
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  172 ( 1329),  selected  172 , name 1xx7_A
# Molecule2: number of CA atoms  188 ( 1523),  selected  188 , name T0470.pdb
# PARAMETERS: 1xx7_A.T0470.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      T       2           -
LGA    -       -      K       3           -
LGA    -       -      Q       4           -
LGA    -       -      E       5           -
LGA    -       -      K       6           -
LGA    -       -      I       7           -
LGA    -       -      E       8           -
LGA    S     1_A      K       9           #
LGA    I     2_A      T      10           -
LGA    -       -      I      11           -
LGA    D     3_A      T      12           #
LGA    L     4_A      F      13          4.905
LGA    I     5_A      V      14           #
LGA    L     6_A      K      15           #
LGA    L     7_A      H      16          4.980
LGA    A     8_A      I      17          2.609
LGA    G     9_A      L      18          3.034
LGA    K    10_A      E      19          3.214
LGA    -       -      K      20           -
LGA    -       -      D      21           -
LGA    L    11_A      A      22           #
LGA    K    12_A      S      23          3.565
LGA    R    13_A      G      24          3.957
LGA    I    14_A      -       -           -
LGA    P    15_A      -       -           -
LGA    R    16_A      -       -           -
LGA    M    17_A      -       -           -
LGA    G    18_A      -       -           -
LGA    W    19_A      -       -           -
LGA    L    20_A      -       -           -
LGA    I    21_A      -       -           -
LGA    K    22_A      -       -           -
LGA    G    23_A      -       -           -
LGA    V    24_A      -       -           -
LGA    P    25_A      -       -           -
LGA    N    26_A      -       -           -
LGA    P    27_A      -       -           -
LGA    E    28_A      -       -           -
LGA    S    29_A      H      25          3.748
LGA    V    30_A      D      26          2.690
LGA    A    31_A      W      27          1.619
LGA    D    32_A      Y      28          1.850
LGA    H    33_A      H      29          1.113
LGA    S    34_A      I      30          0.595
LGA    Y    35_A      R      31          0.904
LGA    R    36_A      R      32          0.420
LGA    V    37_A      V      33          0.486
LGA    A    38_A      H      34          0.353
LGA    F    39_A      K      35          1.040
LGA    I    40_A      M      36          0.752
LGA    T    41_A      A      37          0.615
LGA    L    42_A      I      38          1.123
LGA    L    43_A      S      39          1.428
LGA    L    44_A      L      40          1.191
LGA    A    45_A      S      41          1.522
LGA    E    46_A      E      42          2.240
LGA    E    47_A      Q      43          2.994
LGA    L    48_A      E      44          2.489
LGA    K    49_A      -       -           -
LGA    K    50_A      -       -           -
LGA    K    51_A      -       -           -
LGA    G    52_A      -       -           -
LGA    V    53_A      -       -           -
LGA    E    54_A      G      45          2.370
LGA    I    55_A      G      46          1.808
LGA    D    56_A      N      47          1.103
LGA    V    57_A      R      48          1.191
LGA    E    58_A      F      49          1.556
LGA    K    59_A      I      50          1.246
LGA    A    60_A      I      51          0.719
LGA    L    61_A      E      52          0.842
LGA    K    62_A      M      53          0.911
LGA    I    63_A      A      54          0.720
LGA    A    64_A      A      55          0.902
LGA    I    65_A      L      56          0.761
LGA    I    66_A      L      57          1.023
LGA    H    67_A      H      58          1.176
LGA    D    68_A      D      59          0.640
LGA    L    69_A      V      60          1.171
LGA    G    70_A      A      61          1.808
LGA    E    71_A      D      62          3.817
LGA    A    72_A      -       -           -
LGA    I    73_A      -       -           -
LGA    I    74_A      -       -           -
LGA    T    75_A      L      65          1.111
LGA    D    76_A      N      66           -
LGA    L    77_A      E      67           -
LGA    P    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    S    80_A      -       -           -
LGA    A    81_A      -       -           -
LGA    Q    82_A      -       -           -
LGA    K    83_A      -       -           -
LGA    Y    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    N    86_A      -       -           -
LGA    K    87_A      -       -           -
LGA    E    88_A      -       -           -
LGA    E    89_A      S      68           #
LGA    A    90_A      E      69          1.449
LGA    E    91_A      -       -           -
LGA    A    92_A      E      70          3.766
LGA    K    93_A      A      71          2.723
LGA    A    94_A      G      72          1.603
LGA    L    95_A      M      73          2.870
LGA    K    96_A      K      74          0.814
LGA    D    97_A      K      75          3.674
LGA    V    98_A      V      76          5.153
LGA    L    99_A      S      77          3.527
LGA    P   100_A      D      78          2.687
LGA    -       -      W      79           -
LGA    E   101_A      L      80          3.104
LGA    -       -      E      81           -
LGA    -       -      E      82           -
LGA    -       -      L      83           -
LGA    -       -      H      84           -
LGA    -       -      V      85           -
LGA    -       -      E      86           -
LGA    -       -      E      87           -
LGA    -       -      E      88           -
LGA    -       -      E      89           -
LGA    Y   102_A      S      90          4.934
LGA    T   103_A      K      91          5.845
LGA    E   104_A      H      92          3.913
LGA    L   105_A      V      93          1.453
LGA    F   106_A      L      94          2.933
LGA    E   107_A      H      95          1.783
LGA    E   108_A      I      96          1.869
LGA    Y   109_A      I      97          3.693
LGA    S   110_A      A      98          3.177
LGA    K   111_A      N      99          3.617
LGA    A   112_A      M     100           #
LGA    L   113_A      -       -           -
LGA    T   114_A      S     112          0.736
LGA    L   115_A      I     113          0.322
LGA    E   116_A      E     114          0.645
LGA    G   117_A      G     115          0.385
LGA    Q   118_A      K     116          0.604
LGA    L   119_A      L     117          0.210
LGA    V   120_A      V     118          0.463
LGA    K   121_A      Q     119          0.434
LGA    I   122_A      D     120          0.631
LGA    A   123_A      A     121          0.569
LGA    D   124_A      D     122          0.407
LGA    K   125_A      R     123          0.567
LGA    L   126_A      L     124          0.619
LGA    D   127_A      D     125          1.024
LGA    M   128_A      A     126          1.926
LGA    I   129_A      L     127          2.073
LGA    I   130_A      G     128          3.064
LGA    -       -      A     129           -
LGA    Q   131_A      I     130          2.763
LGA    A   132_A      G     131          1.258
LGA    Y   133_A      I     132          2.393
LGA    E   134_A      A     133          3.582
LGA    Y   135_A      R     134          3.263
LGA    E   136_A      T     135          5.303
LGA    L   137_A      -       -           -
LGA    S   138_A      -       -           -
LGA    G   139_A      -       -           -
LGA    A   140_A      F     136          1.109
LGA    K   141_A      A     137           -
LGA    -       -      Y     138           -
LGA    N   142_A      G     139          5.338
LGA    -       -      G     140           -
LGA    -       -      A     141           -
LGA    -       -      K     142           -
LGA    -       -      G     143           -
LGA    -       -      R     144           -
LGA    -       -      L     145           -
LGA    -       -      M     146           -
LGA    -       -      Y     147           -
LGA    -       -      D     148           -
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    -       -      S     169           -
LGA    -       -      L     170           -
LGA    -       -      N     171           -
LGA    L   143_A      H     172          3.769
LGA    S   144_A      F     173          1.298
LGA    -       -      Y     174           -
LGA    E   145_A      E     175          3.381
LGA    F   146_A      K     176          4.322
LGA    W   147_A      L     177          1.025
LGA    -       -      L     178           -
LGA    N   148_A      K     179          3.344
LGA    A   149_A      L     180          2.801
LGA    L   150_A      K     181          2.584
LGA    E   151_A      D     182          3.193
LGA    D   152_A      L     183          2.556
LGA    L   153_A      M     184          2.107
LGA    E   154_A      -       -           -
LGA    K   155_A      -       -           -
LGA    L   156_A      -       -           -
LGA    E   157_A      N     185          4.409
LGA    I   158_A      T     186          2.349
LGA    S   159_A      -       -           -
LGA    R   160_A      -       -           -
LGA    Y   161_A      N     187          1.987
LGA    L   162_A      A     188          2.443
LGA    -       -      A     189           -
LGA    R   163_A      K     190          3.456
LGA    E   164_A      Q     191          2.373
LGA    I   165_A      E     192          1.297
LGA    I   166_A      A     193          1.933
LGA    E   167_A      E     194          1.206
LGA    E   168_A      V     195          0.191
LGA    V   169_A      R     196          1.367
LGA    R   170_A      H     197          1.514
LGA    R   171_A      R     198          0.667
LGA    L   172_A      Y     199          1.189
LGA    -       -      M     200           -
LGA    -       -      E     201           -
LGA    -       -      Q     202           -
LGA    -       -      F     203           -
LGA    -       -      I     204           -
LGA    -       -      E     205           -
LGA    -       -      Q     206           -
LGA    -       -      F     207           -
LGA    -       -      M     208           -
LGA    -       -      K     209           -
LGA    -       -      E     210           -
LGA    -       -      W     211           -
LGA    -       -      N     212           -
LGA    -       -      A     213           -
LGA    -       -      Q     214           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  172  188    5.0    117    2.47    17.95     41.539     4.546

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.620256 * X  +  -0.411333 * Y  +  -0.667898 * Z  +  29.743286
  Y_new =  -0.349955 * X  +  -0.907150 * Y  +   0.233688 * Z  + 134.316742
  Z_new =  -0.702007 * X  +   0.088788 * Y  +  -0.706614 * Z  + 154.913559 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.016595   -0.124997  [ DEG:   172.8382     -7.1618 ]
  Theta =   0.778212    2.363381  [ DEG:    44.5883    135.4117 ]
  Phi   =  -0.513688    2.627905  [ DEG:   -29.4321    150.5679 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xx7_A                                        
REMARK     2: T0470.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xx7_A.T0470.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  172  188   5.0  117   2.47   17.95  41.539
REMARK  ---------------------------------------------------------- 
MOLECULE 1xx7_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   04-NOV-04   1XX7              
TITLE     CONSERVED HYPOTHETICAL PROTEIN FROM PYROCOCCUS FURIOSUS PFU-          
TITLE    2 403030-001                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: OXETANOCIN-LIKE PROTEIN;                                   
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS FURIOSUS;                            
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    PSI, SECSG, PROTEIN STRUCTURE INITIATIVE, SOUTHEAST                   
KEYWDS   2 COLLABORATORY FOR STRUCTURAL GENOMICS, PYROCOCCUS FURIOSUS,          
KEYWDS   3 CONSERVED HYPOTHETICAL PROTEIN, HYPERTHERMOPHILE                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    L.CHEN,W.TEMPEL,J.HABEL,W.ZHOU,D.NGUYEN,S.-H.CHANG,D.LEE,L.-          
AUTHOR   2 L.C.KELLEY,B.D.DILLARD,Z.-J.LIU,S.BRIDGER,J.C.ENEH,                  
AUTHOR   3 R.C.HOPKINS,F.E.JENNEY JR,H.-S.LEE,T.LI,F.L.POOLE II,C.SHAH,         
AUTHOR   4 F.J.SUGAR,M.W.W.ADAMS,W.B.ARENDALL III,J.S.RICHARDSON,               
AUTHOR   5 D.C.RICHARDSON,J.P.ROSE,B.-C.WANG,SOUTHEAST COLLABORATORY            
AUTHOR   6 FOR STRUCTURAL GENOMICS (SECSG)                                      
REVDAT   2   01-FEB-05 1XX7    1       AUTHOR                                   
REVDAT   1   28-DEC-04 1XX7    0                                                
JRNL        AUTH   L.CHEN,W.TEMPEL,J.HABEL,W.ZHOU,D.NGUYEN,S.-H.CHANG,          
JRNL        AUTH 2 D.LEE,L.-L.C.KELLEY,B.D.DILLARD,Z.-J.LIU,S.BRIDGER,          
JRNL        AUTH 3 J.C.ENEH,R.C.HOPKINS,F.E.JENNEY JR,H.-S.LEE,T.LI,            
JRNL        AUTH 4 F.L.POOLE II,C.SHAH,F.J.SUGAR,M.W.W.ADAMS,                   
JRNL        AUTH 5 W.B.ARENDALL III,J.S.RICHARDSON,D.C.RICHARDSON,              
JRNL        AUTH 6 J.P.ROSE,B.-C.WANG,                                          
JRNL        AUTH 7 SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS              
JRNL        TITL   CONSERVED HYPOTHETICAL PROTEIN FROM PYROCOCCUS               
JRNL        TITL 2 FURIOSUS PFU-403030-001                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.26 ANGSTROMS.                                          
DBREF  1XX7 A    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 B    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 C    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 D    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 E    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 F    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
SEQRES   1 A  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 A  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 A  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 A  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 A  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 A  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 A  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 A  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 A  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 A  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 A  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 A  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 A  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 A  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 A  184  ASP HIS                                                      
SEQRES   1 B  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 B  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 B  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 B  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 B  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 B  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 B  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 B  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 B  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 B  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 B  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 B  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 B  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 B  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 B  184  ASP HIS                                                      
SEQRES   1 C  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 C  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 C  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 C  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 C  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 C  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 C  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 C  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 C  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 C  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 C  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 C  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 C  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 C  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 C  184  ASP HIS                                                      
SEQRES   1 D  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 D  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 D  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 D  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 D  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 D  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 D  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 D  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 D  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 D  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 D  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 D  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 D  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 D  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 D  184  ASP HIS                                                      
SEQRES   1 E  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 E  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 E  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 E  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 E  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 E  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 E  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 E  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 E  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 E  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 E  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 E  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 E  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 E  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 E  184  ASP HIS                                                      
SEQRES   1 F  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 F  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 F  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 F  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 F  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 F  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 F  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 F  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 F  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 F  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 F  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 F  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 F  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 F  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 F  184  ASP HIS                                                      
HET     NI  A 201       1                                                       
HET     NI  B 201       1                                                       
HET     NI  C 201       1                                                       
HET     NI  D 201       1                                                       
HET     NI  E 201       1                                                       
HET     NI  F 201       1                                                       
HET    UNX   2001       1                                                       
HET    UNX   2002       1                                                       
HET    UNX   2003       1                                                       
HET    UNX   2004       1                                                       
HET    UNX   2005       1                                                       
HET    UNX   2006       1                                                       
HET    UNX   2007       1                                                       
HET    UNX   2008       1                                                       
HET    UNX   2009       1                                                       
HET    UNX   2010       1                                                       
HET    UNX   2011       1                                                       
HET    UNX   2012       1                                                       
HET    UNX   2013       1                                                       
HET    UNX   2014       1                                                       
HET    UNX   2015       1                                                       
HET    UNX   2016       1                                                       
HET    UNX   2017       1                                                       
HET    UNX   2018       1                                                       
HET    UNX   2019       1                                                       
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     UNX UNKNOWN ATOM OR ION                                              
FORMUL   7   NI    6(NI 2+)                                                     
FORMUL  13  UNX    19(X1)                                                       
FORMUL  32  HOH   *69(H2 O)                                                     
CRYST1   98.073  111.335  125.984  90.00  90.00  90.00 P 21 21 21   24          
ATOM      1  N   SER A   1      61.547  40.978  89.345  1.00 45.35           N  
ATOM      2  CA  SER A   1      62.071  42.384  89.196  1.00 42.85           C  
ATOM      3  C   SER A   1      61.134  43.354  89.928  1.00 39.71           C  
ATOM      4  O   SER A   1      59.916  43.438  89.608  1.00 33.49           O  
ATOM      5  CB  SER A   1      62.215  42.763  87.711  1.00 46.38           C  
ATOM      6  OG  SER A   1      63.105  43.853  87.500  1.00 49.22           O  
ATOM      7  N   ILE A   2      61.710  44.045  90.922  1.00 35.65           N  
ATOM      8  CA  ILE A   2      61.038  45.079  91.706  1.00 36.39           C  
ATOM      9  C   ILE A   2      60.552  46.254  90.833  1.00 32.94           C  
ATOM     10  O   ILE A   2      59.541  46.874  91.161  1.00 30.82           O  
ATOM     11  CB  ILE A   2      61.934  45.546  92.939  1.00 38.15           C  
ATOM     12  CG1 ILE A   2      61.826  44.558  94.089  1.00 40.60           C  
ATOM     13  CG2 ILE A   2      61.504  46.864  93.531  1.00 39.99           C  
ATOM     14  N   ASP A   3      61.239  46.505  89.714  1.00 30.26           N  
ATOM     15  CA  ASP A   3      60.889  47.583  88.776  1.00 31.44           C  
ATOM     16  C   ASP A   3      59.558  47.359  88.117  1.00 28.27           C  
ATOM     17  O   ASP A   3      58.772  48.293  87.990  1.00 30.07           O  
ATOM     18  CB  ASP A   3      61.968  47.792  87.684  1.00 33.24           C  
ATOM     19  CG  ASP A   3      63.188  48.600  88.189  1.00 39.36           C  
ATOM     20  OD1 ASP A   3      63.166  49.137  89.327  1.00 41.59           O  
ATOM     21  OD2 ASP A   3      64.188  48.712  87.435  1.00 45.86           O  
ATOM     22  N   LEU A   4      59.304  46.132  87.672  1.00 27.11           N  
ATOM     23  CA  LEU A   4      58.006  45.782  87.152  1.00 27.18           C  
ATOM     24  C   LEU A   4      56.906  46.039  88.195  1.00 25.81           C  
ATOM     25  O   LEU A   4      55.847  46.531  87.883  1.00 24.38           O  
ATOM     26  CB  LEU A   4      57.987  44.336  86.706  1.00 29.67           C  
ATOM     27  CG  LEU A   4      58.711  44.114  85.366  1.00 33.06           C  
ATOM     28  CD1 LEU A   4      58.800  42.621  85.082  1.00 32.86           C  
ATOM     29  CD2 LEU A   4      57.976  44.836  84.209  1.00 32.33           C  
ATOM     30  N   ILE A   5      57.196  45.724  89.439  1.00 22.13           N  
ATOM     31  CA  ILE A   5      56.200  45.747  90.481  1.00 24.40           C  
ATOM     32  C   ILE A   5      55.924  47.198  90.879  1.00 21.36           C  
ATOM     33  O   ILE A   5      54.788  47.565  91.087  1.00 18.69           O  
ATOM     34  CB  ILE A   5      56.657  44.860  91.678  1.00 22.58           C  
ATOM     35  CG1 ILE A   5      56.545  43.400  91.268  1.00 25.61           C  
ATOM     36  CG2 ILE A   5      55.829  45.101  92.869  1.00 24.53           C  
ATOM     37  CD1 ILE A   5      57.239  42.436  92.157  1.00 25.42           C  
ATOM     38  N   LEU A   6      56.985  47.989  90.966  1.00 24.30           N  
ATOM     39  CA  LEU A   6      56.921  49.446  91.121  1.00 26.75           C  
ATOM     40  C   LEU A   6      56.136  50.091  89.981  1.00 25.23           C  
ATOM     41  O   LEU A   6      55.313  50.985  90.205  1.00 26.64           O  
ATOM     42  CB  LEU A   6      58.344  50.027  91.201  1.00 25.65           C  
ATOM     43  CG  LEU A   6      59.066  49.725  92.522  1.00 28.51           C  
ATOM     44  CD1 LEU A   6      60.554  50.129  92.447  1.00 29.67           C  
ATOM     45  CD2 LEU A   6      58.420  50.422  93.692  1.00 27.29           C  
ATOM     46  N   LEU A   7      56.372  49.617  88.767  1.00 25.91           N  
ATOM     47  CA  LEU A   7      55.576  50.042  87.623  1.00 25.92           C  
ATOM     48  C   LEU A   7      54.076  49.799  87.794  1.00 25.27           C  
ATOM     49  O   LEU A   7      53.303  50.705  87.607  1.00 19.62           O  
ATOM     50  CB  LEU A   7      56.056  49.366  86.354  1.00 32.19           C  
ATOM     51  CG  LEU A   7      55.477  50.047  85.106  1.00 36.94           C  
ATOM     52  CD1 LEU A   7      56.239  51.363  84.847  1.00 41.28           C  
ATOM     53  CD2 LEU A   7      55.563  49.186  83.949  1.00 38.86           C  
ATOM     54  N   ALA A   8      53.674  48.561  88.092  1.00 23.40           N  
ATOM     55  CA  ALA A   8      52.282  48.252  88.422  1.00 24.83           C  
ATOM     56  C   ALA A   8      51.710  49.072  89.608  1.00 23.28           C  
ATOM     57  O   ALA A   8      50.516  49.372  89.654  1.00 24.88           O  
ATOM     58  CB  ALA A   8      52.120  46.705  88.726  1.00 21.39           C  
ATOM     59  N   GLY A   9      52.539  49.373  90.590  1.00 20.39           N  
ATOM     60  CA  GLY A   9      52.142  50.270  91.671  1.00 19.09           C  
ATOM     61  C   GLY A   9      51.722  51.665  91.201  1.00 14.16           C  
ATOM     62  O   GLY A   9      50.899  52.298  91.818  1.00 19.61           O  
ATOM     63  N   LYS A  10      52.280  52.133  90.102  1.00 14.86           N  
ATOM     64  CA  LYS A  10      51.850  53.392  89.500  1.00 19.44           C  
ATOM     65  C   LYS A  10      50.339  53.439  89.145  1.00 18.26           C  
ATOM     66  O   LYS A  10      49.667  54.484  89.316  1.00 16.98           O  
ATOM     67  CB  LYS A  10      52.705  53.690  88.297  1.00 17.96           C  
ATOM     68  CG  LYS A  10      54.100  54.124  88.601  1.00 20.20           C  
ATOM     69  CD  LYS A  10      54.789  54.430  87.245  1.00 24.38           C  
ATOM     70  CE  LYS A  10      56.267  54.861  87.292  1.00 28.27           C  
ATOM     71  NZ  LYS A  10      56.580  55.349  88.630  1.00 31.65           N  
ATOM     72  N   LEU A  11      49.804  52.286  88.737  1.00 18.54           N  
ATOM     73  CA  LEU A  11      48.372  52.146  88.483  1.00 16.90           C  
ATOM     74  C   LEU A  11      47.523  52.331  89.688  1.00 16.20           C  
ATOM     75  O   LEU A  11      46.331  52.575  89.531  1.00 13.03           O  
ATOM     76  CB  LEU A  11      48.024  50.785  87.877  1.00 18.97           C  
ATOM     77  CG  LEU A  11      48.639  50.400  86.537  1.00 21.58           C  
ATOM     78  CD1 LEU A  11      47.890  49.172  85.963  1.00 21.71           C  
ATOM     79  CD2 LEU A  11      48.615  51.516  85.582  1.00 21.39           C  
ATOM     80  N   LYS A  12      48.104  52.208  90.902  1.00 15.41           N  
ATOM     81  CA  LYS A  12      47.323  52.458  92.119  1.00 15.02           C  
ATOM     82  C   LYS A  12      47.014  53.937  92.293  1.00 11.28           C  
ATOM     83  O   LYS A  12      46.075  54.295  92.987  1.00 14.80           O  
ATOM     84  CB  LYS A  12      47.999  51.949  93.379  1.00 14.53           C  
ATOM     85  CG  LYS A  12      48.207  50.427  93.418  1.00 12.92           C  
ATOM     86  CD  LYS A  12      48.791  50.045  94.771  1.00 14.45           C  
ATOM     87  CE  LYS A  12      49.303  48.598  94.864  1.00 14.14           C  
ATOM     88  NZ  LYS A  12      49.589  48.259  96.320  1.00 12.44           N  
ATOM     89  N   ARG A  13      47.816  54.767  91.679  1.00 14.93           N  
ATOM     90  CA  ARG A  13      47.759  56.212  91.874  1.00 21.48           C  
ATOM     91  C   ARG A  13      47.235  56.966  90.654  1.00 21.04           C  
ATOM     92  O   ARG A  13      46.668  58.020  90.821  1.00 25.12           O  
ATOM     93  CB  ARG A  13      49.132  56.722  92.249  1.00 21.79           C  
ATOM     94  CG  ARG A  13      49.594  56.025  93.471  1.00 26.05           C  
ATOM     95  CD  ARG A  13      50.782  56.645  94.049  1.00 28.11           C  
ATOM     96  NE  ARG A  13      51.929  56.608  93.171  1.00 25.38           N  
ATOM     97  CZ  ARG A  13      52.765  55.587  93.032  1.00 31.75           C  
ATOM     98  NH1 ARG A  13      52.568  54.433  93.643  1.00 35.26           N  
ATOM     99  NH2 ARG A  13      53.799  55.710  92.218  1.00 37.76           N  
ATOM    100  N   ILE A  14      47.419  56.401  89.461  1.00 16.68           N  
ATOM    101  CA  ILE A  14      46.967  57.025  88.219  1.00 23.73           C  
ATOM    102  C   ILE A  14      45.423  56.976  88.124  1.00 20.07           C  
ATOM    103  O   ILE A  14      44.821  55.911  88.258  1.00 24.01           O  
ATOM    104  CB  ILE A  14      47.711  56.378  86.982  1.00 27.46           C  
ATOM    105  CG1 ILE A  14      49.177  56.817  86.999  1.00 26.15           C  
ATOM    106  CG2 ILE A  14      47.087  56.803  85.656  1.00 30.83           C  
ATOM    107  CD1 ILE A  14      50.139  55.934  86.158  1.00 25.18           C  
ATOM    108  N   PRO A  15      44.772  58.155  88.026  1.00 22.29           N  
ATOM    109  CA  PRO A  15      43.310  58.148  87.943  1.00 19.71           C  
ATOM    110  C   PRO A  15      42.750  57.752  86.552  1.00 17.82           C  
ATOM    111  O   PRO A  15      43.380  57.900  85.486  1.00 13.45           O  
ATOM    112  CB  PRO A  15      42.900  59.589  88.345  1.00 17.74           C  
ATOM    113  CG  PRO A  15      44.076  60.396  88.137  1.00 22.50           C  
ATOM    114  CD  PRO A  15      45.311  59.537  88.046  1.00 23.24           C  
ATOM    115  N   ARG A  16      41.590  57.151  86.620  1.00 18.49           N  
ATOM    116  CA  ARG A  16      40.757  56.995  85.476  1.00 20.38           C  
ATOM    117  C   ARG A  16      40.207  58.430  85.105  1.00 18.71           C  
ATOM    118  O   ARG A  16      39.308  58.989  85.806  1.00 16.54           O  
ATOM    119  CB  ARG A  16      39.664  56.001  85.856  1.00 15.60           C  
ATOM    120  CG  ARG A  16      40.213  54.596  86.056  1.00 16.81           C  
ATOM    121  CD  ARG A  16      40.220  53.817  84.725  1.00 17.02           C  
ATOM    122  NE  ARG A  16      38.844  53.460  84.339  1.00 19.02           N  
ATOM    123  CZ  ARG A  16      38.446  53.062  83.115  1.00 20.42           C  
ATOM    124  NH1 ARG A  16      37.169  52.760  82.897  1.00 18.37           N  
ATOM    125  NH2 ARG A  16      39.308  52.981  82.108  1.00 21.81           N  
ATOM    126  N   MET A  17      40.766  58.991  84.028  1.00 20.74           N  
ATOM    127  CA  MET A  17      40.638  60.434  83.704  1.00 25.22           C  
ATOM    128  C   MET A  17      39.248  60.861  83.259  1.00 20.54           C  
ATOM    129  O   MET A  17      38.810  61.954  83.590  1.00 21.18           O  
ATOM    130  CB  MET A  17      41.684  60.871  82.657  1.00 28.01           C  
ATOM    131  CG  MET A  17      43.084  61.052  83.232  1.00 34.93           C  
ATOM    132  SD  MET A  17      43.329  62.460  84.409  1.00 40.07           S  
ATOM    133  CE  MET A  17      42.234  63.623  83.776  1.00 32.60           C  
ATOM    134  N   GLY A  18      38.562  59.994  82.536  1.00 23.45           N  
ATOM    135  CA  GLY A  18      37.171  60.221  82.144  1.00 22.49           C  
ATOM    136  C   GLY A  18      36.317  60.697  83.326  1.00 23.32           C  
ATOM    137  O   GLY A  18      35.683  61.747  83.258  1.00 24.17           O  
ATOM    138  N   TRP A  19      36.349  59.958  84.437  1.00 21.05           N  
ATOM    139  CA  TRP A  19      35.583  60.364  85.639  1.00 20.38           C  
ATOM    140  C   TRP A  19      36.052  61.750  86.134  1.00 19.04           C  
ATOM    141  O   TRP A  19      35.251  62.624  86.430  1.00 17.69           O  
ATOM    142  CB  TRP A  19      35.693  59.323  86.776  1.00 17.99           C  
ATOM    143  CG  TRP A  19      35.512  57.870  86.342  1.00 17.24           C  
ATOM    144  CD1 TRP A  19      36.391  56.855  86.541  1.00 15.98           C  
ATOM    145  CD2 TRP A  19      34.385  57.293  85.627  1.00 19.46           C  
ATOM    146  NE1 TRP A  19      35.906  55.698  85.997  1.00 20.35           N  
ATOM    147  CE2 TRP A  19      34.668  55.922  85.453  1.00 17.31           C  
ATOM    148  CE3 TRP A  19      33.166  57.807  85.128  1.00 18.88           C  
ATOM    149  CZ2 TRP A  19      33.789  55.039  84.784  1.00 19.51           C  
ATOM    150  CZ3 TRP A  19      32.269  56.914  84.455  1.00 18.64           C  
ATOM    151  CH2 TRP A  19      32.604  55.556  84.276  1.00 18.65           C  
ATOM    152  N   LEU A  20      37.361  61.923  86.194  1.00 17.39           N  
ATOM    153  CA  LEU A  20      37.956  63.025  86.884  1.00 21.46           C  
ATOM    154  C   LEU A  20      37.614  64.338  86.201  1.00 22.08           C  
ATOM    155  O   LEU A  20      37.235  65.331  86.851  1.00 19.81           O  
ATOM    156  CB  LEU A  20      39.462  62.776  86.967  1.00 24.72           C  
ATOM    157  CG  LEU A  20      40.444  63.745  87.592  1.00 27.58           C  
ATOM    158  CD1 LEU A  20      41.786  63.077  87.898  1.00 24.69           C  
ATOM    159  CD2 LEU A  20      40.637  64.936  86.644  1.00 30.58           C  
ATOM    160  N   ILE A  21      37.696  64.305  84.886  1.00 24.40           N  
ATOM    161  CA  ILE A  21      37.355  65.425  84.054  1.00 28.46           C  
ATOM    162  C   ILE A  21      35.841  65.763  84.075  1.00 28.01           C  
ATOM    163  O   ILE A  21      35.481  66.914  83.925  1.00 27.15           O  
ATOM    164  CB  ILE A  21      37.872  65.193  82.613  1.00 32.64           C  
ATOM    165  CG1 ILE A  21      39.414  65.172  82.641  1.00 33.07           C  
ATOM    166  CG2 ILE A  21      37.400  66.318  81.699  1.00 36.26           C  
ATOM    167  CD1 ILE A  21      40.062  64.706  81.425  1.00 34.26           C  
ATOM    168  N   LYS A  22      34.992  64.749  84.225  1.00 24.45           N  
ATOM    169  CA  LYS A  22      33.605  64.928  84.479  1.00 22.43           C  
ATOM    170  C   LYS A  22      33.262  65.581  85.835  1.00 23.70           C  
ATOM    171  O   LYS A  22      32.151  66.004  86.018  1.00 21.38           O  
ATOM    172  CB  LYS A  22      32.867  63.599  84.390  1.00 21.20           C  
ATOM    173  CG  LYS A  22      32.736  63.066  83.002  1.00 24.40           C  
ATOM    174  CD  LYS A  22      31.678  63.831  82.260  1.00 26.16           C  
ATOM    175  CE  LYS A  22      31.563  63.414  80.834  1.00 28.50           C  
ATOM    176  NZ  LYS A  22      30.232  63.959  80.341  1.00 29.96           N  
ATOM    177  N   GLY A  23      34.184  65.622  86.785  1.00 21.29           N  
ATOM    178  CA  GLY A  23      33.890  66.178  88.098  1.00 15.42           C  
ATOM    179  C   GLY A  23      33.581  65.150  89.157  1.00 14.68           C  
ATOM    180  O   GLY A  23      33.190  65.496  90.270  1.00 14.72           O  
ATOM    181  N   VAL A  24      33.709  63.874  88.824  1.00 16.10           N  
ATOM    182  CA  VAL A  24      33.568  62.843  89.840  1.00 16.93           C  
ATOM    183  C   VAL A  24      34.707  63.070  90.840  1.00 13.17           C  
ATOM    184  O   VAL A  24      35.868  63.114  90.447  1.00 18.71           O  
ATOM    185  CB  VAL A  24      33.645  61.439  89.276  1.00 19.57           C  
ATOM    186  CG1 VAL A  24      33.690  60.379  90.464  1.00 19.81           C  
ATOM    187  CG2 VAL A  24      32.502  61.186  88.332  1.00 18.65           C  
ATOM    188  N   PRO A  25      34.356  63.260  92.129  1.00 21.33           N  
ATOM    189  CA  PRO A  25      35.286  63.777  93.148  1.00 25.47           C  
ATOM    190  C   PRO A  25      36.483  62.927  93.623  1.00 31.02           C  
ATOM    191  O   PRO A  25      37.565  63.496  93.952  1.00 32.92           O  
ATOM    192  CB  PRO A  25      34.356  64.128  94.346  1.00 27.25           C  
ATOM    193  CG  PRO A  25      33.185  63.324  94.199  1.00 25.12           C  
ATOM    194  CD  PRO A  25      32.972  63.120  92.667  1.00 20.03           C  
ATOM    195  N   ASN A  26      36.320  61.620  93.707  1.00 29.00           N  
ATOM    196  CA  ASN A  26      37.477  60.808  94.109  1.00 31.93           C  
ATOM    197  C   ASN A  26      37.511  59.619  93.192  1.00 24.96           C  
ATOM    198  O   ASN A  26      37.176  58.540  93.581  1.00 22.25           O  
ATOM    199  CB  ASN A  26      37.409  60.386  95.598  1.00 38.14           C  
ATOM    200  CG  ASN A  26      37.835  61.537  96.572  1.00 43.75           C  
ATOM    201  OD1 ASN A  26      37.066  61.944  97.456  1.00 47.47           O  
ATOM    202  ND2 ASN A  26      39.040  62.064  96.382  1.00 44.79           N  
ATOM    203  N   PRO A  27      37.881  59.850  91.932  1.00 19.62           N  
ATOM    204  CA  PRO A  27      37.670  58.844  90.942  1.00 19.88           C  
ATOM    205  C   PRO A  27      38.581  57.592  91.208  1.00 22.26           C  
ATOM    206  O   PRO A  27      39.662  57.745  91.757  1.00 16.15           O  
ATOM    207  CB  PRO A  27      38.060  59.562  89.654  1.00 20.90           C  
ATOM    208  CG  PRO A  27      39.046  60.566  90.087  1.00 23.24           C  
ATOM    209  CD  PRO A  27      38.517  61.059  91.376  1.00 19.89           C  
ATOM    210  N   GLU A  28      38.105  56.400  90.839  1.00 20.15           N  
ATOM    211  CA  GLU A  28      38.914  55.156  90.830  1.00 16.22           C  
ATOM    212  C   GLU A  28      40.240  55.307  90.090  1.00 15.77           C  
ATOM    213  O   GLU A  28      40.401  56.111  89.209  1.00 15.32           O  
ATOM    214  CB  GLU A  28      38.127  54.019  90.209  1.00 14.60           C  
ATOM    215  CG  GLU A  28      37.685  54.305  88.743  1.00 17.82           C  
ATOM    216  CD  GLU A  28      37.367  53.073  87.940  1.00 17.76           C  
ATOM    217  OE1 GLU A  28      37.396  51.931  88.495  1.00 17.86           O  
ATOM    218  OE2 GLU A  28      37.053  53.255  86.752  1.00 16.30           O  
ATOM    219  N   SER A  29      41.200  54.521  90.509  1.00 17.74           N  
ATOM    220  CA  SER A  29      42.442  54.390  89.838  1.00 16.09           C  
ATOM    221  C   SER A  29      42.357  53.350  88.710  1.00 13.43           C  
ATOM    222  O   SER A  29      41.356  52.597  88.572  1.00 11.38           O  
ATOM    223  CB  SER A  29      43.519  54.018  90.858  1.00 17.98           C  
ATOM    224  OG  SER A  29      43.386  52.670  91.281  1.00 19.30           O  
ATOM    225  N   VAL A  30      43.421  53.308  87.911  1.00 11.65           N  
ATOM    226  CA  VAL A  30      43.518  52.336  86.834  1.00 14.43           C  
ATOM    227  C   VAL A  30      43.630  50.899  87.397  1.00 15.45           C  
ATOM    228  O   VAL A  30      43.119  49.937  86.795  1.00 17.19           O  
ATOM    229  CB  VAL A  30      44.672  52.666  85.891  1.00 15.87           C  
ATOM    230  CG1 VAL A  30      44.805  51.597  84.793  1.00 17.22           C  
ATOM    231  CG2 VAL A  30      44.452  54.021  85.267  1.00 17.48           C  
ATOM    232  N   ALA A  31      44.274  50.763  88.557  1.00 16.15           N  
ATOM    233  CA  ALA A  31      44.344  49.494  89.244  1.00 17.48           C  
ATOM    234  C   ALA A  31      42.996  49.036  89.791  1.00 16.18           C  
ATOM    235  O   ALA A  31      42.696  47.856  89.739  1.00 17.58           O  
ATOM    236  CB  ALA A  31      45.328  49.572  90.334  1.00 19.25           C  
ATOM    237  N   ASP A  32      42.225  49.960  90.358  1.00 15.91           N  
ATOM    238  CA  ASP A  32      40.838  49.718  90.816  1.00 16.48           C  
ATOM    239  C   ASP A  32      40.017  49.107  89.657  1.00 15.86           C  
ATOM    240  O   ASP A  32      39.335  48.089  89.791  1.00 12.47           O  
ATOM    241  CB  ASP A  32      40.180  51.051  91.236  1.00 19.68           C  
ATOM    242  CG  ASP A  32      40.545  51.504  92.650  1.00 22.13           C  
ATOM    243  OD1 ASP A  32      40.754  50.609  93.547  1.00 20.55           O  
ATOM    244  OD2 ASP A  32      40.626  52.777  92.848  1.00 14.08           O  
ATOM    245  N   HIS A  33      40.091  49.806  88.530  1.00 15.09           N  
ATOM    246  CA  HIS A  33      39.450  49.439  87.313  1.00 13.94           C  
ATOM    247  C   HIS A  33      39.887  48.078  86.827  1.00 14.78           C  
ATOM    248  O   HIS A  33      39.043  47.243  86.532  1.00 11.48           O  
ATOM    249  CB  HIS A  33      39.809  50.478  86.239  1.00 13.16           C  
ATOM    250  CG  HIS A  33      39.518  50.029  84.869  1.00 11.70           C  
ATOM    251  ND1 HIS A  33      38.252  49.689  84.457  1.00 12.42           N  
ATOM    252  CD2 HIS A  33      40.327  49.838  83.799  1.00 15.41           C  
ATOM    253  CE1 HIS A  33      38.281  49.326  83.188  1.00 10.19           C  
ATOM    254  NE2 HIS A  33      39.521  49.422  82.762  1.00 12.35           N  
ATOM    255  N   SER A  34      41.202  47.895  86.738  1.00 14.96           N  
ATOM    256  CA  SER A  34      41.818  46.675  86.242  1.00 18.95           C  
ATOM    257  C   SER A  34      41.580  45.451  87.098  1.00 20.13           C  
ATOM    258  O   SER A  34      41.474  44.325  86.555  1.00 19.82           O  
ATOM    259  CB  SER A  34      43.326  46.852  86.076  1.00 18.22           C  
ATOM    260  OG  SER A  34      43.615  47.796  85.092  1.00 22.67           O  
ATOM    261  N   TYR A  35      41.508  45.660  88.408  1.00 18.76           N  
ATOM    262  CA  TYR A  35      41.046  44.632  89.325  1.00 17.19           C  
ATOM    263  C   TYR A  35      39.666  44.080  88.962  1.00 20.23           C  
ATOM    264  O   TYR A  35      39.475  42.834  88.898  1.00 16.40           O  
ATOM    265  CB  TYR A  35      40.985  45.107  90.786  1.00 17.34           C  
ATOM    266  CG  TYR A  35      40.318  44.038  91.582  1.00 15.53           C  
ATOM    267  CD1 TYR A  35      40.985  42.829  91.827  1.00 18.39           C  
ATOM    268  CD2 TYR A  35      39.023  44.142  91.954  1.00 12.34           C  
ATOM    269  CE1 TYR A  35      40.363  41.787  92.480  1.00 17.04           C  
ATOM    270  CE2 TYR A  35      38.375  43.086  92.619  1.00 12.97           C  
ATOM    271  CZ  TYR A  35      39.076  41.915  92.867  1.00 16.90           C  
ATOM    272  OH  TYR A  35      38.490  40.855  93.486  1.00 18.23           O  
ATOM    273  N   ARG A  36      38.674  44.968  88.808  1.00 19.79           N  
ATOM    274  CA  ARG A  36      37.299  44.486  88.530  1.00 16.96           C  
ATOM    275  C   ARG A  36      37.148  43.938  87.110  1.00 17.48           C  
ATOM    276  O   ARG A  36      36.315  43.040  86.870  1.00 21.49           O  
ATOM    277  CB  ARG A  36      36.202  45.502  88.839  1.00 15.03           C  
ATOM    278  CG  ARG A  36      34.867  44.808  89.038  1.00 15.08           C  
ATOM    279  CD  ARG A  36      33.801  45.644  89.651  1.00 13.34           C  
ATOM    280  NE  ARG A  36      33.428  46.740  88.778  1.00 16.30           N  
ATOM    281  CZ  ARG A  36      32.465  47.619  89.032  1.00 14.82           C  
ATOM    282  NH1 ARG A  36      31.689  47.483  90.098  1.00 17.65           N  
ATOM    283  NH2 ARG A  36      32.245  48.599  88.177  1.00 20.05           N  
ATOM    284  N   VAL A  37      37.950  44.442  86.184  1.00 15.28           N  
ATOM    285  CA  VAL A  37      38.013  43.856  84.826  1.00 20.20           C  
ATOM    286  C   VAL A  37      38.459  42.344  84.902  1.00 21.05           C  
ATOM    287  O   VAL A  37      37.842  41.487  84.252  1.00 19.25           O  
ATOM    288  CB  VAL A  37      38.946  44.670  83.861  1.00 17.09           C  
ATOM    289  CG1 VAL A  37      39.167  43.940  82.536  1.00 20.77           C  
ATOM    290  CG2 VAL A  37      38.355  46.029  83.588  1.00 21.01           C  
ATOM    291  N   ALA A  38      39.523  42.066  85.685  1.00 17.76           N  
ATOM    292  CA  ALA A  38      39.986  40.709  85.946  1.00 19.10           C  
ATOM    293  C   ALA A  38      38.887  39.900  86.588  1.00 21.36           C  
ATOM    294  O   ALA A  38      38.568  38.785  86.106  1.00 17.11           O  
ATOM    295  CB  ALA A  38      41.237  40.699  86.817  1.00 18.07           C  
ATOM    296  N   PHE A  39      38.250  40.486  87.625  1.00 20.55           N  
ATOM    297  CA  PHE A  39      37.106  39.846  88.252  1.00 18.69           C  
ATOM    298  C   PHE A  39      35.958  39.514  87.275  1.00 19.06           C  
ATOM    299  O   PHE A  39      35.360  38.436  87.348  1.00 21.02           O  
ATOM    300  CB  PHE A  39      36.572  40.651  89.450  1.00 19.67           C  
ATOM    301  CG  PHE A  39      35.391  40.023  90.099  1.00 23.21           C  
ATOM    302  CD1 PHE A  39      35.545  39.002  90.990  1.00 26.69           C  
ATOM    303  CD2 PHE A  39      34.103  40.402  89.762  1.00 22.28           C  
ATOM    304  CE1 PHE A  39      34.411  38.385  91.574  1.00 26.30           C  
ATOM    305  CE2 PHE A  39      33.007  39.799  90.352  1.00 25.45           C  
ATOM    306  CZ  PHE A  39      33.169  38.799  91.270  1.00 20.99           C  
ATOM    307  N   ILE A  40      35.588  40.476  86.440  1.00 21.61           N  
ATOM    308  CA  ILE A  40      34.450  40.304  85.562  1.00 19.79           C  
ATOM    309  C   ILE A  40      34.810  39.257  84.506  1.00 19.47           C  
ATOM    310  O   ILE A  40      33.973  38.428  84.148  1.00 19.93           O  
ATOM    311  CB  ILE A  40      34.041  41.634  84.864  1.00 19.54           C  
ATOM    312  CG1 ILE A  40      33.419  42.597  85.867  1.00 20.72           C  
ATOM    313  CG2 ILE A  40      33.066  41.367  83.669  1.00 14.17           C  
ATOM    314  CD1 ILE A  40      33.381  44.007  85.396  1.00 20.62           C  
ATOM    315  N   THR A  41      36.048  39.311  84.028  1.00 19.41           N  
ATOM    316  CA  THR A  41      36.565  38.336  83.050  1.00 23.05           C  
ATOM    317  C   THR A  41      36.395  36.879  83.554  1.00 23.87           C  
ATOM    318  O   THR A  41      35.913  36.012  82.822  1.00 22.07           O  
ATOM    319  CB  THR A  41      38.068  38.627  82.684  1.00 19.52           C  
ATOM    320  OG1 THR A  41      38.182  39.895  82.039  1.00 20.14           O  
ATOM    321  CG2 THR A  41      38.636  37.541  81.771  1.00 19.99           C  
ATOM    322  N   LEU A  42      36.812  36.643  84.804  1.00 26.94           N  
ATOM    323  CA  LEU A  42      36.623  35.383  85.502  1.00 25.85           C  
ATOM    324  C   LEU A  42      35.163  34.968  85.543  1.00 27.50           C  
ATOM    325  O   LEU A  42      34.820  33.858  85.159  1.00 28.85           O  
ATOM    326  CB  LEU A  42      37.155  35.506  86.919  1.00 30.04           C  
ATOM    327  CG  LEU A  42      37.082  34.286  87.848  1.00 33.06           C  
ATOM    328  CD1 LEU A  42      37.833  33.120  87.236  1.00 37.37           C  
ATOM    329  CD2 LEU A  42      37.693  34.649  89.159  1.00 35.01           C  
ATOM    330  N   LEU A  43      34.319  35.866  86.025  1.00 25.76           N  
ATOM    331  CA  LEU A  43      32.886  35.654  86.085  1.00 31.16           C  
ATOM    332  C   LEU A  43      32.279  35.319  84.698  1.00 30.76           C  
ATOM    333  O   LEU A  43      31.532  34.348  84.551  1.00 27.60           O  
ATOM    334  CB  LEU A  43      32.200  36.907  86.663  1.00 34.70           C  
ATOM    335  CG  LEU A  43      30.979  36.618  87.519  1.00 39.44           C  
ATOM    336  CD1 LEU A  43      31.394  35.995  88.911  1.00 41.91           C  
ATOM    337  CD2 LEU A  43      30.106  37.878  87.709  1.00 38.64           C  
ATOM    338  N   LEU A  44      32.598  36.121  83.688  1.00 29.75           N  
ATOM    339  CA  LEU A  44      32.063  35.879  82.350  1.00 28.81           C  
ATOM    340  C   LEU A  44      32.605  34.566  81.758  1.00 27.32           C  
ATOM    341  O   LEU A  44      31.838  33.795  81.210  1.00 26.97           O  
ATOM    342  CB  LEU A  44      32.311  37.064  81.413  1.00 28.09           C  
ATOM    343  CG  LEU A  44      31.732  38.457  81.784  1.00 30.18           C  
ATOM    344  CD1 LEU A  44      32.287  39.506  80.855  1.00 30.88           C  
ATOM    345  CD2 LEU A  44      30.272  38.513  81.756  1.00 30.88           C  
ATOM    346  N   ALA A  45      33.912  34.325  81.871  1.00 26.77           N  
ATOM    347  CA  ALA A  45      34.503  33.045  81.476  1.00 26.40           C  
ATOM    348  C   ALA A  45      33.685  31.876  82.048  1.00 30.05           C  
ATOM    349  O   ALA A  45      33.342  30.942  81.321  1.00 28.65           O  
ATOM    350  CB  ALA A  45      35.958  32.957  81.938  1.00 27.71           C  
ATOM    351  N   GLU A  46      33.321  31.953  83.327  1.00 31.53           N  
ATOM    352  CA  GLU A  46      32.526  30.876  83.945  1.00 35.58           C  
ATOM    353  C   GLU A  46      31.083  30.759  83.458  1.00 34.59           C  
ATOM    354  O   GLU A  46      30.622  29.652  83.191  1.00 34.29           O  
ATOM    355  CB  GLU A  46      32.635  30.914  85.469  1.00 35.87           C  
ATOM    356  CG  GLU A  46      34.064  30.524  85.924  1.00 40.79           C  
ATOM    357  CD  GLU A  46      34.608  29.199  85.203  1.00 47.34           C  
ATOM    358  OE1 GLU A  46      34.073  28.107  85.587  1.00 45.03           O  
ATOM    359  OE2 GLU A  46      35.536  29.280  84.267  1.00 41.08           O  
ATOM    360  N   GLU A  47      30.394  31.879  83.312  1.00 34.59           N  
ATOM    361  CA  GLU A  47      29.108  31.917  82.613  1.00 38.09           C  
ATOM    362  C   GLU A  47      29.163  31.303  81.165  1.00 38.45           C  
ATOM    363  O   GLU A  47      28.221  30.613  80.741  1.00 35.47           O  
ATOM    364  CB  GLU A  47      28.592  33.357  82.567  1.00 41.71           C  
ATOM    365  CG  GLU A  47      27.305  33.560  81.773  1.00 49.28           C  
ATOM    366  CD  GLU A  47      26.132  32.695  82.286  1.00 55.15           C  
ATOM    367  OE1 GLU A  47      26.061  32.452  83.520  1.00 56.01           O  
ATOM    368  OE2 GLU A  47      25.287  32.271  81.451  1.00 58.22           O  
ATOM    369  N   LEU A  48      30.253  31.572  80.432  1.00 36.11           N  
ATOM    370  CA  LEU A  48      30.449  31.047  79.064  1.00 35.12           C  
ATOM    371  C   LEU A  48      30.664  29.522  79.053  1.00 36.39           C  
ATOM    372  O   LEU A  48      30.195  28.827  78.152  1.00 34.99           O  
ATOM    373  CB  LEU A  48      31.627  31.765  78.367  1.00 33.83           C  
ATOM    374  CG  LEU A  48      31.315  33.181  77.827  1.00 31.97           C  
ATOM    375  CD1 LEU A  48      32.524  33.905  77.375  1.00 26.07           C  
ATOM    376  CD2 LEU A  48      30.301  33.141  76.683  1.00 36.03           C  
ATOM    377  N   LYS A  49      31.367  29.019  80.060  1.00 37.53           N  
ATOM    378  CA  LYS A  49      31.602  27.595  80.228  1.00 40.43           C  
ATOM    379  C   LYS A  49      30.265  26.877  80.417  1.00 44.09           C  
ATOM    380  O   LYS A  49      30.055  25.809  79.844  1.00 46.01           O  
ATOM    381  CB  LYS A  49      32.513  27.355  81.422  1.00 41.93           C  
ATOM    382  CG  LYS A  49      33.294  26.074  81.400  1.00 43.71           C  
ATOM    383  CD  LYS A  49      33.825  25.735  82.819  1.00 45.68           C  
ATOM    384  N   LYS A  50      29.361  27.487  81.187  1.00 44.00           N  
ATOM    385  CA  LYS A  50      28.005  26.968  81.377  1.00 45.41           C  
ATOM    386  C   LYS A  50      27.171  26.978  80.092  1.00 46.17           C  
ATOM    387  O   LYS A  50      26.186  26.265  79.994  1.00 49.86           O  
ATOM    388  CB  LYS A  50      27.254  27.776  82.464  1.00 46.24           C  
ATOM    389  CG  LYS A  50      27.808  27.614  83.888  1.00 47.90           C  
ATOM    390  N   LYS A  51      27.525  27.817  79.134  1.00 43.96           N  
ATOM    391  CA  LYS A  51      26.800  27.893  77.878  1.00 42.71           C  
ATOM    392  C   LYS A  51      27.486  27.056  76.792  1.00 40.69           C  
ATOM    393  O   LYS A  51      27.105  27.109  75.623  1.00 42.35           O  
ATOM    394  CB  LYS A  51      26.675  29.352  77.424  1.00 43.58           C  
ATOM    395  CG  LYS A  51      25.840  30.181  78.338  1.00 45.41           C  
ATOM    396  CD  LYS A  51      24.929  31.118  77.584  1.00 48.15           C  
ATOM    397  CE  LYS A  51      24.360  32.216  78.508  1.00 49.97           C  
ATOM    398  N   GLY A  52      28.493  26.290  77.192  1.00 38.03           N  
ATOM    399  CA  GLY A  52      29.238  25.430  76.305  1.00 35.86           C  
ATOM    400  C   GLY A  52      30.300  26.132  75.490  1.00 36.67           C  
ATOM    401  O   GLY A  52      30.675  25.651  74.438  1.00 36.43           O  
ATOM    402  N   VAL A  53      30.797  27.272  75.960  1.00 37.14           N  
ATOM    403  CA  VAL A  53      31.801  28.029  75.202  1.00 34.47           C  
ATOM    404  C   VAL A  53      33.107  27.946  75.968  1.00 34.40           C  
ATOM    405  O   VAL A  53      33.236  28.503  77.041  1.00 37.32           O  
ATOM    406  CB  VAL A  53      31.373  29.495  75.007  1.00 34.38           C  
ATOM    407  CG1 VAL A  53      32.350  30.248  74.082  1.00 34.96           C  
ATOM    408  CG2 VAL A  53      29.976  29.569  74.450  1.00 33.11           C  
ATOM    409  N   GLU A  54      34.056  27.206  75.429  1.00 35.47           N  
ATOM    410  CA  GLU A  54      35.349  27.052  76.055  1.00 36.47           C  
ATOM    411  C   GLU A  54      36.130  28.342  75.867  1.00 33.59           C  
ATOM    412  O   GLU A  54      36.082  28.966  74.815  1.00 34.37           O  
ATOM    413  CB  GLU A  54      36.129  25.856  75.470  1.00 37.54           C  
ATOM    414  N   ILE A  55      36.842  28.729  76.914  1.00 33.09           N  
ATOM    415  CA  ILE A  55      37.688  29.910  76.904  1.00 29.52           C  
ATOM    416  C   ILE A  55      38.992  29.402  77.461  1.00 29.24           C  
ATOM    417  O   ILE A  55      38.989  28.546  78.349  1.00 24.43           O  
ATOM    418  CB  ILE A  55      37.058  31.025  77.800  1.00 29.89           C  
ATOM    419  CG1 ILE A  55      35.766  31.571  77.157  1.00 32.64           C  
ATOM    420  CG2 ILE A  55      38.049  32.165  78.119  1.00 29.66           C  
ATOM    421  CD1 ILE A  55      35.951  32.396  75.851  1.00 29.27           C  
ATOM    422  N   ASP A  56      40.100  29.893  76.921  1.00 26.29           N  
ATOM    423  CA  ASP A  56      41.380  29.779  77.583  1.00 25.74           C  
ATOM    424  C   ASP A  56      41.441  30.811  78.740  1.00 25.90           C  
ATOM    425  O   ASP A  56      41.810  31.964  78.553  1.00 27.24           O  
ATOM    426  CB  ASP A  56      42.475  30.020  76.551  1.00 24.83           C  
ATOM    427  CG  ASP A  56      43.859  29.851  77.102  1.00 22.65           C  
ATOM    428  OD1 ASP A  56      44.048  29.599  78.309  1.00 28.87           O  
ATOM    429  OD2 ASP A  56      44.795  29.971  76.305  1.00 29.00           O  
ATOM    430  N   VAL A  57      41.056  30.369  79.928  1.00 25.22           N  
ATOM    431  CA  VAL A  57      40.885  31.229  81.065  1.00 25.27           C  
ATOM    432  C   VAL A  57      42.198  31.802  81.542  1.00 23.97           C  
ATOM    433  O   VAL A  57      42.261  32.977  81.870  1.00 20.15           O  
ATOM    434  CB  VAL A  57      40.152  30.516  82.196  1.00 29.57           C  
ATOM    435  CG1 VAL A  57      40.031  31.442  83.448  1.00 28.94           C  
ATOM    436  CG2 VAL A  57      38.766  30.070  81.708  1.00 28.22           C  
ATOM    437  N   GLU A  58      43.242  30.979  81.540  1.00 20.84           N  
ATOM    438  CA  GLU A  58      44.569  31.424  81.855  1.00 20.50           C  
ATOM    439  C   GLU A  58      44.952  32.612  81.015  1.00 27.52           C  
ATOM    440  O   GLU A  58      45.329  33.668  81.577  1.00 25.03           O  
ATOM    441  CB  GLU A  58      45.588  30.310  81.636  1.00 21.89           C  
ATOM    442  CG  GLU A  58      46.975  30.712  81.968  1.00 26.37           C  
ATOM    443  CD  GLU A  58      47.961  29.593  81.951  1.00 29.68           C  
ATOM    444  OE1 GLU A  58      47.565  28.418  82.083  1.00 36.18           O  
ATOM    445  OE2 GLU A  58      49.148  29.895  81.825  1.00 28.30           O  
ATOM    446  N   LYS A  59      44.864  32.457  79.669  1.00 24.57           N  
ATOM    447  CA  LYS A  59      45.131  33.587  78.782  1.00 21.65           C  
ATOM    448  C   LYS A  59      44.242  34.825  79.021  1.00 15.58           C  
ATOM    449  O   LYS A  59      44.732  35.943  78.995  1.00 17.70           O  
ATOM    450  CB  LYS A  59      45.022  33.168  77.342  1.00 25.98           C  
ATOM    451  CG  LYS A  59      45.225  34.325  76.329  1.00 27.69           C  
ATOM    452  CD  LYS A  59      45.002  33.839  74.926  1.00 30.09           C  
ATOM    453  CE  LYS A  59      46.243  33.199  74.363  1.00 29.28           C  
ATOM    454  NZ  LYS A  59      45.898  32.418  73.133  1.00 32.03           N  
ATOM    455  N   ALA A  60      42.959  34.625  79.242  1.00 17.25           N  
ATOM    456  CA  ALA A  60      42.048  35.724  79.449  1.00 20.12           C  
ATOM    457  C   ALA A  60      42.350  36.531  80.744  1.00 21.52           C  
ATOM    458  O   ALA A  60      42.257  37.757  80.741  1.00 22.27           O  
ATOM    459  CB  ALA A  60      40.626  35.235  79.412  1.00 20.70           C  
ATOM    460  N   LEU A  61      42.754  35.843  81.814  1.00 22.43           N  
ATOM    461  CA  LEU A  61      43.158  36.503  83.048  1.00 19.87           C  
ATOM    462  C   LEU A  61      44.485  37.207  82.888  1.00 19.08           C  
ATOM    463  O   LEU A  61      44.636  38.352  83.379  1.00 18.69           O  
ATOM    464  CB  LEU A  61      43.191  35.533  84.240  1.00 22.91           C  
ATOM    465  CG  LEU A  61      41.888  34.788  84.519  1.00 25.10           C  
ATOM    466  CD1 LEU A  61      42.085  33.739  85.664  1.00 25.04           C  
ATOM    467  CD2 LEU A  61      40.770  35.747  84.825  1.00 25.19           C  
ATOM    468  N   LYS A  62      45.444  36.616  82.177  1.00 19.90           N  
ATOM    469  CA  LYS A  62      46.699  37.357  81.950  1.00 19.80           C  
ATOM    470  C   LYS A  62      46.426  38.661  81.180  1.00 23.38           C  
ATOM    471  O   LYS A  62      46.990  39.702  81.486  1.00 21.17           O  
ATOM    472  CB  LYS A  62      47.723  36.553  81.176  1.00 23.91           C  
ATOM    473  CG  LYS A  62      48.347  35.375  81.863  1.00 26.14           C  
ATOM    474  CD  LYS A  62      49.321  34.700  80.913  1.00 28.66           C  
ATOM    475  CE  LYS A  62      49.960  33.480  81.512  1.00 34.50           C  
ATOM    476  NZ  LYS A  62      51.195  33.038  80.740  1.00 38.93           N  
ATOM    477  N   ILE A  63      45.548  38.591  80.186  1.00 21.97           N  
ATOM    478  CA  ILE A  63      45.237  39.761  79.353  1.00 22.25           C  
ATOM    479  C   ILE A  63      44.576  40.862  80.182  1.00 20.36           C  
ATOM    480  O   ILE A  63      44.918  42.014  80.043  1.00 19.73           O  
ATOM    481  CB  ILE A  63      44.309  39.397  78.167  1.00 20.38           C  
ATOM    482  CG1 ILE A  63      45.035  38.492  77.152  1.00 20.90           C  
ATOM    483  CG2 ILE A  63      43.746  40.673  77.494  1.00 21.85           C  
ATOM    484  CD1 ILE A  63      44.089  37.809  76.141  1.00 22.69           C  
ATOM    485  N   ALA A  64      43.611  40.473  81.015  1.00 19.85           N  
ATOM    486  CA  ALA A  64      42.907  41.382  81.881  1.00 18.07           C  
ATOM    487  C   ALA A  64      43.855  42.152  82.839  1.00 19.01           C  
ATOM    488  O   ALA A  64      43.674  43.343  83.066  1.00 21.23           O  
ATOM    489  CB  ALA A  64      41.891  40.629  82.668  1.00 17.81           C  
ATOM    490  N   ILE A  65      44.847  41.439  83.357  1.00 20.55           N  
ATOM    491  CA  ILE A  65      45.875  41.965  84.223  1.00 24.49           C  
ATOM    492  C   ILE A  65      46.791  42.940  83.527  1.00 21.89           C  
ATOM    493  O   ILE A  65      47.079  44.016  84.082  1.00 23.75           O  
ATOM    494  CB  ILE A  65      46.690  40.837  84.897  1.00 23.52           C  
ATOM    495  CG1 ILE A  65      45.817  40.108  85.894  1.00 21.67           C  
ATOM    496  CG2 ILE A  65      47.917  41.414  85.659  1.00 27.21           C  
ATOM    497  CD1 ILE A  65      46.363  38.746  86.269  1.00 24.21           C  
ATOM    498  N   ILE A  66      47.223  42.620  82.317  1.00 22.43           N  
ATOM    499  CA  ILE A  66      48.199  43.497  81.631  1.00 20.67           C  
ATOM    500  C   ILE A  66      47.534  44.582  80.765  1.00 21.50           C  
ATOM    501  O   ILE A  66      48.197  45.474  80.289  1.00 19.55           O  
ATOM    502  CB  ILE A  66      49.236  42.684  80.823  1.00 24.24           C  
ATOM    503  CG1 ILE A  66      48.580  41.871  79.705  1.00 28.10           C  
ATOM    504  CG2 ILE A  66      50.022  41.716  81.775  1.00 24.27           C  
ATOM    505  CD1 ILE A  66      48.361  42.586  78.428  1.00 29.58           C  
ATOM    506  N   HIS A  67      46.217  44.527  80.580  1.00 21.32           N  
ATOM    507  CA  HIS A  67      45.631  45.263  79.465  1.00 22.98           C  
ATOM    508  C   HIS A  67      45.771  46.805  79.531  1.00 26.29           C  
ATOM    509  O   HIS A  67      45.882  47.453  78.486  1.00 22.20           O  
ATOM    510  CB  HIS A  67      44.209  44.823  79.223  1.00 20.52           C  
ATOM    511  CG  HIS A  67      43.209  45.588  80.003  1.00 23.61           C  
ATOM    512  ND1 HIS A  67      42.944  45.322  81.324  1.00 24.36           N  
ATOM    513  CD2 HIS A  67      42.443  46.647  79.664  1.00 23.36           C  
ATOM    514  CE1 HIS A  67      42.052  46.186  81.773  1.00 25.38           C  
ATOM    515  NE2 HIS A  67      41.717  46.990  80.783  1.00 26.11           N  
ATOM    516  N   ASP A  68      45.815  47.376  80.742  1.00 25.44           N  
ATOM    517  CA  ASP A  68      45.988  48.818  80.923  1.00 20.55           C  
ATOM    518  C   ASP A  68      47.309  49.143  81.621  1.00 22.40           C  
ATOM    519  O   ASP A  68      47.523  50.282  82.023  1.00 20.47           O  
ATOM    520  CB  ASP A  68      44.824  49.397  81.715  1.00 22.53           C  
ATOM    521  CG  ASP A  68      43.591  49.622  80.861  1.00 24.12           C  
ATOM    522  OD1 ASP A  68      43.680  49.505  79.638  1.00 26.91           O  
ATOM    523  OD2 ASP A  68      42.513  49.929  81.406  1.00 26.55           O  
ATOM    524  N   LEU A  69      48.219  48.166  81.695  1.00 17.43           N  
ATOM    525  CA  LEU A  69      49.486  48.360  82.373  1.00 22.80           C  
ATOM    526  C   LEU A  69      50.416  49.384  81.676  1.00 27.32           C  
ATOM    527  O   LEU A  69      51.224  50.048  82.340  1.00 25.26           O  
ATOM    528  CB  LEU A  69      50.187  47.023  82.494  1.00 26.03           C  
ATOM    529  CG  LEU A  69      51.407  46.900  83.394  1.00 30.45           C  
ATOM    530  CD1 LEU A  69      51.237  47.607  84.792  1.00 29.95           C  
ATOM    531  CD2 LEU A  69      51.687  45.403  83.548  1.00 32.06           C  
ATOM    532  N   GLY A  70      50.275  49.516  80.351  1.00 23.92           N  
ATOM    533  CA  GLY A  70      50.952  50.564  79.599  1.00 25.38           C  
ATOM    534  C   GLY A  70      50.586  51.991  80.033  1.00 22.90           C  
ATOM    535  O   GLY A  70      51.342  52.943  79.768  1.00 19.81           O  
ATOM    536  N   GLU A  71      49.445  52.123  80.715  1.00 22.19           N  
ATOM    537  CA  GLU A  71      49.016  53.398  81.275  1.00 23.99           C  
ATOM    538  C   GLU A  71      49.851  53.832  82.481  1.00 24.20           C  
ATOM    539  O   GLU A  71      49.852  55.002  82.824  1.00 24.71           O  
ATOM    540  CB  GLU A  71      47.510  53.370  81.604  1.00 25.72           C  
ATOM    541  CG  GLU A  71      46.698  53.059  80.366  1.00 22.31           C  
ATOM    542  CD  GLU A  71      45.197  53.222  80.501  1.00 23.51           C  
ATOM    543  OE1 GLU A  71      44.635  53.257  81.628  1.00 25.48           O  
ATOM    544  OE2 GLU A  71      44.569  53.272  79.435  1.00 19.21           O  
ATOM    545  N   ALA A  72      50.580  52.893  83.097  1.00 21.97           N  
ATOM    546  CA  ALA A  72      51.570  53.219  84.102  1.00 19.53           C  
ATOM    547  C   ALA A  72      52.585  54.212  83.577  1.00 16.67           C  
ATOM    548  O   ALA A  72      53.069  55.045  84.318  1.00 22.06           O  
ATOM    549  CB  ALA A  72      52.285  51.942  84.618  1.00 18.48           C  
ATOM    550  N   ILE A  73      52.872  54.124  82.294  1.00 18.44           N  
ATOM    551  CA  ILE A  73      53.797  55.025  81.575  1.00 21.12           C  
ATOM    552  C   ILE A  73      53.088  56.185  80.842  1.00 20.50           C  
ATOM    553  O   ILE A  73      53.493  57.338  80.930  1.00 23.28           O  
ATOM    554  CB  ILE A  73      54.639  54.138  80.595  1.00 23.84           C  
ATOM    555  CG1 ILE A  73      55.198  52.950  81.403  1.00 27.85           C  
ATOM    556  CG2 ILE A  73      55.717  54.928  79.903  1.00 25.07           C  
ATOM    557  CD1 ILE A  73      56.367  52.278  80.846  1.00 34.01           C  
ATOM    558  N   ILE A  74      51.999  55.862  80.158  1.00 25.42           N  
ATOM    559  CA  ILE A  74      51.298  56.785  79.245  1.00 24.84           C  
ATOM    560  C   ILE A  74      50.198  57.605  79.948  1.00 26.12           C  
ATOM    561  O   ILE A  74      49.802  58.658  79.441  1.00 24.47           O  
ATOM    562  CB  ILE A  74      50.660  55.982  78.075  1.00 23.95           C  
ATOM    563  CG1 ILE A  74      51.738  55.286  77.215  1.00 25.24           C  
ATOM    564  CG2 ILE A  74      49.704  56.849  77.208  1.00 24.01           C  
ATOM    565  CD1 ILE A  74      52.879  56.199  76.746  1.00 26.20           C  
ATOM    566  N   THR A  75      49.758  57.132  81.128  1.00 24.36           N  
ATOM    567  CA  THR A  75      48.521  57.582  81.814  1.00 23.51           C  
ATOM    568  C   THR A  75      47.285  57.144  81.034  1.00 23.22           C  
ATOM    569  O   THR A  75      47.389  56.617  79.938  1.00 22.96           O  
ATOM    570  CB  THR A  75      48.429  59.120  82.092  1.00 22.38           C  
ATOM    571  OG1 THR A  75      48.171  59.840  80.865  1.00 23.18           O  
ATOM    572  CG2 THR A  75      49.712  59.610  82.735  1.00 25.44           C  
ATOM    573  N   ASP A  76      46.123  57.346  81.652  1.00 21.24           N  
ATOM    574  CA  ASP A  76      44.867  56.993  81.072  1.00 24.02           C  
ATOM    575  C   ASP A  76      44.386  58.203  80.224  1.00 25.11           C  
ATOM    576  O   ASP A  76      43.729  59.090  80.720  1.00 28.81           O  
ATOM    577  CB  ASP A  76      43.869  56.663  82.192  1.00 24.35           C  
ATOM    578  CG  ASP A  76      42.529  56.226  81.668  1.00 24.85           C  
ATOM    579  OD1 ASP A  76      42.468  55.732  80.526  1.00 26.02           O  
ATOM    580  OD2 ASP A  76      41.526  56.408  82.373  1.00 27.19           O  
ATOM    581  N   LEU A  77      44.720  58.222  78.948  1.00 23.96           N  
ATOM    582  CA  LEU A  77      44.330  59.326  78.093  1.00 25.11           C  
ATOM    583  C   LEU A  77      42.804  59.337  77.881  1.00 23.20           C  
ATOM    584  O   LEU A  77      42.203  58.316  77.500  1.00 22.97           O  
ATOM    585  CB  LEU A  77      45.095  59.296  76.769  1.00 29.06           C  
ATOM    586  CG  LEU A  77      46.610  59.400  76.962  1.00 31.90           C  
ATOM    587  CD1 LEU A  77      47.346  59.294  75.625  1.00 34.73           C  
ATOM    588  CD2 LEU A  77      46.994  60.671  77.677  1.00 32.15           C  
ATOM    589  N   PRO A  78      42.166  60.478  78.207  1.00 23.25           N  
ATOM    590  CA  PRO A  78      40.720  60.583  77.996  1.00 24.89           C  
ATOM    591  C   PRO A  78      40.391  60.688  76.515  1.00 27.73           C  
ATOM    592  O   PRO A  78      41.303  60.869  75.674  1.00 22.86           O  
ATOM    593  CB  PRO A  78      40.339  61.870  78.762  1.00 23.44           C  
ATOM    594  CG  PRO A  78      41.623  62.689  78.826  1.00 23.94           C  
ATOM    595  CD  PRO A  78      42.753  61.719  78.774  1.00 20.73           C  
ATOM    596  N   LEU A  79      39.101  60.587  76.199  1.00 29.13           N  
ATOM    597  CA  LEU A  79      38.645  60.660  74.807  1.00 30.40           C  
ATOM    598  C   LEU A  79      39.086  61.946  74.130  1.00 27.11           C  
ATOM    599  O   LEU A  79      39.438  61.934  72.962  1.00 32.73           O  
ATOM    600  CB  LEU A  79      37.126  60.537  74.743  1.00 30.14           C  
ATOM    601  CG  LEU A  79      36.568  59.156  75.056  1.00 34.43           C  
ATOM    602  CD1 LEU A  79      35.133  59.264  75.623  1.00 37.65           C  
ATOM    603  CD2 LEU A  79      36.580  58.257  73.816  1.00 33.33           C  
ATOM    604  N   SER A  80      39.066  63.054  74.867  1.00 27.95           N  
ATOM    605  CA  SER A  80      39.419  64.369  74.316  1.00 26.06           C  
ATOM    606  C   SER A  80      40.837  64.354  73.742  1.00 26.08           C  
ATOM    607  O   SER A  80      41.080  64.910  72.684  1.00 26.80           O  
ATOM    608  CB  SER A  80      39.253  65.460  75.392  1.00 26.22           C  
ATOM    609  OG  SER A  80      40.174  65.287  76.477  1.00 25.92           O  
ATOM    610  N   ALA A  81      41.747  63.677  74.453  1.00 25.92           N  
ATOM    611  CA  ALA A  81      43.157  63.611  74.126  1.00 28.45           C  
ATOM    612  C   ALA A  81      43.406  62.635  72.986  1.00 30.53           C  
ATOM    613  O   ALA A  81      44.360  62.792  72.187  1.00 27.45           O  
ATOM    614  CB  ALA A  81      43.951  63.185  75.368  1.00 30.75           C  
ATOM    615  N   GLN A  82      42.540  61.626  72.913  1.00 30.39           N  
ATOM    616  CA  GLN A  82      42.622  60.600  71.867  1.00 32.96           C  
ATOM    617  C   GLN A  82      42.329  61.126  70.453  1.00 31.41           C  
ATOM    618  O   GLN A  82      42.668  60.475  69.491  1.00 35.71           O  
ATOM    619  CB  GLN A  82      41.714  59.419  72.196  1.00 31.28           C  
ATOM    620  CG  GLN A  82      42.200  58.608  73.420  1.00 31.22           C  
ATOM    621  CD  GLN A  82      41.192  57.557  73.847  1.00 33.64           C  
ATOM    622  OE1 GLN A  82      40.604  56.876  73.000  1.00 35.97           O  
ATOM    623  NE2 GLN A  82      40.987  57.414  75.157  1.00 30.57           N  
ATOM    624  N   LYS A  83      41.706  62.290  70.340  1.00 29.74           N  
ATOM    625  CA  LYS A  83      41.509  62.924  69.058  1.00 33.54           C  
ATOM    626  C   LYS A  83      42.826  63.495  68.487  1.00 32.78           C  
ATOM    627  O   LYS A  83      42.884  63.818  67.306  1.00 34.04           O  
ATOM    628  CB  LYS A  83      40.442  64.035  69.170  1.00 35.98           C  
ATOM    629  N   TYR A  84      43.860  63.636  69.335  1.00 31.93           N  
ATOM    630  CA  TYR A  84      45.140  64.227  68.936  1.00 30.13           C  
ATOM    631  C   TYR A  84      46.316  63.308  69.131  1.00 32.46           C  
ATOM    632  O   TYR A  84      47.381  63.613  68.631  1.00 36.25           O  
ATOM    633  CB  TYR A  84      45.412  65.536  69.703  1.00 29.46           C  
ATOM    634  CG  TYR A  84      44.341  66.536  69.532  1.00 26.57           C  
ATOM    635  CD1 TYR A  84      44.356  67.412  68.451  1.00 27.39           C  
ATOM    636  CD2 TYR A  84      43.249  66.576  70.408  1.00 27.33           C  
ATOM    637  CE1 TYR A  84      43.304  68.350  68.260  1.00 26.30           C  
ATOM    638  CE2 TYR A  84      42.209  67.507  70.243  1.00 25.78           C  
ATOM    639  CZ  TYR A  84      42.249  68.389  69.157  1.00 27.17           C  
ATOM    640  OH  TYR A  84      41.232  69.292  68.983  1.00 26.86           O  
ATOM    641  N   LEU A  85      46.130  62.204  69.871  1.00 34.18           N  
ATOM    642  CA  LEU A  85      47.207  61.261  70.219  1.00 33.20           C  
ATOM    643  C   LEU A  85      46.713  59.857  70.020  1.00 34.31           C  
ATOM    644  O   LEU A  85      45.562  59.576  70.328  1.00 36.16           O  
ATOM    645  CB  LEU A  85      47.585  61.405  71.707  1.00 33.67           C  
ATOM    646  CG  LEU A  85      48.179  62.777  72.049  1.00 34.68           C  
ATOM    647  CD1 LEU A  85      48.264  63.022  73.522  1.00 32.35           C  
ATOM    648  CD2 LEU A  85      49.548  62.922  71.398  1.00 36.56           C  
ATOM    649  N   ASN A  86      47.583  58.961  69.556  1.00 37.61           N  
ATOM    650  CA  ASN A  86      47.239  57.527  69.413  1.00 38.89           C  
ATOM    651  C   ASN A  86      47.537  56.759  70.718  1.00 36.31           C  
ATOM    652  O   ASN A  86      48.650  56.294  70.948  1.00 34.35           O  
ATOM    653  CB  ASN A  86      48.000  56.910  68.229  1.00 41.76           C  
ATOM    654  CG  ASN A  86      47.413  55.551  67.765  1.00 45.78           C  
ATOM    655  OD1 ASN A  86      46.674  54.848  68.497  1.00 45.69           O  
ATOM    656  ND2 ASN A  86      47.762  55.176  66.539  1.00 48.29           N  
ATOM    657  N   LYS A  87      46.511  56.619  71.547  1.00 39.53           N  
ATOM    658  CA  LYS A  87      46.627  55.987  72.846  1.00 40.65           C  
ATOM    659  C   LYS A  87      47.144  54.536  72.733  1.00 38.43           C  
ATOM    660  O   LYS A  87      48.126  54.171  73.404  1.00 32.12           O  
ATOM    661  CB  LYS A  87      45.259  56.018  73.561  1.00 41.94           C  
ATOM    662  CG  LYS A  87      45.290  55.547  75.022  1.00 42.20           C  
ATOM    663  CD  LYS A  87      43.886  55.411  75.624  1.00 43.70           C  
ATOM    664  N   GLU A  88      46.488  53.740  71.878  1.00 36.85           N  
ATOM    665  CA  GLU A  88      46.742  52.307  71.801  1.00 37.94           C  
ATOM    666  C   GLU A  88      48.155  52.030  71.320  1.00 37.22           C  
ATOM    667  O   GLU A  88      48.859  51.192  71.887  1.00 33.12           O  
ATOM    668  CB  GLU A  88      45.728  51.614  70.892  1.00 39.18           C  
ATOM    669  N   GLU A  89      48.570  52.776  70.301  1.00 37.35           N  
ATOM    670  CA  GLU A  89      49.912  52.679  69.774  1.00 41.74           C  
ATOM    671  C   GLU A  89      50.975  53.008  70.830  1.00 37.83           C  
ATOM    672  O   GLU A  89      51.970  52.306  70.955  1.00 37.77           O  
ATOM    673  CB  GLU A  89      50.059  53.599  68.567  1.00 44.54           C  
ATOM    674  CG  GLU A  89      51.503  53.705  68.036  1.00 50.62           C  
ATOM    675  CD  GLU A  89      51.734  54.922  67.123  1.00 52.40           C  
ATOM    676  OE1 GLU A  89      50.742  55.460  66.538  1.00 54.58           O  
ATOM    677  OE2 GLU A  89      52.923  55.324  66.993  1.00 56.23           O  
ATOM    678  N   ALA A  90      50.760  54.080  71.585  1.00 36.43           N  
ATOM    679  CA  ALA A  90      51.741  54.522  72.590  1.00 31.93           C  
ATOM    680  C   ALA A  90      51.810  53.528  73.771  1.00 28.28           C  
ATOM    681  O   ALA A  90      52.904  53.241  74.287  1.00 29.93           O  
ATOM    682  CB  ALA A  90      51.424  55.939  73.061  1.00 29.86           C  
ATOM    683  N   GLU A  91      50.669  52.965  74.159  1.00 29.89           N  
ATOM    684  CA  GLU A  91      50.648  51.898  75.215  1.00 31.42           C  
ATOM    685  C   GLU A  91      51.386  50.641  74.758  1.00 33.79           C  
ATOM    686  O   GLU A  91      52.124  50.038  75.545  1.00 33.72           O  
ATOM    687  CB  GLU A  91      49.220  51.505  75.630  1.00 30.45           C  
ATOM    688  CG  GLU A  91      48.433  52.556  76.412  1.00 30.52           C  
ATOM    689  CD  GLU A  91      47.059  52.023  76.936  1.00 35.22           C  
ATOM    690  OE1 GLU A  91      46.944  50.834  77.313  1.00 36.03           O  
ATOM    691  OE2 GLU A  91      46.096  52.818  77.001  1.00 38.01           O  
ATOM    692  N   ALA A  92      51.189  50.246  73.489  1.00 33.85           N  
ATOM    693  CA  ALA A  92      51.827  49.042  72.959  1.00 32.84           C  
ATOM    694  C   ALA A  92      53.329  49.220  72.955  1.00 33.10           C  
ATOM    695  O   ALA A  92      54.056  48.301  73.345  1.00 30.69           O  
ATOM    696  CB  ALA A  92      51.310  48.700  71.547  1.00 32.93           C  
ATOM    697  N   LYS A  93      53.793  50.412  72.557  1.00 34.83           N  
ATOM    698  CA  LYS A  93      55.206  50.723  72.577  1.00 33.13           C  
ATOM    699  C   LYS A  93      55.776  50.705  73.999  1.00 36.30           C  
ATOM    700  O   LYS A  93      56.873  50.182  74.226  1.00 39.73           O  
ATOM    701  CB  LYS A  93      55.498  52.074  71.932  1.00 33.20           C  
ATOM    702  CG  LYS A  93      55.483  52.096  70.442  1.00 36.76           C  
ATOM    703  N   ALA A  94      55.067  51.314  74.941  1.00 36.68           N  
ATOM    704  CA  ALA A  94      55.518  51.342  76.342  1.00 35.54           C  
ATOM    705  C   ALA A  94      55.614  49.920  76.899  1.00 37.87           C  
ATOM    706  O   ALA A  94      56.633  49.555  77.513  1.00 34.74           O  
ATOM    707  CB  ALA A  94      54.558  52.198  77.210  1.00 34.71           C  
ATOM    708  N   LEU A  95      54.552  49.123  76.684  1.00 38.07           N  
ATOM    709  CA  LEU A  95      54.564  47.721  77.088  1.00 42.41           C  
ATOM    710  C   LEU A  95      55.735  46.931  76.469  1.00 42.56           C  
ATOM    711  O   LEU A  95      56.402  46.172  77.159  1.00 44.94           O  
ATOM    712  CB  LEU A  95      53.241  47.026  76.745  1.00 43.61           C  
ATOM    713  CG  LEU A  95      52.112  47.063  77.778  1.00 46.38           C  
ATOM    714  CD1 LEU A  95      50.952  46.198  77.262  1.00 47.83           C  
ATOM    715  CD2 LEU A  95      52.569  46.594  79.180  1.00 44.36           C  
ATOM    716  N   LYS A  96      55.959  47.093  75.173  1.00 42.84           N  
ATOM    717  CA  LYS A  96      57.008  46.362  74.500  1.00 45.86           C  
ATOM    718  C   LYS A  96      58.329  46.633  75.220  1.00 47.00           C  
ATOM    719  O   LYS A  96      59.091  45.698  75.501  1.00 48.03           O  
ATOM    720  CB  LYS A  96      57.095  46.743  73.015  1.00 48.24           C  
ATOM    721  CG  LYS A  96      57.906  45.766  72.150  1.00 50.84           C  
ATOM    722  N   ASP A  97      58.584  47.899  75.554  1.00 44.97           N  
ATOM    723  CA  ASP A  97      59.852  48.277  76.209  1.00 45.42           C  
ATOM    724  C   ASP A  97      60.056  47.728  77.623  1.00 43.65           C  
ATOM    725  O   ASP A  97      61.190  47.632  78.068  1.00 39.69           O  
ATOM    726  CB  ASP A  97      60.019  49.800  76.233  1.00 47.09           C  
ATOM    727  CG  ASP A  97      60.365  50.359  74.885  1.00 48.64           C  
ATOM    728  OD1 ASP A  97      60.751  49.555  74.010  1.00 49.00           O  
ATOM    729  OD2 ASP A  97      60.249  51.594  74.700  1.00 47.49           O  
ATOM    730  N   VAL A  98      58.979  47.371  78.322  1.00 44.05           N  
ATOM    731  CA  VAL A  98      59.098  46.859  79.695  1.00 44.12           C  
ATOM    732  C   VAL A  98      58.741  45.393  79.888  1.00 45.64           C  
ATOM    733  O   VAL A  98      59.377  44.707  80.693  1.00 45.35           O  
ATOM    734  CB  VAL A  98      58.251  47.676  80.707  1.00 44.69           C  
ATOM    735  CG1 VAL A  98      58.817  49.077  80.860  1.00 44.61           C  
ATOM    736  CG2 VAL A  98      56.748  47.677  80.349  1.00 42.00           C  
ATOM    737  N   LEU A  99      57.697  44.942  79.193  1.00 47.56           N  
ATOM    738  CA  LEU A  99      57.196  43.558  79.263  1.00 47.03           C  
ATOM    739  C   LEU A  99      57.064  42.992  77.841  1.00 45.52           C  
ATOM    740  O   LEU A  99      55.964  42.617  77.410  1.00 38.21           O  
ATOM    741  CB  LEU A  99      55.820  43.518  79.951  1.00 50.05           C  
ATOM    742  CG  LEU A  99      55.727  43.732  81.463  1.00 50.72           C  
ATOM    743  CD1 LEU A  99      54.289  44.025  81.863  1.00 50.21           C  
ATOM    744  CD2 LEU A  99      56.278  42.505  82.212  1.00 50.63           C  
ATOM    745  N   PRO A 100      58.189  42.900  77.113  1.00 43.79           N  
ATOM    746  CA  PRO A 100      58.137  42.444  75.707  1.00 45.56           C  
ATOM    747  C   PRO A 100      57.455  41.075  75.531  1.00 45.07           C  
ATOM    748  O   PRO A 100      56.930  40.792  74.479  1.00 41.89           O  
ATOM    749  CB  PRO A 100      59.613  42.392  75.288  1.00 43.02           C  
ATOM    750  CG  PRO A 100      60.393  42.410  76.592  1.00 43.23           C  
ATOM    751  CD  PRO A 100      59.566  43.166  77.567  1.00 43.23           C  
ATOM    752  N   GLU A 101      57.451  40.274  76.587  1.00 49.64           N  
ATOM    753  CA  GLU A 101      56.814  38.955  76.613  1.00 54.31           C  
ATOM    754  C   GLU A 101      55.277  38.957  76.716  1.00 51.00           C  
ATOM    755  O   GLU A 101      54.671  37.909  76.621  1.00 45.46           O  
ATOM    756  CB  GLU A 101      57.407  38.127  77.773  1.00 59.78           C  
ATOM    757  CG  GLU A 101      57.015  38.602  79.196  1.00 64.53           C  
ATOM    758  CD  GLU A 101      57.857  39.781  79.757  1.00 67.79           C  
ATOM    759  OE1 GLU A 101      58.615  40.442  79.017  1.00 67.40           O  
ATOM    760  OE2 GLU A 101      57.742  40.046  80.974  1.00 73.42           O  
ATOM    761  N   TYR A 102      54.658  40.117  76.932  1.00 51.60           N  
ATOM    762  CA  TYR A 102      53.196  40.227  76.903  1.00 54.18           C  
ATOM    763  C   TYR A 102      52.721  41.114  75.751  1.00 55.77           C  
ATOM    764  O   TYR A 102      51.640  41.725  75.819  1.00 59.21           O  
ATOM    765  CB  TYR A 102      52.665  40.777  78.233  1.00 57.89           C  
ATOM    766  CG  TYR A 102      52.962  39.890  79.420  1.00 59.35           C  
ATOM    767  CD1 TYR A 102      52.659  38.523  79.386  1.00 61.62           C  
ATOM    768  CD2 TYR A 102      53.535  40.406  80.574  1.00 59.76           C  
ATOM    769  CE1 TYR A 102      52.938  37.689  80.463  1.00 60.93           C  
ATOM    770  CE2 TYR A 102      53.802  39.582  81.666  1.00 61.45           C  
ATOM    771  CZ  TYR A 102      53.500  38.221  81.594  1.00 59.80           C  
ATOM    772  OH  TYR A 102      53.766  37.392  82.651  1.00 60.80           O  
ATOM    773  N   THR A 103      53.523  41.185  74.693  1.00 54.72           N  
ATOM    774  CA  THR A 103      53.217  42.070  73.565  1.00 54.24           C  
ATOM    775  C   THR A 103      52.020  41.538  72.784  1.00 48.78           C  
ATOM    776  O   THR A 103      51.102  42.296  72.459  1.00 46.66           O  
ATOM    777  CB  THR A 103      54.428  42.211  72.603  1.00 56.61           C  
ATOM    778  OG1 THR A 103      55.586  42.548  73.353  1.00 59.79           O  
ATOM    779  CG2 THR A 103      54.179  43.303  71.581  1.00 58.10           C  
ATOM    780  N   GLU A 104      52.056  40.230  72.500  1.00 45.28           N  
ATOM    781  CA  GLU A 104      50.990  39.547  71.774  1.00 45.94           C  
ATOM    782  C   GLU A 104      49.688  39.531  72.548  1.00 44.24           C  
ATOM    783  O   GLU A 104      48.629  39.568  71.941  1.00 43.66           O  
ATOM    784  CB  GLU A 104      51.391  38.115  71.408  1.00 46.49           C  
ATOM    785  N   LEU A 105      49.775  39.487  73.881  1.00 44.67           N  
ATOM    786  CA  LEU A 105      48.583  39.533  74.751  1.00 43.83           C  
ATOM    787  C   LEU A 105      47.873  40.875  74.684  1.00 38.39           C  
ATOM    788  O   LEU A 105      46.643  40.906  74.585  1.00 34.51           O  
ATOM    789  CB  LEU A 105      48.929  39.221  76.214  1.00 45.74           C  
ATOM    790  CG  LEU A 105      49.268  37.769  76.599  1.00 44.43           C  
ATOM    791  CD1 LEU A 105      49.309  37.703  78.107  1.00 45.70           C  
ATOM    792  CD2 LEU A 105      48.283  36.745  76.067  1.00 44.56           C  
ATOM    793  N   PHE A 106      48.639  41.972  74.735  1.00 35.83           N  
ATOM    794  CA  PHE A 106      48.054  43.320  74.573  1.00 34.53           C  
ATOM    795  C   PHE A 106      47.543  43.553  73.121  1.00 37.52           C  
ATOM    796  O   PHE A 106      46.547  44.266  72.927  1.00 36.92           O  
ATOM    797  CB  PHE A 106      49.026  44.414  74.993  1.00 33.98           C  
ATOM    798  CG  PHE A 106      48.487  45.812  74.806  1.00 35.00           C  
ATOM    799  CD1 PHE A 106      47.529  46.330  75.678  1.00 32.46           C  
ATOM    800  CD2 PHE A 106      48.912  46.603  73.743  1.00 34.84           C  
ATOM    801  CE1 PHE A 106      47.017  47.618  75.503  1.00 33.24           C  
ATOM    802  CE2 PHE A 106      48.392  47.898  73.562  1.00 36.85           C  
ATOM    803  CZ  PHE A 106      47.447  48.406  74.451  1.00 33.69           C  
ATOM    804  N   GLU A 107      48.199  42.928  72.120  1.00 37.48           N  
ATOM    805  CA  GLU A 107      47.668  42.917  70.735  1.00 36.20           C  
ATOM    806  C   GLU A 107      46.295  42.254  70.695  1.00 33.21           C  
ATOM    807  O   GLU A 107      45.379  42.779  70.049  1.00 32.18           O  
ATOM    808  CB  GLU A 107      48.631  42.238  69.722  1.00 36.42           C  
ATOM    809  N   GLU A 108      46.143  41.109  71.380  1.00 30.88           N  
ATOM    810  CA  GLU A 108      44.862  40.409  71.392  1.00 29.72           C  
ATOM    811  C   GLU A 108      43.774  41.275  72.004  1.00 32.01           C  
ATOM    812  O   GLU A 108      42.611  41.271  71.557  1.00 29.25           O  
ATOM    813  CB  GLU A 108      44.928  39.099  72.187  1.00 30.59           C  
ATOM    814  CG  GLU A 108      45.377  37.892  71.373  1.00 32.62           C  
ATOM    815  CD  GLU A 108      45.126  36.569  72.047  1.00 26.96           C  
ATOM    816  OE1 GLU A 108      43.979  36.217  72.391  1.00 26.17           O  
ATOM    817  OE2 GLU A 108      46.087  35.834  72.158  1.00 34.28           O  
ATOM    818  N   TYR A 109      44.132  41.963  73.088  1.00 31.01           N  
ATOM    819  CA  TYR A 109      43.186  42.847  73.761  1.00 28.44           C  
ATOM    820  C   TYR A 109      42.816  43.977  72.771  1.00 24.63           C  
ATOM    821  O   TYR A 109      41.608  44.228  72.511  1.00 24.62           O  
ATOM    822  CB  TYR A 109      43.738  43.425  75.089  1.00 27.88           C  
ATOM    823  CG  TYR A 109      42.799  44.457  75.656  1.00 29.95           C  
ATOM    824  CD1 TYR A 109      41.603  44.066  76.205  1.00 25.53           C  
ATOM    825  CD2 TYR A 109      43.060  45.823  75.549  1.00 29.17           C  
ATOM    826  CE1 TYR A 109      40.724  44.951  76.682  1.00 26.41           C  
ATOM    827  CE2 TYR A 109      42.128  46.764  76.038  1.00 29.23           C  
ATOM    828  CZ  TYR A 109      40.963  46.290  76.593  1.00 28.16           C  
ATOM    829  OH  TYR A 109      39.999  47.116  77.112  1.00 31.77           O  
ATOM    830  N   SER A 110      43.833  44.638  72.230  1.00 25.06           N  
ATOM    831  CA  SER A 110      43.559  45.832  71.429  1.00 33.68           C  
ATOM    832  C   SER A 110      42.811  45.471  70.134  1.00 31.79           C  
ATOM    833  O   SER A 110      41.878  46.125  69.769  1.00 32.87           O  
ATOM    834  CB  SER A 110      44.818  46.692  71.190  1.00 34.57           C  
ATOM    835  OG  SER A 110      45.922  45.920  70.833  1.00 41.67           O  
ATOM    836  N   LYS A 111      43.148  44.368  69.506  1.00 33.08           N  
ATOM    837  CA  LYS A 111      42.429  43.954  68.307  1.00 29.68           C  
ATOM    838  C   LYS A 111      41.049  43.427  68.621  1.00 29.21           C  
ATOM    839  O   LYS A 111      40.113  43.661  67.843  1.00 25.60           O  
ATOM    840  CB  LYS A 111      43.253  42.914  67.565  1.00 35.31           C  
ATOM    841  CG  LYS A 111      44.529  43.481  66.956  1.00 37.20           C  
ATOM    842  CD  LYS A 111      44.218  44.350  65.738  1.00 41.11           C  
ATOM    843  CE  LYS A 111      45.473  44.548  64.845  1.00 42.86           C  
ATOM    844  N   ALA A 112      40.920  42.724  69.757  1.00 24.78           N  
ATOM    845  CA  ALA A 112      39.669  42.116  70.210  1.00 23.37           C  
ATOM    846  C   ALA A 112      39.021  41.208  69.157  1.00 25.92           C  
ATOM    847  O   ALA A 112      37.801  41.255  68.903  1.00 23.17           O  
ATOM    848  CB  ALA A 112      38.716  43.160  70.672  1.00 27.44           C  
ATOM    849  N   LEU A 113      39.863  40.394  68.550  1.00 30.51           N  
ATOM    850  CA  LEU A 113      39.452  39.497  67.475  1.00 31.82           C  
ATOM    851  C   LEU A 113      39.306  38.070  68.013  1.00 29.11           C  
ATOM    852  O   LEU A 113      38.305  37.423  67.734  1.00 33.09           O  
ATOM    853  CB  LEU A 113      40.463  39.574  66.315  1.00 31.09           C  
ATOM    854  CG  LEU A 113      40.472  40.903  65.547  1.00 30.72           C  
ATOM    855  CD1 LEU A 113      41.550  40.905  64.486  1.00 30.12           C  
ATOM    856  CD2 LEU A 113      39.104  41.173  64.921  1.00 32.51           C  
ATOM    857  N   THR A 114      40.278  37.603  68.807  1.00 27.65           N  
ATOM    858  CA  THR A 114      40.198  36.272  69.427  1.00 26.31           C  
ATOM    859  C   THR A 114      39.096  36.174  70.494  1.00 26.01           C  
ATOM    860  O   THR A 114      38.582  37.174  70.959  1.00 26.36           O  
ATOM    861  CB  THR A 114      41.495  35.862  70.051  1.00 27.93           C  
ATOM    862  OG1 THR A 114      41.735  36.648  71.243  1.00 24.14           O  
ATOM    863  CG2 THR A 114      42.648  35.991  69.011  1.00 27.92           C  
ATOM    864  N   LEU A 115      38.712  34.969  70.868  1.00 24.76           N  
ATOM    865  CA  LEU A 115      37.651  34.830  71.889  1.00 25.97           C  
ATOM    866  C   LEU A 115      38.063  35.524  73.201  1.00 24.69           C  
ATOM    867  O   LEU A 115      37.267  36.222  73.842  1.00 22.81           O  
ATOM    868  CB  LEU A 115      37.351  33.354  72.172  1.00 30.54           C  
ATOM    869  CG  LEU A 115      36.401  32.540  71.250  1.00 33.89           C  
ATOM    870  CD1 LEU A 115      36.732  32.692  69.770  1.00 34.23           C  
ATOM    871  CD2 LEU A 115      36.425  31.058  71.671  1.00 29.77           C  
ATOM    872  N   GLU A 116      39.315  35.303  73.593  1.00 21.15           N  
ATOM    873  CA  GLU A 116      39.858  35.833  74.841  1.00 22.51           C  
ATOM    874  C   GLU A 116      39.993  37.366  74.769  1.00 22.04           C  
ATOM    875  O   GLU A 116      39.640  38.035  75.700  1.00 22.00           O  
ATOM    876  CB  GLU A 116      41.203  35.180  75.174  1.00 24.32           C  
ATOM    877  CG  GLU A 116      41.081  33.724  75.646  1.00 25.87           C  
ATOM    878  CD  GLU A 116      40.715  32.719  74.494  1.00 26.72           C  
ATOM    879  OE1 GLU A 116      41.284  32.829  73.403  1.00 23.95           O  
ATOM    880  OE2 GLU A 116      39.812  31.874  74.692  1.00 26.20           O  
ATOM    881  N   GLY A 117      40.480  37.898  73.641  1.00 23.39           N  
ATOM    882  CA  GLY A 117      40.510  39.335  73.408  1.00 21.90           C  
ATOM    883  C   GLY A 117      39.138  39.993  73.470  1.00 22.43           C  
ATOM    884  O   GLY A 117      38.975  41.058  74.079  1.00 19.90           O  
ATOM    885  N   GLN A 118      38.139  39.375  72.836  1.00 23.84           N  
ATOM    886  CA  GLN A 118      36.767  39.865  72.902  1.00 19.51           C  
ATOM    887  C   GLN A 118      36.212  39.829  74.310  1.00 21.26           C  
ATOM    888  O   GLN A 118      35.473  40.749  74.727  1.00 23.37           O  
ATOM    889  CB  GLN A 118      35.836  38.993  72.069  1.00 22.76           C  
ATOM    890  CG  GLN A 118      36.062  38.987  70.584  1.00 23.85           C  
ATOM    891  CD  GLN A 118      35.113  37.991  69.923  1.00 22.83           C  
ATOM    892  OE1 GLN A 118      33.904  38.040  70.142  1.00 22.78           O  
ATOM    893  NE2 GLN A 118      35.653  37.113  69.118  1.00 23.30           N  
ATOM    894  N   LEU A 119      36.488  38.729  75.011  1.00 21.55           N  
ATOM    895  CA  LEU A 119      36.033  38.566  76.391  1.00 25.41           C  
ATOM    896  C   LEU A 119      36.529  39.710  77.333  1.00 20.61           C  
ATOM    897  O   LEU A 119      35.764  40.219  78.131  1.00 17.28           O  
ATOM    898  CB  LEU A 119      36.444  37.195  76.965  1.00 25.07           C  
ATOM    899  CG  LEU A 119      36.070  36.967  78.449  1.00 26.05           C  
ATOM    900  CD1 LEU A 119      34.606  37.151  78.715  1.00 24.59           C  
ATOM    901  CD2 LEU A 119      36.510  35.574  78.902  1.00 28.02           C  
ATOM    902  N   VAL A 120      37.803  40.065  77.231  1.00 19.59           N  
ATOM    903  CA  VAL A 120      38.371  41.080  78.097  1.00 21.04           C  
ATOM    904  C   VAL A 120      37.900  42.473  77.680  1.00 21.66           C  
ATOM    905  O   VAL A 120      37.687  43.319  78.541  1.00 20.02           O  
ATOM    906  CB  VAL A 120      39.911  41.006  78.155  1.00 19.76           C  
ATOM    907  CG1 VAL A 120      40.432  42.058  79.099  1.00 21.89           C  
ATOM    908  CG2 VAL A 120      40.371  39.629  78.647  1.00 20.40           C  
ATOM    909  N   LYS A 121      37.722  42.703  76.378  1.00 18.60           N  
ATOM    910  CA  LYS A 121      37.071  43.926  75.907  1.00 21.06           C  
ATOM    911  C   LYS A 121      35.641  44.117  76.438  1.00 20.74           C  
ATOM    912  O   LYS A 121      35.221  45.233  76.835  1.00 22.50           O  
ATOM    913  CB  LYS A 121      37.073  43.981  74.359  1.00 26.95           C  
ATOM    914  CG  LYS A 121      36.746  45.384  73.766  1.00 29.93           C  
ATOM    915  CD  LYS A 121      37.873  46.435  73.953  1.00 32.01           C  
ATOM    916  CE  LYS A 121      38.933  46.293  72.838  1.00 39.63           C  
ATOM    917  NZ  LYS A 121      40.142  47.188  72.905  1.00 36.79           N  
ATOM    918  N   ILE A 122      34.888  43.034  76.472  1.00 21.80           N  
ATOM    919  CA  ILE A 122      33.580  43.072  77.070  1.00 23.18           C  
ATOM    920  C   ILE A 122      33.653  43.408  78.567  1.00 20.95           C  
ATOM    921  O   ILE A 122      32.896  44.211  79.049  1.00 16.65           O  
ATOM    922  CB  ILE A 122      32.823  41.763  76.825  1.00 23.30           C  
ATOM    923  CG1 ILE A 122      32.388  41.715  75.363  1.00 24.17           C  
ATOM    924  CG2 ILE A 122      31.547  41.695  77.699  1.00 27.06           C  
ATOM    925  CD1 ILE A 122      31.927  40.342  74.928  1.00 26.33           C  
ATOM    926  N   ALA A 123      34.558  42.764  79.283  1.00 21.50           N  
ATOM    927  CA  ALA A 123      34.698  42.977  80.736  1.00 22.64           C  
ATOM    928  C   ALA A 123      35.079  44.422  81.053  1.00 18.99           C  
ATOM    929  O   ALA A 123      34.617  45.007  81.994  1.00 18.14           O  
ATOM    930  CB  ALA A 123      35.764  42.009  81.304  1.00 22.18           C  
ATOM    931  N   ASP A 124      35.979  44.955  80.255  1.00 23.11           N  
ATOM    932  CA  ASP A 124      36.454  46.305  80.407  1.00 23.80           C  
ATOM    933  C   ASP A 124      35.338  47.375  80.279  1.00 23.91           C  
ATOM    934  O   ASP A 124      35.217  48.307  81.103  1.00 21.40           O  
ATOM    935  CB  ASP A 124      37.531  46.516  79.365  1.00 18.65           C  
ATOM    936  CG  ASP A 124      38.195  47.847  79.504  1.00 20.54           C  
ATOM    937  OD1 ASP A 124      38.916  48.059  80.472  1.00 22.50           O  
ATOM    938  OD2 ASP A 124      37.978  48.704  78.652  1.00 23.85           O  
ATOM    939  N   LYS A 125      34.528  47.206  79.238  1.00 25.09           N  
ATOM    940  CA  LYS A 125      33.373  48.047  78.996  1.00 22.62           C  
ATOM    941  C   LYS A 125      32.312  47.882  80.036  1.00 21.36           C  
ATOM    942  O   LYS A 125      31.678  48.855  80.424  1.00 22.89           O  
ATOM    943  CB  LYS A 125      32.834  47.770  77.589  1.00 28.52           C  
ATOM    944  CG  LYS A 125      33.789  48.343  76.514  1.00 29.43           C  
ATOM    945  CD  LYS A 125      33.555  47.748  75.146  1.00 35.18           C  
ATOM    946  CE  LYS A 125      34.480  48.384  74.097  1.00 35.55           C  
ATOM    947  NZ  LYS A 125      34.585  49.878  74.314  1.00 38.14           N  
ATOM    948  N   LEU A 126      32.107  46.656  80.505  1.00 19.47           N  
ATOM    949  CA  LEU A 126      31.149  46.410  81.597  1.00 20.68           C  
ATOM    950  C   LEU A 126      31.561  47.046  82.923  1.00 18.81           C  
ATOM    951  O   LEU A 126      30.727  47.576  83.617  1.00 18.16           O  
ATOM    952  CB  LEU A 126      30.909  44.926  81.786  1.00 23.41           C  
ATOM    953  CG  LEU A 126      30.172  44.259  80.611  1.00 25.05           C  
ATOM    954  CD1 LEU A 126      29.893  42.820  80.969  1.00 28.79           C  
ATOM    955  CD2 LEU A 126      28.896  44.978  80.238  1.00 27.78           C  
ATOM    956  N   ASP A 127      32.842  46.967  83.275  1.00 19.05           N  
ATOM    957  CA  ASP A 127      33.328  47.640  84.454  1.00 20.05           C  
ATOM    958  C   ASP A 127      33.007  49.166  84.380  1.00 15.88           C  
ATOM    959  O   ASP A 127      32.492  49.732  85.331  1.00 17.78           O  
ATOM    960  CB  ASP A 127      34.826  47.460  84.607  1.00 19.98           C  
ATOM    961  CG  ASP A 127      35.389  48.325  85.703  1.00 20.96           C  
ATOM    962  OD1 ASP A 127      35.078  48.083  86.901  1.00 20.41           O  
ATOM    963  OD2 ASP A 127      36.113  49.267  85.358  1.00 20.04           O  
ATOM    964  N   MET A 128      33.302  49.777  83.237  1.00 15.98           N  
ATOM    965  CA  MET A 128      33.056  51.211  82.973  1.00 18.58           C  
ATOM    966  C   MET A 128      31.604  51.642  83.079  1.00 16.58           C  
ATOM    967  O   MET A 128      31.314  52.641  83.679  1.00 18.85           O  
ATOM    968  CB  MET A 128      33.593  51.619  81.604  1.00 18.48           C  
ATOM    969  CG  MET A 128      33.690  53.123  81.462  1.00 26.10           C  
ATOM    970  SD  MET A 128      34.380  53.720  79.880  1.00 32.51           S  
ATOM    971  CE  MET A 128      32.858  53.423  78.910  1.00 35.88           C  
ATOM    972  N   ILE A 129      30.705  50.861  82.500  1.00 18.86           N  
ATOM    973  CA  ILE A 129      29.324  51.210  82.429  1.00 19.17           C  
ATOM    974  C   ILE A 129      28.709  51.053  83.785  1.00 20.27           C  
ATOM    975  O   ILE A 129      27.875  51.874  84.201  1.00 21.28           O  
ATOM    976  CB  ILE A 129      28.524  50.303  81.421  1.00 23.31           C  
ATOM    977  CG1 ILE A 129      29.070  50.432  80.003  1.00 24.81           C  
ATOM    978  CG2 ILE A 129      27.037  50.701  81.399  1.00 23.84           C  
ATOM    979  CD1 ILE A 129      28.532  49.343  79.103  1.00 26.24           C  
ATOM    980  N   ILE A 130      29.092  49.988  84.471  1.00 17.51           N  
ATOM    981  CA  ILE A 130      28.594  49.747  85.810  1.00 19.13           C  
ATOM    982  C   ILE A 130      29.160  50.785  86.785  1.00 14.40           C  
ATOM    983  O   ILE A 130      28.439  51.235  87.660  1.00 16.54           O  
ATOM    984  CB  ILE A 130      28.876  48.302  86.292  1.00 21.72           C  
ATOM    985  CG1 ILE A 130      28.089  47.290  85.458  1.00 22.80           C  
ATOM    986  CG2 ILE A 130      28.467  48.139  87.755  1.00 20.49           C  
ATOM    987  CD1 ILE A 130      28.573  45.789  85.619  1.00 22.85           C  
ATOM    988  N   GLN A 131      30.425  51.169  86.599  1.00 13.96           N  
ATOM    989  CA  GLN A 131      31.029  52.238  87.378  1.00 15.53           C  
ATOM    990  C   GLN A 131      30.307  53.562  87.184  1.00 16.09           C  
ATOM    991  O   GLN A 131      30.131  54.304  88.138  1.00 13.01           O  
ATOM    992  CB  GLN A 131      32.522  52.391  87.061  1.00 13.48           C  
ATOM    993  CG  GLN A 131      33.252  53.368  88.022  1.00 13.65           C  
ATOM    994  CD  GLN A 131      33.158  52.912  89.454  1.00 16.81           C  
ATOM    995  OE1 GLN A 131      33.658  51.832  89.800  1.00 18.13           O  
ATOM    996  NE2 GLN A 131      32.480  53.704  90.297  1.00 10.15           N  
ATOM    997  N   ALA A 132      29.833  53.814  85.961  1.00 17.81           N  
ATOM    998  CA  ALA A 132      29.066  55.023  85.644  1.00 19.19           C  
ATOM    999  C   ALA A 132      27.754  55.058  86.405  1.00 18.72           C  
ATOM   1000  O   ALA A 132      27.439  56.078  87.035  1.00 18.69           O  
ATOM   1001  CB  ALA A 132      28.847  55.168  84.136  1.00 17.55           C  
ATOM   1002  N   TYR A 133      27.058  53.932  86.437  1.00 17.96           N  
ATOM   1003  CA  TYR A 133      25.866  53.763  87.268  1.00 18.16           C  
ATOM   1004  C   TYR A 133      26.169  53.977  88.785  1.00 20.63           C  
ATOM   1005  O   TYR A 133      25.455  54.671  89.486  1.00 19.99           O  
ATOM   1006  CB  TYR A 133      25.264  52.376  86.987  1.00 23.73           C  
ATOM   1007  CG  TYR A 133      24.318  51.892  88.049  1.00 23.61           C  
ATOM   1008  CD1 TYR A 133      22.979  52.318  88.072  1.00 24.05           C  
ATOM   1009  CD2 TYR A 133      24.760  51.039  89.042  1.00 22.68           C  
ATOM   1010  CE1 TYR A 133      22.117  51.897  89.055  1.00 24.40           C  
ATOM   1011  CE2 TYR A 133      23.894  50.601  90.054  1.00 26.98           C  
ATOM   1012  CZ  TYR A 133      22.579  51.027  90.050  1.00 25.86           C  
ATOM   1013  OH  TYR A 133      21.738  50.599  91.043  1.00 28.25           O  
ATOM   1014  N   GLU A 134      27.263  53.404  89.278  1.00 24.16           N  
ATOM   1015  CA  GLU A 134      27.664  53.605  90.677  1.00 20.07           C  
ATOM   1016  C   GLU A 134      27.960  55.065  90.938  1.00 17.90           C  
ATOM   1017  O   GLU A 134      27.579  55.559  91.969  1.00 14.17           O  
ATOM   1018  CB  GLU A 134      28.883  52.752  91.029  1.00 22.80           C  
ATOM   1019  CG  GLU A 134      28.540  51.253  90.964  1.00 25.13           C  
ATOM   1020  CD  GLU A 134      29.726  50.372  91.106  1.00 23.14           C  
ATOM   1021  OE1 GLU A 134      30.156  50.082  92.234  1.00 34.53           O  
ATOM   1022  OE2 GLU A 134      30.251  49.975  90.095  1.00 25.86           O  
ATOM   1023  N   TYR A 135      28.627  55.766  90.007  1.00 16.76           N  
ATOM   1024  CA  TYR A 135      28.940  57.184  90.234  1.00 13.64           C  
ATOM   1025  C   TYR A 135      27.689  58.058  90.176  1.00 15.57           C  
ATOM   1026  O   TYR A 135      27.599  58.994  90.909  1.00 17.97           O  
ATOM   1027  CB  TYR A 135      30.055  57.727  89.325  1.00 13.17           C  
ATOM   1028  CG  TYR A 135      31.448  57.304  89.733  1.00 14.23           C  
ATOM   1029  CD1 TYR A 135      31.830  57.197  91.103  1.00 14.38           C  
ATOM   1030  CD2 TYR A 135      32.401  57.023  88.760  1.00 12.01           C  
ATOM   1031  CE1 TYR A 135      33.164  56.765  91.468  1.00 13.22           C  
ATOM   1032  CE2 TYR A 135      33.698  56.662  89.096  1.00 14.43           C  
ATOM   1033  CZ  TYR A 135      34.076  56.517  90.450  1.00 14.05           C  
ATOM   1034  OH  TYR A 135      35.353  56.125  90.678  1.00 13.38           O  
ATOM   1035  N   GLU A 136      26.717  57.698  89.352  1.00 18.64           N  
ATOM   1036  CA  GLU A 136      25.407  58.334  89.363  1.00 21.20           C  
ATOM   1037  C   GLU A 136      24.646  58.182  90.692  1.00 19.41           C  
ATOM   1038  O   GLU A 136      24.038  59.126  91.145  1.00 22.25           O  
ATOM   1039  CB  GLU A 136      24.556  57.795  88.234  1.00 20.85           C  
ATOM   1040  CG  GLU A 136      25.072  58.214  86.855  1.00 30.46           C  
ATOM   1041  CD  GLU A 136      24.318  57.562  85.687  1.00 34.40           C  
ATOM   1042  OE1 GLU A 136      23.353  56.792  85.914  1.00 42.87           O  
ATOM   1043  OE2 GLU A 136      24.700  57.825  84.528  1.00 44.05           O  
ATOM   1044  N   LEU A 137      24.701  57.011  91.304  1.00 17.30           N  
ATOM   1045  CA  LEU A 137      24.147  56.807  92.627  1.00 21.28           C  
ATOM   1046  C   LEU A 137      24.727  57.754  93.720  1.00 22.23           C  
ATOM   1047  O   LEU A 137      24.055  58.068  94.681  1.00 22.04           O  
ATOM   1048  CB  LEU A 137      24.352  55.339  93.032  1.00 25.75           C  
ATOM   1049  CG  LEU A 137      23.517  54.235  92.347  1.00 24.71           C  
ATOM   1050  CD1 LEU A 137      23.816  52.884  93.038  1.00 25.95           C  
ATOM   1051  CD2 LEU A 137      22.032  54.547  92.465  1.00 25.11           C  
ATOM   1052  N   SER A 138      25.968  58.178  93.557  1.00 22.33           N  
ATOM   1053  CA  SER A 138      26.658  59.064  94.503  1.00 23.94           C  
ATOM   1054  C   SER A 138      26.601  60.512  94.050  1.00 25.22           C  
ATOM   1055  O   SER A 138      27.158  61.373  94.713  1.00 23.86           O  
ATOM   1056  CB  SER A 138      28.151  58.661  94.638  1.00 22.83           C  
ATOM   1057  OG  SER A 138      28.208  57.349  95.164  1.00 23.70           O  
ATOM   1058  N   GLY A 139      25.959  60.774  92.898  1.00 24.66           N  
ATOM   1059  CA  GLY A 139      25.543  62.107  92.559  1.00 24.87           C  
ATOM   1060  C   GLY A 139      25.819  62.643  91.176  1.00 26.33           C  
ATOM   1061  O   GLY A 139      25.277  63.704  90.819  1.00 27.61           O  
ATOM   1062  N   ALA A 140      26.616  61.936  90.373  1.00 20.54           N  
ATOM   1063  CA  ALA A 140      26.935  62.439  89.028  1.00 21.17           C  
ATOM   1064  C   ALA A 140      25.680  62.458  88.126  1.00 22.85           C  
ATOM   1065  O   ALA A 140      24.959  61.473  88.066  1.00 25.51           O  
ATOM   1066  CB  ALA A 140      28.006  61.612  88.407  1.00 15.92           C  
ATOM   1067  N   LYS A 141      25.448  63.578  87.432  1.00 25.07           N  
ATOM   1068  CA  LYS A 141      24.329  63.716  86.495  1.00 27.60           C  
ATOM   1069  C   LYS A 141      24.776  63.816  85.028  1.00 25.59           C  
ATOM   1070  O   LYS A 141      23.953  64.035  84.165  1.00 21.40           O  
ATOM   1071  CB  LYS A 141      23.486  64.965  86.849  1.00 29.63           C  
ATOM   1072  CG  LYS A 141      22.708  64.839  88.165  1.00 33.44           C  
ATOM   1073  CD  LYS A 141      21.842  66.094  88.430  1.00 35.75           C  
ATOM   1074  N   ASN A 142      26.075  63.660  84.775  1.00 22.44           N  
ATOM   1075  CA  ASN A 142      26.706  64.005  83.510  1.00 18.07           C  
ATOM   1076  C   ASN A 142      27.497  62.852  82.852  1.00 17.00           C  
ATOM   1077  O   ASN A 142      28.421  63.079  82.089  1.00 23.92           O  
ATOM   1078  CB  ASN A 142      27.607  65.231  83.722  1.00 20.47           C  
ATOM   1079  CG  ASN A 142      28.753  65.007  84.787  1.00 18.72           C  
ATOM   1080  OD1 ASN A 142      28.767  64.052  85.586  1.00 22.35           O  
ATOM   1081  ND2 ASN A 142      29.703  65.914  84.775  1.00 18.43           N  
ATOM   1082  N   LEU A 143      27.107  61.621  83.144  1.00 18.60           N  
ATOM   1083  CA  LEU A 143      27.810  60.424  82.702  1.00 23.40           C  
ATOM   1084  C   LEU A 143      26.980  59.530  81.736  1.00 28.99           C  
ATOM   1085  O   LEU A 143      27.342  58.389  81.519  1.00 30.96           O  
ATOM   1086  CB  LEU A 143      28.155  59.554  83.932  1.00 21.27           C  
ATOM   1087  CG  LEU A 143      28.906  60.215  85.086  1.00 19.34           C  
ATOM   1088  CD1 LEU A 143      29.330  59.121  86.064  1.00 19.13           C  
ATOM   1089  CD2 LEU A 143      30.149  60.994  84.590  1.00 20.86           C  
ATOM   1090  N   SER A 144      25.885  60.036  81.166  1.00 32.28           N  
ATOM   1091  CA  SER A 144      25.011  59.221  80.286  1.00 34.21           C  
ATOM   1092  C   SER A 144      25.720  58.668  79.040  1.00 33.32           C  
ATOM   1093  O   SER A 144      25.416  57.581  78.579  1.00 31.25           O  
ATOM   1094  CB  SER A 144      23.797  60.046  79.833  1.00 37.56           C  
ATOM   1095  OG  SER A 144      24.225  61.078  78.945  1.00 37.45           O  
ATOM   1096  N   GLU A 145      26.648  59.436  78.498  1.00 34.93           N  
ATOM   1097  CA  GLU A 145      27.420  59.010  77.357  1.00 38.78           C  
ATOM   1098  C   GLU A 145      28.145  57.665  77.576  1.00 38.31           C  
ATOM   1099  O   GLU A 145      28.412  56.945  76.590  1.00 31.22           O  
ATOM   1100  CB  GLU A 145      28.474  60.072  77.009  1.00 43.81           C  
ATOM   1101  CG  GLU A 145      29.502  60.227  78.116  1.00 49.71           C  
ATOM   1102  CD  GLU A 145      30.540  61.268  77.843  1.00 55.10           C  
ATOM   1103  OE1 GLU A 145      31.510  60.978  77.090  1.00 63.42           O  
ATOM   1104  OE2 GLU A 145      30.405  62.366  78.410  1.00 52.87           O  
ATOM   1105  N   PHE A 146      28.496  57.342  78.835  1.00 33.10           N  
ATOM   1106  CA  PHE A 146      29.334  56.168  79.105  1.00 32.42           C  
ATOM   1107  C   PHE A 146      28.563  54.889  78.824  1.00 31.82           C  
ATOM   1108  O   PHE A 146      29.142  53.848  78.546  1.00 36.04           O  
ATOM   1109  CB  PHE A 146      29.891  56.194  80.539  1.00 34.39           C  
ATOM   1110  CG  PHE A 146      31.000  57.176  80.722  1.00 33.45           C  
ATOM   1111  CD1 PHE A 146      32.258  56.910  80.247  1.00 35.27           C  
ATOM   1112  CD2 PHE A 146      30.772  58.403  81.320  1.00 33.88           C  
ATOM   1113  CE1 PHE A 146      33.282  57.860  80.393  1.00 38.38           C  
ATOM   1114  CE2 PHE A 146      31.789  59.322  81.478  1.00 31.99           C  
ATOM   1115  CZ  PHE A 146      33.024  59.062  81.027  1.00 35.13           C  
ATOM   1116  N   TRP A 147      27.246  54.998  78.857  1.00 32.42           N  
ATOM   1117  CA  TRP A 147      26.356  53.908  78.506  1.00 34.93           C  
ATOM   1118  C   TRP A 147      26.347  53.572  77.012  1.00 36.65           C  
ATOM   1119  O   TRP A 147      25.851  52.515  76.611  1.00 40.11           O  
ATOM   1120  CB  TRP A 147      24.960  54.290  78.940  1.00 36.51           C  
ATOM   1121  CG  TRP A 147      24.868  54.469  80.426  1.00 38.53           C  
ATOM   1122  CD1 TRP A 147      25.236  55.572  81.173  1.00 37.20           C  
ATOM   1123  CD2 TRP A 147      24.365  53.508  81.356  1.00 38.65           C  
ATOM   1124  NE1 TRP A 147      24.985  55.345  82.498  1.00 37.59           N  
ATOM   1125  CE2 TRP A 147      24.450  54.083  82.638  1.00 38.87           C  
ATOM   1126  CE3 TRP A 147      23.864  52.202  81.227  1.00 36.59           C  
ATOM   1127  CZ2 TRP A 147      24.054  53.398  83.779  1.00 37.06           C  
ATOM   1128  CZ3 TRP A 147      23.475  51.536  82.346  1.00 35.63           C  
ATOM   1129  CH2 TRP A 147      23.571  52.125  83.611  1.00 36.75           C  
ATOM   1130  N   ASN A 148      26.884  54.472  76.186  1.00 38.15           N  
ATOM   1131  CA  ASN A 148      26.949  54.238  74.752  1.00 37.77           C  
ATOM   1132  C   ASN A 148      27.875  53.059  74.435  1.00 38.73           C  
ATOM   1133  O   ASN A 148      27.820  52.505  73.331  1.00 40.26           O  
ATOM   1134  CB  ASN A 148      27.399  55.513  73.990  1.00 33.55           C  
ATOM   1135  CG  ASN A 148      26.371  56.650  74.067  1.00 32.26           C  
ATOM   1136  OD1 ASN A 148      25.178  56.417  74.293  1.00 31.48           O  
ATOM   1137  ND2 ASN A 148      26.837  57.892  73.867  1.00 29.53           N  
ATOM   1138  N   ALA A 149      28.719  52.669  75.395  1.00 38.79           N  
ATOM   1139  CA  ALA A 149      29.595  51.512  75.201  1.00 36.85           C  
ATOM   1140  C   ALA A 149      28.807  50.189  75.121  1.00 34.54           C  
ATOM   1141  O   ALA A 149      29.318  49.231  74.572  1.00 35.60           O  
ATOM   1142  CB  ALA A 149      30.711  51.438  76.289  1.00 34.89           C  
ATOM   1143  N   LEU A 150      27.585  50.140  75.653  1.00 34.14           N  
ATOM   1144  CA  LEU A 150      26.713  48.980  75.423  1.00 39.03           C  
ATOM   1145  C   LEU A 150      26.603  48.666  73.919  1.00 42.77           C  
ATOM   1146  O   LEU A 150      26.685  47.494  73.520  1.00 41.35           O  
ATOM   1147  CB  LEU A 150      25.316  49.195  75.984  1.00 40.90           C  
ATOM   1148  CG  LEU A 150      25.044  48.871  77.438  1.00 43.67           C  
ATOM   1149  CD1 LEU A 150      23.643  49.360  77.856  1.00 44.97           C  
ATOM   1150  CD2 LEU A 150      25.182  47.384  77.697  1.00 45.24           C  
ATOM   1151  N   GLU A 151      26.452  49.709  73.093  1.00 42.58           N  
ATOM   1152  CA  GLU A 151      26.325  49.539  71.640  1.00 46.14           C  
ATOM   1153  C   GLU A 151      27.547  48.853  71.030  1.00 46.71           C  
ATOM   1154  O   GLU A 151      27.428  48.142  70.046  1.00 47.71           O  
ATOM   1155  CB  GLU A 151      26.134  50.892  70.939  1.00 46.83           C  
ATOM   1156  CG  GLU A 151      24.938  51.739  71.413  1.00 48.37           C  
ATOM   1157  CD  GLU A 151      25.037  53.230  70.992  1.00 49.31           C  
ATOM   1158  OE1 GLU A 151      26.138  53.672  70.549  1.00 45.26           O  
ATOM   1159  OE2 GLU A 151      24.008  53.960  71.121  1.00 49.27           O  
ATOM   1160  N   ASP A 152      28.725  49.092  71.605  1.00 50.09           N  
ATOM   1161  CA  ASP A 152      29.983  48.520  71.086  1.00 51.01           C  
ATOM   1162  C   ASP A 152      30.118  46.986  71.334  1.00 48.77           C  
ATOM   1163  O   ASP A 152      30.951  46.325  70.716  1.00 43.11           O  
ATOM   1164  CB  ASP A 152      31.216  49.195  71.721  1.00 55.11           C  
ATOM   1165  CG  ASP A 152      31.168  50.723  71.706  1.00 58.30           C  
ATOM   1166  OD1 ASP A 152      30.231  51.337  71.113  1.00 57.48           O  
ATOM   1167  OD2 ASP A 152      32.111  51.303  72.321  1.00 59.29           O  
ATOM   1168  N   LEU A 153      29.305  46.439  72.244  1.00 50.88           N  
ATOM   1169  CA  LEU A 153      29.394  45.022  72.639  1.00 49.76           C  
ATOM   1170  C   LEU A 153      28.794  44.063  71.638  1.00 52.64           C  
ATOM   1171  O   LEU A 153      29.343  42.974  71.422  1.00 50.32           O  
ATOM   1172  CB  LEU A 153      28.715  44.810  73.989  1.00 47.79           C  
ATOM   1173  CG  LEU A 153      29.321  45.653  75.101  1.00 42.66           C  
ATOM   1174  CD1 LEU A 153      28.728  45.237  76.399  1.00 43.24           C  
ATOM   1175  CD2 LEU A 153      30.815  45.499  75.079  1.00 41.34           C  
ATOM   1176  N   GLU A 154      27.669  44.467  71.044  1.00 54.09           N  
ATOM   1177  CA  GLU A 154      26.980  43.677  70.028  1.00 54.13           C  
ATOM   1178  C   GLU A 154      27.888  43.359  68.853  1.00 53.29           C  
ATOM   1179  O   GLU A 154      27.750  42.310  68.191  1.00 57.53           O  
ATOM   1180  CB  GLU A 154      25.748  44.437  69.527  1.00 56.89           C  
ATOM   1181  N   LYS A 155      28.834  44.249  68.598  1.00 47.13           N  
ATOM   1182  CA  LYS A 155      29.775  44.057  67.508  1.00 47.67           C  
ATOM   1183  C   LYS A 155      30.807  42.921  67.781  1.00 46.33           C  
ATOM   1184  O   LYS A 155      31.526  42.489  66.877  1.00 50.56           O  
ATOM   1185  CB  LYS A 155      30.474  45.389  67.220  1.00 49.18           C  
ATOM   1186  CG  LYS A 155      29.487  46.592  66.981  1.00 49.35           C  
ATOM   1187  CD  LYS A 155      30.151  47.943  67.300  1.00 51.02           C  
ATOM   1188  N   LEU A 156      30.881  42.463  69.031  1.00 41.62           N  
ATOM   1189  CA  LEU A 156      31.740  41.349  69.430  1.00 38.74           C  
ATOM   1190  C   LEU A 156      30.881  40.088  69.414  1.00 34.97           C  
ATOM   1191  O   LEU A 156      29.914  40.003  70.169  1.00 34.44           O  
ATOM   1192  CB  LEU A 156      32.336  41.607  70.838  1.00 34.76           C  
ATOM   1193  CG  LEU A 156      33.073  42.948  70.942  1.00 35.43           C  
ATOM   1194  CD1 LEU A 156      33.470  43.307  72.377  1.00 36.02           C  
ATOM   1195  CD2 LEU A 156      34.299  42.968  70.019  1.00 32.28           C  
ATOM   1196  N   GLU A 157      31.206  39.130  68.541  1.00 33.54           N  
ATOM   1197  CA  GLU A 157      30.440  37.881  68.457  1.00 33.32           C  
ATOM   1198  C   GLU A 157      30.115  37.216  69.791  1.00 29.36           C  
ATOM   1199  O   GLU A 157      29.018  36.732  69.971  1.00 30.20           O  
ATOM   1200  CB  GLU A 157      31.158  36.827  67.596  1.00 37.57           C  
ATOM   1201  CG  GLU A 157      30.944  36.916  66.099  1.00 40.44           C  
ATOM   1202  CD  GLU A 157      29.513  37.219  65.666  1.00 42.91           C  
ATOM   1203  OE1 GLU A 157      28.501  36.621  66.183  1.00 46.69           O  
ATOM   1204  OE2 GLU A 157      29.415  38.054  64.751  1.00 48.15           O  
ATOM   1205  N   ILE A 158      31.087  37.161  70.701  1.00 33.16           N  
ATOM   1206  CA  ILE A 158      30.960  36.352  71.935  1.00 29.70           C  
ATOM   1207  C   ILE A 158      29.835  36.878  72.859  1.00 27.96           C  
ATOM   1208  O   ILE A 158      29.321  36.153  73.697  1.00 25.50           O  
ATOM   1209  CB  ILE A 158      32.378  36.155  72.641  1.00 33.14           C  
ATOM   1210  CG1 ILE A 158      32.484  34.773  73.329  1.00 35.36           C  
ATOM   1211  CG2 ILE A 158      32.732  37.257  73.617  1.00 30.45           C  
ATOM   1212  N   SER A 159      29.422  38.125  72.646  1.00 29.14           N  
ATOM   1213  CA  SER A 159      28.334  38.746  73.420  1.00 34.58           C  
ATOM   1214  C   SER A 159      26.952  38.115  73.203  1.00 33.82           C  
ATOM   1215  O   SER A 159      26.045  38.314  74.001  1.00 33.83           O  
ATOM   1216  CB  SER A 159      28.244  40.256  73.115  1.00 33.15           C  
ATOM   1217  OG  SER A 159      27.781  40.478  71.799  1.00 38.34           O  
ATOM   1218  N   ARG A 160      26.779  37.358  72.130  1.00 34.83           N  
ATOM   1219  CA  ARG A 160      25.528  36.621  71.960  1.00 38.36           C  
ATOM   1220  C   ARG A 160      25.368  35.510  73.010  1.00 35.24           C  
ATOM   1221  O   ARG A 160      24.259  35.091  73.311  1.00 37.05           O  
ATOM   1222  CB  ARG A 160      25.419  36.077  70.539  1.00 42.71           C  
ATOM   1223  CG  ARG A 160      26.324  34.949  70.257  1.00 45.57           C  
ATOM   1224  CD  ARG A 160      26.511  34.763  68.760  1.00 50.61           C  
ATOM   1225  NE  ARG A 160      26.586  33.340  68.457  1.00 51.18           N  
ATOM   1226  CZ  ARG A 160      27.301  32.794  67.486  1.00 51.46           C  
ATOM   1227  NH1 ARG A 160      28.043  33.540  66.658  1.00 51.99           N  
ATOM   1228  NH2 ARG A 160      27.269  31.475  67.362  1.00 52.64           N  
ATOM   1229  N   TYR A 161      26.482  35.086  73.599  1.00 37.20           N  
ATOM   1230  CA  TYR A 161      26.487  34.143  74.743  1.00 36.29           C  
ATOM   1231  C   TYR A 161      26.415  34.807  76.122  1.00 35.56           C  
ATOM   1232  O   TYR A 161      26.451  34.118  77.142  1.00 37.94           O  
ATOM   1233  CB  TYR A 161      27.723  33.263  74.650  1.00 36.25           C  
ATOM   1234  CG  TYR A 161      27.629  32.395  73.435  1.00 35.70           C  
ATOM   1235  CD1 TYR A 161      26.884  31.220  73.475  1.00 37.51           C  
ATOM   1236  CD2 TYR A 161      28.216  32.765  72.245  1.00 33.64           C  
ATOM   1237  CE1 TYR A 161      26.754  30.420  72.362  1.00 37.76           C  
ATOM   1238  CE2 TYR A 161      28.101  31.975  71.135  1.00 36.77           C  
ATOM   1239  CZ  TYR A 161      27.356  30.789  71.209  1.00 37.76           C  
ATOM   1240  OH  TYR A 161      27.197  29.982  70.108  1.00 40.31           O  
ATOM   1241  N   LEU A 162      26.270  36.138  76.140  1.00 35.52           N  
ATOM   1242  CA  LEU A 162      26.325  36.916  77.370  1.00 36.71           C  
ATOM   1243  C   LEU A 162      25.176  37.874  77.453  1.00 39.88           C  
ATOM   1244  O   LEU A 162      25.291  38.917  78.051  1.00 34.60           O  
ATOM   1245  CB  LEU A 162      27.641  37.668  77.431  1.00 34.36           C  
ATOM   1246  CG  LEU A 162      28.863  36.771  77.608  1.00 32.30           C  
ATOM   1247  CD1 LEU A 162      30.140  37.552  77.502  1.00 33.32           C  
ATOM   1248  CD2 LEU A 162      28.786  36.036  78.936  1.00 31.06           C  
ATOM   1249  N   ARG A 163      24.049  37.486  76.867  1.00 45.77           N  
ATOM   1250  CA  ARG A 163      22.898  38.365  76.738  1.00 50.32           C  
ATOM   1251  C   ARG A 163      22.195  38.678  78.063  1.00 47.24           C  
ATOM   1252  O   ARG A 163      21.707  39.779  78.244  1.00 41.97           O  
ATOM   1253  CB  ARG A 163      21.913  37.800  75.696  1.00 55.21           C  
ATOM   1254  CG  ARG A 163      22.166  38.413  74.317  1.00 59.09           C  
ATOM   1255  CD  ARG A 163      21.522  37.636  73.213  1.00 62.80           C  
ATOM   1256  NE  ARG A 163      21.752  38.277  71.914  1.00 63.52           N  
ATOM   1257  CZ  ARG A 163      21.774  37.637  70.743  1.00 66.09           C  
ATOM   1258  NH1 ARG A 163      21.583  36.308  70.679  1.00 67.09           N  
ATOM   1259  NH2 ARG A 163      21.998  38.322  69.624  1.00 65.11           N  
ATOM   1260  N   GLU A 164      22.186  37.719  78.982  1.00 48.98           N  
ATOM   1261  CA  GLU A 164      21.528  37.890  80.280  1.00 52.27           C  
ATOM   1262  C   GLU A 164      22.215  38.963  81.153  1.00 49.40           C  
ATOM   1263  O   GLU A 164      21.541  39.832  81.700  1.00 50.13           O  
ATOM   1264  CB  GLU A 164      21.454  36.552  81.034  1.00 57.77           C  
ATOM   1265  CG  GLU A 164      20.808  35.394  80.226  1.00 61.49           C  
ATOM   1266  CD  GLU A 164      21.824  34.502  79.468  1.00 64.00           C  
ATOM   1267  OE1 GLU A 164      22.856  35.015  78.946  1.00 63.47           O  
ATOM   1268  OE2 GLU A 164      21.563  33.276  79.395  1.00 65.32           O  
ATOM   1269  N   ILE A 165      23.546  38.919  81.256  1.00 46.42           N  
ATOM   1270  CA  ILE A 165      24.294  39.965  81.974  1.00 43.33           C  
ATOM   1271  C   ILE A 165      24.190  41.312  81.259  1.00 41.03           C  
ATOM   1272  O   ILE A 165      24.011  42.322  81.915  1.00 36.47           O  
ATOM   1273  CB  ILE A 165      25.806  39.589  82.224  1.00 46.38           C  
ATOM   1274  CG1 ILE A 165      26.415  40.473  83.323  1.00 48.71           C  
ATOM   1275  CG2 ILE A 165      26.662  39.705  80.955  1.00 44.54           C  
ATOM   1276  N   ILE A 166      24.272  41.336  79.924  1.00 38.70           N  
ATOM   1277  CA  ILE A 166      24.191  42.604  79.188  1.00 41.52           C  
ATOM   1278  C   ILE A 166      22.821  43.274  79.377  1.00 44.76           C  
ATOM   1279  O   ILE A 166      22.727  44.509  79.384  1.00 48.09           O  
ATOM   1280  CB  ILE A 166      24.472  42.441  77.660  1.00 42.77           C  
ATOM   1281  CG1 ILE A 166      25.919  42.000  77.413  1.00 41.68           C  
ATOM   1282  CG2 ILE A 166      24.201  43.764  76.906  1.00 43.44           C  
ATOM   1283  CD1 ILE A 166      26.141  41.357  76.043  1.00 39.93           C  
ATOM   1284  N   GLU A 167      21.777  42.453  79.522  1.00 45.82           N  
ATOM   1285  CA  GLU A 167      20.412  42.938  79.797  1.00 46.42           C  
ATOM   1286  C   GLU A 167      20.270  43.453  81.251  1.00 44.58           C  
ATOM   1287  O   GLU A 167      19.605  44.437  81.474  1.00 41.24           O  
ATOM   1288  CB  GLU A 167      19.357  41.851  79.495  1.00 42.60           C  
ATOM   1289  N   GLU A 168      20.889  42.774  82.223  1.00 45.66           N  
ATOM   1290  CA  GLU A 168      20.918  43.265  83.607  1.00 44.62           C  
ATOM   1291  C   GLU A 168      21.522  44.663  83.644  1.00 43.29           C  
ATOM   1292  O   GLU A 168      21.010  45.544  84.330  1.00 44.71           O  
ATOM   1293  CB  GLU A 168      21.726  42.341  84.525  1.00 44.18           C  
ATOM   1294  CG  GLU A 168      21.082  41.014  84.860  1.00 44.94           C  
ATOM   1295  CD  GLU A 168      22.059  40.031  85.545  1.00 47.50           C  
ATOM   1296  OE1 GLU A 168      22.814  40.448  86.440  1.00 43.70           O  
ATOM   1297  OE2 GLU A 168      22.063  38.824  85.194  1.00 52.11           O  
ATOM   1298  N   VAL A 169      22.594  44.864  82.878  1.00 42.89           N  
ATOM   1299  CA  VAL A 169      23.328  46.132  82.870  1.00 43.42           C  
ATOM   1300  C   VAL A 169      22.477  47.246  82.232  1.00 47.80           C  
ATOM   1301  O   VAL A 169      22.417  48.373  82.755  1.00 48.12           O  
ATOM   1302  CB  VAL A 169      24.739  45.986  82.196  1.00 37.69           C  
ATOM   1303  CG1 VAL A 169      25.383  47.324  81.957  1.00 35.50           C  
ATOM   1304  CG2 VAL A 169      25.641  45.129  83.052  1.00 37.17           C  
ATOM   1305  N   ARG A 170      21.817  46.918  81.126  1.00 52.04           N  
ATOM   1306  CA  ARG A 170      20.851  47.814  80.500  1.00 54.82           C  
ATOM   1307  C   ARG A 170      19.738  48.194  81.494  1.00 54.03           C  
ATOM   1308  O   ARG A 170      19.346  49.352  81.571  1.00 53.97           O  
ATOM   1309  CB  ARG A 170      20.258  47.174  79.217  1.00 56.58           C  
ATOM   1310  CG  ARG A 170      19.623  48.205  78.252  1.00 58.31           C  
ATOM   1311  CD  ARG A 170      19.358  47.655  76.845  1.00 58.72           C  
ATOM   1312  NE  ARG A 170      20.537  47.737  75.956  1.00 61.17           N  
ATOM   1313  CZ  ARG A 170      21.142  46.699  75.350  1.00 59.89           C  
ATOM   1314  NH1 ARG A 170      20.697  45.453  75.505  1.00 59.26           N  
ATOM   1315  NH2 ARG A 170      22.204  46.913  74.571  1.00 58.26           N  
ATOM   1316  N   ARG A 171      19.269  47.214  82.272  1.00 55.41           N  
ATOM   1317  CA  ARG A 171      18.195  47.416  83.275  1.00 55.56           C  
ATOM   1318  C   ARG A 171      18.527  48.446  84.392  1.00 56.24           C  
ATOM   1319  O   ARG A 171      17.623  48.944  85.072  1.00 55.34           O  
ATOM   1320  CB  ARG A 171      17.774  46.070  83.903  1.00 54.98           C  
ATOM   1321  CG  ARG A 171      16.476  45.498  83.329  1.00 54.66           C  
ATOM   1322  N   LEU A 172      19.807  48.757  84.575  1.00 54.76           N  
ATOM   1323  CA  LEU A 172      20.214  49.821  85.497  1.00 53.65           C  
ATOM   1324  C   LEU A 172      19.813  51.176  84.886  1.00 53.47           C  
ATOM   1325  O   LEU A 172      20.464  52.192  85.097  1.00 52.37           O  
ATOM   1326  CB  LEU A 172      21.730  49.752  85.769  1.00 49.94           C  
ATOM   1327  CG  LEU A 172      22.290  48.412  86.267  1.00 47.81           C  
ATOM   1328  CD1 LEU A 172      23.795  48.389  86.185  1.00 47.32           C  
ATOM   1329  CD2 LEU A 172      21.832  48.079  87.669  1.00 47.46           C  
TER    1330      LEU A 172                                                      
END
MOLECULE T0470.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
