
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  161 ( 1231),  selected  161 , name 1xx7_D
# Molecule2: number of CA atoms  188 ( 1523),  selected  188 , name T0470.pdb
# PARAMETERS: 1xx7_D.T0470.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      T       2           -
LGA    -       -      K       3           -
LGA    -       -      Q       4           -
LGA    -       -      E       5           -
LGA    -       -      K       6           -
LGA    -       -      I       7           -
LGA    -       -      E       8           -
LGA    S     1_D      K       9           #
LGA    I     2_D      T      10           -
LGA    D     3_D      I      11           -
LGA    -       -      T      12           -
LGA    L     4_D      F      13          5.040
LGA    I     5_D      V      14           #
LGA    L     6_D      K      15           #
LGA    L     7_D      H      16          5.038
LGA    A     8_D      I      17          2.365
LGA    G     9_D      L      18          3.185
LGA    K    10_D      E      19          2.875
LGA    -       -      K      20           -
LGA    -       -      D      21           -
LGA    L    11_D      A      22           #
LGA    K    12_D      S      23          3.565
LGA    R    13_D      G      24          3.991
LGA    I    14_D      -       -           -
LGA    P    15_D      -       -           -
LGA    R    16_D      -       -           -
LGA    M    17_D      -       -           -
LGA    G    18_D      -       -           -
LGA    W    19_D      -       -           -
LGA    L    20_D      -       -           -
LGA    I    21_D      -       -           -
LGA    K    22_D      -       -           -
LGA    G    23_D      -       -           -
LGA    V    24_D      -       -           -
LGA    P    25_D      -       -           -
LGA    N    26_D      -       -           -
LGA    P    27_D      -       -           -
LGA    E    28_D      -       -           -
LGA    S    29_D      H      25          3.509
LGA    V    30_D      D      26          2.533
LGA    A    31_D      W      27          1.585
LGA    D    32_D      Y      28          1.892
LGA    H    33_D      H      29          1.120
LGA    S    34_D      I      30          0.519
LGA    Y    35_D      R      31          1.094
LGA    R    36_D      R      32          0.597
LGA    V    37_D      V      33          0.607
LGA    A    38_D      H      34          0.472
LGA    F    39_D      K      35          1.086
LGA    I    40_D      M      36          0.827
LGA    T    41_D      A      37          0.563
LGA    L    42_D      I      38          1.040
LGA    L    43_D      S      39          1.306
LGA    L    44_D      L      40          1.017
LGA    A    45_D      S      41          1.225
LGA    E    46_D      E      42          1.722
LGA    E    47_D      Q      43          2.204
LGA    L    48_D      E      44          1.654
LGA    K    49_D      -       -           -
LGA    K    50_D      -       -           -
LGA    K    51_D      -       -           -
LGA    G    52_D      -       -           -
LGA    V    53_D      -       -           -
LGA    E    54_D      G      45          3.391
LGA    I    55_D      G      46          1.099
LGA    D    56_D      N      47          0.839
LGA    V    57_D      R      48          1.301
LGA    E    58_D      F      49          1.625
LGA    K    59_D      I      50          1.253
LGA    A    60_D      I      51          0.565
LGA    L    61_D      E      52          0.812
LGA    K    62_D      M      53          0.884
LGA    I    63_D      A      54          0.591
LGA    A    64_D      A      55          0.993
LGA    I    65_D      L      56          0.973
LGA    I    66_D      L      57          0.967
LGA    H    67_D      H      58          1.168
LGA    D    68_D      D      59          0.612
LGA    L    69_D      V      60          1.144
LGA    G    70_D      A      61          1.919
LGA    E    71_D      D      62          4.052
LGA    A    72_D      -       -           -
LGA    I    73_D      -       -           -
LGA    I    74_D      -       -           -
LGA    T    75_D      L      65          1.252
LGA    D    76_D      N      66           #
LGA    L    77_D      E      67           -
LGA    P    78_D      -       -           -
LGA    L    79_D      -       -           -
LGA    S    80_D      -       -           -
LGA    A    81_D      -       -           -
LGA    Q    82_D      -       -           -
LGA    K    83_D      -       -           -
LGA    Y    84_D      -       -           -
LGA    L    85_D      -       -           -
LGA    N    86_D      -       -           -
LGA    K    87_D      -       -           -
LGA    E    88_D      -       -           -
LGA    E    89_D      S      68           #
LGA    A    90_D      E      69          1.433
LGA    E    91_D      -       -           -
LGA    A    92_D      E      70          3.723
LGA    K    93_D      A      71          2.681
LGA    A    94_D      G      72          1.741
LGA    L    95_D      M      73          3.031
LGA    K    96_D      K      74          0.829
LGA    D    97_D      K      75          3.587
LGA    V    98_D      V      76          5.075
LGA    L    99_D      S      77          3.364
LGA    P   100_D      D      78          2.871
LGA    E   101_D      W      79           #
LGA    -       -      L      80           -
LGA    -       -      E      81           -
LGA    -       -      E      82           -
LGA    -       -      L      83           -
LGA    -       -      H      84           -
LGA    -       -      V      85           -
LGA    -       -      E      86           -
LGA    -       -      E      87           -
LGA    -       -      E      88           -
LGA    -       -      E      89           -
LGA    Y   102_D      S      90          4.847
LGA    T   103_D      K      91           #
LGA    E   104_D      H      92          3.939
LGA    L   105_D      V      93          1.369
LGA    F   106_D      L      94          2.814
LGA    E   107_D      H      95          1.926
LGA    E   108_D      I      96          2.015
LGA    Y   109_D      I      97          3.833
LGA    S   110_D      A      98          3.084
LGA    K   111_D      N      99          2.953
LGA    A   112_D      M     100           #
LGA    L   113_D      -       -           -
LGA    T   114_D      S     112          1.433
LGA    L   115_D      I     113          0.888
LGA    E   116_D      E     114          0.945
LGA    G   117_D      G     115          0.882
LGA    Q   118_D      K     116          1.165
LGA    L   119_D      L     117          0.679
LGA    V   120_D      V     118          0.848
LGA    K   121_D      Q     119          0.918
LGA    I   122_D      D     120          1.069
LGA    A   123_D      A     121          0.827
LGA    D   124_D      D     122          0.697
LGA    K   125_D      R     123          0.795
LGA    L   126_D      L     124          0.796
LGA    D   127_D      D     125          0.961
LGA    M   128_D      A     126          2.129
LGA    I   129_D      L     127          2.311
LGA    I   130_D      G     128          3.224
LGA    -       -      A     129           -
LGA    Q   131_D      I     130          2.843
LGA    A   132_D      G     131          1.621
LGA    Y   133_D      I     132          2.073
LGA    E   134_D      A     133          3.191
LGA    Y   135_D      R     134          3.192
LGA    E   136_D      T     135          5.062
LGA    L   137_D      -       -           -
LGA    S   138_D      -       -           -
LGA    G   139_D      -       -           -
LGA    A   140_D      F     136          0.829
LGA    K   141_D      A     137           -
LGA    -       -      Y     138           -
LGA    N   142_D      G     139          4.947
LGA    -       -      G     140           -
LGA    -       -      A     141           -
LGA    -       -      K     142           -
LGA    -       -      G     143           -
LGA    -       -      R     144           -
LGA    -       -      L     145           -
LGA    -       -      M     146           -
LGA    -       -      Y     147           -
LGA    -       -      D     148           -
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    -       -      S     169           -
LGA    -       -      L     170           -
LGA    -       -      N     171           -
LGA    L   143_D      H     172          3.960
LGA    S   144_D      F     173          1.798
LGA    -       -      Y     174           -
LGA    -       -      E     175           -
LGA    E   145_D      K     176          2.922
LGA    F   146_D      L     177          3.778
LGA    -       -      L     178           -
LGA    -       -      K     179           -
LGA    -       -      L     180           -
LGA    -       -      K     181           -
LGA    -       -      D     182           -
LGA    -       -      L     183           -
LGA    E   157_D      M     184           #
LGA    I   158_D      N     185          3.120
LGA    S   159_D      T     186          2.904
LGA    R   160_D      N     187          4.128
LGA    Y   161_D      A     188          5.042
LGA    L   162_D      A     189          3.723
LGA    R   163_D      K     190          3.376
LGA    E   164_D      Q     191          2.081
LGA    I   165_D      E     192          1.219
LGA    I   166_D      A     193          1.979
LGA    E   167_D      E     194          1.044
LGA    E   168_D      V     195          0.585
LGA    V   169_D      R     196          1.212
LGA    R   170_D      H     197          1.521
LGA    R   171_D      R     198          0.951
LGA    -       -      Y     199           -
LGA    -       -      M     200           -
LGA    -       -      E     201           -
LGA    -       -      Q     202           -
LGA    -       -      F     203           -
LGA    -       -      I     204           -
LGA    -       -      E     205           -
LGA    -       -      Q     206           -
LGA    -       -      F     207           -
LGA    -       -      M     208           -
LGA    -       -      K     209           -
LGA    -       -      E     210           -
LGA    -       -      W     211           -
LGA    -       -      N     212           -
LGA    -       -      A     213           -
LGA    -       -      Q     214           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  161  188    5.0    108    2.44    18.52     38.392     4.246

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.028140 * X  +   0.333369 * Y  +   0.942376 * Z  +  10.436125
  Y_new =   0.205886 * X  +   0.924469 * Y  +  -0.320887 * Z  +   3.475298
  Z_new =  -0.978171 * X  +   0.184992 * Y  +  -0.094651 * Z  + 160.012344 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.043720   -1.097873  [ DEG:   117.0965    -62.9035 ]
  Theta =   1.361471    1.780121  [ DEG:    78.0066    101.9934 ]
  Phi   =   1.706634   -1.434958  [ DEG:    97.7829    -82.2171 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xx7_D                                        
REMARK     2: T0470.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xx7_D.T0470.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  161  188   5.0  108   2.44   18.52  38.392
REMARK  ---------------------------------------------------------- 
MOLECULE 1xx7_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   04-NOV-04   1XX7              
TITLE     CONSERVED HYPOTHETICAL PROTEIN FROM PYROCOCCUS FURIOSUS PFU-          
TITLE    2 403030-001                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: OXETANOCIN-LIKE PROTEIN;                                   
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS FURIOSUS;                            
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    PSI, SECSG, PROTEIN STRUCTURE INITIATIVE, SOUTHEAST                   
KEYWDS   2 COLLABORATORY FOR STRUCTURAL GENOMICS, PYROCOCCUS FURIOSUS,          
KEYWDS   3 CONSERVED HYPOTHETICAL PROTEIN, HYPERTHERMOPHILE                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    L.CHEN,W.TEMPEL,J.HABEL,W.ZHOU,D.NGUYEN,S.-H.CHANG,D.LEE,L.-          
AUTHOR   2 L.C.KELLEY,B.D.DILLARD,Z.-J.LIU,S.BRIDGER,J.C.ENEH,                  
AUTHOR   3 R.C.HOPKINS,F.E.JENNEY JR,H.-S.LEE,T.LI,F.L.POOLE II,C.SHAH,         
AUTHOR   4 F.J.SUGAR,M.W.W.ADAMS,W.B.ARENDALL III,J.S.RICHARDSON,               
AUTHOR   5 D.C.RICHARDSON,J.P.ROSE,B.-C.WANG,SOUTHEAST COLLABORATORY            
AUTHOR   6 FOR STRUCTURAL GENOMICS (SECSG)                                      
REVDAT   2   01-FEB-05 1XX7    1       AUTHOR                                   
REVDAT   1   28-DEC-04 1XX7    0                                                
JRNL        AUTH   L.CHEN,W.TEMPEL,J.HABEL,W.ZHOU,D.NGUYEN,S.-H.CHANG,          
JRNL        AUTH 2 D.LEE,L.-L.C.KELLEY,B.D.DILLARD,Z.-J.LIU,S.BRIDGER,          
JRNL        AUTH 3 J.C.ENEH,R.C.HOPKINS,F.E.JENNEY JR,H.-S.LEE,T.LI,            
JRNL        AUTH 4 F.L.POOLE II,C.SHAH,F.J.SUGAR,M.W.W.ADAMS,                   
JRNL        AUTH 5 W.B.ARENDALL III,J.S.RICHARDSON,D.C.RICHARDSON,              
JRNL        AUTH 6 J.P.ROSE,B.-C.WANG,                                          
JRNL        AUTH 7 SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS              
JRNL        TITL   CONSERVED HYPOTHETICAL PROTEIN FROM PYROCOCCUS               
JRNL        TITL 2 FURIOSUS PFU-403030-001                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.26 ANGSTROMS.                                          
DBREF  1XX7 A    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 B    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 C    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 D    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 E    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
DBREF  1XX7 F    2   176  UNP    Q8U3R1   Q8U3R1_PYRFU     2    176             
SEQRES   1 A  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 A  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 A  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 A  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 A  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 A  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 A  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 A  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 A  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 A  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 A  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 A  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 A  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 A  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 A  184  ASP HIS                                                      
SEQRES   1 B  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 B  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 B  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 B  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 B  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 B  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 B  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 B  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 B  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 B  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 B  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 B  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 B  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 B  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 B  184  ASP HIS                                                      
SEQRES   1 C  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 C  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 C  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 C  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 C  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 C  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 C  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 C  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 C  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 C  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 C  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 C  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 C  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 C  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 C  184  ASP HIS                                                      
SEQRES   1 D  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 D  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 D  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 D  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 D  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 D  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 D  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 D  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 D  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 D  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 D  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 D  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 D  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 D  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 D  184  ASP HIS                                                      
SEQRES   1 E  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 E  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 E  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 E  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 E  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 E  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 E  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 E  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 E  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 E  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 E  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 E  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 E  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 E  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 E  184  ASP HIS                                                      
SEQRES   1 F  184  ALA HIS HIS HIS HIS HIS HIS GLY SER ILE ASP LEU ILE          
SEQRES   2 F  184  LEU LEU ALA GLY LYS LEU LYS ARG ILE PRO ARG MET GLY          
SEQRES   3 F  184  TRP LEU ILE LYS GLY VAL PRO ASN PRO GLU SER VAL ALA          
SEQRES   4 F  184  ASP HIS SER TYR ARG VAL ALA PHE ILE THR LEU LEU LEU          
SEQRES   5 F  184  ALA GLU GLU LEU LYS LYS LYS GLY VAL GLU ILE ASP VAL          
SEQRES   6 F  184  GLU LYS ALA LEU LYS ILE ALA ILE ILE HIS ASP LEU GLY          
SEQRES   7 F  184  GLU ALA ILE ILE THR ASP LEU PRO LEU SER ALA GLN LYS          
SEQRES   8 F  184  TYR LEU ASN LYS GLU GLU ALA GLU ALA LYS ALA LEU LYS          
SEQRES   9 F  184  ASP VAL LEU PRO GLU TYR THR GLU LEU PHE GLU GLU TYR          
SEQRES  10 F  184  SER LYS ALA LEU THR LEU GLU GLY GLN LEU VAL LYS ILE          
SEQRES  11 F  184  ALA ASP LYS LEU ASP MET ILE ILE GLN ALA TYR GLU TYR          
SEQRES  12 F  184  GLU LEU SER GLY ALA LYS ASN LEU SER GLU PHE TRP ASN          
SEQRES  13 F  184  ALA LEU GLU ASP LEU GLU LYS LEU GLU ILE SER ARG TYR          
SEQRES  14 F  184  LEU ARG GLU ILE ILE GLU GLU VAL ARG ARG LEU LYS ASP          
SEQRES  15 F  184  ASP HIS                                                      
HET     NI  A 201       1                                                       
HET     NI  B 201       1                                                       
HET     NI  C 201       1                                                       
HET     NI  D 201       1                                                       
HET     NI  E 201       1                                                       
HET     NI  F 201       1                                                       
HET    UNX   2001       1                                                       
HET    UNX   2002       1                                                       
HET    UNX   2003       1                                                       
HET    UNX   2004       1                                                       
HET    UNX   2005       1                                                       
HET    UNX   2006       1                                                       
HET    UNX   2007       1                                                       
HET    UNX   2008       1                                                       
HET    UNX   2009       1                                                       
HET    UNX   2010       1                                                       
HET    UNX   2011       1                                                       
HET    UNX   2012       1                                                       
HET    UNX   2013       1                                                       
HET    UNX   2014       1                                                       
HET    UNX   2015       1                                                       
HET    UNX   2016       1                                                       
HET    UNX   2017       1                                                       
HET    UNX   2018       1                                                       
HET    UNX   2019       1                                                       
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     UNX UNKNOWN ATOM OR ION                                              
FORMUL   7   NI    6(NI 2+)                                                     
FORMUL  13  UNX    19(X1)                                                       
FORMUL  32  HOH   *69(H2 O)                                                     
CRYST1   98.073  111.335  125.984  90.00  90.00  90.00 P 21 21 21   24          
ATOM   3941  N   SER D   1      61.274  40.817  89.037  1.00 43.16           N  
ATOM   3942  CA  SER D   1      61.878  42.177  89.125  1.00 41.20           C  
ATOM   3943  C   SER D   1      61.013  43.144  89.946  1.00 38.59           C  
ATOM   3944  O   SER D   1      59.781  43.300  89.716  1.00 28.44           O  
ATOM   3945  CB  SER D   1      62.154  42.777  87.739  1.00 45.33           C  
ATOM   3946  OG  SER D   1      63.087  43.850  87.819  1.00 50.20           O  
ATOM   3947  N   ILE D   2      61.684  43.792  90.896  1.00 35.02           N  
ATOM   3948  CA  ILE D   2      61.099  44.825  91.712  1.00 37.00           C  
ATOM   3949  C   ILE D   2      60.753  46.066  90.864  1.00 30.96           C  
ATOM   3950  O   ILE D   2      59.794  46.734  91.155  1.00 30.95           O  
ATOM   3951  CB  ILE D   2      62.000  45.170  92.956  1.00 41.62           C  
ATOM   3952  CG1 ILE D   2      62.121  43.949  93.856  1.00 45.97           C  
ATOM   3953  CG2 ILE D   2      61.354  46.245  93.842  1.00 41.41           C  
ATOM   3954  N   ASP D   3      61.492  46.336  89.799  1.00 28.22           N  
ATOM   3955  CA  ASP D   3      61.176  47.484  88.945  1.00 30.81           C  
ATOM   3956  C   ASP D   3      59.775  47.364  88.332  1.00 28.70           C  
ATOM   3957  O   ASP D   3      59.023  48.342  88.329  1.00 27.03           O  
ATOM   3958  CB  ASP D   3      62.227  47.708  87.841  1.00 34.40           C  
ATOM   3959  CG  ASP D   3      63.542  48.318  88.385  1.00 40.90           C  
ATOM   3960  OD1 ASP D   3      63.539  48.966  89.476  1.00 41.51           O  
ATOM   3961  OD2 ASP D   3      64.587  48.145  87.712  1.00 46.29           O  
ATOM   3962  N   LEU D   4      59.435  46.167  87.851  1.00 25.20           N  
ATOM   3963  CA  LEU D   4      58.141  45.901  87.261  1.00 23.58           C  
ATOM   3964  C   LEU D   4      57.033  46.052  88.324  1.00 23.17           C  
ATOM   3965  O   LEU D   4      55.966  46.546  88.046  1.00 19.05           O  
ATOM   3966  CB  LEU D   4      58.117  44.484  86.639  1.00 24.21           C  
ATOM   3967  CG  LEU D   4      58.947  44.357  85.372  1.00 27.35           C  
ATOM   3968  CD1 LEU D   4      59.227  42.880  84.966  1.00 26.12           C  
ATOM   3969  CD2 LEU D   4      58.251  45.095  84.261  1.00 29.36           C  
ATOM   3970  N   ILE D   5      57.317  45.602  89.539  1.00 20.59           N  
ATOM   3971  CA  ILE D   5      56.372  45.654  90.613  1.00 21.08           C  
ATOM   3972  C   ILE D   5      56.181  47.095  91.037  1.00 21.00           C  
ATOM   3973  O   ILE D   5      55.078  47.504  91.288  1.00 20.06           O  
ATOM   3974  CB  ILE D   5      56.815  44.781  91.805  1.00 21.33           C  
ATOM   3975  CG1 ILE D   5      56.803  43.299  91.396  1.00 23.74           C  
ATOM   3976  CG2 ILE D   5      55.875  44.995  93.017  1.00 20.06           C  
ATOM   3977  CD1 ILE D   5      57.364  42.329  92.449  1.00 23.81           C  
ATOM   3978  N   LEU D   6      57.270  47.853  91.134  1.00 23.08           N  
ATOM   3979  CA  LEU D   6      57.150  49.287  91.308  1.00 28.38           C  
ATOM   3980  C   LEU D   6      56.339  49.959  90.179  1.00 26.00           C  
ATOM   3981  O   LEU D   6      55.439  50.777  90.462  1.00 23.22           O  
ATOM   3982  CB  LEU D   6      58.513  49.927  91.452  1.00 29.35           C  
ATOM   3983  CG  LEU D   6      59.207  49.512  92.751  1.00 33.88           C  
ATOM   3984  CD1 LEU D   6      60.660  49.984  92.699  1.00 35.87           C  
ATOM   3985  CD2 LEU D   6      58.506  50.040  94.016  1.00 33.91           C  
ATOM   3986  N   LEU D   7      56.632  49.584  88.931  1.00 23.62           N  
ATOM   3987  CA  LEU D   7      55.932  50.110  87.775  1.00 26.10           C  
ATOM   3988  C   LEU D   7      54.405  49.891  87.905  1.00 22.10           C  
ATOM   3989  O   LEU D   7      53.629  50.813  87.760  1.00 21.68           O  
ATOM   3990  CB  LEU D   7      56.493  49.487  86.495  1.00 28.59           C  
ATOM   3991  CG  LEU D   7      55.832  49.856  85.166  1.00 33.76           C  
ATOM   3992  CD1 LEU D   7      55.770  51.387  84.994  1.00 38.01           C  
ATOM   3993  CD2 LEU D   7      56.580  49.268  83.998  1.00 33.61           C  
ATOM   3994  N   ALA D   8      54.006  48.663  88.196  1.00 20.45           N  
ATOM   3995  CA  ALA D   8      52.605  48.314  88.431  1.00 22.17           C  
ATOM   3996  C   ALA D   8      51.960  49.066  89.624  1.00 21.76           C  
ATOM   3997  O   ALA D   8      50.773  49.362  89.587  1.00 20.77           O  
ATOM   3998  CB  ALA D   8      52.434  46.784  88.581  1.00 20.08           C  
ATOM   3999  N   GLY D   9      52.745  49.390  90.642  1.00 16.70           N  
ATOM   4000  CA  GLY D   9      52.267  50.214  91.761  1.00 17.86           C  
ATOM   4001  C   GLY D   9      51.771  51.623  91.409  1.00 19.05           C  
ATOM   4002  O   GLY D   9      50.866  52.170  92.058  1.00 19.07           O  
ATOM   4003  N   LYS D  10      52.371  52.201  90.389  1.00 19.81           N  
ATOM   4004  CA  LYS D  10      51.924  53.463  89.832  1.00 21.14           C  
ATOM   4005  C   LYS D  10      50.485  53.442  89.397  1.00 19.56           C  
ATOM   4006  O   LYS D  10      49.883  54.489  89.312  1.00 18.42           O  
ATOM   4007  CB  LYS D  10      52.736  53.818  88.610  1.00 17.88           C  
ATOM   4008  CG  LYS D  10      54.192  54.156  88.892  1.00 23.05           C  
ATOM   4009  CD  LYS D  10      54.820  54.625  87.591  1.00 21.51           C  
ATOM   4010  CE  LYS D  10      56.267  54.293  87.477  1.00 29.97           C  
ATOM   4011  NZ  LYS D  10      57.197  55.363  87.793  1.00 22.43           N  
ATOM   4012  N   LEU D  11      49.959  52.263  89.071  1.00 19.41           N  
ATOM   4013  CA  LEU D  11      48.563  52.136  88.761  1.00 20.86           C  
ATOM   4014  C   LEU D  11      47.660  52.414  89.984  1.00 20.20           C  
ATOM   4015  O   LEU D  11      46.497  52.814  89.816  1.00 16.99           O  
ATOM   4016  CB  LEU D  11      48.283  50.776  88.123  1.00 20.58           C  
ATOM   4017  CG  LEU D  11      48.871  50.507  86.713  1.00 18.81           C  
ATOM   4018  CD1 LEU D  11      48.249  49.212  86.094  1.00 22.50           C  
ATOM   4019  CD2 LEU D  11      48.704  51.693  85.739  1.00 21.15           C  
ATOM   4020  N   LYS D  12      48.194  52.223  91.202  1.00 15.08           N  
ATOM   4021  CA  LYS D  12      47.412  52.480  92.393  1.00 16.69           C  
ATOM   4022  C   LYS D  12      47.184  54.014  92.551  1.00 19.74           C  
ATOM   4023  O   LYS D  12      46.271  54.425  93.236  1.00 24.79           O  
ATOM   4024  CB  LYS D  12      48.050  51.875  93.655  1.00 14.63           C  
ATOM   4025  CG  LYS D  12      48.501  50.393  93.539  1.00 13.66           C  
ATOM   4026  CD  LYS D  12      49.011  49.941  94.894  1.00 12.56           C  
ATOM   4027  CE  LYS D  12      49.418  48.489  95.002  1.00 11.75           C  
ATOM   4028  NZ  LYS D  12      49.637  48.149  96.453  1.00 10.10           N  
ATOM   4029  N   ARG D  13      47.986  54.822  91.863  1.00 17.44           N  
ATOM   4030  CA  ARG D  13      47.997  56.275  92.023  1.00 20.40           C  
ATOM   4031  C   ARG D  13      47.518  57.019  90.781  1.00 19.30           C  
ATOM   4032  O   ARG D  13      47.087  58.138  90.882  1.00 24.55           O  
ATOM   4033  CB  ARG D  13      49.436  56.739  92.354  1.00 21.95           C  
ATOM   4034  CG  ARG D  13      49.894  56.252  93.716  1.00 24.66           C  
ATOM   4035  CD  ARG D  13      51.220  56.850  94.123  1.00 26.69           C  
ATOM   4036  NE  ARG D  13      52.297  56.489  93.211  1.00 26.26           N  
ATOM   4037  CZ  ARG D  13      52.897  55.297  93.203  1.00 30.58           C  
ATOM   4038  NH1 ARG D  13      52.503  54.307  94.004  1.00 31.38           N  
ATOM   4039  NH2 ARG D  13      53.882  55.066  92.351  1.00 36.17           N  
ATOM   4040  N   ILE D  14      47.611  56.385  89.621  1.00 18.42           N  
ATOM   4041  CA  ILE D  14      47.215  56.991  88.361  1.00 21.59           C  
ATOM   4042  C   ILE D  14      45.688  56.954  88.243  1.00 19.86           C  
ATOM   4043  O   ILE D  14      45.069  55.876  88.270  1.00 21.05           O  
ATOM   4044  CB  ILE D  14      47.946  56.299  87.161  1.00 22.91           C  
ATOM   4045  CG1 ILE D  14      49.426  56.753  87.186  1.00 22.45           C  
ATOM   4046  CG2 ILE D  14      47.326  56.678  85.857  1.00 26.38           C  
ATOM   4047  CD1 ILE D  14      50.314  55.933  86.343  1.00 20.12           C  
ATOM   4048  N   PRO D  15      45.076  58.141  88.135  1.00 20.83           N  
ATOM   4049  CA  PRO D  15      43.656  58.174  88.092  1.00 18.39           C  
ATOM   4050  C   PRO D  15      43.075  57.855  86.701  1.00 18.40           C  
ATOM   4051  O   PRO D  15      43.698  58.111  85.641  1.00 19.87           O  
ATOM   4052  CB  PRO D  15      43.328  59.613  88.546  1.00 19.29           C  
ATOM   4053  CG  PRO D  15      44.461  60.415  88.114  1.00 20.21           C  
ATOM   4054  CD  PRO D  15      45.661  59.506  88.047  1.00 21.77           C  
ATOM   4055  N   ARG D  16      41.886  57.265  86.749  1.00 19.23           N  
ATOM   4056  CA  ARG D  16      41.020  57.179  85.616  1.00 19.51           C  
ATOM   4057  C   ARG D  16      40.475  58.570  85.316  1.00 19.41           C  
ATOM   4058  O   ARG D  16      39.543  59.059  85.978  1.00 16.26           O  
ATOM   4059  CB  ARG D  16      39.933  56.164  85.878  1.00 16.18           C  
ATOM   4060  CG  ARG D  16      40.518  54.759  86.154  1.00 19.10           C  
ATOM   4061  CD  ARG D  16      40.557  53.910  84.876  1.00 20.92           C  
ATOM   4062  NE  ARG D  16      39.182  53.629  84.465  1.00 23.45           N  
ATOM   4063  CZ  ARG D  16      38.773  53.252  83.256  1.00 23.22           C  
ATOM   4064  NH1 ARG D  16      37.476  53.053  83.052  1.00 21.00           N  
ATOM   4065  NH2 ARG D  16      39.627  53.091  82.256  1.00 23.76           N  
ATOM   4066  N   MET D  17      41.086  59.175  84.287  1.00 22.92           N  
ATOM   4067  CA  MET D  17      40.953  60.601  83.944  1.00 25.45           C  
ATOM   4068  C   MET D  17      39.624  61.005  83.380  1.00 20.06           C  
ATOM   4069  O   MET D  17      39.218  62.129  83.579  1.00 20.01           O  
ATOM   4070  CB  MET D  17      42.060  61.023  82.961  1.00 28.29           C  
ATOM   4071  CG  MET D  17      43.407  61.224  83.649  1.00 37.08           C  
ATOM   4072  SD  MET D  17      43.540  62.716  84.721  1.00 40.20           S  
ATOM   4073  CE  MET D  17      42.661  63.863  83.752  1.00 35.70           C  
ATOM   4074  N   GLY D  18      38.949  60.121  82.661  1.00 18.47           N  
ATOM   4075  CA  GLY D  18      37.597  60.421  82.220  1.00 20.91           C  
ATOM   4076  C   GLY D  18      36.727  60.974  83.370  1.00 20.77           C  
ATOM   4077  O   GLY D  18      36.150  62.035  83.256  1.00 23.62           O  
ATOM   4078  N   TRP D  19      36.679  60.248  84.480  1.00 16.39           N  
ATOM   4079  CA  TRP D  19      35.849  60.607  85.613  1.00 17.90           C  
ATOM   4080  C   TRP D  19      36.306  61.921  86.221  1.00 19.38           C  
ATOM   4081  O   TRP D  19      35.479  62.840  86.497  1.00 18.67           O  
ATOM   4082  CB  TRP D  19      35.904  59.543  86.710  1.00 16.96           C  
ATOM   4083  CG  TRP D  19      35.736  58.127  86.314  1.00 16.61           C  
ATOM   4084  CD1 TRP D  19      36.617  57.092  86.581  1.00 18.77           C  
ATOM   4085  CD2 TRP D  19      34.598  57.521  85.646  1.00 21.10           C  
ATOM   4086  NE1 TRP D  19      36.097  55.901  86.115  1.00 19.16           N  
ATOM   4087  CE2 TRP D  19      34.871  56.135  85.530  1.00 15.37           C  
ATOM   4088  CE3 TRP D  19      33.373  58.026  85.121  1.00 19.23           C  
ATOM   4089  CZ2 TRP D  19      33.987  55.253  84.923  1.00 17.59           C  
ATOM   4090  CZ3 TRP D  19      32.509  57.144  84.508  1.00 17.59           C  
ATOM   4091  CH2 TRP D  19      32.810  55.770  84.421  1.00 18.42           C  
ATOM   4092  N   LEU D  20      37.627  62.019  86.410  1.00 18.72           N  
ATOM   4093  CA  LEU D  20      38.270  63.209  86.997  1.00 21.58           C  
ATOM   4094  C   LEU D  20      37.882  64.491  86.237  1.00 20.58           C  
ATOM   4095  O   LEU D  20      37.554  65.527  86.818  1.00 23.92           O  
ATOM   4096  CB  LEU D  20      39.804  62.982  87.022  1.00 23.94           C  
ATOM   4097  CG  LEU D  20      40.707  63.878  87.842  1.00 27.79           C  
ATOM   4098  CD1 LEU D  20      42.047  63.197  88.122  1.00 29.81           C  
ATOM   4099  CD2 LEU D  20      40.901  65.139  87.126  1.00 30.70           C  
ATOM   4100  N   ILE D  21      37.875  64.391  84.934  1.00 22.74           N  
ATOM   4101  CA  ILE D  21      37.585  65.515  84.096  1.00 30.00           C  
ATOM   4102  C   ILE D  21      36.085  65.880  84.156  1.00 30.58           C  
ATOM   4103  O   ILE D  21      35.743  67.063  84.041  1.00 27.46           O  
ATOM   4104  CB  ILE D  21      38.131  65.280  82.649  1.00 33.51           C  
ATOM   4105  CG1 ILE D  21      39.657  65.477  82.682  1.00 35.19           C  
ATOM   4106  CG2 ILE D  21      37.480  66.233  81.634  1.00 37.10           C  
ATOM   4107  CD1 ILE D  21      40.339  65.310  81.410  1.00 37.61           C  
ATOM   4108  N   LYS D  22      35.225  64.877  84.378  1.00 24.68           N  
ATOM   4109  CA  LYS D  22      33.807  65.115  84.554  1.00 23.41           C  
ATOM   4110  C   LYS D  22      33.457  65.784  85.905  1.00 24.30           C  
ATOM   4111  O   LYS D  22      32.394  66.336  86.027  1.00 27.33           O  
ATOM   4112  CB  LYS D  22      33.017  63.851  84.334  1.00 23.56           C  
ATOM   4113  CG  LYS D  22      33.018  63.393  82.874  1.00 26.23           C  
ATOM   4114  CD  LYS D  22      32.268  64.390  81.982  1.00 30.93           C  
ATOM   4115  CE  LYS D  22      31.963  63.840  80.596  1.00 34.24           C  
ATOM   4116  NZ  LYS D  22      30.563  64.233  80.251  1.00 39.05           N  
ATOM   4117  N   GLY D  23      34.385  65.762  86.870  1.00 22.10           N  
ATOM   4118  CA  GLY D  23      34.235  66.383  88.179  1.00 16.11           C  
ATOM   4119  C   GLY D  23      33.914  65.388  89.295  1.00 15.38           C  
ATOM   4120  O   GLY D  23      33.568  65.772  90.404  1.00 22.26           O  
ATOM   4121  N   VAL D  24      33.956  64.106  88.988  1.00 14.49           N  
ATOM   4122  CA  VAL D  24      33.888  63.068  90.031  1.00 17.72           C  
ATOM   4123  C   VAL D  24      35.008  63.286  91.037  1.00 14.76           C  
ATOM   4124  O   VAL D  24      36.155  63.318  90.641  1.00 21.81           O  
ATOM   4125  CB  VAL D  24      34.035  61.669  89.422  1.00 17.40           C  
ATOM   4126  CG1 VAL D  24      34.027  60.617  90.521  1.00 17.19           C  
ATOM   4127  CG2 VAL D  24      32.949  61.436  88.436  1.00 18.78           C  
ATOM   4128  N   PRO D  25      34.679  63.497  92.327  1.00 22.62           N  
ATOM   4129  CA  PRO D  25      35.718  64.020  93.260  1.00 27.30           C  
ATOM   4130  C   PRO D  25      36.855  63.088  93.753  1.00 30.35           C  
ATOM   4131  O   PRO D  25      37.996  63.581  93.975  1.00 33.24           O  
ATOM   4132  CB  PRO D  25      34.872  64.551  94.463  1.00 27.81           C  
ATOM   4133  CG  PRO D  25      33.618  63.738  94.430  1.00 22.56           C  
ATOM   4134  CD  PRO D  25      33.335  63.434  92.972  1.00 18.37           C  
ATOM   4135  N   ASN D  26      36.568  61.801  93.957  1.00 27.49           N  
ATOM   4136  CA  ASN D  26      37.629  60.835  94.318  1.00 29.14           C  
ATOM   4137  C   ASN D  26      37.653  59.670  93.295  1.00 24.12           C  
ATOM   4138  O   ASN D  26      37.268  58.567  93.618  1.00 18.62           O  
ATOM   4139  CB  ASN D  26      37.425  60.253  95.737  1.00 29.06           C  
ATOM   4140  N   PRO D  27      38.086  59.937  92.066  1.00 19.45           N  
ATOM   4141  CA  PRO D  27      37.948  58.953  90.996  1.00 20.26           C  
ATOM   4142  C   PRO D  27      38.801  57.696  91.262  1.00 20.78           C  
ATOM   4143  O   PRO D  27      39.912  57.806  91.776  1.00 16.94           O  
ATOM   4144  CB  PRO D  27      38.457  59.712  89.766  1.00 22.04           C  
ATOM   4145  CG  PRO D  27      39.401  60.699  90.285  1.00 22.91           C  
ATOM   4146  CD  PRO D  27      38.822  61.135  91.627  1.00 22.64           C  
ATOM   4147  N   GLU D  28      38.253  56.517  90.977  1.00 19.15           N  
ATOM   4148  CA  GLU D  28      39.047  55.282  90.959  1.00 17.40           C  
ATOM   4149  C   GLU D  28      40.402  55.434  90.243  1.00 15.91           C  
ATOM   4150  O   GLU D  28      40.578  56.237  89.300  1.00 16.31           O  
ATOM   4151  CB  GLU D  28      38.283  54.148  90.294  1.00 14.61           C  
ATOM   4152  CG  GLU D  28      37.906  54.436  88.845  1.00 17.39           C  
ATOM   4153  CD  GLU D  28      37.600  53.186  88.057  1.00 15.86           C  
ATOM   4154  OE1 GLU D  28      37.635  52.104  88.654  1.00 17.33           O  
ATOM   4155  OE2 GLU D  28      37.343  53.276  86.840  1.00 16.67           O  
ATOM   4156  N   SER D  29      41.356  54.655  90.722  1.00 20.14           N  
ATOM   4157  CA  SER D  29      42.655  54.514  90.070  1.00 19.51           C  
ATOM   4158  C   SER D  29      42.570  53.503  88.921  1.00 19.17           C  
ATOM   4159  O   SER D  29      41.606  52.732  88.811  1.00 12.34           O  
ATOM   4160  CB  SER D  29      43.682  54.076  91.111  1.00 18.55           C  
ATOM   4161  OG  SER D  29      43.449  52.730  91.517  1.00 16.62           O  
ATOM   4162  N   VAL D  30      43.574  53.516  88.055  1.00 16.34           N  
ATOM   4163  CA  VAL D  30      43.692  52.483  87.016  1.00 15.83           C  
ATOM   4164  C   VAL D  30      43.794  51.054  87.580  1.00 13.86           C  
ATOM   4165  O   VAL D  30      43.215  50.164  87.007  1.00 18.57           O  
ATOM   4166  CB  VAL D  30      44.896  52.743  86.072  1.00 16.87           C  
ATOM   4167  CG1 VAL D  30      45.051  51.615  85.046  1.00 16.16           C  
ATOM   4168  CG2 VAL D  30      44.728  54.079  85.353  1.00 18.27           C  
ATOM   4169  N   ALA D  31      44.556  50.846  88.665  1.00 14.50           N  
ATOM   4170  CA  ALA D  31      44.536  49.581  89.426  1.00 18.36           C  
ATOM   4171  C   ALA D  31      43.142  49.147  89.873  1.00 20.21           C  
ATOM   4172  O   ALA D  31      42.763  47.975  89.710  1.00 17.79           O  
ATOM   4173  CB  ALA D  31      45.480  49.648  90.661  1.00 19.23           C  
ATOM   4174  N   ASP D  32      42.375  50.075  90.438  1.00 20.78           N  
ATOM   4175  CA  ASP D  32      40.993  49.766  90.903  1.00 18.54           C  
ATOM   4176  C   ASP D  32      40.175  49.195  89.754  1.00 14.84           C  
ATOM   4177  O   ASP D  32      39.438  48.193  89.870  1.00 14.88           O  
ATOM   4178  CB  ASP D  32      40.259  51.030  91.365  1.00 17.85           C  
ATOM   4179  CG  ASP D  32      40.642  51.483  92.748  1.00 18.91           C  
ATOM   4180  OD1 ASP D  32      40.914  50.644  93.645  1.00 17.63           O  
ATOM   4181  OD2 ASP D  32      40.664  52.732  92.932  1.00 16.16           O  
ATOM   4182  N   HIS D  33      40.235  49.942  88.673  1.00 16.28           N  
ATOM   4183  CA  HIS D  33      39.609  49.600  87.459  1.00 16.99           C  
ATOM   4184  C   HIS D  33      40.088  48.217  86.942  1.00 18.92           C  
ATOM   4185  O   HIS D  33      39.267  47.347  86.719  1.00 14.65           O  
ATOM   4186  CB  HIS D  33      39.841  50.693  86.442  1.00 18.89           C  
ATOM   4187  CG  HIS D  33      39.641  50.237  85.039  1.00 18.54           C  
ATOM   4188  ND1 HIS D  33      38.409  49.918  84.544  1.00 19.91           N  
ATOM   4189  CD2 HIS D  33      40.521  49.992  84.049  1.00 17.23           C  
ATOM   4190  CE1 HIS D  33      38.528  49.505  83.299  1.00 16.20           C  
ATOM   4191  NE2 HIS D  33      39.798  49.541  82.977  1.00 15.27           N  
ATOM   4192  N   SER D  34      41.402  48.028  86.812  1.00 17.57           N  
ATOM   4193  CA  SER D  34      41.944  46.766  86.368  1.00 17.67           C  
ATOM   4194  C   SER D  34      41.616  45.596  87.266  1.00 19.39           C  
ATOM   4195  O   SER D  34      41.402  44.505  86.748  1.00 16.61           O  
ATOM   4196  CB  SER D  34      43.473  46.847  86.174  1.00 19.03           C  
ATOM   4197  OG  SER D  34      43.827  47.766  85.183  1.00 22.22           O  
ATOM   4198  N   TYR D  35      41.596  45.794  88.603  1.00 19.06           N  
ATOM   4199  CA  TYR D  35      41.119  44.773  89.489  1.00 14.21           C  
ATOM   4200  C   TYR D  35      39.713  44.260  89.064  1.00 19.16           C  
ATOM   4201  O   TYR D  35      39.483  43.025  88.946  1.00 16.70           O  
ATOM   4202  CB  TYR D  35      41.105  45.166  90.984  1.00 18.13           C  
ATOM   4203  CG  TYR D  35      40.371  44.063  91.772  1.00 16.32           C  
ATOM   4204  CD1 TYR D  35      41.042  42.897  92.114  1.00 16.03           C  
ATOM   4205  CD2 TYR D  35      38.987  44.144  92.046  1.00 15.66           C  
ATOM   4206  CE1 TYR D  35      40.409  41.865  92.738  1.00 19.34           C  
ATOM   4207  CE2 TYR D  35      38.332  43.111  92.650  1.00 15.88           C  
ATOM   4208  CZ  TYR D  35      39.054  41.950  93.024  1.00 20.27           C  
ATOM   4209  OH  TYR D  35      38.430  40.852  93.647  1.00 20.90           O  
ATOM   4210  N   ARG D  36      38.762  45.173  88.856  1.00 19.03           N  
ATOM   4211  CA  ARG D  36      37.405  44.710  88.565  1.00 19.91           C  
ATOM   4212  C   ARG D  36      37.256  44.146  87.141  1.00 19.78           C  
ATOM   4213  O   ARG D  36      36.455  43.241  86.937  1.00 16.81           O  
ATOM   4214  CB  ARG D  36      36.316  45.730  88.879  1.00 21.19           C  
ATOM   4215  CG  ARG D  36      34.928  45.031  89.056  1.00 22.58           C  
ATOM   4216  CD  ARG D  36      33.818  45.892  89.624  1.00 17.17           C  
ATOM   4217  NE  ARG D  36      33.432  47.015  88.789  1.00 18.22           N  
ATOM   4218  CZ  ARG D  36      32.490  47.890  89.128  1.00 16.03           C  
ATOM   4219  NH1 ARG D  36      31.793  47.725  90.245  1.00 20.73           N  
ATOM   4220  NH2 ARG D  36      32.237  48.916  88.355  1.00 16.41           N  
ATOM   4221  N   VAL D  37      38.056  44.633  86.185  1.00 20.16           N  
ATOM   4222  CA  VAL D  37      38.103  44.025  84.857  1.00 17.32           C  
ATOM   4223  C   VAL D  37      38.588  42.555  84.994  1.00 17.11           C  
ATOM   4224  O   VAL D  37      38.011  41.692  84.402  1.00 17.13           O  
ATOM   4225  CB  VAL D  37      38.974  44.822  83.868  1.00 19.20           C  
ATOM   4226  CG1 VAL D  37      39.035  44.114  82.531  1.00 21.81           C  
ATOM   4227  CG2 VAL D  37      38.454  46.204  83.677  1.00 19.59           C  
ATOM   4228  N   ALA D  38      39.640  42.297  85.783  1.00 17.39           N  
ATOM   4229  CA  ALA D  38      40.092  40.940  86.046  1.00 21.41           C  
ATOM   4230  C   ALA D  38      38.973  40.078  86.654  1.00 23.78           C  
ATOM   4231  O   ALA D  38      38.765  38.922  86.233  1.00 17.26           O  
ATOM   4232  CB  ALA D  38      41.323  40.921  86.948  1.00 23.48           C  
ATOM   4233  N   PHE D  39      38.248  40.641  87.630  1.00 22.91           N  
ATOM   4234  CA  PHE D  39      37.136  39.916  88.263  1.00 21.44           C  
ATOM   4235  C   PHE D  39      35.963  39.621  87.308  1.00 22.73           C  
ATOM   4236  O   PHE D  39      35.372  38.534  87.348  1.00 18.30           O  
ATOM   4237  CB  PHE D  39      36.643  40.684  89.509  1.00 24.45           C  
ATOM   4238  CG  PHE D  39      35.397  40.133  90.107  1.00 23.80           C  
ATOM   4239  CD1 PHE D  39      35.460  39.079  91.009  1.00 28.92           C  
ATOM   4240  CD2 PHE D  39      34.156  40.642  89.754  1.00 28.12           C  
ATOM   4241  CE1 PHE D  39      34.311  38.533  91.549  1.00 28.83           C  
ATOM   4242  CE2 PHE D  39      32.982  40.108  90.300  1.00 28.91           C  
ATOM   4243  CZ  PHE D  39      33.067  39.050  91.202  1.00 27.99           C  
ATOM   4244  N   ILE D  40      35.583  40.626  86.517  1.00 22.04           N  
ATOM   4245  CA  ILE D  40      34.555  40.473  85.535  1.00 21.53           C  
ATOM   4246  C   ILE D  40      34.970  39.462  84.458  1.00 22.25           C  
ATOM   4247  O   ILE D  40      34.181  38.634  84.058  1.00 23.43           O  
ATOM   4248  CB  ILE D  40      34.219  41.800  84.889  1.00 21.82           C  
ATOM   4249  CG1 ILE D  40      33.504  42.693  85.901  1.00 22.28           C  
ATOM   4250  CG2 ILE D  40      33.295  41.591  83.679  1.00 21.34           C  
ATOM   4251  CD1 ILE D  40      33.360  44.103  85.447  1.00 22.46           C  
ATOM   4252  N   THR D  41      36.204  39.557  83.999  1.00 22.96           N  
ATOM   4253  CA  THR D  41      36.765  38.582  83.047  1.00 27.26           C  
ATOM   4254  C   THR D  41      36.637  37.106  83.559  1.00 28.34           C  
ATOM   4255  O   THR D  41      36.196  36.224  82.831  1.00 24.47           O  
ATOM   4256  CB  THR D  41      38.224  38.926  82.718  1.00 23.89           C  
ATOM   4257  OG1 THR D  41      38.270  40.210  82.099  1.00 22.38           O  
ATOM   4258  CG2 THR D  41      38.833  37.893  81.788  1.00 24.43           C  
ATOM   4259  N   LEU D  42      36.989  36.877  84.818  1.00 27.02           N  
ATOM   4260  CA  LEU D  42      36.817  35.590  85.439  1.00 29.76           C  
ATOM   4261  C   LEU D  42      35.355  35.099  85.422  1.00 32.91           C  
ATOM   4262  O   LEU D  42      35.080  33.947  85.061  1.00 32.17           O  
ATOM   4263  CB  LEU D  42      37.292  35.663  86.879  1.00 31.82           C  
ATOM   4264  CG  LEU D  42      37.161  34.400  87.726  1.00 35.51           C  
ATOM   4265  CD1 LEU D  42      38.032  33.267  87.151  1.00 38.28           C  
ATOM   4266  CD2 LEU D  42      37.562  34.705  89.139  1.00 37.52           C  
ATOM   4267  N   LEU D  43      34.450  35.968  85.855  1.00 27.59           N  
ATOM   4268  CA  LEU D  43      33.049  35.635  86.015  1.00 31.12           C  
ATOM   4269  C   LEU D  43      32.430  35.268  84.666  1.00 31.40           C  
ATOM   4270  O   LEU D  43      31.704  34.275  84.566  1.00 26.30           O  
ATOM   4271  CB  LEU D  43      32.308  36.833  86.637  1.00 34.06           C  
ATOM   4272  CG  LEU D  43      31.279  36.594  87.717  1.00 40.51           C  
ATOM   4273  CD1 LEU D  43      31.857  35.737  88.868  1.00 43.21           C  
ATOM   4274  CD2 LEU D  43      30.744  37.955  88.238  1.00 39.78           C  
ATOM   4275  N   LEU D  44      32.741  36.082  83.645  1.00 28.48           N  
ATOM   4276  CA  LEU D  44      32.268  35.892  82.294  1.00 28.53           C  
ATOM   4277  C   LEU D  44      32.873  34.656  81.598  1.00 28.27           C  
ATOM   4278  O   LEU D  44      32.156  33.935  80.901  1.00 26.09           O  
ATOM   4279  CB  LEU D  44      32.530  37.131  81.437  1.00 30.62           C  
ATOM   4280  CG  LEU D  44      31.827  38.461  81.781  1.00 33.52           C  
ATOM   4281  CD1 LEU D  44      32.146  39.530  80.743  1.00 33.86           C  
ATOM   4282  CD2 LEU D  44      30.344  38.292  81.927  1.00 34.65           C  
ATOM   4283  N   ALA D  45      34.169  34.425  81.771  1.00 26.90           N  
ATOM   4284  CA  ALA D  45      34.819  33.195  81.286  1.00 28.36           C  
ATOM   4285  C   ALA D  45      34.112  31.945  81.832  1.00 30.99           C  
ATOM   4286  O   ALA D  45      33.835  31.025  81.093  1.00 31.87           O  
ATOM   4287  CB  ALA D  45      36.313  33.173  81.622  1.00 24.08           C  
ATOM   4288  N   GLU D  46      33.754  31.950  83.103  1.00 36.28           N  
ATOM   4289  CA  GLU D  46      33.011  30.836  83.679  1.00 42.18           C  
ATOM   4290  C   GLU D  46      31.569  30.682  83.128  1.00 40.37           C  
ATOM   4291  O   GLU D  46      31.024  29.573  83.069  1.00 38.97           O  
ATOM   4292  CB  GLU D  46      33.027  30.940  85.209  1.00 47.50           C  
ATOM   4293  CG  GLU D  46      34.475  30.795  85.785  1.00 53.80           C  
ATOM   4294  CD  GLU D  46      35.189  29.503  85.319  1.00 56.66           C  
ATOM   4295  OE1 GLU D  46      34.616  28.398  85.543  1.00 57.44           O  
ATOM   4296  OE2 GLU D  46      36.302  29.598  84.726  1.00 57.01           O  
ATOM   4297  N   GLU D  47      30.970  31.785  82.720  1.00 38.62           N  
ATOM   4298  CA  GLU D  47      29.688  31.741  82.031  1.00 40.18           C  
ATOM   4299  C   GLU D  47      29.864  31.168  80.614  1.00 38.11           C  
ATOM   4300  O   GLU D  47      29.048  30.370  80.175  1.00 36.07           O  
ATOM   4301  CB  GLU D  47      29.031  33.141  82.031  1.00 45.78           C  
ATOM   4302  CG  GLU D  47      27.684  33.241  81.337  1.00 51.90           C  
ATOM   4303  CD  GLU D  47      26.642  32.186  81.808  1.00 57.31           C  
ATOM   4304  OE1 GLU D  47      26.545  31.908  83.038  1.00 58.15           O  
ATOM   4305  OE2 GLU D  47      25.914  31.652  80.926  1.00 59.90           O  
ATOM   4306  N   LEU D  48      30.936  31.548  79.914  1.00 36.44           N  
ATOM   4307  CA  LEU D  48      31.222  30.972  78.609  1.00 38.91           C  
ATOM   4308  C   LEU D  48      31.419  29.455  78.706  1.00 41.66           C  
ATOM   4309  O   LEU D  48      30.845  28.696  77.900  1.00 40.17           O  
ATOM   4310  CB  LEU D  48      32.459  31.590  77.965  1.00 37.25           C  
ATOM   4311  CG  LEU D  48      32.377  33.059  77.558  1.00 40.66           C  
ATOM   4312  CD1 LEU D  48      33.687  33.472  76.919  1.00 42.97           C  
ATOM   4313  CD2 LEU D  48      31.212  33.372  76.641  1.00 40.61           C  
ATOM   4314  N   LYS D  49      32.230  29.038  79.683  1.00 43.33           N  
ATOM   4315  CA  LYS D  49      32.433  27.616  80.036  1.00 46.86           C  
ATOM   4316  C   LYS D  49      31.096  26.844  80.268  1.00 45.86           C  
ATOM   4317  O   LYS D  49      30.901  25.782  79.690  1.00 45.17           O  
ATOM   4318  CB  LYS D  49      33.347  27.522  81.275  1.00 51.02           C  
ATOM   4319  CG  LYS D  49      33.902  26.127  81.585  1.00 55.86           C  
ATOM   4320  CD  LYS D  49      33.713  25.722  83.077  1.00 57.36           C  
ATOM   4321  N   LYS D  50      30.196  27.390  81.090  1.00 44.21           N  
ATOM   4322  CA  LYS D  50      28.834  26.833  81.298  1.00 46.39           C  
ATOM   4323  C   LYS D  50      28.044  26.572  79.993  1.00 44.77           C  
ATOM   4324  O   LYS D  50      27.210  25.652  79.923  1.00 43.27           O  
ATOM   4325  CB  LYS D  50      27.973  27.771  82.180  1.00 47.30           C  
ATOM   4326  CG  LYS D  50      28.057  27.523  83.686  1.00 50.30           C  
ATOM   4327  N   LYS D  51      28.281  27.425  79.004  1.00 40.26           N  
ATOM   4328  CA  LYS D  51      27.680  27.312  77.690  1.00 37.91           C  
ATOM   4329  C   LYS D  51      28.485  26.401  76.754  1.00 32.46           C  
ATOM   4330  O   LYS D  51      28.100  26.218  75.633  1.00 33.91           O  
ATOM   4331  CB  LYS D  51      27.550  28.714  77.054  1.00 37.51           C  
ATOM   4332  CG  LYS D  51      26.523  29.593  77.733  1.00 35.72           C  
ATOM   4333  CD  LYS D  51      26.249  30.845  76.929  1.00 36.90           C  
ATOM   4334  CE  LYS D  51      24.966  31.569  77.419  1.00 37.18           C  
ATOM   4335  N   GLY D  52      29.607  25.850  77.203  1.00 33.40           N  
ATOM   4336  CA  GLY D  52      30.464  25.024  76.349  1.00 33.46           C  
ATOM   4337  C   GLY D  52      31.264  25.771  75.286  1.00 35.91           C  
ATOM   4338  O   GLY D  52      31.631  25.192  74.275  1.00 37.57           O  
ATOM   4339  N   VAL D  53      31.534  27.059  75.507  1.00 34.82           N  
ATOM   4340  CA  VAL D  53      32.352  27.873  74.592  1.00 31.45           C  
ATOM   4341  C   VAL D  53      33.827  27.684  74.986  1.00 36.63           C  
ATOM   4342  O   VAL D  53      34.187  27.785  76.174  1.00 36.54           O  
ATOM   4343  CB  VAL D  53      31.948  29.394  74.690  1.00 33.16           C  
ATOM   4344  CG1 VAL D  53      32.756  30.266  73.775  1.00 33.04           C  
ATOM   4345  CG2 VAL D  53      30.482  29.582  74.395  1.00 33.18           C  
ATOM   4346  N   GLU D  54      34.684  27.415  74.004  1.00 39.06           N  
ATOM   4347  CA  GLU D  54      36.086  27.211  74.281  1.00 42.68           C  
ATOM   4348  C   GLU D  54      36.684  28.562  74.593  1.00 42.35           C  
ATOM   4349  O   GLU D  54      36.400  29.541  73.920  1.00 44.91           O  
ATOM   4350  CB  GLU D  54      36.824  26.575  73.081  1.00 46.04           C  
ATOM   4351  N   ILE D  55      37.492  28.619  75.633  1.00 39.68           N  
ATOM   4352  CA  ILE D  55      38.155  29.850  75.996  1.00 38.37           C  
ATOM   4353  C   ILE D  55      39.304  29.482  76.890  1.00 34.26           C  
ATOM   4354  O   ILE D  55      39.134  28.695  77.808  1.00 30.76           O  
ATOM   4355  CB  ILE D  55      37.169  30.854  76.706  1.00 41.98           C  
ATOM   4356  CG1 ILE D  55      37.900  32.135  77.101  1.00 44.37           C  
ATOM   4357  CG2 ILE D  55      36.474  30.215  77.913  1.00 41.87           C  
ATOM   4358  CD1 ILE D  55      37.081  33.349  76.981  1.00 47.08           C  
ATOM   4359  N   ASP D  56      40.478  30.022  76.595  1.00 30.10           N  
ATOM   4360  CA  ASP D  56      41.626  29.849  77.454  1.00 31.50           C  
ATOM   4361  C   ASP D  56      41.477  30.850  78.610  1.00 31.03           C  
ATOM   4362  O   ASP D  56      41.721  32.063  78.414  1.00 27.46           O  
ATOM   4363  CB  ASP D  56      42.876  30.133  76.634  1.00 32.60           C  
ATOM   4364  CG  ASP D  56      44.144  29.807  77.359  1.00 31.99           C  
ATOM   4365  OD1 ASP D  56      44.156  29.668  78.616  1.00 30.45           O  
ATOM   4366  OD2 ASP D  56      45.152  29.708  76.633  1.00 35.48           O  
ATOM   4367  N   VAL D  57      41.031  30.343  79.776  1.00 28.73           N  
ATOM   4368  CA  VAL D  57      40.763  31.177  80.952  1.00 30.02           C  
ATOM   4369  C   VAL D  57      42.025  31.816  81.463  1.00 28.78           C  
ATOM   4370  O   VAL D  57      42.041  33.012  81.677  1.00 25.45           O  
ATOM   4371  CB  VAL D  57      40.030  30.435  82.110  1.00 30.63           C  
ATOM   4372  CG1 VAL D  57      39.836  31.380  83.326  1.00 29.43           C  
ATOM   4373  CG2 VAL D  57      38.674  29.945  81.659  1.00 30.96           C  
ATOM   4374  N   GLU D  58      43.091  31.030  81.598  1.00 28.06           N  
ATOM   4375  CA  GLU D  58      44.422  31.546  81.948  1.00 29.59           C  
ATOM   4376  C   GLU D  58      44.890  32.712  81.098  1.00 26.63           C  
ATOM   4377  O   GLU D  58      45.425  33.694  81.624  1.00 24.86           O  
ATOM   4378  CB  GLU D  58      45.478  30.447  81.854  1.00 31.88           C  
ATOM   4379  CG  GLU D  58      46.888  30.892  82.276  1.00 32.86           C  
ATOM   4380  CD  GLU D  58      47.916  29.757  82.201  1.00 34.57           C  
ATOM   4381  OE1 GLU D  58      47.503  28.598  82.308  1.00 40.17           O  
ATOM   4382  OE2 GLU D  58      49.124  30.031  82.034  1.00 31.40           O  
ATOM   4383  N   LYS D  59      44.737  32.598  79.791  1.00 25.30           N  
ATOM   4384  CA  LYS D  59      45.146  33.666  78.920  1.00 26.92           C  
ATOM   4385  C   LYS D  59      44.320  34.957  79.130  1.00 23.50           C  
ATOM   4386  O   LYS D  59      44.873  36.050  79.144  1.00 23.37           O  
ATOM   4387  CB  LYS D  59      45.048  33.285  77.467  1.00 27.58           C  
ATOM   4388  CG  LYS D  59      45.827  34.280  76.602  1.00 31.71           C  
ATOM   4389  CD  LYS D  59      45.317  34.357  75.213  1.00 34.45           C  
ATOM   4390  CE  LYS D  59      45.588  33.167  74.413  1.00 31.20           C  
ATOM   4391  NZ  LYS D  59      45.412  33.484  72.963  1.00 27.97           N  
ATOM   4392  N   ALA D  60      43.015  34.808  79.217  1.00 19.77           N  
ATOM   4393  CA  ALA D  60      42.113  35.918  79.442  1.00 23.06           C  
ATOM   4394  C   ALA D  60      42.464  36.710  80.736  1.00 22.31           C  
ATOM   4395  O   ALA D  60      42.372  37.945  80.777  1.00 21.27           O  
ATOM   4396  CB  ALA D  60      40.721  35.415  79.511  1.00 21.36           C  
ATOM   4397  N   LEU D  61      42.825  35.985  81.778  1.00 20.72           N  
ATOM   4398  CA  LEU D  61      43.162  36.583  83.071  1.00 22.57           C  
ATOM   4399  C   LEU D  61      44.517  37.331  82.985  1.00 26.07           C  
ATOM   4400  O   LEU D  61      44.677  38.435  83.543  1.00 19.78           O  
ATOM   4401  CB  LEU D  61      43.184  35.502  84.174  1.00 21.80           C  
ATOM   4402  CG  LEU D  61      41.875  34.771  84.505  1.00 21.50           C  
ATOM   4403  CD1 LEU D  61      42.066  33.681  85.596  1.00 23.39           C  
ATOM   4404  CD2 LEU D  61      40.772  35.730  84.943  1.00 24.00           C  
ATOM   4405  N   LYS D  62      45.460  36.758  82.243  1.00 22.21           N  
ATOM   4406  CA  LYS D  62      46.716  37.404  82.003  1.00 23.21           C  
ATOM   4407  C   LYS D  62      46.530  38.718  81.234  1.00 24.41           C  
ATOM   4408  O   LYS D  62      47.105  39.736  81.587  1.00 23.17           O  
ATOM   4409  CB  LYS D  62      47.657  36.478  81.236  1.00 27.13           C  
ATOM   4410  CG  LYS D  62      48.267  35.333  82.067  1.00 30.64           C  
ATOM   4411  CD  LYS D  62      49.399  34.643  81.226  1.00 31.26           C  
ATOM   4412  CE  LYS D  62      49.893  33.322  81.782  1.00 32.50           C  
ATOM   4413  NZ  LYS D  62      50.962  32.747  80.836  1.00 34.15           N  
ATOM   4414  N   ILE D  63      45.730  38.682  80.179  1.00 19.68           N  
ATOM   4415  CA  ILE D  63      45.440  39.854  79.408  1.00 21.89           C  
ATOM   4416  C   ILE D  63      44.765  40.916  80.291  1.00 23.80           C  
ATOM   4417  O   ILE D  63      45.099  42.092  80.183  1.00 20.85           O  
ATOM   4418  CB  ILE D  63      44.501  39.536  78.190  1.00 24.16           C  
ATOM   4419  CG1 ILE D  63      45.186  38.623  77.162  1.00 24.41           C  
ATOM   4420  CG2 ILE D  63      44.053  40.815  77.484  1.00 24.07           C  
ATOM   4421  CD1 ILE D  63      44.192  38.000  76.159  1.00 25.04           C  
ATOM   4422  N   ALA D  64      43.801  40.504  81.130  1.00 24.12           N  
ATOM   4423  CA  ALA D  64      43.103  41.449  82.005  1.00 22.58           C  
ATOM   4424  C   ALA D  64      44.123  42.140  82.925  1.00 22.07           C  
ATOM   4425  O   ALA D  64      44.142  43.342  82.989  1.00 22.34           O  
ATOM   4426  CB  ALA D  64      42.037  40.771  82.807  1.00 20.76           C  
ATOM   4427  N   ILE D  65      45.014  41.372  83.558  1.00 22.10           N  
ATOM   4428  CA  ILE D  65      46.053  41.957  84.424  1.00 24.93           C  
ATOM   4429  C   ILE D  65      46.915  43.027  83.695  1.00 24.05           C  
ATOM   4430  O   ILE D  65      47.207  44.102  84.250  1.00 26.25           O  
ATOM   4431  CB  ILE D  65      46.886  40.838  85.127  1.00 23.38           C  
ATOM   4432  CG1 ILE D  65      45.972  40.050  86.055  1.00 21.98           C  
ATOM   4433  CG2 ILE D  65      48.040  41.406  85.957  1.00 23.42           C  
ATOM   4434  CD1 ILE D  65      46.491  38.666  86.449  1.00 25.10           C  
ATOM   4435  N   ILE D  66      47.235  42.780  82.421  1.00 23.43           N  
ATOM   4436  CA  ILE D  66      48.240  43.589  81.745  1.00 21.95           C  
ATOM   4437  C   ILE D  66      47.636  44.604  80.839  1.00 20.58           C  
ATOM   4438  O   ILE D  66      48.351  45.466  80.314  1.00 21.29           O  
ATOM   4439  CB  ILE D  66      49.370  42.704  80.969  1.00 24.33           C  
ATOM   4440  CG1 ILE D  66      48.802  41.875  79.808  1.00 21.30           C  
ATOM   4441  CG2 ILE D  66      50.110  41.755  81.941  1.00 20.38           C  
ATOM   4442  CD1 ILE D  66      48.269  42.667  78.662  1.00 22.09           C  
ATOM   4443  N   HIS D  67      46.325  44.539  80.630  1.00 19.78           N  
ATOM   4444  CA  HIS D  67      45.772  45.301  79.522  1.00 23.28           C  
ATOM   4445  C   HIS D  67      45.887  46.841  79.677  1.00 27.15           C  
ATOM   4446  O   HIS D  67      45.825  47.534  78.672  1.00 25.56           O  
ATOM   4447  CB  HIS D  67      44.329  44.919  79.223  1.00 19.90           C  
ATOM   4448  CG  HIS D  67      43.348  45.609  80.112  1.00 24.44           C  
ATOM   4449  ND1 HIS D  67      43.178  45.251  81.430  1.00 22.70           N  
ATOM   4450  CD2 HIS D  67      42.543  46.680  79.896  1.00 17.41           C  
ATOM   4451  CE1 HIS D  67      42.293  46.060  81.985  1.00 27.48           C  
ATOM   4452  NE2 HIS D  67      41.885  46.928  81.076  1.00 24.01           N  
ATOM   4453  N   ASP D  68      46.039  47.367  80.900  1.00 24.91           N  
ATOM   4454  CA  ASP D  68      46.208  48.826  81.082  1.00 23.91           C  
ATOM   4455  C   ASP D  68      47.547  49.123  81.705  1.00 21.52           C  
ATOM   4456  O   ASP D  68      47.792  50.238  82.128  1.00 25.55           O  
ATOM   4457  CB  ASP D  68      45.064  49.432  81.966  1.00 26.83           C  
ATOM   4458  CG  ASP D  68      43.807  49.809  81.165  1.00 28.83           C  
ATOM   4459  OD1 ASP D  68      43.844  49.801  79.915  1.00 31.86           O  
ATOM   4460  OD2 ASP D  68      42.766  50.148  81.796  1.00 29.68           O  
ATOM   4461  N   LEU D  69      48.440  48.145  81.755  1.00 20.79           N  
ATOM   4462  CA  LEU D  69      49.761  48.350  82.357  1.00 24.47           C  
ATOM   4463  C   LEU D  69      50.641  49.406  81.669  1.00 25.69           C  
ATOM   4464  O   LEU D  69      51.434  50.085  82.337  1.00 26.26           O  
ATOM   4465  CB  LEU D  69      50.502  47.028  82.393  1.00 30.70           C  
ATOM   4466  CG  LEU D  69      51.713  46.928  83.308  1.00 34.85           C  
ATOM   4467  CD1 LEU D  69      51.455  47.484  84.749  1.00 34.60           C  
ATOM   4468  CD2 LEU D  69      52.077  45.475  83.354  1.00 37.59           C  
ATOM   4469  N   GLY D  70      50.522  49.536  80.340  1.00 25.48           N  
ATOM   4470  CA  GLY D  70      51.148  50.628  79.606  1.00 23.60           C  
ATOM   4471  C   GLY D  70      50.809  52.013  80.174  1.00 24.74           C  
ATOM   4472  O   GLY D  70      51.581  52.956  80.034  1.00 26.61           O  
ATOM   4473  N   GLU D  71      49.652  52.133  80.815  1.00 24.72           N  
ATOM   4474  CA  GLU D  71      49.229  53.386  81.440  1.00 23.64           C  
ATOM   4475  C   GLU D  71      50.047  53.773  82.674  1.00 21.66           C  
ATOM   4476  O   GLU D  71      50.042  54.946  83.099  1.00 18.83           O  
ATOM   4477  CB  GLU D  71      47.741  53.346  81.752  1.00 22.11           C  
ATOM   4478  CG  GLU D  71      46.950  53.256  80.482  1.00 25.36           C  
ATOM   4479  CD  GLU D  71      45.476  53.255  80.679  1.00 28.92           C  
ATOM   4480  OE1 GLU D  71      45.025  53.313  81.850  1.00 31.82           O  
ATOM   4481  OE2 GLU D  71      44.779  53.183  79.648  1.00 26.59           O  
ATOM   4482  N   ALA D  72      50.808  52.827  83.216  1.00 20.70           N  
ATOM   4483  CA  ALA D  72      51.743  53.156  84.278  1.00 21.14           C  
ATOM   4484  C   ALA D  72      52.822  54.094  83.779  1.00 18.19           C  
ATOM   4485  O   ALA D  72      53.391  54.843  84.575  1.00 18.37           O  
ATOM   4486  CB  ALA D  72      52.346  51.905  84.910  1.00 21.95           C  
ATOM   4487  N   ILE D  73      53.070  54.070  82.467  1.00 18.42           N  
ATOM   4488  CA  ILE D  73      54.040  54.957  81.786  1.00 20.57           C  
ATOM   4489  C   ILE D  73      53.395  56.109  80.999  1.00 20.94           C  
ATOM   4490  O   ILE D  73      53.892  57.250  80.999  1.00 19.48           O  
ATOM   4491  CB  ILE D  73      54.949  54.122  80.798  1.00 23.34           C  
ATOM   4492  CG1 ILE D  73      55.874  53.219  81.622  1.00 27.62           C  
ATOM   4493  CG2 ILE D  73      55.771  55.059  79.862  1.00 20.69           C  
ATOM   4494  CD1 ILE D  73      55.896  51.840  81.168  1.00 33.33           C  
ATOM   4495  N   ILE D  74      52.320  55.787  80.303  1.00 20.46           N  
ATOM   4496  CA  ILE D  74      51.626  56.723  79.425  1.00 22.95           C  
ATOM   4497  C   ILE D  74      50.577  57.578  80.200  1.00 23.98           C  
ATOM   4498  O   ILE D  74      50.235  58.681  79.760  1.00 24.48           O  
ATOM   4499  CB  ILE D  74      50.930  55.909  78.272  1.00 26.00           C  
ATOM   4500  CG1 ILE D  74      51.985  55.218  77.391  1.00 27.55           C  
ATOM   4501  CG2 ILE D  74      49.976  56.776  77.438  1.00 25.65           C  
ATOM   4502  CD1 ILE D  74      52.944  56.181  76.723  1.00 26.36           C  
ATOM   4503  N   THR D  75      50.147  57.061  81.368  1.00 27.43           N  
ATOM   4504  CA  THR D  75      48.940  57.506  82.156  1.00 25.68           C  
ATOM   4505  C   THR D  75      47.676  57.107  81.372  1.00 26.29           C  
ATOM   4506  O   THR D  75      47.786  56.552  80.299  1.00 23.21           O  
ATOM   4507  CB  THR D  75      48.910  59.046  82.531  1.00 22.86           C  
ATOM   4508  OG1 THR D  75      48.616  59.802  81.377  1.00 13.53           O  
ATOM   4509  CG2 THR D  75      50.224  59.530  83.075  1.00 25.06           C  
ATOM   4510  N   ASP D  76      46.491  57.370  81.949  1.00 24.73           N  
ATOM   4511  CA  ASP D  76      45.205  57.038  81.333  1.00 26.84           C  
ATOM   4512  C   ASP D  76      44.694  58.254  80.533  1.00 27.63           C  
ATOM   4513  O   ASP D  76      44.079  59.176  81.072  1.00 27.53           O  
ATOM   4514  CB  ASP D  76      44.169  56.595  82.407  1.00 26.52           C  
ATOM   4515  CG  ASP D  76      42.794  56.281  81.812  1.00 27.67           C  
ATOM   4516  OD1 ASP D  76      42.721  55.879  80.645  1.00 29.36           O  
ATOM   4517  OD2 ASP D  76      41.775  56.448  82.502  1.00 32.07           O  
ATOM   4518  N   LEU D  77      44.955  58.246  79.245  1.00 27.47           N  
ATOM   4519  CA  LEU D  77      44.594  59.379  78.402  1.00 29.25           C  
ATOM   4520  C   LEU D  77      43.080  59.424  78.142  1.00 27.16           C  
ATOM   4521  O   LEU D  77      42.491  58.455  77.629  1.00 24.36           O  
ATOM   4522  CB  LEU D  77      45.331  59.336  77.090  1.00 31.22           C  
ATOM   4523  CG  LEU D  77      46.839  59.368  77.177  1.00 32.52           C  
ATOM   4524  CD1 LEU D  77      47.392  59.116  75.792  1.00 34.34           C  
ATOM   4525  CD2 LEU D  77      47.336  60.713  77.721  1.00 33.12           C  
ATOM   4526  N   PRO D  78      42.455  60.557  78.491  1.00 25.52           N  
ATOM   4527  CA  PRO D  78      41.017  60.694  78.268  1.00 26.54           C  
ATOM   4528  C   PRO D  78      40.715  60.840  76.753  1.00 27.82           C  
ATOM   4529  O   PRO D  78      41.645  60.997  75.908  1.00 23.56           O  
ATOM   4530  CB  PRO D  78      40.657  61.966  79.080  1.00 24.87           C  
ATOM   4531  CG  PRO D  78      41.983  62.792  79.073  1.00 23.73           C  
ATOM   4532  CD  PRO D  78      43.082  61.797  79.035  1.00 22.87           C  
ATOM   4533  N   LEU D  79      39.434  60.744  76.407  1.00 30.27           N  
ATOM   4534  CA  LEU D  79      38.989  60.875  75.010  1.00 32.02           C  
ATOM   4535  C   LEU D  79      39.456  62.176  74.348  1.00 28.46           C  
ATOM   4536  O   LEU D  79      39.948  62.177  73.209  1.00 27.95           O  
ATOM   4537  CB  LEU D  79      37.466  60.751  74.939  1.00 32.40           C  
ATOM   4538  CG  LEU D  79      36.973  59.319  75.135  1.00 37.54           C  
ATOM   4539  CD1 LEU D  79      35.425  59.297  75.214  1.00 39.93           C  
ATOM   4540  CD2 LEU D  79      37.482  58.379  74.025  1.00 38.11           C  
ATOM   4541  N   SER D  80      39.318  63.280  75.080  1.00 27.55           N  
ATOM   4542  CA  SER D  80      39.696  64.592  74.576  1.00 25.43           C  
ATOM   4543  C   SER D  80      41.140  64.558  74.035  1.00 27.11           C  
ATOM   4544  O   SER D  80      41.447  65.186  73.018  1.00 26.96           O  
ATOM   4545  CB  SER D  80      39.594  65.636  75.697  1.00 22.44           C  
ATOM   4546  OG  SER D  80      40.579  65.375  76.711  1.00 21.56           O  
ATOM   4547  N   ALA D  81      42.018  63.855  74.765  1.00 26.38           N  
ATOM   4548  CA  ALA D  81      43.427  63.740  74.403  1.00 26.75           C  
ATOM   4549  C   ALA D  81      43.640  62.822  73.201  1.00 25.57           C  
ATOM   4550  O   ALA D  81      44.573  63.026  72.439  1.00 22.87           O  
ATOM   4551  CB  ALA D  81      44.246  63.231  75.593  1.00 26.07           C  
ATOM   4552  N   GLN D  82      42.787  61.809  73.053  1.00 26.31           N  
ATOM   4553  CA  GLN D  82      42.945  60.804  71.988  1.00 30.29           C  
ATOM   4554  C   GLN D  82      42.612  61.344  70.597  1.00 33.77           C  
ATOM   4555  O   GLN D  82      42.902  60.690  69.618  1.00 34.64           O  
ATOM   4556  CB  GLN D  82      42.087  59.578  72.256  1.00 26.88           C  
ATOM   4557  CG  GLN D  82      42.412  58.899  73.565  1.00 29.01           C  
ATOM   4558  CD  GLN D  82      41.427  57.819  73.881  1.00 31.49           C  
ATOM   4559  OE1 GLN D  82      41.066  57.064  72.999  1.00 33.55           O  
ATOM   4560  NE2 GLN D  82      41.005  57.717  75.143  1.00 31.67           N  
ATOM   4561  N   LYS D  83      42.010  62.533  70.520  1.00 34.71           N  
ATOM   4562  CA  LYS D  83      41.860  63.241  69.252  1.00 37.35           C  
ATOM   4563  C   LYS D  83      43.225  63.726  68.708  1.00 37.04           C  
ATOM   4564  O   LYS D  83      43.375  63.946  67.499  1.00 40.08           O  
ATOM   4565  CB  LYS D  83      40.893  64.428  69.411  1.00 38.83           C  
ATOM   4566  N   TYR D  84      44.212  63.874  69.599  1.00 30.40           N  
ATOM   4567  CA  TYR D  84      45.534  64.368  69.230  1.00 32.09           C  
ATOM   4568  C   TYR D  84      46.667  63.341  69.384  1.00 35.46           C  
ATOM   4569  O   TYR D  84      47.774  63.557  68.885  1.00 38.52           O  
ATOM   4570  CB  TYR D  84      45.849  65.628  70.051  1.00 30.25           C  
ATOM   4571  CG  TYR D  84      44.775  66.674  69.832  1.00 29.59           C  
ATOM   4572  CD1 TYR D  84      44.742  67.437  68.669  1.00 31.14           C  
ATOM   4573  CD2 TYR D  84      43.730  66.827  70.744  1.00 31.55           C  
ATOM   4574  CE1 TYR D  84      43.711  68.374  68.448  1.00 32.76           C  
ATOM   4575  CE2 TYR D  84      42.704  67.757  70.537  1.00 31.27           C  
ATOM   4576  CZ  TYR D  84      42.706  68.526  69.408  1.00 29.52           C  
ATOM   4577  OH  TYR D  84      41.698  69.415  69.231  1.00 31.58           O  
ATOM   4578  N   LEU D  85      46.410  62.256  70.104  1.00 35.16           N  
ATOM   4579  CA  LEU D  85      47.469  61.342  70.508  1.00 36.60           C  
ATOM   4580  C   LEU D  85      46.967  59.930  70.344  1.00 37.12           C  
ATOM   4581  O   LEU D  85      45.812  59.636  70.682  1.00 36.95           O  
ATOM   4582  CB  LEU D  85      47.868  61.577  71.975  1.00 37.14           C  
ATOM   4583  CG  LEU D  85      48.586  62.900  72.307  1.00 37.63           C  
ATOM   4584  CD1 LEU D  85      48.583  63.169  73.794  1.00 34.49           C  
ATOM   4585  CD2 LEU D  85      50.012  62.906  71.764  1.00 38.19           C  
ATOM   4586  N   ASN D  86      47.829  59.055  69.836  1.00 38.85           N  
ATOM   4587  CA  ASN D  86      47.450  57.649  69.614  1.00 37.90           C  
ATOM   4588  C   ASN D  86      47.793  56.839  70.860  1.00 35.10           C  
ATOM   4589  O   ASN D  86      48.956  56.458  71.085  1.00 32.47           O  
ATOM   4590  CB  ASN D  86      48.131  57.093  68.363  1.00 38.34           C  
ATOM   4591  CG  ASN D  86      47.499  55.787  67.883  1.00 43.23           C  
ATOM   4592  OD1 ASN D  86      47.172  54.886  68.681  1.00 40.50           O  
ATOM   4593  ND2 ASN D  86      47.323  55.679  66.568  1.00 45.12           N  
ATOM   4594  N   LYS D  87      46.760  56.607  71.669  1.00 34.28           N  
ATOM   4595  CA  LYS D  87      46.874  55.985  73.006  1.00 33.70           C  
ATOM   4596  C   LYS D  87      47.320  54.491  72.984  1.00 29.27           C  
ATOM   4597  O   LYS D  87      48.231  54.114  73.687  1.00 28.96           O  
ATOM   4598  CB  LYS D  87      45.508  56.126  73.702  1.00 35.52           C  
ATOM   4599  CG  LYS D  87      45.351  55.499  75.102  1.00 35.46           C  
ATOM   4600  CD  LYS D  87      43.919  55.728  75.601  1.00 35.72           C  
ATOM   4601  CE  LYS D  87      43.509  54.803  76.772  1.00 35.78           C  
ATOM   4602  NZ  LYS D  87      42.739  55.562  77.819  1.00 25.56           N  
ATOM   4603  N   GLU D  88      46.646  53.663  72.193  1.00 30.67           N  
ATOM   4604  CA  GLU D  88      46.983  52.237  72.078  1.00 32.91           C  
ATOM   4605  C   GLU D  88      48.420  52.043  71.553  1.00 32.05           C  
ATOM   4606  O   GLU D  88      49.183  51.260  72.095  1.00 34.69           O  
ATOM   4607  CB  GLU D  88      45.957  51.502  71.184  1.00 31.07           C  
ATOM   4608  N   GLU D  89      48.777  52.794  70.522  1.00 35.41           N  
ATOM   4609  CA  GLU D  89      50.119  52.762  69.921  1.00 39.16           C  
ATOM   4610  C   GLU D  89      51.198  53.132  70.950  1.00 36.47           C  
ATOM   4611  O   GLU D  89      52.213  52.427  71.099  1.00 31.17           O  
ATOM   4612  CB  GLU D  89      50.133  53.705  68.711  1.00 43.10           C  
ATOM   4613  CG  GLU D  89      51.455  53.895  67.970  1.00 49.54           C  
ATOM   4614  CD  GLU D  89      51.294  54.845  66.759  1.00 52.03           C  
ATOM   4615  OE1 GLU D  89      50.514  54.495  65.835  1.00 58.73           O  
ATOM   4616  OE2 GLU D  89      51.934  55.929  66.731  1.00 56.61           O  
ATOM   4617  N   ALA D  90      50.970  54.215  71.689  1.00 33.36           N  
ATOM   4618  CA  ALA D  90      51.871  54.571  72.813  1.00 29.21           C  
ATOM   4619  C   ALA D  90      51.921  53.503  73.908  1.00 25.16           C  
ATOM   4620  O   ALA D  90      52.991  53.191  74.410  1.00 25.77           O  
ATOM   4621  CB  ALA D  90      51.456  55.913  73.399  1.00 29.90           C  
ATOM   4622  N   GLU D  91      50.768  52.939  74.290  1.00 27.70           N  
ATOM   4623  CA  GLU D  91      50.727  51.901  75.360  1.00 27.24           C  
ATOM   4624  C   GLU D  91      51.465  50.650  74.912  1.00 27.27           C  
ATOM   4625  O   GLU D  91      52.175  50.034  75.712  1.00 25.80           O  
ATOM   4626  CB  GLU D  91      49.293  51.531  75.781  1.00 25.74           C  
ATOM   4627  CG  GLU D  91      48.650  52.514  76.730  1.00 29.03           C  
ATOM   4628  CD  GLU D  91      47.263  52.080  77.203  1.00 29.44           C  
ATOM   4629  OE1 GLU D  91      47.076  50.905  77.624  1.00 29.58           O  
ATOM   4630  OE2 GLU D  91      46.361  52.941  77.191  1.00 33.96           O  
ATOM   4631  N   ALA D  92      51.285  50.281  73.639  1.00 28.06           N  
ATOM   4632  CA  ALA D  92      51.952  49.084  73.052  1.00 31.40           C  
ATOM   4633  C   ALA D  92      53.480  49.186  73.042  1.00 27.79           C  
ATOM   4634  O   ALA D  92      54.179  48.241  73.405  1.00 29.90           O  
ATOM   4635  CB  ALA D  92      51.416  48.803  71.630  1.00 29.98           C  
ATOM   4636  N   LYS D  93      53.995  50.339  72.661  1.00 30.49           N  
ATOM   4637  CA  LYS D  93      55.444  50.600  72.733  1.00 32.63           C  
ATOM   4638  C   LYS D  93      55.963  50.564  74.177  1.00 31.17           C  
ATOM   4639  O   LYS D  93      56.967  49.919  74.494  1.00 28.43           O  
ATOM   4640  CB  LYS D  93      55.752  51.954  72.121  1.00 34.38           C  
ATOM   4641  CG  LYS D  93      55.427  52.061  70.640  1.00 36.86           C  
ATOM   4642  N   ALA D  94      55.271  51.263  75.064  1.00 31.40           N  
ATOM   4643  CA  ALA D  94      55.708  51.324  76.468  1.00 26.54           C  
ATOM   4644  C   ALA D  94      55.763  49.909  77.033  1.00 30.06           C  
ATOM   4645  O   ALA D  94      56.733  49.528  77.714  1.00 29.90           O  
ATOM   4646  CB  ALA D  94      54.773  52.183  77.278  1.00 25.12           C  
ATOM   4647  N   LEU D  95      54.708  49.138  76.759  1.00 31.82           N  
ATOM   4648  CA  LEU D  95      54.616  47.766  77.240  1.00 33.99           C  
ATOM   4649  C   LEU D  95      55.732  46.889  76.679  1.00 31.24           C  
ATOM   4650  O   LEU D  95      56.328  46.101  77.409  1.00 33.71           O  
ATOM   4651  CB  LEU D  95      53.251  47.157  76.918  1.00 34.62           C  
ATOM   4652  CG  LEU D  95      52.945  45.921  77.751  1.00 39.73           C  
ATOM   4653  CD1 LEU D  95      52.674  46.321  79.208  1.00 39.56           C  
ATOM   4654  CD2 LEU D  95      51.757  45.173  77.170  1.00 41.02           C  
ATOM   4655  N   LYS D  96      56.018  47.050  75.399  1.00 32.41           N  
ATOM   4656  CA  LYS D  96      57.051  46.266  74.727  1.00 36.19           C  
ATOM   4657  C   LYS D  96      58.407  46.459  75.407  1.00 38.28           C  
ATOM   4658  O   LYS D  96      59.153  45.485  75.611  1.00 40.47           O  
ATOM   4659  CB  LYS D  96      57.143  46.660  73.249  1.00 37.07           C  
ATOM   4660  CG  LYS D  96      58.155  45.818  72.428  1.00 38.66           C  
ATOM   4661  CD  LYS D  96      58.033  46.100  70.923  1.00 39.42           C  
ATOM   4662  N   ASP D  97      58.706  47.710  75.775  1.00 40.33           N  
ATOM   4663  CA  ASP D  97      59.957  48.073  76.465  1.00 37.87           C  
ATOM   4664  C   ASP D  97      60.086  47.488  77.875  1.00 38.22           C  
ATOM   4665  O   ASP D  97      61.193  47.340  78.385  1.00 37.06           O  
ATOM   4666  CB  ASP D  97      60.093  49.594  76.544  1.00 40.02           C  
ATOM   4667  CG  ASP D  97      60.474  50.213  75.217  1.00 43.90           C  
ATOM   4668  OD1 ASP D  97      60.938  49.433  74.335  1.00 44.12           O  
ATOM   4669  OD2 ASP D  97      60.324  51.464  75.048  1.00 41.29           O  
ATOM   4670  N   VAL D  98      58.977  47.147  78.524  1.00 34.78           N  
ATOM   4671  CA  VAL D  98      59.103  46.549  79.860  1.00 30.68           C  
ATOM   4672  C   VAL D  98      58.680  45.092  79.933  1.00 28.61           C  
ATOM   4673  O   VAL D  98      59.218  44.335  80.724  1.00 23.74           O  
ATOM   4674  CB  VAL D  98      58.372  47.381  80.919  1.00 29.55           C  
ATOM   4675  CG1 VAL D  98      59.092  48.722  81.069  1.00 31.16           C  
ATOM   4676  CG2 VAL D  98      56.893  47.564  80.578  1.00 29.36           C  
ATOM   4677  N   LEU D  99      57.689  44.719  79.138  1.00 25.00           N  
ATOM   4678  CA  LEU D  99      57.181  43.366  79.131  1.00 29.38           C  
ATOM   4679  C   LEU D  99      56.993  42.918  77.677  1.00 28.98           C  
ATOM   4680  O   LEU D  99      55.884  42.817  77.204  1.00 25.60           O  
ATOM   4681  CB  LEU D  99      55.867  43.307  79.894  1.00 33.59           C  
ATOM   4682  CG  LEU D  99      55.972  43.503  81.404  1.00 38.67           C  
ATOM   4683  CD1 LEU D  99      54.600  43.688  82.001  1.00 42.42           C  
ATOM   4684  CD2 LEU D  99      56.668  42.291  82.064  1.00 39.86           C  
ATOM   4685  N   PRO D 100      58.109  42.668  76.970  1.00 32.98           N  
ATOM   4686  CA  PRO D 100      58.059  42.277  75.553  1.00 31.56           C  
ATOM   4687  C   PRO D 100      57.342  40.961  75.341  1.00 30.91           C  
ATOM   4688  O   PRO D 100      56.761  40.750  74.287  1.00 29.19           O  
ATOM   4689  CB  PRO D 100      59.551  42.205  75.153  1.00 29.27           C  
ATOM   4690  CG  PRO D 100      60.300  42.057  76.426  1.00 32.40           C  
ATOM   4691  CD  PRO D 100      59.497  42.735  77.487  1.00 33.08           C  
ATOM   4692  N   GLU D 101      57.367  40.099  76.362  1.00 33.24           N  
ATOM   4693  CA  GLU D 101      56.656  38.839  76.333  1.00 36.87           C  
ATOM   4694  C   GLU D 101      55.124  38.937  76.306  1.00 36.06           C  
ATOM   4695  O   GLU D 101      54.485  37.933  76.020  1.00 40.49           O  
ATOM   4696  CB  GLU D 101      57.063  37.965  77.534  1.00 41.97           C  
ATOM   4697  CG  GLU D 101      56.581  38.518  78.925  1.00 44.70           C  
ATOM   4698  CD  GLU D 101      57.719  39.164  79.770  1.00 46.38           C  
ATOM   4699  OE1 GLU D 101      58.396  40.137  79.311  1.00 34.29           O  
ATOM   4700  OE2 GLU D 101      57.901  38.672  80.917  1.00 49.49           O  
ATOM   4701  N   TYR D 102      54.540  40.097  76.638  1.00 33.13           N  
ATOM   4702  CA  TYR D 102      53.075  40.243  76.715  1.00 33.15           C  
ATOM   4703  C   TYR D 102      52.545  41.088  75.533  1.00 31.69           C  
ATOM   4704  O   TYR D 102      51.369  41.448  75.463  1.00 27.33           O  
ATOM   4705  CB  TYR D 102      52.651  40.830  78.095  1.00 37.99           C  
ATOM   4706  CG  TYR D 102      52.962  39.903  79.271  1.00 37.99           C  
ATOM   4707  CD1 TYR D 102      52.524  38.602  79.279  1.00 41.98           C  
ATOM   4708  CD2 TYR D 102      53.712  40.333  80.353  1.00 41.32           C  
ATOM   4709  CE1 TYR D 102      52.832  37.736  80.331  1.00 42.51           C  
ATOM   4710  CE2 TYR D 102      54.016  39.479  81.411  1.00 41.09           C  
ATOM   4711  CZ  TYR D 102      53.573  38.181  81.391  1.00 40.82           C  
ATOM   4712  OH  TYR D 102      53.858  37.309  82.429  1.00 39.83           O  
ATOM   4713  N   THR D 103      53.443  41.395  74.610  1.00 29.22           N  
ATOM   4714  CA  THR D 103      53.119  42.167  73.419  1.00 29.63           C  
ATOM   4715  C   THR D 103      51.957  41.580  72.613  1.00 28.32           C  
ATOM   4716  O   THR D 103      51.096  42.327  72.128  1.00 23.96           O  
ATOM   4717  CB  THR D 103      54.369  42.292  72.515  1.00 29.91           C  
ATOM   4718  OG1 THR D 103      55.199  43.322  73.044  1.00 35.82           O  
ATOM   4719  CG2 THR D 103      53.986  42.673  71.096  1.00 36.86           C  
ATOM   4720  N   GLU D 104      51.938  40.257  72.454  1.00 26.86           N  
ATOM   4721  CA  GLU D 104      50.905  39.654  71.630  1.00 31.22           C  
ATOM   4722  C   GLU D 104      49.581  39.601  72.405  1.00 27.27           C  
ATOM   4723  O   GLU D 104      48.541  39.876  71.836  1.00 26.64           O  
ATOM   4724  CB  GLU D 104      51.298  38.271  71.030  1.00 26.85           C  
ATOM   4725  CG  GLU D 104      50.189  37.759  70.021  1.00 28.89           C  
ATOM   4726  CD  GLU D 104      50.552  36.439  69.251  1.00 31.56           C  
ATOM   4727  OE1 GLU D 104      51.739  36.019  69.258  1.00 27.33           O  
ATOM   4728  OE2 GLU D 104      49.623  35.824  68.660  1.00 29.52           O  
ATOM   4729  N   LEU D 105      49.635  39.267  73.690  1.00 30.88           N  
ATOM   4730  CA  LEU D 105      48.458  39.395  74.588  1.00 30.44           C  
ATOM   4731  C   LEU D 105      47.820  40.791  74.534  1.00 28.46           C  
ATOM   4732  O   LEU D 105      46.601  40.928  74.351  1.00 26.64           O  
ATOM   4733  CB  LEU D 105      48.840  39.062  76.023  1.00 31.77           C  
ATOM   4734  CG  LEU D 105      49.294  37.626  76.376  1.00 35.36           C  
ATOM   4735  CD1 LEU D 105      49.252  37.419  77.895  1.00 34.14           C  
ATOM   4736  CD2 LEU D 105      48.481  36.543  75.716  1.00 36.91           C  
ATOM   4737  N   PHE D 106      48.634  41.838  74.668  1.00 30.05           N  
ATOM   4738  CA  PHE D 106      48.106  43.201  74.544  1.00 27.15           C  
ATOM   4739  C   PHE D 106      47.408  43.402  73.185  1.00 29.24           C  
ATOM   4740  O   PHE D 106      46.329  44.023  73.096  1.00 25.63           O  
ATOM   4741  CB  PHE D 106      49.175  44.275  74.751  1.00 24.32           C  
ATOM   4742  CG  PHE D 106      48.606  45.661  74.714  1.00 28.15           C  
ATOM   4743  CD1 PHE D 106      47.707  46.083  75.712  1.00 23.06           C  
ATOM   4744  CD2 PHE D 106      48.875  46.521  73.651  1.00 26.31           C  
ATOM   4745  CE1 PHE D 106      47.115  47.368  75.671  1.00 26.18           C  
ATOM   4746  CE2 PHE D 106      48.292  47.821  73.611  1.00 31.74           C  
ATOM   4747  CZ  PHE D 106      47.398  48.238  74.640  1.00 26.79           C  
ATOM   4748  N   GLU D 107      48.012  42.855  72.130  1.00 29.13           N  
ATOM   4749  CA  GLU D 107      47.486  43.012  70.766  1.00 30.22           C  
ATOM   4750  C   GLU D 107      46.142  42.283  70.630  1.00 24.41           C  
ATOM   4751  O   GLU D 107      45.215  42.811  70.043  1.00 28.20           O  
ATOM   4752  CB  GLU D 107      48.525  42.508  69.732  1.00 33.62           C  
ATOM   4753  CG  GLU D 107      48.411  43.105  68.342  1.00 36.02           C  
ATOM   4754  N   GLU D 108      46.044  41.067  71.178  1.00 25.05           N  
ATOM   4755  CA  GLU D 108      44.783  40.334  71.211  1.00 27.88           C  
ATOM   4756  C   GLU D 108      43.646  41.226  71.834  1.00 30.22           C  
ATOM   4757  O   GLU D 108      42.533  41.274  71.332  1.00 30.96           O  
ATOM   4758  CB  GLU D 108      44.945  39.057  72.033  1.00 26.57           C  
ATOM   4759  CG  GLU D 108      45.738  37.950  71.348  1.00 27.39           C  
ATOM   4760  CD  GLU D 108      45.632  36.597  72.072  1.00 27.87           C  
ATOM   4761  OE1 GLU D 108      44.575  36.291  72.711  1.00 26.51           O  
ATOM   4762  OE2 GLU D 108      46.603  35.820  71.980  1.00 31.57           O  
ATOM   4763  N   TYR D 109      43.983  41.940  72.917  1.00 30.08           N  
ATOM   4764  CA  TYR D 109      43.068  42.863  73.596  1.00 27.71           C  
ATOM   4765  C   TYR D 109      42.755  44.064  72.756  1.00 24.80           C  
ATOM   4766  O   TYR D 109      41.590  44.356  72.481  1.00 21.57           O  
ATOM   4767  CB  TYR D 109      43.665  43.346  74.935  1.00 31.07           C  
ATOM   4768  CG  TYR D 109      42.942  44.511  75.512  1.00 31.61           C  
ATOM   4769  CD1 TYR D 109      41.666  44.356  76.029  1.00 29.35           C  
ATOM   4770  CD2 TYR D 109      43.509  45.781  75.522  1.00 31.66           C  
ATOM   4771  CE1 TYR D 109      40.977  45.426  76.553  1.00 31.33           C  
ATOM   4772  CE2 TYR D 109      42.793  46.881  76.051  1.00 31.41           C  
ATOM   4773  CZ  TYR D 109      41.541  46.684  76.551  1.00 31.12           C  
ATOM   4774  OH  TYR D 109      40.812  47.727  77.081  1.00 35.72           O  
ATOM   4775  N   SER D 110      43.790  44.776  72.359  1.00 25.59           N  
ATOM   4776  CA  SER D 110      43.610  46.105  71.817  1.00 28.38           C  
ATOM   4777  C   SER D 110      42.954  46.067  70.443  1.00 30.28           C  
ATOM   4778  O   SER D 110      42.279  47.014  70.059  1.00 28.19           O  
ATOM   4779  CB  SER D 110      44.953  46.841  71.755  1.00 28.17           C  
ATOM   4780  OG  SER D 110      45.700  46.410  70.644  1.00 38.26           O  
ATOM   4781  N   LYS D 111      43.166  44.986  69.689  1.00 29.66           N  
ATOM   4782  CA  LYS D 111      42.513  44.848  68.394  1.00 28.21           C  
ATOM   4783  C   LYS D 111      41.451  43.766  68.405  1.00 26.74           C  
ATOM   4784  O   LYS D 111      40.969  43.416  67.356  1.00 33.16           O  
ATOM   4785  CB  LYS D 111      43.539  44.604  67.280  1.00 31.71           C  
ATOM   4786  CG  LYS D 111      44.697  45.611  67.228  1.00 31.17           C  
ATOM   4787  CD  LYS D 111      45.159  45.849  65.849  1.00 34.50           C  
ATOM   4788  CE  LYS D 111      46.597  46.375  65.739  1.00 37.89           C  
ATOM   4789  NZ  LYS D 111      46.885  47.618  66.444  1.00 37.09           N  
ATOM   4790  N   ALA D 112      41.078  43.265  69.591  1.00 25.48           N  
ATOM   4791  CA  ALA D 112      39.972  42.319  69.789  1.00 27.29           C  
ATOM   4792  C   ALA D 112      40.061  41.123  68.825  1.00 29.49           C  
ATOM   4793  O   ALA D 112      39.075  40.760  68.172  1.00 27.18           O  
ATOM   4794  CB  ALA D 112      38.589  43.028  69.661  1.00 26.47           C  
ATOM   4795  N   LEU D 113      41.252  40.518  68.758  1.00 29.40           N  
ATOM   4796  CA  LEU D 113      41.563  39.553  67.695  1.00 29.86           C  
ATOM   4797  C   LEU D 113      41.268  38.108  68.043  1.00 25.21           C  
ATOM   4798  O   LEU D 113      41.233  37.310  67.161  1.00 26.83           O  
ATOM   4799  CB  LEU D 113      43.010  39.717  67.226  1.00 27.70           C  
ATOM   4800  CG  LEU D 113      43.187  41.040  66.490  1.00 29.93           C  
ATOM   4801  CD1 LEU D 113      44.640  41.271  66.134  1.00 32.92           C  
ATOM   4802  CD2 LEU D 113      42.298  41.117  65.232  1.00 31.94           C  
ATOM   4803  N   THR D 114      41.058  37.808  69.321  1.00 25.63           N  
ATOM   4804  CA  THR D 114      40.755  36.468  69.801  1.00 23.11           C  
ATOM   4805  C   THR D 114      39.568  36.550  70.761  1.00 25.25           C  
ATOM   4806  O   THR D 114      39.201  37.645  71.177  1.00 23.22           O  
ATOM   4807  CB  THR D 114      41.939  35.868  70.590  1.00 25.75           C  
ATOM   4808  OG1 THR D 114      42.224  36.700  71.747  1.00 27.20           O  
ATOM   4809  CG2 THR D 114      43.177  35.723  69.693  1.00 21.14           C  
ATOM   4810  N   LEU D 115      38.998  35.401  71.131  1.00 21.87           N  
ATOM   4811  CA  LEU D 115      37.877  35.366  72.059  1.00 24.58           C  
ATOM   4812  C   LEU D 115      38.273  35.888  73.431  1.00 26.25           C  
ATOM   4813  O   LEU D 115      37.443  36.486  74.120  1.00 26.83           O  
ATOM   4814  CB  LEU D 115      37.309  33.943  72.221  1.00 26.38           C  
ATOM   4815  N   GLU D 116      39.532  35.635  73.806  1.00 24.98           N  
ATOM   4816  CA  GLU D 116      40.110  36.054  75.084  1.00 23.24           C  
ATOM   4817  C   GLU D 116      40.287  37.552  75.109  1.00 24.98           C  
ATOM   4818  O   GLU D 116      39.971  38.185  76.106  1.00 26.35           O  
ATOM   4819  CB  GLU D 116      41.454  35.381  75.326  1.00 20.26           C  
ATOM   4820  CG  GLU D 116      41.328  33.888  75.629  1.00 24.69           C  
ATOM   4821  CD  GLU D 116      41.045  32.966  74.397  1.00 24.22           C  
ATOM   4822  OE1 GLU D 116      41.399  33.262  73.251  1.00 22.79           O  
ATOM   4823  OE2 GLU D 116      40.476  31.909  74.614  1.00 30.60           O  
ATOM   4824  N   GLY D 117      40.795  38.115  74.016  1.00 26.01           N  
ATOM   4825  CA  GLY D 117      40.931  39.565  73.881  1.00 26.21           C  
ATOM   4826  C   GLY D 117      39.574  40.268  73.924  1.00 26.96           C  
ATOM   4827  O   GLY D 117      39.401  41.310  74.580  1.00 20.51           O  
ATOM   4828  N   GLN D 118      38.610  39.687  73.218  1.00 23.70           N  
ATOM   4829  CA  GLN D 118      37.257  40.194  73.186  1.00 21.02           C  
ATOM   4830  C   GLN D 118      36.586  40.194  74.554  1.00 21.71           C  
ATOM   4831  O   GLN D 118      35.902  41.128  74.901  1.00 26.53           O  
ATOM   4832  CB  GLN D 118      36.405  39.392  72.188  1.00 22.00           C  
ATOM   4833  CG  GLN D 118      36.758  39.704  70.774  1.00 24.57           C  
ATOM   4834  CD  GLN D 118      36.023  38.842  69.747  1.00 32.67           C  
ATOM   4835  OE1 GLN D 118      35.200  37.991  70.085  1.00 34.16           O  
ATOM   4836  NE2 GLN D 118      36.317  39.084  68.470  1.00 42.11           N  
ATOM   4837  N   LEU D 119      36.753  39.106  75.285  1.00 23.59           N  
ATOM   4838  CA  LEU D 119      36.221  38.964  76.612  1.00 25.76           C  
ATOM   4839  C   LEU D 119      36.694  40.111  77.544  1.00 26.85           C  
ATOM   4840  O   LEU D 119      35.906  40.673  78.269  1.00 20.66           O  
ATOM   4841  CB  LEU D 119      36.667  37.611  77.216  1.00 25.03           C  
ATOM   4842  CG  LEU D 119      36.051  37.334  78.609  1.00 24.64           C  
ATOM   4843  CD1 LEU D 119      34.570  37.337  78.488  1.00 29.64           C  
ATOM   4844  CD2 LEU D 119      36.489  36.048  79.197  1.00 25.52           C  
ATOM   4845  N   VAL D 120      37.999  40.387  77.529  1.00 25.18           N  
ATOM   4846  CA  VAL D 120      38.577  41.466  78.317  1.00 23.50           C  
ATOM   4847  C   VAL D 120      38.109  42.861  77.856  1.00 22.45           C  
ATOM   4848  O   VAL D 120      37.902  43.740  78.682  1.00 19.75           O  
ATOM   4849  CB  VAL D 120      40.118  41.361  78.332  1.00 19.12           C  
ATOM   4850  CG1 VAL D 120      40.755  42.494  79.134  1.00 19.93           C  
ATOM   4851  CG2 VAL D 120      40.515  40.046  78.962  1.00 17.80           C  
ATOM   4852  N   LYS D 121      37.964  43.064  76.553  1.00 21.59           N  
ATOM   4853  CA  LYS D 121      37.362  44.310  76.026  1.00 25.04           C  
ATOM   4854  C   LYS D 121      35.936  44.558  76.553  1.00 26.26           C  
ATOM   4855  O   LYS D 121      35.547  45.680  76.915  1.00 21.74           O  
ATOM   4856  CB  LYS D 121      37.373  44.292  74.478  1.00 28.51           C  
ATOM   4857  CG  LYS D 121      37.630  45.656  73.837  1.00 31.26           C  
ATOM   4858  N   ILE D 122      35.154  43.490  76.559  1.00 26.63           N  
ATOM   4859  CA  ILE D 122      33.830  43.467  77.157  1.00 30.28           C  
ATOM   4860  C   ILE D 122      33.819  43.770  78.672  1.00 26.31           C  
ATOM   4861  O   ILE D 122      33.026  44.594  79.134  1.00 26.50           O  
ATOM   4862  CB  ILE D 122      33.203  42.072  76.911  1.00 30.11           C  
ATOM   4863  CG1 ILE D 122      32.787  42.028  75.463  1.00 40.15           C  
ATOM   4864  CG2 ILE D 122      32.026  41.844  77.752  1.00 34.79           C  
ATOM   4865  CD1 ILE D 122      32.402  40.726  75.001  1.00 43.33           C  
ATOM   4866  N   ALA D 123      34.638  43.034  79.427  1.00 19.33           N  
ATOM   4867  CA  ALA D 123      34.799  43.248  80.861  1.00 22.54           C  
ATOM   4868  C   ALA D 123      35.249  44.701  81.157  1.00 22.83           C  
ATOM   4869  O   ALA D 123      34.767  45.368  82.097  1.00 21.97           O  
ATOM   4870  CB  ALA D 123      35.809  42.249  81.419  1.00 19.56           C  
ATOM   4871  N   ASP D 124      36.168  45.178  80.335  1.00 20.80           N  
ATOM   4872  CA  ASP D 124      36.634  46.552  80.398  1.00 25.03           C  
ATOM   4873  C   ASP D 124      35.520  47.653  80.243  1.00 23.09           C  
ATOM   4874  O   ASP D 124      35.416  48.611  81.081  1.00 14.30           O  
ATOM   4875  CB  ASP D 124      37.703  46.728  79.356  1.00 27.46           C  
ATOM   4876  CG  ASP D 124      38.489  47.922  79.575  1.00 29.10           C  
ATOM   4877  OD1 ASP D 124      39.222  47.936  80.554  1.00 34.58           O  
ATOM   4878  OD2 ASP D 124      38.362  48.855  78.788  1.00 32.36           O  
ATOM   4879  N   LYS D 125      34.703  47.500  79.196  1.00 20.70           N  
ATOM   4880  CA  LYS D 125      33.533  48.326  78.981  1.00 24.44           C  
ATOM   4881  C   LYS D 125      32.502  48.168  80.094  1.00 22.32           C  
ATOM   4882  O   LYS D 125      31.930  49.156  80.520  1.00 23.68           O  
ATOM   4883  CB  LYS D 125      32.869  48.042  77.602  1.00 27.28           C  
ATOM   4884  CG  LYS D 125      33.716  48.566  76.421  1.00 32.14           C  
ATOM   4885  CD  LYS D 125      33.397  47.851  75.091  1.00 34.72           C  
ATOM   4886  N   LEU D 126      32.241  46.933  80.526  1.00 21.60           N  
ATOM   4887  CA  LEU D 126      31.236  46.689  81.560  1.00 24.20           C  
ATOM   4888  C   LEU D 126      31.649  47.356  82.909  1.00 24.29           C  
ATOM   4889  O   LEU D 126      30.818  47.916  83.608  1.00 20.86           O  
ATOM   4890  CB  LEU D 126      30.994  45.189  81.734  1.00 24.88           C  
ATOM   4891  CG  LEU D 126      30.161  44.490  80.645  1.00 28.16           C  
ATOM   4892  CD1 LEU D 126      30.037  43.015  80.997  1.00 26.62           C  
ATOM   4893  CD2 LEU D 126      28.775  45.144  80.486  1.00 27.33           C  
ATOM   4894  N   ASP D 127      32.932  47.289  83.252  1.00 20.83           N  
ATOM   4895  CA  ASP D 127      33.416  47.972  84.438  1.00 23.66           C  
ATOM   4896  C   ASP D 127      33.130  49.483  84.358  1.00 23.56           C  
ATOM   4897  O   ASP D 127      32.666  50.065  85.308  1.00 21.02           O  
ATOM   4898  CB  ASP D 127      34.905  47.711  84.689  1.00 18.57           C  
ATOM   4899  CG  ASP D 127      35.464  48.570  85.816  1.00 21.23           C  
ATOM   4900  OD1 ASP D 127      35.167  48.251  86.986  1.00 19.65           O  
ATOM   4901  OD2 ASP D 127      36.191  49.560  85.525  1.00 18.16           O  
ATOM   4902  N   MET D 128      33.433  50.097  83.221  1.00 27.10           N  
ATOM   4903  CA  MET D 128      33.245  51.532  83.048  1.00 28.34           C  
ATOM   4904  C   MET D 128      31.765  51.933  83.059  1.00 23.80           C  
ATOM   4905  O   MET D 128      31.405  52.931  83.657  1.00 17.82           O  
ATOM   4906  CB  MET D 128      33.925  52.022  81.752  1.00 29.56           C  
ATOM   4907  CG  MET D 128      33.554  53.448  81.356  1.00 33.33           C  
ATOM   4908  SD  MET D 128      34.367  53.976  79.862  1.00 39.65           S  
ATOM   4909  CE  MET D 128      33.194  53.354  78.649  1.00 40.59           C  
ATOM   4910  N   ILE D 129      30.919  51.191  82.353  1.00 22.21           N  
ATOM   4911  CA  ILE D 129      29.476  51.440  82.383  1.00 22.05           C  
ATOM   4912  C   ILE D 129      28.891  51.288  83.799  1.00 18.82           C  
ATOM   4913  O   ILE D 129      28.096  52.110  84.274  1.00 19.62           O  
ATOM   4914  CB  ILE D 129      28.673  50.505  81.410  1.00 22.81           C  
ATOM   4915  CG1 ILE D 129      29.114  50.707  79.948  1.00 24.46           C  
ATOM   4916  CG2 ILE D 129      27.180  50.815  81.510  1.00 21.60           C  
ATOM   4917  CD1 ILE D 129      28.839  49.486  78.989  1.00 24.98           C  
ATOM   4918  N   ILE D 130      29.249  50.219  84.467  1.00 17.99           N  
ATOM   4919  CA  ILE D 130      28.750  50.005  85.779  1.00 18.65           C  
ATOM   4920  C   ILE D 130      29.322  51.053  86.747  1.00 19.69           C  
ATOM   4921  O   ILE D 130      28.617  51.506  87.622  1.00 16.45           O  
ATOM   4922  CB  ILE D 130      29.024  48.585  86.252  1.00 21.76           C  
ATOM   4923  CG1 ILE D 130      28.210  47.604  85.394  1.00 22.76           C  
ATOM   4924  CG2 ILE D 130      28.654  48.406  87.740  1.00 20.48           C  
ATOM   4925  CD1 ILE D 130      28.640  46.147  85.564  1.00 21.36           C  
ATOM   4926  N   GLN D 131      30.578  51.445  86.568  1.00 19.23           N  
ATOM   4927  CA  GLN D 131      31.173  52.468  87.405  1.00 17.63           C  
ATOM   4928  C   GLN D 131      30.470  53.799  87.211  1.00 16.02           C  
ATOM   4929  O   GLN D 131      30.282  54.537  88.184  1.00 13.97           O  
ATOM   4930  CB  GLN D 131      32.687  52.593  87.163  1.00 15.51           C  
ATOM   4931  CG  GLN D 131      33.423  53.488  88.164  1.00 15.81           C  
ATOM   4932  CD  GLN D 131      33.283  53.015  89.581  1.00 17.47           C  
ATOM   4933  OE1 GLN D 131      33.722  51.902  89.912  1.00 19.22           O  
ATOM   4934  NE2 GLN D 131      32.627  53.846  90.446  1.00 12.42           N  
ATOM   4935  N   ALA D 132      30.035  54.098  85.997  1.00 16.18           N  
ATOM   4936  CA  ALA D 132      29.317  55.382  85.721  1.00 20.55           C  
ATOM   4937  C   ALA D 132      27.979  55.403  86.441  1.00 21.16           C  
ATOM   4938  O   ALA D 132      27.595  56.426  87.011  1.00 22.17           O  
ATOM   4939  CB  ALA D 132      29.094  55.598  84.213  1.00 22.29           C  
ATOM   4940  N   TYR D 133      27.292  54.267  86.436  1.00 23.63           N  
ATOM   4941  CA  TYR D 133      26.072  54.085  87.238  1.00 25.11           C  
ATOM   4942  C   TYR D 133      26.383  54.313  88.739  1.00 21.89           C  
ATOM   4943  O   TYR D 133      25.632  54.958  89.439  1.00 20.41           O  
ATOM   4944  CB  TYR D 133      25.409  52.676  86.948  1.00 26.18           C  
ATOM   4945  CG  TYR D 133      24.494  52.148  88.059  1.00 28.01           C  
ATOM   4946  CD1 TYR D 133      23.141  52.538  88.154  1.00 27.97           C  
ATOM   4947  CD2 TYR D 133      24.986  51.252  89.005  1.00 26.41           C  
ATOM   4948  CE1 TYR D 133      22.311  52.046  89.179  1.00 27.38           C  
ATOM   4949  CE2 TYR D 133      24.204  50.774  90.022  1.00 26.27           C  
ATOM   4950  CZ  TYR D 133      22.855  51.157  90.123  1.00 31.37           C  
ATOM   4951  OH  TYR D 133      22.114  50.631  91.196  1.00 29.41           O  
ATOM   4952  N   GLU D 134      27.502  53.789  89.226  1.00 22.42           N  
ATOM   4953  CA  GLU D 134      27.866  53.962  90.639  1.00 20.20           C  
ATOM   4954  C   GLU D 134      28.168  55.434  91.018  1.00 20.25           C  
ATOM   4955  O   GLU D 134      27.732  55.930  92.051  1.00 20.51           O  
ATOM   4956  CB  GLU D 134      29.035  53.065  90.983  1.00 22.57           C  
ATOM   4957  CG  GLU D 134      28.630  51.598  90.969  1.00 24.16           C  
ATOM   4958  CD  GLU D 134      29.802  50.675  91.194  1.00 25.72           C  
ATOM   4959  OE1 GLU D 134      30.195  50.492  92.368  1.00 30.70           O  
ATOM   4960  OE2 GLU D 134      30.345  50.145  90.208  1.00 23.39           O  
ATOM   4961  N   TYR D 135      28.869  56.137  90.149  1.00 20.95           N  
ATOM   4962  CA  TYR D 135      29.159  57.538  90.375  1.00 19.11           C  
ATOM   4963  C   TYR D 135      27.901  58.404  90.237  1.00 20.82           C  
ATOM   4964  O   TYR D 135      27.775  59.370  90.945  1.00 21.60           O  
ATOM   4965  CB  TYR D 135      30.262  57.996  89.457  1.00 15.25           C  
ATOM   4966  CG  TYR D 135      31.660  57.538  89.860  1.00 18.20           C  
ATOM   4967  CD1 TYR D 135      32.063  57.428  91.212  1.00 14.48           C  
ATOM   4968  CD2 TYR D 135      32.612  57.226  88.872  1.00 17.72           C  
ATOM   4969  CE1 TYR D 135      33.371  56.964  91.547  1.00 13.37           C  
ATOM   4970  CE2 TYR D 135      33.900  56.847  89.206  1.00 13.13           C  
ATOM   4971  CZ  TYR D 135      34.277  56.716  90.527  1.00 11.95           C  
ATOM   4972  OH  TYR D 135      35.575  56.284  90.757  1.00 15.37           O  
ATOM   4973  N   GLU D 136      26.946  58.027  89.376  1.00 22.97           N  
ATOM   4974  CA  GLU D 136      25.626  58.686  89.380  1.00 23.86           C  
ATOM   4975  C   GLU D 136      24.893  58.547  90.732  1.00 21.77           C  
ATOM   4976  O   GLU D 136      24.316  59.486  91.210  1.00 23.39           O  
ATOM   4977  CB  GLU D 136      24.749  58.174  88.252  1.00 24.55           C  
ATOM   4978  CG  GLU D 136      25.216  58.634  86.905  1.00 30.65           C  
ATOM   4979  CD  GLU D 136      24.518  57.952  85.706  1.00 33.97           C  
ATOM   4980  OE1 GLU D 136      23.731  56.991  85.911  1.00 39.07           O  
ATOM   4981  OE2 GLU D 136      24.769  58.392  84.553  1.00 38.13           O  
ATOM   4982  N   LEU D 137      24.962  57.384  91.355  1.00 20.74           N  
ATOM   4983  CA  LEU D 137      24.375  57.187  92.676  1.00 24.82           C  
ATOM   4984  C   LEU D 137      24.964  58.113  93.772  1.00 26.39           C  
ATOM   4985  O   LEU D 137      24.270  58.475  94.714  1.00 24.80           O  
ATOM   4986  CB  LEU D 137      24.534  55.729  93.109  1.00 24.49           C  
ATOM   4987  CG  LEU D 137      23.673  54.687  92.369  1.00 26.74           C  
ATOM   4988  CD1 LEU D 137      23.972  53.332  92.917  1.00 26.69           C  
ATOM   4989  CD2 LEU D 137      22.200  54.980  92.528  1.00 28.03           C  
ATOM   4990  N   SER D 138      26.237  58.469  93.626  1.00 25.90           N  
ATOM   4991  CA  SER D 138      26.929  59.366  94.532  1.00 24.24           C  
ATOM   4992  C   SER D 138      26.937  60.813  94.086  1.00 20.93           C  
ATOM   4993  O   SER D 138      27.529  61.595  94.742  1.00 22.84           O  
ATOM   4994  CB  SER D 138      28.399  58.894  94.734  1.00 24.56           C  
ATOM   4995  OG  SER D 138      28.386  57.628  95.396  1.00 24.25           O  
ATOM   4996  N   GLY D 139      26.293  61.169  92.976  1.00 24.60           N  
ATOM   4997  CA  GLY D 139      26.085  62.569  92.639  1.00 21.56           C  
ATOM   4998  C   GLY D 139      26.310  63.021  91.208  1.00 21.89           C  
ATOM   4999  O   GLY D 139      25.812  64.083  90.807  1.00 24.01           O  
ATOM   5000  N   ALA D 140      27.033  62.253  90.407  1.00 19.53           N  
ATOM   5001  CA  ALA D 140      27.397  62.751  89.081  1.00 20.79           C  
ATOM   5002  C   ALA D 140      26.155  62.818  88.201  1.00 24.11           C  
ATOM   5003  O   ALA D 140      25.392  61.858  88.145  1.00 27.40           O  
ATOM   5004  CB  ALA D 140      28.471  61.865  88.454  1.00 18.02           C  
ATOM   5005  N   LYS D 141      25.947  63.946  87.525  1.00 24.10           N  
ATOM   5006  CA  LYS D 141      24.801  64.113  86.637  1.00 26.12           C  
ATOM   5007  C   LYS D 141      25.242  64.216  85.172  1.00 25.54           C  
ATOM   5008  O   LYS D 141      24.449  64.363  84.314  1.00 26.67           O  
ATOM   5009  CB  LYS D 141      23.961  65.344  87.062  1.00 30.11           C  
ATOM   5010  CG  LYS D 141      23.016  65.055  88.221  1.00 34.07           C  
ATOM   5011  CD  LYS D 141      23.245  65.975  89.444  1.00 40.41           C  
ATOM   5012  N   ASN D 142      26.528  64.105  84.900  1.00 26.23           N  
ATOM   5013  CA  ASN D 142      27.045  64.383  83.581  1.00 26.14           C  
ATOM   5014  C   ASN D 142      27.792  63.148  82.974  1.00 25.49           C  
ATOM   5015  O   ASN D 142      28.760  63.317  82.234  1.00 25.55           O  
ATOM   5016  CB  ASN D 142      27.961  65.622  83.685  1.00 25.66           C  
ATOM   5017  CG  ASN D 142      29.108  65.399  84.667  1.00 25.26           C  
ATOM   5018  OD1 ASN D 142      29.067  64.452  85.450  1.00 23.71           O  
ATOM   5019  ND2 ASN D 142      30.118  66.273  84.639  1.00 21.33           N  
ATOM   5020  N   LEU D 143      27.344  61.923  83.310  1.00 28.56           N  
ATOM   5021  CA  LEU D 143      28.045  60.686  82.875  1.00 30.40           C  
ATOM   5022  C   LEU D 143      27.266  59.826  81.870  1.00 32.30           C  
ATOM   5023  O   LEU D 143      27.603  58.646  81.669  1.00 30.66           O  
ATOM   5024  CB  LEU D 143      28.429  59.800  84.088  1.00 27.89           C  
ATOM   5025  CG  LEU D 143      29.222  60.413  85.242  1.00 26.62           C  
ATOM   5026  CD1 LEU D 143      29.514  59.383  86.291  1.00 26.92           C  
ATOM   5027  CD2 LEU D 143      30.540  61.093  84.805  1.00 27.07           C  
ATOM   5028  N   SER D 144      26.236  60.389  81.253  1.00 39.08           N  
ATOM   5029  CA  SER D 144      25.338  59.595  80.371  1.00 45.96           C  
ATOM   5030  C   SER D 144      26.067  59.040  79.148  1.00 45.07           C  
ATOM   5031  O   SER D 144      25.808  57.919  78.733  1.00 41.18           O  
ATOM   5032  CB  SER D 144      24.136  60.419  79.910  1.00 47.14           C  
ATOM   5033  OG  SER D 144      24.592  61.457  79.043  1.00 51.03           O  
ATOM   5034  N   GLU D 145      27.002  59.810  78.607  1.00 48.16           N  
ATOM   5035  CA  GLU D 145      27.821  59.333  77.486  1.00 54.02           C  
ATOM   5036  C   GLU D 145      28.603  58.025  77.789  1.00 54.29           C  
ATOM   5037  O   GLU D 145      28.910  57.270  76.865  1.00 54.07           O  
ATOM   5038  CB  GLU D 145      28.803  60.409  77.048  1.00 55.33           C  
ATOM   5039  CG  GLU D 145      29.973  60.540  77.989  1.00 58.58           C  
ATOM   5040  CD  GLU D 145      30.647  61.875  77.896  1.00 62.23           C  
ATOM   5041  OE1 GLU D 145      31.899  61.886  77.812  1.00 61.71           O  
ATOM   5042  OE2 GLU D 145      29.924  62.915  77.900  1.00 65.39           O  
ATOM   5043  N   PHE D 146      28.950  57.788  79.058  1.00 51.75           N  
ATOM   5044  CA  PHE D 146      29.555  56.521  79.452  1.00 50.45           C  
ATOM   5045  C   PHE D 146      28.466  55.465  79.528  1.00 51.01           C  
ATOM   5046  O   PHE D 146      28.757  54.291  79.342  1.00 53.63           O  
ATOM   5047  CB  PHE D 146      30.267  56.608  80.807  1.00 49.12           C  
ATOM   5048  CG  PHE D 146      31.394  57.557  80.827  1.00 48.31           C  
ATOM   5049  CD1 PHE D 146      32.604  57.221  80.272  1.00 50.95           C  
ATOM   5050  CD2 PHE D 146      31.254  58.806  81.401  1.00 48.43           C  
ATOM   5051  CE1 PHE D 146      33.673  58.134  80.281  1.00 52.03           C  
ATOM   5052  CE2 PHE D 146      32.299  59.701  81.421  1.00 47.29           C  
ATOM   5053  CZ  PHE D 146      33.505  59.371  80.858  1.00 50.17           C  
ATOM   5054  N   GLU D 157      30.679  40.700  69.210  1.00 43.55           N  
ATOM   5055  CA  GLU D 157      30.660  39.359  68.622  1.00 44.90           C  
ATOM   5056  C   GLU D 157      30.501  38.249  69.668  1.00 45.18           C  
ATOM   5057  O   GLU D 157      29.698  37.323  69.491  1.00 43.56           O  
ATOM   5058  CB  GLU D 157      31.931  39.104  67.816  1.00 45.17           C  
ATOM   5059  CG  GLU D 157      31.993  37.693  67.176  1.00 48.07           C  
ATOM   5060  N   ILE D 158      31.290  38.335  70.747  1.00 42.91           N  
ATOM   5061  CA  ILE D 158      31.277  37.327  71.837  1.00 39.92           C  
ATOM   5062  C   ILE D 158      30.087  37.630  72.742  1.00 35.83           C  
ATOM   5063  O   ILE D 158      29.743  36.864  73.628  1.00 39.24           O  
ATOM   5064  CB  ILE D 158      32.603  37.371  72.595  1.00 43.57           C  
ATOM   5065  CG1 ILE D 158      32.756  36.243  73.594  1.00 46.81           C  
ATOM   5066  CG2 ILE D 158      32.737  38.659  73.309  1.00 42.03           C  
ATOM   5067  CD1 ILE D 158      34.124  36.282  74.284  1.00 49.29           C  
ATOM   5068  N   SER D 159      29.478  38.778  72.487  1.00 35.01           N  
ATOM   5069  CA  SER D 159      28.291  39.226  73.137  1.00 36.12           C  
ATOM   5070  C   SER D 159      27.097  38.316  72.845  1.00 36.88           C  
ATOM   5071  O   SER D 159      26.145  38.285  73.629  1.00 36.44           O  
ATOM   5072  CB  SER D 159      27.995  40.658  72.656  1.00 41.11           C  
ATOM   5073  OG  SER D 159      28.184  40.782  71.232  1.00 43.39           O  
ATOM   5074  N   ARG D 160      27.124  37.571  71.727  1.00 36.79           N  
ATOM   5075  CA  ARG D 160      26.095  36.533  71.495  1.00 35.18           C  
ATOM   5076  C   ARG D 160      26.011  35.527  72.630  1.00 34.09           C  
ATOM   5077  O   ARG D 160      24.954  34.940  72.853  1.00 32.46           O  
ATOM   5078  CB  ARG D 160      26.288  35.800  70.147  1.00 37.24           C  
ATOM   5079  CG  ARG D 160      27.533  34.957  69.984  1.00 36.25           C  
ATOM   5080  CD  ARG D 160      27.679  34.504  68.514  1.00 40.13           C  
ATOM   5081  NE  ARG D 160      28.308  33.188  68.434  1.00 44.06           N  
ATOM   5082  CZ  ARG D 160      28.160  32.273  67.461  1.00 45.63           C  
ATOM   5083  NH1 ARG D 160      27.381  32.470  66.402  1.00 46.05           N  
ATOM   5084  NH2 ARG D 160      28.818  31.118  67.558  1.00 45.01           N  
ATOM   5085  N   TYR D 161      27.125  35.314  73.340  1.00 35.12           N  
ATOM   5086  CA  TYR D 161      27.138  34.409  74.509  1.00 34.64           C  
ATOM   5087  C   TYR D 161      26.851  35.066  75.846  1.00 33.68           C  
ATOM   5088  O   TYR D 161      26.829  34.365  76.876  1.00 33.15           O  
ATOM   5089  CB  TYR D 161      28.483  33.701  74.656  1.00 35.53           C  
ATOM   5090  CG  TYR D 161      29.051  33.110  73.401  1.00 33.68           C  
ATOM   5091  CD1 TYR D 161      28.422  32.061  72.740  1.00 34.71           C  
ATOM   5092  CD2 TYR D 161      30.243  33.581  72.901  1.00 32.48           C  
ATOM   5093  CE1 TYR D 161      29.007  31.504  71.568  1.00 35.46           C  
ATOM   5094  CE2 TYR D 161      30.815  33.056  71.761  1.00 34.22           C  
ATOM   5095  CZ  TYR D 161      30.208  32.023  71.103  1.00 34.24           C  
ATOM   5096  OH  TYR D 161      30.828  31.546  69.981  1.00 35.56           O  
ATOM   5097  N   LEU D 162      26.633  36.382  75.850  1.00 34.67           N  
ATOM   5098  CA  LEU D 162      26.586  37.136  77.094  1.00 35.65           C  
ATOM   5099  C   LEU D 162      25.372  38.035  77.159  1.00 39.51           C  
ATOM   5100  O   LEU D 162      25.424  39.082  77.793  1.00 37.56           O  
ATOM   5101  CB  LEU D 162      27.880  37.962  77.268  1.00 35.96           C  
ATOM   5102  CG  LEU D 162      29.249  37.244  77.273  1.00 33.65           C  
ATOM   5103  CD1 LEU D 162      30.345  38.286  77.178  1.00 35.16           C  
ATOM   5104  CD2 LEU D 162      29.450  36.375  78.504  1.00 32.77           C  
ATOM   5105  N   ARG D 163      24.263  37.593  76.548  1.00 40.20           N  
ATOM   5106  CA  ARG D 163      23.020  38.369  76.478  1.00 40.99           C  
ATOM   5107  C   ARG D 163      22.389  38.625  77.845  1.00 39.17           C  
ATOM   5108  O   ARG D 163      21.834  39.689  78.093  1.00 41.27           O  
ATOM   5109  CB  ARG D 163      21.980  37.646  75.590  1.00 43.28           C  
ATOM   5110  CG  ARG D 163      22.376  37.438  74.122  1.00 46.20           C  
ATOM   5111  CD  ARG D 163      22.449  38.751  73.348  1.00 48.13           C  
ATOM   5112  NE  ARG D 163      22.959  38.543  71.990  1.00 46.60           N  
ATOM   5113  CZ  ARG D 163      23.650  39.436  71.288  1.00 49.60           C  
ATOM   5114  NH1 ARG D 163      23.938  40.646  71.792  1.00 53.29           N  
ATOM   5115  NH2 ARG D 163      24.068  39.116  70.072  1.00 49.38           N  
ATOM   5116  N   GLU D 164      22.449  37.625  78.706  1.00 40.31           N  
ATOM   5117  CA  GLU D 164      21.935  37.709  80.074  1.00 43.84           C  
ATOM   5118  C   GLU D 164      22.546  38.900  80.883  1.00 44.45           C  
ATOM   5119  O   GLU D 164      21.815  39.766  81.362  1.00 41.89           O  
ATOM   5120  CB  GLU D 164      22.194  36.375  80.805  1.00 47.45           C  
ATOM   5121  CG  GLU D 164      21.449  35.112  80.207  1.00 51.79           C  
ATOM   5122  CD  GLU D 164      22.232  34.304  79.108  1.00 53.68           C  
ATOM   5123  OE1 GLU D 164      23.282  34.769  78.563  1.00 49.51           O  
ATOM   5124  OE2 GLU D 164      21.756  33.180  78.783  1.00 55.44           O  
ATOM   5125  N   ILE D 165      23.881  38.938  80.999  1.00 43.95           N  
ATOM   5126  CA  ILE D 165      24.580  39.985  81.749  1.00 42.67           C  
ATOM   5127  C   ILE D 165      24.455  41.340  81.052  1.00 44.17           C  
ATOM   5128  O   ILE D 165      24.316  42.362  81.703  1.00 42.56           O  
ATOM   5129  CB  ILE D 165      26.115  39.606  82.030  1.00 44.03           C  
ATOM   5130  CG1 ILE D 165      26.741  40.519  83.130  1.00 43.22           C  
ATOM   5131  CG2 ILE D 165      26.974  39.631  80.717  1.00 41.17           C  
ATOM   5132  N   ILE D 166      24.473  41.356  79.729  1.00 46.16           N  
ATOM   5133  CA  ILE D 166      24.310  42.614  79.016  1.00 48.94           C  
ATOM   5134  C   ILE D 166      22.952  43.273  79.353  1.00 50.47           C  
ATOM   5135  O   ILE D 166      22.901  44.482  79.557  1.00 50.47           O  
ATOM   5136  CB  ILE D 166      24.505  42.445  77.502  1.00 50.85           C  
ATOM   5137  CG1 ILE D 166      25.957  42.067  77.202  1.00 50.78           C  
ATOM   5138  CG2 ILE D 166      24.163  43.754  76.758  1.00 52.37           C  
ATOM   5139  CD1 ILE D 166      26.193  41.535  75.773  1.00 50.55           C  
ATOM   5140  N   GLU D 167      21.873  42.481  79.457  1.00 50.26           N  
ATOM   5141  CA  GLU D 167      20.545  43.032  79.818  1.00 50.05           C  
ATOM   5142  C   GLU D 167      20.365  43.331  81.330  1.00 47.64           C  
ATOM   5143  O   GLU D 167      19.650  44.257  81.688  1.00 50.29           O  
ATOM   5144  CB  GLU D 167      19.403  42.135  79.302  1.00 49.72           C  
ATOM   5145  N   GLU D 168      20.990  42.547  82.204  1.00 46.61           N  
ATOM   5146  CA  GLU D 168      21.062  42.878  83.621  1.00 47.48           C  
ATOM   5147  C   GLU D 168      21.632  44.291  83.839  1.00 51.75           C  
ATOM   5148  O   GLU D 168      21.151  45.059  84.718  1.00 54.87           O  
ATOM   5149  CB  GLU D 168      21.934  41.885  84.366  1.00 48.56           C  
ATOM   5150  CG  GLU D 168      21.210  40.686  84.910  1.00 52.23           C  
ATOM   5151  CD  GLU D 168      22.117  39.825  85.788  1.00 56.64           C  
ATOM   5152  OE1 GLU D 168      22.873  40.410  86.591  1.00 59.39           O  
ATOM   5153  OE2 GLU D 168      22.077  38.572  85.691  1.00 59.86           O  
ATOM   5154  N   VAL D 169      22.656  44.624  83.048  1.00 51.07           N  
ATOM   5155  CA  VAL D 169      23.274  45.943  83.077  1.00 50.93           C  
ATOM   5156  C   VAL D 169      22.294  46.996  82.534  1.00 53.24           C  
ATOM   5157  O   VAL D 169      22.055  48.000  83.200  1.00 53.80           O  
ATOM   5158  CB  VAL D 169      24.652  45.947  82.322  1.00 49.00           C  
ATOM   5159  CG1 VAL D 169      25.218  47.376  82.136  1.00 47.13           C  
ATOM   5160  CG2 VAL D 169      25.676  45.040  83.076  1.00 48.28           C  
ATOM   5161  N   ARG D 170      21.715  46.759  81.362  1.00 55.32           N  
ATOM   5162  CA  ARG D 170      20.708  47.676  80.795  1.00 60.76           C  
ATOM   5163  C   ARG D 170      19.588  48.041  81.804  1.00 62.96           C  
ATOM   5164  O   ARG D 170      19.290  49.213  82.022  1.00 66.53           O  
ATOM   5165  CB  ARG D 170      20.086  47.075  79.523  1.00 61.05           C  
ATOM   5166  N   ARG D 171      18.978  47.036  82.418  1.00 63.83           N  
ATOM   5167  CA  ARG D 171      17.961  47.266  83.432  1.00 64.10           C  
ATOM   5168  C   ARG D 171      18.435  48.316  84.452  1.00 64.66           C  
ATOM   5169  O   ARG D 171      19.066  47.989  85.459  1.00 65.91           O  
ATOM   5170  CB  ARG D 171      17.588  45.943  84.143  1.00 65.16           C  
ATOM   5171  CG  ARG D 171      16.698  44.974  83.319  1.00 63.69           C  
TER    5172      ARG D 171                                                      
END
MOLECULE T0470.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
