
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  187 ( 1492),  selected  187 , name 2o08_A
# Molecule2: number of CA atoms  188 ( 1523),  selected  188 , name T0470.pdb
# PARAMETERS: 2o08_A.T0470.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      T       2           -
LGA    G     0_A      K       3          3.518
LGA    -       -      Q       4           -
LGA    X     1_A      E       5          5.073
LGA    N     2_A      K       6          3.005
LGA    R     3_A      I       7          3.188
LGA    G     4_A      E       8          2.395
LGA    K     5_A      K       9          0.710
LGA    A     6_A      T      10          1.005
LGA    L     7_A      I      11          1.015
LGA    Q     8_A      T      12          0.621
LGA    L     9_A      F      13          0.618
LGA    V    10_A      V      14          0.680
LGA    K    11_A      K      15          0.828
LGA    P    12_A      H      16          1.929
LGA    -       -      I      17           -
LGA    H    13_A      L      18          1.023
LGA    L    14_A      E      19          5.480
LGA    -       -      K      20           -
LGA    -       -      D      21           -
LGA    -       -      A      22           -
LGA    T    15_A      S      23          2.421
LGA    E    16_A      G      24          4.548
LGA    H    17_A      H      25          3.871
LGA    R    18_A      D      26          1.086
LGA    Y    19_A      W      27          0.389
LGA    Q    20_A      Y      28          1.277
LGA    H    21_A      H      29          1.383
LGA    T    22_A      I      30          0.678
LGA    I    23_A      R      31          0.286
LGA    G    24_A      R      32          1.599
LGA    V    25_A      V      33          1.733
LGA    X    26_A      H      34          0.729
LGA    E    27_A      K      35          1.563
LGA    T    28_A      M      36          1.965
LGA    A    29_A      A      37          1.520
LGA    I    30_A      I      38          1.423
LGA    D    31_A      S      39          2.276
LGA    L    32_A      L      40          2.441
LGA    A    33_A      S      41          1.773
LGA    K    34_A      E      42          1.816
LGA    L    35_A      Q      43          2.242
LGA    Y    36_A      E      44          1.947
LGA    G    37_A      G      45          1.060
LGA    A    38_A      G      46          0.299
LGA    D    39_A      N      47          1.036
LGA    Q    40_A      R      48          1.354
LGA    Q    41_A      F      49          1.743
LGA    K    42_A      I      50          1.360
LGA    A    43_A      I      51          0.742
LGA    E    44_A      E      52          0.895
LGA    L    45_A      M      53          1.040
LGA    A    46_A      A      54          0.882
LGA    A    47_A      A      55          0.920
LGA    I    48_A      L      56          0.887
LGA    F    49_A      L      57          1.116
LGA    H    50_A      H      58          1.276
LGA    D    51_A      D      59          1.340
LGA    Y    52_A      V      60          1.311
LGA    A    53_A      A      61          2.580
LGA    K    54_A      D      62          2.994
LGA    F    55_A      L      65          2.730
LGA    R    56_A      N      66          2.623
LGA    D    57_A      E      67          2.556
LGA    K    58_A      S      68          1.996
LGA    N    59_A      -       -           -
LGA    E    60_A      -       -           -
LGA    X    61_A      E      69           #
LGA    R    62_A      -       -           -
LGA    T    63_A      -       -           -
LGA    L    64_A      -       -           -
LGA    I    65_A      -       -           -
LGA    R    66_A      -       -           -
LGA    E    67_A      -       -           -
LGA    K    68_A      -       -           -
LGA    L    69_A      -       -           -
LGA    S    70_A      -       -           -
LGA    Q    71_A      -       -           -
LGA    Q    72_A      -       -           -
LGA    D    73_A      -       -           -
LGA    I    74_A      -       -           -
LGA    L    75_A      -       -           -
LGA    F    76_A      -       -           -
LGA    Y    77_A      -       -           -
LGA    G    78_A      -       -           -
LGA    D    79_A      -       -           -
LGA    E    80_A      -       -           -
LGA    L    81_A      -       -           -
LGA    L    82_A      -       -           -
LGA    H    83_A      -       -           -
LGA    A    84_A      -       -           -
LGA    P    85_A      E      70          4.476
LGA    C    86_A      A      71          3.767
LGA    G    87_A      G      72          3.191
LGA    A    88_A      M      73          3.241
LGA    Y    89_A      K      74          2.352
LGA    Y    90_A      K      75          1.692
LGA    V    91_A      V      76          1.340
LGA    R    92_A      S      77          1.832
LGA    E    93_A      D      78          1.404
LGA    E    94_A      W      79          3.498
LGA    V    95_A      L      80          4.254
LGA    G    96_A      E      81          1.378
LGA    I    97_A      E      82           #
LGA    -       -      L      83           -
LGA    -       -      H      84           -
LGA    -       -      V      85           -
LGA    E    98_A      E      86          4.844
LGA    -       -      E      87           -
LGA    -       -      E      88           -
LGA    -       -      E      89           -
LGA    D    99_A      S      90          1.608
LGA    E   100_A      K      91          1.420
LGA    D   101_A      H      92          1.435
LGA    V   102_A      V      93          0.858
LGA    L   103_A      L      94          1.334
LGA    Q   104_A      H      95          0.795
LGA    A   105_A      I      96          1.606
LGA    I   106_A      I      97          0.950
LGA    R   107_A      A      98          1.806
LGA    F   108_A      N      99          1.832
LGA    H   109_A      M     100          1.781
LGA    T   110_A      -       -           -
LGA    T   111_A      -       -           -
LGA    G   112_A      -       -           -
LGA    R   113_A      -       -           -
LGA    P   114_A      -       -           -
LGA    N   115_A      -       -           -
LGA    X   116_A      -       -           -
LGA    S   117_A      S     112          1.555
LGA    L   118_A      I     113          1.471
LGA    L   119_A      E     114          1.658
LGA    E   120_A      G     115          2.170
LGA    K   121_A      K     116          1.613
LGA    I   122_A      L     117          1.785
LGA    I   123_A      V     118          2.155
LGA    F   124_A      Q     119          2.526
LGA    L   125_A      D     120          2.692
LGA    A   126_A      A     121          2.026
LGA    D   127_A      D     122          1.979
LGA    Y   128_A      R     123          1.557
LGA    I   129_A      L     124          1.476
LGA    E   130_A      D     125          2.334
LGA    P   131_A      -       -           -
LGA    N   132_A      A     126          5.307
LGA    R   133_A      L     127           #
LGA    Q   134_A      G     128           #
LGA    -       -      A     129           -
LGA    -       -      I     130           -
LGA    -       -      G     131           -
LGA    -       -      I     132           -
LGA    -       -      A     133           -
LGA    -       -      R     134           -
LGA    -       -      T     135           -
LGA    -       -      F     136           -
LGA    -       -      A     137           -
LGA    -       -      Y     138           -
LGA    -       -      G     139           -
LGA    -       -      G     140           -
LGA    -       -      A     141           -
LGA    -       -      K     142           -
LGA    -       -      G     143           -
LGA    -       -      R     144           -
LGA    -       -      L     145           -
LGA    -       -      M     146           -
LGA    -       -      Y     147           -
LGA    -       -      D     148           -
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    -       -      S     169           -
LGA    -       -      L     170           -
LGA    -       -      N     171           -
LGA    -       -      H     172           -
LGA    -       -      F     173           -
LGA    -       -      Y     174           -
LGA    -       -      E     175           -
LGA    F   135_A      K     176           #
LGA    P   136_A      L     177          1.463
LGA    G   137_A      L     178          1.350
LGA    V   138_A      K     179           #
LGA    E   139_A      L     180          6.849
LGA    K   140_A      K     181          3.135
LGA    V   141_A      D     182          4.573
LGA    R   142_A      L     183           -
LGA    T   143_A      -       -           -
LGA    Q   144_A      M     184          5.318
LGA    A   145_A      N     185          5.091
LGA    K   146_A      T     186          5.775
LGA    T   147_A      N     187          1.971
LGA    D   148_A      A     188           -
LGA    L   149_A      A     189           #
LGA    N   150_A      -       -           -
LGA    G   151_A      -       -           -
LGA    A   152_A      K     190           #
LGA    I   153_A      Q     191           -
LGA    I   154_A      E     192           -
LGA    S   155_A      A     193           -
LGA    S   156_A      E     194           -
LGA    L   157_A      V     195           -
LGA    V   158_A      R     196           -
LGA    N   159_A      H     197           -
LGA    T   160_A      R     198           -
LGA    I   161_A      Y     199           -
LGA    T   162_A      M     200           -
LGA    F   163_A      E     201           -
LGA    L   164_A      Q     202           -
LGA    L   165_A      F     203           -
LGA    K   166_A      I     204           -
LGA    K   167_A      E     205           -
LGA    N   168_A      Q     206           -
LGA    Q   169_A      F     207           -
LGA    P   170_A      M     208           -
LGA    I   171_A      K     209           -
LGA    Y   172_A      E     210           -
LGA    P   173_A      W     211           -
LGA    D   174_A      N     212           -
LGA    T   175_A      A     213           -
LGA    L   176_A      Q     214           -
LGA    A   177_A      -       -           -
LGA    T   178_A      -       -           -
LGA    Y   179_A      -       -           -
LGA    N   180_A      -       -           -
LGA    Q   181_A      -       -           -
LGA    L   182_A      -       -           -
LGA    L   183_A      -       -           -
LGA    L   184_A      -       -           -
LGA    E   185_A      -       -           -
LGA    Q   186_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  187  188    5.0    107    2.48    25.23     44.989     4.149

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.069005 * X  +  -0.529919 * Y  +  -0.845236 * Z  +  61.563923
  Y_new =   0.593594 * X  +   0.659144 * Y  +  -0.461710 * Z  +   0.275675
  Z_new =   0.801801 * X  +  -0.533587 * Y  +   0.269072 * Z  +  34.725735 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.103738    2.037855  [ DEG:   -63.2395    116.7605 ]
  Theta =  -0.930303   -2.211289  [ DEG:   -53.3024   -126.6976 ]
  Phi   =   1.686527   -1.455066  [ DEG:    96.6309    -83.3691 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o08_A                                        
REMARK     2: T0470.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o08_A.T0470.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  187  188   5.0  107   2.48   25.23  44.989
REMARK  ---------------------------------------------------------- 
MOLECULE 2o08_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-NOV-06   2O08              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE HD SUPERFAMILY HYDROLASE              
TITLE    2 (NP_242193.1) FROM BACILLUS HALODURANS AT 1.90 A RESOLUTION          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BH1327 PROTEIN;                                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_242193.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_242193.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PSI-2, PROTEIN           
KEYWDS   3 STRUCTURE INITIATIVE                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   19-DEC-06 2O08    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_242193.1) FROM BACILLUS HALODURANS AT 1.90 A             
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2O08 A    1   187  UNP    Q9KD90   Q9KD90_BACHD     1    187             
DBREF  2O08 B    1   187  UNP    Q9KD90   Q9KD90_BACHD     1    187             
SEQRES   1 A  188  GLY MSE ASN ARG GLY LYS ALA LEU GLN LEU VAL LYS PRO          
SEQRES   2 A  188  HIS LEU THR GLU HIS ARG TYR GLN HIS THR ILE GLY VAL          
SEQRES   3 A  188  MSE GLU THR ALA ILE ASP LEU ALA LYS LEU TYR GLY ALA          
SEQRES   4 A  188  ASP GLN GLN LYS ALA GLU LEU ALA ALA ILE PHE HIS ASP          
SEQRES   5 A  188  TYR ALA LYS PHE ARG ASP LYS ASN GLU MSE ARG THR LEU          
SEQRES   6 A  188  ILE ARG GLU LYS LEU SER GLN GLN ASP ILE LEU PHE TYR          
SEQRES   7 A  188  GLY ASP GLU LEU LEU HIS ALA PRO CYS GLY ALA TYR TYR          
SEQRES   8 A  188  VAL ARG GLU GLU VAL GLY ILE GLU ASP GLU ASP VAL LEU          
SEQRES   9 A  188  GLN ALA ILE ARG PHE HIS THR THR GLY ARG PRO ASN MSE          
SEQRES  10 A  188  SER LEU LEU GLU LYS ILE ILE PHE LEU ALA ASP TYR ILE          
SEQRES  11 A  188  GLU PRO ASN ARG GLN PHE PRO GLY VAL GLU LYS VAL ARG          
SEQRES  12 A  188  THR GLN ALA LYS THR ASP LEU ASN GLY ALA ILE ILE SER          
SEQRES  13 A  188  SER LEU VAL ASN THR ILE THR PHE LEU LEU LYS LYS ASN          
SEQRES  14 A  188  GLN PRO ILE TYR PRO ASP THR LEU ALA THR TYR ASN GLN          
SEQRES  15 A  188  LEU LEU LEU GLU GLN LYS                                      
SEQRES   1 B  188  GLY MSE ASN ARG GLY LYS ALA LEU GLN LEU VAL LYS PRO          
SEQRES   2 B  188  HIS LEU THR GLU HIS ARG TYR GLN HIS THR ILE GLY VAL          
SEQRES   3 B  188  MSE GLU THR ALA ILE ASP LEU ALA LYS LEU TYR GLY ALA          
SEQRES   4 B  188  ASP GLN GLN LYS ALA GLU LEU ALA ALA ILE PHE HIS ASP          
SEQRES   5 B  188  TYR ALA LYS PHE ARG ASP LYS ASN GLU MSE ARG THR LEU          
SEQRES   6 B  188  ILE ARG GLU LYS LEU SER GLN GLN ASP ILE LEU PHE TYR          
SEQRES   7 B  188  GLY ASP GLU LEU LEU HIS ALA PRO CYS GLY ALA TYR TYR          
SEQRES   8 B  188  VAL ARG GLU GLU VAL GLY ILE GLU ASP GLU ASP VAL LEU          
SEQRES   9 B  188  GLN ALA ILE ARG PHE HIS THR THR GLY ARG PRO ASN MSE          
SEQRES  10 B  188  SER LEU LEU GLU LYS ILE ILE PHE LEU ALA ASP TYR ILE          
SEQRES  11 B  188  GLU PRO ASN ARG GLN PHE PRO GLY VAL GLU LYS VAL ARG          
SEQRES  12 B  188  THR GLN ALA LYS THR ASP LEU ASN GLY ALA ILE ILE SER          
SEQRES  13 B  188  SER LEU VAL ASN THR ILE THR PHE LEU LEU LYS LYS ASN          
SEQRES  14 B  188  GLN PRO ILE TYR PRO ASP THR LEU ALA THR TYR ASN GLN          
SEQRES  15 B  188  LEU LEU LEU GLU GLN LYS                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  26       8                                                       
HET    MSE  A  61       8                                                       
HET    MSE  A 116       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  26       8                                                       
HET    MSE  B  61       8                                                       
HET    MSE  B 116       8                                                       
HET     FE  A 400       1                                                       
HET     FE  A 401       1                                                       
HET    PO4  A 500       5                                                       
HET     FE  B 400       1                                                       
HET     FE  B 401       1                                                       
HET    NO3      1       4                                                       
HET    UNL  A 501      14                                                       
HET    DGI  B 500      27                                                       
HET    PG4      2      10                                                       
HET    PG4      3       7                                                       
HET    PG4      4      10                                                       
HET    PG4      5      10                                                       
HET    PG4      6      10                                                       
HET    PG4      7       8                                                       
HET    PG4      8      10                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      FE FE (III) ION                                                     
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     NO3 NITRATE ION                                                      
HETNAM     UNL UNKNOWN LIGAND                                                   
HETNAM     DGI 2'-DEOXYGUANOSINE-5'-DIPHOSPHATE                                 
HETNAM     PG4 TETRAETHYLENE GLYCOL                                             
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3   FE    4(FE 3+)                                                     
FORMUL   5  PO4    O4 P 3-                                                      
FORMUL   8  NO3    N O3 1-                                                      
FORMUL  10  DGI    C10 H15 N5 O10 P2                                            
FORMUL  11  PG4    7(C8 H18 O5)                                                 
FORMUL  18  HOH   *325(H2 O)                                                    
CRYST1   86.830  166.510   73.410  90.00  90.00  90.00 C 2 2 21     16          
ATOM      1  N   GLY A   0      51.659  30.327  82.571  1.00 35.81           N  
ATOM      2  CA  GLY A   0      51.911  31.776  82.734  1.00 35.06           C  
ATOM      3  C   GLY A   0      52.027  32.229  84.170  1.00 34.97           C  
ATOM      4  O   GLY A   0      51.787  31.473  85.100  1.00 37.00           O  
HETATM    5  N   MSE A   1      52.411  33.491  84.326  1.00 35.39           N  
HETATM    6  CA  MSE A   1      52.548  34.104  85.633  1.00 36.13           C  
HETATM    7  C   MSE A   1      51.205  34.053  86.332  1.00 35.30           C  
HETATM    8  O   MSE A   1      50.181  34.286  85.695  1.00 34.10           O  
HETATM    9  CB  MSE A   1      52.972  35.556  85.450  1.00 34.33           C  
HETATM   10  CG  MSE A   1      53.230  36.320  86.688  1.00 40.47           C  
HETATM   11 SE   MSE A   1      53.906  38.062  86.301  0.75 32.93          SE  
HETATM   12  CE  MSE A   1      55.601  37.626  85.411  1.00 38.47           C  
ATOM     13  N   ASN A   2      51.206  33.808  87.640  1.00 35.48           N  
ATOM     14  CA  ASN A   2      49.968  33.730  88.378  1.00 35.46           C  
ATOM     15  C   ASN A   2      49.456  35.119  88.766  1.00 34.08           C  
ATOM     16  O   ASN A   2      50.171  36.093  88.651  1.00 34.81           O  
ATOM     17  CB  ASN A   2      50.075  32.748  89.555  1.00 35.44           C  
ATOM     18  CG  ASN A   2      50.876  33.274  90.733  1.00 44.60           C  
ATOM     19  OD1 ASN A   2      51.100  34.471  90.890  1.00 49.78           O  
ATOM     20  ND2 ASN A   2      51.258  32.353  91.626  1.00 46.09           N  
ATOM     21  N   ARG A   3      48.212  35.175  89.234  1.00 33.21           N  
ATOM     22  CA  ARG A   3      47.528  36.427  89.532  1.00 30.56           C  
ATOM     23  C   ARG A   3      48.326  37.281  90.498  1.00 33.07           C  
ATOM     24  O   ARG A   3      48.572  38.448  90.244  1.00 33.70           O  
ATOM     25  CB  ARG A   3      46.158  36.120  90.161  1.00 30.75           C  
ATOM     26  CG  ARG A   3      45.392  37.357  90.588  1.00 33.65           C  
ATOM     27  CD  ARG A   3      44.073  37.003  91.262  1.00 33.96           C  
ATOM     28  NE  ARG A   3      43.140  36.439  90.299  1.00 27.61           N  
ATOM     29  CZ  ARG A   3      41.836  36.276  90.498  1.00 32.81           C  
ATOM     30  NH1 ARG A   3      41.276  36.578  91.655  1.00 31.80           N  
ATOM     31  NH2 ARG A   3      41.090  35.784  89.533  1.00 34.14           N  
ATOM     32  N   GLY A   4      48.701  36.684  91.631  1.00 32.81           N  
ATOM     33  CA  GLY A   4      49.484  37.383  92.653  1.00 32.12           C  
ATOM     34  C   GLY A   4      50.746  38.047  92.138  1.00 32.78           C  
ATOM     35  O   GLY A   4      51.000  39.195  92.462  1.00 30.63           O  
ATOM     36  N   LYS A   5      51.539  37.332  91.344  1.00 31.65           N  
ATOM     37  CA  LYS A   5      52.782  37.907  90.819  1.00 28.81           C  
ATOM     38  C   LYS A   5      52.446  38.983  89.811  1.00 31.75           C  
ATOM     39  O   LYS A   5      53.025  40.082  89.847  1.00 29.84           O  
ATOM     40  CB  LYS A   5      53.711  36.867  90.167  1.00 30.15           C  
ATOM     41  CG  LYS A   5      54.174  35.726  91.034  1.00 33.47           C  
ATOM     42  CD  LYS A   5      54.856  36.160  92.272  1.00 43.38           C  
ATOM     43  CE  LYS A   5      55.390  34.936  93.004  1.00 47.70           C  
ATOM     44  NZ  LYS A   5      55.342  35.123  94.464  1.00 40.66           N  
ATOM     45  N   ALA A   6      51.485  38.692  88.927  1.00 31.43           N  
ATOM     46  CA  ALA A   6      51.080  39.676  87.915  1.00 32.19           C  
ATOM     47  C   ALA A   6      50.621  40.982  88.564  1.00 30.65           C  
ATOM     48  O   ALA A   6      51.081  42.090  88.193  1.00 29.83           O  
ATOM     49  CB  ALA A   6      49.988  39.082  86.998  1.00 32.44           C  
ATOM     50  N   LEU A   7      49.765  40.868  89.573  1.00 30.06           N  
ATOM     51  CA  LEU A   7      49.324  42.056  90.292  1.00 32.10           C  
ATOM     52  C   LEU A   7      50.443  42.749  91.019  1.00 32.97           C  
ATOM     53  O   LEU A   7      50.464  43.986  91.080  1.00 37.77           O  
ATOM     54  CB  LEU A   7      48.190  41.727  91.283  1.00 28.41           C  
ATOM     55  CG  LEU A   7      46.855  41.455  90.618  1.00 30.16           C  
ATOM     56  CD1 LEU A   7      45.908  40.913  91.672  1.00 27.38           C  
ATOM     57  CD2 LEU A   7      46.298  42.743  89.956  1.00 28.17           C  
ATOM     58  N   GLN A   8      51.392  41.988  91.562  1.00 30.82           N  
ATOM     59  CA  GLN A   8      52.512  42.622  92.252  1.00 32.86           C  
ATOM     60  C   GLN A   8      53.302  43.512  91.291  1.00 33.69           C  
ATOM     61  O   GLN A   8      53.814  44.542  91.680  1.00 30.94           O  
ATOM     62  CB  GLN A   8      53.438  41.599  92.887  1.00 33.57           C  
ATOM     63  CG  GLN A   8      54.183  42.177  94.038  1.00 49.44           C  
ATOM     64  CD  GLN A   8      55.392  41.378  94.430  1.00 61.35           C  
ATOM     65  OE1 GLN A   8      55.301  40.152  94.643  1.00 50.48           O  
ATOM     66  NE2 GLN A   8      56.554  42.074  94.543  1.00 54.31           N  
ATOM     67  N   LEU A   9      53.375  43.138  90.024  1.00 31.42           N  
ATOM     68  CA  LEU A   9      54.114  43.958  89.058  1.00 29.71           C  
ATOM     69  C   LEU A   9      53.398  45.234  88.592  1.00 32.37           C  
ATOM     70  O   LEU A   9      54.071  46.206  88.283  1.00 34.72           O  
ATOM     71  CB  LEU A   9      54.587  43.113  87.885  1.00 30.68           C  
ATOM     72  CG  LEU A   9      55.684  42.083  88.260  1.00 26.75           C  
ATOM     73  CD1 LEU A   9      56.036  41.344  87.036  1.00 24.89           C  
ATOM     74  CD2 LEU A   9      56.943  42.657  88.857  1.00 26.09           C  
ATOM     75  N   VAL A  10      52.065  45.235  88.536  1.00 29.96           N  
ATOM     76  CA  VAL A  10      51.297  46.437  88.132  1.00 29.14           C  
ATOM     77  C   VAL A  10      50.902  47.396  89.278  1.00 30.21           C  
ATOM     78  O   VAL A  10      50.914  48.643  89.104  1.00 30.03           O  
ATOM     79  CB  VAL A  10      50.049  46.039  87.290  1.00 30.17           C  
ATOM     80  CG1 VAL A  10      50.512  45.392  85.977  1.00 28.24           C  
ATOM     81  CG2 VAL A  10      49.092  45.100  88.078  1.00 30.80           C  
ATOM     82  N   LYS A  11      50.645  46.841  90.455  1.00 30.03           N  
ATOM     83  CA  LYS A  11      50.195  47.645  91.622  1.00 33.71           C  
ATOM     84  C   LYS A  11      50.964  48.915  91.947  1.00 32.58           C  
ATOM     85  O   LYS A  11      50.373  49.934  92.286  1.00 36.06           O  
ATOM     86  CB  LYS A  11      50.110  46.806  92.884  1.00 35.12           C  
ATOM     87  CG  LYS A  11      48.743  46.162  93.004  1.00 43.28           C  
ATOM     88  CD  LYS A  11      48.700  45.112  94.093  1.00 45.86           C  
ATOM     89  CE  LYS A  11      48.783  45.684  95.496  1.00 59.05           C  
ATOM     90  NZ  LYS A  11      48.627  44.565  96.510  1.00 57.62           N  
ATOM     91  N   PRO A  12      52.292  48.867  91.893  1.00 37.62           N  
ATOM     92  CA  PRO A  12      53.017  50.114  92.241  1.00 37.08           C  
ATOM     93  C   PRO A  12      52.668  51.369  91.412  1.00 36.27           C  
ATOM     94  O   PRO A  12      53.009  52.479  91.825  1.00 34.21           O  
ATOM     95  CB  PRO A  12      54.484  49.735  91.998  1.00 38.93           C  
ATOM     96  CG  PRO A  12      54.517  48.235  92.137  1.00 42.15           C  
ATOM     97  CD  PRO A  12      53.208  47.758  91.584  1.00 37.11           C  
ATOM     98  N   HIS A  13      52.027  51.198  90.252  1.00 31.22           N  
ATOM     99  CA  HIS A  13      51.681  52.313  89.388  1.00 35.34           C  
ATOM    100  C   HIS A  13      50.202  52.410  89.165  1.00 31.73           C  
ATOM    101  O   HIS A  13      49.763  52.948  88.146  1.00 33.29           O  
ATOM    102  CB  HIS A  13      52.431  52.152  88.056  1.00 37.27           C  
ATOM    103  CG  HIS A  13      53.893  51.830  88.240  1.00 50.58           C  
ATOM    104  ND1 HIS A  13      54.396  50.547  88.114  1.00 62.38           N  
ATOM    105  CD2 HIS A  13      54.947  52.613  88.583  1.00 59.84           C  
ATOM    106  CE1 HIS A  13      55.696  50.559  88.358  1.00 56.80           C  
ATOM    107  NE2 HIS A  13      56.055  51.801  88.643  1.00 58.51           N  
ATOM    108  N   LEU A  14      49.430  51.917  90.145  1.00 33.54           N  
ATOM    109  CA  LEU A  14      47.980  51.953  90.089  1.00 31.20           C  
ATOM    110  C   LEU A  14      47.455  52.755  91.271  1.00 31.80           C  
ATOM    111  O   LEU A  14      47.717  52.398  92.406  1.00 31.25           O  
ATOM    112  CB  LEU A  14      47.397  50.541  90.129  1.00 32.26           C  
ATOM    113  CG  LEU A  14      47.650  49.621  88.923  1.00 28.56           C  
ATOM    114  CD1 LEU A  14      47.092  48.213  89.211  1.00 30.46           C  
ATOM    115  CD2 LEU A  14      47.044  50.216  87.662  1.00 27.41           C  
ATOM    116  N   THR A  15      46.702  53.815  91.004  1.00 31.19           N  
ATOM    117  CA  THR A  15      45.906  54.467  92.063  1.00 30.66           C  
ATOM    118  C   THR A  15      44.788  53.482  92.433  1.00 33.03           C  
ATOM    119  O   THR A  15      44.554  52.460  91.725  1.00 32.88           O  
ATOM    120  CB  THR A  15      45.226  55.721  91.553  1.00 29.16           C  
ATOM    121  OG1 THR A  15      44.323  55.344  90.487  1.00 32.87           O  
ATOM    122  CG2 THR A  15      46.278  56.735  91.033  1.00 28.16           C  
ATOM    123  N   GLU A  16      44.038  53.800  93.481  1.00 34.87           N  
ATOM    124  CA  GLU A  16      42.917  52.934  93.865  1.00 35.79           C  
ATOM    125  C   GLU A  16      41.900  52.756  92.738  1.00 33.81           C  
ATOM    126  O   GLU A  16      41.447  51.633  92.477  1.00 29.87           O  
ATOM    127  CB  GLU A  16      42.255  53.465  95.138  1.00 36.31           C  
ATOM    128  CG  GLU A  16      41.156  52.571  95.743  1.00 45.47           C  
ATOM    129  CD  GLU A  16      41.603  51.109  96.009  1.00 62.37           C  
ATOM    130  OE1 GLU A  16      42.813  50.876  96.241  1.00 66.42           O  
ATOM    131  OE2 GLU A  16      40.738  50.199  95.980  1.00 60.26           O  
ATOM    132  N   HIS A  17      41.570  53.826  92.022  1.00 32.26           N  
ATOM    133  CA  HIS A  17      40.628  53.687  90.915  1.00 29.25           C  
ATOM    134  C   HIS A  17      41.214  52.815  89.836  1.00 30.85           C  
ATOM    135  O   HIS A  17      40.509  51.977  89.279  1.00 27.83           O  
ATOM    136  CB  HIS A  17      40.196  55.008  90.294  1.00 31.35           C  
ATOM    137  CG  HIS A  17      39.167  55.771  91.094  1.00 32.59           C  
ATOM    138  ND1 HIS A  17      37.946  56.144  90.559  1.00 31.01           N  
ATOM    139  CD2 HIS A  17      39.177  56.236  92.369  1.00 37.17           C  
ATOM    140  CE1 HIS A  17      37.257  56.816  91.473  1.00 39.88           C  
ATOM    141  NE2 HIS A  17      37.985  56.890  92.576  1.00 31.86           N  
ATOM    142  N   ARG A  18      42.484  53.000  89.512  1.00 30.39           N  
ATOM    143  CA  ARG A  18      43.085  52.157  88.473  1.00 30.09           C  
ATOM    144  C   ARG A  18      43.221  50.697  88.941  1.00 30.08           C  
ATOM    145  O   ARG A  18      43.080  49.771  88.141  1.00 29.69           O  
ATOM    146  CB  ARG A  18      44.433  52.726  88.003  1.00 31.29           C  
ATOM    147  CG  ARG A  18      44.301  54.098  87.310  1.00 28.15           C  
ATOM    148  CD  ARG A  18      43.313  54.168  86.135  1.00 31.28           C  
ATOM    149  NE  ARG A  18      43.669  53.289  85.034  1.00 32.39           N  
ATOM    150  CZ  ARG A  18      43.045  53.253  83.847  1.00 32.67           C  
ATOM    151  NH1 ARG A  18      42.040  54.078  83.542  1.00 33.43           N  
ATOM    152  NH2 ARG A  18      43.471  52.412  82.919  1.00 34.98           N  
ATOM    153  N   TYR A  19      43.437  50.496  90.234  1.00 30.42           N  
ATOM    154  CA  TYR A  19      43.512  49.143  90.757  1.00 31.33           C  
ATOM    155  C   TYR A  19      42.154  48.477  90.588  1.00 30.94           C  
ATOM    156  O   TYR A  19      42.048  47.335  90.085  1.00 31.11           O  
ATOM    157  CB  TYR A  19      43.945  49.153  92.230  1.00 32.04           C  
ATOM    158  CG  TYR A  19      43.930  47.753  92.822  1.00 34.42           C  
ATOM    159  CD1 TYR A  19      44.888  46.821  92.467  1.00 34.41           C  
ATOM    160  CD2 TYR A  19      42.908  47.341  93.678  1.00 35.99           C  
ATOM    161  CE1 TYR A  19      44.874  45.521  92.992  1.00 32.37           C  
ATOM    162  CE2 TYR A  19      42.889  46.052  94.196  1.00 38.06           C  
ATOM    163  CZ  TYR A  19      43.880  45.153  93.841  1.00 39.53           C  
ATOM    164  OH  TYR A  19      43.884  43.876  94.338  1.00 45.04           O  
ATOM    165  N   GLN A  20      41.097  49.187  90.988  1.00 28.87           N  
ATOM    166  CA  GLN A  20      39.736  48.652  90.784  1.00 28.75           C  
ATOM    167  C   GLN A  20      39.413  48.379  89.330  1.00 29.38           C  
ATOM    168  O   GLN A  20      38.723  47.398  89.020  1.00 32.25           O  
ATOM    169  CB  GLN A  20      38.679  49.565  91.421  1.00 30.61           C  
ATOM    170  CG  GLN A  20      38.794  49.631  92.939  1.00 37.66           C  
ATOM    171  CD  GLN A  20      38.679  48.224  93.618  1.00 47.40           C  
ATOM    172  OE1 GLN A  20      37.985  47.331  93.122  1.00 52.08           O  
ATOM    173  NE2 GLN A  20      39.370  48.046  94.734  1.00 48.44           N  
ATOM    174  N   HIS A  21      39.866  49.239  88.429  1.00 28.00           N  
ATOM    175  CA  HIS A  21      39.722  48.974  86.996  1.00 27.09           C  
ATOM    176  C   HIS A  21      40.365  47.630  86.604  1.00 29.18           C  
ATOM    177  O   HIS A  21      39.766  46.834  85.869  1.00 28.64           O  
ATOM    178  CB  HIS A  21      40.359  50.112  86.167  1.00 27.70           C  
ATOM    179  CG  HIS A  21      40.348  49.873  84.689  1.00 28.13           C  
ATOM    180  ND1 HIS A  21      39.180  49.698  83.970  1.00 28.94           N  
ATOM    181  CD2 HIS A  21      41.358  49.788  83.792  1.00 31.02           C  
ATOM    182  CE1 HIS A  21      39.478  49.538  82.691  1.00 29.55           C  
ATOM    183  NE2 HIS A  21      40.791  49.569  82.559  1.00 28.46           N  
ATOM    184  N   THR A  22      41.580  47.382  87.103  1.00 27.66           N  
ATOM    185  CA  THR A  22      42.353  46.188  86.745  1.00 29.22           C  
ATOM    186  C   THR A  22      41.646  44.921  87.171  1.00 28.08           C  
ATOM    187  O   THR A  22      41.474  43.982  86.372  1.00 28.86           O  
ATOM    188  CB  THR A  22      43.780  46.265  87.382  1.00 31.23           C  
ATOM    189  OG1 THR A  22      44.383  47.510  86.997  1.00 30.15           O  
ATOM    190  CG2 THR A  22      44.708  45.072  86.956  1.00 27.35           C  
ATOM    191  N   ILE A  23      41.218  44.924  88.414  1.00 29.10           N  
ATOM    192  CA  ILE A  23      40.478  43.795  88.989  1.00 33.10           C  
ATOM    193  C   ILE A  23      39.173  43.588  88.236  1.00 33.13           C  
ATOM    194  O   ILE A  23      38.802  42.418  87.924  1.00 33.21           O  
ATOM    195  CB  ILE A  23      40.203  44.032  90.507  1.00 33.09           C  
ATOM    196  CG1 ILE A  23      41.535  44.091  91.294  1.00 34.76           C  
ATOM    197  CG2 ILE A  23      39.283  42.971  91.083  1.00 36.85           C  
ATOM    198  CD1 ILE A  23      42.539  42.963  91.016  1.00 29.05           C  
ATOM    199  N   GLY A  24      38.489  44.698  87.918  1.00 30.70           N  
ATOM    200  CA  GLY A  24      37.234  44.612  87.176  1.00 29.82           C  
ATOM    201  C   GLY A  24      37.443  43.995  85.816  1.00 30.57           C  
ATOM    202  O   GLY A  24      36.696  43.068  85.402  1.00 31.19           O  
ATOM    203  N   VAL A  25      38.456  44.478  85.109  1.00 27.54           N  
ATOM    204  CA  VAL A  25      38.764  43.900  83.755  1.00 28.34           C  
ATOM    205  C   VAL A  25      39.132  42.403  83.856  1.00 28.97           C  
ATOM    206  O   VAL A  25      38.656  41.546  83.061  1.00 28.32           O  
ATOM    207  CB  VAL A  25      39.855  44.714  83.028  1.00 29.03           C  
ATOM    208  CG1 VAL A  25      40.189  44.087  81.639  1.00 25.52           C  
ATOM    209  CG2 VAL A  25      39.407  46.133  82.866  1.00 25.05           C  
HETATM  210  N   MSE A  26      39.976  42.101  84.835  1.00 28.43           N  
HETATM  211  CA  MSE A  26      40.438  40.758  85.109  1.00 29.61           C  
HETATM  212  C   MSE A  26      39.280  39.830  85.387  1.00 31.02           C  
HETATM  213  O   MSE A  26      39.185  38.765  84.753  1.00 29.90           O  
HETATM  214  CB  MSE A  26      41.381  40.751  86.286  1.00 30.30           C  
HETATM  215  CG  MSE A  26      41.969  39.359  86.645  1.00 33.29           C  
HETATM  216 SE   MSE A  26      42.812  39.460  88.376  0.75 31.78          SE  
HETATM  217  CE  MSE A  26      41.304  39.696  89.528  1.00 29.63           C  
ATOM    218  N   GLU A  27      38.376  40.209  86.283  1.00 30.48           N  
ATOM    219  CA  GLU A  27      37.230  39.315  86.598  1.00 32.67           C  
ATOM    220  C   GLU A  27      36.220  39.157  85.461  1.00 32.19           C  
ATOM    221  O   GLU A  27      35.702  38.055  85.216  1.00 29.18           O  
ATOM    222  CB  GLU A  27      36.522  39.772  87.860  1.00 34.11           C  
ATOM    223  CG  GLU A  27      37.423  39.584  89.078  1.00 41.59           C  
ATOM    224  CD  GLU A  27      36.942  40.246  90.359  1.00 43.40           C  
ATOM    225  OE1 GLU A  27      36.357  41.361  90.314  1.00 58.01           O  
ATOM    226  OE2 GLU A  27      37.231  39.656  91.437  1.00 63.13           O  
ATOM    227  N   THR A  28      35.938  40.256  84.779  1.00 28.49           N  
ATOM    228  CA  THR A  28      35.063  40.253  83.613  1.00 29.47           C  
ATOM    229  C   THR A  28      35.667  39.397  82.508  1.00 28.69           C  
ATOM    230  O   THR A  28      34.998  38.616  81.857  1.00 33.10           O  
ATOM    231  CB  THR A  28      34.803  41.718  83.120  1.00 31.73           C  
ATOM    232  OG1 THR A  28      34.363  42.539  84.230  1.00 29.70           O  
ATOM    233  CG2 THR A  28      33.731  41.749  82.017  1.00 32.54           C  
ATOM    234  N   ALA A  29      36.961  39.524  82.305  1.00 28.50           N  
ATOM    235  CA  ALA A  29      37.631  38.724  81.274  1.00 28.58           C  
ATOM    236  C   ALA A  29      37.531  37.237  81.600  1.00 29.15           C  
ATOM    237  O   ALA A  29      37.272  36.427  80.713  1.00 30.61           O  
ATOM    238  CB  ALA A  29      39.071  39.131  81.145  1.00 30.43           C  
ATOM    239  N   ILE A  30      37.736  36.874  82.867  1.00 30.42           N  
ATOM    240  CA  ILE A  30      37.654  35.461  83.271  1.00 29.73           C  
ATOM    241  C   ILE A  30      36.255  34.920  82.996  1.00 30.89           C  
ATOM    242  O   ILE A  30      36.096  33.836  82.443  1.00 34.48           O  
ATOM    243  CB  ILE A  30      38.104  35.239  84.736  1.00 30.80           C  
ATOM    244  CG1 ILE A  30      39.614  35.536  84.879  1.00 32.08           C  
ATOM    245  CG2 ILE A  30      37.815  33.808  85.197  1.00 30.36           C  
ATOM    246  CD1 ILE A  30      40.102  35.839  86.358  1.00 28.02           C  
ATOM    247  N   ASP A  31      35.252  35.695  83.362  1.00 34.39           N  
ATOM    248  CA  ASP A  31      33.845  35.305  83.183  1.00 34.51           C  
ATOM    249  C   ASP A  31      33.466  35.145  81.712  1.00 35.15           C  
ATOM    250  O   ASP A  31      32.768  34.187  81.349  1.00 36.80           O  
ATOM    251  CB  ASP A  31      32.933  36.355  83.805  1.00 36.23           C  
ATOM    252  CG  ASP A  31      33.010  36.394  85.334  1.00 45.73           C  
ATOM    253  OD1 ASP A  31      33.564  35.462  85.967  1.00 54.46           O  
ATOM    254  OD2 ASP A  31      32.489  37.379  85.906  1.00 54.07           O  
ATOM    255  N   LEU A  32      33.924  36.077  80.874  1.00 30.42           N  
ATOM    256  CA  LEU A  32      33.747  35.983  79.445  1.00 30.63           C  
ATOM    257  C   LEU A  32      34.516  34.802  78.875  1.00 33.66           C  
ATOM    258  O   LEU A  32      34.021  34.142  77.959  1.00 36.00           O  
ATOM    259  CB  LEU A  32      34.153  37.283  78.744  1.00 31.38           C  
ATOM    260  CG  LEU A  32      33.271  38.526  78.961  1.00 35.47           C  
ATOM    261  CD1 LEU A  32      33.939  39.797  78.439  1.00 25.88           C  
ATOM    262  CD2 LEU A  32      31.836  38.336  78.282  1.00 33.35           C  
ATOM    263  N   ALA A  33      35.716  34.521  79.389  1.00 32.20           N  
ATOM    264  CA  ALA A  33      36.475  33.328  78.937  1.00 33.52           C  
ATOM    265  C   ALA A  33      35.702  32.056  79.256  1.00 33.23           C  
ATOM    266  O   ALA A  33      35.623  31.174  78.421  1.00 37.20           O  
ATOM    267  CB  ALA A  33      37.844  33.241  79.578  1.00 30.39           C  
ATOM    268  N   LYS A  34      35.167  31.984  80.481  1.00 33.78           N  
ATOM    269  CA  LYS A  34      34.398  30.841  80.947  0.50 34.54           C  
ATOM    271  C   LYS A  34      33.209  30.705  80.010  1.00 36.19           C  
ATOM    272  O   LYS A  34      32.925  29.634  79.488  1.00 39.36           O  
ATOM    273  CB  LYS A  34      33.883  31.050  82.390  0.50 32.58           C  
ATOM    275  CG  LYS A  34      34.915  30.851  83.488  0.50 35.90           C  
ATOM    277  CD  LYS A  34      34.466  31.328  84.910  0.50 33.86           C  
ATOM    279  CE  LYS A  34      35.562  31.058  85.943  0.50 28.46           C  
ATOM    281  NZ  LYS A  34      35.349  31.692  87.279  0.50 40.23           N  
ATOM    283  N   LEU A  35      32.527  31.818  79.807  1.00 37.24           N  
ATOM    284  CA  LEU A  35      31.321  31.832  79.006  1.00 40.61           C  
ATOM    285  C   LEU A  35      31.531  31.402  77.563  1.00 41.34           C  
ATOM    286  O   LEU A  35      30.739  30.602  77.047  1.00 43.84           O  
ATOM    287  CB  LEU A  35      30.695  33.213  79.059  1.00 39.22           C  
ATOM    288  CG  LEU A  35      29.328  33.482  78.481  1.00 43.60           C  
ATOM    289  CD1 LEU A  35      28.324  32.360  78.785  1.00 46.89           C  
ATOM    290  CD2 LEU A  35      28.874  34.816  79.069  1.00 41.39           C  
ATOM    291  N   TYR A  36      32.607  31.880  76.941  1.00 41.36           N  
ATOM    292  CA  TYR A  36      32.847  31.653  75.505  1.00 40.16           C  
ATOM    293  C   TYR A  36      33.908  30.612  75.159  1.00 41.82           C  
ATOM    294  O   TYR A  36      34.286  30.482  73.997  1.00 44.39           O  
ATOM    295  CB  TYR A  36      33.109  32.996  74.823  1.00 41.43           C  
ATOM    296  CG  TYR A  36      31.861  33.851  74.826  1.00 42.75           C  
ATOM    297  CD1 TYR A  36      30.774  33.517  74.018  1.00 49.04           C  
ATOM    298  CD2 TYR A  36      31.738  34.955  75.651  1.00 44.21           C  
ATOM    299  CE1 TYR A  36      29.609  34.276  74.028  1.00 42.10           C  
ATOM    300  CE2 TYR A  36      30.579  35.715  75.664  1.00 40.32           C  
ATOM    301  CZ  TYR A  36      29.522  35.370  74.853  1.00 46.16           C  
ATOM    302  OH  TYR A  36      28.371  36.119  74.847  1.00 46.72           O  
ATOM    303  N   GLY A  37      34.370  29.866  76.151  1.00 41.71           N  
ATOM    304  CA  GLY A  37      35.356  28.820  75.934  1.00 43.15           C  
ATOM    305  C   GLY A  37      36.758  29.264  75.562  1.00 43.30           C  
ATOM    306  O   GLY A  37      37.455  28.563  74.836  1.00 45.03           O  
ATOM    307  N   ALA A  38      37.181  30.418  76.065  1.00 41.15           N  
ATOM    308  CA  ALA A  38      38.547  30.872  75.879  1.00 39.21           C  
ATOM    309  C   ALA A  38      39.360  30.416  77.084  1.00 37.78           C  
ATOM    310  O   ALA A  38      38.804  29.961  78.106  1.00 37.66           O  
ATOM    311  CB  ALA A  38      38.600  32.350  75.752  1.00 36.85           C  
ATOM    312  N   ASP A  39      40.672  30.558  76.957  1.00 37.30           N  
ATOM    313  CA  ASP A  39      41.621  30.239  78.014  1.00 37.15           C  
ATOM    314  C   ASP A  39      41.528  31.289  79.125  1.00 36.70           C  
ATOM    315  O   ASP A  39      41.895  32.441  78.942  1.00 35.42           O  
ATOM    316  CB  ASP A  39      43.021  30.177  77.431  1.00 38.28           C  
ATOM    317  CG  ASP A  39      44.041  29.628  78.400  1.00 38.84           C  
ATOM    318  OD1 ASP A  39      44.076  30.033  79.573  1.00 33.72           O  
ATOM    319  OD2 ASP A  39      44.872  28.813  77.952  1.00 44.59           O  
ATOM    320  N   GLN A  40      41.030  30.877  80.282  1.00 35.31           N  
ATOM    321  CA  GLN A  40      40.791  31.809  81.373  1.00 35.43           C  
ATOM    322  C   GLN A  40      42.062  32.320  82.033  1.00 36.62           C  
ATOM    323  O   GLN A  40      42.021  33.384  82.629  1.00 32.26           O  
ATOM    324  CB  GLN A  40      39.931  31.170  82.449  1.00 36.93           C  
ATOM    325  CG  GLN A  40      38.557  30.802  82.038  1.00 35.09           C  
ATOM    326  CD  GLN A  40      37.935  29.890  83.044  1.00 39.01           C  
ATOM    327  OE1 GLN A  40      37.923  30.181  84.218  1.00 40.33           O  
ATOM    328  NE2 GLN A  40      37.391  28.793  82.586  1.00 40.56           N  
ATOM    329  N   GLN A  41      43.162  31.552  81.951  1.00 35.79           N  
ATOM    330  CA  GLN A  41      44.444  31.977  82.523  1.00 37.42           C  
ATOM    331  C   GLN A  41      45.055  33.038  81.632  1.00 34.52           C  
ATOM    332  O   GLN A  41      45.586  34.004  82.117  1.00 31.98           O  
ATOM    333  CB  GLN A  41      45.415  30.789  82.674  1.00 38.42           C  
ATOM    334  CG  GLN A  41      44.913  29.743  83.706  1.00 46.87           C  
ATOM    335  CD  GLN A  41      45.855  28.550  83.884  1.00 48.78           C  
ATOM    336  OE1 GLN A  41      47.064  28.637  83.610  1.00 57.92           O  
ATOM    337  NE2 GLN A  41      45.305  27.436  84.373  1.00 56.77           N  
ATOM    338  N   LYS A  42      45.010  32.836  80.321  1.00 31.82           N  
ATOM    339  CA  LYS A  42      45.498  33.874  79.390  1.00 32.53           C  
ATOM    340  C   LYS A  42      44.610  35.111  79.474  1.00 30.47           C  
ATOM    341  O   LYS A  42      45.128  36.225  79.438  1.00 34.91           O  
ATOM    342  CB  LYS A  42      45.588  33.365  77.956  1.00 34.30           C  
ATOM    343  CG  LYS A  42      46.537  32.178  77.746  1.00 35.78           C  
ATOM    344  CD  LYS A  42      46.620  31.877  76.290  1.00 35.78           C  
ATOM    345  CE  LYS A  42      47.591  30.756  75.966  1.00 43.75           C  
ATOM    346  NZ  LYS A  42      48.199  31.087  74.604  1.00 50.67           N  
ATOM    347  N   ALA A  43      43.284  34.925  79.581  1.00 31.80           N  
ATOM    348  CA  ALA A  43      42.350  36.048  79.803  1.00 30.11           C  
ATOM    349  C   ALA A  43      42.772  36.846  81.048  1.00 27.78           C  
ATOM    350  O   ALA A  43      42.935  38.075  81.023  1.00 30.09           O  
ATOM    351  CB  ALA A  43      40.864  35.570  79.912  1.00 28.39           C  
ATOM    352  N   GLU A  44      42.983  36.137  82.149  1.00 31.56           N  
ATOM    353  CA  GLU A  44      43.395  36.779  83.425  1.00 30.07           C  
ATOM    354  C   GLU A  44      44.670  37.591  83.315  1.00 30.00           C  
ATOM    355  O   GLU A  44      44.755  38.744  83.790  1.00 30.04           O  
ATOM    356  CB  GLU A  44      43.613  35.688  84.479  1.00 31.21           C  
ATOM    357  CG  GLU A  44      43.868  36.195  85.881  1.00 28.42           C  
ATOM    358  CD  GLU A  44      44.050  35.056  86.883  1.00 33.52           C  
ATOM    359  OE1 GLU A  44      44.927  34.216  86.691  1.00 44.40           O  
ATOM    360  OE2 GLU A  44      43.333  35.030  87.883  1.00 36.74           O  
ATOM    361  N   LEU A  45      45.676  36.965  82.708  1.00 28.72           N  
ATOM    362  CA  LEU A  45      46.999  37.578  82.562  1.00 29.46           C  
ATOM    363  C   LEU A  45      46.971  38.808  81.641  1.00 29.50           C  
ATOM    364  O   LEU A  45      47.511  39.874  81.989  1.00 27.88           O  
ATOM    365  CB  LEU A  45      48.015  36.542  82.025  1.00 30.49           C  
ATOM    366  CG  LEU A  45      49.471  36.991  81.970  1.00 30.20           C  
ATOM    367  CD1 LEU A  45      49.989  37.360  83.369  1.00 31.11           C  
ATOM    368  CD2 LEU A  45      50.345  35.893  81.325  1.00 29.91           C  
ATOM    369  N   ALA A  46      46.335  38.661  80.482  1.00 28.11           N  
ATOM    370  CA  ALA A  46      46.163  39.780  79.532  1.00 27.19           C  
ATOM    371  C   ALA A  46      45.411  40.939  80.157  1.00 28.69           C  
ATOM    372  O   ALA A  46      45.786  42.095  79.993  1.00 29.07           O  
ATOM    373  CB  ALA A  46      45.447  39.292  78.230  1.00 25.42           C  
ATOM    374  N   ALA A  47      44.369  40.615  80.915  1.00 29.92           N  
ATOM    375  CA  ALA A  47      43.598  41.630  81.673  1.00 29.80           C  
ATOM    376  C   ALA A  47      44.422  42.381  82.701  1.00 29.56           C  
ATOM    377  O   ALA A  47      44.400  43.611  82.725  1.00 29.27           O  
ATOM    378  CB  ALA A  47      42.398  41.035  82.311  1.00 29.97           C  
ATOM    379  N   ILE A  48      45.203  41.669  83.500  1.00 27.51           N  
ATOM    380  CA  ILE A  48      46.031  42.323  84.520  1.00 28.95           C  
ATOM    381  C   ILE A  48      47.006  43.298  83.865  1.00 29.98           C  
ATOM    382  O   ILE A  48      47.238  44.402  84.371  1.00 29.62           O  
ATOM    383  CB  ILE A  48      46.774  41.310  85.436  1.00 27.42           C  
ATOM    384  CG1 ILE A  48      45.752  40.529  86.297  1.00 29.74           C  
ATOM    385  CG2 ILE A  48      47.897  42.052  86.350  1.00 25.50           C  
ATOM    386  CD1 ILE A  48      46.271  39.218  86.968  1.00 27.71           C  
ATOM    387  N   PHE A  49      47.583  42.896  82.735  1.00 30.57           N  
ATOM    388  CA  PHE A  49      48.571  43.737  82.056  1.00 28.82           C  
ATOM    389  C   PHE A  49      48.084  44.619  80.938  1.00 29.76           C  
ATOM    390  O   PHE A  49      48.924  45.331  80.370  1.00 27.72           O  
ATOM    391  CB  PHE A  49      49.709  42.878  81.498  1.00 30.31           C  
ATOM    392  CG  PHE A  49      50.652  42.403  82.537  1.00 27.80           C  
ATOM    393  CD1 PHE A  49      51.597  43.260  83.061  1.00 28.50           C  
ATOM    394  CD2 PHE A  49      50.588  41.088  83.003  1.00 31.27           C  
ATOM    395  CE1 PHE A  49      52.462  42.825  84.065  1.00 33.17           C  
ATOM    396  CE2 PHE A  49      51.479  40.629  83.987  1.00 34.75           C  
ATOM    397  CZ  PHE A  49      52.396  41.499  84.514  1.00 32.33           C  
ATOM    398  N   HIS A  50      46.786  44.606  80.605  1.00 27.96           N  
ATOM    399  CA  HIS A  50      46.338  45.326  79.400  1.00 28.29           C  
ATOM    400  C   HIS A  50      46.735  46.829  79.362  1.00 27.35           C  
ATOM    401  O   HIS A  50      47.071  47.364  78.297  1.00 27.56           O  
ATOM    402  CB  HIS A  50      44.834  45.143  79.126  1.00 27.92           C  
ATOM    403  CG  HIS A  50      43.953  46.031  79.936  1.00 25.12           C  
ATOM    404  ND1 HIS A  50      43.707  45.811  81.274  1.00 30.13           N  
ATOM    405  CD2 HIS A  50      43.244  47.135  79.593  1.00 25.39           C  
ATOM    406  CE1 HIS A  50      42.906  46.768  81.730  1.00 29.44           C  
ATOM    407  NE2 HIS A  50      42.589  47.570  80.724  1.00 30.71           N  
ATOM    408  N   ASP A  51      46.728  47.465  80.520  1.00 25.63           N  
ATOM    409  CA  ASP A  51      47.050  48.897  80.650  1.00 28.79           C  
ATOM    410  C   ASP A  51      48.401  49.178  81.260  1.00 27.00           C  
ATOM    411  O   ASP A  51      48.645  50.292  81.753  1.00 26.97           O  
ATOM    412  CB  ASP A  51      45.969  49.636  81.446  1.00 28.72           C  
ATOM    413  CG  ASP A  51      44.744  50.001  80.602  1.00 32.95           C  
ATOM    414  OD1 ASP A  51      44.841  50.140  79.401  1.00 32.26           O  
ATOM    415  OD2 ASP A  51      43.669  50.151  81.164  1.00 31.75           O  
ATOM    416  N   TYR A  52      49.298  48.202  81.152  1.00 25.13           N  
ATOM    417  CA  TYR A  52      50.656  48.345  81.651  1.00 27.80           C  
ATOM    418  C   TYR A  52      51.349  49.668  81.281  1.00 29.15           C  
ATOM    419  O   TYR A  52      52.064  50.237  82.108  1.00 26.96           O  
ATOM    420  CB  TYR A  52      51.487  47.190  81.125  1.00 29.31           C  
ATOM    421  CG  TYR A  52      52.913  47.170  81.573  1.00 29.80           C  
ATOM    422  CD1 TYR A  52      53.257  46.752  82.871  1.00 32.21           C  
ATOM    423  CD2 TYR A  52      53.930  47.526  80.690  1.00 30.22           C  
ATOM    424  CE1 TYR A  52      54.611  46.675  83.262  1.00 34.51           C  
ATOM    425  CE2 TYR A  52      55.257  47.442  81.065  1.00 35.56           C  
ATOM    426  CZ  TYR A  52      55.598  46.998  82.339  1.00 33.98           C  
ATOM    427  OH  TYR A  52      56.946  46.979  82.653  1.00 34.56           O  
ATOM    428  N   ALA A  53      51.190  50.112  80.033  1.00 29.55           N  
ATOM    429  CA  ALA A  53      51.873  51.325  79.551  1.00 28.16           C  
ATOM    430  C   ALA A  53      51.018  52.614  79.624  1.00 29.46           C  
ATOM    431  O   ALA A  53      51.426  53.656  79.147  1.00 31.55           O  
ATOM    432  CB  ALA A  53      52.364  51.092  78.103  1.00 30.38           C  
ATOM    433  N   LYS A  54      49.843  52.561  80.251  1.00 28.73           N  
ATOM    434  CA  LYS A  54      48.930  53.712  80.268  1.00 28.43           C  
ATOM    435  C   LYS A  54      49.641  54.993  80.723  1.00 28.42           C  
ATOM    436  O   LYS A  54      49.466  56.039  80.135  1.00 30.17           O  
ATOM    437  CB  LYS A  54      47.740  53.386  81.178  1.00 30.11           C  
ATOM    438  CG  LYS A  54      46.710  54.449  81.369  1.00 37.54           C  
ATOM    439  CD  LYS A  54      45.701  54.521  80.289  1.00 38.88           C  
ATOM    440  CE  LYS A  54      44.696  55.607  80.663  1.00 41.47           C  
ATOM    441  NZ  LYS A  54      43.690  55.591  79.597  1.00 40.45           N  
ATOM    442  N   PHE A  55      50.452  54.895  81.746  1.00 30.47           N  
ATOM    443  CA  PHE A  55      51.045  56.087  82.355  1.00 30.27           C  
ATOM    444  C   PHE A  55      52.491  56.209  82.055  1.00 33.45           C  
ATOM    445  O   PHE A  55      53.197  56.885  82.773  1.00 33.67           O  
ATOM    446  CB  PHE A  55      50.765  56.082  83.859  1.00 34.22           C  
ATOM    447  CG  PHE A  55      49.308  55.933  84.148  1.00 27.35           C  
ATOM    448  CD1 PHE A  55      48.409  56.900  83.702  1.00 28.32           C  
ATOM    449  CD2 PHE A  55      48.829  54.820  84.785  1.00 37.24           C  
ATOM    450  CE1 PHE A  55      47.056  56.748  83.900  1.00 30.63           C  
ATOM    451  CE2 PHE A  55      47.494  54.658  84.972  1.00 30.82           C  
ATOM    452  CZ  PHE A  55      46.602  55.620  84.524  1.00 34.26           C  
ATOM    453  N   ARG A  56      52.938  55.542  81.000  1.00 34.16           N  
ATOM    454  CA  ARG A  56      54.313  55.688  80.558  1.00 33.21           C  
ATOM    455  C   ARG A  56      54.483  56.980  79.809  1.00 33.50           C  
ATOM    456  O   ARG A  56      53.536  57.559  79.364  1.00 34.08           O  
ATOM    457  CB  ARG A  56      54.727  54.513  79.685  1.00 28.55           C  
ATOM    458  CG  ARG A  56      54.845  53.236  80.447  1.00 36.16           C  
ATOM    459  CD  ARG A  56      56.087  53.206  81.326  1.00 37.23           C  
ATOM    460  NE  ARG A  56      57.267  52.874  80.527  1.00 37.57           N  
ATOM    461  CZ  ARG A  56      57.769  51.655  80.359  1.00 33.09           C  
ATOM    462  NH1 ARG A  56      57.254  50.586  80.944  1.00 32.80           N  
ATOM    463  NH2 ARG A  56      58.822  51.521  79.602  1.00 32.04           N  
ATOM    464  N   ASP A  57      55.722  57.420  79.684  1.00 35.60           N  
ATOM    465  CA  ASP A  57      56.038  58.676  79.024  1.00 39.60           C  
ATOM    466  C   ASP A  57      55.558  58.648  77.577  1.00 38.74           C  
ATOM    467  O   ASP A  57      56.006  57.809  76.780  1.00 36.65           O  
ATOM    468  CB  ASP A  57      57.556  58.899  79.049  1.00 42.13           C  
ATOM    469  CG  ASP A  57      57.960  60.248  78.458  1.00 51.29           C  
ATOM    470  OD1 ASP A  57      57.848  61.260  79.177  1.00 62.30           O  
ATOM    471  OD2 ASP A  57      58.309  60.293  77.264  1.00 54.19           O  
ATOM    472  N   LYS A  58      54.681  59.589  77.230  1.00 38.51           N  
ATOM    473  CA  LYS A  58      54.125  59.648  75.881  1.00 39.11           C  
ATOM    474  C   LYS A  58      55.156  59.916  74.767  1.00 38.60           C  
ATOM    475  O   LYS A  58      55.024  59.375  73.680  1.00 40.61           O  
ATOM    476  CB  LYS A  58      52.916  60.593  75.832  1.00 37.77           C  
ATOM    477  CG  LYS A  58      51.636  59.933  76.448  1.00 38.40           C  
ATOM    478  CD  LYS A  58      50.408  60.813  76.330  1.00 41.28           C  
ATOM    479  CE  LYS A  58      49.193  60.236  77.082  1.00 40.23           C  
ATOM    480  NZ  LYS A  58      49.391  60.209  78.592  1.00 41.89           N  
ATOM    481  N   ASN A  59      56.194  60.688  75.036  1.00 39.79           N  
ATOM    482  CA  ASN A  59      57.239  60.907  74.010  1.00 40.41           C  
ATOM    483  C   ASN A  59      58.057  59.655  73.708  1.00 39.86           C  
ATOM    484  O   ASN A  59      58.339  59.342  72.553  1.00 39.77           O  
ATOM    485  CB  ASN A  59      58.180  62.066  74.398  1.00 45.60           C  
ATOM    486  CG  ASN A  59      57.629  63.430  73.995  1.00 53.16           C  
ATOM    487  OD1 ASN A  59      57.053  63.593  72.905  1.00 59.79           O  
ATOM    488  ND2 ASN A  59      57.818  64.421  74.869  1.00 62.04           N  
ATOM    489  N   GLU A  60      58.447  58.938  74.752  1.00 42.28           N  
ATOM    490  CA  GLU A  60      59.107  57.628  74.589  1.00 42.67           C  
ATOM    491  C   GLU A  60      58.224  56.679  73.787  1.00 37.92           C  
ATOM    492  O   GLU A  60      58.716  55.936  72.947  1.00 37.66           O  
ATOM    493  CB  GLU A  60      59.383  56.998  75.950  1.00 42.78           C  
ATOM    494  CG  GLU A  60      60.454  57.745  76.741  1.00 50.92           C  
ATOM    495  CD  GLU A  60      60.663  57.204  78.164  1.00 51.57           C  
ATOM    496  OE1 GLU A  60      60.031  56.185  78.562  1.00 61.88           O  
ATOM    497  OE2 GLU A  60      61.484  57.821  78.883  1.00 62.54           O  
HETATM  498  N   MSE A  61      56.916  56.714  74.048  1.00 35.08           N  
HETATM  499  CA  MSE A  61      55.994  55.836  73.342  1.00 34.03           C  
HETATM  500  C   MSE A  61      55.890  56.198  71.857  1.00 33.51           C  
HETATM  501  O   MSE A  61      55.948  55.333  71.002  1.00 36.32           O  
HETATM  502  CB  MSE A  61      54.630  55.822  74.026  1.00 34.53           C  
HETATM  503  CG  MSE A  61      54.650  55.009  75.357  1.00 31.49           C  
HETATM  504 SE   MSE A  61      52.984  54.393  75.982  0.75 31.04          SE  
HETATM  505  CE  MSE A  61      52.217  55.986  76.579  1.00 34.49           C  
ATOM    506  N   ARG A  62      55.773  57.479  71.559  1.00 34.54           N  
ATOM    507  CA  ARG A  62      55.770  57.941  70.167  1.00 36.05           C  
ATOM    508  C   ARG A  62      57.032  57.537  69.439  1.00 36.70           C  
ATOM    509  O   ARG A  62      56.978  57.141  68.275  1.00 38.09           O  
ATOM    510  CB  ARG A  62      55.572  59.452  70.117  1.00 36.92           C  
ATOM    511  CG  ARG A  62      54.167  59.871  70.597  1.00 41.45           C  
ATOM    512  CD  ARG A  62      53.933  61.347  70.397  1.00 41.95           C  
ATOM    513  NE  ARG A  62      52.860  61.901  71.234  1.00 47.00           N  
ATOM    514  CZ  ARG A  62      53.045  62.577  72.376  1.00 51.31           C  
ATOM    515  NH1 ARG A  62      54.251  62.791  72.878  1.00 56.43           N  
ATOM    516  NH2 ARG A  62      52.006  63.053  73.040  1.00 56.12           N  
ATOM    517  N   THR A  63      58.165  57.636  70.136  1.00 37.64           N  
ATOM    518  CA  THR A  63      59.460  57.232  69.586  1.00 37.71           C  
ATOM    519  C   THR A  63      59.520  55.737  69.347  1.00 39.09           C  
ATOM    520  O   THR A  63      60.025  55.310  68.315  1.00 41.05           O  
ATOM    521  CB  THR A  63      60.586  57.643  70.522  1.00 39.41           C  
ATOM    522  OG1 THR A  63      60.561  59.074  70.683  1.00 42.00           O  
ATOM    523  CG2 THR A  63      61.945  57.176  69.993  1.00 39.51           C  
ATOM    524  N   LEU A  64      58.983  54.944  70.277  1.00 34.23           N  
ATOM    525  CA  LEU A  64      58.922  53.494  70.127  1.00 35.21           C  
ATOM    526  C   LEU A  64      58.088  53.119  68.903  1.00 37.59           C  
ATOM    527  O   LEU A  64      58.450  52.221  68.134  1.00 37.64           O  
ATOM    528  CB  LEU A  64      58.280  52.830  71.371  1.00 36.12           C  
ATOM    529  CG  LEU A  64      58.222  51.300  71.393  1.00 36.22           C  
ATOM    530  CD1 LEU A  64      59.635  50.741  71.496  1.00 33.61           C  
ATOM    531  CD2 LEU A  64      57.355  50.779  72.536  1.00 34.62           C  
ATOM    532  N   ILE A  65      56.946  53.773  68.744  1.00 39.40           N  
ATOM    533  CA  ILE A  65      56.100  53.540  67.564  1.00 42.63           C  
ATOM    534  C   ILE A  65      56.927  53.820  66.303  1.00 45.53           C  
ATOM    535  O   ILE A  65      57.029  52.959  65.433  1.00 47.73           O  
ATOM    536  CB  ILE A  65      54.799  54.366  67.642  1.00 42.26           C  
ATOM    537  CG1 ILE A  65      53.824  53.663  68.594  1.00 41.93           C  
ATOM    538  CG2 ILE A  65      54.175  54.538  66.265  1.00 43.53           C  
ATOM    539  CD1 ILE A  65      52.872  54.564  69.243  1.00 44.09           C  
ATOM    540  N   ARG A  66      57.566  54.985  66.254  1.00 49.51           N  
ATOM    541  CA  ARG A  66      58.450  55.352  65.135  1.00 52.80           C  
ATOM    542  C   ARG A  66      59.627  54.404  64.883  1.00 54.34           C  
ATOM    543  O   ARG A  66      59.813  53.917  63.760  1.00 55.57           O  
ATOM    544  CB  ARG A  66      59.003  56.772  65.317  1.00 53.45           C  
ATOM    545  CG  ARG A  66      57.996  57.857  64.989  1.00 59.21           C  
ATOM    546  CD  ARG A  66      58.625  59.238  64.857  1.00 58.54           C  
ATOM    547  NE  ARG A  66      58.733  59.918  66.152  1.00 67.10           N  
ATOM    548  CZ  ARG A  66      57.743  60.575  66.766  1.00 65.72           C  
ATOM    549  NH1 ARG A  66      56.513  60.640  66.248  1.00 71.67           N  
ATOM    550  NH2 ARG A  66      57.982  61.165  67.933  1.00 64.92           N  
ATOM    551  N   GLU A  67      60.419  54.149  65.915  1.00 55.39           N  
ATOM    552  CA  GLU A  67      61.651  53.375  65.762  1.00 57.19           C  
ATOM    553  C   GLU A  67      61.433  51.875  65.670  1.00 57.04           C  
ATOM    554  O   GLU A  67      61.935  51.242  64.753  1.00 57.59           O  
ATOM    555  CB  GLU A  67      62.619  53.662  66.911  1.00 57.68           C  
ATOM    556  CG  GLU A  67      63.175  55.079  66.898  1.00 59.24           C  
ATOM    557  CD  GLU A  67      64.099  55.395  68.089  1.00 60.90           C  
ATOM    558  OE1 GLU A  67      64.150  54.630  69.096  1.00 60.69           O  
ATOM    559  OE2 GLU A  67      64.777  56.448  68.008  1.00 69.79           O  
ATOM    560  N   LYS A  68      60.686  51.308  66.613  1.00 56.86           N  
ATOM    561  CA  LYS A  68      60.587  49.850  66.727  1.00 56.02           C  
ATOM    562  C   LYS A  68      59.337  49.191  66.173  1.00 54.99           C  
ATOM    563  O   LYS A  68      59.412  48.022  65.848  1.00 55.81           O  
ATOM    564  CB  LYS A  68      60.815  49.388  68.190  1.00 54.81           C  
ATOM    565  CG  LYS A  68      62.288  49.363  68.612  1.00 53.40           C  
ATOM    566  N   LEU A  69      58.207  49.891  66.059  1.00 56.44           N  
ATOM    567  CA  LEU A  69      56.930  49.216  65.714  1.00 57.43           C  
ATOM    568  C   LEU A  69      56.460  49.409  64.257  1.00 59.40           C  
ATOM    569  O   LEU A  69      56.965  50.273  63.529  1.00 58.41           O  
ATOM    570  CB  LEU A  69      55.823  49.585  66.728  1.00 53.32           C  
ATOM    571  CG  LEU A  69      56.069  49.225  68.217  1.00 52.86           C  
ATOM    572  CD1 LEU A  69      54.870  49.593  69.070  1.00 40.03           C  
ATOM    573  CD2 LEU A  69      56.408  47.740  68.442  1.00 42.61           C  
ATOM    574  N   SER A  70      55.497  48.567  63.861  1.00 63.29           N  
ATOM    575  CA  SER A  70      54.930  48.527  62.487  1.00 66.05           C  
ATOM    576  C   SER A  70      54.001  49.718  62.120  1.00 68.78           C  
ATOM    577  O   SER A  70      54.342  50.516  61.236  1.00 69.77           O  
ATOM    578  CB  SER A  70      54.174  47.200  62.259  1.00 65.56           C  
ATOM    579  N   GLN A  71      52.853  49.830  62.804  1.00 70.37           N  
ATOM    580  CA  GLN A  71      51.819  50.855  62.496  1.00 69.62           C  
ATOM    581  C   GLN A  71      52.166  52.321  62.909  1.00 70.13           C  
ATOM    582  O   GLN A  71      51.923  52.734  64.043  1.00 72.62           O  
ATOM    583  CB  GLN A  71      50.470  50.427  63.116  1.00 69.47           C  
ATOM    584  N   GLN A  72      52.689  53.108  61.971  1.00 68.08           N  
ATOM    585  CA  GLN A  72      53.062  54.517  62.234  1.00 67.06           C  
ATOM    586  C   GLN A  72      51.858  55.463  62.198  1.00 62.88           C  
ATOM    587  O   GLN A  72      51.877  56.539  62.815  1.00 60.26           O  
ATOM    588  CB  GLN A  72      54.086  55.031  61.190  1.00 68.52           C  
ATOM    589  CG  GLN A  72      55.254  54.087  60.885  1.00 71.61           C  
ATOM    590  CD  GLN A  72      55.936  53.628  62.139  1.00 73.96           C  
ATOM    591  OE1 GLN A  72      56.392  54.454  62.919  1.00 76.13           O  
ATOM    592  NE2 GLN A  72      55.982  52.313  62.362  1.00 70.00           N  
ATOM    593  N   ASP A  73      50.825  55.069  61.452  1.00 60.25           N  
ATOM    594  CA  ASP A  73      49.651  55.922  61.250  1.00 58.15           C  
ATOM    595  C   ASP A  73      48.904  56.192  62.558  1.00 53.44           C  
ATOM    596  O   ASP A  73      48.213  57.188  62.665  1.00 52.66           O  
ATOM    597  CB  ASP A  73      48.712  55.386  60.121  1.00 59.21           C  
ATOM    598  CG  ASP A  73      47.745  54.274  60.583  1.00 62.99           C  
ATOM    599  OD1 ASP A  73      48.132  53.401  61.406  1.00 72.52           O  
ATOM    600  OD2 ASP A  73      46.590  54.276  60.083  1.00 62.82           O  
ATOM    601  N   ILE A  74      49.100  55.326  63.554  1.00 49.34           N  
ATOM    602  CA  ILE A  74      48.459  55.462  64.853  1.00 47.03           C  
ATOM    603  C   ILE A  74      48.769  56.817  65.475  1.00 42.50           C  
ATOM    604  O   ILE A  74      47.949  57.356  66.186  1.00 40.74           O  
ATOM    605  CB  ILE A  74      48.878  54.296  65.806  1.00 48.00           C  
ATOM    606  CG1 ILE A  74      47.668  53.580  66.388  1.00 51.09           C  
ATOM    607  CG2 ILE A  74      49.808  54.752  66.918  1.00 50.89           C  
ATOM    608  CD1 ILE A  74      48.026  52.212  66.950  1.00 51.05           C  
ATOM    609  N   LEU A  75      49.950  57.369  65.194  1.00 39.48           N  
ATOM    610  CA  LEU A  75      50.373  58.665  65.744  1.00 41.50           C  
ATOM    611  C   LEU A  75      49.550  59.869  65.304  1.00 43.36           C  
ATOM    612  O   LEU A  75      49.716  60.952  65.852  1.00 45.97           O  
ATOM    613  CB  LEU A  75      51.854  58.936  65.397  1.00 41.27           C  
ATOM    614  CG  LEU A  75      52.918  57.963  65.912  1.00 43.22           C  
ATOM    615  CD1 LEU A  75      54.285  58.331  65.346  1.00 39.93           C  
ATOM    616  CD2 LEU A  75      52.971  57.972  67.441  1.00 42.14           C  
ATOM    617  N   PHE A  76      48.692  59.701  64.306  1.00 45.04           N  
ATOM    618  CA  PHE A  76      47.801  60.769  63.827  1.00 46.92           C  
ATOM    619  C   PHE A  76      46.432  60.804  64.504  1.00 45.35           C  
ATOM    620  O   PHE A  76      45.716  61.790  64.365  1.00 43.68           O  
ATOM    621  CB  PHE A  76      47.643  60.652  62.291  1.00 50.90           C  
ATOM    622  CG  PHE A  76      48.894  61.070  61.527  1.00 52.91           C  
ATOM    623  CD1 PHE A  76      49.993  60.205  61.435  1.00 59.72           C  
ATOM    624  CD2 PHE A  76      48.992  62.348  60.960  1.00 57.69           C  
ATOM    625  CE1 PHE A  76      51.169  60.600  60.770  1.00 62.75           C  
ATOM    626  CE2 PHE A  76      50.152  62.752  60.287  1.00 60.15           C  
ATOM    627  CZ  PHE A  76      51.244  61.874  60.190  1.00 58.23           C  
ATOM    628  N   TYR A  77      46.096  59.776  65.285  1.00 43.09           N  
ATOM    629  CA  TYR A  77      44.736  59.612  65.809  1.00 43.31           C  
ATOM    630  C   TYR A  77      44.535  59.657  67.336  1.00 44.25           C  
ATOM    631  O   TYR A  77      43.562  59.105  67.843  1.00 47.66           O  
ATOM    632  CB  TYR A  77      44.171  58.313  65.251  1.00 42.70           C  
ATOM    633  CG  TYR A  77      44.120  58.295  63.754  1.00 39.16           C  
ATOM    634  CD1 TYR A  77      43.038  58.828  63.073  1.00 39.34           C  
ATOM    635  CD2 TYR A  77      45.160  57.755  63.008  1.00 43.82           C  
ATOM    636  CE1 TYR A  77      42.984  58.824  61.684  1.00 39.92           C  
ATOM    637  CE2 TYR A  77      45.121  57.739  61.611  1.00 44.04           C  
ATOM    638  CZ  TYR A  77      44.023  58.275  60.955  1.00 44.78           C  
ATOM    639  OH  TYR A  77      43.959  58.268  59.583  1.00 44.28           O  
ATOM    640  N   GLY A  78      45.426  60.305  68.068  1.00 42.25           N  
ATOM    641  CA  GLY A  78      45.194  60.552  69.501  1.00 43.13           C  
ATOM    642  C   GLY A  78      46.080  59.771  70.451  1.00 39.11           C  
ATOM    643  O   GLY A  78      46.321  58.592  70.253  1.00 38.80           O  
ATOM    644  N   ASP A  79      46.533  60.446  71.499  1.00 37.27           N  
ATOM    645  CA  ASP A  79      47.445  59.865  72.478  1.00 38.56           C  
ATOM    646  C   ASP A  79      46.947  58.597  73.171  1.00 36.89           C  
ATOM    647  O   ASP A  79      47.767  57.800  73.654  1.00 35.89           O  
ATOM    648  CB  ASP A  79      47.808  60.909  73.537  1.00 42.83           C  
ATOM    649  CG  ASP A  79      48.820  61.930  73.046  1.00 46.31           C  
ATOM    650  OD1 ASP A  79      49.461  61.760  71.967  1.00 55.77           O  
ATOM    651  OD2 ASP A  79      49.016  62.914  73.792  1.00 63.86           O  
ATOM    652  N   GLU A  80      45.628  58.389  73.175  1.00 34.03           N  
ATOM    653  CA  GLU A  80      45.027  57.216  73.808  1.00 33.72           C  
ATOM    654  C   GLU A  80      45.375  55.910  73.099  1.00 32.80           C  
ATOM    655  O   GLU A  80      45.286  54.851  73.708  1.00 34.85           O  
ATOM    656  CB  GLU A  80      43.492  57.374  73.937  1.00 37.54           C  
ATOM    657  N   LEU A  81      45.801  55.981  71.833  1.00 32.22           N  
ATOM    658  CA  LEU A  81      46.110  54.782  71.042  1.00 30.30           C  
ATOM    659  C   LEU A  81      47.532  54.267  71.236  1.00 31.20           C  
ATOM    660  O   LEU A  81      47.883  53.214  70.696  1.00 30.20           O  
ATOM    661  CB  LEU A  81      45.879  55.050  69.563  1.00 29.03           C  
ATOM    662  CG  LEU A  81      44.516  55.590  69.112  1.00 30.05           C  
ATOM    663  CD1 LEU A  81      44.413  55.506  67.586  1.00 36.67           C  
ATOM    664  CD2 LEU A  81      43.353  54.883  69.764  1.00 39.12           C  
ATOM    665  N   LEU A  82      48.335  54.993  72.017  1.00 32.18           N  
ATOM    666  CA  LEU A  82      49.725  54.643  72.241  1.00 31.41           C  
ATOM    667  C   LEU A  82      49.914  53.452  73.180  1.00 30.50           C  
ATOM    668  O   LEU A  82      50.721  52.593  72.918  1.00 29.26           O  
ATOM    669  CB  LEU A  82      50.481  55.840  72.845  1.00 30.36           C  
ATOM    670  CG  LEU A  82      50.632  57.125  72.011  1.00 32.73           C  
ATOM    671  CD1 LEU A  82      51.190  58.308  72.864  1.00 33.49           C  
ATOM    672  CD2 LEU A  82      51.532  56.881  70.817  1.00 32.47           C  
ATOM    673  N   HIS A  83      49.176  53.426  74.279  1.00 29.45           N  
ATOM    674  CA  HIS A  83      49.508  52.518  75.360  1.00 30.11           C  
ATOM    675  C   HIS A  83      49.262  51.048  75.078  1.00 29.15           C  
ATOM    676  O   HIS A  83      49.948  50.216  75.655  1.00 29.32           O  
ATOM    677  CB  HIS A  83      48.833  52.949  76.680  1.00 30.64           C  
ATOM    678  CG  HIS A  83      47.359  52.713  76.725  1.00 29.75           C  
ATOM    679  ND1 HIS A  83      46.439  53.604  76.215  1.00 29.04           N  
ATOM    680  CD2 HIS A  83      46.642  51.727  77.306  1.00 38.54           C  
ATOM    681  CE1 HIS A  83      45.223  53.140  76.424  1.00 36.88           C  
ATOM    682  NE2 HIS A  83      45.318  52.007  77.095  1.00 37.37           N  
ATOM    683  N   ALA A  84      48.310  50.721  74.201  1.00 28.00           N  
ATOM    684  CA  ALA A  84      48.053  49.306  73.871  1.00 28.20           C  
ATOM    685  C   ALA A  84      49.230  48.638  73.127  1.00 30.94           C  
ATOM    686  O   ALA A  84      49.752  47.627  73.603  1.00 29.71           O  
ATOM    687  CB  ALA A  84      46.692  49.133  73.071  1.00 27.51           C  
ATOM    688  N   PRO A  85      49.618  49.162  71.941  1.00 29.48           N  
ATOM    689  CA  PRO A  85      50.739  48.564  71.230  1.00 30.53           C  
ATOM    690  C   PRO A  85      52.075  48.683  71.971  1.00 31.19           C  
ATOM    691  O   PRO A  85      52.883  47.772  71.903  1.00 32.18           O  
ATOM    692  CB  PRO A  85      50.760  49.324  69.906  1.00 31.53           C  
ATOM    693  CG  PRO A  85      50.051  50.613  70.163  1.00 31.49           C  
ATOM    694  CD  PRO A  85      49.010  50.264  71.166  1.00 33.58           C  
ATOM    695  N   CYS A  86      52.295  49.789  72.668  1.00 29.41           N  
ATOM    696  CA  CYS A  86      53.535  49.993  73.410  1.00 31.45           C  
ATOM    697  C   CYS A  86      53.554  49.107  74.637  1.00 31.80           C  
ATOM    698  O   CYS A  86      54.588  48.511  74.964  1.00 31.81           O  
ATOM    699  CB  CYS A  86      53.739  51.476  73.792  1.00 30.67           C  
ATOM    700  SG  CYS A  86      53.972  52.571  72.331  1.00 32.14           S  
ATOM    701  N   GLY A  87      52.412  49.013  75.303  1.00 30.36           N  
ATOM    702  CA  GLY A  87      52.225  48.074  76.418  1.00 29.12           C  
ATOM    703  C   GLY A  87      52.506  46.638  76.001  1.00 30.69           C  
ATOM    704  O   GLY A  87      53.179  45.909  76.717  1.00 33.17           O  
ATOM    705  N   ALA A  88      52.008  46.215  74.839  1.00 27.56           N  
ATOM    706  CA  ALA A  88      52.313  44.860  74.365  1.00 27.65           C  
ATOM    707  C   ALA A  88      53.834  44.716  74.209  1.00 28.60           C  
ATOM    708  O   ALA A  88      54.423  43.690  74.606  1.00 29.11           O  
ATOM    709  CB  ALA A  88      51.562  44.555  73.058  1.00 25.98           C  
ATOM    710  N   TYR A  89      54.483  45.755  73.685  1.00 31.73           N  
ATOM    711  CA  TYR A  89      55.926  45.742  73.502  1.00 31.59           C  
ATOM    712  C   TYR A  89      56.652  45.667  74.863  1.00 31.85           C  
ATOM    713  O   TYR A  89      57.524  44.817  75.082  1.00 31.67           O  
ATOM    714  CB  TYR A  89      56.405  46.964  72.708  1.00 32.79           C  
ATOM    715  CG  TYR A  89      57.921  46.981  72.485  1.00 30.82           C  
ATOM    716  CD1 TYR A  89      58.484  46.340  71.395  1.00 42.83           C  
ATOM    717  CD2 TYR A  89      58.774  47.613  73.389  1.00 32.98           C  
ATOM    718  CE1 TYR A  89      59.868  46.334  71.194  1.00 37.77           C  
ATOM    719  CE2 TYR A  89      60.129  47.599  73.214  1.00 36.79           C  
ATOM    720  CZ  TYR A  89      60.676  46.961  72.103  1.00 40.04           C  
ATOM    721  OH  TYR A  89      62.035  46.962  71.908  1.00 43.90           O  
ATOM    722  N   TYR A  90      56.264  46.541  75.779  1.00 34.08           N  
ATOM    723  CA  TYR A  90      56.942  46.609  77.075  1.00 32.32           C  
ATOM    724  C   TYR A  90      56.763  45.369  77.928  1.00 34.31           C  
ATOM    725  O   TYR A  90      57.708  44.927  78.552  1.00 35.50           O  
ATOM    726  CB  TYR A  90      56.528  47.854  77.840  1.00 32.75           C  
ATOM    727  CG  TYR A  90      56.918  49.180  77.208  1.00 32.73           C  
ATOM    728  CD1 TYR A  90      58.159  49.356  76.575  1.00 32.39           C  
ATOM    729  CD2 TYR A  90      56.101  50.308  77.353  1.00 31.68           C  
ATOM    730  CE1 TYR A  90      58.523  50.570  76.051  1.00 29.23           C  
ATOM    731  CE2 TYR A  90      56.472  51.548  76.850  1.00 30.83           C  
ATOM    732  CZ  TYR A  90      57.682  51.672  76.190  1.00 33.64           C  
ATOM    733  OH  TYR A  90      58.075  52.885  75.673  1.00 37.88           O  
ATOM    734  N   VAL A  91      55.553  44.822  77.961  1.00 32.52           N  
ATOM    735  CA  VAL A  91      55.274  43.575  78.674  1.00 34.49           C  
ATOM    736  C   VAL A  91      56.197  42.431  78.172  1.00 35.01           C  
ATOM    737  O   VAL A  91      56.734  41.677  78.978  1.00 33.36           O  
ATOM    738  CB  VAL A  91      53.784  43.215  78.588  1.00 31.38           C  
ATOM    739  CG1 VAL A  91      53.471  41.835  79.197  1.00 37.12           C  
ATOM    740  CG2 VAL A  91      52.958  44.289  79.321  1.00 30.26           C  
ATOM    741  N   ARG A  92      56.402  42.316  76.861  1.00 34.32           N  
ATOM    742  CA  ARG A  92      57.302  41.275  76.336  0.50 33.86           C  
ATOM    744  C   ARG A  92      58.742  41.559  76.735  1.00 33.64           C  
ATOM    745  O   ARG A  92      59.406  40.683  77.248  1.00 35.76           O  
ATOM    746  CB  ARG A  92      57.210  41.097  74.817  0.50 34.06           C  
ATOM    748  CG  ARG A  92      58.056  39.919  74.305  0.50 32.21           C  
ATOM    750  CD  ARG A  92      58.050  39.771  72.794  0.50 34.79           C  
ATOM    752  NE  ARG A  92      59.361  39.331  72.304  0.50 43.41           N  
ATOM    754  CZ  ARG A  92      59.818  38.076  72.263  0.50 44.40           C  
ATOM    756  NH1 ARG A  92      59.088  37.045  72.683  0.50 47.44           N  
ATOM    758  NH2 ARG A  92      61.039  37.852  71.795  0.50 44.89           N  
ATOM    760  N   GLU A  93      59.194  42.785  76.517  1.00 33.91           N  
ATOM    761  CA  GLU A  93      60.578  43.163  76.772  1.00 35.52           C  
ATOM    762  C   GLU A  93      60.954  43.287  78.218  1.00 33.18           C  
ATOM    763  O   GLU A  93      62.073  42.942  78.573  1.00 33.91           O  
ATOM    764  CB  GLU A  93      60.943  44.477  76.062  1.00 38.12           C  
ATOM    765  CG  GLU A  93      60.839  44.387  74.556  1.00 46.68           C  
ATOM    766  CD  GLU A  93      61.716  43.287  73.933  1.00 53.04           C  
ATOM    767  OE1 GLU A  93      62.914  43.224  74.297  1.00 52.28           O  
ATOM    768  OE2 GLU A  93      61.207  42.517  73.081  1.00 48.67           O  
ATOM    769  N   GLU A  94      60.042  43.757  79.053  1.00 31.28           N  
ATOM    770  CA  GLU A  94      60.355  44.050  80.436  1.00 30.39           C  
ATOM    771  C   GLU A  94      59.918  42.971  81.364  1.00 32.57           C  
ATOM    772  O   GLU A  94      60.660  42.620  82.284  1.00 32.69           O  
ATOM    773  CB  GLU A  94      59.730  45.373  80.868  1.00 31.49           C  
ATOM    774  CG  GLU A  94      60.225  46.525  80.054  1.00 35.05           C  
ATOM    775  CD  GLU A  94      59.523  47.830  80.284  1.00 33.68           C  
ATOM    776  OE1 GLU A  94      58.577  47.970  81.115  1.00 29.11           O  
ATOM    777  OE2 GLU A  94      59.930  48.737  79.566  1.00 37.17           O  
ATOM    778  N   VAL A  95      58.701  42.482  81.167  1.00 30.44           N  
ATOM    779  CA  VAL A  95      58.150  41.429  82.015  1.00 32.26           C  
ATOM    780  C   VAL A  95      58.520  40.028  81.498  1.00 32.03           C  
ATOM    781  O   VAL A  95      58.571  39.100  82.272  1.00 31.58           O  
ATOM    782  CB  VAL A  95      56.628  41.605  82.238  1.00 32.78           C  
ATOM    783  CG1 VAL A  95      56.102  40.585  83.221  1.00 34.53           C  
ATOM    784  CG2 VAL A  95      56.330  43.023  82.687  1.00 29.56           C  
ATOM    785  N   GLY A  96      58.854  39.907  80.218  1.00 31.32           N  
ATOM    786  CA  GLY A  96      59.258  38.628  79.665  1.00 33.08           C  
ATOM    787  C   GLY A  96      58.127  37.721  79.222  1.00 32.56           C  
ATOM    788  O   GLY A  96      58.342  36.543  78.958  1.00 35.03           O  
ATOM    789  N   ILE A  97      56.929  38.264  79.077  1.00 35.67           N  
ATOM    790  CA  ILE A  97      55.788  37.486  78.607  1.00 32.37           C  
ATOM    791  C   ILE A  97      55.894  37.380  77.106  1.00 32.75           C  
ATOM    792  O   ILE A  97      55.870  38.369  76.432  1.00 32.44           O  
ATOM    793  CB  ILE A  97      54.479  38.126  79.046  1.00 33.83           C  
ATOM    794  CG1 ILE A  97      54.345  37.995  80.567  1.00 36.03           C  
ATOM    795  CG2 ILE A  97      53.237  37.424  78.397  1.00 31.60           C  
ATOM    796  CD1 ILE A  97      53.285  38.897  81.144  1.00 44.80           C  
ATOM    797  N   GLU A  98      56.026  36.164  76.580  1.00 33.97           N  
ATOM    798  CA  GLU A  98      56.142  35.937  75.143  1.00 38.57           C  
ATOM    799  C   GLU A  98      54.915  35.229  74.545  1.00 38.99           C  
ATOM    800  O   GLU A  98      54.953  34.822  73.388  1.00 42.81           O  
ATOM    801  CB  GLU A  98      57.409  35.114  74.851  1.00 37.90           C  
ATOM    802  CG  GLU A  98      58.679  35.636  75.494  1.00 41.86           C  
ATOM    803  CD  GLU A  98      59.925  34.836  75.109  1.00 47.97           C  
ATOM    804  OE1 GLU A  98      59.851  33.975  74.204  1.00 59.88           O  
ATOM    805  OE2 GLU A  98      60.994  35.077  75.716  1.00 64.10           O  
ATOM    806  N   ASP A  99      53.842  35.057  75.319  1.00 37.58           N  
ATOM    807  CA  ASP A  99      52.641  34.412  74.820  1.00 35.68           C  
ATOM    808  C   ASP A  99      51.998  35.377  73.834  1.00 36.75           C  
ATOM    809  O   ASP A  99      51.458  36.391  74.239  1.00 36.07           O  
ATOM    810  CB  ASP A  99      51.715  34.124  75.996  1.00 36.40           C  
ATOM    811  CG  ASP A  99      50.412  33.402  75.599  1.00 40.12           C  
ATOM    812  OD1 ASP A  99      49.837  33.638  74.509  1.00 41.29           O  
ATOM    813  OD2 ASP A  99      49.941  32.601  76.439  1.00 43.53           O  
ATOM    814  N   GLU A 100      52.052  35.046  72.544  1.00 38.03           N  
ATOM    815  CA  GLU A 100      51.521  35.916  71.482  1.00 39.52           C  
ATOM    816  C   GLU A 100      50.027  36.191  71.573  1.00 35.84           C  
ATOM    817  O   GLU A 100      49.566  37.269  71.233  1.00 33.58           O  
ATOM    818  CB  GLU A 100      51.852  35.354  70.104  1.00 42.62           C  
ATOM    819  CG  GLU A 100      53.337  35.481  69.753  1.00 56.12           C  
ATOM    820  CD  GLU A 100      53.839  36.941  69.682  1.00 64.34           C  
ATOM    821  OE1 GLU A 100      53.024  37.897  69.523  1.00 74.00           O  
ATOM    822  OE2 GLU A 100      55.074  37.114  69.768  1.00 72.37           O  
ATOM    823  N   ASP A 101      49.280  35.226  72.065  1.00 38.25           N  
ATOM    824  CA  ASP A 101      47.850  35.417  72.261  1.00 39.73           C  
ATOM    825  C   ASP A 101      47.605  36.515  73.307  1.00 38.27           C  
ATOM    826  O   ASP A 101      46.786  37.410  73.083  1.00 38.66           O  
ATOM    827  CB  ASP A 101      47.186  34.106  72.696  1.00 41.82           C  
ATOM    828  CG  ASP A 101      47.461  32.924  71.715  1.00 57.30           C  
ATOM    829  OD1 ASP A 101      47.555  33.148  70.465  1.00 66.66           O  
ATOM    830  OD2 ASP A 101      47.590  31.769  72.212  1.00 67.00           O  
ATOM    831  N   VAL A 102      48.316  36.441  74.439  1.00 36.02           N  
ATOM    832  CA  VAL A 102      48.186  37.442  75.505  1.00 33.94           C  
ATOM    833  C   VAL A 102      48.622  38.805  74.960  1.00 32.14           C  
ATOM    834  O   VAL A 102      47.945  39.792  75.157  1.00 30.94           O  
ATOM    835  CB  VAL A 102      49.012  37.057  76.793  1.00 32.35           C  
ATOM    836  CG1 VAL A 102      49.323  38.279  77.662  1.00 27.56           C  
ATOM    837  CG2 VAL A 102      48.274  35.986  77.633  1.00 34.61           C  
ATOM    838  N   LEU A 103      49.763  38.848  74.290  1.00 29.41           N  
ATOM    839  CA  LEU A 103      50.317  40.108  73.815  1.00 30.24           C  
ATOM    840  C   LEU A 103      49.409  40.778  72.777  1.00 31.75           C  
ATOM    841  O   LEU A 103      49.239  41.982  72.811  1.00 31.09           O  
ATOM    842  CB  LEU A 103      51.743  39.889  73.240  1.00 30.02           C  
ATOM    843  CG  LEU A 103      52.853  39.421  74.169  1.00 32.67           C  
ATOM    844  CD1 LEU A 103      54.193  39.235  73.398  1.00 28.73           C  
ATOM    845  CD2 LEU A 103      53.044  40.433  75.243  1.00 27.04           C  
ATOM    846  N   GLN A 104      48.835  39.997  71.844  1.00 33.92           N  
ATOM    847  CA  GLN A 104      47.869  40.545  70.843  1.00 33.17           C  
ATOM    848  C   GLN A 104      46.647  41.109  71.531  1.00 29.64           C  
ATOM    849  O   GLN A 104      46.138  42.155  71.153  1.00 30.09           O  
ATOM    850  CB  GLN A 104      47.394  39.459  69.881  1.00 36.62           C  
ATOM    851  CG  GLN A 104      48.407  39.083  68.858  1.00 46.10           C  
ATOM    852  CD  GLN A 104      48.340  39.970  67.628  1.00 60.35           C  
ATOM    853  OE1 GLN A 104      49.257  40.763  67.357  1.00 57.86           O  
ATOM    854  NE2 GLN A 104      47.236  39.851  66.877  1.00 68.39           N  
ATOM    855  N   ALA A 105      46.160  40.406  72.536  1.00 30.60           N  
ATOM    856  CA  ALA A 105      44.986  40.896  73.293  1.00 27.44           C  
ATOM    857  C   ALA A 105      45.294  42.245  73.916  1.00 31.80           C  
ATOM    858  O   ALA A 105      44.428  43.093  74.019  1.00 33.46           O  
ATOM    859  CB  ALA A 105      44.580  39.909  74.343  1.00 28.91           C  
ATOM    860  N   ILE A 106      46.527  42.426  74.397  1.00 31.45           N  
ATOM    861  CA  ILE A 106      46.913  43.693  74.968  1.00 29.91           C  
ATOM    862  C   ILE A 106      46.988  44.746  73.851  1.00 32.12           C  
ATOM    863  O   ILE A 106      46.457  45.834  73.988  1.00 31.05           O  
ATOM    864  CB  ILE A 106      48.273  43.600  75.711  1.00 30.40           C  
ATOM    865  CG1 ILE A 106      48.146  42.705  76.940  1.00 33.63           C  
ATOM    866  CG2 ILE A 106      48.733  45.006  76.127  1.00 25.06           C  
ATOM    867  CD1 ILE A 106      49.482  42.356  77.625  1.00 29.08           C  
ATOM    868  N   ARG A 107      47.651  44.383  72.753  1.00 31.89           N  
ATOM    869  CA  ARG A 107      47.914  45.263  71.619  1.00 31.56           C  
ATOM    870  C   ARG A 107      46.671  45.893  71.018  1.00 31.62           C  
ATOM    871  O   ARG A 107      46.694  47.073  70.673  1.00 32.93           O  
ATOM    872  CB  ARG A 107      48.656  44.481  70.542  1.00 31.79           C  
ATOM    873  CG  ARG A 107      49.102  45.252  69.272  1.00 31.02           C  
ATOM    874  CD  ARG A 107      49.977  44.324  68.391  1.00 38.61           C  
ATOM    875  NE  ARG A 107      51.266  43.930  69.025  1.00 50.19           N  
ATOM    876  CZ  ARG A 107      51.615  42.715  69.509  1.00 52.89           C  
ATOM    877  NH1 ARG A 107      50.814  41.650  69.448  1.00 52.18           N  
ATOM    878  NH2 ARG A 107      52.831  42.555  70.039  1.00 55.56           N  
ATOM    879  N   PHE A 108      45.590  45.109  70.915  1.00 32.97           N  
ATOM    880  CA  PHE A 108      44.390  45.576  70.208  1.00 29.47           C  
ATOM    881  C   PHE A 108      43.222  45.969  71.075  1.00 31.58           C  
ATOM    882  O   PHE A 108      42.092  46.138  70.578  1.00 29.83           O  
ATOM    883  CB  PHE A 108      43.997  44.526  69.156  1.00 28.73           C  
ATOM    884  CG  PHE A 108      44.994  44.441  68.064  1.00 26.07           C  
ATOM    885  CD1 PHE A 108      45.138  45.517  67.198  1.00 28.75           C  
ATOM    886  CD2 PHE A 108      45.845  43.349  67.944  1.00 28.75           C  
ATOM    887  CE1 PHE A 108      46.105  45.489  66.190  1.00 28.43           C  
ATOM    888  CE2 PHE A 108      46.812  43.326  66.965  1.00 31.86           C  
ATOM    889  CZ  PHE A 108      46.946  44.389  66.088  1.00 33.36           C  
ATOM    890  N   HIS A 109      43.466  46.145  72.373  1.00 30.25           N  
ATOM    891  CA  HIS A 109      42.339  46.313  73.297  1.00 29.55           C  
ATOM    892  C   HIS A 109      41.694  47.667  73.209  1.00 30.86           C  
ATOM    893  O   HIS A 109      40.565  47.823  73.706  1.00 31.66           O  
ATOM    894  CB  HIS A 109      42.735  46.044  74.771  1.00 30.42           C  
ATOM    895  CG  HIS A 109      43.418  47.194  75.457  1.00 31.85           C  
ATOM    896  ND1 HIS A 109      44.795  47.325  75.520  1.00 31.60           N  
ATOM    897  CD2 HIS A 109      42.910  48.249  76.129  1.00 28.39           C  
ATOM    898  CE1 HIS A 109      45.086  48.420  76.207  1.00 32.33           C  
ATOM    899  NE2 HIS A 109      43.958  48.997  76.582  1.00 25.90           N  
ATOM    900  N   THR A 110      42.449  48.660  72.732  1.00 33.29           N  
ATOM    901  CA  THR A 110      41.921  50.027  72.601  1.00 32.91           C  
ATOM    902  C   THR A 110      41.213  50.251  71.243  1.00 32.67           C  
ATOM    903  O   THR A 110      40.126  50.784  71.214  1.00 30.02           O  
ATOM    904  CB  THR A 110      43.018  51.089  72.695  1.00 33.30           C  
ATOM    905  OG1 THR A 110      43.723  50.934  73.916  1.00 32.46           O  
ATOM    906  CG2 THR A 110      42.414  52.497  72.625  1.00 27.50           C  
ATOM    907  N   THR A 111      41.873  49.901  70.137  1.00 29.62           N  
ATOM    908  CA  THR A 111      41.337  50.195  68.822  1.00 29.85           C  
ATOM    909  C   THR A 111      40.488  49.064  68.231  1.00 30.16           C  
ATOM    910  O   THR A 111      39.589  49.326  67.430  1.00 30.53           O  
ATOM    911  CB  THR A 111      42.438  50.472  67.845  1.00 29.78           C  
ATOM    912  OG1 THR A 111      43.237  49.289  67.671  1.00 34.23           O  
ATOM    913  CG2 THR A 111      43.302  51.715  68.286  1.00 30.07           C  
ATOM    914  N   GLY A 112      40.759  47.830  68.644  1.00 30.91           N  
ATOM    915  CA  GLY A 112      40.182  46.655  67.997  1.00 30.78           C  
ATOM    916  C   GLY A 112      40.935  46.457  66.690  1.00 30.36           C  
ATOM    917  O   GLY A 112      41.828  47.242  66.344  1.00 34.23           O  
ATOM    918  N   ARG A 113      40.624  45.362  66.013  1.00 33.24           N  
ATOM    919  CA  ARG A 113      41.000  45.148  64.637  1.00 34.73           C  
ATOM    920  C   ARG A 113      39.934  44.238  64.002  1.00 36.35           C  
ATOM    921  O   ARG A 113      39.238  43.519  64.719  1.00 34.73           O  
ATOM    922  CB  ARG A 113      42.371  44.508  64.523  1.00 32.99           C  
ATOM    923  CG  ARG A 113      42.503  43.118  65.094  1.00 33.82           C  
ATOM    924  CD  ARG A 113      43.900  42.661  64.835  1.00 39.04           C  
ATOM    925  NE  ARG A 113      44.198  41.330  65.338  1.00 39.76           N  
ATOM    926  CZ  ARG A 113      44.087  40.201  64.642  1.00 45.34           C  
ATOM    927  NH1 ARG A 113      43.671  40.181  63.379  1.00 48.93           N  
ATOM    928  NH2 ARG A 113      44.401  39.058  65.222  1.00 46.49           N  
ATOM    929  N   PRO A 114      39.788  44.288  62.673  1.00 37.61           N  
ATOM    930  CA  PRO A 114      38.954  43.256  62.059  1.00 38.79           C  
ATOM    931  C   PRO A 114      39.579  41.864  62.279  1.00 39.66           C  
ATOM    932  O   PRO A 114      40.811  41.706  62.270  1.00 38.96           O  
ATOM    933  CB  PRO A 114      38.985  43.598  60.567  1.00 40.02           C  
ATOM    934  CG  PRO A 114      39.506  44.969  60.477  1.00 36.79           C  
ATOM    935  CD  PRO A 114      40.338  45.222  61.681  1.00 39.06           C  
ATOM    936  N   ASN A 115      38.714  40.895  62.512  1.00 38.78           N  
ATOM    937  CA  ASN A 115      39.095  39.505  62.668  1.00 40.31           C  
ATOM    938  C   ASN A 115      39.964  39.297  63.922  1.00 41.11           C  
ATOM    939  O   ASN A 115      41.037  38.683  63.878  1.00 43.12           O  
ATOM    940  CB  ASN A 115      39.742  38.963  61.376  1.00 40.11           C  
ATOM    941  CG  ASN A 115      38.902  39.266  60.126  1.00 42.20           C  
ATOM    942  OD1 ASN A 115      39.380  39.895  59.180  1.00 48.16           O  
ATOM    943  ND2 ASN A 115      37.642  38.871  60.151  1.00 43.08           N  
HETATM  944  N   MSE A 116      39.489  39.833  65.042  1.00 39.04           N  
HETATM  945  CA  MSE A 116      40.111  39.566  66.333  1.00 37.10           C  
HETATM  946  C   MSE A 116      39.937  38.099  66.716  1.00 37.93           C  
HETATM  947  O   MSE A 116      38.891  37.515  66.456  1.00 40.05           O  
HETATM  948  CB  MSE A 116      39.461  40.403  67.428  1.00 36.59           C  
HETATM  949  CG  MSE A 116      40.020  41.828  67.451  1.00 40.74           C  
HETATM  950 SE   MSE A 116      39.357  42.904  68.897  0.75 34.85          SE  
HETATM  951  CE  MSE A 116      37.563  43.267  68.325  1.00 31.43           C  
ATOM    952  N   SER A 117      40.971  37.518  67.317  1.00 35.52           N  
ATOM    953  CA  SER A 117      40.865  36.239  68.037  1.00 34.05           C  
ATOM    954  C   SER A 117      39.845  36.388  69.165  1.00 35.03           C  
ATOM    955  O   SER A 117      39.530  37.509  69.592  1.00 34.46           O  
ATOM    956  CB  SER A 117      42.205  35.858  68.674  1.00 35.34           C  
ATOM    957  OG  SER A 117      42.482  36.671  69.817  1.00 35.85           O  
ATOM    958  N   LEU A 118      39.339  35.268  69.676  1.00 33.71           N  
ATOM    959  CA  LEU A 118      38.405  35.312  70.819  1.00 33.51           C  
ATOM    960  C   LEU A 118      38.993  36.019  72.055  1.00 32.44           C  
ATOM    961  O   LEU A 118      38.315  36.795  72.732  1.00 35.24           O  
ATOM    962  CB  LEU A 118      37.941  33.892  71.162  1.00 34.64           C  
ATOM    963  CG  LEU A 118      36.880  33.668  72.241  1.00 34.59           C  
ATOM    964  CD1 LEU A 118      35.586  34.331  71.872  1.00 42.18           C  
ATOM    965  CD2 LEU A 118      36.691  32.152  72.506  1.00 35.16           C  
ATOM    966  N   LEU A 119      40.263  35.769  72.343  1.00 34.58           N  
ATOM    967  CA  LEU A 119      40.917  36.382  73.489  1.00 33.95           C  
ATOM    968  C   LEU A 119      41.050  37.916  73.279  1.00 31.96           C  
ATOM    969  O   LEU A 119      40.859  38.670  74.209  1.00 28.94           O  
ATOM    970  CB  LEU A 119      42.293  35.749  73.745  1.00 33.69           C  
ATOM    971  CG  LEU A 119      42.828  36.122  75.138  1.00 34.45           C  
ATOM    972  CD1 LEU A 119      42.116  35.247  76.171  1.00 39.36           C  
ATOM    973  CD2 LEU A 119      44.349  35.983  75.205  1.00 40.10           C  
ATOM    974  N   GLU A 120      41.423  38.365  72.079  1.00 33.48           N  
ATOM    975  CA  GLU A 120      41.410  39.818  71.787  1.00 32.68           C  
ATOM    976  C   GLU A 120      40.006  40.450  72.039  1.00 32.19           C  
ATOM    977  O   GLU A 120      39.886  41.498  72.673  1.00 29.77           O  
ATOM    978  CB  GLU A 120      41.836  40.106  70.353  1.00 32.24           C  
ATOM    979  CG  GLU A 120      43.240  39.791  70.046  1.00 27.83           C  
ATOM    980  CD  GLU A 120      43.499  39.862  68.561  1.00 37.54           C  
ATOM    981  OE1 GLU A 120      43.685  40.981  68.036  1.00 44.62           O  
ATOM    982  OE2 GLU A 120      43.437  38.800  67.926  1.00 39.18           O  
ATOM    983  N   LYS A 121      38.949  39.769  71.574  1.00 33.54           N  
ATOM    984  CA  LYS A 121      37.579  40.236  71.775  1.00 33.41           C  
ATOM    985  C   LYS A 121      37.219  40.334  73.259  1.00 34.25           C  
ATOM    986  O   LYS A 121      36.560  41.313  73.722  1.00 35.55           O  
ATOM    987  CB  LYS A 121      36.594  39.296  71.048  1.00 32.52           C  
ATOM    988  CG  LYS A 121      36.608  39.397  69.530  1.00 35.58           C  
ATOM    989  CD  LYS A 121      35.581  38.452  68.854  1.00 38.12           C  
ATOM    990  CE  LYS A 121      35.538  38.635  67.324  1.00 37.87           C  
ATOM    991  NZ  LYS A 121      34.665  37.593  66.688  1.00 40.17           N  
ATOM    992  N   ILE A 122      37.598  39.310  74.008  1.00 31.72           N  
ATOM    993  CA  ILE A 122      37.297  39.264  75.451  1.00 32.96           C  
ATOM    994  C   ILE A 122      37.963  40.434  76.199  1.00 31.08           C  
ATOM    995  O   ILE A 122      37.319  41.103  77.002  1.00 31.07           O  
ATOM    996  CB  ILE A 122      37.669  37.865  76.053  1.00 31.59           C  
ATOM    997  CG1 ILE A 122      36.634  36.846  75.567  1.00 36.88           C  
ATOM    998  CG2 ILE A 122      37.771  37.885  77.595  1.00 31.83           C  
ATOM    999  CD1 ILE A 122      37.060  35.419  75.742  1.00 38.53           C  
ATOM   1000  N   ILE A 123      39.230  40.712  75.892  1.00 31.24           N  
ATOM   1001  CA  ILE A 123      39.949  41.817  76.556  1.00 31.09           C  
ATOM   1002  C   ILE A 123      39.411  43.181  76.116  1.00 27.88           C  
ATOM   1003  O   ILE A 123      39.180  44.065  76.951  1.00 29.36           O  
ATOM   1004  CB  ILE A 123      41.496  41.717  76.402  1.00 30.52           C  
ATOM   1005  CG1 ILE A 123      42.003  40.411  77.029  1.00 32.08           C  
ATOM   1006  CG2 ILE A 123      42.219  42.941  77.062  1.00 31.45           C  
ATOM   1007  CD1 ILE A 123      41.654  40.206  78.543  1.00 30.31           C  
ATOM   1008  N   PHE A 124      39.190  43.347  74.816  1.00 31.59           N  
ATOM   1009  CA  PHE A 124      38.575  44.554  74.297  1.00 31.92           C  
ATOM   1010  C   PHE A 124      37.274  44.848  75.030  1.00 31.14           C  
ATOM   1011  O   PHE A 124      37.021  45.944  75.541  1.00 31.11           O  
ATOM   1012  CB  PHE A 124      38.273  44.391  72.779  1.00 29.41           C  
ATOM   1013  CG  PHE A 124      37.647  45.616  72.165  1.00 29.65           C  
ATOM   1014  CD1 PHE A 124      36.263  45.844  72.264  1.00 34.92           C  
ATOM   1015  CD2 PHE A 124      38.439  46.575  71.541  1.00 29.83           C  
ATOM   1016  CE1 PHE A 124      35.709  47.026  71.755  1.00 37.84           C  
ATOM   1017  CE2 PHE A 124      37.885  47.726  71.019  1.00 25.86           C  
ATOM   1018  CZ  PHE A 124      36.527  47.951  71.120  1.00 34.72           C  
ATOM   1019  N   LEU A 125      36.401  43.856  75.041  1.00 30.73           N  
ATOM   1020  CA  LEU A 125      35.089  44.042  75.652  1.00 30.78           C  
ATOM   1021  C   LEU A 125      35.129  44.176  77.165  1.00 30.06           C  
ATOM   1022  O   LEU A 125      34.392  44.968  77.723  1.00 30.07           O  
ATOM   1023  CB  LEU A 125      34.159  42.869  75.284  1.00 31.89           C  
ATOM   1024  CG  LEU A 125      32.705  43.006  75.706  1.00 30.75           C  
ATOM   1025  CD1 LEU A 125      32.097  44.286  75.119  1.00 26.87           C  
ATOM   1026  CD2 LEU A 125      31.950  41.718  75.274  1.00 26.62           C  
ATOM   1027  N   ALA A 126      35.972  43.377  77.816  1.00 33.12           N  
ATOM   1028  CA  ALA A 126      36.117  43.383  79.294  1.00 30.44           C  
ATOM   1029  C   ALA A 126      36.509  44.776  79.787  1.00 31.89           C  
ATOM   1030  O   ALA A 126      36.005  45.261  80.765  1.00 31.13           O  
ATOM   1031  CB  ALA A 126      37.124  42.324  79.718  1.00 28.57           C  
ATOM   1032  N   ASP A 127      37.343  45.453  79.019  1.00 32.96           N  
ATOM   1033  CA  ASP A 127      37.781  46.814  79.319  1.00 32.95           C  
ATOM   1034  C   ASP A 127      36.636  47.781  79.295  1.00 33.56           C  
ATOM   1035  O   ASP A 127      36.543  48.673  80.100  1.00 34.47           O  
ATOM   1036  CB  ASP A 127      38.774  47.272  78.261  1.00 32.77           C  
ATOM   1037  CG  ASP A 127      39.450  48.595  78.633  1.00 35.03           C  
ATOM   1038  OD1 ASP A 127      39.786  48.807  79.805  1.00 34.86           O  
ATOM   1039  OD2 ASP A 127      39.615  49.454  77.778  1.00 39.62           O  
ATOM   1040  N   TYR A 128      35.732  47.547  78.358  1.00 35.94           N  
ATOM   1041  CA  TYR A 128      34.619  48.422  78.140  1.00 37.21           C  
ATOM   1042  C   TYR A 128      33.490  48.226  79.134  1.00 36.50           C  
ATOM   1043  O   TYR A 128      32.897  49.213  79.573  1.00 38.48           O  
ATOM   1044  CB  TYR A 128      34.127  48.175  76.711  1.00 40.09           C  
ATOM   1045  CG  TYR A 128      33.217  49.231  76.244  1.00 47.78           C  
ATOM   1046  CD1 TYR A 128      33.703  50.416  75.684  1.00 59.88           C  
ATOM   1047  CD2 TYR A 128      31.863  49.058  76.370  1.00 61.10           C  
ATOM   1048  CE1 TYR A 128      32.836  51.399  75.263  1.00 57.01           C  
ATOM   1049  CE2 TYR A 128      31.019  49.983  75.942  1.00 66.34           C  
ATOM   1050  CZ  TYR A 128      31.490  51.171  75.407  1.00 62.54           C  
ATOM   1051  OH  TYR A 128      30.558  52.075  75.008  1.00 61.85           O  
ATOM   1052  N   ILE A 129      33.175  46.971  79.474  1.00 32.80           N  
ATOM   1053  CA  ILE A 129      32.031  46.683  80.340  1.00 34.46           C  
ATOM   1054  C   ILE A 129      32.362  46.331  81.807  1.00 35.51           C  
ATOM   1055  O   ILE A 129      31.459  45.977  82.600  1.00 33.46           O  
ATOM   1056  CB  ILE A 129      31.103  45.610  79.706  1.00 35.34           C  
ATOM   1057  CG1 ILE A 129      31.761  44.226  79.679  1.00 39.09           C  
ATOM   1058  CG2 ILE A 129      30.657  46.040  78.270  1.00 33.93           C  
ATOM   1059  CD1 ILE A 129      30.833  43.126  79.395  1.00 33.90           C  
ATOM   1060  N   GLU A 130      33.636  46.430  82.212  1.00 36.04           N  
ATOM   1061  CA  GLU A 130      33.986  46.075  83.611  1.00 34.48           C  
ATOM   1062  C   GLU A 130      33.118  46.912  84.553  1.00 35.99           C  
ATOM   1063  O   GLU A 130      32.746  48.041  84.201  1.00 34.81           O  
ATOM   1064  CB  GLU A 130      35.488  46.210  83.879  1.00 35.73           C  
ATOM   1065  CG  GLU A 130      36.036  47.616  83.832  1.00 27.14           C  
ATOM   1066  CD  GLU A 130      36.100  48.346  85.162  1.00 37.92           C  
ATOM   1067  OE1 GLU A 130      35.547  47.857  86.176  1.00 34.74           O  
ATOM   1068  OE2 GLU A 130      36.725  49.444  85.174  1.00 31.59           O  
ATOM   1069  N   PRO A 131      32.799  46.379  85.748  1.00 35.69           N  
ATOM   1070  CA  PRO A 131      31.714  46.964  86.544  1.00 37.90           C  
ATOM   1071  C   PRO A 131      31.882  48.431  86.951  1.00 38.29           C  
ATOM   1072  O   PRO A 131      30.882  49.103  87.177  1.00 34.91           O  
ATOM   1073  CB  PRO A 131      31.639  46.055  87.776  1.00 36.94           C  
ATOM   1074  CG  PRO A 131      32.915  45.345  87.819  1.00 42.05           C  
ATOM   1075  CD  PRO A 131      33.448  45.261  86.444  1.00 35.27           C  
ATOM   1076  N   ASN A 132      33.103  48.943  87.013  1.00 38.44           N  
ATOM   1077  CA  ASN A 132      33.321  50.353  87.403  1.00 40.04           C  
ATOM   1078  C   ASN A 132      33.077  51.355  86.280  1.00 42.03           C  
ATOM   1079  O   ASN A 132      33.056  52.555  86.517  1.00 42.10           O  
ATOM   1080  CB  ASN A 132      34.750  50.541  87.932  1.00 40.43           C  
ATOM   1081  CG  ASN A 132      35.041  49.660  89.122  1.00 44.56           C  
ATOM   1082  OD1 ASN A 132      34.667  49.999  90.251  1.00 46.20           O  
ATOM   1083  ND2 ASN A 132      35.708  48.513  88.889  1.00 39.27           N  
ATOM   1084  N   ARG A 133      32.917  50.876  85.059  1.00 42.17           N  
ATOM   1085  CA  ARG A 133      32.688  51.767  83.921  1.00 46.78           C  
ATOM   1086  C   ARG A 133      31.246  52.263  83.926  1.00 51.87           C  
ATOM   1087  O   ARG A 133      30.334  51.479  84.136  1.00 50.99           O  
ATOM   1088  CB  ARG A 133      32.950  51.040  82.620  1.00 45.73           C  
ATOM   1089  CG  ARG A 133      34.362  50.642  82.407  1.00 45.98           C  
ATOM   1090  CD  ARG A 133      35.296  51.822  82.194  1.00 44.30           C  
ATOM   1091  NE  ARG A 133      36.256  51.450  81.165  1.00 56.73           N  
ATOM   1092  CZ  ARG A 133      37.518  51.858  81.071  1.00 47.82           C  
ATOM   1093  NH1 ARG A 133      38.073  52.654  81.973  1.00 56.43           N  
ATOM   1094  NH2 ARG A 133      38.237  51.408  80.058  1.00 46.07           N  
ATOM   1095  N   GLN A 134      31.052  53.555  83.677  1.00 58.36           N  
ATOM   1096  CA  GLN A 134      29.723  54.171  83.763  1.00 63.63           C  
ATOM   1097  C   GLN A 134      29.314  54.890  82.505  1.00 64.32           C  
ATOM   1098  O   GLN A 134      28.381  55.693  82.548  1.00 67.60           O  
ATOM   1099  CB  GLN A 134      29.659  55.116  84.962  1.00 64.14           C  
ATOM   1100  CG  GLN A 134      30.141  54.468  86.260  1.00 67.36           C  
ATOM   1101  CD  GLN A 134      29.857  55.296  87.510  1.00 69.78           C  
ATOM   1102  OE1 GLN A 134      29.287  56.394  87.452  1.00 80.49           O  
ATOM   1103  NE2 GLN A 134      30.253  54.754  88.660  1.00 79.87           N  
ATOM   1104  N   PHE A 135      29.945  54.559  81.378  1.00 63.26           N  
ATOM   1105  CA  PHE A 135      29.580  55.191  80.116  0.50 64.24           C  
ATOM   1107  C   PHE A 135      28.075  54.930  79.830  1.00 65.62           C  
ATOM   1108  O   PHE A 135      27.537  53.862  80.164  1.00 65.85           O  
ATOM   1109  CB  PHE A 135      30.441  54.691  78.940  0.50 63.17           C  
ATOM   1111  CG  PHE A 135      29.866  53.496  78.262  0.50 58.97           C  
ATOM   1113  CD1 PHE A 135      28.931  53.659  77.249  0.50 56.31           C  
ATOM   1115  CD2 PHE A 135      30.209  52.216  78.671  0.50 53.64           C  
ATOM   1117  CE1 PHE A 135      28.340  52.573  76.644  0.50 52.64           C  
ATOM   1119  CE2 PHE A 135      29.640  51.131  78.069  0.50 54.02           C  
ATOM   1121  CZ  PHE A 135      28.677  51.316  77.044  0.50 57.55           C  
ATOM   1123  N   PRO A 136      27.367  55.924  79.218  1.00 67.65           N  
ATOM   1124  CA  PRO A 136      25.933  55.739  78.911  1.00 65.16           C  
ATOM   1125  C   PRO A 136      25.575  54.578  78.007  1.00 62.40           C  
ATOM   1126  O   PRO A 136      26.095  54.488  76.917  1.00 65.88           O  
ATOM   1127  CB  PRO A 136      25.564  57.050  78.205  1.00 66.38           C  
ATOM   1128  CG  PRO A 136      26.507  58.042  78.781  1.00 67.97           C  
ATOM   1129  CD  PRO A 136      27.796  57.293  78.842  1.00 68.86           C  
ATOM   1130  N   GLY A 137      24.654  53.724  78.451  1.00 60.95           N  
ATOM   1131  CA  GLY A 137      24.228  52.526  77.692  1.00 57.18           C  
ATOM   1132  C   GLY A 137      24.921  51.222  78.092  1.00 55.28           C  
ATOM   1133  O   GLY A 137      24.524  50.145  77.647  1.00 56.52           O  
ATOM   1134  N   VAL A 138      25.920  51.318  78.964  1.00 54.67           N  
ATOM   1135  CA  VAL A 138      26.745  50.171  79.395  1.00 53.04           C  
ATOM   1136  C   VAL A 138      25.972  48.968  79.870  1.00 51.60           C  
ATOM   1137  O   VAL A 138      26.357  47.840  79.588  1.00 51.06           O  
ATOM   1138  CB  VAL A 138      27.744  50.595  80.499  1.00 51.06           C  
ATOM   1139  CG1 VAL A 138      27.022  50.997  81.752  1.00 52.90           C  
ATOM   1140  CG2 VAL A 138      28.746  49.486  80.766  1.00 49.99           C  
ATOM   1141  N   GLU A 139      24.856  49.213  80.547  1.00 51.73           N  
ATOM   1142  CA  GLU A 139      24.051  48.153  81.125  1.00 52.66           C  
ATOM   1143  C   GLU A 139      23.504  47.232  80.036  1.00 50.76           C  
ATOM   1144  O   GLU A 139      23.517  46.007  80.178  1.00 51.72           O  
ATOM   1145  CB  GLU A 139      22.911  48.718  82.001  1.00 55.21           C  
ATOM   1146  CG  GLU A 139      23.346  49.677  83.168  1.00 62.15           C  
ATOM   1147  CD  GLU A 139      23.537  51.168  82.774  1.00 70.43           C  
ATOM   1148  OE1 GLU A 139      23.326  51.557  81.587  1.00 68.44           O  
ATOM   1149  OE2 GLU A 139      23.917  51.958  83.677  1.00 74.38           O  
ATOM   1150  N   LYS A 140      23.046  47.826  78.941  1.00 49.63           N  
ATOM   1151  CA  LYS A 140      22.583  47.057  77.792  1.00 49.05           C  
ATOM   1152  C   LYS A 140      23.721  46.227  77.201  1.00 42.79           C  
ATOM   1153  O   LYS A 140      23.539  45.053  76.837  1.00 43.87           O  
ATOM   1154  CB  LYS A 140      22.000  47.989  76.716  1.00 50.70           C  
ATOM   1155  N   VAL A 141      24.892  46.841  77.102  1.00 42.43           N  
ATOM   1156  CA  VAL A 141      26.065  46.177  76.525  1.00 37.46           C  
ATOM   1157  C   VAL A 141      26.461  44.965  77.425  1.00 36.51           C  
ATOM   1158  O   VAL A 141      26.741  43.879  76.922  1.00 39.10           O  
ATOM   1159  CB  VAL A 141      27.224  47.176  76.258  1.00 39.27           C  
ATOM   1160  CG1 VAL A 141      28.426  46.470  75.674  1.00 30.01           C  
ATOM   1161  CG2 VAL A 141      26.795  48.264  75.286  1.00 33.78           C  
ATOM   1162  N   ARG A 142      26.440  45.149  78.738  1.00 37.91           N  
ATOM   1163  CA  ARG A 142      26.732  44.065  79.683  1.00 38.96           C  
ATOM   1164  C   ARG A 142      25.804  42.886  79.566  1.00 40.38           C  
ATOM   1165  O   ARG A 142      26.246  41.737  79.635  1.00 41.42           O  
ATOM   1166  CB  ARG A 142      26.650  44.564  81.103  1.00 39.07           C  
ATOM   1167  CG  ARG A 142      27.795  45.407  81.447  1.00 34.75           C  
ATOM   1168  CD  ARG A 142      27.689  45.911  82.846  1.00 41.86           C  
ATOM   1169  NE  ARG A 142      28.793  46.820  83.120  1.00 35.54           N  
ATOM   1170  CZ  ARG A 142      28.736  47.938  83.835  1.00 39.58           C  
ATOM   1171  NH1 ARG A 142      27.613  48.411  84.319  1.00 37.38           N  
ATOM   1172  NH2 ARG A 142      29.834  48.651  83.985  1.00 35.72           N  
ATOM   1173  N   THR A 143      24.514  43.174  79.385  1.00 41.27           N  
ATOM   1174  CA  THR A 143      23.514  42.132  79.185  1.00 41.18           C  
ATOM   1175  C   THR A 143      23.760  41.423  77.849  1.00 39.72           C  
ATOM   1176  O   THR A 143      23.794  40.175  77.760  1.00 40.41           O  
ATOM   1177  CB  THR A 143      22.044  42.734  79.269  1.00 40.47           C  
ATOM   1178  OG1 THR A 143      21.740  43.030  80.634  1.00 45.11           O  
ATOM   1179  CG2 THR A 143      21.002  41.763  78.725  1.00 44.76           C  
ATOM   1180  N   GLN A 144      23.970  42.221  76.816  1.00 38.51           N  
ATOM   1181  CA  GLN A 144      24.238  41.673  75.479  1.00 38.63           C  
ATOM   1182  C   GLN A 144      25.417  40.684  75.451  1.00 38.78           C  
ATOM   1183  O   GLN A 144      25.376  39.632  74.772  1.00 39.64           O  
ATOM   1184  CB  GLN A 144      24.492  42.827  74.514  1.00 36.78           C  
ATOM   1185  CG  GLN A 144      24.340  42.451  73.087  1.00 37.90           C  
ATOM   1186  CD  GLN A 144      24.524  43.634  72.155  1.00 38.35           C  
ATOM   1187  OE1 GLN A 144      25.064  44.688  72.530  1.00 44.74           O  
ATOM   1188  NE2 GLN A 144      24.127  43.449  70.926  1.00 36.78           N  
ATOM   1189  N   ALA A 145      26.428  41.022  76.248  1.00 36.65           N  
ATOM   1190  CA  ALA A 145      27.684  40.290  76.355  1.00 37.04           C  
ATOM   1191  C   ALA A 145      27.487  38.864  76.877  1.00 38.39           C  
ATOM   1192  O   ALA A 145      28.232  37.941  76.526  1.00 37.18           O  
ATOM   1193  CB  ALA A 145      28.639  41.079  77.263  1.00 32.01           C  
ATOM   1194  N   LYS A 146      26.459  38.686  77.689  1.00 39.70           N  
ATOM   1195  CA  LYS A 146      26.141  37.374  78.249  1.00 42.65           C  
ATOM   1196  C   LYS A 146      25.738  36.347  77.193  1.00 43.02           C  
ATOM   1197  O   LYS A 146      25.873  35.132  77.407  1.00 41.83           O  
ATOM   1198  CB  LYS A 146      25.081  37.516  79.330  1.00 42.34           C  
ATOM   1199  CG  LYS A 146      25.613  38.326  80.512  1.00 46.56           C  
ATOM   1200  CD  LYS A 146      24.591  38.492  81.619  1.00 49.21           C  
ATOM   1201  CE  LYS A 146      25.165  39.257  82.813  1.00 52.04           C  
ATOM   1202  NZ  LYS A 146      26.373  38.572  83.358  1.00 56.09           N  
ATOM   1203  N   THR A 147      25.287  36.841  76.042  1.00 44.47           N  
ATOM   1204  CA  THR A 147      24.838  35.996  74.966  1.00 43.52           C  
ATOM   1205  C   THR A 147      25.442  36.273  73.603  1.00 45.22           C  
ATOM   1206  O   THR A 147      25.596  35.338  72.814  1.00 45.42           O  
ATOM   1207  CB  THR A 147      23.302  36.089  74.886  1.00 46.59           C  
ATOM   1208  OG1 THR A 147      22.867  37.432  75.181  1.00 47.18           O  
ATOM   1209  CG2 THR A 147      22.692  35.144  75.939  1.00 46.40           C  
ATOM   1210  N   ASP A 148      25.817  37.521  73.323  1.00 41.43           N  
ATOM   1211  CA  ASP A 148      26.224  37.908  71.987  1.00 41.01           C  
ATOM   1212  C   ASP A 148      27.466  38.744  72.085  1.00 40.32           C  
ATOM   1213  O   ASP A 148      27.358  39.966  72.175  1.00 38.81           O  
ATOM   1214  CB  ASP A 148      25.083  38.724  71.385  1.00 41.22           C  
ATOM   1215  CG  ASP A 148      25.335  39.167  69.958  1.00 42.76           C  
ATOM   1216  OD1 ASP A 148      26.340  38.757  69.334  1.00 39.94           O  
ATOM   1217  OD2 ASP A 148      24.481  39.926  69.457  1.00 46.27           O  
ATOM   1218  N   LEU A 149      28.630  38.080  72.060  1.00 39.73           N  
ATOM   1219  CA  LEU A 149      29.929  38.767  72.205  1.00 37.81           C  
ATOM   1220  C   LEU A 149      30.147  39.781  71.088  1.00 36.26           C  
ATOM   1221  O   LEU A 149      30.456  40.916  71.343  1.00 33.73           O  
ATOM   1222  CB  LEU A 149      31.061  37.749  72.192  1.00 40.64           C  
ATOM   1223  CG  LEU A 149      32.507  38.238  72.373  1.00 36.96           C  
ATOM   1224  CD1 LEU A 149      32.739  38.765  73.757  1.00 33.14           C  
ATOM   1225  CD2 LEU A 149      33.463  37.103  72.110  1.00 38.23           C  
ATOM   1226  N   ASN A 150      29.959  39.355  69.843  1.00 36.69           N  
ATOM   1227  CA  ASN A 150      30.184  40.244  68.689  1.00 36.35           C  
ATOM   1228  C   ASN A 150      29.235  41.442  68.702  1.00 36.75           C  
ATOM   1229  O   ASN A 150      29.657  42.602  68.441  1.00 37.61           O  
ATOM   1230  CB  ASN A 150      30.074  39.449  67.382  1.00 38.04           C  
ATOM   1231  CG  ASN A 150      31.255  38.507  67.160  1.00 38.96           C  
ATOM   1232  OD1 ASN A 150      32.308  38.621  67.803  1.00 39.08           O  
ATOM   1233  ND2 ASN A 150      31.095  37.587  66.211  1.00 44.35           N  
ATOM   1234  N   GLY A 151      27.983  41.186  69.092  1.00 35.53           N  
ATOM   1235  CA  GLY A 151      26.998  42.248  69.240  1.00 35.12           C  
ATOM   1236  C   GLY A 151      27.345  43.249  70.330  1.00 33.20           C  
ATOM   1237  O   GLY A 151      27.176  44.449  70.129  1.00 32.43           O  
ATOM   1238  N   ALA A 152      27.800  42.767  71.490  1.00 33.88           N  
ATOM   1239  CA  ALA A 152      28.267  43.680  72.563  1.00 34.19           C  
ATOM   1240  C   ALA A 152      29.432  44.533  72.091  1.00 31.45           C  
ATOM   1241  O   ALA A 152      29.536  45.717  72.423  1.00 31.63           O  
ATOM   1242  CB  ALA A 152      28.679  42.917  73.835  1.00 32.63           C  
ATOM   1243  N   ILE A 153      30.330  43.920  71.345  1.00 33.05           N  
ATOM   1244  CA  ILE A 153      31.487  44.653  70.820  1.00 31.43           C  
ATOM   1245  C   ILE A 153      31.017  45.668  69.816  1.00 31.32           C  
ATOM   1246  O   ILE A 153      31.501  46.793  69.823  1.00 31.54           O  
ATOM   1247  CB  ILE A 153      32.557  43.716  70.229  1.00 33.55           C  
ATOM   1248  CG1 ILE A 153      33.166  42.863  71.349  1.00 34.80           C  
ATOM   1249  CG2 ILE A 153      33.630  44.561  69.478  1.00 29.54           C  
ATOM   1250  CD1 ILE A 153      34.101  41.786  70.875  1.00 29.51           C  
ATOM   1251  N   ILE A 154      30.050  45.312  68.966  1.00 28.49           N  
ATOM   1252  CA  ILE A 154      29.472  46.301  68.028  1.00 31.40           C  
ATOM   1253  C   ILE A 154      28.867  47.514  68.779  1.00 33.17           C  
ATOM   1254  O   ILE A 154      29.162  48.673  68.481  1.00 31.95           O  
ATOM   1255  CB  ILE A 154      28.412  45.659  67.121  1.00 30.76           C  
ATOM   1256  CG1 ILE A 154      29.093  44.758  66.078  1.00 33.06           C  
ATOM   1257  CG2 ILE A 154      27.594  46.739  66.445  1.00 29.42           C  
ATOM   1258  CD1 ILE A 154      28.170  43.724  65.376  1.00 32.92           C  
ATOM   1259  N   SER A 155      28.060  47.225  69.792  1.00 32.41           N  
ATOM   1260  CA  SER A 155      27.461  48.275  70.612  1.00 32.37           C  
ATOM   1261  C   SER A 155      28.486  49.177  71.262  1.00 31.18           C  
ATOM   1262  O   SER A 155      28.258  50.389  71.377  1.00 32.74           O  
ATOM   1263  CB  SER A 155      26.554  47.661  71.676  1.00 32.02           C  
ATOM   1264  OG  SER A 155      25.502  46.924  71.078  1.00 36.16           O  
ATOM   1265  N   SER A 156      29.600  48.607  71.712  1.00 33.11           N  
ATOM   1266  CA  SER A 156      30.635  49.397  72.352  0.50 33.65           C  
ATOM   1268  C   SER A 156      31.297  50.350  71.352  1.00 35.08           C  
ATOM   1269  O   SER A 156      31.550  51.495  71.670  1.00 35.43           O  
ATOM   1270  CB  SER A 156      31.698  48.501  72.967  0.50 34.70           C  
ATOM   1272  OG  SER A 156      32.410  47.804  71.954  0.50 38.10           O  
ATOM   1274  N   LEU A 157      31.613  49.831  70.163  1.00 36.56           N  
ATOM   1275  CA  LEU A 157      32.195  50.602  69.066  1.00 35.80           C  
ATOM   1276  C   LEU A 157      31.262  51.731  68.627  1.00 36.44           C  
ATOM   1277  O   LEU A 157      31.713  52.857  68.386  1.00 38.25           O  
ATOM   1278  CB  LEU A 157      32.554  49.660  67.901  1.00 37.12           C  
ATOM   1279  CG  LEU A 157      33.735  48.706  68.131  1.00 38.10           C  
ATOM   1280  CD1 LEU A 157      33.807  47.534  67.132  1.00 26.31           C  
ATOM   1281  CD2 LEU A 157      35.037  49.480  68.114  1.00 30.19           C  
ATOM   1282  N   VAL A 158      29.965  51.432  68.522  1.00 37.48           N  
ATOM   1283  CA  VAL A 158      28.948  52.433  68.203  1.00 36.25           C  
ATOM   1284  C   VAL A 158      29.045  53.596  69.213  1.00 38.18           C  
ATOM   1285  O   VAL A 158      29.177  54.758  68.815  1.00 36.07           O  
ATOM   1286  CB  VAL A 158      27.531  51.815  68.136  1.00 35.83           C  
ATOM   1287  CG1 VAL A 158      26.422  52.894  68.185  1.00 37.73           C  
ATOM   1288  CG2 VAL A 158      27.403  50.962  66.850  1.00 29.90           C  
ATOM   1289  N   ASN A 159      29.035  53.282  70.508  1.00 38.59           N  
ATOM   1290  CA  ASN A 159      29.094  54.328  71.519  0.50 37.64           C  
ATOM   1292  C   ASN A 159      30.455  55.079  71.465  1.00 36.57           C  
ATOM   1293  O   ASN A 159      30.483  56.310  71.588  1.00 34.84           O  
ATOM   1294  CB  ASN A 159      28.734  53.748  72.909  0.50 38.75           C  
ATOM   1296  CG  ASN A 159      27.292  53.185  72.979  0.50 36.44           C  
ATOM   1298  OD1 ASN A 159      26.484  53.357  72.055  0.50 31.33           O  
ATOM   1300  ND2 ASN A 159      26.977  52.504  74.079  0.50 34.44           N  
ATOM   1302  N   THR A 160      31.550  54.353  71.245  1.00 37.98           N  
ATOM   1303  CA  THR A 160      32.871  54.969  71.141  1.00 37.73           C  
ATOM   1304  C   THR A 160      32.986  55.915  69.952  1.00 37.18           C  
ATOM   1305  O   THR A 160      33.341  57.087  70.104  1.00 34.65           O  
ATOM   1306  CB  THR A 160      34.004  53.915  71.062  1.00 39.98           C  
ATOM   1307  OG1 THR A 160      34.114  53.278  72.334  1.00 47.52           O  
ATOM   1308  CG2 THR A 160      35.358  54.565  70.709  1.00 39.15           C  
ATOM   1309  N   ILE A 161      32.664  55.392  68.779  1.00 35.51           N  
ATOM   1310  CA  ILE A 161      32.773  56.167  67.550  1.00 35.17           C  
ATOM   1311  C   ILE A 161      31.799  57.336  67.615  1.00 34.47           C  
ATOM   1312  O   ILE A 161      32.158  58.433  67.237  1.00 30.88           O  
ATOM   1313  CB  ILE A 161      32.552  55.302  66.277  1.00 35.98           C  
ATOM   1314  CG1 ILE A 161      33.634  54.208  66.185  1.00 36.98           C  
ATOM   1315  CG2 ILE A 161      32.579  56.202  65.031  1.00 31.74           C  
ATOM   1316  CD1 ILE A 161      33.335  53.044  65.192  1.00 32.67           C  
ATOM   1317  N   THR A 162      30.588  57.116  68.135  1.00 32.60           N  
ATOM   1318  CA  THR A 162      29.628  58.213  68.244  1.00 33.89           C  
ATOM   1319  C   THR A 162      30.178  59.360  69.080  1.00 36.06           C  
ATOM   1320  O   THR A 162      30.030  60.517  68.715  1.00 36.87           O  
ATOM   1321  CB  THR A 162      28.292  57.718  68.813  1.00 35.05           C  
ATOM   1322  OG1 THR A 162      27.673  56.868  67.837  1.00 37.11           O  
ATOM   1323  CG2 THR A 162      27.334  58.880  69.128  1.00 37.80           C  
ATOM   1324  N   PHE A 163      30.809  59.015  70.201  1.00 37.05           N  
ATOM   1325  CA  PHE A 163      31.368  59.985  71.132  1.00 35.72           C  
ATOM   1326  C   PHE A 163      32.482  60.766  70.483  1.00 33.10           C  
ATOM   1327  O   PHE A 163      32.520  61.982  70.568  1.00 34.27           O  
ATOM   1328  CB  PHE A 163      31.910  59.272  72.376  1.00 41.02           C  
ATOM   1329  CG  PHE A 163      32.554  60.194  73.355  1.00 40.43           C  
ATOM   1330  CD1 PHE A 163      31.769  60.946  74.223  1.00 47.94           C  
ATOM   1331  CD2 PHE A 163      33.942  60.356  73.376  1.00 49.80           C  
ATOM   1332  CE1 PHE A 163      32.357  61.836  75.116  1.00 49.28           C  
ATOM   1333  CE2 PHE A 163      34.543  61.251  74.276  1.00 48.51           C  
ATOM   1334  CZ  PHE A 163      33.735  61.992  75.141  1.00 46.11           C  
ATOM   1335  N   LEU A 164      33.395  60.066  69.834  1.00 34.64           N  
ATOM   1336  CA  LEU A 164      34.505  60.731  69.161  1.00 34.06           C  
ATOM   1337  C   LEU A 164      34.003  61.712  68.062  1.00 34.46           C  
ATOM   1338  O   LEU A 164      34.569  62.812  67.883  1.00 33.38           O  
ATOM   1339  CB  LEU A 164      35.485  59.675  68.580  1.00 35.38           C  
ATOM   1340  CG  LEU A 164      36.293  58.786  69.560  1.00 35.58           C  
ATOM   1341  CD1 LEU A 164      37.091  57.761  68.798  1.00 33.09           C  
ATOM   1342  CD2 LEU A 164      37.215  59.638  70.438  1.00 37.72           C  
ATOM   1343  N   LEU A 165      32.971  61.302  67.314  1.00 33.73           N  
ATOM   1344  CA  LEU A 165      32.390  62.153  66.265  1.00 33.99           C  
ATOM   1345  C   LEU A 165      31.814  63.419  66.853  1.00 37.16           C  
ATOM   1346  O   LEU A 165      32.071  64.520  66.352  1.00 38.65           O  
ATOM   1347  CB  LEU A 165      31.299  61.396  65.482  1.00 33.81           C  
ATOM   1348  CG  LEU A 165      31.804  60.355  64.481  1.00 29.01           C  
ATOM   1349  CD1 LEU A 165      30.610  59.497  64.042  1.00 32.90           C  
ATOM   1350  CD2 LEU A 165      32.509  61.005  63.257  1.00 34.68           C  
ATOM   1351  N   LYS A 166      31.080  63.252  67.953  1.00 41.05           N  
ATOM   1352  CA  LYS A 166      30.416  64.345  68.688  1.00 39.37           C  
ATOM   1353  C   LYS A 166      31.407  65.341  69.256  1.00 42.11           C  
ATOM   1354  O   LYS A 166      31.131  66.522  69.276  1.00 40.27           O  
ATOM   1355  CB  LYS A 166      29.608  63.743  69.841  1.00 41.62           C  
ATOM   1356  CG  LYS A 166      28.878  64.716  70.746  1.00 46.37           C  
ATOM   1357  N   LYS A 167      32.553  64.852  69.737  1.00 42.17           N  
ATOM   1358  CA  LYS A 167      33.622  65.721  70.240  1.00 41.20           C  
ATOM   1359  C   LYS A 167      34.592  66.156  69.126  1.00 41.12           C  
ATOM   1360  O   LYS A 167      35.609  66.787  69.403  1.00 42.01           O  
ATOM   1361  CB  LYS A 167      34.389  65.007  71.372  1.00 42.07           C  
ATOM   1362  CG  LYS A 167      33.542  64.532  72.551  1.00 44.21           C  
ATOM   1363  CD  LYS A 167      32.817  65.676  73.225  1.00 46.36           C  
ATOM   1364  CE  LYS A 167      32.179  65.284  74.557  1.00 48.76           C  
ATOM   1365  NZ  LYS A 167      31.432  66.444  75.144  1.00 45.76           N  
ATOM   1366  N   ASN A 168      34.294  65.828  67.873  1.00 39.65           N  
ATOM   1367  CA  ASN A 168      35.154  66.174  66.729  1.00 40.12           C  
ATOM   1368  C   ASN A 168      36.612  65.705  66.855  1.00 41.09           C  
ATOM   1369  O   ASN A 168      37.549  66.466  66.611  1.00 37.74           O  
ATOM   1370  CB  ASN A 168      35.093  67.675  66.424  1.00 45.38           C  
ATOM   1371  CG  ASN A 168      33.734  68.124  65.874  1.00 42.06           C  
ATOM   1372  OD1 ASN A 168      32.815  67.323  65.631  1.00 40.92           O  
ATOM   1373  ND2 ASN A 168      33.612  69.413  65.676  1.00 40.03           N  
ATOM   1374  N   GLN A 169      36.775  64.435  67.218  1.00 37.42           N  
ATOM   1375  CA  GLN A 169      38.065  63.841  67.396  1.00 37.76           C  
ATOM   1376  C   GLN A 169      38.343  62.938  66.219  1.00 37.58           C  
ATOM   1377  O   GLN A 169      37.424  62.410  65.609  1.00 35.02           O  
ATOM   1378  CB  GLN A 169      38.103  63.038  68.674  1.00 39.63           C  
ATOM   1379  CG  GLN A 169      37.719  63.826  69.928  1.00 44.06           C  
ATOM   1380  CD  GLN A 169      38.733  64.888  70.292  1.00 43.55           C  
ATOM   1381  OE1 GLN A 169      39.910  64.589  70.511  1.00 48.76           O  
ATOM   1382  NE2 GLN A 169      38.282  66.134  70.373  1.00 48.85           N  
ATOM   1383  N   PRO A 170      39.623  62.756  65.882  1.00 39.44           N  
ATOM   1384  CA  PRO A 170      39.958  61.856  64.790  1.00 39.65           C  
ATOM   1385  C   PRO A 170      39.586  60.421  65.168  1.00 40.44           C  
ATOM   1386  O   PRO A 170      39.607  60.079  66.357  1.00 36.30           O  
ATOM   1387  CB  PRO A 170      41.471  62.036  64.640  1.00 43.52           C  
ATOM   1388  CG  PRO A 170      41.922  62.525  65.937  1.00 45.99           C  
ATOM   1389  CD  PRO A 170      40.819  63.370  66.474  1.00 41.39           C  
ATOM   1390  N   ILE A 171      39.148  59.634  64.188  1.00 35.29           N  
ATOM   1391  CA  ILE A 171      38.787  58.239  64.430  1.00 34.01           C  
ATOM   1392  C   ILE A 171      39.735  57.332  63.643  1.00 32.52           C  
ATOM   1393  O   ILE A 171      39.918  57.478  62.448  1.00 33.80           O  
ATOM   1394  CB  ILE A 171      37.311  58.008  64.102  1.00 31.01           C  
ATOM   1395  CG1 ILE A 171      36.455  58.851  65.048  1.00 34.73           C  
ATOM   1396  CG2 ILE A 171      36.951  56.495  64.166  1.00 28.80           C  
ATOM   1397  CD1 ILE A 171      35.097  59.194  64.471  1.00 36.25           C  
ATOM   1398  N   TYR A 172      40.357  56.409  64.364  1.00 30.44           N  
ATOM   1399  CA  TYR A 172      41.300  55.461  63.815  1.00 30.30           C  
ATOM   1400  C   TYR A 172      40.536  54.591  62.842  1.00 30.47           C  
ATOM   1401  O   TYR A 172      39.545  53.972  63.213  1.00 32.26           O  
ATOM   1402  CB  TYR A 172      41.935  54.633  64.919  1.00 32.54           C  
ATOM   1403  CG  TYR A 172      43.091  53.771  64.472  1.00 32.98           C  
ATOM   1404  CD1 TYR A 172      44.240  54.343  63.901  1.00 32.97           C  
ATOM   1405  CD2 TYR A 172      43.044  52.393  64.614  1.00 36.69           C  
ATOM   1406  CE1 TYR A 172      45.318  53.549  63.504  1.00 39.70           C  
ATOM   1407  CE2 TYR A 172      44.100  51.602  64.223  1.00 34.01           C  
ATOM   1408  CZ  TYR A 172      45.236  52.176  63.669  1.00 37.31           C  
ATOM   1409  OH  TYR A 172      46.258  51.340  63.272  1.00 36.92           O  
ATOM   1410  N   PRO A 173      40.954  54.574  61.572  1.00 31.48           N  
ATOM   1411  CA  PRO A 173      40.205  53.806  60.564  1.00 33.86           C  
ATOM   1412  C   PRO A 173      40.006  52.319  60.839  1.00 34.45           C  
ATOM   1413  O   PRO A 173      38.948  51.809  60.532  1.00 36.10           O  
ATOM   1414  CB  PRO A 173      41.060  53.984  59.301  1.00 32.78           C  
ATOM   1415  CG  PRO A 173      41.718  55.288  59.509  1.00 33.72           C  
ATOM   1416  CD  PRO A 173      42.081  55.293  60.957  1.00 34.27           C  
ATOM   1417  N   ASP A 174      40.996  51.643  61.432  1.00 34.83           N  
ATOM   1418  CA  ASP A 174      40.862  50.203  61.715  1.00 36.63           C  
ATOM   1419  C   ASP A 174      39.814  49.925  62.790  1.00 33.92           C  
ATOM   1420  O   ASP A 174      39.329  48.797  62.908  1.00 37.48           O  
ATOM   1421  CB  ASP A 174      42.190  49.545  62.096  1.00 37.26           C  
ATOM   1422  CG  ASP A 174      42.389  48.204  61.427  1.00 42.71           C  
ATOM   1423  OD1 ASP A 174      42.001  48.067  60.230  1.00 38.97           O  
ATOM   1424  OD2 ASP A 174      42.991  47.306  62.067  1.00 42.89           O  
ATOM   1425  N   THR A 175      39.467  50.945  63.575  1.00 31.96           N  
ATOM   1426  CA  THR A 175      38.362  50.819  64.532  1.00 30.35           C  
ATOM   1427  C   THR A 175      37.014  50.737  63.806  1.00 32.69           C  
ATOM   1428  O   THR A 175      36.143  49.919  64.163  1.00 31.37           O  
ATOM   1429  CB  THR A 175      38.400  51.971  65.517  1.00 30.99           C  
ATOM   1430  OG1 THR A 175      39.611  51.838  66.258  1.00 31.81           O  
ATOM   1431  CG2 THR A 175      37.165  51.956  66.485  1.00 32.13           C  
ATOM   1432  N   LEU A 176      36.854  51.557  62.779  1.00 29.82           N  
ATOM   1433  CA  LEU A 176      35.684  51.465  61.922  1.00 30.52           C  
ATOM   1434  C   LEU A 176      35.704  50.161  61.133  1.00 28.54           C  
ATOM   1435  O   LEU A 176      34.677  49.551  60.931  1.00 32.76           O  
ATOM   1436  CB  LEU A 176      35.625  52.665  60.957  1.00 29.80           C  
ATOM   1437  CG  LEU A 176      34.326  52.730  60.121  1.00 30.18           C  
ATOM   1438  CD1 LEU A 176      33.139  53.031  60.997  1.00 28.36           C  
ATOM   1439  CD2 LEU A 176      34.446  53.753  59.011  1.00 30.91           C  
ATOM   1440  N   ALA A 177      36.872  49.730  60.663  1.00 30.48           N  
ATOM   1441  CA  ALA A 177      36.954  48.472  59.937  1.00 29.32           C  
ATOM   1442  C   ALA A 177      36.493  47.356  60.850  1.00 30.41           C  
ATOM   1443  O   ALA A 177      35.840  46.433  60.394  1.00 32.96           O  
ATOM   1444  CB  ALA A 177      38.353  48.205  59.425  1.00 28.57           C  
ATOM   1445  N   THR A 178      36.839  47.446  62.138  1.00 34.05           N  
ATOM   1446  CA  THR A 178      36.390  46.475  63.141  1.00 30.16           C  
ATOM   1447  C   THR A 178      34.855  46.426  63.221  1.00 32.25           C  
ATOM   1448  O   THR A 178      34.265  45.357  63.158  1.00 32.11           O  
ATOM   1449  CB  THR A 178      37.023  46.772  64.521  1.00 30.20           C  
ATOM   1450  OG1 THR A 178      38.447  46.691  64.380  1.00 30.91           O  
ATOM   1451  CG2 THR A 178      36.536  45.791  65.586  1.00 32.24           C  
ATOM   1452  N   TYR A 179      34.238  47.584  63.406  1.00 32.69           N  
ATOM   1453  CA  TYR A 179      32.787  47.713  63.397  1.00 29.43           C  
ATOM   1454  C   TYR A 179      32.180  47.113  62.156  1.00 30.91           C  
ATOM   1455  O   TYR A 179      31.271  46.290  62.236  1.00 29.41           O  
ATOM   1456  CB  TYR A 179      32.417  49.190  63.463  1.00 32.34           C  
ATOM   1457  CG  TYR A 179      30.995  49.497  63.135  1.00 34.24           C  
ATOM   1458  CD1 TYR A 179      29.995  49.349  64.094  1.00 33.28           C  
ATOM   1459  CD2 TYR A 179      30.636  49.940  61.860  1.00 27.54           C  
ATOM   1460  CE1 TYR A 179      28.679  49.625  63.794  1.00 31.09           C  
ATOM   1461  CE2 TYR A 179      29.332  50.236  61.553  1.00 31.09           C  
ATOM   1462  CZ  TYR A 179      28.341  50.074  62.512  1.00 27.35           C  
ATOM   1463  OH  TYR A 179      27.038  50.357  62.187  1.00 31.07           O  
ATOM   1464  N   ASN A 180      32.671  47.538  61.001  1.00 29.51           N  
ATOM   1465  CA  ASN A 180      32.144  47.020  59.728  1.00 30.96           C  
ATOM   1466  C   ASN A 180      32.300  45.518  59.595  1.00 33.86           C  
ATOM   1467  O   ASN A 180      31.357  44.845  59.173  1.00 33.06           O  
ATOM   1468  CB  ASN A 180      32.810  47.709  58.544  1.00 30.76           C  
ATOM   1469  CG  ASN A 180      32.258  49.077  58.289  1.00 29.26           C  
ATOM   1470  OD1 ASN A 180      31.078  49.310  58.476  1.00 33.33           O  
ATOM   1471  ND2 ASN A 180      33.087  49.970  57.767  1.00 28.58           N  
ATOM   1472  N   GLN A 181      33.458  44.987  59.980  1.00 34.95           N  
ATOM   1473  CA  GLN A 181      33.690  43.542  59.866  1.00 35.10           C  
ATOM   1474  C   GLN A 181      32.723  42.719  60.719  1.00 36.58           C  
ATOM   1475  O   GLN A 181      32.162  41.727  60.240  1.00 37.95           O  
ATOM   1476  CB  GLN A 181      35.141  43.185  60.194  1.00 36.13           C  
ATOM   1477  CG  GLN A 181      35.435  41.670  60.191  1.00 37.07           C  
ATOM   1478  CD  GLN A 181      35.342  41.069  61.567  1.00 40.19           C  
ATOM   1479  OE1 GLN A 181      36.023  41.536  62.482  1.00 39.74           O  
ATOM   1480  NE2 GLN A 181      34.529  40.021  61.730  1.00 40.06           N  
ATOM   1481  N   LEU A 182      32.528  43.143  61.957  1.00 36.95           N  
ATOM   1482  CA  LEU A 182      31.659  42.468  62.896  1.00 37.63           C  
ATOM   1483  C   LEU A 182      30.223  42.646  62.512  1.00 40.59           C  
ATOM   1484  O   LEU A 182      29.410  41.756  62.701  1.00 41.71           O  
ATOM   1485  CB  LEU A 182      31.862  43.017  64.311  1.00 38.09           C  
ATOM   1486  CG  LEU A 182      33.177  42.656  65.006  1.00 39.05           C  
ATOM   1487  CD1 LEU A 182      33.285  43.429  66.291  1.00 33.86           C  
ATOM   1488  CD2 LEU A 182      33.276  41.171  65.263  1.00 36.83           C  
ATOM   1489  N   LEU A 183      29.911  43.825  62.000  1.00 42.73           N  
ATOM   1490  CA  LEU A 183      28.580  44.112  61.508  1.00 44.58           C  
ATOM   1491  C   LEU A 183      28.277  43.202  60.333  1.00 45.48           C  
ATOM   1492  O   LEU A 183      27.308  42.462  60.375  1.00 44.20           O  
ATOM   1493  CB  LEU A 183      28.471  45.572  61.063  1.00 43.03           C  
ATOM   1494  CG  LEU A 183      27.064  46.114  60.896  1.00 50.86           C  
ATOM   1495  CD1 LEU A 183      26.423  46.396  62.276  1.00 52.75           C  
ATOM   1496  CD2 LEU A 183      27.128  47.369  60.021  1.00 43.26           C  
ATOM   1497  N   LEU A 184      29.123  43.248  59.303  1.00 49.91           N  
ATOM   1498  CA  LEU A 184      28.885  42.502  58.057  1.00 55.18           C  
ATOM   1499  C   LEU A 184      28.878  40.978  58.277  1.00 57.75           C  
ATOM   1500  O   LEU A 184      28.135  40.274  57.599  1.00 59.64           O  
ATOM   1501  CB  LEU A 184      29.824  42.963  56.909  1.00 53.05           C  
ATOM   1502  CG  LEU A 184      29.705  44.468  56.499  1.00 55.61           C  
ATOM   1503  CD1 LEU A 184      30.676  44.891  55.371  1.00 45.61           C  
ATOM   1504  CD2 LEU A 184      28.282  44.851  56.132  1.00 53.24           C  
ATOM   1505  N   GLU A 185      29.652  40.477  59.228  1.00 60.40           N  
ATOM   1506  CA  GLU A 185      29.589  39.055  59.607  1.00 64.09           C  
ATOM   1507  C   GLU A 185      28.341  38.785  60.475  1.00 67.44           C  
ATOM   1508  O   GLU A 185      27.760  37.704  60.377  1.00 69.31           O  
ATOM   1509  CB  GLU A 185      30.930  38.579  60.241  1.00 65.50           C  
ATOM   1510  CG  GLU A 185      30.912  37.548  61.418  1.00 65.25           C  
ATOM   1511  CD  GLU A 185      31.121  38.210  62.803  1.00 72.88           C  
ATOM   1512  OE1 GLU A 185      30.180  38.872  63.366  1.00 60.31           O  
ATOM   1513  OE2 GLU A 185      32.272  38.080  63.294  1.00 71.67           O  
ATOM   1514  N   GLN A 186      27.967  39.779  61.299  1.00 70.96           N  
ATOM   1515  CA  GLN A 186      26.754  39.847  62.188  1.00 70.81           C  
ATOM   1516  C   GLN A 186      27.059  39.720  63.700  1.00 72.08           C  
ATOM   1517  O   GLN A 186      26.548  40.501  64.523  1.00 70.13           O  
ATOM   1518  CB  GLN A 186      25.599  38.912  61.783  1.00 72.79           C  
ATOM   1519  CG  GLN A 186      25.080  39.128  60.355  1.00 75.56           C  
ATOM   1520  CD  GLN A 186      23.577  39.011  60.237  1.00 83.86           C  
ATOM   1521  OE1 GLN A 186      22.940  38.199  60.915  1.00 84.25           O  
ATOM   1522  NE2 GLN A 186      22.994  39.825  59.357  1.00 91.74           N  
TER    1523      GLN A 186                                                      
END
MOLECULE T0470.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
