
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  174 ( 1343),  selected  174 , name 2pq7_A
# Molecule2: number of CA atoms  188 ( 1523),  selected  188 , name T0470.pdb
# PARAMETERS: 2pq7_A.T0470.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      T       2           -
LGA    N     2_A      -       -           -
LGA    L     3_A      -       -           -
LGA    T     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    X     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    R     9_A      K       3           #
LGA    I    10_A      Q       4          2.224
LGA    P    11_A      E       5          3.178
LGA    H    12_A      K       6          1.377
LGA    L    13_A      I       7          2.432
LGA    R    14_A      E       8          2.564
LGA    E    15_A      K       9          1.502
LGA    I    16_A      T      10          0.803
LGA    L    17_A      I      11          1.109
LGA    N    18_A      T      12          1.175
LGA    I    19_A      F      13          1.294
LGA    V    20_A      V      14          0.491
LGA    R    21_A      K      15          1.323
LGA    E    22_A      H      16          1.438
LGA    A    23_A      I      17          1.525
LGA    F    24_A      L      18          1.330
LGA    K    25_A      E      19          1.465
LGA    -       -      K      20           -
LGA    D    26_A      D      21          3.825
LGA    Y    27_A      A      22          0.995
LGA    D    28_A      S      23          4.121
LGA    D    29_A      G      24           -
LGA    P    30_A      H      25           -
LGA    A    31_A      -       -           -
LGA    H    32_A      -       -           -
LGA    D    33_A      D      26          2.444
LGA    I    34_A      W      27          2.563
LGA    S    35_A      Y      28          2.301
LGA    H    36_A      H      29          1.924
LGA    T    37_A      I      30          1.181
LGA    F    38_A      R      31          1.412
LGA    R    39_A      R      32          1.568
LGA    V    40_A      V      33          1.376
LGA    X    41_A      H      34          0.771
LGA    E    42_A      K      35          1.889
LGA    N    43_A      M      36          1.812
LGA    A    44_A      A      37          0.842
LGA    S    45_A      I      38          1.035
LGA    E    46_A      S      39          1.501
LGA    I    47_A      L      40          1.238
LGA    A    48_A      S      41          1.128
LGA    S    49_A      E      42          1.155
LGA    R    50_A      Q      43          0.861
LGA    E    51_A      E      44          0.521
LGA    K    52_A      G      45          1.845
LGA    C    53_A      G      46          1.637
LGA    D    54_A      N      47          1.269
LGA    L    55_A      R      48          1.243
LGA    Q    56_A      F      49          0.956
LGA    K    57_A      I      50          0.786
LGA    A    58_A      I      51          0.789
LGA    I    59_A      E      52          0.955
LGA    I    60_A      M      53          0.874
LGA    A    61_A      A      54          0.373
LGA    A    62_A      A      55          0.650
LGA    L    63_A      L      56          0.691
LGA    L    64_A      L      57          0.483
LGA    H    65_A      H      58          0.541
LGA    D    66_A      D      59          0.569
LGA    I    67_A      V      60          0.885
LGA    K    68_A      A      61          3.009
LGA    R    69_A      D      62          3.539
LGA    P    70_A      L      65          3.008
LGA    H    71_A      N      66          1.956
LGA    E    72_A      E      67          3.823
LGA    A    73_A      -       -           -
LGA    L    74_A      -       -           -
LGA    T    75_A      -       -           -
LGA    G    76_A      -       -           -
LGA    V    77_A      S      68          1.853
LGA    D    78_A      E      69          2.409
LGA    H    79_A      -       -           -
LGA    A    80_A      -       -           -
LGA    E    81_A      E      70          3.226
LGA    S    82_A      A      71          3.620
LGA    G    83_A      G      72          3.920
LGA    A    84_A      M      73          3.348
LGA    E    85_A      K      74          2.626
LGA    Y    86_A      K      75          2.565
LGA    A    87_A      V      76          2.649
LGA    S    88_A      S      77          2.246
LGA    G    89_A      D      78          1.416
LGA    L    90_A      W      79          1.098
LGA    L    91_A      L      80          1.267
LGA    P    92_A      E      81          2.521
LGA    T    93_A      E      82          2.129
LGA    X    94_A      L      83          1.570
LGA    G    95_A      H      84          2.693
LGA    F    96_A      V      85          1.827
LGA    D    97_A      E      86          1.449
LGA    I    98_A      E      87          1.499
LGA    S    99_A      E      88          1.251
LGA    F   100_A      E      89          1.039
LGA    V   101_A      S      90          0.474
LGA    A   102_A      K      91          0.612
LGA    E   103_A      H      92          0.493
LGA    V   104_A      V      93          0.442
LGA    S   105_A      L      94          0.803
LGA    K   106_A      H      95          0.701
LGA    A   107_A      I      96          0.768
LGA    I   108_A      I      97          0.220
LGA    R   109_A      A      98          1.050
LGA    S   110_A      N      99          1.548
LGA    H   111_A      M     100          1.728
LGA    R   112_A      -       -           -
LGA    T   118_A      -       -           -
LGA    P   119_A      -       -           -
LGA    T   120_A      -       -           -
LGA    S   121_A      S     112          2.058
LGA    L   122_A      I     113          1.969
LGA    T   123_A      E     114          2.096
LGA    G   124_A      G     115          1.815
LGA    K   125_A      K     116          1.227
LGA    I   126_A      L     117          1.324
LGA    L   127_A      V     118          1.667
LGA    Q   128_A      Q     119          1.517
LGA    D   129_A      D     120          1.422
LGA    A   130_A      A     121          1.313
LGA    D   131_A      D     122          1.378
LGA    R   132_A      R     123          1.061
LGA    L   133_A      L     124          1.090
LGA    D   134_A      D     125          1.159
LGA    A   135_A      A     126          1.342
LGA    I   136_A      L     127          0.679
LGA    G   137_A      G     128          1.135
LGA    A   138_A      A     129          1.378
LGA    V   139_A      I     130          1.206
LGA    A   140_A      G     131          1.370
LGA    I   141_A      I     132          1.362
LGA    A   142_A      A     133          1.675
LGA    R   143_A      R     134          1.438
LGA    V   144_A      T     135          1.572
LGA    F   145_A      F     136          2.532
LGA    S   146_A      A     137          2.459
LGA    Y   147_A      Y     138          2.716
LGA    -       -      G     139           -
LGA    -       -      G     140           -
LGA    -       -      A     141           -
LGA    -       -      K     142           -
LGA    -       -      G     143           -
LGA    -       -      R     144           -
LGA    -       -      L     145           -
LGA    -       -      M     146           -
LGA    -       -      Y     147           -
LGA    -       -      D     148           -
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    -       -      S     169           -
LGA    -       -      L     170           -
LGA    -       -      N     171           -
LGA    -       -      H     172           -
LGA    -       -      F     173           -
LGA    -       -      Y     174           -
LGA    -       -      E     175           -
LGA    -       -      K     176           -
LGA    -       -      L     177           -
LGA    -       -      L     178           -
LGA    -       -      K     179           -
LGA    -       -      L     180           -
LGA    P   186_A      K     181          1.911
LGA    E   187_A      D     182          2.632
LGA    T   188_A      L     183          1.362
LGA    F   189_A      M     184          1.445
LGA    W   190_A      N     185          1.485
LGA    T   191_A      T     186          0.954
LGA    E   192_A      N     187          1.182
LGA    T   193_A      A     188          1.249
LGA    A   194_A      A     189          1.013
LGA    R   195_A      K     190          1.029
LGA    K   196_A      Q     191          1.034
LGA    X   197_A      E     192          1.415
LGA    A   198_A      A     193          1.196
LGA    E   199_A      E     194          1.050
LGA    D   200_A      V     195          1.087
LGA    R   201_A      R     196          0.620
LGA    Y   202_A      H     197          0.447
LGA    S   203_A      R     198          0.426
LGA    F   204_A      Y     199          0.850
LGA    V   205_A      M     200          0.832
LGA    V   206_A      E     201          0.638
LGA    E   207_A      Q     202          0.879
LGA    F   208_A      F     203          0.981
LGA    V   209_A      I     204          0.853
LGA    Q   210_A      E     205          0.500
LGA    R   211_A      Q     206          0.716
LGA    F   212_A      F     207          0.944
LGA    L   213_A      M     208          0.916
LGA    A   214_A      K     209          1.289
LGA    E   215_A      E     210          2.018
LGA    W   216_A      W     211          2.440
LGA    G   217_A      N     212          1.711
LGA    -       -      A     213           -
LGA    -       -      Q     214           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  174  188    5.0    151    1.71    31.79     73.157     8.329

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.769962 * X  +  -0.638046 * Y  +  -0.007498 * Z  +  93.878799
  Y_new =   0.619782 * X  +  -0.745024 * Y  +  -0.246595 * Z  +  39.114681
  Z_new =   0.151753 * X  +  -0.194515 * Y  +   0.969090 * Z  +  69.269264 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.198087    2.943505  [ DEG:   -11.3496    168.6504 ]
  Theta =  -0.152341   -2.989251  [ DEG:    -8.7285   -171.2715 ]
  Phi   =   2.463840   -0.677753  [ DEG:   141.1676    -38.8324 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pq7_A                                        
REMARK     2: T0470.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pq7_A.T0470.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  174  188   5.0  151   1.71   31.79  73.157
REMARK  ---------------------------------------------------------- 
MOLECULE 2pq7_A
HEADER    HYDROLASE                               01-MAY-07   2PQ7              
TITLE     CRYSTAL STRUCTURE OF PREDICTED HD SUPERFAMILY HYDROLASE               
TITLE    2 (104161995) FROM UNCULTURED THERMOTOGALES BACTERIUM AT               
TITLE    3 1.45 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PREDICTED HD SUPERFAMILY HYDROLASE;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: UNCULTURED THERMOTOGALES BACTERIUM;             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: 104161995, MES0020;                                            
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    104161995, HD DOMAIN, PREDICTED HD SUPERFAMILY HYDROLASE,             
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   15-MAY-07 2PQ7    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PREDICTED HD SUPERFAMILY                
JRNL        TITL 2 HYDROLASE (104161995) FROM UNCULTURED                        
JRNL        TITL 3 THERMOTOGALES BACTERIUM AT 1.45 A RESOLUTION                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  2PQ7 A    1   219  UNP    Q1EM40   Q1EM40_9BACT     1    219             
SEQRES   1 A  220  GLY MSE ASN LEU THR GLU LEU MSE GLU ARG ILE PRO HIS          
SEQRES   2 A  220  LEU ARG GLU ILE LEU ASN ILE VAL ARG GLU ALA PHE LYS          
SEQRES   3 A  220  ASP TYR ASP ASP PRO ALA HIS ASP ILE SER HIS THR PHE          
SEQRES   4 A  220  ARG VAL MSE GLU ASN ALA SER GLU ILE ALA SER ARG GLU          
SEQRES   5 A  220  LYS CYS ASP LEU GLN LYS ALA ILE ILE ALA ALA LEU LEU          
SEQRES   6 A  220  HIS ASP ILE LYS ARG PRO HIS GLU ALA LEU THR GLY VAL          
SEQRES   7 A  220  ASP HIS ALA GLU SER GLY ALA GLU TYR ALA SER GLY LEU          
SEQRES   8 A  220  LEU PRO THR MSE GLY PHE ASP ILE SER PHE VAL ALA GLU          
SEQRES   9 A  220  VAL SER LYS ALA ILE ARG SER HIS ARG TYR SER GLY GLY          
SEQRES  10 A  220  LEU THR PRO THR SER LEU THR GLY LYS ILE LEU GLN ASP          
SEQRES  11 A  220  ALA ASP ARG LEU ASP ALA ILE GLY ALA VAL ALA ILE ALA          
SEQRES  12 A  220  ARG VAL PHE SER TYR SER GLY LYS THR GLY THR PRO LEU          
SEQRES  13 A  220  HIS SER LEU GLN PHE SER PRO ARG SER SER TYR SER GLY          
SEQRES  14 A  220  ASN SER ARG SER SER ILE ASN HIS PHE HIS GLU LYS ILE          
SEQRES  15 A  220  LEU LYS ILE ARG PRO GLU THR PHE TRP THR GLU THR ALA          
SEQRES  16 A  220  ARG LYS MSE ALA GLU ASP ARG TYR SER PHE VAL VAL GLU          
SEQRES  17 A  220  PHE VAL GLN ARG PHE LEU ALA GLU TRP GLY GLN ILE              
HET    MSE  A   1      16                                                       
HET    MSE  A   7      16                                                       
HET    MSE  A  41      16                                                       
HET    MSE  A  94       8                                                       
HET    MSE  A 197      16                                                       
HET     FE      1       1                                                       
HET     FE      2       1                                                       
HET     CL      3       1                                                       
HET    PO4      4       5                                                       
HET    PO4      5       5                                                       
HET    MPD      6       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      FE FE (III) ION                                                     
HETNAM      CL CHLORIDE ION                                                     
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     MPD (4S)-2-METHYL-2,4-PENTANEDIOL                                    
FORMUL   1  MSE    5(C5 H11 N O2 SE)                                            
FORMUL   2   FE    2(FE 3+)                                                     
FORMUL   4   CL    CL 1-                                                        
FORMUL   5  PO4    2(O4 P 3-)                                                   
FORMUL   7  MPD    C6 H14 O2                                                    
FORMUL   8  HOH   *148(H2 O)                                                    
CRYST1  138.518   40.662   37.789  90.00  95.32  90.00 C 1 2 1       4          
HETATM    1  N   MSE A   1      35.330  34.211  91.343  0.50 33.95           N  
HETATM    3  CA  MSE A   1      36.604  33.854  92.041  0.50 31.87           C  
HETATM    5  C   MSE A   1      37.244  35.009  92.761  0.50 33.90           C  
HETATM    7  O   MSE A   1      37.228  36.132  92.261  0.50 35.43           O  
HETATM    9  CB  MSE A   1      37.648  33.313  91.058  0.50 32.93           C  
HETATM   11  CG  MSE A   1      37.712  31.809  90.941  0.50 29.30           C  
HETATM   13 SE   MSE A   1      39.290  31.328  89.909  0.37 24.68          SE  
HETATM   15  CE  MSE A   1      38.420  31.876  88.076  0.50 21.18           C  
ATOM     17  N   ASN A   2      37.814  34.717  93.935  1.00 32.36           N  
ATOM     18  CA  ASN A   2      38.570  35.675  94.701  1.00 34.03           C  
ATOM     19  C   ASN A   2      40.006  35.570  94.210  1.00 33.12           C  
ATOM     20  O   ASN A   2      40.320  34.685  93.400  1.00 31.25           O  
ATOM     21  CB  ASN A   2      38.453  35.421  96.226  1.00 35.45           C  
ATOM     22  CG  ASN A   2      38.975  34.045  96.670  1.00 37.03           C  
ATOM     23  OD1 ASN A   2      39.952  33.533  96.156  1.00 31.39           O  
ATOM     24  ND2 ASN A   2      38.320  33.465  97.674  1.00 36.40           N  
ATOM     25  N   LEU A   3      40.880  36.450  94.691  1.00 32.38           N  
ATOM     26  CA  LEU A   3      42.273  36.456  94.257  1.00 33.47           C  
ATOM     27  C   LEU A   3      43.050  35.205  94.635  1.00 29.92           C  
ATOM     28  O   LEU A   3      43.953  34.783  93.904  1.00 28.81           O  
ATOM     29  CB  LEU A   3      43.023  37.709  94.758  1.00 34.30           C  
ATOM     30  CG  LEU A   3      42.847  38.982  93.918  1.00 41.27           C  
ATOM     31  N   THR A   4      42.747  34.639  95.808  1.00 27.93           N  
ATOM     32  CA  THR A   4      43.423  33.425  96.244  1.00 26.87           C  
ATOM     33  C   THR A   4      43.152  32.326  95.234  1.00 21.32           C  
ATOM     34  O   THR A   4      44.043  31.586  94.863  1.00 24.24           O  
ATOM     35  CB  THR A   4      42.916  33.009  97.646  1.00 27.60           C  
ATOM     36  OG1 THR A   4      43.393  33.973  98.587  1.00 30.14           O  
ATOM     37  CG2 THR A   4      43.395  31.636  98.047  1.00 27.18           C  
ATOM     38  N   GLU A   5      41.899  32.242  94.812  1.00 22.48           N  
ATOM     39  CA  GLU A   5      41.486  31.269  93.849  1.00 23.09           C  
ATOM     40  C   GLU A   5      42.153  31.511  92.491  1.00 24.18           C  
ATOM     41  O   GLU A   5      42.607  30.563  91.850  1.00 21.56           O  
ATOM     42  CB  GLU A   5      39.989  31.284  93.745  1.00 25.89           C  
ATOM     43  CG  GLU A   5      39.382  30.607  94.990  1.00 27.02           C  
ATOM     44  CD  GLU A   5      37.890  30.773  95.074  1.00 33.44           C  
ATOM     45  OE1 GLU A   5      37.362  31.772  94.540  1.00 30.08           O  
ATOM     46  OE2 GLU A   5      37.237  29.892  95.684  1.00 32.48           O  
ATOM     47  N   LEU A   6      42.221  32.773  92.077  1.00 26.13           N  
ATOM     48  CA  LEU A   6      42.934  33.100  90.822  1.00 25.37           C  
ATOM     49  C   LEU A   6      44.418  32.736  90.924  1.00 23.72           C  
ATOM     50  O   LEU A   6      45.003  32.206  89.975  1.00 21.41           O  
ATOM     51  CB  LEU A   6      42.714  34.578  90.428  1.00 27.74           C  
ATOM     52  CG  LEU A   6      41.305  34.948  89.955  1.00 27.97           C  
ATOM     53  CD1 LEU A   6      41.188  36.428  89.802  1.00 32.33           C  
ATOM     54  CD2 LEU A   6      40.932  34.250  88.636  1.00 29.41           C  
HETATM   55  N   MSE A   7      45.015  32.976  92.093  0.50 22.27           N  
HETATM   57  CA  MSE A   7      46.425  32.662  92.301  0.50 23.27           C  
HETATM   59  C   MSE A   7      46.708  31.152  92.309  0.50 24.05           C  
HETATM   61  O   MSE A   7      47.829  30.725  92.026  0.50 24.08           O  
HETATM   63  CB  MSE A   7      46.975  33.399  93.533  0.50 25.87           C  
HETATM   65  CG  MSE A   7      47.155  34.901  93.255  0.50 20.60           C  
HETATM   67 SE   MSE A   7      47.834  36.087  94.688  0.37 30.67          SE  
HETATM   69  CE  MSE A   7      49.093  34.856  95.550  0.50 24.97           C  
ATOM     71  N   GLU A   8      45.693  30.352  92.635  1.00 23.87           N  
ATOM     72  CA  GLU A   8      45.781  28.907  92.537  1.00 27.29           C  
ATOM     73  C   GLU A   8      45.775  28.416  91.092  1.00 25.64           C  
ATOM     74  O   GLU A   8      46.285  27.311  90.801  1.00 27.16           O  
ATOM     75  CB  GLU A   8      44.592  28.259  93.265  1.00 28.61           C  
ATOM     76  CG  GLU A   8      44.687  28.333  94.763  1.00 31.66           C  
ATOM     77  CD  GLU A   8      43.385  27.900  95.454  1.00 33.51           C  
ATOM     78  OE1 GLU A   8      42.344  27.687  94.764  1.00 31.56           O  
ATOM     79  OE2 GLU A   8      43.411  27.780  96.694  1.00 45.55           O  
ATOM     80  N   ARG A   9      45.139  29.184  90.196  1.00 25.74           N  
ATOM     81  CA  ARG A   9      45.013  28.813  88.777  1.00 24.30           C  
ATOM     82  C   ARG A   9      45.943  29.481  87.813  1.00 25.78           C  
ATOM     83  O   ARG A   9      46.200  28.953  86.743  1.00 27.43           O  
ATOM     84  CB  ARG A   9      43.602  29.106  88.281  1.00 27.93           C  
ATOM     85  CG  ARG A   9      42.589  28.104  88.751  1.00 27.65           C  
ATOM     86  CD  ARG A   9      41.174  28.417  88.391  1.00 24.50           C  
ATOM     87  NE  ARG A   9      40.774  28.070  87.026  1.00 21.34           N  
ATOM     88  CZ  ARG A   9      39.519  27.965  86.630  1.00 26.95           C  
ATOM     89  NH1 ARG A   9      38.519  28.168  87.477  1.00 32.80           N  
ATOM     90  NH2 ARG A   9      39.258  27.683  85.354  1.00 35.91           N  
ATOM     91  N   ILE A  10      46.464  30.646  88.169  1.00 22.37           N  
ATOM     92  CA  ILE A  10      47.238  31.438  87.190  1.00 22.66           C  
ATOM     93  C   ILE A  10      48.663  31.654  87.623  1.00 23.30           C  
ATOM     94  O   ILE A  10      48.893  32.329  88.629  1.00 20.08           O  
ATOM     95  CB  ILE A  10      46.511  32.780  86.968  1.00 21.92           C  
ATOM     96  CG1 ILE A  10      45.082  32.507  86.538  1.00 27.16           C  
ATOM     97  CG2 ILE A  10      47.290  33.630  85.939  1.00 24.54           C  
ATOM     98  CD1 ILE A  10      44.227  33.636  86.634  1.00 31.12           C  
ATOM     99  N   PRO A  11      49.648  31.118  86.851  1.00 22.04           N  
ATOM    100  CA  PRO A  11      51.024  31.325  87.226  1.00 23.69           C  
ATOM    101  C   PRO A  11      51.406  32.767  87.312  1.00 22.41           C  
ATOM    102  O   PRO A  11      50.978  33.580  86.482  1.00 21.58           O  
ATOM    103  CB  PRO A  11      51.820  30.694  86.074  1.00 28.65           C  
ATOM    104  CG  PRO A  11      50.926  29.795  85.450  1.00 23.50           C  
ATOM    105  CD  PRO A  11      49.561  30.308  85.614  1.00 24.87           C  
ATOM    106  N   HIS A  12      52.217  33.071  88.298  1.00 21.48           N  
ATOM    107  CA  HIS A  12      52.807  34.381  88.484  1.00 21.94           C  
ATOM    108  C   HIS A  12      51.836  35.487  88.717  1.00 18.95           C  
ATOM    109  O   HIS A  12      52.222  36.649  88.650  1.00 21.52           O  
ATOM    110  CB  HIS A  12      53.720  34.731  87.307  1.00 21.31           C  
ATOM    111  CG  HIS A  12      54.817  33.754  87.113  1.00 27.15           C  
ATOM    112  ND1 HIS A  12      55.945  33.755  87.899  1.00 28.25           N  
ATOM    113  CD2 HIS A  12      54.921  32.684  86.292  1.00 24.73           C  
ATOM    114  CE1 HIS A  12      56.724  32.756  87.524  1.00 34.08           C  
ATOM    115  NE2 HIS A  12      56.131  32.100  86.544  1.00 23.19           N  
ATOM    116  N   LEU A  13      50.616  35.154  89.105  1.00 20.13           N  
ATOM    117  CA  LEU A  13      49.622  36.180  89.267  1.00 18.02           C  
ATOM    118  C   LEU A  13      49.978  37.220  90.312  1.00 18.16           C  
ATOM    119  O   LEU A  13      49.753  38.396  90.129  1.00 18.85           O  
ATOM    120  CB  LEU A  13      48.247  35.577  89.540  1.00 18.45           C  
ATOM    121  CG  LEU A  13      47.104  36.593  89.585  1.00 24.88           C  
ATOM    122  CD1 LEU A  13      46.999  37.298  88.282  1.00 29.02           C  
ATOM    123  CD2 LEU A  13      45.780  35.925  89.895  1.00 26.39           C  
ATOM    124  N   ARG A  14      50.476  36.763  91.462  1.00 18.68           N  
ATOM    125  CA  ARG A  14      50.840  37.675  92.518  1.00 20.11           C  
ATOM    126  C   ARG A  14      51.864  38.714  92.065  1.00 16.13           C  
ATOM    127  O   ARG A  14      51.711  39.911  92.391  1.00 19.15           O  
ATOM    128  CB  ARG A  14      51.432  36.856  93.700  1.00 23.35           C  
ATOM    129  CG  ARG A  14      51.775  37.683  94.933  1.00 27.56           C  
ATOM    130  CD  ARG A  14      52.226  36.811  96.135  1.00 31.13           C  
ATOM    131  N   GLU A  15      52.904  38.242  91.377  1.00 19.75           N  
ATOM    132  CA  GLU A  15      53.982  39.138  90.882  1.00 17.35           C  
ATOM    133  C   GLU A  15      53.435  40.132  89.831  1.00 17.89           C  
ATOM    134  O   GLU A  15      53.686  41.346  89.927  1.00 18.55           O  
ATOM    135  CB  GLU A  15      55.167  38.369  90.333  1.00 21.02           C  
ATOM    136  N   ILE A  16      52.589  39.626  88.958  1.00 18.07           N  
ATOM    137  CA  ILE A  16      51.964  40.518  87.958  1.00 16.99           C  
ATOM    138  C   ILE A  16      51.105  41.560  88.634  1.00 18.55           C  
ATOM    139  O   ILE A  16      51.195  42.728  88.316  1.00 16.82           O  
ATOM    140  CB  ILE A  16      51.185  39.726  86.919  1.00 17.15           C  
ATOM    141  CG1 ILE A  16      52.141  38.827  86.148  1.00 16.17           C  
ATOM    142  CG2 ILE A  16      50.480  40.712  85.951  1.00 20.18           C  
ATOM    143  CD1 ILE A  16      51.438  37.802  85.258  1.00 19.50           C  
ATOM    144  N   LEU A  17      50.261  41.161  89.598  0.50 16.71           N  
ATOM    146  CA  LEU A  17      49.446  42.120  90.336  0.50 15.99           C  
ATOM    148  C   LEU A  17      50.373  43.134  90.992  0.50 16.53           C  
ATOM    150  O   LEU A  17      50.138  44.338  90.968  0.50 16.76           O  
ATOM    152  CB  LEU A  17      48.607  41.444  91.448  0.50 16.50           C  
ATOM    154  CG  LEU A  17      47.401  40.595  91.042  0.50 15.79           C  
ATOM    156  CD1 LEU A  17      47.024  39.640  92.158  0.50 19.35           C  
ATOM    158  CD2 LEU A  17      46.217  41.435  90.664  0.50 18.81           C  
ATOM    160  N   ASN A  18      51.441  42.640  91.590  0.50 15.71           N  
ATOM    162  CA  ASN A  18      52.372  43.536  92.270  0.50 15.59           C  
ATOM    164  C   ASN A  18      52.900  44.648  91.320  0.50 14.35           C  
ATOM    166  O   ASN A  18      52.876  45.829  91.641  0.50 15.98           O  
ATOM    168  CB  ASN A  18      53.517  42.735  92.933  0.50 16.00           C  
ATOM    170  CG  ASN A  18      54.368  43.598  93.838  0.50 18.67           C  
ATOM    172  OD1 ASN A  18      55.598  43.626  93.714  0.50 23.11           O  
ATOM    174  ND2 ASN A  18      53.722  44.290  94.770  0.50 23.35           N  
ATOM    176  N   ILE A  19      53.330  44.216  90.139  1.00 15.96           N  
ATOM    177  CA  ILE A  19      53.901  45.087  89.068  1.00 14.95           C  
ATOM    178  C   ILE A  19      52.851  46.119  88.621  1.00 17.01           C  
ATOM    179  O   ILE A  19      53.151  47.305  88.514  1.00 16.51           O  
ATOM    180  CB  ILE A  19      54.451  44.240  87.926  1.00 15.45           C  
ATOM    181  CG1 ILE A  19      55.747  43.522  88.327  1.00 15.32           C  
ATOM    182  CG2 ILE A  19      54.714  45.096  86.685  1.00 17.50           C  
ATOM    183  CD1 ILE A  19      56.125  42.382  87.390  1.00 17.65           C  
ATOM    184  N   VAL A  20      51.608  45.678  88.460  1.00 16.26           N  
ATOM    185  CA  VAL A  20      50.537  46.563  88.116  1.00 17.81           C  
ATOM    186  C   VAL A  20      50.316  47.608  89.204  1.00 17.37           C  
ATOM    187  O   VAL A  20      50.231  48.795  88.950  1.00 16.67           O  
ATOM    188  CB  VAL A  20      49.235  45.783  87.742  1.00 18.94           C  
ATOM    189  CG1 VAL A  20      48.110  46.739  87.569  1.00 21.56           C  
ATOM    190  CG2 VAL A  20      49.453  44.898  86.498  1.00 21.14           C  
ATOM    191  N   ARG A  21      50.297  47.188  90.469  1.00 16.48           N  
ATOM    192  CA  ARG A  21      50.145  48.153  91.555  1.00 18.26           C  
ATOM    193  C   ARG A  21      51.253  49.212  91.535  1.00 17.32           C  
ATOM    194  O   ARG A  21      50.994  50.402  91.706  1.00 18.68           O  
ATOM    195  CB  ARG A  21      50.120  47.426  92.915  1.00 20.91           C  
ATOM    196  CG  ARG A  21      48.854  46.597  93.087  1.00 26.55           C  
ATOM    197  CD  ARG A  21      48.796  45.815  94.413  1.00 31.64           C  
ATOM    198  NE  ARG A  21      48.733  46.707  95.560  1.00 46.28           N  
ATOM    199  N   GLU A  22      52.474  48.750  91.339  1.00 16.56           N  
ATOM    200  CA  GLU A  22      53.635  49.623  91.254  1.00 18.05           C  
ATOM    201  C   GLU A  22      53.524  50.589  90.069  1.00 18.21           C  
ATOM    202  O   GLU A  22      53.853  51.766  90.197  1.00 17.94           O  
ATOM    203  CB  GLU A  22      54.904  48.783  91.170  1.00 15.33           C  
ATOM    204  CG  GLU A  22      55.239  48.096  92.490  1.00 18.26           C  
ATOM    205  CD  GLU A  22      56.244  46.974  92.394  1.00 25.83           C  
ATOM    206  OE1 GLU A  22      56.568  46.450  91.299  1.00 24.97           O  
ATOM    207  OE2 GLU A  22      56.707  46.591  93.502  1.00 25.20           O  
ATOM    208  N   ALA A  23      53.055  50.095  88.921  1.00 14.59           N  
ATOM    209  CA  ALA A  23      52.889  50.986  87.753  1.00 15.76           C  
ATOM    210  C   ALA A  23      51.934  52.125  87.990  1.00 15.27           C  
ATOM    211  O   ALA A  23      52.074  53.233  87.433  1.00 16.98           O  
ATOM    212  CB  ALA A  23      52.429  50.160  86.553  1.00 15.77           C  
ATOM    213  N   PHE A  24      50.885  51.835  88.759  1.00 15.80           N  
ATOM    214  CA  PHE A  24      49.832  52.801  89.042  1.00 16.93           C  
ATOM    215  C   PHE A  24      50.061  53.676  90.278  1.00 19.08           C  
ATOM    216  O   PHE A  24      49.252  54.555  90.552  1.00 21.30           O  
ATOM    217  CB  PHE A  24      48.452  52.124  89.144  1.00 16.87           C  
ATOM    218  CG  PHE A  24      47.841  51.812  87.814  1.00 16.17           C  
ATOM    219  CD1 PHE A  24      48.100  50.618  87.162  1.00 18.52           C  
ATOM    220  CD2 PHE A  24      47.023  52.739  87.216  1.00 19.87           C  
ATOM    221  CE1 PHE A  24      47.497  50.320  85.929  1.00 16.42           C  
ATOM    222  CE2 PHE A  24      46.461  52.503  85.952  1.00 17.67           C  
ATOM    223  CZ  PHE A  24      46.724  51.281  85.301  1.00 17.76           C  
ATOM    224  N   LYS A  25      51.158  53.451  90.985  1.00 21.39           N  
ATOM    225  CA  LYS A  25      51.459  54.170  92.225  1.00 26.98           C  
ATOM    226  C   LYS A  25      51.475  55.635  91.872  1.00 29.69           C  
ATOM    227  O   LYS A  25      52.190  56.023  90.968  1.00 30.15           O  
ATOM    228  CB  LYS A  25      52.809  53.698  92.769  1.00 29.57           C  
ATOM    229  CG  LYS A  25      53.182  54.289  94.112  1.00 39.68           C  
ATOM    230  CD  LYS A  25      54.232  53.428  94.835  1.00 47.05           C  
ATOM    231  N   ASP A  26      50.667  56.443  92.534  1.00 32.61           N  
ATOM    232  CA  ASP A  26      50.613  57.891  92.187  1.00 37.29           C  
ATOM    233  C   ASP A  26      50.001  58.273  90.807  1.00 38.32           C  
ATOM    234  O   ASP A  26      50.322  59.321  90.246  1.00 43.00           O  
ATOM    235  CB  ASP A  26      52.002  58.550  92.329  1.00 38.13           C  
ATOM    236  N   TYR A  27      49.167  57.412  90.244  1.00 34.39           N  
ATOM    237  CA  TYR A  27      48.382  57.765  89.074  1.00 30.49           C  
ATOM    238  C   TYR A  27      46.946  57.613  89.580  1.00 34.00           C  
ATOM    239  O   TYR A  27      46.428  56.495  89.693  1.00 37.55           O  
ATOM    240  CB  TYR A  27      48.635  56.822  87.913  1.00 29.16           C  
ATOM    241  CG  TYR A  27      47.788  57.151  86.711  1.00 21.32           C  
ATOM    242  CD1 TYR A  27      47.930  58.343  86.045  1.00 28.41           C  
ATOM    243  CD2 TYR A  27      46.845  56.254  86.237  1.00 26.12           C  
ATOM    244  CE1 TYR A  27      47.161  58.638  84.937  1.00 25.37           C  
ATOM    245  CE2 TYR A  27      46.092  56.534  85.116  1.00 25.19           C  
ATOM    246  CZ  TYR A  27      46.255  57.722  84.473  1.00 28.48           C  
ATOM    247  OH  TYR A  27      45.499  58.001  83.386  1.00 28.04           O  
ATOM    248  N   ASP A  28      46.311  58.737  89.887  1.00 36.91           N  
ATOM    249  CA  ASP A  28      44.989  58.719  90.542  1.00 39.03           C  
ATOM    250  C   ASP A  28      43.816  59.232  89.717  1.00 41.30           C  
ATOM    251  O   ASP A  28      42.761  59.533  90.297  1.00 44.11           O  
ATOM    252  CB  ASP A  28      45.057  59.532  91.857  1.00 39.29           C  
ATOM    253  N   ASP A  29      43.981  59.360  88.402  1.00 40.18           N  
ATOM    254  CA  ASP A  29      42.885  59.794  87.555  1.00 40.53           C  
ATOM    255  C   ASP A  29      41.746  58.789  87.761  1.00 41.92           C  
ATOM    256  O   ASP A  29      41.892  57.613  87.419  1.00 38.83           O  
ATOM    257  CB  ASP A  29      43.321  59.852  86.093  1.00 39.54           C  
ATOM    258  CG  ASP A  29      42.243  60.367  85.180  1.00 39.88           C  
ATOM    259  OD1 ASP A  29      41.042  60.257  85.508  1.00 48.90           O  
ATOM    260  OD2 ASP A  29      42.595  60.861  84.095  1.00 39.44           O  
ATOM    261  N   PRO A  30      40.595  59.255  88.309  1.00 43.65           N  
ATOM    262  CA  PRO A  30      39.480  58.353  88.618  1.00 44.22           C  
ATOM    263  C   PRO A  30      38.890  57.664  87.394  1.00 43.18           C  
ATOM    264  O   PRO A  30      38.224  56.636  87.534  1.00 44.20           O  
ATOM    265  CB  PRO A  30      38.445  59.285  89.256  1.00 45.11           C  
ATOM    266  CG  PRO A  30      38.752  60.615  88.687  1.00 45.92           C  
ATOM    267  CD  PRO A  30      40.244  60.652  88.635  1.00 45.68           C  
ATOM    268  N   ALA A  31      39.131  58.239  86.220  1.00 40.34           N  
ATOM    269  CA  ALA A  31      38.683  57.647  84.978  1.00 38.86           C  
ATOM    270  C   ALA A  31      39.598  56.488  84.505  1.00 38.55           C  
ATOM    271  O   ALA A  31      39.210  55.685  83.641  1.00 39.76           O  
ATOM    272  CB  ALA A  31      38.629  58.730  83.908  1.00 40.02           C  
ATOM    273  N   HIS A  32      40.802  56.385  85.065  1.00 34.02           N  
ATOM    274  CA  HIS A  32      41.763  55.418  84.569  1.00 30.76           C  
ATOM    275  C   HIS A  32      42.632  54.799  85.640  1.00 29.89           C  
ATOM    276  O   HIS A  32      43.685  54.267  85.308  1.00 28.37           O  
ATOM    277  CB  HIS A  32      42.709  56.121  83.593  1.00 29.98           C  
ATOM    278  CG  HIS A  32      42.020  56.811  82.474  1.00 33.20           C  
ATOM    279  ND1 HIS A  32      41.472  56.126  81.412  1.00 35.32           N  
ATOM    280  CD2 HIS A  32      41.795  58.123  82.235  1.00 34.74           C  
ATOM    281  CE1 HIS A  32      40.932  56.988  80.568  1.00 37.69           C  
ATOM    282  NE2 HIS A  32      41.109  58.207  81.048  1.00 39.34           N  
ATOM    283  N   ASP A  33      42.220  54.863  86.899  1.00 28.29           N  
ATOM    284  CA  ASP A  33      43.063  54.378  87.976  1.00 26.79           C  
ATOM    285  C   ASP A  33      43.093  52.858  88.055  1.00 23.97           C  
ATOM    286  O   ASP A  33      42.397  52.158  87.319  1.00 25.87           O  
ATOM    287  CB  ASP A  33      42.667  55.030  89.309  1.00 29.26           C  
ATOM    288  CG  ASP A  33      41.284  54.621  89.790  1.00 33.05           C  
ATOM    289  OD1 ASP A  33      40.730  53.601  89.338  1.00 38.11           O  
ATOM    290  OD2 ASP A  33      40.741  55.360  90.625  1.00 42.28           O  
ATOM    291  N   ILE A  34      43.885  52.347  88.979  1.00 22.40           N  
ATOM    292  CA  ILE A  34      44.052  50.932  89.113  1.00 18.13           C  
ATOM    293  C   ILE A  34      42.778  50.137  89.379  1.00 19.08           C  
ATOM    294  O   ILE A  34      42.654  48.971  88.968  1.00 19.05           O  
ATOM    295  CB  ILE A  34      45.107  50.587  90.170  1.00 20.55           C  
ATOM    296  CG1 ILE A  34      45.559  49.151  89.989  1.00 23.24           C  
ATOM    297  CG2 ILE A  34      44.603  50.890  91.563  1.00 22.69           C  
ATOM    298  CD1 ILE A  34      46.690  48.765  90.825  1.00 26.52           C  
ATOM    299  N   SER A  35      41.799  50.758  90.021  1.00 20.36           N  
ATOM    300  CA  SER A  35      40.593  49.993  90.341  1.00 18.93           C  
ATOM    301  C   SER A  35      39.871  49.583  89.054  1.00 17.33           C  
ATOM    302  O   SER A  35      39.248  48.532  89.037  1.00 17.65           O  
ATOM    303  CB  SER A  35      39.685  50.772  91.299  1.00 20.52           C  
ATOM    304  OG  SER A  35      39.150  51.898  90.691  1.00 23.09           O  
ATOM    305  N   HIS A  36      39.948  50.406  88.009  1.00 17.40           N  
ATOM    306  CA  HIS A  36      39.436  50.014  86.698  1.00 17.55           C  
ATOM    307  C   HIS A  36      40.046  48.652  86.245  1.00 16.26           C  
ATOM    308  O   HIS A  36      39.339  47.714  85.856  1.00 15.98           O  
ATOM    309  CB  HIS A  36      39.653  51.097  85.663  1.00 16.38           C  
ATOM    310  CG  HIS A  36      39.541  50.620  84.257  1.00 16.86           C  
ATOM    311  ND1 HIS A  36      38.332  50.341  83.645  1.00 17.89           N  
ATOM    312  CD2 HIS A  36      40.506  50.288  83.363  1.00 19.19           C  
ATOM    313  CE1 HIS A  36      38.562  49.946  82.403  1.00 18.82           C  
ATOM    314  NE2 HIS A  36      39.874  49.905  82.208  1.00 18.24           N  
ATOM    315  N   THR A  37      41.361  48.540  86.317  1.00 15.19           N  
ATOM    316  CA  THR A  37      42.037  47.294  85.923  1.00 13.64           C  
ATOM    317  C   THR A  37      41.532  46.097  86.702  1.00 14.20           C  
ATOM    318  O   THR A  37      41.264  45.035  86.159  1.00 14.95           O  
ATOM    319  CB  THR A  37      43.571  47.451  86.062  1.00 13.65           C  
ATOM    320  OG1 THR A  37      44.011  48.314  84.995  1.00 15.93           O  
ATOM    321  CG2 THR A  37      44.218  46.188  85.895  1.00 13.42           C  
ATOM    322  N   PHE A  38      41.334  46.276  88.006  1.00 16.26           N  
ATOM    323  CA  PHE A  38      40.831  45.156  88.773  1.00 17.39           C  
ATOM    324  C   PHE A  38      39.402  44.804  88.390  1.00 14.97           C  
ATOM    325  O   PHE A  38      39.074  43.635  88.285  1.00 18.78           O  
ATOM    326  CB  PHE A  38      40.913  45.454  90.260  1.00 19.45           C  
ATOM    327  CG  PHE A  38      42.306  45.677  90.751  1.00 27.73           C  
ATOM    328  CD1 PHE A  38      43.355  44.907  90.277  1.00 32.65           C  
ATOM    329  CD2 PHE A  38      42.566  46.640  91.708  1.00 33.43           C  
ATOM    330  CE1 PHE A  38      44.648  45.105  90.726  1.00 35.54           C  
ATOM    331  CE2 PHE A  38      43.853  46.830  92.186  1.00 34.89           C  
ATOM    332  CZ  PHE A  38      44.900  46.052  91.690  1.00 35.27           C  
ATOM    333  N   ARG A  39      38.569  45.802  88.104  1.00 16.05           N  
ATOM    334  CA  ARG A  39      37.191  45.502  87.683  1.00 16.84           C  
ATOM    335  C   ARG A  39      37.172  44.807  86.316  1.00 15.76           C  
ATOM    336  O   ARG A  39      36.352  43.928  86.052  1.00 15.74           O  
ATOM    337  CB  ARG A  39      36.348  46.777  87.693  1.00 16.15           C  
ATOM    338  CG  ARG A  39      36.160  47.319  89.122  1.00 19.50           C  
ATOM    339  CD  ARG A  39      35.119  48.377  89.181  1.00 19.48           C  
ATOM    340  NE  ARG A  39      35.402  49.489  88.288  1.00 19.29           N  
ATOM    341  CZ  ARG A  39      36.135  50.573  88.583  1.00 17.83           C  
ATOM    342  NH1 ARG A  39      36.663  50.775  89.768  1.00 23.42           N  
ATOM    343  NH2 ARG A  39      36.349  51.457  87.650  1.00 18.78           N  
ATOM    344  N   VAL A  40      38.066  45.242  85.423  1.00 14.57           N  
ATOM    345  CA  VAL A  40      38.183  44.603  84.087  1.00 16.68           C  
ATOM    346  C   VAL A  40      38.625  43.145  84.245  1.00 14.76           C  
ATOM    347  O   VAL A  40      38.118  42.234  83.581  1.00 14.01           O  
ATOM    348  CB  VAL A  40      39.101  45.417  83.152  1.00 16.34           C  
ATOM    349  CG1 VAL A  40      39.308  44.660  81.789  1.00 15.26           C  
ATOM    350  CG2 VAL A  40      38.466  46.749  82.867  1.00 15.39           C  
HETATM  351  N   MSE A  41      39.577  42.887  85.123  0.50 16.83           N  
HETATM  353  CA  MSE A  41      39.969  41.532  85.314  0.50 19.17           C  
HETATM  355  C   MSE A  41      38.819  40.685  85.906  0.50 17.16           C  
HETATM  357  O   MSE A  41      38.642  39.539  85.505  0.50 18.68           O  
HETATM  359  CB  MSE A  41      41.245  41.452  86.098  0.50 22.27           C  
HETATM  361  CG  MSE A  41      41.671  40.036  86.246  0.50 23.37           C  
HETATM  363 SE   MSE A  41      41.008  39.387  87.909  0.37 40.64          SE  
HETATM  365  CE  MSE A  41      42.208  40.141  88.716  0.50  2.00           C  
ATOM    367  N   GLU A  42      38.021  41.255  86.805  1.00 16.94           N  
ATOM    368  CA  GLU A  42      36.851  40.526  87.330  1.00 19.88           C  
ATOM    369  C   GLU A  42      35.888  40.206  86.197  1.00 17.43           C  
ATOM    370  O   GLU A  42      35.392  39.069  86.107  1.00 20.58           O  
ATOM    371  CB  GLU A  42      36.138  41.335  88.424  1.00 23.27           C  
ATOM    372  CG  GLU A  42      36.979  41.492  89.675  1.00 35.69           C  
ATOM    373  CD  GLU A  42      37.273  40.171  90.377  1.00 47.38           C  
ATOM    374  OE1 GLU A  42      36.497  39.204  90.184  1.00 53.85           O  
ATOM    375  OE2 GLU A  42      38.273  40.114  91.135  1.00 46.64           O  
ATOM    376  N   ASN A  43      35.623  41.166  85.314  1.00 17.12           N  
ATOM    377  CA  ASN A  43      34.746  40.946  84.164  1.00 15.08           C  
ATOM    378  C   ASN A  43      35.328  39.881  83.238  1.00 17.48           C  
ATOM    379  O   ASN A  43      34.624  38.993  82.758  1.00 16.59           O  
ATOM    380  CB  ASN A  43      34.583  42.209  83.372  1.00 15.92           C  
ATOM    381  CG  ASN A  43      33.905  43.318  84.123  1.00 21.16           C  
ATOM    382  OD1 ASN A  43      33.219  43.086  85.123  1.00 19.82           O  
ATOM    383  ND2 ASN A  43      34.072  44.525  83.634  1.00 16.90           N  
ATOM    384  N   ALA A  44      36.633  39.949  82.991  1.00 16.05           N  
ATOM    385  CA  ALA A  44      37.283  38.959  82.120  1.00 14.97           C  
ATOM    386  C   ALA A  44      37.221  37.557  82.696  1.00 15.11           C  
ATOM    387  O   ALA A  44      37.072  36.584  81.939  1.00 14.67           O  
ATOM    388  CB  ALA A  44      38.740  39.338  81.866  1.00 14.55           C  
ATOM    389  N   SER A  45      37.318  37.463  84.025  1.00 17.90           N  
ATOM    390  CA  SER A  45      37.259  36.181  84.724  1.00 20.89           C  
ATOM    391  C   SER A  45      35.876  35.532  84.510  1.00 19.73           C  
ATOM    392  O   SER A  45      35.764  34.341  84.180  1.00 20.73           O  
ATOM    393  CB  SER A  45      37.486  36.402  86.210  1.00 22.24           C  
ATOM    394  OG  SER A  45      37.419  35.187  86.894  1.00 28.26           O  
ATOM    395  N   GLU A  46      34.838  36.331  84.675  0.50 19.98           N  
ATOM    397  CA  GLU A  46      33.456  35.859  84.469  0.50 20.96           C  
ATOM    399  C   GLU A  46      33.254  35.399  83.016  0.50 20.56           C  
ATOM    401  O   GLU A  46      32.800  34.257  82.713  0.50 15.41           O  
ATOM    403  CB  GLU A  46      32.472  36.994  84.764  0.50 20.23           C  
ATOM    405  CG  GLU A  46      32.612  37.705  86.113  0.50 23.22           C  
ATOM    407  N   ILE A  47      33.667  36.261  82.095  1.00 17.80           N  
ATOM    408  CA  ILE A  47      33.433  36.006  80.694  1.00 15.52           C  
ATOM    409  C   ILE A  47      34.180  34.726  80.243  1.00 16.29           C  
ATOM    410  O   ILE A  47      33.581  33.810  79.640  1.00 17.66           O  
ATOM    411  CB  ILE A  47      33.843  37.202  79.845  1.00 15.62           C  
ATOM    412  CG1 ILE A  47      32.928  38.397  80.148  1.00 15.52           C  
ATOM    413  CG2 ILE A  47      33.807  36.846  78.367  1.00 18.72           C  
ATOM    414  CD1 ILE A  47      33.501  39.705  79.638  1.00 18.60           C  
ATOM    415  N   ALA A  48      35.488  34.659  80.501  1.00 17.75           N  
ATOM    416  CA  ALA A  48      36.297  33.514  80.071  1.00 18.18           C  
ATOM    417  C   ALA A  48      35.802  32.185  80.680  1.00 21.61           C  
ATOM    418  O   ALA A  48      35.729  31.152  80.007  1.00 21.38           O  
ATOM    419  CB  ALA A  48      37.755  33.766  80.399  1.00 17.38           C  
ATOM    420  N   SER A  49      35.445  32.221  81.944  1.00 19.35           N  
ATOM    421  CA  SER A  49      34.887  31.042  82.584  1.00 22.59           C  
ATOM    422  C   SER A  49      33.607  30.590  81.907  1.00 20.50           C  
ATOM    423  O   SER A  49      33.449  29.434  81.517  1.00 22.69           O  
ATOM    424  CB  SER A  49      34.603  31.338  84.047  1.00 22.57           C  
ATOM    425  OG  SER A  49      35.800  31.442  84.748  1.00 33.73           O  
ATOM    426  N   ARG A  50      32.681  31.496  81.711  1.00 18.11           N  
ATOM    427  CA  ARG A  50      31.396  31.097  81.122  1.00 21.35           C  
ATOM    428  C   ARG A  50      31.477  30.753  79.627  1.00 21.56           C  
ATOM    429  O   ARG A  50      30.720  29.932  79.132  1.00 23.11           O  
ATOM    430  CB  ARG A  50      30.348  32.172  81.356  1.00 20.53           C  
ATOM    431  CG  ARG A  50      29.985  32.263  82.824  1.00 24.95           C  
ATOM    432  CD  ARG A  50      28.982  33.335  83.123  1.00 31.15           C  
ATOM    433  NE  ARG A  50      28.754  33.434  84.567  1.00 38.97           N  
ATOM    434  N   GLU A  51      32.411  31.363  78.916  1.00 19.21           N  
ATOM    435  CA  GLU A  51      32.618  31.095  77.490  1.00 19.45           C  
ATOM    436  C   GLU A  51      33.487  29.859  77.236  1.00 21.99           C  
ATOM    437  O   GLU A  51      33.678  29.456  76.103  1.00 21.26           O  
ATOM    438  CB  GLU A  51      33.291  32.319  76.862  1.00 20.02           C  
ATOM    439  CG  GLU A  51      32.398  33.542  76.866  1.00 20.60           C  
ATOM    440  CD  GLU A  51      31.256  33.487  75.886  1.00 19.22           C  
ATOM    441  OE1 GLU A  51      31.401  32.959  74.777  1.00 22.76           O  
ATOM    442  OE2 GLU A  51      30.173  34.057  76.171  1.00 17.43           O  
ATOM    443  N   LYS A  52      34.029  29.284  78.298  1.00 22.05           N  
ATOM    444  CA  LYS A  52      34.871  28.091  78.204  1.00 25.80           C  
ATOM    445  C   LYS A  52      36.126  28.431  77.374  1.00 25.16           C  
ATOM    446  O   LYS A  52      36.598  27.635  76.565  1.00 26.03           O  
ATOM    447  CB  LYS A  52      34.096  26.886  77.612  1.00 27.63           C  
ATOM    448  CG  LYS A  52      32.676  26.663  78.161  1.00 33.18           C  
ATOM    449  CD  LYS A  52      32.676  26.205  79.602  1.00 39.89           C  
ATOM    450  CE  LYS A  52      31.264  25.742  80.015  1.00 45.17           C  
ATOM    451  NZ  LYS A  52      31.259  25.137  81.389  1.00 48.72           N  
ATOM    452  N   CYS A  53      36.664  29.631  77.589  1.00 21.99           N  
ATOM    453  CA  CYS A  53      37.862  30.109  76.914  1.00 22.17           C  
ATOM    454  C   CYS A  53      39.046  30.061  77.864  1.00 22.17           C  
ATOM    455  O   CYS A  53      38.910  29.596  79.000  1.00 22.88           O  
ATOM    456  CB  CYS A  53      37.599  31.515  76.338  1.00 18.23           C  
ATOM    457  SG  CYS A  53      36.464  31.446  74.911  1.00 28.41           S  
ATOM    458  N   ASP A  54      40.214  30.491  77.412  1.00 20.80           N  
ATOM    459  CA  ASP A  54      41.438  30.445  78.185  1.00 18.70           C  
ATOM    460  C   ASP A  54      41.475  31.541  79.263  1.00 17.75           C  
ATOM    461  O   ASP A  54      41.756  32.708  78.999  1.00 17.32           O  
ATOM    462  CB  ASP A  54      42.605  30.570  77.206  1.00 20.07           C  
ATOM    463  CG  ASP A  54      43.942  30.267  77.826  1.00 24.21           C  
ATOM    464  OD1 ASP A  54      44.187  30.611  78.973  1.00 24.53           O  
ATOM    465  OD2 ASP A  54      44.780  29.705  77.089  1.00 29.22           O  
ATOM    466  N   LEU A  55      41.249  31.145  80.511  1.00 17.03           N  
ATOM    467  CA  LEU A  55      41.220  32.064  81.631  1.00 16.58           C  
ATOM    468  C   LEU A  55      42.566  32.750  81.884  1.00 14.88           C  
ATOM    469  O   LEU A  55      42.609  33.930  82.226  1.00 17.73           O  
ATOM    470  CB  LEU A  55      40.826  31.277  82.918  1.00 17.81           C  
ATOM    471  CG  LEU A  55      40.660  32.061  84.197  1.00 22.89           C  
ATOM    472  CD1 LEU A  55      39.462  33.016  84.057  1.00 28.71           C  
ATOM    473  CD2 LEU A  55      40.467  31.103  85.401  1.00 22.95           C  
ATOM    474  N   GLN A  56      43.663  31.987  81.768  1.00 13.27           N  
ATOM    475  CA  GLN A  56      44.988  32.513  82.022  1.00 16.75           C  
ATOM    476  C   GLN A  56      45.274  33.710  81.088  1.00 11.91           C  
ATOM    477  O   GLN A  56      45.732  34.746  81.548  1.00 14.86           O  
ATOM    478  CB  GLN A  56      46.073  31.440  81.892  1.00 17.51           C  
ATOM    479  CG  GLN A  56      45.907  30.298  82.917  1.00 20.66           C  
ATOM    480  CD  GLN A  56      47.082  29.358  82.971  1.00 27.35           C  
ATOM    481  OE1 GLN A  56      48.075  29.526  82.264  1.00 30.69           O  
ATOM    482  NE2 GLN A  56      46.994  28.364  83.865  1.00 27.22           N  
ATOM    483  N   LYS A  57      45.042  33.489  79.799  1.00 14.04           N  
ATOM    484  CA  LYS A  57      45.240  34.576  78.817  1.00 12.36           C  
ATOM    485  C   LYS A  57      44.343  35.797  79.113  1.00  9.99           C  
ATOM    486  O   LYS A  57      44.831  36.885  79.113  1.00 12.60           O  
ATOM    487  CB  LYS A  57      44.980  34.070  77.390  1.00 12.26           C  
ATOM    488  CG  LYS A  57      46.045  33.148  76.800  1.00 16.84           C  
ATOM    489  CD  LYS A  57      45.641  32.564  75.410  1.00 15.55           C  
ATOM    490  CE  LYS A  57      46.687  31.616  74.860  1.00 23.23           C  
ATOM    491  NZ  LYS A  57      46.221  30.913  73.647  1.00 31.08           N  
ATOM    492  N   ALA A  58      43.076  35.549  79.416  1.00 12.39           N  
ATOM    493  CA  ALA A  58      42.109  36.602  79.668  1.00 14.11           C  
ATOM    494  C   ALA A  58      42.451  37.452  80.877  1.00 12.10           C  
ATOM    495  O   ALA A  58      42.455  38.663  80.824  1.00 14.84           O  
ATOM    496  CB  ALA A  58      40.745  35.990  79.760  1.00 14.00           C  
ATOM    497  N   ILE A  59      42.801  36.780  81.981  0.50 13.36           N  
ATOM    499  CA  ILE A  59      43.165  37.456  83.202  0.50 13.76           C  
ATOM    501  C   ILE A  59      44.421  38.300  83.071  0.50 13.05           C  
ATOM    503  O   ILE A  59      44.448  39.449  83.511  0.50 12.78           O  
ATOM    505  CB  ILE A  59      43.402  36.416  84.330  0.50 13.80           C  
ATOM    507  CG1 ILE A  59      42.067  35.810  84.727  0.50 14.70           C  
ATOM    509  CG2 ILE A  59      44.104  37.008  85.535  0.50 10.53           C  
ATOM    511  CD1 ILE A  59      41.033  36.828  85.297  0.50 13.30           C  
ATOM    513  N   ILE A  60      45.455  37.682  82.502  1.00 14.02           N  
ATOM    514  CA  ILE A  60      46.736  38.357  82.327  1.00 10.45           C  
ATOM    515  C   ILE A  60      46.581  39.544  81.366  1.00 10.07           C  
ATOM    516  O   ILE A  60      47.086  40.628  81.659  1.00 12.80           O  
ATOM    517  CB  ILE A  60      47.859  37.380  81.974  1.00 12.31           C  
ATOM    518  CG1 ILE A  60      48.122  36.469  83.222  1.00 15.75           C  
ATOM    519  CG2 ILE A  60      49.116  38.098  81.577  1.00 13.73           C  
ATOM    520  CD1 ILE A  60      49.085  35.374  82.952  1.00 19.54           C  
ATOM    521  N   ALA A  61      45.829  39.329  80.297  1.00 12.51           N  
ATOM    522  CA  ALA A  61      45.640  40.440  79.392  1.00 12.27           C  
ATOM    523  C   ALA A  61      44.888  41.604  80.080  1.00 12.11           C  
ATOM    524  O   ALA A  61      45.227  42.762  79.926  1.00 12.91           O  
ATOM    525  CB  ALA A  61      44.868  39.957  78.275  1.00 10.81           C  
ATOM    526  N   ALA A  62      43.848  41.290  80.847  1.00 11.40           N  
ATOM    527  CA  ALA A  62      43.134  42.308  81.604  1.00 11.30           C  
ATOM    528  C   ALA A  62      44.024  43.037  82.599  1.00 14.76           C  
ATOM    529  O   ALA A  62      43.950  44.245  82.733  1.00 15.30           O  
ATOM    530  CB  ALA A  62      41.975  41.680  82.341  1.00 15.86           C  
ATOM    531  N   LEU A  63      44.837  42.281  83.334  1.00 14.23           N  
ATOM    532  CA  LEU A  63      45.744  42.925  84.310  1.00 14.19           C  
ATOM    533  C   LEU A  63      46.737  43.876  83.657  1.00 14.51           C  
ATOM    534  O   LEU A  63      47.051  44.936  84.183  1.00 14.05           O  
ATOM    535  CB  LEU A  63      46.468  41.873  85.151  1.00 16.55           C  
ATOM    536  CG  LEU A  63      45.754  41.437  86.406  1.00 27.30           C  
ATOM    537  CD1 LEU A  63      46.655  40.418  87.058  1.00 29.84           C  
ATOM    538  CD2 LEU A  63      45.563  42.700  87.315  1.00 25.93           C  
ATOM    539  N   LEU A  64      47.247  43.470  82.492  1.00 13.93           N  
ATOM    540  CA  LEU A  64      48.257  44.269  81.808  1.00 12.35           C  
ATOM    541  C   LEU A  64      47.740  45.298  80.805  1.00 12.22           C  
ATOM    542  O   LEU A  64      48.499  46.172  80.395  1.00 14.17           O  
ATOM    543  CB  LEU A  64      49.228  43.361  81.070  1.00 12.96           C  
ATOM    544  CG  LEU A  64      50.098  42.523  81.995  1.00 12.65           C  
ATOM    545  CD1 LEU A  64      50.906  41.530  81.162  1.00 18.76           C  
ATOM    546  CD2 LEU A  64      50.971  43.357  82.877  1.00 16.43           C  
ATOM    547  N   HIS A  65      46.451  45.268  80.511  1.00 11.59           N  
ATOM    548  CA  HIS A  65      46.000  46.028  79.313  1.00 11.20           C  
ATOM    549  C   HIS A  65      46.205  47.536  79.414  1.00 12.13           C  
ATOM    550  O   HIS A  65      46.510  48.157  78.434  1.00 13.73           O  
ATOM    551  CB  HIS A  65      44.569  45.697  78.923  1.00 13.21           C  
ATOM    552  CG  HIS A  65      43.527  46.454  79.674  1.00 14.51           C  
ATOM    553  ND1 HIS A  65      43.225  46.214  80.989  1.00 12.48           N  
ATOM    554  CD2 HIS A  65      42.697  47.447  79.271  1.00 13.89           C  
ATOM    555  CE1 HIS A  65      42.270  47.047  81.379  1.00 12.00           C  
ATOM    556  NE2 HIS A  65      41.932  47.815  80.346  1.00 13.76           N  
ATOM    557  N   ASP A  66      46.049  48.100  80.604  1.00 12.02           N  
ATOM    558  CA  ASP A  66      46.247  49.526  80.826  1.00 11.80           C  
ATOM    559  C   ASP A  66      47.505  49.842  81.667  1.00 12.65           C  
ATOM    560  O   ASP A  66      47.589  50.953  82.227  1.00 13.01           O  
ATOM    561  CB  ASP A  66      45.015  50.093  81.500  1.00 12.57           C  
ATOM    562  CG  ASP A  66      43.857  50.320  80.528  1.00 16.69           C  
ATOM    563  OD1 ASP A  66      44.010  50.432  79.278  1.00 13.67           O  
ATOM    564  OD2 ASP A  66      42.704  50.450  81.036  1.00 15.36           O  
ATOM    565  N   ILE A  67      48.478  48.912  81.704  1.00 14.10           N  
ATOM    566  CA  ILE A  67      49.643  49.113  82.551  1.00 15.93           C  
ATOM    567  C   ILE A  67      50.486  50.301  82.089  1.00 13.35           C  
ATOM    568  O   ILE A  67      51.151  50.929  82.902  1.00 12.42           O  
ATOM    569  CB  ILE A  67      50.464  47.836  82.732  1.00 14.89           C  
ATOM    570  CG1 ILE A  67      51.304  47.925  84.037  1.00 14.92           C  
ATOM    571  CG2 ILE A  67      51.346  47.524  81.504  1.00 15.08           C  
ATOM    572  CD1 ILE A  67      52.166  46.735  84.304  1.00 19.45           C  
ATOM    573  N   LYS A  68      50.329  50.705  80.813  1.00 13.56           N  
ATOM    574  CA  LYS A  68      51.058  51.836  80.301  1.00 13.04           C  
ATOM    575  C   LYS A  68      50.180  53.088  80.229  1.00 12.79           C  
ATOM    576  O   LYS A  68      50.569  54.106  79.614  1.00 13.20           O  
ATOM    577  CB  LYS A  68      51.743  51.504  78.986  1.00 13.66           C  
ATOM    578  CG  LYS A  68      52.914  50.583  79.118  1.00 12.42           C  
ATOM    579  CD  LYS A  68      54.134  51.324  79.652  1.00 16.75           C  
ATOM    580  CE  LYS A  68      55.265  50.330  79.813  1.00 23.21           C  
ATOM    581  NZ  LYS A  68      56.515  51.021  80.188  1.00 22.68           N  
ATOM    582  N   ARG A  69      49.037  53.058  80.882  1.00 13.33           N  
ATOM    583  CA  ARG A  69      48.197  54.271  80.945  1.00 13.90           C  
ATOM    584  C   ARG A  69      48.906  55.425  81.660  1.00 14.08           C  
ATOM    585  O   ARG A  69      48.880  56.556  81.195  1.00 15.20           O  
ATOM    586  CB  ARG A  69      46.832  54.017  81.599  1.00 15.71           C  
ATOM    587  CG  ARG A  69      45.723  53.814  80.664  1.00 27.43           C  
ATOM    588  CD  ARG A  69      45.286  55.126  80.094  1.00 27.95           C  
ATOM    589  NE  ARG A  69      44.144  54.970  79.213  1.00 32.46           N  
ATOM    590  CZ  ARG A  69      43.627  55.951  78.485  1.00 33.04           C  
ATOM    591  NH1 ARG A  69      44.156  57.161  78.525  1.00 34.21           N  
ATOM    592  NH2 ARG A  69      42.585  55.706  77.698  1.00 34.54           N  
ATOM    593  N   PRO A  70      49.492  55.143  82.814  1.00 14.65           N  
ATOM    594  CA  PRO A  70      50.217  56.231  83.460  1.00 13.24           C  
ATOM    595  C   PRO A  70      51.333  56.780  82.567  1.00 14.69           C  
ATOM    596  O   PRO A  70      51.508  57.994  82.464  1.00 16.53           O  
ATOM    597  CB  PRO A  70      50.786  55.541  84.719  1.00 13.07           C  
ATOM    598  CG  PRO A  70      49.794  54.468  85.020  1.00 16.62           C  
ATOM    599  CD  PRO A  70      49.405  53.942  83.669  1.00 15.63           C  
ATOM    600  N   HIS A  71      52.027  55.892  81.839  1.00 13.13           N  
ATOM    601  CA  HIS A  71      53.066  56.314  80.951  1.00 13.08           C  
ATOM    602  C   HIS A  71      52.508  57.181  79.813  1.00 14.55           C  
ATOM    603  O   HIS A  71      53.158  58.169  79.452  1.00 15.45           O  
ATOM    604  CB  HIS A  71      53.823  55.096  80.445  1.00 16.11           C  
ATOM    605  CG  HIS A  71      54.874  55.415  79.433  1.00 18.30           C  
ATOM    606  ND1 HIS A  71      56.134  55.850  79.789  1.00 26.10           N  
ATOM    607  CD2 HIS A  71      54.854  55.356  78.083  1.00 16.21           C  
ATOM    608  CE1 HIS A  71      56.845  56.049  78.691  1.00 25.76           C  
ATOM    609  NE2 HIS A  71      56.093  55.762  77.646  1.00 21.24           N  
ATOM    610  N   GLU A  72      51.315  56.854  79.321  1.00 13.32           N  
ATOM    611  CA  GLU A  72      50.676  57.669  78.263  1.00 14.20           C  
ATOM    612  C   GLU A  72      50.348  59.073  78.805  1.00 16.37           C  
ATOM    613  O   GLU A  72      50.519  60.049  78.095  1.00 16.88           O  
ATOM    614  CB  GLU A  72      49.393  57.011  77.748  1.00 13.53           C  
ATOM    615  CG  GLU A  72      48.724  57.837  76.667  1.00 15.42           C  
ATOM    616  CD  GLU A  72      47.530  57.191  76.022  1.00 21.04           C  
ATOM    617  OE1 GLU A  72      47.473  55.978  75.911  1.00 21.18           O  
ATOM    618  OE2 GLU A  72      46.643  57.931  75.570  1.00 33.52           O  
ATOM    619  N   ALA A  73      49.879  59.138  80.035  1.00 16.40           N  
ATOM    620  CA  ALA A  73      49.580  60.417  80.654  1.00 19.19           C  
ATOM    621  C   ALA A  73      50.821  61.304  80.706  1.00 20.89           C  
ATOM    622  O   ALA A  73      50.700  62.532  80.582  1.00 25.31           O  
ATOM    623  CB  ALA A  73      48.996  60.205  82.047  1.00 18.43           C  
ATOM    624  N   LEU A  74      52.000  60.712  80.900  1.00 18.19           N  
ATOM    625  CA  LEU A  74      53.234  61.497  80.946  1.00 18.25           C  
ATOM    626  C   LEU A  74      53.824  61.842  79.575  1.00 22.14           C  
ATOM    627  O   LEU A  74      54.430  62.917  79.396  1.00 21.97           O  
ATOM    628  CB  LEU A  74      54.287  60.755  81.755  1.00 17.95           C  
ATOM    629  CG  LEU A  74      53.919  60.466  83.212  1.00 20.85           C  
ATOM    630  CD1 LEU A  74      55.063  59.726  83.863  1.00 21.58           C  
ATOM    631  CD2 LEU A  74      53.611  61.687  83.986  1.00 24.11           C  
ATOM    632  N   THR A  75      53.670  60.941  78.600  1.00 19.08           N  
ATOM    633  CA  THR A  75      54.376  61.058  77.326  1.00 18.98           C  
ATOM    634  C   THR A  75      53.576  61.240  76.041  1.00 18.16           C  
ATOM    635  O   THR A  75      54.128  61.647  75.010  1.00 21.95           O  
ATOM    636  CB  THR A  75      55.252  59.795  77.100  1.00 19.77           C  
ATOM    637  OG1 THR A  75      54.381  58.672  76.935  1.00 18.74           O  
ATOM    638  CG2 THR A  75      56.200  59.527  78.267  1.00 23.18           C  
ATOM    639  N   GLY A  76      52.315  60.861  76.071  1.00 16.36           N  
ATOM    640  CA  GLY A  76      51.482  60.859  74.906  1.00 17.05           C  
ATOM    641  C   GLY A  76      51.656  59.608  74.057  1.00 17.36           C  
ATOM    642  O   GLY A  76      51.035  59.516  73.026  1.00 17.62           O  
ATOM    643  N   VAL A  77      52.478  58.659  74.506  1.00 17.08           N  
ATOM    644  CA  VAL A  77      52.721  57.405  73.767  1.00 17.16           C  
ATOM    645  C   VAL A  77      51.508  56.518  73.994  1.00 18.03           C  
ATOM    646  O   VAL A  77      51.088  56.299  75.140  1.00 14.66           O  
ATOM    647  CB  VAL A  77      54.000  56.717  74.234  1.00 20.31           C  
ATOM    648  CG1 VAL A  77      54.153  55.385  73.550  1.00 22.50           C  
ATOM    649  CG2 VAL A  77      55.221  57.612  73.938  1.00 23.73           C  
ATOM    650  N   ASP A  78      50.941  55.984  72.906  1.00 18.29           N  
ATOM    651  CA  ASP A  78      49.732  55.165  72.994  1.00 17.63           C  
ATOM    652  C   ASP A  78      49.912  53.944  73.938  1.00 15.74           C  
ATOM    653  O   ASP A  78      50.783  53.113  73.695  1.00 15.18           O  
ATOM    654  CB  ASP A  78      49.353  54.648  71.617  1.00 21.37           C  
ATOM    655  CG  ASP A  78      48.272  53.562  71.655  1.00 25.11           C  
ATOM    656  OD1 ASP A  78      47.268  53.633  72.375  1.00 30.31           O  
ATOM    657  OD2 ASP A  78      48.431  52.587  70.909  1.00 46.36           O  
ATOM    658  N   HIS A  79      49.068  53.859  74.943  1.00 15.29           N  
ATOM    659  CA  HIS A  79      49.188  52.824  75.964  1.00 14.67           C  
ATOM    660  C   HIS A  79      48.920  51.397  75.429  1.00 14.54           C  
ATOM    661  O   HIS A  79      49.454  50.398  75.973  1.00 13.80           O  
ATOM    662  CB  HIS A  79      48.335  53.104  77.181  1.00 14.34           C  
ATOM    663  CG  HIS A  79      46.862  52.872  77.016  1.00 15.62           C  
ATOM    664  ND1 HIS A  79      46.021  53.768  76.377  1.00 19.62           N  
ATOM    665  CD2 HIS A  79      46.078  51.851  77.434  1.00 16.49           C  
ATOM    666  CE1 HIS A  79      44.786  53.295  76.393  1.00 18.21           C  
ATOM    667  NE2 HIS A  79      44.787  52.143  77.060  1.00 16.89           N  
ATOM    668  N   ALA A  80      48.105  51.273  74.391  1.00 17.07           N  
ATOM    669  CA  ALA A  80      47.834  49.947  73.827  1.00 14.87           C  
ATOM    670  C   ALA A  80      49.105  49.390  73.167  1.00 15.72           C  
ATOM    671  O   ALA A  80      49.481  48.217  73.340  1.00 15.30           O  
ATOM    672  CB  ALA A  80      46.666  50.045  72.835  1.00 15.91           C  
ATOM    673  N   GLU A  81      49.820  50.233  72.402  0.50 15.18           N  
ATOM    675  CA  GLU A  81      51.081  49.826  71.746  0.50 13.96           C  
ATOM    677  C   GLU A  81      52.205  49.535  72.761  0.50 13.29           C  
ATOM    679  O   GLU A  81      52.973  48.540  72.647  0.50 10.93           O  
ATOM    681  CB  GLU A  81      51.613  50.915  70.774  0.50 16.90           C  
ATOM    683  CG  GLU A  81      50.731  51.175  69.564  0.50 16.17           C  
ATOM    685  N   SER A  82      52.380  50.450  73.703  0.25 11.84           N  
ATOM    688  CA  SER A  82      53.408  50.256  74.716  0.25 12.31           C  
ATOM    691  C   SER A  82      53.040  49.117  75.652  0.25 13.58           C  
ATOM    694  O   SER A  82      53.926  48.360  76.054  0.25 13.28           O  
ATOM    697  CB  SER A  82      53.657  51.544  75.490  0.25 12.57           C  
ATOM    700  OG  SER A  82      52.447  52.032  76.034  0.25  8.34           O  
ATOM    703  N   GLY A  83      51.766  48.992  76.018  1.00 13.06           N  
ATOM    704  CA  GLY A  83      51.360  47.851  76.858  1.00 12.05           C  
ATOM    705  C   GLY A  83      51.607  46.530  76.165  1.00 15.73           C  
ATOM    706  O   GLY A  83      52.053  45.582  76.776  1.00 13.06           O  
ATOM    707  N   ALA A  84      51.353  46.439  74.887  1.00 13.08           N  
ATOM    708  CA  ALA A  84      51.636  45.213  74.128  1.00 11.04           C  
ATOM    709  C   ALA A  84      53.101  44.916  74.080  1.00 14.22           C  
ATOM    710  O   ALA A  84      53.509  43.776  74.266  1.00 12.55           O  
ATOM    711  CB  ALA A  84      51.066  45.383  72.722  1.00 11.09           C  
ATOM    712  N   GLU A  85      53.944  45.928  73.847  1.00 14.19           N  
ATOM    713  CA  GLU A  85      55.387  45.731  73.834  1.00 13.32           C  
ATOM    714  C   GLU A  85      55.899  45.289  75.234  1.00 11.70           C  
ATOM    715  O   GLU A  85      56.739  44.423  75.352  1.00 14.15           O  
ATOM    716  CB  GLU A  85      56.059  47.042  73.370  1.00 14.52           C  
ATOM    717  CG  GLU A  85      57.578  47.007  73.408  1.00 18.45           C  
ATOM    718  CD  GLU A  85      58.227  48.335  72.997  1.00 24.28           C  
ATOM    719  OE1 GLU A  85      57.805  48.912  71.960  1.00 24.58           O  
ATOM    720  OE2 GLU A  85      59.209  48.733  73.672  1.00 36.37           O  
ATOM    721  N   TYR A  86      55.339  45.902  76.248  1.00 12.07           N  
ATOM    722  CA  TYR A  86      55.707  45.571  77.624  1.00 12.69           C  
ATOM    723  C   TYR A  86      55.358  44.121  77.902  1.00 14.70           C  
ATOM    724  O   TYR A  86      56.182  43.366  78.460  1.00 13.24           O  
ATOM    725  CB  TYR A  86      55.019  46.502  78.633  1.00 13.38           C  
ATOM    726  CG  TYR A  86      55.391  46.127  80.033  1.00 13.45           C  
ATOM    727  CD1 TYR A  86      56.613  46.461  80.535  1.00 16.65           C  
ATOM    728  CD2 TYR A  86      54.511  45.436  80.846  1.00 14.04           C  
ATOM    729  CE1 TYR A  86      56.993  46.074  81.822  1.00 16.24           C  
ATOM    730  CE2 TYR A  86      54.889  45.006  82.137  1.00 16.76           C  
ATOM    731  CZ  TYR A  86      56.102  45.353  82.605  1.00 19.05           C  
ATOM    732  OH  TYR A  86      56.451  44.930  83.890  1.00 19.09           O  
ATOM    733  N   ALA A  87      54.152  43.688  77.583  1.00 11.87           N  
ATOM    734  CA  ALA A  87      53.773  42.284  77.804  1.00 12.75           C  
ATOM    735  C   ALA A  87      54.675  41.317  77.085  1.00 15.16           C  
ATOM    736  O   ALA A  87      55.039  40.270  77.588  1.00 14.11           O  
ATOM    737  CB  ALA A  87      52.328  42.095  77.409  1.00 14.24           C  
ATOM    738  N   SER A  88      55.079  41.657  75.869  0.50 12.47           N  
ATOM    740  CA  SER A  88      56.018  40.808  75.110  0.50 13.07           C  
ATOM    742  C   SER A  88      57.398  40.689  75.719  0.50 14.12           C  
ATOM    744  O   SER A  88      58.131  39.757  75.414  0.50 15.97           O  
ATOM    746  CB  SER A  88      56.176  41.340  73.683  0.50 14.39           C  
ATOM    748  OG  SER A  88      54.975  41.210  72.991  0.50 12.35           O  
ATOM    750  N   GLY A  89      57.792  41.677  76.494  1.00 13.46           N  
ATOM    751  CA  GLY A  89      59.038  41.599  77.196  1.00 16.56           C  
ATOM    752  C   GLY A  89      58.936  40.894  78.531  1.00 16.90           C  
ATOM    753  O   GLY A  89      59.756  40.075  78.864  1.00 17.91           O  
ATOM    754  N   LEU A  90      57.883  41.196  79.277  1.00 15.52           N  
ATOM    755  CA  LEU A  90      57.727  40.667  80.636  1.00 16.58           C  
ATOM    756  C   LEU A  90      57.397  39.176  80.642  1.00 17.01           C  
ATOM    757  O   LEU A  90      58.015  38.399  81.353  1.00 15.99           O  
ATOM    758  CB  LEU A  90      56.603  41.398  81.372  1.00 16.62           C  
ATOM    759  CG  LEU A  90      56.193  40.779  82.729  1.00 14.46           C  
ATOM    760  CD1 LEU A  90      57.323  41.059  83.710  1.00 18.14           C  
ATOM    761  CD2 LEU A  90      54.923  41.381  83.219  1.00 17.19           C  
ATOM    762  N   LEU A  91      56.389  38.767  79.904  1.00 13.35           N  
ATOM    763  CA  LEU A  91      55.833  37.450  79.979  1.00 13.89           C  
ATOM    764  C   LEU A  91      56.780  36.271  79.685  1.00 15.73           C  
ATOM    765  O   LEU A  91      56.715  35.235  80.373  1.00 17.04           O  
ATOM    766  CB  LEU A  91      54.518  37.331  79.212  1.00 14.94           C  
ATOM    767  CG  LEU A  91      53.379  38.190  79.810  1.00 15.28           C  
ATOM    768  CD1 LEU A  91      52.131  38.093  78.932  1.00 15.33           C  
ATOM    769  CD2 LEU A  91      53.079  37.832  81.327  1.00 16.33           C  
ATOM    770  N   PRO A  92      57.673  36.396  78.692  1.00 15.29           N  
ATOM    771  CA  PRO A  92      58.649  35.286  78.491  1.00 17.56           C  
ATOM    772  C   PRO A  92      59.538  35.015  79.712  1.00 17.79           C  
ATOM    773  O   PRO A  92      59.929  33.871  79.923  1.00 21.27           O  
ATOM    774  CB  PRO A  92      59.490  35.767  77.304  1.00 18.25           C  
ATOM    775  CG  PRO A  92      58.540  36.686  76.545  1.00 15.68           C  
ATOM    776  CD  PRO A  92      57.787  37.415  77.621  1.00 16.87           C  
ATOM    777  N   THR A  93      59.822  36.059  80.484  1.00 19.24           N  
ATOM    778  CA  THR A  93      60.641  35.905  81.703  1.00 20.55           C  
ATOM    779  C   THR A  93      59.942  35.148  82.807  1.00 22.78           C  
ATOM    780  O   THR A  93      60.577  34.760  83.798  1.00 25.20           O  
ATOM    781  CB  THR A  93      61.131  37.266  82.296  1.00 20.83           C  
ATOM    782  OG1 THR A  93      60.062  37.913  82.986  1.00 23.95           O  
ATOM    783  CG2 THR A  93      61.736  38.188  81.232  1.00 24.96           C  
HETATM  784  N   MSE A  94      58.636  34.956  82.681  1.00 21.30           N  
HETATM  785  CA  MSE A  94      57.808  34.225  83.623  1.00 20.38           C  
HETATM  786  C   MSE A  94      57.446  32.825  83.105  1.00 21.06           C  
HETATM  787  O   MSE A  94      56.559  32.158  83.636  1.00 23.59           O  
HETATM  788  CB  MSE A  94      56.553  35.073  83.936  1.00 19.10           C  
HETATM  789  CG  MSE A  94      56.843  36.388  84.687  1.00 19.06           C  
HETATM  790 SE   MSE A  94      55.292  37.409  84.933  0.74 16.04          SE  
HETATM  791  CE  MSE A  94      55.969  38.432  86.421  1.00 18.59           C  
ATOM    792  N   GLY A  95      58.128  32.392  82.050  1.00 20.92           N  
ATOM    793  CA  GLY A  95      57.942  31.088  81.481  1.00 21.43           C  
ATOM    794  C   GLY A  95      56.772  30.889  80.520  1.00 19.53           C  
ATOM    795  O   GLY A  95      56.501  29.779  80.106  1.00 21.92           O  
ATOM    796  N   PHE A  96      56.054  31.957  80.156  1.00 18.24           N  
ATOM    797  CA  PHE A  96      54.960  31.769  79.199  1.00 20.26           C  
ATOM    798  C   PHE A  96      55.527  31.561  77.790  1.00 17.47           C  
ATOM    799  O   PHE A  96      56.515  32.220  77.436  1.00 16.82           O  
ATOM    800  CB  PHE A  96      54.032  33.006  79.256  1.00 16.50           C  
ATOM    801  CG  PHE A  96      53.267  33.113  80.582  1.00 16.54           C  
ATOM    802  CD1 PHE A  96      52.160  32.306  80.814  1.00 16.36           C  
ATOM    803  CD2 PHE A  96      53.674  33.991  81.556  1.00 15.52           C  
ATOM    804  CE1 PHE A  96      51.465  32.391  82.004  1.00 16.99           C  
ATOM    805  CE2 PHE A  96      52.975  34.088  82.777  1.00 15.94           C  
ATOM    806  CZ  PHE A  96      51.887  33.293  82.969  1.00 16.54           C  
ATOM    807  N   ASP A  97      54.881  30.693  77.024  1.00 17.97           N  
ATOM    808  CA  ASP A  97      55.397  30.312  75.733  1.00 18.91           C  
ATOM    809  C   ASP A  97      55.091  31.348  74.643  1.00 17.87           C  
ATOM    810  O   ASP A  97      54.292  32.263  74.864  1.00 16.05           O  
ATOM    811  CB  ASP A  97      55.030  28.871  75.346  1.00 21.86           C  
ATOM    812  CG  ASP A  97      53.583  28.664  74.942  1.00 28.88           C  
ATOM    813  OD1 ASP A  97      52.823  29.601  74.600  1.00 27.05           O  
ATOM    814  OD2 ASP A  97      53.220  27.467  74.888  1.00 33.23           O  
ATOM    815  N   ILE A  98      55.744  31.192  73.509  1.00 18.51           N  
ATOM    816  CA  ILE A  98      55.654  32.163  72.424  1.00 16.81           C  
ATOM    817  C   ILE A  98      54.223  32.449  71.988  1.00 16.89           C  
ATOM    818  O   ILE A  98      53.848  33.619  71.808  1.00 15.39           O  
ATOM    819  CB  ILE A  98      56.507  31.709  71.203  1.00 19.00           C  
ATOM    820  CG1 ILE A  98      57.994  31.854  71.512  1.00 22.66           C  
ATOM    821  CG2 ILE A  98      56.212  32.552  69.976  1.00 21.13           C  
ATOM    822  CD1 ILE A  98      58.901  31.265  70.447  1.00 23.07           C  
ATOM    823  N   SER A  99      53.440  31.413  71.791  1.00 16.39           N  
ATOM    824  CA  SER A  99      52.083  31.601  71.314  1.00 16.68           C  
ATOM    825  C   SER A  99      51.240  32.281  72.390  1.00 17.87           C  
ATOM    826  O   SER A  99      50.452  33.152  72.059  1.00 16.98           O  
ATOM    827  CB  SER A  99      51.490  30.268  70.792  1.00 20.48           C  
ATOM    828  OG  SER A  99      52.293  29.765  69.697  1.00 20.32           O  
ATOM    829  N   PHE A 100      51.426  31.949  73.658  1.00 16.17           N  
ATOM    830  CA  PHE A 100      50.664  32.571  74.718  1.00 14.87           C  
ATOM    831  C   PHE A 100      50.959  34.054  74.744  1.00 14.25           C  
ATOM    832  O   PHE A 100      50.051  34.921  74.819  1.00 14.36           O  
ATOM    833  CB  PHE A 100      51.066  31.951  76.081  1.00 17.43           C  
ATOM    834  CG  PHE A 100      50.302  32.468  77.249  1.00 15.95           C  
ATOM    835  CD1 PHE A 100      50.612  33.666  77.831  1.00 15.41           C  
ATOM    836  CD2 PHE A 100      49.307  31.687  77.827  1.00 18.43           C  
ATOM    837  CE1 PHE A 100      49.915  34.139  78.954  1.00 18.76           C  
ATOM    838  CE2 PHE A 100      48.641  32.139  78.923  1.00 16.96           C  
ATOM    839  CZ  PHE A 100      48.929  33.339  79.480  1.00 14.62           C  
ATOM    840  N   VAL A 101      52.249  34.366  74.810  1.00 14.26           N  
ATOM    841  CA  VAL A 101      52.679  35.765  74.871  1.00 13.44           C  
ATOM    842  C   VAL A 101      52.190  36.567  73.639  1.00 13.57           C  
ATOM    843  O   VAL A 101      51.731  37.709  73.790  1.00 14.43           O  
ATOM    844  CB  VAL A 101      54.212  35.862  75.025  1.00 12.13           C  
ATOM    845  CG1 VAL A 101      54.669  37.277  74.964  1.00 13.18           C  
ATOM    846  CG2 VAL A 101      54.695  35.140  76.317  1.00 13.14           C  
ATOM    847  N   ALA A 102      52.259  35.990  72.445  1.00 13.42           N  
ATOM    848  CA  ALA A 102      51.815  36.714  71.243  1.00 13.61           C  
ATOM    849  C   ALA A 102      50.333  37.009  71.336  1.00 15.41           C  
ATOM    850  O   ALA A 102      49.889  38.082  70.961  1.00 13.95           O  
ATOM    851  CB  ALA A 102      52.136  35.928  70.030  1.00 14.29           C  
ATOM    852  N   GLU A 103      49.551  36.087  71.828  1.00 12.98           N  
ATOM    853  CA  GLU A 103      48.110  36.300  71.885  1.00 12.54           C  
ATOM    854  C   GLU A 103      47.772  37.397  72.895  1.00 14.04           C  
ATOM    855  O   GLU A 103      46.915  38.252  72.661  1.00 12.42           O  
ATOM    856  CB  GLU A 103      47.307  35.003  72.193  1.00 13.43           C  
ATOM    857  CG  GLU A 103      45.796  35.261  72.312  1.00 15.65           C  
ATOM    858  CD  GLU A 103      44.927  34.028  72.167  1.00 18.04           C  
ATOM    859  OE1 GLU A 103      45.431  33.004  71.673  1.00 21.79           O  
ATOM    860  OE2 GLU A 103      43.715  34.094  72.513  1.00 20.71           O  
ATOM    861  N   VAL A 104      48.352  37.311  74.076  1.00 14.05           N  
ATOM    862  CA  VAL A 104      48.116  38.329  75.084  1.00 12.30           C  
ATOM    863  C   VAL A 104      48.555  39.700  74.591  1.00 13.34           C  
ATOM    864  O   VAL A 104      47.828  40.707  74.789  1.00 12.18           O  
ATOM    865  CB  VAL A 104      48.806  37.993  76.443  1.00 12.94           C  
ATOM    866  CG1 VAL A 104      48.740  39.154  77.429  1.00 12.76           C  
ATOM    867  CG2 VAL A 104      48.176  36.758  77.039  1.00 14.70           C  
ATOM    868  N   SER A 105      49.748  39.760  74.008  1.00 11.85           N  
ATOM    869  CA  SER A 105      50.266  41.024  73.513  0.50 13.05           C  
ATOM    871  C   SER A 105      49.343  41.635  72.417  1.00 11.22           C  
ATOM    872  O   SER A 105      49.033  42.828  72.503  1.00 12.38           O  
ATOM    873  CB  SER A 105      51.708  40.869  73.030  0.50 13.34           C  
ATOM    875  OG  SER A 105      52.564  40.462  74.096  0.50 17.57           O  
ATOM    877  N   LYS A 106      48.869  40.819  71.471  1.00 11.95           N  
ATOM    878  CA  LYS A 106      48.015  41.280  70.381  1.00 14.60           C  
ATOM    879  C   LYS A 106      46.714  41.741  71.003  1.00 13.24           C  
ATOM    880  O   LYS A 106      46.103  42.748  70.559  1.00 12.19           O  
ATOM    881  CB  LYS A 106      47.758  40.136  69.406  1.00 14.07           C  
ATOM    882  CG  LYS A 106      46.932  40.572  68.183  1.00 23.40           C  
ATOM    883  CD  LYS A 106      46.737  39.393  67.137  1.00 26.58           C  
ATOM    884  N   ALA A 107      46.201  41.051  72.008  1.00 12.28           N  
ATOM    885  CA  ALA A 107      44.958  41.472  72.629  1.00 11.39           C  
ATOM    886  C   ALA A 107      45.083  42.854  73.214  1.00 14.35           C  
ATOM    887  O   ALA A 107      44.193  43.696  73.102  1.00 13.60           O  
ATOM    888  CB  ALA A 107      44.540  40.471  73.710  1.00 12.19           C  
ATOM    889  N   ILE A 108      46.183  43.132  73.875  1.00 12.36           N  
ATOM    890  CA  ILE A 108      46.378  44.438  74.469  1.00 13.38           C  
ATOM    891  C   ILE A 108      46.526  45.477  73.376  1.00 13.44           C  
ATOM    892  O   ILE A 108      46.011  46.591  73.445  1.00 14.63           O  
ATOM    893  CB  ILE A 108      47.624  44.425  75.378  1.00 13.43           C  
ATOM    894  CG1 ILE A 108      47.371  43.475  76.579  1.00 12.89           C  
ATOM    895  CG2 ILE A 108      48.030  45.866  75.833  1.00 14.42           C  
ATOM    896  CD1 ILE A 108      48.622  43.185  77.420  1.00 13.43           C  
ATOM    897  N   ARG A 109      47.266  45.106  72.351  1.00 14.17           N  
ATOM    898  CA  ARG A 109      47.508  46.027  71.252  1.00 15.31           C  
ATOM    899  C   ARG A 109      46.231  46.475  70.582  1.00 16.92           C  
ATOM    900  O   ARG A 109      46.141  47.623  70.107  1.00 18.21           O  
ATOM    901  CB  ARG A 109      48.413  45.372  70.230  1.00 15.31           C  
ATOM    902  CG  ARG A 109      48.884  46.287  69.105  1.00 18.25           C  
ATOM    903  CD  ARG A 109      49.796  45.541  68.167  1.00 29.84           C  
ATOM    904  NE  ARG A 109      50.986  45.067  68.858  1.00 34.27           N  
ATOM    905  CZ  ARG A 109      52.158  45.698  68.920  1.00 51.12           C  
ATOM    906  NH1 ARG A 109      52.351  46.875  68.307  1.00 56.41           N  
ATOM    907  NH2 ARG A 109      53.160  45.122  69.607  1.00 43.92           N  
ATOM    908  N   SER A 110      45.243  45.588  70.541  0.50 14.83           N  
ATOM    910  CA  SER A 110      43.969  45.835  69.849  0.50 13.65           C  
ATOM    912  C   SER A 110      42.837  46.402  70.695  0.50 16.04           C  
ATOM    914  O   SER A 110      41.755  46.701  70.172  0.50 15.21           O  
ATOM    916  CB  SER A 110      43.455  44.512  69.259  0.50 12.22           C  
ATOM    918  OG  SER A 110      44.443  43.881  68.482  0.50 14.16           O  
ATOM    920  N   HIS A 111      43.040  46.548  72.000  1.00 17.19           N  
ATOM    921  CA  HIS A 111      41.924  46.839  72.886  1.00 15.78           C  
ATOM    922  C   HIS A 111      41.162  48.155  72.788  1.00 16.35           C  
ATOM    923  O   HIS A 111      40.024  48.195  73.225  1.00 18.69           O  
ATOM    924  CB  HIS A 111      42.282  46.534  74.358  1.00 16.91           C  
ATOM    925  CG  HIS A 111      42.919  47.676  75.105  1.00 17.01           C  
ATOM    926  ND1 HIS A 111      44.281  47.862  75.185  1.00 15.08           N  
ATOM    927  CD2 HIS A 111      42.358  48.652  75.861  1.00 17.75           C  
ATOM    928  CE1 HIS A 111      44.527  48.928  75.932  1.00 13.54           C  
ATOM    929  NE2 HIS A 111      43.374  49.425  76.364  1.00 15.73           N  
ATOM    930  N   ARG A 112      41.761  49.179  72.222  1.00 19.34           N  
ATOM    931  CA  ARG A 112      41.025  50.448  72.079  1.00 26.50           C  
ATOM    932  C   ARG A 112      40.014  50.426  70.924  1.00 29.19           C  
ATOM    933  O   ARG A 112      40.239  49.712  69.937  1.00 32.62           O  
ATOM    934  CB  ARG A 112      41.947  51.624  71.845  1.00 29.16           C  
ATOM    935  CG  ARG A 112      42.985  51.893  72.867  1.00 35.53           C  
ATOM    936  CD  ARG A 112      42.941  53.404  73.180  1.00 48.20           C  
ATOM    937  NE  ARG A 112      44.216  54.082  73.044  1.00 54.22           N  
ATOM    938  CZ  ARG A 112      44.478  55.284  73.555  1.00 51.68           C  
ATOM    939  NH1 ARG A 112      43.566  55.947  74.277  1.00 56.90           N  
ATOM    940  NH2 ARG A 112      45.674  55.825  73.365  1.00 51.06           N  
ATOM    941  N   THR A 118      39.252  46.129  64.824  1.00 32.80           N  
ATOM    942  CA  THR A 118      38.898  45.201  65.892  1.00 28.81           C  
ATOM    943  C   THR A 118      39.955  44.159  66.348  1.00 24.84           C  
ATOM    944  O   THR A 118      40.902  43.860  65.645  1.00 26.49           O  
ATOM    945  CB  THR A 118      37.665  44.380  65.451  1.00 29.48           C  
ATOM    946  OG1 THR A 118      38.011  43.543  64.347  1.00 37.56           O  
ATOM    947  CG2 THR A 118      36.519  45.289  65.056  1.00 35.03           C  
ATOM    948  N   PRO A 119      39.778  43.568  67.562  1.00 19.96           N  
ATOM    949  CA  PRO A 119      40.545  42.406  68.004  1.00 19.33           C  
ATOM    950  C   PRO A 119      40.257  41.203  67.093  1.00 19.95           C  
ATOM    951  O   PRO A 119      39.148  41.103  66.563  1.00 21.19           O  
ATOM    952  CB  PRO A 119      39.975  42.088  69.376  1.00 18.96           C  
ATOM    953  CG  PRO A 119      39.115  43.166  69.760  1.00 20.65           C  
ATOM    954  CD  PRO A 119      38.838  44.053  68.591  1.00 21.96           C  
ATOM    955  N   THR A 120      41.214  40.303  66.972  1.00 19.92           N  
ATOM    956  CA  THR A 120      41.060  39.108  66.141  1.00 21.62           C  
ATOM    957  C   THR A 120      41.097  37.800  66.901  1.00 20.79           C  
ATOM    958  O   THR A 120      40.658  36.759  66.392  1.00 23.30           O  
ATOM    959  CB  THR A 120      42.141  39.071  65.059  1.00 22.74           C  
ATOM    960  OG1 THR A 120      43.440  39.212  65.654  1.00 27.65           O  
ATOM    961  CG2 THR A 120      41.892  40.190  64.028  1.00 22.43           C  
ATOM    962  N   SER A 121      41.573  37.822  68.141  1.00 16.57           N  
ATOM    963  CA  SER A 121      41.634  36.601  68.927  1.00 18.98           C  
ATOM    964  C   SER A 121      40.525  36.560  69.960  1.00 18.17           C  
ATOM    965  O   SER A 121      39.911  37.573  70.296  1.00 17.04           O  
ATOM    966  CB  SER A 121      42.961  36.479  69.663  1.00 21.07           C  
ATOM    967  OG  SER A 121      43.113  37.462  70.705  1.00 21.78           O  
ATOM    968  N   LEU A 122      40.296  35.384  70.504  1.00 16.39           N  
ATOM    969  CA  LEU A 122      39.309  35.222  71.558  1.00 15.70           C  
ATOM    970  C   LEU A 122      39.744  36.073  72.764  1.00 14.79           C  
ATOM    971  O   LEU A 122      38.931  36.743  73.388  1.00 13.77           O  
ATOM    972  CB  LEU A 122      39.174  33.777  72.013  1.00 20.97           C  
ATOM    973  CG  LEU A 122      38.591  32.795  70.987  1.00 31.79           C  
ATOM    974  CD1 LEU A 122      38.703  31.364  71.495  1.00 35.59           C  
ATOM    975  CD2 LEU A 122      37.158  33.141  70.704  1.00 37.52           C  
ATOM    976  N   THR A 123      41.021  36.048  73.104  1.00 13.84           N  
ATOM    977  CA  THR A 123      41.507  36.839  74.236  1.00 13.43           C  
ATOM    978  C   THR A 123      41.254  38.326  73.977  1.00 12.29           C  
ATOM    979  O   THR A 123      40.794  39.026  74.872  1.00 12.42           O  
ATOM    980  CB  THR A 123      42.990  36.591  74.517  1.00 15.51           C  
ATOM    981  OG1 THR A 123      43.208  35.202  74.794  1.00 16.88           O  
ATOM    982  CG2 THR A 123      43.459  37.393  75.729  1.00 14.71           C  
ATOM    983  N   GLY A 124      41.470  38.797  72.743  1.00 13.84           N  
ATOM    984  CA  GLY A 124      41.251  40.198  72.474  1.00 13.78           C  
ATOM    985  C   GLY A 124      39.789  40.624  72.528  1.00 13.07           C  
ATOM    986  O   GLY A 124      39.490  41.694  73.007  1.00 12.75           O  
ATOM    987  N   LYS A 125      38.902  39.754  72.087  1.00 12.50           N  
ATOM    988  CA  LYS A 125      37.488  39.994  72.127  1.00 14.70           C  
ATOM    989  C   LYS A 125      36.994  40.036  73.567  1.00 14.61           C  
ATOM    990  O   LYS A 125      36.229  40.923  73.957  1.00 14.97           O  
ATOM    991  CB  LYS A 125      36.769  38.962  71.271  1.00 13.25           C  
ATOM    992  CG  LYS A 125      37.007  39.262  69.755  1.00 16.80           C  
ATOM    993  CD  LYS A 125      36.347  38.205  68.870  1.00 20.69           C  
ATOM    994  CE  LYS A 125      36.806  38.310  67.404  1.00 28.82           C  
ATOM    995  NZ  LYS A 125      36.483  37.057  66.612  1.00 37.39           N  
ATOM    996  N   ILE A 126      37.403  39.062  74.372  1.00 13.14           N  
ATOM    997  CA  ILE A 126      37.048  39.018  75.783  1.00 12.68           C  
ATOM    998  C   ILE A 126      37.578  40.246  76.496  1.00 12.04           C  
ATOM    999  O   ILE A 126      36.841  40.885  77.274  1.00 13.28           O  
ATOM   1000  CB  ILE A 126      37.581  37.749  76.448  1.00 13.77           C  
ATOM   1001  CG1 ILE A 126      36.816  36.544  75.880  1.00 14.79           C  
ATOM   1002  CG2 ILE A 126      37.473  37.833  77.970  1.00 14.02           C  
ATOM   1003  CD1 ILE A 126      37.350  35.230  76.303  1.00 15.25           C  
ATOM   1004  N   LEU A 127      38.803  40.643  76.199  1.00 10.38           N  
ATOM   1005  CA  LEU A 127      39.419  41.798  76.848  1.00 11.40           C  
ATOM   1006  C   LEU A 127      38.638  43.045  76.542  1.00 11.65           C  
ATOM   1007  O   LEU A 127      38.345  43.831  77.435  1.00 13.28           O  
ATOM   1008  CB  LEU A 127      40.877  41.985  76.410  1.00 12.67           C  
ATOM   1009  CG  LEU A 127      41.547  43.251  76.942  1.00 11.86           C  
ATOM   1010  CD1 LEU A 127      41.547  43.297  78.490  1.00 13.63           C  
ATOM   1011  CD2 LEU A 127      42.946  43.368  76.408  1.00 12.09           C  
ATOM   1012  N   GLN A 128      38.342  43.259  75.252  1.00 12.62           N  
ATOM   1013  CA  GLN A 128      37.583  44.425  74.871  1.00 15.99           C  
ATOM   1014  C   GLN A 128      36.212  44.446  75.516  1.00 13.05           C  
ATOM   1015  O   GLN A 128      35.812  45.484  76.055  1.00 13.90           O  
ATOM   1016  CB  GLN A 128      37.502  44.552  73.368  1.00 17.87           C  
ATOM   1017  CG  GLN A 128      36.943  45.856  72.969  1.00 19.61           C  
ATOM   1018  CD  GLN A 128      37.192  46.144  71.488  1.00 19.79           C  
ATOM   1019  OE1 GLN A 128      36.581  45.543  70.611  1.00 20.47           O  
ATOM   1020  NE2 GLN A 128      38.090  47.072  71.208  1.00 21.11           N  
ATOM   1021  N   ASP A 129      35.519  43.313  75.582  1.00 13.16           N  
ATOM   1022  CA  ASP A 129      34.261  43.268  76.252  1.00 12.46           C  
ATOM   1023  C   ASP A 129      34.400  43.631  77.727  1.00 15.15           C  
ATOM   1024  O   ASP A 129      33.589  44.392  78.270  1.00 16.06           O  
ATOM   1025  CB  ASP A 129      33.635  41.873  76.184  1.00 15.14           C  
ATOM   1026  CG  ASP A 129      33.031  41.531  74.835  1.00 15.37           C  
ATOM   1027  OD1 ASP A 129      32.953  42.412  73.913  1.00 16.42           O  
ATOM   1028  OD2 ASP A 129      32.575  40.359  74.714  1.00 14.92           O  
ATOM   1029  N   ALA A 130      35.356  43.021  78.389  1.00 15.32           N  
ATOM   1030  CA  ALA A 130      35.604  43.213  79.812  1.00 16.56           C  
ATOM   1031  C   ALA A 130      35.906  44.682  80.151  1.00 15.13           C  
ATOM   1032  O   ALA A 130      35.454  45.226  81.192  1.00 14.54           O  
ATOM   1033  CB  ALA A 130      36.752  42.331  80.241  1.00 16.79           C  
ATOM   1034  N   ASP A 131      36.663  45.318  79.269  1.00 14.87           N  
ATOM   1035  CA  ASP A 131      37.057  46.725  79.415  1.00 16.33           C  
ATOM   1036  C   ASP A 131      35.815  47.591  79.251  1.00 17.93           C  
ATOM   1037  O   ASP A 131      35.499  48.436  80.119  1.00 18.24           O  
ATOM   1038  CB  ASP A 131      38.082  47.057  78.346  1.00 14.03           C  
ATOM   1039  CG  ASP A 131      38.734  48.424  78.522  1.00 16.08           C  
ATOM   1040  OD1 ASP A 131      39.064  48.786  79.686  1.00 17.61           O  
ATOM   1041  OD2 ASP A 131      38.938  49.095  77.488  1.00 21.15           O  
ATOM   1042  N   ARG A 132      35.066  47.345  78.174  1.00 17.72           N  
ATOM   1043  CA  ARG A 132      33.928  48.221  77.879  1.00 18.64           C  
ATOM   1044  C   ARG A 132      32.793  48.039  78.850  1.00 16.50           C  
ATOM   1045  O   ARG A 132      32.060  49.010  79.128  1.00 20.28           O  
ATOM   1046  CB  ARG A 132      33.457  48.070  76.434  1.00 18.57           C  
ATOM   1047  CG  ARG A 132      34.504  48.450  75.429  1.00 19.54           C  
ATOM   1048  CD  ARG A 132      34.164  48.135  74.003  1.00 22.79           C  
ATOM   1049  NE  ARG A 132      32.959  48.872  73.611  1.00 28.36           N  
ATOM   1050  CZ  ARG A 132      31.722  48.372  73.494  1.00 33.00           C  
ATOM   1051  NH1 ARG A 132      31.440  47.075  73.637  1.00 39.29           N  
ATOM   1052  NH2 ARG A 132      30.743  49.204  73.164  1.00 38.32           N  
ATOM   1053  N   LEU A 133      32.665  46.860  79.472  1.00 17.08           N  
ATOM   1054  CA  LEU A 133      31.595  46.655  80.452  1.00 18.60           C  
ATOM   1055  C   LEU A 133      31.764  47.611  81.646  1.00 18.49           C  
ATOM   1056  O   LEU A 133      30.801  47.883  82.354  1.00 18.88           O  
ATOM   1057  CB  LEU A 133      31.612  45.234  81.026  1.00 19.27           C  
ATOM   1058  CG  LEU A 133      30.885  44.147  80.249  1.00 22.11           C  
ATOM   1059  CD1 LEU A 133      31.204  42.740  80.825  1.00 19.49           C  
ATOM   1060  CD2 LEU A 133      29.337  44.444  80.309  1.00 25.05           C  
ATOM   1061  N   ASP A 134      32.979  48.091  81.880  1.00 17.01           N  
ATOM   1062  CA  ASP A 134      33.236  48.965  83.030  1.00 18.48           C  
ATOM   1063  C   ASP A 134      32.598  50.350  82.908  1.00 19.10           C  
ATOM   1064  O   ASP A 134      32.558  51.077  83.894  1.00 20.67           O  
ATOM   1065  CB  ASP A 134      34.737  49.081  83.309  1.00 20.00           C  
ATOM   1066  CG  ASP A 134      35.016  49.555  84.730  1.00 18.57           C  
ATOM   1067  OD1 ASP A 134      34.441  48.973  85.678  1.00 19.45           O  
ATOM   1068  OD2 ASP A 134      35.823  50.487  84.865  1.00 19.87           O  
ATOM   1069  N   ALA A 135      32.133  50.732  81.718  1.00 20.21           N  
ATOM   1070  CA  ALA A 135      31.443  51.991  81.517  1.00 22.77           C  
ATOM   1071  C   ALA A 135      29.991  51.982  82.046  1.00 22.43           C  
ATOM   1072  O   ALA A 135      29.350  53.039  82.124  1.00 24.77           O  
ATOM   1073  CB  ALA A 135      31.442  52.337  80.084  1.00 21.96           C  
ATOM   1074  N   ILE A 136      29.472  50.816  82.395  1.00 19.95           N  
ATOM   1075  CA  ILE A 136      28.109  50.697  82.888  1.00 23.10           C  
ATOM   1076  C   ILE A 136      27.953  49.897  84.154  1.00 22.46           C  
ATOM   1077  O   ILE A 136      28.758  49.046  84.499  1.00 21.95           O  
ATOM   1078  CB  ILE A 136      27.156  50.145  81.836  1.00 26.19           C  
ATOM   1079  CG1 ILE A 136      27.612  48.784  81.330  1.00 25.27           C  
ATOM   1080  CG2 ILE A 136      27.029  51.131  80.687  1.00 33.11           C  
ATOM   1081  CD1 ILE A 136      26.755  48.234  80.202  1.00 29.30           C  
ATOM   1082  N   GLY A 137      26.872  50.173  84.881  1.00 21.35           N  
ATOM   1083  CA  GLY A 137      26.619  49.470  86.116  1.00 19.37           C  
ATOM   1084  C   GLY A 137      26.609  50.392  87.329  1.00 19.95           C  
ATOM   1085  O   GLY A 137      26.699  51.621  87.194  1.00 21.74           O  
ATOM   1086  N   ALA A 138      26.547  49.784  88.501  1.00 20.59           N  
ATOM   1087  CA  ALA A 138      26.456  50.506  89.767  1.00 20.79           C  
ATOM   1088  C   ALA A 138      27.702  51.326  90.067  1.00 20.86           C  
ATOM   1089  O   ALA A 138      27.620  52.483  90.483  1.00 20.46           O  
ATOM   1090  CB  ALA A 138      26.192  49.550  90.883  1.00 21.98           C  
ATOM   1091  N   VAL A 139      28.890  50.766  89.839  1.00 19.18           N  
ATOM   1092  CA  VAL A 139      30.119  51.511  90.111  1.00 18.88           C  
ATOM   1093  C   VAL A 139      30.235  52.690  89.171  1.00 19.39           C  
ATOM   1094  O   VAL A 139      30.625  53.784  89.593  1.00 18.69           O  
ATOM   1095  CB  VAL A 139      31.391  50.609  90.063  1.00 21.38           C  
ATOM   1096  CG1 VAL A 139      32.643  51.442  90.265  1.00 20.93           C  
ATOM   1097  CG2 VAL A 139      31.319  49.518  91.121  1.00 19.34           C  
ATOM   1098  N   ALA A 140      29.891  52.497  87.895  1.00 19.37           N  
ATOM   1099  CA  ALA A 140      29.880  53.594  86.925  1.00 20.95           C  
ATOM   1100  C   ALA A 140      28.936  54.752  87.369  1.00 20.32           C  
ATOM   1101  O   ALA A 140      29.291  55.914  87.254  1.00 21.85           O  
ATOM   1102  CB  ALA A 140      29.480  53.072  85.551  1.00 22.32           C  
ATOM   1103  N   ILE A 141      27.744  54.397  87.838  1.00 19.85           N  
ATOM   1104  CA  ILE A 141      26.807  55.386  88.381  1.00 21.00           C  
ATOM   1105  C   ILE A 141      27.463  56.135  89.535  1.00 17.40           C  
ATOM   1106  O   ILE A 141      27.415  57.358  89.591  1.00 20.32           O  
ATOM   1107  CB  ILE A 141      25.483  54.742  88.848  1.00 20.63           C  
ATOM   1108  CG1 ILE A 141      24.665  54.222  87.667  1.00 23.77           C  
ATOM   1109  CG2 ILE A 141      24.652  55.744  89.661  1.00 20.61           C  
ATOM   1110  CD1 ILE A 141      23.593  53.195  88.070  1.00 22.16           C  
ATOM   1111  N   ALA A 142      28.025  55.408  90.490  1.00 17.80           N  
ATOM   1112  CA  ALA A 142      28.690  56.040  91.608  1.00 19.63           C  
ATOM   1113  C   ALA A 142      29.797  56.994  91.116  1.00 24.53           C  
ATOM   1114  O   ALA A 142      29.947  58.100  91.662  1.00 26.10           O  
ATOM   1115  CB  ALA A 142      29.231  55.025  92.575  1.00 21.07           C  
ATOM   1116  N   ARG A 143      30.558  56.597  90.081  1.00 23.23           N  
ATOM   1117  CA  ARG A 143      31.627  57.472  89.586  1.00 26.08           C  
ATOM   1118  C   ARG A 143      31.108  58.755  89.034  1.00 26.78           C  
ATOM   1119  O   ARG A 143      31.725  59.799  89.211  1.00 29.84           O  
ATOM   1120  CB  ARG A 143      32.459  56.822  88.462  1.00 26.94           C  
ATOM   1121  CG  ARG A 143      33.652  56.053  88.913  1.00 35.85           C  
ATOM   1122  CD  ARG A 143      34.683  55.912  87.730  1.00 33.89           C  
ATOM   1123  NE  ARG A 143      34.059  55.359  86.525  1.00 33.69           N  
ATOM   1124  CZ  ARG A 143      33.687  54.091  86.405  1.00 29.96           C  
ATOM   1125  NH1 ARG A 143      33.862  53.244  87.418  1.00 34.14           N  
ATOM   1126  NH2 ARG A 143      33.107  53.673  85.277  1.00 33.55           N  
ATOM   1127  N   VAL A 144      30.001  58.689  88.319  1.00 28.23           N  
ATOM   1128  CA  VAL A 144      29.444  59.900  87.739  1.00 31.12           C  
ATOM   1129  C   VAL A 144      29.134  60.898  88.851  1.00 30.80           C  
ATOM   1130  O   VAL A 144      29.493  62.066  88.757  1.00 32.83           O  
ATOM   1131  CB  VAL A 144      28.180  59.619  86.904  1.00 33.26           C  
ATOM   1132  CG1 VAL A 144      27.474  60.929  86.521  1.00 38.74           C  
ATOM   1133  CG2 VAL A 144      28.536  58.826  85.664  1.00 36.98           C  
ATOM   1134  N   PHE A 145      28.506  60.429  89.915  1.00 29.49           N  
ATOM   1135  CA  PHE A 145      28.159  61.307  91.023  1.00 30.35           C  
ATOM   1136  C   PHE A 145      29.351  61.779  91.854  1.00 33.97           C  
ATOM   1137  O   PHE A 145      29.355  62.920  92.345  1.00 34.44           O  
ATOM   1138  CB  PHE A 145      27.022  60.685  91.850  1.00 27.27           C  
ATOM   1139  CG  PHE A 145      25.722  60.671  91.108  1.00 25.81           C  
ATOM   1140  CD1 PHE A 145      25.059  61.854  90.836  1.00 27.86           C  
ATOM   1141  CD2 PHE A 145      25.154  59.499  90.664  1.00 20.94           C  
ATOM   1142  CE1 PHE A 145      23.859  61.868  90.137  1.00 28.02           C  
ATOM   1143  CE2 PHE A 145      23.956  59.520  89.974  1.00 24.21           C  
ATOM   1144  CZ  PHE A 145      23.314  60.703  89.710  1.00 31.14           C  
ATOM   1145  N   SER A 146      30.371  60.944  91.995  1.00 35.34           N  
ATOM   1146  CA  SER A 146      31.581  61.354  92.699  1.00 39.10           C  
ATOM   1147  C   SER A 146      32.326  62.455  91.958  1.00 42.85           C  
ATOM   1148  O   SER A 146      32.799  63.385  92.593  1.00 45.87           O  
ATOM   1149  CB  SER A 146      32.496  60.179  92.947  1.00 39.32           C  
ATOM   1150  OG  SER A 146      31.866  59.289  93.842  1.00 45.07           O  
ATOM   1151  N   TYR A 147      32.421  62.378  90.632  1.00 45.77           N  
ATOM   1152  CA  TYR A 147      33.078  63.438  89.860  1.00 48.27           C  
ATOM   1153  C   TYR A 147      32.248  64.725  89.921  1.00 50.86           C  
ATOM   1154  O   TYR A 147      31.041  64.716  89.640  1.00 52.30           O  
ATOM   1155  CB  TYR A 147      33.279  63.020  88.399  1.00 49.23           C  
ATOM   1156  N   PRO A 186      24.516  46.995  74.492  1.00 50.14           N  
ATOM   1157  CA  PRO A 186      24.607  45.562  74.798  1.00 48.68           C  
ATOM   1158  C   PRO A 186      24.870  44.703  73.567  1.00 47.11           C  
ATOM   1159  O   PRO A 186      25.605  43.729  73.658  1.00 45.09           O  
ATOM   1160  CB  PRO A 186      23.250  45.246  75.426  1.00 49.94           C  
ATOM   1161  CG  PRO A 186      22.867  46.529  76.119  1.00 49.18           C  
ATOM   1162  CD  PRO A 186      23.465  47.659  75.286  1.00 51.19           C  
ATOM   1163  N   GLU A 187      24.301  45.070  72.420  1.00 46.24           N  
ATOM   1164  CA  GLU A 187      24.551  44.325  71.168  1.00 47.12           C  
ATOM   1165  C   GLU A 187      25.931  44.611  70.532  1.00 44.64           C  
ATOM   1166  O   GLU A 187      26.310  43.968  69.552  1.00 45.61           O  
ATOM   1167  CB  GLU A 187      23.434  44.558  70.130  1.00 49.62           C  
ATOM   1168  CG  GLU A 187      23.359  45.952  69.469  1.00 54.68           C  
ATOM   1169  CD  GLU A 187      22.798  47.053  70.366  1.00 64.25           C  
ATOM   1170  OE1 GLU A 187      22.300  46.751  71.483  1.00 63.66           O  
ATOM   1171  OE2 GLU A 187      22.851  48.231  69.932  1.00 73.26           O  
ATOM   1172  N   THR A 188      26.664  45.588  71.068  1.00 42.26           N  
ATOM   1173  CA  THR A 188      28.011  45.919  70.586  1.00 38.45           C  
ATOM   1174  C   THR A 188      29.113  44.997  71.151  1.00 32.46           C  
ATOM   1175  O   THR A 188      30.245  45.087  70.737  1.00 34.10           O  
ATOM   1176  CB  THR A 188      28.386  47.352  71.002  1.00 37.32           C  
ATOM   1177  OG1 THR A 188      28.277  47.460  72.423  1.00 40.06           O  
ATOM   1178  CG2 THR A 188      27.440  48.380  70.361  1.00 45.18           C  
ATOM   1179  N   PHE A 189      28.769  44.099  72.060  1.00 26.20           N  
ATOM   1180  CA  PHE A 189      29.755  43.215  72.675  1.00 24.23           C  
ATOM   1181  C   PHE A 189      30.002  41.949  71.854  1.00 23.84           C  
ATOM   1182  O   PHE A 189      29.118  41.449  71.174  1.00 24.13           O  
ATOM   1183  CB  PHE A 189      29.334  42.906  74.091  1.00 24.42           C  
ATOM   1184  CG  PHE A 189      29.423  44.093  74.990  1.00 23.72           C  
ATOM   1185  CD1 PHE A 189      28.432  45.098  74.973  1.00 24.98           C  
ATOM   1186  CD2 PHE A 189      30.517  44.255  75.820  1.00 23.70           C  
ATOM   1187  CE1 PHE A 189      28.569  46.203  75.781  1.00 26.63           C  
ATOM   1188  CE2 PHE A 189      30.648  45.358  76.635  1.00 24.60           C  
ATOM   1189  CZ  PHE A 189      29.676  46.332  76.623  1.00 27.21           C  
ATOM   1190  N   TRP A 190      31.230  41.436  71.926  1.00 19.51           N  
ATOM   1191  CA  TRP A 190      31.633  40.281  71.154  1.00 18.62           C  
ATOM   1192  C   TRP A 190      31.048  38.988  71.642  1.00 18.21           C  
ATOM   1193  O   TRP A 190      30.654  38.121  70.836  1.00 19.66           O  
ATOM   1194  CB  TRP A 190      33.160  40.106  71.185  1.00 18.52           C  
ATOM   1195  CG  TRP A 190      33.910  41.173  70.551  1.00 21.04           C  
ATOM   1196  CD1 TRP A 190      34.594  42.191  71.159  1.00 21.06           C  
ATOM   1197  CD2 TRP A 190      34.070  41.350  69.162  1.00 21.40           C  
ATOM   1198  NE1 TRP A 190      35.169  43.003  70.213  1.00 21.95           N  
ATOM   1199  CE2 TRP A 190      34.855  42.503  68.973  1.00 26.40           C  
ATOM   1200  CE3 TRP A 190      33.628  40.642  68.044  1.00 27.95           C  
ATOM   1201  CZ2 TRP A 190      35.219  42.952  67.713  1.00 32.10           C  
ATOM   1202  CZ3 TRP A 190      33.978  41.094  66.796  1.00 32.29           C  
ATOM   1203  CH2 TRP A 190      34.775  42.234  66.637  1.00 28.69           C  
ATOM   1204  N   THR A 191      31.109  38.772  72.951  1.00 15.98           N  
ATOM   1205  CA  THR A 191      30.689  37.525  73.529  1.00 15.43           C  
ATOM   1206  C   THR A 191      29.256  37.538  74.039  1.00 15.76           C  
ATOM   1207  O   THR A 191      28.751  38.550  74.503  1.00 15.99           O  
ATOM   1208  CB  THR A 191      31.593  37.079  74.696  1.00 16.23           C  
ATOM   1209  OG1 THR A 191      31.509  38.012  75.784  1.00 15.35           O  
ATOM   1210  CG2 THR A 191      33.026  36.972  74.262  1.00 16.45           C  
ATOM   1211  N   GLU A 192      28.580  36.401  73.997  1.00 15.98           N  
ATOM   1212  CA  GLU A 192      27.240  36.327  74.537  1.00 17.85           C  
ATOM   1213  C   GLU A 192      27.198  36.616  76.037  1.00 19.83           C  
ATOM   1214  O   GLU A 192      26.261  37.242  76.534  1.00 18.12           O  
ATOM   1215  CB  GLU A 192      26.655  34.929  74.233  1.00 17.89           C  
ATOM   1216  CG  GLU A 192      25.240  34.727  74.752  1.00 22.61           C  
ATOM   1217  CD  GLU A 192      24.227  35.686  74.112  1.00 28.89           C  
ATOM   1218  OE1 GLU A 192      24.499  36.323  73.054  1.00 34.99           O  
ATOM   1219  OE2 GLU A 192      23.124  35.799  74.695  1.00 43.95           O  
ATOM   1220  N   THR A 193      28.178  36.143  76.776  1.00 17.48           N  
ATOM   1221  CA  THR A 193      28.229  36.402  78.196  1.00 16.56           C  
ATOM   1222  C   THR A 193      28.344  37.911  78.450  1.00 18.21           C  
ATOM   1223  O   THR A 193      27.608  38.435  79.313  1.00 17.87           O  
ATOM   1224  CB  THR A 193      29.388  35.652  78.875  1.00 15.90           C  
ATOM   1225  OG1 THR A 193      29.263  34.243  78.617  1.00 17.50           O  
ATOM   1226  CG2 THR A 193      29.493  35.936  80.357  1.00 17.79           C  
ATOM   1227  N   ALA A 194      29.211  38.625  77.728  1.00 18.14           N  
ATOM   1228  CA  ALA A 194      29.309  40.056  77.927  1.00 18.06           C  
ATOM   1229  C   ALA A 194      28.020  40.736  77.525  1.00 19.88           C  
ATOM   1230  O   ALA A 194      27.620  41.685  78.190  1.00 19.07           O  
ATOM   1231  CB  ALA A 194      30.483  40.662  77.159  1.00 17.82           C  
ATOM   1232  N   ARG A 195      27.377  40.289  76.443  1.00 18.96           N  
ATOM   1233  CA  ARG A 195      26.106  40.886  76.007  1.00 21.27           C  
ATOM   1234  C   ARG A 195      25.048  40.772  77.075  1.00 20.00           C  
ATOM   1235  O   ARG A 195      24.332  41.753  77.348  1.00 20.65           O  
ATOM   1236  CB  ARG A 195      25.589  40.238  74.730  1.00 22.17           C  
ATOM   1237  CG  ARG A 195      26.366  40.561  73.513  1.00 25.54           C  
ATOM   1238  CD  ARG A 195      25.525  40.211  72.299  1.00 37.70           C  
ATOM   1239  NE  ARG A 195      26.314  40.163  71.091  1.00 48.70           N  
ATOM   1240  CZ  ARG A 195      26.926  39.076  70.627  1.00 62.69           C  
ATOM   1241  NH1 ARG A 195      26.858  37.902  71.262  1.00 64.95           N  
ATOM   1242  NH2 ARG A 195      27.617  39.166  69.496  1.00 70.64           N  
ATOM   1243  N   LYS A 196      24.969  39.626  77.733  1.00 18.57           N  
ATOM   1244  CA  LYS A 196      24.013  39.425  78.816  1.00 21.66           C  
ATOM   1245  C   LYS A 196      24.349  40.310  80.011  1.00 22.70           C  
ATOM   1246  O   LYS A 196      23.464  40.870  80.633  1.00 22.79           O  
ATOM   1247  CB  LYS A 196      23.939  37.975  79.241  1.00 24.31           C  
ATOM   1248  CG  LYS A 196      23.271  37.093  78.175  1.00 29.69           C  
ATOM   1249  CD  LYS A 196      22.803  35.760  78.733  1.00 42.25           C  
ATOM   1250  CE  LYS A 196      23.937  34.864  79.202  1.00 51.49           C  
ATOM   1251  NZ  LYS A 196      24.777  34.363  78.074  1.00 61.86           N  
HETATM 1252  N   MSE A 197      25.631  40.410  80.349  0.50 19.78           N  
HETATM 1254  CA  MSE A 197      26.068  41.270  81.448  0.50 20.56           C  
HETATM 1256  C   MSE A 197      25.785  42.732  81.142  0.50 21.71           C  
HETATM 1258  O   MSE A 197      25.405  43.489  82.051  0.50 19.47           O  
HETATM 1260  CB  MSE A 197      27.559  41.059  81.728  0.50 21.36           C  
HETATM 1262  CG  MSE A 197      27.864  39.702  82.344  0.50 19.07           C  
HETATM 1264 SE   MSE A 197      29.776  39.257  82.355  0.37 15.09          SE  
HETATM 1266  CE  MSE A 197      30.448  40.176  83.913  0.50 20.94           C  
ATOM   1268  N   ALA A 198      25.983  43.137  79.886  1.00 21.15           N  
ATOM   1269  CA  ALA A 198      25.737  44.490  79.443  1.00 21.97           C  
ATOM   1270  C   ALA A 198      24.236  44.791  79.517  1.00 25.00           C  
ATOM   1271  O   ALA A 198      23.840  45.858  79.994  1.00 23.56           O  
ATOM   1272  CB  ALA A 198      26.228  44.697  78.045  1.00 21.22           C  
ATOM   1273  N   GLU A 199      23.411  43.844  79.070  1.00 23.67           N  
ATOM   1274  CA  GLU A 199      21.963  44.021  79.135  1.00 25.63           C  
ATOM   1275  C   GLU A 199      21.493  44.203  80.576  1.00 23.79           C  
ATOM   1276  O   GLU A 199      20.674  45.070  80.881  1.00 24.36           O  
ATOM   1277  CB  GLU A 199      21.266  42.806  78.518  1.00 25.12           C  
ATOM   1278  CG  GLU A 199      19.752  42.886  78.516  1.00 35.16           C  
ATOM   1279  N   ASP A 200      22.018  43.386  81.466  1.00 19.57           N  
ATOM   1280  CA  ASP A 200      21.682  43.431  82.856  1.00 20.95           C  
ATOM   1281  C   ASP A 200      22.124  44.773  83.488  1.00 20.24           C  
ATOM   1282  O   ASP A 200      21.325  45.460  84.166  1.00 20.57           O  
ATOM   1283  CB  ASP A 200      22.366  42.266  83.518  1.00 19.79           C  
ATOM   1284  CG  ASP A 200      22.158  42.211  84.993  1.00 25.94           C  
ATOM   1285  OD1 ASP A 200      20.988  42.177  85.469  1.00 26.19           O  
ATOM   1286  OD2 ASP A 200      23.174  42.151  85.713  1.00 26.39           O  
ATOM   1287  N   ARG A 201      23.382  45.145  83.287  1.00 20.54           N  
ATOM   1288  CA  ARG A 201      23.855  46.412  83.824  1.00 22.01           C  
ATOM   1289  C   ARG A 201      23.116  47.608  83.241  1.00 22.94           C  
ATOM   1290  O   ARG A 201      22.792  48.541  83.986  1.00 22.24           O  
ATOM   1291  CB  ARG A 201      25.344  46.570  83.580  1.00 21.52           C  
ATOM   1292  CG  ARG A 201      26.140  45.630  84.415  1.00 17.98           C  
ATOM   1293  CD  ARG A 201      27.597  45.844  84.102  1.00 21.10           C  
ATOM   1294  NE  ARG A 201      28.446  44.938  84.855  1.00 19.88           N  
ATOM   1295  CZ  ARG A 201      29.743  45.132  85.063  1.00 20.03           C  
ATOM   1296  NH1 ARG A 201      30.339  46.230  84.634  1.00 19.42           N  
ATOM   1297  NH2 ARG A 201      30.421  44.280  85.815  1.00 18.75           N  
ATOM   1298  N   TYR A 202      22.854  47.614  81.939  1.00 22.34           N  
ATOM   1299  CA  TYR A 202      22.161  48.701  81.269  1.00 25.42           C  
ATOM   1300  C   TYR A 202      20.719  48.848  81.805  1.00 23.19           C  
ATOM   1301  O   TYR A 202      20.242  49.963  82.035  1.00 23.52           O  
ATOM   1302  CB  TYR A 202      22.166  48.437  79.768  1.00 27.20           C  
ATOM   1303  CG  TYR A 202      21.623  49.563  78.937  1.00 36.18           C  
ATOM   1304  CD1 TYR A 202      20.266  49.648  78.641  1.00 35.12           C  
ATOM   1305  CD2 TYR A 202      22.460  50.553  78.462  1.00 48.36           C  
ATOM   1306  CE1 TYR A 202      19.761  50.687  77.891  1.00 43.76           C  
ATOM   1307  CE2 TYR A 202      21.965  51.599  77.703  1.00 51.98           C  
ATOM   1308  CZ  TYR A 202      20.614  51.660  77.423  1.00 47.18           C  
ATOM   1309  OH  TYR A 202      20.117  52.709  76.669  1.00 52.02           O  
ATOM   1310  N   SER A 203      20.033  47.729  81.997  0.50 20.53           N  
ATOM   1312  CA  SER A 203      18.674  47.769  82.540  0.50 22.08           C  
ATOM   1314  C   SER A 203      18.663  48.281  83.994  0.50 21.52           C  
ATOM   1316  O   SER A 203      17.654  48.844  84.449  0.50 19.81           O  
ATOM   1318  CB  SER A 203      18.004  46.411  82.436  0.50 23.45           C  
ATOM   1320  OG  SER A 203      17.862  46.049  81.083  0.50 27.87           O  
ATOM   1322  N   PHE A 204      19.745  48.040  84.737  1.00 21.15           N  
ATOM   1323  CA  PHE A 204      19.878  48.589  86.082  1.00 21.41           C  
ATOM   1324  C   PHE A 204      20.101  50.096  86.009  1.00 20.57           C  
ATOM   1325  O   PHE A 204      19.479  50.863  86.779  1.00 21.62           O  
ATOM   1326  CB  PHE A 204      21.005  47.898  86.887  1.00 19.55           C  
ATOM   1327  CG  PHE A 204      21.121  48.415  88.290  1.00 18.94           C  
ATOM   1328  CD1 PHE A 204      20.169  48.067  89.208  1.00 18.76           C  
ATOM   1329  CD2 PHE A 204      22.095  49.319  88.642  1.00 20.71           C  
ATOM   1330  CE1 PHE A 204      20.221  48.546  90.503  1.00 20.83           C  
ATOM   1331  CE2 PHE A 204      22.149  49.817  89.966  1.00 19.40           C  
ATOM   1332  CZ  PHE A 204      21.198  49.434  90.861  1.00 21.51           C  
ATOM   1333  N   VAL A 205      20.944  50.536  85.093  1.00 19.65           N  
ATOM   1334  CA  VAL A 205      21.199  51.958  84.896  1.00 20.66           C  
ATOM   1335  C   VAL A 205      19.912  52.690  84.500  1.00 22.80           C  
ATOM   1336  O   VAL A 205      19.639  53.770  85.038  1.00 21.29           O  
ATOM   1337  CB  VAL A 205      22.334  52.215  83.891  1.00 22.24           C  
ATOM   1338  CG1 VAL A 205      22.483  53.709  83.605  1.00 24.15           C  
ATOM   1339  CG2 VAL A 205      23.647  51.634  84.409  1.00 19.99           C  
ATOM   1340  N   VAL A 206      19.118  52.100  83.610  1.00 23.29           N  
ATOM   1341  CA  VAL A 206      17.861  52.706  83.177  1.00 26.11           C  
ATOM   1342  C   VAL A 206      16.919  52.850  84.365  1.00 24.58           C  
ATOM   1343  O   VAL A 206      16.352  53.931  84.587  1.00 24.05           O  
ATOM   1344  CB  VAL A 206      17.208  51.920  82.012  1.00 26.02           C  
ATOM   1345  CG1 VAL A 206      15.780  52.387  81.774  1.00 33.26           C  
ATOM   1346  CG2 VAL A 206      18.068  52.045  80.751  1.00 27.55           C  
ATOM   1347  N   GLU A 207      16.760  51.781  85.138  1.00 22.52           N  
ATOM   1348  CA  GLU A 207      15.939  51.841  86.335  1.00 23.91           C  
ATOM   1349  C   GLU A 207      16.427  52.930  87.304  1.00 22.79           C  
ATOM   1350  O   GLU A 207      15.611  53.654  87.892  1.00 19.97           O  
ATOM   1351  CB  GLU A 207      15.907  50.513  87.062  1.00 25.85           C  
ATOM   1352  CG  GLU A 207      14.990  50.540  88.311  1.00 27.90           C  
ATOM   1353  CD  GLU A 207      14.838  49.205  88.976  1.00 31.66           C  
ATOM   1354  OE1 GLU A 207      15.246  48.180  88.381  1.00 47.13           O  
ATOM   1355  OE2 GLU A 207      14.336  49.153  90.108  1.00 28.35           O  
ATOM   1356  N   PHE A 208      17.737  53.048  87.483  1.00 20.17           N  
ATOM   1357  CA  PHE A 208      18.290  54.082  88.345  1.00 18.29           C  
ATOM   1358  C   PHE A 208      17.829  55.464  87.872  1.00 19.75           C  
ATOM   1359  O   PHE A 208      17.390  56.286  88.692  1.00 19.06           O  
ATOM   1360  CB  PHE A 208      19.820  54.051  88.394  1.00 17.24           C  
ATOM   1361  CG  PHE A 208      20.396  54.998  89.415  1.00 17.07           C  
ATOM   1362  CD1 PHE A 208      20.524  56.342  89.129  1.00 21.17           C  
ATOM   1363  CD2 PHE A 208      20.760  54.548  90.678  1.00 22.13           C  
ATOM   1364  CE1 PHE A 208      21.010  57.215  90.092  1.00 17.93           C  
ATOM   1365  CE2 PHE A 208      21.252  55.411  91.615  1.00 20.13           C  
ATOM   1366  CZ  PHE A 208      21.367  56.737  91.332  1.00 18.91           C  
ATOM   1367  N   VAL A 209      17.946  55.724  86.578  1.00 20.93           N  
ATOM   1368  CA  VAL A 209      17.572  57.018  86.002  1.00 23.77           C  
ATOM   1369  C   VAL A 209      16.077  57.274  86.152  1.00 25.46           C  
ATOM   1370  O   VAL A 209      15.656  58.364  86.521  1.00 24.87           O  
ATOM   1371  CB  VAL A 209      17.983  57.116  84.524  1.00 26.15           C  
ATOM   1372  CG1 VAL A 209      17.417  58.384  83.882  1.00 28.00           C  
ATOM   1373  CG2 VAL A 209      19.473  57.127  84.390  1.00 26.54           C  
ATOM   1374  N   GLN A 210      15.282  56.270  85.865  1.00 22.98           N  
ATOM   1375  CA  GLN A 210      13.852  56.398  85.978  1.00 25.43           C  
ATOM   1376  C   GLN A 210      13.470  56.747  87.397  1.00 24.77           C  
ATOM   1377  O   GLN A 210      12.636  57.645  87.604  1.00 27.63           O  
ATOM   1378  CB  GLN A 210      13.164  55.120  85.519  1.00 26.16           C  
ATOM   1379  CG  GLN A 210      13.268  54.903  84.018  1.00 32.91           C  
ATOM   1380  CD  GLN A 210      12.732  53.554  83.576  1.00 34.54           C  
ATOM   1381  OE1 GLN A 210      12.638  52.618  84.374  1.00 48.57           O  
ATOM   1382  NE2 GLN A 210      12.392  53.442  82.294  1.00 45.48           N  
ATOM   1383  N   ARG A 211      14.054  56.042  88.369  1.00 21.30           N  
ATOM   1384  CA  ARG A 211      13.782  56.285  89.768  1.00 20.73           C  
ATOM   1385  C   ARG A 211      14.240  57.662  90.199  1.00 20.72           C  
ATOM   1386  O   ARG A 211      13.527  58.337  90.919  1.00 20.20           O  
ATOM   1387  CB  ARG A 211      14.437  55.224  90.669  1.00 21.40           C  
ATOM   1388  CG  ARG A 211      13.769  53.880  90.631  1.00 19.51           C  
ATOM   1389  CD  ARG A 211      14.495  52.872  91.520  1.00 20.15           C  
ATOM   1390  NE  ARG A 211      13.772  51.622  91.482  1.00 20.45           N  
ATOM   1391  CZ  ARG A 211      12.732  51.336  92.252  1.00 22.19           C  
ATOM   1392  NH1 ARG A 211      12.271  52.218  93.140  1.00 27.86           N  
ATOM   1393  NH2 ARG A 211      12.111  50.165  92.103  1.00 23.83           N  
ATOM   1394  N   PHE A 212      15.435  58.060  89.781  1.00 18.77           N  
ATOM   1395  CA  PHE A 212      15.979  59.376  90.077  1.00 19.49           C  
ATOM   1396  C   PHE A 212      14.992  60.450  89.628  1.00 22.62           C  
ATOM   1397  O   PHE A 212      14.622  61.332  90.410  1.00 22.81           O  
ATOM   1398  CB  PHE A 212      17.332  59.570  89.376  1.00 21.38           C  
ATOM   1399  CG  PHE A 212      18.072  60.796  89.797  1.00 21.47           C  
ATOM   1400  CD1 PHE A 212      17.781  62.011  89.219  1.00 28.42           C  
ATOM   1401  CD2 PHE A 212      19.053  60.739  90.745  1.00 18.15           C  
ATOM   1402  CE1 PHE A 212      18.472  63.148  89.600  1.00 30.74           C  
ATOM   1403  CE2 PHE A 212      19.736  61.868  91.151  1.00 21.83           C  
ATOM   1404  CZ  PHE A 212      19.458  63.069  90.570  1.00 26.60           C  
ATOM   1405  N   LEU A 213      14.562  60.345  88.390  1.00 24.33           N  
ATOM   1406  CA  LEU A 213      13.618  61.323  87.845  1.00 28.15           C  
ATOM   1407  C   LEU A 213      12.260  61.297  88.535  1.00 27.89           C  
ATOM   1408  O   LEU A 213      11.687  62.355  88.808  1.00 28.29           O  
ATOM   1409  CB  LEU A 213      13.448  61.088  86.355  1.00 27.01           C  
ATOM   1410  CG  LEU A 213      14.696  61.386  85.517  1.00 32.98           C  
ATOM   1411  CD1 LEU A 213      14.483  60.926  84.098  1.00 36.28           C  
ATOM   1412  CD2 LEU A 213      15.059  62.856  85.550  1.00 32.34           C  
ATOM   1413  N   ALA A 214      11.739  60.109  88.814  1.00 24.98           N  
ATOM   1414  CA  ALA A 214      10.468  59.995  89.502  1.00 25.93           C  
ATOM   1415  C   ALA A 214      10.549  60.594  90.906  1.00 27.47           C  
ATOM   1416  O   ALA A 214       9.619  61.289  91.344  1.00 27.55           O  
ATOM   1417  CB  ALA A 214      10.011  58.574  89.580  1.00 27.27           C  
ATOM   1418  N   GLU A 215      11.640  60.334  91.621  1.00 23.85           N  
ATOM   1419  CA  GLU A 215      11.816  60.863  92.970  1.00 26.20           C  
ATOM   1420  C   GLU A 215      12.094  62.352  93.006  1.00 29.27           C  
ATOM   1421  O   GLU A 215      11.715  63.033  93.953  1.00 29.77           O  
ATOM   1422  CB  GLU A 215      13.000  60.182  93.654  1.00 23.99           C  
ATOM   1423  CG  GLU A 215      12.825  58.683  93.946  1.00 24.07           C  
ATOM   1424  CD  GLU A 215      14.130  58.007  94.351  1.00 25.99           C  
ATOM   1425  OE1 GLU A 215      15.070  58.723  94.768  1.00 23.89           O  
ATOM   1426  OE2 GLU A 215      14.196  56.750  94.264  1.00 26.46           O  
ATOM   1427  N   TRP A 216      12.794  62.850  91.995  1.00 34.32           N  
ATOM   1428  CA  TRP A 216      13.186  64.250  91.963  1.00 37.39           C  
ATOM   1429  C   TRP A 216      11.963  65.146  91.800  1.00 40.04           C  
ATOM   1430  O   TRP A 216      11.952  66.275  92.306  1.00 40.38           O  
ATOM   1431  CB  TRP A 216      14.221  64.480  90.864  1.00 38.90           C  
ATOM   1432  CG  TRP A 216      14.867  65.815  90.926  1.00 43.58           C  
ATOM   1433  CD1 TRP A 216      14.469  66.952  90.278  1.00 46.63           C  
ATOM   1434  CD2 TRP A 216      16.036  66.162  91.671  1.00 45.35           C  
ATOM   1435  NE1 TRP A 216      15.325  67.993  90.573  1.00 44.24           N  
ATOM   1436  CE2 TRP A 216      16.295  67.535  91.430  1.00 49.59           C  
ATOM   1437  CE3 TRP A 216      16.882  65.457  92.530  1.00 45.52           C  
ATOM   1438  CZ2 TRP A 216      17.368  68.214  92.023  1.00 46.00           C  
ATOM   1439  CZ3 TRP A 216      17.956  66.131  93.120  1.00 46.14           C  
ATOM   1440  CH2 TRP A 216      18.188  67.498  92.861  1.00 45.90           C  
ATOM   1441  N   GLY A 217      10.936  64.622  91.131  1.00 41.61           N  
ATOM   1442  CA  GLY A 217       9.671  65.330  90.915  1.00 43.55           C  
ATOM   1443  C   GLY A 217       9.696  66.132  89.633  1.00 46.13           C  
ATOM   1444  O   GLY A 217      10.762  66.568  89.191  1.00 47.16           O  
TER    1445      GLY A 217                                                      
END
MOLECULE T0470.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
