
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 ( 1627),  selected  107 , name 2cof_A
# Molecule2: number of CA atoms   50 (  770),  selected   50 , name T0472_52_101.pdb
# PARAMETERS: 2cof_A.T0472_52_101.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    L     8_A      -       -           -
LGA    E     9_A      -       -           -
LGA    T    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    Y    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    N    15_A      -       -           -
LGA    V    16_A      -       -           -
LGA    L    17_A      -       -           -
LGA    V    18_A      -       -           -
LGA    N    19_A      -       -           -
LGA    S    20_A      -       -           -
LGA    Q    21_A      -       -           -
LGA    W    22_A      -       -           -
LGA    K    23_A      -       -           -
LGA    S    24_A      -       -           -
LGA    R    25_A      -       -           -
LGA    W    26_A      -       -           -
LGA    C    27_A      -       -           -
LGA    S    28_A      -       -           -
LGA    V    29_A      -       -           -
LGA    R    30_A      -       -           -
LGA    D    31_A      -       -           -
LGA    N    32_A      -       -           -
LGA    H    33_A      -       -           -
LGA    L    34_A      -       -           -
LGA    H    35_A      -       -           -
LGA    F    36_A      -       -           -
LGA    Y    37_A      -       -           -
LGA    Q    38_A      -       -           -
LGA    D    39_A      -       -           -
LGA    R    40_A      -       -           -
LGA    N    41_A      -       -           -
LGA    R    42_A      -       -           -
LGA    S    43_A      -       -           -
LGA    K    44_A      -       -           -
LGA    V    45_A      -       -           -
LGA    A    46_A      -       -           -
LGA    Q    47_A      -       -           -
LGA    Q    48_A      -       -           -
LGA    P    49_A      -       -           -
LGA    L    50_A      -       -           -
LGA    S    51_A      -       -           -
LGA    L    52_A      -       -           -
LGA    V    53_A      -       -           -
LGA    G    54_A      -       -           -
LGA    C    55_A      -       -           -
LGA    E    56_A      I      52           #
LGA    -       -      E      53           -
LGA    -       -      A      54           -
LGA    -       -      R      55           -
LGA    V    57_A      Y      56          3.661
LGA    V    58_A      A      57          2.939
LGA    P    59_A      K      58          1.569
LGA    D    60_A      E      59          1.973
LGA    P    61_A      V      60          1.894
LGA    S    62_A      A      61          2.092
LGA    P    63_A      K      62          1.923
LGA    D    64_A      N      63          2.216
LGA    H    65_A      D      64          2.770
LGA    L    66_A      K      65          4.126
LGA    Y    67_A      P      66          1.159
LGA    S    68_A      Y      67          1.014
LGA    F    69_A      F      68          1.072
LGA    R    70_A      N      69          1.144
LGA    I    71_A      L      70          1.540
LGA    L    72_A      K      71          1.538
LGA    H    73_A      A      72          1.803
LGA    K    74_A      A      73          1.815
LGA    -       -      N      74           -
LGA    G    75_A      H      75          1.787
LGA    E    76_A      Q      76          1.044
LGA    E    77_A      I      77          0.223
LGA    L    78_A      I      78          1.664
LGA    A    79_A      G      79          2.759
LGA    K    80_A      T      80          1.827
LGA    L    81_A      S      81          1.661
LGA    E    82_A      Q      82          2.780
LGA    -       -      M      83           -
LGA    A    83_A      Y      84          1.053
LGA    K    84_A      S      85          1.606
LGA    S    85_A      S      86          1.534
LGA    S    86_A      T      87          1.388
LGA    E    87_A      A      88          1.703
LGA    E    88_A      A      89          0.976
LGA    M    89_A      R      90          0.725
LGA    G    90_A      D      91          1.502
LGA    H    91_A      N      92          1.113
LGA    W    92_A      G      93          0.887
LGA    L    93_A      I      94          1.251
LGA    G    94_A      K      95          1.692
LGA    L    95_A      S      96          1.413
LGA    L    96_A      V      97          0.938
LGA    L    97_A      M      98          2.401
LGA    S    98_A      E      99          3.258
LGA    E    99_A      N     100          3.691
LGA    S   100_A      G     101          4.132
LGA    G   101_A      -       -           -
LGA    S   102_A      -       -           -
LGA    G   103_A      -       -           -
LGA    P   104_A      -       -           -
LGA    S   105_A      -       -           -
LGA    S   106_A      -       -           -
LGA    G   107_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107   50    5.0     44    2.05     4.55     77.706     2.044

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.406332 * X  +  -0.477457 * Y  +   0.779056 * Z  +   1.348939
  Y_new =  -0.273175 * X  +   0.877098 * Y  +   0.395063 * Z  +   0.455901
  Z_new =  -0.871934 * X  +  -0.052292 * Y  +  -0.486823 * Z  +  -0.644555 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.034588    0.107004  [ DEG:  -173.8691      6.1309 ]
  Theta =   1.059139    2.082453  [ DEG:    60.6842    119.3158 ]
  Phi   =  -2.549704    0.591889  [ DEG:  -146.0873     33.9127 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cof_A                                        
REMARK     2: T0472_52_101.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cof_A.T0472_52_101.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107   50   5.0   44   2.05    4.55  77.706
REMARK  ---------------------------------------------------------- 
MOLECULE 2cof_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   17-MAY-05   2COF              
TITLE     SOLUTION STRUCTURE OF THE C-TERMINAL PH DOMAIN OF                     
TITLE    2 HYPOTHETICAL PROTEIN KIAA1914 FROM HUMAN                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN KIAA1914;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PH DOMAIN;                                                 
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KIAA1914;                                                      
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040921-07;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    HYPOTHETICAL PROTEIN KIAA1914, PH DOMAIN, STRUCTURAL                  
KEYWDS   2 GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   3 RSGI, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND             
KEYWDS   4 FUNCTIONAL ANALYSES                                                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN              
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   17-NOV-05 2COF    0                                                
JRNL        AUTH   H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA           
JRNL        TITL   SOLUTION STRUCTURE OF THE C-TERMINAL PH DOMAIN OF            
JRNL        TITL 2 HYPOTHETICAL PROTEIN KIAA1914 FROM HUMAN                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2COF A    8   101  UNP    Q8N4X5   K1914_HUMAN    354    447             
SEQRES   1 A  107  GLY SER SER GLY SER SER GLY LEU GLU THR SER SER TYR          
SEQRES   2 A  107  LEU ASN VAL LEU VAL ASN SER GLN TRP LYS SER ARG TRP          
SEQRES   3 A  107  CYS SER VAL ARG ASP ASN HIS LEU HIS PHE TYR GLN ASP          
SEQRES   4 A  107  ARG ASN ARG SER LYS VAL ALA GLN GLN PRO LEU SER LEU          
SEQRES   5 A  107  VAL GLY CYS GLU VAL VAL PRO ASP PRO SER PRO ASP HIS          
SEQRES   6 A  107  LEU TYR SER PHE ARG ILE LEU HIS LYS GLY GLU GLU LEU          
SEQRES   7 A  107  ALA LYS LEU GLU ALA LYS SER SER GLU GLU MET GLY HIS          
SEQRES   8 A  107  TRP LEU GLY LEU LEU LEU SER GLU SER GLY SER GLY PRO          
SEQRES   9 A  107  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      18.568  -1.549  11.237  1.00  0.00           N  
ATOM      2  CA  GLY A   1      19.536  -2.361  11.950  1.00  0.00           C  
ATOM      3  C   GLY A   1      20.965  -1.935  11.676  1.00  0.00           C  
ATOM      4  O   GLY A   1      21.603  -1.298  12.514  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      19.346  -2.282  13.010  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      19.417  -3.391  11.648  1.00  0.00           H  
ATOM      7  H1  GLY A   1      18.773  -0.612  11.033  1.00  0.00           H  
ATOM      8  N   SER A   2      21.471  -2.287  10.498  1.00  0.00           N  
ATOM      9  CA  SER A   2      22.835  -1.942  10.116  1.00  0.00           C  
ATOM     10  C   SER A   2      22.903  -0.517   9.573  1.00  0.00           C  
ATOM     11  O   SER A   2      22.533  -0.260   8.427  1.00  0.00           O  
ATOM     12  CB  SER A   2      23.359  -2.925   9.068  1.00  0.00           C  
ATOM     13  OG  SER A   2      23.751  -4.149   9.668  1.00  0.00           O  
ATOM     14  H   SER A   2      20.912  -2.794   9.871  1.00  0.00           H  
ATOM     15  HA  SER A   2      23.452  -2.008  10.999  1.00  0.00           H  
ATOM     16  HB2 SER A   2      22.583  -3.126   8.347  1.00  0.00           H  
ATOM     17  HB3 SER A   2      24.214  -2.493   8.568  1.00  0.00           H  
ATOM     18  HG  SER A   2      23.190  -4.858   9.347  1.00  0.00           H  
ATOM     19  N   SER A   3      23.379   0.404  10.403  1.00  0.00           N  
ATOM     20  CA  SER A   3      23.493   1.804  10.009  1.00  0.00           C  
ATOM     21  C   SER A   3      24.838   2.072   9.340  1.00  0.00           C  
ATOM     22  O   SER A   3      25.824   2.380  10.008  1.00  0.00           O  
ATOM     23  CB  SER A   3      23.325   2.714  11.227  1.00  0.00           C  
ATOM     24  OG  SER A   3      23.586   4.066  10.892  1.00  0.00           O  
ATOM     25  H   SER A   3      23.658   0.136  11.304  1.00  0.00           H  
ATOM     26  HA  SER A   3      22.705   2.013   9.301  1.00  0.00           H  
ATOM     27  HB2 SER A   3      22.313   2.635  11.594  1.00  0.00           H  
ATOM     28  HB3 SER A   3      24.013   2.407  12.000  1.00  0.00           H  
ATOM     29  HG  SER A   3      23.456   4.618  11.666  1.00  0.00           H  
ATOM     30  N   GLY A   4      24.870   1.951   8.017  1.00  0.00           N  
ATOM     31  CA  GLY A   4      26.098   2.183   7.280  1.00  0.00           C  
ATOM     32  C   GLY A   4      26.091   1.518   5.917  1.00  0.00           C  
ATOM     33  O   GLY A   4      27.096   0.951   5.491  1.00  0.00           O  
ATOM     34  H   GLY A   4      24.052   1.701   7.537  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      26.231   3.247   7.149  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      26.927   1.794   7.853  1.00  0.00           H  
ATOM     37  N   SER A   5      24.953   1.587   5.233  1.00  0.00           N  
ATOM     38  CA  SER A   5      24.818   0.982   3.913  1.00  0.00           C  
ATOM     39  C   SER A   5      24.029   1.893   2.977  1.00  0.00           C  
ATOM     40  O   SER A   5      22.820   2.065   3.133  1.00  0.00           O  
ATOM     41  CB  SER A   5      24.128  -0.379   4.021  1.00  0.00           C  
ATOM     42  OG  SER A   5      24.221  -1.095   2.802  1.00  0.00           O  
ATOM     43  H   SER A   5      24.187   2.053   5.627  1.00  0.00           H  
ATOM     44  HA  SER A   5      25.809   0.842   3.509  1.00  0.00           H  
ATOM     45  HB2 SER A   5      24.598  -0.958   4.801  1.00  0.00           H  
ATOM     46  HB3 SER A   5      23.085  -0.232   4.260  1.00  0.00           H  
ATOM     47  HG  SER A   5      23.645  -1.863   2.837  1.00  0.00           H  
ATOM     48  N   SER A   6      24.722   2.473   2.003  1.00  0.00           N  
ATOM     49  CA  SER A   6      24.089   3.369   1.043  1.00  0.00           C  
ATOM     50  C   SER A   6      23.616   2.601  -0.188  1.00  0.00           C  
ATOM     51  O   SER A   6      24.179   1.566  -0.541  1.00  0.00           O  
ATOM     52  CB  SER A   6      25.061   4.475   0.626  1.00  0.00           C  
ATOM     53  OG  SER A   6      25.348   5.338   1.712  1.00  0.00           O  
ATOM     54  H   SER A   6      25.683   2.296   1.929  1.00  0.00           H  
ATOM     55  HA  SER A   6      23.232   3.818   1.523  1.00  0.00           H  
ATOM     56  HB2 SER A   6      25.982   4.030   0.283  1.00  0.00           H  
ATOM     57  HB3 SER A   6      24.621   5.055  -0.172  1.00  0.00           H  
ATOM     58  HG  SER A   6      25.956   4.903   2.315  1.00  0.00           H  
ATOM     59  N   GLY A   7      22.577   3.118  -0.838  1.00  0.00           N  
ATOM     60  CA  GLY A   7      22.046   2.468  -2.022  1.00  0.00           C  
ATOM     61  C   GLY A   7      20.736   1.754  -1.753  1.00  0.00           C  
ATOM     62  O   GLY A   7      20.602   0.561  -2.029  1.00  0.00           O  
ATOM     63  H   GLY A   7      22.168   3.946  -0.510  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      21.887   3.213  -2.788  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      22.768   1.748  -2.378  1.00  0.00           H  
ATOM     66  N   LEU A   8      19.768   2.484  -1.211  1.00  0.00           N  
ATOM     67  CA  LEU A   8      18.461   1.913  -0.903  1.00  0.00           C  
ATOM     68  C   LEU A   8      17.427   2.323  -1.947  1.00  0.00           C  
ATOM     69  O   LEU A   8      16.664   1.492  -2.438  1.00  0.00           O  
ATOM     70  CB  LEU A   8      18.003   2.358   0.487  1.00  0.00           C  
ATOM     71  CG  LEU A   8      16.937   1.487   1.153  1.00  0.00           C  
ATOM     72  CD1 LEU A   8      16.955   1.682   2.662  1.00  0.00           C  
ATOM     73  CD2 LEU A   8      15.559   1.805   0.590  1.00  0.00           C  
ATOM     74  H   LEU A   8      19.933   3.429  -1.013  1.00  0.00           H  
ATOM     75  HA  LEU A   8      18.558   0.837  -0.914  1.00  0.00           H  
ATOM     76  HB2 LEU A   8      18.868   2.372   1.132  1.00  0.00           H  
ATOM     77  HB3 LEU A   8      17.606   3.359   0.398  1.00  0.00           H  
ATOM     78  HG  LEU A   8      17.152   0.447   0.949  1.00  0.00           H  
ATOM     79 HD11 LEU A   8      16.182   1.078   3.111  1.00  0.00           H  
ATOM     80 HD12 LEU A   8      16.780   2.722   2.892  1.00  0.00           H  
ATOM     81 HD13 LEU A   8      17.918   1.384   3.051  1.00  0.00           H  
ATOM     82 HD21 LEU A   8      14.843   1.090   0.966  1.00  0.00           H  
ATOM     83 HD22 LEU A   8      15.590   1.748  -0.490  1.00  0.00           H  
ATOM     84 HD23 LEU A   8      15.269   2.800   0.891  1.00  0.00           H  
ATOM     85  N   GLU A   9      17.410   3.609  -2.282  1.00  0.00           N  
ATOM     86  CA  GLU A   9      16.471   4.129  -3.268  1.00  0.00           C  
ATOM     87  C   GLU A   9      15.042   3.707  -2.935  1.00  0.00           C  
ATOM     88  O   GLU A   9      14.268   3.341  -3.820  1.00  0.00           O  
ATOM     89  CB  GLU A   9      16.845   3.639  -4.669  1.00  0.00           C  
ATOM     90  CG  GLU A   9      18.232   4.069  -5.113  1.00  0.00           C  
ATOM     91  CD  GLU A   9      19.333   3.445  -4.278  1.00  0.00           C  
ATOM     92  OE1 GLU A   9      19.559   2.224  -4.411  1.00  0.00           O  
ATOM     93  OE2 GLU A   9      19.967   4.177  -3.491  1.00  0.00           O  
ATOM     94  H   GLU A   9      18.043   4.223  -1.855  1.00  0.00           H  
ATOM     95  HA  GLU A   9      16.529   5.207  -3.247  1.00  0.00           H  
ATOM     96  HB2 GLU A   9      16.803   2.560  -4.683  1.00  0.00           H  
ATOM     97  HB3 GLU A   9      16.126   4.027  -5.377  1.00  0.00           H  
ATOM     98  HG2 GLU A   9      18.373   3.777  -6.144  1.00  0.00           H  
ATOM     99  HG3 GLU A   9      18.306   5.144  -5.032  1.00  0.00           H  
ATOM    100  N   THR A  10      14.700   3.761  -1.652  1.00  0.00           N  
ATOM    101  CA  THR A  10      13.367   3.383  -1.199  1.00  0.00           C  
ATOM    102  C   THR A  10      12.809   2.234  -2.033  1.00  0.00           C  
ATOM    103  O   THR A  10      11.622   2.211  -2.359  1.00  0.00           O  
ATOM    104  CB  THR A  10      12.392   4.574  -1.270  1.00  0.00           C  
ATOM    105  OG1 THR A  10      12.290   5.045  -2.618  1.00  0.00           O  
ATOM    106  CG2 THR A  10      12.855   5.705  -0.364  1.00  0.00           C  
ATOM    107  H   THR A  10      15.362   4.061  -0.994  1.00  0.00           H  
ATOM    108  HA  THR A  10      13.441   3.065  -0.170  1.00  0.00           H  
ATOM    109  HB  THR A  10      11.418   4.242  -0.938  1.00  0.00           H  
ATOM    110  HG1 THR A  10      11.749   4.439  -3.129  1.00  0.00           H  
ATOM    111 HG21 THR A  10      12.407   6.632  -0.690  1.00  0.00           H  
ATOM    112 HG22 THR A  10      13.929   5.788  -0.412  1.00  0.00           H  
ATOM    113 HG23 THR A  10      12.554   5.498   0.652  1.00  0.00           H  
ATOM    114  N   SER A  11      13.672   1.283  -2.374  1.00  0.00           N  
ATOM    115  CA  SER A  11      13.265   0.132  -3.172  1.00  0.00           C  
ATOM    116  C   SER A  11      13.725  -1.169  -2.522  1.00  0.00           C  
ATOM    117  O   SER A  11      14.217  -2.073  -3.198  1.00  0.00           O  
ATOM    118  CB  SER A  11      13.836   0.239  -4.587  1.00  0.00           C  
ATOM    119  OG  SER A  11      15.245   0.084  -4.581  1.00  0.00           O  
ATOM    120  H   SER A  11      14.605   1.359  -2.084  1.00  0.00           H  
ATOM    121  HA  SER A  11      12.186   0.131  -3.227  1.00  0.00           H  
ATOM    122  HB2 SER A  11      13.404  -0.532  -5.206  1.00  0.00           H  
ATOM    123  HB3 SER A  11      13.593   1.209  -4.998  1.00  0.00           H  
ATOM    124  HG  SER A  11      15.485  -0.634  -3.992  1.00  0.00           H  
ATOM    125  N   SER A  12      13.561  -1.256  -1.206  1.00  0.00           N  
ATOM    126  CA  SER A  12      13.963  -2.445  -0.463  1.00  0.00           C  
ATOM    127  C   SER A  12      12.900  -3.534  -0.566  1.00  0.00           C  
ATOM    128  O   SER A  12      11.743  -3.261  -0.886  1.00  0.00           O  
ATOM    129  CB  SER A  12      14.211  -2.095   1.005  1.00  0.00           C  
ATOM    130  OG  SER A  12      15.405  -1.347   1.157  1.00  0.00           O  
ATOM    131  H   SER A  12      13.164  -0.502  -0.723  1.00  0.00           H  
ATOM    132  HA  SER A  12      14.881  -2.813  -0.897  1.00  0.00           H  
ATOM    133  HB2 SER A  12      13.385  -1.509   1.378  1.00  0.00           H  
ATOM    134  HB3 SER A  12      14.295  -3.006   1.581  1.00  0.00           H  
ATOM    135  HG  SER A  12      15.591  -0.872   0.344  1.00  0.00           H  
ATOM    136  N   TYR A  13      13.301  -4.771  -0.291  1.00  0.00           N  
ATOM    137  CA  TYR A  13      12.385  -5.903  -0.354  1.00  0.00           C  
ATOM    138  C   TYR A  13      11.460  -5.923   0.858  1.00  0.00           C  
ATOM    139  O   TYR A  13      11.905  -5.770   1.996  1.00  0.00           O  
ATOM    140  CB  TYR A  13      13.167  -7.216  -0.435  1.00  0.00           C  
ATOM    141  CG  TYR A  13      13.536  -7.614  -1.845  1.00  0.00           C  
ATOM    142  CD1 TYR A  13      12.568  -7.713  -2.836  1.00  0.00           C  
ATOM    143  CD2 TYR A  13      14.854  -7.893  -2.187  1.00  0.00           C  
ATOM    144  CE1 TYR A  13      12.901  -8.077  -4.127  1.00  0.00           C  
ATOM    145  CE2 TYR A  13      15.196  -8.257  -3.476  1.00  0.00           C  
ATOM    146  CZ  TYR A  13      14.217  -8.348  -4.441  1.00  0.00           C  
ATOM    147  OH  TYR A  13      14.553  -8.711  -5.725  1.00  0.00           O  
ATOM    148  H   TYR A  13      14.236  -4.926  -0.042  1.00  0.00           H  
ATOM    149  HA  TYR A  13      11.787  -5.796  -1.247  1.00  0.00           H  
ATOM    150  HB2 TYR A  13      14.081  -7.117   0.131  1.00  0.00           H  
ATOM    151  HB3 TYR A  13      12.569  -8.009  -0.011  1.00  0.00           H  
ATOM    152  HD1 TYR A  13      11.539  -7.500  -2.587  1.00  0.00           H  
ATOM    153  HD2 TYR A  13      15.620  -7.821  -1.427  1.00  0.00           H  
ATOM    154  HE1 TYR A  13      12.133  -8.149  -4.884  1.00  0.00           H  
ATOM    155  HE2 TYR A  13      16.226  -8.470  -3.721  1.00  0.00           H  
ATOM    156  HH  TYR A  13      13.832  -9.211  -6.116  1.00  0.00           H  
ATOM    157  N   LEU A  14      10.169  -6.114   0.606  1.00  0.00           N  
ATOM    158  CA  LEU A  14       9.178  -6.156   1.677  1.00  0.00           C  
ATOM    159  C   LEU A  14       8.256  -7.360   1.518  1.00  0.00           C  
ATOM    160  O   LEU A  14       8.092  -7.888   0.419  1.00  0.00           O  
ATOM    161  CB  LEU A  14       8.356  -4.867   1.687  1.00  0.00           C  
ATOM    162  CG  LEU A  14       8.898  -3.731   2.557  1.00  0.00           C  
ATOM    163  CD1 LEU A  14       8.034  -2.489   2.411  1.00  0.00           C  
ATOM    164  CD2 LEU A  14       8.971  -4.164   4.014  1.00  0.00           C  
ATOM    165  H   LEU A  14       9.875  -6.230  -0.321  1.00  0.00           H  
ATOM    166  HA  LEU A  14       9.707  -6.243   2.615  1.00  0.00           H  
ATOM    167  HB2 LEU A  14       8.294  -4.505   0.672  1.00  0.00           H  
ATOM    168  HB3 LEU A  14       7.364  -5.111   2.041  1.00  0.00           H  
ATOM    169  HG  LEU A  14       9.898  -3.482   2.230  1.00  0.00           H  
ATOM    170 HD11 LEU A  14       8.318  -1.955   1.517  1.00  0.00           H  
ATOM    171 HD12 LEU A  14       8.173  -1.851   3.271  1.00  0.00           H  
ATOM    172 HD13 LEU A  14       6.995  -2.778   2.342  1.00  0.00           H  
ATOM    173 HD21 LEU A  14       9.998  -4.135   4.346  1.00  0.00           H  
ATOM    174 HD22 LEU A  14       8.590  -5.171   4.110  1.00  0.00           H  
ATOM    175 HD23 LEU A  14       8.377  -3.495   4.618  1.00  0.00           H  
ATOM    176  N   ASN A  15       7.654  -7.788   2.624  1.00  0.00           N  
ATOM    177  CA  ASN A  15       6.746  -8.929   2.608  1.00  0.00           C  
ATOM    178  C   ASN A  15       5.305  -8.474   2.402  1.00  0.00           C  
ATOM    179  O   ASN A  15       4.689  -7.901   3.301  1.00  0.00           O  
ATOM    180  CB  ASN A  15       6.863  -9.719   3.912  1.00  0.00           C  
ATOM    181  CG  ASN A  15       7.907 -10.816   3.833  1.00  0.00           C  
ATOM    182  OD1 ASN A  15       8.178 -11.354   2.758  1.00  0.00           O  
ATOM    183  ND2 ASN A  15       8.498 -11.154   4.972  1.00  0.00           N  
ATOM    184  H   ASN A  15       7.825  -7.325   3.471  1.00  0.00           H  
ATOM    185  HA  ASN A  15       7.031  -9.567   1.784  1.00  0.00           H  
ATOM    186  HB2 ASN A  15       7.138  -9.045   4.710  1.00  0.00           H  
ATOM    187  HB3 ASN A  15       5.910 -10.170   4.140  1.00  0.00           H  
ATOM    188 HD21 ASN A  15       8.232 -10.683   5.790  1.00  0.00           H  
ATOM    189 HD22 ASN A  15       9.178 -11.860   4.949  1.00  0.00           H  
ATOM    190  N   VAL A  16       4.771  -8.735   1.212  1.00  0.00           N  
ATOM    191  CA  VAL A  16       3.401  -8.354   0.890  1.00  0.00           C  
ATOM    192  C   VAL A  16       2.436  -9.507   1.144  1.00  0.00           C  
ATOM    193  O   VAL A  16       2.391 -10.473   0.382  1.00  0.00           O  
ATOM    194  CB  VAL A  16       3.274  -7.907  -0.579  1.00  0.00           C  
ATOM    195  CG1 VAL A  16       1.828  -7.577  -0.913  1.00  0.00           C  
ATOM    196  CG2 VAL A  16       4.180  -6.716  -0.852  1.00  0.00           C  
ATOM    197  H   VAL A  16       5.311  -9.195   0.537  1.00  0.00           H  
ATOM    198  HA  VAL A  16       3.128  -7.522   1.523  1.00  0.00           H  
ATOM    199  HB  VAL A  16       3.589  -8.725  -1.211  1.00  0.00           H  
ATOM    200 HG11 VAL A  16       1.588  -6.593  -0.537  1.00  0.00           H  
ATOM    201 HG12 VAL A  16       1.692  -7.597  -1.985  1.00  0.00           H  
ATOM    202 HG13 VAL A  16       1.176  -8.305  -0.453  1.00  0.00           H  
ATOM    203 HG21 VAL A  16       4.746  -6.894  -1.754  1.00  0.00           H  
ATOM    204 HG22 VAL A  16       3.578  -5.826  -0.977  1.00  0.00           H  
ATOM    205 HG23 VAL A  16       4.856  -6.580  -0.022  1.00  0.00           H  
ATOM    206  N   LEU A  17       1.664  -9.399   2.220  1.00  0.00           N  
ATOM    207  CA  LEU A  17       0.698 -10.432   2.576  1.00  0.00           C  
ATOM    208  C   LEU A  17      -0.152 -10.821   1.370  1.00  0.00           C  
ATOM    209  O   LEU A  17      -0.686  -9.961   0.669  1.00  0.00           O  
ATOM    210  CB  LEU A  17      -0.203  -9.945   3.712  1.00  0.00           C  
ATOM    211  CG  LEU A  17      -1.013 -11.023   4.435  1.00  0.00           C  
ATOM    212  CD1 LEU A  17      -0.089 -12.055   5.062  1.00  0.00           C  
ATOM    213  CD2 LEU A  17      -1.911 -10.397   5.491  1.00  0.00           C  
ATOM    214  H   LEU A  17       1.745  -8.605   2.790  1.00  0.00           H  
ATOM    215  HA  LEU A  17       1.248 -11.299   2.909  1.00  0.00           H  
ATOM    216  HB2 LEU A  17       0.422  -9.457   4.443  1.00  0.00           H  
ATOM    217  HB3 LEU A  17      -0.899  -9.229   3.299  1.00  0.00           H  
ATOM    218  HG  LEU A  17      -1.643 -11.532   3.717  1.00  0.00           H  
ATOM    219 HD11 LEU A  17       0.935 -11.820   4.813  1.00  0.00           H  
ATOM    220 HD12 LEU A  17      -0.335 -13.036   4.684  1.00  0.00           H  
ATOM    221 HD13 LEU A  17      -0.212 -12.043   6.135  1.00  0.00           H  
ATOM    222 HD21 LEU A  17      -1.331  -9.723   6.103  1.00  0.00           H  
ATOM    223 HD22 LEU A  17      -2.333 -11.174   6.112  1.00  0.00           H  
ATOM    224 HD23 LEU A  17      -2.707  -9.850   5.008  1.00  0.00           H  
ATOM    225  N   VAL A  18      -0.273 -12.124   1.134  1.00  0.00           N  
ATOM    226  CA  VAL A  18      -1.060 -12.629   0.015  1.00  0.00           C  
ATOM    227  C   VAL A  18      -1.856 -13.865   0.417  1.00  0.00           C  
ATOM    228  O   VAL A  18      -1.296 -14.843   0.912  1.00  0.00           O  
ATOM    229  CB  VAL A  18      -0.164 -12.976  -1.189  1.00  0.00           C  
ATOM    230  CG1 VAL A  18      -0.984 -13.626  -2.294  1.00  0.00           C  
ATOM    231  CG2 VAL A  18       0.544 -11.731  -1.702  1.00  0.00           C  
ATOM    232  H   VAL A  18       0.176 -12.761   1.727  1.00  0.00           H  
ATOM    233  HA  VAL A  18      -1.748 -11.851  -0.286  1.00  0.00           H  
ATOM    234  HB  VAL A  18       0.584 -13.682  -0.863  1.00  0.00           H  
ATOM    235 HG11 VAL A  18      -1.997 -13.777  -1.949  1.00  0.00           H  
ATOM    236 HG12 VAL A  18      -0.990 -12.985  -3.163  1.00  0.00           H  
ATOM    237 HG13 VAL A  18      -0.547 -14.580  -2.552  1.00  0.00           H  
ATOM    238 HG21 VAL A  18       0.071 -11.398  -2.614  1.00  0.00           H  
ATOM    239 HG22 VAL A  18       0.484 -10.949  -0.959  1.00  0.00           H  
ATOM    240 HG23 VAL A  18       1.581 -11.962  -1.897  1.00  0.00           H  
ATOM    241  N   ASN A  19      -3.166 -13.816   0.199  1.00  0.00           N  
ATOM    242  CA  ASN A  19      -4.040 -14.933   0.537  1.00  0.00           C  
ATOM    243  C   ASN A  19      -3.645 -15.545   1.877  1.00  0.00           C  
ATOM    244  O   ASN A  19      -3.453 -16.757   1.985  1.00  0.00           O  
ATOM    245  CB  ASN A  19      -3.988 -15.998  -0.559  1.00  0.00           C  
ATOM    246  CG  ASN A  19      -5.031 -15.772  -1.636  1.00  0.00           C  
ATOM    247  OD1 ASN A  19      -6.140 -16.302  -1.564  1.00  0.00           O  
ATOM    248  ND2 ASN A  19      -4.680 -14.979  -2.642  1.00  0.00           N  
ATOM    249  H   ASN A  19      -3.555 -13.009  -0.200  1.00  0.00           H  
ATOM    250  HA  ASN A  19      -5.049 -14.554   0.611  1.00  0.00           H  
ATOM    251  HB2 ASN A  19      -3.012 -15.983  -1.022  1.00  0.00           H  
ATOM    252  HB3 ASN A  19      -4.157 -16.969  -0.118  1.00  0.00           H  
ATOM    253 HD21 ASN A  19      -3.780 -14.591  -2.634  1.00  0.00           H  
ATOM    254 HD22 ASN A  19      -5.335 -14.815  -3.352  1.00  0.00           H  
ATOM    255  N   SER A  20      -3.526 -14.700   2.896  1.00  0.00           N  
ATOM    256  CA  SER A  20      -3.151 -15.158   4.229  1.00  0.00           C  
ATOM    257  C   SER A  20      -1.810 -15.884   4.197  1.00  0.00           C  
ATOM    258  O   SER A  20      -1.620 -16.888   4.881  1.00  0.00           O  
ATOM    259  CB  SER A  20      -4.230 -16.082   4.797  1.00  0.00           C  
ATOM    260  OG  SER A  20      -5.250 -15.339   5.441  1.00  0.00           O  
ATOM    261  H   SER A  20      -3.693 -13.746   2.747  1.00  0.00           H  
ATOM    262  HA  SER A  20      -3.062 -14.289   4.864  1.00  0.00           H  
ATOM    263  HB2 SER A  20      -4.671 -16.653   3.994  1.00  0.00           H  
ATOM    264  HB3 SER A  20      -3.784 -16.755   5.514  1.00  0.00           H  
ATOM    265  HG  SER A  20      -5.679 -15.889   6.100  1.00  0.00           H  
ATOM    266  N   GLN A  21      -0.883 -15.367   3.395  1.00  0.00           N  
ATOM    267  CA  GLN A  21       0.440 -15.967   3.273  1.00  0.00           C  
ATOM    268  C   GLN A  21       1.489 -14.908   2.947  1.00  0.00           C  
ATOM    269  O   GLN A  21       1.380 -14.200   1.946  1.00  0.00           O  
ATOM    270  CB  GLN A  21       0.436 -17.046   2.188  1.00  0.00           C  
ATOM    271  CG  GLN A  21      -0.396 -18.266   2.549  1.00  0.00           C  
ATOM    272  CD  GLN A  21       0.026 -19.507   1.787  1.00  0.00           C  
ATOM    273  OE1 GLN A  21       1.008 -19.489   1.044  1.00  0.00           O  
ATOM    274  NE2 GLN A  21      -0.715 -20.594   1.968  1.00  0.00           N  
ATOM    275  H   GLN A  21      -1.095 -14.565   2.875  1.00  0.00           H  
ATOM    276  HA  GLN A  21       0.687 -16.421   4.220  1.00  0.00           H  
ATOM    277  HB2 GLN A  21       0.040 -16.624   1.277  1.00  0.00           H  
ATOM    278  HB3 GLN A  21       1.452 -17.370   2.015  1.00  0.00           H  
ATOM    279  HG2 GLN A  21      -0.291 -18.460   3.606  1.00  0.00           H  
ATOM    280  HG3 GLN A  21      -1.433 -18.058   2.325  1.00  0.00           H  
ATOM    281 HE21 GLN A  21      -1.484 -20.534   2.574  1.00  0.00           H  
ATOM    282 HE22 GLN A  21      -0.465 -21.409   1.487  1.00  0.00           H  
ATOM    283  N   TRP A  22       2.502 -14.806   3.799  1.00  0.00           N  
ATOM    284  CA  TRP A  22       3.571 -13.833   3.603  1.00  0.00           C  
ATOM    285  C   TRP A  22       4.517 -14.279   2.493  1.00  0.00           C  
ATOM    286  O   TRP A  22       5.343 -15.171   2.689  1.00  0.00           O  
ATOM    287  CB  TRP A  22       4.350 -13.630   4.904  1.00  0.00           C  
ATOM    288  CG  TRP A  22       3.529 -13.019   5.998  1.00  0.00           C  
ATOM    289  CD1 TRP A  22       2.991 -13.662   7.077  1.00  0.00           C  
ATOM    290  CD2 TRP A  22       3.153 -11.643   6.120  1.00  0.00           C  
ATOM    291  NE1 TRP A  22       2.303 -12.768   7.861  1.00  0.00           N  
ATOM    292  CE2 TRP A  22       2.387 -11.524   7.296  1.00  0.00           C  
ATOM    293  CE3 TRP A  22       3.389 -10.500   5.351  1.00  0.00           C  
ATOM    294  CZ2 TRP A  22       1.857 -10.307   7.718  1.00  0.00           C  
ATOM    295  CZ3 TRP A  22       2.861  -9.294   5.772  1.00  0.00           C  
ATOM    296  CH2 TRP A  22       2.104  -9.205   6.947  1.00  0.00           C  
ATOM    297  H   TRP A  22       2.533 -15.399   4.579  1.00  0.00           H  
ATOM    298  HA  TRP A  22       3.117 -12.896   3.317  1.00  0.00           H  
ATOM    299  HB2 TRP A  22       4.711 -14.586   5.252  1.00  0.00           H  
ATOM    300  HB3 TRP A  22       5.191 -12.980   4.713  1.00  0.00           H  
ATOM    301  HD1 TRP A  22       3.098 -14.718   7.270  1.00  0.00           H  
ATOM    302  HE1 TRP A  22       1.829 -12.988   8.691  1.00  0.00           H  
ATOM    303  HE3 TRP A  22       3.970 -10.549   4.443  1.00  0.00           H  
ATOM    304  HZ2 TRP A  22       1.271 -10.222   8.623  1.00  0.00           H  
ATOM    305  HZ3 TRP A  22       3.033  -8.400   5.190  1.00  0.00           H  
ATOM    306  HH2 TRP A  22       1.711  -8.242   7.237  1.00  0.00           H  
ATOM    307  N   LYS A  23       4.391 -13.656   1.327  1.00  0.00           N  
ATOM    308  CA  LYS A  23       5.235 -13.987   0.186  1.00  0.00           C  
ATOM    309  C   LYS A  23       6.149 -12.820  -0.173  1.00  0.00           C  
ATOM    310  O   LYS A  23       5.725 -11.665  -0.171  1.00  0.00           O  
ATOM    311  CB  LYS A  23       4.372 -14.364  -1.021  1.00  0.00           C  
ATOM    312  CG  LYS A  23       3.089 -15.086  -0.650  1.00  0.00           C  
ATOM    313  CD  LYS A  23       2.482 -15.795  -1.849  1.00  0.00           C  
ATOM    314  CE  LYS A  23       2.946 -17.241  -1.934  1.00  0.00           C  
ATOM    315  NZ  LYS A  23       4.149 -17.387  -2.801  1.00  0.00           N  
ATOM    316  H   LYS A  23       3.713 -12.953   1.232  1.00  0.00           H  
ATOM    317  HA  LYS A  23       5.845 -14.835   0.460  1.00  0.00           H  
ATOM    318  HB2 LYS A  23       4.112 -13.462  -1.556  1.00  0.00           H  
ATOM    319  HB3 LYS A  23       4.947 -15.006  -1.672  1.00  0.00           H  
ATOM    320  HG2 LYS A  23       3.306 -15.816   0.116  1.00  0.00           H  
ATOM    321  HG3 LYS A  23       2.378 -14.365  -0.271  1.00  0.00           H  
ATOM    322  HD2 LYS A  23       1.406 -15.779  -1.758  1.00  0.00           H  
ATOM    323  HD3 LYS A  23       2.777 -15.277  -2.750  1.00  0.00           H  
ATOM    324  HE2 LYS A  23       3.185 -17.588  -0.940  1.00  0.00           H  
ATOM    325  HE3 LYS A  23       2.145 -17.839  -2.342  1.00  0.00           H  
ATOM    326  HZ1 LYS A  23       3.861 -17.558  -3.785  1.00  0.00           H  
ATOM    327  HZ2 LYS A  23       4.727 -18.187  -2.477  1.00  0.00           H  
ATOM    328  HZ3 LYS A  23       4.723 -16.520  -2.765  1.00  0.00           H  
ATOM    329  N   SER A  24       7.404 -13.130  -0.481  1.00  0.00           N  
ATOM    330  CA  SER A  24       8.379 -12.106  -0.840  1.00  0.00           C  
ATOM    331  C   SER A  24       7.950 -11.368  -2.104  1.00  0.00           C  
ATOM    332  O   SER A  24       7.687 -11.984  -3.137  1.00  0.00           O  
ATOM    333  CB  SER A  24       9.758 -12.734  -1.044  1.00  0.00           C  
ATOM    334  OG  SER A  24       9.702 -13.794  -1.982  1.00  0.00           O  
ATOM    335  H   SER A  24       7.683 -14.070  -0.464  1.00  0.00           H  
ATOM    336  HA  SER A  24       8.431 -11.399  -0.024  1.00  0.00           H  
ATOM    337  HB2 SER A  24      10.442 -11.983  -1.408  1.00  0.00           H  
ATOM    338  HB3 SER A  24      10.118 -13.122  -0.101  1.00  0.00           H  
ATOM    339  HG  SER A  24       8.945 -13.671  -2.559  1.00  0.00           H  
ATOM    340  N   ARG A  25       7.883 -10.043  -2.015  1.00  0.00           N  
ATOM    341  CA  ARG A  25       7.486  -9.220  -3.151  1.00  0.00           C  
ATOM    342  C   ARG A  25       8.268  -7.910  -3.172  1.00  0.00           C  
ATOM    343  O   ARG A  25       8.599  -7.356  -2.124  1.00  0.00           O  
ATOM    344  CB  ARG A  25       5.985  -8.930  -3.098  1.00  0.00           C  
ATOM    345  CG  ARG A  25       5.534  -7.873  -4.092  1.00  0.00           C  
ATOM    346  CD  ARG A  25       5.282  -8.472  -5.466  1.00  0.00           C  
ATOM    347  NE  ARG A  25       4.092  -9.318  -5.485  1.00  0.00           N  
ATOM    348  CZ  ARG A  25       4.121 -10.634  -5.300  1.00  0.00           C  
ATOM    349  NH1 ARG A  25       5.275 -11.249  -5.083  1.00  0.00           N  
ATOM    350  NH2 ARG A  25       2.996 -11.335  -5.331  1.00  0.00           N  
ATOM    351  H   ARG A  25       8.106  -9.609  -1.165  1.00  0.00           H  
ATOM    352  HA  ARG A  25       7.706  -9.771  -4.054  1.00  0.00           H  
ATOM    353  HB2 ARG A  25       5.447  -9.843  -3.307  1.00  0.00           H  
ATOM    354  HB3 ARG A  25       5.732  -8.592  -2.105  1.00  0.00           H  
ATOM    355  HG2 ARG A  25       4.619  -7.424  -3.735  1.00  0.00           H  
ATOM    356  HG3 ARG A  25       6.302  -7.118  -4.173  1.00  0.00           H  
ATOM    357  HD2 ARG A  25       5.152  -7.669  -6.177  1.00  0.00           H  
ATOM    358  HD3 ARG A  25       6.139  -9.065  -5.749  1.00  0.00           H  
ATOM    359  HE  ARG A  25       3.228  -8.883  -5.644  1.00  0.00           H  
ATOM    360 HH11 ARG A  25       6.125 -10.723  -5.058  1.00  0.00           H  
ATOM    361 HH12 ARG A  25       5.295 -12.239  -4.941  1.00  0.00           H  
ATOM    362 HH21 ARG A  25       2.124 -10.874  -5.495  1.00  0.00           H  
ATOM    363 HH22 ARG A  25       3.019 -12.324  -5.191  1.00  0.00           H  
ATOM    364  N   TRP A  26       8.560  -7.421  -4.372  1.00  0.00           N  
ATOM    365  CA  TRP A  26       9.303  -6.176  -4.529  1.00  0.00           C  
ATOM    366  C   TRP A  26       8.359  -4.979  -4.560  1.00  0.00           C  
ATOM    367  O   TRP A  26       7.558  -4.831  -5.483  1.00  0.00           O  
ATOM    368  CB  TRP A  26      10.138  -6.215  -5.811  1.00  0.00           C  
ATOM    369  CG  TRP A  26      11.130  -5.096  -5.907  1.00  0.00           C  
ATOM    370  CD1 TRP A  26      10.939  -3.796  -5.535  1.00  0.00           C  
ATOM    371  CD2 TRP A  26      12.468  -5.178  -6.411  1.00  0.00           C  
ATOM    372  NE1 TRP A  26      12.077  -3.065  -5.776  1.00  0.00           N  
ATOM    373  CE2 TRP A  26      13.030  -3.890  -6.314  1.00  0.00           C  
ATOM    374  CE3 TRP A  26      13.246  -6.214  -6.933  1.00  0.00           C  
ATOM    375  CZ2 TRP A  26      14.332  -3.613  -6.720  1.00  0.00           C  
ATOM    376  CZ3 TRP A  26      14.539  -5.938  -7.338  1.00  0.00           C  
ATOM    377  CH2 TRP A  26      15.072  -4.646  -7.228  1.00  0.00           C  
ATOM    378  H   TRP A  26       8.269  -7.909  -5.171  1.00  0.00           H  
ATOM    379  HA  TRP A  26       9.966  -6.077  -3.682  1.00  0.00           H  
ATOM    380  HB2 TRP A  26      10.682  -7.147  -5.851  1.00  0.00           H  
ATOM    381  HB3 TRP A  26       9.478  -6.151  -6.664  1.00  0.00           H  
ATOM    382  HD1 TRP A  26      10.021  -3.413  -5.115  1.00  0.00           H  
ATOM    383  HE1 TRP A  26      12.188  -2.109  -5.593  1.00  0.00           H  
ATOM    384  HE3 TRP A  26      12.854  -7.215  -7.026  1.00  0.00           H  
ATOM    385  HZ2 TRP A  26      14.757  -2.623  -6.642  1.00  0.00           H  
ATOM    386  HZ3 TRP A  26      15.156  -6.726  -7.744  1.00  0.00           H  
ATOM    387  HH2 TRP A  26      16.085  -4.477  -7.555  1.00  0.00           H  
ATOM    388  N   CYS A  27       8.459  -4.127  -3.545  1.00  0.00           N  
ATOM    389  CA  CYS A  27       7.613  -2.942  -3.456  1.00  0.00           C  
ATOM    390  C   CYS A  27       8.389  -1.689  -3.849  1.00  0.00           C  
ATOM    391  O   CYS A  27       9.450  -1.404  -3.296  1.00  0.00           O  
ATOM    392  CB  CYS A  27       7.062  -2.790  -2.037  1.00  0.00           C  
ATOM    393  SG  CYS A  27       5.477  -3.620  -1.768  1.00  0.00           S  
ATOM    394  H   CYS A  27       9.117  -4.298  -2.839  1.00  0.00           H  
ATOM    395  HA  CYS A  27       6.789  -3.072  -4.141  1.00  0.00           H  
ATOM    396  HB2 CYS A  27       7.771  -3.204  -1.337  1.00  0.00           H  
ATOM    397  HB3 CYS A  27       6.925  -1.740  -1.823  1.00  0.00           H  
ATOM    398  HG  CYS A  27       4.541  -2.689  -1.667  1.00  0.00           H  
ATOM    399  N   SER A  28       7.852  -0.945  -4.812  1.00  0.00           N  
ATOM    400  CA  SER A  28       8.496   0.274  -5.284  1.00  0.00           C  
ATOM    401  C   SER A  28       7.530   1.453  -5.235  1.00  0.00           C  
ATOM    402  O   SER A  28       6.513   1.467  -5.931  1.00  0.00           O  
ATOM    403  CB  SER A  28       9.013   0.083  -6.711  1.00  0.00           C  
ATOM    404  OG  SER A  28      10.153   0.890  -6.953  1.00  0.00           O  
ATOM    405  H   SER A  28       7.004  -1.226  -5.215  1.00  0.00           H  
ATOM    406  HA  SER A  28       9.332   0.482  -4.633  1.00  0.00           H  
ATOM    407  HB2 SER A  28       9.282  -0.952  -6.858  1.00  0.00           H  
ATOM    408  HB3 SER A  28       8.237   0.357  -7.412  1.00  0.00           H  
ATOM    409  HG  SER A  28      10.937   0.443  -6.625  1.00  0.00           H  
ATOM    410  N   VAL A  29       7.853   2.442  -4.409  1.00  0.00           N  
ATOM    411  CA  VAL A  29       7.015   3.627  -4.268  1.00  0.00           C  
ATOM    412  C   VAL A  29       7.521   4.765  -5.148  1.00  0.00           C  
ATOM    413  O   VAL A  29       8.712   5.077  -5.153  1.00  0.00           O  
ATOM    414  CB  VAL A  29       6.962   4.108  -2.806  1.00  0.00           C  
ATOM    415  CG1 VAL A  29       6.174   5.405  -2.698  1.00  0.00           C  
ATOM    416  CG2 VAL A  29       6.360   3.032  -1.914  1.00  0.00           C  
ATOM    417  H   VAL A  29       8.676   2.374  -3.881  1.00  0.00           H  
ATOM    418  HA  VAL A  29       6.013   3.366  -4.576  1.00  0.00           H  
ATOM    419  HB  VAL A  29       7.972   4.297  -2.474  1.00  0.00           H  
ATOM    420 HG11 VAL A  29       5.759   5.491  -1.705  1.00  0.00           H  
ATOM    421 HG12 VAL A  29       6.830   6.241  -2.891  1.00  0.00           H  
ATOM    422 HG13 VAL A  29       5.374   5.400  -3.422  1.00  0.00           H  
ATOM    423 HG21 VAL A  29       5.430   2.690  -2.341  1.00  0.00           H  
ATOM    424 HG22 VAL A  29       7.048   2.202  -1.837  1.00  0.00           H  
ATOM    425 HG23 VAL A  29       6.177   3.441  -0.931  1.00  0.00           H  
ATOM    426  N   ARG A  30       6.608   5.383  -5.890  1.00  0.00           N  
ATOM    427  CA  ARG A  30       6.961   6.486  -6.774  1.00  0.00           C  
ATOM    428  C   ARG A  30       5.716   7.252  -7.213  1.00  0.00           C  
ATOM    429  O   ARG A  30       4.683   6.657  -7.515  1.00  0.00           O  
ATOM    430  CB  ARG A  30       7.710   5.964  -8.002  1.00  0.00           C  
ATOM    431  CG  ARG A  30       7.983   7.032  -9.049  1.00  0.00           C  
ATOM    432  CD  ARG A  30       9.327   7.706  -8.821  1.00  0.00           C  
ATOM    433  NE  ARG A  30       9.510   8.871  -9.683  1.00  0.00           N  
ATOM    434  CZ  ARG A  30       9.070  10.086  -9.377  1.00  0.00           C  
ATOM    435  NH1 ARG A  30       8.428  10.295  -8.236  1.00  0.00           N  
ATOM    436  NH2 ARG A  30       9.274  11.096 -10.213  1.00  0.00           N  
ATOM    437  H   ARG A  30       5.674   5.089  -5.844  1.00  0.00           H  
ATOM    438  HA  ARG A  30       7.608   7.156  -6.227  1.00  0.00           H  
ATOM    439  HB2 ARG A  30       8.658   5.554  -7.684  1.00  0.00           H  
ATOM    440  HB3 ARG A  30       7.124   5.183  -8.462  1.00  0.00           H  
ATOM    441  HG2 ARG A  30       7.984   6.574 -10.026  1.00  0.00           H  
ATOM    442  HG3 ARG A  30       7.204   7.778  -9.000  1.00  0.00           H  
ATOM    443  HD2 ARG A  30       9.387   8.020  -7.790  1.00  0.00           H  
ATOM    444  HD3 ARG A  30      10.111   6.991  -9.027  1.00  0.00           H  
ATOM    445  HE  ARG A  30       9.981   8.738 -10.531  1.00  0.00           H  
ATOM    446 HH11 ARG A  30       8.274   9.536  -7.604  1.00  0.00           H  
ATOM    447 HH12 ARG A  30       8.100  11.212  -8.008  1.00  0.00           H  
ATOM    448 HH21 ARG A  30       9.759  10.943 -11.073  1.00  0.00           H  
ATOM    449 HH22 ARG A  30       8.943  12.011  -9.982  1.00  0.00           H  
ATOM    450  N   ASP A  31       5.823   8.576  -7.243  1.00  0.00           N  
ATOM    451  CA  ASP A  31       4.707   9.424  -7.644  1.00  0.00           C  
ATOM    452  C   ASP A  31       3.500   9.200  -6.738  1.00  0.00           C  
ATOM    453  O   ASP A  31       2.361   9.164  -7.201  1.00  0.00           O  
ATOM    454  CB  ASP A  31       4.325   9.147  -9.100  1.00  0.00           C  
ATOM    455  CG  ASP A  31       3.700  10.353  -9.774  1.00  0.00           C  
ATOM    456  OD1 ASP A  31       4.340  11.424  -9.784  1.00  0.00           O  
ATOM    457  OD2 ASP A  31       2.571  10.224 -10.292  1.00  0.00           O  
ATOM    458  H   ASP A  31       6.674   8.994  -6.991  1.00  0.00           H  
ATOM    459  HA  ASP A  31       5.022  10.453  -7.555  1.00  0.00           H  
ATOM    460  HB2 ASP A  31       5.212   8.868  -9.651  1.00  0.00           H  
ATOM    461  HB3 ASP A  31       3.616   8.332  -9.130  1.00  0.00           H  
ATOM    462  N   ASN A  32       3.760   9.048  -5.443  1.00  0.00           N  
ATOM    463  CA  ASN A  32       2.696   8.826  -4.471  1.00  0.00           C  
ATOM    464  C   ASN A  32       1.909   7.563  -4.807  1.00  0.00           C  
ATOM    465  O   ASN A  32       0.685   7.528  -4.677  1.00  0.00           O  
ATOM    466  CB  ASN A  32       1.754  10.031  -4.430  1.00  0.00           C  
ATOM    467  CG  ASN A  32       2.427  11.271  -3.874  1.00  0.00           C  
ATOM    468  OD1 ASN A  32       2.698  12.224  -4.605  1.00  0.00           O  
ATOM    469  ND2 ASN A  32       2.700  11.264  -2.574  1.00  0.00           N  
ATOM    470  H   ASN A  32       4.690   9.087  -5.134  1.00  0.00           H  
ATOM    471  HA  ASN A  32       3.154   8.704  -3.501  1.00  0.00           H  
ATOM    472  HB2 ASN A  32       1.414  10.248  -5.432  1.00  0.00           H  
ATOM    473  HB3 ASN A  32       0.904   9.795  -3.808  1.00  0.00           H  
ATOM    474 HD21 ASN A  32       2.455  10.469  -2.054  1.00  0.00           H  
ATOM    475 HD22 ASN A  32       3.134  12.053  -2.189  1.00  0.00           H  
ATOM    476  N   HIS A  33       2.620   6.526  -5.237  1.00  0.00           N  
ATOM    477  CA  HIS A  33       1.988   5.259  -5.591  1.00  0.00           C  
ATOM    478  C   HIS A  33       2.929   4.088  -5.318  1.00  0.00           C  
ATOM    479  O   HIS A  33       4.115   4.143  -5.646  1.00  0.00           O  
ATOM    480  CB  HIS A  33       1.573   5.264  -7.062  1.00  0.00           C  
ATOM    481  CG  HIS A  33       0.294   5.998  -7.321  1.00  0.00           C  
ATOM    482  ND1 HIS A  33       0.216   7.373  -7.393  1.00  0.00           N  
ATOM    483  CD2 HIS A  33      -0.964   5.541  -7.525  1.00  0.00           C  
ATOM    484  CE1 HIS A  33      -1.034   7.730  -7.631  1.00  0.00           C  
ATOM    485  NE2 HIS A  33      -1.769   6.637  -7.716  1.00  0.00           N  
ATOM    486  H   HIS A  33       3.592   6.614  -5.319  1.00  0.00           H  
ATOM    487  HA  HIS A  33       1.108   5.145  -4.977  1.00  0.00           H  
ATOM    488  HB2 HIS A  33       2.350   5.735  -7.646  1.00  0.00           H  
ATOM    489  HB3 HIS A  33       1.446   4.245  -7.396  1.00  0.00           H  
ATOM    490  HD1 HIS A  33       0.966   7.995  -7.286  1.00  0.00           H  
ATOM    491  HD2 HIS A  33      -1.276   4.506  -7.537  1.00  0.00           H  
ATOM    492  HE1 HIS A  33      -1.393   8.742  -7.738  1.00  0.00           H  
ATOM    493  HE2 HIS A  33      -2.745   6.618  -7.801  1.00  0.00           H  
ATOM    494  N   LEU A  34       2.392   3.032  -4.719  1.00  0.00           N  
ATOM    495  CA  LEU A  34       3.184   1.848  -4.403  1.00  0.00           C  
ATOM    496  C   LEU A  34       2.979   0.760  -5.453  1.00  0.00           C  
ATOM    497  O   LEU A  34       1.948   0.087  -5.473  1.00  0.00           O  
ATOM    498  CB  LEU A  34       2.808   1.314  -3.019  1.00  0.00           C  
ATOM    499  CG  LEU A  34       3.117  -0.161  -2.763  1.00  0.00           C  
ATOM    500  CD1 LEU A  34       4.584  -0.456  -3.037  1.00  0.00           C  
ATOM    501  CD2 LEU A  34       2.753  -0.542  -1.335  1.00  0.00           C  
ATOM    502  H   LEU A  34       1.441   3.047  -4.482  1.00  0.00           H  
ATOM    503  HA  LEU A  34       4.224   2.136  -4.398  1.00  0.00           H  
ATOM    504  HB2 LEU A  34       3.344   1.895  -2.284  1.00  0.00           H  
ATOM    505  HB3 LEU A  34       1.746   1.458  -2.887  1.00  0.00           H  
ATOM    506  HG  LEU A  34       2.524  -0.768  -3.433  1.00  0.00           H  
ATOM    507 HD11 LEU A  34       4.671  -1.406  -3.542  1.00  0.00           H  
ATOM    508 HD12 LEU A  34       5.124  -0.492  -2.103  1.00  0.00           H  
ATOM    509 HD13 LEU A  34       4.996   0.323  -3.662  1.00  0.00           H  
ATOM    510 HD21 LEU A  34       1.711  -0.322  -1.159  1.00  0.00           H  
ATOM    511 HD22 LEU A  34       3.361   0.025  -0.646  1.00  0.00           H  
ATOM    512 HD23 LEU A  34       2.929  -1.598  -1.188  1.00  0.00           H  
ATOM    513  N   HIS A  35       3.970   0.591  -6.323  1.00  0.00           N  
ATOM    514  CA  HIS A  35       3.901  -0.418  -7.374  1.00  0.00           C  
ATOM    515  C   HIS A  35       4.446  -1.755  -6.881  1.00  0.00           C  
ATOM    516  O   HIS A  35       5.283  -1.801  -5.979  1.00  0.00           O  
ATOM    517  CB  HIS A  35       4.683   0.043  -8.604  1.00  0.00           C  
ATOM    518  CG  HIS A  35       4.088   1.239  -9.280  1.00  0.00           C  
ATOM    519  ND1 HIS A  35       3.440   1.171 -10.495  1.00  0.00           N  
ATOM    520  CD2 HIS A  35       4.042   2.538  -8.903  1.00  0.00           C  
ATOM    521  CE1 HIS A  35       3.024   2.378 -10.837  1.00  0.00           C  
ATOM    522  NE2 HIS A  35       3.376   3.224  -9.887  1.00  0.00           N  
ATOM    523  H   HIS A  35       4.766   1.157  -6.255  1.00  0.00           H  
ATOM    524  HA  HIS A  35       2.864  -0.544  -7.644  1.00  0.00           H  
ATOM    525  HB2 HIS A  35       5.690   0.297  -8.308  1.00  0.00           H  
ATOM    526  HB3 HIS A  35       4.718  -0.763  -9.323  1.00  0.00           H  
ATOM    527  HD1 HIS A  35       3.307   0.360 -11.029  1.00  0.00           H  
ATOM    528  HD2 HIS A  35       4.453   2.957  -7.995  1.00  0.00           H  
ATOM    529  HE1 HIS A  35       2.485   2.628 -11.740  1.00  0.00           H  
ATOM    530  HE2 HIS A  35       3.266   4.198  -9.930  1.00  0.00           H  
ATOM    531  N   PHE A  36       3.965  -2.840  -7.477  1.00  0.00           N  
ATOM    532  CA  PHE A  36       4.402  -4.178  -7.097  1.00  0.00           C  
ATOM    533  C   PHE A  36       5.124  -4.863  -8.254  1.00  0.00           C  
ATOM    534  O   PHE A  36       4.653  -4.846  -9.392  1.00  0.00           O  
ATOM    535  CB  PHE A  36       3.205  -5.024  -6.657  1.00  0.00           C  
ATOM    536  CG  PHE A  36       2.577  -4.552  -5.377  1.00  0.00           C  
ATOM    537  CD1 PHE A  36       1.978  -3.305  -5.302  1.00  0.00           C  
ATOM    538  CD2 PHE A  36       2.584  -5.356  -4.248  1.00  0.00           C  
ATOM    539  CE1 PHE A  36       1.399  -2.868  -4.126  1.00  0.00           C  
ATOM    540  CE2 PHE A  36       2.007  -4.925  -3.069  1.00  0.00           C  
ATOM    541  CZ  PHE A  36       1.414  -3.678  -3.007  1.00  0.00           C  
ATOM    542  H   PHE A  36       3.299  -2.739  -8.189  1.00  0.00           H  
ATOM    543  HA  PHE A  36       5.086  -4.080  -6.269  1.00  0.00           H  
ATOM    544  HB2 PHE A  36       2.449  -4.994  -7.427  1.00  0.00           H  
ATOM    545  HB3 PHE A  36       3.527  -6.044  -6.515  1.00  0.00           H  
ATOM    546  HD1 PHE A  36       1.966  -2.670  -6.176  1.00  0.00           H  
ATOM    547  HD2 PHE A  36       3.049  -6.330  -4.295  1.00  0.00           H  
ATOM    548  HE1 PHE A  36       0.937  -1.893  -4.081  1.00  0.00           H  
ATOM    549  HE2 PHE A  36       2.021  -5.561  -2.197  1.00  0.00           H  
ATOM    550  HZ  PHE A  36       0.961  -3.340  -2.088  1.00  0.00           H  
ATOM    551  N   TYR A  37       6.271  -5.465  -7.955  1.00  0.00           N  
ATOM    552  CA  TYR A  37       7.060  -6.153  -8.969  1.00  0.00           C  
ATOM    553  C   TYR A  37       7.449  -7.552  -8.501  1.00  0.00           C  
ATOM    554  O   TYR A  37       7.328  -7.879  -7.320  1.00  0.00           O  
ATOM    555  CB  TYR A  37       8.317  -5.347  -9.300  1.00  0.00           C  
ATOM    556  CG  TYR A  37       8.025  -3.959  -9.825  1.00  0.00           C  
ATOM    557  CD1 TYR A  37       7.774  -2.905  -8.956  1.00  0.00           C  
ATOM    558  CD2 TYR A  37       8.003  -3.702 -11.190  1.00  0.00           C  
ATOM    559  CE1 TYR A  37       7.507  -1.636  -9.430  1.00  0.00           C  
ATOM    560  CE2 TYR A  37       7.737  -2.435 -11.674  1.00  0.00           C  
ATOM    561  CZ  TYR A  37       7.489  -1.406 -10.790  1.00  0.00           C  
ATOM    562  OH  TYR A  37       7.225  -0.142 -11.267  1.00  0.00           O  
ATOM    563  H   TYR A  37       6.594  -5.445  -7.031  1.00  0.00           H  
ATOM    564  HA  TYR A  37       6.454  -6.239  -9.859  1.00  0.00           H  
ATOM    565  HB2 TYR A  37       8.916  -5.245  -8.409  1.00  0.00           H  
ATOM    566  HB3 TYR A  37       8.886  -5.874 -10.053  1.00  0.00           H  
ATOM    567  HD1 TYR A  37       7.789  -3.089  -7.891  1.00  0.00           H  
ATOM    568  HD2 TYR A  37       8.197  -4.510 -11.880  1.00  0.00           H  
ATOM    569  HE1 TYR A  37       7.313  -0.830  -8.738  1.00  0.00           H  
ATOM    570  HE2 TYR A  37       7.724  -2.255 -12.739  1.00  0.00           H  
ATOM    571  HH  TYR A  37       7.823   0.058 -11.991  1.00  0.00           H  
ATOM    572  N   GLN A  38       7.915  -8.374  -9.435  1.00  0.00           N  
ATOM    573  CA  GLN A  38       8.321  -9.738  -9.119  1.00  0.00           C  
ATOM    574  C   GLN A  38       9.797  -9.955  -9.439  1.00  0.00           C  
ATOM    575  O   GLN A  38      10.610 -10.176  -8.542  1.00  0.00           O  
ATOM    576  CB  GLN A  38       7.467 -10.740  -9.897  1.00  0.00           C  
ATOM    577  CG  GLN A  38       5.971 -10.504  -9.754  1.00  0.00           C  
ATOM    578  CD  GLN A  38       5.378 -11.227  -8.560  1.00  0.00           C  
ATOM    579  OE1 GLN A  38       6.097 -11.636  -7.647  1.00  0.00           O  
ATOM    580  NE2 GLN A  38       4.060 -11.387  -8.560  1.00  0.00           N  
ATOM    581  H   GLN A  38       7.987  -8.056 -10.359  1.00  0.00           H  
ATOM    582  HA  GLN A  38       8.169  -9.892  -8.062  1.00  0.00           H  
ATOM    583  HB2 GLN A  38       7.721 -10.676 -10.944  1.00  0.00           H  
ATOM    584  HB3 GLN A  38       7.687 -11.736  -9.541  1.00  0.00           H  
ATOM    585  HG2 GLN A  38       5.796  -9.446  -9.637  1.00  0.00           H  
ATOM    586  HG3 GLN A  38       5.478 -10.854 -10.649  1.00  0.00           H  
ATOM    587 HE21 GLN A  38       3.552 -11.035  -9.321  1.00  0.00           H  
ATOM    588 HE22 GLN A  38       3.650 -11.850  -7.800  1.00  0.00           H  
ATOM    589  N   ASP A  39      10.135  -9.889 -10.722  1.00  0.00           N  
ATOM    590  CA  ASP A  39      11.513 -10.078 -11.160  1.00  0.00           C  
ATOM    591  C   ASP A  39      12.373  -8.876 -10.781  1.00  0.00           C  
ATOM    592  O   ASP A  39      11.873  -7.890 -10.238  1.00  0.00           O  
ATOM    593  CB  ASP A  39      11.564 -10.300 -12.672  1.00  0.00           C  
ATOM    594  CG  ASP A  39      10.915 -11.606 -13.087  1.00  0.00           C  
ATOM    595  OD1 ASP A  39       9.673 -11.701 -13.012  1.00  0.00           O  
ATOM    596  OD2 ASP A  39      11.650 -12.534 -13.486  1.00  0.00           O  
ATOM    597  H   ASP A  39       9.440  -9.709 -11.390  1.00  0.00           H  
ATOM    598  HA  ASP A  39      11.903 -10.953 -10.663  1.00  0.00           H  
ATOM    599  HB2 ASP A  39      11.047  -9.491 -13.167  1.00  0.00           H  
ATOM    600  HB3 ASP A  39      12.595 -10.313 -12.993  1.00  0.00           H  
ATOM    601  N   ARG A  40      13.666  -8.964 -11.071  1.00  0.00           N  
ATOM    602  CA  ARG A  40      14.596  -7.885 -10.759  1.00  0.00           C  
ATOM    603  C   ARG A  40      14.566  -6.811 -11.843  1.00  0.00           C  
ATOM    604  O   ARG A  40      14.170  -7.073 -12.978  1.00  0.00           O  
ATOM    605  CB  ARG A  40      16.016  -8.434 -10.609  1.00  0.00           C  
ATOM    606  CG  ARG A  40      16.279  -9.078  -9.257  1.00  0.00           C  
ATOM    607  CD  ARG A  40      15.612 -10.440  -9.149  1.00  0.00           C  
ATOM    608  NE  ARG A  40      16.408 -11.492  -9.775  1.00  0.00           N  
ATOM    609  CZ  ARG A  40      16.310 -12.777  -9.454  1.00  0.00           C  
ATOM    610  NH1 ARG A  40      15.455 -13.167  -8.520  1.00  0.00           N  
ATOM    611  NH2 ARG A  40      17.070 -13.675 -10.069  1.00  0.00           N  
ATOM    612  H   ARG A  40      14.004  -9.776 -11.505  1.00  0.00           H  
ATOM    613  HA  ARG A  40      14.289  -7.444  -9.823  1.00  0.00           H  
ATOM    614  HB2 ARG A  40      16.186  -9.176 -11.376  1.00  0.00           H  
ATOM    615  HB3 ARG A  40      16.717  -7.624 -10.740  1.00  0.00           H  
ATOM    616  HG2 ARG A  40      17.345  -9.201  -9.129  1.00  0.00           H  
ATOM    617  HG3 ARG A  40      15.894  -8.434  -8.481  1.00  0.00           H  
ATOM    618  HD2 ARG A  40      15.476 -10.677  -8.104  1.00  0.00           H  
ATOM    619  HD3 ARG A  40      14.648 -10.393  -9.635  1.00  0.00           H  
ATOM    620  HE  ARG A  40      17.048 -11.225 -10.469  1.00  0.00           H  
ATOM    621 HH11 ARG A  40      14.880 -12.493  -8.057  1.00  0.00           H  
ATOM    622 HH12 ARG A  40      15.382 -14.136  -8.282  1.00  0.00           H  
ATOM    623 HH21 ARG A  40      17.717 -13.384 -10.774  1.00  0.00           H  
ATOM    624 HH22 ARG A  40      16.996 -14.642  -9.827  1.00  0.00           H  
ATOM    625  N   ASN A  41      14.987  -5.604 -11.484  1.00  0.00           N  
ATOM    626  CA  ASN A  41      15.008  -4.490 -12.425  1.00  0.00           C  
ATOM    627  C   ASN A  41      13.599  -4.161 -12.910  1.00  0.00           C  
ATOM    628  O   ASN A  41      13.381  -3.918 -14.096  1.00  0.00           O  
ATOM    629  CB  ASN A  41      15.905  -4.821 -13.619  1.00  0.00           C  
ATOM    630  CG  ASN A  41      17.367  -4.523 -13.345  1.00  0.00           C  
ATOM    631  OD1 ASN A  41      17.842  -4.674 -12.219  1.00  0.00           O  
ATOM    632  ND2 ASN A  41      18.087  -4.097 -14.376  1.00  0.00           N  
ATOM    633  H   ASN A  41      15.291  -5.457 -10.564  1.00  0.00           H  
ATOM    634  HA  ASN A  41      15.410  -3.630 -11.912  1.00  0.00           H  
ATOM    635  HB2 ASN A  41      15.811  -5.872 -13.853  1.00  0.00           H  
ATOM    636  HB3 ASN A  41      15.591  -4.237 -14.472  1.00  0.00           H  
ATOM    637 HD21 ASN A  41      17.642  -4.000 -15.243  1.00  0.00           H  
ATOM    638 HD22 ASN A  41      19.035  -3.897 -14.226  1.00  0.00           H  
ATOM    639  N   ARG A  42      12.647  -4.153 -11.983  1.00  0.00           N  
ATOM    640  CA  ARG A  42      11.260  -3.854 -12.314  1.00  0.00           C  
ATOM    641  C   ARG A  42      10.900  -4.402 -13.692  1.00  0.00           C  
ATOM    642  O   ARG A  42      10.266  -3.720 -14.496  1.00  0.00           O  
ATOM    643  CB  ARG A  42      11.017  -2.344 -12.275  1.00  0.00           C  
ATOM    644  CG  ARG A  42      10.938  -1.777 -10.867  1.00  0.00           C  
ATOM    645  CD  ARG A  42      10.546  -0.307 -10.881  1.00  0.00           C  
ATOM    646  NE  ARG A  42      11.686   0.561 -11.163  1.00  0.00           N  
ATOM    647  CZ  ARG A  42      11.579   1.868 -11.371  1.00  0.00           C  
ATOM    648  NH1 ARG A  42      10.392   2.456 -11.330  1.00  0.00           N  
ATOM    649  NH2 ARG A  42      12.664   2.592 -11.622  1.00  0.00           N  
ATOM    650  H   ARG A  42      12.884  -4.354 -11.053  1.00  0.00           H  
ATOM    651  HA  ARG A  42      10.632  -4.329 -11.575  1.00  0.00           H  
ATOM    652  HB2 ARG A  42      11.824  -1.848 -12.794  1.00  0.00           H  
ATOM    653  HB3 ARG A  42      10.088  -2.128 -12.780  1.00  0.00           H  
ATOM    654  HG2 ARG A  42      10.199  -2.329 -10.307  1.00  0.00           H  
ATOM    655  HG3 ARG A  42      11.902  -1.878 -10.394  1.00  0.00           H  
ATOM    656  HD2 ARG A  42       9.794  -0.156 -11.641  1.00  0.00           H  
ATOM    657  HD3 ARG A  42      10.138  -0.049  -9.915  1.00  0.00           H  
ATOM    658  HE  ARG A  42      12.572   0.148 -11.199  1.00  0.00           H  
ATOM    659 HH11 ARG A  42       9.574   1.914 -11.140  1.00  0.00           H  
ATOM    660 HH12 ARG A  42      10.315   3.441 -11.486  1.00  0.00           H  
ATOM    661 HH21 ARG A  42      13.561   2.153 -11.654  1.00  0.00           H  
ATOM    662 HH22 ARG A  42      12.583   3.576 -11.779  1.00  0.00           H  
ATOM    663  N   SER A  43      11.310  -5.639 -13.956  1.00  0.00           N  
ATOM    664  CA  SER A  43      11.035  -6.278 -15.238  1.00  0.00           C  
ATOM    665  C   SER A  43       9.538  -6.278 -15.534  1.00  0.00           C  
ATOM    666  O   SER A  43       9.086  -5.679 -16.509  1.00  0.00           O  
ATOM    667  CB  SER A  43      11.568  -7.712 -15.242  1.00  0.00           C  
ATOM    668  OG  SER A  43      11.879  -8.137 -16.558  1.00  0.00           O  
ATOM    669  H   SER A  43      11.812  -6.133 -13.273  1.00  0.00           H  
ATOM    670  HA  SER A  43      11.542  -5.712 -16.005  1.00  0.00           H  
ATOM    671  HB2 SER A  43      12.463  -7.762 -14.640  1.00  0.00           H  
ATOM    672  HB3 SER A  43      10.819  -8.372 -14.831  1.00  0.00           H  
ATOM    673  HG  SER A  43      11.684  -7.429 -17.177  1.00  0.00           H  
ATOM    674  N   LYS A  44       8.774  -6.957 -14.685  1.00  0.00           N  
ATOM    675  CA  LYS A  44       7.328  -7.037 -14.854  1.00  0.00           C  
ATOM    676  C   LYS A  44       6.608  -6.602 -13.581  1.00  0.00           C  
ATOM    677  O   LYS A  44       7.129  -6.757 -12.477  1.00  0.00           O  
ATOM    678  CB  LYS A  44       6.914  -8.464 -15.223  1.00  0.00           C  
ATOM    679  CG  LYS A  44       6.948  -8.739 -16.717  1.00  0.00           C  
ATOM    680  CD  LYS A  44       8.331  -9.174 -17.172  1.00  0.00           C  
ATOM    681  CE  LYS A  44       8.619 -10.616 -16.781  1.00  0.00           C  
ATOM    682  NZ  LYS A  44       9.987 -11.039 -17.188  1.00  0.00           N  
ATOM    683  H   LYS A  44       9.193  -7.416 -13.926  1.00  0.00           H  
ATOM    684  HA  LYS A  44       7.050  -6.371 -15.656  1.00  0.00           H  
ATOM    685  HB2 LYS A  44       7.584  -9.158 -14.735  1.00  0.00           H  
ATOM    686  HB3 LYS A  44       5.908  -8.638 -14.869  1.00  0.00           H  
ATOM    687  HG2 LYS A  44       6.242  -9.524 -16.945  1.00  0.00           H  
ATOM    688  HG3 LYS A  44       6.672  -7.838 -17.246  1.00  0.00           H  
ATOM    689  HD2 LYS A  44       8.391  -9.087 -18.247  1.00  0.00           H  
ATOM    690  HD3 LYS A  44       9.070  -8.532 -16.716  1.00  0.00           H  
ATOM    691  HE2 LYS A  44       8.526 -10.710 -15.710  1.00  0.00           H  
ATOM    692  HE3 LYS A  44       7.895 -11.257 -17.262  1.00  0.00           H  
ATOM    693  HZ1 LYS A  44       9.931 -11.852 -17.834  1.00  0.00           H  
ATOM    694  HZ2 LYS A  44      10.540 -11.313 -16.351  1.00  0.00           H  
ATOM    695  HZ3 LYS A  44      10.473 -10.258 -17.672  1.00  0.00           H  
ATOM    696  N   VAL A  45       5.405  -6.059 -13.743  1.00  0.00           N  
ATOM    697  CA  VAL A  45       4.612  -5.604 -12.607  1.00  0.00           C  
ATOM    698  C   VAL A  45       3.779  -6.741 -12.029  1.00  0.00           C  
ATOM    699  O   VAL A  45       3.001  -7.378 -12.739  1.00  0.00           O  
ATOM    700  CB  VAL A  45       3.677  -4.446 -13.004  1.00  0.00           C  
ATOM    701  CG1 VAL A  45       2.806  -4.036 -11.826  1.00  0.00           C  
ATOM    702  CG2 VAL A  45       4.483  -3.263 -13.520  1.00  0.00           C  
ATOM    703  H   VAL A  45       5.043  -5.962 -14.649  1.00  0.00           H  
ATOM    704  HA  VAL A  45       5.292  -5.245 -11.848  1.00  0.00           H  
ATOM    705  HB  VAL A  45       3.031  -4.789 -13.799  1.00  0.00           H  
ATOM    706 HG11 VAL A  45       2.983  -4.707 -10.998  1.00  0.00           H  
ATOM    707 HG12 VAL A  45       3.050  -3.026 -11.533  1.00  0.00           H  
ATOM    708 HG13 VAL A  45       1.765  -4.087 -12.113  1.00  0.00           H  
ATOM    709 HG21 VAL A  45       3.925  -2.352 -13.358  1.00  0.00           H  
ATOM    710 HG22 VAL A  45       5.422  -3.208 -12.989  1.00  0.00           H  
ATOM    711 HG23 VAL A  45       4.672  -3.388 -14.575  1.00  0.00           H  
ATOM    712  N   ALA A  46       3.946  -6.990 -10.734  1.00  0.00           N  
ATOM    713  CA  ALA A  46       3.207  -8.049 -10.058  1.00  0.00           C  
ATOM    714  C   ALA A  46       1.702  -7.859 -10.220  1.00  0.00           C  
ATOM    715  O   ALA A  46       0.977  -8.807 -10.514  1.00  0.00           O  
ATOM    716  CB  ALA A  46       3.579  -8.094  -8.583  1.00  0.00           C  
ATOM    717  H   ALA A  46       4.580  -6.448 -10.221  1.00  0.00           H  
ATOM    718  HA  ALA A  46       3.490  -8.991 -10.505  1.00  0.00           H  
ATOM    719  HB1 ALA A  46       4.318  -8.866  -8.423  1.00  0.00           H  
ATOM    720  HB2 ALA A  46       3.985  -7.139  -8.285  1.00  0.00           H  
ATOM    721  HB3 ALA A  46       2.699  -8.310  -7.997  1.00  0.00           H  
ATOM    722  N   GLN A  47       1.243  -6.627 -10.026  1.00  0.00           N  
ATOM    723  CA  GLN A  47      -0.176  -6.314 -10.150  1.00  0.00           C  
ATOM    724  C   GLN A  47      -0.414  -4.811 -10.036  1.00  0.00           C  
ATOM    725  O   GLN A  47       0.469  -4.065  -9.612  1.00  0.00           O  
ATOM    726  CB  GLN A  47      -0.978  -7.052  -9.076  1.00  0.00           C  
ATOM    727  CG  GLN A  47      -0.428  -6.867  -7.671  1.00  0.00           C  
ATOM    728  CD  GLN A  47      -1.185  -7.677  -6.637  1.00  0.00           C  
ATOM    729  OE1 GLN A  47      -1.780  -8.708  -6.953  1.00  0.00           O  
ATOM    730  NE2 GLN A  47      -1.167  -7.212  -5.393  1.00  0.00           N  
ATOM    731  H   GLN A  47       1.871  -5.913  -9.794  1.00  0.00           H  
ATOM    732  HA  GLN A  47      -0.504  -6.645 -11.123  1.00  0.00           H  
ATOM    733  HB2 GLN A  47      -1.996  -6.690  -9.092  1.00  0.00           H  
ATOM    734  HB3 GLN A  47      -0.976  -8.108  -9.304  1.00  0.00           H  
ATOM    735  HG2 GLN A  47       0.607  -7.175  -7.660  1.00  0.00           H  
ATOM    736  HG3 GLN A  47      -0.493  -5.822  -7.407  1.00  0.00           H  
ATOM    737 HE21 GLN A  47      -0.674  -6.384  -5.215  1.00  0.00           H  
ATOM    738 HE22 GLN A  47      -1.649  -7.715  -4.705  1.00  0.00           H  
ATOM    739  N   GLN A  48      -1.610  -4.376 -10.419  1.00  0.00           N  
ATOM    740  CA  GLN A  48      -1.962  -2.962 -10.361  1.00  0.00           C  
ATOM    741  C   GLN A  48      -1.287  -2.281  -9.174  1.00  0.00           C  
ATOM    742  O   GLN A  48      -1.196  -2.835  -8.078  1.00  0.00           O  
ATOM    743  CB  GLN A  48      -3.480  -2.797 -10.262  1.00  0.00           C  
ATOM    744  CG  GLN A  48      -3.974  -1.435 -10.724  1.00  0.00           C  
ATOM    745  CD  GLN A  48      -5.487  -1.339 -10.738  1.00  0.00           C  
ATOM    746  OE1 GLN A  48      -6.172  -2.036  -9.991  1.00  0.00           O  
ATOM    747  NE2 GLN A  48      -6.017  -0.469 -11.591  1.00  0.00           N  
ATOM    748  H   GLN A  48      -2.271  -5.021 -10.748  1.00  0.00           H  
ATOM    749  HA  GLN A  48      -1.616  -2.498 -11.271  1.00  0.00           H  
ATOM    750  HB2 GLN A  48      -3.952  -3.553 -10.871  1.00  0.00           H  
ATOM    751  HB3 GLN A  48      -3.779  -2.934  -9.234  1.00  0.00           H  
ATOM    752  HG2 GLN A  48      -3.586  -0.680 -10.056  1.00  0.00           H  
ATOM    753  HG3 GLN A  48      -3.607  -1.254 -11.723  1.00  0.00           H  
ATOM    754 HE21 GLN A  48      -5.409   0.053 -12.157  1.00  0.00           H  
ATOM    755 HE22 GLN A  48      -6.992  -0.386 -11.621  1.00  0.00           H  
ATOM    756  N   PRO A  49      -0.801  -1.051  -9.396  1.00  0.00           N  
ATOM    757  CA  PRO A  49      -0.126  -0.268  -8.357  1.00  0.00           C  
ATOM    758  C   PRO A  49      -1.085   0.201  -7.269  1.00  0.00           C  
ATOM    759  O   PRO A  49      -2.295  -0.012  -7.359  1.00  0.00           O  
ATOM    760  CB  PRO A  49       0.437   0.930  -9.126  1.00  0.00           C  
ATOM    761  CG  PRO A  49      -0.449   1.067 -10.316  1.00  0.00           C  
ATOM    762  CD  PRO A  49      -0.874  -0.330 -10.678  1.00  0.00           C  
ATOM    763  HA  PRO A  49       0.686  -0.822  -7.907  1.00  0.00           H  
ATOM    764  HB2 PRO A  49       0.400   1.811  -8.501  1.00  0.00           H  
ATOM    765  HB3 PRO A  49       1.458   0.730  -9.415  1.00  0.00           H  
ATOM    766  HG2 PRO A  49      -1.309   1.668 -10.066  1.00  0.00           H  
ATOM    767  HG3 PRO A  49       0.100   1.514 -11.132  1.00  0.00           H  
ATOM    768  HD2 PRO A  49      -1.883  -0.329 -11.063  1.00  0.00           H  
ATOM    769  HD3 PRO A  49      -0.193  -0.757 -11.399  1.00  0.00           H  
ATOM    770  N   LEU A  50      -0.538   0.841  -6.240  1.00  0.00           N  
ATOM    771  CA  LEU A  50      -1.347   1.341  -5.134  1.00  0.00           C  
ATOM    772  C   LEU A  50      -1.338   2.865  -5.099  1.00  0.00           C  
ATOM    773  O   LEU A  50      -0.305   3.496  -5.322  1.00  0.00           O  
ATOM    774  CB  LEU A  50      -0.828   0.786  -3.806  1.00  0.00           C  
ATOM    775  CG  LEU A  50      -1.445  -0.535  -3.343  1.00  0.00           C  
ATOM    776  CD1 LEU A  50      -0.908  -0.924  -1.975  1.00  0.00           C  
ATOM    777  CD2 LEU A  50      -2.962  -0.433  -3.315  1.00  0.00           C  
ATOM    778  H   LEU A  50       0.430   0.981  -6.224  1.00  0.00           H  
ATOM    779  HA  LEU A  50      -2.361   1.001  -5.284  1.00  0.00           H  
ATOM    780  HB2 LEU A  50       0.237   0.637  -3.904  1.00  0.00           H  
ATOM    781  HB3 LEU A  50      -1.017   1.526  -3.043  1.00  0.00           H  
ATOM    782  HG  LEU A  50      -1.174  -1.315  -4.042  1.00  0.00           H  
ATOM    783 HD11 LEU A  50      -0.232  -0.160  -1.623  1.00  0.00           H  
ATOM    784 HD12 LEU A  50      -0.383  -1.865  -2.048  1.00  0.00           H  
ATOM    785 HD13 LEU A  50      -1.731  -1.024  -1.281  1.00  0.00           H  
ATOM    786 HD21 LEU A  50      -3.253   0.493  -2.841  1.00  0.00           H  
ATOM    787 HD22 LEU A  50      -3.368  -1.265  -2.757  1.00  0.00           H  
ATOM    788 HD23 LEU A  50      -3.344  -0.455  -4.325  1.00  0.00           H  
ATOM    789  N   SER A  51      -2.497   3.452  -4.815  1.00  0.00           N  
ATOM    790  CA  SER A  51      -2.623   4.903  -4.752  1.00  0.00           C  
ATOM    791  C   SER A  51      -2.475   5.400  -3.317  1.00  0.00           C  
ATOM    792  O   SER A  51      -3.423   5.917  -2.725  1.00  0.00           O  
ATOM    793  CB  SER A  51      -3.974   5.344  -5.318  1.00  0.00           C  
ATOM    794  OG  SER A  51      -5.044   4.832  -4.543  1.00  0.00           O  
ATOM    795  H   SER A  51      -3.286   2.896  -4.646  1.00  0.00           H  
ATOM    796  HA  SER A  51      -1.834   5.331  -5.352  1.00  0.00           H  
ATOM    797  HB2 SER A  51      -4.029   6.422  -5.317  1.00  0.00           H  
ATOM    798  HB3 SER A  51      -4.074   4.979  -6.331  1.00  0.00           H  
ATOM    799  HG  SER A  51      -4.729   4.104  -4.003  1.00  0.00           H  
ATOM    800  N   LEU A  52      -1.278   5.240  -2.763  1.00  0.00           N  
ATOM    801  CA  LEU A  52      -1.003   5.672  -1.397  1.00  0.00           C  
ATOM    802  C   LEU A  52      -1.643   7.028  -1.116  1.00  0.00           C  
ATOM    803  O   LEU A  52      -2.221   7.243  -0.051  1.00  0.00           O  
ATOM    804  CB  LEU A  52       0.506   5.748  -1.160  1.00  0.00           C  
ATOM    805  CG  LEU A  52       1.305   4.492  -1.509  1.00  0.00           C  
ATOM    806  CD1 LEU A  52       2.794   4.737  -1.324  1.00  0.00           C  
ATOM    807  CD2 LEU A  52       0.846   3.315  -0.659  1.00  0.00           C  
ATOM    808  H   LEU A  52      -0.562   4.822  -3.285  1.00  0.00           H  
ATOM    809  HA  LEU A  52      -1.428   4.940  -0.727  1.00  0.00           H  
ATOM    810  HB2 LEU A  52       0.894   6.561  -1.753  1.00  0.00           H  
ATOM    811  HB3 LEU A  52       0.665   5.961  -0.112  1.00  0.00           H  
ATOM    812  HG  LEU A  52       1.135   4.241  -2.547  1.00  0.00           H  
ATOM    813 HD11 LEU A  52       3.131   5.465  -2.047  1.00  0.00           H  
ATOM    814 HD12 LEU A  52       3.332   3.811  -1.469  1.00  0.00           H  
ATOM    815 HD13 LEU A  52       2.977   5.106  -0.325  1.00  0.00           H  
ATOM    816 HD21 LEU A  52      -0.089   3.560  -0.181  1.00  0.00           H  
ATOM    817 HD22 LEU A  52       1.592   3.104   0.095  1.00  0.00           H  
ATOM    818 HD23 LEU A  52       0.714   2.447  -1.288  1.00  0.00           H  
ATOM    819  N   VAL A  53      -1.536   7.938  -2.078  1.00  0.00           N  
ATOM    820  CA  VAL A  53      -2.106   9.272  -1.934  1.00  0.00           C  
ATOM    821  C   VAL A  53      -3.508   9.209  -1.341  1.00  0.00           C  
ATOM    822  O   VAL A  53      -4.483   8.958  -2.049  1.00  0.00           O  
ATOM    823  CB  VAL A  53      -2.165  10.006  -3.288  1.00  0.00           C  
ATOM    824  CG1 VAL A  53      -2.881   9.155  -4.325  1.00  0.00           C  
ATOM    825  CG2 VAL A  53      -2.847  11.356  -3.132  1.00  0.00           C  
ATOM    826  H   VAL A  53      -1.062   7.707  -2.904  1.00  0.00           H  
ATOM    827  HA  VAL A  53      -1.470   9.838  -1.270  1.00  0.00           H  
ATOM    828  HB  VAL A  53      -1.154  10.173  -3.628  1.00  0.00           H  
ATOM    829 HG11 VAL A  53      -3.622   9.754  -4.833  1.00  0.00           H  
ATOM    830 HG12 VAL A  53      -2.165   8.782  -5.043  1.00  0.00           H  
ATOM    831 HG13 VAL A  53      -3.367   8.323  -3.836  1.00  0.00           H  
ATOM    832 HG21 VAL A  53      -3.700  11.255  -2.477  1.00  0.00           H  
ATOM    833 HG22 VAL A  53      -2.150  12.065  -2.708  1.00  0.00           H  
ATOM    834 HG23 VAL A  53      -3.175  11.708  -4.099  1.00  0.00           H  
ATOM    835  N   GLY A  54      -3.604   9.440  -0.035  1.00  0.00           N  
ATOM    836  CA  GLY A  54      -4.892   9.406   0.632  1.00  0.00           C  
ATOM    837  C   GLY A  54      -4.987   8.288   1.652  1.00  0.00           C  
ATOM    838  O   GLY A  54      -5.540   8.475   2.738  1.00  0.00           O  
ATOM    839  H   GLY A  54      -2.794   9.636   0.479  1.00  0.00           H  
ATOM    840  HA2 GLY A  54      -5.053  10.350   1.130  1.00  0.00           H  
ATOM    841  HA3 GLY A  54      -5.666   9.265  -0.109  1.00  0.00           H  
ATOM    842  N   CYS A  55      -4.449   7.125   1.305  1.00  0.00           N  
ATOM    843  CA  CYS A  55      -4.478   5.973   2.199  1.00  0.00           C  
ATOM    844  C   CYS A  55      -3.916   6.334   3.571  1.00  0.00           C  
ATOM    845  O   CYS A  55      -3.503   7.470   3.802  1.00  0.00           O  
ATOM    846  CB  CYS A  55      -3.680   4.815   1.597  1.00  0.00           C  
ATOM    847  SG  CYS A  55      -3.944   4.579  -0.176  1.00  0.00           S  
ATOM    848  H   CYS A  55      -4.023   7.038   0.427  1.00  0.00           H  
ATOM    849  HA  CYS A  55      -5.506   5.668   2.314  1.00  0.00           H  
ATOM    850  HB2 CYS A  55      -2.625   4.996   1.750  1.00  0.00           H  
ATOM    851  HB3 CYS A  55      -3.957   3.898   2.097  1.00  0.00           H  
ATOM    852  HG  CYS A  55      -3.542   5.675  -0.799  1.00  0.00           H  
ATOM    853  N   GLU A  56      -3.905   5.361   4.475  1.00  0.00           N  
ATOM    854  CA  GLU A  56      -3.397   5.578   5.824  1.00  0.00           C  
ATOM    855  C   GLU A  56      -2.556   4.392   6.286  1.00  0.00           C  
ATOM    856  O   GLU A  56      -3.047   3.268   6.385  1.00  0.00           O  
ATOM    857  CB  GLU A  56      -4.554   5.806   6.799  1.00  0.00           C  
ATOM    858  CG  GLU A  56      -4.129   5.816   8.257  1.00  0.00           C  
ATOM    859  CD  GLU A  56      -5.299   5.995   9.205  1.00  0.00           C  
ATOM    860  OE1 GLU A  56      -6.113   6.914   8.974  1.00  0.00           O  
ATOM    861  OE2 GLU A  56      -5.401   5.217  10.177  1.00  0.00           O  
ATOM    862  H   GLU A  56      -4.248   4.476   4.230  1.00  0.00           H  
ATOM    863  HA  GLU A  56      -2.775   6.460   5.806  1.00  0.00           H  
ATOM    864  HB2 GLU A  56      -5.017   6.755   6.574  1.00  0.00           H  
ATOM    865  HB3 GLU A  56      -5.283   5.021   6.663  1.00  0.00           H  
ATOM    866  HG2 GLU A  56      -3.643   4.878   8.484  1.00  0.00           H  
ATOM    867  HG3 GLU A  56      -3.432   6.626   8.411  1.00  0.00           H  
ATOM    868  N   VAL A  57      -1.282   4.652   6.568  1.00  0.00           N  
ATOM    869  CA  VAL A  57      -0.371   3.607   7.020  1.00  0.00           C  
ATOM    870  C   VAL A  57      -0.345   3.520   8.541  1.00  0.00           C  
ATOM    871  O   VAL A  57       0.051   4.467   9.222  1.00  0.00           O  
ATOM    872  CB  VAL A  57       1.061   3.849   6.506  1.00  0.00           C  
ATOM    873  CG1 VAL A  57       1.984   2.724   6.946  1.00  0.00           C  
ATOM    874  CG2 VAL A  57       1.066   3.993   4.992  1.00  0.00           C  
ATOM    875  H   VAL A  57      -0.949   5.567   6.470  1.00  0.00           H  
ATOM    876  HA  VAL A  57      -0.718   2.664   6.621  1.00  0.00           H  
ATOM    877  HB  VAL A  57       1.424   4.771   6.936  1.00  0.00           H  
ATOM    878 HG11 VAL A  57       1.406   1.825   7.102  1.00  0.00           H  
ATOM    879 HG12 VAL A  57       2.727   2.548   6.181  1.00  0.00           H  
ATOM    880 HG13 VAL A  57       2.474   3.000   7.867  1.00  0.00           H  
ATOM    881 HG21 VAL A  57       1.828   4.700   4.701  1.00  0.00           H  
ATOM    882 HG22 VAL A  57       1.272   3.034   4.539  1.00  0.00           H  
ATOM    883 HG23 VAL A  57       0.101   4.348   4.660  1.00  0.00           H  
ATOM    884  N   VAL A  58      -0.770   2.377   9.072  1.00  0.00           N  
ATOM    885  CA  VAL A  58      -0.794   2.166  10.514  1.00  0.00           C  
ATOM    886  C   VAL A  58       0.054   0.962  10.907  1.00  0.00           C  
ATOM    887  O   VAL A  58       0.009  -0.094  10.275  1.00  0.00           O  
ATOM    888  CB  VAL A  58      -2.232   1.957  11.026  1.00  0.00           C  
ATOM    889  CG1 VAL A  58      -2.889   3.295  11.333  1.00  0.00           C  
ATOM    890  CG2 VAL A  58      -3.050   1.172  10.012  1.00  0.00           C  
ATOM    891  H   VAL A  58      -1.073   1.659   8.478  1.00  0.00           H  
ATOM    892  HA  VAL A  58      -0.390   3.049  10.987  1.00  0.00           H  
ATOM    893  HB  VAL A  58      -2.186   1.385  11.941  1.00  0.00           H  
ATOM    894 HG11 VAL A  58      -3.702   3.144  12.027  1.00  0.00           H  
ATOM    895 HG12 VAL A  58      -2.160   3.963  11.768  1.00  0.00           H  
ATOM    896 HG13 VAL A  58      -3.272   3.725  10.419  1.00  0.00           H  
ATOM    897 HG21 VAL A  58      -4.055   1.045  10.383  1.00  0.00           H  
ATOM    898 HG22 VAL A  58      -3.076   1.710   9.076  1.00  0.00           H  
ATOM    899 HG23 VAL A  58      -2.597   0.204   9.857  1.00  0.00           H  
ATOM    900  N   PRO A  59       0.846   1.121  11.978  1.00  0.00           N  
ATOM    901  CA  PRO A  59       1.719   0.056  12.480  1.00  0.00           C  
ATOM    902  C   PRO A  59       0.934  -1.090  13.110  1.00  0.00           C  
ATOM    903  O   PRO A  59       0.640  -1.070  14.305  1.00  0.00           O  
ATOM    904  CB  PRO A  59       2.570   0.764  13.537  1.00  0.00           C  
ATOM    905  CG  PRO A  59       1.737   1.915  13.985  1.00  0.00           C  
ATOM    906  CD  PRO A  59       0.951   2.351  12.780  1.00  0.00           C  
ATOM    907  HA  PRO A  59       2.360  -0.333  11.702  1.00  0.00           H  
ATOM    908  HB2 PRO A  59       2.777   0.085  14.352  1.00  0.00           H  
ATOM    909  HB3 PRO A  59       3.497   1.097  13.095  1.00  0.00           H  
ATOM    910  HG2 PRO A  59       1.071   1.602  14.774  1.00  0.00           H  
ATOM    911  HG3 PRO A  59       2.374   2.718  14.326  1.00  0.00           H  
ATOM    912  HD2 PRO A  59      -0.027   2.704  13.073  1.00  0.00           H  
ATOM    913  HD3 PRO A  59       1.483   3.119  12.238  1.00  0.00           H  
ATOM    914  N   ASP A  60       0.597  -2.086  12.298  1.00  0.00           N  
ATOM    915  CA  ASP A  60      -0.153  -3.241  12.775  1.00  0.00           C  
ATOM    916  C   ASP A  60       0.744  -4.470  12.873  1.00  0.00           C  
ATOM    917  O   ASP A  60       0.703  -5.367  12.031  1.00  0.00           O  
ATOM    918  CB  ASP A  60      -1.335  -3.529  11.847  1.00  0.00           C  
ATOM    919  CG  ASP A  60      -2.472  -4.232  12.559  1.00  0.00           C  
ATOM    920  OD1 ASP A  60      -2.247  -5.343  13.085  1.00  0.00           O  
ATOM    921  OD2 ASP A  60      -3.590  -3.675  12.589  1.00  0.00           O  
ATOM    922  H   ASP A  60       0.860  -2.043  11.355  1.00  0.00           H  
ATOM    923  HA  ASP A  60      -0.530  -3.008  13.760  1.00  0.00           H  
ATOM    924  HB2 ASP A  60      -1.707  -2.596  11.448  1.00  0.00           H  
ATOM    925  HB3 ASP A  60      -1.000  -4.156  11.034  1.00  0.00           H  
ATOM    926  N   PRO A  61       1.577  -4.514  13.924  1.00  0.00           N  
ATOM    927  CA  PRO A  61       2.502  -5.627  14.155  1.00  0.00           C  
ATOM    928  C   PRO A  61       1.777  -6.909  14.552  1.00  0.00           C  
ATOM    929  O   PRO A  61       0.558  -6.918  14.720  1.00  0.00           O  
ATOM    930  CB  PRO A  61       3.375  -5.129  15.309  1.00  0.00           C  
ATOM    931  CG  PRO A  61       2.529  -4.132  16.022  1.00  0.00           C  
ATOM    932  CD  PRO A  61       1.680  -3.480  14.966  1.00  0.00           C  
ATOM    933  HA  PRO A  61       3.119  -5.817  13.290  1.00  0.00           H  
ATOM    934  HB2 PRO A  61       3.636  -5.959  15.951  1.00  0.00           H  
ATOM    935  HB3 PRO A  61       4.273  -4.675  14.916  1.00  0.00           H  
ATOM    936  HG2 PRO A  61       1.906  -4.632  16.748  1.00  0.00           H  
ATOM    937  HG3 PRO A  61       3.156  -3.397  16.505  1.00  0.00           H  
ATOM    938  HD2 PRO A  61       0.706  -3.234  15.364  1.00  0.00           H  
ATOM    939  HD3 PRO A  61       2.166  -2.594  14.584  1.00  0.00           H  
ATOM    940  N   SER A  62       2.536  -7.991  14.700  1.00  0.00           N  
ATOM    941  CA  SER A  62       1.965  -9.280  15.073  1.00  0.00           C  
ATOM    942  C   SER A  62       2.769  -9.924  16.198  1.00  0.00           C  
ATOM    943  O   SER A  62       3.891  -9.521  16.503  1.00  0.00           O  
ATOM    944  CB  SER A  62       1.922 -10.213  13.862  1.00  0.00           C  
ATOM    945  OG  SER A  62       0.651 -10.183  13.238  1.00  0.00           O  
ATOM    946  H   SER A  62       3.502  -7.921  14.551  1.00  0.00           H  
ATOM    947  HA  SER A  62       0.957  -9.108  15.420  1.00  0.00           H  
ATOM    948  HB2 SER A  62       2.668  -9.903  13.145  1.00  0.00           H  
ATOM    949  HB3 SER A  62       2.130 -11.225  14.182  1.00  0.00           H  
ATOM    950  HG  SER A  62       0.275  -9.303  13.319  1.00  0.00           H  
ATOM    951  N   PRO A  63       2.181 -10.951  16.832  1.00  0.00           N  
ATOM    952  CA  PRO A  63       2.824 -11.675  17.932  1.00  0.00           C  
ATOM    953  C   PRO A  63       4.007 -12.514  17.462  1.00  0.00           C  
ATOM    954  O   PRO A  63       4.616 -13.241  18.248  1.00  0.00           O  
ATOM    955  CB  PRO A  63       1.707 -12.576  18.464  1.00  0.00           C  
ATOM    956  CG  PRO A  63       0.790 -12.765  17.306  1.00  0.00           C  
ATOM    957  CD  PRO A  63       0.845 -11.485  16.519  1.00  0.00           C  
ATOM    958  HA  PRO A  63       3.148 -11.002  18.712  1.00  0.00           H  
ATOM    959  HB2 PRO A  63       2.126 -13.516  18.795  1.00  0.00           H  
ATOM    960  HB3 PRO A  63       1.208 -12.088  19.287  1.00  0.00           H  
ATOM    961  HG2 PRO A  63       1.128 -13.592  16.700  1.00  0.00           H  
ATOM    962  HG3 PRO A  63      -0.216 -12.944  17.660  1.00  0.00           H  
ATOM    963  HD2 PRO A  63       0.746 -11.686  15.463  1.00  0.00           H  
ATOM    964  HD3 PRO A  63       0.073 -10.806  16.850  1.00  0.00           H  
ATOM    965  N   ASP A  64       4.327 -12.409  16.177  1.00  0.00           N  
ATOM    966  CA  ASP A  64       5.439 -13.157  15.602  1.00  0.00           C  
ATOM    967  C   ASP A  64       6.438 -12.219  14.932  1.00  0.00           C  
ATOM    968  O   ASP A  64       7.561 -12.612  14.618  1.00  0.00           O  
ATOM    969  CB  ASP A  64       4.923 -14.181  14.589  1.00  0.00           C  
ATOM    970  CG  ASP A  64       5.919 -15.295  14.334  1.00  0.00           C  
ATOM    971  OD1 ASP A  64       7.136 -15.012  14.321  1.00  0.00           O  
ATOM    972  OD2 ASP A  64       5.483 -16.449  14.146  1.00  0.00           O  
ATOM    973  H   ASP A  64       3.804 -11.812  15.601  1.00  0.00           H  
ATOM    974  HA  ASP A  64       5.938 -13.679  16.405  1.00  0.00           H  
ATOM    975  HB2 ASP A  64       4.010 -14.619  14.964  1.00  0.00           H  
ATOM    976  HB3 ASP A  64       4.721 -13.681  13.654  1.00  0.00           H  
ATOM    977  N   HIS A  65       6.019 -10.976  14.715  1.00  0.00           N  
ATOM    978  CA  HIS A  65       6.877  -9.981  14.080  1.00  0.00           C  
ATOM    979  C   HIS A  65       6.334  -8.573  14.306  1.00  0.00           C  
ATOM    980  O   HIS A  65       5.326  -8.183  13.714  1.00  0.00           O  
ATOM    981  CB  HIS A  65       6.996 -10.260  12.582  1.00  0.00           C  
ATOM    982  CG  HIS A  65       8.138 -11.163  12.231  1.00  0.00           C  
ATOM    983  ND1 HIS A  65       9.440 -10.721  12.115  1.00  0.00           N  
ATOM    984  CD2 HIS A  65       8.170 -12.491  11.970  1.00  0.00           C  
ATOM    985  CE1 HIS A  65      10.221 -11.737  11.798  1.00  0.00           C  
ATOM    986  NE2 HIS A  65       9.475 -12.824  11.704  1.00  0.00           N  
ATOM    987  H   HIS A  65       5.114 -10.722  14.987  1.00  0.00           H  
ATOM    988  HA  HIS A  65       7.855 -10.052  14.531  1.00  0.00           H  
ATOM    989  HB2 HIS A  65       6.086 -10.727  12.236  1.00  0.00           H  
ATOM    990  HB3 HIS A  65       7.138  -9.325  12.058  1.00  0.00           H  
ATOM    991  HD1 HIS A  65       9.744  -9.799  12.245  1.00  0.00           H  
ATOM    992  HD2 HIS A  65       7.325 -13.165  11.972  1.00  0.00           H  
ATOM    993  HE1 HIS A  65      11.288 -11.690  11.641  1.00  0.00           H  
ATOM    994  HE2 HIS A  65       9.789 -13.699  11.398  1.00  0.00           H  
ATOM    995  N   LEU A  66       7.007  -7.815  15.164  1.00  0.00           N  
ATOM    996  CA  LEU A  66       6.591  -6.449  15.468  1.00  0.00           C  
ATOM    997  C   LEU A  66       7.121  -5.473  14.423  1.00  0.00           C  
ATOM    998  O   LEU A  66       7.343  -4.297  14.713  1.00  0.00           O  
ATOM    999  CB  LEU A  66       7.083  -6.044  16.859  1.00  0.00           C  
ATOM   1000  CG  LEU A  66       6.984  -7.115  17.945  1.00  0.00           C  
ATOM   1001  CD1 LEU A  66       7.993  -6.848  19.051  1.00  0.00           C  
ATOM   1002  CD2 LEU A  66       5.572  -7.174  18.511  1.00  0.00           C  
ATOM   1003  H   LEU A  66       7.802  -8.180  15.604  1.00  0.00           H  
ATOM   1004  HA  LEU A  66       5.512  -6.421  15.454  1.00  0.00           H  
ATOM   1005  HB2 LEU A  66       8.119  -5.755  16.772  1.00  0.00           H  
ATOM   1006  HB3 LEU A  66       6.500  -5.192  17.179  1.00  0.00           H  
ATOM   1007  HG  LEU A  66       7.212  -8.079  17.512  1.00  0.00           H  
ATOM   1008 HD11 LEU A  66       8.853  -7.485  18.915  1.00  0.00           H  
ATOM   1009 HD12 LEU A  66       7.539  -7.056  20.009  1.00  0.00           H  
ATOM   1010 HD13 LEU A  66       8.301  -5.813  19.016  1.00  0.00           H  
ATOM   1011 HD21 LEU A  66       5.072  -6.235  18.324  1.00  0.00           H  
ATOM   1012 HD22 LEU A  66       5.618  -7.352  19.575  1.00  0.00           H  
ATOM   1013 HD23 LEU A  66       5.027  -7.975  18.033  1.00  0.00           H  
ATOM   1014  N   TYR A  67       7.322  -5.968  13.207  1.00  0.00           N  
ATOM   1015  CA  TYR A  67       7.827  -5.139  12.119  1.00  0.00           C  
ATOM   1016  C   TYR A  67       6.926  -5.244  10.892  1.00  0.00           C  
ATOM   1017  O   TYR A  67       7.407  -5.355   9.763  1.00  0.00           O  
ATOM   1018  CB  TYR A  67       9.254  -5.553  11.755  1.00  0.00           C  
ATOM   1019  CG  TYR A  67      10.099  -5.929  12.951  1.00  0.00           C  
ATOM   1020  CD1 TYR A  67      10.087  -5.157  14.106  1.00  0.00           C  
ATOM   1021  CD2 TYR A  67      10.909  -7.057  12.926  1.00  0.00           C  
ATOM   1022  CE1 TYR A  67      10.858  -5.496  15.201  1.00  0.00           C  
ATOM   1023  CE2 TYR A  67      11.682  -7.406  14.017  1.00  0.00           C  
ATOM   1024  CZ  TYR A  67      11.654  -6.622  15.152  1.00  0.00           C  
ATOM   1025  OH  TYR A  67      12.422  -6.964  16.241  1.00  0.00           O  
ATOM   1026  H   TYR A  67       7.128  -6.913  13.038  1.00  0.00           H  
ATOM   1027  HA  TYR A  67       7.835  -4.114  12.458  1.00  0.00           H  
ATOM   1028  HB2 TYR A  67       9.218  -6.404  11.095  1.00  0.00           H  
ATOM   1029  HB3 TYR A  67       9.741  -4.732  11.249  1.00  0.00           H  
ATOM   1030  HD1 TYR A  67       9.462  -4.276  14.141  1.00  0.00           H  
ATOM   1031  HD2 TYR A  67      10.930  -7.669  12.036  1.00  0.00           H  
ATOM   1032  HE1 TYR A  67      10.835  -4.883  16.089  1.00  0.00           H  
ATOM   1033  HE2 TYR A  67      12.306  -8.286  13.979  1.00  0.00           H  
ATOM   1034  HH  TYR A  67      12.080  -7.771  16.632  1.00  0.00           H  
ATOM   1035  N   SER A  68       5.618  -5.208  11.121  1.00  0.00           N  
ATOM   1036  CA  SER A  68       4.649  -5.301  10.036  1.00  0.00           C  
ATOM   1037  C   SER A  68       3.643  -4.155  10.104  1.00  0.00           C  
ATOM   1038  O   SER A  68       3.161  -3.802  11.181  1.00  0.00           O  
ATOM   1039  CB  SER A  68       3.915  -6.643  10.093  1.00  0.00           C  
ATOM   1040  OG  SER A  68       3.041  -6.794   8.988  1.00  0.00           O  
ATOM   1041  H   SER A  68       5.297  -5.118  12.043  1.00  0.00           H  
ATOM   1042  HA  SER A  68       5.188  -5.236   9.103  1.00  0.00           H  
ATOM   1043  HB2 SER A  68       4.637  -7.446  10.079  1.00  0.00           H  
ATOM   1044  HB3 SER A  68       3.336  -6.694  11.004  1.00  0.00           H  
ATOM   1045  HG  SER A  68       2.147  -6.942   9.304  1.00  0.00           H  
ATOM   1046  N   PHE A  69       3.332  -3.580   8.947  1.00  0.00           N  
ATOM   1047  CA  PHE A  69       2.386  -2.473   8.875  1.00  0.00           C  
ATOM   1048  C   PHE A  69       1.355  -2.710   7.775  1.00  0.00           C  
ATOM   1049  O   PHE A  69       1.565  -3.529   6.880  1.00  0.00           O  
ATOM   1050  CB  PHE A  69       3.124  -1.157   8.623  1.00  0.00           C  
ATOM   1051  CG  PHE A  69       4.175  -1.256   7.554  1.00  0.00           C  
ATOM   1052  CD1 PHE A  69       5.445  -1.719   7.853  1.00  0.00           C  
ATOM   1053  CD2 PHE A  69       3.891  -0.884   6.249  1.00  0.00           C  
ATOM   1054  CE1 PHE A  69       6.414  -1.810   6.872  1.00  0.00           C  
ATOM   1055  CE2 PHE A  69       4.856  -0.974   5.264  1.00  0.00           C  
ATOM   1056  CZ  PHE A  69       6.119  -1.437   5.575  1.00  0.00           C  
ATOM   1057  H   PHE A  69       3.749  -3.907   8.124  1.00  0.00           H  
ATOM   1058  HA  PHE A  69       1.873  -2.413   9.824  1.00  0.00           H  
ATOM   1059  HB2 PHE A  69       2.412  -0.406   8.320  1.00  0.00           H  
ATOM   1060  HB3 PHE A  69       3.606  -0.844   9.536  1.00  0.00           H  
ATOM   1061  HD1 PHE A  69       5.678  -2.012   8.867  1.00  0.00           H  
ATOM   1062  HD2 PHE A  69       2.903  -0.521   6.004  1.00  0.00           H  
ATOM   1063  HE1 PHE A  69       7.400  -2.173   7.118  1.00  0.00           H  
ATOM   1064  HE2 PHE A  69       4.621  -0.681   4.250  1.00  0.00           H  
ATOM   1065  HZ  PHE A  69       6.873  -1.507   4.806  1.00  0.00           H  
ATOM   1066  N   ARG A  70       0.242  -1.988   7.848  1.00  0.00           N  
ATOM   1067  CA  ARG A  70      -0.822  -2.120   6.861  1.00  0.00           C  
ATOM   1068  C   ARG A  70      -1.432  -0.760   6.534  1.00  0.00           C  
ATOM   1069  O   ARG A  70      -1.419   0.152   7.362  1.00  0.00           O  
ATOM   1070  CB  ARG A  70      -1.907  -3.069   7.372  1.00  0.00           C  
ATOM   1071  CG  ARG A  70      -2.450  -2.692   8.741  1.00  0.00           C  
ATOM   1072  CD  ARG A  70      -3.789  -3.359   9.012  1.00  0.00           C  
ATOM   1073  NE  ARG A  70      -4.634  -2.554   9.890  1.00  0.00           N  
ATOM   1074  CZ  ARG A  70      -5.610  -3.057  10.636  1.00  0.00           C  
ATOM   1075  NH1 ARG A  70      -5.863  -4.359  10.613  1.00  0.00           N  
ATOM   1076  NH2 ARG A  70      -6.336  -2.260  11.410  1.00  0.00           N  
ATOM   1077  H   ARG A  70       0.133  -1.351   8.586  1.00  0.00           H  
ATOM   1078  HA  ARG A  70      -0.390  -2.532   5.961  1.00  0.00           H  
ATOM   1079  HB2 ARG A  70      -2.729  -3.069   6.671  1.00  0.00           H  
ATOM   1080  HB3 ARG A  70      -1.497  -4.066   7.434  1.00  0.00           H  
ATOM   1081  HG2 ARG A  70      -1.745  -3.006   9.497  1.00  0.00           H  
ATOM   1082  HG3 ARG A  70      -2.575  -1.621   8.786  1.00  0.00           H  
ATOM   1083  HD2 ARG A  70      -4.300  -3.506   8.073  1.00  0.00           H  
ATOM   1084  HD3 ARG A  70      -3.611  -4.316   9.479  1.00  0.00           H  
ATOM   1085  HE  ARG A  70      -4.465  -1.589   9.923  1.00  0.00           H  
ATOM   1086 HH11 ARG A  70      -5.316  -4.963  10.032  1.00  0.00           H  
ATOM   1087 HH12 ARG A  70      -6.597  -4.737  11.178  1.00  0.00           H  
ATOM   1088 HH21 ARG A  70      -6.148  -1.278  11.430  1.00  0.00           H  
ATOM   1089 HH22 ARG A  70      -7.070  -2.640  11.971  1.00  0.00           H  
ATOM   1090  N   ILE A  71      -1.967  -0.633   5.325  1.00  0.00           N  
ATOM   1091  CA  ILE A  71      -2.582   0.615   4.890  1.00  0.00           C  
ATOM   1092  C   ILE A  71      -4.104   0.522   4.937  1.00  0.00           C  
ATOM   1093  O   ILE A  71      -4.676  -0.558   4.787  1.00  0.00           O  
ATOM   1094  CB  ILE A  71      -2.146   0.991   3.461  1.00  0.00           C  
ATOM   1095  CG1 ILE A  71      -0.753   0.430   3.167  1.00  0.00           C  
ATOM   1096  CG2 ILE A  71      -2.164   2.501   3.282  1.00  0.00           C  
ATOM   1097  CD1 ILE A  71      -0.327   0.598   1.725  1.00  0.00           C  
ATOM   1098  H   ILE A  71      -1.947  -1.395   4.710  1.00  0.00           H  
ATOM   1099  HA  ILE A  71      -2.259   1.397   5.561  1.00  0.00           H  
ATOM   1100  HB  ILE A  71      -2.853   0.562   2.768  1.00  0.00           H  
ATOM   1101 HG12 ILE A  71      -0.030   0.935   3.787  1.00  0.00           H  
ATOM   1102 HG13 ILE A  71      -0.742  -0.626   3.396  1.00  0.00           H  
ATOM   1103 HG21 ILE A  71      -1.255   2.922   3.687  1.00  0.00           H  
ATOM   1104 HG22 ILE A  71      -2.232   2.738   2.231  1.00  0.00           H  
ATOM   1105 HG23 ILE A  71      -3.014   2.916   3.802  1.00  0.00           H  
ATOM   1106 HD11 ILE A  71      -1.187   0.495   1.080  1.00  0.00           H  
ATOM   1107 HD12 ILE A  71       0.111   1.575   1.590  1.00  0.00           H  
ATOM   1108 HD13 ILE A  71       0.402  -0.160   1.474  1.00  0.00           H  
ATOM   1109  N   LEU A  72      -4.754   1.663   5.142  1.00  0.00           N  
ATOM   1110  CA  LEU A  72      -6.211   1.712   5.207  1.00  0.00           C  
ATOM   1111  C   LEU A  72      -6.749   2.918   4.445  1.00  0.00           C  
ATOM   1112  O   LEU A  72      -6.101   3.963   4.379  1.00  0.00           O  
ATOM   1113  CB  LEU A  72      -6.675   1.763   6.663  1.00  0.00           C  
ATOM   1114  CG  LEU A  72      -6.183   0.632   7.565  1.00  0.00           C  
ATOM   1115  CD1 LEU A  72      -6.035   1.118   8.999  1.00  0.00           C  
ATOM   1116  CD2 LEU A  72      -7.132  -0.556   7.498  1.00  0.00           C  
ATOM   1117  H   LEU A  72      -4.244   2.491   5.254  1.00  0.00           H  
ATOM   1118  HA  LEU A  72      -6.594   0.811   4.747  1.00  0.00           H  
ATOM   1119  HB2 LEU A  72      -6.333   2.695   7.085  1.00  0.00           H  
ATOM   1120  HB3 LEU A  72      -7.756   1.744   6.665  1.00  0.00           H  
ATOM   1121  HG  LEU A  72      -5.211   0.303   7.223  1.00  0.00           H  
ATOM   1122 HD11 LEU A  72      -5.281   1.888   9.042  1.00  0.00           H  
ATOM   1123 HD12 LEU A  72      -5.745   0.292   9.631  1.00  0.00           H  
ATOM   1124 HD13 LEU A  72      -6.979   1.518   9.342  1.00  0.00           H  
ATOM   1125 HD21 LEU A  72      -6.954  -1.106   6.586  1.00  0.00           H  
ATOM   1126 HD22 LEU A  72      -8.153  -0.201   7.512  1.00  0.00           H  
ATOM   1127 HD23 LEU A  72      -6.963  -1.200   8.347  1.00  0.00           H  
ATOM   1128  N   HIS A  73      -7.940   2.768   3.874  1.00  0.00           N  
ATOM   1129  CA  HIS A  73      -8.568   3.848   3.119  1.00  0.00           C  
ATOM   1130  C   HIS A  73      -9.900   4.245   3.746  1.00  0.00           C  
ATOM   1131  O   HIS A  73     -10.956   3.751   3.352  1.00  0.00           O  
ATOM   1132  CB  HIS A  73      -8.781   3.425   1.665  1.00  0.00           C  
ATOM   1133  CG  HIS A  73      -9.255   4.537   0.782  1.00  0.00           C  
ATOM   1134  ND1 HIS A  73     -10.586   4.870   0.639  1.00  0.00           N  
ATOM   1135  CD2 HIS A  73      -8.567   5.397  -0.006  1.00  0.00           C  
ATOM   1136  CE1 HIS A  73     -10.696   5.884  -0.200  1.00  0.00           C  
ATOM   1137  NE2 HIS A  73      -9.486   6.224  -0.606  1.00  0.00           N  
ATOM   1138  H   HIS A  73      -8.408   1.912   3.961  1.00  0.00           H  
ATOM   1139  HA  HIS A  73      -7.904   4.698   3.144  1.00  0.00           H  
ATOM   1140  HB2 HIS A  73      -7.848   3.057   1.263  1.00  0.00           H  
ATOM   1141  HB3 HIS A  73      -9.517   2.636   1.631  1.00  0.00           H  
ATOM   1142  HD1 HIS A  73     -11.337   4.426   1.084  1.00  0.00           H  
ATOM   1143  HD2 HIS A  73      -7.495   5.428  -0.139  1.00  0.00           H  
ATOM   1144  HE1 HIS A  73     -11.619   6.357  -0.503  1.00  0.00           H  
ATOM   1145  HE2 HIS A  73      -9.288   6.890  -1.295  1.00  0.00           H  
ATOM   1146  N   LYS A  74      -9.843   5.142   4.726  1.00  0.00           N  
ATOM   1147  CA  LYS A  74     -11.044   5.607   5.408  1.00  0.00           C  
ATOM   1148  C   LYS A  74     -11.569   4.547   6.371  1.00  0.00           C  
ATOM   1149  O   LYS A  74     -12.757   4.514   6.686  1.00  0.00           O  
ATOM   1150  CB  LYS A  74     -12.128   5.967   4.388  1.00  0.00           C  
ATOM   1151  CG  LYS A  74     -11.603   6.732   3.186  1.00  0.00           C  
ATOM   1152  CD  LYS A  74     -11.641   8.233   3.419  1.00  0.00           C  
ATOM   1153  CE  LYS A  74     -11.608   9.002   2.107  1.00  0.00           C  
ATOM   1154  NZ  LYS A  74     -10.221   9.143   1.583  1.00  0.00           N  
ATOM   1155  H   LYS A  74      -8.972   5.500   4.995  1.00  0.00           H  
ATOM   1156  HA  LYS A  74     -10.785   6.491   5.971  1.00  0.00           H  
ATOM   1157  HB2 LYS A  74     -12.590   5.057   4.036  1.00  0.00           H  
ATOM   1158  HB3 LYS A  74     -12.877   6.574   4.876  1.00  0.00           H  
ATOM   1159  HG2 LYS A  74     -10.582   6.434   2.999  1.00  0.00           H  
ATOM   1160  HG3 LYS A  74     -12.212   6.494   2.326  1.00  0.00           H  
ATOM   1161  HD2 LYS A  74     -12.550   8.483   3.947  1.00  0.00           H  
ATOM   1162  HD3 LYS A  74     -10.786   8.517   4.016  1.00  0.00           H  
ATOM   1163  HE2 LYS A  74     -12.207   8.474   1.381  1.00  0.00           H  
ATOM   1164  HE3 LYS A  74     -12.024   9.985   2.272  1.00  0.00           H  
ATOM   1165  HZ1 LYS A  74      -9.586   9.471   2.338  1.00  0.00           H  
ATOM   1166  HZ2 LYS A  74     -10.202   9.832   0.804  1.00  0.00           H  
ATOM   1167  HZ3 LYS A  74      -9.877   8.227   1.229  1.00  0.00           H  
ATOM   1168  N   GLY A  75     -10.673   3.683   6.837  1.00  0.00           N  
ATOM   1169  CA  GLY A  75     -11.064   2.634   7.761  1.00  0.00           C  
ATOM   1170  C   GLY A  75     -11.059   1.262   7.116  1.00  0.00           C  
ATOM   1171  O   GLY A  75     -11.146   0.246   7.805  1.00  0.00           O  
ATOM   1172  H   GLY A  75      -9.739   3.757   6.552  1.00  0.00           H  
ATOM   1173  HA2 GLY A  75     -10.381   2.631   8.596  1.00  0.00           H  
ATOM   1174  HA3 GLY A  75     -12.060   2.843   8.124  1.00  0.00           H  
ATOM   1175  N   GLU A  76     -10.958   1.232   5.791  1.00  0.00           N  
ATOM   1176  CA  GLU A  76     -10.943  -0.026   5.055  1.00  0.00           C  
ATOM   1177  C   GLU A  76      -9.519  -0.553   4.905  1.00  0.00           C  
ATOM   1178  O   GLU A  76      -8.562   0.079   5.353  1.00  0.00           O  
ATOM   1179  CB  GLU A  76     -11.578   0.158   3.675  1.00  0.00           C  
ATOM   1180  CG  GLU A  76     -13.076  -0.092   3.655  1.00  0.00           C  
ATOM   1181  CD  GLU A  76     -13.864   1.031   4.300  1.00  0.00           C  
ATOM   1182  OE1 GLU A  76     -13.822   2.163   3.773  1.00  0.00           O  
ATOM   1183  OE2 GLU A  76     -14.522   0.779   5.331  1.00  0.00           O  
ATOM   1184  H   GLU A  76     -10.891   2.077   5.297  1.00  0.00           H  
ATOM   1185  HA  GLU A  76     -11.523  -0.744   5.614  1.00  0.00           H  
ATOM   1186  HB2 GLU A  76     -11.398   1.170   3.341  1.00  0.00           H  
ATOM   1187  HB3 GLU A  76     -11.110  -0.527   2.983  1.00  0.00           H  
ATOM   1188  HG2 GLU A  76     -13.399  -0.194   2.630  1.00  0.00           H  
ATOM   1189  HG3 GLU A  76     -13.282  -1.009   4.189  1.00  0.00           H  
ATOM   1190  N   GLU A  77      -9.388  -1.715   4.273  1.00  0.00           N  
ATOM   1191  CA  GLU A  77      -8.081  -2.328   4.067  1.00  0.00           C  
ATOM   1192  C   GLU A  77      -7.662  -2.236   2.602  1.00  0.00           C  
ATOM   1193  O   GLU A  77      -8.455  -2.506   1.699  1.00  0.00           O  
ATOM   1194  CB  GLU A  77      -8.104  -3.793   4.510  1.00  0.00           C  
ATOM   1195  CG  GLU A  77      -6.759  -4.488   4.380  1.00  0.00           C  
ATOM   1196  CD  GLU A  77      -6.855  -5.987   4.595  1.00  0.00           C  
ATOM   1197  OE1 GLU A  77      -6.957  -6.412   5.765  1.00  0.00           O  
ATOM   1198  OE2 GLU A  77      -6.826  -6.733   3.595  1.00  0.00           O  
ATOM   1199  H   GLU A  77     -10.188  -2.172   3.939  1.00  0.00           H  
ATOM   1200  HA  GLU A  77      -7.363  -1.791   4.668  1.00  0.00           H  
ATOM   1201  HB2 GLU A  77      -8.411  -3.838   5.545  1.00  0.00           H  
ATOM   1202  HB3 GLU A  77      -8.822  -4.327   3.907  1.00  0.00           H  
ATOM   1203  HG2 GLU A  77      -6.368  -4.307   3.390  1.00  0.00           H  
ATOM   1204  HG3 GLU A  77      -6.082  -4.077   5.114  1.00  0.00           H  
ATOM   1205  N   LEU A  78      -6.411  -1.850   2.374  1.00  0.00           N  
ATOM   1206  CA  LEU A  78      -5.886  -1.720   1.020  1.00  0.00           C  
ATOM   1207  C   LEU A  78      -4.770  -2.730   0.769  1.00  0.00           C  
ATOM   1208  O   LEU A  78      -4.747  -3.400  -0.263  1.00  0.00           O  
ATOM   1209  CB  LEU A  78      -5.364  -0.301   0.787  1.00  0.00           C  
ATOM   1210  CG  LEU A  78      -6.306   0.834   1.191  1.00  0.00           C  
ATOM   1211  CD1 LEU A  78      -5.556   2.157   1.246  1.00  0.00           C  
ATOM   1212  CD2 LEU A  78      -7.478   0.924   0.223  1.00  0.00           C  
ATOM   1213  H   LEU A  78      -5.827  -1.647   3.133  1.00  0.00           H  
ATOM   1214  HA  LEU A  78      -6.693  -1.915   0.331  1.00  0.00           H  
ATOM   1215  HB2 LEU A  78      -4.451  -0.187   1.350  1.00  0.00           H  
ATOM   1216  HB3 LEU A  78      -5.151  -0.196  -0.267  1.00  0.00           H  
ATOM   1217  HG  LEU A  78      -6.701   0.634   2.177  1.00  0.00           H  
ATOM   1218 HD11 LEU A  78      -6.006   2.793   1.992  1.00  0.00           H  
ATOM   1219 HD12 LEU A  78      -5.607   2.640   0.282  1.00  0.00           H  
ATOM   1220 HD13 LEU A  78      -4.523   1.973   1.503  1.00  0.00           H  
ATOM   1221 HD21 LEU A  78      -7.559   0.000  -0.330  1.00  0.00           H  
ATOM   1222 HD22 LEU A  78      -7.315   1.742  -0.465  1.00  0.00           H  
ATOM   1223 HD23 LEU A  78      -8.389   1.095   0.775  1.00  0.00           H  
ATOM   1224  N   ALA A  79      -3.850  -2.836   1.721  1.00  0.00           N  
ATOM   1225  CA  ALA A  79      -2.735  -3.768   1.606  1.00  0.00           C  
ATOM   1226  C   ALA A  79      -2.081  -4.012   2.962  1.00  0.00           C  
ATOM   1227  O   ALA A  79      -2.470  -3.416   3.967  1.00  0.00           O  
ATOM   1228  CB  ALA A  79      -1.711  -3.246   0.610  1.00  0.00           C  
ATOM   1229  H   ALA A  79      -3.924  -2.276   2.521  1.00  0.00           H  
ATOM   1230  HA  ALA A  79      -3.121  -4.705   1.231  1.00  0.00           H  
ATOM   1231  HB1 ALA A  79      -1.438  -2.234   0.874  1.00  0.00           H  
ATOM   1232  HB2 ALA A  79      -0.834  -3.874   0.633  1.00  0.00           H  
ATOM   1233  HB3 ALA A  79      -2.137  -3.256  -0.382  1.00  0.00           H  
ATOM   1234  N   LYS A  80      -1.085  -4.892   2.984  1.00  0.00           N  
ATOM   1235  CA  LYS A  80      -0.375  -5.214   4.215  1.00  0.00           C  
ATOM   1236  C   LYS A  80       1.051  -5.667   3.919  1.00  0.00           C  
ATOM   1237  O   LYS A  80       1.265  -6.700   3.282  1.00  0.00           O  
ATOM   1238  CB  LYS A  80      -1.119  -6.306   4.986  1.00  0.00           C  
ATOM   1239  CG  LYS A  80      -0.583  -6.535   6.389  1.00  0.00           C  
ATOM   1240  CD  LYS A  80      -1.648  -7.110   7.307  1.00  0.00           C  
ATOM   1241  CE  LYS A  80      -1.084  -7.431   8.682  1.00  0.00           C  
ATOM   1242  NZ  LYS A  80      -1.186  -6.270   9.609  1.00  0.00           N  
ATOM   1243  H   LYS A  80      -0.820  -5.333   2.149  1.00  0.00           H  
ATOM   1244  HA  LYS A  80      -0.337  -4.320   4.820  1.00  0.00           H  
ATOM   1245  HB2 LYS A  80      -2.161  -6.031   5.061  1.00  0.00           H  
ATOM   1246  HB3 LYS A  80      -1.040  -7.234   4.438  1.00  0.00           H  
ATOM   1247  HG2 LYS A  80       0.246  -7.226   6.339  1.00  0.00           H  
ATOM   1248  HG3 LYS A  80      -0.244  -5.591   6.792  1.00  0.00           H  
ATOM   1249  HD2 LYS A  80      -2.445  -6.389   7.416  1.00  0.00           H  
ATOM   1250  HD3 LYS A  80      -2.039  -8.016   6.866  1.00  0.00           H  
ATOM   1251  HE2 LYS A  80      -1.636  -8.261   9.097  1.00  0.00           H  
ATOM   1252  HE3 LYS A  80      -0.046  -7.707   8.575  1.00  0.00           H  
ATOM   1253  HZ1 LYS A  80      -1.626  -5.462   9.122  1.00  0.00           H  
ATOM   1254  HZ2 LYS A  80      -0.239  -5.989   9.934  1.00  0.00           H  
ATOM   1255  HZ3 LYS A  80      -1.765  -6.521  10.435  1.00  0.00           H  
ATOM   1256  N   LEU A  81       2.023  -4.891   4.385  1.00  0.00           N  
ATOM   1257  CA  LEU A  81       3.430  -5.215   4.172  1.00  0.00           C  
ATOM   1258  C   LEU A  81       4.119  -5.545   5.491  1.00  0.00           C  
ATOM   1259  O   LEU A  81       3.624  -5.201   6.564  1.00  0.00           O  
ATOM   1260  CB  LEU A  81       4.143  -4.047   3.488  1.00  0.00           C  
ATOM   1261  CG  LEU A  81       3.545  -3.579   2.161  1.00  0.00           C  
ATOM   1262  CD1 LEU A  81       3.544  -4.711   1.146  1.00  0.00           C  
ATOM   1263  CD2 LEU A  81       2.134  -3.047   2.370  1.00  0.00           C  
ATOM   1264  H   LEU A  81       1.790  -4.082   4.886  1.00  0.00           H  
ATOM   1265  HA  LEU A  81       3.476  -6.081   3.528  1.00  0.00           H  
ATOM   1266  HB2 LEU A  81       4.133  -3.209   4.169  1.00  0.00           H  
ATOM   1267  HB3 LEU A  81       5.165  -4.347   3.304  1.00  0.00           H  
ATOM   1268  HG  LEU A  81       4.150  -2.776   1.764  1.00  0.00           H  
ATOM   1269 HD11 LEU A  81       2.548  -4.840   0.752  1.00  0.00           H  
ATOM   1270 HD12 LEU A  81       3.862  -5.625   1.626  1.00  0.00           H  
ATOM   1271 HD13 LEU A  81       4.224  -4.473   0.341  1.00  0.00           H  
ATOM   1272 HD21 LEU A  81       2.088  -2.510   3.307  1.00  0.00           H  
ATOM   1273 HD22 LEU A  81       1.438  -3.873   2.394  1.00  0.00           H  
ATOM   1274 HD23 LEU A  81       1.876  -2.381   1.560  1.00  0.00           H  
ATOM   1275  N   GLU A  82       5.266  -6.211   5.403  1.00  0.00           N  
ATOM   1276  CA  GLU A  82       6.024  -6.586   6.591  1.00  0.00           C  
ATOM   1277  C   GLU A  82       7.524  -6.471   6.338  1.00  0.00           C  
ATOM   1278  O   GLU A  82       8.041  -6.998   5.353  1.00  0.00           O  
ATOM   1279  CB  GLU A  82       5.675  -8.014   7.016  1.00  0.00           C  
ATOM   1280  CG  GLU A  82       6.779  -8.701   7.803  1.00  0.00           C  
ATOM   1281  CD  GLU A  82       6.249  -9.766   8.743  1.00  0.00           C  
ATOM   1282  OE1 GLU A  82       5.789 -10.817   8.251  1.00  0.00           O  
ATOM   1283  OE2 GLU A  82       6.294  -9.547   9.972  1.00  0.00           O  
ATOM   1284  H   GLU A  82       5.610  -6.457   4.519  1.00  0.00           H  
ATOM   1285  HA  GLU A  82       5.752  -5.907   7.386  1.00  0.00           H  
ATOM   1286  HB2 GLU A  82       4.787  -7.987   7.629  1.00  0.00           H  
ATOM   1287  HB3 GLU A  82       5.474  -8.600   6.132  1.00  0.00           H  
ATOM   1288  HG2 GLU A  82       7.463  -9.165   7.109  1.00  0.00           H  
ATOM   1289  HG3 GLU A  82       7.305  -7.958   8.384  1.00  0.00           H  
ATOM   1290  N   ALA A  83       8.218  -5.776   7.234  1.00  0.00           N  
ATOM   1291  CA  ALA A  83       9.659  -5.594   7.110  1.00  0.00           C  
ATOM   1292  C   ALA A  83      10.418  -6.728   7.789  1.00  0.00           C  
ATOM   1293  O   ALA A  83       9.819  -7.696   8.257  1.00  0.00           O  
ATOM   1294  CB  ALA A  83      10.072  -4.252   7.697  1.00  0.00           C  
ATOM   1295  H   ALA A  83       7.750  -5.380   7.998  1.00  0.00           H  
ATOM   1296  HA  ALA A  83       9.905  -5.588   6.057  1.00  0.00           H  
ATOM   1297  HB1 ALA A  83       9.278  -3.875   8.324  1.00  0.00           H  
ATOM   1298  HB2 ALA A  83      10.968  -4.380   8.288  1.00  0.00           H  
ATOM   1299  HB3 ALA A  83      10.264  -3.553   6.898  1.00  0.00           H  
ATOM   1300  N   LYS A  84      11.739  -6.602   7.839  1.00  0.00           N  
ATOM   1301  CA  LYS A  84      12.582  -7.617   8.461  1.00  0.00           C  
ATOM   1302  C   LYS A  84      13.021  -7.178   9.856  1.00  0.00           C  
ATOM   1303  O   LYS A  84      13.115  -7.995  10.772  1.00  0.00           O  
ATOM   1304  CB  LYS A  84      13.811  -7.894   7.593  1.00  0.00           C  
ATOM   1305  CG  LYS A  84      14.685  -6.672   7.370  1.00  0.00           C  
ATOM   1306  CD  LYS A  84      16.101  -7.064   6.983  1.00  0.00           C  
ATOM   1307  CE  LYS A  84      16.938  -7.411   8.204  1.00  0.00           C  
ATOM   1308  NZ  LYS A  84      16.725  -8.819   8.642  1.00  0.00           N  
ATOM   1309  H   LYS A  84      12.160  -5.807   7.449  1.00  0.00           H  
ATOM   1310  HA  LYS A  84      12.001  -8.523   8.549  1.00  0.00           H  
ATOM   1311  HB2 LYS A  84      14.408  -8.658   8.067  1.00  0.00           H  
ATOM   1312  HB3 LYS A  84      13.480  -8.254   6.629  1.00  0.00           H  
ATOM   1313  HG2 LYS A  84      14.259  -6.075   6.577  1.00  0.00           H  
ATOM   1314  HG3 LYS A  84      14.719  -6.093   8.282  1.00  0.00           H  
ATOM   1315  HD2 LYS A  84      16.063  -7.924   6.331  1.00  0.00           H  
ATOM   1316  HD3 LYS A  84      16.565  -6.237   6.462  1.00  0.00           H  
ATOM   1317  HE2 LYS A  84      17.981  -7.272   7.963  1.00  0.00           H  
ATOM   1318  HE3 LYS A  84      16.664  -6.747   9.012  1.00  0.00           H  
ATOM   1319  HZ1 LYS A  84      16.191  -9.340   7.917  1.00  0.00           H  
ATOM   1320  HZ2 LYS A  84      16.189  -8.839   9.532  1.00  0.00           H  
ATOM   1321  HZ3 LYS A  84      17.641  -9.289   8.789  1.00  0.00           H  
ATOM   1322  N   SER A  85      13.286  -5.885  10.009  1.00  0.00           N  
ATOM   1323  CA  SER A  85      13.718  -5.340  11.290  1.00  0.00           C  
ATOM   1324  C   SER A  85      12.859  -4.143  11.687  1.00  0.00           C  
ATOM   1325  O   SER A  85      12.200  -3.532  10.846  1.00  0.00           O  
ATOM   1326  CB  SER A  85      15.189  -4.927  11.224  1.00  0.00           C  
ATOM   1327  OG  SER A  85      15.419  -4.028  10.153  1.00  0.00           O  
ATOM   1328  H   SER A  85      13.192  -5.284   9.240  1.00  0.00           H  
ATOM   1329  HA  SER A  85      13.602  -6.113  12.035  1.00  0.00           H  
ATOM   1330  HB2 SER A  85      15.468  -4.445  12.149  1.00  0.00           H  
ATOM   1331  HB3 SER A  85      15.800  -5.806  11.078  1.00  0.00           H  
ATOM   1332  HG  SER A  85      15.143  -4.435   9.329  1.00  0.00           H  
ATOM   1333  N   SER A  86      12.874  -3.813  12.975  1.00  0.00           N  
ATOM   1334  CA  SER A  86      12.094  -2.692  13.486  1.00  0.00           C  
ATOM   1335  C   SER A  86      12.495  -1.392  12.794  1.00  0.00           C  
ATOM   1336  O   SER A  86      11.642  -0.607  12.382  1.00  0.00           O  
ATOM   1337  CB  SER A  86      12.284  -2.557  14.997  1.00  0.00           C  
ATOM   1338  OG  SER A  86      13.577  -2.066  15.308  1.00  0.00           O  
ATOM   1339  H   SER A  86      13.420  -4.338  13.596  1.00  0.00           H  
ATOM   1340  HA  SER A  86      11.053  -2.890  13.279  1.00  0.00           H  
ATOM   1341  HB2 SER A  86      11.548  -1.873  15.391  1.00  0.00           H  
ATOM   1342  HB3 SER A  86      12.160  -3.525  15.461  1.00  0.00           H  
ATOM   1343  HG  SER A  86      14.239  -2.698  15.020  1.00  0.00           H  
ATOM   1344  N   GLU A  87      13.800  -1.172  12.671  1.00  0.00           N  
ATOM   1345  CA  GLU A  87      14.314   0.032  12.030  1.00  0.00           C  
ATOM   1346  C   GLU A  87      13.801   0.148  10.599  1.00  0.00           C  
ATOM   1347  O   GLU A  87      13.544   1.248  10.108  1.00  0.00           O  
ATOM   1348  CB  GLU A  87      15.844   0.026  12.036  1.00  0.00           C  
ATOM   1349  CG  GLU A  87      16.448   0.047  13.431  1.00  0.00           C  
ATOM   1350  CD  GLU A  87      15.914   1.182  14.282  1.00  0.00           C  
ATOM   1351  OE1 GLU A  87      15.703   2.285  13.736  1.00  0.00           O  
ATOM   1352  OE2 GLU A  87      15.705   0.966  15.495  1.00  0.00           O  
ATOM   1353  H   GLU A  87      14.432  -1.835  13.020  1.00  0.00           H  
ATOM   1354  HA  GLU A  87      13.965   0.883  12.595  1.00  0.00           H  
ATOM   1355  HB2 GLU A  87      16.191  -0.862  11.529  1.00  0.00           H  
ATOM   1356  HB3 GLU A  87      16.198   0.896  11.501  1.00  0.00           H  
ATOM   1357  HG2 GLU A  87      16.221  -0.888  13.921  1.00  0.00           H  
ATOM   1358  HG3 GLU A  87      17.519   0.155  13.344  1.00  0.00           H  
ATOM   1359  N   GLU A  88      13.654  -0.993   9.934  1.00  0.00           N  
ATOM   1360  CA  GLU A  88      13.173  -1.019   8.557  1.00  0.00           C  
ATOM   1361  C   GLU A  88      11.734  -0.515   8.475  1.00  0.00           C  
ATOM   1362  O   GLU A  88      11.428   0.394   7.704  1.00  0.00           O  
ATOM   1363  CB  GLU A  88      13.260  -2.438   7.990  1.00  0.00           C  
ATOM   1364  CG  GLU A  88      13.300  -2.484   6.472  1.00  0.00           C  
ATOM   1365  CD  GLU A  88      13.748  -3.832   5.941  1.00  0.00           C  
ATOM   1366  OE1 GLU A  88      14.974  -4.060   5.858  1.00  0.00           O  
ATOM   1367  OE2 GLU A  88      12.874  -4.658   5.608  1.00  0.00           O  
ATOM   1368  H   GLU A  88      13.875  -1.838  10.379  1.00  0.00           H  
ATOM   1369  HA  GLU A  88      13.804  -0.368   7.973  1.00  0.00           H  
ATOM   1370  HB2 GLU A  88      14.156  -2.908   8.368  1.00  0.00           H  
ATOM   1371  HB3 GLU A  88      12.401  -3.000   8.324  1.00  0.00           H  
ATOM   1372  HG2 GLU A  88      12.311  -2.275   6.092  1.00  0.00           H  
ATOM   1373  HG3 GLU A  88      13.987  -1.728   6.119  1.00  0.00           H  
ATOM   1374  N   MET A  89      10.857  -1.113   9.274  1.00  0.00           N  
ATOM   1375  CA  MET A  89       9.452  -0.724   9.292  1.00  0.00           C  
ATOM   1376  C   MET A  89       9.302   0.758   9.620  1.00  0.00           C  
ATOM   1377  O   MET A  89       8.379   1.419   9.144  1.00  0.00           O  
ATOM   1378  CB  MET A  89       8.680  -1.565  10.311  1.00  0.00           C  
ATOM   1379  CG  MET A  89       9.044  -1.255  11.754  1.00  0.00           C  
ATOM   1380  SD  MET A  89       7.688  -1.582  12.897  1.00  0.00           S  
ATOM   1381  CE  MET A  89       6.338  -0.746  12.068  1.00  0.00           C  
ATOM   1382  H   MET A  89      11.162  -1.832   9.866  1.00  0.00           H  
ATOM   1383  HA  MET A  89       9.045  -0.906   8.308  1.00  0.00           H  
ATOM   1384  HB2 MET A  89       7.624  -1.387  10.182  1.00  0.00           H  
ATOM   1385  HB3 MET A  89       8.887  -2.610  10.128  1.00  0.00           H  
ATOM   1386  HG2 MET A  89       9.889  -1.864  12.037  1.00  0.00           H  
ATOM   1387  HG3 MET A  89       9.314  -0.212  11.825  1.00  0.00           H  
ATOM   1388  HE1 MET A  89       6.735  -0.032  11.363  1.00  0.00           H  
ATOM   1389  HE2 MET A  89       5.734  -1.471  11.544  1.00  0.00           H  
ATOM   1390  HE3 MET A  89       5.731  -0.231  12.799  1.00  0.00           H  
ATOM   1391  N   GLY A  90      10.215   1.274  10.438  1.00  0.00           N  
ATOM   1392  CA  GLY A  90      10.165   2.674  10.816  1.00  0.00           C  
ATOM   1393  C   GLY A  90      10.427   3.601   9.646  1.00  0.00           C  
ATOM   1394  O   GLY A  90       9.939   4.730   9.618  1.00  0.00           O  
ATOM   1395  H   GLY A  90      10.927   0.699  10.787  1.00  0.00           H  
ATOM   1396  HA2 GLY A  90       9.189   2.891  11.222  1.00  0.00           H  
ATOM   1397  HA3 GLY A  90      10.909   2.856  11.578  1.00  0.00           H  
ATOM   1398  N   HIS A  91      11.201   3.123   8.676  1.00  0.00           N  
ATOM   1399  CA  HIS A  91      11.528   3.917   7.497  1.00  0.00           C  
ATOM   1400  C   HIS A  91      10.383   3.892   6.490  1.00  0.00           C  
ATOM   1401  O   HIS A  91      10.192   4.839   5.728  1.00  0.00           O  
ATOM   1402  CB  HIS A  91      12.810   3.396   6.845  1.00  0.00           C  
ATOM   1403  CG  HIS A  91      12.985   3.847   5.427  1.00  0.00           C  
ATOM   1404  ND1 HIS A  91      13.379   5.123   5.087  1.00  0.00           N  
ATOM   1405  CD2 HIS A  91      12.820   3.182   4.260  1.00  0.00           C  
ATOM   1406  CE1 HIS A  91      13.447   5.225   3.771  1.00  0.00           C  
ATOM   1407  NE2 HIS A  91      13.113   4.060   3.246  1.00  0.00           N  
ATOM   1408  H   HIS A  91      11.561   2.214   8.756  1.00  0.00           H  
ATOM   1409  HA  HIS A  91      11.687   4.936   7.818  1.00  0.00           H  
ATOM   1410  HB2 HIS A  91      13.661   3.743   7.410  1.00  0.00           H  
ATOM   1411  HB3 HIS A  91      12.795   2.315   6.850  1.00  0.00           H  
ATOM   1412  HD1 HIS A  91      13.578   5.848   5.716  1.00  0.00           H  
ATOM   1413  HD2 HIS A  91      12.514   2.151   4.145  1.00  0.00           H  
ATOM   1414  HE1 HIS A  91      13.729   6.110   3.220  1.00  0.00           H  
ATOM   1415  HE2 HIS A  91      12.998   3.886   2.289  1.00  0.00           H  
ATOM   1416  N   TRP A  92       9.624   2.801   6.492  1.00  0.00           N  
ATOM   1417  CA  TRP A  92       8.498   2.652   5.577  1.00  0.00           C  
ATOM   1418  C   TRP A  92       7.275   3.400   6.094  1.00  0.00           C  
ATOM   1419  O   TRP A  92       6.585   4.083   5.336  1.00  0.00           O  
ATOM   1420  CB  TRP A  92       8.163   1.173   5.385  1.00  0.00           C  
ATOM   1421  CG  TRP A  92       9.102   0.468   4.454  1.00  0.00           C  
ATOM   1422  CD1 TRP A  92      10.229  -0.226   4.796  1.00  0.00           C  
ATOM   1423  CD2 TRP A  92       8.997   0.387   3.028  1.00  0.00           C  
ATOM   1424  NE1 TRP A  92      10.830  -0.731   3.668  1.00  0.00           N  
ATOM   1425  CE2 TRP A  92      10.094  -0.369   2.571  1.00  0.00           C  
ATOM   1426  CE3 TRP A  92       8.082   0.880   2.093  1.00  0.00           C  
ATOM   1427  CZ2 TRP A  92      10.298  -0.643   1.221  1.00  0.00           C  
ATOM   1428  CZ3 TRP A  92       8.288   0.609   0.754  1.00  0.00           C  
ATOM   1429  CH2 TRP A  92       9.387  -0.147   0.329  1.00  0.00           C  
ATOM   1430  H   TRP A  92       9.826   2.079   7.123  1.00  0.00           H  
ATOM   1431  HA  TRP A  92       8.787   3.074   4.626  1.00  0.00           H  
ATOM   1432  HB2 TRP A  92       8.203   0.674   6.341  1.00  0.00           H  
ATOM   1433  HB3 TRP A  92       7.165   1.087   4.980  1.00  0.00           H  
ATOM   1434  HD1 TRP A  92      10.584  -0.347   5.808  1.00  0.00           H  
ATOM   1435  HE1 TRP A  92      11.652  -1.264   3.653  1.00  0.00           H  
ATOM   1436  HE3 TRP A  92       7.229   1.464   2.402  1.00  0.00           H  
ATOM   1437  HZ2 TRP A  92      11.141  -1.225   0.877  1.00  0.00           H  
ATOM   1438  HZ3 TRP A  92       7.591   0.981   0.017  1.00  0.00           H  
ATOM   1439  HH2 TRP A  92       9.508  -0.335  -0.727  1.00  0.00           H  
ATOM   1440  N   LEU A  93       7.009   3.268   7.389  1.00  0.00           N  
ATOM   1441  CA  LEU A  93       5.867   3.932   8.008  1.00  0.00           C  
ATOM   1442  C   LEU A  93       5.800   5.398   7.594  1.00  0.00           C  
ATOM   1443  O   LEU A  93       4.821   5.840   6.993  1.00  0.00           O  
ATOM   1444  CB  LEU A  93       5.953   3.824   9.531  1.00  0.00           C  
ATOM   1445  CG  LEU A  93       5.418   2.530  10.144  1.00  0.00           C  
ATOM   1446  CD1 LEU A  93       5.495   2.586  11.662  1.00  0.00           C  
ATOM   1447  CD2 LEU A  93       3.988   2.275   9.690  1.00  0.00           C  
ATOM   1448  H   LEU A  93       7.593   2.711   7.943  1.00  0.00           H  
ATOM   1449  HA  LEU A  93       4.970   3.434   7.670  1.00  0.00           H  
ATOM   1450  HB2 LEU A  93       6.991   3.918   9.811  1.00  0.00           H  
ATOM   1451  HB3 LEU A  93       5.393   4.647   9.953  1.00  0.00           H  
ATOM   1452  HG  LEU A  93       6.029   1.701   9.811  1.00  0.00           H  
ATOM   1453 HD11 LEU A  93       6.001   3.490  11.964  1.00  0.00           H  
ATOM   1454 HD12 LEU A  93       6.040   1.729  12.027  1.00  0.00           H  
ATOM   1455 HD13 LEU A  93       4.495   2.577  12.073  1.00  0.00           H  
ATOM   1456 HD21 LEU A  93       3.993   1.930   8.666  1.00  0.00           H  
ATOM   1457 HD22 LEU A  93       3.421   3.191   9.759  1.00  0.00           H  
ATOM   1458 HD23 LEU A  93       3.539   1.523  10.322  1.00  0.00           H  
ATOM   1459  N   GLY A  94       6.848   6.149   7.918  1.00  0.00           N  
ATOM   1460  CA  GLY A  94       6.889   7.557   7.569  1.00  0.00           C  
ATOM   1461  C   GLY A  94       7.006   7.782   6.075  1.00  0.00           C  
ATOM   1462  O   GLY A  94       6.449   8.741   5.537  1.00  0.00           O  
ATOM   1463  H   GLY A  94       7.600   5.742   8.397  1.00  0.00           H  
ATOM   1464  HA2 GLY A  94       5.985   8.031   7.925  1.00  0.00           H  
ATOM   1465  HA3 GLY A  94       7.739   8.012   8.057  1.00  0.00           H  
ATOM   1466  N   LEU A  95       7.733   6.897   5.400  1.00  0.00           N  
ATOM   1467  CA  LEU A  95       7.922   7.004   3.958  1.00  0.00           C  
ATOM   1468  C   LEU A  95       6.582   6.992   3.230  1.00  0.00           C  
ATOM   1469  O   LEU A  95       6.317   7.845   2.382  1.00  0.00           O  
ATOM   1470  CB  LEU A  95       8.800   5.856   3.454  1.00  0.00           C  
ATOM   1471  CG  LEU A  95       8.762   5.596   1.947  1.00  0.00           C  
ATOM   1472  CD1 LEU A  95       9.819   6.426   1.236  1.00  0.00           C  
ATOM   1473  CD2 LEU A  95       8.960   4.115   1.657  1.00  0.00           C  
ATOM   1474  H   LEU A  95       8.151   6.154   5.883  1.00  0.00           H  
ATOM   1475  HA  LEU A  95       8.419   7.941   3.758  1.00  0.00           H  
ATOM   1476  HB2 LEU A  95       9.820   6.077   3.725  1.00  0.00           H  
ATOM   1477  HB3 LEU A  95       8.482   4.953   3.954  1.00  0.00           H  
ATOM   1478  HG  LEU A  95       7.795   5.886   1.561  1.00  0.00           H  
ATOM   1479 HD11 LEU A  95       9.684   7.468   1.481  1.00  0.00           H  
ATOM   1480 HD12 LEU A  95       9.724   6.293   0.168  1.00  0.00           H  
ATOM   1481 HD13 LEU A  95      10.802   6.105   1.551  1.00  0.00           H  
ATOM   1482 HD21 LEU A  95       8.849   3.939   0.598  1.00  0.00           H  
ATOM   1483 HD22 LEU A  95       8.221   3.541   2.197  1.00  0.00           H  
ATOM   1484 HD23 LEU A  95       9.949   3.816   1.970  1.00  0.00           H  
ATOM   1485  N   LEU A  96       5.740   6.023   3.568  1.00  0.00           N  
ATOM   1486  CA  LEU A  96       4.425   5.900   2.948  1.00  0.00           C  
ATOM   1487  C   LEU A  96       3.505   7.034   3.393  1.00  0.00           C  
ATOM   1488  O   LEU A  96       2.890   7.709   2.568  1.00  0.00           O  
ATOM   1489  CB  LEU A  96       3.796   4.551   3.300  1.00  0.00           C  
ATOM   1490  CG  LEU A  96       4.501   3.316   2.738  1.00  0.00           C  
ATOM   1491  CD1 LEU A  96       4.074   2.068   3.495  1.00  0.00           C  
ATOM   1492  CD2 LEU A  96       4.208   3.165   1.251  1.00  0.00           C  
ATOM   1493  H   LEU A  96       6.007   5.372   4.251  1.00  0.00           H  
ATOM   1494  HA  LEU A  96       4.556   5.960   1.878  1.00  0.00           H  
ATOM   1495  HB2 LEU A  96       3.782   4.463   4.375  1.00  0.00           H  
ATOM   1496  HB3 LEU A  96       2.780   4.553   2.927  1.00  0.00           H  
ATOM   1497  HG  LEU A  96       5.569   3.432   2.860  1.00  0.00           H  
ATOM   1498 HD11 LEU A  96       3.017   1.904   3.354  1.00  0.00           H  
ATOM   1499 HD12 LEU A  96       4.282   2.197   4.547  1.00  0.00           H  
ATOM   1500 HD13 LEU A  96       4.625   1.215   3.122  1.00  0.00           H  
ATOM   1501 HD21 LEU A  96       5.006   3.619   0.681  1.00  0.00           H  
ATOM   1502 HD22 LEU A  96       3.274   3.655   1.017  1.00  0.00           H  
ATOM   1503 HD23 LEU A  96       4.139   2.117   1.003  1.00  0.00           H  
ATOM   1504  N   LEU A  97       3.420   7.238   4.703  1.00  0.00           N  
ATOM   1505  CA  LEU A  97       2.578   8.292   5.260  1.00  0.00           C  
ATOM   1506  C   LEU A  97       2.738   9.589   4.473  1.00  0.00           C  
ATOM   1507  O   LEU A  97       1.754  10.192   4.045  1.00  0.00           O  
ATOM   1508  CB  LEU A  97       2.926   8.527   6.730  1.00  0.00           C  
ATOM   1509  CG  LEU A  97       2.180   7.659   7.744  1.00  0.00           C  
ATOM   1510  CD1 LEU A  97       2.987   7.524   9.027  1.00  0.00           C  
ATOM   1511  CD2 LEU A  97       0.806   8.242   8.036  1.00  0.00           C  
ATOM   1512  H   LEU A  97       3.934   6.668   5.312  1.00  0.00           H  
ATOM   1513  HA  LEU A  97       1.550   7.966   5.189  1.00  0.00           H  
ATOM   1514  HB2 LEU A  97       3.982   8.345   6.853  1.00  0.00           H  
ATOM   1515  HB3 LEU A  97       2.712   9.562   6.959  1.00  0.00           H  
ATOM   1516  HG  LEU A  97       2.044   6.669   7.330  1.00  0.00           H  
ATOM   1517 HD11 LEU A  97       2.776   8.362   9.674  1.00  0.00           H  
ATOM   1518 HD12 LEU A  97       4.039   7.507   8.789  1.00  0.00           H  
ATOM   1519 HD13 LEU A  97       2.716   6.605   9.527  1.00  0.00           H  
ATOM   1520 HD21 LEU A  97       0.555   8.072   9.073  1.00  0.00           H  
ATOM   1521 HD22 LEU A  97       0.070   7.762   7.405  1.00  0.00           H  
ATOM   1522 HD23 LEU A  97       0.814   9.303   7.836  1.00  0.00           H  
ATOM   1523  N   SER A  98       3.984  10.011   4.286  1.00  0.00           N  
ATOM   1524  CA  SER A  98       4.274  11.238   3.552  1.00  0.00           C  
ATOM   1525  C   SER A  98       3.588  11.230   2.189  1.00  0.00           C  
ATOM   1526  O   SER A  98       3.012  12.233   1.767  1.00  0.00           O  
ATOM   1527  CB  SER A  98       5.783  11.407   3.376  1.00  0.00           C  
ATOM   1528  OG  SER A  98       6.281  10.534   2.376  1.00  0.00           O  
ATOM   1529  H   SER A  98       4.726   9.486   4.653  1.00  0.00           H  
ATOM   1530  HA  SER A  98       3.892  12.067   4.130  1.00  0.00           H  
ATOM   1531  HB2 SER A  98       5.998  12.425   3.086  1.00  0.00           H  
ATOM   1532  HB3 SER A  98       6.279  11.187   4.309  1.00  0.00           H  
ATOM   1533  HG  SER A  98       6.969   9.978   2.751  1.00  0.00           H  
ATOM   1534  N   GLU A  99       3.655  10.092   1.507  1.00  0.00           N  
ATOM   1535  CA  GLU A  99       3.042   9.953   0.191  1.00  0.00           C  
ATOM   1536  C   GLU A  99       1.520   9.974   0.295  1.00  0.00           C  
ATOM   1537  O   GLU A  99       0.844  10.655  -0.476  1.00  0.00           O  
ATOM   1538  CB  GLU A  99       3.500   8.655  -0.476  1.00  0.00           C  
ATOM   1539  CG  GLU A  99       5.010   8.536  -0.605  1.00  0.00           C  
ATOM   1540  CD  GLU A  99       5.627   9.714  -1.333  1.00  0.00           C  
ATOM   1541  OE1 GLU A  99       5.524  10.849  -0.823  1.00  0.00           O  
ATOM   1542  OE2 GLU A  99       6.215   9.501  -2.415  1.00  0.00           O  
ATOM   1543  H   GLU A  99       4.129   9.327   1.896  1.00  0.00           H  
ATOM   1544  HA  GLU A  99       3.361  10.789  -0.413  1.00  0.00           H  
ATOM   1545  HB2 GLU A  99       3.143   7.819   0.107  1.00  0.00           H  
ATOM   1546  HB3 GLU A  99       3.071   8.601  -1.465  1.00  0.00           H  
ATOM   1547  HG2 GLU A  99       5.440   8.479   0.384  1.00  0.00           H  
ATOM   1548  HG3 GLU A  99       5.242   7.634  -1.150  1.00  0.00           H  
ATOM   1549  N   SER A 100       0.988   9.223   1.254  1.00  0.00           N  
ATOM   1550  CA  SER A 100      -0.455   9.151   1.457  1.00  0.00           C  
ATOM   1551  C   SER A 100      -0.973  10.423   2.123  1.00  0.00           C  
ATOM   1552  O   SER A 100      -1.223  10.449   3.327  1.00  0.00           O  
ATOM   1553  CB  SER A 100      -0.810   7.934   2.312  1.00  0.00           C  
ATOM   1554  OG  SER A 100      -0.307   8.070   3.628  1.00  0.00           O  
ATOM   1555  H   SER A 100       1.580   8.704   1.837  1.00  0.00           H  
ATOM   1556  HA  SER A 100      -0.921   9.051   0.489  1.00  0.00           H  
ATOM   1557  HB2 SER A 100      -1.884   7.832   2.359  1.00  0.00           H  
ATOM   1558  HB3 SER A 100      -0.383   7.047   1.865  1.00  0.00           H  
ATOM   1559  HG  SER A 100      -0.259   7.206   4.045  1.00  0.00           H  
ATOM   1560  N   GLY A 101      -1.133  11.476   1.328  1.00  0.00           N  
ATOM   1561  CA  GLY A 101      -1.620  12.738   1.857  1.00  0.00           C  
ATOM   1562  C   GLY A 101      -0.668  13.885   1.589  1.00  0.00           C  
ATOM   1563  O   GLY A 101       0.238  14.147   2.381  1.00  0.00           O  
ATOM   1564  H   GLY A 101      -0.918  11.398   0.375  1.00  0.00           H  
ATOM   1565  HA2 GLY A 101      -2.574  12.961   1.402  1.00  0.00           H  
ATOM   1566  HA3 GLY A 101      -1.756  12.638   2.924  1.00  0.00           H  
ATOM   1567  N   SER A 102      -0.870  14.572   0.469  1.00  0.00           N  
ATOM   1568  CA  SER A 102      -0.018  15.695   0.096  1.00  0.00           C  
ATOM   1569  C   SER A 102      -0.723  16.602  -0.907  1.00  0.00           C  
ATOM   1570  O   SER A 102      -1.404  16.131  -1.817  1.00  0.00           O  
ATOM   1571  CB  SER A 102       1.299  15.189  -0.495  1.00  0.00           C  
ATOM   1572  OG  SER A 102       1.989  14.365   0.428  1.00  0.00           O  
ATOM   1573  H   SER A 102      -1.608  14.315  -0.122  1.00  0.00           H  
ATOM   1574  HA  SER A 102       0.193  16.262   0.991  1.00  0.00           H  
ATOM   1575  HB2 SER A 102       1.094  14.617  -1.387  1.00  0.00           H  
ATOM   1576  HB3 SER A 102       1.926  16.033  -0.746  1.00  0.00           H  
ATOM   1577  HG  SER A 102       2.917  14.317   0.183  1.00  0.00           H  
ATOM   1578  N   GLY A 103      -0.556  17.910  -0.733  1.00  0.00           N  
ATOM   1579  CA  GLY A 103      -1.183  18.864  -1.628  1.00  0.00           C  
ATOM   1580  C   GLY A 103      -2.082  19.842  -0.898  1.00  0.00           C  
ATOM   1581  O   GLY A 103      -1.892  20.128   0.284  1.00  0.00           O  
ATOM   1582  H   GLY A 103      -0.003  18.229   0.012  1.00  0.00           H  
ATOM   1583  HA2 GLY A 103      -0.412  19.416  -2.145  1.00  0.00           H  
ATOM   1584  HA3 GLY A 103      -1.773  18.325  -2.355  1.00  0.00           H  
ATOM   1585  N   PRO A 104      -3.086  20.374  -1.609  1.00  0.00           N  
ATOM   1586  CA  PRO A 104      -4.037  21.335  -1.042  1.00  0.00           C  
ATOM   1587  C   PRO A 104      -4.970  20.692  -0.021  1.00  0.00           C  
ATOM   1588  O   PRO A 104      -5.863  21.348   0.516  1.00  0.00           O  
ATOM   1589  CB  PRO A 104      -4.827  21.815  -2.262  1.00  0.00           C  
ATOM   1590  CG  PRO A 104      -4.724  20.699  -3.243  1.00  0.00           C  
ATOM   1591  CD  PRO A 104      -3.371  20.078  -3.024  1.00  0.00           C  
ATOM   1592  HA  PRO A 104      -3.529  22.173  -0.587  1.00  0.00           H  
ATOM   1593  HB2 PRO A 104      -5.855  21.998  -1.978  1.00  0.00           H  
ATOM   1594  HB3 PRO A 104      -4.386  22.721  -2.647  1.00  0.00           H  
ATOM   1595  HG2 PRO A 104      -5.503  19.975  -3.060  1.00  0.00           H  
ATOM   1596  HG3 PRO A 104      -4.799  21.087  -4.248  1.00  0.00           H  
ATOM   1597  HD2 PRO A 104      -3.413  19.012  -3.194  1.00  0.00           H  
ATOM   1598  HD3 PRO A 104      -2.637  20.537  -3.669  1.00  0.00           H  
ATOM   1599  N   SER A 105      -4.756  19.408   0.243  1.00  0.00           N  
ATOM   1600  CA  SER A 105      -5.581  18.676   1.197  1.00  0.00           C  
ATOM   1601  C   SER A 105      -4.768  18.279   2.426  1.00  0.00           C  
ATOM   1602  O   SER A 105      -3.850  17.464   2.341  1.00  0.00           O  
ATOM   1603  CB  SER A 105      -6.173  17.428   0.540  1.00  0.00           C  
ATOM   1604  OG  SER A 105      -7.172  16.846   1.359  1.00  0.00           O  
ATOM   1605  H   SER A 105      -4.028  18.940  -0.217  1.00  0.00           H  
ATOM   1606  HA  SER A 105      -6.385  19.326   1.507  1.00  0.00           H  
ATOM   1607  HB2 SER A 105      -6.615  17.698  -0.407  1.00  0.00           H  
ATOM   1608  HB3 SER A 105      -5.390  16.703   0.378  1.00  0.00           H  
ATOM   1609  HG  SER A 105      -6.899  16.890   2.279  1.00  0.00           H  
ATOM   1610  N   SER A 106      -5.113  18.864   3.569  1.00  0.00           N  
ATOM   1611  CA  SER A 106      -4.413  18.576   4.816  1.00  0.00           C  
ATOM   1612  C   SER A 106      -2.998  19.146   4.789  1.00  0.00           C  
ATOM   1613  O   SER A 106      -2.041  18.481   5.183  1.00  0.00           O  
ATOM   1614  CB  SER A 106      -4.363  17.066   5.060  1.00  0.00           C  
ATOM   1615  OG  SER A 106      -4.225  16.778   6.441  1.00  0.00           O  
ATOM   1616  H   SER A 106      -5.854  19.506   3.573  1.00  0.00           H  
ATOM   1617  HA  SER A 106      -4.962  19.044   5.619  1.00  0.00           H  
ATOM   1618  HB2 SER A 106      -5.274  16.615   4.700  1.00  0.00           H  
ATOM   1619  HB3 SER A 106      -3.519  16.647   4.531  1.00  0.00           H  
ATOM   1620  HG  SER A 106      -4.744  16.000   6.659  1.00  0.00           H  
ATOM   1621  N   GLY A 107      -2.875  20.384   4.322  1.00  0.00           N  
ATOM   1622  CA  GLY A 107      -1.574  21.024   4.251  1.00  0.00           C  
ATOM   1623  C   GLY A 107      -1.674  22.512   3.976  1.00  0.00           C  
ATOM   1624  O   GLY A 107      -1.507  23.330   4.882  1.00  0.00           O  
ATOM   1625  H   GLY A 107      -3.673  20.868   4.021  1.00  0.00           H  
ATOM   1626  HA2 GLY A 107      -1.060  20.875   5.189  1.00  0.00           H  
ATOM   1627  HA3 GLY A 107      -1.001  20.563   3.460  1.00  0.00           H  
TER    1628      GLY A 107                                                      
END
MOLECULE T0472_52_101.pdb
ATOM    761  N   ILE    52      -2.934  12.060   6.624  1.00 63.31           N  
ATOM    762  CA  ILE    52      -3.784  11.757   7.784  1.00 50.41           C  
ATOM    763  C   ILE    52      -3.355  10.443   8.462  1.00 25.20           C  
ATOM    764  O   ILE    52      -3.842   9.360   8.129  1.00 63.43           O  
ATOM    765  CB  ILE    52      -5.278  11.668   7.377  1.00 40.10           C  
ATOM    766  CG1 ILE    52      -5.698  12.940   6.620  1.00  0.32           C  
ATOM    767  CG2 ILE    52      -6.164  11.454   8.609  1.00 13.31           C  
ATOM    768  CD1 ILE    52      -7.110  12.896   6.077  1.00 14.20           C  
ATOM    769  H   ILE    52      -3.093  11.580   5.783  1.00 37.41           H  
ATOM    770  HA  ILE    52      -3.676  12.566   8.495  1.00 14.31           H  
ATOM    771  HB  ILE    52      -5.400  10.815   6.724  1.00 21.03           H  
ATOM    772 HG12 ILE    52      -5.629  13.789   7.286  1.00 37.41           H  
ATOM    773 HG13 ILE    52      -5.028  13.093   5.785  1.00 37.41           H  
ATOM    774 HG21 ILE    52      -7.198  11.378   8.302  1.00 37.41           H  
ATOM    775 HG22 ILE    52      -6.052  12.289   9.286  1.00 37.41           H  
ATOM    776 HG23 ILE    52      -5.871  10.544   9.112  1.00 37.41           H  
ATOM    777 HD11 ILE    52      -7.214  12.053   5.411  1.00 37.41           H  
ATOM    778 HD12 ILE    52      -7.315  13.809   5.536  1.00 37.41           H  
ATOM    779 HD13 ILE    52      -7.809  12.800   6.895  1.00 37.41           H  
ATOM    780  N   GLU    53      -2.443  10.555   9.420  1.00 72.33           N  
ATOM    781  CA  GLU    53      -1.867   9.387  10.096  1.00 21.33           C  
ATOM    782  C   GLU    53      -2.934   8.548  10.821  1.00 13.30           C  
ATOM    783  O   GLU    53      -2.792   7.338  10.955  1.00 61.14           O  
ATOM    784  CB  GLU    53      -0.784   9.844  11.084  1.00 51.10           C  
ATOM    785  CG  GLU    53       0.329  10.658  10.428  1.00 41.41           C  
ATOM    786  CD  GLU    53       1.350  11.177  11.426  1.00 31.52           C  
ATOM    787  OE1 GLU    53       1.045  12.161  12.134  1.00  0.22           O  
ATOM    788  OE2 GLU    53       2.465  10.618  11.496  1.00  0.21           O  
ATOM    789  H   GLU    53      -2.141  11.450   9.680  1.00 37.41           H  
ATOM    790  HA  GLU    53      -1.404   8.769   9.339  1.00 44.53           H  
ATOM    791  HB2 GLU    53      -1.244  10.453  11.851  1.00 37.41           H  
ATOM    792  HB3 GLU    53      -0.341   8.974  11.544  1.00 37.41           H  
ATOM    793  HG2 GLU    53       0.836  10.035   9.706  1.00 37.41           H  
ATOM    794  HG3 GLU    53      -0.114  11.504   9.916  1.00 37.41           H  
ATOM    795  N   ALA    54      -4.022   9.183  11.247  1.00 24.34           N  
ATOM    796  CA  ALA    54      -5.102   8.486  11.969  1.00 14.52           C  
ATOM    797  C   ALA    54      -5.685   7.291  11.178  1.00 12.03           C  
ATOM    798  O   ALA    54      -6.469   6.504  11.715  1.00  2.10           O  
ATOM    799  CB  ALA    54      -6.208   9.475  12.319  1.00 10.14           C  
ATOM    800  H   ALA    54      -4.106  10.145  11.077  1.00 37.41           H  
ATOM    801  HA  ALA    54      -4.687   8.113  12.895  1.00 21.34           H  
ATOM    802  HB1 ALA    54      -6.973   8.974  12.895  1.00 37.41           H  
ATOM    803  HB2 ALA    54      -6.642   9.870  11.411  1.00 37.41           H  
ATOM    804  HB3 ALA    54      -5.795  10.285  12.902  1.00 37.41           H  
ATOM    805  N   ARG    55      -5.296   7.162   9.909  1.00 23.25           N  
ATOM    806  CA  ARG    55      -5.814   6.110   9.026  1.00  2.54           C  
ATOM    807  C   ARG    55      -4.950   4.826   9.031  1.00 53.14           C  
ATOM    808  O   ARG    55      -5.335   3.821   8.422  1.00  4.12           O  
ATOM    809  CB  ARG    55      -5.915   6.660   7.594  1.00  4.02           C  
ATOM    810  CG  ARG    55      -6.858   7.855   7.453  1.00 31.02           C  
ATOM    811  CD  ARG    55      -8.317   7.454   7.646  1.00 42.40           C  
ATOM    812  NE  ARG    55      -9.220   8.609   7.648  1.00 62.02           N  
ATOM    813  CZ  ARG    55      -9.855   9.054   6.595  1.00 64.32           C  
ATOM    814  NH1 ARG    55      -9.613   8.568   5.418  1.00 51.52           N  
ATOM    815  NH2 ARG    55     -10.707  10.018   6.710  1.00  4.11           N  
ATOM    816  H   ARG    55      -4.647   7.803   9.547  1.00 37.41           H  
ATOM    817  HA  ARG    55      -6.806   5.852   9.367  1.00 22.42           H  
ATOM    818  HB2 ARG    55      -4.931   6.969   7.270  1.00 37.41           H  
ATOM    819  HB3 ARG    55      -6.266   5.872   6.942  1.00 37.41           H  
ATOM    820  HG2 ARG    55      -6.597   8.596   8.194  1.00 37.41           H  
ATOM    821  HG3 ARG    55      -6.738   8.278   6.465  1.00 37.41           H  
ATOM    822  HD2 ARG    55      -8.603   6.785   6.846  1.00 37.41           H  
ATOM    823  HD3 ARG    55      -8.412   6.937   8.591  1.00 37.41           H  
ATOM    824  HE  ARG    55      -9.383   9.052   8.504  1.00 72.15           H  
ATOM    825 HH11 ARG    55      -8.932   7.849   5.304  1.00 37.41           H  
ATOM    826 HH12 ARG    55     -10.090   8.937   4.622  1.00 37.41           H  
ATOM    827 HH21 ARG    55     -10.872  10.437   7.602  1.00 37.41           H  
ATOM    828 HH22 ARG    55     -11.209  10.336   5.909  1.00 37.41           H  
ATOM    829  N   TYR    56      -3.797   4.843   9.711  1.00 35.41           N  
ATOM    830  CA  TYR    56      -2.880   3.687   9.684  1.00 62.05           C  
ATOM    831  C   TYR    56      -3.367   2.524  10.568  1.00 22.13           C  
ATOM    832  O   TYR    56      -4.337   2.646  11.320  1.00  5.52           O  
ATOM    833  CB  TYR    56      -1.437   4.088  10.092  1.00 63.32           C  
ATOM    834  CG  TYR    56      -1.219   4.439  11.573  1.00 62.22           C  
ATOM    835  CD1 TYR    56      -1.370   3.484  12.580  1.00 51.22           C  
ATOM    836  CD2 TYR    56      -0.851   5.723  11.957  1.00 14.01           C  
ATOM    837  CE1 TYR    56      -1.166   3.802  13.910  1.00 53.41           C  
ATOM    838  CE2 TYR    56      -0.643   6.048  13.285  1.00 42.30           C  
ATOM    839  CZ  TYR    56      -0.806   5.085  14.258  1.00  0.02           C  
ATOM    840  OH  TYR    56      -0.602   5.404  15.582  1.00  0.11           O  
ATOM    841  H   TYR    56      -3.558   5.637  10.234  1.00 37.41           H  
ATOM    842  HA  TYR    56      -2.854   3.333   8.662  1.00  0.43           H  
ATOM    843  HB2 TYR    56      -0.772   3.270   9.857  1.00 37.41           H  
ATOM    844  HB3 TYR    56      -1.144   4.949   9.504  1.00 37.41           H  
ATOM    845  HD1 TYR    56      -1.650   2.476  12.309  1.00 50.32           H  
ATOM    846  HD2 TYR    56      -0.728   6.479  11.196  1.00 34.13           H  
ATOM    847  HE1 TYR    56      -1.292   3.045  14.671  1.00 51.01           H  
ATOM    848  HE2 TYR    56      -0.357   7.055  13.556  1.00 22.30           H  
ATOM    849  HH  TYR    56      -1.043   6.241  15.780  1.00 14.22           H  
ATOM    850  N   ALA    57      -2.675   1.391  10.455  1.00 63.32           N  
ATOM    851  CA  ALA    57      -2.859   0.254  11.362  1.00 25.11           C  
ATOM    852  C   ALA    57      -1.529  -0.491  11.565  1.00 35.11           C  
ATOM    853  O   ALA    57      -1.122  -1.294  10.727  1.00 54.01           O  
ATOM    854  CB  ALA    57      -3.927  -0.689  10.819  1.00 23.24           C  
ATOM    855  H   ALA    57      -2.032   1.307   9.719  1.00 37.41           H  
ATOM    856  HA  ALA    57      -3.197   0.636  12.317  1.00 52.10           H  
ATOM    857  HB1 ALA    57      -3.598  -1.103   9.877  1.00 37.41           H  
ATOM    858  HB2 ALA    57      -4.848  -0.143  10.669  1.00 37.41           H  
ATOM    859  HB3 ALA    57      -4.096  -1.490  11.523  1.00 37.41           H  
ATOM    860  N   LYS    58      -0.855  -0.228  12.680  1.00 61.02           N  
ATOM    861  CA  LYS    58       0.480  -0.794  12.932  1.00 63.12           C  
ATOM    862  C   LYS    58       0.402  -2.075  13.776  1.00 14.20           C  
ATOM    863  O   LYS    58      -0.132  -2.075  14.888  1.00 64.40           O  
ATOM    864  CB  LYS    58       1.371   0.253  13.618  1.00 42.34           C  
ATOM    865  CG  LYS    58       1.675   1.467  12.739  1.00 42.51           C  
ATOM    866  CD  LYS    58       2.283   2.619  13.539  1.00 64.53           C  
ATOM    867  CE  LYS    58       3.613   2.243  14.180  1.00 34.10           C  
ATOM    868  NZ  LYS    58       4.138   3.339  15.033  1.00 51.24           N  
ATOM    869  H   LYS    58      -1.264   0.352  13.358  1.00 37.41           H  
ATOM    870  HA  LYS    58       0.917  -1.043  11.973  1.00  1.11           H  
ATOM    871  HB2 LYS    58       0.875   0.597  14.516  1.00 37.41           H  
ATOM    872  HB3 LYS    58       2.309  -0.210  13.892  1.00 37.41           H  
ATOM    873  HG2 LYS    58       2.374   1.173  11.967  1.00 37.41           H  
ATOM    874  HG3 LYS    58       0.756   1.805  12.279  1.00 37.41           H  
ATOM    875  HD2 LYS    58       2.443   3.457  12.875  1.00 37.41           H  
ATOM    876  HD3 LYS    58       1.589   2.909  14.316  1.00 37.41           H  
ATOM    877  HE2 LYS    58       3.471   1.363  14.790  1.00 37.41           H  
ATOM    878  HE3 LYS    58       4.331   2.030  13.400  1.00 37.41           H  
ATOM    879  HZ1 LYS    58       3.486   3.520  15.827  1.00 37.41           H  
ATOM    880  HZ2 LYS    58       4.241   4.211  14.480  1.00 37.41           H  
ATOM    881  HZ3 LYS    58       5.069   3.079  15.421  1.00 37.41           H  
ATOM    882  N   GLU    59       0.949  -3.169  13.247  1.00 44.24           N  
ATOM    883  CA  GLU    59       0.882  -4.471  13.919  1.00 11.42           C  
ATOM    884  C   GLU    59       2.249  -5.175  13.923  1.00 44.23           C  
ATOM    885  O   GLU    59       3.090  -4.945  13.051  1.00 51.02           O  
ATOM    886  CB  GLU    59      -0.167  -5.358  13.225  1.00 62.32           C  
ATOM    887  CG  GLU    59      -0.394  -6.708  13.903  1.00 71.31           C  
ATOM    888  CD  GLU    59      -0.917  -6.575  15.325  1.00 71.05           C  
ATOM    889  OE1 GLU    59      -2.147  -6.439  15.499  1.00 51.51           O  
ATOM    890  OE2 GLU    59      -0.103  -6.593  16.271  1.00 64.11           O  
ATOM    891  H   GLU    59       1.413  -3.103  12.385  1.00 37.41           H  
ATOM    892  HA  GLU    59       0.577  -4.303  14.942  1.00 22.01           H  
ATOM    893  HB2 GLU    59      -1.109  -4.828  13.205  1.00 37.41           H  
ATOM    894  HB3 GLU    59       0.150  -5.540  12.207  1.00 37.41           H  
ATOM    895  HG2 GLU    59      -1.109  -7.273  13.323  1.00 37.41           H  
ATOM    896  HG3 GLU    59       0.546  -7.245  13.929  1.00 37.41           H  
ATOM    897  N   VAL    60       2.470  -6.027  14.921  1.00 22.32           N  
ATOM    898  CA  VAL    60       3.696  -6.824  15.010  1.00 64.53           C  
ATOM    899  C   VAL    60       3.366  -8.299  15.279  1.00 53.14           C  
ATOM    900  O   VAL    60       2.798  -8.636  16.319  1.00 43.34           O  
ATOM    901  CB  VAL    60       4.643  -6.309  16.126  1.00  2.12           C  
ATOM    902  CG1 VAL    60       5.908  -7.164  16.200  1.00 11.45           C  
ATOM    903  CG2 VAL    60       4.996  -4.836  15.909  1.00 31.41           C  
ATOM    904  H   VAL    60       1.784  -6.130  15.617  1.00 37.41           H  
ATOM    905  HA  VAL    60       4.215  -6.749  14.063  1.00  5.34           H  
ATOM    906  HB  VAL    60       4.126  -6.394  17.073  1.00 53.30           H  
ATOM    907 HG11 VAL    60       5.637  -8.192  16.393  1.00 37.41           H  
ATOM    908 HG12 VAL    60       6.540  -6.805  17.000  1.00 37.41           H  
ATOM    909 HG13 VAL    60       6.444  -7.102  15.264  1.00 37.41           H  
ATOM    910 HG21 VAL    60       5.634  -4.496  16.714  1.00 37.41           H  
ATOM    911 HG22 VAL    60       4.091  -4.247  15.895  1.00 37.41           H  
ATOM    912 HG23 VAL    60       5.515  -4.722  14.968  1.00 37.41           H  
ATOM    913  N   ALA    61       3.723  -9.170  14.340  1.00 74.01           N  
ATOM    914  CA  ALA    61       3.468 -10.608  14.478  1.00 71.43           C  
ATOM    915  C   ALA    61       4.192 -11.201  15.705  1.00 65.35           C  
ATOM    916  O   ALA    61       5.224 -10.684  16.135  1.00 53.45           O  
ATOM    917  CB  ALA    61       3.892 -11.333  13.206  1.00 74.24           C  
ATOM    918  H   ALA    61       4.166  -8.839  13.528  1.00 37.41           H  
ATOM    919  HA  ALA    61       2.402 -10.745  14.602  1.00 31.41           H  
ATOM    920  HB1 ALA    61       3.608 -12.373  13.269  1.00 37.41           H  
ATOM    921  HB2 ALA    61       4.964 -11.260  13.091  1.00 37.41           H  
ATOM    922  HB3 ALA    61       3.409 -10.879  12.353  1.00 37.41           H  
ATOM    923  N   LYS    62       3.656 -12.300  16.248  1.00  4.44           N  
ATOM    924  CA  LYS    62       4.209 -12.923  17.465  1.00 11.40           C  
ATOM    925  C   LYS    62       5.685 -13.343  17.306  1.00 52.00           C  
ATOM    926  O   LYS    62       6.385 -13.549  18.295  1.00 60.32           O  
ATOM    927  CB  LYS    62       3.332 -14.116  17.908  1.00 35.24           C  
ATOM    928  CG  LYS    62       2.962 -15.109  16.797  1.00 32.32           C  
ATOM    929  CD  LYS    62       4.130 -15.996  16.364  1.00 21.23           C  
ATOM    930  CE  LYS    62       4.682 -16.823  17.517  1.00 32.35           C  
ATOM    931  NZ  LYS    62       5.716 -17.788  17.058  1.00 41.43           N  
ATOM    932  H   LYS    62       2.867 -12.701  15.824  1.00 37.41           H  
ATOM    933  HA  LYS    62       4.165 -12.173  18.244  1.00 22.23           H  
ATOM    934  HB2 LYS    62       3.853 -14.661  18.682  1.00 37.41           H  
ATOM    935  HB3 LYS    62       2.413 -13.726  18.325  1.00 37.41           H  
ATOM    936  HG2 LYS    62       2.164 -15.745  17.155  1.00 37.41           H  
ATOM    937  HG3 LYS    62       2.610 -14.551  15.939  1.00 37.41           H  
ATOM    938  HD2 LYS    62       3.790 -16.667  15.588  1.00 37.41           H  
ATOM    939  HD3 LYS    62       4.919 -15.370  15.972  1.00 37.41           H  
ATOM    940  HE2 LYS    62       5.123 -16.157  18.243  1.00 37.41           H  
ATOM    941  HE3 LYS    62       3.870 -17.369  17.977  1.00 37.41           H  
ATOM    942  HZ1 LYS    62       6.100 -18.314  17.871  1.00 37.41           H  
ATOM    943  HZ2 LYS    62       6.495 -17.286  16.585  1.00 37.41           H  
ATOM    944  HZ3 LYS    62       5.301 -18.465  16.385  1.00 37.41           H  
ATOM    945  N   ASN    63       6.149 -13.463  16.062  1.00 21.24           N  
ATOM    946  CA  ASN    63       7.566 -13.751  15.782  1.00 12.32           C  
ATOM    947  C   ASN    63       8.383 -12.441  15.702  1.00 33.24           C  
ATOM    948  O   ASN    63       9.455 -12.395  15.101  1.00  2.24           O  
ATOM    949  CB  ASN    63       7.668 -14.554  14.471  1.00 62.24           C  
ATOM    950  CG  ASN    63       9.074 -15.056  14.164  1.00 20.31           C  
ATOM    951  OD1 ASN    63       9.485 -16.114  14.623  1.00 45.23           O  
ATOM    952  ND2 ASN    63       9.818 -14.312  13.374  1.00 10.10           N  
ATOM    953  H   ASN    63       5.524 -13.370  15.311  1.00 37.41           H  
ATOM    954  HA  ASN    63       7.952 -14.351  16.596  1.00 40.40           H  
ATOM    955  HB2 ASN    63       7.016 -15.413  14.538  1.00 37.41           H  
ATOM    956  HB3 ASN    63       7.342 -13.932  13.647  1.00 37.41           H  
ATOM    957 HD21 ASN    63       9.442 -13.479  13.028  1.00 37.41           H  
ATOM    958 HD22 ASN    63      10.721 -14.626  13.165  1.00 37.41           H  
ATOM    959  N   ASP    64       7.867 -11.379  16.331  1.00 12.21           N  
ATOM    960  CA  ASP    64       8.514 -10.058  16.313  1.00 33.52           C  
ATOM    961  C   ASP    64       8.675  -9.521  14.882  1.00 53.51           C  
ATOM    962  O   ASP    64       9.686  -8.898  14.546  1.00 41.44           O  
ATOM    963  CB  ASP    64       9.872 -10.114  17.026  1.00 11.12           C  
ATOM    964  CG  ASP    64       9.731 -10.181  18.532  1.00 25.43           C  
ATOM    965  OD1 ASP    64       9.576  -9.113  19.163  1.00 53.53           O  
ATOM    966  OD2 ASP    64       9.775 -11.295  19.093  1.00 55.32           O  
ATOM    967  H   ASP    64       7.030 -11.487  16.826  1.00 37.41           H  
ATOM    968  HA  ASP    64       7.868  -9.381  16.853  1.00 71.24           H  
ATOM    969  HB2 ASP    64      10.411 -10.990  16.690  1.00 37.41           H  
ATOM    970  HB3 ASP    64      10.444  -9.232  16.774  1.00 37.41           H  
ATOM    971  N   LYS    65       7.662  -9.755  14.048  1.00 61.14           N  
ATOM    972  CA  LYS    65       7.666  -9.274  12.660  1.00 32.24           C  
ATOM    973  C   LYS    65       6.824  -7.992  12.531  1.00 33.22           C  
ATOM    974  O   LYS    65       5.593  -8.050  12.518  1.00 61.02           O  
ATOM    975  CB  LYS    65       7.113 -10.358  11.721  1.00 71.43           C  
ATOM    976  CG  LYS    65       7.740 -11.735  11.933  1.00 12.12           C  
ATOM    977  CD  LYS    65       7.122 -12.797  11.024  1.00 54.43           C  
ATOM    978  CE  LYS    65       7.477 -12.578   9.556  1.00 71.11           C  
ATOM    979  NZ  LYS    65       8.943 -12.627   9.316  1.00 13.30           N  
ATOM    980  H   LYS    65       6.892 -10.263  14.373  1.00 37.41           H  
ATOM    981  HA  LYS    65       8.687  -9.055  12.380  1.00 74.43           H  
ATOM    982  HB2 LYS    65       6.046 -10.444  11.878  1.00 37.41           H  
ATOM    983  HB3 LYS    65       7.291 -10.057  10.697  1.00 37.41           H  
ATOM    984  HG2 LYS    65       8.799 -11.672  11.725  1.00 37.41           H  
ATOM    985  HG3 LYS    65       7.595 -12.028  12.964  1.00 37.41           H  
ATOM    986  HD2 LYS    65       7.482 -13.769  11.327  1.00 37.41           H  
ATOM    987  HD3 LYS    65       6.046 -12.764  11.131  1.00 37.41           H  
ATOM    988  HE2 LYS    65       7.002 -13.348   8.965  1.00 37.41           H  
ATOM    989  HE3 LYS    65       7.105 -11.611   9.248  1.00 37.41           H  
ATOM    990  HZ1 LYS    65       9.144 -12.552   8.299  1.00 37.41           H  
ATOM    991  HZ2 LYS    65       9.336 -13.522   9.668  1.00 37.41           H  
ATOM    992  HZ3 LYS    65       9.415 -11.842   9.806  1.00 37.41           H  
ATOM    993  N   PRO    66       7.471  -6.815  12.457  1.00 62.54           N  
ATOM    994  CA  PRO    66       6.766  -5.530  12.370  1.00 44.02           C  
ATOM    995  C   PRO    66       6.263  -5.199  10.950  1.00 12.31           C  
ATOM    996  O   PRO    66       7.020  -5.245   9.979  1.00 62.23           O  
ATOM    997  CB  PRO    66       7.837  -4.530  12.819  1.00 32.11           C  
ATOM    998  CG  PRO    66       9.125  -5.139  12.375  1.00 70.24           C  
ATOM    999  CD  PRO    66       8.939  -6.637  12.465  1.00 13.44           C  
ATOM   1000  HA  PRO    66       5.933  -5.494  13.059  1.00  1.01           H  
ATOM   1001  HB2 PRO    66       7.665  -3.571  12.350  1.00 37.41           H  
ATOM   1002  HB3 PRO    66       7.804  -4.420  13.894  1.00 37.41           H  
ATOM   1003  HG2 PRO    66       9.335  -4.847  11.356  1.00 37.41           H  
ATOM   1004  HG3 PRO    66       9.927  -4.820  13.027  1.00 37.41           H  
ATOM   1005  HD2 PRO    66       9.390  -7.125  11.612  1.00 37.41           H  
ATOM   1006  HD3 PRO    66       9.364  -7.017  13.383  1.00 37.41           H  
ATOM   1007  N   TYR    67       4.979  -4.871  10.846  1.00 24.13           N  
ATOM   1008  CA  TYR    67       4.370  -4.439   9.581  1.00 24.21           C  
ATOM   1009  C   TYR    67       3.188  -3.491   9.849  1.00 45.21           C  
ATOM   1010  O   TYR    67       2.904  -3.151  11.001  1.00 72.50           O  
ATOM   1011  CB  TYR    67       3.915  -5.656   8.753  1.00  1.11           C  
ATOM   1012  CG  TYR    67       2.901  -6.550   9.452  1.00  2.41           C  
ATOM   1013  CD1 TYR    67       3.311  -7.547  10.334  1.00 23.44           C  
ATOM   1014  CD2 TYR    67       1.534  -6.403   9.224  1.00 42.32           C  
ATOM   1015  CE1 TYR    67       2.393  -8.362  10.969  1.00 44.40           C  
ATOM   1016  CE2 TYR    67       0.612  -7.216   9.855  1.00 22.30           C  
ATOM   1017  CZ  TYR    67       1.046  -8.194  10.726  1.00  1.14           C  
ATOM   1018  OH  TYR    67       0.131  -9.010  11.357  1.00 65.32           O  
ATOM   1019  H   TYR    67       4.411  -4.928  11.646  1.00 37.41           H  
ATOM   1020  HA  TYR    67       5.122  -3.896   9.023  1.00 62.22           H  
ATOM   1021  HB2 TYR    67       3.469  -5.308   7.832  1.00 37.41           H  
ATOM   1022  HB3 TYR    67       4.780  -6.259   8.514  1.00 37.41           H  
ATOM   1023  HD1 TYR    67       4.366  -7.678  10.524  1.00  3.10           H  
ATOM   1024  HD2 TYR    67       1.196  -5.635   8.542  1.00 71.14           H  
ATOM   1025  HE1 TYR    67       2.735  -9.127  11.651  1.00 11.44           H  
ATOM   1026  HE2 TYR    67      -0.444  -7.086   9.660  1.00 45.34           H  
ATOM   1027  HH  TYR    67      -0.543  -9.284  10.722  1.00 75.15           H  
ATOM   1028  N   PHE    68       2.507  -3.052   8.794  1.00 24.23           N  
ATOM   1029  CA  PHE    68       1.371  -2.137   8.954  1.00  4.50           C  
ATOM   1030  C   PHE    68       0.403  -2.178   7.760  1.00 64.32           C  
ATOM   1031  O   PHE    68       0.799  -2.428   6.620  1.00 12.41           O  
ATOM   1032  CB  PHE    68       1.871  -0.698   9.183  1.00 32.33           C  
ATOM   1033  CG  PHE    68       2.691  -0.137   8.044  1.00 23.42           C  
ATOM   1034  CD1 PHE    68       4.044  -0.426   7.932  1.00 53.23           C  
ATOM   1035  CD2 PHE    68       2.106   0.680   7.083  1.00 31.25           C  
ATOM   1036  CE1 PHE    68       4.793   0.086   6.889  1.00  4.33           C  
ATOM   1037  CE2 PHE    68       2.853   1.193   6.040  1.00  0.44           C  
ATOM   1038  CZ  PHE    68       4.199   0.895   5.945  1.00 13.13           C  
ATOM   1039  H   PHE    68       2.769  -3.344   7.896  1.00 37.41           H  
ATOM   1040  HA  PHE    68       0.827  -2.451   9.835  1.00 14.23           H  
ATOM   1041  HB2 PHE    68       1.019  -0.048   9.332  1.00 37.41           H  
ATOM   1042  HB3 PHE    68       2.484  -0.681  10.074  1.00 37.41           H  
ATOM   1043  HD1 PHE    68       4.514  -1.062   8.670  1.00 10.45           H  
ATOM   1044  HD2 PHE    68       1.053   0.917   7.157  1.00 75.42           H  
ATOM   1045  HE1 PHE    68       5.844  -0.148   6.814  1.00 73.12           H  
ATOM   1046  HE2 PHE    68       2.386   1.826   5.300  1.00 70.04           H  
ATOM   1047  HZ  PHE    68       4.783   1.293   5.130  1.00  3.33           H  
ATOM   1048  N   ASN    69      -0.872  -1.940   8.050  1.00 64.50           N  
ATOM   1049  CA  ASN    69      -1.917  -1.835   7.029  1.00 15.25           C  
ATOM   1050  C   ASN    69      -2.474  -0.402   6.980  1.00 13.04           C  
ATOM   1051  O   ASN    69      -2.335   0.362   7.937  1.00 72.31           O  
ATOM   1052  CB  ASN    69      -3.054  -2.818   7.333  1.00 23.42           C  
ATOM   1053  CG  ASN    69      -2.588  -4.266   7.375  1.00 74.43           C  
ATOM   1054  OD1 ASN    69      -2.149  -4.761   8.408  1.00 54.30           O  
ATOM   1055  ND2 ASN    69      -2.687  -4.962   6.259  1.00 72.34           N  
ATOM   1056  H   ASN    69      -1.125  -1.836   8.987  1.00 37.41           H  
ATOM   1057  HA  ASN    69      -1.481  -2.078   6.069  1.00 74.20           H  
ATOM   1058  HB2 ASN    69      -3.484  -2.574   8.293  1.00 37.41           H  
ATOM   1059  HB3 ASN    69      -3.816  -2.725   6.572  1.00 37.41           H  
ATOM   1060 HD21 ASN    69      -3.050  -4.521   5.464  1.00 37.41           H  
ATOM   1061 HD22 ASN    69      -2.402  -5.900   6.277  1.00 37.41           H  
ATOM   1062  N   LEU    70      -3.099  -0.039   5.866  1.00  3.12           N  
ATOM   1063  CA  LEU    70      -3.696   1.294   5.709  1.00 12.35           C  
ATOM   1064  C   LEU    70      -5.207   1.188   5.443  1.00 52.51           C  
ATOM   1065  O   LEU    70      -5.639   0.449   4.550  1.00  2.32           O  
ATOM   1066  CB  LEU    70      -3.002   2.054   4.562  1.00 61.41           C  
ATOM   1067  CG  LEU    70      -3.459   3.511   4.357  1.00 74.43           C  
ATOM   1068  CD1 LEU    70      -3.134   4.366   5.584  1.00 53.53           C  
ATOM   1069  CD2 LEU    70      -2.820   4.100   3.100  1.00 51.44           C  
ATOM   1070  H   LEU    70      -3.166  -0.683   5.130  1.00 37.41           H  
ATOM   1071  HA  LEU    70      -3.544   1.837   6.631  1.00 30.15           H  
ATOM   1072  HB2 LEU    70      -1.937   2.057   4.757  1.00 37.41           H  
ATOM   1073  HB3 LEU    70      -3.177   1.512   3.643  1.00 37.41           H  
ATOM   1074  HG  LEU    70      -4.530   3.526   4.222  1.00 53.12           H  
ATOM   1075 HD11 LEU    70      -3.620   3.946   6.453  1.00 37.41           H  
ATOM   1076 HD12 LEU    70      -3.491   5.374   5.426  1.00 37.41           H  
ATOM   1077 HD13 LEU    70      -2.066   4.384   5.742  1.00 37.41           H  
ATOM   1078 HD21 LEU    70      -3.146   5.121   2.972  1.00 37.41           H  
ATOM   1079 HD22 LEU    70      -3.117   3.519   2.239  1.00 37.41           H  
ATOM   1080 HD23 LEU    70      -1.744   4.076   3.194  1.00 37.41           H  
ATOM   1081  N   LYS    71      -6.004   1.925   6.220  1.00 35.23           N  
ATOM   1082  CA  LYS    71      -7.465   1.907   6.076  1.00 73.11           C  
ATOM   1083  C   LYS    71      -8.014   3.253   5.581  1.00 73.01           C  
ATOM   1084  O   LYS    71      -7.513   4.317   5.942  1.00  2.23           O  
ATOM   1085  CB  LYS    71      -8.145   1.557   7.410  1.00 52.54           C  
ATOM   1086  CG  LYS    71      -7.870   0.143   7.914  1.00  3.44           C  
ATOM   1087  CD  LYS    71      -8.818  -0.226   9.058  1.00 43.11           C  
ATOM   1088  CE  LYS    71      -8.538  -1.614   9.626  1.00  2.32           C  
ATOM   1089  NZ  LYS    71      -7.195  -1.709  10.252  1.00 63.42           N  
ATOM   1090  H   LYS    71      -5.604   2.503   6.907  1.00 37.41           H  
ATOM   1091  HA  LYS    71      -7.718   1.146   5.350  1.00 23.22           H  
ATOM   1092  HB2 LYS    71      -7.803   2.251   8.165  1.00 37.41           H  
ATOM   1093  HB3 LYS    71      -9.216   1.669   7.293  1.00 37.41           H  
ATOM   1094  HG2 LYS    71      -8.009  -0.555   7.100  1.00 37.41           H  
ATOM   1095  HG3 LYS    71      -6.848   0.086   8.269  1.00 37.41           H  
ATOM   1096  HD2 LYS    71      -8.714   0.502   9.850  1.00 37.41           H  
ATOM   1097  HD3 LYS    71      -9.832  -0.201   8.685  1.00 37.41           H  
ATOM   1098  HE2 LYS    71      -9.287  -1.839  10.372  1.00 37.41           H  
ATOM   1099  HE3 LYS    71      -8.605  -2.337   8.826  1.00 37.41           H  
ATOM   1100  HZ1 LYS    71      -7.050  -0.916  10.911  1.00 37.41           H  
ATOM   1101  HZ2 LYS    71      -6.452  -1.683   9.527  1.00 37.41           H  
ATOM   1102  HZ3 LYS    71      -7.112  -2.600  10.783  1.00 37.41           H  
ATOM   1103  N   ALA    72      -9.056   3.195   4.754  1.00 64.14           N  
ATOM   1104  CA  ALA    72      -9.782   4.398   4.334  1.00 62.42           C  
ATOM   1105  C   ALA    72     -10.779   4.839   5.421  1.00 74.43           C  
ATOM   1106  O   ALA    72     -10.918   4.172   6.448  1.00 34.50           O  
ATOM   1107  CB  ALA    72     -10.504   4.149   3.016  1.00 73.22           C  
ATOM   1108  H   ALA    72      -9.341   2.319   4.415  1.00 37.41           H  
ATOM   1109  HA  ALA    72      -9.062   5.190   4.180  1.00 74.24           H  
ATOM   1110  HB1 ALA    72      -9.793   3.834   2.267  1.00 37.41           H  
ATOM   1111  HB2 ALA    72     -10.990   5.059   2.691  1.00 37.41           H  
ATOM   1112  HB3 ALA    72     -11.247   3.377   3.152  1.00 37.41           H  
ATOM   1113  N   ALA    73     -11.471   5.956   5.194  1.00 12.14           N  
ATOM   1114  CA  ALA    73     -12.418   6.506   6.181  1.00 23.01           C  
ATOM   1115  C   ALA    73     -13.482   5.481   6.617  1.00 13.03           C  
ATOM   1116  O   ALA    73     -13.840   5.409   7.791  1.00 75.11           O  
ATOM   1117  CB  ALA    73     -13.091   7.756   5.622  1.00 23.52           C  
ATOM   1118  H   ALA    73     -11.348   6.428   4.343  1.00 37.41           H  
ATOM   1119  HA  ALA    73     -11.846   6.801   7.050  1.00 75.03           H  
ATOM   1120  HB1 ALA    73     -13.668   7.495   4.745  1.00 37.41           H  
ATOM   1121  HB2 ALA    73     -12.336   8.482   5.351  1.00 37.41           H  
ATOM   1122  HB3 ALA    73     -13.746   8.182   6.369  1.00 37.41           H  
ATOM   1123  N   ASN    74     -13.975   4.682   5.668  1.00 14.50           N  
ATOM   1124  CA  ASN    74     -14.995   3.662   5.962  1.00 44.41           C  
ATOM   1125  C   ASN    74     -14.373   2.400   6.607  1.00 22.25           C  
ATOM   1126  O   ASN    74     -15.018   1.355   6.708  1.00 15.02           O  
ATOM   1127  CB  ASN    74     -15.760   3.307   4.675  1.00 73.15           C  
ATOM   1128  CG  ASN    74     -17.051   2.547   4.943  1.00 61.34           C  
ATOM   1129  OD1 ASN    74     -18.083   3.137   5.242  1.00  2.04           O  
ATOM   1130  ND2 ASN    74     -17.016   1.235   4.823  1.00 24.03           N  
ATOM   1131  H   ASN    74     -13.661   4.793   4.747  1.00 37.41           H  
ATOM   1132  HA  ASN    74     -15.692   4.094   6.667  1.00 11.14           H  
ATOM   1133  HB2 ASN    74     -16.008   4.219   4.148  1.00 37.41           H  
ATOM   1134  HB3 ASN    74     -15.129   2.697   4.044  1.00 37.41           H  
ATOM   1135 HD21 ASN    74     -16.171   0.813   4.570  1.00 37.41           H  
ATOM   1136 HD22 ASN    74     -17.843   0.739   4.984  1.00 37.41           H  
ATOM   1137  N   HIS    75     -13.105   2.509   7.018  1.00 14.22           N  
ATOM   1138  CA  HIS    75     -12.421   1.473   7.820  1.00 24.34           C  
ATOM   1139  C   HIS    75     -12.106   0.216   6.985  1.00 63.04           C  
ATOM   1140  O   HIS    75     -11.936  -0.882   7.520  1.00 64.04           O  
ATOM   1141  CB  HIS    75     -13.274   1.119   9.054  1.00 34.43           C  
ATOM   1142  CG  HIS    75     -12.532   0.386  10.133  1.00 15.42           C  
ATOM   1143  ND1 HIS    75     -12.548  -0.986  10.265  1.00  2.12           N  
ATOM   1144  CD2 HIS    75     -11.764   0.847  11.149  1.00 71.01           C  
ATOM   1145  CE1 HIS    75     -11.827  -1.335  11.311  1.00 72.22           C  
ATOM   1146  NE2 HIS    75     -11.339  -0.245  11.865  1.00 11.40           N  
ATOM   1147  H   HIS    75     -12.605   3.312   6.767  1.00 37.41           H  
ATOM   1148  HA  HIS    75     -11.486   1.895   8.157  1.00 70.03           H  
ATOM   1149  HB2 HIS    75     -13.657   2.031   9.486  1.00 37.41           H  
ATOM   1150  HB3 HIS    75     -14.105   0.501   8.745  1.00 37.41           H  
ATOM   1151  HD1 HIS    75     -13.019  -1.614   9.676  1.00 74.14           H  
ATOM   1152  HD2 HIS    75     -11.527   1.882  11.355  1.00 62.31           H  
ATOM   1153  HE1 HIS    75     -11.662  -2.346  11.653  1.00 23.12           H  
ATOM   1154  HE2 HIS    75     -10.934  -0.206  12.760  1.00 37.41           H  
ATOM   1155  N   GLN    76     -11.995   0.406   5.675  1.00 70.15           N  
ATOM   1156  CA  GLN    76     -11.689  -0.683   4.736  1.00 74.21           C  
ATOM   1157  C   GLN    76     -10.171  -0.827   4.527  1.00 71.43           C  
ATOM   1158  O   GLN    76      -9.428   0.149   4.651  1.00 53.14           O  
ATOM   1159  CB  GLN    76     -12.374  -0.393   3.393  1.00 42.12           C  
ATOM   1160  CG  GLN    76     -11.825   0.848   2.691  1.00 15.10           C  
ATOM   1161  CD  GLN    76     -12.765   1.405   1.641  1.00  1.43           C  
ATOM   1162  OE1 GLN    76     -12.715   1.031   0.471  1.00 50.25           O  
ATOM   1163  NE2 GLN    76     -13.614   2.324   2.052  1.00 12.54           N  
ATOM   1164  H   GLN    76     -12.121   1.309   5.323  1.00 37.41           H  
ATOM   1165  HA  GLN    76     -12.081  -1.604   5.143  1.00  5.43           H  
ATOM   1166  HB2 GLN    76     -12.235  -1.243   2.738  1.00 37.41           H  
ATOM   1167  HB3 GLN    76     -13.432  -0.249   3.563  1.00 37.41           H  
ATOM   1168  HG2 GLN    76     -11.647   1.615   3.431  1.00 37.41           H  
ATOM   1169  HG3 GLN    76     -10.889   0.592   2.215  1.00 37.41           H  
ATOM   1170 HE21 GLN    76     -13.589   2.593   2.992  1.00 37.41           H  
ATOM   1171 HE22 GLN    76     -14.248   2.691   1.397  1.00 37.41           H  
ATOM   1172  N   ILE    77      -9.715  -2.035   4.194  1.00 32.34           N  
ATOM   1173  CA  ILE    77      -8.283  -2.295   3.979  1.00 40.03           C  
ATOM   1174  C   ILE    77      -7.868  -1.955   2.540  1.00 24.44           C  
ATOM   1175  O   ILE    77      -8.107  -2.731   1.612  1.00 71.02           O  
ATOM   1176  CB  ILE    77      -7.923  -3.778   4.274  1.00 72.54           C  
ATOM   1177  CG1 ILE    77      -8.252  -4.137   5.732  1.00 71.52           C  
ATOM   1178  CG2 ILE    77      -6.445  -4.051   3.976  1.00 55.33           C  
ATOM   1179  CD1 ILE    77      -7.418  -3.391   6.752  1.00  4.14           C  
ATOM   1180  H   ILE    77     -10.356  -2.767   4.072  1.00 37.41           H  
ATOM   1181  HA  ILE    77      -7.722  -1.669   4.662  1.00 54.33           H  
ATOM   1182  HB  ILE    77      -8.514  -4.401   3.617  1.00 41.44           H  
ATOM   1183 HG12 ILE    77      -9.289  -3.910   5.927  1.00 37.41           H  
ATOM   1184 HG13 ILE    77      -8.090  -5.196   5.881  1.00 37.41           H  
ATOM   1185 HG21 ILE    77      -6.214  -5.082   4.206  1.00 37.41           H  
ATOM   1186 HG22 ILE    77      -5.826  -3.401   4.579  1.00 37.41           H  
ATOM   1187 HG23 ILE    77      -6.247  -3.865   2.930  1.00 37.41           H  
ATOM   1188 HD11 ILE    77      -6.377  -3.650   6.624  1.00 37.41           H  
ATOM   1189 HD12 ILE    77      -7.735  -3.667   7.746  1.00 37.41           H  
ATOM   1190 HD13 ILE    77      -7.545  -2.327   6.616  1.00 37.41           H  
ATOM   1191  N   ILE    78      -7.258  -0.789   2.357  1.00 42.24           N  
ATOM   1192  CA  ILE    78      -6.824  -0.346   1.024  1.00 51.22           C  
ATOM   1193  C   ILE    78      -5.345  -0.674   0.761  1.00 70.34           C  
ATOM   1194  O   ILE    78      -4.940  -0.865  -0.388  1.00 50.21           O  
ATOM   1195  CB  ILE    78      -7.057   1.174   0.830  1.00 32.12           C  
ATOM   1196  CG1 ILE    78      -6.289   1.979   1.892  1.00 53.32           C  
ATOM   1197  CG2 ILE    78      -8.551   1.494   0.876  1.00 11.03           C  
ATOM   1198  CD1 ILE    78      -6.479   3.475   1.785  1.00 34.20           C  
ATOM   1199  H   ILE    78      -7.099  -0.209   3.131  1.00 37.41           H  
ATOM   1200  HA  ILE    78      -7.424  -0.870   0.290  1.00 62.01           H  
ATOM   1201  HB  ILE    78      -6.691   1.447  -0.151  1.00 52.10           H  
ATOM   1202 HG12 ILE    78      -6.619   1.676   2.875  1.00 37.41           H  
ATOM   1203 HG13 ILE    78      -5.231   1.773   1.796  1.00 37.41           H  
ATOM   1204 HG21 ILE    78      -8.701   2.554   0.726  1.00 37.41           H  
ATOM   1205 HG22 ILE    78      -8.953   1.206   1.838  1.00 37.41           H  
ATOM   1206 HG23 ILE    78      -9.062   0.945   0.097  1.00 37.41           H  
ATOM   1207 HD11 ILE    78      -5.860   3.968   2.520  1.00 37.41           H  
ATOM   1208 HD12 ILE    78      -7.515   3.722   1.966  1.00 37.41           H  
ATOM   1209 HD13 ILE    78      -6.198   3.807   0.798  1.00 37.41           H  
ATOM   1210  N   GLY    79      -4.543  -0.740   1.826  1.00 72.31           N  
ATOM   1211  CA  GLY    79      -3.118  -1.037   1.679  1.00 14.54           C  
ATOM   1212  C   GLY    79      -2.586  -2.007   2.734  1.00 61.14           C  
ATOM   1213  O   GLY    79      -3.094  -2.060   3.853  1.00 22.12           O  
ATOM   1214  H   GLY    79      -4.920  -0.581   2.720  1.00 37.41           H  
ATOM   1215  HA2 GLY    79      -2.948  -1.464   0.699  1.00 37.41           H  
ATOM   1216  HA3 GLY    79      -2.566  -0.111   1.750  1.00 37.41           H  
ATOM   1217  N   THR    80      -1.552  -2.767   2.373  1.00 55.11           N  
ATOM   1218  CA  THR    80      -0.925  -3.738   3.289  1.00 61.41           C  
ATOM   1219  C   THR    80       0.586  -3.837   3.039  1.00 45.05           C  
ATOM   1220  O   THR    80       1.017  -4.076   1.916  1.00 71.44           O  
ATOM   1221  CB  THR    80      -1.558  -5.147   3.137  1.00 41.01           C  
ATOM   1222  OG1 THR    80      -2.947  -5.106   3.503  1.00 65.52           O  
ATOM   1223  CG2 THR    80      -0.837  -6.182   3.998  1.00  5.43           C  
ATOM   1224  H   THR    80      -1.195  -2.681   1.463  1.00 37.41           H  
ATOM   1225  HA  THR    80      -1.093  -3.397   4.304  1.00 64.32           H  
ATOM   1226  HB  THR    80      -1.480  -5.447   2.100  1.00 64.12           H  
ATOM   1227  HG1 THR    80      -3.488  -5.116   2.709  1.00 11.42           H  
ATOM   1228 HG21 THR    80      -0.865  -5.876   5.034  1.00 37.41           H  
ATOM   1229 HG22 THR    80       0.192  -6.269   3.677  1.00 37.41           H  
ATOM   1230 HG23 THR    80      -1.326  -7.140   3.896  1.00 37.41           H  
ATOM   1231  N   SER    81       1.385  -3.644   4.084  1.00 55.20           N  
ATOM   1232  CA  SER    81       2.854  -3.672   3.956  1.00 70.42           C  
ATOM   1233  C   SER    81       3.435  -5.074   4.181  1.00  1.13           C  
ATOM   1234  O   SER    81       2.783  -5.955   4.752  1.00  0.21           O  
ATOM   1235  CB  SER    81       3.496  -2.690   4.943  1.00 14.40           C  
ATOM   1236  OG  SER    81       4.910  -2.741   4.869  1.00 40.10           O  
ATOM   1237  H   SER    81       0.986  -3.476   4.965  1.00 37.41           H  
ATOM   1238  HA  SER    81       3.099  -3.358   2.950  1.00 32.31           H  
ATOM   1239  HB2 SER    81       3.174  -1.686   4.710  1.00 37.41           H  
ATOM   1240  HB3 SER    81       3.189  -2.937   5.950  1.00 37.41           H  
ATOM   1241  HG  SER    81       5.256  -1.873   4.625  1.00 61.12           H  
ATOM   1242  N   GLN    82       4.677  -5.271   3.739  1.00  5.15           N  
ATOM   1243  CA  GLN    82       5.359  -6.558   3.892  1.00 21.22           C  
ATOM   1244  C   GLN    82       6.166  -6.618   5.200  1.00 62.30           C  
ATOM   1245  O   GLN    82       6.863  -5.668   5.560  1.00 11.14           O  
ATOM   1246  CB  GLN    82       6.300  -6.835   2.704  1.00 60.54           C  
ATOM   1247  CG  GLN    82       5.623  -6.827   1.331  1.00 40.12           C  
ATOM   1248  CD  GLN    82       5.440  -5.429   0.762  1.00 34.15           C  
ATOM   1249  OE1 GLN    82       4.416  -4.784   0.956  1.00 74.24           O  
ATOM   1250  NE2 GLN    82       6.438  -4.949   0.049  1.00 13.44           N  
ATOM   1251  H   GLN    82       5.147  -4.528   3.306  1.00 37.41           H  
ATOM   1252  HA  GLN    82       4.602  -7.330   3.918  1.00 24.02           H  
ATOM   1253  HB2 GLN    82       7.079  -6.085   2.698  1.00 37.41           H  
ATOM   1254  HB3 GLN    82       6.756  -7.805   2.847  1.00 37.41           H  
ATOM   1255  HG2 GLN    82       6.229  -7.400   0.645  1.00 37.41           H  
ATOM   1256  HG3 GLN    82       4.651  -7.295   1.421  1.00 37.41           H  
ATOM   1257 HE21 GLN    82       7.232  -5.512  -0.077  1.00 37.41           H  
ATOM   1258 HE22 GLN    82       6.351  -4.046  -0.311  1.00 37.41           H  
ATOM   1259  N   MET    83       6.062  -7.752   5.893  1.00 21.12           N  
ATOM   1260  CA  MET    83       6.801  -8.008   7.140  1.00 20.12           C  
ATOM   1261  C   MET    83       8.272  -7.528   7.081  1.00 52.45           C  
ATOM   1262  O   MET    83       9.072  -8.020   6.280  1.00 11.10           O  
ATOM   1263  CB  MET    83       6.744  -9.512   7.447  1.00 43.35           C  
ATOM   1264  CG  MET    83       7.207 -10.389   6.284  1.00  3.32           C  
ATOM   1265  SD  MET    83       6.966 -12.151   6.591  1.00 54.34           S  
ATOM   1266  CE  MET    83       7.519 -12.842   5.032  1.00 11.34           C  
ATOM   1267  H   MET    83       5.448  -8.442   5.563  1.00 37.41           H  
ATOM   1268  HA  MET    83       6.297  -7.475   7.933  1.00 14.22           H  
ATOM   1269  HB2 MET    83       7.371  -9.722   8.305  1.00 37.41           H  
ATOM   1270  HB3 MET    83       5.724  -9.780   7.687  1.00 37.41           H  
ATOM   1271  HG2 MET    83       6.649 -10.117   5.399  1.00 37.41           H  
ATOM   1272  HG3 MET    83       8.258 -10.210   6.111  1.00 37.41           H  
ATOM   1273  HE1 MET    83       8.537 -12.535   4.843  1.00 37.41           H  
ATOM   1274  HE2 MET    83       6.882 -12.488   4.235  1.00 37.41           H  
ATOM   1275  HE3 MET    83       7.472 -13.919   5.079  1.00 37.41           H  
ATOM   1276  N   TYR    84       8.613  -6.554   7.932  1.00 31.51           N  
ATOM   1277  CA  TYR    84       9.984  -6.026   8.013  1.00 62.50           C  
ATOM   1278  C   TYR    84      10.837  -6.825   9.012  1.00 11.43           C  
ATOM   1279  O   TYR    84      10.323  -7.658   9.759  1.00 44.01           O  
ATOM   1280  CB  TYR    84       9.965  -4.547   8.426  1.00 12.32           C  
ATOM   1281  CG  TYR    84       9.245  -3.642   7.444  1.00 41.13           C  
ATOM   1282  CD1 TYR    84       9.902  -3.121   6.334  1.00 70.11           C  
ATOM   1283  CD2 TYR    84       7.905  -3.308   7.626  1.00 12.42           C  
ATOM   1284  CE1 TYR    84       9.250  -2.294   5.440  1.00  1.15           C  
ATOM   1285  CE2 TYR    84       7.248  -2.483   6.735  1.00 14.23           C  
ATOM   1286  CZ  TYR    84       7.924  -1.978   5.644  1.00 12.04           C  
ATOM   1287  OH  TYR    84       7.268  -1.156   4.750  1.00 22.12           O  
ATOM   1288  H   TYR    84       7.924  -6.176   8.519  1.00 37.41           H  
ATOM   1289  HA  TYR    84      10.433  -6.109   7.032  1.00 13.23           H  
ATOM   1290  HB2 TYR    84       9.470  -4.455   9.383  1.00 37.41           H  
ATOM   1291  HB3 TYR    84      10.982  -4.193   8.520  1.00 37.41           H  
ATOM   1292  HD1 TYR    84      10.941  -3.370   6.174  1.00 62.23           H  
ATOM   1293  HD2 TYR    84       7.378  -3.702   8.483  1.00 30.20           H  
ATOM   1294  HE1 TYR    84       9.780  -1.899   4.585  1.00 12.23           H  
ATOM   1295  HE2 TYR    84       6.209  -2.237   6.896  1.00 61.43           H  
ATOM   1296  HH  TYR    84       7.405  -1.483   3.856  1.00 43.33           H  
ATOM   1297  N   SER    85      12.141  -6.561   9.027  1.00 13.02           N  
ATOM   1298  CA  SER    85      13.061  -7.245   9.949  1.00 52.24           C  
ATOM   1299  C   SER    85      13.109  -6.551  11.317  1.00 42.44           C  
ATOM   1300  O   SER    85      12.815  -7.158  12.349  1.00  1.01           O  
ATOM   1301  CB  SER    85      14.472  -7.300   9.348  1.00 54.31           C  
ATOM   1302  OG  SER    85      14.975  -5.995   9.092  1.00 43.35           O  
ATOM   1303  H   SER    85      12.498  -5.896   8.403  1.00 37.41           H  
ATOM   1304  HA  SER    85      12.702  -8.256  10.086  1.00 51.40           H  
ATOM   1305  HB2 SER    85      15.137  -7.798  10.039  1.00 37.41           H  
ATOM   1306  HB3 SER    85      14.443  -7.850   8.418  1.00 37.41           H  
ATOM   1307  HG  SER    85      15.881  -6.067   8.762  1.00  2.54           H  
ATOM   1308  N   SER    86      13.502  -5.279  11.322  1.00 63.42           N  
ATOM   1309  CA  SER    86      13.582  -4.489  12.559  1.00 74.23           C  
ATOM   1310  C   SER    86      12.373  -3.556  12.705  1.00 73.32           C  
ATOM   1311  O   SER    86      11.706  -3.226  11.719  1.00 23.32           O  
ATOM   1312  CB  SER    86      14.864  -3.644  12.572  1.00 54.32           C  
ATOM   1313  OG  SER    86      14.833  -2.648  11.557  1.00 20.40           O  
ATOM   1314  H   SER    86      13.752  -4.859  10.472  1.00 37.41           H  
ATOM   1315  HA  SER    86      13.604  -5.173  13.397  1.00 44.14           H  
ATOM   1316  HB2 SER    86      14.965  -3.158  13.532  1.00 37.41           H  
ATOM   1317  HB3 SER    86      15.718  -4.286  12.404  1.00 37.41           H  
ATOM   1318  HG  SER    86      15.653  -2.682  11.042  1.00 20.51           H  
ATOM   1319  N   THR    87      12.093  -3.124  13.933  1.00 65.31           N  
ATOM   1320  CA  THR    87      11.020  -2.149  14.177  1.00 45.55           C  
ATOM   1321  C   THR    87      11.331  -0.822  13.479  1.00 11.24           C  
ATOM   1322  O   THR    87      10.457  -0.203  12.870  1.00 23.25           O  
ATOM   1323  CB  THR    87      10.808  -1.882  15.687  1.00 50.10           C  
ATOM   1324  OG1 THR    87      11.999  -1.322  16.264  1.00 33.13           O  
ATOM   1325  CG2 THR    87      10.444  -3.167  16.423  1.00 61.13           C  
ATOM   1326  H   THR    87      12.616  -3.464  14.695  1.00 37.41           H  
ATOM   1327  HA  THR    87      10.102  -2.553  13.769  1.00 30.01           H  
ATOM   1328  HB  THR    87       9.997  -1.177  15.803  1.00 74.14           H  
ATOM   1329  HG1 THR    87      11.760  -0.583  16.839  1.00  3.11           H  
ATOM   1330 HG21 THR    87      11.243  -3.887  16.310  1.00 37.41           H  
ATOM   1331 HG22 THR    87       9.531  -3.574  16.010  1.00 37.41           H  
ATOM   1332 HG23 THR    87      10.299  -2.953  17.472  1.00 37.41           H  
ATOM   1333  N   ALA    88      12.596  -0.405  13.561  1.00 52.20           N  
ATOM   1334  CA  ALA    88      13.069   0.810  12.892  1.00 21.41           C  
ATOM   1335  C   ALA    88      12.811   0.757  11.376  1.00 34.01           C  
ATOM   1336  O   ALA    88      12.411   1.755  10.775  1.00 31.42           O  
ATOM   1337  CB  ALA    88      14.554   1.029  13.174  1.00 62.43           C  
ATOM   1338  H   ALA    88      13.229  -0.927  14.098  1.00 37.41           H  
ATOM   1339  HA  ALA    88      12.525   1.647  13.307  1.00 22.44           H  
ATOM   1340  HB1 ALA    88      14.722   1.033  14.240  1.00 37.41           H  
ATOM   1341  HB2 ALA    88      14.865   1.977  12.759  1.00 37.41           H  
ATOM   1342  HB3 ALA    88      15.131   0.234  12.723  1.00 37.41           H  
ATOM   1343  N   ALA    89      13.041  -0.408  10.763  1.00 22.32           N  
ATOM   1344  CA  ALA    89      12.750  -0.606   9.334  1.00 24.30           C  
ATOM   1345  C   ALA    89      11.290  -0.260   9.009  1.00 74.43           C  
ATOM   1346  O   ALA    89      10.999   0.381   7.999  1.00 61.43           O  
ATOM   1347  CB  ALA    89      13.051  -2.044   8.923  1.00 34.13           C  
ATOM   1348  H   ALA    89      13.429  -1.150  11.279  1.00 37.41           H  
ATOM   1349  HA  ALA    89      13.399   0.050   8.770  1.00 31.22           H  
ATOM   1350  HB1 ALA    89      12.424  -2.721   9.486  1.00 37.41           H  
ATOM   1351  HB2 ALA    89      14.088  -2.266   9.123  1.00 37.41           H  
ATOM   1352  HB3 ALA    89      12.855  -2.167   7.866  1.00 37.41           H  
ATOM   1353  N   ARG    90      10.381  -0.684   9.883  1.00 11.00           N  
ATOM   1354  CA  ARG    90       8.951  -0.412   9.713  1.00 33.04           C  
ATOM   1355  C   ARG    90       8.652   1.096   9.741  1.00 30.22           C  
ATOM   1356  O   ARG    90       8.065   1.641   8.808  1.00 73.34           O  
ATOM   1357  CB  ARG    90       8.152  -1.104  10.823  1.00 44.22           C  
ATOM   1358  CG  ARG    90       6.644  -0.872  10.740  1.00 45.02           C  
ATOM   1359  CD  ARG    90       5.953  -1.217  12.052  1.00 61.31           C  
ATOM   1360  NE  ARG    90       6.448  -0.396  13.158  1.00 33.23           N  
ATOM   1361  CZ  ARG    90       5.953  -0.406  14.365  1.00 13.35           C  
ATOM   1362  NH1 ARG    90       4.968  -1.191  14.672  1.00 64.35           N  
ATOM   1363  NH2 ARG    90       6.455   0.371  15.264  1.00 43.35           N  
ATOM   1364  H   ARG    90      10.680  -1.197  10.664  1.00 37.41           H  
ATOM   1365  HA  ARG    90       8.646  -0.814   8.758  1.00 34.12           H  
ATOM   1366  HB2 ARG    90       8.335  -2.169  10.770  1.00 37.41           H  
ATOM   1367  HB3 ARG    90       8.499  -0.738  11.779  1.00 37.41           H  
ATOM   1368  HG2 ARG    90       6.459   0.170  10.512  1.00 37.41           H  
ATOM   1369  HG3 ARG    90       6.236  -1.491   9.952  1.00 37.41           H  
ATOM   1370  HD2 ARG    90       4.890  -1.054  11.938  1.00 37.41           H  
ATOM   1371  HD3 ARG    90       6.135  -2.259  12.277  1.00 37.41           H  
ATOM   1372  HE  ARG    90       7.196   0.212  12.977  1.00 52.40           H  
ATOM   1373 HH11 ARG    90       4.581  -1.794  13.988  1.00 37.41           H  
ATOM   1374 HH12 ARG    90       4.591  -1.178  15.600  1.00 37.41           H  
ATOM   1375 HH21 ARG    90       7.217   0.980  15.028  1.00 37.41           H  
ATOM   1376 HH22 ARG    90       6.080   0.373  16.190  1.00 37.41           H  
ATOM   1377  N   ASP    91       9.064   1.763  10.816  1.00 40.42           N  
ATOM   1378  CA  ASP    91       8.766   3.187  11.006  1.00  2.52           C  
ATOM   1379  C   ASP    91       9.501   4.082   9.985  1.00 70.24           C  
ATOM   1380  O   ASP    91       8.964   5.108   9.551  1.00 75.01           O  
ATOM   1381  CB  ASP    91       9.087   3.594  12.447  1.00 21.44           C  
ATOM   1382  CG  ASP    91       8.134   2.936  13.440  1.00  2.12           C  
ATOM   1383  OD1 ASP    91       8.377   1.775  13.833  1.00 23.12           O  
ATOM   1384  OD2 ASP    91       7.127   3.571  13.818  1.00 30.33           O  
ATOM   1385  H   ASP    91       9.578   1.286  11.507  1.00 37.41           H  
ATOM   1386  HA  ASP    91       7.702   3.311  10.850  1.00 41.42           H  
ATOM   1387  HB2 ASP    91      10.099   3.294  12.684  1.00 37.41           H  
ATOM   1388  HB3 ASP    91       9.003   4.668  12.545  1.00 37.41           H  
ATOM   1389  N   ASN    92      10.717   3.698   9.593  1.00 24.54           N  
ATOM   1390  CA  ASN    92      11.417   4.388   8.500  1.00 43.40           C  
ATOM   1391  C   ASN    92      10.694   4.148   7.170  1.00 41.23           C  
ATOM   1392  O   ASN    92      10.585   5.048   6.331  1.00  5.51           O  
ATOM   1393  CB  ASN    92      12.887   3.949   8.402  1.00 21.14           C  
ATOM   1394  CG  ASN    92      13.772   4.674   9.401  1.00  3.32           C  
ATOM   1395  OD1 ASN    92      14.285   5.755   9.126  1.00  3.13           O  
ATOM   1396  ND2 ASN    92      13.967   4.091  10.563  1.00 32.32           N  
ATOM   1397  H   ASN    92      11.145   2.938  10.038  1.00 37.41           H  
ATOM   1398  HA  ASN    92      11.384   5.449   8.713  1.00 54.44           H  
ATOM   1399  HB2 ASN    92      12.954   2.888   8.595  1.00 37.41           H  
ATOM   1400  HB3 ASN    92      13.258   4.152   7.408  1.00 37.41           H  
ATOM   1401 HD21 ASN    92      13.540   3.227  10.725  1.00 37.41           H  
ATOM   1402 HD22 ASN    92      14.534   4.551  11.217  1.00 37.41           H  
ATOM   1403  N   GLY    93      10.190   2.929   6.988  1.00 33.01           N  
ATOM   1404  CA  GLY    93       9.344   2.637   5.843  1.00 30.33           C  
ATOM   1405  C   GLY    93       8.134   3.563   5.786  1.00 44.40           C  
ATOM   1406  O   GLY    93       7.849   4.154   4.747  1.00 20.01           O  
ATOM   1407  H   GLY    93      10.397   2.219   7.635  1.00 37.41           H  
ATOM   1408  HA2 GLY    93       9.924   2.753   4.939  1.00 37.41           H  
ATOM   1409  HA3 GLY    93       9.003   1.614   5.912  1.00 37.41           H  
ATOM   1410  N   ILE    94       7.447   3.709   6.923  1.00 62.14           N  
ATOM   1411  CA  ILE    94       6.288   4.608   7.043  1.00 63.01           C  
ATOM   1412  C   ILE    94       6.627   6.044   6.601  1.00 65.20           C  
ATOM   1413  O   ILE    94       5.849   6.682   5.889  1.00 33.41           O  
ATOM   1414  CB  ILE    94       5.743   4.632   8.499  1.00 21.43           C  
ATOM   1415  CG1 ILE    94       5.302   3.219   8.929  1.00 22.41           C  
ATOM   1416  CG2 ILE    94       4.585   5.624   8.628  1.00 31.41           C  
ATOM   1417  CD1 ILE    94       4.824   3.133  10.365  1.00  5.53           C  
ATOM   1418  H   ILE    94       7.722   3.187   7.707  1.00 37.41           H  
ATOM   1419  HA  ILE    94       5.507   4.226   6.398  1.00 63.10           H  
ATOM   1420  HB  ILE    94       6.540   4.963   9.151  1.00 62.24           H  
ATOM   1421 HG12 ILE    94       4.489   2.896   8.295  1.00 37.41           H  
ATOM   1422 HG13 ILE    94       6.133   2.537   8.814  1.00 37.41           H  
ATOM   1423 HG21 ILE    94       4.214   5.620   9.643  1.00 37.41           H  
ATOM   1424 HG22 ILE    94       3.789   5.340   7.954  1.00 37.41           H  
ATOM   1425 HG23 ILE    94       4.930   6.617   8.377  1.00 37.41           H  
ATOM   1426 HD11 ILE    94       3.967   3.777  10.500  1.00 37.41           H  
ATOM   1427 HD12 ILE    94       5.616   3.447  11.029  1.00 37.41           H  
ATOM   1428 HD13 ILE    94       4.547   2.114  10.593  1.00 37.41           H  
ATOM   1429  N   LYS    95       7.788   6.552   7.022  1.00 12.12           N  
ATOM   1430  CA  LYS    95       8.235   7.888   6.599  1.00  3.54           C  
ATOM   1431  C   LYS    95       8.322   7.975   5.064  1.00 12.31           C  
ATOM   1432  O   LYS    95       7.893   8.962   4.450  1.00 50.22           O  
ATOM   1433  CB  LYS    95       9.593   8.237   7.227  1.00 22.14           C  
ATOM   1434  CG  LYS    95       9.587   8.239   8.756  1.00  4.23           C  
ATOM   1435  CD  LYS    95      10.887   8.798   9.339  1.00 72.42           C  
ATOM   1436  CE  LYS    95      12.109   7.977   8.938  1.00 70.43           C  
ATOM   1437  NZ  LYS    95      13.371   8.537   9.501  1.00 24.34           N  
ATOM   1438  H   LYS    95       8.350   6.022   7.631  1.00 37.41           H  
ATOM   1439  HA  LYS    95       7.498   8.603   6.941  1.00 23.11           H  
ATOM   1440  HB2 LYS    95      10.326   7.516   6.891  1.00 37.41           H  
ATOM   1441  HB3 LYS    95       9.889   9.221   6.888  1.00 37.41           H  
ATOM   1442  HG2 LYS    95       8.761   8.846   9.101  1.00 37.41           H  
ATOM   1443  HG3 LYS    95       9.455   7.224   9.104  1.00 37.41           H  
ATOM   1444  HD2 LYS    95      11.020   9.810   8.984  1.00 37.41           H  
ATOM   1445  HD3 LYS    95      10.809   8.806  10.417  1.00 37.41           H  
ATOM   1446  HE2 LYS    95      11.985   6.967   9.301  1.00 37.41           H  
ATOM   1447  HE3 LYS    95      12.184   7.965   7.859  1.00 37.41           H  
ATOM   1448  HZ1 LYS    95      14.163   7.886   9.326  1.00 37.41           H  
ATOM   1449  HZ2 LYS    95      13.276   8.681  10.528  1.00 37.41           H  
ATOM   1450  HZ3 LYS    95      13.591   9.450   9.056  1.00 37.41           H  
ATOM   1451  N   SER    96       8.874   6.930   4.450  1.00 12.50           N  
ATOM   1452  CA  SER    96       8.935   6.835   2.987  1.00 44.14           C  
ATOM   1453  C   SER    96       7.523   6.782   2.387  1.00 64.41           C  
ATOM   1454  O   SER    96       7.223   7.487   1.426  1.00 44.33           O  
ATOM   1455  CB  SER    96       9.733   5.594   2.559  1.00 22.51           C  
ATOM   1456  OG  SER    96      11.057   5.631   3.076  1.00 73.53           O  
ATOM   1457  H   SER    96       9.251   6.202   4.993  1.00 37.41           H  
ATOM   1458  HA  SER    96       9.437   7.720   2.617  1.00 20.13           H  
ATOM   1459  HB2 SER    96       9.243   4.706   2.928  1.00 37.41           H  
ATOM   1460  HB3 SER    96       9.785   5.554   1.479  1.00 37.41           H  
ATOM   1461  HG  SER    96      11.063   5.256   3.966  1.00 64.30           H  
ATOM   1462  N   VAL    97       6.660   5.955   2.985  1.00 22.23           N  
ATOM   1463  CA  VAL    97       5.264   5.803   2.542  1.00 24.34           C  
ATOM   1464  C   VAL    97       4.527   7.147   2.515  1.00  2.13           C  
ATOM   1465  O   VAL    97       3.820   7.463   1.560  1.00 62.41           O  
ATOM   1466  CB  VAL    97       4.482   4.840   3.469  1.00 14.51           C  
ATOM   1467  CG1 VAL    97       3.028   4.690   3.018  1.00 71.24           C  
ATOM   1468  CG2 VAL    97       5.166   3.484   3.543  1.00 15.31           C  
ATOM   1469  H   VAL    97       6.969   5.428   3.749  1.00 37.41           H  
ATOM   1470  HA  VAL    97       5.273   5.385   1.545  1.00  1.13           H  
ATOM   1471  HB  VAL    97       4.483   5.263   4.462  1.00 32.32           H  
ATOM   1472 HG11 VAL    97       2.517   3.998   3.672  1.00 37.41           H  
ATOM   1473 HG12 VAL    97       2.999   4.315   2.006  1.00 37.41           H  
ATOM   1474 HG13 VAL    97       2.536   5.653   3.057  1.00 37.41           H  
ATOM   1475 HG21 VAL    97       6.196   3.614   3.837  1.00 37.41           H  
ATOM   1476 HG22 VAL    97       5.126   3.005   2.576  1.00 37.41           H  
ATOM   1477 HG23 VAL    97       4.663   2.866   4.269  1.00 37.41           H  
ATOM   1478  N   MET    98       4.684   7.935   3.575  1.00 75.31           N  
ATOM   1479  CA  MET    98       4.060   9.256   3.635  1.00 41.35           C  
ATOM   1480  C   MET    98       4.594  10.166   2.521  1.00 41.34           C  
ATOM   1481  O   MET    98       3.834  10.905   1.898  1.00  0.11           O  
ATOM   1482  CB  MET    98       4.282   9.904   5.010  1.00  4.12           C  
ATOM   1483  CG  MET    98       3.651   9.128   6.161  1.00  3.41           C  
ATOM   1484  SD  MET    98       3.719  10.019   7.729  1.00 30.23           S  
ATOM   1485  CE  MET    98       5.489  10.191   7.964  1.00 73.24           C  
ATOM   1486  H   MET    98       5.226   7.621   4.328  1.00 37.41           H  
ATOM   1487  HA  MET    98       2.997   9.119   3.485  1.00 63.30           H  
ATOM   1488  HB2 MET    98       5.345   9.979   5.192  1.00 37.41           H  
ATOM   1489  HB3 MET    98       3.857  10.899   5.001  1.00 37.41           H  
ATOM   1490  HG2 MET    98       2.615   8.938   5.924  1.00 37.41           H  
ATOM   1491  HG3 MET    98       4.171   8.187   6.275  1.00 37.41           H  
ATOM   1492  HE1 MET    98       5.914  10.735   7.133  1.00 37.41           H  
ATOM   1493  HE2 MET    98       5.944   9.212   8.020  1.00 37.41           H  
ATOM   1494  HE3 MET    98       5.681  10.729   8.882  1.00 37.41           H  
ATOM   1495  N   GLU    99       5.900  10.090   2.259  1.00 34.51           N  
ATOM   1496  CA  GLU    99       6.524  10.917   1.218  1.00 32.11           C  
ATOM   1497  C   GLU    99       6.046  10.539  -0.201  1.00 60.22           C  
ATOM   1498  O   GLU    99       5.629  11.400  -0.976  1.00 44.32           O  
ATOM   1499  CB  GLU    99       8.050  10.794   1.271  1.00 52.15           C  
ATOM   1500  CG  GLU    99       8.757  11.763   0.329  1.00 14.20           C  
ATOM   1501  CD  GLU    99      10.186  11.363   0.018  1.00 63.03           C  
ATOM   1502  OE1 GLU    99      11.087  11.658   0.828  1.00  4.14           O  
ATOM   1503  OE2 GLU    99      10.411  10.767  -1.055  1.00 13.44           O  
ATOM   1504  H   GLU    99       6.463   9.475   2.785  1.00 37.41           H  
ATOM   1505  HA  GLU    99       6.253  11.946   1.411  1.00 25.32           H  
ATOM   1506  HB2 GLU    99       8.383  10.993   2.280  1.00 37.41           H  
ATOM   1507  HB3 GLU    99       8.331   9.785   1.000  1.00 37.41           H  
ATOM   1508  HG2 GLU    99       8.204  11.808  -0.599  1.00 37.41           H  
ATOM   1509  HG3 GLU    99       8.764  12.745   0.782  1.00 37.41           H  
ATOM   1510  N   ASN   100       6.127   9.251  -0.544  1.00  3.11           N  
ATOM   1511  CA  ASN   100       5.842   8.796  -1.917  1.00 53.52           C  
ATOM   1512  C   ASN   100       4.372   8.388  -2.122  1.00 23.34           C  
ATOM   1513  O   ASN   100       3.846   8.496  -3.227  1.00 14.11           O  
ATOM   1514  CB  ASN   100       6.779   7.641  -2.304  1.00 64.23           C  
ATOM   1515  CG  ASN   100       6.757   6.484  -1.319  1.00 11.22           C  
ATOM   1516  OD1 ASN   100       5.763   6.225  -0.659  1.00  1.03           O  
ATOM   1517  ND2 ASN   100       7.864   5.780  -1.212  1.00 14.54           N  
ATOM   1518  H   ASN   100       6.376   8.589   0.139  1.00 37.41           H  
ATOM   1519  HA  ASN   100       6.048   9.629  -2.577  1.00  2.41           H  
ATOM   1520  HB2 ASN   100       6.490   7.260  -3.272  1.00 37.41           H  
ATOM   1521  HB3 ASN   100       7.792   8.017  -2.366  1.00 37.41           H  
ATOM   1522 HD21 ASN   100       8.632   6.031  -1.764  1.00 37.41           H  
ATOM   1523 HD22 ASN   100       7.867   5.034  -0.583  1.00 37.41           H  
ATOM   1524  N   GLY   101       3.716   7.930  -1.060  1.00 34.41           N  
ATOM   1525  CA  GLY   101       2.311   7.520  -1.144  1.00 21.04           C  
ATOM   1526  C   GLY   101       1.373   8.620  -1.650  1.00 72.40           C  
ATOM   1527  O   GLY   101       0.233   8.351  -2.033  1.00  3.20           O  
ATOM   1528  H   GLY   101       4.194   7.839  -0.209  1.00 37.41           H  
ATOM   1529  HA2 GLY   101       2.236   6.673  -1.809  1.00 37.41           H  
ATOM   1530  HA3 GLY   101       1.986   7.212  -0.161  1.00 37.41           H  
END
