
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   67 (  545),  selected   67 , name 2yzt_A
# Molecule2: number of CA atoms   50 (  770),  selected   50 , name T0472_52_101.pdb
# PARAMETERS: 2yzt_A.T0472_52_101.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    R     2_A      -       -           -
LGA    R     3_A      I      52          3.252
LGA    R     4_A      E      53          3.288
LGA    Y     5_A      A      54          3.037
LGA    R     6_A      R      55          2.095
LGA    V     7_A      Y      56          1.836
LGA    V     8_A      A      57          1.586
LGA    V     9_A      K      58          1.698
LGA    E    10_A      E      59          1.631
LGA    R    11_A      V      60          1.368
LGA    D    12_A      A      61          1.182
LGA    E    13_A      K      62          2.671
LGA    E    14_A      N      63          1.734
LGA    G    15_A      D      64          0.686
LGA    Y    16_A      K      65          0.542
LGA    F    17_A      P      66          1.197
LGA    V    18_A      Y      67          1.609
LGA    A    19_A      F      68          0.290
LGA    H    20_A      N      69          0.794
LGA    V    21_A      L      70          1.581
LGA    P    22_A      K      71          1.074
LGA    E    23_A      A      72          2.684
LGA    L    24_A      A      73           -
LGA    -       -      N      74           -
LGA    -       -      H      75           -
LGA    -       -      Q      76           -
LGA    -       -      I      77           -
LGA    H    25_A      I      78          2.385
LGA    A    26_A      G      79          2.253
LGA    H    27_A      T      80          2.033
LGA    T    28_A      S      81          2.103
LGA    Q    29_A      Q      82          3.353
LGA    -       -      M      83           -
LGA    A    30_A      Y      84          1.304
LGA    Q    31_A      S      85          1.697
LGA    S    32_A      S      86          1.667
LGA    F    33_A      T      87          1.406
LGA    E    34_A      A      88          0.675
LGA    E    35_A      A      89          0.614
LGA    L    36_A      R      90          0.353
LGA    L    37_A      D      91          0.532
LGA    R    38_A      N      92          0.800
LGA    R    39_A      G      93          0.790
LGA    L    40_A      I      94          1.299
LGA    Q    41_A      K      95          1.564
LGA    E    42_A      S      96          0.899
LGA    A    43_A      V      97          1.656
LGA    I    44_A      M      98          2.375
LGA    A    45_A      E      99          1.792
LGA    V    46_A      N     100          1.549
LGA    S    47_A      G     101          1.533
LGA    L    48_A      -       -           -
LGA    E    49_A      -       -           -
LGA    E    50_A      -       -           -
LGA    E    51_A      -       -           -
LGA    R    52_A      -       -           -
LGA    A    53_A      -       -           -
LGA    E    54_A      -       -           -
LGA    V    55_A      -       -           -
LGA    V    56_A      -       -           -
LGA    G    57_A      -       -           -
LGA    L    58_A      -       -           -
LGA    E    59_A      -       -           -
LGA    G    60_A      -       -           -
LGA    A    61_A      -       -           -
LGA    L    62_A      -       -           -
LGA    E    63_A      -       -           -
LGA    I    64_A      -       -           -
LGA    E    65_A      -       -           -
LGA    A    66_A      -       -           -
LGA    A    67_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   67   50    5.0     44    1.78     9.09     79.763     2.337

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.287288 * X  +  -0.957817 * Y  +  -0.007147 * Z  +  25.151587
  Y_new =   0.745624 * X  +  -0.218946 * Y  +  -0.629371 * Z  +  14.123127
  Z_new =   0.601258 * X  +  -0.186140 * Y  +   0.777072 * Z  +  -4.188082 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.235110    2.906483  [ DEG:   -13.4708    166.5292 ]
  Theta =  -0.645074   -2.496519  [ DEG:   -36.9600   -143.0400 ]
  Phi   =   1.938566   -1.203027  [ DEG:   111.0716    -68.9284 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2yzt_A                                        
REMARK     2: T0472_52_101.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2yzt_A.T0472_52_101.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   67   50   5.0   44   1.78    9.09  79.763
REMARK  ---------------------------------------------------------- 
MOLECULE 2yzt_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   06-MAY-07   2YZT              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED PROTEIN FROM           
TITLE    2 THERMUS THERMOPHILUS HB8                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE UNCHARACTERIZED PROTEIN TTHA1756;                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-11A                                   
KEYWDS    UNCHARACTERIZED CONSERVED PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 UNKNOWN FUNCTION, NPPSFA, NATIONAL PROJECT ON PROTEIN                
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.EBIHARA,S.YOKOYAMA,S.KURAMITSU,RIKEN STRUCTURAL                     
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   06-NOV-07 2YZT    0                                                
JRNL        AUTH   A.EBIHARA,S.YOKOYAMA,S.KURAMITSU                             
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED               
JRNL        TITL 2 PROTEIN FROM THERMUS THERMOPHILUS HB8                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2YZT A    1    67  UNP    Q5SHH4   Q5SHH4_THET8     1     67             
SEQRES   1 A   67  MSE ARG ARG ARG TYR ARG VAL VAL VAL GLU ARG ASP GLU          
SEQRES   2 A   67  GLU GLY TYR PHE VAL ALA HIS VAL PRO GLU LEU HIS ALA          
SEQRES   3 A   67  HIS THR GLN ALA GLN SER PHE GLU GLU LEU LEU ARG ARG          
SEQRES   4 A   67  LEU GLN GLU ALA ILE ALA VAL SER LEU GLU GLU GLU ARG          
SEQRES   5 A   67  ALA GLU VAL VAL GLY LEU GLU GLY ALA LEU GLU ILE GLU          
SEQRES   6 A   67  ALA ALA                                                      
HET    MSE  A   1       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    C5 H11 N O2 SE                                               
FORMUL   2  HOH   *33(H2 O)                                                     
CRYST1   50.152   50.152   46.817  90.00  90.00 120.00 P 31 2 1      6          
HETATM    1  N   MSE A   1       2.809  19.644   3.819  1.00 26.53           N  
HETATM    2  CA  MSE A   1       1.363  19.327   3.996  1.00 25.98           C  
HETATM    3  C   MSE A   1       1.144  18.473   5.236  1.00 25.15           C  
HETATM    4  O   MSE A   1       2.027  17.716   5.645  1.00 26.09           O  
HETATM    5  CB  MSE A   1       0.799  18.608   2.755  1.00 27.90           C  
HETATM    6  CG  MSE A   1       1.454  17.285   2.386  1.00 30.13           C  
HETATM    7 SE   MSE A   1       0.507  16.327   0.964  1.00 32.31          SE  
HETATM    8  CE  MSE A   1       0.786  17.566  -0.480  1.00 31.20           C  
ATOM      9  N   ARG A   2      -0.042  18.602   5.821  1.00 23.20           N  
ATOM     10  CA  ARG A   2      -0.409  17.875   7.032  1.00 22.71           C  
ATOM     11  C   ARG A   2      -1.504  16.847   6.794  1.00 19.59           C  
ATOM     12  O   ARG A   2      -2.496  17.126   6.128  1.00 18.44           O  
ATOM     13  CB  ARG A   2      -0.886  18.861   8.098  1.00 24.30           C  
ATOM     14  CG  ARG A   2       0.222  19.673   8.720  1.00 27.89           C  
ATOM     15  CD  ARG A   2       0.911  18.883   9.816  1.00 30.51           C  
ATOM     16  NE  ARG A   2       2.102  19.576  10.301  1.00 35.26           N  
ATOM     17  CZ  ARG A   2       2.725  19.290  11.438  1.00 34.61           C  
ATOM     18  NH1 ARG A   2       2.267  18.324  12.221  1.00 36.43           N  
ATOM     19  NH2 ARG A   2       3.814  19.965  11.787  1.00 36.29           N  
ATOM     20  N   ARG A   3      -1.323  15.657   7.355  1.00 18.70           N  
ATOM     21  CA  ARG A   3      -2.308  14.599   7.218  1.00 17.05           C  
ATOM     22  C   ARG A   3      -2.325  13.733   8.470  1.00 16.87           C  
ATOM     23  O   ARG A   3      -1.350  13.670   9.211  1.00 13.48           O  
ATOM     24  CB  ARG A   3      -1.982  13.717   6.005  1.00 19.83           C  
ATOM     25  CG  ARG A   3      -2.047  14.426   4.658  1.00 18.80           C  
ATOM     26  CD  ARG A   3      -3.478  14.571   4.154  1.00 23.87           C  
ATOM     27  NE  ARG A   3      -3.507  15.191   2.831  1.00 26.31           N  
ATOM     28  CZ  ARG A   3      -3.362  16.493   2.604  1.00 26.89           C  
ATOM     29  NH1 ARG A   3      -3.185  17.336   3.611  1.00 26.58           N  
ATOM     30  NH2 ARG A   3      -3.381  16.952   1.360  1.00 29.15           N  
ATOM     31  N   ARG A   4      -3.454  13.082   8.708  1.00 16.74           N  
ATOM     32  CA  ARG A   4      -3.587  12.177   9.839  1.00 16.59           C  
ATOM     33  C   ARG A   4      -4.211  10.921   9.267  1.00 15.14           C  
ATOM     34  O   ARG A   4      -5.198  10.986   8.521  1.00 13.93           O  
ATOM     35  CB  ARG A   4      -4.479  12.776  10.930  1.00 21.36           C  
ATOM     36  CG  ARG A   4      -4.871  11.793  12.032  1.00 23.97           C  
ATOM     37  CD  ARG A   4      -5.443  12.535  13.228  1.00 29.17           C  
ATOM     38  NE  ARG A   4      -6.299  13.634  12.795  1.00 32.09           N  
ATOM     39  CZ  ARG A   4      -6.249  14.862  13.300  1.00 33.79           C  
ATOM     40  NH1 ARG A   4      -5.387  15.153  14.267  1.00 32.47           N  
ATOM     41  NH2 ARG A   4      -7.047  15.807  12.824  1.00 33.30           N  
ATOM     42  N   TYR A   5      -3.623   9.779   9.596  1.00 12.30           N  
ATOM     43  CA  TYR A   5      -4.120   8.507   9.095  1.00 14.72           C  
ATOM     44  C   TYR A   5      -4.260   7.453  10.168  1.00 12.79           C  
ATOM     45  O   TYR A   5      -3.380   7.297  11.017  1.00 13.90           O  
ATOM     46  CB  TYR A   5      -3.178   7.940   8.031  1.00 14.30           C  
ATOM     47  CG  TYR A   5      -3.044   8.802   6.805  1.00 17.11           C  
ATOM     48  CD1 TYR A   5      -4.152   9.089   6.011  1.00 18.38           C  
ATOM     49  CD2 TYR A   5      -1.812   9.348   6.447  1.00 18.31           C  
ATOM     50  CE1 TYR A   5      -4.039   9.904   4.893  1.00 20.40           C  
ATOM     51  CE2 TYR A   5      -1.688  10.163   5.328  1.00 20.09           C  
ATOM     52  CZ  TYR A   5      -2.808  10.438   4.557  1.00 21.92           C  
ATOM     53  OH  TYR A   5      -2.699  11.257   3.454  1.00 22.70           O  
ATOM     54  N   ARG A   6      -5.359   6.712  10.109  1.00 12.65           N  
ATOM     55  CA  ARG A   6      -5.550   5.617  11.045  1.00 14.77           C  
ATOM     56  C   ARG A   6      -4.517   4.570  10.635  1.00 11.63           C  
ATOM     57  O   ARG A   6      -4.244   4.391   9.446  1.00 11.34           O  
ATOM     58  CB  ARG A   6      -6.938   5.005  10.898  1.00 17.15           C  
ATOM     59  CG  ARG A   6      -8.054   5.745  11.595  1.00 25.11           C  
ATOM     60  CD  ARG A   6      -9.352   5.000  11.354  1.00 29.09           C  
ATOM     61  NE  ARG A   6      -9.644   4.910   9.925  1.00 33.64           N  
ATOM     62  CZ  ARG A   6     -10.152   3.835   9.329  1.00 34.67           C  
ATOM     63  NH1 ARG A   6     -10.429   2.750  10.037  1.00 35.83           N  
ATOM     64  NH2 ARG A   6     -10.381   3.846   8.023  1.00 36.71           N  
ATOM     65  N   VAL A   7      -3.945   3.881  11.611  1.00 11.17           N  
ATOM     66  CA  VAL A   7      -2.956   2.854  11.318  1.00 11.36           C  
ATOM     67  C   VAL A   7      -3.135   1.686  12.277  1.00 13.10           C  
ATOM     68  O   VAL A   7      -3.560   1.866  13.417  1.00 12.92           O  
ATOM     69  CB  VAL A   7      -1.495   3.405  11.455  1.00 11.50           C  
ATOM     70  CG1 VAL A   7      -1.170   3.675  12.922  1.00 14.13           C  
ATOM     71  CG2 VAL A   7      -0.500   2.414  10.860  1.00 14.56           C  
ATOM     72  N   VAL A   8      -2.840   0.483  11.798  1.00 11.74           N  
ATOM     73  CA  VAL A   8      -2.922  -0.708  12.621  1.00 14.09           C  
ATOM     74  C   VAL A   8      -1.609  -1.443  12.427  1.00 14.30           C  
ATOM     75  O   VAL A   8      -1.225  -1.764  11.298  1.00 15.55           O  
ATOM     76  CB  VAL A   8      -4.080  -1.640  12.206  1.00 13.92           C  
ATOM     77  CG1 VAL A   8      -3.996  -2.934  12.991  1.00 17.31           C  
ATOM     78  CG2 VAL A   8      -5.424  -0.960  12.476  1.00 15.62           C  
ATOM     79  N   VAL A   9      -0.921  -1.703  13.530  1.00 13.10           N  
ATOM     80  CA  VAL A   9       0.356  -2.395  13.484  1.00 14.71           C  
ATOM     81  C   VAL A   9       0.293  -3.680  14.286  1.00 16.18           C  
ATOM     82  O   VAL A   9      -0.218  -3.700  15.406  1.00 16.51           O  
ATOM     83  CB  VAL A   9       1.488  -1.540  14.081  1.00 14.15           C  
ATOM     84  CG1 VAL A   9       2.794  -2.324  14.037  1.00 14.68           C  
ATOM     85  CG2 VAL A   9       1.621  -0.231  13.316  1.00 11.99           C  
ATOM     86  N   GLU A  10       0.822  -4.754  13.718  1.00 18.39           N  
ATOM     87  CA  GLU A  10       0.825  -6.018  14.430  1.00 22.42           C  
ATOM     88  C   GLU A  10       2.173  -6.705  14.327  1.00 22.00           C  
ATOM     89  O   GLU A  10       2.865  -6.594  13.319  1.00 21.34           O  
ATOM     90  CB  GLU A  10      -0.298  -6.909  13.900  1.00 24.83           C  
ATOM     91  CG  GLU A  10      -1.636  -6.187  13.935  1.00 31.37           C  
ATOM     92  CD  GLU A  10      -2.823  -7.097  13.737  1.00 34.13           C  
ATOM     93  OE1 GLU A  10      -3.051  -7.974  14.598  1.00 35.91           O  
ATOM     94  OE2 GLU A  10      -3.529  -6.926  12.718  1.00 38.44           O  
ATOM     95  N   ARG A  11       2.548  -7.387  15.402  1.00 23.42           N  
ATOM     96  CA  ARG A  11       3.813  -8.103  15.479  1.00 24.40           C  
ATOM     97  C   ARG A  11       3.497  -9.596  15.369  1.00 24.75           C  
ATOM     98  O   ARG A  11       2.712 -10.121  16.156  1.00 25.27           O  
ATOM     99  CB  ARG A  11       4.477  -7.790  16.826  1.00 26.38           C  
ATOM    100  CG  ARG A  11       5.983  -7.993  16.889  1.00 29.90           C  
ATOM    101  CD  ARG A  11       6.534  -7.429  18.198  1.00 33.29           C  
ATOM    102  NE  ARG A  11       7.956  -7.097  18.121  1.00 34.50           N  
ATOM    103  CZ  ARG A  11       8.590  -6.325  19.001  1.00 36.97           C  
ATOM    104  NH1 ARG A  11       7.928  -5.807  20.032  1.00 35.87           N  
ATOM    105  NH2 ARG A  11       9.882  -6.053  18.845  1.00 36.16           N  
ATOM    106  N   ASP A  12       4.090 -10.281  14.392  1.00 24.80           N  
ATOM    107  CA  ASP A  12       3.823 -11.708  14.230  1.00 26.05           C  
ATOM    108  C   ASP A  12       4.681 -12.566  15.154  1.00 27.55           C  
ATOM    109  O   ASP A  12       5.500 -12.053  15.916  1.00 25.65           O  
ATOM    110  CB  ASP A  12       4.026 -12.154  12.769  1.00 25.63           C  
ATOM    111  CG  ASP A  12       5.463 -12.013  12.295  1.00 24.37           C  
ATOM    112  OD1 ASP A  12       6.385 -12.060  13.132  1.00 22.88           O  
ATOM    113  OD2 ASP A  12       5.669 -11.874  11.069  1.00 23.10           O  
ATOM    114  N   GLU A  13       4.476 -13.878  15.076  1.00 29.52           N  
ATOM    115  CA  GLU A  13       5.202 -14.844  15.897  1.00 32.38           C  
ATOM    116  C   GLU A  13       6.712 -14.647  15.849  1.00 32.95           C  
ATOM    117  O   GLU A  13       7.391 -14.790  16.867  1.00 34.43           O  
ATOM    118  CB  GLU A  13       4.843 -16.265  15.453  1.00 33.06           C  
ATOM    119  CG  GLU A  13       5.704 -17.370  16.052  1.00 37.18           C  
ATOM    120  CD  GLU A  13       7.062 -17.502  15.378  1.00 36.98           C  
ATOM    121  OE1 GLU A  13       7.110 -17.541  14.128  1.00 38.86           O  
ATOM    122  OE2 GLU A  13       8.079 -17.572  16.099  1.00 38.83           O  
ATOM    123  N   GLU A  14       7.231 -14.329  14.666  1.00 33.42           N  
ATOM    124  CA  GLU A  14       8.661 -14.110  14.486  1.00 34.16           C  
ATOM    125  C   GLU A  14       9.066 -12.757  15.058  1.00 33.65           C  
ATOM    126  O   GLU A  14      10.245 -12.410  15.081  1.00 33.49           O  
ATOM    127  CB  GLU A  14       9.020 -14.162  12.998  1.00 35.48           C  
ATOM    128  CG  GLU A  14       8.702 -15.485  12.329  1.00 40.87           C  
ATOM    129  CD  GLU A  14       8.891 -15.439  10.824  1.00 42.93           C  
ATOM    130  OE1 GLU A  14       8.246 -14.589  10.169  1.00 45.06           O  
ATOM    131  OE2 GLU A  14       9.677 -16.255  10.294  1.00 44.91           O  
ATOM    132  N   GLY A  15       8.083 -11.993  15.523  1.00 32.43           N  
ATOM    133  CA  GLY A  15       8.377 -10.686  16.075  1.00 30.41           C  
ATOM    134  C   GLY A  15       8.524  -9.640  14.983  1.00 28.78           C  
ATOM    135  O   GLY A  15       9.039  -8.544  15.225  1.00 28.74           O  
ATOM    136  N   TYR A  16       8.082  -9.977  13.773  1.00 25.47           N  
ATOM    137  CA  TYR A  16       8.156  -9.044  12.653  1.00 25.28           C  
ATOM    138  C   TYR A  16       6.874  -8.223  12.577  1.00 22.28           C  
ATOM    139  O   TYR A  16       5.822  -8.663  13.037  1.00 22.53           O  
ATOM    140  CB  TYR A  16       8.407  -9.795  11.340  1.00 26.92           C  
ATOM    141  CG  TYR A  16       9.782 -10.437  11.265  1.00 30.42           C  
ATOM    142  CD1 TYR A  16      10.767 -10.138  12.213  1.00 31.78           C  
ATOM    143  CD2 TYR A  16      10.104 -11.328  10.241  1.00 30.73           C  
ATOM    144  CE1 TYR A  16      12.037 -10.709  12.145  1.00 32.53           C  
ATOM    145  CE2 TYR A  16      11.377 -11.906  10.160  1.00 32.25           C  
ATOM    146  CZ  TYR A  16      12.336 -11.591  11.117  1.00 33.68           C  
ATOM    147  OH  TYR A  16      13.595 -12.149  11.045  1.00 33.53           O  
ATOM    148  N   PHE A  17       6.968  -7.036  11.984  1.00 22.14           N  
ATOM    149  CA  PHE A  17       5.834  -6.119  11.903  1.00 20.16           C  
ATOM    150  C   PHE A  17       5.173  -5.954  10.543  1.00 20.53           C  
ATOM    151  O   PHE A  17       5.809  -6.070   9.496  1.00 20.56           O  
ATOM    152  CB  PHE A  17       6.269  -4.726  12.365  1.00 21.05           C  
ATOM    153  CG  PHE A  17       6.812  -4.681  13.759  1.00 22.75           C  
ATOM    154  CD1 PHE A  17       5.961  -4.517  14.848  1.00 23.48           C  
ATOM    155  CD2 PHE A  17       8.184  -4.787  13.987  1.00 24.09           C  
ATOM    156  CE1 PHE A  17       6.467  -4.455  16.150  1.00 24.97           C  
ATOM    157  CE2 PHE A  17       8.701  -4.727  15.282  1.00 25.79           C  
ATOM    158  CZ  PHE A  17       7.839  -4.559  16.367  1.00 25.07           C  
ATOM    159  N   VAL A  18       3.879  -5.661  10.585  1.00 19.63           N  
ATOM    160  CA  VAL A  18       3.099  -5.407   9.389  1.00 20.52           C  
ATOM    161  C   VAL A  18       2.184  -4.247   9.757  1.00 20.10           C  
ATOM    162  O   VAL A  18       1.482  -4.307  10.764  1.00 20.29           O  
ATOM    163  CB  VAL A  18       2.237  -6.617   8.995  1.00 22.80           C  
ATOM    164  CG1 VAL A  18       1.472  -6.310   7.710  1.00 24.49           C  
ATOM    165  CG2 VAL A  18       3.119  -7.848   8.823  1.00 21.91           C  
ATOM    166  N   ALA A  19       2.206  -3.186   8.960  1.00 17.94           N  
ATOM    167  CA  ALA A  19       1.359  -2.036   9.226  1.00 17.57           C  
ATOM    168  C   ALA A  19       0.332  -1.881   8.112  1.00 17.99           C  
ATOM    169  O   ALA A  19       0.607  -2.179   6.947  1.00 20.85           O  
ATOM    170  CB  ALA A  19       2.203  -0.771   9.345  1.00 17.61           C  
ATOM    171  N   HIS A  20      -0.858  -1.425   8.483  1.00 15.48           N  
ATOM    172  CA  HIS A  20      -1.930  -1.217   7.527  1.00 15.21           C  
ATOM    173  C   HIS A  20      -2.470   0.196   7.714  1.00 14.40           C  
ATOM    174  O   HIS A  20      -2.858   0.576   8.821  1.00 12.94           O  
ATOM    175  CB  HIS A  20      -3.049  -2.234   7.779  1.00 14.23           C  
ATOM    176  CG  HIS A  20      -4.197  -2.136   6.822  1.00 14.06           C  
ATOM    177  ND1 HIS A  20      -5.464  -2.579   7.141  1.00 15.59           N  
ATOM    178  CD2 HIS A  20      -4.264  -1.695   5.542  1.00 14.42           C  
ATOM    179  CE1 HIS A  20      -6.262  -2.418   6.099  1.00 14.87           C  
ATOM    180  NE2 HIS A  20      -5.560  -1.886   5.115  1.00 13.22           N  
ATOM    181  N   VAL A  21      -2.459   0.979   6.640  1.00 11.99           N  
ATOM    182  CA  VAL A  21      -2.990   2.333   6.670  1.00 13.97           C  
ATOM    183  C   VAL A  21      -4.188   2.235   5.729  1.00 13.95           C  
ATOM    184  O   VAL A  21      -4.066   2.444   4.517  1.00 13.39           O  
ATOM    185  CB  VAL A  21      -1.967   3.365   6.136  1.00 13.46           C  
ATOM    186  CG1 VAL A  21      -2.564   4.753   6.180  1.00 10.74           C  
ATOM    187  CG2 VAL A  21      -0.684   3.319   6.974  1.00 15.00           C  
ATOM    188  N   PRO A  22      -5.368   1.905   6.279  1.00 14.99           N  
ATOM    189  CA  PRO A  22      -6.587   1.762   5.476  1.00 15.75           C  
ATOM    190  C   PRO A  22      -6.983   2.896   4.532  1.00 16.70           C  
ATOM    191  O   PRO A  22      -7.379   2.640   3.396  1.00 18.42           O  
ATOM    192  CB  PRO A  22      -7.659   1.450   6.521  1.00 15.92           C  
ATOM    193  CG  PRO A  22      -7.122   2.085   7.776  1.00 13.51           C  
ATOM    194  CD  PRO A  22      -5.663   1.745   7.716  1.00 12.74           C  
ATOM    195  N   GLU A  23      -6.881   4.138   4.985  1.00 16.40           N  
ATOM    196  CA  GLU A  23      -7.249   5.262   4.132  1.00 20.15           C  
ATOM    197  C   GLU A  23      -6.366   5.336   2.886  1.00 21.21           C  
ATOM    198  O   GLU A  23      -6.796   5.843   1.844  1.00 21.67           O  
ATOM    199  CB  GLU A  23      -7.167   6.575   4.912  1.00 23.05           C  
ATOM    200  CG  GLU A  23      -7.787   7.760   4.185  1.00 28.77           C  
ATOM    201  CD  GLU A  23      -7.789   9.026   5.020  1.00 32.04           C  
ATOM    202  OE1 GLU A  23      -8.063   8.934   6.237  1.00 31.80           O  
ATOM    203  OE2 GLU A  23      -7.530  10.112   4.456  1.00 33.97           O  
ATOM    204  N   LEU A  24      -5.139   4.830   2.988  1.00 18.86           N  
ATOM    205  CA  LEU A  24      -4.214   4.842   1.856  1.00 19.86           C  
ATOM    206  C   LEU A  24      -4.130   3.492   1.143  1.00 18.73           C  
ATOM    207  O   LEU A  24      -3.288   3.295   0.258  1.00 17.96           O  
ATOM    208  CB  LEU A  24      -2.813   5.269   2.313  1.00 17.45           C  
ATOM    209  CG  LEU A  24      -2.691   6.676   2.903  1.00 20.12           C  
ATOM    210  CD1 LEU A  24      -1.234   6.951   3.283  1.00 19.57           C  
ATOM    211  CD2 LEU A  24      -3.195   7.701   1.895  1.00 21.61           C  
ATOM    212  N   HIS A  25      -4.997   2.562   1.539  1.00 18.94           N  
ATOM    213  CA  HIS A  25      -5.033   1.227   0.937  1.00 21.64           C  
ATOM    214  C   HIS A  25      -3.627   0.644   0.850  1.00 22.90           C  
ATOM    215  O   HIS A  25      -3.288  -0.049  -0.112  1.00 23.32           O  
ATOM    216  CB  HIS A  25      -5.639   1.316  -0.470  1.00 23.58           C  
ATOM    217  CG  HIS A  25      -6.867   2.165  -0.538  1.00 24.68           C  
ATOM    218  ND1 HIS A  25      -8.019   1.866   0.157  1.00 28.01           N  
ATOM    219  CD2 HIS A  25      -7.108   3.332  -1.181  1.00 26.55           C  
ATOM    220  CE1 HIS A  25      -8.916   2.813  -0.052  1.00 28.12           C  
ATOM    221  NE2 HIS A  25      -8.389   3.714  -0.861  1.00 27.62           N  
ATOM    222  N   ALA A  26      -2.806   0.920   1.858  1.00 21.83           N  
ATOM    223  CA  ALA A  26      -1.430   0.445   1.857  1.00 21.80           C  
ATOM    224  C   ALA A  26      -1.045  -0.472   3.004  1.00 20.88           C  
ATOM    225  O   ALA A  26      -1.592  -0.390   4.110  1.00 19.13           O  
ATOM    226  CB  ALA A  26      -0.478   1.640   1.819  1.00 23.09           C  
ATOM    227  N   HIS A  27      -0.086  -1.345   2.717  1.00 21.27           N  
ATOM    228  CA  HIS A  27       0.452  -2.294   3.679  1.00 21.72           C  
ATOM    229  C   HIS A  27       1.970  -2.207   3.587  1.00 22.67           C  
ATOM    230  O   HIS A  27       2.525  -2.106   2.488  1.00 20.54           O  
ATOM    231  CB  HIS A  27       0.013  -3.721   3.335  1.00 25.45           C  
ATOM    232  CG  HIS A  27      -1.415  -4.020   3.672  1.00 26.69           C  
ATOM    233  ND1 HIS A  27      -1.793  -4.599   4.864  1.00 29.61           N  
ATOM    234  CD2 HIS A  27      -2.558  -3.812   2.975  1.00 27.86           C  
ATOM    235  CE1 HIS A  27      -3.106  -4.737   4.887  1.00 28.58           C  
ATOM    236  NE2 HIS A  27      -3.595  -4.267   3.753  1.00 28.56           N  
ATOM    237  N   THR A  28       2.637  -2.216   4.735  1.00 20.89           N  
ATOM    238  CA  THR A  28       4.093  -2.177   4.764  1.00 24.36           C  
ATOM    239  C   THR A  28       4.547  -3.151   5.845  1.00 23.88           C  
ATOM    240  O   THR A  28       3.866  -3.334   6.860  1.00 24.15           O  
ATOM    241  CB  THR A  28       4.640  -0.758   5.082  1.00 25.88           C  
ATOM    242  OG1 THR A  28       4.379  -0.433   6.447  1.00 31.52           O  
ATOM    243  CG2 THR A  28       3.977   0.283   4.202  1.00 27.97           C  
ATOM    244  N   GLN A  29       5.686  -3.791   5.626  1.00 22.23           N  
ATOM    245  CA  GLN A  29       6.208  -4.751   6.585  1.00 22.03           C  
ATOM    246  C   GLN A  29       7.695  -4.528   6.818  1.00 21.26           C  
ATOM    247  O   GLN A  29       8.383  -3.950   5.973  1.00 21.87           O  
ATOM    248  CB  GLN A  29       5.945  -6.176   6.084  1.00 23.70           C  
ATOM    249  CG  GLN A  29       6.504  -6.467   4.691  1.00 24.68           C  
ATOM    250  CD  GLN A  29       5.861  -7.683   4.044  1.00 27.81           C  
ATOM    251  OE1 GLN A  29       4.669  -7.676   3.726  1.00 28.36           O  
ATOM    252  NE2 GLN A  29       6.646  -8.734   3.849  1.00 27.67           N  
ATOM    253  N   ALA A  30       8.181  -4.971   7.975  1.00 21.19           N  
ATOM    254  CA  ALA A  30       9.589  -4.827   8.338  1.00 23.53           C  
ATOM    255  C   ALA A  30       9.918  -5.751   9.500  1.00 24.15           C  
ATOM    256  O   ALA A  30       9.021  -6.223  10.197  1.00 23.56           O  
ATOM    257  CB  ALA A  30       9.886  -3.388   8.720  1.00 23.87           C  
ATOM    258  N   GLN A  31      11.207  -6.001   9.716  1.00 25.76           N  
ATOM    259  CA  GLN A  31      11.634  -6.887  10.794  1.00 26.35           C  
ATOM    260  C   GLN A  31      11.887  -6.175  12.117  1.00 25.79           C  
ATOM    261  O   GLN A  31      12.045  -6.820  13.154  1.00 26.51           O  
ATOM    262  CB  GLN A  31      12.886  -7.658  10.378  1.00 28.94           C  
ATOM    263  CG  GLN A  31      12.658  -8.613   9.210  1.00 32.59           C  
ATOM    264  CD  GLN A  31      13.834  -9.539   8.978  1.00 34.12           C  
ATOM    265  OE1 GLN A  31      14.876  -9.412   9.625  1.00 37.18           O  
ATOM    266  NE2 GLN A  31      13.676 -10.479   8.053  1.00 36.22           N  
ATOM    267  N   SER A  32      11.934  -4.848  12.084  1.00 24.19           N  
ATOM    268  CA  SER A  32      12.147  -4.075  13.300  1.00 23.24           C  
ATOM    269  C   SER A  32      11.215  -2.872  13.312  1.00 22.63           C  
ATOM    270  O   SER A  32      10.667  -2.493  12.279  1.00 22.20           O  
ATOM    271  CB  SER A  32      13.596  -3.599  13.392  1.00 22.74           C  
ATOM    272  OG  SER A  32      13.875  -2.620  12.408  1.00 22.39           O  
ATOM    273  N   PHE A  33      11.034  -2.275  14.483  1.00 23.53           N  
ATOM    274  CA  PHE A  33      10.171  -1.111  14.600  1.00 25.15           C  
ATOM    275  C   PHE A  33      10.783   0.069  13.848  1.00 24.24           C  
ATOM    276  O   PHE A  33      10.073   0.826  13.188  1.00 23.72           O  
ATOM    277  CB  PHE A  33       9.971  -0.753  16.072  1.00 28.69           C  
ATOM    278  CG  PHE A  33       8.664  -0.072  16.357  1.00 32.02           C  
ATOM    279  CD1 PHE A  33       7.472  -0.600  15.866  1.00 32.66           C  
ATOM    280  CD2 PHE A  33       8.616   1.075  17.144  1.00 34.02           C  
ATOM    281  CE1 PHE A  33       6.249  -0.002  16.153  1.00 34.22           C  
ATOM    282  CE2 PHE A  33       7.396   1.681  17.439  1.00 34.78           C  
ATOM    283  CZ  PHE A  33       6.208   1.140  16.941  1.00 35.81           C  
ATOM    284  N   GLU A  34      12.103   0.213  13.932  1.00 23.84           N  
ATOM    285  CA  GLU A  34      12.796   1.310  13.255  1.00 22.83           C  
ATOM    286  C   GLU A  34      12.587   1.216  11.744  1.00 21.37           C  
ATOM    287  O   GLU A  34      12.307   2.220  11.078  1.00 19.89           O  
ATOM    288  CB  GLU A  34      14.296   1.265  13.563  1.00 24.31           C  
ATOM    289  CG  GLU A  34      15.069   2.490  13.096  1.00 28.17           C  
ATOM    290  CD  GLU A  34      14.663   3.762  13.828  1.00 29.87           C  
ATOM    291  OE1 GLU A  34      14.717   3.777  15.079  1.00 29.98           O  
ATOM    292  OE2 GLU A  34      14.295   4.751  13.154  1.00 33.42           O  
ATOM    293  N   GLU A  35      12.725   0.007  11.213  1.00 20.63           N  
ATOM    294  CA  GLU A  35      12.557  -0.239   9.787  1.00 22.59           C  
ATOM    295  C   GLU A  35      11.114   0.016   9.370  1.00 20.14           C  
ATOM    296  O   GLU A  35      10.859   0.567   8.297  1.00 18.90           O  
ATOM    297  CB  GLU A  35      12.929  -1.685   9.456  1.00 25.20           C  
ATOM    298  CG  GLU A  35      12.980  -1.992   7.974  1.00 30.05           C  
ATOM    299  CD  GLU A  35      12.964  -3.483   7.690  1.00 34.16           C  
ATOM    300  OE1 GLU A  35      13.606  -4.246   8.447  1.00 36.14           O  
ATOM    301  OE2 GLU A  35      12.318  -3.893   6.703  1.00 36.53           O  
ATOM    302  N   LEU A  36      10.170  -0.387  10.220  1.00 19.12           N  
ATOM    303  CA  LEU A  36       8.757  -0.197   9.915  1.00 19.03           C  
ATOM    304  C   LEU A  36       8.448   1.282   9.741  1.00 17.80           C  
ATOM    305  O   LEU A  36       7.832   1.674   8.751  1.00 18.28           O  
ATOM    306  CB  LEU A  36       7.873  -0.786  11.023  1.00 19.24           C  
ATOM    307  CG  LEU A  36       6.365  -0.780  10.729  1.00 20.11           C  
ATOM    308  CD1 LEU A  36       6.059  -1.754   9.594  1.00 20.94           C  
ATOM    309  CD2 LEU A  36       5.592  -1.162  11.982  1.00 21.80           C  
ATOM    310  N   LEU A  37       8.879   2.102  10.698  1.00 18.83           N  
ATOM    311  CA  LEU A  37       8.646   3.540  10.627  1.00 19.42           C  
ATOM    312  C   LEU A  37       9.219   4.110   9.333  1.00 19.02           C  
ATOM    313  O   LEU A  37       8.554   4.879   8.642  1.00 17.34           O  
ATOM    314  CB  LEU A  37       9.286   4.256  11.820  1.00 21.20           C  
ATOM    315  CG  LEU A  37       9.156   5.787  11.843  1.00 23.96           C  
ATOM    316  CD1 LEU A  37       7.683   6.160  11.928  1.00 26.20           C  
ATOM    317  CD2 LEU A  37       9.923   6.371  13.023  1.00 26.27           C  
ATOM    318  N   ARG A  38      10.448   3.722   9.000  1.00 18.94           N  
ATOM    319  CA  ARG A  38      11.090   4.229   7.787  1.00 20.13           C  
ATOM    320  C   ARG A  38      10.325   3.869   6.520  1.00 21.28           C  
ATOM    321  O   ARG A  38      10.111   4.725   5.657  1.00 22.93           O  
ATOM    322  CB  ARG A  38      12.533   3.722   7.676  1.00 23.59           C  
ATOM    323  CG  ARG A  38      13.262   4.212   6.421  1.00 28.85           C  
ATOM    324  CD  ARG A  38      14.702   3.723   6.371  1.00 30.08           C  
ATOM    325  NE  ARG A  38      14.801   2.267   6.286  1.00 34.22           N  
ATOM    326  CZ  ARG A  38      14.477   1.552   5.213  1.00 35.80           C  
ATOM    327  NH1 ARG A  38      14.026   2.154   4.118  1.00 36.46           N  
ATOM    328  NH2 ARG A  38      14.611   0.233   5.229  1.00 38.47           N  
ATOM    329  N   ARG A  39       9.911   2.611   6.401  1.00 19.06           N  
ATOM    330  CA  ARG A  39       9.176   2.181   5.220  1.00 21.29           C  
ATOM    331  C   ARG A  39       7.776   2.781   5.189  1.00 20.42           C  
ATOM    332  O   ARG A  39       7.247   3.097   4.122  1.00 20.05           O  
ATOM    333  CB  ARG A  39       9.112   0.655   5.166  1.00 21.82           C  
ATOM    334  CG  ARG A  39      10.464   0.037   4.857  1.00 23.56           C  
ATOM    335  CD  ARG A  39      10.397  -1.460   4.704  1.00 26.89           C  
ATOM    336  NE  ARG A  39      11.711  -2.014   4.386  1.00 29.00           N  
ATOM    337  CZ  ARG A  39      12.383  -1.757   3.267  1.00 32.02           C  
ATOM    338  NH1 ARG A  39      11.868  -0.952   2.347  1.00 32.83           N  
ATOM    339  NH2 ARG A  39      13.580  -2.299   3.072  1.00 32.82           N  
ATOM    340  N   LEU A  40       7.187   2.946   6.366  1.00 20.59           N  
ATOM    341  CA  LEU A  40       5.854   3.522   6.477  1.00 20.80           C  
ATOM    342  C   LEU A  40       5.892   4.964   5.953  1.00 20.36           C  
ATOM    343  O   LEU A  40       5.036   5.375   5.168  1.00 18.42           O  
ATOM    344  CB  LEU A  40       5.413   3.491   7.943  1.00 21.78           C  
ATOM    345  CG  LEU A  40       3.925   3.583   8.286  1.00 25.49           C  
ATOM    346  CD1 LEU A  40       3.127   2.546   7.505  1.00 24.86           C  
ATOM    347  CD2 LEU A  40       3.755   3.360   9.793  1.00 24.91           C  
ATOM    348  N   GLN A  41       6.892   5.723   6.389  1.00 20.17           N  
ATOM    349  CA  GLN A  41       7.045   7.106   5.953  1.00 22.08           C  
ATOM    350  C   GLN A  41       7.294   7.157   4.447  1.00 22.28           C  
ATOM    351  O   GLN A  41       6.705   7.979   3.743  1.00 21.04           O  
ATOM    352  CB  GLN A  41       8.194   7.780   6.712  1.00 21.89           C  
ATOM    353  CG  GLN A  41       7.836   8.120   8.161  1.00 24.22           C  
ATOM    354  CD  GLN A  41       9.000   8.672   8.969  1.00 25.20           C  
ATOM    355  OE1 GLN A  41       8.817   9.118  10.102  1.00 26.18           O  
ATOM    356  NE2 GLN A  41      10.197   8.643   8.395  1.00 25.58           N  
ATOM    357  N   GLU A  42       8.156   6.273   3.949  1.00 21.64           N  
ATOM    358  CA  GLU A  42       8.446   6.245   2.517  1.00 23.16           C  
ATOM    359  C   GLU A  42       7.191   5.881   1.724  1.00 20.75           C  
ATOM    360  O   GLU A  42       6.914   6.480   0.691  1.00 21.72           O  
ATOM    361  CB  GLU A  42       9.567   5.244   2.213  1.00 25.65           C  
ATOM    362  CG  GLU A  42      10.830   5.487   3.023  1.00 32.62           C  
ATOM    363  CD  GLU A  42      11.970   4.558   2.645  1.00 35.54           C  
ATOM    364  OE1 GLU A  42      11.707   3.369   2.356  1.00 39.45           O  
ATOM    365  OE2 GLU A  42      13.131   5.020   2.653  1.00 38.25           O  
ATOM    366  N   ALA A  43       6.428   4.907   2.217  1.00 19.75           N  
ATOM    367  CA  ALA A  43       5.210   4.483   1.543  1.00 18.48           C  
ATOM    368  C   ALA A  43       4.142   5.576   1.530  1.00 18.00           C  
ATOM    369  O   ALA A  43       3.466   5.767   0.526  1.00 17.31           O  
ATOM    370  CB  ALA A  43       4.657   3.218   2.195  1.00 19.83           C  
ATOM    371  N   ILE A  44       3.986   6.291   2.641  1.00 16.64           N  
ATOM    372  CA  ILE A  44       2.985   7.359   2.693  1.00 16.14           C  
ATOM    373  C   ILE A  44       3.375   8.482   1.738  1.00 15.41           C  
ATOM    374  O   ILE A  44       2.518   9.046   1.058  1.00 16.62           O  
ATOM    375  CB  ILE A  44       2.827   7.908   4.125  1.00 15.70           C  
ATOM    376  CG1 ILE A  44       2.221   6.818   5.016  1.00 14.03           C  
ATOM    377  CG2 ILE A  44       1.926   9.150   4.126  1.00 15.29           C  
ATOM    378  CD1 ILE A  44       2.243   7.140   6.508  1.00 17.83           C  
ATOM    379  N   ALA A  45       4.667   8.790   1.682  1.00 15.63           N  
ATOM    380  CA  ALA A  45       5.163   9.833   0.789  1.00 16.36           C  
ATOM    381  C   ALA A  45       4.803   9.475  -0.651  1.00 16.89           C  
ATOM    382  O   ALA A  45       4.280  10.309  -1.396  1.00 15.98           O  
ATOM    383  CB  ALA A  45       6.677   9.984   0.936  1.00 16.11           C  
ATOM    384  N   VAL A  46       5.071   8.234  -1.049  1.00 15.90           N  
ATOM    385  CA  VAL A  46       4.743   7.822  -2.409  1.00 17.14           C  
ATOM    386  C   VAL A  46       3.240   7.918  -2.677  1.00 15.61           C  
ATOM    387  O   VAL A  46       2.830   8.395  -3.732  1.00 16.62           O  
ATOM    388  CB  VAL A  46       5.228   6.381  -2.710  1.00 16.54           C  
ATOM    389  CG1 VAL A  46       4.728   5.946  -4.077  1.00 19.80           C  
ATOM    390  CG2 VAL A  46       6.745   6.332  -2.680  1.00 20.11           C  
ATOM    391  N   SER A  47       2.419   7.477  -1.725  1.00 15.46           N  
ATOM    392  CA  SER A  47       0.967   7.546  -1.881  1.00 16.88           C  
ATOM    393  C   SER A  47       0.523   8.976  -2.171  1.00 17.17           C  
ATOM    394  O   SER A  47      -0.309   9.216  -3.046  1.00 18.04           O  
ATOM    395  CB  SER A  47       0.252   7.070  -0.611  1.00 16.74           C  
ATOM    396  OG  SER A  47       0.559   5.723  -0.314  1.00 22.72           O  
ATOM    397  N   LEU A  48       1.085   9.920  -1.424  1.00 16.24           N  
ATOM    398  CA  LEU A  48       0.753  11.336  -1.566  1.00 16.47           C  
ATOM    399  C   LEU A  48       1.497  12.029  -2.713  1.00 17.69           C  
ATOM    400  O   LEU A  48       1.284  13.215  -2.965  1.00 15.86           O  
ATOM    401  CB  LEU A  48       1.070  12.072  -0.262  1.00 16.16           C  
ATOM    402  CG  LEU A  48       0.362  11.622   1.025  1.00 14.70           C  
ATOM    403  CD1 LEU A  48       0.995  12.307   2.219  1.00 15.62           C  
ATOM    404  CD2 LEU A  48      -1.104  11.930   0.945  1.00 16.31           C  
ATOM    405  N   GLU A  49       2.354  11.280  -3.407  1.00 17.58           N  
ATOM    406  CA  GLU A  49       3.169  11.813  -4.499  1.00 17.10           C  
ATOM    407  C   GLU A  49       4.030  12.973  -3.994  1.00 18.60           C  
ATOM    408  O   GLU A  49       4.228  13.985  -4.672  1.00 19.53           O  
ATOM    409  CB  GLU A  49       2.285  12.235  -5.683  1.00 15.64           C  
ATOM    410  CG  GLU A  49       1.328  11.120  -6.121  1.00 17.43           C  
ATOM    411  CD  GLU A  49       0.700  11.335  -7.490  1.00 19.99           C  
ATOM    412  OE1 GLU A  49       0.609  12.498  -7.938  1.00 19.69           O  
ATOM    413  OE2 GLU A  49       0.282  10.330  -8.113  1.00 20.61           O  
ATOM    414  N   GLU A  50       4.550  12.794  -2.782  1.00 17.06           N  
ATOM    415  CA  GLU A  50       5.416  13.764  -2.120  1.00 17.71           C  
ATOM    416  C   GLU A  50       6.834  13.196  -2.071  1.00 18.37           C  
ATOM    417  O   GLU A  50       7.019  11.984  -2.153  1.00 20.78           O  
ATOM    418  CB  GLU A  50       4.925  14.007  -0.691  1.00 17.69           C  
ATOM    419  CG  GLU A  50       3.617  14.752  -0.621  1.00 16.61           C  
ATOM    420  CD  GLU A  50       3.806  16.235  -0.825  1.00 13.73           C  
ATOM    421  OE1 GLU A  50       4.197  16.920   0.143  1.00 14.29           O  
ATOM    422  OE2 GLU A  50       3.583  16.712  -1.952  1.00 16.00           O  
ATOM    423  N   GLU A  51       7.829  14.063  -1.923  1.00 20.07           N  
ATOM    424  CA  GLU A  51       9.216  13.610  -1.859  1.00 23.59           C  
ATOM    425  C   GLU A  51       9.527  12.858  -0.573  1.00 23.12           C  
ATOM    426  O   GLU A  51      10.186  11.819  -0.595  1.00 23.96           O  
ATOM    427  CB  GLU A  51      10.164  14.796  -2.012  1.00 26.69           C  
ATOM    428  CG  GLU A  51      10.197  15.308  -3.431  1.00 33.03           C  
ATOM    429  CD  GLU A  51      10.474  14.192  -4.419  1.00 37.03           C  
ATOM    430  OE1 GLU A  51      11.631  13.720  -4.479  1.00 38.25           O  
ATOM    431  OE2 GLU A  51       9.531  13.776  -5.125  1.00 40.30           O  
ATOM    432  N   ARG A  52       9.054  13.386   0.547  1.00 22.34           N  
ATOM    433  CA  ARG A  52       9.283  12.740   1.830  1.00 21.71           C  
ATOM    434  C   ARG A  52       8.118  12.956   2.790  1.00 19.83           C  
ATOM    435  O   ARG A  52       7.341  13.894   2.638  1.00 19.07           O  
ATOM    436  CB  ARG A  52      10.572  13.262   2.461  1.00 23.19           C  
ATOM    437  CG  ARG A  52      10.590  14.753   2.706  1.00 28.41           C  
ATOM    438  CD  ARG A  52      11.809  15.146   3.523  1.00 32.97           C  
ATOM    439  NE  ARG A  52      11.883  16.591   3.714  1.00 36.87           N  
ATOM    440  CZ  ARG A  52      12.130  17.457   2.737  1.00 37.96           C  
ATOM    441  NH1 ARG A  52      12.332  17.021   1.500  1.00 39.22           N  
ATOM    442  NH2 ARG A  52      12.167  18.758   2.997  1.00 38.69           N  
ATOM    443  N   ALA A  53       7.996  12.065   3.769  1.00 17.32           N  
ATOM    444  CA  ALA A  53       6.946  12.158   4.774  1.00 17.29           C  
ATOM    445  C   ALA A  53       7.581  11.787   6.106  1.00 16.77           C  
ATOM    446  O   ALA A  53       8.499  10.976   6.153  1.00 18.25           O  
ATOM    447  CB  ALA A  53       5.808  11.200   4.451  1.00 16.05           C  
ATOM    448  N   GLU A  54       7.104  12.403   7.178  1.00 17.32           N  
ATOM    449  CA  GLU A  54       7.633  12.129   8.502  1.00 19.83           C  
ATOM    450  C   GLU A  54       6.514  11.962   9.500  1.00 16.59           C  
ATOM    451  O   GLU A  54       5.553  12.725   9.507  1.00 18.93           O  
ATOM    452  CB  GLU A  54       8.549  13.264   8.970  1.00 22.92           C  
ATOM    453  CG  GLU A  54      10.038  12.953   8.884  1.00 32.66           C  
ATOM    454  CD  GLU A  54      10.548  12.860   7.458  1.00 35.18           C  
ATOM    455  OE1 GLU A  54      10.622  13.910   6.777  1.00 40.02           O  
ATOM    456  OE2 GLU A  54      10.876  11.736   7.018  1.00 38.15           O  
ATOM    457  N   VAL A  55       6.632  10.941  10.334  1.00 17.46           N  
ATOM    458  CA  VAL A  55       5.643  10.707  11.367  1.00 16.20           C  
ATOM    459  C   VAL A  55       6.016  11.657  12.501  1.00 16.14           C  
ATOM    460  O   VAL A  55       7.075  11.507  13.098  1.00 18.73           O  
ATOM    461  CB  VAL A  55       5.707   9.244  11.853  1.00 17.19           C  
ATOM    462  CG1 VAL A  55       4.820   9.044  13.076  1.00 15.92           C  
ATOM    463  CG2 VAL A  55       5.264   8.323  10.725  1.00 17.40           C  
ATOM    464  N   VAL A  56       5.170  12.648  12.772  1.00 16.86           N  
ATOM    465  CA  VAL A  56       5.458  13.599  13.848  1.00 18.37           C  
ATOM    466  C   VAL A  56       4.678  13.260  15.111  1.00 19.19           C  
ATOM    467  O   VAL A  56       4.857  13.885  16.161  1.00 18.54           O  
ATOM    468  CB  VAL A  56       5.139  15.055  13.440  1.00 18.52           C  
ATOM    469  CG1 VAL A  56       6.082  15.497  12.334  1.00 18.87           C  
ATOM    470  CG2 VAL A  56       3.684  15.182  13.007  1.00 19.68           C  
ATOM    471  N   GLY A  57       3.805  12.267  15.011  1.00 18.46           N  
ATOM    472  CA  GLY A  57       3.042  11.882  16.178  1.00 18.14           C  
ATOM    473  C   GLY A  57       2.118  10.710  15.948  1.00 17.84           C  
ATOM    474  O   GLY A  57       1.884  10.290  14.817  1.00 16.52           O  
ATOM    475  N   LEU A  58       1.625  10.153  17.043  1.00 18.07           N  
ATOM    476  CA  LEU A  58       0.691   9.053  16.973  1.00 19.59           C  
ATOM    477  C   LEU A  58      -0.049   8.928  18.293  1.00 21.82           C  
ATOM    478  O   LEU A  58       0.560   8.956  19.362  1.00 19.84           O  
ATOM    479  CB  LEU A  58       1.405   7.742  16.611  1.00 22.69           C  
ATOM    480  CG  LEU A  58       2.638   7.234  17.348  1.00 24.86           C  
ATOM    481  CD1 LEU A  58       2.921   5.804  16.905  1.00 28.71           C  
ATOM    482  CD2 LEU A  58       3.836   8.125  17.052  1.00 30.20           C  
ATOM    483  N   GLU A  59      -1.373   8.849  18.199  1.00 22.71           N  
ATOM    484  CA  GLU A  59      -2.242   8.702  19.358  1.00 23.08           C  
ATOM    485  C   GLU A  59      -2.995   7.396  19.149  1.00 23.62           C  
ATOM    486  O   GLU A  59      -3.667   7.227  18.134  1.00 22.36           O  
ATOM    487  CB  GLU A  59      -3.268   9.840  19.436  1.00 26.87           C  
ATOM    488  CG  GLU A  59      -2.697  11.245  19.567  1.00 30.16           C  
ATOM    489  CD  GLU A  59      -2.133  11.779  18.268  1.00 32.94           C  
ATOM    490  OE1 GLU A  59      -2.813  11.632  17.228  1.00 32.25           O  
ATOM    491  OE2 GLU A  59      -1.021  12.356  18.289  1.00 32.76           O  
ATOM    492  N   GLY A  60      -2.889   6.471  20.096  1.00 21.90           N  
ATOM    493  CA  GLY A  60      -3.604   5.219  19.934  1.00 21.51           C  
ATOM    494  C   GLY A  60      -3.543   4.328  21.150  1.00 21.82           C  
ATOM    495  O   GLY A  60      -3.392   4.800  22.282  1.00 21.04           O  
ATOM    496  N   ALA A  61      -3.670   3.030  20.908  1.00 20.33           N  
ATOM    497  CA  ALA A  61      -3.636   2.040  21.975  1.00 20.61           C  
ATOM    498  C   ALA A  61      -2.557   1.001  21.697  1.00 21.42           C  
ATOM    499  O   ALA A  61      -2.438   0.501  20.575  1.00 22.05           O  
ATOM    500  CB  ALA A  61      -4.989   1.365  22.096  1.00 21.03           C  
ATOM    501  N   LEU A  62      -1.773   0.694  22.727  1.00 17.72           N  
ATOM    502  CA  LEU A  62      -0.697  -0.285  22.642  1.00 18.14           C  
ATOM    503  C   LEU A  62      -1.209  -1.595  23.221  1.00 17.77           C  
ATOM    504  O   LEU A  62      -1.836  -1.595  24.277  1.00 16.76           O  
ATOM    505  CB  LEU A  62       0.509   0.151  23.485  1.00 19.21           C  
ATOM    506  CG  LEU A  62       1.470   1.246  23.033  1.00 22.11           C  
ATOM    507  CD1 LEU A  62       2.525   1.455  24.112  1.00 23.55           C  
ATOM    508  CD2 LEU A  62       2.117   0.852  21.709  1.00 22.99           C  
ATOM    509  N   GLU A  63      -0.952  -2.697  22.522  1.00 16.99           N  
ATOM    510  CA  GLU A  63      -1.334  -4.028  22.992  1.00 17.38           C  
ATOM    511  C   GLU A  63      -0.052  -4.573  23.592  1.00 16.24           C  
ATOM    512  O   GLU A  63       0.976  -4.636  22.911  1.00 15.07           O  
ATOM    513  CB  GLU A  63      -1.760  -4.936  21.832  1.00 19.46           C  
ATOM    514  CG  GLU A  63      -2.846  -4.376  20.941  1.00 26.45           C  
ATOM    515  CD  GLU A  63      -4.038  -3.887  21.719  1.00 28.10           C  
ATOM    516  OE1 GLU A  63      -4.437  -4.568  22.684  1.00 31.51           O  
ATOM    517  OE2 GLU A  63      -4.581  -2.821  21.359  1.00 31.18           O  
ATOM    518  N   ILE A  64      -0.116  -4.979  24.856  1.00 15.01           N  
ATOM    519  CA  ILE A  64       1.060  -5.470  25.553  1.00 15.32           C  
ATOM    520  C   ILE A  64       0.967  -6.919  26.005  1.00 14.31           C  
ATOM    521  O   ILE A  64      -0.079  -7.374  26.467  1.00 16.99           O  
ATOM    522  CB  ILE A  64       1.338  -4.613  26.824  1.00 16.57           C  
ATOM    523  CG1 ILE A  64       1.622  -3.159  26.436  1.00 16.51           C  
ATOM    524  CG2 ILE A  64       2.475  -5.222  27.630  1.00 20.09           C  
ATOM    525  CD1 ILE A  64       2.929  -2.940  25.727  1.00 17.15           C  
ATOM    526  N   GLU A  65       2.085  -7.621  25.873  1.00 15.48           N  
ATOM    527  CA  GLU A  65       2.215  -9.004  26.316  1.00 18.43           C  
ATOM    528  C   GLU A  65       3.347  -8.982  27.341  1.00 15.95           C  
ATOM    529  O   GLU A  65       4.485  -8.656  27.003  1.00 17.05           O  
ATOM    530  CB  GLU A  65       2.589  -9.913  25.142  1.00 22.21           C  
ATOM    531  CG  GLU A  65       1.540 -10.955  24.842  1.00 29.76           C  
ATOM    532  CD  GLU A  65       1.304 -11.890  26.010  1.00 33.44           C  
ATOM    533  OE1 GLU A  65       0.320 -12.661  25.972  1.00 36.05           O  
ATOM    534  OE2 GLU A  65       2.105 -11.859  26.967  1.00 36.55           O  
ATOM    535  N   ALA A  66       3.038  -9.299  28.596  1.00 17.21           N  
ATOM    536  CA  ALA A  66       4.061  -9.280  29.639  1.00 16.12           C  
ATOM    537  C   ALA A  66       4.189 -10.616  30.352  1.00 18.39           C  
ATOM    538  O   ALA A  66       3.229 -11.383  30.434  1.00 16.29           O  
ATOM    539  CB  ALA A  66       3.759  -8.185  30.657  1.00 14.57           C  
ATOM    540  N   ALA A  67       5.387 -10.874  30.871  1.00 17.95           N  
ATOM    541  CA  ALA A  67       5.673 -12.106  31.591  1.00 18.68           C  
ATOM    542  C   ALA A  67       6.547 -11.792  32.806  1.00 20.14           C  
ATOM    543  O   ALA A  67       7.183 -10.711  32.821  1.00 19.36           O  
ATOM    544  CB  ALA A  67       6.379 -13.088  30.669  1.00 19.67           C  
ATOM    545  OXT ALA A  67       6.592 -12.631  33.730  1.00 20.37           O  
TER     546      ALA A  67                                                      
END
MOLECULE T0472_52_101.pdb
ATOM    761  N   ILE    52      -2.934  12.060   6.624  1.00 63.31           N  
ATOM    762  CA  ILE    52      -3.784  11.757   7.784  1.00 50.41           C  
ATOM    763  C   ILE    52      -3.355  10.443   8.462  1.00 25.20           C  
ATOM    764  O   ILE    52      -3.842   9.360   8.129  1.00 63.43           O  
ATOM    765  CB  ILE    52      -5.278  11.668   7.377  1.00 40.10           C  
ATOM    766  CG1 ILE    52      -5.698  12.940   6.620  1.00  0.32           C  
ATOM    767  CG2 ILE    52      -6.164  11.454   8.609  1.00 13.31           C  
ATOM    768  CD1 ILE    52      -7.110  12.896   6.077  1.00 14.20           C  
ATOM    769  H   ILE    52      -3.093  11.580   5.783  1.00 37.41           H  
ATOM    770  HA  ILE    52      -3.676  12.566   8.495  1.00 14.31           H  
ATOM    771  HB  ILE    52      -5.400  10.815   6.724  1.00 21.03           H  
ATOM    772 HG12 ILE    52      -5.629  13.789   7.286  1.00 37.41           H  
ATOM    773 HG13 ILE    52      -5.028  13.093   5.785  1.00 37.41           H  
ATOM    774 HG21 ILE    52      -7.198  11.378   8.302  1.00 37.41           H  
ATOM    775 HG22 ILE    52      -6.052  12.289   9.286  1.00 37.41           H  
ATOM    776 HG23 ILE    52      -5.871  10.544   9.112  1.00 37.41           H  
ATOM    777 HD11 ILE    52      -7.214  12.053   5.411  1.00 37.41           H  
ATOM    778 HD12 ILE    52      -7.315  13.809   5.536  1.00 37.41           H  
ATOM    779 HD13 ILE    52      -7.809  12.800   6.895  1.00 37.41           H  
ATOM    780  N   GLU    53      -2.443  10.555   9.420  1.00 72.33           N  
ATOM    781  CA  GLU    53      -1.867   9.387  10.096  1.00 21.33           C  
ATOM    782  C   GLU    53      -2.934   8.548  10.821  1.00 13.30           C  
ATOM    783  O   GLU    53      -2.792   7.338  10.955  1.00 61.14           O  
ATOM    784  CB  GLU    53      -0.784   9.844  11.084  1.00 51.10           C  
ATOM    785  CG  GLU    53       0.329  10.658  10.428  1.00 41.41           C  
ATOM    786  CD  GLU    53       1.350  11.177  11.426  1.00 31.52           C  
ATOM    787  OE1 GLU    53       1.045  12.161  12.134  1.00  0.22           O  
ATOM    788  OE2 GLU    53       2.465  10.618  11.496  1.00  0.21           O  
ATOM    789  H   GLU    53      -2.141  11.450   9.680  1.00 37.41           H  
ATOM    790  HA  GLU    53      -1.404   8.769   9.339  1.00 44.53           H  
ATOM    791  HB2 GLU    53      -1.244  10.453  11.851  1.00 37.41           H  
ATOM    792  HB3 GLU    53      -0.341   8.974  11.544  1.00 37.41           H  
ATOM    793  HG2 GLU    53       0.836  10.035   9.706  1.00 37.41           H  
ATOM    794  HG3 GLU    53      -0.114  11.504   9.916  1.00 37.41           H  
ATOM    795  N   ALA    54      -4.022   9.183  11.247  1.00 24.34           N  
ATOM    796  CA  ALA    54      -5.102   8.486  11.969  1.00 14.52           C  
ATOM    797  C   ALA    54      -5.685   7.291  11.178  1.00 12.03           C  
ATOM    798  O   ALA    54      -6.469   6.504  11.715  1.00  2.10           O  
ATOM    799  CB  ALA    54      -6.208   9.475  12.319  1.00 10.14           C  
ATOM    800  H   ALA    54      -4.106  10.145  11.077  1.00 37.41           H  
ATOM    801  HA  ALA    54      -4.687   8.113  12.895  1.00 21.34           H  
ATOM    802  HB1 ALA    54      -6.973   8.974  12.895  1.00 37.41           H  
ATOM    803  HB2 ALA    54      -6.642   9.870  11.411  1.00 37.41           H  
ATOM    804  HB3 ALA    54      -5.795  10.285  12.902  1.00 37.41           H  
ATOM    805  N   ARG    55      -5.296   7.162   9.909  1.00 23.25           N  
ATOM    806  CA  ARG    55      -5.814   6.110   9.026  1.00  2.54           C  
ATOM    807  C   ARG    55      -4.950   4.826   9.031  1.00 53.14           C  
ATOM    808  O   ARG    55      -5.335   3.821   8.422  1.00  4.12           O  
ATOM    809  CB  ARG    55      -5.915   6.660   7.594  1.00  4.02           C  
ATOM    810  CG  ARG    55      -6.858   7.855   7.453  1.00 31.02           C  
ATOM    811  CD  ARG    55      -8.317   7.454   7.646  1.00 42.40           C  
ATOM    812  NE  ARG    55      -9.220   8.609   7.648  1.00 62.02           N  
ATOM    813  CZ  ARG    55      -9.855   9.054   6.595  1.00 64.32           C  
ATOM    814  NH1 ARG    55      -9.613   8.568   5.418  1.00 51.52           N  
ATOM    815  NH2 ARG    55     -10.707  10.018   6.710  1.00  4.11           N  
ATOM    816  H   ARG    55      -4.647   7.803   9.547  1.00 37.41           H  
ATOM    817  HA  ARG    55      -6.806   5.852   9.367  1.00 22.42           H  
ATOM    818  HB2 ARG    55      -4.931   6.969   7.270  1.00 37.41           H  
ATOM    819  HB3 ARG    55      -6.266   5.872   6.942  1.00 37.41           H  
ATOM    820  HG2 ARG    55      -6.597   8.596   8.194  1.00 37.41           H  
ATOM    821  HG3 ARG    55      -6.738   8.278   6.465  1.00 37.41           H  
ATOM    822  HD2 ARG    55      -8.603   6.785   6.846  1.00 37.41           H  
ATOM    823  HD3 ARG    55      -8.412   6.937   8.591  1.00 37.41           H  
ATOM    824  HE  ARG    55      -9.383   9.052   8.504  1.00 72.15           H  
ATOM    825 HH11 ARG    55      -8.932   7.849   5.304  1.00 37.41           H  
ATOM    826 HH12 ARG    55     -10.090   8.937   4.622  1.00 37.41           H  
ATOM    827 HH21 ARG    55     -10.872  10.437   7.602  1.00 37.41           H  
ATOM    828 HH22 ARG    55     -11.209  10.336   5.909  1.00 37.41           H  
ATOM    829  N   TYR    56      -3.797   4.843   9.711  1.00 35.41           N  
ATOM    830  CA  TYR    56      -2.880   3.687   9.684  1.00 62.05           C  
ATOM    831  C   TYR    56      -3.367   2.524  10.568  1.00 22.13           C  
ATOM    832  O   TYR    56      -4.337   2.646  11.320  1.00  5.52           O  
ATOM    833  CB  TYR    56      -1.437   4.088  10.092  1.00 63.32           C  
ATOM    834  CG  TYR    56      -1.219   4.439  11.573  1.00 62.22           C  
ATOM    835  CD1 TYR    56      -1.370   3.484  12.580  1.00 51.22           C  
ATOM    836  CD2 TYR    56      -0.851   5.723  11.957  1.00 14.01           C  
ATOM    837  CE1 TYR    56      -1.166   3.802  13.910  1.00 53.41           C  
ATOM    838  CE2 TYR    56      -0.643   6.048  13.285  1.00 42.30           C  
ATOM    839  CZ  TYR    56      -0.806   5.085  14.258  1.00  0.02           C  
ATOM    840  OH  TYR    56      -0.602   5.404  15.582  1.00  0.11           O  
ATOM    841  H   TYR    56      -3.558   5.637  10.234  1.00 37.41           H  
ATOM    842  HA  TYR    56      -2.854   3.333   8.662  1.00  0.43           H  
ATOM    843  HB2 TYR    56      -0.772   3.270   9.857  1.00 37.41           H  
ATOM    844  HB3 TYR    56      -1.144   4.949   9.504  1.00 37.41           H  
ATOM    845  HD1 TYR    56      -1.650   2.476  12.309  1.00 50.32           H  
ATOM    846  HD2 TYR    56      -0.728   6.479  11.196  1.00 34.13           H  
ATOM    847  HE1 TYR    56      -1.292   3.045  14.671  1.00 51.01           H  
ATOM    848  HE2 TYR    56      -0.357   7.055  13.556  1.00 22.30           H  
ATOM    849  HH  TYR    56      -1.043   6.241  15.780  1.00 14.22           H  
ATOM    850  N   ALA    57      -2.675   1.391  10.455  1.00 63.32           N  
ATOM    851  CA  ALA    57      -2.859   0.254  11.362  1.00 25.11           C  
ATOM    852  C   ALA    57      -1.529  -0.491  11.565  1.00 35.11           C  
ATOM    853  O   ALA    57      -1.122  -1.294  10.727  1.00 54.01           O  
ATOM    854  CB  ALA    57      -3.927  -0.689  10.819  1.00 23.24           C  
ATOM    855  H   ALA    57      -2.032   1.307   9.719  1.00 37.41           H  
ATOM    856  HA  ALA    57      -3.197   0.636  12.317  1.00 52.10           H  
ATOM    857  HB1 ALA    57      -3.598  -1.103   9.877  1.00 37.41           H  
ATOM    858  HB2 ALA    57      -4.848  -0.143  10.669  1.00 37.41           H  
ATOM    859  HB3 ALA    57      -4.096  -1.490  11.523  1.00 37.41           H  
ATOM    860  N   LYS    58      -0.855  -0.228  12.680  1.00 61.02           N  
ATOM    861  CA  LYS    58       0.480  -0.794  12.932  1.00 63.12           C  
ATOM    862  C   LYS    58       0.402  -2.075  13.776  1.00 14.20           C  
ATOM    863  O   LYS    58      -0.132  -2.075  14.888  1.00 64.40           O  
ATOM    864  CB  LYS    58       1.371   0.253  13.618  1.00 42.34           C  
ATOM    865  CG  LYS    58       1.675   1.467  12.739  1.00 42.51           C  
ATOM    866  CD  LYS    58       2.283   2.619  13.539  1.00 64.53           C  
ATOM    867  CE  LYS    58       3.613   2.243  14.180  1.00 34.10           C  
ATOM    868  NZ  LYS    58       4.138   3.339  15.033  1.00 51.24           N  
ATOM    869  H   LYS    58      -1.264   0.352  13.358  1.00 37.41           H  
ATOM    870  HA  LYS    58       0.917  -1.043  11.973  1.00  1.11           H  
ATOM    871  HB2 LYS    58       0.875   0.597  14.516  1.00 37.41           H  
ATOM    872  HB3 LYS    58       2.309  -0.210  13.892  1.00 37.41           H  
ATOM    873  HG2 LYS    58       2.374   1.173  11.967  1.00 37.41           H  
ATOM    874  HG3 LYS    58       0.756   1.805  12.279  1.00 37.41           H  
ATOM    875  HD2 LYS    58       2.443   3.457  12.875  1.00 37.41           H  
ATOM    876  HD3 LYS    58       1.589   2.909  14.316  1.00 37.41           H  
ATOM    877  HE2 LYS    58       3.471   1.363  14.790  1.00 37.41           H  
ATOM    878  HE3 LYS    58       4.331   2.030  13.400  1.00 37.41           H  
ATOM    879  HZ1 LYS    58       3.486   3.520  15.827  1.00 37.41           H  
ATOM    880  HZ2 LYS    58       4.241   4.211  14.480  1.00 37.41           H  
ATOM    881  HZ3 LYS    58       5.069   3.079  15.421  1.00 37.41           H  
ATOM    882  N   GLU    59       0.949  -3.169  13.247  1.00 44.24           N  
ATOM    883  CA  GLU    59       0.882  -4.471  13.919  1.00 11.42           C  
ATOM    884  C   GLU    59       2.249  -5.175  13.923  1.00 44.23           C  
ATOM    885  O   GLU    59       3.090  -4.945  13.051  1.00 51.02           O  
ATOM    886  CB  GLU    59      -0.167  -5.358  13.225  1.00 62.32           C  
ATOM    887  CG  GLU    59      -0.394  -6.708  13.903  1.00 71.31           C  
ATOM    888  CD  GLU    59      -0.917  -6.575  15.325  1.00 71.05           C  
ATOM    889  OE1 GLU    59      -2.147  -6.439  15.499  1.00 51.51           O  
ATOM    890  OE2 GLU    59      -0.103  -6.593  16.271  1.00 64.11           O  
ATOM    891  H   GLU    59       1.413  -3.103  12.385  1.00 37.41           H  
ATOM    892  HA  GLU    59       0.577  -4.303  14.942  1.00 22.01           H  
ATOM    893  HB2 GLU    59      -1.109  -4.828  13.205  1.00 37.41           H  
ATOM    894  HB3 GLU    59       0.150  -5.540  12.207  1.00 37.41           H  
ATOM    895  HG2 GLU    59      -1.109  -7.273  13.323  1.00 37.41           H  
ATOM    896  HG3 GLU    59       0.546  -7.245  13.929  1.00 37.41           H  
ATOM    897  N   VAL    60       2.470  -6.027  14.921  1.00 22.32           N  
ATOM    898  CA  VAL    60       3.696  -6.824  15.010  1.00 64.53           C  
ATOM    899  C   VAL    60       3.366  -8.299  15.279  1.00 53.14           C  
ATOM    900  O   VAL    60       2.798  -8.636  16.319  1.00 43.34           O  
ATOM    901  CB  VAL    60       4.643  -6.309  16.126  1.00  2.12           C  
ATOM    902  CG1 VAL    60       5.908  -7.164  16.200  1.00 11.45           C  
ATOM    903  CG2 VAL    60       4.996  -4.836  15.909  1.00 31.41           C  
ATOM    904  H   VAL    60       1.784  -6.130  15.617  1.00 37.41           H  
ATOM    905  HA  VAL    60       4.215  -6.749  14.063  1.00  5.34           H  
ATOM    906  HB  VAL    60       4.126  -6.394  17.073  1.00 53.30           H  
ATOM    907 HG11 VAL    60       5.637  -8.192  16.393  1.00 37.41           H  
ATOM    908 HG12 VAL    60       6.540  -6.805  17.000  1.00 37.41           H  
ATOM    909 HG13 VAL    60       6.444  -7.102  15.264  1.00 37.41           H  
ATOM    910 HG21 VAL    60       5.634  -4.496  16.714  1.00 37.41           H  
ATOM    911 HG22 VAL    60       4.091  -4.247  15.895  1.00 37.41           H  
ATOM    912 HG23 VAL    60       5.515  -4.722  14.968  1.00 37.41           H  
ATOM    913  N   ALA    61       3.723  -9.170  14.340  1.00 74.01           N  
ATOM    914  CA  ALA    61       3.468 -10.608  14.478  1.00 71.43           C  
ATOM    915  C   ALA    61       4.192 -11.201  15.705  1.00 65.35           C  
ATOM    916  O   ALA    61       5.224 -10.684  16.135  1.00 53.45           O  
ATOM    917  CB  ALA    61       3.892 -11.333  13.206  1.00 74.24           C  
ATOM    918  H   ALA    61       4.166  -8.839  13.528  1.00 37.41           H  
ATOM    919  HA  ALA    61       2.402 -10.745  14.602  1.00 31.41           H  
ATOM    920  HB1 ALA    61       3.608 -12.373  13.269  1.00 37.41           H  
ATOM    921  HB2 ALA    61       4.964 -11.260  13.091  1.00 37.41           H  
ATOM    922  HB3 ALA    61       3.409 -10.879  12.353  1.00 37.41           H  
ATOM    923  N   LYS    62       3.656 -12.300  16.248  1.00  4.44           N  
ATOM    924  CA  LYS    62       4.209 -12.923  17.465  1.00 11.40           C  
ATOM    925  C   LYS    62       5.685 -13.343  17.306  1.00 52.00           C  
ATOM    926  O   LYS    62       6.385 -13.549  18.295  1.00 60.32           O  
ATOM    927  CB  LYS    62       3.332 -14.116  17.908  1.00 35.24           C  
ATOM    928  CG  LYS    62       2.962 -15.109  16.797  1.00 32.32           C  
ATOM    929  CD  LYS    62       4.130 -15.996  16.364  1.00 21.23           C  
ATOM    930  CE  LYS    62       4.682 -16.823  17.517  1.00 32.35           C  
ATOM    931  NZ  LYS    62       5.716 -17.788  17.058  1.00 41.43           N  
ATOM    932  H   LYS    62       2.867 -12.701  15.824  1.00 37.41           H  
ATOM    933  HA  LYS    62       4.165 -12.173  18.244  1.00 22.23           H  
ATOM    934  HB2 LYS    62       3.853 -14.661  18.682  1.00 37.41           H  
ATOM    935  HB3 LYS    62       2.413 -13.726  18.325  1.00 37.41           H  
ATOM    936  HG2 LYS    62       2.164 -15.745  17.155  1.00 37.41           H  
ATOM    937  HG3 LYS    62       2.610 -14.551  15.939  1.00 37.41           H  
ATOM    938  HD2 LYS    62       3.790 -16.667  15.588  1.00 37.41           H  
ATOM    939  HD3 LYS    62       4.919 -15.370  15.972  1.00 37.41           H  
ATOM    940  HE2 LYS    62       5.123 -16.157  18.243  1.00 37.41           H  
ATOM    941  HE3 LYS    62       3.870 -17.369  17.977  1.00 37.41           H  
ATOM    942  HZ1 LYS    62       6.100 -18.314  17.871  1.00 37.41           H  
ATOM    943  HZ2 LYS    62       6.495 -17.286  16.585  1.00 37.41           H  
ATOM    944  HZ3 LYS    62       5.301 -18.465  16.385  1.00 37.41           H  
ATOM    945  N   ASN    63       6.149 -13.463  16.062  1.00 21.24           N  
ATOM    946  CA  ASN    63       7.566 -13.751  15.782  1.00 12.32           C  
ATOM    947  C   ASN    63       8.383 -12.441  15.702  1.00 33.24           C  
ATOM    948  O   ASN    63       9.455 -12.395  15.101  1.00  2.24           O  
ATOM    949  CB  ASN    63       7.668 -14.554  14.471  1.00 62.24           C  
ATOM    950  CG  ASN    63       9.074 -15.056  14.164  1.00 20.31           C  
ATOM    951  OD1 ASN    63       9.485 -16.114  14.623  1.00 45.23           O  
ATOM    952  ND2 ASN    63       9.818 -14.312  13.374  1.00 10.10           N  
ATOM    953  H   ASN    63       5.524 -13.370  15.311  1.00 37.41           H  
ATOM    954  HA  ASN    63       7.952 -14.351  16.596  1.00 40.40           H  
ATOM    955  HB2 ASN    63       7.016 -15.413  14.538  1.00 37.41           H  
ATOM    956  HB3 ASN    63       7.342 -13.932  13.647  1.00 37.41           H  
ATOM    957 HD21 ASN    63       9.442 -13.479  13.028  1.00 37.41           H  
ATOM    958 HD22 ASN    63      10.721 -14.626  13.165  1.00 37.41           H  
ATOM    959  N   ASP    64       7.867 -11.379  16.331  1.00 12.21           N  
ATOM    960  CA  ASP    64       8.514 -10.058  16.313  1.00 33.52           C  
ATOM    961  C   ASP    64       8.675  -9.521  14.882  1.00 53.51           C  
ATOM    962  O   ASP    64       9.686  -8.898  14.546  1.00 41.44           O  
ATOM    963  CB  ASP    64       9.872 -10.114  17.026  1.00 11.12           C  
ATOM    964  CG  ASP    64       9.731 -10.181  18.532  1.00 25.43           C  
ATOM    965  OD1 ASP    64       9.576  -9.113  19.163  1.00 53.53           O  
ATOM    966  OD2 ASP    64       9.775 -11.295  19.093  1.00 55.32           O  
ATOM    967  H   ASP    64       7.030 -11.487  16.826  1.00 37.41           H  
ATOM    968  HA  ASP    64       7.868  -9.381  16.853  1.00 71.24           H  
ATOM    969  HB2 ASP    64      10.411 -10.990  16.690  1.00 37.41           H  
ATOM    970  HB3 ASP    64      10.444  -9.232  16.774  1.00 37.41           H  
ATOM    971  N   LYS    65       7.662  -9.755  14.048  1.00 61.14           N  
ATOM    972  CA  LYS    65       7.666  -9.274  12.660  1.00 32.24           C  
ATOM    973  C   LYS    65       6.824  -7.992  12.531  1.00 33.22           C  
ATOM    974  O   LYS    65       5.593  -8.050  12.518  1.00 61.02           O  
ATOM    975  CB  LYS    65       7.113 -10.358  11.721  1.00 71.43           C  
ATOM    976  CG  LYS    65       7.740 -11.735  11.933  1.00 12.12           C  
ATOM    977  CD  LYS    65       7.122 -12.797  11.024  1.00 54.43           C  
ATOM    978  CE  LYS    65       7.477 -12.578   9.556  1.00 71.11           C  
ATOM    979  NZ  LYS    65       8.943 -12.627   9.316  1.00 13.30           N  
ATOM    980  H   LYS    65       6.892 -10.263  14.373  1.00 37.41           H  
ATOM    981  HA  LYS    65       8.687  -9.055  12.380  1.00 74.43           H  
ATOM    982  HB2 LYS    65       6.046 -10.444  11.878  1.00 37.41           H  
ATOM    983  HB3 LYS    65       7.291 -10.057  10.697  1.00 37.41           H  
ATOM    984  HG2 LYS    65       8.799 -11.672  11.725  1.00 37.41           H  
ATOM    985  HG3 LYS    65       7.595 -12.028  12.964  1.00 37.41           H  
ATOM    986  HD2 LYS    65       7.482 -13.769  11.327  1.00 37.41           H  
ATOM    987  HD3 LYS    65       6.046 -12.764  11.131  1.00 37.41           H  
ATOM    988  HE2 LYS    65       7.002 -13.348   8.965  1.00 37.41           H  
ATOM    989  HE3 LYS    65       7.105 -11.611   9.248  1.00 37.41           H  
ATOM    990  HZ1 LYS    65       9.144 -12.552   8.299  1.00 37.41           H  
ATOM    991  HZ2 LYS    65       9.336 -13.522   9.668  1.00 37.41           H  
ATOM    992  HZ3 LYS    65       9.415 -11.842   9.806  1.00 37.41           H  
ATOM    993  N   PRO    66       7.471  -6.815  12.457  1.00 62.54           N  
ATOM    994  CA  PRO    66       6.766  -5.530  12.370  1.00 44.02           C  
ATOM    995  C   PRO    66       6.263  -5.199  10.950  1.00 12.31           C  
ATOM    996  O   PRO    66       7.020  -5.245   9.979  1.00 62.23           O  
ATOM    997  CB  PRO    66       7.837  -4.530  12.819  1.00 32.11           C  
ATOM    998  CG  PRO    66       9.125  -5.139  12.375  1.00 70.24           C  
ATOM    999  CD  PRO    66       8.939  -6.637  12.465  1.00 13.44           C  
ATOM   1000  HA  PRO    66       5.933  -5.494  13.059  1.00  1.01           H  
ATOM   1001  HB2 PRO    66       7.665  -3.571  12.350  1.00 37.41           H  
ATOM   1002  HB3 PRO    66       7.804  -4.420  13.894  1.00 37.41           H  
ATOM   1003  HG2 PRO    66       9.335  -4.847  11.356  1.00 37.41           H  
ATOM   1004  HG3 PRO    66       9.927  -4.820  13.027  1.00 37.41           H  
ATOM   1005  HD2 PRO    66       9.390  -7.125  11.612  1.00 37.41           H  
ATOM   1006  HD3 PRO    66       9.364  -7.017  13.383  1.00 37.41           H  
ATOM   1007  N   TYR    67       4.979  -4.871  10.846  1.00 24.13           N  
ATOM   1008  CA  TYR    67       4.370  -4.439   9.581  1.00 24.21           C  
ATOM   1009  C   TYR    67       3.188  -3.491   9.849  1.00 45.21           C  
ATOM   1010  O   TYR    67       2.904  -3.151  11.001  1.00 72.50           O  
ATOM   1011  CB  TYR    67       3.915  -5.656   8.753  1.00  1.11           C  
ATOM   1012  CG  TYR    67       2.901  -6.550   9.452  1.00  2.41           C  
ATOM   1013  CD1 TYR    67       3.311  -7.547  10.334  1.00 23.44           C  
ATOM   1014  CD2 TYR    67       1.534  -6.403   9.224  1.00 42.32           C  
ATOM   1015  CE1 TYR    67       2.393  -8.362  10.969  1.00 44.40           C  
ATOM   1016  CE2 TYR    67       0.612  -7.216   9.855  1.00 22.30           C  
ATOM   1017  CZ  TYR    67       1.046  -8.194  10.726  1.00  1.14           C  
ATOM   1018  OH  TYR    67       0.131  -9.010  11.357  1.00 65.32           O  
ATOM   1019  H   TYR    67       4.411  -4.928  11.646  1.00 37.41           H  
ATOM   1020  HA  TYR    67       5.122  -3.896   9.023  1.00 62.22           H  
ATOM   1021  HB2 TYR    67       3.469  -5.308   7.832  1.00 37.41           H  
ATOM   1022  HB3 TYR    67       4.780  -6.259   8.514  1.00 37.41           H  
ATOM   1023  HD1 TYR    67       4.366  -7.678  10.524  1.00  3.10           H  
ATOM   1024  HD2 TYR    67       1.196  -5.635   8.542  1.00 71.14           H  
ATOM   1025  HE1 TYR    67       2.735  -9.127  11.651  1.00 11.44           H  
ATOM   1026  HE2 TYR    67      -0.444  -7.086   9.660  1.00 45.34           H  
ATOM   1027  HH  TYR    67      -0.543  -9.284  10.722  1.00 75.15           H  
ATOM   1028  N   PHE    68       2.507  -3.052   8.794  1.00 24.23           N  
ATOM   1029  CA  PHE    68       1.371  -2.137   8.954  1.00  4.50           C  
ATOM   1030  C   PHE    68       0.403  -2.178   7.760  1.00 64.32           C  
ATOM   1031  O   PHE    68       0.799  -2.428   6.620  1.00 12.41           O  
ATOM   1032  CB  PHE    68       1.871  -0.698   9.183  1.00 32.33           C  
ATOM   1033  CG  PHE    68       2.691  -0.137   8.044  1.00 23.42           C  
ATOM   1034  CD1 PHE    68       4.044  -0.426   7.932  1.00 53.23           C  
ATOM   1035  CD2 PHE    68       2.106   0.680   7.083  1.00 31.25           C  
ATOM   1036  CE1 PHE    68       4.793   0.086   6.889  1.00  4.33           C  
ATOM   1037  CE2 PHE    68       2.853   1.193   6.040  1.00  0.44           C  
ATOM   1038  CZ  PHE    68       4.199   0.895   5.945  1.00 13.13           C  
ATOM   1039  H   PHE    68       2.769  -3.344   7.896  1.00 37.41           H  
ATOM   1040  HA  PHE    68       0.827  -2.451   9.835  1.00 14.23           H  
ATOM   1041  HB2 PHE    68       1.019  -0.048   9.332  1.00 37.41           H  
ATOM   1042  HB3 PHE    68       2.484  -0.681  10.074  1.00 37.41           H  
ATOM   1043  HD1 PHE    68       4.514  -1.062   8.670  1.00 10.45           H  
ATOM   1044  HD2 PHE    68       1.053   0.917   7.157  1.00 75.42           H  
ATOM   1045  HE1 PHE    68       5.844  -0.148   6.814  1.00 73.12           H  
ATOM   1046  HE2 PHE    68       2.386   1.826   5.300  1.00 70.04           H  
ATOM   1047  HZ  PHE    68       4.783   1.293   5.130  1.00  3.33           H  
ATOM   1048  N   ASN    69      -0.872  -1.940   8.050  1.00 64.50           N  
ATOM   1049  CA  ASN    69      -1.917  -1.835   7.029  1.00 15.25           C  
ATOM   1050  C   ASN    69      -2.474  -0.402   6.980  1.00 13.04           C  
ATOM   1051  O   ASN    69      -2.335   0.362   7.937  1.00 72.31           O  
ATOM   1052  CB  ASN    69      -3.054  -2.818   7.333  1.00 23.42           C  
ATOM   1053  CG  ASN    69      -2.588  -4.266   7.375  1.00 74.43           C  
ATOM   1054  OD1 ASN    69      -2.149  -4.761   8.408  1.00 54.30           O  
ATOM   1055  ND2 ASN    69      -2.687  -4.962   6.259  1.00 72.34           N  
ATOM   1056  H   ASN    69      -1.125  -1.836   8.987  1.00 37.41           H  
ATOM   1057  HA  ASN    69      -1.481  -2.078   6.069  1.00 74.20           H  
ATOM   1058  HB2 ASN    69      -3.484  -2.574   8.293  1.00 37.41           H  
ATOM   1059  HB3 ASN    69      -3.816  -2.725   6.572  1.00 37.41           H  
ATOM   1060 HD21 ASN    69      -3.050  -4.521   5.464  1.00 37.41           H  
ATOM   1061 HD22 ASN    69      -2.402  -5.900   6.277  1.00 37.41           H  
ATOM   1062  N   LEU    70      -3.099  -0.039   5.866  1.00  3.12           N  
ATOM   1063  CA  LEU    70      -3.696   1.294   5.709  1.00 12.35           C  
ATOM   1064  C   LEU    70      -5.207   1.188   5.443  1.00 52.51           C  
ATOM   1065  O   LEU    70      -5.639   0.449   4.550  1.00  2.32           O  
ATOM   1066  CB  LEU    70      -3.002   2.054   4.562  1.00 61.41           C  
ATOM   1067  CG  LEU    70      -3.459   3.511   4.357  1.00 74.43           C  
ATOM   1068  CD1 LEU    70      -3.134   4.366   5.584  1.00 53.53           C  
ATOM   1069  CD2 LEU    70      -2.820   4.100   3.100  1.00 51.44           C  
ATOM   1070  H   LEU    70      -3.166  -0.683   5.130  1.00 37.41           H  
ATOM   1071  HA  LEU    70      -3.544   1.837   6.631  1.00 30.15           H  
ATOM   1072  HB2 LEU    70      -1.937   2.057   4.757  1.00 37.41           H  
ATOM   1073  HB3 LEU    70      -3.177   1.512   3.643  1.00 37.41           H  
ATOM   1074  HG  LEU    70      -4.530   3.526   4.222  1.00 53.12           H  
ATOM   1075 HD11 LEU    70      -3.620   3.946   6.453  1.00 37.41           H  
ATOM   1076 HD12 LEU    70      -3.491   5.374   5.426  1.00 37.41           H  
ATOM   1077 HD13 LEU    70      -2.066   4.384   5.742  1.00 37.41           H  
ATOM   1078 HD21 LEU    70      -3.146   5.121   2.972  1.00 37.41           H  
ATOM   1079 HD22 LEU    70      -3.117   3.519   2.239  1.00 37.41           H  
ATOM   1080 HD23 LEU    70      -1.744   4.076   3.194  1.00 37.41           H  
ATOM   1081  N   LYS    71      -6.004   1.925   6.220  1.00 35.23           N  
ATOM   1082  CA  LYS    71      -7.465   1.907   6.076  1.00 73.11           C  
ATOM   1083  C   LYS    71      -8.014   3.253   5.581  1.00 73.01           C  
ATOM   1084  O   LYS    71      -7.513   4.317   5.942  1.00  2.23           O  
ATOM   1085  CB  LYS    71      -8.145   1.557   7.410  1.00 52.54           C  
ATOM   1086  CG  LYS    71      -7.870   0.143   7.914  1.00  3.44           C  
ATOM   1087  CD  LYS    71      -8.818  -0.226   9.058  1.00 43.11           C  
ATOM   1088  CE  LYS    71      -8.538  -1.614   9.626  1.00  2.32           C  
ATOM   1089  NZ  LYS    71      -7.195  -1.709  10.252  1.00 63.42           N  
ATOM   1090  H   LYS    71      -5.604   2.503   6.907  1.00 37.41           H  
ATOM   1091  HA  LYS    71      -7.718   1.146   5.350  1.00 23.22           H  
ATOM   1092  HB2 LYS    71      -7.803   2.251   8.165  1.00 37.41           H  
ATOM   1093  HB3 LYS    71      -9.216   1.669   7.293  1.00 37.41           H  
ATOM   1094  HG2 LYS    71      -8.009  -0.555   7.100  1.00 37.41           H  
ATOM   1095  HG3 LYS    71      -6.848   0.086   8.269  1.00 37.41           H  
ATOM   1096  HD2 LYS    71      -8.714   0.502   9.850  1.00 37.41           H  
ATOM   1097  HD3 LYS    71      -9.832  -0.201   8.685  1.00 37.41           H  
ATOM   1098  HE2 LYS    71      -9.287  -1.839  10.372  1.00 37.41           H  
ATOM   1099  HE3 LYS    71      -8.605  -2.337   8.826  1.00 37.41           H  
ATOM   1100  HZ1 LYS    71      -7.050  -0.916  10.911  1.00 37.41           H  
ATOM   1101  HZ2 LYS    71      -6.452  -1.683   9.527  1.00 37.41           H  
ATOM   1102  HZ3 LYS    71      -7.112  -2.600  10.783  1.00 37.41           H  
ATOM   1103  N   ALA    72      -9.056   3.195   4.754  1.00 64.14           N  
ATOM   1104  CA  ALA    72      -9.782   4.398   4.334  1.00 62.42           C  
ATOM   1105  C   ALA    72     -10.779   4.839   5.421  1.00 74.43           C  
ATOM   1106  O   ALA    72     -10.918   4.172   6.448  1.00 34.50           O  
ATOM   1107  CB  ALA    72     -10.504   4.149   3.016  1.00 73.22           C  
ATOM   1108  H   ALA    72      -9.341   2.319   4.415  1.00 37.41           H  
ATOM   1109  HA  ALA    72      -9.062   5.190   4.180  1.00 74.24           H  
ATOM   1110  HB1 ALA    72      -9.793   3.834   2.267  1.00 37.41           H  
ATOM   1111  HB2 ALA    72     -10.990   5.059   2.691  1.00 37.41           H  
ATOM   1112  HB3 ALA    72     -11.247   3.377   3.152  1.00 37.41           H  
ATOM   1113  N   ALA    73     -11.471   5.956   5.194  1.00 12.14           N  
ATOM   1114  CA  ALA    73     -12.418   6.506   6.181  1.00 23.01           C  
ATOM   1115  C   ALA    73     -13.482   5.481   6.617  1.00 13.03           C  
ATOM   1116  O   ALA    73     -13.840   5.409   7.791  1.00 75.11           O  
ATOM   1117  CB  ALA    73     -13.091   7.756   5.622  1.00 23.52           C  
ATOM   1118  H   ALA    73     -11.348   6.428   4.343  1.00 37.41           H  
ATOM   1119  HA  ALA    73     -11.846   6.801   7.050  1.00 75.03           H  
ATOM   1120  HB1 ALA    73     -13.668   7.495   4.745  1.00 37.41           H  
ATOM   1121  HB2 ALA    73     -12.336   8.482   5.351  1.00 37.41           H  
ATOM   1122  HB3 ALA    73     -13.746   8.182   6.369  1.00 37.41           H  
ATOM   1123  N   ASN    74     -13.975   4.682   5.668  1.00 14.50           N  
ATOM   1124  CA  ASN    74     -14.995   3.662   5.962  1.00 44.41           C  
ATOM   1125  C   ASN    74     -14.373   2.400   6.607  1.00 22.25           C  
ATOM   1126  O   ASN    74     -15.018   1.355   6.708  1.00 15.02           O  
ATOM   1127  CB  ASN    74     -15.760   3.307   4.675  1.00 73.15           C  
ATOM   1128  CG  ASN    74     -17.051   2.547   4.943  1.00 61.34           C  
ATOM   1129  OD1 ASN    74     -18.083   3.137   5.242  1.00  2.04           O  
ATOM   1130  ND2 ASN    74     -17.016   1.235   4.823  1.00 24.03           N  
ATOM   1131  H   ASN    74     -13.661   4.793   4.747  1.00 37.41           H  
ATOM   1132  HA  ASN    74     -15.692   4.094   6.667  1.00 11.14           H  
ATOM   1133  HB2 ASN    74     -16.008   4.219   4.148  1.00 37.41           H  
ATOM   1134  HB3 ASN    74     -15.129   2.697   4.044  1.00 37.41           H  
ATOM   1135 HD21 ASN    74     -16.171   0.813   4.570  1.00 37.41           H  
ATOM   1136 HD22 ASN    74     -17.843   0.739   4.984  1.00 37.41           H  
ATOM   1137  N   HIS    75     -13.105   2.509   7.018  1.00 14.22           N  
ATOM   1138  CA  HIS    75     -12.421   1.473   7.820  1.00 24.34           C  
ATOM   1139  C   HIS    75     -12.106   0.216   6.985  1.00 63.04           C  
ATOM   1140  O   HIS    75     -11.936  -0.882   7.520  1.00 64.04           O  
ATOM   1141  CB  HIS    75     -13.274   1.119   9.054  1.00 34.43           C  
ATOM   1142  CG  HIS    75     -12.532   0.386  10.133  1.00 15.42           C  
ATOM   1143  ND1 HIS    75     -12.548  -0.986  10.265  1.00  2.12           N  
ATOM   1144  CD2 HIS    75     -11.764   0.847  11.149  1.00 71.01           C  
ATOM   1145  CE1 HIS    75     -11.827  -1.335  11.311  1.00 72.22           C  
ATOM   1146  NE2 HIS    75     -11.339  -0.245  11.865  1.00 11.40           N  
ATOM   1147  H   HIS    75     -12.605   3.312   6.767  1.00 37.41           H  
ATOM   1148  HA  HIS    75     -11.486   1.895   8.157  1.00 70.03           H  
ATOM   1149  HB2 HIS    75     -13.657   2.031   9.486  1.00 37.41           H  
ATOM   1150  HB3 HIS    75     -14.105   0.501   8.745  1.00 37.41           H  
ATOM   1151  HD1 HIS    75     -13.019  -1.614   9.676  1.00 74.14           H  
ATOM   1152  HD2 HIS    75     -11.527   1.882  11.355  1.00 62.31           H  
ATOM   1153  HE1 HIS    75     -11.662  -2.346  11.653  1.00 23.12           H  
ATOM   1154  HE2 HIS    75     -10.934  -0.206  12.760  1.00 37.41           H  
ATOM   1155  N   GLN    76     -11.995   0.406   5.675  1.00 70.15           N  
ATOM   1156  CA  GLN    76     -11.689  -0.683   4.736  1.00 74.21           C  
ATOM   1157  C   GLN    76     -10.171  -0.827   4.527  1.00 71.43           C  
ATOM   1158  O   GLN    76      -9.428   0.149   4.651  1.00 53.14           O  
ATOM   1159  CB  GLN    76     -12.374  -0.393   3.393  1.00 42.12           C  
ATOM   1160  CG  GLN    76     -11.825   0.848   2.691  1.00 15.10           C  
ATOM   1161  CD  GLN    76     -12.765   1.405   1.641  1.00  1.43           C  
ATOM   1162  OE1 GLN    76     -12.715   1.031   0.471  1.00 50.25           O  
ATOM   1163  NE2 GLN    76     -13.614   2.324   2.052  1.00 12.54           N  
ATOM   1164  H   GLN    76     -12.121   1.309   5.323  1.00 37.41           H  
ATOM   1165  HA  GLN    76     -12.081  -1.604   5.143  1.00  5.43           H  
ATOM   1166  HB2 GLN    76     -12.235  -1.243   2.738  1.00 37.41           H  
ATOM   1167  HB3 GLN    76     -13.432  -0.249   3.563  1.00 37.41           H  
ATOM   1168  HG2 GLN    76     -11.647   1.615   3.431  1.00 37.41           H  
ATOM   1169  HG3 GLN    76     -10.889   0.592   2.215  1.00 37.41           H  
ATOM   1170 HE21 GLN    76     -13.589   2.593   2.992  1.00 37.41           H  
ATOM   1171 HE22 GLN    76     -14.248   2.691   1.397  1.00 37.41           H  
ATOM   1172  N   ILE    77      -9.715  -2.035   4.194  1.00 32.34           N  
ATOM   1173  CA  ILE    77      -8.283  -2.295   3.979  1.00 40.03           C  
ATOM   1174  C   ILE    77      -7.868  -1.955   2.540  1.00 24.44           C  
ATOM   1175  O   ILE    77      -8.107  -2.731   1.612  1.00 71.02           O  
ATOM   1176  CB  ILE    77      -7.923  -3.778   4.274  1.00 72.54           C  
ATOM   1177  CG1 ILE    77      -8.252  -4.137   5.732  1.00 71.52           C  
ATOM   1178  CG2 ILE    77      -6.445  -4.051   3.976  1.00 55.33           C  
ATOM   1179  CD1 ILE    77      -7.418  -3.391   6.752  1.00  4.14           C  
ATOM   1180  H   ILE    77     -10.356  -2.767   4.072  1.00 37.41           H  
ATOM   1181  HA  ILE    77      -7.722  -1.669   4.662  1.00 54.33           H  
ATOM   1182  HB  ILE    77      -8.514  -4.401   3.617  1.00 41.44           H  
ATOM   1183 HG12 ILE    77      -9.289  -3.910   5.927  1.00 37.41           H  
ATOM   1184 HG13 ILE    77      -8.090  -5.196   5.881  1.00 37.41           H  
ATOM   1185 HG21 ILE    77      -6.214  -5.082   4.206  1.00 37.41           H  
ATOM   1186 HG22 ILE    77      -5.826  -3.401   4.579  1.00 37.41           H  
ATOM   1187 HG23 ILE    77      -6.247  -3.865   2.930  1.00 37.41           H  
ATOM   1188 HD11 ILE    77      -6.377  -3.650   6.624  1.00 37.41           H  
ATOM   1189 HD12 ILE    77      -7.735  -3.667   7.746  1.00 37.41           H  
ATOM   1190 HD13 ILE    77      -7.545  -2.327   6.616  1.00 37.41           H  
ATOM   1191  N   ILE    78      -7.258  -0.789   2.357  1.00 42.24           N  
ATOM   1192  CA  ILE    78      -6.824  -0.346   1.024  1.00 51.22           C  
ATOM   1193  C   ILE    78      -5.345  -0.674   0.761  1.00 70.34           C  
ATOM   1194  O   ILE    78      -4.940  -0.865  -0.388  1.00 50.21           O  
ATOM   1195  CB  ILE    78      -7.057   1.174   0.830  1.00 32.12           C  
ATOM   1196  CG1 ILE    78      -6.289   1.979   1.892  1.00 53.32           C  
ATOM   1197  CG2 ILE    78      -8.551   1.494   0.876  1.00 11.03           C  
ATOM   1198  CD1 ILE    78      -6.479   3.475   1.785  1.00 34.20           C  
ATOM   1199  H   ILE    78      -7.099  -0.209   3.131  1.00 37.41           H  
ATOM   1200  HA  ILE    78      -7.424  -0.870   0.290  1.00 62.01           H  
ATOM   1201  HB  ILE    78      -6.691   1.447  -0.151  1.00 52.10           H  
ATOM   1202 HG12 ILE    78      -6.619   1.676   2.875  1.00 37.41           H  
ATOM   1203 HG13 ILE    78      -5.231   1.773   1.796  1.00 37.41           H  
ATOM   1204 HG21 ILE    78      -8.701   2.554   0.726  1.00 37.41           H  
ATOM   1205 HG22 ILE    78      -8.953   1.206   1.838  1.00 37.41           H  
ATOM   1206 HG23 ILE    78      -9.062   0.945   0.097  1.00 37.41           H  
ATOM   1207 HD11 ILE    78      -5.860   3.968   2.520  1.00 37.41           H  
ATOM   1208 HD12 ILE    78      -7.515   3.722   1.966  1.00 37.41           H  
ATOM   1209 HD13 ILE    78      -6.198   3.807   0.798  1.00 37.41           H  
ATOM   1210  N   GLY    79      -4.543  -0.740   1.826  1.00 72.31           N  
ATOM   1211  CA  GLY    79      -3.118  -1.037   1.679  1.00 14.54           C  
ATOM   1212  C   GLY    79      -2.586  -2.007   2.734  1.00 61.14           C  
ATOM   1213  O   GLY    79      -3.094  -2.060   3.853  1.00 22.12           O  
ATOM   1214  H   GLY    79      -4.920  -0.581   2.720  1.00 37.41           H  
ATOM   1215  HA2 GLY    79      -2.948  -1.464   0.699  1.00 37.41           H  
ATOM   1216  HA3 GLY    79      -2.566  -0.111   1.750  1.00 37.41           H  
ATOM   1217  N   THR    80      -1.552  -2.767   2.373  1.00 55.11           N  
ATOM   1218  CA  THR    80      -0.925  -3.738   3.289  1.00 61.41           C  
ATOM   1219  C   THR    80       0.586  -3.837   3.039  1.00 45.05           C  
ATOM   1220  O   THR    80       1.017  -4.076   1.916  1.00 71.44           O  
ATOM   1221  CB  THR    80      -1.558  -5.147   3.137  1.00 41.01           C  
ATOM   1222  OG1 THR    80      -2.947  -5.106   3.503  1.00 65.52           O  
ATOM   1223  CG2 THR    80      -0.837  -6.182   3.998  1.00  5.43           C  
ATOM   1224  H   THR    80      -1.195  -2.681   1.463  1.00 37.41           H  
ATOM   1225  HA  THR    80      -1.093  -3.397   4.304  1.00 64.32           H  
ATOM   1226  HB  THR    80      -1.480  -5.447   2.100  1.00 64.12           H  
ATOM   1227  HG1 THR    80      -3.488  -5.116   2.709  1.00 11.42           H  
ATOM   1228 HG21 THR    80      -0.865  -5.876   5.034  1.00 37.41           H  
ATOM   1229 HG22 THR    80       0.192  -6.269   3.677  1.00 37.41           H  
ATOM   1230 HG23 THR    80      -1.326  -7.140   3.896  1.00 37.41           H  
ATOM   1231  N   SER    81       1.385  -3.644   4.084  1.00 55.20           N  
ATOM   1232  CA  SER    81       2.854  -3.672   3.956  1.00 70.42           C  
ATOM   1233  C   SER    81       3.435  -5.074   4.181  1.00  1.13           C  
ATOM   1234  O   SER    81       2.783  -5.955   4.752  1.00  0.21           O  
ATOM   1235  CB  SER    81       3.496  -2.690   4.943  1.00 14.40           C  
ATOM   1236  OG  SER    81       4.910  -2.741   4.869  1.00 40.10           O  
ATOM   1237  H   SER    81       0.986  -3.476   4.965  1.00 37.41           H  
ATOM   1238  HA  SER    81       3.099  -3.358   2.950  1.00 32.31           H  
ATOM   1239  HB2 SER    81       3.174  -1.686   4.710  1.00 37.41           H  
ATOM   1240  HB3 SER    81       3.189  -2.937   5.950  1.00 37.41           H  
ATOM   1241  HG  SER    81       5.256  -1.873   4.625  1.00 61.12           H  
ATOM   1242  N   GLN    82       4.677  -5.271   3.739  1.00  5.15           N  
ATOM   1243  CA  GLN    82       5.359  -6.558   3.892  1.00 21.22           C  
ATOM   1244  C   GLN    82       6.166  -6.618   5.200  1.00 62.30           C  
ATOM   1245  O   GLN    82       6.863  -5.668   5.560  1.00 11.14           O  
ATOM   1246  CB  GLN    82       6.300  -6.835   2.704  1.00 60.54           C  
ATOM   1247  CG  GLN    82       5.623  -6.827   1.331  1.00 40.12           C  
ATOM   1248  CD  GLN    82       5.440  -5.429   0.762  1.00 34.15           C  
ATOM   1249  OE1 GLN    82       4.416  -4.784   0.956  1.00 74.24           O  
ATOM   1250  NE2 GLN    82       6.438  -4.949   0.049  1.00 13.44           N  
ATOM   1251  H   GLN    82       5.147  -4.528   3.306  1.00 37.41           H  
ATOM   1252  HA  GLN    82       4.602  -7.330   3.918  1.00 24.02           H  
ATOM   1253  HB2 GLN    82       7.079  -6.085   2.698  1.00 37.41           H  
ATOM   1254  HB3 GLN    82       6.756  -7.805   2.847  1.00 37.41           H  
ATOM   1255  HG2 GLN    82       6.229  -7.400   0.645  1.00 37.41           H  
ATOM   1256  HG3 GLN    82       4.651  -7.295   1.421  1.00 37.41           H  
ATOM   1257 HE21 GLN    82       7.232  -5.512  -0.077  1.00 37.41           H  
ATOM   1258 HE22 GLN    82       6.351  -4.046  -0.311  1.00 37.41           H  
ATOM   1259  N   MET    83       6.062  -7.752   5.893  1.00 21.12           N  
ATOM   1260  CA  MET    83       6.801  -8.008   7.140  1.00 20.12           C  
ATOM   1261  C   MET    83       8.272  -7.528   7.081  1.00 52.45           C  
ATOM   1262  O   MET    83       9.072  -8.020   6.280  1.00 11.10           O  
ATOM   1263  CB  MET    83       6.744  -9.512   7.447  1.00 43.35           C  
ATOM   1264  CG  MET    83       7.207 -10.389   6.284  1.00  3.32           C  
ATOM   1265  SD  MET    83       6.966 -12.151   6.591  1.00 54.34           S  
ATOM   1266  CE  MET    83       7.519 -12.842   5.032  1.00 11.34           C  
ATOM   1267  H   MET    83       5.448  -8.442   5.563  1.00 37.41           H  
ATOM   1268  HA  MET    83       6.297  -7.475   7.933  1.00 14.22           H  
ATOM   1269  HB2 MET    83       7.371  -9.722   8.305  1.00 37.41           H  
ATOM   1270  HB3 MET    83       5.724  -9.780   7.687  1.00 37.41           H  
ATOM   1271  HG2 MET    83       6.649 -10.117   5.399  1.00 37.41           H  
ATOM   1272  HG3 MET    83       8.258 -10.210   6.111  1.00 37.41           H  
ATOM   1273  HE1 MET    83       8.537 -12.535   4.843  1.00 37.41           H  
ATOM   1274  HE2 MET    83       6.882 -12.488   4.235  1.00 37.41           H  
ATOM   1275  HE3 MET    83       7.472 -13.919   5.079  1.00 37.41           H  
ATOM   1276  N   TYR    84       8.613  -6.554   7.932  1.00 31.51           N  
ATOM   1277  CA  TYR    84       9.984  -6.026   8.013  1.00 62.50           C  
ATOM   1278  C   TYR    84      10.837  -6.825   9.012  1.00 11.43           C  
ATOM   1279  O   TYR    84      10.323  -7.658   9.759  1.00 44.01           O  
ATOM   1280  CB  TYR    84       9.965  -4.547   8.426  1.00 12.32           C  
ATOM   1281  CG  TYR    84       9.245  -3.642   7.444  1.00 41.13           C  
ATOM   1282  CD1 TYR    84       9.902  -3.121   6.334  1.00 70.11           C  
ATOM   1283  CD2 TYR    84       7.905  -3.308   7.626  1.00 12.42           C  
ATOM   1284  CE1 TYR    84       9.250  -2.294   5.440  1.00  1.15           C  
ATOM   1285  CE2 TYR    84       7.248  -2.483   6.735  1.00 14.23           C  
ATOM   1286  CZ  TYR    84       7.924  -1.978   5.644  1.00 12.04           C  
ATOM   1287  OH  TYR    84       7.268  -1.156   4.750  1.00 22.12           O  
ATOM   1288  H   TYR    84       7.924  -6.176   8.519  1.00 37.41           H  
ATOM   1289  HA  TYR    84      10.433  -6.109   7.032  1.00 13.23           H  
ATOM   1290  HB2 TYR    84       9.470  -4.455   9.383  1.00 37.41           H  
ATOM   1291  HB3 TYR    84      10.982  -4.193   8.520  1.00 37.41           H  
ATOM   1292  HD1 TYR    84      10.941  -3.370   6.174  1.00 62.23           H  
ATOM   1293  HD2 TYR    84       7.378  -3.702   8.483  1.00 30.20           H  
ATOM   1294  HE1 TYR    84       9.780  -1.899   4.585  1.00 12.23           H  
ATOM   1295  HE2 TYR    84       6.209  -2.237   6.896  1.00 61.43           H  
ATOM   1296  HH  TYR    84       7.405  -1.483   3.856  1.00 43.33           H  
ATOM   1297  N   SER    85      12.141  -6.561   9.027  1.00 13.02           N  
ATOM   1298  CA  SER    85      13.061  -7.245   9.949  1.00 52.24           C  
ATOM   1299  C   SER    85      13.109  -6.551  11.317  1.00 42.44           C  
ATOM   1300  O   SER    85      12.815  -7.158  12.349  1.00  1.01           O  
ATOM   1301  CB  SER    85      14.472  -7.300   9.348  1.00 54.31           C  
ATOM   1302  OG  SER    85      14.975  -5.995   9.092  1.00 43.35           O  
ATOM   1303  H   SER    85      12.498  -5.896   8.403  1.00 37.41           H  
ATOM   1304  HA  SER    85      12.702  -8.256  10.086  1.00 51.40           H  
ATOM   1305  HB2 SER    85      15.137  -7.798  10.039  1.00 37.41           H  
ATOM   1306  HB3 SER    85      14.443  -7.850   8.418  1.00 37.41           H  
ATOM   1307  HG  SER    85      15.881  -6.067   8.762  1.00  2.54           H  
ATOM   1308  N   SER    86      13.502  -5.279  11.322  1.00 63.42           N  
ATOM   1309  CA  SER    86      13.582  -4.489  12.559  1.00 74.23           C  
ATOM   1310  C   SER    86      12.373  -3.556  12.705  1.00 73.32           C  
ATOM   1311  O   SER    86      11.706  -3.226  11.719  1.00 23.32           O  
ATOM   1312  CB  SER    86      14.864  -3.644  12.572  1.00 54.32           C  
ATOM   1313  OG  SER    86      14.833  -2.648  11.557  1.00 20.40           O  
ATOM   1314  H   SER    86      13.752  -4.859  10.472  1.00 37.41           H  
ATOM   1315  HA  SER    86      13.604  -5.173  13.397  1.00 44.14           H  
ATOM   1316  HB2 SER    86      14.965  -3.158  13.532  1.00 37.41           H  
ATOM   1317  HB3 SER    86      15.718  -4.286  12.404  1.00 37.41           H  
ATOM   1318  HG  SER    86      15.653  -2.682  11.042  1.00 20.51           H  
ATOM   1319  N   THR    87      12.093  -3.124  13.933  1.00 65.31           N  
ATOM   1320  CA  THR    87      11.020  -2.149  14.177  1.00 45.55           C  
ATOM   1321  C   THR    87      11.331  -0.822  13.479  1.00 11.24           C  
ATOM   1322  O   THR    87      10.457  -0.203  12.870  1.00 23.25           O  
ATOM   1323  CB  THR    87      10.808  -1.882  15.687  1.00 50.10           C  
ATOM   1324  OG1 THR    87      11.999  -1.322  16.264  1.00 33.13           O  
ATOM   1325  CG2 THR    87      10.444  -3.167  16.423  1.00 61.13           C  
ATOM   1326  H   THR    87      12.616  -3.464  14.695  1.00 37.41           H  
ATOM   1327  HA  THR    87      10.102  -2.553  13.769  1.00 30.01           H  
ATOM   1328  HB  THR    87       9.997  -1.177  15.803  1.00 74.14           H  
ATOM   1329  HG1 THR    87      11.760  -0.583  16.839  1.00  3.11           H  
ATOM   1330 HG21 THR    87      11.243  -3.887  16.310  1.00 37.41           H  
ATOM   1331 HG22 THR    87       9.531  -3.574  16.010  1.00 37.41           H  
ATOM   1332 HG23 THR    87      10.299  -2.953  17.472  1.00 37.41           H  
ATOM   1333  N   ALA    88      12.596  -0.405  13.561  1.00 52.20           N  
ATOM   1334  CA  ALA    88      13.069   0.810  12.892  1.00 21.41           C  
ATOM   1335  C   ALA    88      12.811   0.757  11.376  1.00 34.01           C  
ATOM   1336  O   ALA    88      12.411   1.755  10.775  1.00 31.42           O  
ATOM   1337  CB  ALA    88      14.554   1.029  13.174  1.00 62.43           C  
ATOM   1338  H   ALA    88      13.229  -0.927  14.098  1.00 37.41           H  
ATOM   1339  HA  ALA    88      12.525   1.647  13.307  1.00 22.44           H  
ATOM   1340  HB1 ALA    88      14.722   1.033  14.240  1.00 37.41           H  
ATOM   1341  HB2 ALA    88      14.865   1.977  12.759  1.00 37.41           H  
ATOM   1342  HB3 ALA    88      15.131   0.234  12.723  1.00 37.41           H  
ATOM   1343  N   ALA    89      13.041  -0.408  10.763  1.00 22.32           N  
ATOM   1344  CA  ALA    89      12.750  -0.606   9.334  1.00 24.30           C  
ATOM   1345  C   ALA    89      11.290  -0.260   9.009  1.00 74.43           C  
ATOM   1346  O   ALA    89      10.999   0.381   7.999  1.00 61.43           O  
ATOM   1347  CB  ALA    89      13.051  -2.044   8.923  1.00 34.13           C  
ATOM   1348  H   ALA    89      13.429  -1.150  11.279  1.00 37.41           H  
ATOM   1349  HA  ALA    89      13.399   0.050   8.770  1.00 31.22           H  
ATOM   1350  HB1 ALA    89      12.424  -2.721   9.486  1.00 37.41           H  
ATOM   1351  HB2 ALA    89      14.088  -2.266   9.123  1.00 37.41           H  
ATOM   1352  HB3 ALA    89      12.855  -2.167   7.866  1.00 37.41           H  
ATOM   1353  N   ARG    90      10.381  -0.684   9.883  1.00 11.00           N  
ATOM   1354  CA  ARG    90       8.951  -0.412   9.713  1.00 33.04           C  
ATOM   1355  C   ARG    90       8.652   1.096   9.741  1.00 30.22           C  
ATOM   1356  O   ARG    90       8.065   1.641   8.808  1.00 73.34           O  
ATOM   1357  CB  ARG    90       8.152  -1.104  10.823  1.00 44.22           C  
ATOM   1358  CG  ARG    90       6.644  -0.872  10.740  1.00 45.02           C  
ATOM   1359  CD  ARG    90       5.953  -1.217  12.052  1.00 61.31           C  
ATOM   1360  NE  ARG    90       6.448  -0.396  13.158  1.00 33.23           N  
ATOM   1361  CZ  ARG    90       5.953  -0.406  14.365  1.00 13.35           C  
ATOM   1362  NH1 ARG    90       4.968  -1.191  14.672  1.00 64.35           N  
ATOM   1363  NH2 ARG    90       6.455   0.371  15.264  1.00 43.35           N  
ATOM   1364  H   ARG    90      10.680  -1.197  10.664  1.00 37.41           H  
ATOM   1365  HA  ARG    90       8.646  -0.814   8.758  1.00 34.12           H  
ATOM   1366  HB2 ARG    90       8.335  -2.169  10.770  1.00 37.41           H  
ATOM   1367  HB3 ARG    90       8.499  -0.738  11.779  1.00 37.41           H  
ATOM   1368  HG2 ARG    90       6.459   0.170  10.512  1.00 37.41           H  
ATOM   1369  HG3 ARG    90       6.236  -1.491   9.952  1.00 37.41           H  
ATOM   1370  HD2 ARG    90       4.890  -1.054  11.938  1.00 37.41           H  
ATOM   1371  HD3 ARG    90       6.135  -2.259  12.277  1.00 37.41           H  
ATOM   1372  HE  ARG    90       7.196   0.212  12.977  1.00 52.40           H  
ATOM   1373 HH11 ARG    90       4.581  -1.794  13.988  1.00 37.41           H  
ATOM   1374 HH12 ARG    90       4.591  -1.178  15.600  1.00 37.41           H  
ATOM   1375 HH21 ARG    90       7.217   0.980  15.028  1.00 37.41           H  
ATOM   1376 HH22 ARG    90       6.080   0.373  16.190  1.00 37.41           H  
ATOM   1377  N   ASP    91       9.064   1.763  10.816  1.00 40.42           N  
ATOM   1378  CA  ASP    91       8.766   3.187  11.006  1.00  2.52           C  
ATOM   1379  C   ASP    91       9.501   4.082   9.985  1.00 70.24           C  
ATOM   1380  O   ASP    91       8.964   5.108   9.551  1.00 75.01           O  
ATOM   1381  CB  ASP    91       9.087   3.594  12.447  1.00 21.44           C  
ATOM   1382  CG  ASP    91       8.134   2.936  13.440  1.00  2.12           C  
ATOM   1383  OD1 ASP    91       8.377   1.775  13.833  1.00 23.12           O  
ATOM   1384  OD2 ASP    91       7.127   3.571  13.818  1.00 30.33           O  
ATOM   1385  H   ASP    91       9.578   1.286  11.507  1.00 37.41           H  
ATOM   1386  HA  ASP    91       7.702   3.311  10.850  1.00 41.42           H  
ATOM   1387  HB2 ASP    91      10.099   3.294  12.684  1.00 37.41           H  
ATOM   1388  HB3 ASP    91       9.003   4.668  12.545  1.00 37.41           H  
ATOM   1389  N   ASN    92      10.717   3.698   9.593  1.00 24.54           N  
ATOM   1390  CA  ASN    92      11.417   4.388   8.500  1.00 43.40           C  
ATOM   1391  C   ASN    92      10.694   4.148   7.170  1.00 41.23           C  
ATOM   1392  O   ASN    92      10.585   5.048   6.331  1.00  5.51           O  
ATOM   1393  CB  ASN    92      12.887   3.949   8.402  1.00 21.14           C  
ATOM   1394  CG  ASN    92      13.772   4.674   9.401  1.00  3.32           C  
ATOM   1395  OD1 ASN    92      14.285   5.755   9.126  1.00  3.13           O  
ATOM   1396  ND2 ASN    92      13.967   4.091  10.563  1.00 32.32           N  
ATOM   1397  H   ASN    92      11.145   2.938  10.038  1.00 37.41           H  
ATOM   1398  HA  ASN    92      11.384   5.449   8.713  1.00 54.44           H  
ATOM   1399  HB2 ASN    92      12.954   2.888   8.595  1.00 37.41           H  
ATOM   1400  HB3 ASN    92      13.258   4.152   7.408  1.00 37.41           H  
ATOM   1401 HD21 ASN    92      13.540   3.227  10.725  1.00 37.41           H  
ATOM   1402 HD22 ASN    92      14.534   4.551  11.217  1.00 37.41           H  
ATOM   1403  N   GLY    93      10.190   2.929   6.988  1.00 33.01           N  
ATOM   1404  CA  GLY    93       9.344   2.637   5.843  1.00 30.33           C  
ATOM   1405  C   GLY    93       8.134   3.563   5.786  1.00 44.40           C  
ATOM   1406  O   GLY    93       7.849   4.154   4.747  1.00 20.01           O  
ATOM   1407  H   GLY    93      10.397   2.219   7.635  1.00 37.41           H  
ATOM   1408  HA2 GLY    93       9.924   2.753   4.939  1.00 37.41           H  
ATOM   1409  HA3 GLY    93       9.003   1.614   5.912  1.00 37.41           H  
ATOM   1410  N   ILE    94       7.447   3.709   6.923  1.00 62.14           N  
ATOM   1411  CA  ILE    94       6.288   4.608   7.043  1.00 63.01           C  
ATOM   1412  C   ILE    94       6.627   6.044   6.601  1.00 65.20           C  
ATOM   1413  O   ILE    94       5.849   6.682   5.889  1.00 33.41           O  
ATOM   1414  CB  ILE    94       5.743   4.632   8.499  1.00 21.43           C  
ATOM   1415  CG1 ILE    94       5.302   3.219   8.929  1.00 22.41           C  
ATOM   1416  CG2 ILE    94       4.585   5.624   8.628  1.00 31.41           C  
ATOM   1417  CD1 ILE    94       4.824   3.133  10.365  1.00  5.53           C  
ATOM   1418  H   ILE    94       7.722   3.187   7.707  1.00 37.41           H  
ATOM   1419  HA  ILE    94       5.507   4.226   6.398  1.00 63.10           H  
ATOM   1420  HB  ILE    94       6.540   4.963   9.151  1.00 62.24           H  
ATOM   1421 HG12 ILE    94       4.489   2.896   8.295  1.00 37.41           H  
ATOM   1422 HG13 ILE    94       6.133   2.537   8.814  1.00 37.41           H  
ATOM   1423 HG21 ILE    94       4.214   5.620   9.643  1.00 37.41           H  
ATOM   1424 HG22 ILE    94       3.789   5.340   7.954  1.00 37.41           H  
ATOM   1425 HG23 ILE    94       4.930   6.617   8.377  1.00 37.41           H  
ATOM   1426 HD11 ILE    94       3.967   3.777  10.500  1.00 37.41           H  
ATOM   1427 HD12 ILE    94       5.616   3.447  11.029  1.00 37.41           H  
ATOM   1428 HD13 ILE    94       4.547   2.114  10.593  1.00 37.41           H  
ATOM   1429  N   LYS    95       7.788   6.552   7.022  1.00 12.12           N  
ATOM   1430  CA  LYS    95       8.235   7.888   6.599  1.00  3.54           C  
ATOM   1431  C   LYS    95       8.322   7.975   5.064  1.00 12.31           C  
ATOM   1432  O   LYS    95       7.893   8.962   4.450  1.00 50.22           O  
ATOM   1433  CB  LYS    95       9.593   8.237   7.227  1.00 22.14           C  
ATOM   1434  CG  LYS    95       9.587   8.239   8.756  1.00  4.23           C  
ATOM   1435  CD  LYS    95      10.887   8.798   9.339  1.00 72.42           C  
ATOM   1436  CE  LYS    95      12.109   7.977   8.938  1.00 70.43           C  
ATOM   1437  NZ  LYS    95      13.371   8.537   9.501  1.00 24.34           N  
ATOM   1438  H   LYS    95       8.350   6.022   7.631  1.00 37.41           H  
ATOM   1439  HA  LYS    95       7.498   8.603   6.941  1.00 23.11           H  
ATOM   1440  HB2 LYS    95      10.326   7.516   6.891  1.00 37.41           H  
ATOM   1441  HB3 LYS    95       9.889   9.221   6.888  1.00 37.41           H  
ATOM   1442  HG2 LYS    95       8.761   8.846   9.101  1.00 37.41           H  
ATOM   1443  HG3 LYS    95       9.455   7.224   9.104  1.00 37.41           H  
ATOM   1444  HD2 LYS    95      11.020   9.810   8.984  1.00 37.41           H  
ATOM   1445  HD3 LYS    95      10.809   8.806  10.417  1.00 37.41           H  
ATOM   1446  HE2 LYS    95      11.985   6.967   9.301  1.00 37.41           H  
ATOM   1447  HE3 LYS    95      12.184   7.965   7.859  1.00 37.41           H  
ATOM   1448  HZ1 LYS    95      14.163   7.886   9.326  1.00 37.41           H  
ATOM   1449  HZ2 LYS    95      13.276   8.681  10.528  1.00 37.41           H  
ATOM   1450  HZ3 LYS    95      13.591   9.450   9.056  1.00 37.41           H  
ATOM   1451  N   SER    96       8.874   6.930   4.450  1.00 12.50           N  
ATOM   1452  CA  SER    96       8.935   6.835   2.987  1.00 44.14           C  
ATOM   1453  C   SER    96       7.523   6.782   2.387  1.00 64.41           C  
ATOM   1454  O   SER    96       7.223   7.487   1.426  1.00 44.33           O  
ATOM   1455  CB  SER    96       9.733   5.594   2.559  1.00 22.51           C  
ATOM   1456  OG  SER    96      11.057   5.631   3.076  1.00 73.53           O  
ATOM   1457  H   SER    96       9.251   6.202   4.993  1.00 37.41           H  
ATOM   1458  HA  SER    96       9.437   7.720   2.617  1.00 20.13           H  
ATOM   1459  HB2 SER    96       9.243   4.706   2.928  1.00 37.41           H  
ATOM   1460  HB3 SER    96       9.785   5.554   1.479  1.00 37.41           H  
ATOM   1461  HG  SER    96      11.063   5.256   3.966  1.00 64.30           H  
ATOM   1462  N   VAL    97       6.660   5.955   2.985  1.00 22.23           N  
ATOM   1463  CA  VAL    97       5.264   5.803   2.542  1.00 24.34           C  
ATOM   1464  C   VAL    97       4.527   7.147   2.515  1.00  2.13           C  
ATOM   1465  O   VAL    97       3.820   7.463   1.560  1.00 62.41           O  
ATOM   1466  CB  VAL    97       4.482   4.840   3.469  1.00 14.51           C  
ATOM   1467  CG1 VAL    97       3.028   4.690   3.018  1.00 71.24           C  
ATOM   1468  CG2 VAL    97       5.166   3.484   3.543  1.00 15.31           C  
ATOM   1469  H   VAL    97       6.969   5.428   3.749  1.00 37.41           H  
ATOM   1470  HA  VAL    97       5.273   5.385   1.545  1.00  1.13           H  
ATOM   1471  HB  VAL    97       4.483   5.263   4.462  1.00 32.32           H  
ATOM   1472 HG11 VAL    97       2.517   3.998   3.672  1.00 37.41           H  
ATOM   1473 HG12 VAL    97       2.999   4.315   2.006  1.00 37.41           H  
ATOM   1474 HG13 VAL    97       2.536   5.653   3.057  1.00 37.41           H  
ATOM   1475 HG21 VAL    97       6.196   3.614   3.837  1.00 37.41           H  
ATOM   1476 HG22 VAL    97       5.126   3.005   2.576  1.00 37.41           H  
ATOM   1477 HG23 VAL    97       4.663   2.866   4.269  1.00 37.41           H  
ATOM   1478  N   MET    98       4.684   7.935   3.575  1.00 75.31           N  
ATOM   1479  CA  MET    98       4.060   9.256   3.635  1.00 41.35           C  
ATOM   1480  C   MET    98       4.594  10.166   2.521  1.00 41.34           C  
ATOM   1481  O   MET    98       3.834  10.905   1.898  1.00  0.11           O  
ATOM   1482  CB  MET    98       4.282   9.904   5.010  1.00  4.12           C  
ATOM   1483  CG  MET    98       3.651   9.128   6.161  1.00  3.41           C  
ATOM   1484  SD  MET    98       3.719  10.019   7.729  1.00 30.23           S  
ATOM   1485  CE  MET    98       5.489  10.191   7.964  1.00 73.24           C  
ATOM   1486  H   MET    98       5.226   7.621   4.328  1.00 37.41           H  
ATOM   1487  HA  MET    98       2.997   9.119   3.485  1.00 63.30           H  
ATOM   1488  HB2 MET    98       5.345   9.979   5.192  1.00 37.41           H  
ATOM   1489  HB3 MET    98       3.857  10.899   5.001  1.00 37.41           H  
ATOM   1490  HG2 MET    98       2.615   8.938   5.924  1.00 37.41           H  
ATOM   1491  HG3 MET    98       4.171   8.187   6.275  1.00 37.41           H  
ATOM   1492  HE1 MET    98       5.914  10.735   7.133  1.00 37.41           H  
ATOM   1493  HE2 MET    98       5.944   9.212   8.020  1.00 37.41           H  
ATOM   1494  HE3 MET    98       5.681  10.729   8.882  1.00 37.41           H  
ATOM   1495  N   GLU    99       5.900  10.090   2.259  1.00 34.51           N  
ATOM   1496  CA  GLU    99       6.524  10.917   1.218  1.00 32.11           C  
ATOM   1497  C   GLU    99       6.046  10.539  -0.201  1.00 60.22           C  
ATOM   1498  O   GLU    99       5.629  11.400  -0.976  1.00 44.32           O  
ATOM   1499  CB  GLU    99       8.050  10.794   1.271  1.00 52.15           C  
ATOM   1500  CG  GLU    99       8.757  11.763   0.329  1.00 14.20           C  
ATOM   1501  CD  GLU    99      10.186  11.363   0.018  1.00 63.03           C  
ATOM   1502  OE1 GLU    99      11.087  11.658   0.828  1.00  4.14           O  
ATOM   1503  OE2 GLU    99      10.411  10.767  -1.055  1.00 13.44           O  
ATOM   1504  H   GLU    99       6.463   9.475   2.785  1.00 37.41           H  
ATOM   1505  HA  GLU    99       6.253  11.946   1.411  1.00 25.32           H  
ATOM   1506  HB2 GLU    99       8.383  10.993   2.280  1.00 37.41           H  
ATOM   1507  HB3 GLU    99       8.331   9.785   1.000  1.00 37.41           H  
ATOM   1508  HG2 GLU    99       8.204  11.808  -0.599  1.00 37.41           H  
ATOM   1509  HG3 GLU    99       8.764  12.745   0.782  1.00 37.41           H  
ATOM   1510  N   ASN   100       6.127   9.251  -0.544  1.00  3.11           N  
ATOM   1511  CA  ASN   100       5.842   8.796  -1.917  1.00 53.52           C  
ATOM   1512  C   ASN   100       4.372   8.388  -2.122  1.00 23.34           C  
ATOM   1513  O   ASN   100       3.846   8.496  -3.227  1.00 14.11           O  
ATOM   1514  CB  ASN   100       6.779   7.641  -2.304  1.00 64.23           C  
ATOM   1515  CG  ASN   100       6.757   6.484  -1.319  1.00 11.22           C  
ATOM   1516  OD1 ASN   100       5.763   6.225  -0.659  1.00  1.03           O  
ATOM   1517  ND2 ASN   100       7.864   5.780  -1.212  1.00 14.54           N  
ATOM   1518  H   ASN   100       6.376   8.589   0.139  1.00 37.41           H  
ATOM   1519  HA  ASN   100       6.048   9.629  -2.577  1.00  2.41           H  
ATOM   1520  HB2 ASN   100       6.490   7.260  -3.272  1.00 37.41           H  
ATOM   1521  HB3 ASN   100       7.792   8.017  -2.366  1.00 37.41           H  
ATOM   1522 HD21 ASN   100       8.632   6.031  -1.764  1.00 37.41           H  
ATOM   1523 HD22 ASN   100       7.867   5.034  -0.583  1.00 37.41           H  
ATOM   1524  N   GLY   101       3.716   7.930  -1.060  1.00 34.41           N  
ATOM   1525  CA  GLY   101       2.311   7.520  -1.144  1.00 21.04           C  
ATOM   1526  C   GLY   101       1.373   8.620  -1.650  1.00 72.40           C  
ATOM   1527  O   GLY   101       0.233   8.351  -2.033  1.00  3.20           O  
ATOM   1528  H   GLY   101       4.194   7.839  -0.209  1.00 37.41           H  
ATOM   1529  HA2 GLY   101       2.236   6.673  -1.809  1.00 37.41           H  
ATOM   1530  HA3 GLY   101       1.986   7.212  -0.161  1.00 37.41           H  
END
