
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  123 (  602),  selected  123 , name 1i94_K
# Molecule2: number of CA atoms  110 ( 1680),  selected  110 , name T0472.pdb
# PARAMETERS: 1i94_K.T0472.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     7_K      -       -           -
LGA    K     8_K      -       -           -
LGA    K     9_K      -       -           -
LGA    V    10_K      -       -           -
LGA    K    11_K      -       -           -
LGA    R    12_K      -       -           -
LGA    Q    13_K      -       -           -
LGA    V    14_K      -       -           -
LGA    A    15_K      M       1          2.679
LGA    S    16_K      S       2          3.221
LGA    G    17_K      G       3          0.783
LGA    R    18_K      W       4          1.531
LGA    A    19_K      Y       5          0.485
LGA    Y    20_K      E       6          1.005
LGA    I    21_K      L       7          0.760
LGA    H    22_K      S       8          0.904
LGA    A    23_K      K       9          2.916
LGA    S    24_K      S      10          4.992
LGA    Y    25_K      S      11           #
LGA    -       -      N      12           -
LGA    N    26_K      D      13          2.742
LGA    N    27_K      Q      14          1.421
LGA    T    28_K      F      15          1.211
LGA    I    29_K      K      16          0.706
LGA    V    30_K      F      17          1.355
LGA    T    31_K      V      18          1.774
LGA    I    32_K      L      19          1.344
LGA    T    33_K      K      20          1.427
LGA    D    34_K      A      21          1.517
LGA    P    35_K      G      22          1.842
LGA    D    36_K      N      23          1.107
LGA    G    37_K      G      24          1.223
LGA    N    38_K      E      25          1.909
LGA    P    39_K      V      26          2.388
LGA    I    40_K      I      27          2.810
LGA    T    41_K      L      28          2.242
LGA    W    42_K      T      29          3.007
LGA    S    43_K      S      30          2.619
LGA    S    44_K      E      31          3.972
LGA    G    45_K      L      32          4.779
LGA    G    46_K      -       -           -
LGA    V    47_K      -       -           -
LGA    I    48_K      -       -           -
LGA    G    49_K      -       -           -
LGA    Y    50_K      -       -           -
LGA    K    51_K      -       -           -
LGA    G    52_K      -       -           -
LGA    S    53_K      -       -           -
LGA    R    54_K      -       -           -
LGA    K    55_K      Y      33          3.162
LGA    G    56_K      T      34          2.279
LGA    T    57_K      G      35          2.019
LGA    P    58_K      K      36          3.062
LGA    Y    59_K      S      37          2.625
LGA    A    60_K      G      38          2.897
LGA    A    61_K      A      39          2.333
LGA    Q    62_K      M      40          2.356
LGA    L    63_K      N      41          3.073
LGA    A    64_K      G      42          2.558
LGA    A    65_K      I      43          2.349
LGA    L    66_K      E      44          2.975
LGA    D    67_K      S      45          4.188
LGA    A    68_K      V      46          4.176
LGA    A    69_K      Q      47          3.166
LGA    K    70_K      T      48          4.078
LGA    K    71_K      N      49          4.797
LGA    A    72_K      S      50          4.539
LGA    M    73_K      P      51          5.069
LGA    A    74_K      I      52          5.940
LGA    -       -      E      53           -
LGA    -       -      A      54           -
LGA    -       -      R      55           -
LGA    -       -      Y      56           -
LGA    -       -      A      57           -
LGA    -       -      K      58           -
LGA    -       -      E      59           -
LGA    -       -      V      60           -
LGA    -       -      A      61           -
LGA    -       -      K      62           -
LGA    -       -      N      63           -
LGA    -       -      D      64           -
LGA    -       -      K      65           -
LGA    -       -      P      66           -
LGA    -       -      Y      67           -
LGA    -       -      F      68           -
LGA    -       -      N      69           -
LGA    -       -      L      70           -
LGA    -       -      K      71           -
LGA    -       -      A      72           -
LGA    -       -      A      73           -
LGA    -       -      N      74           -
LGA    -       -      H      75           -
LGA    -       -      Q      76           -
LGA    -       -      I      77           -
LGA    -       -      I      78           -
LGA    -       -      G      79           -
LGA    -       -      T      80           -
LGA    -       -      S      81           -
LGA    -       -      Q      82           -
LGA    -       -      M      83           -
LGA    -       -      Y      84           -
LGA    -       -      S      85           -
LGA    -       -      S      86           -
LGA    -       -      T      87           -
LGA    -       -      A      88           -
LGA    -       -      A      89           -
LGA    -       -      R      90           -
LGA    -       -      D      91           -
LGA    -       -      N      92           -
LGA    -       -      G      93           -
LGA    -       -      I      94           -
LGA    -       -      K      95           -
LGA    -       -      S      96           -
LGA    -       -      V      97           -
LGA    Y    75_K      M      98          1.014
LGA    G    76_K      E      99          2.641
LGA    M    77_K      N     100          3.018
LGA    -       -      G     101           -
LGA    Q    78_K      K     102          3.892
LGA    S    79_K      T     103          2.887
LGA    V    80_K      T     104          4.062
LGA    D    81_K      T     105          2.666
LGA    V    82_K      I     106          2.205
LGA    I    83_K      K     107          2.216
LGA    V    84_K      D     108          2.037
LGA    R    85_K      L     109          1.203
LGA    G    86_K      T     110          2.977
LGA    T    87_K      -       -           -
LGA    G    88_K      -       -           -
LGA    A    89_K      -       -           -
LGA    G    90_K      -       -           -
LGA    R    91_K      -       -           -
LGA    E    92_K      -       -           -
LGA    Q    93_K      -       -           -
LGA    A    94_K      -       -           -
LGA    I    95_K      -       -           -
LGA    R    96_K      -       -           -
LGA    A    97_K      -       -           -
LGA    L    98_K      -       -           -
LGA    Q    99_K      -       -           -
LGA    A   100_K      -       -           -
LGA    S   101_K      -       -           -
LGA    G   102_K      -       -           -
LGA    L   103_K      -       -           -
LGA    Q   104_K      -       -           -
LGA    V   105_K      -       -           -
LGA    K   106_K      -       -           -
LGA    S   107_K      -       -           -
LGA    I   108_K      -       -           -
LGA    V   109_K      -       -           -
LGA    D   110_K      -       -           -
LGA    D   111_K      -       -           -
LGA    T   112_K      -       -           -
LGA    P   113_K      -       -           -
LGA    V   114_K      -       -           -
LGA    P   115_K      -       -           -
LGA    H   116_K      -       -           -
LGA    N   117_K      -       -           -
LGA    G   118_K      -       -           -
LGA    C   119_K      -       -           -
LGA    R   120_K      -       -           -
LGA    P   121_K      -       -           -
LGA    K   122_K      -       -           -
LGA    K   123_K      -       -           -
LGA    K   124_K      -       -           -
LGA    F   125_K      -       -           -
LGA    R   126_K      -       -           -
LGA    K   127_K      -       -           -
LGA    A   128_K      -       -           -
LGA    S   129_K      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  123  110    5.0     62    2.85    11.29     37.847     2.105

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.374598 * X  +   0.280458 * Y  +  -0.883753 * Z  +  44.742722
  Y_new =  -0.086411 * X  +  -0.938446 * Y  +  -0.334442 * Z  + 110.198601
  Z_new =  -0.923152 * X  +   0.201647 * Y  +  -0.327306 * Z  +  21.358423 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.589431   -0.552161  [ DEG:   148.3635    -31.6365 ]
  Theta =   1.176200    1.965393  [ DEG:    67.3913    112.6087 ]
  Phi   =  -0.226711    2.914882  [ DEG:   -12.9896    167.0104 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1i94_K                                        
REMARK     2: T0472.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1i94_K.T0472.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  123  110   5.0   62   2.85   11.29  37.847
REMARK  ---------------------------------------------------------- 
MOLECULE 1i94_K
HEADER    RIBOSOME                                18-MAR-01   1I94              
TITLE     CRYSTAL STRUCTURES OF THE SMALL RIBOSOMAL SUBUNIT WITH                
TITLE    2 TETRACYCLINE, EDEINE AND IF3                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 16S RRNA;                                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 MOL_ID: 2;                                                           
COMPND   5 MOLECULE: 30S RIBOSOMAL PROTEIN S2;                                  
COMPND   6 CHAIN: B;                                                            
COMPND   7 MOL_ID: 3;                                                           
COMPND   8 MOLECULE: 30S RIBOSOMAL PROTEIN S3;                                  
COMPND   9 CHAIN: C;                                                            
COMPND  10 MOL_ID: 4;                                                           
COMPND  11 MOLECULE: 30S RIBOSOMAL PROTEIN S4;                                  
COMPND  12 CHAIN: D;                                                            
COMPND  13 MOL_ID: 5;                                                           
COMPND  14 MOLECULE: 30S RIBOSOMAL PROTEIN S5;                                  
COMPND  15 CHAIN: E;                                                            
COMPND  16 MOL_ID: 6;                                                           
COMPND  17 MOLECULE: 30S RIBOSOMAL PROTEIN S6;                                  
COMPND  18 CHAIN: F;                                                            
COMPND  19 MOL_ID: 7;                                                           
COMPND  20 MOLECULE: 30S RIBOSOMAL PROTEIN S7;                                  
COMPND  21 CHAIN: G;                                                            
COMPND  22 MOL_ID: 8;                                                           
COMPND  23 MOLECULE: 30S RIBOSOMAL PROTEIN S8;                                  
COMPND  24 CHAIN: H;                                                            
COMPND  25 MOL_ID: 9;                                                           
COMPND  26 MOLECULE: 30S RIBOSOMAL PROTEIN S9;                                  
COMPND  27 CHAIN: I;                                                            
COMPND  28 MOL_ID: 10;                                                          
COMPND  29 MOLECULE: 30S RIBOSOMAL PROTEIN S10;                                 
COMPND  30 CHAIN: J;                                                            
COMPND  31 MOL_ID: 11;                                                          
COMPND  32 MOLECULE: 30S RIBOSOMAL PROTEIN S11;                                 
COMPND  33 CHAIN: K;                                                            
COMPND  34 MOL_ID: 12;                                                          
COMPND  35 MOLECULE: 30S RIBOSOMAL PROTEIN S12;                                 
COMPND  36 CHAIN: L;                                                            
COMPND  37 MOL_ID: 13;                                                          
COMPND  38 MOLECULE: 30S RIBOSOMAL PROTEIN S13;                                 
COMPND  39 CHAIN: M;                                                            
COMPND  40 MOL_ID: 14;                                                          
COMPND  41 MOLECULE: 30S RIBOSOMAL PROTEIN S14;                                 
COMPND  42 CHAIN: N;                                                            
COMPND  43 MOL_ID: 15;                                                          
COMPND  44 MOLECULE: 30S RIBOSOMAL PROTEIN S15;                                 
COMPND  45 CHAIN: O;                                                            
COMPND  46 MOL_ID: 16;                                                          
COMPND  47 MOLECULE: 30S RIBOSOMAL PROTEIN S16;                                 
COMPND  48 CHAIN: P;                                                            
COMPND  49 MOL_ID: 17;                                                          
COMPND  50 MOLECULE: 30S RIBOSOMAL PROTEIN S17;                                 
COMPND  51 CHAIN: Q;                                                            
COMPND  52 MOL_ID: 18;                                                          
COMPND  53 MOLECULE: 30S RIBOSOMAL PROTEIN S18;                                 
COMPND  54 CHAIN: R;                                                            
COMPND  55 MOL_ID: 19;                                                          
COMPND  56 MOLECULE: 30S RIBOSOMAL PROTEIN S19;                                 
COMPND  57 CHAIN: S;                                                            
COMPND  58 MOL_ID: 20;                                                          
COMPND  59 MOLECULE: 30S RIBOSOMAL PROTEIN S20;                                 
COMPND  60 CHAIN: T;                                                            
COMPND  61 MOL_ID: 21;                                                          
COMPND  62 MOLECULE: 30S RIBOSOMAL PROTEIN THX;                                 
COMPND  63 CHAIN: U                                                             
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 MOL_ID: 2;                                                           
SOURCE   5 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   6 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   7 MOL_ID: 3;                                                           
SOURCE   8 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   9 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  10 MOL_ID: 4;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 MOL_ID: 5;                                                           
SOURCE  14 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  15 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  16 MOL_ID: 6;                                                           
SOURCE  17 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  18 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  19 MOL_ID: 7;                                                           
SOURCE  20 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  21 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  22 MOL_ID: 8;                                                           
SOURCE  23 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  24 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  25 MOL_ID: 9;                                                           
SOURCE  26 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  27 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  28 MOL_ID: 10;                                                          
SOURCE  29 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  30 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  31 MOL_ID: 11;                                                          
SOURCE  32 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  33 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  34 MOL_ID: 12;                                                          
SOURCE  35 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  36 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  37 MOL_ID: 13;                                                          
SOURCE  38 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  39 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  40 MOL_ID: 14;                                                          
SOURCE  41 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  42 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  43 MOL_ID: 15;                                                          
SOURCE  44 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  45 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  46 MOL_ID: 16;                                                          
SOURCE  47 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  48 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  49 MOL_ID: 17;                                                          
SOURCE  50 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  51 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  52 MOL_ID: 18;                                                          
SOURCE  53 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  54 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  55 MOL_ID: 19;                                                          
SOURCE  56 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  57 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  58 MOL_ID: 20;                                                          
SOURCE  59 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  60 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  61 MOL_ID: 21;                                                          
SOURCE  62 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE  63 ORGANISM_COMMON: BACTERIA                                            
KEYWDS    30S RIBOSOME                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.PIOLETTI,F.SCHLUENZEN,J.HARMS,R.ZARIVACH,M.GLUEHMANN,               
AUTHOR   2 H.AVILA,H.BARTELS,C.JACOBI,T.HARTSCH,A.YONATH,F.FRANCESCHI           
REVDAT   2   01-APR-03 1I94    1       JRNL                                     
REVDAT   1   12-APR-01 1I94    0                                                
JRNL        AUTH   M.PIOLETTI,F.SCHLUNZEN,J.HARMS,R.ZARIVACH,                   
JRNL        AUTH 2 M.GLUHMANN,H.AVILA,A.BASHAN,H.BARTELS,T.AUERBACH,            
JRNL        AUTH 3 C.JACOBI,T.HARTSCH,A.YONATH,F.FRANCESCHI                     
JRNL        TITL   CRYSTAL STRUCTURES OF COMPLEXES OF THE SMALL                 
JRNL        TITL 2 RIBOSOMAL SUBUNIT WITH TETRACYCLINE, EDEINE AND              
JRNL        TITL 3 IF3.                                                         
JRNL        REF    EMBO J.                       V.  20  1829 2001              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 3.20 ANGSTROMS.                                          
DBREF  1I94 A    2  1515  GB     155076   M26923         648   2161             
DBREF  1I94 B    2   256  GB     13446664 CAC35061         2    256             
DBREF  1I94 C    2   239  GB     13446666 CAC35062         2    239             
DBREF  1I94 D    2   209  UNP    P80373   RS4_THETH        1    208             
DBREF  1I94 E    2   162  UNP    P27152   RS5_THETH        1    161             
DBREF  1I94 F    1   101  UNP    P23370   RS6_THETH        1    101             
DBREF  1I94 G    2   156  UNP    P17291   P17291           1    155             
DBREF  1I94 H    1   138  UNP    P24319   RS8_THETH        1    138             
DBREF  1I94 I    1   128  GB     13446668 CAC35063         1    128             
DBREF  1I94 J    2   105  UNP    P80375   RS10_THETH       1    104             
DBREF  1I94 K    2   129  GB     4519421  BAA75547         2    129             
DBREF  1I94 L    5   135  UNP    P17293   RS12_THETH       5    135             
DBREF  1I94 M    2   126  GB     4519420  BAA75546         2    126             
DBREF  1I94 N    2    61  UNP    P24320   RS14_THETH       1     60             
DBREF  1I94 O    2    89  UNP    P80378   RS15_THETH       1     88             
DBREF  1I94 P    1    88  GB     12056104 CAC21226         1     88             
DBREF  1I94 Q    2   105  UNP    P24321   RS17_THETH       1    104             
DBREF  1I94 R    2    88  GB     6739549  AAF27297         2     88             
DBREF  1I94 S    2    93  UNP    P80381   RS19_THETH       1     92             
DBREF  1I94 T    2   106  GB     11125386 CAC15067         2    106             
DBREF  1I94 U    2    27  GB     11125387 CAC15068         2     27             
SEQRES   1 A 1514    U   G   U   U   G   G   A   G   A   G   U   U   U          
SEQRES   2 A 1514    G   A   U   C   C   U   G   G   C   U   C   A   G          
SEQRES   3 A 1514    G   G   U   G   A   A   C   G   C   U   G   G   C          
SEQRES   4 A 1514    G   G   C   G   U   G   C   C   U   A   A   G   A          
SEQRES   5 A 1514    C   A   U   G   C   A   A   G   U   C   G   U   G          
SEQRES   6 A 1514    C   G   G   G   C   C   G   C   G   G   G   G   U          
SEQRES   7 A 1514    U   U   U   A   C   U   C   C   G   U   G   G   U          
SEQRES   8 A 1514    C   A   G   C   G   G   C   G   G   A   C   G   G          
SEQRES   9 A 1514    G   U   G   A   G   U   A   A   C   G   C   G   U          
SEQRES  10 A 1514    G   G   G   U   G   A   C   C   U   A   C   C   C          
SEQRES  11 A 1514    G   G   A   A   G   A   G   G   G   G   G   A   C          
SEQRES  12 A 1514    A   A   C   C   C   G   G   G   G   A   A   A   C          
SEQRES  13 A 1514    U   C   G   G   G   C   U   A   A   U   C   C   C          
SEQRES  14 A 1514    C   C   A   U   G   U   G   G   A   C   C   C   G          
SEQRES  15 A 1514    C   C   C   C   U   U   G   G   G   G   U   G   U          
SEQRES  16 A 1514    G   U   C   C   A   A   A   G   G   G   C   U   U          
SEQRES  17 A 1514    U   G   C   C   C   G   C   U   U   C   C   G   G          
SEQRES  18 A 1514    A   U   G   G   G   C   C   C   G   C   G   U   C          
SEQRES  19 A 1514    C   C   A   U   C   A   G   C   U   A   G   U   U          
SEQRES  20 A 1514    G   G   U   G   G   G   G   U   A   A   U   G   G          
SEQRES  21 A 1514    C   C   C   A   C   C   A   A   G   G   C   G   A          
SEQRES  22 A 1514    C   G   A   C   G   G   G   U   A   G   C   C   G          
SEQRES  23 A 1514    G   U   C   U   G   A   G   A   G   G   A   U   G          
SEQRES  24 A 1514    G   C   C   G   G   C   C   A   C   A   G   G   G          
SEQRES  25 A 1514    G   C   A   C   U   G   A   G   A   C   A   C   G          
SEQRES  26 A 1514    G   G   C   C   C   C   A   C   U   C   C   U   A          
SEQRES  27 A 1514    C   G   G   G   A   G   G   C   A   G   C   A   G          
SEQRES  28 A 1514    U   U   A   G   G   A   A   U   C   U   U   C   C          
SEQRES  29 A 1514    G   C   A   A   U   G   G   G   C   G   C   A   A          
SEQRES  30 A 1514    G   C   C   U   G   A   C   G   G   A   G   C   G          
SEQRES  31 A 1514    A   C   G   C   C   G   C   U   U   G   G   A   G          
SEQRES  32 A 1514    G   A   A   G   A   A   G   C   C   C   U   U   C          
SEQRES  33 A 1514    G   G   G   G   U   G   U   A   A   A   C   U   C          
SEQRES  34 A 1514    C   U   G   A   A   C   C   C   G   G   G   A   C          
SEQRES  35 A 1514    G   A   A   A   C   C   C   C   C   G   A   C   G          
SEQRES  36 A 1514    A   G   G   G   G   A   C   U   G   A   C   G   G          
SEQRES  37 A 1514    U   A   C   C   G   G   G   G   U   A   A   U   A          
SEQRES  38 A 1514    G   C   G   C   C   G   G   C   C   A   A   C   U          
SEQRES  39 A 1514    C   C   G   U   G   C   C   A   G   C   A   G   C          
SEQRES  40 A 1514    C   G   C   G   G   U   A   A   U   A   C   G   G          
SEQRES  41 A 1514    A   G   G   G   C   G   C   G   A   G   C   G   U          
SEQRES  42 A 1514    U   A   C   C   C   G   G   A   U   U   C   A   C          
SEQRES  43 A 1514    U   G   G   G   C   G   U   A   A   A   G   G   G          
SEQRES  44 A 1514    C   G   U   G   U   A   G   G   C   G   G   C   C          
SEQRES  45 A 1514    U   G   G   G   G   C   G   U   C   C   C   A   U          
SEQRES  46 A 1514    G   U   G   A   A   A   G   A   C   C   A   C   G          
SEQRES  47 A 1514    G   C   U   C   A   A   C   C   G   U   G   G   G          
SEQRES  48 A 1514    G   G   A   G   C   G   U   G   G   G   A   U   A          
SEQRES  49 A 1514    C   G   C   U   C   A   G   G   C   U   A   G   A          
SEQRES  50 A 1514    C   G   G   U   G   G   G   A   G   A   G   G   G          
SEQRES  51 A 1514    U   G   G   U   G   G   A   A   U   U   C   C   C          
SEQRES  52 A 1514    G   G   A   G   U   A   G   C   G   G   U   G   A          
SEQRES  53 A 1514    A   A   U   G   C   G   C   A   G   A   U   A   C          
SEQRES  54 A 1514    C   G   G   G   A   G   G   A   A   C   G   C   C          
SEQRES  55 A 1514    G   A   U   G   G   C   G   A   A   G   G   C   A          
SEQRES  56 A 1514    G   C   C   A   C   C   U   G   G   U   C   C   A          
SEQRES  57 A 1514    C   C   C   G   U   G   A   C   G   C   U   G   A          
SEQRES  58 A 1514    G   G   C   G   C   G   A   A   A   G   C   G   U          
SEQRES  59 A 1514    G   G   G   G   A   G   C   A   A   A   C   C   G          
SEQRES  60 A 1514    G   A   U   U   A   G   A   U   A   C   C   C   G          
SEQRES  61 A 1514    G   G   U   A   G   U   C   C   A   C   G   C   C          
SEQRES  62 A 1514    C   U   A   A   A   C   G   A   U   G   C   G   C          
SEQRES  63 A 1514    G   C   U   A   G   G   U   C   U   C   U   G   G          
SEQRES  64 A 1514    G   U   C   U   C   C   U   G   G   G   G   G   C          
SEQRES  65 A 1514    C   G   A   A   G   C   U   A   A   C   G   C   G          
SEQRES  66 A 1514    U   U   A   A   G   C   G   C   G   C   C   G   C          
SEQRES  67 A 1514    C   U   G   G   G   G   A   G   U   A   C   G   G          
SEQRES  68 A 1514    C   C   G   C   A   A   G   G   C   U   G   A   A          
SEQRES  69 A 1514    A   C   U   C   A   A   A   G   G   A   A   U   U          
SEQRES  70 A 1514    G   A   C   G   G   G   G   G   C   C   C   G   C          
SEQRES  71 A 1514    A   C   A   A   G   C   G   G   U   G   G   A   G          
SEQRES  72 A 1514    C   A   U   G   U   G   G   U   U   U   A   A   U          
SEQRES  73 A 1514    U   C   G   A   A   G   C   A   A   C   G   C   G          
SEQRES  74 A 1514    A   A   G   A   A   C   C   U   U   A   C   C   A          
SEQRES  75 A 1514    G   G   C   C   U   U   G   A   C   A   U   G   C          
SEQRES  76 A 1514    U   A   G   G   G   A   A   C   C   C   G   G   G          
SEQRES  77 A 1514    U   G   A   A   A   G   C   C   U   G   G   G   G          
SEQRES  78 A 1514    U   G   C   C   C   C   G   C   G   A   G   G   G          
SEQRES  79 A 1514    G   A   G   C   C   C   U   A   G   C   A   C   A          
SEQRES  80 A 1514    G   G   U   G   C   U   G   C   A   U   G   G   C          
SEQRES  81 A 1514    C   G   U   C   G   U   C   A   G   C   U   C   G          
SEQRES  82 A 1514    U   G   C   C   G   U   G   A   G   G   U   G   U          
SEQRES  83 A 1514    U   G   G   G   U   U   A   A   G   U   C   C   C          
SEQRES  84 A 1514    G   C   A   A   C   G   A   G   C   G   C   A   A          
SEQRES  85 A 1514    C   C   C   C   C   G   C   C   G   U   U   A   G          
SEQRES  86 A 1514    U   U   G   C   C   A   G   C   G   G   U   U   C          
SEQRES  87 A 1514    G   G   C   C   G   G   G   C   A   C   U   C   U          
SEQRES  88 A 1514    A   A   C   G   G   G   A   C   U   G   C   C   C          
SEQRES  89 A 1514    G   C   G   A   A   A   G   C   G   G   G   A   G          
SEQRES  90 A 1514    G   A   A   G   G   A   G   G   G   G   A   C   G          
SEQRES  91 A 1514    A   C   G   U   C   U   G   G   U   C   A   G   C          
SEQRES  92 A 1514    A   U   G   G   C   C   C   U   U   A   C   G   G          
SEQRES  93 A 1514    C   C   U   G   G   G   C   G   A   C   A   C   A          
SEQRES  94 A 1514    C   G   U   G   C   U   A   C   A   A   U   G   C          
SEQRES  95 A 1514    C   C   A   C   U   A   C   A   A   A   G   C   G          
SEQRES  96 A 1514    A   U   G   C   C   A   C   C   C   G   G   C   A          
SEQRES  97 A 1514    A   C   G   G   G   G   A   G   C   U   A   A   U          
SEQRES  98 A 1514    C   G   C   A   A   A   A   A   G   G   U   G   G          
SEQRES  99 A 1514    G   C   C   C   A   G   U   U   C   G   G   A   U          
SEQRES  10 A 1514    U   G   G   G   G   U   C   U   G   C   A   A   C          
SEQRES  10 A 1514    C   C   G   A   C   C   C   C   A   U   G   A   A          
SEQRES  10 A 1514    G   C   C   G   G   A   A   U   C   G   C   U   A          
SEQRES  10 A 1514    G   U   A   A   U   C   G   C   G   G   A   U   C          
SEQRES  10 A 1514    A   G   C   C   A   U   G   C   C   G   C   G   G          
SEQRES  10 A 1514    U   G   A   A   U   A   C   G   U   U   C   C   C          
SEQRES  10 A 1514    G   G   G   C   C   U   U   G   U   A   C   A   C          
SEQRES  10 A 1514    A   C   C   G   C   C   C   G   U   C   A   C   G          
SEQRES  10 A 1514    C   C   A   U   G   G   G   A   G   C   G   G   G          
SEQRES  10 A 1514    C   U   C   U   A   C   C   C   G   A   A   G   U          
SEQRES  11 A 1514    C   G   C   C   G   G   G   A   G   C   C   U   A          
SEQRES  11 A 1514    C   G   G   G   C   A   G   G   C   G   C   C   G          
SEQRES  11 A 1514    A   G   G   G   U   A   G   G   G   C   C   C   G          
SEQRES  11 A 1514    U   G   A   C   U   G   G   G   G   C   G   A   A          
SEQRES  11 A 1514    G   U   C   G   U   A   A   C   A   A   G   G   U          
SEQRES  11 A 1514    A   G   C   U   G   U   A   C   C   G   G   A   A          
SEQRES  11 A 1514    G   G   U   G   C   G   G   C   U   G   G   A   U          
SEQRES  11 A 1514    C   A   C   C   U   C                                      
SEQRES   1 B  255  PRO VAL GLU ILE THR VAL LYS GLU LEU LEU GLU ALA GLY          
SEQRES   2 B  255  VAL HIS PHE GLY HIS GLU ARG LYS ARG TRP ASN PRO LYS          
SEQRES   3 B  255  PHE ALA ARG TYR ILE TYR ALA GLU ARG ASN GLY ILE HIS          
SEQRES   4 B  255  ILE ILE ASP LEU GLN LYS THR MET GLU GLU LEU GLU ARG          
SEQRES   5 B  255  THR PHE ARG PHE ILE GLU ASP LEU ALA MET ARG GLY GLY          
SEQRES   6 B  255  THR ILE LEU PHE VAL GLY THR LYS LYS GLN ALA GLN ASP          
SEQRES   7 B  255  ILE VAL ARG MET GLU ALA GLU ARG ALA GLY MET PRO TYR          
SEQRES   8 B  255  VAL ASN GLN ARG TRP LEU GLY GLY MET LEU THR ASN PHE          
SEQRES   9 B  255  LYS THR ILE SER GLN ARG VAL HIS ARG LEU GLU GLU LEU          
SEQRES  10 B  255  GLU ALA LEU PHE ALA SER PRO GLU ILE GLU GLU ARG PRO          
SEQRES  11 B  255  LYS LYS GLU GLN VAL ARG LEU LYS HIS GLU LEU GLU ARG          
SEQRES  12 B  255  LEU GLN LYS TYR LEU SER GLY PHE ARG LEU LEU LYS ARG          
SEQRES  13 B  255  LEU PRO ASP ALA ILE PHE VAL VAL ASP PRO THR LYS GLU          
SEQRES  14 B  255  ALA ILE ALA VAL ARG GLU ALA ARG LYS LEU PHE ILE PRO          
SEQRES  15 B  255  VAL ILE ALA LEU ALA ASP THR ASP SER ASP PRO ASP LEU          
SEQRES  16 B  255  VAL ASP TYR ILE ILE PRO GLY ASN ASP ASP ALA ILE ARG          
SEQRES  17 B  255  SER ILE GLN LEU ILE LEU SER ARG ALA VAL ASP LEU ILE          
SEQRES  18 B  255  ILE GLN ALA ARG GLY GLY VAL VAL GLU PRO SER PRO SER          
SEQRES  19 B  255  TYR ALA LEU VAL GLN GLU ALA GLU ALA THR GLU THR PRO          
SEQRES  20 B  255  GLU GLY GLU SER GLU VAL GLU ALA                              
SEQRES   1 C  238  GLY ASN LYS ILE HIS PRO ILE GLY PHE ARG LEU GLY ILE          
SEQRES   2 C  238  THR ARG ASP TRP GLU SER ARG TRP TYR ALA GLY LYS LYS          
SEQRES   3 C  238  GLN TYR ARG HIS LEU LEU LEU GLU ASP GLN ARG ILE ARG          
SEQRES   4 C  238  GLY LEU LEU GLU LYS GLU LEU TYR SER ALA GLY LEU ALA          
SEQRES   5 C  238  ARG VAL ASP ILE GLU ARG ALA ALA ASP ASN VAL ALA VAL          
SEQRES   6 C  238  THR VAL HIS VAL ALA LYS PRO GLY VAL VAL ILE GLY ARG          
SEQRES   7 C  238  GLY GLY GLU ARG ILE ARG VAL LEU ARG GLU GLU LEU ALA          
SEQRES   8 C  238  LYS LEU THR GLY LYS ASN VAL ALA LEU ASN VAL GLN GLU          
SEQRES   9 C  238  VAL GLN ASN PRO ASN LEU SER ALA PRO LEU VAL ALA GLN          
SEQRES  10 C  238  ARG VAL ALA GLU GLN ILE GLU ARG ARG PHE ALA VAL ARG          
SEQRES  11 C  238  ARG ALA ILE LYS GLN ALA VAL GLN ARG VAL MET GLU SER          
SEQRES  12 C  238  GLY ALA LYS GLY ALA LYS VAL ILE VAL SER GLY ARG ILE          
SEQRES  13 C  238  GLY GLY ALA GLU GLN ALA ARG THR GLU TRP ALA ALA GLN          
SEQRES  14 C  238  GLY ARG VAL PRO LEU HIS THR LEU ARG ALA ASN ILE ASP          
SEQRES  15 C  238  TYR GLY PHE ALA LEU ALA ARG THR THR TYR GLY VAL LEU          
SEQRES  16 C  238  GLY VAL LYS ALA TYR ILE PHE LEU GLY GLU VAL ILE GLY          
SEQRES  17 C  238  GLY GLN LYS PRO LYS ALA ARG PRO GLU LEU PRO LYS ALA          
SEQRES  18 C  238  GLU GLU ARG PRO ARG ARG ARG ARG PRO ALA VAL ARG VAL          
SEQRES  19 C  238  LYS LYS GLU GLU                                              
SEQRES   1 D  208  GLY ARG TYR ILE GLY PRO VAL CYS ARG LEU CYS ARG ARG          
SEQRES   2 D  208  GLU GLY VAL LYS LEU TYR LEU LYS GLY GLU ARG CYS TYR          
SEQRES   3 D  208  SER PRO LYS CYS ALA MET GLU ARG ARG PRO TYR PRO PRO          
SEQRES   4 D  208  GLY GLN HIS GLY GLN LYS ARG ALA ARG ARG PRO SER ASP          
SEQRES   5 D  208  TYR ALA VAL ARG LEU ARG GLU LYS GLN LYS LEU ARG ARG          
SEQRES   6 D  208  ILE TYR GLY ILE SER GLU ARG GLN PHE ARG ASN LEU PHE          
SEQRES   7 D  208  GLU GLU ALA SER LYS LYS LYS GLY VAL THR GLY SER VAL          
SEQRES   8 D  208  PHE LEU GLY LEU LEU GLU SER ARG LEU ASP ASN VAL VAL          
SEQRES   9 D  208  TYR ARG LEU GLY PHE ALA VAL SER ARG ARG GLN ALA ARG          
SEQRES  10 D  208  GLN LEU VAL ARG HIS GLY HIS ILE THR VAL ASN GLY ARG          
SEQRES  11 D  208  ARG VAL ASP LEU PRO SER TYR ARG VAL ARG PRO GLY ASP          
SEQRES  12 D  208  GLU ILE ALA VAL ALA GLU LYS SER ARG ASN LEU GLU LEU          
SEQRES  13 D  208  ILE ARG GLN ASN LEU GLU ALA MET LYS GLY ARG LYS VAL          
SEQRES  14 D  208  GLY PRO TRP LEU SER LEU ASP VAL GLU GLY MET LYS GLY          
SEQRES  15 D  208  LYS PHE LEU ARG LEU PRO ASP ARG GLU ASP LEU ALA LEU          
SEQRES  16 D  208  PRO VAL ASN GLU GLN LEU VAL ILE GLU PHE TYR SER ARG          
SEQRES   1 E  161  PRO GLU THR ASP PHE GLU GLU LYS MET ILE LEU ILE ARG          
SEQRES   2 E  161  ARG THR ALA ARG MET GLN ALA GLY GLY ARG ARG PHE ARG          
SEQRES   3 E  161  PHE GLY ALA LEU VAL VAL VAL GLY ASP ARG GLN GLY ARG          
SEQRES   4 E  161  VAL GLY LEU GLY PHE GLY LYS ALA PRO GLU VAL PRO LEU          
SEQRES   5 E  161  ALA VAL GLN LYS ALA GLY TYR TYR ALA ARG ARG ASN MET          
SEQRES   6 E  161  VAL GLU VAL PRO LEU GLN ASN GLY THR ILE PRO HIS GLU          
SEQRES   7 E  161  ILE GLU VAL GLU PHE GLY ALA SER LYS ILE VAL LEU LYS          
SEQRES   8 E  161  PRO ALA ALA PRO GLY THR GLY VAL ILE ALA GLY ALA VAL          
SEQRES   9 E  161  PRO ARG ALA ILE LEU GLU LEU ALA GLY VAL THR ASP ILE          
SEQRES  10 E  161  LEU THR LYS GLU LEU GLY SER ARG ASN PRO ILE ASN ILE          
SEQRES  11 E  161  ALA TYR ALA THR MET GLU ALA LEU ARG GLN LEU ARG THR          
SEQRES  12 E  161  LYS ALA ASP VAL GLU ARG LEU ARG LYS GLY GLU ALA HIS          
SEQRES  13 E  161  ALA GLN ALA GLN GLY                                          
SEQRES   1 F  101  MET ARG ARG TYR GLU VAL ASN ILE VAL LEU ASN PRO ASN          
SEQRES   2 F  101  LEU ASP GLN SER GLN LEU ALA LEU GLU LYS GLU ILE ILE          
SEQRES   3 F  101  GLN ARG ALA LEU GLU ASN TYR GLY ALA ARG VAL GLU LYS          
SEQRES   4 F  101  VAL GLU GLU LEU GLY LEU ARG ARG LEU ALA TYR PRO ILE          
SEQRES   5 F  101  ALA LYS ASP PRO GLN GLY TYR PHE LEU TRP TYR GLN VAL          
SEQRES   6 F  101  GLU MET PRO GLU ASP ARG VAL ASN ASP LEU ALA ARG GLU          
SEQRES   7 F  101  LEU ARG ILE ARG ASP ASN VAL ARG ARG VAL MET VAL VAL          
SEQRES   8 F  101  LYS SER GLN GLU PRO PHE LEU ALA ASN ALA                      
SEQRES   1 G  155  ALA ARG ARG ARG ARG ALA GLU VAL ARG GLN LEU GLN PRO          
SEQRES   2 G  155  ASP LEU VAL TYR GLY ASP VAL LEU VAL THR ALA PHE ILE          
SEQRES   3 G  155  ASN LYS ILE MET ARG ASP GLY LYS LYS ASN LEU ALA ALA          
SEQRES   4 G  155  ARG ILE PHE TYR ASP ALA CYS LYS ILE ILE GLN GLU LYS          
SEQRES   5 G  155  THR GLY GLN GLU PRO LEU LYS VAL PHE LYS GLN ALA VAL          
SEQRES   6 G  155  GLU ASN VAL LYS PRO ARG MET GLU VAL ARG SER ARG ARG          
SEQRES   7 G  155  VAL GLY GLY ALA ASN TYR GLN VAL PRO MET GLU VAL SER          
SEQRES   8 G  155  PRO ARG ARG GLN GLN SER LEU ALA LEU ARG TRP LEU VAL          
SEQRES   9 G  155  GLN ALA ALA ASN GLN ARG PRO GLU ARG ARG ALA ALA VAL          
SEQRES  10 G  155  ARG ILE ALA HIS GLU LEU MET ASP ALA ALA GLU GLY LYS          
SEQRES  11 G  155  GLY GLY ALA VAL LYS LYS LYS GLU ASP VAL GLU ARG MET          
SEQRES  12 G  155  ALA GLU ALA ASN ARG ALA TYR ALA HIS TYR ARG TRP              
SEQRES   1 H  138  MET LEU THR ASP PRO ILE ALA ASP MET LEU THR ARG ILE          
SEQRES   2 H  138  ARG ASN ALA THR ARG VAL TYR LYS GLU SER THR GLU VAL          
SEQRES   3 H  138  PRO ALA SER ARG PHE LYS GLU GLU ILE LEU LYS ILE LEU          
SEQRES   4 H  138  ALA ARG GLU GLY PHE ILE LYS GLY TYR GLU ARG VAL GLU          
SEQRES   5 H  138  VAL ASP GLY LYS PRO TYR LEU ARG ILE HIS LEU LYS TYR          
SEQRES   6 H  138  GLY PRO ARG ARG GLN GLY PRO ASP PRO ARG PRO GLU GLN          
SEQRES   7 H  138  VAL ILE LYS HIS ILE ARG ARG ILE SER ARG PRO GLY ARG          
SEQRES   8 H  138  ARG VAL TYR VAL GLY VAL LYS GLU ILE PRO ARG VAL ARG          
SEQRES   9 H  138  ARG GLY LEU GLY ILE ALA ILE LEU SER THR PRO LYS GLY          
SEQRES  10 H  138  VAL LEU THR ASP ARG GLU ALA ARG LYS LEU GLY VAL GLY          
SEQRES  11 H  138  GLY GLU LEU ILE CYS GLU VAL TRP                              
SEQRES   1 I  128  MET GLU GLN TYR TYR GLY THR GLY ARG ARG LYS GLU ALA          
SEQRES   2 I  128  VAL ALA ARG VAL PHE LEU ARG PRO GLY ASN GLY LYS VAL          
SEQRES   3 I  128  THR VAL ASN GLY GLN ASP PHE ASN GLU TYR PHE GLN GLY          
SEQRES   4 I  128  LEU VAL ARG ALA VAL ALA ALA LEU GLU PRO LEU ARG ALA          
SEQRES   5 I  128  VAL ASP ALA LEU GLY ARG PHE ASP ALA TYR ILE THR VAL          
SEQRES   6 I  128  ARG GLY GLY GLY LYS SER GLY GLN ILE ASP ALA ILE LYS          
SEQRES   7 I  128  LEU GLY ILE ALA ARG ALA LEU VAL GLN TYR ASN PRO ASP          
SEQRES   8 I  128  TYR ARG ALA LYS LEU LYS PRO LEU GLY PHE LEU THR ARG          
SEQRES   9 I  128  ASP ALA ARG VAL VAL GLU ARG LYS LYS TYR GLY LYS HIS          
SEQRES  10 I  128  LYS ALA ARG ARG ALA PRO GLN TYR SER LYS ARG                  
SEQRES   1 J  104  PRO LYS ILE ARG ILE LYS LEU ARG GLY PHE ASP HIS LYS          
SEQRES   2 J  104  THR LEU ASP ALA SER ALA GLN LYS ILE VAL GLU ALA ALA          
SEQRES   3 J  104  ARG ARG SER GLY ALA GLN VAL SER GLY PRO ILE PRO LEU          
SEQRES   4 J  104  PRO THR ARG VAL ARG ARG PHE THR VAL ILE ARG GLY PRO          
SEQRES   5 J  104  PHE LYS HIS LYS ASP SER ARG GLU HIS PHE GLU LEU ARG          
SEQRES   6 J  104  THR HIS ASN ARG LEU VAL ASP ILE ILE ASN PRO ASN ARG          
SEQRES   7 J  104  LYS THR ILE GLU GLN LEU MET THR LEU ASP LEU PRO THR          
SEQRES   8 J  104  GLY VAL GLU ILE GLU ILE LYS THR VAL GLY GLY GLY ARG          
SEQRES   1 K  128  ALA LYS LYS PRO SER LYS LYS LYS VAL LYS ARG GLN VAL          
SEQRES   2 K  128  ALA SER GLY ARG ALA TYR ILE HIS ALA SER TYR ASN ASN          
SEQRES   3 K  128  THR ILE VAL THR ILE THR ASP PRO ASP GLY ASN PRO ILE          
SEQRES   4 K  128  THR TRP SER SER GLY GLY VAL ILE GLY TYR LYS GLY SER          
SEQRES   5 K  128  ARG LYS GLY THR PRO TYR ALA ALA GLN LEU ALA ALA LEU          
SEQRES   6 K  128  ASP ALA ALA LYS LYS ALA MET ALA TYR GLY MET GLN SER          
SEQRES   7 K  128  VAL ASP VAL ILE VAL ARG GLY THR GLY ALA GLY ARG GLU          
SEQRES   8 K  128  GLN ALA ILE ARG ALA LEU GLN ALA SER GLY LEU GLN VAL          
SEQRES   9 K  128  LYS SER ILE VAL ASP ASP THR PRO VAL PRO HIS ASN GLY          
SEQRES  10 K  128  CYS ARG PRO LYS LYS LYS PHE ARG LYS ALA SER                  
SEQRES   1 L  131  PRO THR ILE ASN GLN LEU VAL ARG LYS GLY ARG GLU LYS          
SEQRES   2 L  131  VAL ARG LYS LYS SER LYS VAL PRO ALA LEU LYS GLY ALA          
SEQRES   3 L  131  PRO PHE ARG ARG GLY VAL CYS THR VAL VAL ARG THR VAL          
SEQRES   4 L  131  THR PRO LYS LYS PRO ASN SER ALA LEU ARG LYS VAL ALA          
SEQRES   5 L  131  LYS VAL ARG LEU THR SER GLY TYR GLU VAL THR ALA TYR          
SEQRES   6 L  131  ILE PRO GLY GLU GLY HIS ASN LEU GLN GLU HIS SER VAL          
SEQRES   7 L  131  VAL LEU ILE ARG GLY GLY ARG VAL LYS ASP LEU PRO GLY          
SEQRES   8 L  131  VAL ARG TYR HIS ILE VAL ARG GLY VAL TYR ASP ALA ALA          
SEQRES   9 L  131  GLY VAL LYS ASP ARG LYS LYS SER ARG SER LYS TYR GLY          
SEQRES  10 L  131  THR LYS LYS PRO LYS GLU ALA ALA LYS THR ALA ALA LYS          
SEQRES  11 L  131  LYS                                                          
SEQRES   1 M  125  ALA ARG ILE ALA GLY VAL GLU ILE PRO ARG ASN LYS ARG          
SEQRES   2 M  125  VAL ASP VAL ALA LEU THR TYR ILE TYR GLY ILE GLY LYS          
SEQRES   3 M  125  ALA ARG ALA LYS GLU ALA LEU GLU LYS THR GLY ILE ASN          
SEQRES   4 M  125  PRO ALA THR ARG VAL LYS ASP LEU THR GLU ALA GLU VAL          
SEQRES   5 M  125  VAL ARG LEU ARG GLU TYR VAL GLU ASN THR TRP LYS LEU          
SEQRES   6 M  125  GLU GLY GLU LEU ARG ALA GLU VAL ALA ALA ASN ILE LYS          
SEQRES   7 M  125  ARG LEU MET ASP ILE GLY CYS TYR ARG GLY LEU ARG HIS          
SEQRES   8 M  125  ARG ARG GLY LEU PRO VAL ARG GLY GLN ARG THR ARG THR          
SEQRES   9 M  125  ASN ALA ARG THR ARG LYS GLY PRO ARG LYS THR VAL ALA          
SEQRES  10 M  125  GLY LYS LYS LYS ALA PRO ARG LYS                              
SEQRES   1 N   60  ALA ARG LYS ALA LEU ILE GLU LYS ALA LYS ARG THR PRO          
SEQRES   2 N   60  LYS PHE LYS VAL ARG ALA TYR THR ARG CYS VAL ARG CYS          
SEQRES   3 N   60  GLY ARG ALA ARG SER VAL TYR ARG PHE PHE GLY LEU CYS          
SEQRES   4 N   60  ARG ILE CYS LEU ARG GLU LEU ALA HIS LYS GLY GLN LEU          
SEQRES   5 N   60  PRO GLY VAL ARG LYS ALA SER TRP                              
SEQRES   1 O   88  PRO ILE THR LYS GLU GLU LYS GLN LYS VAL ILE GLN GLU          
SEQRES   2 O   88  PHE ALA ARG PHE PRO GLY ASP THR GLY SER THR GLU VAL          
SEQRES   3 O   88  GLN VAL ALA LEU LEU THR LEU ARG ILE ASN ARG LEU SER          
SEQRES   4 O   88  GLU HIS LEU LYS VAL HIS LYS LYS ASP HIS HIS SER HIS          
SEQRES   5 O   88  ARG GLY LEU LEU MET MET VAL GLY GLN ARG ARG ARG LEU          
SEQRES   6 O   88  LEU ARG TYR LEU GLN ARG GLU ASP PRO GLU ARG TYR ARG          
SEQRES   7 O   88  ALA LEU ILE GLU LYS LEU GLY ILE ARG GLY                      
SEQRES   1 P   88  MET VAL LYS ILE ARG LEU ALA ARG PHE GLY SER LYS HIS          
SEQRES   2 P   88  ASN PRO HIS TYR ARG ILE VAL VAL THR ASP ALA ARG ARG          
SEQRES   3 P   88  LYS ARG ASP GLY LYS TYR ILE GLU LYS ILE GLY TYR TYR          
SEQRES   4 P   88  ASP PRO ARG LYS THR THR PRO ASP TRP LEU LYS VAL ASP          
SEQRES   5 P   88  VAL GLU ARG ALA ARG TYR TRP LEU SER VAL GLY ALA GLN          
SEQRES   6 P   88  PRO THR ASP THR ALA ARG ARG LEU LEU ARG GLN ALA GLY          
SEQRES   7 P   88  VAL PHE ARG GLN GLU ALA ARG GLU GLY ALA                      
SEQRES   1 Q  104  PRO LYS LYS VAL LEU THR GLY VAL VAL VAL SER ASP LYS          
SEQRES   2 Q  104  MET GLN LYS THR VAL THR VAL LEU VAL GLU ARG GLN PHE          
SEQRES   3 Q  104  PRO HIS PRO LEU TYR GLY LYS VAL ILE LYS ARG SER LYS          
SEQRES   4 Q  104  LYS TYR LEU ALA HIS ASP PRO GLU GLU ARG TYR LYS VAL          
SEQRES   5 Q  104  GLY ASP VAL VAL GLU ILE ILE GLU ALA ARG PRO ILE SER          
SEQRES   6 Q  104  LYS ARG LYS ARG PHE ARG VAL LEU ARG LEU VAL GLU GLU          
SEQRES   7 Q  104  GLY ARG LEU ASP LEU VAL GLU LYS TYR LEU VAL ARG ARG          
SEQRES   8 Q  104  GLN ASN TYR ALA SER LEU SER LYS ARG GLY GLY LYS ALA          
SEQRES   1 R   87  SER THR LYS ASN ALA LYS PRO LYS LYS GLU ALA GLN ARG          
SEQRES   2 R   87  ARG PRO SER ARG LYS ALA LYS VAL LYS ALA THR LEU GLY          
SEQRES   3 R   87  GLU PHE ASP LEU ARG ASP TYR ARG ASN VAL GLU VAL LEU          
SEQRES   4 R   87  LYS ARG PHE LEU SER GLU THR GLY LYS ILE LEU PRO ARG          
SEQRES   5 R   87  ARG ARG THR GLY LEU SER GLY LYS GLU GLN ARG ILE LEU          
SEQRES   6 R   87  ALA LYS THR ILE LYS ARG ALA ARG ILE LEU GLY LEU LEU          
SEQRES   7 R   87  PRO PHE THR GLU LYS LEU VAL ARG LYS                          
SEQRES   1 S   92  PRO ARG SER LEU LYS LYS GLY VAL PHE VAL ASP ASP HIS          
SEQRES   2 S   92  LEU LEU GLU LYS VAL LEU GLU LEU ASN ALA LYS GLY GLU          
SEQRES   3 S   92  LYS ARG LEU ILE LYS THR TRP SER ARG ARG SER THR ILE          
SEQRES   4 S   92  VAL PRO GLU MET VAL GLY HIS THR ILE ALA VAL TYR ASN          
SEQRES   5 S   92  GLY LYS GLN HIS VAL PRO VAL TYR ILE THR GLU ASN MET          
SEQRES   6 S   92  VAL GLY HIS LYS LEU GLY GLU PHE ALA PRO THR ARG THR          
SEQRES   7 S   92  TYR ARG GLY HIS GLY LYS GLU ALA LYS ALA THR LYS LYS          
SEQRES   8 S   92  LYS                                                          
SEQRES   1 T  105  ALA GLN LYS LYS PRO LYS ARG ASN LEU SER ALA LEU LYS          
SEQRES   2 T  105  ARG HIS ARG GLN SER LEU LYS ARG ARG LEU ARG ASN LYS          
SEQRES   3 T  105  ALA LYS LYS SER ALA ILE LYS THR LEU SER LYS LYS ALA          
SEQRES   4 T  105  ILE GLN LEU ALA GLN GLU GLY LYS ALA GLU GLU ALA LEU          
SEQRES   5 T  105  LYS ILE MET ARG LYS ALA GLU SER LEU ILE ASP LYS ALA          
SEQRES   6 T  105  ALA LYS GLY SER THR LEU HIS LYS ASN ALA ALA ALA ARG          
SEQRES   7 T  105  ARG LYS SER ARG LEU MET ARG LYS VAL ARG GLN LEU LEU          
SEQRES   8 T  105  GLU ALA ALA GLY ALA PRO LEU ILE GLY GLY GLY LEU SER          
SEQRES   9 T  105  ALA                                                          
SEQRES   1 U   26  GLY LYS GLY ASP ARG ARG THR ARG ARG GLY LYS ILE TRP          
SEQRES   2 U   26  ARG GLY THR TYR GLY LYS TYR ARG PRO ARG LYS LYS LYS          
HET     MG      1       1                                                       
HET     MG      2       1                                                       
HET     MG      3       1                                                       
HET     MG      4       1                                                       
HET     MG      5       1                                                       
HET     MG      6       1                                                       
HET     MG      7       1                                                       
HET     MG      8       1                                                       
HET     MG      9       1                                                       
HET     MG     10       1                                                       
HET     MG     11       1                                                       
HET     MG     12       1                                                       
HET     MG     13       1                                                       
HET     MG     14       1                                                       
HET     MG     15       1                                                       
HET     MG     16       1                                                       
HET     MG     17       1                                                       
HET     MG     18       1                                                       
HET     MG     19       1                                                       
HET     MG     20       1                                                       
HET     MG     21       1                                                       
HET     MG     22       1                                                       
HET     MG     23       1                                                       
HET     MG     24       1                                                       
HET     MG     25       1                                                       
HET     MG     26       1                                                       
HET     MG     27       1                                                       
HET     MG     28       1                                                       
HET     MG     29       1                                                       
HET     MG     30       1                                                       
HET     MG     31       1                                                       
HET     MG     32       1                                                       
HET     MG     33       1                                                       
HET     MG     34       1                                                       
HET     MG     35       1                                                       
HET     MG     36       1                                                       
HET     MG     37       1                                                       
HET     MG     38       1                                                       
HET     MG     39       1                                                       
HET     MG     40       1                                                       
HET     MG     41       1                                                       
HET     MG     42       1                                                       
HET     MG     43       1                                                       
HET     MG     44       1                                                       
HET     MG     45       1                                                       
HET     MG     46       1                                                       
HET     MG     47       1                                                       
HET     MG     48       1                                                       
HET     MG     49       1                                                       
HET     MG     50       1                                                       
HET     MG     51       1                                                       
HET     MG     52       1                                                       
HET     MG     53       1                                                       
HET     MG     54       1                                                       
HET     MG     55       1                                                       
HET     MG     56       1                                                       
HET     MG     57       1                                                       
HET     MG     58       1                                                       
HET     MG     59       1                                                       
HET     MG     60       1                                                       
HET     MG     61       1                                                       
HET     MG     62       1                                                       
HET     MG     63       1                                                       
HET     MG     64       1                                                       
HET     MG     65       1                                                       
HET     MG     66       1                                                       
HET     MG     67       1                                                       
HET     MG     68       1                                                       
HET     MG     69       1                                                       
HET     MG     70       1                                                       
HET     MG     71       1                                                       
HET     MG     72       1                                                       
HET     MG     73       1                                                       
HET     MG     74       1                                                       
HET     MG     75       1                                                       
HET     ZN     76       1                                                       
HET     ZN     77       1                                                       
HET    WO2   1001      82                                                       
HET    WO2   1002      82                                                       
HET    WO2   1003      82                                                       
HET    WO2   1004      82                                                       
HET    WO2   1005      82                                                       
HET    WO2   1006      82                                                       
HET    WO2   1007      82                                                       
HET    WO2   1008      82                                                       
HET    WO2   1009      82                                                       
HET    WO2   1010      82                                                       
HET    WO2   1011      82                                                       
HET    WO2   1012      82                                                       
HET    WO2   1013      82                                                       
HET    WO2   1014      82                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM      ZN ZINC ION                                                         
HETNAM     WO2 OCTADECATUNGSTENYL DIPHOSPHATE                                   
FORMUL  22   MG    75(MG 2+)                                                    
FORMUL  97   ZN    2(ZN 2+)                                                     
FORMUL  99  WO2    14(O62 P2 W18)                                               
CRYST1  406.300  406.300  173.100  90.00  90.00  90.00 P 41 21 2     8          
ATOM  39620  N   LYS K   7      12.622   6.222  17.958  1.00157.77           N  
ATOM  39621  CA  LYS K   7      11.722   6.262  16.766  1.00157.77           C  
ATOM  39622  C   LYS K   7      10.311   5.718  17.016  1.00157.77           C  
ATOM  39623  O   LYS K   7       9.333   6.472  16.953  1.00157.77           O  
ATOM  39624  CB  LYS K   7      12.350   5.498  15.584  1.00157.77           C  
ATOM  39625  N   LYS K   8      10.222   4.413  17.286  1.00 95.01           N  
ATOM  39626  CA  LYS K   8       8.951   3.712  17.528  1.00 95.01           C  
ATOM  39627  C   LYS K   8       8.443   3.043  16.203  1.00 95.01           C  
ATOM  39628  O   LYS K   8       8.894   1.933  15.856  1.00 95.01           O  
ATOM  39629  CB  LYS K   8       7.929   4.694  18.117  1.00 95.01           C  
ATOM  39630  N   LYS K   9       7.523   3.696  15.470  1.00 97.42           N  
ATOM  39631  CA  LYS K   9       7.007   3.171  14.180  1.00 97.42           C  
ATOM  39632  C   LYS K   9       7.474   4.114  13.047  1.00 97.42           C  
ATOM  39633  O   LYS K   9       7.308   3.816  11.855  1.00 97.42           O  
ATOM  39634  CB  LYS K   9       5.457   3.069  14.181  1.00 97.42           C  
ATOM  39635  N   VAL K  10       8.058   5.246  13.454  1.00108.08           N  
ATOM  39636  CA  VAL K  10       8.615   6.298  12.584  1.00108.08           C  
ATOM  39637  C   VAL K  10       7.846   6.741  11.334  1.00108.08           C  
ATOM  39638  O   VAL K  10       7.637   5.975  10.384  1.00108.08           O  
ATOM  39639  CB  VAL K  10      10.093   5.965  12.163  1.00108.08           C  
ATOM  39640  N   LYS K  11       7.446   8.009  11.350  1.00163.22           N  
ATOM  39641  CA  LYS K  11       6.723   8.620  10.246  1.00163.22           C  
ATOM  39642  C   LYS K  11       7.792   9.130   9.283  1.00163.22           C  
ATOM  39643  O   LYS K  11       8.266  10.263   9.401  1.00163.22           O  
ATOM  39644  CB  LYS K  11       5.858   9.785  10.748  1.00163.22           C  
ATOM  39645  N   ARG K  12       8.170   8.273   8.342  1.00201.43           N  
ATOM  39646  CA  ARG K  12       9.196   8.586   7.354  1.00201.43           C  
ATOM  39647  C   ARG K  12       8.652   9.363   6.156  1.00201.43           C  
ATOM  39648  O   ARG K  12       7.612   9.017   5.592  1.00201.43           O  
ATOM  39649  CB  ARG K  12       9.843   7.284   6.882  1.00201.43           C  
ATOM  39650  N   GLN K  13       9.369  10.417   5.774  1.00113.70           N  
ATOM  39651  CA  GLN K  13       8.982  11.257   4.645  1.00113.70           C  
ATOM  39652  C   GLN K  13       9.638  10.731   3.378  1.00113.70           C  
ATOM  39653  O   GLN K  13      10.844  10.462   3.361  1.00113.70           O  
ATOM  39654  CB  GLN K  13       9.430  12.699   4.883  1.00113.70           C  
ATOM  39655  N   VAL K  14       8.847  10.587   2.317  1.00116.25           N  
ATOM  39656  CA  VAL K  14       9.366  10.088   1.051  1.00116.25           C  
ATOM  39657  C   VAL K  14       9.108  11.069  -0.088  1.00116.25           C  
ATOM  39658  O   VAL K  14       9.900  11.164  -1.025  1.00116.25           O  
ATOM  39659  CB  VAL K  14       8.745   8.731   0.697  1.00116.25           C  
ATOM  39660  N   ALA K  15       7.997  11.792  -0.002  1.00118.19           N  
ATOM  39661  CA  ALA K  15       7.636  12.786  -1.008  1.00118.19           C  
ATOM  39662  C   ALA K  15       7.385  12.224  -2.415  1.00118.19           C  
ATOM  39663  O   ALA K  15       6.425  12.620  -3.077  1.00118.19           O  
ATOM  39664  CB  ALA K  15       8.703  13.887  -1.059  1.00118.19           C  
ATOM  39665  N   SER K  16       8.236  11.306  -2.873  1.00130.88           N  
ATOM  39666  CA  SER K  16       8.077  10.718  -4.204  1.00130.88           C  
ATOM  39667  C   SER K  16       8.422   9.232  -4.223  1.00130.88           C  
ATOM  39668  O   SER K  16       9.198   8.758  -3.398  1.00130.88           O  
ATOM  39669  CB  SER K  16       8.968  11.442  -5.215  1.00130.88           C  
ATOM  39670  N   GLY K  17       7.847   8.504  -5.175  1.00100.79           N  
ATOM  39671  CA  GLY K  17       8.117   7.079  -5.282  1.00100.79           C  
ATOM  39672  C   GLY K  17       7.455   6.430  -6.487  1.00100.79           C  
ATOM  39673  O   GLY K  17       7.186   7.088  -7.496  1.00100.79           O  
ATOM  39674  N   ARG K  18       7.200   5.126  -6.380  1.00 97.28           N  
ATOM  39675  CA  ARG K  18       6.559   4.368  -7.451  1.00 97.28           C  
ATOM  39676  C   ARG K  18       5.097   4.088  -7.118  1.00 97.28           C  
ATOM  39677  O   ARG K  18       4.645   4.285  -5.983  1.00 97.28           O  
ATOM  39678  CB  ARG K  18       7.257   3.023  -7.670  1.00 97.28           C  
ATOM  39679  N   ALA K  19       4.375   3.609  -8.127  1.00 76.47           N  
ATOM  39680  CA  ALA K  19       2.964   3.259  -8.011  1.00 76.47           C  
ATOM  39681  C   ALA K  19       2.682   2.137  -9.004  1.00 76.47           C  
ATOM  39682  O   ALA K  19       2.013   2.340 -10.017  1.00 76.47           O  
ATOM  39683  CB  ALA K  19       2.084   4.467  -8.319  1.00 76.47           C  
ATOM  39684  N   TYR K  20       3.221   0.959  -8.723  1.00 82.68           N  
ATOM  39685  CA  TYR K  20       3.012  -0.186  -9.586  1.00 82.68           C  
ATOM  39686  C   TYR K  20       1.543  -0.611  -9.535  1.00 82.68           C  
ATOM  39687  O   TYR K  20       0.920  -0.628  -8.473  1.00 82.68           O  
ATOM  39688  CB  TYR K  20       3.915  -1.333  -9.147  1.00 82.68           C  
ATOM  39689  N   ILE K  21       0.980  -0.942 -10.687  1.00 69.75           N  
ATOM  39690  CA  ILE K  21      -0.410  -1.350 -10.723  1.00 69.75           C  
ATOM  39691  C   ILE K  21      -0.561  -2.660 -11.472  1.00 69.75           C  
ATOM  39692  O   ILE K  21      -0.139  -2.787 -12.614  1.00 69.75           O  
ATOM  39693  CB  ILE K  21      -1.248  -0.291 -11.395  1.00 69.75           C  
ATOM  39694  N   HIS K  22      -1.152  -3.648 -10.822  1.00 78.71           N  
ATOM  39695  CA  HIS K  22      -1.333  -4.934 -11.461  1.00 78.71           C  
ATOM  39696  C   HIS K  22      -2.806  -5.152 -11.624  1.00 78.71           C  
ATOM  39697  O   HIS K  22      -3.548  -5.203 -10.639  1.00 78.71           O  
ATOM  39698  CB  HIS K  22      -0.729  -6.033 -10.608  1.00 78.71           C  
ATOM  39699  N   ALA K  23      -3.218  -5.251 -12.886  1.00 62.10           N  
ATOM  39700  CA  ALA K  23      -4.607  -5.470 -13.250  1.00 62.10           C  
ATOM  39701  C   ALA K  23      -4.719  -6.776 -14.015  1.00 62.10           C  
ATOM  39702  O   ALA K  23      -3.810  -7.163 -14.734  1.00 62.10           O  
ATOM  39703  CB  ALA K  23      -5.107  -4.315 -14.106  1.00 62.10           C  
ATOM  39704  N   SER K  24      -5.834  -7.459 -13.841  1.00 66.80           N  
ATOM  39705  CA  SER K  24      -6.063  -8.710 -14.533  1.00 66.80           C  
ATOM  39706  C   SER K  24      -7.483  -9.192 -14.291  1.00 66.80           C  
ATOM  39707  O   SER K  24      -8.196  -8.683 -13.426  1.00 66.80           O  
ATOM  39708  CB  SER K  24      -5.055  -9.763 -14.087  1.00 66.80           C  
ATOM  39709  N   TYR K  25      -7.889 -10.185 -15.063  1.00 85.42           N  
ATOM  39710  CA  TYR K  25      -9.235 -10.699 -14.962  1.00 85.42           C  
ATOM  39711  C   TYR K  25      -9.557 -11.304 -13.617  1.00 85.42           C  
ATOM  39712  O   TYR K  25     -10.360 -12.230 -13.532  1.00 85.42           O  
ATOM  39713  CB  TYR K  25      -9.479 -11.731 -16.056  1.00 85.42           C  
ATOM  39714  N   ASN K  26      -8.959 -10.789 -12.556  1.00 98.00           N  
ATOM  39715  CA  ASN K  26      -9.256 -11.360 -11.259  1.00 98.00           C  
ATOM  39716  C   ASN K  26      -9.228 -10.392 -10.090  1.00 98.00           C  
ATOM  39717  O   ASN K  26     -10.084 -10.461  -9.203  1.00 98.00           O  
ATOM  39718  CB  ASN K  26      -8.314 -12.535 -10.989  1.00 98.00           C  
ATOM  39719  N   ASN K  27      -8.253  -9.493 -10.089  1.00 83.40           N  
ATOM  39720  CA  ASN K  27      -8.125  -8.534  -9.010  1.00 83.40           C  
ATOM  39721  C   ASN K  27      -7.152  -7.461  -9.443  1.00 83.40           C  
ATOM  39722  O   ASN K  27      -6.355  -7.683 -10.346  1.00 83.40           O  
ATOM  39723  CB  ASN K  27      -7.589  -9.231  -7.769  1.00 83.40           C  
ATOM  39724  N   THR K  28      -7.211  -6.299  -8.803  1.00 80.87           N  
ATOM  39725  CA  THR K  28      -6.307  -5.207  -9.138  1.00 80.87           C  
ATOM  39726  C   THR K  28      -5.484  -4.769  -7.941  1.00 80.87           C  
ATOM  39727  O   THR K  28      -6.017  -4.234  -6.981  1.00 80.87           O  
ATOM  39728  CB  THR K  28      -7.077  -4.002  -9.654  1.00 80.87           C  
ATOM  39729  N   ILE K  29      -4.181  -4.996  -8.010  1.00 60.67           N  
ATOM  39730  CA  ILE K  29      -3.275  -4.632  -6.932  1.00 60.67           C  
ATOM  39731  C   ILE K  29      -2.427  -3.403  -7.250  1.00 60.67           C  
ATOM  39732  O   ILE K  29      -1.624  -3.417  -8.181  1.00 60.67           O  
ATOM  39733  CB  ILE K  29      -2.304  -5.785  -6.608  1.00 60.67           C  
ATOM  39734  N   VAL K  30      -2.610  -2.343  -6.471  1.00 80.51           N  
ATOM  39735  CA  VAL K  30      -1.833  -1.127  -6.639  1.00 80.51           C  
ATOM  39736  C   VAL K  30      -0.755  -1.216  -5.588  1.00 80.51           C  
ATOM  39737  O   VAL K  30      -0.913  -1.907  -4.590  1.00 80.51           O  
ATOM  39738  CB  VAL K  30      -2.651   0.140  -6.362  1.00 80.51           C  
ATOM  39739  N   THR K  31       0.341  -0.509  -5.807  1.00 76.10           N  
ATOM  39740  CA  THR K  31       1.452  -0.531  -4.865  1.00 76.10           C  
ATOM  39741  C   THR K  31       2.153   0.825  -4.790  1.00 76.10           C  
ATOM  39742  O   THR K  31       2.125   1.604  -5.738  1.00 76.10           O  
ATOM  39743  CB  THR K  31       2.515  -1.565  -5.286  1.00 76.10           C  
ATOM  39744  N   ILE K  32       2.774   1.110  -3.657  1.00 68.41           N  
ATOM  39745  CA  ILE K  32       3.507   2.344  -3.522  1.00 68.41           C  
ATOM  39746  C   ILE K  32       4.900   1.941  -3.124  1.00 68.41           C  
ATOM  39747  O   ILE K  32       5.094   0.994  -2.373  1.00 68.41           O  
ATOM  39748  CB  ILE K  32       2.892   3.248  -2.478  1.00 68.41           C  
ATOM  39749  N   THR K  33       5.877   2.664  -3.641  1.00 88.04           N  
ATOM  39750  CA  THR K  33       7.264   2.343  -3.376  1.00 88.04           C  
ATOM  39751  C   THR K  33       8.107   3.616  -3.322  1.00 88.04           C  
ATOM  39752  O   THR K  33       7.601   4.718  -3.559  1.00 88.04           O  
ATOM  39753  CB  THR K  33       7.780   1.380  -4.492  1.00 88.04           C  
ATOM  39754  N   ASP K  34       9.386   3.459  -2.990  1.00 90.01           N  
ATOM  39755  CA  ASP K  34      10.313   4.582  -2.920  1.00 90.01           C  
ATOM  39756  C   ASP K  34      10.995   4.679  -4.276  1.00 90.01           C  
ATOM  39757  O   ASP K  34      11.100   3.690  -4.993  1.00 90.01           O  
ATOM  39758  CB  ASP K  34      11.368   4.345  -1.834  1.00 90.01           C  
ATOM  39759  N   PRO K  35      11.484   5.867  -4.642  1.00 87.06           N  
ATOM  39760  CA  PRO K  35      12.152   6.036  -5.934  1.00 87.06           C  
ATOM  39761  C   PRO K  35      13.197   4.963  -6.276  1.00 87.06           C  
ATOM  39762  O   PRO K  35      13.749   4.949  -7.374  1.00 87.06           O  
ATOM  39763  CB  PRO K  35      12.743   7.442  -5.830  1.00 87.06           C  
ATOM  39764  N   ASP K  36      13.466   4.062  -5.342  1.00 99.31           N  
ATOM  39765  CA  ASP K  36      14.423   3.002  -5.603  1.00 99.31           C  
ATOM  39766  C   ASP K  36      13.798   1.641  -5.460  1.00 99.31           C  
ATOM  39767  O   ASP K  36      14.385   0.739  -4.871  1.00 99.31           O  
ATOM  39768  CB  ASP K  36      15.615   3.116  -4.668  1.00 99.31           C  
ATOM  39769  N   GLY K  37      12.596   1.498  -6.000  1.00 94.33           N  
ATOM  39770  CA  GLY K  37      11.904   0.226  -5.932  1.00 94.33           C  
ATOM  39771  C   GLY K  37      11.292  -0.132  -4.589  1.00 94.33           C  
ATOM  39772  O   GLY K  37      10.109  -0.452  -4.516  1.00 94.33           O  
ATOM  39773  N   ASN K  38      12.091  -0.092  -3.528  1.00 85.50           N  
ATOM  39774  CA  ASN K  38      11.611  -0.438  -2.195  1.00 85.50           C  
ATOM  39775  C   ASN K  38      10.180   0.050  -1.979  1.00 85.50           C  
ATOM  39776  O   ASN K  38       9.863   1.203  -2.261  1.00 85.50           O  
ATOM  39777  CB  ASN K  38      12.545   0.158  -1.140  1.00 85.50           C  
ATOM  39778  N   PRO K  39       9.290  -0.837  -1.494  1.00 83.58           N  
ATOM  39779  CA  PRO K  39       7.886  -0.505  -1.242  1.00 83.58           C  
ATOM  39780  C   PRO K  39       7.575   0.148   0.105  1.00 83.58           C  
ATOM  39781  O   PRO K  39       8.305   0.011   1.088  1.00 83.58           O  
ATOM  39782  CB  PRO K  39       7.196  -1.846  -1.382  1.00 83.58           C  
ATOM  39783  N   ILE K  40       6.457   0.855   0.128  1.00 75.27           N  
ATOM  39784  CA  ILE K  40       5.992   1.538   1.314  1.00 75.27           C  
ATOM  39785  C   ILE K  40       4.691   0.899   1.772  1.00 75.27           C  
ATOM  39786  O   ILE K  40       4.620   0.363   2.873  1.00 75.27           O  
ATOM  39787  CB  ILE K  40       5.772   3.010   1.000  1.00 75.27           C  
ATOM  39788  N   THR K  41       3.671   0.942   0.919  1.00 83.25           N  
ATOM  39789  CA  THR K  41       2.379   0.364   1.254  1.00 83.25           C  
ATOM  39790  C   THR K  41       1.550  -0.048   0.053  1.00 83.25           C  
ATOM  39791  O   THR K  41       1.474   0.671  -0.938  1.00 83.25           O  
ATOM  39792  CB  THR K  41       1.546   1.342   2.061  1.00 83.25           C  
ATOM  39793  N   TRP K  42       0.915  -1.207   0.157  1.00 87.77           N  
ATOM  39794  CA  TRP K  42       0.075  -1.692  -0.919  1.00 87.77           C  
ATOM  39795  C   TRP K  42      -1.303  -2.002  -0.369  1.00 87.77           C  
ATOM  39796  O   TRP K  42      -1.446  -2.425   0.779  1.00 87.77           O  
ATOM  39797  CB  TRP K  42       0.623  -2.975  -1.553  1.00 87.77           C  
ATOM  39798  N   SER K  43      -2.314  -1.761  -1.196  1.00 84.42           N  
ATOM  39799  CA  SER K  43      -3.700  -2.037  -0.847  1.00 84.42           C  
ATOM  39800  C   SER K  43      -4.133  -2.944  -1.979  1.00 84.42           C  
ATOM  39801  O   SER K  43      -3.286  -3.589  -2.578  1.00 84.42           O  
ATOM  39802  CB  SER K  43      -4.543  -0.771  -0.858  1.00 84.42           C  
ATOM  39803  N   SER K  44      -5.426  -3.003  -2.283  1.00 62.63           N  
ATOM  39804  CA  SER K  44      -5.901  -3.865  -3.366  1.00 62.63           C  
ATOM  39805  C   SER K  44      -7.407  -3.795  -3.501  1.00 62.63           C  
ATOM  39806  O   SER K  44      -8.012  -2.747  -3.339  1.00 62.63           O  
ATOM  39807  CB  SER K  44      -5.500  -5.329  -3.115  1.00 62.63           C  
ATOM  39808  N   GLY K  45      -8.008  -4.922  -3.831  1.00 58.52           N  
ATOM  39809  CA  GLY K  45      -9.443  -4.964  -3.930  1.00 58.52           C  
ATOM  39810  C   GLY K  45      -9.782  -5.779  -2.717  1.00 58.52           C  
ATOM  39811  O   GLY K  45     -10.823  -5.610  -2.099  1.00 58.52           O  
ATOM  39812  N   GLY K  46      -8.856  -6.663  -2.374  1.00 83.61           N  
ATOM  39813  CA  GLY K  46      -9.030  -7.521  -1.225  1.00 83.61           C  
ATOM  39814  C   GLY K  46      -8.961  -6.716   0.048  1.00 83.61           C  
ATOM  39815  O   GLY K  46      -9.776  -6.906   0.946  1.00 83.61           O  
ATOM  39816  N   VAL K  47      -7.992  -5.811   0.128  1.00101.10           N  
ATOM  39817  CA  VAL K  47      -7.830  -4.974   1.308  1.00101.10           C  
ATOM  39818  C   VAL K  47      -9.129  -4.302   1.734  1.00101.10           C  
ATOM  39819  O   VAL K  47      -9.347  -4.063   2.923  1.00101.10           O  
ATOM  39820  CB  VAL K  47      -6.791  -3.904   1.068  1.00101.10           C  
ATOM  39821  N   ILE K  48      -9.978  -3.985   0.762  1.00 76.66           N  
ATOM  39822  CA  ILE K  48     -11.272  -3.373   1.039  1.00 76.66           C  
ATOM  39823  C   ILE K  48     -12.346  -4.404   0.736  1.00 76.66           C  
ATOM  39824  O   ILE K  48     -12.421  -4.900  -0.386  1.00 76.66           O  
ATOM  39825  CB  ILE K  48     -11.552  -2.227   0.127  1.00 76.66           C  
ATOM  39826  N   GLY K  49     -13.177  -4.715   1.726  1.00102.21           N  
ATOM  39827  CA  GLY K  49     -14.239  -5.692   1.535  1.00102.21           C  
ATOM  39828  C   GLY K  49     -14.054  -6.617   0.342  1.00102.21           C  
ATOM  39829  O   GLY K  49     -13.291  -7.585   0.413  1.00102.21           O  
ATOM  39830  N   TYR K  50     -14.765  -6.304  -0.742  1.00 74.09           N  
ATOM  39831  CA  TYR K  50     -14.727  -7.053  -1.995  1.00 74.09           C  
ATOM  39832  C   TYR K  50     -13.911  -8.342  -1.925  1.00 74.09           C  
ATOM  39833  O   TYR K  50     -12.693  -8.304  -1.770  1.00 74.09           O  
ATOM  39834  CB  TYR K  50     -14.193  -6.146  -3.097  1.00 74.09           C  
ATOM  39835  N   LYS K  51     -14.592  -9.480  -2.067  1.00 86.59           N  
ATOM  39836  CA  LYS K  51     -13.943 -10.786  -1.959  1.00 86.59           C  
ATOM  39837  C   LYS K  51     -13.878 -11.679  -3.192  1.00 86.59           C  
ATOM  39838  O   LYS K  51     -12.874 -12.357  -3.413  1.00 86.59           O  
ATOM  39839  CB  LYS K  51     -14.598 -11.600  -0.832  1.00 86.59           C  
ATOM  39840  N   GLY K  52     -14.945 -11.702  -3.980  1.00 91.32           N  
ATOM  39841  CA  GLY K  52     -14.948 -12.566  -5.150  1.00 91.32           C  
ATOM  39842  C   GLY K  52     -14.514 -11.921  -6.447  1.00 91.32           C  
ATOM  39843  O   GLY K  52     -13.389 -11.434  -6.587  1.00 91.32           O  
ATOM  39844  N   SER K  53     -15.411 -11.942  -7.419  1.00 85.16           N  
ATOM  39845  CA  SER K  53     -15.113 -11.334  -8.691  1.00 85.16           C  
ATOM  39846  C   SER K  53     -15.200  -9.835  -8.486  1.00 85.16           C  
ATOM  39847  O   SER K  53     -15.005  -9.056  -9.408  1.00 85.16           O  
ATOM  39848  CB  SER K  53     -16.125 -11.777  -9.735  1.00 85.16           C  
ATOM  39849  N   ARG K  54     -15.506  -9.430  -7.266  1.00 86.29           N  
ATOM  39850  CA  ARG K  54     -15.606  -8.021  -6.974  1.00 86.29           C  
ATOM  39851  C   ARG K  54     -14.212  -7.462  -6.778  1.00 86.29           C  
ATOM  39852  O   ARG K  54     -14.046  -6.272  -6.550  1.00 86.29           O  
ATOM  39853  CB  ARG K  54     -16.418  -7.799  -5.710  1.00 86.29           C  
ATOM  39854  N   LYS K  55     -13.203  -8.318  -6.848  1.00 77.60           N  
ATOM  39855  CA  LYS K  55     -11.844  -7.833  -6.679  1.00 77.60           C  
ATOM  39856  C   LYS K  55     -11.234  -7.479  -8.028  1.00 77.60           C  
ATOM  39857  O   LYS K  55     -10.115  -6.973  -8.111  1.00 77.60           O  
ATOM  39858  CB  LYS K  55     -10.987  -8.878  -5.985  1.00 77.60           C  
ATOM  39859  N   GLY K  56     -11.986  -7.763  -9.084  1.00 88.53           N  
ATOM  39860  CA  GLY K  56     -11.551  -7.462 -10.437  1.00 88.53           C  
ATOM  39861  C   GLY K  56     -12.491  -6.396 -10.956  1.00 88.53           C  
ATOM  39862  O   GLY K  56     -12.497  -6.026 -12.127  1.00 88.53           O  
ATOM  39863  N   THR K  57     -13.318  -5.926 -10.040  1.00100.14           N  
ATOM  39864  CA  THR K  57     -14.278  -4.886 -10.311  1.00100.14           C  
ATOM  39865  C   THR K  57     -13.446  -3.631 -10.481  1.00100.14           C  
ATOM  39866  O   THR K  57     -12.537  -3.375  -9.700  1.00100.14           O  
ATOM  39867  CB  THR K  57     -15.220  -4.730  -9.109  1.00100.14           C  
ATOM  39868  N   PRO K  58     -13.738  -2.831 -11.510  1.00 77.13           N  
ATOM  39869  CA  PRO K  58     -12.945  -1.611 -11.688  1.00 77.13           C  
ATOM  39870  C   PRO K  58     -12.735  -0.783 -10.385  1.00 77.13           C  
ATOM  39871  O   PRO K  58     -11.733  -0.075 -10.248  1.00 77.13           O  
ATOM  39872  CB  PRO K  58     -13.719  -0.868 -12.779  1.00 77.13           C  
ATOM  39873  N   TYR K  59     -13.658  -0.872  -9.425  1.00 93.67           N  
ATOM  39874  CA  TYR K  59     -13.491  -0.134  -8.176  1.00 93.67           C  
ATOM  39875  C   TYR K  59     -12.207  -0.661  -7.610  1.00 93.67           C  
ATOM  39876  O   TYR K  59     -11.385   0.095  -7.097  1.00 93.67           O  
ATOM  39877  CB  TYR K  59     -14.611  -0.440  -7.201  1.00 93.67           C  
ATOM  39878  N   ALA K  60     -12.051  -1.977  -7.725  1.00 82.27           N  
ATOM  39879  CA  ALA K  60     -10.858  -2.677  -7.260  1.00 82.27           C  
ATOM  39880  C   ALA K  60      -9.636  -1.896  -7.689  1.00 82.27           C  
ATOM  39881  O   ALA K  60      -8.534  -2.107  -7.180  1.00 82.27           O  
ATOM  39882  CB  ALA K  60     -10.797  -4.083  -7.850  1.00 82.27           C  
ATOM  39883  N   ALA K  61      -9.836  -0.998  -8.645  1.00 77.43           N  
ATOM  39884  CA  ALA K  61      -8.749  -0.178  -9.126  1.00 77.43           C  
ATOM  39885  C   ALA K  61      -8.694   1.072  -8.278  1.00 77.43           C  
ATOM  39886  O   ALA K  61      -7.882   1.178  -7.360  1.00 77.43           O  
ATOM  39887  CB  ALA K  61      -8.968   0.190 -10.585  1.00 77.43           C  
ATOM  39888  N   GLN K  62      -9.591   2.002  -8.577  1.00 68.50           N  
ATOM  39889  CA  GLN K  62      -9.632   3.276  -7.874  1.00 68.50           C  
ATOM  39890  C   GLN K  62      -9.556   3.152  -6.372  1.00 68.50           C  
ATOM  39891  O   GLN K  62      -8.568   3.532  -5.753  1.00 68.50           O  
ATOM  39892  CB  GLN K  62     -10.895   4.044  -8.245  1.00 68.50           C  
ATOM  39893  N   LEU K  63     -10.625   2.625  -5.794  1.00 78.59           N  
ATOM  39894  CA  LEU K  63     -10.717   2.454  -4.360  1.00 78.59           C  
ATOM  39895  C   LEU K  63      -9.384   1.990  -3.771  1.00 78.59           C  
ATOM  39896  O   LEU K  63      -8.872   2.604  -2.831  1.00 78.59           O  
ATOM  39897  CB  LEU K  63     -11.854   1.480  -4.059  1.00 78.59           C  
ATOM  39898  N   ALA K  64      -8.813   0.924  -4.321  1.00 72.18           N  
ATOM  39899  CA  ALA K  64      -7.526   0.462  -3.836  1.00 72.18           C  
ATOM  39900  C   ALA K  64      -6.563   1.581  -4.184  1.00 72.18           C  
ATOM  39901  O   ALA K  64      -5.756   2.013  -3.365  1.00 72.18           O  
ATOM  39902  CB  ALA K  64      -7.126  -0.782  -4.548  1.00 72.18           C  
ATOM  39903  N   ALA K  65      -6.678   2.055  -5.419  1.00 66.83           N  
ATOM  39904  CA  ALA K  65      -5.836   3.124  -5.926  1.00 66.83           C  
ATOM  39905  C   ALA K  65      -6.128   4.461  -5.249  1.00 66.83           C  
ATOM  39906  O   ALA K  65      -5.874   5.527  -5.813  1.00 66.83           O  
ATOM  39907  CB  ALA K  65      -6.014   3.248  -7.420  1.00 66.83           C  
ATOM  39908  N   LEU K  66      -6.683   4.390  -4.045  1.00 73.39           N  
ATOM  39909  CA  LEU K  66      -6.979   5.575  -3.243  1.00 73.39           C  
ATOM  39910  C   LEU K  66      -6.310   5.270  -1.929  1.00 73.39           C  
ATOM  39911  O   LEU K  66      -5.666   6.121  -1.327  1.00 73.39           O  
ATOM  39912  CB  LEU K  66      -8.479   5.733  -3.012  1.00 73.39           C  
ATOM  39913  N   ASP K  67      -6.476   4.025  -1.500  1.00 84.44           N  
ATOM  39914  CA  ASP K  67      -5.883   3.563  -0.270  1.00 84.44           C  
ATOM  39915  C   ASP K  67      -4.398   3.532  -0.481  1.00 84.44           C  
ATOM  39916  O   ASP K  67      -3.629   3.866   0.410  1.00 84.44           O  
ATOM  39917  CB  ASP K  67      -6.399   2.181   0.070  1.00 84.44           C  
ATOM  39918  N   ALA K  68      -3.980   3.127  -1.663  1.00 79.99           N  
ATOM  39919  CA  ALA K  68      -2.567   3.128  -1.911  1.00 79.99           C  
ATOM  39920  C   ALA K  68      -2.164   4.560  -1.572  1.00 79.99           C  
ATOM  39921  O   ALA K  68      -1.278   4.782  -0.760  1.00 79.99           O  
ATOM  39922  CB  ALA K  68      -2.296   2.816  -3.352  1.00 79.99           C  
ATOM  39923  N   ALA K  69      -2.883   5.520  -2.152  1.00 74.42           N  
ATOM  39924  CA  ALA K  69      -2.630   6.955  -1.958  1.00 74.42           C  
ATOM  39925  C   ALA K  69      -2.711   7.455  -0.519  1.00 74.42           C  
ATOM  39926  O   ALA K  69      -1.709   7.852   0.072  1.00 74.42           O  
ATOM  39927  CB  ALA K  69      -3.588   7.776  -2.828  1.00 74.42           C  
ATOM  39928  N   LYS K  70      -3.923   7.471   0.024  1.00 93.03           N  
ATOM  39929  CA  LYS K  70      -4.142   7.933   1.384  1.00 93.03           C  
ATOM  39930  C   LYS K  70      -3.027   7.430   2.278  1.00 93.03           C  
ATOM  39931  O   LYS K  70      -2.244   8.216   2.808  1.00 93.03           O  
ATOM  39932  CB  LYS K  70      -5.492   7.433   1.904  1.00 93.03           C  
ATOM  39933  N   LYS K  71      -2.949   6.114   2.430  1.00 91.32           N  
ATOM  39934  CA  LYS K  71      -1.924   5.509   3.264  1.00 91.32           C  
ATOM  39935  C   LYS K  71      -0.535   5.885   2.757  1.00 91.32           C  
ATOM  39936  O   LYS K  71       0.432   5.850   3.523  1.00 91.32           O  
ATOM  39937  CB  LYS K  71      -2.067   3.984   3.262  1.00 91.32           C  
ATOM  39938  N   ALA K  72      -0.438   6.248   1.475  1.00 90.41           N  
ATOM  39939  CA  ALA K  72       0.848   6.618   0.878  1.00 90.41           C  
ATOM  39940  C   ALA K  72       1.188   8.097   0.991  1.00 90.41           C  
ATOM  39941  O   ALA K  72       2.319   8.492   0.722  1.00 90.41           O  
ATOM  39942  CB  ALA K  72       0.892   6.203  -0.572  1.00 90.41           C  
ATOM  39943  N   MET K  73       0.214   8.914   1.367  1.00 93.65           N  
ATOM  39944  CA  MET K  73       0.467  10.337   1.519  1.00 93.65           C  
ATOM  39945  C   MET K  73       0.958  10.554   2.946  1.00 93.65           C  
ATOM  39946  O   MET K  73       1.561  11.579   3.260  1.00 93.65           O  
ATOM  39947  CB  MET K  73      -0.809  11.146   1.262  1.00 93.65           C  
ATOM  39948  N   ALA K  74       0.711   9.561   3.798  1.00 98.45           N  
ATOM  39949  CA  ALA K  74       1.113   9.600   5.205  1.00 98.45           C  
ATOM  39950  C   ALA K  74       2.631   9.559   5.385  1.00 98.45           C  
ATOM  39951  O   ALA K  74       3.149   9.808   6.475  1.00 98.45           O  
ATOM  39952  CB  ALA K  74       0.470   8.442   5.956  1.00 98.45           C  
ATOM  39953  N   TYR K  75       3.336   9.225   4.313  1.00108.62           N  
ATOM  39954  CA  TYR K  75       4.791   9.166   4.331  1.00108.62           C  
ATOM  39955  C   TYR K  75       5.280  10.287   3.424  1.00108.62           C  
ATOM  39956  O   TYR K  75       6.345  10.192   2.799  1.00108.62           O  
ATOM  39957  CB  TYR K  75       5.284   7.833   3.783  1.00108.62           C  
ATOM  39958  N   GLY K  76       4.476  11.341   3.345  1.00 92.53           N  
ATOM  39959  CA  GLY K  76       4.825  12.470   2.512  1.00 92.53           C  
ATOM  39960  C   GLY K  76       4.311  12.348   1.090  1.00 92.53           C  
ATOM  39961  O   GLY K  76       3.238  12.853   0.774  1.00 92.53           O  
ATOM  39962  N   MET K  77       5.073  11.664   0.243  1.00100.17           N  
ATOM  39963  CA  MET K  77       4.729  11.498  -1.162  1.00100.17           C  
ATOM  39964  C   MET K  77       3.608  12.362  -1.698  1.00100.17           C  
ATOM  39965  O   MET K  77       2.446  12.176  -1.354  1.00100.17           O  
ATOM  39966  CB  MET K  77       4.435  10.039  -1.479  1.00100.17           C  
ATOM  39967  N   GLN K  78       3.976  13.315  -2.547  1.00110.37           N  
ATOM  39968  CA  GLN K  78       3.011  14.213  -3.161  1.00110.37           C  
ATOM  39969  C   GLN K  78       2.893  13.902  -4.647  1.00110.37           C  
ATOM  39970  O   GLN K  78       1.838  14.095  -5.246  1.00110.37           O  
ATOM  39971  CB  GLN K  78       3.437  15.671  -2.988  1.00110.37           C  
ATOM  39972  N   SER K  79       3.983  13.418  -5.234  1.00118.91           N  
ATOM  39973  CA  SER K  79       4.011  13.080  -6.655  1.00118.91           C  
ATOM  39974  C   SER K  79       4.566  11.674  -6.891  1.00118.91           C  
ATOM  39975  O   SER K  79       5.545  11.271  -6.262  1.00118.91           O  
ATOM  39976  CB  SER K  79       4.846  14.114  -7.414  1.00118.91           C  
ATOM  39977  N   VAL K  80       3.945  10.933  -7.806  1.00 94.69           N  
ATOM  39978  CA  VAL K  80       4.371   9.565  -8.080  1.00 94.69           C  
ATOM  39979  C   VAL K  80       4.470   9.238  -9.556  1.00 94.69           C  
ATOM  39980  O   VAL K  80       3.803   9.852 -10.387  1.00 94.69           O  
ATOM  39981  CB  VAL K  80       3.393   8.537  -7.474  1.00 94.69           C  
ATOM  39982  N   ASP K  81       5.298   8.241  -9.855  1.00103.52           N  
ATOM  39983  CA  ASP K  81       5.518   7.751 -11.215  1.00103.52           C  
ATOM  39984  C   ASP K  81       4.788   6.416 -11.361  1.00103.52           C  
ATOM  39985  O   ASP K  81       5.251   5.389 -10.868  1.00103.52           O  
ATOM  39986  CB  ASP K  81       7.018   7.534 -11.477  1.00103.52           C  
ATOM  39987  N   VAL K  82       3.650   6.435 -12.045  1.00 96.85           N  
ATOM  39988  CA  VAL K  82       2.852   5.231 -12.239  1.00 96.85           C  
ATOM  39989  C   VAL K  82       3.510   4.180 -13.140  1.00 96.85           C  
ATOM  39990  O   VAL K  82       4.296   4.502 -14.032  1.00 96.85           O  
ATOM  39991  CB  VAL K  82       1.481   5.581 -12.823  1.00 96.85           C  
ATOM  39992  N   ILE K  83       3.171   2.917 -12.903  1.00 71.61           N  
ATOM  39993  CA  ILE K  83       3.722   1.818 -13.678  1.00 71.61           C  
ATOM  39994  C   ILE K  83       2.717   0.697 -13.874  1.00 71.61           C  
ATOM  39995  O   ILE K  83       2.588  -0.199 -13.040  1.00 71.61           O  
ATOM  39996  CB  ILE K  83       4.956   1.248 -13.003  1.00 71.61           C  
ATOM  39997  N   VAL K  84       2.021   0.753 -15.001  1.00 76.24           N  
ATOM  39998  CA  VAL K  84       1.006  -0.224 -15.346  1.00 76.24           C  
ATOM  39999  C   VAL K  84       1.599  -1.566 -15.745  1.00 76.24           C  
ATOM  40000  O   VAL K  84       2.727  -1.648 -16.203  1.00 76.24           O  
ATOM  40001  CB  VAL K  84       0.128   0.302 -16.507  1.00 76.24           C  
ATOM  40002  N   ARG K  85       0.822  -2.619 -15.542  1.00 72.17           N  
ATOM  40003  CA  ARG K  85       1.212  -3.972 -15.905  1.00 72.17           C  
ATOM  40004  C   ARG K  85      -0.027  -4.844 -16.099  1.00 72.17           C  
ATOM  40005  O   ARG K  85      -1.100  -4.563 -15.560  1.00 72.17           O  
ATOM  40006  CB  ARG K  85       2.127  -4.596 -14.844  1.00 72.17           C  
ATOM  40007  N   GLY K  86       0.131  -5.905 -16.882  1.00 74.26           N  
ATOM  40008  CA  GLY K  86      -0.978  -6.803 -17.134  1.00 74.26           C  
ATOM  40009  C   GLY K  86      -2.013  -6.251 -18.100  1.00 74.26           C  
ATOM  40010  O   GLY K  86      -2.112  -5.031 -18.302  1.00 74.26           O  
ATOM  40011  N   THR K  87      -2.778  -7.167 -18.697  1.00 92.87           N  
ATOM  40012  CA  THR K  87      -3.831  -6.828 -19.651  1.00 92.87           C  
ATOM  40013  C   THR K  87      -5.161  -7.294 -19.085  1.00 92.87           C  
ATOM  40014  O   THR K  87      -5.352  -8.481 -18.822  1.00 92.87           O  
ATOM  40015  CB  THR K  87      -3.619  -7.517 -21.021  1.00 92.87           C  
ATOM  40016  N   GLY K  88      -6.068  -6.341 -18.902  1.00 98.91           N  
ATOM  40017  CA  GLY K  88      -7.376  -6.629 -18.353  1.00 98.91           C  
ATOM  40018  C   GLY K  88      -8.114  -5.326 -18.135  1.00 98.91           C  
ATOM  40019  O   GLY K  88      -8.044  -4.433 -18.981  1.00 98.91           O  
ATOM  40020  N   ALA K  89      -8.812  -5.205 -17.007  1.00100.90           N  
ATOM  40021  CA  ALA K  89      -9.564  -3.988 -16.695  1.00100.90           C  
ATOM  40022  C   ALA K  89      -8.937  -3.312 -15.492  1.00100.90           C  
ATOM  40023  O   ALA K  89      -8.182  -3.942 -14.754  1.00100.90           O  
ATOM  40024  CB  ALA K  89     -11.022  -4.329 -16.400  1.00100.90           C  
ATOM  40025  N   GLY K  90      -9.240  -2.035 -15.295  1.00130.02           N  
ATOM  40026  CA  GLY K  90      -8.676  -1.330 -14.158  1.00130.02           C  
ATOM  40027  C   GLY K  90      -7.526  -0.408 -14.518  1.00130.02           C  
ATOM  40028  O   GLY K  90      -7.094   0.420 -13.708  1.00130.02           O  
ATOM  40029  N   ARG K  91      -7.010  -0.563 -15.730  1.00101.66           N  
ATOM  40030  CA  ARG K  91      -5.925   0.293 -16.184  1.00101.66           C  
ATOM  40031  C   ARG K  91      -6.512   1.693 -16.161  1.00101.66           C  
ATOM  40032  O   ARG K  91      -7.731   1.863 -16.218  1.00101.66           O  
ATOM  40033  CB  ARG K  91      -5.511  -0.026 -17.631  1.00101.66           C  
ATOM  40034  N   GLU K  92      -5.645   2.693 -16.082  1.00 99.31           N  
ATOM  40035  CA  GLU K  92      -6.078   4.081 -16.093  1.00 99.31           C  
ATOM  40036  C   GLU K  92      -6.965   4.453 -14.913  1.00 99.31           C  
ATOM  40037  O   GLU K  92      -6.784   5.512 -14.319  1.00 99.31           O  
ATOM  40038  CB  GLU K  92      -6.769   4.375 -17.426  1.00 99.31           C  
ATOM  40039  N   GLN K  93      -7.915   3.593 -14.560  1.00104.06           N  
ATOM  40040  CA  GLN K  93      -8.781   3.892 -13.425  1.00104.06           C  
ATOM  40041  C   GLN K  93      -7.904   4.044 -12.193  1.00104.06           C  
ATOM  40042  O   GLN K  93      -7.918   5.082 -11.526  1.00104.06           O  
ATOM  40043  CB  GLN K  93      -9.802   2.775 -13.206  1.00104.06           C  
ATOM  40044  N   ALA K  94      -7.131   3.002 -11.905  1.00 92.79           N  
ATOM  40045  CA  ALA K  94      -6.228   3.035 -10.770  1.00 92.79           C  
ATOM  40046  C   ALA K  94      -5.461   4.338 -10.895  1.00 92.79           C  
ATOM  40047  O   ALA K  94      -5.197   5.026  -9.911  1.00 92.79           O  
ATOM  40048  CB  ALA K  94      -5.270   1.851 -10.827  1.00 92.79           C  
ATOM  40049  N   ILE K  95      -5.132   4.680 -12.134  1.00 87.94           N  
ATOM  40050  CA  ILE K  95      -4.396   5.893 -12.423  1.00 87.94           C  
ATOM  40051  C   ILE K  95      -5.217   7.123 -12.078  1.00 87.94           C  
ATOM  40052  O   ILE K  95      -4.914   7.822 -11.116  1.00 87.94           O  
ATOM  40053  CB  ILE K  95      -4.002   5.944 -13.895  1.00 87.94           C  
ATOM  40054  N   ARG K  96      -6.260   7.389 -12.855  1.00 92.61           N  
ATOM  40055  CA  ARG K  96      -7.092   8.553 -12.592  1.00 92.61           C  
ATOM  40056  C   ARG K  96      -7.311   8.632 -11.093  1.00 92.61           C  
ATOM  40057  O   ARG K  96      -7.313   9.708 -10.502  1.00 92.61           O  
ATOM  40058  CB  ARG K  96      -8.443   8.435 -13.301  1.00 92.61           C  
ATOM  40059  N   ALA K  97      -7.468   7.467 -10.482  1.00 89.43           N  
ATOM  40060  CA  ALA K  97      -7.689   7.377  -9.050  1.00 89.43           C  
ATOM  40061  C   ALA K  97      -6.628   8.145  -8.275  1.00 89.43           C  
ATOM  40062  O   ALA K  97      -6.925   8.759  -7.250  1.00 89.43           O  
ATOM  40063  CB  ALA K  97      -7.698   5.926  -8.630  1.00 89.43           C  
ATOM  40064  N   LEU K  98      -5.393   8.101  -8.771  1.00 93.69           N  
ATOM  40065  CA  LEU K  98      -4.253   8.787  -8.154  1.00 93.69           C  
ATOM  40066  C   LEU K  98      -4.234  10.269  -8.568  1.00 93.69           C  
ATOM  40067  O   LEU K  98      -3.660  11.118  -7.876  1.00 93.69           O  
ATOM  40068  CB  LEU K  98      -2.936   8.127  -8.598  1.00 93.69           C  
ATOM  40069  N   GLN K  99      -4.871  10.564  -9.700  1.00101.04           N  
ATOM  40070  CA  GLN K  99      -4.925  11.922 -10.240  1.00101.04           C  
ATOM  40071  C   GLN K  99      -6.002  12.787  -9.591  1.00101.04           C  
ATOM  40072  O   GLN K  99      -6.225  13.941  -9.975  1.00101.04           O  
ATOM  40073  CB  GLN K  99      -5.128  11.859 -11.759  1.00101.04           C  
ATOM  40074  N   ALA K 100      -6.666  12.212  -8.602  1.00 97.36           N  
ATOM  40075  CA  ALA K 100      -7.707  12.904  -7.865  1.00 97.36           C  
ATOM  40076  C   ALA K 100      -7.429  12.656  -6.388  1.00 97.36           C  
ATOM  40077  O   ALA K 100      -7.951  13.355  -5.511  1.00 97.36           O  
ATOM  40078  CB  ALA K 100      -9.070  12.353  -8.241  1.00 97.36           C  
ATOM  40079  N   SER K 101      -6.582  11.661  -6.134  1.00104.19           N  
ATOM  40080  CA  SER K 101      -6.201  11.260  -4.779  1.00104.19           C  
ATOM  40081  C   SER K 101      -5.459  12.354  -4.018  1.00104.19           C  
ATOM  40082  O   SER K 101      -5.481  12.403  -2.782  1.00104.19           O  
ATOM  40083  CB  SER K 101      -5.315  10.009  -4.835  1.00104.19           C  
ATOM  40084  N   GLY K 102      -4.800  13.231  -4.765  1.00121.80           N  
ATOM  40085  CA  GLY K 102      -4.039  14.297  -4.147  1.00121.80           C  
ATOM  40086  C   GLY K 102      -2.580  14.095  -4.493  1.00121.80           C  
ATOM  40087  O   GLY K 102      -1.718  14.908  -4.155  1.00121.80           O  
ATOM  40088  N   LEU K 103      -2.308  12.987  -5.173  1.00105.34           N  
ATOM  40089  CA  LEU K 103      -0.957  12.664  -5.595  1.00105.34           C  
ATOM  40090  C   LEU K 103      -0.726  13.177  -7.008  1.00105.34           C  
ATOM  40091  O   LEU K 103      -1.371  12.716  -7.952  1.00105.34           O  
ATOM  40092  CB  LEU K 103      -0.730  11.150  -5.562  1.00105.34           C  
ATOM  40093  N   GLN K 104       0.175  14.146  -7.154  1.00116.36           N  
ATOM  40094  CA  GLN K 104       0.488  14.680  -8.472  1.00116.36           C  
ATOM  40095  C   GLN K 104       1.103  13.515  -9.213  1.00116.36           C  
ATOM  40096  O   GLN K 104       1.837  12.723  -8.623  1.00116.36           O  
ATOM  40097  CB  GLN K 104       1.496  15.827  -8.371  1.00116.36           C  
ATOM  40098  N   VAL K 105       0.803  13.385 -10.495  1.00 97.15           N  
ATOM  40099  CA  VAL K 105       1.359  12.267 -11.228  1.00 97.15           C  
ATOM  40100  C   VAL K 105       2.460  12.647 -12.209  1.00 97.15           C  
ATOM  40101  O   VAL K 105       2.215  13.219 -13.273  1.00 97.15           O  
ATOM  40102  CB  VAL K 105       0.274  11.500 -11.961  1.00 97.15           C  
ATOM  40103  N   LYS K 106       3.685  12.312 -11.825  1.00 95.26           N  
ATOM  40104  CA  LYS K 106       4.844  12.599 -12.641  1.00 95.26           C  
ATOM  40105  C   LYS K 106       4.641  11.995 -14.012  1.00 95.26           C  
ATOM  40106  O   LYS K 106       4.300  12.695 -14.957  1.00 95.26           O  
ATOM  40107  CB  LYS K 106       6.100  12.001 -12.010  1.00 95.26           C  
ATOM  40108  N   SER K 107       4.829  10.681 -14.099  1.00 97.12           N  
ATOM  40109  CA  SER K 107       4.707   9.960 -15.358  1.00 97.12           C  
ATOM  40110  C   SER K 107       3.865   8.681 -15.306  1.00 97.12           C  
ATOM  40111  O   SER K 107       3.673   8.093 -14.242  1.00 97.12           O  
ATOM  40112  CB  SER K 107       6.109   9.617 -15.860  1.00 97.12           C  
ATOM  40113  N   ILE K 108       3.367   8.268 -16.471  1.00 98.73           N  
ATOM  40114  CA  ILE K 108       2.569   7.048 -16.617  1.00 98.73           C  
ATOM  40115  C   ILE K 108       3.316   6.142 -17.587  1.00 98.73           C  
ATOM  40116  O   ILE K 108       3.534   6.508 -18.736  1.00 98.73           O  
ATOM  40117  CB  ILE K 108       1.180   7.329 -17.214  1.00 98.73           C  
ATOM  40118  N   VAL K 109       3.695   4.955 -17.138  1.00 73.83           N  
ATOM  40119  CA  VAL K 109       4.448   4.062 -17.996  1.00 73.83           C  
ATOM  40120  C   VAL K 109       3.853   2.672 -18.026  1.00 73.83           C  
ATOM  40121  O   VAL K 109       3.221   2.257 -17.067  1.00 73.83           O  
ATOM  40122  CB  VAL K 109       5.911   3.975 -17.508  1.00 73.83           C  
ATOM  40123  N   ASP K 110       4.051   1.966 -19.135  1.00 83.55           N  
ATOM  40124  CA  ASP K 110       3.559   0.600 -19.288  1.00 83.55           C  
ATOM  40125  C   ASP K 110       4.779  -0.290 -19.337  1.00 83.55           C  
ATOM  40126  O   ASP K 110       5.766   0.066 -19.972  1.00 83.55           O  
ATOM  40127  CB  ASP K 110       2.794   0.438 -20.594  1.00 83.55           C  
ATOM  40128  N   ASP K 111       4.714  -1.439 -18.675  1.00 90.75           N  
ATOM  40129  CA  ASP K 111       5.842  -2.372 -18.657  1.00 90.75           C  
ATOM  40130  C   ASP K 111       5.375  -3.814 -18.740  1.00 90.75           C  
ATOM  40131  O   ASP K 111       6.147  -4.743 -18.485  1.00 90.75           O  
ATOM  40132  CB  ASP K 111       6.674  -2.194 -17.382  1.00 90.75           C  
ATOM  40133  N   THR K 112       4.114  -3.997 -19.111  1.00 87.53           N  
ATOM  40134  CA  THR K 112       3.548  -5.334 -19.194  1.00 87.53           C  
ATOM  40135  C   THR K 112       4.515  -6.318 -19.834  1.00 87.53           C  
ATOM  40136  O   THR K 112       4.962  -6.115 -20.963  1.00 87.53           O  
ATOM  40137  CB  THR K 112       2.235  -5.346 -19.993  1.00 87.53           C  
ATOM  40138  N   PRO K 113       4.869  -7.388 -19.098  1.00 82.29           N  
ATOM  40139  CA  PRO K 113       5.784  -8.447 -19.541  1.00 82.29           C  
ATOM  40140  C   PRO K 113       5.148  -9.490 -20.468  1.00 82.29           C  
ATOM  40141  O   PRO K 113       4.245 -10.229 -20.075  1.00 82.29           O  
ATOM  40142  CB  PRO K 113       6.251  -9.062 -18.227  1.00 82.29           C  
ATOM  40143  N   VAL K 114       5.621  -9.533 -21.705  1.00 83.82           N  
ATOM  40144  CA  VAL K 114       5.123 -10.490 -22.670  1.00 83.82           C  
ATOM  40145  C   VAL K 114       6.292 -11.339 -23.109  1.00 83.82           C  
ATOM  40146  O   VAL K 114       7.196 -10.863 -23.782  1.00 83.82           O  
ATOM  40147  CB  VAL K 114       4.525  -9.809 -23.889  1.00 83.82           C  
ATOM  40148  N   PRO K 115       6.272 -12.623 -22.749  1.00 63.54           N  
ATOM  40149  CA  PRO K 115       7.309 -13.599 -23.068  1.00 63.54           C  
ATOM  40150  C   PRO K 115       7.540 -13.672 -24.550  1.00 63.54           C  
ATOM  40151  O   PRO K 115       6.592 -13.907 -25.292  1.00 63.54           O  
ATOM  40152  CB  PRO K 115       6.714 -14.892 -22.545  1.00 63.54           C  
ATOM  40153  N   HIS K 116       8.783 -13.483 -24.989  1.00 74.24           N  
ATOM  40154  CA  HIS K 116       9.101 -13.559 -26.417  1.00 74.24           C  
ATOM  40155  C   HIS K 116       8.988 -15.009 -26.849  1.00 74.24           C  
ATOM  40156  O   HIS K 116       9.853 -15.553 -27.526  1.00 74.24           O  
ATOM  40157  CB  HIS K 116      10.507 -13.026 -26.667  1.00 74.24           C  
ATOM  40158  N   ASN K 117       7.879 -15.602 -26.418  1.00 89.16           N  
ATOM  40159  CA  ASN K 117       7.507 -16.983 -26.639  1.00 89.16           C  
ATOM  40160  C   ASN K 117       8.378 -17.998 -25.935  1.00 89.16           C  
ATOM  40161  O   ASN K 117       9.389 -18.464 -26.448  1.00 89.16           O  
ATOM  40162  CB  ASN K 117       7.402 -17.272 -28.119  1.00 89.16           C  
ATOM  40163  N   GLY K 118       7.952 -18.312 -24.722  1.00 69.23           N  
ATOM  40164  CA  GLY K 118       8.632 -19.274 -23.887  1.00 69.23           C  
ATOM  40165  C   GLY K 118       7.579 -19.725 -22.894  1.00 69.23           C  
ATOM  40166  O   GLY K 118       6.756 -18.909 -22.461  1.00 69.23           O  
ATOM  40167  N   CYS K 119       7.582 -21.010 -22.547  1.00 78.58           N  
ATOM  40168  CA  CYS K 119       6.618 -21.557 -21.595  1.00 78.58           C  
ATOM  40169  C   CYS K 119       5.238 -21.766 -22.212  1.00 78.58           C  
ATOM  40170  O   CYS K 119       4.549 -20.801 -22.568  1.00 78.58           O  
ATOM  40171  CB  CYS K 119       6.464 -20.626 -20.388  1.00 78.58           C  
ATOM  40172  N   ARG K 120       4.826 -23.023 -22.323  1.00 66.05           N  
ATOM  40173  CA  ARG K 120       3.519 -23.329 -22.876  1.00 66.05           C  
ATOM  40174  C   ARG K 120       2.438 -22.838 -21.937  1.00 66.05           C  
ATOM  40175  O   ARG K 120       2.352 -23.283 -20.798  1.00 66.05           O  
ATOM  40176  CB  ARG K 120       3.361 -24.828 -23.068  1.00 66.05           C  
ATOM  40177  N   PRO K 121       1.602 -21.899 -22.394  1.00 70.24           N  
ATOM  40178  CA  PRO K 121       0.526 -21.375 -21.551  1.00 70.24           C  
ATOM  40179  C   PRO K 121      -0.451 -22.482 -21.144  1.00 70.24           C  
ATOM  40180  O   PRO K 121      -0.434 -23.566 -21.726  1.00 70.24           O  
ATOM  40181  CB  PRO K 121      -0.113 -20.309 -22.439  1.00 70.24           C  
ATOM  40182  N   LYS K 122      -1.289 -22.225 -20.142  1.00 55.90           N  
ATOM  40183  CA  LYS K 122      -2.247 -23.235 -19.704  1.00 55.90           C  
ATOM  40184  C   LYS K 122      -3.347 -23.348 -20.741  1.00 55.90           C  
ATOM  40185  O   LYS K 122      -3.707 -22.354 -21.367  1.00 55.90           O  
ATOM  40186  CB  LYS K 122      -2.860 -22.847 -18.363  1.00 55.90           C  
ATOM  40187  N   LYS K 123      -3.885 -24.550 -20.921  1.00 55.96           N  
ATOM  40188  CA  LYS K 123      -4.945 -24.746 -21.898  1.00 55.96           C  
ATOM  40189  C   LYS K 123      -5.761 -23.482 -22.035  1.00 55.96           C  
ATOM  40190  O   LYS K 123      -5.978 -22.988 -23.134  1.00 55.96           O  
ATOM  40191  CB  LYS K 123      -5.891 -25.873 -21.481  1.00 55.96           C  
ATOM  40192  N   LYS K 124      -6.192 -22.958 -20.898  1.00 75.58           N  
ATOM  40193  CA  LYS K 124      -7.021 -21.759 -20.836  1.00 75.58           C  
ATOM  40194  C   LYS K 124      -6.597 -20.653 -21.788  1.00 75.58           C  
ATOM  40195  O   LYS K 124      -7.390 -19.770 -22.117  1.00 75.58           O  
ATOM  40196  CB  LYS K 124      -7.044 -21.237 -19.401  1.00 75.58           C  
ATOM  40197  N   PHE K 125      -5.351 -20.703 -22.238  1.00 74.33           N  
ATOM  40198  CA  PHE K 125      -4.845 -19.692 -23.155  1.00 74.33           C  
ATOM  40199  C   PHE K 125      -4.181 -20.380 -24.345  1.00 74.33           C  
ATOM  40200  O   PHE K 125      -3.346 -21.265 -24.173  1.00 74.33           O  
ATOM  40201  CB  PHE K 125      -3.862 -18.785 -22.408  1.00 74.33           C  
ATOM  40202  N   ARG K 126      -4.550 -19.986 -25.558  1.00 95.42           N  
ATOM  40203  CA  ARG K 126      -3.970 -20.643 -26.711  1.00 95.42           C  
ATOM  40204  C   ARG K 126      -4.260 -19.992 -28.070  1.00 95.42           C  
ATOM  40205  O   ARG K 126      -3.345 -19.760 -28.867  1.00 95.42           O  
ATOM  40206  CB  ARG K 126      -4.434 -22.102 -26.697  1.00 95.42           C  
ATOM  40207  N   LYS K 127      -5.534 -19.708 -28.330  1.00115.86           N  
ATOM  40208  CA  LYS K 127      -5.954 -19.085 -29.586  1.00115.86           C  
ATOM  40209  C   LYS K 127      -6.200 -17.589 -29.367  1.00115.86           C  
ATOM  40210  O   LYS K 127      -5.903 -17.057 -28.295  1.00115.86           O  
ATOM  40211  CB  LYS K 127      -7.239 -19.748 -30.102  1.00115.86           C  
ATOM  40212  N   ALA K 128      -6.742 -16.917 -30.381  1.00181.45           N  
ATOM  40213  CA  ALA K 128      -7.032 -15.486 -30.298  1.00181.45           C  
ATOM  40214  C   ALA K 128      -7.907 -15.056 -31.466  1.00181.45           C  
ATOM  40215  O   ALA K 128      -8.916 -14.376 -31.289  1.00181.45           O  
ATOM  40216  CB  ALA K 128      -5.737 -14.683 -30.299  1.00181.45           C  
ATOM  40217  N   SER K 129      -7.500 -15.453 -32.665  1.00186.33           N  
ATOM  40218  CA  SER K 129      -8.238 -15.134 -33.877  1.00186.33           C  
ATOM  40219  C   SER K 129      -8.403 -16.421 -34.676  1.00186.33           C  
ATOM  40220  O   SER K 129      -9.534 -16.958 -34.716  1.00186.33           O  
ATOM  40221  CB  SER K 129      -7.470 -14.103 -34.711  1.00186.33           C  
TER   40222      SER K 129                                                      
END
MOLECULE T0472.pdb
ATOM      1  N   MET     1       9.133  12.968  -2.784  1.00 43.14           N  
ATOM      2  CA  MET     1       8.345  11.878  -3.427  1.00 43.44           C  
ATOM      3  C   MET     1       9.259  10.975  -4.276  1.00  1.32           C  
ATOM      4  O   MET     1       9.403  11.181  -5.480  1.00  4.13           O  
ATOM      5  CB  MET     1       7.231  12.463  -4.311  1.00 41.12           C  
ATOM      6  CG  MET     1       6.300  13.433  -3.593  1.00 70.41           C  
ATOM      7  SD  MET     1       5.023  14.089  -4.687  1.00 54.53           S  
ATOM      8  CE  MET     1       4.245  15.300  -3.619  1.00 10.43           C  
ATOM      9  H1  MET     1       9.887  12.563  -2.191  1.00 37.41           H  
ATOM     10  H2  MET     1       8.518  13.561  -2.186  1.00 37.41           H  
ATOM     11  H3  MET     1       9.573  13.572  -3.511  1.00 37.41           H  
ATOM     12  HA  MET     1       7.898  11.280  -2.643  1.00 10.24           H  
ATOM     13  HB2 MET     1       7.684  12.989  -5.139  1.00 37.41           H  
ATOM     14  HB3 MET     1       6.634  11.650  -4.700  1.00 37.41           H  
ATOM     15  HG2 MET     1       5.821  12.916  -2.774  1.00 37.41           H  
ATOM     16  HG3 MET     1       6.883  14.256  -3.206  1.00 37.41           H  
ATOM     17  HE1 MET     1       3.845  14.807  -2.744  1.00 37.41           H  
ATOM     18  HE2 MET     1       3.443  15.788  -4.154  1.00 37.41           H  
ATOM     19  HE3 MET     1       4.974  16.037  -3.314  1.00 37.41           H  
ATOM     20  N   SER     2       9.886   9.990  -3.637  1.00 63.42           N  
ATOM     21  CA  SER     2      10.874   9.125  -4.307  1.00 41.35           C  
ATOM     22  C   SER     2      10.235   7.904  -4.990  1.00 44.41           C  
ATOM     23  O   SER     2      10.859   7.263  -5.836  1.00 64.32           O  
ATOM     24  CB  SER     2      11.923   8.645  -3.291  1.00 62.12           C  
ATOM     25  OG  SER     2      12.574   9.740  -2.656  1.00  2.50           O  
ATOM     26  H   SER     2       9.701   9.848  -2.682  1.00 37.41           H  
ATOM     27  HA  SER     2      11.374   9.718  -5.061  1.00 54.33           H  
ATOM     28  HB2 SER     2      11.439   8.046  -2.533  1.00 37.41           H  
ATOM     29  HB3 SER     2      12.668   8.046  -3.798  1.00 37.41           H  
ATOM     30  HG  SER     2      12.000  10.099  -1.964  1.00  4.15           H  
ATOM     31  N   GLY     3       8.992   7.593  -4.637  1.00 75.03           N  
ATOM     32  CA  GLY     3       8.365   6.357  -5.110  1.00 53.14           C  
ATOM     33  C   GLY     3       7.171   6.559  -6.038  1.00 60.02           C  
ATOM     34  O   GLY     3       6.764   7.688  -6.319  1.00 54.15           O  
ATOM     35  H   GLY     3       8.494   8.202  -4.062  1.00 37.41           H  
ATOM     36  HA2 GLY     3       9.107   5.767  -5.632  1.00 37.41           H  
ATOM     37  HA3 GLY     3       8.034   5.797  -4.247  1.00 37.41           H  
ATOM     38  N   TRP     4       6.603   5.443  -6.503  1.00 62.23           N  
ATOM     39  CA  TRP     4       5.490   5.464  -7.462  1.00 53.24           C  
ATOM     40  C   TRP     4       4.594   4.222  -7.304  1.00 54.24           C  
ATOM     41  O   TRP     4       4.936   3.281  -6.579  1.00 44.23           O  
ATOM     42  CB  TRP     4       6.036   5.524  -8.896  1.00 10.44           C  
ATOM     43  CG  TRP     4       6.747   4.270  -9.314  1.00 32.04           C  
ATOM     44  CD1 TRP     4       6.224   3.237 -10.039  1.00 71.44           C  
ATOM     45  CD2 TRP     4       8.100   3.905  -9.018  1.00 13.20           C  
ATOM     46  NE1 TRP     4       7.168   2.263 -10.217  1.00 61.42           N  
ATOM     47  CE2 TRP     4       8.328   2.647  -9.600  1.00 45.30           C  
ATOM     48  CE3 TRP     4       9.142   4.523  -8.318  1.00 25.24           C  
ATOM     49  CZ2 TRP     4       9.553   1.991  -9.506  1.00 52.13           C  
ATOM     50  CZ3 TRP     4      10.358   3.871  -8.226  1.00 73.25           C  
ATOM     51  CH2 TRP     4      10.554   2.618  -8.816  1.00  5.23           C  
ATOM     52  H   TRP     4       6.940   4.580  -6.189  1.00 37.41           H  
ATOM     53  HA  TRP     4       4.900   6.348  -7.272  1.00 54.13           H  
ATOM     54  HB2 TRP     4       5.218   5.690  -9.581  1.00 37.41           H  
ATOM     55  HB3 TRP     4       6.735   6.347  -8.976  1.00 37.41           H  
ATOM     56  HD1 TRP     4       5.211   3.205 -10.413  1.00 41.45           H  
ATOM     57  HE1 TRP     4       7.034   1.429 -10.712  1.00 73.22           H  
ATOM     58  HE3 TRP     4       9.009   5.490  -7.857  1.00 10.05           H  
ATOM     59  HZ2 TRP     4       9.714   1.021  -9.952  1.00 70.05           H  
ATOM     60  HZ3 TRP     4      11.174   4.331  -7.688  1.00 24.30           H  
ATOM     61  HH2 TRP     4      11.521   2.146  -8.716  1.00 52.45           H  
ATOM     62  N   TYR     5       3.460   4.218  -8.005  1.00 42.30           N  
ATOM     63  CA  TYR     5       2.510   3.097  -7.957  1.00 50.41           C  
ATOM     64  C   TYR     5       2.527   2.271  -9.253  1.00 31.42           C  
ATOM     65  O   TYR     5       2.631   2.816 -10.353  1.00 52.13           O  
ATOM     66  CB  TYR     5       1.087   3.616  -7.708  1.00 22.52           C  
ATOM     67  CG  TYR     5       0.862   4.157  -6.310  1.00 11.51           C  
ATOM     68  CD1 TYR     5       1.120   5.489  -6.002  1.00 21.33           C  
ATOM     69  CD2 TYR     5       0.384   3.331  -5.298  1.00 41.02           C  
ATOM     70  CE1 TYR     5       0.911   5.979  -4.726  1.00  4.11           C  
ATOM     71  CE2 TYR     5       0.172   3.815  -4.022  1.00  0.53           C  
ATOM     72  CZ  TYR     5       0.438   5.138  -3.742  1.00 23.25           C  
ATOM     73  OH  TYR     5       0.230   5.621  -2.472  1.00  1.02           O  
ATOM     74  H   TYR     5       3.255   4.990  -8.575  1.00 37.41           H  
ATOM     75  HA  TYR     5       2.793   2.454  -7.135  1.00 50.15           H  
ATOM     76  HB2 TYR     5       0.876   4.411  -8.408  1.00 37.41           H  
ATOM     77  HB3 TYR     5       0.384   2.809  -7.870  1.00 37.41           H  
ATOM     78  HD1 TYR     5       1.491   6.147  -6.776  1.00 42.22           H  
ATOM     79  HD2 TYR     5       0.177   2.292  -5.519  1.00 61.25           H  
ATOM     80  HE1 TYR     5       1.118   7.016  -4.506  1.00 44.53           H  
ATOM     81  HE2 TYR     5      -0.199   3.156  -3.251  1.00 11.50           H  
ATOM     82  HH  TYR     5      -0.161   6.501  -2.521  1.00 40.41           H  
ATOM     83  N   GLU     6       2.420   0.953  -9.109  1.00  1.12           N  
ATOM     84  CA  GLU     6       2.292   0.035 -10.252  1.00 73.13           C  
ATOM     85  C   GLU     6       1.107  -0.924 -10.061  1.00 15.03           C  
ATOM     86  O   GLU     6       1.108  -1.750  -9.148  1.00 55.41           O  
ATOM     87  CB  GLU     6       3.585  -0.776 -10.446  1.00 14.14           C  
ATOM     88  CG  GLU     6       4.684  -0.030 -11.196  1.00 40.20           C  
ATOM     89  CD  GLU     6       6.000  -0.797 -11.250  1.00 32.34           C  
ATOM     90  OE1 GLU     6       6.043  -1.972 -10.832  1.00 42.31           O  
ATOM     91  OE2 GLU     6       7.020  -0.206 -11.660  1.00 43.22           O  
ATOM     92  H   GLU     6       2.436   0.578  -8.203  1.00 37.41           H  
ATOM     93  HA  GLU     6       2.114   0.630 -11.139  1.00 53.04           H  
ATOM     94  HB2 GLU     6       3.969  -1.047  -9.474  1.00 37.41           H  
ATOM     95  HB3 GLU     6       3.355  -1.679 -10.995  1.00 37.41           H  
ATOM     96  HG2 GLU     6       4.351   0.150 -12.208  1.00 37.41           H  
ATOM     97  HG3 GLU     6       4.857   0.916 -10.703  1.00 37.41           H  
ATOM     98  N   LEU     7       0.099  -0.804 -10.920  1.00 51.22           N  
ATOM     99  CA  LEU     7      -1.074  -1.684 -10.880  1.00 22.02           C  
ATOM    100  C   LEU     7      -0.897  -2.873 -11.835  1.00 44.25           C  
ATOM    101  O   LEU     7      -0.622  -2.686 -13.018  1.00 73.34           O  
ATOM    102  CB  LEU     7      -2.338  -0.908 -11.275  1.00 53.12           C  
ATOM    103  CG  LEU     7      -3.639  -1.730 -11.252  1.00 55.32           C  
ATOM    104  CD1 LEU     7      -4.047  -2.070  -9.820  1.00  5.11           C  
ATOM    105  CD2 LEU     7      -4.758  -0.992 -11.979  1.00 32.15           C  
ATOM    106  H   LEU     7       0.145  -0.106 -11.607  1.00 37.41           H  
ATOM    107  HA  LEU     7      -1.186  -2.053  -9.870  1.00 64.54           H  
ATOM    108  HB2 LEU     7      -2.450  -0.071 -10.597  1.00 37.41           H  
ATOM    109  HB3 LEU     7      -2.199  -0.521 -12.276  1.00 37.41           H  
ATOM    110  HG  LEU     7      -3.469  -2.663 -11.773  1.00  3.12           H  
ATOM    111 HD11 LEU     7      -4.968  -2.635  -9.832  1.00 37.41           H  
ATOM    112 HD12 LEU     7      -4.193  -1.158  -9.258  1.00 37.41           H  
ATOM    113 HD13 LEU     7      -3.270  -2.659  -9.353  1.00 37.41           H  
ATOM    114 HD21 LEU     7      -4.922  -0.031 -11.513  1.00 37.41           H  
ATOM    115 HD22 LEU     7      -5.664  -1.577 -11.930  1.00 37.41           H  
ATOM    116 HD23 LEU     7      -4.479  -0.850 -13.013  1.00 37.41           H  
ATOM    117  N   SER     8      -1.082  -4.093 -11.338  1.00 53.24           N  
ATOM    118  CA  SER     8      -0.905  -5.294 -12.171  1.00 31.23           C  
ATOM    119  C   SER     8      -2.098  -6.253 -12.064  1.00  3.22           C  
ATOM    120  O   SER     8      -2.856  -6.221 -11.093  1.00  4.32           O  
ATOM    121  CB  SER     8       0.387  -6.029 -11.787  1.00 22.41           C  
ATOM    122  OG  SER     8       0.365  -6.445 -10.429  1.00 32.24           O  
ATOM    123  H   SER     8      -1.343  -4.193 -10.399  1.00 37.41           H  
ATOM    124  HA  SER     8      -0.827  -4.968 -13.201  1.00  5.52           H  
ATOM    125  HB2 SER     8       0.503  -6.901 -12.413  1.00 37.41           H  
ATOM    126  HB3 SER     8       1.230  -5.369 -11.934  1.00 37.41           H  
ATOM    127  HG  SER     8       0.420  -5.670  -9.855  1.00 21.24           H  
ATOM    128  N   LYS     9      -2.262  -7.100 -13.083  1.00 41.30           N  
ATOM    129  CA  LYS     9      -3.341  -8.094 -13.117  1.00  1.00           C  
ATOM    130  C   LYS     9      -2.853  -9.472 -12.635  1.00 12.02           C  
ATOM    131  O   LYS     9      -1.749  -9.905 -12.965  1.00 63.01           O  
ATOM    132  CB  LYS     9      -3.907  -8.213 -14.543  1.00 61.51           C  
ATOM    133  CG  LYS     9      -4.926  -9.340 -14.712  1.00 32.33           C  
ATOM    134  CD  LYS     9      -5.360  -9.520 -16.166  1.00 51.24           C  
ATOM    135  CE  LYS     9      -6.254  -8.383 -16.648  1.00 54.22           C  
ATOM    136  NZ  LYS     9      -7.603  -8.424 -16.015  1.00  4.21           N  
ATOM    137  H   LYS     9      -1.635  -7.058 -13.834  1.00 37.41           H  
ATOM    138  HA  LYS     9      -4.129  -7.754 -12.456  1.00  4.52           H  
ATOM    139  HB2 LYS     9      -4.388  -7.280 -14.804  1.00 37.41           H  
ATOM    140  HB3 LYS     9      -3.089  -8.389 -15.229  1.00 37.41           H  
ATOM    141  HG2 LYS     9      -4.483 -10.264 -14.367  1.00 37.41           H  
ATOM    142  HG3 LYS     9      -5.797  -9.117 -14.110  1.00 37.41           H  
ATOM    143  HD2 LYS     9      -4.481  -9.560 -16.793  1.00 37.41           H  
ATOM    144  HD3 LYS     9      -5.904 -10.452 -16.252  1.00 37.41           H  
ATOM    145  HE2 LYS     9      -5.784  -7.440 -16.411  1.00 37.41           H  
ATOM    146  HE3 LYS     9      -6.370  -8.464 -17.721  1.00 37.41           H  
ATOM    147  HZ1 LYS     9      -7.523  -8.381 -14.981  1.00 37.41           H  
ATOM    148  HZ2 LYS     9      -8.096  -9.303 -16.277  1.00 37.41           H  
ATOM    149  HZ3 LYS     9      -8.176  -7.617 -16.339  1.00 37.41           H  
ATOM    150  N   SER    10      -3.690 -10.150 -11.857  1.00 65.03           N  
ATOM    151  CA  SER    10      -3.397 -11.504 -11.370  1.00 12.31           C  
ATOM    152  C   SER    10      -4.045 -12.568 -12.267  1.00 71.11           C  
ATOM    153  O   SER    10      -4.752 -12.244 -13.222  1.00 21.42           O  
ATOM    154  CB  SER    10      -3.901 -11.663  -9.930  1.00 51.44           C  
ATOM    155  OG  SER    10      -3.702 -12.985  -9.453  1.00 44.32           O  
ATOM    156  H   SER    10      -4.536  -9.729 -11.601  1.00 37.41           H  
ATOM    157  HA  SER    10      -2.324 -11.642 -11.386  1.00 20.04           H  
ATOM    158  HB2 SER    10      -3.365 -10.981  -9.286  1.00 37.41           H  
ATOM    159  HB3 SER    10      -4.956 -11.436  -9.894  1.00 37.41           H  
ATOM    160  HG  SER    10      -3.002 -12.984  -8.787  1.00 52.12           H  
ATOM    161  N   SER    11      -3.824 -13.840 -11.940  1.00 53.25           N  
ATOM    162  CA  SER    11      -4.365 -14.958 -12.731  1.00 71.22           C  
ATOM    163  C   SER    11      -5.902 -14.955 -12.751  1.00 61.02           C  
ATOM    164  O   SER    11      -6.521 -15.438 -13.700  1.00 23.10           O  
ATOM    165  CB  SER    11      -3.860 -16.297 -12.177  1.00  2.01           C  
ATOM    166  OG  SER    11      -4.259 -16.475 -10.828  1.00 23.05           O  
ATOM    167  H   SER    11      -3.289 -14.037 -11.141  1.00 37.41           H  
ATOM    168  HA  SER    11      -4.009 -14.845 -13.746  1.00 14.14           H  
ATOM    169  HB2 SER    11      -4.265 -17.106 -12.768  1.00 37.41           H  
ATOM    170  HB3 SER    11      -2.782 -16.322 -12.225  1.00 37.41           H  
ATOM    171  HG  SER    11      -3.986 -17.352 -10.525  1.00 23.22           H  
ATOM    172  N   ASN    12      -6.515 -14.408 -11.700  1.00 44.53           N  
ATOM    173  CA  ASN    12      -7.983 -14.299 -11.614  1.00 72.42           C  
ATOM    174  C   ASN    12      -8.499 -13.016 -12.289  1.00 55.44           C  
ATOM    175  O   ASN    12      -9.666 -12.652 -12.137  1.00 71.03           O  
ATOM    176  CB  ASN    12      -8.429 -14.300 -10.146  1.00 11.22           C  
ATOM    177  CG  ASN    12      -7.960 -15.522  -9.387  1.00 12.42           C  
ATOM    178  OD1 ASN    12      -7.781 -16.594  -9.957  1.00 23.32           O  
ATOM    179  ND2 ASN    12      -7.765 -15.376  -8.092  1.00 33.33           N  
ATOM    180  H   ASN    12      -5.968 -14.085 -10.951  1.00 37.41           H  
ATOM    181  HA  ASN    12      -8.414 -15.156 -12.111  1.00 44.30           H  
ATOM    182  HB2 ASN    12      -8.032 -13.422  -9.655  1.00 37.41           H  
ATOM    183  HB3 ASN    12      -9.509 -14.270 -10.103  1.00 37.41           H  
ATOM    184 HD21 ASN    12      -7.934 -14.496  -7.693  1.00 37.41           H  
ATOM    185 HD22 ASN    12      -7.463 -16.156  -7.583  1.00 37.41           H  
ATOM    186  N   ASP    13      -7.615 -12.331 -13.021  1.00 50.41           N  
ATOM    187  CA  ASP    13      -7.914 -11.021 -13.626  1.00 62.51           C  
ATOM    188  C   ASP    13      -8.024  -9.907 -12.568  1.00 12.43           C  
ATOM    189  O   ASP    13      -8.190  -8.735 -12.913  1.00 50.44           O  
ATOM    190  CB  ASP    13      -9.186 -11.065 -14.493  1.00 13.34           C  
ATOM    191  CG  ASP    13      -8.954 -11.755 -15.823  1.00 73.13           C  
ATOM    192  OD1 ASP    13      -8.463 -11.087 -16.760  1.00 10.25           O  
ATOM    193  OD2 ASP    13      -9.254 -12.964 -15.938  1.00 60.13           O  
ATOM    194  H   ASP    13      -6.725 -12.718 -13.165  1.00 37.41           H  
ATOM    195  HA  ASP    13      -7.078 -10.779 -14.267  1.00 70.42           H  
ATOM    196  HB2 ASP    13      -9.962 -11.595 -13.960  1.00 37.41           H  
ATOM    197  HB3 ASP    13      -9.520 -10.054 -14.686  1.00 37.41           H  
ATOM    198  N   GLN    14      -7.900 -10.275 -11.292  1.00 32.13           N  
ATOM    199  CA  GLN    14      -7.973  -9.309 -10.191  1.00 61.21           C  
ATOM    200  C   GLN    14      -6.763  -8.367 -10.199  1.00 42.43           C  
ATOM    201  O   GLN    14      -5.650  -8.771 -10.534  1.00 44.04           O  
ATOM    202  CB  GLN    14      -8.056 -10.042  -8.848  1.00 55.01           C  
ATOM    203  CG  GLN    14      -9.291 -10.920  -8.699  1.00 41.00           C  
ATOM    204  CD  GLN    14      -9.368 -11.589  -7.339  1.00 63.31           C  
ATOM    205  OE1 GLN    14      -8.861 -12.691  -7.139  1.00 40.21           O  
ATOM    206  NE2 GLN    14      -9.989 -10.919  -6.388  1.00 52.14           N  
ATOM    207  H   GLN    14      -7.752 -11.216 -11.085  1.00 37.41           H  
ATOM    208  HA  GLN    14      -8.873  -8.721 -10.324  1.00 31.13           H  
ATOM    209  HB2 GLN    14      -7.182 -10.668  -8.739  1.00 37.41           H  
ATOM    210  HB3 GLN    14      -8.063  -9.309  -8.050  1.00 37.41           H  
ATOM    211  HG2 GLN    14     -10.173 -10.309  -8.835  1.00 37.41           H  
ATOM    212  HG3 GLN    14      -9.267 -11.687  -9.461  1.00 37.41           H  
ATOM    213 HE21 GLN    14     -10.356 -10.040  -6.606  1.00 37.41           H  
ATOM    214 HE22 GLN    14     -10.067 -11.336  -5.507  1.00 37.41           H  
ATOM    215  N   PHE    15      -6.984  -7.119  -9.814  1.00 34.33           N  
ATOM    216  CA  PHE    15      -5.946  -6.088  -9.886  1.00 11.02           C  
ATOM    217  C   PHE    15      -5.339  -5.799  -8.506  1.00 12.22           C  
ATOM    218  O   PHE    15      -6.057  -5.669  -7.517  1.00  5.21           O  
ATOM    219  CB  PHE    15      -6.550  -4.800 -10.462  1.00 74.34           C  
ATOM    220  CG  PHE    15      -7.348  -5.021 -11.726  1.00 43.43           C  
ATOM    221  CD1 PHE    15      -6.715  -5.122 -12.954  1.00 11.24           C  
ATOM    222  CD2 PHE    15      -8.732  -5.131 -11.680  1.00 33.13           C  
ATOM    223  CE1 PHE    15      -7.443  -5.326 -14.110  1.00 51.03           C  
ATOM    224  CE2 PHE    15      -9.463  -5.335 -12.835  1.00  2.13           C  
ATOM    225  CZ  PHE    15      -8.818  -5.432 -14.050  1.00 45.41           C  
ATOM    226  H   PHE    15      -7.868  -6.879  -9.467  1.00 37.41           H  
ATOM    227  HA  PHE    15      -5.167  -6.437 -10.549  1.00 73.33           H  
ATOM    228  HB2 PHE    15      -7.207  -4.356  -9.725  1.00 37.41           H  
ATOM    229  HB3 PHE    15      -5.753  -4.104 -10.686  1.00 37.41           H  
ATOM    230  HD1 PHE    15      -5.639  -5.040 -13.004  1.00 42.24           H  
ATOM    231  HD2 PHE    15      -9.239  -5.057 -10.729  1.00 24.11           H  
ATOM    232  HE1 PHE    15      -6.938  -5.402 -15.060  1.00 73.33           H  
ATOM    233  HE2 PHE    15     -10.539  -5.417 -12.786  1.00 13.42           H  
ATOM    234  HZ  PHE    15      -9.388  -5.589 -14.953  1.00 71.34           H  
ATOM    235  N   LYS    16      -4.013  -5.695  -8.446  1.00 31.41           N  
ATOM    236  CA  LYS    16      -3.332  -5.276  -7.216  1.00 15.33           C  
ATOM    237  C   LYS    16      -2.193  -4.297  -7.539  1.00  4.33           C  
ATOM    238  O   LYS    16      -1.420  -4.510  -8.477  1.00 10.15           O  
ATOM    239  CB  LYS    16      -2.802  -6.487  -6.416  1.00 42.11           C  
ATOM    240  CG  LYS    16      -1.604  -7.217  -7.030  1.00 31.14           C  
ATOM    241  CD  LYS    16      -1.976  -8.053  -8.255  1.00 13.43           C  
ATOM    242  CE  LYS    16      -0.779  -8.849  -8.774  1.00 54.14           C  
ATOM    243  NZ  LYS    16      -0.218  -9.756  -7.733  1.00 10.20           N  
ATOM    244  H   LYS    16      -3.479  -5.908  -9.244  1.00 37.41           H  
ATOM    245  HA  LYS    16      -4.059  -4.752  -6.607  1.00 12.31           H  
ATOM    246  HB2 LYS    16      -2.508  -6.144  -5.433  1.00 37.41           H  
ATOM    247  HB3 LYS    16      -3.608  -7.198  -6.302  1.00 37.41           H  
ATOM    248  HG2 LYS    16      -0.865  -6.486  -7.324  1.00 37.41           H  
ATOM    249  HG3 LYS    16      -1.177  -7.871  -6.280  1.00 37.41           H  
ATOM    250  HD2 LYS    16      -2.762  -8.742  -7.982  1.00 37.41           H  
ATOM    251  HD3 LYS    16      -2.328  -7.394  -9.037  1.00 37.41           H  
ATOM    252  HE2 LYS    16      -1.095  -9.442  -9.619  1.00 37.41           H  
ATOM    253  HE3 LYS    16      -0.010  -8.159  -9.088  1.00 37.41           H  
ATOM    254  HZ1 LYS    16      -0.943 -10.432  -7.415  1.00 37.41           H  
ATOM    255  HZ2 LYS    16       0.107  -9.206  -6.912  1.00 37.41           H  
ATOM    256  HZ3 LYS    16       0.589 -10.290  -8.116  1.00 37.41           H  
ATOM    257  N   PHE    17      -2.108  -3.208  -6.777  1.00 74.03           N  
ATOM    258  CA  PHE    17      -1.075  -2.191  -7.000  1.00 53.02           C  
ATOM    259  C   PHE    17      -0.005  -2.223  -5.901  1.00 30.43           C  
ATOM    260  O   PHE    17      -0.299  -2.478  -4.730  1.00 23.23           O  
ATOM    261  CB  PHE    17      -1.699  -0.787  -7.109  1.00 61.40           C  
ATOM    262  CG  PHE    17      -2.509  -0.354  -5.908  1.00 22.44           C  
ATOM    263  CD1 PHE    17      -3.851  -0.698  -5.797  1.00 25.42           C  
ATOM    264  CD2 PHE    17      -1.934   0.413  -4.902  1.00 11.02           C  
ATOM    265  CE1 PHE    17      -4.599  -0.289  -4.707  1.00  3.25           C  
ATOM    266  CE2 PHE    17      -2.679   0.826  -3.812  1.00 61.51           C  
ATOM    267  CZ  PHE    17      -4.013   0.475  -3.714  1.00 53.33           C  
ATOM    268  H   PHE    17      -2.748  -3.087  -6.047  1.00 37.41           H  
ATOM    269  HA  PHE    17      -0.593  -2.422  -7.942  1.00 71.45           H  
ATOM    270  HB2 PHE    17      -0.910  -0.063  -7.253  1.00 37.41           H  
ATOM    271  HB3 PHE    17      -2.350  -0.763  -7.974  1.00 37.41           H  
ATOM    272  HD1 PHE    17      -4.311  -1.293  -6.572  1.00 23.54           H  
ATOM    273  HD2 PHE    17      -0.891   0.688  -4.976  1.00 22.11           H  
ATOM    274  HE1 PHE    17      -5.642  -0.566  -4.633  1.00 15.40           H  
ATOM    275  HE2 PHE    17      -2.218   1.422  -3.036  1.00 34.02           H  
ATOM    276  HZ  PHE    17      -4.597   0.797  -2.862  1.00  5.30           H  
ATOM    277  N   VAL    18       1.239  -1.967  -6.293  1.00 22.04           N  
ATOM    278  CA  VAL    18       2.366  -1.971  -5.355  1.00 54.43           C  
ATOM    279  C   VAL    18       3.086  -0.611  -5.328  1.00 22.02           C  
ATOM    280  O   VAL    18       3.423  -0.044  -6.371  1.00 23.21           O  
ATOM    281  CB  VAL    18       3.384  -3.091  -5.700  1.00 44.42           C  
ATOM    282  CG1 VAL    18       2.765  -4.472  -5.488  1.00 41.30           C  
ATOM    283  CG2 VAL    18       3.901  -2.944  -7.134  1.00 73.52           C  
ATOM    284  H   VAL    18       1.409  -1.778  -7.239  1.00 37.41           H  
ATOM    285  HA  VAL    18       1.973  -2.169  -4.366  1.00 54.53           H  
ATOM    286  HB  VAL    18       4.227  -2.997  -5.027  1.00 60.00           H  
ATOM    287 HG11 VAL    18       2.445  -4.568  -4.460  1.00 37.41           H  
ATOM    288 HG12 VAL    18       3.498  -5.236  -5.708  1.00 37.41           H  
ATOM    289 HG13 VAL    18       1.913  -4.592  -6.142  1.00 37.41           H  
ATOM    290 HG21 VAL    18       3.072  -3.005  -7.826  1.00 37.41           H  
ATOM    291 HG22 VAL    18       4.605  -3.735  -7.348  1.00 37.41           H  
ATOM    292 HG23 VAL    18       4.391  -1.987  -7.246  1.00 37.41           H  
ATOM    293  N   LEU    19       3.304  -0.092  -4.125  1.00 52.03           N  
ATOM    294  CA  LEU    19       4.021   1.173  -3.934  1.00 24.34           C  
ATOM    295  C   LEU    19       5.504   0.916  -3.629  1.00 42.15           C  
ATOM    296  O   LEU    19       5.838   0.190  -2.691  1.00 31.33           O  
ATOM    297  CB  LEU    19       3.377   1.971  -2.791  1.00 55.15           C  
ATOM    298  CG  LEU    19       4.090   3.280  -2.402  1.00 63.53           C  
ATOM    299  CD1 LEU    19       4.113   4.265  -3.570  1.00 65.03           C  
ATOM    300  CD2 LEU    19       3.432   3.907  -1.174  1.00 62.21           C  
ATOM    301  H   LEU    19       2.973  -0.572  -3.337  1.00 37.41           H  
ATOM    302  HA  LEU    19       3.946   1.745  -4.850  1.00 24.45           H  
ATOM    303  HB2 LEU    19       2.363   2.209  -3.079  1.00 37.41           H  
ATOM    304  HB3 LEU    19       3.342   1.335  -1.918  1.00 37.41           H  
ATOM    305  HG  LEU    19       5.116   3.054  -2.147  1.00 54.21           H  
ATOM    306 HD11 LEU    19       3.100   4.489  -3.876  1.00 37.41           H  
ATOM    307 HD12 LEU    19       4.650   3.830  -4.401  1.00 37.41           H  
ATOM    308 HD13 LEU    19       4.605   5.176  -3.263  1.00 37.41           H  
ATOM    309 HD21 LEU    19       2.399   4.136  -1.392  1.00 37.41           H  
ATOM    310 HD22 LEU    19       3.954   4.817  -0.911  1.00 37.41           H  
ATOM    311 HD23 LEU    19       3.481   3.216  -0.344  1.00 37.41           H  
ATOM    312  N   LYS    20       6.390   1.506  -4.431  1.00 33.45           N  
ATOM    313  CA  LYS    20       7.837   1.352  -4.228  1.00 63.43           C  
ATOM    314  C   LYS    20       8.451   2.586  -3.550  1.00 41.42           C  
ATOM    315  O   LYS    20       8.049   3.714  -3.819  1.00 10.34           O  
ATOM    316  CB  LYS    20       8.554   1.068  -5.563  1.00  1.45           C  
ATOM    317  CG  LYS    20       8.383  -0.369  -6.067  1.00  2.44           C  
ATOM    318  CD  LYS    20       6.992  -0.637  -6.637  1.00 64.21           C  
ATOM    319  CE  LYS    20       6.845  -0.091  -8.043  1.00  4.33           C  
ATOM    320  NZ  LYS    20       7.743  -0.793  -9.006  1.00 70.21           N  
ATOM    321  H   LYS    20       6.064   2.064  -5.171  1.00 37.41           H  
ATOM    322  HA  LYS    20       7.985   0.502  -3.574  1.00 54.55           H  
ATOM    323  HB2 LYS    20       8.168   1.740  -6.317  1.00 37.41           H  
ATOM    324  HB3 LYS    20       9.612   1.256  -5.438  1.00 37.41           H  
ATOM    325  HG2 LYS    20       9.116  -0.555  -6.838  1.00 37.41           H  
ATOM    326  HG3 LYS    20       8.560  -1.046  -5.242  1.00 37.41           H  
ATOM    327  HD2 LYS    20       6.824  -1.702  -6.663  1.00 37.41           H  
ATOM    328  HD3 LYS    20       6.254  -0.170  -6.002  1.00 37.41           H  
ATOM    329  HE2 LYS    20       5.822  -0.223  -8.359  1.00 37.41           H  
ATOM    330  HE3 LYS    20       7.088   0.960  -8.036  1.00 37.41           H  
ATOM    331  HZ1 LYS    20       7.384  -1.753  -9.195  1.00 37.41           H  
ATOM    332  HZ2 LYS    20       8.705  -0.861  -8.622  1.00 37.41           H  
ATOM    333  HZ3 LYS    20       7.778  -0.275  -9.907  1.00 37.41           H  
ATOM    334  N   ALA    21       9.428   2.352  -2.671  1.00 15.14           N  
ATOM    335  CA  ALA    21      10.115   3.432  -1.950  1.00 74.41           C  
ATOM    336  C   ALA    21      10.840   4.396  -2.906  1.00 70.03           C  
ATOM    337  O   ALA    21      10.640   5.609  -2.844  1.00  2.32           O  
ATOM    338  CB  ALA    21      11.103   2.839  -0.948  1.00 55.31           C  
ATOM    339  H   ALA    21       9.690   1.424  -2.493  1.00 37.41           H  
ATOM    340  HA  ALA    21       9.370   3.986  -1.395  1.00 43.44           H  
ATOM    341  HB1 ALA    21      10.578   2.178  -0.273  1.00 37.41           H  
ATOM    342  HB2 ALA    21      11.566   3.636  -0.383  1.00 37.41           H  
ATOM    343  HB3 ALA    21      11.864   2.284  -1.476  1.00 37.41           H  
ATOM    344  N   GLY    22      11.682   3.840  -3.777  1.00 32.43           N  
ATOM    345  CA  GLY    22      12.417   4.656  -4.743  1.00 65.25           C  
ATOM    346  C   GLY    22      13.304   3.833  -5.674  1.00 43.13           C  
ATOM    347  O   GLY    22      13.199   3.930  -6.893  1.00 21.33           O  
ATOM    348  H   GLY    22      11.811   2.873  -3.760  1.00 37.41           H  
ATOM    349  HA2 GLY    22      11.707   5.212  -5.340  1.00 37.41           H  
ATOM    350  HA3 GLY    22      13.041   5.357  -4.203  1.00 37.41           H  
ATOM    351  N   ASN    23      14.167   3.000  -5.096  1.00 64.32           N  
ATOM    352  CA  ASN    23      15.101   2.174  -5.885  1.00 13.20           C  
ATOM    353  C   ASN    23      14.403   0.985  -6.576  1.00 64.53           C  
ATOM    354  O   ASN    23      15.057   0.162  -7.218  1.00  4.43           O  
ATOM    355  CB  ASN    23      16.222   1.642  -4.984  1.00  5.33           C  
ATOM    356  CG  ASN    23      15.692   0.766  -3.862  1.00 25.22           C  
ATOM    357  OD1 ASN    23      15.512  -0.435  -4.025  1.00 20.42           O  
ATOM    358  ND2 ASN    23      15.436   1.361  -2.714  1.00 32.25           N  
ATOM    359  H   ASN    23      14.195   2.951  -4.116  1.00 37.41           H  
ATOM    360  HA  ASN    23      15.538   2.805  -6.645  1.00 42.31           H  
ATOM    361  HB2 ASN    23      16.909   1.057  -5.580  1.00 37.41           H  
ATOM    362  HB3 ASN    23      16.754   2.477  -4.550  1.00 37.41           H  
ATOM    363 HD21 ASN    23      15.594   2.326  -2.643  1.00 37.41           H  
ATOM    364 HD22 ASN    23      15.105   0.811  -1.974  1.00 37.41           H  
ATOM    365  N   GLY    24      13.081   0.900  -6.452  1.00 13.42           N  
ATOM    366  CA  GLY    24      12.345  -0.253  -6.968  1.00 11.14           C  
ATOM    367  C   GLY    24      11.843  -1.172  -5.857  1.00 21.53           C  
ATOM    368  O   GLY    24      10.939  -1.981  -6.068  1.00 12.42           O  
ATOM    369  H   GLY    24      12.597   1.636  -6.028  1.00 37.41           H  
ATOM    370  HA2 GLY    24      11.496   0.104  -7.533  1.00 37.41           H  
ATOM    371  HA3 GLY    24      12.987  -0.822  -7.628  1.00 37.41           H  
ATOM    372  N   GLU    25      12.440  -1.042  -4.675  1.00 54.13           N  
ATOM    373  CA  GLU    25      12.017  -1.788  -3.482  1.00  3.13           C  
ATOM    374  C   GLU    25      10.554  -1.474  -3.113  1.00 52.25           C  
ATOM    375  O   GLU    25      10.193  -0.313  -2.913  1.00 55.42           O  
ATOM    376  CB  GLU    25      12.945  -1.435  -2.311  1.00  1.11           C  
ATOM    377  CG  GLU    25      12.583  -2.096  -0.987  1.00 25.03           C  
ATOM    378  CD  GLU    25      13.518  -1.679   0.136  1.00  2.32           C  
ATOM    379  OE1 GLU    25      13.394  -0.538   0.625  1.00 33.43           O  
ATOM    380  OE2 GLU    25      14.398  -2.480   0.521  1.00  5.43           O  
ATOM    381  H   GLU    25      13.201  -0.430  -4.600  1.00 37.41           H  
ATOM    382  HA  GLU    25      12.108  -2.843  -3.697  1.00 33.42           H  
ATOM    383  HB2 GLU    25      13.952  -1.731  -2.569  1.00 37.41           H  
ATOM    384  HB3 GLU    25      12.927  -0.361  -2.168  1.00 37.41           H  
ATOM    385  HG2 GLU    25      11.573  -1.816  -0.721  1.00 37.41           H  
ATOM    386  HG3 GLU    25      12.637  -3.170  -1.106  1.00 37.41           H  
ATOM    387  N   VAL    26       9.719  -2.509  -3.029  1.00 55.41           N  
ATOM    388  CA  VAL    26       8.293  -2.340  -2.714  1.00 44.33           C  
ATOM    389  C   VAL    26       8.057  -2.237  -1.197  1.00 35.44           C  
ATOM    390  O   VAL    26       8.505  -3.089  -0.430  1.00 45.23           O  
ATOM    391  CB  VAL    26       7.450  -3.517  -3.277  1.00 24.14           C  
ATOM    392  CG1 VAL    26       5.963  -3.324  -2.972  1.00 40.43           C  
ATOM    393  CG2 VAL    26       7.683  -3.679  -4.781  1.00 75.21           C  
ATOM    394  H   VAL    26      10.068  -3.414  -3.178  1.00 37.41           H  
ATOM    395  HA  VAL    26       7.954  -1.427  -3.185  1.00 33.13           H  
ATOM    396  HB  VAL    26       7.775  -4.426  -2.788  1.00 11.33           H  
ATOM    397 HG11 VAL    26       5.401  -4.152  -3.378  1.00 37.41           H  
ATOM    398 HG12 VAL    26       5.616  -2.402  -3.420  1.00 37.41           H  
ATOM    399 HG13 VAL    26       5.816  -3.281  -1.903  1.00 37.41           H  
ATOM    400 HG21 VAL    26       8.738  -3.827  -4.969  1.00 37.41           H  
ATOM    401 HG22 VAL    26       7.349  -2.791  -5.299  1.00 37.41           H  
ATOM    402 HG23 VAL    26       7.133  -4.535  -5.142  1.00 37.41           H  
ATOM    403  N   ILE    27       7.346  -1.191  -0.773  1.00  4.41           N  
ATOM    404  CA  ILE    27       7.030  -0.986   0.647  1.00  4.54           C  
ATOM    405  C   ILE    27       5.568  -1.348   0.975  1.00  3.14           C  
ATOM    406  O   ILE    27       5.275  -1.837   2.064  1.00 23.10           O  
ATOM    407  CB  ILE    27       7.318   0.477   1.088  1.00 42.43           C  
ATOM    408  CG1 ILE    27       6.607   1.478   0.157  1.00 33.30           C  
ATOM    409  CG2 ILE    27       8.823   0.740   1.129  1.00 23.50           C  
ATOM    410  CD1 ILE    27       6.893   2.933   0.474  1.00 42.13           C  
ATOM    411  H   ILE    27       7.027  -0.540  -1.431  1.00 37.41           H  
ATOM    412  HA  ILE    27       7.677  -1.639   1.224  1.00 11.11           H  
ATOM    413  HB  ILE    27       6.937   0.603   2.092  1.00 11.11           H  
ATOM    414 HG12 ILE    27       6.919   1.298  -0.862  1.00 37.41           H  
ATOM    415 HG13 ILE    27       5.538   1.329   0.228  1.00 37.41           H  
ATOM    416 HG21 ILE    27       9.236   0.637   0.137  1.00 37.41           H  
ATOM    417 HG22 ILE    27       9.296   0.029   1.791  1.00 37.41           H  
ATOM    418 HG23 ILE    27       9.003   1.742   1.492  1.00 37.41           H  
ATOM    419 HD11 ILE    27       7.949   3.129   0.359  1.00 37.41           H  
ATOM    420 HD12 ILE    27       6.595   3.151   1.491  1.00 37.41           H  
ATOM    421 HD13 ILE    27       6.337   3.563  -0.205  1.00 37.41           H  
ATOM    422  N   LEU    28       4.654  -1.107   0.029  1.00  4.22           N  
ATOM    423  CA  LEU    28       3.226  -1.431   0.210  1.00 60.34           C  
ATOM    424  C   LEU    28       2.710  -2.337  -0.916  1.00 13.24           C  
ATOM    425  O   LEU    28       2.926  -2.061  -2.095  1.00 51.11           O  
ATOM    426  CB  LEU    28       2.365  -0.148   0.265  1.00 13.32           C  
ATOM    427  CG  LEU    28       2.170   0.493   1.654  1.00  1.30           C  
ATOM    428  CD1 LEU    28       1.429  -0.455   2.592  1.00 51.54           C  
ATOM    429  CD2 LEU    28       3.503   0.911   2.258  1.00 11.51           C  
ATOM    430  H   LEU    28       4.943  -0.701  -0.816  1.00 37.41           H  
ATOM    431  HA  LEU    28       3.123  -1.959   1.150  1.00 32.34           H  
ATOM    432  HB2 LEU    28       2.821   0.588  -0.381  1.00 37.41           H  
ATOM    433  HB3 LEU    28       1.384  -0.381  -0.133  1.00 37.41           H  
ATOM    434  HG  LEU    28       1.565   1.381   1.544  1.00 21.42           H  
ATOM    435 HD11 LEU    28       0.466  -0.702   2.169  1.00 37.41           H  
ATOM    436 HD12 LEU    28       1.288   0.023   3.552  1.00 37.41           H  
ATOM    437 HD13 LEU    28       2.006  -1.358   2.725  1.00 37.41           H  
ATOM    438 HD21 LEU    28       4.121   0.040   2.408  1.00 37.41           H  
ATOM    439 HD22 LEU    28       3.333   1.397   3.207  1.00 37.41           H  
ATOM    440 HD23 LEU    28       4.005   1.595   1.589  1.00 37.41           H  
ATOM    441  N   THR    29       2.027  -3.415  -0.540  1.00 42.25           N  
ATOM    442  CA  THR    29       1.398  -4.329  -1.505  1.00  3.53           C  
ATOM    443  C   THR    29      -0.089  -4.530  -1.181  1.00 50.11           C  
ATOM    444  O   THR    29      -0.436  -5.182  -0.195  1.00  2.20           O  
ATOM    445  CB  THR    29       2.089  -5.715  -1.513  1.00  3.43           C  
ATOM    446  OG1 THR    29       3.497  -5.570  -1.777  1.00 62.22           O  
ATOM    447  CG2 THR    29       1.467  -6.643  -2.559  1.00 43.44           C  
ATOM    448  H   THR    29       1.947  -3.611   0.416  1.00 37.41           H  
ATOM    449  HA  THR    29       1.489  -3.897  -2.495  1.00 31.01           H  
ATOM    450  HB  THR    29       1.965  -6.167  -0.537  1.00 62.51           H  
ATOM    451  HG1 THR    29       3.867  -4.912  -1.174  1.00 71.20           H  
ATOM    452 HG21 THR    29       0.423  -6.800  -2.327  1.00 37.41           H  
ATOM    453 HG22 THR    29       1.983  -7.592  -2.552  1.00 37.41           H  
ATOM    454 HG23 THR    29       1.555  -6.194  -3.538  1.00 37.41           H  
ATOM    455  N   SER    30      -0.966  -3.964  -2.002  1.00 12.02           N  
ATOM    456  CA  SER    30      -2.415  -4.109  -1.802  1.00 32.42           C  
ATOM    457  C   SER    30      -2.917  -5.478  -2.279  1.00 71.31           C  
ATOM    458  O   SER    30      -2.366  -6.063  -3.210  1.00 12.20           O  
ATOM    459  CB  SER    30      -3.166  -2.992  -2.529  1.00 40.31           C  
ATOM    460  OG  SER    30      -2.809  -1.723  -2.009  1.00 75.03           O  
ATOM    461  H   SER    30      -0.637  -3.433  -2.762  1.00 37.41           H  
ATOM    462  HA  SER    30      -2.609  -4.024  -0.740  1.00 24.21           H  
ATOM    463  HB2 SER    30      -2.917  -3.016  -3.581  1.00 37.41           H  
ATOM    464  HB3 SER    30      -4.230  -3.132  -2.406  1.00 37.41           H  
ATOM    465  HG  SER    30      -3.596  -1.280  -1.671  1.00 71.43           H  
ATOM    466  N   GLU    31      -3.971  -5.977  -1.634  1.00 73.33           N  
ATOM    467  CA  GLU    31      -4.517  -7.305  -1.944  1.00  3.32           C  
ATOM    468  C   GLU    31      -5.400  -7.270  -3.211  1.00 40.31           C  
ATOM    469  O   GLU    31      -5.730  -6.200  -3.721  1.00 52.34           O  
ATOM    470  CB  GLU    31      -5.301  -7.835  -0.729  1.00 60.41           C  
ATOM    471  CG  GLU    31      -5.616  -9.328  -0.785  1.00 21.24           C  
ATOM    472  CD  GLU    31      -6.150  -9.867   0.533  1.00 21.13           C  
ATOM    473  OE1 GLU    31      -5.332 -10.197   1.419  1.00 42.33           O  
ATOM    474  OE2 GLU    31      -7.384  -9.967   0.691  1.00 53.31           O  
ATOM    475  H   GLU    31      -4.396  -5.440  -0.936  1.00 37.41           H  
ATOM    476  HA  GLU    31      -3.681  -7.966  -2.130  1.00 12.32           H  
ATOM    477  HB2 GLU    31      -4.719  -7.649   0.163  1.00 37.41           H  
ATOM    478  HB3 GLU    31      -6.235  -7.293  -0.653  1.00 37.41           H  
ATOM    479  HG2 GLU    31      -6.357  -9.497  -1.555  1.00 37.41           H  
ATOM    480  HG3 GLU    31      -4.713  -9.865  -1.038  1.00 37.41           H  
ATOM    481  N   LEU    32      -5.778  -8.448  -3.709  1.00 31.41           N  
ATOM    482  CA  LEU    32      -6.494  -8.574  -4.988  1.00 40.14           C  
ATOM    483  C   LEU    32      -7.866  -7.870  -5.000  1.00 75.44           C  
ATOM    484  O   LEU    32      -8.808  -8.295  -4.327  1.00 53.22           O  
ATOM    485  CB  LEU    32      -6.674 -10.060  -5.335  1.00 14.41           C  
ATOM    486  CG  LEU    32      -5.371 -10.842  -5.569  1.00 55.35           C  
ATOM    487  CD1 LEU    32      -5.662 -12.309  -5.881  1.00 43.45           C  
ATOM    488  CD2 LEU    32      -4.552 -10.204  -6.689  1.00 22.01           C  
ATOM    489  H   LEU    32      -5.565  -9.259  -3.210  1.00 37.41           H  
ATOM    490  HA  LEU    32      -5.873  -8.122  -5.748  1.00 11.12           H  
ATOM    491  HB2 LEU    32      -7.213 -10.533  -4.525  1.00 37.41           H  
ATOM    492  HB3 LEU    32      -7.275 -10.130  -6.231  1.00 37.41           H  
ATOM    493  HG  LEU    32      -4.779 -10.810  -4.665  1.00 11.42           H  
ATOM    494 HD11 LEU    32      -6.278 -12.376  -6.768  1.00 37.41           H  
ATOM    495 HD12 LEU    32      -6.182 -12.758  -5.048  1.00 37.41           H  
ATOM    496 HD13 LEU    32      -4.733 -12.834  -6.048  1.00 37.41           H  
ATOM    497 HD21 LEU    32      -3.639 -10.763  -6.829  1.00 37.41           H  
ATOM    498 HD22 LEU    32      -4.311  -9.185  -6.426  1.00 37.41           H  
ATOM    499 HD23 LEU    32      -5.123 -10.214  -7.606  1.00 37.41           H  
ATOM    500  N   TYR    33      -7.965  -6.790  -5.775  1.00 11.35           N  
ATOM    501  CA  TYR    33      -9.249  -6.138  -6.051  1.00 11.52           C  
ATOM    502  C   TYR    33      -9.951  -6.803  -7.244  1.00 23.01           C  
ATOM    503  O   TYR    33      -9.325  -7.082  -8.265  1.00 43.55           O  
ATOM    504  CB  TYR    33      -9.043  -4.646  -6.357  1.00 50.44           C  
ATOM    505  CG  TYR    33      -8.682  -3.799  -5.149  1.00 53.22           C  
ATOM    506  CD1 TYR    33      -7.393  -3.804  -4.627  1.00 25.22           C  
ATOM    507  CD2 TYR    33      -9.634  -2.992  -4.534  1.00 32.12           C  
ATOM    508  CE1 TYR    33      -7.065  -3.030  -3.529  1.00 54.14           C  
ATOM    509  CE2 TYR    33      -9.312  -2.216  -3.437  1.00  5.53           C  
ATOM    510  CZ  TYR    33      -8.029  -2.239  -2.939  1.00 72.32           C  
ATOM    511  OH  TYR    33      -7.713  -1.471  -1.839  1.00 32.34           O  
ATOM    512  H   TYR    33      -7.147  -6.415  -6.167  1.00 37.41           H  
ATOM    513  HA  TYR    33      -9.875  -6.236  -5.174  1.00 51.34           H  
ATOM    514  HB2 TYR    33      -8.246  -4.543  -7.080  1.00 37.41           H  
ATOM    515  HB3 TYR    33      -9.954  -4.247  -6.783  1.00 37.41           H  
ATOM    516  HD1 TYR    33      -6.640  -4.426  -5.091  1.00 54.13           H  
ATOM    517  HD2 TYR    33     -10.641  -2.976  -4.925  1.00 75.03           H  
ATOM    518  HE1 TYR    33      -6.057  -3.047  -3.139  1.00 13.12           H  
ATOM    519  HE2 TYR    33     -10.066  -1.596  -2.976  1.00 52.15           H  
ATOM    520  HH  TYR    33      -6.843  -1.077  -1.960  1.00 61.43           H  
ATOM    521  N   THR    34     -11.253  -7.044  -7.126  1.00 23.34           N  
ATOM    522  CA  THR    34     -12.024  -7.667  -8.217  1.00  0.23           C  
ATOM    523  C   THR    34     -12.409  -6.652  -9.305  1.00 51.22           C  
ATOM    524  O   THR    34     -13.006  -7.010 -10.319  1.00 71.32           O  
ATOM    525  CB  THR    34     -13.311  -8.338  -7.688  1.00 34.04           C  
ATOM    526  OG1 THR    34     -14.136  -7.365  -7.029  1.00 52.13           O  
ATOM    527  CG2 THR    34     -12.980  -9.470  -6.719  1.00 45.25           C  
ATOM    528  H   THR    34     -11.710  -6.807  -6.291  1.00 37.41           H  
ATOM    529  HA  THR    34     -11.406  -8.433  -8.663  1.00 53.15           H  
ATOM    530  HB  THR    34     -13.856  -8.750  -8.526  1.00 11.22           H  
ATOM    531  HG1 THR    34     -14.964  -7.264  -7.518  1.00 54.02           H  
ATOM    532 HG21 THR    34     -13.896  -9.921  -6.365  1.00 37.41           H  
ATOM    533 HG22 THR    34     -12.426  -9.076  -5.879  1.00 37.41           H  
ATOM    534 HG23 THR    34     -12.384 -10.216  -7.225  1.00 37.41           H  
ATOM    535  N   GLY    35     -12.063  -5.386  -9.087  1.00 32.43           N  
ATOM    536  CA  GLY    35     -12.350  -4.339 -10.064  1.00 11.33           C  
ATOM    537  C   GLY    35     -11.308  -3.223 -10.037  1.00  4.14           C  
ATOM    538  O   GLY    35     -10.841  -2.834  -8.963  1.00  4.34           O  
ATOM    539  H   GLY    35     -11.606  -5.156  -8.253  1.00 37.41           H  
ATOM    540  HA2 GLY    35     -12.372  -4.774 -11.052  1.00 37.41           H  
ATOM    541  HA3 GLY    35     -13.319  -3.918  -9.847  1.00 37.41           H  
ATOM    542  N   LYS    36     -10.949  -2.697 -11.208  1.00 34.30           N  
ATOM    543  CA  LYS    36      -9.908  -1.662 -11.301  1.00 51.21           C  
ATOM    544  C   LYS    36     -10.348  -0.358 -10.615  1.00 14.33           C  
ATOM    545  O   LYS    36      -9.536   0.323  -9.991  1.00 14.21           O  
ATOM    546  CB  LYS    36      -9.538  -1.392 -12.767  1.00 64.03           C  
ATOM    547  CG  LYS    36      -8.450  -0.329 -12.934  1.00  4.43           C  
ATOM    548  CD  LYS    36      -7.999  -0.180 -14.384  1.00 75.05           C  
ATOM    549  CE  LYS    36      -7.329  -1.447 -14.907  1.00 30.43           C  
ATOM    550  NZ  LYS    36      -6.824  -1.274 -16.294  1.00 15.40           N  
ATOM    551  H   LYS    36     -11.399  -2.997 -12.026  1.00 37.41           H  
ATOM    552  HA  LYS    36      -9.034  -2.040 -10.788  1.00 74.12           H  
ATOM    553  HB2 LYS    36      -9.188  -2.313 -13.213  1.00 37.41           H  
ATOM    554  HB3 LYS    36     -10.421  -1.060 -13.295  1.00 37.41           H  
ATOM    555  HG2 LYS    36      -8.839   0.620 -12.593  1.00 37.41           H  
ATOM    556  HG3 LYS    36      -7.597  -0.602 -12.327  1.00 37.41           H  
ATOM    557  HD2 LYS    36      -8.861   0.037 -14.998  1.00 37.41           H  
ATOM    558  HD3 LYS    36      -7.297   0.641 -14.448  1.00 37.41           H  
ATOM    559  HE2 LYS    36      -6.500  -1.696 -14.262  1.00 37.41           H  
ATOM    560  HE3 LYS    36      -8.049  -2.252 -14.894  1.00 37.41           H  
ATOM    561  HZ1 LYS    36      -6.090  -0.537 -16.322  1.00 37.41           H  
ATOM    562  HZ2 LYS    36      -7.605  -0.997 -16.924  1.00 37.41           H  
ATOM    563  HZ3 LYS    36      -6.413  -2.166 -16.637  1.00 37.41           H  
ATOM    564  N   SER    37     -11.637  -0.030 -10.725  1.00 24.11           N  
ATOM    565  CA  SER    37     -12.206   1.158 -10.064  1.00 42.53           C  
ATOM    566  C   SER    37     -11.841   1.196  -8.573  1.00  4.25           C  
ATOM    567  O   SER    37     -11.376   2.213  -8.064  1.00 74.34           O  
ATOM    568  CB  SER    37     -13.737   1.184 -10.222  1.00 65.24           C  
ATOM    569  OG  SER    37     -14.322   2.265  -9.504  1.00 74.54           O  
ATOM    570  H   SER    37     -12.221  -0.594 -11.276  1.00 37.41           H  
ATOM    571  HA  SER    37     -11.790   2.033 -10.546  1.00 22.04           H  
ATOM    572  HB2 SER    37     -13.988   1.292 -11.268  1.00 37.41           H  
ATOM    573  HB3 SER    37     -14.152   0.258  -9.851  1.00 37.41           H  
ATOM    574  HG  SER    37     -13.892   3.093  -9.764  1.00  1.20           H  
ATOM    575  N   GLY    38     -12.040   0.071  -7.881  1.00  5.13           N  
ATOM    576  CA  GLY    38     -11.691  -0.019  -6.465  1.00 65.42           C  
ATOM    577  C   GLY    38     -10.193   0.119  -6.202  1.00 20.51           C  
ATOM    578  O   GLY    38      -9.782   0.729  -5.212  1.00 35.31           O  
ATOM    579  H   GLY    38     -12.434  -0.701  -8.334  1.00 37.41           H  
ATOM    580  HA2 GLY    38     -12.210   0.762  -5.929  1.00 37.41           H  
ATOM    581  HA3 GLY    38     -12.021  -0.977  -6.089  1.00 37.41           H  
ATOM    582  N   ALA    39      -9.375  -0.451  -7.084  1.00 14.51           N  
ATOM    583  CA  ALA    39      -7.916  -0.366  -6.955  1.00  2.15           C  
ATOM    584  C   ALA    39      -7.414   1.079  -7.131  1.00 43.23           C  
ATOM    585  O   ALA    39      -6.716   1.617  -6.269  1.00 65.03           O  
ATOM    586  CB  ALA    39      -7.246  -1.290  -7.966  1.00 22.11           C  
ATOM    587  H   ALA    39      -9.761  -0.943  -7.840  1.00 37.41           H  
ATOM    588  HA  ALA    39      -7.651  -0.706  -5.963  1.00 55.24           H  
ATOM    589  HB1 ALA    39      -7.593  -2.301  -7.816  1.00 37.41           H  
ATOM    590  HB2 ALA    39      -6.173  -1.255  -7.833  1.00 37.41           H  
ATOM    591  HB3 ALA    39      -7.492  -0.971  -8.970  1.00 37.41           H  
ATOM    592  N   MET    40      -7.786   1.701  -8.247  1.00  3.10           N  
ATOM    593  CA  MET    40      -7.380   3.081  -8.541  1.00 23.33           C  
ATOM    594  C   MET    40      -7.929   4.060  -7.491  1.00 42.24           C  
ATOM    595  O   MET    40      -7.181   4.866  -6.930  1.00 12.52           O  
ATOM    596  CB  MET    40      -7.850   3.485  -9.942  1.00 43.41           C  
ATOM    597  CG  MET    40      -7.287   2.606 -11.050  1.00 13.52           C  
ATOM    598  SD  MET    40      -5.482   2.610 -11.093  1.00 32.52           S  
ATOM    599  CE  MET    40      -5.155   4.329 -11.473  1.00 52.20           C  
ATOM    600  H   MET    40      -8.347   1.222  -8.892  1.00 37.41           H  
ATOM    601  HA  MET    40      -6.300   3.117  -8.513  1.00 73.45           H  
ATOM    602  HB2 MET    40      -8.930   3.426  -9.979  1.00 37.41           H  
ATOM    603  HB3 MET    40      -7.548   4.505 -10.132  1.00 37.41           H  
ATOM    604  HG2 MET    40      -7.627   1.592 -10.894  1.00 37.41           H  
ATOM    605  HG3 MET    40      -7.658   2.964 -12.000  1.00 37.41           H  
ATOM    606  HE1 MET    40      -5.544   4.955 -10.683  1.00 37.41           H  
ATOM    607  HE2 MET    40      -5.633   4.590 -12.407  1.00 37.41           H  
ATOM    608  HE3 MET    40      -4.089   4.482 -11.560  1.00 37.41           H  
ATOM    609  N   ASN    41      -9.235   3.982  -7.223  1.00 54.43           N  
ATOM    610  CA  ASN    41      -9.854   4.788  -6.164  1.00 55.45           C  
ATOM    611  C   ASN    41      -9.162   4.529  -4.817  1.00 34.44           C  
ATOM    612  O   ASN    41      -9.037   5.428  -3.983  1.00  2.44           O  
ATOM    613  CB  ASN    41     -11.353   4.477  -6.067  1.00 74.23           C  
ATOM    614  CG  ASN    41     -12.070   5.347  -5.048  1.00 64.35           C  
ATOM    615  OD1 ASN    41     -12.499   6.456  -5.352  1.00 42.11           O  
ATOM    616  ND2 ASN    41     -12.216   4.850  -3.835  1.00 53.21           N  
ATOM    617  H   ASN    41      -9.797   3.376  -7.756  1.00 37.41           H  
ATOM    618  HA  ASN    41      -9.726   5.831  -6.426  1.00 43.51           H  
ATOM    619  HB2 ASN    41     -11.811   4.637  -7.032  1.00 37.41           H  
ATOM    620  HB3 ASN    41     -11.482   3.442  -5.784  1.00 37.41           H  
ATOM    621 HD21 ASN    41     -11.856   3.955  -3.653  1.00 37.41           H  
ATOM    622 HD22 ASN    41     -12.684   5.392  -3.169  1.00 37.41           H  
ATOM    623  N   GLY    42      -8.703   3.292  -4.623  1.00 72.21           N  
ATOM    624  CA  GLY    42      -7.892   2.966  -3.460  1.00 21.21           C  
ATOM    625  C   GLY    42      -6.599   3.775  -3.407  1.00 52.31           C  
ATOM    626  O   GLY    42      -6.209   4.261  -2.346  1.00 32.41           O  
ATOM    627  H   GLY    42      -8.924   2.590  -5.273  1.00 37.41           H  
ATOM    628  HA2 GLY    42      -8.468   3.161  -2.565  1.00 37.41           H  
ATOM    629  HA3 GLY    42      -7.644   1.915  -3.494  1.00 37.41           H  
ATOM    630  N   ILE    43      -5.946   3.944  -4.562  1.00 11.41           N  
ATOM    631  CA  ILE    43      -4.716   4.744  -4.647  1.00 54.22           C  
ATOM    632  C   ILE    43      -4.993   6.213  -4.287  1.00 64.31           C  
ATOM    633  O   ILE    43      -4.294   6.809  -3.465  1.00 51.11           O  
ATOM    634  CB  ILE    43      -4.089   4.680  -6.067  1.00 51.41           C  
ATOM    635  CG1 ILE    43      -3.778   3.224  -6.457  1.00 75.32           C  
ATOM    636  CG2 ILE    43      -2.826   5.540  -6.136  1.00 72.23           C  
ATOM    637  CD1 ILE    43      -3.219   3.066  -7.857  1.00 23.24           C  
ATOM    638  H   ILE    43      -6.306   3.531  -5.378  1.00 37.41           H  
ATOM    639  HA  ILE    43      -4.005   4.338  -3.940  1.00 25.12           H  
ATOM    640  HB  ILE    43      -4.804   5.086  -6.769  1.00  3.44           H  
ATOM    641 HG12 ILE    43      -3.053   2.817  -5.767  1.00 37.41           H  
ATOM    642 HG13 ILE    43      -4.688   2.642  -6.397  1.00 37.41           H  
ATOM    643 HG21 ILE    43      -3.074   6.568  -5.907  1.00 37.41           H  
ATOM    644 HG22 ILE    43      -2.403   5.486  -7.128  1.00 37.41           H  
ATOM    645 HG23 ILE    43      -2.102   5.178  -5.418  1.00 37.41           H  
ATOM    646 HD11 ILE    43      -2.285   3.604  -7.936  1.00 37.41           H  
ATOM    647 HD12 ILE    43      -3.924   3.461  -8.573  1.00 37.41           H  
ATOM    648 HD13 ILE    43      -3.049   2.019  -8.060  1.00 37.41           H  
ATOM    649  N   GLU    44      -6.028   6.785  -4.900  1.00 42.02           N  
ATOM    650  CA  GLU    44      -6.435   8.163  -4.607  1.00 44.20           C  
ATOM    651  C   GLU    44      -6.822   8.313  -3.125  1.00  2.01           C  
ATOM    652  O   GLU    44      -6.565   9.348  -2.500  1.00 34.34           O  
ATOM    653  CB  GLU    44      -7.601   8.575  -5.518  1.00 34.11           C  
ATOM    654  CG  GLU    44      -7.288   8.430  -7.007  1.00 35.01           C  
ATOM    655  CD  GLU    44      -8.408   8.934  -7.906  1.00  4.40           C  
ATOM    656  OE1 GLU    44      -9.376   8.180  -8.143  1.00 31.35           O  
ATOM    657  OE2 GLU    44      -8.320  10.084  -8.388  1.00 62.22           O  
ATOM    658  H   GLU    44      -6.532   6.269  -5.567  1.00 37.41           H  
ATOM    659  HA  GLU    44      -5.590   8.806  -4.810  1.00 63.15           H  
ATOM    660  HB2 GLU    44      -8.458   7.956  -5.288  1.00 37.41           H  
ATOM    661  HB3 GLU    44      -7.850   9.608  -5.321  1.00 37.41           H  
ATOM    662  HG2 GLU    44      -6.389   8.987  -7.227  1.00 37.41           H  
ATOM    663  HG3 GLU    44      -7.118   7.383  -7.220  1.00 37.41           H  
ATOM    664  N   SER    45      -7.431   7.267  -2.566  1.00 71.45           N  
ATOM    665  CA  SER    45      -7.729   7.223  -1.129  1.00 64.43           C  
ATOM    666  C   SER    45      -6.431   7.303  -0.315  1.00 65.20           C  
ATOM    667  O   SER    45      -6.324   8.094   0.620  1.00  1.10           O  
ATOM    668  CB  SER    45      -8.501   5.943  -0.769  1.00 20.41           C  
ATOM    669  OG  SER    45      -8.892   5.931   0.598  1.00 73.31           O  
ATOM    670  H   SER    45      -7.690   6.509  -3.131  1.00 37.41           H  
ATOM    671  HA  SER    45      -8.342   8.082  -0.891  1.00  1.13           H  
ATOM    672  HB2 SER    45      -9.387   5.876  -1.383  1.00 37.41           H  
ATOM    673  HB3 SER    45      -7.873   5.081  -0.956  1.00 37.41           H  
ATOM    674  HG  SER    45      -9.836   5.743   0.653  1.00 53.44           H  
ATOM    675  N   VAL    46      -5.434   6.494  -0.694  1.00 74.53           N  
ATOM    676  CA  VAL    46      -4.112   6.532  -0.050  1.00 11.12           C  
ATOM    677  C   VAL    46      -3.501   7.945  -0.102  1.00 70.22           C  
ATOM    678  O   VAL    46      -2.893   8.401   0.865  1.00 14.22           O  
ATOM    679  CB  VAL    46      -3.124   5.524  -0.701  1.00 73.43           C  
ATOM    680  CG1 VAL    46      -1.738   5.622  -0.063  1.00 33.41           C  
ATOM    681  CG2 VAL    46      -3.657   4.095  -0.600  1.00 62.22           C  
ATOM    682  H   VAL    46      -5.590   5.855  -1.422  1.00 37.41           H  
ATOM    683  HA  VAL    46      -4.244   6.251   0.987  1.00 62.22           H  
ATOM    684  HB  VAL    46      -3.028   5.773  -1.751  1.00  4.22           H  
ATOM    685 HG11 VAL    46      -1.332   6.610  -0.227  1.00 37.41           H  
ATOM    686 HG12 VAL    46      -1.082   4.887  -0.508  1.00 37.41           H  
ATOM    687 HG13 VAL    46      -1.816   5.437   0.999  1.00 37.41           H  
ATOM    688 HG21 VAL    46      -3.758   3.819   0.441  1.00 37.41           H  
ATOM    689 HG22 VAL    46      -2.970   3.416  -1.086  1.00 37.41           H  
ATOM    690 HG23 VAL    46      -4.622   4.034  -1.081  1.00 37.41           H  
ATOM    691  N   GLN    47      -3.678   8.636  -1.229  1.00 30.23           N  
ATOM    692  CA  GLN    47      -3.191  10.017  -1.383  1.00 64.14           C  
ATOM    693  C   GLN    47      -3.807  10.953  -0.324  1.00 44.51           C  
ATOM    694  O   GLN    47      -3.102  11.757   0.290  1.00  0.02           O  
ATOM    695  CB  GLN    47      -3.496  10.537  -2.801  1.00 41.10           C  
ATOM    696  CG  GLN    47      -2.785   9.760  -3.907  1.00 73.03           C  
ATOM    697  CD  GLN    47      -3.121  10.267  -5.302  1.00 65.41           C  
ATOM    698  OE1 GLN    47      -4.214  10.765  -5.555  1.00 11.23           O  
ATOM    699  NE2 GLN    47      -2.184  10.153  -6.220  1.00 25.01           N  
ATOM    700  H   GLN    47      -4.141   8.207  -1.980  1.00 37.41           H  
ATOM    701  HA  GLN    47      -2.119  10.002  -1.244  1.00 60.45           H  
ATOM    702  HB2 GLN    47      -4.562  10.475  -2.975  1.00 37.41           H  
ATOM    703  HB3 GLN    47      -3.191  11.572  -2.867  1.00 37.41           H  
ATOM    704  HG2 GLN    47      -1.717   9.842  -3.760  1.00 37.41           H  
ATOM    705  HG3 GLN    47      -3.075   8.721  -3.842  1.00 37.41           H  
ATOM    706 HE21 GLN    47      -1.327   9.753  -5.962  1.00 37.41           H  
ATOM    707 HE22 GLN    47      -2.384  10.471  -7.122  1.00 37.41           H  
ATOM    708  N   THR    48      -5.118  10.835  -0.104  1.00 62.12           N  
ATOM    709  CA  THR    48      -5.808  11.628   0.934  1.00 52.31           C  
ATOM    710  C   THR    48      -5.457  11.143   2.351  1.00 45.00           C  
ATOM    711  O   THR    48      -5.382  11.935   3.290  1.00 12.34           O  
ATOM    712  CB  THR    48      -7.347  11.585   0.756  1.00 31.54           C  
ATOM    713  OG1 THR    48      -7.705  12.112  -0.530  1.00 41.12           O  
ATOM    714  CG2 THR    48      -8.066  12.382   1.845  1.00 24.32           C  
ATOM    715  H   THR    48      -5.640  10.209  -0.657  1.00 37.41           H  
ATOM    716  HA  THR    48      -5.487  12.658   0.831  1.00  2.23           H  
ATOM    717  HB  THR    48      -7.671  10.554   0.812  1.00 51.41           H  
ATOM    718  HG1 THR    48      -7.278  12.971  -0.651  1.00 32.15           H  
ATOM    719 HG21 THR    48      -7.766  13.418   1.791  1.00 37.41           H  
ATOM    720 HG22 THR    48      -7.810  11.985   2.817  1.00 37.41           H  
ATOM    721 HG23 THR    48      -9.135  12.310   1.699  1.00 37.41           H  
ATOM    722  N   ASN    49      -5.245   9.839   2.496  1.00 41.45           N  
ATOM    723  CA  ASN    49      -4.900   9.234   3.791  1.00 12.32           C  
ATOM    724  C   ASN    49      -3.433   9.498   4.172  1.00 34.54           C  
ATOM    725  O   ASN    49      -3.088   9.548   5.350  1.00 72.52           O  
ATOM    726  CB  ASN    49      -5.175   7.726   3.753  1.00 32.14           C  
ATOM    727  CG  ASN    49      -6.646   7.410   3.544  1.00 51.32           C  
ATOM    728  OD1 ASN    49      -7.524   8.100   4.048  1.00  4.51           O  
ATOM    729  ND2 ASN    49      -6.927   6.377   2.783  1.00 14.21           N  
ATOM    730  H   ASN    49      -5.328   9.258   1.710  1.00 37.41           H  
ATOM    731  HA  ASN    49      -5.536   9.684   4.542  1.00 40.24           H  
ATOM    732  HB2 ASN    49      -4.611   7.284   2.944  1.00 37.41           H  
ATOM    733  HB3 ASN    49      -4.860   7.283   4.689  1.00 37.41           H  
ATOM    734 HD21 ASN    49      -6.185   5.872   2.403  1.00 37.41           H  
ATOM    735 HD22 ASN    49      -7.868   6.173   2.610  1.00 37.41           H  
ATOM    736  N   SER    50      -2.581   9.658   3.161  1.00 54.03           N  
ATOM    737  CA  SER    50      -1.131   9.866   3.356  1.00 14.11           C  
ATOM    738  C   SER    50      -0.802  10.941   4.421  1.00 44.35           C  
ATOM    739  O   SER    50       0.011  10.692   5.313  1.00 31.31           O  
ATOM    740  CB  SER    50      -0.464  10.223   2.014  1.00 15.02           C  
ATOM    741  OG  SER    50       0.913  10.533   2.172  1.00 20.01           O  
ATOM    742  H   SER    50      -2.933   9.635   2.249  1.00 37.41           H  
ATOM    743  HA  SER    50      -0.725   8.922   3.695  1.00 71.31           H  
ATOM    744  HB2 SER    50      -0.552   9.384   1.339  1.00 37.41           H  
ATOM    745  HB3 SER    50      -0.965  11.079   1.584  1.00 37.41           H  
ATOM    746  HG  SER    50       1.437   9.729   2.070  1.00 12.52           H  
ATOM    747  N   PRO    51      -1.402  12.156   4.354  1.00 52.03           N  
ATOM    748  CA  PRO    51      -1.169  13.199   5.370  1.00  4.43           C  
ATOM    749  C   PRO    51      -1.944  12.952   6.677  1.00 52.32           C  
ATOM    750  O   PRO    51      -1.650  13.558   7.711  1.00 44.31           O  
ATOM    751  CB  PRO    51      -1.670  14.471   4.675  1.00 73.13           C  
ATOM    752  CG  PRO    51      -2.748  13.994   3.764  1.00 43.32           C  
ATOM    753  CD  PRO    51      -2.319  12.627   3.293  1.00 42.13           C  
ATOM    754  HA  PRO    51      -0.116  13.299   5.596  1.00 13.20           H  
ATOM    755  HB2 PRO    51      -2.049  15.171   5.410  1.00 37.41           H  
ATOM    756  HB3 PRO    51      -0.861  14.927   4.123  1.00 37.41           H  
ATOM    757  HG2 PRO    51      -3.684  13.930   4.302  1.00 37.41           H  
ATOM    758  HG3 PRO    51      -2.845  14.667   2.925  1.00 37.41           H  
ATOM    759  HD2 PRO    51      -3.173  11.972   3.205  1.00 37.41           H  
ATOM    760  HD3 PRO    51      -1.803  12.700   2.346  1.00 37.41           H  
ATOM    761  N   ILE    52      -2.934  12.060   6.624  1.00 63.31           N  
ATOM    762  CA  ILE    52      -3.784  11.757   7.784  1.00 50.41           C  
ATOM    763  C   ILE    52      -3.355  10.443   8.462  1.00 25.20           C  
ATOM    764  O   ILE    52      -3.842   9.360   8.129  1.00 63.43           O  
ATOM    765  CB  ILE    52      -5.278  11.668   7.377  1.00 40.10           C  
ATOM    766  CG1 ILE    52      -5.698  12.940   6.620  1.00  0.32           C  
ATOM    767  CG2 ILE    52      -6.164  11.454   8.609  1.00 13.31           C  
ATOM    768  CD1 ILE    52      -7.110  12.896   6.077  1.00 14.20           C  
ATOM    769  H   ILE    52      -3.093  11.580   5.783  1.00 37.41           H  
ATOM    770  HA  ILE    52      -3.676  12.566   8.495  1.00 14.31           H  
ATOM    771  HB  ILE    52      -5.400  10.815   6.724  1.00 21.03           H  
ATOM    772 HG12 ILE    52      -5.629  13.789   7.286  1.00 37.41           H  
ATOM    773 HG13 ILE    52      -5.028  13.093   5.785  1.00 37.41           H  
ATOM    774 HG21 ILE    52      -7.198  11.378   8.302  1.00 37.41           H  
ATOM    775 HG22 ILE    52      -6.052  12.289   9.286  1.00 37.41           H  
ATOM    776 HG23 ILE    52      -5.871  10.544   9.112  1.00 37.41           H  
ATOM    777 HD11 ILE    52      -7.214  12.053   5.411  1.00 37.41           H  
ATOM    778 HD12 ILE    52      -7.315  13.809   5.536  1.00 37.41           H  
ATOM    779 HD13 ILE    52      -7.809  12.800   6.895  1.00 37.41           H  
ATOM    780  N   GLU    53      -2.443  10.555   9.420  1.00 72.33           N  
ATOM    781  CA  GLU    53      -1.867   9.387  10.096  1.00 21.33           C  
ATOM    782  C   GLU    53      -2.934   8.548  10.821  1.00 13.30           C  
ATOM    783  O   GLU    53      -2.792   7.338  10.955  1.00 61.14           O  
ATOM    784  CB  GLU    53      -0.784   9.844  11.084  1.00 51.10           C  
ATOM    785  CG  GLU    53       0.329  10.658  10.428  1.00 41.41           C  
ATOM    786  CD  GLU    53       1.350  11.177  11.426  1.00 31.52           C  
ATOM    787  OE1 GLU    53       1.045  12.161  12.134  1.00  0.22           O  
ATOM    788  OE2 GLU    53       2.465  10.618  11.496  1.00  0.21           O  
ATOM    789  H   GLU    53      -2.141  11.450   9.680  1.00 37.41           H  
ATOM    790  HA  GLU    53      -1.404   8.769   9.339  1.00 44.53           H  
ATOM    791  HB2 GLU    53      -1.244  10.453  11.851  1.00 37.41           H  
ATOM    792  HB3 GLU    53      -0.341   8.974  11.544  1.00 37.41           H  
ATOM    793  HG2 GLU    53       0.836  10.035   9.706  1.00 37.41           H  
ATOM    794  HG3 GLU    53      -0.114  11.504   9.916  1.00 37.41           H  
ATOM    795  N   ALA    54      -4.022   9.183  11.247  1.00 24.34           N  
ATOM    796  CA  ALA    54      -5.102   8.486  11.969  1.00 14.52           C  
ATOM    797  C   ALA    54      -5.685   7.291  11.178  1.00 12.03           C  
ATOM    798  O   ALA    54      -6.469   6.504  11.715  1.00  2.10           O  
ATOM    799  CB  ALA    54      -6.208   9.475  12.319  1.00 10.14           C  
ATOM    800  H   ALA    54      -4.106  10.145  11.077  1.00 37.41           H  
ATOM    801  HA  ALA    54      -4.687   8.113  12.895  1.00 21.34           H  
ATOM    802  HB1 ALA    54      -6.973   8.974  12.895  1.00 37.41           H  
ATOM    803  HB2 ALA    54      -6.642   9.870  11.411  1.00 37.41           H  
ATOM    804  HB3 ALA    54      -5.795  10.285  12.902  1.00 37.41           H  
ATOM    805  N   ARG    55      -5.296   7.162   9.909  1.00 23.25           N  
ATOM    806  CA  ARG    55      -5.814   6.110   9.026  1.00  2.54           C  
ATOM    807  C   ARG    55      -4.950   4.826   9.031  1.00 53.14           C  
ATOM    808  O   ARG    55      -5.335   3.821   8.422  1.00  4.12           O  
ATOM    809  CB  ARG    55      -5.915   6.660   7.594  1.00  4.02           C  
ATOM    810  CG  ARG    55      -6.858   7.855   7.453  1.00 31.02           C  
ATOM    811  CD  ARG    55      -8.317   7.454   7.646  1.00 42.40           C  
ATOM    812  NE  ARG    55      -9.220   8.609   7.648  1.00 62.02           N  
ATOM    813  CZ  ARG    55      -9.855   9.054   6.595  1.00 64.32           C  
ATOM    814  NH1 ARG    55      -9.613   8.568   5.418  1.00 51.52           N  
ATOM    815  NH2 ARG    55     -10.707  10.018   6.710  1.00  4.11           N  
ATOM    816  H   ARG    55      -4.647   7.803   9.547  1.00 37.41           H  
ATOM    817  HA  ARG    55      -6.806   5.852   9.367  1.00 22.42           H  
ATOM    818  HB2 ARG    55      -4.931   6.969   7.270  1.00 37.41           H  
ATOM    819  HB3 ARG    55      -6.266   5.872   6.942  1.00 37.41           H  
ATOM    820  HG2 ARG    55      -6.597   8.596   8.194  1.00 37.41           H  
ATOM    821  HG3 ARG    55      -6.738   8.278   6.465  1.00 37.41           H  
ATOM    822  HD2 ARG    55      -8.603   6.785   6.846  1.00 37.41           H  
ATOM    823  HD3 ARG    55      -8.412   6.937   8.591  1.00 37.41           H  
ATOM    824  HE  ARG    55      -9.383   9.052   8.504  1.00 72.15           H  
ATOM    825 HH11 ARG    55      -8.932   7.849   5.304  1.00 37.41           H  
ATOM    826 HH12 ARG    55     -10.090   8.937   4.622  1.00 37.41           H  
ATOM    827 HH21 ARG    55     -10.872  10.437   7.602  1.00 37.41           H  
ATOM    828 HH22 ARG    55     -11.209  10.336   5.909  1.00 37.41           H  
ATOM    829  N   TYR    56      -3.797   4.843   9.711  1.00 35.41           N  
ATOM    830  CA  TYR    56      -2.880   3.687   9.684  1.00 62.05           C  
ATOM    831  C   TYR    56      -3.367   2.524  10.568  1.00 22.13           C  
ATOM    832  O   TYR    56      -4.337   2.646  11.320  1.00  5.52           O  
ATOM    833  CB  TYR    56      -1.437   4.088  10.092  1.00 63.32           C  
ATOM    834  CG  TYR    56      -1.219   4.439  11.573  1.00 62.22           C  
ATOM    835  CD1 TYR    56      -1.370   3.484  12.580  1.00 51.22           C  
ATOM    836  CD2 TYR    56      -0.851   5.723  11.957  1.00 14.01           C  
ATOM    837  CE1 TYR    56      -1.166   3.802  13.910  1.00 53.41           C  
ATOM    838  CE2 TYR    56      -0.643   6.048  13.285  1.00 42.30           C  
ATOM    839  CZ  TYR    56      -0.806   5.085  14.258  1.00  0.02           C  
ATOM    840  OH  TYR    56      -0.602   5.404  15.582  1.00  0.11           O  
ATOM    841  H   TYR    56      -3.558   5.637  10.234  1.00 37.41           H  
ATOM    842  HA  TYR    56      -2.854   3.333   8.662  1.00  0.43           H  
ATOM    843  HB2 TYR    56      -0.772   3.270   9.857  1.00 37.41           H  
ATOM    844  HB3 TYR    56      -1.144   4.949   9.504  1.00 37.41           H  
ATOM    845  HD1 TYR    56      -1.650   2.476  12.309  1.00 50.32           H  
ATOM    846  HD2 TYR    56      -0.728   6.479  11.196  1.00 34.13           H  
ATOM    847  HE1 TYR    56      -1.292   3.045  14.671  1.00 51.01           H  
ATOM    848  HE2 TYR    56      -0.357   7.055  13.556  1.00 22.30           H  
ATOM    849  HH  TYR    56      -1.043   6.241  15.780  1.00 14.22           H  
ATOM    850  N   ALA    57      -2.675   1.391  10.455  1.00 63.32           N  
ATOM    851  CA  ALA    57      -2.859   0.254  11.362  1.00 25.11           C  
ATOM    852  C   ALA    57      -1.529  -0.491  11.565  1.00 35.11           C  
ATOM    853  O   ALA    57      -1.122  -1.294  10.727  1.00 54.01           O  
ATOM    854  CB  ALA    57      -3.927  -0.689  10.819  1.00 23.24           C  
ATOM    855  H   ALA    57      -2.032   1.307   9.719  1.00 37.41           H  
ATOM    856  HA  ALA    57      -3.197   0.636  12.317  1.00 52.10           H  
ATOM    857  HB1 ALA    57      -3.598  -1.103   9.877  1.00 37.41           H  
ATOM    858  HB2 ALA    57      -4.848  -0.143  10.669  1.00 37.41           H  
ATOM    859  HB3 ALA    57      -4.096  -1.490  11.523  1.00 37.41           H  
ATOM    860  N   LYS    58      -0.855  -0.228  12.680  1.00 61.02           N  
ATOM    861  CA  LYS    58       0.480  -0.794  12.932  1.00 63.12           C  
ATOM    862  C   LYS    58       0.402  -2.075  13.776  1.00 14.20           C  
ATOM    863  O   LYS    58      -0.132  -2.075  14.888  1.00 64.40           O  
ATOM    864  CB  LYS    58       1.371   0.253  13.618  1.00 42.34           C  
ATOM    865  CG  LYS    58       1.675   1.467  12.739  1.00 42.51           C  
ATOM    866  CD  LYS    58       2.283   2.619  13.539  1.00 64.53           C  
ATOM    867  CE  LYS    58       3.613   2.243  14.180  1.00 34.10           C  
ATOM    868  NZ  LYS    58       4.138   3.339  15.033  1.00 51.24           N  
ATOM    869  H   LYS    58      -1.264   0.352  13.358  1.00 37.41           H  
ATOM    870  HA  LYS    58       0.917  -1.043  11.973  1.00  1.11           H  
ATOM    871  HB2 LYS    58       0.875   0.597  14.516  1.00 37.41           H  
ATOM    872  HB3 LYS    58       2.309  -0.210  13.892  1.00 37.41           H  
ATOM    873  HG2 LYS    58       2.374   1.173  11.967  1.00 37.41           H  
ATOM    874  HG3 LYS    58       0.756   1.805  12.279  1.00 37.41           H  
ATOM    875  HD2 LYS    58       2.443   3.457  12.875  1.00 37.41           H  
ATOM    876  HD3 LYS    58       1.589   2.909  14.316  1.00 37.41           H  
ATOM    877  HE2 LYS    58       3.471   1.363  14.790  1.00 37.41           H  
ATOM    878  HE3 LYS    58       4.331   2.030  13.400  1.00 37.41           H  
ATOM    879  HZ1 LYS    58       3.486   3.520  15.827  1.00 37.41           H  
ATOM    880  HZ2 LYS    58       4.241   4.211  14.480  1.00 37.41           H  
ATOM    881  HZ3 LYS    58       5.069   3.079  15.421  1.00 37.41           H  
ATOM    882  N   GLU    59       0.949  -3.169  13.247  1.00 44.24           N  
ATOM    883  CA  GLU    59       0.882  -4.471  13.919  1.00 11.42           C  
ATOM    884  C   GLU    59       2.249  -5.175  13.923  1.00 44.23           C  
ATOM    885  O   GLU    59       3.090  -4.945  13.051  1.00 51.02           O  
ATOM    886  CB  GLU    59      -0.167  -5.358  13.225  1.00 62.32           C  
ATOM    887  CG  GLU    59      -0.394  -6.708  13.903  1.00 71.31           C  
ATOM    888  CD  GLU    59      -0.917  -6.575  15.325  1.00 71.05           C  
ATOM    889  OE1 GLU    59      -2.147  -6.439  15.499  1.00 51.51           O  
ATOM    890  OE2 GLU    59      -0.103  -6.593  16.271  1.00 64.11           O  
ATOM    891  H   GLU    59       1.413  -3.103  12.385  1.00 37.41           H  
ATOM    892  HA  GLU    59       0.577  -4.303  14.942  1.00 22.01           H  
ATOM    893  HB2 GLU    59      -1.109  -4.828  13.205  1.00 37.41           H  
ATOM    894  HB3 GLU    59       0.150  -5.540  12.207  1.00 37.41           H  
ATOM    895  HG2 GLU    59      -1.109  -7.273  13.323  1.00 37.41           H  
ATOM    896  HG3 GLU    59       0.546  -7.245  13.929  1.00 37.41           H  
ATOM    897  N   VAL    60       2.470  -6.027  14.921  1.00 22.32           N  
ATOM    898  CA  VAL    60       3.696  -6.824  15.010  1.00 64.53           C  
ATOM    899  C   VAL    60       3.366  -8.299  15.279  1.00 53.14           C  
ATOM    900  O   VAL    60       2.798  -8.636  16.319  1.00 43.34           O  
ATOM    901  CB  VAL    60       4.643  -6.309  16.126  1.00  2.12           C  
ATOM    902  CG1 VAL    60       5.908  -7.164  16.200  1.00 11.45           C  
ATOM    903  CG2 VAL    60       4.996  -4.836  15.909  1.00 31.41           C  
ATOM    904  H   VAL    60       1.784  -6.130  15.617  1.00 37.41           H  
ATOM    905  HA  VAL    60       4.215  -6.749  14.063  1.00  5.34           H  
ATOM    906  HB  VAL    60       4.126  -6.394  17.073  1.00 53.30           H  
ATOM    907 HG11 VAL    60       5.637  -8.192  16.393  1.00 37.41           H  
ATOM    908 HG12 VAL    60       6.540  -6.805  17.000  1.00 37.41           H  
ATOM    909 HG13 VAL    60       6.444  -7.102  15.264  1.00 37.41           H  
ATOM    910 HG21 VAL    60       5.634  -4.496  16.714  1.00 37.41           H  
ATOM    911 HG22 VAL    60       4.091  -4.247  15.895  1.00 37.41           H  
ATOM    912 HG23 VAL    60       5.515  -4.722  14.968  1.00 37.41           H  
ATOM    913  N   ALA    61       3.723  -9.170  14.340  1.00 74.01           N  
ATOM    914  CA  ALA    61       3.468 -10.608  14.478  1.00 71.43           C  
ATOM    915  C   ALA    61       4.192 -11.201  15.705  1.00 65.35           C  
ATOM    916  O   ALA    61       5.224 -10.684  16.135  1.00 53.45           O  
ATOM    917  CB  ALA    61       3.892 -11.333  13.206  1.00 74.24           C  
ATOM    918  H   ALA    61       4.166  -8.839  13.528  1.00 37.41           H  
ATOM    919  HA  ALA    61       2.402 -10.745  14.602  1.00 31.41           H  
ATOM    920  HB1 ALA    61       3.608 -12.373  13.269  1.00 37.41           H  
ATOM    921  HB2 ALA    61       4.964 -11.260  13.091  1.00 37.41           H  
ATOM    922  HB3 ALA    61       3.409 -10.879  12.353  1.00 37.41           H  
ATOM    923  N   LYS    62       3.656 -12.300  16.248  1.00  4.44           N  
ATOM    924  CA  LYS    62       4.209 -12.923  17.465  1.00 11.40           C  
ATOM    925  C   LYS    62       5.685 -13.343  17.306  1.00 52.00           C  
ATOM    926  O   LYS    62       6.385 -13.549  18.295  1.00 60.32           O  
ATOM    927  CB  LYS    62       3.332 -14.116  17.908  1.00 35.24           C  
ATOM    928  CG  LYS    62       2.962 -15.109  16.797  1.00 32.32           C  
ATOM    929  CD  LYS    62       4.130 -15.996  16.364  1.00 21.23           C  
ATOM    930  CE  LYS    62       4.682 -16.823  17.517  1.00 32.35           C  
ATOM    931  NZ  LYS    62       5.716 -17.788  17.058  1.00 41.43           N  
ATOM    932  H   LYS    62       2.867 -12.701  15.824  1.00 37.41           H  
ATOM    933  HA  LYS    62       4.165 -12.173  18.244  1.00 22.23           H  
ATOM    934  HB2 LYS    62       3.853 -14.661  18.682  1.00 37.41           H  
ATOM    935  HB3 LYS    62       2.413 -13.726  18.325  1.00 37.41           H  
ATOM    936  HG2 LYS    62       2.164 -15.745  17.155  1.00 37.41           H  
ATOM    937  HG3 LYS    62       2.610 -14.551  15.939  1.00 37.41           H  
ATOM    938  HD2 LYS    62       3.790 -16.667  15.588  1.00 37.41           H  
ATOM    939  HD3 LYS    62       4.919 -15.370  15.972  1.00 37.41           H  
ATOM    940  HE2 LYS    62       5.123 -16.157  18.243  1.00 37.41           H  
ATOM    941  HE3 LYS    62       3.870 -17.369  17.977  1.00 37.41           H  
ATOM    942  HZ1 LYS    62       6.100 -18.314  17.871  1.00 37.41           H  
ATOM    943  HZ2 LYS    62       6.495 -17.286  16.585  1.00 37.41           H  
ATOM    944  HZ3 LYS    62       5.301 -18.465  16.385  1.00 37.41           H  
ATOM    945  N   ASN    63       6.149 -13.463  16.062  1.00 21.24           N  
ATOM    946  CA  ASN    63       7.566 -13.751  15.782  1.00 12.32           C  
ATOM    947  C   ASN    63       8.383 -12.441  15.702  1.00 33.24           C  
ATOM    948  O   ASN    63       9.455 -12.395  15.101  1.00  2.24           O  
ATOM    949  CB  ASN    63       7.668 -14.554  14.471  1.00 62.24           C  
ATOM    950  CG  ASN    63       9.074 -15.056  14.164  1.00 20.31           C  
ATOM    951  OD1 ASN    63       9.485 -16.114  14.623  1.00 45.23           O  
ATOM    952  ND2 ASN    63       9.818 -14.312  13.374  1.00 10.10           N  
ATOM    953  H   ASN    63       5.524 -13.370  15.311  1.00 37.41           H  
ATOM    954  HA  ASN    63       7.952 -14.351  16.596  1.00 40.40           H  
ATOM    955  HB2 ASN    63       7.016 -15.413  14.538  1.00 37.41           H  
ATOM    956  HB3 ASN    63       7.342 -13.932  13.647  1.00 37.41           H  
ATOM    957 HD21 ASN    63       9.442 -13.479  13.028  1.00 37.41           H  
ATOM    958 HD22 ASN    63      10.721 -14.626  13.165  1.00 37.41           H  
ATOM    959  N   ASP    64       7.867 -11.379  16.331  1.00 12.21           N  
ATOM    960  CA  ASP    64       8.514 -10.058  16.313  1.00 33.52           C  
ATOM    961  C   ASP    64       8.675  -9.521  14.882  1.00 53.51           C  
ATOM    962  O   ASP    64       9.686  -8.898  14.546  1.00 41.44           O  
ATOM    963  CB  ASP    64       9.872 -10.114  17.026  1.00 11.12           C  
ATOM    964  CG  ASP    64       9.731 -10.181  18.532  1.00 25.43           C  
ATOM    965  OD1 ASP    64       9.576  -9.113  19.163  1.00 53.53           O  
ATOM    966  OD2 ASP    64       9.775 -11.295  19.093  1.00 55.32           O  
ATOM    967  H   ASP    64       7.030 -11.487  16.826  1.00 37.41           H  
ATOM    968  HA  ASP    64       7.868  -9.381  16.853  1.00 71.24           H  
ATOM    969  HB2 ASP    64      10.411 -10.990  16.690  1.00 37.41           H  
ATOM    970  HB3 ASP    64      10.444  -9.232  16.774  1.00 37.41           H  
ATOM    971  N   LYS    65       7.662  -9.755  14.048  1.00 61.14           N  
ATOM    972  CA  LYS    65       7.666  -9.274  12.660  1.00 32.24           C  
ATOM    973  C   LYS    65       6.824  -7.992  12.531  1.00 33.22           C  
ATOM    974  O   LYS    65       5.593  -8.050  12.518  1.00 61.02           O  
ATOM    975  CB  LYS    65       7.113 -10.358  11.721  1.00 71.43           C  
ATOM    976  CG  LYS    65       7.740 -11.735  11.933  1.00 12.12           C  
ATOM    977  CD  LYS    65       7.122 -12.797  11.024  1.00 54.43           C  
ATOM    978  CE  LYS    65       7.477 -12.578   9.556  1.00 71.11           C  
ATOM    979  NZ  LYS    65       8.943 -12.627   9.316  1.00 13.30           N  
ATOM    980  H   LYS    65       6.892 -10.263  14.373  1.00 37.41           H  
ATOM    981  HA  LYS    65       8.687  -9.055  12.380  1.00 74.43           H  
ATOM    982  HB2 LYS    65       6.046 -10.444  11.878  1.00 37.41           H  
ATOM    983  HB3 LYS    65       7.291 -10.057  10.697  1.00 37.41           H  
ATOM    984  HG2 LYS    65       8.799 -11.672  11.725  1.00 37.41           H  
ATOM    985  HG3 LYS    65       7.595 -12.028  12.964  1.00 37.41           H  
ATOM    986  HD2 LYS    65       7.482 -13.769  11.327  1.00 37.41           H  
ATOM    987  HD3 LYS    65       6.046 -12.764  11.131  1.00 37.41           H  
ATOM    988  HE2 LYS    65       7.002 -13.348   8.965  1.00 37.41           H  
ATOM    989  HE3 LYS    65       7.105 -11.611   9.248  1.00 37.41           H  
ATOM    990  HZ1 LYS    65       9.144 -12.552   8.299  1.00 37.41           H  
ATOM    991  HZ2 LYS    65       9.336 -13.522   9.668  1.00 37.41           H  
ATOM    992  HZ3 LYS    65       9.415 -11.842   9.806  1.00 37.41           H  
ATOM    993  N   PRO    66       7.471  -6.815  12.457  1.00 62.54           N  
ATOM    994  CA  PRO    66       6.766  -5.530  12.370  1.00 44.02           C  
ATOM    995  C   PRO    66       6.263  -5.199  10.950  1.00 12.31           C  
ATOM    996  O   PRO    66       7.020  -5.245   9.979  1.00 62.23           O  
ATOM    997  CB  PRO    66       7.837  -4.530  12.819  1.00 32.11           C  
ATOM    998  CG  PRO    66       9.125  -5.139  12.375  1.00 70.24           C  
ATOM    999  CD  PRO    66       8.939  -6.637  12.465  1.00 13.44           C  
ATOM   1000  HA  PRO    66       5.933  -5.494  13.059  1.00  1.01           H  
ATOM   1001  HB2 PRO    66       7.665  -3.571  12.350  1.00 37.41           H  
ATOM   1002  HB3 PRO    66       7.804  -4.420  13.894  1.00 37.41           H  
ATOM   1003  HG2 PRO    66       9.335  -4.847  11.356  1.00 37.41           H  
ATOM   1004  HG3 PRO    66       9.927  -4.820  13.027  1.00 37.41           H  
ATOM   1005  HD2 PRO    66       9.390  -7.125  11.612  1.00 37.41           H  
ATOM   1006  HD3 PRO    66       9.364  -7.017  13.383  1.00 37.41           H  
ATOM   1007  N   TYR    67       4.979  -4.871  10.846  1.00 24.13           N  
ATOM   1008  CA  TYR    67       4.370  -4.439   9.581  1.00 24.21           C  
ATOM   1009  C   TYR    67       3.188  -3.491   9.849  1.00 45.21           C  
ATOM   1010  O   TYR    67       2.904  -3.151  11.001  1.00 72.50           O  
ATOM   1011  CB  TYR    67       3.915  -5.656   8.753  1.00  1.11           C  
ATOM   1012  CG  TYR    67       2.901  -6.550   9.452  1.00  2.41           C  
ATOM   1013  CD1 TYR    67       3.311  -7.547  10.334  1.00 23.44           C  
ATOM   1014  CD2 TYR    67       1.534  -6.403   9.224  1.00 42.32           C  
ATOM   1015  CE1 TYR    67       2.393  -8.362  10.969  1.00 44.40           C  
ATOM   1016  CE2 TYR    67       0.612  -7.216   9.855  1.00 22.30           C  
ATOM   1017  CZ  TYR    67       1.046  -8.194  10.726  1.00  1.14           C  
ATOM   1018  OH  TYR    67       0.131  -9.010  11.357  1.00 65.32           O  
ATOM   1019  H   TYR    67       4.411  -4.928  11.646  1.00 37.41           H  
ATOM   1020  HA  TYR    67       5.122  -3.896   9.023  1.00 62.22           H  
ATOM   1021  HB2 TYR    67       3.469  -5.308   7.832  1.00 37.41           H  
ATOM   1022  HB3 TYR    67       4.780  -6.259   8.514  1.00 37.41           H  
ATOM   1023  HD1 TYR    67       4.366  -7.678  10.524  1.00  3.10           H  
ATOM   1024  HD2 TYR    67       1.196  -5.635   8.542  1.00 71.14           H  
ATOM   1025  HE1 TYR    67       2.735  -9.127  11.651  1.00 11.44           H  
ATOM   1026  HE2 TYR    67      -0.444  -7.086   9.660  1.00 45.34           H  
ATOM   1027  HH  TYR    67      -0.543  -9.284  10.722  1.00 75.15           H  
ATOM   1028  N   PHE    68       2.507  -3.052   8.794  1.00 24.23           N  
ATOM   1029  CA  PHE    68       1.371  -2.137   8.954  1.00  4.50           C  
ATOM   1030  C   PHE    68       0.403  -2.178   7.760  1.00 64.32           C  
ATOM   1031  O   PHE    68       0.799  -2.428   6.620  1.00 12.41           O  
ATOM   1032  CB  PHE    68       1.871  -0.698   9.183  1.00 32.33           C  
ATOM   1033  CG  PHE    68       2.691  -0.137   8.044  1.00 23.42           C  
ATOM   1034  CD1 PHE    68       4.044  -0.426   7.932  1.00 53.23           C  
ATOM   1035  CD2 PHE    68       2.106   0.680   7.083  1.00 31.25           C  
ATOM   1036  CE1 PHE    68       4.793   0.086   6.889  1.00  4.33           C  
ATOM   1037  CE2 PHE    68       2.853   1.193   6.040  1.00  0.44           C  
ATOM   1038  CZ  PHE    68       4.199   0.895   5.945  1.00 13.13           C  
ATOM   1039  H   PHE    68       2.769  -3.344   7.896  1.00 37.41           H  
ATOM   1040  HA  PHE    68       0.827  -2.451   9.835  1.00 14.23           H  
ATOM   1041  HB2 PHE    68       1.019  -0.048   9.332  1.00 37.41           H  
ATOM   1042  HB3 PHE    68       2.484  -0.681  10.074  1.00 37.41           H  
ATOM   1043  HD1 PHE    68       4.514  -1.062   8.670  1.00 10.45           H  
ATOM   1044  HD2 PHE    68       1.053   0.917   7.157  1.00 75.42           H  
ATOM   1045  HE1 PHE    68       5.844  -0.148   6.814  1.00 73.12           H  
ATOM   1046  HE2 PHE    68       2.386   1.826   5.300  1.00 70.04           H  
ATOM   1047  HZ  PHE    68       4.783   1.293   5.130  1.00  3.33           H  
ATOM   1048  N   ASN    69      -0.872  -1.940   8.050  1.00 64.50           N  
ATOM   1049  CA  ASN    69      -1.917  -1.835   7.029  1.00 15.25           C  
ATOM   1050  C   ASN    69      -2.474  -0.402   6.980  1.00 13.04           C  
ATOM   1051  O   ASN    69      -2.335   0.362   7.937  1.00 72.31           O  
ATOM   1052  CB  ASN    69      -3.054  -2.818   7.333  1.00 23.42           C  
ATOM   1053  CG  ASN    69      -2.588  -4.266   7.375  1.00 74.43           C  
ATOM   1054  OD1 ASN    69      -2.149  -4.761   8.408  1.00 54.30           O  
ATOM   1055  ND2 ASN    69      -2.687  -4.962   6.259  1.00 72.34           N  
ATOM   1056  H   ASN    69      -1.125  -1.836   8.987  1.00 37.41           H  
ATOM   1057  HA  ASN    69      -1.481  -2.078   6.069  1.00 74.20           H  
ATOM   1058  HB2 ASN    69      -3.484  -2.574   8.293  1.00 37.41           H  
ATOM   1059  HB3 ASN    69      -3.816  -2.725   6.572  1.00 37.41           H  
ATOM   1060 HD21 ASN    69      -3.050  -4.521   5.464  1.00 37.41           H  
ATOM   1061 HD22 ASN    69      -2.402  -5.900   6.277  1.00 37.41           H  
ATOM   1062  N   LEU    70      -3.099  -0.039   5.866  1.00  3.12           N  
ATOM   1063  CA  LEU    70      -3.696   1.294   5.709  1.00 12.35           C  
ATOM   1064  C   LEU    70      -5.207   1.188   5.443  1.00 52.51           C  
ATOM   1065  O   LEU    70      -5.639   0.449   4.550  1.00  2.32           O  
ATOM   1066  CB  LEU    70      -3.002   2.054   4.562  1.00 61.41           C  
ATOM   1067  CG  LEU    70      -3.459   3.511   4.357  1.00 74.43           C  
ATOM   1068  CD1 LEU    70      -3.134   4.366   5.584  1.00 53.53           C  
ATOM   1069  CD2 LEU    70      -2.820   4.100   3.100  1.00 51.44           C  
ATOM   1070  H   LEU    70      -3.166  -0.683   5.130  1.00 37.41           H  
ATOM   1071  HA  LEU    70      -3.544   1.837   6.631  1.00 30.15           H  
ATOM   1072  HB2 LEU    70      -1.937   2.057   4.757  1.00 37.41           H  
ATOM   1073  HB3 LEU    70      -3.177   1.512   3.643  1.00 37.41           H  
ATOM   1074  HG  LEU    70      -4.530   3.526   4.222  1.00 53.12           H  
ATOM   1075 HD11 LEU    70      -3.620   3.946   6.453  1.00 37.41           H  
ATOM   1076 HD12 LEU    70      -3.491   5.374   5.426  1.00 37.41           H  
ATOM   1077 HD13 LEU    70      -2.066   4.384   5.742  1.00 37.41           H  
ATOM   1078 HD21 LEU    70      -3.146   5.121   2.972  1.00 37.41           H  
ATOM   1079 HD22 LEU    70      -3.117   3.519   2.239  1.00 37.41           H  
ATOM   1080 HD23 LEU    70      -1.744   4.076   3.194  1.00 37.41           H  
ATOM   1081  N   LYS    71      -6.004   1.925   6.220  1.00 35.23           N  
ATOM   1082  CA  LYS    71      -7.465   1.907   6.076  1.00 73.11           C  
ATOM   1083  C   LYS    71      -8.014   3.253   5.581  1.00 73.01           C  
ATOM   1084  O   LYS    71      -7.513   4.317   5.942  1.00  2.23           O  
ATOM   1085  CB  LYS    71      -8.145   1.557   7.410  1.00 52.54           C  
ATOM   1086  CG  LYS    71      -7.870   0.143   7.914  1.00  3.44           C  
ATOM   1087  CD  LYS    71      -8.818  -0.226   9.058  1.00 43.11           C  
ATOM   1088  CE  LYS    71      -8.538  -1.614   9.626  1.00  2.32           C  
ATOM   1089  NZ  LYS    71      -7.195  -1.709  10.252  1.00 63.42           N  
ATOM   1090  H   LYS    71      -5.604   2.503   6.907  1.00 37.41           H  
ATOM   1091  HA  LYS    71      -7.718   1.146   5.350  1.00 23.22           H  
ATOM   1092  HB2 LYS    71      -7.803   2.251   8.165  1.00 37.41           H  
ATOM   1093  HB3 LYS    71      -9.216   1.669   7.293  1.00 37.41           H  
ATOM   1094  HG2 LYS    71      -8.009  -0.555   7.100  1.00 37.41           H  
ATOM   1095  HG3 LYS    71      -6.848   0.086   8.269  1.00 37.41           H  
ATOM   1096  HD2 LYS    71      -8.714   0.502   9.850  1.00 37.41           H  
ATOM   1097  HD3 LYS    71      -9.832  -0.201   8.685  1.00 37.41           H  
ATOM   1098  HE2 LYS    71      -9.287  -1.839  10.372  1.00 37.41           H  
ATOM   1099  HE3 LYS    71      -8.605  -2.337   8.826  1.00 37.41           H  
ATOM   1100  HZ1 LYS    71      -7.050  -0.916  10.911  1.00 37.41           H  
ATOM   1101  HZ2 LYS    71      -6.452  -1.683   9.527  1.00 37.41           H  
ATOM   1102  HZ3 LYS    71      -7.112  -2.600  10.783  1.00 37.41           H  
ATOM   1103  N   ALA    72      -9.056   3.195   4.754  1.00 64.14           N  
ATOM   1104  CA  ALA    72      -9.782   4.398   4.334  1.00 62.42           C  
ATOM   1105  C   ALA    72     -10.779   4.839   5.421  1.00 74.43           C  
ATOM   1106  O   ALA    72     -10.918   4.172   6.448  1.00 34.50           O  
ATOM   1107  CB  ALA    72     -10.504   4.149   3.016  1.00 73.22           C  
ATOM   1108  H   ALA    72      -9.341   2.319   4.415  1.00 37.41           H  
ATOM   1109  HA  ALA    72      -9.062   5.190   4.180  1.00 74.24           H  
ATOM   1110  HB1 ALA    72      -9.793   3.834   2.267  1.00 37.41           H  
ATOM   1111  HB2 ALA    72     -10.990   5.059   2.691  1.00 37.41           H  
ATOM   1112  HB3 ALA    72     -11.247   3.377   3.152  1.00 37.41           H  
ATOM   1113  N   ALA    73     -11.471   5.956   5.194  1.00 12.14           N  
ATOM   1114  CA  ALA    73     -12.418   6.506   6.181  1.00 23.01           C  
ATOM   1115  C   ALA    73     -13.482   5.481   6.617  1.00 13.03           C  
ATOM   1116  O   ALA    73     -13.840   5.409   7.791  1.00 75.11           O  
ATOM   1117  CB  ALA    73     -13.091   7.756   5.622  1.00 23.52           C  
ATOM   1118  H   ALA    73     -11.348   6.428   4.343  1.00 37.41           H  
ATOM   1119  HA  ALA    73     -11.846   6.801   7.050  1.00 75.03           H  
ATOM   1120  HB1 ALA    73     -13.668   7.495   4.745  1.00 37.41           H  
ATOM   1121  HB2 ALA    73     -12.336   8.482   5.351  1.00 37.41           H  
ATOM   1122  HB3 ALA    73     -13.746   8.182   6.369  1.00 37.41           H  
ATOM   1123  N   ASN    74     -13.975   4.682   5.668  1.00 14.50           N  
ATOM   1124  CA  ASN    74     -14.995   3.662   5.962  1.00 44.41           C  
ATOM   1125  C   ASN    74     -14.373   2.400   6.607  1.00 22.25           C  
ATOM   1126  O   ASN    74     -15.018   1.355   6.708  1.00 15.02           O  
ATOM   1127  CB  ASN    74     -15.760   3.307   4.675  1.00 73.15           C  
ATOM   1128  CG  ASN    74     -17.051   2.547   4.943  1.00 61.34           C  
ATOM   1129  OD1 ASN    74     -18.083   3.137   5.242  1.00  2.04           O  
ATOM   1130  ND2 ASN    74     -17.016   1.235   4.823  1.00 24.03           N  
ATOM   1131  H   ASN    74     -13.661   4.793   4.747  1.00 37.41           H  
ATOM   1132  HA  ASN    74     -15.692   4.094   6.667  1.00 11.14           H  
ATOM   1133  HB2 ASN    74     -16.008   4.219   4.148  1.00 37.41           H  
ATOM   1134  HB3 ASN    74     -15.129   2.697   4.044  1.00 37.41           H  
ATOM   1135 HD21 ASN    74     -16.171   0.813   4.570  1.00 37.41           H  
ATOM   1136 HD22 ASN    74     -17.843   0.739   4.984  1.00 37.41           H  
ATOM   1137  N   HIS    75     -13.105   2.509   7.018  1.00 14.22           N  
ATOM   1138  CA  HIS    75     -12.421   1.473   7.820  1.00 24.34           C  
ATOM   1139  C   HIS    75     -12.106   0.216   6.985  1.00 63.04           C  
ATOM   1140  O   HIS    75     -11.936  -0.882   7.520  1.00 64.04           O  
ATOM   1141  CB  HIS    75     -13.274   1.119   9.054  1.00 34.43           C  
ATOM   1142  CG  HIS    75     -12.532   0.386  10.133  1.00 15.42           C  
ATOM   1143  ND1 HIS    75     -12.548  -0.986  10.265  1.00  2.12           N  
ATOM   1144  CD2 HIS    75     -11.764   0.847  11.149  1.00 71.01           C  
ATOM   1145  CE1 HIS    75     -11.827  -1.335  11.311  1.00 72.22           C  
ATOM   1146  NE2 HIS    75     -11.339  -0.245  11.865  1.00 11.40           N  
ATOM   1147  H   HIS    75     -12.605   3.312   6.767  1.00 37.41           H  
ATOM   1148  HA  HIS    75     -11.486   1.895   8.157  1.00 70.03           H  
ATOM   1149  HB2 HIS    75     -13.657   2.031   9.486  1.00 37.41           H  
ATOM   1150  HB3 HIS    75     -14.105   0.501   8.745  1.00 37.41           H  
ATOM   1151  HD1 HIS    75     -13.019  -1.614   9.676  1.00 74.14           H  
ATOM   1152  HD2 HIS    75     -11.527   1.882  11.355  1.00 62.31           H  
ATOM   1153  HE1 HIS    75     -11.662  -2.346  11.653  1.00 23.12           H  
ATOM   1154  HE2 HIS    75     -10.934  -0.206  12.760  1.00 37.41           H  
ATOM   1155  N   GLN    76     -11.995   0.406   5.675  1.00 70.15           N  
ATOM   1156  CA  GLN    76     -11.689  -0.683   4.736  1.00 74.21           C  
ATOM   1157  C   GLN    76     -10.171  -0.827   4.527  1.00 71.43           C  
ATOM   1158  O   GLN    76      -9.428   0.149   4.651  1.00 53.14           O  
ATOM   1159  CB  GLN    76     -12.374  -0.393   3.393  1.00 42.12           C  
ATOM   1160  CG  GLN    76     -11.825   0.848   2.691  1.00 15.10           C  
ATOM   1161  CD  GLN    76     -12.765   1.405   1.641  1.00  1.43           C  
ATOM   1162  OE1 GLN    76     -12.715   1.031   0.471  1.00 50.25           O  
ATOM   1163  NE2 GLN    76     -13.614   2.324   2.052  1.00 12.54           N  
ATOM   1164  H   GLN    76     -12.121   1.309   5.323  1.00 37.41           H  
ATOM   1165  HA  GLN    76     -12.081  -1.604   5.143  1.00  5.43           H  
ATOM   1166  HB2 GLN    76     -12.235  -1.243   2.738  1.00 37.41           H  
ATOM   1167  HB3 GLN    76     -13.432  -0.249   3.563  1.00 37.41           H  
ATOM   1168  HG2 GLN    76     -11.647   1.615   3.431  1.00 37.41           H  
ATOM   1169  HG3 GLN    76     -10.889   0.592   2.215  1.00 37.41           H  
ATOM   1170 HE21 GLN    76     -13.589   2.593   2.992  1.00 37.41           H  
ATOM   1171 HE22 GLN    76     -14.248   2.691   1.397  1.00 37.41           H  
ATOM   1172  N   ILE    77      -9.715  -2.035   4.194  1.00 32.34           N  
ATOM   1173  CA  ILE    77      -8.283  -2.295   3.979  1.00 40.03           C  
ATOM   1174  C   ILE    77      -7.868  -1.955   2.540  1.00 24.44           C  
ATOM   1175  O   ILE    77      -8.107  -2.731   1.612  1.00 71.02           O  
ATOM   1176  CB  ILE    77      -7.923  -3.778   4.274  1.00 72.54           C  
ATOM   1177  CG1 ILE    77      -8.252  -4.137   5.732  1.00 71.52           C  
ATOM   1178  CG2 ILE    77      -6.445  -4.051   3.976  1.00 55.33           C  
ATOM   1179  CD1 ILE    77      -7.418  -3.391   6.752  1.00  4.14           C  
ATOM   1180  H   ILE    77     -10.356  -2.767   4.072  1.00 37.41           H  
ATOM   1181  HA  ILE    77      -7.722  -1.669   4.662  1.00 54.33           H  
ATOM   1182  HB  ILE    77      -8.514  -4.401   3.617  1.00 41.44           H  
ATOM   1183 HG12 ILE    77      -9.289  -3.910   5.927  1.00 37.41           H  
ATOM   1184 HG13 ILE    77      -8.090  -5.196   5.881  1.00 37.41           H  
ATOM   1185 HG21 ILE    77      -6.214  -5.082   4.206  1.00 37.41           H  
ATOM   1186 HG22 ILE    77      -5.826  -3.401   4.579  1.00 37.41           H  
ATOM   1187 HG23 ILE    77      -6.247  -3.865   2.930  1.00 37.41           H  
ATOM   1188 HD11 ILE    77      -6.377  -3.650   6.624  1.00 37.41           H  
ATOM   1189 HD12 ILE    77      -7.735  -3.667   7.746  1.00 37.41           H  
ATOM   1190 HD13 ILE    77      -7.545  -2.327   6.616  1.00 37.41           H  
ATOM   1191  N   ILE    78      -7.258  -0.789   2.357  1.00 42.24           N  
ATOM   1192  CA  ILE    78      -6.824  -0.346   1.024  1.00 51.22           C  
ATOM   1193  C   ILE    78      -5.345  -0.674   0.761  1.00 70.34           C  
ATOM   1194  O   ILE    78      -4.940  -0.865  -0.388  1.00 50.21           O  
ATOM   1195  CB  ILE    78      -7.057   1.174   0.830  1.00 32.12           C  
ATOM   1196  CG1 ILE    78      -6.289   1.979   1.892  1.00 53.32           C  
ATOM   1197  CG2 ILE    78      -8.551   1.494   0.876  1.00 11.03           C  
ATOM   1198  CD1 ILE    78      -6.479   3.475   1.785  1.00 34.20           C  
ATOM   1199  H   ILE    78      -7.099  -0.209   3.131  1.00 37.41           H  
ATOM   1200  HA  ILE    78      -7.424  -0.870   0.290  1.00 62.01           H  
ATOM   1201  HB  ILE    78      -6.691   1.447  -0.151  1.00 52.10           H  
ATOM   1202 HG12 ILE    78      -6.619   1.676   2.875  1.00 37.41           H  
ATOM   1203 HG13 ILE    78      -5.231   1.773   1.796  1.00 37.41           H  
ATOM   1204 HG21 ILE    78      -8.701   2.554   0.726  1.00 37.41           H  
ATOM   1205 HG22 ILE    78      -8.953   1.206   1.838  1.00 37.41           H  
ATOM   1206 HG23 ILE    78      -9.062   0.945   0.097  1.00 37.41           H  
ATOM   1207 HD11 ILE    78      -5.860   3.968   2.520  1.00 37.41           H  
ATOM   1208 HD12 ILE    78      -7.515   3.722   1.966  1.00 37.41           H  
ATOM   1209 HD13 ILE    78      -6.198   3.807   0.798  1.00 37.41           H  
ATOM   1210  N   GLY    79      -4.543  -0.740   1.826  1.00 72.31           N  
ATOM   1211  CA  GLY    79      -3.118  -1.037   1.679  1.00 14.54           C  
ATOM   1212  C   GLY    79      -2.586  -2.007   2.734  1.00 61.14           C  
ATOM   1213  O   GLY    79      -3.094  -2.060   3.853  1.00 22.12           O  
ATOM   1214  H   GLY    79      -4.920  -0.581   2.720  1.00 37.41           H  
ATOM   1215  HA2 GLY    79      -2.948  -1.464   0.699  1.00 37.41           H  
ATOM   1216  HA3 GLY    79      -2.566  -0.111   1.750  1.00 37.41           H  
ATOM   1217  N   THR    80      -1.552  -2.767   2.373  1.00 55.11           N  
ATOM   1218  CA  THR    80      -0.925  -3.738   3.289  1.00 61.41           C  
ATOM   1219  C   THR    80       0.586  -3.837   3.039  1.00 45.05           C  
ATOM   1220  O   THR    80       1.017  -4.076   1.916  1.00 71.44           O  
ATOM   1221  CB  THR    80      -1.558  -5.147   3.137  1.00 41.01           C  
ATOM   1222  OG1 THR    80      -2.947  -5.106   3.503  1.00 65.52           O  
ATOM   1223  CG2 THR    80      -0.837  -6.182   3.998  1.00  5.43           C  
ATOM   1224  H   THR    80      -1.195  -2.681   1.463  1.00 37.41           H  
ATOM   1225  HA  THR    80      -1.093  -3.397   4.304  1.00 64.32           H  
ATOM   1226  HB  THR    80      -1.480  -5.447   2.100  1.00 64.12           H  
ATOM   1227  HG1 THR    80      -3.488  -5.116   2.709  1.00 11.42           H  
ATOM   1228 HG21 THR    80      -0.865  -5.876   5.034  1.00 37.41           H  
ATOM   1229 HG22 THR    80       0.192  -6.269   3.677  1.00 37.41           H  
ATOM   1230 HG23 THR    80      -1.326  -7.140   3.896  1.00 37.41           H  
ATOM   1231  N   SER    81       1.385  -3.644   4.084  1.00 55.20           N  
ATOM   1232  CA  SER    81       2.854  -3.672   3.956  1.00 70.42           C  
ATOM   1233  C   SER    81       3.435  -5.074   4.181  1.00  1.13           C  
ATOM   1234  O   SER    81       2.783  -5.955   4.752  1.00  0.21           O  
ATOM   1235  CB  SER    81       3.496  -2.690   4.943  1.00 14.40           C  
ATOM   1236  OG  SER    81       4.910  -2.741   4.869  1.00 40.10           O  
ATOM   1237  H   SER    81       0.986  -3.476   4.965  1.00 37.41           H  
ATOM   1238  HA  SER    81       3.099  -3.358   2.950  1.00 32.31           H  
ATOM   1239  HB2 SER    81       3.174  -1.686   4.710  1.00 37.41           H  
ATOM   1240  HB3 SER    81       3.189  -2.937   5.950  1.00 37.41           H  
ATOM   1241  HG  SER    81       5.256  -1.873   4.625  1.00 61.12           H  
ATOM   1242  N   GLN    82       4.677  -5.271   3.739  1.00  5.15           N  
ATOM   1243  CA  GLN    82       5.359  -6.558   3.892  1.00 21.22           C  
ATOM   1244  C   GLN    82       6.166  -6.618   5.200  1.00 62.30           C  
ATOM   1245  O   GLN    82       6.863  -5.668   5.560  1.00 11.14           O  
ATOM   1246  CB  GLN    82       6.300  -6.835   2.704  1.00 60.54           C  
ATOM   1247  CG  GLN    82       5.623  -6.827   1.331  1.00 40.12           C  
ATOM   1248  CD  GLN    82       5.440  -5.429   0.762  1.00 34.15           C  
ATOM   1249  OE1 GLN    82       4.416  -4.784   0.956  1.00 74.24           O  
ATOM   1250  NE2 GLN    82       6.438  -4.949   0.049  1.00 13.44           N  
ATOM   1251  H   GLN    82       5.147  -4.528   3.306  1.00 37.41           H  
ATOM   1252  HA  GLN    82       4.602  -7.330   3.918  1.00 24.02           H  
ATOM   1253  HB2 GLN    82       7.079  -6.085   2.698  1.00 37.41           H  
ATOM   1254  HB3 GLN    82       6.756  -7.805   2.847  1.00 37.41           H  
ATOM   1255  HG2 GLN    82       6.229  -7.400   0.645  1.00 37.41           H  
ATOM   1256  HG3 GLN    82       4.651  -7.295   1.421  1.00 37.41           H  
ATOM   1257 HE21 GLN    82       7.232  -5.512  -0.077  1.00 37.41           H  
ATOM   1258 HE22 GLN    82       6.351  -4.046  -0.311  1.00 37.41           H  
ATOM   1259  N   MET    83       6.062  -7.752   5.893  1.00 21.12           N  
ATOM   1260  CA  MET    83       6.801  -8.008   7.140  1.00 20.12           C  
ATOM   1261  C   MET    83       8.272  -7.528   7.081  1.00 52.45           C  
ATOM   1262  O   MET    83       9.072  -8.020   6.280  1.00 11.10           O  
ATOM   1263  CB  MET    83       6.744  -9.512   7.447  1.00 43.35           C  
ATOM   1264  CG  MET    83       7.207 -10.389   6.284  1.00  3.32           C  
ATOM   1265  SD  MET    83       6.966 -12.151   6.591  1.00 54.34           S  
ATOM   1266  CE  MET    83       7.519 -12.842   5.032  1.00 11.34           C  
ATOM   1267  H   MET    83       5.448  -8.442   5.563  1.00 37.41           H  
ATOM   1268  HA  MET    83       6.297  -7.475   7.933  1.00 14.22           H  
ATOM   1269  HB2 MET    83       7.371  -9.722   8.305  1.00 37.41           H  
ATOM   1270  HB3 MET    83       5.724  -9.780   7.687  1.00 37.41           H  
ATOM   1271  HG2 MET    83       6.649 -10.117   5.399  1.00 37.41           H  
ATOM   1272  HG3 MET    83       8.258 -10.210   6.111  1.00 37.41           H  
ATOM   1273  HE1 MET    83       8.537 -12.535   4.843  1.00 37.41           H  
ATOM   1274  HE2 MET    83       6.882 -12.488   4.235  1.00 37.41           H  
ATOM   1275  HE3 MET    83       7.472 -13.919   5.079  1.00 37.41           H  
ATOM   1276  N   TYR    84       8.613  -6.554   7.932  1.00 31.51           N  
ATOM   1277  CA  TYR    84       9.984  -6.026   8.013  1.00 62.50           C  
ATOM   1278  C   TYR    84      10.837  -6.825   9.012  1.00 11.43           C  
ATOM   1279  O   TYR    84      10.323  -7.658   9.759  1.00 44.01           O  
ATOM   1280  CB  TYR    84       9.965  -4.547   8.426  1.00 12.32           C  
ATOM   1281  CG  TYR    84       9.245  -3.642   7.444  1.00 41.13           C  
ATOM   1282  CD1 TYR    84       9.902  -3.121   6.334  1.00 70.11           C  
ATOM   1283  CD2 TYR    84       7.905  -3.308   7.626  1.00 12.42           C  
ATOM   1284  CE1 TYR    84       9.250  -2.294   5.440  1.00  1.15           C  
ATOM   1285  CE2 TYR    84       7.248  -2.483   6.735  1.00 14.23           C  
ATOM   1286  CZ  TYR    84       7.924  -1.978   5.644  1.00 12.04           C  
ATOM   1287  OH  TYR    84       7.268  -1.156   4.750  1.00 22.12           O  
ATOM   1288  H   TYR    84       7.924  -6.176   8.519  1.00 37.41           H  
ATOM   1289  HA  TYR    84      10.433  -6.109   7.032  1.00 13.23           H  
ATOM   1290  HB2 TYR    84       9.470  -4.455   9.383  1.00 37.41           H  
ATOM   1291  HB3 TYR    84      10.982  -4.193   8.520  1.00 37.41           H  
ATOM   1292  HD1 TYR    84      10.941  -3.370   6.174  1.00 62.23           H  
ATOM   1293  HD2 TYR    84       7.378  -3.702   8.483  1.00 30.20           H  
ATOM   1294  HE1 TYR    84       9.780  -1.899   4.585  1.00 12.23           H  
ATOM   1295  HE2 TYR    84       6.209  -2.237   6.896  1.00 61.43           H  
ATOM   1296  HH  TYR    84       7.405  -1.483   3.856  1.00 43.33           H  
ATOM   1297  N   SER    85      12.141  -6.561   9.027  1.00 13.02           N  
ATOM   1298  CA  SER    85      13.061  -7.245   9.949  1.00 52.24           C  
ATOM   1299  C   SER    85      13.109  -6.551  11.317  1.00 42.44           C  
ATOM   1300  O   SER    85      12.815  -7.158  12.349  1.00  1.01           O  
ATOM   1301  CB  SER    85      14.472  -7.300   9.348  1.00 54.31           C  
ATOM   1302  OG  SER    85      14.975  -5.995   9.092  1.00 43.35           O  
ATOM   1303  H   SER    85      12.498  -5.896   8.403  1.00 37.41           H  
ATOM   1304  HA  SER    85      12.702  -8.256  10.086  1.00 51.40           H  
ATOM   1305  HB2 SER    85      15.137  -7.798  10.039  1.00 37.41           H  
ATOM   1306  HB3 SER    85      14.443  -7.850   8.418  1.00 37.41           H  
ATOM   1307  HG  SER    85      15.881  -6.067   8.762  1.00  2.54           H  
ATOM   1308  N   SER    86      13.502  -5.279  11.322  1.00 63.42           N  
ATOM   1309  CA  SER    86      13.582  -4.489  12.559  1.00 74.23           C  
ATOM   1310  C   SER    86      12.373  -3.556  12.705  1.00 73.32           C  
ATOM   1311  O   SER    86      11.706  -3.226  11.719  1.00 23.32           O  
ATOM   1312  CB  SER    86      14.864  -3.644  12.572  1.00 54.32           C  
ATOM   1313  OG  SER    86      14.833  -2.648  11.557  1.00 20.40           O  
ATOM   1314  H   SER    86      13.752  -4.859  10.472  1.00 37.41           H  
ATOM   1315  HA  SER    86      13.604  -5.173  13.397  1.00 44.14           H  
ATOM   1316  HB2 SER    86      14.965  -3.158  13.532  1.00 37.41           H  
ATOM   1317  HB3 SER    86      15.718  -4.286  12.404  1.00 37.41           H  
ATOM   1318  HG  SER    86      15.653  -2.682  11.042  1.00 20.51           H  
ATOM   1319  N   THR    87      12.093  -3.124  13.933  1.00 65.31           N  
ATOM   1320  CA  THR    87      11.020  -2.149  14.177  1.00 45.55           C  
ATOM   1321  C   THR    87      11.331  -0.822  13.479  1.00 11.24           C  
ATOM   1322  O   THR    87      10.457  -0.203  12.870  1.00 23.25           O  
ATOM   1323  CB  THR    87      10.808  -1.882  15.687  1.00 50.10           C  
ATOM   1324  OG1 THR    87      11.999  -1.322  16.264  1.00 33.13           O  
ATOM   1325  CG2 THR    87      10.444  -3.167  16.423  1.00 61.13           C  
ATOM   1326  H   THR    87      12.616  -3.464  14.695  1.00 37.41           H  
ATOM   1327  HA  THR    87      10.102  -2.553  13.769  1.00 30.01           H  
ATOM   1328  HB  THR    87       9.997  -1.177  15.803  1.00 74.14           H  
ATOM   1329  HG1 THR    87      11.760  -0.583  16.839  1.00  3.11           H  
ATOM   1330 HG21 THR    87      11.243  -3.887  16.310  1.00 37.41           H  
ATOM   1331 HG22 THR    87       9.531  -3.574  16.010  1.00 37.41           H  
ATOM   1332 HG23 THR    87      10.299  -2.953  17.472  1.00 37.41           H  
ATOM   1333  N   ALA    88      12.596  -0.405  13.561  1.00 52.20           N  
ATOM   1334  CA  ALA    88      13.069   0.810  12.892  1.00 21.41           C  
ATOM   1335  C   ALA    88      12.811   0.757  11.376  1.00 34.01           C  
ATOM   1336  O   ALA    88      12.411   1.755  10.775  1.00 31.42           O  
ATOM   1337  CB  ALA    88      14.554   1.029  13.174  1.00 62.43           C  
ATOM   1338  H   ALA    88      13.229  -0.927  14.098  1.00 37.41           H  
ATOM   1339  HA  ALA    88      12.525   1.647  13.307  1.00 22.44           H  
ATOM   1340  HB1 ALA    88      14.722   1.033  14.240  1.00 37.41           H  
ATOM   1341  HB2 ALA    88      14.865   1.977  12.759  1.00 37.41           H  
ATOM   1342  HB3 ALA    88      15.131   0.234  12.723  1.00 37.41           H  
ATOM   1343  N   ALA    89      13.041  -0.408  10.763  1.00 22.32           N  
ATOM   1344  CA  ALA    89      12.750  -0.606   9.334  1.00 24.30           C  
ATOM   1345  C   ALA    89      11.290  -0.260   9.009  1.00 74.43           C  
ATOM   1346  O   ALA    89      10.999   0.381   7.999  1.00 61.43           O  
ATOM   1347  CB  ALA    89      13.051  -2.044   8.923  1.00 34.13           C  
ATOM   1348  H   ALA    89      13.429  -1.150  11.279  1.00 37.41           H  
ATOM   1349  HA  ALA    89      13.399   0.050   8.770  1.00 31.22           H  
ATOM   1350  HB1 ALA    89      12.424  -2.721   9.486  1.00 37.41           H  
ATOM   1351  HB2 ALA    89      14.088  -2.266   9.123  1.00 37.41           H  
ATOM   1352  HB3 ALA    89      12.855  -2.167   7.866  1.00 37.41           H  
ATOM   1353  N   ARG    90      10.381  -0.684   9.883  1.00 11.00           N  
ATOM   1354  CA  ARG    90       8.951  -0.412   9.713  1.00 33.04           C  
ATOM   1355  C   ARG    90       8.652   1.096   9.741  1.00 30.22           C  
ATOM   1356  O   ARG    90       8.065   1.641   8.808  1.00 73.34           O  
ATOM   1357  CB  ARG    90       8.152  -1.104  10.823  1.00 44.22           C  
ATOM   1358  CG  ARG    90       6.644  -0.872  10.740  1.00 45.02           C  
ATOM   1359  CD  ARG    90       5.953  -1.217  12.052  1.00 61.31           C  
ATOM   1360  NE  ARG    90       6.448  -0.396  13.158  1.00 33.23           N  
ATOM   1361  CZ  ARG    90       5.953  -0.406  14.365  1.00 13.35           C  
ATOM   1362  NH1 ARG    90       4.968  -1.191  14.672  1.00 64.35           N  
ATOM   1363  NH2 ARG    90       6.455   0.371  15.264  1.00 43.35           N  
ATOM   1364  H   ARG    90      10.680  -1.197  10.664  1.00 37.41           H  
ATOM   1365  HA  ARG    90       8.646  -0.814   8.758  1.00 34.12           H  
ATOM   1366  HB2 ARG    90       8.335  -2.169  10.770  1.00 37.41           H  
ATOM   1367  HB3 ARG    90       8.499  -0.738  11.779  1.00 37.41           H  
ATOM   1368  HG2 ARG    90       6.459   0.170  10.512  1.00 37.41           H  
ATOM   1369  HG3 ARG    90       6.236  -1.491   9.952  1.00 37.41           H  
ATOM   1370  HD2 ARG    90       4.890  -1.054  11.938  1.00 37.41           H  
ATOM   1371  HD3 ARG    90       6.135  -2.259  12.277  1.00 37.41           H  
ATOM   1372  HE  ARG    90       7.196   0.212  12.977  1.00 52.40           H  
ATOM   1373 HH11 ARG    90       4.581  -1.794  13.988  1.00 37.41           H  
ATOM   1374 HH12 ARG    90       4.591  -1.178  15.600  1.00 37.41           H  
ATOM   1375 HH21 ARG    90       7.217   0.980  15.028  1.00 37.41           H  
ATOM   1376 HH22 ARG    90       6.080   0.373  16.190  1.00 37.41           H  
ATOM   1377  N   ASP    91       9.064   1.763  10.816  1.00 40.42           N  
ATOM   1378  CA  ASP    91       8.766   3.187  11.006  1.00  2.52           C  
ATOM   1379  C   ASP    91       9.501   4.082   9.985  1.00 70.24           C  
ATOM   1380  O   ASP    91       8.964   5.108   9.551  1.00 75.01           O  
ATOM   1381  CB  ASP    91       9.087   3.594  12.447  1.00 21.44           C  
ATOM   1382  CG  ASP    91       8.134   2.936  13.440  1.00  2.12           C  
ATOM   1383  OD1 ASP    91       8.377   1.775  13.833  1.00 23.12           O  
ATOM   1384  OD2 ASP    91       7.127   3.571  13.818  1.00 30.33           O  
ATOM   1385  H   ASP    91       9.578   1.286  11.507  1.00 37.41           H  
ATOM   1386  HA  ASP    91       7.702   3.311  10.850  1.00 41.42           H  
ATOM   1387  HB2 ASP    91      10.099   3.294  12.684  1.00 37.41           H  
ATOM   1388  HB3 ASP    91       9.003   4.668  12.545  1.00 37.41           H  
ATOM   1389  N   ASN    92      10.717   3.698   9.593  1.00 24.54           N  
ATOM   1390  CA  ASN    92      11.417   4.388   8.500  1.00 43.40           C  
ATOM   1391  C   ASN    92      10.694   4.148   7.170  1.00 41.23           C  
ATOM   1392  O   ASN    92      10.585   5.048   6.331  1.00  5.51           O  
ATOM   1393  CB  ASN    92      12.887   3.949   8.402  1.00 21.14           C  
ATOM   1394  CG  ASN    92      13.772   4.674   9.401  1.00  3.32           C  
ATOM   1395  OD1 ASN    92      14.285   5.755   9.126  1.00  3.13           O  
ATOM   1396  ND2 ASN    92      13.967   4.091  10.563  1.00 32.32           N  
ATOM   1397  H   ASN    92      11.145   2.938  10.038  1.00 37.41           H  
ATOM   1398  HA  ASN    92      11.384   5.449   8.713  1.00 54.44           H  
ATOM   1399  HB2 ASN    92      12.954   2.888   8.595  1.00 37.41           H  
ATOM   1400  HB3 ASN    92      13.258   4.152   7.408  1.00 37.41           H  
ATOM   1401 HD21 ASN    92      13.540   3.227  10.725  1.00 37.41           H  
ATOM   1402 HD22 ASN    92      14.534   4.551  11.217  1.00 37.41           H  
ATOM   1403  N   GLY    93      10.190   2.929   6.988  1.00 33.01           N  
ATOM   1404  CA  GLY    93       9.344   2.637   5.843  1.00 30.33           C  
ATOM   1405  C   GLY    93       8.134   3.563   5.786  1.00 44.40           C  
ATOM   1406  O   GLY    93       7.849   4.154   4.747  1.00 20.01           O  
ATOM   1407  H   GLY    93      10.397   2.219   7.635  1.00 37.41           H  
ATOM   1408  HA2 GLY    93       9.924   2.753   4.939  1.00 37.41           H  
ATOM   1409  HA3 GLY    93       9.003   1.614   5.912  1.00 37.41           H  
ATOM   1410  N   ILE    94       7.447   3.709   6.923  1.00 62.14           N  
ATOM   1411  CA  ILE    94       6.288   4.608   7.043  1.00 63.01           C  
ATOM   1412  C   ILE    94       6.627   6.044   6.601  1.00 65.20           C  
ATOM   1413  O   ILE    94       5.849   6.682   5.889  1.00 33.41           O  
ATOM   1414  CB  ILE    94       5.743   4.632   8.499  1.00 21.43           C  
ATOM   1415  CG1 ILE    94       5.302   3.219   8.929  1.00 22.41           C  
ATOM   1416  CG2 ILE    94       4.585   5.624   8.628  1.00 31.41           C  
ATOM   1417  CD1 ILE    94       4.824   3.133  10.365  1.00  5.53           C  
ATOM   1418  H   ILE    94       7.722   3.187   7.707  1.00 37.41           H  
ATOM   1419  HA  ILE    94       5.507   4.226   6.398  1.00 63.10           H  
ATOM   1420  HB  ILE    94       6.540   4.963   9.151  1.00 62.24           H  
ATOM   1421 HG12 ILE    94       4.489   2.896   8.295  1.00 37.41           H  
ATOM   1422 HG13 ILE    94       6.133   2.537   8.814  1.00 37.41           H  
ATOM   1423 HG21 ILE    94       4.214   5.620   9.643  1.00 37.41           H  
ATOM   1424 HG22 ILE    94       3.789   5.340   7.954  1.00 37.41           H  
ATOM   1425 HG23 ILE    94       4.930   6.617   8.377  1.00 37.41           H  
ATOM   1426 HD11 ILE    94       3.967   3.777  10.500  1.00 37.41           H  
ATOM   1427 HD12 ILE    94       5.616   3.447  11.029  1.00 37.41           H  
ATOM   1428 HD13 ILE    94       4.547   2.114  10.593  1.00 37.41           H  
ATOM   1429  N   LYS    95       7.788   6.552   7.022  1.00 12.12           N  
ATOM   1430  CA  LYS    95       8.235   7.888   6.599  1.00  3.54           C  
ATOM   1431  C   LYS    95       8.322   7.975   5.064  1.00 12.31           C  
ATOM   1432  O   LYS    95       7.893   8.962   4.450  1.00 50.22           O  
ATOM   1433  CB  LYS    95       9.593   8.237   7.227  1.00 22.14           C  
ATOM   1434  CG  LYS    95       9.587   8.239   8.756  1.00  4.23           C  
ATOM   1435  CD  LYS    95      10.887   8.798   9.339  1.00 72.42           C  
ATOM   1436  CE  LYS    95      12.109   7.977   8.938  1.00 70.43           C  
ATOM   1437  NZ  LYS    95      13.371   8.537   9.501  1.00 24.34           N  
ATOM   1438  H   LYS    95       8.350   6.022   7.631  1.00 37.41           H  
ATOM   1439  HA  LYS    95       7.498   8.603   6.941  1.00 23.11           H  
ATOM   1440  HB2 LYS    95      10.326   7.516   6.891  1.00 37.41           H  
ATOM   1441  HB3 LYS    95       9.889   9.221   6.888  1.00 37.41           H  
ATOM   1442  HG2 LYS    95       8.761   8.846   9.101  1.00 37.41           H  
ATOM   1443  HG3 LYS    95       9.455   7.224   9.104  1.00 37.41           H  
ATOM   1444  HD2 LYS    95      11.020   9.810   8.984  1.00 37.41           H  
ATOM   1445  HD3 LYS    95      10.809   8.806  10.417  1.00 37.41           H  
ATOM   1446  HE2 LYS    95      11.985   6.967   9.301  1.00 37.41           H  
ATOM   1447  HE3 LYS    95      12.184   7.965   7.859  1.00 37.41           H  
ATOM   1448  HZ1 LYS    95      14.163   7.886   9.326  1.00 37.41           H  
ATOM   1449  HZ2 LYS    95      13.276   8.681  10.528  1.00 37.41           H  
ATOM   1450  HZ3 LYS    95      13.591   9.450   9.056  1.00 37.41           H  
ATOM   1451  N   SER    96       8.874   6.930   4.450  1.00 12.50           N  
ATOM   1452  CA  SER    96       8.935   6.835   2.987  1.00 44.14           C  
ATOM   1453  C   SER    96       7.523   6.782   2.387  1.00 64.41           C  
ATOM   1454  O   SER    96       7.223   7.487   1.426  1.00 44.33           O  
ATOM   1455  CB  SER    96       9.733   5.594   2.559  1.00 22.51           C  
ATOM   1456  OG  SER    96      11.057   5.631   3.076  1.00 73.53           O  
ATOM   1457  H   SER    96       9.251   6.202   4.993  1.00 37.41           H  
ATOM   1458  HA  SER    96       9.437   7.720   2.617  1.00 20.13           H  
ATOM   1459  HB2 SER    96       9.243   4.706   2.928  1.00 37.41           H  
ATOM   1460  HB3 SER    96       9.785   5.554   1.479  1.00 37.41           H  
ATOM   1461  HG  SER    96      11.063   5.256   3.966  1.00 64.30           H  
ATOM   1462  N   VAL    97       6.660   5.955   2.985  1.00 22.23           N  
ATOM   1463  CA  VAL    97       5.264   5.803   2.542  1.00 24.34           C  
ATOM   1464  C   VAL    97       4.527   7.147   2.515  1.00  2.13           C  
ATOM   1465  O   VAL    97       3.820   7.463   1.560  1.00 62.41           O  
ATOM   1466  CB  VAL    97       4.482   4.840   3.469  1.00 14.51           C  
ATOM   1467  CG1 VAL    97       3.028   4.690   3.018  1.00 71.24           C  
ATOM   1468  CG2 VAL    97       5.166   3.484   3.543  1.00 15.31           C  
ATOM   1469  H   VAL    97       6.969   5.428   3.749  1.00 37.41           H  
ATOM   1470  HA  VAL    97       5.273   5.385   1.545  1.00  1.13           H  
ATOM   1471  HB  VAL    97       4.483   5.263   4.462  1.00 32.32           H  
ATOM   1472 HG11 VAL    97       2.517   3.998   3.672  1.00 37.41           H  
ATOM   1473 HG12 VAL    97       2.999   4.315   2.006  1.00 37.41           H  
ATOM   1474 HG13 VAL    97       2.536   5.653   3.057  1.00 37.41           H  
ATOM   1475 HG21 VAL    97       6.196   3.614   3.837  1.00 37.41           H  
ATOM   1476 HG22 VAL    97       5.126   3.005   2.576  1.00 37.41           H  
ATOM   1477 HG23 VAL    97       4.663   2.866   4.269  1.00 37.41           H  
ATOM   1478  N   MET    98       4.684   7.935   3.575  1.00 75.31           N  
ATOM   1479  CA  MET    98       4.060   9.256   3.635  1.00 41.35           C  
ATOM   1480  C   MET    98       4.594  10.166   2.521  1.00 41.34           C  
ATOM   1481  O   MET    98       3.834  10.905   1.898  1.00  0.11           O  
ATOM   1482  CB  MET    98       4.282   9.904   5.010  1.00  4.12           C  
ATOM   1483  CG  MET    98       3.651   9.128   6.161  1.00  3.41           C  
ATOM   1484  SD  MET    98       3.719  10.019   7.729  1.00 30.23           S  
ATOM   1485  CE  MET    98       5.489  10.191   7.964  1.00 73.24           C  
ATOM   1486  H   MET    98       5.226   7.621   4.328  1.00 37.41           H  
ATOM   1487  HA  MET    98       2.997   9.119   3.485  1.00 63.30           H  
ATOM   1488  HB2 MET    98       5.345   9.979   5.192  1.00 37.41           H  
ATOM   1489  HB3 MET    98       3.857  10.899   5.001  1.00 37.41           H  
ATOM   1490  HG2 MET    98       2.615   8.938   5.924  1.00 37.41           H  
ATOM   1491  HG3 MET    98       4.171   8.187   6.275  1.00 37.41           H  
ATOM   1492  HE1 MET    98       5.914  10.735   7.133  1.00 37.41           H  
ATOM   1493  HE2 MET    98       5.944   9.212   8.020  1.00 37.41           H  
ATOM   1494  HE3 MET    98       5.681  10.729   8.882  1.00 37.41           H  
ATOM   1495  N   GLU    99       5.900  10.090   2.259  1.00 34.51           N  
ATOM   1496  CA  GLU    99       6.524  10.917   1.218  1.00 32.11           C  
ATOM   1497  C   GLU    99       6.046  10.539  -0.201  1.00 60.22           C  
ATOM   1498  O   GLU    99       5.629  11.400  -0.976  1.00 44.32           O  
ATOM   1499  CB  GLU    99       8.050  10.794   1.271  1.00 52.15           C  
ATOM   1500  CG  GLU    99       8.757  11.763   0.329  1.00 14.20           C  
ATOM   1501  CD  GLU    99      10.186  11.363   0.018  1.00 63.03           C  
ATOM   1502  OE1 GLU    99      11.087  11.658   0.828  1.00  4.14           O  
ATOM   1503  OE2 GLU    99      10.411  10.767  -1.055  1.00 13.44           O  
ATOM   1504  H   GLU    99       6.463   9.475   2.785  1.00 37.41           H  
ATOM   1505  HA  GLU    99       6.253  11.946   1.411  1.00 25.32           H  
ATOM   1506  HB2 GLU    99       8.383  10.993   2.280  1.00 37.41           H  
ATOM   1507  HB3 GLU    99       8.331   9.785   1.000  1.00 37.41           H  
ATOM   1508  HG2 GLU    99       8.204  11.808  -0.599  1.00 37.41           H  
ATOM   1509  HG3 GLU    99       8.764  12.745   0.782  1.00 37.41           H  
ATOM   1510  N   ASN   100       6.127   9.251  -0.544  1.00  3.11           N  
ATOM   1511  CA  ASN   100       5.842   8.796  -1.917  1.00 53.52           C  
ATOM   1512  C   ASN   100       4.372   8.388  -2.122  1.00 23.34           C  
ATOM   1513  O   ASN   100       3.846   8.496  -3.227  1.00 14.11           O  
ATOM   1514  CB  ASN   100       6.779   7.641  -2.304  1.00 64.23           C  
ATOM   1515  CG  ASN   100       6.757   6.484  -1.319  1.00 11.22           C  
ATOM   1516  OD1 ASN   100       5.763   6.225  -0.659  1.00  1.03           O  
ATOM   1517  ND2 ASN   100       7.864   5.780  -1.212  1.00 14.54           N  
ATOM   1518  H   ASN   100       6.376   8.589   0.139  1.00 37.41           H  
ATOM   1519  HA  ASN   100       6.048   9.629  -2.577  1.00  2.41           H  
ATOM   1520  HB2 ASN   100       6.490   7.260  -3.272  1.00 37.41           H  
ATOM   1521  HB3 ASN   100       7.792   8.017  -2.366  1.00 37.41           H  
ATOM   1522 HD21 ASN   100       8.632   6.031  -1.764  1.00 37.41           H  
ATOM   1523 HD22 ASN   100       7.867   5.034  -0.583  1.00 37.41           H  
ATOM   1524  N   GLY   101       3.716   7.930  -1.060  1.00 34.41           N  
ATOM   1525  CA  GLY   101       2.311   7.520  -1.144  1.00 21.04           C  
ATOM   1526  C   GLY   101       1.373   8.620  -1.650  1.00 72.40           C  
ATOM   1527  O   GLY   101       0.233   8.351  -2.033  1.00  3.20           O  
ATOM   1528  H   GLY   101       4.194   7.839  -0.209  1.00 37.41           H  
ATOM   1529  HA2 GLY   101       2.236   6.673  -1.809  1.00 37.41           H  
ATOM   1530  HA3 GLY   101       1.986   7.212  -0.161  1.00 37.41           H  
ATOM   1531  N   LYS   102       1.852   9.862  -1.651  1.00 64.32           N  
ATOM   1532  CA  LYS   102       1.064  11.005  -2.128  1.00 23.43           C  
ATOM   1533  C   LYS   102       1.444  11.394  -3.572  1.00 33.45           C  
ATOM   1534  O   LYS   102       1.112  12.486  -4.037  1.00 42.10           O  
ATOM   1535  CB  LYS   102       1.271  12.209  -1.191  1.00 55.44           C  
ATOM   1536  CG  LYS   102       2.708  12.725  -1.150  1.00  1.32           C  
ATOM   1537  CD  LYS   102       2.859  13.962  -0.259  1.00 41.23           C  
ATOM   1538  CE  LYS   102       2.866  13.628   1.232  1.00 74.51           C  
ATOM   1539  NZ  LYS   102       1.570  13.084   1.723  1.00 50.10           N  
ATOM   1540  H   LYS   102       2.756  10.017  -1.318  1.00 37.41           H  
ATOM   1541  HA  LYS   102       0.019  10.726  -2.107  1.00 64.40           H  
ATOM   1542  HB2 LYS   102       0.630  13.016  -1.516  1.00 37.41           H  
ATOM   1543  HB3 LYS   102       0.985  11.920  -0.188  1.00 37.41           H  
ATOM   1544  HG2 LYS   102       3.349  11.942  -0.772  1.00 37.41           H  
ATOM   1545  HG3 LYS   102       3.013  12.979  -2.156  1.00 37.41           H  
ATOM   1546  HD2 LYS   102       3.791  14.452  -0.504  1.00 37.41           H  
ATOM   1547  HD3 LYS   102       2.040  14.640  -0.461  1.00 37.41           H  
ATOM   1548  HE2 LYS   102       3.639  12.897   1.416  1.00 37.41           H  
ATOM   1549  HE3 LYS   102       3.096  14.528   1.784  1.00 37.41           H  
ATOM   1550  HZ1 LYS   102       1.407  12.130   1.341  1.00 37.41           H  
ATOM   1551  HZ2 LYS   102       0.784  13.703   1.435  1.00 37.41           H  
ATOM   1552  HZ3 LYS   102       1.582  13.028   2.761  1.00 37.41           H  
ATOM   1553  N   THR   103       2.137  10.496  -4.280  1.00 35.15           N  
ATOM   1554  CA  THR   103       2.586  10.777  -5.656  1.00 14.31           C  
ATOM   1555  C   THR   103       1.483  10.510  -6.689  1.00 53.11           C  
ATOM   1556  O   THR   103       0.536   9.766  -6.433  1.00 73.50           O  
ATOM   1557  CB  THR   103       3.836   9.947  -6.053  1.00 70.12           C  
ATOM   1558  OG1 THR   103       4.388  10.449  -7.285  1.00 22.34           O  
ATOM   1559  CG2 THR   103       3.496   8.467  -6.228  1.00 71.24           C  
ATOM   1560  H   THR   103       2.344   9.626  -3.875  1.00 37.41           H  
ATOM   1561  HA  THR   103       2.855  11.823  -5.706  1.00 31.50           H  
ATOM   1562  HB  THR   103       4.577  10.041  -5.271  1.00 71.21           H  
ATOM   1563  HG1 THR   103       5.226  10.002  -7.467  1.00  4.21           H  
ATOM   1564 HG21 THR   103       2.754   8.354  -7.008  1.00 37.41           H  
ATOM   1565 HG22 THR   103       3.105   8.073  -5.301  1.00 37.41           H  
ATOM   1566 HG23 THR   103       4.387   7.920  -6.501  1.00 37.41           H  
ATOM   1567  N   THR   104       1.620  11.120  -7.862  1.00 31.13           N  
ATOM   1568  CA  THR   104       0.651  10.944  -8.954  1.00 32.22           C  
ATOM   1569  C   THR   104       1.164   9.969 -10.024  1.00 70.41           C  
ATOM   1570  O   THR   104       0.440   9.627 -10.960  1.00 30.14           O  
ATOM   1571  CB  THR   104       0.320  12.293  -9.635  1.00 24.42           C  
ATOM   1572  OG1 THR   104       1.515  12.875 -10.180  1.00 51.34           O  
ATOM   1573  CG2 THR   104      -0.316  13.266  -8.646  1.00 55.23           C  
ATOM   1574  H   THR   104       2.391  11.714  -8.001  1.00 37.41           H  
ATOM   1575  HA  THR   104      -0.262  10.545  -8.531  1.00 50.10           H  
ATOM   1576  HB  THR   104      -0.380  12.111 -10.439  1.00 22.41           H  
ATOM   1577  HG1 THR   104       1.423  12.956 -11.139  1.00 11.44           H  
ATOM   1578 HG21 THR   104       0.356  13.430  -7.814  1.00 37.41           H  
ATOM   1579 HG22 THR   104      -1.245  12.854  -8.280  1.00 37.41           H  
ATOM   1580 HG23 THR   104      -0.512  14.208  -9.140  1.00 37.41           H  
ATOM   1581  N   THR   105       2.415   9.529  -9.891  1.00 14.23           N  
ATOM   1582  CA  THR   105       3.013   8.591 -10.854  1.00 20.42           C  
ATOM   1583  C   THR   105       2.410   7.184 -10.712  1.00 74.13           C  
ATOM   1584  O   THR   105       2.790   6.416  -9.825  1.00 51.22           O  
ATOM   1585  CB  THR   105       4.554   8.505 -10.693  1.00 44.42           C  
ATOM   1586  OG1 THR   105       5.134   9.813 -10.815  1.00 24.24           O  
ATOM   1587  CG2 THR   105       5.172   7.579 -11.742  1.00 75.21           C  
ATOM   1588  H   THR   105       2.952   9.843  -9.134  1.00 37.41           H  
ATOM   1589  HA  THR   105       2.800   8.962 -11.848  1.00 23.14           H  
ATOM   1590  HB  THR   105       4.779   8.113  -9.709  1.00 13.31           H  
ATOM   1591  HG1 THR   105       5.239  10.030 -11.749  1.00  0.32           H  
ATOM   1592 HG21 THR   105       4.931   7.940 -12.731  1.00 37.41           H  
ATOM   1593 HG22 THR   105       4.782   6.578 -11.620  1.00 37.41           H  
ATOM   1594 HG23 THR   105       6.247   7.561 -11.620  1.00 37.41           H  
ATOM   1595  N   ILE   106       1.457   6.855 -11.586  1.00 44.22           N  
ATOM   1596  CA  ILE   106       0.781   5.551 -11.555  1.00 73.12           C  
ATOM   1597  C   ILE   106       0.951   4.798 -12.887  1.00 32.44           C  
ATOM   1598  O   ILE   106       0.569   5.296 -13.949  1.00 45.14           O  
ATOM   1599  CB  ILE   106      -0.734   5.710 -11.255  1.00 50.10           C  
ATOM   1600  CG1 ILE   106      -0.945   6.476  -9.937  1.00 42.04           C  
ATOM   1601  CG2 ILE   106      -1.417   4.342 -11.201  1.00 24.13           C  
ATOM   1602  CD1 ILE   106      -2.399   6.734  -9.598  1.00 63.53           C  
ATOM   1603  H   ILE   106       1.195   7.511 -12.268  1.00 37.41           H  
ATOM   1604  HA  ILE   106       1.224   4.963 -10.762  1.00 62.42           H  
ATOM   1605  HB  ILE   106      -1.179   6.273 -12.064  1.00 14.02           H  
ATOM   1606 HG12 ILE   106      -0.517   5.907  -9.125  1.00 37.41           H  
ATOM   1607 HG13 ILE   106      -0.445   7.434 -10.000  1.00 37.41           H  
ATOM   1608 HG21 ILE   106      -2.471   4.473 -11.004  1.00 37.41           H  
ATOM   1609 HG22 ILE   106      -0.976   3.749 -10.415  1.00 37.41           H  
ATOM   1610 HG23 ILE   106      -1.290   3.837 -12.148  1.00 37.41           H  
ATOM   1611 HD11 ILE   106      -2.861   7.300 -10.394  1.00 37.41           H  
ATOM   1612 HD12 ILE   106      -2.460   7.294  -8.678  1.00 37.41           H  
ATOM   1613 HD13 ILE   106      -2.915   5.792  -9.480  1.00 37.41           H  
ATOM   1614  N   LYS   107       1.515   3.593 -12.819  1.00 22.22           N  
ATOM   1615  CA  LYS   107       1.743   2.759 -14.007  1.00 24.23           C  
ATOM   1616  C   LYS   107       0.701   1.631 -14.109  1.00 55.21           C  
ATOM   1617  O   LYS   107       0.537   0.849 -13.173  1.00 60.10           O  
ATOM   1618  CB  LYS   107       3.146   2.138 -13.951  1.00 24.43           C  
ATOM   1619  CG  LYS   107       4.284   3.155 -13.897  1.00  0.22           C  
ATOM   1620  CD  LYS   107       5.643   2.470 -13.746  1.00 71.45           C  
ATOM   1621  CE  LYS   107       6.791   3.473 -13.728  1.00 74.43           C  
ATOM   1622  NZ  LYS   107       6.956   4.166 -15.033  1.00 72.12           N  
ATOM   1623  H   LYS   107       1.794   3.251 -11.944  1.00 37.41           H  
ATOM   1624  HA  LYS   107       1.671   3.389 -14.883  1.00  2.54           H  
ATOM   1625  HB2 LYS   107       3.213   1.511 -13.071  1.00 37.41           H  
ATOM   1626  HB3 LYS   107       3.287   1.521 -14.828  1.00 37.41           H  
ATOM   1627  HG2 LYS   107       4.282   3.731 -14.810  1.00 37.41           H  
ATOM   1628  HG3 LYS   107       4.126   3.813 -13.053  1.00 37.41           H  
ATOM   1629  HD2 LYS   107       5.653   1.912 -12.821  1.00 37.41           H  
ATOM   1630  HD3 LYS   107       5.786   1.791 -14.575  1.00 37.41           H  
ATOM   1631  HE2 LYS   107       6.598   4.212 -12.962  1.00 37.41           H  
ATOM   1632  HE3 LYS   107       7.706   2.948 -13.492  1.00 37.41           H  
ATOM   1633  HZ1 LYS   107       6.062   4.614 -15.319  1.00 37.41           H  
ATOM   1634  HZ2 LYS   107       7.240   3.485 -15.767  1.00 37.41           H  
ATOM   1635  HZ3 LYS   107       7.689   4.900 -14.960  1.00 37.41           H  
ATOM   1636  N   ASP   108      -0.007   1.550 -15.237  1.00 71.14           N  
ATOM   1637  CA  ASP   108      -0.917   0.431 -15.488  1.00 54.31           C  
ATOM   1638  C   ASP   108      -0.181  -0.710 -16.218  1.00 22.43           C  
ATOM   1639  O   ASP   108       0.368  -0.516 -17.308  1.00  0.32           O  
ATOM   1640  CB  ASP   108      -2.132   0.895 -16.310  1.00 64.04           C  
ATOM   1641  CG  ASP   108      -3.160  -0.211 -16.509  1.00 60.11           C  
ATOM   1642  OD1 ASP   108      -2.911  -1.126 -17.321  1.00 25.55           O  
ATOM   1643  OD2 ASP   108      -4.223  -0.178 -15.856  1.00 52.43           O  
ATOM   1644  H   ASP   108       0.073   2.261 -15.910  1.00 37.41           H  
ATOM   1645  HA  ASP   108      -1.265   0.064 -14.531  1.00  2.35           H  
ATOM   1646  HB2 ASP   108      -2.607   1.722 -15.801  1.00 37.41           H  
ATOM   1647  HB3 ASP   108      -1.795   1.228 -17.283  1.00 37.41           H  
ATOM   1648  N   LEU   109      -0.162  -1.889 -15.604  1.00 62.34           N  
ATOM   1649  CA  LEU   109       0.457  -3.083 -16.201  1.00  5.54           C  
ATOM   1650  C   LEU   109      -0.608  -4.150 -16.514  1.00 34.51           C  
ATOM   1651  O   LEU   109      -0.292  -5.320 -16.745  1.00 53.33           O  
ATOM   1652  CB  LEU   109       1.511  -3.663 -15.239  1.00  3.13           C  
ATOM   1653  CG  LEU   109       2.597  -2.676 -14.772  1.00 74.52           C  
ATOM   1654  CD1 LEU   109       3.544  -3.347 -13.782  1.00 30.34           C  
ATOM   1655  CD2 LEU   109       3.368  -2.116 -15.964  1.00 45.23           C  
ATOM   1656  H   LEU   109      -0.561  -1.960 -14.712  1.00 37.41           H  
ATOM   1657  HA  LEU   109       0.938  -2.791 -17.124  1.00 40.53           H  
ATOM   1658  HB2 LEU   109       0.999  -4.041 -14.364  1.00 37.41           H  
ATOM   1659  HB3 LEU   109       2.000  -4.493 -15.732  1.00 37.41           H  
ATOM   1660  HG  LEU   109       2.122  -1.847 -14.264  1.00 50.13           H  
ATOM   1661 HD11 LEU   109       4.065  -4.160 -14.269  1.00 37.41           H  
ATOM   1662 HD12 LEU   109       2.977  -3.734 -12.948  1.00 37.41           H  
ATOM   1663 HD13 LEU   109       4.262  -2.624 -13.421  1.00 37.41           H  
ATOM   1664 HD21 LEU   109       2.687  -1.608 -16.630  1.00 37.41           H  
ATOM   1665 HD22 LEU   109       3.852  -2.925 -16.494  1.00 37.41           H  
ATOM   1666 HD23 LEU   109       4.117  -1.419 -15.616  1.00 37.41           H  
ATOM   1667  N   THR   110      -1.872  -3.731 -16.530  1.00  1.33           N  
ATOM   1668  CA  THR   110      -2.999  -4.655 -16.729  1.00 62.42           C  
ATOM   1669  C   THR   110      -3.425  -4.709 -18.201  1.00 13.21           C  
ATOM   1670  O   THR   110      -3.577  -5.787 -18.780  1.00 25.20           O  
ATOM   1671  CB  THR   110      -4.222  -4.245 -15.871  1.00  1.14           C  
ATOM   1672  OG1 THR   110      -4.816  -3.037 -16.381  1.00 74.21           O  
ATOM   1673  CG2 THR   110      -3.816  -4.028 -14.418  1.00 41.22           C  
ATOM   1674  H   THR   110      -2.054  -2.773 -16.421  1.00 37.41           H  
ATOM   1675  HA  THR   110      -2.684  -5.642 -16.420  1.00 10.12           H  
ATOM   1676  HB  THR   110      -4.954  -5.040 -15.907  1.00 33.15           H  
ATOM   1677  HG1 THR   110      -4.211  -2.293 -16.242  1.00  4.31           H  
ATOM   1678 HG21 THR   110      -4.673  -3.694 -13.851  1.00 37.41           H  
ATOM   1679 HG22 THR   110      -3.039  -3.277 -14.368  1.00 37.41           H  
ATOM   1680 HG23 THR   110      -3.449  -4.955 -14.001  1.00 37.41           H  
END
