
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 ( 1627),  selected  107 , name 2cof_A
# Molecule2: number of CA atoms  110 ( 1680),  selected  110 , name T0472.pdb
# PARAMETERS: 2cof_A.T0472.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      M       1           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    L     8_A      -       -           -
LGA    E     9_A      -       -           -
LGA    T    10_A      S       2          6.115
LGA    S    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    Y    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    N    15_A      -       -           -
LGA    V    16_A      -       -           -
LGA    L    17_A      -       -           -
LGA    V    18_A      -       -           -
LGA    N    19_A      -       -           -
LGA    S    20_A      -       -           -
LGA    Q    21_A      -       -           -
LGA    W    22_A      -       -           -
LGA    K    23_A      -       -           -
LGA    S    24_A      -       -           -
LGA    R    25_A      -       -           -
LGA    W    26_A      -       -           -
LGA    C    27_A      -       -           -
LGA    S    28_A      -       -           -
LGA    V    29_A      G       3          3.824
LGA    R    30_A      W       4          1.420
LGA    D    31_A      -       -           -
LGA    N    32_A      -       -           -
LGA    H    33_A      -       -           -
LGA    L    34_A      Y       5          3.602
LGA    H    35_A      E       6          2.616
LGA    F    36_A      L       7          5.192
LGA    Y    37_A      -       -           -
LGA    Q    38_A      -       -           -
LGA    D    39_A      -       -           -
LGA    R    40_A      -       -           -
LGA    N    41_A      -       -           -
LGA    R    42_A      -       -           -
LGA    S    43_A      -       -           -
LGA    K    44_A      -       -           -
LGA    V    45_A      S       8          2.959
LGA    A    46_A      K       9          4.892
LGA    Q    47_A      S      10           #
LGA    -       -      S      11           -
LGA    -       -      N      12           -
LGA    -       -      D      13           -
LGA    -       -      Q      14           -
LGA    -       -      F      15           -
LGA    Q    48_A      K      16          4.263
LGA    P    49_A      F      17          3.011
LGA    -       -      V      18           -
LGA    -       -      L      19           -
LGA    -       -      K      20           -
LGA    -       -      A      21           -
LGA    -       -      G      22           -
LGA    -       -      N      23           -
LGA    -       -      G      24           -
LGA    -       -      E      25           -
LGA    -       -      V      26           -
LGA    -       -      I      27           -
LGA    -       -      L      28           -
LGA    -       -      T      29           -
LGA    -       -      S      30           -
LGA    -       -      E      31           -
LGA    -       -      L      32           -
LGA    -       -      Y      33           -
LGA    -       -      T      34           -
LGA    -       -      G      35           -
LGA    -       -      K      36           -
LGA    -       -      S      37           -
LGA    -       -      G      38           -
LGA    -       -      A      39           -
LGA    L    50_A      M      40           #
LGA    -       -      N      41           -
LGA    -       -      G      42           -
LGA    S    51_A      I      43          0.989
LGA    -       -      E      44           -
LGA    -       -      S      45           -
LGA    L    52_A      V      46          2.232
LGA    V    53_A      Q      47          0.273
LGA    G    54_A      T      48          1.803
LGA    C    55_A      N      49          2.988
LGA    -       -      S      50           -
LGA    -       -      P      51           -
LGA    -       -      I      52           -
LGA    -       -      E      53           -
LGA    -       -      A      54           -
LGA    E    56_A      R      55          3.350
LGA    V    57_A      Y      56          3.300
LGA    V    58_A      A      57          2.964
LGA    P    59_A      K      58          1.703
LGA    D    60_A      E      59          2.029
LGA    P    61_A      V      60          2.028
LGA    S    62_A      A      61          1.932
LGA    P    63_A      K      62          1.563
LGA    D    64_A      N      63          2.414
LGA    H    65_A      D      64          3.600
LGA    L    66_A      K      65          3.424
LGA    Y    67_A      P      66          1.508
LGA    S    68_A      Y      67          0.864
LGA    F    69_A      F      68          0.772
LGA    R    70_A      N      69          0.555
LGA    I    71_A      L      70          0.748
LGA    L    72_A      K      71          0.725
LGA    H    73_A      A      72          0.527
LGA    K    74_A      A      73          1.166
LGA    -       -      N      74           -
LGA    G    75_A      H      75          2.312
LGA    E    76_A      Q      76          1.942
LGA    E    77_A      I      77          1.210
LGA    L    78_A      I      78          1.092
LGA    A    79_A      G      79          2.443
LGA    K    80_A      T      80          1.541
LGA    L    81_A      S      81          1.419
LGA    E    82_A      Q      82          1.974
LGA    A    83_A      M      83          3.396
LGA    K    84_A      Y      84          2.825
LGA    S    85_A      S      85          1.693
LGA    S    86_A      S      86          2.129
LGA    -       -      T      87           -
LGA    E    87_A      A      88          2.851
LGA    E    88_A      A      89          2.225
LGA    M    89_A      R      90          1.468
LGA    G    90_A      D      91          1.905
LGA    H    91_A      N      92          2.182
LGA    W    92_A      G      93          1.782
LGA    L    93_A      I      94          1.077
LGA    G    94_A      K      95          1.677
LGA    L    95_A      S      96          1.698
LGA    L    96_A      V      97          1.619
LGA    L    97_A      M      98          2.605
LGA    S    98_A      E      99          3.573
LGA    -       -      N     100           -
LGA    E    99_A      G     101          3.024
LGA    S   100_A      K     102          4.774
LGA    G   101_A      T     103           -
LGA    S   102_A      T     104           -
LGA    G   103_A      T     105           -
LGA    P   104_A      I     106           -
LGA    S   105_A      K     107           -
LGA    S   106_A      D     108           -
LGA    G   107_A      L     109           -
LGA    -       -      T     110           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107  110    5.0     60    2.60     5.00     40.150     2.224

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.502564 * X  +  -0.454189 * Y  +   0.735624 * Z  +   0.083955
  Y_new =  -0.240537 * X  +   0.890746 * Y  +   0.385634 * Z  +   0.813175
  Z_new =  -0.830405 * X  +   0.016861 * Y  +  -0.556906 * Z  +  -0.689843 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.111325   -0.030267  [ DEG:   178.2658     -1.7342 ]
  Theta =   0.979834    2.161759  [ DEG:    56.1403    123.8597 ]
  Phi   =  -2.695196    0.446397  [ DEG:  -154.4233     25.5767 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cof_A                                        
REMARK     2: T0472.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cof_A.T0472.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107  110   5.0   60   2.60    5.00  40.150
REMARK  ---------------------------------------------------------- 
MOLECULE 2cof_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   17-MAY-05   2COF              
TITLE     SOLUTION STRUCTURE OF THE C-TERMINAL PH DOMAIN OF                     
TITLE    2 HYPOTHETICAL PROTEIN KIAA1914 FROM HUMAN                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN KIAA1914;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PH DOMAIN;                                                 
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KIAA1914;                                                      
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040921-07;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    HYPOTHETICAL PROTEIN KIAA1914, PH DOMAIN, STRUCTURAL                  
KEYWDS   2 GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   3 RSGI, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND             
KEYWDS   4 FUNCTIONAL ANALYSES                                                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN              
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   17-NOV-05 2COF    0                                                
JRNL        AUTH   H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA           
JRNL        TITL   SOLUTION STRUCTURE OF THE C-TERMINAL PH DOMAIN OF            
JRNL        TITL 2 HYPOTHETICAL PROTEIN KIAA1914 FROM HUMAN                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2COF A    8   101  UNP    Q8N4X5   K1914_HUMAN    354    447             
SEQRES   1 A  107  GLY SER SER GLY SER SER GLY LEU GLU THR SER SER TYR          
SEQRES   2 A  107  LEU ASN VAL LEU VAL ASN SER GLN TRP LYS SER ARG TRP          
SEQRES   3 A  107  CYS SER VAL ARG ASP ASN HIS LEU HIS PHE TYR GLN ASP          
SEQRES   4 A  107  ARG ASN ARG SER LYS VAL ALA GLN GLN PRO LEU SER LEU          
SEQRES   5 A  107  VAL GLY CYS GLU VAL VAL PRO ASP PRO SER PRO ASP HIS          
SEQRES   6 A  107  LEU TYR SER PHE ARG ILE LEU HIS LYS GLY GLU GLU LEU          
SEQRES   7 A  107  ALA LYS LEU GLU ALA LYS SER SER GLU GLU MET GLY HIS          
SEQRES   8 A  107  TRP LEU GLY LEU LEU LEU SER GLU SER GLY SER GLY PRO          
SEQRES   9 A  107  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      18.377  -1.949   9.281  1.00  0.00           N  
ATOM      2  CA  GLY A   1      19.390  -2.805   9.871  1.00  0.00           C  
ATOM      3  C   GLY A   1      20.794  -2.411   9.459  1.00  0.00           C  
ATOM      4  O   GLY A   1      21.534  -1.813  10.239  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      19.313  -2.746  10.947  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      19.209  -3.824   9.561  1.00  0.00           H  
ATOM      7  H1  GLY A   1      18.588  -1.014   9.077  1.00  0.00           H  
ATOM      8  N   SER A   2      21.164  -2.748   8.227  1.00  0.00           N  
ATOM      9  CA  SER A   2      22.491  -2.430   7.712  1.00  0.00           C  
ATOM     10  C   SER A   2      22.544  -0.995   7.196  1.00  0.00           C  
ATOM     11  O   SER A   2      22.065  -0.700   6.101  1.00  0.00           O  
ATOM     12  CB  SER A   2      22.874  -3.401   6.595  1.00  0.00           C  
ATOM     13  OG  SER A   2      23.290  -4.649   7.124  1.00  0.00           O  
ATOM     14  H   SER A   2      20.529  -3.224   7.651  1.00  0.00           H  
ATOM     15  HA  SER A   2      23.194  -2.534   8.525  1.00  0.00           H  
ATOM     16  HB2 SER A   2      22.021  -3.563   5.954  1.00  0.00           H  
ATOM     17  HB3 SER A   2      23.685  -2.980   6.017  1.00  0.00           H  
ATOM     18  HG  SER A   2      22.678  -5.335   6.848  1.00  0.00           H  
ATOM     19  N   SER A   3      23.131  -0.108   7.991  1.00  0.00           N  
ATOM     20  CA  SER A   3      23.245   1.297   7.618  1.00  0.00           C  
ATOM     21  C   SER A   3      24.520   1.545   6.819  1.00  0.00           C  
ATOM     22  O   SER A   3      25.579   1.811   7.386  1.00  0.00           O  
ATOM     23  CB  SER A   3      23.230   2.181   8.866  1.00  0.00           C  
ATOM     24  OG  SER A   3      23.496   3.534   8.535  1.00  0.00           O  
ATOM     25  H   SER A   3      23.494  -0.405   8.852  1.00  0.00           H  
ATOM     26  HA  SER A   3      22.394   1.545   7.001  1.00  0.00           H  
ATOM     27  HB2 SER A   3      22.261   2.121   9.336  1.00  0.00           H  
ATOM     28  HB3 SER A   3      23.986   1.837   9.556  1.00  0.00           H  
ATOM     29  HG  SER A   3      23.464   4.070   9.331  1.00  0.00           H  
ATOM     30  N   GLY A   4      24.411   1.456   5.497  1.00  0.00           N  
ATOM     31  CA  GLY A   4      25.562   1.673   4.641  1.00  0.00           C  
ATOM     32  C   GLY A   4      25.394   1.042   3.272  1.00  0.00           C  
ATOM     33  O   GLY A   4      26.332   0.458   2.731  1.00  0.00           O  
ATOM     34  H   GLY A   4      23.541   1.241   5.100  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      25.712   2.735   4.519  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      26.435   1.248   5.115  1.00  0.00           H  
ATOM     37  N   SER A   5      24.194   1.159   2.712  1.00  0.00           N  
ATOM     38  CA  SER A   5      23.905   0.591   1.401  1.00  0.00           C  
ATOM     39  C   SER A   5      23.050   1.545   0.572  1.00  0.00           C  
ATOM     40  O   SER A   5      21.870   1.746   0.858  1.00  0.00           O  
ATOM     41  CB  SER A   5      23.190  -0.753   1.551  1.00  0.00           C  
ATOM     42  OG  SER A   5      23.134  -1.442   0.313  1.00  0.00           O  
ATOM     43  H   SER A   5      23.487   1.636   3.194  1.00  0.00           H  
ATOM     44  HA  SER A   5      24.844   0.434   0.892  1.00  0.00           H  
ATOM     45  HB2 SER A   5      23.721  -1.364   2.265  1.00  0.00           H  
ATOM     46  HB3 SER A   5      22.182  -0.585   1.901  1.00  0.00           H  
ATOM     47  HG  SER A   5      22.543  -2.195   0.392  1.00  0.00           H  
ATOM     48  N   SER A   6      23.655   2.130  -0.456  1.00  0.00           N  
ATOM     49  CA  SER A   6      22.952   3.066  -1.325  1.00  0.00           C  
ATOM     50  C   SER A   6      22.332   2.342  -2.516  1.00  0.00           C  
ATOM     51  O   SER A   6      22.824   1.301  -2.948  1.00  0.00           O  
ATOM     52  CB  SER A   6      23.908   4.155  -1.817  1.00  0.00           C  
ATOM     53  OG  SER A   6      24.332   4.983  -0.749  1.00  0.00           O  
ATOM     54  H   SER A   6      24.598   1.929  -0.634  1.00  0.00           H  
ATOM     55  HA  SER A   6      22.163   3.526  -0.749  1.00  0.00           H  
ATOM     56  HB2 SER A   6      24.775   3.694  -2.265  1.00  0.00           H  
ATOM     57  HB3 SER A   6      23.404   4.766  -2.553  1.00  0.00           H  
ATOM     58  HG  SER A   6      24.986   4.517  -0.223  1.00  0.00           H  
ATOM     59  N   GLY A   7      21.247   2.902  -3.043  1.00  0.00           N  
ATOM     60  CA  GLY A   7      20.577   2.297  -4.178  1.00  0.00           C  
ATOM     61  C   GLY A   7      19.281   1.612  -3.789  1.00  0.00           C  
ATOM     62  O   GLY A   7      19.084   0.430  -4.076  1.00  0.00           O  
ATOM     63  H   GLY A   7      20.899   3.733  -2.656  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      20.361   3.064  -4.907  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      21.236   1.566  -4.623  1.00  0.00           H  
ATOM     66  N   LEU A   8      18.396   2.354  -3.134  1.00  0.00           N  
ATOM     67  CA  LEU A   8      17.112   1.811  -2.703  1.00  0.00           C  
ATOM     68  C   LEU A   8      15.988   2.275  -3.625  1.00  0.00           C  
ATOM     69  O   LEU A   8      15.154   1.477  -4.051  1.00  0.00           O  
ATOM     70  CB  LEU A   8      16.814   2.235  -1.264  1.00  0.00           C  
ATOM     71  CG  LEU A   8      15.798   1.377  -0.509  1.00  0.00           C  
ATOM     72  CD1 LEU A   8      15.979   1.534   0.993  1.00  0.00           C  
ATOM     73  CD2 LEU A   8      14.379   1.746  -0.918  1.00  0.00           C  
ATOM     74  H   LEU A   8      18.609   3.289  -2.934  1.00  0.00           H  
ATOM     75  HA  LEU A   8      17.176   0.734  -2.748  1.00  0.00           H  
ATOM     76  HB2 LEU A   8      17.742   2.209  -0.713  1.00  0.00           H  
ATOM     77  HB3 LEU A   8      16.440   3.248  -1.289  1.00  0.00           H  
ATOM     78  HG  LEU A   8      15.959   0.337  -0.757  1.00  0.00           H  
ATOM     79 HD11 LEU A   8      15.239   0.940   1.508  1.00  0.00           H  
ATOM     80 HD12 LEU A   8      15.859   2.572   1.263  1.00  0.00           H  
ATOM     81 HD13 LEU A   8      16.967   1.201   1.273  1.00  0.00           H  
ATOM     82 HD21 LEU A   8      13.685   1.041  -0.484  1.00  0.00           H  
ATOM     83 HD22 LEU A   8      14.296   1.715  -1.996  1.00  0.00           H  
ATOM     84 HD23 LEU A   8      14.151   2.741  -0.567  1.00  0.00           H  
ATOM     85  N   GLU A   9      15.974   3.569  -3.928  1.00  0.00           N  
ATOM     86  CA  GLU A   9      14.953   4.138  -4.799  1.00  0.00           C  
ATOM     87  C   GLU A   9      13.555   3.747  -4.328  1.00  0.00           C  
ATOM     88  O   GLU A   9      12.683   3.424  -5.134  1.00  0.00           O  
ATOM     89  CB  GLU A   9      15.165   3.673  -6.242  1.00  0.00           C  
ATOM     90  CG  GLU A   9      16.511   4.076  -6.819  1.00  0.00           C  
ATOM     91  CD  GLU A   9      17.674   3.402  -6.117  1.00  0.00           C  
ATOM     92  OE1 GLU A   9      17.849   2.179  -6.300  1.00  0.00           O  
ATOM     93  OE2 GLU A   9      18.408   4.096  -5.385  1.00  0.00           O  
ATOM     94  H   GLU A   9      16.666   4.155  -3.556  1.00  0.00           H  
ATOM     95  HA  GLU A   9      15.046   5.213  -4.761  1.00  0.00           H  
ATOM     96  HB2 GLU A   9      15.091   2.596  -6.275  1.00  0.00           H  
ATOM     97  HB3 GLU A   9      14.389   4.097  -6.862  1.00  0.00           H  
ATOM     98  HG2 GLU A   9      16.536   3.805  -7.865  1.00  0.00           H  
ATOM     99  HG3 GLU A   9      16.624   5.146  -6.723  1.00  0.00           H  
ATOM    100  N   THR A  10      13.350   3.778  -3.015  1.00  0.00           N  
ATOM    101  CA  THR A  10      12.060   3.426  -2.434  1.00  0.00           C  
ATOM    102  C   THR A  10      11.385   2.314  -3.229  1.00  0.00           C  
ATOM    103  O   THR A  10      10.171   2.330  -3.430  1.00  0.00           O  
ATOM    104  CB  THR A  10      11.119   4.644  -2.376  1.00  0.00           C  
ATOM    105  OG1 THR A  10      10.891   5.151  -3.695  1.00  0.00           O  
ATOM    106  CG2 THR A  10      11.707   5.740  -1.500  1.00  0.00           C  
ATOM    107  H   THR A  10      14.085   4.045  -2.423  1.00  0.00           H  
ATOM    108  HA  THR A  10      12.232   3.081  -1.425  1.00  0.00           H  
ATOM    109  HB  THR A  10      10.176   4.330  -1.952  1.00  0.00           H  
ATOM    110  HG1 THR A  10      10.283   4.573  -4.160  1.00  0.00           H  
ATOM    111 HG21 THR A  10      11.255   6.687  -1.757  1.00  0.00           H  
ATOM    112 HG22 THR A  10      12.772   5.795  -1.658  1.00  0.00           H  
ATOM    113 HG23 THR A  10      11.507   5.516  -0.462  1.00  0.00           H  
ATOM    114  N   SER A  11      12.180   1.348  -3.679  1.00  0.00           N  
ATOM    115  CA  SER A  11      11.659   0.229  -4.455  1.00  0.00           C  
ATOM    116  C   SER A  11      12.145  -1.100  -3.885  1.00  0.00           C  
ATOM    117  O   SER A  11      12.537  -2.000  -4.628  1.00  0.00           O  
ATOM    118  CB  SER A  11      12.082   0.355  -5.919  1.00  0.00           C  
ATOM    119  OG  SER A  11      13.479   0.161  -6.064  1.00  0.00           O  
ATOM    120  H   SER A  11      13.139   1.391  -3.486  1.00  0.00           H  
ATOM    121  HA  SER A  11      10.580   0.258  -4.397  1.00  0.00           H  
ATOM    122  HB2 SER A  11      11.566  -0.389  -6.506  1.00  0.00           H  
ATOM    123  HB3 SER A  11      11.827   1.341  -6.282  1.00  0.00           H  
ATOM    124  HG  SER A  11      13.758  -0.577  -5.518  1.00  0.00           H  
ATOM    125  N   SER A  12      12.116  -1.215  -2.561  1.00  0.00           N  
ATOM    126  CA  SER A  12      12.558  -2.433  -1.891  1.00  0.00           C  
ATOM    127  C   SER A  12      11.458  -3.490  -1.905  1.00  0.00           C  
ATOM    128  O   SER A  12      10.283  -3.177  -2.096  1.00  0.00           O  
ATOM    129  CB  SER A  12      12.967  -2.126  -0.448  1.00  0.00           C  
ATOM    130  OG  SER A  12      14.192  -1.414  -0.406  1.00  0.00           O  
ATOM    131  H   SER A  12      11.793  -0.462  -2.023  1.00  0.00           H  
ATOM    132  HA  SER A  12      13.415  -2.814  -2.425  1.00  0.00           H  
ATOM    133  HB2 SER A  12      12.202  -1.527   0.021  1.00  0.00           H  
ATOM    134  HB3 SER A  12      13.083  -3.052   0.095  1.00  0.00           H  
ATOM    135  HG  SER A  12      14.306  -0.924  -1.224  1.00  0.00           H  
ATOM    136  N   TYR A  13      11.848  -4.743  -1.700  1.00  0.00           N  
ATOM    137  CA  TYR A  13      10.898  -5.848  -1.692  1.00  0.00           C  
ATOM    138  C   TYR A  13      10.103  -5.873  -0.390  1.00  0.00           C  
ATOM    139  O   TYR A  13      10.668  -5.760   0.698  1.00  0.00           O  
ATOM    140  CB  TYR A  13      11.628  -7.179  -1.882  1.00  0.00           C  
ATOM    141  CG  TYR A  13      11.837  -7.552  -3.331  1.00  0.00           C  
ATOM    142  CD1 TYR A  13      10.769  -7.601  -4.218  1.00  0.00           C  
ATOM    143  CD2 TYR A  13      13.103  -7.858  -3.815  1.00  0.00           C  
ATOM    144  CE1 TYR A  13      10.955  -7.942  -5.544  1.00  0.00           C  
ATOM    145  CE2 TYR A  13      13.299  -8.199  -5.140  1.00  0.00           C  
ATOM    146  CZ  TYR A  13      12.222  -8.240  -6.000  1.00  0.00           C  
ATOM    147  OH  TYR A  13      12.412  -8.581  -7.319  1.00  0.00           O  
ATOM    148  H   TYR A  13      12.799  -4.929  -1.553  1.00  0.00           H  
ATOM    149  HA  TYR A  13      10.214  -5.703  -2.515  1.00  0.00           H  
ATOM    150  HB2 TYR A  13      12.598  -7.120  -1.412  1.00  0.00           H  
ATOM    151  HB3 TYR A  13      11.055  -7.966  -1.416  1.00  0.00           H  
ATOM    152  HD1 TYR A  13       9.777  -7.366  -3.858  1.00  0.00           H  
ATOM    153  HD2 TYR A  13      13.945  -7.826  -3.138  1.00  0.00           H  
ATOM    154  HE1 TYR A  13      10.111  -7.974  -6.218  1.00  0.00           H  
ATOM    155  HE2 TYR A  13      14.291  -8.434  -5.497  1.00  0.00           H  
ATOM    156  HH  TYR A  13      11.640  -9.052  -7.643  1.00  0.00           H  
ATOM    157  N   LEU A  14       8.788  -6.022  -0.510  1.00  0.00           N  
ATOM    158  CA  LEU A  14       7.913  -6.064   0.657  1.00  0.00           C  
ATOM    159  C   LEU A  14       6.944  -7.238   0.570  1.00  0.00           C  
ATOM    160  O   LEU A  14       6.652  -7.735  -0.517  1.00  0.00           O  
ATOM    161  CB  LEU A  14       7.135  -4.753   0.781  1.00  0.00           C  
ATOM    162  CG  LEU A  14       7.797  -3.655   1.614  1.00  0.00           C  
ATOM    163  CD1 LEU A  14       6.960  -2.386   1.586  1.00  0.00           C  
ATOM    164  CD2 LEU A  14       8.009  -4.125   3.046  1.00  0.00           C  
ATOM    165  H   LEU A  14       8.396  -6.108  -1.403  1.00  0.00           H  
ATOM    166  HA  LEU A  14       8.534  -6.188   1.533  1.00  0.00           H  
ATOM    167  HB2 LEU A  14       6.979  -4.365  -0.214  1.00  0.00           H  
ATOM    168  HB3 LEU A  14       6.178  -4.979   1.232  1.00  0.00           H  
ATOM    169  HG  LEU A  14       8.765  -3.425   1.190  1.00  0.00           H  
ATOM    170 HD11 LEU A  14       7.166  -1.838   0.679  1.00  0.00           H  
ATOM    171 HD12 LEU A  14       7.207  -1.773   2.441  1.00  0.00           H  
ATOM    172 HD13 LEU A  14       5.911  -2.645   1.620  1.00  0.00           H  
ATOM    173 HD21 LEU A  14       9.065  -4.132   3.269  1.00  0.00           H  
ATOM    174 HD22 LEU A  14       7.610  -5.123   3.159  1.00  0.00           H  
ATOM    175 HD23 LEU A  14       7.500  -3.455   3.723  1.00  0.00           H  
ATOM    176  N   ASN A  15       6.448  -7.676   1.723  1.00  0.00           N  
ATOM    177  CA  ASN A  15       5.510  -8.792   1.777  1.00  0.00           C  
ATOM    178  C   ASN A  15       4.069  -8.293   1.732  1.00  0.00           C  
ATOM    179  O   ASN A  15       3.568  -7.726   2.704  1.00  0.00           O  
ATOM    180  CB  ASN A  15       5.739  -9.617   3.044  1.00  0.00           C  
ATOM    181  CG  ASN A  15       6.735 -10.739   2.833  1.00  0.00           C  
ATOM    182  OD1 ASN A  15       6.878 -11.258   1.725  1.00  0.00           O  
ATOM    183  ND2 ASN A  15       7.432 -11.121   3.897  1.00  0.00           N  
ATOM    184  H   ASN A  15       6.720  -7.239   2.557  1.00  0.00           H  
ATOM    185  HA  ASN A  15       5.689  -9.417   0.914  1.00  0.00           H  
ATOM    186  HB2 ASN A  15       6.115  -8.970   3.824  1.00  0.00           H  
ATOM    187  HB3 ASN A  15       4.801 -10.047   3.361  1.00  0.00           H  
ATOM    188 HD21 ASN A  15       7.266 -10.664   4.748  1.00  0.00           H  
ATOM    189 HD22 ASN A  15       8.084 -11.845   3.788  1.00  0.00           H  
ATOM    190  N   VAL A  16       3.407  -8.510   0.600  1.00  0.00           N  
ATOM    191  CA  VAL A  16       2.023  -8.084   0.431  1.00  0.00           C  
ATOM    192  C   VAL A  16       1.056  -9.216   0.760  1.00  0.00           C  
ATOM    193  O   VAL A  16       0.904 -10.162  -0.015  1.00  0.00           O  
ATOM    194  CB  VAL A  16       1.758  -7.598  -1.007  1.00  0.00           C  
ATOM    195  CG1 VAL A  16       0.295  -7.220  -1.181  1.00  0.00           C  
ATOM    196  CG2 VAL A  16       2.665  -6.425  -1.347  1.00  0.00           C  
ATOM    197  H   VAL A  16       3.861  -8.967  -0.138  1.00  0.00           H  
ATOM    198  HA  VAL A  16       1.842  -7.261   1.107  1.00  0.00           H  
ATOM    199  HB  VAL A  16       1.981  -8.408  -1.686  1.00  0.00           H  
ATOM    200 HG11 VAL A  16       0.124  -6.240  -0.760  1.00  0.00           H  
ATOM    201 HG12 VAL A  16       0.048  -7.211  -2.232  1.00  0.00           H  
ATOM    202 HG13 VAL A  16      -0.327  -7.942  -0.671  1.00  0.00           H  
ATOM    203 HG21 VAL A  16       3.129  -6.597  -2.307  1.00  0.00           H  
ATOM    204 HG22 VAL A  16       2.080  -5.517  -1.389  1.00  0.00           H  
ATOM    205 HG23 VAL A  16       3.428  -6.328  -0.590  1.00  0.00           H  
ATOM    206  N   LEU A  17       0.404  -9.114   1.912  1.00  0.00           N  
ATOM    207  CA  LEU A  17      -0.550 -10.129   2.344  1.00  0.00           C  
ATOM    208  C   LEU A  17      -1.532 -10.465   1.226  1.00  0.00           C  
ATOM    209  O   LEU A  17      -2.110  -9.574   0.604  1.00  0.00           O  
ATOM    210  CB  LEU A  17      -1.313  -9.646   3.579  1.00  0.00           C  
ATOM    211  CG  LEU A  17      -2.076 -10.719   4.359  1.00  0.00           C  
ATOM    212  CD1 LEU A  17      -1.123 -11.790   4.864  1.00  0.00           C  
ATOM    213  CD2 LEU A  17      -2.841 -10.095   5.516  1.00  0.00           C  
ATOM    214  H   LEU A  17       0.567  -8.337   2.487  1.00  0.00           H  
ATOM    215  HA  LEU A  17       0.005 -11.019   2.600  1.00  0.00           H  
ATOM    216  HB2 LEU A  17      -0.602  -9.193   4.252  1.00  0.00           H  
ATOM    217  HB3 LEU A  17      -2.027  -8.902   3.256  1.00  0.00           H  
ATOM    218  HG  LEU A  17      -2.791 -11.192   3.701  1.00  0.00           H  
ATOM    219 HD11 LEU A  17      -0.123 -11.577   4.514  1.00  0.00           H  
ATOM    220 HD12 LEU A  17      -1.436 -12.755   4.492  1.00  0.00           H  
ATOM    221 HD13 LEU A  17      -1.133 -11.801   5.944  1.00  0.00           H  
ATOM    222 HD21 LEU A  17      -2.180  -9.452   6.079  1.00  0.00           H  
ATOM    223 HD22 LEU A  17      -3.218 -10.875   6.161  1.00  0.00           H  
ATOM    224 HD23 LEU A  17      -3.666  -9.514   5.131  1.00  0.00           H  
ATOM    225  N   VAL A  18      -1.715 -11.759   0.976  1.00  0.00           N  
ATOM    226  CA  VAL A  18      -2.629 -12.214  -0.065  1.00  0.00           C  
ATOM    227  C   VAL A  18      -3.415 -13.437   0.391  1.00  0.00           C  
ATOM    228  O   VAL A  18      -2.836 -14.442   0.803  1.00  0.00           O  
ATOM    229  CB  VAL A  18      -1.874 -12.555  -1.364  1.00  0.00           C  
ATOM    230  CG1 VAL A  18      -2.823 -13.155  -2.390  1.00  0.00           C  
ATOM    231  CG2 VAL A  18      -1.186 -11.318  -1.920  1.00  0.00           C  
ATOM    232  H   VAL A  18      -1.226 -12.422   1.505  1.00  0.00           H  
ATOM    233  HA  VAL A  18      -3.321 -11.411  -0.276  1.00  0.00           H  
ATOM    234  HB  VAL A  18      -1.117 -13.290  -1.133  1.00  0.00           H  
ATOM    235 HG11 VAL A  18      -3.798 -13.287  -1.945  1.00  0.00           H  
ATOM    236 HG12 VAL A  18      -2.900 -12.494  -3.240  1.00  0.00           H  
ATOM    237 HG13 VAL A  18      -2.443 -14.114  -2.714  1.00  0.00           H  
ATOM    238 HG21 VAL A  18      -1.741 -10.950  -2.771  1.00  0.00           H  
ATOM    239 HG22 VAL A  18      -1.146 -10.553  -1.158  1.00  0.00           H  
ATOM    240 HG23 VAL A  18      -0.182 -11.572  -2.228  1.00  0.00           H  
ATOM    241  N   ASN A  19      -4.739 -13.347   0.312  1.00  0.00           N  
ATOM    242  CA  ASN A  19      -5.605 -14.448   0.716  1.00  0.00           C  
ATOM    243  C   ASN A  19      -5.092 -15.104   1.993  1.00  0.00           C  
ATOM    244  O   ASN A  19      -4.925 -16.322   2.055  1.00  0.00           O  
ATOM    245  CB  ASN A  19      -5.699 -15.487  -0.403  1.00  0.00           C  
ATOM    246  CG  ASN A  19      -6.841 -15.206  -1.360  1.00  0.00           C  
ATOM    247  OD1 ASN A  19      -7.952 -15.708  -1.184  1.00  0.00           O  
ATOM    248  ND2 ASN A  19      -6.573 -14.399  -2.380  1.00  0.00           N  
ATOM    249  H   ASN A  19      -5.142 -12.521  -0.027  1.00  0.00           H  
ATOM    250  HA  ASN A  19      -6.589 -14.044   0.902  1.00  0.00           H  
ATOM    251  HB2 ASN A  19      -4.776 -15.487  -0.965  1.00  0.00           H  
ATOM    252  HB3 ASN A  19      -5.850 -16.464   0.033  1.00  0.00           H  
ATOM    253 HD21 ASN A  19      -5.666 -14.036  -2.457  1.00  0.00           H  
ATOM    254 HD22 ASN A  19      -7.293 -14.199  -3.013  1.00  0.00           H  
ATOM    255  N   SER A  20      -4.842 -14.288   3.012  1.00  0.00           N  
ATOM    256  CA  SER A  20      -4.345 -14.788   4.289  1.00  0.00           C  
ATOM    257  C   SER A  20      -3.036 -15.549   4.100  1.00  0.00           C  
ATOM    258  O   SER A  20      -2.806 -16.575   4.740  1.00  0.00           O  
ATOM    259  CB  SER A  20      -5.386 -15.696   4.946  1.00  0.00           C  
ATOM    260  OG  SER A  20      -6.312 -14.942   5.709  1.00  0.00           O  
ATOM    261  H   SER A  20      -4.996 -13.325   2.902  1.00  0.00           H  
ATOM    262  HA  SER A  20      -4.164 -13.938   4.929  1.00  0.00           H  
ATOM    263  HB2 SER A  20      -5.924 -16.235   4.182  1.00  0.00           H  
ATOM    264  HB3 SER A  20      -4.887 -16.398   5.598  1.00  0.00           H  
ATOM    265  HG  SER A  20      -6.686 -15.496   6.397  1.00  0.00           H  
ATOM    266  N   GLN A  21      -2.183 -15.038   3.218  1.00  0.00           N  
ATOM    267  CA  GLN A  21      -0.898 -15.670   2.945  1.00  0.00           C  
ATOM    268  C   GLN A  21       0.142 -14.632   2.535  1.00  0.00           C  
ATOM    269  O   GLN A  21      -0.049 -13.897   1.566  1.00  0.00           O  
ATOM    270  CB  GLN A  21      -1.047 -16.722   1.844  1.00  0.00           C  
ATOM    271  CG  GLN A  21      -1.873 -17.928   2.263  1.00  0.00           C  
ATOM    272  CD  GLN A  21      -1.569 -19.160   1.434  1.00  0.00           C  
ATOM    273  OE1 GLN A  21      -0.669 -19.151   0.593  1.00  0.00           O  
ATOM    274  NE2 GLN A  21      -2.319 -20.231   1.668  1.00  0.00           N  
ATOM    275  H   GLN A  21      -2.424 -14.218   2.740  1.00  0.00           H  
ATOM    276  HA  GLN A  21      -0.567 -16.154   3.851  1.00  0.00           H  
ATOM    277  HB2 GLN A  21      -1.522 -16.267   0.988  1.00  0.00           H  
ATOM    278  HB3 GLN A  21      -0.064 -17.069   1.558  1.00  0.00           H  
ATOM    279  HG2 GLN A  21      -1.664 -18.150   3.299  1.00  0.00           H  
ATOM    280  HG3 GLN A  21      -2.920 -17.686   2.153  1.00  0.00           H  
ATOM    281 HE21 GLN A  21      -3.018 -20.165   2.352  1.00  0.00           H  
ATOM    282 HE22 GLN A  21      -2.144 -21.040   1.146  1.00  0.00           H  
ATOM    283  N   TRP A  22       1.241 -14.579   3.278  1.00  0.00           N  
ATOM    284  CA  TRP A  22       2.312 -13.631   2.992  1.00  0.00           C  
ATOM    285  C   TRP A  22       3.124 -14.075   1.781  1.00  0.00           C  
ATOM    286  O   TRP A  22       3.939 -14.994   1.870  1.00  0.00           O  
ATOM    287  CB  TRP A  22       3.227 -13.481   4.208  1.00  0.00           C  
ATOM    288  CG  TRP A  22       2.543 -12.875   5.396  1.00  0.00           C  
ATOM    289  CD1 TRP A  22       2.101 -13.530   6.510  1.00  0.00           C  
ATOM    290  CD2 TRP A  22       2.222 -11.493   5.586  1.00  0.00           C  
ATOM    291  NE1 TRP A  22       1.525 -12.637   7.381  1.00  0.00           N  
ATOM    292  CE2 TRP A  22       1.586 -11.382   6.838  1.00  0.00           C  
ATOM    293  CE3 TRP A  22       2.411 -10.338   4.822  1.00  0.00           C  
ATOM    294  CZ2 TRP A  22       1.139 -10.162   7.340  1.00  0.00           C  
ATOM    295  CZ3 TRP A  22       1.966  -9.129   5.321  1.00  0.00           C  
ATOM    296  CH2 TRP A  22       1.338  -9.048   6.570  1.00  0.00           C  
ATOM    297  H   TRP A  22       1.336 -15.192   4.038  1.00  0.00           H  
ATOM    298  HA  TRP A  22       1.858 -12.675   2.775  1.00  0.00           H  
ATOM    299  HB2 TRP A  22       3.594 -14.455   4.496  1.00  0.00           H  
ATOM    300  HB3 TRP A  22       4.063 -12.850   3.945  1.00  0.00           H  
ATOM    301  HD1 TRP A  22       2.196 -14.593   6.668  1.00  0.00           H  
ATOM    302  HE1 TRP A  22       1.133 -12.864   8.251  1.00  0.00           H  
ATOM    303  HE3 TRP A  22       2.893 -10.380   3.857  1.00  0.00           H  
ATOM    304  HZ2 TRP A  22       0.653 -10.083   8.302  1.00  0.00           H  
ATOM    305  HZ3 TRP A  22       2.103  -8.226   4.744  1.00  0.00           H  
ATOM    306  HH2 TRP A  22       1.005  -8.083   6.921  1.00  0.00           H  
ATOM    307  N   LYS A  23       2.896 -13.420   0.647  1.00  0.00           N  
ATOM    308  CA  LYS A  23       3.607 -13.746  -0.582  1.00  0.00           C  
ATOM    309  C   LYS A  23       4.513 -12.596  -1.009  1.00  0.00           C  
ATOM    310  O   LYS A  23       4.125 -11.430  -0.938  1.00  0.00           O  
ATOM    311  CB  LYS A  23       2.613 -14.069  -1.700  1.00  0.00           C  
ATOM    312  CG  LYS A  23       1.354 -14.765  -1.213  1.00  0.00           C  
ATOM    313  CD  LYS A  23       0.606 -15.428  -2.357  1.00  0.00           C  
ATOM    314  CE  LYS A  23       1.015 -16.883  -2.522  1.00  0.00           C  
ATOM    315  NZ  LYS A  23       2.116 -17.041  -3.512  1.00  0.00           N  
ATOM    316  H   LYS A  23       2.233 -12.697   0.639  1.00  0.00           H  
ATOM    317  HA  LYS A  23       4.217 -14.617  -0.392  1.00  0.00           H  
ATOM    318  HB2 LYS A  23       2.325 -13.148  -2.186  1.00  0.00           H  
ATOM    319  HB3 LYS A  23       3.098 -14.711  -2.422  1.00  0.00           H  
ATOM    320  HG2 LYS A  23       1.628 -15.519  -0.490  1.00  0.00           H  
ATOM    321  HG3 LYS A  23       0.708 -14.035  -0.747  1.00  0.00           H  
ATOM    322  HD2 LYS A  23      -0.454 -15.385  -2.154  1.00  0.00           H  
ATOM    323  HD3 LYS A  23       0.820 -14.896  -3.272  1.00  0.00           H  
ATOM    324  HE2 LYS A  23       1.345 -17.261  -1.566  1.00  0.00           H  
ATOM    325  HE3 LYS A  23       0.159 -17.449  -2.856  1.00  0.00           H  
ATOM    326  HZ1 LYS A  23       1.723 -17.180  -4.465  1.00  0.00           H  
ATOM    327  HZ2 LYS A  23       2.702 -17.864  -3.268  1.00  0.00           H  
ATOM    328  HZ3 LYS A  23       2.717 -16.191  -3.517  1.00  0.00           H  
ATOM    329  N   SER A  24       5.719 -12.932  -1.453  1.00  0.00           N  
ATOM    330  CA  SER A  24       6.682 -11.926  -1.890  1.00  0.00           C  
ATOM    331  C   SER A  24       6.146 -11.146  -3.086  1.00  0.00           C  
ATOM    332  O   SER A  24       5.758 -11.729  -4.099  1.00  0.00           O  
ATOM    333  CB  SER A  24       8.013 -12.586  -2.251  1.00  0.00           C  
ATOM    334  OG  SER A  24       7.828 -13.621  -3.201  1.00  0.00           O  
ATOM    335  H   SER A  24       5.970 -13.879  -1.486  1.00  0.00           H  
ATOM    336  HA  SER A  24       6.839 -11.241  -1.070  1.00  0.00           H  
ATOM    337  HB2 SER A  24       8.678 -11.845  -2.668  1.00  0.00           H  
ATOM    338  HB3 SER A  24       8.457 -13.006  -1.359  1.00  0.00           H  
ATOM    339  HG  SER A  24       7.020 -13.463  -3.693  1.00  0.00           H  
ATOM    340  N   ARG A  25       6.128  -9.823  -2.962  1.00  0.00           N  
ATOM    341  CA  ARG A  25       5.639  -8.961  -4.033  1.00  0.00           C  
ATOM    342  C   ARG A  25       6.453  -7.673  -4.107  1.00  0.00           C  
ATOM    343  O   ARG A  25       6.907  -7.154  -3.087  1.00  0.00           O  
ATOM    344  CB  ARG A  25       4.161  -8.632  -3.816  1.00  0.00           C  
ATOM    345  CG  ARG A  25       3.640  -7.539  -4.735  1.00  0.00           C  
ATOM    346  CD  ARG A  25       3.229  -8.097  -6.088  1.00  0.00           C  
ATOM    347  NE  ARG A  25       2.019  -8.909  -6.001  1.00  0.00           N  
ATOM    348  CZ  ARG A  25       2.029 -10.230  -5.848  1.00  0.00           C  
ATOM    349  NH1 ARG A  25       3.181 -10.881  -5.766  1.00  0.00           N  
ATOM    350  NH2 ARG A  25       0.886 -10.899  -5.776  1.00  0.00           N  
ATOM    351  H   ARG A  25       6.450  -9.416  -2.131  1.00  0.00           H  
ATOM    352  HA  ARG A  25       5.748  -9.495  -4.965  1.00  0.00           H  
ATOM    353  HB2 ARG A  25       3.577  -9.524  -3.988  1.00  0.00           H  
ATOM    354  HB3 ARG A  25       4.022  -8.311  -2.795  1.00  0.00           H  
ATOM    355  HG2 ARG A  25       2.781  -7.074  -4.274  1.00  0.00           H  
ATOM    356  HG3 ARG A  25       4.418  -6.803  -4.879  1.00  0.00           H  
ATOM    357  HD2 ARG A  25       3.050  -7.274  -6.763  1.00  0.00           H  
ATOM    358  HD3 ARG A  25       4.035  -8.706  -6.471  1.00  0.00           H  
ATOM    359  HE  ARG A  25       1.157  -8.448  -6.059  1.00  0.00           H  
ATOM    360 HH11 ARG A  25       4.044 -10.380  -5.819  1.00  0.00           H  
ATOM    361 HH12 ARG A  25       3.186 -11.874  -5.649  1.00  0.00           H  
ATOM    362 HH21 ARG A  25       0.016 -10.411  -5.838  1.00  0.00           H  
ATOM    363 HH22 ARG A  25       0.895 -11.892  -5.662  1.00  0.00           H  
ATOM    364  N   TRP A  26       6.633  -7.163  -5.320  1.00  0.00           N  
ATOM    365  CA  TRP A  26       7.392  -5.934  -5.527  1.00  0.00           C  
ATOM    366  C   TRP A  26       6.486  -4.712  -5.433  1.00  0.00           C  
ATOM    367  O   TRP A  26       5.598  -4.520  -6.264  1.00  0.00           O  
ATOM    368  CB  TRP A  26       8.088  -5.964  -6.890  1.00  0.00           C  
ATOM    369  CG  TRP A  26       9.097  -4.870  -7.065  1.00  0.00           C  
ATOM    370  CD1 TRP A  26       8.984  -3.575  -6.646  1.00  0.00           C  
ATOM    371  CD2 TRP A  26      10.373  -4.977  -7.707  1.00  0.00           C  
ATOM    372  NE1 TRP A  26      10.113  -2.870  -6.989  1.00  0.00           N  
ATOM    373  CE2 TRP A  26      10.979  -3.707  -7.641  1.00  0.00           C  
ATOM    374  CE3 TRP A  26      11.062  -6.021  -8.330  1.00  0.00           C  
ATOM    375  CZ2 TRP A  26      12.241  -3.456  -8.175  1.00  0.00           C  
ATOM    376  CZ3 TRP A  26      12.313  -5.770  -8.861  1.00  0.00           C  
ATOM    377  CH2 TRP A  26      12.892  -4.496  -8.780  1.00  0.00           C  
ATOM    378  H   TRP A  26       6.246  -7.622  -6.094  1.00  0.00           H  
ATOM    379  HA  TRP A  26       8.142  -5.874  -4.752  1.00  0.00           H  
ATOM    380  HB2 TRP A  26       8.597  -6.909  -7.006  1.00  0.00           H  
ATOM    381  HB3 TRP A  26       7.345  -5.861  -7.667  1.00  0.00           H  
ATOM    382  HD1 TRP A  26       8.127  -3.178  -6.125  1.00  0.00           H  
ATOM    383  HE1 TRP A  26      10.270  -1.922  -6.798  1.00  0.00           H  
ATOM    384  HE3 TRP A  26      10.632  -7.008  -8.403  1.00  0.00           H  
ATOM    385  HZ2 TRP A  26      12.700  -2.480  -8.120  1.00  0.00           H  
ATOM    386  HZ3 TRP A  26      12.861  -6.564  -9.347  1.00  0.00           H  
ATOM    387  HH2 TRP A  26      13.871  -4.346  -9.207  1.00  0.00           H  
ATOM    388  N   CYS A  27       6.716  -3.888  -4.416  1.00  0.00           N  
ATOM    389  CA  CYS A  27       5.919  -2.683  -4.213  1.00  0.00           C  
ATOM    390  C   CYS A  27       6.686  -1.443  -4.658  1.00  0.00           C  
ATOM    391  O   CYS A  27       7.807  -1.200  -4.213  1.00  0.00           O  
ATOM    392  CB  CYS A  27       5.523  -2.552  -2.742  1.00  0.00           C  
ATOM    393  SG  CYS A  27       3.951  -3.344  -2.327  1.00  0.00           S  
ATOM    394  H   CYS A  27       7.438  -4.095  -3.787  1.00  0.00           H  
ATOM    395  HA  CYS A  27       5.025  -2.774  -4.811  1.00  0.00           H  
ATOM    396  HB2 CYS A  27       6.288  -3.001  -2.128  1.00  0.00           H  
ATOM    397  HB3 CYS A  27       5.440  -1.504  -2.492  1.00  0.00           H  
ATOM    398  HG  CYS A  27       3.058  -2.391  -2.108  1.00  0.00           H  
ATOM    399  N   SER A  28       6.075  -0.661  -5.543  1.00  0.00           N  
ATOM    400  CA  SER A  28       6.702   0.552  -6.054  1.00  0.00           C  
ATOM    401  C   SER A  28       5.781   1.755  -5.879  1.00  0.00           C  
ATOM    402  O   SER A  28       4.699   1.814  -6.464  1.00  0.00           O  
ATOM    403  CB  SER A  28       7.063   0.382  -7.530  1.00  0.00           C  
ATOM    404  OG  SER A  28       8.194   1.163  -7.873  1.00  0.00           O  
ATOM    405  H   SER A  28       5.181  -0.909  -5.862  1.00  0.00           H  
ATOM    406  HA  SER A  28       7.607   0.721  -5.489  1.00  0.00           H  
ATOM    407  HB2 SER A  28       7.284  -0.657  -7.727  1.00  0.00           H  
ATOM    408  HB3 SER A  28       6.227   0.694  -8.141  1.00  0.00           H  
ATOM    409  HG  SER A  28       8.995   0.687  -7.638  1.00  0.00           H  
ATOM    410  N   VAL A  29       6.217   2.714  -5.069  1.00  0.00           N  
ATOM    411  CA  VAL A  29       5.434   3.918  -4.816  1.00  0.00           C  
ATOM    412  C   VAL A  29       5.879   5.062  -5.720  1.00  0.00           C  
ATOM    413  O   VAL A  29       7.073   5.342  -5.842  1.00  0.00           O  
ATOM    414  CB  VAL A  29       5.548   4.364  -3.346  1.00  0.00           C  
ATOM    415  CG1 VAL A  29       4.814   5.678  -3.129  1.00  0.00           C  
ATOM    416  CG2 VAL A  29       5.010   3.283  -2.420  1.00  0.00           C  
ATOM    417  H   VAL A  29       7.088   2.610  -4.632  1.00  0.00           H  
ATOM    418  HA  VAL A  29       4.398   3.691  -5.023  1.00  0.00           H  
ATOM    419  HB  VAL A  29       6.592   4.518  -3.118  1.00  0.00           H  
ATOM    420 HG11 VAL A  29       4.507   5.751  -2.096  1.00  0.00           H  
ATOM    421 HG12 VAL A  29       5.470   6.501  -3.371  1.00  0.00           H  
ATOM    422 HG13 VAL A  29       3.943   5.713  -3.765  1.00  0.00           H  
ATOM    423 HG21 VAL A  29       4.031   2.977  -2.755  1.00  0.00           H  
ATOM    424 HG22 VAL A  29       5.677   2.433  -2.433  1.00  0.00           H  
ATOM    425 HG23 VAL A  29       4.942   3.672  -1.415  1.00  0.00           H  
ATOM    426  N   ARG A  30       4.913   5.723  -6.348  1.00  0.00           N  
ATOM    427  CA  ARG A  30       5.205   6.838  -7.241  1.00  0.00           C  
ATOM    428  C   ARG A  30       3.945   7.648  -7.530  1.00  0.00           C  
ATOM    429  O   ARG A  30       2.868   7.088  -7.736  1.00  0.00           O  
ATOM    430  CB  ARG A  30       5.807   6.326  -8.551  1.00  0.00           C  
ATOM    431  CG  ARG A  30       6.001   7.412  -9.597  1.00  0.00           C  
ATOM    432  CD  ARG A  30       7.381   8.043  -9.496  1.00  0.00           C  
ATOM    433  NE  ARG A  30       7.507   9.223 -10.347  1.00  0.00           N  
ATOM    434  CZ  ARG A  30       7.138  10.442  -9.971  1.00  0.00           C  
ATOM    435  NH1 ARG A  30       6.624  10.640  -8.765  1.00  0.00           N  
ATOM    436  NH2 ARG A  30       7.284  11.467 -10.802  1.00  0.00           N  
ATOM    437  H   ARG A  30       3.981   5.453  -6.211  1.00  0.00           H  
ATOM    438  HA  ARG A  30       5.925   7.476  -6.750  1.00  0.00           H  
ATOM    439  HB2 ARG A  30       6.769   5.883  -8.343  1.00  0.00           H  
ATOM    440  HB3 ARG A  30       5.153   5.573  -8.963  1.00  0.00           H  
ATOM    441  HG2 ARG A  30       5.886   6.978 -10.579  1.00  0.00           H  
ATOM    442  HG3 ARG A  30       5.254   8.177  -9.451  1.00  0.00           H  
ATOM    443  HD2 ARG A  30       7.557   8.330  -8.471  1.00  0.00           H  
ATOM    444  HD3 ARG A  30       8.118   7.313  -9.799  1.00  0.00           H  
ATOM    445  HE  ARG A  30       7.884   9.099 -11.243  1.00  0.00           H  
ATOM    446 HH11 ARG A  30       6.514   9.871  -8.137  1.00  0.00           H  
ATOM    447 HH12 ARG A  30       6.348  11.560  -8.484  1.00  0.00           H  
ATOM    448 HH21 ARG A  30       7.672  11.321 -11.711  1.00  0.00           H  
ATOM    449 HH22 ARG A  30       7.006  12.384 -10.517  1.00  0.00           H  
ATOM    450  N   ASP A  31       4.087   8.969  -7.542  1.00  0.00           N  
ATOM    451  CA  ASP A  31       2.960   9.857  -7.807  1.00  0.00           C  
ATOM    452  C   ASP A  31       1.848   9.643  -6.784  1.00  0.00           C  
ATOM    453  O   ASP A  31       0.667   9.649  -7.127  1.00  0.00           O  
ATOM    454  CB  ASP A  31       2.421   9.625  -9.220  1.00  0.00           C  
ATOM    455  CG  ASP A  31       1.766  10.864  -9.799  1.00  0.00           C  
ATOM    456  OD1 ASP A  31       2.433  11.918  -9.852  1.00  0.00           O  
ATOM    457  OD2 ASP A  31       0.586  10.779 -10.199  1.00  0.00           O  
ATOM    458  H   ASP A  31       4.971   9.357  -7.372  1.00  0.00           H  
ATOM    459  HA  ASP A  31       3.313  10.874  -7.728  1.00  0.00           H  
ATOM    460  HB2 ASP A  31       3.238   9.336  -9.866  1.00  0.00           H  
ATOM    461  HB3 ASP A  31       1.690   8.831  -9.194  1.00  0.00           H  
ATOM    462  N   ASN A  32       2.237   9.452  -5.527  1.00  0.00           N  
ATOM    463  CA  ASN A  32       1.273   9.235  -4.455  1.00  0.00           C  
ATOM    464  C   ASN A  32       0.418   8.003  -4.733  1.00  0.00           C  
ATOM    465  O   ASN A  32      -0.786   7.998  -4.477  1.00  0.00           O  
ATOM    466  CB  ASN A  32       0.376  10.464  -4.289  1.00  0.00           C  
ATOM    467  CG  ASN A  32       1.140  11.671  -3.780  1.00  0.00           C  
ATOM    468  OD1 ASN A  32       1.361  12.634  -4.514  1.00  0.00           O  
ATOM    469  ND2 ASN A  32       1.546  11.624  -2.516  1.00  0.00           N  
ATOM    470  H   ASN A  32       3.194   9.458  -5.316  1.00  0.00           H  
ATOM    471  HA  ASN A  32       1.825   9.077  -3.540  1.00  0.00           H  
ATOM    472  HB2 ASN A  32      -0.059  10.715  -5.245  1.00  0.00           H  
ATOM    473  HB3 ASN A  32      -0.411  10.236  -3.587  1.00  0.00           H  
ATOM    474 HD21 ASN A  32       1.333  10.824  -1.990  1.00  0.00           H  
ATOM    475 HD22 ASN A  32       2.041  12.392  -2.161  1.00  0.00           H  
ATOM    476  N   HIS A  33       1.050   6.957  -5.258  1.00  0.00           N  
ATOM    477  CA  HIS A  33       0.347   5.717  -5.571  1.00  0.00           C  
ATOM    478  C   HIS A  33       1.277   4.515  -5.423  1.00  0.00           C  
ATOM    479  O   HIS A  33       2.423   4.546  -5.872  1.00  0.00           O  
ATOM    480  CB  HIS A  33      -0.218   5.770  -6.990  1.00  0.00           C  
ATOM    481  CG  HIS A  33      -1.494   6.545  -7.098  1.00  0.00           C  
ATOM    482  ND1 HIS A  33      -1.538   7.923  -7.132  1.00  0.00           N  
ATOM    483  CD2 HIS A  33      -2.779   6.127  -7.180  1.00  0.00           C  
ATOM    484  CE1 HIS A  33      -2.795   8.319  -7.231  1.00  0.00           C  
ATOM    485  NE2 HIS A  33      -3.568   7.249  -7.261  1.00  0.00           N  
ATOM    486  H   HIS A  33       2.010   7.022  -5.439  1.00  0.00           H  
ATOM    487  HA  HIS A  33      -0.467   5.613  -4.871  1.00  0.00           H  
ATOM    488  HB2 HIS A  33       0.508   6.234  -7.642  1.00  0.00           H  
ATOM    489  HB3 HIS A  33      -0.409   4.763  -7.331  1.00  0.00           H  
ATOM    490  HD1 HIS A  33      -0.764   8.521  -7.090  1.00  0.00           H  
ATOM    491  HD2 HIS A  33      -3.122   5.101  -7.181  1.00  0.00           H  
ATOM    492  HE1 HIS A  33      -3.133   9.343  -7.277  1.00  0.00           H  
ATOM    493  HE2 HIS A  33      -4.547   7.258  -7.244  1.00  0.00           H  
ATOM    494  N   LEU A  34       0.774   3.459  -4.794  1.00  0.00           N  
ATOM    495  CA  LEU A  34       1.559   2.247  -4.588  1.00  0.00           C  
ATOM    496  C   LEU A  34       1.214   1.191  -5.634  1.00  0.00           C  
ATOM    497  O   LEU A  34       0.168   0.547  -5.561  1.00  0.00           O  
ATOM    498  CB  LEU A  34       1.314   1.690  -3.185  1.00  0.00           C  
ATOM    499  CG  LEU A  34       1.604   0.200  -2.994  1.00  0.00           C  
ATOM    500  CD1 LEU A  34       3.025  -0.127  -3.427  1.00  0.00           C  
ATOM    501  CD2 LEU A  34       1.379  -0.205  -1.545  1.00  0.00           C  
ATOM    502  H   LEU A  34      -0.146   3.494  -4.459  1.00  0.00           H  
ATOM    503  HA  LEU A  34       2.602   2.506  -4.686  1.00  0.00           H  
ATOM    504  HB2 LEU A  34       1.939   2.238  -2.498  1.00  0.00           H  
ATOM    505  HB3 LEU A  34       0.275   1.859  -2.939  1.00  0.00           H  
ATOM    506  HG  LEU A  34       0.926  -0.374  -3.611  1.00  0.00           H  
ATOM    507 HD11 LEU A  34       3.031  -1.067  -3.958  1.00  0.00           H  
ATOM    508 HD12 LEU A  34       3.658  -0.201  -2.555  1.00  0.00           H  
ATOM    509 HD13 LEU A  34       3.393   0.656  -4.074  1.00  0.00           H  
ATOM    510 HD21 LEU A  34       0.367   0.039  -1.256  1.00  0.00           H  
ATOM    511 HD22 LEU A  34       2.072   0.328  -0.911  1.00  0.00           H  
ATOM    512 HD23 LEU A  34       1.537  -1.268  -1.440  1.00  0.00           H  
ATOM    513  N   HIS A  35       2.104   1.017  -6.607  1.00  0.00           N  
ATOM    514  CA  HIS A  35       1.897   0.036  -7.666  1.00  0.00           C  
ATOM    515  C   HIS A  35       2.450  -1.327  -7.262  1.00  0.00           C  
ATOM    516  O   HIS A  35       3.375  -1.418  -6.453  1.00  0.00           O  
ATOM    517  CB  HIS A  35       2.560   0.506  -8.961  1.00  0.00           C  
ATOM    518  CG  HIS A  35       1.933   1.734  -9.545  1.00  0.00           C  
ATOM    519  ND1 HIS A  35       1.161   1.713 -10.687  1.00  0.00           N  
ATOM    520  CD2 HIS A  35       1.965   3.024  -9.138  1.00  0.00           C  
ATOM    521  CE1 HIS A  35       0.747   2.939 -10.958  1.00  0.00           C  
ATOM    522  NE2 HIS A  35       1.221   3.752 -10.031  1.00  0.00           N  
ATOM    523  H   HIS A  35       2.920   1.559  -6.611  1.00  0.00           H  
ATOM    524  HA  HIS A  35       0.834  -0.055  -7.830  1.00  0.00           H  
ATOM    525  HB2 HIS A  35       3.599   0.725  -8.766  1.00  0.00           H  
ATOM    526  HB3 HIS A  35       2.496  -0.283  -9.697  1.00  0.00           H  
ATOM    527  HD1 HIS A  35       0.950   0.920 -11.222  1.00  0.00           H  
ATOM    528  HD2 HIS A  35       2.481   3.409  -8.268  1.00  0.00           H  
ATOM    529  HE1 HIS A  35       0.126   3.226 -11.793  1.00  0.00           H  
ATOM    530  HE2 HIS A  35       1.136   4.729 -10.041  1.00  0.00           H  
ATOM    531  N   PHE A  36       1.878  -2.384  -7.828  1.00  0.00           N  
ATOM    532  CA  PHE A  36       2.312  -3.742  -7.525  1.00  0.00           C  
ATOM    533  C   PHE A  36       2.890  -4.418  -8.765  1.00  0.00           C  
ATOM    534  O   PHE A  36       2.304  -4.360  -9.847  1.00  0.00           O  
ATOM    535  CB  PHE A  36       1.143  -4.565  -6.980  1.00  0.00           C  
ATOM    536  CG  PHE A  36       0.665  -4.108  -5.632  1.00  0.00           C  
ATOM    537  CD1 PHE A  36       0.115  -2.848  -5.468  1.00  0.00           C  
ATOM    538  CD2 PHE A  36       0.766  -4.940  -4.528  1.00  0.00           C  
ATOM    539  CE1 PHE A  36      -0.326  -2.424  -4.228  1.00  0.00           C  
ATOM    540  CE2 PHE A  36       0.327  -4.523  -3.286  1.00  0.00           C  
ATOM    541  CZ  PHE A  36      -0.218  -3.262  -3.135  1.00  0.00           C  
ATOM    542  H   PHE A  36       1.145  -2.247  -8.464  1.00  0.00           H  
ATOM    543  HA  PHE A  36       3.082  -3.683  -6.771  1.00  0.00           H  
ATOM    544  HB2 PHE A  36       0.312  -4.496  -7.667  1.00  0.00           H  
ATOM    545  HB3 PHE A  36       1.448  -5.597  -6.895  1.00  0.00           H  
ATOM    546  HD1 PHE A  36       0.031  -2.191  -6.322  1.00  0.00           H  
ATOM    547  HD2 PHE A  36       1.195  -5.925  -4.644  1.00  0.00           H  
ATOM    548  HE1 PHE A  36      -0.752  -1.439  -4.114  1.00  0.00           H  
ATOM    549  HE2 PHE A  36       0.413  -5.180  -2.433  1.00  0.00           H  
ATOM    550  HZ  PHE A  36      -0.563  -2.934  -2.167  1.00  0.00           H  
ATOM    551  N   TYR A  37       4.043  -5.058  -8.601  1.00  0.00           N  
ATOM    552  CA  TYR A  37       4.702  -5.741  -9.706  1.00  0.00           C  
ATOM    553  C   TYR A  37       5.096  -7.161  -9.312  1.00  0.00           C  
ATOM    554  O   TYR A  37       5.089  -7.514  -8.132  1.00  0.00           O  
ATOM    555  CB  TYR A  37       5.941  -4.962 -10.150  1.00  0.00           C  
ATOM    556  CG  TYR A  37       5.637  -3.554 -10.611  1.00  0.00           C  
ATOM    557  CD1 TYR A  37       5.510  -2.515  -9.698  1.00  0.00           C  
ATOM    558  CD2 TYR A  37       5.481  -3.263 -11.960  1.00  0.00           C  
ATOM    559  CE1 TYR A  37       5.232  -1.228 -10.114  1.00  0.00           C  
ATOM    560  CE2 TYR A  37       5.204  -1.978 -12.386  1.00  0.00           C  
ATOM    561  CZ  TYR A  37       5.080  -0.964 -11.459  1.00  0.00           C  
ATOM    562  OH  TYR A  37       4.805   0.317 -11.879  1.00  0.00           O  
ATOM    563  H   TYR A  37       4.461  -5.069  -7.715  1.00  0.00           H  
ATOM    564  HA  TYR A  37       4.005  -5.790 -10.530  1.00  0.00           H  
ATOM    565  HB2 TYR A  37       6.632  -4.898  -9.324  1.00  0.00           H  
ATOM    566  HB3 TYR A  37       6.413  -5.485 -10.969  1.00  0.00           H  
ATOM    567  HD1 TYR A  37       5.629  -2.726  -8.644  1.00  0.00           H  
ATOM    568  HD2 TYR A  37       5.579  -4.059 -12.685  1.00  0.00           H  
ATOM    569  HE1 TYR A  37       5.135  -0.434  -9.389  1.00  0.00           H  
ATOM    570  HE2 TYR A  37       5.085  -1.772 -13.440  1.00  0.00           H  
ATOM    571  HH  TYR A  37       5.330   0.519 -12.656  1.00  0.00           H  
ATOM    572  N   GLN A  38       5.438  -7.973 -10.308  1.00  0.00           N  
ATOM    573  CA  GLN A  38       5.834  -9.355 -10.065  1.00  0.00           C  
ATOM    574  C   GLN A  38       7.262  -9.603 -10.542  1.00  0.00           C  
ATOM    575  O   GLN A  38       8.157  -9.869  -9.739  1.00  0.00           O  
ATOM    576  CB  GLN A  38       4.874 -10.314 -10.771  1.00  0.00           C  
ATOM    577  CG  GLN A  38       3.410 -10.041 -10.468  1.00  0.00           C  
ATOM    578  CD  GLN A  38       2.923 -10.777  -9.234  1.00  0.00           C  
ATOM    579  OE1 GLN A  38       3.720 -11.228  -8.410  1.00  0.00           O  
ATOM    580  NE2 GLN A  38       1.608 -10.901  -9.099  1.00  0.00           N  
ATOM    581  H   GLN A  38       5.423  -7.634 -11.226  1.00  0.00           H  
ATOM    582  HA  GLN A  38       5.788  -9.531  -9.001  1.00  0.00           H  
ATOM    583  HB2 GLN A  38       5.021 -10.231 -11.837  1.00  0.00           H  
ATOM    584  HB3 GLN A  38       5.101 -11.324 -10.461  1.00  0.00           H  
ATOM    585  HG2 GLN A  38       3.279  -8.981 -10.310  1.00  0.00           H  
ATOM    586  HG3 GLN A  38       2.816 -10.355 -11.313  1.00  0.00           H  
ATOM    587 HE21 GLN A  38       1.034 -10.517  -9.795  1.00  0.00           H  
ATOM    588 HE22 GLN A  38       1.265 -11.371  -8.311  1.00  0.00           H  
ATOM    589  N   ASP A  39       7.466  -9.515 -11.852  1.00  0.00           N  
ATOM    590  CA  ASP A  39       8.786  -9.731 -12.435  1.00  0.00           C  
ATOM    591  C   ASP A  39       9.715  -8.562 -12.122  1.00  0.00           C  
ATOM    592  O   ASP A  39       9.304  -7.576 -11.508  1.00  0.00           O  
ATOM    593  CB  ASP A  39       8.672  -9.917 -13.949  1.00  0.00           C  
ATOM    594  CG  ASP A  39       7.946 -11.194 -14.322  1.00  0.00           C  
ATOM    595  OD1 ASP A  39       6.716 -11.257 -14.119  1.00  0.00           O  
ATOM    596  OD2 ASP A  39       8.608 -12.132 -14.816  1.00  0.00           O  
ATOM    597  H   ASP A  39       6.712  -9.300 -12.439  1.00  0.00           H  
ATOM    598  HA  ASP A  39       9.199 -10.628 -12.001  1.00  0.00           H  
ATOM    599  HB2 ASP A  39       8.132  -9.082 -14.369  1.00  0.00           H  
ATOM    600  HB3 ASP A  39       9.664  -9.950 -14.375  1.00  0.00           H  
ATOM    601  N   ARG A  40      10.968  -8.678 -12.548  1.00  0.00           N  
ATOM    602  CA  ARG A  40      11.957  -7.633 -12.311  1.00  0.00           C  
ATOM    603  C   ARG A  40      11.846  -6.533 -13.362  1.00  0.00           C  
ATOM    604  O   ARG A  40      11.327  -6.755 -14.455  1.00  0.00           O  
ATOM    605  CB  ARG A  40      13.368  -8.224 -12.322  1.00  0.00           C  
ATOM    606  CG  ARG A  40      13.751  -8.907 -11.019  1.00  0.00           C  
ATOM    607  CD  ARG A  40      13.059 -10.253 -10.871  1.00  0.00           C  
ATOM    608  NE  ARG A  40      13.754 -11.310 -11.600  1.00  0.00           N  
ATOM    609  CZ  ARG A  40      13.652 -12.600 -11.299  1.00  0.00           C  
ATOM    610  NH1 ARG A  40      12.887 -12.990 -10.289  1.00  0.00           N  
ATOM    611  NH2 ARG A  40      14.317 -13.503 -12.009  1.00  0.00           N  
ATOM    612  H   ARG A  40      11.236  -9.488 -13.031  1.00  0.00           H  
ATOM    613  HA  ARG A  40      11.762  -7.207 -11.339  1.00  0.00           H  
ATOM    614  HB2 ARG A  40      13.436  -8.951 -13.118  1.00  0.00           H  
ATOM    615  HB3 ARG A  40      14.075  -7.430 -12.508  1.00  0.00           H  
ATOM    616  HG2 ARG A  40      14.820  -9.063 -11.006  1.00  0.00           H  
ATOM    617  HG3 ARG A  40      13.468  -8.273 -10.193  1.00  0.00           H  
ATOM    618  HD2 ARG A  40      13.025 -10.512  -9.823  1.00  0.00           H  
ATOM    619  HD3 ARG A  40      12.052 -10.168 -11.254  1.00  0.00           H  
ATOM    620  HE  ARG A  40      14.326 -11.044 -12.351  1.00  0.00           H  
ATOM    621 HH11 ARG A  40      12.384 -12.312  -9.753  1.00  0.00           H  
ATOM    622 HH12 ARG A  40      12.811 -13.961 -10.065  1.00  0.00           H  
ATOM    623 HH21 ARG A  40      14.895 -13.212 -12.771  1.00  0.00           H  
ATOM    624 HH22 ARG A  40      14.240 -14.473 -11.782  1.00  0.00           H  
ATOM    625  N   ASN A  41      12.338  -5.346 -13.024  1.00  0.00           N  
ATOM    626  CA  ASN A  41      12.294  -4.211 -13.937  1.00  0.00           C  
ATOM    627  C   ASN A  41      10.853  -3.831 -14.265  1.00  0.00           C  
ATOM    628  O   ASN A  41      10.520  -3.554 -15.417  1.00  0.00           O  
ATOM    629  CB  ASN A  41      13.052  -4.536 -15.226  1.00  0.00           C  
ATOM    630  CG  ASN A  41      14.543  -4.285 -15.099  1.00  0.00           C  
ATOM    631  OD1 ASN A  41      15.127  -4.476 -14.033  1.00  0.00           O  
ATOM    632  ND2 ASN A  41      15.164  -3.853 -16.190  1.00  0.00           N  
ATOM    633  H   ASN A  41      12.740  -5.230 -12.137  1.00  0.00           H  
ATOM    634  HA  ASN A  41      12.773  -3.374 -13.451  1.00  0.00           H  
ATOM    635  HB2 ASN A  41      12.903  -5.578 -15.471  1.00  0.00           H  
ATOM    636  HB3 ASN A  41      12.669  -3.923 -16.028  1.00  0.00           H  
ATOM    637 HD21 ASN A  41      14.634  -3.723 -17.004  1.00  0.00           H  
ATOM    638 HD22 ASN A  41      16.128  -3.682 -16.136  1.00  0.00           H  
ATOM    639  N   ARG A  42      10.003  -3.820 -13.243  1.00  0.00           N  
ATOM    640  CA  ARG A  42       8.598  -3.476 -13.421  1.00  0.00           C  
ATOM    641  C   ARG A  42       8.081  -3.980 -14.766  1.00  0.00           C  
ATOM    642  O   ARG A  42       7.387  -3.262 -15.484  1.00  0.00           O  
ATOM    643  CB  ARG A  42       8.406  -1.961 -13.324  1.00  0.00           C  
ATOM    644  CG  ARG A  42       8.490  -1.427 -11.904  1.00  0.00           C  
ATOM    645  CD  ARG A  42       8.142   0.053 -11.845  1.00  0.00           C  
ATOM    646  NE  ARG A  42       9.271   0.897 -12.226  1.00  0.00           N  
ATOM    647  CZ  ARG A  42       9.183   2.211 -12.394  1.00  0.00           C  
ATOM    648  NH1 ARG A  42       8.024   2.829 -12.216  1.00  0.00           N  
ATOM    649  NH2 ARG A  42      10.256   2.911 -12.740  1.00  0.00           N  
ATOM    650  H   ARG A  42      10.329  -4.051 -12.348  1.00  0.00           H  
ATOM    651  HA  ARG A  42       8.037  -3.952 -12.632  1.00  0.00           H  
ATOM    652  HB2 ARG A  42       9.168  -1.475 -13.915  1.00  0.00           H  
ATOM    653  HB3 ARG A  42       7.435  -1.708 -13.725  1.00  0.00           H  
ATOM    654  HG2 ARG A  42       7.796  -1.973 -11.282  1.00  0.00           H  
ATOM    655  HG3 ARG A  42       9.495  -1.566 -11.537  1.00  0.00           H  
ATOM    656  HD2 ARG A  42       7.320   0.243 -12.519  1.00  0.00           H  
ATOM    657  HD3 ARG A  42       7.844   0.299 -10.837  1.00  0.00           H  
ATOM    658  HE  ARG A  42      10.137   0.460 -12.363  1.00  0.00           H  
ATOM    659 HH11 ARG A  42       7.214   2.305 -11.953  1.00  0.00           H  
ATOM    660 HH12 ARG A  42       7.960   3.819 -12.341  1.00  0.00           H  
ATOM    661 HH21 ARG A  42      11.132   2.448 -12.876  1.00  0.00           H  
ATOM    662 HH22 ARG A  42      10.189   3.900 -12.867  1.00  0.00           H  
ATOM    663  N   SER A  43       8.425  -5.221 -15.098  1.00  0.00           N  
ATOM    664  CA  SER A  43       7.999  -5.820 -16.357  1.00  0.00           C  
ATOM    665  C   SER A  43       6.480  -5.773 -16.496  1.00  0.00           C  
ATOM    666  O   SER A  43       5.947  -5.137 -17.405  1.00  0.00           O  
ATOM    667  CB  SER A  43       8.487  -7.268 -16.449  1.00  0.00           C  
ATOM    668  OG  SER A  43       8.646  -7.668 -17.799  1.00  0.00           O  
ATOM    669  H   SER A  43       8.980  -5.744 -14.482  1.00  0.00           H  
ATOM    670  HA  SER A  43       8.440  -5.249 -17.161  1.00  0.00           H  
ATOM    671  HB2 SER A  43       9.437  -7.357 -15.944  1.00  0.00           H  
ATOM    672  HB3 SER A  43       7.765  -7.917 -15.975  1.00  0.00           H  
ATOM    673  HG  SER A  43       8.409  -6.941 -18.379  1.00  0.00           H  
ATOM    674  N   LYS A  44       5.788  -6.451 -15.587  1.00  0.00           N  
ATOM    675  CA  LYS A  44       4.331  -6.488 -15.605  1.00  0.00           C  
ATOM    676  C   LYS A  44       3.760  -6.065 -14.254  1.00  0.00           C  
ATOM    677  O   LYS A  44       4.389  -6.261 -13.215  1.00  0.00           O  
ATOM    678  CB  LYS A  44       3.840  -7.894 -15.960  1.00  0.00           C  
ATOM    679  CG  LYS A  44       3.710  -8.133 -17.455  1.00  0.00           C  
ATOM    680  CD  LYS A  44       5.025  -8.594 -18.061  1.00  0.00           C  
ATOM    681  CE  LYS A  44       5.309 -10.051 -17.733  1.00  0.00           C  
ATOM    682  NZ  LYS A  44       6.614 -10.501 -18.290  1.00  0.00           N  
ATOM    683  H   LYS A  44       6.271  -6.940 -14.886  1.00  0.00           H  
ATOM    684  HA  LYS A  44       3.991  -5.795 -16.359  1.00  0.00           H  
ATOM    685  HB2 LYS A  44       4.535  -8.617 -15.560  1.00  0.00           H  
ATOM    686  HB3 LYS A  44       2.871  -8.048 -15.506  1.00  0.00           H  
ATOM    687  HG2 LYS A  44       2.961  -8.892 -17.624  1.00  0.00           H  
ATOM    688  HG3 LYS A  44       3.407  -7.212 -17.932  1.00  0.00           H  
ATOM    689  HD2 LYS A  44       4.975  -8.482 -19.134  1.00  0.00           H  
ATOM    690  HD3 LYS A  44       5.825  -7.983 -17.670  1.00  0.00           H  
ATOM    691  HE2 LYS A  44       5.325 -10.169 -16.660  1.00  0.00           H  
ATOM    692  HE3 LYS A  44       4.520 -10.661 -18.149  1.00  0.00           H  
ATOM    693  HZ1 LYS A  44       6.468 -11.297 -18.944  1.00  0.00           H  
ATOM    694  HZ2 LYS A  44       7.243 -10.811 -17.521  1.00  0.00           H  
ATOM    695  HZ3 LYS A  44       7.070  -9.722 -18.805  1.00  0.00           H  
ATOM    696  N   VAL A  45       2.564  -5.486 -14.279  1.00  0.00           N  
ATOM    697  CA  VAL A  45       1.907  -5.037 -13.056  1.00  0.00           C  
ATOM    698  C   VAL A  45       1.105  -6.165 -12.419  1.00  0.00           C  
ATOM    699  O   VAL A  45       0.240  -6.763 -13.057  1.00  0.00           O  
ATOM    700  CB  VAL A  45       0.970  -3.845 -13.328  1.00  0.00           C  
ATOM    701  CG1 VAL A  45       0.239  -3.441 -12.057  1.00  0.00           C  
ATOM    702  CG2 VAL A  45       1.753  -2.672 -13.899  1.00  0.00           C  
ATOM    703  H   VAL A  45       2.113  -5.357 -15.139  1.00  0.00           H  
ATOM    704  HA  VAL A  45       2.672  -4.715 -12.365  1.00  0.00           H  
ATOM    705  HB  VAL A  45       0.235  -4.150 -14.058  1.00  0.00           H  
ATOM    706 HG11 VAL A  45       0.481  -4.136 -11.267  1.00  0.00           H  
ATOM    707 HG12 VAL A  45       0.541  -2.445 -11.769  1.00  0.00           H  
ATOM    708 HG13 VAL A  45      -0.827  -3.456 -12.235  1.00  0.00           H  
ATOM    709 HG21 VAL A  45       1.242  -1.750 -13.661  1.00  0.00           H  
ATOM    710 HG22 VAL A  45       2.743  -2.655 -13.468  1.00  0.00           H  
ATOM    711 HG23 VAL A  45       1.828  -2.776 -14.971  1.00  0.00           H  
ATOM    712  N   ALA A  46       1.398  -6.450 -11.154  1.00  0.00           N  
ATOM    713  CA  ALA A  46       0.703  -7.505 -10.427  1.00  0.00           C  
ATOM    714  C   ALA A  46      -0.805  -7.270 -10.427  1.00  0.00           C  
ATOM    715  O   ALA A  46      -1.584  -8.191 -10.664  1.00  0.00           O  
ATOM    716  CB  ALA A  46       1.224  -7.597  -9.001  1.00  0.00           C  
ATOM    717  H   ALA A  46       2.098  -5.938 -10.699  1.00  0.00           H  
ATOM    718  HA  ALA A  46       0.910  -8.444 -10.922  1.00  0.00           H  
ATOM    719  HB1 ALA A  46       1.953  -8.392  -8.935  1.00  0.00           H  
ATOM    720  HB2 ALA A  46       1.687  -6.661  -8.727  1.00  0.00           H  
ATOM    721  HB3 ALA A  46       0.404  -7.803  -8.331  1.00  0.00           H  
ATOM    722  N   GLN A  47      -1.205  -6.031 -10.160  1.00  0.00           N  
ATOM    723  CA  GLN A  47      -2.619  -5.677 -10.128  1.00  0.00           C  
ATOM    724  C   GLN A  47      -2.799  -4.172  -9.958  1.00  0.00           C  
ATOM    725  O   GLN A  47      -1.856  -3.460  -9.612  1.00  0.00           O  
ATOM    726  CB  GLN A  47      -3.326  -6.419  -8.992  1.00  0.00           C  
ATOM    727  CG  GLN A  47      -2.629  -6.284  -7.649  1.00  0.00           C  
ATOM    728  CD  GLN A  47      -3.298  -7.098  -6.559  1.00  0.00           C  
ATOM    729  OE1 GLN A  47      -3.952  -8.105  -6.833  1.00  0.00           O  
ATOM    730  NE2 GLN A  47      -3.137  -6.665  -5.314  1.00  0.00           N  
ATOM    731  H   GLN A  47      -0.535  -5.341  -9.979  1.00  0.00           H  
ATOM    732  HA  GLN A  47      -3.056  -5.975 -11.068  1.00  0.00           H  
ATOM    733  HB2 GLN A  47      -4.329  -6.029  -8.894  1.00  0.00           H  
ATOM    734  HB3 GLN A  47      -3.380  -7.469  -9.242  1.00  0.00           H  
ATOM    735  HG2 GLN A  47      -1.608  -6.620  -7.752  1.00  0.00           H  
ATOM    736  HG3 GLN A  47      -2.635  -5.244  -7.357  1.00  0.00           H  
ATOM    737 HE21 GLN A  47      -2.604  -5.855  -5.171  1.00  0.00           H  
ATOM    738 HE22 GLN A  47      -3.560  -7.171  -4.591  1.00  0.00           H  
ATOM    739  N   GLN A  48      -4.016  -3.695 -10.204  1.00  0.00           N  
ATOM    740  CA  GLN A  48      -4.318  -2.274 -10.078  1.00  0.00           C  
ATOM    741  C   GLN A  48      -3.503  -1.641  -8.955  1.00  0.00           C  
ATOM    742  O   GLN A  48      -3.315  -2.224  -7.886  1.00  0.00           O  
ATOM    743  CB  GLN A  48      -5.811  -2.071  -9.819  1.00  0.00           C  
ATOM    744  CG  GLN A  48      -6.310  -0.684 -10.196  1.00  0.00           C  
ATOM    745  CD  GLN A  48      -7.814  -0.546 -10.050  1.00  0.00           C  
ATOM    746  OE1 GLN A  48      -8.437  -1.243  -9.251  1.00  0.00           O  
ATOM    747  NE2 GLN A  48      -8.403   0.358 -10.824  1.00  0.00           N  
ATOM    748  H   GLN A  48      -4.725  -4.313 -10.475  1.00  0.00           H  
ATOM    749  HA  GLN A  48      -4.055  -1.797 -11.009  1.00  0.00           H  
ATOM    750  HB2 GLN A  48      -6.367  -2.797 -10.391  1.00  0.00           H  
ATOM    751  HB3 GLN A  48      -6.006  -2.225  -8.767  1.00  0.00           H  
ATOM    752  HG2 GLN A  48      -5.833   0.043  -9.557  1.00  0.00           H  
ATOM    753  HG3 GLN A  48      -6.043  -0.488 -11.224  1.00  0.00           H  
ATOM    754 HE21 GLN A  48      -7.842   0.876 -11.439  1.00  0.00           H  
ATOM    755 HE22 GLN A  48      -9.373   0.468 -10.750  1.00  0.00           H  
ATOM    756  N   PRO A  49      -3.007  -0.420  -9.199  1.00  0.00           N  
ATOM    757  CA  PRO A  49      -2.205   0.320  -8.220  1.00  0.00           C  
ATOM    758  C   PRO A  49      -3.031   0.787  -7.028  1.00  0.00           C  
ATOM    759  O   PRO A  49      -4.249   0.609  -6.995  1.00  0.00           O  
ATOM    760  CB  PRO A  49      -1.689   1.521  -9.017  1.00  0.00           C  
ATOM    761  CG  PRO A  49      -2.690   1.710 -10.105  1.00  0.00           C  
ATOM    762  CD  PRO A  49      -3.191   0.335 -10.450  1.00  0.00           C  
ATOM    763  HA  PRO A  49      -1.367  -0.267  -7.869  1.00  0.00           H  
ATOM    764  HB2 PRO A  49      -1.635   2.387  -8.373  1.00  0.00           H  
ATOM    765  HB3 PRO A  49      -0.710   1.300  -9.416  1.00  0.00           H  
ATOM    766  HG2 PRO A  49      -3.501   2.328  -9.754  1.00  0.00           H  
ATOM    767  HG3 PRO A  49      -2.215   2.163 -10.964  1.00  0.00           H  
ATOM    768  HD2 PRO A  49      -4.234   0.373 -10.728  1.00  0.00           H  
ATOM    769  HD3 PRO A  49      -2.602  -0.093 -11.248  1.00  0.00           H  
ATOM    770  N   LEU A  50      -2.362   1.386  -6.048  1.00  0.00           N  
ATOM    771  CA  LEU A  50      -3.036   1.881  -4.853  1.00  0.00           C  
ATOM    772  C   LEU A  50      -2.979   3.403  -4.786  1.00  0.00           C  
ATOM    773  O   LEU A  50      -1.956   4.011  -5.102  1.00  0.00           O  
ATOM    774  CB  LEU A  50      -2.398   1.280  -3.599  1.00  0.00           C  
ATOM    775  CG  LEU A  50      -3.003  -0.035  -3.103  1.00  0.00           C  
ATOM    776  CD1 LEU A  50      -2.339  -0.472  -1.806  1.00  0.00           C  
ATOM    777  CD2 LEU A  50      -4.506   0.107  -2.914  1.00  0.00           C  
ATOM    778  H   LEU A  50      -1.393   1.500  -6.130  1.00  0.00           H  
ATOM    779  HA  LEU A  50      -4.070   1.573  -4.904  1.00  0.00           H  
ATOM    780  HB2 LEU A  50      -1.354   1.104  -3.810  1.00  0.00           H  
ATOM    781  HB3 LEU A  50      -2.486   2.006  -2.804  1.00  0.00           H  
ATOM    782  HG  LEU A  50      -2.829  -0.804  -3.842  1.00  0.00           H  
ATOM    783 HD11 LEU A  50      -1.608   0.265  -1.511  1.00  0.00           H  
ATOM    784 HD12 LEU A  50      -1.852  -1.424  -1.954  1.00  0.00           H  
ATOM    785 HD13 LEU A  50      -3.088  -0.566  -1.033  1.00  0.00           H  
ATOM    786 HD21 LEU A  50      -4.718   1.029  -2.392  1.00  0.00           H  
ATOM    787 HD22 LEU A  50      -4.875  -0.727  -2.335  1.00  0.00           H  
ATOM    788 HD23 LEU A  50      -4.990   0.121  -3.879  1.00  0.00           H  
ATOM    789  N   SER A  51      -4.084   4.014  -4.370  1.00  0.00           N  
ATOM    790  CA  SER A  51      -4.160   5.466  -4.263  1.00  0.00           C  
ATOM    791  C   SER A  51      -3.849   5.923  -2.840  1.00  0.00           C  
ATOM    792  O   SER A  51      -4.715   6.451  -2.141  1.00  0.00           O  
ATOM    793  CB  SER A  51      -5.549   5.957  -4.675  1.00  0.00           C  
ATOM    794  OG  SER A  51      -6.547   5.456  -3.803  1.00  0.00           O  
ATOM    795  H   SER A  51      -4.867   3.475  -4.132  1.00  0.00           H  
ATOM    796  HA  SER A  51      -3.425   5.887  -4.932  1.00  0.00           H  
ATOM    797  HB2 SER A  51      -5.572   7.036  -4.645  1.00  0.00           H  
ATOM    798  HB3 SER A  51      -5.764   5.621  -5.680  1.00  0.00           H  
ATOM    799  HG  SER A  51      -6.199   4.706  -3.315  1.00  0.00           H  
ATOM    800  N   LEU A  52      -2.606   5.717  -2.419  1.00  0.00           N  
ATOM    801  CA  LEU A  52      -2.178   6.108  -1.080  1.00  0.00           C  
ATOM    802  C   LEU A  52      -2.745   7.473  -0.703  1.00  0.00           C  
ATOM    803  O   LEU A  52      -3.203   7.678   0.420  1.00  0.00           O  
ATOM    804  CB  LEU A  52      -0.651   6.137  -1.000  1.00  0.00           C  
ATOM    805  CG  LEU A  52       0.070   4.869  -1.457  1.00  0.00           C  
ATOM    806  CD1 LEU A  52       1.577   5.068  -1.424  1.00  0.00           C  
ATOM    807  CD2 LEU A  52      -0.333   3.684  -0.590  1.00  0.00           C  
ATOM    808  H   LEU A  52      -1.961   5.293  -3.021  1.00  0.00           H  
ATOM    809  HA  LEU A  52      -2.553   5.371  -0.384  1.00  0.00           H  
ATOM    810  HB2 LEU A  52      -0.303   6.954  -1.613  1.00  0.00           H  
ATOM    811  HB3 LEU A  52      -0.378   6.320   0.030  1.00  0.00           H  
ATOM    812  HG  LEU A  52      -0.215   4.649  -2.478  1.00  0.00           H  
ATOM    813 HD11 LEU A  52       1.858   5.805  -2.162  1.00  0.00           H  
ATOM    814 HD12 LEU A  52       2.069   4.133  -1.644  1.00  0.00           H  
ATOM    815 HD13 LEU A  52       1.873   5.408  -0.442  1.00  0.00           H  
ATOM    816 HD21 LEU A  52      -1.206   3.943  -0.011  1.00  0.00           H  
ATOM    817 HD22 LEU A  52       0.480   3.435   0.078  1.00  0.00           H  
ATOM    818 HD23 LEU A  52      -0.555   2.836  -1.220  1.00  0.00           H  
ATOM    819  N   VAL A  53      -2.712   8.404  -1.652  1.00  0.00           N  
ATOM    820  CA  VAL A  53      -3.225   9.749  -1.420  1.00  0.00           C  
ATOM    821  C   VAL A  53      -4.559   9.709  -0.686  1.00  0.00           C  
ATOM    822  O   VAL A  53      -5.609   9.502  -1.293  1.00  0.00           O  
ATOM    823  CB  VAL A  53      -3.402  10.517  -2.745  1.00  0.00           C  
ATOM    824  CG1 VAL A  53      -4.247   9.711  -3.720  1.00  0.00           C  
ATOM    825  CG2 VAL A  53      -4.024  11.881  -2.489  1.00  0.00           C  
ATOM    826  H   VAL A  53      -2.334   8.180  -2.528  1.00  0.00           H  
ATOM    827  HA  VAL A  53      -2.506  10.281  -0.815  1.00  0.00           H  
ATOM    828  HB  VAL A  53      -2.427  10.665  -3.184  1.00  0.00           H  
ATOM    829 HG11 VAL A  53      -5.018  10.343  -4.134  1.00  0.00           H  
ATOM    830 HG12 VAL A  53      -3.620   9.337  -4.516  1.00  0.00           H  
ATOM    831 HG13 VAL A  53      -4.703   8.882  -3.200  1.00  0.00           H  
ATOM    832 HG21 VAL A  53      -4.806  11.787  -1.751  1.00  0.00           H  
ATOM    833 HG22 VAL A  53      -3.266  12.560  -2.125  1.00  0.00           H  
ATOM    834 HG23 VAL A  53      -4.439  12.266  -3.408  1.00  0.00           H  
ATOM    835  N   GLY A  54      -4.511   9.911   0.628  1.00  0.00           N  
ATOM    836  CA  GLY A  54      -5.724   9.895   1.425  1.00  0.00           C  
ATOM    837  C   GLY A  54      -5.745   8.756   2.425  1.00  0.00           C  
ATOM    838  O   GLY A  54      -6.176   8.931   3.567  1.00  0.00           O  
ATOM    839  H   GLY A  54      -3.647  10.072   1.059  1.00  0.00           H  
ATOM    840  HA2 GLY A  54      -5.804  10.831   1.958  1.00  0.00           H  
ATOM    841  HA3 GLY A  54      -6.574   9.794   0.766  1.00  0.00           H  
ATOM    842  N   CYS A  55      -5.280   7.588   1.999  1.00  0.00           N  
ATOM    843  CA  CYS A  55      -5.250   6.414   2.866  1.00  0.00           C  
ATOM    844  C   CYS A  55      -4.538   6.727   4.178  1.00  0.00           C  
ATOM    845  O   CYS A  55      -4.071   7.845   4.390  1.00  0.00           O  
ATOM    846  CB  CYS A  55      -4.554   5.250   2.159  1.00  0.00           C  
ATOM    847  SG  CYS A  55      -5.008   5.065   0.418  1.00  0.00           S  
ATOM    848  H   CYS A  55      -4.950   7.510   1.079  1.00  0.00           H  
ATOM    849  HA  CYS A  55      -6.270   6.135   3.080  1.00  0.00           H  
ATOM    850  HB2 CYS A  55      -3.484   5.399   2.204  1.00  0.00           H  
ATOM    851  HB3 CYS A  55      -4.804   4.330   2.665  1.00  0.00           H  
ATOM    852  HG  CYS A  55      -4.640   6.165  -0.219  1.00  0.00           H  
ATOM    853  N   GLU A  56      -4.463   5.731   5.056  1.00  0.00           N  
ATOM    854  CA  GLU A  56      -3.811   5.901   6.349  1.00  0.00           C  
ATOM    855  C   GLU A  56      -2.962   4.682   6.695  1.00  0.00           C  
ATOM    856  O   GLU A  56      -3.474   3.570   6.820  1.00  0.00           O  
ATOM    857  CB  GLU A  56      -4.854   6.137   7.444  1.00  0.00           C  
ATOM    858  CG  GLU A  56      -4.280   6.099   8.849  1.00  0.00           C  
ATOM    859  CD  GLU A  56      -5.339   6.286   9.918  1.00  0.00           C  
ATOM    860  OE1 GLU A  56      -6.145   7.233   9.794  1.00  0.00           O  
ATOM    861  OE2 GLU A  56      -5.362   5.488  10.879  1.00  0.00           O  
ATOM    862  H   GLU A  56      -4.855   4.862   4.828  1.00  0.00           H  
ATOM    863  HA  GLU A  56      -3.169   6.767   6.285  1.00  0.00           H  
ATOM    864  HB2 GLU A  56      -5.309   7.103   7.289  1.00  0.00           H  
ATOM    865  HB3 GLU A  56      -5.616   5.375   7.368  1.00  0.00           H  
ATOM    866  HG2 GLU A  56      -3.801   5.144   9.004  1.00  0.00           H  
ATOM    867  HG3 GLU A  56      -3.547   6.886   8.948  1.00  0.00           H  
ATOM    868  N   VAL A  57      -1.659   4.900   6.847  1.00  0.00           N  
ATOM    869  CA  VAL A  57      -0.737   3.820   7.179  1.00  0.00           C  
ATOM    870  C   VAL A  57      -0.556   3.695   8.687  1.00  0.00           C  
ATOM    871  O   VAL A  57      -0.064   4.614   9.343  1.00  0.00           O  
ATOM    872  CB  VAL A  57       0.640   4.036   6.524  1.00  0.00           C  
ATOM    873  CG1 VAL A  57       1.571   2.876   6.840  1.00  0.00           C  
ATOM    874  CG2 VAL A  57       0.492   4.217   5.021  1.00  0.00           C  
ATOM    875  H   VAL A  57      -1.310   5.808   6.734  1.00  0.00           H  
ATOM    876  HA  VAL A  57      -1.152   2.897   6.798  1.00  0.00           H  
ATOM    877  HB  VAL A  57       1.073   4.937   6.933  1.00  0.00           H  
ATOM    878 HG11 VAL A  57       0.986   1.989   7.036  1.00  0.00           H  
ATOM    879 HG12 VAL A  57       2.224   2.699   5.998  1.00  0.00           H  
ATOM    880 HG13 VAL A  57       2.162   3.116   7.711  1.00  0.00           H  
ATOM    881 HG21 VAL A  57       1.241   4.910   4.667  1.00  0.00           H  
ATOM    882 HG22 VAL A  57       0.622   3.264   4.528  1.00  0.00           H  
ATOM    883 HG23 VAL A  57      -0.491   4.606   4.799  1.00  0.00           H  
ATOM    884  N   VAL A  58      -0.957   2.552   9.234  1.00  0.00           N  
ATOM    885  CA  VAL A  58      -0.837   2.306  10.666  1.00  0.00           C  
ATOM    886  C   VAL A  58       0.010   1.070  10.942  1.00  0.00           C  
ATOM    887  O   VAL A  58      -0.131   0.032  10.295  1.00  0.00           O  
ATOM    888  CB  VAL A  58      -2.220   2.124  11.321  1.00  0.00           C  
ATOM    889  CG1 VAL A  58      -2.802   3.471  11.723  1.00  0.00           C  
ATOM    890  CG2 VAL A  58      -3.162   1.386  10.381  1.00  0.00           C  
ATOM    891  H   VAL A  58      -1.341   1.857   8.660  1.00  0.00           H  
ATOM    892  HA  VAL A  58      -0.360   3.165  11.113  1.00  0.00           H  
ATOM    893  HB  VAL A  58      -2.097   1.528  12.213  1.00  0.00           H  
ATOM    894 HG11 VAL A  58      -3.542   3.325  12.496  1.00  0.00           H  
ATOM    895 HG12 VAL A  58      -2.012   4.108  12.094  1.00  0.00           H  
ATOM    896 HG13 VAL A  58      -3.265   3.933  10.864  1.00  0.00           H  
ATOM    897 HG21 VAL A  58      -4.126   1.277  10.852  1.00  0.00           H  
ATOM    898 HG22 VAL A  58      -3.269   1.948   9.464  1.00  0.00           H  
ATOM    899 HG23 VAL A  58      -2.756   0.410  10.158  1.00  0.00           H  
ATOM    900  N   PRO A  59       0.914   1.181  11.927  1.00  0.00           N  
ATOM    901  CA  PRO A  59       1.803   0.081  12.313  1.00  0.00           C  
ATOM    902  C   PRO A  59       1.054  -1.059  12.996  1.00  0.00           C  
ATOM    903  O   PRO A  59       0.886  -1.060  14.215  1.00  0.00           O  
ATOM    904  CB  PRO A  59       2.779   0.740  13.290  1.00  0.00           C  
ATOM    905  CG  PRO A  59       2.032   1.902  13.847  1.00  0.00           C  
ATOM    906  CD  PRO A  59       1.138   2.387  12.741  1.00  0.00           C  
ATOM    907  HA  PRO A  59       2.348  -0.306  11.464  1.00  0.00           H  
ATOM    908  HB2 PRO A  59       3.049   0.035  14.064  1.00  0.00           H  
ATOM    909  HB3 PRO A  59       3.665   1.058  12.761  1.00  0.00           H  
ATOM    910  HG2 PRO A  59       1.442   1.587  14.694  1.00  0.00           H  
ATOM    911  HG3 PRO A  59       2.724   2.678  14.137  1.00  0.00           H  
ATOM    912  HD2 PRO A  59       0.207   2.759  13.142  1.00  0.00           H  
ATOM    913  HD3 PRO A  59       1.634   3.154  12.163  1.00  0.00           H  
ATOM    914  N   ASP A  60       0.605  -2.025  12.202  1.00  0.00           N  
ATOM    915  CA  ASP A  60      -0.125  -3.170  12.731  1.00  0.00           C  
ATOM    916  C   ASP A  60       0.741  -4.426  12.707  1.00  0.00           C  
ATOM    917  O   ASP A  60       0.586  -5.300  11.855  1.00  0.00           O  
ATOM    918  CB  ASP A  60      -1.404  -3.403  11.925  1.00  0.00           C  
ATOM    919  CG  ASP A  60      -2.483  -4.093  12.736  1.00  0.00           C  
ATOM    920  OD1 ASP A  60      -2.237  -5.222  13.212  1.00  0.00           O  
ATOM    921  OD2 ASP A  60      -3.574  -3.506  12.895  1.00  0.00           O  
ATOM    922  H   ASP A  60       0.770  -1.966  11.238  1.00  0.00           H  
ATOM    923  HA  ASP A  60      -0.391  -2.951  13.754  1.00  0.00           H  
ATOM    924  HB2 ASP A  60      -1.788  -2.451  11.587  1.00  0.00           H  
ATOM    925  HB3 ASP A  60      -1.175  -4.019  11.068  1.00  0.00           H  
ATOM    926  N   PRO A  61       1.677  -4.518  13.664  1.00  0.00           N  
ATOM    927  CA  PRO A  61       2.587  -5.661  13.773  1.00  0.00           C  
ATOM    928  C   PRO A  61       1.870  -6.932  14.216  1.00  0.00           C  
ATOM    929  O   PRO A  61       0.675  -6.912  14.510  1.00  0.00           O  
ATOM    930  CB  PRO A  61       3.590  -5.215  14.840  1.00  0.00           C  
ATOM    931  CG  PRO A  61       2.852  -4.214  15.659  1.00  0.00           C  
ATOM    932  CD  PRO A  61       1.917  -3.512  14.712  1.00  0.00           C  
ATOM    933  HA  PRO A  61       3.105  -5.847  12.844  1.00  0.00           H  
ATOM    934  HB2 PRO A  61       3.892  -6.067  15.433  1.00  0.00           H  
ATOM    935  HB3 PRO A  61       4.455  -4.776  14.365  1.00  0.00           H  
ATOM    936  HG2 PRO A  61       2.294  -4.714  16.435  1.00  0.00           H  
ATOM    937  HG3 PRO A  61       3.547  -3.508  16.090  1.00  0.00           H  
ATOM    938  HD2 PRO A  61       0.998  -3.251  15.215  1.00  0.00           H  
ATOM    939  HD3 PRO A  61       2.388  -2.632  14.300  1.00  0.00           H  
ATOM    940  N   SER A  62       2.608  -8.037  14.260  1.00  0.00           N  
ATOM    941  CA  SER A  62       2.040  -9.319  14.663  1.00  0.00           C  
ATOM    942  C   SER A  62       2.938 -10.012  15.684  1.00  0.00           C  
ATOM    943  O   SER A  62       4.097  -9.647  15.879  1.00  0.00           O  
ATOM    944  CB  SER A  62       1.845 -10.221  13.443  1.00  0.00           C  
ATOM    945  OG  SER A  62       0.517 -10.141  12.956  1.00  0.00           O  
ATOM    946  H   SER A  62       3.555  -7.990  14.013  1.00  0.00           H  
ATOM    947  HA  SER A  62       1.080  -9.128  15.117  1.00  0.00           H  
ATOM    948  HB2 SER A  62       2.521  -9.914  12.659  1.00  0.00           H  
ATOM    949  HB3 SER A  62       2.055 -11.245  13.718  1.00  0.00           H  
ATOM    950  HG  SER A  62       0.178  -9.253  13.095  1.00  0.00           H  
ATOM    951  N   PRO A  63       2.389 -11.038  16.353  1.00  0.00           N  
ATOM    952  CA  PRO A  63       3.120 -11.806  17.364  1.00  0.00           C  
ATOM    953  C   PRO A  63       4.224 -12.665  16.755  1.00  0.00           C  
ATOM    954  O   PRO A  63       4.889 -13.427  17.457  1.00  0.00           O  
ATOM    955  CB  PRO A  63       2.039 -12.689  17.991  1.00  0.00           C  
ATOM    956  CG  PRO A  63       1.001 -12.825  16.931  1.00  0.00           C  
ATOM    957  CD  PRO A  63       1.012 -11.528  16.171  1.00  0.00           C  
ATOM    958  HA  PRO A  63       3.544 -11.162  18.121  1.00  0.00           H  
ATOM    959  HB2 PRO A  63       2.462 -13.648  18.255  1.00  0.00           H  
ATOM    960  HB3 PRO A  63       1.642 -12.208  18.872  1.00  0.00           H  
ATOM    961  HG2 PRO A  63       1.250 -13.646  16.275  1.00  0.00           H  
ATOM    962  HG3 PRO A  63       0.033 -12.985  17.384  1.00  0.00           H  
ATOM    963  HD2 PRO A  63       0.799 -11.700  15.126  1.00  0.00           H  
ATOM    964  HD3 PRO A  63       0.299 -10.836  16.595  1.00  0.00           H  
ATOM    965  N   ASP A  64       4.411 -12.537  15.446  1.00  0.00           N  
ATOM    966  CA  ASP A  64       5.435 -13.301  14.742  1.00  0.00           C  
ATOM    967  C   ASP A  64       6.386 -12.374  13.992  1.00  0.00           C  
ATOM    968  O   ASP A  64       7.459 -12.790  13.554  1.00  0.00           O  
ATOM    969  CB  ASP A  64       4.787 -14.285  13.767  1.00  0.00           C  
ATOM    970  CG  ASP A  64       5.718 -15.419  13.385  1.00  0.00           C  
ATOM    971  OD1 ASP A  64       6.934 -15.169  13.251  1.00  0.00           O  
ATOM    972  OD2 ASP A  64       5.231 -16.557  13.218  1.00  0.00           O  
ATOM    973  H   ASP A  64       3.849 -11.913  14.941  1.00  0.00           H  
ATOM    974  HA  ASP A  64       5.999 -13.855  15.478  1.00  0.00           H  
ATOM    975  HB2 ASP A  64       3.905 -14.708  14.226  1.00  0.00           H  
ATOM    976  HB3 ASP A  64       4.503 -13.757  12.869  1.00  0.00           H  
ATOM    977  N   HIS A  65       5.984 -11.115  13.846  1.00  0.00           N  
ATOM    978  CA  HIS A  65       6.800 -10.128  13.147  1.00  0.00           C  
ATOM    979  C   HIS A  65       6.325  -8.712  13.459  1.00  0.00           C  
ATOM    980  O   HIS A  65       5.273  -8.281  12.985  1.00  0.00           O  
ATOM    981  CB  HIS A  65       6.755 -10.374  11.639  1.00  0.00           C  
ATOM    982  CG  HIS A  65       7.827 -11.299  11.151  1.00  0.00           C  
ATOM    983  ND1 HIS A  65       9.122 -10.889  10.910  1.00  0.00           N  
ATOM    984  CD2 HIS A  65       7.792 -12.620  10.860  1.00  0.00           C  
ATOM    985  CE1 HIS A  65       9.836 -11.918  10.490  1.00  0.00           C  
ATOM    986  NE2 HIS A  65       9.052 -12.981  10.452  1.00  0.00           N  
ATOM    987  H   HIS A  65       5.120 -10.844  14.218  1.00  0.00           H  
ATOM    988  HA  HIS A  65       7.817 -10.237  13.492  1.00  0.00           H  
ATOM    989  HB2 HIS A  65       5.801 -10.807  11.380  1.00  0.00           H  
ATOM    990  HB3 HIS A  65       6.869  -9.430  11.124  1.00  0.00           H  
ATOM    991  HD1 HIS A  65       9.466  -9.979  11.027  1.00  0.00           H  
ATOM    992  HD2 HIS A  65       6.932 -13.271  10.936  1.00  0.00           H  
ATOM    993  HE1 HIS A  65      10.882 -11.896  10.224  1.00  0.00           H  
ATOM    994  HE2 HIS A  65       9.307 -13.857  10.096  1.00  0.00           H  
ATOM    995  N   LEU A  66       7.106  -7.994  14.259  1.00  0.00           N  
ATOM    996  CA  LEU A  66       6.765  -6.626  14.634  1.00  0.00           C  
ATOM    997  C   LEU A  66       7.212  -5.639  13.561  1.00  0.00           C  
ATOM    998  O   LEU A  66       7.497  -4.477  13.851  1.00  0.00           O  
ATOM    999  CB  LEU A  66       7.410  -6.268  15.974  1.00  0.00           C  
ATOM   1000  CG  LEU A  66       7.392  -7.363  17.041  1.00  0.00           C  
ATOM   1001  CD1 LEU A  66       8.518  -7.150  18.042  1.00  0.00           C  
ATOM   1002  CD2 LEU A  66       6.046  -7.397  17.750  1.00  0.00           C  
ATOM   1003  H   LEU A  66       7.931  -8.391  14.605  1.00  0.00           H  
ATOM   1004  HA  LEU A  66       5.691  -6.568  14.733  1.00  0.00           H  
ATOM   1005  HB2 LEU A  66       8.440  -6.006  15.785  1.00  0.00           H  
ATOM   1006  HB3 LEU A  66       6.889  -5.409  16.371  1.00  0.00           H  
ATOM   1007  HG  LEU A  66       7.546  -8.322  16.566  1.00  0.00           H  
ATOM   1008 HD11 LEU A  66       9.341  -7.807  17.803  1.00  0.00           H  
ATOM   1009 HD12 LEU A  66       8.160  -7.369  19.037  1.00  0.00           H  
ATOM   1010 HD13 LEU A  66       8.852  -6.124  17.997  1.00  0.00           H  
ATOM   1011 HD21 LEU A  66       5.557  -6.440  17.636  1.00  0.00           H  
ATOM   1012 HD22 LEU A  66       6.197  -7.602  18.799  1.00  0.00           H  
ATOM   1013 HD23 LEU A  66       5.431  -8.171  17.314  1.00  0.00           H  
ATOM   1014  N   TYR A  67       7.271  -6.109  12.320  1.00  0.00           N  
ATOM   1015  CA  TYR A  67       7.685  -5.268  11.203  1.00  0.00           C  
ATOM   1016  C   TYR A  67       6.658  -5.318  10.075  1.00  0.00           C  
ATOM   1017  O   TYR A  67       7.015  -5.414   8.900  1.00  0.00           O  
ATOM   1018  CB  TYR A  67       9.053  -5.711  10.683  1.00  0.00           C  
ATOM   1019  CG  TYR A  67      10.006  -6.139  11.776  1.00  0.00           C  
ATOM   1020  CD1 TYR A  67      10.137  -5.395  12.942  1.00  0.00           C  
ATOM   1021  CD2 TYR A  67      10.775  -7.288  11.642  1.00  0.00           C  
ATOM   1022  CE1 TYR A  67      11.007  -5.782  13.943  1.00  0.00           C  
ATOM   1023  CE2 TYR A  67      11.647  -7.684  12.638  1.00  0.00           C  
ATOM   1024  CZ  TYR A  67      11.760  -6.928  13.786  1.00  0.00           C  
ATOM   1025  OH  TYR A  67      12.626  -7.317  14.781  1.00  0.00           O  
ATOM   1026  H   TYR A  67       7.032  -7.044  12.151  1.00  0.00           H  
ATOM   1027  HA  TYR A  67       7.758  -4.251  11.562  1.00  0.00           H  
ATOM   1028  HB2 TYR A  67       8.923  -6.545  10.012  1.00  0.00           H  
ATOM   1029  HB3 TYR A  67       9.508  -4.891  10.147  1.00  0.00           H  
ATOM   1030  HD1 TYR A  67       9.545  -4.499  13.061  1.00  0.00           H  
ATOM   1031  HD2 TYR A  67      10.686  -7.878  10.741  1.00  0.00           H  
ATOM   1032  HE1 TYR A  67      11.095  -5.191  14.842  1.00  0.00           H  
ATOM   1033  HE2 TYR A  67      12.237  -8.580  12.517  1.00  0.00           H  
ATOM   1034  HH  TYR A  67      12.303  -8.124  15.189  1.00  0.00           H  
ATOM   1035  N   SER A  68       5.383  -5.252  10.440  1.00  0.00           N  
ATOM   1036  CA  SER A  68       4.304  -5.292   9.460  1.00  0.00           C  
ATOM   1037  C   SER A  68       3.345  -4.121   9.658  1.00  0.00           C  
ATOM   1038  O   SER A  68       2.988  -3.781  10.786  1.00  0.00           O  
ATOM   1039  CB  SER A  68       3.540  -6.615   9.565  1.00  0.00           C  
ATOM   1040  OG  SER A  68       2.553  -6.715   8.554  1.00  0.00           O  
ATOM   1041  H   SER A  68       5.161  -5.176  11.392  1.00  0.00           H  
ATOM   1042  HA  SER A  68       4.745  -5.219   8.478  1.00  0.00           H  
ATOM   1043  HB2 SER A  68       4.233  -7.436   9.459  1.00  0.00           H  
ATOM   1044  HB3 SER A  68       3.057  -6.672  10.530  1.00  0.00           H  
ATOM   1045  HG  SER A  68       1.692  -6.846   8.959  1.00  0.00           H  
ATOM   1046  N   PHE A  69       2.932  -3.509   8.553  1.00  0.00           N  
ATOM   1047  CA  PHE A  69       2.017  -2.376   8.604  1.00  0.00           C  
ATOM   1048  C   PHE A  69       0.871  -2.558   7.613  1.00  0.00           C  
ATOM   1049  O   PHE A  69       0.962  -3.360   6.683  1.00  0.00           O  
ATOM   1050  CB  PHE A  69       2.763  -1.075   8.304  1.00  0.00           C  
ATOM   1051  CG  PHE A  69       3.694  -1.175   7.129  1.00  0.00           C  
ATOM   1052  CD1 PHE A  69       4.975  -1.680   7.285  1.00  0.00           C  
ATOM   1053  CD2 PHE A  69       3.288  -0.765   5.870  1.00  0.00           C  
ATOM   1054  CE1 PHE A  69       5.833  -1.773   6.205  1.00  0.00           C  
ATOM   1055  CE2 PHE A  69       4.141  -0.856   4.787  1.00  0.00           C  
ATOM   1056  CZ  PHE A  69       5.416  -1.361   4.955  1.00  0.00           C  
ATOM   1057  H   PHE A  69       3.252  -3.827   7.683  1.00  0.00           H  
ATOM   1058  HA  PHE A  69       1.608  -2.325   9.602  1.00  0.00           H  
ATOM   1059  HB2 PHE A  69       2.046  -0.297   8.094  1.00  0.00           H  
ATOM   1060  HB3 PHE A  69       3.347  -0.797   9.169  1.00  0.00           H  
ATOM   1061  HD1 PHE A  69       5.302  -2.005   8.262  1.00  0.00           H  
ATOM   1062  HD2 PHE A  69       2.291  -0.369   5.738  1.00  0.00           H  
ATOM   1063  HE1 PHE A  69       6.828  -2.169   6.339  1.00  0.00           H  
ATOM   1064  HE2 PHE A  69       3.811  -0.532   3.811  1.00  0.00           H  
ATOM   1065  HZ  PHE A  69       6.084  -1.432   4.110  1.00  0.00           H  
ATOM   1066  N   ARG A  70      -0.207  -1.808   7.817  1.00  0.00           N  
ATOM   1067  CA  ARG A  70      -1.371  -1.886   6.944  1.00  0.00           C  
ATOM   1068  C   ARG A  70      -1.972  -0.503   6.712  1.00  0.00           C  
ATOM   1069  O   ARG A  70      -1.845   0.387   7.553  1.00  0.00           O  
ATOM   1070  CB  ARG A  70      -2.425  -2.818   7.545  1.00  0.00           C  
ATOM   1071  CG  ARG A  70      -2.811  -2.460   8.971  1.00  0.00           C  
ATOM   1072  CD  ARG A  70      -4.134  -3.097   9.366  1.00  0.00           C  
ATOM   1073  NE  ARG A  70      -4.859  -2.291  10.344  1.00  0.00           N  
ATOM   1074  CZ  ARG A  70      -5.766  -2.786  11.178  1.00  0.00           C  
ATOM   1075  NH1 ARG A  70      -6.059  -4.080  11.153  1.00  0.00           N  
ATOM   1076  NH2 ARG A  70      -6.385  -1.988  12.040  1.00  0.00           N  
ATOM   1077  H   ARG A  70      -0.220  -1.187   8.576  1.00  0.00           H  
ATOM   1078  HA  ARG A  70      -1.047  -2.288   5.995  1.00  0.00           H  
ATOM   1079  HB2 ARG A  70      -3.315  -2.778   6.934  1.00  0.00           H  
ATOM   1080  HB3 ARG A  70      -2.040  -3.827   7.542  1.00  0.00           H  
ATOM   1081  HG2 ARG A  70      -2.041  -2.812   9.642  1.00  0.00           H  
ATOM   1082  HG3 ARG A  70      -2.899  -1.387   9.052  1.00  0.00           H  
ATOM   1083  HD2 ARG A  70      -4.744  -3.208   8.482  1.00  0.00           H  
ATOM   1084  HD3 ARG A  70      -3.937  -4.070   9.791  1.00  0.00           H  
ATOM   1085  HE  ARG A  70      -4.660  -1.332  10.381  1.00  0.00           H  
ATOM   1086 HH11 ARG A  70      -5.594  -4.684  10.505  1.00  0.00           H  
ATOM   1087 HH12 ARG A  70      -6.741  -4.451  11.783  1.00  0.00           H  
ATOM   1088 HH21 ARG A  70      -6.167  -1.013  12.062  1.00  0.00           H  
ATOM   1089 HH22 ARG A  70      -7.067  -2.363  12.666  1.00  0.00           H  
ATOM   1090  N   ILE A  71      -2.625  -0.332   5.568  1.00  0.00           N  
ATOM   1091  CA  ILE A  71      -3.245   0.943   5.227  1.00  0.00           C  
ATOM   1092  C   ILE A  71      -4.756   0.890   5.431  1.00  0.00           C  
ATOM   1093  O   ILE A  71      -5.372  -0.171   5.319  1.00  0.00           O  
ATOM   1094  CB  ILE A  71      -2.948   1.342   3.769  1.00  0.00           C  
ATOM   1095  CG1 ILE A  71      -1.611   0.751   3.319  1.00  0.00           C  
ATOM   1096  CG2 ILE A  71      -2.940   2.856   3.625  1.00  0.00           C  
ATOM   1097  CD1 ILE A  71      -1.332   0.943   1.844  1.00  0.00           C  
ATOM   1098  H   ILE A  71      -2.692  -1.079   4.939  1.00  0.00           H  
ATOM   1099  HA  ILE A  71      -2.831   1.699   5.878  1.00  0.00           H  
ATOM   1100  HB  ILE A  71      -3.736   0.949   3.145  1.00  0.00           H  
ATOM   1101 HG12 ILE A  71      -0.812   1.221   3.871  1.00  0.00           H  
ATOM   1102 HG13 ILE A  71      -1.608  -0.311   3.523  1.00  0.00           H  
ATOM   1103 HG21 ILE A  71      -1.982   3.242   3.942  1.00  0.00           H  
ATOM   1104 HG22 ILE A  71      -3.110   3.120   2.593  1.00  0.00           H  
ATOM   1105 HG23 ILE A  71      -3.719   3.280   4.240  1.00  0.00           H  
ATOM   1106 HD11 ILE A  71      -2.257   0.879   1.291  1.00  0.00           H  
ATOM   1107 HD12 ILE A  71      -0.882   1.910   1.685  1.00  0.00           H  
ATOM   1108 HD13 ILE A  71      -0.656   0.171   1.502  1.00  0.00           H  
ATOM   1109  N   LEU A  72      -5.347   2.042   5.727  1.00  0.00           N  
ATOM   1110  CA  LEU A  72      -6.787   2.129   5.945  1.00  0.00           C  
ATOM   1111  C   LEU A  72      -7.366   3.368   5.270  1.00  0.00           C  
ATOM   1112  O   LEU A  72      -6.698   4.397   5.159  1.00  0.00           O  
ATOM   1113  CB  LEU A  72      -7.096   2.158   7.442  1.00  0.00           C  
ATOM   1114  CG  LEU A  72      -6.546   0.991   8.264  1.00  0.00           C  
ATOM   1115  CD1 LEU A  72      -6.236   1.438   9.685  1.00  0.00           C  
ATOM   1116  CD2 LEU A  72      -7.532  -0.168   8.270  1.00  0.00           C  
ATOM   1117  H   LEU A  72      -4.804   2.853   5.803  1.00  0.00           H  
ATOM   1118  HA  LEU A  72      -7.242   1.251   5.509  1.00  0.00           H  
ATOM   1119  HB2 LEU A  72      -6.685   3.070   7.847  1.00  0.00           H  
ATOM   1120  HB3 LEU A  72      -8.171   2.168   7.558  1.00  0.00           H  
ATOM   1121  HG  LEU A  72      -5.625   0.645   7.815  1.00  0.00           H  
ATOM   1122 HD11 LEU A  72      -5.459   2.186   9.665  1.00  0.00           H  
ATOM   1123 HD12 LEU A  72      -5.907   0.589  10.265  1.00  0.00           H  
ATOM   1124 HD13 LEU A  72      -7.127   1.855  10.133  1.00  0.00           H  
ATOM   1125 HD21 LEU A  72      -7.466  -0.701   7.333  1.00  0.00           H  
ATOM   1126 HD22 LEU A  72      -8.535   0.214   8.398  1.00  0.00           H  
ATOM   1127 HD23 LEU A  72      -7.295  -0.837   9.083  1.00  0.00           H  
ATOM   1128  N   HIS A  73      -8.613   3.265   4.823  1.00  0.00           N  
ATOM   1129  CA  HIS A  73      -9.284   4.379   4.162  1.00  0.00           C  
ATOM   1130  C   HIS A  73     -10.531   4.797   4.933  1.00  0.00           C  
ATOM   1131  O   HIS A  73     -11.637   4.341   4.641  1.00  0.00           O  
ATOM   1132  CB  HIS A  73      -9.659   3.998   2.729  1.00  0.00           C  
ATOM   1133  CG  HIS A  73     -10.189   5.144   1.925  1.00  0.00           C  
ATOM   1134  ND1 HIS A  73     -11.518   5.516   1.929  1.00  0.00           N  
ATOM   1135  CD2 HIS A  73      -9.562   6.004   1.088  1.00  0.00           C  
ATOM   1136  CE1 HIS A  73     -11.685   6.554   1.128  1.00  0.00           C  
ATOM   1137  NE2 HIS A  73     -10.513   6.870   0.606  1.00  0.00           N  
ATOM   1138  H   HIS A  73      -9.095   2.420   4.940  1.00  0.00           H  
ATOM   1139  HA  HIS A  73      -8.597   5.211   4.135  1.00  0.00           H  
ATOM   1140  HB2 HIS A  73      -8.784   3.615   2.224  1.00  0.00           H  
ATOM   1141  HB3 HIS A  73     -10.418   3.230   2.755  1.00  0.00           H  
ATOM   1142  HD1 HIS A  73     -12.231   5.082   2.440  1.00  0.00           H  
ATOM   1143  HD2 HIS A  73      -8.509   6.009   0.844  1.00  0.00           H  
ATOM   1144  HE1 HIS A  73     -12.619   7.059   0.933  1.00  0.00           H  
ATOM   1145  HE2 HIS A  73     -10.368   7.547  -0.086  1.00  0.00           H  
ATOM   1146  N   LYS A  74     -10.346   5.668   5.920  1.00  0.00           N  
ATOM   1147  CA  LYS A  74     -11.456   6.149   6.734  1.00  0.00           C  
ATOM   1148  C   LYS A  74     -11.909   5.079   7.724  1.00  0.00           C  
ATOM   1149  O   LYS A  74     -13.059   5.071   8.160  1.00  0.00           O  
ATOM   1150  CB  LYS A  74     -12.628   6.562   5.842  1.00  0.00           C  
ATOM   1151  CG  LYS A  74     -12.209   7.342   4.608  1.00  0.00           C  
ATOM   1152  CD  LYS A  74     -12.179   8.837   4.876  1.00  0.00           C  
ATOM   1153  CE  LYS A  74     -12.259   9.637   3.585  1.00  0.00           C  
ATOM   1154  NZ  LYS A  74     -10.930   9.753   2.922  1.00  0.00           N  
ATOM   1155  H   LYS A  74      -9.442   5.995   6.105  1.00  0.00           H  
ATOM   1156  HA  LYS A  74     -11.113   7.011   7.286  1.00  0.00           H  
ATOM   1157  HB2 LYS A  74     -13.152   5.674   5.520  1.00  0.00           H  
ATOM   1158  HB3 LYS A  74     -13.304   7.178   6.418  1.00  0.00           H  
ATOM   1159  HG2 LYS A  74     -11.222   7.021   4.309  1.00  0.00           H  
ATOM   1160  HG3 LYS A  74     -12.911   7.142   3.811  1.00  0.00           H  
ATOM   1161  HD2 LYS A  74     -13.019   9.099   5.502  1.00  0.00           H  
ATOM   1162  HD3 LYS A  74     -11.258   9.084   5.386  1.00  0.00           H  
ATOM   1163  HE2 LYS A  74     -12.945   9.144   2.914  1.00  0.00           H  
ATOM   1164  HE3 LYS A  74     -12.626  10.627   3.813  1.00  0.00           H  
ATOM   1165  HZ1 LYS A  74     -10.211  10.046   3.613  1.00  0.00           H  
ATOM   1166  HZ2 LYS A  74     -10.972  10.461   2.160  1.00  0.00           H  
ATOM   1167  HZ3 LYS A  74     -10.653   8.837   2.514  1.00  0.00           H  
ATOM   1168  N   GLY A  75     -10.995   4.180   8.075  1.00  0.00           N  
ATOM   1169  CA  GLY A  75     -11.320   3.120   9.012  1.00  0.00           C  
ATOM   1170  C   GLY A  75     -11.422   1.764   8.340  1.00  0.00           C  
ATOM   1171  O   GLY A  75     -11.467   0.735   9.013  1.00  0.00           O  
ATOM   1172  H   GLY A  75     -10.094   4.236   7.695  1.00  0.00           H  
ATOM   1173  HA2 GLY A  75     -10.553   3.078   9.770  1.00  0.00           H  
ATOM   1174  HA3 GLY A  75     -12.266   3.347   9.481  1.00  0.00           H  
ATOM   1175  N   GLU A  76     -11.460   1.764   7.012  1.00  0.00           N  
ATOM   1176  CA  GLU A  76     -11.559   0.525   6.251  1.00  0.00           C  
ATOM   1177  C   GLU A  76     -10.174  -0.037   5.942  1.00  0.00           C  
ATOM   1178  O   GLU A  76      -9.158   0.558   6.301  1.00  0.00           O  
ATOM   1179  CB  GLU A  76     -12.328   0.760   4.949  1.00  0.00           C  
ATOM   1180  CG  GLU A  76     -13.827   0.551   5.081  1.00  0.00           C  
ATOM   1181  CD  GLU A  76     -14.510   1.679   5.829  1.00  0.00           C  
ATOM   1182  OE1 GLU A  76     -14.489   2.822   5.325  1.00  0.00           O  
ATOM   1183  OE2 GLU A  76     -15.064   1.420   6.917  1.00  0.00           O  
ATOM   1184  H   GLU A  76     -11.420   2.619   6.532  1.00  0.00           H  
ATOM   1185  HA  GLU A  76     -12.098  -0.191   6.852  1.00  0.00           H  
ATOM   1186  HB2 GLU A  76     -12.154   1.774   4.620  1.00  0.00           H  
ATOM   1187  HB3 GLU A  76     -11.955   0.080   4.198  1.00  0.00           H  
ATOM   1188  HG2 GLU A  76     -14.257   0.483   4.093  1.00  0.00           H  
ATOM   1189  HG3 GLU A  76     -14.003  -0.373   5.613  1.00  0.00           H  
ATOM   1190  N   GLU A  77     -10.143  -1.186   5.274  1.00  0.00           N  
ATOM   1191  CA  GLU A  77      -8.884  -1.829   4.920  1.00  0.00           C  
ATOM   1192  C   GLU A  77      -8.617  -1.712   3.422  1.00  0.00           C  
ATOM   1193  O   GLU A  77      -9.507  -1.939   2.601  1.00  0.00           O  
ATOM   1194  CB  GLU A  77      -8.904  -3.303   5.331  1.00  0.00           C  
ATOM   1195  CG  GLU A  77      -7.601  -4.031   5.046  1.00  0.00           C  
ATOM   1196  CD  GLU A  77      -7.718  -5.532   5.238  1.00  0.00           C  
ATOM   1197  OE1 GLU A  77      -7.710  -5.982   6.403  1.00  0.00           O  
ATOM   1198  OE2 GLU A  77      -7.816  -6.254   4.224  1.00  0.00           O  
ATOM   1199  H   GLU A  77     -10.987  -1.612   5.016  1.00  0.00           H  
ATOM   1200  HA  GLU A  77      -8.092  -1.326   5.455  1.00  0.00           H  
ATOM   1201  HB2 GLU A  77      -9.103  -3.365   6.391  1.00  0.00           H  
ATOM   1202  HB3 GLU A  77      -9.696  -3.803   4.795  1.00  0.00           H  
ATOM   1203  HG2 GLU A  77      -7.310  -3.837   4.025  1.00  0.00           H  
ATOM   1204  HG3 GLU A  77      -6.839  -3.656   5.715  1.00  0.00           H  
ATOM   1205  N   LEU A  78      -7.386  -1.355   3.073  1.00  0.00           N  
ATOM   1206  CA  LEU A  78      -7.000  -1.206   1.674  1.00  0.00           C  
ATOM   1207  C   LEU A  78      -5.947  -2.240   1.286  1.00  0.00           C  
ATOM   1208  O   LEU A  78      -6.051  -2.884   0.243  1.00  0.00           O  
ATOM   1209  CB  LEU A  78      -6.464   0.204   1.419  1.00  0.00           C  
ATOM   1210  CG  LEU A  78      -7.325   1.354   1.943  1.00  0.00           C  
ATOM   1211  CD1 LEU A  78      -6.535   2.654   1.948  1.00  0.00           C  
ATOM   1212  CD2 LEU A  78      -8.587   1.499   1.105  1.00  0.00           C  
ATOM   1213  H   LEU A  78      -6.719  -1.187   3.771  1.00  0.00           H  
ATOM   1214  HA  LEU A  78      -7.880  -1.362   1.069  1.00  0.00           H  
ATOM   1215  HB2 LEU A  78      -5.494   0.279   1.886  1.00  0.00           H  
ATOM   1216  HB3 LEU A  78      -6.358   0.329   0.351  1.00  0.00           H  
ATOM   1217  HG  LEU A  78      -7.621   1.140   2.961  1.00  0.00           H  
ATOM   1218 HD11 LEU A  78      -6.885   3.284   2.751  1.00  0.00           H  
ATOM   1219 HD12 LEU A  78      -6.670   3.161   1.005  1.00  0.00           H  
ATOM   1220 HD13 LEU A  78      -5.486   2.436   2.092  1.00  0.00           H  
ATOM   1221 HD21 LEU A  78      -8.753   0.592   0.544  1.00  0.00           H  
ATOM   1222 HD22 LEU A  78      -8.473   2.329   0.421  1.00  0.00           H  
ATOM   1223 HD23 LEU A  78      -9.431   1.681   1.753  1.00  0.00           H  
ATOM   1224  N   ALA A  79      -4.936  -2.394   2.135  1.00  0.00           N  
ATOM   1225  CA  ALA A  79      -3.867  -3.353   1.883  1.00  0.00           C  
ATOM   1226  C   ALA A  79      -3.083  -3.647   3.158  1.00  0.00           C  
ATOM   1227  O   ALA A  79      -3.348  -3.066   4.210  1.00  0.00           O  
ATOM   1228  CB  ALA A  79      -2.937  -2.834   0.797  1.00  0.00           C  
ATOM   1229  H   ALA A  79      -4.910  -1.851   2.950  1.00  0.00           H  
ATOM   1230  HA  ALA A  79      -4.317  -4.270   1.530  1.00  0.00           H  
ATOM   1231  HB1 ALA A  79      -2.608  -1.837   1.053  1.00  0.00           H  
ATOM   1232  HB2 ALA A  79      -2.082  -3.486   0.715  1.00  0.00           H  
ATOM   1233  HB3 ALA A  79      -3.464  -2.808  -0.145  1.00  0.00           H  
ATOM   1234  N   LYS A  80      -2.117  -4.554   3.057  1.00  0.00           N  
ATOM   1235  CA  LYS A  80      -1.293  -4.926   4.200  1.00  0.00           C  
ATOM   1236  C   LYS A  80       0.080  -5.410   3.746  1.00  0.00           C  
ATOM   1237  O   LYS A  80       0.197  -6.432   3.069  1.00  0.00           O  
ATOM   1238  CB  LYS A  80      -1.985  -6.016   5.020  1.00  0.00           C  
ATOM   1239  CG  LYS A  80      -1.313  -6.293   6.354  1.00  0.00           C  
ATOM   1240  CD  LYS A  80      -2.294  -6.862   7.365  1.00  0.00           C  
ATOM   1241  CE  LYS A  80      -1.599  -7.232   8.667  1.00  0.00           C  
ATOM   1242  NZ  LYS A  80      -1.570  -6.091   9.624  1.00  0.00           N  
ATOM   1243  H   LYS A  80      -1.953  -4.982   2.189  1.00  0.00           H  
ATOM   1244  HA  LYS A  80      -1.166  -4.049   4.817  1.00  0.00           H  
ATOM   1245  HB2 LYS A  80      -3.005  -5.714   5.210  1.00  0.00           H  
ATOM   1246  HB3 LYS A  80      -1.990  -6.932   4.447  1.00  0.00           H  
ATOM   1247  HG2 LYS A  80      -0.514  -7.005   6.203  1.00  0.00           H  
ATOM   1248  HG3 LYS A  80      -0.906  -5.369   6.740  1.00  0.00           H  
ATOM   1249  HD2 LYS A  80      -3.053  -6.123   7.573  1.00  0.00           H  
ATOM   1250  HD3 LYS A  80      -2.755  -7.746   6.949  1.00  0.00           H  
ATOM   1251  HE2 LYS A  80      -2.130  -8.057   9.120  1.00  0.00           H  
ATOM   1252  HE3 LYS A  80      -0.587  -7.533   8.446  1.00  0.00           H  
ATOM   1253  HZ1 LYS A  80      -2.034  -5.260   9.203  1.00  0.00           H  
ATOM   1254  HZ2 LYS A  80      -0.586  -5.844   9.855  1.00  0.00           H  
ATOM   1255  HZ3 LYS A  80      -2.068  -6.347  10.501  1.00  0.00           H  
ATOM   1256  N   LEU A  81       1.119  -4.672   4.125  1.00  0.00           N  
ATOM   1257  CA  LEU A  81       2.485  -5.028   3.759  1.00  0.00           C  
ATOM   1258  C   LEU A  81       3.297  -5.410   4.992  1.00  0.00           C  
ATOM   1259  O   LEU A  81       2.927  -5.079   6.117  1.00  0.00           O  
ATOM   1260  CB  LEU A  81       3.158  -3.864   3.030  1.00  0.00           C  
ATOM   1261  CG  LEU A  81       2.439  -3.347   1.783  1.00  0.00           C  
ATOM   1262  CD1 LEU A  81       2.300  -4.454   0.750  1.00  0.00           C  
ATOM   1263  CD2 LEU A  81       1.074  -2.783   2.150  1.00  0.00           C  
ATOM   1264  H   LEU A  81       0.963  -3.869   4.665  1.00  0.00           H  
ATOM   1265  HA  LEU A  81       2.439  -5.879   3.096  1.00  0.00           H  
ATOM   1266  HB2 LEU A  81       3.244  -3.044   3.726  1.00  0.00           H  
ATOM   1267  HB3 LEU A  81       4.145  -4.187   2.733  1.00  0.00           H  
ATOM   1268  HG  LEU A  81       3.023  -2.552   1.342  1.00  0.00           H  
ATOM   1269 HD11 LEU A  81       1.265  -4.546   0.459  1.00  0.00           H  
ATOM   1270 HD12 LEU A  81       2.638  -5.387   1.174  1.00  0.00           H  
ATOM   1271 HD13 LEU A  81       2.899  -4.214  -0.117  1.00  0.00           H  
ATOM   1272 HD21 LEU A  81       1.141  -2.268   3.097  1.00  0.00           H  
ATOM   1273 HD22 LEU A  81       0.360  -3.590   2.228  1.00  0.00           H  
ATOM   1274 HD23 LEU A  81       0.754  -2.090   1.386  1.00  0.00           H  
ATOM   1275  N   GLU A  82       4.410  -6.104   4.770  1.00  0.00           N  
ATOM   1276  CA  GLU A  82       5.275  -6.529   5.864  1.00  0.00           C  
ATOM   1277  C   GLU A  82       6.743  -6.448   5.458  1.00  0.00           C  
ATOM   1278  O   GLU A  82       7.139  -6.964   4.413  1.00  0.00           O  
ATOM   1279  CB  GLU A  82       4.930  -7.956   6.292  1.00  0.00           C  
ATOM   1280  CG  GLU A  82       6.089  -8.693   6.945  1.00  0.00           C  
ATOM   1281  CD  GLU A  82       5.628  -9.766   7.911  1.00  0.00           C  
ATOM   1282  OE1 GLU A  82       5.089 -10.792   7.447  1.00  0.00           O  
ATOM   1283  OE2 GLU A  82       5.807  -9.578   9.134  1.00  0.00           O  
ATOM   1284  H   GLU A  82       4.652  -6.338   3.849  1.00  0.00           H  
ATOM   1285  HA  GLU A  82       5.107  -5.862   6.697  1.00  0.00           H  
ATOM   1286  HB2 GLU A  82       4.111  -7.920   6.995  1.00  0.00           H  
ATOM   1287  HB3 GLU A  82       4.621  -8.515   5.421  1.00  0.00           H  
ATOM   1288  HG2 GLU A  82       6.683  -9.157   6.173  1.00  0.00           H  
ATOM   1289  HG3 GLU A  82       6.694  -7.979   7.483  1.00  0.00           H  
ATOM   1290  N   ALA A  83       7.547  -5.795   6.291  1.00  0.00           N  
ATOM   1291  CA  ALA A  83       8.972  -5.648   6.021  1.00  0.00           C  
ATOM   1292  C   ALA A  83       9.764  -6.819   6.592  1.00  0.00           C  
ATOM   1293  O   ALA A  83       9.188  -7.782   7.099  1.00  0.00           O  
ATOM   1294  CB  ALA A  83       9.484  -4.334   6.591  1.00  0.00           C  
ATOM   1295  H   ALA A  83       7.173  -5.405   7.109  1.00  0.00           H  
ATOM   1296  HA  ALA A  83       9.107  -5.624   4.949  1.00  0.00           H  
ATOM   1297  HB1 ALA A  83       8.770  -3.950   7.306  1.00  0.00           H  
ATOM   1298  HB2 ALA A  83      10.431  -4.500   7.082  1.00  0.00           H  
ATOM   1299  HB3 ALA A  83       9.612  -3.620   5.791  1.00  0.00           H  
ATOM   1300  N   LYS A  84      11.086  -6.730   6.507  1.00  0.00           N  
ATOM   1301  CA  LYS A  84      11.958  -7.783   7.016  1.00  0.00           C  
ATOM   1302  C   LYS A  84      12.552  -7.391   8.366  1.00  0.00           C  
ATOM   1303  O   LYS A  84      12.717  -8.232   9.249  1.00  0.00           O  
ATOM   1304  CB  LYS A  84      13.082  -8.071   6.017  1.00  0.00           C  
ATOM   1305  CG  LYS A  84      13.964  -6.869   5.731  1.00  0.00           C  
ATOM   1306  CD  LYS A  84      15.320  -7.289   5.190  1.00  0.00           C  
ATOM   1307  CE  LYS A  84      16.268  -7.689   6.310  1.00  0.00           C  
ATOM   1308  NZ  LYS A  84      16.060  -9.101   6.736  1.00  0.00           N  
ATOM   1309  H   LYS A  84      11.487  -5.938   6.092  1.00  0.00           H  
ATOM   1310  HA  LYS A  84      11.364  -8.674   7.144  1.00  0.00           H  
ATOM   1311  HB2 LYS A  84      13.702  -8.863   6.411  1.00  0.00           H  
ATOM   1312  HB3 LYS A  84      12.642  -8.399   5.086  1.00  0.00           H  
ATOM   1313  HG2 LYS A  84      13.476  -6.241   5.001  1.00  0.00           H  
ATOM   1314  HG3 LYS A  84      14.109  -6.313   6.647  1.00  0.00           H  
ATOM   1315  HD2 LYS A  84      15.188  -8.132   4.528  1.00  0.00           H  
ATOM   1316  HD3 LYS A  84      15.751  -6.463   4.642  1.00  0.00           H  
ATOM   1317  HE2 LYS A  84      17.284  -7.572   5.963  1.00  0.00           H  
ATOM   1318  HE3 LYS A  84      16.100  -7.038   7.155  1.00  0.00           H  
ATOM   1319  HZ1 LYS A  84      15.439  -9.589   6.060  1.00  0.00           H  
ATOM   1320  HZ2 LYS A  84      15.619  -9.128   7.677  1.00  0.00           H  
ATOM   1321  HZ3 LYS A  84      16.972  -9.599   6.777  1.00  0.00           H  
ATOM   1322  N   SER A  85      12.870  -6.109   8.518  1.00  0.00           N  
ATOM   1323  CA  SER A  85      13.448  -5.608   9.759  1.00  0.00           C  
ATOM   1324  C   SER A  85      12.671  -4.398  10.269  1.00  0.00           C  
ATOM   1325  O   SER A  85      11.947  -3.748   9.515  1.00  0.00           O  
ATOM   1326  CB  SER A  85      14.917  -5.233   9.548  1.00  0.00           C  
ATOM   1327  OG  SER A  85      15.060  -4.315   8.479  1.00  0.00           O  
ATOM   1328  H   SER A  85      12.715  -5.487   7.777  1.00  0.00           H  
ATOM   1329  HA  SER A  85      13.388  -6.395  10.495  1.00  0.00           H  
ATOM   1330  HB2 SER A  85      15.304  -4.782  10.449  1.00  0.00           H  
ATOM   1331  HB3 SER A  85      15.483  -6.124   9.320  1.00  0.00           H  
ATOM   1332  HG  SER A  85      14.688  -4.693   7.679  1.00  0.00           H  
ATOM   1333  N   SER A  86      12.830  -4.100  11.555  1.00  0.00           N  
ATOM   1334  CA  SER A  86      12.141  -2.971  12.169  1.00  0.00           C  
ATOM   1335  C   SER A  86      12.506  -1.666  11.468  1.00  0.00           C  
ATOM   1336  O   SER A  86      11.638  -0.849  11.164  1.00  0.00           O  
ATOM   1337  CB  SER A  86      12.491  -2.879  13.655  1.00  0.00           C  
ATOM   1338  OG  SER A  86      13.822  -2.430  13.839  1.00  0.00           O  
ATOM   1339  H   SER A  86      13.421  -4.655  12.105  1.00  0.00           H  
ATOM   1340  HA  SER A  86      11.078  -3.136  12.067  1.00  0.00           H  
ATOM   1341  HB2 SER A  86      11.820  -2.185  14.138  1.00  0.00           H  
ATOM   1342  HB3 SER A  86      12.386  -3.855  14.108  1.00  0.00           H  
ATOM   1343  HG  SER A  86      14.432  -3.074  13.470  1.00  0.00           H  
ATOM   1344  N   GLU A  87      13.797  -1.479  11.213  1.00  0.00           N  
ATOM   1345  CA  GLU A  87      14.277  -0.274  10.549  1.00  0.00           C  
ATOM   1346  C   GLU A  87      13.622  -0.108   9.181  1.00  0.00           C  
ATOM   1347  O   GLU A  87      13.348   1.010   8.744  1.00  0.00           O  
ATOM   1348  CB  GLU A  87      15.799  -0.321  10.394  1.00  0.00           C  
ATOM   1349  CG  GLU A  87      16.544  -0.351  11.718  1.00  0.00           C  
ATOM   1350  CD  GLU A  87      16.135   0.776  12.645  1.00  0.00           C  
ATOM   1351  OE1 GLU A  87      15.901   1.898  12.148  1.00  0.00           O  
ATOM   1352  OE2 GLU A  87      16.047   0.537  13.868  1.00  0.00           O  
ATOM   1353  H   GLU A  87      14.442  -2.167  11.480  1.00  0.00           H  
ATOM   1354  HA  GLU A  87      14.013   0.573  11.165  1.00  0.00           H  
ATOM   1355  HB2 GLU A  87      16.064  -1.206   9.834  1.00  0.00           H  
ATOM   1356  HB3 GLU A  87      16.120   0.551   9.845  1.00  0.00           H  
ATOM   1357  HG2 GLU A  87      16.341  -1.291  12.210  1.00  0.00           H  
ATOM   1358  HG3 GLU A  87      17.603  -0.270  11.522  1.00  0.00           H  
ATOM   1359  N   GLU A  88      13.373  -1.228   8.511  1.00  0.00           N  
ATOM   1360  CA  GLU A  88      12.750  -1.207   7.192  1.00  0.00           C  
ATOM   1361  C   GLU A  88      11.327  -0.663   7.271  1.00  0.00           C  
ATOM   1362  O   GLU A  88      10.970   0.273   6.556  1.00  0.00           O  
ATOM   1363  CB  GLU A  88      12.737  -2.614   6.588  1.00  0.00           C  
ATOM   1364  CG  GLU A  88      12.618  -2.624   5.073  1.00  0.00           C  
ATOM   1365  CD  GLU A  88      12.968  -3.970   4.470  1.00  0.00           C  
ATOM   1366  OE1 GLU A  88      14.171  -4.229   4.254  1.00  0.00           O  
ATOM   1367  OE2 GLU A  88      12.040  -4.764   4.213  1.00  0.00           O  
ATOM   1368  H   GLU A  88      13.614  -2.090   8.912  1.00  0.00           H  
ATOM   1369  HA  GLU A  88      13.337  -0.560   6.559  1.00  0.00           H  
ATOM   1370  HB2 GLU A  88      13.653  -3.118   6.860  1.00  0.00           H  
ATOM   1371  HB3 GLU A  88      11.901  -3.160   6.998  1.00  0.00           H  
ATOM   1372  HG2 GLU A  88      11.601  -2.379   4.804  1.00  0.00           H  
ATOM   1373  HG3 GLU A  88      13.286  -1.878   4.667  1.00  0.00           H  
ATOM   1374  N   MET A  89      10.520  -1.256   8.144  1.00  0.00           N  
ATOM   1375  CA  MET A  89       9.136  -0.830   8.318  1.00  0.00           C  
ATOM   1376  C   MET A  89       9.065   0.647   8.692  1.00  0.00           C  
ATOM   1377  O   MET A  89       8.118   1.344   8.329  1.00  0.00           O  
ATOM   1378  CB  MET A  89       8.450  -1.675   9.393  1.00  0.00           C  
ATOM   1379  CG  MET A  89       8.971  -1.410  10.797  1.00  0.00           C  
ATOM   1380  SD  MET A  89       7.732  -1.728  12.068  1.00  0.00           S  
ATOM   1381  CE  MET A  89       6.328  -0.836  11.403  1.00  0.00           C  
ATOM   1382  H   MET A  89      10.863  -1.997   8.686  1.00  0.00           H  
ATOM   1383  HA  MET A  89       8.625  -0.976   7.377  1.00  0.00           H  
ATOM   1384  HB2 MET A  89       7.392  -1.464   9.379  1.00  0.00           H  
ATOM   1385  HB3 MET A  89       8.606  -2.720   9.167  1.00  0.00           H  
ATOM   1386  HG2 MET A  89       9.822  -2.048  10.977  1.00  0.00           H  
ATOM   1387  HG3 MET A  89       9.278  -0.377  10.862  1.00  0.00           H  
ATOM   1388  HE1 MET A  89       6.671  -0.115  10.676  1.00  0.00           H  
ATOM   1389  HE2 MET A  89       5.652  -1.531  10.929  1.00  0.00           H  
ATOM   1390  HE3 MET A  89       5.816  -0.323  12.204  1.00  0.00           H  
ATOM   1391  N   GLY A  90      10.073   1.118   9.421  1.00  0.00           N  
ATOM   1392  CA  GLY A  90      10.104   2.509   9.832  1.00  0.00           C  
ATOM   1393  C   GLY A  90      10.270   3.457   8.661  1.00  0.00           C  
ATOM   1394  O   GLY A  90       9.816   4.599   8.709  1.00  0.00           O  
ATOM   1395  H   GLY A  90      10.801   0.515   9.681  1.00  0.00           H  
ATOM   1396  HA2 GLY A  90       9.182   2.742  10.343  1.00  0.00           H  
ATOM   1397  HA3 GLY A  90      10.928   2.651  10.515  1.00  0.00           H  
ATOM   1398  N   HIS A  91      10.926   2.982   7.606  1.00  0.00           N  
ATOM   1399  CA  HIS A  91      11.151   3.796   6.417  1.00  0.00           C  
ATOM   1400  C   HIS A  91       9.907   3.826   5.534  1.00  0.00           C  
ATOM   1401  O   HIS A  91       9.667   4.797   4.817  1.00  0.00           O  
ATOM   1402  CB  HIS A  91      12.342   3.256   5.623  1.00  0.00           C  
ATOM   1403  CG  HIS A  91      12.382   3.737   4.204  1.00  0.00           C  
ATOM   1404  ND1 HIS A  91      12.777   5.010   3.853  1.00  0.00           N  
ATOM   1405  CD2 HIS A  91      12.078   3.106   3.047  1.00  0.00           C  
ATOM   1406  CE1 HIS A  91      12.711   5.143   2.539  1.00  0.00           C  
ATOM   1407  NE2 HIS A  91      12.290   4.000   2.027  1.00  0.00           N  
ATOM   1408  H   HIS A  91      11.264   2.062   7.628  1.00  0.00           H  
ATOM   1409  HA  HIS A  91      11.372   4.802   6.741  1.00  0.00           H  
ATOM   1410  HB2 HIS A  91      13.258   3.566   6.104  1.00  0.00           H  
ATOM   1411  HB3 HIS A  91      12.296   2.177   5.607  1.00  0.00           H  
ATOM   1412  HD1 HIS A  91      13.061   5.714   4.473  1.00  0.00           H  
ATOM   1413  HD2 HIS A  91      11.731   2.087   2.943  1.00  0.00           H  
ATOM   1414  HE1 HIS A  91      12.960   6.032   1.981  1.00  0.00           H  
ATOM   1415  HE2 HIS A  91      12.071   3.853   1.084  1.00  0.00           H  
ATOM   1416  N   TRP A  92       9.121   2.757   5.592  1.00  0.00           N  
ATOM   1417  CA  TRP A  92       7.902   2.661   4.797  1.00  0.00           C  
ATOM   1418  C   TRP A  92       6.762   3.429   5.455  1.00  0.00           C  
ATOM   1419  O   TRP A  92       6.018   4.149   4.788  1.00  0.00           O  
ATOM   1420  CB  TRP A  92       7.505   1.196   4.609  1.00  0.00           C  
ATOM   1421  CG  TRP A  92       8.322   0.489   3.569  1.00  0.00           C  
ATOM   1422  CD1 TRP A  92       9.457  -0.242   3.777  1.00  0.00           C  
ATOM   1423  CD2 TRP A  92       8.066   0.447   2.161  1.00  0.00           C  
ATOM   1424  NE1 TRP A  92       9.922  -0.736   2.582  1.00  0.00           N  
ATOM   1425  CE2 TRP A  92       9.087  -0.328   1.576  1.00  0.00           C  
ATOM   1426  CE3 TRP A  92       7.074   0.987   1.338  1.00  0.00           C  
ATOM   1427  CZ2 TRP A  92       9.142  -0.573   0.206  1.00  0.00           C  
ATOM   1428  CZ3 TRP A  92       7.132   0.743  -0.021  1.00  0.00           C  
ATOM   1429  CH2 TRP A  92       8.158  -0.032  -0.575  1.00  0.00           C  
ATOM   1430  H   TRP A  92       9.366   2.014   6.183  1.00  0.00           H  
ATOM   1431  HA  TRP A  92       8.103   3.098   3.830  1.00  0.00           H  
ATOM   1432  HB2 TRP A  92       7.630   0.673   5.545  1.00  0.00           H  
ATOM   1433  HB3 TRP A  92       6.468   1.148   4.309  1.00  0.00           H  
ATOM   1434  HD1 TRP A  92       9.911  -0.398   4.743  1.00  0.00           H  
ATOM   1435  HE1 TRP A  92      10.723  -1.291   2.470  1.00  0.00           H  
ATOM   1436  HE3 TRP A  92       6.275   1.587   1.747  1.00  0.00           H  
ATOM   1437  HZ2 TRP A  92       9.928  -1.169  -0.236  1.00  0.00           H  
ATOM   1438  HZ3 TRP A  92       6.374   1.153  -0.672  1.00  0.00           H  
ATOM   1439  HH2 TRP A  92       8.163  -0.197  -1.642  1.00  0.00           H  
ATOM   1440  N   LEU A  93       6.628   3.272   6.768  1.00  0.00           N  
ATOM   1441  CA  LEU A  93       5.577   3.952   7.516  1.00  0.00           C  
ATOM   1442  C   LEU A  93       5.510   5.429   7.144  1.00  0.00           C  
ATOM   1443  O   LEU A  93       4.488   5.912   6.658  1.00  0.00           O  
ATOM   1444  CB  LEU A  93       5.818   3.804   9.020  1.00  0.00           C  
ATOM   1445  CG  LEU A  93       5.311   2.510   9.657  1.00  0.00           C  
ATOM   1446  CD1 LEU A  93       5.546   2.526  11.159  1.00  0.00           C  
ATOM   1447  CD2 LEU A  93       3.835   2.305   9.349  1.00  0.00           C  
ATOM   1448  H   LEU A  93       7.250   2.686   7.245  1.00  0.00           H  
ATOM   1449  HA  LEU A  93       4.636   3.486   7.263  1.00  0.00           H  
ATOM   1450  HB2 LEU A  93       6.881   3.863   9.192  1.00  0.00           H  
ATOM   1451  HB3 LEU A  93       5.328   4.631   9.515  1.00  0.00           H  
ATOM   1452  HG  LEU A  93       5.859   1.674   9.244  1.00  0.00           H  
ATOM   1453 HD11 LEU A  93       6.108   3.409  11.426  1.00  0.00           H  
ATOM   1454 HD12 LEU A  93       6.101   1.647  11.447  1.00  0.00           H  
ATOM   1455 HD13 LEU A  93       4.595   2.535  11.672  1.00  0.00           H  
ATOM   1456 HD21 LEU A  93       3.723   1.986   8.323  1.00  0.00           H  
ATOM   1457 HD22 LEU A  93       3.305   3.235   9.497  1.00  0.00           H  
ATOM   1458 HD23 LEU A  93       3.431   1.551  10.008  1.00  0.00           H  
ATOM   1459  N   GLY A  94       6.609   6.143   7.372  1.00  0.00           N  
ATOM   1460  CA  GLY A  94       6.654   7.558   7.052  1.00  0.00           C  
ATOM   1461  C   GLY A  94       6.622   7.815   5.559  1.00  0.00           C  
ATOM   1462  O   GLY A  94       6.041   8.802   5.103  1.00  0.00           O  
ATOM   1463  H   GLY A  94       7.394   5.704   7.761  1.00  0.00           H  
ATOM   1464  HA2 GLY A  94       5.807   8.047   7.510  1.00  0.00           H  
ATOM   1465  HA3 GLY A  94       7.563   7.977   7.458  1.00  0.00           H  
ATOM   1466  N   LEU A  95       7.248   6.928   4.793  1.00  0.00           N  
ATOM   1467  CA  LEU A  95       7.290   7.065   3.341  1.00  0.00           C  
ATOM   1468  C   LEU A  95       5.882   7.108   2.757  1.00  0.00           C  
ATOM   1469  O   LEU A  95       5.555   7.988   1.960  1.00  0.00           O  
ATOM   1470  CB  LEU A  95       8.076   5.907   2.723  1.00  0.00           C  
ATOM   1471  CG  LEU A  95       7.875   5.685   1.224  1.00  0.00           C  
ATOM   1472  CD1 LEU A  95       8.876   6.503   0.424  1.00  0.00           C  
ATOM   1473  CD2 LEU A  95       7.998   4.207   0.882  1.00  0.00           C  
ATOM   1474  H   LEU A  95       7.693   6.163   5.213  1.00  0.00           H  
ATOM   1475  HA  LEU A  95       7.791   7.993   3.110  1.00  0.00           H  
ATOM   1476  HB2 LEU A  95       9.126   6.093   2.891  1.00  0.00           H  
ATOM   1477  HB3 LEU A  95       7.786   5.001   3.235  1.00  0.00           H  
ATOM   1478  HG  LEU A  95       6.881   6.011   0.947  1.00  0.00           H  
ATOM   1479 HD11 LEU A  95       8.799   7.542   0.704  1.00  0.00           H  
ATOM   1480 HD12 LEU A  95       8.667   6.399  -0.631  1.00  0.00           H  
ATOM   1481 HD13 LEU A  95       9.876   6.148   0.628  1.00  0.00           H  
ATOM   1482 HD21 LEU A  95       7.772   4.060  -0.163  1.00  0.00           H  
ATOM   1483 HD22 LEU A  95       7.302   3.640   1.484  1.00  0.00           H  
ATOM   1484 HD23 LEU A  95       9.004   3.873   1.084  1.00  0.00           H  
ATOM   1485  N   LEU A  96       5.051   6.154   3.160  1.00  0.00           N  
ATOM   1486  CA  LEU A  96       3.676   6.082   2.679  1.00  0.00           C  
ATOM   1487  C   LEU A  96       2.841   7.229   3.242  1.00  0.00           C  
ATOM   1488  O   LEU A  96       2.164   7.941   2.500  1.00  0.00           O  
ATOM   1489  CB  LEU A  96       3.047   4.742   3.065  1.00  0.00           C  
ATOM   1490  CG  LEU A  96       3.653   3.503   2.405  1.00  0.00           C  
ATOM   1491  CD1 LEU A  96       3.271   2.248   3.176  1.00  0.00           C  
ATOM   1492  CD2 LEU A  96       3.203   3.397   0.955  1.00  0.00           C  
ATOM   1493  H   LEU A  96       5.368   5.479   3.797  1.00  0.00           H  
ATOM   1494  HA  LEU A  96       3.697   6.164   1.602  1.00  0.00           H  
ATOM   1495  HB2 LEU A  96       3.143   4.628   4.133  1.00  0.00           H  
ATOM   1496  HB3 LEU A  96       1.999   4.781   2.800  1.00  0.00           H  
ATOM   1497  HG  LEU A  96       4.731   3.586   2.418  1.00  0.00           H  
ATOM   1498 HD11 LEU A  96       2.201   2.116   3.143  1.00  0.00           H  
ATOM   1499 HD12 LEU A  96       3.591   2.346   4.203  1.00  0.00           H  
ATOM   1500 HD13 LEU A  96       3.754   1.390   2.730  1.00  0.00           H  
ATOM   1501 HD21 LEU A  96       3.950   3.842   0.315  1.00  0.00           H  
ATOM   1502 HD22 LEU A  96       2.265   3.917   0.830  1.00  0.00           H  
ATOM   1503 HD23 LEU A  96       3.078   2.357   0.693  1.00  0.00           H  
ATOM   1504  N   LEU A  97       2.898   7.403   4.558  1.00  0.00           N  
ATOM   1505  CA  LEU A  97       2.151   8.465   5.222  1.00  0.00           C  
ATOM   1506  C   LEU A  97       2.266   9.777   4.451  1.00  0.00           C  
ATOM   1507  O   LEU A  97       1.261  10.417   4.141  1.00  0.00           O  
ATOM   1508  CB  LEU A  97       2.656   8.655   6.653  1.00  0.00           C  
ATOM   1509  CG  LEU A  97       1.994   7.783   7.720  1.00  0.00           C  
ATOM   1510  CD1 LEU A  97       2.925   7.595   8.908  1.00  0.00           C  
ATOM   1511  CD2 LEU A  97       0.675   8.396   8.166  1.00  0.00           C  
ATOM   1512  H   LEU A  97       3.456   6.805   5.097  1.00  0.00           H  
ATOM   1513  HA  LEU A  97       1.112   8.170   5.252  1.00  0.00           H  
ATOM   1514  HB2 LEU A  97       3.713   8.441   6.660  1.00  0.00           H  
ATOM   1515  HB3 LEU A  97       2.498   9.689   6.924  1.00  0.00           H  
ATOM   1516  HG  LEU A  97       1.786   6.808   7.301  1.00  0.00           H  
ATOM   1517 HD11 LEU A  97       2.808   8.421   9.592  1.00  0.00           H  
ATOM   1518 HD12 LEU A  97       3.946   7.555   8.561  1.00  0.00           H  
ATOM   1519 HD13 LEU A  97       2.681   6.671   9.413  1.00  0.00           H  
ATOM   1520 HD21 LEU A  97       0.529   8.207   9.220  1.00  0.00           H  
ATOM   1521 HD22 LEU A  97      -0.136   7.951   7.606  1.00  0.00           H  
ATOM   1522 HD23 LEU A  97       0.694   9.461   7.989  1.00  0.00           H  
ATOM   1523  N   SER A  98       3.498  10.170   4.143  1.00  0.00           N  
ATOM   1524  CA  SER A  98       3.746  11.405   3.410  1.00  0.00           C  
ATOM   1525  C   SER A  98       2.922  11.450   2.127  1.00  0.00           C  
ATOM   1526  O   SER A  98       2.336  12.477   1.789  1.00  0.00           O  
ATOM   1527  CB  SER A  98       5.233  11.538   3.081  1.00  0.00           C  
ATOM   1528  OG  SER A  98       5.598  10.677   2.016  1.00  0.00           O  
ATOM   1529  H   SER A  98       4.258   9.616   4.419  1.00  0.00           H  
ATOM   1530  HA  SER A  98       3.451  12.230   4.043  1.00  0.00           H  
ATOM   1531  HB2 SER A  98       5.446  12.556   2.792  1.00  0.00           H  
ATOM   1532  HB3 SER A  98       5.817  11.281   3.952  1.00  0.00           H  
ATOM   1533  HG  SER A  98       6.305  10.093   2.305  1.00  0.00           H  
ATOM   1534  N   GLU A  99       2.885  10.327   1.416  1.00  0.00           N  
ATOM   1535  CA  GLU A  99       2.134  10.238   0.170  1.00  0.00           C  
ATOM   1536  C   GLU A  99       0.632  10.298   0.432  1.00  0.00           C  
ATOM   1537  O   GLU A  99      -0.099  11.015  -0.249  1.00  0.00           O  
ATOM   1538  CB  GLU A  99       2.483   8.944  -0.570  1.00  0.00           C  
ATOM   1539  CG  GLU A  99       3.966   8.787  -0.859  1.00  0.00           C  
ATOM   1540  CD  GLU A  99       4.539   9.966  -1.622  1.00  0.00           C  
ATOM   1541  OE1 GLU A  99       4.523  11.091  -1.079  1.00  0.00           O  
ATOM   1542  OE2 GLU A  99       5.004   9.764  -2.763  1.00  0.00           O  
ATOM   1543  H   GLU A  99       3.374   9.541   1.737  1.00  0.00           H  
ATOM   1544  HA  GLU A  99       2.414  11.079  -0.447  1.00  0.00           H  
ATOM   1545  HB2 GLU A  99       2.164   8.104   0.029  1.00  0.00           H  
ATOM   1546  HB3 GLU A  99       1.951   8.926  -1.510  1.00  0.00           H  
ATOM   1547  HG2 GLU A  99       4.495   8.695   0.079  1.00  0.00           H  
ATOM   1548  HG3 GLU A  99       4.114   7.893  -1.444  1.00  0.00           H  
ATOM   1549  N   SER A 100       0.181   9.538   1.425  1.00  0.00           N  
ATOM   1550  CA  SER A 100      -1.234   9.500   1.776  1.00  0.00           C  
ATOM   1551  C   SER A 100      -1.643  10.768   2.520  1.00  0.00           C  
ATOM   1552  O   SER A 100      -1.765  10.772   3.744  1.00  0.00           O  
ATOM   1553  CB  SER A 100      -1.535   8.272   2.637  1.00  0.00           C  
ATOM   1554  OG  SER A 100      -0.893   8.362   3.896  1.00  0.00           O  
ATOM   1555  H   SER A 100       0.815   8.988   1.932  1.00  0.00           H  
ATOM   1556  HA  SER A 100      -1.801   9.436   0.860  1.00  0.00           H  
ATOM   1557  HB2 SER A 100      -2.601   8.198   2.794  1.00  0.00           H  
ATOM   1558  HB3 SER A 100      -1.183   7.385   2.129  1.00  0.00           H  
ATOM   1559  HG  SER A 100      -0.829   7.487   4.286  1.00  0.00           H  
ATOM   1560  N   GLY A 101      -1.853  11.845   1.769  1.00  0.00           N  
ATOM   1561  CA  GLY A 101      -2.245  13.106   2.373  1.00  0.00           C  
ATOM   1562  C   GLY A 101      -1.292  14.233   2.032  1.00  0.00           C  
ATOM   1563  O   GLY A 101      -0.302  14.451   2.731  1.00  0.00           O  
ATOM   1564  H   GLY A 101      -1.741  11.784   0.798  1.00  0.00           H  
ATOM   1565  HA2 GLY A 101      -3.234  13.366   2.026  1.00  0.00           H  
ATOM   1566  HA3 GLY A 101      -2.272  12.984   3.446  1.00  0.00           H  
ATOM   1567  N   SER A 102      -1.589  14.952   0.954  1.00  0.00           N  
ATOM   1568  CA  SER A 102      -0.748  16.061   0.519  1.00  0.00           C  
ATOM   1569  C   SER A 102      -1.527  17.011  -0.385  1.00  0.00           C  
ATOM   1570  O   SER A 102      -2.311  16.581  -1.229  1.00  0.00           O  
ATOM   1571  CB  SER A 102       0.485  15.534  -0.217  1.00  0.00           C  
ATOM   1572  OG  SER A 102       1.243  14.669   0.610  1.00  0.00           O  
ATOM   1573  H   SER A 102      -2.392  14.730   0.438  1.00  0.00           H  
ATOM   1574  HA  SER A 102      -0.428  16.600   1.399  1.00  0.00           H  
ATOM   1575  HB2 SER A 102       0.171  14.989  -1.095  1.00  0.00           H  
ATOM   1576  HB3 SER A 102       1.107  16.367  -0.515  1.00  0.00           H  
ATOM   1577  HG  SER A 102       2.139  14.602   0.268  1.00  0.00           H  
ATOM   1578  N   GLY A 103      -1.304  18.309  -0.201  1.00  0.00           N  
ATOM   1579  CA  GLY A 103      -1.991  19.302  -1.006  1.00  0.00           C  
ATOM   1580  C   GLY A 103      -2.781  20.286  -0.164  1.00  0.00           C  
ATOM   1581  O   GLY A 103      -2.460  20.537   0.998  1.00  0.00           O  
ATOM   1582  H   GLY A 103      -0.667  18.595   0.488  1.00  0.00           H  
ATOM   1583  HA2 GLY A 103      -1.262  19.845  -1.587  1.00  0.00           H  
ATOM   1584  HA3 GLY A 103      -2.669  18.797  -1.678  1.00  0.00           H  
ATOM   1585  N   PRO A 104      -3.836  20.862  -0.755  1.00  0.00           N  
ATOM   1586  CA  PRO A 104      -4.695  21.834  -0.070  1.00  0.00           C  
ATOM   1587  C   PRO A 104      -5.536  21.192   1.028  1.00  0.00           C  
ATOM   1588  O   PRO A 104      -6.349  21.858   1.669  1.00  0.00           O  
ATOM   1589  CB  PRO A 104      -5.593  22.365  -1.191  1.00  0.00           C  
ATOM   1590  CG  PRO A 104      -5.625  21.271  -2.201  1.00  0.00           C  
ATOM   1591  CD  PRO A 104      -4.276  20.609  -2.138  1.00  0.00           C  
ATOM   1592  HA  PRO A 104      -4.118  22.647   0.347  1.00  0.00           H  
ATOM   1593  HB2 PRO A 104      -6.580  22.569  -0.797  1.00  0.00           H  
ATOM   1594  HB3 PRO A 104      -5.168  23.268  -1.600  1.00  0.00           H  
ATOM   1595  HG2 PRO A 104      -6.402  20.564  -1.953  1.00  0.00           H  
ATOM   1596  HG3 PRO A 104      -5.793  21.685  -3.184  1.00  0.00           H  
ATOM   1597  HD2 PRO A 104      -4.367  19.549  -2.326  1.00  0.00           H  
ATOM   1598  HD3 PRO A 104      -3.600  21.063  -2.846  1.00  0.00           H  
ATOM   1599  N   SER A 105      -5.334  19.896   1.240  1.00  0.00           N  
ATOM   1600  CA  SER A 105      -6.076  19.164   2.259  1.00  0.00           C  
ATOM   1601  C   SER A 105      -5.152  18.715   3.388  1.00  0.00           C  
ATOM   1602  O   SER A 105      -4.272  17.878   3.190  1.00  0.00           O  
ATOM   1603  CB  SER A 105      -6.770  17.949   1.641  1.00  0.00           C  
ATOM   1604  OG  SER A 105      -7.695  17.374   2.547  1.00  0.00           O  
ATOM   1605  H   SER A 105      -4.671  19.420   0.697  1.00  0.00           H  
ATOM   1606  HA  SER A 105      -6.824  19.827   2.665  1.00  0.00           H  
ATOM   1607  HB2 SER A 105      -7.299  18.254   0.751  1.00  0.00           H  
ATOM   1608  HB3 SER A 105      -6.029  17.207   1.383  1.00  0.00           H  
ATOM   1609  HG  SER A 105      -7.326  17.388   3.434  1.00  0.00           H  
ATOM   1610  N   SER A 106      -5.359  19.281   4.573  1.00  0.00           N  
ATOM   1611  CA  SER A 106      -4.543  18.943   5.734  1.00  0.00           C  
ATOM   1612  C   SER A 106      -3.122  19.476   5.571  1.00  0.00           C  
ATOM   1613  O   SER A 106      -2.149  18.775   5.849  1.00  0.00           O  
ATOM   1614  CB  SER A 106      -4.512  17.427   5.939  1.00  0.00           C  
ATOM   1615  OG  SER A 106      -4.239  17.102   7.290  1.00  0.00           O  
ATOM   1616  H   SER A 106      -6.076  19.942   4.669  1.00  0.00           H  
ATOM   1617  HA  SER A 106      -4.991  19.406   6.600  1.00  0.00           H  
ATOM   1618  HB2 SER A 106      -5.469  17.010   5.666  1.00  0.00           H  
ATOM   1619  HB3 SER A 106      -3.740  16.999   5.315  1.00  0.00           H  
ATOM   1620  HG  SER A 106      -4.756  16.333   7.545  1.00  0.00           H  
ATOM   1621  N   GLY A 107      -3.011  20.721   5.120  1.00  0.00           N  
ATOM   1622  CA  GLY A 107      -1.706  21.327   4.928  1.00  0.00           C  
ATOM   1623  C   GLY A 107      -1.790  22.823   4.697  1.00  0.00           C  
ATOM   1624  O   GLY A 107      -1.506  23.613   5.598  1.00  0.00           O  
ATOM   1625  H   GLY A 107      -3.822  21.233   4.915  1.00  0.00           H  
ATOM   1626  HA2 GLY A 107      -1.102  21.141   5.804  1.00  0.00           H  
ATOM   1627  HA3 GLY A 107      -1.232  20.869   4.072  1.00  0.00           H  
TER    1628      GLY A 107                                                      
END
MOLECULE T0472.pdb
ATOM      1  N   MET     1       9.133  12.968  -2.784  1.00 43.14           N  
ATOM      2  CA  MET     1       8.345  11.878  -3.427  1.00 43.44           C  
ATOM      3  C   MET     1       9.259  10.975  -4.276  1.00  1.32           C  
ATOM      4  O   MET     1       9.403  11.181  -5.480  1.00  4.13           O  
ATOM      5  CB  MET     1       7.231  12.463  -4.311  1.00 41.12           C  
ATOM      6  CG  MET     1       6.300  13.433  -3.593  1.00 70.41           C  
ATOM      7  SD  MET     1       5.023  14.089  -4.687  1.00 54.53           S  
ATOM      8  CE  MET     1       4.245  15.300  -3.619  1.00 10.43           C  
ATOM      9  H1  MET     1       9.887  12.563  -2.191  1.00 37.41           H  
ATOM     10  H2  MET     1       8.518  13.561  -2.186  1.00 37.41           H  
ATOM     11  H3  MET     1       9.573  13.572  -3.511  1.00 37.41           H  
ATOM     12  HA  MET     1       7.898  11.280  -2.643  1.00 10.24           H  
ATOM     13  HB2 MET     1       7.684  12.989  -5.139  1.00 37.41           H  
ATOM     14  HB3 MET     1       6.634  11.650  -4.700  1.00 37.41           H  
ATOM     15  HG2 MET     1       5.821  12.916  -2.774  1.00 37.41           H  
ATOM     16  HG3 MET     1       6.883  14.256  -3.206  1.00 37.41           H  
ATOM     17  HE1 MET     1       3.845  14.807  -2.744  1.00 37.41           H  
ATOM     18  HE2 MET     1       3.443  15.788  -4.154  1.00 37.41           H  
ATOM     19  HE3 MET     1       4.974  16.037  -3.314  1.00 37.41           H  
ATOM     20  N   SER     2       9.886   9.990  -3.637  1.00 63.42           N  
ATOM     21  CA  SER     2      10.874   9.125  -4.307  1.00 41.35           C  
ATOM     22  C   SER     2      10.235   7.904  -4.990  1.00 44.41           C  
ATOM     23  O   SER     2      10.859   7.263  -5.836  1.00 64.32           O  
ATOM     24  CB  SER     2      11.923   8.645  -3.291  1.00 62.12           C  
ATOM     25  OG  SER     2      12.574   9.740  -2.656  1.00  2.50           O  
ATOM     26  H   SER     2       9.701   9.848  -2.682  1.00 37.41           H  
ATOM     27  HA  SER     2      11.374   9.718  -5.061  1.00 54.33           H  
ATOM     28  HB2 SER     2      11.439   8.046  -2.533  1.00 37.41           H  
ATOM     29  HB3 SER     2      12.668   8.046  -3.798  1.00 37.41           H  
ATOM     30  HG  SER     2      12.000  10.099  -1.964  1.00  4.15           H  
ATOM     31  N   GLY     3       8.992   7.593  -4.637  1.00 75.03           N  
ATOM     32  CA  GLY     3       8.365   6.357  -5.110  1.00 53.14           C  
ATOM     33  C   GLY     3       7.171   6.559  -6.038  1.00 60.02           C  
ATOM     34  O   GLY     3       6.764   7.688  -6.319  1.00 54.15           O  
ATOM     35  H   GLY     3       8.494   8.202  -4.062  1.00 37.41           H  
ATOM     36  HA2 GLY     3       9.107   5.767  -5.632  1.00 37.41           H  
ATOM     37  HA3 GLY     3       8.034   5.797  -4.247  1.00 37.41           H  
ATOM     38  N   TRP     4       6.603   5.443  -6.503  1.00 62.23           N  
ATOM     39  CA  TRP     4       5.490   5.464  -7.462  1.00 53.24           C  
ATOM     40  C   TRP     4       4.594   4.222  -7.304  1.00 54.24           C  
ATOM     41  O   TRP     4       4.936   3.281  -6.579  1.00 44.23           O  
ATOM     42  CB  TRP     4       6.036   5.524  -8.896  1.00 10.44           C  
ATOM     43  CG  TRP     4       6.747   4.270  -9.314  1.00 32.04           C  
ATOM     44  CD1 TRP     4       6.224   3.237 -10.039  1.00 71.44           C  
ATOM     45  CD2 TRP     4       8.100   3.905  -9.018  1.00 13.20           C  
ATOM     46  NE1 TRP     4       7.168   2.263 -10.217  1.00 61.42           N  
ATOM     47  CE2 TRP     4       8.328   2.647  -9.600  1.00 45.30           C  
ATOM     48  CE3 TRP     4       9.142   4.523  -8.318  1.00 25.24           C  
ATOM     49  CZ2 TRP     4       9.553   1.991  -9.506  1.00 52.13           C  
ATOM     50  CZ3 TRP     4      10.358   3.871  -8.226  1.00 73.25           C  
ATOM     51  CH2 TRP     4      10.554   2.618  -8.816  1.00  5.23           C  
ATOM     52  H   TRP     4       6.940   4.580  -6.189  1.00 37.41           H  
ATOM     53  HA  TRP     4       4.900   6.348  -7.272  1.00 54.13           H  
ATOM     54  HB2 TRP     4       5.218   5.690  -9.581  1.00 37.41           H  
ATOM     55  HB3 TRP     4       6.735   6.347  -8.976  1.00 37.41           H  
ATOM     56  HD1 TRP     4       5.211   3.205 -10.413  1.00 41.45           H  
ATOM     57  HE1 TRP     4       7.034   1.429 -10.712  1.00 73.22           H  
ATOM     58  HE3 TRP     4       9.009   5.490  -7.857  1.00 10.05           H  
ATOM     59  HZ2 TRP     4       9.714   1.021  -9.952  1.00 70.05           H  
ATOM     60  HZ3 TRP     4      11.174   4.331  -7.688  1.00 24.30           H  
ATOM     61  HH2 TRP     4      11.521   2.146  -8.716  1.00 52.45           H  
ATOM     62  N   TYR     5       3.460   4.218  -8.005  1.00 42.30           N  
ATOM     63  CA  TYR     5       2.510   3.097  -7.957  1.00 50.41           C  
ATOM     64  C   TYR     5       2.527   2.271  -9.253  1.00 31.42           C  
ATOM     65  O   TYR     5       2.631   2.816 -10.353  1.00 52.13           O  
ATOM     66  CB  TYR     5       1.087   3.616  -7.708  1.00 22.52           C  
ATOM     67  CG  TYR     5       0.862   4.157  -6.310  1.00 11.51           C  
ATOM     68  CD1 TYR     5       1.120   5.489  -6.002  1.00 21.33           C  
ATOM     69  CD2 TYR     5       0.384   3.331  -5.298  1.00 41.02           C  
ATOM     70  CE1 TYR     5       0.911   5.979  -4.726  1.00  4.11           C  
ATOM     71  CE2 TYR     5       0.172   3.815  -4.022  1.00  0.53           C  
ATOM     72  CZ  TYR     5       0.438   5.138  -3.742  1.00 23.25           C  
ATOM     73  OH  TYR     5       0.230   5.621  -2.472  1.00  1.02           O  
ATOM     74  H   TYR     5       3.255   4.990  -8.575  1.00 37.41           H  
ATOM     75  HA  TYR     5       2.793   2.454  -7.135  1.00 50.15           H  
ATOM     76  HB2 TYR     5       0.876   4.411  -8.408  1.00 37.41           H  
ATOM     77  HB3 TYR     5       0.384   2.809  -7.870  1.00 37.41           H  
ATOM     78  HD1 TYR     5       1.491   6.147  -6.776  1.00 42.22           H  
ATOM     79  HD2 TYR     5       0.177   2.292  -5.519  1.00 61.25           H  
ATOM     80  HE1 TYR     5       1.118   7.016  -4.506  1.00 44.53           H  
ATOM     81  HE2 TYR     5      -0.199   3.156  -3.251  1.00 11.50           H  
ATOM     82  HH  TYR     5      -0.161   6.501  -2.521  1.00 40.41           H  
ATOM     83  N   GLU     6       2.420   0.953  -9.109  1.00  1.12           N  
ATOM     84  CA  GLU     6       2.292   0.035 -10.252  1.00 73.13           C  
ATOM     85  C   GLU     6       1.107  -0.924 -10.061  1.00 15.03           C  
ATOM     86  O   GLU     6       1.108  -1.750  -9.148  1.00 55.41           O  
ATOM     87  CB  GLU     6       3.585  -0.776 -10.446  1.00 14.14           C  
ATOM     88  CG  GLU     6       4.684  -0.030 -11.196  1.00 40.20           C  
ATOM     89  CD  GLU     6       6.000  -0.797 -11.250  1.00 32.34           C  
ATOM     90  OE1 GLU     6       6.043  -1.972 -10.832  1.00 42.31           O  
ATOM     91  OE2 GLU     6       7.020  -0.206 -11.660  1.00 43.22           O  
ATOM     92  H   GLU     6       2.436   0.578  -8.203  1.00 37.41           H  
ATOM     93  HA  GLU     6       2.114   0.630 -11.139  1.00 53.04           H  
ATOM     94  HB2 GLU     6       3.969  -1.047  -9.474  1.00 37.41           H  
ATOM     95  HB3 GLU     6       3.355  -1.679 -10.995  1.00 37.41           H  
ATOM     96  HG2 GLU     6       4.351   0.150 -12.208  1.00 37.41           H  
ATOM     97  HG3 GLU     6       4.857   0.916 -10.703  1.00 37.41           H  
ATOM     98  N   LEU     7       0.099  -0.804 -10.920  1.00 51.22           N  
ATOM     99  CA  LEU     7      -1.074  -1.684 -10.880  1.00 22.02           C  
ATOM    100  C   LEU     7      -0.897  -2.873 -11.835  1.00 44.25           C  
ATOM    101  O   LEU     7      -0.622  -2.686 -13.018  1.00 73.34           O  
ATOM    102  CB  LEU     7      -2.338  -0.908 -11.275  1.00 53.12           C  
ATOM    103  CG  LEU     7      -3.639  -1.730 -11.252  1.00 55.32           C  
ATOM    104  CD1 LEU     7      -4.047  -2.070  -9.820  1.00  5.11           C  
ATOM    105  CD2 LEU     7      -4.758  -0.992 -11.979  1.00 32.15           C  
ATOM    106  H   LEU     7       0.145  -0.106 -11.607  1.00 37.41           H  
ATOM    107  HA  LEU     7      -1.186  -2.053  -9.870  1.00 64.54           H  
ATOM    108  HB2 LEU     7      -2.450  -0.071 -10.597  1.00 37.41           H  
ATOM    109  HB3 LEU     7      -2.199  -0.521 -12.276  1.00 37.41           H  
ATOM    110  HG  LEU     7      -3.469  -2.663 -11.773  1.00  3.12           H  
ATOM    111 HD11 LEU     7      -4.968  -2.635  -9.832  1.00 37.41           H  
ATOM    112 HD12 LEU     7      -4.193  -1.158  -9.258  1.00 37.41           H  
ATOM    113 HD13 LEU     7      -3.270  -2.659  -9.353  1.00 37.41           H  
ATOM    114 HD21 LEU     7      -4.922  -0.031 -11.513  1.00 37.41           H  
ATOM    115 HD22 LEU     7      -5.664  -1.577 -11.930  1.00 37.41           H  
ATOM    116 HD23 LEU     7      -4.479  -0.850 -13.013  1.00 37.41           H  
ATOM    117  N   SER     8      -1.082  -4.093 -11.338  1.00 53.24           N  
ATOM    118  CA  SER     8      -0.905  -5.294 -12.171  1.00 31.23           C  
ATOM    119  C   SER     8      -2.098  -6.253 -12.064  1.00  3.22           C  
ATOM    120  O   SER     8      -2.856  -6.221 -11.093  1.00  4.32           O  
ATOM    121  CB  SER     8       0.387  -6.029 -11.787  1.00 22.41           C  
ATOM    122  OG  SER     8       0.365  -6.445 -10.429  1.00 32.24           O  
ATOM    123  H   SER     8      -1.343  -4.193 -10.399  1.00 37.41           H  
ATOM    124  HA  SER     8      -0.827  -4.968 -13.201  1.00  5.52           H  
ATOM    125  HB2 SER     8       0.503  -6.901 -12.413  1.00 37.41           H  
ATOM    126  HB3 SER     8       1.230  -5.369 -11.934  1.00 37.41           H  
ATOM    127  HG  SER     8       0.420  -5.670  -9.855  1.00 21.24           H  
ATOM    128  N   LYS     9      -2.262  -7.100 -13.083  1.00 41.30           N  
ATOM    129  CA  LYS     9      -3.341  -8.094 -13.117  1.00  1.00           C  
ATOM    130  C   LYS     9      -2.853  -9.472 -12.635  1.00 12.02           C  
ATOM    131  O   LYS     9      -1.749  -9.905 -12.965  1.00 63.01           O  
ATOM    132  CB  LYS     9      -3.907  -8.213 -14.543  1.00 61.51           C  
ATOM    133  CG  LYS     9      -4.926  -9.340 -14.712  1.00 32.33           C  
ATOM    134  CD  LYS     9      -5.360  -9.520 -16.166  1.00 51.24           C  
ATOM    135  CE  LYS     9      -6.254  -8.383 -16.648  1.00 54.22           C  
ATOM    136  NZ  LYS     9      -7.603  -8.424 -16.015  1.00  4.21           N  
ATOM    137  H   LYS     9      -1.635  -7.058 -13.834  1.00 37.41           H  
ATOM    138  HA  LYS     9      -4.129  -7.754 -12.456  1.00  4.52           H  
ATOM    139  HB2 LYS     9      -4.388  -7.280 -14.804  1.00 37.41           H  
ATOM    140  HB3 LYS     9      -3.089  -8.389 -15.229  1.00 37.41           H  
ATOM    141  HG2 LYS     9      -4.483 -10.264 -14.367  1.00 37.41           H  
ATOM    142  HG3 LYS     9      -5.797  -9.117 -14.110  1.00 37.41           H  
ATOM    143  HD2 LYS     9      -4.481  -9.560 -16.793  1.00 37.41           H  
ATOM    144  HD3 LYS     9      -5.904 -10.452 -16.252  1.00 37.41           H  
ATOM    145  HE2 LYS     9      -5.784  -7.440 -16.411  1.00 37.41           H  
ATOM    146  HE3 LYS     9      -6.370  -8.464 -17.721  1.00 37.41           H  
ATOM    147  HZ1 LYS     9      -7.523  -8.381 -14.981  1.00 37.41           H  
ATOM    148  HZ2 LYS     9      -8.096  -9.303 -16.277  1.00 37.41           H  
ATOM    149  HZ3 LYS     9      -8.176  -7.617 -16.339  1.00 37.41           H  
ATOM    150  N   SER    10      -3.690 -10.150 -11.857  1.00 65.03           N  
ATOM    151  CA  SER    10      -3.397 -11.504 -11.370  1.00 12.31           C  
ATOM    152  C   SER    10      -4.045 -12.568 -12.267  1.00 71.11           C  
ATOM    153  O   SER    10      -4.752 -12.244 -13.222  1.00 21.42           O  
ATOM    154  CB  SER    10      -3.901 -11.663  -9.930  1.00 51.44           C  
ATOM    155  OG  SER    10      -3.702 -12.985  -9.453  1.00 44.32           O  
ATOM    156  H   SER    10      -4.536  -9.729 -11.601  1.00 37.41           H  
ATOM    157  HA  SER    10      -2.324 -11.642 -11.386  1.00 20.04           H  
ATOM    158  HB2 SER    10      -3.365 -10.981  -9.286  1.00 37.41           H  
ATOM    159  HB3 SER    10      -4.956 -11.436  -9.894  1.00 37.41           H  
ATOM    160  HG  SER    10      -3.002 -12.984  -8.787  1.00 52.12           H  
ATOM    161  N   SER    11      -3.824 -13.840 -11.940  1.00 53.25           N  
ATOM    162  CA  SER    11      -4.365 -14.958 -12.731  1.00 71.22           C  
ATOM    163  C   SER    11      -5.902 -14.955 -12.751  1.00 61.02           C  
ATOM    164  O   SER    11      -6.521 -15.438 -13.700  1.00 23.10           O  
ATOM    165  CB  SER    11      -3.860 -16.297 -12.177  1.00  2.01           C  
ATOM    166  OG  SER    11      -4.259 -16.475 -10.828  1.00 23.05           O  
ATOM    167  H   SER    11      -3.289 -14.037 -11.141  1.00 37.41           H  
ATOM    168  HA  SER    11      -4.009 -14.845 -13.746  1.00 14.14           H  
ATOM    169  HB2 SER    11      -4.265 -17.106 -12.768  1.00 37.41           H  
ATOM    170  HB3 SER    11      -2.782 -16.322 -12.225  1.00 37.41           H  
ATOM    171  HG  SER    11      -3.986 -17.352 -10.525  1.00 23.22           H  
ATOM    172  N   ASN    12      -6.515 -14.408 -11.700  1.00 44.53           N  
ATOM    173  CA  ASN    12      -7.983 -14.299 -11.614  1.00 72.42           C  
ATOM    174  C   ASN    12      -8.499 -13.016 -12.289  1.00 55.44           C  
ATOM    175  O   ASN    12      -9.666 -12.652 -12.137  1.00 71.03           O  
ATOM    176  CB  ASN    12      -8.429 -14.300 -10.146  1.00 11.22           C  
ATOM    177  CG  ASN    12      -7.960 -15.522  -9.387  1.00 12.42           C  
ATOM    178  OD1 ASN    12      -7.781 -16.594  -9.957  1.00 23.32           O  
ATOM    179  ND2 ASN    12      -7.765 -15.376  -8.092  1.00 33.33           N  
ATOM    180  H   ASN    12      -5.968 -14.085 -10.951  1.00 37.41           H  
ATOM    181  HA  ASN    12      -8.414 -15.156 -12.111  1.00 44.30           H  
ATOM    182  HB2 ASN    12      -8.032 -13.422  -9.655  1.00 37.41           H  
ATOM    183  HB3 ASN    12      -9.509 -14.270 -10.103  1.00 37.41           H  
ATOM    184 HD21 ASN    12      -7.934 -14.496  -7.693  1.00 37.41           H  
ATOM    185 HD22 ASN    12      -7.463 -16.156  -7.583  1.00 37.41           H  
ATOM    186  N   ASP    13      -7.615 -12.331 -13.021  1.00 50.41           N  
ATOM    187  CA  ASP    13      -7.914 -11.021 -13.626  1.00 62.51           C  
ATOM    188  C   ASP    13      -8.024  -9.907 -12.568  1.00 12.43           C  
ATOM    189  O   ASP    13      -8.190  -8.735 -12.913  1.00 50.44           O  
ATOM    190  CB  ASP    13      -9.186 -11.065 -14.493  1.00 13.34           C  
ATOM    191  CG  ASP    13      -8.954 -11.755 -15.823  1.00 73.13           C  
ATOM    192  OD1 ASP    13      -8.463 -11.087 -16.760  1.00 10.25           O  
ATOM    193  OD2 ASP    13      -9.254 -12.964 -15.938  1.00 60.13           O  
ATOM    194  H   ASP    13      -6.725 -12.718 -13.165  1.00 37.41           H  
ATOM    195  HA  ASP    13      -7.078 -10.779 -14.267  1.00 70.42           H  
ATOM    196  HB2 ASP    13      -9.962 -11.595 -13.960  1.00 37.41           H  
ATOM    197  HB3 ASP    13      -9.520 -10.054 -14.686  1.00 37.41           H  
ATOM    198  N   GLN    14      -7.900 -10.275 -11.292  1.00 32.13           N  
ATOM    199  CA  GLN    14      -7.973  -9.309 -10.191  1.00 61.21           C  
ATOM    200  C   GLN    14      -6.763  -8.367 -10.199  1.00 42.43           C  
ATOM    201  O   GLN    14      -5.650  -8.771 -10.534  1.00 44.04           O  
ATOM    202  CB  GLN    14      -8.056 -10.042  -8.848  1.00 55.01           C  
ATOM    203  CG  GLN    14      -9.291 -10.920  -8.699  1.00 41.00           C  
ATOM    204  CD  GLN    14      -9.368 -11.589  -7.339  1.00 63.31           C  
ATOM    205  OE1 GLN    14      -8.861 -12.691  -7.139  1.00 40.21           O  
ATOM    206  NE2 GLN    14      -9.989 -10.919  -6.388  1.00 52.14           N  
ATOM    207  H   GLN    14      -7.752 -11.216 -11.085  1.00 37.41           H  
ATOM    208  HA  GLN    14      -8.873  -8.721 -10.324  1.00 31.13           H  
ATOM    209  HB2 GLN    14      -7.182 -10.668  -8.739  1.00 37.41           H  
ATOM    210  HB3 GLN    14      -8.063  -9.309  -8.050  1.00 37.41           H  
ATOM    211  HG2 GLN    14     -10.173 -10.309  -8.835  1.00 37.41           H  
ATOM    212  HG3 GLN    14      -9.267 -11.687  -9.461  1.00 37.41           H  
ATOM    213 HE21 GLN    14     -10.356 -10.040  -6.606  1.00 37.41           H  
ATOM    214 HE22 GLN    14     -10.067 -11.336  -5.507  1.00 37.41           H  
ATOM    215  N   PHE    15      -6.984  -7.119  -9.814  1.00 34.33           N  
ATOM    216  CA  PHE    15      -5.946  -6.088  -9.886  1.00 11.02           C  
ATOM    217  C   PHE    15      -5.339  -5.799  -8.506  1.00 12.22           C  
ATOM    218  O   PHE    15      -6.057  -5.669  -7.517  1.00  5.21           O  
ATOM    219  CB  PHE    15      -6.550  -4.800 -10.462  1.00 74.34           C  
ATOM    220  CG  PHE    15      -7.348  -5.021 -11.726  1.00 43.43           C  
ATOM    221  CD1 PHE    15      -6.715  -5.122 -12.954  1.00 11.24           C  
ATOM    222  CD2 PHE    15      -8.732  -5.131 -11.680  1.00 33.13           C  
ATOM    223  CE1 PHE    15      -7.443  -5.326 -14.110  1.00 51.03           C  
ATOM    224  CE2 PHE    15      -9.463  -5.335 -12.835  1.00  2.13           C  
ATOM    225  CZ  PHE    15      -8.818  -5.432 -14.050  1.00 45.41           C  
ATOM    226  H   PHE    15      -7.868  -6.879  -9.467  1.00 37.41           H  
ATOM    227  HA  PHE    15      -5.167  -6.437 -10.549  1.00 73.33           H  
ATOM    228  HB2 PHE    15      -7.207  -4.356  -9.725  1.00 37.41           H  
ATOM    229  HB3 PHE    15      -5.753  -4.104 -10.686  1.00 37.41           H  
ATOM    230  HD1 PHE    15      -5.639  -5.040 -13.004  1.00 42.24           H  
ATOM    231  HD2 PHE    15      -9.239  -5.057 -10.729  1.00 24.11           H  
ATOM    232  HE1 PHE    15      -6.938  -5.402 -15.060  1.00 73.33           H  
ATOM    233  HE2 PHE    15     -10.539  -5.417 -12.786  1.00 13.42           H  
ATOM    234  HZ  PHE    15      -9.388  -5.589 -14.953  1.00 71.34           H  
ATOM    235  N   LYS    16      -4.013  -5.695  -8.446  1.00 31.41           N  
ATOM    236  CA  LYS    16      -3.332  -5.276  -7.216  1.00 15.33           C  
ATOM    237  C   LYS    16      -2.193  -4.297  -7.539  1.00  4.33           C  
ATOM    238  O   LYS    16      -1.420  -4.510  -8.477  1.00 10.15           O  
ATOM    239  CB  LYS    16      -2.802  -6.487  -6.416  1.00 42.11           C  
ATOM    240  CG  LYS    16      -1.604  -7.217  -7.030  1.00 31.14           C  
ATOM    241  CD  LYS    16      -1.976  -8.053  -8.255  1.00 13.43           C  
ATOM    242  CE  LYS    16      -0.779  -8.849  -8.774  1.00 54.14           C  
ATOM    243  NZ  LYS    16      -0.218  -9.756  -7.733  1.00 10.20           N  
ATOM    244  H   LYS    16      -3.479  -5.908  -9.244  1.00 37.41           H  
ATOM    245  HA  LYS    16      -4.059  -4.752  -6.607  1.00 12.31           H  
ATOM    246  HB2 LYS    16      -2.508  -6.144  -5.433  1.00 37.41           H  
ATOM    247  HB3 LYS    16      -3.608  -7.198  -6.302  1.00 37.41           H  
ATOM    248  HG2 LYS    16      -0.865  -6.486  -7.324  1.00 37.41           H  
ATOM    249  HG3 LYS    16      -1.177  -7.871  -6.280  1.00 37.41           H  
ATOM    250  HD2 LYS    16      -2.762  -8.742  -7.982  1.00 37.41           H  
ATOM    251  HD3 LYS    16      -2.328  -7.394  -9.037  1.00 37.41           H  
ATOM    252  HE2 LYS    16      -1.095  -9.442  -9.619  1.00 37.41           H  
ATOM    253  HE3 LYS    16      -0.010  -8.159  -9.088  1.00 37.41           H  
ATOM    254  HZ1 LYS    16      -0.943 -10.432  -7.415  1.00 37.41           H  
ATOM    255  HZ2 LYS    16       0.107  -9.206  -6.912  1.00 37.41           H  
ATOM    256  HZ3 LYS    16       0.589 -10.290  -8.116  1.00 37.41           H  
ATOM    257  N   PHE    17      -2.108  -3.208  -6.777  1.00 74.03           N  
ATOM    258  CA  PHE    17      -1.075  -2.191  -7.000  1.00 53.02           C  
ATOM    259  C   PHE    17      -0.005  -2.223  -5.901  1.00 30.43           C  
ATOM    260  O   PHE    17      -0.299  -2.478  -4.730  1.00 23.23           O  
ATOM    261  CB  PHE    17      -1.699  -0.787  -7.109  1.00 61.40           C  
ATOM    262  CG  PHE    17      -2.509  -0.354  -5.908  1.00 22.44           C  
ATOM    263  CD1 PHE    17      -3.851  -0.698  -5.797  1.00 25.42           C  
ATOM    264  CD2 PHE    17      -1.934   0.413  -4.902  1.00 11.02           C  
ATOM    265  CE1 PHE    17      -4.599  -0.289  -4.707  1.00  3.25           C  
ATOM    266  CE2 PHE    17      -2.679   0.826  -3.812  1.00 61.51           C  
ATOM    267  CZ  PHE    17      -4.013   0.475  -3.714  1.00 53.33           C  
ATOM    268  H   PHE    17      -2.748  -3.087  -6.047  1.00 37.41           H  
ATOM    269  HA  PHE    17      -0.593  -2.422  -7.942  1.00 71.45           H  
ATOM    270  HB2 PHE    17      -0.910  -0.063  -7.253  1.00 37.41           H  
ATOM    271  HB3 PHE    17      -2.350  -0.763  -7.974  1.00 37.41           H  
ATOM    272  HD1 PHE    17      -4.311  -1.293  -6.572  1.00 23.54           H  
ATOM    273  HD2 PHE    17      -0.891   0.688  -4.976  1.00 22.11           H  
ATOM    274  HE1 PHE    17      -5.642  -0.566  -4.633  1.00 15.40           H  
ATOM    275  HE2 PHE    17      -2.218   1.422  -3.036  1.00 34.02           H  
ATOM    276  HZ  PHE    17      -4.597   0.797  -2.862  1.00  5.30           H  
ATOM    277  N   VAL    18       1.239  -1.967  -6.293  1.00 22.04           N  
ATOM    278  CA  VAL    18       2.366  -1.971  -5.355  1.00 54.43           C  
ATOM    279  C   VAL    18       3.086  -0.611  -5.328  1.00 22.02           C  
ATOM    280  O   VAL    18       3.423  -0.044  -6.371  1.00 23.21           O  
ATOM    281  CB  VAL    18       3.384  -3.091  -5.700  1.00 44.42           C  
ATOM    282  CG1 VAL    18       2.765  -4.472  -5.488  1.00 41.30           C  
ATOM    283  CG2 VAL    18       3.901  -2.944  -7.134  1.00 73.52           C  
ATOM    284  H   VAL    18       1.409  -1.778  -7.239  1.00 37.41           H  
ATOM    285  HA  VAL    18       1.973  -2.169  -4.366  1.00 54.53           H  
ATOM    286  HB  VAL    18       4.227  -2.997  -5.027  1.00 60.00           H  
ATOM    287 HG11 VAL    18       2.445  -4.568  -4.460  1.00 37.41           H  
ATOM    288 HG12 VAL    18       3.498  -5.236  -5.708  1.00 37.41           H  
ATOM    289 HG13 VAL    18       1.913  -4.592  -6.142  1.00 37.41           H  
ATOM    290 HG21 VAL    18       3.072  -3.005  -7.826  1.00 37.41           H  
ATOM    291 HG22 VAL    18       4.605  -3.735  -7.348  1.00 37.41           H  
ATOM    292 HG23 VAL    18       4.391  -1.987  -7.246  1.00 37.41           H  
ATOM    293  N   LEU    19       3.304  -0.092  -4.125  1.00 52.03           N  
ATOM    294  CA  LEU    19       4.021   1.173  -3.934  1.00 24.34           C  
ATOM    295  C   LEU    19       5.504   0.916  -3.629  1.00 42.15           C  
ATOM    296  O   LEU    19       5.838   0.190  -2.691  1.00 31.33           O  
ATOM    297  CB  LEU    19       3.377   1.971  -2.791  1.00 55.15           C  
ATOM    298  CG  LEU    19       4.090   3.280  -2.402  1.00 63.53           C  
ATOM    299  CD1 LEU    19       4.113   4.265  -3.570  1.00 65.03           C  
ATOM    300  CD2 LEU    19       3.432   3.907  -1.174  1.00 62.21           C  
ATOM    301  H   LEU    19       2.973  -0.572  -3.337  1.00 37.41           H  
ATOM    302  HA  LEU    19       3.946   1.745  -4.850  1.00 24.45           H  
ATOM    303  HB2 LEU    19       2.363   2.209  -3.079  1.00 37.41           H  
ATOM    304  HB3 LEU    19       3.342   1.335  -1.918  1.00 37.41           H  
ATOM    305  HG  LEU    19       5.116   3.054  -2.147  1.00 54.21           H  
ATOM    306 HD11 LEU    19       3.100   4.489  -3.876  1.00 37.41           H  
ATOM    307 HD12 LEU    19       4.650   3.830  -4.401  1.00 37.41           H  
ATOM    308 HD13 LEU    19       4.605   5.176  -3.263  1.00 37.41           H  
ATOM    309 HD21 LEU    19       2.399   4.136  -1.392  1.00 37.41           H  
ATOM    310 HD22 LEU    19       3.954   4.817  -0.911  1.00 37.41           H  
ATOM    311 HD23 LEU    19       3.481   3.216  -0.344  1.00 37.41           H  
ATOM    312  N   LYS    20       6.390   1.506  -4.431  1.00 33.45           N  
ATOM    313  CA  LYS    20       7.837   1.352  -4.228  1.00 63.43           C  
ATOM    314  C   LYS    20       8.451   2.586  -3.550  1.00 41.42           C  
ATOM    315  O   LYS    20       8.049   3.714  -3.819  1.00 10.34           O  
ATOM    316  CB  LYS    20       8.554   1.068  -5.563  1.00  1.45           C  
ATOM    317  CG  LYS    20       8.383  -0.369  -6.067  1.00  2.44           C  
ATOM    318  CD  LYS    20       6.992  -0.637  -6.637  1.00 64.21           C  
ATOM    319  CE  LYS    20       6.845  -0.091  -8.043  1.00  4.33           C  
ATOM    320  NZ  LYS    20       7.743  -0.793  -9.006  1.00 70.21           N  
ATOM    321  H   LYS    20       6.064   2.064  -5.171  1.00 37.41           H  
ATOM    322  HA  LYS    20       7.985   0.502  -3.574  1.00 54.55           H  
ATOM    323  HB2 LYS    20       8.168   1.740  -6.317  1.00 37.41           H  
ATOM    324  HB3 LYS    20       9.612   1.256  -5.438  1.00 37.41           H  
ATOM    325  HG2 LYS    20       9.116  -0.555  -6.838  1.00 37.41           H  
ATOM    326  HG3 LYS    20       8.560  -1.046  -5.242  1.00 37.41           H  
ATOM    327  HD2 LYS    20       6.824  -1.702  -6.663  1.00 37.41           H  
ATOM    328  HD3 LYS    20       6.254  -0.170  -6.002  1.00 37.41           H  
ATOM    329  HE2 LYS    20       5.822  -0.223  -8.359  1.00 37.41           H  
ATOM    330  HE3 LYS    20       7.088   0.960  -8.036  1.00 37.41           H  
ATOM    331  HZ1 LYS    20       7.384  -1.753  -9.195  1.00 37.41           H  
ATOM    332  HZ2 LYS    20       8.705  -0.861  -8.622  1.00 37.41           H  
ATOM    333  HZ3 LYS    20       7.778  -0.275  -9.907  1.00 37.41           H  
ATOM    334  N   ALA    21       9.428   2.352  -2.671  1.00 15.14           N  
ATOM    335  CA  ALA    21      10.115   3.432  -1.950  1.00 74.41           C  
ATOM    336  C   ALA    21      10.840   4.396  -2.906  1.00 70.03           C  
ATOM    337  O   ALA    21      10.640   5.609  -2.844  1.00  2.32           O  
ATOM    338  CB  ALA    21      11.103   2.839  -0.948  1.00 55.31           C  
ATOM    339  H   ALA    21       9.690   1.424  -2.493  1.00 37.41           H  
ATOM    340  HA  ALA    21       9.370   3.986  -1.395  1.00 43.44           H  
ATOM    341  HB1 ALA    21      10.578   2.178  -0.273  1.00 37.41           H  
ATOM    342  HB2 ALA    21      11.566   3.636  -0.383  1.00 37.41           H  
ATOM    343  HB3 ALA    21      11.864   2.284  -1.476  1.00 37.41           H  
ATOM    344  N   GLY    22      11.682   3.840  -3.777  1.00 32.43           N  
ATOM    345  CA  GLY    22      12.417   4.656  -4.743  1.00 65.25           C  
ATOM    346  C   GLY    22      13.304   3.833  -5.674  1.00 43.13           C  
ATOM    347  O   GLY    22      13.199   3.930  -6.893  1.00 21.33           O  
ATOM    348  H   GLY    22      11.811   2.873  -3.760  1.00 37.41           H  
ATOM    349  HA2 GLY    22      11.707   5.212  -5.340  1.00 37.41           H  
ATOM    350  HA3 GLY    22      13.041   5.357  -4.203  1.00 37.41           H  
ATOM    351  N   ASN    23      14.167   3.000  -5.096  1.00 64.32           N  
ATOM    352  CA  ASN    23      15.101   2.174  -5.885  1.00 13.20           C  
ATOM    353  C   ASN    23      14.403   0.985  -6.576  1.00 64.53           C  
ATOM    354  O   ASN    23      15.057   0.162  -7.218  1.00  4.43           O  
ATOM    355  CB  ASN    23      16.222   1.642  -4.984  1.00  5.33           C  
ATOM    356  CG  ASN    23      15.692   0.766  -3.862  1.00 25.22           C  
ATOM    357  OD1 ASN    23      15.512  -0.435  -4.025  1.00 20.42           O  
ATOM    358  ND2 ASN    23      15.436   1.361  -2.714  1.00 32.25           N  
ATOM    359  H   ASN    23      14.195   2.951  -4.116  1.00 37.41           H  
ATOM    360  HA  ASN    23      15.538   2.805  -6.645  1.00 42.31           H  
ATOM    361  HB2 ASN    23      16.909   1.057  -5.580  1.00 37.41           H  
ATOM    362  HB3 ASN    23      16.754   2.477  -4.550  1.00 37.41           H  
ATOM    363 HD21 ASN    23      15.594   2.326  -2.643  1.00 37.41           H  
ATOM    364 HD22 ASN    23      15.105   0.811  -1.974  1.00 37.41           H  
ATOM    365  N   GLY    24      13.081   0.900  -6.452  1.00 13.42           N  
ATOM    366  CA  GLY    24      12.345  -0.253  -6.968  1.00 11.14           C  
ATOM    367  C   GLY    24      11.843  -1.172  -5.857  1.00 21.53           C  
ATOM    368  O   GLY    24      10.939  -1.981  -6.068  1.00 12.42           O  
ATOM    369  H   GLY    24      12.597   1.636  -6.028  1.00 37.41           H  
ATOM    370  HA2 GLY    24      11.496   0.104  -7.533  1.00 37.41           H  
ATOM    371  HA3 GLY    24      12.987  -0.822  -7.628  1.00 37.41           H  
ATOM    372  N   GLU    25      12.440  -1.042  -4.675  1.00 54.13           N  
ATOM    373  CA  GLU    25      12.017  -1.788  -3.482  1.00  3.13           C  
ATOM    374  C   GLU    25      10.554  -1.474  -3.113  1.00 52.25           C  
ATOM    375  O   GLU    25      10.193  -0.313  -2.913  1.00 55.42           O  
ATOM    376  CB  GLU    25      12.945  -1.435  -2.311  1.00  1.11           C  
ATOM    377  CG  GLU    25      12.583  -2.096  -0.987  1.00 25.03           C  
ATOM    378  CD  GLU    25      13.518  -1.679   0.136  1.00  2.32           C  
ATOM    379  OE1 GLU    25      13.394  -0.538   0.625  1.00 33.43           O  
ATOM    380  OE2 GLU    25      14.398  -2.480   0.521  1.00  5.43           O  
ATOM    381  H   GLU    25      13.201  -0.430  -4.600  1.00 37.41           H  
ATOM    382  HA  GLU    25      12.108  -2.843  -3.697  1.00 33.42           H  
ATOM    383  HB2 GLU    25      13.952  -1.731  -2.569  1.00 37.41           H  
ATOM    384  HB3 GLU    25      12.927  -0.361  -2.168  1.00 37.41           H  
ATOM    385  HG2 GLU    25      11.573  -1.816  -0.721  1.00 37.41           H  
ATOM    386  HG3 GLU    25      12.637  -3.170  -1.106  1.00 37.41           H  
ATOM    387  N   VAL    26       9.719  -2.509  -3.029  1.00 55.41           N  
ATOM    388  CA  VAL    26       8.293  -2.340  -2.714  1.00 44.33           C  
ATOM    389  C   VAL    26       8.057  -2.237  -1.197  1.00 35.44           C  
ATOM    390  O   VAL    26       8.505  -3.089  -0.430  1.00 45.23           O  
ATOM    391  CB  VAL    26       7.450  -3.517  -3.277  1.00 24.14           C  
ATOM    392  CG1 VAL    26       5.963  -3.324  -2.972  1.00 40.43           C  
ATOM    393  CG2 VAL    26       7.683  -3.679  -4.781  1.00 75.21           C  
ATOM    394  H   VAL    26      10.068  -3.414  -3.178  1.00 37.41           H  
ATOM    395  HA  VAL    26       7.954  -1.427  -3.185  1.00 33.13           H  
ATOM    396  HB  VAL    26       7.775  -4.426  -2.788  1.00 11.33           H  
ATOM    397 HG11 VAL    26       5.401  -4.152  -3.378  1.00 37.41           H  
ATOM    398 HG12 VAL    26       5.616  -2.402  -3.420  1.00 37.41           H  
ATOM    399 HG13 VAL    26       5.816  -3.281  -1.903  1.00 37.41           H  
ATOM    400 HG21 VAL    26       8.738  -3.827  -4.969  1.00 37.41           H  
ATOM    401 HG22 VAL    26       7.349  -2.791  -5.299  1.00 37.41           H  
ATOM    402 HG23 VAL    26       7.133  -4.535  -5.142  1.00 37.41           H  
ATOM    403  N   ILE    27       7.346  -1.191  -0.773  1.00  4.41           N  
ATOM    404  CA  ILE    27       7.030  -0.986   0.647  1.00  4.54           C  
ATOM    405  C   ILE    27       5.568  -1.348   0.975  1.00  3.14           C  
ATOM    406  O   ILE    27       5.275  -1.837   2.064  1.00 23.10           O  
ATOM    407  CB  ILE    27       7.318   0.477   1.088  1.00 42.43           C  
ATOM    408  CG1 ILE    27       6.607   1.478   0.157  1.00 33.30           C  
ATOM    409  CG2 ILE    27       8.823   0.740   1.129  1.00 23.50           C  
ATOM    410  CD1 ILE    27       6.893   2.933   0.474  1.00 42.13           C  
ATOM    411  H   ILE    27       7.027  -0.540  -1.431  1.00 37.41           H  
ATOM    412  HA  ILE    27       7.677  -1.639   1.224  1.00 11.11           H  
ATOM    413  HB  ILE    27       6.937   0.603   2.092  1.00 11.11           H  
ATOM    414 HG12 ILE    27       6.919   1.298  -0.862  1.00 37.41           H  
ATOM    415 HG13 ILE    27       5.538   1.329   0.228  1.00 37.41           H  
ATOM    416 HG21 ILE    27       9.236   0.637   0.137  1.00 37.41           H  
ATOM    417 HG22 ILE    27       9.296   0.029   1.791  1.00 37.41           H  
ATOM    418 HG23 ILE    27       9.003   1.742   1.492  1.00 37.41           H  
ATOM    419 HD11 ILE    27       7.949   3.129   0.359  1.00 37.41           H  
ATOM    420 HD12 ILE    27       6.595   3.151   1.491  1.00 37.41           H  
ATOM    421 HD13 ILE    27       6.337   3.563  -0.205  1.00 37.41           H  
ATOM    422  N   LEU    28       4.654  -1.107   0.029  1.00  4.22           N  
ATOM    423  CA  LEU    28       3.226  -1.431   0.210  1.00 60.34           C  
ATOM    424  C   LEU    28       2.710  -2.337  -0.916  1.00 13.24           C  
ATOM    425  O   LEU    28       2.926  -2.061  -2.095  1.00 51.11           O  
ATOM    426  CB  LEU    28       2.365  -0.148   0.265  1.00 13.32           C  
ATOM    427  CG  LEU    28       2.170   0.493   1.654  1.00  1.30           C  
ATOM    428  CD1 LEU    28       1.429  -0.455   2.592  1.00 51.54           C  
ATOM    429  CD2 LEU    28       3.503   0.911   2.258  1.00 11.51           C  
ATOM    430  H   LEU    28       4.943  -0.701  -0.816  1.00 37.41           H  
ATOM    431  HA  LEU    28       3.123  -1.959   1.150  1.00 32.34           H  
ATOM    432  HB2 LEU    28       2.821   0.588  -0.381  1.00 37.41           H  
ATOM    433  HB3 LEU    28       1.384  -0.381  -0.133  1.00 37.41           H  
ATOM    434  HG  LEU    28       1.565   1.381   1.544  1.00 21.42           H  
ATOM    435 HD11 LEU    28       0.466  -0.702   2.169  1.00 37.41           H  
ATOM    436 HD12 LEU    28       1.288   0.023   3.552  1.00 37.41           H  
ATOM    437 HD13 LEU    28       2.006  -1.358   2.725  1.00 37.41           H  
ATOM    438 HD21 LEU    28       4.121   0.040   2.408  1.00 37.41           H  
ATOM    439 HD22 LEU    28       3.333   1.397   3.207  1.00 37.41           H  
ATOM    440 HD23 LEU    28       4.005   1.595   1.589  1.00 37.41           H  
ATOM    441  N   THR    29       2.027  -3.415  -0.540  1.00 42.25           N  
ATOM    442  CA  THR    29       1.398  -4.329  -1.505  1.00  3.53           C  
ATOM    443  C   THR    29      -0.089  -4.530  -1.181  1.00 50.11           C  
ATOM    444  O   THR    29      -0.436  -5.182  -0.195  1.00  2.20           O  
ATOM    445  CB  THR    29       2.089  -5.715  -1.513  1.00  3.43           C  
ATOM    446  OG1 THR    29       3.497  -5.570  -1.777  1.00 62.22           O  
ATOM    447  CG2 THR    29       1.467  -6.643  -2.559  1.00 43.44           C  
ATOM    448  H   THR    29       1.947  -3.611   0.416  1.00 37.41           H  
ATOM    449  HA  THR    29       1.489  -3.897  -2.495  1.00 31.01           H  
ATOM    450  HB  THR    29       1.965  -6.167  -0.537  1.00 62.51           H  
ATOM    451  HG1 THR    29       3.867  -4.912  -1.174  1.00 71.20           H  
ATOM    452 HG21 THR    29       0.423  -6.800  -2.327  1.00 37.41           H  
ATOM    453 HG22 THR    29       1.983  -7.592  -2.552  1.00 37.41           H  
ATOM    454 HG23 THR    29       1.555  -6.194  -3.538  1.00 37.41           H  
ATOM    455  N   SER    30      -0.966  -3.964  -2.002  1.00 12.02           N  
ATOM    456  CA  SER    30      -2.415  -4.109  -1.802  1.00 32.42           C  
ATOM    457  C   SER    30      -2.917  -5.478  -2.279  1.00 71.31           C  
ATOM    458  O   SER    30      -2.366  -6.063  -3.210  1.00 12.20           O  
ATOM    459  CB  SER    30      -3.166  -2.992  -2.529  1.00 40.31           C  
ATOM    460  OG  SER    30      -2.809  -1.723  -2.009  1.00 75.03           O  
ATOM    461  H   SER    30      -0.637  -3.433  -2.762  1.00 37.41           H  
ATOM    462  HA  SER    30      -2.609  -4.024  -0.740  1.00 24.21           H  
ATOM    463  HB2 SER    30      -2.917  -3.016  -3.581  1.00 37.41           H  
ATOM    464  HB3 SER    30      -4.230  -3.132  -2.406  1.00 37.41           H  
ATOM    465  HG  SER    30      -3.596  -1.280  -1.671  1.00 71.43           H  
ATOM    466  N   GLU    31      -3.971  -5.977  -1.634  1.00 73.33           N  
ATOM    467  CA  GLU    31      -4.517  -7.305  -1.944  1.00  3.32           C  
ATOM    468  C   GLU    31      -5.400  -7.270  -3.211  1.00 40.31           C  
ATOM    469  O   GLU    31      -5.730  -6.200  -3.721  1.00 52.34           O  
ATOM    470  CB  GLU    31      -5.301  -7.835  -0.729  1.00 60.41           C  
ATOM    471  CG  GLU    31      -5.616  -9.328  -0.785  1.00 21.24           C  
ATOM    472  CD  GLU    31      -6.150  -9.867   0.533  1.00 21.13           C  
ATOM    473  OE1 GLU    31      -5.332 -10.197   1.419  1.00 42.33           O  
ATOM    474  OE2 GLU    31      -7.384  -9.967   0.691  1.00 53.31           O  
ATOM    475  H   GLU    31      -4.396  -5.440  -0.936  1.00 37.41           H  
ATOM    476  HA  GLU    31      -3.681  -7.966  -2.130  1.00 12.32           H  
ATOM    477  HB2 GLU    31      -4.719  -7.649   0.163  1.00 37.41           H  
ATOM    478  HB3 GLU    31      -6.235  -7.293  -0.653  1.00 37.41           H  
ATOM    479  HG2 GLU    31      -6.357  -9.497  -1.555  1.00 37.41           H  
ATOM    480  HG3 GLU    31      -4.713  -9.865  -1.038  1.00 37.41           H  
ATOM    481  N   LEU    32      -5.778  -8.448  -3.709  1.00 31.41           N  
ATOM    482  CA  LEU    32      -6.494  -8.574  -4.988  1.00 40.14           C  
ATOM    483  C   LEU    32      -7.866  -7.870  -5.000  1.00 75.44           C  
ATOM    484  O   LEU    32      -8.808  -8.295  -4.327  1.00 53.22           O  
ATOM    485  CB  LEU    32      -6.674 -10.060  -5.335  1.00 14.41           C  
ATOM    486  CG  LEU    32      -5.371 -10.842  -5.569  1.00 55.35           C  
ATOM    487  CD1 LEU    32      -5.662 -12.309  -5.881  1.00 43.45           C  
ATOM    488  CD2 LEU    32      -4.552 -10.204  -6.689  1.00 22.01           C  
ATOM    489  H   LEU    32      -5.565  -9.259  -3.210  1.00 37.41           H  
ATOM    490  HA  LEU    32      -5.873  -8.122  -5.748  1.00 11.12           H  
ATOM    491  HB2 LEU    32      -7.213 -10.533  -4.525  1.00 37.41           H  
ATOM    492  HB3 LEU    32      -7.275 -10.130  -6.231  1.00 37.41           H  
ATOM    493  HG  LEU    32      -4.779 -10.810  -4.665  1.00 11.42           H  
ATOM    494 HD11 LEU    32      -6.278 -12.376  -6.768  1.00 37.41           H  
ATOM    495 HD12 LEU    32      -6.182 -12.758  -5.048  1.00 37.41           H  
ATOM    496 HD13 LEU    32      -4.733 -12.834  -6.048  1.00 37.41           H  
ATOM    497 HD21 LEU    32      -3.639 -10.763  -6.829  1.00 37.41           H  
ATOM    498 HD22 LEU    32      -4.311  -9.185  -6.426  1.00 37.41           H  
ATOM    499 HD23 LEU    32      -5.123 -10.214  -7.606  1.00 37.41           H  
ATOM    500  N   TYR    33      -7.965  -6.790  -5.775  1.00 11.35           N  
ATOM    501  CA  TYR    33      -9.249  -6.138  -6.051  1.00 11.52           C  
ATOM    502  C   TYR    33      -9.951  -6.803  -7.244  1.00 23.01           C  
ATOM    503  O   TYR    33      -9.325  -7.082  -8.265  1.00 43.55           O  
ATOM    504  CB  TYR    33      -9.043  -4.646  -6.357  1.00 50.44           C  
ATOM    505  CG  TYR    33      -8.682  -3.799  -5.149  1.00 53.22           C  
ATOM    506  CD1 TYR    33      -7.393  -3.804  -4.627  1.00 25.22           C  
ATOM    507  CD2 TYR    33      -9.634  -2.992  -4.534  1.00 32.12           C  
ATOM    508  CE1 TYR    33      -7.065  -3.030  -3.529  1.00 54.14           C  
ATOM    509  CE2 TYR    33      -9.312  -2.216  -3.437  1.00  5.53           C  
ATOM    510  CZ  TYR    33      -8.029  -2.239  -2.939  1.00 72.32           C  
ATOM    511  OH  TYR    33      -7.713  -1.471  -1.839  1.00 32.34           O  
ATOM    512  H   TYR    33      -7.147  -6.415  -6.167  1.00 37.41           H  
ATOM    513  HA  TYR    33      -9.875  -6.236  -5.174  1.00 51.34           H  
ATOM    514  HB2 TYR    33      -8.246  -4.543  -7.080  1.00 37.41           H  
ATOM    515  HB3 TYR    33      -9.954  -4.247  -6.783  1.00 37.41           H  
ATOM    516  HD1 TYR    33      -6.640  -4.426  -5.091  1.00 54.13           H  
ATOM    517  HD2 TYR    33     -10.641  -2.976  -4.925  1.00 75.03           H  
ATOM    518  HE1 TYR    33      -6.057  -3.047  -3.139  1.00 13.12           H  
ATOM    519  HE2 TYR    33     -10.066  -1.596  -2.976  1.00 52.15           H  
ATOM    520  HH  TYR    33      -6.843  -1.077  -1.960  1.00 61.43           H  
ATOM    521  N   THR    34     -11.253  -7.044  -7.126  1.00 23.34           N  
ATOM    522  CA  THR    34     -12.024  -7.667  -8.217  1.00  0.23           C  
ATOM    523  C   THR    34     -12.409  -6.652  -9.305  1.00 51.22           C  
ATOM    524  O   THR    34     -13.006  -7.010 -10.319  1.00 71.32           O  
ATOM    525  CB  THR    34     -13.311  -8.338  -7.688  1.00 34.04           C  
ATOM    526  OG1 THR    34     -14.136  -7.365  -7.029  1.00 52.13           O  
ATOM    527  CG2 THR    34     -12.980  -9.470  -6.719  1.00 45.25           C  
ATOM    528  H   THR    34     -11.710  -6.807  -6.291  1.00 37.41           H  
ATOM    529  HA  THR    34     -11.406  -8.433  -8.663  1.00 53.15           H  
ATOM    530  HB  THR    34     -13.856  -8.750  -8.526  1.00 11.22           H  
ATOM    531  HG1 THR    34     -14.964  -7.264  -7.518  1.00 54.02           H  
ATOM    532 HG21 THR    34     -13.896  -9.921  -6.365  1.00 37.41           H  
ATOM    533 HG22 THR    34     -12.426  -9.076  -5.879  1.00 37.41           H  
ATOM    534 HG23 THR    34     -12.384 -10.216  -7.225  1.00 37.41           H  
ATOM    535  N   GLY    35     -12.063  -5.386  -9.087  1.00 32.43           N  
ATOM    536  CA  GLY    35     -12.350  -4.339 -10.064  1.00 11.33           C  
ATOM    537  C   GLY    35     -11.308  -3.223 -10.037  1.00  4.14           C  
ATOM    538  O   GLY    35     -10.841  -2.834  -8.963  1.00  4.34           O  
ATOM    539  H   GLY    35     -11.606  -5.156  -8.253  1.00 37.41           H  
ATOM    540  HA2 GLY    35     -12.372  -4.774 -11.052  1.00 37.41           H  
ATOM    541  HA3 GLY    35     -13.319  -3.918  -9.847  1.00 37.41           H  
ATOM    542  N   LYS    36     -10.949  -2.697 -11.208  1.00 34.30           N  
ATOM    543  CA  LYS    36      -9.908  -1.662 -11.301  1.00 51.21           C  
ATOM    544  C   LYS    36     -10.348  -0.358 -10.615  1.00 14.33           C  
ATOM    545  O   LYS    36      -9.536   0.323  -9.991  1.00 14.21           O  
ATOM    546  CB  LYS    36      -9.538  -1.392 -12.767  1.00 64.03           C  
ATOM    547  CG  LYS    36      -8.450  -0.329 -12.934  1.00  4.43           C  
ATOM    548  CD  LYS    36      -7.999  -0.180 -14.384  1.00 75.05           C  
ATOM    549  CE  LYS    36      -7.329  -1.447 -14.907  1.00 30.43           C  
ATOM    550  NZ  LYS    36      -6.824  -1.274 -16.294  1.00 15.40           N  
ATOM    551  H   LYS    36     -11.399  -2.997 -12.026  1.00 37.41           H  
ATOM    552  HA  LYS    36      -9.034  -2.040 -10.788  1.00 74.12           H  
ATOM    553  HB2 LYS    36      -9.188  -2.313 -13.213  1.00 37.41           H  
ATOM    554  HB3 LYS    36     -10.421  -1.060 -13.295  1.00 37.41           H  
ATOM    555  HG2 LYS    36      -8.839   0.620 -12.593  1.00 37.41           H  
ATOM    556  HG3 LYS    36      -7.597  -0.602 -12.327  1.00 37.41           H  
ATOM    557  HD2 LYS    36      -8.861   0.037 -14.998  1.00 37.41           H  
ATOM    558  HD3 LYS    36      -7.297   0.641 -14.448  1.00 37.41           H  
ATOM    559  HE2 LYS    36      -6.500  -1.696 -14.262  1.00 37.41           H  
ATOM    560  HE3 LYS    36      -8.049  -2.252 -14.894  1.00 37.41           H  
ATOM    561  HZ1 LYS    36      -6.090  -0.537 -16.322  1.00 37.41           H  
ATOM    562  HZ2 LYS    36      -7.605  -0.997 -16.924  1.00 37.41           H  
ATOM    563  HZ3 LYS    36      -6.413  -2.166 -16.637  1.00 37.41           H  
ATOM    564  N   SER    37     -11.637  -0.030 -10.725  1.00 24.11           N  
ATOM    565  CA  SER    37     -12.206   1.158 -10.064  1.00 42.53           C  
ATOM    566  C   SER    37     -11.841   1.196  -8.573  1.00  4.25           C  
ATOM    567  O   SER    37     -11.376   2.213  -8.064  1.00 74.34           O  
ATOM    568  CB  SER    37     -13.737   1.184 -10.222  1.00 65.24           C  
ATOM    569  OG  SER    37     -14.322   2.265  -9.504  1.00 74.54           O  
ATOM    570  H   SER    37     -12.221  -0.594 -11.276  1.00 37.41           H  
ATOM    571  HA  SER    37     -11.790   2.033 -10.546  1.00 22.04           H  
ATOM    572  HB2 SER    37     -13.988   1.292 -11.268  1.00 37.41           H  
ATOM    573  HB3 SER    37     -14.152   0.258  -9.851  1.00 37.41           H  
ATOM    574  HG  SER    37     -13.892   3.093  -9.764  1.00  1.20           H  
ATOM    575  N   GLY    38     -12.040   0.071  -7.881  1.00  5.13           N  
ATOM    576  CA  GLY    38     -11.691  -0.019  -6.465  1.00 65.42           C  
ATOM    577  C   GLY    38     -10.193   0.119  -6.202  1.00 20.51           C  
ATOM    578  O   GLY    38      -9.782   0.729  -5.212  1.00 35.31           O  
ATOM    579  H   GLY    38     -12.434  -0.701  -8.334  1.00 37.41           H  
ATOM    580  HA2 GLY    38     -12.210   0.762  -5.929  1.00 37.41           H  
ATOM    581  HA3 GLY    38     -12.021  -0.977  -6.089  1.00 37.41           H  
ATOM    582  N   ALA    39      -9.375  -0.451  -7.084  1.00 14.51           N  
ATOM    583  CA  ALA    39      -7.916  -0.366  -6.955  1.00  2.15           C  
ATOM    584  C   ALA    39      -7.414   1.079  -7.131  1.00 43.23           C  
ATOM    585  O   ALA    39      -6.716   1.617  -6.269  1.00 65.03           O  
ATOM    586  CB  ALA    39      -7.246  -1.290  -7.966  1.00 22.11           C  
ATOM    587  H   ALA    39      -9.761  -0.943  -7.840  1.00 37.41           H  
ATOM    588  HA  ALA    39      -7.651  -0.706  -5.963  1.00 55.24           H  
ATOM    589  HB1 ALA    39      -7.593  -2.301  -7.816  1.00 37.41           H  
ATOM    590  HB2 ALA    39      -6.173  -1.255  -7.833  1.00 37.41           H  
ATOM    591  HB3 ALA    39      -7.492  -0.971  -8.970  1.00 37.41           H  
ATOM    592  N   MET    40      -7.786   1.701  -8.247  1.00  3.10           N  
ATOM    593  CA  MET    40      -7.380   3.081  -8.541  1.00 23.33           C  
ATOM    594  C   MET    40      -7.929   4.060  -7.491  1.00 42.24           C  
ATOM    595  O   MET    40      -7.181   4.866  -6.930  1.00 12.52           O  
ATOM    596  CB  MET    40      -7.850   3.485  -9.942  1.00 43.41           C  
ATOM    597  CG  MET    40      -7.287   2.606 -11.050  1.00 13.52           C  
ATOM    598  SD  MET    40      -5.482   2.610 -11.093  1.00 32.52           S  
ATOM    599  CE  MET    40      -5.155   4.329 -11.473  1.00 52.20           C  
ATOM    600  H   MET    40      -8.347   1.222  -8.892  1.00 37.41           H  
ATOM    601  HA  MET    40      -6.300   3.117  -8.513  1.00 73.45           H  
ATOM    602  HB2 MET    40      -8.930   3.426  -9.979  1.00 37.41           H  
ATOM    603  HB3 MET    40      -7.548   4.505 -10.132  1.00 37.41           H  
ATOM    604  HG2 MET    40      -7.627   1.592 -10.894  1.00 37.41           H  
ATOM    605  HG3 MET    40      -7.658   2.964 -12.000  1.00 37.41           H  
ATOM    606  HE1 MET    40      -5.544   4.955 -10.683  1.00 37.41           H  
ATOM    607  HE2 MET    40      -5.633   4.590 -12.407  1.00 37.41           H  
ATOM    608  HE3 MET    40      -4.089   4.482 -11.560  1.00 37.41           H  
ATOM    609  N   ASN    41      -9.235   3.982  -7.223  1.00 54.43           N  
ATOM    610  CA  ASN    41      -9.854   4.788  -6.164  1.00 55.45           C  
ATOM    611  C   ASN    41      -9.162   4.529  -4.817  1.00 34.44           C  
ATOM    612  O   ASN    41      -9.037   5.428  -3.983  1.00  2.44           O  
ATOM    613  CB  ASN    41     -11.353   4.477  -6.067  1.00 74.23           C  
ATOM    614  CG  ASN    41     -12.070   5.347  -5.048  1.00 64.35           C  
ATOM    615  OD1 ASN    41     -12.499   6.456  -5.352  1.00 42.11           O  
ATOM    616  ND2 ASN    41     -12.216   4.850  -3.835  1.00 53.21           N  
ATOM    617  H   ASN    41      -9.797   3.376  -7.756  1.00 37.41           H  
ATOM    618  HA  ASN    41      -9.726   5.831  -6.426  1.00 43.51           H  
ATOM    619  HB2 ASN    41     -11.811   4.637  -7.032  1.00 37.41           H  
ATOM    620  HB3 ASN    41     -11.482   3.442  -5.784  1.00 37.41           H  
ATOM    621 HD21 ASN    41     -11.856   3.955  -3.653  1.00 37.41           H  
ATOM    622 HD22 ASN    41     -12.684   5.392  -3.169  1.00 37.41           H  
ATOM    623  N   GLY    42      -8.703   3.292  -4.623  1.00 72.21           N  
ATOM    624  CA  GLY    42      -7.892   2.966  -3.460  1.00 21.21           C  
ATOM    625  C   GLY    42      -6.599   3.775  -3.407  1.00 52.31           C  
ATOM    626  O   GLY    42      -6.209   4.261  -2.346  1.00 32.41           O  
ATOM    627  H   GLY    42      -8.924   2.590  -5.273  1.00 37.41           H  
ATOM    628  HA2 GLY    42      -8.468   3.161  -2.565  1.00 37.41           H  
ATOM    629  HA3 GLY    42      -7.644   1.915  -3.494  1.00 37.41           H  
ATOM    630  N   ILE    43      -5.946   3.944  -4.562  1.00 11.41           N  
ATOM    631  CA  ILE    43      -4.716   4.744  -4.647  1.00 54.22           C  
ATOM    632  C   ILE    43      -4.993   6.213  -4.287  1.00 64.31           C  
ATOM    633  O   ILE    43      -4.294   6.809  -3.465  1.00 51.11           O  
ATOM    634  CB  ILE    43      -4.089   4.680  -6.067  1.00 51.41           C  
ATOM    635  CG1 ILE    43      -3.778   3.224  -6.457  1.00 75.32           C  
ATOM    636  CG2 ILE    43      -2.826   5.540  -6.136  1.00 72.23           C  
ATOM    637  CD1 ILE    43      -3.219   3.066  -7.857  1.00 23.24           C  
ATOM    638  H   ILE    43      -6.306   3.531  -5.378  1.00 37.41           H  
ATOM    639  HA  ILE    43      -4.005   4.338  -3.940  1.00 25.12           H  
ATOM    640  HB  ILE    43      -4.804   5.086  -6.769  1.00  3.44           H  
ATOM    641 HG12 ILE    43      -3.053   2.817  -5.767  1.00 37.41           H  
ATOM    642 HG13 ILE    43      -4.688   2.642  -6.397  1.00 37.41           H  
ATOM    643 HG21 ILE    43      -3.074   6.568  -5.907  1.00 37.41           H  
ATOM    644 HG22 ILE    43      -2.403   5.486  -7.128  1.00 37.41           H  
ATOM    645 HG23 ILE    43      -2.102   5.178  -5.418  1.00 37.41           H  
ATOM    646 HD11 ILE    43      -2.285   3.604  -7.936  1.00 37.41           H  
ATOM    647 HD12 ILE    43      -3.924   3.461  -8.573  1.00 37.41           H  
ATOM    648 HD13 ILE    43      -3.049   2.019  -8.060  1.00 37.41           H  
ATOM    649  N   GLU    44      -6.028   6.785  -4.900  1.00 42.02           N  
ATOM    650  CA  GLU    44      -6.435   8.163  -4.607  1.00 44.20           C  
ATOM    651  C   GLU    44      -6.822   8.313  -3.125  1.00  2.01           C  
ATOM    652  O   GLU    44      -6.565   9.348  -2.500  1.00 34.34           O  
ATOM    653  CB  GLU    44      -7.601   8.575  -5.518  1.00 34.11           C  
ATOM    654  CG  GLU    44      -7.288   8.430  -7.007  1.00 35.01           C  
ATOM    655  CD  GLU    44      -8.408   8.934  -7.906  1.00  4.40           C  
ATOM    656  OE1 GLU    44      -9.376   8.180  -8.143  1.00 31.35           O  
ATOM    657  OE2 GLU    44      -8.320  10.084  -8.388  1.00 62.22           O  
ATOM    658  H   GLU    44      -6.532   6.269  -5.567  1.00 37.41           H  
ATOM    659  HA  GLU    44      -5.590   8.806  -4.810  1.00 63.15           H  
ATOM    660  HB2 GLU    44      -8.458   7.956  -5.288  1.00 37.41           H  
ATOM    661  HB3 GLU    44      -7.850   9.608  -5.321  1.00 37.41           H  
ATOM    662  HG2 GLU    44      -6.389   8.987  -7.227  1.00 37.41           H  
ATOM    663  HG3 GLU    44      -7.118   7.383  -7.220  1.00 37.41           H  
ATOM    664  N   SER    45      -7.431   7.267  -2.566  1.00 71.45           N  
ATOM    665  CA  SER    45      -7.729   7.223  -1.129  1.00 64.43           C  
ATOM    666  C   SER    45      -6.431   7.303  -0.315  1.00 65.20           C  
ATOM    667  O   SER    45      -6.324   8.094   0.620  1.00  1.10           O  
ATOM    668  CB  SER    45      -8.501   5.943  -0.769  1.00 20.41           C  
ATOM    669  OG  SER    45      -8.892   5.931   0.598  1.00 73.31           O  
ATOM    670  H   SER    45      -7.690   6.509  -3.131  1.00 37.41           H  
ATOM    671  HA  SER    45      -8.342   8.082  -0.891  1.00  1.13           H  
ATOM    672  HB2 SER    45      -9.387   5.876  -1.383  1.00 37.41           H  
ATOM    673  HB3 SER    45      -7.873   5.081  -0.956  1.00 37.41           H  
ATOM    674  HG  SER    45      -9.836   5.743   0.653  1.00 53.44           H  
ATOM    675  N   VAL    46      -5.434   6.494  -0.694  1.00 74.53           N  
ATOM    676  CA  VAL    46      -4.112   6.532  -0.050  1.00 11.12           C  
ATOM    677  C   VAL    46      -3.501   7.945  -0.102  1.00 70.22           C  
ATOM    678  O   VAL    46      -2.893   8.401   0.865  1.00 14.22           O  
ATOM    679  CB  VAL    46      -3.124   5.524  -0.701  1.00 73.43           C  
ATOM    680  CG1 VAL    46      -1.738   5.622  -0.063  1.00 33.41           C  
ATOM    681  CG2 VAL    46      -3.657   4.095  -0.600  1.00 62.22           C  
ATOM    682  H   VAL    46      -5.590   5.855  -1.422  1.00 37.41           H  
ATOM    683  HA  VAL    46      -4.244   6.251   0.987  1.00 62.22           H  
ATOM    684  HB  VAL    46      -3.028   5.773  -1.751  1.00  4.22           H  
ATOM    685 HG11 VAL    46      -1.332   6.610  -0.227  1.00 37.41           H  
ATOM    686 HG12 VAL    46      -1.082   4.887  -0.508  1.00 37.41           H  
ATOM    687 HG13 VAL    46      -1.816   5.437   0.999  1.00 37.41           H  
ATOM    688 HG21 VAL    46      -3.758   3.819   0.441  1.00 37.41           H  
ATOM    689 HG22 VAL    46      -2.970   3.416  -1.086  1.00 37.41           H  
ATOM    690 HG23 VAL    46      -4.622   4.034  -1.081  1.00 37.41           H  
ATOM    691  N   GLN    47      -3.678   8.636  -1.229  1.00 30.23           N  
ATOM    692  CA  GLN    47      -3.191  10.017  -1.383  1.00 64.14           C  
ATOM    693  C   GLN    47      -3.807  10.953  -0.324  1.00 44.51           C  
ATOM    694  O   GLN    47      -3.102  11.757   0.290  1.00  0.02           O  
ATOM    695  CB  GLN    47      -3.496  10.537  -2.801  1.00 41.10           C  
ATOM    696  CG  GLN    47      -2.785   9.760  -3.907  1.00 73.03           C  
ATOM    697  CD  GLN    47      -3.121  10.267  -5.302  1.00 65.41           C  
ATOM    698  OE1 GLN    47      -4.214  10.765  -5.555  1.00 11.23           O  
ATOM    699  NE2 GLN    47      -2.184  10.153  -6.220  1.00 25.01           N  
ATOM    700  H   GLN    47      -4.141   8.207  -1.980  1.00 37.41           H  
ATOM    701  HA  GLN    47      -2.119  10.002  -1.244  1.00 60.45           H  
ATOM    702  HB2 GLN    47      -4.562  10.475  -2.975  1.00 37.41           H  
ATOM    703  HB3 GLN    47      -3.191  11.572  -2.867  1.00 37.41           H  
ATOM    704  HG2 GLN    47      -1.717   9.842  -3.760  1.00 37.41           H  
ATOM    705  HG3 GLN    47      -3.075   8.721  -3.842  1.00 37.41           H  
ATOM    706 HE21 GLN    47      -1.327   9.753  -5.962  1.00 37.41           H  
ATOM    707 HE22 GLN    47      -2.384  10.471  -7.122  1.00 37.41           H  
ATOM    708  N   THR    48      -5.118  10.835  -0.104  1.00 62.12           N  
ATOM    709  CA  THR    48      -5.808  11.628   0.934  1.00 52.31           C  
ATOM    710  C   THR    48      -5.457  11.143   2.351  1.00 45.00           C  
ATOM    711  O   THR    48      -5.382  11.935   3.290  1.00 12.34           O  
ATOM    712  CB  THR    48      -7.347  11.585   0.756  1.00 31.54           C  
ATOM    713  OG1 THR    48      -7.705  12.112  -0.530  1.00 41.12           O  
ATOM    714  CG2 THR    48      -8.066  12.382   1.845  1.00 24.32           C  
ATOM    715  H   THR    48      -5.640  10.209  -0.657  1.00 37.41           H  
ATOM    716  HA  THR    48      -5.487  12.658   0.831  1.00  2.23           H  
ATOM    717  HB  THR    48      -7.671  10.554   0.812  1.00 51.41           H  
ATOM    718  HG1 THR    48      -7.278  12.971  -0.651  1.00 32.15           H  
ATOM    719 HG21 THR    48      -7.766  13.418   1.791  1.00 37.41           H  
ATOM    720 HG22 THR    48      -7.810  11.985   2.817  1.00 37.41           H  
ATOM    721 HG23 THR    48      -9.135  12.310   1.699  1.00 37.41           H  
ATOM    722  N   ASN    49      -5.245   9.839   2.496  1.00 41.45           N  
ATOM    723  CA  ASN    49      -4.900   9.234   3.791  1.00 12.32           C  
ATOM    724  C   ASN    49      -3.433   9.498   4.172  1.00 34.54           C  
ATOM    725  O   ASN    49      -3.088   9.548   5.350  1.00 72.52           O  
ATOM    726  CB  ASN    49      -5.175   7.726   3.753  1.00 32.14           C  
ATOM    727  CG  ASN    49      -6.646   7.410   3.544  1.00 51.32           C  
ATOM    728  OD1 ASN    49      -7.524   8.100   4.048  1.00  4.51           O  
ATOM    729  ND2 ASN    49      -6.927   6.377   2.783  1.00 14.21           N  
ATOM    730  H   ASN    49      -5.328   9.258   1.710  1.00 37.41           H  
ATOM    731  HA  ASN    49      -5.536   9.684   4.542  1.00 40.24           H  
ATOM    732  HB2 ASN    49      -4.611   7.284   2.944  1.00 37.41           H  
ATOM    733  HB3 ASN    49      -4.860   7.283   4.689  1.00 37.41           H  
ATOM    734 HD21 ASN    49      -6.185   5.872   2.403  1.00 37.41           H  
ATOM    735 HD22 ASN    49      -7.868   6.173   2.610  1.00 37.41           H  
ATOM    736  N   SER    50      -2.581   9.658   3.161  1.00 54.03           N  
ATOM    737  CA  SER    50      -1.131   9.866   3.356  1.00 14.11           C  
ATOM    738  C   SER    50      -0.802  10.941   4.421  1.00 44.35           C  
ATOM    739  O   SER    50       0.011  10.692   5.313  1.00 31.31           O  
ATOM    740  CB  SER    50      -0.464  10.223   2.014  1.00 15.02           C  
ATOM    741  OG  SER    50       0.913  10.533   2.172  1.00 20.01           O  
ATOM    742  H   SER    50      -2.933   9.635   2.249  1.00 37.41           H  
ATOM    743  HA  SER    50      -0.725   8.922   3.695  1.00 71.31           H  
ATOM    744  HB2 SER    50      -0.552   9.384   1.339  1.00 37.41           H  
ATOM    745  HB3 SER    50      -0.965  11.079   1.584  1.00 37.41           H  
ATOM    746  HG  SER    50       1.437   9.729   2.070  1.00 12.52           H  
ATOM    747  N   PRO    51      -1.402  12.156   4.354  1.00 52.03           N  
ATOM    748  CA  PRO    51      -1.169  13.199   5.370  1.00  4.43           C  
ATOM    749  C   PRO    51      -1.944  12.952   6.677  1.00 52.32           C  
ATOM    750  O   PRO    51      -1.650  13.558   7.711  1.00 44.31           O  
ATOM    751  CB  PRO    51      -1.670  14.471   4.675  1.00 73.13           C  
ATOM    752  CG  PRO    51      -2.748  13.994   3.764  1.00 43.32           C  
ATOM    753  CD  PRO    51      -2.319  12.627   3.293  1.00 42.13           C  
ATOM    754  HA  PRO    51      -0.116  13.299   5.596  1.00 13.20           H  
ATOM    755  HB2 PRO    51      -2.049  15.171   5.410  1.00 37.41           H  
ATOM    756  HB3 PRO    51      -0.861  14.927   4.123  1.00 37.41           H  
ATOM    757  HG2 PRO    51      -3.684  13.930   4.302  1.00 37.41           H  
ATOM    758  HG3 PRO    51      -2.845  14.667   2.925  1.00 37.41           H  
ATOM    759  HD2 PRO    51      -3.173  11.972   3.205  1.00 37.41           H  
ATOM    760  HD3 PRO    51      -1.803  12.700   2.346  1.00 37.41           H  
ATOM    761  N   ILE    52      -2.934  12.060   6.624  1.00 63.31           N  
ATOM    762  CA  ILE    52      -3.784  11.757   7.784  1.00 50.41           C  
ATOM    763  C   ILE    52      -3.355  10.443   8.462  1.00 25.20           C  
ATOM    764  O   ILE    52      -3.842   9.360   8.129  1.00 63.43           O  
ATOM    765  CB  ILE    52      -5.278  11.668   7.377  1.00 40.10           C  
ATOM    766  CG1 ILE    52      -5.698  12.940   6.620  1.00  0.32           C  
ATOM    767  CG2 ILE    52      -6.164  11.454   8.609  1.00 13.31           C  
ATOM    768  CD1 ILE    52      -7.110  12.896   6.077  1.00 14.20           C  
ATOM    769  H   ILE    52      -3.093  11.580   5.783  1.00 37.41           H  
ATOM    770  HA  ILE    52      -3.676  12.566   8.495  1.00 14.31           H  
ATOM    771  HB  ILE    52      -5.400  10.815   6.724  1.00 21.03           H  
ATOM    772 HG12 ILE    52      -5.629  13.789   7.286  1.00 37.41           H  
ATOM    773 HG13 ILE    52      -5.028  13.093   5.785  1.00 37.41           H  
ATOM    774 HG21 ILE    52      -7.198  11.378   8.302  1.00 37.41           H  
ATOM    775 HG22 ILE    52      -6.052  12.289   9.286  1.00 37.41           H  
ATOM    776 HG23 ILE    52      -5.871  10.544   9.112  1.00 37.41           H  
ATOM    777 HD11 ILE    52      -7.214  12.053   5.411  1.00 37.41           H  
ATOM    778 HD12 ILE    52      -7.315  13.809   5.536  1.00 37.41           H  
ATOM    779 HD13 ILE    52      -7.809  12.800   6.895  1.00 37.41           H  
ATOM    780  N   GLU    53      -2.443  10.555   9.420  1.00 72.33           N  
ATOM    781  CA  GLU    53      -1.867   9.387  10.096  1.00 21.33           C  
ATOM    782  C   GLU    53      -2.934   8.548  10.821  1.00 13.30           C  
ATOM    783  O   GLU    53      -2.792   7.338  10.955  1.00 61.14           O  
ATOM    784  CB  GLU    53      -0.784   9.844  11.084  1.00 51.10           C  
ATOM    785  CG  GLU    53       0.329  10.658  10.428  1.00 41.41           C  
ATOM    786  CD  GLU    53       1.350  11.177  11.426  1.00 31.52           C  
ATOM    787  OE1 GLU    53       1.045  12.161  12.134  1.00  0.22           O  
ATOM    788  OE2 GLU    53       2.465  10.618  11.496  1.00  0.21           O  
ATOM    789  H   GLU    53      -2.141  11.450   9.680  1.00 37.41           H  
ATOM    790  HA  GLU    53      -1.404   8.769   9.339  1.00 44.53           H  
ATOM    791  HB2 GLU    53      -1.244  10.453  11.851  1.00 37.41           H  
ATOM    792  HB3 GLU    53      -0.341   8.974  11.544  1.00 37.41           H  
ATOM    793  HG2 GLU    53       0.836  10.035   9.706  1.00 37.41           H  
ATOM    794  HG3 GLU    53      -0.114  11.504   9.916  1.00 37.41           H  
ATOM    795  N   ALA    54      -4.022   9.183  11.247  1.00 24.34           N  
ATOM    796  CA  ALA    54      -5.102   8.486  11.969  1.00 14.52           C  
ATOM    797  C   ALA    54      -5.685   7.291  11.178  1.00 12.03           C  
ATOM    798  O   ALA    54      -6.469   6.504  11.715  1.00  2.10           O  
ATOM    799  CB  ALA    54      -6.208   9.475  12.319  1.00 10.14           C  
ATOM    800  H   ALA    54      -4.106  10.145  11.077  1.00 37.41           H  
ATOM    801  HA  ALA    54      -4.687   8.113  12.895  1.00 21.34           H  
ATOM    802  HB1 ALA    54      -6.973   8.974  12.895  1.00 37.41           H  
ATOM    803  HB2 ALA    54      -6.642   9.870  11.411  1.00 37.41           H  
ATOM    804  HB3 ALA    54      -5.795  10.285  12.902  1.00 37.41           H  
ATOM    805  N   ARG    55      -5.296   7.162   9.909  1.00 23.25           N  
ATOM    806  CA  ARG    55      -5.814   6.110   9.026  1.00  2.54           C  
ATOM    807  C   ARG    55      -4.950   4.826   9.031  1.00 53.14           C  
ATOM    808  O   ARG    55      -5.335   3.821   8.422  1.00  4.12           O  
ATOM    809  CB  ARG    55      -5.915   6.660   7.594  1.00  4.02           C  
ATOM    810  CG  ARG    55      -6.858   7.855   7.453  1.00 31.02           C  
ATOM    811  CD  ARG    55      -8.317   7.454   7.646  1.00 42.40           C  
ATOM    812  NE  ARG    55      -9.220   8.609   7.648  1.00 62.02           N  
ATOM    813  CZ  ARG    55      -9.855   9.054   6.595  1.00 64.32           C  
ATOM    814  NH1 ARG    55      -9.613   8.568   5.418  1.00 51.52           N  
ATOM    815  NH2 ARG    55     -10.707  10.018   6.710  1.00  4.11           N  
ATOM    816  H   ARG    55      -4.647   7.803   9.547  1.00 37.41           H  
ATOM    817  HA  ARG    55      -6.806   5.852   9.367  1.00 22.42           H  
ATOM    818  HB2 ARG    55      -4.931   6.969   7.270  1.00 37.41           H  
ATOM    819  HB3 ARG    55      -6.266   5.872   6.942  1.00 37.41           H  
ATOM    820  HG2 ARG    55      -6.597   8.596   8.194  1.00 37.41           H  
ATOM    821  HG3 ARG    55      -6.738   8.278   6.465  1.00 37.41           H  
ATOM    822  HD2 ARG    55      -8.603   6.785   6.846  1.00 37.41           H  
ATOM    823  HD3 ARG    55      -8.412   6.937   8.591  1.00 37.41           H  
ATOM    824  HE  ARG    55      -9.383   9.052   8.504  1.00 72.15           H  
ATOM    825 HH11 ARG    55      -8.932   7.849   5.304  1.00 37.41           H  
ATOM    826 HH12 ARG    55     -10.090   8.937   4.622  1.00 37.41           H  
ATOM    827 HH21 ARG    55     -10.872  10.437   7.602  1.00 37.41           H  
ATOM    828 HH22 ARG    55     -11.209  10.336   5.909  1.00 37.41           H  
ATOM    829  N   TYR    56      -3.797   4.843   9.711  1.00 35.41           N  
ATOM    830  CA  TYR    56      -2.880   3.687   9.684  1.00 62.05           C  
ATOM    831  C   TYR    56      -3.367   2.524  10.568  1.00 22.13           C  
ATOM    832  O   TYR    56      -4.337   2.646  11.320  1.00  5.52           O  
ATOM    833  CB  TYR    56      -1.437   4.088  10.092  1.00 63.32           C  
ATOM    834  CG  TYR    56      -1.219   4.439  11.573  1.00 62.22           C  
ATOM    835  CD1 TYR    56      -1.370   3.484  12.580  1.00 51.22           C  
ATOM    836  CD2 TYR    56      -0.851   5.723  11.957  1.00 14.01           C  
ATOM    837  CE1 TYR    56      -1.166   3.802  13.910  1.00 53.41           C  
ATOM    838  CE2 TYR    56      -0.643   6.048  13.285  1.00 42.30           C  
ATOM    839  CZ  TYR    56      -0.806   5.085  14.258  1.00  0.02           C  
ATOM    840  OH  TYR    56      -0.602   5.404  15.582  1.00  0.11           O  
ATOM    841  H   TYR    56      -3.558   5.637  10.234  1.00 37.41           H  
ATOM    842  HA  TYR    56      -2.854   3.333   8.662  1.00  0.43           H  
ATOM    843  HB2 TYR    56      -0.772   3.270   9.857  1.00 37.41           H  
ATOM    844  HB3 TYR    56      -1.144   4.949   9.504  1.00 37.41           H  
ATOM    845  HD1 TYR    56      -1.650   2.476  12.309  1.00 50.32           H  
ATOM    846  HD2 TYR    56      -0.728   6.479  11.196  1.00 34.13           H  
ATOM    847  HE1 TYR    56      -1.292   3.045  14.671  1.00 51.01           H  
ATOM    848  HE2 TYR    56      -0.357   7.055  13.556  1.00 22.30           H  
ATOM    849  HH  TYR    56      -1.043   6.241  15.780  1.00 14.22           H  
ATOM    850  N   ALA    57      -2.675   1.391  10.455  1.00 63.32           N  
ATOM    851  CA  ALA    57      -2.859   0.254  11.362  1.00 25.11           C  
ATOM    852  C   ALA    57      -1.529  -0.491  11.565  1.00 35.11           C  
ATOM    853  O   ALA    57      -1.122  -1.294  10.727  1.00 54.01           O  
ATOM    854  CB  ALA    57      -3.927  -0.689  10.819  1.00 23.24           C  
ATOM    855  H   ALA    57      -2.032   1.307   9.719  1.00 37.41           H  
ATOM    856  HA  ALA    57      -3.197   0.636  12.317  1.00 52.10           H  
ATOM    857  HB1 ALA    57      -3.598  -1.103   9.877  1.00 37.41           H  
ATOM    858  HB2 ALA    57      -4.848  -0.143  10.669  1.00 37.41           H  
ATOM    859  HB3 ALA    57      -4.096  -1.490  11.523  1.00 37.41           H  
ATOM    860  N   LYS    58      -0.855  -0.228  12.680  1.00 61.02           N  
ATOM    861  CA  LYS    58       0.480  -0.794  12.932  1.00 63.12           C  
ATOM    862  C   LYS    58       0.402  -2.075  13.776  1.00 14.20           C  
ATOM    863  O   LYS    58      -0.132  -2.075  14.888  1.00 64.40           O  
ATOM    864  CB  LYS    58       1.371   0.253  13.618  1.00 42.34           C  
ATOM    865  CG  LYS    58       1.675   1.467  12.739  1.00 42.51           C  
ATOM    866  CD  LYS    58       2.283   2.619  13.539  1.00 64.53           C  
ATOM    867  CE  LYS    58       3.613   2.243  14.180  1.00 34.10           C  
ATOM    868  NZ  LYS    58       4.138   3.339  15.033  1.00 51.24           N  
ATOM    869  H   LYS    58      -1.264   0.352  13.358  1.00 37.41           H  
ATOM    870  HA  LYS    58       0.917  -1.043  11.973  1.00  1.11           H  
ATOM    871  HB2 LYS    58       0.875   0.597  14.516  1.00 37.41           H  
ATOM    872  HB3 LYS    58       2.309  -0.210  13.892  1.00 37.41           H  
ATOM    873  HG2 LYS    58       2.374   1.173  11.967  1.00 37.41           H  
ATOM    874  HG3 LYS    58       0.756   1.805  12.279  1.00 37.41           H  
ATOM    875  HD2 LYS    58       2.443   3.457  12.875  1.00 37.41           H  
ATOM    876  HD3 LYS    58       1.589   2.909  14.316  1.00 37.41           H  
ATOM    877  HE2 LYS    58       3.471   1.363  14.790  1.00 37.41           H  
ATOM    878  HE3 LYS    58       4.331   2.030  13.400  1.00 37.41           H  
ATOM    879  HZ1 LYS    58       3.486   3.520  15.827  1.00 37.41           H  
ATOM    880  HZ2 LYS    58       4.241   4.211  14.480  1.00 37.41           H  
ATOM    881  HZ3 LYS    58       5.069   3.079  15.421  1.00 37.41           H  
ATOM    882  N   GLU    59       0.949  -3.169  13.247  1.00 44.24           N  
ATOM    883  CA  GLU    59       0.882  -4.471  13.919  1.00 11.42           C  
ATOM    884  C   GLU    59       2.249  -5.175  13.923  1.00 44.23           C  
ATOM    885  O   GLU    59       3.090  -4.945  13.051  1.00 51.02           O  
ATOM    886  CB  GLU    59      -0.167  -5.358  13.225  1.00 62.32           C  
ATOM    887  CG  GLU    59      -0.394  -6.708  13.903  1.00 71.31           C  
ATOM    888  CD  GLU    59      -0.917  -6.575  15.325  1.00 71.05           C  
ATOM    889  OE1 GLU    59      -2.147  -6.439  15.499  1.00 51.51           O  
ATOM    890  OE2 GLU    59      -0.103  -6.593  16.271  1.00 64.11           O  
ATOM    891  H   GLU    59       1.413  -3.103  12.385  1.00 37.41           H  
ATOM    892  HA  GLU    59       0.577  -4.303  14.942  1.00 22.01           H  
ATOM    893  HB2 GLU    59      -1.109  -4.828  13.205  1.00 37.41           H  
ATOM    894  HB3 GLU    59       0.150  -5.540  12.207  1.00 37.41           H  
ATOM    895  HG2 GLU    59      -1.109  -7.273  13.323  1.00 37.41           H  
ATOM    896  HG3 GLU    59       0.546  -7.245  13.929  1.00 37.41           H  
ATOM    897  N   VAL    60       2.470  -6.027  14.921  1.00 22.32           N  
ATOM    898  CA  VAL    60       3.696  -6.824  15.010  1.00 64.53           C  
ATOM    899  C   VAL    60       3.366  -8.299  15.279  1.00 53.14           C  
ATOM    900  O   VAL    60       2.798  -8.636  16.319  1.00 43.34           O  
ATOM    901  CB  VAL    60       4.643  -6.309  16.126  1.00  2.12           C  
ATOM    902  CG1 VAL    60       5.908  -7.164  16.200  1.00 11.45           C  
ATOM    903  CG2 VAL    60       4.996  -4.836  15.909  1.00 31.41           C  
ATOM    904  H   VAL    60       1.784  -6.130  15.617  1.00 37.41           H  
ATOM    905  HA  VAL    60       4.215  -6.749  14.063  1.00  5.34           H  
ATOM    906  HB  VAL    60       4.126  -6.394  17.073  1.00 53.30           H  
ATOM    907 HG11 VAL    60       5.637  -8.192  16.393  1.00 37.41           H  
ATOM    908 HG12 VAL    60       6.540  -6.805  17.000  1.00 37.41           H  
ATOM    909 HG13 VAL    60       6.444  -7.102  15.264  1.00 37.41           H  
ATOM    910 HG21 VAL    60       5.634  -4.496  16.714  1.00 37.41           H  
ATOM    911 HG22 VAL    60       4.091  -4.247  15.895  1.00 37.41           H  
ATOM    912 HG23 VAL    60       5.515  -4.722  14.968  1.00 37.41           H  
ATOM    913  N   ALA    61       3.723  -9.170  14.340  1.00 74.01           N  
ATOM    914  CA  ALA    61       3.468 -10.608  14.478  1.00 71.43           C  
ATOM    915  C   ALA    61       4.192 -11.201  15.705  1.00 65.35           C  
ATOM    916  O   ALA    61       5.224 -10.684  16.135  1.00 53.45           O  
ATOM    917  CB  ALA    61       3.892 -11.333  13.206  1.00 74.24           C  
ATOM    918  H   ALA    61       4.166  -8.839  13.528  1.00 37.41           H  
ATOM    919  HA  ALA    61       2.402 -10.745  14.602  1.00 31.41           H  
ATOM    920  HB1 ALA    61       3.608 -12.373  13.269  1.00 37.41           H  
ATOM    921  HB2 ALA    61       4.964 -11.260  13.091  1.00 37.41           H  
ATOM    922  HB3 ALA    61       3.409 -10.879  12.353  1.00 37.41           H  
ATOM    923  N   LYS    62       3.656 -12.300  16.248  1.00  4.44           N  
ATOM    924  CA  LYS    62       4.209 -12.923  17.465  1.00 11.40           C  
ATOM    925  C   LYS    62       5.685 -13.343  17.306  1.00 52.00           C  
ATOM    926  O   LYS    62       6.385 -13.549  18.295  1.00 60.32           O  
ATOM    927  CB  LYS    62       3.332 -14.116  17.908  1.00 35.24           C  
ATOM    928  CG  LYS    62       2.962 -15.109  16.797  1.00 32.32           C  
ATOM    929  CD  LYS    62       4.130 -15.996  16.364  1.00 21.23           C  
ATOM    930  CE  LYS    62       4.682 -16.823  17.517  1.00 32.35           C  
ATOM    931  NZ  LYS    62       5.716 -17.788  17.058  1.00 41.43           N  
ATOM    932  H   LYS    62       2.867 -12.701  15.824  1.00 37.41           H  
ATOM    933  HA  LYS    62       4.165 -12.173  18.244  1.00 22.23           H  
ATOM    934  HB2 LYS    62       3.853 -14.661  18.682  1.00 37.41           H  
ATOM    935  HB3 LYS    62       2.413 -13.726  18.325  1.00 37.41           H  
ATOM    936  HG2 LYS    62       2.164 -15.745  17.155  1.00 37.41           H  
ATOM    937  HG3 LYS    62       2.610 -14.551  15.939  1.00 37.41           H  
ATOM    938  HD2 LYS    62       3.790 -16.667  15.588  1.00 37.41           H  
ATOM    939  HD3 LYS    62       4.919 -15.370  15.972  1.00 37.41           H  
ATOM    940  HE2 LYS    62       5.123 -16.157  18.243  1.00 37.41           H  
ATOM    941  HE3 LYS    62       3.870 -17.369  17.977  1.00 37.41           H  
ATOM    942  HZ1 LYS    62       6.100 -18.314  17.871  1.00 37.41           H  
ATOM    943  HZ2 LYS    62       6.495 -17.286  16.585  1.00 37.41           H  
ATOM    944  HZ3 LYS    62       5.301 -18.465  16.385  1.00 37.41           H  
ATOM    945  N   ASN    63       6.149 -13.463  16.062  1.00 21.24           N  
ATOM    946  CA  ASN    63       7.566 -13.751  15.782  1.00 12.32           C  
ATOM    947  C   ASN    63       8.383 -12.441  15.702  1.00 33.24           C  
ATOM    948  O   ASN    63       9.455 -12.395  15.101  1.00  2.24           O  
ATOM    949  CB  ASN    63       7.668 -14.554  14.471  1.00 62.24           C  
ATOM    950  CG  ASN    63       9.074 -15.056  14.164  1.00 20.31           C  
ATOM    951  OD1 ASN    63       9.485 -16.114  14.623  1.00 45.23           O  
ATOM    952  ND2 ASN    63       9.818 -14.312  13.374  1.00 10.10           N  
ATOM    953  H   ASN    63       5.524 -13.370  15.311  1.00 37.41           H  
ATOM    954  HA  ASN    63       7.952 -14.351  16.596  1.00 40.40           H  
ATOM    955  HB2 ASN    63       7.016 -15.413  14.538  1.00 37.41           H  
ATOM    956  HB3 ASN    63       7.342 -13.932  13.647  1.00 37.41           H  
ATOM    957 HD21 ASN    63       9.442 -13.479  13.028  1.00 37.41           H  
ATOM    958 HD22 ASN    63      10.721 -14.626  13.165  1.00 37.41           H  
ATOM    959  N   ASP    64       7.867 -11.379  16.331  1.00 12.21           N  
ATOM    960  CA  ASP    64       8.514 -10.058  16.313  1.00 33.52           C  
ATOM    961  C   ASP    64       8.675  -9.521  14.882  1.00 53.51           C  
ATOM    962  O   ASP    64       9.686  -8.898  14.546  1.00 41.44           O  
ATOM    963  CB  ASP    64       9.872 -10.114  17.026  1.00 11.12           C  
ATOM    964  CG  ASP    64       9.731 -10.181  18.532  1.00 25.43           C  
ATOM    965  OD1 ASP    64       9.576  -9.113  19.163  1.00 53.53           O  
ATOM    966  OD2 ASP    64       9.775 -11.295  19.093  1.00 55.32           O  
ATOM    967  H   ASP    64       7.030 -11.487  16.826  1.00 37.41           H  
ATOM    968  HA  ASP    64       7.868  -9.381  16.853  1.00 71.24           H  
ATOM    969  HB2 ASP    64      10.411 -10.990  16.690  1.00 37.41           H  
ATOM    970  HB3 ASP    64      10.444  -9.232  16.774  1.00 37.41           H  
ATOM    971  N   LYS    65       7.662  -9.755  14.048  1.00 61.14           N  
ATOM    972  CA  LYS    65       7.666  -9.274  12.660  1.00 32.24           C  
ATOM    973  C   LYS    65       6.824  -7.992  12.531  1.00 33.22           C  
ATOM    974  O   LYS    65       5.593  -8.050  12.518  1.00 61.02           O  
ATOM    975  CB  LYS    65       7.113 -10.358  11.721  1.00 71.43           C  
ATOM    976  CG  LYS    65       7.740 -11.735  11.933  1.00 12.12           C  
ATOM    977  CD  LYS    65       7.122 -12.797  11.024  1.00 54.43           C  
ATOM    978  CE  LYS    65       7.477 -12.578   9.556  1.00 71.11           C  
ATOM    979  NZ  LYS    65       8.943 -12.627   9.316  1.00 13.30           N  
ATOM    980  H   LYS    65       6.892 -10.263  14.373  1.00 37.41           H  
ATOM    981  HA  LYS    65       8.687  -9.055  12.380  1.00 74.43           H  
ATOM    982  HB2 LYS    65       6.046 -10.444  11.878  1.00 37.41           H  
ATOM    983  HB3 LYS    65       7.291 -10.057  10.697  1.00 37.41           H  
ATOM    984  HG2 LYS    65       8.799 -11.672  11.725  1.00 37.41           H  
ATOM    985  HG3 LYS    65       7.595 -12.028  12.964  1.00 37.41           H  
ATOM    986  HD2 LYS    65       7.482 -13.769  11.327  1.00 37.41           H  
ATOM    987  HD3 LYS    65       6.046 -12.764  11.131  1.00 37.41           H  
ATOM    988  HE2 LYS    65       7.002 -13.348   8.965  1.00 37.41           H  
ATOM    989  HE3 LYS    65       7.105 -11.611   9.248  1.00 37.41           H  
ATOM    990  HZ1 LYS    65       9.144 -12.552   8.299  1.00 37.41           H  
ATOM    991  HZ2 LYS    65       9.336 -13.522   9.668  1.00 37.41           H  
ATOM    992  HZ3 LYS    65       9.415 -11.842   9.806  1.00 37.41           H  
ATOM    993  N   PRO    66       7.471  -6.815  12.457  1.00 62.54           N  
ATOM    994  CA  PRO    66       6.766  -5.530  12.370  1.00 44.02           C  
ATOM    995  C   PRO    66       6.263  -5.199  10.950  1.00 12.31           C  
ATOM    996  O   PRO    66       7.020  -5.245   9.979  1.00 62.23           O  
ATOM    997  CB  PRO    66       7.837  -4.530  12.819  1.00 32.11           C  
ATOM    998  CG  PRO    66       9.125  -5.139  12.375  1.00 70.24           C  
ATOM    999  CD  PRO    66       8.939  -6.637  12.465  1.00 13.44           C  
ATOM   1000  HA  PRO    66       5.933  -5.494  13.059  1.00  1.01           H  
ATOM   1001  HB2 PRO    66       7.665  -3.571  12.350  1.00 37.41           H  
ATOM   1002  HB3 PRO    66       7.804  -4.420  13.894  1.00 37.41           H  
ATOM   1003  HG2 PRO    66       9.335  -4.847  11.356  1.00 37.41           H  
ATOM   1004  HG3 PRO    66       9.927  -4.820  13.027  1.00 37.41           H  
ATOM   1005  HD2 PRO    66       9.390  -7.125  11.612  1.00 37.41           H  
ATOM   1006  HD3 PRO    66       9.364  -7.017  13.383  1.00 37.41           H  
ATOM   1007  N   TYR    67       4.979  -4.871  10.846  1.00 24.13           N  
ATOM   1008  CA  TYR    67       4.370  -4.439   9.581  1.00 24.21           C  
ATOM   1009  C   TYR    67       3.188  -3.491   9.849  1.00 45.21           C  
ATOM   1010  O   TYR    67       2.904  -3.151  11.001  1.00 72.50           O  
ATOM   1011  CB  TYR    67       3.915  -5.656   8.753  1.00  1.11           C  
ATOM   1012  CG  TYR    67       2.901  -6.550   9.452  1.00  2.41           C  
ATOM   1013  CD1 TYR    67       3.311  -7.547  10.334  1.00 23.44           C  
ATOM   1014  CD2 TYR    67       1.534  -6.403   9.224  1.00 42.32           C  
ATOM   1015  CE1 TYR    67       2.393  -8.362  10.969  1.00 44.40           C  
ATOM   1016  CE2 TYR    67       0.612  -7.216   9.855  1.00 22.30           C  
ATOM   1017  CZ  TYR    67       1.046  -8.194  10.726  1.00  1.14           C  
ATOM   1018  OH  TYR    67       0.131  -9.010  11.357  1.00 65.32           O  
ATOM   1019  H   TYR    67       4.411  -4.928  11.646  1.00 37.41           H  
ATOM   1020  HA  TYR    67       5.122  -3.896   9.023  1.00 62.22           H  
ATOM   1021  HB2 TYR    67       3.469  -5.308   7.832  1.00 37.41           H  
ATOM   1022  HB3 TYR    67       4.780  -6.259   8.514  1.00 37.41           H  
ATOM   1023  HD1 TYR    67       4.366  -7.678  10.524  1.00  3.10           H  
ATOM   1024  HD2 TYR    67       1.196  -5.635   8.542  1.00 71.14           H  
ATOM   1025  HE1 TYR    67       2.735  -9.127  11.651  1.00 11.44           H  
ATOM   1026  HE2 TYR    67      -0.444  -7.086   9.660  1.00 45.34           H  
ATOM   1027  HH  TYR    67      -0.543  -9.284  10.722  1.00 75.15           H  
ATOM   1028  N   PHE    68       2.507  -3.052   8.794  1.00 24.23           N  
ATOM   1029  CA  PHE    68       1.371  -2.137   8.954  1.00  4.50           C  
ATOM   1030  C   PHE    68       0.403  -2.178   7.760  1.00 64.32           C  
ATOM   1031  O   PHE    68       0.799  -2.428   6.620  1.00 12.41           O  
ATOM   1032  CB  PHE    68       1.871  -0.698   9.183  1.00 32.33           C  
ATOM   1033  CG  PHE    68       2.691  -0.137   8.044  1.00 23.42           C  
ATOM   1034  CD1 PHE    68       4.044  -0.426   7.932  1.00 53.23           C  
ATOM   1035  CD2 PHE    68       2.106   0.680   7.083  1.00 31.25           C  
ATOM   1036  CE1 PHE    68       4.793   0.086   6.889  1.00  4.33           C  
ATOM   1037  CE2 PHE    68       2.853   1.193   6.040  1.00  0.44           C  
ATOM   1038  CZ  PHE    68       4.199   0.895   5.945  1.00 13.13           C  
ATOM   1039  H   PHE    68       2.769  -3.344   7.896  1.00 37.41           H  
ATOM   1040  HA  PHE    68       0.827  -2.451   9.835  1.00 14.23           H  
ATOM   1041  HB2 PHE    68       1.019  -0.048   9.332  1.00 37.41           H  
ATOM   1042  HB3 PHE    68       2.484  -0.681  10.074  1.00 37.41           H  
ATOM   1043  HD1 PHE    68       4.514  -1.062   8.670  1.00 10.45           H  
ATOM   1044  HD2 PHE    68       1.053   0.917   7.157  1.00 75.42           H  
ATOM   1045  HE1 PHE    68       5.844  -0.148   6.814  1.00 73.12           H  
ATOM   1046  HE2 PHE    68       2.386   1.826   5.300  1.00 70.04           H  
ATOM   1047  HZ  PHE    68       4.783   1.293   5.130  1.00  3.33           H  
ATOM   1048  N   ASN    69      -0.872  -1.940   8.050  1.00 64.50           N  
ATOM   1049  CA  ASN    69      -1.917  -1.835   7.029  1.00 15.25           C  
ATOM   1050  C   ASN    69      -2.474  -0.402   6.980  1.00 13.04           C  
ATOM   1051  O   ASN    69      -2.335   0.362   7.937  1.00 72.31           O  
ATOM   1052  CB  ASN    69      -3.054  -2.818   7.333  1.00 23.42           C  
ATOM   1053  CG  ASN    69      -2.588  -4.266   7.375  1.00 74.43           C  
ATOM   1054  OD1 ASN    69      -2.149  -4.761   8.408  1.00 54.30           O  
ATOM   1055  ND2 ASN    69      -2.687  -4.962   6.259  1.00 72.34           N  
ATOM   1056  H   ASN    69      -1.125  -1.836   8.987  1.00 37.41           H  
ATOM   1057  HA  ASN    69      -1.481  -2.078   6.069  1.00 74.20           H  
ATOM   1058  HB2 ASN    69      -3.484  -2.574   8.293  1.00 37.41           H  
ATOM   1059  HB3 ASN    69      -3.816  -2.725   6.572  1.00 37.41           H  
ATOM   1060 HD21 ASN    69      -3.050  -4.521   5.464  1.00 37.41           H  
ATOM   1061 HD22 ASN    69      -2.402  -5.900   6.277  1.00 37.41           H  
ATOM   1062  N   LEU    70      -3.099  -0.039   5.866  1.00  3.12           N  
ATOM   1063  CA  LEU    70      -3.696   1.294   5.709  1.00 12.35           C  
ATOM   1064  C   LEU    70      -5.207   1.188   5.443  1.00 52.51           C  
ATOM   1065  O   LEU    70      -5.639   0.449   4.550  1.00  2.32           O  
ATOM   1066  CB  LEU    70      -3.002   2.054   4.562  1.00 61.41           C  
ATOM   1067  CG  LEU    70      -3.459   3.511   4.357  1.00 74.43           C  
ATOM   1068  CD1 LEU    70      -3.134   4.366   5.584  1.00 53.53           C  
ATOM   1069  CD2 LEU    70      -2.820   4.100   3.100  1.00 51.44           C  
ATOM   1070  H   LEU    70      -3.166  -0.683   5.130  1.00 37.41           H  
ATOM   1071  HA  LEU    70      -3.544   1.837   6.631  1.00 30.15           H  
ATOM   1072  HB2 LEU    70      -1.937   2.057   4.757  1.00 37.41           H  
ATOM   1073  HB3 LEU    70      -3.177   1.512   3.643  1.00 37.41           H  
ATOM   1074  HG  LEU    70      -4.530   3.526   4.222  1.00 53.12           H  
ATOM   1075 HD11 LEU    70      -3.620   3.946   6.453  1.00 37.41           H  
ATOM   1076 HD12 LEU    70      -3.491   5.374   5.426  1.00 37.41           H  
ATOM   1077 HD13 LEU    70      -2.066   4.384   5.742  1.00 37.41           H  
ATOM   1078 HD21 LEU    70      -3.146   5.121   2.972  1.00 37.41           H  
ATOM   1079 HD22 LEU    70      -3.117   3.519   2.239  1.00 37.41           H  
ATOM   1080 HD23 LEU    70      -1.744   4.076   3.194  1.00 37.41           H  
ATOM   1081  N   LYS    71      -6.004   1.925   6.220  1.00 35.23           N  
ATOM   1082  CA  LYS    71      -7.465   1.907   6.076  1.00 73.11           C  
ATOM   1083  C   LYS    71      -8.014   3.253   5.581  1.00 73.01           C  
ATOM   1084  O   LYS    71      -7.513   4.317   5.942  1.00  2.23           O  
ATOM   1085  CB  LYS    71      -8.145   1.557   7.410  1.00 52.54           C  
ATOM   1086  CG  LYS    71      -7.870   0.143   7.914  1.00  3.44           C  
ATOM   1087  CD  LYS    71      -8.818  -0.226   9.058  1.00 43.11           C  
ATOM   1088  CE  LYS    71      -8.538  -1.614   9.626  1.00  2.32           C  
ATOM   1089  NZ  LYS    71      -7.195  -1.709  10.252  1.00 63.42           N  
ATOM   1090  H   LYS    71      -5.604   2.503   6.907  1.00 37.41           H  
ATOM   1091  HA  LYS    71      -7.718   1.146   5.350  1.00 23.22           H  
ATOM   1092  HB2 LYS    71      -7.803   2.251   8.165  1.00 37.41           H  
ATOM   1093  HB3 LYS    71      -9.216   1.669   7.293  1.00 37.41           H  
ATOM   1094  HG2 LYS    71      -8.009  -0.555   7.100  1.00 37.41           H  
ATOM   1095  HG3 LYS    71      -6.848   0.086   8.269  1.00 37.41           H  
ATOM   1096  HD2 LYS    71      -8.714   0.502   9.850  1.00 37.41           H  
ATOM   1097  HD3 LYS    71      -9.832  -0.201   8.685  1.00 37.41           H  
ATOM   1098  HE2 LYS    71      -9.287  -1.839  10.372  1.00 37.41           H  
ATOM   1099  HE3 LYS    71      -8.605  -2.337   8.826  1.00 37.41           H  
ATOM   1100  HZ1 LYS    71      -7.050  -0.916  10.911  1.00 37.41           H  
ATOM   1101  HZ2 LYS    71      -6.452  -1.683   9.527  1.00 37.41           H  
ATOM   1102  HZ3 LYS    71      -7.112  -2.600  10.783  1.00 37.41           H  
ATOM   1103  N   ALA    72      -9.056   3.195   4.754  1.00 64.14           N  
ATOM   1104  CA  ALA    72      -9.782   4.398   4.334  1.00 62.42           C  
ATOM   1105  C   ALA    72     -10.779   4.839   5.421  1.00 74.43           C  
ATOM   1106  O   ALA    72     -10.918   4.172   6.448  1.00 34.50           O  
ATOM   1107  CB  ALA    72     -10.504   4.149   3.016  1.00 73.22           C  
ATOM   1108  H   ALA    72      -9.341   2.319   4.415  1.00 37.41           H  
ATOM   1109  HA  ALA    72      -9.062   5.190   4.180  1.00 74.24           H  
ATOM   1110  HB1 ALA    72      -9.793   3.834   2.267  1.00 37.41           H  
ATOM   1111  HB2 ALA    72     -10.990   5.059   2.691  1.00 37.41           H  
ATOM   1112  HB3 ALA    72     -11.247   3.377   3.152  1.00 37.41           H  
ATOM   1113  N   ALA    73     -11.471   5.956   5.194  1.00 12.14           N  
ATOM   1114  CA  ALA    73     -12.418   6.506   6.181  1.00 23.01           C  
ATOM   1115  C   ALA    73     -13.482   5.481   6.617  1.00 13.03           C  
ATOM   1116  O   ALA    73     -13.840   5.409   7.791  1.00 75.11           O  
ATOM   1117  CB  ALA    73     -13.091   7.756   5.622  1.00 23.52           C  
ATOM   1118  H   ALA    73     -11.348   6.428   4.343  1.00 37.41           H  
ATOM   1119  HA  ALA    73     -11.846   6.801   7.050  1.00 75.03           H  
ATOM   1120  HB1 ALA    73     -13.668   7.495   4.745  1.00 37.41           H  
ATOM   1121  HB2 ALA    73     -12.336   8.482   5.351  1.00 37.41           H  
ATOM   1122  HB3 ALA    73     -13.746   8.182   6.369  1.00 37.41           H  
ATOM   1123  N   ASN    74     -13.975   4.682   5.668  1.00 14.50           N  
ATOM   1124  CA  ASN    74     -14.995   3.662   5.962  1.00 44.41           C  
ATOM   1125  C   ASN    74     -14.373   2.400   6.607  1.00 22.25           C  
ATOM   1126  O   ASN    74     -15.018   1.355   6.708  1.00 15.02           O  
ATOM   1127  CB  ASN    74     -15.760   3.307   4.675  1.00 73.15           C  
ATOM   1128  CG  ASN    74     -17.051   2.547   4.943  1.00 61.34           C  
ATOM   1129  OD1 ASN    74     -18.083   3.137   5.242  1.00  2.04           O  
ATOM   1130  ND2 ASN    74     -17.016   1.235   4.823  1.00 24.03           N  
ATOM   1131  H   ASN    74     -13.661   4.793   4.747  1.00 37.41           H  
ATOM   1132  HA  ASN    74     -15.692   4.094   6.667  1.00 11.14           H  
ATOM   1133  HB2 ASN    74     -16.008   4.219   4.148  1.00 37.41           H  
ATOM   1134  HB3 ASN    74     -15.129   2.697   4.044  1.00 37.41           H  
ATOM   1135 HD21 ASN    74     -16.171   0.813   4.570  1.00 37.41           H  
ATOM   1136 HD22 ASN    74     -17.843   0.739   4.984  1.00 37.41           H  
ATOM   1137  N   HIS    75     -13.105   2.509   7.018  1.00 14.22           N  
ATOM   1138  CA  HIS    75     -12.421   1.473   7.820  1.00 24.34           C  
ATOM   1139  C   HIS    75     -12.106   0.216   6.985  1.00 63.04           C  
ATOM   1140  O   HIS    75     -11.936  -0.882   7.520  1.00 64.04           O  
ATOM   1141  CB  HIS    75     -13.274   1.119   9.054  1.00 34.43           C  
ATOM   1142  CG  HIS    75     -12.532   0.386  10.133  1.00 15.42           C  
ATOM   1143  ND1 HIS    75     -12.548  -0.986  10.265  1.00  2.12           N  
ATOM   1144  CD2 HIS    75     -11.764   0.847  11.149  1.00 71.01           C  
ATOM   1145  CE1 HIS    75     -11.827  -1.335  11.311  1.00 72.22           C  
ATOM   1146  NE2 HIS    75     -11.339  -0.245  11.865  1.00 11.40           N  
ATOM   1147  H   HIS    75     -12.605   3.312   6.767  1.00 37.41           H  
ATOM   1148  HA  HIS    75     -11.486   1.895   8.157  1.00 70.03           H  
ATOM   1149  HB2 HIS    75     -13.657   2.031   9.486  1.00 37.41           H  
ATOM   1150  HB3 HIS    75     -14.105   0.501   8.745  1.00 37.41           H  
ATOM   1151  HD1 HIS    75     -13.019  -1.614   9.676  1.00 74.14           H  
ATOM   1152  HD2 HIS    75     -11.527   1.882  11.355  1.00 62.31           H  
ATOM   1153  HE1 HIS    75     -11.662  -2.346  11.653  1.00 23.12           H  
ATOM   1154  HE2 HIS    75     -10.934  -0.206  12.760  1.00 37.41           H  
ATOM   1155  N   GLN    76     -11.995   0.406   5.675  1.00 70.15           N  
ATOM   1156  CA  GLN    76     -11.689  -0.683   4.736  1.00 74.21           C  
ATOM   1157  C   GLN    76     -10.171  -0.827   4.527  1.00 71.43           C  
ATOM   1158  O   GLN    76      -9.428   0.149   4.651  1.00 53.14           O  
ATOM   1159  CB  GLN    76     -12.374  -0.393   3.393  1.00 42.12           C  
ATOM   1160  CG  GLN    76     -11.825   0.848   2.691  1.00 15.10           C  
ATOM   1161  CD  GLN    76     -12.765   1.405   1.641  1.00  1.43           C  
ATOM   1162  OE1 GLN    76     -12.715   1.031   0.471  1.00 50.25           O  
ATOM   1163  NE2 GLN    76     -13.614   2.324   2.052  1.00 12.54           N  
ATOM   1164  H   GLN    76     -12.121   1.309   5.323  1.00 37.41           H  
ATOM   1165  HA  GLN    76     -12.081  -1.604   5.143  1.00  5.43           H  
ATOM   1166  HB2 GLN    76     -12.235  -1.243   2.738  1.00 37.41           H  
ATOM   1167  HB3 GLN    76     -13.432  -0.249   3.563  1.00 37.41           H  
ATOM   1168  HG2 GLN    76     -11.647   1.615   3.431  1.00 37.41           H  
ATOM   1169  HG3 GLN    76     -10.889   0.592   2.215  1.00 37.41           H  
ATOM   1170 HE21 GLN    76     -13.589   2.593   2.992  1.00 37.41           H  
ATOM   1171 HE22 GLN    76     -14.248   2.691   1.397  1.00 37.41           H  
ATOM   1172  N   ILE    77      -9.715  -2.035   4.194  1.00 32.34           N  
ATOM   1173  CA  ILE    77      -8.283  -2.295   3.979  1.00 40.03           C  
ATOM   1174  C   ILE    77      -7.868  -1.955   2.540  1.00 24.44           C  
ATOM   1175  O   ILE    77      -8.107  -2.731   1.612  1.00 71.02           O  
ATOM   1176  CB  ILE    77      -7.923  -3.778   4.274  1.00 72.54           C  
ATOM   1177  CG1 ILE    77      -8.252  -4.137   5.732  1.00 71.52           C  
ATOM   1178  CG2 ILE    77      -6.445  -4.051   3.976  1.00 55.33           C  
ATOM   1179  CD1 ILE    77      -7.418  -3.391   6.752  1.00  4.14           C  
ATOM   1180  H   ILE    77     -10.356  -2.767   4.072  1.00 37.41           H  
ATOM   1181  HA  ILE    77      -7.722  -1.669   4.662  1.00 54.33           H  
ATOM   1182  HB  ILE    77      -8.514  -4.401   3.617  1.00 41.44           H  
ATOM   1183 HG12 ILE    77      -9.289  -3.910   5.927  1.00 37.41           H  
ATOM   1184 HG13 ILE    77      -8.090  -5.196   5.881  1.00 37.41           H  
ATOM   1185 HG21 ILE    77      -6.214  -5.082   4.206  1.00 37.41           H  
ATOM   1186 HG22 ILE    77      -5.826  -3.401   4.579  1.00 37.41           H  
ATOM   1187 HG23 ILE    77      -6.247  -3.865   2.930  1.00 37.41           H  
ATOM   1188 HD11 ILE    77      -6.377  -3.650   6.624  1.00 37.41           H  
ATOM   1189 HD12 ILE    77      -7.735  -3.667   7.746  1.00 37.41           H  
ATOM   1190 HD13 ILE    77      -7.545  -2.327   6.616  1.00 37.41           H  
ATOM   1191  N   ILE    78      -7.258  -0.789   2.357  1.00 42.24           N  
ATOM   1192  CA  ILE    78      -6.824  -0.346   1.024  1.00 51.22           C  
ATOM   1193  C   ILE    78      -5.345  -0.674   0.761  1.00 70.34           C  
ATOM   1194  O   ILE    78      -4.940  -0.865  -0.388  1.00 50.21           O  
ATOM   1195  CB  ILE    78      -7.057   1.174   0.830  1.00 32.12           C  
ATOM   1196  CG1 ILE    78      -6.289   1.979   1.892  1.00 53.32           C  
ATOM   1197  CG2 ILE    78      -8.551   1.494   0.876  1.00 11.03           C  
ATOM   1198  CD1 ILE    78      -6.479   3.475   1.785  1.00 34.20           C  
ATOM   1199  H   ILE    78      -7.099  -0.209   3.131  1.00 37.41           H  
ATOM   1200  HA  ILE    78      -7.424  -0.870   0.290  1.00 62.01           H  
ATOM   1201  HB  ILE    78      -6.691   1.447  -0.151  1.00 52.10           H  
ATOM   1202 HG12 ILE    78      -6.619   1.676   2.875  1.00 37.41           H  
ATOM   1203 HG13 ILE    78      -5.231   1.773   1.796  1.00 37.41           H  
ATOM   1204 HG21 ILE    78      -8.701   2.554   0.726  1.00 37.41           H  
ATOM   1205 HG22 ILE    78      -8.953   1.206   1.838  1.00 37.41           H  
ATOM   1206 HG23 ILE    78      -9.062   0.945   0.097  1.00 37.41           H  
ATOM   1207 HD11 ILE    78      -5.860   3.968   2.520  1.00 37.41           H  
ATOM   1208 HD12 ILE    78      -7.515   3.722   1.966  1.00 37.41           H  
ATOM   1209 HD13 ILE    78      -6.198   3.807   0.798  1.00 37.41           H  
ATOM   1210  N   GLY    79      -4.543  -0.740   1.826  1.00 72.31           N  
ATOM   1211  CA  GLY    79      -3.118  -1.037   1.679  1.00 14.54           C  
ATOM   1212  C   GLY    79      -2.586  -2.007   2.734  1.00 61.14           C  
ATOM   1213  O   GLY    79      -3.094  -2.060   3.853  1.00 22.12           O  
ATOM   1214  H   GLY    79      -4.920  -0.581   2.720  1.00 37.41           H  
ATOM   1215  HA2 GLY    79      -2.948  -1.464   0.699  1.00 37.41           H  
ATOM   1216  HA3 GLY    79      -2.566  -0.111   1.750  1.00 37.41           H  
ATOM   1217  N   THR    80      -1.552  -2.767   2.373  1.00 55.11           N  
ATOM   1218  CA  THR    80      -0.925  -3.738   3.289  1.00 61.41           C  
ATOM   1219  C   THR    80       0.586  -3.837   3.039  1.00 45.05           C  
ATOM   1220  O   THR    80       1.017  -4.076   1.916  1.00 71.44           O  
ATOM   1221  CB  THR    80      -1.558  -5.147   3.137  1.00 41.01           C  
ATOM   1222  OG1 THR    80      -2.947  -5.106   3.503  1.00 65.52           O  
ATOM   1223  CG2 THR    80      -0.837  -6.182   3.998  1.00  5.43           C  
ATOM   1224  H   THR    80      -1.195  -2.681   1.463  1.00 37.41           H  
ATOM   1225  HA  THR    80      -1.093  -3.397   4.304  1.00 64.32           H  
ATOM   1226  HB  THR    80      -1.480  -5.447   2.100  1.00 64.12           H  
ATOM   1227  HG1 THR    80      -3.488  -5.116   2.709  1.00 11.42           H  
ATOM   1228 HG21 THR    80      -0.865  -5.876   5.034  1.00 37.41           H  
ATOM   1229 HG22 THR    80       0.192  -6.269   3.677  1.00 37.41           H  
ATOM   1230 HG23 THR    80      -1.326  -7.140   3.896  1.00 37.41           H  
ATOM   1231  N   SER    81       1.385  -3.644   4.084  1.00 55.20           N  
ATOM   1232  CA  SER    81       2.854  -3.672   3.956  1.00 70.42           C  
ATOM   1233  C   SER    81       3.435  -5.074   4.181  1.00  1.13           C  
ATOM   1234  O   SER    81       2.783  -5.955   4.752  1.00  0.21           O  
ATOM   1235  CB  SER    81       3.496  -2.690   4.943  1.00 14.40           C  
ATOM   1236  OG  SER    81       4.910  -2.741   4.869  1.00 40.10           O  
ATOM   1237  H   SER    81       0.986  -3.476   4.965  1.00 37.41           H  
ATOM   1238  HA  SER    81       3.099  -3.358   2.950  1.00 32.31           H  
ATOM   1239  HB2 SER    81       3.174  -1.686   4.710  1.00 37.41           H  
ATOM   1240  HB3 SER    81       3.189  -2.937   5.950  1.00 37.41           H  
ATOM   1241  HG  SER    81       5.256  -1.873   4.625  1.00 61.12           H  
ATOM   1242  N   GLN    82       4.677  -5.271   3.739  1.00  5.15           N  
ATOM   1243  CA  GLN    82       5.359  -6.558   3.892  1.00 21.22           C  
ATOM   1244  C   GLN    82       6.166  -6.618   5.200  1.00 62.30           C  
ATOM   1245  O   GLN    82       6.863  -5.668   5.560  1.00 11.14           O  
ATOM   1246  CB  GLN    82       6.300  -6.835   2.704  1.00 60.54           C  
ATOM   1247  CG  GLN    82       5.623  -6.827   1.331  1.00 40.12           C  
ATOM   1248  CD  GLN    82       5.440  -5.429   0.762  1.00 34.15           C  
ATOM   1249  OE1 GLN    82       4.416  -4.784   0.956  1.00 74.24           O  
ATOM   1250  NE2 GLN    82       6.438  -4.949   0.049  1.00 13.44           N  
ATOM   1251  H   GLN    82       5.147  -4.528   3.306  1.00 37.41           H  
ATOM   1252  HA  GLN    82       4.602  -7.330   3.918  1.00 24.02           H  
ATOM   1253  HB2 GLN    82       7.079  -6.085   2.698  1.00 37.41           H  
ATOM   1254  HB3 GLN    82       6.756  -7.805   2.847  1.00 37.41           H  
ATOM   1255  HG2 GLN    82       6.229  -7.400   0.645  1.00 37.41           H  
ATOM   1256  HG3 GLN    82       4.651  -7.295   1.421  1.00 37.41           H  
ATOM   1257 HE21 GLN    82       7.232  -5.512  -0.077  1.00 37.41           H  
ATOM   1258 HE22 GLN    82       6.351  -4.046  -0.311  1.00 37.41           H  
ATOM   1259  N   MET    83       6.062  -7.752   5.893  1.00 21.12           N  
ATOM   1260  CA  MET    83       6.801  -8.008   7.140  1.00 20.12           C  
ATOM   1261  C   MET    83       8.272  -7.528   7.081  1.00 52.45           C  
ATOM   1262  O   MET    83       9.072  -8.020   6.280  1.00 11.10           O  
ATOM   1263  CB  MET    83       6.744  -9.512   7.447  1.00 43.35           C  
ATOM   1264  CG  MET    83       7.207 -10.389   6.284  1.00  3.32           C  
ATOM   1265  SD  MET    83       6.966 -12.151   6.591  1.00 54.34           S  
ATOM   1266  CE  MET    83       7.519 -12.842   5.032  1.00 11.34           C  
ATOM   1267  H   MET    83       5.448  -8.442   5.563  1.00 37.41           H  
ATOM   1268  HA  MET    83       6.297  -7.475   7.933  1.00 14.22           H  
ATOM   1269  HB2 MET    83       7.371  -9.722   8.305  1.00 37.41           H  
ATOM   1270  HB3 MET    83       5.724  -9.780   7.687  1.00 37.41           H  
ATOM   1271  HG2 MET    83       6.649 -10.117   5.399  1.00 37.41           H  
ATOM   1272  HG3 MET    83       8.258 -10.210   6.111  1.00 37.41           H  
ATOM   1273  HE1 MET    83       8.537 -12.535   4.843  1.00 37.41           H  
ATOM   1274  HE2 MET    83       6.882 -12.488   4.235  1.00 37.41           H  
ATOM   1275  HE3 MET    83       7.472 -13.919   5.079  1.00 37.41           H  
ATOM   1276  N   TYR    84       8.613  -6.554   7.932  1.00 31.51           N  
ATOM   1277  CA  TYR    84       9.984  -6.026   8.013  1.00 62.50           C  
ATOM   1278  C   TYR    84      10.837  -6.825   9.012  1.00 11.43           C  
ATOM   1279  O   TYR    84      10.323  -7.658   9.759  1.00 44.01           O  
ATOM   1280  CB  TYR    84       9.965  -4.547   8.426  1.00 12.32           C  
ATOM   1281  CG  TYR    84       9.245  -3.642   7.444  1.00 41.13           C  
ATOM   1282  CD1 TYR    84       9.902  -3.121   6.334  1.00 70.11           C  
ATOM   1283  CD2 TYR    84       7.905  -3.308   7.626  1.00 12.42           C  
ATOM   1284  CE1 TYR    84       9.250  -2.294   5.440  1.00  1.15           C  
ATOM   1285  CE2 TYR    84       7.248  -2.483   6.735  1.00 14.23           C  
ATOM   1286  CZ  TYR    84       7.924  -1.978   5.644  1.00 12.04           C  
ATOM   1287  OH  TYR    84       7.268  -1.156   4.750  1.00 22.12           O  
ATOM   1288  H   TYR    84       7.924  -6.176   8.519  1.00 37.41           H  
ATOM   1289  HA  TYR    84      10.433  -6.109   7.032  1.00 13.23           H  
ATOM   1290  HB2 TYR    84       9.470  -4.455   9.383  1.00 37.41           H  
ATOM   1291  HB3 TYR    84      10.982  -4.193   8.520  1.00 37.41           H  
ATOM   1292  HD1 TYR    84      10.941  -3.370   6.174  1.00 62.23           H  
ATOM   1293  HD2 TYR    84       7.378  -3.702   8.483  1.00 30.20           H  
ATOM   1294  HE1 TYR    84       9.780  -1.899   4.585  1.00 12.23           H  
ATOM   1295  HE2 TYR    84       6.209  -2.237   6.896  1.00 61.43           H  
ATOM   1296  HH  TYR    84       7.405  -1.483   3.856  1.00 43.33           H  
ATOM   1297  N   SER    85      12.141  -6.561   9.027  1.00 13.02           N  
ATOM   1298  CA  SER    85      13.061  -7.245   9.949  1.00 52.24           C  
ATOM   1299  C   SER    85      13.109  -6.551  11.317  1.00 42.44           C  
ATOM   1300  O   SER    85      12.815  -7.158  12.349  1.00  1.01           O  
ATOM   1301  CB  SER    85      14.472  -7.300   9.348  1.00 54.31           C  
ATOM   1302  OG  SER    85      14.975  -5.995   9.092  1.00 43.35           O  
ATOM   1303  H   SER    85      12.498  -5.896   8.403  1.00 37.41           H  
ATOM   1304  HA  SER    85      12.702  -8.256  10.086  1.00 51.40           H  
ATOM   1305  HB2 SER    85      15.137  -7.798  10.039  1.00 37.41           H  
ATOM   1306  HB3 SER    85      14.443  -7.850   8.418  1.00 37.41           H  
ATOM   1307  HG  SER    85      15.881  -6.067   8.762  1.00  2.54           H  
ATOM   1308  N   SER    86      13.502  -5.279  11.322  1.00 63.42           N  
ATOM   1309  CA  SER    86      13.582  -4.489  12.559  1.00 74.23           C  
ATOM   1310  C   SER    86      12.373  -3.556  12.705  1.00 73.32           C  
ATOM   1311  O   SER    86      11.706  -3.226  11.719  1.00 23.32           O  
ATOM   1312  CB  SER    86      14.864  -3.644  12.572  1.00 54.32           C  
ATOM   1313  OG  SER    86      14.833  -2.648  11.557  1.00 20.40           O  
ATOM   1314  H   SER    86      13.752  -4.859  10.472  1.00 37.41           H  
ATOM   1315  HA  SER    86      13.604  -5.173  13.397  1.00 44.14           H  
ATOM   1316  HB2 SER    86      14.965  -3.158  13.532  1.00 37.41           H  
ATOM   1317  HB3 SER    86      15.718  -4.286  12.404  1.00 37.41           H  
ATOM   1318  HG  SER    86      15.653  -2.682  11.042  1.00 20.51           H  
ATOM   1319  N   THR    87      12.093  -3.124  13.933  1.00 65.31           N  
ATOM   1320  CA  THR    87      11.020  -2.149  14.177  1.00 45.55           C  
ATOM   1321  C   THR    87      11.331  -0.822  13.479  1.00 11.24           C  
ATOM   1322  O   THR    87      10.457  -0.203  12.870  1.00 23.25           O  
ATOM   1323  CB  THR    87      10.808  -1.882  15.687  1.00 50.10           C  
ATOM   1324  OG1 THR    87      11.999  -1.322  16.264  1.00 33.13           O  
ATOM   1325  CG2 THR    87      10.444  -3.167  16.423  1.00 61.13           C  
ATOM   1326  H   THR    87      12.616  -3.464  14.695  1.00 37.41           H  
ATOM   1327  HA  THR    87      10.102  -2.553  13.769  1.00 30.01           H  
ATOM   1328  HB  THR    87       9.997  -1.177  15.803  1.00 74.14           H  
ATOM   1329  HG1 THR    87      11.760  -0.583  16.839  1.00  3.11           H  
ATOM   1330 HG21 THR    87      11.243  -3.887  16.310  1.00 37.41           H  
ATOM   1331 HG22 THR    87       9.531  -3.574  16.010  1.00 37.41           H  
ATOM   1332 HG23 THR    87      10.299  -2.953  17.472  1.00 37.41           H  
ATOM   1333  N   ALA    88      12.596  -0.405  13.561  1.00 52.20           N  
ATOM   1334  CA  ALA    88      13.069   0.810  12.892  1.00 21.41           C  
ATOM   1335  C   ALA    88      12.811   0.757  11.376  1.00 34.01           C  
ATOM   1336  O   ALA    88      12.411   1.755  10.775  1.00 31.42           O  
ATOM   1337  CB  ALA    88      14.554   1.029  13.174  1.00 62.43           C  
ATOM   1338  H   ALA    88      13.229  -0.927  14.098  1.00 37.41           H  
ATOM   1339  HA  ALA    88      12.525   1.647  13.307  1.00 22.44           H  
ATOM   1340  HB1 ALA    88      14.722   1.033  14.240  1.00 37.41           H  
ATOM   1341  HB2 ALA    88      14.865   1.977  12.759  1.00 37.41           H  
ATOM   1342  HB3 ALA    88      15.131   0.234  12.723  1.00 37.41           H  
ATOM   1343  N   ALA    89      13.041  -0.408  10.763  1.00 22.32           N  
ATOM   1344  CA  ALA    89      12.750  -0.606   9.334  1.00 24.30           C  
ATOM   1345  C   ALA    89      11.290  -0.260   9.009  1.00 74.43           C  
ATOM   1346  O   ALA    89      10.999   0.381   7.999  1.00 61.43           O  
ATOM   1347  CB  ALA    89      13.051  -2.044   8.923  1.00 34.13           C  
ATOM   1348  H   ALA    89      13.429  -1.150  11.279  1.00 37.41           H  
ATOM   1349  HA  ALA    89      13.399   0.050   8.770  1.00 31.22           H  
ATOM   1350  HB1 ALA    89      12.424  -2.721   9.486  1.00 37.41           H  
ATOM   1351  HB2 ALA    89      14.088  -2.266   9.123  1.00 37.41           H  
ATOM   1352  HB3 ALA    89      12.855  -2.167   7.866  1.00 37.41           H  
ATOM   1353  N   ARG    90      10.381  -0.684   9.883  1.00 11.00           N  
ATOM   1354  CA  ARG    90       8.951  -0.412   9.713  1.00 33.04           C  
ATOM   1355  C   ARG    90       8.652   1.096   9.741  1.00 30.22           C  
ATOM   1356  O   ARG    90       8.065   1.641   8.808  1.00 73.34           O  
ATOM   1357  CB  ARG    90       8.152  -1.104  10.823  1.00 44.22           C  
ATOM   1358  CG  ARG    90       6.644  -0.872  10.740  1.00 45.02           C  
ATOM   1359  CD  ARG    90       5.953  -1.217  12.052  1.00 61.31           C  
ATOM   1360  NE  ARG    90       6.448  -0.396  13.158  1.00 33.23           N  
ATOM   1361  CZ  ARG    90       5.953  -0.406  14.365  1.00 13.35           C  
ATOM   1362  NH1 ARG    90       4.968  -1.191  14.672  1.00 64.35           N  
ATOM   1363  NH2 ARG    90       6.455   0.371  15.264  1.00 43.35           N  
ATOM   1364  H   ARG    90      10.680  -1.197  10.664  1.00 37.41           H  
ATOM   1365  HA  ARG    90       8.646  -0.814   8.758  1.00 34.12           H  
ATOM   1366  HB2 ARG    90       8.335  -2.169  10.770  1.00 37.41           H  
ATOM   1367  HB3 ARG    90       8.499  -0.738  11.779  1.00 37.41           H  
ATOM   1368  HG2 ARG    90       6.459   0.170  10.512  1.00 37.41           H  
ATOM   1369  HG3 ARG    90       6.236  -1.491   9.952  1.00 37.41           H  
ATOM   1370  HD2 ARG    90       4.890  -1.054  11.938  1.00 37.41           H  
ATOM   1371  HD3 ARG    90       6.135  -2.259  12.277  1.00 37.41           H  
ATOM   1372  HE  ARG    90       7.196   0.212  12.977  1.00 52.40           H  
ATOM   1373 HH11 ARG    90       4.581  -1.794  13.988  1.00 37.41           H  
ATOM   1374 HH12 ARG    90       4.591  -1.178  15.600  1.00 37.41           H  
ATOM   1375 HH21 ARG    90       7.217   0.980  15.028  1.00 37.41           H  
ATOM   1376 HH22 ARG    90       6.080   0.373  16.190  1.00 37.41           H  
ATOM   1377  N   ASP    91       9.064   1.763  10.816  1.00 40.42           N  
ATOM   1378  CA  ASP    91       8.766   3.187  11.006  1.00  2.52           C  
ATOM   1379  C   ASP    91       9.501   4.082   9.985  1.00 70.24           C  
ATOM   1380  O   ASP    91       8.964   5.108   9.551  1.00 75.01           O  
ATOM   1381  CB  ASP    91       9.087   3.594  12.447  1.00 21.44           C  
ATOM   1382  CG  ASP    91       8.134   2.936  13.440  1.00  2.12           C  
ATOM   1383  OD1 ASP    91       8.377   1.775  13.833  1.00 23.12           O  
ATOM   1384  OD2 ASP    91       7.127   3.571  13.818  1.00 30.33           O  
ATOM   1385  H   ASP    91       9.578   1.286  11.507  1.00 37.41           H  
ATOM   1386  HA  ASP    91       7.702   3.311  10.850  1.00 41.42           H  
ATOM   1387  HB2 ASP    91      10.099   3.294  12.684  1.00 37.41           H  
ATOM   1388  HB3 ASP    91       9.003   4.668  12.545  1.00 37.41           H  
ATOM   1389  N   ASN    92      10.717   3.698   9.593  1.00 24.54           N  
ATOM   1390  CA  ASN    92      11.417   4.388   8.500  1.00 43.40           C  
ATOM   1391  C   ASN    92      10.694   4.148   7.170  1.00 41.23           C  
ATOM   1392  O   ASN    92      10.585   5.048   6.331  1.00  5.51           O  
ATOM   1393  CB  ASN    92      12.887   3.949   8.402  1.00 21.14           C  
ATOM   1394  CG  ASN    92      13.772   4.674   9.401  1.00  3.32           C  
ATOM   1395  OD1 ASN    92      14.285   5.755   9.126  1.00  3.13           O  
ATOM   1396  ND2 ASN    92      13.967   4.091  10.563  1.00 32.32           N  
ATOM   1397  H   ASN    92      11.145   2.938  10.038  1.00 37.41           H  
ATOM   1398  HA  ASN    92      11.384   5.449   8.713  1.00 54.44           H  
ATOM   1399  HB2 ASN    92      12.954   2.888   8.595  1.00 37.41           H  
ATOM   1400  HB3 ASN    92      13.258   4.152   7.408  1.00 37.41           H  
ATOM   1401 HD21 ASN    92      13.540   3.227  10.725  1.00 37.41           H  
ATOM   1402 HD22 ASN    92      14.534   4.551  11.217  1.00 37.41           H  
ATOM   1403  N   GLY    93      10.190   2.929   6.988  1.00 33.01           N  
ATOM   1404  CA  GLY    93       9.344   2.637   5.843  1.00 30.33           C  
ATOM   1405  C   GLY    93       8.134   3.563   5.786  1.00 44.40           C  
ATOM   1406  O   GLY    93       7.849   4.154   4.747  1.00 20.01           O  
ATOM   1407  H   GLY    93      10.397   2.219   7.635  1.00 37.41           H  
ATOM   1408  HA2 GLY    93       9.924   2.753   4.939  1.00 37.41           H  
ATOM   1409  HA3 GLY    93       9.003   1.614   5.912  1.00 37.41           H  
ATOM   1410  N   ILE    94       7.447   3.709   6.923  1.00 62.14           N  
ATOM   1411  CA  ILE    94       6.288   4.608   7.043  1.00 63.01           C  
ATOM   1412  C   ILE    94       6.627   6.044   6.601  1.00 65.20           C  
ATOM   1413  O   ILE    94       5.849   6.682   5.889  1.00 33.41           O  
ATOM   1414  CB  ILE    94       5.743   4.632   8.499  1.00 21.43           C  
ATOM   1415  CG1 ILE    94       5.302   3.219   8.929  1.00 22.41           C  
ATOM   1416  CG2 ILE    94       4.585   5.624   8.628  1.00 31.41           C  
ATOM   1417  CD1 ILE    94       4.824   3.133  10.365  1.00  5.53           C  
ATOM   1418  H   ILE    94       7.722   3.187   7.707  1.00 37.41           H  
ATOM   1419  HA  ILE    94       5.507   4.226   6.398  1.00 63.10           H  
ATOM   1420  HB  ILE    94       6.540   4.963   9.151  1.00 62.24           H  
ATOM   1421 HG12 ILE    94       4.489   2.896   8.295  1.00 37.41           H  
ATOM   1422 HG13 ILE    94       6.133   2.537   8.814  1.00 37.41           H  
ATOM   1423 HG21 ILE    94       4.214   5.620   9.643  1.00 37.41           H  
ATOM   1424 HG22 ILE    94       3.789   5.340   7.954  1.00 37.41           H  
ATOM   1425 HG23 ILE    94       4.930   6.617   8.377  1.00 37.41           H  
ATOM   1426 HD11 ILE    94       3.967   3.777  10.500  1.00 37.41           H  
ATOM   1427 HD12 ILE    94       5.616   3.447  11.029  1.00 37.41           H  
ATOM   1428 HD13 ILE    94       4.547   2.114  10.593  1.00 37.41           H  
ATOM   1429  N   LYS    95       7.788   6.552   7.022  1.00 12.12           N  
ATOM   1430  CA  LYS    95       8.235   7.888   6.599  1.00  3.54           C  
ATOM   1431  C   LYS    95       8.322   7.975   5.064  1.00 12.31           C  
ATOM   1432  O   LYS    95       7.893   8.962   4.450  1.00 50.22           O  
ATOM   1433  CB  LYS    95       9.593   8.237   7.227  1.00 22.14           C  
ATOM   1434  CG  LYS    95       9.587   8.239   8.756  1.00  4.23           C  
ATOM   1435  CD  LYS    95      10.887   8.798   9.339  1.00 72.42           C  
ATOM   1436  CE  LYS    95      12.109   7.977   8.938  1.00 70.43           C  
ATOM   1437  NZ  LYS    95      13.371   8.537   9.501  1.00 24.34           N  
ATOM   1438  H   LYS    95       8.350   6.022   7.631  1.00 37.41           H  
ATOM   1439  HA  LYS    95       7.498   8.603   6.941  1.00 23.11           H  
ATOM   1440  HB2 LYS    95      10.326   7.516   6.891  1.00 37.41           H  
ATOM   1441  HB3 LYS    95       9.889   9.221   6.888  1.00 37.41           H  
ATOM   1442  HG2 LYS    95       8.761   8.846   9.101  1.00 37.41           H  
ATOM   1443  HG3 LYS    95       9.455   7.224   9.104  1.00 37.41           H  
ATOM   1444  HD2 LYS    95      11.020   9.810   8.984  1.00 37.41           H  
ATOM   1445  HD3 LYS    95      10.809   8.806  10.417  1.00 37.41           H  
ATOM   1446  HE2 LYS    95      11.985   6.967   9.301  1.00 37.41           H  
ATOM   1447  HE3 LYS    95      12.184   7.965   7.859  1.00 37.41           H  
ATOM   1448  HZ1 LYS    95      14.163   7.886   9.326  1.00 37.41           H  
ATOM   1449  HZ2 LYS    95      13.276   8.681  10.528  1.00 37.41           H  
ATOM   1450  HZ3 LYS    95      13.591   9.450   9.056  1.00 37.41           H  
ATOM   1451  N   SER    96       8.874   6.930   4.450  1.00 12.50           N  
ATOM   1452  CA  SER    96       8.935   6.835   2.987  1.00 44.14           C  
ATOM   1453  C   SER    96       7.523   6.782   2.387  1.00 64.41           C  
ATOM   1454  O   SER    96       7.223   7.487   1.426  1.00 44.33           O  
ATOM   1455  CB  SER    96       9.733   5.594   2.559  1.00 22.51           C  
ATOM   1456  OG  SER    96      11.057   5.631   3.076  1.00 73.53           O  
ATOM   1457  H   SER    96       9.251   6.202   4.993  1.00 37.41           H  
ATOM   1458  HA  SER    96       9.437   7.720   2.617  1.00 20.13           H  
ATOM   1459  HB2 SER    96       9.243   4.706   2.928  1.00 37.41           H  
ATOM   1460  HB3 SER    96       9.785   5.554   1.479  1.00 37.41           H  
ATOM   1461  HG  SER    96      11.063   5.256   3.966  1.00 64.30           H  
ATOM   1462  N   VAL    97       6.660   5.955   2.985  1.00 22.23           N  
ATOM   1463  CA  VAL    97       5.264   5.803   2.542  1.00 24.34           C  
ATOM   1464  C   VAL    97       4.527   7.147   2.515  1.00  2.13           C  
ATOM   1465  O   VAL    97       3.820   7.463   1.560  1.00 62.41           O  
ATOM   1466  CB  VAL    97       4.482   4.840   3.469  1.00 14.51           C  
ATOM   1467  CG1 VAL    97       3.028   4.690   3.018  1.00 71.24           C  
ATOM   1468  CG2 VAL    97       5.166   3.484   3.543  1.00 15.31           C  
ATOM   1469  H   VAL    97       6.969   5.428   3.749  1.00 37.41           H  
ATOM   1470  HA  VAL    97       5.273   5.385   1.545  1.00  1.13           H  
ATOM   1471  HB  VAL    97       4.483   5.263   4.462  1.00 32.32           H  
ATOM   1472 HG11 VAL    97       2.517   3.998   3.672  1.00 37.41           H  
ATOM   1473 HG12 VAL    97       2.999   4.315   2.006  1.00 37.41           H  
ATOM   1474 HG13 VAL    97       2.536   5.653   3.057  1.00 37.41           H  
ATOM   1475 HG21 VAL    97       6.196   3.614   3.837  1.00 37.41           H  
ATOM   1476 HG22 VAL    97       5.126   3.005   2.576  1.00 37.41           H  
ATOM   1477 HG23 VAL    97       4.663   2.866   4.269  1.00 37.41           H  
ATOM   1478  N   MET    98       4.684   7.935   3.575  1.00 75.31           N  
ATOM   1479  CA  MET    98       4.060   9.256   3.635  1.00 41.35           C  
ATOM   1480  C   MET    98       4.594  10.166   2.521  1.00 41.34           C  
ATOM   1481  O   MET    98       3.834  10.905   1.898  1.00  0.11           O  
ATOM   1482  CB  MET    98       4.282   9.904   5.010  1.00  4.12           C  
ATOM   1483  CG  MET    98       3.651   9.128   6.161  1.00  3.41           C  
ATOM   1484  SD  MET    98       3.719  10.019   7.729  1.00 30.23           S  
ATOM   1485  CE  MET    98       5.489  10.191   7.964  1.00 73.24           C  
ATOM   1486  H   MET    98       5.226   7.621   4.328  1.00 37.41           H  
ATOM   1487  HA  MET    98       2.997   9.119   3.485  1.00 63.30           H  
ATOM   1488  HB2 MET    98       5.345   9.979   5.192  1.00 37.41           H  
ATOM   1489  HB3 MET    98       3.857  10.899   5.001  1.00 37.41           H  
ATOM   1490  HG2 MET    98       2.615   8.938   5.924  1.00 37.41           H  
ATOM   1491  HG3 MET    98       4.171   8.187   6.275  1.00 37.41           H  
ATOM   1492  HE1 MET    98       5.914  10.735   7.133  1.00 37.41           H  
ATOM   1493  HE2 MET    98       5.944   9.212   8.020  1.00 37.41           H  
ATOM   1494  HE3 MET    98       5.681  10.729   8.882  1.00 37.41           H  
ATOM   1495  N   GLU    99       5.900  10.090   2.259  1.00 34.51           N  
ATOM   1496  CA  GLU    99       6.524  10.917   1.218  1.00 32.11           C  
ATOM   1497  C   GLU    99       6.046  10.539  -0.201  1.00 60.22           C  
ATOM   1498  O   GLU    99       5.629  11.400  -0.976  1.00 44.32           O  
ATOM   1499  CB  GLU    99       8.050  10.794   1.271  1.00 52.15           C  
ATOM   1500  CG  GLU    99       8.757  11.763   0.329  1.00 14.20           C  
ATOM   1501  CD  GLU    99      10.186  11.363   0.018  1.00 63.03           C  
ATOM   1502  OE1 GLU    99      11.087  11.658   0.828  1.00  4.14           O  
ATOM   1503  OE2 GLU    99      10.411  10.767  -1.055  1.00 13.44           O  
ATOM   1504  H   GLU    99       6.463   9.475   2.785  1.00 37.41           H  
ATOM   1505  HA  GLU    99       6.253  11.946   1.411  1.00 25.32           H  
ATOM   1506  HB2 GLU    99       8.383  10.993   2.280  1.00 37.41           H  
ATOM   1507  HB3 GLU    99       8.331   9.785   1.000  1.00 37.41           H  
ATOM   1508  HG2 GLU    99       8.204  11.808  -0.599  1.00 37.41           H  
ATOM   1509  HG3 GLU    99       8.764  12.745   0.782  1.00 37.41           H  
ATOM   1510  N   ASN   100       6.127   9.251  -0.544  1.00  3.11           N  
ATOM   1511  CA  ASN   100       5.842   8.796  -1.917  1.00 53.52           C  
ATOM   1512  C   ASN   100       4.372   8.388  -2.122  1.00 23.34           C  
ATOM   1513  O   ASN   100       3.846   8.496  -3.227  1.00 14.11           O  
ATOM   1514  CB  ASN   100       6.779   7.641  -2.304  1.00 64.23           C  
ATOM   1515  CG  ASN   100       6.757   6.484  -1.319  1.00 11.22           C  
ATOM   1516  OD1 ASN   100       5.763   6.225  -0.659  1.00  1.03           O  
ATOM   1517  ND2 ASN   100       7.864   5.780  -1.212  1.00 14.54           N  
ATOM   1518  H   ASN   100       6.376   8.589   0.139  1.00 37.41           H  
ATOM   1519  HA  ASN   100       6.048   9.629  -2.577  1.00  2.41           H  
ATOM   1520  HB2 ASN   100       6.490   7.260  -3.272  1.00 37.41           H  
ATOM   1521  HB3 ASN   100       7.792   8.017  -2.366  1.00 37.41           H  
ATOM   1522 HD21 ASN   100       8.632   6.031  -1.764  1.00 37.41           H  
ATOM   1523 HD22 ASN   100       7.867   5.034  -0.583  1.00 37.41           H  
ATOM   1524  N   GLY   101       3.716   7.930  -1.060  1.00 34.41           N  
ATOM   1525  CA  GLY   101       2.311   7.520  -1.144  1.00 21.04           C  
ATOM   1526  C   GLY   101       1.373   8.620  -1.650  1.00 72.40           C  
ATOM   1527  O   GLY   101       0.233   8.351  -2.033  1.00  3.20           O  
ATOM   1528  H   GLY   101       4.194   7.839  -0.209  1.00 37.41           H  
ATOM   1529  HA2 GLY   101       2.236   6.673  -1.809  1.00 37.41           H  
ATOM   1530  HA3 GLY   101       1.986   7.212  -0.161  1.00 37.41           H  
ATOM   1531  N   LYS   102       1.852   9.862  -1.651  1.00 64.32           N  
ATOM   1532  CA  LYS   102       1.064  11.005  -2.128  1.00 23.43           C  
ATOM   1533  C   LYS   102       1.444  11.394  -3.572  1.00 33.45           C  
ATOM   1534  O   LYS   102       1.112  12.486  -4.037  1.00 42.10           O  
ATOM   1535  CB  LYS   102       1.271  12.209  -1.191  1.00 55.44           C  
ATOM   1536  CG  LYS   102       2.708  12.725  -1.150  1.00  1.32           C  
ATOM   1537  CD  LYS   102       2.859  13.962  -0.259  1.00 41.23           C  
ATOM   1538  CE  LYS   102       2.866  13.628   1.232  1.00 74.51           C  
ATOM   1539  NZ  LYS   102       1.570  13.084   1.723  1.00 50.10           N  
ATOM   1540  H   LYS   102       2.756  10.017  -1.318  1.00 37.41           H  
ATOM   1541  HA  LYS   102       0.019  10.726  -2.107  1.00 64.40           H  
ATOM   1542  HB2 LYS   102       0.630  13.016  -1.516  1.00 37.41           H  
ATOM   1543  HB3 LYS   102       0.985  11.920  -0.188  1.00 37.41           H  
ATOM   1544  HG2 LYS   102       3.349  11.942  -0.772  1.00 37.41           H  
ATOM   1545  HG3 LYS   102       3.013  12.979  -2.156  1.00 37.41           H  
ATOM   1546  HD2 LYS   102       3.791  14.452  -0.504  1.00 37.41           H  
ATOM   1547  HD3 LYS   102       2.040  14.640  -0.461  1.00 37.41           H  
ATOM   1548  HE2 LYS   102       3.639  12.897   1.416  1.00 37.41           H  
ATOM   1549  HE3 LYS   102       3.096  14.528   1.784  1.00 37.41           H  
ATOM   1550  HZ1 LYS   102       1.407  12.130   1.341  1.00 37.41           H  
ATOM   1551  HZ2 LYS   102       0.784  13.703   1.435  1.00 37.41           H  
ATOM   1552  HZ3 LYS   102       1.582  13.028   2.761  1.00 37.41           H  
ATOM   1553  N   THR   103       2.137  10.496  -4.280  1.00 35.15           N  
ATOM   1554  CA  THR   103       2.586  10.777  -5.656  1.00 14.31           C  
ATOM   1555  C   THR   103       1.483  10.510  -6.689  1.00 53.11           C  
ATOM   1556  O   THR   103       0.536   9.766  -6.433  1.00 73.50           O  
ATOM   1557  CB  THR   103       3.836   9.947  -6.053  1.00 70.12           C  
ATOM   1558  OG1 THR   103       4.388  10.449  -7.285  1.00 22.34           O  
ATOM   1559  CG2 THR   103       3.496   8.467  -6.228  1.00 71.24           C  
ATOM   1560  H   THR   103       2.344   9.626  -3.875  1.00 37.41           H  
ATOM   1561  HA  THR   103       2.855  11.823  -5.706  1.00 31.50           H  
ATOM   1562  HB  THR   103       4.577  10.041  -5.271  1.00 71.21           H  
ATOM   1563  HG1 THR   103       5.226  10.002  -7.467  1.00  4.21           H  
ATOM   1564 HG21 THR   103       2.754   8.354  -7.008  1.00 37.41           H  
ATOM   1565 HG22 THR   103       3.105   8.073  -5.301  1.00 37.41           H  
ATOM   1566 HG23 THR   103       4.387   7.920  -6.501  1.00 37.41           H  
ATOM   1567  N   THR   104       1.620  11.120  -7.862  1.00 31.13           N  
ATOM   1568  CA  THR   104       0.651  10.944  -8.954  1.00 32.22           C  
ATOM   1569  C   THR   104       1.164   9.969 -10.024  1.00 70.41           C  
ATOM   1570  O   THR   104       0.440   9.627 -10.960  1.00 30.14           O  
ATOM   1571  CB  THR   104       0.320  12.293  -9.635  1.00 24.42           C  
ATOM   1572  OG1 THR   104       1.515  12.875 -10.180  1.00 51.34           O  
ATOM   1573  CG2 THR   104      -0.316  13.266  -8.646  1.00 55.23           C  
ATOM   1574  H   THR   104       2.391  11.714  -8.001  1.00 37.41           H  
ATOM   1575  HA  THR   104      -0.262  10.545  -8.531  1.00 50.10           H  
ATOM   1576  HB  THR   104      -0.380  12.111 -10.439  1.00 22.41           H  
ATOM   1577  HG1 THR   104       1.423  12.956 -11.139  1.00 11.44           H  
ATOM   1578 HG21 THR   104       0.356  13.430  -7.814  1.00 37.41           H  
ATOM   1579 HG22 THR   104      -1.245  12.854  -8.280  1.00 37.41           H  
ATOM   1580 HG23 THR   104      -0.512  14.208  -9.140  1.00 37.41           H  
ATOM   1581  N   THR   105       2.415   9.529  -9.891  1.00 14.23           N  
ATOM   1582  CA  THR   105       3.013   8.591 -10.854  1.00 20.42           C  
ATOM   1583  C   THR   105       2.410   7.184 -10.712  1.00 74.13           C  
ATOM   1584  O   THR   105       2.790   6.416  -9.825  1.00 51.22           O  
ATOM   1585  CB  THR   105       4.554   8.505 -10.693  1.00 44.42           C  
ATOM   1586  OG1 THR   105       5.134   9.813 -10.815  1.00 24.24           O  
ATOM   1587  CG2 THR   105       5.172   7.579 -11.742  1.00 75.21           C  
ATOM   1588  H   THR   105       2.952   9.843  -9.134  1.00 37.41           H  
ATOM   1589  HA  THR   105       2.800   8.962 -11.848  1.00 23.14           H  
ATOM   1590  HB  THR   105       4.779   8.113  -9.709  1.00 13.31           H  
ATOM   1591  HG1 THR   105       5.239  10.030 -11.749  1.00  0.32           H  
ATOM   1592 HG21 THR   105       4.931   7.940 -12.731  1.00 37.41           H  
ATOM   1593 HG22 THR   105       4.782   6.578 -11.620  1.00 37.41           H  
ATOM   1594 HG23 THR   105       6.247   7.561 -11.620  1.00 37.41           H  
ATOM   1595  N   ILE   106       1.457   6.855 -11.586  1.00 44.22           N  
ATOM   1596  CA  ILE   106       0.781   5.551 -11.555  1.00 73.12           C  
ATOM   1597  C   ILE   106       0.951   4.798 -12.887  1.00 32.44           C  
ATOM   1598  O   ILE   106       0.569   5.296 -13.949  1.00 45.14           O  
ATOM   1599  CB  ILE   106      -0.734   5.710 -11.255  1.00 50.10           C  
ATOM   1600  CG1 ILE   106      -0.945   6.476  -9.937  1.00 42.04           C  
ATOM   1601  CG2 ILE   106      -1.417   4.342 -11.201  1.00 24.13           C  
ATOM   1602  CD1 ILE   106      -2.399   6.734  -9.598  1.00 63.53           C  
ATOM   1603  H   ILE   106       1.195   7.511 -12.268  1.00 37.41           H  
ATOM   1604  HA  ILE   106       1.224   4.963 -10.762  1.00 62.42           H  
ATOM   1605  HB  ILE   106      -1.179   6.273 -12.064  1.00 14.02           H  
ATOM   1606 HG12 ILE   106      -0.517   5.907  -9.125  1.00 37.41           H  
ATOM   1607 HG13 ILE   106      -0.445   7.434 -10.000  1.00 37.41           H  
ATOM   1608 HG21 ILE   106      -2.471   4.473 -11.004  1.00 37.41           H  
ATOM   1609 HG22 ILE   106      -0.976   3.749 -10.415  1.00 37.41           H  
ATOM   1610 HG23 ILE   106      -1.290   3.837 -12.148  1.00 37.41           H  
ATOM   1611 HD11 ILE   106      -2.861   7.300 -10.394  1.00 37.41           H  
ATOM   1612 HD12 ILE   106      -2.460   7.294  -8.678  1.00 37.41           H  
ATOM   1613 HD13 ILE   106      -2.915   5.792  -9.480  1.00 37.41           H  
ATOM   1614  N   LYS   107       1.515   3.593 -12.819  1.00 22.22           N  
ATOM   1615  CA  LYS   107       1.743   2.759 -14.007  1.00 24.23           C  
ATOM   1616  C   LYS   107       0.701   1.631 -14.109  1.00 55.21           C  
ATOM   1617  O   LYS   107       0.537   0.849 -13.173  1.00 60.10           O  
ATOM   1618  CB  LYS   107       3.146   2.138 -13.951  1.00 24.43           C  
ATOM   1619  CG  LYS   107       4.284   3.155 -13.897  1.00  0.22           C  
ATOM   1620  CD  LYS   107       5.643   2.470 -13.746  1.00 71.45           C  
ATOM   1621  CE  LYS   107       6.791   3.473 -13.728  1.00 74.43           C  
ATOM   1622  NZ  LYS   107       6.956   4.166 -15.033  1.00 72.12           N  
ATOM   1623  H   LYS   107       1.794   3.251 -11.944  1.00 37.41           H  
ATOM   1624  HA  LYS   107       1.671   3.389 -14.883  1.00  2.54           H  
ATOM   1625  HB2 LYS   107       3.213   1.511 -13.071  1.00 37.41           H  
ATOM   1626  HB3 LYS   107       3.287   1.521 -14.828  1.00 37.41           H  
ATOM   1627  HG2 LYS   107       4.282   3.731 -14.810  1.00 37.41           H  
ATOM   1628  HG3 LYS   107       4.126   3.813 -13.053  1.00 37.41           H  
ATOM   1629  HD2 LYS   107       5.653   1.912 -12.821  1.00 37.41           H  
ATOM   1630  HD3 LYS   107       5.786   1.791 -14.575  1.00 37.41           H  
ATOM   1631  HE2 LYS   107       6.598   4.212 -12.962  1.00 37.41           H  
ATOM   1632  HE3 LYS   107       7.706   2.948 -13.492  1.00 37.41           H  
ATOM   1633  HZ1 LYS   107       6.062   4.614 -15.319  1.00 37.41           H  
ATOM   1634  HZ2 LYS   107       7.240   3.485 -15.767  1.00 37.41           H  
ATOM   1635  HZ3 LYS   107       7.689   4.900 -14.960  1.00 37.41           H  
ATOM   1636  N   ASP   108      -0.007   1.550 -15.237  1.00 71.14           N  
ATOM   1637  CA  ASP   108      -0.917   0.431 -15.488  1.00 54.31           C  
ATOM   1638  C   ASP   108      -0.181  -0.710 -16.218  1.00 22.43           C  
ATOM   1639  O   ASP   108       0.368  -0.516 -17.308  1.00  0.32           O  
ATOM   1640  CB  ASP   108      -2.132   0.895 -16.310  1.00 64.04           C  
ATOM   1641  CG  ASP   108      -3.160  -0.211 -16.509  1.00 60.11           C  
ATOM   1642  OD1 ASP   108      -2.911  -1.126 -17.321  1.00 25.55           O  
ATOM   1643  OD2 ASP   108      -4.223  -0.178 -15.856  1.00 52.43           O  
ATOM   1644  H   ASP   108       0.073   2.261 -15.910  1.00 37.41           H  
ATOM   1645  HA  ASP   108      -1.265   0.064 -14.531  1.00  2.35           H  
ATOM   1646  HB2 ASP   108      -2.607   1.722 -15.801  1.00 37.41           H  
ATOM   1647  HB3 ASP   108      -1.795   1.228 -17.283  1.00 37.41           H  
ATOM   1648  N   LEU   109      -0.162  -1.889 -15.604  1.00 62.34           N  
ATOM   1649  CA  LEU   109       0.457  -3.083 -16.201  1.00  5.54           C  
ATOM   1650  C   LEU   109      -0.608  -4.150 -16.514  1.00 34.51           C  
ATOM   1651  O   LEU   109      -0.292  -5.320 -16.745  1.00 53.33           O  
ATOM   1652  CB  LEU   109       1.511  -3.663 -15.239  1.00  3.13           C  
ATOM   1653  CG  LEU   109       2.597  -2.676 -14.772  1.00 74.52           C  
ATOM   1654  CD1 LEU   109       3.544  -3.347 -13.782  1.00 30.34           C  
ATOM   1655  CD2 LEU   109       3.368  -2.116 -15.964  1.00 45.23           C  
ATOM   1656  H   LEU   109      -0.561  -1.960 -14.712  1.00 37.41           H  
ATOM   1657  HA  LEU   109       0.938  -2.791 -17.124  1.00 40.53           H  
ATOM   1658  HB2 LEU   109       0.999  -4.041 -14.364  1.00 37.41           H  
ATOM   1659  HB3 LEU   109       2.000  -4.493 -15.732  1.00 37.41           H  
ATOM   1660  HG  LEU   109       2.122  -1.847 -14.264  1.00 50.13           H  
ATOM   1661 HD11 LEU   109       4.065  -4.160 -14.269  1.00 37.41           H  
ATOM   1662 HD12 LEU   109       2.977  -3.734 -12.948  1.00 37.41           H  
ATOM   1663 HD13 LEU   109       4.262  -2.624 -13.421  1.00 37.41           H  
ATOM   1664 HD21 LEU   109       2.687  -1.608 -16.630  1.00 37.41           H  
ATOM   1665 HD22 LEU   109       3.852  -2.925 -16.494  1.00 37.41           H  
ATOM   1666 HD23 LEU   109       4.117  -1.419 -15.616  1.00 37.41           H  
ATOM   1667  N   THR   110      -1.872  -3.731 -16.530  1.00  1.33           N  
ATOM   1668  CA  THR   110      -2.999  -4.655 -16.729  1.00 62.42           C  
ATOM   1669  C   THR   110      -3.425  -4.709 -18.201  1.00 13.21           C  
ATOM   1670  O   THR   110      -3.577  -5.787 -18.780  1.00 25.20           O  
ATOM   1671  CB  THR   110      -4.222  -4.245 -15.871  1.00  1.14           C  
ATOM   1672  OG1 THR   110      -4.816  -3.037 -16.381  1.00 74.21           O  
ATOM   1673  CG2 THR   110      -3.816  -4.028 -14.418  1.00 41.22           C  
ATOM   1674  H   THR   110      -2.054  -2.773 -16.421  1.00 37.41           H  
ATOM   1675  HA  THR   110      -2.684  -5.642 -16.420  1.00 10.12           H  
ATOM   1676  HB  THR   110      -4.954  -5.040 -15.907  1.00 33.15           H  
ATOM   1677  HG1 THR   110      -4.211  -2.293 -16.242  1.00  4.31           H  
ATOM   1678 HG21 THR   110      -4.673  -3.694 -13.851  1.00 37.41           H  
ATOM   1679 HG22 THR   110      -3.039  -3.277 -14.368  1.00 37.41           H  
ATOM   1680 HG23 THR   110      -3.449  -4.955 -14.001  1.00 37.41           H  
END
