
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  155 ( 1217),  selected  155 , name 3brc_A
# Molecule2: number of CA atoms  110 ( 1680),  selected  110 , name T0472.pdb
# PARAMETERS: 3brc_A.T0472.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      M       1           -
LGA    L     2_A      S       2           -
LGA    E     3_A      G       3           -
LGA    D     4_A      W       4           -
LGA    L     5_A      Y       5           -
LGA    I     6_A      E       6           -
LGA    G     7_A      L       7           -
LGA    K     8_A      S       8           -
LGA    A     9_A      K       9           -
LGA    Y    10_A      S      10           -
LGA    L    11_A      S      11           -
LGA    E    12_A      -       -           -
LGA    S    13_A      -       -           -
LGA    A    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    D    16_A      -       -           -
LGA    R    17_A      -       -           -
LGA    R    18_A      N      12           #
LGA    R    19_A      D      13          3.146
LGA    G    20_A      Q      14          0.912
LGA    D    21_A      F      15          2.461
LGA    -       -      K      16           -
LGA    -       -      F      17           -
LGA    -       -      V      18           -
LGA    -       -      L      19           -
LGA    -       -      K      20           -
LGA    -       -      A      21           -
LGA    -       -      G      22           -
LGA    -       -      N      23           -
LGA    -       -      G      24           -
LGA    -       -      E      25           -
LGA    -       -      V      26           -
LGA    -       -      I      27           -
LGA    -       -      L      28           -
LGA    -       -      T      29           -
LGA    -       -      S      30           -
LGA    -       -      E      31           -
LGA    -       -      L      32           -
LGA    -       -      Y      33           -
LGA    -       -      T      34           -
LGA    R    22_A      G      35          3.925
LGA    S    23_A      K      36          3.545
LGA    E    24_A      S      37          3.035
LGA    E    25_A      G      38          2.520
LGA    V    26_A      A      39          1.973
LGA    E    27_A      M      40          1.508
LGA    A    28_A      N      41          0.548
LGA    I    29_A      G      42          0.845
LGA    R    30_A      I      43          1.608
LGA    K    31_A      E      44          1.537
LGA    Y    32_A      S      45          1.872
LGA    I    33_A      V      46          2.587
LGA    R    34_A      Q      47          2.380
LGA    S    35_A      T      48          3.332
LGA    A    36_A      N      49          4.593
LGA    R    37_A      S      50           -
LGA    R    38_A      P      51           #
LGA    T    39_A      I      52          1.853
LGA    V    40_A      E      53          3.273
LGA    V    41_A      A      54          4.070
LGA    P    42_A      -       -           -
LGA    N    43_A      -       -           -
LGA    W    44_A      -       -           -
LGA    N    45_A      -       -           -
LGA    A    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    K    48_A      -       -           -
LGA    V    49_A      -       -           -
LGA    D    50_A      -       -           -
LGA    A    51_A      -       -           -
LGA    I    52_A      -       -           -
LGA    N    53_A      -       -           -
LGA    D    54_A      -       -           -
LGA    V    55_A      -       -           -
LGA    L    56_A      -       -           -
LGA    R    57_A      -       -           -
LGA    S    58_A      -       -           -
LGA    F    59_A      -       -           -
LGA    N    60_A      -       -           -
LGA    L    61_A      -       -           -
LGA    R    62_A      -       -           -
LGA    E    63_A      -       -           -
LGA    A    64_A      -       -           -
LGA    E    65_A      -       -           -
LGA    H    66_A      -       -           -
LGA    L    67_A      -       -           -
LGA    Q    68_A      -       -           -
LGA    F    69_A      -       -           -
LGA    N    70_A      -       -           -
LGA    T    71_A      -       -           -
LGA    N    72_A      -       -           -
LGA    W    73_A      -       -           -
LGA    A    74_A      -       -           -
LGA    D    75_A      -       -           -
LGA    L    76_A      -       -           -
LGA    T    77_A      -       -           -
LGA    R    78_A      -       -           -
LGA    X    79_A      -       -           -
LGA    P    80_A      -       -           -
LGA    A    81_A      -       -           -
LGA    V    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    K    84_A      -       -           -
LGA    A    85_A      -       -           -
LGA    L    86_A      -       -           -
LGA    X    87_A      -       -           -
LGA    A    88_A      -       -           -
LGA    L    89_A      -       -           -
LGA    D    90_A      -       -           -
LGA    I    91_A      -       -           -
LGA    S    92_A      -       -           -
LGA    G    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    D    95_A      -       -           -
LGA    L    96_A      -       -           -
LGA    V    97_A      R      55          0.936
LGA    I    98_A      Y      56          0.814
LGA    A    99_A      A      57          2.194
LGA    R   100_A      K      58          1.110
LGA    G   101_A      E      59          1.455
LGA    R   102_A      V      60          1.931
LGA    L   103_A      A      61          3.878
LGA    G   104_A      -       -           -
LGA    V   105_A      -       -           -
LGA    P   106_A      K      62          2.006
LGA    G   107_A      N      63          1.783
LGA    S   108_A      D      64           #
LGA    G   109_A      K      65          1.715
LGA    S   110_A      P      66          2.382
LGA    L   111_A      Y      67          2.514
LGA    L   112_A      F      68          0.370
LGA    V   113_A      N      69          0.750
LGA    I   114_A      L      70          0.415
LGA    X   115_A      K      71          0.526
LGA    D   116_A      A      72          1.340
LGA    S   117_A      A      73          1.631
LGA    R   118_A      N      74          1.940
LGA    G   119_A      H      75          1.609
LGA    R   120_A      Q      76          0.823
LGA    L   121_A      I      77          0.355
LGA    L   122_A      I      78          0.477
LGA    S   123_A      G      79          0.424
LGA    A   124_A      T      80          0.972
LGA    A   125_A      S      81          0.441
LGA    X   126_A      Q      82          2.455
LGA    S   127_A      M      83          1.923
LGA    P   128_A      -       -           -
LGA    P   129_A      -       -           -
LGA    H   130_A      -       -           -
LGA    V   131_A      -       -           -
LGA    I   132_A      -       -           -
LGA    H   133_A      Y      84           #
LGA    S   134_A      S      85          5.135
LGA    X   135_A      -       -           -
LGA    E   136_A      S      86          4.648
LGA    V   137_A      T      87          2.826
LGA    R   138_A      A      88          2.726
LGA    E   139_A      A      89          2.817
LGA    A   140_A      R      90          2.891
LGA    V   141_A      D      91          2.557
LGA    R   142_A      N      92          2.669
LGA    S   143_A      G      93          2.881
LGA    E   144_A      I      94           #
LGA    X   145_A      K      95           #
LGA    -       -      S      96           -
LGA    T   146_A      V      97          3.450
LGA    H   147_A      M      98           -
LGA    A   148_A      E      99           -
LGA    -       -      N     100           -
LGA    L   149_A      G     101          4.423
LGA    E   150_A      K     102           -
LGA    R   151_A      -       -           -
LGA    I   152_A      -       -           -
LGA    G   153_A      -       -           -
LGA    F   154_A      T     103          5.050
LGA    -       -      T     104           -
LGA    K   155_A      T     105          4.406
LGA    -       -      I     106           -
LGA    -       -      K     107           -
LGA    -       -      D     108           -
LGA    -       -      L     109           -
LGA    -       -      T     110           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  155  110    5.0     62    2.55     3.23     39.040     2.338

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.155713 * X  +   0.439042 * Y  +   0.884870 * Z  + -14.188072
  Y_new =   0.875539 * X  +   0.353424 * Y  +  -0.329427 * Z  + -10.747231
  Z_new =  -0.457367 * X  +   0.826035 * Y  +  -0.329366 * Z  +  11.073214 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.950209   -1.191384  [ DEG:   111.7387    -68.2613 ]
  Theta =   0.475032    2.666561  [ DEG:    27.2173    152.7827 ]
  Phi   =   1.394789   -1.746804  [ DEG:    79.9155   -100.0845 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3brc_A                                        
REMARK     2: T0472.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3brc_A.T0472.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  155  110   5.0   62   2.55    3.23  39.040
REMARK  ---------------------------------------------------------- 
MOLECULE 3brc_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   21-DEC-07   3BRC              
TITLE     CRYSTAL STRUCTURE OF A CONSERVED PROTEIN OF UNKNOWN                   
TITLE    2 FUNCTION FROM METHANOBACTERIUM THERMOAUTOTROPHICUM                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED PROTEIN OF UNKNOWN FUNCTION;                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOTHERMOBACTER                             
SOURCE   3 THERMAUTOTROPHICUS STR. DELTA H;                                     
SOURCE   4 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   5 STRAIN: DELTA H;                                                     
SOURCE   6 GENE: MTH1144, GI:2622249;                                           
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    CONSERVED PROTEIN, METHANOBACTERIUM THERMOAUTOTROPHICUM,              
KEYWDS   2 STRUCTURAL GENOMICS, MCSG, PSI-2, PROTEIN STRUCTURE                  
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS,                  
KEYWDS   4 STRUCTURAL GENOMICS, UNKNOWN FUNCTION                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,E.EVDOKIMOVA,M.KUDRITSKA,A.SAVCHENKO,A.M.EDWARDS,             
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   1   19-FEB-08 3BRC    0                                                
JRNL        AUTH   R.ZHANG,E.EVDOKIMOVA,M.KUDRITSKA,A.SAVCHENKO,                
JRNL        AUTH 2 A.M.EDWARDS,A.JOACHIMIAK                                     
JRNL        TITL   THE CRYSTAL STRUCTURE OF A CONSERVED PROTEIN OF              
JRNL        TITL 2 UNKNOWN FUNCTION FROM METHANOBACTERIUM                       
JRNL        TITL 3 THERMOAUTOTROPHICUM.                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  3BRC A    1   156  UNP    O27213   O27213_METTH     1    156             
DBREF  3BRC B    1   156  UNP    O27213   O27213_METTH     1    156             
SEQRES   1 A  156  MSE LEU GLU ASP LEU ILE GLY LYS ALA TYR LEU GLU SER          
SEQRES   2 A  156  ALA GLU ASP ARG ARG ARG GLY ASP ARG SER GLU GLU VAL          
SEQRES   3 A  156  GLU ALA ILE ARG LYS TYR ILE ARG SER ALA ARG ARG THR          
SEQRES   4 A  156  VAL VAL PRO ASN TRP ASN ALA GLU LYS VAL ASP ALA ILE          
SEQRES   5 A  156  ASN ASP VAL LEU ARG SER PHE ASN LEU ARG GLU ALA GLU          
SEQRES   6 A  156  HIS LEU GLN PHE ASN THR ASN TRP ALA ASP LEU THR ARG          
SEQRES   7 A  156  MSE PRO ALA VAL THR LYS ALA LEU MSE ALA LEU ASP ILE          
SEQRES   8 A  156  SER GLY ALA ASP LEU VAL ILE ALA ARG GLY ARG LEU GLY          
SEQRES   9 A  156  VAL PRO GLY SER GLY SER LEU LEU VAL ILE MSE ASP SER          
SEQRES  10 A  156  ARG GLY ARG LEU LEU SER ALA ALA MSE SER PRO PRO HIS          
SEQRES  11 A  156  VAL ILE HIS SER MSE GLU VAL ARG GLU ALA VAL ARG SER          
SEQRES  12 A  156  GLU MSE THR HIS ALA LEU GLU ARG ILE GLY PHE LYS ARG          
SEQRES   1 B  156  MSE LEU GLU ASP LEU ILE GLY LYS ALA TYR LEU GLU SER          
SEQRES   2 B  156  ALA GLU ASP ARG ARG ARG GLY ASP ARG SER GLU GLU VAL          
SEQRES   3 B  156  GLU ALA ILE ARG LYS TYR ILE ARG SER ALA ARG ARG THR          
SEQRES   4 B  156  VAL VAL PRO ASN TRP ASN ALA GLU LYS VAL ASP ALA ILE          
SEQRES   5 B  156  ASN ASP VAL LEU ARG SER PHE ASN LEU ARG GLU ALA GLU          
SEQRES   6 B  156  HIS LEU GLN PHE ASN THR ASN TRP ALA ASP LEU THR ARG          
SEQRES   7 B  156  MSE PRO ALA VAL THR LYS ALA LEU MSE ALA LEU ASP ILE          
SEQRES   8 B  156  SER GLY ALA ASP LEU VAL ILE ALA ARG GLY ARG LEU GLY          
SEQRES   9 B  156  VAL PRO GLY SER GLY SER LEU LEU VAL ILE MSE ASP SER          
SEQRES  10 B  156  ARG GLY ARG LEU LEU SER ALA ALA MSE SER PRO PRO HIS          
SEQRES  11 B  156  VAL ILE HIS SER MSE GLU VAL ARG GLU ALA VAL ARG SER          
SEQRES  12 B  156  GLU MSE THR HIS ALA LEU GLU ARG ILE GLY PHE LYS ARG          
HET    MSE  A   1       8                                                       
HET    MSE  A  79       8                                                       
HET    MSE  A  87       8                                                       
HET    MSE  A 115       8                                                       
HET    MSE  A 126       8                                                       
HET    MSE  A 135       8                                                       
HET    MSE  A 145       8                                                       
HET    MSE  B  79       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  B 115       8                                                       
HET    MSE  B 126       8                                                       
HET    MSE  B 135       8                                                       
HET    MSE  B 145       8                                                       
HET    PO4  A 157       5                                                       
HET    PO4  A 158       5                                                       
HET    PO4  B 157       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     PO4 PHOSPHATE ION                                                    
FORMUL   1  MSE    13(C5 H11 N O2 SE)                                           
FORMUL   3  PO4    3(O4 P 3-)                                                   
FORMUL   6  HOH   *226(H2 O)                                                    
CRYST1  106.894   48.916   63.868  90.00 118.54  90.00 C 1 2 1       8          
HETATM    1  N   MSE A   1     -16.917   7.205  -4.074  1.00 36.20           N  
HETATM    2  CA  MSE A   1     -16.218   6.452  -5.155  1.00 37.88           C  
HETATM    3  C   MSE A   1     -16.070   4.990  -4.735  1.00 33.42           C  
HETATM    4  O   MSE A   1     -16.343   4.078  -5.528  1.00 32.82           O  
HETATM    5  CB  MSE A   1     -14.830   7.060  -5.447  1.00 38.05           C  
HETATM    6  CG  MSE A   1     -13.676   6.482  -4.562  1.00 42.09           C  
HETATM    7 SE   MSE A   1     -11.906   7.359  -4.608  1.00 49.75          SE  
HETATM    8  CE  MSE A   1     -12.387   9.051  -3.675  1.00 46.15           C  
ATOM      9  N   LEU A   2     -15.638   4.759  -3.491  1.00 29.86           N  
ATOM     10  CA  LEU A   2     -15.262   3.406  -3.107  1.00 27.22           C  
ATOM     11  C   LEU A   2     -16.505   2.540  -3.040  1.00 26.18           C  
ATOM     12  O   LEU A   2     -16.480   1.379  -3.463  1.00 24.57           O  
ATOM     13  CB  LEU A   2     -14.475   3.358  -1.775  1.00 26.99           C  
ATOM     14  CG  LEU A   2     -13.026   3.882  -1.780  1.00 26.29           C  
ATOM     15  CD1 LEU A   2     -12.338   3.649  -0.436  1.00 24.41           C  
ATOM     16  CD2 LEU A   2     -12.205   3.242  -2.858  1.00 24.56           C  
ATOM     17  N   GLU A   3     -17.610   3.105  -2.548  1.00 24.49           N  
ATOM     18  CA  GLU A   3     -18.841   2.340  -2.475  1.00 24.43           C  
ATOM     19  C   GLU A   3     -19.303   1.902  -3.863  1.00 23.66           C  
ATOM     20  O   GLU A   3     -19.721   0.745  -4.036  1.00 22.67           O  
ATOM     21  CB  GLU A   3     -19.936   3.098  -1.728  1.00 24.79           C  
ATOM     22  CG  GLU A   3     -19.721   3.075  -0.208  1.00 26.14           C  
ATOM     23  CD  GLU A   3     -18.733   4.139   0.285  1.00 29.03           C  
ATOM     24  OE1 GLU A   3     -18.221   4.938  -0.530  1.00 30.44           O  
ATOM     25  OE2 GLU A   3     -18.477   4.185   1.498  1.00 29.92           O  
ATOM     26  N   ASP A   4     -19.212   2.821  -4.829  1.00 23.76           N  
ATOM     27  CA  ASP A   4     -19.567   2.588  -6.236  1.00 23.37           C  
ATOM     28  C   ASP A   4     -18.807   1.359  -6.755  1.00 22.33           C  
ATOM     29  O   ASP A   4     -19.392   0.389  -7.251  1.00 21.62           O  
ATOM     30  CB  ASP A   4     -19.219   3.878  -7.034  1.00 23.76           C  
ATOM     31  CG  ASP A   4     -19.601   3.823  -8.506  1.00 24.97           C  
ATOM     32  OD1 ASP A   4     -19.421   2.772  -9.139  1.00 28.50           O  
ATOM     33  OD2 ASP A   4     -20.035   4.877  -9.059  1.00 26.30           O  
ATOM     34  N   LEU A   5     -17.493   1.392  -6.585  1.00 21.47           N  
ATOM     35  CA  LEU A   5     -16.640   0.324  -7.066  1.00 21.11           C  
ATOM     36  C   LEU A   5     -16.796  -0.983  -6.281  1.00 20.51           C  
ATOM     37  O   LEU A   5     -16.697  -2.062  -6.878  1.00 20.43           O  
ATOM     38  CB  LEU A   5     -15.182   0.788  -7.079  1.00 22.39           C  
ATOM     39  CG  LEU A   5     -14.891   1.972  -8.016  1.00 22.64           C  
ATOM     40  CD1 LEU A   5     -13.468   2.403  -7.823  1.00 22.56           C  
ATOM     41  CD2 LEU A   5     -15.162   1.625  -9.491  1.00 21.35           C  
ATOM     42  N   ILE A   6     -17.040  -0.911  -4.964  1.00 20.16           N  
ATOM     43  CA  ILE A   6     -17.304  -2.118  -4.191  1.00 19.34           C  
ATOM     44  C   ILE A   6     -18.587  -2.809  -4.671  1.00 19.19           C  
ATOM     45  O   ILE A   6     -18.595  -4.016  -4.929  1.00 18.28           O  
ATOM     46  CB  ILE A   6     -17.344  -1.814  -2.671  1.00 19.90           C  
ATOM     47  CG1 ILE A   6     -15.943  -1.476  -2.180  1.00 22.00           C  
ATOM     48  CG2 ILE A   6     -17.874  -3.012  -1.860  1.00 20.62           C  
ATOM     49  CD1 ILE A   6     -15.929  -0.857  -0.797  1.00 19.66           C  
ATOM     50  N   GLY A   7     -19.667  -2.042  -4.808  1.00 18.72           N  
ATOM     51  CA  GLY A   7     -20.924  -2.576  -5.290  1.00 19.20           C  
ATOM     52  C   GLY A   7     -20.699  -3.277  -6.628  1.00 19.07           C  
ATOM     53  O   GLY A   7     -21.131  -4.427  -6.814  1.00 19.51           O  
ATOM     54  N   LYS A   8     -19.967  -2.624  -7.531  1.00 18.13           N  
ATOM     55  CA  LYS A   8     -19.675  -3.221  -8.839  1.00 18.49           C  
ATOM     56  C   LYS A   8     -18.802  -4.479  -8.756  1.00 17.43           C  
ATOM     57  O   LYS A   8     -19.086  -5.499  -9.415  1.00 18.20           O  
ATOM     58  CB  LYS A   8     -19.029  -2.208  -9.793  1.00 19.02           C  
ATOM     59  CG  LYS A   8     -20.012  -1.186 -10.305  1.00 20.08           C  
ATOM     60  CD  LYS A   8     -19.431  -0.231 -11.325  1.00 20.63           C  
ATOM     61  CE  LYS A   8     -20.388   0.960 -11.583  1.00 23.23           C  
ATOM     62  NZ  LYS A   8     -21.838   0.590 -11.488  1.00 27.28           N  
ATOM     63  N   ALA A   9     -17.738  -4.404  -7.958  1.00 16.54           N  
ATOM     64  CA  ALA A   9     -16.871  -5.555  -7.758  1.00 17.07           C  
ATOM     65  C   ALA A   9     -17.599  -6.731  -7.124  1.00 16.58           C  
ATOM     66  O   ALA A   9     -17.354  -7.879  -7.480  1.00 16.90           O  
ATOM     67  CB  ALA A   9     -15.698  -5.187  -6.907  1.00 16.11           C  
ATOM     68  N   TYR A  10     -18.451  -6.452  -6.143  1.00 16.86           N  
ATOM     69  CA  TYR A  10     -19.222  -7.509  -5.481  1.00 17.37           C  
ATOM     70  C   TYR A  10     -20.174  -8.221  -6.462  1.00 17.87           C  
ATOM     71  O   TYR A  10     -20.320  -9.465  -6.410  1.00 19.02           O  
ATOM     72  CB  TYR A  10     -19.989  -6.941  -4.271  1.00 16.52           C  
ATOM     73  CG  TYR A  10     -19.127  -6.719  -3.009  1.00 15.36           C  
ATOM     74  CD1 TYR A  10     -17.728  -6.633  -3.066  1.00 15.62           C  
ATOM     75  CD2 TYR A  10     -19.737  -6.612  -1.764  1.00 16.80           C  
ATOM     76  CE1 TYR A  10     -16.966  -6.428  -1.896  1.00 15.37           C  
ATOM     77  CE2 TYR A  10     -19.004  -6.394  -0.608  1.00 15.00           C  
ATOM     78  CZ  TYR A  10     -17.613  -6.319  -0.671  1.00 14.88           C  
ATOM     79  OH  TYR A  10     -16.872  -6.111   0.480  1.00 16.08           O  
ATOM     80  N   LEU A  11     -20.791  -7.447  -7.356  1.00 18.68           N  
ATOM     81  CA  LEU A  11     -21.699  -8.021  -8.353  1.00 19.73           C  
ATOM     82  C   LEU A  11     -20.908  -8.897  -9.316  1.00 20.39           C  
ATOM     83  O   LEU A  11     -21.351  -9.998  -9.665  1.00 21.01           O  
ATOM     84  CB  LEU A  11     -22.446  -6.920  -9.094  1.00 19.48           C  
ATOM     85  CG  LEU A  11     -23.472  -7.392 -10.117  1.00 20.10           C  
ATOM     86  CD1 LEU A  11     -24.504  -8.315  -9.477  1.00 22.24           C  
ATOM     87  CD2 LEU A  11     -24.138  -6.173 -10.739  1.00 20.97           C  
ATOM     88  N   GLU A  12     -19.738  -8.415  -9.738  1.00 20.57           N  
ATOM     89  CA  GLU A  12     -18.810  -9.197 -10.566  1.00 21.35           C  
ATOM     90  C   GLU A  12     -18.517 -10.561  -9.958  1.00 20.95           C  
ATOM     91  O   GLU A  12     -18.607 -11.581 -10.628  1.00 20.71           O  
ATOM     92  CB  GLU A  12     -17.475  -8.479 -10.672  1.00 21.91           C  
ATOM     93  CG  GLU A  12     -17.051  -7.875 -11.977  1.00 24.06           C  
ATOM     94  CD  GLU A  12     -15.561  -7.516 -11.887  1.00 24.53           C  
ATOM     95  OE1 GLU A  12     -15.211  -6.837 -10.928  1.00 27.80           O  
ATOM     96  OE2 GLU A  12     -14.736  -7.950 -12.724  1.00 30.61           O  
ATOM     97  N   SER A  13     -18.108 -10.576  -8.690  1.00 19.61           N  
ATOM     98  CA  SER A  13     -17.748 -11.835  -8.035  1.00 21.26           C  
ATOM     99  C   SER A  13     -18.979 -12.741  -7.965  1.00 21.30           C  
ATOM    100  O   SER A  13     -18.896 -13.956  -8.231  1.00 21.86           O  
ATOM    101  CB  SER A  13     -17.152 -11.594  -6.637  1.00 20.72           C  
ATOM    102  OG  SER A  13     -15.859 -10.977  -6.713  1.00 22.17           O  
ATOM    103  N   ALA A  14     -20.119 -12.134  -7.655  1.00 21.50           N  
ATOM    104  CA  ALA A  14     -21.364 -12.857  -7.465  1.00 22.57           C  
ATOM    105  C   ALA A  14     -21.788 -13.529  -8.770  1.00 23.34           C  
ATOM    106  O   ALA A  14     -22.310 -14.662  -8.758  1.00 23.71           O  
ATOM    107  CB  ALA A  14     -22.422 -11.919  -6.972  1.00 21.97           C  
ATOM    108  N   GLU A  15     -21.517 -12.861  -9.892  1.00 23.81           N  
ATOM    109  CA  GLU A  15     -21.903 -13.388 -11.216  1.00 24.61           C  
ATOM    110  C   GLU A  15     -20.759 -14.133 -11.936  1.00 24.88           C  
ATOM    111  O   GLU A  15     -20.826 -14.363 -13.148  1.00 23.98           O  
ATOM    112  CB  GLU A  15     -22.423 -12.234 -12.068  1.00 24.58           C  
ATOM    113  CG  GLU A  15     -23.639 -11.554 -11.444  1.00 26.22           C  
ATOM    114  CD  GLU A  15     -24.232 -10.465 -12.320  1.00 27.40           C  
ATOM    115  OE1 GLU A  15     -23.476  -9.838 -13.092  1.00 30.50           O  
ATOM    116  OE2 GLU A  15     -25.459 -10.228 -12.236  1.00 32.69           O  
ATOM    117  N   ASP A  16     -19.750 -14.561 -11.172  1.00 25.23           N  
ATOM    118  CA  ASP A  16     -18.482 -15.110 -11.691  1.00 25.51           C  
ATOM    119  C   ASP A  16     -17.857 -14.364 -12.863  1.00 25.67           C  
ATOM    120  O   ASP A  16     -17.384 -14.995 -13.820  1.00 25.89           O  
ATOM    121  CB  ASP A  16     -18.591 -16.587 -12.088  1.00 26.50           C  
ATOM    122  CG  ASP A  16     -17.198 -17.311 -12.100  1.00 26.95           C  
ATOM    123  OD1 ASP A  16     -16.246 -16.865 -11.403  1.00 29.76           O  
ATOM    124  OD2 ASP A  16     -17.045 -18.344 -12.792  1.00 29.22           O  
ATOM    125  N   ARG A  17     -17.837 -13.045 -12.800  1.00 24.97           N  
ATOM    126  CA  ARG A  17     -17.177 -12.256 -13.833  1.00 24.87           C  
ATOM    127  C   ARG A  17     -15.888 -11.645 -13.314  1.00 25.22           C  
ATOM    128  O   ARG A  17     -15.224 -10.924 -14.045  1.00 26.20           O  
ATOM    129  CB  ARG A  17     -18.102 -11.156 -14.354  1.00 24.39           C  
ATOM    130  CG  ARG A  17     -19.379 -11.695 -14.954  1.00 24.06           C  
ATOM    131  CD  ARG A  17     -20.205 -10.612 -15.584  1.00 23.72           C  
ATOM    132  NE  ARG A  17     -20.869  -9.789 -14.573  1.00 22.86           N  
ATOM    133  CZ  ARG A  17     -20.451  -8.593 -14.154  1.00 22.92           C  
ATOM    134  NH1 ARG A  17     -19.370  -8.036 -14.674  1.00 20.55           N  
ATOM    135  NH2 ARG A  17     -21.144  -7.935 -13.221  1.00 22.13           N  
ATOM    136  N   ARG A  18     -15.531 -11.937 -12.067  1.00 25.01           N  
ATOM    137  CA  ARG A  18     -14.372 -11.310 -11.426  1.00 25.11           C  
ATOM    138  C   ARG A  18     -13.101 -11.998 -11.875  1.00 25.24           C  
ATOM    139  O   ARG A  18     -12.934 -13.197 -11.663  1.00 26.24           O  
ATOM    140  CB  ARG A  18     -14.493 -11.386  -9.892  1.00 24.80           C  
ATOM    141  CG  ARG A  18     -13.363 -10.712  -9.111  1.00 25.66           C  
ATOM    142  CD  ARG A  18     -13.612  -9.248  -9.003  1.00 23.23           C  
ATOM    143  NE  ARG A  18     -12.606  -8.516  -8.235  1.00 20.54           N  
ATOM    144  CZ  ARG A  18     -12.457  -7.194  -8.321  1.00 20.50           C  
ATOM    145  NH1 ARG A  18     -13.249  -6.484  -9.116  1.00 20.89           N  
ATOM    146  NH2 ARG A  18     -11.519  -6.580  -7.627  1.00 19.14           N  
ATOM    147  N   ARG A  19     -12.192 -11.240 -12.474  1.00 25.50           N  
ATOM    148  CA  ARG A  19     -10.871 -11.754 -12.839  1.00 25.76           C  
ATOM    149  C   ARG A  19      -9.825 -10.756 -12.358  1.00 25.30           C  
ATOM    150  O   ARG A  19      -9.251 -10.004 -13.140  1.00 26.65           O  
ATOM    151  CB  ARG A  19     -10.776 -11.998 -14.345  1.00 26.05           C  
ATOM    152  CG  ARG A  19     -11.764 -13.064 -14.868  1.00 27.04           C  
ATOM    153  CD  ARG A  19     -11.424 -14.465 -14.351  1.00 27.87           C  
ATOM    154  NE  ARG A  19     -12.269 -15.514 -14.932  1.00 28.41           N  
ATOM    155  CZ  ARG A  19     -13.464 -15.899 -14.474  1.00 28.82           C  
ATOM    156  NH1 ARG A  19     -14.020 -15.326 -13.416  1.00 28.41           N  
ATOM    157  NH2 ARG A  19     -14.122 -16.878 -15.092  1.00 30.09           N  
ATOM    158  N   GLY A  20      -9.624 -10.740 -11.051  1.00 24.33           N  
ATOM    159  CA  GLY A  20      -8.623  -9.906 -10.419  1.00 23.28           C  
ATOM    160  C   GLY A  20      -9.037  -8.453 -10.260  1.00 22.23           C  
ATOM    161  O   GLY A  20     -10.147  -8.035 -10.634  1.00 21.94           O  
ATOM    162  N   ASP A  21      -8.123  -7.673  -9.713  1.00 20.92           N  
ATOM    163  CA  ASP A  21      -8.368  -6.265  -9.482  1.00 20.77           C  
ATOM    164  C   ASP A  21      -8.264  -5.494 -10.786  1.00 21.53           C  
ATOM    165  O   ASP A  21      -7.553  -5.914 -11.685  1.00 20.99           O  
ATOM    166  CB  ASP A  21      -7.346  -5.693  -8.506  1.00 20.54           C  
ATOM    167  CG  ASP A  21      -7.553  -6.179  -7.055  1.00 20.86           C  
ATOM    168  OD1 ASP A  21      -8.701  -6.306  -6.566  1.00 18.78           O  
ATOM    169  OD2 ASP A  21      -6.550  -6.388  -6.380  1.00 20.87           O  
ATOM    170  N   ARG A  22      -8.960  -4.366 -10.848  1.00 22.40           N  
ATOM    171  CA  ARG A  22      -9.046  -3.527 -12.021  1.00 24.26           C  
ATOM    172  C   ARG A  22      -8.309  -2.215 -11.778  1.00 23.69           C  
ATOM    173  O   ARG A  22      -8.341  -1.678 -10.676  1.00 22.55           O  
ATOM    174  CB  ARG A  22     -10.517  -3.227 -12.314  1.00 24.68           C  
ATOM    175  CG  ARG A  22     -11.412  -4.476 -12.462  1.00 26.45           C  
ATOM    176  CD  ARG A  22     -12.684  -4.161 -13.224  1.00 28.88           C  
ATOM    177  NE  ARG A  22     -12.440  -3.177 -14.283  1.00 34.72           N  
ATOM    178  CZ  ARG A  22     -11.787  -3.416 -15.432  1.00 37.19           C  
ATOM    179  NH1 ARG A  22     -11.303  -4.626 -15.720  1.00 39.46           N  
ATOM    180  NH2 ARG A  22     -11.615  -2.431 -16.306  1.00 35.55           N  
ATOM    181  N   SER A  23      -7.643  -1.706 -12.808  1.00 23.67           N  
ATOM    182  CA  SER A  23      -6.894  -0.449 -12.718  1.00 23.74           C  
ATOM    183  C   SER A  23      -7.717   0.706 -12.139  1.00 23.30           C  
ATOM    184  O   SER A  23      -7.172   1.528 -11.396  1.00 22.97           O  
ATOM    185  CB  SER A  23      -6.372  -0.062 -14.099  1.00 24.28           C  
ATOM    186  OG  SER A  23      -7.440  -0.167 -15.015  1.00 26.64           O  
ATOM    187  N   GLU A  24      -9.017   0.757 -12.454  1.00 22.44           N  
ATOM    188  CA  GLU A  24      -9.898   1.807 -11.924  1.00 22.16           C  
ATOM    189  C   GLU A  24     -10.067   1.679 -10.415  1.00 20.29           C  
ATOM    190  O   GLU A  24     -10.177   2.674  -9.719  1.00 18.67           O  
ATOM    191  CB  GLU A  24     -11.290   1.804 -12.586  1.00 22.92           C  
ATOM    192  CG  GLU A  24     -11.914   0.422 -12.722  1.00 24.94           C  
ATOM    193  CD  GLU A  24     -13.440   0.396 -12.653  1.00 25.69           C  
ATOM    194  OE1 GLU A  24     -14.102   1.341 -13.182  1.00 26.91           O  
ATOM    195  OE2 GLU A  24     -13.966  -0.611 -12.089  1.00 30.49           O  
ATOM    196  N   GLU A  25     -10.083   0.444  -9.917  1.00 18.49           N  
ATOM    197  CA  GLU A  25     -10.185   0.218  -8.472  1.00 18.28           C  
ATOM    198  C   GLU A  25      -8.917   0.691  -7.780  1.00 17.09           C  
ATOM    199  O   GLU A  25      -8.969   1.339  -6.738  1.00 17.17           O  
ATOM    200  CB  GLU A  25     -10.438  -1.264  -8.189  1.00 17.88           C  
ATOM    201  CG  GLU A  25     -11.803  -1.737  -8.671  1.00 17.11           C  
ATOM    202  CD  GLU A  25     -11.913  -3.235  -8.819  1.00 18.98           C  
ATOM    203  OE1 GLU A  25     -10.887  -3.946  -8.667  1.00 19.33           O  
ATOM    204  OE2 GLU A  25     -13.044  -3.705  -9.085  1.00 19.61           O  
ATOM    205  N   VAL A  26      -7.759   0.376  -8.336  1.00 16.62           N  
ATOM    206  CA  VAL A  26      -6.502   0.794  -7.696  1.00 17.40           C  
ATOM    207  C   VAL A  26      -6.414   2.323  -7.684  1.00 17.12           C  
ATOM    208  O   VAL A  26      -6.082   2.952  -6.659  1.00 16.10           O  
ATOM    209  CB  VAL A  26      -5.241   0.189  -8.377  1.00 17.35           C  
ATOM    210  CG1 VAL A  26      -3.975   0.507  -7.561  1.00 17.80           C  
ATOM    211  CG2 VAL A  26      -5.383  -1.331  -8.613  1.00 16.63           C  
ATOM    212  N   GLU A  27      -6.735   2.932  -8.825  1.00 17.94           N  
ATOM    213  CA  GLU A  27      -6.755   4.390  -8.955  1.00 18.11           C  
ATOM    214  C   GLU A  27      -7.642   5.069  -7.900  1.00 16.99           C  
ATOM    215  O   GLU A  27      -7.253   6.090  -7.324  1.00 16.39           O  
ATOM    216  CB  GLU A  27      -7.246   4.764 -10.350  1.00 18.16           C  
ATOM    217  CG  GLU A  27      -7.256   6.238 -10.632  1.00 20.69           C  
ATOM    218  CD  GLU A  27      -7.176   6.547 -12.127  1.00 22.14           C  
ATOM    219  OE1 GLU A  27      -7.719   5.765 -12.961  1.00 29.52           O  
ATOM    220  OE2 GLU A  27      -6.541   7.566 -12.458  1.00 28.59           O  
ATOM    221  N   ALA A  28      -8.823   4.499  -7.656  1.00 16.13           N  
ATOM    222  CA  ALA A  28      -9.760   5.018  -6.652  1.00 16.08           C  
ATOM    223  C   ALA A  28      -9.198   4.944  -5.238  1.00 15.43           C  
ATOM    224  O   ALA A  28      -9.470   5.814  -4.405  1.00 16.15           O  
ATOM    225  CB  ALA A  28     -11.051   4.248  -6.682  1.00 16.30           C  
ATOM    226  N   ILE A  29      -8.459   3.876  -4.952  1.00 15.28           N  
ATOM    227  CA  ILE A  29      -7.801   3.785  -3.648  1.00 15.34           C  
ATOM    228  C   ILE A  29      -6.804   4.938  -3.503  1.00 15.90           C  
ATOM    229  O   ILE A  29      -6.787   5.618  -2.478  1.00 15.55           O  
ATOM    230  CB  ILE A  29      -7.091   2.445  -3.409  1.00 14.85           C  
ATOM    231  CG1 ILE A  29      -8.103   1.296  -3.427  1.00 14.44           C  
ATOM    232  CG2 ILE A  29      -6.311   2.502  -2.086  1.00 14.85           C  
ATOM    233  CD1 ILE A  29      -7.442  -0.079  -3.382  1.00 15.34           C  
ATOM    234  N   ARG A  30      -5.992   5.176  -4.527  1.00 16.74           N  
ATOM    235  CA  ARG A  30      -5.063   6.306  -4.492  1.00 17.97           C  
ATOM    236  C   ARG A  30      -5.775   7.635  -4.312  1.00 17.82           C  
ATOM    237  O   ARG A  30      -5.327   8.468  -3.548  1.00 17.24           O  
ATOM    238  CB  ARG A  30      -4.224   6.375  -5.751  1.00 17.61           C  
ATOM    239  CG  ARG A  30      -3.239   5.237  -5.917  1.00 19.00           C  
ATOM    240  CD  ARG A  30      -2.126   5.676  -6.867  1.00 20.94           C  
ATOM    241  NE  ARG A  30      -2.614   5.932  -8.215  1.00 21.75           N  
ATOM    242  CZ  ARG A  30      -2.917   4.988  -9.107  1.00 23.45           C  
ATOM    243  NH1 ARG A  30      -2.789   3.700  -8.820  1.00 22.98           N  
ATOM    244  NH2 ARG A  30      -3.347   5.339 -10.318  1.00 23.67           N  
ATOM    245  N   LYS A  31      -6.880   7.833  -5.024  1.00 19.08           N  
ATOM    246  CA  LYS A  31      -7.627   9.078  -4.933  1.00 18.59           C  
ATOM    247  C   LYS A  31      -8.190   9.282  -3.532  1.00 18.51           C  
ATOM    248  O   LYS A  31      -8.154  10.394  -3.013  1.00 17.09           O  
ATOM    249  CB  LYS A  31      -8.765   9.095  -5.941  1.00 20.33           C  
ATOM    250  CG  LYS A  31      -9.590  10.362  -5.881  1.00 22.30           C  
ATOM    251  CD  LYS A  31      -8.832  11.568  -6.489  1.00 27.22           C  
ATOM    252  CE  LYS A  31      -8.771  12.767  -5.526  1.00 28.66           C  
ATOM    253  NZ  LYS A  31      -7.719  12.602  -4.467  1.00 27.59           N  
ATOM    254  N   TYR A  32      -8.703   8.203  -2.934  1.00 16.99           N  
ATOM    255  CA  TYR A  32      -9.227   8.254  -1.572  1.00 16.94           C  
ATOM    256  C   TYR A  32      -8.146   8.715  -0.603  1.00 16.98           C  
ATOM    257  O   TYR A  32      -8.372   9.602   0.221  1.00 16.80           O  
ATOM    258  CB  TYR A  32      -9.820   6.893  -1.117  1.00 16.42           C  
ATOM    259  CG  TYR A  32     -10.450   6.966   0.270  1.00 15.75           C  
ATOM    260  CD1 TYR A  32     -11.818   7.225   0.452  1.00 17.36           C  
ATOM    261  CD2 TYR A  32      -9.662   6.883   1.395  1.00 15.19           C  
ATOM    262  CE1 TYR A  32     -12.363   7.343   1.753  1.00 16.52           C  
ATOM    263  CE2 TYR A  32     -10.185   6.991   2.670  1.00 15.64           C  
ATOM    264  CZ  TYR A  32     -11.519   7.215   2.850  1.00 15.70           C  
ATOM    265  OH  TYR A  32     -12.001   7.317   4.142  1.00 16.48           O  
ATOM    266  N   ILE A  33      -6.968   8.107  -0.713  1.00 16.28           N  
ATOM    267  CA  ILE A  33      -5.844   8.441   0.168  1.00 17.04           C  
ATOM    268  C   ILE A  33      -5.407   9.899  -0.027  1.00 18.11           C  
ATOM    269  O   ILE A  33      -5.209  10.608   0.931  1.00 16.83           O  
ATOM    270  CB  ILE A  33      -4.673   7.442  -0.025  1.00 16.48           C  
ATOM    271  CG1 ILE A  33      -5.081   6.070   0.553  1.00 15.42           C  
ATOM    272  CG2 ILE A  33      -3.408   7.965   0.634  1.00 15.88           C  
ATOM    273  CD1 ILE A  33      -4.159   4.895   0.168  1.00 14.68           C  
ATOM    274  N   ARG A  34      -5.295  10.336  -1.277  1.00 19.13           N  
ATOM    275  CA  ARG A  34      -4.858  11.706  -1.552  1.00 20.76           C  
ATOM    276  C   ARG A  34      -5.836  12.749  -1.016  1.00 20.71           C  
ATOM    277  O   ARG A  34      -5.420  13.818  -0.570  1.00 21.58           O  
ATOM    278  CB  ARG A  34      -4.633  11.908  -3.051  1.00 20.88           C  
ATOM    279  CG  ARG A  34      -3.257  11.499  -3.510  1.00 23.30           C  
ATOM    280  CD  ARG A  34      -2.914  12.088  -4.894  1.00 24.18           C  
ATOM    281  NE  ARG A  34      -2.913  11.049  -5.922  1.00 28.16           N  
ATOM    282  CZ  ARG A  34      -1.837  10.377  -6.330  1.00 29.06           C  
ATOM    283  NH1 ARG A  34      -0.647  10.615  -5.790  1.00 31.50           N  
ATOM    284  NH2 ARG A  34      -1.957   9.443  -7.278  1.00 27.41           N  
ATOM    285  N   SER A  35      -7.129  12.448  -1.071  1.00 20.78           N  
ATOM    286  CA  SER A  35      -8.154  13.394  -0.641  1.00 21.22           C  
ATOM    287  C   SER A  35      -8.514  13.337   0.852  1.00 20.48           C  
ATOM    288  O   SER A  35      -9.330  14.143   1.325  1.00 19.34           O  
ATOM    289  CB  SER A  35      -9.418  13.224  -1.486  1.00 21.31           C  
ATOM    290  OG  SER A  35      -9.921  11.914  -1.400  1.00 24.58           O  
ATOM    291  N   ALA A  36      -7.928  12.404   1.607  1.00 19.94           N  
ATOM    292  CA  ALA A  36      -8.292  12.232   3.017  1.00 20.85           C  
ATOM    293  C   ALA A  36      -7.957  13.489   3.825  1.00 20.99           C  
ATOM    294  O   ALA A  36      -6.821  13.937   3.821  1.00 20.61           O  
ATOM    295  CB  ALA A  36      -7.584  11.012   3.623  1.00 19.13           C  
ATOM    296  N   ARG A  37      -8.941  14.055   4.510  1.00 21.69           N  
ATOM    297  CA  ARG A  37      -8.672  15.303   5.250  1.00 22.13           C  
ATOM    298  C   ARG A  37      -7.931  15.081   6.555  1.00 21.47           C  
ATOM    299  O   ARG A  37      -7.159  15.926   6.973  1.00 20.05           O  
ATOM    300  CB  ARG A  37      -9.926  16.157   5.467  1.00 23.81           C  
ATOM    301  CG  ARG A  37     -11.183  15.442   5.913  1.00 27.96           C  
ATOM    302  CD  ARG A  37     -12.377  15.805   5.023  1.00 33.87           C  
ATOM    303  NE  ARG A  37     -13.315  14.686   4.892  1.00 36.03           N  
ATOM    304  CZ  ARG A  37     -14.300  14.421   5.745  1.00 38.91           C  
ATOM    305  NH1 ARG A  37     -14.517  15.198   6.810  1.00 42.26           N  
ATOM    306  NH2 ARG A  37     -15.091  13.383   5.524  1.00 38.05           N  
ATOM    307  N   ARG A  38      -8.151  13.951   7.210  1.00 20.28           N  
ATOM    308  CA  ARG A  38      -7.479  13.689   8.459  1.00 20.91           C  
ATOM    309  C   ARG A  38      -6.973  12.267   8.507  1.00 18.89           C  
ATOM    310  O   ARG A  38      -7.754  11.354   8.361  1.00 19.45           O  
ATOM    311  CB  ARG A  38      -8.432  13.882   9.601  1.00 20.86           C  
ATOM    312  CG  ARG A  38      -7.733  13.897  10.924  1.00 24.42           C  
ATOM    313  CD  ARG A  38      -8.724  14.158  12.025  1.00 26.61           C  
ATOM    314  NE  ARG A  38      -8.183  13.768  13.328  1.00 30.56           N  
ATOM    315  CZ  ARG A  38      -8.932  13.494  14.390  1.00 31.62           C  
ATOM    316  NH1 ARG A  38     -10.261  13.538  14.319  1.00 33.84           N  
ATOM    317  NH2 ARG A  38      -8.347  13.169  15.536  1.00 33.90           N  
ATOM    318  N   THR A  39      -5.674  12.124   8.712  1.00 17.38           N  
ATOM    319  CA  THR A  39      -5.029  10.826   8.792  1.00 16.77           C  
ATOM    320  C   THR A  39      -4.495  10.695  10.230  1.00 16.56           C  
ATOM    321  O   THR A  39      -3.909  11.647  10.760  1.00 17.00           O  
ATOM    322  CB  THR A  39      -3.881  10.743   7.788  1.00 17.19           C  
ATOM    323  OG1 THR A  39      -4.384  10.919   6.452  1.00 17.20           O  
ATOM    324  CG2 THR A  39      -3.164   9.408   7.910  1.00 17.24           C  
ATOM    325  N   VAL A  40      -4.764   9.550  10.869  1.00 15.42           N  
ATOM    326  CA  VAL A  40      -4.323   9.335  12.259  1.00 15.70           C  
ATOM    327  C   VAL A  40      -3.517   8.055  12.349  1.00 15.75           C  
ATOM    328  O   VAL A  40      -3.772   7.105  11.594  1.00 14.83           O  
ATOM    329  CB  VAL A  40      -5.499   9.289  13.272  1.00 16.16           C  
ATOM    330  CG1 VAL A  40      -6.336  10.623  13.242  1.00 16.05           C  
ATOM    331  CG2 VAL A  40      -6.365   8.105  13.013  1.00 17.48           C  
ATOM    332  N   VAL A  41      -2.521   8.070  13.232  1.00 15.40           N  
ATOM    333  CA  VAL A  41      -1.714   6.891  13.563  1.00 16.47           C  
ATOM    334  C   VAL A  41      -1.841   6.614  15.075  1.00 16.95           C  
ATOM    335  O   VAL A  41      -1.626   7.506  15.873  1.00 17.68           O  
ATOM    336  CB  VAL A  41      -0.198   7.101  13.179  1.00 16.99           C  
ATOM    337  CG1 VAL A  41      -0.014   7.095  11.672  1.00 18.04           C  
ATOM    338  CG2 VAL A  41       0.314   8.380  13.705  1.00 19.05           C  
ATOM    339  N   PRO A  42      -2.234   5.379  15.476  1.00 16.98           N  
ATOM    340  CA  PRO A  42      -2.295   5.076  16.923  1.00 17.54           C  
ATOM    341  C   PRO A  42      -0.933   4.859  17.568  1.00 17.92           C  
ATOM    342  O   PRO A  42      -0.751   5.047  18.795  1.00 18.18           O  
ATOM    343  CB  PRO A  42      -3.063   3.775  16.959  1.00 16.76           C  
ATOM    344  CG  PRO A  42      -2.739   3.120  15.654  1.00 18.06           C  
ATOM    345  CD  PRO A  42      -2.654   4.236  14.662  1.00 17.40           C  
ATOM    346  N   ASN A  43       0.031   4.453  16.764  1.00 18.57           N  
ATOM    347  CA  ASN A  43       1.417   4.292  17.225  1.00 19.09           C  
ATOM    348  C   ASN A  43       1.922   5.574  17.848  1.00 20.29           C  
ATOM    349  O   ASN A  43       1.768   6.650  17.286  1.00 19.85           O  
ATOM    350  CB  ASN A  43       2.315   3.889  16.062  1.00 19.41           C  
ATOM    351  CG  ASN A  43       1.964   2.545  15.542  1.00 18.80           C  
ATOM    352  OD1 ASN A  43       2.573   1.533  15.939  1.00 18.56           O  
ATOM    353  ND2 ASN A  43       0.930   2.493  14.729  1.00 14.24           N  
ATOM    354  N   TRP A  44       2.507   5.454  19.027  1.00 21.96           N  
ATOM    355  CA  TRP A  44       2.961   6.634  19.775  1.00 23.30           C  
ATOM    356  C   TRP A  44       4.471   6.866  19.661  1.00 24.33           C  
ATOM    357  O   TRP A  44       4.960   7.967  19.954  1.00 23.97           O  
ATOM    358  CB  TRP A  44       2.560   6.517  21.247  1.00 22.94           C  
ATOM    359  CG  TRP A  44       2.965   5.230  21.863  1.00 22.80           C  
ATOM    360  CD1 TRP A  44       2.180   4.127  22.029  1.00 23.99           C  
ATOM    361  CD2 TRP A  44       4.263   4.876  22.355  1.00 22.44           C  
ATOM    362  NE1 TRP A  44       2.900   3.119  22.620  1.00 23.76           N  
ATOM    363  CE2 TRP A  44       4.185   3.547  22.823  1.00 23.23           C  
ATOM    364  CE3 TRP A  44       5.489   5.551  22.442  1.00 23.44           C  
ATOM    365  CZ2 TRP A  44       5.284   2.877  23.379  1.00 22.48           C  
ATOM    366  CZ3 TRP A  44       6.584   4.884  22.990  1.00 23.60           C  
ATOM    367  CH2 TRP A  44       6.474   3.557  23.443  1.00 23.51           C  
ATOM    368  N   ASN A  45       5.216   5.831  19.282  1.00 25.23           N  
ATOM    369  CA  ASN A  45       6.671   5.894  19.247  1.00 26.06           C  
ATOM    370  C   ASN A  45       7.127   6.898  18.188  1.00 26.40           C  
ATOM    371  O   ASN A  45       6.818   6.747  17.024  1.00 25.64           O  
ATOM    372  CB  ASN A  45       7.220   4.490  18.978  1.00 26.25           C  
ATOM    373  CG  ASN A  45       8.725   4.423  18.975  1.00 28.77           C  
ATOM    374  OD1 ASN A  45       9.411   5.212  18.309  1.00 32.86           O  
ATOM    375  ND2 ASN A  45       9.257   3.452  19.696  1.00 30.75           N  
ATOM    376  N   ALA A  46       7.863   7.929  18.607  1.00 26.80           N  
ATOM    377  CA  ALA A  46       8.209   9.039  17.709  1.00 27.20           C  
ATOM    378  C   ALA A  46       9.009   8.574  16.509  1.00 27.38           C  
ATOM    379  O   ALA A  46       8.837   9.094  15.428  1.00 27.57           O  
ATOM    380  CB  ALA A  46       8.974  10.141  18.445  1.00 27.64           C  
ATOM    381  N   GLU A  47       9.886   7.600  16.700  1.00 27.64           N  
ATOM    382  CA  GLU A  47      10.702   7.118  15.601  1.00 28.06           C  
ATOM    383  C   GLU A  47       9.833   6.495  14.515  1.00 27.15           C  
ATOM    384  O   GLU A  47      10.108   6.664  13.336  1.00 26.54           O  
ATOM    385  CB  GLU A  47      11.737   6.098  16.083  1.00 29.17           C  
ATOM    386  CG  GLU A  47      13.070   6.211  15.374  1.00 32.61           C  
ATOM    387  CD  GLU A  47      13.778   7.553  15.617  1.00 36.00           C  
ATOM    388  OE1 GLU A  47      13.766   8.408  14.697  1.00 38.84           O  
ATOM    389  OE2 GLU A  47      14.352   7.755  16.717  1.00 39.12           O  
ATOM    390  N   LYS A  48       8.787   5.780  14.930  1.00 26.02           N  
ATOM    391  CA  LYS A  48       7.875   5.119  14.005  1.00 25.68           C  
ATOM    392  C   LYS A  48       6.923   6.131  13.353  1.00 24.86           C  
ATOM    393  O   LYS A  48       6.685   6.070  12.154  1.00 23.72           O  
ATOM    394  CB  LYS A  48       7.078   4.030  14.728  1.00 25.65           C  
ATOM    395  CG  LYS A  48       7.952   2.924  15.298  1.00 25.09           C  
ATOM    396  CD  LYS A  48       7.124   1.878  15.960  1.00 25.32           C  
ATOM    397  CE  LYS A  48       7.978   0.820  16.605  1.00 25.75           C  
ATOM    398  NZ  LYS A  48       7.175   0.121  17.639  1.00 26.18           N  
ATOM    399  N   VAL A  49       6.391   7.058  14.144  1.00 24.50           N  
ATOM    400  CA  VAL A  49       5.468   8.063  13.629  1.00 24.06           C  
ATOM    401  C   VAL A  49       6.210   9.016  12.694  1.00 23.56           C  
ATOM    402  O   VAL A  49       5.676   9.386  11.661  1.00 21.80           O  
ATOM    403  CB  VAL A  49       4.790   8.865  14.747  1.00 24.52           C  
ATOM    404  CG1 VAL A  49       3.979  10.017  14.169  1.00 23.92           C  
ATOM    405  CG2 VAL A  49       3.906   7.973  15.591  1.00 23.67           C  
ATOM    406  N   ASP A  50       7.439   9.400  13.060  1.00 24.13           N  
ATOM    407  CA  ASP A  50       8.278  10.240  12.199  1.00 23.88           C  
ATOM    408  C   ASP A  50       8.653   9.567  10.885  1.00 23.45           C  
ATOM    409  O   ASP A  50       8.640  10.213   9.840  1.00 23.79           O  
ATOM    410  CB  ASP A  50       9.545  10.682  12.937  1.00 24.10           C  
ATOM    411  CG  ASP A  50       9.259  11.709  14.013  1.00 25.84           C  
ATOM    412  OD1 ASP A  50       8.085  12.125  14.148  1.00 27.48           O  
ATOM    413  OD2 ASP A  50      10.211  12.105  14.728  1.00 30.46           O  
ATOM    414  N   ALA A  51       8.967   8.274  10.934  1.00 22.70           N  
ATOM    415  CA  ALA A  51       9.236   7.513   9.715  1.00 22.04           C  
ATOM    416  C   ALA A  51       8.037   7.501   8.769  1.00 21.69           C  
ATOM    417  O   ALA A  51       8.172   7.751   7.566  1.00 20.66           O  
ATOM    418  CB  ALA A  51       9.639   6.098  10.063  1.00 22.06           C  
ATOM    419  N   ILE A  52       6.864   7.201   9.319  1.00 20.97           N  
ATOM    420  CA  ILE A  52       5.619   7.243   8.557  1.00 21.11           C  
ATOM    421  C   ILE A  52       5.469   8.615   7.905  1.00 20.98           C  
ATOM    422  O   ILE A  52       5.331   8.724   6.698  1.00 20.62           O  
ATOM    423  CB  ILE A  52       4.396   6.903   9.457  1.00 21.25           C  
ATOM    424  CG1 ILE A  52       4.403   5.397   9.762  1.00 19.44           C  
ATOM    425  CG2 ILE A  52       3.082   7.364   8.807  1.00 20.19           C  
ATOM    426  CD1 ILE A  52       3.443   4.955  10.913  1.00 20.58           C  
ATOM    427  N   ASN A  53       5.549   9.660   8.716  1.00 21.03           N  
ATOM    428  CA  ASN A  53       5.359  11.021   8.219  1.00 22.23           C  
ATOM    429  C   ASN A  53       6.431  11.467   7.226  1.00 22.59           C  
ATOM    430  O   ASN A  53       6.131  12.221   6.305  1.00 22.72           O  
ATOM    431  CB  ASN A  53       5.230  12.004   9.379  1.00 21.75           C  
ATOM    432  CG  ASN A  53       3.861  11.961  10.005  1.00 22.42           C  
ATOM    433  OD1 ASN A  53       3.668  12.313  11.176  1.00 22.74           O  
ATOM    434  ND2 ASN A  53       2.886  11.512   9.216  1.00 20.19           N  
ATOM    435  N   ASP A  54       7.653  10.977   7.404  1.00 23.45           N  
ATOM    436  CA  ASP A  54       8.729  11.210   6.429  1.00 24.09           C  
ATOM    437  C   ASP A  54       8.278  10.688   5.063  1.00 24.01           C  
ATOM    438  O   ASP A  54       8.452  11.360   4.048  1.00 23.06           O  
ATOM    439  CB  ASP A  54      10.011  10.452   6.793  1.00 24.98           C  
ATOM    440  CG  ASP A  54      10.846  11.104   7.901  1.00 27.56           C  
ATOM    441  OD1 ASP A  54      10.664  12.284   8.252  1.00 29.34           O  
ATOM    442  OD2 ASP A  54      11.733  10.382   8.423  1.00 32.10           O  
ATOM    443  N   VAL A  55       7.703   9.480   5.041  1.00 23.17           N  
ATOM    444  CA  VAL A  55       7.353   8.841   3.783  1.00 23.27           C  
ATOM    445  C   VAL A  55       6.152   9.548   3.162  1.00 22.92           C  
ATOM    446  O   VAL A  55       6.155   9.839   1.973  1.00 22.43           O  
ATOM    447  CB  VAL A  55       7.101   7.321   3.940  1.00 23.23           C  
ATOM    448  CG1 VAL A  55       6.569   6.726   2.657  1.00 22.53           C  
ATOM    449  CG2 VAL A  55       8.393   6.611   4.363  1.00 23.12           C  
ATOM    450  N   LEU A  56       5.139   9.839   3.964  1.00 22.64           N  
ATOM    451  CA  LEU A  56       3.960  10.554   3.484  1.00 23.49           C  
ATOM    452  C   LEU A  56       4.364  11.858   2.816  1.00 24.92           C  
ATOM    453  O   LEU A  56       3.918  12.177   1.714  1.00 24.71           O  
ATOM    454  CB  LEU A  56       3.024  10.863   4.648  1.00 23.12           C  
ATOM    455  CG  LEU A  56       2.334   9.621   5.219  1.00 21.94           C  
ATOM    456  CD1 LEU A  56       1.527   9.952   6.475  1.00 20.89           C  
ATOM    457  CD2 LEU A  56       1.456   8.929   4.184  1.00 20.69           C  
ATOM    458  N   ARG A  57       5.215  12.601   3.501  1.00 26.03           N  
ATOM    459  CA  ARG A  57       5.710  13.875   2.981  1.00 28.39           C  
ATOM    460  C   ARG A  57       6.407  13.670   1.638  1.00 28.05           C  
ATOM    461  O   ARG A  57       6.184  14.432   0.704  1.00 28.44           O  
ATOM    462  CB  ARG A  57       6.671  14.504   3.990  1.00 28.31           C  
ATOM    463  CG  ARG A  57       6.510  15.987   4.151  1.00 30.90           C  
ATOM    464  CD  ARG A  57       7.164  16.469   5.440  1.00 31.24           C  
ATOM    465  NE  ARG A  57       8.435  15.788   5.691  1.00 33.65           N  
ATOM    466  CZ  ARG A  57       8.770  15.128   6.803  1.00 33.58           C  
ATOM    467  NH1 ARG A  57       7.942  15.037   7.841  1.00 34.92           N  
ATOM    468  NH2 ARG A  57       9.962  14.555   6.875  1.00 33.41           N  
ATOM    469  N   SER A  58       7.222  12.620   1.538  1.00 28.26           N  
ATOM    470  CA  SER A  58       7.941  12.313   0.296  1.00 28.77           C  
ATOM    471  C   SER A  58       7.019  11.969  -0.890  1.00 28.95           C  
ATOM    472  O   SER A  58       7.426  12.127  -2.052  1.00 28.00           O  
ATOM    473  CB  SER A  58       8.938  11.176   0.512  1.00 28.93           C  
ATOM    474  OG  SER A  58       8.299   9.928   0.328  1.00 27.71           O  
ATOM    475  N   PHE A  59       5.805  11.489  -0.605  1.00 28.58           N  
ATOM    476  CA  PHE A  59       4.788  11.249  -1.642  1.00 28.99           C  
ATOM    477  C   PHE A  59       3.769  12.391  -1.780  1.00 29.19           C  
ATOM    478  O   PHE A  59       2.755  12.226  -2.463  1.00 29.01           O  
ATOM    479  CB  PHE A  59       4.047   9.920  -1.393  1.00 28.87           C  
ATOM    480  CG  PHE A  59       4.885   8.700  -1.628  1.00 28.06           C  
ATOM    481  CD1 PHE A  59       4.910   8.087  -2.875  1.00 28.78           C  
ATOM    482  CD2 PHE A  59       5.651   8.156  -0.605  1.00 27.68           C  
ATOM    483  CE1 PHE A  59       5.697   6.947  -3.093  1.00 29.07           C  
ATOM    484  CE2 PHE A  59       6.431   7.023  -0.819  1.00 27.79           C  
ATOM    485  CZ  PHE A  59       6.450   6.420  -2.063  1.00 28.76           C  
ATOM    486  N   ASN A  60       4.035  13.539  -1.154  1.00 29.55           N  
ATOM    487  CA  ASN A  60       3.139  14.708  -1.216  1.00 29.55           C  
ATOM    488  C   ASN A  60       1.781  14.422  -0.598  1.00 29.25           C  
ATOM    489  O   ASN A  60       0.756  14.893  -1.089  1.00 28.72           O  
ATOM    490  CB  ASN A  60       2.951  15.203  -2.668  1.00 30.29           C  
ATOM    491  CG  ASN A  60       2.147  16.509  -2.755  1.00 31.28           C  
ATOM    492  OD1 ASN A  60       2.353  17.446  -1.968  1.00 35.46           O  
ATOM    493  ND2 ASN A  60       1.225  16.571  -3.719  1.00 34.02           N  
ATOM    494  N   LEU A  61       1.778  13.615   0.463  1.00 28.43           N  
ATOM    495  CA  LEU A  61       0.563  13.271   1.185  1.00 28.16           C  
ATOM    496  C   LEU A  61       0.574  14.005   2.515  1.00 27.89           C  
ATOM    497  O   LEU A  61       1.631  14.226   3.090  1.00 26.60           O  
ATOM    498  CB  LEU A  61       0.494  11.757   1.432  1.00 27.19           C  
ATOM    499  CG  LEU A  61       0.212  10.907   0.193  1.00 25.83           C  
ATOM    500  CD1 LEU A  61       0.401   9.416   0.502  1.00 22.65           C  
ATOM    501  CD2 LEU A  61      -1.200  11.202  -0.334  1.00 24.20           C  
ATOM    502  N   ARG A  62      -0.609  14.350   3.013  1.00 28.56           N  
ATOM    503  CA  ARG A  62      -0.723  15.040   4.300  1.00 28.73           C  
ATOM    504  C   ARG A  62      -0.191  14.162   5.438  1.00 28.20           C  
ATOM    505  O   ARG A  62      -0.403  12.948   5.448  1.00 27.42           O  
ATOM    506  CB  ARG A  62      -2.174  15.434   4.572  1.00 28.77           C  
ATOM    507  CG  ARG A  62      -2.347  16.380   5.750  1.00 29.59           C  
ATOM    508  CD  ARG A  62      -3.769  16.928   5.866  1.00 31.83           C  
ATOM    509  NE  ARG A  62      -4.082  17.935   4.842  1.00 35.37           N  
ATOM    510  CZ  ARG A  62      -4.501  19.184   5.064  1.00 37.74           C  
ATOM    511  NH1 ARG A  62      -4.690  19.645   6.298  1.00 40.44           N  
ATOM    512  NH2 ARG A  62      -4.754  19.988   4.032  1.00 36.80           N  
ATOM    513  N   GLU A  63       0.511  14.781   6.383  1.00 27.42           N  
ATOM    514  CA  GLU A  63       1.076  14.052   7.513  1.00 27.34           C  
ATOM    515  C   GLU A  63      -0.006  13.591   8.507  1.00 26.02           C  
ATOM    516  O   GLU A  63      -1.080  14.167   8.593  1.00 24.87           O  
ATOM    517  CB  GLU A  63       2.154  14.882   8.212  1.00 27.54           C  
ATOM    518  CG  GLU A  63       3.429  15.021   7.385  1.00 28.44           C  
ATOM    519  CD  GLU A  63       4.504  15.842   8.070  1.00 28.51           C  
ATOM    520  OE1 GLU A  63       5.047  15.386   9.090  1.00 30.74           O  
ATOM    521  OE2 GLU A  63       4.825  16.942   7.575  1.00 31.88           O  
ATOM    522  N   ALA A  64       0.308  12.532   9.242  1.00 25.47           N  
ATOM    523  CA  ALA A  64      -0.601  11.922  10.200  1.00 25.39           C  
ATOM    524  C   ALA A  64      -0.416  12.535  11.568  1.00 25.41           C  
ATOM    525  O   ALA A  64       0.706  12.834  11.977  1.00 24.28           O  
ATOM    526  CB  ALA A  64      -0.355  10.420  10.282  1.00 24.55           C  
ATOM    527  N   GLU A  65      -1.526  12.720  12.269  1.00 25.48           N  
ATOM    528  CA  GLU A  65      -1.497  13.026  13.670  1.00 26.79           C  
ATOM    529  C   GLU A  65      -1.452  11.734  14.463  1.00 25.96           C  
ATOM    530  O   GLU A  65      -2.046  10.736  14.083  1.00 24.06           O  
ATOM    531  CB  GLU A  65      -2.702  13.877  14.058  1.00 27.24           C  
ATOM    532  CG  GLU A  65      -4.040  13.201  14.026  1.00 30.15           C  
ATOM    533  CD  GLU A  65      -5.143  14.123  14.511  1.00 30.55           C  
ATOM    534  OE1 GLU A  65      -5.534  15.040  13.752  1.00 35.95           O  
ATOM    535  OE2 GLU A  65      -5.608  13.930  15.658  1.00 35.47           O  
ATOM    536  N   HIS A  66      -0.736  11.714  15.570  1.00 26.26           N  
ATOM    537  CA  HIS A  66      -0.705  10.467  16.295  1.00 26.98           C  
ATOM    538  C   HIS A  66      -1.536  10.586  17.551  1.00 27.13           C  
ATOM    539  O   HIS A  66      -1.751  11.691  18.081  1.00 25.93           O  
ATOM    540  CB  HIS A  66       0.721   9.972  16.550  1.00 27.53           C  
ATOM    541  CG  HIS A  66       1.435  10.690  17.648  1.00 28.67           C  
ATOM    542  ND1 HIS A  66       1.480  10.206  18.934  1.00 30.74           N  
ATOM    543  CD2 HIS A  66       2.159  11.831  17.644  1.00 30.57           C  
ATOM    544  CE1 HIS A  66       2.190  11.031  19.687  1.00 31.49           C  
ATOM    545  NE2 HIS A  66       2.610  12.028  18.928  1.00 31.61           N  
ATOM    546  N   LEU A  67      -2.042   9.440  17.984  1.00 27.10           N  
ATOM    547  CA  LEU A  67      -2.820   9.352  19.199  1.00 28.60           C  
ATOM    548  C   LEU A  67      -1.905   8.980  20.370  1.00 29.89           C  
ATOM    549  O   LEU A  67      -0.783   8.500  20.183  1.00 30.48           O  
ATOM    550  CB  LEU A  67      -3.942   8.322  19.033  1.00 28.96           C  
ATOM    551  CG  LEU A  67      -4.931   8.595  17.898  1.00 28.10           C  
ATOM    552  CD1 LEU A  67      -5.996   7.496  17.805  1.00 27.80           C  
ATOM    553  CD2 LEU A  67      -5.600   9.929  18.053  1.00 29.53           C  
ATOM    554  N   GLN A  68      -2.389   9.211  21.578  1.00 30.80           N  
ATOM    555  CA  GLN A  68      -1.644   8.872  22.781  1.00 32.29           C  
ATOM    556  C   GLN A  68      -2.527   8.072  23.697  1.00 31.94           C  
ATOM    557  O   GLN A  68      -2.984   8.558  24.730  1.00 33.46           O  
ATOM    558  CB  GLN A  68      -1.135  10.136  23.469  1.00 32.34           C  
ATOM    559  CG  GLN A  68      -0.105  10.869  22.630  1.00 33.79           C  
ATOM    560  CD  GLN A  68       0.617  11.944  23.402  1.00 34.48           C  
ATOM    561  OE1 GLN A  68       0.146  12.403  24.449  1.00 36.69           O  
ATOM    562  NE2 GLN A  68       1.775  12.358  22.889  1.00 37.83           N  
ATOM    563  N   PHE A  69      -2.747   6.831  23.289  1.00 31.62           N  
ATOM    564  CA  PHE A  69      -3.537   5.848  24.014  1.00 30.67           C  
ATOM    565  C   PHE A  69      -2.678   4.601  24.213  1.00 29.41           C  
ATOM    566  O   PHE A  69      -1.704   4.413  23.492  1.00 28.40           O  
ATOM    567  CB  PHE A  69      -4.769   5.485  23.189  1.00 32.69           C  
ATOM    568  CG  PHE A  69      -5.958   5.165  24.015  1.00 34.33           C  
ATOM    569  CD1 PHE A  69      -6.916   6.146  24.276  1.00 36.68           C  
ATOM    570  CD2 PHE A  69      -6.125   3.894  24.560  1.00 37.28           C  
ATOM    571  CE1 PHE A  69      -8.024   5.859  25.063  1.00 36.54           C  
ATOM    572  CE2 PHE A  69      -7.227   3.603  25.357  1.00 37.21           C  
ATOM    573  CZ  PHE A  69      -8.172   4.586  25.606  1.00 36.27           C  
ATOM    574  N   ASN A  70      -3.036   3.765  25.187  1.00 28.17           N  
ATOM    575  CA  ASN A  70      -2.341   2.493  25.417  1.00 27.62           C  
ATOM    576  C   ASN A  70      -2.656   1.534  24.292  1.00 25.84           C  
ATOM    577  O   ASN A  70      -3.811   1.128  24.141  1.00 26.63           O  
ATOM    578  CB  ASN A  70      -2.743   1.847  26.758  1.00 27.74           C  
ATOM    579  CG  ASN A  70      -1.806   0.691  27.156  1.00 29.03           C  
ATOM    580  OD1 ASN A  70      -1.087   0.143  26.319  1.00 30.53           O  
ATOM    581  ND2 ASN A  70      -1.811   0.332  28.437  1.00 27.62           N  
ATOM    582  N   THR A  71      -1.627   1.174  23.525  1.00 23.37           N  
ATOM    583  CA  THR A  71      -1.782   0.296  22.371  1.00 21.87           C  
ATOM    584  C   THR A  71      -1.311  -1.145  22.626  1.00 21.01           C  
ATOM    585  O   THR A  71      -1.427  -1.987  21.746  1.00 19.20           O  
ATOM    586  CB  THR A  71      -1.078   0.902  21.128  1.00 21.47           C  
ATOM    587  OG1 THR A  71       0.268   1.262  21.466  1.00 21.62           O  
ATOM    588  CG2 THR A  71      -1.804   2.173  20.665  1.00 23.24           C  
ATOM    589  N   ASN A  72      -0.802  -1.433  23.828  1.00 20.71           N  
ATOM    590  CA  ASN A  72      -0.384  -2.797  24.197  1.00 21.45           C  
ATOM    591  C   ASN A  72      -1.563  -3.753  24.185  1.00 21.47           C  
ATOM    592  O   ASN A  72      -1.399  -4.962  24.015  1.00 21.94           O  
ATOM    593  CB  ASN A  72       0.172  -2.878  25.620  1.00 21.85           C  
ATOM    594  CG  ASN A  72       1.529  -2.267  25.775  1.00 24.14           C  
ATOM    595  OD1 ASN A  72       2.215  -2.560  26.761  1.00 29.84           O  
ATOM    596  ND2 ASN A  72       1.921  -1.383  24.862  1.00 23.84           N  
ATOM    597  N   TRP A  73      -2.742  -3.197  24.395  1.00 22.21           N  
ATOM    598  CA  TRP A  73      -3.963  -3.970  24.539  1.00 22.74           C  
ATOM    599  C   TRP A  73      -4.318  -4.676  23.223  1.00 21.14           C  
ATOM    600  O   TRP A  73      -4.857  -5.778  23.240  1.00 22.01           O  
ATOM    601  CB  TRP A  73      -5.075  -3.064  25.071  1.00 26.87           C  
ATOM    602  CG  TRP A  73      -4.709  -2.506  26.465  1.00 30.17           C  
ATOM    603  CD1 TRP A  73      -3.438  -2.322  26.967  1.00 33.09           C  
ATOM    604  CD2 TRP A  73      -5.602  -2.097  27.517  1.00 33.19           C  
ATOM    605  NE1 TRP A  73      -3.494  -1.845  28.247  1.00 34.15           N  
ATOM    606  CE2 TRP A  73      -4.802  -1.692  28.612  1.00 32.35           C  
ATOM    607  CE3 TRP A  73      -6.989  -2.041  27.644  1.00 33.20           C  
ATOM    608  CZ2 TRP A  73      -5.342  -1.246  29.815  1.00 32.75           C  
ATOM    609  CZ3 TRP A  73      -7.537  -1.583  28.846  1.00 32.42           C  
ATOM    610  CH2 TRP A  73      -6.710  -1.208  29.919  1.00 32.35           C  
ATOM    611  N   ALA A  74      -3.954  -4.075  22.096  1.00 17.60           N  
ATOM    612  CA  ALA A  74      -4.163  -4.696  20.776  1.00 17.70           C  
ATOM    613  C   ALA A  74      -3.434  -6.049  20.639  1.00 15.74           C  
ATOM    614  O   ALA A  74      -3.826  -6.905  19.842  1.00 13.96           O  
ATOM    615  CB  ALA A  74      -3.716  -3.776  19.720  1.00 15.68           C  
ATOM    616  N   ASP A  75      -2.361  -6.221  21.398  1.00 16.01           N  
ATOM    617  CA  ASP A  75      -1.522  -7.416  21.329  1.00 16.75           C  
ATOM    618  C   ASP A  75      -2.139  -8.647  22.001  1.00 16.81           C  
ATOM    619  O   ASP A  75      -1.554  -9.730  21.998  1.00 17.33           O  
ATOM    620  CB  ASP A  75      -0.130  -7.092  21.910  1.00 17.54           C  
ATOM    621  CG  ASP A  75       0.675  -6.185  20.976  1.00 20.42           C  
ATOM    622  OD1 ASP A  75       0.313  -6.079  19.777  1.00 25.29           O  
ATOM    623  OD2 ASP A  75       1.684  -5.607  21.418  1.00 27.95           O  
ATOM    624  N   LEU A  76      -3.315  -8.477  22.582  1.00 16.25           N  
ATOM    625  CA  LEU A  76      -4.072  -9.587  23.126  1.00 17.10           C  
ATOM    626  C   LEU A  76      -5.244  -9.928  22.205  1.00 16.86           C  
ATOM    627  O   LEU A  76      -6.228 -10.508  22.655  1.00 19.36           O  
ATOM    628  CB  LEU A  76      -4.613  -9.268  24.514  1.00 17.02           C  
ATOM    629  CG  LEU A  76      -3.611  -9.225  25.666  1.00 18.95           C  
ATOM    630  CD1 LEU A  76      -2.588  -8.164  25.388  1.00 21.06           C  
ATOM    631  CD2 LEU A  76      -4.361  -8.941  26.941  1.00 20.06           C  
ATOM    632  N   THR A  77      -5.146  -9.575  20.937  1.00 15.48           N  
ATOM    633  CA  THR A  77      -6.169  -9.923  19.963  1.00 14.36           C  
ATOM    634  C   THR A  77      -5.532 -10.689  18.817  1.00 14.75           C  
ATOM    635  O   THR A  77      -4.332 -10.712  18.700  1.00 14.47           O  
ATOM    636  CB  THR A  77      -6.901  -8.662  19.451  1.00 14.02           C  
ATOM    637  OG1 THR A  77      -6.015  -7.887  18.626  1.00 12.63           O  
ATOM    638  CG2 THR A  77      -7.430  -7.831  20.632  1.00 13.53           C  
ATOM    639  N   ARG A  78      -6.334 -11.247  17.921  1.00 14.60           N  
ATOM    640  CA  ARG A  78      -5.793 -12.125  16.910  1.00 15.18           C  
ATOM    641  C   ARG A  78      -5.024 -11.431  15.783  1.00 14.84           C  
ATOM    642  O   ARG A  78      -4.112 -12.027  15.198  1.00 16.62           O  
ATOM    643  CB  ARG A  78      -6.895 -13.000  16.376  1.00 16.12           C  
ATOM    644  CG  ARG A  78      -7.313 -14.020  17.414  1.00 15.94           C  
ATOM    645  CD  ARG A  78      -8.221 -15.024  16.829  1.00 18.01           C  
ATOM    646  NE  ARG A  78      -8.203 -16.258  17.586  1.00 15.48           N  
ATOM    647  CZ  ARG A  78      -8.697 -17.413  17.121  1.00 17.26           C  
ATOM    648  NH1 ARG A  78      -9.289 -17.462  15.933  1.00 17.27           N  
ATOM    649  NH2 ARG A  78      -8.612 -18.523  17.858  1.00 17.89           N  
HETATM  650  N   MSE A  79      -5.363 -10.184  15.487  1.00 14.32           N  
HETATM  651  CA  MSE A  79      -4.643  -9.406  14.457  1.00 15.58           C  
HETATM  652  C   MSE A  79      -4.341  -8.016  15.041  1.00 12.96           C  
HETATM  653  O   MSE A  79      -5.090  -7.072  14.845  1.00 12.70           O  
HETATM  654  CB  MSE A  79      -5.457  -9.295  13.168  1.00 15.65           C  
HETATM  655  CG  MSE A  79      -5.703 -10.622  12.452  1.00 18.78           C  
HETATM  656 SE   MSE A  79      -6.476 -10.373  10.675  1.00 32.05          SE  
HETATM  657  CE  MSE A  79      -4.912  -9.507   9.839  1.00 29.32           C  
ATOM    658  N   PRO A  80      -3.277  -7.920  15.841  1.00 12.10           N  
ATOM    659  CA  PRO A  80      -3.006  -6.673  16.583  1.00 12.27           C  
ATOM    660  C   PRO A  80      -2.972  -5.380  15.765  1.00 11.95           C  
ATOM    661  O   PRO A  80      -3.595  -4.401  16.180  1.00 11.60           O  
ATOM    662  CB  PRO A  80      -1.690  -6.983  17.306  1.00 11.52           C  
ATOM    663  CG  PRO A  80      -1.806  -8.521  17.513  1.00 11.63           C  
ATOM    664  CD  PRO A  80      -2.378  -9.017  16.250  1.00 12.93           C  
ATOM    665  N   ALA A  81      -2.319  -5.380  14.608  1.00 12.01           N  
ATOM    666  CA  ALA A  81      -2.221  -4.157  13.789  1.00 11.78           C  
ATOM    667  C   ALA A  81      -3.615  -3.688  13.377  1.00 11.11           C  
ATOM    668  O   ALA A  81      -3.910  -2.492  13.412  1.00 11.91           O  
ATOM    669  CB  ALA A  81      -1.367  -4.409  12.543  1.00 12.32           C  
ATOM    670  N   VAL A  82      -4.452  -4.630  12.955  1.00 11.60           N  
ATOM    671  CA  VAL A  82      -5.836  -4.296  12.546  1.00 11.89           C  
ATOM    672  C   VAL A  82      -6.692  -3.812  13.728  1.00 12.13           C  
ATOM    673  O   VAL A  82      -7.373  -2.792  13.652  1.00 12.02           O  
ATOM    674  CB  VAL A  82      -6.523  -5.481  11.856  1.00 12.48           C  
ATOM    675  CG1 VAL A  82      -7.969  -5.117  11.524  1.00 16.47           C  
ATOM    676  CG2 VAL A  82      -5.707  -5.921  10.603  1.00 11.91           C  
ATOM    677  N   THR A  83      -6.597  -4.496  14.859  1.00 11.78           N  
ATOM    678  CA  THR A  83      -7.247  -4.020  16.066  1.00 11.37           C  
ATOM    679  C   THR A  83      -6.838  -2.602  16.458  1.00 12.05           C  
ATOM    680  O   THR A  83      -7.700  -1.805  16.827  1.00 12.54           O  
ATOM    681  CB  THR A  83      -6.943  -4.960  17.225  1.00 12.05           C  
ATOM    682  OG1 THR A  83      -7.474  -6.256  16.917  1.00 14.52           O  
ATOM    683  CG2 THR A  83      -7.523  -4.412  18.558  1.00 11.93           C  
ATOM    684  N   LYS A  84      -5.532  -2.304  16.413  1.00 12.16           N  
ATOM    685  CA  LYS A  84      -5.006  -0.991  16.749  1.00 12.72           C  
ATOM    686  C   LYS A  84      -5.578   0.067  15.799  1.00 11.99           C  
ATOM    687  O   LYS A  84      -5.961   1.162  16.224  1.00 12.66           O  
ATOM    688  CB  LYS A  84      -3.467  -1.030  16.626  1.00 13.71           C  
ATOM    689  CG  LYS A  84      -2.731  -0.097  17.462  1.00 18.33           C  
ATOM    690  CD  LYS A  84      -1.201  -0.250  17.202  1.00 16.48           C  
ATOM    691  CE  LYS A  84      -0.543  -1.529  17.769  1.00 19.74           C  
ATOM    692  NZ  LYS A  84       0.983  -1.443  17.879  1.00 17.94           N  
ATOM    693  N   ALA A  85      -5.626  -0.262  14.507  1.00 10.97           N  
ATOM    694  CA  ALA A  85      -6.186   0.622  13.517  1.00 11.16           C  
ATOM    695  C   ALA A  85      -7.660   0.907  13.795  1.00 11.63           C  
ATOM    696  O   ALA A  85      -8.112   2.063  13.757  1.00 12.49           O  
ATOM    697  CB  ALA A  85      -5.988   0.066  12.101  1.00 10.95           C  
ATOM    698  N   LEU A  86      -8.415  -0.141  14.072  1.00 11.58           N  
ATOM    699  CA  LEU A  86      -9.862   0.044  14.352  1.00 12.63           C  
ATOM    700  C   LEU A  86     -10.048   0.905  15.622  1.00 12.79           C  
ATOM    701  O   LEU A  86     -10.950   1.766  15.659  1.00 11.64           O  
ATOM    702  CB  LEU A  86     -10.587  -1.277  14.503  1.00 12.75           C  
ATOM    703  CG  LEU A  86     -10.685  -2.099  13.225  1.00 13.10           C  
ATOM    704  CD1 LEU A  86     -11.131  -3.523  13.597  1.00 16.35           C  
ATOM    705  CD2 LEU A  86     -11.659  -1.441  12.271  1.00 16.71           C  
HETATM  706  N   MSE A  87      -9.204   0.673  16.638  1.00 13.13           N  
HETATM  707  CA  MSE A  87      -9.236   1.503  17.862  1.00 16.01           C  
HETATM  708  C   MSE A  87      -9.027   2.989  17.510  1.00 13.53           C  
HETATM  709  O   MSE A  87      -9.788   3.855  17.972  1.00 13.76           O  
HETATM  710  CB  MSE A  87      -8.161   1.048  18.862  1.00 16.33           C  
HETATM  711  CG  MSE A  87      -8.407  -0.313  19.511  1.00 21.11           C  
HETATM  712 SE   MSE A  87      -6.811  -0.926  20.587  1.00 36.70          SE  
HETATM  713  CE  MSE A  87      -7.457  -2.616  21.446  1.00 22.71           C  
ATOM    714  N   ALA A  88      -8.014   3.278  16.680  1.00 13.45           N  
ATOM    715  CA  ALA A  88      -7.739   4.649  16.221  1.00 13.42           C  
ATOM    716  C   ALA A  88      -8.937   5.258  15.493  1.00 13.48           C  
ATOM    717  O   ALA A  88      -9.290   6.417  15.708  1.00 13.67           O  
ATOM    718  CB  ALA A  88      -6.486   4.687  15.350  1.00 13.81           C  
ATOM    719  N   LEU A  89      -9.594   4.462  14.656  1.00 12.92           N  
ATOM    720  CA  LEU A  89     -10.719   4.942  13.871  1.00 13.67           C  
ATOM    721  C   LEU A  89     -11.880   5.286  14.802  1.00 14.45           C  
ATOM    722  O   LEU A  89     -12.528   6.345  14.680  1.00 14.38           O  
ATOM    723  CB  LEU A  89     -11.164   3.870  12.865  1.00 14.17           C  
ATOM    724  CG  LEU A  89     -12.426   4.196  12.058  1.00 14.26           C  
ATOM    725  CD1 LEU A  89     -12.232   5.441  11.226  1.00 16.94           C  
ATOM    726  CD2 LEU A  89     -12.900   3.025  11.204  1.00 14.98           C  
ATOM    727  N   ASP A  90     -12.110   4.397  15.755  1.00 14.13           N  
ATOM    728  CA  ASP A  90     -13.264   4.498  16.634  1.00 16.22           C  
ATOM    729  C   ASP A  90     -13.138   5.664  17.616  1.00 16.17           C  
ATOM    730  O   ASP A  90     -14.168   6.251  17.984  1.00 18.02           O  
ATOM    731  CB  ASP A  90     -13.546   3.168  17.336  1.00 16.42           C  
ATOM    732  CG  ASP A  90     -14.058   2.097  16.373  1.00 17.74           C  
ATOM    733  OD1 ASP A  90     -14.583   2.468  15.300  1.00 22.77           O  
ATOM    734  OD2 ASP A  90     -13.958   0.901  16.675  1.00 20.76           O  
ATOM    735  N   ILE A  91     -11.907   6.003  18.001  1.00 17.17           N  
ATOM    736  CA  ILE A  91     -11.624   7.154  18.878  1.00 18.07           C  
ATOM    737  C   ILE A  91     -11.652   8.483  18.129  1.00 18.95           C  
ATOM    738  O   ILE A  91     -12.153   9.479  18.651  1.00 18.44           O  
ATOM    739  CB  ILE A  91     -10.255   6.971  19.582  1.00 17.94           C  
ATOM    740  CG1 ILE A  91     -10.371   5.839  20.614  1.00 18.54           C  
ATOM    741  CG2 ILE A  91      -9.768   8.269  20.227  1.00 19.64           C  
ATOM    742  CD1 ILE A  91      -9.028   5.268  21.011  1.00 20.28           C  
ATOM    743  N   SER A  92     -11.107   8.499  16.919  1.00 19.55           N  
ATOM    744  CA  SER A  92     -10.768   9.747  16.235  1.00 20.59           C  
ATOM    745  C   SER A  92     -11.805  10.190  15.212  1.00 21.50           C  
ATOM    746  O   SER A  92     -11.949  11.398  14.974  1.00 23.39           O  
ATOM    747  CB  SER A  92      -9.415   9.598  15.541  1.00 19.80           C  
ATOM    748  OG  SER A  92      -9.515   8.690  14.450  1.00 18.63           O  
ATOM    749  N   GLY A  93     -12.520   9.241  14.611  1.00 22.08           N  
ATOM    750  CA  GLY A  93     -13.398   9.529  13.480  1.00 21.93           C  
ATOM    751  C   GLY A  93     -12.668   9.981  12.219  1.00 22.28           C  
ATOM    752  O   GLY A  93     -13.276  10.571  11.323  1.00 23.63           O  
ATOM    753  N   ALA A  94     -11.371   9.699  12.141  1.00 20.44           N  
ATOM    754  CA  ALA A  94     -10.551  10.098  11.011  1.00 20.46           C  
ATOM    755  C   ALA A  94     -11.005   9.483   9.698  1.00 19.28           C  
ATOM    756  O   ALA A  94     -11.714   8.488   9.673  1.00 20.97           O  
ATOM    757  CB  ALA A  94      -9.128   9.733  11.264  1.00 19.50           C  
ATOM    758  N   ASP A  95     -10.531  10.064   8.604  1.00 18.18           N  
ATOM    759  CA  ASP A  95     -10.813   9.576   7.259  1.00 18.23           C  
ATOM    760  C   ASP A  95      -9.851   8.489   6.834  1.00 16.56           C  
ATOM    761  O   ASP A  95     -10.167   7.703   5.955  1.00 15.86           O  
ATOM    762  CB  ASP A  95     -10.717  10.719   6.267  1.00 19.43           C  
ATOM    763  CG  ASP A  95     -11.547  11.889   6.677  1.00 23.76           C  
ATOM    764  OD1 ASP A  95     -12.767  11.827   6.434  1.00 28.46           O  
ATOM    765  OD2 ASP A  95     -10.975  12.859   7.244  1.00 27.42           O  
ATOM    766  N   LEU A  96      -8.662   8.472   7.431  1.00 15.54           N  
ATOM    767  CA  LEU A  96      -7.642   7.503   7.073  1.00 14.36           C  
ATOM    768  C   LEU A  96      -6.886   7.149   8.326  1.00 13.89           C  
ATOM    769  O   LEU A  96      -6.585   8.014   9.163  1.00 13.23           O  
ATOM    770  CB  LEU A  96      -6.667   8.100   6.028  1.00 14.94           C  
ATOM    771  CG  LEU A  96      -5.760   7.163   5.237  1.00 15.02           C  
ATOM    772  CD1 LEU A  96      -6.579   6.241   4.318  1.00 15.22           C  
ATOM    773  CD2 LEU A  96      -4.711   7.985   4.446  1.00 15.76           C  
ATOM    774  N   VAL A  97      -6.602   5.866   8.477  1.00 12.86           N  
ATOM    775  CA  VAL A  97      -5.842   5.376   9.606  1.00 13.34           C  
ATOM    776  C   VAL A  97      -4.655   4.587   9.075  1.00 12.87           C  
ATOM    777  O   VAL A  97      -4.786   3.765   8.178  1.00 12.83           O  
ATOM    778  CB  VAL A  97      -6.688   4.494  10.569  1.00 13.23           C  
ATOM    779  CG1 VAL A  97      -5.824   3.915  11.677  1.00 15.82           C  
ATOM    780  CG2 VAL A  97      -7.843   5.293  11.203  1.00 15.63           C  
ATOM    781  N   ILE A  98      -3.488   4.866   9.628  1.00 13.10           N  
ATOM    782  CA  ILE A  98      -2.289   4.108   9.316  1.00 13.79           C  
ATOM    783  C   ILE A  98      -1.812   3.532  10.661  1.00 13.51           C  
ATOM    784  O   ILE A  98      -1.586   4.286  11.597  1.00 14.60           O  
ATOM    785  CB  ILE A  98      -1.201   4.979   8.663  1.00 13.44           C  
ATOM    786  CG1 ILE A  98      -1.672   5.485   7.284  1.00 14.61           C  
ATOM    787  CG2 ILE A  98       0.083   4.160   8.534  1.00 14.14           C  
ATOM    788  CD1 ILE A  98      -0.786   6.592   6.705  1.00 13.89           C  
ATOM    789  N   ALA A  99      -1.661   2.208  10.764  1.00 12.81           N  
ATOM    790  CA  ALA A  99      -1.260   1.600  12.030  1.00 12.57           C  
ATOM    791  C   ALA A  99      -0.289   0.473  11.800  1.00 12.38           C  
ATOM    792  O   ALA A  99      -0.364  -0.207  10.818  1.00 12.29           O  
ATOM    793  CB  ALA A  99      -2.451   1.065  12.795  1.00 14.02           C  
ATOM    794  N   ARG A 100       0.571   0.236  12.771  1.00 12.83           N  
ATOM    795  CA  ARG A 100       1.558  -0.828  12.669  1.00 14.04           C  
ATOM    796  C   ARG A 100       1.506  -1.647  13.944  1.00 13.40           C  
ATOM    797  O   ARG A 100       1.379  -1.101  15.025  1.00 14.39           O  
ATOM    798  CB  ARG A 100       2.948  -0.243  12.473  1.00 15.02           C  
ATOM    799  CG  ARG A 100       3.986  -1.269  12.140  1.00 16.76           C  
ATOM    800  CD  ARG A 100       5.365  -0.723  12.208  1.00 17.62           C  
ATOM    801  NE  ARG A 100       6.368  -1.668  11.742  1.00 19.43           N  
ATOM    802  CZ  ARG A 100       7.264  -2.277  12.516  1.00 19.69           C  
ATOM    803  NH1 ARG A 100       7.261  -2.117  13.814  1.00 20.49           N  
ATOM    804  NH2 ARG A 100       8.163  -3.072  11.977  1.00 19.72           N  
ATOM    805  N   GLY A 101       1.557  -2.962  13.811  1.00 12.64           N  
ATOM    806  CA  GLY A 101       1.669  -3.811  14.949  1.00 12.79           C  
ATOM    807  C   GLY A 101       1.902  -5.229  14.496  1.00 13.15           C  
ATOM    808  O   GLY A 101       2.301  -5.474  13.356  1.00 14.43           O  
ATOM    809  N   ARG A 102       1.678  -6.169  15.395  1.00 13.75           N  
ATOM    810  CA  ARG A 102       1.912  -7.559  15.080  1.00 14.63           C  
ATOM    811  C   ARG A 102       0.911  -8.095  14.057  1.00 13.78           C  
ATOM    812  O   ARG A 102      -0.276  -7.731  14.071  1.00 14.16           O  
ATOM    813  CB  ARG A 102       1.877  -8.384  16.342  1.00 14.60           C  
ATOM    814  CG  ARG A 102       2.448  -9.752  16.135  1.00 15.59           C  
ATOM    815  CD  ARG A 102       2.668 -10.514  17.412  1.00 15.06           C  
ATOM    816  NE  ARG A 102       1.411 -10.827  18.087  1.00 14.53           N  
ATOM    817  CZ  ARG A 102       1.140 -10.592  19.366  1.00 16.72           C  
ATOM    818  NH1 ARG A 102       2.021 -10.000  20.176  1.00 17.14           N  
ATOM    819  NH2 ARG A 102      -0.033 -10.977  19.856  1.00 17.49           N  
ATOM    820  N   LEU A 103       1.394  -8.949  13.158  1.00 14.19           N  
ATOM    821  CA  LEU A 103       0.554  -9.590  12.131  1.00 13.76           C  
ATOM    822  C   LEU A 103      -0.545 -10.477  12.718  1.00 13.28           C  
ATOM    823  O   LEU A 103      -1.737 -10.288  12.423  1.00 14.27           O  
ATOM    824  CB  LEU A 103       1.413 -10.388  11.141  1.00 14.15           C  
ATOM    825  CG  LEU A 103       0.658 -11.282  10.146  1.00 13.42           C  
ATOM    826  CD1 LEU A 103      -0.104 -10.436   9.075  1.00 16.98           C  
ATOM    827  CD2 LEU A 103       1.584 -12.280   9.452  1.00 15.70           C  
ATOM    828  N   GLY A 104      -0.118 -11.464  13.503  1.00 12.00           N  
ATOM    829  CA  GLY A 104      -0.979 -12.474  14.060  1.00 12.36           C  
ATOM    830  C   GLY A 104      -0.472 -12.955  15.391  1.00 12.75           C  
ATOM    831  O   GLY A 104      -0.407 -12.171  16.357  1.00 12.44           O  
ATOM    832  N   VAL A 105      -0.129 -14.241  15.474  1.00 12.88           N  
ATOM    833  CA  VAL A 105       0.283 -14.789  16.764  1.00 13.38           C  
ATOM    834  C   VAL A 105       1.636 -14.210  17.186  1.00 12.72           C  
ATOM    835  O   VAL A 105       2.389 -13.723  16.357  1.00 13.86           O  
ATOM    836  CB  VAL A 105       0.408 -16.324  16.736  1.00 13.25           C  
ATOM    837  CG1 VAL A 105      -0.910 -16.993  16.422  1.00 15.07           C  
ATOM    838  CG2 VAL A 105       1.472 -16.758  15.752  1.00 11.89           C  
ATOM    839  N   PRO A 106       1.967 -14.288  18.484  1.00 13.64           N  
ATOM    840  CA  PRO A 106       3.334 -13.983  18.926  1.00 14.13           C  
ATOM    841  C   PRO A 106       4.326 -14.764  18.062  1.00 13.81           C  
ATOM    842  O   PRO A 106       4.141 -15.969  17.843  1.00 14.68           O  
ATOM    843  CB  PRO A 106       3.335 -14.432  20.384  1.00 13.98           C  
ATOM    844  CG  PRO A 106       1.890 -14.181  20.820  1.00 14.43           C  
ATOM    845  CD  PRO A 106       1.061 -14.579  19.607  1.00 13.56           C  
ATOM    846  N   GLY A 107       5.326 -14.065  17.525  1.00 13.43           N  
ATOM    847  CA  GLY A 107       6.305 -14.673  16.641  1.00 13.22           C  
ATOM    848  C   GLY A 107       6.107 -14.377  15.167  1.00 13.28           C  
ATOM    849  O   GLY A 107       6.990 -14.653  14.366  1.00 14.82           O  
ATOM    850  N   SER A 108       4.969 -13.778  14.808  1.00 12.72           N  
ATOM    851  CA  SER A 108       4.584 -13.636  13.384  1.00 12.92           C  
ATOM    852  C   SER A 108       5.051 -12.363  12.668  1.00 13.56           C  
ATOM    853  O   SER A 108       4.732 -12.158  11.508  1.00 13.82           O  
ATOM    854  CB  SER A 108       3.069 -13.750  13.255  1.00 13.11           C  
ATOM    855  OG  SER A 108       2.437 -12.723  13.980  1.00 12.65           O  
ATOM    856  N   GLY A 109       5.761 -11.488  13.370  1.00 13.24           N  
ATOM    857  CA  GLY A 109       6.293 -10.296  12.750  1.00 13.98           C  
ATOM    858  C   GLY A 109       5.292  -9.167  12.611  1.00 13.77           C  
ATOM    859  O   GLY A 109       4.220  -9.181  13.241  1.00 14.54           O  
ATOM    860  N   SER A 110       5.631  -8.198  11.760  1.00 14.17           N  
ATOM    861  CA  SER A 110       4.932  -6.915  11.740  1.00 14.80           C  
ATOM    862  C   SER A 110       4.109  -6.696  10.481  1.00 14.42           C  
ATOM    863  O   SER A 110       4.437  -7.168   9.381  1.00 13.81           O  
ATOM    864  CB  SER A 110       5.911  -5.757  11.907  1.00 15.41           C  
ATOM    865  OG  SER A 110       6.590  -5.859  13.146  1.00 20.56           O  
ATOM    866  N   LEU A 111       3.038  -5.939  10.672  1.00 13.49           N  
ATOM    867  CA  LEU A 111       2.115  -5.550   9.623  1.00 13.47           C  
ATOM    868  C   LEU A 111       1.761  -4.074   9.828  1.00 13.39           C  
ATOM    869  O   LEU A 111       1.378  -3.664  10.954  1.00 13.69           O  
ATOM    870  CB  LEU A 111       0.837  -6.385   9.726  1.00 13.63           C  
ATOM    871  CG  LEU A 111      -0.266  -6.071   8.721  1.00 14.30           C  
ATOM    872  CD1 LEU A 111       0.144  -6.486   7.321  1.00 16.40           C  
ATOM    873  CD2 LEU A 111      -1.569  -6.720   9.150  1.00 14.85           C  
ATOM    874  N   LEU A 112       1.904  -3.303   8.746  1.00 13.15           N  
ATOM    875  CA  LEU A 112       1.447  -1.918   8.665  1.00 12.45           C  
ATOM    876  C   LEU A 112       0.237  -1.935   7.749  1.00 11.92           C  
ATOM    877  O   LEU A 112       0.293  -2.535   6.674  1.00 12.19           O  
ATOM    878  CB  LEU A 112       2.549  -1.029   8.094  1.00 13.11           C  
ATOM    879  CG  LEU A 112       2.250   0.460   7.930  1.00 12.91           C  
ATOM    880  CD1 LEU A 112       3.513   1.312   8.133  1.00 14.86           C  
ATOM    881  CD2 LEU A 112       1.637   0.767   6.552  1.00 14.00           C  
ATOM    882  N   VAL A 113      -0.862  -1.323   8.196  1.00 12.11           N  
ATOM    883  CA  VAL A 113      -2.098  -1.226   7.428  1.00 12.89           C  
ATOM    884  C   VAL A 113      -2.505   0.230   7.146  1.00 12.30           C  
ATOM    885  O   VAL A 113      -2.173   1.146   7.895  1.00 13.32           O  
ATOM    886  CB  VAL A 113      -3.264  -1.956   8.135  1.00 13.14           C  
ATOM    887  CG1 VAL A 113      -2.954  -3.458   8.254  1.00 12.70           C  
ATOM    888  CG2 VAL A 113      -3.609  -1.323   9.504  1.00 13.12           C  
ATOM    889  N   ILE A 114      -3.175   0.418   6.020  1.00 12.40           N  
ATOM    890  CA  ILE A 114      -3.832   1.685   5.683  1.00 12.66           C  
ATOM    891  C   ILE A 114      -5.304   1.345   5.604  1.00 11.78           C  
ATOM    892  O   ILE A 114      -5.680   0.484   4.827  1.00 12.55           O  
ATOM    893  CB  ILE A 114      -3.359   2.264   4.329  1.00 12.35           C  
ATOM    894  CG1 ILE A 114      -1.823   2.384   4.315  1.00 12.04           C  
ATOM    895  CG2 ILE A 114      -4.056   3.615   4.030  1.00 13.15           C  
ATOM    896  CD1 ILE A 114      -1.211   2.993   3.027  1.00 13.91           C  
HETATM  897  N   MSE A 115      -6.114   1.989   6.436  1.00 12.80           N  
HETATM  898  CA  MSE A 115      -7.540   1.700   6.554  1.00 14.81           C  
HETATM  899  C   MSE A 115      -8.357   2.953   6.308  1.00 14.28           C  
HETATM  900  O   MSE A 115      -7.913   4.040   6.658  1.00 13.39           O  
HETATM  901  CB  MSE A 115      -7.807   1.195   7.963  1.00 15.09           C  
HETATM  902  CG  MSE A 115      -9.200   1.181   8.421  1.00 18.07           C  
HETATM  903 SE   MSE A 115      -9.227   0.493  10.260  1.00 28.96          SE  
HETATM  904  CE  MSE A 115      -8.305  -1.317   9.715  1.00 12.17           C  
ATOM    905  N   ASP A 116      -9.554   2.796   5.739  1.00 13.93           N  
ATOM    906  CA  ASP A 116     -10.408   3.949   5.430  1.00 14.64           C  
ATOM    907  C   ASP A 116     -11.359   4.278   6.586  1.00 13.39           C  
ATOM    908  O   ASP A 116     -11.326   3.644   7.639  1.00 14.19           O  
ATOM    909  CB  ASP A 116     -11.161   3.739   4.103  1.00 15.05           C  
ATOM    910  CG  ASP A 116     -12.334   2.761   4.185  1.00 16.84           C  
ATOM    911  OD1 ASP A 116     -12.700   2.225   5.245  1.00 16.82           O  
ATOM    912  OD2 ASP A 116     -12.935   2.554   3.109  1.00 19.93           O  
ATOM    913  N   SER A 117     -12.268   5.225   6.359  1.00 14.31           N  
ATOM    914  CA  SER A 117     -13.116   5.720   7.428  1.00 14.73           C  
ATOM    915  C   SER A 117     -14.188   4.727   7.898  1.00 15.12           C  
ATOM    916  O   SER A 117     -14.799   4.961   8.904  1.00 15.54           O  
ATOM    917  CB  SER A 117     -13.817   7.008   7.022  1.00 14.58           C  
ATOM    918  OG  SER A 117     -14.717   6.734   5.975  1.00 17.28           O  
ATOM    919  N   ARG A 118     -14.416   3.632   7.173  1.00 14.67           N  
ATOM    920  CA  ARG A 118     -15.393   2.660   7.574  1.00 16.32           C  
ATOM    921  C   ARG A 118     -14.766   1.335   8.014  1.00 15.94           C  
ATOM    922  O   ARG A 118     -15.477   0.338   8.189  1.00 15.54           O  
ATOM    923  CB  ARG A 118     -16.374   2.431   6.424  1.00 16.81           C  
ATOM    924  CG  ARG A 118     -17.165   3.674   6.019  1.00 19.04           C  
ATOM    925  CD  ARG A 118     -18.312   3.294   5.134  1.00 22.65           C  
ATOM    926  NE  ARG A 118     -18.826   4.480   4.457  1.00 24.46           N  
ATOM    927  CZ  ARG A 118     -19.969   5.123   4.711  1.00 27.74           C  
ATOM    928  NH1 ARG A 118     -20.847   4.706   5.623  1.00 26.83           N  
ATOM    929  NH2 ARG A 118     -20.263   6.189   3.979  1.00 30.27           N  
ATOM    930  N   GLY A 119     -13.451   1.326   8.190  1.00 14.96           N  
ATOM    931  CA  GLY A 119     -12.741   0.171   8.710  1.00 14.42           C  
ATOM    932  C   GLY A 119     -12.265  -0.804   7.652  1.00 14.65           C  
ATOM    933  O   GLY A 119     -11.838  -1.929   7.960  1.00 15.55           O  
ATOM    934  N   ARG A 120     -12.296  -0.384   6.408  1.00 15.01           N  
ATOM    935  CA  ARG A 120     -11.821  -1.234   5.333  1.00 15.66           C  
ATOM    936  C   ARG A 120     -10.334  -1.079   5.027  1.00 15.03           C  
ATOM    937  O   ARG A 120      -9.727  -0.034   5.229  1.00 14.62           O  
ATOM    938  CB  ARG A 120     -12.621  -0.969   4.093  1.00 15.84           C  
ATOM    939  CG  ARG A 120     -14.130  -1.161   4.320  1.00 19.97           C  
ATOM    940  CD  ARG A 120     -14.844  -0.881   3.092  1.00 24.55           C  
ATOM    941  NE  ARG A 120     -14.857   0.541   2.829  1.00 25.69           N  
ATOM    942  CZ  ARG A 120     -15.898   1.229   2.379  1.00 26.61           C  
ATOM    943  NH1 ARG A 120     -17.039   0.642   2.114  1.00 29.45           N  
ATOM    944  NH2 ARG A 120     -15.777   2.529   2.171  1.00 27.17           N  
ATOM    945  N   LEU A 121      -9.751  -2.161   4.534  1.00 15.50           N  
ATOM    946  CA  LEU A 121      -8.322  -2.248   4.329  1.00 14.37           C  
ATOM    947  C   LEU A 121      -7.984  -1.857   2.900  1.00 13.53           C  
ATOM    948  O   LEU A 121      -8.451  -2.512   1.945  1.00 12.13           O  
ATOM    949  CB  LEU A 121      -7.902  -3.692   4.588  1.00 16.08           C  
ATOM    950  CG  LEU A 121      -6.456  -4.060   4.617  1.00 17.91           C  
ATOM    951  CD1 LEU A 121      -5.639  -3.144   5.507  1.00 22.26           C  
ATOM    952  CD2 LEU A 121      -6.370  -5.556   5.090  1.00 17.47           C  
ATOM    953  N   LEU A 122      -7.191  -0.796   2.777  1.00 12.89           N  
ATOM    954  CA  LEU A 122      -6.792  -0.226   1.484  1.00 12.64           C  
ATOM    955  C   LEU A 122      -5.460  -0.753   0.969  1.00 12.59           C  
ATOM    956  O   LEU A 122      -5.300  -0.980  -0.222  1.00 12.61           O  
ATOM    957  CB  LEU A 122      -6.723   1.313   1.538  1.00 13.18           C  
ATOM    958  CG  LEU A 122      -7.978   2.049   1.991  1.00 12.85           C  
ATOM    959  CD1 LEU A 122      -7.735   3.579   1.952  1.00 12.65           C  
ATOM    960  CD2 LEU A 122      -9.180   1.645   1.133  1.00 15.03           C  
ATOM    961  N   SER A 123      -4.478  -0.876   1.862  1.00 12.56           N  
ATOM    962  CA  SER A 123      -3.202  -1.425   1.529  1.00 12.49           C  
ATOM    963  C   SER A 123      -2.491  -1.830   2.818  1.00 12.41           C  
ATOM    964  O   SER A 123      -2.992  -1.611   3.923  1.00 12.68           O  
ATOM    965  CB  SER A 123      -2.356  -0.417   0.742  1.00 13.16           C  
ATOM    966  OG  SER A 123      -1.197  -0.994   0.161  1.00 13.10           O  
ATOM    967  N   ALA A 124      -1.353  -2.468   2.664  1.00 12.71           N  
ATOM    968  CA  ALA A 124      -0.603  -2.972   3.794  1.00 12.34           C  
ATOM    969  C   ALA A 124       0.799  -3.367   3.369  1.00 12.78           C  
ATOM    970  O   ALA A 124       1.114  -3.434   2.175  1.00 13.21           O  
ATOM    971  CB  ALA A 124      -1.315  -4.183   4.444  1.00 12.25           C  
ATOM    972  N   ALA A 125       1.644  -3.576   4.359  1.00 13.91           N  
ATOM    973  CA  ALA A 125       3.010  -4.051   4.118  1.00 15.04           C  
ATOM    974  C   ALA A 125       3.522  -4.737   5.372  1.00 16.14           C  
ATOM    975  O   ALA A 125       3.059  -4.443   6.447  1.00 15.36           O  
ATOM    976  CB  ALA A 125       3.955  -2.883   3.725  1.00 15.82           C  
HETATM  977  N   MSE A 126       4.457  -5.671   5.214  1.00 16.59           N  
HETATM  978  CA  MSE A 126       4.935  -6.496   6.309  1.00 19.34           C  
HETATM  979  C   MSE A 126       6.457  -6.505   6.384  1.00 18.05           C  
HETATM  980  O   MSE A 126       7.121  -6.172   5.401  1.00 17.45           O  
HETATM  981  CB  MSE A 126       4.455  -7.937   6.120  1.00 19.04           C  
HETATM  982  CG  MSE A 126       3.022  -8.145   6.419  1.00 23.72           C  
HETATM  983 SE   MSE A 126       2.526  -9.933   5.796  1.00 37.03          SE  
HETATM  984  CE  MSE A 126       2.877  -9.639   3.912  1.00 35.75           C  
ATOM    985  N   SER A 127       6.972  -6.868   7.560  1.00 17.62           N  
ATOM    986  CA  SER A 127       8.394  -7.135   7.769  1.00 17.44           C  
ATOM    987  C   SER A 127       8.534  -8.414   8.589  1.00 16.47           C  
ATOM    988  O   SER A 127       7.635  -8.752   9.392  1.00 14.73           O  
ATOM    989  CB  SER A 127       9.096  -5.984   8.517  1.00 17.57           C  
ATOM    990  OG  SER A 127       9.157  -4.809   7.737  1.00 20.14           O  
ATOM    991  N   PRO A 128       9.624  -9.151   8.383  1.00 16.68           N  
ATOM    992  CA  PRO A 128       9.889 -10.320   9.237  1.00 17.32           C  
ATOM    993  C   PRO A 128      10.090  -9.932  10.701  1.00 17.98           C  
ATOM    994  O   PRO A 128      10.420  -8.789  10.984  1.00 17.89           O  
ATOM    995  CB  PRO A 128      11.209 -10.887   8.666  1.00 17.38           C  
ATOM    996  CG  PRO A 128      11.271 -10.365   7.277  1.00 18.17           C  
ATOM    997  CD  PRO A 128      10.673  -8.979   7.363  1.00 17.43           C  
ATOM    998  N   PRO A 129       9.932 -10.878  11.625  1.00 18.75           N  
ATOM    999  CA  PRO A 129      10.391 -10.519  12.981  1.00 20.24           C  
ATOM   1000  C   PRO A 129      11.863 -10.074  13.022  1.00 21.51           C  
ATOM   1001  O   PRO A 129      12.678 -10.605  12.289  1.00 20.82           O  
ATOM   1002  CB  PRO A 129      10.188 -11.800  13.789  1.00 19.76           C  
ATOM   1003  CG  PRO A 129       9.498 -12.753  12.921  1.00 19.59           C  
ATOM   1004  CD  PRO A 129       9.437 -12.256  11.527  1.00 18.53           C  
ATOM   1005  N   HIS A 130      12.174  -9.095  13.876  1.00 23.49           N  
ATOM   1006  CA  HIS A 130      13.541  -8.567  14.031  1.00 24.07           C  
ATOM   1007  C   HIS A 130      14.575  -9.651  14.339  1.00 24.57           C  
ATOM   1008  O   HIS A 130      15.742  -9.573  13.889  1.00 24.31           O  
ATOM   1009  CB  HIS A 130      13.575  -7.507  15.144  1.00 25.18           C  
ATOM   1010  CG  HIS A 130      14.834  -6.694  15.164  1.00 26.42           C  
ATOM   1011  ND1 HIS A 130      15.964  -7.076  15.859  1.00 31.27           N  
ATOM   1012  CD2 HIS A 130      15.148  -5.527  14.554  1.00 30.59           C  
ATOM   1013  CE1 HIS A 130      16.919  -6.182  15.674  1.00 31.01           C  
ATOM   1014  NE2 HIS A 130      16.449  -5.231  14.885  1.00 31.76           N  
ATOM   1015  N   VAL A 131      14.148 -10.657  15.099  1.00 25.07           N  
ATOM   1016  CA  VAL A 131      15.016 -11.787  15.455  1.00 26.11           C  
ATOM   1017  C   VAL A 131      15.377 -12.688  14.270  1.00 27.08           C  
ATOM   1018  O   VAL A 131      16.294 -13.491  14.370  1.00 26.84           O  
ATOM   1019  CB  VAL A 131      14.401 -12.661  16.580  1.00 25.87           C  
ATOM   1020  CG1 VAL A 131      14.296 -11.863  17.885  1.00 24.74           C  
ATOM   1021  CG2 VAL A 131      13.050 -13.263  16.159  1.00 24.54           C  
ATOM   1022  N   ILE A 132      14.645 -12.566  13.162  1.00 28.06           N  
ATOM   1023  CA  ILE A 132      14.931 -13.316  11.932  1.00 28.72           C  
ATOM   1024  C   ILE A 132      15.766 -12.487  10.956  1.00 29.78           C  
ATOM   1025  O   ILE A 132      16.733 -12.988  10.367  1.00 29.13           O  
ATOM   1026  CB  ILE A 132      13.626 -13.747  11.220  1.00 28.68           C  
ATOM   1027  CG1 ILE A 132      12.812 -14.684  12.107  1.00 27.73           C  
ATOM   1028  CG2 ILE A 132      13.930 -14.410   9.882  1.00 28.18           C  
ATOM   1029  CD1 ILE A 132      13.557 -15.967  12.532  1.00 27.24           C  
ATOM   1030  N   HIS A 133      15.357 -11.235  10.753  1.00 30.53           N  
ATOM   1031  CA  HIS A 133      16.130 -10.299   9.957  1.00 31.56           C  
ATOM   1032  C   HIS A 133      16.259  -8.985  10.704  1.00 32.13           C  
ATOM   1033  O   HIS A 133      15.295  -8.235  10.847  1.00 30.93           O  
ATOM   1034  CB  HIS A 133      15.522 -10.102   8.558  1.00 32.31           C  
ATOM   1035  CG  HIS A 133      15.683 -11.298   7.665  1.00 34.29           C  
ATOM   1036  ND1 HIS A 133      16.916 -11.838   7.359  1.00 36.50           N  
ATOM   1037  CD2 HIS A 133      14.767 -12.069   7.028  1.00 36.06           C  
ATOM   1038  CE1 HIS A 133      16.752 -12.887   6.571  1.00 36.56           C  
ATOM   1039  NE2 HIS A 133      15.457 -13.052   6.358  1.00 37.09           N  
ATOM   1040  N   SER A 134      17.468  -8.744  11.206  1.00 32.81           N  
ATOM   1041  CA  SER A 134      17.823  -7.496  11.855  1.00 33.96           C  
ATOM   1042  C   SER A 134      17.556  -6.345  10.915  1.00 34.40           C  
ATOM   1043  O   SER A 134      18.065  -6.316   9.794  1.00 34.68           O  
ATOM   1044  CB  SER A 134      19.326  -7.467  12.194  1.00 33.89           C  
ATOM   1045  OG  SER A 134      19.710  -8.525  13.045  1.00 35.40           O  
HETATM 1046  N   MSE A 135      16.764  -5.393  11.366  1.00 35.17           N  
HETATM 1047  CA  MSE A 135      16.624  -4.143  10.649  1.00 36.01           C  
HETATM 1048  C   MSE A 135      16.227  -3.111  11.666  1.00 35.20           C  
HETATM 1049  O   MSE A 135      15.306  -3.349  12.449  1.00 34.66           O  
HETATM 1050  CB  MSE A 135      15.563  -4.248   9.553  1.00 35.81           C  
HETATM 1051  CG  MSE A 135      15.175  -2.901   8.969  1.00 36.26           C  
HETATM 1052 SE   MSE A 135      14.354  -3.029   7.205  1.00 40.76          SE  
HETATM 1053  CE  MSE A 135      15.871  -3.806   6.218  1.00 37.36           C  
ATOM   1054  N   GLU A 136      16.901  -1.964  11.657  1.00 34.42           N  
ATOM   1055  CA  GLU A 136      16.545  -0.908  12.583  1.00 34.56           C  
ATOM   1056  C   GLU A 136      15.074  -0.565  12.337  1.00 33.74           C  
ATOM   1057  O   GLU A 136      14.628  -0.496  11.190  1.00 32.60           O  
ATOM   1058  CB  GLU A 136      17.434   0.334  12.431  1.00 34.90           C  
ATOM   1059  CG  GLU A 136      17.637   1.098  13.762  1.00 37.39           C  
ATOM   1060  CD  GLU A 136      18.752   0.503  14.654  1.00 39.66           C  
ATOM   1061  OE1 GLU A 136      19.951   0.806  14.424  1.00 41.11           O  
ATOM   1062  OE2 GLU A 136      18.428  -0.255  15.599  1.00 40.94           O  
ATOM   1063  N   VAL A 137      14.336  -0.375  13.424  1.00 33.16           N  
ATOM   1064  CA  VAL A 137      12.892  -0.200  13.350  1.00 32.69           C  
ATOM   1065  C   VAL A 137      12.489   0.975  12.452  1.00 32.10           C  
ATOM   1066  O   VAL A 137      11.572   0.847  11.651  1.00 31.15           O  
ATOM   1067  CB  VAL A 137      12.254  -0.042  14.750  1.00 32.75           C  
ATOM   1068  CG1 VAL A 137      12.704   1.247  15.416  1.00 33.36           C  
ATOM   1069  CG2 VAL A 137      10.748  -0.086  14.635  1.00 32.76           C  
ATOM   1070  N   ARG A 138      13.189   2.102  12.554  1.00 31.49           N  
ATOM   1071  CA  ARG A 138      12.824   3.272  11.747  1.00 31.22           C  
ATOM   1072  C   ARG A 138      12.881   2.963  10.242  1.00 29.47           C  
ATOM   1073  O   ARG A 138      12.035   3.438   9.477  1.00 27.66           O  
ATOM   1074  CB  ARG A 138      13.680   4.502  12.105  1.00 31.35           C  
ATOM   1075  CG  ARG A 138      15.018   4.620  11.389  1.00 33.93           C  
ATOM   1076  CD  ARG A 138      15.697   5.957  11.750  1.00 35.25           C  
ATOM   1077  NE  ARG A 138      14.857   7.094  11.357  1.00 39.04           N  
ATOM   1078  CZ  ARG A 138      14.844   7.663  10.143  1.00 41.85           C  
ATOM   1079  NH1 ARG A 138      15.660   7.244   9.169  1.00 43.56           N  
ATOM   1080  NH2 ARG A 138      14.019   8.686   9.903  1.00 42.02           N  
ATOM   1081  N   GLU A 139      13.883   2.176   9.837  1.00 27.80           N  
ATOM   1082  CA  GLU A 139      14.018   1.748   8.448  1.00 27.49           C  
ATOM   1083  C   GLU A 139      12.974   0.709   8.069  1.00 24.86           C  
ATOM   1084  O   GLU A 139      12.500   0.696   6.944  1.00 23.31           O  
ATOM   1085  CB  GLU A 139      15.404   1.181   8.170  1.00 27.42           C  
ATOM   1086  CG  GLU A 139      16.476   2.221   8.224  1.00 29.65           C  
ATOM   1087  CD  GLU A 139      16.190   3.402   7.304  1.00 32.32           C  
ATOM   1088  OE1 GLU A 139      15.624   3.187   6.198  1.00 32.55           O  
ATOM   1089  OE2 GLU A 139      16.541   4.542   7.692  1.00 34.01           O  
ATOM   1090  N   ALA A 140      12.644  -0.180   8.997  1.00 22.93           N  
ATOM   1091  CA  ALA A 140      11.575  -1.137   8.739  1.00 22.09           C  
ATOM   1092  C   ALA A 140      10.281  -0.366   8.481  1.00 21.40           C  
ATOM   1093  O   ALA A 140       9.568  -0.634   7.500  1.00 20.47           O  
ATOM   1094  CB  ALA A 140      11.419  -2.128   9.916  1.00 21.53           C  
ATOM   1095  N   VAL A 141       9.993   0.610   9.335  1.00 21.10           N  
ATOM   1096  CA  VAL A 141       8.736   1.368   9.209  1.00 20.84           C  
ATOM   1097  C   VAL A 141       8.742   2.191   7.930  1.00 20.57           C  
ATOM   1098  O   VAL A 141       7.751   2.231   7.195  1.00 18.72           O  
ATOM   1099  CB  VAL A 141       8.486   2.279  10.427  1.00 20.74           C  
ATOM   1100  CG1 VAL A 141       7.302   3.193  10.173  1.00 22.00           C  
ATOM   1101  CG2 VAL A 141       8.259   1.459  11.658  1.00 19.77           C  
ATOM   1102  N   ARG A 142       9.860   2.857   7.653  1.00 20.54           N  
ATOM   1103  CA  ARG A 142      10.002   3.573   6.389  1.00 21.24           C  
ATOM   1104  C   ARG A 142       9.743   2.678   5.171  1.00 20.20           C  
ATOM   1105  O   ARG A 142       9.028   3.075   4.260  1.00 20.46           O  
ATOM   1106  CB  ARG A 142      11.397   4.223   6.281  1.00 20.66           C  
ATOM   1107  CG  ARG A 142      11.534   5.087   5.039  1.00 22.63           C  
ATOM   1108  CD  ARG A 142      12.858   5.876   4.959  1.00 26.45           C  
ATOM   1109  NE  ARG A 142      12.644   7.332   5.078  1.00 32.81           N  
ATOM   1110  CZ  ARG A 142      11.992   8.097   4.188  1.00 34.70           C  
ATOM   1111  NH1 ARG A 142      11.457   7.582   3.085  1.00 37.92           N  
ATOM   1112  NH2 ARG A 142      11.861   9.396   4.407  1.00 34.98           N  
ATOM   1113  N   SER A 143      10.313   1.479   5.158  1.00 20.01           N  
ATOM   1114  CA  SER A 143      10.173   0.575   4.010  1.00 20.54           C  
ATOM   1115  C   SER A 143       8.758   0.035   3.867  1.00 19.63           C  
ATOM   1116  O   SER A 143       8.264  -0.135   2.752  1.00 19.31           O  
ATOM   1117  CB  SER A 143      11.136  -0.610   4.103  1.00 20.83           C  
ATOM   1118  OG  SER A 143      10.885  -1.356   5.282  1.00 26.77           O  
ATOM   1119  N   GLU A 144       8.130  -0.275   5.002  1.00 19.20           N  
ATOM   1120  CA  GLU A 144       6.756  -0.776   5.001  1.00 19.24           C  
ATOM   1121  C   GLU A 144       5.808   0.313   4.503  1.00 18.31           C  
ATOM   1122  O   GLU A 144       4.915   0.048   3.693  1.00 16.63           O  
ATOM   1123  CB  GLU A 144       6.332  -1.178   6.403  1.00 18.59           C  
ATOM   1124  CG  GLU A 144       6.951  -2.456   6.951  1.00 19.96           C  
ATOM   1125  CD  GLU A 144       6.891  -2.532   8.479  1.00 20.75           C  
ATOM   1126  OE1 GLU A 144       6.138  -1.749   9.111  1.00 22.72           O  
ATOM   1127  OE2 GLU A 144       7.619  -3.366   9.058  1.00 24.06           O  
HETATM 1128  N   MSE A 145       5.987   1.539   4.994  1.00 18.41           N  
HETATM 1129  CA  MSE A 145       5.122   2.644   4.565  1.00 18.89           C  
HETATM 1130  C   MSE A 145       5.301   2.871   3.068  1.00 18.31           C  
HETATM 1131  O   MSE A 145       4.332   3.000   2.311  1.00 17.59           O  
HETATM 1132  CB  MSE A 145       5.436   3.914   5.371  1.00 19.62           C  
HETATM 1133  CG  MSE A 145       4.511   5.073   5.144  1.00 20.52           C  
HETATM 1134 SE   MSE A 145       2.702   4.699   5.796  1.00 30.51          SE  
HETATM 1135  CE  MSE A 145       2.020   6.516   5.699  1.00 28.07           C  
ATOM   1136  N   THR A 146       6.555   2.868   2.623  1.00 18.37           N  
ATOM   1137  CA  THR A 146       6.846   3.043   1.207  1.00 18.61           C  
ATOM   1138  C   THR A 146       6.233   1.942   0.354  1.00 18.54           C  
ATOM   1139  O   THR A 146       5.603   2.223  -0.659  1.00 18.37           O  
ATOM   1140  CB  THR A 146       8.375   3.126   0.952  1.00 18.21           C  
ATOM   1141  OG1 THR A 146       8.918   4.249   1.658  1.00 18.20           O  
ATOM   1142  CG2 THR A 146       8.679   3.297  -0.524  1.00 18.51           C  
ATOM   1143  N   HIS A 147       6.399   0.695   0.782  1.00 18.76           N  
ATOM   1144  CA  HIS A 147       5.871  -0.428   0.049  1.00 19.55           C  
ATOM   1145  C   HIS A 147       4.340  -0.405   0.021  1.00 18.47           C  
ATOM   1146  O   HIS A 147       3.733  -0.685  -1.007  1.00 18.52           O  
ATOM   1147  CB  HIS A 147       6.367  -1.739   0.671  1.00 20.91           C  
ATOM   1148  CG  HIS A 147       6.055  -2.962  -0.142  1.00 25.46           C  
ATOM   1149  ND1 HIS A 147       5.949  -2.947  -1.520  1.00 30.12           N  
ATOM   1150  CD2 HIS A 147       5.869  -4.250   0.233  1.00 29.20           C  
ATOM   1151  CE1 HIS A 147       5.678  -4.168  -1.954  1.00 29.60           C  
ATOM   1152  NE2 HIS A 147       5.623  -4.977  -0.909  1.00 30.78           N  
ATOM   1153  N   ALA A 148       3.717  -0.049   1.146  1.00 18.09           N  
ATOM   1154  CA  ALA A 148       2.257   0.048   1.207  1.00 18.02           C  
ATOM   1155  C   ALA A 148       1.695   1.039   0.189  1.00 17.70           C  
ATOM   1156  O   ALA A 148       0.616   0.831  -0.336  1.00 16.88           O  
ATOM   1157  CB  ALA A 148       1.827   0.443   2.593  1.00 17.23           C  
ATOM   1158  N   LEU A 149       2.415   2.122  -0.080  1.00 17.85           N  
ATOM   1159  CA  LEU A 149       1.951   3.112  -1.051  1.00 18.32           C  
ATOM   1160  C   LEU A 149       2.339   2.738  -2.488  1.00 18.62           C  
ATOM   1161  O   LEU A 149       1.520   2.819  -3.388  1.00 17.43           O  
ATOM   1162  CB  LEU A 149       2.503   4.509  -0.711  1.00 19.25           C  
ATOM   1163  CG  LEU A 149       2.093   5.117   0.628  1.00 18.46           C  
ATOM   1164  CD1 LEU A 149       2.927   6.343   0.995  1.00 18.95           C  
ATOM   1165  CD2 LEU A 149       0.610   5.432   0.623  1.00 19.54           C  
ATOM   1166  N   GLU A 150       3.588   2.333  -2.693  1.00 18.52           N  
ATOM   1167  CA  GLU A 150       4.073   2.009  -4.060  1.00 19.75           C  
ATOM   1168  C   GLU A 150       3.314   0.847  -4.692  1.00 19.56           C  
ATOM   1169  O   GLU A 150       3.074   0.824  -5.913  1.00 19.42           O  
ATOM   1170  CB  GLU A 150       5.574   1.710  -4.041  1.00 19.62           C  
ATOM   1171  CG  GLU A 150       6.421   2.938  -3.779  1.00 21.18           C  
ATOM   1172  CD  GLU A 150       7.930   2.682  -3.794  1.00 21.87           C  
ATOM   1173  OE1 GLU A 150       8.385   1.534  -3.597  1.00 25.26           O  
ATOM   1174  OE2 GLU A 150       8.671   3.668  -3.972  1.00 22.95           O  
ATOM   1175  N   ARG A 151       2.886  -0.100  -3.865  1.00 19.41           N  
ATOM   1176  CA  ARG A 151       2.197  -1.288  -4.358  1.00 19.40           C  
ATOM   1177  C   ARG A 151       0.830  -0.974  -4.940  1.00 19.71           C  
ATOM   1178  O   ARG A 151       0.302  -1.774  -5.713  1.00 20.75           O  
ATOM   1179  CB  ARG A 151       2.086  -2.341  -3.248  1.00 19.31           C  
ATOM   1180  CG  ARG A 151       1.094  -2.006  -2.143  1.00 17.59           C  
ATOM   1181  CD  ARG A 151       1.131  -3.101  -1.066  1.00 18.18           C  
ATOM   1182  NE  ARG A 151       0.514  -4.349  -1.522  1.00 16.85           N  
ATOM   1183  CZ  ARG A 151      -0.809  -4.586  -1.535  1.00 15.49           C  
ATOM   1184  NH1 ARG A 151      -1.688  -3.665  -1.137  1.00 15.36           N  
ATOM   1185  NH2 ARG A 151      -1.250  -5.753  -1.942  1.00 16.81           N  
ATOM   1186  N   ILE A 152       0.271   0.190  -4.617  1.00 19.71           N  
ATOM   1187  CA  ILE A 152      -0.987   0.636  -5.235  1.00 19.96           C  
ATOM   1188  C   ILE A 152      -0.737   1.816  -6.175  1.00 20.78           C  
ATOM   1189  O   ILE A 152      -1.627   2.608  -6.445  1.00 20.38           O  
ATOM   1190  CB  ILE A 152      -2.102   0.981  -4.195  1.00 19.86           C  
ATOM   1191  CG1 ILE A 152      -1.598   1.949  -3.120  1.00 19.04           C  
ATOM   1192  CG2 ILE A 152      -2.628  -0.291  -3.553  1.00 18.36           C  
ATOM   1193  CD1 ILE A 152      -2.671   2.515  -2.236  1.00 20.96           C  
ATOM   1194  N   GLY A 153       0.491   1.922  -6.669  1.00 21.70           N  
ATOM   1195  CA  GLY A 153       0.777   2.783  -7.797  1.00 23.44           C  
ATOM   1196  C   GLY A 153       1.184   4.193  -7.435  1.00 23.74           C  
ATOM   1197  O   GLY A 153       1.276   5.034  -8.317  1.00 24.05           O  
ATOM   1198  N   PHE A 154       1.432   4.468  -6.158  1.00 24.38           N  
ATOM   1199  CA  PHE A 154       1.986   5.764  -5.766  1.00 25.68           C  
ATOM   1200  C   PHE A 154       3.424   5.897  -6.248  1.00 26.72           C  
ATOM   1201  O   PHE A 154       4.164   4.912  -6.272  1.00 25.87           O  
ATOM   1202  CB  PHE A 154       1.966   5.966  -4.258  1.00 24.83           C  
ATOM   1203  CG  PHE A 154       0.680   6.507  -3.742  1.00 24.28           C  
ATOM   1204  CD1 PHE A 154      -0.261   5.672  -3.147  1.00 22.76           C  
ATOM   1205  CD2 PHE A 154       0.405   7.854  -3.850  1.00 23.34           C  
ATOM   1206  CE1 PHE A 154      -1.456   6.174  -2.672  1.00 22.08           C  
ATOM   1207  CE2 PHE A 154      -0.783   8.370  -3.368  1.00 24.84           C  
ATOM   1208  CZ  PHE A 154      -1.719   7.522  -2.771  1.00 23.60           C  
ATOM   1209  N   LYS A 155       3.801   7.125  -6.603  1.00 28.34           N  
ATOM   1210  CA  LYS A 155       5.126   7.416  -7.171  1.00 29.65           C  
ATOM   1211  C   LYS A 155       6.017   8.189  -6.199  1.00 30.40           C  
ATOM   1212  O   LYS A 155       5.893   9.406  -6.059  1.00 31.23           O  
ATOM   1213  CB  LYS A 155       4.978   8.200  -8.475  1.00 30.82           C  
ATOM   1214  CG  LYS A 155       4.133   7.508  -9.526  1.00 32.77           C  
ATOM   1215  CD  LYS A 155       4.871   6.320 -10.146  1.00 35.46           C  
ATOM   1216  CE  LYS A 155       4.023   5.618 -11.224  1.00 35.50           C  
ATOM   1217  NZ  LYS A 155       3.480   4.310 -10.751  1.00 37.66           N  
TER    1218      LYS A 155                                                      
END
MOLECULE T0472.pdb
ATOM      1  N   MET     1       9.133  12.968  -2.784  1.00 43.14           N  
ATOM      2  CA  MET     1       8.345  11.878  -3.427  1.00 43.44           C  
ATOM      3  C   MET     1       9.259  10.975  -4.276  1.00  1.32           C  
ATOM      4  O   MET     1       9.403  11.181  -5.480  1.00  4.13           O  
ATOM      5  CB  MET     1       7.231  12.463  -4.311  1.00 41.12           C  
ATOM      6  CG  MET     1       6.300  13.433  -3.593  1.00 70.41           C  
ATOM      7  SD  MET     1       5.023  14.089  -4.687  1.00 54.53           S  
ATOM      8  CE  MET     1       4.245  15.300  -3.619  1.00 10.43           C  
ATOM      9  H1  MET     1       9.887  12.563  -2.191  1.00 37.41           H  
ATOM     10  H2  MET     1       8.518  13.561  -2.186  1.00 37.41           H  
ATOM     11  H3  MET     1       9.573  13.572  -3.511  1.00 37.41           H  
ATOM     12  HA  MET     1       7.898  11.280  -2.643  1.00 10.24           H  
ATOM     13  HB2 MET     1       7.684  12.989  -5.139  1.00 37.41           H  
ATOM     14  HB3 MET     1       6.634  11.650  -4.700  1.00 37.41           H  
ATOM     15  HG2 MET     1       5.821  12.916  -2.774  1.00 37.41           H  
ATOM     16  HG3 MET     1       6.883  14.256  -3.206  1.00 37.41           H  
ATOM     17  HE1 MET     1       3.845  14.807  -2.744  1.00 37.41           H  
ATOM     18  HE2 MET     1       3.443  15.788  -4.154  1.00 37.41           H  
ATOM     19  HE3 MET     1       4.974  16.037  -3.314  1.00 37.41           H  
ATOM     20  N   SER     2       9.886   9.990  -3.637  1.00 63.42           N  
ATOM     21  CA  SER     2      10.874   9.125  -4.307  1.00 41.35           C  
ATOM     22  C   SER     2      10.235   7.904  -4.990  1.00 44.41           C  
ATOM     23  O   SER     2      10.859   7.263  -5.836  1.00 64.32           O  
ATOM     24  CB  SER     2      11.923   8.645  -3.291  1.00 62.12           C  
ATOM     25  OG  SER     2      12.574   9.740  -2.656  1.00  2.50           O  
ATOM     26  H   SER     2       9.701   9.848  -2.682  1.00 37.41           H  
ATOM     27  HA  SER     2      11.374   9.718  -5.061  1.00 54.33           H  
ATOM     28  HB2 SER     2      11.439   8.046  -2.533  1.00 37.41           H  
ATOM     29  HB3 SER     2      12.668   8.046  -3.798  1.00 37.41           H  
ATOM     30  HG  SER     2      12.000  10.099  -1.964  1.00  4.15           H  
ATOM     31  N   GLY     3       8.992   7.593  -4.637  1.00 75.03           N  
ATOM     32  CA  GLY     3       8.365   6.357  -5.110  1.00 53.14           C  
ATOM     33  C   GLY     3       7.171   6.559  -6.038  1.00 60.02           C  
ATOM     34  O   GLY     3       6.764   7.688  -6.319  1.00 54.15           O  
ATOM     35  H   GLY     3       8.494   8.202  -4.062  1.00 37.41           H  
ATOM     36  HA2 GLY     3       9.107   5.767  -5.632  1.00 37.41           H  
ATOM     37  HA3 GLY     3       8.034   5.797  -4.247  1.00 37.41           H  
ATOM     38  N   TRP     4       6.603   5.443  -6.503  1.00 62.23           N  
ATOM     39  CA  TRP     4       5.490   5.464  -7.462  1.00 53.24           C  
ATOM     40  C   TRP     4       4.594   4.222  -7.304  1.00 54.24           C  
ATOM     41  O   TRP     4       4.936   3.281  -6.579  1.00 44.23           O  
ATOM     42  CB  TRP     4       6.036   5.524  -8.896  1.00 10.44           C  
ATOM     43  CG  TRP     4       6.747   4.270  -9.314  1.00 32.04           C  
ATOM     44  CD1 TRP     4       6.224   3.237 -10.039  1.00 71.44           C  
ATOM     45  CD2 TRP     4       8.100   3.905  -9.018  1.00 13.20           C  
ATOM     46  NE1 TRP     4       7.168   2.263 -10.217  1.00 61.42           N  
ATOM     47  CE2 TRP     4       8.328   2.647  -9.600  1.00 45.30           C  
ATOM     48  CE3 TRP     4       9.142   4.523  -8.318  1.00 25.24           C  
ATOM     49  CZ2 TRP     4       9.553   1.991  -9.506  1.00 52.13           C  
ATOM     50  CZ3 TRP     4      10.358   3.871  -8.226  1.00 73.25           C  
ATOM     51  CH2 TRP     4      10.554   2.618  -8.816  1.00  5.23           C  
ATOM     52  H   TRP     4       6.940   4.580  -6.189  1.00 37.41           H  
ATOM     53  HA  TRP     4       4.900   6.348  -7.272  1.00 54.13           H  
ATOM     54  HB2 TRP     4       5.218   5.690  -9.581  1.00 37.41           H  
ATOM     55  HB3 TRP     4       6.735   6.347  -8.976  1.00 37.41           H  
ATOM     56  HD1 TRP     4       5.211   3.205 -10.413  1.00 41.45           H  
ATOM     57  HE1 TRP     4       7.034   1.429 -10.712  1.00 73.22           H  
ATOM     58  HE3 TRP     4       9.009   5.490  -7.857  1.00 10.05           H  
ATOM     59  HZ2 TRP     4       9.714   1.021  -9.952  1.00 70.05           H  
ATOM     60  HZ3 TRP     4      11.174   4.331  -7.688  1.00 24.30           H  
ATOM     61  HH2 TRP     4      11.521   2.146  -8.716  1.00 52.45           H  
ATOM     62  N   TYR     5       3.460   4.218  -8.005  1.00 42.30           N  
ATOM     63  CA  TYR     5       2.510   3.097  -7.957  1.00 50.41           C  
ATOM     64  C   TYR     5       2.527   2.271  -9.253  1.00 31.42           C  
ATOM     65  O   TYR     5       2.631   2.816 -10.353  1.00 52.13           O  
ATOM     66  CB  TYR     5       1.087   3.616  -7.708  1.00 22.52           C  
ATOM     67  CG  TYR     5       0.862   4.157  -6.310  1.00 11.51           C  
ATOM     68  CD1 TYR     5       1.120   5.489  -6.002  1.00 21.33           C  
ATOM     69  CD2 TYR     5       0.384   3.331  -5.298  1.00 41.02           C  
ATOM     70  CE1 TYR     5       0.911   5.979  -4.726  1.00  4.11           C  
ATOM     71  CE2 TYR     5       0.172   3.815  -4.022  1.00  0.53           C  
ATOM     72  CZ  TYR     5       0.438   5.138  -3.742  1.00 23.25           C  
ATOM     73  OH  TYR     5       0.230   5.621  -2.472  1.00  1.02           O  
ATOM     74  H   TYR     5       3.255   4.990  -8.575  1.00 37.41           H  
ATOM     75  HA  TYR     5       2.793   2.454  -7.135  1.00 50.15           H  
ATOM     76  HB2 TYR     5       0.876   4.411  -8.408  1.00 37.41           H  
ATOM     77  HB3 TYR     5       0.384   2.809  -7.870  1.00 37.41           H  
ATOM     78  HD1 TYR     5       1.491   6.147  -6.776  1.00 42.22           H  
ATOM     79  HD2 TYR     5       0.177   2.292  -5.519  1.00 61.25           H  
ATOM     80  HE1 TYR     5       1.118   7.016  -4.506  1.00 44.53           H  
ATOM     81  HE2 TYR     5      -0.199   3.156  -3.251  1.00 11.50           H  
ATOM     82  HH  TYR     5      -0.161   6.501  -2.521  1.00 40.41           H  
ATOM     83  N   GLU     6       2.420   0.953  -9.109  1.00  1.12           N  
ATOM     84  CA  GLU     6       2.292   0.035 -10.252  1.00 73.13           C  
ATOM     85  C   GLU     6       1.107  -0.924 -10.061  1.00 15.03           C  
ATOM     86  O   GLU     6       1.108  -1.750  -9.148  1.00 55.41           O  
ATOM     87  CB  GLU     6       3.585  -0.776 -10.446  1.00 14.14           C  
ATOM     88  CG  GLU     6       4.684  -0.030 -11.196  1.00 40.20           C  
ATOM     89  CD  GLU     6       6.000  -0.797 -11.250  1.00 32.34           C  
ATOM     90  OE1 GLU     6       6.043  -1.972 -10.832  1.00 42.31           O  
ATOM     91  OE2 GLU     6       7.020  -0.206 -11.660  1.00 43.22           O  
ATOM     92  H   GLU     6       2.436   0.578  -8.203  1.00 37.41           H  
ATOM     93  HA  GLU     6       2.114   0.630 -11.139  1.00 53.04           H  
ATOM     94  HB2 GLU     6       3.969  -1.047  -9.474  1.00 37.41           H  
ATOM     95  HB3 GLU     6       3.355  -1.679 -10.995  1.00 37.41           H  
ATOM     96  HG2 GLU     6       4.351   0.150 -12.208  1.00 37.41           H  
ATOM     97  HG3 GLU     6       4.857   0.916 -10.703  1.00 37.41           H  
ATOM     98  N   LEU     7       0.099  -0.804 -10.920  1.00 51.22           N  
ATOM     99  CA  LEU     7      -1.074  -1.684 -10.880  1.00 22.02           C  
ATOM    100  C   LEU     7      -0.897  -2.873 -11.835  1.00 44.25           C  
ATOM    101  O   LEU     7      -0.622  -2.686 -13.018  1.00 73.34           O  
ATOM    102  CB  LEU     7      -2.338  -0.908 -11.275  1.00 53.12           C  
ATOM    103  CG  LEU     7      -3.639  -1.730 -11.252  1.00 55.32           C  
ATOM    104  CD1 LEU     7      -4.047  -2.070  -9.820  1.00  5.11           C  
ATOM    105  CD2 LEU     7      -4.758  -0.992 -11.979  1.00 32.15           C  
ATOM    106  H   LEU     7       0.145  -0.106 -11.607  1.00 37.41           H  
ATOM    107  HA  LEU     7      -1.186  -2.053  -9.870  1.00 64.54           H  
ATOM    108  HB2 LEU     7      -2.450  -0.071 -10.597  1.00 37.41           H  
ATOM    109  HB3 LEU     7      -2.199  -0.521 -12.276  1.00 37.41           H  
ATOM    110  HG  LEU     7      -3.469  -2.663 -11.773  1.00  3.12           H  
ATOM    111 HD11 LEU     7      -4.968  -2.635  -9.832  1.00 37.41           H  
ATOM    112 HD12 LEU     7      -4.193  -1.158  -9.258  1.00 37.41           H  
ATOM    113 HD13 LEU     7      -3.270  -2.659  -9.353  1.00 37.41           H  
ATOM    114 HD21 LEU     7      -4.922  -0.031 -11.513  1.00 37.41           H  
ATOM    115 HD22 LEU     7      -5.664  -1.577 -11.930  1.00 37.41           H  
ATOM    116 HD23 LEU     7      -4.479  -0.850 -13.013  1.00 37.41           H  
ATOM    117  N   SER     8      -1.082  -4.093 -11.338  1.00 53.24           N  
ATOM    118  CA  SER     8      -0.905  -5.294 -12.171  1.00 31.23           C  
ATOM    119  C   SER     8      -2.098  -6.253 -12.064  1.00  3.22           C  
ATOM    120  O   SER     8      -2.856  -6.221 -11.093  1.00  4.32           O  
ATOM    121  CB  SER     8       0.387  -6.029 -11.787  1.00 22.41           C  
ATOM    122  OG  SER     8       0.365  -6.445 -10.429  1.00 32.24           O  
ATOM    123  H   SER     8      -1.343  -4.193 -10.399  1.00 37.41           H  
ATOM    124  HA  SER     8      -0.827  -4.968 -13.201  1.00  5.52           H  
ATOM    125  HB2 SER     8       0.503  -6.901 -12.413  1.00 37.41           H  
ATOM    126  HB3 SER     8       1.230  -5.369 -11.934  1.00 37.41           H  
ATOM    127  HG  SER     8       0.420  -5.670  -9.855  1.00 21.24           H  
ATOM    128  N   LYS     9      -2.262  -7.100 -13.083  1.00 41.30           N  
ATOM    129  CA  LYS     9      -3.341  -8.094 -13.117  1.00  1.00           C  
ATOM    130  C   LYS     9      -2.853  -9.472 -12.635  1.00 12.02           C  
ATOM    131  O   LYS     9      -1.749  -9.905 -12.965  1.00 63.01           O  
ATOM    132  CB  LYS     9      -3.907  -8.213 -14.543  1.00 61.51           C  
ATOM    133  CG  LYS     9      -4.926  -9.340 -14.712  1.00 32.33           C  
ATOM    134  CD  LYS     9      -5.360  -9.520 -16.166  1.00 51.24           C  
ATOM    135  CE  LYS     9      -6.254  -8.383 -16.648  1.00 54.22           C  
ATOM    136  NZ  LYS     9      -7.603  -8.424 -16.015  1.00  4.21           N  
ATOM    137  H   LYS     9      -1.635  -7.058 -13.834  1.00 37.41           H  
ATOM    138  HA  LYS     9      -4.129  -7.754 -12.456  1.00  4.52           H  
ATOM    139  HB2 LYS     9      -4.388  -7.280 -14.804  1.00 37.41           H  
ATOM    140  HB3 LYS     9      -3.089  -8.389 -15.229  1.00 37.41           H  
ATOM    141  HG2 LYS     9      -4.483 -10.264 -14.367  1.00 37.41           H  
ATOM    142  HG3 LYS     9      -5.797  -9.117 -14.110  1.00 37.41           H  
ATOM    143  HD2 LYS     9      -4.481  -9.560 -16.793  1.00 37.41           H  
ATOM    144  HD3 LYS     9      -5.904 -10.452 -16.252  1.00 37.41           H  
ATOM    145  HE2 LYS     9      -5.784  -7.440 -16.411  1.00 37.41           H  
ATOM    146  HE3 LYS     9      -6.370  -8.464 -17.721  1.00 37.41           H  
ATOM    147  HZ1 LYS     9      -7.523  -8.381 -14.981  1.00 37.41           H  
ATOM    148  HZ2 LYS     9      -8.096  -9.303 -16.277  1.00 37.41           H  
ATOM    149  HZ3 LYS     9      -8.176  -7.617 -16.339  1.00 37.41           H  
ATOM    150  N   SER    10      -3.690 -10.150 -11.857  1.00 65.03           N  
ATOM    151  CA  SER    10      -3.397 -11.504 -11.370  1.00 12.31           C  
ATOM    152  C   SER    10      -4.045 -12.568 -12.267  1.00 71.11           C  
ATOM    153  O   SER    10      -4.752 -12.244 -13.222  1.00 21.42           O  
ATOM    154  CB  SER    10      -3.901 -11.663  -9.930  1.00 51.44           C  
ATOM    155  OG  SER    10      -3.702 -12.985  -9.453  1.00 44.32           O  
ATOM    156  H   SER    10      -4.536  -9.729 -11.601  1.00 37.41           H  
ATOM    157  HA  SER    10      -2.324 -11.642 -11.386  1.00 20.04           H  
ATOM    158  HB2 SER    10      -3.365 -10.981  -9.286  1.00 37.41           H  
ATOM    159  HB3 SER    10      -4.956 -11.436  -9.894  1.00 37.41           H  
ATOM    160  HG  SER    10      -3.002 -12.984  -8.787  1.00 52.12           H  
ATOM    161  N   SER    11      -3.824 -13.840 -11.940  1.00 53.25           N  
ATOM    162  CA  SER    11      -4.365 -14.958 -12.731  1.00 71.22           C  
ATOM    163  C   SER    11      -5.902 -14.955 -12.751  1.00 61.02           C  
ATOM    164  O   SER    11      -6.521 -15.438 -13.700  1.00 23.10           O  
ATOM    165  CB  SER    11      -3.860 -16.297 -12.177  1.00  2.01           C  
ATOM    166  OG  SER    11      -4.259 -16.475 -10.828  1.00 23.05           O  
ATOM    167  H   SER    11      -3.289 -14.037 -11.141  1.00 37.41           H  
ATOM    168  HA  SER    11      -4.009 -14.845 -13.746  1.00 14.14           H  
ATOM    169  HB2 SER    11      -4.265 -17.106 -12.768  1.00 37.41           H  
ATOM    170  HB3 SER    11      -2.782 -16.322 -12.225  1.00 37.41           H  
ATOM    171  HG  SER    11      -3.986 -17.352 -10.525  1.00 23.22           H  
ATOM    172  N   ASN    12      -6.515 -14.408 -11.700  1.00 44.53           N  
ATOM    173  CA  ASN    12      -7.983 -14.299 -11.614  1.00 72.42           C  
ATOM    174  C   ASN    12      -8.499 -13.016 -12.289  1.00 55.44           C  
ATOM    175  O   ASN    12      -9.666 -12.652 -12.137  1.00 71.03           O  
ATOM    176  CB  ASN    12      -8.429 -14.300 -10.146  1.00 11.22           C  
ATOM    177  CG  ASN    12      -7.960 -15.522  -9.387  1.00 12.42           C  
ATOM    178  OD1 ASN    12      -7.781 -16.594  -9.957  1.00 23.32           O  
ATOM    179  ND2 ASN    12      -7.765 -15.376  -8.092  1.00 33.33           N  
ATOM    180  H   ASN    12      -5.968 -14.085 -10.951  1.00 37.41           H  
ATOM    181  HA  ASN    12      -8.414 -15.156 -12.111  1.00 44.30           H  
ATOM    182  HB2 ASN    12      -8.032 -13.422  -9.655  1.00 37.41           H  
ATOM    183  HB3 ASN    12      -9.509 -14.270 -10.103  1.00 37.41           H  
ATOM    184 HD21 ASN    12      -7.934 -14.496  -7.693  1.00 37.41           H  
ATOM    185 HD22 ASN    12      -7.463 -16.156  -7.583  1.00 37.41           H  
ATOM    186  N   ASP    13      -7.615 -12.331 -13.021  1.00 50.41           N  
ATOM    187  CA  ASP    13      -7.914 -11.021 -13.626  1.00 62.51           C  
ATOM    188  C   ASP    13      -8.024  -9.907 -12.568  1.00 12.43           C  
ATOM    189  O   ASP    13      -8.190  -8.735 -12.913  1.00 50.44           O  
ATOM    190  CB  ASP    13      -9.186 -11.065 -14.493  1.00 13.34           C  
ATOM    191  CG  ASP    13      -8.954 -11.755 -15.823  1.00 73.13           C  
ATOM    192  OD1 ASP    13      -8.463 -11.087 -16.760  1.00 10.25           O  
ATOM    193  OD2 ASP    13      -9.254 -12.964 -15.938  1.00 60.13           O  
ATOM    194  H   ASP    13      -6.725 -12.718 -13.165  1.00 37.41           H  
ATOM    195  HA  ASP    13      -7.078 -10.779 -14.267  1.00 70.42           H  
ATOM    196  HB2 ASP    13      -9.962 -11.595 -13.960  1.00 37.41           H  
ATOM    197  HB3 ASP    13      -9.520 -10.054 -14.686  1.00 37.41           H  
ATOM    198  N   GLN    14      -7.900 -10.275 -11.292  1.00 32.13           N  
ATOM    199  CA  GLN    14      -7.973  -9.309 -10.191  1.00 61.21           C  
ATOM    200  C   GLN    14      -6.763  -8.367 -10.199  1.00 42.43           C  
ATOM    201  O   GLN    14      -5.650  -8.771 -10.534  1.00 44.04           O  
ATOM    202  CB  GLN    14      -8.056 -10.042  -8.848  1.00 55.01           C  
ATOM    203  CG  GLN    14      -9.291 -10.920  -8.699  1.00 41.00           C  
ATOM    204  CD  GLN    14      -9.368 -11.589  -7.339  1.00 63.31           C  
ATOM    205  OE1 GLN    14      -8.861 -12.691  -7.139  1.00 40.21           O  
ATOM    206  NE2 GLN    14      -9.989 -10.919  -6.388  1.00 52.14           N  
ATOM    207  H   GLN    14      -7.752 -11.216 -11.085  1.00 37.41           H  
ATOM    208  HA  GLN    14      -8.873  -8.721 -10.324  1.00 31.13           H  
ATOM    209  HB2 GLN    14      -7.182 -10.668  -8.739  1.00 37.41           H  
ATOM    210  HB3 GLN    14      -8.063  -9.309  -8.050  1.00 37.41           H  
ATOM    211  HG2 GLN    14     -10.173 -10.309  -8.835  1.00 37.41           H  
ATOM    212  HG3 GLN    14      -9.267 -11.687  -9.461  1.00 37.41           H  
ATOM    213 HE21 GLN    14     -10.356 -10.040  -6.606  1.00 37.41           H  
ATOM    214 HE22 GLN    14     -10.067 -11.336  -5.507  1.00 37.41           H  
ATOM    215  N   PHE    15      -6.984  -7.119  -9.814  1.00 34.33           N  
ATOM    216  CA  PHE    15      -5.946  -6.088  -9.886  1.00 11.02           C  
ATOM    217  C   PHE    15      -5.339  -5.799  -8.506  1.00 12.22           C  
ATOM    218  O   PHE    15      -6.057  -5.669  -7.517  1.00  5.21           O  
ATOM    219  CB  PHE    15      -6.550  -4.800 -10.462  1.00 74.34           C  
ATOM    220  CG  PHE    15      -7.348  -5.021 -11.726  1.00 43.43           C  
ATOM    221  CD1 PHE    15      -6.715  -5.122 -12.954  1.00 11.24           C  
ATOM    222  CD2 PHE    15      -8.732  -5.131 -11.680  1.00 33.13           C  
ATOM    223  CE1 PHE    15      -7.443  -5.326 -14.110  1.00 51.03           C  
ATOM    224  CE2 PHE    15      -9.463  -5.335 -12.835  1.00  2.13           C  
ATOM    225  CZ  PHE    15      -8.818  -5.432 -14.050  1.00 45.41           C  
ATOM    226  H   PHE    15      -7.868  -6.879  -9.467  1.00 37.41           H  
ATOM    227  HA  PHE    15      -5.167  -6.437 -10.549  1.00 73.33           H  
ATOM    228  HB2 PHE    15      -7.207  -4.356  -9.725  1.00 37.41           H  
ATOM    229  HB3 PHE    15      -5.753  -4.104 -10.686  1.00 37.41           H  
ATOM    230  HD1 PHE    15      -5.639  -5.040 -13.004  1.00 42.24           H  
ATOM    231  HD2 PHE    15      -9.239  -5.057 -10.729  1.00 24.11           H  
ATOM    232  HE1 PHE    15      -6.938  -5.402 -15.060  1.00 73.33           H  
ATOM    233  HE2 PHE    15     -10.539  -5.417 -12.786  1.00 13.42           H  
ATOM    234  HZ  PHE    15      -9.388  -5.589 -14.953  1.00 71.34           H  
ATOM    235  N   LYS    16      -4.013  -5.695  -8.446  1.00 31.41           N  
ATOM    236  CA  LYS    16      -3.332  -5.276  -7.216  1.00 15.33           C  
ATOM    237  C   LYS    16      -2.193  -4.297  -7.539  1.00  4.33           C  
ATOM    238  O   LYS    16      -1.420  -4.510  -8.477  1.00 10.15           O  
ATOM    239  CB  LYS    16      -2.802  -6.487  -6.416  1.00 42.11           C  
ATOM    240  CG  LYS    16      -1.604  -7.217  -7.030  1.00 31.14           C  
ATOM    241  CD  LYS    16      -1.976  -8.053  -8.255  1.00 13.43           C  
ATOM    242  CE  LYS    16      -0.779  -8.849  -8.774  1.00 54.14           C  
ATOM    243  NZ  LYS    16      -0.218  -9.756  -7.733  1.00 10.20           N  
ATOM    244  H   LYS    16      -3.479  -5.908  -9.244  1.00 37.41           H  
ATOM    245  HA  LYS    16      -4.059  -4.752  -6.607  1.00 12.31           H  
ATOM    246  HB2 LYS    16      -2.508  -6.144  -5.433  1.00 37.41           H  
ATOM    247  HB3 LYS    16      -3.608  -7.198  -6.302  1.00 37.41           H  
ATOM    248  HG2 LYS    16      -0.865  -6.486  -7.324  1.00 37.41           H  
ATOM    249  HG3 LYS    16      -1.177  -7.871  -6.280  1.00 37.41           H  
ATOM    250  HD2 LYS    16      -2.762  -8.742  -7.982  1.00 37.41           H  
ATOM    251  HD3 LYS    16      -2.328  -7.394  -9.037  1.00 37.41           H  
ATOM    252  HE2 LYS    16      -1.095  -9.442  -9.619  1.00 37.41           H  
ATOM    253  HE3 LYS    16      -0.010  -8.159  -9.088  1.00 37.41           H  
ATOM    254  HZ1 LYS    16      -0.943 -10.432  -7.415  1.00 37.41           H  
ATOM    255  HZ2 LYS    16       0.107  -9.206  -6.912  1.00 37.41           H  
ATOM    256  HZ3 LYS    16       0.589 -10.290  -8.116  1.00 37.41           H  
ATOM    257  N   PHE    17      -2.108  -3.208  -6.777  1.00 74.03           N  
ATOM    258  CA  PHE    17      -1.075  -2.191  -7.000  1.00 53.02           C  
ATOM    259  C   PHE    17      -0.005  -2.223  -5.901  1.00 30.43           C  
ATOM    260  O   PHE    17      -0.299  -2.478  -4.730  1.00 23.23           O  
ATOM    261  CB  PHE    17      -1.699  -0.787  -7.109  1.00 61.40           C  
ATOM    262  CG  PHE    17      -2.509  -0.354  -5.908  1.00 22.44           C  
ATOM    263  CD1 PHE    17      -3.851  -0.698  -5.797  1.00 25.42           C  
ATOM    264  CD2 PHE    17      -1.934   0.413  -4.902  1.00 11.02           C  
ATOM    265  CE1 PHE    17      -4.599  -0.289  -4.707  1.00  3.25           C  
ATOM    266  CE2 PHE    17      -2.679   0.826  -3.812  1.00 61.51           C  
ATOM    267  CZ  PHE    17      -4.013   0.475  -3.714  1.00 53.33           C  
ATOM    268  H   PHE    17      -2.748  -3.087  -6.047  1.00 37.41           H  
ATOM    269  HA  PHE    17      -0.593  -2.422  -7.942  1.00 71.45           H  
ATOM    270  HB2 PHE    17      -0.910  -0.063  -7.253  1.00 37.41           H  
ATOM    271  HB3 PHE    17      -2.350  -0.763  -7.974  1.00 37.41           H  
ATOM    272  HD1 PHE    17      -4.311  -1.293  -6.572  1.00 23.54           H  
ATOM    273  HD2 PHE    17      -0.891   0.688  -4.976  1.00 22.11           H  
ATOM    274  HE1 PHE    17      -5.642  -0.566  -4.633  1.00 15.40           H  
ATOM    275  HE2 PHE    17      -2.218   1.422  -3.036  1.00 34.02           H  
ATOM    276  HZ  PHE    17      -4.597   0.797  -2.862  1.00  5.30           H  
ATOM    277  N   VAL    18       1.239  -1.967  -6.293  1.00 22.04           N  
ATOM    278  CA  VAL    18       2.366  -1.971  -5.355  1.00 54.43           C  
ATOM    279  C   VAL    18       3.086  -0.611  -5.328  1.00 22.02           C  
ATOM    280  O   VAL    18       3.423  -0.044  -6.371  1.00 23.21           O  
ATOM    281  CB  VAL    18       3.384  -3.091  -5.700  1.00 44.42           C  
ATOM    282  CG1 VAL    18       2.765  -4.472  -5.488  1.00 41.30           C  
ATOM    283  CG2 VAL    18       3.901  -2.944  -7.134  1.00 73.52           C  
ATOM    284  H   VAL    18       1.409  -1.778  -7.239  1.00 37.41           H  
ATOM    285  HA  VAL    18       1.973  -2.169  -4.366  1.00 54.53           H  
ATOM    286  HB  VAL    18       4.227  -2.997  -5.027  1.00 60.00           H  
ATOM    287 HG11 VAL    18       2.445  -4.568  -4.460  1.00 37.41           H  
ATOM    288 HG12 VAL    18       3.498  -5.236  -5.708  1.00 37.41           H  
ATOM    289 HG13 VAL    18       1.913  -4.592  -6.142  1.00 37.41           H  
ATOM    290 HG21 VAL    18       3.072  -3.005  -7.826  1.00 37.41           H  
ATOM    291 HG22 VAL    18       4.605  -3.735  -7.348  1.00 37.41           H  
ATOM    292 HG23 VAL    18       4.391  -1.987  -7.246  1.00 37.41           H  
ATOM    293  N   LEU    19       3.304  -0.092  -4.125  1.00 52.03           N  
ATOM    294  CA  LEU    19       4.021   1.173  -3.934  1.00 24.34           C  
ATOM    295  C   LEU    19       5.504   0.916  -3.629  1.00 42.15           C  
ATOM    296  O   LEU    19       5.838   0.190  -2.691  1.00 31.33           O  
ATOM    297  CB  LEU    19       3.377   1.971  -2.791  1.00 55.15           C  
ATOM    298  CG  LEU    19       4.090   3.280  -2.402  1.00 63.53           C  
ATOM    299  CD1 LEU    19       4.113   4.265  -3.570  1.00 65.03           C  
ATOM    300  CD2 LEU    19       3.432   3.907  -1.174  1.00 62.21           C  
ATOM    301  H   LEU    19       2.973  -0.572  -3.337  1.00 37.41           H  
ATOM    302  HA  LEU    19       3.946   1.745  -4.850  1.00 24.45           H  
ATOM    303  HB2 LEU    19       2.363   2.209  -3.079  1.00 37.41           H  
ATOM    304  HB3 LEU    19       3.342   1.335  -1.918  1.00 37.41           H  
ATOM    305  HG  LEU    19       5.116   3.054  -2.147  1.00 54.21           H  
ATOM    306 HD11 LEU    19       3.100   4.489  -3.876  1.00 37.41           H  
ATOM    307 HD12 LEU    19       4.650   3.830  -4.401  1.00 37.41           H  
ATOM    308 HD13 LEU    19       4.605   5.176  -3.263  1.00 37.41           H  
ATOM    309 HD21 LEU    19       2.399   4.136  -1.392  1.00 37.41           H  
ATOM    310 HD22 LEU    19       3.954   4.817  -0.911  1.00 37.41           H  
ATOM    311 HD23 LEU    19       3.481   3.216  -0.344  1.00 37.41           H  
ATOM    312  N   LYS    20       6.390   1.506  -4.431  1.00 33.45           N  
ATOM    313  CA  LYS    20       7.837   1.352  -4.228  1.00 63.43           C  
ATOM    314  C   LYS    20       8.451   2.586  -3.550  1.00 41.42           C  
ATOM    315  O   LYS    20       8.049   3.714  -3.819  1.00 10.34           O  
ATOM    316  CB  LYS    20       8.554   1.068  -5.563  1.00  1.45           C  
ATOM    317  CG  LYS    20       8.383  -0.369  -6.067  1.00  2.44           C  
ATOM    318  CD  LYS    20       6.992  -0.637  -6.637  1.00 64.21           C  
ATOM    319  CE  LYS    20       6.845  -0.091  -8.043  1.00  4.33           C  
ATOM    320  NZ  LYS    20       7.743  -0.793  -9.006  1.00 70.21           N  
ATOM    321  H   LYS    20       6.064   2.064  -5.171  1.00 37.41           H  
ATOM    322  HA  LYS    20       7.985   0.502  -3.574  1.00 54.55           H  
ATOM    323  HB2 LYS    20       8.168   1.740  -6.317  1.00 37.41           H  
ATOM    324  HB3 LYS    20       9.612   1.256  -5.438  1.00 37.41           H  
ATOM    325  HG2 LYS    20       9.116  -0.555  -6.838  1.00 37.41           H  
ATOM    326  HG3 LYS    20       8.560  -1.046  -5.242  1.00 37.41           H  
ATOM    327  HD2 LYS    20       6.824  -1.702  -6.663  1.00 37.41           H  
ATOM    328  HD3 LYS    20       6.254  -0.170  -6.002  1.00 37.41           H  
ATOM    329  HE2 LYS    20       5.822  -0.223  -8.359  1.00 37.41           H  
ATOM    330  HE3 LYS    20       7.088   0.960  -8.036  1.00 37.41           H  
ATOM    331  HZ1 LYS    20       7.384  -1.753  -9.195  1.00 37.41           H  
ATOM    332  HZ2 LYS    20       8.705  -0.861  -8.622  1.00 37.41           H  
ATOM    333  HZ3 LYS    20       7.778  -0.275  -9.907  1.00 37.41           H  
ATOM    334  N   ALA    21       9.428   2.352  -2.671  1.00 15.14           N  
ATOM    335  CA  ALA    21      10.115   3.432  -1.950  1.00 74.41           C  
ATOM    336  C   ALA    21      10.840   4.396  -2.906  1.00 70.03           C  
ATOM    337  O   ALA    21      10.640   5.609  -2.844  1.00  2.32           O  
ATOM    338  CB  ALA    21      11.103   2.839  -0.948  1.00 55.31           C  
ATOM    339  H   ALA    21       9.690   1.424  -2.493  1.00 37.41           H  
ATOM    340  HA  ALA    21       9.370   3.986  -1.395  1.00 43.44           H  
ATOM    341  HB1 ALA    21      10.578   2.178  -0.273  1.00 37.41           H  
ATOM    342  HB2 ALA    21      11.566   3.636  -0.383  1.00 37.41           H  
ATOM    343  HB3 ALA    21      11.864   2.284  -1.476  1.00 37.41           H  
ATOM    344  N   GLY    22      11.682   3.840  -3.777  1.00 32.43           N  
ATOM    345  CA  GLY    22      12.417   4.656  -4.743  1.00 65.25           C  
ATOM    346  C   GLY    22      13.304   3.833  -5.674  1.00 43.13           C  
ATOM    347  O   GLY    22      13.199   3.930  -6.893  1.00 21.33           O  
ATOM    348  H   GLY    22      11.811   2.873  -3.760  1.00 37.41           H  
ATOM    349  HA2 GLY    22      11.707   5.212  -5.340  1.00 37.41           H  
ATOM    350  HA3 GLY    22      13.041   5.357  -4.203  1.00 37.41           H  
ATOM    351  N   ASN    23      14.167   3.000  -5.096  1.00 64.32           N  
ATOM    352  CA  ASN    23      15.101   2.174  -5.885  1.00 13.20           C  
ATOM    353  C   ASN    23      14.403   0.985  -6.576  1.00 64.53           C  
ATOM    354  O   ASN    23      15.057   0.162  -7.218  1.00  4.43           O  
ATOM    355  CB  ASN    23      16.222   1.642  -4.984  1.00  5.33           C  
ATOM    356  CG  ASN    23      15.692   0.766  -3.862  1.00 25.22           C  
ATOM    357  OD1 ASN    23      15.512  -0.435  -4.025  1.00 20.42           O  
ATOM    358  ND2 ASN    23      15.436   1.361  -2.714  1.00 32.25           N  
ATOM    359  H   ASN    23      14.195   2.951  -4.116  1.00 37.41           H  
ATOM    360  HA  ASN    23      15.538   2.805  -6.645  1.00 42.31           H  
ATOM    361  HB2 ASN    23      16.909   1.057  -5.580  1.00 37.41           H  
ATOM    362  HB3 ASN    23      16.754   2.477  -4.550  1.00 37.41           H  
ATOM    363 HD21 ASN    23      15.594   2.326  -2.643  1.00 37.41           H  
ATOM    364 HD22 ASN    23      15.105   0.811  -1.974  1.00 37.41           H  
ATOM    365  N   GLY    24      13.081   0.900  -6.452  1.00 13.42           N  
ATOM    366  CA  GLY    24      12.345  -0.253  -6.968  1.00 11.14           C  
ATOM    367  C   GLY    24      11.843  -1.172  -5.857  1.00 21.53           C  
ATOM    368  O   GLY    24      10.939  -1.981  -6.068  1.00 12.42           O  
ATOM    369  H   GLY    24      12.597   1.636  -6.028  1.00 37.41           H  
ATOM    370  HA2 GLY    24      11.496   0.104  -7.533  1.00 37.41           H  
ATOM    371  HA3 GLY    24      12.987  -0.822  -7.628  1.00 37.41           H  
ATOM    372  N   GLU    25      12.440  -1.042  -4.675  1.00 54.13           N  
ATOM    373  CA  GLU    25      12.017  -1.788  -3.482  1.00  3.13           C  
ATOM    374  C   GLU    25      10.554  -1.474  -3.113  1.00 52.25           C  
ATOM    375  O   GLU    25      10.193  -0.313  -2.913  1.00 55.42           O  
ATOM    376  CB  GLU    25      12.945  -1.435  -2.311  1.00  1.11           C  
ATOM    377  CG  GLU    25      12.583  -2.096  -0.987  1.00 25.03           C  
ATOM    378  CD  GLU    25      13.518  -1.679   0.136  1.00  2.32           C  
ATOM    379  OE1 GLU    25      13.394  -0.538   0.625  1.00 33.43           O  
ATOM    380  OE2 GLU    25      14.398  -2.480   0.521  1.00  5.43           O  
ATOM    381  H   GLU    25      13.201  -0.430  -4.600  1.00 37.41           H  
ATOM    382  HA  GLU    25      12.108  -2.843  -3.697  1.00 33.42           H  
ATOM    383  HB2 GLU    25      13.952  -1.731  -2.569  1.00 37.41           H  
ATOM    384  HB3 GLU    25      12.927  -0.361  -2.168  1.00 37.41           H  
ATOM    385  HG2 GLU    25      11.573  -1.816  -0.721  1.00 37.41           H  
ATOM    386  HG3 GLU    25      12.637  -3.170  -1.106  1.00 37.41           H  
ATOM    387  N   VAL    26       9.719  -2.509  -3.029  1.00 55.41           N  
ATOM    388  CA  VAL    26       8.293  -2.340  -2.714  1.00 44.33           C  
ATOM    389  C   VAL    26       8.057  -2.237  -1.197  1.00 35.44           C  
ATOM    390  O   VAL    26       8.505  -3.089  -0.430  1.00 45.23           O  
ATOM    391  CB  VAL    26       7.450  -3.517  -3.277  1.00 24.14           C  
ATOM    392  CG1 VAL    26       5.963  -3.324  -2.972  1.00 40.43           C  
ATOM    393  CG2 VAL    26       7.683  -3.679  -4.781  1.00 75.21           C  
ATOM    394  H   VAL    26      10.068  -3.414  -3.178  1.00 37.41           H  
ATOM    395  HA  VAL    26       7.954  -1.427  -3.185  1.00 33.13           H  
ATOM    396  HB  VAL    26       7.775  -4.426  -2.788  1.00 11.33           H  
ATOM    397 HG11 VAL    26       5.401  -4.152  -3.378  1.00 37.41           H  
ATOM    398 HG12 VAL    26       5.616  -2.402  -3.420  1.00 37.41           H  
ATOM    399 HG13 VAL    26       5.816  -3.281  -1.903  1.00 37.41           H  
ATOM    400 HG21 VAL    26       8.738  -3.827  -4.969  1.00 37.41           H  
ATOM    401 HG22 VAL    26       7.349  -2.791  -5.299  1.00 37.41           H  
ATOM    402 HG23 VAL    26       7.133  -4.535  -5.142  1.00 37.41           H  
ATOM    403  N   ILE    27       7.346  -1.191  -0.773  1.00  4.41           N  
ATOM    404  CA  ILE    27       7.030  -0.986   0.647  1.00  4.54           C  
ATOM    405  C   ILE    27       5.568  -1.348   0.975  1.00  3.14           C  
ATOM    406  O   ILE    27       5.275  -1.837   2.064  1.00 23.10           O  
ATOM    407  CB  ILE    27       7.318   0.477   1.088  1.00 42.43           C  
ATOM    408  CG1 ILE    27       6.607   1.478   0.157  1.00 33.30           C  
ATOM    409  CG2 ILE    27       8.823   0.740   1.129  1.00 23.50           C  
ATOM    410  CD1 ILE    27       6.893   2.933   0.474  1.00 42.13           C  
ATOM    411  H   ILE    27       7.027  -0.540  -1.431  1.00 37.41           H  
ATOM    412  HA  ILE    27       7.677  -1.639   1.224  1.00 11.11           H  
ATOM    413  HB  ILE    27       6.937   0.603   2.092  1.00 11.11           H  
ATOM    414 HG12 ILE    27       6.919   1.298  -0.862  1.00 37.41           H  
ATOM    415 HG13 ILE    27       5.538   1.329   0.228  1.00 37.41           H  
ATOM    416 HG21 ILE    27       9.236   0.637   0.137  1.00 37.41           H  
ATOM    417 HG22 ILE    27       9.296   0.029   1.791  1.00 37.41           H  
ATOM    418 HG23 ILE    27       9.003   1.742   1.492  1.00 37.41           H  
ATOM    419 HD11 ILE    27       7.949   3.129   0.359  1.00 37.41           H  
ATOM    420 HD12 ILE    27       6.595   3.151   1.491  1.00 37.41           H  
ATOM    421 HD13 ILE    27       6.337   3.563  -0.205  1.00 37.41           H  
ATOM    422  N   LEU    28       4.654  -1.107   0.029  1.00  4.22           N  
ATOM    423  CA  LEU    28       3.226  -1.431   0.210  1.00 60.34           C  
ATOM    424  C   LEU    28       2.710  -2.337  -0.916  1.00 13.24           C  
ATOM    425  O   LEU    28       2.926  -2.061  -2.095  1.00 51.11           O  
ATOM    426  CB  LEU    28       2.365  -0.148   0.265  1.00 13.32           C  
ATOM    427  CG  LEU    28       2.170   0.493   1.654  1.00  1.30           C  
ATOM    428  CD1 LEU    28       1.429  -0.455   2.592  1.00 51.54           C  
ATOM    429  CD2 LEU    28       3.503   0.911   2.258  1.00 11.51           C  
ATOM    430  H   LEU    28       4.943  -0.701  -0.816  1.00 37.41           H  
ATOM    431  HA  LEU    28       3.123  -1.959   1.150  1.00 32.34           H  
ATOM    432  HB2 LEU    28       2.821   0.588  -0.381  1.00 37.41           H  
ATOM    433  HB3 LEU    28       1.384  -0.381  -0.133  1.00 37.41           H  
ATOM    434  HG  LEU    28       1.565   1.381   1.544  1.00 21.42           H  
ATOM    435 HD11 LEU    28       0.466  -0.702   2.169  1.00 37.41           H  
ATOM    436 HD12 LEU    28       1.288   0.023   3.552  1.00 37.41           H  
ATOM    437 HD13 LEU    28       2.006  -1.358   2.725  1.00 37.41           H  
ATOM    438 HD21 LEU    28       4.121   0.040   2.408  1.00 37.41           H  
ATOM    439 HD22 LEU    28       3.333   1.397   3.207  1.00 37.41           H  
ATOM    440 HD23 LEU    28       4.005   1.595   1.589  1.00 37.41           H  
ATOM    441  N   THR    29       2.027  -3.415  -0.540  1.00 42.25           N  
ATOM    442  CA  THR    29       1.398  -4.329  -1.505  1.00  3.53           C  
ATOM    443  C   THR    29      -0.089  -4.530  -1.181  1.00 50.11           C  
ATOM    444  O   THR    29      -0.436  -5.182  -0.195  1.00  2.20           O  
ATOM    445  CB  THR    29       2.089  -5.715  -1.513  1.00  3.43           C  
ATOM    446  OG1 THR    29       3.497  -5.570  -1.777  1.00 62.22           O  
ATOM    447  CG2 THR    29       1.467  -6.643  -2.559  1.00 43.44           C  
ATOM    448  H   THR    29       1.947  -3.611   0.416  1.00 37.41           H  
ATOM    449  HA  THR    29       1.489  -3.897  -2.495  1.00 31.01           H  
ATOM    450  HB  THR    29       1.965  -6.167  -0.537  1.00 62.51           H  
ATOM    451  HG1 THR    29       3.867  -4.912  -1.174  1.00 71.20           H  
ATOM    452 HG21 THR    29       0.423  -6.800  -2.327  1.00 37.41           H  
ATOM    453 HG22 THR    29       1.983  -7.592  -2.552  1.00 37.41           H  
ATOM    454 HG23 THR    29       1.555  -6.194  -3.538  1.00 37.41           H  
ATOM    455  N   SER    30      -0.966  -3.964  -2.002  1.00 12.02           N  
ATOM    456  CA  SER    30      -2.415  -4.109  -1.802  1.00 32.42           C  
ATOM    457  C   SER    30      -2.917  -5.478  -2.279  1.00 71.31           C  
ATOM    458  O   SER    30      -2.366  -6.063  -3.210  1.00 12.20           O  
ATOM    459  CB  SER    30      -3.166  -2.992  -2.529  1.00 40.31           C  
ATOM    460  OG  SER    30      -2.809  -1.723  -2.009  1.00 75.03           O  
ATOM    461  H   SER    30      -0.637  -3.433  -2.762  1.00 37.41           H  
ATOM    462  HA  SER    30      -2.609  -4.024  -0.740  1.00 24.21           H  
ATOM    463  HB2 SER    30      -2.917  -3.016  -3.581  1.00 37.41           H  
ATOM    464  HB3 SER    30      -4.230  -3.132  -2.406  1.00 37.41           H  
ATOM    465  HG  SER    30      -3.596  -1.280  -1.671  1.00 71.43           H  
ATOM    466  N   GLU    31      -3.971  -5.977  -1.634  1.00 73.33           N  
ATOM    467  CA  GLU    31      -4.517  -7.305  -1.944  1.00  3.32           C  
ATOM    468  C   GLU    31      -5.400  -7.270  -3.211  1.00 40.31           C  
ATOM    469  O   GLU    31      -5.730  -6.200  -3.721  1.00 52.34           O  
ATOM    470  CB  GLU    31      -5.301  -7.835  -0.729  1.00 60.41           C  
ATOM    471  CG  GLU    31      -5.616  -9.328  -0.785  1.00 21.24           C  
ATOM    472  CD  GLU    31      -6.150  -9.867   0.533  1.00 21.13           C  
ATOM    473  OE1 GLU    31      -5.332 -10.197   1.419  1.00 42.33           O  
ATOM    474  OE2 GLU    31      -7.384  -9.967   0.691  1.00 53.31           O  
ATOM    475  H   GLU    31      -4.396  -5.440  -0.936  1.00 37.41           H  
ATOM    476  HA  GLU    31      -3.681  -7.966  -2.130  1.00 12.32           H  
ATOM    477  HB2 GLU    31      -4.719  -7.649   0.163  1.00 37.41           H  
ATOM    478  HB3 GLU    31      -6.235  -7.293  -0.653  1.00 37.41           H  
ATOM    479  HG2 GLU    31      -6.357  -9.497  -1.555  1.00 37.41           H  
ATOM    480  HG3 GLU    31      -4.713  -9.865  -1.038  1.00 37.41           H  
ATOM    481  N   LEU    32      -5.778  -8.448  -3.709  1.00 31.41           N  
ATOM    482  CA  LEU    32      -6.494  -8.574  -4.988  1.00 40.14           C  
ATOM    483  C   LEU    32      -7.866  -7.870  -5.000  1.00 75.44           C  
ATOM    484  O   LEU    32      -8.808  -8.295  -4.327  1.00 53.22           O  
ATOM    485  CB  LEU    32      -6.674 -10.060  -5.335  1.00 14.41           C  
ATOM    486  CG  LEU    32      -5.371 -10.842  -5.569  1.00 55.35           C  
ATOM    487  CD1 LEU    32      -5.662 -12.309  -5.881  1.00 43.45           C  
ATOM    488  CD2 LEU    32      -4.552 -10.204  -6.689  1.00 22.01           C  
ATOM    489  H   LEU    32      -5.565  -9.259  -3.210  1.00 37.41           H  
ATOM    490  HA  LEU    32      -5.873  -8.122  -5.748  1.00 11.12           H  
ATOM    491  HB2 LEU    32      -7.213 -10.533  -4.525  1.00 37.41           H  
ATOM    492  HB3 LEU    32      -7.275 -10.130  -6.231  1.00 37.41           H  
ATOM    493  HG  LEU    32      -4.779 -10.810  -4.665  1.00 11.42           H  
ATOM    494 HD11 LEU    32      -6.278 -12.376  -6.768  1.00 37.41           H  
ATOM    495 HD12 LEU    32      -6.182 -12.758  -5.048  1.00 37.41           H  
ATOM    496 HD13 LEU    32      -4.733 -12.834  -6.048  1.00 37.41           H  
ATOM    497 HD21 LEU    32      -3.639 -10.763  -6.829  1.00 37.41           H  
ATOM    498 HD22 LEU    32      -4.311  -9.185  -6.426  1.00 37.41           H  
ATOM    499 HD23 LEU    32      -5.123 -10.214  -7.606  1.00 37.41           H  
ATOM    500  N   TYR    33      -7.965  -6.790  -5.775  1.00 11.35           N  
ATOM    501  CA  TYR    33      -9.249  -6.138  -6.051  1.00 11.52           C  
ATOM    502  C   TYR    33      -9.951  -6.803  -7.244  1.00 23.01           C  
ATOM    503  O   TYR    33      -9.325  -7.082  -8.265  1.00 43.55           O  
ATOM    504  CB  TYR    33      -9.043  -4.646  -6.357  1.00 50.44           C  
ATOM    505  CG  TYR    33      -8.682  -3.799  -5.149  1.00 53.22           C  
ATOM    506  CD1 TYR    33      -7.393  -3.804  -4.627  1.00 25.22           C  
ATOM    507  CD2 TYR    33      -9.634  -2.992  -4.534  1.00 32.12           C  
ATOM    508  CE1 TYR    33      -7.065  -3.030  -3.529  1.00 54.14           C  
ATOM    509  CE2 TYR    33      -9.312  -2.216  -3.437  1.00  5.53           C  
ATOM    510  CZ  TYR    33      -8.029  -2.239  -2.939  1.00 72.32           C  
ATOM    511  OH  TYR    33      -7.713  -1.471  -1.839  1.00 32.34           O  
ATOM    512  H   TYR    33      -7.147  -6.415  -6.167  1.00 37.41           H  
ATOM    513  HA  TYR    33      -9.875  -6.236  -5.174  1.00 51.34           H  
ATOM    514  HB2 TYR    33      -8.246  -4.543  -7.080  1.00 37.41           H  
ATOM    515  HB3 TYR    33      -9.954  -4.247  -6.783  1.00 37.41           H  
ATOM    516  HD1 TYR    33      -6.640  -4.426  -5.091  1.00 54.13           H  
ATOM    517  HD2 TYR    33     -10.641  -2.976  -4.925  1.00 75.03           H  
ATOM    518  HE1 TYR    33      -6.057  -3.047  -3.139  1.00 13.12           H  
ATOM    519  HE2 TYR    33     -10.066  -1.596  -2.976  1.00 52.15           H  
ATOM    520  HH  TYR    33      -6.843  -1.077  -1.960  1.00 61.43           H  
ATOM    521  N   THR    34     -11.253  -7.044  -7.126  1.00 23.34           N  
ATOM    522  CA  THR    34     -12.024  -7.667  -8.217  1.00  0.23           C  
ATOM    523  C   THR    34     -12.409  -6.652  -9.305  1.00 51.22           C  
ATOM    524  O   THR    34     -13.006  -7.010 -10.319  1.00 71.32           O  
ATOM    525  CB  THR    34     -13.311  -8.338  -7.688  1.00 34.04           C  
ATOM    526  OG1 THR    34     -14.136  -7.365  -7.029  1.00 52.13           O  
ATOM    527  CG2 THR    34     -12.980  -9.470  -6.719  1.00 45.25           C  
ATOM    528  H   THR    34     -11.710  -6.807  -6.291  1.00 37.41           H  
ATOM    529  HA  THR    34     -11.406  -8.433  -8.663  1.00 53.15           H  
ATOM    530  HB  THR    34     -13.856  -8.750  -8.526  1.00 11.22           H  
ATOM    531  HG1 THR    34     -14.964  -7.264  -7.518  1.00 54.02           H  
ATOM    532 HG21 THR    34     -13.896  -9.921  -6.365  1.00 37.41           H  
ATOM    533 HG22 THR    34     -12.426  -9.076  -5.879  1.00 37.41           H  
ATOM    534 HG23 THR    34     -12.384 -10.216  -7.225  1.00 37.41           H  
ATOM    535  N   GLY    35     -12.063  -5.386  -9.087  1.00 32.43           N  
ATOM    536  CA  GLY    35     -12.350  -4.339 -10.064  1.00 11.33           C  
ATOM    537  C   GLY    35     -11.308  -3.223 -10.037  1.00  4.14           C  
ATOM    538  O   GLY    35     -10.841  -2.834  -8.963  1.00  4.34           O  
ATOM    539  H   GLY    35     -11.606  -5.156  -8.253  1.00 37.41           H  
ATOM    540  HA2 GLY    35     -12.372  -4.774 -11.052  1.00 37.41           H  
ATOM    541  HA3 GLY    35     -13.319  -3.918  -9.847  1.00 37.41           H  
ATOM    542  N   LYS    36     -10.949  -2.697 -11.208  1.00 34.30           N  
ATOM    543  CA  LYS    36      -9.908  -1.662 -11.301  1.00 51.21           C  
ATOM    544  C   LYS    36     -10.348  -0.358 -10.615  1.00 14.33           C  
ATOM    545  O   LYS    36      -9.536   0.323  -9.991  1.00 14.21           O  
ATOM    546  CB  LYS    36      -9.538  -1.392 -12.767  1.00 64.03           C  
ATOM    547  CG  LYS    36      -8.450  -0.329 -12.934  1.00  4.43           C  
ATOM    548  CD  LYS    36      -7.999  -0.180 -14.384  1.00 75.05           C  
ATOM    549  CE  LYS    36      -7.329  -1.447 -14.907  1.00 30.43           C  
ATOM    550  NZ  LYS    36      -6.824  -1.274 -16.294  1.00 15.40           N  
ATOM    551  H   LYS    36     -11.399  -2.997 -12.026  1.00 37.41           H  
ATOM    552  HA  LYS    36      -9.034  -2.040 -10.788  1.00 74.12           H  
ATOM    553  HB2 LYS    36      -9.188  -2.313 -13.213  1.00 37.41           H  
ATOM    554  HB3 LYS    36     -10.421  -1.060 -13.295  1.00 37.41           H  
ATOM    555  HG2 LYS    36      -8.839   0.620 -12.593  1.00 37.41           H  
ATOM    556  HG3 LYS    36      -7.597  -0.602 -12.327  1.00 37.41           H  
ATOM    557  HD2 LYS    36      -8.861   0.037 -14.998  1.00 37.41           H  
ATOM    558  HD3 LYS    36      -7.297   0.641 -14.448  1.00 37.41           H  
ATOM    559  HE2 LYS    36      -6.500  -1.696 -14.262  1.00 37.41           H  
ATOM    560  HE3 LYS    36      -8.049  -2.252 -14.894  1.00 37.41           H  
ATOM    561  HZ1 LYS    36      -6.090  -0.537 -16.322  1.00 37.41           H  
ATOM    562  HZ2 LYS    36      -7.605  -0.997 -16.924  1.00 37.41           H  
ATOM    563  HZ3 LYS    36      -6.413  -2.166 -16.637  1.00 37.41           H  
ATOM    564  N   SER    37     -11.637  -0.030 -10.725  1.00 24.11           N  
ATOM    565  CA  SER    37     -12.206   1.158 -10.064  1.00 42.53           C  
ATOM    566  C   SER    37     -11.841   1.196  -8.573  1.00  4.25           C  
ATOM    567  O   SER    37     -11.376   2.213  -8.064  1.00 74.34           O  
ATOM    568  CB  SER    37     -13.737   1.184 -10.222  1.00 65.24           C  
ATOM    569  OG  SER    37     -14.322   2.265  -9.504  1.00 74.54           O  
ATOM    570  H   SER    37     -12.221  -0.594 -11.276  1.00 37.41           H  
ATOM    571  HA  SER    37     -11.790   2.033 -10.546  1.00 22.04           H  
ATOM    572  HB2 SER    37     -13.988   1.292 -11.268  1.00 37.41           H  
ATOM    573  HB3 SER    37     -14.152   0.258  -9.851  1.00 37.41           H  
ATOM    574  HG  SER    37     -13.892   3.093  -9.764  1.00  1.20           H  
ATOM    575  N   GLY    38     -12.040   0.071  -7.881  1.00  5.13           N  
ATOM    576  CA  GLY    38     -11.691  -0.019  -6.465  1.00 65.42           C  
ATOM    577  C   GLY    38     -10.193   0.119  -6.202  1.00 20.51           C  
ATOM    578  O   GLY    38      -9.782   0.729  -5.212  1.00 35.31           O  
ATOM    579  H   GLY    38     -12.434  -0.701  -8.334  1.00 37.41           H  
ATOM    580  HA2 GLY    38     -12.210   0.762  -5.929  1.00 37.41           H  
ATOM    581  HA3 GLY    38     -12.021  -0.977  -6.089  1.00 37.41           H  
ATOM    582  N   ALA    39      -9.375  -0.451  -7.084  1.00 14.51           N  
ATOM    583  CA  ALA    39      -7.916  -0.366  -6.955  1.00  2.15           C  
ATOM    584  C   ALA    39      -7.414   1.079  -7.131  1.00 43.23           C  
ATOM    585  O   ALA    39      -6.716   1.617  -6.269  1.00 65.03           O  
ATOM    586  CB  ALA    39      -7.246  -1.290  -7.966  1.00 22.11           C  
ATOM    587  H   ALA    39      -9.761  -0.943  -7.840  1.00 37.41           H  
ATOM    588  HA  ALA    39      -7.651  -0.706  -5.963  1.00 55.24           H  
ATOM    589  HB1 ALA    39      -7.593  -2.301  -7.816  1.00 37.41           H  
ATOM    590  HB2 ALA    39      -6.173  -1.255  -7.833  1.00 37.41           H  
ATOM    591  HB3 ALA    39      -7.492  -0.971  -8.970  1.00 37.41           H  
ATOM    592  N   MET    40      -7.786   1.701  -8.247  1.00  3.10           N  
ATOM    593  CA  MET    40      -7.380   3.081  -8.541  1.00 23.33           C  
ATOM    594  C   MET    40      -7.929   4.060  -7.491  1.00 42.24           C  
ATOM    595  O   MET    40      -7.181   4.866  -6.930  1.00 12.52           O  
ATOM    596  CB  MET    40      -7.850   3.485  -9.942  1.00 43.41           C  
ATOM    597  CG  MET    40      -7.287   2.606 -11.050  1.00 13.52           C  
ATOM    598  SD  MET    40      -5.482   2.610 -11.093  1.00 32.52           S  
ATOM    599  CE  MET    40      -5.155   4.329 -11.473  1.00 52.20           C  
ATOM    600  H   MET    40      -8.347   1.222  -8.892  1.00 37.41           H  
ATOM    601  HA  MET    40      -6.300   3.117  -8.513  1.00 73.45           H  
ATOM    602  HB2 MET    40      -8.930   3.426  -9.979  1.00 37.41           H  
ATOM    603  HB3 MET    40      -7.548   4.505 -10.132  1.00 37.41           H  
ATOM    604  HG2 MET    40      -7.627   1.592 -10.894  1.00 37.41           H  
ATOM    605  HG3 MET    40      -7.658   2.964 -12.000  1.00 37.41           H  
ATOM    606  HE1 MET    40      -5.544   4.955 -10.683  1.00 37.41           H  
ATOM    607  HE2 MET    40      -5.633   4.590 -12.407  1.00 37.41           H  
ATOM    608  HE3 MET    40      -4.089   4.482 -11.560  1.00 37.41           H  
ATOM    609  N   ASN    41      -9.235   3.982  -7.223  1.00 54.43           N  
ATOM    610  CA  ASN    41      -9.854   4.788  -6.164  1.00 55.45           C  
ATOM    611  C   ASN    41      -9.162   4.529  -4.817  1.00 34.44           C  
ATOM    612  O   ASN    41      -9.037   5.428  -3.983  1.00  2.44           O  
ATOM    613  CB  ASN    41     -11.353   4.477  -6.067  1.00 74.23           C  
ATOM    614  CG  ASN    41     -12.070   5.347  -5.048  1.00 64.35           C  
ATOM    615  OD1 ASN    41     -12.499   6.456  -5.352  1.00 42.11           O  
ATOM    616  ND2 ASN    41     -12.216   4.850  -3.835  1.00 53.21           N  
ATOM    617  H   ASN    41      -9.797   3.376  -7.756  1.00 37.41           H  
ATOM    618  HA  ASN    41      -9.726   5.831  -6.426  1.00 43.51           H  
ATOM    619  HB2 ASN    41     -11.811   4.637  -7.032  1.00 37.41           H  
ATOM    620  HB3 ASN    41     -11.482   3.442  -5.784  1.00 37.41           H  
ATOM    621 HD21 ASN    41     -11.856   3.955  -3.653  1.00 37.41           H  
ATOM    622 HD22 ASN    41     -12.684   5.392  -3.169  1.00 37.41           H  
ATOM    623  N   GLY    42      -8.703   3.292  -4.623  1.00 72.21           N  
ATOM    624  CA  GLY    42      -7.892   2.966  -3.460  1.00 21.21           C  
ATOM    625  C   GLY    42      -6.599   3.775  -3.407  1.00 52.31           C  
ATOM    626  O   GLY    42      -6.209   4.261  -2.346  1.00 32.41           O  
ATOM    627  H   GLY    42      -8.924   2.590  -5.273  1.00 37.41           H  
ATOM    628  HA2 GLY    42      -8.468   3.161  -2.565  1.00 37.41           H  
ATOM    629  HA3 GLY    42      -7.644   1.915  -3.494  1.00 37.41           H  
ATOM    630  N   ILE    43      -5.946   3.944  -4.562  1.00 11.41           N  
ATOM    631  CA  ILE    43      -4.716   4.744  -4.647  1.00 54.22           C  
ATOM    632  C   ILE    43      -4.993   6.213  -4.287  1.00 64.31           C  
ATOM    633  O   ILE    43      -4.294   6.809  -3.465  1.00 51.11           O  
ATOM    634  CB  ILE    43      -4.089   4.680  -6.067  1.00 51.41           C  
ATOM    635  CG1 ILE    43      -3.778   3.224  -6.457  1.00 75.32           C  
ATOM    636  CG2 ILE    43      -2.826   5.540  -6.136  1.00 72.23           C  
ATOM    637  CD1 ILE    43      -3.219   3.066  -7.857  1.00 23.24           C  
ATOM    638  H   ILE    43      -6.306   3.531  -5.378  1.00 37.41           H  
ATOM    639  HA  ILE    43      -4.005   4.338  -3.940  1.00 25.12           H  
ATOM    640  HB  ILE    43      -4.804   5.086  -6.769  1.00  3.44           H  
ATOM    641 HG12 ILE    43      -3.053   2.817  -5.767  1.00 37.41           H  
ATOM    642 HG13 ILE    43      -4.688   2.642  -6.397  1.00 37.41           H  
ATOM    643 HG21 ILE    43      -3.074   6.568  -5.907  1.00 37.41           H  
ATOM    644 HG22 ILE    43      -2.403   5.486  -7.128  1.00 37.41           H  
ATOM    645 HG23 ILE    43      -2.102   5.178  -5.418  1.00 37.41           H  
ATOM    646 HD11 ILE    43      -2.285   3.604  -7.936  1.00 37.41           H  
ATOM    647 HD12 ILE    43      -3.924   3.461  -8.573  1.00 37.41           H  
ATOM    648 HD13 ILE    43      -3.049   2.019  -8.060  1.00 37.41           H  
ATOM    649  N   GLU    44      -6.028   6.785  -4.900  1.00 42.02           N  
ATOM    650  CA  GLU    44      -6.435   8.163  -4.607  1.00 44.20           C  
ATOM    651  C   GLU    44      -6.822   8.313  -3.125  1.00  2.01           C  
ATOM    652  O   GLU    44      -6.565   9.348  -2.500  1.00 34.34           O  
ATOM    653  CB  GLU    44      -7.601   8.575  -5.518  1.00 34.11           C  
ATOM    654  CG  GLU    44      -7.288   8.430  -7.007  1.00 35.01           C  
ATOM    655  CD  GLU    44      -8.408   8.934  -7.906  1.00  4.40           C  
ATOM    656  OE1 GLU    44      -9.376   8.180  -8.143  1.00 31.35           O  
ATOM    657  OE2 GLU    44      -8.320  10.084  -8.388  1.00 62.22           O  
ATOM    658  H   GLU    44      -6.532   6.269  -5.567  1.00 37.41           H  
ATOM    659  HA  GLU    44      -5.590   8.806  -4.810  1.00 63.15           H  
ATOM    660  HB2 GLU    44      -8.458   7.956  -5.288  1.00 37.41           H  
ATOM    661  HB3 GLU    44      -7.850   9.608  -5.321  1.00 37.41           H  
ATOM    662  HG2 GLU    44      -6.389   8.987  -7.227  1.00 37.41           H  
ATOM    663  HG3 GLU    44      -7.118   7.383  -7.220  1.00 37.41           H  
ATOM    664  N   SER    45      -7.431   7.267  -2.566  1.00 71.45           N  
ATOM    665  CA  SER    45      -7.729   7.223  -1.129  1.00 64.43           C  
ATOM    666  C   SER    45      -6.431   7.303  -0.315  1.00 65.20           C  
ATOM    667  O   SER    45      -6.324   8.094   0.620  1.00  1.10           O  
ATOM    668  CB  SER    45      -8.501   5.943  -0.769  1.00 20.41           C  
ATOM    669  OG  SER    45      -8.892   5.931   0.598  1.00 73.31           O  
ATOM    670  H   SER    45      -7.690   6.509  -3.131  1.00 37.41           H  
ATOM    671  HA  SER    45      -8.342   8.082  -0.891  1.00  1.13           H  
ATOM    672  HB2 SER    45      -9.387   5.876  -1.383  1.00 37.41           H  
ATOM    673  HB3 SER    45      -7.873   5.081  -0.956  1.00 37.41           H  
ATOM    674  HG  SER    45      -9.836   5.743   0.653  1.00 53.44           H  
ATOM    675  N   VAL    46      -5.434   6.494  -0.694  1.00 74.53           N  
ATOM    676  CA  VAL    46      -4.112   6.532  -0.050  1.00 11.12           C  
ATOM    677  C   VAL    46      -3.501   7.945  -0.102  1.00 70.22           C  
ATOM    678  O   VAL    46      -2.893   8.401   0.865  1.00 14.22           O  
ATOM    679  CB  VAL    46      -3.124   5.524  -0.701  1.00 73.43           C  
ATOM    680  CG1 VAL    46      -1.738   5.622  -0.063  1.00 33.41           C  
ATOM    681  CG2 VAL    46      -3.657   4.095  -0.600  1.00 62.22           C  
ATOM    682  H   VAL    46      -5.590   5.855  -1.422  1.00 37.41           H  
ATOM    683  HA  VAL    46      -4.244   6.251   0.987  1.00 62.22           H  
ATOM    684  HB  VAL    46      -3.028   5.773  -1.751  1.00  4.22           H  
ATOM    685 HG11 VAL    46      -1.332   6.610  -0.227  1.00 37.41           H  
ATOM    686 HG12 VAL    46      -1.082   4.887  -0.508  1.00 37.41           H  
ATOM    687 HG13 VAL    46      -1.816   5.437   0.999  1.00 37.41           H  
ATOM    688 HG21 VAL    46      -3.758   3.819   0.441  1.00 37.41           H  
ATOM    689 HG22 VAL    46      -2.970   3.416  -1.086  1.00 37.41           H  
ATOM    690 HG23 VAL    46      -4.622   4.034  -1.081  1.00 37.41           H  
ATOM    691  N   GLN    47      -3.678   8.636  -1.229  1.00 30.23           N  
ATOM    692  CA  GLN    47      -3.191  10.017  -1.383  1.00 64.14           C  
ATOM    693  C   GLN    47      -3.807  10.953  -0.324  1.00 44.51           C  
ATOM    694  O   GLN    47      -3.102  11.757   0.290  1.00  0.02           O  
ATOM    695  CB  GLN    47      -3.496  10.537  -2.801  1.00 41.10           C  
ATOM    696  CG  GLN    47      -2.785   9.760  -3.907  1.00 73.03           C  
ATOM    697  CD  GLN    47      -3.121  10.267  -5.302  1.00 65.41           C  
ATOM    698  OE1 GLN    47      -4.214  10.765  -5.555  1.00 11.23           O  
ATOM    699  NE2 GLN    47      -2.184  10.153  -6.220  1.00 25.01           N  
ATOM    700  H   GLN    47      -4.141   8.207  -1.980  1.00 37.41           H  
ATOM    701  HA  GLN    47      -2.119  10.002  -1.244  1.00 60.45           H  
ATOM    702  HB2 GLN    47      -4.562  10.475  -2.975  1.00 37.41           H  
ATOM    703  HB3 GLN    47      -3.191  11.572  -2.867  1.00 37.41           H  
ATOM    704  HG2 GLN    47      -1.717   9.842  -3.760  1.00 37.41           H  
ATOM    705  HG3 GLN    47      -3.075   8.721  -3.842  1.00 37.41           H  
ATOM    706 HE21 GLN    47      -1.327   9.753  -5.962  1.00 37.41           H  
ATOM    707 HE22 GLN    47      -2.384  10.471  -7.122  1.00 37.41           H  
ATOM    708  N   THR    48      -5.118  10.835  -0.104  1.00 62.12           N  
ATOM    709  CA  THR    48      -5.808  11.628   0.934  1.00 52.31           C  
ATOM    710  C   THR    48      -5.457  11.143   2.351  1.00 45.00           C  
ATOM    711  O   THR    48      -5.382  11.935   3.290  1.00 12.34           O  
ATOM    712  CB  THR    48      -7.347  11.585   0.756  1.00 31.54           C  
ATOM    713  OG1 THR    48      -7.705  12.112  -0.530  1.00 41.12           O  
ATOM    714  CG2 THR    48      -8.066  12.382   1.845  1.00 24.32           C  
ATOM    715  H   THR    48      -5.640  10.209  -0.657  1.00 37.41           H  
ATOM    716  HA  THR    48      -5.487  12.658   0.831  1.00  2.23           H  
ATOM    717  HB  THR    48      -7.671  10.554   0.812  1.00 51.41           H  
ATOM    718  HG1 THR    48      -7.278  12.971  -0.651  1.00 32.15           H  
ATOM    719 HG21 THR    48      -7.766  13.418   1.791  1.00 37.41           H  
ATOM    720 HG22 THR    48      -7.810  11.985   2.817  1.00 37.41           H  
ATOM    721 HG23 THR    48      -9.135  12.310   1.699  1.00 37.41           H  
ATOM    722  N   ASN    49      -5.245   9.839   2.496  1.00 41.45           N  
ATOM    723  CA  ASN    49      -4.900   9.234   3.791  1.00 12.32           C  
ATOM    724  C   ASN    49      -3.433   9.498   4.172  1.00 34.54           C  
ATOM    725  O   ASN    49      -3.088   9.548   5.350  1.00 72.52           O  
ATOM    726  CB  ASN    49      -5.175   7.726   3.753  1.00 32.14           C  
ATOM    727  CG  ASN    49      -6.646   7.410   3.544  1.00 51.32           C  
ATOM    728  OD1 ASN    49      -7.524   8.100   4.048  1.00  4.51           O  
ATOM    729  ND2 ASN    49      -6.927   6.377   2.783  1.00 14.21           N  
ATOM    730  H   ASN    49      -5.328   9.258   1.710  1.00 37.41           H  
ATOM    731  HA  ASN    49      -5.536   9.684   4.542  1.00 40.24           H  
ATOM    732  HB2 ASN    49      -4.611   7.284   2.944  1.00 37.41           H  
ATOM    733  HB3 ASN    49      -4.860   7.283   4.689  1.00 37.41           H  
ATOM    734 HD21 ASN    49      -6.185   5.872   2.403  1.00 37.41           H  
ATOM    735 HD22 ASN    49      -7.868   6.173   2.610  1.00 37.41           H  
ATOM    736  N   SER    50      -2.581   9.658   3.161  1.00 54.03           N  
ATOM    737  CA  SER    50      -1.131   9.866   3.356  1.00 14.11           C  
ATOM    738  C   SER    50      -0.802  10.941   4.421  1.00 44.35           C  
ATOM    739  O   SER    50       0.011  10.692   5.313  1.00 31.31           O  
ATOM    740  CB  SER    50      -0.464  10.223   2.014  1.00 15.02           C  
ATOM    741  OG  SER    50       0.913  10.533   2.172  1.00 20.01           O  
ATOM    742  H   SER    50      -2.933   9.635   2.249  1.00 37.41           H  
ATOM    743  HA  SER    50      -0.725   8.922   3.695  1.00 71.31           H  
ATOM    744  HB2 SER    50      -0.552   9.384   1.339  1.00 37.41           H  
ATOM    745  HB3 SER    50      -0.965  11.079   1.584  1.00 37.41           H  
ATOM    746  HG  SER    50       1.437   9.729   2.070  1.00 12.52           H  
ATOM    747  N   PRO    51      -1.402  12.156   4.354  1.00 52.03           N  
ATOM    748  CA  PRO    51      -1.169  13.199   5.370  1.00  4.43           C  
ATOM    749  C   PRO    51      -1.944  12.952   6.677  1.00 52.32           C  
ATOM    750  O   PRO    51      -1.650  13.558   7.711  1.00 44.31           O  
ATOM    751  CB  PRO    51      -1.670  14.471   4.675  1.00 73.13           C  
ATOM    752  CG  PRO    51      -2.748  13.994   3.764  1.00 43.32           C  
ATOM    753  CD  PRO    51      -2.319  12.627   3.293  1.00 42.13           C  
ATOM    754  HA  PRO    51      -0.116  13.299   5.596  1.00 13.20           H  
ATOM    755  HB2 PRO    51      -2.049  15.171   5.410  1.00 37.41           H  
ATOM    756  HB3 PRO    51      -0.861  14.927   4.123  1.00 37.41           H  
ATOM    757  HG2 PRO    51      -3.684  13.930   4.302  1.00 37.41           H  
ATOM    758  HG3 PRO    51      -2.845  14.667   2.925  1.00 37.41           H  
ATOM    759  HD2 PRO    51      -3.173  11.972   3.205  1.00 37.41           H  
ATOM    760  HD3 PRO    51      -1.803  12.700   2.346  1.00 37.41           H  
ATOM    761  N   ILE    52      -2.934  12.060   6.624  1.00 63.31           N  
ATOM    762  CA  ILE    52      -3.784  11.757   7.784  1.00 50.41           C  
ATOM    763  C   ILE    52      -3.355  10.443   8.462  1.00 25.20           C  
ATOM    764  O   ILE    52      -3.842   9.360   8.129  1.00 63.43           O  
ATOM    765  CB  ILE    52      -5.278  11.668   7.377  1.00 40.10           C  
ATOM    766  CG1 ILE    52      -5.698  12.940   6.620  1.00  0.32           C  
ATOM    767  CG2 ILE    52      -6.164  11.454   8.609  1.00 13.31           C  
ATOM    768  CD1 ILE    52      -7.110  12.896   6.077  1.00 14.20           C  
ATOM    769  H   ILE    52      -3.093  11.580   5.783  1.00 37.41           H  
ATOM    770  HA  ILE    52      -3.676  12.566   8.495  1.00 14.31           H  
ATOM    771  HB  ILE    52      -5.400  10.815   6.724  1.00 21.03           H  
ATOM    772 HG12 ILE    52      -5.629  13.789   7.286  1.00 37.41           H  
ATOM    773 HG13 ILE    52      -5.028  13.093   5.785  1.00 37.41           H  
ATOM    774 HG21 ILE    52      -7.198  11.378   8.302  1.00 37.41           H  
ATOM    775 HG22 ILE    52      -6.052  12.289   9.286  1.00 37.41           H  
ATOM    776 HG23 ILE    52      -5.871  10.544   9.112  1.00 37.41           H  
ATOM    777 HD11 ILE    52      -7.214  12.053   5.411  1.00 37.41           H  
ATOM    778 HD12 ILE    52      -7.315  13.809   5.536  1.00 37.41           H  
ATOM    779 HD13 ILE    52      -7.809  12.800   6.895  1.00 37.41           H  
ATOM    780  N   GLU    53      -2.443  10.555   9.420  1.00 72.33           N  
ATOM    781  CA  GLU    53      -1.867   9.387  10.096  1.00 21.33           C  
ATOM    782  C   GLU    53      -2.934   8.548  10.821  1.00 13.30           C  
ATOM    783  O   GLU    53      -2.792   7.338  10.955  1.00 61.14           O  
ATOM    784  CB  GLU    53      -0.784   9.844  11.084  1.00 51.10           C  
ATOM    785  CG  GLU    53       0.329  10.658  10.428  1.00 41.41           C  
ATOM    786  CD  GLU    53       1.350  11.177  11.426  1.00 31.52           C  
ATOM    787  OE1 GLU    53       1.045  12.161  12.134  1.00  0.22           O  
ATOM    788  OE2 GLU    53       2.465  10.618  11.496  1.00  0.21           O  
ATOM    789  H   GLU    53      -2.141  11.450   9.680  1.00 37.41           H  
ATOM    790  HA  GLU    53      -1.404   8.769   9.339  1.00 44.53           H  
ATOM    791  HB2 GLU    53      -1.244  10.453  11.851  1.00 37.41           H  
ATOM    792  HB3 GLU    53      -0.341   8.974  11.544  1.00 37.41           H  
ATOM    793  HG2 GLU    53       0.836  10.035   9.706  1.00 37.41           H  
ATOM    794  HG3 GLU    53      -0.114  11.504   9.916  1.00 37.41           H  
ATOM    795  N   ALA    54      -4.022   9.183  11.247  1.00 24.34           N  
ATOM    796  CA  ALA    54      -5.102   8.486  11.969  1.00 14.52           C  
ATOM    797  C   ALA    54      -5.685   7.291  11.178  1.00 12.03           C  
ATOM    798  O   ALA    54      -6.469   6.504  11.715  1.00  2.10           O  
ATOM    799  CB  ALA    54      -6.208   9.475  12.319  1.00 10.14           C  
ATOM    800  H   ALA    54      -4.106  10.145  11.077  1.00 37.41           H  
ATOM    801  HA  ALA    54      -4.687   8.113  12.895  1.00 21.34           H  
ATOM    802  HB1 ALA    54      -6.973   8.974  12.895  1.00 37.41           H  
ATOM    803  HB2 ALA    54      -6.642   9.870  11.411  1.00 37.41           H  
ATOM    804  HB3 ALA    54      -5.795  10.285  12.902  1.00 37.41           H  
ATOM    805  N   ARG    55      -5.296   7.162   9.909  1.00 23.25           N  
ATOM    806  CA  ARG    55      -5.814   6.110   9.026  1.00  2.54           C  
ATOM    807  C   ARG    55      -4.950   4.826   9.031  1.00 53.14           C  
ATOM    808  O   ARG    55      -5.335   3.821   8.422  1.00  4.12           O  
ATOM    809  CB  ARG    55      -5.915   6.660   7.594  1.00  4.02           C  
ATOM    810  CG  ARG    55      -6.858   7.855   7.453  1.00 31.02           C  
ATOM    811  CD  ARG    55      -8.317   7.454   7.646  1.00 42.40           C  
ATOM    812  NE  ARG    55      -9.220   8.609   7.648  1.00 62.02           N  
ATOM    813  CZ  ARG    55      -9.855   9.054   6.595  1.00 64.32           C  
ATOM    814  NH1 ARG    55      -9.613   8.568   5.418  1.00 51.52           N  
ATOM    815  NH2 ARG    55     -10.707  10.018   6.710  1.00  4.11           N  
ATOM    816  H   ARG    55      -4.647   7.803   9.547  1.00 37.41           H  
ATOM    817  HA  ARG    55      -6.806   5.852   9.367  1.00 22.42           H  
ATOM    818  HB2 ARG    55      -4.931   6.969   7.270  1.00 37.41           H  
ATOM    819  HB3 ARG    55      -6.266   5.872   6.942  1.00 37.41           H  
ATOM    820  HG2 ARG    55      -6.597   8.596   8.194  1.00 37.41           H  
ATOM    821  HG3 ARG    55      -6.738   8.278   6.465  1.00 37.41           H  
ATOM    822  HD2 ARG    55      -8.603   6.785   6.846  1.00 37.41           H  
ATOM    823  HD3 ARG    55      -8.412   6.937   8.591  1.00 37.41           H  
ATOM    824  HE  ARG    55      -9.383   9.052   8.504  1.00 72.15           H  
ATOM    825 HH11 ARG    55      -8.932   7.849   5.304  1.00 37.41           H  
ATOM    826 HH12 ARG    55     -10.090   8.937   4.622  1.00 37.41           H  
ATOM    827 HH21 ARG    55     -10.872  10.437   7.602  1.00 37.41           H  
ATOM    828 HH22 ARG    55     -11.209  10.336   5.909  1.00 37.41           H  
ATOM    829  N   TYR    56      -3.797   4.843   9.711  1.00 35.41           N  
ATOM    830  CA  TYR    56      -2.880   3.687   9.684  1.00 62.05           C  
ATOM    831  C   TYR    56      -3.367   2.524  10.568  1.00 22.13           C  
ATOM    832  O   TYR    56      -4.337   2.646  11.320  1.00  5.52           O  
ATOM    833  CB  TYR    56      -1.437   4.088  10.092  1.00 63.32           C  
ATOM    834  CG  TYR    56      -1.219   4.439  11.573  1.00 62.22           C  
ATOM    835  CD1 TYR    56      -1.370   3.484  12.580  1.00 51.22           C  
ATOM    836  CD2 TYR    56      -0.851   5.723  11.957  1.00 14.01           C  
ATOM    837  CE1 TYR    56      -1.166   3.802  13.910  1.00 53.41           C  
ATOM    838  CE2 TYR    56      -0.643   6.048  13.285  1.00 42.30           C  
ATOM    839  CZ  TYR    56      -0.806   5.085  14.258  1.00  0.02           C  
ATOM    840  OH  TYR    56      -0.602   5.404  15.582  1.00  0.11           O  
ATOM    841  H   TYR    56      -3.558   5.637  10.234  1.00 37.41           H  
ATOM    842  HA  TYR    56      -2.854   3.333   8.662  1.00  0.43           H  
ATOM    843  HB2 TYR    56      -0.772   3.270   9.857  1.00 37.41           H  
ATOM    844  HB3 TYR    56      -1.144   4.949   9.504  1.00 37.41           H  
ATOM    845  HD1 TYR    56      -1.650   2.476  12.309  1.00 50.32           H  
ATOM    846  HD2 TYR    56      -0.728   6.479  11.196  1.00 34.13           H  
ATOM    847  HE1 TYR    56      -1.292   3.045  14.671  1.00 51.01           H  
ATOM    848  HE2 TYR    56      -0.357   7.055  13.556  1.00 22.30           H  
ATOM    849  HH  TYR    56      -1.043   6.241  15.780  1.00 14.22           H  
ATOM    850  N   ALA    57      -2.675   1.391  10.455  1.00 63.32           N  
ATOM    851  CA  ALA    57      -2.859   0.254  11.362  1.00 25.11           C  
ATOM    852  C   ALA    57      -1.529  -0.491  11.565  1.00 35.11           C  
ATOM    853  O   ALA    57      -1.122  -1.294  10.727  1.00 54.01           O  
ATOM    854  CB  ALA    57      -3.927  -0.689  10.819  1.00 23.24           C  
ATOM    855  H   ALA    57      -2.032   1.307   9.719  1.00 37.41           H  
ATOM    856  HA  ALA    57      -3.197   0.636  12.317  1.00 52.10           H  
ATOM    857  HB1 ALA    57      -3.598  -1.103   9.877  1.00 37.41           H  
ATOM    858  HB2 ALA    57      -4.848  -0.143  10.669  1.00 37.41           H  
ATOM    859  HB3 ALA    57      -4.096  -1.490  11.523  1.00 37.41           H  
ATOM    860  N   LYS    58      -0.855  -0.228  12.680  1.00 61.02           N  
ATOM    861  CA  LYS    58       0.480  -0.794  12.932  1.00 63.12           C  
ATOM    862  C   LYS    58       0.402  -2.075  13.776  1.00 14.20           C  
ATOM    863  O   LYS    58      -0.132  -2.075  14.888  1.00 64.40           O  
ATOM    864  CB  LYS    58       1.371   0.253  13.618  1.00 42.34           C  
ATOM    865  CG  LYS    58       1.675   1.467  12.739  1.00 42.51           C  
ATOM    866  CD  LYS    58       2.283   2.619  13.539  1.00 64.53           C  
ATOM    867  CE  LYS    58       3.613   2.243  14.180  1.00 34.10           C  
ATOM    868  NZ  LYS    58       4.138   3.339  15.033  1.00 51.24           N  
ATOM    869  H   LYS    58      -1.264   0.352  13.358  1.00 37.41           H  
ATOM    870  HA  LYS    58       0.917  -1.043  11.973  1.00  1.11           H  
ATOM    871  HB2 LYS    58       0.875   0.597  14.516  1.00 37.41           H  
ATOM    872  HB3 LYS    58       2.309  -0.210  13.892  1.00 37.41           H  
ATOM    873  HG2 LYS    58       2.374   1.173  11.967  1.00 37.41           H  
ATOM    874  HG3 LYS    58       0.756   1.805  12.279  1.00 37.41           H  
ATOM    875  HD2 LYS    58       2.443   3.457  12.875  1.00 37.41           H  
ATOM    876  HD3 LYS    58       1.589   2.909  14.316  1.00 37.41           H  
ATOM    877  HE2 LYS    58       3.471   1.363  14.790  1.00 37.41           H  
ATOM    878  HE3 LYS    58       4.331   2.030  13.400  1.00 37.41           H  
ATOM    879  HZ1 LYS    58       3.486   3.520  15.827  1.00 37.41           H  
ATOM    880  HZ2 LYS    58       4.241   4.211  14.480  1.00 37.41           H  
ATOM    881  HZ3 LYS    58       5.069   3.079  15.421  1.00 37.41           H  
ATOM    882  N   GLU    59       0.949  -3.169  13.247  1.00 44.24           N  
ATOM    883  CA  GLU    59       0.882  -4.471  13.919  1.00 11.42           C  
ATOM    884  C   GLU    59       2.249  -5.175  13.923  1.00 44.23           C  
ATOM    885  O   GLU    59       3.090  -4.945  13.051  1.00 51.02           O  
ATOM    886  CB  GLU    59      -0.167  -5.358  13.225  1.00 62.32           C  
ATOM    887  CG  GLU    59      -0.394  -6.708  13.903  1.00 71.31           C  
ATOM    888  CD  GLU    59      -0.917  -6.575  15.325  1.00 71.05           C  
ATOM    889  OE1 GLU    59      -2.147  -6.439  15.499  1.00 51.51           O  
ATOM    890  OE2 GLU    59      -0.103  -6.593  16.271  1.00 64.11           O  
ATOM    891  H   GLU    59       1.413  -3.103  12.385  1.00 37.41           H  
ATOM    892  HA  GLU    59       0.577  -4.303  14.942  1.00 22.01           H  
ATOM    893  HB2 GLU    59      -1.109  -4.828  13.205  1.00 37.41           H  
ATOM    894  HB3 GLU    59       0.150  -5.540  12.207  1.00 37.41           H  
ATOM    895  HG2 GLU    59      -1.109  -7.273  13.323  1.00 37.41           H  
ATOM    896  HG3 GLU    59       0.546  -7.245  13.929  1.00 37.41           H  
ATOM    897  N   VAL    60       2.470  -6.027  14.921  1.00 22.32           N  
ATOM    898  CA  VAL    60       3.696  -6.824  15.010  1.00 64.53           C  
ATOM    899  C   VAL    60       3.366  -8.299  15.279  1.00 53.14           C  
ATOM    900  O   VAL    60       2.798  -8.636  16.319  1.00 43.34           O  
ATOM    901  CB  VAL    60       4.643  -6.309  16.126  1.00  2.12           C  
ATOM    902  CG1 VAL    60       5.908  -7.164  16.200  1.00 11.45           C  
ATOM    903  CG2 VAL    60       4.996  -4.836  15.909  1.00 31.41           C  
ATOM    904  H   VAL    60       1.784  -6.130  15.617  1.00 37.41           H  
ATOM    905  HA  VAL    60       4.215  -6.749  14.063  1.00  5.34           H  
ATOM    906  HB  VAL    60       4.126  -6.394  17.073  1.00 53.30           H  
ATOM    907 HG11 VAL    60       5.637  -8.192  16.393  1.00 37.41           H  
ATOM    908 HG12 VAL    60       6.540  -6.805  17.000  1.00 37.41           H  
ATOM    909 HG13 VAL    60       6.444  -7.102  15.264  1.00 37.41           H  
ATOM    910 HG21 VAL    60       5.634  -4.496  16.714  1.00 37.41           H  
ATOM    911 HG22 VAL    60       4.091  -4.247  15.895  1.00 37.41           H  
ATOM    912 HG23 VAL    60       5.515  -4.722  14.968  1.00 37.41           H  
ATOM    913  N   ALA    61       3.723  -9.170  14.340  1.00 74.01           N  
ATOM    914  CA  ALA    61       3.468 -10.608  14.478  1.00 71.43           C  
ATOM    915  C   ALA    61       4.192 -11.201  15.705  1.00 65.35           C  
ATOM    916  O   ALA    61       5.224 -10.684  16.135  1.00 53.45           O  
ATOM    917  CB  ALA    61       3.892 -11.333  13.206  1.00 74.24           C  
ATOM    918  H   ALA    61       4.166  -8.839  13.528  1.00 37.41           H  
ATOM    919  HA  ALA    61       2.402 -10.745  14.602  1.00 31.41           H  
ATOM    920  HB1 ALA    61       3.608 -12.373  13.269  1.00 37.41           H  
ATOM    921  HB2 ALA    61       4.964 -11.260  13.091  1.00 37.41           H  
ATOM    922  HB3 ALA    61       3.409 -10.879  12.353  1.00 37.41           H  
ATOM    923  N   LYS    62       3.656 -12.300  16.248  1.00  4.44           N  
ATOM    924  CA  LYS    62       4.209 -12.923  17.465  1.00 11.40           C  
ATOM    925  C   LYS    62       5.685 -13.343  17.306  1.00 52.00           C  
ATOM    926  O   LYS    62       6.385 -13.549  18.295  1.00 60.32           O  
ATOM    927  CB  LYS    62       3.332 -14.116  17.908  1.00 35.24           C  
ATOM    928  CG  LYS    62       2.962 -15.109  16.797  1.00 32.32           C  
ATOM    929  CD  LYS    62       4.130 -15.996  16.364  1.00 21.23           C  
ATOM    930  CE  LYS    62       4.682 -16.823  17.517  1.00 32.35           C  
ATOM    931  NZ  LYS    62       5.716 -17.788  17.058  1.00 41.43           N  
ATOM    932  H   LYS    62       2.867 -12.701  15.824  1.00 37.41           H  
ATOM    933  HA  LYS    62       4.165 -12.173  18.244  1.00 22.23           H  
ATOM    934  HB2 LYS    62       3.853 -14.661  18.682  1.00 37.41           H  
ATOM    935  HB3 LYS    62       2.413 -13.726  18.325  1.00 37.41           H  
ATOM    936  HG2 LYS    62       2.164 -15.745  17.155  1.00 37.41           H  
ATOM    937  HG3 LYS    62       2.610 -14.551  15.939  1.00 37.41           H  
ATOM    938  HD2 LYS    62       3.790 -16.667  15.588  1.00 37.41           H  
ATOM    939  HD3 LYS    62       4.919 -15.370  15.972  1.00 37.41           H  
ATOM    940  HE2 LYS    62       5.123 -16.157  18.243  1.00 37.41           H  
ATOM    941  HE3 LYS    62       3.870 -17.369  17.977  1.00 37.41           H  
ATOM    942  HZ1 LYS    62       6.100 -18.314  17.871  1.00 37.41           H  
ATOM    943  HZ2 LYS    62       6.495 -17.286  16.585  1.00 37.41           H  
ATOM    944  HZ3 LYS    62       5.301 -18.465  16.385  1.00 37.41           H  
ATOM    945  N   ASN    63       6.149 -13.463  16.062  1.00 21.24           N  
ATOM    946  CA  ASN    63       7.566 -13.751  15.782  1.00 12.32           C  
ATOM    947  C   ASN    63       8.383 -12.441  15.702  1.00 33.24           C  
ATOM    948  O   ASN    63       9.455 -12.395  15.101  1.00  2.24           O  
ATOM    949  CB  ASN    63       7.668 -14.554  14.471  1.00 62.24           C  
ATOM    950  CG  ASN    63       9.074 -15.056  14.164  1.00 20.31           C  
ATOM    951  OD1 ASN    63       9.485 -16.114  14.623  1.00 45.23           O  
ATOM    952  ND2 ASN    63       9.818 -14.312  13.374  1.00 10.10           N  
ATOM    953  H   ASN    63       5.524 -13.370  15.311  1.00 37.41           H  
ATOM    954  HA  ASN    63       7.952 -14.351  16.596  1.00 40.40           H  
ATOM    955  HB2 ASN    63       7.016 -15.413  14.538  1.00 37.41           H  
ATOM    956  HB3 ASN    63       7.342 -13.932  13.647  1.00 37.41           H  
ATOM    957 HD21 ASN    63       9.442 -13.479  13.028  1.00 37.41           H  
ATOM    958 HD22 ASN    63      10.721 -14.626  13.165  1.00 37.41           H  
ATOM    959  N   ASP    64       7.867 -11.379  16.331  1.00 12.21           N  
ATOM    960  CA  ASP    64       8.514 -10.058  16.313  1.00 33.52           C  
ATOM    961  C   ASP    64       8.675  -9.521  14.882  1.00 53.51           C  
ATOM    962  O   ASP    64       9.686  -8.898  14.546  1.00 41.44           O  
ATOM    963  CB  ASP    64       9.872 -10.114  17.026  1.00 11.12           C  
ATOM    964  CG  ASP    64       9.731 -10.181  18.532  1.00 25.43           C  
ATOM    965  OD1 ASP    64       9.576  -9.113  19.163  1.00 53.53           O  
ATOM    966  OD2 ASP    64       9.775 -11.295  19.093  1.00 55.32           O  
ATOM    967  H   ASP    64       7.030 -11.487  16.826  1.00 37.41           H  
ATOM    968  HA  ASP    64       7.868  -9.381  16.853  1.00 71.24           H  
ATOM    969  HB2 ASP    64      10.411 -10.990  16.690  1.00 37.41           H  
ATOM    970  HB3 ASP    64      10.444  -9.232  16.774  1.00 37.41           H  
ATOM    971  N   LYS    65       7.662  -9.755  14.048  1.00 61.14           N  
ATOM    972  CA  LYS    65       7.666  -9.274  12.660  1.00 32.24           C  
ATOM    973  C   LYS    65       6.824  -7.992  12.531  1.00 33.22           C  
ATOM    974  O   LYS    65       5.593  -8.050  12.518  1.00 61.02           O  
ATOM    975  CB  LYS    65       7.113 -10.358  11.721  1.00 71.43           C  
ATOM    976  CG  LYS    65       7.740 -11.735  11.933  1.00 12.12           C  
ATOM    977  CD  LYS    65       7.122 -12.797  11.024  1.00 54.43           C  
ATOM    978  CE  LYS    65       7.477 -12.578   9.556  1.00 71.11           C  
ATOM    979  NZ  LYS    65       8.943 -12.627   9.316  1.00 13.30           N  
ATOM    980  H   LYS    65       6.892 -10.263  14.373  1.00 37.41           H  
ATOM    981  HA  LYS    65       8.687  -9.055  12.380  1.00 74.43           H  
ATOM    982  HB2 LYS    65       6.046 -10.444  11.878  1.00 37.41           H  
ATOM    983  HB3 LYS    65       7.291 -10.057  10.697  1.00 37.41           H  
ATOM    984  HG2 LYS    65       8.799 -11.672  11.725  1.00 37.41           H  
ATOM    985  HG3 LYS    65       7.595 -12.028  12.964  1.00 37.41           H  
ATOM    986  HD2 LYS    65       7.482 -13.769  11.327  1.00 37.41           H  
ATOM    987  HD3 LYS    65       6.046 -12.764  11.131  1.00 37.41           H  
ATOM    988  HE2 LYS    65       7.002 -13.348   8.965  1.00 37.41           H  
ATOM    989  HE3 LYS    65       7.105 -11.611   9.248  1.00 37.41           H  
ATOM    990  HZ1 LYS    65       9.144 -12.552   8.299  1.00 37.41           H  
ATOM    991  HZ2 LYS    65       9.336 -13.522   9.668  1.00 37.41           H  
ATOM    992  HZ3 LYS    65       9.415 -11.842   9.806  1.00 37.41           H  
ATOM    993  N   PRO    66       7.471  -6.815  12.457  1.00 62.54           N  
ATOM    994  CA  PRO    66       6.766  -5.530  12.370  1.00 44.02           C  
ATOM    995  C   PRO    66       6.263  -5.199  10.950  1.00 12.31           C  
ATOM    996  O   PRO    66       7.020  -5.245   9.979  1.00 62.23           O  
ATOM    997  CB  PRO    66       7.837  -4.530  12.819  1.00 32.11           C  
ATOM    998  CG  PRO    66       9.125  -5.139  12.375  1.00 70.24           C  
ATOM    999  CD  PRO    66       8.939  -6.637  12.465  1.00 13.44           C  
ATOM   1000  HA  PRO    66       5.933  -5.494  13.059  1.00  1.01           H  
ATOM   1001  HB2 PRO    66       7.665  -3.571  12.350  1.00 37.41           H  
ATOM   1002  HB3 PRO    66       7.804  -4.420  13.894  1.00 37.41           H  
ATOM   1003  HG2 PRO    66       9.335  -4.847  11.356  1.00 37.41           H  
ATOM   1004  HG3 PRO    66       9.927  -4.820  13.027  1.00 37.41           H  
ATOM   1005  HD2 PRO    66       9.390  -7.125  11.612  1.00 37.41           H  
ATOM   1006  HD3 PRO    66       9.364  -7.017  13.383  1.00 37.41           H  
ATOM   1007  N   TYR    67       4.979  -4.871  10.846  1.00 24.13           N  
ATOM   1008  CA  TYR    67       4.370  -4.439   9.581  1.00 24.21           C  
ATOM   1009  C   TYR    67       3.188  -3.491   9.849  1.00 45.21           C  
ATOM   1010  O   TYR    67       2.904  -3.151  11.001  1.00 72.50           O  
ATOM   1011  CB  TYR    67       3.915  -5.656   8.753  1.00  1.11           C  
ATOM   1012  CG  TYR    67       2.901  -6.550   9.452  1.00  2.41           C  
ATOM   1013  CD1 TYR    67       3.311  -7.547  10.334  1.00 23.44           C  
ATOM   1014  CD2 TYR    67       1.534  -6.403   9.224  1.00 42.32           C  
ATOM   1015  CE1 TYR    67       2.393  -8.362  10.969  1.00 44.40           C  
ATOM   1016  CE2 TYR    67       0.612  -7.216   9.855  1.00 22.30           C  
ATOM   1017  CZ  TYR    67       1.046  -8.194  10.726  1.00  1.14           C  
ATOM   1018  OH  TYR    67       0.131  -9.010  11.357  1.00 65.32           O  
ATOM   1019  H   TYR    67       4.411  -4.928  11.646  1.00 37.41           H  
ATOM   1020  HA  TYR    67       5.122  -3.896   9.023  1.00 62.22           H  
ATOM   1021  HB2 TYR    67       3.469  -5.308   7.832  1.00 37.41           H  
ATOM   1022  HB3 TYR    67       4.780  -6.259   8.514  1.00 37.41           H  
ATOM   1023  HD1 TYR    67       4.366  -7.678  10.524  1.00  3.10           H  
ATOM   1024  HD2 TYR    67       1.196  -5.635   8.542  1.00 71.14           H  
ATOM   1025  HE1 TYR    67       2.735  -9.127  11.651  1.00 11.44           H  
ATOM   1026  HE2 TYR    67      -0.444  -7.086   9.660  1.00 45.34           H  
ATOM   1027  HH  TYR    67      -0.543  -9.284  10.722  1.00 75.15           H  
ATOM   1028  N   PHE    68       2.507  -3.052   8.794  1.00 24.23           N  
ATOM   1029  CA  PHE    68       1.371  -2.137   8.954  1.00  4.50           C  
ATOM   1030  C   PHE    68       0.403  -2.178   7.760  1.00 64.32           C  
ATOM   1031  O   PHE    68       0.799  -2.428   6.620  1.00 12.41           O  
ATOM   1032  CB  PHE    68       1.871  -0.698   9.183  1.00 32.33           C  
ATOM   1033  CG  PHE    68       2.691  -0.137   8.044  1.00 23.42           C  
ATOM   1034  CD1 PHE    68       4.044  -0.426   7.932  1.00 53.23           C  
ATOM   1035  CD2 PHE    68       2.106   0.680   7.083  1.00 31.25           C  
ATOM   1036  CE1 PHE    68       4.793   0.086   6.889  1.00  4.33           C  
ATOM   1037  CE2 PHE    68       2.853   1.193   6.040  1.00  0.44           C  
ATOM   1038  CZ  PHE    68       4.199   0.895   5.945  1.00 13.13           C  
ATOM   1039  H   PHE    68       2.769  -3.344   7.896  1.00 37.41           H  
ATOM   1040  HA  PHE    68       0.827  -2.451   9.835  1.00 14.23           H  
ATOM   1041  HB2 PHE    68       1.019  -0.048   9.332  1.00 37.41           H  
ATOM   1042  HB3 PHE    68       2.484  -0.681  10.074  1.00 37.41           H  
ATOM   1043  HD1 PHE    68       4.514  -1.062   8.670  1.00 10.45           H  
ATOM   1044  HD2 PHE    68       1.053   0.917   7.157  1.00 75.42           H  
ATOM   1045  HE1 PHE    68       5.844  -0.148   6.814  1.00 73.12           H  
ATOM   1046  HE2 PHE    68       2.386   1.826   5.300  1.00 70.04           H  
ATOM   1047  HZ  PHE    68       4.783   1.293   5.130  1.00  3.33           H  
ATOM   1048  N   ASN    69      -0.872  -1.940   8.050  1.00 64.50           N  
ATOM   1049  CA  ASN    69      -1.917  -1.835   7.029  1.00 15.25           C  
ATOM   1050  C   ASN    69      -2.474  -0.402   6.980  1.00 13.04           C  
ATOM   1051  O   ASN    69      -2.335   0.362   7.937  1.00 72.31           O  
ATOM   1052  CB  ASN    69      -3.054  -2.818   7.333  1.00 23.42           C  
ATOM   1053  CG  ASN    69      -2.588  -4.266   7.375  1.00 74.43           C  
ATOM   1054  OD1 ASN    69      -2.149  -4.761   8.408  1.00 54.30           O  
ATOM   1055  ND2 ASN    69      -2.687  -4.962   6.259  1.00 72.34           N  
ATOM   1056  H   ASN    69      -1.125  -1.836   8.987  1.00 37.41           H  
ATOM   1057  HA  ASN    69      -1.481  -2.078   6.069  1.00 74.20           H  
ATOM   1058  HB2 ASN    69      -3.484  -2.574   8.293  1.00 37.41           H  
ATOM   1059  HB3 ASN    69      -3.816  -2.725   6.572  1.00 37.41           H  
ATOM   1060 HD21 ASN    69      -3.050  -4.521   5.464  1.00 37.41           H  
ATOM   1061 HD22 ASN    69      -2.402  -5.900   6.277  1.00 37.41           H  
ATOM   1062  N   LEU    70      -3.099  -0.039   5.866  1.00  3.12           N  
ATOM   1063  CA  LEU    70      -3.696   1.294   5.709  1.00 12.35           C  
ATOM   1064  C   LEU    70      -5.207   1.188   5.443  1.00 52.51           C  
ATOM   1065  O   LEU    70      -5.639   0.449   4.550  1.00  2.32           O  
ATOM   1066  CB  LEU    70      -3.002   2.054   4.562  1.00 61.41           C  
ATOM   1067  CG  LEU    70      -3.459   3.511   4.357  1.00 74.43           C  
ATOM   1068  CD1 LEU    70      -3.134   4.366   5.584  1.00 53.53           C  
ATOM   1069  CD2 LEU    70      -2.820   4.100   3.100  1.00 51.44           C  
ATOM   1070  H   LEU    70      -3.166  -0.683   5.130  1.00 37.41           H  
ATOM   1071  HA  LEU    70      -3.544   1.837   6.631  1.00 30.15           H  
ATOM   1072  HB2 LEU    70      -1.937   2.057   4.757  1.00 37.41           H  
ATOM   1073  HB3 LEU    70      -3.177   1.512   3.643  1.00 37.41           H  
ATOM   1074  HG  LEU    70      -4.530   3.526   4.222  1.00 53.12           H  
ATOM   1075 HD11 LEU    70      -3.620   3.946   6.453  1.00 37.41           H  
ATOM   1076 HD12 LEU    70      -3.491   5.374   5.426  1.00 37.41           H  
ATOM   1077 HD13 LEU    70      -2.066   4.384   5.742  1.00 37.41           H  
ATOM   1078 HD21 LEU    70      -3.146   5.121   2.972  1.00 37.41           H  
ATOM   1079 HD22 LEU    70      -3.117   3.519   2.239  1.00 37.41           H  
ATOM   1080 HD23 LEU    70      -1.744   4.076   3.194  1.00 37.41           H  
ATOM   1081  N   LYS    71      -6.004   1.925   6.220  1.00 35.23           N  
ATOM   1082  CA  LYS    71      -7.465   1.907   6.076  1.00 73.11           C  
ATOM   1083  C   LYS    71      -8.014   3.253   5.581  1.00 73.01           C  
ATOM   1084  O   LYS    71      -7.513   4.317   5.942  1.00  2.23           O  
ATOM   1085  CB  LYS    71      -8.145   1.557   7.410  1.00 52.54           C  
ATOM   1086  CG  LYS    71      -7.870   0.143   7.914  1.00  3.44           C  
ATOM   1087  CD  LYS    71      -8.818  -0.226   9.058  1.00 43.11           C  
ATOM   1088  CE  LYS    71      -8.538  -1.614   9.626  1.00  2.32           C  
ATOM   1089  NZ  LYS    71      -7.195  -1.709  10.252  1.00 63.42           N  
ATOM   1090  H   LYS    71      -5.604   2.503   6.907  1.00 37.41           H  
ATOM   1091  HA  LYS    71      -7.718   1.146   5.350  1.00 23.22           H  
ATOM   1092  HB2 LYS    71      -7.803   2.251   8.165  1.00 37.41           H  
ATOM   1093  HB3 LYS    71      -9.216   1.669   7.293  1.00 37.41           H  
ATOM   1094  HG2 LYS    71      -8.009  -0.555   7.100  1.00 37.41           H  
ATOM   1095  HG3 LYS    71      -6.848   0.086   8.269  1.00 37.41           H  
ATOM   1096  HD2 LYS    71      -8.714   0.502   9.850  1.00 37.41           H  
ATOM   1097  HD3 LYS    71      -9.832  -0.201   8.685  1.00 37.41           H  
ATOM   1098  HE2 LYS    71      -9.287  -1.839  10.372  1.00 37.41           H  
ATOM   1099  HE3 LYS    71      -8.605  -2.337   8.826  1.00 37.41           H  
ATOM   1100  HZ1 LYS    71      -7.050  -0.916  10.911  1.00 37.41           H  
ATOM   1101  HZ2 LYS    71      -6.452  -1.683   9.527  1.00 37.41           H  
ATOM   1102  HZ3 LYS    71      -7.112  -2.600  10.783  1.00 37.41           H  
ATOM   1103  N   ALA    72      -9.056   3.195   4.754  1.00 64.14           N  
ATOM   1104  CA  ALA    72      -9.782   4.398   4.334  1.00 62.42           C  
ATOM   1105  C   ALA    72     -10.779   4.839   5.421  1.00 74.43           C  
ATOM   1106  O   ALA    72     -10.918   4.172   6.448  1.00 34.50           O  
ATOM   1107  CB  ALA    72     -10.504   4.149   3.016  1.00 73.22           C  
ATOM   1108  H   ALA    72      -9.341   2.319   4.415  1.00 37.41           H  
ATOM   1109  HA  ALA    72      -9.062   5.190   4.180  1.00 74.24           H  
ATOM   1110  HB1 ALA    72      -9.793   3.834   2.267  1.00 37.41           H  
ATOM   1111  HB2 ALA    72     -10.990   5.059   2.691  1.00 37.41           H  
ATOM   1112  HB3 ALA    72     -11.247   3.377   3.152  1.00 37.41           H  
ATOM   1113  N   ALA    73     -11.471   5.956   5.194  1.00 12.14           N  
ATOM   1114  CA  ALA    73     -12.418   6.506   6.181  1.00 23.01           C  
ATOM   1115  C   ALA    73     -13.482   5.481   6.617  1.00 13.03           C  
ATOM   1116  O   ALA    73     -13.840   5.409   7.791  1.00 75.11           O  
ATOM   1117  CB  ALA    73     -13.091   7.756   5.622  1.00 23.52           C  
ATOM   1118  H   ALA    73     -11.348   6.428   4.343  1.00 37.41           H  
ATOM   1119  HA  ALA    73     -11.846   6.801   7.050  1.00 75.03           H  
ATOM   1120  HB1 ALA    73     -13.668   7.495   4.745  1.00 37.41           H  
ATOM   1121  HB2 ALA    73     -12.336   8.482   5.351  1.00 37.41           H  
ATOM   1122  HB3 ALA    73     -13.746   8.182   6.369  1.00 37.41           H  
ATOM   1123  N   ASN    74     -13.975   4.682   5.668  1.00 14.50           N  
ATOM   1124  CA  ASN    74     -14.995   3.662   5.962  1.00 44.41           C  
ATOM   1125  C   ASN    74     -14.373   2.400   6.607  1.00 22.25           C  
ATOM   1126  O   ASN    74     -15.018   1.355   6.708  1.00 15.02           O  
ATOM   1127  CB  ASN    74     -15.760   3.307   4.675  1.00 73.15           C  
ATOM   1128  CG  ASN    74     -17.051   2.547   4.943  1.00 61.34           C  
ATOM   1129  OD1 ASN    74     -18.083   3.137   5.242  1.00  2.04           O  
ATOM   1130  ND2 ASN    74     -17.016   1.235   4.823  1.00 24.03           N  
ATOM   1131  H   ASN    74     -13.661   4.793   4.747  1.00 37.41           H  
ATOM   1132  HA  ASN    74     -15.692   4.094   6.667  1.00 11.14           H  
ATOM   1133  HB2 ASN    74     -16.008   4.219   4.148  1.00 37.41           H  
ATOM   1134  HB3 ASN    74     -15.129   2.697   4.044  1.00 37.41           H  
ATOM   1135 HD21 ASN    74     -16.171   0.813   4.570  1.00 37.41           H  
ATOM   1136 HD22 ASN    74     -17.843   0.739   4.984  1.00 37.41           H  
ATOM   1137  N   HIS    75     -13.105   2.509   7.018  1.00 14.22           N  
ATOM   1138  CA  HIS    75     -12.421   1.473   7.820  1.00 24.34           C  
ATOM   1139  C   HIS    75     -12.106   0.216   6.985  1.00 63.04           C  
ATOM   1140  O   HIS    75     -11.936  -0.882   7.520  1.00 64.04           O  
ATOM   1141  CB  HIS    75     -13.274   1.119   9.054  1.00 34.43           C  
ATOM   1142  CG  HIS    75     -12.532   0.386  10.133  1.00 15.42           C  
ATOM   1143  ND1 HIS    75     -12.548  -0.986  10.265  1.00  2.12           N  
ATOM   1144  CD2 HIS    75     -11.764   0.847  11.149  1.00 71.01           C  
ATOM   1145  CE1 HIS    75     -11.827  -1.335  11.311  1.00 72.22           C  
ATOM   1146  NE2 HIS    75     -11.339  -0.245  11.865  1.00 11.40           N  
ATOM   1147  H   HIS    75     -12.605   3.312   6.767  1.00 37.41           H  
ATOM   1148  HA  HIS    75     -11.486   1.895   8.157  1.00 70.03           H  
ATOM   1149  HB2 HIS    75     -13.657   2.031   9.486  1.00 37.41           H  
ATOM   1150  HB3 HIS    75     -14.105   0.501   8.745  1.00 37.41           H  
ATOM   1151  HD1 HIS    75     -13.019  -1.614   9.676  1.00 74.14           H  
ATOM   1152  HD2 HIS    75     -11.527   1.882  11.355  1.00 62.31           H  
ATOM   1153  HE1 HIS    75     -11.662  -2.346  11.653  1.00 23.12           H  
ATOM   1154  HE2 HIS    75     -10.934  -0.206  12.760  1.00 37.41           H  
ATOM   1155  N   GLN    76     -11.995   0.406   5.675  1.00 70.15           N  
ATOM   1156  CA  GLN    76     -11.689  -0.683   4.736  1.00 74.21           C  
ATOM   1157  C   GLN    76     -10.171  -0.827   4.527  1.00 71.43           C  
ATOM   1158  O   GLN    76      -9.428   0.149   4.651  1.00 53.14           O  
ATOM   1159  CB  GLN    76     -12.374  -0.393   3.393  1.00 42.12           C  
ATOM   1160  CG  GLN    76     -11.825   0.848   2.691  1.00 15.10           C  
ATOM   1161  CD  GLN    76     -12.765   1.405   1.641  1.00  1.43           C  
ATOM   1162  OE1 GLN    76     -12.715   1.031   0.471  1.00 50.25           O  
ATOM   1163  NE2 GLN    76     -13.614   2.324   2.052  1.00 12.54           N  
ATOM   1164  H   GLN    76     -12.121   1.309   5.323  1.00 37.41           H  
ATOM   1165  HA  GLN    76     -12.081  -1.604   5.143  1.00  5.43           H  
ATOM   1166  HB2 GLN    76     -12.235  -1.243   2.738  1.00 37.41           H  
ATOM   1167  HB3 GLN    76     -13.432  -0.249   3.563  1.00 37.41           H  
ATOM   1168  HG2 GLN    76     -11.647   1.615   3.431  1.00 37.41           H  
ATOM   1169  HG3 GLN    76     -10.889   0.592   2.215  1.00 37.41           H  
ATOM   1170 HE21 GLN    76     -13.589   2.593   2.992  1.00 37.41           H  
ATOM   1171 HE22 GLN    76     -14.248   2.691   1.397  1.00 37.41           H  
ATOM   1172  N   ILE    77      -9.715  -2.035   4.194  1.00 32.34           N  
ATOM   1173  CA  ILE    77      -8.283  -2.295   3.979  1.00 40.03           C  
ATOM   1174  C   ILE    77      -7.868  -1.955   2.540  1.00 24.44           C  
ATOM   1175  O   ILE    77      -8.107  -2.731   1.612  1.00 71.02           O  
ATOM   1176  CB  ILE    77      -7.923  -3.778   4.274  1.00 72.54           C  
ATOM   1177  CG1 ILE    77      -8.252  -4.137   5.732  1.00 71.52           C  
ATOM   1178  CG2 ILE    77      -6.445  -4.051   3.976  1.00 55.33           C  
ATOM   1179  CD1 ILE    77      -7.418  -3.391   6.752  1.00  4.14           C  
ATOM   1180  H   ILE    77     -10.356  -2.767   4.072  1.00 37.41           H  
ATOM   1181  HA  ILE    77      -7.722  -1.669   4.662  1.00 54.33           H  
ATOM   1182  HB  ILE    77      -8.514  -4.401   3.617  1.00 41.44           H  
ATOM   1183 HG12 ILE    77      -9.289  -3.910   5.927  1.00 37.41           H  
ATOM   1184 HG13 ILE    77      -8.090  -5.196   5.881  1.00 37.41           H  
ATOM   1185 HG21 ILE    77      -6.214  -5.082   4.206  1.00 37.41           H  
ATOM   1186 HG22 ILE    77      -5.826  -3.401   4.579  1.00 37.41           H  
ATOM   1187 HG23 ILE    77      -6.247  -3.865   2.930  1.00 37.41           H  
ATOM   1188 HD11 ILE    77      -6.377  -3.650   6.624  1.00 37.41           H  
ATOM   1189 HD12 ILE    77      -7.735  -3.667   7.746  1.00 37.41           H  
ATOM   1190 HD13 ILE    77      -7.545  -2.327   6.616  1.00 37.41           H  
ATOM   1191  N   ILE    78      -7.258  -0.789   2.357  1.00 42.24           N  
ATOM   1192  CA  ILE    78      -6.824  -0.346   1.024  1.00 51.22           C  
ATOM   1193  C   ILE    78      -5.345  -0.674   0.761  1.00 70.34           C  
ATOM   1194  O   ILE    78      -4.940  -0.865  -0.388  1.00 50.21           O  
ATOM   1195  CB  ILE    78      -7.057   1.174   0.830  1.00 32.12           C  
ATOM   1196  CG1 ILE    78      -6.289   1.979   1.892  1.00 53.32           C  
ATOM   1197  CG2 ILE    78      -8.551   1.494   0.876  1.00 11.03           C  
ATOM   1198  CD1 ILE    78      -6.479   3.475   1.785  1.00 34.20           C  
ATOM   1199  H   ILE    78      -7.099  -0.209   3.131  1.00 37.41           H  
ATOM   1200  HA  ILE    78      -7.424  -0.870   0.290  1.00 62.01           H  
ATOM   1201  HB  ILE    78      -6.691   1.447  -0.151  1.00 52.10           H  
ATOM   1202 HG12 ILE    78      -6.619   1.676   2.875  1.00 37.41           H  
ATOM   1203 HG13 ILE    78      -5.231   1.773   1.796  1.00 37.41           H  
ATOM   1204 HG21 ILE    78      -8.701   2.554   0.726  1.00 37.41           H  
ATOM   1205 HG22 ILE    78      -8.953   1.206   1.838  1.00 37.41           H  
ATOM   1206 HG23 ILE    78      -9.062   0.945   0.097  1.00 37.41           H  
ATOM   1207 HD11 ILE    78      -5.860   3.968   2.520  1.00 37.41           H  
ATOM   1208 HD12 ILE    78      -7.515   3.722   1.966  1.00 37.41           H  
ATOM   1209 HD13 ILE    78      -6.198   3.807   0.798  1.00 37.41           H  
ATOM   1210  N   GLY    79      -4.543  -0.740   1.826  1.00 72.31           N  
ATOM   1211  CA  GLY    79      -3.118  -1.037   1.679  1.00 14.54           C  
ATOM   1212  C   GLY    79      -2.586  -2.007   2.734  1.00 61.14           C  
ATOM   1213  O   GLY    79      -3.094  -2.060   3.853  1.00 22.12           O  
ATOM   1214  H   GLY    79      -4.920  -0.581   2.720  1.00 37.41           H  
ATOM   1215  HA2 GLY    79      -2.948  -1.464   0.699  1.00 37.41           H  
ATOM   1216  HA3 GLY    79      -2.566  -0.111   1.750  1.00 37.41           H  
ATOM   1217  N   THR    80      -1.552  -2.767   2.373  1.00 55.11           N  
ATOM   1218  CA  THR    80      -0.925  -3.738   3.289  1.00 61.41           C  
ATOM   1219  C   THR    80       0.586  -3.837   3.039  1.00 45.05           C  
ATOM   1220  O   THR    80       1.017  -4.076   1.916  1.00 71.44           O  
ATOM   1221  CB  THR    80      -1.558  -5.147   3.137  1.00 41.01           C  
ATOM   1222  OG1 THR    80      -2.947  -5.106   3.503  1.00 65.52           O  
ATOM   1223  CG2 THR    80      -0.837  -6.182   3.998  1.00  5.43           C  
ATOM   1224  H   THR    80      -1.195  -2.681   1.463  1.00 37.41           H  
ATOM   1225  HA  THR    80      -1.093  -3.397   4.304  1.00 64.32           H  
ATOM   1226  HB  THR    80      -1.480  -5.447   2.100  1.00 64.12           H  
ATOM   1227  HG1 THR    80      -3.488  -5.116   2.709  1.00 11.42           H  
ATOM   1228 HG21 THR    80      -0.865  -5.876   5.034  1.00 37.41           H  
ATOM   1229 HG22 THR    80       0.192  -6.269   3.677  1.00 37.41           H  
ATOM   1230 HG23 THR    80      -1.326  -7.140   3.896  1.00 37.41           H  
ATOM   1231  N   SER    81       1.385  -3.644   4.084  1.00 55.20           N  
ATOM   1232  CA  SER    81       2.854  -3.672   3.956  1.00 70.42           C  
ATOM   1233  C   SER    81       3.435  -5.074   4.181  1.00  1.13           C  
ATOM   1234  O   SER    81       2.783  -5.955   4.752  1.00  0.21           O  
ATOM   1235  CB  SER    81       3.496  -2.690   4.943  1.00 14.40           C  
ATOM   1236  OG  SER    81       4.910  -2.741   4.869  1.00 40.10           O  
ATOM   1237  H   SER    81       0.986  -3.476   4.965  1.00 37.41           H  
ATOM   1238  HA  SER    81       3.099  -3.358   2.950  1.00 32.31           H  
ATOM   1239  HB2 SER    81       3.174  -1.686   4.710  1.00 37.41           H  
ATOM   1240  HB3 SER    81       3.189  -2.937   5.950  1.00 37.41           H  
ATOM   1241  HG  SER    81       5.256  -1.873   4.625  1.00 61.12           H  
ATOM   1242  N   GLN    82       4.677  -5.271   3.739  1.00  5.15           N  
ATOM   1243  CA  GLN    82       5.359  -6.558   3.892  1.00 21.22           C  
ATOM   1244  C   GLN    82       6.166  -6.618   5.200  1.00 62.30           C  
ATOM   1245  O   GLN    82       6.863  -5.668   5.560  1.00 11.14           O  
ATOM   1246  CB  GLN    82       6.300  -6.835   2.704  1.00 60.54           C  
ATOM   1247  CG  GLN    82       5.623  -6.827   1.331  1.00 40.12           C  
ATOM   1248  CD  GLN    82       5.440  -5.429   0.762  1.00 34.15           C  
ATOM   1249  OE1 GLN    82       4.416  -4.784   0.956  1.00 74.24           O  
ATOM   1250  NE2 GLN    82       6.438  -4.949   0.049  1.00 13.44           N  
ATOM   1251  H   GLN    82       5.147  -4.528   3.306  1.00 37.41           H  
ATOM   1252  HA  GLN    82       4.602  -7.330   3.918  1.00 24.02           H  
ATOM   1253  HB2 GLN    82       7.079  -6.085   2.698  1.00 37.41           H  
ATOM   1254  HB3 GLN    82       6.756  -7.805   2.847  1.00 37.41           H  
ATOM   1255  HG2 GLN    82       6.229  -7.400   0.645  1.00 37.41           H  
ATOM   1256  HG3 GLN    82       4.651  -7.295   1.421  1.00 37.41           H  
ATOM   1257 HE21 GLN    82       7.232  -5.512  -0.077  1.00 37.41           H  
ATOM   1258 HE22 GLN    82       6.351  -4.046  -0.311  1.00 37.41           H  
ATOM   1259  N   MET    83       6.062  -7.752   5.893  1.00 21.12           N  
ATOM   1260  CA  MET    83       6.801  -8.008   7.140  1.00 20.12           C  
ATOM   1261  C   MET    83       8.272  -7.528   7.081  1.00 52.45           C  
ATOM   1262  O   MET    83       9.072  -8.020   6.280  1.00 11.10           O  
ATOM   1263  CB  MET    83       6.744  -9.512   7.447  1.00 43.35           C  
ATOM   1264  CG  MET    83       7.207 -10.389   6.284  1.00  3.32           C  
ATOM   1265  SD  MET    83       6.966 -12.151   6.591  1.00 54.34           S  
ATOM   1266  CE  MET    83       7.519 -12.842   5.032  1.00 11.34           C  
ATOM   1267  H   MET    83       5.448  -8.442   5.563  1.00 37.41           H  
ATOM   1268  HA  MET    83       6.297  -7.475   7.933  1.00 14.22           H  
ATOM   1269  HB2 MET    83       7.371  -9.722   8.305  1.00 37.41           H  
ATOM   1270  HB3 MET    83       5.724  -9.780   7.687  1.00 37.41           H  
ATOM   1271  HG2 MET    83       6.649 -10.117   5.399  1.00 37.41           H  
ATOM   1272  HG3 MET    83       8.258 -10.210   6.111  1.00 37.41           H  
ATOM   1273  HE1 MET    83       8.537 -12.535   4.843  1.00 37.41           H  
ATOM   1274  HE2 MET    83       6.882 -12.488   4.235  1.00 37.41           H  
ATOM   1275  HE3 MET    83       7.472 -13.919   5.079  1.00 37.41           H  
ATOM   1276  N   TYR    84       8.613  -6.554   7.932  1.00 31.51           N  
ATOM   1277  CA  TYR    84       9.984  -6.026   8.013  1.00 62.50           C  
ATOM   1278  C   TYR    84      10.837  -6.825   9.012  1.00 11.43           C  
ATOM   1279  O   TYR    84      10.323  -7.658   9.759  1.00 44.01           O  
ATOM   1280  CB  TYR    84       9.965  -4.547   8.426  1.00 12.32           C  
ATOM   1281  CG  TYR    84       9.245  -3.642   7.444  1.00 41.13           C  
ATOM   1282  CD1 TYR    84       9.902  -3.121   6.334  1.00 70.11           C  
ATOM   1283  CD2 TYR    84       7.905  -3.308   7.626  1.00 12.42           C  
ATOM   1284  CE1 TYR    84       9.250  -2.294   5.440  1.00  1.15           C  
ATOM   1285  CE2 TYR    84       7.248  -2.483   6.735  1.00 14.23           C  
ATOM   1286  CZ  TYR    84       7.924  -1.978   5.644  1.00 12.04           C  
ATOM   1287  OH  TYR    84       7.268  -1.156   4.750  1.00 22.12           O  
ATOM   1288  H   TYR    84       7.924  -6.176   8.519  1.00 37.41           H  
ATOM   1289  HA  TYR    84      10.433  -6.109   7.032  1.00 13.23           H  
ATOM   1290  HB2 TYR    84       9.470  -4.455   9.383  1.00 37.41           H  
ATOM   1291  HB3 TYR    84      10.982  -4.193   8.520  1.00 37.41           H  
ATOM   1292  HD1 TYR    84      10.941  -3.370   6.174  1.00 62.23           H  
ATOM   1293  HD2 TYR    84       7.378  -3.702   8.483  1.00 30.20           H  
ATOM   1294  HE1 TYR    84       9.780  -1.899   4.585  1.00 12.23           H  
ATOM   1295  HE2 TYR    84       6.209  -2.237   6.896  1.00 61.43           H  
ATOM   1296  HH  TYR    84       7.405  -1.483   3.856  1.00 43.33           H  
ATOM   1297  N   SER    85      12.141  -6.561   9.027  1.00 13.02           N  
ATOM   1298  CA  SER    85      13.061  -7.245   9.949  1.00 52.24           C  
ATOM   1299  C   SER    85      13.109  -6.551  11.317  1.00 42.44           C  
ATOM   1300  O   SER    85      12.815  -7.158  12.349  1.00  1.01           O  
ATOM   1301  CB  SER    85      14.472  -7.300   9.348  1.00 54.31           C  
ATOM   1302  OG  SER    85      14.975  -5.995   9.092  1.00 43.35           O  
ATOM   1303  H   SER    85      12.498  -5.896   8.403  1.00 37.41           H  
ATOM   1304  HA  SER    85      12.702  -8.256  10.086  1.00 51.40           H  
ATOM   1305  HB2 SER    85      15.137  -7.798  10.039  1.00 37.41           H  
ATOM   1306  HB3 SER    85      14.443  -7.850   8.418  1.00 37.41           H  
ATOM   1307  HG  SER    85      15.881  -6.067   8.762  1.00  2.54           H  
ATOM   1308  N   SER    86      13.502  -5.279  11.322  1.00 63.42           N  
ATOM   1309  CA  SER    86      13.582  -4.489  12.559  1.00 74.23           C  
ATOM   1310  C   SER    86      12.373  -3.556  12.705  1.00 73.32           C  
ATOM   1311  O   SER    86      11.706  -3.226  11.719  1.00 23.32           O  
ATOM   1312  CB  SER    86      14.864  -3.644  12.572  1.00 54.32           C  
ATOM   1313  OG  SER    86      14.833  -2.648  11.557  1.00 20.40           O  
ATOM   1314  H   SER    86      13.752  -4.859  10.472  1.00 37.41           H  
ATOM   1315  HA  SER    86      13.604  -5.173  13.397  1.00 44.14           H  
ATOM   1316  HB2 SER    86      14.965  -3.158  13.532  1.00 37.41           H  
ATOM   1317  HB3 SER    86      15.718  -4.286  12.404  1.00 37.41           H  
ATOM   1318  HG  SER    86      15.653  -2.682  11.042  1.00 20.51           H  
ATOM   1319  N   THR    87      12.093  -3.124  13.933  1.00 65.31           N  
ATOM   1320  CA  THR    87      11.020  -2.149  14.177  1.00 45.55           C  
ATOM   1321  C   THR    87      11.331  -0.822  13.479  1.00 11.24           C  
ATOM   1322  O   THR    87      10.457  -0.203  12.870  1.00 23.25           O  
ATOM   1323  CB  THR    87      10.808  -1.882  15.687  1.00 50.10           C  
ATOM   1324  OG1 THR    87      11.999  -1.322  16.264  1.00 33.13           O  
ATOM   1325  CG2 THR    87      10.444  -3.167  16.423  1.00 61.13           C  
ATOM   1326  H   THR    87      12.616  -3.464  14.695  1.00 37.41           H  
ATOM   1327  HA  THR    87      10.102  -2.553  13.769  1.00 30.01           H  
ATOM   1328  HB  THR    87       9.997  -1.177  15.803  1.00 74.14           H  
ATOM   1329  HG1 THR    87      11.760  -0.583  16.839  1.00  3.11           H  
ATOM   1330 HG21 THR    87      11.243  -3.887  16.310  1.00 37.41           H  
ATOM   1331 HG22 THR    87       9.531  -3.574  16.010  1.00 37.41           H  
ATOM   1332 HG23 THR    87      10.299  -2.953  17.472  1.00 37.41           H  
ATOM   1333  N   ALA    88      12.596  -0.405  13.561  1.00 52.20           N  
ATOM   1334  CA  ALA    88      13.069   0.810  12.892  1.00 21.41           C  
ATOM   1335  C   ALA    88      12.811   0.757  11.376  1.00 34.01           C  
ATOM   1336  O   ALA    88      12.411   1.755  10.775  1.00 31.42           O  
ATOM   1337  CB  ALA    88      14.554   1.029  13.174  1.00 62.43           C  
ATOM   1338  H   ALA    88      13.229  -0.927  14.098  1.00 37.41           H  
ATOM   1339  HA  ALA    88      12.525   1.647  13.307  1.00 22.44           H  
ATOM   1340  HB1 ALA    88      14.722   1.033  14.240  1.00 37.41           H  
ATOM   1341  HB2 ALA    88      14.865   1.977  12.759  1.00 37.41           H  
ATOM   1342  HB3 ALA    88      15.131   0.234  12.723  1.00 37.41           H  
ATOM   1343  N   ALA    89      13.041  -0.408  10.763  1.00 22.32           N  
ATOM   1344  CA  ALA    89      12.750  -0.606   9.334  1.00 24.30           C  
ATOM   1345  C   ALA    89      11.290  -0.260   9.009  1.00 74.43           C  
ATOM   1346  O   ALA    89      10.999   0.381   7.999  1.00 61.43           O  
ATOM   1347  CB  ALA    89      13.051  -2.044   8.923  1.00 34.13           C  
ATOM   1348  H   ALA    89      13.429  -1.150  11.279  1.00 37.41           H  
ATOM   1349  HA  ALA    89      13.399   0.050   8.770  1.00 31.22           H  
ATOM   1350  HB1 ALA    89      12.424  -2.721   9.486  1.00 37.41           H  
ATOM   1351  HB2 ALA    89      14.088  -2.266   9.123  1.00 37.41           H  
ATOM   1352  HB3 ALA    89      12.855  -2.167   7.866  1.00 37.41           H  
ATOM   1353  N   ARG    90      10.381  -0.684   9.883  1.00 11.00           N  
ATOM   1354  CA  ARG    90       8.951  -0.412   9.713  1.00 33.04           C  
ATOM   1355  C   ARG    90       8.652   1.096   9.741  1.00 30.22           C  
ATOM   1356  O   ARG    90       8.065   1.641   8.808  1.00 73.34           O  
ATOM   1357  CB  ARG    90       8.152  -1.104  10.823  1.00 44.22           C  
ATOM   1358  CG  ARG    90       6.644  -0.872  10.740  1.00 45.02           C  
ATOM   1359  CD  ARG    90       5.953  -1.217  12.052  1.00 61.31           C  
ATOM   1360  NE  ARG    90       6.448  -0.396  13.158  1.00 33.23           N  
ATOM   1361  CZ  ARG    90       5.953  -0.406  14.365  1.00 13.35           C  
ATOM   1362  NH1 ARG    90       4.968  -1.191  14.672  1.00 64.35           N  
ATOM   1363  NH2 ARG    90       6.455   0.371  15.264  1.00 43.35           N  
ATOM   1364  H   ARG    90      10.680  -1.197  10.664  1.00 37.41           H  
ATOM   1365  HA  ARG    90       8.646  -0.814   8.758  1.00 34.12           H  
ATOM   1366  HB2 ARG    90       8.335  -2.169  10.770  1.00 37.41           H  
ATOM   1367  HB3 ARG    90       8.499  -0.738  11.779  1.00 37.41           H  
ATOM   1368  HG2 ARG    90       6.459   0.170  10.512  1.00 37.41           H  
ATOM   1369  HG3 ARG    90       6.236  -1.491   9.952  1.00 37.41           H  
ATOM   1370  HD2 ARG    90       4.890  -1.054  11.938  1.00 37.41           H  
ATOM   1371  HD3 ARG    90       6.135  -2.259  12.277  1.00 37.41           H  
ATOM   1372  HE  ARG    90       7.196   0.212  12.977  1.00 52.40           H  
ATOM   1373 HH11 ARG    90       4.581  -1.794  13.988  1.00 37.41           H  
ATOM   1374 HH12 ARG    90       4.591  -1.178  15.600  1.00 37.41           H  
ATOM   1375 HH21 ARG    90       7.217   0.980  15.028  1.00 37.41           H  
ATOM   1376 HH22 ARG    90       6.080   0.373  16.190  1.00 37.41           H  
ATOM   1377  N   ASP    91       9.064   1.763  10.816  1.00 40.42           N  
ATOM   1378  CA  ASP    91       8.766   3.187  11.006  1.00  2.52           C  
ATOM   1379  C   ASP    91       9.501   4.082   9.985  1.00 70.24           C  
ATOM   1380  O   ASP    91       8.964   5.108   9.551  1.00 75.01           O  
ATOM   1381  CB  ASP    91       9.087   3.594  12.447  1.00 21.44           C  
ATOM   1382  CG  ASP    91       8.134   2.936  13.440  1.00  2.12           C  
ATOM   1383  OD1 ASP    91       8.377   1.775  13.833  1.00 23.12           O  
ATOM   1384  OD2 ASP    91       7.127   3.571  13.818  1.00 30.33           O  
ATOM   1385  H   ASP    91       9.578   1.286  11.507  1.00 37.41           H  
ATOM   1386  HA  ASP    91       7.702   3.311  10.850  1.00 41.42           H  
ATOM   1387  HB2 ASP    91      10.099   3.294  12.684  1.00 37.41           H  
ATOM   1388  HB3 ASP    91       9.003   4.668  12.545  1.00 37.41           H  
ATOM   1389  N   ASN    92      10.717   3.698   9.593  1.00 24.54           N  
ATOM   1390  CA  ASN    92      11.417   4.388   8.500  1.00 43.40           C  
ATOM   1391  C   ASN    92      10.694   4.148   7.170  1.00 41.23           C  
ATOM   1392  O   ASN    92      10.585   5.048   6.331  1.00  5.51           O  
ATOM   1393  CB  ASN    92      12.887   3.949   8.402  1.00 21.14           C  
ATOM   1394  CG  ASN    92      13.772   4.674   9.401  1.00  3.32           C  
ATOM   1395  OD1 ASN    92      14.285   5.755   9.126  1.00  3.13           O  
ATOM   1396  ND2 ASN    92      13.967   4.091  10.563  1.00 32.32           N  
ATOM   1397  H   ASN    92      11.145   2.938  10.038  1.00 37.41           H  
ATOM   1398  HA  ASN    92      11.384   5.449   8.713  1.00 54.44           H  
ATOM   1399  HB2 ASN    92      12.954   2.888   8.595  1.00 37.41           H  
ATOM   1400  HB3 ASN    92      13.258   4.152   7.408  1.00 37.41           H  
ATOM   1401 HD21 ASN    92      13.540   3.227  10.725  1.00 37.41           H  
ATOM   1402 HD22 ASN    92      14.534   4.551  11.217  1.00 37.41           H  
ATOM   1403  N   GLY    93      10.190   2.929   6.988  1.00 33.01           N  
ATOM   1404  CA  GLY    93       9.344   2.637   5.843  1.00 30.33           C  
ATOM   1405  C   GLY    93       8.134   3.563   5.786  1.00 44.40           C  
ATOM   1406  O   GLY    93       7.849   4.154   4.747  1.00 20.01           O  
ATOM   1407  H   GLY    93      10.397   2.219   7.635  1.00 37.41           H  
ATOM   1408  HA2 GLY    93       9.924   2.753   4.939  1.00 37.41           H  
ATOM   1409  HA3 GLY    93       9.003   1.614   5.912  1.00 37.41           H  
ATOM   1410  N   ILE    94       7.447   3.709   6.923  1.00 62.14           N  
ATOM   1411  CA  ILE    94       6.288   4.608   7.043  1.00 63.01           C  
ATOM   1412  C   ILE    94       6.627   6.044   6.601  1.00 65.20           C  
ATOM   1413  O   ILE    94       5.849   6.682   5.889  1.00 33.41           O  
ATOM   1414  CB  ILE    94       5.743   4.632   8.499  1.00 21.43           C  
ATOM   1415  CG1 ILE    94       5.302   3.219   8.929  1.00 22.41           C  
ATOM   1416  CG2 ILE    94       4.585   5.624   8.628  1.00 31.41           C  
ATOM   1417  CD1 ILE    94       4.824   3.133  10.365  1.00  5.53           C  
ATOM   1418  H   ILE    94       7.722   3.187   7.707  1.00 37.41           H  
ATOM   1419  HA  ILE    94       5.507   4.226   6.398  1.00 63.10           H  
ATOM   1420  HB  ILE    94       6.540   4.963   9.151  1.00 62.24           H  
ATOM   1421 HG12 ILE    94       4.489   2.896   8.295  1.00 37.41           H  
ATOM   1422 HG13 ILE    94       6.133   2.537   8.814  1.00 37.41           H  
ATOM   1423 HG21 ILE    94       4.214   5.620   9.643  1.00 37.41           H  
ATOM   1424 HG22 ILE    94       3.789   5.340   7.954  1.00 37.41           H  
ATOM   1425 HG23 ILE    94       4.930   6.617   8.377  1.00 37.41           H  
ATOM   1426 HD11 ILE    94       3.967   3.777  10.500  1.00 37.41           H  
ATOM   1427 HD12 ILE    94       5.616   3.447  11.029  1.00 37.41           H  
ATOM   1428 HD13 ILE    94       4.547   2.114  10.593  1.00 37.41           H  
ATOM   1429  N   LYS    95       7.788   6.552   7.022  1.00 12.12           N  
ATOM   1430  CA  LYS    95       8.235   7.888   6.599  1.00  3.54           C  
ATOM   1431  C   LYS    95       8.322   7.975   5.064  1.00 12.31           C  
ATOM   1432  O   LYS    95       7.893   8.962   4.450  1.00 50.22           O  
ATOM   1433  CB  LYS    95       9.593   8.237   7.227  1.00 22.14           C  
ATOM   1434  CG  LYS    95       9.587   8.239   8.756  1.00  4.23           C  
ATOM   1435  CD  LYS    95      10.887   8.798   9.339  1.00 72.42           C  
ATOM   1436  CE  LYS    95      12.109   7.977   8.938  1.00 70.43           C  
ATOM   1437  NZ  LYS    95      13.371   8.537   9.501  1.00 24.34           N  
ATOM   1438  H   LYS    95       8.350   6.022   7.631  1.00 37.41           H  
ATOM   1439  HA  LYS    95       7.498   8.603   6.941  1.00 23.11           H  
ATOM   1440  HB2 LYS    95      10.326   7.516   6.891  1.00 37.41           H  
ATOM   1441  HB3 LYS    95       9.889   9.221   6.888  1.00 37.41           H  
ATOM   1442  HG2 LYS    95       8.761   8.846   9.101  1.00 37.41           H  
ATOM   1443  HG3 LYS    95       9.455   7.224   9.104  1.00 37.41           H  
ATOM   1444  HD2 LYS    95      11.020   9.810   8.984  1.00 37.41           H  
ATOM   1445  HD3 LYS    95      10.809   8.806  10.417  1.00 37.41           H  
ATOM   1446  HE2 LYS    95      11.985   6.967   9.301  1.00 37.41           H  
ATOM   1447  HE3 LYS    95      12.184   7.965   7.859  1.00 37.41           H  
ATOM   1448  HZ1 LYS    95      14.163   7.886   9.326  1.00 37.41           H  
ATOM   1449  HZ2 LYS    95      13.276   8.681  10.528  1.00 37.41           H  
ATOM   1450  HZ3 LYS    95      13.591   9.450   9.056  1.00 37.41           H  
ATOM   1451  N   SER    96       8.874   6.930   4.450  1.00 12.50           N  
ATOM   1452  CA  SER    96       8.935   6.835   2.987  1.00 44.14           C  
ATOM   1453  C   SER    96       7.523   6.782   2.387  1.00 64.41           C  
ATOM   1454  O   SER    96       7.223   7.487   1.426  1.00 44.33           O  
ATOM   1455  CB  SER    96       9.733   5.594   2.559  1.00 22.51           C  
ATOM   1456  OG  SER    96      11.057   5.631   3.076  1.00 73.53           O  
ATOM   1457  H   SER    96       9.251   6.202   4.993  1.00 37.41           H  
ATOM   1458  HA  SER    96       9.437   7.720   2.617  1.00 20.13           H  
ATOM   1459  HB2 SER    96       9.243   4.706   2.928  1.00 37.41           H  
ATOM   1460  HB3 SER    96       9.785   5.554   1.479  1.00 37.41           H  
ATOM   1461  HG  SER    96      11.063   5.256   3.966  1.00 64.30           H  
ATOM   1462  N   VAL    97       6.660   5.955   2.985  1.00 22.23           N  
ATOM   1463  CA  VAL    97       5.264   5.803   2.542  1.00 24.34           C  
ATOM   1464  C   VAL    97       4.527   7.147   2.515  1.00  2.13           C  
ATOM   1465  O   VAL    97       3.820   7.463   1.560  1.00 62.41           O  
ATOM   1466  CB  VAL    97       4.482   4.840   3.469  1.00 14.51           C  
ATOM   1467  CG1 VAL    97       3.028   4.690   3.018  1.00 71.24           C  
ATOM   1468  CG2 VAL    97       5.166   3.484   3.543  1.00 15.31           C  
ATOM   1469  H   VAL    97       6.969   5.428   3.749  1.00 37.41           H  
ATOM   1470  HA  VAL    97       5.273   5.385   1.545  1.00  1.13           H  
ATOM   1471  HB  VAL    97       4.483   5.263   4.462  1.00 32.32           H  
ATOM   1472 HG11 VAL    97       2.517   3.998   3.672  1.00 37.41           H  
ATOM   1473 HG12 VAL    97       2.999   4.315   2.006  1.00 37.41           H  
ATOM   1474 HG13 VAL    97       2.536   5.653   3.057  1.00 37.41           H  
ATOM   1475 HG21 VAL    97       6.196   3.614   3.837  1.00 37.41           H  
ATOM   1476 HG22 VAL    97       5.126   3.005   2.576  1.00 37.41           H  
ATOM   1477 HG23 VAL    97       4.663   2.866   4.269  1.00 37.41           H  
ATOM   1478  N   MET    98       4.684   7.935   3.575  1.00 75.31           N  
ATOM   1479  CA  MET    98       4.060   9.256   3.635  1.00 41.35           C  
ATOM   1480  C   MET    98       4.594  10.166   2.521  1.00 41.34           C  
ATOM   1481  O   MET    98       3.834  10.905   1.898  1.00  0.11           O  
ATOM   1482  CB  MET    98       4.282   9.904   5.010  1.00  4.12           C  
ATOM   1483  CG  MET    98       3.651   9.128   6.161  1.00  3.41           C  
ATOM   1484  SD  MET    98       3.719  10.019   7.729  1.00 30.23           S  
ATOM   1485  CE  MET    98       5.489  10.191   7.964  1.00 73.24           C  
ATOM   1486  H   MET    98       5.226   7.621   4.328  1.00 37.41           H  
ATOM   1487  HA  MET    98       2.997   9.119   3.485  1.00 63.30           H  
ATOM   1488  HB2 MET    98       5.345   9.979   5.192  1.00 37.41           H  
ATOM   1489  HB3 MET    98       3.857  10.899   5.001  1.00 37.41           H  
ATOM   1490  HG2 MET    98       2.615   8.938   5.924  1.00 37.41           H  
ATOM   1491  HG3 MET    98       4.171   8.187   6.275  1.00 37.41           H  
ATOM   1492  HE1 MET    98       5.914  10.735   7.133  1.00 37.41           H  
ATOM   1493  HE2 MET    98       5.944   9.212   8.020  1.00 37.41           H  
ATOM   1494  HE3 MET    98       5.681  10.729   8.882  1.00 37.41           H  
ATOM   1495  N   GLU    99       5.900  10.090   2.259  1.00 34.51           N  
ATOM   1496  CA  GLU    99       6.524  10.917   1.218  1.00 32.11           C  
ATOM   1497  C   GLU    99       6.046  10.539  -0.201  1.00 60.22           C  
ATOM   1498  O   GLU    99       5.629  11.400  -0.976  1.00 44.32           O  
ATOM   1499  CB  GLU    99       8.050  10.794   1.271  1.00 52.15           C  
ATOM   1500  CG  GLU    99       8.757  11.763   0.329  1.00 14.20           C  
ATOM   1501  CD  GLU    99      10.186  11.363   0.018  1.00 63.03           C  
ATOM   1502  OE1 GLU    99      11.087  11.658   0.828  1.00  4.14           O  
ATOM   1503  OE2 GLU    99      10.411  10.767  -1.055  1.00 13.44           O  
ATOM   1504  H   GLU    99       6.463   9.475   2.785  1.00 37.41           H  
ATOM   1505  HA  GLU    99       6.253  11.946   1.411  1.00 25.32           H  
ATOM   1506  HB2 GLU    99       8.383  10.993   2.280  1.00 37.41           H  
ATOM   1507  HB3 GLU    99       8.331   9.785   1.000  1.00 37.41           H  
ATOM   1508  HG2 GLU    99       8.204  11.808  -0.599  1.00 37.41           H  
ATOM   1509  HG3 GLU    99       8.764  12.745   0.782  1.00 37.41           H  
ATOM   1510  N   ASN   100       6.127   9.251  -0.544  1.00  3.11           N  
ATOM   1511  CA  ASN   100       5.842   8.796  -1.917  1.00 53.52           C  
ATOM   1512  C   ASN   100       4.372   8.388  -2.122  1.00 23.34           C  
ATOM   1513  O   ASN   100       3.846   8.496  -3.227  1.00 14.11           O  
ATOM   1514  CB  ASN   100       6.779   7.641  -2.304  1.00 64.23           C  
ATOM   1515  CG  ASN   100       6.757   6.484  -1.319  1.00 11.22           C  
ATOM   1516  OD1 ASN   100       5.763   6.225  -0.659  1.00  1.03           O  
ATOM   1517  ND2 ASN   100       7.864   5.780  -1.212  1.00 14.54           N  
ATOM   1518  H   ASN   100       6.376   8.589   0.139  1.00 37.41           H  
ATOM   1519  HA  ASN   100       6.048   9.629  -2.577  1.00  2.41           H  
ATOM   1520  HB2 ASN   100       6.490   7.260  -3.272  1.00 37.41           H  
ATOM   1521  HB3 ASN   100       7.792   8.017  -2.366  1.00 37.41           H  
ATOM   1522 HD21 ASN   100       8.632   6.031  -1.764  1.00 37.41           H  
ATOM   1523 HD22 ASN   100       7.867   5.034  -0.583  1.00 37.41           H  
ATOM   1524  N   GLY   101       3.716   7.930  -1.060  1.00 34.41           N  
ATOM   1525  CA  GLY   101       2.311   7.520  -1.144  1.00 21.04           C  
ATOM   1526  C   GLY   101       1.373   8.620  -1.650  1.00 72.40           C  
ATOM   1527  O   GLY   101       0.233   8.351  -2.033  1.00  3.20           O  
ATOM   1528  H   GLY   101       4.194   7.839  -0.209  1.00 37.41           H  
ATOM   1529  HA2 GLY   101       2.236   6.673  -1.809  1.00 37.41           H  
ATOM   1530  HA3 GLY   101       1.986   7.212  -0.161  1.00 37.41           H  
ATOM   1531  N   LYS   102       1.852   9.862  -1.651  1.00 64.32           N  
ATOM   1532  CA  LYS   102       1.064  11.005  -2.128  1.00 23.43           C  
ATOM   1533  C   LYS   102       1.444  11.394  -3.572  1.00 33.45           C  
ATOM   1534  O   LYS   102       1.112  12.486  -4.037  1.00 42.10           O  
ATOM   1535  CB  LYS   102       1.271  12.209  -1.191  1.00 55.44           C  
ATOM   1536  CG  LYS   102       2.708  12.725  -1.150  1.00  1.32           C  
ATOM   1537  CD  LYS   102       2.859  13.962  -0.259  1.00 41.23           C  
ATOM   1538  CE  LYS   102       2.866  13.628   1.232  1.00 74.51           C  
ATOM   1539  NZ  LYS   102       1.570  13.084   1.723  1.00 50.10           N  
ATOM   1540  H   LYS   102       2.756  10.017  -1.318  1.00 37.41           H  
ATOM   1541  HA  LYS   102       0.019  10.726  -2.107  1.00 64.40           H  
ATOM   1542  HB2 LYS   102       0.630  13.016  -1.516  1.00 37.41           H  
ATOM   1543  HB3 LYS   102       0.985  11.920  -0.188  1.00 37.41           H  
ATOM   1544  HG2 LYS   102       3.349  11.942  -0.772  1.00 37.41           H  
ATOM   1545  HG3 LYS   102       3.013  12.979  -2.156  1.00 37.41           H  
ATOM   1546  HD2 LYS   102       3.791  14.452  -0.504  1.00 37.41           H  
ATOM   1547  HD3 LYS   102       2.040  14.640  -0.461  1.00 37.41           H  
ATOM   1548  HE2 LYS   102       3.639  12.897   1.416  1.00 37.41           H  
ATOM   1549  HE3 LYS   102       3.096  14.528   1.784  1.00 37.41           H  
ATOM   1550  HZ1 LYS   102       1.407  12.130   1.341  1.00 37.41           H  
ATOM   1551  HZ2 LYS   102       0.784  13.703   1.435  1.00 37.41           H  
ATOM   1552  HZ3 LYS   102       1.582  13.028   2.761  1.00 37.41           H  
ATOM   1553  N   THR   103       2.137  10.496  -4.280  1.00 35.15           N  
ATOM   1554  CA  THR   103       2.586  10.777  -5.656  1.00 14.31           C  
ATOM   1555  C   THR   103       1.483  10.510  -6.689  1.00 53.11           C  
ATOM   1556  O   THR   103       0.536   9.766  -6.433  1.00 73.50           O  
ATOM   1557  CB  THR   103       3.836   9.947  -6.053  1.00 70.12           C  
ATOM   1558  OG1 THR   103       4.388  10.449  -7.285  1.00 22.34           O  
ATOM   1559  CG2 THR   103       3.496   8.467  -6.228  1.00 71.24           C  
ATOM   1560  H   THR   103       2.344   9.626  -3.875  1.00 37.41           H  
ATOM   1561  HA  THR   103       2.855  11.823  -5.706  1.00 31.50           H  
ATOM   1562  HB  THR   103       4.577  10.041  -5.271  1.00 71.21           H  
ATOM   1563  HG1 THR   103       5.226  10.002  -7.467  1.00  4.21           H  
ATOM   1564 HG21 THR   103       2.754   8.354  -7.008  1.00 37.41           H  
ATOM   1565 HG22 THR   103       3.105   8.073  -5.301  1.00 37.41           H  
ATOM   1566 HG23 THR   103       4.387   7.920  -6.501  1.00 37.41           H  
ATOM   1567  N   THR   104       1.620  11.120  -7.862  1.00 31.13           N  
ATOM   1568  CA  THR   104       0.651  10.944  -8.954  1.00 32.22           C  
ATOM   1569  C   THR   104       1.164   9.969 -10.024  1.00 70.41           C  
ATOM   1570  O   THR   104       0.440   9.627 -10.960  1.00 30.14           O  
ATOM   1571  CB  THR   104       0.320  12.293  -9.635  1.00 24.42           C  
ATOM   1572  OG1 THR   104       1.515  12.875 -10.180  1.00 51.34           O  
ATOM   1573  CG2 THR   104      -0.316  13.266  -8.646  1.00 55.23           C  
ATOM   1574  H   THR   104       2.391  11.714  -8.001  1.00 37.41           H  
ATOM   1575  HA  THR   104      -0.262  10.545  -8.531  1.00 50.10           H  
ATOM   1576  HB  THR   104      -0.380  12.111 -10.439  1.00 22.41           H  
ATOM   1577  HG1 THR   104       1.423  12.956 -11.139  1.00 11.44           H  
ATOM   1578 HG21 THR   104       0.356  13.430  -7.814  1.00 37.41           H  
ATOM   1579 HG22 THR   104      -1.245  12.854  -8.280  1.00 37.41           H  
ATOM   1580 HG23 THR   104      -0.512  14.208  -9.140  1.00 37.41           H  
ATOM   1581  N   THR   105       2.415   9.529  -9.891  1.00 14.23           N  
ATOM   1582  CA  THR   105       3.013   8.591 -10.854  1.00 20.42           C  
ATOM   1583  C   THR   105       2.410   7.184 -10.712  1.00 74.13           C  
ATOM   1584  O   THR   105       2.790   6.416  -9.825  1.00 51.22           O  
ATOM   1585  CB  THR   105       4.554   8.505 -10.693  1.00 44.42           C  
ATOM   1586  OG1 THR   105       5.134   9.813 -10.815  1.00 24.24           O  
ATOM   1587  CG2 THR   105       5.172   7.579 -11.742  1.00 75.21           C  
ATOM   1588  H   THR   105       2.952   9.843  -9.134  1.00 37.41           H  
ATOM   1589  HA  THR   105       2.800   8.962 -11.848  1.00 23.14           H  
ATOM   1590  HB  THR   105       4.779   8.113  -9.709  1.00 13.31           H  
ATOM   1591  HG1 THR   105       5.239  10.030 -11.749  1.00  0.32           H  
ATOM   1592 HG21 THR   105       4.931   7.940 -12.731  1.00 37.41           H  
ATOM   1593 HG22 THR   105       4.782   6.578 -11.620  1.00 37.41           H  
ATOM   1594 HG23 THR   105       6.247   7.561 -11.620  1.00 37.41           H  
ATOM   1595  N   ILE   106       1.457   6.855 -11.586  1.00 44.22           N  
ATOM   1596  CA  ILE   106       0.781   5.551 -11.555  1.00 73.12           C  
ATOM   1597  C   ILE   106       0.951   4.798 -12.887  1.00 32.44           C  
ATOM   1598  O   ILE   106       0.569   5.296 -13.949  1.00 45.14           O  
ATOM   1599  CB  ILE   106      -0.734   5.710 -11.255  1.00 50.10           C  
ATOM   1600  CG1 ILE   106      -0.945   6.476  -9.937  1.00 42.04           C  
ATOM   1601  CG2 ILE   106      -1.417   4.342 -11.201  1.00 24.13           C  
ATOM   1602  CD1 ILE   106      -2.399   6.734  -9.598  1.00 63.53           C  
ATOM   1603  H   ILE   106       1.195   7.511 -12.268  1.00 37.41           H  
ATOM   1604  HA  ILE   106       1.224   4.963 -10.762  1.00 62.42           H  
ATOM   1605  HB  ILE   106      -1.179   6.273 -12.064  1.00 14.02           H  
ATOM   1606 HG12 ILE   106      -0.517   5.907  -9.125  1.00 37.41           H  
ATOM   1607 HG13 ILE   106      -0.445   7.434 -10.000  1.00 37.41           H  
ATOM   1608 HG21 ILE   106      -2.471   4.473 -11.004  1.00 37.41           H  
ATOM   1609 HG22 ILE   106      -0.976   3.749 -10.415  1.00 37.41           H  
ATOM   1610 HG23 ILE   106      -1.290   3.837 -12.148  1.00 37.41           H  
ATOM   1611 HD11 ILE   106      -2.861   7.300 -10.394  1.00 37.41           H  
ATOM   1612 HD12 ILE   106      -2.460   7.294  -8.678  1.00 37.41           H  
ATOM   1613 HD13 ILE   106      -2.915   5.792  -9.480  1.00 37.41           H  
ATOM   1614  N   LYS   107       1.515   3.593 -12.819  1.00 22.22           N  
ATOM   1615  CA  LYS   107       1.743   2.759 -14.007  1.00 24.23           C  
ATOM   1616  C   LYS   107       0.701   1.631 -14.109  1.00 55.21           C  
ATOM   1617  O   LYS   107       0.537   0.849 -13.173  1.00 60.10           O  
ATOM   1618  CB  LYS   107       3.146   2.138 -13.951  1.00 24.43           C  
ATOM   1619  CG  LYS   107       4.284   3.155 -13.897  1.00  0.22           C  
ATOM   1620  CD  LYS   107       5.643   2.470 -13.746  1.00 71.45           C  
ATOM   1621  CE  LYS   107       6.791   3.473 -13.728  1.00 74.43           C  
ATOM   1622  NZ  LYS   107       6.956   4.166 -15.033  1.00 72.12           N  
ATOM   1623  H   LYS   107       1.794   3.251 -11.944  1.00 37.41           H  
ATOM   1624  HA  LYS   107       1.671   3.389 -14.883  1.00  2.54           H  
ATOM   1625  HB2 LYS   107       3.213   1.511 -13.071  1.00 37.41           H  
ATOM   1626  HB3 LYS   107       3.287   1.521 -14.828  1.00 37.41           H  
ATOM   1627  HG2 LYS   107       4.282   3.731 -14.810  1.00 37.41           H  
ATOM   1628  HG3 LYS   107       4.126   3.813 -13.053  1.00 37.41           H  
ATOM   1629  HD2 LYS   107       5.653   1.912 -12.821  1.00 37.41           H  
ATOM   1630  HD3 LYS   107       5.786   1.791 -14.575  1.00 37.41           H  
ATOM   1631  HE2 LYS   107       6.598   4.212 -12.962  1.00 37.41           H  
ATOM   1632  HE3 LYS   107       7.706   2.948 -13.492  1.00 37.41           H  
ATOM   1633  HZ1 LYS   107       6.062   4.614 -15.319  1.00 37.41           H  
ATOM   1634  HZ2 LYS   107       7.240   3.485 -15.767  1.00 37.41           H  
ATOM   1635  HZ3 LYS   107       7.689   4.900 -14.960  1.00 37.41           H  
ATOM   1636  N   ASP   108      -0.007   1.550 -15.237  1.00 71.14           N  
ATOM   1637  CA  ASP   108      -0.917   0.431 -15.488  1.00 54.31           C  
ATOM   1638  C   ASP   108      -0.181  -0.710 -16.218  1.00 22.43           C  
ATOM   1639  O   ASP   108       0.368  -0.516 -17.308  1.00  0.32           O  
ATOM   1640  CB  ASP   108      -2.132   0.895 -16.310  1.00 64.04           C  
ATOM   1641  CG  ASP   108      -3.160  -0.211 -16.509  1.00 60.11           C  
ATOM   1642  OD1 ASP   108      -2.911  -1.126 -17.321  1.00 25.55           O  
ATOM   1643  OD2 ASP   108      -4.223  -0.178 -15.856  1.00 52.43           O  
ATOM   1644  H   ASP   108       0.073   2.261 -15.910  1.00 37.41           H  
ATOM   1645  HA  ASP   108      -1.265   0.064 -14.531  1.00  2.35           H  
ATOM   1646  HB2 ASP   108      -2.607   1.722 -15.801  1.00 37.41           H  
ATOM   1647  HB3 ASP   108      -1.795   1.228 -17.283  1.00 37.41           H  
ATOM   1648  N   LEU   109      -0.162  -1.889 -15.604  1.00 62.34           N  
ATOM   1649  CA  LEU   109       0.457  -3.083 -16.201  1.00  5.54           C  
ATOM   1650  C   LEU   109      -0.608  -4.150 -16.514  1.00 34.51           C  
ATOM   1651  O   LEU   109      -0.292  -5.320 -16.745  1.00 53.33           O  
ATOM   1652  CB  LEU   109       1.511  -3.663 -15.239  1.00  3.13           C  
ATOM   1653  CG  LEU   109       2.597  -2.676 -14.772  1.00 74.52           C  
ATOM   1654  CD1 LEU   109       3.544  -3.347 -13.782  1.00 30.34           C  
ATOM   1655  CD2 LEU   109       3.368  -2.116 -15.964  1.00 45.23           C  
ATOM   1656  H   LEU   109      -0.561  -1.960 -14.712  1.00 37.41           H  
ATOM   1657  HA  LEU   109       0.938  -2.791 -17.124  1.00 40.53           H  
ATOM   1658  HB2 LEU   109       0.999  -4.041 -14.364  1.00 37.41           H  
ATOM   1659  HB3 LEU   109       2.000  -4.493 -15.732  1.00 37.41           H  
ATOM   1660  HG  LEU   109       2.122  -1.847 -14.264  1.00 50.13           H  
ATOM   1661 HD11 LEU   109       4.065  -4.160 -14.269  1.00 37.41           H  
ATOM   1662 HD12 LEU   109       2.977  -3.734 -12.948  1.00 37.41           H  
ATOM   1663 HD13 LEU   109       4.262  -2.624 -13.421  1.00 37.41           H  
ATOM   1664 HD21 LEU   109       2.687  -1.608 -16.630  1.00 37.41           H  
ATOM   1665 HD22 LEU   109       3.852  -2.925 -16.494  1.00 37.41           H  
ATOM   1666 HD23 LEU   109       4.117  -1.419 -15.616  1.00 37.41           H  
ATOM   1667  N   THR   110      -1.872  -3.731 -16.530  1.00  1.33           N  
ATOM   1668  CA  THR   110      -2.999  -4.655 -16.729  1.00 62.42           C  
ATOM   1669  C   THR   110      -3.425  -4.709 -18.201  1.00 13.21           C  
ATOM   1670  O   THR   110      -3.577  -5.787 -18.780  1.00 25.20           O  
ATOM   1671  CB  THR   110      -4.222  -4.245 -15.871  1.00  1.14           C  
ATOM   1672  OG1 THR   110      -4.816  -3.037 -16.381  1.00 74.21           O  
ATOM   1673  CG2 THR   110      -3.816  -4.028 -14.418  1.00 41.22           C  
ATOM   1674  H   THR   110      -2.054  -2.773 -16.421  1.00 37.41           H  
ATOM   1675  HA  THR   110      -2.684  -5.642 -16.420  1.00 10.12           H  
ATOM   1676  HB  THR   110      -4.954  -5.040 -15.907  1.00 33.15           H  
ATOM   1677  HG1 THR   110      -4.211  -2.293 -16.242  1.00  4.31           H  
ATOM   1678 HG21 THR   110      -4.673  -3.694 -13.851  1.00 37.41           H  
ATOM   1679 HG22 THR   110      -3.039  -3.277 -14.368  1.00 37.41           H  
ATOM   1680 HG23 THR   110      -3.449  -4.955 -14.001  1.00 37.41           H  
END
