
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   42 (  335),  selected   42 , name 2ay0_B
# Molecule2: number of CA atoms   40 (  676),  selected   40 , name T0474.pdb
# PARAMETERS: 2ay0_B.T0474.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     3_B      M       9          1.901
LGA    T     4_B      G      10          1.233
LGA    T     5_B      R      11          0.856
LGA    M     6_B      I      12          0.706
LGA    G     7_B      L      13          0.494
LGA    V     8_B      L      14          0.391
LGA    M     9_B      D      15          0.321
LGA    L    10_B      L      16          0.970
LGA    D    11_B      S      17          0.378
LGA    D    12_B      N      18          0.313
LGA    A    13_B      E      19          0.571
LGA    T    14_B      V      20          0.589
LGA    R    15_B      I      21          0.966
LGA    E    16_B      K      22          0.967
LGA    R    17_B      Q      23          0.404
LGA    I    18_B      L      24          0.686
LGA    K    19_B      D      25          1.182
LGA    S    20_B      D      26          0.844
LGA    A    21_B      L      27          0.696
LGA    A    22_B      E      28          1.555
LGA    T    23_B      V      29          1.361
LGA    R    24_B      Q      30          0.820
LGA    I    25_B      R      31          1.499
LGA    D    26_B      N      32          1.468
LGA    R    27_B      L      33          1.164
LGA    T    28_B      P      34          1.276
LGA    P    29_B      R      35          0.822
LGA    H    30_B      A      36          0.811
LGA    W    31_B      D      37          0.842
LGA    L    32_B      L      38          0.701
LGA    I    33_B      L      39          0.499
LGA    K    34_B      R      40          0.625
LGA    Q    35_B      E      41          0.948
LGA    A    36_B      A      42          0.517
LGA    I    37_B      V      43          0.611
LGA    F    38_B      D      44          0.608
LGA    S    39_B      Q      45          0.658
LGA    Y    40_B      Y      46          0.492
LGA    L    41_B      L      47          0.637
LGA    E    42_B      I      48          0.894
LGA    Q    43_B      -       -           -
LGA    L    44_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   42   40    5.0     40    0.91    12.50     98.037     3.961

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.485205 * X  +   0.673948 * Y  +   0.557109 * Z  + -33.055950
  Y_new =  -0.850183 * X  +  -0.512526 * Y  +  -0.120440 * Z  +  31.838949
  Z_new =   0.204363 * X  +  -0.532083 * Y  +   0.821659 * Z  +  12.147218 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.574666    2.566927  [ DEG:   -32.9259    147.0741 ]
  Theta =  -0.205813   -2.935780  [ DEG:   -11.7922   -168.2078 ]
  Phi   =  -2.089398    1.052195  [ DEG:  -119.7137     60.2863 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ay0_B                                        
REMARK     2: T0474.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ay0_B.T0474.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   42   40   5.0   40   0.91   12.50  98.037
REMARK  ---------------------------------------------------------- 
MOLECULE 2ay0_B
HEADER    DNA BINDING PROTEIN                     06-SEP-05   2AY0              
TITLE     STRUCTURE OF THE LYS9MET MUTANT OF THE E. COLI PROLINE                
TITLE    2 UTILIZATION A (PUTA) DNA-BINDING DOMAIN.                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BIFUNCTIONAL PUTA PROTEIN;                                 
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: RESIDUES 1-52;                                             
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PUTA, POAA;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21DE3 PLYSS;                             
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET23B                                    
KEYWDS    PUTA, RIBBON-HELIX-HELIX, DNA-BINDING DOMAIN, PROLINE                 
KEYWDS   2 CATABOLISM, PROLINE UTILIZATION A                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.D.LARSON,J.P.SCHUERMANN,Y.ZHOU,J.L.JENKINS,D.F.BECKER,              
AUTHOR   2 J.J.TANNER                                                           
REVDAT   2   05-DEC-06 2AY0    1       JRNL                                     
REVDAT   1   15-AUG-06 2AY0    0                                                
JRNL        AUTH   J.D.LARSON,J.L.JENKINS,J.P.SCHUERMANN,Y.ZHOU,                
JRNL        AUTH 2 D.F.BECKER,J.J.TANNER                                        
JRNL        TITL   CRYSTAL STRUCTURES OF THE DNA-BINDING DOMAIN OF              
JRNL        TITL 2 ESCHERICHIA COLI PROLINE UTILIZATION A                       
JRNL        TITL 3 FLAVOPROTEIN AND ANALYSIS OF THE ROLE OF LYS9 IN             
JRNL        TITL 4 DNA RECOGNITION.                                             
JRNL        REF    PROTEIN SCI.                  V.  15  2630 2006              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2AY0 A    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 B    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 C    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 D    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 E    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 F    1    52  UNP    P09546   PUTA_ECOLI       1     52             
SEQRES   1 A   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 A   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 A   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 A   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 A   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 B   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 B   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 B   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 B   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 B   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 C   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 C   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 C   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 C   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 C   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 D   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 D   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 D   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 D   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 D   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 E   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 E   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 E   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 E   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 E   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 F   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 F   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 F   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 F   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 F   58  HIS HIS HIS HIS HIS HIS                                      
HET     CL      1       1                                                       
HET     CL      2       1                                                       
HET     CL      3       1                                                       
HET     CL      4       1                                                       
HET     CL      5       1                                                       
HET     CL      6       1                                                       
HETNAM      CL CHLORIDE ION                                                     
FORMUL   7   CL    6(CL 1-)                                                     
FORMUL  13  HOH   *67(H2 O)                                                     
CRYST1   72.070   91.494   69.606  90.00 119.21  90.00 C 1 2 1      24          
ATOM    345  N   THR B   3     -15.824 -13.472   4.459  1.00 47.08           N  
ATOM    346  CA  THR B   3     -14.438 -13.150   4.909  1.00 47.45           C  
ATOM    347  C   THR B   3     -13.394 -13.989   4.188  1.00 47.11           C  
ATOM    348  O   THR B   3     -13.644 -15.143   3.847  1.00 47.29           O  
ATOM    349  CB  THR B   3     -14.264 -13.349   6.430  1.00 47.56           C  
ATOM    350  OG1 THR B   3     -15.274 -12.610   7.118  1.00 49.26           O  
ATOM    351  CG2 THR B   3     -12.889 -12.872   6.907  1.00 47.24           C  
ATOM    352  N   THR B   4     -12.231 -13.382   3.955  1.00 46.59           N  
ATOM    353  CA  THR B   4     -11.073 -14.068   3.381  1.00 46.06           C  
ATOM    354  C   THR B   4      -9.806 -13.502   4.016  1.00 45.12           C  
ATOM    355  O   THR B   4      -9.844 -12.468   4.692  1.00 44.95           O  
ATOM    356  CB  THR B   4     -11.004 -13.911   1.842  1.00 46.10           C  
ATOM    357  OG1 THR B   4     -11.032 -12.523   1.486  1.00 47.21           O  
ATOM    358  CG2 THR B   4     -12.165 -14.618   1.175  1.00 46.73           C  
ATOM    359  N   THR B   5      -8.689 -14.190   3.822  1.00 44.15           N  
ATOM    360  CA  THR B   5      -7.403 -13.713   4.320  1.00 43.50           C  
ATOM    361  C   THR B   5      -6.446 -13.518   3.153  1.00 42.75           C  
ATOM    362  O   THR B   5      -6.204 -14.453   2.380  1.00 42.57           O  
ATOM    363  CB  THR B   5      -6.799 -14.675   5.354  1.00 43.62           C  
ATOM    364  OG1 THR B   5      -7.655 -14.729   6.503  1.00 43.49           O  
ATOM    365  CG2 THR B   5      -5.412 -14.187   5.810  1.00 43.80           C  
ATOM    366  N   MET B   6      -5.953 -12.288   3.013  1.00 41.45           N  
ATOM    367  CA  MET B   6      -4.909 -11.946   2.051  1.00 41.03           C  
ATOM    368  C   MET B   6      -3.556 -11.846   2.763  1.00 40.71           C  
ATOM    369  O   MET B   6      -3.498 -11.525   3.948  1.00 40.20           O  
ATOM    370  CB  MET B   6      -5.211 -10.602   1.390  1.00 41.09           C  
ATOM    371  CG  MET B   6      -6.298 -10.644   0.320  1.00 42.14           C  
ATOM    372  SD  MET B   6      -6.608  -9.047  -0.495  1.00 41.17           S  
ATOM    373  CE  MET B   6      -4.951  -8.574  -0.932  1.00 42.89           C  
ATOM    374  N   GLY B   7      -2.478 -12.123   2.033  1.00 40.06           N  
ATOM    375  CA  GLY B   7      -1.129 -11.973   2.560  1.00 39.84           C  
ATOM    376  C   GLY B   7      -0.625 -10.553   2.373  1.00 39.41           C  
ATOM    377  O   GLY B   7      -0.914  -9.923   1.353  1.00 40.02           O  
ATOM    378  N   VAL B   8       0.108 -10.052   3.366  1.00 38.79           N  
ATOM    379  CA  VAL B   8       0.842  -8.778   3.282  1.00 38.50           C  
ATOM    380  C   VAL B   8       2.339  -9.054   3.476  1.00 37.86           C  
ATOM    381  O   VAL B   8       2.745  -9.546   4.526  1.00 36.88           O  
ATOM    382  CB  VAL B   8       0.392  -7.773   4.385  1.00 38.22           C  
ATOM    383  CG1 VAL B   8       0.964  -6.414   4.125  1.00 38.75           C  
ATOM    384  CG2 VAL B   8      -1.114  -7.687   4.454  1.00 39.56           C  
ATOM    385  N   MET B   9       3.161  -8.728   2.475  1.00 37.63           N  
ATOM    386  CA  MET B   9       4.613  -8.857   2.609  1.00 36.74           C  
ATOM    387  C   MET B   9       5.172  -7.597   3.264  1.00 37.95           C  
ATOM    388  O   MET B   9       4.934  -6.493   2.779  1.00 38.11           O  
ATOM    389  CB  MET B   9       5.270  -9.064   1.256  1.00 37.13           C  
ATOM    390  CG  MET B   9       4.900 -10.378   0.567  1.00 37.32           C  
ATOM    391  SD  MET B   9       5.717 -10.567  -1.033  1.00 32.37           S  
ATOM    392  CE  MET B   9       7.344 -10.930  -0.469  1.00 33.32           C  
ATOM    393  N   LEU B  10       5.927  -7.773   4.349  1.00 38.67           N  
ATOM    394  CA  LEU B  10       6.501  -6.666   5.132  1.00 39.34           C  
ATOM    395  C   LEU B  10       8.009  -6.841   5.302  1.00 39.57           C  
ATOM    396  O   LEU B  10       8.440  -7.885   5.778  1.00 39.69           O  
ATOM    397  CB  LEU B  10       5.874  -6.639   6.531  1.00 39.63           C  
ATOM    398  CG  LEU B  10       4.378  -6.344   6.646  1.00 40.47           C  
ATOM    399  CD1 LEU B  10       3.909  -6.636   8.042  1.00 41.01           C  
ATOM    400  CD2 LEU B  10       4.069  -4.906   6.268  1.00 40.64           C  
ATOM    401  N   ASP B  11       8.805  -5.831   4.936  1.00 39.96           N  
ATOM    402  CA  ASP B  11      10.246  -5.853   5.240  1.00 40.22           C  
ATOM    403  C   ASP B  11      10.399  -5.595   6.749  1.00 40.06           C  
ATOM    404  O   ASP B  11       9.482  -5.064   7.392  1.00 39.69           O  
ATOM    405  CB  ASP B  11      11.058  -4.915   4.293  1.00 40.87           C  
ATOM    406  CG  ASP B  11      11.707  -3.713   4.991  1.00 41.95           C  
ATOM    407  OD1 ASP B  11      10.984  -2.798   5.428  1.00 45.68           O  
ATOM    408  OD2 ASP B  11      12.964  -3.661   5.048  1.00 43.66           O  
ATOM    409  N   ASP B  12      11.503  -6.047   7.337  1.00 39.60           N  
ATOM    410  CA  ASP B  12      11.595  -6.092   8.808  1.00 39.60           C  
ATOM    411  C   ASP B  12      11.525  -4.718   9.470  1.00 38.94           C  
ATOM    412  O   ASP B  12      10.952  -4.598  10.538  1.00 38.64           O  
ATOM    413  CB  ASP B  12      12.831  -6.872   9.271  1.00 39.79           C  
ATOM    414  CG  ASP B  12      12.749  -8.356   8.922  1.00 41.26           C  
ATOM    415  OD1 ASP B  12      11.636  -8.859   8.620  1.00 43.28           O  
ATOM    416  OD2 ASP B  12      13.799  -9.020   8.939  1.00 41.68           O  
ATOM    417  N   ALA B  13      12.054  -3.686   8.813  1.00 38.36           N  
ATOM    418  CA  ALA B  13      11.941  -2.311   9.316  1.00 38.24           C  
ATOM    419  C   ALA B  13      10.482  -1.850   9.458  1.00 38.34           C  
ATOM    420  O   ALA B  13      10.113  -1.234  10.463  1.00 38.06           O  
ATOM    421  CB  ALA B  13      12.724  -1.350   8.416  1.00 38.24           C  
ATOM    422  N   THR B  14       9.653  -2.161   8.463  1.00 38.54           N  
ATOM    423  CA  THR B  14       8.245  -1.773   8.493  1.00 38.62           C  
ATOM    424  C   THR B  14       7.507  -2.534   9.579  1.00 39.03           C  
ATOM    425  O   THR B  14       6.668  -1.992  10.274  1.00 38.30           O  
ATOM    426  CB  THR B  14       7.540  -2.071   7.161  1.00 38.34           C  
ATOM    427  OG1 THR B  14       8.296  -1.510   6.095  1.00 37.71           O  
ATOM    428  CG2 THR B  14       6.128  -1.500   7.155  1.00 39.06           C  
ATOM    429  N   ARG B  15       7.811  -3.815   9.692  1.00 39.96           N  
ATOM    430  CA  ARG B  15       7.171  -4.632  10.696  1.00 40.81           C  
ATOM    431  C   ARG B  15       7.500  -4.150  12.117  1.00 40.53           C  
ATOM    432  O   ARG B  15       6.623  -4.120  12.967  1.00 40.14           O  
ATOM    433  CB  ARG B  15       7.565  -6.091  10.496  1.00 41.25           C  
ATOM    434  CG  ARG B  15       6.810  -7.014  11.399  1.00 44.81           C  
ATOM    435  CD  ARG B  15       6.584  -8.371  10.745  1.00 49.91           C  
ATOM    436  NE  ARG B  15       5.908  -9.278  11.669  1.00 51.57           N  
ATOM    437  CZ  ARG B  15       5.419 -10.476  11.352  1.00 52.04           C  
ATOM    438  NH1 ARG B  15       5.508 -10.956  10.117  1.00 51.63           N  
ATOM    439  NH2 ARG B  15       4.830 -11.195  12.298  1.00 52.63           N  
ATOM    440  N   GLU B  16       8.756  -3.772  12.361  1.00 40.47           N  
ATOM    441  CA  GLU B  16       9.173  -3.199  13.659  1.00 40.99           C  
ATOM    442  C   GLU B  16       8.461  -1.870  13.938  1.00 40.29           C  
ATOM    443  O   GLU B  16       8.037  -1.592  15.070  1.00 38.61           O  
ATOM    444  CB  GLU B  16      10.705  -2.990  13.679  1.00 41.21           C  
ATOM    445  CG  GLU B  16      11.486  -4.283  13.837  1.00 42.55           C  
ATOM    446  CD  GLU B  16      12.939  -4.192  13.407  1.00 43.76           C  
ATOM    447  OE1 GLU B  16      13.427  -3.083  13.055  1.00 48.05           O  
ATOM    448  OE2 GLU B  16      13.617  -5.249  13.421  1.00 48.74           O  
ATOM    449  N   ARG B  17       8.345  -1.052  12.892  1.00 40.63           N  
ATOM    450  CA  ARG B  17       7.611   0.210  12.955  1.00 41.30           C  
ATOM    451  C   ARG B  17       6.157  -0.013  13.324  1.00 40.24           C  
ATOM    452  O   ARG B  17       5.638   0.655  14.208  1.00 38.84           O  
ATOM    453  CB  ARG B  17       7.661   0.930  11.612  1.00 41.80           C  
ATOM    454  CG  ARG B  17       7.446   2.439  11.713  1.00 43.72           C  
ATOM    455  CD  ARG B  17       7.984   3.158  10.480  1.00 43.96           C  
ATOM    456  NE  ARG B  17       9.391   2.826  10.226  1.00 47.56           N  
ATOM    457  CZ  ARG B  17      10.452   3.490  10.700  1.00 47.31           C  
ATOM    458  NH1 ARG B  17      11.674   3.070  10.382  1.00 46.72           N  
ATOM    459  NH2 ARG B  17      10.315   4.555  11.494  1.00 48.03           N  
ATOM    460  N   ILE B  18       5.506  -0.934  12.618  1.00 40.31           N  
ATOM    461  CA  ILE B  18       4.107  -1.293  12.893  1.00 40.78           C  
ATOM    462  C   ILE B  18       3.942  -1.778  14.348  1.00 40.89           C  
ATOM    463  O   ILE B  18       3.002  -1.384  15.059  1.00 41.14           O  
ATOM    464  CB  ILE B  18       3.630  -2.413  11.934  1.00 40.83           C  
ATOM    465  CG1 ILE B  18       3.381  -1.847  10.524  1.00 41.69           C  
ATOM    466  CG2 ILE B  18       2.359  -3.069  12.450  1.00 41.55           C  
ATOM    467  CD1 ILE B  18       3.219  -2.921   9.452  1.00 41.15           C  
ATOM    468  N   LYS B  19       4.843  -2.661  14.767  1.00 40.66           N  
ATOM    469  CA  LYS B  19       4.805  -3.214  16.119  1.00 40.73           C  
ATOM    470  C   LYS B  19       5.006  -2.108  17.164  1.00 39.66           C  
ATOM    471  O   LYS B  19       4.305  -2.076  18.169  1.00 39.75           O  
ATOM    472  CB  LYS B  19       5.843  -4.336  16.261  1.00 41.11           C  
ATOM    473  CG  LYS B  19       5.980  -4.945  17.668  1.00 42.42           C  
ATOM    474  CD  LYS B  19       4.656  -5.596  18.152  1.00 44.50           C  
ATOM    475  CE  LYS B  19       4.929  -6.716  19.206  1.00 43.41           C  
ATOM    476  N   SER B  20       5.907  -1.172  16.898  1.00 38.76           N  
ATOM    477  CA  SER B  20       6.178  -0.066  17.813  1.00 38.59           C  
ATOM    478  C   SER B  20       5.008   0.919  17.895  1.00 38.73           C  
ATOM    479  O   SER B  20       4.646   1.386  18.987  1.00 38.28           O  
ATOM    480  CB  SER B  20       7.453   0.677  17.372  1.00 39.04           C  
ATOM    481  OG  SER B  20       7.832   1.635  18.341  1.00 39.35           O  
ATOM    482  N   ALA B  21       4.426   1.247  16.740  1.00 37.93           N  
ATOM    483  CA  ALA B  21       3.296   2.166  16.687  1.00 38.10           C  
ATOM    484  C   ALA B  21       2.064   1.549  17.355  1.00 38.62           C  
ATOM    485  O   ALA B  21       1.289   2.221  18.024  1.00 38.42           O  
ATOM    486  CB  ALA B  21       2.989   2.552  15.235  1.00 38.16           C  
ATOM    487  N   ALA B  22       1.865   0.254  17.153  1.00 38.88           N  
ATOM    488  CA  ALA B  22       0.731  -0.419  17.751  1.00 38.91           C  
ATOM    489  C   ALA B  22       0.916  -0.545  19.270  1.00 39.31           C  
ATOM    490  O   ALA B  22       0.014  -0.234  20.034  1.00 40.78           O  
ATOM    491  CB  ALA B  22       0.559  -1.777  17.130  1.00 38.91           C  
ATOM    492  N   THR B  23       2.063  -1.040  19.696  1.00 39.46           N  
ATOM    493  CA  THR B  23       2.301  -1.320  21.117  1.00 39.84           C  
ATOM    494  C   THR B  23       2.146  -0.070  22.002  1.00 38.56           C  
ATOM    495  O   THR B  23       1.593  -0.149  23.088  1.00 37.96           O  
ATOM    496  CB  THR B  23       3.706  -1.935  21.369  1.00 39.76           C  
ATOM    497  OG1 THR B  23       4.693  -1.103  20.779  1.00 42.12           O  
ATOM    498  CG2 THR B  23       3.830  -3.311  20.748  1.00 40.27           C  
ATOM    499  N   ARG B  24       2.625   1.077  21.524  1.00 38.34           N  
ATOM    500  CA  ARG B  24       2.587   2.306  22.317  1.00 38.12           C  
ATOM    501  C   ARG B  24       1.180   2.812  22.645  1.00 37.86           C  
ATOM    502  O   ARG B  24       1.011   3.600  23.574  1.00 36.66           O  
ATOM    503  CB  ARG B  24       3.398   3.406  21.647  1.00 38.45           C  
ATOM    504  CG  ARG B  24       2.886   3.880  20.332  1.00 38.91           C  
ATOM    505  CD  ARG B  24       3.926   4.757  19.676  1.00 39.46           C  
ATOM    506  NE  ARG B  24       3.920   6.058  20.316  1.00 42.22           N  
ATOM    507  N   ILE B  25       0.186   2.317  21.900  1.00 38.42           N  
ATOM    508  CA  ILE B  25      -1.226   2.636  22.129  1.00 38.57           C  
ATOM    509  C   ILE B  25      -2.028   1.378  22.509  1.00 38.82           C  
ATOM    510  O   ILE B  25      -3.244   1.353  22.342  1.00 38.53           O  
ATOM    511  CB  ILE B  25      -1.886   3.345  20.879  1.00 38.57           C  
ATOM    512  CG1 ILE B  25      -1.751   2.489  19.616  1.00 37.47           C  
ATOM    513  CG2 ILE B  25      -1.268   4.709  20.644  1.00 38.64           C  
ATOM    514  CD1 ILE B  25      -2.394   3.082  18.379  1.00 39.30           C  
ATOM    515  N   ASP B  26      -1.358   0.345  23.032  1.00 38.53           N  
ATOM    516  CA  ASP B  26      -2.039  -0.843  23.559  1.00 38.83           C  
ATOM    517  C   ASP B  26      -2.855  -1.610  22.512  1.00 39.51           C  
ATOM    518  O   ASP B  26      -3.899  -2.226  22.832  1.00 39.26           O  
ATOM    519  CB  ASP B  26      -2.966  -0.492  24.742  1.00 38.62           C  
ATOM    520  CG  ASP B  26      -2.231  -0.327  26.061  1.00 39.03           C  
ATOM    521  OD1 ASP B  26      -1.154  -0.929  26.270  1.00 37.93           O  
ATOM    522  OD2 ASP B  26      -2.789   0.380  26.918  1.00 39.86           O  
ATOM    523  N   ARG B  27      -2.355  -1.599  21.278  1.00 39.98           N  
ATOM    524  CA  ARG B  27      -2.971  -2.321  20.160  1.00 39.57           C  
ATOM    525  C   ARG B  27      -1.969  -3.286  19.504  1.00 39.68           C  
ATOM    526  O   ARG B  27      -0.790  -3.356  19.891  1.00 40.36           O  
ATOM    527  CB  ARG B  27      -3.492  -1.302  19.125  1.00 39.85           C  
ATOM    528  CG  ARG B  27      -4.601  -0.388  19.622  1.00 37.68           C  
ATOM    529  CD  ARG B  27      -5.744  -1.162  20.128  1.00 36.75           C  
ATOM    530  NE  ARG B  27      -6.897  -0.355  20.512  1.00 35.29           N  
ATOM    531  CZ  ARG B  27      -7.152   0.073  21.751  1.00 36.25           C  
ATOM    532  NH1 ARG B  27      -6.331  -0.174  22.757  1.00 36.68           N  
ATOM    533  NH2 ARG B  27      -8.249   0.765  21.991  1.00 36.57           N  
ATOM    534  N   THR B  28      -2.424  -3.992  18.484  1.00 39.54           N  
ATOM    535  CA  THR B  28      -1.625  -5.031  17.810  1.00 39.31           C  
ATOM    536  C   THR B  28      -1.349  -4.651  16.362  1.00 40.19           C  
ATOM    537  O   THR B  28      -2.057  -3.819  15.790  1.00 41.10           O  
ATOM    538  CB  THR B  28      -2.361  -6.376  17.806  1.00 39.23           C  
ATOM    539  OG1 THR B  28      -3.682  -6.225  17.224  1.00 37.92           O  
ATOM    540  CG2 THR B  28      -2.469  -6.931  19.217  1.00 38.54           C  
ATOM    541  N   PRO B  29      -0.306  -5.253  15.758  1.00 40.11           N  
ATOM    542  CA  PRO B  29      -0.103  -5.126  14.322  1.00 39.58           C  
ATOM    543  C   PRO B  29      -1.356  -5.407  13.468  1.00 39.28           C  
ATOM    544  O   PRO B  29      -1.644  -4.652  12.567  1.00 40.53           O  
ATOM    545  CB  PRO B  29       0.990  -6.155  14.043  1.00 39.40           C  
ATOM    546  CG  PRO B  29       1.793  -6.189  15.318  1.00 39.64           C  
ATOM    547  CD  PRO B  29       0.752  -6.074  16.395  1.00 40.00           C  
ATOM    548  N   HIS B  30      -2.091  -6.476  13.722  1.00 39.17           N  
ATOM    549  CA  HIS B  30      -3.304  -6.729  12.925  1.00 38.96           C  
ATOM    550  C   HIS B  30      -4.345  -5.607  13.039  1.00 38.50           C  
ATOM    551  O   HIS B  30      -4.991  -5.226  12.046  1.00 37.64           O  
ATOM    552  CB  HIS B  30      -3.946  -8.033  13.324  1.00 38.41           C  
ATOM    553  CG  HIS B  30      -3.220  -9.242  12.827  1.00 38.52           C  
ATOM    554  ND1 HIS B  30      -2.923 -10.314  13.639  1.00 37.69           N  
ATOM    555  CD2 HIS B  30      -2.763  -9.566  11.595  1.00 37.44           C  
ATOM    556  CE1 HIS B  30      -2.313 -11.243  12.925  1.00 35.91           C  
ATOM    557  NE2 HIS B  30      -2.208 -10.816  11.683  1.00 37.04           N  
ATOM    558  N   TRP B  31      -4.489  -5.073  14.248  1.00 38.25           N  
ATOM    559  CA  TRP B  31      -5.387  -3.946  14.515  1.00 38.21           C  
ATOM    560  C   TRP B  31      -4.984  -2.757  13.674  1.00 38.68           C  
ATOM    561  O   TRP B  31      -5.833  -2.144  13.033  1.00 38.81           O  
ATOM    562  CB  TRP B  31      -5.392  -3.582  16.000  1.00 37.72           C  
ATOM    563  CG  TRP B  31      -6.220  -2.390  16.374  1.00 37.31           C  
ATOM    564  CD1 TRP B  31      -7.514  -2.396  16.832  1.00 37.52           C  
ATOM    565  CD2 TRP B  31      -5.816  -1.013  16.348  1.00 38.24           C  
ATOM    566  NE1 TRP B  31      -7.930  -1.116  17.087  1.00 36.95           N  
ATOM    567  CE2 TRP B  31      -6.918  -0.246  16.773  1.00 37.42           C  
ATOM    568  CE3 TRP B  31      -4.631  -0.351  15.982  1.00 38.03           C  
ATOM    569  CZ2 TRP B  31      -6.869   1.148  16.864  1.00 38.51           C  
ATOM    570  CZ3 TRP B  31      -4.590   1.010  16.068  1.00 37.56           C  
ATOM    571  CH2 TRP B  31      -5.700   1.753  16.519  1.00 38.26           C  
ATOM    572  N   LEU B  32      -3.692  -2.449  13.672  1.00 39.66           N  
ATOM    573  CA  LEU B  32      -3.138  -1.271  12.982  1.00 40.62           C  
ATOM    574  C   LEU B  32      -3.353  -1.338  11.482  1.00 40.11           C  
ATOM    575  O   LEU B  32      -3.631  -0.335  10.820  1.00 39.95           O  
ATOM    576  CB  LEU B  32      -1.627  -1.189  13.297  1.00 40.33           C  
ATOM    577  CG  LEU B  32      -0.515  -0.216  12.838  1.00 42.61           C  
ATOM    578  CD1 LEU B  32      -0.531   0.170  11.347  1.00 43.76           C  
ATOM    579  CD2 LEU B  32      -0.399   1.007  13.706  1.00 45.41           C  
ATOM    580  N   ILE B  33      -3.161  -2.527  10.946  1.00 40.61           N  
ATOM    581  CA  ILE B  33      -3.236  -2.744   9.517  1.00 40.88           C  
ATOM    582  C   ILE B  33      -4.662  -2.579   9.069  1.00 40.27           C  
ATOM    583  O   ILE B  33      -4.933  -2.012   8.018  1.00 40.47           O  
ATOM    584  CB  ILE B  33      -2.681  -4.138   9.131  1.00 41.15           C  
ATOM    585  CG1 ILE B  33      -1.151  -4.127   9.284  1.00 41.43           C  
ATOM    586  CG2 ILE B  33      -3.091  -4.514   7.685  1.00 41.13           C  
ATOM    587  CD1 ILE B  33      -0.521  -5.516   9.214  1.00 42.23           C  
ATOM    588  N   LYS B  34      -5.592  -3.099   9.850  1.00 40.06           N  
ATOM    589  CA  LYS B  34      -6.988  -2.878   9.527  1.00 39.43           C  
ATOM    590  C   LYS B  34      -7.320  -1.390   9.635  1.00 38.80           C  
ATOM    591  O   LYS B  34      -8.002  -0.859   8.764  1.00 38.34           O  
ATOM    592  CB  LYS B  34      -7.908  -3.750  10.378  1.00 38.74           C  
ATOM    593  CG  LYS B  34      -7.859  -5.245  10.017  1.00 40.31           C  
ATOM    594  CD  LYS B  34      -8.095  -5.581   8.510  1.00 41.00           C  
ATOM    595  CE  LYS B  34      -9.477  -5.227   7.999  1.00 41.05           C  
ATOM    596  NZ  LYS B  34     -10.547  -6.096   8.580  1.00 44.75           N  
ATOM    597  N   GLN B  35      -6.836  -0.716  10.677  1.00 38.50           N  
ATOM    598  CA  GLN B  35      -7.042   0.744  10.779  1.00 38.89           C  
ATOM    599  C   GLN B  35      -6.560   1.494   9.549  1.00 39.22           C  
ATOM    600  O   GLN B  35      -7.280   2.340   9.007  1.00 38.72           O  
ATOM    601  CB  GLN B  35      -6.325   1.333  11.982  1.00 38.92           C  
ATOM    602  CG  GLN B  35      -6.881   0.950  13.301  1.00 40.62           C  
ATOM    603  CD  GLN B  35      -8.315   1.396  13.511  1.00 41.48           C  
ATOM    604  OE1 GLN B  35      -9.213   0.569  13.705  1.00 42.46           O  
ATOM    605  NE2 GLN B  35      -8.537   2.713  13.489  1.00 41.71           N  
ATOM    606  N   ALA B  36      -5.330   1.182   9.135  1.00 38.94           N  
ATOM    607  CA  ALA B  36      -4.714   1.750   7.950  1.00 38.98           C  
ATOM    608  C   ALA B  36      -5.584   1.590   6.717  1.00 39.00           C  
ATOM    609  O   ALA B  36      -5.863   2.565   6.012  1.00 38.87           O  
ATOM    610  CB  ALA B  36      -3.366   1.089   7.705  1.00 38.96           C  
ATOM    611  N   ILE B  37      -6.010   0.360   6.459  1.00 38.50           N  
ATOM    612  CA  ILE B  37      -6.847   0.063   5.298  1.00 38.95           C  
ATOM    613  C   ILE B  37      -8.181   0.817   5.308  1.00 39.93           C  
ATOM    614  O   ILE B  37      -8.613   1.365   4.291  1.00 39.23           O  
ATOM    615  CB  ILE B  37      -7.123  -1.456   5.191  1.00 38.64           C  
ATOM    616  CG1 ILE B  37      -5.834  -2.217   4.814  1.00 39.27           C  
ATOM    617  CG2 ILE B  37      -8.206  -1.742   4.179  1.00 38.73           C  
ATOM    618  CD1 ILE B  37      -5.926  -3.719   5.041  1.00 39.14           C  
ATOM    619  N   PHE B  38      -8.860   0.813   6.449  1.00 41.35           N  
ATOM    620  CA  PHE B  38     -10.155   1.483   6.521  1.00 42.23           C  
ATOM    621  C   PHE B  38     -10.016   2.986   6.426  1.00 42.10           C  
ATOM    622  O   PHE B  38     -10.785   3.627   5.712  1.00 41.39           O  
ATOM    623  CB  PHE B  38     -10.922   1.063   7.766  1.00 43.33           C  
ATOM    624  CG  PHE B  38     -11.710  -0.181   7.556  1.00 45.04           C  
ATOM    625  CD1 PHE B  38     -11.253  -1.404   8.033  1.00 47.38           C  
ATOM    626  CD2 PHE B  38     -12.893  -0.140   6.832  1.00 46.41           C  
ATOM    627  CE1 PHE B  38     -11.986  -2.568   7.817  1.00 47.05           C  
ATOM    628  CE2 PHE B  38     -13.624  -1.293   6.599  1.00 47.73           C  
ATOM    629  CZ  PHE B  38     -13.166  -2.517   7.099  1.00 47.04           C  
ATOM    630  N   SER B  39      -9.044   3.527   7.154  1.00 42.21           N  
ATOM    631  CA  SER B  39      -8.702   4.942   7.079  1.00 42.72           C  
ATOM    632  C   SER B  39      -8.474   5.362   5.625  1.00 42.50           C  
ATOM    633  O   SER B  39      -9.009   6.369   5.176  1.00 42.65           O  
ATOM    634  CB  SER B  39      -7.435   5.233   7.897  1.00 42.78           C  
ATOM    635  OG  SER B  39      -6.920   6.525   7.580  1.00 44.36           O  
ATOM    636  N   TYR B  40      -7.681   4.575   4.907  1.00 42.19           N  
ATOM    637  CA  TYR B  40      -7.354   4.850   3.501  1.00 42.61           C  
ATOM    638  C   TYR B  40      -8.614   4.835   2.610  1.00 42.08           C  
ATOM    639  O   TYR B  40      -8.864   5.776   1.865  1.00 41.85           O  
ATOM    640  CB  TYR B  40      -6.302   3.839   3.019  1.00 42.89           C  
ATOM    641  CG  TYR B  40      -5.838   4.037   1.607  1.00 43.60           C  
ATOM    642  CD1 TYR B  40      -4.657   4.722   1.318  1.00 44.05           C  
ATOM    643  CD2 TYR B  40      -6.578   3.533   0.550  1.00 44.52           C  
ATOM    644  CE1 TYR B  40      -4.229   4.899  -0.008  1.00 44.88           C  
ATOM    645  CE2 TYR B  40      -6.175   3.711  -0.758  1.00 45.43           C  
ATOM    646  CZ  TYR B  40      -5.001   4.387  -1.042  1.00 44.98           C  
ATOM    647  OH  TYR B  40      -4.637   4.523  -2.369  1.00 44.65           O  
ATOM    648  N   LEU B  41      -9.412   3.776   2.715  1.00 42.03           N  
ATOM    649  CA  LEU B  41     -10.625   3.639   1.905  1.00 42.36           C  
ATOM    650  C   LEU B  41     -11.655   4.728   2.234  1.00 42.64           C  
ATOM    651  O   LEU B  41     -12.365   5.193   1.356  1.00 42.35           O  
ATOM    652  CB  LEU B  41     -11.257   2.259   2.105  1.00 42.40           C  
ATOM    653  CG  LEU B  41     -10.490   1.045   1.589  1.00 41.08           C  
ATOM    654  CD1 LEU B  41     -11.156  -0.228   2.076  1.00 40.98           C  
ATOM    655  CD2 LEU B  41     -10.385   1.056   0.067  1.00 41.53           C  
ATOM    656  N   GLU B  42     -11.736   5.120   3.502  1.00 43.10           N  
ATOM    657  CA  GLU B  42     -12.580   6.251   3.894  1.00 43.86           C  
ATOM    658  C   GLU B  42     -12.224   7.539   3.161  1.00 43.68           C  
ATOM    659  O   GLU B  42     -13.086   8.174   2.566  1.00 43.96           O  
ATOM    660  CB  GLU B  42     -12.467   6.501   5.390  1.00 43.84           C  
ATOM    661  CG  GLU B  42     -13.318   5.591   6.213  1.00 44.61           C  
ATOM    662  CD  GLU B  42     -13.229   5.933   7.670  1.00 45.06           C  
ATOM    663  OE1 GLU B  42     -12.095   6.031   8.194  1.00 44.70           O  
ATOM    664  OE2 GLU B  42     -14.304   6.120   8.276  1.00 48.35           O  
ATOM    665  N   GLN B  43     -10.952   7.920   3.236  1.00 43.84           N  
ATOM    666  CA  GLN B  43     -10.431   9.128   2.590  1.00 44.04           C  
ATOM    667  C   GLN B  43     -10.758   9.177   1.090  1.00 44.12           C  
ATOM    668  O   GLN B  43     -10.919  10.253   0.525  1.00 44.44           O  
ATOM    669  CB  GLN B  43      -8.919   9.227   2.815  1.00 44.05           C  
ATOM    670  CG  GLN B  43      -8.527   9.501   4.277  1.00 44.66           C  
ATOM    671  CD  GLN B  43      -7.305   8.708   4.728  1.00 45.01           C  
ATOM    672  N   LEU B  44     -10.846   8.009   0.457  1.00 44.17           N  
ATOM    673  CA  LEU B  44     -11.355   7.894  -0.904  1.00 44.17           C  
ATOM    674  C   LEU B  44     -12.842   8.215  -0.915  1.00 44.04           C  
ATOM    675  O   LEU B  44     -13.244   9.226  -1.468  1.00 43.92           O  
ATOM    676  CB  LEU B  44     -11.128   6.480  -1.461  1.00 44.26           C  
ATOM    677  CG  LEU B  44      -9.790   6.156  -2.136  1.00 44.60           C  
ATOM    678  CD1 LEU B  44      -8.630   6.907  -1.515  1.00 44.91           C  
ATOM    679  CD2 LEU B  44      -9.535   4.652  -2.100  1.00 44.39           C  
TER     680      LEU B  44                                                      
END
MOLECULE T0474.pdb
ATOM    111  N   MET     9     -15.513 -13.396   6.798  1.00  1.00
ATOM    112  HN  MET     9     -15.434 -14.281   7.279  1.00  0.00
ATOM    113  CA  MET     9     -14.325 -12.543   6.707  1.00  1.00
ATOM    114  HA  MET     9     -14.565 -11.671   6.099  1.00  0.00
ATOM    115  CB  MET     9     -13.908 -12.081   8.105  1.00  1.00
ATOM    116 2HB  MET     9     -13.830 -12.945   8.766  1.00  0.00
ATOM    117 3HB  MET     9     -12.943 -11.578   8.049  1.00  0.00
ATOM    118  CG  MET     9     -14.958 -11.112   8.652  1.00  1.00
ATOM    119 2HG  MET     9     -15.026 -10.238   8.004  1.00  0.00
ATOM    120 3HG  MET     9     -15.932 -11.601   8.683  1.00  0.00
ATOM    121  SD  MET     9     -14.493 -10.590  10.321  1.00  1.00
ATOM    122  CE  MET     9     -13.435  -9.204   9.838  1.00  1.00
ATOM    123 1HE  MET     9     -13.039  -8.735  10.739  1.00  0.00
ATOM    124 2HE  MET     9     -12.614  -9.570   9.222  1.00  0.00
ATOM    125 3HE  MET     9     -14.020  -8.479   9.272  1.00  0.00
ATOM    126  C   MET     9     -13.176 -13.302   6.057  1.00  1.00
ATOM    127  O   MET     9     -12.801 -14.387   6.505  1.00  1.00
ATOM    128  N   GLY    10     -12.622 -12.725   4.996  1.00  1.00
ATOM    129  HN  GLY    10     -12.966 -11.834   4.669  1.00  0.00
ATOM    130  CA  GLY    10     -11.516 -13.351   4.281  1.00  1.00
ATOM    131 1HA  GLY    10     -11.622 -14.435   4.333  1.00  0.00
ATOM    132 2HA  GLY    10     -11.539 -13.037   3.238  1.00  0.00
ATOM    133  C   GLY    10     -10.188 -12.947   4.897  1.00  1.00
ATOM    134  O   GLY    10     -10.149 -12.229   5.897  1.00  1.00
ATOM    135  N   ARG    11      -9.096 -13.412   4.297  1.00  1.00
ATOM    136  HN  ARG    11      -9.181 -14.000   3.480  1.00  0.00
ATOM    137  CA  ARG    11      -7.763 -13.096   4.791  1.00  1.00
ATOM    138  HA  ARG    11      -7.806 -12.157   5.342  1.00  0.00
ATOM    139  CB  ARG    11      -7.286 -14.202   5.726  1.00  1.00
ATOM    140 2HB  ARG    11      -6.291 -13.959   6.097  1.00  0.00
ATOM    141 3HB  ARG    11      -7.976 -14.289   6.566  1.00  0.00
ATOM    142  CG  ARG    11      -7.236 -15.532   4.970  1.00  1.00
ATOM    143 2HG  ARG    11      -8.221 -15.755   4.560  1.00  0.00
ATOM    144 3HG  ARG    11      -6.512 -15.462   4.158  1.00  0.00
ATOM    145  CD  ARG    11      -6.820 -16.647   5.930  1.00  1.00
ATOM    146 2HD  ARG    11      -5.842 -16.415   6.352  1.00  0.00
ATOM    147 3HD  ARG    11      -7.550 -16.721   6.737  1.00  0.00
ATOM    148  NE  ARG    11      -6.752 -17.919   5.222  1.00  1.00
ATOM    149  HE  ARG    11      -6.699 -17.908   4.213  1.00  0.00
ATOM    150  CZ  ARG    11      -6.759 -19.073   5.880  1.00  1.00
ATOM    151  NH1 ARG    11      -6.698 -20.199   5.223  1.00  1.00
ATOM    152 1HH1 ARG    11      -6.704 -21.076   5.725  1.00  0.00
ATOM    153 2HH1 ARG    11      -6.645 -20.194   4.214  1.00  0.00
ATOM    154  NH2 ARG    11      -6.828 -19.081   7.183  1.00  1.00
ATOM    155 1HH2 ARG    11      -6.834 -19.960   7.681  1.00  0.00
ATOM    156 2HH2 ARG    11      -6.876 -18.210   7.692  1.00  0.00
ATOM    157  C   ARG    11      -6.786 -12.948   3.631  1.00  1.00
ATOM    158  O   ARG    11      -6.886 -13.656   2.628  1.00  1.00
ATOM    159  N   ILE    12      -5.838 -12.024   3.774  1.00  1.00
ATOM    160  HN  ILE    12      -5.799 -11.470   4.618  1.00  0.00
ATOM    161  CA  ILE    12      -4.836 -11.783   2.734  1.00  1.00
ATOM    162  HA  ILE    12      -4.856 -12.613   2.027  1.00  0.00
ATOM    163  CB  ILE    12      -5.149 -10.485   1.993  1.00  1.00
ATOM    164  HB  ILE    12      -5.211  -9.665   2.708  1.00  0.00
ATOM    165  CG2 ILE    12      -4.041 -10.193   0.977  1.00  1.00
ATOM    166 1HG2 ILE    12      -4.265  -9.266   0.450  1.00  0.00
ATOM    167 2HG2 ILE    12      -3.089 -10.095   1.497  1.00  0.00
ATOM    168 3HG2 ILE    12      -3.981 -11.012   0.260  1.00  0.00
ATOM    169  CG1 ILE    12      -6.487 -10.626   1.261  1.00  1.00
ATOM    170 2HG1 ILE    12      -6.369 -11.306   0.417  1.00  0.00
ATOM    171 3HG1 ILE    12      -7.235 -11.025   1.946  1.00  0.00
ATOM    172  CD1 ILE    12      -6.941  -9.258   0.753  1.00  1.00
ATOM    173 1HD1 ILE    12      -7.893  -9.361   0.231  1.00  0.00
ATOM    174 2HD1 ILE    12      -7.061  -8.579   1.597  1.00  0.00
ATOM    175 3HD1 ILE    12      -6.193  -8.859   0.068  1.00  0.00
ATOM    176  C   ILE    12      -3.449 -11.685   3.354  1.00  1.00
ATOM    177  O   ILE    12      -3.297 -11.280   4.502  1.00  1.00
ATOM    178  N   LEU    13      -2.441 -12.058   2.581  1.00  1.00
ATOM    179  HN  LEU    13      -2.622 -12.381   1.641  1.00  0.00
ATOM    180  CA  LEU    13      -1.058 -12.018   3.047  1.00  1.00
ATOM    181  HA  LEU    13      -1.049 -12.131   4.131  1.00  0.00
ATOM    182  CB  LEU    13      -0.268 -13.170   2.414  1.00  1.00
ATOM    183 2HB  LEU    13      -0.546 -13.261   1.364  1.00  0.00
ATOM    184 3HB  LEU    13       0.798 -12.958   2.491  1.00  0.00
ATOM    185  CG  LEU    13      -0.573 -14.493   3.133  1.00  1.00
ATOM    186  HG  LEU    13      -1.612 -14.492   3.464  1.00  0.00
ATOM    187  CD1 LEU    13      -0.343 -15.669   2.177  1.00  1.00
ATOM    188 1HD1 LEU    13      -0.564 -16.606   2.689  1.00  0.00
ATOM    189 2HD1 LEU    13      -0.998 -15.567   1.311  1.00  0.00
ATOM    190 3HD1 LEU    13       0.696 -15.672   1.848  1.00  0.00
ATOM    191  CD2 LEU    13       0.352 -14.655   4.350  1.00  1.00
ATOM    192 1HD2 LEU    13       0.128 -15.594   4.858  1.00  0.00
ATOM    193 2HD2 LEU    13       1.390 -14.661   4.018  1.00  0.00
ATOM    194 3HD2 LEU    13       0.195 -13.825   5.038  1.00  0.00
ATOM    195  C   LEU    13      -0.412 -10.701   2.682  1.00  1.00
ATOM    196  O   LEU    13      -0.703 -10.115   1.639  1.00  1.00
ATOM    197  N   LEU    14       0.467 -10.241   3.563  1.00  1.00
ATOM    198  HN  LEU    14       0.663 -10.769   4.402  1.00  0.00
ATOM    199  CA  LEU    14       1.169  -8.980   3.354  1.00  1.00
ATOM    200  HA  LEU    14       0.935  -8.615   2.354  1.00  0.00
ATOM    201  CB  LEU    14       0.683  -7.948   4.388  1.00  1.00
ATOM    202 2HB  LEU    14       0.127  -8.462   5.173  1.00  0.00
ATOM    203 3HB  LEU    14       1.545  -7.444   4.824  1.00  0.00
ATOM    204  CG  LEU    14      -0.224  -6.911   3.726  1.00  1.00
ATOM    205  HG  LEU    14      -0.583  -6.216   4.485  1.00  0.00
ATOM    206  CD1 LEU    14       0.576  -6.113   2.661  1.00  1.00
ATOM    207 1HD1 LEU    14      -0.074  -5.370   2.199  1.00  0.00
ATOM    208 2HD1 LEU    14       1.417  -5.612   3.139  1.00  0.00
ATOM    209 3HD1 LEU    14       0.946  -6.797   1.897  1.00  0.00
ATOM    210  CD2 LEU    14      -1.438  -7.627   3.095  1.00  1.00
ATOM    211 1HD2 LEU    14      -2.095  -6.890   2.633  1.00  0.00
ATOM    212 2HD2 LEU    14      -1.092  -8.331   2.337  1.00  0.00
ATOM    213 3HD2 LEU    14      -1.985  -8.167   3.869  1.00  0.00
ATOM    214  C   LEU    14       2.679  -9.170   3.464  1.00  1.00
ATOM    215  O   LEU    14       3.182  -9.797   4.399  1.00  1.00
ATOM    216  N   ASP    15       3.393  -8.610   2.493  1.00  1.00
ATOM    217  HN  ASP    15       2.926  -8.109   1.751  1.00  0.00
ATOM    218  CA  ASP    15       4.851  -8.698   2.462  1.00  1.00
ATOM    219  HA  ASP    15       5.173  -9.440   3.193  1.00  0.00
ATOM    220  CB  ASP    15       5.315  -9.130   1.075  1.00  1.00
ATOM    221 2HB  ASP    15       4.890  -8.463   0.325  1.00  0.00
ATOM    222 3HB  ASP    15       6.402  -9.082   1.024  1.00  0.00
ATOM    223  CG  ASP    15       4.857 -10.559   0.802  1.00  1.00
ATOM    224  OD1 ASP    15       4.446 -11.217   1.744  1.00  1.00
ATOM    225  OD2 ASP    15       4.921 -10.972  -0.343  1.00  1.00
ATOM    226 2HD  ASP    15       4.616 -11.877  -0.440  1.00  0.00
ATOM    227  C   ASP    15       5.475  -7.350   2.811  1.00  1.00
ATOM    228  O   ASP    15       5.377  -6.390   2.043  1.00  1.00
ATOM    229  N   LEU    16       6.122  -7.285   3.974  1.00  1.00
ATOM    230  HN  LEU    16       6.173  -8.102   4.566  1.00  0.00
ATOM    231  CA  LEU    16       6.771  -6.053   4.430  1.00  1.00
ATOM    232  HA  LEU    16       6.836  -5.363   3.589  1.00  0.00
ATOM    233  CB  LEU    16       5.942  -5.405   5.542  1.00  1.00
ATOM    234 2HB  LEU    16       5.703  -6.152   6.299  1.00  0.00
ATOM    235 3HB  LEU    16       6.514  -4.597   5.997  1.00  0.00
ATOM    236  CG  LEU    16       4.641  -4.842   4.951  1.00  1.00
ATOM    237  HG  LEU    16       4.182  -5.600   4.316  1.00  0.00
ATOM    238  CD1 LEU    16       3.679  -4.488   6.091  1.00  1.00
ATOM    239 1HD1 LEU    16       2.748  -4.100   5.676  1.00  0.00
ATOM    240 2HD1 LEU    16       3.469  -5.382   6.679  1.00  0.00
ATOM    241 3HD1 LEU    16       4.135  -3.732   6.729  1.00  0.00
ATOM    242  CD2 LEU    16       4.924  -3.580   4.103  1.00  1.00
ATOM    243 1HD2 LEU    16       3.991  -3.197   3.688  1.00  0.00
ATOM    244 2HD2 LEU    16       5.380  -2.816   4.732  1.00  0.00
ATOM    245 3HD2 LEU    16       5.603  -3.835   3.290  1.00  0.00
ATOM    246  C   LEU    16       8.175  -6.345   4.937  1.00  1.00
ATOM    247  O   LEU    16       8.442  -7.414   5.487  1.00  1.00
ATOM    248  N   SER    17       9.070  -5.384   4.746  1.00  1.00
ATOM    249  HN  SER    17       8.799  -4.524   4.291  1.00  0.00
ATOM    250  CA  SER    17      10.447  -5.538   5.181  1.00  1.00
ATOM    251  HA  SER    17      10.846  -6.462   4.762  1.00  0.00
ATOM    252  CB  SER    17      11.284  -4.360   4.677  1.00  1.00
ATOM    253 2HB  SER    17      10.709  -3.439   4.771  1.00  0.00
ATOM    254 3HB  SER    17      12.196  -4.282   5.269  1.00  0.00
ATOM    255  OG  SER    17      11.621  -4.572   3.312  1.00  1.00
ATOM    256  HG  SER    17      12.145  -3.827   3.009  1.00  0.00
ATOM    257  C   SER    17      10.515  -5.614   6.703  1.00  1.00
ATOM    258  O   SER    17       9.580  -5.216   7.397  1.00  1.00
ATOM    259  N   ASN    18      11.626  -6.130   7.212  1.00  1.00
ATOM    260  HN  ASN    18      12.366  -6.443   6.600  1.00  0.00
ATOM    261  CA  ASN    18      11.809  -6.259   8.652  1.00  1.00
ATOM    262  HA  ASN    18      10.994  -6.860   9.056  1.00  0.00
ATOM    263  CB  ASN    18      13.138  -6.955   8.951  1.00  1.00
ATOM    264 2HB  ASN    18      13.934  -6.476   8.382  1.00  0.00
ATOM    265 3HB  ASN    18      13.359  -6.873  10.015  1.00  0.00
ATOM    266  CG  ASN    18      13.053  -8.428   8.564  1.00  1.00
ATOM    267  OD1 ASN    18      12.406  -9.215   9.254  1.00  1.00
ATOM    268  ND2 ASN    18      13.669  -8.848   7.493  1.00  1.00
ATOM    269 1HD2 ASN    18      14.192  -8.183   6.941  1.00  0.00
ATOM    270 2HD2 ASN    18      13.620  -9.821   7.224  1.00  0.00
ATOM    271  C   ASN    18      11.791  -4.887   9.318  1.00  1.00
ATOM    272  O   ASN    18      11.239  -4.722  10.405  1.00  1.00
ATOM    273  N   GLU    19      12.397  -3.906   8.659  1.00  1.00
ATOM    274  HN  GLU    19      12.835  -4.089   7.767  1.00  0.00
ATOM    275  CA  GLU    19      12.445  -2.553   9.199  1.00  1.00
ATOM    276  HA  GLU    19      13.001  -2.571  10.137  1.00  0.00
ATOM    277  CB  GLU    19      13.159  -1.622   8.213  1.00  1.00
ATOM    278 2HB  GLU    19      12.722  -1.743   7.222  1.00  0.00
ATOM    279 3HB  GLU    19      13.039  -0.589   8.540  1.00  0.00
ATOM    280  CG  GLU    19      14.651  -1.968   8.157  1.00  1.00
ATOM    281 2HG  GLU    19      15.188  -1.170   7.646  1.00  0.00
ATOM    282 3HG  GLU    19      15.037  -2.068   9.171  1.00  0.00
ATOM    283  CD  GLU    19      14.860  -3.279   7.406  1.00  1.00
ATOM    284  OE1 GLU    19      13.967  -3.667   6.671  1.00  1.00
ATOM    285  OE2 GLU    19      15.911  -3.875   7.576  1.00  1.00
ATOM    286 2HE  GLU    19      15.974  -4.690   7.073  1.00  0.00
ATOM    287  C   GLU    19      11.035  -2.034   9.467  1.00  1.00
ATOM    288  O   GLU    19      10.807  -1.306  10.431  1.00  1.00
ATOM    289  N   VAL    20      10.092  -2.422   8.618  1.00  1.00
ATOM    290  HN  VAL    20      10.326  -3.021   7.839  1.00  0.00
ATOM    291  CA  VAL    20       8.705  -1.999   8.784  1.00  1.00
ATOM    292  HA  VAL    20       8.680  -0.915   8.890  1.00  0.00
ATOM    293  CB  VAL    20       7.890  -2.400   7.552  1.00  1.00
ATOM    294  HB  VAL    20       8.005  -3.470   7.375  1.00  0.00
ATOM    295  CG1 VAL    20       6.412  -2.082   7.784  1.00  1.00
ATOM    296 1HG1 VAL    20       5.835  -2.371   6.906  1.00  0.00
ATOM    297 2HG1 VAL    20       6.053  -2.636   8.652  1.00  0.00
ATOM    298 3HG1 VAL    20       6.294  -1.013   7.961  1.00  0.00
ATOM    299  CG2 VAL    20       8.396  -1.626   6.332  1.00  1.00
ATOM    300 1HG2 VAL    20       7.818  -1.914   5.454  1.00  0.00
ATOM    301 2HG2 VAL    20       8.282  -0.557   6.508  1.00  0.00
ATOM    302 3HG2 VAL    20       9.448  -1.857   6.166  1.00  0.00
ATOM    303  C   VAL    20       8.099  -2.635  10.035  1.00  1.00
ATOM    304  O   VAL    20       7.400  -1.970  10.801  1.00  1.00
ATOM    305  N   ILE    21       8.368  -3.920  10.235  1.00  1.00
ATOM    306  HN  ILE    21       8.948  -4.427   9.581  1.00  0.00
ATOM    307  CA  ILE    21       7.838  -4.626  11.395  1.00  1.00
ATOM    308  HA  ILE    21       6.752  -4.676  11.313  1.00  0.00
ATOM    309  CB  ILE    21       8.401  -6.053  11.442  1.00  1.00
ATOM    310  HB  ILE    21       9.480  -6.011  11.588  1.00  0.00
ATOM    311  CG2 ILE    21       7.762  -6.825  12.599  1.00  1.00
ATOM    312 1HG2 ILE    21       8.167  -7.837  12.630  1.00  0.00
ATOM    313 2HG2 ILE    21       7.980  -6.318  13.538  1.00  0.00
ATOM    314 3HG2 ILE    21       6.683  -6.871  12.453  1.00  0.00
ATOM    315  CG1 ILE    21       8.093  -6.768  10.120  1.00  1.00
ATOM    316 2HG1 ILE    21       7.014  -6.874  10.009  1.00  0.00
ATOM    317 3HG1 ILE    21       8.487  -6.180   9.291  1.00  0.00
ATOM    318  CD1 ILE    21       8.742  -8.158  10.110  1.00  1.00
ATOM    319 1HD1 ILE    21       8.517  -8.660   9.169  1.00  0.00
ATOM    320 2HD1 ILE    21       9.822  -8.055  10.218  1.00  0.00
ATOM    321 3HD1 ILE    21       8.349  -8.748  10.938  1.00  0.00
ATOM    322  C   ILE    21       8.208  -3.875  12.668  1.00  1.00
ATOM    323  O   ILE    21       7.418  -3.804  13.610  1.00  1.00
ATOM    324  N   LYS    22       9.407  -3.303  12.684  1.00  1.00
ATOM    325  HN  LYS    22      10.021  -3.389  11.887  1.00  0.00
ATOM    326  CA  LYS    22       9.862  -2.545  13.839  1.00  1.00
ATOM    327  HA  LYS    22       9.776  -3.171  14.728  1.00  0.00
ATOM    328  CB  LYS    22      11.326  -2.139  13.654  1.00  1.00
ATOM    329 2HB  LYS    22      11.435  -1.587  12.721  1.00  0.00
ATOM    330 3HB  LYS    22      11.638  -1.510  14.488  1.00  0.00
ATOM    331  CG  LYS    22      12.196  -3.398  13.609  1.00  1.00
ATOM    332 2HG  LYS    22      12.104  -3.937  14.552  1.00  0.00
ATOM    333 3HG  LYS    22      11.865  -4.039  12.792  1.00  0.00
ATOM    334  CD  LYS    22      13.656  -3.003  13.388  1.00  1.00
ATOM    335 2HD  LYS    22      13.751  -2.478  12.437  1.00  0.00
ATOM    336 3HD  LYS    22      13.982  -2.350  14.197  1.00  0.00
ATOM    337  CE  LYS    22      14.526  -4.260  13.365  1.00  1.00
ATOM    338 2HE  LYS    22      15.573  -3.977  13.253  1.00  0.00
ATOM    339 3HE  LYS    22      14.401  -4.808  14.299  1.00  0.00
ATOM    340  NZ  LYS    22      14.117  -5.125  12.221  1.00  1.00
ATOM    341 1HZ  LYS    22      14.695  -5.954  12.211  1.00  0.00
ATOM    342 2HZ  LYS    22      13.148  -5.389  12.327  1.00  0.00
ATOM    343 3HZ  LYS    22      14.235  -4.619  11.355  1.00  0.00
ATOM    344  C   LYS    22       8.997  -1.298  14.019  1.00  1.00
ATOM    345  O   LYS    22       8.652  -0.924  15.142  1.00  1.00
ATOM    346  N   GLN    23       8.653  -0.656  12.901  1.00  1.00
ATOM    347  HN  GLN    23       8.963  -1.001  12.004  1.00  0.00
ATOM    348  CA  GLN    23       7.831   0.548  12.941  1.00  1.00
ATOM    349  HA  GLN    23       8.313   1.285  13.583  1.00  0.00
ATOM    350  CB  GLN    23       7.694   1.124  11.528  1.00  1.00
ATOM    351 2HB  GLN    23       7.276   0.365  10.866  1.00  0.00
ATOM    352 3HB  GLN    23       7.032   1.989  11.552  1.00  0.00
ATOM    353  CG  GLN    23       9.064   1.547  11.014  1.00  1.00
ATOM    354 2HG  GLN    23       9.476   2.313  11.671  1.00  0.00
ATOM    355 3HG  GLN    23       9.730   0.683  11.009  1.00  0.00
ATOM    356  CD  GLN    23       8.947   2.103   9.601  1.00  1.00
ATOM    357  OE1 GLN    23       8.083   2.938   9.330  1.00  1.00
ATOM    358  NE2 GLN    23       9.773   1.691   8.681  1.00  1.00
ATOM    359 1HE2 GLN    23      10.473   1.006   8.928  1.00  0.00
ATOM    360 2HE2 GLN    23       9.710   2.051   7.740  1.00  0.00
ATOM    361  C   GLN    23       6.452   0.220  13.503  1.00  1.00
ATOM    362  O   GLN    23       5.946   0.913  14.386  1.00  1.00
ATOM    363  N   LEU    24       5.850  -0.844  12.982  1.00  1.00
ATOM    364  HN  LEU    24       6.307  -1.381  12.259  1.00  0.00
ATOM    365  CA  LEU    24       4.528  -1.263  13.434  1.00  1.00
ATOM    366  HA  LEU    24       3.832  -0.435  13.298  1.00  0.00
ATOM    367  CB  LEU    24       4.052  -2.459  12.603  1.00  1.00
ATOM    368 2HB  LEU    24       4.837  -3.215  12.575  1.00  0.00
ATOM    369 3HB  LEU    24       3.157  -2.882  13.059  1.00  0.00
ATOM    370  CG  LEU    24       3.729  -2.005  11.170  1.00  1.00
ATOM    371  HG  LEU    24       4.544  -1.383  10.801  1.00  0.00
ATOM    372  CD1 LEU    24       3.585  -3.238  10.273  1.00  1.00
ATOM    373 1HD1 LEU    24       3.368  -2.923   9.252  1.00  0.00
ATOM    374 2HD1 LEU    24       4.514  -3.808  10.287  1.00  0.00
ATOM    375 3HD1 LEU    24       2.771  -3.863  10.641  1.00  0.00
ATOM    376  CD2 LEU    24       2.418  -1.188  11.137  1.00  1.00
ATOM    377 1HD2 LEU    24       2.206  -0.873  10.115  1.00  0.00
ATOM    378 2HD2 LEU    24       1.597  -1.805  11.503  1.00  0.00
ATOM    379 3HD2 LEU    24       2.523  -0.309  11.773  1.00  0.00
ATOM    380  C   LEU    24       4.564  -1.644  14.905  1.00  1.00
ATOM    381  O   LEU    24       3.670  -1.288  15.668  1.00  1.00
ATOM    382  N   ASP    25       5.605  -2.358  15.302  1.00  1.00
ATOM    383  HN  ASP    25       6.321  -2.624  14.641  1.00  0.00
ATOM    384  CA  ASP    25       5.743  -2.776  16.690  1.00  1.00
ATOM    385  HA  ASP    25       4.924  -3.451  16.938  1.00  0.00
ATOM    386  CB  ASP    25       7.073  -3.509  16.877  1.00  1.00
ATOM    387 2HB  ASP    25       7.177  -4.272  16.106  1.00  0.00
ATOM    388 3HB  ASP    25       7.893  -2.797  16.790  1.00  0.00
ATOM    389  CG  ASP    25       7.121  -4.168  18.249  1.00  1.00
ATOM    390  OD1 ASP    25       6.068  -4.331  18.843  1.00  1.00
ATOM    391  OD2 ASP    25       8.210  -4.500  18.686  1.00  1.00
ATOM    392 2HD  ASP    25       8.165  -4.909  19.554  1.00  0.00
ATOM    393  C   ASP    25       5.692  -1.566  17.617  1.00  1.00
ATOM    394  O   ASP    25       4.993  -1.581  18.629  1.00  1.00
ATOM    395  N   ASP    26       6.427  -0.517  17.264  1.00  1.00
ATOM    396  HN  ASP    26       6.985  -0.545  16.423  1.00  0.00
ATOM    397  CA  ASP    26       6.444   0.690  18.080  1.00  1.00
ATOM    398  HA  ASP    26       6.825   0.440  19.070  1.00  0.00
ATOM    399  CB  ASP    26       7.360   1.736  17.441  1.00  1.00
ATOM    400 2HB  ASP    26       8.317   1.276  17.195  1.00  0.00
ATOM    401 3HB  ASP    26       6.898   2.112  16.528  1.00  0.00
ATOM    402  CG  ASP    26       7.587   2.893  18.406  1.00  1.00
ATOM    403  OD1 ASP    26       6.816   3.016  19.343  1.00  1.00
ATOM    404  OD2 ASP    26       8.529   3.639  18.196  1.00  1.00
ATOM    405 2HD  ASP    26       8.611   4.343  18.843  1.00  0.00
ATOM    406  C   ASP    26       5.032   1.249  18.217  1.00  1.00
ATOM    407  O   ASP    26       4.614   1.651  19.302  1.00  1.00
ATOM    408  N   LEU    27       4.300   1.259  17.110  1.00  1.00
ATOM    409  HN  LEU    27       4.690   0.919  16.243  1.00  0.00
ATOM    410  CA  LEU    27       2.929   1.754  17.111  1.00  1.00
ATOM    411  HA  LEU    27       2.919   2.741  17.572  1.00  0.00
ATOM    412  CB  LEU    27       2.416   1.878  15.672  1.00  1.00
ATOM    413 2HB  LEU    27       2.812   1.057  15.074  1.00  0.00
ATOM    414 3HB  LEU    27       1.327   1.836  15.670  1.00  0.00
ATOM    415  CG  LEU    27       2.881   3.225  15.071  1.00  1.00
ATOM    416  HG  LEU    27       3.841   3.501  15.506  1.00  0.00
ATOM    417  CD1 LEU    27       3.027   3.090  13.565  1.00  1.00
ATOM    418 1HD1 LEU    27       3.358   4.039  13.144  1.00  0.00
ATOM    419 2HD1 LEU    27       3.762   2.317  13.339  1.00  0.00
ATOM    420 3HD1 LEU    27       2.066   2.815  13.130  1.00  0.00
ATOM    421  CD2 LEU    27       1.846   4.321  15.376  1.00  1.00
ATOM    422 1HD2 LEU    27       2.181   5.267  14.952  1.00  0.00
ATOM    423 2HD2 LEU    27       0.886   4.046  14.938  1.00  0.00
ATOM    424 3HD2 LEU    27       1.735   4.426  16.455  1.00  0.00
ATOM    425  C   LEU    27       2.024   0.830  17.918  1.00  1.00
ATOM    426  O   LEU    27       1.076   1.278  18.558  1.00  1.00
ATOM    427  N   GLU    28       2.323  -0.461  17.875  1.00  1.00
ATOM    428  HN  GLU    28       3.112  -0.779  17.331  1.00  0.00
ATOM    429  CA  GLU    28       1.536  -1.444  18.599  1.00  1.00
ATOM    430  HA  GLU    28       0.481  -1.288  18.371  1.00  0.00
ATOM    431  CB  GLU    28       1.944  -2.847  18.147  1.00  1.00
ATOM    432 2HB  GLU    28       3.031  -2.923  18.137  1.00  0.00
ATOM    433 3HB  GLU    28       1.535  -3.585  18.838  1.00  0.00
ATOM    434  CG  GLU    28       1.401  -3.112  16.740  1.00  1.00
ATOM    435 2HG  GLU    28       0.318  -3.226  16.785  1.00  0.00
ATOM    436 3HG  GLU    28       1.647  -2.271  16.092  1.00  0.00
ATOM    437  CD  GLU    28       2.021  -4.385  16.175  1.00  1.00
ATOM    438  OE1 GLU    28       1.807  -5.434  16.759  1.00  1.00
ATOM    439  OE2 GLU    28       2.705  -4.290  15.169  1.00  1.00
ATOM    440 2HE  GLU    28       3.064  -5.129  14.871  1.00  0.00
ATOM    441  C   GLU    28       1.744  -1.301  20.103  1.00  1.00
ATOM    442  O   GLU    28       0.820  -1.498  20.886  1.00  1.00
ATOM    443  N   VAL    29       2.967  -0.967  20.496  1.00  1.00
ATOM    444  HN  VAL    29       3.699  -0.817  19.817  1.00  0.00
ATOM    445  CA  VAL    29       3.278  -0.811  21.916  1.00  1.00
ATOM    446  HA  VAL    29       3.008  -1.731  22.435  1.00  0.00
ATOM    447  CB  VAL    29       4.780  -0.558  22.093  1.00  1.00
ATOM    448  HB  VAL    29       5.090   0.246  21.426  1.00  0.00
ATOM    449  CG1 VAL    29       5.075  -0.157  23.544  1.00  1.00
ATOM    450 1HG1 VAL    29       6.143   0.023  23.663  1.00  0.00
ATOM    451 2HG1 VAL    29       4.524   0.751  23.789  1.00  0.00
ATOM    452 3HG1 VAL    29       4.766  -0.961  24.213  1.00  0.00
ATOM    453  CG2 VAL    29       5.558  -1.832  21.749  1.00  1.00
ATOM    454 1HG2 VAL    29       6.626  -1.651  21.870  1.00  0.00
ATOM    455 2HG2 VAL    29       5.248  -2.638  22.415  1.00  0.00
ATOM    456 3HG2 VAL    29       5.353  -2.115  20.717  1.00  0.00
ATOM    457  C   VAL    29       2.490   0.350  22.522  1.00  1.00
ATOM    458  O   VAL    29       1.838   0.200  23.555  1.00  1.00
ATOM    459  N   GLN    30       2.565   1.506  21.876  1.00  1.00
ATOM    460  HN  GLN    30       3.114   1.580  21.032  1.00  0.00
ATOM    461  CA  GLN    30       1.864   2.689  22.362  1.00  1.00
ATOM    462  HA  GLN    30       2.189   2.889  23.383  1.00  0.00
ATOM    463  CB  GLN    30       2.206   3.900  21.487  1.00  1.00
ATOM    464 2HB  GLN    30       1.589   4.748  21.782  1.00  0.00
ATOM    465 3HB  GLN    30       3.258   4.154  21.613  1.00  0.00
ATOM    466  CG  GLN    30       1.937   3.559  20.033  1.00  1.00
ATOM    467 2HG  GLN    30       2.480   2.652  19.767  1.00  0.00
ATOM    468 3HG  GLN    30       0.869   3.392  19.892  1.00  0.00
ATOM    469  CD  GLN    30       2.394   4.705  19.137  1.00  1.00
ATOM    470  OE1 GLN    30       3.594   4.951  19.007  1.00  1.00
ATOM    471  NE2 GLN    30       1.507   5.426  18.510  1.00  1.00
ATOM    472 1HE2 GLN    30       0.529   5.206  18.633  1.00  0.00
ATOM    473 2HE2 GLN    30       1.796   6.188  17.915  1.00  0.00
ATOM    474  C   GLN    30       0.361   2.454  22.363  1.00  1.00
ATOM    475  O   GLN    30      -0.341   2.869  23.283  1.00  1.00
ATOM    476  N   ARG    31      -0.127   1.784  21.325  1.00  1.00
ATOM    477  HN  ARG    31       0.492   1.461  20.595  1.00  0.00
ATOM    478  CA  ARG    31      -1.554   1.498  21.209  1.00  1.00
ATOM    479  HA  ARG    31      -2.114   2.326  21.644  1.00  0.00
ATOM    480  CB  ARG    31      -1.929   1.363  19.725  1.00  1.00
ATOM    481 2HB  ARG    31      -1.128   0.846  19.197  1.00  0.00
ATOM    482 3HB  ARG    31      -2.851   0.788  19.638  1.00  0.00
ATOM    483  CG  ARG    31      -2.137   2.754  19.099  1.00  1.00
ATOM    484 2HG  ARG    31      -1.427   3.455  19.537  1.00  0.00
ATOM    485 3HG  ARG    31      -1.972   2.693  18.023  1.00  0.00
ATOM    486  CD  ARG    31      -3.565   3.245  19.366  1.00  1.00
ATOM    487 2HD  ARG    31      -4.277   2.508  18.994  1.00  0.00
ATOM    488 3HD  ARG    31      -3.710   3.372  20.439  1.00  0.00
ATOM    489  NE  ARG    31      -3.789   4.518  18.692  1.00  1.00
ATOM    490  HE  ARG    31      -4.150   4.506  17.749  1.00  0.00
ATOM    491  CZ  ARG    31      -3.529   5.674  19.294  1.00  1.00
ATOM    492  NH1 ARG    31      -3.751   6.794  18.668  1.00  1.00
ATOM    493 1HH1 ARG    31      -3.552   7.672  19.125  1.00  0.00
ATOM    494 2HH1 ARG    31      -4.122   6.783  17.729  1.00  0.00
ATOM    495  NH2 ARG    31      -3.046   5.687  20.508  1.00  1.00
ATOM    496 1HH2 ARG    31      -2.848   6.567  20.961  1.00  0.00
ATOM    497 2HH2 ARG    31      -2.871   4.818  20.992  1.00  0.00
ATOM    498  C   ARG    31      -1.908   0.216  21.957  1.00  1.00
ATOM    499  O   ARG    31      -3.077  -0.038  22.248  1.00  1.00
ATOM    500  N   ASN    32      -0.898  -0.584  22.265  1.00  1.00
ATOM    501  HN  ASN    32       0.046  -0.334  22.008  1.00  0.00
ATOM    502  CA  ASN    32      -1.122  -1.829  22.974  1.00  1.00
ATOM    503  HA  ASN    32      -0.177  -2.368  23.046  1.00  0.00
ATOM    504  CB  ASN    32      -1.640  -1.544  24.378  1.00  1.00
ATOM    505 2HB  ASN    32      -2.629  -1.090  24.314  1.00  0.00
ATOM    506 3HB  ASN    32      -1.710  -2.478  24.936  1.00  0.00
ATOM    507  CG  ASN    32      -0.690  -0.596  25.097  1.00  1.00
ATOM    508  OD1 ASN    32       0.488  -0.908  25.268  1.00  1.00
ATOM    509  ND2 ASN    32      -1.133   0.553  25.526  1.00  1.00
ATOM    510 1HD2 ASN    32      -2.103   0.787  25.371  1.00  0.00
ATOM    511 2HD2 ASN    32      -0.514   1.193  26.002  1.00  0.00
ATOM    512  C   ASN    32      -2.126  -2.686  22.225  1.00  1.00
ATOM    513  O   ASN    32      -2.988  -3.319  22.832  1.00  1.00
ATOM    514  N   LEU    33      -2.020  -2.698  20.896  1.00  1.00
ATOM    515  HN  LEU    33      -1.296  -2.163  20.439  1.00  0.00
ATOM    516  CA  LEU    33      -2.942  -3.481  20.071  1.00  1.00
ATOM    517  HA  LEU    33      -3.452  -4.206  20.707  1.00  0.00
ATOM    518  CB  LEU    33      -3.983  -2.541  19.444  1.00  1.00
ATOM    519 2HB  LEU    33      -3.494  -1.621  19.126  1.00  0.00
ATOM    520 3HB  LEU    33      -4.437  -3.029  18.581  1.00  0.00
ATOM    521  CG  LEU    33      -5.078  -2.208  20.477  1.00  1.00
ATOM    522  HG  LEU    33      -4.621  -2.119  21.462  1.00  0.00
ATOM    523  CD1 LEU    33      -5.744  -0.882  20.108  1.00  1.00
ATOM    524 1HD1 LEU    33      -6.510  -0.640  20.845  1.00  0.00
ATOM    525 2HD1 LEU    33      -4.994  -0.092  20.092  1.00  0.00
ATOM    526 3HD1 LEU    33      -6.203  -0.968  19.123  1.00  0.00
ATOM    527  CD2 LEU    33      -6.144  -3.319  20.517  1.00  1.00
ATOM    528 1HD2 LEU    33      -6.907  -3.072  21.255  1.00  0.00
ATOM    529 2HD2 LEU    33      -6.608  -3.412  19.535  1.00  0.00
ATOM    530 3HD2 LEU    33      -5.673  -4.264  20.787  1.00  0.00
ATOM    531  C   LEU    33      -2.191  -4.230  18.972  1.00  1.00
ATOM    532  O   LEU    33      -1.121  -3.799  18.538  1.00  1.00
ATOM    533  N   PRO    34      -2.736  -5.331  18.512  1.00  1.00
ATOM    534  CD  PRO    34      -4.004  -5.930  18.977  1.00  1.00
ATOM    535  CA  PRO    34      -2.110  -6.148  17.430  1.00  1.00
ATOM    536  HA  PRO    34      -1.111  -6.469  17.726  1.00  0.00
ATOM    537  CB  PRO    34      -3.045  -7.368  17.298  1.00  1.00
ATOM    538 2HB  PRO    34      -3.151  -7.684  16.260  1.00  0.00
ATOM    539 3HB  PRO    34      -2.649  -8.179  17.909  1.00  0.00
ATOM    540  CG  PRO    34      -4.352  -6.929  17.881  1.00  1.00
ATOM    541 2HG  PRO    34      -4.918  -6.411  17.107  1.00  0.00
ATOM    542 3HG  PRO    34      -4.919  -7.773  18.274  1.00  0.00
ATOM    543 2HD  PRO    34      -4.789  -5.183  19.093  1.00  0.00
ATOM    544 3HD  PRO    34      -3.835  -6.452  19.919  1.00  0.00
ATOM    545  C   PRO    34      -2.016  -5.378  16.112  1.00  1.00
ATOM    546  O   PRO    34      -2.805  -4.471  15.854  1.00  1.00
ATOM    547  N   ARG    35      -1.047  -5.755  15.286  1.00  1.00
ATOM    548  HN  ARG    35      -0.423  -6.505  15.547  1.00  0.00
ATOM    549  CA  ARG    35      -0.858  -5.106  13.998  1.00  1.00
ATOM    550  HA  ARG    35      -0.686  -4.042  14.160  1.00  0.00
ATOM    551  CB  ARG    35       0.359  -5.712  13.299  1.00  1.00
ATOM    552 2HB  ARG    35       0.558  -5.163  12.379  1.00  0.00
ATOM    553 3HB  ARG    35       1.225  -5.644  13.957  1.00  0.00
ATOM    554  CG  ARG    35       0.090  -7.184  12.965  1.00  1.00
ATOM    555 2HG  ARG    35      -0.310  -7.689  13.845  1.00  0.00
ATOM    556 3HG  ARG    35      -0.633  -7.246  12.151  1.00  0.00
ATOM    557  CD  ARG    35       1.394  -7.858  12.540  1.00  1.00
ATOM    558 2HD  ARG    35       1.818  -7.323  11.690  1.00  0.00
ATOM    559 3HD  ARG    35       2.101  -7.833  13.369  1.00  0.00
ATOM    560  NE  ARG    35       1.140  -9.244  12.162  1.00  1.00
ATOM    561  HE  ARG    35       0.191  -9.523  11.958  1.00  0.00
ATOM    562  CZ  ARG    35       2.129 -10.128  12.085  1.00  1.00
ATOM    563  NH1 ARG    35       1.877 -11.362  11.743  1.00  1.00
ATOM    564 1HH1 ARG    35       2.630 -12.032  11.686  1.00  0.00
ATOM    565 2HH1 ARG    35       0.930 -11.647  11.536  1.00  0.00
ATOM    566  NH2 ARG    35       3.352  -9.761  12.354  1.00  1.00
ATOM    567 1HH2 ARG    35       4.103 -10.434  12.296  1.00  0.00
ATOM    568 2HH2 ARG    35       3.547  -8.807  12.620  1.00  0.00
ATOM    569  C   ARG    35      -2.094  -5.282  13.128  1.00  1.00
ATOM    570  O   ARG    35      -2.547  -4.338  12.481  1.00  1.00
ATOM    571  N   ALA    36      -2.630  -6.497  13.102  1.00  1.00
ATOM    572  HN  ALA    36      -2.226  -7.244  13.650  1.00  0.00
ATOM    573  CA  ALA    36      -3.804  -6.780  12.288  1.00  1.00
ATOM    574  HA  ALA    36      -3.513  -6.776  11.238  1.00  0.00
ATOM    575  CB  ALA    36      -4.367  -8.157  12.647  1.00  1.00
ATOM    576 1HB  ALA    36      -5.236  -8.372  12.024  1.00  0.00
ATOM    577 2HB  ALA    36      -3.604  -8.917  12.478  1.00  0.00
ATOM    578 3HB  ALA    36      -4.662  -8.167  13.696  1.00  0.00
ATOM    579  C   ALA    36      -4.869  -5.719  12.514  1.00  1.00
ATOM    580  O   ALA    36      -5.509  -5.258  11.569  1.00  1.00
ATOM    581  N   ASP    37      -5.044  -5.323  13.768  1.00  1.00
ATOM    582  HN  ASP    37      -4.497  -5.730  14.513  1.00  0.00
ATOM    583  CA  ASP    37      -6.026  -4.299  14.095  1.00  1.00
ATOM    584  HA  ASP    37      -6.992  -4.599  13.688  1.00  0.00
ATOM    585  CB  ASP    37      -6.145  -4.162  15.615  1.00  1.00
ATOM    586 2HB  ASP    37      -6.520  -5.096  16.035  1.00  0.00
ATOM    587 3HB  ASP    37      -5.163  -3.948  16.037  1.00  0.00
ATOM    588  CG  ASP    37      -7.104  -3.029  15.964  1.00  1.00
ATOM    589  OD1 ASP    37      -6.656  -2.063  16.560  1.00  1.00
ATOM    590  OD2 ASP    37      -8.272  -3.143  15.630  1.00  1.00
ATOM    591 2HD  ASP    37      -8.817  -2.394  15.882  1.00  0.00
ATOM    592  C   ASP    37      -5.626  -2.957  13.485  1.00  1.00
ATOM    593  O   ASP    37      -6.473  -2.203  13.007  1.00  1.00
ATOM    594  N   LEU    38      -4.328  -2.669  13.504  1.00  1.00
ATOM    595  HN  LEU    38      -3.671  -3.321  13.908  1.00  0.00
ATOM    596  CA  LEU    38      -3.822  -1.419  12.949  1.00  1.00
ATOM    597  HA  LEU    38      -4.409  -0.596  13.356  1.00  0.00
ATOM    598  CB  LEU    38      -2.356  -1.230  13.347  1.00  1.00
ATOM    599 2HB  LEU    38      -1.784  -2.110  13.051  1.00  0.00
ATOM    600 3HB  LEU    38      -1.955  -0.350  12.845  1.00  0.00
ATOM    601  CG  LEU    38      -2.254  -1.042  14.869  1.00  1.00
ATOM    602  HG  LEU    38      -2.762  -1.871  15.364  1.00  0.00
ATOM    603  CD1 LEU    38      -0.777  -1.036  15.282  1.00  1.00
ATOM    604 1HD1 LEU    38      -0.701  -0.916  16.363  1.00  0.00
ATOM    605 2HD1 LEU    38      -0.314  -1.979  14.988  1.00  0.00
ATOM    606 3HD1 LEU    38      -0.265  -0.211  14.788  1.00  0.00
ATOM    607  CD2 LEU    38      -2.919   0.283  15.301  1.00  1.00
ATOM    608 1HD2 LEU    38      -2.843   0.398  16.382  1.00  0.00
ATOM    609 2HD2 LEU    38      -2.416   1.117  14.812  1.00  0.00
ATOM    610 3HD2 LEU    38      -3.970   0.272  15.012  1.00  0.00
ATOM    611  C   LEU    38      -3.947  -1.410  11.431  1.00  1.00
ATOM    612  O   LEU    38      -4.315  -0.398  10.834  1.00  1.00
ATOM    613  N   LEU    39      -3.630  -2.539  10.810  1.00  1.00
ATOM    614  HN  LEU    39      -3.336  -3.347  11.341  1.00  0.00
ATOM    615  CA  LEU    39      -3.698  -2.642   9.359  1.00  1.00
ATOM    616  HA  LEU    39      -3.057  -1.878   8.920  1.00  0.00
ATOM    617  CB  LEU    39      -3.207  -4.021   8.928  1.00  1.00
ATOM    618 2HB  LEU    39      -3.755  -4.787   9.477  1.00  0.00
ATOM    619 3HB  LEU    39      -3.378  -4.147   7.859  1.00  0.00
ATOM    620  CG  LEU    39      -1.705  -4.160   9.223  1.00  1.00
ATOM    621  HG  LEU    39      -1.522  -3.885  10.262  1.00  0.00
ATOM    622  CD1 LEU    39      -1.276  -5.619   9.008  1.00  1.00
ATOM    623 1HD1 LEU    39      -0.214  -5.724   9.231  1.00  0.00
ATOM    624 2HD1 LEU    39      -1.851  -6.268   9.669  1.00  0.00
ATOM    625 3HD1 LEU    39      -1.460  -5.903   7.972  1.00  0.00
ATOM    626  CD2 LEU    39      -0.882  -3.226   8.308  1.00  1.00
ATOM    627 1HD2 LEU    39       0.179  -3.331   8.534  1.00  0.00
ATOM    628 2HD2 LEU    39      -1.058  -3.493   7.266  1.00  0.00
ATOM    629 3HD2 LEU    39      -1.188  -2.194   8.475  1.00  0.00
ATOM    630  C   LEU    39      -5.126  -2.437   8.872  1.00  1.00
ATOM    631  O   LEU    39      -5.366  -1.701   7.915  1.00  1.00
ATOM    632  N   ARG    40      -6.072  -3.096   9.529  1.00  1.00
ATOM    633  HN  ARG    40      -5.831  -3.690  10.309  1.00  0.00
ATOM    634  CA  ARG    40      -7.470  -2.980   9.142  1.00  1.00
ATOM    635  HA  ARG    40      -7.593  -3.390   8.139  1.00  0.00
ATOM    636  CB  ARG    40      -8.347  -3.770  10.118  1.00  1.00
ATOM    637 2HB  ARG    40      -8.014  -4.808  10.146  1.00  0.00
ATOM    638 3HB  ARG    40      -8.263  -3.335  11.114  1.00  0.00
ATOM    639  CG  ARG    40      -9.806  -3.716   9.661  1.00  1.00
ATOM    640 2HG  ARG    40     -10.146  -2.681   9.653  1.00  0.00
ATOM    641 3HG  ARG    40      -9.888  -4.134   8.658  1.00  0.00
ATOM    642  CD  ARG    40     -10.672  -4.528  10.623  1.00  1.00
ATOM    643 2HD  ARG    40     -11.704  -4.527  10.270  1.00  0.00
ATOM    644 3HD  ARG    40     -10.307  -5.555  10.660  1.00  0.00
ATOM    645  NE  ARG    40     -10.617  -3.946  11.960  1.00  1.00
ATOM    646  HE  ARG    40     -10.000  -4.363  12.642  1.00  0.00
ATOM    647  CZ  ARG    40     -11.359  -2.891  12.283  1.00  1.00
ATOM    648  NH1 ARG    40     -11.296  -2.394  13.488  1.00  1.00
ATOM    649 1HH1 ARG    40     -11.859  -1.592  13.731  1.00  0.00
ATOM    650 2HH1 ARG    40     -10.686  -2.811  14.176  1.00  0.00
ATOM    651  NH2 ARG    40     -12.145  -2.349  11.393  1.00  1.00
ATOM    652 1HH2 ARG    40     -12.707  -1.547  11.640  1.00  0.00
ATOM    653 2HH2 ARG    40     -12.192  -2.732  10.460  1.00  0.00
ATOM    654  C   ARG    40      -7.895  -1.518   9.138  1.00  1.00
ATOM    655  O   ARG    40      -8.571  -1.060   8.216  1.00  1.00
ATOM    656  N   GLU    41      -7.491  -0.789  10.169  1.00  1.00
ATOM    657  HN  GLU    41      -6.936  -1.209  10.902  1.00  0.00
ATOM    658  CA  GLU    41      -7.833   0.623  10.270  1.00  1.00
ATOM    659  HA  GLU    41      -8.914   0.728  10.175  1.00  0.00
ATOM    660  CB  GLU    41      -7.397   1.170  11.631  1.00  1.00
ATOM    661 2HB  GLU    41      -6.340   0.954  11.786  1.00  0.00
ATOM    662 3HB  GLU    41      -7.555   2.248  11.655  1.00  0.00
ATOM    663  CG  GLU    41      -8.219   0.511  12.742  1.00  1.00
ATOM    664 2HG  GLU    41      -8.141  -0.573  12.655  1.00  0.00
ATOM    665 3HG  GLU    41      -7.831   0.822  13.712  1.00  0.00
ATOM    666  CD  GLU    41      -9.683   0.924  12.626  1.00  1.00
ATOM    667  OE1 GLU    41     -10.523   0.212  13.150  1.00  1.00
ATOM    668  OE2 GLU    41      -9.942   1.945  12.011  1.00  1.00
ATOM    669 2HE  GLU    41     -10.881   2.143  11.977  1.00  0.00
ATOM    670  C   GLU    41      -7.157   1.416   9.157  1.00  1.00
ATOM    671  O   GLU    41      -7.731   2.362   8.620  1.00  1.00
ATOM    672  N   ALA    42      -5.935   1.025   8.816  1.00  1.00
ATOM    673  HN  ALA    42      -5.502   0.242   9.285  1.00  0.00
ATOM    674  CA  ALA    42      -5.195   1.711   7.765  1.00  1.00
ATOM    675  HA  ALA    42      -5.063   2.753   8.054  1.00  0.00
ATOM    676  CB  ALA    42      -3.822   1.062   7.588  1.00  1.00
ATOM    677 1HB  ALA    42      -3.264   1.589   6.815  1.00  0.00
ATOM    678 2HB  ALA    42      -3.273   1.112   8.529  1.00  0.00
ATOM    679 3HB  ALA    42      -3.949   0.019   7.296  1.00  0.00
ATOM    680  C   ALA    42      -5.957   1.654   6.445  1.00  1.00
ATOM    681  O   ALA    42      -6.127   2.672   5.774  1.00  1.00
ATOM    682  N   VAL    43      -6.414   0.461   6.074  1.00  1.00
ATOM    683  HN  VAL    43      -6.254  -0.351   6.654  1.00  0.00
ATOM    684  CA  VAL    43      -7.153   0.301   4.826  1.00  1.00
ATOM    685  HA  VAL    43      -6.540   0.667   4.003  1.00  0.00
ATOM    686  CB  VAL    43      -7.464  -1.180   4.601  1.00  1.00
ATOM    687  HB  VAL    43      -8.001  -1.572   5.465  1.00  0.00
ATOM    688  CG1 VAL    43      -8.329  -1.341   3.351  1.00  1.00
ATOM    689 1HG1 VAL    43      -8.550  -2.397   3.194  1.00  0.00
ATOM    690 2HG1 VAL    43      -9.261  -0.791   3.481  1.00  0.00
ATOM    691 3HG1 VAL    43      -7.794  -0.950   2.486  1.00  0.00
ATOM    692  CG2 VAL    43      -6.156  -1.955   4.421  1.00  1.00
ATOM    693 1HG2 VAL    43      -6.377  -3.011   4.264  1.00  0.00
ATOM    694 2HG2 VAL    43      -5.618  -1.564   3.558  1.00  0.00
ATOM    695 3HG2 VAL    43      -5.541  -1.842   5.314  1.00  0.00
ATOM    696  C   VAL    43      -8.454   1.098   4.873  1.00  1.00
ATOM    697  O   VAL    43      -8.725   1.916   3.995  1.00  1.00
ATOM    698  N   ASP    44      -9.257   0.847   5.901  1.00  1.00
ATOM    699  HN  ASP    44      -8.994   0.166   6.599  1.00  0.00
ATOM    700  CA  ASP    44     -10.528   1.542   6.045  1.00  1.00
ATOM    701  HA  ASP    44     -11.207   1.200   5.263  1.00  0.00
ATOM    702  CB  ASP    44     -11.143   1.234   7.411  1.00  1.00
ATOM    703 2HB  ASP    44     -11.062   0.165   7.610  1.00  0.00
ATOM    704 3HB  ASP    44     -10.604   1.784   8.182  1.00  0.00
ATOM    705  CG  ASP    44     -12.614   1.642   7.436  1.00  1.00
ATOM    706  OD1 ASP    44     -13.227   1.654   6.381  1.00  1.00
ATOM    707  OD2 ASP    44     -13.105   1.939   8.513  1.00  1.00
ATOM    708 2HD  ASP    44     -14.031   2.185   8.455  1.00  0.00
ATOM    709  C   ASP    44     -10.318   3.044   5.904  1.00  1.00
ATOM    710  O   ASP    44     -11.076   3.725   5.217  1.00  1.00
ATOM    711  N   GLN    45      -9.273   3.550   6.546  1.00  1.00
ATOM    712  HN  GLN    45      -8.678   2.949   7.098  1.00  0.00
ATOM    713  CA  GLN    45      -8.959   4.970   6.474  1.00  1.00
ATOM    714  HA  GLN    45      -9.843   5.537   6.765  1.00  0.00
ATOM    715  CB  GLN    45      -7.818   5.297   7.443  1.00  1.00
ATOM    716 2HB  GLN    45      -7.048   4.529   7.368  1.00  0.00
ATOM    717 3HB  GLN    45      -7.391   6.266   7.186  1.00  0.00
ATOM    718  CG  GLN    45      -8.354   5.341   8.877  1.00  1.00
ATOM    719 2HG  GLN    45      -9.109   6.123   8.958  1.00  0.00
ATOM    720 3HG  GLN    45      -8.806   4.380   9.124  1.00  0.00
ATOM    721  CD  GLN    45      -7.219   5.631   9.851  1.00  1.00
ATOM    722  OE1 GLN    45      -6.424   6.544   9.625  1.00  1.00
ATOM    723  NE2 GLN    45      -7.097   4.907  10.929  1.00  1.00
ATOM    724 1HE2 GLN    45      -7.762   4.164  11.093  1.00  0.00
ATOM    725 2HE2 GLN    45      -6.351   5.088  11.584  1.00  0.00
ATOM    726  C   GLN    45      -8.566   5.364   5.053  1.00  1.00
ATOM    727  O   GLN    45      -8.921   6.442   4.575  1.00  1.00
ATOM    728  N   TYR    46      -7.828   4.486   4.386  1.00  1.00
ATOM    729  HN  TYR    46      -7.559   3.615   4.821  1.00  0.00
ATOM    730  CA  TYR    46      -7.388   4.752   3.020  1.00  1.00
ATOM    731  HA  TYR    46      -6.832   5.689   3.011  1.00  0.00
ATOM    732  CB  TYR    46      -6.472   3.628   2.537  1.00  1.00
ATOM    733 2HB  TYR    46      -5.591   3.572   3.176  1.00  0.00
ATOM    734 3HB  TYR    46      -7.001   2.676   2.587  1.00  0.00
ATOM    735  CG  TYR    46      -6.050   3.901   1.111  1.00  1.00
ATOM    736  CD1 TYR    46      -5.180   4.963   0.835  1.00  1.00
ATOM    737 1HD  TYR    46      -4.815   5.585   1.639  1.00  0.00
ATOM    738  CE1 TYR    46      -4.783   5.218  -0.482  1.00  1.00
ATOM    739 1HE  TYR    46      -4.112   6.037  -0.695  1.00  0.00
ATOM    740  CZ  TYR    46      -5.255   4.412  -1.524  1.00  1.00
ATOM    741  CE2 TYR    46      -6.124   3.349  -1.250  1.00  1.00
ATOM    742 2HE  TYR    46      -6.487   2.726  -2.054  1.00  0.00
ATOM    743  CD2 TYR    46      -6.522   3.093   0.068  1.00  1.00
ATOM    744 2HD  TYR    46      -7.192   2.273   0.280  1.00  0.00
ATOM    745  OH  TYR    46      -4.864   4.665  -2.823  1.00  1.00
ATOM    746  HH  TYR    46      -5.247   4.053  -3.456  1.00  0.00
ATOM    747  C   TYR    46      -8.587   4.882   2.086  1.00  1.00
ATOM    748  O   TYR    46      -8.663   5.812   1.284  1.00  1.00
ATOM    749  N   LEU    47      -9.521   3.946   2.202  1.00  1.00
ATOM    750  HN  LEU    47      -9.413   3.203   2.878  1.00  0.00
ATOM    751  CA  LEU    47     -10.719   3.963   1.364  1.00  1.00
ATOM    752  HA  LEU    47     -10.410   3.940   0.319  1.00  0.00
ATOM    753  CB  LEU    47     -11.583   2.731   1.653  1.00  1.00
ATOM    754 2HB  LEU    47     -11.671   2.595   2.731  1.00  0.00
ATOM    755 3HB  LEU    47     -12.574   2.875   1.223  1.00  0.00
ATOM    756  CG  LEU    47     -10.934   1.482   1.033  1.00  1.00
ATOM    757  HG  LEU    47      -9.885   1.443   1.325  1.00  0.00
ATOM    758  CD1 LEU    47     -11.649   0.228   1.554  1.00  1.00
ATOM    759 1HD1 LEU    47     -11.185  -0.661   1.126  1.00  0.00
ATOM    760 2HD1 LEU    47     -11.571   0.190   2.641  1.00  0.00
ATOM    761 3HD1 LEU    47     -12.700   0.262   1.266  1.00  0.00
ATOM    762  CD2 LEU    47     -11.025   1.534  -0.513  1.00  1.00
ATOM    763 1HD2 LEU    47     -10.558   0.646  -0.939  1.00  0.00
ATOM    764 2HD2 LEU    47     -12.072   1.571  -0.814  1.00  0.00
ATOM    765 3HD2 LEU    47     -10.511   2.423  -0.877  1.00  0.00
ATOM    766  C   LEU    47     -11.533   5.227   1.610  1.00  1.00
ATOM    767  O   LEU    47     -12.036   5.844   0.671  1.00  1.00
ATOM    768  N   ILE    48     -11.657   5.610   2.871  1.00  1.00
ATOM    769  HN  ILE    48     -11.225   5.077   3.613  1.00  0.00
ATOM    770  CA  ILE    48     -12.415   6.804   3.212  1.00  1.00
ATOM    771  HA  ILE    48     -13.439   6.684   2.859  1.00  0.00
ATOM    772  CB  ILE    48     -12.428   6.992   4.735  1.00  1.00
ATOM    773  HB  ILE    48     -11.411   6.900   5.115  1.00  0.00
ATOM    774  CG2 ILE    48     -12.973   8.378   5.090  1.00  1.00
ATOM    775 1HG2 ILE    48     -12.973   8.505   6.173  1.00  0.00
ATOM    776 2HG2 ILE    48     -12.344   9.142   4.635  1.00  0.00
ATOM    777 3HG2 ILE    48     -13.992   8.474   4.714  1.00  0.00
ATOM    778  CG1 ILE    48     -13.306   5.915   5.379  1.00  1.00
ATOM    779 2HG1 ILE    48     -14.354   6.122   5.160  1.00  0.00
ATOM    780 3HG1 ILE    48     -13.037   4.938   4.976  1.00  0.00
ATOM    781  CD1 ILE    48     -13.093   5.916   6.896  1.00  1.00
ATOM    782 1HD1 ILE    48     -13.720   5.149   7.352  1.00  0.00
ATOM    783 2HD1 ILE    48     -12.046   5.707   7.116  1.00  0.00
ATOM    784 3HD1 ILE    48     -13.362   6.892   7.300  1.00  0.00
ATOM    785  C   ILE    48     -11.797   8.028   2.543  1.00  1.00
ATOM    786  O   ILE    48     -12.506   8.858   1.976  1.00  1.00
END
