
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 1063),  selected  133 , name 2gey_D
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 2gey_D.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_D      -       -           -
LGA    M     3_D      N       2          1.992
LGA    A     4_D      S       3          3.654
LGA    E     5_D      E       4          4.013
LGA    R     6_D      I       5          1.950
LGA    K     7_D      E       6          2.126
LGA    A     8_D      L       7          3.800
LGA    L     9_D      P       8          2.996
LGA    C    10_D      V       9          1.004
LGA    L    11_D      Q      10          1.356
LGA    E    12_D      K      11          1.132
LGA    M    13_D      Q      12          0.733
LGA    V    14_D      L      13          0.707
LGA    A    15_D      E      14          0.738
LGA    A    16_D      A      15          0.578
LGA    W    17_D      Y      16          1.004
LGA    N    18_D      N      17          1.763
LGA    R    19_D      A      18          0.905
LGA    W    20_D      R      19          0.958
LGA    D    21_D      D      20          1.250
LGA    L    22_D      I      21          1.502
LGA    S    23_D      D      22          1.689
LGA    G    24_D      A      23          1.437
LGA    I    25_D      F      24          0.796
LGA    I    26_D      M      25          0.618
LGA    K    27_D      A      26          0.934
LGA    H    28_D      W      27          0.991
LGA    W    29_D      W      28          1.116
LGA    S    30_D      A      29          0.698
LGA    P    31_D      D      30          1.102
LGA    D    32_D      D      31          1.753
LGA    I    33_D      C      32          0.767
LGA    V    34_D      Q      33          1.026
LGA    H    35_D      Y      34          1.180
LGA    Y    36_D      Y      35          1.483
LGA    S    37_D      A      36          1.586
LGA    E    38_D      F      37          2.844
LGA    -       -      P      38           -
LGA    D    39_D      A      39          0.935
LGA    N    40_D      T      40          1.949
LGA    E    41_D      L      41          1.517
LGA    V    42_D      L      42          1.623
LGA    S    43_D      A      43          1.640
LGA    -       -      G      44           -
LGA    -       -      N      45           -
LGA    S    44_D      A      46          4.471
LGA    A    45_D      A      47          4.787
LGA    D    46_D      E      48          4.442
LGA    M    47_D      I      49          3.365
LGA    V    48_D      R      50          3.090
LGA    K    49_D      V      51          3.497
LGA    L    50_D      R      52          2.827
LGA    M    51_D      H      53          1.090
LGA    E    52_D      I      54          1.820
LGA    G    53_D      E      55          1.883
LGA    G    54_D      R      56          1.619
LGA    L    55_D      F      57          1.725
LGA    K    56_D      K      58          1.494
LGA    A    57_D      E      59          2.907
LGA    F    58_D      -       -           -
LGA    P    59_D      P      60          1.571
LGA    D    60_D      D      61          3.606
LGA    L    61_D      L      62          2.145
LGA    Q    62_D      Y      63          1.969
LGA    L    63_D      G      64          1.597
LGA    E    64_D      E      65          1.920
LGA    V    65_D      L      66          1.701
LGA    K    66_D      L      67          1.432
LGA    S    67_D      T      68          1.312
LGA    I    68_D      R      69          1.119
LGA    M    69_D      V      70          1.114
LGA    A    70_D      I      71          1.060
LGA    E    71_D      V      72          1.521
LGA    E    72_D      G      73          1.821
LGA    D    73_D      N      74          1.042
LGA    R    74_D      V      75          0.999
LGA    V    75_D      V      76          1.035
LGA    A    76_D      I      77          1.126
LGA    L    77_D      D      78          1.173
LGA    R    78_D      H      79          0.878
LGA    I    79_D      E      80          0.849
LGA    T    80_D      T      81          1.005
LGA    V    81_D      V      82          1.746
LGA    T    82_D      T      83          2.038
LGA    A    83_D      R      84          4.409
LGA    T    84_D      -       -           -
LGA    H    85_D      N      85          3.314
LGA    Q    86_D      -       -           -
LGA    G    87_D      -       -           -
LGA    E    88_D      -       -           -
LGA    F    89_D      -       -           -
LGA    M    90_D      F      86           #
LGA    G    91_D      -       -           -
LGA    V    92_D      -       -           -
LGA    Q    93_D      -       -           -
LGA    P    94_D      -       -           -
LGA    T    95_D      P      87           #
LGA    G    96_D      E      88           -
LGA    Q    97_D      G      89          5.199
LGA    R    98_D      K      90          3.219
LGA    V    99_D      G      91          2.403
LGA    S   100_D      E      92          0.720
LGA    W   101_D      V      93          0.910
LGA    H   102_D      D      94          1.354
LGA    L   103_D      V      95          0.731
LGA    V   104_D      A      96          0.741
LGA    E   105_D      C      97          1.016
LGA    E   106_D      I      98          1.072
LGA    L   107_D      Y      99          0.993
LGA    R   108_D      E     100          1.030
LGA    F   109_D      V     101          1.035
LGA    V   110_D      E     102          1.606
LGA    D   111_D      N     103          2.035
LGA    G   112_D      G     104          1.299
LGA    K   113_D      R     105          0.567
LGA    V   114_D      I     106          0.533
LGA    V   115_D      A     107          0.487
LGA    E   116_D      K     108          0.571
LGA    H   117_D      A     109          0.393
LGA    W   118_D      W     110          0.835
LGA    D   119_D      F     111          0.682
LGA    V   120_D      K     112          0.498
LGA    I   121_D      I     113          1.839
LGA    N   122_D      G     114          3.559
LGA    M   123_D      E     115          5.397
LGA    R   124_D      P     116          2.663
LGA    P   125_D      R     117          3.137
LGA    L   126_D      -       -           -
LGA    L   127_D      -       -           -
LGA    V   128_D      -       -           -
LGA    R   129_D      I     118           #
LGA    L   130_D      -       -           -
LGA    G   131_D      -       -           -
LGA    K   132_D      -       -           -
LGA    L   133_D      -       -           -
LGA    P   134_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133  117    5.0    110    2.06    18.18     75.783     5.082

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.937068 * X  +   0.163485 * Y  +  -0.308507 * Z  +  13.956394
  Y_new =  -0.270119 * X  +   0.220403 * Y  +   0.937261 * Z  + -31.918053
  Z_new =   0.221224 * X  +   0.961611 * Y  +  -0.162373 * Z  + -22.318995 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.738073   -1.403519  [ DEG:    99.5843    -80.4157 ]
  Theta =  -0.223070   -2.918523  [ DEG:   -12.7809   -167.2191 ]
  Phi   =  -2.860941    0.280651  [ DEG:  -163.9199     16.0801 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gey_D                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gey_D.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133  117   5.0  110   2.06   18.18  75.783
REMARK  ---------------------------------------------------------- 
MOLECULE 2gey_D
HEADER    OXIDOREDUCTASE                          21-MAR-06   2GEY              
TITLE     CRYSTAL STRUCTURE OF ACLR A PUTATIVE HYDROXYLASE FROM                 
TITLE    2 STREPTOMYCES GALILAEUS                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACLR PROTEIN;                                              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PUTATIVE HYDROXYLASE;                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES GALILAEUS;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: ATCC31133;                                                   
SOURCE   5 GENE: ACLR;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET30B                                    
KEYWDS    ALPHA+BETA BARREL                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.BEINKER,B.LOHKAMP,G.SCHNEIDER                                       
REVDAT   1   18-JUL-06 2GEY    0                                                
JRNL        AUTH   P.BEINKER,B.LOHKAMP,T.PELTONEN,J.NIEMI,P.MANTSALA,           
JRNL        AUTH 2 G.SCHNEIDER                                                  
JRNL        TITL   CRYSTAL STRUCTURES OF SNOAL2 AND ACLR: TWO                   
JRNL        TITL 2 PUTATIVE HYDROXYLASES IN THE BIOSYNTHESIS OF                 
JRNL        TITL 3 AROMATIC POLYKETIDE ANTIBIOTICS                              
JRNL        REF    J.MOL.BIOL.                   V. 359   728 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2GEY A    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY B    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY C    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY D    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
SEQRES   1 A  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 A  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 A  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 A  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 A  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 A  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 A  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 A  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 A  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 A  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 A  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 A  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 A  158  HIS HIS                                                      
SEQRES   1 B  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 B  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 B  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 B  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 B  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 B  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 B  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 B  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 B  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 B  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 B  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 B  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 B  158  HIS HIS                                                      
SEQRES   1 C  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 C  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 C  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 C  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 C  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 C  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 C  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 C  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 C  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 C  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 C  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 C  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 C  158  HIS HIS                                                      
SEQRES   1 D  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 D  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 D  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 D  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 D  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 D  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 D  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 D  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 D  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 D  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 D  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 D  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 D  158  HIS HIS                                                      
HET    PG4   1001      13                                                       
HET    PG4   1002      13                                                       
HET    PG4   1003      13                                                       
HET    PG4   1004      13                                                       
HET    GOL   2001       6                                                       
HET    GOL   2002       6                                                       
HET    GOL   2003       6                                                       
HET    GOL   2004       6                                                       
HET    GOL   2005       6                                                       
HET    PEG   3001       7                                                       
HETNAM     PG4 TETRAETHYLENE GLYCOL                                             
HETNAM     GOL GLYCEROL                                                         
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
FORMUL   5  PG4    4(C8 H18 O5)                                                 
FORMUL   9  GOL    5(C3 H8 O3)                                                  
FORMUL  14  PEG    C4 H10 O3                                                    
FORMUL  15  HOH   *548(H2 O)                                                    
CRYST1   80.908   81.724  136.640  90.00  90.00  90.00 P 21 21 21   16          
ATOM   3653  N   SER D   2       0.580  -2.873  -3.515  1.00 25.49           N  
ATOM   3654  CA  SER D   2       1.311  -2.479  -2.277  1.00 25.54           C  
ATOM   3655  C   SER D   2       1.496  -3.672  -1.352  1.00 25.04           C  
ATOM   3656  O   SER D   2       0.831  -4.704  -1.500  1.00 24.29           O  
ATOM   3657  CB  SER D   2       0.541  -1.391  -1.531  1.00 25.71           C  
ATOM   3658  OG  SER D   2      -0.614  -1.924  -0.894  1.00 25.87           O  
ATOM   3659  N   MET D   3       2.390  -3.517  -0.380  1.00 24.69           N  
ATOM   3660  CA  MET D   3       2.597  -4.546   0.629  1.00 25.28           C  
ATOM   3661  C   MET D   3       1.300  -4.863   1.369  1.00 24.89           C  
ATOM   3662  O   MET D   3       0.988  -6.029   1.614  1.00 25.25           O  
ATOM   3663  CB  MET D   3       3.681  -4.102   1.609  1.00 25.17           C  
ATOM   3664  CG  MET D   3       5.060  -4.069   0.979  1.00 25.37           C  
ATOM   3665  SD  MET D   3       6.333  -3.549   2.147  1.00 27.19           S  
ATOM   3666  CE  MET D   3       6.060  -1.782   2.202  1.00 28.34           C  
ATOM   3667  N   ALA D   4       0.536  -3.825   1.699  1.00 24.99           N  
ATOM   3668  CA  ALA D   4      -0.732  -4.001   2.404  1.00 24.57           C  
ATOM   3669  C   ALA D   4      -1.708  -4.862   1.606  1.00 24.05           C  
ATOM   3670  O   ALA D   4      -2.361  -5.743   2.160  1.00 23.81           O  
ATOM   3671  CB  ALA D   4      -1.348  -2.662   2.723  1.00 24.88           C  
ATOM   3672  N   GLU D   5      -1.802  -4.600   0.304  1.00 24.00           N  
ATOM   3673  CA  GLU D   5      -2.689  -5.366  -0.571  1.00 24.24           C  
ATOM   3674  C   GLU D   5      -2.232  -6.805  -0.744  1.00 23.92           C  
ATOM   3675  O   GLU D   5      -3.056  -7.717  -0.740  1.00 23.67           O  
ATOM   3676  CB  GLU D   5      -2.823  -4.672  -1.928  1.00 24.24           C  
ATOM   3677  CG  GLU D   5      -3.548  -3.353  -1.801  1.00 24.45           C  
ATOM   3678  CD  GLU D   5      -3.298  -2.390  -2.940  1.00 26.11           C  
ATOM   3679  OE1 GLU D   5      -2.393  -2.626  -3.779  1.00 29.75           O  
ATOM   3680  OE2 GLU D   5      -4.030  -1.386  -2.989  1.00 26.02           O  
ATOM   3681  N   ARG D   6      -0.924  -7.012  -0.889  1.00 23.65           N  
ATOM   3682  CA  ARG D   6      -0.379  -8.364  -1.014  1.00 23.97           C  
ATOM   3683  C   ARG D   6      -0.548  -9.166   0.280  1.00 24.25           C  
ATOM   3684  O   ARG D   6      -0.887 -10.350   0.233  1.00 23.75           O  
ATOM   3685  CB  ARG D   6       1.077  -8.319  -1.480  1.00 24.32           C  
ATOM   3686  CG  ARG D   6       1.194  -7.877  -2.926  1.00 23.18           C  
ATOM   3687  CD  ARG D   6       2.620  -7.930  -3.438  1.00 24.97           C  
ATOM   3688  NE  ARG D   6       3.464  -6.850  -2.915  1.00 25.02           N  
ATOM   3689  CZ  ARG D   6       3.536  -5.611  -3.417  1.00 26.73           C  
ATOM   3690  NH1 ARG D   6       2.807  -5.244  -4.456  1.00 27.64           N  
ATOM   3691  NH2 ARG D   6       4.354  -4.720  -2.864  1.00 27.22           N  
ATOM   3692  N   LYS D   7      -0.406  -8.510   1.429  1.00 24.21           N  
ATOM   3693  CA  LYS D   7      -0.718  -9.178   2.705  1.00 25.10           C  
ATOM   3694  C   LYS D   7      -2.187  -9.599   2.757  1.00 25.02           C  
ATOM   3695  O   LYS D   7      -2.508 -10.717   3.166  1.00 25.32           O  
ATOM   3696  CB  LYS D   7      -0.395  -8.279   3.894  1.00 25.11           C  
ATOM   3697  CG  LYS D   7       1.072  -8.207   4.221  1.00 27.62           C  
ATOM   3698  CD  LYS D   7       1.211  -7.603   5.605  1.00 27.94           C  
ATOM   3699  CE  LYS D   7       2.415  -6.756   5.750  1.00 32.84           C  
ATOM   3700  NZ  LYS D   7       2.212  -5.792   6.896  1.00 32.03           N  
ATOM   3701  N   ALA D   8      -3.072  -8.708   2.312  1.00 25.05           N  
ATOM   3702  CA  ALA D   8      -4.504  -8.985   2.294  1.00 25.25           C  
ATOM   3703  C   ALA D   8      -4.816 -10.187   1.406  1.00 25.29           C  
ATOM   3704  O   ALA D   8      -5.617 -11.050   1.784  1.00 25.91           O  
ATOM   3705  CB  ALA D   8      -5.280  -7.766   1.848  1.00 25.49           C  
ATOM   3706  N   LEU D   9      -4.175 -10.260   0.243  1.00 25.15           N  
ATOM   3707  CA  LEU D   9      -4.375 -11.394  -0.657  1.00 25.49           C  
ATOM   3708  C   LEU D   9      -3.896 -12.701  -0.021  1.00 25.62           C  
ATOM   3709  O   LEU D   9      -4.580 -13.719  -0.089  1.00 25.72           O  
ATOM   3710  CB  LEU D   9      -3.700 -11.146  -2.008  1.00 25.52           C  
ATOM   3711  CG  LEU D   9      -4.443 -10.118  -2.863  1.00 25.84           C  
ATOM   3712  CD1 LEU D   9      -3.542  -9.627  -3.995  1.00 27.45           C  
ATOM   3713  CD2 LEU D   9      -5.748 -10.684  -3.413  1.00 25.60           C  
ATOM   3714  N   CYS D  10      -2.737 -12.677   0.627  1.00 25.69           N  
ATOM   3715  CA  CYS D  10      -2.249 -13.874   1.322  1.00 26.07           C  
ATOM   3716  C   CYS D  10      -3.194 -14.314   2.429  1.00 26.03           C  
ATOM   3717  O   CYS D  10      -3.402 -15.504   2.610  1.00 26.09           O  
ATOM   3718  CB  CYS D  10      -0.859 -13.652   1.900  1.00 26.27           C  
ATOM   3719  SG  CYS D  10       0.377 -13.466   0.609  1.00 28.96           S  
ATOM   3720  N   LEU D  11      -3.772 -13.367   3.163  1.00 25.75           N  
ATOM   3721  CA  LEU D  11      -4.731 -13.725   4.194  1.00 26.06           C  
ATOM   3722  C   LEU D  11      -6.038 -14.309   3.620  1.00 26.16           C  
ATOM   3723  O   LEU D  11      -6.709 -15.119   4.278  1.00 25.59           O  
ATOM   3724  CB  LEU D  11      -4.996 -12.538   5.115  1.00 26.47           C  
ATOM   3725  CG  LEU D  11      -3.789 -12.107   5.951  1.00 26.79           C  
ATOM   3726  CD1 LEU D  11      -4.129 -10.892   6.809  1.00 29.93           C  
ATOM   3727  CD2 LEU D  11      -3.263 -13.259   6.816  1.00 27.41           C  
ATOM   3728  N   GLU D  12      -6.399 -13.928   2.395  1.00 26.05           N  
ATOM   3729  CA  GLU D  12      -7.525 -14.582   1.715  1.00 26.57           C  
ATOM   3730  C   GLU D  12      -7.199 -16.032   1.371  1.00 26.46           C  
ATOM   3731  O   GLU D  12      -8.083 -16.896   1.372  1.00 26.63           O  
ATOM   3732  CB  GLU D  12      -7.934 -13.816   0.445  1.00 27.53           C  
ATOM   3733  CG  GLU D  12      -8.580 -12.482   0.738  1.00 30.77           C  
ATOM   3734  CD  GLU D  12      -9.777 -12.612   1.642  1.00 36.54           C  
ATOM   3735  OE1 GLU D  12     -10.757 -13.255   1.226  1.00 40.54           O  
ATOM   3736  OE2 GLU D  12      -9.724 -12.109   2.788  1.00 40.99           O  
ATOM   3737  N   MET D  13      -5.934 -16.299   1.055  1.00 26.16           N  
ATOM   3738  CA  MET D  13      -5.480 -17.660   0.774  0.50 26.43           C  
ATOM   3740  C   MET D  13      -5.561 -18.491   2.057  1.00 26.12           C  
ATOM   3741  O   MET D  13      -6.005 -19.631   2.036  1.00 25.97           O  
ATOM   3742  CB  MET D  13      -4.058 -17.658   0.203  0.50 26.52           C  
ATOM   3744  CG  MET D  13      -3.895 -16.788  -1.047  0.50 26.98           C  
ATOM   3746  SD  MET D  13      -2.182 -16.611  -1.567  0.50 28.35           S  
ATOM   3748  CE  MET D  13      -1.988 -18.139  -2.495  0.50 28.88           C  
ATOM   3750  N   VAL D  14      -5.162 -17.890   3.180  1.00 25.57           N  
ATOM   3751  CA  VAL D  14      -5.300 -18.530   4.505  1.00 25.50           C  
ATOM   3752  C   VAL D  14      -6.778 -18.799   4.808  1.00 25.19           C  
ATOM   3753  O   VAL D  14      -7.130 -19.887   5.266  1.00 24.40           O  
ATOM   3754  CB  VAL D  14      -4.661 -17.674   5.622  1.00 25.74           C  
ATOM   3755  CG1 VAL D  14      -4.974 -18.244   7.007  1.00 26.06           C  
ATOM   3756  CG2 VAL D  14      -3.151 -17.586   5.423  1.00 26.54           C  
ATOM   3757  N   ALA D  15      -7.644 -17.824   4.517  1.00 24.55           N  
ATOM   3758  CA  ALA D  15      -9.079 -18.000   4.728  1.00 24.45           C  
ATOM   3759  C   ALA D  15      -9.618 -19.163   3.890  1.00 24.37           C  
ATOM   3760  O   ALA D  15     -10.476 -19.912   4.353  1.00 24.84           O  
ATOM   3761  CB  ALA D  15      -9.834 -16.729   4.413  1.00 24.63           C  
ATOM   3762  N   ALA D  16      -9.111 -19.303   2.668  1.00 24.16           N  
ATOM   3763  CA  ALA D  16      -9.502 -20.404   1.776  1.00 24.28           C  
ATOM   3764  C   ALA D  16      -9.126 -21.755   2.383  1.00 24.47           C  
ATOM   3765  O   ALA D  16      -9.933 -22.691   2.367  1.00 24.44           O  
ATOM   3766  CB  ALA D  16      -8.860 -20.244   0.414  1.00 24.82           C  
ATOM   3767  N   TRP D  17      -7.908 -21.858   2.910  1.00 24.10           N  
ATOM   3768  CA  TRP D  17      -7.499 -23.063   3.641  1.00 24.58           C  
ATOM   3769  C   TRP D  17      -8.469 -23.350   4.778  1.00 24.24           C  
ATOM   3770  O   TRP D  17      -8.884 -24.486   4.972  1.00 23.89           O  
ATOM   3771  CB  TRP D  17      -6.101 -22.924   4.221  1.00 25.51           C  
ATOM   3772  CG  TRP D  17      -5.032 -23.406   3.334  1.00 27.01           C  
ATOM   3773  CD1 TRP D  17      -4.049 -22.665   2.768  1.00 28.11           C  
ATOM   3774  CD2 TRP D  17      -4.825 -24.752   2.906  1.00 26.96           C  
ATOM   3775  NE1 TRP D  17      -3.227 -23.468   2.015  1.00 28.76           N  
ATOM   3776  CE2 TRP D  17      -3.685 -24.754   2.080  1.00 27.08           C  
ATOM   3777  CE3 TRP D  17      -5.493 -25.955   3.140  1.00 27.58           C  
ATOM   3778  CZ2 TRP D  17      -3.199 -25.917   1.480  1.00 28.47           C  
ATOM   3779  CZ3 TRP D  17      -5.008 -27.112   2.545  1.00 28.68           C  
ATOM   3780  CH2 TRP D  17      -3.873 -27.078   1.719  1.00 28.14           C  
ATOM   3781  N   ASN D  18      -8.827 -22.302   5.514  1.00 24.09           N  
ATOM   3782  CA  ASN D  18      -9.646 -22.443   6.709  1.00 24.57           C  
ATOM   3783  C   ASN D  18     -11.113 -22.767   6.439  1.00 24.66           C  
ATOM   3784  O   ASN D  18     -11.847 -23.117   7.361  1.00 24.31           O  
ATOM   3785  CB  ASN D  18      -9.493 -21.210   7.604  1.00 25.07           C  
ATOM   3786  CG  ASN D  18      -8.191 -21.225   8.382  1.00 26.39           C  
ATOM   3787  OD1 ASN D  18      -7.621 -22.297   8.618  1.00 26.48           O  
ATOM   3788  ND2 ASN D  18      -7.712 -20.045   8.793  1.00 23.77           N  
ATOM   3789  N   ARG D  19     -11.540 -22.667   5.182  1.00 24.70           N  
ATOM   3790  CA  ARG D  19     -12.839 -23.225   4.787  1.00 24.96           C  
ATOM   3791  C   ARG D  19     -12.678 -24.424   3.844  1.00 25.24           C  
ATOM   3792  O   ARG D  19     -13.651 -24.866   3.216  1.00 24.35           O  
ATOM   3793  CB  ARG D  19     -13.740 -22.138   4.187  1.00 25.39           C  
ATOM   3794  CG  ARG D  19     -13.211 -21.509   2.920  1.00 25.28           C  
ATOM   3795  CD  ARG D  19     -14.252 -20.629   2.201  1.00 25.98           C  
ATOM   3796  NE  ARG D  19     -13.672 -20.178   0.941  1.00 26.65           N  
ATOM   3797  CZ  ARG D  19     -12.886 -19.112   0.809  1.00 27.79           C  
ATOM   3798  NH1 ARG D  19     -12.641 -18.314   1.830  1.00 27.31           N  
ATOM   3799  NH2 ARG D  19     -12.353 -18.831  -0.371  1.00 29.22           N  
ATOM   3800  N   TRP D  20     -11.456 -24.952   3.774  1.00 25.12           N  
ATOM   3801  CA  TRP D  20     -11.140 -26.195   3.051  1.00 25.49           C  
ATOM   3802  C   TRP D  20     -11.465 -26.099   1.558  1.00 25.74           C  
ATOM   3803  O   TRP D  20     -11.989 -27.045   0.941  1.00 25.82           O  
ATOM   3804  CB  TRP D  20     -11.821 -27.392   3.736  1.00 25.65           C  
ATOM   3805  CG  TRP D  20     -11.629 -27.311   5.223  1.00 25.75           C  
ATOM   3806  CD1 TRP D  20     -10.450 -27.411   5.899  1.00 25.92           C  
ATOM   3807  CD2 TRP D  20     -12.629 -27.041   6.206  1.00 26.03           C  
ATOM   3808  NE1 TRP D  20     -10.653 -27.240   7.237  1.00 25.41           N  
ATOM   3809  CE2 TRP D  20     -11.980 -27.009   7.459  1.00 26.36           C  
ATOM   3810  CE3 TRP D  20     -14.011 -26.828   6.153  1.00 26.59           C  
ATOM   3811  CZ2 TRP D  20     -12.666 -26.780   8.652  1.00 26.25           C  
ATOM   3812  CZ3 TRP D  20     -14.691 -26.596   7.338  1.00 26.38           C  
ATOM   3813  CH2 TRP D  20     -14.017 -26.575   8.571  1.00 26.37           C  
ATOM   3814  N   ASP D  21     -11.113 -24.937   0.999  1.00 25.96           N  
ATOM   3815  CA  ASP D  21     -11.413 -24.573  -0.375  1.00 26.17           C  
ATOM   3816  C   ASP D  21     -10.109 -24.422  -1.176  1.00 26.46           C  
ATOM   3817  O   ASP D  21      -9.548 -23.332  -1.276  1.00 25.89           O  
ATOM   3818  CB  ASP D  21     -12.207 -23.270  -0.382  1.00 26.06           C  
ATOM   3819  CG  ASP D  21     -12.534 -22.785  -1.788  1.00 27.52           C  
ATOM   3820  OD1 ASP D  21     -12.435 -23.580  -2.754  1.00 29.34           O  
ATOM   3821  OD2 ASP D  21     -12.875 -21.597  -1.914  1.00 31.19           O  
ATOM   3822  N   LEU D  22      -9.620 -25.519  -1.747  1.00 26.87           N  
ATOM   3823  CA  LEU D  22      -8.328 -25.469  -2.447  1.00 27.73           C  
ATOM   3824  C   LEU D  22      -8.366 -24.547  -3.666  1.00 27.74           C  
ATOM   3825  O   LEU D  22      -7.371 -23.896  -3.993  1.00 27.73           O  
ATOM   3826  CB  LEU D  22      -7.872 -26.863  -2.854  1.00 28.28           C  
ATOM   3827  CG  LEU D  22      -7.579 -27.819  -1.696  1.00 29.36           C  
ATOM   3828  CD1 LEU D  22      -6.955 -29.099  -2.237  1.00 31.12           C  
ATOM   3829  CD2 LEU D  22      -6.692 -27.192  -0.647  1.00 30.30           C  
ATOM   3830  N   SER D  23      -9.521 -24.477  -4.314  1.00 28.00           N  
ATOM   3831  CA  SER D  23      -9.672 -23.625  -5.485  0.50 28.18           C  
ATOM   3833  C   SER D  23      -9.462 -22.150  -5.132  1.00 28.37           C  
ATOM   3834  O   SER D  23      -8.968 -21.379  -5.958  1.00 28.33           O  
ATOM   3835  CB  SER D  23     -11.030 -23.859  -6.150  0.50 28.15           C  
ATOM   3837  OG  SER D  23     -11.060 -25.136  -6.767  0.50 28.35           O  
ATOM   3839  N   GLY D  24      -9.802 -21.772  -3.891  1.00 28.25           N  
ATOM   3840  CA  GLY D  24      -9.611 -20.411  -3.398  1.00 28.43           C  
ATOM   3841  C   GLY D  24      -8.163 -20.015  -3.171  1.00 28.76           C  
ATOM   3842  O   GLY D  24      -7.854 -18.833  -2.977  1.00 29.53           O  
ATOM   3843  N   ILE D  25      -7.271 -21.006  -3.161  1.00 28.49           N  
ATOM   3844  CA  ILE D  25      -5.837 -20.773  -3.087  1.00 28.24           C  
ATOM   3845  C   ILE D  25      -5.258 -20.758  -4.497  1.00 27.84           C  
ATOM   3846  O   ILE D  25      -4.550 -19.823  -4.888  1.00 28.01           O  
ATOM   3847  CB  ILE D  25      -5.151 -21.880  -2.265  1.00 28.16           C  
ATOM   3848  CG1 ILE D  25      -5.657 -21.838  -0.814  1.00 30.34           C  
ATOM   3849  CG2 ILE D  25      -3.631 -21.740  -2.321  1.00 29.07           C  
ATOM   3850  CD1 ILE D  25      -5.904 -23.168  -0.220  1.00 31.43           C  
ATOM   3851  N   ILE D  26      -5.582 -21.803  -5.254  1.00 27.12           N  
ATOM   3852  CA  ILE D  26      -5.000 -22.035  -6.566  1.00 27.07           C  
ATOM   3853  C   ILE D  26      -5.367 -20.928  -7.553  1.00 27.07           C  
ATOM   3854  O   ILE D  26      -4.607 -20.638  -8.475  1.00 26.34           O  
ATOM   3855  CB  ILE D  26      -5.443 -23.421  -7.108  1.00 26.81           C  
ATOM   3856  CG1 ILE D  26      -4.857 -24.533  -6.221  1.00 26.38           C  
ATOM   3857  CG2 ILE D  26      -5.032 -23.595  -8.556  1.00 27.28           C  
ATOM   3858  CD1 ILE D  26      -5.531 -25.883  -6.371  1.00 27.87           C  
ATOM   3859  N   LYS D  27      -6.525 -20.304  -7.361  1.00 26.85           N  
ATOM   3860  CA  LYS D  27      -6.940 -19.228  -8.254  1.00 27.66           C  
ATOM   3861  C   LYS D  27      -5.973 -18.037  -8.250  1.00 27.54           C  
ATOM   3862  O   LYS D  27      -5.960 -17.266  -9.203  1.00 27.21           O  
ATOM   3863  CB  LYS D  27      -8.350 -18.754  -7.914  1.00 27.77           C  
ATOM   3864  CG  LYS D  27      -8.499 -18.012  -6.611  1.00 28.76           C  
ATOM   3865  CD  LYS D  27      -9.960 -17.714  -6.382  1.00 29.43           C  
ATOM   3866  CE  LYS D  27     -10.200 -16.911  -5.139  1.00 32.30           C  
ATOM   3867  NZ  LYS D  27     -11.611 -16.414  -5.166  1.00 33.44           N  
ATOM   3868  N   HIS D  28      -5.180 -17.896  -7.188  1.00 27.44           N  
ATOM   3869  CA  HIS D  28      -4.197 -16.807  -7.090  1.00 28.07           C  
ATOM   3870  C   HIS D  28      -2.834 -17.141  -7.692  1.00 28.25           C  
ATOM   3871  O   HIS D  28      -1.933 -16.291  -7.727  1.00 28.55           O  
ATOM   3872  CB  HIS D  28      -4.028 -16.396  -5.643  1.00 28.96           C  
ATOM   3873  CG  HIS D  28      -5.286 -15.871  -5.029  1.00 30.50           C  
ATOM   3874  ND1 HIS D  28      -5.886 -14.701  -5.447  1.00 34.00           N  
ATOM   3875  CD2 HIS D  28      -6.082 -16.379  -4.059  1.00 31.82           C  
ATOM   3876  CE1 HIS D  28      -6.983 -14.496  -4.736  1.00 33.25           C  
ATOM   3877  NE2 HIS D  28      -7.125 -15.500  -3.889  1.00 31.98           N  
ATOM   3878  N   TRP D  29      -2.676 -18.376  -8.146  1.00 27.76           N  
ATOM   3879  CA  TRP D  29      -1.433 -18.813  -8.754  1.00 27.30           C  
ATOM   3880  C   TRP D  29      -1.331 -18.313 -10.185  1.00 27.44           C  
ATOM   3881  O   TRP D  29      -2.301 -18.379 -10.950  1.00 27.21           O  
ATOM   3882  CB  TRP D  29      -1.368 -20.339  -8.775  1.00 27.30           C  
ATOM   3883  CG  TRP D  29      -1.238 -21.009  -7.430  1.00 26.62           C  
ATOM   3884  CD1 TRP D  29      -1.235 -20.419  -6.206  1.00 27.24           C  
ATOM   3885  CD2 TRP D  29      -1.107 -22.415  -7.199  1.00 26.63           C  
ATOM   3886  NE1 TRP D  29      -1.098 -21.370  -5.218  1.00 27.53           N  
ATOM   3887  CE2 TRP D  29      -1.020 -22.605  -5.805  1.00 27.25           C  
ATOM   3888  CE3 TRP D  29      -1.050 -23.531  -8.038  1.00 27.62           C  
ATOM   3889  CZ2 TRP D  29      -0.882 -23.871  -5.230  1.00 27.97           C  
ATOM   3890  CZ3 TRP D  29      -0.907 -24.793  -7.459  1.00 27.64           C  
ATOM   3891  CH2 TRP D  29      -0.828 -24.947  -6.077  1.00 26.87           C  
ATOM   3892  N   SER D  30      -0.155 -17.818 -10.554  1.00 27.32           N  
ATOM   3893  CA  SER D  30       0.142 -17.531 -11.943  0.70 27.31           C  
ATOM   3895  C   SER D  30       0.198 -18.854 -12.712  1.00 27.81           C  
ATOM   3896  O   SER D  30       0.573 -19.883 -12.141  1.00 27.61           O  
ATOM   3897  CB  SER D  30       1.483 -16.804 -12.078  0.70 27.34           C  
ATOM   3899  OG  SER D  30       1.958 -16.839 -13.411  0.70 24.62           O  
ATOM   3901  N   PRO D  31      -0.163 -18.836 -14.005  1.00 28.27           N  
ATOM   3902  CA  PRO D  31       0.047 -20.047 -14.809  1.00 28.59           C  
ATOM   3903  C   PRO D  31       1.514 -20.471 -14.845  1.00 28.74           C  
ATOM   3904  O   PRO D  31       1.816 -21.644 -15.085  1.00 29.66           O  
ATOM   3905  CB  PRO D  31      -0.390 -19.632 -16.216  1.00 28.75           C  
ATOM   3906  CG  PRO D  31      -1.131 -18.376 -16.072  1.00 29.52           C  
ATOM   3907  CD  PRO D  31      -0.765 -17.742 -14.789  1.00 28.62           C  
ATOM   3908  N   ASP D  32       2.408 -19.507 -14.641  1.00 28.48           N  
ATOM   3909  CA  ASP D  32       3.844 -19.733 -14.660  1.00 28.39           C  
ATOM   3910  C   ASP D  32       4.446 -19.885 -13.266  1.00 27.66           C  
ATOM   3911  O   ASP D  32       5.666 -19.781 -13.103  1.00 27.44           O  
ATOM   3912  CB  ASP D  32       4.527 -18.562 -15.365  1.00 29.19           C  
ATOM   3913  CG  ASP D  32       4.063 -18.394 -16.792  1.00 31.54           C  
ATOM   3914  OD1 ASP D  32       3.908 -19.414 -17.504  1.00 35.58           O  
ATOM   3915  OD2 ASP D  32       3.857 -17.237 -17.207  1.00 36.35           O  
ATOM   3916  N   ILE D  33       3.606 -20.126 -12.261  1.00 26.79           N  
ATOM   3917  CA  ILE D  33       4.082 -20.281 -10.887  1.00 25.87           C  
ATOM   3918  C   ILE D  33       5.128 -21.386 -10.778  1.00 25.55           C  
ATOM   3919  O   ILE D  33       5.055 -22.415 -11.477  1.00 24.65           O  
ATOM   3920  CB  ILE D  33       2.913 -20.553  -9.892  1.00 25.57           C  
ATOM   3921  CG1 ILE D  33       3.398 -20.497  -8.441  1.00 25.86           C  
ATOM   3922  CG2 ILE D  33       2.245 -21.894 -10.189  1.00 26.00           C  
ATOM   3923  CD1 ILE D  33       2.294 -20.428  -7.405  1.00 25.68           C  
ATOM   3924  N   VAL D  34       6.116 -21.152  -9.918  1.00 25.09           N  
ATOM   3925  CA  VAL D  34       7.092 -22.178  -9.549  1.00 25.00           C  
ATOM   3926  C   VAL D  34       7.044 -22.367  -8.041  1.00 24.34           C  
ATOM   3927  O   VAL D  34       7.021 -21.383  -7.290  1.00 24.63           O  
ATOM   3928  CB  VAL D  34       8.522 -21.806  -9.991  1.00 24.93           C  
ATOM   3929  CG1 VAL D  34       9.498 -22.938  -9.649  1.00 25.50           C  
ATOM   3930  CG2 VAL D  34       8.550 -21.520 -11.478  1.00 26.36           C  
ATOM   3931  N   HIS D  35       6.993 -23.623  -7.596  1.00 24.15           N  
ATOM   3932  CA  HIS D  35       6.993 -23.940  -6.165  1.00 24.23           C  
ATOM   3933  C   HIS D  35       8.338 -24.527  -5.800  1.00 24.01           C  
ATOM   3934  O   HIS D  35       8.916 -25.301  -6.572  1.00 23.11           O  
ATOM   3935  CB  HIS D  35       5.927 -24.981  -5.800  1.00 24.70           C  
ATOM   3936  CG  HIS D  35       4.567 -24.672  -6.332  1.00 25.89           C  
ATOM   3937  ND1 HIS D  35       3.642 -23.944  -5.622  1.00 27.56           N  
ATOM   3938  CD2 HIS D  35       3.977 -24.993  -7.506  1.00 28.79           C  
ATOM   3939  CE1 HIS D  35       2.537 -23.830  -6.336  1.00 27.54           C  
ATOM   3940  NE2 HIS D  35       2.716 -24.452  -7.484  1.00 28.28           N  
ATOM   3941  N   TYR D  36       8.803 -24.190  -4.605  1.00 23.85           N  
ATOM   3942  CA  TYR D  36      10.043 -24.734  -4.086  1.00 24.33           C  
ATOM   3943  C   TYR D  36       9.858 -25.251  -2.669  1.00 24.32           C  
ATOM   3944  O   TYR D  36       9.243 -24.585  -1.825  1.00 25.12           O  
ATOM   3945  CB  TYR D  36      11.137 -23.679  -4.057  1.00 24.94           C  
ATOM   3946  CG  TYR D  36      11.311 -22.858  -5.310  1.00 25.03           C  
ATOM   3947  CD1 TYR D  36      10.610 -21.679  -5.481  1.00 25.49           C  
ATOM   3948  CD2 TYR D  36      12.216 -23.231  -6.297  1.00 26.68           C  
ATOM   3949  CE1 TYR D  36      10.781 -20.896  -6.618  1.00 25.81           C  
ATOM   3950  CE2 TYR D  36      12.396 -22.447  -7.447  1.00 26.41           C  
ATOM   3951  CZ  TYR D  36      11.677 -21.276  -7.587  1.00 25.92           C  
ATOM   3952  OH  TYR D  36      11.844 -20.490  -8.715  1.00 26.97           O  
ATOM   3953  N   SER D  37      10.416 -26.426  -2.404  1.00 24.50           N  
ATOM   3954  CA  SER D  37      10.456 -26.966  -1.053  1.00 24.50           C  
ATOM   3955  C   SER D  37      11.786 -27.681  -0.849  1.00 23.94           C  
ATOM   3956  O   SER D  37      12.216 -28.489  -1.687  1.00 22.84           O  
ATOM   3957  CB  SER D  37       9.281 -27.907  -0.802  1.00 25.27           C  
ATOM   3958  OG  SER D  37       9.289 -28.381   0.532  1.00 27.71           O  
ATOM   3959  N   GLU D  38      12.447 -27.359   0.263  1.00 23.73           N  
ATOM   3960  CA  GLU D  38      13.776 -27.882   0.559  1.00 23.95           C  
ATOM   3961  C   GLU D  38      14.759 -27.547  -0.572  1.00 23.86           C  
ATOM   3962  O   GLU D  38      15.667 -28.324  -0.878  1.00 23.80           O  
ATOM   3963  CB  GLU D  38      13.709 -29.388   0.851  1.00 23.77           C  
ATOM   3964  CG  GLU D  38      12.663 -29.739   1.909  1.00 23.22           C  
ATOM   3965  CD  GLU D  38      12.603 -31.209   2.266  1.00 24.80           C  
ATOM   3966  OE1 GLU D  38      13.247 -32.033   1.576  1.00 25.91           O  
ATOM   3967  OE2 GLU D  38      11.925 -31.537   3.260  1.00 26.42           O  
ATOM   3968  N   ASP D  39      14.548 -26.403  -1.200  1.00 24.35           N  
ATOM   3969  CA  ASP D  39      15.405 -25.875  -2.231  1.00 24.70           C  
ATOM   3970  C   ASP D  39      15.259 -26.603  -3.568  1.00 24.90           C  
ATOM   3971  O   ASP D  39      15.984 -26.362  -4.467  1.00 25.81           O  
ATOM   3972  CB  ASP D  39      16.874 -25.733  -1.812  1.00 25.07           C  
ATOM   3973  CG  ASP D  39      17.076 -24.786  -0.653  1.00 25.29           C  
ATOM   3974  OD1 ASP D  39      16.234 -23.937  -0.420  1.00 26.50           O  
ATOM   3975  OD2 ASP D  39      18.088 -24.919   0.009  1.00 27.47           O  
ATOM   3976  N   ASN D  40      14.270 -27.465  -3.654  1.00 20.00           N  
ATOM   3977  CA  ASN D  40      13.987 -28.186  -4.870  1.00 20.00           C  
ATOM   3978  C   ASN D  40      12.660 -27.736  -5.470  1.00 20.00           C  
ATOM   3979  O   ASN D  40      11.738 -27.539  -4.765  1.00 24.32           O  
ATOM   3980  CB  ASN D  40      13.942 -29.678  -4.592  1.00 20.00           C  
ATOM   3981  CG  ASN D  40      15.213 -30.193  -3.955  1.00 20.00           C  
ATOM   3982  OD1 ASN D  40      15.171 -30.858  -2.964  1.00 20.00           O  
ATOM   3983  ND2 ASN D  40      16.319 -29.846  -4.499  1.00 20.00           N  
ATOM   3984  N   GLU D  41      12.616 -27.597  -6.780  1.00 25.10           N  
ATOM   3985  CA  GLU D  41      11.382 -27.395  -7.527  0.50 25.59           C  
ATOM   3987  C   GLU D  41      10.377 -28.496  -7.266  1.00 25.47           C  
ATOM   3988  O   GLU D  41      10.766 -29.617  -7.240  1.00 25.65           O  
ATOM   3989  CB  GLU D  41      11.612 -27.312  -9.039  0.50 25.59           C  
ATOM   3991  CG  GLU D  41      12.501 -26.171  -9.508  0.50 26.24           C  
ATOM   3993  CD  GLU D  41      12.985 -26.372 -10.930  0.50 26.91           C  
ATOM   3995  OE1 GLU D  41      12.275 -27.035 -11.723  0.50 29.27           O  
ATOM   3997  OE2 GLU D  41      14.082 -25.877 -11.259  0.50 28.60           O  
ATOM   3999  N   VAL D  42       9.118 -28.153  -7.092  1.00 25.25           N  
ATOM   4000  CA  VAL D  42       8.016 -29.098  -6.942  1.00 25.37           C  
ATOM   4001  C   VAL D  42       6.971 -28.700  -7.975  1.00 25.26           C  
ATOM   4002  O   VAL D  42       6.586 -27.540  -8.036  1.00 25.29           O  
ATOM   4003  CB  VAL D  42       7.385 -29.025  -5.539  1.00 25.49           C  
ATOM   4004  CG1 VAL D  42       6.164 -29.957  -5.439  1.00 26.35           C  
ATOM   4005  CG2 VAL D  42       8.418 -29.363  -4.465  1.00 25.73           C  
ATOM   4006  N   SER D  43       6.517 -29.655  -8.783  1.00 25.62           N  
ATOM   4007  CA  SER D  43       5.541 -29.361  -9.836  1.00 25.73           C  
ATOM   4008  C   SER D  43       4.214 -28.916  -9.238  1.00 25.62           C  
ATOM   4009  O   SER D  43       3.855 -29.310  -8.129  1.00 24.76           O  
ATOM   4010  CB  SER D  43       5.320 -30.581 -10.732  1.00 25.89           C  
ATOM   4011  OG  SER D  43       4.609 -31.608 -10.055  1.00 25.97           O  
ATOM   4012  N   SER D  44       3.475 -28.088  -9.970  1.00 26.30           N  
ATOM   4013  CA  SER D  44       2.131 -27.707  -9.520  1.00 26.54           C  
ATOM   4014  C   SER D  44       1.259 -28.939  -9.307  1.00 26.42           C  
ATOM   4015  O   SER D  44       0.517 -29.020  -8.325  1.00 26.80           O  
ATOM   4016  CB  SER D  44       1.466 -26.746 -10.505  1.00 26.99           C  
ATOM   4017  OG  SER D  44       1.963 -25.429 -10.317  1.00 28.46           O  
ATOM   4018  N   ALA D  45       1.364 -29.905 -10.212  1.00 26.77           N  
ATOM   4019  CA  ALA D  45       0.604 -31.148 -10.090  1.00 26.82           C  
ATOM   4020  C   ALA D  45       0.889 -31.851  -8.761  1.00 26.98           C  
ATOM   4021  O   ALA D  45      -0.042 -32.256  -8.060  1.00 26.75           O  
ATOM   4022  CB  ALA D  45       0.910 -32.072 -11.250  1.00 27.14           C  
ATOM   4023  N   ASP D  46       2.171 -31.969  -8.408  1.00 26.86           N  
ATOM   4024  CA  ASP D  46       2.568 -32.614  -7.146  1.00 27.06           C  
ATOM   4025  C   ASP D  46       2.128 -31.798  -5.930  1.00 26.88           C  
ATOM   4026  O   ASP D  46       1.707 -32.357  -4.925  1.00 26.29           O  
ATOM   4027  CB  ASP D  46       4.087 -32.868  -7.102  1.00 27.07           C  
ATOM   4028  CG  ASP D  46       4.523 -34.031  -8.006  1.00 28.77           C  
ATOM   4029  OD1 ASP D  46       3.667 -34.829  -8.433  1.00 28.38           O  
ATOM   4030  OD2 ASP D  46       5.731 -34.145  -8.297  1.00 29.70           O  
ATOM   4031  N   MET D  47       2.224 -30.477  -6.026  1.00 27.42           N  
ATOM   4032  CA  MET D  47       1.781 -29.596  -4.941  1.00 27.90           C  
ATOM   4033  C   MET D  47       0.290 -29.781  -4.667  1.00 27.64           C  
ATOM   4034  O   MET D  47      -0.128 -29.900  -3.518  1.00 28.13           O  
ATOM   4035  CB  MET D  47       2.068 -28.132  -5.292  1.00 28.05           C  
ATOM   4036  CG  MET D  47       1.804 -27.141  -4.175  1.00 30.19           C  
ATOM   4037  SD  MET D  47       2.712 -27.493  -2.651  1.00 38.40           S  
ATOM   4038  CE  MET D  47       4.380 -27.504  -3.264  1.00 35.95           C  
ATOM   4039  N   VAL D  48      -0.511 -29.802  -5.723  1.00 27.81           N  
ATOM   4040  CA  VAL D  48      -1.957 -29.946  -5.565  1.00 27.98           C  
ATOM   4041  C   VAL D  48      -2.301 -31.302  -4.940  1.00 27.69           C  
ATOM   4042  O   VAL D  48      -3.181 -31.382  -4.090  1.00 27.61           O  
ATOM   4043  CB  VAL D  48      -2.701 -29.735  -6.894  1.00 28.10           C  
ATOM   4044  CG1 VAL D  48      -4.183 -30.083  -6.755  1.00 29.00           C  
ATOM   4045  CG2 VAL D  48      -2.529 -28.284  -7.371  1.00 28.52           C  
ATOM   4046  N   LYS D  49      -1.602 -32.358  -5.347  1.00 27.70           N  
ATOM   4047  CA  LYS D  49      -1.793 -33.682  -4.740  1.00 28.05           C  
ATOM   4048  C   LYS D  49      -1.512 -33.675  -3.236  1.00 27.83           C  
ATOM   4049  O   LYS D  49      -2.235 -34.306  -2.463  1.00 27.40           O  
ATOM   4050  CB  LYS D  49      -0.907 -34.734  -5.419  1.00 28.02           C  
ATOM   4051  CG  LYS D  49      -1.408 -35.177  -6.763  1.00 28.93           C  
ATOM   4052  CD  LYS D  49      -0.412 -36.106  -7.456  1.00 29.05           C  
ATOM   4053  CE  LYS D  49      -0.809 -36.367  -8.894  0.50 29.20           C  
ATOM   4054  NZ  LYS D  49       0.242 -37.121  -9.626  0.50 29.40           N  
ATOM   4055  N   LEU D  50      -0.459 -32.970  -2.832  1.00 28.07           N  
ATOM   4056  CA  LEU D  50      -0.103 -32.861  -1.418  1.00 28.73           C  
ATOM   4057  C   LEU D  50      -1.172 -32.087  -0.657  1.00 28.37           C  
ATOM   4058  O   LEU D  50      -1.530 -32.445   0.465  1.00 27.89           O  
ATOM   4059  CB  LEU D  50       1.249 -32.162  -1.241  1.00 29.08           C  
ATOM   4060  CG  LEU D  50       2.490 -32.928  -1.698  1.00 31.33           C  
ATOM   4061  CD1 LEU D  50       3.693 -31.994  -1.705  1.00 33.17           C  
ATOM   4062  CD2 LEU D  50       2.746 -34.147  -0.824  1.00 32.48           C  
ATOM   4063  N   MET D  51      -1.685 -31.027  -1.271  1.00 28.73           N  
ATOM   4064  CA  MET D  51      -2.739 -30.222  -0.647  1.00 29.20           C  
ATOM   4065  C   MET D  51      -4.012 -31.057  -0.461  1.00 29.23           C  
ATOM   4066  O   MET D  51      -4.594 -31.074   0.629  1.00 29.49           O  
ATOM   4067  CB  MET D  51      -3.022 -28.967  -1.485  1.00 29.12           C  
ATOM   4068  CG  MET D  51      -1.857 -27.966  -1.545  1.00 29.64           C  
ATOM   4069  SD  MET D  51      -2.000 -26.811  -2.931  1.00 31.26           S  
ATOM   4070  CE  MET D  51      -3.427 -25.848  -2.442  1.00 33.36           C  
ATOM   4071  N   GLU D  52      -4.416 -31.757  -1.521  1.00 29.27           N  
ATOM   4072  CA  GLU D  52      -5.577 -32.663  -1.504  1.00 29.90           C  
ATOM   4073  C   GLU D  52      -5.414 -33.774  -0.461  1.00 29.50           C  
ATOM   4074  O   GLU D  52      -6.328 -34.037   0.320  1.00 29.74           O  
ATOM   4075  CB  GLU D  52      -5.806 -33.271  -2.900  1.00 29.97           C  
ATOM   4076  CG  GLU D  52      -6.352 -32.272  -3.939  1.00 31.29           C  
ATOM   4077  CD  GLU D  52      -6.372 -32.815  -5.371  1.00 32.76           C  
ATOM   4078  OE1 GLU D  52      -5.664 -33.808  -5.674  1.00 37.22           O  
ATOM   4079  OE2 GLU D  52      -7.105 -32.241  -6.213  1.00 37.09           O  
ATOM   4080  N   GLY D  53      -4.242 -34.409  -0.442  1.00 29.41           N  
ATOM   4081  CA  GLY D  53      -3.950 -35.477   0.520  1.00 29.38           C  
ATOM   4082  C   GLY D  53      -3.956 -35.033   1.971  1.00 29.37           C  
ATOM   4083  O   GLY D  53      -4.472 -35.742   2.843  1.00 29.29           O  
ATOM   4084  N   GLY D  54      -3.378 -33.864   2.240  1.00 29.18           N  
ATOM   4085  CA  GLY D  54      -3.392 -33.279   3.580  1.00 29.43           C  
ATOM   4086  C   GLY D  54      -4.799 -32.995   4.062  1.00 29.09           C  
ATOM   4087  O   GLY D  54      -5.154 -33.290   5.204  1.00 28.83           O  
ATOM   4088  N   LEU D  55      -5.605 -32.436   3.174  1.00 29.39           N  
ATOM   4089  CA  LEU D  55      -6.997 -32.129   3.474  1.00 29.47           C  
ATOM   4090  C   LEU D  55      -7.809 -33.396   3.777  1.00 29.24           C  
ATOM   4091  O   LEU D  55      -8.690 -33.389   4.644  1.00 29.85           O  
ATOM   4092  CB  LEU D  55      -7.606 -31.355   2.302  1.00 29.75           C  
ATOM   4093  CG  LEU D  55      -8.815 -30.466   2.549  1.00 30.43           C  
ATOM   4094  CD1 LEU D  55      -8.605 -29.579   3.755  1.00 29.97           C  
ATOM   4095  CD2 LEU D  55      -9.094 -29.627   1.287  1.00 30.62           C  
ATOM   4096  N   LYS D  56      -7.508 -34.487   3.079  1.00 28.40           N  
ATOM   4097  CA  LYS D  56      -8.176 -35.762   3.338  1.00 27.84           C  
ATOM   4098  C   LYS D  56      -7.794 -36.343   4.697  1.00 27.33           C  
ATOM   4099  O   LYS D  56      -8.642 -36.882   5.408  1.00 27.46           O  
ATOM   4100  CB  LYS D  56      -7.867 -36.771   2.229  1.00 27.89           C  
ATOM   4101  CG  LYS D  56      -8.549 -36.450   0.911  0.50 27.88           C  
ATOM   4102  CD  LYS D  56      -8.168 -37.429  -0.193  0.50 28.29           C  
ATOM   4103  CE  LYS D  56      -8.577 -36.902  -1.565  0.50 28.00           C  
ATOM   4104  NZ  LYS D  56      -8.425 -37.931  -2.635  0.50 28.37           N  
ATOM   4105  N   ALA D  57      -6.518 -36.239   5.046  1.00 26.70           N  
ATOM   4106  CA  ALA D  57      -5.999 -36.785   6.301  1.00 26.32           C  
ATOM   4107  C   ALA D  57      -6.435 -35.953   7.514  1.00 25.85           C  
ATOM   4108  O   ALA D  57      -6.692 -36.502   8.591  1.00 25.62           O  
ATOM   4109  CB  ALA D  57      -4.483 -36.869   6.234  1.00 26.27           C  
ATOM   4110  N   PHE D  58      -6.543 -34.640   7.311  1.00 25.42           N  
ATOM   4111  CA  PHE D  58      -6.788 -33.662   8.377  1.00 25.64           C  
ATOM   4112  C   PHE D  58      -7.924 -32.724   7.932  1.00 25.50           C  
ATOM   4113  O   PHE D  58      -7.696 -31.542   7.670  1.00 25.59           O  
ATOM   4114  CB  PHE D  58      -5.493 -32.892   8.648  1.00 25.39           C  
ATOM   4115  CG  PHE D  58      -4.331 -33.792   8.966  1.00 25.20           C  
ATOM   4116  CD1 PHE D  58      -4.311 -34.511  10.158  1.00 25.33           C  
ATOM   4117  CD2 PHE D  58      -3.301 -33.975   8.056  1.00 25.47           C  
ATOM   4118  CE1 PHE D  58      -3.263 -35.383  10.452  1.00 25.45           C  
ATOM   4119  CE2 PHE D  58      -2.249 -34.837   8.344  1.00 25.51           C  
ATOM   4120  CZ  PHE D  58      -2.232 -35.545   9.542  1.00 25.29           C  
ATOM   4121  N   PRO D  59      -9.150 -33.266   7.834  1.00 25.60           N  
ATOM   4122  CA  PRO D  59     -10.250 -32.555   7.185  1.00 25.47           C  
ATOM   4123  C   PRO D  59     -10.733 -31.303   7.927  1.00 25.56           C  
ATOM   4124  O   PRO D  59     -11.385 -30.459   7.316  1.00 25.90           O  
ATOM   4125  CB  PRO D  59     -11.355 -33.614   7.097  1.00 25.85           C  
ATOM   4126  CG  PRO D  59     -11.041 -34.590   8.186  1.00 26.32           C  
ATOM   4127  CD  PRO D  59      -9.553 -34.600   8.313  1.00 25.73           C  
ATOM   4128  N   ASP D  60     -10.412 -31.185   9.216  1.00 24.74           N  
ATOM   4129  CA  ASP D  60     -10.818 -30.021  10.019  1.00 24.71           C  
ATOM   4130  C   ASP D  60      -9.660 -29.077  10.278  1.00 24.48           C  
ATOM   4131  O   ASP D  60      -9.736 -28.243  11.188  1.00 25.09           O  
ATOM   4132  CB  ASP D  60     -11.417 -30.476  11.359  1.00 24.66           C  
ATOM   4133  CG  ASP D  60     -10.413 -31.203  12.243  1.00 25.07           C  
ATOM   4134  OD1 ASP D  60      -9.297 -31.539  11.765  1.00 24.83           O  
ATOM   4135  OD2 ASP D  60     -10.747 -31.440  13.432  1.00 26.93           O  
ATOM   4136  N   LEU D  61      -8.594 -29.181   9.487  1.00 24.63           N  
ATOM   4137  CA  LEU D  61      -7.404 -28.393   9.756  1.00 24.66           C  
ATOM   4138  C   LEU D  61      -7.713 -26.897   9.801  1.00 24.79           C  
ATOM   4139  O   LEU D  61      -8.590 -26.406   9.077  1.00 23.93           O  
ATOM   4140  CB  LEU D  61      -6.292 -28.691   8.759  1.00 25.12           C  
ATOM   4141  CG  LEU D  61      -6.479 -28.346   7.281  1.00 25.13           C  
ATOM   4142  CD1 LEU D  61      -6.068 -26.911   6.980  1.00 26.76           C  
ATOM   4143  CD2 LEU D  61      -5.650 -29.296   6.431  1.00 25.71           C  
ATOM   4144  N   GLN D  62      -7.011 -26.193  10.681  1.00 24.49           N  
ATOM   4145  CA  GLN D  62      -7.129 -24.742  10.798  1.00 24.96           C  
ATOM   4146  C   GLN D  62      -5.742 -24.121  10.888  1.00 25.52           C  
ATOM   4147  O   GLN D  62      -4.872 -24.627  11.615  1.00 25.28           O  
ATOM   4148  CB  GLN D  62      -7.930 -24.355  12.039  1.00 25.14           C  
ATOM   4149  CG  GLN D  62      -9.366 -24.804  12.014  1.00 25.00           C  
ATOM   4150  CD  GLN D  62     -10.229 -23.928  11.138  1.00 26.37           C  
ATOM   4151  OE1 GLN D  62     -10.730 -22.895  11.591  1.00 27.03           O  
ATOM   4152  NE2 GLN D  62     -10.418 -24.334   9.878  1.00 24.37           N  
ATOM   4153  N   LEU D  63      -5.552 -23.032  10.147  1.00 25.12           N  
ATOM   4154  CA  LEU D  63      -4.294 -22.280  10.105  1.00 25.86           C  
ATOM   4155  C   LEU D  63      -4.404 -21.046  10.989  1.00 26.28           C  
ATOM   4156  O   LEU D  63      -5.356 -20.277  10.864  1.00 25.43           O  
ATOM   4157  CB  LEU D  63      -3.995 -21.813   8.680  1.00 25.95           C  
ATOM   4158  CG  LEU D  63      -3.413 -22.818   7.677  1.00 27.12           C  
ATOM   4159  CD1 LEU D  63      -4.303 -24.021   7.517  1.00 27.79           C  
ATOM   4160  CD2 LEU D  63      -3.192 -22.142   6.340  1.00 27.00           C  
ATOM   4161  N   GLU D  64      -3.450 -20.880  11.893  1.00 26.29           N  
ATOM   4162  CA  GLU D  64      -3.315 -19.659  12.670  1.00 26.81           C  
ATOM   4163  C   GLU D  64      -2.070 -18.923  12.198  1.00 26.71           C  
ATOM   4164  O   GLU D  64      -0.959 -19.457  12.279  1.00 26.09           O  
ATOM   4165  CB  GLU D  64      -3.194 -19.970  14.163  1.00 27.06           C  
ATOM   4166  CG  GLU D  64      -3.185 -18.709  15.012  1.00 27.81           C  
ATOM   4167  CD  GLU D  64      -2.876 -18.947  16.471  1.00 30.44           C  
ATOM   4168  OE1 GLU D  64      -2.794 -20.116  16.904  1.00 35.34           O  
ATOM   4169  OE2 GLU D  64      -2.701 -17.937  17.193  1.00 35.58           O  
ATOM   4170  N   VAL D  65      -2.245 -17.714  11.717  1.00 26.14           N  
ATOM   4171  CA  VAL D  65      -1.126 -16.914  11.316  1.00 26.21           C  
ATOM   4172  C   VAL D  65      -0.467 -16.294  12.537  1.00 26.02           C  
ATOM   4173  O   VAL D  65      -1.050 -15.492  13.175  1.00 25.16           O  
ATOM   4174  CB  VAL D  65      -1.511 -15.827  10.298  1.00 26.21           C  
ATOM   4175  CG1 VAL D  65      -0.308 -15.035   9.873  1.00 26.38           C  
ATOM   4176  CG2 VAL D  65      -2.193 -16.454   9.133  1.00 26.32           C  
ATOM   4177  N   LYS D  66       0.736 -16.729  12.852  1.00 20.00           N  
ATOM   4178  CA  LYS D  66       1.473 -16.182  13.959  1.00 20.00           C  
ATOM   4179  C   LYS D  66       2.179 -14.878  13.634  1.00 20.00           C  
ATOM   4180  O   LYS D  66       2.341 -14.061  14.474  1.00 26.12           O  
ATOM   4181  CB  LYS D  66       2.496 -17.160  14.534  1.00 20.00           C  
ATOM   4182  CG  LYS D  66       1.980 -18.517  14.838  1.00 20.00           C  
ATOM   4183  CD  LYS D  66       0.902 -18.538  15.854  1.00 20.00           C  
ATOM   4184  CE  LYS D  66       1.393 -18.314  17.208  1.00 20.00           C  
ATOM   4185  NZ  LYS D  66       0.351 -18.510  18.240  1.00 20.00           N  
ATOM   4186  N   SER D  67       2.629 -14.751  12.401  1.00 26.46           N  
ATOM   4187  CA  SER D  67       3.193 -13.525  11.934  1.00 26.77           C  
ATOM   4188  C   SER D  67       3.101 -13.394  10.433  1.00 26.40           C  
ATOM   4189  O   SER D  67       3.045 -14.350   9.753  1.00 25.86           O  
ATOM   4190  CB  SER D  67       4.623 -13.373  12.389  1.00 27.30           C  
ATOM   4191  OG  SER D  67       5.498 -14.133  11.641  1.00 29.67           O  
ATOM   4192  N   ILE D  68       3.069 -12.165   9.981  1.00 26.68           N  
ATOM   4193  CA  ILE D  68       3.043 -11.891   8.558  1.00 26.79           C  
ATOM   4194  C   ILE D  68       3.971 -10.711   8.311  1.00 27.49           C  
ATOM   4195  O   ILE D  68       4.033  -9.766   9.115  1.00 27.68           O  
ATOM   4196  CB  ILE D  68       1.594 -11.682   8.023  1.00 26.96           C  
ATOM   4197  CG1 ILE D  68       1.592 -11.498   6.499  1.00 26.59           C  
ATOM   4198  CG2 ILE D  68       0.880 -10.537   8.755  1.00 28.13           C  
ATOM   4199  CD1 ILE D  68       0.230 -11.678   5.881  1.00 28.00           C  
ATOM   4200  N   MET D  69       4.752 -10.810   7.246  1.00 26.89           N  
ATOM   4201  CA  MET D  69       5.730  -9.789   6.914  1.00 27.43           C  
ATOM   4202  C   MET D  69       5.714  -9.609   5.410  1.00 26.69           C  
ATOM   4203  O   MET D  69       5.513 -10.585   4.677  1.00 25.68           O  
ATOM   4204  CB  MET D  69       7.120 -10.251   7.373  1.00 27.70           C  
ATOM   4205  CG  MET D  69       8.231  -9.272   7.114  1.00 29.26           C  
ATOM   4206  SD  MET D  69       9.837  -9.926   7.622  1.00 34.21           S  
ATOM   4207  CE  MET D  69       9.548 -10.140   9.356  1.00 32.20           C  
ATOM   4208  N   ALA D  70       5.910  -8.375   4.959  1.00 25.71           N  
ATOM   4209  CA  ALA D  70       6.009  -8.080   3.535  1.00 25.95           C  
ATOM   4210  C   ALA D  70       7.134  -7.094   3.246  1.00 26.21           C  
ATOM   4211  O   ALA D  70       7.376  -6.175   4.037  1.00 25.85           O  
ATOM   4212  CB  ALA D  70       4.698  -7.538   3.023  1.00 26.01           C  
ATOM   4213  N   GLU D  71       7.817  -7.315   2.126  1.00 26.45           N  
ATOM   4214  CA  GLU D  71       8.859  -6.419   1.618  1.00 26.52           C  
ATOM   4215  C   GLU D  71       8.955  -6.606   0.115  1.00 26.15           C  
ATOM   4216  O   GLU D  71       8.839  -7.732  -0.390  1.00 25.13           O  
ATOM   4217  CB  GLU D  71      10.220  -6.675   2.281  1.00 26.71           C  
ATOM   4218  CG  GLU D  71      11.263  -5.607   1.959  1.00 27.69           C  
ATOM   4219  CD  GLU D  71      12.588  -5.805   2.690  1.00 28.81           C  
ATOM   4220  OE1 GLU D  71      12.815  -6.896   3.213  1.00 29.40           O  
ATOM   4221  OE2 GLU D  71      13.393  -4.849   2.760  1.00 34.62           O  
ATOM   4222  N   GLU D  72       9.166  -5.501  -0.595  1.00 26.04           N  
ATOM   4223  CA  GLU D  72       9.098  -5.448  -2.055  0.50 26.44           C  
ATOM   4225  C   GLU D  72       7.912  -6.274  -2.561  1.00 26.29           C  
ATOM   4226  O   GLU D  72       6.784  -5.952  -2.172  1.00 26.32           O  
ATOM   4227  CB  GLU D  72      10.448  -5.791  -2.687  0.50 26.81           C  
ATOM   4229  CG  GLU D  72      11.521  -4.721  -2.403  0.50 28.19           C  
ATOM   4231  CD  GLU D  72      11.123  -3.323  -2.888  0.50 30.62           C  
ATOM   4233  OE1 GLU D  72      11.349  -2.335  -2.147  0.50 31.94           O  
ATOM   4235  OE2 GLU D  72      10.581  -3.211  -4.013  0.50 32.80           O  
ATOM   4237  N   ASP D  73       8.114  -7.293  -3.398  1.00 25.89           N  
ATOM   4238  CA  ASP D  73       7.007  -8.058  -3.993  1.00 26.06           C  
ATOM   4239  C   ASP D  73       6.717  -9.374  -3.269  1.00 25.75           C  
ATOM   4240  O   ASP D  73       5.992 -10.223  -3.795  1.00 25.76           O  
ATOM   4241  CB  ASP D  73       7.282  -8.317  -5.488  1.00 26.60           C  
ATOM   4242  CG  ASP D  73       8.661  -8.936  -5.762  1.00 27.47           C  
ATOM   4243  OD1 ASP D  73       9.446  -9.161  -4.814  1.00 27.84           O  
ATOM   4244  OD2 ASP D  73       8.969  -9.191  -6.955  1.00 29.68           O  
ATOM   4245  N   ARG D  74       7.261  -9.526  -2.058  1.00 25.27           N  
ATOM   4246  CA  ARG D  74       7.136 -10.773  -1.310  0.50 25.27           C  
ATOM   4248  C   ARG D  74       6.342 -10.610  -0.018  1.00 25.17           C  
ATOM   4249  O   ARG D  74       6.280  -9.520   0.561  1.00 25.01           O  
ATOM   4250  CB  ARG D  74       8.518 -11.346  -1.001  0.50 25.14           C  
ATOM   4252  CG  ARG D  74       9.245 -11.882  -2.229  0.50 25.57           C  
ATOM   4254  CD  ARG D  74      10.670 -12.305  -1.911  0.50 26.21           C  
ATOM   4256  NE  ARG D  74      11.496 -11.175  -1.497  0.50 26.36           N  
ATOM   4258  CZ  ARG D  74      12.198 -11.089  -0.365  0.50 27.15           C  
ATOM   4260  NH1 ARG D  74      12.223 -12.070   0.533  0.50 27.41           N  
ATOM   4262  NH2 ARG D  74      12.900  -9.993  -0.132  0.50 27.75           N  
ATOM   4264  N   VAL D  75       5.750 -11.720   0.424  1.00 24.86           N  
ATOM   4265  CA  VAL D  75       5.056 -11.806   1.699  1.00 25.02           C  
ATOM   4266  C   VAL D  75       5.455 -13.139   2.312  1.00 25.11           C  
ATOM   4267  O   VAL D  75       5.545 -14.146   1.593  1.00 25.22           O  
ATOM   4268  CB  VAL D  75       3.534 -11.775   1.529  1.00 24.96           C  
ATOM   4269  CG1 VAL D  75       2.839 -11.843   2.885  1.00 25.25           C  
ATOM   4270  CG2 VAL D  75       3.107 -10.527   0.754  1.00 25.91           C  
ATOM   4271  N   ALA D  76       5.713 -13.140   3.613  1.00 25.08           N  
ATOM   4272  CA  ALA D  76       5.992 -14.371   4.351  1.00 24.99           C  
ATOM   4273  C   ALA D  76       5.047 -14.493   5.533  1.00 25.27           C  
ATOM   4274  O   ALA D  76       4.788 -13.508   6.238  1.00 25.18           O  
ATOM   4275  CB  ALA D  76       7.433 -14.395   4.833  1.00 25.07           C  
ATOM   4276  N   LEU D  77       4.552 -15.705   5.751  1.00 25.59           N  
ATOM   4277  CA  LEU D  77       3.637 -16.000   6.845  1.00 25.69           C  
ATOM   4278  C   LEU D  77       4.166 -17.163   7.660  1.00 25.59           C  
ATOM   4279  O   LEU D  77       4.481 -18.222   7.107  1.00 26.00           O  
ATOM   4280  CB  LEU D  77       2.254 -16.381   6.316  1.00 26.13           C  
ATOM   4281  CG  LEU D  77       1.553 -15.381   5.391  1.00 27.21           C  
ATOM   4282  CD1 LEU D  77       1.911 -15.617   3.931  1.00 29.39           C  
ATOM   4283  CD2 LEU D  77       0.065 -15.482   5.584  1.00 26.99           C  
ATOM   4284  N   ARG D  78       4.255 -16.959   8.966  1.00 25.26           N  
ATOM   4285  CA  ARG D  78       4.541 -18.033   9.914  1.00 25.28           C  
ATOM   4286  C   ARG D  78       3.213 -18.508  10.485  1.00 25.20           C  
ATOM   4287  O   ARG D  78       2.474 -17.727  11.091  1.00 24.91           O  
ATOM   4288  CB  ARG D  78       5.461 -17.557  11.030  1.00 25.13           C  
ATOM   4289  CG  ARG D  78       5.770 -18.630  12.068  1.00 24.89           C  
ATOM   4290  CD  ARG D  78       6.982 -18.278  12.939  1.00 26.04           C  
ATOM   4291  NE  ARG D  78       6.859 -16.961  13.583  1.00 26.18           N  
ATOM   4292  CZ  ARG D  78       6.221 -16.714  14.723  1.00 26.94           C  
ATOM   4293  NH1 ARG D  78       5.624 -17.675  15.412  1.00 26.00           N  
ATOM   4294  NH2 ARG D  78       6.190 -15.473  15.188  1.00 29.00           N  
ATOM   4295  N   ILE D  79       2.936 -19.798  10.290  1.00 25.65           N  
ATOM   4296  CA  ILE D  79       1.626 -20.378  10.517  1.00 25.86           C  
ATOM   4297  C   ILE D  79       1.720 -21.628  11.390  1.00 25.94           C  
ATOM   4298  O   ILE D  79       2.640 -22.440  11.235  1.00 25.54           O  
ATOM   4299  CB  ILE D  79       1.011 -20.730   9.151  1.00 25.91           C  
ATOM   4300  CG1 ILE D  79       0.670 -19.440   8.396  1.00 26.22           C  
ATOM   4301  CG2 ILE D  79      -0.216 -21.653   9.275  1.00 26.65           C  
ATOM   4302  CD1 ILE D  79       0.433 -19.647   6.919  1.00 26.61           C  
ATOM   4303  N   THR D  80       0.768 -21.774  12.306  1.00 25.58           N  
ATOM   4304  CA  THR D  80       0.609 -23.011  13.059  1.00 25.59           C  
ATOM   4305  C   THR D  80      -0.677 -23.675  12.583  1.00 25.45           C  
ATOM   4306  O   THR D  80      -1.735 -23.026  12.520  1.00 25.40           O  
ATOM   4307  CB  THR D  80       0.561 -22.732  14.565  1.00 25.46           C  
ATOM   4308  OG1 THR D  80       1.808 -22.151  14.970  1.00 27.65           O  
ATOM   4309  CG2 THR D  80       0.306 -24.009  15.370  1.00 26.02           C  
ATOM   4310  N   VAL D  81      -0.575 -24.951  12.219  1.00 24.70           N  
ATOM   4311  CA  VAL D  81      -1.729 -25.734  11.813  1.00 24.98           C  
ATOM   4312  C   VAL D  81      -2.153 -26.651  12.960  1.00 24.64           C  
ATOM   4313  O   VAL D  81      -1.310 -27.277  13.607  1.00 24.26           O  
ATOM   4314  CB  VAL D  81      -1.432 -26.596  10.566  1.00 25.27           C  
ATOM   4315  CG1 VAL D  81      -2.705 -27.324  10.119  1.00 26.08           C  
ATOM   4316  CG2 VAL D  81      -0.870 -25.726   9.411  1.00 26.38           C  
ATOM   4317  N   THR D  82      -3.455 -26.700  13.224  1.00 24.44           N  
ATOM   4318  CA  THR D  82      -4.018 -27.654  14.166  1.00 24.61           C  
ATOM   4319  C   THR D  82      -5.150 -28.408  13.481  1.00 24.32           C  
ATOM   4320  O   THR D  82      -5.858 -27.858  12.629  1.00 23.48           O  
ATOM   4321  CB  THR D  82      -4.500 -26.977  15.463  1.00 24.98           C  
ATOM   4322  OG1 THR D  82      -5.462 -25.958  15.161  1.00 26.96           O  
ATOM   4323  CG2 THR D  82      -3.322 -26.357  16.200  1.00 25.57           C  
ATOM   4324  N   ALA D  83      -5.287 -29.681  13.831  1.00 24.08           N  
ATOM   4325  CA  ALA D  83      -6.249 -30.553  13.177  1.00 24.30           C  
ATOM   4326  C   ALA D  83      -6.466 -31.829  13.969  1.00 24.28           C  
ATOM   4327  O   ALA D  83      -5.779 -32.085  14.957  1.00 23.98           O  
ATOM   4328  CB  ALA D  83      -5.769 -30.901  11.788  1.00 24.31           C  
ATOM   4329  N   THR D  84      -7.419 -32.630  13.501  1.00 24.61           N  
ATOM   4330  CA  THR D  84      -7.641 -33.968  14.015  1.00 24.66           C  
ATOM   4331  C   THR D  84      -7.221 -34.958  12.922  1.00 24.76           C  
ATOM   4332  O   THR D  84      -7.531 -34.763  11.749  1.00 23.85           O  
ATOM   4333  CB  THR D  84      -9.123 -34.194  14.355  1.00 24.95           C  
ATOM   4334  OG1 THR D  84      -9.588 -33.126  15.188  1.00 25.84           O  
ATOM   4335  CG2 THR D  84      -9.322 -35.520  15.074  1.00 24.96           C  
ATOM   4336  N   HIS D  85      -6.508 -36.007  13.321  1.00 24.88           N  
ATOM   4337  CA  HIS D  85      -6.101 -37.069  12.400  1.00 25.36           C  
ATOM   4338  C   HIS D  85      -7.282 -38.006  12.123  1.00 25.59           C  
ATOM   4339  O   HIS D  85      -7.567 -38.912  12.910  1.00 25.13           O  
ATOM   4340  CB  HIS D  85      -4.902 -37.829  12.983  1.00 25.30           C  
ATOM   4341  CG  HIS D  85      -4.332 -38.857  12.059  1.00 25.23           C  
ATOM   4342  ND1 HIS D  85      -3.711 -40.000  12.511  1.00 25.63           N  
ATOM   4343  CD2 HIS D  85      -4.297 -38.919  10.707  1.00 25.42           C  
ATOM   4344  CE1 HIS D  85      -3.310 -40.718  11.477  1.00 25.77           C  
ATOM   4345  NE2 HIS D  85      -3.653 -40.085  10.371  1.00 25.74           N  
ATOM   4346  N   GLN D  86      -7.973 -37.767  11.007  1.00 26.08           N  
ATOM   4347  CA  GLN D  86      -9.173 -38.522  10.641  1.00 27.21           C  
ATOM   4348  C   GLN D  86      -9.030 -39.373   9.382  1.00 27.44           C  
ATOM   4349  O   GLN D  86      -9.876 -40.235   9.133  1.00 27.13           O  
ATOM   4350  CB  GLN D  86     -10.365 -37.576  10.485  1.00 27.27           C  
ATOM   4351  CG  GLN D  86     -10.620 -36.748  11.739  1.00 28.63           C  
ATOM   4352  CD  GLN D  86     -12.028 -36.186  11.841  1.00 29.74           C  
ATOM   4353  OE1 GLN D  86     -12.837 -36.299  10.915  1.00 33.48           O  
ATOM   4354  NE2 GLN D  86     -12.325 -35.567  12.980  1.00 32.05           N  
ATOM   4355  N   GLY D  87      -7.979 -39.151   8.598  1.00 27.81           N  
ATOM   4356  CA  GLY D  87      -7.690 -40.006   7.443  1.00 28.60           C  
ATOM   4357  C   GLY D  87      -6.269 -40.540   7.476  1.00 29.01           C  
ATOM   4358  O   GLY D  87      -5.391 -39.948   8.114  1.00 28.75           O  
ATOM   4359  N   GLU D  88      -6.046 -41.661   6.788  1.00 29.55           N  
ATOM   4360  CA  GLU D  88      -4.720 -42.257   6.720  0.50 29.81           C  
ATOM   4362  C   GLU D  88      -3.700 -41.210   6.277  1.00 29.91           C  
ATOM   4363  O   GLU D  88      -3.955 -40.432   5.365  1.00 30.23           O  
ATOM   4364  CB  GLU D  88      -4.715 -43.451   5.758  0.50 29.82           C  
ATOM   4366  CG  GLU D  88      -3.438 -44.285   5.796  0.50 30.03           C  
ATOM   4368  CD  GLU D  88      -3.503 -45.512   4.897  0.50 30.46           C  
ATOM   4370  OE1 GLU D  88      -4.582 -46.135   4.801  0.50 32.02           O  
ATOM   4372  OE2 GLU D  88      -2.471 -45.860   4.287  0.50 32.17           O  
ATOM   4374  N   PHE D  89      -2.551 -41.191   6.944  1.00 30.20           N  
ATOM   4375  CA  PHE D  89      -1.467 -40.275   6.581  1.00 30.58           C  
ATOM   4376  C   PHE D  89      -0.125 -40.927   6.843  1.00 30.91           C  
ATOM   4377  O   PHE D  89       0.127 -41.411   7.945  1.00 30.74           O  
ATOM   4378  CB  PHE D  89      -1.562 -38.970   7.363  1.00 30.53           C  
ATOM   4379  CG  PHE D  89      -0.709 -37.869   6.801  1.00 30.39           C  
ATOM   4380  CD1 PHE D  89      -1.038 -37.269   5.591  1.00 30.59           C  
ATOM   4381  CD2 PHE D  89       0.419 -37.427   7.480  1.00 30.65           C  
ATOM   4382  CE1 PHE D  89      -0.264 -36.241   5.070  1.00 30.81           C  
ATOM   4383  CE2 PHE D  89       1.202 -36.400   6.963  1.00 30.36           C  
ATOM   4384  CZ  PHE D  89       0.862 -35.813   5.755  1.00 30.56           C  
ATOM   4385  N   MET D  90       0.728 -40.928   5.821  1.00 31.71           N  
ATOM   4386  CA  MET D  90       2.034 -41.593   5.871  1.00 32.43           C  
ATOM   4387  C   MET D  90       1.933 -43.043   6.330  1.00 32.17           C  
ATOM   4388  O   MET D  90       2.764 -43.526   7.104  1.00 32.42           O  
ATOM   4389  CB  MET D  90       2.991 -40.806   6.763  1.00 32.66           C  
ATOM   4390  CG  MET D  90       3.310 -39.447   6.214  1.00 33.67           C  
ATOM   4391  SD  MET D  90       4.360 -38.514   7.328  1.00 36.29           S  
ATOM   4392  CE  MET D  90       5.813 -39.565   7.362  1.00 36.38           C  
ATOM   4393  N   GLY D  91       0.902 -43.732   5.847  1.00 31.98           N  
ATOM   4394  CA  GLY D  91       0.680 -45.135   6.170  1.00 31.58           C  
ATOM   4395  C   GLY D  91       0.130 -45.402   7.561  1.00 31.39           C  
ATOM   4396  O   GLY D  91      -0.049 -46.559   7.939  1.00 31.23           O  
ATOM   4397  N   VAL D  92      -0.143 -44.343   8.326  1.00 30.99           N  
ATOM   4398  CA  VAL D  92      -0.662 -44.478   9.685  1.00 30.88           C  
ATOM   4399  C   VAL D  92      -2.170 -44.292   9.666  1.00 30.74           C  
ATOM   4400  O   VAL D  92      -2.660 -43.253   9.235  1.00 30.68           O  
ATOM   4401  CB  VAL D  92      -0.038 -43.436  10.638  1.00 30.68           C  
ATOM   4402  CG1 VAL D  92      -0.531 -43.644  12.063  1.00 30.78           C  
ATOM   4403  CG2 VAL D  92       1.480 -43.509  10.575  1.00 30.80           C  
ATOM   4404  N   GLN D  93      -2.898 -45.298  10.144  1.00 30.76           N  
ATOM   4405  CA  GLN D  93      -4.355 -45.241  10.191  1.00 30.79           C  
ATOM   4406  C   GLN D  93      -4.815 -44.145  11.147  1.00 30.40           C  
ATOM   4407  O   GLN D  93      -4.135 -43.851  12.126  1.00 29.89           O  
ATOM   4408  CB  GLN D  93      -4.945 -46.590  10.611  1.00 31.10           C  
ATOM   4409  CG  GLN D  93      -4.715 -47.716   9.603  1.00 32.48           C  
ATOM   4410  CD  GLN D  93      -5.313 -47.415   8.237  1.00 34.26           C  
ATOM   4411  OE1 GLN D  93      -6.465 -46.989   8.127  1.00 35.30           O  
ATOM   4412  NE2 GLN D  93      -4.527 -47.629   7.188  1.00 36.12           N  
ATOM   4413  N   PRO D  94      -5.970 -43.525  10.856  1.00 30.40           N  
ATOM   4414  CA  PRO D  94      -6.406 -42.401  11.685  1.00 30.53           C  
ATOM   4415  C   PRO D  94      -6.626 -42.795  13.141  1.00 30.31           C  
ATOM   4416  O   PRO D  94      -7.158 -43.863  13.426  1.00 30.27           O  
ATOM   4417  CB  PRO D  94      -7.703 -41.938  11.017  1.00 30.49           C  
ATOM   4418  CG  PRO D  94      -8.132 -43.043  10.144  1.00 30.68           C  
ATOM   4419  CD  PRO D  94      -6.909 -43.805   9.757  1.00 30.44           C  
ATOM   4420  N   THR D  95      -6.171 -41.934  14.042  1.00 30.35           N  
ATOM   4421  CA  THR D  95      -6.246 -42.164  15.479  1.00 30.67           C  
ATOM   4422  C   THR D  95      -7.336 -41.321  16.125  1.00 30.58           C  
ATOM   4423  O   THR D  95      -7.770 -41.608  17.240  1.00 30.89           O  
ATOM   4424  CB  THR D  95      -4.909 -41.794  16.147  1.00 31.01           C  
ATOM   4425  OG1 THR D  95      -4.588 -40.436  15.846  1.00 32.24           O  
ATOM   4426  CG2 THR D  95      -3.791 -42.665  15.629  1.00 31.58           C  
ATOM   4427  N   GLY D  96      -7.768 -40.272  15.427  1.00 30.28           N  
ATOM   4428  CA  GLY D  96      -8.665 -39.281  15.995  1.00 29.95           C  
ATOM   4429  C   GLY D  96      -7.956 -38.331  16.945  1.00 29.76           C  
ATOM   4430  O   GLY D  96      -8.615 -37.545  17.630  1.00 30.43           O  
ATOM   4431  N   GLN D  97      -6.623 -38.396  16.990  1.00 29.05           N  
ATOM   4432  CA  GLN D  97      -5.821 -37.525  17.853  1.00 28.98           C  
ATOM   4433  C   GLN D  97      -5.793 -36.112  17.304  1.00 27.74           C  
ATOM   4434  O   GLN D  97      -5.790 -35.924  16.093  1.00 26.89           O  
ATOM   4435  CB  GLN D  97      -4.356 -37.970  17.875  1.00 29.27           C  
ATOM   4436  CG  GLN D  97      -3.983 -39.107  18.771  1.00 31.10           C  
ATOM   4437  CD  GLN D  97      -2.475 -39.352  18.731  1.00 31.56           C  
ATOM   4438  OE1 GLN D  97      -1.808 -39.360  19.765  1.00 35.86           O  
ATOM   4439  NE2 GLN D  97      -1.930 -39.521  17.522  1.00 34.17           N  
ATOM   4440  N   ARG D  98      -5.726 -35.129  18.197  1.00 26.87           N  
ATOM   4441  CA  ARG D  98      -5.383 -33.770  17.791  1.00 26.81           C  
ATOM   4442  C   ARG D  98      -3.902 -33.727  17.422  1.00 26.39           C  
ATOM   4443  O   ARG D  98      -3.075 -34.336  18.093  1.00 26.03           O  
ATOM   4444  CB  ARG D  98      -5.677 -32.765  18.910  1.00 26.87           C  
ATOM   4445  CG  ARG D  98      -7.146 -32.621  19.250  1.00 27.25           C  
ATOM   4446  CD  ARG D  98      -7.930 -31.990  18.100  1.00 28.59           C  
ATOM   4447  NE  ARG D  98      -7.627 -30.570  17.952  1.00 28.85           N  
ATOM   4448  CZ  ARG D  98      -7.983 -29.813  16.914  1.00 29.39           C  
ATOM   4449  NH1 ARG D  98      -8.652 -30.323  15.888  1.00 29.49           N  
ATOM   4450  NH2 ARG D  98      -7.665 -28.530  16.906  1.00 29.54           N  
ATOM   4451  N   VAL D  99      -3.572 -33.008  16.353  1.00 25.71           N  
ATOM   4452  CA  VAL D  99      -2.193 -32.864  15.920  1.00 25.71           C  
ATOM   4453  C   VAL D  99      -1.924 -31.403  15.607  1.00 25.60           C  
ATOM   4454  O   VAL D  99      -2.849 -30.588  15.505  1.00 24.61           O  
ATOM   4455  CB  VAL D  99      -1.875 -33.721  14.671  1.00 25.64           C  
ATOM   4456  CG1 VAL D  99      -2.099 -35.207  14.961  1.00 26.38           C  
ATOM   4457  CG2 VAL D  99      -2.699 -33.270  13.459  1.00 26.67           C  
ATOM   4458  N   SER D 100      -0.647 -31.078  15.462  1.00 25.55           N  
ATOM   4459  CA  SER D 100      -0.253 -29.742  15.086  1.00 25.48           C  
ATOM   4460  C   SER D 100       1.049 -29.789  14.313  1.00 25.52           C  
ATOM   4461  O   SER D 100       1.838 -30.736  14.440  1.00 25.42           O  
ATOM   4462  CB  SER D 100      -0.085 -28.864  16.324  1.00 25.89           C  
ATOM   4463  OG  SER D 100       0.985 -29.334  17.136  1.00 26.43           O  
ATOM   4464  N   TRP D 101       1.269 -28.767  13.507  1.00 25.22           N  
ATOM   4465  CA  TRP D 101       2.577 -28.555  12.913  1.00 25.15           C  
ATOM   4466  C   TRP D 101       2.772 -27.078  12.582  1.00 24.94           C  
ATOM   4467  O   TRP D 101       1.880 -26.257  12.807  1.00 23.93           O  
ATOM   4468  CB  TRP D 101       2.808 -29.481  11.709  1.00 25.91           C  
ATOM   4469  CG  TRP D 101       1.977 -29.255  10.500  1.00 26.42           C  
ATOM   4470  CD1 TRP D 101       2.291 -28.486   9.423  1.00 27.74           C  
ATOM   4471  CD2 TRP D 101       0.703 -29.844  10.214  1.00 27.41           C  
ATOM   4472  NE1 TRP D 101       1.295 -28.548   8.487  1.00 27.81           N  
ATOM   4473  CE2 TRP D 101       0.307 -29.379   8.944  1.00 27.80           C  
ATOM   4474  CE3 TRP D 101      -0.137 -30.727  10.908  1.00 27.71           C  
ATOM   4475  CZ2 TRP D 101      -0.905 -29.763   8.345  1.00 28.25           C  
ATOM   4476  CZ3 TRP D 101      -1.345 -31.102  10.320  1.00 27.97           C  
ATOM   4477  CH2 TRP D 101      -1.712 -30.621   9.044  1.00 27.72           C  
ATOM   4478  N   HIS D 102       3.952 -26.740  12.081  1.00 24.36           N  
ATOM   4479  CA  HIS D 102       4.334 -25.341  11.948  1.00 24.72           C  
ATOM   4480  C   HIS D 102       5.016 -25.159  10.620  1.00 25.05           C  
ATOM   4481  O   HIS D 102       5.725 -26.051  10.151  1.00 25.17           O  
ATOM   4482  CB  HIS D 102       5.282 -24.943  13.083  1.00 24.83           C  
ATOM   4483  CG  HIS D 102       4.771 -25.287  14.445  1.00 24.34           C  
ATOM   4484  ND1 HIS D 102       3.958 -24.443  15.169  1.00 24.42           N  
ATOM   4485  CD2 HIS D 102       4.954 -26.388  15.216  1.00 25.67           C  
ATOM   4486  CE1 HIS D 102       3.655 -25.012  16.323  1.00 26.36           C  
ATOM   4487  NE2 HIS D 102       4.249 -26.191  16.378  1.00 26.16           N  
ATOM   4488  N   LEU D 103       4.808 -24.009  10.001  1.00 24.80           N  
ATOM   4489  CA  LEU D 103       5.441 -23.738   8.719  0.50 25.04           C  
ATOM   4491  C   LEU D 103       5.586 -22.253   8.456  1.00 25.09           C  
ATOM   4492  O   LEU D 103       4.940 -21.433   9.099  1.00 24.17           O  
ATOM   4493  CB  LEU D 103       4.657 -24.393   7.580  0.50 25.46           C  
ATOM   4495  CG  LEU D 103       3.261 -23.868   7.210  0.50 26.17           C  
ATOM   4497  CD1 LEU D 103       3.081 -23.887   5.705  0.50 27.20           C  
ATOM   4499  CD2 LEU D 103       2.141 -24.686   7.863  0.50 27.28           C  
ATOM   4501  N   VAL D 104       6.454 -21.932   7.507  1.00 24.82           N  
ATOM   4502  CA  VAL D 104       6.543 -20.603   6.944  1.00 25.96           C  
ATOM   4503  C   VAL D 104       6.330 -20.738   5.434  1.00 26.05           C  
ATOM   4504  O   VAL D 104       6.979 -21.567   4.778  1.00 26.15           O  
ATOM   4505  CB  VAL D 104       7.888 -19.933   7.225  1.00 25.78           C  
ATOM   4506  CG1 VAL D 104       7.975 -18.575   6.504  1.00 27.30           C  
ATOM   4507  CG2 VAL D 104       8.098 -19.775   8.718  1.00 26.29           C  
ATOM   4508  N   GLU D 105       5.382 -19.965   4.913  1.00 26.56           N  
ATOM   4509  CA  GLU D 105       5.144 -19.847   3.476  1.00 27.50           C  
ATOM   4510  C   GLU D 105       5.648 -18.483   3.032  1.00 27.34           C  
ATOM   4511  O   GLU D 105       5.358 -17.474   3.689  1.00 27.26           O  
ATOM   4512  CB  GLU D 105       3.652 -19.934   3.176  1.00 28.98           C  
ATOM   4513  CG  GLU D 105       3.043 -21.246   3.580  1.00 34.28           C  
ATOM   4514  CD  GLU D 105       2.672 -22.123   2.418  1.00 40.45           C  
ATOM   4515  OE1 GLU D 105       1.674 -21.816   1.717  1.00 44.02           O  
ATOM   4516  OE2 GLU D 105       3.367 -23.142   2.221  1.00 46.06           O  
ATOM   4517  N   GLU D 106       6.396 -18.455   1.931  1.00 26.79           N  
ATOM   4518  CA  GLU D 106       6.850 -17.218   1.317  1.00 26.67           C  
ATOM   4519  C   GLU D 106       6.330 -17.170  -0.118  1.00 26.33           C  
ATOM   4520  O   GLU D 106       6.436 -18.154  -0.852  1.00 25.78           O  
ATOM   4521  CB  GLU D 106       8.375 -17.139   1.357  1.00 26.54           C  
ATOM   4522  CG  GLU D 106       8.933 -15.805   0.901  1.00 27.07           C  
ATOM   4523  CD  GLU D 106      10.454 -15.747   0.897  1.00 29.10           C  
ATOM   4524  OE1 GLU D 106      11.130 -16.636   1.473  1.00 30.53           O  
ATOM   4525  OE2 GLU D 106      10.970 -14.765   0.341  1.00 32.73           O  
ATOM   4526  N   LEU D 107       5.768 -16.026  -0.499  1.00 25.99           N  
ATOM   4527  CA  LEU D 107       5.138 -15.854  -1.807  0.50 26.06           C  
ATOM   4529  C   LEU D 107       5.677 -14.599  -2.475  1.00 26.04           C  
ATOM   4530  O   LEU D 107       5.870 -13.592  -1.807  1.00 25.88           O  
ATOM   4531  CB  LEU D 107       3.621 -15.734  -1.656  0.50 26.25           C  
ATOM   4533  CG  LEU D 107       2.878 -16.875  -0.940  0.50 26.90           C  
ATOM   4535  CD1 LEU D 107       1.397 -16.560  -0.860  0.50 28.03           C  
ATOM   4537  CD2 LEU D 107       3.096 -18.209  -1.639  0.50 27.60           C  
ATOM   4539  N   ARG D 108       5.921 -14.676  -3.787  1.00 25.31           N  
ATOM   4540  CA  ARG D 108       6.317 -13.521  -4.590  1.00 25.28           C  
ATOM   4541  C   ARG D 108       5.223 -13.284  -5.619  1.00 24.90           C  
ATOM   4542  O   ARG D 108       4.745 -14.234  -6.256  1.00 24.73           O  
ATOM   4543  CB  ARG D 108       7.672 -13.722  -5.274  1.00 25.16           C  
ATOM   4544  CG  ARG D 108       8.147 -12.460  -6.014  1.00 25.41           C  
ATOM   4545  CD  ARG D 108       9.571 -12.565  -6.514  1.00 26.54           C  
ATOM   4546  NE  ARG D 108       9.668 -13.366  -7.718  1.00 28.17           N  
ATOM   4547  CZ  ARG D 108       9.490 -12.911  -8.957  1.00 29.77           C  
ATOM   4548  NH1 ARG D 108       9.123 -11.655  -9.190  1.00 31.04           N  
ATOM   4549  NH2 ARG D 108       9.630 -13.745  -9.980  1.00 29.96           N  
ATOM   4550  N   PHE D 109       4.822 -12.024  -5.760  1.00 24.82           N  
ATOM   4551  CA  PHE D 109       3.730 -11.620  -6.640  1.00 25.22           C  
ATOM   4552  C   PHE D 109       4.214 -10.875  -7.874  1.00 25.55           C  
ATOM   4553  O   PHE D 109       5.147 -10.060  -7.799  1.00 25.30           O  
ATOM   4554  CB  PHE D 109       2.760 -10.696  -5.901  1.00 25.62           C  
ATOM   4555  CG  PHE D 109       1.927 -11.391  -4.880  1.00 25.73           C  
ATOM   4556  CD1 PHE D 109       2.447 -11.678  -3.627  1.00 25.85           C  
ATOM   4557  CD2 PHE D 109       0.627 -11.781  -5.181  1.00 26.24           C  
ATOM   4558  CE1 PHE D 109       1.678 -12.341  -2.675  1.00 26.73           C  
ATOM   4559  CE2 PHE D 109      -0.149 -12.439  -4.232  1.00 27.01           C  
ATOM   4560  CZ  PHE D 109       0.380 -12.720  -2.982  1.00 27.00           C  
ATOM   4561  N   VAL D 110       3.546 -11.143  -8.995  1.00 25.09           N  
ATOM   4562  CA  VAL D 110       3.616 -10.296 -10.188  1.00 26.24           C  
ATOM   4563  C   VAL D 110       2.194 -10.094 -10.700  1.00 26.64           C  
ATOM   4564  O   VAL D 110       1.458 -11.069 -10.887  1.00 26.72           O  
ATOM   4565  CB  VAL D 110       4.453 -10.935 -11.305  1.00 26.07           C  
ATOM   4566  CG1 VAL D 110       4.404 -10.077 -12.584  1.00 26.94           C  
ATOM   4567  CG2 VAL D 110       5.880 -11.155 -10.845  1.00 26.86           C  
ATOM   4568  N   ASP D 111       1.806  -8.837 -10.906  1.00 27.34           N  
ATOM   4569  CA  ASP D 111       0.459  -8.499 -11.390  1.00 28.02           C  
ATOM   4570  C   ASP D 111      -0.650  -9.171 -10.569  1.00 27.92           C  
ATOM   4571  O   ASP D 111      -1.616  -9.684 -11.121  1.00 27.88           O  
ATOM   4572  CB  ASP D 111       0.324  -8.871 -12.870  1.00 28.90           C  
ATOM   4573  CG  ASP D 111       1.209  -8.028 -13.771  1.00 31.70           C  
ATOM   4574  OD1 ASP D 111       1.571  -6.893 -13.375  1.00 35.72           O  
ATOM   4575  OD2 ASP D 111       1.538  -8.495 -14.884  1.00 35.50           O  
ATOM   4576  N   GLY D 112      -0.481  -9.196  -9.255  1.00 27.87           N  
ATOM   4577  CA  GLY D 112      -1.489  -9.739  -8.350  1.00 28.07           C  
ATOM   4578  C   GLY D 112      -1.589 -11.258  -8.290  1.00 28.06           C  
ATOM   4579  O   GLY D 112      -2.441 -11.780  -7.575  1.00 29.29           O  
ATOM   4580  N   LYS D 113      -0.699 -11.967  -8.983  1.00 27.49           N  
ATOM   4581  CA  LYS D 113      -0.688 -13.436  -8.985  1.00 26.92           C  
ATOM   4582  C   LYS D 113       0.625 -13.950  -8.390  1.00 26.21           C  
ATOM   4583  O   LYS D 113       1.668 -13.306  -8.514  1.00 25.20           O  
ATOM   4584  CB  LYS D 113      -0.861 -13.975 -10.407  1.00 27.88           C  
ATOM   4585  CG  LYS D 113      -2.241 -13.691 -11.025  1.00 29.79           C  
ATOM   4586  CD  LYS D 113      -3.283 -14.705 -10.545  1.00 32.84           C  
ATOM   4587  CE  LYS D 113      -4.696 -14.419 -11.087  1.00 33.75           C  
ATOM   4588  NZ  LYS D 113      -5.518 -13.664 -10.084  1.00 38.55           N  
ATOM   4589  N   VAL D 114       0.559 -15.102  -7.731  1.00 24.72           N  
ATOM   4590  CA  VAL D 114       1.739 -15.699  -7.110  1.00 24.65           C  
ATOM   4591  C   VAL D 114       2.560 -16.375  -8.204  1.00 24.09           C  
ATOM   4592  O   VAL D 114       2.067 -17.286  -8.873  1.00 23.94           O  
ATOM   4593  CB  VAL D 114       1.336 -16.756  -6.062  1.00 24.51           C  
ATOM   4594  CG1 VAL D 114       2.559 -17.399  -5.444  1.00 24.59           C  
ATOM   4595  CG2 VAL D 114       0.456 -16.127  -4.995  1.00 26.02           C  
ATOM   4596  N   VAL D 115       3.800 -15.933  -8.378  1.00 23.67           N  
ATOM   4597  CA  VAL D 115       4.707 -16.525  -9.371  1.00 24.15           C  
ATOM   4598  C   VAL D 115       5.782 -17.435  -8.775  1.00 23.84           C  
ATOM   4599  O   VAL D 115       6.359 -18.266  -9.493  1.00 23.95           O  
ATOM   4600  CB  VAL D 115       5.392 -15.450 -10.248  1.00 23.88           C  
ATOM   4601  CG1 VAL D 115       4.363 -14.733 -11.087  1.00 25.05           C  
ATOM   4602  CG2 VAL D 115       6.210 -14.465  -9.404  1.00 24.40           C  
ATOM   4603  N   GLU D 116       6.095 -17.240  -7.500  1.00 24.46           N  
ATOM   4604  CA  GLU D 116       7.000 -18.122  -6.776  1.00 24.98           C  
ATOM   4605  C   GLU D 116       6.460 -18.367  -5.383  1.00 25.29           C  
ATOM   4606  O   GLU D 116       5.929 -17.457  -4.739  1.00 24.42           O  
ATOM   4607  CB  GLU D 116       8.416 -17.548  -6.697  1.00 24.96           C  
ATOM   4608  CG  GLU D 116       9.152 -17.578  -8.017  1.00 25.52           C  
ATOM   4609  CD  GLU D 116      10.595 -17.108  -7.907  1.00 26.85           C  
ATOM   4610  OE1 GLU D 116      10.809 -15.894  -7.692  1.00 28.40           O  
ATOM   4611  OE2 GLU D 116      11.515 -17.949  -8.050  1.00 27.85           O  
ATOM   4612  N   HIS D 117       6.640 -19.599  -4.923  1.00 25.33           N  
ATOM   4613  CA  HIS D 117       6.156 -20.028  -3.624  0.50 25.47           C  
ATOM   4615  C   HIS D 117       7.218 -20.923  -2.984  1.00 25.61           C  
ATOM   4616  O   HIS D 117       7.642 -21.917  -3.588  1.00 25.12           O  
ATOM   4617  CB  HIS D 117       4.812 -20.743  -3.818  0.50 25.79           C  
ATOM   4619  CG  HIS D 117       4.438 -21.687  -2.721  0.50 26.12           C  
ATOM   4621  ND1 HIS D 117       4.108 -23.005  -2.966  0.50 27.14           N  
ATOM   4623  CD2 HIS D 117       4.326 -21.513  -1.383  0.50 27.10           C  
ATOM   4625  CE1 HIS D 117       3.808 -23.601  -1.825  0.50 28.13           C  
ATOM   4627  NE2 HIS D 117       3.930 -22.718  -0.850  0.50 27.97           N  
ATOM   4629  N   TRP D 118       7.643 -20.559  -1.782  1.00 25.49           N  
ATOM   4630  CA  TRP D 118       8.612 -21.349  -1.017  1.00 25.86           C  
ATOM   4631  C   TRP D 118       7.966 -21.747   0.303  1.00 26.56           C  
ATOM   4632  O   TRP D 118       7.261 -20.938   0.928  1.00 27.43           O  
ATOM   4633  CB  TRP D 118       9.865 -20.536  -0.689  1.00 26.00           C  
ATOM   4634  CG  TRP D 118      10.627 -19.971  -1.840  1.00 25.44           C  
ATOM   4635  CD1 TRP D 118      11.724 -20.514  -2.432  1.00 25.49           C  
ATOM   4636  CD2 TRP D 118      10.396 -18.719  -2.494  1.00 24.87           C  
ATOM   4637  NE1 TRP D 118      12.176 -19.698  -3.434  1.00 25.05           N  
ATOM   4638  CE2 TRP D 118      11.380 -18.584  -3.490  1.00 24.91           C  
ATOM   4639  CE3 TRP D 118       9.451 -17.703  -2.340  1.00 25.80           C  
ATOM   4640  CZ2 TRP D 118      11.437 -17.477  -4.339  1.00 25.66           C  
ATOM   4641  CZ3 TRP D 118       9.510 -16.597  -3.186  1.00 25.56           C  
ATOM   4642  CH2 TRP D 118      10.502 -16.491  -4.161  1.00 25.42           C  
ATOM   4643  N   ASP D 119       8.208 -22.976   0.746  1.00 26.61           N  
ATOM   4644  CA  ASP D 119       7.775 -23.371   2.084  1.00 26.28           C  
ATOM   4645  C   ASP D 119       8.911 -23.956   2.906  1.00 25.80           C  
ATOM   4646  O   ASP D 119       9.866 -24.517   2.364  1.00 26.12           O  
ATOM   4647  CB  ASP D 119       6.588 -24.349   2.036  1.00 27.40           C  
ATOM   4648  CG  ASP D 119       6.918 -25.677   1.366  1.00 30.39           C  
ATOM   4649  OD1 ASP D 119       7.912 -26.351   1.737  1.00 34.25           O  
ATOM   4650  OD2 ASP D 119       6.143 -26.079   0.466  1.00 36.46           O  
ATOM   4651  N   VAL D 120       8.808 -23.769   4.218  1.00 24.76           N  
ATOM   4652  CA  VAL D 120       9.635 -24.466   5.188  1.00 24.49           C  
ATOM   4653  C   VAL D 120       8.659 -25.064   6.173  1.00 24.40           C  
ATOM   4654  O   VAL D 120       8.013 -24.331   6.933  1.00 24.27           O  
ATOM   4655  CB  VAL D 120      10.622 -23.519   5.912  1.00 24.05           C  
ATOM   4656  CG1 VAL D 120      11.359 -24.269   7.006  1.00 23.87           C  
ATOM   4657  CG2 VAL D 120      11.609 -22.917   4.893  1.00 24.19           C  
ATOM   4658  N   ILE D 121       8.528 -26.385   6.148  1.00 24.13           N  
ATOM   4659  CA  ILE D 121       7.517 -27.061   6.957  0.50 24.35           C  
ATOM   4661  C   ILE D 121       8.157 -27.922   8.041  1.00 24.20           C  
ATOM   4662  O   ILE D 121       8.923 -28.841   7.748  1.00 24.46           O  
ATOM   4663  CB  ILE D 121       6.589 -27.937   6.084  0.50 24.33           C  
ATOM   4665  CG1 ILE D 121       5.791 -27.064   5.107  0.50 24.42           C  
ATOM   4667  CG2 ILE D 121       5.642 -28.746   6.960  0.50 24.45           C  
ATOM   4669  CD1 ILE D 121       5.098 -27.847   4.007  0.50 24.64           C  
ATOM   4671  N   ASN D 122       7.829 -27.615   9.300  1.00 24.03           N  
ATOM   4672  CA  ASN D 122       8.237 -28.424  10.429  1.00 24.36           C  
ATOM   4673  C   ASN D 122       7.111 -29.363  10.857  1.00 24.57           C  
ATOM   4674  O   ASN D 122       6.187 -28.946  11.559  1.00 24.36           O  
ATOM   4675  CB  ASN D 122       8.628 -27.569  11.631  1.00 24.22           C  
ATOM   4676  CG  ASN D 122       8.946 -28.421  12.851  1.00 23.75           C  
ATOM   4677  OD1 ASN D 122       9.334 -29.589  12.707  1.00 23.20           O  
ATOM   4678  ND2 ASN D 122       8.781 -27.859  14.053  1.00 24.31           N  
ATOM   4679  N   MET D 123       7.220 -30.625  10.446  1.00 25.15           N  
ATOM   4680  CA  MET D 123       6.237 -31.660  10.794  0.50 25.62           C  
ATOM   4682  C   MET D 123       6.634 -32.456  12.041  1.00 25.51           C  
ATOM   4683  O   MET D 123       5.961 -33.433  12.397  1.00 25.20           O  
ATOM   4684  CB  MET D 123       6.055 -32.638   9.630  0.50 25.81           C  
ATOM   4686  CG  MET D 123       5.629 -31.997   8.314  0.50 25.95           C  
ATOM   4688  SD  MET D 123       4.140 -32.771   7.643  0.50 28.03           S  
ATOM   4690  CE  MET D 123       2.948 -31.969   8.693  0.50 29.06           C  
ATOM   4692  N   ARG D 124       7.714 -32.061  12.714  1.00 25.47           N  
ATOM   4693  CA  ARG D 124       8.187 -32.836  13.878  1.00 25.83           C  
ATOM   4694  C   ARG D 124       7.081 -33.231  14.867  1.00 25.87           C  
ATOM   4695  O   ARG D 124       6.967 -34.413  15.216  1.00 25.84           O  
ATOM   4696  CB  ARG D 124       9.308 -32.107  14.621  1.00 25.61           C  
ATOM   4697  CG  ARG D 124      10.028 -32.967  15.648  1.00 26.29           C  
ATOM   4698  CD  ARG D 124      10.728 -32.124  16.706  1.00 27.02           C  
ATOM   4699  NE  ARG D 124       9.772 -31.495  17.612  1.00 27.67           N  
ATOM   4700  CZ  ARG D 124       9.123 -32.126  18.592  1.00 30.07           C  
ATOM   4701  NH1 ARG D 124       9.330 -33.413  18.844  1.00 30.41           N  
ATOM   4702  NH2 ARG D 124       8.263 -31.458  19.344  1.00 30.12           N  
ATOM   4703  N   PRO D 125       6.268 -32.261  15.329  1.00 26.24           N  
ATOM   4704  CA  PRO D 125       5.259 -32.624  16.332  1.00 26.73           C  
ATOM   4705  C   PRO D 125       4.246 -33.636  15.806  1.00 27.02           C  
ATOM   4706  O   PRO D 125       3.800 -34.507  16.552  1.00 27.04           O  
ATOM   4707  CB  PRO D 125       4.559 -31.294  16.650  1.00 27.10           C  
ATOM   4708  CG  PRO D 125       5.410 -30.228  16.080  1.00 26.65           C  
ATOM   4709  CD  PRO D 125       6.184 -30.838  14.961  1.00 26.79           C  
ATOM   4710  N   LEU D 126       3.895 -33.516  14.529  1.00 27.35           N  
ATOM   4711  CA  LEU D 126       2.984 -34.458  13.881  1.00 27.72           C  
ATOM   4712  C   LEU D 126       3.593 -35.850  13.761  1.00 27.90           C  
ATOM   4713  O   LEU D 126       2.930 -36.853  14.063  1.00 27.78           O  
ATOM   4714  CB  LEU D 126       2.590 -33.946  12.498  1.00 27.64           C  
ATOM   4715  CG  LEU D 126       1.700 -34.851  11.640  1.00 28.07           C  
ATOM   4716  CD1 LEU D 126       0.410 -35.181  12.359  1.00 29.30           C  
ATOM   4717  CD2 LEU D 126       1.393 -34.174  10.326  1.00 28.73           C  
ATOM   4718  N   LEU D 127       4.848 -35.909  13.317  1.00 27.62           N  
ATOM   4719  CA  LEU D 127       5.563 -37.176  13.159  1.00 28.25           C  
ATOM   4720  C   LEU D 127       5.674 -37.928  14.481  1.00 28.29           C  
ATOM   4721  O   LEU D 127       5.611 -39.159  14.505  1.00 28.35           O  
ATOM   4722  CB  LEU D 127       6.960 -36.939  12.582  1.00 28.01           C  
ATOM   4723  CG  LEU D 127       6.978 -36.505  11.110  1.00 28.24           C  
ATOM   4724  CD1 LEU D 127       8.332 -35.918  10.760  1.00 28.50           C  
ATOM   4725  CD2 LEU D 127       6.658 -37.668  10.179  1.00 28.86           C  
ATOM   4726  N   VAL D 128       5.837 -37.183  15.572  1.00 28.84           N  
ATOM   4727  CA  VAL D 128       5.843 -37.765  16.912  1.00 29.67           C  
ATOM   4728  C   VAL D 128       4.466 -38.328  17.276  1.00 30.16           C  
ATOM   4729  O   VAL D 128       4.379 -39.435  17.806  1.00 29.84           O  
ATOM   4730  CB  VAL D 128       6.325 -36.749  17.981  1.00 29.62           C  
ATOM   4731  CG1 VAL D 128       6.122 -37.297  19.399  1.00 30.07           C  
ATOM   4732  CG2 VAL D 128       7.798 -36.414  17.760  1.00 29.66           C  
ATOM   4733  N   ARG D 129       3.397 -37.585  16.989  1.00 30.97           N  
ATOM   4734  CA  ARG D 129       2.033 -38.083  17.241  1.00 31.68           C  
ATOM   4735  C   ARG D 129       1.674 -39.290  16.363  1.00 31.77           C  
ATOM   4736  O   ARG D 129       0.963 -40.191  16.813  1.00 31.90           O  
ATOM   4737  CB  ARG D 129       0.984 -36.986  17.040  1.00 32.38           C  
ATOM   4738  CG  ARG D 129       1.089 -35.803  17.992  1.00 35.07           C  
ATOM   4739  CD  ARG D 129       0.647 -36.157  19.396  1.00 40.30           C  
ATOM   4740  NE  ARG D 129      -0.805 -36.100  19.566  1.00 42.70           N  
ATOM   4741  CZ  ARG D 129      -1.450 -35.348  20.466  1.00 44.55           C  
ATOM   4742  NH1 ARG D 129      -0.786 -34.559  21.319  1.00 45.28           N  
ATOM   4743  NH2 ARG D 129      -2.779 -35.392  20.526  1.00 44.14           N  
ATOM   4744  N   LEU D 130       2.159 -39.306  15.125  1.00 31.70           N  
ATOM   4745  CA  LEU D 130       1.929 -40.433  14.211  1.00 32.31           C  
ATOM   4746  C   LEU D 130       2.797 -41.660  14.521  1.00 32.22           C  
ATOM   4747  O   LEU D 130       2.597 -42.716  13.920  1.00 31.85           O  
ATOM   4748  CB  LEU D 130       2.171 -40.017  12.756  1.00 32.31           C  
ATOM   4749  CG  LEU D 130       1.228 -38.979  12.145  1.00 33.17           C  
ATOM   4750  CD1 LEU D 130       1.736 -38.554  10.785  1.00 33.32           C  
ATOM   4751  CD2 LEU D 130      -0.189 -39.496  12.032  1.00 33.48           C  
ATOM   4752  N   GLY D 131       3.761 -41.516  15.429  1.00 32.34           N  
ATOM   4753  CA  GLY D 131       4.623 -42.627  15.841  1.00 32.84           C  
ATOM   4754  C   GLY D 131       5.834 -42.832  14.947  1.00 33.03           C  
ATOM   4755  O   GLY D 131       6.530 -43.841  15.066  1.00 32.88           O  
ATOM   4756  N   LYS D 132       6.093 -41.866  14.066  1.00 33.38           N  
ATOM   4757  CA  LYS D 132       7.213 -41.926  13.123  1.00 33.95           C  
ATOM   4758  C   LYS D 132       8.538 -41.486  13.751  1.00 34.17           C  
ATOM   4759  O   LYS D 132       9.611 -41.844  13.262  1.00 34.16           O  
ATOM   4760  CB  LYS D 132       6.918 -41.049  11.902  1.00 34.11           C  
ATOM   4761  CG  LYS D 132       5.737 -41.505  11.060  1.00 35.03           C  
ATOM   4762  CD  LYS D 132       6.019 -42.835  10.375  1.00 36.08           C  
ATOM   4763  CE  LYS D 132       5.009 -43.120   9.283  1.00 36.15           C  
ATOM   4764  NZ  LYS D 132       5.187 -44.473   8.695  1.00 37.00           N  
ATOM   4765  N   LEU D 133       8.450 -40.686  14.810  1.00 34.53           N  
ATOM   4766  CA  LEU D 133       9.611 -40.258  15.588  1.00 34.90           C  
ATOM   4767  C   LEU D 133       9.274 -40.423  17.061  1.00 35.42           C  
ATOM   4768  O   LEU D 133       8.106 -40.342  17.433  1.00 35.84           O  
ATOM   4769  CB  LEU D 133       9.935 -38.787  15.326  1.00 34.67           C  
ATOM   4770  CG  LEU D 133      10.453 -38.369  13.953  1.00 34.52           C  
ATOM   4771  CD1 LEU D 133      10.507 -36.845  13.886  1.00 34.73           C  
ATOM   4772  CD2 LEU D 133      11.811 -38.971  13.658  1.00 34.20           C  
ATOM   4773  N   PRO D 134      10.291 -40.643  17.909  1.00 35.96           N  
ATOM   4774  CA  PRO D 134      10.029 -40.858  19.335  1.00 36.08           C  
ATOM   4775  C   PRO D 134       9.734 -39.559  20.092  1.00 36.42           C  
ATOM   4776  O   PRO D 134      10.214 -38.491  19.704  1.00 37.06           O  
ATOM   4777  CB  PRO D 134      11.328 -41.497  19.831  1.00 36.26           C  
ATOM   4778  CG  PRO D 134      12.381 -40.942  18.939  1.00 36.10           C  
ATOM   4779  CD  PRO D 134      11.731 -40.706  17.597  1.00 36.15           C  
TER    4780      PRO D 134                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
