
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  125 ( 1873),  selected  125 , name 1buq_A
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 1buq_A.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    N     2_A      -       -           -
LGA    T     3_A      -       -           -
LGA    P     4_A      N       2          3.002
LGA    E     5_A      S       3          2.927
LGA    H     6_A      E       4          2.593
LGA    M     7_A      I       5          1.203
LGA    T     8_A      E       6          1.722
LGA    A     9_A      L       7          2.005
LGA    V    10_A      P       8          1.523
LGA    V    11_A      V       9          1.438
LGA    Q    12_A      Q      10          0.973
LGA    R    13_A      K      11          0.729
LGA    Y    14_A      Q      12          1.314
LGA    V    15_A      L      13          0.963
LGA    A    16_A      E      14          1.607
LGA    A    17_A      A      15          1.466
LGA    L    18_A      Y      16          0.356
LGA    N    19_A      N      17          1.270
LGA    A    20_A      A      18          1.536
LGA    G    21_A      R      19          1.960
LGA    D    22_A      D      20          2.017
LGA    L    23_A      I      21          1.886
LGA    D    24_A      D      22          1.767
LGA    G    25_A      A      23          1.387
LGA    I    26_A      F      24          1.345
LGA    V    27_A      M      25          1.309
LGA    A    28_A      A      26          1.177
LGA    L    29_A      W      27          1.668
LGA    F    30_A      W      28          1.331
LGA    A    31_A      A      29          1.567
LGA    D    32_A      D      30          1.722
LGA    D    33_A      D      31          2.348
LGA    A    34_A      C      32          1.259
LGA    T    35_A      Q      33          1.208
LGA    V    36_A      Y      34          0.781
LGA    E    37_A      Y      35          0.894
LGA    D    38_A      A      36          1.539
LGA    P    39_A      F      37          4.124
LGA    V    40_A      P      38          3.127
LGA    G    41_A      A      39          4.247
LGA    S    42_A      T      40          1.489
LGA    E    43_A      L      41          3.074
LGA    P    44_A      L      42          3.131
LGA    R    45_A      A      43          0.680
LGA    S    46_A      G      44          1.751
LGA    G    47_A      N      45          1.423
LGA    T    48_A      A      46          2.386
LGA    A    49_A      A      47          2.151
LGA    A    50_A      E      48          0.965
LGA    I    51_A      I      49          1.057
LGA    R    52_A      R      50          1.149
LGA    E    53_A      V      51          1.752
LGA    F    54_A      R      52          1.603
LGA    F    55_A      H      53          2.130
LGA    A    56_A      I      54          1.996
LGA    N    57_A      E      55          2.510
LGA    S    58_A      R      56          2.884
LGA    L    59_A      F      57          2.486
LGA    K    60_A      K      58          3.386
LGA    L    61_A      E      59          3.581
LGA    P    62_A      P      60          3.930
LGA    L    63_A      D      61          3.945
LGA    -       -      L      62           -
LGA    A    64_A      Y      63          1.252
LGA    V    65_A      G      64          1.079
LGA    E    66_A      E      65          2.335
LGA    L    67_A      L      66          1.158
LGA    T    68_A      L      67          2.377
LGA    Q    69_A      T      68          1.991
LGA    E    70_A      R      69          3.160
LGA    V    71_A      -       -           -
LGA    R    72_A      V      70          1.821
LGA    A    73_A      I      71          1.882
LGA    V    74_A      V      72          2.083
LGA    A    75_A      G      73          2.347
LGA    N    76_A      N      74          2.145
LGA    E    77_A      V      75          2.346
LGA    A    78_A      V      76          2.218
LGA    A    79_A      I      77          1.875
LGA    F    80_A      D      78          1.985
LGA    A    81_A      H      79          0.666
LGA    F    82_A      E      80          1.071
LGA    T    83_A      T      81          1.056
LGA    V    84_A      V      82          1.649
LGA    S    85_A      T      83          1.968
LGA    F    86_A      R      84          2.549
LGA    E    87_A      N      85          2.763
LGA    F    88_A      F      86          3.053
LGA    Q    89_A      P      87          4.056
LGA    G    90_A      E      88          6.766
LGA    R    91_A      G      89          2.164
LGA    K    92_A      K      90          1.314
LGA    T    93_A      G      91          1.858
LGA    V    94_A      E      92          0.936
LGA    V    95_A      V      93          1.155
LGA    A    96_A      D      94          0.691
LGA    P    97_A      V      95          1.000
LGA    I    98_A      A      96          0.396
LGA    D    99_A      C      97          0.741
LGA    H   100_A      I      98          0.496
LGA    F   101_A      Y      99          0.523
LGA    R   102_A      E     100          0.855
LGA    F   103_A      V     101          0.800
LGA    N   104_A      E     102          0.623
LGA    G   105_A      N     103          3.138
LGA    A   106_A      G     104          2.947
LGA    G   107_A      -       -           -
LGA    K   108_A      R     105          2.372
LGA    V   109_A      I     106          1.840
LGA    V   110_A      A     107          1.890
LGA    S   111_A      K     108          1.122
LGA    M   112_A      A     109          0.807
LGA    R   113_A      W     110          1.103
LGA    A   114_A      F     111          0.939
LGA    L   115_A      K     112          1.472
LGA    F   116_A      I     113          2.117
LGA    G   117_A      G     114          4.007
LGA    E   118_A      E     115          3.645
LGA    K   119_A      -       -           -
LGA    N   120_A      -       -           -
LGA    I   121_A      P     116          1.939
LGA    H   122_A      R     117          0.663
LGA    A   123_A      I     118          3.198
LGA    G   124_A      -       -           -
LGA    A   125_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  125  117    5.0    116    2.15    23.28     76.429     5.161

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.849992 * X  +  -0.385403 * Y  +   0.359135 * Z  +  11.504599
  Y_new =  -0.452987 * X  +   0.882736 * Y  +  -0.124817 * Z  + -17.057686
  Z_new =  -0.268917 * X  +  -0.268777 * Y  +  -0.924901 * Z  +   5.601053 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.858781    0.282811  [ DEG:  -163.7961     16.2039 ]
  Theta =   0.272268    2.869324  [ DEG:    15.5998    164.4002 ]
  Phi   =  -2.651948    0.489644  [ DEG:  -151.9454     28.0545 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1buq_A                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1buq_A.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  125  117   5.0  116   2.15   23.28  76.429
REMARK  ---------------------------------------------------------- 
MOLECULE 1buq_A
HEADER    ISOMERASE                               04-SEP-98   1BUQ              
TITLE     SOLUTION STRUCTURE OF DELTA-5-3-KETOSTEROID ISOMERASE                 
TITLE    2 COMPLEXED WITH THE STEROID 19-NORTESTOSTERONE-HEMISUCCINATE          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (3-KETOSTEROID ISOMERASE-19-                       
COMPND   3 NORTESTOSTERONE-HEMISUCCINATE);                                      
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 SYNONYM: KSI;                                                        
COMPND   6 EC: 5.3.3.1;                                                         
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES;                                                       
COMPND   9 OTHER_DETAILS: KSI COMPLEXED WITH 19-NORTESTOSTERONE-                
COMPND  10 HEMISUCCINATE, A SUBSTRATE ANALOG.                                   
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: COMAMONAS TESTOSTERONI;                         
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   5 EXPRESSION_SYSTEM_CELL_LINE: BL21/DE3;                               
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: BACTERIAL;                            
SOURCE   7 EXPRESSION_SYSTEM_VECTOR: E.COLI;                                    
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-25B;                                  
SOURCE   9 OTHER_DETAILS: PET-25B+GENE                                          
KEYWDS    KETOSTEROID ISOMERASE-19NTHS, ENZYME-SUBSTRATE COMPLEX,               
KEYWDS   2 ENZYMES                                                              
EXPDTA    NMR, 15 STRUCTURES                                                    
AUTHOR    M.A.MASSIAH,C.ABEYGUNAWARDANA,A.G.GITTIS,A.S.MILDVAN                  
REVDAT   3   22-MAY-02 1BUQ    1       SOURCE REMARK SHEET                      
REVDAT   2   29-DEC-99 1BUQ    4       HEADER COMPND REMARK JRNL                
REVDAT   2 2                   4       ATOM   SOURCE SEQRES                     
REVDAT   1   20-JAN-99 1BUQ    0                                                
JRNL        AUTH   M.A.MASSIAH,C.ABEYGUNAWARDANA,A.G.GITTIS,                    
JRNL        AUTH 2 A.S.MILDVAN                                                  
JRNL        TITL   SOLUTION STRUCTURE OF DELTA 5-3-KETOSTEROID                  
JRNL        TITL 2 ISOMERASE COMPLEXED WITH THE STEROID                         
JRNL        TITL 3 19-NORTESTOSTERONE HEMISUCCINATE.                            
JRNL        REF    BIOCHEMISTRY                  V.  37 14701 1998              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1BUQ A    1   125  UNP    P00947   SDIS_COMTE       1    125             
DBREF  1BUQ B  201   325  UNP    P00947   SDIS_COMTE       1    125             
SEQRES   1 A  125  MET ASN THR PRO GLU HIS MET THR ALA VAL VAL GLN ARG          
SEQRES   2 A  125  TYR VAL ALA ALA LEU ASN ALA GLY ASP LEU ASP GLY ILE          
SEQRES   3 A  125  VAL ALA LEU PHE ALA ASP ASP ALA THR VAL GLU ASP PRO          
SEQRES   4 A  125  VAL GLY SER GLU PRO ARG SER GLY THR ALA ALA ILE ARG          
SEQRES   5 A  125  GLU PHE PHE ALA ASN SER LEU LYS LEU PRO LEU ALA VAL          
SEQRES   6 A  125  GLU LEU THR GLN GLU VAL ARG ALA VAL ALA ASN GLU ALA          
SEQRES   7 A  125  ALA PHE ALA PHE THR VAL SER PHE GLU PHE GLN GLY ARG          
SEQRES   8 A  125  LYS THR VAL VAL ALA PRO ILE ASP HIS PHE ARG PHE ASN          
SEQRES   9 A  125  GLY ALA GLY LYS VAL VAL SER MET ARG ALA LEU PHE GLY          
SEQRES  10 A  125  GLU LYS ASN ILE HIS ALA GLY ALA                              
SEQRES   1 B  125  MET ASN THR PRO GLU HIS MET THR ALA VAL VAL GLN ARG          
SEQRES   2 B  125  TYR VAL ALA ALA LEU ASN ALA GLY ASP LEU ASP GLY ILE          
SEQRES   3 B  125  VAL ALA LEU PHE ALA ASP ASP ALA THR VAL GLU ASP PRO          
SEQRES   4 B  125  VAL GLY SER GLU PRO ARG SER GLY THR ALA ALA ILE ARG          
SEQRES   5 B  125  GLU PHE PHE ALA ASN SER LEU LYS LEU PRO LEU ALA VAL          
SEQRES   6 B  125  GLU LEU THR GLN GLU VAL ARG ALA VAL ALA ASN GLU ALA          
SEQRES   7 B  125  ALA PHE ALA PHE THR VAL SER PHE GLU PHE GLN GLY ARG          
SEQRES   8 B  125  LYS THR VAL VAL ALA PRO ILE ASP HIS PHE ARG PHE ASN          
SEQRES   9 B  125  GLY ALA GLY LYS VAL VAL SER MET ARG ALA LEU PHE GLY          
SEQRES  10 B  125  GLU LYS ASN ILE HIS ALA GLY ALA                              
HET    NTH    126      56                                                       
HET    NTH    326      56                                                       
HETNAM     NTH SUCCINIC ACID MONO-(13-METHYL-3-OXO-2,3,6,7,8,9,10,11,           
HETNAM   2 NTH  12,13,14,15,16,17-TETRADECAHYDRO-1H-                            
HETNAM   3 NTH  CYCLOPENTA[A]PHENANTHREN-17-YL) ESTER                           
FORMUL   3  NTH    2(C22 H30 O5)                                                
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       9.664   0.705   0.206  1.00  0.00           N  
ATOM      2  CA  MET A   1       8.439   1.499   0.512  1.00  0.00           C  
ATOM      3  C   MET A   1       7.275   1.037  -0.369  1.00  0.00           C  
ATOM      4  O   MET A   1       7.109   1.490  -1.484  1.00  0.00           O  
ATOM      5  CB  MET A   1       8.816   2.946   0.188  1.00  0.00           C  
ATOM      6  CG  MET A   1       7.688   3.878   0.631  1.00  0.00           C  
ATOM      7  SD  MET A   1       8.365   5.192   1.677  1.00  0.00           S  
ATOM      8  CE  MET A   1       6.813   5.669   2.473  1.00  0.00           C  
ATOM      9  HA  MET A   1       8.182   1.410   1.556  1.00  0.00           H  
ATOM     10  HB2 MET A   1       9.725   3.206   0.709  1.00  0.00           H  
ATOM     11  HB3 MET A   1       8.968   3.049  -0.876  1.00  0.00           H  
ATOM     12  HG2 MET A   1       7.220   4.317  -0.239  1.00  0.00           H  
ATOM     13  HG3 MET A   1       6.953   3.316   1.189  1.00  0.00           H  
ATOM     14  HE1 MET A   1       6.040   4.961   2.207  1.00  0.00           H  
ATOM     15  HE2 MET A   1       6.947   5.679   3.546  1.00  0.00           H  
ATOM     16  HE3 MET A   1       6.524   6.653   2.141  1.00  0.00           H  
ATOM     17  H1  MET A   1       9.854   0.740  -0.815  1.00  0.00           H  
ATOM     18  H2  MET A   1      10.473   1.104   0.725  1.00  0.00           H  
ATOM     19  H3  MET A   1       9.519  -0.282   0.496  1.00  0.00           H  
ATOM     20  N   ASN A   2       6.467   0.137   0.122  1.00  0.00           N  
ATOM     21  CA  ASN A   2       5.317  -0.353  -0.691  1.00  0.00           C  
ATOM     22  C   ASN A   2       4.189  -0.810   0.238  1.00  0.00           C  
ATOM     23  O   ASN A   2       4.411  -1.132   1.389  1.00  0.00           O  
ATOM     24  CB  ASN A   2       5.771  -1.528  -1.559  1.00  0.00           C  
ATOM     25  CG  ASN A   2       4.560  -2.143  -2.260  1.00  0.00           C  
ATOM     26  OD1 ASN A   2       4.375  -1.963  -3.447  1.00  0.00           O  
ATOM     27  ND2 ASN A   2       3.720  -2.866  -1.572  1.00  0.00           N  
ATOM     28  H   ASN A   2       6.617  -0.218   1.023  1.00  0.00           H  
ATOM     29  HA  ASN A   2       4.960   0.445  -1.324  1.00  0.00           H  
ATOM     30  HB2 ASN A   2       6.477  -1.177  -2.298  1.00  0.00           H  
ATOM     31  HB3 ASN A   2       6.243  -2.274  -0.937  1.00  0.00           H  
ATOM     32 HD21 ASN A   2       3.870  -3.011  -0.614  1.00  0.00           H  
ATOM     33 HD22 ASN A   2       2.941  -3.266  -2.013  1.00  0.00           H  
ATOM     34  N   THR A   3       2.981  -0.840  -0.254  1.00  0.00           N  
ATOM     35  CA  THR A   3       1.836  -1.273   0.594  1.00  0.00           C  
ATOM     36  C   THR A   3       1.676  -2.792   0.504  1.00  0.00           C  
ATOM     37  O   THR A   3       1.275  -3.313  -0.518  1.00  0.00           O  
ATOM     38  CB  THR A   3       0.563  -0.601   0.096  1.00  0.00           C  
ATOM     39  OG1 THR A   3       0.883   0.667  -0.461  1.00  0.00           O  
ATOM     40  CG2 THR A   3      -0.413  -0.419   1.260  1.00  0.00           C  
ATOM     41  H   THR A   3       2.824  -0.575  -1.185  1.00  0.00           H  
ATOM     42  HA  THR A   3       2.011  -0.988   1.613  1.00  0.00           H  
ATOM     43  HB  THR A   3       0.111  -1.219  -0.652  1.00  0.00           H  
ATOM     44  HG1 THR A   3       0.745   1.333   0.216  1.00  0.00           H  
ATOM     45 HG21 THR A   3       0.012  -0.846   2.156  1.00  0.00           H  
ATOM     46 HG22 THR A   3      -0.597   0.634   1.415  1.00  0.00           H  
ATOM     47 HG23 THR A   3      -1.344  -0.917   1.031  1.00  0.00           H  
ATOM     48  N   PRO A   4       1.988  -3.456   1.585  1.00  0.00           N  
ATOM     49  CA  PRO A   4       1.872  -4.933   1.631  1.00  0.00           C  
ATOM     50  C   PRO A   4       0.398  -5.346   1.682  1.00  0.00           C  
ATOM     51  O   PRO A   4       0.069  -6.516   1.658  1.00  0.00           O  
ATOM     52  CB  PRO A   4       2.589  -5.311   2.925  1.00  0.00           C  
ATOM     53  CG  PRO A   4       2.507  -4.088   3.781  1.00  0.00           C  
ATOM     54  CD  PRO A   4       2.475  -2.901   2.854  1.00  0.00           C  
ATOM     55  HA  PRO A   4       2.368  -5.383   0.786  1.00  0.00           H  
ATOM     56  HB2 PRO A   4       2.087  -6.143   3.401  1.00  0.00           H  
ATOM     57  HB3 PRO A   4       3.621  -5.555   2.726  1.00  0.00           H  
ATOM     58  HG2 PRO A   4       1.606  -4.116   4.379  1.00  0.00           H  
ATOM     59  HG3 PRO A   4       3.373  -4.026   4.420  1.00  0.00           H  
ATOM     60  HD2 PRO A   4       1.795  -2.147   3.228  1.00  0.00           H  
ATOM     61  HD3 PRO A   4       3.465  -2.492   2.726  1.00  0.00           H  
ATOM     62  N   GLU A   5      -0.490  -4.393   1.751  1.00  0.00           N  
ATOM     63  CA  GLU A   5      -1.942  -4.728   1.805  1.00  0.00           C  
ATOM     64  C   GLU A   5      -2.299  -5.627   0.620  1.00  0.00           C  
ATOM     65  O   GLU A   5      -2.989  -6.617   0.764  1.00  0.00           O  
ATOM     66  CB  GLU A   5      -2.766  -3.441   1.737  1.00  0.00           C  
ATOM     67  CG  GLU A   5      -4.224  -3.749   2.085  1.00  0.00           C  
ATOM     68  CD  GLU A   5      -5.149  -2.981   1.138  1.00  0.00           C  
ATOM     69  OE1 GLU A   5      -5.180  -1.765   1.228  1.00  0.00           O  
ATOM     70  OE2 GLU A   5      -5.812  -3.623   0.340  1.00  0.00           O  
ATOM     71  H   GLU A   5      -0.203  -3.455   1.769  1.00  0.00           H  
ATOM     72  HA  GLU A   5      -2.157  -5.246   2.727  1.00  0.00           H  
ATOM     73  HB2 GLU A   5      -2.370  -2.723   2.442  1.00  0.00           H  
ATOM     74  HB3 GLU A   5      -2.714  -3.033   0.739  1.00  0.00           H  
ATOM     75  HG2 GLU A   5      -4.402  -4.809   1.982  1.00  0.00           H  
ATOM     76  HG3 GLU A   5      -4.422  -3.446   3.103  1.00  0.00           H  
ATOM     77  N   HIS A   6      -1.839  -5.290  -0.554  1.00  0.00           N  
ATOM     78  CA  HIS A   6      -2.154  -6.125  -1.748  1.00  0.00           C  
ATOM     79  C   HIS A   6      -1.478  -7.490  -1.611  1.00  0.00           C  
ATOM     80  O   HIS A   6      -2.119  -8.520  -1.679  1.00  0.00           O  
ATOM     81  CB  HIS A   6      -1.640  -5.427  -3.009  1.00  0.00           C  
ATOM     82  CG  HIS A   6      -2.687  -5.506  -4.087  1.00  0.00           C  
ATOM     83  ND1 HIS A   6      -3.068  -4.399  -4.829  1.00  0.00           N  
ATOM     84  CD2 HIS A   6      -3.440  -6.552  -4.558  1.00  0.00           C  
ATOM     85  CE1 HIS A   6      -4.012  -4.801  -5.699  1.00  0.00           C  
ATOM     86  NE2 HIS A   6      -4.276  -6.105  -5.577  1.00  0.00           N  
ATOM     87  H   HIS A   6      -1.285  -4.487  -0.649  1.00  0.00           H  
ATOM     88  HA  HIS A   6      -3.223  -6.258  -1.820  1.00  0.00           H  
ATOM     89  HB2 HIS A   6      -1.429  -4.391  -2.787  1.00  0.00           H  
ATOM     90  HB3 HIS A   6      -0.739  -5.914  -3.347  1.00  0.00           H  
ATOM     91  HD1 HIS A   6      -2.714  -3.490  -4.736  1.00  0.00           H  
ATOM     92  HD2 HIS A   6      -3.392  -7.568  -4.194  1.00  0.00           H  
ATOM     93  HE1 HIS A   6      -4.498  -4.148  -6.410  1.00  0.00           H  
ATOM     94  N   MET A   7      -0.187  -7.507  -1.419  1.00  0.00           N  
ATOM     95  CA  MET A   7       0.532  -8.791  -1.278  1.00  0.00           C  
ATOM     96  C   MET A   7      -0.058  -9.581  -0.108  1.00  0.00           C  
ATOM     97  O   MET A   7      -0.368 -10.749  -0.229  1.00  0.00           O  
ATOM     98  CB  MET A   7       2.001  -8.487  -1.012  1.00  0.00           C  
ATOM     99  CG  MET A   7       2.563  -7.640  -2.156  1.00  0.00           C  
ATOM    100  SD  MET A   7       4.174  -6.968  -1.674  1.00  0.00           S  
ATOM    101  CE  MET A   7       4.079  -5.436  -2.634  1.00  0.00           C  
ATOM    102  H   MET A   7       0.316  -6.672  -1.366  1.00  0.00           H  
ATOM    103  HA  MET A   7       0.439  -9.365  -2.188  1.00  0.00           H  
ATOM    104  HB2 MET A   7       2.094  -7.945  -0.082  1.00  0.00           H  
ATOM    105  HB3 MET A   7       2.544  -9.403  -0.949  1.00  0.00           H  
ATOM    106  HG2 MET A   7       2.679  -8.255  -3.036  1.00  0.00           H  
ATOM    107  HG3 MET A   7       1.885  -6.828  -2.371  1.00  0.00           H  
ATOM    108  HE1 MET A   7       3.074  -5.049  -2.596  1.00  0.00           H  
ATOM    109  HE2 MET A   7       4.760  -4.708  -2.216  1.00  0.00           H  
ATOM    110  HE3 MET A   7       4.346  -5.639  -3.662  1.00  0.00           H  
ATOM    111  N   THR A   8      -0.219  -8.950   1.022  1.00  0.00           N  
ATOM    112  CA  THR A   8      -0.794  -9.665   2.194  1.00  0.00           C  
ATOM    113  C   THR A   8      -2.132 -10.283   1.793  1.00  0.00           C  
ATOM    114  O   THR A   8      -2.465 -11.379   2.199  1.00  0.00           O  
ATOM    115  CB  THR A   8      -1.011  -8.676   3.342  1.00  0.00           C  
ATOM    116  OG1 THR A   8       0.243  -8.330   3.910  1.00  0.00           O  
ATOM    117  CG2 THR A   8      -1.899  -9.319   4.411  1.00  0.00           C  
ATOM    118  H   THR A   8       0.034  -8.008   1.097  1.00  0.00           H  
ATOM    119  HA  THR A   8      -0.116 -10.443   2.511  1.00  0.00           H  
ATOM    120  HB  THR A   8      -1.495  -7.787   2.966  1.00  0.00           H  
ATOM    121  HG1 THR A   8       0.337  -7.375   3.866  1.00  0.00           H  
ATOM    122 HG21 THR A   8      -2.081 -10.353   4.152  1.00  0.00           H  
ATOM    123 HG22 THR A   8      -1.402  -9.270   5.368  1.00  0.00           H  
ATOM    124 HG23 THR A   8      -2.838  -8.790   4.465  1.00  0.00           H  
ATOM    125  N   ALA A   9      -2.899  -9.595   0.994  1.00  0.00           N  
ATOM    126  CA  ALA A   9      -4.208 -10.155   0.568  1.00  0.00           C  
ATOM    127  C   ALA A   9      -3.986 -11.581   0.074  1.00  0.00           C  
ATOM    128  O   ALA A   9      -4.733 -12.484   0.393  1.00  0.00           O  
ATOM    129  CB  ALA A   9      -4.791  -9.301  -0.561  1.00  0.00           C  
ATOM    130  H   ALA A   9      -2.611  -8.717   0.670  1.00  0.00           H  
ATOM    131  HA  ALA A   9      -4.888 -10.164   1.409  1.00  0.00           H  
ATOM    132  HB1 ALA A   9      -4.892  -8.279  -0.224  1.00  0.00           H  
ATOM    133  HB2 ALA A   9      -4.131  -9.334  -1.415  1.00  0.00           H  
ATOM    134  HB3 ALA A   9      -5.761  -9.686  -0.840  1.00  0.00           H  
ATOM    135  N   VAL A  10      -2.948 -11.794  -0.688  1.00  0.00           N  
ATOM    136  CA  VAL A  10      -2.664 -13.167  -1.182  1.00  0.00           C  
ATOM    137  C   VAL A  10      -2.562 -14.096   0.031  1.00  0.00           C  
ATOM    138  O   VAL A  10      -3.182 -15.137   0.081  1.00  0.00           O  
ATOM    139  CB  VAL A  10      -1.338 -13.172  -1.970  1.00  0.00           C  
ATOM    140  CG1 VAL A  10      -0.671 -14.551  -1.880  1.00  0.00           C  
ATOM    141  CG2 VAL A  10      -1.611 -12.853  -3.442  1.00  0.00           C  
ATOM    142  H   VAL A  10      -2.350 -11.052  -0.920  1.00  0.00           H  
ATOM    143  HA  VAL A  10      -3.470 -13.495  -1.823  1.00  0.00           H  
ATOM    144  HB  VAL A  10      -0.674 -12.425  -1.557  1.00  0.00           H  
ATOM    145 HG11 VAL A  10      -1.430 -15.310  -1.764  1.00  0.00           H  
ATOM    146 HG12 VAL A  10      -0.109 -14.738  -2.782  1.00  0.00           H  
ATOM    147 HG13 VAL A  10      -0.006 -14.574  -1.031  1.00  0.00           H  
ATOM    148 HG21 VAL A  10      -2.440 -12.166  -3.516  1.00  0.00           H  
ATOM    149 HG22 VAL A  10      -0.731 -12.405  -3.882  1.00  0.00           H  
ATOM    150 HG23 VAL A  10      -1.850 -13.764  -3.971  1.00  0.00           H  
ATOM    151  N   VAL A  11      -1.784 -13.715   1.007  1.00  0.00           N  
ATOM    152  CA  VAL A  11      -1.630 -14.563   2.226  1.00  0.00           C  
ATOM    153  C   VAL A  11      -3.009 -14.854   2.825  1.00  0.00           C  
ATOM    154  O   VAL A  11      -3.292 -15.957   3.249  1.00  0.00           O  
ATOM    155  CB  VAL A  11      -0.761 -13.815   3.248  1.00  0.00           C  
ATOM    156  CG1 VAL A  11      -1.012 -14.366   4.653  1.00  0.00           C  
ATOM    157  CG2 VAL A  11       0.716 -14.000   2.888  1.00  0.00           C  
ATOM    158  H   VAL A  11      -1.298 -12.865   0.940  1.00  0.00           H  
ATOM    159  HA  VAL A  11      -1.151 -15.493   1.958  1.00  0.00           H  
ATOM    160  HB  VAL A  11      -1.008 -12.764   3.226  1.00  0.00           H  
ATOM    161 HG11 VAL A  11      -1.467 -15.344   4.580  1.00  0.00           H  
ATOM    162 HG12 VAL A  11      -0.075 -14.443   5.181  1.00  0.00           H  
ATOM    163 HG13 VAL A  11      -1.674 -13.700   5.185  1.00  0.00           H  
ATOM    164 HG21 VAL A  11       0.859 -14.971   2.439  1.00  0.00           H  
ATOM    165 HG22 VAL A  11       1.016 -13.233   2.191  1.00  0.00           H  
ATOM    166 HG23 VAL A  11       1.316 -13.928   3.784  1.00  0.00           H  
ATOM    167  N   GLN A  12      -3.871 -13.878   2.855  1.00  0.00           N  
ATOM    168  CA  GLN A  12      -5.229 -14.096   3.414  1.00  0.00           C  
ATOM    169  C   GLN A  12      -5.933 -15.124   2.552  1.00  0.00           C  
ATOM    170  O   GLN A  12      -6.078 -16.278   2.904  1.00  0.00           O  
ATOM    171  CB  GLN A  12      -6.005 -12.781   3.350  1.00  0.00           C  
ATOM    172  CG  GLN A  12      -7.466 -13.030   3.717  1.00  0.00           C  
ATOM    173  CD  GLN A  12      -8.343 -11.929   3.115  1.00  0.00           C  
ATOM    174  OE1 GLN A  12      -8.151 -11.535   1.982  1.00  0.00           O  
ATOM    175  NE2 GLN A  12      -9.303 -11.412   3.832  1.00  0.00           N  
ATOM    176  H   GLN A  12      -3.630 -13.002   2.496  1.00  0.00           H  
ATOM    177  HA  GLN A  12      -5.169 -14.443   4.433  1.00  0.00           H  
ATOM    178  HB2 GLN A  12      -5.574 -12.075   4.039  1.00  0.00           H  
ATOM    179  HB3 GLN A  12      -5.952 -12.379   2.350  1.00  0.00           H  
ATOM    180  HG2 GLN A  12      -7.776 -13.989   3.333  1.00  0.00           H  
ATOM    181  HG3 GLN A  12      -7.568 -13.024   4.785  1.00  0.00           H  
ATOM    182 HE21 GLN A  12      -9.458 -11.729   4.746  1.00  0.00           H  
ATOM    183 HE22 GLN A  12      -9.870 -10.707   3.455  1.00  0.00           H  
ATOM    184  N   ARG A  13      -6.350 -14.694   1.409  1.00  0.00           N  
ATOM    185  CA  ARG A  13      -7.033 -15.597   0.461  1.00  0.00           C  
ATOM    186  C   ARG A  13      -6.274 -16.920   0.418  1.00  0.00           C  
ATOM    187  O   ARG A  13      -6.845 -17.991   0.478  1.00  0.00           O  
ATOM    188  CB  ARG A  13      -6.991 -14.938  -0.910  1.00  0.00           C  
ATOM    189  CG  ARG A  13      -8.352 -14.318  -1.219  1.00  0.00           C  
ATOM    190  CD  ARG A  13      -8.383 -13.845  -2.674  1.00  0.00           C  
ATOM    191  NE  ARG A  13      -8.788 -14.973  -3.557  1.00  0.00           N  
ATOM    192  CZ  ARG A  13     -10.053 -15.234  -3.741  1.00  0.00           C  
ATOM    193  NH1 ARG A  13     -10.850 -14.313  -4.210  1.00  0.00           N  
ATOM    194  NH2 ARG A  13     -10.522 -16.417  -3.456  1.00  0.00           N  
ATOM    195  H   ARG A  13      -6.193 -13.763   1.164  1.00  0.00           H  
ATOM    196  HA  ARG A  13      -8.055 -15.759   0.766  1.00  0.00           H  
ATOM    197  HB2 ARG A  13      -6.235 -14.166  -0.911  1.00  0.00           H  
ATOM    198  HB3 ARG A  13      -6.747 -15.675  -1.648  1.00  0.00           H  
ATOM    199  HG2 ARG A  13      -9.123 -15.053  -1.057  1.00  0.00           H  
ATOM    200  HG3 ARG A  13      -8.518 -13.475  -0.566  1.00  0.00           H  
ATOM    201  HD2 ARG A  13      -9.093 -13.038  -2.773  1.00  0.00           H  
ATOM    202  HD3 ARG A  13      -7.401 -13.498  -2.961  1.00  0.00           H  
ATOM    203  HE  ARG A  13      -8.106 -15.518  -4.001  1.00  0.00           H  
ATOM    204 HH11 ARG A  13     -10.491 -13.405  -4.429  1.00  0.00           H  
ATOM    205 HH12 ARG A  13     -11.819 -14.515  -4.351  1.00  0.00           H  
ATOM    206 HH21 ARG A  13      -9.914 -17.124  -3.096  1.00  0.00           H  
ATOM    207 HH22 ARG A  13     -11.492 -16.617  -3.598  1.00  0.00           H  
ATOM    208  N   TYR A  14      -4.983 -16.833   0.319  1.00  0.00           N  
ATOM    209  CA  TYR A  14      -4.133 -18.055   0.275  1.00  0.00           C  
ATOM    210  C   TYR A  14      -4.544 -18.986   1.415  1.00  0.00           C  
ATOM    211  O   TYR A  14      -4.712 -20.176   1.230  1.00  0.00           O  
ATOM    212  CB  TYR A  14      -2.665 -17.631   0.433  1.00  0.00           C  
ATOM    213  CG  TYR A  14      -1.820 -18.779   0.932  1.00  0.00           C  
ATOM    214  CD1 TYR A  14      -1.875 -19.152   2.279  1.00  0.00           C  
ATOM    215  CD2 TYR A  14      -0.967 -19.453   0.052  1.00  0.00           C  
ATOM    216  CE1 TYR A  14      -1.079 -20.203   2.748  1.00  0.00           C  
ATOM    217  CE2 TYR A  14      -0.172 -20.506   0.519  1.00  0.00           C  
ATOM    218  CZ  TYR A  14      -0.226 -20.883   1.870  1.00  0.00           C  
ATOM    219  OH  TYR A  14       0.567 -21.920   2.339  1.00  0.00           O  
ATOM    220  H   TYR A  14      -4.566 -15.949   0.279  1.00  0.00           H  
ATOM    221  HA  TYR A  14      -4.269 -18.559  -0.671  1.00  0.00           H  
ATOM    222  HB2 TYR A  14      -2.286 -17.300  -0.522  1.00  0.00           H  
ATOM    223  HB3 TYR A  14      -2.607 -16.817   1.140  1.00  0.00           H  
ATOM    224  HD1 TYR A  14      -2.535 -18.631   2.957  1.00  0.00           H  
ATOM    225  HD2 TYR A  14      -0.925 -19.165  -0.987  1.00  0.00           H  
ATOM    226  HE1 TYR A  14      -1.124 -20.487   3.786  1.00  0.00           H  
ATOM    227  HE2 TYR A  14       0.483 -21.026  -0.164  1.00  0.00           H  
ATOM    228  HH  TYR A  14       0.155 -22.287   3.130  1.00  0.00           H  
ATOM    229  N   VAL A  15      -4.715 -18.452   2.590  1.00  0.00           N  
ATOM    230  CA  VAL A  15      -5.121 -19.303   3.740  1.00  0.00           C  
ATOM    231  C   VAL A  15      -6.649 -19.429   3.755  1.00  0.00           C  
ATOM    232  O   VAL A  15      -7.185 -20.481   4.043  1.00  0.00           O  
ATOM    233  CB  VAL A  15      -4.583 -18.682   5.038  1.00  0.00           C  
ATOM    234  CG1 VAL A  15      -5.602 -18.804   6.179  1.00  0.00           C  
ATOM    235  CG2 VAL A  15      -3.296 -19.402   5.437  1.00  0.00           C  
ATOM    236  H   VAL A  15      -4.578 -17.489   2.714  1.00  0.00           H  
ATOM    237  HA  VAL A  15      -4.695 -20.282   3.616  1.00  0.00           H  
ATOM    238  HB  VAL A  15      -4.363 -17.646   4.859  1.00  0.00           H  
ATOM    239 HG11 VAL A  15      -6.543 -18.372   5.870  1.00  0.00           H  
ATOM    240 HG12 VAL A  15      -5.747 -19.847   6.420  1.00  0.00           H  
ATOM    241 HG13 VAL A  15      -5.233 -18.282   7.049  1.00  0.00           H  
ATOM    242 HG21 VAL A  15      -2.785 -19.743   4.548  1.00  0.00           H  
ATOM    243 HG22 VAL A  15      -2.657 -18.721   5.980  1.00  0.00           H  
ATOM    244 HG23 VAL A  15      -3.536 -20.249   6.062  1.00  0.00           H  
ATOM    245  N   ALA A  16      -7.358 -18.385   3.423  1.00  0.00           N  
ATOM    246  CA  ALA A  16      -8.842 -18.496   3.401  1.00  0.00           C  
ATOM    247  C   ALA A  16      -9.196 -19.755   2.613  1.00  0.00           C  
ATOM    248  O   ALA A  16     -10.099 -20.490   2.960  1.00  0.00           O  
ATOM    249  CB  ALA A  16      -9.445 -17.268   2.717  1.00  0.00           C  
ATOM    250  H   ALA A  16      -6.920 -17.546   3.172  1.00  0.00           H  
ATOM    251  HA  ALA A  16      -9.220 -18.582   4.412  1.00  0.00           H  
ATOM    252  HB1 ALA A  16      -8.919 -16.383   3.039  1.00  0.00           H  
ATOM    253  HB2 ALA A  16      -9.355 -17.372   1.646  1.00  0.00           H  
ATOM    254  HB3 ALA A  16     -10.489 -17.184   2.985  1.00  0.00           H  
ATOM    255  N   ALA A  17      -8.458 -20.023   1.569  1.00  0.00           N  
ATOM    256  CA  ALA A  17      -8.711 -21.250   0.768  1.00  0.00           C  
ATOM    257  C   ALA A  17      -8.249 -22.447   1.597  1.00  0.00           C  
ATOM    258  O   ALA A  17      -8.820 -23.519   1.545  1.00  0.00           O  
ATOM    259  CB  ALA A  17      -7.914 -21.183  -0.537  1.00  0.00           C  
ATOM    260  H   ALA A  17      -7.720 -19.425   1.326  1.00  0.00           H  
ATOM    261  HA  ALA A  17      -9.767 -21.337   0.554  1.00  0.00           H  
ATOM    262  HB1 ALA A  17      -6.870 -21.021  -0.312  1.00  0.00           H  
ATOM    263  HB2 ALA A  17      -8.027 -22.112  -1.076  1.00  0.00           H  
ATOM    264  HB3 ALA A  17      -8.282 -20.367  -1.142  1.00  0.00           H  
ATOM    265  N   LEU A  18      -7.223 -22.253   2.383  1.00  0.00           N  
ATOM    266  CA  LEU A  18      -6.712 -23.338   3.249  1.00  0.00           C  
ATOM    267  C   LEU A  18      -7.766 -23.639   4.312  1.00  0.00           C  
ATOM    268  O   LEU A  18      -8.277 -24.736   4.416  1.00  0.00           O  
ATOM    269  CB  LEU A  18      -5.444 -22.839   3.935  1.00  0.00           C  
ATOM    270  CG  LEU A  18      -4.225 -23.085   3.043  1.00  0.00           C  
ATOM    271  CD1 LEU A  18      -3.221 -21.944   3.237  1.00  0.00           C  
ATOM    272  CD2 LEU A  18      -3.570 -24.411   3.433  1.00  0.00           C  
ATOM    273  H   LEU A  18      -6.795 -21.375   2.419  1.00  0.00           H  
ATOM    274  HA  LEU A  18      -6.500 -24.221   2.666  1.00  0.00           H  
ATOM    275  HB2 LEU A  18      -5.541 -21.783   4.125  1.00  0.00           H  
ATOM    276  HB3 LEU A  18      -5.318 -23.350   4.864  1.00  0.00           H  
ATOM    277  HG  LEU A  18      -4.535 -23.122   2.009  1.00  0.00           H  
ATOM    278 HD11 LEU A  18      -3.382 -21.482   4.201  1.00  0.00           H  
ATOM    279 HD12 LEU A  18      -2.216 -22.332   3.188  1.00  0.00           H  
ATOM    280 HD13 LEU A  18      -3.360 -21.205   2.460  1.00  0.00           H  
ATOM    281 HD21 LEU A  18      -4.098 -24.841   4.271  1.00  0.00           H  
ATOM    282 HD22 LEU A  18      -3.610 -25.093   2.596  1.00  0.00           H  
ATOM    283 HD23 LEU A  18      -2.540 -24.237   3.707  1.00  0.00           H  
ATOM    284  N   ASN A  19      -8.098 -22.649   5.093  1.00  0.00           N  
ATOM    285  CA  ASN A  19      -9.124 -22.825   6.154  1.00  0.00           C  
ATOM    286  C   ASN A  19     -10.348 -23.515   5.560  1.00  0.00           C  
ATOM    287  O   ASN A  19     -10.960 -24.366   6.174  1.00  0.00           O  
ATOM    288  CB  ASN A  19      -9.527 -21.447   6.680  1.00  0.00           C  
ATOM    289  CG  ASN A  19      -9.700 -21.505   8.198  1.00  0.00           C  
ATOM    290  OD1 ASN A  19      -8.881 -22.075   8.893  1.00  0.00           O  
ATOM    291  ND2 ASN A  19     -10.739 -20.939   8.746  1.00  0.00           N  
ATOM    292  H   ASN A  19      -7.671 -21.775   4.972  1.00  0.00           H  
ATOM    293  HA  ASN A  19      -8.722 -23.420   6.960  1.00  0.00           H  
ATOM    294  HB2 ASN A  19      -8.756 -20.735   6.429  1.00  0.00           H  
ATOM    295  HB3 ASN A  19     -10.456 -21.141   6.223  1.00  0.00           H  
ATOM    296 HD21 ASN A  19     -11.400 -20.481   8.186  1.00  0.00           H  
ATOM    297 HD22 ASN A  19     -10.859 -20.971   9.718  1.00  0.00           H  
ATOM    298  N   ALA A  20     -10.709 -23.147   4.365  1.00  0.00           N  
ATOM    299  CA  ALA A  20     -11.897 -23.771   3.718  1.00  0.00           C  
ATOM    300  C   ALA A  20     -11.465 -25.015   2.938  1.00  0.00           C  
ATOM    301  O   ALA A  20     -12.251 -25.627   2.241  1.00  0.00           O  
ATOM    302  CB  ALA A  20     -12.541 -22.767   2.759  1.00  0.00           C  
ATOM    303  H   ALA A  20     -10.197 -22.453   3.895  1.00  0.00           H  
ATOM    304  HA  ALA A  20     -12.613 -24.053   4.476  1.00  0.00           H  
ATOM    305  HB1 ALA A  20     -12.163 -21.776   2.967  1.00  0.00           H  
ATOM    306  HB2 ALA A  20     -12.301 -23.036   1.741  1.00  0.00           H  
ATOM    307  HB3 ALA A  20     -13.613 -22.779   2.891  1.00  0.00           H  
ATOM    308  N   GLY A  21     -10.222 -25.397   3.050  1.00  0.00           N  
ATOM    309  CA  GLY A  21      -9.742 -26.601   2.317  1.00  0.00           C  
ATOM    310  C   GLY A  21     -10.200 -26.527   0.860  1.00  0.00           C  
ATOM    311  O   GLY A  21     -10.440 -27.533   0.223  1.00  0.00           O  
ATOM    312  H   GLY A  21      -9.605 -24.891   3.617  1.00  0.00           H  
ATOM    313  HA2 GLY A  21      -8.662 -26.639   2.356  1.00  0.00           H  
ATOM    314  HA3 GLY A  21     -10.150 -27.489   2.775  1.00  0.00           H  
ATOM    315  N   ASP A  22     -10.325 -25.342   0.330  1.00  0.00           N  
ATOM    316  CA  ASP A  22     -10.769 -25.203  -1.084  1.00  0.00           C  
ATOM    317  C   ASP A  22      -9.551 -25.032  -1.994  1.00  0.00           C  
ATOM    318  O   ASP A  22      -9.126 -23.930  -2.276  1.00  0.00           O  
ATOM    319  CB  ASP A  22     -11.673 -23.983  -1.211  1.00  0.00           C  
ATOM    320  CG  ASP A  22     -12.648 -24.188  -2.372  1.00  0.00           C  
ATOM    321  OD1 ASP A  22     -12.743 -25.306  -2.849  1.00  0.00           O  
ATOM    322  OD2 ASP A  22     -13.282 -23.222  -2.764  1.00  0.00           O  
ATOM    323  H   ASP A  22     -10.128 -24.543   0.862  1.00  0.00           H  
ATOM    324  HA  ASP A  22     -11.315 -26.078  -1.379  1.00  0.00           H  
ATOM    325  HB2 ASP A  22     -12.226 -23.846  -0.293  1.00  0.00           H  
ATOM    326  HB3 ASP A  22     -11.068 -23.120  -1.400  1.00  0.00           H  
ATOM    327  N   LEU A  23      -8.988 -26.114  -2.461  1.00  0.00           N  
ATOM    328  CA  LEU A  23      -7.810 -26.021  -3.349  1.00  0.00           C  
ATOM    329  C   LEU A  23      -8.108 -25.067  -4.508  1.00  0.00           C  
ATOM    330  O   LEU A  23      -7.212 -24.554  -5.147  1.00  0.00           O  
ATOM    331  CB  LEU A  23      -7.512 -27.408  -3.891  1.00  0.00           C  
ATOM    332  CG  LEU A  23      -6.506 -28.101  -2.977  1.00  0.00           C  
ATOM    333  CD1 LEU A  23      -5.264 -27.225  -2.803  1.00  0.00           C  
ATOM    334  CD2 LEU A  23      -7.147 -28.353  -1.611  1.00  0.00           C  
ATOM    335  H   LEU A  23      -9.339 -26.994  -2.230  1.00  0.00           H  
ATOM    336  HA  LEU A  23      -6.961 -25.669  -2.790  1.00  0.00           H  
ATOM    337  HB2 LEU A  23      -8.426 -27.984  -3.924  1.00  0.00           H  
ATOM    338  HB3 LEU A  23      -7.106 -27.326  -4.878  1.00  0.00           H  
ATOM    339  HG  LEU A  23      -6.218 -29.034  -3.416  1.00  0.00           H  
ATOM    340 HD11 LEU A  23      -5.358 -26.339  -3.410  1.00  0.00           H  
ATOM    341 HD12 LEU A  23      -5.165 -26.943  -1.765  1.00  0.00           H  
ATOM    342 HD13 LEU A  23      -4.390 -27.779  -3.110  1.00  0.00           H  
ATOM    343 HD21 LEU A  23      -7.636 -27.452  -1.271  1.00  0.00           H  
ATOM    344 HD22 LEU A  23      -7.875 -29.147  -1.697  1.00  0.00           H  
ATOM    345 HD23 LEU A  23      -6.385 -28.639  -0.902  1.00  0.00           H  
ATOM    346  N   ASP A  24      -9.362 -24.826  -4.785  1.00  0.00           N  
ATOM    347  CA  ASP A  24      -9.714 -23.907  -5.902  1.00  0.00           C  
ATOM    348  C   ASP A  24      -9.212 -22.502  -5.578  1.00  0.00           C  
ATOM    349  O   ASP A  24      -8.462 -21.912  -6.330  1.00  0.00           O  
ATOM    350  CB  ASP A  24     -11.234 -23.879  -6.082  1.00  0.00           C  
ATOM    351  CG  ASP A  24     -11.674 -25.094  -6.900  1.00  0.00           C  
ATOM    352  OD1 ASP A  24     -11.374 -26.203  -6.488  1.00  0.00           O  
ATOM    353  OD2 ASP A  24     -12.306 -24.896  -7.926  1.00  0.00           O  
ATOM    354  H   ASP A  24     -10.071 -25.249  -4.258  1.00  0.00           H  
ATOM    355  HA  ASP A  24      -9.250 -24.254  -6.814  1.00  0.00           H  
ATOM    356  HB2 ASP A  24     -11.711 -23.905  -5.113  1.00  0.00           H  
ATOM    357  HB3 ASP A  24     -11.518 -22.976  -6.601  1.00  0.00           H  
ATOM    358  N   GLY A  25      -9.615 -21.959  -4.462  1.00  0.00           N  
ATOM    359  CA  GLY A  25      -9.153 -20.591  -4.097  1.00  0.00           C  
ATOM    360  C   GLY A  25      -7.631 -20.577  -4.029  1.00  0.00           C  
ATOM    361  O   GLY A  25      -6.992 -19.576  -4.287  1.00  0.00           O  
ATOM    362  H   GLY A  25     -10.218 -22.450  -3.867  1.00  0.00           H  
ATOM    363  HA2 GLY A  25      -9.482 -19.898  -4.846  1.00  0.00           H  
ATOM    364  HA3 GLY A  25      -9.559 -20.311  -3.140  1.00  0.00           H  
ATOM    365  N   ILE A  26      -7.049 -21.689  -3.699  1.00  0.00           N  
ATOM    366  CA  ILE A  26      -5.564 -21.763  -3.629  1.00  0.00           C  
ATOM    367  C   ILE A  26      -5.011 -21.652  -5.045  1.00  0.00           C  
ATOM    368  O   ILE A  26      -4.312 -20.716  -5.379  1.00  0.00           O  
ATOM    369  CB  ILE A  26      -5.149 -23.098  -3.020  1.00  0.00           C  
ATOM    370  CG1 ILE A  26      -5.874 -23.283  -1.688  1.00  0.00           C  
ATOM    371  CG2 ILE A  26      -3.636 -23.105  -2.792  1.00  0.00           C  
ATOM    372  CD1 ILE A  26      -5.281 -24.478  -0.950  1.00  0.00           C  
ATOM    373  H   ILE A  26      -7.591 -22.480  -3.511  1.00  0.00           H  
ATOM    374  HA  ILE A  26      -5.183 -20.953  -3.023  1.00  0.00           H  
ATOM    375  HB  ILE A  26      -5.417 -23.900  -3.693  1.00  0.00           H  
ATOM    376 HG12 ILE A  26      -5.757 -22.391  -1.087  1.00  0.00           H  
ATOM    377 HG13 ILE A  26      -6.924 -23.460  -1.869  1.00  0.00           H  
ATOM    378 HG21 ILE A  26      -3.231 -22.136  -3.043  1.00  0.00           H  
ATOM    379 HG22 ILE A  26      -3.427 -23.322  -1.755  1.00  0.00           H  
ATOM    380 HG23 ILE A  26      -3.182 -23.858  -3.418  1.00  0.00           H  
ATOM    381 HD11 ILE A  26      -4.628 -25.020  -1.617  1.00  0.00           H  
ATOM    382 HD12 ILE A  26      -4.717 -24.127  -0.098  1.00  0.00           H  
ATOM    383 HD13 ILE A  26      -6.077 -25.125  -0.616  1.00  0.00           H  
ATOM    384  N   VAL A  27      -5.343 -22.589  -5.890  1.00  0.00           N  
ATOM    385  CA  VAL A  27      -4.863 -22.522  -7.289  1.00  0.00           C  
ATOM    386  C   VAL A  27      -5.332 -21.198  -7.883  1.00  0.00           C  
ATOM    387  O   VAL A  27      -4.620 -20.545  -8.621  1.00  0.00           O  
ATOM    388  CB  VAL A  27      -5.458 -23.687  -8.077  1.00  0.00           C  
ATOM    389  CG1 VAL A  27      -4.964 -23.628  -9.517  1.00  0.00           C  
ATOM    390  CG2 VAL A  27      -5.017 -25.006  -7.437  1.00  0.00           C  
ATOM    391  H   VAL A  27      -5.924 -23.324  -5.608  1.00  0.00           H  
ATOM    392  HA  VAL A  27      -3.783 -22.574  -7.312  1.00  0.00           H  
ATOM    393  HB  VAL A  27      -6.536 -23.619  -8.061  1.00  0.00           H  
ATOM    394 HG11 VAL A  27      -3.891 -23.512  -9.523  1.00  0.00           H  
ATOM    395 HG12 VAL A  27      -5.232 -24.541 -10.025  1.00  0.00           H  
ATOM    396 HG13 VAL A  27      -5.421 -22.788 -10.017  1.00  0.00           H  
ATOM    397 HG21 VAL A  27      -5.218 -24.975  -6.375  1.00  0.00           H  
ATOM    398 HG22 VAL A  27      -5.565 -25.822  -7.883  1.00  0.00           H  
ATOM    399 HG23 VAL A  27      -3.960 -25.150  -7.599  1.00  0.00           H  
ATOM    400  N   ALA A  28      -6.523 -20.785  -7.539  1.00  0.00           N  
ATOM    401  CA  ALA A  28      -7.038 -19.489  -8.048  1.00  0.00           C  
ATOM    402  C   ALA A  28      -6.031 -18.410  -7.665  1.00  0.00           C  
ATOM    403  O   ALA A  28      -5.507 -17.700  -8.500  1.00  0.00           O  
ATOM    404  CB  ALA A  28      -8.390 -19.188  -7.395  1.00  0.00           C  
ATOM    405  H   ALA A  28      -7.066 -21.320  -6.925  1.00  0.00           H  
ATOM    406  HA  ALA A  28      -7.145 -19.529  -9.122  1.00  0.00           H  
ATOM    407  HB1 ALA A  28      -8.308 -19.307  -6.324  1.00  0.00           H  
ATOM    408  HB2 ALA A  28      -8.682 -18.174  -7.622  1.00  0.00           H  
ATOM    409  HB3 ALA A  28      -9.134 -19.872  -7.777  1.00  0.00           H  
ATOM    410  N   LEU A  29      -5.738 -18.307  -6.399  1.00  0.00           N  
ATOM    411  CA  LEU A  29      -4.744 -17.306  -5.938  1.00  0.00           C  
ATOM    412  C   LEU A  29      -3.412 -17.590  -6.632  1.00  0.00           C  
ATOM    413  O   LEU A  29      -2.564 -16.729  -6.761  1.00  0.00           O  
ATOM    414  CB  LEU A  29      -4.574 -17.436  -4.425  1.00  0.00           C  
ATOM    415  CG  LEU A  29      -4.237 -16.068  -3.841  1.00  0.00           C  
ATOM    416  CD1 LEU A  29      -5.455 -15.152  -3.967  1.00  0.00           C  
ATOM    417  CD2 LEU A  29      -3.872 -16.224  -2.368  1.00  0.00           C  
ATOM    418  H   LEU A  29      -6.162 -18.906  -5.749  1.00  0.00           H  
ATOM    419  HA  LEU A  29      -5.082 -16.311  -6.183  1.00  0.00           H  
ATOM    420  HB2 LEU A  29      -5.495 -17.797  -3.990  1.00  0.00           H  
ATOM    421  HB3 LEU A  29      -3.777 -18.130  -4.207  1.00  0.00           H  
ATOM    422  HG  LEU A  29      -3.404 -15.638  -4.379  1.00  0.00           H  
ATOM    423 HD11 LEU A  29      -6.306 -15.622  -3.498  1.00  0.00           H  
ATOM    424 HD12 LEU A  29      -5.249 -14.211  -3.480  1.00  0.00           H  
ATOM    425 HD13 LEU A  29      -5.669 -14.980  -5.012  1.00  0.00           H  
ATOM    426 HD21 LEU A  29      -3.247 -17.096  -2.243  1.00  0.00           H  
ATOM    427 HD22 LEU A  29      -3.340 -15.347  -2.034  1.00  0.00           H  
ATOM    428 HD23 LEU A  29      -4.774 -16.342  -1.789  1.00  0.00           H  
ATOM    429  N   PHE A  30      -3.229 -18.803  -7.075  1.00  0.00           N  
ATOM    430  CA  PHE A  30      -1.975 -19.184  -7.758  1.00  0.00           C  
ATOM    431  C   PHE A  30      -2.100 -18.904  -9.258  1.00  0.00           C  
ATOM    432  O   PHE A  30      -3.106 -19.199  -9.871  1.00  0.00           O  
ATOM    433  CB  PHE A  30      -1.765 -20.677  -7.536  1.00  0.00           C  
ATOM    434  CG  PHE A  30      -1.485 -20.961  -6.074  1.00  0.00           C  
ATOM    435  CD1 PHE A  30      -1.186 -19.916  -5.187  1.00  0.00           C  
ATOM    436  CD2 PHE A  30      -1.528 -22.280  -5.605  1.00  0.00           C  
ATOM    437  CE1 PHE A  30      -0.931 -20.192  -3.839  1.00  0.00           C  
ATOM    438  CE2 PHE A  30      -1.274 -22.554  -4.256  1.00  0.00           C  
ATOM    439  CZ  PHE A  30      -0.975 -21.511  -3.374  1.00  0.00           C  
ATOM    440  H   PHE A  30      -3.923 -19.478  -6.955  1.00  0.00           H  
ATOM    441  HA  PHE A  30      -1.145 -18.631  -7.349  1.00  0.00           H  
ATOM    442  HB2 PHE A  30      -2.654 -21.207  -7.838  1.00  0.00           H  
ATOM    443  HB3 PHE A  30      -0.942 -21.008  -8.129  1.00  0.00           H  
ATOM    444  HD1 PHE A  30      -1.152 -18.897  -5.543  1.00  0.00           H  
ATOM    445  HD2 PHE A  30      -1.759 -23.086  -6.285  1.00  0.00           H  
ATOM    446  HE1 PHE A  30      -0.700 -19.386  -3.157  1.00  0.00           H  
ATOM    447  HE2 PHE A  30      -1.307 -23.572  -3.897  1.00  0.00           H  
ATOM    448  HZ  PHE A  30      -0.778 -21.723  -2.334  1.00  0.00           H  
ATOM    449  N   ALA A  31      -1.084 -18.344  -9.856  1.00  0.00           N  
ATOM    450  CA  ALA A  31      -1.151 -18.056 -11.317  1.00  0.00           C  
ATOM    451  C   ALA A  31      -1.580 -19.324 -12.063  1.00  0.00           C  
ATOM    452  O   ALA A  31      -1.842 -20.347 -11.464  1.00  0.00           O  
ATOM    453  CB  ALA A  31       0.227 -17.612 -11.815  1.00  0.00           C  
ATOM    454  H   ALA A  31      -0.280 -18.115  -9.347  1.00  0.00           H  
ATOM    455  HA  ALA A  31      -1.870 -17.271 -11.498  1.00  0.00           H  
ATOM    456  HB1 ALA A  31       0.954 -17.743 -11.027  1.00  0.00           H  
ATOM    457  HB2 ALA A  31       0.510 -18.210 -12.669  1.00  0.00           H  
ATOM    458  HB3 ALA A  31       0.188 -16.572 -12.101  1.00  0.00           H  
ATOM    459  N   ASP A  32      -1.653 -19.264 -13.364  1.00  0.00           N  
ATOM    460  CA  ASP A  32      -2.065 -20.466 -14.144  1.00  0.00           C  
ATOM    461  C   ASP A  32      -1.003 -21.551 -14.007  1.00  0.00           C  
ATOM    462  O   ASP A  32      -1.266 -22.726 -14.174  1.00  0.00           O  
ATOM    463  CB  ASP A  32      -2.215 -20.090 -15.613  1.00  0.00           C  
ATOM    464  CG  ASP A  32      -3.675 -20.250 -16.038  1.00  0.00           C  
ATOM    465  OD1 ASP A  32      -4.427 -19.303 -15.876  1.00  0.00           O  
ATOM    466  OD2 ASP A  32      -4.018 -21.317 -16.520  1.00  0.00           O  
ATOM    467  H   ASP A  32      -1.438 -18.428 -13.829  1.00  0.00           H  
ATOM    468  HA  ASP A  32      -3.001 -20.831 -13.770  1.00  0.00           H  
ATOM    469  HB2 ASP A  32      -1.908 -19.065 -15.748  1.00  0.00           H  
ATOM    470  HB3 ASP A  32      -1.593 -20.735 -16.213  1.00  0.00           H  
ATOM    471  N   ASP A  33       0.193 -21.157 -13.704  1.00  0.00           N  
ATOM    472  CA  ASP A  33       1.296 -22.138 -13.549  1.00  0.00           C  
ATOM    473  C   ASP A  33       2.282 -21.620 -12.502  1.00  0.00           C  
ATOM    474  O   ASP A  33       3.482 -21.646 -12.695  1.00  0.00           O  
ATOM    475  CB  ASP A  33       2.017 -22.309 -14.888  1.00  0.00           C  
ATOM    476  CG  ASP A  33       2.570 -20.958 -15.344  1.00  0.00           C  
ATOM    477  OD1 ASP A  33       1.992 -19.948 -14.976  1.00  0.00           O  
ATOM    478  OD2 ASP A  33       3.562 -20.956 -16.053  1.00  0.00           O  
ATOM    479  H   ASP A  33       0.364 -20.209 -13.579  1.00  0.00           H  
ATOM    480  HA  ASP A  33       0.893 -23.082 -13.230  1.00  0.00           H  
ATOM    481  HB2 ASP A  33       2.830 -23.012 -14.771  1.00  0.00           H  
ATOM    482  HB3 ASP A  33       1.322 -22.680 -15.626  1.00  0.00           H  
ATOM    483  N   ALA A  34       1.784 -21.141 -11.396  1.00  0.00           N  
ATOM    484  CA  ALA A  34       2.687 -20.610 -10.337  1.00  0.00           C  
ATOM    485  C   ALA A  34       3.766 -21.646 -10.009  1.00  0.00           C  
ATOM    486  O   ALA A  34       3.823 -22.707 -10.597  1.00  0.00           O  
ATOM    487  CB  ALA A  34       1.874 -20.302  -9.078  1.00  0.00           C  
ATOM    488  H   ALA A  34       0.813 -21.124 -11.264  1.00  0.00           H  
ATOM    489  HA  ALA A  34       3.155 -19.705 -10.693  1.00  0.00           H  
ATOM    490  HB1 ALA A  34       0.889 -20.736  -9.172  1.00  0.00           H  
ATOM    491  HB2 ALA A  34       2.371 -20.722  -8.216  1.00  0.00           H  
ATOM    492  HB3 ALA A  34       1.788 -19.233  -8.959  1.00  0.00           H  
ATOM    493  N   THR A  35       4.624 -21.340  -9.072  1.00  0.00           N  
ATOM    494  CA  THR A  35       5.702 -22.300  -8.703  1.00  0.00           C  
ATOM    495  C   THR A  35       5.659 -22.561  -7.195  1.00  0.00           C  
ATOM    496  O   THR A  35       5.515 -21.653  -6.401  1.00  0.00           O  
ATOM    497  CB  THR A  35       7.063 -21.706  -9.076  1.00  0.00           C  
ATOM    498  OG1 THR A  35       6.943 -20.295  -9.199  1.00  0.00           O  
ATOM    499  CG2 THR A  35       7.534 -22.297 -10.406  1.00  0.00           C  
ATOM    500  H   THR A  35       4.559 -20.477  -8.612  1.00  0.00           H  
ATOM    501  HA  THR A  35       5.556 -23.228  -9.234  1.00  0.00           H  
ATOM    502  HB  THR A  35       7.783 -21.941  -8.308  1.00  0.00           H  
ATOM    503  HG1 THR A  35       7.735 -19.965  -9.629  1.00  0.00           H  
ATOM    504 HG21 THR A  35       6.695 -22.375 -11.082  1.00  0.00           H  
ATOM    505 HG22 THR A  35       8.286 -21.654 -10.840  1.00  0.00           H  
ATOM    506 HG23 THR A  35       7.952 -23.278 -10.237  1.00  0.00           H  
ATOM    507  N   VAL A  36       5.783 -23.796  -6.797  1.00  0.00           N  
ATOM    508  CA  VAL A  36       5.750 -24.123  -5.343  1.00  0.00           C  
ATOM    509  C   VAL A  36       7.126 -24.648  -4.914  1.00  0.00           C  
ATOM    510  O   VAL A  36       7.969 -24.939  -5.733  1.00  0.00           O  
ATOM    511  CB  VAL A  36       4.669 -25.187  -5.093  1.00  0.00           C  
ATOM    512  CG1 VAL A  36       4.929 -25.916  -3.773  1.00  0.00           C  
ATOM    513  CG2 VAL A  36       3.299 -24.508  -5.029  1.00  0.00           C  
ATOM    514  H   VAL A  36       5.898 -24.513  -7.455  1.00  0.00           H  
ATOM    515  HA  VAL A  36       5.514 -23.231  -4.779  1.00  0.00           H  
ATOM    516  HB  VAL A  36       4.677 -25.901  -5.904  1.00  0.00           H  
ATOM    517 HG11 VAL A  36       5.894 -26.399  -3.812  1.00  0.00           H  
ATOM    518 HG12 VAL A  36       4.914 -25.206  -2.960  1.00  0.00           H  
ATOM    519 HG13 VAL A  36       4.161 -26.659  -3.615  1.00  0.00           H  
ATOM    520 HG21 VAL A  36       3.253 -23.719  -5.765  1.00  0.00           H  
ATOM    521 HG22 VAL A  36       2.527 -25.236  -5.232  1.00  0.00           H  
ATOM    522 HG23 VAL A  36       3.150 -24.091  -4.044  1.00  0.00           H  
ATOM    523  N   GLU A  37       7.349 -24.776  -3.636  1.00  0.00           N  
ATOM    524  CA  GLU A  37       8.653 -25.291  -3.139  1.00  0.00           C  
ATOM    525  C   GLU A  37       8.380 -26.001  -1.822  1.00  0.00           C  
ATOM    526  O   GLU A  37       8.104 -25.373  -0.820  1.00  0.00           O  
ATOM    527  CB  GLU A  37       9.626 -24.132  -2.913  1.00  0.00           C  
ATOM    528  CG  GLU A  37       9.847 -23.384  -4.230  1.00  0.00           C  
ATOM    529  CD  GLU A  37      11.245 -22.759  -4.233  1.00  0.00           C  
ATOM    530  OE1 GLU A  37      11.842 -22.689  -3.172  1.00  0.00           O  
ATOM    531  OE2 GLU A  37      11.693 -22.363  -5.297  1.00  0.00           O  
ATOM    532  H   GLU A  37       6.646 -24.547  -2.990  1.00  0.00           H  
ATOM    533  HA  GLU A  37       9.069 -25.989  -3.850  1.00  0.00           H  
ATOM    534  HB2 GLU A  37       9.217 -23.456  -2.178  1.00  0.00           H  
ATOM    535  HB3 GLU A  37      10.570 -24.518  -2.560  1.00  0.00           H  
ATOM    536  HG2 GLU A  37       9.759 -24.075  -5.056  1.00  0.00           H  
ATOM    537  HG3 GLU A  37       9.107 -22.604  -4.331  1.00  0.00           H  
ATOM    538  N   ASP A  38       8.414 -27.300  -1.810  1.00  0.00           N  
ATOM    539  CA  ASP A  38       8.104 -28.009  -0.539  1.00  0.00           C  
ATOM    540  C   ASP A  38       8.336 -29.514  -0.714  1.00  0.00           C  
ATOM    541  O   ASP A  38       8.243 -30.020  -1.812  1.00  0.00           O  
ATOM    542  CB  ASP A  38       6.635 -27.743  -0.196  1.00  0.00           C  
ATOM    543  CG  ASP A  38       6.538 -26.747   0.964  1.00  0.00           C  
ATOM    544  OD1 ASP A  38       7.197 -26.964   1.968  1.00  0.00           O  
ATOM    545  OD2 ASP A  38       5.800 -25.785   0.830  1.00  0.00           O  
ATOM    546  H   ASP A  38       8.615 -27.806  -2.636  1.00  0.00           H  
ATOM    547  HA  ASP A  38       8.732 -27.627   0.248  1.00  0.00           H  
ATOM    548  HB2 ASP A  38       6.139 -27.329  -1.062  1.00  0.00           H  
ATOM    549  HB3 ASP A  38       6.158 -28.663   0.078  1.00  0.00           H  
ATOM    550  N   PRO A  39       8.629 -30.192   0.372  1.00  0.00           N  
ATOM    551  CA  PRO A  39       8.725 -29.537   1.706  1.00  0.00           C  
ATOM    552  C   PRO A  39      10.008 -28.704   1.833  1.00  0.00           C  
ATOM    553  O   PRO A  39       9.961 -27.494   1.934  1.00  0.00           O  
ATOM    554  CB  PRO A  39       8.742 -30.713   2.680  1.00  0.00           C  
ATOM    555  CG  PRO A  39       9.261 -31.872   1.890  1.00  0.00           C  
ATOM    556  CD  PRO A  39       8.895 -31.633   0.447  1.00  0.00           C  
ATOM    557  HA  PRO A  39       7.859 -28.927   1.889  1.00  0.00           H  
ATOM    558  HB2 PRO A  39       9.399 -30.499   3.512  1.00  0.00           H  
ATOM    559  HB3 PRO A  39       7.745 -30.923   3.031  1.00  0.00           H  
ATOM    560  HG2 PRO A  39      10.334 -31.940   1.995  1.00  0.00           H  
ATOM    561  HG3 PRO A  39       8.800 -32.786   2.232  1.00  0.00           H  
ATOM    562  HD2 PRO A  39       9.720 -31.902  -0.200  1.00  0.00           H  
ATOM    563  HD3 PRO A  39       8.009 -32.188   0.183  1.00  0.00           H  
ATOM    564  N   VAL A  40      11.150 -29.333   1.837  1.00  0.00           N  
ATOM    565  CA  VAL A  40      12.419 -28.562   1.965  1.00  0.00           C  
ATOM    566  C   VAL A  40      13.584 -29.399   1.435  1.00  0.00           C  
ATOM    567  O   VAL A  40      14.238 -30.108   2.173  1.00  0.00           O  
ATOM    568  CB  VAL A  40      12.662 -28.218   3.437  1.00  0.00           C  
ATOM    569  CG1 VAL A  40      11.587 -27.242   3.917  1.00  0.00           C  
ATOM    570  CG2 VAL A  40      12.598 -29.498   4.274  1.00  0.00           C  
ATOM    571  H   VAL A  40      11.175 -30.309   1.760  1.00  0.00           H  
ATOM    572  HA  VAL A  40      12.343 -27.649   1.392  1.00  0.00           H  
ATOM    573  HB  VAL A  40      13.636 -27.763   3.546  1.00  0.00           H  
ATOM    574 HG11 VAL A  40      11.381 -26.522   3.139  1.00  0.00           H  
ATOM    575 HG12 VAL A  40      10.685 -27.786   4.153  1.00  0.00           H  
ATOM    576 HG13 VAL A  40      11.938 -26.727   4.800  1.00  0.00           H  
ATOM    577 HG21 VAL A  40      12.643 -30.357   3.622  1.00  0.00           H  
ATOM    578 HG22 VAL A  40      13.432 -29.522   4.960  1.00  0.00           H  
ATOM    579 HG23 VAL A  40      11.673 -29.518   4.832  1.00  0.00           H  
ATOM    580  N   GLY A  41      13.848 -29.321   0.160  1.00  0.00           N  
ATOM    581  CA  GLY A  41      14.970 -30.111  -0.419  1.00  0.00           C  
ATOM    582  C   GLY A  41      14.831 -30.157  -1.943  1.00  0.00           C  
ATOM    583  O   GLY A  41      15.094 -31.164  -2.570  1.00  0.00           O  
ATOM    584  H   GLY A  41      13.308 -28.743  -0.418  1.00  0.00           H  
ATOM    585  HA2 GLY A  41      15.910 -29.644  -0.156  1.00  0.00           H  
ATOM    586  HA3 GLY A  41      14.946 -31.115  -0.026  1.00  0.00           H  
ATOM    587  N   SER A  42      14.421 -29.072  -2.542  1.00  0.00           N  
ATOM    588  CA  SER A  42      14.269 -29.046  -4.026  1.00  0.00           C  
ATOM    589  C   SER A  42      13.040 -29.861  -4.440  1.00  0.00           C  
ATOM    590  O   SER A  42      13.131 -30.778  -5.231  1.00  0.00           O  
ATOM    591  CB  SER A  42      15.518 -29.638  -4.678  1.00  0.00           C  
ATOM    592  OG  SER A  42      16.167 -28.634  -5.448  1.00  0.00           O  
ATOM    593  H   SER A  42      14.219 -28.271  -2.017  1.00  0.00           H  
ATOM    594  HA  SER A  42      14.147 -28.026  -4.355  1.00  0.00           H  
ATOM    595  HB2 SER A  42      16.193 -29.992  -3.918  1.00  0.00           H  
ATOM    596  HB3 SER A  42      15.231 -30.464  -5.314  1.00  0.00           H  
ATOM    597  HG  SER A  42      17.082 -28.898  -5.570  1.00  0.00           H  
ATOM    598  N   GLU A  43      11.891 -29.535  -3.911  1.00  0.00           N  
ATOM    599  CA  GLU A  43      10.661 -30.292  -4.280  1.00  0.00           C  
ATOM    600  C   GLU A  43       9.528 -29.313  -4.615  1.00  0.00           C  
ATOM    601  O   GLU A  43       8.478 -29.335  -4.008  1.00  0.00           O  
ATOM    602  CB  GLU A  43      10.258 -31.182  -3.106  1.00  0.00           C  
ATOM    603  CG  GLU A  43      11.333 -32.246  -2.894  1.00  0.00           C  
ATOM    604  CD  GLU A  43      10.678 -33.621  -2.754  1.00  0.00           C  
ATOM    605  OE1 GLU A  43       9.511 -33.737  -3.091  1.00  0.00           O  
ATOM    606  OE2 GLU A  43      11.354 -34.535  -2.312  1.00  0.00           O  
ATOM    607  H   GLU A  43      11.836 -28.796  -3.274  1.00  0.00           H  
ATOM    608  HA  GLU A  43      10.869 -30.905  -5.143  1.00  0.00           H  
ATOM    609  HB2 GLU A  43      10.173 -30.579  -2.215  1.00  0.00           H  
ATOM    610  HB3 GLU A  43       9.314 -31.658  -3.316  1.00  0.00           H  
ATOM    611  HG2 GLU A  43      12.005 -32.249  -3.740  1.00  0.00           H  
ATOM    612  HG3 GLU A  43      11.887 -32.019  -1.996  1.00  0.00           H  
ATOM    613  N   PRO A  44       9.796 -28.487  -5.586  1.00  0.00           N  
ATOM    614  CA  PRO A  44       8.816 -27.474  -6.043  1.00  0.00           C  
ATOM    615  C   PRO A  44       7.762 -28.096  -6.966  1.00  0.00           C  
ATOM    616  O   PRO A  44       7.838 -29.254  -7.327  1.00  0.00           O  
ATOM    617  CB  PRO A  44       9.675 -26.480  -6.818  1.00  0.00           C  
ATOM    618  CG  PRO A  44      10.868 -27.259  -7.279  1.00  0.00           C  
ATOM    619  CD  PRO A  44      11.042 -28.428  -6.341  1.00  0.00           C  
ATOM    620  HA  PRO A  44       8.349 -26.984  -5.206  1.00  0.00           H  
ATOM    621  HB2 PRO A  44       9.127 -26.093  -7.665  1.00  0.00           H  
ATOM    622  HB3 PRO A  44       9.989 -25.673  -6.174  1.00  0.00           H  
ATOM    623  HG2 PRO A  44      10.706 -27.615  -8.286  1.00  0.00           H  
ATOM    624  HG3 PRO A  44      11.748 -26.635  -7.246  1.00  0.00           H  
ATOM    625  HD2 PRO A  44      11.181 -29.339  -6.894  1.00  0.00           H  
ATOM    626  HD3 PRO A  44      11.870 -28.260  -5.674  1.00  0.00           H  
ATOM    627  N   ARG A  45       6.784 -27.322  -7.355  1.00  0.00           N  
ATOM    628  CA  ARG A  45       5.720 -27.837  -8.262  1.00  0.00           C  
ATOM    629  C   ARG A  45       5.184 -26.672  -9.099  1.00  0.00           C  
ATOM    630  O   ARG A  45       4.388 -25.880  -8.636  1.00  0.00           O  
ATOM    631  CB  ARG A  45       4.585 -28.441  -7.434  1.00  0.00           C  
ATOM    632  CG  ARG A  45       4.834 -29.938  -7.240  1.00  0.00           C  
ATOM    633  CD  ARG A  45       4.741 -30.652  -8.590  1.00  0.00           C  
ATOM    634  NE  ARG A  45       5.759 -31.738  -8.650  1.00  0.00           N  
ATOM    635  CZ  ARG A  45       5.547 -32.790  -9.392  1.00  0.00           C  
ATOM    636  NH1 ARG A  45       5.472 -32.669 -10.689  1.00  0.00           N  
ATOM    637  NH2 ARG A  45       5.410 -33.964  -8.837  1.00  0.00           N  
ATOM    638  H   ARG A  45       6.754 -26.390  -7.055  1.00  0.00           H  
ATOM    639  HA  ARG A  45       6.136 -28.591  -8.916  1.00  0.00           H  
ATOM    640  HB2 ARG A  45       4.544 -27.953  -6.470  1.00  0.00           H  
ATOM    641  HB3 ARG A  45       3.647 -28.298  -7.951  1.00  0.00           H  
ATOM    642  HG2 ARG A  45       5.818 -30.088  -6.821  1.00  0.00           H  
ATOM    643  HG3 ARG A  45       4.092 -30.343  -6.570  1.00  0.00           H  
ATOM    644  HD2 ARG A  45       3.755 -31.077  -8.705  1.00  0.00           H  
ATOM    645  HD3 ARG A  45       4.922 -29.943  -9.385  1.00  0.00           H  
ATOM    646  HE  ARG A  45       6.588 -31.662  -8.133  1.00  0.00           H  
ATOM    647 HH11 ARG A  45       5.576 -31.769 -11.114  1.00  0.00           H  
ATOM    648 HH12 ARG A  45       5.310 -33.475 -11.259  1.00  0.00           H  
ATOM    649 HH21 ARG A  45       5.466 -34.056  -7.844  1.00  0.00           H  
ATOM    650 HH22 ARG A  45       5.248 -34.769  -9.405  1.00  0.00           H  
ATOM    651  N   SER A  46       5.624 -26.551 -10.319  1.00  0.00           N  
ATOM    652  CA  SER A  46       5.153 -25.429 -11.174  1.00  0.00           C  
ATOM    653  C   SER A  46       3.892 -25.843 -11.939  1.00  0.00           C  
ATOM    654  O   SER A  46       3.542 -27.004 -11.999  1.00  0.00           O  
ATOM    655  CB  SER A  46       6.264 -25.065 -12.155  1.00  0.00           C  
ATOM    656  OG  SER A  46       5.760 -25.084 -13.486  1.00  0.00           O  
ATOM    657  H   SER A  46       6.276 -27.191 -10.672  1.00  0.00           H  
ATOM    658  HA  SER A  46       4.935 -24.575 -10.554  1.00  0.00           H  
ATOM    659  HB2 SER A  46       6.634 -24.083 -11.930  1.00  0.00           H  
ATOM    660  HB3 SER A  46       7.069 -25.778 -12.052  1.00  0.00           H  
ATOM    661  HG  SER A  46       6.508 -25.127 -14.086  1.00  0.00           H  
ATOM    662  N   GLY A  47       3.208 -24.894 -12.521  1.00  0.00           N  
ATOM    663  CA  GLY A  47       1.968 -25.223 -13.282  1.00  0.00           C  
ATOM    664  C   GLY A  47       0.774 -25.251 -12.325  1.00  0.00           C  
ATOM    665  O   GLY A  47       0.875 -24.854 -11.182  1.00  0.00           O  
ATOM    666  H   GLY A  47       3.510 -23.964 -12.458  1.00  0.00           H  
ATOM    667  HA2 GLY A  47       1.804 -24.475 -14.043  1.00  0.00           H  
ATOM    668  HA3 GLY A  47       2.075 -26.189 -13.746  1.00  0.00           H  
ATOM    669  N   THR A  48      -0.354 -25.720 -12.781  1.00  0.00           N  
ATOM    670  CA  THR A  48      -1.547 -25.777 -11.897  1.00  0.00           C  
ATOM    671  C   THR A  48      -1.757 -27.222 -11.436  1.00  0.00           C  
ATOM    672  O   THR A  48      -1.972 -27.489 -10.271  1.00  0.00           O  
ATOM    673  CB  THR A  48      -2.773 -25.295 -12.678  1.00  0.00           C  
ATOM    674  OG1 THR A  48      -2.741 -23.877 -12.778  1.00  0.00           O  
ATOM    675  CG2 THR A  48      -4.049 -25.725 -11.956  1.00  0.00           C  
ATOM    676  H   THR A  48      -0.417 -26.038 -13.704  1.00  0.00           H  
ATOM    677  HA  THR A  48      -1.391 -25.143 -11.037  1.00  0.00           H  
ATOM    678  HB  THR A  48      -2.763 -25.726 -13.667  1.00  0.00           H  
ATOM    679  HG1 THR A  48      -2.941 -23.513 -11.912  1.00  0.00           H  
ATOM    680 HG21 THR A  48      -3.826 -25.912 -10.916  1.00  0.00           H  
ATOM    681 HG22 THR A  48      -4.787 -24.942 -12.033  1.00  0.00           H  
ATOM    682 HG23 THR A  48      -4.430 -26.627 -12.411  1.00  0.00           H  
ATOM    683  N   ALA A  49      -1.691 -28.157 -12.344  1.00  0.00           N  
ATOM    684  CA  ALA A  49      -1.882 -29.584 -11.959  1.00  0.00           C  
ATOM    685  C   ALA A  49      -0.840 -29.966 -10.907  1.00  0.00           C  
ATOM    686  O   ALA A  49      -1.029 -30.886 -10.137  1.00  0.00           O  
ATOM    687  CB  ALA A  49      -1.713 -30.472 -13.193  1.00  0.00           C  
ATOM    688  H   ALA A  49      -1.514 -27.922 -13.279  1.00  0.00           H  
ATOM    689  HA  ALA A  49      -2.873 -29.717 -11.551  1.00  0.00           H  
ATOM    690  HB1 ALA A  49      -1.684 -29.856 -14.079  1.00  0.00           H  
ATOM    691  HB2 ALA A  49      -0.791 -31.029 -13.111  1.00  0.00           H  
ATOM    692  HB3 ALA A  49      -2.543 -31.159 -13.259  1.00  0.00           H  
ATOM    693  N   ALA A  50       0.260 -29.265 -10.866  1.00  0.00           N  
ATOM    694  CA  ALA A  50       1.313 -29.586  -9.863  1.00  0.00           C  
ATOM    695  C   ALA A  50       1.056 -28.787  -8.583  1.00  0.00           C  
ATOM    696  O   ALA A  50       0.994 -29.334  -7.500  1.00  0.00           O  
ATOM    697  CB  ALA A  50       2.687 -29.215 -10.427  1.00  0.00           C  
ATOM    698  H   ALA A  50       0.393 -28.525 -11.496  1.00  0.00           H  
ATOM    699  HA  ALA A  50       1.289 -30.642  -9.640  1.00  0.00           H  
ATOM    700  HB1 ALA A  50       2.580 -28.890 -11.452  1.00  0.00           H  
ATOM    701  HB2 ALA A  50       3.114 -28.414  -9.840  1.00  0.00           H  
ATOM    702  HB3 ALA A  50       3.337 -30.075 -10.387  1.00  0.00           H  
ATOM    703  N   ILE A  51       0.902 -27.496  -8.699  1.00  0.00           N  
ATOM    704  CA  ILE A  51       0.645 -26.662  -7.490  1.00  0.00           C  
ATOM    705  C   ILE A  51      -0.609 -27.176  -6.782  1.00  0.00           C  
ATOM    706  O   ILE A  51      -0.623 -27.361  -5.581  1.00  0.00           O  
ATOM    707  CB  ILE A  51       0.439 -25.207  -7.916  1.00  0.00           C  
ATOM    708  CG1 ILE A  51       1.696 -24.707  -8.631  1.00  0.00           C  
ATOM    709  CG2 ILE A  51       0.179 -24.339  -6.684  1.00  0.00           C  
ATOM    710  CD1 ILE A  51       1.452 -23.297  -9.169  1.00  0.00           C  
ATOM    711  H   ILE A  51       0.953 -27.075  -9.582  1.00  0.00           H  
ATOM    712  HA  ILE A  51       1.489 -26.728  -6.820  1.00  0.00           H  
ATOM    713  HB  ILE A  51      -0.407 -25.144  -8.586  1.00  0.00           H  
ATOM    714 HG12 ILE A  51       2.521 -24.690  -7.934  1.00  0.00           H  
ATOM    715 HG13 ILE A  51       1.932 -25.368  -9.450  1.00  0.00           H  
ATOM    716 HG21 ILE A  51       1.008 -24.427  -5.999  1.00  0.00           H  
ATOM    717 HG22 ILE A  51       0.070 -23.307  -6.988  1.00  0.00           H  
ATOM    718 HG23 ILE A  51      -0.728 -24.666  -6.198  1.00  0.00           H  
ATOM    719 HD11 ILE A  51       0.393 -23.083  -9.150  1.00  0.00           H  
ATOM    720 HD12 ILE A  51       1.974 -22.581  -8.552  1.00  0.00           H  
ATOM    721 HD13 ILE A  51       1.814 -23.230 -10.184  1.00  0.00           H  
ATOM    722  N   ARG A  52      -1.658 -27.418  -7.517  1.00  0.00           N  
ATOM    723  CA  ARG A  52      -2.905 -27.931  -6.884  1.00  0.00           C  
ATOM    724  C   ARG A  52      -2.671 -29.369  -6.422  1.00  0.00           C  
ATOM    725  O   ARG A  52      -2.837 -29.692  -5.264  1.00  0.00           O  
ATOM    726  CB  ARG A  52      -4.045 -27.901  -7.905  1.00  0.00           C  
ATOM    727  CG  ARG A  52      -5.372 -28.180  -7.198  1.00  0.00           C  
ATOM    728  CD  ARG A  52      -6.406 -28.649  -8.222  1.00  0.00           C  
ATOM    729  NE  ARG A  52      -6.883 -30.012  -7.858  1.00  0.00           N  
ATOM    730  CZ  ARG A  52      -7.872 -30.555  -8.513  1.00  0.00           C  
ATOM    731  NH1 ARG A  52      -7.862 -30.565  -9.817  1.00  0.00           N  
ATOM    732  NH2 ARG A  52      -8.872 -31.085  -7.864  1.00  0.00           N  
ATOM    733  H   ARG A  52      -1.624 -27.270  -8.485  1.00  0.00           H  
ATOM    734  HA  ARG A  52      -3.161 -27.313  -6.033  1.00  0.00           H  
ATOM    735  HB2 ARG A  52      -4.082 -26.930  -8.374  1.00  0.00           H  
ATOM    736  HB3 ARG A  52      -3.874 -28.658  -8.657  1.00  0.00           H  
ATOM    737  HG2 ARG A  52      -5.227 -28.949  -6.453  1.00  0.00           H  
ATOM    738  HG3 ARG A  52      -5.724 -27.278  -6.721  1.00  0.00           H  
ATOM    739  HD2 ARG A  52      -7.243 -27.965  -8.229  1.00  0.00           H  
ATOM    740  HD3 ARG A  52      -5.955 -28.676  -9.203  1.00  0.00           H  
ATOM    741  HE  ARG A  52      -6.454 -30.502  -7.125  1.00  0.00           H  
ATOM    742 HH11 ARG A  52      -7.095 -30.159 -10.315  1.00  0.00           H  
ATOM    743 HH12 ARG A  52      -8.619 -30.982 -10.320  1.00  0.00           H  
ATOM    744 HH21 ARG A  52      -8.880 -31.075  -6.864  1.00  0.00           H  
ATOM    745 HH22 ARG A  52      -9.630 -31.501  -8.366  1.00  0.00           H  
ATOM    746  N   GLU A  53      -2.276 -30.235  -7.314  1.00  0.00           N  
ATOM    747  CA  GLU A  53      -2.022 -31.647  -6.912  1.00  0.00           C  
ATOM    748  C   GLU A  53      -1.201 -31.647  -5.623  1.00  0.00           C  
ATOM    749  O   GLU A  53      -1.305 -32.540  -4.805  1.00  0.00           O  
ATOM    750  CB  GLU A  53      -1.245 -32.364  -8.017  1.00  0.00           C  
ATOM    751  CG  GLU A  53      -0.930 -33.793  -7.573  1.00  0.00           C  
ATOM    752  CD  GLU A  53       0.277 -34.317  -8.354  1.00  0.00           C  
ATOM    753  OE1 GLU A  53       1.391 -34.061  -7.928  1.00  0.00           O  
ATOM    754  OE2 GLU A  53       0.067 -34.967  -9.365  1.00  0.00           O  
ATOM    755  H   GLU A  53      -2.140 -29.957  -8.244  1.00  0.00           H  
ATOM    756  HA  GLU A  53      -2.963 -32.150  -6.742  1.00  0.00           H  
ATOM    757  HB2 GLU A  53      -1.842 -32.390  -8.917  1.00  0.00           H  
ATOM    758  HB3 GLU A  53      -0.323 -31.836  -8.209  1.00  0.00           H  
ATOM    759  HG2 GLU A  53      -0.707 -33.800  -6.516  1.00  0.00           H  
ATOM    760  HG3 GLU A  53      -1.782 -34.426  -7.766  1.00  0.00           H  
ATOM    761  N   PHE A  54      -0.392 -30.642  -5.434  1.00  0.00           N  
ATOM    762  CA  PHE A  54       0.430 -30.559  -4.203  1.00  0.00           C  
ATOM    763  C   PHE A  54      -0.412 -29.936  -3.097  1.00  0.00           C  
ATOM    764  O   PHE A  54      -0.808 -30.587  -2.151  1.00  0.00           O  
ATOM    765  CB  PHE A  54       1.628 -29.656  -4.476  1.00  0.00           C  
ATOM    766  CG  PHE A  54       2.859 -30.210  -3.794  1.00  0.00           C  
ATOM    767  CD1 PHE A  54       2.728 -31.072  -2.698  1.00  0.00           C  
ATOM    768  CD2 PHE A  54       4.134 -29.861  -4.258  1.00  0.00           C  
ATOM    769  CE1 PHE A  54       3.868 -31.585  -2.067  1.00  0.00           C  
ATOM    770  CE2 PHE A  54       5.274 -30.373  -3.628  1.00  0.00           C  
ATOM    771  CZ  PHE A  54       5.141 -31.235  -2.533  1.00  0.00           C  
ATOM    772  H   PHE A  54      -0.330 -29.929  -6.102  1.00  0.00           H  
ATOM    773  HA  PHE A  54       0.765 -31.542  -3.911  1.00  0.00           H  
ATOM    774  HB2 PHE A  54       1.791 -29.597  -5.537  1.00  0.00           H  
ATOM    775  HB3 PHE A  54       1.421 -28.669  -4.101  1.00  0.00           H  
ATOM    776  HD1 PHE A  54       1.746 -31.343  -2.338  1.00  0.00           H  
ATOM    777  HD2 PHE A  54       4.237 -29.195  -5.102  1.00  0.00           H  
ATOM    778  HE1 PHE A  54       3.765 -32.249  -1.223  1.00  0.00           H  
ATOM    779  HE2 PHE A  54       6.256 -30.103  -3.987  1.00  0.00           H  
ATOM    780  HZ  PHE A  54       6.021 -31.631  -2.047  1.00  0.00           H  
ATOM    781  N   PHE A  55      -0.688 -28.672  -3.225  1.00  0.00           N  
ATOM    782  CA  PHE A  55      -1.511 -27.979  -2.195  1.00  0.00           C  
ATOM    783  C   PHE A  55      -2.734 -28.838  -1.874  1.00  0.00           C  
ATOM    784  O   PHE A  55      -3.261 -28.801  -0.779  1.00  0.00           O  
ATOM    785  CB  PHE A  55      -1.948 -26.610  -2.723  1.00  0.00           C  
ATOM    786  CG  PHE A  55      -1.404 -25.535  -1.809  1.00  0.00           C  
ATOM    787  CD1 PHE A  55      -2.048 -25.245  -0.598  1.00  0.00           C  
ATOM    788  CD2 PHE A  55      -0.245 -24.834  -2.169  1.00  0.00           C  
ATOM    789  CE1 PHE A  55      -1.530 -24.257   0.251  1.00  0.00           C  
ATOM    790  CE2 PHE A  55       0.270 -23.846  -1.320  1.00  0.00           C  
ATOM    791  CZ  PHE A  55      -0.373 -23.561  -0.113  1.00  0.00           C  
ATOM    792  H   PHE A  55      -0.353 -28.179  -4.007  1.00  0.00           H  
ATOM    793  HA  PHE A  55      -0.927 -27.848  -1.298  1.00  0.00           H  
ATOM    794  HB2 PHE A  55      -1.554 -26.470  -3.720  1.00  0.00           H  
ATOM    795  HB3 PHE A  55      -3.025 -26.555  -2.751  1.00  0.00           H  
ATOM    796  HD1 PHE A  55      -2.942 -25.782  -0.317  1.00  0.00           H  
ATOM    797  HD2 PHE A  55       0.251 -25.055  -3.102  1.00  0.00           H  
ATOM    798  HE1 PHE A  55      -2.023 -24.031   1.184  1.00  0.00           H  
ATOM    799  HE2 PHE A  55       1.164 -23.304  -1.598  1.00  0.00           H  
ATOM    800  HZ  PHE A  55       0.025 -22.804   0.541  1.00  0.00           H  
ATOM    801  N   ALA A  56      -3.180 -29.624  -2.814  1.00  0.00           N  
ATOM    802  CA  ALA A  56      -4.356 -30.500  -2.557  1.00  0.00           C  
ATOM    803  C   ALA A  56      -3.905 -31.668  -1.679  1.00  0.00           C  
ATOM    804  O   ALA A  56      -4.493 -31.951  -0.655  1.00  0.00           O  
ATOM    805  CB  ALA A  56      -4.901 -31.034  -3.882  1.00  0.00           C  
ATOM    806  H   ALA A  56      -2.731 -29.648  -3.686  1.00  0.00           H  
ATOM    807  HA  ALA A  56      -5.124 -29.939  -2.045  1.00  0.00           H  
ATOM    808  HB1 ALA A  56      -5.110 -30.207  -4.545  1.00  0.00           H  
ATOM    809  HB2 ALA A  56      -4.169 -31.684  -4.338  1.00  0.00           H  
ATOM    810  HB3 ALA A  56      -5.811 -31.588  -3.700  1.00  0.00           H  
ATOM    811  N   ASN A  57      -2.851 -32.335  -2.065  1.00  0.00           N  
ATOM    812  CA  ASN A  57      -2.348 -33.469  -1.244  1.00  0.00           C  
ATOM    813  C   ASN A  57      -2.091 -32.957   0.172  1.00  0.00           C  
ATOM    814  O   ASN A  57      -2.293 -33.655   1.146  1.00  0.00           O  
ATOM    815  CB  ASN A  57      -1.045 -33.999  -1.844  1.00  0.00           C  
ATOM    816  CG  ASN A  57      -0.755 -35.393  -1.288  1.00  0.00           C  
ATOM    817  OD1 ASN A  57      -0.515 -35.551  -0.107  1.00  0.00           O  
ATOM    818  ND2 ASN A  57      -0.769 -36.419  -2.094  1.00  0.00           N  
ATOM    819  H   ASN A  57      -2.382 -32.081  -2.887  1.00  0.00           H  
ATOM    820  HA  ASN A  57      -3.087 -34.257  -1.218  1.00  0.00           H  
ATOM    821  HB2 ASN A  57      -1.139 -34.051  -2.919  1.00  0.00           H  
ATOM    822  HB3 ASN A  57      -0.233 -33.335  -1.585  1.00  0.00           H  
ATOM    823 HD21 ASN A  57      -0.961 -36.292  -3.046  1.00  0.00           H  
ATOM    824 HD22 ASN A  57      -0.585 -37.318  -1.747  1.00  0.00           H  
ATOM    825  N   SER A  58      -1.660 -31.732   0.290  1.00  0.00           N  
ATOM    826  CA  SER A  58      -1.403 -31.155   1.636  1.00  0.00           C  
ATOM    827  C   SER A  58      -2.731 -31.067   2.388  1.00  0.00           C  
ATOM    828  O   SER A  58      -2.799 -31.277   3.583  1.00  0.00           O  
ATOM    829  CB  SER A  58      -0.813 -29.753   1.482  1.00  0.00           C  
ATOM    830  OG  SER A  58      -0.830 -29.094   2.741  1.00  0.00           O  
ATOM    831  H   SER A  58      -1.516 -31.185  -0.511  1.00  0.00           H  
ATOM    832  HA  SER A  58      -0.716 -31.785   2.179  1.00  0.00           H  
ATOM    833  HB2 SER A  58       0.204 -29.823   1.132  1.00  0.00           H  
ATOM    834  HB3 SER A  58      -1.399 -29.194   0.765  1.00  0.00           H  
ATOM    835  HG  SER A  58      -1.323 -28.276   2.641  1.00  0.00           H  
ATOM    836  N   LEU A  59      -3.787 -30.759   1.687  1.00  0.00           N  
ATOM    837  CA  LEU A  59      -5.117 -30.653   2.331  1.00  0.00           C  
ATOM    838  C   LEU A  59      -5.595 -32.043   2.760  1.00  0.00           C  
ATOM    839  O   LEU A  59      -6.466 -32.179   3.596  1.00  0.00           O  
ATOM    840  CB  LEU A  59      -6.092 -30.061   1.318  1.00  0.00           C  
ATOM    841  CG  LEU A  59      -7.125 -29.206   2.044  1.00  0.00           C  
ATOM    842  CD1 LEU A  59      -6.422 -27.999   2.663  1.00  0.00           C  
ATOM    843  CD2 LEU A  59      -8.180 -28.727   1.045  1.00  0.00           C  
ATOM    844  H   LEU A  59      -3.706 -30.595   0.727  1.00  0.00           H  
ATOM    845  HA  LEU A  59      -5.054 -30.007   3.194  1.00  0.00           H  
ATOM    846  HB2 LEU A  59      -5.548 -29.447   0.615  1.00  0.00           H  
ATOM    847  HB3 LEU A  59      -6.587 -30.858   0.788  1.00  0.00           H  
ATOM    848  HG  LEU A  59      -7.596 -29.789   2.822  1.00  0.00           H  
ATOM    849 HD11 LEU A  59      -5.364 -28.052   2.450  1.00  0.00           H  
ATOM    850 HD12 LEU A  59      -6.829 -27.091   2.244  1.00  0.00           H  
ATOM    851 HD13 LEU A  59      -6.575 -28.003   3.732  1.00  0.00           H  
ATOM    852 HD21 LEU A  59      -8.203 -29.395   0.197  1.00  0.00           H  
ATOM    853 HD22 LEU A  59      -9.149 -28.719   1.522  1.00  0.00           H  
ATOM    854 HD23 LEU A  59      -7.934 -27.730   0.711  1.00  0.00           H  
ATOM    855  N   LYS A  60      -5.033 -33.076   2.194  1.00  0.00           N  
ATOM    856  CA  LYS A  60      -5.458 -34.454   2.573  1.00  0.00           C  
ATOM    857  C   LYS A  60      -5.318 -34.630   4.085  1.00  0.00           C  
ATOM    858  O   LYS A  60      -5.997 -35.435   4.692  1.00  0.00           O  
ATOM    859  CB  LYS A  60      -4.578 -35.478   1.854  1.00  0.00           C  
ATOM    860  CG  LYS A  60      -5.016 -35.591   0.393  1.00  0.00           C  
ATOM    861  CD  LYS A  60      -4.602 -36.955  -0.163  1.00  0.00           C  
ATOM    862  CE  LYS A  60      -3.194 -36.859  -0.755  1.00  0.00           C  
ATOM    863  NZ  LYS A  60      -2.857 -38.249  -1.169  1.00  0.00           N  
ATOM    864  H   LYS A  60      -4.333 -32.947   1.522  1.00  0.00           H  
ATOM    865  HA  LYS A  60      -6.489 -34.602   2.287  1.00  0.00           H  
ATOM    866  HB2 LYS A  60      -3.546 -35.160   1.898  1.00  0.00           H  
ATOM    867  HB3 LYS A  60      -4.679 -36.440   2.333  1.00  0.00           H  
ATOM    868  HG2 LYS A  60      -6.090 -35.486   0.332  1.00  0.00           H  
ATOM    869  HG3 LYS A  60      -4.545 -34.810  -0.186  1.00  0.00           H  
ATOM    870  HD2 LYS A  60      -4.611 -37.686   0.633  1.00  0.00           H  
ATOM    871  HD3 LYS A  60      -5.295 -37.254  -0.935  1.00  0.00           H  
ATOM    872  HE2 LYS A  60      -3.192 -36.197  -1.610  1.00  0.00           H  
ATOM    873  HE3 LYS A  60      -2.495 -36.515  -0.008  1.00  0.00           H  
ATOM    874  HZ1 LYS A  60      -3.728 -38.763  -1.406  1.00  0.00           H  
ATOM    875  HZ2 LYS A  60      -2.233 -38.220  -2.002  1.00  0.00           H  
ATOM    876  HZ3 LYS A  60      -2.371 -38.736  -0.389  1.00  0.00           H  
ATOM    877  N   LEU A  61      -4.444 -33.880   4.699  1.00  0.00           N  
ATOM    878  CA  LEU A  61      -4.261 -33.996   6.169  1.00  0.00           C  
ATOM    879  C   LEU A  61      -5.219 -33.023   6.864  1.00  0.00           C  
ATOM    880  O   LEU A  61      -5.175 -31.834   6.619  1.00  0.00           O  
ATOM    881  CB  LEU A  61      -2.815 -33.640   6.513  1.00  0.00           C  
ATOM    882  CG  LEU A  61      -2.336 -34.489   7.693  1.00  0.00           C  
ATOM    883  CD1 LEU A  61      -0.974 -35.101   7.361  1.00  0.00           C  
ATOM    884  CD2 LEU A  61      -2.202 -33.610   8.936  1.00  0.00           C  
ATOM    885  H   LEU A  61      -3.908 -33.235   4.194  1.00  0.00           H  
ATOM    886  HA  LEU A  61      -4.471 -35.007   6.484  1.00  0.00           H  
ATOM    887  HB2 LEU A  61      -2.187 -33.832   5.655  1.00  0.00           H  
ATOM    888  HB3 LEU A  61      -2.757 -32.596   6.771  1.00  0.00           H  
ATOM    889  HG  LEU A  61      -3.049 -35.278   7.882  1.00  0.00           H  
ATOM    890 HD11 LEU A  61      -1.039 -35.639   6.427  1.00  0.00           H  
ATOM    891 HD12 LEU A  61      -0.239 -34.314   7.273  1.00  0.00           H  
ATOM    892 HD13 LEU A  61      -0.682 -35.779   8.149  1.00  0.00           H  
ATOM    893 HD21 LEU A  61      -3.101 -33.028   9.063  1.00  0.00           H  
ATOM    894 HD22 LEU A  61      -2.051 -34.233   9.804  1.00  0.00           H  
ATOM    895 HD23 LEU A  61      -1.357 -32.947   8.818  1.00  0.00           H  
ATOM    896  N   PRO A  62      -6.070 -33.561   7.698  1.00  0.00           N  
ATOM    897  CA  PRO A  62      -7.061 -32.725   8.420  1.00  0.00           C  
ATOM    898  C   PRO A  62      -6.395 -31.918   9.537  1.00  0.00           C  
ATOM    899  O   PRO A  62      -6.091 -32.435  10.594  1.00  0.00           O  
ATOM    900  CB  PRO A  62      -8.034 -33.746   9.000  1.00  0.00           C  
ATOM    901  CG  PRO A  62      -7.246 -35.012   9.118  1.00  0.00           C  
ATOM    902  CD  PRO A  62      -6.190 -34.982   8.044  1.00  0.00           C  
ATOM    903  HA  PRO A  62      -7.580 -32.072   7.735  1.00  0.00           H  
ATOM    904  HB2 PRO A  62      -8.380 -33.423   9.974  1.00  0.00           H  
ATOM    905  HB3 PRO A  62      -8.869 -33.893   8.333  1.00  0.00           H  
ATOM    906  HG2 PRO A  62      -6.781 -35.065  10.094  1.00  0.00           H  
ATOM    907  HG3 PRO A  62      -7.891 -35.864   8.970  1.00  0.00           H  
ATOM    908  HD2 PRO A  62      -5.252 -35.362   8.426  1.00  0.00           H  
ATOM    909  HD3 PRO A  62      -6.508 -35.548   7.183  1.00  0.00           H  
ATOM    910  N   LEU A  63      -6.178 -30.648   9.319  1.00  0.00           N  
ATOM    911  CA  LEU A  63      -5.549 -29.807  10.377  1.00  0.00           C  
ATOM    912  C   LEU A  63      -6.289 -28.477  10.478  1.00  0.00           C  
ATOM    913  O   LEU A  63      -7.244 -28.225   9.771  1.00  0.00           O  
ATOM    914  CB  LEU A  63      -4.092 -29.507  10.033  1.00  0.00           C  
ATOM    915  CG  LEU A  63      -3.534 -30.559   9.082  1.00  0.00           C  
ATOM    916  CD1 LEU A  63      -3.643 -30.052   7.642  1.00  0.00           C  
ATOM    917  CD2 LEU A  63      -2.063 -30.807   9.423  1.00  0.00           C  
ATOM    918  H   LEU A  63      -6.441 -30.246   8.464  1.00  0.00           H  
ATOM    919  HA  LEU A  63      -5.593 -30.317  11.320  1.00  0.00           H  
ATOM    920  HB2 LEU A  63      -4.037 -28.541   9.569  1.00  0.00           H  
ATOM    921  HB3 LEU A  63      -3.506 -29.500  10.940  1.00  0.00           H  
ATOM    922  HG  LEU A  63      -4.095 -31.476   9.187  1.00  0.00           H  
ATOM    923 HD11 LEU A  63      -3.082 -29.135   7.540  1.00  0.00           H  
ATOM    924 HD12 LEU A  63      -3.244 -30.794   6.968  1.00  0.00           H  
ATOM    925 HD13 LEU A  63      -4.680 -29.868   7.403  1.00  0.00           H  
ATOM    926 HD21 LEU A  63      -1.642 -29.914   9.864  1.00  0.00           H  
ATOM    927 HD22 LEU A  63      -1.989 -31.620  10.128  1.00  0.00           H  
ATOM    928 HD23 LEU A  63      -1.520 -31.055   8.524  1.00  0.00           H  
ATOM    929  N   ALA A  64      -5.836 -27.616  11.344  1.00  0.00           N  
ATOM    930  CA  ALA A  64      -6.486 -26.285  11.487  1.00  0.00           C  
ATOM    931  C   ALA A  64      -5.469 -25.204  11.128  1.00  0.00           C  
ATOM    932  O   ALA A  64      -4.370 -25.174  11.647  1.00  0.00           O  
ATOM    933  CB  ALA A  64      -6.959 -26.090  12.927  1.00  0.00           C  
ATOM    934  H   ALA A  64      -5.053 -27.842  11.890  1.00  0.00           H  
ATOM    935  HA  ALA A  64      -7.331 -26.223  10.816  1.00  0.00           H  
ATOM    936  HB1 ALA A  64      -6.897 -27.029  13.456  1.00  0.00           H  
ATOM    937  HB2 ALA A  64      -6.331 -25.359  13.415  1.00  0.00           H  
ATOM    938  HB3 ALA A  64      -7.981 -25.742  12.925  1.00  0.00           H  
ATOM    939  N   VAL A  65      -5.818 -24.322  10.236  1.00  0.00           N  
ATOM    940  CA  VAL A  65      -4.861 -23.251   9.837  1.00  0.00           C  
ATOM    941  C   VAL A  65      -5.424 -21.883  10.222  1.00  0.00           C  
ATOM    942  O   VAL A  65      -6.441 -21.452   9.716  1.00  0.00           O  
ATOM    943  CB  VAL A  65      -4.640 -23.304   8.325  1.00  0.00           C  
ATOM    944  CG1 VAL A  65      -3.403 -22.482   7.960  1.00  0.00           C  
ATOM    945  CG2 VAL A  65      -4.429 -24.757   7.894  1.00  0.00           C  
ATOM    946  H   VAL A  65      -6.704 -24.368   9.824  1.00  0.00           H  
ATOM    947  HA  VAL A  65      -3.919 -23.406  10.341  1.00  0.00           H  
ATOM    948  HB  VAL A  65      -5.505 -22.898   7.820  1.00  0.00           H  
ATOM    949 HG11 VAL A  65      -2.949 -22.097   8.861  1.00  0.00           H  
ATOM    950 HG12 VAL A  65      -2.694 -23.110   7.439  1.00  0.00           H  
ATOM    951 HG13 VAL A  65      -3.692 -21.660   7.322  1.00  0.00           H  
ATOM    952 HG21 VAL A  65      -3.861 -25.278   8.650  1.00  0.00           H  
ATOM    953 HG22 VAL A  65      -5.389 -25.239   7.769  1.00  0.00           H  
ATOM    954 HG23 VAL A  65      -3.890 -24.781   6.958  1.00  0.00           H  
ATOM    955  N   GLU A  66      -4.766 -21.193  11.112  1.00  0.00           N  
ATOM    956  CA  GLU A  66      -5.255 -19.850  11.529  1.00  0.00           C  
ATOM    957  C   GLU A  66      -4.061 -18.983  11.933  1.00  0.00           C  
ATOM    958  O   GLU A  66      -3.589 -19.044  13.051  1.00  0.00           O  
ATOM    959  CB  GLU A  66      -6.205 -19.999  12.719  1.00  0.00           C  
ATOM    960  CG  GLU A  66      -7.364 -19.010  12.575  1.00  0.00           C  
ATOM    961  CD  GLU A  66      -8.669 -19.686  13.001  1.00  0.00           C  
ATOM    962  OE1 GLU A  66      -9.171 -20.493  12.237  1.00  0.00           O  
ATOM    963  OE2 GLU A  66      -9.144 -19.384  14.083  1.00  0.00           O  
ATOM    964  H   GLU A  66      -3.945 -21.558  11.505  1.00  0.00           H  
ATOM    965  HA  GLU A  66      -5.776 -19.385  10.706  1.00  0.00           H  
ATOM    966  HB2 GLU A  66      -6.592 -21.007  12.745  1.00  0.00           H  
ATOM    967  HB3 GLU A  66      -5.671 -19.793  13.634  1.00  0.00           H  
ATOM    968  HG2 GLU A  66      -7.182 -18.149  13.202  1.00  0.00           H  
ATOM    969  HG3 GLU A  66      -7.443 -18.696  11.545  1.00  0.00           H  
ATOM    970  N   LEU A  67      -3.565 -18.180  11.030  1.00  0.00           N  
ATOM    971  CA  LEU A  67      -2.398 -17.314  11.360  1.00  0.00           C  
ATOM    972  C   LEU A  67      -2.580 -16.699  12.746  1.00  0.00           C  
ATOM    973  O   LEU A  67      -3.655 -16.727  13.315  1.00  0.00           O  
ATOM    974  CB  LEU A  67      -2.283 -16.209  10.325  1.00  0.00           C  
ATOM    975  CG  LEU A  67      -2.622 -16.763   8.941  1.00  0.00           C  
ATOM    976  CD1 LEU A  67      -2.183 -15.768   7.891  1.00  0.00           C  
ATOM    977  CD2 LEU A  67      -1.891 -18.089   8.711  1.00  0.00           C  
ATOM    978  H   LEU A  67      -3.956 -18.150  10.131  1.00  0.00           H  
ATOM    979  HA  LEU A  67      -1.500 -17.899  11.340  1.00  0.00           H  
ATOM    980  HB2 LEU A  67      -2.965 -15.421  10.578  1.00  0.00           H  
ATOM    981  HB3 LEU A  67      -1.273 -15.826  10.320  1.00  0.00           H  
ATOM    982  HG  LEU A  67      -3.687 -16.915   8.860  1.00  0.00           H  
ATOM    983 HD11 LEU A  67      -1.626 -14.977   8.366  1.00  0.00           H  
ATOM    984 HD12 LEU A  67      -1.560 -16.269   7.168  1.00  0.00           H  
ATOM    985 HD13 LEU A  67      -3.055 -15.361   7.405  1.00  0.00           H  
ATOM    986 HD21 LEU A  67      -2.036 -18.738   9.560  1.00  0.00           H  
ATOM    987 HD22 LEU A  67      -2.281 -18.565   7.824  1.00  0.00           H  
ATOM    988 HD23 LEU A  67      -0.836 -17.898   8.580  1.00  0.00           H  
ATOM    989  N   THR A  68      -1.539 -16.137  13.294  1.00  0.00           N  
ATOM    990  CA  THR A  68      -1.650 -15.515  14.645  1.00  0.00           C  
ATOM    991  C   THR A  68      -0.669 -14.352  14.752  1.00  0.00           C  
ATOM    992  O   THR A  68      -0.971 -13.314  15.307  1.00  0.00           O  
ATOM    993  CB  THR A  68      -1.332 -16.556  15.720  1.00  0.00           C  
ATOM    994  OG1 THR A  68      -0.898 -15.897  16.902  1.00  0.00           O  
ATOM    995  CG2 THR A  68      -0.230 -17.492  15.219  1.00  0.00           C  
ATOM    996  H   THR A  68      -0.684 -16.122  12.817  1.00  0.00           H  
ATOM    997  HA  THR A  68      -2.646 -15.147  14.783  1.00  0.00           H  
ATOM    998  HB  THR A  68      -2.218 -17.134  15.935  1.00  0.00           H  
ATOM    999  HG1 THR A  68      -1.674 -15.687  17.426  1.00  0.00           H  
ATOM   1000 HG21 THR A  68      -0.506 -17.887  14.253  1.00  0.00           H  
ATOM   1001 HG22 THR A  68       0.696 -16.943  15.133  1.00  0.00           H  
ATOM   1002 HG23 THR A  68      -0.103 -18.306  15.918  1.00  0.00           H  
ATOM   1003  N   GLN A  69       0.498 -14.522  14.219  1.00  0.00           N  
ATOM   1004  CA  GLN A  69       1.516 -13.435  14.272  1.00  0.00           C  
ATOM   1005  C   GLN A  69       1.235 -12.430  13.153  1.00  0.00           C  
ATOM   1006  O   GLN A  69       0.098 -12.184  12.800  1.00  0.00           O  
ATOM   1007  CB  GLN A  69       2.912 -14.035  14.087  1.00  0.00           C  
ATOM   1008  CG  GLN A  69       3.070 -14.528  12.647  1.00  0.00           C  
ATOM   1009  CD  GLN A  69       3.386 -16.024  12.652  1.00  0.00           C  
ATOM   1010  OE1 GLN A  69       2.656 -16.812  12.086  1.00  0.00           O  
ATOM   1011  NE2 GLN A  69       4.452 -16.451  13.272  1.00  0.00           N  
ATOM   1012  H   GLN A  69       0.704 -15.367  13.777  1.00  0.00           H  
ATOM   1013  HA  GLN A  69       1.461 -12.936  15.228  1.00  0.00           H  
ATOM   1014  HB2 GLN A  69       3.658 -13.281  14.295  1.00  0.00           H  
ATOM   1015  HB3 GLN A  69       3.041 -14.865  14.766  1.00  0.00           H  
ATOM   1016  HG2 GLN A  69       2.152 -14.354  12.105  1.00  0.00           H  
ATOM   1017  HG3 GLN A  69       3.878 -13.993  12.171  1.00  0.00           H  
ATOM   1018 HE21 GLN A  69       5.040 -15.816  13.730  1.00  0.00           H  
ATOM   1019 HE22 GLN A  69       4.662 -17.408  13.282  1.00  0.00           H  
ATOM   1020  N   GLU A  70       2.257 -11.846  12.589  1.00  0.00           N  
ATOM   1021  CA  GLU A  70       2.037 -10.861  11.494  1.00  0.00           C  
ATOM   1022  C   GLU A  70       2.586 -11.421  10.180  1.00  0.00           C  
ATOM   1023  O   GLU A  70       3.714 -11.865  10.107  1.00  0.00           O  
ATOM   1024  CB  GLU A  70       2.753  -9.552  11.826  1.00  0.00           C  
ATOM   1025  CG  GLU A  70       2.152  -8.425  10.986  1.00  0.00           C  
ATOM   1026  CD  GLU A  70       2.829  -7.101  11.346  1.00  0.00           C  
ATOM   1027  OE1 GLU A  70       4.027  -6.995  11.137  1.00  0.00           O  
ATOM   1028  OE2 GLU A  70       2.139  -6.216  11.825  1.00  0.00           O  
ATOM   1029  H   GLU A  70       3.167 -12.055  12.884  1.00  0.00           H  
ATOM   1030  HA  GLU A  70       0.978 -10.673  11.387  1.00  0.00           H  
ATOM   1031  HB2 GLU A  70       2.627  -9.328  12.876  1.00  0.00           H  
ATOM   1032  HB3 GLU A  70       3.804  -9.648  11.599  1.00  0.00           H  
ATOM   1033  HG2 GLU A  70       2.307  -8.636   9.938  1.00  0.00           H  
ATOM   1034  HG3 GLU A  70       1.094  -8.351  11.185  1.00  0.00           H  
ATOM   1035  N   VAL A  71       1.797 -11.396   9.143  1.00  0.00           N  
ATOM   1036  CA  VAL A  71       2.269 -11.917   7.831  1.00  0.00           C  
ATOM   1037  C   VAL A  71       3.365 -10.995   7.297  1.00  0.00           C  
ATOM   1038  O   VAL A  71       3.401  -9.818   7.597  1.00  0.00           O  
ATOM   1039  CB  VAL A  71       1.089 -11.947   6.855  1.00  0.00           C  
ATOM   1040  CG1 VAL A  71       1.604 -12.054   5.419  1.00  0.00           C  
ATOM   1041  CG2 VAL A  71       0.205 -13.155   7.169  1.00  0.00           C  
ATOM   1042  H   VAL A  71       0.893 -11.027   9.223  1.00  0.00           H  
ATOM   1043  HA  VAL A  71       2.664 -12.916   7.955  1.00  0.00           H  
ATOM   1044  HB  VAL A  71       0.509 -11.040   6.961  1.00  0.00           H  
ATOM   1045 HG11 VAL A  71       2.448 -12.726   5.390  1.00  0.00           H  
ATOM   1046 HG12 VAL A  71       0.818 -12.432   4.783  1.00  0.00           H  
ATOM   1047 HG13 VAL A  71       1.908 -11.076   5.075  1.00  0.00           H  
ATOM   1048 HG21 VAL A  71       0.037 -13.211   8.233  1.00  0.00           H  
ATOM   1049 HG22 VAL A  71      -0.740 -13.052   6.659  1.00  0.00           H  
ATOM   1050 HG23 VAL A  71       0.697 -14.057   6.835  1.00  0.00           H  
ATOM   1051  N   ARG A  72       4.261 -11.516   6.506  1.00  0.00           N  
ATOM   1052  CA  ARG A  72       5.352 -10.657   5.960  1.00  0.00           C  
ATOM   1053  C   ARG A  72       5.207 -10.544   4.442  1.00  0.00           C  
ATOM   1054  O   ARG A  72       4.973 -11.519   3.756  1.00  0.00           O  
ATOM   1055  CB  ARG A  72       6.716 -11.264   6.300  1.00  0.00           C  
ATOM   1056  CG  ARG A  72       6.617 -12.068   7.598  1.00  0.00           C  
ATOM   1057  CD  ARG A  72       7.951 -12.765   7.867  1.00  0.00           C  
ATOM   1058  NE  ARG A  72       7.776 -13.779   8.945  1.00  0.00           N  
ATOM   1059  CZ  ARG A  72       7.994 -13.455  10.189  1.00  0.00           C  
ATOM   1060  NH1 ARG A  72       7.342 -12.462  10.729  1.00  0.00           N  
ATOM   1061  NH2 ARG A  72       8.866 -14.122  10.896  1.00  0.00           N  
ATOM   1062  H   ARG A  72       4.219 -12.470   6.273  1.00  0.00           H  
ATOM   1063  HA  ARG A  72       5.281  -9.672   6.399  1.00  0.00           H  
ATOM   1064  HB2 ARG A  72       7.031 -11.913   5.496  1.00  0.00           H  
ATOM   1065  HB3 ARG A  72       7.439 -10.472   6.426  1.00  0.00           H  
ATOM   1066  HG2 ARG A  72       6.385 -11.403   8.417  1.00  0.00           H  
ATOM   1067  HG3 ARG A  72       5.839 -12.811   7.505  1.00  0.00           H  
ATOM   1068  HD2 ARG A  72       8.290 -13.252   6.966  1.00  0.00           H  
ATOM   1069  HD3 ARG A  72       8.682 -12.033   8.178  1.00  0.00           H  
ATOM   1070  HE  ARG A  72       7.497 -14.691   8.718  1.00  0.00           H  
ATOM   1071 HH11 ARG A  72       6.676 -11.949  10.187  1.00  0.00           H  
ATOM   1072 HH12 ARG A  72       7.507 -12.214  11.683  1.00  0.00           H  
ATOM   1073 HH21 ARG A  72       9.369 -14.882  10.482  1.00  0.00           H  
ATOM   1074 HH22 ARG A  72       9.033 -13.874  11.850  1.00  0.00           H  
ATOM   1075  N   ALA A  73       5.346  -9.360   3.914  1.00  0.00           N  
ATOM   1076  CA  ALA A  73       5.218  -9.179   2.441  1.00  0.00           C  
ATOM   1077  C   ALA A  73       6.101  -8.010   1.997  1.00  0.00           C  
ATOM   1078  O   ALA A  73       5.851  -6.870   2.337  1.00  0.00           O  
ATOM   1079  CB  ALA A  73       3.760  -8.880   2.086  1.00  0.00           C  
ATOM   1080  H   ALA A  73       5.535  -8.588   4.486  1.00  0.00           H  
ATOM   1081  HA  ALA A  73       5.535 -10.081   1.938  1.00  0.00           H  
ATOM   1082  HB1 ALA A  73       3.109  -9.493   2.692  1.00  0.00           H  
ATOM   1083  HB2 ALA A  73       3.550  -7.838   2.273  1.00  0.00           H  
ATOM   1084  HB3 ALA A  73       3.591  -9.099   1.041  1.00  0.00           H  
ATOM   1085  N   VAL A  74       7.131  -8.282   1.244  1.00  0.00           N  
ATOM   1086  CA  VAL A  74       8.029  -7.182   0.782  1.00  0.00           C  
ATOM   1087  C   VAL A  74       8.236  -7.293  -0.727  1.00  0.00           C  
ATOM   1088  O   VAL A  74       8.112  -8.355  -1.304  1.00  0.00           O  
ATOM   1089  CB  VAL A  74       9.397  -7.272   1.477  1.00  0.00           C  
ATOM   1090  CG1 VAL A  74       9.643  -5.993   2.274  1.00  0.00           C  
ATOM   1091  CG2 VAL A  74       9.440  -8.481   2.420  1.00  0.00           C  
ATOM   1092  H   VAL A  74       7.316  -9.208   0.982  1.00  0.00           H  
ATOM   1093  HA  VAL A  74       7.573  -6.230   1.011  1.00  0.00           H  
ATOM   1094  HB  VAL A  74      10.168  -7.373   0.728  1.00  0.00           H  
ATOM   1095 HG11 VAL A  74       9.403  -5.137   1.661  1.00  0.00           H  
ATOM   1096 HG12 VAL A  74       9.019  -5.992   3.156  1.00  0.00           H  
ATOM   1097 HG13 VAL A  74      10.681  -5.947   2.567  1.00  0.00           H  
ATOM   1098 HG21 VAL A  74       9.234  -9.381   1.862  1.00  0.00           H  
ATOM   1099 HG22 VAL A  74      10.420  -8.551   2.869  1.00  0.00           H  
ATOM   1100 HG23 VAL A  74       8.698  -8.359   3.196  1.00  0.00           H  
ATOM   1101  N   ALA A  75       8.561  -6.205  -1.367  1.00  0.00           N  
ATOM   1102  CA  ALA A  75       8.786  -6.247  -2.837  1.00  0.00           C  
ATOM   1103  C   ALA A  75       7.691  -7.087  -3.498  1.00  0.00           C  
ATOM   1104  O   ALA A  75       6.564  -7.119  -3.045  1.00  0.00           O  
ATOM   1105  CB  ALA A  75      10.153  -6.876  -3.115  1.00  0.00           C  
ATOM   1106  H   ALA A  75       8.663  -5.360  -0.880  1.00  0.00           H  
ATOM   1107  HA  ALA A  75       8.764  -5.244  -3.237  1.00  0.00           H  
ATOM   1108  HB1 ALA A  75      10.905  -6.378  -2.520  1.00  0.00           H  
ATOM   1109  HB2 ALA A  75      10.125  -7.925  -2.856  1.00  0.00           H  
ATOM   1110  HB3 ALA A  75      10.392  -6.770  -4.162  1.00  0.00           H  
ATOM   1111  N   ASN A  76       8.012  -7.770  -4.563  1.00  0.00           N  
ATOM   1112  CA  ASN A  76       6.987  -8.607  -5.246  1.00  0.00           C  
ATOM   1113  C   ASN A  76       6.871  -9.957  -4.532  1.00  0.00           C  
ATOM   1114  O   ASN A  76       6.055 -10.786  -4.882  1.00  0.00           O  
ATOM   1115  CB  ASN A  76       7.404  -8.837  -6.701  1.00  0.00           C  
ATOM   1116  CG  ASN A  76       7.190  -7.552  -7.501  1.00  0.00           C  
ATOM   1117  OD1 ASN A  76       6.630  -6.596  -7.001  1.00  0.00           O  
ATOM   1118  ND2 ASN A  76       7.614  -7.487  -8.734  1.00  0.00           N  
ATOM   1119  H   ASN A  76       8.927  -7.732  -4.912  1.00  0.00           H  
ATOM   1120  HA  ASN A  76       6.032  -8.103  -5.220  1.00  0.00           H  
ATOM   1121  HB2 ASN A  76       8.447  -9.115  -6.736  1.00  0.00           H  
ATOM   1122  HB3 ASN A  76       6.804  -9.627  -7.126  1.00  0.00           H  
ATOM   1123 HD21 ASN A  76       8.067  -8.257  -9.137  1.00  0.00           H  
ATOM   1124 HD22 ASN A  76       7.483  -6.667  -9.255  1.00  0.00           H  
ATOM   1125  N   GLU A  77       7.684 -10.186  -3.536  1.00  0.00           N  
ATOM   1126  CA  GLU A  77       7.624 -11.481  -2.808  1.00  0.00           C  
ATOM   1127  C   GLU A  77       6.947 -11.277  -1.454  1.00  0.00           C  
ATOM   1128  O   GLU A  77       6.293 -10.281  -1.215  1.00  0.00           O  
ATOM   1129  CB  GLU A  77       9.043 -11.994  -2.586  1.00  0.00           C  
ATOM   1130  CG  GLU A  77       9.324 -13.160  -3.532  1.00  0.00           C  
ATOM   1131  CD  GLU A  77      10.823 -13.229  -3.829  1.00  0.00           C  
ATOM   1132  OE1 GLU A  77      11.422 -12.180  -4.004  1.00  0.00           O  
ATOM   1133  OE2 GLU A  77      11.347 -14.330  -3.877  1.00  0.00           O  
ATOM   1134  H   GLU A  77       8.339  -9.511  -3.269  1.00  0.00           H  
ATOM   1135  HA  GLU A  77       7.066 -12.199  -3.390  1.00  0.00           H  
ATOM   1136  HB2 GLU A  77       9.744 -11.199  -2.774  1.00  0.00           H  
ATOM   1137  HB3 GLU A  77       9.149 -12.325  -1.568  1.00  0.00           H  
ATOM   1138  HG2 GLU A  77       9.005 -14.083  -3.071  1.00  0.00           H  
ATOM   1139  HG3 GLU A  77       8.783 -13.012  -4.456  1.00  0.00           H  
ATOM   1140  N   ALA A  78       7.104 -12.217  -0.566  1.00  0.00           N  
ATOM   1141  CA  ALA A  78       6.478 -12.088   0.780  1.00  0.00           C  
ATOM   1142  C   ALA A  78       6.784 -13.339   1.608  1.00  0.00           C  
ATOM   1143  O   ALA A  78       7.223 -14.345   1.089  1.00  0.00           O  
ATOM   1144  CB  ALA A  78       4.963 -11.938   0.627  1.00  0.00           C  
ATOM   1145  H   ALA A  78       7.638 -13.007  -0.785  1.00  0.00           H  
ATOM   1146  HA  ALA A  78       6.877 -11.218   1.282  1.00  0.00           H  
ATOM   1147  HB1 ALA A  78       4.749 -11.175  -0.106  1.00  0.00           H  
ATOM   1148  HB2 ALA A  78       4.540 -12.878   0.303  1.00  0.00           H  
ATOM   1149  HB3 ALA A  78       4.532 -11.658   1.577  1.00  0.00           H  
ATOM   1150  N   ALA A  79       6.551 -13.283   2.890  1.00  0.00           N  
ATOM   1151  CA  ALA A  79       6.820 -14.468   3.755  1.00  0.00           C  
ATOM   1152  C   ALA A  79       5.850 -14.451   4.936  1.00  0.00           C  
ATOM   1153  O   ALA A  79       5.565 -13.413   5.496  1.00  0.00           O  
ATOM   1154  CB  ALA A  79       8.257 -14.407   4.277  1.00  0.00           C  
ATOM   1155  H   ALA A  79       6.194 -12.461   3.286  1.00  0.00           H  
ATOM   1156  HA  ALA A  79       6.681 -15.372   3.183  1.00  0.00           H  
ATOM   1157  HB1 ALA A  79       8.456 -13.423   4.670  1.00  0.00           H  
ATOM   1158  HB2 ALA A  79       8.386 -15.141   5.058  1.00  0.00           H  
ATOM   1159  HB3 ALA A  79       8.941 -14.619   3.468  1.00  0.00           H  
ATOM   1160  N   PHE A  80       5.335 -15.586   5.326  1.00  0.00           N  
ATOM   1161  CA  PHE A  80       4.388 -15.598   6.474  1.00  0.00           C  
ATOM   1162  C   PHE A  80       4.477 -16.931   7.207  1.00  0.00           C  
ATOM   1163  O   PHE A  80       5.091 -17.868   6.744  1.00  0.00           O  
ATOM   1164  CB  PHE A  80       2.961 -15.378   5.965  1.00  0.00           C  
ATOM   1165  CG  PHE A  80       2.485 -16.602   5.210  1.00  0.00           C  
ATOM   1166  CD1 PHE A  80       1.861 -17.654   5.893  1.00  0.00           C  
ATOM   1167  CD2 PHE A  80       2.663 -16.679   3.823  1.00  0.00           C  
ATOM   1168  CE1 PHE A  80       1.416 -18.782   5.187  1.00  0.00           C  
ATOM   1169  CE2 PHE A  80       2.218 -17.805   3.118  1.00  0.00           C  
ATOM   1170  CZ  PHE A  80       1.595 -18.857   3.799  1.00  0.00           C  
ATOM   1171  H   PHE A  80       5.569 -16.422   4.869  1.00  0.00           H  
ATOM   1172  HA  PHE A  80       4.649 -14.804   7.156  1.00  0.00           H  
ATOM   1173  HB2 PHE A  80       2.308 -15.192   6.804  1.00  0.00           H  
ATOM   1174  HB3 PHE A  80       2.945 -14.525   5.307  1.00  0.00           H  
ATOM   1175  HD1 PHE A  80       1.723 -17.598   6.963  1.00  0.00           H  
ATOM   1176  HD2 PHE A  80       3.144 -15.868   3.296  1.00  0.00           H  
ATOM   1177  HE1 PHE A  80       0.936 -19.594   5.714  1.00  0.00           H  
ATOM   1178  HE2 PHE A  80       2.357 -17.861   2.048  1.00  0.00           H  
ATOM   1179  HZ  PHE A  80       1.251 -19.729   3.253  1.00  0.00           H  
ATOM   1180  N   ALA A  81       3.870 -17.015   8.356  1.00  0.00           N  
ATOM   1181  CA  ALA A  81       3.919 -18.282   9.134  1.00  0.00           C  
ATOM   1182  C   ALA A  81       2.567 -18.525   9.803  1.00  0.00           C  
ATOM   1183  O   ALA A  81       1.622 -17.788   9.606  1.00  0.00           O  
ATOM   1184  CB  ALA A  81       5.002 -18.177  10.209  1.00  0.00           C  
ATOM   1185  H   ALA A  81       3.384 -16.241   8.709  1.00  0.00           H  
ATOM   1186  HA  ALA A  81       4.147 -19.105   8.472  1.00  0.00           H  
ATOM   1187  HB1 ALA A  81       5.826 -17.587   9.836  1.00  0.00           H  
ATOM   1188  HB2 ALA A  81       4.591 -17.703  11.089  1.00  0.00           H  
ATOM   1189  HB3 ALA A  81       5.353 -19.164  10.465  1.00  0.00           H  
ATOM   1190  N   PHE A  82       2.474 -19.551  10.600  1.00  0.00           N  
ATOM   1191  CA  PHE A  82       1.190 -19.845  11.293  1.00  0.00           C  
ATOM   1192  C   PHE A  82       1.334 -21.129  12.099  1.00  0.00           C  
ATOM   1193  O   PHE A  82       2.423 -21.555  12.428  1.00  0.00           O  
ATOM   1194  CB  PHE A  82       0.072 -20.022  10.265  1.00  0.00           C  
ATOM   1195  CG  PHE A  82       0.353 -21.234   9.409  1.00  0.00           C  
ATOM   1196  CD1 PHE A  82       1.415 -21.216   8.497  1.00  0.00           C  
ATOM   1197  CD2 PHE A  82      -0.450 -22.374   9.528  1.00  0.00           C  
ATOM   1198  CE1 PHE A  82       1.674 -22.340   7.703  1.00  0.00           C  
ATOM   1199  CE2 PHE A  82      -0.191 -23.497   8.734  1.00  0.00           C  
ATOM   1200  CZ  PHE A  82       0.870 -23.481   7.821  1.00  0.00           C  
ATOM   1201  H   PHE A  82       3.253 -20.128  10.747  1.00  0.00           H  
ATOM   1202  HA  PHE A  82       0.943 -19.031  11.957  1.00  0.00           H  
ATOM   1203  HB2 PHE A  82      -0.870 -20.153  10.778  1.00  0.00           H  
ATOM   1204  HB3 PHE A  82       0.018 -19.149   9.643  1.00  0.00           H  
ATOM   1205  HD1 PHE A  82       2.035 -20.337   8.406  1.00  0.00           H  
ATOM   1206  HD2 PHE A  82      -1.269 -22.387  10.232  1.00  0.00           H  
ATOM   1207  HE1 PHE A  82       2.492 -22.327   6.999  1.00  0.00           H  
ATOM   1208  HE2 PHE A  82      -0.811 -24.377   8.825  1.00  0.00           H  
ATOM   1209  HZ  PHE A  82       1.069 -24.347   7.209  1.00  0.00           H  
ATOM   1210  N   THR A  83       0.238 -21.748  12.417  1.00  0.00           N  
ATOM   1211  CA  THR A  83       0.295 -23.007  13.202  1.00  0.00           C  
ATOM   1212  C   THR A  83      -0.701 -24.013  12.633  1.00  0.00           C  
ATOM   1213  O   THR A  83      -1.714 -23.651  12.069  1.00  0.00           O  
ATOM   1214  CB  THR A  83      -0.060 -22.711  14.656  1.00  0.00           C  
ATOM   1215  OG1 THR A  83      -0.650 -21.421  14.745  1.00  0.00           O  
ATOM   1216  CG2 THR A  83       1.209 -22.756  15.500  1.00  0.00           C  
ATOM   1217  H   THR A  83      -0.625 -21.380  12.139  1.00  0.00           H  
ATOM   1218  HA  THR A  83       1.292 -23.418  13.152  1.00  0.00           H  
ATOM   1219  HB  THR A  83      -0.755 -23.454  15.018  1.00  0.00           H  
ATOM   1220  HG1 THR A  83      -0.767 -21.212  15.675  1.00  0.00           H  
ATOM   1221 HG21 THR A  83       2.056 -22.491  14.885  1.00  0.00           H  
ATOM   1222 HG22 THR A  83       1.122 -22.057  16.316  1.00  0.00           H  
ATOM   1223 HG23 THR A  83       1.345 -23.755  15.889  1.00  0.00           H  
ATOM   1224  N   VAL A  84      -0.422 -25.276  12.784  1.00  0.00           N  
ATOM   1225  CA  VAL A  84      -1.357 -26.310  12.259  1.00  0.00           C  
ATOM   1226  C   VAL A  84      -1.801 -27.214  13.410  1.00  0.00           C  
ATOM   1227  O   VAL A  84      -0.988 -27.793  14.100  1.00  0.00           O  
ATOM   1228  CB  VAL A  84      -0.663 -27.161  11.188  1.00  0.00           C  
ATOM   1229  CG1 VAL A  84      -1.652 -27.453  10.063  1.00  0.00           C  
ATOM   1230  CG2 VAL A  84       0.540 -26.413  10.612  1.00  0.00           C  
ATOM   1231  H   VAL A  84       0.400 -25.545  13.249  1.00  0.00           H  
ATOM   1232  HA  VAL A  84      -2.222 -25.826  11.828  1.00  0.00           H  
ATOM   1233  HB  VAL A  84      -0.334 -28.093  11.626  1.00  0.00           H  
ATOM   1234 HG11 VAL A  84      -2.564 -27.843  10.482  1.00  0.00           H  
ATOM   1235 HG12 VAL A  84      -1.863 -26.542   9.525  1.00  0.00           H  
ATOM   1236 HG13 VAL A  84      -1.226 -28.180   9.387  1.00  0.00           H  
ATOM   1237 HG21 VAL A  84       1.229 -26.174  11.408  1.00  0.00           H  
ATOM   1238 HG22 VAL A  84       1.035 -27.035   9.882  1.00  0.00           H  
ATOM   1239 HG23 VAL A  84       0.204 -25.501  10.140  1.00  0.00           H  
ATOM   1240  N   SER A  85      -3.082 -27.337  13.624  1.00  0.00           N  
ATOM   1241  CA  SER A  85      -3.566 -28.204  14.735  1.00  0.00           C  
ATOM   1242  C   SER A  85      -4.339 -29.391  14.159  1.00  0.00           C  
ATOM   1243  O   SER A  85      -5.529 -29.317  13.925  1.00  0.00           O  
ATOM   1244  CB  SER A  85      -4.480 -27.397  15.656  1.00  0.00           C  
ATOM   1245  OG  SER A  85      -5.355 -26.600  14.869  1.00  0.00           O  
ATOM   1246  H   SER A  85      -3.723 -26.861  13.057  1.00  0.00           H  
ATOM   1247  HA  SER A  85      -2.722 -28.571  15.297  1.00  0.00           H  
ATOM   1248  HB2 SER A  85      -5.064 -28.068  16.265  1.00  0.00           H  
ATOM   1249  HB3 SER A  85      -3.879 -26.765  16.296  1.00  0.00           H  
ATOM   1250  HG  SER A  85      -5.602 -25.830  15.386  1.00  0.00           H  
ATOM   1251  N   PHE A  86      -3.670 -30.488  13.935  1.00  0.00           N  
ATOM   1252  CA  PHE A  86      -4.362 -31.682  13.382  1.00  0.00           C  
ATOM   1253  C   PHE A  86      -4.324 -32.809  14.419  1.00  0.00           C  
ATOM   1254  O   PHE A  86      -3.762 -32.659  15.486  1.00  0.00           O  
ATOM   1255  CB  PHE A  86      -3.662 -32.125  12.097  1.00  0.00           C  
ATOM   1256  CG  PHE A  86      -2.329 -32.752  12.431  1.00  0.00           C  
ATOM   1257  CD1 PHE A  86      -1.255 -31.943  12.819  1.00  0.00           C  
ATOM   1258  CD2 PHE A  86      -2.168 -34.140  12.353  1.00  0.00           C  
ATOM   1259  CE1 PHE A  86      -0.018 -32.523  13.130  1.00  0.00           C  
ATOM   1260  CE2 PHE A  86      -0.932 -34.719  12.664  1.00  0.00           C  
ATOM   1261  CZ  PHE A  86       0.143 -33.911  13.052  1.00  0.00           C  
ATOM   1262  H   PHE A  86      -2.712 -30.526  14.136  1.00  0.00           H  
ATOM   1263  HA  PHE A  86      -5.391 -31.431  13.163  1.00  0.00           H  
ATOM   1264  HB2 PHE A  86      -4.280 -32.841  11.580  1.00  0.00           H  
ATOM   1265  HB3 PHE A  86      -3.504 -31.268  11.462  1.00  0.00           H  
ATOM   1266  HD1 PHE A  86      -1.378 -30.871  12.876  1.00  0.00           H  
ATOM   1267  HD2 PHE A  86      -2.997 -34.763  12.052  1.00  0.00           H  
ATOM   1268  HE1 PHE A  86       0.811 -31.898  13.429  1.00  0.00           H  
ATOM   1269  HE2 PHE A  86      -0.807 -35.791  12.604  1.00  0.00           H  
ATOM   1270  HZ  PHE A  86       1.096 -34.359  13.292  1.00  0.00           H  
ATOM   1271  N   GLU A  87      -4.922 -33.931  14.124  1.00  0.00           N  
ATOM   1272  CA  GLU A  87      -4.923 -35.052  15.108  1.00  0.00           C  
ATOM   1273  C   GLU A  87      -3.985 -36.166  14.638  1.00  0.00           C  
ATOM   1274  O   GLU A  87      -3.551 -36.192  13.504  1.00  0.00           O  
ATOM   1275  CB  GLU A  87      -6.343 -35.607  15.242  1.00  0.00           C  
ATOM   1276  CG  GLU A  87      -6.346 -36.769  16.237  1.00  0.00           C  
ATOM   1277  CD  GLU A  87      -7.786 -37.096  16.636  1.00  0.00           C  
ATOM   1278  OE1 GLU A  87      -8.265 -36.504  17.590  1.00  0.00           O  
ATOM   1279  OE2 GLU A  87      -8.385 -37.932  15.981  1.00  0.00           O  
ATOM   1280  H   GLU A  87      -5.379 -34.033  13.262  1.00  0.00           H  
ATOM   1281  HA  GLU A  87      -4.592 -34.685  16.068  1.00  0.00           H  
ATOM   1282  HB2 GLU A  87      -7.003 -34.827  15.595  1.00  0.00           H  
ATOM   1283  HB3 GLU A  87      -6.684 -35.959  14.280  1.00  0.00           H  
ATOM   1284  HG2 GLU A  87      -5.892 -37.636  15.781  1.00  0.00           H  
ATOM   1285  HG3 GLU A  87      -5.786 -36.491  17.117  1.00  0.00           H  
ATOM   1286  N   PHE A  88      -3.674 -37.093  15.506  1.00  0.00           N  
ATOM   1287  CA  PHE A  88      -2.770 -38.210  15.116  1.00  0.00           C  
ATOM   1288  C   PHE A  88      -3.531 -39.536  15.207  1.00  0.00           C  
ATOM   1289  O   PHE A  88      -4.745 -39.566  15.218  1.00  0.00           O  
ATOM   1290  CB  PHE A  88      -1.569 -38.248  16.059  1.00  0.00           C  
ATOM   1291  CG  PHE A  88      -0.291 -38.122  15.263  1.00  0.00           C  
ATOM   1292  CD1 PHE A  88      -0.195 -38.709  13.995  1.00  0.00           C  
ATOM   1293  CD2 PHE A  88       0.797 -37.419  15.793  1.00  0.00           C  
ATOM   1294  CE1 PHE A  88       0.991 -38.594  13.258  1.00  0.00           C  
ATOM   1295  CE2 PHE A  88       1.982 -37.303  15.056  1.00  0.00           C  
ATOM   1296  CZ  PHE A  88       2.079 -37.891  13.789  1.00  0.00           C  
ATOM   1297  H   PHE A  88      -4.037 -37.053  16.415  1.00  0.00           H  
ATOM   1298  HA  PHE A  88      -2.428 -38.061  14.108  1.00  0.00           H  
ATOM   1299  HB2 PHE A  88      -1.638 -37.431  16.760  1.00  0.00           H  
ATOM   1300  HB3 PHE A  88      -1.566 -39.183  16.595  1.00  0.00           H  
ATOM   1301  HD1 PHE A  88      -1.034 -39.252  13.586  1.00  0.00           H  
ATOM   1302  HD2 PHE A  88       0.721 -36.965  16.770  1.00  0.00           H  
ATOM   1303  HE1 PHE A  88       1.065 -39.046  12.281  1.00  0.00           H  
ATOM   1304  HE2 PHE A  88       2.821 -36.760  15.467  1.00  0.00           H  
ATOM   1305  HZ  PHE A  88       2.993 -37.801  13.222  1.00  0.00           H  
ATOM   1306  N   GLN A  89      -2.825 -40.632  15.269  1.00  0.00           N  
ATOM   1307  CA  GLN A  89      -3.509 -41.954  15.356  1.00  0.00           C  
ATOM   1308  C   GLN A  89      -4.217 -42.083  16.707  1.00  0.00           C  
ATOM   1309  O   GLN A  89      -4.949 -43.024  16.946  1.00  0.00           O  
ATOM   1310  CB  GLN A  89      -2.479 -43.073  15.213  1.00  0.00           C  
ATOM   1311  CG  GLN A  89      -1.298 -42.772  16.125  1.00  0.00           C  
ATOM   1312  CD  GLN A  89      -0.009 -42.724  15.300  1.00  0.00           C  
ATOM   1313  OE1 GLN A  89       0.009 -43.134  14.157  1.00  0.00           O  
ATOM   1314  NE2 GLN A  89       1.077 -42.239  15.836  1.00  0.00           N  
ATOM   1315  H   GLN A  89      -1.847 -40.586  15.257  1.00  0.00           H  
ATOM   1316  HA  GLN A  89      -4.232 -42.032  14.566  1.00  0.00           H  
ATOM   1317  HB2 GLN A  89      -2.926 -44.016  15.497  1.00  0.00           H  
ATOM   1318  HB3 GLN A  89      -2.139 -43.125  14.190  1.00  0.00           H  
ATOM   1319  HG2 GLN A  89      -1.460 -41.817  16.599  1.00  0.00           H  
ATOM   1320  HG3 GLN A  89      -1.215 -43.541  16.877  1.00  0.00           H  
ATOM   1321 HE21 GLN A  89       1.063 -41.908  16.758  1.00  0.00           H  
ATOM   1322 HE22 GLN A  89       1.906 -42.204  15.315  1.00  0.00           H  
ATOM   1323  N   GLY A  90      -4.007 -41.150  17.594  1.00  0.00           N  
ATOM   1324  CA  GLY A  90      -4.672 -41.230  18.926  1.00  0.00           C  
ATOM   1325  C   GLY A  90      -4.469 -39.917  19.686  1.00  0.00           C  
ATOM   1326  O   GLY A  90      -5.366 -39.425  20.342  1.00  0.00           O  
ATOM   1327  H   GLY A  90      -3.413 -40.399  17.386  1.00  0.00           H  
ATOM   1328  HA2 GLY A  90      -5.729 -41.409  18.790  1.00  0.00           H  
ATOM   1329  HA3 GLY A  90      -4.242 -42.041  19.495  1.00  0.00           H  
ATOM   1330  N   ARG A  91      -3.298 -39.347  19.607  1.00  0.00           N  
ATOM   1331  CA  ARG A  91      -3.041 -38.067  20.327  1.00  0.00           C  
ATOM   1332  C   ARG A  91      -3.255 -36.890  19.374  1.00  0.00           C  
ATOM   1333  O   ARG A  91      -3.635 -37.062  18.233  1.00  0.00           O  
ATOM   1334  CB  ARG A  91      -1.601 -38.051  20.839  1.00  0.00           C  
ATOM   1335  CG  ARG A  91      -1.563 -38.566  22.279  1.00  0.00           C  
ATOM   1336  CD  ARG A  91      -0.153 -38.389  22.847  1.00  0.00           C  
ATOM   1337  NE  ARG A  91       0.092 -39.413  23.901  1.00  0.00           N  
ATOM   1338  CZ  ARG A  91      -0.744 -39.540  24.895  1.00  0.00           C  
ATOM   1339  NH1 ARG A  91      -0.639 -38.766  25.941  1.00  0.00           N  
ATOM   1340  NH2 ARG A  91      -1.687 -40.441  24.844  1.00  0.00           N  
ATOM   1341  H   ARG A  91      -2.586 -39.760  19.074  1.00  0.00           H  
ATOM   1342  HA  ARG A  91      -3.722 -37.982  21.162  1.00  0.00           H  
ATOM   1343  HB2 ARG A  91      -0.990 -38.684  20.213  1.00  0.00           H  
ATOM   1344  HB3 ARG A  91      -1.220 -37.041  20.812  1.00  0.00           H  
ATOM   1345  HG2 ARG A  91      -2.268 -38.010  22.880  1.00  0.00           H  
ATOM   1346  HG3 ARG A  91      -1.825 -39.614  22.294  1.00  0.00           H  
ATOM   1347  HD2 ARG A  91       0.571 -38.506  22.055  1.00  0.00           H  
ATOM   1348  HD3 ARG A  91      -0.061 -37.401  23.275  1.00  0.00           H  
ATOM   1349  HE  ARG A  91       0.881 -39.991  23.847  1.00  0.00           H  
ATOM   1350 HH11 ARG A  91       0.083 -38.074  25.981  1.00  0.00           H  
ATOM   1351 HH12 ARG A  91      -1.279 -38.864  26.702  1.00  0.00           H  
ATOM   1352 HH21 ARG A  91      -1.768 -41.036  24.043  1.00  0.00           H  
ATOM   1353 HH22 ARG A  91      -2.327 -40.539  25.606  1.00  0.00           H  
ATOM   1354  N   LYS A  92      -3.009 -35.692  19.833  1.00  0.00           N  
ATOM   1355  CA  LYS A  92      -3.195 -34.502  18.955  1.00  0.00           C  
ATOM   1356  C   LYS A  92      -1.842 -33.823  18.724  1.00  0.00           C  
ATOM   1357  O   LYS A  92      -1.127 -33.510  19.655  1.00  0.00           O  
ATOM   1358  CB  LYS A  92      -4.151 -33.517  19.629  1.00  0.00           C  
ATOM   1359  CG  LYS A  92      -3.479 -32.916  20.863  1.00  0.00           C  
ATOM   1360  CD  LYS A  92      -2.786 -31.606  20.481  1.00  0.00           C  
ATOM   1361  CE  LYS A  92      -3.317 -30.471  21.361  1.00  0.00           C  
ATOM   1362  NZ  LYS A  92      -2.189 -29.505  21.462  1.00  0.00           N  
ATOM   1363  H   LYS A  92      -2.702 -35.576  20.758  1.00  0.00           H  
ATOM   1364  HA  LYS A  92      -3.608 -34.815  18.007  1.00  0.00           H  
ATOM   1365  HB2 LYS A  92      -4.404 -32.729  18.935  1.00  0.00           H  
ATOM   1366  HB3 LYS A  92      -5.050 -34.036  19.928  1.00  0.00           H  
ATOM   1367  HG2 LYS A  92      -4.224 -32.723  21.622  1.00  0.00           H  
ATOM   1368  HG3 LYS A  92      -2.745 -33.609  21.247  1.00  0.00           H  
ATOM   1369  HD2 LYS A  92      -1.721 -31.706  20.625  1.00  0.00           H  
ATOM   1370  HD3 LYS A  92      -2.992 -31.380  19.445  1.00  0.00           H  
ATOM   1371  HE2 LYS A  92      -4.174 -30.005  20.895  1.00  0.00           H  
ATOM   1372  HE3 LYS A  92      -3.574 -30.842  22.341  1.00  0.00           H  
ATOM   1373  HZ1 LYS A  92      -1.288 -30.026  21.492  1.00  0.00           H  
ATOM   1374  HZ2 LYS A  92      -2.198 -28.873  20.636  1.00  0.00           H  
ATOM   1375  HZ3 LYS A  92      -2.292 -28.939  22.327  1.00  0.00           H  
ATOM   1376  N   THR A  93      -1.481 -33.600  17.489  1.00  0.00           N  
ATOM   1377  CA  THR A  93      -0.174 -32.949  17.199  1.00  0.00           C  
ATOM   1378  C   THR A  93      -0.406 -31.621  16.472  1.00  0.00           C  
ATOM   1379  O   THR A  93      -1.286 -31.502  15.642  1.00  0.00           O  
ATOM   1380  CB  THR A  93       0.656 -33.872  16.310  1.00  0.00           C  
ATOM   1381  OG1 THR A  93      -0.114 -35.015  15.966  1.00  0.00           O  
ATOM   1382  CG2 THR A  93       1.911 -34.307  17.063  1.00  0.00           C  
ATOM   1383  H   THR A  93      -2.066 -33.865  16.751  1.00  0.00           H  
ATOM   1384  HA  THR A  93       0.355 -32.769  18.124  1.00  0.00           H  
ATOM   1385  HB  THR A  93       0.943 -33.347  15.413  1.00  0.00           H  
ATOM   1386  HG1 THR A  93      -0.382 -35.448  16.780  1.00  0.00           H  
ATOM   1387 HG21 THR A  93       1.753 -34.183  18.124  1.00  0.00           H  
ATOM   1388 HG22 THR A  93       2.118 -35.345  16.848  1.00  0.00           H  
ATOM   1389 HG23 THR A  93       2.748 -33.700  16.750  1.00  0.00           H  
ATOM   1390  N   VAL A  94       0.381 -30.624  16.772  1.00  0.00           N  
ATOM   1391  CA  VAL A  94       0.217 -29.311  16.099  1.00  0.00           C  
ATOM   1392  C   VAL A  94       1.491 -29.024  15.282  1.00  0.00           C  
ATOM   1393  O   VAL A  94       2.446 -29.773  15.333  1.00  0.00           O  
ATOM   1394  CB  VAL A  94      -0.028 -28.239  17.182  1.00  0.00           C  
ATOM   1395  CG1 VAL A  94       0.932 -27.058  17.027  1.00  0.00           C  
ATOM   1396  CG2 VAL A  94      -1.466 -27.729  17.071  1.00  0.00           C  
ATOM   1397  H   VAL A  94       1.087 -30.738  17.439  1.00  0.00           H  
ATOM   1398  HA  VAL A  94      -0.633 -29.356  15.435  1.00  0.00           H  
ATOM   1399  HB  VAL A  94       0.116 -28.683  18.157  1.00  0.00           H  
ATOM   1400 HG11 VAL A  94       1.938 -27.427  16.923  1.00  0.00           H  
ATOM   1401 HG12 VAL A  94       0.663 -26.491  16.151  1.00  0.00           H  
ATOM   1402 HG13 VAL A  94       0.869 -26.429  17.901  1.00  0.00           H  
ATOM   1403 HG21 VAL A  94      -1.620 -27.298  16.094  1.00  0.00           H  
ATOM   1404 HG22 VAL A  94      -2.151 -28.551  17.216  1.00  0.00           H  
ATOM   1405 HG23 VAL A  94      -1.641 -26.977  17.827  1.00  0.00           H  
ATOM   1406  N   VAL A  95       1.515 -27.956  14.532  1.00  0.00           N  
ATOM   1407  CA  VAL A  95       2.733 -27.650  13.723  1.00  0.00           C  
ATOM   1408  C   VAL A  95       2.937 -26.133  13.648  1.00  0.00           C  
ATOM   1409  O   VAL A  95       1.994 -25.368  13.593  1.00  0.00           O  
ATOM   1410  CB  VAL A  95       2.564 -28.243  12.318  1.00  0.00           C  
ATOM   1411  CG1 VAL A  95       3.468 -27.519  11.316  1.00  0.00           C  
ATOM   1412  CG2 VAL A  95       2.947 -29.720  12.354  1.00  0.00           C  
ATOM   1413  H   VAL A  95       0.738 -27.359  14.495  1.00  0.00           H  
ATOM   1414  HA  VAL A  95       3.593 -28.100  14.197  1.00  0.00           H  
ATOM   1415  HB  VAL A  95       1.534 -28.146  12.008  1.00  0.00           H  
ATOM   1416 HG11 VAL A  95       4.228 -26.968  11.849  1.00  0.00           H  
ATOM   1417 HG12 VAL A  95       3.937 -28.242  10.664  1.00  0.00           H  
ATOM   1418 HG13 VAL A  95       2.873 -26.837  10.727  1.00  0.00           H  
ATOM   1419 HG21 VAL A  95       3.205 -29.997  13.365  1.00  0.00           H  
ATOM   1420 HG22 VAL A  95       2.112 -30.317  12.019  1.00  0.00           H  
ATOM   1421 HG23 VAL A  95       3.795 -29.887  11.706  1.00  0.00           H  
ATOM   1422  N   ALA A  96       4.170 -25.694  13.658  1.00  0.00           N  
ATOM   1423  CA  ALA A  96       4.440 -24.223  13.599  1.00  0.00           C  
ATOM   1424  C   ALA A  96       5.525 -23.920  12.561  1.00  0.00           C  
ATOM   1425  O   ALA A  96       6.635 -23.576  12.912  1.00  0.00           O  
ATOM   1426  CB  ALA A  96       4.923 -23.743  14.969  1.00  0.00           C  
ATOM   1427  H   ALA A  96       4.914 -26.333  13.712  1.00  0.00           H  
ATOM   1428  HA  ALA A  96       3.533 -23.700  13.336  1.00  0.00           H  
ATOM   1429  HB1 ALA A  96       5.824 -24.275  15.238  1.00  0.00           H  
ATOM   1430  HB2 ALA A  96       5.128 -22.685  14.927  1.00  0.00           H  
ATOM   1431  HB3 ALA A  96       4.159 -23.934  15.707  1.00  0.00           H  
ATOM   1432  N   PRO A  97       5.168 -24.057  11.313  1.00  0.00           N  
ATOM   1433  CA  PRO A  97       6.110 -23.796  10.210  1.00  0.00           C  
ATOM   1434  C   PRO A  97       5.952 -22.367   9.682  1.00  0.00           C  
ATOM   1435  O   PRO A  97       5.170 -21.585  10.187  1.00  0.00           O  
ATOM   1436  CB  PRO A  97       5.656 -24.795   9.151  1.00  0.00           C  
ATOM   1437  CG  PRO A  97       4.202 -25.071   9.446  1.00  0.00           C  
ATOM   1438  CD  PRO A  97       3.871 -24.474  10.800  1.00  0.00           C  
ATOM   1439  HA  PRO A  97       7.125 -24.000  10.503  1.00  0.00           H  
ATOM   1440  HB2 PRO A  97       5.764 -24.364   8.164  1.00  0.00           H  
ATOM   1441  HB3 PRO A  97       6.226 -25.706   9.226  1.00  0.00           H  
ATOM   1442  HG2 PRO A  97       3.583 -24.619   8.684  1.00  0.00           H  
ATOM   1443  HG3 PRO A  97       4.033 -26.135   9.469  1.00  0.00           H  
ATOM   1444  HD2 PRO A  97       3.214 -23.623  10.686  1.00  0.00           H  
ATOM   1445  HD3 PRO A  97       3.432 -25.212  11.449  1.00  0.00           H  
ATOM   1446  N   ILE A  98       6.678 -22.035   8.651  1.00  0.00           N  
ATOM   1447  CA  ILE A  98       6.569 -20.674   8.054  1.00  0.00           C  
ATOM   1448  C   ILE A  98       6.570 -20.819   6.531  1.00  0.00           C  
ATOM   1449  O   ILE A  98       7.295 -21.623   5.982  1.00  0.00           O  
ATOM   1450  CB  ILE A  98       7.752 -19.808   8.489  1.00  0.00           C  
ATOM   1451  CG1 ILE A  98       7.803 -19.751  10.017  1.00  0.00           C  
ATOM   1452  CG2 ILE A  98       7.579 -18.391   7.932  1.00  0.00           C  
ATOM   1453  CD1 ILE A  98       9.015 -20.538  10.517  1.00  0.00           C  
ATOM   1454  H   ILE A  98       7.286 -22.692   8.253  1.00  0.00           H  
ATOM   1455  HA  ILE A  98       5.645 -20.214   8.373  1.00  0.00           H  
ATOM   1456  HB  ILE A  98       8.668 -20.237   8.111  1.00  0.00           H  
ATOM   1457 HG12 ILE A  98       7.885 -18.722  10.337  1.00  0.00           H  
ATOM   1458 HG13 ILE A  98       6.903 -20.185  10.424  1.00  0.00           H  
ATOM   1459 HG21 ILE A  98       6.602 -18.016   8.196  1.00  0.00           H  
ATOM   1460 HG22 ILE A  98       8.336 -17.743   8.348  1.00  0.00           H  
ATOM   1461 HG23 ILE A  98       7.676 -18.411   6.855  1.00  0.00           H  
ATOM   1462 HD11 ILE A  98       9.043 -21.501  10.029  1.00  0.00           H  
ATOM   1463 HD12 ILE A  98       9.918 -19.992  10.291  1.00  0.00           H  
ATOM   1464 HD13 ILE A  98       8.936 -20.679  11.586  1.00  0.00           H  
ATOM   1465  N   ASP A  99       5.760 -20.066   5.841  1.00  0.00           N  
ATOM   1466  CA  ASP A  99       5.720 -20.192   4.364  1.00  0.00           C  
ATOM   1467  C   ASP A  99       6.278 -18.931   3.710  1.00  0.00           C  
ATOM   1468  O   ASP A  99       6.389 -17.889   4.327  1.00  0.00           O  
ATOM   1469  CB  ASP A  99       4.281 -20.391   3.924  1.00  0.00           C  
ATOM   1470  CG  ASP A  99       4.242 -21.254   2.661  1.00  0.00           C  
ATOM   1471  OD1 ASP A  99       5.250 -21.868   2.354  1.00  0.00           O  
ATOM   1472  OD2 ASP A  99       3.060 -21.284   1.946  1.00  0.00           O  
ATOM   1473  H   ASP A  99       5.169 -19.426   6.293  1.00  0.00           H  
ATOM   1474  HA  ASP A  99       6.297 -21.039   4.058  1.00  0.00           H  
ATOM   1475  HB2 ASP A  99       3.727 -20.877   4.713  1.00  0.00           H  
ATOM   1476  HB3 ASP A  99       3.853 -19.435   3.719  1.00  0.00           H  
ATOM   1477  HD2 ASP A  99       2.380 -21.653   2.514  1.00  0.00           H  
ATOM   1478  N   HIS A 100       6.620 -19.019   2.455  1.00  0.00           N  
ATOM   1479  CA  HIS A 100       7.161 -17.833   1.739  1.00  0.00           C  
ATOM   1480  C   HIS A 100       6.198 -17.458   0.618  1.00  0.00           C  
ATOM   1481  O   HIS A 100       5.203 -18.121   0.400  1.00  0.00           O  
ATOM   1482  CB  HIS A 100       8.534 -18.165   1.152  1.00  0.00           C  
ATOM   1483  CG  HIS A 100       9.387 -16.926   1.141  1.00  0.00           C  
ATOM   1484  ND1 HIS A 100       9.537 -16.143   0.008  1.00  0.00           N  
ATOM   1485  CD2 HIS A 100      10.139 -16.323   2.118  1.00  0.00           C  
ATOM   1486  CE1 HIS A 100      10.351 -15.120   0.328  1.00  0.00           C  
ATOM   1487  NE2 HIS A 100      10.748 -15.182   1.603  1.00  0.00           N  
ATOM   1488  H   HIS A 100       6.512 -19.870   1.980  1.00  0.00           H  
ATOM   1489  HA  HIS A 100       7.247 -17.003   2.424  1.00  0.00           H  
ATOM   1490  HB2 HIS A 100       9.009 -18.924   1.756  1.00  0.00           H  
ATOM   1491  HB3 HIS A 100       8.417 -18.529   0.143  1.00  0.00           H  
ATOM   1492  HD1 HIS A 100       9.126 -16.304  -0.866  1.00  0.00           H  
ATOM   1493  HD2 HIS A 100      10.242 -16.678   3.132  1.00  0.00           H  
ATOM   1494  HE1 HIS A 100      10.649 -14.344  -0.362  1.00  0.00           H  
ATOM   1495  N   PHE A 101       6.461 -16.392  -0.083  1.00  0.00           N  
ATOM   1496  CA  PHE A 101       5.532 -15.988  -1.159  1.00  0.00           C  
ATOM   1497  C   PHE A 101       6.287 -15.267  -2.278  1.00  0.00           C  
ATOM   1498  O   PHE A 101       7.205 -14.508  -2.037  1.00  0.00           O  
ATOM   1499  CB  PHE A 101       4.497 -15.056  -0.557  1.00  0.00           C  
ATOM   1500  CG  PHE A 101       3.138 -15.701  -0.648  1.00  0.00           C  
ATOM   1501  CD1 PHE A 101       2.737 -16.312  -1.840  1.00  0.00           C  
ATOM   1502  CD2 PHE A 101       2.286 -15.697   0.460  1.00  0.00           C  
ATOM   1503  CE1 PHE A 101       1.478 -16.920  -1.925  1.00  0.00           C  
ATOM   1504  CE2 PHE A 101       1.027 -16.303   0.377  1.00  0.00           C  
ATOM   1505  CZ  PHE A 101       0.623 -16.914  -0.816  1.00  0.00           C  
ATOM   1506  H   PHE A 101       7.250 -15.850   0.112  1.00  0.00           H  
ATOM   1507  HA  PHE A 101       5.038 -16.859  -1.556  1.00  0.00           H  
ATOM   1508  HB2 PHE A 101       4.740 -14.877   0.479  1.00  0.00           H  
ATOM   1509  HB3 PHE A 101       4.502 -14.125  -1.094  1.00  0.00           H  
ATOM   1510  HD1 PHE A 101       3.399 -16.318  -2.693  1.00  0.00           H  
ATOM   1511  HD2 PHE A 101       2.600 -15.225   1.382  1.00  0.00           H  
ATOM   1512  HE1 PHE A 101       1.167 -17.391  -2.845  1.00  0.00           H  
ATOM   1513  HE2 PHE A 101       0.369 -16.302   1.232  1.00  0.00           H  
ATOM   1514  HZ  PHE A 101      -0.348 -17.384  -0.881  1.00  0.00           H  
ATOM   1515  N   ARG A 102       5.896 -15.498  -3.503  1.00  0.00           N  
ATOM   1516  CA  ARG A 102       6.574 -14.829  -4.649  1.00  0.00           C  
ATOM   1517  C   ARG A 102       5.514 -14.319  -5.629  1.00  0.00           C  
ATOM   1518  O   ARG A 102       4.881 -15.086  -6.326  1.00  0.00           O  
ATOM   1519  CB  ARG A 102       7.481 -15.832  -5.361  1.00  0.00           C  
ATOM   1520  CG  ARG A 102       8.876 -15.232  -5.536  1.00  0.00           C  
ATOM   1521  CD  ARG A 102       9.677 -16.084  -6.524  1.00  0.00           C  
ATOM   1522  NE  ARG A 102      10.047 -17.373  -5.875  1.00  0.00           N  
ATOM   1523  CZ  ARG A 102      10.803 -18.229  -6.505  1.00  0.00           C  
ATOM   1524  NH1 ARG A 102      10.851 -18.222  -7.809  1.00  0.00           N  
ATOM   1525  NH2 ARG A 102      11.510 -19.092  -5.829  1.00  0.00           N  
ATOM   1526  H   ARG A 102       5.150 -16.113  -3.667  1.00  0.00           H  
ATOM   1527  HA  ARG A 102       7.163 -13.999  -4.288  1.00  0.00           H  
ATOM   1528  HB2 ARG A 102       7.548 -16.737  -4.775  1.00  0.00           H  
ATOM   1529  HB3 ARG A 102       7.068 -16.061  -6.332  1.00  0.00           H  
ATOM   1530  HG2 ARG A 102       8.792 -14.223  -5.913  1.00  0.00           H  
ATOM   1531  HG3 ARG A 102       9.384 -15.220  -4.585  1.00  0.00           H  
ATOM   1532  HD2 ARG A 102       9.076 -16.279  -7.398  1.00  0.00           H  
ATOM   1533  HD3 ARG A 102      10.574 -15.554  -6.811  1.00  0.00           H  
ATOM   1534  HE  ARG A 102       9.723 -17.577  -4.972  1.00  0.00           H  
ATOM   1535 HH11 ARG A 102      10.309 -17.560  -8.327  1.00  0.00           H  
ATOM   1536 HH12 ARG A 102      11.430 -18.880  -8.292  1.00  0.00           H  
ATOM   1537 HH21 ARG A 102      11.472 -19.097  -4.829  1.00  0.00           H  
ATOM   1538 HH22 ARG A 102      12.089 -19.750  -6.309  1.00  0.00           H  
ATOM   1539  N   PHE A 103       5.311 -13.031  -5.684  1.00  0.00           N  
ATOM   1540  CA  PHE A 103       4.288 -12.475  -6.616  1.00  0.00           C  
ATOM   1541  C   PHE A 103       4.983 -11.821  -7.812  1.00  0.00           C  
ATOM   1542  O   PHE A 103       6.195 -11.796  -7.899  1.00  0.00           O  
ATOM   1543  CB  PHE A 103       3.449 -11.430  -5.879  1.00  0.00           C  
ATOM   1544  CG  PHE A 103       2.915 -12.032  -4.602  1.00  0.00           C  
ATOM   1545  CD1 PHE A 103       2.480 -13.361  -4.587  1.00  0.00           C  
ATOM   1546  CD2 PHE A 103       2.858 -11.262  -3.433  1.00  0.00           C  
ATOM   1547  CE1 PHE A 103       1.986 -13.922  -3.404  1.00  0.00           C  
ATOM   1548  CE2 PHE A 103       2.364 -11.823  -2.251  1.00  0.00           C  
ATOM   1549  CZ  PHE A 103       1.928 -13.153  -2.236  1.00  0.00           C  
ATOM   1550  H   PHE A 103       5.830 -12.428  -5.110  1.00  0.00           H  
ATOM   1551  HA  PHE A 103       3.644 -13.273  -6.962  1.00  0.00           H  
ATOM   1552  HB2 PHE A 103       4.064 -10.573  -5.645  1.00  0.00           H  
ATOM   1553  HB3 PHE A 103       2.624 -11.123  -6.503  1.00  0.00           H  
ATOM   1554  HD1 PHE A 103       2.524 -13.955  -5.488  1.00  0.00           H  
ATOM   1555  HD2 PHE A 103       3.195 -10.236  -3.445  1.00  0.00           H  
ATOM   1556  HE1 PHE A 103       1.648 -14.948  -3.394  1.00  0.00           H  
ATOM   1557  HE2 PHE A 103       2.319 -11.231  -1.349  1.00  0.00           H  
ATOM   1558  HZ  PHE A 103       1.547 -13.586  -1.323  1.00  0.00           H  
ATOM   1559  N   ASN A 104       4.228 -11.290  -8.735  1.00  0.00           N  
ATOM   1560  CA  ASN A 104       4.849 -10.639  -9.923  1.00  0.00           C  
ATOM   1561  C   ASN A 104       4.294  -9.221 -10.080  1.00  0.00           C  
ATOM   1562  O   ASN A 104       4.669  -8.496 -10.981  1.00  0.00           O  
ATOM   1563  CB  ASN A 104       4.529 -11.451 -11.180  1.00  0.00           C  
ATOM   1564  CG  ASN A 104       3.031 -11.361 -11.479  1.00  0.00           C  
ATOM   1565  OD1 ASN A 104       2.619 -10.644 -12.368  1.00  0.00           O  
ATOM   1566  ND2 ASN A 104       2.193 -12.065 -10.767  1.00  0.00           N  
ATOM   1567  H   ASN A 104       3.252 -11.320  -8.647  1.00  0.00           H  
ATOM   1568  HA  ASN A 104       5.920 -10.592  -9.788  1.00  0.00           H  
ATOM   1569  HB2 ASN A 104       5.087 -11.055 -12.016  1.00  0.00           H  
ATOM   1570  HB3 ASN A 104       4.801 -12.483 -11.022  1.00  0.00           H  
ATOM   1571 HD21 ASN A 104       2.525 -12.644 -10.050  1.00  0.00           H  
ATOM   1572 HD22 ASN A 104       1.231 -12.015 -10.951  1.00  0.00           H  
ATOM   1573  N   GLY A 105       3.403  -8.818  -9.216  1.00  0.00           N  
ATOM   1574  CA  GLY A 105       2.830  -7.446  -9.326  1.00  0.00           C  
ATOM   1575  C   GLY A 105       1.902  -7.176  -8.141  1.00  0.00           C  
ATOM   1576  O   GLY A 105       2.312  -6.646  -7.128  1.00  0.00           O  
ATOM   1577  H   GLY A 105       3.111  -9.416  -8.496  1.00  0.00           H  
ATOM   1578  HA2 GLY A 105       3.631  -6.721  -9.330  1.00  0.00           H  
ATOM   1579  HA3 GLY A 105       2.267  -7.365 -10.243  1.00  0.00           H  
ATOM   1580  N   ALA A 106       0.653  -7.536  -8.257  1.00  0.00           N  
ATOM   1581  CA  ALA A 106      -0.297  -7.297  -7.136  1.00  0.00           C  
ATOM   1582  C   ALA A 106      -1.707  -7.716  -7.559  1.00  0.00           C  
ATOM   1583  O   ALA A 106      -2.686  -7.103  -7.183  1.00  0.00           O  
ATOM   1584  CB  ALA A 106      -0.295  -5.810  -6.777  1.00  0.00           C  
ATOM   1585  H   ALA A 106       0.340  -7.962  -9.082  1.00  0.00           H  
ATOM   1586  HA  ALA A 106       0.008  -7.876  -6.278  1.00  0.00           H  
ATOM   1587  HB1 ALA A 106       0.201  -5.253  -7.557  1.00  0.00           H  
ATOM   1588  HB2 ALA A 106      -1.313  -5.463  -6.676  1.00  0.00           H  
ATOM   1589  HB3 ALA A 106       0.228  -5.667  -5.843  1.00  0.00           H  
ATOM   1590  N   GLY A 107      -1.819  -8.758  -8.335  1.00  0.00           N  
ATOM   1591  CA  GLY A 107      -3.166  -9.214  -8.779  1.00  0.00           C  
ATOM   1592  C   GLY A 107      -3.329 -10.702  -8.465  1.00  0.00           C  
ATOM   1593  O   GLY A 107      -4.392 -11.156  -8.091  1.00  0.00           O  
ATOM   1594  H   GLY A 107      -1.017  -9.240  -8.627  1.00  0.00           H  
ATOM   1595  HA2 GLY A 107      -3.926  -8.650  -8.257  1.00  0.00           H  
ATOM   1596  HA3 GLY A 107      -3.267  -9.062  -9.842  1.00  0.00           H  
ATOM   1597  N   LYS A 108      -2.281 -11.464  -8.612  1.00  0.00           N  
ATOM   1598  CA  LYS A 108      -2.374 -12.922  -8.322  1.00  0.00           C  
ATOM   1599  C   LYS A 108      -1.037 -13.411  -7.764  1.00  0.00           C  
ATOM   1600  O   LYS A 108      -0.198 -12.628  -7.363  1.00  0.00           O  
ATOM   1601  CB  LYS A 108      -2.696 -13.681  -9.611  1.00  0.00           C  
ATOM   1602  CG  LYS A 108      -3.566 -12.808 -10.517  1.00  0.00           C  
ATOM   1603  CD  LYS A 108      -4.248 -13.684 -11.569  1.00  0.00           C  
ATOM   1604  CE  LYS A 108      -3.322 -13.848 -12.777  1.00  0.00           C  
ATOM   1605  NZ  LYS A 108      -3.068 -12.462 -13.257  1.00  0.00           N  
ATOM   1606  H   LYS A 108      -1.433 -11.077  -8.914  1.00  0.00           H  
ATOM   1607  HA  LYS A 108      -3.153 -13.096  -7.595  1.00  0.00           H  
ATOM   1608  HB2 LYS A 108      -1.777 -13.929 -10.122  1.00  0.00           H  
ATOM   1609  HB3 LYS A 108      -3.230 -14.589  -9.369  1.00  0.00           H  
ATOM   1610  HG2 LYS A 108      -4.315 -12.307  -9.922  1.00  0.00           H  
ATOM   1611  HG3 LYS A 108      -2.947 -12.074 -11.011  1.00  0.00           H  
ATOM   1612  HD2 LYS A 108      -4.464 -14.654 -11.144  1.00  0.00           H  
ATOM   1613  HD3 LYS A 108      -5.170 -13.216 -11.885  1.00  0.00           H  
ATOM   1614  HE2 LYS A 108      -2.397 -14.321 -12.477  1.00  0.00           H  
ATOM   1615  HE3 LYS A 108      -3.809 -14.424 -13.549  1.00  0.00           H  
ATOM   1616  HZ1 LYS A 108      -3.887 -11.861 -13.034  1.00  0.00           H  
ATOM   1617  HZ2 LYS A 108      -2.220 -12.082 -12.787  1.00  0.00           H  
ATOM   1618  HZ3 LYS A 108      -2.919 -12.472 -14.286  1.00  0.00           H  
ATOM   1619  N   VAL A 109      -0.830 -14.698  -7.738  1.00  0.00           N  
ATOM   1620  CA  VAL A 109       0.455 -15.232  -7.208  1.00  0.00           C  
ATOM   1621  C   VAL A 109       1.212 -15.925  -8.343  1.00  0.00           C  
ATOM   1622  O   VAL A 109       0.634 -16.318  -9.337  1.00  0.00           O  
ATOM   1623  CB  VAL A 109       0.164 -16.242  -6.098  1.00  0.00           C  
ATOM   1624  CG1 VAL A 109       1.476 -16.849  -5.601  1.00  0.00           C  
ATOM   1625  CG2 VAL A 109      -0.541 -15.531  -4.941  1.00  0.00           C  
ATOM   1626  H   VAL A 109      -1.517 -15.313  -8.068  1.00  0.00           H  
ATOM   1627  HA  VAL A 109       1.049 -14.419  -6.812  1.00  0.00           H  
ATOM   1628  HB  VAL A 109      -0.473 -17.026  -6.483  1.00  0.00           H  
ATOM   1629 HG11 VAL A 109       2.159 -16.058  -5.329  1.00  0.00           H  
ATOM   1630 HG12 VAL A 109       1.282 -17.470  -4.738  1.00  0.00           H  
ATOM   1631 HG13 VAL A 109       1.915 -17.449  -6.385  1.00  0.00           H  
ATOM   1632 HG21 VAL A 109       0.031 -14.664  -4.649  1.00  0.00           H  
ATOM   1633 HG22 VAL A 109      -1.527 -15.223  -5.255  1.00  0.00           H  
ATOM   1634 HG23 VAL A 109      -0.625 -16.206  -4.102  1.00  0.00           H  
ATOM   1635  N   VAL A 110       2.501 -16.083  -8.208  1.00  0.00           N  
ATOM   1636  CA  VAL A 110       3.282 -16.753  -9.287  1.00  0.00           C  
ATOM   1637  C   VAL A 110       4.204 -17.807  -8.673  1.00  0.00           C  
ATOM   1638  O   VAL A 110       4.180 -18.959  -9.051  1.00  0.00           O  
ATOM   1639  CB  VAL A 110       4.117 -15.716 -10.042  1.00  0.00           C  
ATOM   1640  CG1 VAL A 110       3.299 -15.159 -11.208  1.00  0.00           C  
ATOM   1641  CG2 VAL A 110       4.501 -14.572  -9.099  1.00  0.00           C  
ATOM   1642  H   VAL A 110       2.953 -15.762  -7.401  1.00  0.00           H  
ATOM   1643  HA  VAL A 110       2.600 -17.233  -9.975  1.00  0.00           H  
ATOM   1644  HB  VAL A 110       5.011 -16.186 -10.424  1.00  0.00           H  
ATOM   1645 HG11 VAL A 110       2.907 -15.977 -11.795  1.00  0.00           H  
ATOM   1646 HG12 VAL A 110       2.482 -14.569 -10.824  1.00  0.00           H  
ATOM   1647 HG13 VAL A 110       3.930 -14.541 -11.828  1.00  0.00           H  
ATOM   1648 HG21 VAL A 110       3.624 -14.231  -8.569  1.00  0.00           H  
ATOM   1649 HG22 VAL A 110       5.237 -14.920  -8.390  1.00  0.00           H  
ATOM   1650 HG23 VAL A 110       4.913 -13.756  -9.673  1.00  0.00           H  
ATOM   1651  N   SER A 111       5.012 -17.427  -7.727  1.00  0.00           N  
ATOM   1652  CA  SER A 111       5.926 -18.417  -7.094  1.00  0.00           C  
ATOM   1653  C   SER A 111       5.744 -18.364  -5.579  1.00  0.00           C  
ATOM   1654  O   SER A 111       5.297 -17.375  -5.034  1.00  0.00           O  
ATOM   1655  CB  SER A 111       7.374 -18.084  -7.451  1.00  0.00           C  
ATOM   1656  OG  SER A 111       7.390 -17.027  -8.402  1.00  0.00           O  
ATOM   1657  H   SER A 111       5.017 -16.494  -7.430  1.00  0.00           H  
ATOM   1658  HA  SER A 111       5.684 -19.409  -7.451  1.00  0.00           H  
ATOM   1659  HB2 SER A 111       7.904 -17.775  -6.567  1.00  0.00           H  
ATOM   1660  HB3 SER A 111       7.853 -18.961  -7.865  1.00  0.00           H  
ATOM   1661  HG  SER A 111       6.877 -17.306  -9.165  1.00  0.00           H  
ATOM   1662  N   MET A 112       6.081 -19.418  -4.891  1.00  0.00           N  
ATOM   1663  CA  MET A 112       5.917 -19.415  -3.412  1.00  0.00           C  
ATOM   1664  C   MET A 112       6.911 -20.391  -2.783  1.00  0.00           C  
ATOM   1665  O   MET A 112       7.245 -21.409  -3.356  1.00  0.00           O  
ATOM   1666  CB  MET A 112       4.492 -19.842  -3.057  1.00  0.00           C  
ATOM   1667  CG  MET A 112       4.194 -19.455  -1.609  1.00  0.00           C  
ATOM   1668  SD  MET A 112       2.769 -20.397  -1.011  1.00  0.00           S  
ATOM   1669  CE  MET A 112       1.696 -20.122  -2.442  1.00  0.00           C  
ATOM   1670  H   MET A 112       6.436 -20.210  -5.346  1.00  0.00           H  
ATOM   1671  HA  MET A 112       6.099 -18.421  -3.032  1.00  0.00           H  
ATOM   1672  HB2 MET A 112       3.793 -19.345  -3.716  1.00  0.00           H  
ATOM   1673  HB3 MET A 112       4.396 -20.910  -3.170  1.00  0.00           H  
ATOM   1674  HG2 MET A 112       5.054 -19.677  -0.995  1.00  0.00           H  
ATOM   1675  HG3 MET A 112       3.975 -18.398  -1.556  1.00  0.00           H  
ATOM   1676  HE1 MET A 112       1.924 -19.166  -2.886  1.00  0.00           H  
ATOM   1677  HE2 MET A 112       1.861 -20.904  -3.170  1.00  0.00           H  
ATOM   1678  HE3 MET A 112       0.663 -20.131  -2.122  1.00  0.00           H  
ATOM   1679  N   ARG A 113       7.384 -20.089  -1.606  1.00  0.00           N  
ATOM   1680  CA  ARG A 113       8.354 -21.000  -0.938  1.00  0.00           C  
ATOM   1681  C   ARG A 113       7.806 -21.412   0.429  1.00  0.00           C  
ATOM   1682  O   ARG A 113       6.783 -20.929   0.868  1.00  0.00           O  
ATOM   1683  CB  ARG A 113       9.692 -20.278  -0.759  1.00  0.00           C  
ATOM   1684  CG  ARG A 113      10.800 -21.085  -1.437  1.00  0.00           C  
ATOM   1685  CD  ARG A 113      11.944 -21.316  -0.447  1.00  0.00           C  
ATOM   1686  NE  ARG A 113      12.777 -22.461  -0.910  1.00  0.00           N  
ATOM   1687  CZ  ARG A 113      12.742 -23.596  -0.268  1.00  0.00           C  
ATOM   1688  NH1 ARG A 113      12.752 -23.608   1.038  1.00  0.00           N  
ATOM   1689  NH2 ARG A 113      12.698 -24.720  -0.930  1.00  0.00           N  
ATOM   1690  H   ARG A 113       7.099 -19.264  -1.159  1.00  0.00           H  
ATOM   1691  HA  ARG A 113       8.497 -21.878  -1.547  1.00  0.00           H  
ATOM   1692  HB2 ARG A 113       9.634 -19.296  -1.205  1.00  0.00           H  
ATOM   1693  HB3 ARG A 113       9.912 -20.183   0.295  1.00  0.00           H  
ATOM   1694  HG2 ARG A 113      10.404 -22.037  -1.761  1.00  0.00           H  
ATOM   1695  HG3 ARG A 113      11.170 -20.540  -2.291  1.00  0.00           H  
ATOM   1696  HD2 ARG A 113      12.554 -20.427  -0.388  1.00  0.00           H  
ATOM   1697  HD3 ARG A 113      11.537 -21.538   0.528  1.00  0.00           H  
ATOM   1698  HE  ARG A 113      13.349 -22.362  -1.700  1.00  0.00           H  
ATOM   1699 HH11 ARG A 113      12.785 -22.746   1.545  1.00  0.00           H  
ATOM   1700 HH12 ARG A 113      12.726 -24.477   1.530  1.00  0.00           H  
ATOM   1701 HH21 ARG A 113      12.690 -24.710  -1.930  1.00  0.00           H  
ATOM   1702 HH22 ARG A 113      12.671 -25.590  -0.438  1.00  0.00           H  
ATOM   1703  N   ALA A 114       8.478 -22.303   1.103  1.00  0.00           N  
ATOM   1704  CA  ALA A 114       7.994 -22.746   2.441  1.00  0.00           C  
ATOM   1705  C   ALA A 114       9.192 -23.092   3.327  1.00  0.00           C  
ATOM   1706  O   ALA A 114      10.221 -23.528   2.850  1.00  0.00           O  
ATOM   1707  CB  ALA A 114       7.108 -23.983   2.278  1.00  0.00           C  
ATOM   1708  H   ALA A 114       9.301 -22.683   0.730  1.00  0.00           H  
ATOM   1709  HA  ALA A 114       7.425 -21.952   2.899  1.00  0.00           H  
ATOM   1710  HB1 ALA A 114       6.520 -23.888   1.376  1.00  0.00           H  
ATOM   1711  HB2 ALA A 114       7.728 -24.865   2.212  1.00  0.00           H  
ATOM   1712  HB3 ALA A 114       6.449 -24.069   3.130  1.00  0.00           H  
ATOM   1713  N   LEU A 115       9.071 -22.903   4.613  1.00  0.00           N  
ATOM   1714  CA  LEU A 115      10.211 -23.223   5.515  1.00  0.00           C  
ATOM   1715  C   LEU A 115       9.695 -23.810   6.829  1.00  0.00           C  
ATOM   1716  O   LEU A 115       8.674 -23.409   7.349  1.00  0.00           O  
ATOM   1717  CB  LEU A 115      11.008 -21.958   5.813  1.00  0.00           C  
ATOM   1718  CG  LEU A 115      12.278 -22.328   6.577  1.00  0.00           C  
ATOM   1719  CD1 LEU A 115      13.489 -21.702   5.887  1.00  0.00           C  
ATOM   1720  CD2 LEU A 115      12.179 -21.806   8.011  1.00  0.00           C  
ATOM   1721  H   LEU A 115       8.234 -22.549   4.982  1.00  0.00           H  
ATOM   1722  HA  LEU A 115      10.857 -23.942   5.033  1.00  0.00           H  
ATOM   1723  HB2 LEU A 115      11.271 -21.474   4.886  1.00  0.00           H  
ATOM   1724  HB3 LEU A 115      10.410 -21.290   6.414  1.00  0.00           H  
ATOM   1725  HG  LEU A 115      12.387 -23.403   6.591  1.00  0.00           H  
ATOM   1726 HD11 LEU A 115      13.299 -20.655   5.709  1.00  0.00           H  
ATOM   1727 HD12 LEU A 115      14.359 -21.810   6.517  1.00  0.00           H  
ATOM   1728 HD13 LEU A 115      13.664 -22.202   4.945  1.00  0.00           H  
ATOM   1729 HD21 LEU A 115      11.232 -22.100   8.437  1.00  0.00           H  
ATOM   1730 HD22 LEU A 115      12.985 -22.218   8.601  1.00  0.00           H  
ATOM   1731 HD23 LEU A 115      12.253 -20.728   8.007  1.00  0.00           H  
ATOM   1732  N   PHE A 116      10.419 -24.748   7.367  1.00  0.00           N  
ATOM   1733  CA  PHE A 116      10.027 -25.389   8.656  1.00  0.00           C  
ATOM   1734  C   PHE A 116      10.954 -26.569   8.908  1.00  0.00           C  
ATOM   1735  O   PHE A 116      12.060 -26.623   8.408  1.00  0.00           O  
ATOM   1736  CB  PHE A 116       8.581 -25.894   8.598  1.00  0.00           C  
ATOM   1737  CG  PHE A 116       8.476 -27.043   7.626  1.00  0.00           C  
ATOM   1738  CD1 PHE A 116       8.564 -26.804   6.250  1.00  0.00           C  
ATOM   1739  CD2 PHE A 116       8.289 -28.347   8.101  1.00  0.00           C  
ATOM   1740  CE1 PHE A 116       8.466 -27.870   5.347  1.00  0.00           C  
ATOM   1741  CE2 PHE A 116       8.192 -29.413   7.198  1.00  0.00           C  
ATOM   1742  CZ  PHE A 116       8.280 -29.174   5.822  1.00  0.00           C  
ATOM   1743  H   PHE A 116      11.243 -25.031   6.918  1.00  0.00           H  
ATOM   1744  HA  PHE A 116      10.129 -24.679   9.461  1.00  0.00           H  
ATOM   1745  HB2 PHE A 116       8.281 -26.230   9.580  1.00  0.00           H  
ATOM   1746  HB3 PHE A 116       7.932 -25.097   8.284  1.00  0.00           H  
ATOM   1747  HD1 PHE A 116       8.705 -25.799   5.886  1.00  0.00           H  
ATOM   1748  HD2 PHE A 116       8.219 -28.530   9.165  1.00  0.00           H  
ATOM   1749  HE1 PHE A 116       8.534 -27.686   4.286  1.00  0.00           H  
ATOM   1750  HE2 PHE A 116       8.047 -30.418   7.564  1.00  0.00           H  
ATOM   1751  HZ  PHE A 116       8.205 -29.997   5.125  1.00  0.00           H  
ATOM   1752  N   GLY A 117      10.514 -27.517   9.675  1.00  0.00           N  
ATOM   1753  CA  GLY A 117      11.377 -28.697   9.952  1.00  0.00           C  
ATOM   1754  C   GLY A 117      10.800 -29.512  11.109  1.00  0.00           C  
ATOM   1755  O   GLY A 117       9.748 -29.207  11.637  1.00  0.00           O  
ATOM   1756  H   GLY A 117       9.620 -27.452  10.065  1.00  0.00           H  
ATOM   1757  HA2 GLY A 117      11.432 -29.315   9.067  1.00  0.00           H  
ATOM   1758  HA3 GLY A 117      12.363 -28.357  10.214  1.00  0.00           H  
ATOM   1759  N   GLU A 118      11.487 -30.549  11.508  1.00  0.00           N  
ATOM   1760  CA  GLU A 118      10.989 -31.390  12.631  1.00  0.00           C  
ATOM   1761  C   GLU A 118      11.077 -30.600  13.939  1.00  0.00           C  
ATOM   1762  O   GLU A 118      10.621 -31.042  14.975  1.00  0.00           O  
ATOM   1763  CB  GLU A 118      11.846 -32.652  12.733  1.00  0.00           C  
ATOM   1764  CG  GLU A 118      11.044 -33.762  13.413  1.00  0.00           C  
ATOM   1765  CD  GLU A 118      11.872 -35.049  13.436  1.00  0.00           C  
ATOM   1766  OE1 GLU A 118      12.949 -35.029  14.008  1.00  0.00           O  
ATOM   1767  OE2 GLU A 118      11.414 -36.035  12.879  1.00  0.00           O  
ATOM   1768  H   GLU A 118      12.333 -30.773  11.068  1.00  0.00           H  
ATOM   1769  HA  GLU A 118       9.964 -31.664  12.446  1.00  0.00           H  
ATOM   1770  HB2 GLU A 118      12.134 -32.970  11.741  1.00  0.00           H  
ATOM   1771  HB3 GLU A 118      12.730 -32.439  13.313  1.00  0.00           H  
ATOM   1772  HG2 GLU A 118      10.807 -33.467  14.424  1.00  0.00           H  
ATOM   1773  HG3 GLU A 118      10.130 -33.934  12.864  1.00  0.00           H  
ATOM   1774  N   LYS A 119      11.656 -29.432  13.896  1.00  0.00           N  
ATOM   1775  CA  LYS A 119      11.777 -28.605  15.122  1.00  0.00           C  
ATOM   1776  C   LYS A 119      10.568 -27.688  15.220  1.00  0.00           C  
ATOM   1777  O   LYS A 119      10.137 -27.305  16.289  1.00  0.00           O  
ATOM   1778  CB  LYS A 119      13.035 -27.760  15.005  1.00  0.00           C  
ATOM   1779  CG  LYS A 119      13.760 -27.716  16.353  1.00  0.00           C  
ATOM   1780  CD  LYS A 119      15.072 -26.945  16.203  1.00  0.00           C  
ATOM   1781  CE  LYS A 119      16.198 -27.713  16.899  1.00  0.00           C  
ATOM   1782  NZ  LYS A 119      16.177 -27.233  18.310  1.00  0.00           N  
ATOM   1783  H   LYS A 119      12.014 -29.093  13.053  1.00  0.00           H  
ATOM   1784  HA  LYS A 119      11.833 -29.234  15.988  1.00  0.00           H  
ATOM   1785  HB2 LYS A 119      13.678 -28.192  14.255  1.00  0.00           H  
ATOM   1786  HB3 LYS A 119      12.763 -26.764  14.705  1.00  0.00           H  
ATOM   1787  HG2 LYS A 119      13.132 -27.223  17.081  1.00  0.00           H  
ATOM   1788  HG3 LYS A 119      13.972 -28.722  16.681  1.00  0.00           H  
ATOM   1789  HD2 LYS A 119      15.306 -26.832  15.154  1.00  0.00           H  
ATOM   1790  HD3 LYS A 119      14.971 -25.970  16.655  1.00  0.00           H  
ATOM   1791  HE2 LYS A 119      16.006 -28.776  16.858  1.00  0.00           H  
ATOM   1792  HE3 LYS A 119      17.149 -27.482  16.445  1.00  0.00           H  
ATOM   1793  HZ1 LYS A 119      15.191 -27.096  18.614  1.00  0.00           H  
ATOM   1794  HZ2 LYS A 119      16.636 -27.936  18.922  1.00  0.00           H  
ATOM   1795  HZ3 LYS A 119      16.689 -26.331  18.377  1.00  0.00           H  
ATOM   1796  N   ASN A 120      10.031 -27.336  14.098  1.00  0.00           N  
ATOM   1797  CA  ASN A 120       8.846 -26.435  14.077  1.00  0.00           C  
ATOM   1798  C   ASN A 120       7.568 -27.270  14.160  1.00  0.00           C  
ATOM   1799  O   ASN A 120       6.477 -26.778  13.947  1.00  0.00           O  
ATOM   1800  CB  ASN A 120       8.848 -25.629  12.778  1.00  0.00           C  
ATOM   1801  CG  ASN A 120       9.126 -24.158  13.087  1.00  0.00           C  
ATOM   1802  OD1 ASN A 120       9.276 -23.784  14.234  1.00  0.00           O  
ATOM   1803  ND2 ASN A 120       9.205 -23.302  12.106  1.00  0.00           N  
ATOM   1804  H   ASN A 120      10.418 -27.663  13.261  1.00  0.00           H  
ATOM   1805  HA  ASN A 120       8.892 -25.760  14.920  1.00  0.00           H  
ATOM   1806  HB2 ASN A 120       9.614 -26.011  12.122  1.00  0.00           H  
ATOM   1807  HB3 ASN A 120       7.887 -25.719  12.297  1.00  0.00           H  
ATOM   1808 HD21 ASN A 120       9.085 -23.604  11.181  1.00  0.00           H  
ATOM   1809 HD22 ASN A 120       9.383 -22.357  12.293  1.00  0.00           H  
ATOM   1810  N   ILE A 121       7.692 -28.528  14.480  1.00  0.00           N  
ATOM   1811  CA  ILE A 121       6.483 -29.390  14.591  1.00  0.00           C  
ATOM   1812  C   ILE A 121       5.969 -29.322  16.031  1.00  0.00           C  
ATOM   1813  O   ILE A 121       6.414 -28.505  16.811  1.00  0.00           O  
ATOM   1814  CB  ILE A 121       6.848 -30.834  14.237  1.00  0.00           C  
ATOM   1815  CG1 ILE A 121       7.893 -30.830  13.119  1.00  0.00           C  
ATOM   1816  CG2 ILE A 121       5.601 -31.579  13.757  1.00  0.00           C  
ATOM   1817  CD1 ILE A 121       7.320 -30.128  11.886  1.00  0.00           C  
ATOM   1818  H   ILE A 121       8.579 -28.902  14.659  1.00  0.00           H  
ATOM   1819  HA  ILE A 121       5.721 -29.032  13.916  1.00  0.00           H  
ATOM   1820  HB  ILE A 121       7.251 -31.329  15.108  1.00  0.00           H  
ATOM   1821 HG12 ILE A 121       8.773 -30.305  13.455  1.00  0.00           H  
ATOM   1822 HG13 ILE A 121       8.152 -31.846  12.866  1.00  0.00           H  
ATOM   1823 HG21 ILE A 121       4.741 -30.932  13.841  1.00  0.00           H  
ATOM   1824 HG22 ILE A 121       5.731 -31.872  12.726  1.00  0.00           H  
ATOM   1825 HG23 ILE A 121       5.450 -32.458  14.365  1.00  0.00           H  
ATOM   1826 HD11 ILE A 121       6.253 -30.283  11.846  1.00  0.00           H  
ATOM   1827 HD12 ILE A 121       7.527 -29.070  11.945  1.00  0.00           H  
ATOM   1828 HD13 ILE A 121       7.777 -30.535  10.996  1.00  0.00           H  
ATOM   1829  N   HIS A 122       5.036 -30.159  16.393  1.00  0.00           N  
ATOM   1830  CA  HIS A 122       4.510 -30.123  17.787  1.00  0.00           C  
ATOM   1831  C   HIS A 122       4.018 -31.513  18.191  1.00  0.00           C  
ATOM   1832  O   HIS A 122       2.928 -31.920  17.842  1.00  0.00           O  
ATOM   1833  CB  HIS A 122       3.359 -29.129  17.864  1.00  0.00           C  
ATOM   1834  CG  HIS A 122       3.638 -28.119  18.942  1.00  0.00           C  
ATOM   1835  ND1 HIS A 122       4.016 -26.816  18.655  1.00  0.00           N  
ATOM   1836  CD2 HIS A 122       3.600 -28.204  20.312  1.00  0.00           C  
ATOM   1837  CE1 HIS A 122       4.188 -26.177  19.827  1.00  0.00           C  
ATOM   1838  NE2 HIS A 122       3.947 -26.977  20.869  1.00  0.00           N  
ATOM   1839  H   HIS A 122       4.682 -30.809  15.751  1.00  0.00           H  
ATOM   1840  HA  HIS A 122       5.293 -29.812  18.458  1.00  0.00           H  
ATOM   1841  HB2 HIS A 122       3.261 -28.629  16.915  1.00  0.00           H  
ATOM   1842  HB3 HIS A 122       2.448 -29.656  18.093  1.00  0.00           H  
ATOM   1843  HD1 HIS A 122       4.136 -26.432  17.762  1.00  0.00           H  
ATOM   1844  HD2 HIS A 122       3.339 -29.090  20.873  1.00  0.00           H  
ATOM   1845  HE1 HIS A 122       4.485 -25.142  19.914  1.00  0.00           H  
ATOM   1846  N   ALA A 123       4.808 -32.246  18.926  1.00  0.00           N  
ATOM   1847  CA  ALA A 123       4.375 -33.607  19.349  1.00  0.00           C  
ATOM   1848  C   ALA A 123       4.270 -33.660  20.874  1.00  0.00           C  
ATOM   1849  O   ALA A 123       5.130 -33.177  21.583  1.00  0.00           O  
ATOM   1850  CB  ALA A 123       5.398 -34.639  18.871  1.00  0.00           C  
ATOM   1851  H   ALA A 123       5.684 -31.902  19.200  1.00  0.00           H  
ATOM   1852  HA  ALA A 123       3.411 -33.829  18.913  1.00  0.00           H  
ATOM   1853  HB1 ALA A 123       6.060 -34.183  18.149  1.00  0.00           H  
ATOM   1854  HB2 ALA A 123       5.974 -34.993  19.714  1.00  0.00           H  
ATOM   1855  HB3 ALA A 123       4.884 -35.471  18.412  1.00  0.00           H  
ATOM   1856  N   GLY A 124       3.219 -34.243  21.385  1.00  0.00           N  
ATOM   1857  CA  GLY A 124       3.057 -34.327  22.864  1.00  0.00           C  
ATOM   1858  C   GLY A 124       1.570 -34.401  23.212  1.00  0.00           C  
ATOM   1859  O   GLY A 124       0.780 -34.976  22.488  1.00  0.00           O  
ATOM   1860  H   GLY A 124       2.536 -34.625  20.795  1.00  0.00           H  
ATOM   1861  HA2 GLY A 124       3.559 -35.211  23.230  1.00  0.00           H  
ATOM   1862  HA3 GLY A 124       3.488 -33.450  23.324  1.00  0.00           H  
ATOM   1863  N   ALA A 125       1.178 -33.824  24.315  1.00  0.00           N  
ATOM   1864  CA  ALA A 125      -0.259 -33.862  24.707  1.00  0.00           C  
ATOM   1865  C   ALA A 125      -0.915 -32.521  24.373  1.00  0.00           C  
ATOM   1866  O   ALA A 125      -1.968 -32.245  24.923  1.00  0.00           O  
ATOM   1867  CB  ALA A 125      -0.372 -34.124  26.210  1.00  0.00           C  
ATOM   1868  OXT ALA A 125      -0.352 -31.792  23.572  1.00  0.00           O  
ATOM   1869  H   ALA A 125       1.829 -33.365  24.886  1.00  0.00           H  
ATOM   1870  HA  ALA A 125      -0.758 -34.651  24.165  1.00  0.00           H  
ATOM   1871  HB1 ALA A 125       0.374 -34.846  26.507  1.00  0.00           H  
ATOM   1872  HB2 ALA A 125      -0.215 -33.203  26.749  1.00  0.00           H  
ATOM   1873  HB3 ALA A 125      -1.356 -34.510  26.435  1.00  0.00           H  
TER    1874      ALA A 125                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
