
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  129 ( 1197),  selected  129 , name 1e3v_B
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 1e3v_B.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     2_B      -       -           -
LGA    L     3_B      -       -           -
LGA    P     4_B      -       -           -
LGA    T     5_B      -       -           -
LGA    A     6_B      N       2          1.708
LGA    Q     7_B      S       3          3.080
LGA    E     8_B      E       4          3.387
LGA    V     9_B      I       5          2.210
LGA    Q    10_B      E       6          2.790
LGA    G    11_B      L       7          3.690
LGA    L    12_B      P       8          2.704
LGA    M    13_B      V       9          1.553
LGA    A    14_B      Q      10          2.140
LGA    R    15_B      K      11          1.909
LGA    Y    16_B      Q      12          1.573
LGA    I    17_B      L      13          1.019
LGA    E    18_B      E      14          0.515
LGA    L    19_B      A      15          0.646
LGA    V    20_B      Y      16          0.460
LGA    D    21_B      N      17          0.931
LGA    V    22_B      A      18          1.220
LGA    G    23_B      R      19          1.869
LGA    D    24_B      D      20          1.735
LGA    I    25_B      I      21          2.057
LGA    E    26_B      D      22          2.774
LGA    A    27_B      A      23          2.387
LGA    I    28_B      F      24          1.140
LGA    V    29_B      M      25          1.931
LGA    Q    30_B      A      26          2.157
LGA    M    31_B      W      27          2.264
LGA    Y    32_B      W      28          1.600
LGA    A    33_B      A      29          0.780
LGA    D    34_B      D      30          1.127
LGA    D    35_B      D      31          0.884
LGA    A    36_B      C      32          0.587
LGA    T    37_B      Q      33          0.914
LGA    V    38_B      Y      34          0.887
LGA    E    39_B      Y      35          1.163
LGA    D    40_B      A      36          2.355
LGA    P    41_B      F      37          2.833
LGA    F    42_B      -       -           -
LGA    G    43_B      P      38          1.766
LGA    Q    44_B      A      39          4.749
LGA    P    45_B      T      40          2.004
LGA    P    46_B      L      41          0.706
LGA    I    47_B      L      42          2.199
LGA    H    48_B      A      43          2.446
LGA    -       -      G      44           -
LGA    G    49_B      N      45          1.809
LGA    R    50_B      A      46          2.732
LGA    E    51_B      A      47          2.801
LGA    Q    52_B      E      48          1.579
LGA    I    53_B      I      49          1.182
LGA    A    54_B      R      50          2.076
LGA    A    55_B      V      51          2.046
LGA    F    56_B      R      52          0.849
LGA    Y    57_B      H      53          0.458
LGA    R    58_B      I      54          1.444
LGA    Q    59_B      E      55          1.730
LGA    G    60_B      R      56          1.704
LGA    L    61_B      F      57          1.943
LGA    G    62_B      K      58          3.126
LGA    G    63_B      E      59          2.440
LGA    G    64_B      P      60          2.750
LGA    K    65_B      D      61          1.844
LGA    V    66_B      L      62          0.941
LGA    R    67_B      Y      63          0.937
LGA    A    68_B      G      64          1.039
LGA    C    69_B      E      65          2.099
LGA    L    70_B      L      66          1.815
LGA    T    71_B      L      67          0.560
LGA    G    72_B      T      68          1.701
LGA    P    73_B      R      69          3.583
LGA    V    74_B      V      70          2.807
LGA    R    75_B      -       -           -
LGA    A    76_B      I      71          1.725
LGA    S    77_B      V      72          2.686
LGA    H    78_B      G      73          2.933
LGA    N    79_B      N      74          3.747
LGA    G    80_B      -       -           -
LGA    C    81_B      V      75          1.696
LGA    G    82_B      V      76          1.736
LGA    A    83_B      I      77          1.664
LGA    M    84_B      D      78          2.513
LGA    P    85_B      H      79          1.683
LGA    F    86_B      E      80          1.484
LGA    R    87_B      T      81          1.417
LGA    V    88_B      V      82          1.409
LGA    E    89_B      T      83          0.993
LGA    M    90_B      R      84          1.708
LGA    V    91_B      N      85          1.702
LGA    W    92_B      F      86          3.562
LGA    N    93_B      P      87          5.809
LGA    G    94_B      E      88           -
LGA    Q    95_B      G      89          4.202
LGA    P    96_B      K      90          1.989
LGA    C    97_B      G      91          0.906
LGA    A    98_B      E      92          0.592
LGA    L    99_B      V      93          0.873
LGA    D   100_B      D      94          0.823
LGA    V   101_B      V      95          1.265
LGA    I   102_B      A      96          1.126
LGA    D   103_B      C      97          1.660
LGA    V   104_B      I      98          1.402
LGA    M   105_B      Y      99          0.812
LGA    R   106_B      E     100          0.682
LGA    F   107_B      V     101          0.771
LGA    D   108_B      E     102          1.641
LGA    E   109_B      N     103          0.713
LGA    H   110_B      G     104          3.176
LGA    G   111_B      -       -           -
LGA    R   112_B      R     105          1.307
LGA    I   113_B      I     106          1.015
LGA    Q   114_B      A     107          1.123
LGA    T   115_B      K     108          0.813
LGA    M   116_B      A     109          0.795
LGA    Q   117_B      W     110          0.886
LGA    A   118_B      F     111          0.770
LGA    Y   119_B      K     112          1.593
LGA    W   120_B      I     113          1.690
LGA    S   121_B      G     114          4.489
LGA    E   122_B      -       -           -
LGA    V   123_B      -       -           -
LGA    N   124_B      E     115          1.418
LGA    L   125_B      P     116          0.988
LGA    S   126_B      R     117          1.605
LGA    V   127_B      I     118          4.761
LGA    R   128_B      -       -           -
LGA    E   129_B      -       -           -
LGA    P   130_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  129  117    5.0    115    2.08    14.78     85.268     5.268

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.464967 * X  +  -0.290731 * Y  +   0.836231 * Z  + -58.167595
  Y_new =  -0.111794 * X  +   0.917702 * Y  +   0.381216 * Z  + -25.724617
  Z_new =  -0.878241 * X  +  -0.270738 * Y  +   0.394199 * Z  + -22.126230 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.601816    2.539777  [ DEG:   -34.4815    145.5185 ]
  Theta =   1.072172    2.069420  [ DEG:    61.4310    118.5691 ]
  Phi   =  -0.235955    2.905637  [ DEG:   -13.5192    166.4808 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1e3v_B                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1e3v_B.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  129  117   5.0  115   2.08   14.78  85.268
REMARK  ---------------------------------------------------------- 
MOLECULE 1e3v_B
HEADER    ISOMERASE                               23-JUN-00   1E3V              
TITLE     CRYSTAL STRUCTURE OF KETOSTEROID ISOMERASE FROM PSEDOMONAS            
TITLE    2 PUTIDA COMPLEXED WITH DEOXYCHOLATE                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: STEROID DELTA-ISOMERASE;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: DELTA-5-3-KETOSTEROID ISOMERASE;                            
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 OTHER_DETAILS: DEOXYCHOLATE                                          
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS PUTIDA;                             
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    DEOXYCHLATE, KSI, LBHB, REVERSE BINDING                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.-C.HA,M.-S.KIM,J.-S.KIM,B.-H.OH                                     
REVDAT   2   01-APR-03 1E3V    1       JRNL                                     
REVDAT   1   12-MAR-01 1E3V    0                                                
JRNL        AUTH   N.C.HA,M.S.KIM,W.LEE,K.Y.CHOI,B.H.OH                         
JRNL        TITL   DETECTION OF LARGE PKA PERTURBATIONS OF AN                   
JRNL        TITL 2 INHIBITOR AND A CATALYTIC GROUP AT AN ENZYME                 
JRNL        TITL 3 ACTIVE SITE, A MECHANISTIC BASIS FOR CATALYTIC               
JRNL        TITL 4 POWER OF MANY ENZYMES.                                       
JRNL        REF    J.BIOL.CHEM.                  V. 275 41100 2000              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1E3V A    1   131  UNP    P07445   SDIS_PSEPU       1    131             
DBREF  1E3V B    1   131  UNP    P07445   SDIS_PSEPU       1    131             
SEQRES   1 A  131  MET ASN LEU PRO THR ALA GLN GLU VAL GLN GLY LEU MET          
SEQRES   2 A  131  ALA ARG TYR ILE GLU LEU VAL ASP VAL GLY ASP ILE GLU          
SEQRES   3 A  131  ALA ILE VAL GLN MET TYR ALA ASP ASP ALA THR VAL GLU          
SEQRES   4 A  131  ASP PRO PHE GLY GLN PRO PRO ILE HIS GLY ARG GLU GLN          
SEQRES   5 A  131  ILE ALA ALA PHE TYR ARG GLN GLY LEU GLY GLY GLY LYS          
SEQRES   6 A  131  VAL ARG ALA CYS LEU THR GLY PRO VAL ARG ALA SER HIS          
SEQRES   7 A  131  ASN GLY CYS GLY ALA MET PRO PHE ARG VAL GLU MET VAL          
SEQRES   8 A  131  TRP ASN GLY GLN PRO CYS ALA LEU ASP VAL ILE ASP VAL          
SEQRES   9 A  131  MET ARG PHE ASP GLU HIS GLY ARG ILE GLN THR MET GLN          
SEQRES  10 A  131  ALA TYR TRP SER GLU VAL ASN LEU SER VAL ARG GLU PRO          
SEQRES  11 A  131  GLN                                                          
SEQRES   1 B  131  MET ASN LEU PRO THR ALA GLN GLU VAL GLN GLY LEU MET          
SEQRES   2 B  131  ALA ARG TYR ILE GLU LEU VAL ASP VAL GLY ASP ILE GLU          
SEQRES   3 B  131  ALA ILE VAL GLN MET TYR ALA ASP ASP ALA THR VAL GLU          
SEQRES   4 B  131  ASP PRO PHE GLY GLN PRO PRO ILE HIS GLY ARG GLU GLN          
SEQRES   5 B  131  ILE ALA ALA PHE TYR ARG GLN GLY LEU GLY GLY GLY LYS          
SEQRES   6 B  131  VAL ARG ALA CYS LEU THR GLY PRO VAL ARG ALA SER HIS          
SEQRES   7 B  131  ASN GLY CYS GLY ALA MET PRO PHE ARG VAL GLU MET VAL          
SEQRES   8 B  131  TRP ASN GLY GLN PRO CYS ALA LEU ASP VAL ILE ASP VAL          
SEQRES   9 B  131  MET ARG PHE ASP GLU HIS GLY ARG ILE GLN THR MET GLN          
SEQRES  10 B  131  ALA TYR TRP SER GLU VAL ASN LEU SER VAL ARG GLU PRO          
SEQRES  11 B  131  GLN                                                          
HET    DXC  A 801      28                                                       
HET    DXC  B 801      28                                                       
HETNAM     DXC (3ALPHA,5ALPHA,12ALPHA)-3,12-DIHYDROXYCHOLAN-24-OIC              
HETNAM   2 DXC  ACID                                                            
HETSYN     DXC DEOXYCHOLIC ACID                                                 
FORMUL   3  DXC    2(C24 H40 O4)                                                
FORMUL   5  HOH   *104(H2 O)                                                    
CRYST1   36.580   75.210   96.130  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1192  N   ASN B   2       5.600  -8.543  -7.676  1.00 47.58           N  
ATOM   1193  CA  ASN B   2       5.662  -7.488  -8.727  1.00 43.54           C  
ATOM   1194  C   ASN B   2       4.654  -6.365  -8.493  1.00 40.10           C  
ATOM   1195  O   ASN B   2       4.929  -5.438  -7.740  1.00 40.14           O  
ATOM   1196  CB  ASN B   2       5.465  -8.105 -10.109  1.00 45.31           C  
ATOM   1197  H1  ASN B   2       4.664  -8.977  -7.584  1.00  0.00           H  
ATOM   1198  H2  ASN B   2       6.266  -9.316  -7.892  1.00  0.00           H  
ATOM   1199  H3  ASN B   2       5.900  -8.115  -6.779  1.00  0.00           H  
ATOM   1200  N   LEU B   3       3.471  -6.495  -9.094  1.00 37.24           N  
ATOM   1201  CA  LEU B   3       2.403  -5.500  -9.003  1.00 31.53           C  
ATOM   1202  C   LEU B   3       1.717  -5.243  -7.656  1.00 27.46           C  
ATOM   1203  O   LEU B   3       1.484  -4.086  -7.299  1.00 28.13           O  
ATOM   1204  CB  LEU B   3       1.352  -5.764 -10.096  1.00 32.32           C  
ATOM   1205  CG  LEU B   3      -0.145  -5.589  -9.808  1.00 33.77           C  
ATOM   1206  CD1 LEU B   3      -0.859  -5.028 -11.036  1.00 32.02           C  
ATOM   1207  CD2 LEU B   3      -0.761  -6.920  -9.371  1.00 28.91           C  
ATOM   1208  H   LEU B   3       3.247  -7.280  -9.624  1.00  0.00           H  
ATOM   1209  N   PRO B   4       1.348  -6.301  -6.908  1.00 22.51           N  
ATOM   1210  CA  PRO B   4       0.693  -6.009  -5.629  1.00 17.69           C  
ATOM   1211  C   PRO B   4       1.552  -5.158  -4.694  1.00 16.81           C  
ATOM   1212  O   PRO B   4       2.758  -5.375  -4.572  1.00 13.98           O  
ATOM   1213  CB  PRO B   4       0.428  -7.403  -5.057  1.00 17.10           C  
ATOM   1214  CG  PRO B   4       1.522  -8.222  -5.651  1.00 19.83           C  
ATOM   1215  CD  PRO B   4       1.526  -7.755  -7.075  1.00 21.30           C  
ATOM   1216  N   THR B   5       0.924  -4.170  -4.068  1.00 14.88           N  
ATOM   1217  CA  THR B   5       1.599  -3.278  -3.138  1.00 13.40           C  
ATOM   1218  C   THR B   5       1.754  -4.025  -1.817  1.00 12.47           C  
ATOM   1219  O   THR B   5       1.100  -5.051  -1.615  1.00 13.48           O  
ATOM   1220  CB  THR B   5       0.764  -2.003  -2.904  1.00 10.41           C  
ATOM   1221  OG1 THR B   5      -0.478  -2.348  -2.278  1.00  7.90           O  
ATOM   1222  CG2 THR B   5       0.488  -1.288  -4.237  1.00 10.64           C  
ATOM   1223  H   THR B   5      -0.025  -4.023  -4.218  1.00  0.00           H  
ATOM   1224  HG1 THR B   5      -0.428  -2.212  -1.327  1.00  0.00           H  
ATOM   1225  N   ALA B   6       2.535  -3.467  -0.894  1.00 11.19           N  
ATOM   1226  CA  ALA B   6       2.771  -4.092   0.406  1.00  9.71           C  
ATOM   1227  C   ALA B   6       1.463  -4.401   1.121  1.00  9.91           C  
ATOM   1228  O   ALA B   6       1.291  -5.490   1.666  1.00 10.29           O  
ATOM   1229  CB  ALA B   6       3.669  -3.208   1.278  1.00  6.85           C  
ATOM   1230  H   ALA B   6       2.928  -2.587  -1.040  1.00  0.00           H  
ATOM   1231  N   GLN B   7       0.531  -3.454   1.102  1.00 11.41           N  
ATOM   1232  CA  GLN B   7      -0.770  -3.648   1.741  1.00 14.72           C  
ATOM   1233  C   GLN B   7      -1.586  -4.752   1.085  1.00 13.95           C  
ATOM   1234  O   GLN B   7      -2.332  -5.461   1.757  1.00 13.76           O  
ATOM   1235  CB  GLN B   7      -1.562  -2.346   1.735  1.00 18.72           C  
ATOM   1236  CG  GLN B   7      -1.150  -1.411   2.851  1.00 34.74           C  
ATOM   1237  CD  GLN B   7      -1.430   0.044   2.547  1.00 40.26           C  
ATOM   1238  OE1 GLN B   7      -0.587   0.907   2.801  1.00 42.27           O  
ATOM   1239  NE2 GLN B   7      -2.613   0.330   2.002  1.00 41.88           N  
ATOM   1240  H   GLN B   7       0.741  -2.590   0.690  1.00  0.00           H  
ATOM   1241 HE21 GLN B   7      -2.790   1.271   1.799  1.00  0.00           H  
ATOM   1242 HE22 GLN B   7      -3.263  -0.377   1.801  1.00  0.00           H  
ATOM   1243  N   GLU B   8      -1.455  -4.876  -0.230  1.00 13.51           N  
ATOM   1244  CA  GLU B   8      -2.163  -5.900  -0.976  1.00 14.31           C  
ATOM   1245  C   GLU B   8      -1.544  -7.278  -0.715  1.00 14.84           C  
ATOM   1246  O   GLU B   8      -2.264  -8.273  -0.614  1.00 14.21           O  
ATOM   1247  CB  GLU B   8      -2.164  -5.549  -2.460  1.00 13.73           C  
ATOM   1248  CG  GLU B   8      -2.876  -4.228  -2.712  1.00 24.52           C  
ATOM   1249  CD  GLU B   8      -2.874  -3.790  -4.160  1.00 25.76           C  
ATOM   1250  OE1 GLU B   8      -1.932  -4.129  -4.905  1.00 27.73           O  
ATOM   1251  OE2 GLU B   8      -3.824  -3.084  -4.551  1.00 35.06           O  
ATOM   1252  H   GLU B   8      -0.865  -4.271  -0.719  1.00  0.00           H  
ATOM   1253  N   VAL B   9      -0.220  -7.325  -0.556  1.00 12.57           N  
ATOM   1254  CA  VAL B   9       0.471  -8.581  -0.275  1.00 11.57           C  
ATOM   1255  C   VAL B   9      -0.043  -9.113   1.064  1.00 12.23           C  
ATOM   1256  O   VAL B   9      -0.331 -10.311   1.196  1.00 10.96           O  
ATOM   1257  CB  VAL B   9       2.013  -8.389  -0.226  1.00 12.93           C  
ATOM   1258  CG1 VAL B   9       2.699  -9.644   0.306  1.00 13.14           C  
ATOM   1259  CG2 VAL B   9       2.547  -8.070  -1.617  1.00 12.38           C  
ATOM   1260  H   VAL B   9       0.312  -6.507  -0.616  1.00  0.00           H  
ATOM   1261  N   GLN B  10      -0.210  -8.217   2.038  1.00 10.30           N  
ATOM   1262  CA  GLN B  10      -0.714  -8.603   3.355  1.00  9.80           C  
ATOM   1263  C   GLN B  10      -2.099  -9.245   3.250  1.00 12.76           C  
ATOM   1264  O   GLN B  10      -2.400 -10.207   3.958  1.00 10.36           O  
ATOM   1265  CB  GLN B  10      -0.807  -7.400   4.291  1.00 10.73           C  
ATOM   1266  CG  GLN B  10       0.521  -6.836   4.767  1.00 10.15           C  
ATOM   1267  CD  GLN B  10       0.340  -5.900   5.948  1.00 13.17           C  
ATOM   1268  OE1 GLN B  10       0.890  -6.124   7.033  1.00 14.46           O  
ATOM   1269  NE2 GLN B  10      -0.457  -4.854   5.754  1.00 13.09           N  
ATOM   1270  H   GLN B  10       0.036  -7.280   1.874  1.00  0.00           H  
ATOM   1271 HE21 GLN B  10      -0.558  -4.274   6.533  1.00  0.00           H  
ATOM   1272 HE22 GLN B  10      -0.893  -4.715   4.895  1.00  0.00           H  
ATOM   1273  N   GLY B  11      -2.952  -8.677   2.399  1.00 12.29           N  
ATOM   1274  CA  GLY B  11      -4.292  -9.210   2.222  1.00 12.81           C  
ATOM   1275  C   GLY B  11      -4.318 -10.551   1.507  1.00 10.23           C  
ATOM   1276  O   GLY B  11      -5.034 -11.470   1.916  1.00 11.66           O  
ATOM   1277  H   GLY B  11      -2.672  -7.889   1.888  1.00  0.00           H  
ATOM   1278  N   LEU B  12      -3.551 -10.659   0.432  1.00  7.11           N  
ATOM   1279  CA  LEU B  12      -3.473 -11.883  -0.350  1.00  9.84           C  
ATOM   1280  C   LEU B  12      -2.977 -13.055   0.483  1.00 11.24           C  
ATOM   1281  O   LEU B  12      -3.563 -14.144   0.457  1.00  9.62           O  
ATOM   1282  CB  LEU B  12      -2.555 -11.678  -1.547  1.00  8.20           C  
ATOM   1283  CG  LEU B  12      -3.175 -10.843  -2.665  1.00 16.72           C  
ATOM   1284  CD1 LEU B  12      -2.098 -10.290  -3.550  1.00 15.11           C  
ATOM   1285  CD2 LEU B  12      -4.155 -11.676  -3.459  1.00 15.00           C  
ATOM   1286  H   LEU B  12      -3.026  -9.877   0.158  1.00  0.00           H  
ATOM   1287  N   MET B  13      -1.891 -12.825   1.218  1.00 10.09           N  
ATOM   1288  CA  MET B  13      -1.315 -13.860   2.064  1.00 10.78           C  
ATOM   1289  C   MET B  13      -2.239 -14.249   3.219  1.00  9.71           C  
ATOM   1290  O   MET B  13      -2.287 -15.420   3.602  1.00 12.03           O  
ATOM   1291  CB  MET B  13       0.072 -13.435   2.558  1.00 11.17           C  
ATOM   1292  CG  MET B  13       1.080 -13.358   1.432  1.00  8.01           C  
ATOM   1293  SD  MET B  13       2.753 -12.941   1.946  1.00 13.36           S  
ATOM   1294  CE  MET B  13       3.348 -14.558   2.499  1.00  9.53           C  
ATOM   1295  H   MET B  13      -1.463 -11.946   1.165  1.00  0.00           H  
ATOM   1296  N   ALA B  14      -3.000 -13.290   3.745  1.00  6.00           N  
ATOM   1297  CA  ALA B  14      -3.943 -13.580   4.821  1.00  6.00           C  
ATOM   1298  C   ALA B  14      -5.116 -14.394   4.247  1.00  9.27           C  
ATOM   1299  O   ALA B  14      -5.662 -15.293   4.918  1.00  8.51           O  
ATOM   1300  CB  ALA B  14      -4.447 -12.297   5.445  1.00  7.94           C  
ATOM   1301  H   ALA B  14      -2.918 -12.371   3.415  1.00  0.00           H  
ATOM   1302  N   ARG B  15      -5.477 -14.108   2.995  1.00  9.44           N  
ATOM   1303  CA  ARG B  15      -6.565 -14.828   2.347  1.00 10.41           C  
ATOM   1304  C   ARG B  15      -6.134 -16.265   2.087  1.00 10.05           C  
ATOM   1305  O   ARG B  15      -6.935 -17.193   2.215  1.00  9.78           O  
ATOM   1306  CB  ARG B  15      -6.981 -14.171   1.033  1.00 14.88           C  
ATOM   1307  CG  ARG B  15      -8.229 -14.823   0.458  1.00 20.62           C  
ATOM   1308  CD  ARG B  15      -8.574 -14.363  -0.940  1.00 26.92           C  
ATOM   1309  NE  ARG B  15      -9.805 -15.012  -1.396  1.00 34.89           N  
ATOM   1310  CZ  ARG B  15      -9.904 -15.739  -2.505  1.00 36.81           C  
ATOM   1311  NH1 ARG B  15      -8.846 -15.916  -3.287  1.00 40.79           N  
ATOM   1312  NH2 ARG B  15     -11.059 -16.304  -2.826  1.00 37.83           N  
ATOM   1313  H   ARG B  15      -5.014 -13.397   2.504  1.00  0.00           H  
ATOM   1314  HE  ARG B  15     -10.610 -14.910  -0.845  1.00  0.00           H  
ATOM   1315 HH11 ARG B  15      -7.968 -15.501  -3.047  1.00  0.00           H  
ATOM   1316 HH12 ARG B  15      -8.928 -16.457  -4.121  1.00  0.00           H  
ATOM   1317 HH21 ARG B  15     -11.855 -16.170  -2.239  1.00  0.00           H  
ATOM   1318 HH22 ARG B  15     -11.135 -16.847  -3.659  1.00  0.00           H  
ATOM   1319  N   TYR B  16      -4.879 -16.439   1.689  1.00  9.73           N  
ATOM   1320  CA  TYR B  16      -4.333 -17.767   1.446  1.00 10.51           C  
ATOM   1321  C   TYR B  16      -4.510 -18.652   2.696  1.00  9.69           C  
ATOM   1322  O   TYR B  16      -4.976 -19.787   2.588  1.00 12.20           O  
ATOM   1323  CB  TYR B  16      -2.857 -17.665   1.051  1.00 10.15           C  
ATOM   1324  CG  TYR B  16      -2.138 -18.991   1.048  1.00 11.42           C  
ATOM   1325  CD1 TYR B  16      -2.184 -19.826  -0.065  1.00 10.44           C  
ATOM   1326  CD2 TYR B  16      -1.438 -19.430   2.182  1.00  8.07           C  
ATOM   1327  CE1 TYR B  16      -1.557 -21.069  -0.050  1.00 12.07           C  
ATOM   1328  CE2 TYR B  16      -0.806 -20.674   2.207  1.00  8.00           C  
ATOM   1329  CZ  TYR B  16      -0.874 -21.483   1.090  1.00  8.50           C  
ATOM   1330  OH  TYR B  16      -0.284 -22.718   1.095  1.00  8.94           O  
ATOM   1331  H   TYR B  16      -4.310 -15.656   1.540  1.00  0.00           H  
ATOM   1332  HH  TYR B  16      -0.594 -23.127   0.270  1.00  0.00           H  
ATOM   1333  N   ILE B  17      -4.161 -18.134   3.874  1.00  9.53           N  
ATOM   1334  CA  ILE B  17      -4.314 -18.892   5.124  1.00 10.22           C  
ATOM   1335  C   ILE B  17      -5.794 -19.231   5.373  1.00 11.95           C  
ATOM   1336  O   ILE B  17      -6.118 -20.328   5.843  1.00  8.63           O  
ATOM   1337  CB  ILE B  17      -3.751 -18.106   6.358  1.00 10.70           C  
ATOM   1338  CG1 ILE B  17      -2.229 -17.993   6.276  1.00 12.41           C  
ATOM   1339  CG2 ILE B  17      -4.141 -18.788   7.664  1.00 11.37           C  
ATOM   1340  CD1 ILE B  17      -1.518 -19.313   6.246  1.00 14.35           C  
ATOM   1341  H   ILE B  17      -3.780 -17.232   3.904  1.00  0.00           H  
ATOM   1342  N   GLU B  18      -6.689 -18.290   5.075  1.00 10.43           N  
ATOM   1343  CA  GLU B  18      -8.117 -18.526   5.264  1.00 13.33           C  
ATOM   1344  C   GLU B  18      -8.607 -19.692   4.398  1.00 10.91           C  
ATOM   1345  O   GLU B  18      -9.392 -20.524   4.847  1.00  9.85           O  
ATOM   1346  CB  GLU B  18      -8.922 -17.269   4.925  1.00 20.46           C  
ATOM   1347  CG  GLU B  18      -8.663 -16.075   5.827  1.00 36.02           C  
ATOM   1348  CD  GLU B  18      -9.357 -14.805   5.329  1.00 45.74           C  
ATOM   1349  OE1 GLU B  18     -10.564 -14.867   4.991  1.00 48.09           O  
ATOM   1350  OE2 GLU B  18      -8.691 -13.745   5.270  1.00 50.31           O  
ATOM   1351  H   GLU B  18      -6.382 -17.427   4.722  1.00  0.00           H  
ATOM   1352  N   LEU B  19      -8.145 -19.741   3.155  1.00  9.30           N  
ATOM   1353  CA  LEU B  19      -8.531 -20.799   2.234  1.00  8.03           C  
ATOM   1354  C   LEU B  19      -7.972 -22.153   2.665  1.00  9.07           C  
ATOM   1355  O   LEU B  19      -8.623 -23.184   2.465  1.00  7.10           O  
ATOM   1356  CB  LEU B  19      -8.074 -20.466   0.821  1.00  7.07           C  
ATOM   1357  CG  LEU B  19      -8.708 -19.233   0.181  1.00  8.66           C  
ATOM   1358  CD1 LEU B  19      -8.084 -18.998  -1.186  1.00  7.01           C  
ATOM   1359  CD2 LEU B  19     -10.205 -19.421   0.073  1.00  6.02           C  
ATOM   1360  H   LEU B  19      -7.541 -19.032   2.841  1.00  0.00           H  
ATOM   1361  N   VAL B  20      -6.763 -22.151   3.229  1.00  9.64           N  
ATOM   1362  CA  VAL B  20      -6.130 -23.375   3.716  1.00  9.19           C  
ATOM   1363  C   VAL B  20      -6.922 -23.857   4.930  1.00  8.58           C  
ATOM   1364  O   VAL B  20      -7.225 -25.038   5.055  1.00 10.33           O  
ATOM   1365  CB  VAL B  20      -4.653 -23.141   4.137  1.00  9.92           C  
ATOM   1366  CG1 VAL B  20      -4.108 -24.377   4.849  1.00  8.22           C  
ATOM   1367  CG2 VAL B  20      -3.792 -22.829   2.919  1.00  6.00           C  
ATOM   1368  H   VAL B  20      -6.282 -21.298   3.295  1.00  0.00           H  
ATOM   1369  N   ASP B  21      -7.286 -22.924   5.799  1.00  9.28           N  
ATOM   1370  CA  ASP B  21      -8.056 -23.244   6.992  1.00 10.04           C  
ATOM   1371  C   ASP B  21      -9.423 -23.877   6.654  1.00 14.18           C  
ATOM   1372  O   ASP B  21      -9.857 -24.810   7.331  1.00 13.82           O  
ATOM   1373  CB  ASP B  21      -8.243 -21.980   7.842  1.00 10.76           C  
ATOM   1374  CG  ASP B  21      -8.947 -22.260   9.154  1.00 13.00           C  
ATOM   1375  OD1 ASP B  21      -8.406 -23.033   9.964  1.00 16.55           O  
ATOM   1376  OD2 ASP B  21     -10.043 -21.713   9.384  1.00 18.27           O  
ATOM   1377  H   ASP B  21      -7.029 -21.992   5.640  1.00  0.00           H  
ATOM   1378  N   VAL B  22     -10.115 -23.362   5.635  1.00 15.94           N  
ATOM   1379  CA  VAL B  22     -11.418 -23.924   5.258  1.00 17.71           C  
ATOM   1380  C   VAL B  22     -11.288 -25.127   4.324  1.00 17.85           C  
ATOM   1381  O   VAL B  22     -12.259 -25.847   4.100  1.00 20.68           O  
ATOM   1382  CB  VAL B  22     -12.398 -22.873   4.632  1.00 17.97           C  
ATOM   1383  CG1 VAL B  22     -12.696 -21.761   5.627  1.00 19.49           C  
ATOM   1384  CG2 VAL B  22     -11.851 -22.317   3.324  1.00 16.26           C  
ATOM   1385  H   VAL B  22      -9.749 -22.593   5.147  1.00  0.00           H  
ATOM   1386  N   GLY B  23     -10.098 -25.329   3.769  1.00 13.81           N  
ATOM   1387  CA  GLY B  23      -9.864 -26.453   2.884  1.00 11.06           C  
ATOM   1388  C   GLY B  23     -10.418 -26.352   1.472  1.00 14.28           C  
ATOM   1389  O   GLY B  23     -10.758 -27.372   0.873  1.00 15.15           O  
ATOM   1390  H   GLY B  23      -9.343 -24.730   3.952  1.00  0.00           H  
ATOM   1391  N   ASP B  24     -10.493 -25.143   0.923  1.00 13.53           N  
ATOM   1392  CA  ASP B  24     -11.003 -24.971  -0.431  1.00 12.37           C  
ATOM   1393  C   ASP B  24      -9.844 -25.103  -1.409  1.00 11.89           C  
ATOM   1394  O   ASP B  24      -9.169 -24.126  -1.730  1.00 11.87           O  
ATOM   1395  CB  ASP B  24     -11.688 -23.608  -0.585  1.00 13.19           C  
ATOM   1396  CG  ASP B  24     -12.561 -23.534  -1.831  1.00 15.56           C  
ATOM   1397  OD1 ASP B  24     -12.099 -23.908  -2.931  1.00 16.74           O  
ATOM   1398  OD2 ASP B  24     -13.723 -23.107  -1.714  1.00 17.09           O  
ATOM   1399  H   ASP B  24     -10.156 -24.376   1.437  1.00  0.00           H  
ATOM   1400  N   ILE B  25      -9.661 -26.311  -1.927  1.00 11.30           N  
ATOM   1401  CA  ILE B  25      -8.577 -26.605  -2.845  1.00 12.26           C  
ATOM   1402  C   ILE B  25      -8.642 -25.867  -4.182  1.00 14.43           C  
ATOM   1403  O   ILE B  25      -7.628 -25.324  -4.634  1.00 15.42           O  
ATOM   1404  CB  ILE B  25      -8.428 -28.132  -3.027  1.00 15.97           C  
ATOM   1405  CG1 ILE B  25      -8.131 -28.765  -1.666  1.00 14.62           C  
ATOM   1406  CG2 ILE B  25      -7.303 -28.458  -4.008  1.00 15.68           C  
ATOM   1407  CD1 ILE B  25      -8.529 -30.220  -1.561  1.00 23.93           C  
ATOM   1408  H   ILE B  25     -10.279 -27.034  -1.674  1.00  0.00           H  
ATOM   1409  N   GLU B  26      -9.820 -25.806  -4.799  1.00 14.88           N  
ATOM   1410  CA  GLU B  26      -9.966 -25.108  -6.079  1.00 16.46           C  
ATOM   1411  C   GLU B  26      -9.591 -23.631  -5.923  1.00 14.70           C  
ATOM   1412  O   GLU B  26      -8.881 -23.080  -6.758  1.00 14.22           O  
ATOM   1413  CB  GLU B  26     -11.402 -25.241  -6.617  1.00 25.80           C  
ATOM   1414  CG  GLU B  26     -11.661 -24.533  -7.964  1.00 42.85           C  
ATOM   1415  CD  GLU B  26     -13.116 -24.645  -8.456  1.00 52.02           C  
ATOM   1416  OE1 GLU B  26     -14.031 -24.220  -7.714  1.00 57.90           O  
ATOM   1417  OE2 GLU B  26     -13.344 -25.140  -9.590  1.00 52.90           O  
ATOM   1418  H   GLU B  26     -10.595 -26.258  -4.403  1.00  0.00           H  
ATOM   1419  N   ALA B  27     -10.033 -23.013  -4.825  1.00 14.48           N  
ATOM   1420  CA  ALA B  27      -9.750 -21.605  -4.547  1.00 13.59           C  
ATOM   1421  C   ALA B  27      -8.252 -21.344  -4.363  1.00 13.52           C  
ATOM   1422  O   ALA B  27      -7.719 -20.367  -4.903  1.00 11.83           O  
ATOM   1423  CB  ALA B  27     -10.532 -21.135  -3.328  1.00  9.22           C  
ATOM   1424  H   ALA B  27     -10.543 -23.531  -4.182  1.00  0.00           H  
ATOM   1425  N   ILE B  28      -7.571 -22.224  -3.627  1.00 13.84           N  
ATOM   1426  CA  ILE B  28      -6.125 -22.096  -3.406  1.00 11.57           C  
ATOM   1427  C   ILE B  28      -5.362 -22.222  -4.722  1.00 11.31           C  
ATOM   1428  O   ILE B  28      -4.526 -21.378  -5.047  1.00 11.92           O  
ATOM   1429  CB  ILE B  28      -5.591 -23.168  -2.426  1.00 13.31           C  
ATOM   1430  CG1 ILE B  28      -6.214 -22.968  -1.040  1.00 14.09           C  
ATOM   1431  CG2 ILE B  28      -4.069 -23.089  -2.341  1.00 12.90           C  
ATOM   1432  CD1 ILE B  28      -5.945 -24.100  -0.055  1.00 15.40           C  
ATOM   1433  H   ILE B  28      -8.047 -22.977  -3.215  1.00  0.00           H  
ATOM   1434  N   VAL B  29      -5.669 -23.259  -5.491  1.00  9.93           N  
ATOM   1435  CA  VAL B  29      -5.003 -23.472  -6.768  1.00 12.04           C  
ATOM   1436  C   VAL B  29      -5.179 -22.265  -7.697  1.00 14.96           C  
ATOM   1437  O   VAL B  29      -4.283 -21.934  -8.481  1.00 13.89           O  
ATOM   1438  CB  VAL B  29      -5.521 -24.755  -7.470  1.00 16.85           C  
ATOM   1439  CG1 VAL B  29      -4.794 -24.964  -8.794  1.00 20.33           C  
ATOM   1440  CG2 VAL B  29      -5.312 -25.970  -6.572  1.00 19.01           C  
ATOM   1441  H   VAL B  29      -6.360 -23.892  -5.191  1.00  0.00           H  
ATOM   1442  N   GLN B  30      -6.332 -21.609  -7.601  1.00 16.57           N  
ATOM   1443  CA  GLN B  30      -6.627 -20.432  -8.418  1.00 19.91           C  
ATOM   1444  C   GLN B  30      -5.724 -19.243  -8.075  1.00 17.13           C  
ATOM   1445  O   GLN B  30      -5.574 -18.322  -8.880  1.00 19.81           O  
ATOM   1446  CB  GLN B  30      -8.091 -20.010  -8.247  1.00 27.05           C  
ATOM   1447  CG  GLN B  30      -9.117 -20.989  -8.795  1.00 40.70           C  
ATOM   1448  CD  GLN B  30      -9.297 -20.902 -10.306  1.00 49.62           C  
ATOM   1449  OE1 GLN B  30      -8.469 -20.332 -11.026  1.00 53.50           O  
ATOM   1450  NE2 GLN B  30     -10.400 -21.463 -10.793  1.00 54.17           N  
ATOM   1451  H   GLN B  30      -7.018 -21.945  -6.982  1.00  0.00           H  
ATOM   1452 HE21 GLN B  30     -10.545 -21.434 -11.759  1.00  0.00           H  
ATOM   1453 HE22 GLN B  30     -11.018 -21.885 -10.164  1.00  0.00           H  
ATOM   1454  N   MET B  31      -5.158 -19.238  -6.873  1.00 13.88           N  
ATOM   1455  CA  MET B  31      -4.277 -18.150  -6.457  1.00 10.83           C  
ATOM   1456  C   MET B  31      -2.903 -18.236  -7.102  1.00 11.43           C  
ATOM   1457  O   MET B  31      -2.135 -17.270  -7.071  1.00 14.24           O  
ATOM   1458  CB  MET B  31      -4.110 -18.138  -4.939  1.00  9.84           C  
ATOM   1459  CG  MET B  31      -5.338 -17.703  -4.191  1.00 11.79           C  
ATOM   1460  SD  MET B  31      -4.989 -17.360  -2.467  1.00 16.21           S  
ATOM   1461  CE  MET B  31      -4.161 -15.797  -2.575  1.00 15.35           C  
ATOM   1462  H   MET B  31      -5.331 -19.972  -6.249  1.00  0.00           H  
ATOM   1463  N   TYR B  32      -2.598 -19.382  -7.696  1.00 10.90           N  
ATOM   1464  CA  TYR B  32      -1.298 -19.605  -8.313  1.00 11.66           C  
ATOM   1465  C   TYR B  32      -1.214 -19.294  -9.793  1.00 12.79           C  
ATOM   1466  O   TYR B  32      -2.194 -19.413 -10.514  1.00 13.33           O  
ATOM   1467  CB  TYR B  32      -0.851 -21.058  -8.090  1.00  9.95           C  
ATOM   1468  CG  TYR B  32      -0.315 -21.336  -6.702  1.00  9.08           C  
ATOM   1469  CD1 TYR B  32       1.040 -21.171  -6.417  1.00  6.48           C  
ATOM   1470  CD2 TYR B  32      -1.159 -21.767  -5.678  1.00 11.00           C  
ATOM   1471  CE1 TYR B  32       1.544 -21.430  -5.149  1.00  8.28           C  
ATOM   1472  CE2 TYR B  32      -0.665 -22.026  -4.400  1.00  8.99           C  
ATOM   1473  CZ  TYR B  32       0.687 -21.855  -4.146  1.00  8.88           C  
ATOM   1474  OH  TYR B  32       1.184 -22.105  -2.883  1.00  9.80           O  
ATOM   1475  H   TYR B  32      -3.265 -20.094  -7.777  1.00  0.00           H  
ATOM   1476  HH  TYR B  32       2.140 -22.065  -2.915  1.00  0.00           H  
ATOM   1477  N   ALA B  33      -0.026 -18.875 -10.225  1.00 14.55           N  
ATOM   1478  CA  ALA B  33       0.240 -18.581 -11.628  1.00 17.60           C  
ATOM   1479  C   ALA B  33       0.461 -19.931 -12.310  1.00 21.03           C  
ATOM   1480  O   ALA B  33       0.763 -20.923 -11.644  1.00 20.93           O  
ATOM   1481  CB  ALA B  33       1.491 -17.713 -11.756  1.00 13.27           C  
ATOM   1482  H   ALA B  33       0.697 -18.786  -9.568  1.00  0.00           H  
ATOM   1483  N   ASP B  34       0.317 -19.977 -13.629  1.00 25.75           N  
ATOM   1484  CA  ASP B  34       0.510 -21.228 -14.366  1.00 32.05           C  
ATOM   1485  C   ASP B  34       1.922 -21.804 -14.267  1.00 30.96           C  
ATOM   1486  O   ASP B  34       2.108 -23.026 -14.259  1.00 31.51           O  
ATOM   1487  CB  ASP B  34       0.125 -21.049 -15.835  1.00 39.13           C  
ATOM   1488  CG  ASP B  34      -1.359 -21.207 -16.063  1.00 47.91           C  
ATOM   1489  OD1 ASP B  34      -1.894 -22.302 -15.771  1.00 54.16           O  
ATOM   1490  OD2 ASP B  34      -1.995 -20.240 -16.525  1.00 54.51           O  
ATOM   1491  H   ASP B  34       0.040 -19.167 -14.099  1.00  0.00           H  
ATOM   1492  N   ASP B  35       2.913 -20.921 -14.203  1.00 28.79           N  
ATOM   1493  CA  ASP B  35       4.307 -21.344 -14.113  1.00 28.62           C  
ATOM   1494  C   ASP B  35       4.864 -21.269 -12.684  1.00 23.38           C  
ATOM   1495  O   ASP B  35       6.079 -21.248 -12.475  1.00 23.95           O  
ATOM   1496  CB  ASP B  35       5.177 -20.543 -15.101  1.00 33.96           C  
ATOM   1497  CG  ASP B  35       5.178 -19.040 -14.819  1.00 40.97           C  
ATOM   1498  OD1 ASP B  35       4.126 -18.491 -14.416  1.00 42.48           O  
ATOM   1499  OD2 ASP B  35       6.242 -18.406 -15.017  1.00 45.52           O  
ATOM   1500  H   ASP B  35       2.680 -19.976 -14.196  1.00  0.00           H  
ATOM   1501  N   ALA B  36       3.968 -21.294 -11.706  1.00 17.95           N  
ATOM   1502  CA  ALA B  36       4.354 -21.217 -10.309  1.00 15.00           C  
ATOM   1503  C   ALA B  36       5.091 -22.465  -9.833  1.00 16.85           C  
ATOM   1504  O   ALA B  36       4.993 -23.533 -10.450  1.00 17.23           O  
ATOM   1505  CB  ALA B  36       3.125 -20.992  -9.451  1.00 11.88           C  
ATOM   1506  H   ALA B  36       3.015 -21.405 -11.905  1.00  0.00           H  
ATOM   1507  N   THR B  37       5.863 -22.303  -8.758  1.00 13.90           N  
ATOM   1508  CA  THR B  37       6.600 -23.401  -8.137  1.00 15.24           C  
ATOM   1509  C   THR B  37       6.344 -23.366  -6.631  1.00 14.65           C  
ATOM   1510  O   THR B  37       6.188 -22.289  -6.039  1.00 13.88           O  
ATOM   1511  CB  THR B  37       8.128 -23.317  -8.383  1.00 16.88           C  
ATOM   1512  OG1 THR B  37       8.639 -22.077  -7.880  1.00 22.30           O  
ATOM   1513  CG2 THR B  37       8.448 -23.433  -9.852  1.00 19.81           C  
ATOM   1514  H   THR B  37       5.938 -21.409  -8.356  1.00  0.00           H  
ATOM   1515  HG1 THR B  37       8.312 -21.374  -8.461  1.00  0.00           H  
ATOM   1516  N   VAL B  38       6.269 -24.540  -6.018  1.00 12.99           N  
ATOM   1517  CA  VAL B  38       6.049 -24.644  -4.585  1.00 11.82           C  
ATOM   1518  C   VAL B  38       7.196 -25.465  -4.026  1.00 12.99           C  
ATOM   1519  O   VAL B  38       7.574 -26.472  -4.617  1.00 11.15           O  
ATOM   1520  CB  VAL B  38       4.717 -25.362  -4.276  1.00 12.24           C  
ATOM   1521  CG1 VAL B  38       4.615 -25.707  -2.799  1.00  9.08           C  
ATOM   1522  CG2 VAL B  38       3.546 -24.486  -4.690  1.00 14.21           C  
ATOM   1523  H   VAL B  38       6.405 -25.367  -6.531  1.00  0.00           H  
ATOM   1524  N   GLU B  39       7.794 -24.985  -2.940  1.00 11.96           N  
ATOM   1525  CA  GLU B  39       8.883 -25.696  -2.267  1.00 13.56           C  
ATOM   1526  C   GLU B  39       8.419 -25.871  -0.830  1.00 11.49           C  
ATOM   1527  O   GLU B  39       8.441 -24.926  -0.042  1.00  9.27           O  
ATOM   1528  CB  GLU B  39      10.187 -24.895  -2.336  1.00 14.08           C  
ATOM   1529  CG  GLU B  39      10.800 -24.882  -3.720  1.00 13.21           C  
ATOM   1530  CD  GLU B  39      11.980 -23.947  -3.837  1.00 16.65           C  
ATOM   1531  OE1 GLU B  39      11.775 -22.769  -4.179  1.00 18.03           O  
ATOM   1532  OE2 GLU B  39      13.120 -24.387  -3.607  1.00 19.33           O  
ATOM   1533  H   GLU B  39       7.515 -24.126  -2.558  1.00  0.00           H  
ATOM   1534  N   ASP B  40       7.953 -27.072  -0.508  1.00 10.16           N  
ATOM   1535  CA  ASP B  40       7.431 -27.364   0.819  1.00  9.97           C  
ATOM   1536  C   ASP B  40       7.713 -28.820   1.222  1.00 12.38           C  
ATOM   1537  O   ASP B  40       7.143 -29.751   0.657  1.00 15.81           O  
ATOM   1538  CB  ASP B  40       5.922 -27.098   0.806  1.00  8.54           C  
ATOM   1539  CG  ASP B  40       5.284 -27.174   2.173  1.00  8.59           C  
ATOM   1540  OD1 ASP B  40       5.873 -27.723   3.113  1.00 13.14           O  
ATOM   1541  OD2 ASP B  40       4.150 -26.688   2.308  1.00 15.45           O  
ATOM   1542  H   ASP B  40       7.982 -27.790  -1.175  1.00  0.00           H  
ATOM   1543  HD2 ASP B  40       3.515 -27.256   1.864  1.00  0.00           H  
ATOM   1544  N   PRO B  41       8.597 -29.029   2.209  1.00 13.25           N  
ATOM   1545  CA  PRO B  41       9.320 -27.972   2.922  1.00 10.92           C  
ATOM   1546  C   PRO B  41      10.486 -27.461   2.083  1.00  9.56           C  
ATOM   1547  O   PRO B  41      10.922 -28.132   1.141  1.00 11.36           O  
ATOM   1548  CB  PRO B  41       9.793 -28.692   4.187  1.00 11.29           C  
ATOM   1549  CG  PRO B  41      10.047 -30.063   3.704  1.00 10.51           C  
ATOM   1550  CD  PRO B  41       8.838 -30.338   2.840  1.00 13.03           C  
ATOM   1551  N   PHE B  42      10.960 -26.260   2.386  1.00  9.64           N  
ATOM   1552  CA  PHE B  42      12.083 -25.694   1.660  1.00 10.34           C  
ATOM   1553  C   PHE B  42      13.246 -26.674   1.842  1.00 11.62           C  
ATOM   1554  O   PHE B  42      13.501 -27.151   2.956  1.00 13.62           O  
ATOM   1555  CB  PHE B  42      12.446 -24.315   2.216  1.00 11.23           C  
ATOM   1556  CG  PHE B  42      13.548 -23.633   1.458  1.00 11.46           C  
ATOM   1557  CD1 PHE B  42      13.319 -23.121   0.188  1.00 11.97           C  
ATOM   1558  CD2 PHE B  42      14.823 -23.525   2.005  1.00 12.45           C  
ATOM   1559  CE1 PHE B  42      14.346 -22.511  -0.524  1.00 16.28           C  
ATOM   1560  CE2 PHE B  42      15.859 -22.917   1.301  1.00 11.91           C  
ATOM   1561  CZ  PHE B  42      15.622 -22.410   0.038  1.00 11.24           C  
ATOM   1562  H   PHE B  42      10.581 -25.768   3.131  1.00  0.00           H  
ATOM   1563  N   GLY B  43      13.911 -27.006   0.744  1.00 11.98           N  
ATOM   1564  CA  GLY B  43      15.004 -27.964   0.787  1.00 15.27           C  
ATOM   1565  C   GLY B  43      14.660 -29.174  -0.080  1.00 18.12           C  
ATOM   1566  O   GLY B  43      15.547 -29.902  -0.538  1.00 17.52           O  
ATOM   1567  H   GLY B  43      13.657 -26.620  -0.118  1.00  0.00           H  
ATOM   1568  N   GLN B  44      13.361 -29.395  -0.285  1.00 17.18           N  
ATOM   1569  CA  GLN B  44      12.863 -30.490  -1.113  1.00 19.31           C  
ATOM   1570  C   GLN B  44      12.756 -30.007  -2.553  1.00 17.56           C  
ATOM   1571  O   GLN B  44      12.750 -28.804  -2.804  1.00 19.08           O  
ATOM   1572  CB  GLN B  44      11.478 -30.928  -0.636  1.00 20.00           C  
ATOM   1573  CG  GLN B  44      11.463 -31.501   0.754  1.00 30.51           C  
ATOM   1574  CD  GLN B  44      12.278 -32.772   0.869  1.00 37.04           C  
ATOM   1575  OE1 GLN B  44      13.270 -32.825   1.596  1.00 38.13           O  
ATOM   1576  NE2 GLN B  44      11.861 -33.809   0.150  1.00 40.25           N  
ATOM   1577  H   GLN B  44      12.698 -28.799   0.122  1.00  0.00           H  
ATOM   1578 HE21 GLN B  44      12.384 -34.633   0.227  1.00  0.00           H  
ATOM   1579 HE22 GLN B  44      11.064 -33.701  -0.409  1.00  0.00           H  
ATOM   1580  N   PRO B  45      12.730 -30.937  -3.523  1.00 19.06           N  
ATOM   1581  CA  PRO B  45      12.618 -30.548  -4.933  1.00 20.97           C  
ATOM   1582  C   PRO B  45      11.305 -29.792  -5.132  1.00 19.57           C  
ATOM   1583  O   PRO B  45      10.268 -30.194  -4.603  1.00 17.94           O  
ATOM   1584  CB  PRO B  45      12.589 -31.896  -5.652  1.00 20.97           C  
ATOM   1585  CG  PRO B  45      13.430 -32.757  -4.762  1.00 24.11           C  
ATOM   1586  CD  PRO B  45      12.910 -32.393  -3.399  1.00 21.14           C  
ATOM   1587  N   PRO B  46      11.343 -28.675  -5.873  1.00 21.17           N  
ATOM   1588  CA  PRO B  46      10.149 -27.862  -6.127  1.00 22.05           C  
ATOM   1589  C   PRO B  46       9.153 -28.502  -7.079  1.00 22.94           C  
ATOM   1590  O   PRO B  46       9.544 -29.157  -8.040  1.00 26.86           O  
ATOM   1591  CB  PRO B  46      10.736 -26.593  -6.736  1.00 23.33           C  
ATOM   1592  CG  PRO B  46      11.937 -27.097  -7.467  1.00 22.25           C  
ATOM   1593  CD  PRO B  46      12.536 -28.069  -6.492  1.00 20.86           C  
ATOM   1594  N   ILE B  47       7.864 -28.344  -6.796  1.00 22.16           N  
ATOM   1595  CA  ILE B  47       6.845 -28.882  -7.690  1.00 22.57           C  
ATOM   1596  C   ILE B  47       6.414 -27.713  -8.570  1.00 23.21           C  
ATOM   1597  O   ILE B  47       6.486 -26.555  -8.149  1.00 21.31           O  
ATOM   1598  CB  ILE B  47       5.639 -29.495  -6.936  1.00 21.86           C  
ATOM   1599  CG1 ILE B  47       4.876 -28.429  -6.168  1.00 23.18           C  
ATOM   1600  CG2 ILE B  47       6.111 -30.576  -5.976  1.00 24.04           C  
ATOM   1601  CD1 ILE B  47       3.758 -29.000  -5.347  1.00 28.64           C  
ATOM   1602  H   ILE B  47       7.616 -27.845  -5.994  1.00  0.00           H  
ATOM   1603  N   HIS B  48       6.002 -28.007  -9.795  1.00 26.30           N  
ATOM   1604  CA  HIS B  48       5.603 -26.960 -10.723  1.00 31.04           C  
ATOM   1605  C   HIS B  48       4.361 -27.307 -11.545  1.00 27.94           C  
ATOM   1606  O   HIS B  48       4.110 -28.469 -11.847  1.00 28.30           O  
ATOM   1607  CB  HIS B  48       6.784 -26.636 -11.651  1.00 40.78           C  
ATOM   1608  CG  HIS B  48       6.393 -25.905 -12.898  1.00 53.89           C  
ATOM   1609  ND1 HIS B  48       6.214 -24.539 -12.938  1.00 58.13           N  
ATOM   1610  CD2 HIS B  48       6.124 -26.356 -14.148  1.00 58.66           C  
ATOM   1611  CE1 HIS B  48       5.850 -24.179 -14.157  1.00 60.35           C  
ATOM   1612  NE2 HIS B  48       5.787 -25.263 -14.909  1.00 61.42           N  
ATOM   1613  H   HIS B  48       5.944 -28.948 -10.080  1.00  0.00           H  
ATOM   1614  HD1 HIS B  48       6.318 -23.902 -12.184  1.00  0.00           H  
ATOM   1615  HE2 HIS B  48       5.540 -25.281 -15.859  1.00  0.00           H  
ATOM   1616  N   GLY B  49       3.599 -26.289 -11.922  1.00 26.75           N  
ATOM   1617  CA  GLY B  49       2.416 -26.524 -12.730  1.00 26.73           C  
ATOM   1618  C   GLY B  49       1.168 -26.782 -11.914  1.00 23.69           C  
ATOM   1619  O   GLY B  49       1.231 -27.412 -10.856  1.00 22.27           O  
ATOM   1620  H   GLY B  49       3.786 -25.383 -11.593  1.00  0.00           H  
ATOM   1621  N   ARG B  50       0.033 -26.307 -12.429  1.00 23.65           N  
ATOM   1622  CA  ARG B  50      -1.268 -26.457 -11.770  1.00 23.61           C  
ATOM   1623  C   ARG B  50      -1.621 -27.875 -11.314  1.00 19.19           C  
ATOM   1624  O   ARG B  50      -2.056 -28.066 -10.181  1.00 21.58           O  
ATOM   1625  CB  ARG B  50      -2.393 -25.931 -12.673  1.00 29.34           C  
ATOM   1626  CG  ARG B  50      -2.306 -24.453 -13.018  1.00 32.54           C  
ATOM   1627  CD  ARG B  50      -2.407 -23.582 -11.787  1.00 36.87           C  
ATOM   1628  NE  ARG B  50      -2.484 -22.178 -12.165  1.00 41.53           N  
ATOM   1629  CZ  ARG B  50      -3.595 -21.452 -12.112  1.00 43.43           C  
ATOM   1630  NH1 ARG B  50      -4.730 -21.986 -11.683  1.00 45.53           N  
ATOM   1631  NH2 ARG B  50      -3.579 -20.198 -12.539  1.00 46.47           N  
ATOM   1632  H   ARG B  50       0.087 -25.796 -13.263  1.00  0.00           H  
ATOM   1633  HE  ARG B  50      -1.665 -21.738 -12.472  1.00  0.00           H  
ATOM   1634 HH11 ARG B  50      -4.761 -22.943 -11.397  1.00  0.00           H  
ATOM   1635 HH12 ARG B  50      -5.559 -21.429 -11.645  1.00  0.00           H  
ATOM   1636 HH21 ARG B  50      -2.731 -19.806 -12.893  1.00  0.00           H  
ATOM   1637 HH22 ARG B  50      -4.409 -19.645 -12.497  1.00  0.00           H  
ATOM   1638  N   GLU B  51      -1.446 -28.863 -12.187  1.00 15.96           N  
ATOM   1639  CA  GLU B  51      -1.777 -30.247 -11.833  1.00 17.32           C  
ATOM   1640  C   GLU B  51      -1.001 -30.744 -10.609  1.00 14.04           C  
ATOM   1641  O   GLU B  51      -1.581 -31.316  -9.688  1.00 12.34           O  
ATOM   1642  CB  GLU B  51      -1.549 -31.201 -13.011  1.00 20.29           C  
ATOM   1643  CG  GLU B  51      -1.987 -32.639 -12.699  1.00 26.75           C  
ATOM   1644  CD  GLU B  51      -1.562 -33.673 -13.739  1.00 30.02           C  
ATOM   1645  OE1 GLU B  51      -0.612 -33.423 -14.517  1.00 32.61           O  
ATOM   1646  OE2 GLU B  51      -2.179 -34.761 -13.751  1.00 33.10           O  
ATOM   1647  H   GLU B  51      -1.090 -28.624 -13.039  1.00  0.00           H  
ATOM   1648  N   GLN B  52       0.310 -30.532 -10.605  1.00 12.90           N  
ATOM   1649  CA  GLN B  52       1.141 -30.962  -9.486  1.00 13.13           C  
ATOM   1650  C   GLN B  52       0.802 -30.182  -8.229  1.00 11.60           C  
ATOM   1651  O   GLN B  52       0.742 -30.753  -7.138  1.00 12.85           O  
ATOM   1652  CB  GLN B  52       2.618 -30.783  -9.812  1.00 16.97           C  
ATOM   1653  CG  GLN B  52       3.147 -31.751 -10.852  1.00 26.88           C  
ATOM   1654  CD  GLN B  52       4.633 -31.559 -11.133  1.00 35.77           C  
ATOM   1655  OE1 GLN B  52       5.419 -31.216 -10.238  1.00 38.65           O  
ATOM   1656  NE2 GLN B  52       5.028 -31.779 -12.385  1.00 39.80           N  
ATOM   1657  H   GLN B  52       0.734 -30.062 -11.351  1.00  0.00           H  
ATOM   1658 HE21 GLN B  52       5.979 -31.673 -12.577  1.00  0.00           H  
ATOM   1659 HE22 GLN B  52       4.357 -32.034 -13.046  1.00  0.00           H  
ATOM   1660  N   ILE B  53       0.546 -28.884  -8.381  1.00 10.15           N  
ATOM   1661  CA  ILE B  53       0.218 -28.042  -7.239  1.00  9.74           C  
ATOM   1662  C   ILE B  53      -1.138 -28.409  -6.666  1.00  8.61           C  
ATOM   1663  O   ILE B  53      -1.315 -28.421  -5.449  1.00 10.17           O  
ATOM   1664  CB  ILE B  53       0.301 -26.541  -7.587  1.00 10.42           C  
ATOM   1665  CG1 ILE B  53       1.744 -26.187  -7.949  1.00 13.09           C  
ATOM   1666  CG2 ILE B  53      -0.154 -25.690  -6.409  1.00 10.10           C  
ATOM   1667  CD1 ILE B  53       1.954 -24.756  -8.356  1.00 15.40           C  
ATOM   1668  H   ILE B  53       0.594 -28.471  -9.268  1.00  0.00           H  
ATOM   1669  N   ALA B  54      -2.078 -28.767  -7.536  1.00  9.33           N  
ATOM   1670  CA  ALA B  54      -3.408 -29.169  -7.089  1.00 10.06           C  
ATOM   1671  C   ALA B  54      -3.292 -30.495  -6.328  1.00 10.53           C  
ATOM   1672  O   ALA B  54      -3.897 -30.667  -5.266  1.00  8.56           O  
ATOM   1673  CB  ALA B  54      -4.350 -29.317  -8.289  1.00 10.42           C  
ATOM   1674  H   ALA B  54      -1.880 -28.762  -8.488  1.00  0.00           H  
ATOM   1675  N   ALA B  55      -2.484 -31.413  -6.863  1.00 10.24           N  
ATOM   1676  CA  ALA B  55      -2.263 -32.719  -6.231  1.00  9.91           C  
ATOM   1677  C   ALA B  55      -1.670 -32.527  -4.838  1.00  9.49           C  
ATOM   1678  O   ALA B  55      -2.115 -33.152  -3.870  1.00 12.12           O  
ATOM   1679  CB  ALA B  55      -1.341 -33.567  -7.086  1.00  6.98           C  
ATOM   1680  H   ALA B  55      -2.042 -31.211  -7.715  1.00  0.00           H  
ATOM   1681  N   PHE B  56      -0.686 -31.634  -4.737  1.00  9.27           N  
ATOM   1682  CA  PHE B  56      -0.041 -31.320  -3.468  1.00  7.48           C  
ATOM   1683  C   PHE B  56      -1.077 -30.941  -2.409  1.00 10.34           C  
ATOM   1684  O   PHE B  56      -1.099 -31.514  -1.318  1.00 12.91           O  
ATOM   1685  CB  PHE B  56       0.957 -30.169  -3.670  1.00 11.26           C  
ATOM   1686  CG  PHE B  56       1.504 -29.582  -2.382  1.00 13.48           C  
ATOM   1687  CD1 PHE B  56       2.477 -30.259  -1.640  1.00 12.66           C  
ATOM   1688  CD2 PHE B  56       1.047 -28.350  -1.916  1.00 12.68           C  
ATOM   1689  CE1 PHE B  56       2.981 -29.713  -0.449  1.00 12.75           C  
ATOM   1690  CE2 PHE B  56       1.546 -27.801  -0.728  1.00 14.46           C  
ATOM   1691  CZ  PHE B  56       2.510 -28.482   0.002  1.00 11.01           C  
ATOM   1692  H   PHE B  56      -0.389 -31.172  -5.551  1.00  0.00           H  
ATOM   1693  N   TYR B  57      -1.941 -29.981  -2.730  1.00 11.65           N  
ATOM   1694  CA  TYR B  57      -2.963 -29.530  -1.789  1.00 11.54           C  
ATOM   1695  C   TYR B  57      -4.045 -30.561  -1.500  1.00 14.16           C  
ATOM   1696  O   TYR B  57      -4.527 -30.667  -0.370  1.00 12.73           O  
ATOM   1697  CB  TYR B  57      -3.592 -28.212  -2.261  1.00 11.76           C  
ATOM   1698  CG  TYR B  57      -2.690 -27.020  -2.033  1.00  9.67           C  
ATOM   1699  CD1 TYR B  57      -2.553 -26.472  -0.763  1.00  9.61           C  
ATOM   1700  CD2 TYR B  57      -1.926 -26.482  -3.074  1.00  9.34           C  
ATOM   1701  CE1 TYR B  57      -1.670 -25.420  -0.531  1.00 10.13           C  
ATOM   1702  CE2 TYR B  57      -1.038 -25.423  -2.852  1.00  8.45           C  
ATOM   1703  CZ  TYR B  57      -0.918 -24.905  -1.578  1.00  8.14           C  
ATOM   1704  OH  TYR B  57      -0.024 -23.890  -1.329  1.00  9.33           O  
ATOM   1705  H   TYR B  57      -1.886 -29.551  -3.611  1.00  0.00           H  
ATOM   1706  HH  TYR B  57       0.367 -23.978  -0.439  1.00  0.00           H  
ATOM   1707  N   ARG B  58      -4.432 -31.318  -2.517  1.00 14.21           N  
ATOM   1708  CA  ARG B  58      -5.450 -32.343  -2.338  1.00 19.92           C  
ATOM   1709  C   ARG B  58      -4.916 -33.396  -1.372  1.00 19.21           C  
ATOM   1710  O   ARG B  58      -5.620 -33.844  -0.471  1.00 18.34           O  
ATOM   1711  CB  ARG B  58      -5.780 -32.978  -3.682  1.00 22.87           C  
ATOM   1712  CG  ARG B  58      -6.940 -33.947  -3.660  1.00 31.53           C  
ATOM   1713  CD  ARG B  58      -7.895 -33.645  -4.811  1.00 40.11           C  
ATOM   1714  NE  ARG B  58      -7.190 -33.232  -6.028  1.00 48.29           N  
ATOM   1715  CZ  ARG B  58      -7.523 -32.176  -6.769  1.00 51.28           C  
ATOM   1716  NH1 ARG B  58      -8.556 -31.412  -6.428  1.00 54.55           N  
ATOM   1717  NH2 ARG B  58      -6.820 -31.876  -7.854  1.00 52.11           N  
ATOM   1718  H   ARG B  58      -4.023 -31.188  -3.396  1.00  0.00           H  
ATOM   1719  HE  ARG B  58      -6.421 -33.768  -6.316  1.00  0.00           H  
ATOM   1720 HH11 ARG B  58      -9.088 -31.629  -5.611  1.00  0.00           H  
ATOM   1721 HH12 ARG B  58      -8.802 -30.623  -6.990  1.00  0.00           H  
ATOM   1722 HH21 ARG B  58      -6.037 -32.442  -8.112  1.00  0.00           H  
ATOM   1723 HH22 ARG B  58      -7.070 -31.085  -8.410  1.00  0.00           H  
ATOM   1724  N   GLN B  59      -3.644 -33.739  -1.547  1.00 19.41           N  
ATOM   1725  CA  GLN B  59      -2.977 -34.724  -0.714  1.00 20.56           C  
ATOM   1726  C   GLN B  59      -2.813 -34.259   0.725  1.00 20.10           C  
ATOM   1727  O   GLN B  59      -3.023 -35.031   1.651  1.00 19.25           O  
ATOM   1728  CB  GLN B  59      -1.612 -35.052  -1.307  1.00 24.87           C  
ATOM   1729  CG  GLN B  59      -1.287 -36.521  -1.272  1.00 36.22           C  
ATOM   1730  CD  GLN B  59      -2.339 -37.368  -1.971  1.00 41.82           C  
ATOM   1731  OE1 GLN B  59      -3.170 -36.862  -2.734  1.00 44.98           O  
ATOM   1732  NE2 GLN B  59      -2.303 -38.671  -1.719  1.00 46.98           N  
ATOM   1733  H   GLN B  59      -3.140 -33.328  -2.273  1.00  0.00           H  
ATOM   1734 HE21 GLN B  59      -2.990 -39.204  -2.165  1.00  0.00           H  
ATOM   1735 HE22 GLN B  59      -1.620 -39.026  -1.122  1.00  0.00           H  
ATOM   1736  N   GLY B  60      -2.437 -32.996   0.906  1.00 19.56           N  
ATOM   1737  CA  GLY B  60      -2.244 -32.460   2.238  1.00 18.12           C  
ATOM   1738  C   GLY B  60      -3.504 -32.087   2.995  1.00 20.31           C  
ATOM   1739  O   GLY B  60      -3.573 -32.281   4.209  1.00 22.70           O  
ATOM   1740  H   GLY B  60      -2.288 -32.431   0.122  1.00  0.00           H  
ATOM   1741  N   LEU B  61      -4.496 -31.537   2.298  1.00 19.40           N  
ATOM   1742  CA  LEU B  61      -5.740 -31.126   2.944  1.00 20.89           C  
ATOM   1743  C   LEU B  61      -6.840 -32.181   2.861  1.00 23.19           C  
ATOM   1744  O   LEU B  61      -7.115 -32.733   1.796  1.00 28.71           O  
ATOM   1745  CB  LEU B  61      -6.231 -29.795   2.366  1.00 16.30           C  
ATOM   1746  CG  LEU B  61      -5.227 -28.639   2.443  1.00 17.45           C  
ATOM   1747  CD1 LEU B  61      -5.825 -27.374   1.843  1.00 13.84           C  
ATOM   1748  CD2 LEU B  61      -4.813 -28.413   3.884  1.00 13.25           C  
ATOM   1749  H   LEU B  61      -4.430 -31.459   1.329  1.00  0.00           H  
ATOM   1750  N   GLY B  62      -7.898 -31.830   3.541  1.00 38.53           N  
ATOM   1751  CA  GLY B  62      -9.344 -31.704   3.613  1.00 19.95           C  
ATOM   1752  C   GLY B  62     -10.044 -32.598   4.619  1.00 31.84           C  
ATOM   1753  O   GLY B  62     -11.031 -32.185   5.231  1.00 22.22           O  
ATOM   1754  H   GLY B  62      -7.585 -31.561   4.394  1.00  0.00           H  
ATOM   1755  N   GLY B  63      -9.543 -33.819   4.781  1.00 33.85           N  
ATOM   1756  CA  GLY B  63     -10.146 -34.764   5.707  1.00 64.37           C  
ATOM   1757  C   GLY B  63      -9.961 -34.435   7.177  1.00 57.78           C  
ATOM   1758  O   GLY B  63     -10.400 -33.390   7.657  1.00 28.53           O  
ATOM   1759  H   GLY B  63      -8.754 -34.088   4.266  1.00  0.00           H  
ATOM   1760  N   GLY B  64      -9.327 -35.350   7.905  1.00 67.88           N  
ATOM   1761  CA  GLY B  64      -9.099 -35.141   9.322  1.00 54.89           C  
ATOM   1762  C   GLY B  64      -8.151 -33.985   9.577  1.00 43.41           C  
ATOM   1763  O   GLY B  64      -7.374 -33.605   8.698  1.00 32.24           O  
ATOM   1764  H   GLY B  64      -9.010 -36.174   7.479  1.00  0.00           H  
ATOM   1765  N   LYS B  65      -8.863 -33.090   8.976  1.00 36.77           N  
ATOM   1766  CA  LYS B  65      -9.251 -31.824   9.593  1.00 39.00           C  
ATOM   1767  C   LYS B  65      -8.059 -30.896   9.835  1.00 35.32           C  
ATOM   1768  O   LYS B  65      -7.443 -30.927  10.903  1.00 36.92           O  
ATOM   1769  CB  LYS B  65      -9.979 -32.069  10.919  1.00 42.36           C  
ATOM   1770  CG  LYS B  65     -11.379 -32.638  10.785  1.00 48.61           C  
ATOM   1771  CD  LYS B  65     -11.370 -34.108  10.403  1.00 53.40           C  
ATOM   1772  CE  LYS B  65     -12.776 -34.679  10.463  1.00 55.41           C  
ATOM   1773  NZ  LYS B  65     -13.359 -34.536  11.831  1.00 57.58           N  
ATOM   1774  H   LYS B  65      -9.232 -33.308   8.097  1.00  0.00           H  
ATOM   1775  HZ1 LYS B  65     -12.753 -35.037  12.513  1.00  0.00           H  
ATOM   1776  HZ2 LYS B  65     -13.405 -33.530  12.089  1.00  0.00           H  
ATOM   1777  HZ3 LYS B  65     -14.316 -34.943  11.857  1.00  0.00           H  
ATOM   1778  N   VAL B  66      -7.741 -30.075   8.839  1.00 29.88           N  
ATOM   1779  CA  VAL B  66      -6.632 -29.135   8.946  1.00 25.96           C  
ATOM   1780  C   VAL B  66      -7.150 -27.739   9.258  1.00 25.00           C  
ATOM   1781  O   VAL B  66      -8.160 -27.298   8.706  1.00 24.23           O  
ATOM   1782  CB  VAL B  66      -5.802 -29.068   7.631  1.00 24.94           C  
ATOM   1783  CG1 VAL B  66      -4.737 -27.978   7.719  1.00 23.78           C  
ATOM   1784  CG2 VAL B  66      -5.144 -30.402   7.350  1.00 24.53           C  
ATOM   1785  H   VAL B  66      -8.266 -30.066   8.018  1.00  0.00           H  
ATOM   1786  N   ARG B  67      -6.502 -27.080  10.209  1.00 23.61           N  
ATOM   1787  CA  ARG B  67      -6.849 -25.714  10.561  1.00 22.32           C  
ATOM   1788  C   ARG B  67      -5.542 -24.926  10.624  1.00 20.82           C  
ATOM   1789  O   ARG B  67      -4.517 -25.429  11.098  1.00 18.69           O  
ATOM   1790  CB  ARG B  67      -7.645 -25.633  11.868  1.00 28.09           C  
ATOM   1791  CG  ARG B  67      -7.147 -26.501  12.997  1.00 40.63           C  
ATOM   1792  CD  ARG B  67      -8.009 -26.328  14.247  1.00 48.65           C  
ATOM   1793  NE  ARG B  67      -7.820 -25.022  14.879  1.00 56.17           N  
ATOM   1794  CZ  ARG B  67      -8.324 -24.677  16.063  1.00 60.20           C  
ATOM   1795  NH1 ARG B  67      -9.060 -25.539  16.758  1.00 64.42           N  
ATOM   1796  NH2 ARG B  67      -8.072 -23.477  16.567  1.00 61.03           N  
ATOM   1797  H   ARG B  67      -5.759 -27.525  10.676  1.00  0.00           H  
ATOM   1798  HE  ARG B  67      -7.285 -24.352  14.404  1.00  0.00           H  
ATOM   1799 HH11 ARG B  67      -9.245 -26.452  16.398  1.00  0.00           H  
ATOM   1800 HH12 ARG B  67      -9.432 -25.267  17.646  1.00  0.00           H  
ATOM   1801 HH21 ARG B  67      -7.506 -22.827  16.062  1.00  0.00           H  
ATOM   1802 HH22 ARG B  67      -8.451 -23.221  17.457  1.00  0.00           H  
ATOM   1803  N   ALA B  68      -5.548 -23.736  10.042  1.00 16.65           N  
ATOM   1804  CA  ALA B  68      -4.353 -22.903  10.018  1.00 13.92           C  
ATOM   1805  C   ALA B  68      -4.706 -21.508  10.501  1.00 14.34           C  
ATOM   1806  O   ALA B  68      -5.812 -21.014  10.258  1.00 15.42           O  
ATOM   1807  CB  ALA B  68      -3.769 -22.863   8.605  1.00  8.11           C  
ATOM   1808  H   ALA B  68      -6.353 -23.377   9.621  1.00  0.00           H  
ATOM   1809  N   CYS B  69      -3.780 -20.893  11.221  1.00 13.39           N  
ATOM   1810  CA  CYS B  69      -3.998 -19.560  11.751  1.00 16.83           C  
ATOM   1811  C   CYS B  69      -2.723 -18.733  11.771  1.00 14.95           C  
ATOM   1812  O   CYS B  69      -1.660 -19.229  12.166  1.00 15.16           O  
ATOM   1813  CB  CYS B  69      -4.584 -19.645  13.169  1.00 19.53           C  
ATOM   1814  SG  CYS B  69      -3.924 -20.991  14.188  1.00 36.21           S  
ATOM   1815  H   CYS B  69      -2.928 -21.342  11.427  1.00  0.00           H  
ATOM   1816  N   LEU B  70      -2.824 -17.487  11.313  1.00 11.29           N  
ATOM   1817  CA  LEU B  70      -1.691 -16.584  11.320  1.00  8.75           C  
ATOM   1818  C   LEU B  70      -1.318 -16.396  12.770  1.00  8.75           C  
ATOM   1819  O   LEU B  70      -2.183 -16.214  13.613  1.00 10.88           O  
ATOM   1820  CB  LEU B  70      -2.081 -15.227  10.746  1.00  8.70           C  
ATOM   1821  CG  LEU B  70      -1.871 -15.020   9.253  1.00 10.26           C  
ATOM   1822  CD1 LEU B  70      -2.434 -13.663   8.845  1.00 12.81           C  
ATOM   1823  CD2 LEU B  70      -0.387 -15.084   8.937  1.00 10.22           C  
ATOM   1824  H   LEU B  70      -3.683 -17.159  10.991  1.00  0.00           H  
ATOM   1825  N   THR B  71      -0.035 -16.481  13.077  1.00  9.17           N  
ATOM   1826  CA  THR B  71       0.384 -16.304  14.457  1.00 11.68           C  
ATOM   1827  C   THR B  71       1.078 -14.954  14.651  1.00  9.10           C  
ATOM   1828  O   THR B  71       1.469 -14.597  15.761  1.00 11.57           O  
ATOM   1829  CB  THR B  71       1.277 -17.466  14.912  1.00 12.35           C  
ATOM   1830  OG1 THR B  71       2.319 -17.675  13.950  1.00 13.17           O  
ATOM   1831  CG2 THR B  71       0.443 -18.738  15.047  1.00 12.49           C  
ATOM   1832  H   THR B  71       0.633 -16.633  12.385  1.00  0.00           H  
ATOM   1833  HG1 THR B  71       1.933 -17.883  13.102  1.00  0.00           H  
ATOM   1834  N   GLY B  72       1.177 -14.196  13.562  1.00 10.61           N  
ATOM   1835  CA  GLY B  72       1.796 -12.887  13.604  1.00  9.13           C  
ATOM   1836  C   GLY B  72       1.476 -12.122  12.332  1.00 12.33           C  
ATOM   1837  O   GLY B  72       0.883 -12.689  11.408  1.00  9.96           O  
ATOM   1838  H   GLY B  72       0.826 -14.531  12.692  1.00  0.00           H  
ATOM   1839  N   PRO B  73       1.867 -10.839  12.253  1.00 11.99           N  
ATOM   1840  CA  PRO B  73       1.631  -9.970  11.093  1.00 11.32           C  
ATOM   1841  C   PRO B  73       2.361 -10.448   9.853  1.00  7.87           C  
ATOM   1842  O   PRO B  73       3.469 -10.992   9.941  1.00  8.02           O  
ATOM   1843  CB  PRO B  73       2.228  -8.627  11.543  1.00 11.29           C  
ATOM   1844  CG  PRO B  73       2.190  -8.673  13.020  1.00 12.70           C  
ATOM   1845  CD  PRO B  73       2.550 -10.093  13.325  1.00 11.68           C  
ATOM   1846  N   VAL B  74       1.742 -10.236   8.698  1.00  7.42           N  
ATOM   1847  CA  VAL B  74       2.367 -10.598   7.435  1.00  8.34           C  
ATOM   1848  C   VAL B  74       3.397  -9.488   7.194  1.00 11.10           C  
ATOM   1849  O   VAL B  74       3.103  -8.295   7.357  1.00  7.24           O  
ATOM   1850  CB  VAL B  74       1.346 -10.604   6.254  1.00  6.65           C  
ATOM   1851  CG1 VAL B  74       2.073 -10.786   4.911  1.00  6.00           C  
ATOM   1852  CG2 VAL B  74       0.304 -11.699   6.441  1.00  6.77           C  
ATOM   1853  H   VAL B  74       0.902  -9.738   8.658  1.00  0.00           H  
ATOM   1854  N   ARG B  75       4.623  -9.886   6.895  1.00 11.39           N  
ATOM   1855  CA  ARG B  75       5.685  -8.922   6.603  1.00 10.60           C  
ATOM   1856  C   ARG B  75       5.690  -8.762   5.091  1.00 10.56           C  
ATOM   1857  O   ARG B  75       5.917  -9.727   4.364  1.00 11.68           O  
ATOM   1858  CB  ARG B  75       7.039  -9.436   7.100  1.00  6.79           C  
ATOM   1859  CG  ARG B  75       7.315  -9.146   8.565  1.00  6.00           C  
ATOM   1860  CD  ARG B  75       6.447  -9.931   9.520  1.00  6.00           C  
ATOM   1861  NE  ARG B  75       7.033  -9.882  10.853  1.00  6.95           N  
ATOM   1862  CZ  ARG B  75       6.595 -10.540  11.923  1.00  6.35           C  
ATOM   1863  NH1 ARG B  75       5.520 -11.318  11.847  1.00  6.00           N  
ATOM   1864  NH2 ARG B  75       7.266 -10.460  13.061  1.00  6.00           N  
ATOM   1865  H   ARG B  75       4.770 -10.849   6.892  1.00  0.00           H  
ATOM   1866  HE  ARG B  75       7.815  -9.316  10.984  1.00  0.00           H  
ATOM   1867 HH11 ARG B  75       5.041 -11.415  10.976  1.00  0.00           H  
ATOM   1868 HH12 ARG B  75       5.198 -11.811  12.656  1.00  0.00           H  
ATOM   1869 HH21 ARG B  75       8.097  -9.909  13.128  1.00  0.00           H  
ATOM   1870 HH22 ARG B  75       6.937 -10.950  13.864  1.00  0.00           H  
ATOM   1871  N   ALA B  76       5.414  -7.557   4.606  1.00 11.01           N  
ATOM   1872  CA  ALA B  76       5.359  -7.346   3.170  1.00  9.40           C  
ATOM   1873  C   ALA B  76       6.398  -6.364   2.684  1.00 10.22           C  
ATOM   1874  O   ALA B  76       6.767  -5.443   3.408  1.00 11.25           O  
ATOM   1875  CB  ALA B  76       3.970  -6.889   2.774  1.00 10.10           C  
ATOM   1876  H   ALA B  76       5.258  -6.774   5.196  1.00  0.00           H  
ATOM   1877  N   SER B  77       6.917  -6.595   1.484  1.00 10.19           N  
ATOM   1878  CA  SER B  77       7.914  -5.706   0.908  1.00 13.12           C  
ATOM   1879  C   SER B  77       7.251  -4.899  -0.204  1.00 14.55           C  
ATOM   1880  O   SER B  77       6.047  -5.021  -0.436  1.00 14.09           O  
ATOM   1881  CB  SER B  77       9.087  -6.514   0.363  1.00 13.46           C  
ATOM   1882  OG  SER B  77       8.701  -7.274  -0.770  1.00 20.77           O  
ATOM   1883  H   SER B  77       6.603  -7.336   0.933  1.00  0.00           H  
ATOM   1884  HG  SER B  77       9.323  -8.012  -0.801  1.00  0.00           H  
ATOM   1885  N   HIS B  78       8.028  -4.057  -0.874  1.00 14.50           N  
ATOM   1886  CA  HIS B  78       7.496  -3.235  -1.961  1.00 13.88           C  
ATOM   1887  C   HIS B  78       7.682  -3.852  -3.337  1.00 15.05           C  
ATOM   1888  O   HIS B  78       7.263  -3.275  -4.337  1.00 18.58           O  
ATOM   1889  CB  HIS B  78       8.140  -1.848  -1.940  1.00 12.54           C  
ATOM   1890  CG  HIS B  78       7.755  -1.032  -0.750  1.00  9.75           C  
ATOM   1891  ND1 HIS B  78       6.445  -0.750  -0.433  1.00 14.39           N  
ATOM   1892  CD2 HIS B  78       8.507  -0.456   0.212  1.00 14.12           C  
ATOM   1893  CE1 HIS B  78       6.403  -0.031   0.672  1.00 13.51           C  
ATOM   1894  NE2 HIS B  78       7.644   0.164   1.083  1.00 12.49           N  
ATOM   1895  H   HIS B  78       8.971  -3.946  -0.606  1.00  0.00           H  
ATOM   1896  HD1 HIS B  78       5.654  -1.004  -0.931  1.00  0.00           H  
ATOM   1897  HE2 HIS B  78       7.976   0.709   1.815  1.00  0.00           H  
ATOM   1898  N   ASN B  79       8.315  -5.016  -3.401  1.00 12.57           N  
ATOM   1899  CA  ASN B  79       8.527  -5.660  -4.687  1.00 12.66           C  
ATOM   1900  C   ASN B  79       7.644  -6.894  -4.899  1.00 12.84           C  
ATOM   1901  O   ASN B  79       7.987  -7.809  -5.648  1.00 12.68           O  
ATOM   1902  CB  ASN B  79      10.021  -5.936  -4.938  1.00 17.25           C  
ATOM   1903  CG  ASN B  79      10.565  -7.119  -4.148  1.00 18.16           C  
ATOM   1904  OD1 ASN B  79      11.408  -7.857  -4.651  1.00 25.56           O  
ATOM   1905  ND2 ASN B  79      10.138  -7.272  -2.906  1.00 15.57           N  
ATOM   1906  H   ASN B  79       8.583  -5.426  -2.559  1.00  0.00           H  
ATOM   1907 HD21 ASN B  79      10.552  -8.065  -2.505  1.00  0.00           H  
ATOM   1908 HD22 ASN B  79       9.509  -6.681  -2.465  1.00  0.00           H  
ATOM   1909  N   GLY B  80       6.477  -6.876  -4.257  1.00 12.32           N  
ATOM   1910  CA  GLY B  80       5.517  -7.954  -4.387  1.00 12.47           C  
ATOM   1911  C   GLY B  80       5.877  -9.250  -3.698  1.00 14.46           C  
ATOM   1912  O   GLY B  80       5.513 -10.323  -4.176  1.00 12.87           O  
ATOM   1913  H   GLY B  80       6.253  -6.128  -3.669  1.00  0.00           H  
ATOM   1914  N   CYS B  81       6.549  -9.151  -2.562  1.00 11.31           N  
ATOM   1915  CA  CYS B  81       6.940 -10.323  -1.815  1.00  9.13           C  
ATOM   1916  C   CYS B  81       6.513 -10.149  -0.372  1.00 10.66           C  
ATOM   1917  O   CYS B  81       6.370  -9.021   0.110  1.00 10.38           O  
ATOM   1918  CB  CYS B  81       8.455 -10.513  -1.881  1.00 11.36           C  
ATOM   1919  SG  CYS B  81       9.110 -10.881  -3.506  1.00 15.20           S  
ATOM   1920  H   CYS B  81       6.742  -8.277  -2.170  1.00  0.00           H  
ATOM   1921  N   GLY B  82       6.317 -11.269   0.318  1.00  6.78           N  
ATOM   1922  CA  GLY B  82       5.917 -11.212   1.707  1.00  7.63           C  
ATOM   1923  C   GLY B  82       6.323 -12.465   2.452  1.00  6.97           C  
ATOM   1924  O   GLY B  82       6.723 -13.458   1.837  1.00  8.34           O  
ATOM   1925  H   GLY B  82       6.435 -12.154  -0.097  1.00  0.00           H  
ATOM   1926  N   ALA B  83       6.213 -12.421   3.775  1.00  6.00           N  
ATOM   1927  CA  ALA B  83       6.560 -13.556   4.617  1.00  6.00           C  
ATOM   1928  C   ALA B  83       5.609 -13.543   5.796  1.00  6.00           C  
ATOM   1929  O   ALA B  83       5.270 -12.482   6.314  1.00  6.00           O  
ATOM   1930  CB  ALA B  83       8.009 -13.454   5.089  1.00  7.39           C  
ATOM   1931  H   ALA B  83       5.878 -11.623   4.234  1.00  0.00           H  
ATOM   1932  N   MET B  84       5.179 -14.721   6.226  1.00  6.25           N  
ATOM   1933  CA  MET B  84       4.233 -14.804   7.330  1.00  6.63           C  
ATOM   1934  C   MET B  84       4.424 -16.032   8.196  1.00  6.00           C  
ATOM   1935  O   MET B  84       4.839 -17.084   7.716  1.00  6.00           O  
ATOM   1936  CB  MET B  84       2.799 -14.816   6.788  1.00  7.24           C  
ATOM   1937  CG  MET B  84       2.486 -16.031   5.920  1.00 10.02           C  
ATOM   1938  SD  MET B  84       0.793 -16.084   5.316  1.00 12.26           S  
ATOM   1939  CE  MET B  84       0.989 -17.169   3.923  1.00  6.00           C  
ATOM   1940  H   MET B  84       5.500 -15.554   5.800  1.00  0.00           H  
ATOM   1941  N   PRO B  85       4.185 -15.882   9.506  1.00  8.04           N  
ATOM   1942  CA  PRO B  85       4.305 -16.962  10.484  1.00  9.41           C  
ATOM   1943  C   PRO B  85       2.899 -17.523  10.742  1.00  9.02           C  
ATOM   1944  O   PRO B  85       1.923 -16.771  10.794  1.00  9.70           O  
ATOM   1945  CB  PRO B  85       4.847 -16.230  11.707  1.00  8.54           C  
ATOM   1946  CG  PRO B  85       4.095 -14.927  11.661  1.00  6.16           C  
ATOM   1947  CD  PRO B  85       4.004 -14.579  10.180  1.00  6.00           C  
ATOM   1948  N   PHE B  86       2.771 -18.836  10.850  1.00  7.35           N  
ATOM   1949  CA  PHE B  86       1.462 -19.413  11.118  1.00  7.60           C  
ATOM   1950  C   PHE B  86       1.580 -20.798  11.707  1.00  8.90           C  
ATOM   1951  O   PHE B  86       2.647 -21.410  11.666  1.00  8.27           O  
ATOM   1952  CB  PHE B  86       0.583 -19.430   9.854  1.00  7.58           C  
ATOM   1953  CG  PHE B  86       1.120 -20.274   8.730  1.00  9.00           C  
ATOM   1954  CD1 PHE B  86       2.116 -19.787   7.887  1.00  6.00           C  
ATOM   1955  CD2 PHE B  86       0.599 -21.541   8.487  1.00  8.90           C  
ATOM   1956  CE1 PHE B  86       2.583 -20.541   6.821  1.00  6.09           C  
ATOM   1957  CE2 PHE B  86       1.061 -22.306   7.418  1.00  9.47           C  
ATOM   1958  CZ  PHE B  86       2.054 -21.806   6.585  1.00  7.65           C  
ATOM   1959  H   PHE B  86       3.556 -19.428  10.755  1.00  0.00           H  
ATOM   1960  N   ARG B  87       0.511 -21.241  12.351  1.00  9.90           N  
ATOM   1961  CA  ARG B  87       0.476 -22.569  12.938  1.00 11.45           C  
ATOM   1962  C   ARG B  87      -0.571 -23.423  12.224  1.00 11.53           C  
ATOM   1963  O   ARG B  87      -1.628 -22.929  11.817  1.00 11.73           O  
ATOM   1964  CB  ARG B  87       0.174 -22.510  14.436  1.00 13.80           C  
ATOM   1965  CG  ARG B  87      -0.318 -23.841  14.996  1.00 24.15           C  
ATOM   1966  CD  ARG B  87      -0.296 -23.894  16.507  1.00 31.47           C  
ATOM   1967  NE  ARG B  87       1.056 -24.137  17.000  1.00 38.99           N  
ATOM   1968  CZ  ARG B  87       1.359 -24.997  17.965  1.00 41.06           C  
ATOM   1969  NH1 ARG B  87       0.413 -25.714  18.555  1.00 42.72           N  
ATOM   1970  NH2 ARG B  87       2.620 -25.136  18.344  1.00 46.38           N  
ATOM   1971  H   ARG B  87      -0.292 -20.681  12.418  1.00  0.00           H  
ATOM   1972  HE  ARG B  87       1.795 -23.639  16.593  1.00  0.00           H  
ATOM   1973 HH11 ARG B  87      -0.544 -25.635  18.276  1.00  0.00           H  
ATOM   1974 HH12 ARG B  87       0.657 -26.359  19.279  1.00  0.00           H  
ATOM   1975 HH21 ARG B  87       3.323 -24.581  17.900  1.00  0.00           H  
ATOM   1976 HH22 ARG B  87       2.856 -25.785  19.066  1.00  0.00           H  
ATOM   1977  N   VAL B  88      -0.242 -24.693  12.028  1.00 11.33           N  
ATOM   1978  CA  VAL B  88      -1.140 -25.633  11.379  1.00 11.53           C  
ATOM   1979  C   VAL B  88      -1.447 -26.736  12.383  1.00 13.14           C  
ATOM   1980  O   VAL B  88      -0.560 -27.202  13.100  1.00 12.68           O  
ATOM   1981  CB  VAL B  88      -0.497 -26.260  10.114  1.00 12.89           C  
ATOM   1982  CG1 VAL B  88      -1.449 -27.273   9.491  1.00 17.96           C  
ATOM   1983  CG2 VAL B  88      -0.149 -25.179   9.102  1.00 16.04           C  
ATOM   1984  H   VAL B  88       0.628 -25.018  12.335  1.00  0.00           H  
ATOM   1985  N   GLU B  89      -2.715 -27.096  12.490  1.00 11.50           N  
ATOM   1986  CA  GLU B  89      -3.122 -28.155  13.390  1.00 14.31           C  
ATOM   1987  C   GLU B  89      -3.783 -29.207  12.532  1.00 16.39           C  
ATOM   1988  O   GLU B  89      -4.667 -28.901  11.728  1.00 14.73           O  
ATOM   1989  CB  GLU B  89      -4.123 -27.653  14.427  1.00 15.63           C  
ATOM   1990  CG  GLU B  89      -3.523 -26.856  15.561  1.00 22.41           C  
ATOM   1991  CD  GLU B  89      -4.565 -26.416  16.577  1.00 28.47           C  
ATOM   1992  OE1 GLU B  89      -5.603 -27.100  16.726  1.00 36.40           O  
ATOM   1993  OE2 GLU B  89      -4.348 -25.379  17.233  1.00 35.07           O  
ATOM   1994  H   GLU B  89      -3.405 -26.662  11.954  1.00  0.00           H  
ATOM   1995  N   MET B  90      -3.318 -30.438  12.661  1.00 17.68           N  
ATOM   1996  CA  MET B  90      -3.894 -31.523  11.896  1.00 18.11           C  
ATOM   1997  C   MET B  90      -3.872 -32.804  12.713  1.00 19.06           C  
ATOM   1998  O   MET B  90      -3.554 -32.792  13.906  1.00 15.84           O  
ATOM   1999  CB  MET B  90      -3.198 -31.697  10.533  1.00 20.06           C  
ATOM   2000  CG  MET B  90      -1.771 -32.208  10.563  1.00 22.56           C  
ATOM   2001  SD  MET B  90      -0.569 -30.930  10.198  1.00 33.58           S  
ATOM   2002  CE  MET B  90      -0.174 -30.422  11.820  1.00 16.84           C  
ATOM   2003  H   MET B  90      -2.638 -30.636  13.337  1.00  0.00           H  
ATOM   2004  N   VAL B  91      -4.224 -33.904  12.065  1.00 20.33           N  
ATOM   2005  CA  VAL B  91      -4.277 -35.196  12.721  1.00 21.32           C  
ATOM   2006  C   VAL B  91      -3.437 -36.230  11.974  1.00 19.48           C  
ATOM   2007  O   VAL B  91      -3.207 -36.114  10.763  1.00 21.24           O  
ATOM   2008  CB  VAL B  91      -5.756 -35.660  12.828  1.00 21.48           C  
ATOM   2009  CG1 VAL B  91      -5.842 -37.068  13.310  1.00 26.82           C  
ATOM   2010  CG2 VAL B  91      -6.524 -34.748  13.776  1.00 24.46           C  
ATOM   2011  H   VAL B  91      -4.452 -33.857  11.111  1.00  0.00           H  
ATOM   2012  N   TRP B  92      -2.925 -37.202  12.722  1.00 18.82           N  
ATOM   2013  CA  TRP B  92      -2.140 -38.299  12.167  1.00 14.97           C  
ATOM   2014  C   TRP B  92      -2.695 -39.537  12.868  1.00 15.95           C  
ATOM   2015  O   TRP B  92      -2.544 -39.682  14.081  1.00 13.55           O  
ATOM   2016  CB  TRP B  92      -0.657 -38.123  12.495  1.00 14.37           C  
ATOM   2017  CG  TRP B  92       0.258 -39.026  11.715  1.00 13.90           C  
ATOM   2018  CD1 TRP B  92      -0.095 -39.937  10.754  1.00 13.78           C  
ATOM   2019  CD2 TRP B  92       1.686 -39.070  11.804  1.00 15.75           C  
ATOM   2020  NE1 TRP B  92       1.031 -40.539  10.238  1.00 16.22           N  
ATOM   2021  CE2 TRP B  92       2.136 -40.025  10.862  1.00 14.55           C  
ATOM   2022  CE3 TRP B  92       2.634 -38.387  12.585  1.00 13.14           C  
ATOM   2023  CZ2 TRP B  92       3.493 -40.318  10.683  1.00 16.63           C  
ATOM   2024  CZ3 TRP B  92       3.981 -38.679  12.407  1.00 11.60           C  
ATOM   2025  CH2 TRP B  92       4.399 -39.635  11.461  1.00 11.31           C  
ATOM   2026  H   TRP B  92      -3.049 -37.177  13.691  1.00  0.00           H  
ATOM   2027  HE1 TRP B  92       1.029 -41.229   9.531  1.00  0.00           H  
ATOM   2028  N   ASN B  93      -3.411 -40.375  12.116  1.00 19.41           N  
ATOM   2029  CA  ASN B  93      -4.027 -41.598  12.656  1.00 20.24           C  
ATOM   2030  C   ASN B  93      -4.856 -41.280  13.905  1.00 22.39           C  
ATOM   2031  O   ASN B  93      -4.711 -41.930  14.945  1.00 22.86           O  
ATOM   2032  CB  ASN B  93      -2.966 -42.659  13.001  1.00 20.60           C  
ATOM   2033  CG  ASN B  93      -2.372 -43.337  11.770  1.00 25.43           C  
ATOM   2034  OD1 ASN B  93      -2.501 -42.852  10.645  1.00 27.73           O  
ATOM   2035  ND2 ASN B  93      -1.706 -44.460  11.986  1.00 31.10           N  
ATOM   2036  H   ASN B  93      -3.490 -40.190  11.159  1.00  0.00           H  
ATOM   2037 HD21 ASN B  93      -1.303 -44.931  11.224  1.00  0.00           H  
ATOM   2038 HD22 ASN B  93      -1.646 -44.779  12.906  1.00  0.00           H  
ATOM   2039  N   GLY B  94      -5.677 -40.235  13.814  1.00 21.58           N  
ATOM   2040  CA  GLY B  94      -6.516 -39.851  14.937  1.00 21.66           C  
ATOM   2041  C   GLY B  94      -5.835 -39.027  16.017  1.00 23.56           C  
ATOM   2042  O   GLY B  94      -6.511 -38.476  16.886  1.00 26.10           O  
ATOM   2043  H   GLY B  94      -5.714 -39.724  12.987  1.00  0.00           H  
ATOM   2044  N   GLN B  95      -4.514 -38.905  15.948  1.00 20.74           N  
ATOM   2045  CA  GLN B  95      -3.764 -38.142  16.936  1.00 21.13           C  
ATOM   2046  C   GLN B  95      -3.483 -36.707  16.495  1.00 18.13           C  
ATOM   2047  O   GLN B  95      -2.992 -36.470  15.392  1.00 18.13           O  
ATOM   2048  CB  GLN B  95      -2.442 -38.844  17.238  1.00 28.39           C  
ATOM   2049  CG  GLN B  95      -2.227 -39.166  18.715  1.00 40.39           C  
ATOM   2050  CD  GLN B  95      -2.153 -37.922  19.593  1.00 44.95           C  
ATOM   2051  OE1 GLN B  95      -2.854 -37.819  20.600  1.00 49.73           O  
ATOM   2052  NE2 GLN B  95      -1.310 -36.970  19.210  1.00 45.03           N  
ATOM   2053  H   GLN B  95      -4.016 -39.372  15.255  1.00  0.00           H  
ATOM   2054 HE21 GLN B  95      -1.289 -36.174  19.776  1.00  0.00           H  
ATOM   2055 HE22 GLN B  95      -0.758 -37.081  18.401  1.00  0.00           H  
ATOM   2056  N   PRO B  96      -3.809 -35.728  17.351  1.00 16.85           N  
ATOM   2057  CA  PRO B  96      -3.597 -34.301  17.083  1.00 14.92           C  
ATOM   2058  C   PRO B  96      -2.112 -33.962  17.004  1.00 12.57           C  
ATOM   2059  O   PRO B  96      -1.306 -34.434  17.813  1.00 11.13           O  
ATOM   2060  CB  PRO B  96      -4.232 -33.627  18.300  1.00 16.50           C  
ATOM   2061  CG  PRO B  96      -5.286 -34.582  18.712  1.00 20.77           C  
ATOM   2062  CD  PRO B  96      -4.574 -35.907  18.596  1.00 17.16           C  
ATOM   2063  N   CYS B  97      -1.770 -33.119  16.041  1.00 12.64           N  
ATOM   2064  CA  CYS B  97      -0.401 -32.675  15.816  1.00 13.22           C  
ATOM   2065  C   CYS B  97      -0.423 -31.167  15.523  1.00 14.54           C  
ATOM   2066  O   CYS B  97      -1.481 -30.602  15.239  1.00 16.23           O  
ATOM   2067  CB  CYS B  97       0.186 -33.397  14.599  1.00 10.19           C  
ATOM   2068  SG  CYS B  97       0.149 -35.200  14.677  1.00 12.02           S  
ATOM   2069  H   CYS B  97      -2.480 -32.750  15.470  1.00  0.00           H  
ATOM   2070  N   ALA B  98       0.735 -30.521  15.583  1.00 14.05           N  
ATOM   2071  CA  ALA B  98       0.846 -29.094  15.279  1.00 11.12           C  
ATOM   2072  C   ALA B  98       2.186 -28.828  14.642  1.00 10.78           C  
ATOM   2073  O   ALA B  98       3.167 -29.487  14.974  1.00 11.52           O  
ATOM   2074  CB  ALA B  98       0.731 -28.276  16.504  1.00 11.32           C  
ATOM   2075  H   ALA B  98       1.564 -30.996  15.816  1.00  0.00           H  
ATOM   2076  N   LEU B  99       2.233 -27.834  13.760  1.00 10.41           N  
ATOM   2077  CA  LEU B  99       3.460 -27.458  13.073  1.00  8.44           C  
ATOM   2078  C   LEU B  99       3.513 -25.939  12.921  1.00 10.65           C  
ATOM   2079  O   LEU B  99       2.524 -25.317  12.511  1.00 10.22           O  
ATOM   2080  CB  LEU B  99       3.495 -28.101  11.687  1.00  6.92           C  
ATOM   2081  CG  LEU B  99       4.723 -27.829  10.824  1.00  8.23           C  
ATOM   2082  CD1 LEU B  99       5.916 -28.619  11.329  1.00  6.00           C  
ATOM   2083  CD2 LEU B  99       4.418 -28.189   9.387  1.00 11.96           C  
ATOM   2084  H   LEU B  99       1.431 -27.302  13.557  1.00  0.00           H  
ATOM   2085  N   ASP B 100       4.644 -25.345  13.296  1.00  9.94           N  
ATOM   2086  CA  ASP B 100       4.863 -23.903  13.175  1.00  8.76           C  
ATOM   2087  C   ASP B 100       5.585 -23.713  11.851  1.00  7.84           C  
ATOM   2088  O   ASP B 100       6.593 -24.375  11.592  1.00  7.49           O  
ATOM   2089  CB  ASP B 100       5.712 -23.390  14.328  1.00  7.57           C  
ATOM   2090  CG  ASP B 100       5.016 -23.516  15.644  1.00 11.47           C  
ATOM   2091  OD1 ASP B 100       3.823 -23.161  15.714  1.00 12.42           O  
ATOM   2092  OD2 ASP B 100       5.649 -23.985  16.606  1.00 14.54           O  
ATOM   2093  H   ASP B 100       5.372 -25.904  13.645  1.00  0.00           H  
ATOM   2094  N   VAL B 101       5.057 -22.832  11.005  1.00  7.50           N  
ATOM   2095  CA  VAL B 101       5.617 -22.616   9.676  1.00  7.85           C  
ATOM   2096  C   VAL B 101       5.778 -21.146   9.311  1.00  7.17           C  
ATOM   2097  O   VAL B 101       5.117 -20.271   9.869  1.00  6.00           O  
ATOM   2098  CB  VAL B 101       4.664 -23.214   8.593  1.00  7.16           C  
ATOM   2099  CG1 VAL B 101       5.333 -23.238   7.221  1.00  6.00           C  
ATOM   2100  CG2 VAL B 101       4.167 -24.592   9.004  1.00 10.24           C  
ATOM   2101  H   VAL B 101       4.280 -22.294  11.271  1.00  0.00           H  
ATOM   2102  N   ILE B 102       6.678 -20.891   8.372  1.00  7.71           N  
ATOM   2103  CA  ILE B 102       6.867 -19.558   7.836  1.00  6.91           C  
ATOM   2104  C   ILE B 102       6.875 -19.736   6.328  1.00  6.00           C  
ATOM   2105  O   ILE B 102       7.643 -20.538   5.807  1.00  6.16           O  
ATOM   2106  CB  ILE B 102       8.191 -18.874   8.286  1.00  6.67           C  
ATOM   2107  CG1 ILE B 102       8.032 -18.277   9.684  1.00  6.00           C  
ATOM   2108  CG2 ILE B 102       8.551 -17.741   7.310  1.00 10.28           C  
ATOM   2109  CD1 ILE B 102       9.214 -17.455  10.144  1.00  6.56           C  
ATOM   2110  H   ILE B 102       7.246 -21.615   8.029  1.00  0.00           H  
ATOM   2111  N   ASP B 103       5.959 -19.061   5.642  1.00  6.00           N  
ATOM   2112  CA  ASP B 103       5.886 -19.119   4.181  1.00  6.64           C  
ATOM   2113  C   ASP B 103       6.420 -17.802   3.612  1.00  6.09           C  
ATOM   2114  O   ASP B 103       6.143 -16.730   4.157  1.00  6.78           O  
ATOM   2115  CB  ASP B 103       4.432 -19.273   3.697  1.00  6.00           C  
ATOM   2116  CG  ASP B 103       3.951 -20.709   3.674  1.00  8.51           C  
ATOM   2117  OD1 ASP B 103       4.657 -21.612   4.151  1.00  6.29           O  
ATOM   2118  OD2 ASP B 103       2.830 -20.934   3.175  1.00  6.00           O  
ATOM   2119  H   ASP B 103       5.341 -18.481   6.140  1.00  0.00           H  
ATOM   2120  HD2 ASP B 103       2.859 -20.827   2.223  1.00  0.00           H  
ATOM   2121  N   VAL B 104       7.173 -17.895   2.524  1.00  7.44           N  
ATOM   2122  CA  VAL B 104       7.704 -16.732   1.826  1.00  8.86           C  
ATOM   2123  C   VAL B 104       7.080 -16.831   0.438  1.00  9.33           C  
ATOM   2124  O   VAL B 104       7.156 -17.885  -0.198  1.00  7.33           O  
ATOM   2125  CB  VAL B 104       9.241 -16.784   1.711  1.00 10.91           C  
ATOM   2126  CG1 VAL B 104       9.741 -15.685   0.779  1.00 11.61           C  
ATOM   2127  CG2 VAL B 104       9.861 -16.624   3.088  1.00  9.19           C  
ATOM   2128  H   VAL B 104       7.392 -18.776   2.158  1.00  0.00           H  
ATOM   2129  N   MET B 105       6.407 -15.768  -0.001  1.00  8.96           N  
ATOM   2130  CA  MET B 105       5.748 -15.777  -1.305  1.00  9.00           C  
ATOM   2131  C   MET B 105       6.104 -14.587  -2.171  1.00 10.96           C  
ATOM   2132  O   MET B 105       6.237 -13.471  -1.682  1.00  8.93           O  
ATOM   2133  CB  MET B 105       4.221 -15.795  -1.143  1.00 11.68           C  
ATOM   2134  CG  MET B 105       3.622 -17.082  -0.583  1.00 13.02           C  
ATOM   2135  SD  MET B 105       1.834 -16.928  -0.342  1.00 15.65           S  
ATOM   2136  CE  MET B 105       1.441 -18.531   0.248  1.00 13.56           C  
ATOM   2137  H   MET B 105       6.377 -14.957   0.550  1.00  0.00           H  
ATOM   2138  N   ARG B 106       6.223 -14.844  -3.467  1.00 13.44           N  
ATOM   2139  CA  ARG B 106       6.513 -13.825  -4.467  1.00 13.87           C  
ATOM   2140  C   ARG B 106       5.334 -13.824  -5.436  1.00 13.49           C  
ATOM   2141  O   ARG B 106       4.964 -14.873  -5.971  1.00 12.32           O  
ATOM   2142  CB  ARG B 106       7.788 -14.160  -5.231  1.00 16.09           C  
ATOM   2143  CG  ARG B 106       8.059 -13.218  -6.381  1.00 23.94           C  
ATOM   2144  CD  ARG B 106       9.341 -13.576  -7.104  1.00 33.80           C  
ATOM   2145  NE  ARG B 106      10.080 -12.362  -7.432  1.00 45.63           N  
ATOM   2146  CZ  ARG B 106      11.018 -11.821  -6.657  1.00 48.68           C  
ATOM   2147  NH1 ARG B 106      11.357 -12.392  -5.504  1.00 49.07           N  
ATOM   2148  NH2 ARG B 106      11.571 -10.665  -7.006  1.00 52.23           N  
ATOM   2149  H   ARG B 106       6.089 -15.768  -3.772  1.00  0.00           H  
ATOM   2150  HE  ARG B 106       9.871 -11.907  -8.274  1.00  0.00           H  
ATOM   2151 HH11 ARG B 106      10.913 -13.237  -5.207  1.00  0.00           H  
ATOM   2152 HH12 ARG B 106      12.062 -11.970  -4.934  1.00  0.00           H  
ATOM   2153 HH21 ARG B 106      11.283 -10.204  -7.844  1.00  0.00           H  
ATOM   2154 HH22 ARG B 106      12.267 -10.251  -6.422  1.00  0.00           H  
ATOM   2155  N   PHE B 107       4.705 -12.668  -5.607  1.00 13.81           N  
ATOM   2156  CA  PHE B 107       3.562 -12.542  -6.509  1.00 14.31           C  
ATOM   2157  C   PHE B 107       3.998 -11.938  -7.836  1.00 14.81           C  
ATOM   2158  O   PHE B 107       4.963 -11.160  -7.885  1.00 17.08           O  
ATOM   2159  CB  PHE B 107       2.475 -11.675  -5.872  1.00 10.26           C  
ATOM   2160  CG  PHE B 107       1.894 -12.259  -4.609  1.00  9.95           C  
ATOM   2161  CD1 PHE B 107       2.541 -12.100  -3.390  1.00  6.93           C  
ATOM   2162  CD2 PHE B 107       0.696 -12.971  -4.641  1.00  9.78           C  
ATOM   2163  CE1 PHE B 107       2.001 -12.642  -2.215  1.00 11.86           C  
ATOM   2164  CE2 PHE B 107       0.148 -13.516  -3.478  1.00 10.21           C  
ATOM   2165  CZ  PHE B 107       0.801 -13.352  -2.261  1.00  9.50           C  
ATOM   2166  H   PHE B 107       5.031 -11.882  -5.124  1.00  0.00           H  
ATOM   2167  N   ASP B 108       3.315 -12.314  -8.912  1.00 14.92           N  
ATOM   2168  CA  ASP B 108       3.633 -11.790 -10.233  1.00 16.92           C  
ATOM   2169  C   ASP B 108       2.892 -10.484 -10.512  1.00 19.06           C  
ATOM   2170  O   ASP B 108       2.142  -9.985  -9.669  1.00 16.72           O  
ATOM   2171  CB  ASP B 108       3.367 -12.833 -11.339  1.00 17.27           C  
ATOM   2172  CG  ASP B 108       1.886 -13.207 -11.500  1.00 16.36           C  
ATOM   2173  OD1 ASP B 108       1.000 -12.602 -10.879  1.00 17.30           O  
ATOM   2174  OD2 ASP B 108       1.603 -14.131 -12.282  1.00 19.66           O  
ATOM   2175  H   ASP B 108       2.592 -12.957  -8.803  1.00  0.00           H  
ATOM   2176  N   GLU B 109       3.084  -9.945 -11.709  1.00 21.72           N  
ATOM   2177  CA  GLU B 109       2.441  -8.696 -12.110  1.00 27.69           C  
ATOM   2178  C   GLU B 109       0.932  -8.827 -12.349  1.00 27.60           C  
ATOM   2179  O   GLU B 109       0.325  -7.980 -13.002  1.00 29.63           O  
ATOM   2180  CB  GLU B 109       3.121  -8.138 -13.369  1.00 32.56           C  
ATOM   2181  CG  GLU B 109       2.913  -8.958 -14.652  1.00 42.88           C  
ATOM   2182  CD  GLU B 109       3.694 -10.264 -14.685  1.00 50.60           C  
ATOM   2183  OE1 GLU B 109       4.736 -10.375 -13.997  1.00 56.02           O  
ATOM   2184  OE2 GLU B 109       3.272 -11.186 -15.415  1.00 55.05           O  
ATOM   2185  H   GLU B 109       3.680 -10.426 -12.307  1.00  0.00           H  
ATOM   2186  N   HIS B 110       0.335  -9.897 -11.837  1.00 27.89           N  
ATOM   2187  CA  HIS B 110      -1.091 -10.147 -12.002  1.00 25.47           C  
ATOM   2188  C   HIS B 110      -1.721 -10.511 -10.675  1.00 22.63           C  
ATOM   2189  O   HIS B 110      -2.864 -10.965 -10.630  1.00 24.97           O  
ATOM   2190  CB  HIS B 110      -1.328 -11.289 -12.994  1.00 31.63           C  
ATOM   2191  CG  HIS B 110      -0.933 -10.961 -14.398  1.00 38.38           C  
ATOM   2192  ND1 HIS B 110       0.101 -11.600 -15.051  1.00 40.93           N  
ATOM   2193  CD2 HIS B 110      -1.432 -10.058 -15.277  1.00 41.07           C  
ATOM   2194  CE1 HIS B 110       0.223 -11.103 -16.270  1.00 43.65           C  
ATOM   2195  NE2 HIS B 110      -0.695 -10.167 -16.431  1.00 44.54           N  
ATOM   2196  H   HIS B 110       0.827 -10.534 -11.302  1.00  0.00           H  
ATOM   2197  HD1 HIS B 110       0.650 -12.343 -14.711  1.00  0.00           H  
ATOM   2198  HE2 HIS B 110      -0.851  -9.646 -17.246  1.00  0.00           H  
ATOM   2199  N   GLY B 111      -0.962 -10.360  -9.598  1.00 19.26           N  
ATOM   2200  CA  GLY B 111      -1.498 -10.670  -8.287  1.00 17.11           C  
ATOM   2201  C   GLY B 111      -1.566 -12.143  -7.927  1.00 13.26           C  
ATOM   2202  O   GLY B 111      -2.181 -12.502  -6.924  1.00 14.89           O  
ATOM   2203  H   GLY B 111      -0.042 -10.030  -9.648  1.00  0.00           H  
ATOM   2204  N   ARG B 112      -0.909 -12.988  -8.713  1.00 13.77           N  
ATOM   2205  CA  ARG B 112      -0.908 -14.437  -8.474  1.00 16.90           C  
ATOM   2206  C   ARG B 112       0.426 -14.872  -7.865  1.00 12.86           C  
ATOM   2207  O   ARG B 112       1.446 -14.230  -8.104  1.00 10.23           O  
ATOM   2208  CB  ARG B 112      -1.131 -15.190  -9.793  1.00 21.60           C  
ATOM   2209  CG  ARG B 112      -2.257 -14.628 -10.656  1.00 30.68           C  
ATOM   2210  CD  ARG B 112      -2.377 -15.360 -11.983  1.00 38.23           C  
ATOM   2211  NE  ARG B 112      -3.138 -16.598 -11.852  1.00 47.19           N  
ATOM   2212  CZ  ARG B 112      -4.466 -16.669 -11.900  1.00 52.61           C  
ATOM   2213  NH1 ARG B 112      -5.190 -15.571 -12.080  1.00 56.54           N  
ATOM   2214  NH2 ARG B 112      -5.078 -17.838 -11.758  1.00 53.19           N  
ATOM   2215  H   ARG B 112      -0.407 -12.617  -9.446  1.00  0.00           H  
ATOM   2216  HE  ARG B 112      -2.642 -17.433 -11.720  1.00  0.00           H  
ATOM   2217 HH11 ARG B 112      -4.743 -14.683 -12.185  1.00  0.00           H  
ATOM   2218 HH12 ARG B 112      -6.187 -15.634 -12.113  1.00  0.00           H  
ATOM   2219 HH21 ARG B 112      -4.541 -18.668 -11.608  1.00  0.00           H  
ATOM   2220 HH22 ARG B 112      -6.076 -17.884 -11.788  1.00  0.00           H  
ATOM   2221  N   ILE B 113       0.420 -15.975  -7.112  1.00 12.89           N  
ATOM   2222  CA  ILE B 113       1.637 -16.500  -6.479  1.00  9.25           C  
ATOM   2223  C   ILE B 113       2.500 -17.177  -7.530  1.00  9.93           C  
ATOM   2224  O   ILE B 113       2.067 -18.123  -8.191  1.00  9.01           O  
ATOM   2225  CB  ILE B 113       1.332 -17.561  -5.389  1.00  9.74           C  
ATOM   2226  CG1 ILE B 113       0.315 -17.032  -4.378  1.00  9.75           C  
ATOM   2227  CG2 ILE B 113       2.614 -17.930  -4.660  1.00  9.61           C  
ATOM   2228  CD1 ILE B 113      -0.234 -18.103  -3.446  1.00 11.15           C  
ATOM   2229  H   ILE B 113      -0.423 -16.458  -6.992  1.00  0.00           H  
ATOM   2230  N   GLN B 114       3.709 -16.671  -7.706  1.00  8.51           N  
ATOM   2231  CA  GLN B 114       4.625 -17.235  -8.677  1.00 11.44           C  
ATOM   2232  C   GLN B 114       5.514 -18.264  -7.986  1.00 12.42           C  
ATOM   2233  O   GLN B 114       5.901 -19.270  -8.585  1.00 10.73           O  
ATOM   2234  CB  GLN B 114       5.464 -16.133  -9.315  1.00 15.70           C  
ATOM   2235  CG  GLN B 114       6.224 -16.576 -10.538  1.00 25.21           C  
ATOM   2236  CD  GLN B 114       6.875 -15.415 -11.268  1.00 37.93           C  
ATOM   2237  OE1 GLN B 114       6.947 -14.292 -10.752  1.00 41.39           O  
ATOM   2238  NE2 GLN B 114       7.353 -15.676 -12.482  1.00 42.75           N  
ATOM   2239  H   GLN B 114       3.979 -15.896  -7.176  1.00  0.00           H  
ATOM   2240 HE21 GLN B 114       7.779 -14.928 -12.949  1.00  0.00           H  
ATOM   2241 HE22 GLN B 114       7.271 -16.584 -12.835  1.00  0.00           H  
ATOM   2242  N   THR B 115       5.849 -18.010  -6.726  1.00 12.14           N  
ATOM   2243  CA  THR B 115       6.679 -18.939  -5.975  1.00 15.11           C  
ATOM   2244  C   THR B 115       6.276 -18.934  -4.512  1.00 12.75           C  
ATOM   2245  O   THR B 115       5.959 -17.885  -3.948  1.00  9.69           O  
ATOM   2246  CB  THR B 115       8.195 -18.585  -6.053  1.00 17.77           C  
ATOM   2247  OG1 THR B 115       8.420 -17.303  -5.460  1.00 27.09           O  
ATOM   2248  CG2 THR B 115       8.691 -18.549  -7.491  1.00 21.61           C  
ATOM   2249  H   THR B 115       5.564 -17.185  -6.279  1.00  0.00           H  
ATOM   2250  HG1 THR B 115       8.234 -17.347  -4.516  1.00  0.00           H  
ATOM   2251  N   MET B 116       6.266 -20.116  -3.912  1.00 13.60           N  
ATOM   2252  CA  MET B 116       5.949 -20.264  -2.499  1.00 13.46           C  
ATOM   2253  C   MET B 116       7.002 -21.187  -1.904  1.00 12.96           C  
ATOM   2254  O   MET B 116       7.368 -22.199  -2.511  1.00 14.79           O  
ATOM   2255  CB  MET B 116       4.554 -20.853  -2.303  1.00 13.22           C  
ATOM   2256  CG  MET B 116       4.117 -20.942  -0.840  1.00 11.86           C  
ATOM   2257  SD  MET B 116       4.776 -22.370   0.037  1.00 17.02           S  
ATOM   2258  CE  MET B 116       3.429 -23.535  -0.124  1.00  9.58           C  
ATOM   2259  H   MET B 116       6.492 -20.925  -4.424  1.00  0.00           H  
ATOM   2260  N   GLN B 117       7.520 -20.811  -0.744  1.00  9.50           N  
ATOM   2261  CA  GLN B 117       8.531 -21.598  -0.061  1.00 10.98           C  
ATOM   2262  C   GLN B 117       8.117 -21.679   1.389  1.00  9.10           C  
ATOM   2263  O   GLN B 117       7.809 -20.658   1.996  1.00  9.77           O  
ATOM   2264  CB  GLN B 117       9.892 -20.914  -0.176  1.00 10.15           C  
ATOM   2265  CG  GLN B 117      10.376 -20.780  -1.598  1.00 14.99           C  
ATOM   2266  CD  GLN B 117      11.569 -19.856  -1.723  1.00 24.38           C  
ATOM   2267  OE1 GLN B 117      11.473 -18.658  -1.445  1.00 25.99           O  
ATOM   2268  NE2 GLN B 117      12.698 -20.401  -2.152  1.00 25.07           N  
ATOM   2269  H   GLN B 117       7.223 -19.975  -0.323  1.00  0.00           H  
ATOM   2270 HE21 GLN B 117      13.475 -19.810  -2.193  1.00  0.00           H  
ATOM   2271 HE22 GLN B 117      12.699 -21.349  -2.384  1.00  0.00           H  
ATOM   2272  N   ALA B 118       8.056 -22.889   1.927  1.00  6.00           N  
ATOM   2273  CA  ALA B 118       7.663 -23.070   3.316  1.00  7.67           C  
ATOM   2274  C   ALA B 118       8.835 -23.568   4.159  1.00  7.48           C  
ATOM   2275  O   ALA B 118       9.451 -24.580   3.845  1.00  9.20           O  
ATOM   2276  CB  ALA B 118       6.492 -24.036   3.405  1.00  6.00           C  
ATOM   2277  H   ALA B 118       8.288 -23.672   1.391  1.00  0.00           H  
ATOM   2278  N   TYR B 119       9.158 -22.826   5.209  1.00  7.19           N  
ATOM   2279  CA  TYR B 119      10.243 -23.176   6.111  1.00  8.34           C  
ATOM   2280  C   TYR B 119       9.714 -23.877   7.340  1.00  6.71           C  
ATOM   2281  O   TYR B 119       8.858 -23.347   8.052  1.00  7.84           O  
ATOM   2282  CB  TYR B 119      11.004 -21.922   6.540  1.00  8.88           C  
ATOM   2283  CG  TYR B 119      11.762 -21.291   5.411  1.00 10.37           C  
ATOM   2284  CD1 TYR B 119      11.119 -20.469   4.485  1.00  7.21           C  
ATOM   2285  CD2 TYR B 119      13.122 -21.543   5.241  1.00  9.31           C  
ATOM   2286  CE1 TYR B 119      11.811 -19.920   3.421  1.00  8.64           C  
ATOM   2287  CE2 TYR B 119      13.822 -20.997   4.183  1.00  9.69           C  
ATOM   2288  CZ  TYR B 119      13.162 -20.189   3.278  1.00 10.49           C  
ATOM   2289  OH  TYR B 119      13.862 -19.647   2.233  1.00 14.21           O  
ATOM   2290  H   TYR B 119       8.641 -22.023   5.390  1.00  0.00           H  
ATOM   2291  HH  TYR B 119      14.718 -20.069   2.100  1.00  0.00           H  
ATOM   2292  N   TRP B 120      10.212 -25.085   7.561  1.00  9.85           N  
ATOM   2293  CA  TRP B 120       9.846 -25.896   8.715  1.00  8.05           C  
ATOM   2294  C   TRP B 120      10.546 -27.241   8.604  1.00  8.54           C  
ATOM   2295  O   TRP B 120      11.013 -27.623   7.525  1.00  9.38           O  
ATOM   2296  CB  TRP B 120       8.324 -26.112   8.791  1.00  7.57           C  
ATOM   2297  CG  TRP B 120       7.746 -26.939   7.664  1.00 11.17           C  
ATOM   2298  CD1 TRP B 120       7.237 -26.475   6.491  1.00  6.70           C  
ATOM   2299  CD2 TRP B 120       7.593 -28.370   7.631  1.00 10.06           C  
ATOM   2300  NE1 TRP B 120       6.770 -27.520   5.731  1.00 10.54           N  
ATOM   2301  CE2 TRP B 120       6.977 -28.693   6.400  1.00 10.37           C  
ATOM   2302  CE3 TRP B 120       7.919 -29.409   8.519  1.00 11.50           C  
ATOM   2303  CZ2 TRP B 120       6.674 -30.014   6.032  1.00  8.34           C  
ATOM   2304  CZ3 TRP B 120       7.617 -30.728   8.153  1.00 11.85           C  
ATOM   2305  CH2 TRP B 120       7.002 -31.013   6.917  1.00 11.31           C  
ATOM   2306  H   TRP B 120      10.859 -25.465   6.928  1.00  0.00           H  
ATOM   2307  HE1 TRP B 120       6.267 -27.396   4.926  1.00  0.00           H  
ATOM   2308  N   SER B 121      10.679 -27.919   9.736  1.00  9.80           N  
ATOM   2309  CA  SER B 121      11.264 -29.251   9.783  1.00  8.09           C  
ATOM   2310  C   SER B 121      10.716 -29.878  11.057  1.00  7.91           C  
ATOM   2311  O   SER B 121       9.896 -29.268  11.750  1.00  8.96           O  
ATOM   2312  CB  SER B 121      12.796 -29.208   9.785  1.00  6.00           C  
ATOM   2313  OG  SER B 121      13.303 -28.750  11.020  1.00  7.17           O  
ATOM   2314  H   SER B 121      10.399 -27.505  10.581  1.00  0.00           H  
ATOM   2315  HG  SER B 121      13.087 -29.299  11.759  1.00  0.00           H  
ATOM   2316  N   GLU B 122      11.187 -31.072  11.393  1.00  8.82           N  
ATOM   2317  CA  GLU B 122      10.710 -31.772  12.581  1.00  6.12           C  
ATOM   2318  C   GLU B 122      10.932 -31.016  13.883  1.00  6.00           C  
ATOM   2319  O   GLU B 122      10.267 -31.291  14.876  1.00  6.74           O  
ATOM   2320  CB  GLU B 122      11.309 -33.179  12.664  1.00 10.86           C  
ATOM   2321  CG  GLU B 122      10.864 -34.129  11.551  1.00  8.91           C  
ATOM   2322  CD  GLU B 122      11.688 -33.998  10.270  1.00 15.10           C  
ATOM   2323  OE1 GLU B 122      12.568 -33.118  10.183  1.00 14.49           O  
ATOM   2324  OE2 GLU B 122      11.469 -34.796   9.338  1.00 17.82           O  
ATOM   2325  H   GLU B 122      11.853 -31.463  10.822  1.00  0.00           H  
ATOM   2326  N   VAL B 123      11.849 -30.052  13.887  1.00  7.35           N  
ATOM   2327  CA  VAL B 123      12.090 -29.267  15.101  1.00  7.68           C  
ATOM   2328  C   VAL B 123      10.881 -28.359  15.393  1.00  8.94           C  
ATOM   2329  O   VAL B 123      10.681 -27.917  16.523  1.00 13.31           O  
ATOM   2330  CB  VAL B 123      13.408 -28.422  15.016  1.00  9.04           C  
ATOM   2331  CG1 VAL B 123      14.609 -29.334  14.743  1.00  6.88           C  
ATOM   2332  CG2 VAL B 123      13.302 -27.337  13.944  1.00  7.33           C  
ATOM   2333  H   VAL B 123      12.368 -29.885  13.092  1.00  0.00           H  
ATOM   2334  N   ASN B 124      10.064 -28.118  14.368  1.00  8.20           N  
ATOM   2335  CA  ASN B 124       8.870 -27.273  14.478  1.00  9.15           C  
ATOM   2336  C   ASN B 124       7.593 -28.103  14.602  1.00 10.38           C  
ATOM   2337  O   ASN B 124       6.489 -27.555  14.677  1.00  7.78           O  
ATOM   2338  CB  ASN B 124       8.756 -26.383  13.234  1.00  7.12           C  
ATOM   2339  CG  ASN B 124       9.947 -25.476  13.067  1.00  6.00           C  
ATOM   2340  OD1 ASN B 124      10.669 -25.555  12.072  1.00  8.90           O  
ATOM   2341  ND2 ASN B 124      10.190 -24.632  14.064  1.00  8.20           N  
ATOM   2342  H   ASN B 124      10.256 -28.510  13.498  1.00  0.00           H  
ATOM   2343 HD21 ASN B 124      10.973 -24.035  14.018  1.00  0.00           H  
ATOM   2344 HD22 ASN B 124       9.572 -24.649  14.829  1.00  0.00           H  
ATOM   2345  N   LEU B 125       7.768 -29.420  14.694  1.00 12.22           N  
ATOM   2346  CA  LEU B 125       6.662 -30.363  14.749  1.00  8.69           C  
ATOM   2347  C   LEU B 125       6.343 -30.935  16.118  1.00  9.04           C  
ATOM   2348  O   LEU B 125       7.222 -31.111  16.952  1.00 11.60           O  
ATOM   2349  CB  LEU B 125       6.939 -31.497  13.754  1.00  9.53           C  
ATOM   2350  CG  LEU B 125       5.950 -32.631  13.482  1.00 13.19           C  
ATOM   2351  CD1 LEU B 125       4.647 -32.094  12.923  1.00  9.38           C  
ATOM   2352  CD2 LEU B 125       6.586 -33.603  12.487  1.00 13.00           C  
ATOM   2353  H   LEU B 125       8.665 -29.791  14.799  1.00  0.00           H  
ATOM   2354  N   SER B 126       5.060 -31.192  16.350  1.00  8.86           N  
ATOM   2355  CA  SER B 126       4.586 -31.778  17.593  1.00 10.54           C  
ATOM   2356  C   SER B 126       3.509 -32.787  17.232  1.00 15.74           C  
ATOM   2357  O   SER B 126       2.436 -32.412  16.757  1.00 15.13           O  
ATOM   2358  CB  SER B 126       4.025 -30.711  18.513  1.00 13.26           C  
ATOM   2359  OG  SER B 126       3.534 -31.289  19.696  1.00 14.04           O  
ATOM   2360  H   SER B 126       4.407 -30.928  15.672  1.00  0.00           H  
ATOM   2361  HG  SER B 126       4.284 -31.718  20.111  1.00  0.00           H  
ATOM   2362  N   VAL B 127       3.824 -34.070  17.393  1.00 17.96           N  
ATOM   2363  CA  VAL B 127       2.876 -35.141  17.072  1.00 19.12           C  
ATOM   2364  C   VAL B 127       2.221 -35.666  18.353  1.00 22.86           C  
ATOM   2365  O   VAL B 127       1.766 -36.797  18.419  1.00 23.40           O  
ATOM   2366  CB  VAL B 127       3.578 -36.310  16.351  1.00 18.89           C  
ATOM   2367  CG1 VAL B 127       4.116 -35.869  15.014  1.00 14.87           C  
ATOM   2368  CG2 VAL B 127       4.691 -36.873  17.205  1.00 18.93           C  
ATOM   2369  H   VAL B 127       4.727 -34.292  17.625  1.00  0.00           H  
ATOM   2370  N   ARG B 128       2.099 -34.791  19.337  1.00 26.50           N  
ATOM   2371  CA  ARG B 128       1.537 -35.188  20.615  1.00 34.75           C  
ATOM   2372  C   ARG B 128       0.535 -34.177  21.159  1.00 39.56           C  
ATOM   2373  O   ARG B 128       0.654 -33.740  22.303  1.00 42.39           O  
ATOM   2374  CB  ARG B 128       2.644 -35.409  21.624  1.00 39.13           C  
ATOM   2375  H   ARG B 128       2.172 -33.846  19.214  1.00  0.00           H  
ATOM   2376  N   GLU B 129      -0.404 -33.777  20.306  1.00 43.37           N  
ATOM   2377  CA  GLU B 129      -1.507 -32.857  20.633  1.00 46.29           C  
ATOM   2378  C   GLU B 129      -1.488 -31.384  20.190  1.00 47.92           C  
ATOM   2379  O   GLU B 129      -2.451 -30.956  19.555  1.00 51.57           O  
ATOM   2380  CB  GLU B 129      -1.926 -32.979  22.099  1.00 43.89           C  
ATOM   2381  H   GLU B 129      -0.322 -34.132  19.401  1.00  0.00           H  
ATOM   2382  N   PRO B 130      -0.418 -30.601  20.477  1.00 49.13           N  
ATOM   2383  CA  PRO B 130      -0.350 -29.176  20.089  1.00 47.95           C  
ATOM   2384  C   PRO B 130      -1.003 -28.808  18.776  1.00 49.88           C  
ATOM   2385  O   PRO B 130      -1.548 -27.691  18.704  1.00 51.56           O  
ATOM   2386  CB  PRO B 130       1.144 -28.901  20.111  1.00 45.69           C  
ATOM   2387  CG  PRO B 130       1.520 -29.650  21.341  1.00 47.73           C  
ATOM   2388  CD  PRO B 130       0.814 -30.989  21.171  1.00 49.13           C  
TER    2389      PRO B 130                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
