
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  140 ( 1102),  selected  140 , name 2bng_C
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 2bng_C.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E    10_C      -       -           -
LGA    T    11_C      -       -           -
LGA    P    12_C      -       -           -
LGA    E    13_C      -       -           -
LGA    T    14_C      N       2          0.870
LGA    T    15_C      S       3          2.080
LGA    E    16_C      E       4          2.309
LGA    A    17_C      I       5          0.933
LGA    I    18_C      E       6          1.701
LGA    R    19_C      L       7          2.723
LGA    A    20_C      P       8          1.346
LGA    V    21_C      V       9          0.413
LGA    E    22_C      Q      10          1.549
LGA    A    23_C      K      11          0.849
LGA    F    24_C      Q      12          0.810
LGA    L    25_C      L      13          1.550
LGA    N    26_C      E      14          1.400
LGA    A    27_C      A      15          0.946
LGA    L    28_C      Y      16          1.639
LGA    Q    29_C      N      17          1.335
LGA    N    30_C      A      18          1.292
LGA    E    31_C      R      19          1.204
LGA    D    32_C      D      20          0.386
LGA    F    33_C      I      21          1.342
LGA    D    34_C      D      22          1.048
LGA    T    35_C      A      23          0.864
LGA    V    36_C      F      24          1.744
LGA    D    37_C      M      25          2.260
LGA    A    38_C      A      26          0.938
LGA    A    39_C      W      27          2.082
LGA    L    40_C      W      28          1.978
LGA    G    41_C      A      29          1.177
LGA    D    42_C      D      30          1.564
LGA    D    43_C      D      31          1.948
LGA    L    44_C      C      32          1.606
LGA    V    45_C      Q      33          1.617
LGA    Y    46_C      Y      34          1.350
LGA    E    47_C      Y      35          1.861
LGA    N    48_C      A      36          2.088
LGA    V    49_C      F      37          0.950
LGA    G    50_C      P      38          2.999
LGA    F    51_C      A      39           -
LGA    S    52_C      T      40          4.194
LGA    R    53_C      L      41          2.324
LGA    I    54_C      L      42          1.640
LGA    -       -      A      43           -
LGA    R    55_C      G      44          1.744
LGA    G    56_C      N      45          1.175
LGA    G    57_C      A      46          0.957
LGA    R    58_C      A      47          1.022
LGA    R    59_C      E      48          1.174
LGA    T    60_C      I      49          1.141
LGA    A    61_C      R      50          1.001
LGA    T    62_C      V      51          2.194
LGA    L    63_C      R      52          2.559
LGA    L    64_C      H      53          1.962
LGA    R    65_C      I      54          2.357
LGA    R    66_C      E      55          3.989
LGA    X    67_C      R      56          4.037
LGA    Q    68_C      F      57          3.558
LGA    G    69_C      K      58          2.611
LGA    R    70_C      E      59          3.861
LGA    V    71_C      P      60           #
LGA    G    72_C      D      61          4.692
LGA    F    73_C      L      62          2.703
LGA    E    74_C      Y      63          1.602
LGA    V    75_C      G      64          1.547
LGA    K    76_C      E      65          2.107
LGA    I    77_C      L      66          2.085
LGA    H    78_C      L      67          2.107
LGA    R    79_C      T      68          2.072
LGA    I    80_C      R      69          1.590
LGA    G    81_C      V      70          2.238
LGA    A    82_C      I      71          1.642
LGA    D    83_C      V      72          1.715
LGA    G    84_C      G      73          1.586
LGA    A    85_C      N      74          0.916
LGA    A    86_C      V      75          0.927
LGA    V    87_C      V      76          1.063
LGA    L    88_C      I      77          1.786
LGA    T    89_C      D      78          2.499
LGA    E    90_C      H      79          2.502
LGA    R    91_C      E      80          2.163
LGA    T    92_C      T      81          1.849
LGA    D    93_C      V      82          2.025
LGA    A    94_C      T      83          1.953
LGA    L    95_C      R      84          2.485
LGA    I    96_C      -       -           -
LGA    I    97_C      -       -           -
LGA    G    98_C      -       -           -
LGA    P    99_C      -       -           -
LGA    L   100_C      N      85          2.434
LGA    R   101_C      F      86          5.399
LGA    -       -      P      87           -
LGA    -       -      E      88           -
LGA    -       -      G      89           -
LGA    -       -      K      90           -
LGA    V   102_C      G      91          1.247
LGA    Q   103_C      E      92          0.423
LGA    F   104_C      V      93          1.663
LGA    W   105_C      D      94          1.173
LGA    V   106_C      V      95          1.270
LGA    C   107_C      A      96          1.554
LGA    G   108_C      C      97          2.023
LGA    V   109_C      I      98          1.284
LGA    F   110_C      Y      99          0.661
LGA    E   111_C      E     100          0.570
LGA    V   112_C      V     101          1.027
LGA    D   113_C      E     102          2.045
LGA    D   114_C      N     103          3.189
LGA    G   115_C      G     104          3.145
LGA    R   116_C      R     105          1.652
LGA    I   117_C      I     106          1.449
LGA    T   118_C      A     107          1.817
LGA    L   119_C      K     108          1.820
LGA    W   120_C      A     109          1.637
LGA    R   121_C      W     110          1.307
LGA    D   122_C      F     111          1.188
LGA    Y   123_C      K     112          1.408
LGA    F   124_C      I     113          1.906
LGA    D   125_C      G     114          3.210
LGA    V   126_C      -       -           -
LGA    Y   127_C      -       -           -
LGA    D   128_C      E     115          2.435
LGA    X   129_C      P     116          1.547
LGA    F   130_C      -       -           -
LGA    K   131_C      R     117          4.107
LGA    G   132_C      I     118          3.923
LGA    L   133_C      -       -           -
LGA    L   134_C      -       -           -
LGA    R   135_C      -       -           -
LGA    G   136_C      -       -           -
LGA    L   137_C      -       -           -
LGA    V   138_C      -       -           -
LGA    A   139_C      -       -           -
LGA    L   140_C      -       -           -
LGA    V   141_C      -       -           -
LGA    V   142_C      -       -           -
LGA    P   143_C      -       -           -
LGA    S   144_C      -       -           -
LGA    L   145_C      -       -           -
LGA    K   146_C      -       -           -
LGA    A   147_C      -       -           -
LGA    T   148_C      -       -           -
LGA    L   149_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  140  117    5.0    110    2.08    17.27     71.077     5.048

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.335645 * X  +  -0.816271 * Y  +   0.470154 * Z  +  35.172699
  Y_new =   0.642121 * X  +  -0.563442 * Y  +  -0.519822 * Z  +  48.631287
  Z_new =   0.689219 * X  +   0.127420 * Y  +   0.713261 * Z  + -41.336147 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.176779   -2.964813  [ DEG:    10.1287   -169.8713 ]
  Theta =  -0.760411   -2.381182  [ DEG:   -43.5683   -136.4317 ]
  Phi   =   2.052449   -1.089143  [ DEG:   117.5967    -62.4033 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bng_C                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bng_C.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  140  117   5.0  110   2.08   17.27  71.077
REMARK  ---------------------------------------------------------- 
MOLECULE 2bng_C
HEADER    HYDROLASE                               24-MAR-05   2BNG              
TITLE     STRUCTURE OF AN M.TUBERCULOSIS LEH-LIKE EPOXIDE HYDROLASE             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MB2760;                                                    
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: LEH-LIKE EPOXIDE HYDROLASE;                                 
COMPND   5 EC: 3.3.2.8;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 OTHER_DETAILS: ENDOGENOUS LIGAND OF UNKNOWN ORIGIN BOUND             
COMPND   8 IN THE ACTIVE SITE                                                   
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 STRAIN: H37RV;                                                       
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    M.TUBERCULOSIS, EPOXIDE HYDROLASE, LIMONENE, HYDROLASE,               
KEYWDS   2 STRUCTURAL PROTEOMICS IN EUROPE, SPINE, STRUCTURAL GENOMICS          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.JOHANSSON,M.ARAND,T.UNGE,T.BERGFORS,T.A.JONES,S.L.MOWBRAY,          
AUTHOR   2 STRUCTURAL PROTEOMICS IN EUROPE (SPINE)                              
REVDAT   3   20-DEC-06 2BNG    1       JRNL                                     
REVDAT   2   10-AUG-05 2BNG    1       MTRIX1 MTRIX2 MTRIX3                     
REVDAT   1   03-AUG-05 2BNG    0                                                
JRNL        AUTH   P.JOHANSSON,T.UNGE,A.CRONIN,M.ARAND,T.BERGFORS,              
JRNL        AUTH 2 T.A.JONES,S.L.MOWBRAY                                        
JRNL        TITL   STRUCTURE OF AN ATYPICAL EPOXIDE HYDROLASE FROM              
JRNL        TITL 2 MYCOBACTERIUM TUBERCULOSIS GIVES INSIGHTS INTO ITS           
JRNL        TITL 3 FUNCTION.                                                    
JRNL        REF    J.MOL.BIOL.                   V. 351  1048 2005              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2BNG A    1   149  UNP    Q7TY00   Q7TY00_MYCBO     1    149             
DBREF  2BNG B    1   149  UNP    Q7TY00   Q7TY00_MYCBO     1    149             
DBREF  2BNG C    1   149  UNP    Q7TY00   Q7TY00_MYCBO     1    149             
SEQRES   1 A  149  MSE ALA GLU LEU THR GLU THR SER PRO GLU THR PRO GLU          
SEQRES   2 A  149  THR THR GLU ALA ILE ARG ALA VAL GLU ALA PHE LEU ASN          
SEQRES   3 A  149  ALA LEU GLN ASN GLU ASP PHE ASP THR VAL ASP ALA ALA          
SEQRES   4 A  149  LEU GLY ASP ASP LEU VAL TYR GLU ASN VAL GLY PHE SER          
SEQRES   5 A  149  ARG ILE ARG GLY GLY ARG ARG THR ALA THR LEU LEU ARG          
SEQRES   6 A  149  ARG MSE GLN GLY ARG VAL GLY PHE GLU VAL LYS ILE HIS          
SEQRES   7 A  149  ARG ILE GLY ALA ASP GLY ALA ALA VAL LEU THR GLU ARG          
SEQRES   8 A  149  THR ASP ALA LEU ILE ILE GLY PRO LEU ARG VAL GLN PHE          
SEQRES   9 A  149  TRP VAL CYS GLY VAL PHE GLU VAL ASP ASP GLY ARG ILE          
SEQRES  10 A  149  THR LEU TRP ARG ASP TYR PHE ASP VAL TYR ASP MSE PHE          
SEQRES  11 A  149  LYS GLY LEU LEU ARG GLY LEU VAL ALA LEU VAL VAL PRO          
SEQRES  12 A  149  SER LEU LYS ALA THR LEU                                      
SEQRES   1 B  149  MSE ALA GLU LEU THR GLU THR SER PRO GLU THR PRO GLU          
SEQRES   2 B  149  THR THR GLU ALA ILE ARG ALA VAL GLU ALA PHE LEU ASN          
SEQRES   3 B  149  ALA LEU GLN ASN GLU ASP PHE ASP THR VAL ASP ALA ALA          
SEQRES   4 B  149  LEU GLY ASP ASP LEU VAL TYR GLU ASN VAL GLY PHE SER          
SEQRES   5 B  149  ARG ILE ARG GLY GLY ARG ARG THR ALA THR LEU LEU ARG          
SEQRES   6 B  149  ARG MSE GLN GLY ARG VAL GLY PHE GLU VAL LYS ILE HIS          
SEQRES   7 B  149  ARG ILE GLY ALA ASP GLY ALA ALA VAL LEU THR GLU ARG          
SEQRES   8 B  149  THR ASP ALA LEU ILE ILE GLY PRO LEU ARG VAL GLN PHE          
SEQRES   9 B  149  TRP VAL CYS GLY VAL PHE GLU VAL ASP ASP GLY ARG ILE          
SEQRES  10 B  149  THR LEU TRP ARG ASP TYR PHE ASP VAL TYR ASP MSE PHE          
SEQRES  11 B  149  LYS GLY LEU LEU ARG GLY LEU VAL ALA LEU VAL VAL PRO          
SEQRES  12 B  149  SER LEU LYS ALA THR LEU                                      
SEQRES   1 C  149  MSE ALA GLU LEU THR GLU THR SER PRO GLU THR PRO GLU          
SEQRES   2 C  149  THR THR GLU ALA ILE ARG ALA VAL GLU ALA PHE LEU ASN          
SEQRES   3 C  149  ALA LEU GLN ASN GLU ASP PHE ASP THR VAL ASP ALA ALA          
SEQRES   4 C  149  LEU GLY ASP ASP LEU VAL TYR GLU ASN VAL GLY PHE SER          
SEQRES   5 C  149  ARG ILE ARG GLY GLY ARG ARG THR ALA THR LEU LEU ARG          
SEQRES   6 C  149  ARG MSE GLN GLY ARG VAL GLY PHE GLU VAL LYS ILE HIS          
SEQRES   7 C  149  ARG ILE GLY ALA ASP GLY ALA ALA VAL LEU THR GLU ARG          
SEQRES   8 C  149  THR ASP ALA LEU ILE ILE GLY PRO LEU ARG VAL GLN PHE          
SEQRES   9 C  149  TRP VAL CYS GLY VAL PHE GLU VAL ASP ASP GLY ARG ILE          
SEQRES  10 C  149  THR LEU TRP ARG ASP TYR PHE ASP VAL TYR ASP MSE PHE          
SEQRES  11 C  149  LYS GLY LEU LEU ARG GLY LEU VAL ALA LEU VAL VAL PRO          
SEQRES  12 C  149  SER LEU LYS ALA THR LEU                                      
HET    MSE  A  67       8                                                       
HET    MSE  A 129       8                                                       
HET    MSE  B  67       8                                                       
HET    MSE  B 129       8                                                       
HET    MSE  C  67       8                                                       
HET    MSE  C 129       8                                                       
HET     CA  B1145       1                                                       
HET     CA  B1146       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CA CALCIUM ION                                                      
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   4   CA    2(CA 2+)                                                     
FORMUL   6  HOH   *89(H2 O)                                                     
CRYST1   81.901   81.901  117.025  90.00  90.00 120.00 P 32 2 1     18          
ATOM   2094  N   GLU C  10      -5.107   4.943  -4.318  1.00 68.42           N  
ATOM   2095  CA  GLU C  10      -4.229   3.954  -5.021  1.00 67.66           C  
ATOM   2096  C   GLU C  10      -3.560   3.038  -3.999  1.00 64.19           C  
ATOM   2097  O   GLU C  10      -2.567   3.411  -3.356  1.00 63.69           O  
ATOM   2098  CB  GLU C  10      -3.169   4.655  -5.883  1.00 69.70           C  
ATOM   2099  CG  GLU C  10      -3.620   5.060  -7.307  1.00 74.82           C  
ATOM   2100  CD  GLU C  10      -4.355   6.408  -7.386  1.00 80.81           C  
ATOM   2101  OE1 GLU C  10      -3.973   7.372  -6.673  1.00 82.87           O  
ATOM   2102  OE2 GLU C  10      -5.310   6.510  -8.197  1.00 84.01           O  
ATOM   2103  N   THR C  11      -4.122   1.843  -3.853  1.00 61.51           N  
ATOM   2104  CA  THR C  11      -3.720   0.921  -2.808  1.00 58.82           C  
ATOM   2105  C   THR C  11      -2.440   0.172  -3.197  1.00 57.12           C  
ATOM   2106  O   THR C  11      -2.364  -0.386  -4.293  1.00 56.88           O  
ATOM   2107  CB  THR C  11      -4.883  -0.035  -2.429  1.00 57.47           C  
ATOM   2108  OG1 THR C  11      -4.366  -1.287  -1.956  1.00 55.89           O  
ATOM   2109  CG2 THR C  11      -5.781  -0.286  -3.612  1.00 59.08           C  
ATOM   2110  N   PRO C  12      -1.421   0.181  -2.306  1.00 56.14           N  
ATOM   2111  CA  PRO C  12      -0.097  -0.374  -2.656  1.00 55.27           C  
ATOM   2112  C   PRO C  12      -0.051  -1.887  -2.821  1.00 53.75           C  
ATOM   2113  O   PRO C  12      -0.706  -2.631  -2.078  1.00 51.87           O  
ATOM   2114  CB  PRO C  12       0.810   0.078  -1.499  1.00 54.33           C  
ATOM   2115  CG  PRO C  12      -0.093   0.380  -0.379  1.00 54.36           C  
ATOM   2116  CD  PRO C  12      -1.454   0.723  -0.934  1.00 55.59           C  
ATOM   2117  N   GLU C  13       0.752  -2.327  -3.789  1.00 55.17           N  
ATOM   2118  CA  GLU C  13       0.971  -3.755  -4.078  1.00 55.12           C  
ATOM   2119  C   GLU C  13       1.309  -4.559  -2.839  1.00 53.40           C  
ATOM   2120  O   GLU C  13       1.068  -5.759  -2.766  1.00 51.39           O  
ATOM   2121  CB  GLU C  13       2.046  -3.940  -5.156  1.00 55.39           C  
ATOM   2122  CG  GLU C  13       1.660  -3.293  -6.508  1.00 60.33           C  
ATOM   2123  CD  GLU C  13       0.194  -3.566  -6.939  1.00 63.38           C  
ATOM   2124  OE1 GLU C  13      -0.140  -4.752  -7.213  1.00 61.57           O  
ATOM   2125  OE2 GLU C  13      -0.605  -2.590  -7.026  1.00 64.75           O  
ATOM   2126  N   THR C  14       1.830  -3.851  -1.856  1.00 55.74           N  
ATOM   2127  CA  THR C  14       2.206  -4.399  -0.573  1.00 54.90           C  
ATOM   2128  C   THR C  14       0.980  -4.968   0.188  1.00 53.62           C  
ATOM   2129  O   THR C  14       0.988  -6.130   0.606  1.00 51.51           O  
ATOM   2130  CB  THR C  14       2.975  -3.280   0.194  1.00 56.33           C  
ATOM   2131  OG1 THR C  14       4.381  -3.534   0.137  1.00 57.33           O  
ATOM   2132  CG2 THR C  14       2.610  -3.177   1.604  1.00 55.86           C  
ATOM   2133  N   THR C  15      -0.073  -4.149   0.320  1.00 54.17           N  
ATOM   2134  CA  THR C  15      -1.339  -4.542   0.949  1.00 52.69           C  
ATOM   2135  C   THR C  15      -1.995  -5.644   0.156  1.00 51.32           C  
ATOM   2136  O   THR C  15      -2.528  -6.579   0.734  1.00 50.04           O  
ATOM   2137  CB  THR C  15      -2.308  -3.356   0.986  1.00 54.53           C  
ATOM   2138  OG1 THR C  15      -1.639  -2.213   1.476  1.00 55.55           O  
ATOM   2139  CG2 THR C  15      -3.454  -3.596   1.849  1.00 53.20           C  
ATOM   2140  N   GLU C  16      -1.954  -5.511  -1.168  1.00 51.30           N  
ATOM   2141  CA  GLU C  16      -2.476  -6.519  -2.074  1.00 50.28           C  
ATOM   2142  C   GLU C  16      -1.815  -7.880  -1.907  1.00 47.13           C  
ATOM   2143  O   GLU C  16      -2.507  -8.893  -1.824  1.00 45.88           O  
ATOM   2144  CB  GLU C  16      -2.281  -6.063  -3.493  1.00 52.07           C  
ATOM   2145  CG  GLU C  16      -3.539  -5.916  -4.178  1.00 56.09           C  
ATOM   2146  CD  GLU C  16      -3.359  -5.444  -5.559  1.00 61.07           C  
ATOM   2147  OE1 GLU C  16      -2.533  -5.959  -6.365  1.00 62.77           O  
ATOM   2148  OE2 GLU C  16      -4.102  -4.524  -5.836  1.00 63.81           O  
ATOM   2149  N   ALA C  17      -0.484  -7.882  -1.856  1.00 45.19           N  
ATOM   2150  CA  ALA C  17       0.285  -9.114  -1.751  1.00 42.66           C  
ATOM   2151  C   ALA C  17      -0.022  -9.835  -0.430  1.00 40.28           C  
ATOM   2152  O   ALA C  17      -0.260 -11.040  -0.411  1.00 38.67           O  
ATOM   2153  CB  ALA C  17       1.774  -8.839  -1.905  1.00 42.50           C  
ATOM   2154  N   ILE C  18      -0.042  -9.082   0.662  1.00 39.75           N  
ATOM   2155  CA  ILE C  18      -0.422  -9.609   1.981  1.00 38.57           C  
ATOM   2156  C   ILE C  18      -1.811 -10.281   1.975  1.00 38.71           C  
ATOM   2157  O   ILE C  18      -1.986 -11.430   2.400  1.00 37.12           O  
ATOM   2158  CB  ILE C  18      -0.346  -8.486   3.048  1.00 39.15           C  
ATOM   2159  CG1 ILE C  18       1.131  -8.122   3.300  1.00 39.14           C  
ATOM   2160  CG2 ILE C  18      -1.022  -8.888   4.353  1.00 37.17           C  
ATOM   2161  CD1 ILE C  18       1.358  -6.852   4.110  1.00 39.42           C  
ATOM   2162  N   ARG C  19      -2.784  -9.553   1.453  1.00 39.55           N  
ATOM   2163  CA  ARG C  19      -4.118 -10.055   1.291  1.00 39.47           C  
ATOM   2164  C   ARG C  19      -4.258 -11.307   0.408  1.00 38.01           C  
ATOM   2165  O   ARG C  19      -5.065 -12.166   0.716  1.00 37.65           O  
ATOM   2166  CB  ARG C  19      -4.868  -8.941   0.665  1.00 41.03           C  
ATOM   2167  CG  ARG C  19      -6.156  -8.795   1.192  1.00 43.46           C  
ATOM   2168  CD  ARG C  19      -6.722  -7.764   0.376  1.00 47.41           C  
ATOM   2169  NE  ARG C  19      -7.020  -6.572   1.093  1.00 51.80           N  
ATOM   2170  CZ  ARG C  19      -7.019  -5.387   0.530  1.00 52.97           C  
ATOM   2171  NH1 ARG C  19      -6.730  -5.174  -0.738  1.00 54.41           N  
ATOM   2172  NH2 ARG C  19      -7.339  -4.404   1.271  1.00 53.87           N  
ATOM   2173  N   ALA C  20      -3.495 -11.389  -0.679  1.00 37.17           N  
ATOM   2174  CA  ALA C  20      -3.504 -12.572  -1.550  1.00 36.78           C  
ATOM   2175  C   ALA C  20      -3.048 -13.805  -0.768  1.00 35.33           C  
ATOM   2176  O   ALA C  20      -3.681 -14.857  -0.835  1.00 34.64           O  
ATOM   2177  CB  ALA C  20      -2.630 -12.351  -2.814  1.00 36.67           C  
ATOM   2178  N   VAL C  21      -1.973 -13.638   0.007  1.00 34.68           N  
ATOM   2179  CA  VAL C  21      -1.411 -14.711   0.825  1.00 33.25           C  
ATOM   2180  C   VAL C  21      -2.361 -15.131   1.937  1.00 33.76           C  
ATOM   2181  O   VAL C  21      -2.555 -16.333   2.169  1.00 33.18           O  
ATOM   2182  CB  VAL C  21       0.009 -14.359   1.373  1.00 33.12           C  
ATOM   2183  CG1 VAL C  21       0.505 -15.426   2.377  1.00 30.07           C  
ATOM   2184  CG2 VAL C  21       1.014 -14.200   0.209  1.00 30.85           C  
ATOM   2185  N   GLU C  22      -2.988 -14.159   2.597  1.00 34.74           N  
ATOM   2186  CA  GLU C  22      -4.002 -14.471   3.595  1.00 35.55           C  
ATOM   2187  C   GLU C  22      -5.211 -15.192   2.992  1.00 35.43           C  
ATOM   2188  O   GLU C  22      -5.685 -16.198   3.543  1.00 34.98           O  
ATOM   2189  CB  GLU C  22      -4.458 -13.208   4.300  1.00 36.55           C  
ATOM   2190  CG  GLU C  22      -3.441 -12.645   5.250  1.00 39.42           C  
ATOM   2191  CD  GLU C  22      -3.865 -11.299   5.825  1.00 43.57           C  
ATOM   2192  OE1 GLU C  22      -4.580 -10.544   5.117  1.00 48.33           O  
ATOM   2193  OE2 GLU C  22      -3.486 -10.997   6.981  1.00 46.86           O  
ATOM   2194  N   ALA C  23      -5.709 -14.678   1.866  1.00 35.68           N  
ATOM   2195  CA  ALA C  23      -6.826 -15.331   1.161  1.00 35.48           C  
ATOM   2196  C   ALA C  23      -6.441 -16.769   0.779  1.00 34.45           C  
ATOM   2197  O   ALA C  23      -7.222 -17.708   0.983  1.00 34.26           O  
ATOM   2198  CB  ALA C  23      -7.258 -14.537  -0.049  1.00 35.89           C  
ATOM   2199  N   PHE C  24      -5.219 -16.956   0.290  1.00 33.49           N  
ATOM   2200  CA  PHE C  24      -4.794 -18.287  -0.085  1.00 32.95           C  
ATOM   2201  C   PHE C  24      -4.741 -19.289   1.096  1.00 32.20           C  
ATOM   2202  O   PHE C  24      -5.250 -20.395   1.001  1.00 31.56           O  
ATOM   2203  CB  PHE C  24      -3.468 -18.247  -0.844  1.00 32.80           C  
ATOM   2204  CG  PHE C  24      -2.825 -19.587  -0.975  1.00 31.41           C  
ATOM   2205  CD1 PHE C  24      -3.383 -20.553  -1.801  1.00 29.88           C  
ATOM   2206  CD2 PHE C  24      -1.682 -19.890  -0.231  1.00 30.44           C  
ATOM   2207  CE1 PHE C  24      -2.809 -21.808  -1.906  1.00 32.02           C  
ATOM   2208  CE2 PHE C  24      -1.077 -21.134  -0.323  1.00 32.04           C  
ATOM   2209  CZ  PHE C  24      -1.640 -22.112  -1.170  1.00 32.45           C  
ATOM   2210  N   LEU C  25      -4.128 -18.886   2.199  1.00 32.18           N  
ATOM   2211  CA  LEU C  25      -4.017 -19.741   3.382  1.00 32.11           C  
ATOM   2212  C   LEU C  25      -5.366 -20.055   4.045  1.00 32.40           C  
ATOM   2213  O   LEU C  25      -5.594 -21.204   4.451  1.00 32.02           O  
ATOM   2214  CB  LEU C  25      -3.001 -19.172   4.377  1.00 31.60           C  
ATOM   2215  CG  LEU C  25      -1.556 -19.184   3.832  1.00 32.13           C  
ATOM   2216  CD1 LEU C  25      -0.671 -18.274   4.690  1.00 31.49           C  
ATOM   2217  CD2 LEU C  25      -0.966 -20.603   3.741  1.00 29.96           C  
ATOM   2218  N   ASN C  26      -6.268 -19.075   4.114  1.00 32.77           N  
ATOM   2219  CA  ASN C  26      -7.629 -19.361   4.561  1.00 33.32           C  
ATOM   2220  C   ASN C  26      -8.309 -20.323   3.601  1.00 33.23           C  
ATOM   2221  O   ASN C  26      -9.013 -21.235   4.024  1.00 33.48           O  
ATOM   2222  CB  ASN C  26      -8.464 -18.086   4.777  1.00 34.47           C  
ATOM   2223  CG  ASN C  26      -7.992 -17.273   5.999  1.00 36.98           C  
ATOM   2224  OD1 ASN C  26      -7.750 -17.819   7.085  1.00 38.41           O  
ATOM   2225  ND2 ASN C  26      -7.849 -15.971   5.815  1.00 38.79           N  
ATOM   2226  N   ALA C  27      -8.062 -20.156   2.308  1.00 32.97           N  
ATOM   2227  CA  ALA C  27      -8.666 -21.026   1.312  1.00 33.59           C  
ATOM   2228  C   ALA C  27      -8.266 -22.485   1.490  1.00 33.55           C  
ATOM   2229  O   ALA C  27      -9.100 -23.374   1.336  1.00 34.65           O  
ATOM   2230  CB  ALA C  27      -8.344 -20.544  -0.110  1.00 33.61           C  
ATOM   2231  N   LEU C  28      -6.995 -22.728   1.817  1.00 33.41           N  
ATOM   2232  CA  LEU C  28      -6.504 -24.072   2.121  1.00 33.69           C  
ATOM   2233  C   LEU C  28      -7.197 -24.680   3.331  1.00 33.94           C  
ATOM   2234  O   LEU C  28      -7.634 -25.833   3.302  1.00 34.46           O  
ATOM   2235  CB  LEU C  28      -5.022 -24.043   2.430  1.00 32.93           C  
ATOM   2236  CG  LEU C  28      -3.959 -24.081   1.358  1.00 34.74           C  
ATOM   2237  CD1 LEU C  28      -2.626 -24.021   2.093  1.00 33.89           C  
ATOM   2238  CD2 LEU C  28      -4.061 -25.336   0.502  1.00 35.74           C  
ATOM   2239  N   GLN C  29      -7.259 -23.905   4.404  1.00 34.46           N  
ATOM   2240  CA  GLN C  29      -7.897 -24.333   5.634  1.00 36.00           C  
ATOM   2241  C   GLN C  29      -9.382 -24.619   5.363  1.00 37.01           C  
ATOM   2242  O   GLN C  29      -9.926 -25.611   5.838  1.00 37.44           O  
ATOM   2243  CB  GLN C  29      -7.708 -23.259   6.722  1.00 35.70           C  
ATOM   2244  CG  GLN C  29      -8.449 -23.591   7.998  1.00 37.97           C  
ATOM   2245  CD  GLN C  29      -7.985 -22.821   9.219  1.00 39.68           C  
ATOM   2246  OE1 GLN C  29      -8.512 -23.038  10.279  1.00 42.47           O  
ATOM   2247  NE2 GLN C  29      -6.999 -21.950   9.085  1.00 39.47           N  
ATOM   2248  N   ASN C  30     -10.014 -23.763   4.561  1.00 37.98           N  
ATOM   2249  CA  ASN C  30     -11.455 -23.849   4.305  1.00 39.60           C  
ATOM   2250  C   ASN C  30     -11.830 -24.819   3.187  1.00 40.24           C  
ATOM   2251  O   ASN C  30     -13.022 -25.037   2.909  1.00 40.58           O  
ATOM   2252  CB  ASN C  30     -12.040 -22.470   3.966  1.00 40.25           C  
ATOM   2253  CG  ASN C  30     -12.050 -21.531   5.141  1.00 41.35           C  
ATOM   2254  OD1 ASN C  30     -11.928 -21.926   6.303  1.00 41.41           O  
ATOM   2255  ND2 ASN C  30     -12.189 -20.265   4.835  1.00 44.07           N  
ATOM   2256  N   GLU C  31     -10.813 -25.372   2.527  1.00 39.70           N  
ATOM   2257  CA  GLU C  31     -11.019 -26.303   1.403  1.00 40.71           C  
ATOM   2258  C   GLU C  31     -11.751 -25.659   0.232  1.00 41.27           C  
ATOM   2259  O   GLU C  31     -12.554 -26.298  -0.455  1.00 42.35           O  
ATOM   2260  CB  GLU C  31     -11.723 -27.583   1.855  1.00 41.03           C  
ATOM   2261  CG  GLU C  31     -10.816 -28.458   2.664  1.00 41.87           C  
ATOM   2262  CD  GLU C  31     -11.552 -29.585   3.310  1.00 44.50           C  
ATOM   2263  OE1 GLU C  31     -12.704 -29.824   3.003  1.00 46.83           O  
ATOM   2264  OE2 GLU C  31     -10.996 -30.273   4.138  1.00 46.14           O  
ATOM   2265  N   ASP C  32     -11.454 -24.383   0.015  1.00 40.93           N  
ATOM   2266  CA  ASP C  32     -12.102 -23.577  -1.000  1.00 41.62           C  
ATOM   2267  C   ASP C  32     -11.202 -23.650  -2.234  1.00 41.67           C  
ATOM   2268  O   ASP C  32     -10.370 -22.759  -2.507  1.00 41.01           O  
ATOM   2269  CB  ASP C  32     -12.285 -22.151  -0.467  1.00 41.62           C  
ATOM   2270  CG  ASP C  32     -12.786 -21.165  -1.520  1.00 43.37           C  
ATOM   2271  OD1 ASP C  32     -13.171 -21.591  -2.636  1.00 43.27           O  
ATOM   2272  OD2 ASP C  32     -12.775 -19.940  -1.213  1.00 44.03           O  
ATOM   2273  N   PHE C  33     -11.373 -24.739  -2.980  1.00 42.03           N  
ATOM   2274  CA  PHE C  33     -10.349 -25.142  -3.955  1.00 42.42           C  
ATOM   2275  C   PHE C  33     -10.345 -24.320  -5.218  1.00 43.38           C  
ATOM   2276  O   PHE C  33      -9.327 -24.239  -5.906  1.00 43.66           O  
ATOM   2277  CB  PHE C  33     -10.379 -26.648  -4.229  1.00 42.60           C  
ATOM   2278  CG  PHE C  33      -9.902 -27.461  -3.066  1.00 42.54           C  
ATOM   2279  CD1 PHE C  33      -8.582 -27.350  -2.627  1.00 42.34           C  
ATOM   2280  CD2 PHE C  33     -10.769 -28.305  -2.386  1.00 43.97           C  
ATOM   2281  CE1 PHE C  33      -8.131 -28.081  -1.552  1.00 42.96           C  
ATOM   2282  CE2 PHE C  33     -10.329 -29.042  -1.295  1.00 44.49           C  
ATOM   2283  CZ  PHE C  33      -9.008 -28.930  -0.873  1.00 42.66           C  
ATOM   2284  N   ASP C  34     -11.466 -23.675  -5.504  1.00 44.22           N  
ATOM   2285  CA  ASP C  34     -11.503 -22.751  -6.620  1.00 45.96           C  
ATOM   2286  C   ASP C  34     -10.717 -21.455  -6.342  1.00 45.32           C  
ATOM   2287  O   ASP C  34     -10.075 -20.909  -7.252  1.00 46.36           O  
ATOM   2288  CB  ASP C  34     -12.933 -22.440  -7.031  1.00 47.81           C  
ATOM   2289  CG  ASP C  34     -13.688 -23.670  -7.487  1.00 49.98           C  
ATOM   2290  OD1 ASP C  34     -14.880 -23.564  -7.747  1.00 53.83           O  
ATOM   2291  OD2 ASP C  34     -13.126 -24.762  -7.576  1.00 51.14           O  
ATOM   2292  N   THR C  35     -10.754 -20.972  -5.101  1.00 43.66           N  
ATOM   2293  CA  THR C  35      -9.877 -19.872  -4.696  1.00 42.48           C  
ATOM   2294  C   THR C  35      -8.398 -20.294  -4.685  1.00 41.82           C  
ATOM   2295  O   THR C  35      -7.527 -19.517  -5.075  1.00 42.36           O  
ATOM   2296  CB  THR C  35     -10.298 -19.295  -3.335  1.00 41.66           C  
ATOM   2297  OG1 THR C  35     -11.649 -18.829  -3.429  1.00 41.95           O  
ATOM   2298  CG2 THR C  35      -9.392 -18.154  -2.895  1.00 39.16           C  
ATOM   2299  N   VAL C  36      -8.118 -21.517  -4.240  1.00 40.79           N  
ATOM   2300  CA  VAL C  36      -6.757 -22.060  -4.306  1.00 40.06           C  
ATOM   2301  C   VAL C  36      -6.244 -22.060  -5.767  1.00 41.48           C  
ATOM   2302  O   VAL C  36      -5.127 -21.617  -6.052  1.00 41.60           O  
ATOM   2303  CB  VAL C  36      -6.678 -23.471  -3.690  1.00 39.26           C  
ATOM   2304  CG1 VAL C  36      -5.362 -24.158  -4.080  1.00 37.92           C  
ATOM   2305  CG2 VAL C  36      -6.869 -23.391  -2.165  1.00 37.10           C  
ATOM   2306  N   ASP C  37      -7.086 -22.530  -6.683  1.00 42.89           N  
ATOM   2307  CA  ASP C  37      -6.810 -22.488  -8.129  1.00 44.94           C  
ATOM   2308  C   ASP C  37      -6.552 -21.110  -8.709  1.00 44.98           C  
ATOM   2309  O   ASP C  37      -5.632 -20.924  -9.500  1.00 45.80           O  
ATOM   2310  CB  ASP C  37      -7.979 -23.081  -8.910  1.00 46.93           C  
ATOM   2311  CG  ASP C  37      -7.938 -24.566  -8.939  1.00 50.36           C  
ATOM   2312  OD1 ASP C  37      -6.821 -25.118  -8.983  1.00 53.71           O  
ATOM   2313  OD2 ASP C  37      -9.005 -25.198  -8.906  1.00 55.05           O  
ATOM   2314  N   ALA C  38      -7.390 -20.154  -8.345  1.00 44.40           N  
ATOM   2315  CA  ALA C  38      -7.205 -18.776  -8.780  1.00 44.56           C  
ATOM   2316  C   ALA C  38      -5.942 -18.138  -8.177  1.00 43.34           C  
ATOM   2317  O   ALA C  38      -5.328 -17.279  -8.816  1.00 44.57           O  
ATOM   2318  CB  ALA C  38      -8.431 -17.955  -8.443  1.00 44.63           C  
ATOM   2319  N   ALA C  39      -5.549 -18.565  -6.968  1.00 41.07           N  
ATOM   2320  CA  ALA C  39      -4.455 -17.919  -6.230  1.00 39.37           C  
ATOM   2321  C   ALA C  39      -3.064 -18.301  -6.742  1.00 39.10           C  
ATOM   2322  O   ALA C  39      -2.116 -17.541  -6.567  1.00 39.05           O  
ATOM   2323  CB  ALA C  39      -4.562 -18.216  -4.744  1.00 37.56           C  
ATOM   2324  N   LEU C  40      -2.930 -19.464  -7.381  1.00 38.85           N  
ATOM   2325  CA  LEU C  40      -1.589 -19.987  -7.680  1.00 38.03           C  
ATOM   2326  C   LEU C  40      -1.191 -19.734  -9.119  1.00 39.74           C  
ATOM   2327  O   LEU C  40      -1.884 -20.141 -10.039  1.00 40.81           O  
ATOM   2328  CB  LEU C  40      -1.477 -21.481  -7.350  1.00 36.72           C  
ATOM   2329  CG  LEU C  40      -1.737 -21.920  -5.900  1.00 34.75           C  
ATOM   2330  CD1 LEU C  40      -1.639 -23.447  -5.769  1.00 32.10           C  
ATOM   2331  CD2 LEU C  40      -0.804 -21.220  -4.909  1.00 31.87           C  
ATOM   2332  N   GLY C  41      -0.071 -19.049  -9.309  1.00 40.28           N  
ATOM   2333  CA  GLY C  41       0.433 -18.767 -10.636  1.00 42.16           C  
ATOM   2334  C   GLY C  41       0.827 -20.030 -11.388  1.00 43.27           C  
ATOM   2335  O   GLY C  41       1.256 -21.020 -10.789  1.00 42.06           O  
ATOM   2336  N   ASP C  42       0.691 -19.986 -12.710  1.00 45.55           N  
ATOM   2337  CA  ASP C  42       1.080 -21.103 -13.578  1.00 47.33           C  
ATOM   2338  C   ASP C  42       2.502 -21.622 -13.366  1.00 46.61           C  
ATOM   2339  O   ASP C  42       2.725 -22.824 -13.415  1.00 46.49           O  
ATOM   2340  CB  ASP C  42       0.852 -20.757 -15.045  1.00 49.95           C  
ATOM   2341  CG  ASP C  42      -0.620 -20.823 -15.437  1.00 52.65           C  
ATOM   2342  OD1 ASP C  42      -0.969 -20.365 -16.550  1.00 57.16           O  
ATOM   2343  OD2 ASP C  42      -1.441 -21.329 -14.638  1.00 53.34           O  
ATOM   2344  N   ASP C  43       3.445 -20.729 -13.091  1.00 46.41           N  
ATOM   2345  CA  ASP C  43       4.815 -21.138 -12.817  1.00 46.19           C  
ATOM   2346  C   ASP C  43       5.219 -21.136 -11.345  1.00 43.76           C  
ATOM   2347  O   ASP C  43       6.396 -20.962 -11.014  1.00 43.99           O  
ATOM   2348  CB  ASP C  43       5.769 -20.307 -13.629  1.00 48.02           C  
ATOM   2349  CG  ASP C  43       5.728 -20.677 -15.088  1.00 53.36           C  
ATOM   2350  OD1 ASP C  43       6.776 -20.596 -15.734  1.00 58.40           O  
ATOM   2351  OD2 ASP C  43       4.674 -21.080 -15.625  1.00 57.01           O  
ATOM   2352  N   LEU C  44       4.246 -21.358 -10.468  1.00 41.37           N  
ATOM   2353  CA  LEU C  44       4.513 -21.554  -9.056  1.00 38.44           C  
ATOM   2354  C   LEU C  44       5.666 -22.518  -8.823  1.00 38.30           C  
ATOM   2355  O   LEU C  44       5.716 -23.596  -9.437  1.00 38.79           O  
ATOM   2356  CB  LEU C  44       3.267 -22.089  -8.353  1.00 37.07           C  
ATOM   2357  CG  LEU C  44       3.398 -22.411  -6.864  1.00 35.08           C  
ATOM   2358  CD1 LEU C  44       3.569 -21.140  -5.997  1.00 31.70           C  
ATOM   2359  CD2 LEU C  44       2.194 -23.236  -6.416  1.00 33.45           C  
ATOM   2360  N   VAL C  45       6.600 -22.129  -7.952  1.00 37.01           N  
ATOM   2361  CA  VAL C  45       7.447 -23.125  -7.302  1.00 35.67           C  
ATOM   2362  C   VAL C  45       7.104 -23.237  -5.822  1.00 34.33           C  
ATOM   2363  O   VAL C  45       7.077 -22.232  -5.078  1.00 33.73           O  
ATOM   2364  CB  VAL C  45       9.010 -23.040  -7.644  1.00 37.35           C  
ATOM   2365  CG1 VAL C  45       9.375 -21.925  -8.668  1.00 36.30           C  
ATOM   2366  CG2 VAL C  45       9.889 -23.049  -6.397  1.00 34.94           C  
ATOM   2367  N   TYR C  46       6.798 -24.475  -5.424  1.00 33.77           N  
ATOM   2368  CA  TYR C  46       6.341 -24.802  -4.078  1.00 32.36           C  
ATOM   2369  C   TYR C  46       7.328 -25.723  -3.334  1.00 32.63           C  
ATOM   2370  O   TYR C  46       7.536 -26.905  -3.703  1.00 32.99           O  
ATOM   2371  CB  TYR C  46       4.936 -25.422  -4.127  1.00 31.90           C  
ATOM   2372  CG  TYR C  46       4.467 -26.071  -2.840  1.00 30.13           C  
ATOM   2373  CD1 TYR C  46       4.661 -25.446  -1.603  1.00 29.06           C  
ATOM   2374  CD2 TYR C  46       3.798 -27.294  -2.863  1.00 29.67           C  
ATOM   2375  CE1 TYR C  46       4.198 -26.030  -0.410  1.00 28.56           C  
ATOM   2376  CE2 TYR C  46       3.340 -27.902  -1.679  1.00 29.39           C  
ATOM   2377  CZ  TYR C  46       3.554 -27.258  -0.460  1.00 30.43           C  
ATOM   2378  OH  TYR C  46       3.129 -27.816   0.713  1.00 30.27           O  
ATOM   2379  N   GLU C  47       7.904 -25.176  -2.265  1.00 32.18           N  
ATOM   2380  CA  GLU C  47       8.948 -25.849  -1.508  1.00 33.19           C  
ATOM   2381  C   GLU C  47       8.542 -26.010  -0.066  1.00 31.44           C  
ATOM   2382  O   GLU C  47       8.149 -25.047   0.589  1.00 31.21           O  
ATOM   2383  CB  GLU C  47      10.256 -25.056  -1.548  1.00 33.39           C  
ATOM   2384  CG  GLU C  47      10.940 -25.070  -2.902  1.00 37.47           C  
ATOM   2385  CD  GLU C  47      12.047 -24.011  -3.077  1.00 39.62           C  
ATOM   2386  OE1 GLU C  47      12.187 -23.063  -2.247  1.00 42.11           O  
ATOM   2387  OE2 GLU C  47      12.791 -24.135  -4.083  1.00 44.89           O  
ATOM   2388  N   ASN C  48       8.616 -27.239   0.416  1.00 31.19           N  
ATOM   2389  CA  ASN C  48       8.780 -27.477   1.832  1.00 30.48           C  
ATOM   2390  C   ASN C  48      10.281 -27.643   2.014  1.00 30.83           C  
ATOM   2391  O   ASN C  48      10.857 -28.630   1.545  1.00 31.52           O  
ATOM   2392  CB  ASN C  48       8.009 -28.721   2.244  1.00 30.24           C  
ATOM   2393  CG  ASN C  48       6.526 -28.520   2.141  1.00 30.43           C  
ATOM   2394  OD1 ASN C  48       5.958 -27.707   2.867  1.00 29.17           O  
ATOM   2395  ND2 ASN C  48       5.880 -29.238   1.220  1.00 29.60           N  
ATOM   2396  N   VAL C  49      10.920 -26.665   2.645  1.00 30.43           N  
ATOM   2397  CA  VAL C  49      12.380 -26.561   2.592  1.00 31.40           C  
ATOM   2398  C   VAL C  49      13.065 -27.806   3.143  1.00 32.97           C  
ATOM   2399  O   VAL C  49      12.805 -28.217   4.282  1.00 33.11           O  
ATOM   2400  CB  VAL C  49      12.886 -25.316   3.371  1.00 31.30           C  
ATOM   2401  CG1 VAL C  49      14.230 -25.062   3.169  1.00 29.88           C  
ATOM   2402  CG2 VAL C  49      12.414 -24.167   2.843  1.00 29.24           C  
ATOM   2403  N   GLY C  50      13.931 -28.401   2.317  1.00 34.34           N  
ATOM   2404  CA  GLY C  50      14.668 -29.605   2.670  1.00 35.13           C  
ATOM   2405  C   GLY C  50      13.904 -30.879   2.351  1.00 36.20           C  
ATOM   2406  O   GLY C  50      14.439 -31.973   2.529  1.00 36.86           O  
ATOM   2407  N   PHE C  51      12.660 -30.762   1.888  1.00 35.73           N  
ATOM   2408  CA  PHE C  51      11.823 -31.960   1.725  1.00 37.24           C  
ATOM   2409  C   PHE C  51      11.161 -32.171   0.368  1.00 37.53           C  
ATOM   2410  O   PHE C  51      11.097 -33.294  -0.112  1.00 38.67           O  
ATOM   2411  CB  PHE C  51      10.789 -32.077   2.864  1.00 36.99           C  
ATOM   2412  CG  PHE C  51      11.427 -32.309   4.197  1.00 39.49           C  
ATOM   2413  CD1 PHE C  51      11.698 -33.603   4.635  1.00 42.56           C  
ATOM   2414  CD2 PHE C  51      11.841 -31.234   4.986  1.00 40.49           C  
ATOM   2415  CE1 PHE C  51      12.336 -33.824   5.861  1.00 43.21           C  
ATOM   2416  CE2 PHE C  51      12.482 -31.448   6.198  1.00 41.54           C  
ATOM   2417  CZ  PHE C  51      12.730 -32.748   6.635  1.00 41.69           C  
ATOM   2418  N   SER C  52      10.655 -31.114  -0.238  1.00 36.79           N  
ATOM   2419  CA  SER C  52       9.941 -31.271  -1.476  1.00 37.68           C  
ATOM   2420  C   SER C  52       9.975 -29.991  -2.278  1.00 38.27           C  
ATOM   2421  O   SER C  52       9.947 -28.875  -1.718  1.00 37.39           O  
ATOM   2422  CB  SER C  52       8.489 -31.721  -1.231  1.00 36.92           C  
ATOM   2423  OG  SER C  52       7.676 -30.697  -0.684  1.00 35.06           O  
ATOM   2424  N   ARG C  53      10.067 -30.175  -3.590  1.00 40.06           N  
ATOM   2425  CA  ARG C  53       9.842 -29.103  -4.531  1.00 41.71           C  
ATOM   2426  C   ARG C  53       8.903 -29.539  -5.650  1.00 42.35           C  
ATOM   2427  O   ARG C  53       9.090 -30.582  -6.263  1.00 43.60           O  
ATOM   2428  CB  ARG C  53      11.143 -28.563  -5.106  1.00 42.24           C  
ATOM   2429  CG  ARG C  53      10.817 -27.412  -6.028  1.00 44.70           C  
ATOM   2430  CD  ARG C  53      11.980 -26.831  -6.751  1.00 49.33           C  
ATOM   2431  NE  ARG C  53      12.803 -26.114  -5.813  1.00 54.73           N  
ATOM   2432  CZ  ARG C  53      14.038 -26.485  -5.571  1.00 57.95           C  
ATOM   2433  NH1 ARG C  53      14.526 -27.516  -6.238  1.00 60.54           N  
ATOM   2434  NH2 ARG C  53      14.772 -25.823  -4.704  1.00 58.00           N  
ATOM   2435  N   ILE C  54       7.882 -28.729  -5.893  1.00 42.34           N  
ATOM   2436  CA  ILE C  54       6.953 -28.954  -6.990  1.00 43.48           C  
ATOM   2437  C   ILE C  54       6.922 -27.694  -7.827  1.00 43.71           C  
ATOM   2438  O   ILE C  54       6.944 -26.573  -7.290  1.00 42.59           O  
ATOM   2439  CB  ILE C  54       5.523 -29.295  -6.475  1.00 42.70           C  
ATOM   2440  CG1 ILE C  54       5.512 -30.687  -5.842  1.00 44.57           C  
ATOM   2441  CG2 ILE C  54       4.502 -29.259  -7.604  1.00 43.50           C  
ATOM   2442  CD1 ILE C  54       4.158 -31.095  -5.259  1.00 43.09           C  
ATOM   2443  N   ARG C  55       6.853 -27.892  -9.137  1.00 45.30           N  
ATOM   2444  CA  ARG C  55       6.719 -26.807 -10.096  1.00 46.70           C  
ATOM   2445  C   ARG C  55       5.400 -26.810 -10.839  1.00 46.46           C  
ATOM   2446  O   ARG C  55       5.030 -27.806 -11.449  1.00 47.71           O  
ATOM   2447  CB  ARG C  55       7.827 -26.915 -11.101  1.00 48.59           C  
ATOM   2448  CG  ARG C  55       9.098 -27.107 -10.398  1.00 52.24           C  
ATOM   2449  CD  ARG C  55      10.165 -26.942 -11.331  1.00 60.22           C  
ATOM   2450  NE  ARG C  55       9.887 -25.643 -11.887  1.00 64.12           N  
ATOM   2451  CZ  ARG C  55      10.659 -24.583 -11.723  1.00 65.94           C  
ATOM   2452  NH1 ARG C  55      11.788 -24.606 -11.054  1.00 65.74           N  
ATOM   2453  NH2 ARG C  55      10.299 -23.470 -12.249  1.00 66.37           N  
ATOM   2454  N   GLY C  56       4.714 -25.677 -10.807  1.00 45.30           N  
ATOM   2455  CA  GLY C  56       3.482 -25.519 -11.554  1.00 45.30           C  
ATOM   2456  C   GLY C  56       2.282 -25.378 -10.657  1.00 43.69           C  
ATOM   2457  O   GLY C  56       2.009 -26.258  -9.845  1.00 42.87           O  
ATOM   2458  N   GLY C  57       1.571 -24.263 -10.819  1.00 43.28           N  
ATOM   2459  CA  GLY C  57       0.384 -23.959 -10.040  1.00 42.49           C  
ATOM   2460  C   GLY C  57      -0.736 -24.974 -10.174  1.00 42.79           C  
ATOM   2461  O   GLY C  57      -1.365 -25.350  -9.195  1.00 41.60           O  
ATOM   2462  N   ARG C  58      -0.984 -25.425 -11.387  1.00 44.64           N  
ATOM   2463  CA  ARG C  58      -2.011 -26.447 -11.615  1.00 45.82           C  
ATOM   2464  C   ARG C  58      -1.755 -27.805 -11.053  1.00 45.16           C  
ATOM   2465  O   ARG C  58      -2.674 -28.478 -10.602  1.00 44.93           O  
ATOM   2466  CB  ARG C  58      -2.166 -26.675 -13.069  1.00 48.17           C  
ATOM   2467  CG  ARG C  58      -2.885 -25.633 -13.586  1.00 49.74           C  
ATOM   2468  CD  ARG C  58      -2.644 -25.749 -14.935  1.00 55.29           C  
ATOM   2469  NE  ARG C  58      -3.134 -24.571 -15.411  1.00 59.35           N  
ATOM   2470  CZ  ARG C  58      -4.367 -24.328 -15.192  1.00 59.08           C  
ATOM   2471  NH1 ARG C  58      -5.122 -25.214 -14.556  1.00 58.13           N  
ATOM   2472  NH2 ARG C  58      -4.795 -23.221 -15.627  1.00 59.14           N  
ATOM   2473  N   ARG C  59      -0.512 -28.229 -11.143  1.00 45.03           N  
ATOM   2474  CA  ARG C  59      -0.151 -29.484 -10.576  1.00 45.14           C  
ATOM   2475  C   ARG C  59      -0.249 -29.429  -9.045  1.00 42.78           C  
ATOM   2476  O   ARG C  59      -0.732 -30.385  -8.434  1.00 42.27           O  
ATOM   2477  CB  ARG C  59       1.232 -29.867 -11.071  1.00 46.35           C  
ATOM   2478  CG  ARG C  59       1.749 -31.125 -10.487  1.00 49.75           C  
ATOM   2479  CD  ARG C  59       2.678 -31.787 -11.447  1.00 57.38           C  
ATOM   2480  NE  ARG C  59       3.890 -32.219 -10.790  1.00 61.88           N  
ATOM   2481  CZ  ARG C  59       5.116 -32.034 -11.266  1.00 64.99           C  
ATOM   2482  NH1 ARG C  59       5.327 -31.466 -12.414  1.00 66.35           N  
ATOM   2483  NH2 ARG C  59       6.153 -32.447 -10.606  1.00 64.43           N  
ATOM   2484  N   THR C  60       0.180 -28.308  -8.443  1.00 41.18           N  
ATOM   2485  CA  THR C  60       0.074 -28.110  -6.984  1.00 39.03           C  
ATOM   2486  C   THR C  60      -1.389 -27.977  -6.543  1.00 38.61           C  
ATOM   2487  O   THR C  60      -1.802 -28.582  -5.542  1.00 37.29           O  
ATOM   2488  CB  THR C  60       0.887 -26.879  -6.509  1.00 38.41           C  
ATOM   2489  OG1 THR C  60       2.270 -27.085  -6.811  1.00 38.13           O  
ATOM   2490  CG2 THR C  60       0.726 -26.645  -5.004  1.00 34.76           C  
ATOM   2491  N   ALA C  61      -2.155 -27.197  -7.311  1.00 39.24           N  
ATOM   2492  CA  ALA C  61      -3.573 -26.976  -7.048  1.00 39.23           C  
ATOM   2493  C   ALA C  61      -4.377 -28.275  -7.020  1.00 40.03           C  
ATOM   2494  O   ALA C  61      -5.190 -28.469  -6.108  1.00 39.28           O  
ATOM   2495  CB  ALA C  61      -4.161 -25.996  -8.033  1.00 39.85           C  
ATOM   2496  N   THR C  62      -4.145 -29.171  -7.988  1.00 41.44           N  
ATOM   2497  CA  THR C  62      -4.910 -30.426  -7.996  1.00 42.48           C  
ATOM   2498  C   THR C  62      -4.380 -31.447  -6.981  1.00 42.08           C  
ATOM   2499  O   THR C  62      -5.146 -32.263  -6.456  1.00 42.05           O  
ATOM   2500  CB  THR C  62      -5.172 -31.059  -9.426  1.00 44.52           C  
ATOM   2501  OG1 THR C  62      -3.961 -31.491 -10.019  1.00 44.49           O  
ATOM   2502  CG2 THR C  62      -5.743 -30.072 -10.368  1.00 44.97           C  
ATOM   2503  N   LEU C  63      -3.088 -31.378  -6.674  1.00 41.77           N  
ATOM   2504  CA  LEU C  63      -2.535 -32.170  -5.570  1.00 41.76           C  
ATOM   2505  C   LEU C  63      -3.254 -31.844  -4.256  1.00 40.64           C  
ATOM   2506  O   LEU C  63      -3.697 -32.749  -3.533  1.00 40.16           O  
ATOM   2507  CB  LEU C  63      -1.047 -31.897  -5.406  1.00 41.52           C  
ATOM   2508  CG  LEU C  63      -0.311 -32.986  -4.651  1.00 44.18           C  
ATOM   2509  CD1 LEU C  63      -0.113 -34.210  -5.534  1.00 47.40           C  
ATOM   2510  CD2 LEU C  63       1.024 -32.473  -4.186  1.00 45.45           C  
ATOM   2511  N   LEU C  64      -3.364 -30.543  -3.974  1.00 39.80           N  
ATOM   2512  CA  LEU C  64      -4.036 -30.062  -2.785  1.00 39.46           C  
ATOM   2513  C   LEU C  64      -5.520 -30.401  -2.796  1.00 40.55           C  
ATOM   2514  O   LEU C  64      -6.064 -30.876  -1.794  1.00 40.27           O  
ATOM   2515  CB  LEU C  64      -3.831 -28.555  -2.616  1.00 38.60           C  
ATOM   2516  CG  LEU C  64      -2.400 -28.115  -2.268  1.00 38.53           C  
ATOM   2517  CD1 LEU C  64      -2.277 -26.604  -2.383  1.00 38.33           C  
ATOM   2518  CD2 LEU C  64      -1.939 -28.609  -0.890  1.00 35.68           C  
ATOM   2519  N   ARG C  65      -6.169 -30.186  -3.937  1.00 41.90           N  
ATOM   2520  CA  ARG C  65      -7.562 -30.564  -4.092  1.00 43.56           C  
ATOM   2521  C   ARG C  65      -7.778 -32.041  -3.773  1.00 44.23           C  
ATOM   2522  O   ARG C  65      -8.767 -32.407  -3.133  1.00 44.51           O  
ATOM   2523  CB  ARG C  65      -8.073 -30.230  -5.495  1.00 44.55           C  
ATOM   2524  CG  ARG C  65      -9.550 -30.554  -5.715  1.00 46.19           C  
ATOM   2525  CD  ARG C  65      -9.974 -30.323  -7.173  1.00 48.02           C  
ATOM   2526  NE  ARG C  65      -9.941 -28.895  -7.507  1.00 49.26           N  
ATOM   2527  CZ  ARG C  65     -10.971 -28.056  -7.367  1.00 50.58           C  
ATOM   2528  NH1 ARG C  65     -12.141 -28.497  -6.900  1.00 49.20           N  
ATOM   2529  NH2 ARG C  65     -10.831 -26.766  -7.693  1.00 50.91           N  
ATOM   2530  N   ARG C  66      -6.846 -32.883  -4.196  1.00 45.08           N  
ATOM   2531  CA  ARG C  66      -7.017 -34.313  -4.018  1.00 46.21           C  
ATOM   2532  C   ARG C  66      -6.756 -34.801  -2.609  1.00 46.13           C  
ATOM   2533  O   ARG C  66      -6.997 -35.959  -2.296  1.00 46.87           O  
ATOM   2534  CB  ARG C  66      -6.227 -35.088  -5.051  1.00 46.90           C  
ATOM   2535  CG  ARG C  66      -6.938 -35.015  -6.346  1.00 47.80           C  
ATOM   2536  CD  ARG C  66      -6.271 -35.781  -7.378  1.00 47.85           C  
ATOM   2537  NE  ARG C  66      -6.961 -35.524  -8.619  1.00 47.82           N  
ATOM   2538  CZ  ARG C  66      -6.453 -35.836  -9.782  1.00 48.41           C  
ATOM   2539  NH1 ARG C  66      -5.298 -36.417  -9.758  1.00 47.45           N  
ATOM   2540  NH2 ARG C  66      -7.070 -35.588 -10.929  1.00 48.27           N  
HETATM 2541  N   MSE C  67      -6.306 -33.910  -1.750  0.44 45.67           N  
HETATM 2542  CA  MSE C  67      -6.097 -34.280  -0.376  1.00 47.06           C  
HETATM 2543  C   MSE C  67      -7.338 -34.141   0.508  1.00 46.09           C  
HETATM 2544  O   MSE C  67      -7.392 -34.646   1.641  1.00 45.85           O  
HETATM 2545  CB  MSE C  67      -4.933 -33.500   0.189  1.00 45.69           C  
HETATM 2546  CG  MSE C  67      -3.610 -34.191  -0.103  1.00 47.26           C  
HETATM 2547 SE   MSE C  67      -2.210 -33.077   0.579  1.00 53.06          SE  
HETATM 2548  CE  MSE C  67      -1.455 -32.367  -1.055  1.00 49.95           C  
ATOM   2549  N   GLN C  68      -8.333 -33.460  -0.032  1.00 45.85           N  
ATOM   2550  CA  GLN C  68      -9.610 -33.283   0.602  1.00 45.77           C  
ATOM   2551  C   GLN C  68     -10.178 -34.603   1.132  1.00 46.22           C  
ATOM   2552  O   GLN C  68     -10.256 -35.596   0.398  1.00 46.64           O  
ATOM   2553  CB  GLN C  68     -10.522 -32.755  -0.469  1.00 46.31           C  
ATOM   2554  CG  GLN C  68     -11.500 -31.822  -0.028  1.00 47.31           C  
ATOM   2555  CD  GLN C  68     -12.767 -32.419   0.348  1.00 49.55           C  
ATOM   2556  OE1 GLN C  68     -13.414 -31.931   1.206  1.00 48.61           O  
ATOM   2557  NE2 GLN C  68     -13.163 -33.447  -0.303  1.00 50.30           N  
ATOM   2558  N   GLY C  69     -10.580 -34.618   2.404  1.00 45.47           N  
ATOM   2559  CA  GLY C  69     -11.117 -35.846   3.007  1.00 45.98           C  
ATOM   2560  C   GLY C  69     -10.068 -36.840   3.516  1.00 45.79           C  
ATOM   2561  O   GLY C  69     -10.415 -37.843   4.117  1.00 46.43           O  
ATOM   2562  N   ARG C  70      -8.786 -36.563   3.288  1.00 44.83           N  
ATOM   2563  CA  ARG C  70      -7.705 -37.417   3.800  1.00 45.24           C  
ATOM   2564  C   ARG C  70      -6.815 -36.717   4.773  1.00 43.39           C  
ATOM   2565  O   ARG C  70      -6.401 -37.279   5.770  1.00 43.61           O  
ATOM   2566  CB  ARG C  70      -6.797 -37.864   2.676  1.00 46.17           C  
ATOM   2567  CG  ARG C  70      -7.340 -38.960   1.941  1.00 49.63           C  
ATOM   2568  CD  ARG C  70      -7.457 -38.592   0.596  1.00 53.71           C  
ATOM   2569  NE  ARG C  70      -7.692 -39.716  -0.289  1.00 59.64           N  
ATOM   2570  CZ  ARG C  70      -8.879 -40.280  -0.516  1.00 62.67           C  
ATOM   2571  NH1 ARG C  70      -9.982 -39.877   0.112  1.00 62.55           N  
ATOM   2572  NH2 ARG C  70      -8.965 -41.272  -1.382  1.00 64.26           N  
ATOM   2573  N   VAL C  71      -6.453 -35.498   4.434  1.00 41.80           N  
ATOM   2574  CA  VAL C  71      -5.733 -34.670   5.370  1.00 40.25           C  
ATOM   2575  C   VAL C  71      -6.313 -33.259   5.356  1.00 39.21           C  
ATOM   2576  O   VAL C  71      -6.406 -32.631   4.302  1.00 39.59           O  
ATOM   2577  CB  VAL C  71      -4.194 -34.732   5.124  1.00 39.73           C  
ATOM   2578  CG1 VAL C  71      -3.888 -34.784   3.683  1.00 40.12           C  
ATOM   2579  CG2 VAL C  71      -3.481 -33.566   5.766  1.00 38.98           C  
ATOM   2580  N   GLY C  72      -6.730 -32.785   6.524  1.00 38.27           N  
ATOM   2581  CA  GLY C  72      -7.195 -31.409   6.676  1.00 37.45           C  
ATOM   2582  C   GLY C  72      -6.040 -30.505   7.071  1.00 36.85           C  
ATOM   2583  O   GLY C  72      -5.032 -30.971   7.626  1.00 36.81           O  
ATOM   2584  N   PHE C  73      -6.172 -29.212   6.786  1.00 36.02           N  
ATOM   2585  CA  PHE C  73      -5.159 -28.256   7.197  1.00 35.70           C  
ATOM   2586  C   PHE C  73      -5.755 -27.189   8.086  1.00 35.05           C  
ATOM   2587  O   PHE C  73      -6.870 -26.753   7.856  1.00 34.92           O  
ATOM   2588  CB  PHE C  73      -4.487 -27.586   5.976  1.00 36.13           C  
ATOM   2589  CG  PHE C  73      -4.161 -28.540   4.843  1.00 37.57           C  
ATOM   2590  CD1 PHE C  73      -3.231 -29.553   5.014  1.00 39.26           C  
ATOM   2591  CD2 PHE C  73      -4.771 -28.394   3.594  1.00 40.13           C  
ATOM   2592  CE1 PHE C  73      -2.922 -30.421   3.970  1.00 40.92           C  
ATOM   2593  CE2 PHE C  73      -4.474 -29.264   2.534  1.00 40.35           C  
ATOM   2594  CZ  PHE C  73      -3.549 -30.277   2.726  1.00 40.15           C  
ATOM   2595  N   GLU C  74      -5.002 -26.785   9.103  1.00 34.96           N  
ATOM   2596  CA  GLU C  74      -5.285 -25.552   9.824  1.00 36.10           C  
ATOM   2597  C   GLU C  74      -4.083 -24.604   9.757  1.00 35.36           C  
ATOM   2598  O   GLU C  74      -2.910 -25.033   9.707  1.00 35.25           O  
ATOM   2599  CB  GLU C  74      -5.738 -25.815  11.258  1.00 36.34           C  
ATOM   2600  CG  GLU C  74      -7.167 -26.390  11.337  1.00 39.00           C  
ATOM   2601  CD  GLU C  74      -7.586 -26.797  12.742  1.00 42.62           C  
ATOM   2602  OE1 GLU C  74      -6.977 -26.324  13.735  1.00 46.05           O  
ATOM   2603  OE2 GLU C  74      -8.543 -27.593  12.869  1.00 46.10           O  
ATOM   2604  N   VAL C  75      -4.381 -23.311   9.703  1.00 34.90           N  
ATOM   2605  CA  VAL C  75      -3.346 -22.310   9.599  1.00 33.99           C  
ATOM   2606  C   VAL C  75      -3.730 -21.157  10.489  1.00 34.04           C  
ATOM   2607  O   VAL C  75      -4.826 -20.629  10.424  1.00 34.49           O  
ATOM   2608  CB  VAL C  75      -3.123 -21.814   8.149  1.00 34.08           C  
ATOM   2609  CG1 VAL C  75      -1.982 -20.783   8.109  1.00 33.49           C  
ATOM   2610  CG2 VAL C  75      -2.801 -22.995   7.203  1.00 33.80           C  
ATOM   2611  N   LYS C  76      -2.817 -20.792  11.362  1.00 33.63           N  
ATOM   2612  CA  LYS C  76      -3.009 -19.647  12.183  1.00 33.58           C  
ATOM   2613  C   LYS C  76      -1.789 -18.764  11.930  1.00 32.79           C  
ATOM   2614  O   LYS C  76      -0.646 -19.184  12.157  1.00 32.15           O  
ATOM   2615  CB  LYS C  76      -3.156 -20.116  13.624  1.00 34.15           C  
ATOM   2616  CG  LYS C  76      -3.057 -19.068  14.672  1.00 36.83           C  
ATOM   2617  CD  LYS C  76      -4.148 -18.095  14.629  1.00 41.24           C  
ATOM   2618  CE  LYS C  76      -4.301 -17.461  16.017  1.00 44.86           C  
ATOM   2619  NZ  LYS C  76      -4.425 -16.011  16.001  1.00 45.79           N  
ATOM   2620  N   ILE C  77      -2.039 -17.567  11.393  1.00 32.22           N  
ATOM   2621  CA  ILE C  77      -0.969 -16.619  11.088  1.00 31.30           C  
ATOM   2622  C   ILE C  77      -0.810 -15.695  12.287  1.00 31.60           C  
ATOM   2623  O   ILE C  77      -1.750 -15.006  12.652  1.00 32.29           O  
ATOM   2624  CB  ILE C  77      -1.288 -15.791   9.791  1.00 31.69           C  
ATOM   2625  CG1 ILE C  77      -1.660 -16.719   8.614  1.00 30.31           C  
ATOM   2626  CG2 ILE C  77      -0.100 -14.854   9.447  1.00 30.99           C  
ATOM   2627  CD1 ILE C  77      -2.244 -15.986   7.364  1.00 30.79           C  
ATOM   2628  N   HIS C  78       0.364 -15.700  12.907  1.00 31.26           N  
ATOM   2629  CA  HIS C  78       0.651 -14.815  14.044  1.00 31.95           C  
ATOM   2630  C   HIS C  78       1.136 -13.433  13.606  1.00 32.31           C  
ATOM   2631  O   HIS C  78       0.766 -12.422  14.200  1.00 33.30           O  
ATOM   2632  CB  HIS C  78       1.683 -15.454  14.979  1.00 32.08           C  
ATOM   2633  CG  HIS C  78       1.336 -16.854  15.395  1.00 32.96           C  
ATOM   2634  ND1 HIS C  78       0.296 -17.145  16.261  1.00 33.28           N  
ATOM   2635  CD2 HIS C  78       1.893 -18.046  15.065  1.00 31.58           C  
ATOM   2636  CE1 HIS C  78       0.218 -18.453  16.430  1.00 32.93           C  
ATOM   2637  NE2 HIS C  78       1.173 -19.023  15.713  1.00 32.35           N  
ATOM   2638  N   ARG C  79       1.981 -13.409  12.578  1.00 31.40           N  
ATOM   2639  CA  ARG C  79       2.533 -12.183  12.014  1.00 31.66           C  
ATOM   2640  C   ARG C  79       2.730 -12.405  10.527  1.00 31.06           C  
ATOM   2641  O   ARG C  79       3.029 -13.533  10.102  1.00 29.72           O  
ATOM   2642  CB  ARG C  79       3.872 -11.826  12.661  1.00 31.75           C  
ATOM   2643  CG  ARG C  79       3.790 -11.499  14.175  1.00 33.25           C  
ATOM   2644  CD  ARG C  79       5.185 -11.335  14.740  1.00 34.78           C  
ATOM   2645  NE  ARG C  79       5.241 -10.900  16.144  1.00 36.72           N  
ATOM   2646  CZ  ARG C  79       5.125 -11.726  17.180  1.00 37.48           C  
ATOM   2647  NH1 ARG C  79       4.909 -12.935  16.984  1.00 35.42           N  
ATOM   2648  NH2 ARG C  79       5.198 -11.405  18.425  1.00 38.79           N  
ATOM   2649  N   ILE C  80       2.536 -11.330   9.762  1.00 31.56           N  
ATOM   2650  CA  ILE C  80       2.659 -11.327   8.318  1.00 31.31           C  
ATOM   2651  C   ILE C  80       3.078  -9.926   7.881  1.00 32.93           C  
ATOM   2652  O   ILE C  80       2.573  -8.955   8.399  1.00 34.21           O  
ATOM   2653  CB  ILE C  80       1.324 -11.775   7.631  1.00 31.49           C  
ATOM   2654  CG1 ILE C  80       1.470 -11.759   6.096  1.00 30.59           C  
ATOM   2655  CG2 ILE C  80       0.102 -10.949   8.155  1.00 29.35           C  
ATOM   2656  CD1 ILE C  80       0.381 -12.525   5.354  1.00 30.58           C  
ATOM   2657  N   GLY C  81       4.004  -9.830   6.935  1.00 33.47           N  
ATOM   2658  CA  GLY C  81       4.501  -8.536   6.461  1.00 34.37           C  
ATOM   2659  C   GLY C  81       5.084  -8.699   5.083  1.00 34.48           C  
ATOM   2660  O   GLY C  81       5.320  -9.816   4.650  1.00 34.62           O  
ATOM   2661  N   ALA C  82       5.316  -7.597   4.388  1.00 35.92           N  
ATOM   2662  CA  ALA C  82       5.689  -7.645   2.987  1.00 36.84           C  
ATOM   2663  C   ALA C  82       6.953  -6.872   2.712  1.00 38.27           C  
ATOM   2664  O   ALA C  82       7.286  -5.937   3.414  1.00 38.92           O  
ATOM   2665  CB  ALA C  82       4.574  -7.108   2.138  1.00 37.64           C  
ATOM   2666  N   ASP C  83       7.649  -7.287   1.672  1.00 39.73           N  
ATOM   2667  CA  ASP C  83       8.873  -6.643   1.200  1.00 41.91           C  
ATOM   2668  C   ASP C  83       8.710  -6.596  -0.315  1.00 42.63           C  
ATOM   2669  O   ASP C  83       9.088  -7.540  -1.020  1.00 42.22           O  
ATOM   2670  CB  ASP C  83      10.051  -7.524   1.633  1.00 41.56           C  
ATOM   2671  CG  ASP C  83      11.404  -7.078   1.097  1.00 44.53           C  
ATOM   2672  OD1 ASP C  83      11.528  -6.060   0.374  1.00 48.31           O  
ATOM   2673  OD2 ASP C  83      12.371  -7.802   1.426  1.00 46.20           O  
ATOM   2674  N   GLY C  84       8.096  -5.518  -0.794  1.00 43.76           N  
ATOM   2675  CA  GLY C  84       7.726  -5.403  -2.184  1.00 45.02           C  
ATOM   2676  C   GLY C  84       6.759  -6.515  -2.543  1.00 44.04           C  
ATOM   2677  O   GLY C  84       5.699  -6.616  -1.935  1.00 43.89           O  
ATOM   2678  N   ALA C  85       7.137  -7.347  -3.520  1.00 43.30           N  
ATOM   2679  CA  ALA C  85       6.315  -8.474  -3.931  1.00 41.90           C  
ATOM   2680  C   ALA C  85       6.463  -9.686  -2.975  1.00 39.44           C  
ATOM   2681  O   ALA C  85       5.649 -10.592  -3.007  1.00 38.71           O  
ATOM   2682  CB  ALA C  85       6.638  -8.870  -5.380  1.00 42.68           C  
ATOM   2683  N   ALA C  86       7.504  -9.705  -2.147  1.00 37.74           N  
ATOM   2684  CA  ALA C  86       7.663 -10.790  -1.166  1.00 35.45           C  
ATOM   2685  C   ALA C  86       6.796 -10.611   0.116  1.00 33.82           C  
ATOM   2686  O   ALA C  86       6.650  -9.500   0.627  1.00 33.91           O  
ATOM   2687  CB  ALA C  86       9.124 -10.972  -0.799  1.00 34.56           C  
ATOM   2688  N   VAL C  87       6.255 -11.724   0.612  1.00 31.63           N  
ATOM   2689  CA  VAL C  87       5.421 -11.759   1.802  1.00 30.21           C  
ATOM   2690  C   VAL C  87       6.009 -12.815   2.752  1.00 29.40           C  
ATOM   2691  O   VAL C  87       6.351 -13.939   2.329  1.00 28.51           O  
ATOM   2692  CB  VAL C  87       3.926 -12.090   1.447  1.00 30.11           C  
ATOM   2693  CG1 VAL C  87       3.072 -12.286   2.699  1.00 28.84           C  
ATOM   2694  CG2 VAL C  87       3.319 -11.002   0.532  1.00 30.20           C  
ATOM   2695  N   LEU C  88       6.153 -12.433   4.025  1.00 29.04           N  
ATOM   2696  CA  LEU C  88       6.684 -13.321   5.063  1.00 28.64           C  
ATOM   2697  C   LEU C  88       5.625 -13.599   6.108  1.00 28.51           C  
ATOM   2698  O   LEU C  88       4.816 -12.731   6.435  1.00 28.89           O  
ATOM   2699  CB  LEU C  88       7.939 -12.751   5.748  1.00 28.60           C  
ATOM   2700  CG  LEU C  88       9.122 -12.385   4.845  1.00 30.55           C  
ATOM   2701  CD1 LEU C  88       9.050 -10.909   4.572  1.00 31.18           C  
ATOM   2702  CD2 LEU C  88      10.472 -12.737   5.453  1.00 31.36           C  
ATOM   2703  N   THR C  89       5.692 -14.782   6.701  1.00 28.08           N  
ATOM   2704  CA  THR C  89       4.594 -15.288   7.457  1.00 27.72           C  
ATOM   2705  C   THR C  89       5.129 -16.095   8.667  1.00 27.31           C  
ATOM   2706  O   THR C  89       6.041 -16.904   8.526  1.00 27.50           O  
ATOM   2707  CB  THR C  89       3.770 -16.051   6.387  1.00 28.41           C  
ATOM   2708  OG1 THR C  89       2.402 -15.791   6.443  1.00 29.87           O  
ATOM   2709  CG2 THR C  89       3.856 -17.368   6.404  1.00 25.49           C  
ATOM   2710  N   GLU C  90       4.632 -15.802   9.871  1.00 27.11           N  
ATOM   2711  CA  GLU C  90       4.941 -16.604  11.065  1.00 26.59           C  
ATOM   2712  C   GLU C  90       3.647 -17.294  11.463  1.00 26.30           C  
ATOM   2713  O   GLU C  90       2.659 -16.621  11.780  1.00 27.06           O  
ATOM   2714  CB  GLU C  90       5.474 -15.741  12.222  1.00 27.25           C  
ATOM   2715  CG  GLU C  90       5.881 -16.554  13.466  1.00 27.19           C  
ATOM   2716  CD  GLU C  90       5.986 -15.737  14.778  1.00 29.04           C  
ATOM   2717  OE1 GLU C  90       5.369 -14.655  14.916  1.00 30.78           O  
ATOM   2718  OE2 GLU C  90       6.682 -16.197  15.704  1.00 29.10           O  
ATOM   2719  N   ARG C  91       3.627 -18.621  11.402  1.00 25.60           N  
ATOM   2720  CA  ARG C  91       2.390 -19.371  11.581  1.00 25.89           C  
ATOM   2721  C   ARG C  91       2.528 -20.566  12.510  1.00 26.57           C  
ATOM   2722  O   ARG C  91       3.630 -21.020  12.837  1.00 27.14           O  
ATOM   2723  CB  ARG C  91       1.810 -19.880  10.231  1.00 25.27           C  
ATOM   2724  CG  ARG C  91       2.321 -19.201   8.998  1.00 25.21           C  
ATOM   2725  CD  ARG C  91       1.491 -19.486   7.780  1.00 24.77           C  
ATOM   2726  NE  ARG C  91       1.556 -20.855   7.284  1.00 23.31           N  
ATOM   2727  CZ  ARG C  91       2.298 -21.268   6.248  1.00 25.21           C  
ATOM   2728  NH1 ARG C  91       3.093 -20.420   5.582  1.00 23.06           N  
ATOM   2729  NH2 ARG C  91       2.241 -22.560   5.852  1.00 22.30           N  
ATOM   2730  N   THR C  92       1.371 -21.063  12.932  1.00 27.25           N  
ATOM   2731  CA  THR C  92       1.219 -22.406  13.455  1.00 27.85           C  
ATOM   2732  C   THR C  92       0.313 -23.136  12.465  1.00 27.62           C  
ATOM   2733  O   THR C  92      -0.761 -22.652  12.114  1.00 27.68           O  
ATOM   2734  CB  THR C  92       0.582 -22.405  14.852  1.00 28.67           C  
ATOM   2735  OG1 THR C  92       1.375 -21.604  15.748  1.00 30.79           O  
ATOM   2736  CG2 THR C  92       0.528 -23.802  15.403  1.00 28.48           C  
ATOM   2737  N   ASP C  93       0.774 -24.283  11.984  1.00 27.26           N  
ATOM   2738  CA  ASP C  93      -0.014 -25.108  11.078  1.00 27.44           C  
ATOM   2739  C   ASP C  93      -0.413 -26.383  11.815  1.00 27.60           C  
ATOM   2740  O   ASP C  93       0.199 -26.751  12.815  1.00 27.74           O  
ATOM   2741  CB  ASP C  93       0.806 -25.465   9.819  1.00 27.07           C  
ATOM   2742  CG  ASP C  93       0.893 -24.311   8.796  1.00 29.84           C  
ATOM   2743  OD1 ASP C  93       1.166 -24.609   7.613  1.00 31.90           O  
ATOM   2744  OD2 ASP C  93       0.700 -23.117   9.151  1.00 32.09           O  
ATOM   2745  N   ALA C  94      -1.422 -27.065  11.306  1.00 28.29           N  
ATOM   2746  CA  ALA C  94      -1.775 -28.388  11.785  1.00 29.56           C  
ATOM   2747  C   ALA C  94      -2.186 -29.262  10.611  1.00 30.26           C  
ATOM   2748  O   ALA C  94      -2.919 -28.805   9.741  1.00 29.67           O  
ATOM   2749  CB  ALA C  94      -2.902 -28.289  12.796  1.00 29.66           C  
ATOM   2750  N   LEU C  95      -1.690 -30.501  10.578  1.00 31.55           N  
ATOM   2751  CA  LEU C  95      -2.205 -31.507   9.645  1.00 33.05           C  
ATOM   2752  C   LEU C  95      -3.082 -32.467  10.436  1.00 34.42           C  
ATOM   2753  O   LEU C  95      -2.705 -32.902  11.528  1.00 35.89           O  
ATOM   2754  CB  LEU C  95      -1.087 -32.251   8.898  1.00 33.37           C  
ATOM   2755  CG  LEU C  95      -0.026 -31.406   8.152  1.00 34.57           C  
ATOM   2756  CD1 LEU C  95       1.080 -32.322   7.626  1.00 35.58           C  
ATOM   2757  CD2 LEU C  95      -0.592 -30.536   7.026  1.00 33.39           C  
ATOM   2758  N   ILE C  96      -4.262 -32.766   9.897  1.00 34.65           N  
ATOM   2759  CA  ILE C  96      -5.251 -33.607  10.560  1.00 35.61           C  
ATOM   2760  C   ILE C  96      -5.530 -34.782   9.667  1.00 36.68           C  
ATOM   2761  O   ILE C  96      -5.933 -34.598   8.528  1.00 36.95           O  
ATOM   2762  CB  ILE C  96      -6.624 -32.882  10.738  1.00 35.84           C  
ATOM   2763  CG1 ILE C  96      -6.443 -31.354  10.902  1.00 35.32           C  
ATOM   2764  CG2 ILE C  96      -7.490 -33.590  11.756  1.00 34.26           C  
ATOM   2765  CD1 ILE C  96      -6.588 -30.731  12.176  1.00 37.35           C  
ATOM   2766  N   ILE C  97      -5.325 -35.986  10.191  1.00 37.93           N  
ATOM   2767  CA  ILE C  97      -5.617 -37.223   9.489  1.00 38.85           C  
ATOM   2768  C   ILE C  97      -6.488 -38.014  10.450  1.00 40.19           C  
ATOM   2769  O   ILE C  97      -5.995 -38.573  11.444  1.00 40.90           O  
ATOM   2770  CB  ILE C  97      -4.316 -37.990   9.140  1.00 39.66           C  
ATOM   2771  CG1 ILE C  97      -3.389 -37.108   8.296  1.00 38.83           C  
ATOM   2772  CG2 ILE C  97      -4.618 -39.298   8.385  1.00 40.26           C  
ATOM   2773  CD1 ILE C  97      -1.944 -37.302   8.588  1.00 39.72           C  
ATOM   2774  N   GLY C  98      -7.795 -38.027  10.168  1.00 40.28           N  
ATOM   2775  CA  GLY C  98      -8.792 -38.540  11.093  1.00 40.83           C  
ATOM   2776  C   GLY C  98      -8.639 -37.916  12.475  1.00 41.15           C  
ATOM   2777  O   GLY C  98      -8.676 -36.675  12.611  1.00 40.11           O  
ATOM   2778  N   PRO C  99      -8.429 -38.766  13.516  1.00 42.18           N  
ATOM   2779  CA  PRO C  99      -8.361 -38.261  14.897  1.00 41.97           C  
ATOM   2780  C   PRO C  99      -6.954 -37.824  15.283  1.00 41.11           C  
ATOM   2781  O   PRO C  99      -6.768 -37.282  16.370  1.00 41.40           O  
ATOM   2782  CB  PRO C  99      -8.778 -39.469  15.737  1.00 43.60           C  
ATOM   2783  CG  PRO C  99      -8.312 -40.690  14.906  1.00 44.44           C  
ATOM   2784  CD  PRO C  99      -8.239 -40.237  13.445  1.00 43.39           C  
ATOM   2785  N   LEU C 100      -5.980 -38.069  14.406  1.00 39.95           N  
ATOM   2786  CA  LEU C 100      -4.604 -37.624  14.621  1.00 38.95           C  
ATOM   2787  C   LEU C 100      -4.396 -36.167  14.183  1.00 37.68           C  
ATOM   2788  O   LEU C 100      -4.624 -35.816  13.020  1.00 37.20           O  
ATOM   2789  CB  LEU C 100      -3.629 -38.547  13.878  1.00 38.81           C  
ATOM   2790  CG  LEU C 100      -2.144 -38.168  13.935  1.00 39.06           C  
ATOM   2791  CD1 LEU C 100      -1.606 -38.186  15.400  1.00 38.52           C  
ATOM   2792  CD2 LEU C 100      -1.287 -39.040  12.983  1.00 38.33           C  
ATOM   2793  N   ARG C 101      -3.964 -35.322  15.116  1.00 37.35           N  
ATOM   2794  CA  ARG C 101      -3.667 -33.932  14.807  1.00 36.08           C  
ATOM   2795  C   ARG C 101      -2.215 -33.624  15.117  1.00 35.45           C  
ATOM   2796  O   ARG C 101      -1.757 -33.843  16.243  1.00 36.30           O  
ATOM   2797  CB  ARG C 101      -4.584 -33.008  15.599  1.00 36.83           C  
ATOM   2798  CG  ARG C 101      -4.200 -31.542  15.548  1.00 36.45           C  
ATOM   2799  CD  ARG C 101      -5.046 -30.775  16.536  1.00 39.93           C  
ATOM   2800  NE  ARG C 101      -4.853 -29.352  16.338  1.00 41.00           N  
ATOM   2801  CZ  ARG C 101      -5.626 -28.608  15.562  1.00 41.67           C  
ATOM   2802  NH1 ARG C 101      -6.661 -29.163  14.950  1.00 41.95           N  
ATOM   2803  NH2 ARG C 101      -5.357 -27.311  15.390  1.00 40.24           N  
ATOM   2804  N   VAL C 102      -1.490 -33.148  14.108  1.00 33.71           N  
ATOM   2805  CA  VAL C 102      -0.071 -32.850  14.244  1.00 33.03           C  
ATOM   2806  C   VAL C 102       0.168 -31.362  14.003  1.00 32.11           C  
ATOM   2807  O   VAL C 102      -0.026 -30.847  12.901  1.00 31.06           O  
ATOM   2808  CB  VAL C 102       0.803 -33.685  13.259  1.00 33.55           C  
ATOM   2809  CG1 VAL C 102       2.290 -33.355  13.430  1.00 31.12           C  
ATOM   2810  CG2 VAL C 102       0.549 -35.191  13.433  1.00 34.08           C  
ATOM   2811  N   GLN C 103       0.614 -30.687  15.045  1.00 32.12           N  
ATOM   2812  CA  GLN C 103       0.717 -29.246  15.038  1.00 31.88           C  
ATOM   2813  C   GLN C 103       2.172 -28.812  15.204  1.00 31.35           C  
ATOM   2814  O   GLN C 103       2.911 -29.384  16.016  1.00 32.80           O  
ATOM   2815  CB  GLN C 103      -0.145 -28.701  16.176  1.00 32.57           C  
ATOM   2816  CG  GLN C 103      -0.446 -27.229  16.115  1.00 33.73           C  
ATOM   2817  CD  GLN C 103      -1.617 -26.875  17.023  1.00 36.08           C  
ATOM   2818  OE1 GLN C 103      -2.700 -27.343  16.826  1.00 34.99           O  
ATOM   2819  NE2 GLN C 103      -1.389 -26.076  18.014  1.00 34.27           N  
ATOM   2820  N   PHE C 104       2.571 -27.791  14.460  1.00 29.64           N  
ATOM   2821  CA  PHE C 104       3.974 -27.398  14.376  1.00 29.03           C  
ATOM   2822  C   PHE C 104       4.056 -25.949  13.881  1.00 28.37           C  
ATOM   2823  O   PHE C 104       3.117 -25.470  13.210  1.00 28.54           O  
ATOM   2824  CB  PHE C 104       4.748 -28.338  13.412  1.00 28.52           C  
ATOM   2825  CG  PHE C 104       4.079 -28.518  12.056  1.00 27.82           C  
ATOM   2826  CD1 PHE C 104       4.453 -27.740  10.978  1.00 27.91           C  
ATOM   2827  CD2 PHE C 104       3.079 -29.478  11.864  1.00 27.97           C  
ATOM   2828  CE1 PHE C 104       3.844 -27.911   9.716  1.00 28.70           C  
ATOM   2829  CE2 PHE C 104       2.456 -29.633  10.626  1.00 27.18           C  
ATOM   2830  CZ  PHE C 104       2.836 -28.847   9.551  1.00 27.41           C  
ATOM   2831  N   TRP C 105       5.160 -25.260  14.173  1.00 27.25           N  
ATOM   2832  CA  TRP C 105       5.333 -23.937  13.626  1.00 26.70           C  
ATOM   2833  C   TRP C 105       5.799 -24.003  12.164  1.00 26.43           C  
ATOM   2834  O   TRP C 105       6.482 -24.958  11.758  1.00 25.87           O  
ATOM   2835  CB  TRP C 105       6.270 -23.108  14.494  1.00 26.78           C  
ATOM   2836  CG  TRP C 105       7.745 -23.602  14.609  1.00 28.05           C  
ATOM   2837  CD1 TRP C 105       8.326 -24.195  15.707  1.00 28.27           C  
ATOM   2838  CD2 TRP C 105       8.802 -23.475  13.626  1.00 27.27           C  
ATOM   2839  NE1 TRP C 105       9.659 -24.456  15.468  1.00 28.34           N  
ATOM   2840  CE2 TRP C 105       9.981 -24.018  14.208  1.00 27.82           C  
ATOM   2841  CE3 TRP C 105       8.876 -22.929  12.333  1.00 27.30           C  
ATOM   2842  CZ2 TRP C 105      11.207 -24.063  13.528  1.00 26.63           C  
ATOM   2843  CZ3 TRP C 105      10.118 -22.962  11.657  1.00 26.35           C  
ATOM   2844  CH2 TRP C 105      11.252 -23.543  12.261  1.00 26.91           C  
ATOM   2845  N   VAL C 106       5.391 -23.001  11.381  1.00 26.07           N  
ATOM   2846  CA  VAL C 106       5.894 -22.801  10.020  1.00 25.44           C  
ATOM   2847  C   VAL C 106       6.150 -21.312   9.795  1.00 25.77           C  
ATOM   2848  O   VAL C 106       5.338 -20.454  10.195  1.00 25.41           O  
ATOM   2849  CB  VAL C 106       4.892 -23.238   8.947  1.00 24.92           C  
ATOM   2850  CG1 VAL C 106       5.501 -23.044   7.549  1.00 24.89           C  
ATOM   2851  CG2 VAL C 106       4.474 -24.679   9.151  1.00 24.62           C  
ATOM   2852  N   CYS C 107       7.283 -21.025   9.160  1.00 25.75           N  
ATOM   2853  CA  CYS C 107       7.532 -19.724   8.571  1.00 26.46           C  
ATOM   2854  C   CYS C 107       7.442 -19.896   7.040  1.00 26.76           C  
ATOM   2855  O   CYS C 107       8.150 -20.703   6.456  1.00 27.16           O  
ATOM   2856  CB  CYS C 107       8.891 -19.168   9.032  1.00 26.64           C  
ATOM   2857  SG  CYS C 107       8.891 -18.736  10.851  1.00 28.38           S  
ATOM   2858  N   GLY C 108       6.536 -19.167   6.405  1.00 26.52           N  
ATOM   2859  CA  GLY C 108       6.392 -19.239   4.974  1.00 27.50           C  
ATOM   2860  C   GLY C 108       6.806 -17.948   4.328  1.00 28.45           C  
ATOM   2861  O   GLY C 108       6.512 -16.855   4.848  1.00 29.29           O  
ATOM   2862  N   VAL C 109       7.510 -18.067   3.210  1.00 28.84           N  
ATOM   2863  CA  VAL C 109       7.788 -16.910   2.371  1.00 29.70           C  
ATOM   2864  C   VAL C 109       7.131 -17.108   0.998  1.00 30.10           C  
ATOM   2865  O   VAL C 109       7.186 -18.186   0.391  1.00 29.26           O  
ATOM   2866  CB  VAL C 109       9.300 -16.532   2.256  1.00 30.41           C  
ATOM   2867  CG1 VAL C 109      10.079 -16.802   3.547  1.00 29.55           C  
ATOM   2868  CG2 VAL C 109       9.942 -17.246   1.136  1.00 32.77           C  
ATOM   2869  N   PHE C 110       6.474 -16.048   0.539  1.00 31.06           N  
ATOM   2870  CA  PHE C 110       5.754 -16.070  -0.725  1.00 31.84           C  
ATOM   2871  C   PHE C 110       6.257 -14.958  -1.596  1.00 33.96           C  
ATOM   2872  O   PHE C 110       6.815 -13.971  -1.096  1.00 34.24           O  
ATOM   2873  CB  PHE C 110       4.247 -15.895  -0.488  1.00 30.07           C  
ATOM   2874  CG  PHE C 110       3.674 -16.887   0.480  1.00 28.32           C  
ATOM   2875  CD1 PHE C 110       3.916 -16.778   1.849  1.00 25.48           C  
ATOM   2876  CD2 PHE C 110       2.891 -17.944   0.025  1.00 27.00           C  
ATOM   2877  CE1 PHE C 110       3.376 -17.708   2.754  1.00 24.95           C  
ATOM   2878  CE2 PHE C 110       2.347 -18.867   0.919  1.00 26.00           C  
ATOM   2879  CZ  PHE C 110       2.581 -18.747   2.292  1.00 24.26           C  
ATOM   2880  N   GLU C 111       6.064 -15.134  -2.897  1.00 36.22           N  
ATOM   2881  CA  GLU C 111       6.144 -14.042  -3.842  1.00 39.52           C  
ATOM   2882  C   GLU C 111       4.848 -13.977  -4.624  1.00 40.23           C  
ATOM   2883  O   GLU C 111       4.334 -14.990  -5.113  1.00 40.20           O  
ATOM   2884  CB  GLU C 111       7.345 -14.202  -4.783  1.00 41.03           C  
ATOM   2885  CG  GLU C 111       8.474 -13.272  -4.424  1.00 45.56           C  
ATOM   2886  CD  GLU C 111       9.805 -13.774  -4.910  1.00 52.01           C  
ATOM   2887  OE1 GLU C 111       9.860 -14.315  -6.032  1.00 55.28           O  
ATOM   2888  OE2 GLU C 111      10.809 -13.631  -4.175  1.00 53.52           O  
ATOM   2889  N   VAL C 112       4.303 -12.777  -4.724  1.00 41.58           N  
ATOM   2890  CA  VAL C 112       3.082 -12.597  -5.481  1.00 42.95           C  
ATOM   2891  C   VAL C 112       3.242 -11.575  -6.600  1.00 45.71           C  
ATOM   2892  O   VAL C 112       3.831 -10.510  -6.432  1.00 46.50           O  
ATOM   2893  CB  VAL C 112       1.781 -12.428  -4.575  1.00 42.15           C  
ATOM   2894  CG1 VAL C 112       2.096 -12.457  -3.075  1.00 39.43           C  
ATOM   2895  CG2 VAL C 112       0.955 -11.222  -4.969  1.00 43.31           C  
ATOM   2896  N   ASP C 113       2.739 -11.959  -7.760  1.00 47.94           N  
ATOM   2897  CA  ASP C 113       2.847 -11.182  -8.969  1.00 51.26           C  
ATOM   2898  C   ASP C 113       1.430 -11.106  -9.499  1.00 52.26           C  
ATOM   2899  O   ASP C 113       0.855 -12.121  -9.903  1.00 52.03           O  
ATOM   2900  CB  ASP C 113       3.785 -11.897  -9.956  1.00 52.40           C  
ATOM   2901  CG  ASP C 113       3.815 -11.247 -11.346  1.00 57.88           C  
ATOM   2902  OD1 ASP C 113       3.685 -10.004 -11.452  1.00 63.34           O  
ATOM   2903  OD2 ASP C 113       4.003 -11.972 -12.353  1.00 61.19           O  
ATOM   2904  N   ASP C 114       0.842  -9.910  -9.434  1.00 53.67           N  
ATOM   2905  CA  ASP C 114      -0.414  -9.657 -10.120  1.00 54.98           C  
ATOM   2906  C   ASP C 114      -1.526 -10.476  -9.450  1.00 53.24           C  
ATOM   2907  O   ASP C 114      -2.313 -11.164 -10.117  1.00 53.71           O  
ATOM   2908  CB  ASP C 114      -0.223 -10.059 -11.588  1.00 56.89           C  
ATOM   2909  CG  ASP C 114      -0.697  -9.014 -12.517  1.00 61.27           C  
ATOM   2910  OD1 ASP C 114      -1.878  -9.012 -12.711  1.00 63.45           O  
ATOM   2911  OD2 ASP C 114       0.039  -8.169 -13.074  1.00 63.66           O  
ATOM   2912  N   GLY C 115      -1.561 -10.429  -8.121  1.00 51.08           N  
ATOM   2913  CA  GLY C 115      -2.524 -11.215  -7.352  1.00 49.08           C  
ATOM   2914  C   GLY C 115      -2.283 -12.720  -7.331  1.00 47.39           C  
ATOM   2915  O   GLY C 115      -2.960 -13.439  -6.600  1.00 46.39           O  
ATOM   2916  N   ARG C 116      -1.316 -13.205  -8.112  1.00 46.82           N  
ATOM   2917  CA  ARG C 116      -1.012 -14.640  -8.116  1.00 44.95           C  
ATOM   2918  C   ARG C 116       0.296 -15.004  -7.425  1.00 42.54           C  
ATOM   2919  O   ARG C 116       1.296 -14.287  -7.535  1.00 42.81           O  
ATOM   2920  CB  ARG C 116      -1.118 -15.230  -9.529  1.00 46.49           C  
ATOM   2921  CG  ARG C 116      -2.491 -14.894 -10.097  1.00 48.89           C  
ATOM   2922  CD  ARG C 116      -3.012 -15.780 -11.173  1.00 51.90           C  
ATOM   2923  NE  ARG C 116      -3.306 -17.167 -10.793  1.00 54.59           N  
ATOM   2924  CZ  ARG C 116      -3.828 -18.059 -11.645  1.00 56.84           C  
ATOM   2925  NH1 ARG C 116      -4.099 -17.690 -12.855  1.00 58.57           N  
ATOM   2926  NH2 ARG C 116      -4.094 -19.308 -11.336  1.00 55.19           N  
ATOM   2927  N   ILE C 117       0.266 -16.122  -6.703  1.00 39.54           N  
ATOM   2928  CA  ILE C 117       1.417 -16.605  -5.970  1.00 36.76           C  
ATOM   2929  C   ILE C 117       2.348 -17.383  -6.892  1.00 36.96           C  
ATOM   2930  O   ILE C 117       1.970 -18.399  -7.473  1.00 36.79           O  
ATOM   2931  CB  ILE C 117       0.983 -17.454  -4.752  1.00 35.44           C  
ATOM   2932  CG1 ILE C 117       0.215 -16.568  -3.757  1.00 34.02           C  
ATOM   2933  CG2 ILE C 117       2.207 -18.178  -4.110  1.00 33.76           C  
ATOM   2934  CD1 ILE C 117      -0.493 -17.316  -2.623  1.00 33.03           C  
ATOM   2935  N   THR C 118       3.580 -16.884  -7.015  1.00 36.72           N  
ATOM   2936  CA  THR C 118       4.597 -17.505  -7.872  1.00 36.84           C  
ATOM   2937  C   THR C 118       5.646 -18.292  -7.089  1.00 35.27           C  
ATOM   2938  O   THR C 118       6.277 -19.197  -7.639  1.00 35.47           O  
ATOM   2939  CB  THR C 118       5.258 -16.476  -8.809  1.00 38.35           C  
ATOM   2940  OG1 THR C 118       5.888 -15.454  -8.028  1.00 39.40           O  
ATOM   2941  CG2 THR C 118       4.197 -15.848  -9.737  1.00 38.50           C  
ATOM   2942  N   LEU C 119       5.814 -17.945  -5.809  1.00 33.35           N  
ATOM   2943  CA  LEU C 119       6.677 -18.691  -4.900  1.00 31.79           C  
ATOM   2944  C   LEU C 119       5.933 -18.981  -3.608  1.00 30.46           C  
ATOM   2945  O   LEU C 119       5.286 -18.099  -3.047  1.00 29.99           O  
ATOM   2946  CB  LEU C 119       7.984 -17.946  -4.595  1.00 31.44           C  
ATOM   2947  CG  LEU C 119       8.897 -18.603  -3.547  1.00 30.31           C  
ATOM   2948  CD1 LEU C 119       9.463 -19.960  -4.022  1.00 27.94           C  
ATOM   2949  CD2 LEU C 119      10.012 -17.670  -3.100  1.00 31.32           C  
ATOM   2950  N   TRP C 120       6.029 -20.229  -3.148  1.00 29.51           N  
ATOM   2951  CA  TRP C 120       5.476 -20.635  -1.850  1.00 27.62           C  
ATOM   2952  C   TRP C 120       6.512 -21.547  -1.201  1.00 27.31           C  
ATOM   2953  O   TRP C 120       6.744 -22.695  -1.638  1.00 27.34           O  
ATOM   2954  CB  TRP C 120       4.138 -21.332  -2.032  1.00 27.56           C  
ATOM   2955  CG  TRP C 120       3.564 -21.978  -0.810  1.00 26.39           C  
ATOM   2956  CD1 TRP C 120       3.886 -21.718   0.485  1.00 25.91           C  
ATOM   2957  CD2 TRP C 120       2.533 -22.976  -0.781  1.00 25.66           C  
ATOM   2958  NE1 TRP C 120       3.119 -22.501   1.334  1.00 26.08           N  
ATOM   2959  CE2 TRP C 120       2.288 -23.289   0.577  1.00 25.73           C  
ATOM   2960  CE3 TRP C 120       1.792 -23.641  -1.773  1.00 27.25           C  
ATOM   2961  CZ2 TRP C 120       1.322 -24.229   0.972  1.00 25.76           C  
ATOM   2962  CZ3 TRP C 120       0.836 -24.594  -1.376  1.00 26.92           C  
ATOM   2963  CH2 TRP C 120       0.613 -24.869  -0.021  1.00 25.83           C  
ATOM   2964  N   ARG C 121       7.157 -21.006  -0.175  1.00 26.34           N  
ATOM   2965  CA  ARG C 121       8.281 -21.666   0.471  1.00 26.43           C  
ATOM   2966  C   ARG C 121       8.034 -21.792   1.976  1.00 25.63           C  
ATOM   2967  O   ARG C 121       8.080 -20.806   2.723  1.00 25.13           O  
ATOM   2968  CB  ARG C 121       9.566 -20.877   0.219  1.00 26.81           C  
ATOM   2969  CG  ARG C 121      10.778 -21.631   0.687  1.00 27.72           C  
ATOM   2970  CD  ARG C 121      12.065 -20.837   0.529  1.00 28.23           C  
ATOM   2971  NE  ARG C 121      12.506 -20.742  -0.863  1.00 30.21           N  
ATOM   2972  CZ  ARG C 121      13.045 -19.638  -1.380  1.00 33.49           C  
ATOM   2973  NH1 ARG C 121      13.178 -18.541  -0.633  1.00 34.01           N  
ATOM   2974  NH2 ARG C 121      13.411 -19.599  -2.641  1.00 33.30           N  
ATOM   2975  N   ASP C 122       7.751 -23.004   2.422  1.00 25.42           N  
ATOM   2976  CA  ASP C 122       7.451 -23.196   3.843  1.00 25.11           C  
ATOM   2977  C   ASP C 122       8.658 -23.793   4.553  1.00 25.52           C  
ATOM   2978  O   ASP C 122       9.252 -24.771   4.076  1.00 25.79           O  
ATOM   2979  CB  ASP C 122       6.200 -24.066   4.023  1.00 24.55           C  
ATOM   2980  CG  ASP C 122       4.887 -23.253   3.992  1.00 26.35           C  
ATOM   2981  OD1 ASP C 122       4.896 -21.999   4.060  1.00 27.52           O  
ATOM   2982  OD2 ASP C 122       3.808 -23.873   3.912  1.00 28.42           O  
ATOM   2983  N   TYR C 123       9.002 -23.183   5.683  1.00 25.61           N  
ATOM   2984  CA  TYR C 123      10.087 -23.601   6.554  1.00 26.70           C  
ATOM   2985  C   TYR C 123       9.519 -24.196   7.845  1.00 27.57           C  
ATOM   2986  O   TYR C 123       8.607 -23.636   8.444  1.00 27.84           O  
ATOM   2987  CB  TYR C 123      10.910 -22.382   6.973  1.00 26.65           C  
ATOM   2988  CG  TYR C 123      11.759 -21.732   5.910  1.00 26.15           C  
ATOM   2989  CD1 TYR C 123      11.257 -20.681   5.135  1.00 24.34           C  
ATOM   2990  CD2 TYR C 123      13.096 -22.143   5.696  1.00 25.43           C  
ATOM   2991  CE1 TYR C 123      12.064 -20.055   4.170  1.00 25.14           C  
ATOM   2992  CE2 TYR C 123      13.902 -21.523   4.742  1.00 25.06           C  
ATOM   2993  CZ  TYR C 123      13.376 -20.485   3.993  1.00 27.11           C  
ATOM   2994  OH  TYR C 123      14.150 -19.886   3.048  1.00 29.56           O  
ATOM   2995  N   PHE C 124      10.106 -25.297   8.305  1.00 28.65           N  
ATOM   2996  CA  PHE C 124       9.744 -25.894   9.591  1.00 29.27           C  
ATOM   2997  C   PHE C 124      10.919 -26.748  10.079  1.00 30.05           C  
ATOM   2998  O   PHE C 124      11.881 -26.960   9.336  1.00 29.72           O  
ATOM   2999  CB  PHE C 124       8.481 -26.766   9.469  1.00 29.73           C  
ATOM   3000  CG  PHE C 124       8.513 -27.694   8.314  1.00 30.78           C  
ATOM   3001  CD1 PHE C 124       7.921 -27.345   7.118  1.00 33.16           C  
ATOM   3002  CD2 PHE C 124       9.152 -28.914   8.416  1.00 34.28           C  
ATOM   3003  CE1 PHE C 124       7.947 -28.207   6.037  1.00 36.00           C  
ATOM   3004  CE2 PHE C 124       9.197 -29.786   7.347  1.00 36.44           C  
ATOM   3005  CZ  PHE C 124       8.601 -29.438   6.154  1.00 35.57           C  
ATOM   3006  N   ASP C 125      10.809 -27.260  11.310  1.00 30.37           N  
ATOM   3007  CA  ASP C 125      11.875 -28.016  11.990  1.00 31.11           C  
ATOM   3008  C   ASP C 125      11.399 -29.463  12.228  1.00 31.77           C  
ATOM   3009  O   ASP C 125      10.295 -29.680  12.722  1.00 31.39           O  
ATOM   3010  CB  ASP C 125      12.196 -27.264  13.288  1.00 31.25           C  
ATOM   3011  CG  ASP C 125      12.980 -28.070  14.309  1.00 33.16           C  
ATOM   3012  OD1 ASP C 125      13.845 -28.895  13.955  1.00 33.35           O  
ATOM   3013  OD2 ASP C 125      12.765 -27.823  15.523  1.00 34.72           O  
ATOM   3014  N   VAL C 126      12.221 -30.451  11.865  1.00 32.61           N  
ATOM   3015  CA  VAL C 126      11.807 -31.849  12.042  1.00 33.67           C  
ATOM   3016  C   VAL C 126      11.643 -32.159  13.516  1.00 34.21           C  
ATOM   3017  O   VAL C 126      10.795 -32.959  13.889  1.00 34.72           O  
ATOM   3018  CB  VAL C 126      12.759 -32.909  11.373  1.00 34.76           C  
ATOM   3019  CG1 VAL C 126      12.954 -32.614   9.891  1.00 33.84           C  
ATOM   3020  CG2 VAL C 126      14.096 -32.948  12.070  1.00 36.41           C  
ATOM   3021  N   TYR C 127      12.446 -31.522  14.355  1.00 34.55           N  
ATOM   3022  CA  TYR C 127      12.330 -31.754  15.784  1.00 36.14           C  
ATOM   3023  C   TYR C 127      10.957 -31.311  16.357  1.00 35.02           C  
ATOM   3024  O   TYR C 127      10.253 -32.086  17.027  1.00 34.80           O  
ATOM   3025  CB  TYR C 127      13.494 -31.084  16.485  1.00 37.98           C  
ATOM   3026  CG  TYR C 127      13.440 -31.078  17.985  1.00 40.44           C  
ATOM   3027  CD1 TYR C 127      13.478 -32.262  18.721  1.00 42.37           C  
ATOM   3028  CD2 TYR C 127      13.384 -29.871  18.672  1.00 42.36           C  
ATOM   3029  CE1 TYR C 127      13.444 -32.242  20.115  1.00 44.29           C  
ATOM   3030  CE2 TYR C 127      13.365 -29.831  20.063  1.00 44.40           C  
ATOM   3031  CZ  TYR C 127      13.387 -31.023  20.775  1.00 45.18           C  
ATOM   3032  OH  TYR C 127      13.359 -30.982  22.147  1.00 47.55           O  
ATOM   3033  N   ASP C 128      10.588 -30.066  16.060  1.00 33.40           N  
ATOM   3034  CA  ASP C 128       9.299 -29.516  16.411  1.00 32.90           C  
ATOM   3035  C   ASP C 128       8.180 -30.375  15.851  1.00 33.02           C  
ATOM   3036  O   ASP C 128       7.191 -30.595  16.528  1.00 33.54           O  
ATOM   3037  CB  ASP C 128       9.188 -28.083  15.883  1.00 31.91           C  
ATOM   3038  CG  ASP C 128       7.865 -27.448  16.214  1.00 30.83           C  
ATOM   3039  OD1 ASP C 128       7.600 -27.225  17.399  1.00 33.46           O  
ATOM   3040  OD2 ASP C 128       7.082 -27.160  15.302  1.00 28.34           O  
HETATM 3041  N   MSE C 129       8.349 -30.867  14.626  1.00 33.01           N  
HETATM 3042  CA  MSE C 129       7.361 -31.719  13.986  1.00 33.67           C  
HETATM 3043  C   MSE C 129       7.255 -33.065  14.696  1.00 34.78           C  
HETATM 3044  O   MSE C 129       6.162 -33.607  14.892  1.00 34.94           O  
HETATM 3045  CB  MSE C 129       7.717 -31.944  12.517  1.00 33.45           C  
HETATM 3046  CG  MSE C 129       6.761 -32.904  11.818  1.00 35.08           C  
HETATM 3047 SE   MSE C 129       5.498 -31.901  10.942  0.43 38.06          SE  
HETATM 3048  CE  MSE C 129       6.920 -30.872   9.827  1.00 31.53           C  
ATOM   3049  N   PHE C 130       8.405 -33.612  15.052  1.00 36.07           N  
ATOM   3050  CA  PHE C 130       8.460 -34.878  15.758  1.00 37.58           C  
ATOM   3051  C   PHE C 130       7.758 -34.741  17.116  1.00 38.22           C  
ATOM   3052  O   PHE C 130       6.971 -35.611  17.518  1.00 38.53           O  
ATOM   3053  CB  PHE C 130       9.909 -35.363  15.905  1.00 38.63           C  
ATOM   3054  CG  PHE C 130      10.031 -36.669  16.629  1.00 41.38           C  
ATOM   3055  CD1 PHE C 130       9.546 -37.852  16.059  1.00 43.57           C  
ATOM   3056  CD2 PHE C 130      10.598 -36.723  17.896  1.00 43.48           C  
ATOM   3057  CE1 PHE C 130       9.638 -39.084  16.757  1.00 46.53           C  
ATOM   3058  CE2 PHE C 130      10.700 -37.931  18.593  1.00 45.92           C  
ATOM   3059  CZ  PHE C 130      10.221 -39.115  18.029  1.00 46.29           C  
ATOM   3060  N   LYS C 131       8.003 -33.622  17.796  1.00 38.06           N  
ATOM   3061  CA  LYS C 131       7.290 -33.314  19.037  1.00 38.88           C  
ATOM   3062  C   LYS C 131       5.791 -33.165  18.834  1.00 38.06           C  
ATOM   3063  O   LYS C 131       5.006 -33.577  19.693  1.00 39.03           O  
ATOM   3064  CB  LYS C 131       7.843 -32.053  19.702  1.00 38.60           C  
ATOM   3065  CG  LYS C 131       9.135 -32.286  20.455  1.00 40.23           C  
ATOM   3066  CD  LYS C 131       9.595 -31.045  21.221  1.00 40.94           C  
ATOM   3067  CE  LYS C 131       9.803 -29.856  20.293  1.00 40.51           C  
ATOM   3068  NZ  LYS C 131       9.988 -28.612  21.079  1.00 41.14           N  
ATOM   3069  N   GLY C 132       5.404 -32.580  17.704  1.00 36.44           N  
ATOM   3070  CA  GLY C 132       4.002 -32.443  17.348  1.00 36.12           C  
ATOM   3071  C   GLY C 132       3.359 -33.793  17.094  1.00 37.38           C  
ATOM   3072  O   GLY C 132       2.202 -34.003  17.443  1.00 37.33           O  
ATOM   3073  N   LEU C 133       4.124 -34.708  16.495  1.00 38.29           N  
ATOM   3074  CA  LEU C 133       3.656 -36.062  16.214  1.00 40.07           C  
ATOM   3075  C   LEU C 133       3.438 -36.866  17.506  1.00 42.26           C  
ATOM   3076  O   LEU C 133       2.431 -37.561  17.649  1.00 43.37           O  
ATOM   3077  CB  LEU C 133       4.619 -36.797  15.263  1.00 40.18           C  
ATOM   3078  CG  LEU C 133       4.196 -38.209  14.807  1.00 41.78           C  
ATOM   3079  CD1 LEU C 133       2.842 -38.190  14.060  1.00 40.02           C  
ATOM   3080  CD2 LEU C 133       5.286 -38.863  13.962  1.00 40.73           C  
ATOM   3081  N   LEU C 134       4.370 -36.741  18.444  1.00 43.74           N  
ATOM   3082  CA  LEU C 134       4.280 -37.437  19.725  1.00 46.57           C  
ATOM   3083  C   LEU C 134       3.096 -36.970  20.532  1.00 47.00           C  
ATOM   3084  O   LEU C 134       2.412 -37.772  21.161  1.00 47.89           O  
ATOM   3085  CB  LEU C 134       5.554 -37.261  20.545  1.00 47.01           C  
ATOM   3086  CG  LEU C 134       6.683 -38.202  20.116  1.00 50.06           C  
ATOM   3087  CD1 LEU C 134       7.996 -37.714  20.658  1.00 51.36           C  
ATOM   3088  CD2 LEU C 134       6.497 -39.619  20.574  1.00 52.95           C  
ATOM   3089  N   ARG C 135       2.865 -35.666  20.508  1.00 46.44           N  
ATOM   3090  CA  ARG C 135       1.718 -35.113  21.169  1.00 47.83           C  
ATOM   3091  C   ARG C 135       0.405 -35.510  20.496  1.00 47.29           C  
ATOM   3092  O   ARG C 135      -0.594 -35.741  21.174  1.00 48.26           O  
ATOM   3093  CB  ARG C 135       1.817 -33.622  21.202  1.00 47.17           C  
ATOM   3094  CG  ARG C 135       0.971 -33.147  22.263  1.00 50.91           C  
ATOM   3095  CD  ARG C 135       0.866 -31.752  22.181  1.00 55.65           C  
ATOM   3096  NE  ARG C 135      -0.272 -31.289  22.932  1.00 59.66           N  
ATOM   3097  CZ  ARG C 135      -0.154 -30.350  23.850  1.00 62.48           C  
ATOM   3098  NH1 ARG C 135       1.053 -29.879  24.087  1.00 63.84           N  
ATOM   3099  NH2 ARG C 135      -1.203 -29.904  24.521  1.00 62.89           N  
ATOM   3100  N   GLY C 136       0.421 -35.574  19.169  1.00 45.98           N  
ATOM   3101  CA  GLY C 136      -0.724 -36.047  18.413  1.00 45.80           C  
ATOM   3102  C   GLY C 136      -1.049 -37.477  18.793  1.00 47.73           C  
ATOM   3103  O   GLY C 136      -2.201 -37.818  19.107  1.00 48.22           O  
ATOM   3104  N   LEU C 137      -0.019 -38.313  18.772  1.00 48.50           N  
ATOM   3105  CA  LEU C 137      -0.166 -39.713  19.127  1.00 50.50           C  
ATOM   3106  C   LEU C 137      -0.644 -39.913  20.564  1.00 52.12           C  
ATOM   3107  O   LEU C 137      -1.528 -40.719  20.808  1.00 53.09           O  
ATOM   3108  CB  LEU C 137       1.137 -40.454  18.879  1.00 51.14           C  
ATOM   3109  CG  LEU C 137       1.535 -40.592  17.412  1.00 49.87           C  
ATOM   3110  CD1 LEU C 137       2.904 -41.257  17.354  1.00 48.76           C  
ATOM   3111  CD2 LEU C 137       0.479 -41.375  16.586  1.00 48.97           C  
ATOM   3112  N   VAL C 138      -0.073 -39.165  21.499  1.00 52.54           N  
ATOM   3113  CA  VAL C 138      -0.510 -39.221  22.889  1.00 54.83           C  
ATOM   3114  C   VAL C 138      -1.981 -38.799  23.029  1.00 55.43           C  
ATOM   3115  O   VAL C 138      -2.750 -39.434  23.769  1.00 57.06           O  
ATOM   3116  CB  VAL C 138       0.394 -38.381  23.830  1.00 54.96           C  
ATOM   3117  CG1 VAL C 138      -0.278 -38.167  25.175  1.00 55.55           C  
ATOM   3118  CG2 VAL C 138       1.755 -39.059  24.019  1.00 56.04           C  
ATOM   3119  N   ALA C 139      -2.368 -37.748  22.309  1.00 54.06           N  
ATOM   3120  CA  ALA C 139      -3.729 -37.220  22.405  1.00 54.87           C  
ATOM   3121  C   ALA C 139      -4.786 -38.188  21.836  1.00 56.10           C  
ATOM   3122  O   ALA C 139      -5.947 -38.138  22.210  1.00 56.98           O  
ATOM   3123  CB  ALA C 139      -3.816 -35.877  21.748  1.00 52.60           C  
ATOM   3124  N   LEU C 140      -4.364 -39.073  20.954  1.00 56.94           N  
ATOM   3125  CA  LEU C 140      -5.162 -40.171  20.422  1.00 58.84           C  
ATOM   3126  C   LEU C 140      -5.708 -41.103  21.490  1.00 62.35           C  
ATOM   3127  O   LEU C 140      -6.684 -41.829  21.266  1.00 63.31           O  
ATOM   3128  CB  LEU C 140      -4.280 -41.024  19.521  1.00 58.69           C  
ATOM   3129  CG  LEU C 140      -4.585 -41.231  18.048  1.00 57.44           C  
ATOM   3130  CD1 LEU C 140      -5.073 -39.950  17.427  1.00 55.92           C  
ATOM   3131  CD2 LEU C 140      -3.352 -41.777  17.348  1.00 56.56           C  
ATOM   3132  N   VAL C 141      -5.016 -41.072  22.660  1.00 64.61           N  
ATOM   3133  CA  VAL C 141      -5.250 -42.010  23.736  1.00 67.97           C  
ATOM   3134  C   VAL C 141      -5.758 -41.211  24.942  1.00 69.35           C  
ATOM   3135  O   VAL C 141      -6.617 -41.667  25.695  1.00 71.73           O  
ATOM   3136  CB  VAL C 141      -3.914 -42.736  24.031  1.00 69.18           C  
ATOM   3137  CG1 VAL C 141      -3.895 -43.300  25.302  1.00 71.64           C  
ATOM   3138  CG2 VAL C 141      -3.693 -43.844  23.132  1.00 69.53           C  
ATOM   3139  N   VAL C 142      -5.219 -40.008  25.108  1.00 68.75           N  
ATOM   3140  CA  VAL C 142      -5.666 -39.067  26.131  1.00 69.93           C  
ATOM   3141  C   VAL C 142      -6.167 -37.815  25.406  1.00 68.62           C  
ATOM   3142  O   VAL C 142      -5.404 -36.859  25.210  1.00 67.42           O  
ATOM   3143  CB  VAL C 142      -4.522 -38.662  27.106  1.00 70.44           C  
ATOM   3144  CG1 VAL C 142      -5.093 -37.955  28.326  1.00 71.46           C  
ATOM   3145  CG2 VAL C 142      -3.688 -39.870  27.512  1.00 71.90           C  
ATOM   3146  N   PRO C 143      -7.452 -37.809  24.995  1.00 69.08           N  
ATOM   3147  CA  PRO C 143      -7.967 -36.691  24.195  1.00 67.46           C  
ATOM   3148  C   PRO C 143      -7.788 -35.364  24.889  1.00 67.57           C  
ATOM   3149  O   PRO C 143      -8.068 -34.336  24.348  1.00 66.53           O  
ATOM   3150  CB  PRO C 143      -9.460 -36.986  24.045  1.00 68.20           C  
ATOM   3151  CG  PRO C 143      -9.710 -38.276  24.673  1.00 70.20           C  
ATOM   3152  CD  PRO C 143      -8.465 -38.846  25.248  1.00 70.82           C  
ATOM   3153  N   SER C 144      -7.308 -35.354  26.097  1.00 69.37           N  
ATOM   3154  CA  SER C 144      -7.119 -34.074  26.676  1.00 69.46           C  
ATOM   3155  C   SER C 144      -5.832 -33.451  26.353  1.00 68.25           C  
ATOM   3156  O   SER C 144      -5.609 -32.408  26.818  1.00 68.20           O  
ATOM   3157  CB  SER C 144      -7.099 -34.177  28.150  1.00 71.83           C  
ATOM   3158  OG  SER C 144      -6.490 -33.038  28.718  1.00 71.49           O  
ATOM   3159  N   LEU C 145      -4.904 -34.089  25.664  1.00 67.51           N  
ATOM   3160  CA  LEU C 145      -3.614 -33.405  25.501  1.00 66.51           C  
ATOM   3161  C   LEU C 145      -3.442 -32.909  24.068  1.00 64.34           C  
ATOM   3162  O   LEU C 145      -2.348 -32.527  23.668  1.00 63.10           O  
ATOM   3163  CB  LEU C 145      -2.436 -34.280  25.986  1.00 67.52           C  
ATOM   3164  CG  LEU C 145      -2.453 -34.830  27.428  1.00 69.68           C  
ATOM   3165  CD1 LEU C 145      -1.329 -35.820  27.640  1.00 69.69           C  
ATOM   3166  CD2 LEU C 145      -2.381 -33.728  28.483  1.00 70.36           C  
ATOM   3167  N   LYS C 146      -4.543 -32.904  23.314  1.00 63.90           N  
ATOM   3168  CA  LYS C 146      -4.520 -32.537  21.898  1.00 62.41           C  
ATOM   3169  C   LYS C 146      -4.293 -31.043  21.719  1.00 61.42           C  
ATOM   3170  O   LYS C 146      -4.929 -30.232  22.397  1.00 62.26           O  
ATOM   3171  CB  LYS C 146      -5.809 -32.977  21.187  1.00 62.26           C  
ATOM   3172  CG  LYS C 146      -5.727 -32.876  19.668  1.00 60.60           C  
ATOM   3173  CD  LYS C 146      -7.025 -33.286  18.998  1.00 61.55           C  
ATOM   3174  CE  LYS C 146      -7.092 -34.782  18.792  1.00 62.02           C  
ATOM   3175  NZ  LYS C 146      -8.012 -35.086  17.674  1.00 62.42           N  
ATOM   3176  N   ALA C 147      -3.379 -30.697  20.809  1.00 60.10           N  
ATOM   3177  CA  ALA C 147      -3.064 -29.308  20.469  1.00 58.87           C  
ATOM   3178  C   ALA C 147      -4.288 -28.586  19.900  1.00 58.78           C  
ATOM   3179  O   ALA C 147      -5.176 -29.209  19.302  1.00 59.01           O  
ATOM   3180  CB  ALA C 147      -1.909 -29.270  19.486  1.00 57.41           C  
ATOM   3181  N   THR C 148      -4.353 -27.278  20.112  1.00 58.89           N  
ATOM   3182  CA  THR C 148      -5.451 -26.465  19.574  1.00 58.59           C  
ATOM   3183  C   THR C 148      -4.886 -25.171  18.998  1.00 57.94           C  
ATOM   3184  O   THR C 148      -3.805 -24.726  19.407  1.00 57.98           O  
ATOM   3185  CB  THR C 148      -6.489 -26.090  20.674  1.00 60.05           C  
ATOM   3186  OG1 THR C 148      -5.794 -25.732  21.870  1.00 60.13           O  
ATOM   3187  CG2 THR C 148      -7.446 -27.243  20.976  1.00 60.37           C  
ATOM   3188  N   LEU C 149      -5.620 -24.575  18.055  1.00 57.51           N  
ATOM   3189  CA  LEU C 149      -5.348 -23.206  17.604  1.00 57.06           C  
ATOM   3190  C   LEU C 149      -6.320 -22.210  18.219  1.00 58.34           C  
ATOM   3191  O   LEU C 149      -5.923 -21.386  19.047  1.00 59.53           O  
ATOM   3192  CB  LEU C 149      -5.393 -23.099  16.081  1.00 55.76           C  
ATOM   3193  CG  LEU C 149      -4.268 -23.820  15.363  1.00 53.49           C  
ATOM   3194  CD1 LEU C 149      -4.440 -23.638  13.894  1.00 52.60           C  
ATOM   3195  CD2 LEU C 149      -2.963 -23.257  15.829  1.00 52.33           C  
TER    3196      LEU C 149                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
