
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 ( 1465),  selected   92 , name 1ust_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 1ust_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       2           -
LGA    -       -      K       3           -
LGA    K    39_A      C       4           #
LGA    -       -      P       5           -
LGA    E    40_A      I       6          4.835
LGA    E    41_A      C       7          4.174
LGA    A    42_A      G       8          4.544
LGA    S    43_A      S       9           #
LGA    S    44_A      P      10          3.143
LGA    K    45_A      L      11          3.081
LGA    S    46_A      K      12          2.337
LGA    Y    47_A      W      13          2.214
LGA    R    48_A      E      14          2.190
LGA    E    49_A      E      15          2.842
LGA    L    50_A      L      16          2.456
LGA    I    51_A      I      17          2.967
LGA    I    52_A      E      18          3.949
LGA    E    53_A      E      19          4.006
LGA    G    54_A      M      20          3.892
LGA    L    55_A      L      21          4.625
LGA    T    56_A      I      22          3.535
LGA    A    57_A      I      23          1.816
LGA    L    58_A      E      24           #
LGA    K    59_A      N      25          1.918
LGA    E    60_A      F      26           #
LGA    R    61_A      -       -           -
LGA    K    62_A      E      27          3.979
LGA    G    63_A      E      28          2.712
LGA    S    64_A      I      29          1.744
LGA    S    65_A      V      30          3.963
LGA    -       -      K      31           -
LGA    -       -      D      32           -
LGA    R    66_A      R      33          2.614
LGA    P    67_A      E      34          2.483
LGA    A    68_A      R      35          2.164
LGA    L    69_A      F      36          2.200
LGA    K    70_A      L      37          1.929
LGA    K    71_A      A      38          2.488
LGA    F    72_A      Q      39          2.472
LGA    I    73_A      V      40          1.867
LGA    K    74_A      E      41          1.828
LGA    E    75_A      E      42          2.513
LGA    N    76_A      F      43          2.587
LGA    Y    77_A      V      44          3.601
LGA    -       -      F      45           -
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    P    78_A      F      54          4.006
LGA    I    79_A      Y      55          4.907
LGA    V    80_A      G      56          4.874
LGA    G    81_A      K      57          4.673
LGA    S    82_A      T      58          2.743
LGA    A    83_A      L      59          1.762
LGA    S    84_A      P      60          1.246
LGA    -       -      R      61           -
LGA    N    85_A      R      62          2.208
LGA    F    86_A      E      63          2.939
LGA    D    87_A      A      64          2.047
LGA    L    88_A      E      65          0.316
LGA    Y    89_A      K      66          1.252
LGA    F    90_A      V      67          0.683
LGA    N    91_A      F      68          1.621
LGA    N    92_A      E      69          2.158
LGA    A    93_A      L      70          3.464
LGA    I    94_A      L      71          3.740
LGA    K    95_A      N      72          5.016
LGA    K    96_A      D      73           #
LGA    G    97_A      F      74           #
LGA    V    98_A      K      75          4.972
LGA    E    99_A      G      76          3.934
LGA    A   100_A      G      77          2.990
LGA    G   101_A      I      78          1.756
LGA    D   102_A      -       -           -
LGA    F   103_A      -       -           -
LGA    E   104_A      -       -           -
LGA    Q   105_A      -       -           -
LGA    P   106_A      -       -           -
LGA    K   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    A   110_A      -       -           -
LGA    G   111_A      -       -           -
LGA    A   112_A      -       -           -
LGA    V   113_A      -       -           -
LGA    K   114_A      -       -           -
LGA    L   115_A      -       -           -
LGA    A   116_A      D      79          3.352
LGA    K   117_A      W      80          1.667
LGA    K   118_A      E      81          3.878
LGA    K   119_A      N      82           -
LGA    S   120_A      K      83           -
LGA    P   121_A      R      84           -
LGA    E   122_A      V      85           -
LGA    V   123_A      K      86           -
LGA    K   124_A      L      87           -
LGA    K   125_A      K      88           -
LGA    E   126_A      -       -           -
LGA    K   127_A      -       -           -
LGA    E   128_A      -       -           -
LGA    V   129_A      -       -           -
LGA    S   130_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   87    5.0     59    3.13    11.86     40.956     1.828

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.806128 * X  +  -0.440238 * Y  +   0.395409 * Z  + -11.283808
  Y_new =  -0.590498 * X  +  -0.555167 * Y  +   0.585749 * Z  +  -2.286325
  Z_new =  -0.038351 * X  +  -0.705677 * Y  +  -0.707495 * Z  +  -3.350662 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.357481    0.784112  [ DEG:  -135.0737     44.9263 ]
  Theta =   0.038360    3.103232  [ DEG:     2.1979    177.8021 ]
  Phi   =  -0.632214    2.509379  [ DEG:   -36.2232    143.7768 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ust_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ust_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   87   5.0   59   3.13   11.86  40.956
REMARK  ---------------------------------------------------------- 
MOLECULE 1ust_A
HEADER    DNA BINDING PROTEIN                     30-NOV-03   1UST              
TITLE     YEAST HISTONE H1 GLOBULAR DOMAIN I, HHO1P GI, SOLUTION NMR            
TITLE    2 STRUCTURES                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTONE H1;                                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: GLOBULAR DOMAIN I, RESIDUES 38-130;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: BAKER'S YEAST;                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET17B                                    
KEYWDS    DNA BINDING PROTEIN, LINKER HISTONE, DNA BINDING DOMAIN,              
KEYWDS   2 WINGED HELIX FOLD                                                    
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    T.ALI,P.COLES,T.J.STEVENS,K.STOTT,J.O.THOMAS                          
REVDAT   1   01-APR-04 1UST    0                                                
JRNL        AUTH   T.ALI,P.COLES,T.J.STEVENS,K.STOTT,J.O.THOMAS                 
JRNL        TITL   TWO HOMOLOGOUS DOMAINS OF SIMILAR STRUCTURE BUT              
JRNL        TITL 2 DIFFERENT STABILITY IN THE YEAST LINKER HISTONE,             
JRNL        TITL 3 HHO1P.                                                       
JRNL        REF    J.MOL.BIOL.                   V. 338   139 2004              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1UST A   38   130  UNP    P53551   H1_YEAST        38    130             
SEQRES   1 A   93  LYS LYS GLU GLU ALA SER SER LYS SER TYR ARG GLU LEU          
SEQRES   2 A   93  ILE ILE GLU GLY LEU THR ALA LEU LYS GLU ARG LYS GLY          
SEQRES   3 A   93  SER SER ARG PRO ALA LEU LYS LYS PHE ILE LYS GLU ASN          
SEQRES   4 A   93  TYR PRO ILE VAL GLY SER ALA SER ASN PHE ASP LEU TYR          
SEQRES   5 A   93  PHE ASN ASN ALA ILE LYS LYS GLY VAL GLU ALA GLY ASP          
SEQRES   6 A   93  PHE GLU GLN PRO LYS GLY PRO ALA GLY ALA VAL LYS LEU          
SEQRES   7 A   93  ALA LYS LYS LYS SER PRO GLU VAL LYS LYS GLU LYS GLU          
SEQRES   8 A   93  VAL SER                                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   LYS A  39       6.581  -4.717 -12.080  1.00  0.00           N  
ATOM      2  CA  LYS A  39       7.579  -4.580 -13.165  1.00  0.00           C  
ATOM      3  C   LYS A  39       8.848  -5.367 -12.849  1.00  0.00           C  
ATOM      4  O   LYS A  39       9.425  -6.011 -13.723  1.00  0.00           O  
ATOM      5  CB  LYS A  39       7.894  -3.091 -13.377  1.00  0.00           C  
ATOM      6  CG  LYS A  39       8.366  -2.368 -12.123  1.00  0.00           C  
ATOM      7  CD  LYS A  39       8.724  -0.919 -12.415  1.00  0.00           C  
ATOM      8  CE  LYS A  39       9.180  -0.187 -11.165  1.00  0.00           C  
ATOM      9  NZ  LYS A  39       8.101  -0.094 -10.148  1.00  0.00           N  
ATOM     10  H2  LYS A  39       6.832  -4.117 -11.272  1.00  0.00           H  
ATOM     11  HA  LYS A  39       7.147  -4.976 -14.070  1.00  0.00           H  
ATOM     12  HB2 LYS A  39       8.668  -3.005 -14.125  1.00  0.00           H  
ATOM     13  HB3 LYS A  39       7.003  -2.598 -13.736  1.00  0.00           H  
ATOM     14  HG2 LYS A  39       7.576  -2.392 -11.386  1.00  0.00           H  
ATOM     15  HG3 LYS A  39       9.238  -2.875 -11.735  1.00  0.00           H  
ATOM     16  HD2 LYS A  39       9.521  -0.896 -13.142  1.00  0.00           H  
ATOM     17  HD3 LYS A  39       7.854  -0.420 -12.819  1.00  0.00           H  
ATOM     18  HE2 LYS A  39      10.019  -0.713 -10.740  1.00  0.00           H  
ATOM     19  HE3 LYS A  39       9.486   0.814 -11.442  1.00  0.00           H  
ATOM     20  HZ1 LYS A  39       7.220   0.251 -10.589  1.00  0.00           H  
ATOM     21  HZ2 LYS A  39       7.921  -1.035  -9.730  1.00  0.00           H  
ATOM     22  HZ3 LYS A  39       8.376   0.565  -9.387  1.00  0.00           H  
ATOM     23  H1  LYS A  39       6.534  -5.712 -11.760  1.00  0.00           H  
ATOM     24  H3  LYS A  39       5.638  -4.434 -12.423  1.00  0.00           H  
ATOM     25  N   GLU A  40       9.249  -5.361 -11.584  1.00  0.00           N  
ATOM     26  CA  GLU A  40      10.419  -6.105 -11.155  1.00  0.00           C  
ATOM     27  C   GLU A  40      10.252  -6.508  -9.701  1.00  0.00           C  
ATOM     28  O   GLU A  40      10.317  -7.683  -9.353  1.00  0.00           O  
ATOM     29  CB  GLU A  40      11.679  -5.253 -11.329  1.00  0.00           C  
ATOM     30  CG  GLU A  40      12.959  -6.003 -11.017  1.00  0.00           C  
ATOM     31  CD  GLU A  40      13.093  -7.255 -11.852  1.00  0.00           C  
ATOM     32  OE1 GLU A  40      13.213  -7.139 -13.088  1.00  0.00           O  
ATOM     33  OE2 GLU A  40      13.053  -8.361 -11.280  1.00  0.00           O  
ATOM     34  H   GLU A  40       8.729  -4.868 -10.915  1.00  0.00           H  
ATOM     35  HA  GLU A  40      10.499  -6.994 -11.763  1.00  0.00           H  
ATOM     36  HB2 GLU A  40      11.727  -4.908 -12.349  1.00  0.00           H  
ATOM     37  HB3 GLU A  40      11.616  -4.399 -10.669  1.00  0.00           H  
ATOM     38  HG2 GLU A  40      13.801  -5.358 -11.218  1.00  0.00           H  
ATOM     39  HG3 GLU A  40      12.957  -6.281  -9.973  1.00  0.00           H  
ATOM     40  N   GLU A  41       9.934  -5.524  -8.882  1.00  0.00           N  
ATOM     41  CA  GLU A  41       9.640  -5.737  -7.481  1.00  0.00           C  
ATOM     42  C   GLU A  41       8.347  -6.537  -7.326  1.00  0.00           C  
ATOM     43  O   GLU A  41       7.418  -6.399  -8.129  1.00  0.00           O  
ATOM     44  CB  GLU A  41       9.521  -4.388  -6.749  1.00  0.00           C  
ATOM     45  CG  GLU A  41       8.314  -3.546  -7.161  1.00  0.00           C  
ATOM     46  CD  GLU A  41       8.408  -2.964  -8.565  1.00  0.00           C  
ATOM     47  OE1 GLU A  41       9.493  -3.013  -9.175  1.00  0.00           O  
ATOM     48  OE2 GLU A  41       7.391  -2.441  -9.063  1.00  0.00           O  
ATOM     49  H   GLU A  41       9.852  -4.610  -9.243  1.00  0.00           H  
ATOM     50  HA  GLU A  41      10.455  -6.301  -7.052  1.00  0.00           H  
ATOM     51  HB2 GLU A  41       9.453  -4.575  -5.690  1.00  0.00           H  
ATOM     52  HB3 GLU A  41      10.413  -3.811  -6.946  1.00  0.00           H  
ATOM     53  HG2 GLU A  41       7.432  -4.166  -7.109  1.00  0.00           H  
ATOM     54  HG3 GLU A  41       8.213  -2.730  -6.458  1.00  0.00           H  
ATOM     55  N   ALA A  42       8.277  -7.347  -6.283  1.00  0.00           N  
ATOM     56  CA  ALA A  42       7.087  -8.138  -6.002  1.00  0.00           C  
ATOM     57  C   ALA A  42       6.038  -7.304  -5.265  1.00  0.00           C  
ATOM     58  O   ALA A  42       5.391  -7.782  -4.330  1.00  0.00           O  
ATOM     59  CB  ALA A  42       7.454  -9.374  -5.195  1.00  0.00           C  
ATOM     60  H   ALA A  42       9.030  -7.384  -5.658  1.00  0.00           H  
ATOM     61  HA  ALA A  42       6.673  -8.465  -6.946  1.00  0.00           H  
ATOM     62  HB1 ALA A  42       7.739  -9.079  -4.195  1.00  0.00           H  
ATOM     63  HB2 ALA A  42       8.280  -9.882  -5.670  1.00  0.00           H  
ATOM     64  HB3 ALA A  42       6.603 -10.039  -5.146  1.00  0.00           H  
ATOM     65  N   SER A  43       5.867  -6.061  -5.700  1.00  0.00           N  
ATOM     66  CA  SER A  43       4.899  -5.157  -5.099  1.00  0.00           C  
ATOM     67  C   SER A  43       4.763  -3.891  -5.944  1.00  0.00           C  
ATOM     68  O   SER A  43       4.837  -3.955  -7.173  1.00  0.00           O  
ATOM     69  CB  SER A  43       5.319  -4.808  -3.664  1.00  0.00           C  
ATOM     70  OG  SER A  43       6.620  -4.240  -3.631  1.00  0.00           O  
ATOM     71  H   SER A  43       6.403  -5.746  -6.457  1.00  0.00           H  
ATOM     72  HA  SER A  43       3.945  -5.664  -5.074  1.00  0.00           H  
ATOM     73  HB2 SER A  43       4.622  -4.097  -3.250  1.00  0.00           H  
ATOM     74  HB3 SER A  43       5.316  -5.706  -3.062  1.00  0.00           H  
ATOM     75  HG  SER A  43       7.279  -4.937  -3.787  1.00  0.00           H  
ATOM     76  N   SER A  44       4.609  -2.745  -5.281  1.00  0.00           N  
ATOM     77  CA  SER A  44       4.510  -1.446  -5.944  1.00  0.00           C  
ATOM     78  C   SER A  44       3.359  -1.420  -6.945  1.00  0.00           C  
ATOM     79  O   SER A  44       3.388  -0.680  -7.927  1.00  0.00           O  
ATOM     80  CB  SER A  44       5.835  -1.085  -6.627  1.00  0.00           C  
ATOM     81  OG  SER A  44       5.849   0.269  -7.062  1.00  0.00           O  
ATOM     82  H   SER A  44       4.596  -2.768  -4.301  1.00  0.00           H  
ATOM     83  HA  SER A  44       4.304  -0.714  -5.182  1.00  0.00           H  
ATOM     84  HB2 SER A  44       6.647  -1.231  -5.931  1.00  0.00           H  
ATOM     85  HB3 SER A  44       5.981  -1.725  -7.486  1.00  0.00           H  
ATOM     86  HG  SER A  44       4.944   0.556  -7.252  1.00  0.00           H  
ATOM     87  N   LYS A  45       2.280  -2.101  -6.596  1.00  0.00           N  
ATOM     88  CA  LYS A  45       1.048  -1.979  -7.346  1.00  0.00           C  
ATOM     89  C   LYS A  45       0.138  -1.000  -6.627  1.00  0.00           C  
ATOM     90  O   LYS A  45      -0.140  -1.180  -5.441  1.00  0.00           O  
ATOM     91  CB  LYS A  45       0.337  -3.329  -7.481  1.00  0.00           C  
ATOM     92  CG  LYS A  45       1.144  -4.397  -8.198  1.00  0.00           C  
ATOM     93  CD  LYS A  45       1.458  -3.990  -9.626  1.00  0.00           C  
ATOM     94  CE  LYS A  45       2.075  -5.137 -10.416  1.00  0.00           C  
ATOM     95  NZ  LYS A  45       2.177  -4.819 -11.863  1.00  0.00           N  
ATOM     96  H   LYS A  45       2.265  -2.550  -5.724  1.00  0.00           H  
ATOM     97  HA  LYS A  45       1.283  -1.595  -8.329  1.00  0.00           H  
ATOM     98  HB2 LYS A  45       0.098  -3.695  -6.493  1.00  0.00           H  
ATOM     99  HB3 LYS A  45      -0.582  -3.178  -8.029  1.00  0.00           H  
ATOM    100  HG2 LYS A  45       2.070  -4.553  -7.666  1.00  0.00           H  
ATOM    101  HG3 LYS A  45       0.573  -5.315  -8.210  1.00  0.00           H  
ATOM    102  HD2 LYS A  45       0.544  -3.683 -10.111  1.00  0.00           H  
ATOM    103  HD3 LYS A  45       2.155  -3.163  -9.603  1.00  0.00           H  
ATOM    104  HE2 LYS A  45       3.064  -5.333 -10.030  1.00  0.00           H  
ATOM    105  HE3 LYS A  45       1.458  -6.019 -10.289  1.00  0.00           H  
ATOM    106  HZ1 LYS A  45       1.328  -4.295 -12.175  1.00  0.00           H  
ATOM    107  HZ2 LYS A  45       3.017  -4.229 -12.048  1.00  0.00           H  
ATOM    108  HZ3 LYS A  45       2.254  -5.695 -12.425  1.00  0.00           H  
ATOM    109  N   SER A  46      -0.343   0.003  -7.334  1.00  0.00           N  
ATOM    110  CA  SER A  46      -1.276   0.935  -6.739  1.00  0.00           C  
ATOM    111  C   SER A  46      -2.616   0.251  -6.553  1.00  0.00           C  
ATOM    112  O   SER A  46      -3.208  -0.262  -7.507  1.00  0.00           O  
ATOM    113  CB  SER A  46      -1.438   2.188  -7.602  1.00  0.00           C  
ATOM    114  OG  SER A  46      -2.407   3.065  -7.055  1.00  0.00           O  
ATOM    115  H   SER A  46      -0.117   0.084  -8.289  1.00  0.00           H  
ATOM    116  HA  SER A  46      -0.890   1.217  -5.771  1.00  0.00           H  
ATOM    117  HB2 SER A  46      -0.501   2.712  -7.655  1.00  0.00           H  
ATOM    118  HB3 SER A  46      -1.745   1.906  -8.590  1.00  0.00           H  
ATOM    119  HG  SER A  46      -1.970   3.880  -6.764  1.00  0.00           H  
ATOM    120  N   TYR A  47      -3.100   0.265  -5.325  1.00  0.00           N  
ATOM    121  CA  TYR A  47      -4.390  -0.323  -5.009  1.00  0.00           C  
ATOM    122  C   TYR A  47      -5.482   0.445  -5.732  1.00  0.00           C  
ATOM    123  O   TYR A  47      -6.507  -0.114  -6.108  1.00  0.00           O  
ATOM    124  CB  TYR A  47      -4.632  -0.320  -3.496  1.00  0.00           C  
ATOM    125  CG  TYR A  47      -3.708  -1.242  -2.721  1.00  0.00           C  
ATOM    126  CD1 TYR A  47      -2.333  -1.179  -2.897  1.00  0.00           C  
ATOM    127  CD2 TYR A  47      -4.211  -2.171  -1.817  1.00  0.00           C  
ATOM    128  CE1 TYR A  47      -1.484  -2.013  -2.194  1.00  0.00           C  
ATOM    129  CE2 TYR A  47      -3.371  -3.009  -1.111  1.00  0.00           C  
ATOM    130  CZ  TYR A  47      -2.020  -2.936  -1.301  1.00  0.00           C  
ATOM    131  OH  TYR A  47      -1.168  -3.753  -0.596  1.00  0.00           O  
ATOM    132  H   TYR A  47      -2.590   0.709  -4.615  1.00  0.00           H  
ATOM    133  HA  TYR A  47      -4.385  -1.343  -5.366  1.00  0.00           H  
ATOM    134  HB2 TYR A  47      -4.489   0.683  -3.121  1.00  0.00           H  
ATOM    135  HB3 TYR A  47      -5.648  -0.629  -3.304  1.00  0.00           H  
ATOM    136  HD1 TYR A  47      -1.925  -0.465  -3.598  1.00  0.00           H  
ATOM    137  HD2 TYR A  47      -5.279  -2.233  -1.669  1.00  0.00           H  
ATOM    138  HE1 TYR A  47      -0.418  -1.951  -2.346  1.00  0.00           H  
ATOM    139  HE2 TYR A  47      -3.785  -3.720  -0.410  1.00  0.00           H  
ATOM    140  HH  TYR A  47      -1.689  -4.359  -0.063  1.00  0.00           H  
ATOM    141  N   ARG A  48      -5.191   1.710  -6.016  1.00  0.00           N  
ATOM    142  CA  ARG A  48      -6.077   2.572  -6.779  1.00  0.00           C  
ATOM    143  C   ARG A  48      -6.453   1.937  -8.124  1.00  0.00           C  
ATOM    144  O   ARG A  48      -7.616   1.942  -8.524  1.00  0.00           O  
ATOM    145  CB  ARG A  48      -5.388   3.919  -7.009  1.00  0.00           C  
ATOM    146  CG  ARG A  48      -6.248   4.925  -7.744  1.00  0.00           C  
ATOM    147  CD  ARG A  48      -5.579   6.285  -7.821  1.00  0.00           C  
ATOM    148  NE  ARG A  48      -6.527   7.325  -8.207  1.00  0.00           N  
ATOM    149  CZ  ARG A  48      -6.194   8.587  -8.472  1.00  0.00           C  
ATOM    150  NH1 ARG A  48      -4.924   8.976  -8.414  1.00  0.00           N  
ATOM    151  NH2 ARG A  48      -7.135   9.462  -8.796  1.00  0.00           N  
ATOM    152  H   ARG A  48      -4.319   2.064  -5.736  1.00  0.00           H  
ATOM    153  HA  ARG A  48      -6.974   2.731  -6.200  1.00  0.00           H  
ATOM    154  HB2 ARG A  48      -5.114   4.340  -6.053  1.00  0.00           H  
ATOM    155  HB3 ARG A  48      -4.484   3.754  -7.587  1.00  0.00           H  
ATOM    156  HG2 ARG A  48      -6.418   4.562  -8.745  1.00  0.00           H  
ATOM    157  HG3 ARG A  48      -7.191   5.024  -7.226  1.00  0.00           H  
ATOM    158  HD2 ARG A  48      -5.165   6.526  -6.853  1.00  0.00           H  
ATOM    159  HD3 ARG A  48      -4.787   6.242  -8.553  1.00  0.00           H  
ATOM    160  HE  ARG A  48      -7.486   7.067  -8.253  1.00  0.00           H  
ATOM    161 HH11 ARG A  48      -4.201   8.322  -8.168  1.00  0.00           H  
ATOM    162 HH12 ARG A  48      -4.680   9.927  -8.621  1.00  0.00           H  
ATOM    163 HH21 ARG A  48      -8.100   9.177  -8.844  1.00  0.00           H  
ATOM    164 HH22 ARG A  48      -6.890  10.418  -8.987  1.00  0.00           H  
ATOM    165  N   GLU A  49      -5.465   1.362  -8.795  1.00  0.00           N  
ATOM    166  CA  GLU A  49      -5.686   0.709 -10.083  1.00  0.00           C  
ATOM    167  C   GLU A  49      -6.419  -0.606  -9.888  1.00  0.00           C  
ATOM    168  O   GLU A  49      -7.330  -0.947 -10.639  1.00  0.00           O  
ATOM    169  CB  GLU A  49      -4.350   0.430 -10.766  1.00  0.00           C  
ATOM    170  CG  GLU A  49      -3.366   1.574 -10.664  1.00  0.00           C  
ATOM    171  CD  GLU A  49      -3.734   2.756 -11.539  1.00  0.00           C  
ATOM    172  OE1 GLU A  49      -4.801   3.360 -11.309  1.00  0.00           O  
ATOM    173  OE2 GLU A  49      -2.958   3.091 -12.456  1.00  0.00           O  
ATOM    174  H   GLU A  49      -4.564   1.353  -8.407  1.00  0.00           H  
ATOM    175  HA  GLU A  49      -6.280   1.364 -10.703  1.00  0.00           H  
ATOM    176  HB2 GLU A  49      -3.903  -0.444 -10.316  1.00  0.00           H  
ATOM    177  HB3 GLU A  49      -4.531   0.232 -11.813  1.00  0.00           H  
ATOM    178  HG2 GLU A  49      -3.342   1.903  -9.639  1.00  0.00           H  
ATOM    179  HG3 GLU A  49      -2.387   1.215 -10.949  1.00  0.00           H  
ATOM    180  N   LEU A  50      -5.943  -1.365  -8.916  1.00  0.00           N  
ATOM    181  CA  LEU A  50      -6.452  -2.701  -8.635  1.00  0.00           C  
ATOM    182  C   LEU A  50      -7.925  -2.666  -8.252  1.00  0.00           C  
ATOM    183  O   LEU A  50      -8.738  -3.423  -8.787  1.00  0.00           O  
ATOM    184  CB  LEU A  50      -5.644  -3.324  -7.495  1.00  0.00           C  
ATOM    185  CG  LEU A  50      -4.281  -3.944  -7.859  1.00  0.00           C  
ATOM    186  CD1 LEU A  50      -3.580  -3.184  -8.973  1.00  0.00           C  
ATOM    187  CD2 LEU A  50      -3.394  -3.963  -6.635  1.00  0.00           C  
ATOM    188  H   LEU A  50      -5.178  -1.036  -8.400  1.00  0.00           H  
ATOM    189  HA  LEU A  50      -6.331  -3.302  -9.523  1.00  0.00           H  
ATOM    190  HB2 LEU A  50      -5.472  -2.559  -6.754  1.00  0.00           H  
ATOM    191  HB3 LEU A  50      -6.252  -4.099  -7.044  1.00  0.00           H  
ATOM    192  HG  LEU A  50      -4.426  -4.962  -8.185  1.00  0.00           H  
ATOM    193 HD11 LEU A  50      -4.260  -2.462  -9.398  1.00  0.00           H  
ATOM    194 HD12 LEU A  50      -2.714  -2.677  -8.571  1.00  0.00           H  
ATOM    195 HD13 LEU A  50      -3.265  -3.880  -9.738  1.00  0.00           H  
ATOM    196 HD21 LEU A  50      -3.895  -4.496  -5.839  1.00  0.00           H  
ATOM    197 HD22 LEU A  50      -2.461  -4.454  -6.870  1.00  0.00           H  
ATOM    198 HD23 LEU A  50      -3.198  -2.947  -6.320  1.00  0.00           H  
ATOM    199  N   ILE A  51      -8.258  -1.792  -7.313  1.00  0.00           N  
ATOM    200  CA  ILE A  51      -9.624  -1.668  -6.834  1.00  0.00           C  
ATOM    201  C   ILE A  51     -10.545  -1.224  -7.951  1.00  0.00           C  
ATOM    202  O   ILE A  51     -11.554  -1.858  -8.191  1.00  0.00           O  
ATOM    203  CB  ILE A  51      -9.729  -0.676  -5.661  1.00  0.00           C  
ATOM    204  CG1 ILE A  51      -8.847  -1.133  -4.501  1.00  0.00           C  
ATOM    205  CG2 ILE A  51     -11.177  -0.538  -5.206  1.00  0.00           C  
ATOM    206  CD1 ILE A  51      -8.848  -0.176  -3.336  1.00  0.00           C  
ATOM    207  H   ILE A  51      -7.560  -1.221  -6.920  1.00  0.00           H  
ATOM    208  HA  ILE A  51      -9.951  -2.640  -6.486  1.00  0.00           H  
ATOM    209  HB  ILE A  51      -9.391   0.291  -6.005  1.00  0.00           H  
ATOM    210 HG12 ILE A  51      -9.199  -2.090  -4.144  1.00  0.00           H  
ATOM    211 HG13 ILE A  51      -7.829  -1.234  -4.848  1.00  0.00           H  
ATOM    212 HG21 ILE A  51     -11.830  -0.958  -5.955  1.00  0.00           H  
ATOM    213 HG22 ILE A  51     -11.312  -1.061  -4.273  1.00  0.00           H  
ATOM    214 HG23 ILE A  51     -11.413   0.509  -5.070  1.00  0.00           H  
ATOM    215 HD11 ILE A  51      -9.868   0.043  -3.059  1.00  0.00           H  
ATOM    216 HD12 ILE A  51      -8.335  -0.625  -2.500  1.00  0.00           H  
ATOM    217 HD13 ILE A  51      -8.347   0.736  -3.621  1.00  0.00           H  
ATOM    218  N   ILE A  52     -10.187  -0.152  -8.643  1.00  0.00           N  
ATOM    219  CA  ILE A  52     -11.024   0.359  -9.722  1.00  0.00           C  
ATOM    220  C   ILE A  52     -11.221  -0.671 -10.826  1.00  0.00           C  
ATOM    221  O   ILE A  52     -12.345  -0.875 -11.290  1.00  0.00           O  
ATOM    222  CB  ILE A  52     -10.462   1.662 -10.317  1.00  0.00           C  
ATOM    223  CG1 ILE A  52     -10.703   2.809  -9.335  1.00  0.00           C  
ATOM    224  CG2 ILE A  52     -11.113   1.943 -11.663  1.00  0.00           C  
ATOM    225  CD1 ILE A  52     -10.136   4.138  -9.772  1.00  0.00           C  
ATOM    226  H   ILE A  52      -9.355   0.315  -8.414  1.00  0.00           H  
ATOM    227  HA  ILE A  52     -11.992   0.585  -9.296  1.00  0.00           H  
ATOM    228  HB  ILE A  52      -9.401   1.539 -10.470  1.00  0.00           H  
ATOM    229 HG12 ILE A  52     -11.767   2.936  -9.200  1.00  0.00           H  
ATOM    230 HG13 ILE A  52     -10.256   2.557  -8.385  1.00  0.00           H  
ATOM    231 HG21 ILE A  52     -11.716   1.089 -11.949  1.00  0.00           H  
ATOM    232 HG22 ILE A  52     -11.740   2.820 -11.588  1.00  0.00           H  
ATOM    233 HG23 ILE A  52     -10.347   2.107 -12.406  1.00  0.00           H  
ATOM    234 HD11 ILE A  52     -10.572   4.421 -10.720  1.00  0.00           H  
ATOM    235 HD12 ILE A  52     -10.372   4.887  -9.028  1.00  0.00           H  
ATOM    236 HD13 ILE A  52      -9.064   4.053  -9.875  1.00  0.00           H  
ATOM    237  N   GLU A  53     -10.141  -1.351 -11.200  1.00  0.00           N  
ATOM    238  CA  GLU A  53     -10.196  -2.397 -12.218  1.00  0.00           C  
ATOM    239  C   GLU A  53     -11.304  -3.391 -11.901  1.00  0.00           C  
ATOM    240  O   GLU A  53     -12.114  -3.736 -12.764  1.00  0.00           O  
ATOM    241  CB  GLU A  53      -8.847  -3.114 -12.294  1.00  0.00           C  
ATOM    242  CG  GLU A  53      -8.822  -4.302 -13.248  1.00  0.00           C  
ATOM    243  CD  GLU A  53      -8.991  -3.906 -14.701  1.00  0.00           C  
ATOM    244  OE1 GLU A  53      -9.020  -2.692 -15.000  1.00  0.00           O  
ATOM    245  OE2 GLU A  53      -9.081  -4.813 -15.556  1.00  0.00           O  
ATOM    246  H   GLU A  53      -9.283  -1.162 -10.759  1.00  0.00           H  
ATOM    247  HA  GLU A  53     -10.403  -1.930 -13.169  1.00  0.00           H  
ATOM    248  HB2 GLU A  53      -8.098  -2.406 -12.619  1.00  0.00           H  
ATOM    249  HB3 GLU A  53      -8.588  -3.466 -11.307  1.00  0.00           H  
ATOM    250  HG2 GLU A  53      -7.876  -4.812 -13.141  1.00  0.00           H  
ATOM    251  HG3 GLU A  53      -9.622  -4.976 -12.978  1.00  0.00           H  
ATOM    252  N   GLY A  54     -11.387  -3.776 -10.636  1.00  0.00           N  
ATOM    253  CA  GLY A  54     -12.445  -4.654 -10.207  1.00  0.00           C  
ATOM    254  C   GLY A  54     -13.733  -3.926  -9.964  1.00  0.00           C  
ATOM    255  O   GLY A  54     -14.774  -4.345 -10.439  1.00  0.00           O  
ATOM    256  H   GLY A  54     -10.750  -3.417  -9.980  1.00  0.00           H  
ATOM    257  HA2 GLY A  54     -12.606  -5.410 -10.960  1.00  0.00           H  
ATOM    258  HA3 GLY A  54     -12.152  -5.129  -9.291  1.00  0.00           H  
ATOM    259  N   LEU A  55     -13.671  -2.927  -9.102  1.00  0.00           N  
ATOM    260  CA  LEU A  55     -14.846  -2.220  -8.611  1.00  0.00           C  
ATOM    261  C   LEU A  55     -15.744  -1.745  -9.750  1.00  0.00           C  
ATOM    262  O   LEU A  55     -16.968  -1.694  -9.610  1.00  0.00           O  
ATOM    263  CB  LEU A  55     -14.390  -1.045  -7.750  1.00  0.00           C  
ATOM    264  CG  LEU A  55     -15.481  -0.328  -6.964  1.00  0.00           C  
ATOM    265  CD1 LEU A  55     -16.245  -1.310  -6.098  1.00  0.00           C  
ATOM    266  CD2 LEU A  55     -14.866   0.764  -6.111  1.00  0.00           C  
ATOM    267  H   LEU A  55     -12.796  -2.714  -8.687  1.00  0.00           H  
ATOM    268  HA  LEU A  55     -15.397  -2.906  -7.991  1.00  0.00           H  
ATOM    269  HB2 LEU A  55     -13.659  -1.411  -7.045  1.00  0.00           H  
ATOM    270  HB3 LEU A  55     -13.910  -0.326  -8.391  1.00  0.00           H  
ATOM    271  HG  LEU A  55     -16.177   0.129  -7.653  1.00  0.00           H  
ATOM    272 HD11 LEU A  55     -15.636  -2.183  -5.919  1.00  0.00           H  
ATOM    273 HD12 LEU A  55     -16.486  -0.839  -5.156  1.00  0.00           H  
ATOM    274 HD13 LEU A  55     -17.156  -1.600  -6.599  1.00  0.00           H  
ATOM    275 HD21 LEU A  55     -14.102   0.338  -5.478  1.00  0.00           H  
ATOM    276 HD22 LEU A  55     -14.426   1.516  -6.751  1.00  0.00           H  
ATOM    277 HD23 LEU A  55     -15.631   1.217  -5.499  1.00  0.00           H  
ATOM    278  N   THR A  56     -15.138  -1.439 -10.884  1.00  0.00           N  
ATOM    279  CA  THR A  56     -15.879  -1.026 -12.058  1.00  0.00           C  
ATOM    280  C   THR A  56     -16.548  -2.243 -12.724  1.00  0.00           C  
ATOM    281  O   THR A  56     -17.607  -2.127 -13.338  1.00  0.00           O  
ATOM    282  CB  THR A  56     -14.952  -0.284 -13.061  1.00  0.00           C  
ATOM    283  OG1 THR A  56     -15.724   0.574 -13.915  1.00  0.00           O  
ATOM    284  CG2 THR A  56     -14.146  -1.255 -13.916  1.00  0.00           C  
ATOM    285  H   THR A  56     -14.160  -1.528 -10.943  1.00  0.00           H  
ATOM    286  HA  THR A  56     -16.649  -0.340 -11.735  1.00  0.00           H  
ATOM    287  HB  THR A  56     -14.256   0.322 -12.496  1.00  0.00           H  
ATOM    288  HG1 THR A  56     -16.051   0.062 -14.676  1.00  0.00           H  
ATOM    289 HG21 THR A  56     -14.820  -1.898 -14.460  1.00  0.00           H  
ATOM    290 HG22 THR A  56     -13.533  -0.703 -14.611  1.00  0.00           H  
ATOM    291 HG23 THR A  56     -13.516  -1.855 -13.276  1.00  0.00           H  
ATOM    292  N   ALA A  57     -15.904  -3.402 -12.601  1.00  0.00           N  
ATOM    293  CA  ALA A  57     -16.383  -4.634 -13.217  1.00  0.00           C  
ATOM    294  C   ALA A  57     -17.358  -5.407 -12.328  1.00  0.00           C  
ATOM    295  O   ALA A  57     -18.403  -5.856 -12.798  1.00  0.00           O  
ATOM    296  CB  ALA A  57     -15.206  -5.523 -13.586  1.00  0.00           C  
ATOM    297  H   ALA A  57     -15.066  -3.426 -12.087  1.00  0.00           H  
ATOM    298  HA  ALA A  57     -16.890  -4.365 -14.133  1.00  0.00           H  
ATOM    299  HB1 ALA A  57     -14.440  -4.926 -14.062  1.00  0.00           H  
ATOM    300  HB2 ALA A  57     -14.802  -5.977 -12.692  1.00  0.00           H  
ATOM    301  HB3 ALA A  57     -15.535  -6.295 -14.267  1.00  0.00           H  
ATOM    302  N   LEU A  58     -16.978  -5.659 -11.071  1.00  0.00           N  
ATOM    303  CA  LEU A  58     -17.781  -6.503 -10.199  1.00  0.00           C  
ATOM    304  C   LEU A  58     -18.813  -5.679  -9.439  1.00  0.00           C  
ATOM    305  O   LEU A  58     -19.323  -6.098  -8.400  1.00  0.00           O  
ATOM    306  CB  LEU A  58     -16.891  -7.298  -9.222  1.00  0.00           C  
ATOM    307  CG  LEU A  58     -16.589  -6.619  -7.883  1.00  0.00           C  
ATOM    308  CD1 LEU A  58     -16.342  -7.658  -6.809  1.00  0.00           C  
ATOM    309  CD2 LEU A  58     -15.406  -5.701  -7.978  1.00  0.00           C  
ATOM    310  H   LEU A  58     -16.116  -5.319 -10.744  1.00  0.00           H  
ATOM    311  HA  LEU A  58     -18.303  -7.202 -10.827  1.00  0.00           H  
ATOM    312  HB2 LEU A  58     -17.378  -8.239  -9.017  1.00  0.00           H  
ATOM    313  HB3 LEU A  58     -15.952  -7.501  -9.713  1.00  0.00           H  
ATOM    314  HG  LEU A  58     -17.432  -6.021  -7.599  1.00  0.00           H  
ATOM    315 HD11 LEU A  58     -16.455  -8.647  -7.227  1.00  0.00           H  
ATOM    316 HD12 LEU A  58     -15.338  -7.544  -6.422  1.00  0.00           H  
ATOM    317 HD13 LEU A  58     -17.053  -7.522  -6.007  1.00  0.00           H  
ATOM    318 HD21 LEU A  58     -15.140  -5.572  -9.017  1.00  0.00           H  
ATOM    319 HD22 LEU A  58     -15.663  -4.739  -7.550  1.00  0.00           H  
ATOM    320 HD23 LEU A  58     -14.572  -6.124  -7.439  1.00  0.00           H  
ATOM    321  N   LYS A  59     -19.126  -4.506  -9.969  1.00  0.00           N  
ATOM    322  CA  LYS A  59     -20.087  -3.616  -9.336  1.00  0.00           C  
ATOM    323  C   LYS A  59     -21.458  -4.291  -9.206  1.00  0.00           C  
ATOM    324  O   LYS A  59     -22.185  -4.052  -8.242  1.00  0.00           O  
ATOM    325  CB  LYS A  59     -20.197  -2.296 -10.120  1.00  0.00           C  
ATOM    326  CG  LYS A  59     -21.163  -2.316 -11.297  1.00  0.00           C  
ATOM    327  CD  LYS A  59     -20.636  -3.146 -12.455  1.00  0.00           C  
ATOM    328  CE  LYS A  59     -21.576  -3.094 -13.647  1.00  0.00           C  
ATOM    329  NZ  LYS A  59     -21.120  -3.972 -14.754  1.00  0.00           N  
ATOM    330  H   LYS A  59     -18.674  -4.216 -10.788  1.00  0.00           H  
ATOM    331  HA  LYS A  59     -19.721  -3.398  -8.344  1.00  0.00           H  
ATOM    332  HB2 LYS A  59     -20.517  -1.520  -9.442  1.00  0.00           H  
ATOM    333  HB3 LYS A  59     -19.216  -2.040 -10.495  1.00  0.00           H  
ATOM    334  HG2 LYS A  59     -22.104  -2.736 -10.965  1.00  0.00           H  
ATOM    335  HG3 LYS A  59     -21.321  -1.303 -11.634  1.00  0.00           H  
ATOM    336  HD2 LYS A  59     -19.671  -2.763 -12.751  1.00  0.00           H  
ATOM    337  HD3 LYS A  59     -20.535  -4.172 -12.133  1.00  0.00           H  
ATOM    338  HE2 LYS A  59     -22.557  -3.413 -13.330  1.00  0.00           H  
ATOM    339  HE3 LYS A  59     -21.627  -2.075 -14.004  1.00  0.00           H  
ATOM    340  HZ1 LYS A  59     -20.106  -3.820 -14.945  1.00  0.00           H  
ATOM    341  HZ2 LYS A  59     -21.270  -4.973 -14.499  1.00  0.00           H  
ATOM    342  HZ3 LYS A  59     -21.660  -3.761 -15.622  1.00  0.00           H  
ATOM    343  N   GLU A  60     -21.783  -5.162 -10.165  1.00  0.00           N  
ATOM    344  CA  GLU A  60     -23.050  -5.890 -10.166  1.00  0.00           C  
ATOM    345  C   GLU A  60     -24.230  -4.918 -10.115  1.00  0.00           C  
ATOM    346  O   GLU A  60     -24.494  -4.199 -11.082  1.00  0.00           O  
ATOM    347  CB  GLU A  60     -23.115  -6.882  -8.996  1.00  0.00           C  
ATOM    348  CG  GLU A  60     -22.035  -7.952  -9.042  1.00  0.00           C  
ATOM    349  CD  GLU A  60     -22.147  -8.946  -7.904  1.00  0.00           C  
ATOM    350  OE1 GLU A  60     -23.095  -8.835  -7.093  1.00  0.00           O  
ATOM    351  OE2 GLU A  60     -21.291  -9.849  -7.811  1.00  0.00           O  
ATOM    352  H   GLU A  60     -21.146  -5.326 -10.887  1.00  0.00           H  
ATOM    353  HA  GLU A  60     -23.103  -6.441 -11.092  1.00  0.00           H  
ATOM    354  HB2 GLU A  60     -23.007  -6.335  -8.071  1.00  0.00           H  
ATOM    355  HB3 GLU A  60     -24.076  -7.370  -9.006  1.00  0.00           H  
ATOM    356  HG2 GLU A  60     -22.116  -8.488  -9.976  1.00  0.00           H  
ATOM    357  HG3 GLU A  60     -21.067  -7.474  -8.988  1.00  0.00           H  
ATOM    358  N   ARG A  61     -24.913  -4.887  -8.977  1.00  0.00           N  
ATOM    359  CA  ARG A  61     -26.053  -3.999  -8.778  1.00  0.00           C  
ATOM    360  C   ARG A  61     -25.620  -2.534  -8.791  1.00  0.00           C  
ATOM    361  O   ARG A  61     -26.336  -1.674  -9.300  1.00  0.00           O  
ATOM    362  CB  ARG A  61     -26.757  -4.327  -7.458  1.00  0.00           C  
ATOM    363  CG  ARG A  61     -25.868  -4.153  -6.234  1.00  0.00           C  
ATOM    364  CD  ARG A  61     -26.574  -4.548  -4.949  1.00  0.00           C  
ATOM    365  NE  ARG A  61     -27.707  -3.677  -4.630  1.00  0.00           N  
ATOM    366  CZ  ARG A  61     -28.374  -3.730  -3.477  1.00  0.00           C  
ATOM    367  NH1 ARG A  61     -27.965  -4.549  -2.514  1.00  0.00           N  
ATOM    368  NH2 ARG A  61     -29.430  -2.952  -3.270  1.00  0.00           N  
ATOM    369  H   ARG A  61     -24.633  -5.471  -8.241  1.00  0.00           H  
ATOM    370  HA  ARG A  61     -26.743  -4.164  -9.592  1.00  0.00           H  
ATOM    371  HB2 ARG A  61     -27.615  -3.680  -7.348  1.00  0.00           H  
ATOM    372  HB3 ARG A  61     -27.092  -5.353  -7.485  1.00  0.00           H  
ATOM    373  HG2 ARG A  61     -24.990  -4.770  -6.354  1.00  0.00           H  
ATOM    374  HG3 ARG A  61     -25.571  -3.115  -6.168  1.00  0.00           H  
ATOM    375  HD2 ARG A  61     -26.934  -5.562  -5.052  1.00  0.00           H  
ATOM    376  HD3 ARG A  61     -25.862  -4.504  -4.139  1.00  0.00           H  
ATOM    377  HE  ARG A  61     -28.000  -3.032  -5.325  1.00  0.00           H  
ATOM    378 HH11 ARG A  61     -27.150  -5.125  -2.650  1.00  0.00           H  
ATOM    379 HH12 ARG A  61     -28.467  -4.598  -1.644  1.00  0.00           H  
ATOM    380 HH21 ARG A  61     -29.740  -2.310  -3.981  1.00  0.00           H  
ATOM    381 HH22 ARG A  61     -29.929  -3.001  -2.397  1.00  0.00           H  
ATOM    382  N   LYS A  62     -24.425  -2.266  -8.269  1.00  0.00           N  
ATOM    383  CA  LYS A  62     -23.882  -0.914  -8.219  1.00  0.00           C  
ATOM    384  C   LYS A  62     -22.458  -0.943  -7.678  1.00  0.00           C  
ATOM    385  O   LYS A  62     -21.545  -0.430  -8.304  1.00  0.00           O  
ATOM    386  CB  LYS A  62     -24.764   0.011  -7.358  1.00  0.00           C  
ATOM    387  CG  LYS A  62     -25.003  -0.485  -5.936  1.00  0.00           C  
ATOM    388  CD  LYS A  62     -25.960   0.421  -5.176  1.00  0.00           C  
ATOM    389  CE  LYS A  62     -25.389   1.819  -4.978  1.00  0.00           C  
ATOM    390  NZ  LYS A  62     -26.355   2.720  -4.291  1.00  0.00           N  
ATOM    391  H   LYS A  62     -23.859  -3.014  -7.973  1.00  0.00           H  
ATOM    392  HA  LYS A  62     -23.857  -0.532  -9.230  1.00  0.00           H  
ATOM    393  HB2 LYS A  62     -24.294   0.981  -7.299  1.00  0.00           H  
ATOM    394  HB3 LYS A  62     -25.724   0.118  -7.843  1.00  0.00           H  
ATOM    395  HG2 LYS A  62     -25.422  -1.479  -5.978  1.00  0.00           H  
ATOM    396  HG3 LYS A  62     -24.057  -0.513  -5.414  1.00  0.00           H  
ATOM    397  HD2 LYS A  62     -26.883   0.500  -5.730  1.00  0.00           H  
ATOM    398  HD3 LYS A  62     -26.159  -0.016  -4.208  1.00  0.00           H  
ATOM    399  HE2 LYS A  62     -24.492   1.748  -4.383  1.00  0.00           H  
ATOM    400  HE3 LYS A  62     -25.148   2.235  -5.946  1.00  0.00           H  
ATOM    401  HZ1 LYS A  62     -27.327   2.353  -4.397  1.00  0.00           H  
ATOM    402  HZ2 LYS A  62     -26.129   2.782  -3.277  1.00  0.00           H  
ATOM    403  HZ3 LYS A  62     -26.313   3.678  -4.704  1.00  0.00           H  
ATOM    404  N   GLY A  63     -22.265  -1.645  -6.573  1.00  0.00           N  
ATOM    405  CA  GLY A  63     -20.943  -1.807  -6.004  1.00  0.00           C  
ATOM    406  C   GLY A  63     -20.820  -3.112  -5.247  1.00  0.00           C  
ATOM    407  O   GLY A  63     -21.808  -3.833  -5.094  1.00  0.00           O  
ATOM    408  H   GLY A  63     -23.021  -2.104  -6.162  1.00  0.00           H  
ATOM    409  HA2 GLY A  63     -20.213  -1.792  -6.801  1.00  0.00           H  
ATOM    410  HA3 GLY A  63     -20.746  -0.986  -5.328  1.00  0.00           H  
ATOM    411  N   SER A  64     -19.629  -3.404  -4.749  1.00  0.00           N  
ATOM    412  CA  SER A  64     -19.390  -4.639  -4.010  1.00  0.00           C  
ATOM    413  C   SER A  64     -18.453  -4.411  -2.828  1.00  0.00           C  
ATOM    414  O   SER A  64     -17.690  -3.445  -2.797  1.00  0.00           O  
ATOM    415  CB  SER A  64     -18.833  -5.724  -4.933  1.00  0.00           C  
ATOM    416  OG  SER A  64     -19.833  -6.212  -5.814  1.00  0.00           O  
ATOM    417  H   SER A  64     -18.895  -2.757  -4.849  1.00  0.00           H  
ATOM    418  HA  SER A  64     -20.344  -4.973  -3.627  1.00  0.00           H  
ATOM    419  HB2 SER A  64     -18.024  -5.314  -5.520  1.00  0.00           H  
ATOM    420  HB3 SER A  64     -18.465  -6.545  -4.336  1.00  0.00           H  
ATOM    421  HG  SER A  64     -19.642  -5.913  -6.718  1.00  0.00           H  
ATOM    422  N   SER A  65     -18.612  -5.249  -1.817  1.00  0.00           N  
ATOM    423  CA  SER A  65     -17.893  -5.126  -0.557  1.00  0.00           C  
ATOM    424  C   SER A  65     -16.393  -5.366  -0.736  1.00  0.00           C  
ATOM    425  O   SER A  65     -15.963  -5.987  -1.715  1.00  0.00           O  
ATOM    426  CB  SER A  65     -18.479  -6.125   0.445  1.00  0.00           C  
ATOM    427  OG  SER A  65     -18.095  -5.828   1.777  1.00  0.00           O  
ATOM    428  H   SER A  65     -19.284  -5.964  -1.907  1.00  0.00           H  
ATOM    429  HA  SER A  65     -18.044  -4.124  -0.181  1.00  0.00           H  
ATOM    430  HB2 SER A  65     -19.556  -6.098   0.386  1.00  0.00           H  
ATOM    431  HB3 SER A  65     -18.134  -7.118   0.198  1.00  0.00           H  
ATOM    432  HG  SER A  65     -18.762  -6.193   2.383  1.00  0.00           H  
ATOM    433  N   ARG A  66     -15.600  -4.884   0.229  1.00  0.00           N  
ATOM    434  CA  ARG A  66     -14.149  -5.053   0.208  1.00  0.00           C  
ATOM    435  C   ARG A  66     -13.725  -6.507  -0.032  1.00  0.00           C  
ATOM    436  O   ARG A  66     -12.858  -6.749  -0.860  1.00  0.00           O  
ATOM    437  CB  ARG A  66     -13.513  -4.556   1.510  1.00  0.00           C  
ATOM    438  CG  ARG A  66     -13.472  -3.044   1.666  1.00  0.00           C  
ATOM    439  CD  ARG A  66     -14.788  -2.477   2.175  1.00  0.00           C  
ATOM    440  NE  ARG A  66     -15.278  -3.187   3.359  1.00  0.00           N  
ATOM    441  CZ  ARG A  66     -14.644  -3.240   4.535  1.00  0.00           C  
ATOM    442  NH1 ARG A  66     -13.535  -2.541   4.750  1.00  0.00           N  
ATOM    443  NH2 ARG A  66     -15.142  -3.985   5.512  1.00  0.00           N  
ATOM    444  H   ARG A  66     -16.007  -4.410   0.985  1.00  0.00           H  
ATOM    445  HA  ARG A  66     -13.772  -4.453  -0.607  1.00  0.00           H  
ATOM    446  HB2 ARG A  66     -14.071  -4.960   2.339  1.00  0.00           H  
ATOM    447  HB3 ARG A  66     -12.499  -4.927   1.561  1.00  0.00           H  
ATOM    448  HG2 ARG A  66     -12.696  -2.797   2.365  1.00  0.00           H  
ATOM    449  HG3 ARG A  66     -13.246  -2.601   0.706  1.00  0.00           H  
ATOM    450  HD2 ARG A  66     -14.639  -1.437   2.430  1.00  0.00           H  
ATOM    451  HD3 ARG A  66     -15.526  -2.551   1.391  1.00  0.00           H  
ATOM    452  HE  ARG A  66     -16.130  -3.670   3.265  1.00  0.00           H  
ATOM    453 HH11 ARG A  66     -13.155  -1.952   4.026  1.00  0.00           H  
ATOM    454 HH12 ARG A  66     -13.067  -2.591   5.639  1.00  0.00           H  
ATOM    455 HH21 ARG A  66     -15.992  -4.511   5.358  1.00  0.00           H  
ATOM    456 HH22 ARG A  66     -14.684  -4.029   6.403  1.00  0.00           H  
ATOM    457  N   PRO A  67     -14.272  -7.497   0.721  1.00  0.00           N  
ATOM    458  CA  PRO A  67     -13.879  -8.907   0.582  1.00  0.00           C  
ATOM    459  C   PRO A  67     -13.922  -9.395  -0.867  1.00  0.00           C  
ATOM    460  O   PRO A  67     -13.022 -10.111  -1.315  1.00  0.00           O  
ATOM    461  CB  PRO A  67     -14.906  -9.668   1.436  1.00  0.00           C  
ATOM    462  CG  PRO A  67     -15.951  -8.667   1.799  1.00  0.00           C  
ATOM    463  CD  PRO A  67     -15.259  -7.338   1.797  1.00  0.00           C  
ATOM    464  HA  PRO A  67     -12.889  -9.076   0.979  1.00  0.00           H  
ATOM    465  HB2 PRO A  67     -15.324 -10.481   0.861  1.00  0.00           H  
ATOM    466  HB3 PRO A  67     -14.420 -10.060   2.317  1.00  0.00           H  
ATOM    467  HG2 PRO A  67     -16.743  -8.677   1.065  1.00  0.00           H  
ATOM    468  HG3 PRO A  67     -16.345  -8.884   2.779  1.00  0.00           H  
ATOM    469  HD2 PRO A  67     -15.959  -6.546   1.573  1.00  0.00           H  
ATOM    470  HD3 PRO A  67     -14.772  -7.160   2.745  1.00  0.00           H  
ATOM    471  N   ALA A  68     -14.930  -8.954  -1.612  1.00  0.00           N  
ATOM    472  CA  ALA A  68     -15.055  -9.309  -3.018  1.00  0.00           C  
ATOM    473  C   ALA A  68     -13.922  -8.690  -3.834  1.00  0.00           C  
ATOM    474  O   ALA A  68     -13.261  -9.374  -4.620  1.00  0.00           O  
ATOM    475  CB  ALA A  68     -16.411  -8.868  -3.549  1.00  0.00           C  
ATOM    476  H   ALA A  68     -15.583  -8.340  -1.215  1.00  0.00           H  
ATOM    477  HA  ALA A  68     -14.996 -10.385  -3.096  1.00  0.00           H  
ATOM    478  HB1 ALA A  68     -16.932  -9.724  -3.952  1.00  0.00           H  
ATOM    479  HB2 ALA A  68     -16.271  -8.130  -4.326  1.00  0.00           H  
ATOM    480  HB3 ALA A  68     -16.990  -8.439  -2.746  1.00  0.00           H  
ATOM    481  N   LEU A  69     -13.639  -7.419  -3.568  1.00  0.00           N  
ATOM    482  CA  LEU A  69     -12.530  -6.720  -4.215  1.00  0.00           C  
ATOM    483  C   LEU A  69     -11.189  -7.350  -3.848  1.00  0.00           C  
ATOM    484  O   LEU A  69     -10.317  -7.512  -4.701  1.00  0.00           O  
ATOM    485  CB  LEU A  69     -12.534  -5.245  -3.821  1.00  0.00           C  
ATOM    486  CG  LEU A  69     -13.464  -4.353  -4.639  1.00  0.00           C  
ATOM    487  CD1 LEU A  69     -13.654  -3.010  -3.950  1.00  0.00           C  
ATOM    488  CD2 LEU A  69     -12.897  -4.157  -6.037  1.00  0.00           C  
ATOM    489  H   LEU A  69     -14.156  -6.954  -2.877  1.00  0.00           H  
ATOM    490  HA  LEU A  69     -12.669  -6.797  -5.282  1.00  0.00           H  
ATOM    491  HB2 LEU A  69     -12.821  -5.170  -2.781  1.00  0.00           H  
ATOM    492  HB3 LEU A  69     -11.528  -4.867  -3.925  1.00  0.00           H  
ATOM    493  HG  LEU A  69     -14.430  -4.825  -4.726  1.00  0.00           H  
ATOM    494 HD11 LEU A  69     -13.887  -3.171  -2.907  1.00  0.00           H  
ATOM    495 HD12 LEU A  69     -12.744  -2.432  -4.031  1.00  0.00           H  
ATOM    496 HD13 LEU A  69     -14.464  -2.475  -4.422  1.00  0.00           H  
ATOM    497 HD21 LEU A  69     -11.831  -3.987  -5.976  1.00  0.00           H  
ATOM    498 HD22 LEU A  69     -13.088  -5.041  -6.629  1.00  0.00           H  
ATOM    499 HD23 LEU A  69     -13.372  -3.305  -6.502  1.00  0.00           H  
ATOM    500  N   LYS A  70     -11.033  -7.708  -2.577  1.00  0.00           N  
ATOM    501  CA  LYS A  70      -9.800  -8.320  -2.096  1.00  0.00           C  
ATOM    502  C   LYS A  70      -9.523  -9.625  -2.833  1.00  0.00           C  
ATOM    503  O   LYS A  70      -8.386  -9.906  -3.210  1.00  0.00           O  
ATOM    504  CB  LYS A  70      -9.869  -8.588  -0.587  1.00  0.00           C  
ATOM    505  CG  LYS A  70     -10.033  -7.340   0.268  1.00  0.00           C  
ATOM    506  CD  LYS A  70      -9.970  -7.669   1.747  1.00  0.00           C  
ATOM    507  CE  LYS A  70     -10.037  -6.415   2.600  1.00  0.00           C  
ATOM    508  NZ  LYS A  70      -9.788  -6.700   4.033  1.00  0.00           N  
ATOM    509  H   LYS A  70     -11.769  -7.554  -1.943  1.00  0.00           H  
ATOM    510  HA  LYS A  70      -8.991  -7.631  -2.294  1.00  0.00           H  
ATOM    511  HB2 LYS A  70     -10.705  -9.242  -0.390  1.00  0.00           H  
ATOM    512  HB3 LYS A  70      -8.958  -9.086  -0.281  1.00  0.00           H  
ATOM    513  HG2 LYS A  70      -9.244  -6.640   0.035  1.00  0.00           H  
ATOM    514  HG3 LYS A  70     -10.992  -6.889   0.050  1.00  0.00           H  
ATOM    515  HD2 LYS A  70     -10.803  -8.309   2.000  1.00  0.00           H  
ATOM    516  HD3 LYS A  70      -9.043  -8.183   1.951  1.00  0.00           H  
ATOM    517  HE2 LYS A  70      -9.294  -5.717   2.247  1.00  0.00           H  
ATOM    518  HE3 LYS A  70     -11.017  -5.977   2.493  1.00  0.00           H  
ATOM    519  HZ1 LYS A  70      -9.399  -7.662   4.147  1.00  0.00           H  
ATOM    520  HZ2 LYS A  70      -9.107  -6.017   4.420  1.00  0.00           H  
ATOM    521  HZ3 LYS A  70     -10.676  -6.630   4.576  1.00  0.00           H  
ATOM    522  N   LYS A  71     -10.581 -10.385  -3.096  1.00  0.00           N  
ATOM    523  CA  LYS A  71     -10.458 -11.629  -3.839  1.00  0.00           C  
ATOM    524  C   LYS A  71     -10.086 -11.341  -5.279  1.00  0.00           C  
ATOM    525  O   LYS A  71      -9.163 -11.938  -5.824  1.00  0.00           O  
ATOM    526  CB  LYS A  71     -11.763 -12.419  -3.808  1.00  0.00           C  
ATOM    527  CG  LYS A  71     -11.677 -13.734  -4.563  1.00  0.00           C  
ATOM    528  CD  LYS A  71     -12.978 -14.515  -4.513  1.00  0.00           C  
ATOM    529  CE  LYS A  71     -12.892 -15.772  -5.366  1.00  0.00           C  
ATOM    530  NZ  LYS A  71     -14.126 -16.593  -5.283  1.00  0.00           N  
ATOM    531  H   LYS A  71     -11.473 -10.065  -2.845  1.00  0.00           H  
ATOM    532  HA  LYS A  71      -9.674 -12.214  -3.384  1.00  0.00           H  
ATOM    533  HB2 LYS A  71     -12.023 -12.622  -2.785  1.00  0.00           H  
ATOM    534  HB3 LYS A  71     -12.542 -11.820  -4.257  1.00  0.00           H  
ATOM    535  HG2 LYS A  71     -11.440 -13.526  -5.594  1.00  0.00           H  
ATOM    536  HG3 LYS A  71     -10.892 -14.335  -4.128  1.00  0.00           H  
ATOM    537  HD2 LYS A  71     -13.177 -14.799  -3.490  1.00  0.00           H  
ATOM    538  HD3 LYS A  71     -13.778 -13.890  -4.881  1.00  0.00           H  
ATOM    539  HE2 LYS A  71     -12.733 -15.481  -6.393  1.00  0.00           H  
ATOM    540  HE3 LYS A  71     -12.054 -16.362  -5.028  1.00  0.00           H  
ATOM    541  HZ1 LYS A  71     -14.559 -16.499  -4.338  1.00  0.00           H  
ATOM    542  HZ2 LYS A  71     -14.816 -16.285  -6.004  1.00  0.00           H  
ATOM    543  HZ3 LYS A  71     -13.895 -17.597  -5.447  1.00  0.00           H  
ATOM    544  N   PHE A  72     -10.809 -10.400  -5.864  1.00  0.00           N  
ATOM    545  CA  PHE A  72     -10.578  -9.982  -7.240  1.00  0.00           C  
ATOM    546  C   PHE A  72      -9.105  -9.656  -7.466  1.00  0.00           C  
ATOM    547  O   PHE A  72      -8.505 -10.097  -8.445  1.00  0.00           O  
ATOM    548  CB  PHE A  72     -11.432  -8.753  -7.573  1.00  0.00           C  
ATOM    549  CG  PHE A  72     -11.258  -8.273  -8.982  1.00  0.00           C  
ATOM    550  CD1 PHE A  72     -12.047  -8.778 -10.000  1.00  0.00           C  
ATOM    551  CD2 PHE A  72     -10.289  -7.334  -9.290  1.00  0.00           C  
ATOM    552  CE1 PHE A  72     -11.878  -8.350 -11.302  1.00  0.00           C  
ATOM    553  CE2 PHE A  72     -10.111  -6.902 -10.590  1.00  0.00           C  
ATOM    554  CZ  PHE A  72     -10.907  -7.411 -11.599  1.00  0.00           C  
ATOM    555  H   PHE A  72     -11.531  -9.975  -5.350  1.00  0.00           H  
ATOM    556  HA  PHE A  72     -10.864 -10.795  -7.890  1.00  0.00           H  
ATOM    557  HB2 PHE A  72     -12.474  -8.998  -7.433  1.00  0.00           H  
ATOM    558  HB3 PHE A  72     -11.164  -7.944  -6.909  1.00  0.00           H  
ATOM    559  HD1 PHE A  72     -12.804  -9.510  -9.762  1.00  0.00           H  
ATOM    560  HD2 PHE A  72      -9.668  -6.938  -8.498  1.00  0.00           H  
ATOM    561  HE1 PHE A  72     -12.500  -8.751 -12.089  1.00  0.00           H  
ATOM    562  HE2 PHE A  72      -9.353  -6.168 -10.818  1.00  0.00           H  
ATOM    563  HZ  PHE A  72     -10.775  -7.073 -12.616  1.00  0.00           H  
ATOM    564  N   ILE A  73      -8.529  -8.886  -6.552  1.00  0.00           N  
ATOM    565  CA  ILE A  73      -7.132  -8.499  -6.659  1.00  0.00           C  
ATOM    566  C   ILE A  73      -6.214  -9.704  -6.480  1.00  0.00           C  
ATOM    567  O   ILE A  73      -5.235  -9.849  -7.200  1.00  0.00           O  
ATOM    568  CB  ILE A  73      -6.769  -7.405  -5.636  1.00  0.00           C  
ATOM    569  CG1 ILE A  73      -7.633  -6.163  -5.871  1.00  0.00           C  
ATOM    570  CG2 ILE A  73      -5.289  -7.055  -5.734  1.00  0.00           C  
ATOM    571  CD1 ILE A  73      -7.369  -5.043  -4.890  1.00  0.00           C  
ATOM    572  H   ILE A  73      -9.057  -8.574  -5.784  1.00  0.00           H  
ATOM    573  HA  ILE A  73      -6.981  -8.094  -7.649  1.00  0.00           H  
ATOM    574  HB  ILE A  73      -6.959  -7.789  -4.646  1.00  0.00           H  
ATOM    575 HG12 ILE A  73      -7.445  -5.783  -6.863  1.00  0.00           H  
ATOM    576 HG13 ILE A  73      -8.675  -6.438  -5.788  1.00  0.00           H  
ATOM    577 HG21 ILE A  73      -4.721  -7.952  -5.933  1.00  0.00           H  
ATOM    578 HG22 ILE A  73      -5.137  -6.350  -6.536  1.00  0.00           H  
ATOM    579 HG23 ILE A  73      -4.959  -6.618  -4.803  1.00  0.00           H  
ATOM    580 HD11 ILE A  73      -7.208  -5.458  -3.906  1.00  0.00           H  
ATOM    581 HD12 ILE A  73      -6.492  -4.494  -5.197  1.00  0.00           H  
ATOM    582 HD13 ILE A  73      -8.220  -4.378  -4.865  1.00  0.00           H  
ATOM    583  N   LYS A  74      -6.546 -10.578  -5.541  1.00  0.00           N  
ATOM    584  CA  LYS A  74      -5.738 -11.767  -5.295  1.00  0.00           C  
ATOM    585  C   LYS A  74      -5.716 -12.694  -6.507  1.00  0.00           C  
ATOM    586  O   LYS A  74      -4.677 -13.270  -6.839  1.00  0.00           O  
ATOM    587  CB  LYS A  74      -6.227 -12.510  -4.050  1.00  0.00           C  
ATOM    588  CG  LYS A  74      -5.878 -11.790  -2.759  1.00  0.00           C  
ATOM    589  CD  LYS A  74      -6.368 -12.545  -1.535  1.00  0.00           C  
ATOM    590  CE  LYS A  74      -5.999 -11.816  -0.250  1.00  0.00           C  
ATOM    591  NZ  LYS A  74      -6.481 -12.528   0.964  1.00  0.00           N  
ATOM    592  H   LYS A  74      -7.353 -10.425  -5.002  1.00  0.00           H  
ATOM    593  HA  LYS A  74      -4.733 -11.435  -5.116  1.00  0.00           H  
ATOM    594  HB2 LYS A  74      -7.300 -12.615  -4.105  1.00  0.00           H  
ATOM    595  HB3 LYS A  74      -5.776 -13.493  -4.027  1.00  0.00           H  
ATOM    596  HG2 LYS A  74      -4.806 -11.687  -2.696  1.00  0.00           H  
ATOM    597  HG3 LYS A  74      -6.334 -10.810  -2.772  1.00  0.00           H  
ATOM    598  HD2 LYS A  74      -7.441 -12.642  -1.589  1.00  0.00           H  
ATOM    599  HD3 LYS A  74      -5.914 -13.526  -1.524  1.00  0.00           H  
ATOM    600  HE2 LYS A  74      -4.925 -11.724  -0.197  1.00  0.00           H  
ATOM    601  HE3 LYS A  74      -6.441 -10.830  -0.276  1.00  0.00           H  
ATOM    602  HZ1 LYS A  74      -6.889 -13.452   0.707  1.00  0.00           H  
ATOM    603  HZ2 LYS A  74      -5.692 -12.684   1.628  1.00  0.00           H  
ATOM    604  HZ3 LYS A  74      -7.216 -11.960   1.446  1.00  0.00           H  
ATOM    605  N   GLU A  75      -6.859 -12.842  -7.161  1.00  0.00           N  
ATOM    606  CA  GLU A  75      -6.960 -13.709  -8.325  1.00  0.00           C  
ATOM    607  C   GLU A  75      -6.279 -13.084  -9.546  1.00  0.00           C  
ATOM    608  O   GLU A  75      -5.738 -13.793 -10.393  1.00  0.00           O  
ATOM    609  CB  GLU A  75      -8.427 -14.011  -8.658  1.00  0.00           C  
ATOM    610  CG  GLU A  75      -9.233 -14.599  -7.506  1.00  0.00           C  
ATOM    611  CD  GLU A  75      -8.607 -15.843  -6.906  1.00  0.00           C  
ATOM    612  OE1 GLU A  75      -7.638 -15.711  -6.130  1.00  0.00           O  
ATOM    613  OE2 GLU A  75      -9.075 -16.960  -7.206  1.00  0.00           O  
ATOM    614  H   GLU A  75      -7.662 -12.374  -6.837  1.00  0.00           H  
ATOM    615  HA  GLU A  75      -6.460 -14.637  -8.087  1.00  0.00           H  
ATOM    616  HB2 GLU A  75      -8.904 -13.095  -8.965  1.00  0.00           H  
ATOM    617  HB3 GLU A  75      -8.457 -14.711  -9.479  1.00  0.00           H  
ATOM    618  HG2 GLU A  75      -9.320 -13.852  -6.731  1.00  0.00           H  
ATOM    619  HG3 GLU A  75     -10.219 -14.851  -7.869  1.00  0.00           H  
ATOM    620  N   ASN A  76      -6.439 -11.777  -9.705  1.00  0.00           N  
ATOM    621  CA  ASN A  76      -5.991 -11.096 -10.925  1.00  0.00           C  
ATOM    622  C   ASN A  76      -4.589 -10.512 -10.795  1.00  0.00           C  
ATOM    623  O   ASN A  76      -3.802 -10.568 -11.740  1.00  0.00           O  
ATOM    624  CB  ASN A  76      -6.983  -9.992 -11.300  1.00  0.00           C  
ATOM    625  CG  ASN A  76      -8.262 -10.545 -11.892  1.00  0.00           C  
ATOM    626  OD1 ASN A  76      -8.294 -10.964 -13.050  1.00  0.00           O  
ATOM    627  ND2 ASN A  76      -9.317 -10.580 -11.093  1.00  0.00           N  
ATOM    628  H   ASN A  76      -6.975 -11.281  -9.051  1.00  0.00           H  
ATOM    629  HA  ASN A  76      -5.981 -11.829 -11.718  1.00  0.00           H  
ATOM    630  HB2 ASN A  76      -7.234  -9.425 -10.416  1.00  0.00           H  
ATOM    631  HB3 ASN A  76      -6.525  -9.337 -12.025  1.00  0.00           H  
ATOM    632 HD21 ASN A  76      -9.212 -10.249 -10.175  1.00  0.00           H  
ATOM    633 HD22 ASN A  76     -10.158 -10.950 -11.449  1.00  0.00           H  
ATOM    634  N   TYR A  77      -4.289  -9.914  -9.652  1.00  0.00           N  
ATOM    635  CA  TYR A  77      -2.991  -9.274  -9.426  1.00  0.00           C  
ATOM    636  C   TYR A  77      -2.260  -9.917  -8.245  1.00  0.00           C  
ATOM    637  O   TYR A  77      -2.170  -9.318  -7.176  1.00  0.00           O  
ATOM    638  CB  TYR A  77      -3.167  -7.774  -9.148  1.00  0.00           C  
ATOM    639  CG  TYR A  77      -3.671  -6.957 -10.320  1.00  0.00           C  
ATOM    640  CD1 TYR A  77      -4.959  -7.142 -10.803  1.00  0.00           C  
ATOM    641  CD2 TYR A  77      -2.864  -6.016 -10.952  1.00  0.00           C  
ATOM    642  CE1 TYR A  77      -5.431  -6.415 -11.879  1.00  0.00           C  
ATOM    643  CE2 TYR A  77      -3.330  -5.285 -12.030  1.00  0.00           C  
ATOM    644  CZ  TYR A  77      -4.579  -5.426 -12.460  1.00  0.00           C  
ATOM    645  OH  TYR A  77      -5.082  -4.769 -13.566  1.00  0.00           O  
ATOM    646  H   TYR A  77      -4.961  -9.890  -8.932  1.00  0.00           H  
ATOM    647  HA  TYR A  77      -2.397  -9.400 -10.319  1.00  0.00           H  
ATOM    648  HB2 TYR A  77      -3.870  -7.648  -8.339  1.00  0.00           H  
ATOM    649  HB3 TYR A  77      -2.213  -7.363  -8.847  1.00  0.00           H  
ATOM    650  HD1 TYR A  77      -5.600  -7.867 -10.324  1.00  0.00           H  
ATOM    651  HD2 TYR A  77      -1.860  -5.857 -10.589  1.00  0.00           H  
ATOM    652  HE1 TYR A  77      -6.438  -6.576 -12.237  1.00  0.00           H  
ATOM    653  HE2 TYR A  77      -2.688  -4.559 -12.507  1.00  0.00           H  
ATOM    654  HH  TYR A  77      -5.220  -3.844 -13.300  1.00  0.00           H  
ATOM    655  N   PRO A  78      -1.724 -11.140  -8.420  1.00  0.00           N  
ATOM    656  CA  PRO A  78      -1.038 -11.878  -7.342  1.00  0.00           C  
ATOM    657  C   PRO A  78       0.134 -11.116  -6.732  1.00  0.00           C  
ATOM    658  O   PRO A  78       0.509 -11.364  -5.587  1.00  0.00           O  
ATOM    659  CB  PRO A  78      -0.539 -13.143  -8.034  1.00  0.00           C  
ATOM    660  CG  PRO A  78      -1.452 -13.318  -9.195  1.00  0.00           C  
ATOM    661  CD  PRO A  78      -1.775 -11.930  -9.663  1.00  0.00           C  
ATOM    662  HA  PRO A  78      -1.728 -12.149  -6.555  1.00  0.00           H  
ATOM    663  HB2 PRO A  78       0.484 -13.004  -8.352  1.00  0.00           H  
ATOM    664  HB3 PRO A  78      -0.602 -13.976  -7.352  1.00  0.00           H  
ATOM    665  HG2 PRO A  78      -0.951 -13.872  -9.974  1.00  0.00           H  
ATOM    666  HG3 PRO A  78      -2.350 -13.829  -8.885  1.00  0.00           H  
ATOM    667  HD2 PRO A  78      -1.033 -11.588 -10.369  1.00  0.00           H  
ATOM    668  HD3 PRO A  78      -2.762 -11.898 -10.101  1.00  0.00           H  
ATOM    669  N   ILE A  79       0.694 -10.183  -7.500  1.00  0.00           N  
ATOM    670  CA  ILE A  79       1.812  -9.360  -7.047  1.00  0.00           C  
ATOM    671  C   ILE A  79       1.507  -8.751  -5.688  1.00  0.00           C  
ATOM    672  O   ILE A  79       2.223  -8.959  -4.706  1.00  0.00           O  
ATOM    673  CB  ILE A  79       2.080  -8.191  -8.023  1.00  0.00           C  
ATOM    674  CG1 ILE A  79       2.185  -8.682  -9.475  1.00  0.00           C  
ATOM    675  CG2 ILE A  79       3.352  -7.456  -7.628  1.00  0.00           C  
ATOM    676  CD1 ILE A  79       0.854  -8.795 -10.189  1.00  0.00           C  
ATOM    677  H   ILE A  79       0.337 -10.036  -8.399  1.00  0.00           H  
ATOM    678  HA  ILE A  79       2.698  -9.973  -6.983  1.00  0.00           H  
ATOM    679  HB  ILE A  79       1.244  -7.494  -7.934  1.00  0.00           H  
ATOM    680 HG12 ILE A  79       2.801  -7.994 -10.038  1.00  0.00           H  
ATOM    681 HG13 ILE A  79       2.648  -9.658  -9.484  1.00  0.00           H  
ATOM    682 HG21 ILE A  79       3.652  -7.765  -6.636  1.00  0.00           H  
ATOM    683 HG22 ILE A  79       4.138  -7.691  -8.331  1.00  0.00           H  
ATOM    684 HG23 ILE A  79       3.169  -6.391  -7.634  1.00  0.00           H  
ATOM    685 HD11 ILE A  79       0.052  -8.630  -9.483  1.00  0.00           H  
ATOM    686 HD12 ILE A  79       0.801  -8.055 -10.973  1.00  0.00           H  
ATOM    687 HD13 ILE A  79       0.758  -9.781 -10.618  1.00  0.00           H  
ATOM    688  N   VAL A  80       0.402  -8.038  -5.652  1.00  0.00           N  
ATOM    689  CA  VAL A  80      -0.085  -7.402  -4.455  1.00  0.00           C  
ATOM    690  C   VAL A  80      -1.036  -8.338  -3.730  1.00  0.00           C  
ATOM    691  O   VAL A  80      -1.139  -8.324  -2.505  1.00  0.00           O  
ATOM    692  CB  VAL A  80      -0.781  -6.083  -4.826  1.00  0.00           C  
ATOM    693  CG1 VAL A  80      -2.164  -6.003  -4.251  1.00  0.00           C  
ATOM    694  CG2 VAL A  80       0.045  -4.893  -4.388  1.00  0.00           C  
ATOM    695  H   VAL A  80      -0.136  -7.972  -6.464  1.00  0.00           H  
ATOM    696  HA  VAL A  80       0.750  -7.178  -3.813  1.00  0.00           H  
ATOM    697  HB  VAL A  80      -0.874  -6.055  -5.894  1.00  0.00           H  
ATOM    698 HG11 VAL A  80      -2.193  -6.560  -3.328  1.00  0.00           H  
ATOM    699 HG12 VAL A  80      -2.418  -4.975  -4.067  1.00  0.00           H  
ATOM    700 HG13 VAL A  80      -2.859  -6.432  -4.958  1.00  0.00           H  
ATOM    701 HG21 VAL A  80       1.089  -5.173  -4.355  1.00  0.00           H  
ATOM    702 HG22 VAL A  80      -0.091  -4.085  -5.094  1.00  0.00           H  
ATOM    703 HG23 VAL A  80      -0.276  -4.575  -3.408  1.00  0.00           H  
ATOM    704  N   GLY A  81      -1.745  -9.139  -4.508  1.00  0.00           N  
ATOM    705  CA  GLY A  81      -2.701 -10.058  -3.952  1.00  0.00           C  
ATOM    706  C   GLY A  81      -2.082 -10.974  -2.915  1.00  0.00           C  
ATOM    707  O   GLY A  81      -2.658 -11.205  -1.853  1.00  0.00           O  
ATOM    708  H   GLY A  81      -1.644  -9.074  -5.485  1.00  0.00           H  
ATOM    709  HA2 GLY A  81      -3.498  -9.490  -3.500  1.00  0.00           H  
ATOM    710  HA3 GLY A  81      -3.101 -10.657  -4.752  1.00  0.00           H  
ATOM    711  N   SER A  82      -0.884 -11.449  -3.209  1.00  0.00           N  
ATOM    712  CA  SER A  82      -0.150 -12.295  -2.291  1.00  0.00           C  
ATOM    713  C   SER A  82       0.914 -11.474  -1.560  1.00  0.00           C  
ATOM    714  O   SER A  82       1.988 -11.977  -1.220  1.00  0.00           O  
ATOM    715  CB  SER A  82       0.495 -13.457  -3.058  1.00  0.00           C  
ATOM    716  OG  SER A  82       0.924 -14.486  -2.178  1.00  0.00           O  
ATOM    717  H   SER A  82      -0.466 -11.198  -4.061  1.00  0.00           H  
ATOM    718  HA  SER A  82      -0.847 -12.691  -1.568  1.00  0.00           H  
ATOM    719  HB2 SER A  82      -0.224 -13.870  -3.750  1.00  0.00           H  
ATOM    720  HB3 SER A  82       1.350 -13.092  -3.606  1.00  0.00           H  
ATOM    721  HG  SER A  82       0.376 -15.271  -2.317  1.00  0.00           H  
ATOM    722  N   ALA A  83       0.611 -10.209  -1.306  1.00  0.00           N  
ATOM    723  CA  ALA A  83       1.520  -9.344  -0.564  1.00  0.00           C  
ATOM    724  C   ALA A  83       1.249  -9.460   0.928  1.00  0.00           C  
ATOM    725  O   ALA A  83       0.110  -9.686   1.344  1.00  0.00           O  
ATOM    726  CB  ALA A  83       1.400  -7.894  -1.016  1.00  0.00           C  
ATOM    727  H   ALA A  83      -0.270  -9.859  -1.578  1.00  0.00           H  
ATOM    728  HA  ALA A  83       2.528  -9.676  -0.762  1.00  0.00           H  
ATOM    729  HB1 ALA A  83       1.083  -7.861  -2.051  1.00  0.00           H  
ATOM    730  HB2 ALA A  83       0.672  -7.384  -0.403  1.00  0.00           H  
ATOM    731  HB3 ALA A  83       2.356  -7.405  -0.918  1.00  0.00           H  
ATOM    732  N   SER A  84       2.302  -9.362   1.721  1.00  0.00           N  
ATOM    733  CA  SER A  84       2.172  -9.482   3.159  1.00  0.00           C  
ATOM    734  C   SER A  84       1.344  -8.326   3.715  1.00  0.00           C  
ATOM    735  O   SER A  84       1.627  -7.158   3.443  1.00  0.00           O  
ATOM    736  CB  SER A  84       3.557  -9.519   3.806  1.00  0.00           C  
ATOM    737  OG  SER A  84       4.345 -10.558   3.243  1.00  0.00           O  
ATOM    738  H   SER A  84       3.193  -9.219   1.330  1.00  0.00           H  
ATOM    739  HA  SER A  84       1.659 -10.408   3.371  1.00  0.00           H  
ATOM    740  HB2 SER A  84       4.057  -8.575   3.642  1.00  0.00           H  
ATOM    741  HB3 SER A  84       3.456  -9.697   4.867  1.00  0.00           H  
ATOM    742  HG  SER A  84       3.881 -10.931   2.471  1.00  0.00           H  
ATOM    743  N   ASN A  85       0.289  -8.678   4.444  1.00  0.00           N  
ATOM    744  CA  ASN A  85      -0.637  -7.709   5.030  1.00  0.00           C  
ATOM    745  C   ASN A  85      -1.402  -6.939   3.954  1.00  0.00           C  
ATOM    746  O   ASN A  85      -1.888  -5.835   4.203  1.00  0.00           O  
ATOM    747  CB  ASN A  85       0.092  -6.720   5.957  1.00  0.00           C  
ATOM    748  CG  ASN A  85       0.653  -7.363   7.218  1.00  0.00           C  
ATOM    749  OD1 ASN A  85       1.206  -6.679   8.081  1.00  0.00           O  
ATOM    750  ND2 ASN A  85       0.519  -8.676   7.336  1.00  0.00           N  
ATOM    751  H   ASN A  85       0.105  -9.641   4.572  1.00  0.00           H  
ATOM    752  HA  ASN A  85      -1.353  -8.264   5.619  1.00  0.00           H  
ATOM    753  HB2 ASN A  85       0.912  -6.272   5.416  1.00  0.00           H  
ATOM    754  HB3 ASN A  85      -0.600  -5.944   6.251  1.00  0.00           H  
ATOM    755 HD21 ASN A  85       0.071  -9.165   6.612  1.00  0.00           H  
ATOM    756 HD22 ASN A  85       0.885  -9.110   8.136  1.00  0.00           H  
ATOM    757  N   PHE A  86      -1.628  -7.584   2.809  1.00  0.00           N  
ATOM    758  CA  PHE A  86      -2.447  -7.006   1.745  1.00  0.00           C  
ATOM    759  C   PHE A  86      -3.863  -6.762   2.251  1.00  0.00           C  
ATOM    760  O   PHE A  86      -4.460  -5.711   2.002  1.00  0.00           O  
ATOM    761  CB  PHE A  86      -2.486  -7.943   0.531  1.00  0.00           C  
ATOM    762  CG  PHE A  86      -3.597  -7.631  -0.434  1.00  0.00           C  
ATOM    763  CD1 PHE A  86      -3.590  -6.448  -1.156  1.00  0.00           C  
ATOM    764  CD2 PHE A  86      -4.637  -8.523  -0.630  1.00  0.00           C  
ATOM    765  CE1 PHE A  86      -4.597  -6.166  -2.060  1.00  0.00           C  
ATOM    766  CE2 PHE A  86      -5.646  -8.243  -1.528  1.00  0.00           C  
ATOM    767  CZ  PHE A  86      -5.675  -7.048  -2.184  1.00  0.00           C  
ATOM    768  H   PHE A  86      -1.307  -8.504   2.713  1.00  0.00           H  
ATOM    769  HA  PHE A  86      -2.009  -6.061   1.454  1.00  0.00           H  
ATOM    770  HB2 PHE A  86      -1.550  -7.866  -0.004  1.00  0.00           H  
ATOM    771  HB3 PHE A  86      -2.618  -8.960   0.873  1.00  0.00           H  
ATOM    772  HD1 PHE A  86      -2.784  -5.744  -1.013  1.00  0.00           H  
ATOM    773  HD2 PHE A  86      -4.657  -9.444  -0.065  1.00  0.00           H  
ATOM    774  HE1 PHE A  86      -4.579  -5.240  -2.617  1.00  0.00           H  
ATOM    775  HE2 PHE A  86      -6.452  -8.949  -1.669  1.00  0.00           H  
ATOM    776  HZ  PHE A  86      -6.480  -6.819  -2.862  1.00  0.00           H  
ATOM    777  N   ASP A  87      -4.382  -7.743   2.975  1.00  0.00           N  
ATOM    778  CA  ASP A  87      -5.728  -7.675   3.542  1.00  0.00           C  
ATOM    779  C   ASP A  87      -5.907  -6.406   4.377  1.00  0.00           C  
ATOM    780  O   ASP A  87      -6.920  -5.713   4.260  1.00  0.00           O  
ATOM    781  CB  ASP A  87      -5.994  -8.912   4.403  1.00  0.00           C  
ATOM    782  CG  ASP A  87      -7.403  -8.947   4.959  1.00  0.00           C  
ATOM    783  OD1 ASP A  87      -8.364  -8.981   4.162  1.00  0.00           O  
ATOM    784  OD2 ASP A  87      -7.559  -8.930   6.196  1.00  0.00           O  
ATOM    785  H   ASP A  87      -3.840  -8.547   3.128  1.00  0.00           H  
ATOM    786  HA  ASP A  87      -6.433  -7.657   2.723  1.00  0.00           H  
ATOM    787  HB2 ASP A  87      -5.845  -9.798   3.805  1.00  0.00           H  
ATOM    788  HB3 ASP A  87      -5.300  -8.921   5.231  1.00  0.00           H  
ATOM    789  N   LEU A  88      -4.888  -6.080   5.167  1.00  0.00           N  
ATOM    790  CA  LEU A  88      -4.894  -4.876   5.990  1.00  0.00           C  
ATOM    791  C   LEU A  88      -4.730  -3.626   5.121  1.00  0.00           C  
ATOM    792  O   LEU A  88      -5.492  -2.664   5.251  1.00  0.00           O  
ATOM    793  CB  LEU A  88      -3.770  -4.973   7.043  1.00  0.00           C  
ATOM    794  CG  LEU A  88      -3.627  -3.801   8.033  1.00  0.00           C  
ATOM    795  CD1 LEU A  88      -2.671  -2.749   7.499  1.00  0.00           C  
ATOM    796  CD2 LEU A  88      -4.977  -3.172   8.341  1.00  0.00           C  
ATOM    797  H   LEU A  88      -4.091  -6.650   5.167  1.00  0.00           H  
ATOM    798  HA  LEU A  88      -5.845  -4.824   6.498  1.00  0.00           H  
ATOM    799  HB2 LEU A  88      -3.934  -5.872   7.617  1.00  0.00           H  
ATOM    800  HB3 LEU A  88      -2.832  -5.077   6.517  1.00  0.00           H  
ATOM    801  HG  LEU A  88      -3.215  -4.176   8.960  1.00  0.00           H  
ATOM    802 HD11 LEU A  88      -1.733  -3.215   7.238  1.00  0.00           H  
ATOM    803 HD12 LEU A  88      -3.102  -2.286   6.625  1.00  0.00           H  
ATOM    804 HD13 LEU A  88      -2.502  -1.998   8.258  1.00  0.00           H  
ATOM    805 HD21 LEU A  88      -5.758  -3.899   8.178  1.00  0.00           H  
ATOM    806 HD22 LEU A  88      -4.997  -2.841   9.368  1.00  0.00           H  
ATOM    807 HD23 LEU A  88      -5.131  -2.327   7.684  1.00  0.00           H  
ATOM    808  N   TYR A  89      -3.738  -3.653   4.241  1.00  0.00           N  
ATOM    809  CA  TYR A  89      -3.434  -2.516   3.373  1.00  0.00           C  
ATOM    810  C   TYR A  89      -4.644  -2.106   2.542  1.00  0.00           C  
ATOM    811  O   TYR A  89      -4.862  -0.920   2.294  1.00  0.00           O  
ATOM    812  CB  TYR A  89      -2.267  -2.851   2.447  1.00  0.00           C  
ATOM    813  CG  TYR A  89      -0.912  -2.860   3.119  1.00  0.00           C  
ATOM    814  CD1 TYR A  89      -0.798  -2.940   4.500  1.00  0.00           C  
ATOM    815  CD2 TYR A  89       0.254  -2.802   2.368  1.00  0.00           C  
ATOM    816  CE1 TYR A  89       0.436  -2.961   5.116  1.00  0.00           C  
ATOM    817  CE2 TYR A  89       1.493  -2.821   2.973  1.00  0.00           C  
ATOM    818  CZ  TYR A  89       1.580  -2.900   4.349  1.00  0.00           C  
ATOM    819  OH  TYR A  89       2.815  -2.920   4.957  1.00  0.00           O  
ATOM    820  H   TYR A  89      -3.167  -4.454   4.191  1.00  0.00           H  
ATOM    821  HA  TYR A  89      -3.152  -1.688   4.006  1.00  0.00           H  
ATOM    822  HB2 TYR A  89      -2.428  -3.829   2.022  1.00  0.00           H  
ATOM    823  HB3 TYR A  89      -2.238  -2.122   1.655  1.00  0.00           H  
ATOM    824  HD1 TYR A  89      -1.696  -2.988   5.093  1.00  0.00           H  
ATOM    825  HD2 TYR A  89       0.181  -2.738   1.291  1.00  0.00           H  
ATOM    826  HE1 TYR A  89       0.497  -3.026   6.191  1.00  0.00           H  
ATOM    827  HE2 TYR A  89       2.389  -2.776   2.370  1.00  0.00           H  
ATOM    828  HH  TYR A  89       3.215  -3.794   4.840  1.00  0.00           H  
ATOM    829  N   PHE A  90      -5.405  -3.094   2.093  1.00  0.00           N  
ATOM    830  CA  PHE A  90      -6.575  -2.849   1.264  1.00  0.00           C  
ATOM    831  C   PHE A  90      -7.580  -1.947   1.979  1.00  0.00           C  
ATOM    832  O   PHE A  90      -8.166  -1.056   1.369  1.00  0.00           O  
ATOM    833  CB  PHE A  90      -7.250  -4.166   0.889  1.00  0.00           C  
ATOM    834  CG  PHE A  90      -8.373  -3.993  -0.088  1.00  0.00           C  
ATOM    835  CD1 PHE A  90      -8.115  -3.860  -1.440  1.00  0.00           C  
ATOM    836  CD2 PHE A  90      -9.687  -3.965   0.345  1.00  0.00           C  
ATOM    837  CE1 PHE A  90      -9.147  -3.703  -2.338  1.00  0.00           C  
ATOM    838  CE2 PHE A  90     -10.721  -3.806  -0.550  1.00  0.00           C  
ATOM    839  CZ  PHE A  90     -10.451  -3.676  -1.894  1.00  0.00           C  
ATOM    840  H   PHE A  90      -5.148  -4.026   2.295  1.00  0.00           H  
ATOM    841  HA  PHE A  90      -6.245  -2.355   0.360  1.00  0.00           H  
ATOM    842  HB2 PHE A  90      -6.519  -4.822   0.441  1.00  0.00           H  
ATOM    843  HB3 PHE A  90      -7.648  -4.629   1.779  1.00  0.00           H  
ATOM    844  HD1 PHE A  90      -7.093  -3.882  -1.787  1.00  0.00           H  
ATOM    845  HD2 PHE A  90      -9.900  -4.065   1.400  1.00  0.00           H  
ATOM    846  HE1 PHE A  90      -8.934  -3.600  -3.392  1.00  0.00           H  
ATOM    847  HE2 PHE A  90     -11.743  -3.789  -0.198  1.00  0.00           H  
ATOM    848  HZ  PHE A  90     -11.260  -3.549  -2.598  1.00  0.00           H  
ATOM    849  N   ASN A  91      -7.777  -2.187   3.270  1.00  0.00           N  
ATOM    850  CA  ASN A  91      -8.724  -1.396   4.057  1.00  0.00           C  
ATOM    851  C   ASN A  91      -8.310   0.070   4.074  1.00  0.00           C  
ATOM    852  O   ASN A  91      -9.121   0.957   3.802  1.00  0.00           O  
ATOM    853  CB  ASN A  91      -8.815  -1.924   5.491  1.00  0.00           C  
ATOM    854  CG  ASN A  91      -9.279  -3.364   5.552  1.00  0.00           C  
ATOM    855  OD1 ASN A  91     -10.371  -3.703   5.096  1.00  0.00           O  
ATOM    856  ND2 ASN A  91      -8.448  -4.224   6.114  1.00  0.00           N  
ATOM    857  H   ASN A  91      -7.273  -2.909   3.705  1.00  0.00           H  
ATOM    858  HA  ASN A  91      -9.694  -1.478   3.591  1.00  0.00           H  
ATOM    859  HB2 ASN A  91      -7.840  -1.864   5.953  1.00  0.00           H  
ATOM    860  HB3 ASN A  91      -9.510  -1.316   6.051  1.00  0.00           H  
ATOM    861 HD21 ASN A  91      -7.595  -3.882   6.457  1.00  0.00           H  
ATOM    862 HD22 ASN A  91      -8.713  -5.172   6.155  1.00  0.00           H  
ATOM    863  N   ASN A  92      -7.024   0.301   4.303  1.00  0.00           N  
ATOM    864  CA  ASN A  92      -6.463   1.648   4.280  1.00  0.00           C  
ATOM    865  C   ASN A  92      -6.574   2.251   2.887  1.00  0.00           C  
ATOM    866  O   ASN A  92      -6.847   3.441   2.734  1.00  0.00           O  
ATOM    867  CB  ASN A  92      -5.001   1.633   4.733  1.00  0.00           C  
ATOM    868  CG  ASN A  92      -4.848   1.328   6.211  1.00  0.00           C  
ATOM    869  OD1 ASN A  92      -5.389   2.036   7.061  1.00  0.00           O  
ATOM    870  ND2 ASN A  92      -4.114   0.276   6.532  1.00  0.00           N  
ATOM    871  H   ASN A  92      -6.423  -0.461   4.450  1.00  0.00           H  
ATOM    872  HA  ASN A  92      -7.037   2.257   4.965  1.00  0.00           H  
ATOM    873  HB2 ASN A  92      -4.466   0.880   4.174  1.00  0.00           H  
ATOM    874  HB3 ASN A  92      -4.561   2.600   4.534  1.00  0.00           H  
ATOM    875 HD21 ASN A  92      -3.712  -0.248   5.807  1.00  0.00           H  
ATOM    876 HD22 ASN A  92      -3.987   0.068   7.489  1.00  0.00           H  
ATOM    877  N   ALA A  93      -6.406   1.406   1.874  1.00  0.00           N  
ATOM    878  CA  ALA A  93      -6.518   1.830   0.485  1.00  0.00           C  
ATOM    879  C   ALA A  93      -7.925   2.332   0.179  1.00  0.00           C  
ATOM    880  O   ALA A  93      -8.097   3.383  -0.438  1.00  0.00           O  
ATOM    881  CB  ALA A  93      -6.147   0.685  -0.446  1.00  0.00           C  
ATOM    882  H   ALA A  93      -6.231   0.459   2.070  1.00  0.00           H  
ATOM    883  HA  ALA A  93      -5.817   2.636   0.326  1.00  0.00           H  
ATOM    884  HB1 ALA A  93      -5.107   0.427  -0.301  1.00  0.00           H  
ATOM    885  HB2 ALA A  93      -6.766  -0.172  -0.227  1.00  0.00           H  
ATOM    886  HB3 ALA A  93      -6.302   0.989  -1.471  1.00  0.00           H  
ATOM    887  N   ILE A  94      -8.924   1.608   0.677  1.00  0.00           N  
ATOM    888  CA  ILE A  94     -10.318   2.008   0.520  1.00  0.00           C  
ATOM    889  C   ILE A  94     -10.555   3.362   1.175  1.00  0.00           C  
ATOM    890  O   ILE A  94     -11.121   4.271   0.567  1.00  0.00           O  
ATOM    891  CB  ILE A  94     -11.279   0.974   1.145  1.00  0.00           C  
ATOM    892  CG1 ILE A  94     -11.176  -0.366   0.418  1.00  0.00           C  
ATOM    893  CG2 ILE A  94     -12.715   1.484   1.113  1.00  0.00           C  
ATOM    894  CD1 ILE A  94     -11.573  -0.293  -1.038  1.00  0.00           C  
ATOM    895  H   ILE A  94      -8.713   0.802   1.197  1.00  0.00           H  
ATOM    896  HA  ILE A  94     -10.531   2.084  -0.539  1.00  0.00           H  
ATOM    897  HB  ILE A  94     -10.998   0.833   2.178  1.00  0.00           H  
ATOM    898 HG12 ILE A  94     -10.155  -0.716   0.464  1.00  0.00           H  
ATOM    899 HG13 ILE A  94     -11.820  -1.084   0.904  1.00  0.00           H  
ATOM    900 HG21 ILE A  94     -12.763   2.385   0.520  1.00  0.00           H  
ATOM    901 HG22 ILE A  94     -13.355   0.731   0.678  1.00  0.00           H  
ATOM    902 HG23 ILE A  94     -13.043   1.697   2.120  1.00  0.00           H  
ATOM    903 HD11 ILE A  94     -11.796   0.731  -1.294  1.00  0.00           H  
ATOM    904 HD12 ILE A  94     -10.761  -0.650  -1.651  1.00  0.00           H  
ATOM    905 HD13 ILE A  94     -12.447  -0.908  -1.204  1.00  0.00           H  
ATOM    906  N   LYS A  95     -10.069   3.493   2.400  1.00  0.00           N  
ATOM    907  CA  LYS A  95     -10.190   4.739   3.149  1.00  0.00           C  
ATOM    908  C   LYS A  95      -9.512   5.887   2.411  1.00  0.00           C  
ATOM    909  O   LYS A  95     -10.056   6.987   2.333  1.00  0.00           O  
ATOM    910  CB  LYS A  95      -9.587   4.595   4.546  1.00  0.00           C  
ATOM    911  CG  LYS A  95     -10.309   3.590   5.425  1.00  0.00           C  
ATOM    912  CD  LYS A  95      -9.739   3.572   6.832  1.00  0.00           C  
ATOM    913  CE  LYS A  95     -10.486   2.591   7.718  1.00  0.00           C  
ATOM    914  NZ  LYS A  95     -10.048   2.675   9.136  1.00  0.00           N  
ATOM    915  H   LYS A  95      -9.600   2.732   2.808  1.00  0.00           H  
ATOM    916  HA  LYS A  95     -11.242   4.964   3.245  1.00  0.00           H  
ATOM    917  HB2 LYS A  95      -8.560   4.279   4.449  1.00  0.00           H  
ATOM    918  HB3 LYS A  95      -9.614   5.557   5.038  1.00  0.00           H  
ATOM    919  HG2 LYS A  95     -11.355   3.856   5.474  1.00  0.00           H  
ATOM    920  HG3 LYS A  95     -10.205   2.608   4.990  1.00  0.00           H  
ATOM    921  HD2 LYS A  95      -8.700   3.279   6.785  1.00  0.00           H  
ATOM    922  HD3 LYS A  95      -9.816   4.561   7.256  1.00  0.00           H  
ATOM    923  HE2 LYS A  95     -11.542   2.810   7.667  1.00  0.00           H  
ATOM    924  HE3 LYS A  95     -10.308   1.589   7.356  1.00  0.00           H  
ATOM    925  HZ1 LYS A  95      -9.075   3.047   9.191  1.00  0.00           H  
ATOM    926  HZ2 LYS A  95     -10.682   3.307   9.672  1.00  0.00           H  
ATOM    927  HZ3 LYS A  95     -10.068   1.730   9.574  1.00  0.00           H  
ATOM    928  N   LYS A  96      -8.335   5.616   1.863  1.00  0.00           N  
ATOM    929  CA  LYS A  96      -7.582   6.608   1.104  1.00  0.00           C  
ATOM    930  C   LYS A  96      -8.336   6.981  -0.173  1.00  0.00           C  
ATOM    931  O   LYS A  96      -8.358   8.140  -0.583  1.00  0.00           O  
ATOM    932  CB  LYS A  96      -6.185   6.057   0.780  1.00  0.00           C  
ATOM    933  CG  LYS A  96      -5.200   7.088   0.235  1.00  0.00           C  
ATOM    934  CD  LYS A  96      -5.430   7.367  -1.240  1.00  0.00           C  
ATOM    935  CE  LYS A  96      -4.417   8.355  -1.787  1.00  0.00           C  
ATOM    936  NZ  LYS A  96      -3.024   7.851  -1.656  1.00  0.00           N  
ATOM    937  H   LYS A  96      -7.957   4.713   1.970  1.00  0.00           H  
ATOM    938  HA  LYS A  96      -7.480   7.491   1.714  1.00  0.00           H  
ATOM    939  HB2 LYS A  96      -5.762   5.639   1.680  1.00  0.00           H  
ATOM    940  HB3 LYS A  96      -6.285   5.271   0.046  1.00  0.00           H  
ATOM    941  HG2 LYS A  96      -5.320   8.007   0.784  1.00  0.00           H  
ATOM    942  HG3 LYS A  96      -4.196   6.715   0.368  1.00  0.00           H  
ATOM    943  HD2 LYS A  96      -5.352   6.442  -1.790  1.00  0.00           H  
ATOM    944  HD3 LYS A  96      -6.422   7.778  -1.363  1.00  0.00           H  
ATOM    945  HE2 LYS A  96      -4.631   8.527  -2.832  1.00  0.00           H  
ATOM    946  HE3 LYS A  96      -4.509   9.283  -1.245  1.00  0.00           H  
ATOM    947  HZ1 LYS A  96      -3.023   6.813  -1.550  1.00  0.00           H  
ATOM    948  HZ2 LYS A  96      -2.471   8.101  -2.502  1.00  0.00           H  
ATOM    949  HZ3 LYS A  96      -2.568   8.276  -0.819  1.00  0.00           H  
ATOM    950  N   GLY A  97      -8.936   5.992  -0.806  1.00  0.00           N  
ATOM    951  CA  GLY A  97      -9.653   6.234  -2.037  1.00  0.00           C  
ATOM    952  C   GLY A  97     -10.927   7.032  -1.836  1.00  0.00           C  
ATOM    953  O   GLY A  97     -11.271   7.875  -2.666  1.00  0.00           O  
ATOM    954  H   GLY A  97      -8.866   5.077  -0.450  1.00  0.00           H  
ATOM    955  HA2 GLY A  97      -9.008   6.776  -2.713  1.00  0.00           H  
ATOM    956  HA3 GLY A  97      -9.904   5.285  -2.484  1.00  0.00           H  
ATOM    957  N   VAL A  98     -11.668   6.731  -0.774  1.00  0.00           N  
ATOM    958  CA  VAL A  98     -12.938   7.409  -0.531  1.00  0.00           C  
ATOM    959  C   VAL A  98     -12.720   8.870  -0.126  1.00  0.00           C  
ATOM    960  O   VAL A  98     -13.438   9.756  -0.587  1.00  0.00           O  
ATOM    961  CB  VAL A  98     -13.823   6.682   0.514  1.00  0.00           C  
ATOM    962  CG1 VAL A  98     -14.199   5.289   0.029  1.00  0.00           C  
ATOM    963  CG2 VAL A  98     -13.138   6.598   1.864  1.00  0.00           C  
ATOM    964  H   VAL A  98     -11.379   6.010  -0.169  1.00  0.00           H  
ATOM    965  HA  VAL A  98     -13.477   7.406  -1.469  1.00  0.00           H  
ATOM    966  HB  VAL A  98     -14.734   7.249   0.637  1.00  0.00           H  
ATOM    967 HG11 VAL A  98     -13.304   4.728  -0.196  1.00  0.00           H  
ATOM    968 HG12 VAL A  98     -14.760   4.777   0.797  1.00  0.00           H  
ATOM    969 HG13 VAL A  98     -14.805   5.370  -0.863  1.00  0.00           H  
ATOM    970 HG21 VAL A  98     -12.485   7.450   1.990  1.00  0.00           H  
ATOM    971 HG22 VAL A  98     -13.882   6.594   2.644  1.00  0.00           H  
ATOM    972 HG23 VAL A  98     -12.556   5.689   1.914  1.00  0.00           H  
ATOM    973  N   GLU A  99     -11.665   9.136   0.648  1.00  0.00           N  
ATOM    974  CA  GLU A  99     -11.317  10.512   1.002  1.00  0.00           C  
ATOM    975  C   GLU A  99     -10.842  11.274  -0.233  1.00  0.00           C  
ATOM    976  O   GLU A  99     -11.106  12.466  -0.380  1.00  0.00           O  
ATOM    977  CB  GLU A  99     -10.237  10.555   2.088  1.00  0.00           C  
ATOM    978  CG  GLU A  99      -9.012   9.725   1.757  1.00  0.00           C  
ATOM    979  CD  GLU A  99      -7.728  10.315   2.293  1.00  0.00           C  
ATOM    980  OE1 GLU A  99      -7.371  11.440   1.892  1.00  0.00           O  
ATOM    981  OE2 GLU A  99      -7.060   9.645   3.108  1.00  0.00           O  
ATOM    982  H   GLU A  99     -11.078   8.401   0.930  1.00  0.00           H  
ATOM    983  HA  GLU A  99     -12.211  10.989   1.379  1.00  0.00           H  
ATOM    984  HB2 GLU A  99      -9.922  11.579   2.228  1.00  0.00           H  
ATOM    985  HB3 GLU A  99     -10.657  10.187   3.011  1.00  0.00           H  
ATOM    986  HG2 GLU A  99      -9.139   8.742   2.187  1.00  0.00           H  
ATOM    987  HG3 GLU A  99      -8.934   9.635   0.681  1.00  0.00           H  
ATOM    988  N   ALA A 100     -10.141  10.571  -1.117  1.00  0.00           N  
ATOM    989  CA  ALA A 100      -9.637  11.159  -2.353  1.00  0.00           C  
ATOM    990  C   ALA A 100     -10.773  11.411  -3.337  1.00  0.00           C  
ATOM    991  O   ALA A 100     -10.598  12.098  -4.345  1.00  0.00           O  
ATOM    992  CB  ALA A 100      -8.584  10.256  -2.976  1.00  0.00           C  
ATOM    993  H   ALA A 100      -9.952   9.625  -0.930  1.00  0.00           H  
ATOM    994  HA  ALA A 100      -9.168  12.101  -2.107  1.00  0.00           H  
ATOM    995  HB1 ALA A 100      -8.434  10.538  -4.008  1.00  0.00           H  
ATOM    996  HB2 ALA A 100      -8.916   9.229  -2.927  1.00  0.00           H  
ATOM    997  HB3 ALA A 100      -7.654  10.359  -2.436  1.00  0.00           H  
ATOM    998  N   GLY A 101     -11.924  10.815  -3.060  1.00  0.00           N  
ATOM    999  CA  GLY A 101     -13.064  10.945  -3.940  1.00  0.00           C  
ATOM   1000  C   GLY A 101     -12.912  10.106  -5.188  1.00  0.00           C  
ATOM   1001  O   GLY A 101     -13.323  10.512  -6.273  1.00  0.00           O  
ATOM   1002  H   GLY A 101     -11.991  10.255  -2.257  1.00  0.00           H  
ATOM   1003  HA2 GLY A 101     -13.951  10.631  -3.412  1.00  0.00           H  
ATOM   1004  HA3 GLY A 101     -13.173  11.981  -4.224  1.00  0.00           H  
ATOM   1005  N   ASP A 102     -12.341   8.921  -5.028  1.00  0.00           N  
ATOM   1006  CA  ASP A 102     -12.156   8.006  -6.144  1.00  0.00           C  
ATOM   1007  C   ASP A 102     -13.026   6.775  -5.940  1.00  0.00           C  
ATOM   1008  O   ASP A 102     -13.639   6.268  -6.879  1.00  0.00           O  
ATOM   1009  CB  ASP A 102     -10.687   7.601  -6.283  1.00  0.00           C  
ATOM   1010  CG  ASP A 102     -10.299   7.336  -7.727  1.00  0.00           C  
ATOM   1011  OD1 ASP A 102     -11.139   7.549  -8.625  1.00  0.00           O  
ATOM   1012  OD2 ASP A 102      -9.169   6.861  -7.969  1.00  0.00           O  
ATOM   1013  H   ASP A 102     -12.046   8.648  -4.130  1.00  0.00           H  
ATOM   1014  HA  ASP A 102     -12.473   8.510  -7.045  1.00  0.00           H  
ATOM   1015  HB2 ASP A 102     -10.062   8.395  -5.901  1.00  0.00           H  
ATOM   1016  HB3 ASP A 102     -10.512   6.701  -5.710  1.00  0.00           H  
ATOM   1017  N   PHE A 103     -13.214   6.408  -4.679  1.00  0.00           N  
ATOM   1018  CA  PHE A 103     -14.174   5.372  -4.329  1.00  0.00           C  
ATOM   1019  C   PHE A 103     -15.206   5.949  -3.366  1.00  0.00           C  
ATOM   1020  O   PHE A 103     -14.941   6.950  -2.699  1.00  0.00           O  
ATOM   1021  CB  PHE A 103     -13.501   4.153  -3.678  1.00  0.00           C  
ATOM   1022  CG  PHE A 103     -12.176   3.768  -4.266  1.00  0.00           C  
ATOM   1023  CD1 PHE A 103     -12.071   3.357  -5.582  1.00  0.00           C  
ATOM   1024  CD2 PHE A 103     -11.036   3.797  -3.484  1.00  0.00           C  
ATOM   1025  CE1 PHE A 103     -10.848   2.988  -6.107  1.00  0.00           C  
ATOM   1026  CE2 PHE A 103      -9.811   3.433  -4.004  1.00  0.00           C  
ATOM   1027  CZ  PHE A 103      -9.715   3.028  -5.318  1.00  0.00           C  
ATOM   1028  H   PHE A 103     -12.806   6.940  -3.958  1.00  0.00           H  
ATOM   1029  HA  PHE A 103     -14.675   5.060  -5.233  1.00  0.00           H  
ATOM   1030  HB2 PHE A 103     -13.347   4.354  -2.630  1.00  0.00           H  
ATOM   1031  HB3 PHE A 103     -14.157   3.301  -3.777  1.00  0.00           H  
ATOM   1032  HD1 PHE A 103     -12.954   3.332  -6.201  1.00  0.00           H  
ATOM   1033  HD2 PHE A 103     -11.111   4.116  -2.454  1.00  0.00           H  
ATOM   1034  HE1 PHE A 103     -10.778   2.668  -7.134  1.00  0.00           H  
ATOM   1035  HE2 PHE A 103      -8.928   3.473  -3.380  1.00  0.00           H  
ATOM   1036  HZ  PHE A 103      -8.759   2.739  -5.727  1.00  0.00           H  
ATOM   1037  N   GLU A 104     -16.363   5.318  -3.290  1.00  0.00           N  
ATOM   1038  CA  GLU A 104     -17.426   5.743  -2.388  1.00  0.00           C  
ATOM   1039  C   GLU A 104     -18.138   4.512  -1.845  1.00  0.00           C  
ATOM   1040  O   GLU A 104     -18.234   3.501  -2.536  1.00  0.00           O  
ATOM   1041  CB  GLU A 104     -18.426   6.661  -3.112  1.00  0.00           C  
ATOM   1042  CG  GLU A 104     -19.113   6.005  -4.303  1.00  0.00           C  
ATOM   1043  CD  GLU A 104     -20.114   6.914  -4.991  1.00  0.00           C  
ATOM   1044  OE1 GLU A 104     -19.710   7.979  -5.495  1.00  0.00           O  
ATOM   1045  OE2 GLU A 104     -21.309   6.552  -5.046  1.00  0.00           O  
ATOM   1046  H   GLU A 104     -16.512   4.526  -3.847  1.00  0.00           H  
ATOM   1047  HA  GLU A 104     -16.977   6.281  -1.564  1.00  0.00           H  
ATOM   1048  HB2 GLU A 104     -19.187   6.970  -2.411  1.00  0.00           H  
ATOM   1049  HB3 GLU A 104     -17.899   7.535  -3.465  1.00  0.00           H  
ATOM   1050  HG2 GLU A 104     -18.359   5.720  -5.022  1.00  0.00           H  
ATOM   1051  HG3 GLU A 104     -19.629   5.123  -3.961  1.00  0.00           H  
ATOM   1052  N   GLN A 105     -18.555   4.550  -0.592  1.00  0.00           N  
ATOM   1053  CA  GLN A 105     -19.212   3.399   0.010  1.00  0.00           C  
ATOM   1054  C   GLN A 105     -20.683   3.688   0.280  1.00  0.00           C  
ATOM   1055  O   GLN A 105     -21.026   4.418   1.213  1.00  0.00           O  
ATOM   1056  CB  GLN A 105     -18.505   2.978   1.300  1.00  0.00           C  
ATOM   1057  CG  GLN A 105     -17.095   2.461   1.073  1.00  0.00           C  
ATOM   1058  CD  GLN A 105     -16.449   1.930   2.336  1.00  0.00           C  
ATOM   1059  OE1 GLN A 105     -16.887   0.927   2.903  1.00  0.00           O  
ATOM   1060  NE2 GLN A 105     -15.399   2.597   2.782  1.00  0.00           N  
ATOM   1061  H   GLN A 105     -18.415   5.366  -0.057  1.00  0.00           H  
ATOM   1062  HA  GLN A 105     -19.147   2.586  -0.700  1.00  0.00           H  
ATOM   1063  HB2 GLN A 105     -18.453   3.829   1.963  1.00  0.00           H  
ATOM   1064  HB3 GLN A 105     -19.080   2.197   1.774  1.00  0.00           H  
ATOM   1065  HG2 GLN A 105     -17.132   1.666   0.345  1.00  0.00           H  
ATOM   1066  HG3 GLN A 105     -16.488   3.269   0.689  1.00  0.00           H  
ATOM   1067 HE21 GLN A 105     -15.103   3.382   2.280  1.00  0.00           H  
ATOM   1068 HE22 GLN A 105     -14.958   2.275   3.605  1.00  0.00           H  
ATOM   1069  N   PRO A 106     -21.574   3.136  -0.558  1.00  0.00           N  
ATOM   1070  CA  PRO A 106     -23.023   3.328  -0.431  1.00  0.00           C  
ATOM   1071  C   PRO A 106     -23.571   2.782   0.884  1.00  0.00           C  
ATOM   1072  O   PRO A 106     -24.513   3.332   1.450  1.00  0.00           O  
ATOM   1073  CB  PRO A 106     -23.601   2.535  -1.610  1.00  0.00           C  
ATOM   1074  CG  PRO A 106     -22.524   1.588  -2.012  1.00  0.00           C  
ATOM   1075  CD  PRO A 106     -21.235   2.290  -1.714  1.00  0.00           C  
ATOM   1076  HA  PRO A 106     -23.293   4.367  -0.525  1.00  0.00           H  
ATOM   1077  HB2 PRO A 106     -24.489   2.010  -1.291  1.00  0.00           H  
ATOM   1078  HB3 PRO A 106     -23.850   3.213  -2.414  1.00  0.00           H  
ATOM   1079  HG2 PRO A 106     -22.598   0.678  -1.434  1.00  0.00           H  
ATOM   1080  HG3 PRO A 106     -22.598   1.372  -3.067  1.00  0.00           H  
ATOM   1081  HD2 PRO A 106     -20.465   1.576  -1.458  1.00  0.00           H  
ATOM   1082  HD3 PRO A 106     -20.929   2.893  -2.555  1.00  0.00           H  
ATOM   1083  N   LYS A 107     -22.991   1.679   1.347  1.00  0.00           N  
ATOM   1084  CA  LYS A 107     -23.436   1.037   2.578  1.00  0.00           C  
ATOM   1085  C   LYS A 107     -22.590   1.476   3.768  1.00  0.00           C  
ATOM   1086  O   LYS A 107     -22.437   0.729   4.740  1.00  0.00           O  
ATOM   1087  CB  LYS A 107     -23.377  -0.486   2.446  1.00  0.00           C  
ATOM   1088  CG  LYS A 107     -24.278  -1.048   1.358  1.00  0.00           C  
ATOM   1089  CD  LYS A 107     -24.262  -2.568   1.368  1.00  0.00           C  
ATOM   1090  CE  LYS A 107     -25.204  -3.148   0.325  1.00  0.00           C  
ATOM   1091  NZ  LYS A 107     -25.264  -4.630   0.403  1.00  0.00           N  
ATOM   1092  H   LYS A 107     -22.245   1.287   0.845  1.00  0.00           H  
ATOM   1093  HA  LYS A 107     -24.459   1.334   2.754  1.00  0.00           H  
ATOM   1094  HB2 LYS A 107     -22.361  -0.778   2.226  1.00  0.00           H  
ATOM   1095  HB3 LYS A 107     -23.670  -0.927   3.388  1.00  0.00           H  
ATOM   1096  HG2 LYS A 107     -25.288  -0.705   1.529  1.00  0.00           H  
ATOM   1097  HG3 LYS A 107     -23.929  -0.697   0.398  1.00  0.00           H  
ATOM   1098  HD2 LYS A 107     -23.260  -2.908   1.158  1.00  0.00           H  
ATOM   1099  HD3 LYS A 107     -24.565  -2.915   2.346  1.00  0.00           H  
ATOM   1100  HE2 LYS A 107     -26.195  -2.748   0.486  1.00  0.00           H  
ATOM   1101  HE3 LYS A 107     -24.857  -2.860  -0.658  1.00  0.00           H  
ATOM   1102  HZ1 LYS A 107     -25.160  -4.943   1.393  1.00  0.00           H  
ATOM   1103  HZ2 LYS A 107     -26.181  -4.974   0.041  1.00  0.00           H  
ATOM   1104  HZ3 LYS A 107     -24.497  -5.054  -0.163  1.00  0.00           H  
ATOM   1105  N   GLY A 108     -22.060   2.690   3.700  1.00  0.00           N  
ATOM   1106  CA  GLY A 108     -21.258   3.212   4.785  1.00  0.00           C  
ATOM   1107  C   GLY A 108     -19.878   2.604   4.841  1.00  0.00           C  
ATOM   1108  O   GLY A 108     -19.576   1.669   4.097  1.00  0.00           O  
ATOM   1109  H   GLY A 108     -22.217   3.239   2.905  1.00  0.00           H  
ATOM   1110  HA2 GLY A 108     -21.157   4.280   4.665  1.00  0.00           H  
ATOM   1111  HA3 GLY A 108     -21.761   3.015   5.718  1.00  0.00           H  
ATOM   1112  N   PRO A 109     -19.025   3.100   5.746  1.00  0.00           N  
ATOM   1113  CA  PRO A 109     -17.675   2.579   5.924  1.00  0.00           C  
ATOM   1114  C   PRO A 109     -17.695   1.135   6.393  1.00  0.00           C  
ATOM   1115  O   PRO A 109     -18.574   0.738   7.167  1.00  0.00           O  
ATOM   1116  CB  PRO A 109     -17.064   3.479   7.002  1.00  0.00           C  
ATOM   1117  CG  PRO A 109     -17.955   4.669   7.075  1.00  0.00           C  
ATOM   1118  CD  PRO A 109     -19.320   4.185   6.692  1.00  0.00           C  
ATOM   1119  HA  PRO A 109     -17.098   2.654   5.015  1.00  0.00           H  
ATOM   1120  HB2 PRO A 109     -17.040   2.948   7.942  1.00  0.00           H  
ATOM   1121  HB3 PRO A 109     -16.064   3.752   6.710  1.00  0.00           H  
ATOM   1122  HG2 PRO A 109     -17.966   5.058   8.083  1.00  0.00           H  
ATOM   1123  HG3 PRO A 109     -17.617   5.427   6.382  1.00  0.00           H  
ATOM   1124  HD2 PRO A 109     -19.847   3.815   7.559  1.00  0.00           H  
ATOM   1125  HD3 PRO A 109     -19.882   4.973   6.212  1.00  0.00           H  
ATOM   1126  N   ALA A 110     -16.776   0.348   5.850  1.00  0.00           N  
ATOM   1127  CA  ALA A 110     -16.701  -1.081   6.126  1.00  0.00           C  
ATOM   1128  C   ALA A 110     -17.903  -1.807   5.532  1.00  0.00           C  
ATOM   1129  O   ALA A 110     -18.456  -2.729   6.134  1.00  0.00           O  
ATOM   1130  CB  ALA A 110     -16.580  -1.346   7.625  1.00  0.00           C  
ATOM   1131  H   ALA A 110     -16.164   0.734   5.188  1.00  0.00           H  
ATOM   1132  HA  ALA A 110     -15.806  -1.457   5.651  1.00  0.00           H  
ATOM   1133  HB1 ALA A 110     -17.387  -1.990   7.941  1.00  0.00           H  
ATOM   1134  HB2 ALA A 110     -15.635  -1.825   7.831  1.00  0.00           H  
ATOM   1135  HB3 ALA A 110     -16.634  -0.410   8.161  1.00  0.00           H  
ATOM   1136  N   GLY A 111     -18.270  -1.407   4.322  1.00  0.00           N  
ATOM   1137  CA  GLY A 111     -19.364  -2.049   3.625  1.00  0.00           C  
ATOM   1138  C   GLY A 111     -19.021  -2.317   2.175  1.00  0.00           C  
ATOM   1139  O   GLY A 111     -17.890  -2.687   1.855  1.00  0.00           O  
ATOM   1140  H   GLY A 111     -17.779  -0.675   3.886  1.00  0.00           H  
ATOM   1141  HA2 GLY A 111     -19.591  -2.987   4.113  1.00  0.00           H  
ATOM   1142  HA3 GLY A 111     -20.232  -1.410   3.667  1.00  0.00           H  
ATOM   1143  N   ALA A 112     -19.979  -2.081   1.293  1.00  0.00           N  
ATOM   1144  CA  ALA A 112     -19.749  -2.226  -0.134  1.00  0.00           C  
ATOM   1145  C   ALA A 112     -19.166  -0.945  -0.710  1.00  0.00           C  
ATOM   1146  O   ALA A 112     -19.660   0.144  -0.428  1.00  0.00           O  
ATOM   1147  CB  ALA A 112     -21.040  -2.598  -0.851  1.00  0.00           C  
ATOM   1148  H   ALA A 112     -20.839  -1.737   1.606  1.00  0.00           H  
ATOM   1149  HA  ALA A 112     -19.038  -3.029  -0.275  1.00  0.00           H  
ATOM   1150  HB1 ALA A 112     -21.682  -3.145  -0.178  1.00  0.00           H  
ATOM   1151  HB2 ALA A 112     -21.542  -1.701  -1.180  1.00  0.00           H  
ATOM   1152  HB3 ALA A 112     -20.808  -3.216  -1.708  1.00  0.00           H  
ATOM   1153  N   VAL A 113     -18.143  -1.084  -1.540  1.00  0.00           N  
ATOM   1154  CA  VAL A 113     -17.540   0.059  -2.206  1.00  0.00           C  
ATOM   1155  C   VAL A 113     -18.098   0.187  -3.622  1.00  0.00           C  
ATOM   1156  O   VAL A 113     -18.613  -0.777  -4.187  1.00  0.00           O  
ATOM   1157  CB  VAL A 113     -15.992  -0.047  -2.257  1.00  0.00           C  
ATOM   1158  CG1 VAL A 113     -15.371   1.217  -2.849  1.00  0.00           C  
ATOM   1159  CG2 VAL A 113     -15.431  -0.308  -0.867  1.00  0.00           C  
ATOM   1160  H   VAL A 113     -17.829  -1.988  -1.765  1.00  0.00           H  
ATOM   1161  HA  VAL A 113     -17.801   0.945  -1.647  1.00  0.00           H  
ATOM   1162  HB  VAL A 113     -15.726  -0.882  -2.889  1.00  0.00           H  
ATOM   1163 HG11 VAL A 113     -15.655   2.071  -2.253  1.00  0.00           H  
ATOM   1164 HG12 VAL A 113     -14.294   1.125  -2.852  1.00  0.00           H  
ATOM   1165 HG13 VAL A 113     -15.725   1.356  -3.865  1.00  0.00           H  
ATOM   1166 HG21 VAL A 113     -16.190  -0.097  -0.129  1.00  0.00           H  
ATOM   1167 HG22 VAL A 113     -15.130  -1.341  -0.790  1.00  0.00           H  
ATOM   1168 HG23 VAL A 113     -14.578   0.332  -0.697  1.00  0.00           H  
ATOM   1169  N   LYS A 114     -18.078   1.396  -4.136  1.00  0.00           N  
ATOM   1170  CA  LYS A 114     -18.621   1.709  -5.439  1.00  0.00           C  
ATOM   1171  C   LYS A 114     -17.756   2.773  -6.086  1.00  0.00           C  
ATOM   1172  O   LYS A 114     -17.318   3.702  -5.412  1.00  0.00           O  
ATOM   1173  CB  LYS A 114     -20.054   2.220  -5.265  1.00  0.00           C  
ATOM   1174  CG  LYS A 114     -20.648   2.948  -6.464  1.00  0.00           C  
ATOM   1175  CD  LYS A 114     -20.558   2.138  -7.737  1.00  0.00           C  
ATOM   1176  CE  LYS A 114     -21.099   2.904  -8.931  1.00  0.00           C  
ATOM   1177  NZ  LYS A 114     -20.907   2.144 -10.190  1.00  0.00           N  
ATOM   1178  H   LYS A 114     -17.731   2.137  -3.585  1.00  0.00           H  
ATOM   1179  HA  LYS A 114     -18.620   0.815  -6.043  1.00  0.00           H  
ATOM   1180  HB2 LYS A 114     -20.695   1.386  -5.025  1.00  0.00           H  
ATOM   1181  HB3 LYS A 114     -20.049   2.906  -4.438  1.00  0.00           H  
ATOM   1182  HG2 LYS A 114     -21.689   3.146  -6.261  1.00  0.00           H  
ATOM   1183  HG3 LYS A 114     -20.122   3.878  -6.602  1.00  0.00           H  
ATOM   1184  HD2 LYS A 114     -19.529   1.891  -7.921  1.00  0.00           H  
ATOM   1185  HD3 LYS A 114     -21.130   1.230  -7.616  1.00  0.00           H  
ATOM   1186  HE2 LYS A 114     -22.152   3.082  -8.784  1.00  0.00           H  
ATOM   1187  HE3 LYS A 114     -20.580   3.848  -9.005  1.00  0.00           H  
ATOM   1188  HZ1 LYS A 114     -20.201   1.390 -10.048  1.00  0.00           H  
ATOM   1189  HZ2 LYS A 114     -21.806   1.710 -10.493  1.00  0.00           H  
ATOM   1190  HZ3 LYS A 114     -20.567   2.780 -10.945  1.00  0.00           H  
ATOM   1191  N   LEU A 115     -17.399   2.571  -7.349  1.00  0.00           N  
ATOM   1192  CA  LEU A 115     -16.565   3.519  -8.046  1.00  0.00           C  
ATOM   1193  C   LEU A 115     -17.187   4.914  -8.002  1.00  0.00           C  
ATOM   1194  O   LEU A 115     -18.284   5.127  -8.527  1.00  0.00           O  
ATOM   1195  CB  LEU A 115     -16.422   3.083  -9.495  1.00  0.00           C  
ATOM   1196  CG  LEU A 115     -14.998   2.996 -10.003  1.00  0.00           C  
ATOM   1197  CD1 LEU A 115     -14.345   4.369 -10.005  1.00  0.00           C  
ATOM   1198  CD2 LEU A 115     -14.206   2.028  -9.155  1.00  0.00           C  
ATOM   1199  H   LEU A 115     -17.629   1.724  -7.796  1.00  0.00           H  
ATOM   1200  HA  LEU A 115     -15.596   3.533  -7.564  1.00  0.00           H  
ATOM   1201  HB2 LEU A 115     -16.879   2.109  -9.600  1.00  0.00           H  
ATOM   1202  HB3 LEU A 115     -16.959   3.784 -10.115  1.00  0.00           H  
ATOM   1203  HG  LEU A 115     -15.015   2.621 -11.008  1.00  0.00           H  
ATOM   1204 HD11 LEU A 115     -14.923   5.039 -10.624  1.00  0.00           H  
ATOM   1205 HD12 LEU A 115     -14.314   4.750  -8.995  1.00  0.00           H  
ATOM   1206 HD13 LEU A 115     -13.340   4.290 -10.395  1.00  0.00           H  
ATOM   1207 HD21 LEU A 115     -14.775   1.788  -8.264  1.00  0.00           H  
ATOM   1208 HD22 LEU A 115     -14.021   1.125  -9.717  1.00  0.00           H  
ATOM   1209 HD23 LEU A 115     -13.267   2.480  -8.875  1.00  0.00           H  
ATOM   1210  N   ALA A 116     -16.477   5.858  -7.403  1.00  0.00           N  
ATOM   1211  CA  ALA A 116     -16.964   7.225  -7.312  1.00  0.00           C  
ATOM   1212  C   ALA A 116     -16.654   7.996  -8.583  1.00  0.00           C  
ATOM   1213  O   ALA A 116     -15.511   8.039  -9.042  1.00  0.00           O  
ATOM   1214  CB  ALA A 116     -16.366   7.933  -6.107  1.00  0.00           C  
ATOM   1215  H   ALA A 116     -15.595   5.636  -7.034  1.00  0.00           H  
ATOM   1216  HA  ALA A 116     -18.034   7.186  -7.182  1.00  0.00           H  
ATOM   1217  HB1 ALA A 116     -16.510   7.324  -5.226  1.00  0.00           H  
ATOM   1218  HB2 ALA A 116     -16.858   8.884  -5.971  1.00  0.00           H  
ATOM   1219  HB3 ALA A 116     -15.311   8.092  -6.268  1.00  0.00           H  
ATOM   1220  N   LYS A 117     -17.671   8.635  -9.128  1.00  0.00           N  
ATOM   1221  CA  LYS A 117     -17.520   9.455 -10.318  1.00  0.00           C  
ATOM   1222  C   LYS A 117     -18.187  10.801 -10.094  1.00  0.00           C  
ATOM   1223  O   LYS A 117     -17.626  11.849 -10.412  1.00  0.00           O  
ATOM   1224  CB  LYS A 117     -18.127   8.760 -11.540  1.00  0.00           C  
ATOM   1225  CG  LYS A 117     -17.410   7.478 -11.944  1.00  0.00           C  
ATOM   1226  CD  LYS A 117     -15.981   7.754 -12.384  1.00  0.00           C  
ATOM   1227  CE  LYS A 117     -15.261   6.478 -12.791  1.00  0.00           C  
ATOM   1228  NZ  LYS A 117     -15.857   5.858 -14.006  1.00  0.00           N  
ATOM   1229  H   LYS A 117     -18.553   8.575  -8.693  1.00  0.00           H  
ATOM   1230  HA  LYS A 117     -16.463   9.611 -10.482  1.00  0.00           H  
ATOM   1231  HB2 LYS A 117     -19.156   8.515 -11.325  1.00  0.00           H  
ATOM   1232  HB3 LYS A 117     -18.096   9.441 -12.379  1.00  0.00           H  
ATOM   1233  HG2 LYS A 117     -17.393   6.807 -11.099  1.00  0.00           H  
ATOM   1234  HG3 LYS A 117     -17.946   7.018 -12.761  1.00  0.00           H  
ATOM   1235  HD2 LYS A 117     -16.001   8.427 -13.228  1.00  0.00           H  
ATOM   1236  HD3 LYS A 117     -15.446   8.214 -11.567  1.00  0.00           H  
ATOM   1237  HE2 LYS A 117     -14.226   6.714 -12.991  1.00  0.00           H  
ATOM   1238  HE3 LYS A 117     -15.316   5.773 -11.975  1.00  0.00           H  
ATOM   1239  HZ1 LYS A 117     -16.894   5.816 -13.922  1.00  0.00           H  
ATOM   1240  HZ2 LYS A 117     -15.611   6.415 -14.851  1.00  0.00           H  
ATOM   1241  HZ3 LYS A 117     -15.492   4.886 -14.126  1.00  0.00           H  
ATOM   1242  N   LYS A 118     -19.346  10.765  -9.458  1.00  0.00           N  
ATOM   1243  CA  LYS A 118     -20.069  11.973  -9.101  1.00  0.00           C  
ATOM   1244  C   LYS A 118     -20.669  11.825  -7.713  1.00  0.00           C  
ATOM   1245  O   LYS A 118     -21.250  10.787  -7.394  1.00  0.00           O  
ATOM   1246  CB  LYS A 118     -21.186  12.260 -10.112  1.00  0.00           C  
ATOM   1247  CG  LYS A 118     -20.689  12.681 -11.485  1.00  0.00           C  
ATOM   1248  CD  LYS A 118     -19.962  14.016 -11.438  1.00  0.00           C  
ATOM   1249  CE  LYS A 118     -20.894  15.152 -11.038  1.00  0.00           C  
ATOM   1250  NZ  LYS A 118     -20.197  16.466 -11.051  1.00  0.00           N  
ATOM   1251  H   LYS A 118     -19.707   9.895  -9.177  1.00  0.00           H  
ATOM   1252  HA  LYS A 118     -19.371  12.794  -9.098  1.00  0.00           H  
ATOM   1253  HB2 LYS A 118     -21.785  11.369 -10.228  1.00  0.00           H  
ATOM   1254  HB3 LYS A 118     -21.811  13.049  -9.722  1.00  0.00           H  
ATOM   1255  HG2 LYS A 118     -20.010  11.927 -11.858  1.00  0.00           H  
ATOM   1256  HG3 LYS A 118     -21.535  12.764 -12.152  1.00  0.00           H  
ATOM   1257  HD2 LYS A 118     -19.160  13.953 -10.717  1.00  0.00           H  
ATOM   1258  HD3 LYS A 118     -19.552  14.227 -12.416  1.00  0.00           H  
ATOM   1259  HE2 LYS A 118     -21.720  15.184 -11.730  1.00  0.00           H  
ATOM   1260  HE3 LYS A 118     -21.265  14.961 -10.042  1.00  0.00           H  
ATOM   1261  HZ1 LYS A 118     -19.534  16.512 -11.854  1.00  0.00           H  
ATOM   1262  HZ2 LYS A 118     -20.892  17.240 -11.141  1.00  0.00           H  
ATOM   1263  HZ3 LYS A 118     -19.661  16.600 -10.166  1.00  0.00           H  
ATOM   1264  N   LYS A 119     -20.564  12.871  -6.907  1.00  0.00           N  
ATOM   1265  CA  LYS A 119     -21.159  12.872  -5.574  1.00  0.00           C  
ATOM   1266  C   LYS A 119     -22.666  13.101  -5.661  1.00  0.00           C  
ATOM   1267  O   LYS A 119     -23.198  14.072  -5.122  1.00  0.00           O  
ATOM   1268  CB  LYS A 119     -20.499  13.924  -4.675  1.00  0.00           C  
ATOM   1269  CG  LYS A 119     -19.311  13.392  -3.881  1.00  0.00           C  
ATOM   1270  CD  LYS A 119     -18.132  13.021  -4.768  1.00  0.00           C  
ATOM   1271  CE  LYS A 119     -17.467  14.250  -5.363  1.00  0.00           C  
ATOM   1272  NZ  LYS A 119     -16.243  13.899  -6.133  1.00  0.00           N  
ATOM   1273  H   LYS A 119     -20.120  13.686  -7.235  1.00  0.00           H  
ATOM   1274  HA  LYS A 119     -20.990  11.895  -5.145  1.00  0.00           H  
ATOM   1275  HB2 LYS A 119     -20.156  14.744  -5.291  1.00  0.00           H  
ATOM   1276  HB3 LYS A 119     -21.235  14.294  -3.977  1.00  0.00           H  
ATOM   1277  HG2 LYS A 119     -18.992  14.153  -3.185  1.00  0.00           H  
ATOM   1278  HG3 LYS A 119     -19.625  12.518  -3.333  1.00  0.00           H  
ATOM   1279  HD2 LYS A 119     -17.405  12.483  -4.176  1.00  0.00           H  
ATOM   1280  HD3 LYS A 119     -18.484  12.388  -5.572  1.00  0.00           H  
ATOM   1281  HE2 LYS A 119     -18.169  14.740  -6.022  1.00  0.00           H  
ATOM   1282  HE3 LYS A 119     -17.198  14.921  -4.560  1.00  0.00           H  
ATOM   1283  HZ1 LYS A 119     -16.191  12.868  -6.281  1.00  0.00           H  
ATOM   1284  HZ2 LYS A 119     -16.254  14.367  -7.063  1.00  0.00           H  
ATOM   1285  HZ3 LYS A 119     -15.392  14.205  -5.608  1.00  0.00           H  
ATOM   1286  N   SER A 120     -23.330  12.214  -6.380  1.00  0.00           N  
ATOM   1287  CA  SER A 120     -24.763  12.279  -6.593  1.00  0.00           C  
ATOM   1288  C   SER A 120     -25.533  11.960  -5.313  1.00  0.00           C  
ATOM   1289  O   SER A 120     -24.997  11.330  -4.396  1.00  0.00           O  
ATOM   1290  CB  SER A 120     -25.136  11.296  -7.700  1.00  0.00           C  
ATOM   1291  OG  SER A 120     -24.387  10.098  -7.572  1.00  0.00           O  
ATOM   1292  H   SER A 120     -22.832  11.473  -6.789  1.00  0.00           H  
ATOM   1293  HA  SER A 120     -25.010  13.280  -6.913  1.00  0.00           H  
ATOM   1294  HB2 SER A 120     -26.188  11.062  -7.632  1.00  0.00           H  
ATOM   1295  HB3 SER A 120     -24.925  11.741  -8.662  1.00  0.00           H  
ATOM   1296  HG  SER A 120     -24.141   9.779  -8.452  1.00  0.00           H  
ATOM   1297  N   PRO A 121     -26.789  12.429  -5.220  1.00  0.00           N  
ATOM   1298  CA  PRO A 121     -27.640  12.191  -4.051  1.00  0.00           C  
ATOM   1299  C   PRO A 121     -28.027  10.718  -3.896  1.00  0.00           C  
ATOM   1300  O   PRO A 121     -27.566   9.858  -4.655  1.00  0.00           O  
ATOM   1301  CB  PRO A 121     -28.883  13.040  -4.325  1.00  0.00           C  
ATOM   1302  CG  PRO A 121     -28.912  13.215  -5.801  1.00  0.00           C  
ATOM   1303  CD  PRO A 121     -27.479  13.227  -6.249  1.00  0.00           C  
ATOM   1304  HA  PRO A 121     -27.164  12.531  -3.142  1.00  0.00           H  
ATOM   1305  HB2 PRO A 121     -29.760  12.517  -3.975  1.00  0.00           H  
ATOM   1306  HB3 PRO A 121     -28.797  13.987  -3.819  1.00  0.00           H  
ATOM   1307  HG2 PRO A 121     -29.441  12.393  -6.260  1.00  0.00           H  
ATOM   1308  HG3 PRO A 121     -29.388  14.152  -6.047  1.00  0.00           H  
ATOM   1309  HD2 PRO A 121     -27.384  12.768  -7.221  1.00  0.00           H  
ATOM   1310  HD3 PRO A 121     -27.098  14.237  -6.270  1.00  0.00           H  
ATOM   1311  N   GLU A 122     -28.825  10.441  -2.866  1.00  0.00           N  
ATOM   1312  CA  GLU A 122     -29.228   9.081  -2.519  1.00  0.00           C  
ATOM   1313  C   GLU A 122     -28.018   8.246  -2.131  1.00  0.00           C  
ATOM   1314  O   GLU A 122     -27.993   7.028  -2.316  1.00  0.00           O  
ATOM   1315  CB  GLU A 122     -30.020   8.415  -3.649  1.00  0.00           C  
ATOM   1316  CG  GLU A 122     -31.462   8.889  -3.735  1.00  0.00           C  
ATOM   1317  CD  GLU A 122     -32.242   8.192  -4.830  1.00  0.00           C  
ATOM   1318  OE1 GLU A 122     -31.908   8.383  -6.019  1.00  0.00           O  
ATOM   1319  OE2 GLU A 122     -33.196   7.455  -4.513  1.00  0.00           O  
ATOM   1320  H   GLU A 122     -29.095  11.178  -2.271  1.00  0.00           H  
ATOM   1321  HA  GLU A 122     -29.867   9.156  -1.653  1.00  0.00           H  
ATOM   1322  HB2 GLU A 122     -29.537   8.631  -4.591  1.00  0.00           H  
ATOM   1323  HB3 GLU A 122     -30.022   7.345  -3.493  1.00  0.00           H  
ATOM   1324  HG2 GLU A 122     -31.948   8.695  -2.790  1.00  0.00           H  
ATOM   1325  HG3 GLU A 122     -31.466   9.952  -3.930  1.00  0.00           H  
ATOM   1326  N   VAL A 123     -27.098   8.897  -1.437  1.00  0.00           N  
ATOM   1327  CA  VAL A 123     -25.960   8.224  -0.833  1.00  0.00           C  
ATOM   1328  C   VAL A 123     -25.827   8.714   0.601  1.00  0.00           C  
ATOM   1329  O   VAL A 123     -24.818   9.298   0.997  1.00  0.00           O  
ATOM   1330  CB  VAL A 123     -24.639   8.472  -1.599  1.00  0.00           C  
ATOM   1331  CG1 VAL A 123     -23.542   7.549  -1.092  1.00  0.00           C  
ATOM   1332  CG2 VAL A 123     -24.830   8.295  -3.095  1.00  0.00           C  
ATOM   1333  H   VAL A 123     -27.249   9.846  -1.232  1.00  0.00           H  
ATOM   1334  HA  VAL A 123     -26.166   7.162  -0.825  1.00  0.00           H  
ATOM   1335  HB  VAL A 123     -24.328   9.492  -1.417  1.00  0.00           H  
ATOM   1336 HG11 VAL A 123     -23.899   6.530  -1.093  1.00  0.00           H  
ATOM   1337 HG12 VAL A 123     -22.679   7.629  -1.735  1.00  0.00           H  
ATOM   1338 HG13 VAL A 123     -23.268   7.833  -0.086  1.00  0.00           H  
ATOM   1339 HG21 VAL A 123     -25.877   8.140  -3.310  1.00  0.00           H  
ATOM   1340 HG22 VAL A 123     -24.484   9.180  -3.609  1.00  0.00           H  
ATOM   1341 HG23 VAL A 123     -24.263   7.439  -3.432  1.00  0.00           H  
ATOM   1342  N   LYS A 124     -26.912   8.576   1.339  1.00  0.00           N  
ATOM   1343  CA  LYS A 124     -26.984   9.073   2.705  1.00  0.00           C  
ATOM   1344  C   LYS A 124     -27.055   7.915   3.692  1.00  0.00           C  
ATOM   1345  O   LYS A 124     -27.818   7.936   4.661  1.00  0.00           O  
ATOM   1346  CB  LYS A 124     -28.175  10.032   2.874  1.00  0.00           C  
ATOM   1347  CG  LYS A 124     -29.495   9.508   2.330  1.00  0.00           C  
ATOM   1348  CD  LYS A 124     -30.550  10.603   2.274  1.00  0.00           C  
ATOM   1349  CE  LYS A 124     -31.827  10.114   1.607  1.00  0.00           C  
ATOM   1350  NZ  LYS A 124     -32.786  11.223   1.363  1.00  0.00           N  
ATOM   1351  H   LYS A 124     -27.703   8.138   0.943  1.00  0.00           H  
ATOM   1352  HA  LYS A 124     -26.073   9.620   2.895  1.00  0.00           H  
ATOM   1353  HB2 LYS A 124     -28.301  10.235   3.925  1.00  0.00           H  
ATOM   1354  HB3 LYS A 124     -27.946  10.958   2.366  1.00  0.00           H  
ATOM   1355  HG2 LYS A 124     -29.342   9.125   1.333  1.00  0.00           H  
ATOM   1356  HG3 LYS A 124     -29.849   8.712   2.971  1.00  0.00           H  
ATOM   1357  HD2 LYS A 124     -30.781  10.920   3.280  1.00  0.00           H  
ATOM   1358  HD3 LYS A 124     -30.159  11.436   1.712  1.00  0.00           H  
ATOM   1359  HE2 LYS A 124     -31.573   9.657   0.663  1.00  0.00           H  
ATOM   1360  HE3 LYS A 124     -32.294   9.378   2.248  1.00  0.00           H  
ATOM   1361  HZ1 LYS A 124     -32.870  11.824   2.211  1.00  0.00           H  
ATOM   1362  HZ2 LYS A 124     -32.458  11.810   0.567  1.00  0.00           H  
ATOM   1363  HZ3 LYS A 124     -33.729  10.842   1.131  1.00  0.00           H  
ATOM   1364  N   LYS A 125     -26.209   6.925   3.454  1.00  0.00           N  
ATOM   1365  CA  LYS A 125     -26.106   5.768   4.330  1.00  0.00           C  
ATOM   1366  C   LYS A 125     -24.645   5.524   4.677  1.00  0.00           C  
ATOM   1367  O   LYS A 125     -24.239   4.394   4.939  1.00  0.00           O  
ATOM   1368  CB  LYS A 125     -26.673   4.521   3.642  1.00  0.00           C  
ATOM   1369  CG  LYS A 125     -28.069   4.696   3.073  1.00  0.00           C  
ATOM   1370  CD  LYS A 125     -28.498   3.456   2.311  1.00  0.00           C  
ATOM   1371  CE  LYS A 125     -29.870   3.622   1.678  1.00  0.00           C  
ATOM   1372  NZ  LYS A 125     -30.273   2.399   0.939  1.00  0.00           N  
ATOM   1373  H   LYS A 125     -25.610   6.991   2.683  1.00  0.00           H  
ATOM   1374  HA  LYS A 125     -26.663   5.970   5.232  1.00  0.00           H  
ATOM   1375  HB2 LYS A 125     -26.015   4.241   2.834  1.00  0.00           H  
ATOM   1376  HB3 LYS A 125     -26.701   3.715   4.361  1.00  0.00           H  
ATOM   1377  HG2 LYS A 125     -28.762   4.870   3.884  1.00  0.00           H  
ATOM   1378  HG3 LYS A 125     -28.074   5.541   2.403  1.00  0.00           H  
ATOM   1379  HD2 LYS A 125     -27.780   3.257   1.532  1.00  0.00           H  
ATOM   1380  HD3 LYS A 125     -28.528   2.620   2.993  1.00  0.00           H  
ATOM   1381  HE2 LYS A 125     -30.593   3.820   2.456  1.00  0.00           H  
ATOM   1382  HE3 LYS A 125     -29.838   4.455   0.993  1.00  0.00           H  
ATOM   1383  HZ1 LYS A 125     -30.124   1.558   1.534  1.00  0.00           H  
ATOM   1384  HZ2 LYS A 125     -31.282   2.449   0.677  1.00  0.00           H  
ATOM   1385  HZ3 LYS A 125     -29.707   2.300   0.069  1.00  0.00           H  
ATOM   1386  N   GLU A 126     -23.846   6.580   4.602  1.00  0.00           N  
ATOM   1387  CA  GLU A 126     -22.406   6.470   4.805  1.00  0.00           C  
ATOM   1388  C   GLU A 126     -22.005   6.913   6.210  1.00  0.00           C  
ATOM   1389  O   GLU A 126     -20.835   6.831   6.582  1.00  0.00           O  
ATOM   1390  CB  GLU A 126     -21.665   7.297   3.753  1.00  0.00           C  
ATOM   1391  CG  GLU A 126     -21.963   8.783   3.830  1.00  0.00           C  
ATOM   1392  CD  GLU A 126     -21.292   9.587   2.736  1.00  0.00           C  
ATOM   1393  OE1 GLU A 126     -20.565   9.000   1.906  1.00  0.00           O  
ATOM   1394  OE2 GLU A 126     -21.498  10.817   2.701  1.00  0.00           O  
ATOM   1395  H   GLU A 126     -24.229   7.453   4.357  1.00  0.00           H  
ATOM   1396  HA  GLU A 126     -22.138   5.433   4.684  1.00  0.00           H  
ATOM   1397  HB2 GLU A 126     -20.601   7.158   3.883  1.00  0.00           H  
ATOM   1398  HB3 GLU A 126     -21.949   6.947   2.773  1.00  0.00           H  
ATOM   1399  HG2 GLU A 126     -23.030   8.929   3.754  1.00  0.00           H  
ATOM   1400  HG3 GLU A 126     -21.621   9.153   4.787  1.00  0.00           H  
ATOM   1401  N   LYS A 127     -22.982   7.404   6.968  1.00  0.00           N  
ATOM   1402  CA  LYS A 127     -22.769   7.902   8.329  1.00  0.00           C  
ATOM   1403  C   LYS A 127     -21.942   9.187   8.336  1.00  0.00           C  
ATOM   1404  O   LYS A 127     -22.470  10.263   8.611  1.00  0.00           O  
ATOM   1405  CB  LYS A 127     -22.085   6.857   9.223  1.00  0.00           C  
ATOM   1406  CG  LYS A 127     -21.894   7.337  10.658  1.00  0.00           C  
ATOM   1407  CD  LYS A 127     -20.604   6.819  11.276  1.00  0.00           C  
ATOM   1408  CE  LYS A 127     -20.623   5.313  11.473  1.00  0.00           C  
ATOM   1409  NZ  LYS A 127     -19.390   4.835  12.151  1.00  0.00           N  
ATOM   1410  H   LYS A 127     -23.885   7.461   6.585  1.00  0.00           H  
ATOM   1411  HA  LYS A 127     -23.741   8.123   8.743  1.00  0.00           H  
ATOM   1412  HB2 LYS A 127     -22.687   5.961   9.239  1.00  0.00           H  
ATOM   1413  HB3 LYS A 127     -21.112   6.624   8.811  1.00  0.00           H  
ATOM   1414  HG2 LYS A 127     -21.869   8.416  10.663  1.00  0.00           H  
ATOM   1415  HG3 LYS A 127     -22.729   6.995  11.253  1.00  0.00           H  
ATOM   1416  HD2 LYS A 127     -19.782   7.070  10.624  1.00  0.00           H  
ATOM   1417  HD3 LYS A 127     -20.461   7.295  12.234  1.00  0.00           H  
ATOM   1418  HE2 LYS A 127     -21.480   5.051  12.076  1.00  0.00           H  
ATOM   1419  HE3 LYS A 127     -20.702   4.837  10.507  1.00  0.00           H  
ATOM   1420  HZ1 LYS A 127     -18.737   5.631  12.314  1.00  0.00           H  
ATOM   1421  HZ2 LYS A 127     -19.627   4.407  13.070  1.00  0.00           H  
ATOM   1422  HZ3 LYS A 127     -18.906   4.122  11.562  1.00  0.00           H  
ATOM   1423  N   GLU A 128     -20.639   9.058   8.090  1.00  0.00           N  
ATOM   1424  CA  GLU A 128     -19.717  10.189   8.166  1.00  0.00           C  
ATOM   1425  C   GLU A 128     -18.450   9.937   7.355  1.00  0.00           C  
ATOM   1426  O   GLU A 128     -17.338  10.105   7.860  1.00  0.00           O  
ATOM   1427  CB  GLU A 128     -19.325  10.470   9.624  1.00  0.00           C  
ATOM   1428  CG  GLU A 128     -20.328  11.311  10.397  1.00  0.00           C  
ATOM   1429  CD  GLU A 128     -20.483  12.713   9.839  1.00  0.00           C  
ATOM   1430  OE1 GLU A 128     -19.807  13.046   8.842  1.00  0.00           O  
ATOM   1431  OE2 GLU A 128     -21.277  13.500  10.398  1.00  0.00           O  
ATOM   1432  H   GLU A 128     -20.280   8.164   7.898  1.00  0.00           H  
ATOM   1433  HA  GLU A 128     -20.219  11.055   7.767  1.00  0.00           H  
ATOM   1434  HB2 GLU A 128     -19.210   9.528  10.139  1.00  0.00           H  
ATOM   1435  HB3 GLU A 128     -18.375  10.988   9.634  1.00  0.00           H  
ATOM   1436  HG2 GLU A 128     -21.290  10.820  10.359  1.00  0.00           H  
ATOM   1437  HG3 GLU A 128     -20.004  11.383  11.425  1.00  0.00           H  
ATOM   1438  N   VAL A 129     -18.603   9.608   6.080  1.00  0.00           N  
ATOM   1439  CA  VAL A 129     -17.448   9.460   5.198  1.00  0.00           C  
ATOM   1440  C   VAL A 129     -17.004  10.837   4.689  1.00  0.00           C  
ATOM   1441  O   VAL A 129     -17.056  11.128   3.491  1.00  0.00           O  
ATOM   1442  CB  VAL A 129     -17.735   8.514   4.007  1.00  0.00           C  
ATOM   1443  CG1 VAL A 129     -16.469   8.261   3.194  1.00  0.00           C  
ATOM   1444  CG2 VAL A 129     -18.310   7.198   4.500  1.00  0.00           C  
ATOM   1445  H   VAL A 129     -19.505   9.550   5.702  1.00  0.00           H  
ATOM   1446  HA  VAL A 129     -16.644   9.035   5.783  1.00  0.00           H  
ATOM   1447  HB  VAL A 129     -18.463   8.983   3.364  1.00  0.00           H  
ATOM   1448 HG11 VAL A 129     -15.874   9.161   3.167  1.00  0.00           H  
ATOM   1449 HG12 VAL A 129     -15.901   7.467   3.656  1.00  0.00           H  
ATOM   1450 HG13 VAL A 129     -16.739   7.976   2.189  1.00  0.00           H  
ATOM   1451 HG21 VAL A 129     -19.055   7.392   5.258  1.00  0.00           H  
ATOM   1452 HG22 VAL A 129     -18.766   6.672   3.673  1.00  0.00           H  
ATOM   1453 HG23 VAL A 129     -17.518   6.594   4.917  1.00  0.00           H  
ATOM   1454  N   SER A 130     -16.666  11.710   5.627  1.00  0.00           N  
ATOM   1455  CA  SER A 130     -16.299  13.078   5.318  1.00  0.00           C  
ATOM   1456  C   SER A 130     -15.675  13.717   6.547  1.00  0.00           C  
ATOM   1457  O   SER A 130     -15.637  13.048   7.603  1.00  0.00           O  
ATOM   1458  CB  SER A 130     -17.532  13.870   4.881  1.00  0.00           C  
ATOM   1459  OG  SER A 130     -17.184  15.164   4.414  1.00  0.00           O  
ATOM   1460  OXT SER A 130     -15.230  14.878   6.460  1.00  0.00           O  
ATOM   1461  H   SER A 130     -16.708  11.436   6.571  1.00  0.00           H  
ATOM   1462  HA  SER A 130     -15.575  13.065   4.516  1.00  0.00           H  
ATOM   1463  HB2 SER A 130     -18.033  13.340   4.085  1.00  0.00           H  
ATOM   1464  HB3 SER A 130     -18.205  13.974   5.719  1.00  0.00           H  
ATOM   1465  HG  SER A 130     -16.424  15.491   4.924  1.00  0.00           H  
TER    1466      SER A 130                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
