
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  120 ( 1912),  selected  120 , name 2bo5_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 2bo5_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    F     1_A      -       -           -
LGA    A     2_A      -       -           -
LGA    K     3_A      -       -           -
LGA    L     4_A      -       -           -
LGA    V     5_A      -       -           -
LGA    R     6_A      -       -           -
LGA    P     7_A      -       -           -
LGA    P     8_A      -       -           -
LGA    V     9_A      -       -           -
LGA    Q    10_A      -       -           -
LGA    I    11_A      -       -           -
LGA    Y    12_A      -       -           -
LGA    G    13_A      -       -           -
LGA    I    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    G    16_A      -       -           -
LGA    R    17_A      -       -           -
LGA    Y    18_A      -       -           -
LGA    A    19_A      -       -           -
LGA    T    20_A      -       -           -
LGA    A    21_A      -       -           -
LGA    L    22_A      -       -           -
LGA    Y    23_A      -       -           -
LGA    S    24_A      -       -           -
LGA    A    25_A      -       -           -
LGA    A    26_A      -       -           -
LGA    S    27_A      -       -           -
LGA    K    28_A      -       -           -
LGA    Q    29_A      -       -           -
LGA    N    30_A      -       -           -
LGA    K    31_A      -       -           -
LGA    L    32_A      -       -           -
LGA    E    33_A      A       2          4.800
LGA    Q    34_A      K       3          1.853
LGA    V    35_A      C       4           -
LGA    -       -      P       5           -
LGA    -       -      I       6           -
LGA    -       -      C       7           -
LGA    -       -      G       8           -
LGA    -       -      S       9           -
LGA    E    36_A      P      10          4.906
LGA    K    37_A      L      11          3.067
LGA    E    38_A      K      12           #
LGA    L    39_A      W      13          1.457
LGA    -       -      E      14           -
LGA    L    40_A      E      15          2.586
LGA    R    41_A      L      16          1.861
LGA    V    42_A      I      17          2.129
LGA    G    43_A      E      18          2.201
LGA    Q    44_A      E      19          2.426
LGA    I    45_A      M      20          2.881
LGA    L    46_A      L      21          2.773
LGA    K    47_A      I      22          3.319
LGA    E    48_A      I      23          2.182
LGA    P    49_A      E      24          1.936
LGA    K    50_A      N      25          1.788
LGA    M    51_A      F      26          0.544
LGA    A    52_A      E      27          1.565
LGA    A    53_A      E      28          2.853
LGA    S    54_A      I      29          2.639
LGA    L    55_A      V      30          1.209
LGA    L    56_A      K      31          3.829
LGA    N    57_A      -       -           -
LGA    P    58_A      -       -           -
LGA    Y    59_A      -       -           -
LGA    V    60_A      -       -           -
LGA    K    61_A      -       -           -
LGA    R    62_A      -       -           -
LGA    S    63_A      -       -           -
LGA    V    64_A      -       -           -
LGA    K    65_A      D      32          1.894
LGA    V    66_A      R      33          1.780
LGA    K    67_A      E      34          1.418
LGA    S    68_A      R      35          1.452
LGA    L    69_A      F      36          1.931
LGA    S    70_A      L      37          1.845
LGA    D    71_A      A      38          1.313
LGA    M    72_A      Q      39          2.306
LGA    T    73_A      V      40          2.776
LGA    A    74_A      E      41          1.115
LGA    K    75_A      E      42          2.831
LGA    E    76_A      F      43          4.010
LGA    K    77_A      V      44           #
LGA    -       -      F      45           -
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    -       -      F      54           -
LGA    -       -      Y      55           -
LGA    F    78_A      G      56          4.223
LGA    -       -      K      57           -
LGA    -       -      T      58           -
LGA    S    79_A      L      59          3.640
LGA    P    80_A      P      60          2.447
LGA    L    81_A      R      61           #
LGA    -       -      R      62           -
LGA    T    82_A      E      63          3.393
LGA    S    83_A      A      64          0.924
LGA    N    84_A      E      65          1.697
LGA    L    85_A      K      66          1.524
LGA    I    86_A      V      67          0.650
LGA    N    87_A      F      68          0.767
LGA    L    88_A      E      69          0.935
LGA    L    89_A      L      70          0.844
LGA    A    90_A      L      71          0.745
LGA    E    91_A      N      72          1.727
LGA    N    92_A      D      73          3.643
LGA    G    93_A      F      74          2.430
LGA    R    94_A      K      75          5.345
LGA    L    95_A      G      76           -
LGA    T    96_A      G      77           #
LGA    N    97_A      I      78          1.794
LGA    -       -      D      79           -
LGA    -       -      W      80           -
LGA    -       -      E      81           -
LGA    -       -      N      82           -
LGA    -       -      K      83           -
LGA    T    98_A      R      84           #
LGA    P    99_A      V      85          2.434
LGA    A   100_A      K      86          3.641
LGA    V   101_A      L      87          3.539
LGA    I   102_A      K      88           -
LGA    S   103_A      -       -           -
LGA    A   104_A      -       -           -
LGA    F   105_A      -       -           -
LGA    S   106_A      -       -           -
LGA    T   107_A      -       -           -
LGA    M   108_A      -       -           -
LGA    M   109_A      -       -           -
LGA    S   110_A      -       -           -
LGA    V   111_A      -       -           -
LGA    H   112_A      -       -           -
LGA    R   113_A      -       -           -
LGA    G   114_A      -       -           -
LGA    E   115_A      -       -           -
LGA    V   116_A      -       -           -
LGA    P   117_A      -       -           -
LGA    C   118_A      -       -           -
LGA    T   119_A      -       -           -
LGA    V   120_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  120   87    5.0     54    2.59     5.56     41.515     2.009

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.749211 * X  +  -0.643188 * Y  +   0.158091 * Z  +  -5.608428
  Y_new =  -0.105891 * X  +   0.351937 * Y  +   0.930015 * Z  +   0.567014
  Z_new =  -0.653812 * X  +   0.680036 * Y  +  -0.331783 * Z  +  -1.988947 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.024709   -1.116884  [ DEG:   116.0073    -63.9927 ]
  Theta =   0.712612    2.428981  [ DEG:    40.8297    139.1703 ]
  Phi   =  -3.001185    0.140407  [ DEG:  -171.9553      8.0447 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bo5_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bo5_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  120   87   5.0   54   2.59    5.56  41.515
REMARK  ---------------------------------------------------------- 
MOLECULE 2bo5_A
HEADER    HYDROLASE                               07-APR-05   2BO5              
TITLE     BOVINE OLIGOMYCIN SENSITIVITY CONFERRAL PROTEIN N-TERMINAL            
TITLE    2 DOMAIN                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ATP SYNTHASE OLIGOMYCIN SENSITIVITY CONFERRAL              
COMPND   3 PROTEIN;                                                             
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: N-TERMINAL DOMAIN, RESIDUES 24-143;                        
COMPND   6 SYNONYM: OSCP;                                                       
COMPND   7 EC: 3.6.3.14;                                                        
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BOS TAURUS;                                     
SOURCE   3 ORGANISM_COMMON: BOVINE;                                             
SOURCE   4 ORGAN: HEART;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-10, PET-11;                           
SOURCE   8 OTHER_DETAILS: MITOCHONDRIAL                                         
KEYWDS    ATP SYNTHASE, PERIPHERAL STALK, OSCP, ALPHA-SUBUNIT, BETA-            
KEYWDS   2 SUBUNIT, NMR, PROTEIN-PROTEIN INTERACTIONS, CHEMICAL SHIFT           
KEYWDS   3 PERTURBATIONS, CHEMICAL SHIFT MAPPING, TITRATION, BINDING            
KEYWDS   4 INTERFACE, CF(1), HYDROGEN ION TRANSPORT, HYDROLASE, ION             
KEYWDS   5 TRANSPORT, MITOCHONDRION, TRANSIT PEPTIDE, TRANSPORT                 
EXPDTA    NMR, 44 STRUCTURES                                                    
AUTHOR    R.J.CARBAJO,F.A.KELLAS,M.J.RUNSWICK,M.G.MONTGOMERY,                   
AUTHOR   2 J.E.WALKER,D.NEUHAUS                                                 
REVDAT   1   17-AUG-05 2BO5    0                                                
JRNL        AUTH   R.J.CARBAJO,F.A.KELLAS,M.J.RUNSWICK,M.G.MONTGOMERY,          
JRNL        AUTH 2 J.E.WALKER,D.NEUHAUS                                         
JRNL        TITL   STRUCTURE OF THE F1-BINDING DOMAIN OF THE STATOR             
JRNL        TITL 2 OF BOVINE F1FO-ATPASE AND HOW IT BINDS AN                    
JRNL        TITL 3 ALPHA-SUBUNIT.                                               
JRNL        REF    J.MOL.BIOL.                   V. 351   824 2005              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2BO5 A    1   120  UNP    P13621   ATPO_BOVIN      24    143             
SEQRES   1 A  120  PHE ALA LYS LEU VAL ARG PRO PRO VAL GLN ILE TYR GLY          
SEQRES   2 A  120  ILE GLU GLY ARG TYR ALA THR ALA LEU TYR SER ALA ALA          
SEQRES   3 A  120  SER LYS GLN ASN LYS LEU GLU GLN VAL GLU LYS GLU LEU          
SEQRES   4 A  120  LEU ARG VAL GLY GLN ILE LEU LYS GLU PRO LYS MET ALA          
SEQRES   5 A  120  ALA SER LEU LEU ASN PRO TYR VAL LYS ARG SER VAL LYS          
SEQRES   6 A  120  VAL LYS SER LEU SER ASP MET THR ALA LYS GLU LYS PHE          
SEQRES   7 A  120  SER PRO LEU THR SER ASN LEU ILE ASN LEU LEU ALA GLU          
SEQRES   8 A  120  ASN GLY ARG LEU THR ASN THR PRO ALA VAL ILE SER ALA          
SEQRES   9 A  120  PHE SER THR MET MET SER VAL HIS ARG GLY GLU VAL PRO          
SEQRES  10 A  120  CYS THR VAL                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   PHE A   1     -28.527  25.430 -19.387  1.00  0.00           N  
ATOM      2  CA  PHE A   1     -28.374  25.138 -17.938  1.00  0.00           C  
ATOM      3  C   PHE A   1     -27.441  23.954 -17.710  1.00  0.00           C  
ATOM      4  O   PHE A   1     -26.893  23.391 -18.658  1.00  0.00           O  
ATOM      5  CB  PHE A   1     -29.755  24.841 -17.351  1.00  0.00           C  
ATOM      6  CG  PHE A   1     -30.440  26.051 -16.784  1.00  0.00           C  
ATOM      7  CD1 PHE A   1     -29.816  26.828 -15.821  1.00  0.00           C  
ATOM      8  CD2 PHE A   1     -31.707  26.413 -17.215  1.00  0.00           C  
ATOM      9  CE1 PHE A   1     -30.443  27.943 -15.297  1.00  0.00           C  
ATOM     10  CE2 PHE A   1     -32.339  27.527 -16.694  1.00  0.00           C  
ATOM     11  CZ  PHE A   1     -31.706  28.292 -15.734  1.00  0.00           C  
ATOM     12  H2  PHE A   1     -29.186  24.728 -19.783  1.00  0.00           H  
ATOM     13  HA  PHE A   1     -27.962  26.010 -17.453  1.00  0.00           H  
ATOM     14  HB2 PHE A   1     -30.388  24.436 -18.127  1.00  0.00           H  
ATOM     15  HB3 PHE A   1     -29.654  24.113 -16.559  1.00  0.00           H  
ATOM     16  HD1 PHE A   1     -28.828  26.556 -15.478  1.00  0.00           H  
ATOM     17  HD2 PHE A   1     -32.202  25.815 -17.965  1.00  0.00           H  
ATOM     18  HE1 PHE A   1     -29.946  28.540 -14.546  1.00  0.00           H  
ATOM     19  HE2 PHE A   1     -33.326  27.798 -17.038  1.00  0.00           H  
ATOM     20  HZ  PHE A   1     -32.198  29.163 -15.326  1.00  0.00           H  
ATOM     21  H1  PHE A   1     -28.906  26.394 -19.478  1.00  0.00           H  
ATOM     22  N   ALA A   2     -27.264  23.581 -16.447  1.00  0.00           N  
ATOM     23  CA  ALA A   2     -26.396  22.464 -16.095  1.00  0.00           C  
ATOM     24  C   ALA A   2     -24.961  22.720 -16.544  1.00  0.00           C  
ATOM     25  O   ALA A   2     -24.239  21.791 -16.908  1.00  0.00           O  
ATOM     26  CB  ALA A   2     -26.921  21.174 -16.708  1.00  0.00           C  
ATOM     27  H   ALA A   2     -27.727  24.069 -15.735  1.00  0.00           H  
ATOM     28  HA  ALA A   2     -26.411  22.355 -15.019  1.00  0.00           H  
ATOM     29  HB1 ALA A   2     -26.937  21.268 -17.783  1.00  0.00           H  
ATOM     30  HB2 ALA A   2     -26.277  20.354 -16.427  1.00  0.00           H  
ATOM     31  HB3 ALA A   2     -27.921  20.986 -16.348  1.00  0.00           H  
ATOM     32  N   LYS A   3     -24.555  23.984 -16.516  1.00  0.00           N  
ATOM     33  CA  LYS A   3     -23.205  24.362 -16.920  1.00  0.00           C  
ATOM     34  C   LYS A   3     -22.163  23.682 -16.039  1.00  0.00           C  
ATOM     35  O   LYS A   3     -21.498  22.737 -16.464  1.00  0.00           O  
ATOM     36  CB  LYS A   3     -23.036  25.881 -16.850  1.00  0.00           C  
ATOM     37  CG  LYS A   3     -23.406  26.594 -18.141  1.00  0.00           C  
ATOM     38  CD  LYS A   3     -24.838  26.293 -18.553  1.00  0.00           C  
ATOM     39  CE  LYS A   3     -25.148  26.847 -19.934  1.00  0.00           C  
ATOM     40  NZ  LYS A   3     -24.437  26.098 -21.006  1.00  0.00           N  
ATOM     41  H   LYS A   3     -25.176  24.680 -16.215  1.00  0.00           H  
ATOM     42  HA  LYS A   3     -23.063  24.040 -17.940  1.00  0.00           H  
ATOM     43  HB2 LYS A   3     -23.663  26.265 -16.060  1.00  0.00           H  
ATOM     44  HB3 LYS A   3     -22.005  26.107 -16.623  1.00  0.00           H  
ATOM     45  HG2 LYS A   3     -23.301  27.659 -17.996  1.00  0.00           H  
ATOM     46  HG3 LYS A   3     -22.738  26.268 -18.924  1.00  0.00           H  
ATOM     47  HD2 LYS A   3     -24.981  25.222 -18.565  1.00  0.00           H  
ATOM     48  HD3 LYS A   3     -25.511  26.741 -17.835  1.00  0.00           H  
ATOM     49  HE2 LYS A   3     -26.212  26.779 -20.104  1.00  0.00           H  
ATOM     50  HE3 LYS A   3     -24.844  27.883 -19.968  1.00  0.00           H  
ATOM     51  HZ1 LYS A   3     -23.593  25.632 -20.618  1.00  0.00           H  
ATOM     52  HZ2 LYS A   3     -25.064  25.372 -21.411  1.00  0.00           H  
ATOM     53  HZ3 LYS A   3     -24.144  26.748 -21.763  1.00  0.00           H  
ATOM     54  N   LEU A   4     -22.025  24.169 -14.811  1.00  0.00           N  
ATOM     55  CA  LEU A   4     -21.063  23.608 -13.869  1.00  0.00           C  
ATOM     56  C   LEU A   4     -19.640  23.733 -14.405  1.00  0.00           C  
ATOM     57  O   LEU A   4     -19.427  23.830 -15.614  1.00  0.00           O  
ATOM     58  CB  LEU A   4     -21.387  22.139 -13.590  1.00  0.00           C  
ATOM     59  CG  LEU A   4     -22.863  21.841 -13.323  1.00  0.00           C  
ATOM     60  CD1 LEU A   4     -23.163  20.370 -13.565  1.00  0.00           C  
ATOM     61  CD2 LEU A   4     -23.238  22.237 -11.903  1.00  0.00           C  
ATOM     62  H   LEU A   4     -22.584  24.923 -14.530  1.00  0.00           H  
ATOM     63  HA  LEU A   4     -21.137  24.165 -12.947  1.00  0.00           H  
ATOM     64  HB2 LEU A   4     -21.071  21.555 -14.442  1.00  0.00           H  
ATOM     65  HB3 LEU A   4     -20.818  21.824 -12.728  1.00  0.00           H  
ATOM     66  HG  LEU A   4     -23.470  22.422 -14.004  1.00  0.00           H  
ATOM     67 HD11 LEU A   4     -22.829  20.093 -14.555  1.00  0.00           H  
ATOM     68 HD12 LEU A   4     -22.647  19.772 -12.830  1.00  0.00           H  
ATOM     69 HD13 LEU A   4     -24.227  20.202 -13.484  1.00  0.00           H  
ATOM     70 HD21 LEU A   4     -22.390  22.082 -11.251  1.00  0.00           H  
ATOM     71 HD22 LEU A   4     -23.522  23.278 -11.882  1.00  0.00           H  
ATOM     72 HD23 LEU A   4     -24.066  21.631 -11.566  1.00  0.00           H  
ATOM     73  N   VAL A   5     -18.669  23.731 -13.498  1.00  0.00           N  
ATOM     74  CA  VAL A   5     -17.266  23.844 -13.879  1.00  0.00           C  
ATOM     75  C   VAL A   5     -16.517  22.544 -13.610  1.00  0.00           C  
ATOM     76  O   VAL A   5     -15.597  22.183 -14.342  1.00  0.00           O  
ATOM     77  CB  VAL A   5     -16.569  24.991 -13.123  1.00  0.00           C  
ATOM     78  CG1 VAL A   5     -17.006  26.339 -13.675  1.00  0.00           C  
ATOM     79  CG2 VAL A   5     -16.856  24.899 -11.632  1.00  0.00           C  
ATOM     80  H   VAL A   5     -18.901  23.651 -12.549  1.00  0.00           H  
ATOM     81  HA  VAL A   5     -17.224  24.061 -14.937  1.00  0.00           H  
ATOM     82  HB  VAL A   5     -15.503  24.896 -13.269  1.00  0.00           H  
ATOM     83 HG11 VAL A   5     -17.984  26.245 -14.125  1.00  0.00           H  
ATOM     84 HG12 VAL A   5     -17.046  27.061 -12.873  1.00  0.00           H  
ATOM     85 HG13 VAL A   5     -16.298  26.669 -14.421  1.00  0.00           H  
ATOM     86 HG21 VAL A   5     -16.818  23.865 -11.321  1.00  0.00           H  
ATOM     87 HG22 VAL A   5     -16.116  25.466 -11.087  1.00  0.00           H  
ATOM     88 HG23 VAL A   5     -17.838  25.300 -11.429  1.00  0.00           H  
ATOM     89  N   ARG A   6     -16.917  21.845 -12.553  1.00  0.00           N  
ATOM     90  CA  ARG A   6     -16.283  20.584 -12.186  1.00  0.00           C  
ATOM     91  C   ARG A   6     -14.798  20.786 -11.889  1.00  0.00           C  
ATOM     92  O   ARG A   6     -13.941  20.450 -12.706  1.00  0.00           O  
ATOM     93  CB  ARG A   6     -16.456  19.557 -13.307  1.00  0.00           C  
ATOM     94  CG  ARG A   6     -17.902  19.351 -13.725  1.00  0.00           C  
ATOM     95  CD  ARG A   6     -18.515  18.142 -13.038  1.00  0.00           C  
ATOM     96  NE  ARG A   6     -18.220  16.900 -13.749  1.00  0.00           N  
ATOM     97  CZ  ARG A   6     -18.901  15.768 -13.580  1.00  0.00           C  
ATOM     98  NH1 ARG A   6     -19.915  15.718 -12.725  1.00  0.00           N  
ATOM     99  NH2 ARG A   6     -18.566  14.685 -14.267  1.00  0.00           N  
ATOM    100  H   ARG A   6     -17.657  22.184 -12.006  1.00  0.00           H  
ATOM    101  HA  ARG A   6     -16.769  20.216 -11.295  1.00  0.00           H  
ATOM    102  HB2 ARG A   6     -15.898  19.886 -14.171  1.00  0.00           H  
ATOM    103  HB3 ARG A   6     -16.062  18.608 -12.975  1.00  0.00           H  
ATOM    104  HG2 ARG A   6     -18.473  20.229 -13.460  1.00  0.00           H  
ATOM    105  HG3 ARG A   6     -17.941  19.204 -14.795  1.00  0.00           H  
ATOM    106  HD2 ARG A   6     -18.118  18.074 -12.036  1.00  0.00           H  
ATOM    107  HD3 ARG A   6     -19.586  18.273 -12.992  1.00  0.00           H  
ATOM    108  HE  ARG A   6     -17.475  16.909 -14.387  1.00  0.00           H  
ATOM    109 HH11 ARG A   6     -20.172  16.531 -12.204  1.00  0.00           H  
ATOM    110 HH12 ARG A   6     -20.423  14.865 -12.604  1.00  0.00           H  
ATOM    111 HH21 ARG A   6     -17.803  14.718 -14.913  1.00  0.00           H  
ATOM    112 HH22 ARG A   6     -19.077  13.835 -14.141  1.00  0.00           H  
ATOM    113  N   PRO A   7     -14.474  21.342 -10.709  1.00  0.00           N  
ATOM    114  CA  PRO A   7     -13.086  21.589 -10.308  1.00  0.00           C  
ATOM    115  C   PRO A   7     -12.217  20.340 -10.430  1.00  0.00           C  
ATOM    116  O   PRO A   7     -12.716  19.217 -10.362  1.00  0.00           O  
ATOM    117  CB  PRO A   7     -13.207  22.014  -8.842  1.00  0.00           C  
ATOM    118  CG  PRO A   7     -14.586  22.566  -8.721  1.00  0.00           C  
ATOM    119  CD  PRO A   7     -15.435  21.773  -9.676  1.00  0.00           C  
ATOM    120  HA  PRO A   7     -12.645  22.390 -10.881  1.00  0.00           H  
ATOM    121  HB2 PRO A   7     -13.069  21.154  -8.203  1.00  0.00           H  
ATOM    122  HB3 PRO A   7     -12.463  22.761  -8.617  1.00  0.00           H  
ATOM    123  HG2 PRO A   7     -14.944  22.442  -7.709  1.00  0.00           H  
ATOM    124  HG3 PRO A   7     -14.589  23.611  -8.996  1.00  0.00           H  
ATOM    125  HD2 PRO A   7     -15.871  20.922  -9.176  1.00  0.00           H  
ATOM    126  HD3 PRO A   7     -16.206  22.397 -10.103  1.00  0.00           H  
ATOM    127  N   PRO A   8     -10.898  20.520 -10.612  1.00  0.00           N  
ATOM    128  CA  PRO A   8      -9.959  19.402 -10.744  1.00  0.00           C  
ATOM    129  C   PRO A   8      -9.766  18.651  -9.432  1.00  0.00           C  
ATOM    130  O   PRO A   8      -9.923  19.219  -8.351  1.00  0.00           O  
ATOM    131  CB  PRO A   8      -8.654  20.079 -11.169  1.00  0.00           C  
ATOM    132  CG  PRO A   8      -8.759  21.467 -10.639  1.00  0.00           C  
ATOM    133  CD  PRO A   8     -10.218  21.827 -10.705  1.00  0.00           C  
ATOM    134  HA  PRO A   8     -10.274  18.709 -11.511  1.00  0.00           H  
ATOM    135  HB2 PRO A   8      -7.815  19.553 -10.739  1.00  0.00           H  
ATOM    136  HB3 PRO A   8      -8.577  20.074 -12.247  1.00  0.00           H  
ATOM    137  HG2 PRO A   8      -8.411  21.497  -9.617  1.00  0.00           H  
ATOM    138  HG3 PRO A   8      -8.179  22.141 -11.253  1.00  0.00           H  
ATOM    139  HD2 PRO A   8     -10.488  22.461  -9.873  1.00  0.00           H  
ATOM    140  HD3 PRO A   8     -10.445  22.313 -11.642  1.00  0.00           H  
ATOM    141  N   VAL A   9      -9.422  17.371  -9.533  1.00  0.00           N  
ATOM    142  CA  VAL A   9      -9.207  16.542  -8.354  1.00  0.00           C  
ATOM    143  C   VAL A   9      -8.271  15.378  -8.663  1.00  0.00           C  
ATOM    144  O   VAL A   9      -8.466  14.656  -9.639  1.00  0.00           O  
ATOM    145  CB  VAL A   9     -10.536  15.986  -7.807  1.00  0.00           C  
ATOM    146  CG1 VAL A   9     -11.411  17.112  -7.279  1.00  0.00           C  
ATOM    147  CG2 VAL A   9     -11.264  15.193  -8.882  1.00  0.00           C  
ATOM    148  H   VAL A   9      -9.311  16.975 -10.422  1.00  0.00           H  
ATOM    149  HA  VAL A   9      -8.758  17.159  -7.589  1.00  0.00           H  
ATOM    150  HB  VAL A   9     -10.314  15.319  -6.987  1.00  0.00           H  
ATOM    151 HG11 VAL A   9     -10.810  17.788  -6.689  1.00  0.00           H  
ATOM    152 HG12 VAL A   9     -11.847  17.648  -8.110  1.00  0.00           H  
ATOM    153 HG13 VAL A   9     -12.197  16.699  -6.665  1.00  0.00           H  
ATOM    154 HG21 VAL A   9     -11.246  15.745  -9.810  1.00  0.00           H  
ATOM    155 HG22 VAL A   9     -10.775  14.240  -9.020  1.00  0.00           H  
ATOM    156 HG23 VAL A   9     -12.288  15.032  -8.578  1.00  0.00           H  
ATOM    157  N   GLN A  10      -7.256  15.204  -7.824  1.00  0.00           N  
ATOM    158  CA  GLN A  10      -6.289  14.128  -8.008  1.00  0.00           C  
ATOM    159  C   GLN A  10      -5.310  14.070  -6.839  1.00  0.00           C  
ATOM    160  O   GLN A  10      -4.960  12.990  -6.362  1.00  0.00           O  
ATOM    161  CB  GLN A  10      -5.524  14.319  -9.319  1.00  0.00           C  
ATOM    162  CG  GLN A  10      -4.909  15.701  -9.469  1.00  0.00           C  
ATOM    163  CD  GLN A  10      -4.486  15.999 -10.893  1.00  0.00           C  
ATOM    164  OE1 GLN A  10      -3.559  15.384 -11.420  1.00  0.00           O  
ATOM    165  NE2 GLN A  10      -5.166  16.948 -11.526  1.00  0.00           N  
ATOM    166  H   GLN A  10      -7.154  15.814  -7.063  1.00  0.00           H  
ATOM    167  HA  GLN A  10      -6.834  13.197  -8.052  1.00  0.00           H  
ATOM    168  HB2 GLN A  10      -4.731  13.588  -9.369  1.00  0.00           H  
ATOM    169  HB3 GLN A  10      -6.203  14.159 -10.144  1.00  0.00           H  
ATOM    170  HG2 GLN A  10      -5.636  16.439  -9.163  1.00  0.00           H  
ATOM    171  HG3 GLN A  10      -4.042  15.767  -8.829  1.00  0.00           H  
ATOM    172 HE21 GLN A  10      -5.893  17.397 -11.045  1.00  0.00           H  
ATOM    173 HE22 GLN A  10      -4.913  17.162 -12.449  1.00  0.00           H  
ATOM    174  N   ILE A  11      -4.872  15.239  -6.382  1.00  0.00           N  
ATOM    175  CA  ILE A  11      -3.934  15.321  -5.269  1.00  0.00           C  
ATOM    176  C   ILE A  11      -4.396  16.351  -4.245  1.00  0.00           C  
ATOM    177  O   ILE A  11      -4.981  17.375  -4.598  1.00  0.00           O  
ATOM    178  CB  ILE A  11      -2.521  15.660  -5.763  1.00  0.00           C  
ATOM    179  CG1 ILE A  11      -1.512  15.585  -4.614  1.00  0.00           C  
ATOM    180  CG2 ILE A  11      -2.495  17.034  -6.417  1.00  0.00           C  
ATOM    181  CD1 ILE A  11      -0.628  14.357  -4.667  1.00  0.00           C  
ATOM    182  H   ILE A  11      -5.188  16.065  -6.803  1.00  0.00           H  
ATOM    183  HA  ILE A  11      -3.903  14.351  -4.793  1.00  0.00           H  
ATOM    184  HB  ILE A  11      -2.257  14.928  -6.509  1.00  0.00           H  
ATOM    185 HG12 ILE A  11      -0.872  16.454  -4.646  1.00  0.00           H  
ATOM    186 HG13 ILE A  11      -2.044  15.570  -3.675  1.00  0.00           H  
ATOM    187 HG21 ILE A  11      -3.445  17.222  -6.896  1.00  0.00           H  
ATOM    188 HG22 ILE A  11      -2.316  17.788  -5.665  1.00  0.00           H  
ATOM    189 HG23 ILE A  11      -1.707  17.067  -7.154  1.00  0.00           H  
ATOM    190 HD11 ILE A  11      -1.245  13.473  -4.737  1.00  0.00           H  
ATOM    191 HD12 ILE A  11       0.018  14.416  -5.530  1.00  0.00           H  
ATOM    192 HD13 ILE A  11      -0.027  14.307  -3.771  1.00  0.00           H  
ATOM    193  N   TYR A  12      -4.165  16.050  -2.971  1.00  0.00           N  
ATOM    194  CA  TYR A  12      -4.597  16.924  -1.888  1.00  0.00           C  
ATOM    195  C   TYR A  12      -3.632  16.848  -0.708  1.00  0.00           C  
ATOM    196  O   TYR A  12      -2.930  17.813  -0.405  1.00  0.00           O  
ATOM    197  CB  TYR A  12      -6.014  16.527  -1.442  1.00  0.00           C  
ATOM    198  CG  TYR A  12      -6.804  15.807  -2.519  1.00  0.00           C  
ATOM    199  CD1 TYR A  12      -6.340  14.614  -3.067  1.00  0.00           C  
ATOM    200  CD2 TYR A  12      -7.993  16.330  -3.010  1.00  0.00           C  
ATOM    201  CE1 TYR A  12      -7.032  13.969  -4.069  1.00  0.00           C  
ATOM    202  CE2 TYR A  12      -8.698  15.685  -4.009  1.00  0.00           C  
ATOM    203  CZ  TYR A  12      -8.213  14.505  -4.537  1.00  0.00           C  
ATOM    204  OH  TYR A  12      -8.908  13.864  -5.536  1.00  0.00           O  
ATOM    205  H   TYR A  12      -3.722  15.203  -2.753  1.00  0.00           H  
ATOM    206  HA  TYR A  12      -4.616  17.936  -2.261  1.00  0.00           H  
ATOM    207  HB2 TYR A  12      -5.945  15.872  -0.586  1.00  0.00           H  
ATOM    208  HB3 TYR A  12      -6.560  17.417  -1.166  1.00  0.00           H  
ATOM    209  HD1 TYR A  12      -5.419  14.191  -2.696  1.00  0.00           H  
ATOM    210  HD2 TYR A  12      -8.370  17.255  -2.597  1.00  0.00           H  
ATOM    211  HE1 TYR A  12      -6.641  13.050  -4.484  1.00  0.00           H  
ATOM    212  HE2 TYR A  12      -9.623  16.106  -4.376  1.00  0.00           H  
ATOM    213  HH  TYR A  12      -8.348  13.778  -6.312  1.00  0.00           H  
ATOM    214  N   GLY A  13      -3.604  15.695  -0.046  1.00  0.00           N  
ATOM    215  CA  GLY A  13      -2.720  15.518   1.092  1.00  0.00           C  
ATOM    216  C   GLY A  13      -3.187  14.420   2.026  1.00  0.00           C  
ATOM    217  O   GLY A  13      -2.516  13.398   2.176  1.00  0.00           O  
ATOM    218  H   GLY A  13      -4.185  14.961  -0.333  1.00  0.00           H  
ATOM    219  HA2 GLY A  13      -1.733  15.271   0.730  1.00  0.00           H  
ATOM    220  HA3 GLY A  13      -2.669  16.446   1.641  1.00  0.00           H  
ATOM    221  N   ILE A  14      -4.337  14.629   2.657  1.00  0.00           N  
ATOM    222  CA  ILE A  14      -4.887  13.647   3.584  1.00  0.00           C  
ATOM    223  C   ILE A  14      -5.109  12.305   2.893  1.00  0.00           C  
ATOM    224  O   ILE A  14      -4.742  11.257   3.423  1.00  0.00           O  
ATOM    225  CB  ILE A  14      -6.214  14.139   4.205  1.00  0.00           C  
ATOM    226  CG1 ILE A  14      -6.635  13.230   5.368  1.00  0.00           C  
ATOM    227  CG2 ILE A  14      -7.310  14.218   3.149  1.00  0.00           C  
ATOM    228  CD1 ILE A  14      -7.185  11.885   4.939  1.00  0.00           C  
ATOM    229  H   ILE A  14      -4.826  15.464   2.498  1.00  0.00           H  
ATOM    230  HA  ILE A  14      -4.172  13.510   4.381  1.00  0.00           H  
ATOM    231  HB  ILE A  14      -6.052  15.137   4.584  1.00  0.00           H  
ATOM    232 HG12 ILE A  14      -5.779  13.049   6.000  1.00  0.00           H  
ATOM    233 HG13 ILE A  14      -7.399  13.732   5.946  1.00  0.00           H  
ATOM    234 HG21 ILE A  14      -6.955  14.788   2.304  1.00  0.00           H  
ATOM    235 HG22 ILE A  14      -7.573  13.221   2.827  1.00  0.00           H  
ATOM    236 HG23 ILE A  14      -8.180  14.701   3.569  1.00  0.00           H  
ATOM    237 HD11 ILE A  14      -7.351  11.884   3.873  1.00  0.00           H  
ATOM    238 HD12 ILE A  14      -6.477  11.110   5.194  1.00  0.00           H  
ATOM    239 HD13 ILE A  14      -8.119  11.700   5.449  1.00  0.00           H  
ATOM    240  N   GLU A  15      -5.702  12.345   1.705  1.00  0.00           N  
ATOM    241  CA  GLU A  15      -5.959  11.127   0.946  1.00  0.00           C  
ATOM    242  C   GLU A  15      -4.658  10.570   0.384  1.00  0.00           C  
ATOM    243  O   GLU A  15      -4.473   9.356   0.306  1.00  0.00           O  
ATOM    244  CB  GLU A  15      -6.954  11.401  -0.185  1.00  0.00           C  
ATOM    245  CG  GLU A  15      -8.349  10.869   0.095  1.00  0.00           C  
ATOM    246  CD  GLU A  15      -9.437  11.857  -0.278  1.00  0.00           C  
ATOM    247  OE1 GLU A  15      -9.810  12.681   0.583  1.00  0.00           O  
ATOM    248  OE2 GLU A  15      -9.915  11.807  -1.431  1.00  0.00           O  
ATOM    249  H   GLU A  15      -5.967  13.209   1.329  1.00  0.00           H  
ATOM    250  HA  GLU A  15      -6.384  10.400   1.622  1.00  0.00           H  
ATOM    251  HB2 GLU A  15      -7.021  12.468  -0.338  1.00  0.00           H  
ATOM    252  HB3 GLU A  15      -6.589  10.939  -1.091  1.00  0.00           H  
ATOM    253  HG2 GLU A  15      -8.496   9.963  -0.476  1.00  0.00           H  
ATOM    254  HG3 GLU A  15      -8.431  10.646   1.149  1.00  0.00           H  
ATOM    255  N   GLY A  16      -3.752  11.467   0.009  1.00  0.00           N  
ATOM    256  CA  GLY A  16      -2.473  11.044  -0.523  1.00  0.00           C  
ATOM    257  C   GLY A  16      -1.571  10.488   0.558  1.00  0.00           C  
ATOM    258  O   GLY A  16      -0.698   9.664   0.286  1.00  0.00           O  
ATOM    259  H   GLY A  16      -3.950  12.422   0.105  1.00  0.00           H  
ATOM    260  HA2 GLY A  16      -2.637  10.280  -1.271  1.00  0.00           H  
ATOM    261  HA3 GLY A  16      -1.986  11.890  -0.985  1.00  0.00           H  
ATOM    262  N   ARG A  17      -1.790  10.934   1.792  1.00  0.00           N  
ATOM    263  CA  ARG A  17      -0.997  10.471   2.923  1.00  0.00           C  
ATOM    264  C   ARG A  17      -1.353   9.032   3.276  1.00  0.00           C  
ATOM    265  O   ARG A  17      -0.542   8.311   3.851  1.00  0.00           O  
ATOM    266  CB  ARG A  17      -1.215  11.378   4.136  1.00  0.00           C  
ATOM    267  CG  ARG A  17      -0.102  11.292   5.167  1.00  0.00           C  
ATOM    268  CD  ARG A  17      -0.303  12.298   6.289  1.00  0.00           C  
ATOM    269  NE  ARG A  17       0.963  12.853   6.759  1.00  0.00           N  
ATOM    270  CZ  ARG A  17       1.079  13.632   7.833  1.00  0.00           C  
ATOM    271  NH1 ARG A  17       0.006  13.949   8.548  1.00  0.00           N  
ATOM    272  NH2 ARG A  17       2.268  14.095   8.191  1.00  0.00           N  
ATOM    273  H   ARG A  17      -2.506  11.587   1.948  1.00  0.00           H  
ATOM    274  HA  ARG A  17       0.044  10.508   2.635  1.00  0.00           H  
ATOM    275  HB2 ARG A  17      -1.285  12.401   3.797  1.00  0.00           H  
ATOM    276  HB3 ARG A  17      -2.142  11.101   4.615  1.00  0.00           H  
ATOM    277  HG2 ARG A  17      -0.089  10.297   5.587  1.00  0.00           H  
ATOM    278  HG3 ARG A  17       0.842  11.491   4.680  1.00  0.00           H  
ATOM    279  HD2 ARG A  17      -0.925  13.102   5.926  1.00  0.00           H  
ATOM    280  HD3 ARG A  17      -0.798  11.805   7.113  1.00  0.00           H  
ATOM    281  HE  ARG A  17       1.771  12.636   6.248  1.00  0.00           H  
ATOM    282 HH11 ARG A  17      -0.894  13.603   8.283  1.00  0.00           H  
ATOM    283 HH12 ARG A  17       0.100  14.534   9.355  1.00  0.00           H  
ATOM    284 HH21 ARG A  17       3.078  13.860   7.655  1.00  0.00           H  
ATOM    285 HH22 ARG A  17       2.354  14.681   8.997  1.00  0.00           H  
ATOM    286  N   TYR A  18      -2.566   8.613   2.920  1.00  0.00           N  
ATOM    287  CA  TYR A  18      -3.008   7.251   3.196  1.00  0.00           C  
ATOM    288  C   TYR A  18      -2.033   6.248   2.598  1.00  0.00           C  
ATOM    289  O   TYR A  18      -1.579   5.325   3.273  1.00  0.00           O  
ATOM    290  CB  TYR A  18      -4.409   7.019   2.623  1.00  0.00           C  
ATOM    291  CG  TYR A  18      -5.505   7.022   3.663  1.00  0.00           C  
ATOM    292  CD1 TYR A  18      -5.665   8.095   4.529  1.00  0.00           C  
ATOM    293  CD2 TYR A  18      -6.384   5.951   3.774  1.00  0.00           C  
ATOM    294  CE1 TYR A  18      -6.667   8.102   5.478  1.00  0.00           C  
ATOM    295  CE2 TYR A  18      -7.390   5.950   4.723  1.00  0.00           C  
ATOM    296  CZ  TYR A  18      -7.527   7.028   5.572  1.00  0.00           C  
ATOM    297  OH  TYR A  18      -8.527   7.032   6.517  1.00  0.00           O  
ATOM    298  H   TYR A  18      -3.173   9.230   2.457  1.00  0.00           H  
ATOM    299  HA  TYR A  18      -3.032   7.118   4.266  1.00  0.00           H  
ATOM    300  HB2 TYR A  18      -4.631   7.799   1.910  1.00  0.00           H  
ATOM    301  HB3 TYR A  18      -4.432   6.063   2.120  1.00  0.00           H  
ATOM    302  HD1 TYR A  18      -4.990   8.934   4.454  1.00  0.00           H  
ATOM    303  HD2 TYR A  18      -6.273   5.107   3.108  1.00  0.00           H  
ATOM    304  HE1 TYR A  18      -6.774   8.947   6.142  1.00  0.00           H  
ATOM    305  HE2 TYR A  18      -8.063   5.109   4.796  1.00  0.00           H  
ATOM    306  HH  TYR A  18      -8.352   6.352   7.171  1.00  0.00           H  
ATOM    307  N   ALA A  19      -1.712   6.444   1.326  1.00  0.00           N  
ATOM    308  CA  ALA A  19      -0.784   5.568   0.633  1.00  0.00           C  
ATOM    309  C   ALA A  19       0.624   5.737   1.182  1.00  0.00           C  
ATOM    310  O   ALA A  19       1.347   4.762   1.376  1.00  0.00           O  
ATOM    311  CB  ALA A  19      -0.811   5.850  -0.862  1.00  0.00           C  
ATOM    312  H   ALA A  19      -2.104   7.203   0.845  1.00  0.00           H  
ATOM    313  HA  ALA A  19      -1.102   4.548   0.792  1.00  0.00           H  
ATOM    314  HB1 ALA A  19      -1.366   6.759  -1.047  1.00  0.00           H  
ATOM    315  HB2 ALA A  19      -1.286   5.027  -1.375  1.00  0.00           H  
ATOM    316  HB3 ALA A  19       0.200   5.966  -1.226  1.00  0.00           H  
ATOM    317  N   THR A  20       1.009   6.983   1.436  1.00  0.00           N  
ATOM    318  CA  THR A  20       2.332   7.273   1.965  1.00  0.00           C  
ATOM    319  C   THR A  20       2.460   6.811   3.410  1.00  0.00           C  
ATOM    320  O   THR A  20       3.564   6.565   3.893  1.00  0.00           O  
ATOM    321  CB  THR A  20       2.650   8.764   1.848  1.00  0.00           C  
ATOM    322  OG1 THR A  20       1.515   9.490   1.409  1.00  0.00           O  
ATOM    323  CG2 THR A  20       3.777   9.045   0.881  1.00  0.00           C  
ATOM    324  H   THR A  20       0.387   7.721   1.264  1.00  0.00           H  
ATOM    325  HA  THR A  20       3.044   6.725   1.374  1.00  0.00           H  
ATOM    326  HB  THR A  20       2.941   9.142   2.817  1.00  0.00           H  
ATOM    327  HG1 THR A  20       1.339   9.282   0.488  1.00  0.00           H  
ATOM    328 HG21 THR A  20       3.645   8.442  -0.006  1.00  0.00           H  
ATOM    329 HG22 THR A  20       3.770  10.091   0.611  1.00  0.00           H  
ATOM    330 HG23 THR A  20       4.720   8.799   1.345  1.00  0.00           H  
ATOM    331  N   ALA A  21       1.330   6.675   4.098  1.00  0.00           N  
ATOM    332  CA  ALA A  21       1.348   6.223   5.480  1.00  0.00           C  
ATOM    333  C   ALA A  21       1.192   4.710   5.559  1.00  0.00           C  
ATOM    334  O   ALA A  21       1.220   4.129   6.643  1.00  0.00           O  
ATOM    335  CB  ALA A  21       0.267   6.921   6.289  1.00  0.00           C  
ATOM    336  H   ALA A  21       0.469   6.873   3.667  1.00  0.00           H  
ATOM    337  HA  ALA A  21       2.311   6.486   5.894  1.00  0.00           H  
ATOM    338  HB1 ALA A  21       0.568   7.940   6.488  1.00  0.00           H  
ATOM    339  HB2 ALA A  21       0.123   6.400   7.225  1.00  0.00           H  
ATOM    340  HB3 ALA A  21      -0.657   6.921   5.731  1.00  0.00           H  
ATOM    341  N   LEU A  22       1.060   4.074   4.400  1.00  0.00           N  
ATOM    342  CA  LEU A  22       0.939   2.626   4.337  1.00  0.00           C  
ATOM    343  C   LEU A  22       2.133   2.074   3.599  1.00  0.00           C  
ATOM    344  O   LEU A  22       2.718   1.065   3.995  1.00  0.00           O  
ATOM    345  CB  LEU A  22      -0.358   2.207   3.645  1.00  0.00           C  
ATOM    346  CG  LEU A  22      -0.596   0.695   3.598  1.00  0.00           C  
ATOM    347  CD1 LEU A  22      -1.939   0.344   4.221  1.00  0.00           C  
ATOM    348  CD2 LEU A  22      -0.516   0.186   2.166  1.00  0.00           C  
ATOM    349  H   LEU A  22       1.073   4.590   3.562  1.00  0.00           H  
ATOM    350  HA  LEU A  22       0.952   2.241   5.345  1.00  0.00           H  
ATOM    351  HB2 LEU A  22      -1.185   2.670   4.166  1.00  0.00           H  
ATOM    352  HB3 LEU A  22      -0.338   2.580   2.632  1.00  0.00           H  
ATOM    353  HG  LEU A  22       0.175   0.201   4.172  1.00  0.00           H  
ATOM    354 HD11 LEU A  22      -2.678   1.068   3.916  1.00  0.00           H  
ATOM    355 HD12 LEU A  22      -2.241  -0.640   3.892  1.00  0.00           H  
ATOM    356 HD13 LEU A  22      -1.850   0.351   5.297  1.00  0.00           H  
ATOM    357 HD21 LEU A  22      -1.019   0.880   1.509  1.00  0.00           H  
ATOM    358 HD22 LEU A  22       0.519   0.099   1.873  1.00  0.00           H  
ATOM    359 HD23 LEU A  22      -0.991  -0.781   2.102  1.00  0.00           H  
ATOM    360  N   TYR A  23       2.520   2.772   2.544  1.00  0.00           N  
ATOM    361  CA  TYR A  23       3.671   2.385   1.778  1.00  0.00           C  
ATOM    362  C   TYR A  23       4.933   2.823   2.521  1.00  0.00           C  
ATOM    363  O   TYR A  23       6.015   2.303   2.268  1.00  0.00           O  
ATOM    364  CB  TYR A  23       3.600   2.983   0.365  1.00  0.00           C  
ATOM    365  CG  TYR A  23       4.684   3.987   0.054  1.00  0.00           C  
ATOM    366  CD1 TYR A  23       6.001   3.581  -0.083  1.00  0.00           C  
ATOM    367  CD2 TYR A  23       4.393   5.336  -0.090  1.00  0.00           C  
ATOM    368  CE1 TYR A  23       7.003   4.484  -0.359  1.00  0.00           C  
ATOM    369  CE2 TYR A  23       5.387   6.250  -0.361  1.00  0.00           C  
ATOM    370  CZ  TYR A  23       6.691   5.822  -0.498  1.00  0.00           C  
ATOM    371  OH  TYR A  23       7.683   6.734  -0.766  1.00  0.00           O  
ATOM    372  H   TYR A  23       2.035   3.583   2.295  1.00  0.00           H  
ATOM    373  HA  TYR A  23       3.670   1.308   1.705  1.00  0.00           H  
ATOM    374  HB2 TYR A  23       3.681   2.183  -0.354  1.00  0.00           H  
ATOM    375  HB3 TYR A  23       2.647   3.473   0.239  1.00  0.00           H  
ATOM    376  HD1 TYR A  23       6.236   2.535   0.029  1.00  0.00           H  
ATOM    377  HD2 TYR A  23       3.369   5.672   0.006  1.00  0.00           H  
ATOM    378  HE1 TYR A  23       8.023   4.137  -0.473  1.00  0.00           H  
ATOM    379  HE2 TYR A  23       5.139   7.292  -0.463  1.00  0.00           H  
ATOM    380  HH  TYR A  23       7.682   6.943  -1.703  1.00  0.00           H  
ATOM    381  N   SER A  24       4.787   3.769   3.466  1.00  0.00           N  
ATOM    382  CA  SER A  24       5.930   4.232   4.248  1.00  0.00           C  
ATOM    383  C   SER A  24       6.695   3.029   4.781  1.00  0.00           C  
ATOM    384  O   SER A  24       7.921   2.966   4.697  1.00  0.00           O  
ATOM    385  CB  SER A  24       5.469   5.128   5.401  1.00  0.00           C  
ATOM    386  OG  SER A  24       6.378   5.078   6.488  1.00  0.00           O  
ATOM    387  H   SER A  24       3.896   4.147   3.651  1.00  0.00           H  
ATOM    388  HA  SER A  24       6.577   4.795   3.592  1.00  0.00           H  
ATOM    389  HB2 SER A  24       5.401   6.148   5.054  1.00  0.00           H  
ATOM    390  HB3 SER A  24       4.499   4.799   5.744  1.00  0.00           H  
ATOM    391  HG  SER A  24       7.262   5.278   6.174  1.00  0.00           H  
ATOM    392  N   ALA A  25       5.947   2.053   5.287  1.00  0.00           N  
ATOM    393  CA  ALA A  25       6.540   0.825   5.784  1.00  0.00           C  
ATOM    394  C   ALA A  25       7.003  -0.007   4.601  1.00  0.00           C  
ATOM    395  O   ALA A  25       8.033  -0.679   4.656  1.00  0.00           O  
ATOM    396  CB  ALA A  25       5.542   0.051   6.634  1.00  0.00           C  
ATOM    397  H   ALA A  25       4.972   2.151   5.293  1.00  0.00           H  
ATOM    398  HA  ALA A  25       7.392   1.079   6.395  1.00  0.00           H  
ATOM    399  HB1 ALA A  25       4.538   0.318   6.340  1.00  0.00           H  
ATOM    400  HB2 ALA A  25       5.691  -1.008   6.487  1.00  0.00           H  
ATOM    401  HB3 ALA A  25       5.691   0.295   7.675  1.00  0.00           H  
ATOM    402  N   ALA A  26       6.232   0.068   3.519  1.00  0.00           N  
ATOM    403  CA  ALA A  26       6.554  -0.653   2.295  1.00  0.00           C  
ATOM    404  C   ALA A  26       7.896  -0.195   1.735  1.00  0.00           C  
ATOM    405  O   ALA A  26       8.701  -1.010   1.289  1.00  0.00           O  
ATOM    406  CB  ALA A  26       5.460  -0.446   1.260  1.00  0.00           C  
ATOM    407  H   ALA A  26       5.427   0.636   3.543  1.00  0.00           H  
ATOM    408  HA  ALA A  26       6.609  -1.706   2.527  1.00  0.00           H  
ATOM    409  HB1 ALA A  26       4.496  -0.471   1.744  1.00  0.00           H  
ATOM    410  HB2 ALA A  26       5.596   0.511   0.779  1.00  0.00           H  
ATOM    411  HB3 ALA A  26       5.512  -1.230   0.519  1.00  0.00           H  
ATOM    412  N   SER A  27       8.131   1.115   1.764  1.00  0.00           N  
ATOM    413  CA  SER A  27       9.376   1.687   1.263  1.00  0.00           C  
ATOM    414  C   SER A  27      10.575   1.065   1.967  1.00  0.00           C  
ATOM    415  O   SER A  27      11.554   0.681   1.327  1.00  0.00           O  
ATOM    416  CB  SER A  27       9.384   3.203   1.468  1.00  0.00           C  
ATOM    417  OG  SER A  27      10.059   3.858   0.408  1.00  0.00           O  
ATOM    418  H   SER A  27       7.448   1.714   2.135  1.00  0.00           H  
ATOM    419  HA  SER A  27       9.440   1.476   0.203  1.00  0.00           H  
ATOM    420  HB2 SER A  27       8.368   3.565   1.508  1.00  0.00           H  
ATOM    421  HB3 SER A  27       9.885   3.436   2.397  1.00  0.00           H  
ATOM    422  HG  SER A  27      11.001   3.876   0.592  1.00  0.00           H  
ATOM    423  N   LYS A  28      10.488   0.960   3.291  1.00  0.00           N  
ATOM    424  CA  LYS A  28      11.563   0.373   4.084  1.00  0.00           C  
ATOM    425  C   LYS A  28      11.948  -0.993   3.530  1.00  0.00           C  
ATOM    426  O   LYS A  28      13.103  -1.409   3.616  1.00  0.00           O  
ATOM    427  CB  LYS A  28      11.135   0.244   5.548  1.00  0.00           C  
ATOM    428  CG  LYS A  28      11.427   1.483   6.378  1.00  0.00           C  
ATOM    429  CD  LYS A  28      10.723   1.431   7.723  1.00  0.00           C  
ATOM    430  CE  LYS A  28      11.384   2.354   8.735  1.00  0.00           C  
ATOM    431  NZ  LYS A  28      10.609   2.431  10.004  1.00  0.00           N  
ATOM    432  H   LYS A  28       9.679   1.278   3.744  1.00  0.00           H  
ATOM    433  HA  LYS A  28      12.417   1.029   4.022  1.00  0.00           H  
ATOM    434  HB2 LYS A  28      10.074   0.053   5.585  1.00  0.00           H  
ATOM    435  HB3 LYS A  28      11.659  -0.590   5.990  1.00  0.00           H  
ATOM    436  HG2 LYS A  28      12.491   1.552   6.543  1.00  0.00           H  
ATOM    437  HG3 LYS A  28      11.088   2.355   5.837  1.00  0.00           H  
ATOM    438  HD2 LYS A  28       9.694   1.733   7.593  1.00  0.00           H  
ATOM    439  HD3 LYS A  28      10.756   0.418   8.097  1.00  0.00           H  
ATOM    440  HE2 LYS A  28      12.374   1.980   8.950  1.00  0.00           H  
ATOM    441  HE3 LYS A  28      11.456   3.342   8.306  1.00  0.00           H  
ATOM    442  HZ1 LYS A  28      10.186   1.506  10.223  1.00  0.00           H  
ATOM    443  HZ2 LYS A  28      11.235   2.706  10.788  1.00  0.00           H  
ATOM    444  HZ3 LYS A  28       9.849   3.137   9.918  1.00  0.00           H  
ATOM    445  N   GLN A  29      10.969  -1.682   2.952  1.00  0.00           N  
ATOM    446  CA  GLN A  29      11.199  -2.996   2.370  1.00  0.00           C  
ATOM    447  C   GLN A  29      11.505  -2.872   0.882  1.00  0.00           C  
ATOM    448  O   GLN A  29      12.394  -3.549   0.368  1.00  0.00           O  
ATOM    449  CB  GLN A  29       9.979  -3.894   2.582  1.00  0.00           C  
ATOM    450  CG  GLN A  29      10.331  -5.353   2.822  1.00  0.00           C  
ATOM    451  CD  GLN A  29       9.167  -6.150   3.377  1.00  0.00           C  
ATOM    452  OE1 GLN A  29       8.777  -7.174   2.816  1.00  0.00           O  
ATOM    453  NE2 GLN A  29       8.605  -5.682   4.486  1.00  0.00           N  
ATOM    454  H   GLN A  29      10.070  -1.292   2.909  1.00  0.00           H  
ATOM    455  HA  GLN A  29      12.051  -3.436   2.866  1.00  0.00           H  
ATOM    456  HB2 GLN A  29       9.426  -3.534   3.436  1.00  0.00           H  
ATOM    457  HB3 GLN A  29       9.349  -3.838   1.706  1.00  0.00           H  
ATOM    458  HG2 GLN A  29      10.636  -5.796   1.885  1.00  0.00           H  
ATOM    459  HG3 GLN A  29      11.149  -5.401   3.525  1.00  0.00           H  
ATOM    460 HE21 GLN A  29       8.968  -4.860   4.877  1.00  0.00           H  
ATOM    461 HE22 GLN A  29       7.850  -6.177   4.866  1.00  0.00           H  
ATOM    462  N   ASN A  30      10.745  -2.004   0.200  1.00  0.00           N  
ATOM    463  CA  ASN A  30      10.894  -1.764  -1.238  1.00  0.00           C  
ATOM    464  C   ASN A  30       9.750  -2.422  -1.988  1.00  0.00           C  
ATOM    465  O   ASN A  30       9.908  -2.870  -3.124  1.00  0.00           O  
ATOM    466  CB  ASN A  30      12.237  -2.274  -1.776  1.00  0.00           C  
ATOM    467  CG  ASN A  30      12.561  -1.713  -3.146  1.00  0.00           C  
ATOM    468  OD1 ASN A  30      11.868  -0.827  -3.647  1.00  0.00           O  
ATOM    469  ND2 ASN A  30      13.620  -2.227  -3.761  1.00  0.00           N  
ATOM    470  H   ASN A  30      10.042  -1.512   0.683  1.00  0.00           H  
ATOM    471  HA  ASN A  30      10.837  -0.695  -1.396  1.00  0.00           H  
ATOM    472  HB2 ASN A  30      13.023  -1.986  -1.095  1.00  0.00           H  
ATOM    473  HB3 ASN A  30      12.203  -3.351  -1.846  1.00  0.00           H  
ATOM    474 HD21 ASN A  30      14.124  -2.931  -3.302  1.00  0.00           H  
ATOM    475 HD22 ASN A  30      13.852  -1.884  -4.649  1.00  0.00           H  
ATOM    476  N   LYS A  31       8.595  -2.477  -1.336  1.00  0.00           N  
ATOM    477  CA  LYS A  31       7.415  -3.081  -1.925  1.00  0.00           C  
ATOM    478  C   LYS A  31       6.636  -2.072  -2.763  1.00  0.00           C  
ATOM    479  O   LYS A  31       5.556  -2.383  -3.257  1.00  0.00           O  
ATOM    480  CB  LYS A  31       6.522  -3.669  -0.834  1.00  0.00           C  
ATOM    481  CG  LYS A  31       7.001  -5.020  -0.328  1.00  0.00           C  
ATOM    482  CD  LYS A  31       6.517  -6.153  -1.217  1.00  0.00           C  
ATOM    483  CE  LYS A  31       7.309  -7.427  -0.976  1.00  0.00           C  
ATOM    484  NZ  LYS A  31       6.565  -8.638  -1.421  1.00  0.00           N  
ATOM    485  H   LYS A  31       8.537  -2.103  -0.432  1.00  0.00           H  
ATOM    486  HA  LYS A  31       7.746  -3.880  -2.571  1.00  0.00           H  
ATOM    487  HB2 LYS A  31       6.493  -2.984  -0.000  1.00  0.00           H  
ATOM    488  HB3 LYS A  31       5.523  -3.789  -1.227  1.00  0.00           H  
ATOM    489  HG2 LYS A  31       8.081  -5.025  -0.313  1.00  0.00           H  
ATOM    490  HG3 LYS A  31       6.626  -5.172   0.674  1.00  0.00           H  
ATOM    491  HD2 LYS A  31       5.476  -6.344  -1.006  1.00  0.00           H  
ATOM    492  HD3 LYS A  31       6.630  -5.860  -2.250  1.00  0.00           H  
ATOM    493  HE2 LYS A  31       8.239  -7.367  -1.522  1.00  0.00           H  
ATOM    494  HE3 LYS A  31       7.518  -7.512   0.080  1.00  0.00           H  
ATOM    495  HZ1 LYS A  31       6.065  -8.443  -2.311  1.00  0.00           H  
ATOM    496  HZ2 LYS A  31       7.225  -9.427  -1.574  1.00  0.00           H  
ATOM    497  HZ3 LYS A  31       5.870  -8.915  -0.699  1.00  0.00           H  
ATOM    498  N   LEU A  32       7.191  -0.866  -2.936  1.00  0.00           N  
ATOM    499  CA  LEU A  32       6.544   0.168  -3.736  1.00  0.00           C  
ATOM    500  C   LEU A  32       5.962  -0.425  -5.014  1.00  0.00           C  
ATOM    501  O   LEU A  32       4.939   0.032  -5.513  1.00  0.00           O  
ATOM    502  CB  LEU A  32       7.561   1.259  -4.075  1.00  0.00           C  
ATOM    503  CG  LEU A  32       7.810   2.279  -2.961  1.00  0.00           C  
ATOM    504  CD1 LEU A  32       6.811   3.418  -3.070  1.00  0.00           C  
ATOM    505  CD2 LEU A  32       7.728   1.616  -1.591  1.00  0.00           C  
ATOM    506  H   LEU A  32       8.057  -0.668  -2.525  1.00  0.00           H  
ATOM    507  HA  LEU A  32       5.744   0.601  -3.152  1.00  0.00           H  
ATOM    508  HB2 LEU A  32       8.500   0.784  -4.317  1.00  0.00           H  
ATOM    509  HB3 LEU A  32       7.209   1.791  -4.946  1.00  0.00           H  
ATOM    510  HG  LEU A  32       8.802   2.691  -3.072  1.00  0.00           H  
ATOM    511 HD11 LEU A  32       6.486   3.511  -4.093  1.00  0.00           H  
ATOM    512 HD12 LEU A  32       5.958   3.213  -2.440  1.00  0.00           H  
ATOM    513 HD13 LEU A  32       7.278   4.339  -2.757  1.00  0.00           H  
ATOM    514 HD21 LEU A  32       8.408   0.780  -1.556  1.00  0.00           H  
ATOM    515 HD22 LEU A  32       7.999   2.329  -0.830  1.00  0.00           H  
ATOM    516 HD23 LEU A  32       6.720   1.270  -1.417  1.00  0.00           H  
ATOM    517  N   GLU A  33       6.616  -1.462  -5.523  1.00  0.00           N  
ATOM    518  CA  GLU A  33       6.154  -2.136  -6.731  1.00  0.00           C  
ATOM    519  C   GLU A  33       4.920  -2.982  -6.428  1.00  0.00           C  
ATOM    520  O   GLU A  33       4.002  -3.074  -7.240  1.00  0.00           O  
ATOM    521  CB  GLU A  33       7.265  -3.016  -7.309  1.00  0.00           C  
ATOM    522  CG  GLU A  33       8.196  -2.278  -8.256  1.00  0.00           C  
ATOM    523  CD  GLU A  33       8.792  -3.185  -9.314  1.00  0.00           C  
ATOM    524  OE1 GLU A  33       8.133  -3.399 -10.353  1.00  0.00           O  
ATOM    525  OE2 GLU A  33       9.919  -3.683  -9.102  1.00  0.00           O  
ATOM    526  H   GLU A  33       7.422  -1.789  -5.068  1.00  0.00           H  
ATOM    527  HA  GLU A  33       5.890  -1.378  -7.454  1.00  0.00           H  
ATOM    528  HB2 GLU A  33       7.854  -3.413  -6.496  1.00  0.00           H  
ATOM    529  HB3 GLU A  33       6.814  -3.836  -7.848  1.00  0.00           H  
ATOM    530  HG2 GLU A  33       7.640  -1.493  -8.749  1.00  0.00           H  
ATOM    531  HG3 GLU A  33       9.000  -1.841  -7.682  1.00  0.00           H  
ATOM    532  N   GLN A  34       4.908  -3.589  -5.247  1.00  0.00           N  
ATOM    533  CA  GLN A  34       3.791  -4.423  -4.816  1.00  0.00           C  
ATOM    534  C   GLN A  34       2.675  -3.581  -4.196  1.00  0.00           C  
ATOM    535  O   GLN A  34       1.571  -4.074  -3.970  1.00  0.00           O  
ATOM    536  CB  GLN A  34       4.270  -5.470  -3.809  1.00  0.00           C  
ATOM    537  CG  GLN A  34       4.737  -6.766  -4.454  1.00  0.00           C  
ATOM    538  CD  GLN A  34       3.845  -7.943  -4.112  1.00  0.00           C  
ATOM    539  OE1 GLN A  34       4.327  -9.044  -3.845  1.00  0.00           O  
ATOM    540  NE2 GLN A  34       2.537  -7.716  -4.120  1.00  0.00           N  
ATOM    541  H   GLN A  34       5.670  -3.468  -4.643  1.00  0.00           H  
ATOM    542  HA  GLN A  34       3.399  -4.927  -5.682  1.00  0.00           H  
ATOM    543  HB2 GLN A  34       5.093  -5.058  -3.244  1.00  0.00           H  
ATOM    544  HB3 GLN A  34       3.460  -5.701  -3.132  1.00  0.00           H  
ATOM    545  HG2 GLN A  34       4.742  -6.637  -5.526  1.00  0.00           H  
ATOM    546  HG3 GLN A  34       5.739  -6.980  -4.114  1.00  0.00           H  
ATOM    547 HE21 GLN A  34       2.224  -6.815  -4.342  1.00  0.00           H  
ATOM    548 HE22 GLN A  34       1.937  -8.460  -3.902  1.00  0.00           H  
ATOM    549  N   VAL A  35       2.967  -2.312  -3.920  1.00  0.00           N  
ATOM    550  CA  VAL A  35       1.979  -1.418  -3.325  1.00  0.00           C  
ATOM    551  C   VAL A  35       1.524  -0.355  -4.323  1.00  0.00           C  
ATOM    552  O   VAL A  35       0.421   0.181  -4.213  1.00  0.00           O  
ATOM    553  CB  VAL A  35       2.521  -0.705  -2.059  1.00  0.00           C  
ATOM    554  CG1 VAL A  35       1.427  -0.582  -1.012  1.00  0.00           C  
ATOM    555  CG2 VAL A  35       3.747  -1.418  -1.481  1.00  0.00           C  
ATOM    556  H   VAL A  35       3.864  -1.969  -4.118  1.00  0.00           H  
ATOM    557  HA  VAL A  35       1.119  -2.016  -3.045  1.00  0.00           H  
ATOM    558  HB  VAL A  35       2.819   0.292  -2.342  1.00  0.00           H  
ATOM    559 HG11 VAL A  35       0.869  -1.505  -0.965  1.00  0.00           H  
ATOM    560 HG12 VAL A  35       1.873  -0.381  -0.049  1.00  0.00           H  
ATOM    561 HG13 VAL A  35       0.763   0.227  -1.277  1.00  0.00           H  
ATOM    562 HG21 VAL A  35       3.733  -2.459  -1.767  1.00  0.00           H  
ATOM    563 HG22 VAL A  35       4.648  -0.953  -1.855  1.00  0.00           H  
ATOM    564 HG23 VAL A  35       3.733  -1.343  -0.403  1.00  0.00           H  
ATOM    565  N   GLU A  36       2.375  -0.060  -5.297  1.00  0.00           N  
ATOM    566  CA  GLU A  36       2.055   0.932  -6.318  1.00  0.00           C  
ATOM    567  C   GLU A  36       1.350   0.262  -7.483  1.00  0.00           C  
ATOM    568  O   GLU A  36       0.420   0.817  -8.066  1.00  0.00           O  
ATOM    569  CB  GLU A  36       3.319   1.638  -6.813  1.00  0.00           C  
ATOM    570  CG  GLU A  36       3.036   2.857  -7.675  1.00  0.00           C  
ATOM    571  CD  GLU A  36       4.210   3.231  -8.558  1.00  0.00           C  
ATOM    572  OE1 GLU A  36       5.075   2.362  -8.795  1.00  0.00           O  
ATOM    573  OE2 GLU A  36       4.265   4.394  -9.013  1.00  0.00           O  
ATOM    574  H   GLU A  36       3.231  -0.529  -5.336  1.00  0.00           H  
ATOM    575  HA  GLU A  36       1.390   1.660  -5.878  1.00  0.00           H  
ATOM    576  HB2 GLU A  36       3.898   1.954  -5.958  1.00  0.00           H  
ATOM    577  HB3 GLU A  36       3.903   0.940  -7.394  1.00  0.00           H  
ATOM    578  HG2 GLU A  36       2.184   2.647  -8.305  1.00  0.00           H  
ATOM    579  HG3 GLU A  36       2.808   3.694  -7.030  1.00  0.00           H  
ATOM    580  N   LYS A  37       1.785  -0.951  -7.798  1.00  0.00           N  
ATOM    581  CA  LYS A  37       1.178  -1.711  -8.873  1.00  0.00           C  
ATOM    582  C   LYS A  37      -0.160  -2.244  -8.402  1.00  0.00           C  
ATOM    583  O   LYS A  37      -1.118  -2.318  -9.173  1.00  0.00           O  
ATOM    584  CB  LYS A  37       2.085  -2.861  -9.315  1.00  0.00           C  
ATOM    585  CG  LYS A  37       3.443  -2.404  -9.822  1.00  0.00           C  
ATOM    586  CD  LYS A  37       3.362  -1.896 -11.253  1.00  0.00           C  
ATOM    587  CE  LYS A  37       4.580  -2.311 -12.060  1.00  0.00           C  
ATOM    588  NZ  LYS A  37       4.302  -2.317 -13.523  1.00  0.00           N  
ATOM    589  H   LYS A  37       2.515  -1.350  -7.280  1.00  0.00           H  
ATOM    590  HA  LYS A  37       1.012  -1.042  -9.704  1.00  0.00           H  
ATOM    591  HB2 LYS A  37       2.240  -3.525  -8.478  1.00  0.00           H  
ATOM    592  HB3 LYS A  37       1.594  -3.405 -10.108  1.00  0.00           H  
ATOM    593  HG2 LYS A  37       3.803  -1.607  -9.188  1.00  0.00           H  
ATOM    594  HG3 LYS A  37       4.129  -3.237  -9.783  1.00  0.00           H  
ATOM    595  HD2 LYS A  37       2.477  -2.304 -11.719  1.00  0.00           H  
ATOM    596  HD3 LYS A  37       3.300  -0.818 -11.238  1.00  0.00           H  
ATOM    597  HE2 LYS A  37       5.383  -1.617 -11.860  1.00  0.00           H  
ATOM    598  HE3 LYS A  37       4.878  -3.303 -11.755  1.00  0.00           H  
ATOM    599  HZ1 LYS A  37       3.966  -1.381 -13.827  1.00  0.00           H  
ATOM    600  HZ2 LYS A  37       5.166  -2.551 -14.051  1.00  0.00           H  
ATOM    601  HZ3 LYS A  37       3.571  -3.025 -13.744  1.00  0.00           H  
ATOM    602  N   GLU A  38      -0.230  -2.587  -7.119  1.00  0.00           N  
ATOM    603  CA  GLU A  38      -1.462  -3.076  -6.548  1.00  0.00           C  
ATOM    604  C   GLU A  38      -2.481  -1.946  -6.495  1.00  0.00           C  
ATOM    605  O   GLU A  38      -3.606  -2.089  -6.969  1.00  0.00           O  
ATOM    606  CB  GLU A  38      -1.197  -3.630  -5.153  1.00  0.00           C  
ATOM    607  CG  GLU A  38      -0.807  -5.099  -5.145  1.00  0.00           C  
ATOM    608  CD  GLU A  38       0.351  -5.403  -6.078  1.00  0.00           C  
ATOM    609  OE1 GLU A  38       0.232  -5.109  -7.287  1.00  0.00           O  
ATOM    610  OE2 GLU A  38       1.374  -5.935  -5.601  1.00  0.00           O  
ATOM    611  H   GLU A  38       0.561  -2.489  -6.536  1.00  0.00           H  
ATOM    612  HA  GLU A  38      -1.844  -3.865  -7.180  1.00  0.00           H  
ATOM    613  HB2 GLU A  38      -0.397  -3.063  -4.700  1.00  0.00           H  
ATOM    614  HB3 GLU A  38      -2.086  -3.511  -4.563  1.00  0.00           H  
ATOM    615  HG2 GLU A  38      -0.519  -5.378  -4.144  1.00  0.00           H  
ATOM    616  HG3 GLU A  38      -1.660  -5.686  -5.449  1.00  0.00           H  
ATOM    617  N   LEU A  39      -2.072  -0.813  -5.931  1.00  0.00           N  
ATOM    618  CA  LEU A  39      -2.946   0.352  -5.830  1.00  0.00           C  
ATOM    619  C   LEU A  39      -3.623   0.639  -7.165  1.00  0.00           C  
ATOM    620  O   LEU A  39      -4.760   1.110  -7.207  1.00  0.00           O  
ATOM    621  CB  LEU A  39      -2.151   1.575  -5.368  1.00  0.00           C  
ATOM    622  CG  LEU A  39      -2.168   1.827  -3.860  1.00  0.00           C  
ATOM    623  CD1 LEU A  39      -1.405   3.099  -3.523  1.00  0.00           C  
ATOM    624  CD2 LEU A  39      -3.598   1.910  -3.350  1.00  0.00           C  
ATOM    625  H   LEU A  39      -1.158  -0.755  -5.584  1.00  0.00           H  
ATOM    626  HA  LEU A  39      -3.707   0.131  -5.096  1.00  0.00           H  
ATOM    627  HB2 LEU A  39      -1.124   1.449  -5.680  1.00  0.00           H  
ATOM    628  HB3 LEU A  39      -2.554   2.448  -5.860  1.00  0.00           H  
ATOM    629  HG  LEU A  39      -1.680   1.003  -3.359  1.00  0.00           H  
ATOM    630 HD11 LEU A  39      -0.555   3.194  -4.182  1.00  0.00           H  
ATOM    631 HD12 LEU A  39      -2.056   3.952  -3.648  1.00  0.00           H  
ATOM    632 HD13 LEU A  39      -1.064   3.053  -2.500  1.00  0.00           H  
ATOM    633 HD21 LEU A  39      -4.252   2.202  -4.158  1.00  0.00           H  
ATOM    634 HD22 LEU A  39      -3.903   0.944  -2.974  1.00  0.00           H  
ATOM    635 HD23 LEU A  39      -3.657   2.640  -2.557  1.00  0.00           H  
ATOM    636  N   LEU A  40      -2.923   0.341  -8.257  1.00  0.00           N  
ATOM    637  CA  LEU A  40      -3.473   0.559  -9.589  1.00  0.00           C  
ATOM    638  C   LEU A  40      -4.719  -0.294  -9.794  1.00  0.00           C  
ATOM    639  O   LEU A  40      -5.628   0.082 -10.534  1.00  0.00           O  
ATOM    640  CB  LEU A  40      -2.429   0.232 -10.659  1.00  0.00           C  
ATOM    641  CG  LEU A  40      -2.661   0.900 -12.015  1.00  0.00           C  
ATOM    642  CD1 LEU A  40      -1.337   1.135 -12.728  1.00  0.00           C  
ATOM    643  CD2 LEU A  40      -3.588   0.052 -12.874  1.00  0.00           C  
ATOM    644  H   LEU A  40      -2.022  -0.042  -8.165  1.00  0.00           H  
ATOM    645  HA  LEU A  40      -3.748   1.600  -9.669  1.00  0.00           H  
ATOM    646  HB2 LEU A  40      -1.459   0.537 -10.291  1.00  0.00           H  
ATOM    647  HB3 LEU A  40      -2.419  -0.837 -10.807  1.00  0.00           H  
ATOM    648  HG  LEU A  40      -3.131   1.860 -11.862  1.00  0.00           H  
ATOM    649 HD11 LEU A  40      -0.784   0.208 -12.773  1.00  0.00           H  
ATOM    650 HD12 LEU A  40      -1.526   1.490 -13.730  1.00  0.00           H  
ATOM    651 HD13 LEU A  40      -0.763   1.872 -12.187  1.00  0.00           H  
ATOM    652 HD21 LEU A  40      -4.204  -0.565 -12.237  1.00  0.00           H  
ATOM    653 HD22 LEU A  40      -4.217   0.697 -13.469  1.00  0.00           H  
ATOM    654 HD23 LEU A  40      -2.999  -0.577 -13.525  1.00  0.00           H  
ATOM    655  N   ARG A  41      -4.755  -1.442  -9.125  1.00  0.00           N  
ATOM    656  CA  ARG A  41      -5.890  -2.349  -9.221  1.00  0.00           C  
ATOM    657  C   ARG A  41      -7.143  -1.699  -8.645  1.00  0.00           C  
ATOM    658  O   ARG A  41      -8.207  -1.724  -9.262  1.00  0.00           O  
ATOM    659  CB  ARG A  41      -5.589  -3.657  -8.484  1.00  0.00           C  
ATOM    660  CG  ARG A  41      -5.883  -4.899  -9.307  1.00  0.00           C  
ATOM    661  CD  ARG A  41      -4.938  -5.017 -10.493  1.00  0.00           C  
ATOM    662  NE  ARG A  41      -5.606  -5.563 -11.672  1.00  0.00           N  
ATOM    663  CZ  ARG A  41      -4.984  -5.829 -12.818  1.00  0.00           C  
ATOM    664  NH1 ARG A  41      -3.683  -5.603 -12.944  1.00  0.00           N  
ATOM    665  NH2 ARG A  41      -5.666  -6.324 -13.843  1.00  0.00           N  
ATOM    666  H   ARG A  41      -4.001  -1.681  -8.547  1.00  0.00           H  
ATOM    667  HA  ARG A  41      -6.057  -2.564 -10.264  1.00  0.00           H  
ATOM    668  HB2 ARG A  41      -4.544  -3.671  -8.213  1.00  0.00           H  
ATOM    669  HB3 ARG A  41      -6.186  -3.697  -7.585  1.00  0.00           H  
ATOM    670  HG2 ARG A  41      -5.767  -5.770  -8.679  1.00  0.00           H  
ATOM    671  HG3 ARG A  41      -6.898  -4.847  -9.671  1.00  0.00           H  
ATOM    672  HD2 ARG A  41      -4.554  -4.037 -10.729  1.00  0.00           H  
ATOM    673  HD3 ARG A  41      -4.120  -5.668 -10.220  1.00  0.00           H  
ATOM    674  HE  ARG A  41      -6.568  -5.739 -11.607  1.00  0.00           H  
ATOM    675 HH11 ARG A  41      -3.163  -5.230 -12.176  1.00  0.00           H  
ATOM    676 HH12 ARG A  41      -3.222  -5.806 -13.808  1.00  0.00           H  
ATOM    677 HH21 ARG A  41      -6.647  -6.496 -13.753  1.00  0.00           H  
ATOM    678 HH22 ARG A  41      -5.200  -6.524 -14.704  1.00  0.00           H  
ATOM    679  N   VAL A  42      -7.008  -1.115  -7.458  1.00  0.00           N  
ATOM    680  CA  VAL A  42      -8.126  -0.454  -6.796  1.00  0.00           C  
ATOM    681  C   VAL A  42      -8.785   0.566  -7.719  1.00  0.00           C  
ATOM    682  O   VAL A  42      -9.983   0.828  -7.616  1.00  0.00           O  
ATOM    683  CB  VAL A  42      -7.672   0.248  -5.502  1.00  0.00           C  
ATOM    684  CG1 VAL A  42      -8.867   0.806  -4.743  1.00  0.00           C  
ATOM    685  CG2 VAL A  42      -6.878  -0.710  -4.627  1.00  0.00           C  
ATOM    686  H   VAL A  42      -6.133  -1.126  -7.014  1.00  0.00           H  
ATOM    687  HA  VAL A  42      -8.852  -1.210  -6.536  1.00  0.00           H  
ATOM    688  HB  VAL A  42      -7.027   1.073  -5.771  1.00  0.00           H  
ATOM    689 HG11 VAL A  42      -9.618   1.137  -5.446  1.00  0.00           H  
ATOM    690 HG12 VAL A  42      -9.282   0.036  -4.109  1.00  0.00           H  
ATOM    691 HG13 VAL A  42      -8.550   1.641  -4.136  1.00  0.00           H  
ATOM    692 HG21 VAL A  42      -7.375  -1.668  -4.600  1.00  0.00           H  
ATOM    693 HG22 VAL A  42      -5.885  -0.831  -5.035  1.00  0.00           H  
ATOM    694 HG23 VAL A  42      -6.810  -0.310  -3.625  1.00  0.00           H  
ATOM    695  N   GLY A  43      -7.997   1.135  -8.627  1.00  0.00           N  
ATOM    696  CA  GLY A  43      -8.527   2.113  -9.557  1.00  0.00           C  
ATOM    697  C   GLY A  43      -9.423   1.485 -10.605  1.00  0.00           C  
ATOM    698  O   GLY A  43     -10.501   2.001 -10.902  1.00  0.00           O  
ATOM    699  H   GLY A  43      -7.049   0.884  -8.668  1.00  0.00           H  
ATOM    700  HA2 GLY A  43      -9.098   2.845  -9.005  1.00  0.00           H  
ATOM    701  HA3 GLY A  43      -7.706   2.609 -10.051  1.00  0.00           H  
ATOM    702  N   GLN A  44      -8.980   0.363 -11.164  1.00  0.00           N  
ATOM    703  CA  GLN A  44      -9.751  -0.341 -12.181  1.00  0.00           C  
ATOM    704  C   GLN A  44     -10.999  -0.970 -11.571  1.00  0.00           C  
ATOM    705  O   GLN A  44     -12.031  -1.094 -12.230  1.00  0.00           O  
ATOM    706  CB  GLN A  44      -8.895  -1.420 -12.846  1.00  0.00           C  
ATOM    707  CG  GLN A  44      -9.502  -1.977 -14.124  1.00  0.00           C  
ATOM    708  CD  GLN A  44      -8.861  -1.402 -15.372  1.00  0.00           C  
ATOM    709  OE1 GLN A  44      -9.347  -0.424 -15.940  1.00  0.00           O  
ATOM    710  NE2 GLN A  44      -7.763  -2.010 -15.807  1.00  0.00           N  
ATOM    711  H   GLN A  44      -8.114  -0.002 -10.882  1.00  0.00           H  
ATOM    712  HA  GLN A  44     -10.052   0.379 -12.926  1.00  0.00           H  
ATOM    713  HB2 GLN A  44      -7.928  -0.999 -13.085  1.00  0.00           H  
ATOM    714  HB3 GLN A  44      -8.759  -2.236 -12.152  1.00  0.00           H  
ATOM    715  HG2 GLN A  44      -9.371  -3.048 -14.132  1.00  0.00           H  
ATOM    716  HG3 GLN A  44     -10.556  -1.742 -14.137  1.00  0.00           H  
ATOM    717 HE21 GLN A  44      -7.432  -2.784 -15.304  1.00  0.00           H  
ATOM    718 HE22 GLN A  44      -7.328  -1.660 -16.612  1.00  0.00           H  
ATOM    719  N   ILE A  45     -10.896  -1.363 -10.305  1.00  0.00           N  
ATOM    720  CA  ILE A  45     -12.015  -1.975  -9.601  1.00  0.00           C  
ATOM    721  C   ILE A  45     -13.164  -0.986  -9.434  1.00  0.00           C  
ATOM    722  O   ILE A  45     -14.331  -1.375  -9.434  1.00  0.00           O  
ATOM    723  CB  ILE A  45     -11.585  -2.497  -8.214  1.00  0.00           C  
ATOM    724  CG1 ILE A  45     -10.448  -3.509  -8.358  1.00  0.00           C  
ATOM    725  CG2 ILE A  45     -12.764  -3.127  -7.485  1.00  0.00           C  
ATOM    726  CD1 ILE A  45      -9.557  -3.595  -7.137  1.00  0.00           C  
ATOM    727  H   ILE A  45     -10.047  -1.234  -9.831  1.00  0.00           H  
ATOM    728  HA  ILE A  45     -12.361  -2.816 -10.186  1.00  0.00           H  
ATOM    729  HB  ILE A  45     -11.238  -1.658  -7.629  1.00  0.00           H  
ATOM    730 HG12 ILE A  45     -10.866  -4.488  -8.532  1.00  0.00           H  
ATOM    731 HG13 ILE A  45      -9.831  -3.231  -9.201  1.00  0.00           H  
ATOM    732 HG21 ILE A  45     -13.584  -2.424  -7.453  1.00  0.00           H  
ATOM    733 HG22 ILE A  45     -13.076  -4.019  -8.007  1.00  0.00           H  
ATOM    734 HG23 ILE A  45     -12.470  -3.383  -6.478  1.00  0.00           H  
ATOM    735 HD11 ILE A  45      -9.903  -2.899  -6.388  1.00  0.00           H  
ATOM    736 HD12 ILE A  45      -9.590  -4.599  -6.738  1.00  0.00           H  
ATOM    737 HD13 ILE A  45      -8.542  -3.350  -7.413  1.00  0.00           H  
ATOM    738  N   LEU A  46     -12.831   0.292  -9.295  1.00  0.00           N  
ATOM    739  CA  LEU A  46     -13.847   1.323  -9.130  1.00  0.00           C  
ATOM    740  C   LEU A  46     -14.514   1.646 -10.462  1.00  0.00           C  
ATOM    741  O   LEU A  46     -15.692   2.001 -10.507  1.00  0.00           O  
ATOM    742  CB  LEU A  46     -13.235   2.585  -8.520  1.00  0.00           C  
ATOM    743  CG  LEU A  46     -13.911   3.072  -7.237  1.00  0.00           C  
ATOM    744  CD1 LEU A  46     -14.072   1.926  -6.245  1.00  0.00           C  
ATOM    745  CD2 LEU A  46     -13.114   4.211  -6.618  1.00  0.00           C  
ATOM    746  H   LEU A  46     -11.883   0.546  -9.304  1.00  0.00           H  
ATOM    747  HA  LEU A  46     -14.597   0.937  -8.456  1.00  0.00           H  
ATOM    748  HB2 LEU A  46     -12.195   2.387  -8.303  1.00  0.00           H  
ATOM    749  HB3 LEU A  46     -13.287   3.378  -9.251  1.00  0.00           H  
ATOM    750  HG  LEU A  46     -14.896   3.445  -7.477  1.00  0.00           H  
ATOM    751 HD11 LEU A  46     -13.694   1.012  -6.682  1.00  0.00           H  
ATOM    752 HD12 LEU A  46     -13.522   2.148  -5.342  1.00  0.00           H  
ATOM    753 HD13 LEU A  46     -15.118   1.802  -6.007  1.00  0.00           H  
ATOM    754 HD21 LEU A  46     -12.060   4.035  -6.771  1.00  0.00           H  
ATOM    755 HD22 LEU A  46     -13.395   5.142  -7.086  1.00  0.00           H  
ATOM    756 HD23 LEU A  46     -13.322   4.261  -5.560  1.00  0.00           H  
ATOM    757  N   LYS A  47     -13.760   1.506 -11.545  1.00  0.00           N  
ATOM    758  CA  LYS A  47     -14.287   1.767 -12.877  1.00  0.00           C  
ATOM    759  C   LYS A  47     -15.225   0.644 -13.306  1.00  0.00           C  
ATOM    760  O   LYS A  47     -16.056   0.817 -14.198  1.00  0.00           O  
ATOM    761  CB  LYS A  47     -13.146   1.911 -13.885  1.00  0.00           C  
ATOM    762  CG  LYS A  47     -13.600   2.376 -15.259  1.00  0.00           C  
ATOM    763  CD  LYS A  47     -12.718   1.811 -16.359  1.00  0.00           C  
ATOM    764  CE  LYS A  47     -13.529   1.440 -17.590  1.00  0.00           C  
ATOM    765  NZ  LYS A  47     -12.659   1.093 -18.747  1.00  0.00           N  
ATOM    766  H   LYS A  47     -12.833   1.207 -11.449  1.00  0.00           H  
ATOM    767  HA  LYS A  47     -14.843   2.693 -12.840  1.00  0.00           H  
ATOM    768  HB2 LYS A  47     -12.432   2.625 -13.504  1.00  0.00           H  
ATOM    769  HB3 LYS A  47     -12.658   0.953 -13.997  1.00  0.00           H  
ATOM    770  HG2 LYS A  47     -14.616   2.048 -15.422  1.00  0.00           H  
ATOM    771  HG3 LYS A  47     -13.560   3.455 -15.293  1.00  0.00           H  
ATOM    772  HD2 LYS A  47     -11.984   2.554 -16.635  1.00  0.00           H  
ATOM    773  HD3 LYS A  47     -12.218   0.928 -15.989  1.00  0.00           H  
ATOM    774  HE2 LYS A  47     -14.153   0.591 -17.351  1.00  0.00           H  
ATOM    775  HE3 LYS A  47     -14.154   2.280 -17.859  1.00  0.00           H  
ATOM    776  HZ1 LYS A  47     -11.791   0.626 -18.412  1.00  0.00           H  
ATOM    777  HZ2 LYS A  47     -13.161   0.448 -19.390  1.00  0.00           H  
ATOM    778  HZ3 LYS A  47     -12.398   1.952 -19.269  1.00  0.00           H  
ATOM    779  N   GLU A  48     -15.086  -0.511 -12.657  1.00  0.00           N  
ATOM    780  CA  GLU A  48     -15.915  -1.667 -12.961  1.00  0.00           C  
ATOM    781  C   GLU A  48     -17.350  -1.451 -12.476  1.00  0.00           C  
ATOM    782  O   GLU A  48     -17.599  -1.386 -11.272  1.00  0.00           O  
ATOM    783  CB  GLU A  48     -15.330  -2.917 -12.301  1.00  0.00           C  
ATOM    784  CG  GLU A  48     -14.358  -3.675 -13.191  1.00  0.00           C  
ATOM    785  CD  GLU A  48     -14.434  -5.177 -12.990  1.00  0.00           C  
ATOM    786  OE1 GLU A  48     -14.154  -5.640 -11.864  1.00  0.00           O  
ATOM    787  OE2 GLU A  48     -14.774  -5.888 -13.958  1.00  0.00           O  
ATOM    788  H   GLU A  48     -14.407  -0.585 -11.955  1.00  0.00           H  
ATOM    789  HA  GLU A  48     -15.918  -1.802 -14.030  1.00  0.00           H  
ATOM    790  HB2 GLU A  48     -14.807  -2.623 -11.401  1.00  0.00           H  
ATOM    791  HB3 GLU A  48     -16.138  -3.583 -12.036  1.00  0.00           H  
ATOM    792  HG2 GLU A  48     -14.586  -3.454 -14.222  1.00  0.00           H  
ATOM    793  HG3 GLU A  48     -13.353  -3.347 -12.966  1.00  0.00           H  
ATOM    794  N   PRO A  49     -18.317  -1.337 -13.405  1.00  0.00           N  
ATOM    795  CA  PRO A  49     -19.725  -1.130 -13.050  1.00  0.00           C  
ATOM    796  C   PRO A  49     -20.229  -2.173 -12.061  1.00  0.00           C  
ATOM    797  O   PRO A  49     -20.947  -1.850 -11.115  1.00  0.00           O  
ATOM    798  CB  PRO A  49     -20.455  -1.263 -14.389  1.00  0.00           C  
ATOM    799  CG  PRO A  49     -19.432  -0.919 -15.415  1.00  0.00           C  
ATOM    800  CD  PRO A  49     -18.119  -1.403 -14.865  1.00  0.00           C  
ATOM    801  HA  PRO A  49     -19.888  -0.142 -12.644  1.00  0.00           H  
ATOM    802  HB2 PRO A  49     -20.810  -2.277 -14.509  1.00  0.00           H  
ATOM    803  HB3 PRO A  49     -21.288  -0.578 -14.418  1.00  0.00           H  
ATOM    804  HG2 PRO A  49     -19.659  -1.422 -16.343  1.00  0.00           H  
ATOM    805  HG3 PRO A  49     -19.405   0.150 -15.562  1.00  0.00           H  
ATOM    806  HD2 PRO A  49     -17.927  -2.417 -15.184  1.00  0.00           H  
ATOM    807  HD3 PRO A  49     -17.317  -0.750 -15.175  1.00  0.00           H  
ATOM    808  N   LYS A  50     -19.845  -3.426 -12.283  1.00  0.00           N  
ATOM    809  CA  LYS A  50     -20.256  -4.517 -11.408  1.00  0.00           C  
ATOM    810  C   LYS A  50     -19.639  -4.361 -10.022  1.00  0.00           C  
ATOM    811  O   LYS A  50     -20.229  -4.764  -9.020  1.00  0.00           O  
ATOM    812  CB  LYS A  50     -19.852  -5.864 -12.012  1.00  0.00           C  
ATOM    813  CG  LYS A  50     -20.307  -7.059 -11.191  1.00  0.00           C  
ATOM    814  CD  LYS A  50     -19.343  -8.227 -11.326  1.00  0.00           C  
ATOM    815  CE  LYS A  50     -20.063  -9.560 -11.213  1.00  0.00           C  
ATOM    816  NZ  LYS A  50     -19.261 -10.676 -11.786  1.00  0.00           N  
ATOM    817  H   LYS A  50     -19.271  -3.621 -13.053  1.00  0.00           H  
ATOM    818  HA  LYS A  50     -21.332  -4.482 -11.316  1.00  0.00           H  
ATOM    819  HB2 LYS A  50     -20.283  -5.948 -12.998  1.00  0.00           H  
ATOM    820  HB3 LYS A  50     -18.776  -5.900 -12.095  1.00  0.00           H  
ATOM    821  HG2 LYS A  50     -20.362  -6.770 -10.151  1.00  0.00           H  
ATOM    822  HG3 LYS A  50     -21.283  -7.369 -11.533  1.00  0.00           H  
ATOM    823  HD2 LYS A  50     -18.858  -8.171 -12.290  1.00  0.00           H  
ATOM    824  HD3 LYS A  50     -18.600  -8.161 -10.544  1.00  0.00           H  
ATOM    825  HE2 LYS A  50     -20.254  -9.765 -10.170  1.00  0.00           H  
ATOM    826  HE3 LYS A  50     -21.002  -9.494 -11.744  1.00  0.00           H  
ATOM    827  HZ1 LYS A  50     -18.260 -10.568 -11.524  1.00  0.00           H  
ATOM    828  HZ2 LYS A  50     -19.607 -11.588 -11.423  1.00  0.00           H  
ATOM    829  HZ3 LYS A  50     -19.338 -10.677 -12.823  1.00  0.00           H  
ATOM    830  N   MET A  51     -18.449  -3.771  -9.975  1.00  0.00           N  
ATOM    831  CA  MET A  51     -17.750  -3.559  -8.713  1.00  0.00           C  
ATOM    832  C   MET A  51     -18.430  -2.469  -7.892  1.00  0.00           C  
ATOM    833  O   MET A  51     -18.495  -2.552  -6.666  1.00  0.00           O  
ATOM    834  CB  MET A  51     -16.291  -3.185  -8.969  1.00  0.00           C  
ATOM    835  CG  MET A  51     -15.427  -4.350  -9.428  1.00  0.00           C  
ATOM    836  SD  MET A  51     -15.502  -5.768  -8.312  1.00  0.00           S  
ATOM    837  CE  MET A  51     -15.555  -4.956  -6.716  1.00  0.00           C  
ATOM    838  H   MET A  51     -18.031  -3.471 -10.809  1.00  0.00           H  
ATOM    839  HA  MET A  51     -17.783  -4.482  -8.156  1.00  0.00           H  
ATOM    840  HB2 MET A  51     -16.258  -2.420  -9.732  1.00  0.00           H  
ATOM    841  HB3 MET A  51     -15.868  -2.788  -8.058  1.00  0.00           H  
ATOM    842  HG2 MET A  51     -15.763  -4.664 -10.405  1.00  0.00           H  
ATOM    843  HG3 MET A  51     -14.403  -4.015  -9.493  1.00  0.00           H  
ATOM    844  HE1 MET A  51     -16.345  -4.221  -6.712  1.00  0.00           H  
ATOM    845  HE2 MET A  51     -15.741  -5.690  -5.945  1.00  0.00           H  
ATOM    846  HE3 MET A  51     -14.609  -4.470  -6.527  1.00  0.00           H  
ATOM    847  N   ALA A  52     -18.937  -1.447  -8.575  1.00  0.00           N  
ATOM    848  CA  ALA A  52     -19.612  -0.342  -7.904  1.00  0.00           C  
ATOM    849  C   ALA A  52     -20.793  -0.842  -7.079  1.00  0.00           C  
ATOM    850  O   ALA A  52     -21.164  -0.233  -6.077  1.00  0.00           O  
ATOM    851  CB  ALA A  52     -20.074   0.689  -8.921  1.00  0.00           C  
ATOM    852  H   ALA A  52     -18.855  -1.436  -9.552  1.00  0.00           H  
ATOM    853  HA  ALA A  52     -18.900   0.130  -7.244  1.00  0.00           H  
ATOM    854  HB1 ALA A  52     -21.107   0.508  -9.174  1.00  0.00           H  
ATOM    855  HB2 ALA A  52     -19.467   0.616  -9.811  1.00  0.00           H  
ATOM    856  HB3 ALA A  52     -19.975   1.679  -8.499  1.00  0.00           H  
ATOM    857  N   ALA A  53     -21.378  -1.956  -7.507  1.00  0.00           N  
ATOM    858  CA  ALA A  53     -22.516  -2.540  -6.807  1.00  0.00           C  
ATOM    859  C   ALA A  53     -22.064  -3.476  -5.686  1.00  0.00           C  
ATOM    860  O   ALA A  53     -22.888  -4.121  -5.039  1.00  0.00           O  
ATOM    861  CB  ALA A  53     -23.412  -3.282  -7.786  1.00  0.00           C  
ATOM    862  H   ALA A  53     -21.036  -2.399  -8.312  1.00  0.00           H  
ATOM    863  HA  ALA A  53     -23.089  -1.731  -6.375  1.00  0.00           H  
ATOM    864  HB1 ALA A  53     -22.857  -4.088  -8.242  1.00  0.00           H  
ATOM    865  HB2 ALA A  53     -24.264  -3.685  -7.259  1.00  0.00           H  
ATOM    866  HB3 ALA A  53     -23.751  -2.600  -8.552  1.00  0.00           H  
ATOM    867  N   SER A  54     -20.753  -3.549  -5.460  1.00  0.00           N  
ATOM    868  CA  SER A  54     -20.207  -4.411  -4.417  1.00  0.00           C  
ATOM    869  C   SER A  54     -19.285  -3.630  -3.485  1.00  0.00           C  
ATOM    870  O   SER A  54     -19.267  -3.866  -2.277  1.00  0.00           O  
ATOM    871  CB  SER A  54     -19.448  -5.584  -5.040  1.00  0.00           C  
ATOM    872  OG  SER A  54     -20.340  -6.596  -5.474  1.00  0.00           O  
ATOM    873  H   SER A  54     -20.141  -3.016  -6.006  1.00  0.00           H  
ATOM    874  HA  SER A  54     -21.034  -4.795  -3.841  1.00  0.00           H  
ATOM    875  HB2 SER A  54     -18.881  -5.233  -5.890  1.00  0.00           H  
ATOM    876  HB3 SER A  54     -18.775  -6.004  -4.308  1.00  0.00           H  
ATOM    877  HG  SER A  54     -19.943  -7.457  -5.325  1.00  0.00           H  
ATOM    878  N   LEU A  55     -18.521  -2.702  -4.050  1.00  0.00           N  
ATOM    879  CA  LEU A  55     -17.600  -1.891  -3.264  1.00  0.00           C  
ATOM    880  C   LEU A  55     -18.339  -0.784  -2.512  1.00  0.00           C  
ATOM    881  O   LEU A  55     -17.760  -0.112  -1.660  1.00  0.00           O  
ATOM    882  CB  LEU A  55     -16.529  -1.278  -4.166  1.00  0.00           C  
ATOM    883  CG  LEU A  55     -15.314  -2.168  -4.428  1.00  0.00           C  
ATOM    884  CD1 LEU A  55     -14.283  -1.432  -5.268  1.00  0.00           C  
ATOM    885  CD2 LEU A  55     -14.700  -2.632  -3.115  1.00  0.00           C  
ATOM    886  H   LEU A  55     -18.577  -2.558  -5.017  1.00  0.00           H  
ATOM    887  HA  LEU A  55     -17.122  -2.538  -2.544  1.00  0.00           H  
ATOM    888  HB2 LEU A  55     -16.983  -1.037  -5.117  1.00  0.00           H  
ATOM    889  HB3 LEU A  55     -16.183  -0.362  -3.710  1.00  0.00           H  
ATOM    890  HG  LEU A  55     -15.629  -3.044  -4.979  1.00  0.00           H  
ATOM    891 HD11 LEU A  55     -14.057  -0.481  -4.808  1.00  0.00           H  
ATOM    892 HD12 LEU A  55     -13.382  -2.022  -5.335  1.00  0.00           H  
ATOM    893 HD13 LEU A  55     -14.679  -1.265  -6.260  1.00  0.00           H  
ATOM    894 HD21 LEU A  55     -14.922  -1.914  -2.341  1.00  0.00           H  
ATOM    895 HD22 LEU A  55     -15.113  -3.594  -2.845  1.00  0.00           H  
ATOM    896 HD23 LEU A  55     -13.630  -2.719  -3.230  1.00  0.00           H  
ATOM    897  N   LEU A  56     -19.616  -0.593  -2.835  1.00  0.00           N  
ATOM    898  CA  LEU A  56     -20.417   0.438  -2.187  1.00  0.00           C  
ATOM    899  C   LEU A  56     -21.818  -0.070  -1.854  1.00  0.00           C  
ATOM    900  O   LEU A  56     -22.763   0.712  -1.764  1.00  0.00           O  
ATOM    901  CB  LEU A  56     -20.512   1.674  -3.085  1.00  0.00           C  
ATOM    902  CG  LEU A  56     -20.450   3.014  -2.351  1.00  0.00           C  
ATOM    903  CD1 LEU A  56     -21.696   3.217  -1.504  1.00  0.00           C  
ATOM    904  CD2 LEU A  56     -19.198   3.091  -1.490  1.00  0.00           C  
ATOM    905  H   LEU A  56     -20.029  -1.154  -3.524  1.00  0.00           H  
ATOM    906  HA  LEU A  56     -19.921   0.712  -1.268  1.00  0.00           H  
ATOM    907  HB2 LEU A  56     -19.699   1.638  -3.796  1.00  0.00           H  
ATOM    908  HB3 LEU A  56     -21.445   1.629  -3.626  1.00  0.00           H  
ATOM    909  HG  LEU A  56     -20.407   3.812  -3.078  1.00  0.00           H  
ATOM    910 HD11 LEU A  56     -22.572   3.169  -2.134  1.00  0.00           H  
ATOM    911 HD12 LEU A  56     -21.751   2.444  -0.752  1.00  0.00           H  
ATOM    912 HD13 LEU A  56     -21.651   4.183  -1.023  1.00  0.00           H  
ATOM    913 HD21 LEU A  56     -18.355   2.708  -2.046  1.00  0.00           H  
ATOM    914 HD22 LEU A  56     -19.012   4.120  -1.219  1.00  0.00           H  
ATOM    915 HD23 LEU A  56     -19.339   2.503  -0.596  1.00  0.00           H  
ATOM    916  N   ASN A  57     -21.949  -1.382  -1.672  1.00  0.00           N  
ATOM    917  CA  ASN A  57     -23.239  -1.977  -1.349  1.00  0.00           C  
ATOM    918  C   ASN A  57     -23.441  -2.053   0.164  1.00  0.00           C  
ATOM    919  O   ASN A  57     -22.774  -2.831   0.845  1.00  0.00           O  
ATOM    920  CB  ASN A  57     -23.344  -3.378  -1.953  1.00  0.00           C  
ATOM    921  CG  ASN A  57     -22.188  -4.272  -1.550  1.00  0.00           C  
ATOM    922  OD1 ASN A  57     -21.273  -3.843  -0.848  1.00  0.00           O  
ATOM    923  ND2 ASN A  57     -22.226  -5.523  -1.993  1.00  0.00           N  
ATOM    924  H   ASN A  57     -21.164  -1.963  -1.756  1.00  0.00           H  
ATOM    925  HA  ASN A  57     -24.008  -1.354  -1.777  1.00  0.00           H  
ATOM    926  HB2 ASN A  57     -24.262  -3.839  -1.621  1.00  0.00           H  
ATOM    927  HB3 ASN A  57     -23.355  -3.298  -3.030  1.00  0.00           H  
ATOM    928 HD21 ASN A  57     -22.986  -5.796  -2.547  1.00  0.00           H  
ATOM    929 HD22 ASN A  57     -21.489  -6.123  -1.749  1.00  0.00           H  
ATOM    930  N   PRO A  58     -24.372  -1.249   0.717  1.00  0.00           N  
ATOM    931  CA  PRO A  58     -24.656  -1.241   2.155  1.00  0.00           C  
ATOM    932  C   PRO A  58     -25.443  -2.474   2.601  1.00  0.00           C  
ATOM    933  O   PRO A  58     -25.903  -2.548   3.740  1.00  0.00           O  
ATOM    934  CB  PRO A  58     -25.500   0.029   2.361  1.00  0.00           C  
ATOM    935  CG  PRO A  58     -25.492   0.747   1.049  1.00  0.00           C  
ATOM    936  CD  PRO A  58     -25.221  -0.292   0.000  1.00  0.00           C  
ATOM    937  HA  PRO A  58     -23.749  -1.170   2.734  1.00  0.00           H  
ATOM    938  HB2 PRO A  58     -26.503  -0.248   2.648  1.00  0.00           H  
ATOM    939  HB3 PRO A  58     -25.055   0.632   3.139  1.00  0.00           H  
ATOM    940  HG2 PRO A  58     -26.455   1.208   0.878  1.00  0.00           H  
ATOM    941  HG3 PRO A  58     -24.713   1.495   1.046  1.00  0.00           H  
ATOM    942  HD2 PRO A  58     -26.142  -0.754  -0.324  1.00  0.00           H  
ATOM    943  HD3 PRO A  58     -24.696   0.143  -0.835  1.00  0.00           H  
ATOM    944  N   TYR A  59     -25.600  -3.436   1.695  1.00  0.00           N  
ATOM    945  CA  TYR A  59     -26.335  -4.657   1.989  1.00  0.00           C  
ATOM    946  C   TYR A  59     -25.433  -5.701   2.640  1.00  0.00           C  
ATOM    947  O   TYR A  59     -25.891  -6.519   3.437  1.00  0.00           O  
ATOM    948  CB  TYR A  59     -26.939  -5.216   0.700  1.00  0.00           C  
ATOM    949  CG  TYR A  59     -28.031  -4.347   0.122  1.00  0.00           C  
ATOM    950  CD1 TYR A  59     -27.773  -3.034  -0.255  1.00  0.00           C  
ATOM    951  CD2 TYR A  59     -29.322  -4.835  -0.045  1.00  0.00           C  
ATOM    952  CE1 TYR A  59     -28.768  -2.234  -0.781  1.00  0.00           C  
ATOM    953  CE2 TYR A  59     -30.323  -4.040  -0.572  1.00  0.00           C  
ATOM    954  CZ  TYR A  59     -30.041  -2.741  -0.938  1.00  0.00           C  
ATOM    955  OH  TYR A  59     -31.034  -1.947  -1.462  1.00  0.00           O  
ATOM    956  H   TYR A  59     -25.218  -3.321   0.805  1.00  0.00           H  
ATOM    957  HA  TYR A  59     -27.133  -4.410   2.672  1.00  0.00           H  
ATOM    958  HB2 TYR A  59     -26.159  -5.307  -0.042  1.00  0.00           H  
ATOM    959  HB3 TYR A  59     -27.358  -6.192   0.899  1.00  0.00           H  
ATOM    960  HD1 TYR A  59     -26.777  -2.638  -0.134  1.00  0.00           H  
ATOM    961  HD2 TYR A  59     -29.539  -5.853   0.242  1.00  0.00           H  
ATOM    962  HE1 TYR A  59     -28.546  -1.216  -1.066  1.00  0.00           H  
ATOM    963  HE2 TYR A  59     -31.318  -4.438  -0.695  1.00  0.00           H  
ATOM    964  HH  TYR A  59     -31.276  -2.269  -2.334  1.00  0.00           H  
ATOM    965  N   VAL A  60     -24.150  -5.669   2.295  1.00  0.00           N  
ATOM    966  CA  VAL A  60     -23.191  -6.615   2.848  1.00  0.00           C  
ATOM    967  C   VAL A  60     -23.060  -6.448   4.362  1.00  0.00           C  
ATOM    968  O   VAL A  60     -23.777  -7.098   5.122  1.00  0.00           O  
ATOM    969  CB  VAL A  60     -21.809  -6.478   2.176  1.00  0.00           C  
ATOM    970  CG1 VAL A  60     -20.878  -7.580   2.650  1.00  0.00           C  
ATOM    971  CG2 VAL A  60     -21.947  -6.507   0.661  1.00  0.00           C  
ATOM    972  H   VAL A  60     -23.843  -4.994   1.653  1.00  0.00           H  
ATOM    973  HA  VAL A  60     -23.556  -7.611   2.648  1.00  0.00           H  
ATOM    974  HB  VAL A  60     -21.382  -5.527   2.457  1.00  0.00           H  
ATOM    975 HG11 VAL A  60     -21.401  -8.525   2.630  1.00  0.00           H  
ATOM    976 HG12 VAL A  60     -20.021  -7.630   1.998  1.00  0.00           H  
ATOM    977 HG13 VAL A  60     -20.556  -7.369   3.657  1.00  0.00           H  
ATOM    978 HG21 VAL A  60     -22.956  -6.241   0.385  1.00  0.00           H  
ATOM    979 HG22 VAL A  60     -21.256  -5.802   0.223  1.00  0.00           H  
ATOM    980 HG23 VAL A  60     -21.725  -7.500   0.299  1.00  0.00           H  
ATOM    981  N   LYS A  61     -22.153  -5.574   4.802  1.00  0.00           N  
ATOM    982  CA  LYS A  61     -21.944  -5.329   6.228  1.00  0.00           C  
ATOM    983  C   LYS A  61     -20.706  -4.466   6.450  1.00  0.00           C  
ATOM    984  O   LYS A  61     -20.170  -3.878   5.510  1.00  0.00           O  
ATOM    985  CB  LYS A  61     -21.799  -6.650   6.995  1.00  0.00           C  
ATOM    986  CG  LYS A  61     -22.716  -6.757   8.203  1.00  0.00           C  
ATOM    987  CD  LYS A  61     -24.181  -6.753   7.795  1.00  0.00           C  
ATOM    988  CE  LYS A  61     -25.085  -6.409   8.968  1.00  0.00           C  
ATOM    989  NZ  LYS A  61     -26.518  -6.357   8.568  1.00  0.00           N  
ATOM    990  H   LYS A  61     -21.613  -5.079   4.155  1.00  0.00           H  
ATOM    991  HA  LYS A  61     -22.808  -4.799   6.602  1.00  0.00           H  
ATOM    992  HB2 LYS A  61     -22.018  -7.470   6.330  1.00  0.00           H  
ATOM    993  HB3 LYS A  61     -20.779  -6.742   7.340  1.00  0.00           H  
ATOM    994  HG2 LYS A  61     -22.501  -7.677   8.726  1.00  0.00           H  
ATOM    995  HG3 LYS A  61     -22.532  -5.918   8.858  1.00  0.00           H  
ATOM    996  HD2 LYS A  61     -24.326  -6.021   7.015  1.00  0.00           H  
ATOM    997  HD3 LYS A  61     -24.444  -7.734   7.425  1.00  0.00           H  
ATOM    998  HE2 LYS A  61     -24.961  -7.159   9.733  1.00  0.00           H  
ATOM    999  HE3 LYS A  61     -24.794  -5.445   9.358  1.00  0.00           H  
ATOM   1000  HZ1 LYS A  61     -26.601  -6.077   7.569  1.00  0.00           H  
ATOM   1001  HZ2 LYS A  61     -26.958  -7.292   8.690  1.00  0.00           H  
ATOM   1002  HZ3 LYS A  61     -27.029  -5.667   9.154  1.00  0.00           H  
ATOM   1003  N   ARG A  62     -20.253  -4.399   7.697  1.00  0.00           N  
ATOM   1004  CA  ARG A  62     -19.073  -3.614   8.040  1.00  0.00           C  
ATOM   1005  C   ARG A  62     -17.837  -4.504   8.114  1.00  0.00           C  
ATOM   1006  O   ARG A  62     -16.721  -4.055   7.855  1.00  0.00           O  
ATOM   1007  CB  ARG A  62     -19.282  -2.894   9.373  1.00  0.00           C  
ATOM   1008  CG  ARG A  62     -18.090  -2.051   9.802  1.00  0.00           C  
ATOM   1009  CD  ARG A  62     -17.713  -1.031   8.739  1.00  0.00           C  
ATOM   1010  NE  ARG A  62     -17.688   0.330   9.271  1.00  0.00           N  
ATOM   1011  CZ  ARG A  62     -17.770   1.423   8.517  1.00  0.00           C  
ATOM   1012  NH1 ARG A  62     -17.880   1.323   7.199  1.00  0.00           N  
ATOM   1013  NH2 ARG A  62     -17.741   2.623   9.084  1.00  0.00           N  
ATOM   1014  H   ARG A  62     -20.720  -4.892   8.403  1.00  0.00           H  
ATOM   1015  HA  ARG A  62     -18.927  -2.880   7.261  1.00  0.00           H  
ATOM   1016  HB2 ARG A  62     -20.141  -2.245   9.289  1.00  0.00           H  
ATOM   1017  HB3 ARG A  62     -19.470  -3.629  10.140  1.00  0.00           H  
ATOM   1018  HG2 ARG A  62     -18.341  -1.529  10.714  1.00  0.00           H  
ATOM   1019  HG3 ARG A  62     -17.247  -2.702   9.979  1.00  0.00           H  
ATOM   1020  HD2 ARG A  62     -16.734  -1.275   8.355  1.00  0.00           H  
ATOM   1021  HD3 ARG A  62     -18.435  -1.080   7.938  1.00  0.00           H  
ATOM   1022  HE  ARG A  62     -17.605   0.433  10.243  1.00  0.00           H  
ATOM   1023 HH11 ARG A  62     -17.902   0.423   6.764  1.00  0.00           H  
ATOM   1024 HH12 ARG A  62     -17.942   2.149   6.638  1.00  0.00           H  
ATOM   1025 HH21 ARG A  62     -17.657   2.704  10.077  1.00  0.00           H  
ATOM   1026 HH22 ARG A  62     -17.803   3.444   8.518  1.00  0.00           H  
ATOM   1027  N   SER A  63     -18.044  -5.769   8.468  1.00  0.00           N  
ATOM   1028  CA  SER A  63     -16.945  -6.722   8.574  1.00  0.00           C  
ATOM   1029  C   SER A  63     -17.150  -7.918   7.647  1.00  0.00           C  
ATOM   1030  O   SER A  63     -16.314  -8.819   7.592  1.00  0.00           O  
ATOM   1031  CB  SER A  63     -16.791  -7.201  10.019  1.00  0.00           C  
ATOM   1032  OG  SER A  63     -18.055  -7.412  10.623  1.00  0.00           O  
ATOM   1033  H   SER A  63     -18.957  -6.069   8.662  1.00  0.00           H  
ATOM   1034  HA  SER A  63     -16.040  -6.213   8.276  1.00  0.00           H  
ATOM   1035  HB2 SER A  63     -16.241  -8.129  10.032  1.00  0.00           H  
ATOM   1036  HB3 SER A  63     -16.254  -6.456  10.587  1.00  0.00           H  
ATOM   1037  HG  SER A  63     -18.558  -6.594  10.610  1.00  0.00           H  
ATOM   1038  N   VAL A  64     -18.256  -7.919   6.909  1.00  0.00           N  
ATOM   1039  CA  VAL A  64     -18.543  -9.000   5.978  1.00  0.00           C  
ATOM   1040  C   VAL A  64     -17.913  -8.697   4.626  1.00  0.00           C  
ATOM   1041  O   VAL A  64     -17.117  -9.482   4.108  1.00  0.00           O  
ATOM   1042  CB  VAL A  64     -20.059  -9.214   5.804  1.00  0.00           C  
ATOM   1043  CG1 VAL A  64     -20.335 -10.383   4.869  1.00  0.00           C  
ATOM   1044  CG2 VAL A  64     -20.723  -9.438   7.155  1.00  0.00           C  
ATOM   1045  H   VAL A  64     -18.885  -7.172   6.982  1.00  0.00           H  
ATOM   1046  HA  VAL A  64     -18.109  -9.907   6.372  1.00  0.00           H  
ATOM   1047  HB  VAL A  64     -20.481  -8.323   5.365  1.00  0.00           H  
ATOM   1048 HG11 VAL A  64     -19.538 -11.107   4.954  1.00  0.00           H  
ATOM   1049 HG12 VAL A  64     -21.273 -10.845   5.137  1.00  0.00           H  
ATOM   1050 HG13 VAL A  64     -20.388 -10.024   3.851  1.00  0.00           H  
ATOM   1051 HG21 VAL A  64     -20.430  -8.652   7.835  1.00  0.00           H  
ATOM   1052 HG22 VAL A  64     -21.796  -9.429   7.035  1.00  0.00           H  
ATOM   1053 HG23 VAL A  64     -20.413 -10.392   7.555  1.00  0.00           H  
ATOM   1054  N   LYS A  65     -18.264  -7.545   4.064  1.00  0.00           N  
ATOM   1055  CA  LYS A  65     -17.720  -7.125   2.778  1.00  0.00           C  
ATOM   1056  C   LYS A  65     -16.194  -7.152   2.797  1.00  0.00           C  
ATOM   1057  O   LYS A  65     -15.556  -7.328   1.759  1.00  0.00           O  
ATOM   1058  CB  LYS A  65     -18.209  -5.717   2.428  1.00  0.00           C  
ATOM   1059  CG  LYS A  65     -17.766  -5.243   1.054  1.00  0.00           C  
ATOM   1060  CD  LYS A  65     -18.665  -5.792  -0.042  1.00  0.00           C  
ATOM   1061  CE  LYS A  65     -17.890  -6.042  -1.325  1.00  0.00           C  
ATOM   1062  NZ  LYS A  65     -17.061  -7.276  -1.241  1.00  0.00           N  
ATOM   1063  H   LYS A  65     -18.898  -6.958   4.529  1.00  0.00           H  
ATOM   1064  HA  LYS A  65     -18.071  -7.816   2.027  1.00  0.00           H  
ATOM   1065  HB2 LYS A  65     -19.289  -5.705   2.458  1.00  0.00           H  
ATOM   1066  HB3 LYS A  65     -17.830  -5.024   3.165  1.00  0.00           H  
ATOM   1067  HG2 LYS A  65     -17.800  -4.165   1.028  1.00  0.00           H  
ATOM   1068  HG3 LYS A  65     -16.754  -5.578   0.879  1.00  0.00           H  
ATOM   1069  HD2 LYS A  65     -19.097  -6.723   0.293  1.00  0.00           H  
ATOM   1070  HD3 LYS A  65     -19.451  -5.077  -0.239  1.00  0.00           H  
ATOM   1071  HE2 LYS A  65     -18.591  -6.144  -2.140  1.00  0.00           H  
ATOM   1072  HE3 LYS A  65     -17.244  -5.196  -1.511  1.00  0.00           H  
ATOM   1073  HZ1 LYS A  65     -16.637  -7.359  -0.295  1.00  0.00           H  
ATOM   1074  HZ2 LYS A  65     -17.650  -8.115  -1.420  1.00  0.00           H  
ATOM   1075  HZ3 LYS A  65     -16.299  -7.244  -1.949  1.00  0.00           H  
ATOM   1076  N   VAL A  66     -15.609  -6.975   3.983  1.00  0.00           N  
ATOM   1077  CA  VAL A  66     -14.158  -6.983   4.118  1.00  0.00           C  
ATOM   1078  C   VAL A  66     -13.583  -8.357   3.791  1.00  0.00           C  
ATOM   1079  O   VAL A  66     -12.451  -8.471   3.321  1.00  0.00           O  
ATOM   1080  CB  VAL A  66     -13.717  -6.566   5.538  1.00  0.00           C  
ATOM   1081  CG1 VAL A  66     -14.082  -7.636   6.558  1.00  0.00           C  
ATOM   1082  CG2 VAL A  66     -12.223  -6.277   5.568  1.00  0.00           C  
ATOM   1083  H   VAL A  66     -16.165  -6.837   4.781  1.00  0.00           H  
ATOM   1084  HA  VAL A  66     -13.758  -6.264   3.416  1.00  0.00           H  
ATOM   1085  HB  VAL A  66     -14.241  -5.659   5.802  1.00  0.00           H  
ATOM   1086 HG11 VAL A  66     -14.748  -8.354   6.104  1.00  0.00           H  
ATOM   1087 HG12 VAL A  66     -13.185  -8.139   6.890  1.00  0.00           H  
ATOM   1088 HG13 VAL A  66     -14.570  -7.176   7.403  1.00  0.00           H  
ATOM   1089 HG21 VAL A  66     -11.878  -6.063   4.567  1.00  0.00           H  
ATOM   1090 HG22 VAL A  66     -12.035  -5.426   6.205  1.00  0.00           H  
ATOM   1091 HG23 VAL A  66     -11.698  -7.139   5.952  1.00  0.00           H  
ATOM   1092  N   LYS A  67     -14.371  -9.400   4.037  1.00  0.00           N  
ATOM   1093  CA  LYS A  67     -13.934 -10.763   3.758  1.00  0.00           C  
ATOM   1094  C   LYS A  67     -13.918 -11.020   2.257  1.00  0.00           C  
ATOM   1095  O   LYS A  67     -12.951 -11.564   1.722  1.00  0.00           O  
ATOM   1096  CB  LYS A  67     -14.850 -11.771   4.454  1.00  0.00           C  
ATOM   1097  CG  LYS A  67     -14.776 -11.714   5.972  1.00  0.00           C  
ATOM   1098  CD  LYS A  67     -13.497 -12.351   6.491  1.00  0.00           C  
ATOM   1099  CE  LYS A  67     -12.946 -11.598   7.691  1.00  0.00           C  
ATOM   1100  NZ  LYS A  67     -13.848 -11.699   8.871  1.00  0.00           N  
ATOM   1101  H   LYS A  67     -15.266  -9.250   4.409  1.00  0.00           H  
ATOM   1102  HA  LYS A  67     -12.930 -10.874   4.139  1.00  0.00           H  
ATOM   1103  HB2 LYS A  67     -15.871 -11.577   4.159  1.00  0.00           H  
ATOM   1104  HB3 LYS A  67     -14.576 -12.767   4.140  1.00  0.00           H  
ATOM   1105  HG2 LYS A  67     -14.804 -10.681   6.286  1.00  0.00           H  
ATOM   1106  HG3 LYS A  67     -15.623 -12.241   6.384  1.00  0.00           H  
ATOM   1107  HD2 LYS A  67     -13.707 -13.369   6.783  1.00  0.00           H  
ATOM   1108  HD3 LYS A  67     -12.758 -12.345   5.703  1.00  0.00           H  
ATOM   1109  HE2 LYS A  67     -11.983 -12.012   7.948  1.00  0.00           H  
ATOM   1110  HE3 LYS A  67     -12.830 -10.558   7.424  1.00  0.00           H  
ATOM   1111  HZ1 LYS A  67     -14.199 -12.672   8.970  1.00  0.00           H  
ATOM   1112  HZ2 LYS A  67     -13.333 -11.439   9.737  1.00  0.00           H  
ATOM   1113  HZ3 LYS A  67     -14.659 -11.058   8.757  1.00  0.00           H  
ATOM   1114  N   SER A  68     -14.988 -10.615   1.581  1.00  0.00           N  
ATOM   1115  CA  SER A  68     -15.086 -10.793   0.139  1.00  0.00           C  
ATOM   1116  C   SER A  68     -13.948 -10.065  -0.564  1.00  0.00           C  
ATOM   1117  O   SER A  68     -13.539 -10.444  -1.662  1.00  0.00           O  
ATOM   1118  CB  SER A  68     -16.434 -10.279  -0.372  1.00  0.00           C  
ATOM   1119  OG  SER A  68     -16.416 -10.112  -1.779  1.00  0.00           O  
ATOM   1120  H   SER A  68     -15.723 -10.181   2.063  1.00  0.00           H  
ATOM   1121  HA  SER A  68     -15.006 -11.849  -0.073  1.00  0.00           H  
ATOM   1122  HB2 SER A  68     -17.208 -10.987  -0.116  1.00  0.00           H  
ATOM   1123  HB3 SER A  68     -16.652  -9.326   0.089  1.00  0.00           H  
ATOM   1124  HG  SER A  68     -16.092  -9.234  -1.994  1.00  0.00           H  
ATOM   1125  N   LEU A  69     -13.430  -9.021   0.080  1.00  0.00           N  
ATOM   1126  CA  LEU A  69     -12.330  -8.252  -0.483  1.00  0.00           C  
ATOM   1127  C   LEU A  69     -11.115  -9.145  -0.699  1.00  0.00           C  
ATOM   1128  O   LEU A  69     -10.469  -9.084  -1.742  1.00  0.00           O  
ATOM   1129  CB  LEU A  69     -11.971  -7.084   0.439  1.00  0.00           C  
ATOM   1130  CG  LEU A  69     -12.552  -5.733   0.023  1.00  0.00           C  
ATOM   1131  CD1 LEU A  69     -14.072  -5.783   0.023  1.00  0.00           C  
ATOM   1132  CD2 LEU A  69     -12.052  -4.629   0.946  1.00  0.00           C  
ATOM   1133  H   LEU A  69     -13.792  -8.770   0.955  1.00  0.00           H  
ATOM   1134  HA  LEU A  69     -12.652  -7.862  -1.437  1.00  0.00           H  
ATOM   1135  HB2 LEU A  69     -12.325  -7.315   1.432  1.00  0.00           H  
ATOM   1136  HB3 LEU A  69     -10.895  -6.993   0.471  1.00  0.00           H  
ATOM   1137  HG  LEU A  69     -12.227  -5.504  -0.980  1.00  0.00           H  
ATOM   1138 HD11 LEU A  69     -14.400  -6.780  -0.234  1.00  0.00           H  
ATOM   1139 HD12 LEU A  69     -14.441  -5.525   1.005  1.00  0.00           H  
ATOM   1140 HD13 LEU A  69     -14.456  -5.081  -0.702  1.00  0.00           H  
ATOM   1141 HD21 LEU A  69     -11.684  -5.066   1.863  1.00  0.00           H  
ATOM   1142 HD22 LEU A  69     -11.254  -4.089   0.459  1.00  0.00           H  
ATOM   1143 HD23 LEU A  69     -12.861  -3.951   1.168  1.00  0.00           H  
ATOM   1144  N   SER A  70     -10.820  -9.984   0.294  1.00  0.00           N  
ATOM   1145  CA  SER A  70      -9.688 -10.904   0.218  1.00  0.00           C  
ATOM   1146  C   SER A  70      -9.670 -11.635  -1.118  1.00  0.00           C  
ATOM   1147  O   SER A  70      -8.604 -11.945  -1.653  1.00  0.00           O  
ATOM   1148  CB  SER A  70      -9.750 -11.914   1.365  1.00  0.00           C  
ATOM   1149  OG  SER A  70      -8.452 -12.240   1.829  1.00  0.00           O  
ATOM   1150  H   SER A  70     -11.379  -9.987   1.095  1.00  0.00           H  
ATOM   1151  HA  SER A  70      -8.783 -10.324   0.311  1.00  0.00           H  
ATOM   1152  HB2 SER A  70     -10.315 -11.494   2.183  1.00  0.00           H  
ATOM   1153  HB3 SER A  70     -10.234 -12.817   1.020  1.00  0.00           H  
ATOM   1154  HG  SER A  70      -8.223 -13.128   1.544  1.00  0.00           H  
ATOM   1155  N   ASP A  71     -10.854 -11.903  -1.659  1.00  0.00           N  
ATOM   1156  CA  ASP A  71     -10.964 -12.590  -2.941  1.00  0.00           C  
ATOM   1157  C   ASP A  71     -10.420 -11.715  -4.063  1.00  0.00           C  
ATOM   1158  O   ASP A  71      -9.918 -12.216  -5.069  1.00  0.00           O  
ATOM   1159  CB  ASP A  71     -12.418 -12.972  -3.225  1.00  0.00           C  
ATOM   1160  CG  ASP A  71     -12.899 -14.111  -2.347  1.00  0.00           C  
ATOM   1161  OD1 ASP A  71     -12.147 -15.095  -2.187  1.00  0.00           O  
ATOM   1162  OD2 ASP A  71     -14.028 -14.019  -1.821  1.00  0.00           O  
ATOM   1163  H   ASP A  71     -11.671 -11.626  -1.188  1.00  0.00           H  
ATOM   1164  HA  ASP A  71     -10.365 -13.487  -2.885  1.00  0.00           H  
ATOM   1165  HB2 ASP A  71     -13.051 -12.116  -3.049  1.00  0.00           H  
ATOM   1166  HB3 ASP A  71     -12.510 -13.275  -4.258  1.00  0.00           H  
ATOM   1167  N   MET A  72     -10.497 -10.403  -3.867  1.00  0.00           N  
ATOM   1168  CA  MET A  72      -9.985  -9.453  -4.843  1.00  0.00           C  
ATOM   1169  C   MET A  72      -8.617  -8.950  -4.396  1.00  0.00           C  
ATOM   1170  O   MET A  72      -8.002  -8.106  -5.048  1.00  0.00           O  
ATOM   1171  CB  MET A  72     -10.953  -8.280  -5.008  1.00  0.00           C  
ATOM   1172  CG  MET A  72     -10.523  -7.280  -6.069  1.00  0.00           C  
ATOM   1173  SD  MET A  72     -11.809  -6.071  -6.443  1.00  0.00           S  
ATOM   1174  CE  MET A  72     -11.967  -5.245  -4.861  1.00  0.00           C  
ATOM   1175  H   MET A  72     -10.884 -10.065  -3.033  1.00  0.00           H  
ATOM   1176  HA  MET A  72      -9.878  -9.966  -5.788  1.00  0.00           H  
ATOM   1177  HB2 MET A  72     -11.924  -8.666  -5.280  1.00  0.00           H  
ATOM   1178  HB3 MET A  72     -11.034  -7.759  -4.066  1.00  0.00           H  
ATOM   1179  HG2 MET A  72      -9.649  -6.754  -5.717  1.00  0.00           H  
ATOM   1180  HG3 MET A  72     -10.280  -7.817  -6.974  1.00  0.00           H  
ATOM   1181  HE1 MET A  72     -11.433  -5.806  -4.108  1.00  0.00           H  
ATOM   1182  HE2 MET A  72     -11.553  -4.251  -4.931  1.00  0.00           H  
ATOM   1183  HE3 MET A  72     -13.010  -5.183  -4.590  1.00  0.00           H  
ATOM   1184  N   THR A  73      -8.148  -9.490  -3.274  1.00  0.00           N  
ATOM   1185  CA  THR A  73      -6.857  -9.127  -2.722  1.00  0.00           C  
ATOM   1186  C   THR A  73      -5.865 -10.271  -2.903  1.00  0.00           C  
ATOM   1187  O   THR A  73      -4.652 -10.061  -2.893  1.00  0.00           O  
ATOM   1188  CB  THR A  73      -6.998  -8.774  -1.236  1.00  0.00           C  
ATOM   1189  OG1 THR A  73      -8.350  -8.535  -0.901  1.00  0.00           O  
ATOM   1190  CG2 THR A  73      -6.210  -7.557  -0.817  1.00  0.00           C  
ATOM   1191  H   THR A  73      -8.686 -10.160  -2.808  1.00  0.00           H  
ATOM   1192  HA  THR A  73      -6.497  -8.269  -3.259  1.00  0.00           H  
ATOM   1193  HB  THR A  73      -6.649  -9.604  -0.652  1.00  0.00           H  
ATOM   1194  HG1 THR A  73      -8.661  -7.751  -1.361  1.00  0.00           H  
ATOM   1195 HG21 THR A  73      -6.332  -6.779  -1.551  1.00  0.00           H  
ATOM   1196 HG22 THR A  73      -6.573  -7.209   0.138  1.00  0.00           H  
ATOM   1197 HG23 THR A  73      -5.166  -7.814  -0.734  1.00  0.00           H  
ATOM   1198  N   ALA A  74      -6.387 -11.485  -3.075  1.00  0.00           N  
ATOM   1199  CA  ALA A  74      -5.544 -12.656  -3.266  1.00  0.00           C  
ATOM   1200  C   ALA A  74      -5.634 -13.181  -4.699  1.00  0.00           C  
ATOM   1201  O   ALA A  74      -5.038 -14.206  -5.028  1.00  0.00           O  
ATOM   1202  CB  ALA A  74      -5.929 -13.748  -2.279  1.00  0.00           C  
ATOM   1203  H   ALA A  74      -7.364 -11.595  -3.077  1.00  0.00           H  
ATOM   1204  HA  ALA A  74      -4.524 -12.367  -3.064  1.00  0.00           H  
ATOM   1205  HB1 ALA A  74      -5.560 -14.700  -2.633  1.00  0.00           H  
ATOM   1206  HB2 ALA A  74      -5.497 -13.529  -1.314  1.00  0.00           H  
ATOM   1207  HB3 ALA A  74      -7.004 -13.790  -2.191  1.00  0.00           H  
ATOM   1208  N   LYS A  75      -6.383 -12.480  -5.551  1.00  0.00           N  
ATOM   1209  CA  LYS A  75      -6.538 -12.894  -6.941  1.00  0.00           C  
ATOM   1210  C   LYS A  75      -6.494 -11.698  -7.891  1.00  0.00           C  
ATOM   1211  O   LYS A  75      -6.990 -11.774  -9.016  1.00  0.00           O  
ATOM   1212  CB  LYS A  75      -7.855 -13.651  -7.122  1.00  0.00           C  
ATOM   1213  CG  LYS A  75      -7.786 -14.749  -8.172  1.00  0.00           C  
ATOM   1214  CD  LYS A  75      -7.574 -16.114  -7.536  1.00  0.00           C  
ATOM   1215  CE  LYS A  75      -6.261 -16.174  -6.772  1.00  0.00           C  
ATOM   1216  NZ  LYS A  75      -5.725 -17.561  -6.697  1.00  0.00           N  
ATOM   1217  H   LYS A  75      -6.841 -11.670  -5.240  1.00  0.00           H  
ATOM   1218  HA  LYS A  75      -5.721 -13.556  -7.181  1.00  0.00           H  
ATOM   1219  HB2 LYS A  75      -8.132 -14.100  -6.180  1.00  0.00           H  
ATOM   1220  HB3 LYS A  75      -8.623 -12.950  -7.416  1.00  0.00           H  
ATOM   1221  HG2 LYS A  75      -8.713 -14.762  -8.726  1.00  0.00           H  
ATOM   1222  HG3 LYS A  75      -6.966 -14.542  -8.843  1.00  0.00           H  
ATOM   1223  HD2 LYS A  75      -8.386 -16.313  -6.854  1.00  0.00           H  
ATOM   1224  HD3 LYS A  75      -7.562 -16.864  -8.315  1.00  0.00           H  
ATOM   1225  HE2 LYS A  75      -5.539 -15.545  -7.271  1.00  0.00           H  
ATOM   1226  HE3 LYS A  75      -6.427 -15.806  -5.770  1.00  0.00           H  
ATOM   1227  HZ1 LYS A  75      -6.473 -18.218  -6.396  1.00  0.00           H  
ATOM   1228  HZ2 LYS A  75      -5.373 -17.859  -7.630  1.00  0.00           H  
ATOM   1229  HZ3 LYS A  75      -4.944 -17.606  -6.012  1.00  0.00           H  
ATOM   1230  N   GLU A  76      -5.897 -10.598  -7.441  1.00  0.00           N  
ATOM   1231  CA  GLU A  76      -5.795  -9.397  -8.264  1.00  0.00           C  
ATOM   1232  C   GLU A  76      -4.358  -8.897  -8.324  1.00  0.00           C  
ATOM   1233  O   GLU A  76      -3.842  -8.577  -9.396  1.00  0.00           O  
ATOM   1234  CB  GLU A  76      -6.712  -8.301  -7.721  1.00  0.00           C  
ATOM   1235  CG  GLU A  76      -7.491  -7.570  -8.802  1.00  0.00           C  
ATOM   1236  CD  GLU A  76      -8.269  -6.386  -8.262  1.00  0.00           C  
ATOM   1237  OE1 GLU A  76      -7.720  -5.654  -7.412  1.00  0.00           O  
ATOM   1238  OE2 GLU A  76      -9.425  -6.192  -8.689  1.00  0.00           O  
ATOM   1239  H   GLU A  76      -5.518 -10.591  -6.537  1.00  0.00           H  
ATOM   1240  HA  GLU A  76      -6.109  -9.652  -9.258  1.00  0.00           H  
ATOM   1241  HB2 GLU A  76      -7.420  -8.748  -7.040  1.00  0.00           H  
ATOM   1242  HB3 GLU A  76      -6.116  -7.578  -7.185  1.00  0.00           H  
ATOM   1243  HG2 GLU A  76      -6.799  -7.215  -9.551  1.00  0.00           H  
ATOM   1244  HG3 GLU A  76      -8.187  -8.261  -9.256  1.00  0.00           H  
ATOM   1245  N   LYS A  77      -3.721  -8.833  -7.165  1.00  0.00           N  
ATOM   1246  CA  LYS A  77      -2.341  -8.372  -7.058  1.00  0.00           C  
ATOM   1247  C   LYS A  77      -1.995  -8.136  -5.596  1.00  0.00           C  
ATOM   1248  O   LYS A  77      -0.878  -8.406  -5.153  1.00  0.00           O  
ATOM   1249  CB  LYS A  77      -2.134  -7.087  -7.867  1.00  0.00           C  
ATOM   1250  CG  LYS A  77      -1.363  -7.300  -9.160  1.00  0.00           C  
ATOM   1251  CD  LYS A  77      -1.684  -6.223 -10.183  1.00  0.00           C  
ATOM   1252  CE  LYS A  77      -0.459  -5.851 -11.002  1.00  0.00           C  
ATOM   1253  NZ  LYS A  77      -0.393  -6.609 -12.281  1.00  0.00           N  
ATOM   1254  H   LYS A  77      -4.193  -9.103  -6.349  1.00  0.00           H  
ATOM   1255  HA  LYS A  77      -1.698  -9.148  -7.450  1.00  0.00           H  
ATOM   1256  HB2 LYS A  77      -3.100  -6.672  -8.115  1.00  0.00           H  
ATOM   1257  HB3 LYS A  77      -1.591  -6.377  -7.264  1.00  0.00           H  
ATOM   1258  HG2 LYS A  77      -0.305  -7.275  -8.945  1.00  0.00           H  
ATOM   1259  HG3 LYS A  77      -1.626  -8.264  -9.569  1.00  0.00           H  
ATOM   1260  HD2 LYS A  77      -2.451  -6.589 -10.850  1.00  0.00           H  
ATOM   1261  HD3 LYS A  77      -2.041  -5.344  -9.667  1.00  0.00           H  
ATOM   1262  HE2 LYS A  77      -0.496  -4.794 -11.222  1.00  0.00           H  
ATOM   1263  HE3 LYS A  77       0.426  -6.065 -10.421  1.00  0.00           H  
ATOM   1264  HZ1 LYS A  77      -1.347  -6.717 -12.682  1.00  0.00           H  
ATOM   1265  HZ2 LYS A  77       0.203  -6.104 -12.967  1.00  0.00           H  
ATOM   1266  HZ3 LYS A  77       0.012  -7.553 -12.117  1.00  0.00           H  
ATOM   1267  N   PHE A  78      -2.977  -7.641  -4.851  1.00  0.00           N  
ATOM   1268  CA  PHE A  78      -2.812  -7.373  -3.431  1.00  0.00           C  
ATOM   1269  C   PHE A  78      -2.343  -8.606  -2.694  1.00  0.00           C  
ATOM   1270  O   PHE A  78      -2.080  -9.643  -3.303  1.00  0.00           O  
ATOM   1271  CB  PHE A  78      -4.137  -6.929  -2.828  1.00  0.00           C  
ATOM   1272  CG  PHE A  78      -4.827  -5.870  -3.621  1.00  0.00           C  
ATOM   1273  CD1 PHE A  78      -4.107  -4.842  -4.195  1.00  0.00           C  
ATOM   1274  CD2 PHE A  78      -6.195  -5.911  -3.799  1.00  0.00           C  
ATOM   1275  CE1 PHE A  78      -4.747  -3.872  -4.937  1.00  0.00           C  
ATOM   1276  CE2 PHE A  78      -6.841  -4.947  -4.535  1.00  0.00           C  
ATOM   1277  CZ  PHE A  78      -6.115  -3.921  -5.110  1.00  0.00           C  
ATOM   1278  H   PHE A  78      -3.846  -7.458  -5.270  1.00  0.00           H  
ATOM   1279  HA  PHE A  78      -2.089  -6.589  -3.311  1.00  0.00           H  
ATOM   1280  HB2 PHE A  78      -4.793  -7.780  -2.772  1.00  0.00           H  
ATOM   1281  HB3 PHE A  78      -3.966  -6.548  -1.833  1.00  0.00           H  
ATOM   1282  HD1 PHE A  78      -3.030  -4.798  -4.054  1.00  0.00           H  
ATOM   1283  HD2 PHE A  78      -6.761  -6.708  -3.346  1.00  0.00           H  
ATOM   1284  HE1 PHE A  78      -4.181  -3.074  -5.376  1.00  0.00           H  
ATOM   1285  HE2 PHE A  78      -7.911  -4.995  -4.663  1.00  0.00           H  
ATOM   1286  HZ  PHE A  78      -6.612  -3.163  -5.692  1.00  0.00           H  
ATOM   1287  N   SER A  79      -2.280  -8.477  -1.372  1.00  0.00           N  
ATOM   1288  CA  SER A  79      -1.889  -9.563  -0.481  1.00  0.00           C  
ATOM   1289  C   SER A  79      -0.839  -9.116   0.527  1.00  0.00           C  
ATOM   1290  O   SER A  79      -0.919  -9.470   1.703  1.00  0.00           O  
ATOM   1291  CB  SER A  79      -1.373 -10.792  -1.242  1.00  0.00           C  
ATOM   1292  OG  SER A  79      -0.845 -11.757  -0.349  1.00  0.00           O  
ATOM   1293  H   SER A  79      -2.537  -7.616  -0.975  1.00  0.00           H  
ATOM   1294  HA  SER A  79      -2.775  -9.840   0.059  1.00  0.00           H  
ATOM   1295  HB2 SER A  79      -2.186 -11.238  -1.793  1.00  0.00           H  
ATOM   1296  HB3 SER A  79      -0.595 -10.490  -1.927  1.00  0.00           H  
ATOM   1297  HG  SER A  79       0.107 -11.808  -0.458  1.00  0.00           H  
ATOM   1298  N   PRO A  80       0.196  -8.382   0.090  1.00  0.00           N  
ATOM   1299  CA  PRO A  80       1.264  -7.960   0.966  1.00  0.00           C  
ATOM   1300  C   PRO A  80       1.160  -6.523   1.460  1.00  0.00           C  
ATOM   1301  O   PRO A  80       0.814  -6.292   2.619  1.00  0.00           O  
ATOM   1302  CB  PRO A  80       2.488  -8.142   0.070  1.00  0.00           C  
ATOM   1303  CG  PRO A  80       1.981  -7.970  -1.341  1.00  0.00           C  
ATOM   1304  CD  PRO A  80       0.465  -7.964  -1.284  1.00  0.00           C  
ATOM   1305  HA  PRO A  80       1.328  -8.605   1.815  1.00  0.00           H  
ATOM   1306  HB2 PRO A  80       3.228  -7.395   0.317  1.00  0.00           H  
ATOM   1307  HB3 PRO A  80       2.902  -9.128   0.221  1.00  0.00           H  
ATOM   1308  HG2 PRO A  80       2.338  -7.035  -1.743  1.00  0.00           H  
ATOM   1309  HG3 PRO A  80       2.326  -8.792  -1.950  1.00  0.00           H  
ATOM   1310  HD2 PRO A  80       0.083  -6.972  -1.469  1.00  0.00           H  
ATOM   1311  HD3 PRO A  80       0.056  -8.668  -1.992  1.00  0.00           H  
ATOM   1312  N   LEU A  81       1.458  -5.553   0.602  1.00  0.00           N  
ATOM   1313  CA  LEU A  81       1.385  -4.163   1.015  1.00  0.00           C  
ATOM   1314  C   LEU A  81       0.030  -3.595   0.657  1.00  0.00           C  
ATOM   1315  O   LEU A  81      -0.213  -2.394   0.770  1.00  0.00           O  
ATOM   1316  CB  LEU A  81       2.498  -3.348   0.370  1.00  0.00           C  
ATOM   1317  CG  LEU A  81       3.839  -3.404   1.106  1.00  0.00           C  
ATOM   1318  CD1 LEU A  81       3.748  -2.676   2.439  1.00  0.00           C  
ATOM   1319  CD2 LEU A  81       4.269  -4.848   1.318  1.00  0.00           C  
ATOM   1320  H   LEU A  81       1.721  -5.769  -0.324  1.00  0.00           H  
ATOM   1321  HA  LEU A  81       1.501  -4.132   2.088  1.00  0.00           H  
ATOM   1322  HB2 LEU A  81       2.644  -3.706  -0.642  1.00  0.00           H  
ATOM   1323  HB3 LEU A  81       2.180  -2.320   0.331  1.00  0.00           H  
ATOM   1324  HG  LEU A  81       4.590  -2.915   0.507  1.00  0.00           H  
ATOM   1325 HD11 LEU A  81       3.084  -1.830   2.344  1.00  0.00           H  
ATOM   1326 HD12 LEU A  81       3.368  -3.349   3.193  1.00  0.00           H  
ATOM   1327 HD13 LEU A  81       4.731  -2.330   2.729  1.00  0.00           H  
ATOM   1328 HD21 LEU A  81       3.466  -5.398   1.787  1.00  0.00           H  
ATOM   1329 HD22 LEU A  81       4.503  -5.298   0.365  1.00  0.00           H  
ATOM   1330 HD23 LEU A  81       5.142  -4.873   1.954  1.00  0.00           H  
ATOM   1331  N   THR A  82      -0.851  -4.482   0.227  1.00  0.00           N  
ATOM   1332  CA  THR A  82      -2.187  -4.110  -0.148  1.00  0.00           C  
ATOM   1333  C   THR A  82      -3.213  -4.957   0.590  1.00  0.00           C  
ATOM   1334  O   THR A  82      -4.416  -4.771   0.417  1.00  0.00           O  
ATOM   1335  CB  THR A  82      -2.355  -4.241  -1.651  1.00  0.00           C  
ATOM   1336  OG1 THR A  82      -1.110  -4.511  -2.273  1.00  0.00           O  
ATOM   1337  CG2 THR A  82      -2.917  -2.984  -2.277  1.00  0.00           C  
ATOM   1338  H   THR A  82      -0.590  -5.423   0.164  1.00  0.00           H  
ATOM   1339  HA  THR A  82      -2.332  -3.081   0.123  1.00  0.00           H  
ATOM   1340  HB  THR A  82      -3.025  -5.061  -1.859  1.00  0.00           H  
ATOM   1341  HG1 THR A  82      -0.909  -5.445  -2.191  1.00  0.00           H  
ATOM   1342 HG21 THR A  82      -2.905  -2.186  -1.550  1.00  0.00           H  
ATOM   1343 HG22 THR A  82      -2.309  -2.701  -3.124  1.00  0.00           H  
ATOM   1344 HG23 THR A  82      -3.931  -3.159  -2.600  1.00  0.00           H  
ATOM   1345  N   SER A  83      -2.742  -5.874   1.440  1.00  0.00           N  
ATOM   1346  CA  SER A  83      -3.653  -6.707   2.204  1.00  0.00           C  
ATOM   1347  C   SER A  83      -3.914  -6.082   3.569  1.00  0.00           C  
ATOM   1348  O   SER A  83      -4.147  -6.774   4.560  1.00  0.00           O  
ATOM   1349  CB  SER A  83      -3.105  -8.118   2.377  1.00  0.00           C  
ATOM   1350  OG  SER A  83      -3.918  -8.877   3.255  1.00  0.00           O  
ATOM   1351  H   SER A  83      -1.774  -5.979   1.563  1.00  0.00           H  
ATOM   1352  HA  SER A  83      -4.575  -6.744   1.651  1.00  0.00           H  
ATOM   1353  HB2 SER A  83      -3.078  -8.609   1.420  1.00  0.00           H  
ATOM   1354  HB3 SER A  83      -2.107  -8.065   2.786  1.00  0.00           H  
ATOM   1355  HG  SER A  83      -4.823  -8.878   2.935  1.00  0.00           H  
ATOM   1356  N   ASN A  84      -3.881  -4.763   3.587  1.00  0.00           N  
ATOM   1357  CA  ASN A  84      -4.118  -3.977   4.784  1.00  0.00           C  
ATOM   1358  C   ASN A  84      -4.805  -2.703   4.351  1.00  0.00           C  
ATOM   1359  O   ASN A  84      -5.821  -2.296   4.914  1.00  0.00           O  
ATOM   1360  CB  ASN A  84      -2.804  -3.665   5.505  1.00  0.00           C  
ATOM   1361  CG  ASN A  84      -3.025  -3.157   6.915  1.00  0.00           C  
ATOM   1362  OD1 ASN A  84      -4.095  -3.341   7.494  1.00  0.00           O  
ATOM   1363  ND2 ASN A  84      -2.009  -2.510   7.476  1.00  0.00           N  
ATOM   1364  H   ASN A  84      -3.707  -4.290   2.748  1.00  0.00           H  
ATOM   1365  HA  ASN A  84      -4.774  -4.536   5.438  1.00  0.00           H  
ATOM   1366  HB2 ASN A  84      -2.207  -4.563   5.555  1.00  0.00           H  
ATOM   1367  HB3 ASN A  84      -2.268  -2.910   4.948  1.00  0.00           H  
ATOM   1368 HD21 ASN A  84      -1.187  -2.400   6.956  1.00  0.00           H  
ATOM   1369 HD22 ASN A  84      -2.125  -2.170   8.388  1.00  0.00           H  
ATOM   1370  N   LEU A  85      -4.262  -2.117   3.291  1.00  0.00           N  
ATOM   1371  CA  LEU A  85      -4.836  -0.930   2.707  1.00  0.00           C  
ATOM   1372  C   LEU A  85      -6.181  -1.294   2.091  1.00  0.00           C  
ATOM   1373  O   LEU A  85      -7.031  -0.430   1.878  1.00  0.00           O  
ATOM   1374  CB  LEU A  85      -3.905  -0.355   1.634  1.00  0.00           C  
ATOM   1375  CG  LEU A  85      -4.316   1.013   1.083  1.00  0.00           C  
ATOM   1376  CD1 LEU A  85      -3.678   2.130   1.895  1.00  0.00           C  
ATOM   1377  CD2 LEU A  85      -3.933   1.134  -0.385  1.00  0.00           C  
ATOM   1378  H   LEU A  85      -3.478  -2.524   2.868  1.00  0.00           H  
ATOM   1379  HA  LEU A  85      -4.985  -0.200   3.488  1.00  0.00           H  
ATOM   1380  HB2 LEU A  85      -2.915  -0.269   2.054  1.00  0.00           H  
ATOM   1381  HB3 LEU A  85      -3.867  -1.052   0.810  1.00  0.00           H  
ATOM   1382  HG  LEU A  85      -5.389   1.118   1.160  1.00  0.00           H  
ATOM   1383 HD11 LEU A  85      -2.646   1.886   2.092  1.00  0.00           H  
ATOM   1384 HD12 LEU A  85      -3.730   3.054   1.338  1.00  0.00           H  
ATOM   1385 HD13 LEU A  85      -4.207   2.242   2.830  1.00  0.00           H  
ATOM   1386 HD21 LEU A  85      -3.057   0.534  -0.579  1.00  0.00           H  
ATOM   1387 HD22 LEU A  85      -4.750   0.787  -1.000  1.00  0.00           H  
ATOM   1388 HD23 LEU A  85      -3.721   2.168  -0.618  1.00  0.00           H  
ATOM   1389  N   ILE A  86      -6.373  -2.593   1.810  1.00  0.00           N  
ATOM   1390  CA  ILE A  86      -7.619  -3.052   1.227  1.00  0.00           C  
ATOM   1391  C   ILE A  86      -8.766  -2.893   2.221  1.00  0.00           C  
ATOM   1392  O   ILE A  86      -9.814  -2.339   1.891  1.00  0.00           O  
ATOM   1393  CB  ILE A  86      -7.514  -4.523   0.745  1.00  0.00           C  
ATOM   1394  CG1 ILE A  86      -7.552  -4.570  -0.782  1.00  0.00           C  
ATOM   1395  CG2 ILE A  86      -8.620  -5.394   1.328  1.00  0.00           C  
ATOM   1396  CD1 ILE A  86      -6.267  -4.103  -1.427  1.00  0.00           C  
ATOM   1397  H   ILE A  86      -5.660  -3.253   2.001  1.00  0.00           H  
ATOM   1398  HA  ILE A  86      -7.815  -2.431   0.372  1.00  0.00           H  
ATOM   1399  HB  ILE A  86      -6.568  -4.918   1.080  1.00  0.00           H  
ATOM   1400 HG12 ILE A  86      -7.737  -5.583  -1.102  1.00  0.00           H  
ATOM   1401 HG13 ILE A  86      -8.351  -3.934  -1.136  1.00  0.00           H  
ATOM   1402 HG21 ILE A  86      -9.581  -4.957   1.103  1.00  0.00           H  
ATOM   1403 HG22 ILE A  86      -8.565  -6.383   0.896  1.00  0.00           H  
ATOM   1404 HG23 ILE A  86      -8.499  -5.463   2.399  1.00  0.00           H  
ATOM   1405 HD11 ILE A  86      -5.837  -3.307  -0.838  1.00  0.00           H  
ATOM   1406 HD12 ILE A  86      -5.571  -4.927  -1.479  1.00  0.00           H  
ATOM   1407 HD13 ILE A  86      -6.474  -3.742  -2.423  1.00  0.00           H  
ATOM   1408  N   ASN A  87      -8.555  -3.376   3.441  1.00  0.00           N  
ATOM   1409  CA  ASN A  87      -9.567  -3.276   4.483  1.00  0.00           C  
ATOM   1410  C   ASN A  87      -9.752  -1.823   4.902  1.00  0.00           C  
ATOM   1411  O   ASN A  87     -10.862  -1.386   5.199  1.00  0.00           O  
ATOM   1412  CB  ASN A  87      -9.173  -4.124   5.693  1.00  0.00           C  
ATOM   1413  CG  ASN A  87      -9.118  -5.604   5.368  1.00  0.00           C  
ATOM   1414  OD1 ASN A  87      -9.617  -6.043   4.331  1.00  0.00           O  
ATOM   1415  ND2 ASN A  87      -8.511  -6.383   6.255  1.00  0.00           N  
ATOM   1416  H   ASN A  87      -7.696  -3.800   3.646  1.00  0.00           H  
ATOM   1417  HA  ASN A  87     -10.499  -3.645   4.080  1.00  0.00           H  
ATOM   1418  HB2 ASN A  87      -8.198  -3.816   6.040  1.00  0.00           H  
ATOM   1419  HB3 ASN A  87      -9.896  -3.974   6.482  1.00  0.00           H  
ATOM   1420 HD21 ASN A  87      -8.136  -5.965   7.059  1.00  0.00           H  
ATOM   1421 HD22 ASN A  87      -8.461  -7.345   6.071  1.00  0.00           H  
ATOM   1422  N   LEU A  88      -8.650  -1.077   4.913  1.00  0.00           N  
ATOM   1423  CA  LEU A  88      -8.679   0.331   5.286  1.00  0.00           C  
ATOM   1424  C   LEU A  88      -9.430   1.150   4.243  1.00  0.00           C  
ATOM   1425  O   LEU A  88     -10.144   2.094   4.578  1.00  0.00           O  
ATOM   1426  CB  LEU A  88      -7.254   0.865   5.447  1.00  0.00           C  
ATOM   1427  CG  LEU A  88      -7.041   1.796   6.643  1.00  0.00           C  
ATOM   1428  CD1 LEU A  88      -5.654   1.599   7.233  1.00  0.00           C  
ATOM   1429  CD2 LEU A  88      -7.246   3.246   6.229  1.00  0.00           C  
ATOM   1430  H   LEU A  88      -7.797  -1.485   4.658  1.00  0.00           H  
ATOM   1431  HA  LEU A  88      -9.194   0.414   6.231  1.00  0.00           H  
ATOM   1432  HB2 LEU A  88      -6.585   0.022   5.549  1.00  0.00           H  
ATOM   1433  HB3 LEU A  88      -6.989   1.404   4.549  1.00  0.00           H  
ATOM   1434  HG  LEU A  88      -7.767   1.559   7.407  1.00  0.00           H  
ATOM   1435 HD11 LEU A  88      -5.346   0.573   7.096  1.00  0.00           H  
ATOM   1436 HD12 LEU A  88      -4.954   2.254   6.736  1.00  0.00           H  
ATOM   1437 HD13 LEU A  88      -5.676   1.830   8.288  1.00  0.00           H  
ATOM   1438 HD21 LEU A  88      -6.859   3.395   5.233  1.00  0.00           H  
ATOM   1439 HD22 LEU A  88      -8.300   3.479   6.246  1.00  0.00           H  
ATOM   1440 HD23 LEU A  88      -6.723   3.893   6.919  1.00  0.00           H  
ATOM   1441  N   LEU A  89      -9.269   0.778   2.976  1.00  0.00           N  
ATOM   1442  CA  LEU A  89      -9.939   1.479   1.890  1.00  0.00           C  
ATOM   1443  C   LEU A  89     -11.441   1.215   1.925  1.00  0.00           C  
ATOM   1444  O   LEU A  89     -12.237   2.036   1.470  1.00  0.00           O  
ATOM   1445  CB  LEU A  89      -9.357   1.054   0.540  1.00  0.00           C  
ATOM   1446  CG  LEU A  89      -8.371   2.048  -0.073  1.00  0.00           C  
ATOM   1447  CD1 LEU A  89      -7.677   1.442  -1.284  1.00  0.00           C  
ATOM   1448  CD2 LEU A  89      -9.088   3.335  -0.452  1.00  0.00           C  
ATOM   1449  H   LEU A  89      -8.689   0.013   2.767  1.00  0.00           H  
ATOM   1450  HA  LEU A  89      -9.770   2.537   2.027  1.00  0.00           H  
ATOM   1451  HB2 LEU A  89      -8.850   0.108   0.672  1.00  0.00           H  
ATOM   1452  HB3 LEU A  89     -10.170   0.913  -0.155  1.00  0.00           H  
ATOM   1453  HG  LEU A  89      -7.614   2.289   0.659  1.00  0.00           H  
ATOM   1454 HD11 LEU A  89      -7.725   0.365  -1.225  1.00  0.00           H  
ATOM   1455 HD12 LEU A  89      -8.169   1.776  -2.185  1.00  0.00           H  
ATOM   1456 HD13 LEU A  89      -6.644   1.755  -1.300  1.00  0.00           H  
ATOM   1457 HD21 LEU A  89      -9.728   3.642   0.361  1.00  0.00           H  
ATOM   1458 HD22 LEU A  89      -8.360   4.108  -0.650  1.00  0.00           H  
ATOM   1459 HD23 LEU A  89      -9.685   3.167  -1.336  1.00  0.00           H  
ATOM   1460  N   ALA A  90     -11.819   0.067   2.475  1.00  0.00           N  
ATOM   1461  CA  ALA A  90     -13.223  -0.307   2.579  1.00  0.00           C  
ATOM   1462  C   ALA A  90     -13.662  -0.385   4.038  1.00  0.00           C  
ATOM   1463  O   ALA A  90     -14.614  -1.090   4.372  1.00  0.00           O  
ATOM   1464  CB  ALA A  90     -13.469  -1.635   1.880  1.00  0.00           C  
ATOM   1465  H   ALA A  90     -11.136  -0.544   2.824  1.00  0.00           H  
ATOM   1466  HA  ALA A  90     -13.808   0.452   2.078  1.00  0.00           H  
ATOM   1467  HB1 ALA A  90     -13.117  -2.441   2.505  1.00  0.00           H  
ATOM   1468  HB2 ALA A  90     -12.939  -1.650   0.939  1.00  0.00           H  
ATOM   1469  HB3 ALA A  90     -14.527  -1.755   1.699  1.00  0.00           H  
ATOM   1470  N   GLU A  91     -12.963   0.345   4.906  1.00  0.00           N  
ATOM   1471  CA  GLU A  91     -13.286   0.356   6.328  1.00  0.00           C  
ATOM   1472  C   GLU A  91     -14.331   1.421   6.637  1.00  0.00           C  
ATOM   1473  O   GLU A  91     -15.297   1.169   7.357  1.00  0.00           O  
ATOM   1474  CB  GLU A  91     -12.026   0.607   7.160  1.00  0.00           C  
ATOM   1475  CG  GLU A  91     -12.282   0.652   8.658  1.00  0.00           C  
ATOM   1476  CD  GLU A  91     -12.240   2.061   9.215  1.00  0.00           C  
ATOM   1477  OE1 GLU A  91     -11.183   2.716   9.093  1.00  0.00           O  
ATOM   1478  OE2 GLU A  91     -13.263   2.511   9.773  1.00  0.00           O  
ATOM   1479  H   GLU A  91     -12.215   0.889   4.581  1.00  0.00           H  
ATOM   1480  HA  GLU A  91     -13.690  -0.612   6.585  1.00  0.00           H  
ATOM   1481  HB2 GLU A  91     -11.315  -0.182   6.964  1.00  0.00           H  
ATOM   1482  HB3 GLU A  91     -11.594   1.551   6.862  1.00  0.00           H  
ATOM   1483  HG2 GLU A  91     -13.258   0.233   8.856  1.00  0.00           H  
ATOM   1484  HG3 GLU A  91     -11.529   0.060   9.158  1.00  0.00           H  
ATOM   1485  N   ASN A  92     -14.129   2.614   6.088  1.00  0.00           N  
ATOM   1486  CA  ASN A  92     -15.055   3.719   6.306  1.00  0.00           C  
ATOM   1487  C   ASN A  92     -15.920   3.959   5.073  1.00  0.00           C  
ATOM   1488  O   ASN A  92     -17.042   4.452   5.178  1.00  0.00           O  
ATOM   1489  CB  ASN A  92     -14.285   4.993   6.660  1.00  0.00           C  
ATOM   1490  CG  ASN A  92     -13.388   4.810   7.869  1.00  0.00           C  
ATOM   1491  OD1 ASN A  92     -13.854   4.807   9.008  1.00  0.00           O  
ATOM   1492  ND2 ASN A  92     -12.091   4.656   7.626  1.00  0.00           N  
ATOM   1493  H   ASN A  92     -13.340   2.754   5.524  1.00  0.00           H  
ATOM   1494  HA  ASN A  92     -15.694   3.454   7.133  1.00  0.00           H  
ATOM   1495  HB2 ASN A  92     -13.670   5.280   5.821  1.00  0.00           H  
ATOM   1496  HB3 ASN A  92     -14.989   5.783   6.874  1.00  0.00           H  
ATOM   1497 HD21 ASN A  92     -11.791   4.669   6.693  1.00  0.00           H  
ATOM   1498 HD22 ASN A  92     -11.489   4.536   8.389  1.00  0.00           H  
ATOM   1499  N   GLY A  93     -15.389   3.611   3.905  1.00  0.00           N  
ATOM   1500  CA  GLY A  93     -16.126   3.799   2.669  1.00  0.00           C  
ATOM   1501  C   GLY A  93     -15.468   4.810   1.754  1.00  0.00           C  
ATOM   1502  O   GLY A  93     -16.143   5.641   1.147  1.00  0.00           O  
ATOM   1503  H   GLY A  93     -14.489   3.224   3.882  1.00  0.00           H  
ATOM   1504  HA2 GLY A  93     -16.192   2.851   2.155  1.00  0.00           H  
ATOM   1505  HA3 GLY A  93     -17.124   4.138   2.906  1.00  0.00           H  
ATOM   1506  N   ARG A  94     -14.144   4.740   1.656  1.00  0.00           N  
ATOM   1507  CA  ARG A  94     -13.390   5.657   0.810  1.00  0.00           C  
ATOM   1508  C   ARG A  94     -13.078   5.022  -0.541  1.00  0.00           C  
ATOM   1509  O   ARG A  94     -12.041   5.298  -1.142  1.00  0.00           O  
ATOM   1510  CB  ARG A  94     -12.091   6.073   1.503  1.00  0.00           C  
ATOM   1511  CG  ARG A  94     -11.441   7.301   0.889  1.00  0.00           C  
ATOM   1512  CD  ARG A  94     -10.363   7.873   1.796  1.00  0.00           C  
ATOM   1513  NE  ARG A  94     -10.856   8.996   2.590  1.00  0.00           N  
ATOM   1514  CZ  ARG A  94     -10.140   9.611   3.529  1.00  0.00           C  
ATOM   1515  NH1 ARG A  94      -8.901   9.215   3.794  1.00  0.00           N  
ATOM   1516  NH2 ARG A  94     -10.664  10.624   4.205  1.00  0.00           N  
ATOM   1517  H   ARG A  94     -13.663   4.056   2.166  1.00  0.00           H  
ATOM   1518  HA  ARG A  94     -13.998   6.535   0.649  1.00  0.00           H  
ATOM   1519  HB2 ARG A  94     -12.302   6.284   2.541  1.00  0.00           H  
ATOM   1520  HB3 ARG A  94     -11.389   5.254   1.447  1.00  0.00           H  
ATOM   1521  HG2 ARG A  94     -10.992   7.026  -0.055  1.00  0.00           H  
ATOM   1522  HG3 ARG A  94     -12.198   8.054   0.724  1.00  0.00           H  
ATOM   1523  HD2 ARG A  94     -10.022   7.095   2.463  1.00  0.00           H  
ATOM   1524  HD3 ARG A  94      -9.538   8.209   1.186  1.00  0.00           H  
ATOM   1525  HE  ARG A  94     -11.768   9.309   2.415  1.00  0.00           H  
ATOM   1526 HH11 ARG A  94      -8.500   8.452   3.288  1.00  0.00           H  
ATOM   1527 HH12 ARG A  94      -8.369   9.681   4.500  1.00  0.00           H  
ATOM   1528 HH21 ARG A  94     -11.596  10.927   4.009  1.00  0.00           H  
ATOM   1529 HH22 ARG A  94     -10.127  11.086   4.910  1.00  0.00           H  
ATOM   1530  N   LEU A  95     -13.984   4.172  -1.015  1.00  0.00           N  
ATOM   1531  CA  LEU A  95     -13.804   3.501  -2.297  1.00  0.00           C  
ATOM   1532  C   LEU A  95     -14.569   4.225  -3.399  1.00  0.00           C  
ATOM   1533  O   LEU A  95     -15.088   3.603  -4.325  1.00  0.00           O  
ATOM   1534  CB  LEU A  95     -14.266   2.046  -2.208  1.00  0.00           C  
ATOM   1535  CG  LEU A  95     -13.208   1.059  -1.711  1.00  0.00           C  
ATOM   1536  CD1 LEU A  95     -13.861  -0.086  -0.952  1.00  0.00           C  
ATOM   1537  CD2 LEU A  95     -12.386   0.530  -2.875  1.00  0.00           C  
ATOM   1538  H   LEU A  95     -14.793   3.993  -0.491  1.00  0.00           H  
ATOM   1539  HA  LEU A  95     -12.751   3.523  -2.538  1.00  0.00           H  
ATOM   1540  HB2 LEU A  95     -15.114   1.999  -1.540  1.00  0.00           H  
ATOM   1541  HB3 LEU A  95     -14.585   1.730  -3.190  1.00  0.00           H  
ATOM   1542  HG  LEU A  95     -12.540   1.570  -1.033  1.00  0.00           H  
ATOM   1543 HD11 LEU A  95     -14.878  -0.211  -1.293  1.00  0.00           H  
ATOM   1544 HD12 LEU A  95     -13.307  -0.997  -1.129  1.00  0.00           H  
ATOM   1545 HD13 LEU A  95     -13.860   0.136   0.105  1.00  0.00           H  
ATOM   1546 HD21 LEU A  95     -12.392   1.252  -3.678  1.00  0.00           H  
ATOM   1547 HD22 LEU A  95     -11.369   0.361  -2.551  1.00  0.00           H  
ATOM   1548 HD23 LEU A  95     -12.811  -0.400  -3.224  1.00  0.00           H  
ATOM   1549  N   THR A  96     -14.624   5.547  -3.291  1.00  0.00           N  
ATOM   1550  CA  THR A  96     -15.313   6.371  -4.276  1.00  0.00           C  
ATOM   1551  C   THR A  96     -14.330   7.336  -4.924  1.00  0.00           C  
ATOM   1552  O   THR A  96     -14.360   7.557  -6.134  1.00  0.00           O  
ATOM   1553  CB  THR A  96     -16.457   7.145  -3.620  1.00  0.00           C  
ATOM   1554  OG1 THR A  96     -15.956   8.232  -2.861  1.00  0.00           O  
ATOM   1555  CG2 THR A  96     -17.305   6.294  -2.699  1.00  0.00           C  
ATOM   1556  H   THR A  96     -14.182   5.981  -2.532  1.00  0.00           H  
ATOM   1557  HA  THR A  96     -15.717   5.718  -5.036  1.00  0.00           H  
ATOM   1558  HB  THR A  96     -17.102   7.540  -4.392  1.00  0.00           H  
ATOM   1559  HG1 THR A  96     -15.278   7.916  -2.259  1.00  0.00           H  
ATOM   1560 HG21 THR A  96     -17.730   5.473  -3.258  1.00  0.00           H  
ATOM   1561 HG22 THR A  96     -16.691   5.906  -1.900  1.00  0.00           H  
ATOM   1562 HG23 THR A  96     -18.100   6.895  -2.283  1.00  0.00           H  
ATOM   1563  N   ASN A  97     -13.449   7.893  -4.102  1.00  0.00           N  
ATOM   1564  CA  ASN A  97     -12.435   8.823  -4.576  1.00  0.00           C  
ATOM   1565  C   ASN A  97     -11.041   8.289  -4.261  1.00  0.00           C  
ATOM   1566  O   ASN A  97     -10.092   9.057  -4.103  1.00  0.00           O  
ATOM   1567  CB  ASN A  97     -12.629  10.195  -3.931  1.00  0.00           C  
ATOM   1568  CG  ASN A  97     -13.877  10.898  -4.429  1.00  0.00           C  
ATOM   1569  OD1 ASN A  97     -13.824  11.694  -5.367  1.00  0.00           O  
ATOM   1570  ND2 ASN A  97     -15.010  10.606  -3.800  1.00  0.00           N  
ATOM   1571  H   ASN A  97     -13.474   7.664  -3.150  1.00  0.00           H  
ATOM   1572  HA  ASN A  97     -12.542   8.916  -5.647  1.00  0.00           H  
ATOM   1573  HB2 ASN A  97     -12.709  10.076  -2.861  1.00  0.00           H  
ATOM   1574  HB3 ASN A  97     -11.774  10.817  -4.156  1.00  0.00           H  
ATOM   1575 HD21 ASN A  97     -14.977   9.963  -3.062  1.00  0.00           H  
ATOM   1576 HD22 ASN A  97     -15.833  11.046  -4.102  1.00  0.00           H  
ATOM   1577  N   THR A  98     -10.928   6.964  -4.167  1.00  0.00           N  
ATOM   1578  CA  THR A  98      -9.653   6.327  -3.865  1.00  0.00           C  
ATOM   1579  C   THR A  98      -8.649   6.471  -5.015  1.00  0.00           C  
ATOM   1580  O   THR A  98      -7.443   6.535  -4.773  1.00  0.00           O  
ATOM   1581  CB  THR A  98      -9.855   4.847  -3.524  1.00  0.00           C  
ATOM   1582  OG1 THR A  98      -8.669   4.292  -2.985  1.00  0.00           O  
ATOM   1583  CG2 THR A  98     -10.258   3.996  -4.709  1.00  0.00           C  
ATOM   1584  H   THR A  98     -11.722   6.403  -4.298  1.00  0.00           H  
ATOM   1585  HA  THR A  98      -9.248   6.823  -2.997  1.00  0.00           H  
ATOM   1586  HB  THR A  98     -10.634   4.764  -2.778  1.00  0.00           H  
ATOM   1587  HG1 THR A  98      -7.982   4.290  -3.657  1.00  0.00           H  
ATOM   1588 HG21 THR A  98      -9.666   4.270  -5.568  1.00  0.00           H  
ATOM   1589 HG22 THR A  98     -10.094   2.954  -4.476  1.00  0.00           H  
ATOM   1590 HG23 THR A  98     -11.304   4.155  -4.926  1.00  0.00           H  
ATOM   1591  N   PRO A  99      -9.112   6.526  -6.284  1.00  0.00           N  
ATOM   1592  CA  PRO A  99      -8.210   6.664  -7.433  1.00  0.00           C  
ATOM   1593  C   PRO A  99      -7.252   7.839  -7.275  1.00  0.00           C  
ATOM   1594  O   PRO A  99      -6.169   7.854  -7.860  1.00  0.00           O  
ATOM   1595  CB  PRO A  99      -9.160   6.898  -8.610  1.00  0.00           C  
ATOM   1596  CG  PRO A  99     -10.435   6.256  -8.190  1.00  0.00           C  
ATOM   1597  CD  PRO A  99     -10.527   6.463  -6.705  1.00  0.00           C  
ATOM   1598  HA  PRO A  99      -7.642   5.761  -7.598  1.00  0.00           H  
ATOM   1599  HB2 PRO A  99      -9.284   7.958  -8.771  1.00  0.00           H  
ATOM   1600  HB3 PRO A  99      -8.758   6.435  -9.498  1.00  0.00           H  
ATOM   1601  HG2 PRO A  99     -11.267   6.730  -8.690  1.00  0.00           H  
ATOM   1602  HG3 PRO A  99     -10.409   5.200  -8.420  1.00  0.00           H  
ATOM   1603  HD2 PRO A  99     -11.036   7.390  -6.489  1.00  0.00           H  
ATOM   1604  HD3 PRO A  99     -11.034   5.635  -6.239  1.00  0.00           H  
ATOM   1605  N   ALA A 100      -7.655   8.821  -6.474  1.00  0.00           N  
ATOM   1606  CA  ALA A 100      -6.830   9.997  -6.234  1.00  0.00           C  
ATOM   1607  C   ALA A 100      -5.678   9.668  -5.290  1.00  0.00           C  
ATOM   1608  O   ALA A 100      -4.610  10.277  -5.361  1.00  0.00           O  
ATOM   1609  CB  ALA A 100      -7.676  11.126  -5.666  1.00  0.00           C  
ATOM   1610  H   ALA A 100      -8.527   8.751  -6.032  1.00  0.00           H  
ATOM   1611  HA  ALA A 100      -6.426  10.321  -7.181  1.00  0.00           H  
ATOM   1612  HB1 ALA A 100      -8.712  10.966  -5.926  1.00  0.00           H  
ATOM   1613  HB2 ALA A 100      -7.574  11.147  -4.590  1.00  0.00           H  
ATOM   1614  HB3 ALA A 100      -7.342  12.068  -6.077  1.00  0.00           H  
ATOM   1615  N   VAL A 101      -5.901   8.698  -4.408  1.00  0.00           N  
ATOM   1616  CA  VAL A 101      -4.882   8.284  -3.452  1.00  0.00           C  
ATOM   1617  C   VAL A 101      -3.755   7.529  -4.148  1.00  0.00           C  
ATOM   1618  O   VAL A 101      -2.593   7.628  -3.756  1.00  0.00           O  
ATOM   1619  CB  VAL A 101      -5.477   7.393  -2.346  1.00  0.00           C  
ATOM   1620  CG1 VAL A 101      -4.441   7.108  -1.269  1.00  0.00           C  
ATOM   1621  CG2 VAL A 101      -6.716   8.042  -1.746  1.00  0.00           C  
ATOM   1622  H   VAL A 101      -6.772   8.248  -4.400  1.00  0.00           H  
ATOM   1623  HA  VAL A 101      -4.476   9.173  -2.991  1.00  0.00           H  
ATOM   1624  HB  VAL A 101      -5.770   6.451  -2.789  1.00  0.00           H  
ATOM   1625 HG11 VAL A 101      -3.720   7.913  -1.242  1.00  0.00           H  
ATOM   1626 HG12 VAL A 101      -4.930   7.031  -0.309  1.00  0.00           H  
ATOM   1627 HG13 VAL A 101      -3.936   6.180  -1.491  1.00  0.00           H  
ATOM   1628 HG21 VAL A 101      -6.666   9.112  -1.888  1.00  0.00           H  
ATOM   1629 HG22 VAL A 101      -7.598   7.654  -2.232  1.00  0.00           H  
ATOM   1630 HG23 VAL A 101      -6.762   7.821  -0.689  1.00  0.00           H  
ATOM   1631  N   ILE A 102      -4.108   6.773  -5.183  1.00  0.00           N  
ATOM   1632  CA  ILE A 102      -3.127   6.002  -5.937  1.00  0.00           C  
ATOM   1633  C   ILE A 102      -2.179   6.920  -6.700  1.00  0.00           C  
ATOM   1634  O   ILE A 102      -0.982   6.650  -6.800  1.00  0.00           O  
ATOM   1635  CB  ILE A 102      -3.810   5.042  -6.930  1.00  0.00           C  
ATOM   1636  CG1 ILE A 102      -4.840   4.174  -6.207  1.00  0.00           C  
ATOM   1637  CG2 ILE A 102      -2.775   4.173  -7.631  1.00  0.00           C  
ATOM   1638  CD1 ILE A 102      -6.085   3.904  -7.024  1.00  0.00           C  
ATOM   1639  H   ILE A 102      -5.051   6.736  -5.448  1.00  0.00           H  
ATOM   1640  HA  ILE A 102      -2.555   5.413  -5.233  1.00  0.00           H  
ATOM   1641  HB  ILE A 102      -4.312   5.634  -7.680  1.00  0.00           H  
ATOM   1642 HG12 ILE A 102      -4.392   3.222  -5.963  1.00  0.00           H  
ATOM   1643 HG13 ILE A 102      -5.142   4.668  -5.295  1.00  0.00           H  
ATOM   1644 HG21 ILE A 102      -1.932   4.019  -6.974  1.00  0.00           H  
ATOM   1645 HG22 ILE A 102      -3.215   3.219  -7.880  1.00  0.00           H  
ATOM   1646 HG23 ILE A 102      -2.444   4.664  -8.533  1.00  0.00           H  
ATOM   1647 HD11 ILE A 102      -6.015   4.424  -7.968  1.00  0.00           H  
ATOM   1648 HD12 ILE A 102      -6.175   2.844  -7.204  1.00  0.00           H  
ATOM   1649 HD13 ILE A 102      -6.953   4.253  -6.484  1.00  0.00           H  
ATOM   1650  N   SER A 103      -2.721   8.009  -7.239  1.00  0.00           N  
ATOM   1651  CA  SER A 103      -1.923   8.967  -7.993  1.00  0.00           C  
ATOM   1652  C   SER A 103      -0.797   9.533  -7.134  1.00  0.00           C  
ATOM   1653  O   SER A 103       0.348   9.625  -7.577  1.00  0.00           O  
ATOM   1654  CB  SER A 103      -2.807  10.104  -8.510  1.00  0.00           C  
ATOM   1655  OG  SER A 103      -2.052  11.035  -9.267  1.00  0.00           O  
ATOM   1656  H   SER A 103      -3.681   8.170  -7.124  1.00  0.00           H  
ATOM   1657  HA  SER A 103      -1.490   8.448  -8.835  1.00  0.00           H  
ATOM   1658  HB2 SER A 103      -3.585   9.696  -9.138  1.00  0.00           H  
ATOM   1659  HB3 SER A 103      -3.254  10.619  -7.671  1.00  0.00           H  
ATOM   1660  HG  SER A 103      -1.985  10.728 -10.175  1.00  0.00           H  
ATOM   1661  N   ALA A 104      -1.130   9.907  -5.904  1.00  0.00           N  
ATOM   1662  CA  ALA A 104      -0.144  10.458  -4.982  1.00  0.00           C  
ATOM   1663  C   ALA A 104       0.993   9.471  -4.746  1.00  0.00           C  
ATOM   1664  O   ALA A 104       2.136   9.866  -4.518  1.00  0.00           O  
ATOM   1665  CB  ALA A 104      -0.805  10.833  -3.663  1.00  0.00           C  
ATOM   1666  H   ALA A 104      -2.058   9.806  -5.607  1.00  0.00           H  
ATOM   1667  HA  ALA A 104       0.259  11.358  -5.424  1.00  0.00           H  
ATOM   1668  HB1 ALA A 104      -1.591  11.551  -3.846  1.00  0.00           H  
ATOM   1669  HB2 ALA A 104      -1.224   9.948  -3.208  1.00  0.00           H  
ATOM   1670  HB3 ALA A 104      -0.069  11.264  -3.002  1.00  0.00           H  
ATOM   1671  N   PHE A 105       0.670   8.182  -4.805  1.00  0.00           N  
ATOM   1672  CA  PHE A 105       1.663   7.135  -4.600  1.00  0.00           C  
ATOM   1673  C   PHE A 105       2.767   7.222  -5.647  1.00  0.00           C  
ATOM   1674  O   PHE A 105       3.929   6.935  -5.362  1.00  0.00           O  
ATOM   1675  CB  PHE A 105       1.003   5.757  -4.659  1.00  0.00           C  
ATOM   1676  CG  PHE A 105       1.800   4.678  -3.981  1.00  0.00           C  
ATOM   1677  CD1 PHE A 105       3.011   4.253  -4.505  1.00  0.00           C  
ATOM   1678  CD2 PHE A 105       1.337   4.087  -2.818  1.00  0.00           C  
ATOM   1679  CE1 PHE A 105       3.741   3.263  -3.882  1.00  0.00           C  
ATOM   1680  CE2 PHE A 105       2.063   3.096  -2.190  1.00  0.00           C  
ATOM   1681  CZ  PHE A 105       3.267   2.684  -2.723  1.00  0.00           C  
ATOM   1682  H   PHE A 105      -0.258   7.930  -4.992  1.00  0.00           H  
ATOM   1683  HA  PHE A 105       2.098   7.275  -3.622  1.00  0.00           H  
ATOM   1684  HB2 PHE A 105       0.037   5.807  -4.178  1.00  0.00           H  
ATOM   1685  HB3 PHE A 105       0.870   5.473  -5.693  1.00  0.00           H  
ATOM   1686  HD1 PHE A 105       3.385   4.702  -5.410  1.00  0.00           H  
ATOM   1687  HD2 PHE A 105       0.396   4.408  -2.402  1.00  0.00           H  
ATOM   1688  HE1 PHE A 105       4.682   2.941  -4.300  1.00  0.00           H  
ATOM   1689  HE2 PHE A 105       1.690   2.644  -1.284  1.00  0.00           H  
ATOM   1690  HZ  PHE A 105       3.837   1.911  -2.234  1.00  0.00           H  
ATOM   1691  N   SER A 106       2.394   7.611  -6.861  1.00  0.00           N  
ATOM   1692  CA  SER A 106       3.355   7.726  -7.951  1.00  0.00           C  
ATOM   1693  C   SER A 106       4.336   8.866  -7.705  1.00  0.00           C  
ATOM   1694  O   SER A 106       5.477   8.823  -8.166  1.00  0.00           O  
ATOM   1695  CB  SER A 106       2.632   7.931  -9.283  1.00  0.00           C  
ATOM   1696  OG  SER A 106       3.539   8.315 -10.302  1.00  0.00           O  
ATOM   1697  H   SER A 106       1.451   7.821  -7.029  1.00  0.00           H  
ATOM   1698  HA  SER A 106       3.911   6.803  -7.990  1.00  0.00           H  
ATOM   1699  HB2 SER A 106       2.152   7.009  -9.575  1.00  0.00           H  
ATOM   1700  HB3 SER A 106       1.888   8.705  -9.170  1.00  0.00           H  
ATOM   1701  HG  SER A 106       3.473   9.261 -10.449  1.00  0.00           H  
ATOM   1702  N   THR A 107       3.895   9.880  -6.974  1.00  0.00           N  
ATOM   1703  CA  THR A 107       4.751  11.017  -6.669  1.00  0.00           C  
ATOM   1704  C   THR A 107       5.487  10.787  -5.360  1.00  0.00           C  
ATOM   1705  O   THR A 107       6.602  11.270  -5.170  1.00  0.00           O  
ATOM   1706  CB  THR A 107       3.933  12.307  -6.600  1.00  0.00           C  
ATOM   1707  OG1 THR A 107       3.240  12.527  -7.816  1.00  0.00           O  
ATOM   1708  CG2 THR A 107       4.774  13.535  -6.324  1.00  0.00           C  
ATOM   1709  H   THR A 107       2.979   9.860  -6.626  1.00  0.00           H  
ATOM   1710  HA  THR A 107       5.484  11.099  -7.458  1.00  0.00           H  
ATOM   1711  HB  THR A 107       3.206  12.219  -5.806  1.00  0.00           H  
ATOM   1712  HG1 THR A 107       2.518  13.142  -7.666  1.00  0.00           H  
ATOM   1713 HG21 THR A 107       5.347  13.383  -5.421  1.00  0.00           H  
ATOM   1714 HG22 THR A 107       5.446  13.705  -7.151  1.00  0.00           H  
ATOM   1715 HG23 THR A 107       4.130  14.393  -6.201  1.00  0.00           H  
ATOM   1716  N   MET A 108       4.868  10.026  -4.465  1.00  0.00           N  
ATOM   1717  CA  MET A 108       5.485   9.718  -3.191  1.00  0.00           C  
ATOM   1718  C   MET A 108       6.435   8.539  -3.349  1.00  0.00           C  
ATOM   1719  O   MET A 108       7.386   8.390  -2.582  1.00  0.00           O  
ATOM   1720  CB  MET A 108       4.424   9.401  -2.143  1.00  0.00           C  
ATOM   1721  CG  MET A 108       3.512  10.576  -1.825  1.00  0.00           C  
ATOM   1722  SD  MET A 108       4.409  11.990  -1.158  1.00  0.00           S  
ATOM   1723  CE  MET A 108       3.216  12.625   0.016  1.00  0.00           C  
ATOM   1724  H   MET A 108       3.987   9.650  -4.673  1.00  0.00           H  
ATOM   1725  HA  MET A 108       6.049  10.583  -2.875  1.00  0.00           H  
ATOM   1726  HB2 MET A 108       3.814   8.584  -2.497  1.00  0.00           H  
ATOM   1727  HB3 MET A 108       4.919   9.103  -1.234  1.00  0.00           H  
ATOM   1728  HG2 MET A 108       3.012  10.881  -2.732  1.00  0.00           H  
ATOM   1729  HG3 MET A 108       2.778  10.258  -1.101  1.00  0.00           H  
ATOM   1730  HE1 MET A 108       2.265  12.134  -0.135  1.00  0.00           H  
ATOM   1731  HE2 MET A 108       3.563  12.435   1.021  1.00  0.00           H  
ATOM   1732  HE3 MET A 108       3.097  13.689  -0.129  1.00  0.00           H  
ATOM   1733  N   MET A 109       6.176   7.705  -4.357  1.00  0.00           N  
ATOM   1734  CA  MET A 109       7.022   6.551  -4.611  1.00  0.00           C  
ATOM   1735  C   MET A 109       8.328   6.975  -5.278  1.00  0.00           C  
ATOM   1736  O   MET A 109       9.270   6.193  -5.354  1.00  0.00           O  
ATOM   1737  CB  MET A 109       6.298   5.526  -5.488  1.00  0.00           C  
ATOM   1738  CG  MET A 109       6.003   6.020  -6.892  1.00  0.00           C  
ATOM   1739  SD  MET A 109       7.370   5.735  -8.033  1.00  0.00           S  
ATOM   1740  CE  MET A 109       6.874   6.753  -9.419  1.00  0.00           C  
ATOM   1741  H   MET A 109       5.407   7.875  -4.946  1.00  0.00           H  
ATOM   1742  HA  MET A 109       7.251   6.099  -3.655  1.00  0.00           H  
ATOM   1743  HB2 MET A 109       6.912   4.642  -5.565  1.00  0.00           H  
ATOM   1744  HB3 MET A 109       5.363   5.264  -5.016  1.00  0.00           H  
ATOM   1745  HG2 MET A 109       5.131   5.504  -7.264  1.00  0.00           H  
ATOM   1746  HG3 MET A 109       5.802   7.080  -6.850  1.00  0.00           H  
ATOM   1747  HE1 MET A 109       5.799   6.723  -9.523  1.00  0.00           H  
ATOM   1748  HE2 MET A 109       7.189   7.773  -9.248  1.00  0.00           H  
ATOM   1749  HE3 MET A 109       7.333   6.381 -10.323  1.00  0.00           H  
ATOM   1750  N   SER A 110       8.385   8.216  -5.763  1.00  0.00           N  
ATOM   1751  CA  SER A 110       9.595   8.715  -6.408  1.00  0.00           C  
ATOM   1752  C   SER A 110      10.456   9.489  -5.415  1.00  0.00           C  
ATOM   1753  O   SER A 110      11.650   9.685  -5.636  1.00  0.00           O  
ATOM   1754  CB  SER A 110       9.239   9.600  -7.603  1.00  0.00           C  
ATOM   1755  OG  SER A 110       9.134   8.837  -8.792  1.00  0.00           O  
ATOM   1756  H   SER A 110       7.603   8.809  -5.683  1.00  0.00           H  
ATOM   1757  HA  SER A 110      10.161   7.862  -6.754  1.00  0.00           H  
ATOM   1758  HB2 SER A 110       8.294  10.088  -7.418  1.00  0.00           H  
ATOM   1759  HB3 SER A 110      10.009  10.348  -7.736  1.00  0.00           H  
ATOM   1760  HG  SER A 110       8.662   9.342  -9.457  1.00  0.00           H  
ATOM   1761  N   VAL A 111       9.844   9.920  -4.316  1.00  0.00           N  
ATOM   1762  CA  VAL A 111      10.559  10.660  -3.287  1.00  0.00           C  
ATOM   1763  C   VAL A 111      11.298   9.712  -2.345  1.00  0.00           C  
ATOM   1764  O   VAL A 111      12.165  10.136  -1.581  1.00  0.00           O  
ATOM   1765  CB  VAL A 111       9.605  11.545  -2.464  1.00  0.00           C  
ATOM   1766  CG1 VAL A 111      10.389  12.424  -1.500  1.00  0.00           C  
ATOM   1767  CG2 VAL A 111       8.736  12.394  -3.382  1.00  0.00           C  
ATOM   1768  H   VAL A 111       8.892   9.728  -4.190  1.00  0.00           H  
ATOM   1769  HA  VAL A 111      11.281  11.298  -3.777  1.00  0.00           H  
ATOM   1770  HB  VAL A 111       8.959  10.903  -1.884  1.00  0.00           H  
ATOM   1771 HG11 VAL A 111      11.313  12.734  -1.964  1.00  0.00           H  
ATOM   1772 HG12 VAL A 111       9.802  13.296  -1.249  1.00  0.00           H  
ATOM   1773 HG13 VAL A 111      10.607  11.867  -0.601  1.00  0.00           H  
ATOM   1774 HG21 VAL A 111       8.737  11.968  -4.373  1.00  0.00           H  
ATOM   1775 HG22 VAL A 111       7.726  12.417  -3.000  1.00  0.00           H  
ATOM   1776 HG23 VAL A 111       9.129  13.399  -3.420  1.00  0.00           H  
ATOM   1777  N   HIS A 112      10.953   8.425  -2.402  1.00  0.00           N  
ATOM   1778  CA  HIS A 112      11.587   7.431  -1.557  1.00  0.00           C  
ATOM   1779  C   HIS A 112      12.953   7.036  -2.111  1.00  0.00           C  
ATOM   1780  O   HIS A 112      13.835   6.608  -1.368  1.00  0.00           O  
ATOM   1781  CB  HIS A 112      10.684   6.203  -1.442  1.00  0.00           C  
ATOM   1782  CG  HIS A 112      10.875   5.202  -2.536  1.00  0.00           C  
ATOM   1783  ND1 HIS A 112      11.023   5.542  -3.862  1.00  0.00           N  
ATOM   1784  CD2 HIS A 112      10.952   3.861  -2.486  1.00  0.00           C  
ATOM   1785  CE1 HIS A 112      11.183   4.444  -4.580  1.00  0.00           C  
ATOM   1786  NE2 HIS A 112      11.144   3.409  -3.767  1.00  0.00           N  
ATOM   1787  H   HIS A 112      10.258   8.134  -3.027  1.00  0.00           H  
ATOM   1788  HA  HIS A 112      11.715   7.861  -0.575  1.00  0.00           H  
ATOM   1789  HB2 HIS A 112      10.881   5.709  -0.503  1.00  0.00           H  
ATOM   1790  HB3 HIS A 112       9.655   6.524  -1.463  1.00  0.00           H  
ATOM   1791  HD1 HIS A 112      10.996   6.449  -4.226  1.00  0.00           H  
ATOM   1792  HD2 HIS A 112      10.871   3.262  -1.602  1.00  0.00           H  
ATOM   1793  HE1 HIS A 112      11.320   4.403  -5.650  1.00  0.00           H  
ATOM   1794  HE2 HIS A 112      11.125   2.470  -4.047  1.00  0.00           H  
ATOM   1795  N   ARG A 113      13.118   7.175  -3.426  1.00  0.00           N  
ATOM   1796  CA  ARG A 113      14.373   6.823  -4.072  1.00  0.00           C  
ATOM   1797  C   ARG A 113      15.477   7.799  -3.680  1.00  0.00           C  
ATOM   1798  O   ARG A 113      16.636   7.411  -3.529  1.00  0.00           O  
ATOM   1799  CB  ARG A 113      14.203   6.807  -5.592  1.00  0.00           C  
ATOM   1800  CG  ARG A 113      15.009   5.720  -6.284  1.00  0.00           C  
ATOM   1801  CD  ARG A 113      14.277   5.169  -7.496  1.00  0.00           C  
ATOM   1802  NE  ARG A 113      15.188   4.866  -8.596  1.00  0.00           N  
ATOM   1803  CZ  ARG A 113      14.794   4.664  -9.852  1.00  0.00           C  
ATOM   1804  NH1 ARG A 113      13.507   4.731 -10.169  1.00  0.00           N  
ATOM   1805  NH2 ARG A 113      15.689   4.393 -10.792  1.00  0.00           N  
ATOM   1806  H   ARG A 113      12.376   7.518  -3.973  1.00  0.00           H  
ATOM   1807  HA  ARG A 113      14.645   5.831  -3.738  1.00  0.00           H  
ATOM   1808  HB2 ARG A 113      13.160   6.655  -5.825  1.00  0.00           H  
ATOM   1809  HB3 ARG A 113      14.516   7.763  -5.987  1.00  0.00           H  
ATOM   1810  HG2 ARG A 113      15.953   6.134  -6.605  1.00  0.00           H  
ATOM   1811  HG3 ARG A 113      15.185   4.916  -5.584  1.00  0.00           H  
ATOM   1812  HD2 ARG A 113      13.762   4.264  -7.209  1.00  0.00           H  
ATOM   1813  HD3 ARG A 113      13.556   5.902  -7.829  1.00  0.00           H  
ATOM   1814  HE  ARG A 113      16.144   4.810  -8.389  1.00  0.00           H  
ATOM   1815 HH11 ARG A 113      12.827   4.935  -9.465  1.00  0.00           H  
ATOM   1816 HH12 ARG A 113      13.217   4.579 -11.114  1.00  0.00           H  
ATOM   1817 HH21 ARG A 113      16.660   4.342 -10.558  1.00  0.00           H  
ATOM   1818 HH22 ARG A 113      15.393   4.242 -11.734  1.00  0.00           H  
ATOM   1819  N   GLY A 114      15.110   9.066  -3.519  1.00  0.00           N  
ATOM   1820  CA  GLY A 114      16.081  10.078  -3.146  1.00  0.00           C  
ATOM   1821  C   GLY A 114      16.304  10.148  -1.648  1.00  0.00           C  
ATOM   1822  O   GLY A 114      17.371  10.555  -1.191  1.00  0.00           O  
ATOM   1823  H   GLY A 114      14.171   9.316  -3.654  1.00  0.00           H  
ATOM   1824  HA2 GLY A 114      17.021   9.854  -3.628  1.00  0.00           H  
ATOM   1825  HA3 GLY A 114      15.731  11.041  -3.493  1.00  0.00           H  
ATOM   1826  N   GLU A 115      15.292   9.750  -0.882  1.00  0.00           N  
ATOM   1827  CA  GLU A 115      15.383   9.770   0.574  1.00  0.00           C  
ATOM   1828  C   GLU A 115      16.046   8.497   1.094  1.00  0.00           C  
ATOM   1829  O   GLU A 115      15.467   7.768   1.902  1.00  0.00           O  
ATOM   1830  CB  GLU A 115      13.991   9.927   1.189  1.00  0.00           C  
ATOM   1831  CG  GLU A 115      14.003  10.017   2.707  1.00  0.00           C  
ATOM   1832  CD  GLU A 115      13.837  11.438   3.207  1.00  0.00           C  
ATOM   1833  OE1 GLU A 115      12.971  12.159   2.669  1.00  0.00           O  
ATOM   1834  OE2 GLU A 115      14.573  11.830   4.137  1.00  0.00           O  
ATOM   1835  H   GLU A 115      14.467   9.435  -1.305  1.00  0.00           H  
ATOM   1836  HA  GLU A 115      15.989  10.617   0.856  1.00  0.00           H  
ATOM   1837  HB2 GLU A 115      13.538  10.827   0.801  1.00  0.00           H  
ATOM   1838  HB3 GLU A 115      13.387   9.078   0.905  1.00  0.00           H  
ATOM   1839  HG2 GLU A 115      13.195   9.417   3.097  1.00  0.00           H  
ATOM   1840  HG3 GLU A 115      14.945   9.631   3.069  1.00  0.00           H  
ATOM   1841  N   VAL A 116      17.262   8.235   0.627  1.00  0.00           N  
ATOM   1842  CA  VAL A 116      18.003   7.052   1.045  1.00  0.00           C  
ATOM   1843  C   VAL A 116      19.510   7.299   0.983  1.00  0.00           C  
ATOM   1844  O   VAL A 116      20.005   7.925   0.046  1.00  0.00           O  
ATOM   1845  CB  VAL A 116      17.652   5.833   0.168  1.00  0.00           C  
ATOM   1846  CG1 VAL A 116      18.017   6.095  -1.286  1.00  0.00           C  
ATOM   1847  CG2 VAL A 116      18.350   4.582   0.684  1.00  0.00           C  
ATOM   1848  H   VAL A 116      17.670   8.853  -0.014  1.00  0.00           H  
ATOM   1849  HA  VAL A 116      17.723   6.828   2.064  1.00  0.00           H  
ATOM   1850  HB  VAL A 116      16.586   5.672   0.223  1.00  0.00           H  
ATOM   1851 HG11 VAL A 116      17.971   7.155  -1.483  1.00  0.00           H  
ATOM   1852 HG12 VAL A 116      19.018   5.736  -1.477  1.00  0.00           H  
ATOM   1853 HG13 VAL A 116      17.321   5.578  -1.930  1.00  0.00           H  
ATOM   1854 HG21 VAL A 116      19.416   4.754   0.722  1.00  0.00           H  
ATOM   1855 HG22 VAL A 116      17.986   4.350   1.673  1.00  0.00           H  
ATOM   1856 HG23 VAL A 116      18.142   3.756   0.020  1.00  0.00           H  
ATOM   1857  N   PRO A 117      20.265   6.811   1.985  1.00  0.00           N  
ATOM   1858  CA  PRO A 117      21.720   6.986   2.033  1.00  0.00           C  
ATOM   1859  C   PRO A 117      22.399   6.544   0.741  1.00  0.00           C  
ATOM   1860  O   PRO A 117      22.777   5.382   0.592  1.00  0.00           O  
ATOM   1861  CB  PRO A 117      22.150   6.091   3.196  1.00  0.00           C  
ATOM   1862  CG  PRO A 117      20.947   6.001   4.069  1.00  0.00           C  
ATOM   1863  CD  PRO A 117      19.762   6.052   3.147  1.00  0.00           C  
ATOM   1864  HA  PRO A 117      21.988   8.011   2.245  1.00  0.00           H  
ATOM   1865  HB2 PRO A 117      22.439   5.120   2.819  1.00  0.00           H  
ATOM   1866  HB3 PRO A 117      22.981   6.543   3.715  1.00  0.00           H  
ATOM   1867  HG2 PRO A 117      20.959   5.069   4.615  1.00  0.00           H  
ATOM   1868  HG3 PRO A 117      20.925   6.837   4.753  1.00  0.00           H  
ATOM   1869  HD2 PRO A 117      19.466   5.054   2.857  1.00  0.00           H  
ATOM   1870  HD3 PRO A 117      18.939   6.568   3.617  1.00  0.00           H  
ATOM   1871  N   CYS A 118      22.551   7.478  -0.192  1.00  0.00           N  
ATOM   1872  CA  CYS A 118      23.185   7.185  -1.472  1.00  0.00           C  
ATOM   1873  C   CYS A 118      24.700   7.330  -1.375  1.00  0.00           C  
ATOM   1874  O   CYS A 118      25.264   8.347  -1.779  1.00  0.00           O  
ATOM   1875  CB  CYS A 118      22.641   8.113  -2.559  1.00  0.00           C  
ATOM   1876  SG  CYS A 118      22.797   9.873  -2.173  1.00  0.00           S  
ATOM   1877  H   CYS A 118      22.229   8.387  -0.015  1.00  0.00           H  
ATOM   1878  HA  CYS A 118      22.949   6.164  -1.732  1.00  0.00           H  
ATOM   1879  HB2 CYS A 118      23.176   7.932  -3.478  1.00  0.00           H  
ATOM   1880  HB3 CYS A 118      21.593   7.902  -2.711  1.00  0.00           H  
ATOM   1881  HG  CYS A 118      22.237  10.360  -2.781  1.00  0.00           H  
ATOM   1882  N   THR A 119      25.353   6.305  -0.836  1.00  0.00           N  
ATOM   1883  CA  THR A 119      26.804   6.318  -0.687  1.00  0.00           C  
ATOM   1884  C   THR A 119      27.466   5.404  -1.713  1.00  0.00           C  
ATOM   1885  O   THR A 119      28.582   5.664  -2.162  1.00  0.00           O  
ATOM   1886  CB  THR A 119      27.196   5.884   0.727  1.00  0.00           C  
ATOM   1887  OG1 THR A 119      28.601   5.932   0.895  1.00  0.00           O  
ATOM   1888  CG2 THR A 119      26.740   4.482   1.070  1.00  0.00           C  
ATOM   1889  H   THR A 119      24.849   5.522  -0.533  1.00  0.00           H  
ATOM   1890  HA  THR A 119      27.145   7.329  -0.850  1.00  0.00           H  
ATOM   1891  HB  THR A 119      26.745   6.562   1.438  1.00  0.00           H  
ATOM   1892  HG1 THR A 119      28.934   6.771   0.569  1.00  0.00           H  
ATOM   1893 HG21 THR A 119      26.020   4.148   0.337  1.00  0.00           H  
ATOM   1894 HG22 THR A 119      27.590   3.817   1.069  1.00  0.00           H  
ATOM   1895 HG23 THR A 119      26.283   4.482   2.049  1.00  0.00           H  
ATOM   1896  N   VAL A 120      26.769   4.333  -2.080  1.00  0.00           N  
ATOM   1897  CA  VAL A 120      27.289   3.381  -3.054  1.00  0.00           C  
ATOM   1898  C   VAL A 120      27.156   3.920  -4.473  1.00  0.00           C  
ATOM   1899  O   VAL A 120      26.248   4.744  -4.710  1.00  0.00           O  
ATOM   1900  CB  VAL A 120      26.560   2.027  -2.960  1.00  0.00           C  
ATOM   1901  CG1 VAL A 120      27.243   0.990  -3.837  1.00  0.00           C  
ATOM   1902  CG2 VAL A 120      26.495   1.555  -1.516  1.00  0.00           C  
ATOM   1903  OXT VAL A 120      27.961   3.512  -5.337  1.00  0.00           O  
ATOM   1904  H   VAL A 120      25.885   4.180  -1.687  1.00  0.00           H  
ATOM   1905  HA  VAL A 120      28.335   3.218  -2.837  1.00  0.00           H  
ATOM   1906  HB  VAL A 120      25.549   2.160  -3.319  1.00  0.00           H  
ATOM   1907 HG11 VAL A 120      28.314   1.074  -3.727  1.00  0.00           H  
ATOM   1908 HG12 VAL A 120      26.927   0.001  -3.540  1.00  0.00           H  
ATOM   1909 HG13 VAL A 120      26.974   1.159  -4.870  1.00  0.00           H  
ATOM   1910 HG21 VAL A 120      26.206   2.379  -0.880  1.00  0.00           H  
ATOM   1911 HG22 VAL A 120      25.767   0.761  -1.429  1.00  0.00           H  
ATOM   1912 HG23 VAL A 120      27.464   1.188  -1.212  1.00  0.00           H  
TER    1913      VAL A 120                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
