
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   89 (  661),  selected   89 , name 1c6o_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 1c6o_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      -       -           -
LGA    A     2_A      -       -           -
LGA    D     3_A      -       -           -
LGA    L     4_A      -       -           -
LGA    A     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    K     8_A      -       -           -
LGA    Q     9_A      -       -           -
LGA    T    10_A      A       2          4.408
LGA    F    11_A      -       -           -
LGA    E    12_A      -       -           -
LGA    A    13_A      K       3          5.557
LGA    -       -      C       4           -
LGA    -       -      P       5           -
LGA    -       -      I       6           -
LGA    -       -      C       7           -
LGA    -       -      G       8           -
LGA    -       -      S       9           -
LGA    -       -      P      10           -
LGA    N    14_A      L      11          3.662
LGA    -       -      K      12           -
LGA    C    15_A      W      13          3.242
LGA    A    16_A      E      14          3.742
LGA    A    17_A      E      15          3.887
LGA    C    18_A      L      16          3.695
LGA    H    19_A      I      17          3.367
LGA    A    20_A      -       -           -
LGA    G    21_A      -       -           -
LGA    G    22_A      -       -           -
LGA    N    23_A      E      18          1.670
LGA    N    24_A      E      19          1.752
LGA    S    25_A      M      20           #
LGA    V    26_A      L      21           -
LGA    I    27_A      -       -           -
LGA    P    28_A      -       -           -
LGA    D    29_A      I      22          1.936
LGA    H    30_A      I      23          3.020
LGA    T    31_A      -       -           -
LGA    L    32_A      -       -           -
LGA    R    33_A      -       -           -
LGA    K    34_A      -       -           -
LGA    A    35_A      -       -           -
LGA    A    36_A      E      24          4.974
LGA    M    37_A      N      25          5.156
LGA    E    38_A      F      26          5.351
LGA    Q    39_A      E      27          4.338
LGA    F    40_A      E      28           #
LGA    L    41_A      I      29          3.598
LGA    Q    42_A      V      30           -
LGA    G    43_A      -       -           -
LGA    G    44_A      -       -           -
LGA    F    45_A      K      31          2.280
LGA    N    46_A      D      32          0.805
LGA    L    47_A      R      33          0.945
LGA    E    48_A      E      34          0.663
LGA    A    49_A      R      35          0.909
LGA    I    50_A      F      36          1.067
LGA    T    51_A      L      37          0.912
LGA    Y    52_A      A      38          0.639
LGA    Q    53_A      Q      39          1.328
LGA    V    54_A      V      40          1.816
LGA    E    55_A      E      41          1.678
LGA    N    56_A      E      42          1.724
LGA    G    57_A      F      43          1.381
LGA    K    58_A      -       -           -
LGA    G    59_A      -       -           -
LGA    A    60_A      -       -           -
LGA    M    61_A      V      44          4.326
LGA    P    62_A      F      45          2.616
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    -       -      F      54           -
LGA    A    63_A      Y      55          2.498
LGA    W    64_A      G      56          1.454
LGA    S    65_A      K      57          1.636
LGA    G    66_A      T      58          0.826
LGA    T    67_A      L      59          2.712
LGA    L    68_A      P      60          2.525
LGA    D    69_A      -       -           -
LGA    D    70_A      R      61          1.993
LGA    D    71_A      R      62          2.407
LGA    E    72_A      E      63          1.395
LGA    I    73_A      A      64          1.071
LGA    A    74_A      E      65          2.338
LGA    A    75_A      K      66          2.078
LGA    V    76_A      -       -           -
LGA    A    77_A      V      67          1.481
LGA    A    78_A      F      68          1.150
LGA    Y    79_A      E      69          2.279
LGA    V    80_A      L      70          2.179
LGA    Y    81_A      L      71          0.612
LGA    D    82_A      N      72          2.691
LGA    Q    83_A      D      73          4.100
LGA    A    84_A      -       -           -
LGA    S    85_A      F      74          2.490
LGA    G    86_A      K      75          2.098
LGA    D    87_A      G      76          4.781
LGA    K    88_A      G      77          2.937
LGA    W    89_A      I      78          2.386
LGA    -       -      D      79           -
LGA    -       -      W      80           -
LGA    -       -      E      81           -
LGA    -       -      N      82           -
LGA    -       -      K      83           -
LGA    -       -      R      84           -
LGA    -       -      V      85           -
LGA    -       -      K      86           -
LGA    -       -      L      87           -
LGA    -       -      K      88           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   89   87    5.0     56    2.81     8.93     43.437     1.926

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.828688 * X  +   0.557089 * Y  +  -0.054119 * Z  +  -2.936689
  Y_new =  -0.524648 * X  +  -0.739450 * Y  +   0.421850 * Z  +  24.278118
  Z_new =   0.194990 * X  +   0.377976 * Y  +   0.905049 * Z  + -26.264977 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.395612   -2.745981  [ DEG:    22.6669   -157.3331 ]
  Theta =  -0.196247   -2.945346  [ DEG:   -11.2441   -168.7559 ]
  Phi   =  -2.577184    0.564408  [ DEG:  -147.6618     32.3382 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1c6o_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1c6o_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   89   87   5.0   56   2.81    8.93  43.437
REMARK  ---------------------------------------------------------- 
MOLECULE 1c6o_A
HEADER    ELECTRON TRANSPORT                      07-APR-99   1C6O              
TITLE     CRYSTAL STRUCTURE OF OXIDIZED CYTOCHROME C6 FROM THE GREEN            
TITLE    2 ALGAE SCENEDESMUS OBLIQUUS                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CYTOCHROME C6;                                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 OTHER_DETAILS: OXIDIZED STATE (FE+++)                                
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SCENEDESMUS OBLIQUUS;                           
SOURCE   3 ORGANISM_COMMON: GREEN ALGA;                                         
SOURCE   4 STRAIN: D3;                                                          
SOURCE   5 ORGANELLE: CHLOROPLAST;                                              
SOURCE   6 CELLULAR_LOCATION: THYLAKOID LUMEN OF CHLOROPLAST;                   
SOURCE   7 OTHER_DETAILS: GENE IS NUCLEAR PETJ                                  
KEYWDS    ELECTRON TRANSPORT PROTEIN, CYTOCHROME-C6, OXIDIZED STATE,            
KEYWDS   2 PHOTOSYNTHESIS, DIMERIZATION                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.SCHNACKENBERG,M.E.THAN,K.MANN,G.WIEGAND,R.HUBER,W.REUTER            
REVDAT   1   12-APR-00 1C6O    0                                                
JRNL        AUTH   J.SCHNACKENBERG,M.E.THAN,K.MANN,G.WIEGAND,R.HUBER,           
JRNL        AUTH 2 W.REUTER                                                     
JRNL        TITL   AMINO ACID SEQUENCE, CRYSTALLIZATION AND STRUCTURE           
JRNL        TITL 2 DETERMINATION OF REDUCED AND OXIDIZED CYTOCHROME             
JRNL        TITL 3 C6 FROM THE GREEN ALGA SCENEDESMUS OBLIQUUS.                 
JRNL        REF    J.MOL.BIOL.                   V. 290  1019 1999              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1C6O A    1    89  UNP    P57736   CYC6_SCEOB       1     89             
DBREF  1C6O B    1    89  UNP    P57736   CYC6_SCEOB       1     89             
SEQRES   1 A   89  SER ALA ASP LEU ALA LEU GLY LYS GLN THR PHE GLU ALA          
SEQRES   2 A   89  ASN CYS ALA ALA CYS HIS ALA GLY GLY ASN ASN SER VAL          
SEQRES   3 A   89  ILE PRO ASP HIS THR LEU ARG LYS ALA ALA MET GLU GLN          
SEQRES   4 A   89  PHE LEU GLN GLY GLY PHE ASN LEU GLU ALA ILE THR TYR          
SEQRES   5 A   89  GLN VAL GLU ASN GLY LYS GLY ALA MET PRO ALA TRP SER          
SEQRES   6 A   89  GLY THR LEU ASP ASP ASP GLU ILE ALA ALA VAL ALA ALA          
SEQRES   7 A   89  TYR VAL TYR ASP GLN ALA SER GLY ASP LYS TRP                  
SEQRES   1 B   89  SER ALA ASP LEU ALA LEU GLY LYS GLN THR PHE GLU ALA          
SEQRES   2 B   89  ASN CYS ALA ALA CYS HIS ALA GLY GLY ASN ASN SER VAL          
SEQRES   3 B   89  ILE PRO ASP HIS THR LEU ARG LYS ALA ALA MET GLU GLN          
SEQRES   4 B   89  PHE LEU GLN GLY GLY PHE ASN LEU GLU ALA ILE THR TYR          
SEQRES   5 B   89  GLN VAL GLU ASN GLY LYS GLY ALA MET PRO ALA TRP SER          
SEQRES   6 B   89  GLY THR LEU ASP ASP ASP GLU ILE ALA ALA VAL ALA ALA          
SEQRES   7 B   89  TYR VAL TYR ASP GLN ALA SER GLY ASP LYS TRP                  
HET    HEM  A  90      43                                                       
HET    HEM  B  90      43                                                       
HETNAM     HEM PROTOPORPHYRIN IX CONTAINING FE                                  
HETSYN     HEM HEME                                                             
FORMUL   3  HEM    2(C34 H32 FE N4 O4)                                          
FORMUL   5  HOH   *96(H2 O)                                                     
CRYST1   49.560   49.560  152.440  90.00  90.00 120.00 P 31 2 1     12          
ATOM      1  N   SER A   1      -6.389  -3.556  14.685  0.00  0.00           N  
ATOM      2  CA  SER A   1      -7.052  -3.304  13.377  1.00 64.69           C  
ATOM      3  C   SER A   1      -5.942  -3.244  12.328  1.00 60.00           C  
ATOM      4  O   SER A   1      -4.769  -3.409  12.672  1.00 62.82           O  
ATOM      5  CB  SER A   1      -7.829  -1.978  13.429  1.00 67.16           C  
ATOM      6  OG  SER A   1      -8.841  -1.917  12.430  1.00 74.18           O  
ATOM      7  N   ALA A   2      -6.310  -3.048  11.062  1.00 50.66           N  
ATOM      8  CA  ALA A   2      -5.327  -2.964   9.991  1.00 41.84           C  
ATOM      9  C   ALA A   2      -4.798  -1.537   9.919  1.00 34.61           C  
ATOM     10  O   ALA A   2      -5.583  -0.589   9.925  1.00 33.88           O  
ATOM     11  CB  ALA A   2      -5.958  -3.380   8.653  1.00 40.23           C  
ATOM     12  N   ASP A   3      -3.476  -1.393   9.890  1.00 29.17           N  
ATOM     13  CA  ASP A   3      -2.827  -0.083   9.824  1.00 29.30           C  
ATOM     14  C   ASP A   3      -3.083   0.596   8.480  1.00 28.97           C  
ATOM     15  O   ASP A   3      -2.601   0.133   7.452  1.00 22.70           O  
ATOM     16  CB  ASP A   3      -1.321  -0.229  10.087  1.00 29.66           C  
ATOM     17  CG  ASP A   3      -0.542   1.060   9.850  1.00 36.56           C  
ATOM     18  OD1 ASP A   3      -1.143   2.152   9.815  1.00 38.20           O  
ATOM     19  OD2 ASP A   3       0.688   0.981   9.668  1.00 41.10           O  
ATOM     20  N   LEU A   4      -3.800   1.720   8.507  1.00 23.18           N  
ATOM     21  CA  LEU A   4      -4.141   2.453   7.300  1.00 25.49           C  
ATOM     22  C   LEU A   4      -2.980   3.174   6.608  1.00 30.45           C  
ATOM     23  O   LEU A   4      -3.110   3.567   5.441  1.00 26.22           O  
ATOM     24  CB  LEU A   4      -5.290   3.408   7.555  1.00 25.98           C  
ATOM     25  CG  LEU A   4      -6.646   2.765   7.852  1.00 33.40           C  
ATOM     26  CD1 LEU A   4      -7.699   3.851   7.994  1.00 29.53           C  
ATOM     27  CD2 LEU A   4      -7.042   1.806   6.735  1.00 33.75           C  
ATOM     28  N   ALA A   5      -1.878   3.382   7.329  1.00 24.76           N  
ATOM     29  CA  ALA A   5      -0.688   3.994   6.750  1.00 29.60           C  
ATOM     30  C   ALA A   5      -0.091   2.895   5.831  1.00 31.87           C  
ATOM     31  O   ALA A   5       0.239   3.160   4.670  1.00 27.75           O  
ATOM     32  CB  ALA A   5       0.315   4.371   7.846  1.00 28.45           C  
ATOM     33  N   LEU A   6       0.027   1.669   6.358  1.00 30.31           N  
ATOM     34  CA  LEU A   6       0.524   0.522   5.589  1.00 28.85           C  
ATOM     35  C   LEU A   6      -0.421   0.280   4.414  1.00 27.81           C  
ATOM     36  O   LEU A   6       0.002  -0.067   3.321  1.00 30.50           O  
ATOM     37  CB  LEU A   6       0.600  -0.736   6.450  1.00 25.92           C  
ATOM     38  CG  LEU A   6       1.010  -2.002   5.707  1.00 21.15           C  
ATOM     39  CD1 LEU A   6       2.451  -1.870   5.168  1.00 19.78           C  
ATOM     40  CD2 LEU A   6       0.899  -3.181   6.651  1.00 18.21           C  
ATOM     41  N   GLY A   7      -1.706   0.491   4.647  1.00 24.18           N  
ATOM     42  CA  GLY A   7      -2.679   0.339   3.598  1.00 18.12           C  
ATOM     43  C   GLY A   7      -2.451   1.317   2.469  1.00 25.10           C  
ATOM     44  O   GLY A   7      -2.550   0.921   1.301  1.00 23.47           O  
ATOM     45  N   LYS A   8      -2.177   2.584   2.790  1.00 23.76           N  
ATOM     46  CA  LYS A   8      -1.952   3.610   1.765  1.00 24.46           C  
ATOM     47  C   LYS A   8      -0.698   3.365   0.933  1.00 20.44           C  
ATOM     48  O   LYS A   8      -0.742   3.488  -0.293  1.00 23.43           O  
ATOM     49  CB  LYS A   8      -1.901   5.002   2.372  1.00 22.74           C  
ATOM     50  CG  LYS A   8      -1.882   6.101   1.330  1.00 25.62           C  
ATOM     51  CD  LYS A   8      -1.721   7.474   1.986  1.00 38.61           C  
ATOM     52  CE  LYS A   8      -1.581   8.647   0.991  1.00 38.55           C  
ATOM     53  NZ  LYS A   8      -1.227   9.895   1.708  0.00  0.00           N  
ATOM     54  N   GLN A   9       0.399   3.015   1.604  1.00 18.29           N  
ATOM     55  CA  GLN A   9       1.655   2.733   0.925  1.00 22.99           C  
ATOM     56  C   GLN A   9       1.589   1.460   0.070  1.00 24.90           C  
ATOM     57  O   GLN A   9       2.240   1.387  -0.967  1.00 27.16           O  
ATOM     58  CB  GLN A   9       2.801   2.648   1.920  1.00 19.20           C  
ATOM     59  CG  GLN A   9       3.070   3.971   2.654  1.00 22.66           C  
ATOM     60  CD  GLN A   9       3.282   5.149   1.725  1.00 22.21           C  
ATOM     61  OE1 GLN A   9       2.539   6.122   1.766  1.00 28.66           O  
ATOM     62  NE2 GLN A   9       4.285   5.065   0.883  1.00 22.56           N  
ATOM     63  N   THR A  10       0.843   0.454   0.537  1.00 27.59           N  
ATOM     64  CA  THR A  10       0.649  -0.806  -0.199  1.00 24.79           C  
ATOM     65  C   THR A  10      -0.175  -0.511  -1.458  1.00 24.22           C  
ATOM     66  O   THR A  10       0.158  -0.965  -2.552  1.00 25.02           O  
ATOM     67  CB  THR A  10      -0.035  -1.899   0.683  1.00 16.34           C  
ATOM     68  OG1 THR A  10       0.876  -2.315   1.699  1.00 18.25           O  
ATOM     69  CG2 THR A  10      -0.374  -3.149  -0.134  1.00 22.43           C  
ATOM     70  N   PHE A  11      -1.190   0.329  -1.320  1.00 17.92           N  
ATOM     71  CA  PHE A  11      -2.006   0.670  -2.452  1.00 20.23           C  
ATOM     72  C   PHE A  11      -1.177   1.389  -3.501  1.00 25.64           C  
ATOM     73  O   PHE A  11      -1.292   1.124  -4.692  1.00 23.73           O  
ATOM     74  CB  PHE A  11      -3.173   1.568  -2.031  1.00 17.89           C  
ATOM     75  CG  PHE A  11      -4.074   1.947  -3.155  1.00 16.41           C  
ATOM     76  CD1 PHE A  11      -5.114   1.104  -3.544  1.00 20.01           C  
ATOM     77  CD2 PHE A  11      -3.889   3.154  -3.844  1.00 22.42           C  
ATOM     78  CE1 PHE A  11      -5.965   1.452  -4.606  1.00 20.60           C  
ATOM     79  CE2 PHE A  11      -4.733   3.517  -4.909  1.00 15.39           C  
ATOM     80  CZ  PHE A  11      -5.772   2.670  -5.291  1.00 18.10           C  
ATOM     81  N   GLU A  12      -0.361   2.333  -3.061  1.00 27.74           N  
ATOM     82  CA  GLU A  12       0.436   3.104  -3.998  1.00 26.38           C  
ATOM     83  C   GLU A  12       1.481   2.286  -4.758  1.00 23.24           C  
ATOM     84  O   GLU A  12       1.641   2.452  -5.979  1.00 23.50           O  
ATOM     85  CB  GLU A  12       1.068   4.297  -3.283  1.00 23.25           C  
ATOM     86  CG  GLU A  12       0.056   5.323  -2.861  1.00 32.52           C  
ATOM     87  CD  GLU A  12       0.667   6.452  -2.058  1.00 37.50           C  
ATOM     88  OE1 GLU A  12       1.903   6.465  -1.811  1.00 49.91           O  
ATOM     89  OE2 GLU A  12      -0.105   7.349  -1.672  1.00 44.87           O  
ATOM     90  N   ALA A  13       2.164   1.407  -4.024  1.00 20.04           N  
ATOM     91  CA  ALA A  13       3.201   0.556  -4.565  1.00 22.95           C  
ATOM     92  C   ALA A  13       2.682  -0.522  -5.508  1.00 24.49           C  
ATOM     93  O   ALA A  13       3.305  -0.775  -6.527  1.00 27.13           O  
ATOM     94  CB  ALA A  13       4.002  -0.083  -3.423  1.00 12.81           C  
ATOM     95  N   ASN A  14       1.529  -1.109  -5.188  1.00 24.71           N  
ATOM     96  CA  ASN A  14       0.973  -2.196  -5.970  1.00 20.13           C  
ATOM     97  C   ASN A  14      -0.309  -1.967  -6.767  1.00 19.76           C  
ATOM     98  O   ASN A  14      -0.512  -2.602  -7.797  1.00 25.83           O  
ATOM     99  CB  ASN A  14       0.749  -3.412  -5.059  1.00 18.93           C  
ATOM    100  CG  ASN A  14       1.969  -3.750  -4.198  1.00 21.23           C  
ATOM    101  OD1 ASN A  14       2.072  -3.290  -3.064  1.00 29.99           O  
ATOM    102  ND2 ASN A  14       2.873  -4.576  -4.712  1.00 17.82           N  
ATOM    103  N   CYS A  15      -1.145  -1.023  -6.372  1.00 16.78           N  
ATOM    104  CA  CYS A  15      -2.424  -0.878  -7.048  1.00 13.47           C  
ATOM    105  C   CYS A  15      -2.637   0.360  -7.887  1.00 17.13           C  
ATOM    106  O   CYS A  15      -3.462   0.358  -8.809  1.00 19.88           O  
ATOM    107  CB  CYS A  15      -3.539  -0.983  -5.985  1.00  9.43           C  
ATOM    108  SG  CYS A  15      -3.152  -2.109  -4.657  1.00 18.38           S  
ATOM    109  N   ALA A  16      -1.925   1.430  -7.538  1.00 23.56           N  
ATOM    110  CA  ALA A  16      -2.049   2.730  -8.206  1.00 22.74           C  
ATOM    111  C   ALA A  16      -1.879   2.648  -9.712  1.00 25.53           C  
ATOM    112  O   ALA A  16      -2.560   3.357 -10.445  1.00 24.43           O  
ATOM    113  CB  ALA A  16      -1.065   3.747  -7.607  1.00 21.83           C  
ATOM    114  N   ALA A  17      -1.031   1.732 -10.172  1.00 29.67           N  
ATOM    115  CA  ALA A  17      -0.790   1.549 -11.600  1.00 28.86           C  
ATOM    116  C   ALA A  17      -2.079   1.439 -12.412  1.00 25.99           C  
ATOM    117  O   ALA A  17      -2.199   2.058 -13.473  1.00 29.11           O  
ATOM    118  CB  ALA A  17       0.083   0.341 -11.828  1.00 29.65           C  
ATOM    119  N   CYS A  18      -3.049   0.671 -11.918  1.00 26.07           N  
ATOM    120  CA  CYS A  18      -4.314   0.519 -12.631  1.00 23.63           C  
ATOM    121  C   CYS A  18      -5.496   1.189 -11.966  1.00 27.13           C  
ATOM    122  O   CYS A  18      -6.561   1.326 -12.578  1.00 27.62           O  
ATOM    123  CB  CYS A  18      -4.671  -0.947 -12.775  1.00 21.47           C  
ATOM    124  SG  CYS A  18      -3.420  -1.918 -13.559  1.00 29.68           S  
ATOM    125  N   HIS A  19      -5.342   1.548 -10.695  1.00 27.47           N  
ATOM    126  CA  HIS A  19      -6.452   2.133  -9.962  1.00 27.26           C  
ATOM    127  C   HIS A  19      -6.214   3.522  -9.376  1.00 33.12           C  
ATOM    128  O   HIS A  19      -6.789   3.872  -8.327  1.00 33.07           O  
ATOM    129  CB  HIS A  19      -6.849   1.184  -8.846  1.00 23.08           C  
ATOM    130  CG  HIS A  19      -7.347  -0.142  -9.318  1.00 13.44           C  
ATOM    131  ND1 HIS A  19      -8.539  -0.284  -9.985  1.00 19.22           N  
ATOM    132  CD2 HIS A  19      -6.911  -1.394  -9.065  1.00 13.32           C  
ATOM    133  CE1 HIS A  19      -8.832  -1.562 -10.104  1.00 19.59           C  
ATOM    134  NE2 HIS A  19      -7.858  -2.261  -9.554  1.00 18.61           N  
ATOM    135  N   ALA A  20      -5.356   4.301 -10.029  1.00 36.52           N  
ATOM    136  CA  ALA A  20      -5.065   5.658  -9.571  1.00 35.93           C  
ATOM    137  C   ALA A  20      -6.367   6.459  -9.517  1.00 33.72           C  
ATOM    138  O   ALA A  20      -7.220   6.377 -10.427  1.00 33.27           O  
ATOM    139  CB  ALA A  20      -4.054   6.327 -10.494  1.00 32.41           C  
ATOM    140  N   GLY A  21      -6.549   7.154  -8.400  1.00 33.14           N  
ATOM    141  CA  GLY A  21      -7.741   7.950  -8.204  1.00 28.96           C  
ATOM    142  C   GLY A  21      -8.986   7.120  -8.011  1.00 24.82           C  
ATOM    143  O   GLY A  21     -10.085   7.619  -8.231  1.00 35.32           O  
ATOM    144  N   GLY A  22      -8.844   5.868  -7.587  1.00 27.34           N  
ATOM    145  CA  GLY A  22     -10.019   5.025  -7.403  1.00 25.75           C  
ATOM    146  C   GLY A  22     -10.666   4.580  -8.711  1.00 26.39           C  
ATOM    147  O   GLY A  22     -11.761   4.024  -8.730  1.00 27.30           O  
ATOM    148  N   ASN A  23      -9.992   4.806  -9.826  1.00 31.05           N  
ATOM    149  CA  ASN A  23     -10.551   4.421 -11.117  1.00 33.90           C  
ATOM    150  C   ASN A  23     -10.107   3.022 -11.566  1.00 32.05           C  
ATOM    151  O   ASN A  23      -9.634   2.219 -10.755  1.00 27.30           O  
ATOM    152  CB  ASN A  23     -10.150   5.464 -12.165  1.00 44.42           C  
ATOM    153  CG  ASN A  23     -10.757   6.840 -11.889  1.00 51.84           C  
ATOM    154  OD1 ASN A  23     -11.975   6.972 -11.681  1.00 53.80           O  
ATOM    155  ND2 ASN A  23      -9.908   7.867 -11.860  1.00 55.68           N  
ATOM    156  N   ASN A  24     -10.333   2.712 -12.840  1.00 31.02           N  
ATOM    157  CA  ASN A  24      -9.909   1.433 -13.432  1.00 31.46           C  
ATOM    158  C   ASN A  24      -9.574   1.698 -14.889  1.00 33.93           C  
ATOM    159  O   ASN A  24     -10.470   1.887 -15.722  1.00 32.30           O  
ATOM    160  CB  ASN A  24     -10.994   0.371 -13.358  1.00 21.37           C  
ATOM    161  CG  ASN A  24     -10.467  -1.028 -13.673  1.00 24.64           C  
ATOM    162  OD1 ASN A  24      -9.569  -1.209 -14.491  1.00 23.32           O  
ATOM    163  ND2 ASN A  24     -11.012  -2.017 -13.002  1.00 22.99           N  
ATOM    164  N   SER A  25      -8.275   1.736 -15.177  1.00 35.44           N  
ATOM    165  CA  SER A  25      -7.769   1.996 -16.519  1.00 38.78           C  
ATOM    166  C   SER A  25      -7.909   0.831 -17.525  1.00 36.39           C  
ATOM    167  O   SER A  25      -7.737   1.020 -18.735  1.00 40.31           O  
ATOM    168  CB  SER A  25      -6.308   2.403 -16.409  1.00 32.89           C  
ATOM    169  OG  SER A  25      -5.585   1.430 -15.673  1.00 43.24           O  
ATOM    170  N   VAL A  26      -8.196  -0.364 -17.020  1.00 37.44           N  
ATOM    171  CA  VAL A  26      -8.335  -1.559 -17.846  1.00 29.77           C  
ATOM    172  C   VAL A  26      -9.814  -1.710 -18.221  1.00 36.40           C  
ATOM    173  O   VAL A  26     -10.178  -1.696 -19.393  1.00 38.47           O  
ATOM    174  CB  VAL A  26      -7.776  -2.792 -17.085  1.00 33.21           C  
ATOM    175  CG1 VAL A  26      -7.847  -4.034 -17.932  1.00 27.87           C  
ATOM    176  CG2 VAL A  26      -6.328  -2.531 -16.654  1.00 27.02           C  
ATOM    177  N   ILE A  27     -10.677  -1.860 -17.226  1.00 34.18           N  
ATOM    178  CA  ILE A  27     -12.112  -1.950 -17.479  1.00 31.19           C  
ATOM    179  C   ILE A  27     -12.709  -0.735 -16.751  1.00 39.19           C  
ATOM    180  O   ILE A  27     -13.189  -0.823 -15.615  1.00 36.03           O  
ATOM    181  CB  ILE A  27     -12.700  -3.224 -16.934  1.00 28.43           C  
ATOM    182  CG1 ILE A  27     -12.017  -4.422 -17.582  1.00 29.16           C  
ATOM    183  CG2 ILE A  27     -14.183  -3.236 -17.187  1.00 28.31           C  
ATOM    184  CD1 ILE A  27     -12.533  -5.730 -17.062  1.00 32.44           C  
ATOM    185  N   PRO A  28     -12.729   0.412 -17.440  1.00 43.55           N  
ATOM    186  CA  PRO A  28     -13.210   1.731 -17.021  1.00 40.19           C  
ATOM    187  C   PRO A  28     -14.340   1.825 -16.004  1.00 38.34           C  
ATOM    188  O   PRO A  28     -14.263   2.648 -15.090  1.00 37.43           O  
ATOM    189  CB  PRO A  28     -13.592   2.379 -18.345  1.00 38.70           C  
ATOM    190  CG  PRO A  28     -12.561   1.829 -19.273  1.00 44.36           C  
ATOM    191  CD  PRO A  28     -12.581   0.368 -18.909  1.00 45.56           C  
ATOM    192  N   ASP A  29     -15.393   1.029 -16.164  1.00 35.32           N  
ATOM    193  CA  ASP A  29     -16.513   1.102 -15.239  1.00 31.91           C  
ATOM    194  C   ASP A  29     -16.337   0.287 -13.965  1.00 30.99           C  
ATOM    195  O   ASP A  29     -17.086   0.461 -13.018  1.00 29.18           O  
ATOM    196  CB  ASP A  29     -17.838   0.770 -15.940  1.00 38.04           C  
ATOM    197  CG  ASP A  29     -17.969  -0.693 -16.308  1.00 42.18           C  
ATOM    198  OD1 ASP A  29     -16.934  -1.375 -16.456  1.00 51.46           O  
ATOM    199  OD2 ASP A  29     -19.121  -1.158 -16.449  1.00 43.23           O  
ATOM    200  N   HIS A  30     -15.323  -0.565 -13.921  1.00 28.03           N  
ATOM    201  CA  HIS A  30     -15.072  -1.364 -12.737  1.00 28.16           C  
ATOM    202  C   HIS A  30     -14.150  -0.608 -11.797  1.00 32.11           C  
ATOM    203  O   HIS A  30     -13.033  -1.066 -11.483  1.00 28.83           O  
ATOM    204  CB  HIS A  30     -14.476  -2.704 -13.141  1.00 26.26           C  
ATOM    205  CG  HIS A  30     -15.498  -3.662 -13.645  1.00 24.10           C  
ATOM    206  ND1 HIS A  30     -16.516  -3.279 -14.487  1.00 21.56           N  
ATOM    207  CD2 HIS A  30     -15.706  -4.974 -13.377  1.00 25.46           C  
ATOM    208  CE1 HIS A  30     -17.311  -4.308 -14.717  1.00 25.76           C  
ATOM    209  NE2 HIS A  30     -16.842  -5.351 -14.055  1.00 26.12           N  
ATOM    210  N   THR A  31     -14.622   0.546 -11.334  1.00 28.42           N  
ATOM    211  CA  THR A  31     -13.816   1.398 -10.449  1.00 34.87           C  
ATOM    212  C   THR A  31     -13.795   0.965  -8.979  1.00 29.05           C  
ATOM    213  O   THR A  31     -14.470   0.011  -8.603  1.00 29.60           O  
ATOM    214  CB  THR A  31     -14.291   2.837 -10.507  1.00 28.94           C  
ATOM    215  OG1 THR A  31     -15.636   2.900 -10.019  1.00 37.72           O  
ATOM    216  CG2 THR A  31     -14.257   3.337 -11.935  1.00 30.60           C  
ATOM    217  N   LEU A  32     -13.047   1.703  -8.158  1.00 29.87           N  
ATOM    218  CA  LEU A  32     -12.931   1.420  -6.730  1.00 26.31           C  
ATOM    219  C   LEU A  32     -13.890   2.265  -5.889  1.00 28.65           C  
ATOM    220  O   LEU A  32     -13.613   2.612  -4.736  1.00 26.25           O  
ATOM    221  CB  LEU A  32     -11.499   1.618  -6.251  1.00 23.57           C  
ATOM    222  CG  LEU A  32     -10.435   0.722  -6.861  1.00 21.11           C  
ATOM    223  CD1 LEU A  32      -9.228   0.677  -5.929  1.00 22.32           C  
ATOM    224  CD2 LEU A  32     -11.010  -0.666  -7.070  1.00 22.96           C  
ATOM    225  N   ARG A  33     -15.022   2.596  -6.481  1.00 29.86           N  
ATOM    226  CA  ARG A  33     -16.030   3.351  -5.783  1.00 37.47           C  
ATOM    227  C   ARG A  33     -17.109   2.392  -5.248  1.00 37.21           C  
ATOM    228  O   ARG A  33     -17.296   1.293  -5.790  1.00 36.13           O  
ATOM    229  CB  ARG A  33     -16.570   4.427  -6.724  1.00 43.38           C  
ATOM    230  CG  ARG A  33     -15.417   5.301  -7.200  1.00 56.00           C  
ATOM    231  CD  ARG A  33     -15.814   6.680  -7.687  1.00 58.58           C  
ATOM    232  NE  ARG A  33     -14.646   7.573  -7.722  1.00 67.60           N  
ATOM    233  CZ  ARG A  33     -13.715   7.576  -8.676  1.00 64.43           C  
ATOM    234  NH1 ARG A  33     -13.804   6.734  -9.698  0.00  0.00           N  
ATOM    235  NH2 ARG A  33     -12.679   8.403  -8.584  0.00  0.00           N  
ATOM    236  N   LYS A  34     -17.798   2.783  -4.170  1.00 39.14           N  
ATOM    237  CA  LYS A  34     -18.833   1.921  -3.569  1.00 37.62           C  
ATOM    238  C   LYS A  34     -19.905   1.419  -4.548  1.00 33.97           C  
ATOM    239  O   LYS A  34     -20.154   0.218  -4.607  1.00 33.82           O  
ATOM    240  CB  LYS A  34     -19.463   2.548  -2.298  1.00 36.82           C  
ATOM    241  CG  LYS A  34     -20.433   3.698  -2.552  1.00 44.59           C  
ATOM    242  CD  LYS A  34     -20.105   4.933  -1.728  0.00  0.00           C  
ATOM    243  CE  LYS A  34     -20.558   4.818  -0.282  0.00  0.00           C  
ATOM    244  NZ  LYS A  34     -20.293   6.091   0.440  0.00  0.00           N  
ATOM    245  N   ALA A  35     -20.482   2.319  -5.350  1.00 31.77           N  
ATOM    246  CA  ALA A  35     -21.514   1.942  -6.332  1.00 37.40           C  
ATOM    247  C   ALA A  35     -21.022   0.870  -7.312  1.00 37.19           C  
ATOM    248  O   ALA A  35     -21.665  -0.171  -7.493  1.00 38.87           O  
ATOM    249  CB  ALA A  35     -21.993   3.172  -7.102  1.00 34.72           C  
ATOM    250  N   ALA A  36     -19.859   1.121  -7.909  1.00 32.27           N  
ATOM    251  CA  ALA A  36     -19.266   0.198  -8.847  1.00 30.66           C  
ATOM    252  C   ALA A  36     -19.140  -1.144  -8.183  1.00 32.37           C  
ATOM    253  O   ALA A  36     -19.627  -2.139  -8.716  1.00 36.14           O  
ATOM    254  CB  ALA A  36     -17.900   0.685  -9.267  1.00 33.15           C  
ATOM    255  N   MET A  37     -18.518  -1.165  -7.003  1.00 32.65           N  
ATOM    256  CA  MET A  37     -18.323  -2.417  -6.281  1.00 30.18           C  
ATOM    257  C   MET A  37     -19.611  -3.112  -5.903  1.00 33.57           C  
ATOM    258  O   MET A  37     -19.688  -4.343  -5.950  1.00 35.33           O  
ATOM    259  CB  MET A  37     -17.422  -2.234  -5.071  1.00 27.63           C  
ATOM    260  CG  MET A  37     -16.000  -2.007  -5.481  1.00 27.30           C  
ATOM    261  SD  MET A  37     -14.810  -2.042  -4.167  1.00 30.43           S  
ATOM    262  CE  MET A  37     -14.784  -0.298  -3.780  1.00 28.54           C  
ATOM    263  N   GLU A  38     -20.623  -2.336  -5.528  1.00 41.11           N  
ATOM    264  CA  GLU A  38     -21.926  -2.908  -5.179  1.00 45.20           C  
ATOM    265  C   GLU A  38     -22.435  -3.715  -6.379  1.00 43.06           C  
ATOM    266  O   GLU A  38     -22.903  -4.842  -6.250  1.00 41.69           O  
ATOM    267  CB  GLU A  38     -22.918  -1.793  -4.827  1.00 48.80           C  
ATOM    268  CG  GLU A  38     -22.710  -1.188  -3.441  1.00 59.17           C  
ATOM    269  CD  GLU A  38     -23.449   0.132  -3.220  1.00 60.18           C  
ATOM    270  OE1 GLU A  38     -24.465   0.405  -3.906  1.00 67.79           O  
ATOM    271  OE2 GLU A  38     -23.000   0.909  -2.346  1.00 70.17           O  
ATOM    272  N   GLN A  39     -22.249  -3.151  -7.560  1.00 41.07           N  
ATOM    273  CA  GLN A  39     -22.673  -3.783  -8.782  1.00 42.06           C  
ATOM    274  C   GLN A  39     -21.774  -4.905  -9.346  1.00 41.71           C  
ATOM    275  O   GLN A  39     -22.269  -5.965  -9.736  1.00 43.37           O  
ATOM    276  CB  GLN A  39     -22.855  -2.699  -9.825  1.00 43.77           C  
ATOM    277  CG  GLN A  39     -23.484  -3.189 -11.100  1.00 63.13           C  
ATOM    278  CD  GLN A  39     -23.539  -2.115 -12.161  1.00 65.66           C  
ATOM    279  OE1 GLN A  39     -23.344  -0.926 -11.874  1.00 71.96           O  
ATOM    280  NE2 GLN A  39     -23.791  -2.525 -13.404  1.00 72.27           N  
ATOM    281  N   PHE A  40     -20.462  -4.686  -9.384  1.00 37.38           N  
ATOM    282  CA  PHE A  40     -19.543  -5.663  -9.971  1.00 33.54           C  
ATOM    283  C   PHE A  40     -18.694  -6.584  -9.114  1.00 35.78           C  
ATOM    284  O   PHE A  40     -18.179  -7.578  -9.634  1.00 39.80           O  
ATOM    285  CB  PHE A  40     -18.585  -4.953 -10.916  1.00 32.01           C  
ATOM    286  CG  PHE A  40     -19.255  -4.092 -11.925  1.00 29.44           C  
ATOM    287  CD1 PHE A  40     -20.221  -4.615 -12.771  1.00 30.97           C  
ATOM    288  CD2 PHE A  40     -18.917  -2.753 -12.033  1.00 32.12           C  
ATOM    289  CE1 PHE A  40     -20.841  -3.817 -13.710  1.00 30.71           C  
ATOM    290  CE2 PHE A  40     -19.532  -1.942 -12.971  1.00 30.49           C  
ATOM    291  CZ  PHE A  40     -20.498  -2.479 -13.811  1.00 34.60           C  
ATOM    292  N   LEU A  41     -18.455  -6.238  -7.853  1.00 30.30           N  
ATOM    293  CA  LEU A  41     -17.611  -7.075  -7.012  1.00 26.92           C  
ATOM    294  C   LEU A  41     -18.347  -8.273  -6.420  1.00 25.94           C  
ATOM    295  O   LEU A  41     -19.384  -8.129  -5.773  1.00 27.31           O  
ATOM    296  CB  LEU A  41     -16.975  -6.228  -5.911  1.00 22.11           C  
ATOM    297  CG  LEU A  41     -16.069  -6.923  -4.902  1.00 20.64           C  
ATOM    298  CD1 LEU A  41     -14.897  -7.570  -5.605  1.00 17.82           C  
ATOM    299  CD2 LEU A  41     -15.594  -5.894  -3.868  1.00 17.71           C  
ATOM    300  N   GLN A  42     -17.793  -9.461  -6.630  1.00 32.86           N  
ATOM    301  CA  GLN A  42     -18.395 -10.685  -6.113  1.00 34.91           C  
ATOM    302  C   GLN A  42     -18.440 -10.595  -4.587  1.00 32.73           C  
ATOM    303  O   GLN A  42     -17.406 -10.455  -3.941  1.00 39.94           O  
ATOM    304  CB  GLN A  42     -17.571 -11.900  -6.561  1.00 39.18           C  
ATOM    305  CG  GLN A  42     -18.074 -13.246  -6.040  1.00 60.58           C  
ATOM    306  CD  GLN A  42     -17.030 -14.365  -6.160  1.00 66.96           C  
ATOM    307  OE1 GLN A  42     -16.109 -14.309  -6.997  1.00 75.47           O  
ATOM    308  NE2 GLN A  42     -17.180 -15.396  -5.332  1.00 72.16           N  
ATOM    309  N   GLY A  43     -19.638 -10.643  -4.013  1.00 34.69           N  
ATOM    310  CA  GLY A  43     -19.758 -10.554  -2.566  1.00 32.38           C  
ATOM    311  C   GLY A  43     -20.288  -9.211  -2.100  1.00 30.65           C  
ATOM    312  O   GLY A  43     -20.674  -9.059  -0.950  1.00 33.90           O  
ATOM    313  N   GLY A  44     -20.341  -8.249  -3.011  1.00 31.74           N  
ATOM    314  CA  GLY A  44     -20.835  -6.928  -2.675  1.00 31.04           C  
ATOM    315  C   GLY A  44     -19.748  -6.077  -2.051  1.00 31.66           C  
ATOM    316  O   GLY A  44     -18.618  -6.545  -1.839  1.00 35.60           O  
ATOM    317  N   PHE A  45     -20.092  -4.818  -1.790  1.00 29.61           N  
ATOM    318  CA  PHE A  45     -19.190  -3.854  -1.176  1.00 31.21           C  
ATOM    319  C   PHE A  45     -19.030  -4.082   0.333  1.00 31.53           C  
ATOM    320  O   PHE A  45     -19.855  -3.635   1.124  1.00 29.87           O  
ATOM    321  CB  PHE A  45     -19.692  -2.428  -1.420  1.00 29.89           C  
ATOM    322  CG  PHE A  45     -18.857  -1.372  -0.745  1.00 39.83           C  
ATOM    323  CD1 PHE A  45     -17.496  -1.257  -1.024  1.00 32.81           C  
ATOM    324  CD2 PHE A  45     -19.424  -0.504   0.190  1.00 37.85           C  
ATOM    325  CE1 PHE A  45     -16.710  -0.292  -0.384  1.00 38.86           C  
ATOM    326  CE2 PHE A  45     -18.648   0.465   0.839  1.00 41.59           C  
ATOM    327  CZ  PHE A  45     -17.287   0.570   0.551  1.00 37.11           C  
ATOM    328  N   ASN A  46     -17.954  -4.759   0.721  1.00 27.50           N  
ATOM    329  CA  ASN A  46     -17.645  -5.046   2.121  1.00 28.80           C  
ATOM    330  C   ASN A  46     -16.177  -5.393   2.181  1.00 24.57           C  
ATOM    331  O   ASN A  46     -15.573  -5.768   1.188  1.00 29.71           O  
ATOM    332  CB  ASN A  46     -18.498  -6.199   2.702  1.00 25.50           C  
ATOM    333  CG  ASN A  46     -18.413  -7.477   1.880  1.00 23.11           C  
ATOM    334  OD1 ASN A  46     -17.544  -8.320   2.099  1.00 26.06           O  
ATOM    335  ND2 ASN A  46     -19.327  -7.630   0.934  1.00 26.94           N  
ATOM    336  N   LEU A  47     -15.592  -5.267   3.354  1.00 30.25           N  
ATOM    337  CA  LEU A  47     -14.182  -5.551   3.506  1.00 26.76           C  
ATOM    338  C   LEU A  47     -13.761  -6.942   3.037  1.00 26.57           C  
ATOM    339  O   LEU A  47     -12.718  -7.109   2.399  1.00 30.35           O  
ATOM    340  CB  LEU A  47     -13.785  -5.371   4.966  1.00 27.98           C  
ATOM    341  CG  LEU A  47     -12.295  -5.584   5.201  1.00 31.99           C  
ATOM    342  CD1 LEU A  47     -11.570  -4.316   4.798  1.00 32.03           C  
ATOM    343  CD2 LEU A  47     -12.014  -5.928   6.633  1.00 35.91           C  
ATOM    344  N   GLU A  48     -14.564  -7.942   3.356  1.00 24.65           N  
ATOM    345  CA  GLU A  48     -14.233  -9.314   3.016  1.00 24.11           C  
ATOM    346  C   GLU A  48     -14.210  -9.590   1.511  1.00 18.10           C  
ATOM    347  O   GLU A  48     -13.342 -10.291   1.035  1.00 21.89           O  
ATOM    348  CB  GLU A  48     -15.164 -10.280   3.758  1.00 27.73           C  
ATOM    349  CG  GLU A  48     -15.160 -10.110   5.294  1.00 38.17           C  
ATOM    350  CD  GLU A  48     -16.007  -8.911   5.828  1.00 40.07           C  
ATOM    351  OE1 GLU A  48     -16.924  -8.396   5.140  1.00 39.20           O  
ATOM    352  OE2 GLU A  48     -15.753  -8.479   6.971  1.00 44.77           O  
ATOM    353  N   ALA A  49     -15.143  -9.016   0.770  1.00 17.42           N  
ATOM    354  CA  ALA A  49     -15.208  -9.195  -0.671  1.00 20.45           C  
ATOM    355  C   ALA A  49     -13.944  -8.601  -1.308  1.00 26.06           C  
ATOM    356  O   ALA A  49     -13.319  -9.211  -2.183  1.00 26.41           O  
ATOM    357  CB  ALA A  49     -16.462  -8.518  -1.219  1.00 16.36           C  
ATOM    358  N   ILE A  50     -13.539  -7.431  -0.821  1.00 21.57           N  
ATOM    359  CA  ILE A  50     -12.360  -6.763  -1.326  1.00 18.35           C  
ATOM    360  C   ILE A  50     -11.130  -7.605  -1.066  1.00 19.63           C  
ATOM    361  O   ILE A  50     -10.323  -7.830  -1.971  1.00 19.61           O  
ATOM    362  CB  ILE A  50     -12.217  -5.346  -0.717  1.00 22.66           C  
ATOM    363  CG1 ILE A  50     -13.347  -4.464  -1.229  1.00 17.32           C  
ATOM    364  CG2 ILE A  50     -10.885  -4.712  -1.125  1.00 19.20           C  
ATOM    365  CD1 ILE A  50     -13.453  -3.121  -0.559  1.00 25.54           C  
ATOM    366  N   THR A  51     -11.011  -8.122   0.152  1.00 17.60           N  
ATOM    367  CA  THR A  51      -9.870  -8.956   0.526  1.00 20.16           C  
ATOM    368  C   THR A  51      -9.741 -10.219  -0.339  1.00 20.29           C  
ATOM    369  O   THR A  51      -8.645 -10.601  -0.764  1.00 23.57           O  
ATOM    370  CB  THR A  51      -9.950  -9.361   2.037  1.00 17.53           C  
ATOM    371  OG1 THR A  51      -9.972  -8.171   2.835  1.00 23.75           O  
ATOM    372  CG2 THR A  51      -8.756 -10.226   2.460  1.00 16.46           C  
ATOM    373  N   TYR A  52     -10.872 -10.854  -0.601  1.00 23.38           N  
ATOM    374  CA  TYR A  52     -10.891 -12.081  -1.370  1.00 23.45           C  
ATOM    375  C   TYR A  52     -10.385 -11.850  -2.789  1.00 21.76           C  
ATOM    376  O   TYR A  52      -9.584 -12.642  -3.303  1.00 22.56           O  
ATOM    377  CB  TYR A  52     -12.311 -12.663  -1.383  1.00 26.99           C  
ATOM    378  CG  TYR A  52     -12.361 -14.063  -1.933  1.00 26.20           C  
ATOM    379  CD1 TYR A  52     -12.012 -15.159  -1.139  1.00 24.83           C  
ATOM    380  CD2 TYR A  52     -12.720 -14.289  -3.253  1.00 24.19           C  
ATOM    381  CE1 TYR A  52     -12.018 -16.432  -1.653  1.00 22.09           C  
ATOM    382  CE2 TYR A  52     -12.725 -15.556  -3.773  1.00 23.49           C  
ATOM    383  CZ  TYR A  52     -12.376 -16.617  -2.975  1.00 25.05           C  
ATOM    384  OH  TYR A  52     -12.391 -17.874  -3.518  1.00 36.58           O  
ATOM    385  N   GLN A  53     -10.846 -10.770  -3.418  1.00 20.42           N  
ATOM    386  CA  GLN A  53     -10.412 -10.457  -4.777  1.00 24.94           C  
ATOM    387  C   GLN A  53      -8.925 -10.100  -4.828  1.00 27.34           C  
ATOM    388  O   GLN A  53      -8.235 -10.474  -5.771  1.00 25.03           O  
ATOM    389  CB  GLN A  53     -11.264  -9.361  -5.405  1.00 21.63           C  
ATOM    390  CG  GLN A  53     -10.884  -9.074  -6.855  1.00 27.79           C  
ATOM    391  CD  GLN A  53     -12.087  -8.720  -7.724  1.00 28.57           C  
ATOM    392  OE1 GLN A  53     -13.123  -9.383  -7.653  1.00 36.65           O  
ATOM    393  NE2 GLN A  53     -11.952  -7.691  -8.561  1.00 26.54           N  
ATOM    394  N   VAL A  54      -8.423  -9.414  -3.801  1.00 27.30           N  
ATOM    395  CA  VAL A  54      -7.009  -9.059  -3.744  1.00 20.73           C  
ATOM    396  C   VAL A  54      -6.176 -10.331  -3.586  1.00 21.80           C  
ATOM    397  O   VAL A  54      -5.141 -10.496  -4.218  1.00 20.24           O  
ATOM    398  CB  VAL A  54      -6.714  -8.064  -2.586  1.00 21.17           C  
ATOM    399  CG1 VAL A  54      -5.227  -7.905  -2.382  1.00 19.82           C  
ATOM    400  CG2 VAL A  54      -7.333  -6.726  -2.896  1.00 19.94           C  
ATOM    401  N   GLU A  55      -6.610 -11.229  -2.724  1.00 19.59           N  
ATOM    402  CA  GLU A  55      -5.874 -12.459  -2.563  1.00 22.40           C  
ATOM    403  C   GLU A  55      -5.893 -13.320  -3.815  1.00 21.76           C  
ATOM    404  O   GLU A  55      -4.853 -13.779  -4.272  1.00 24.39           O  
ATOM    405  CB  GLU A  55      -6.463 -13.274  -1.418  1.00 18.75           C  
ATOM    406  CG  GLU A  55      -6.378 -12.570  -0.103  1.00 32.72           C  
ATOM    407  CD  GLU A  55      -7.126 -13.259   1.010  1.00 33.87           C  
ATOM    408  OE1 GLU A  55      -8.237 -13.780   0.767  1.00 45.32           O  
ATOM    409  OE2 GLU A  55      -6.628 -13.243   2.155  1.00 43.00           O  
ATOM    410  N   ASN A  56      -7.066 -13.465  -4.419  1.00 24.85           N  
ATOM    411  CA  ASN A  56      -7.223 -14.370  -5.551  1.00 25.39           C  
ATOM    412  C   ASN A  56      -7.173 -13.856  -6.965  1.00 28.44           C  
ATOM    413  O   ASN A  56      -6.911 -14.623  -7.887  1.00 32.03           O  
ATOM    414  CB  ASN A  56      -8.492 -15.194  -5.344  1.00 20.98           C  
ATOM    415  CG  ASN A  56      -8.495 -15.912  -4.008  1.00 22.36           C  
ATOM    416  OD1 ASN A  56      -7.723 -16.829  -3.791  1.00 25.27           O  
ATOM    417  ND2 ASN A  56      -9.328 -15.463  -3.092  1.00 20.82           N  
ATOM    418  N   GLY A  57      -7.404 -12.564  -7.148  1.00 33.01           N  
ATOM    419  CA  GLY A  57      -7.390 -12.011  -8.488  1.00 27.81           C  
ATOM    420  C   GLY A  57      -8.732 -12.195  -9.170  1.00 28.22           C  
ATOM    421  O   GLY A  57      -9.640 -12.813  -8.618  1.00 29.10           O  
ATOM    422  N   LYS A  58      -8.853 -11.689 -10.387  1.00 25.31           N  
ATOM    423  CA  LYS A  58     -10.088 -11.788 -11.127  1.00 27.94           C  
ATOM    424  C   LYS A  58      -9.797 -11.303 -12.529  1.00 31.92           C  
ATOM    425  O   LYS A  58      -9.396 -10.154 -12.708  1.00 30.26           O  
ATOM    426  CB  LYS A  58     -11.129 -10.882 -10.500  1.00 30.47           C  
ATOM    427  CG  LYS A  58     -12.438 -10.817 -11.255  1.00 35.20           C  
ATOM    428  CD  LYS A  58     -13.242 -12.063 -11.076  1.00 47.08           C  
ATOM    429  CE  LYS A  58     -14.664 -11.850 -11.567  1.00 54.00           C  
ATOM    430  NZ  LYS A  58     -15.644 -11.872 -10.422  1.00 72.60           N  
ATOM    431  N   GLY A  59      -9.936 -12.199 -13.506  1.00 32.08           N  
ATOM    432  CA  GLY A  59      -9.713 -11.847 -14.901  1.00 20.41           C  
ATOM    433  C   GLY A  59      -8.354 -11.249 -15.154  1.00 16.85           C  
ATOM    434  O   GLY A  59      -7.339 -11.880 -14.920  1.00 22.36           O  
ATOM    435  N   ALA A  60      -8.337 -10.006 -15.605  1.00 21.81           N  
ATOM    436  CA  ALA A  60      -7.098  -9.315 -15.876  1.00 21.39           C  
ATOM    437  C   ALA A  60      -6.421  -8.807 -14.597  1.00 30.54           C  
ATOM    438  O   ALA A  60      -5.259  -8.384 -14.643  1.00 35.25           O  
ATOM    439  CB  ALA A  60      -7.340  -8.177 -16.832  1.00 27.15           C  
ATOM    440  N   MET A  61      -7.130  -8.798 -13.467  1.00 28.07           N  
ATOM    441  CA  MET A  61      -6.496  -8.356 -12.228  1.00 25.37           C  
ATOM    442  C   MET A  61      -5.751  -9.506 -11.595  1.00 18.19           C  
ATOM    443  O   MET A  61      -6.338 -10.536 -11.292  1.00 25.76           O  
ATOM    444  CB  MET A  61      -7.484  -7.840 -11.207  1.00 26.27           C  
ATOM    445  CG  MET A  61      -6.733  -7.473  -9.936  1.00 32.07           C  
ATOM    446  SD  MET A  61      -7.709  -6.570  -8.836  1.00 27.10           S  
ATOM    447  CE  MET A  61      -7.135  -7.289  -7.289  1.00 20.52           C  
ATOM    448  N   PRO A  62      -4.443  -9.349 -11.386  1.00 21.24           N  
ATOM    449  CA  PRO A  62      -3.634 -10.402 -10.772  1.00 22.59           C  
ATOM    450  C   PRO A  62      -4.012 -10.711  -9.307  1.00 28.47           C  
ATOM    451  O   PRO A  62      -4.795  -9.982  -8.660  1.00 23.30           O  
ATOM    452  CB  PRO A  62      -2.200  -9.853 -10.886  1.00 23.23           C  
ATOM    453  CG  PRO A  62      -2.391  -8.367 -10.922  1.00 21.43           C  
ATOM    454  CD  PRO A  62      -3.615  -8.192 -11.778  1.00 21.78           C  
ATOM    455  N   ALA A  63      -3.494 -11.836  -8.838  1.00 24.94           N  
ATOM    456  CA  ALA A  63      -3.688 -12.313  -7.479  1.00 29.56           C  
ATOM    457  C   ALA A  63      -2.490 -11.791  -6.707  1.00 29.97           C  
ATOM    458  O   ALA A  63      -1.384 -11.730  -7.248  1.00 27.24           O  
ATOM    459  CB  ALA A  63      -3.698 -13.824  -7.449  1.00 25.75           C  
ATOM    460  N   TRP A  64      -2.690 -11.469  -5.434  1.00 29.51           N  
ATOM    461  CA  TRP A  64      -1.616 -10.906  -4.628  1.00 27.85           C  
ATOM    462  C   TRP A  64      -1.101 -11.765  -3.477  1.00 29.80           C  
ATOM    463  O   TRP A  64      -0.112 -11.404  -2.861  1.00 34.56           O  
ATOM    464  CB  TRP A  64      -2.025  -9.495  -4.148  1.00 25.18           C  
ATOM    465  CG  TRP A  64      -2.296  -8.569  -5.308  1.00 18.25           C  
ATOM    466  CD1 TRP A  64      -3.485  -8.386  -5.975  1.00 23.47           C  
ATOM    467  CD2 TRP A  64      -1.327  -7.799  -6.010  1.00 20.74           C  
ATOM    468  NE1 TRP A  64      -3.303  -7.566  -7.063  1.00 20.92           N  
ATOM    469  CE2 TRP A  64      -1.992  -7.181  -7.105  1.00 20.71           C  
ATOM    470  CE3 TRP A  64       0.042  -7.575  -5.826  1.00 16.30           C  
ATOM    471  CZ2 TRP A  64      -1.333  -6.348  -8.008  1.00 22.99           C  
ATOM    472  CZ3 TRP A  64       0.702  -6.759  -6.717  1.00 26.32           C  
ATOM    473  CH2 TRP A  64       0.014  -6.148  -7.801  1.00 25.74           C  
ATOM    474  N   SER A  65      -1.703 -12.927  -3.239  1.00 31.10           N  
ATOM    475  CA  SER A  65      -1.288 -13.817  -2.150  1.00 39.26           C  
ATOM    476  C   SER A  65       0.200 -14.116  -2.079  1.00 38.69           C  
ATOM    477  O   SER A  65       0.730 -14.440  -1.015  1.00 45.01           O  
ATOM    478  CB  SER A  65      -2.057 -15.117  -2.216  1.00 34.06           C  
ATOM    479  OG  SER A  65      -3.437 -14.838  -2.348  1.00 59.08           O  
ATOM    480  N   GLY A  66       0.866 -14.083  -3.220  1.00 43.25           N  
ATOM    481  CA  GLY A  66       2.293 -14.312  -3.205  1.00 45.68           C  
ATOM    482  C   GLY A  66       2.975 -12.998  -2.877  1.00 43.86           C  
ATOM    483  O   GLY A  66       3.608 -12.852  -1.839  1.00 49.55           O  
ATOM    484  N   THR A  67       2.747 -12.011  -3.735  1.00 45.99           N  
ATOM    485  CA  THR A  67       3.337 -10.675  -3.625  1.00 50.95           C  
ATOM    486  C   THR A  67       3.201  -9.920  -2.283  1.00 48.06           C  
ATOM    487  O   THR A  67       4.145  -9.238  -1.861  1.00 51.71           O  
ATOM    488  CB  THR A  67       2.819  -9.774  -4.793  1.00 52.61           C  
ATOM    489  OG1 THR A  67       3.083 -10.426  -6.043  1.00 62.43           O  
ATOM    490  CG2 THR A  67       3.495  -8.400  -4.798  1.00 56.31           C  
ATOM    491  N   LEU A  68       2.046 -10.032  -1.629  1.00 37.59           N  
ATOM    492  CA  LEU A  68       1.801  -9.337  -0.369  1.00 32.57           C  
ATOM    493  C   LEU A  68       1.552 -10.310   0.780  1.00 30.74           C  
ATOM    494  O   LEU A  68       1.106 -11.436   0.568  1.00 32.03           O  
ATOM    495  CB  LEU A  68       0.583  -8.408  -0.513  1.00 31.41           C  
ATOM    496  CG  LEU A  68       0.540  -7.501  -1.745  1.00 29.11           C  
ATOM    497  CD1 LEU A  68      -0.789  -6.810  -1.850  1.00 31.32           C  
ATOM    498  CD2 LEU A  68       1.680  -6.508  -1.688  1.00 32.75           C  
ATOM    499  N   ASP A  69       1.885  -9.896   1.994  1.00 28.77           N  
ATOM    500  CA  ASP A  69       1.634 -10.743   3.139  1.00 33.32           C  
ATOM    501  C   ASP A  69       0.249 -10.398   3.665  1.00 32.81           C  
ATOM    502  O   ASP A  69      -0.352  -9.402   3.241  1.00 36.12           O  
ATOM    503  CB  ASP A  69       2.730 -10.637   4.224  1.00 35.09           C  
ATOM    504  CG  ASP A  69       2.767  -9.288   4.953  1.00 41.69           C  
ATOM    505  OD1 ASP A  69       1.829  -8.472   4.844  1.00 36.50           O  
ATOM    506  OD2 ASP A  69       3.760  -9.063   5.681  1.00 42.05           O  
ATOM    507  N   ASP A  70      -0.249 -11.219   4.579  1.00 35.62           N  
ATOM    508  CA  ASP A  70      -1.569 -11.038   5.161  1.00 41.72           C  
ATOM    509  C   ASP A  70      -1.839  -9.675   5.763  1.00 37.77           C  
ATOM    510  O   ASP A  70      -2.930  -9.140   5.613  1.00 36.30           O  
ATOM    511  CB  ASP A  70      -1.834 -12.135   6.181  1.00 55.50           C  
ATOM    512  CG  ASP A  70      -1.900 -13.509   5.535  1.00 66.38           C  
ATOM    513  OD1 ASP A  70      -0.917 -13.907   4.858  1.00 73.50           O  
ATOM    514  OD2 ASP A  70      -2.949 -14.179   5.678  1.00 73.91           O  
ATOM    515  N   ASP A  71      -0.838  -9.083   6.398  1.00 39.31           N  
ATOM    516  CA  ASP A  71      -1.023  -7.761   6.984  1.00 36.36           C  
ATOM    517  C   ASP A  71      -1.155  -6.686   5.930  1.00 34.21           C  
ATOM    518  O   ASP A  71      -2.008  -5.803   6.061  1.00 27.65           O  
ATOM    519  CB  ASP A  71       0.081  -7.432   7.988  1.00 49.35           C  
ATOM    520  CG  ASP A  71      -0.082  -8.210   9.293  1.00 52.25           C  
ATOM    521  OD1 ASP A  71      -1.224  -8.638   9.588  1.00 59.68           O  
ATOM    522  OD2 ASP A  71       0.919  -8.410  10.014  1.00 64.08           O  
ATOM    523  N   GLU A  72      -0.373  -6.803   4.854  1.00 25.81           N  
ATOM    524  CA  GLU A  72      -0.440  -5.853   3.758  1.00 25.66           C  
ATOM    525  C   GLU A  72      -1.753  -6.024   3.013  1.00 24.69           C  
ATOM    526  O   GLU A  72      -2.380  -5.038   2.617  1.00 26.50           O  
ATOM    527  CB  GLU A  72       0.756  -6.010   2.826  1.00 21.03           C  
ATOM    528  CG  GLU A  72       2.031  -5.648   3.526  1.00 27.62           C  
ATOM    529  CD  GLU A  72       3.281  -6.056   2.783  1.00 29.36           C  
ATOM    530  OE1 GLU A  72       3.204  -6.936   1.906  1.00 38.94           O  
ATOM    531  OE2 GLU A  72       4.358  -5.497   3.081  1.00 38.79           O  
ATOM    532  N   ILE A  73      -2.205  -7.263   2.849  1.00 27.01           N  
ATOM    533  CA  ILE A  73      -3.482  -7.490   2.161  1.00 20.57           C  
ATOM    534  C   ILE A  73      -4.617  -6.916   3.003  1.00 16.68           C  
ATOM    535  O   ILE A  73      -5.472  -6.191   2.498  1.00 23.68           O  
ATOM    536  CB  ILE A  73      -3.701  -9.001   1.829  1.00 22.04           C  
ATOM    537  CG1 ILE A  73      -2.790  -9.398   0.647  1.00 18.27           C  
ATOM    538  CG2 ILE A  73      -5.171  -9.267   1.482  1.00 20.56           C  
ATOM    539  CD1 ILE A  73      -2.814 -10.869   0.237  1.00 23.24           C  
ATOM    540  N   ALA A  74      -4.598  -7.198   4.297  1.00 20.53           N  
ATOM    541  CA  ALA A  74      -5.622  -6.675   5.209  1.00 23.28           C  
ATOM    542  C   ALA A  74      -5.618  -5.142   5.211  1.00 16.65           C  
ATOM    543  O   ALA A  74      -6.659  -4.504   5.072  1.00 19.38           O  
ATOM    544  CB  ALA A  74      -5.371  -7.207   6.620  1.00 25.69           C  
ATOM    545  N   ALA A  75      -4.430  -4.555   5.304  1.00 21.85           N  
ATOM    546  CA  ALA A  75      -4.285  -3.109   5.314  1.00 20.65           C  
ATOM    547  C   ALA A  75      -4.749  -2.446   4.024  1.00 23.64           C  
ATOM    548  O   ALA A  75      -5.480  -1.457   4.071  1.00 20.49           O  
ATOM    549  CB  ALA A  75      -2.834  -2.725   5.618  1.00 19.96           C  
ATOM    550  N   VAL A  76      -4.369  -2.995   2.862  1.00 24.21           N  
ATOM    551  CA  VAL A  76      -4.772  -2.378   1.602  1.00 18.01           C  
ATOM    552  C   VAL A  76      -6.257  -2.523   1.395  1.00 16.42           C  
ATOM    553  O   VAL A  76      -6.905  -1.622   0.854  1.00 17.44           O  
ATOM    554  CB  VAL A  76      -3.931  -2.878   0.367  1.00 20.97           C  
ATOM    555  CG1 VAL A  76      -4.374  -4.248  -0.089  1.00 16.22           C  
ATOM    556  CG2 VAL A  76      -4.020  -1.886  -0.759  1.00 14.28           C  
ATOM    557  N   ALA A  77      -6.818  -3.643   1.849  1.00 20.55           N  
ATOM    558  CA  ALA A  77      -8.266  -3.846   1.714  1.00 20.70           C  
ATOM    559  C   ALA A  77      -9.013  -2.781   2.562  1.00 19.89           C  
ATOM    560  O   ALA A  77      -9.994  -2.172   2.099  1.00 22.85           O  
ATOM    561  CB  ALA A  77      -8.644  -5.285   2.139  1.00 18.16           C  
ATOM    562  N   ALA A  78      -8.523  -2.532   3.783  1.00 22.46           N  
ATOM    563  CA  ALA A  78      -9.123  -1.516   4.676  1.00 25.50           C  
ATOM    564  C   ALA A  78      -9.039  -0.109   4.080  1.00 18.49           C  
ATOM    565  O   ALA A  78     -10.000   0.659   4.133  1.00 20.77           O  
ATOM    566  CB  ALA A  78      -8.439  -1.539   6.060  1.00 16.89           C  
ATOM    567  N   TYR A  79      -7.879   0.216   3.506  1.00 24.10           N  
ATOM    568  CA  TYR A  79      -7.657   1.519   2.894  1.00 16.99           C  
ATOM    569  C   TYR A  79      -8.631   1.741   1.750  1.00 19.03           C  
ATOM    570  O   TYR A  79      -9.305   2.766   1.686  1.00 23.90           O  
ATOM    571  CB  TYR A  79      -6.212   1.634   2.426  1.00 17.74           C  
ATOM    572  CG  TYR A  79      -5.929   2.893   1.659  1.00 20.21           C  
ATOM    573  CD1 TYR A  79      -5.675   4.092   2.317  1.00 17.91           C  
ATOM    574  CD2 TYR A  79      -5.984   2.902   0.274  1.00 20.73           C  
ATOM    575  CE1 TYR A  79      -5.495   5.265   1.620  1.00 24.19           C  
ATOM    576  CE2 TYR A  79      -5.808   4.063  -0.439  1.00 26.58           C  
ATOM    577  CZ  TYR A  79      -5.566   5.245   0.232  1.00 29.20           C  
ATOM    578  OH  TYR A  79      -5.394   6.408  -0.491  1.00 30.85           O  
ATOM    579  N   VAL A  80      -8.724   0.766   0.852  1.00 24.00           N  
ATOM    580  CA  VAL A  80      -9.649   0.861  -0.283  1.00 22.36           C  
ATOM    581  C   VAL A  80     -11.100   0.985   0.247  1.00 25.44           C  
ATOM    582  O   VAL A  80     -11.901   1.811  -0.251  1.00 22.59           O  
ATOM    583  CB  VAL A  80      -9.495  -0.391  -1.247  1.00 26.07           C  
ATOM    584  CG1 VAL A  80     -10.590  -0.420  -2.294  1.00 19.66           C  
ATOM    585  CG2 VAL A  80      -8.112  -0.393  -1.919  1.00 25.11           C  
ATOM    586  N   TYR A  81     -11.438   0.163   1.244  1.00 26.62           N  
ATOM    587  CA  TYR A  81     -12.777   0.197   1.826  1.00 29.75           C  
ATOM    588  C   TYR A  81     -13.133   1.572   2.419  1.00 27.04           C  
ATOM    589  O   TYR A  81     -14.221   2.089   2.173  1.00 25.13           O  
ATOM    590  CB  TYR A  81     -12.944  -0.893   2.888  1.00 29.86           C  
ATOM    591  CG  TYR A  81     -14.331  -0.874   3.436  1.00 31.54           C  
ATOM    592  CD1 TYR A  81     -15.338  -1.583   2.819  1.00 32.42           C  
ATOM    593  CD2 TYR A  81     -14.665  -0.055   4.513  1.00 36.76           C  
ATOM    594  CE1 TYR A  81     -16.653  -1.482   3.245  1.00 36.08           C  
ATOM    595  CE2 TYR A  81     -15.976   0.059   4.952  1.00 38.31           C  
ATOM    596  CZ  TYR A  81     -16.973  -0.659   4.316  1.00 43.64           C  
ATOM    597  OH  TYR A  81     -18.286  -0.576   4.761  1.00 47.78           O  
ATOM    598  N   ASP A  82     -12.210   2.157   3.179  1.00 22.71           N  
ATOM    599  CA  ASP A  82     -12.435   3.469   3.792  1.00 33.39           C  
ATOM    600  C   ASP A  82     -12.538   4.588   2.744  1.00 33.88           C  
ATOM    601  O   ASP A  82     -13.383   5.491   2.846  1.00 31.24           O  
ATOM    602  CB  ASP A  82     -11.344   3.789   4.834  1.00 31.62           C  
ATOM    603  CG  ASP A  82     -11.360   2.821   6.039  1.00 39.70           C  
ATOM    604  OD1 ASP A  82     -12.298   1.998   6.154  1.00 34.64           O  
ATOM    605  OD2 ASP A  82     -10.429   2.863   6.879  1.00 37.12           O  
ATOM    606  N   GLN A  83     -11.715   4.510   1.703  1.00 36.90           N  
ATOM    607  CA  GLN A  83     -11.753   5.511   0.634  1.00 28.20           C  
ATOM    608  C   GLN A  83     -13.103   5.464  -0.085  1.00 29.83           C  
ATOM    609  O   GLN A  83     -13.749   6.491  -0.328  1.00 27.25           O  
ATOM    610  CB  GLN A  83     -10.610   5.258  -0.359  1.00 27.59           C  
ATOM    611  CG  GLN A  83      -9.228   5.474   0.224  1.00 25.39           C  
ATOM    612  CD  GLN A  83      -8.932   6.949   0.440  1.00 34.82           C  
ATOM    613  OE1 GLN A  83      -8.654   7.684  -0.500  1.00 34.96           O  
ATOM    614  NE2 GLN A  83      -9.005   7.384   1.673  1.00 28.93           N  
ATOM    615  N   ALA A  84     -13.547   4.263  -0.413  1.00 30.56           N  
ATOM    616  CA  ALA A  84     -14.805   4.119  -1.110  1.00 32.79           C  
ATOM    617  C   ALA A  84     -15.988   4.523  -0.234  1.00 38.63           C  
ATOM    618  O   ALA A  84     -16.861   5.260  -0.698  1.00 38.51           O  
ATOM    619  CB  ALA A  84     -14.968   2.695  -1.596  1.00 37.51           C  
ATOM    620  N   SER A  85     -16.038   4.056   1.021  1.00 39.33           N  
ATOM    621  CA  SER A  85     -17.173   4.406   1.893  1.00 45.77           C  
ATOM    622  C   SER A  85     -17.285   5.911   2.135  1.00 44.62           C  
ATOM    623  O   SER A  85     -18.379   6.467   2.057  1.00 51.12           O  
ATOM    624  CB  SER A  85     -17.186   3.614   3.210  1.00 38.12           C  
ATOM    625  OG  SER A  85     -16.045   3.870   3.998  1.00 46.01           O  
ATOM    626  N   GLY A  86     -16.156   6.578   2.357  1.00 46.51           N  
ATOM    627  CA  GLY A  86     -16.197   8.014   2.555  1.00 46.23           C  
ATOM    628  C   GLY A  86     -16.287   8.782   1.247  1.00 49.79           C  
ATOM    629  O   GLY A  86     -16.339  10.014   1.246  1.00 51.35           O  
ATOM    630  N   ASP A  87     -16.301   8.050   0.132  1.00 51.65           N  
ATOM    631  CA  ASP A  87     -16.360   8.640  -1.205  1.00 49.73           C  
ATOM    632  C   ASP A  87     -15.162   9.554  -1.375  1.00 46.35           C  
ATOM    633  O   ASP A  87     -15.207  10.549  -2.091  1.00 45.62           O  
ATOM    634  CB  ASP A  87     -17.677   9.401  -1.418  1.00 51.46           C  
ATOM    635  CG  ASP A  87     -18.879   8.473  -1.492  1.00 50.59           C  
ATOM    636  OD1 ASP A  87     -19.076   7.829  -2.543  0.00  0.00           O  
ATOM    637  OD2 ASP A  87     -19.620   8.363  -0.492  0.00  0.00           O  
ATOM    638  N   LYS A  88     -14.068   9.146  -0.743  1.00 44.95           N  
ATOM    639  CA  LYS A  88     -12.811   9.877  -0.743  1.00 43.44           C  
ATOM    640  C   LYS A  88     -11.974   9.811  -2.022  1.00 46.06           C  
ATOM    641  O   LYS A  88     -10.868  10.350  -2.041  1.00 50.91           O  
ATOM    642  CB  LYS A  88     -11.960   9.428   0.453  1.00 44.40           C  
ATOM    643  CG  LYS A  88     -12.523   9.856   1.814  1.00 48.90           C  
ATOM    644  CD  LYS A  88     -11.555  10.782   2.555  1.00 45.21           C  
ATOM    645  CE  LYS A  88     -10.333  10.023   3.069  1.00 46.79           C  
ATOM    646  NZ  LYS A  88      -9.155  10.892   3.399  1.00 46.10           N  
ATOM    647  N   TRP A  89     -12.464   9.142  -3.066  1.00 43.71           N  
ATOM    648  CA  TRP A  89     -11.720   9.048  -4.325  1.00 45.41           C  
ATOM    649  C   TRP A  89     -12.070  10.241  -5.220  1.00 45.55           C  
ATOM    650  O   TRP A  89     -13.184  10.784  -5.071  0.00  0.00           O  
ATOM    651  CB  TRP A  89     -12.070   7.768  -5.098  1.00 41.87           C  
ATOM    652  CG  TRP A  89     -11.621   6.472  -4.517  1.00 32.33           C  
ATOM    653  CD1 TRP A  89     -12.417   5.408  -4.238  1.00 35.17           C  
ATOM    654  CD2 TRP A  89     -10.272   6.054  -4.239  1.00 30.88           C  
ATOM    655  NE1 TRP A  89     -11.657   4.343  -3.814  1.00 35.82           N  
ATOM    656  CE2 TRP A  89     -10.336   4.709  -3.800  1.00 29.66           C  
ATOM    657  CE3 TRP A  89      -9.021   6.679  -4.318  1.00 29.99           C  
ATOM    658  CZ2 TRP A  89      -9.195   3.971  -3.444  1.00 24.01           C  
ATOM    659  CZ3 TRP A  89      -7.882   5.942  -3.961  1.00 29.48           C  
ATOM    660  CH2 TRP A  89      -7.985   4.605  -3.530  1.00 27.08           C  
ATOM    661  OXT TRP A  89     -11.258  10.560  -6.113  0.00  0.00           O  
TER     662      TRP A  89                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
