
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   81 (  641),  selected   81 , name 2fu4_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 2fu4_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     3_A      A       2           -
LGA    N     4_A      K       3           -
LGA    N     5_A      C       4           -
LGA    T     6_A      P       5           -
LGA    A     7_A      I       6           -
LGA    L     8_A      C       7           -
LGA    K     9_A      G       8           -
LGA    K    10_A      S       9           -
LGA    A    11_A      P      10           -
LGA    G    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    K    14_A      -       -           -
LGA    V    15_A      -       -           -
LGA    T    16_A      L      11          5.395
LGA    L    17_A      K      12          2.341
LGA    P    18_A      W      13          2.126
LGA    R    19_A      E      14          2.526
LGA    L    20_A      E      15          2.106
LGA    K    21_A      L      16          1.615
LGA    I    22_A      I      17          3.022
LGA    L    23_A      E      18          3.615
LGA    E    24_A      E      19          3.548
LGA    V    25_A      M      20          3.638
LGA    L    26_A      L      21          4.022
LGA    Q    27_A      I      22          3.386
LGA    E    28_A      I      23          1.830
LGA    P    29_A      E      24          2.313
LGA    D    30_A      N      25          2.338
LGA    N    31_A      F      26          1.961
LGA    H    32_A      E      27          2.567
LGA    H    33_A      E      28          1.884
LGA    V    34_A      I      29          1.345
LGA    -       -      V      30           -
LGA    -       -      K      31           -
LGA    S    35_A      D      32          1.412
LGA    A    36_A      R      33          1.615
LGA    E    37_A      E      34          1.585
LGA    D    38_A      R      35          1.003
LGA    L    39_A      F      36          1.256
LGA    Y    40_A      L      37          1.342
LGA    K    41_A      A      38          1.560
LGA    R    42_A      Q      39          1.525
LGA    L    43_A      V      40          0.950
LGA    I    44_A      E      41          1.030
LGA    D    45_A      E      42          1.839
LGA    M    46_A      F      43          2.114
LGA    G    47_A      V      44          3.232
LGA    -       -      F      45           -
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    -       -      F      54           -
LGA    -       -      Y      55           -
LGA    E    48_A      G      56          2.525
LGA    -       -      K      57           -
LGA    -       -      T      58           -
LGA    E    49_A      L      59          2.629
LGA    -       -      P      60           -
LGA    -       -      R      61           -
LGA    -       -      R      62           -
LGA    I    50_A      E      63          4.720
LGA    G    51_A      A      64          0.859
LGA    L    52_A      -       -           -
LGA    A    53_A      E      65          1.789
LGA    T    54_A      K      66          1.231
LGA    V    55_A      V      67          1.120
LGA    Y    56_A      F      68          1.457
LGA    R    57_A      E      69          0.742
LGA    V    58_A      L      70          1.958
LGA    L    59_A      L      71          2.723
LGA    N    60_A      N      72          3.213
LGA    Q    61_A      D      73          3.588
LGA    F    62_A      F      74          4.742
LGA    D    63_A      K      75          2.920
LGA    D    64_A      -       -           -
LGA    A    65_A      G      76          2.929
LGA    G    66_A      G      77          3.318
LGA    I    67_A      I      78          0.762
LGA    V    68_A      -       -           -
LGA    T    69_A      -       -           -
LGA    R    70_A      -       -           -
LGA    H    71_A      -       -           -
LGA    N    72_A      -       -           -
LGA    F    73_A      -       -           -
LGA    E    74_A      -       -           -
LGA    G    75_A      -       -           -
LGA    G    76_A      -       -           -
LGA    K    77_A      -       -           -
LGA    S    78_A      -       -           -
LGA    V    79_A      -       -           -
LGA    F    80_A      -       -           -
LGA    E    81_A      -       -           -
LGA    L    82_A      D      79           #
LGA    T    83_A      W      80          3.920
LGA    -       -      E      81           -
LGA    -       -      N      82           -
LGA    -       -      K      83           -
LGA    -       -      R      84           -
LGA    -       -      V      85           -
LGA    -       -      K      86           -
LGA    -       -      L      87           -
LGA    -       -      K      88           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   81   87    5.0     51    2.58    19.61     42.346     1.900

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.507526 * X  +   0.466846 * Y  +  -0.724204 * Z  + -21.812868
  Y_new =   0.642254 * X  +  -0.765272 * Y  +  -0.043225 * Z  +  11.277041
  Z_new =  -0.574393 * X  +  -0.443185 * Y  +  -0.688230 * Z  +  34.768848 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.569483    0.572110  [ DEG:  -147.2205     32.7795 ]
  Theta =   0.611862    2.529731  [ DEG:    35.0571    144.9429 ]
  Phi   =   0.902043   -2.239549  [ DEG:    51.6833   -128.3167 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fu4_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fu4_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   81   87   5.0   51   2.58   19.61  42.346
REMARK  ---------------------------------------------------------- 
MOLECULE 2fu4_A
HEADER    DNA BINDING PROTEIN                     26-JAN-06   2FU4              
TITLE     CRYSTAL STRUCTURE OF THE DNA BINDING DOMAIN OF E.COLI FUR             
TITLE    2 (FERRIC UPTAKE REGULATOR)                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FERRIC UPTAKE REGULATION PROTEIN;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN;                                         
COMPND   5 SYNONYM: FUR, FERRIC UPTAKE REGULATOR;                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: BL21;                                                        
SOURCE   5 GENE: FUR(P0A9A9);                                                   
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET 30C                                   
KEYWDS    DNA BINDING DOMAIN, HELIX-TURN-HELIX                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    L.PECQUEUR,B.D'AUTREAUX,J.DUPUY,Y.NICOLET,L.JACQUAMET,                
AUTHOR   2 B.BRUTSCHER,I.MICHAUD-SORET,B.BERSCH                                 
REVDAT   1   16-MAY-06 2FU4    0                                                
JRNL        AUTH   L.PECQUEUR,B.D'AUTREAUX,J.DUPUY,Y.NICOLET,                   
JRNL        AUTH 2 L.JACQUAMET,B.BRUTSCHER,I.MICHAUD-SORET,B.BERSCH             
JRNL        TITL   ACTIVATION OF E. COLI FUR VIA THE N-TERMINAL HELIX           
JRNL        TITL 2 FOLDING AND METAL DEPENDENT DIMERIZATION : NMR AND           
JRNL        TITL 3 X-RAY STRUCTURAL STUDIES                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2FU4 A    1    83  UNP    P0A9A9   FUR_ECOLI        1     83             
DBREF  2FU4 B    1    83  UNP    P0A9A9   FUR_ECOLI        1     83             
SEQRES   1 A   83  MET THR ASP ASN ASN THR ALA LEU LYS LYS ALA GLY LEU          
SEQRES   2 A   83  LYS VAL THR LEU PRO ARG LEU LYS ILE LEU GLU VAL LEU          
SEQRES   3 A   83  GLN GLU PRO ASP ASN HIS HIS VAL SER ALA GLU ASP LEU          
SEQRES   4 A   83  TYR LYS ARG LEU ILE ASP MET GLY GLU GLU ILE GLY LEU          
SEQRES   5 A   83  ALA THR VAL TYR ARG VAL LEU ASN GLN PHE ASP ASP ALA          
SEQRES   6 A   83  GLY ILE VAL THR ARG HIS ASN PHE GLU GLY GLY LYS SER          
SEQRES   7 A   83  VAL PHE GLU LEU THR                                          
SEQRES   1 B   83  MET THR ASP ASN ASN THR ALA LEU LYS LYS ALA GLY LEU          
SEQRES   2 B   83  LYS VAL THR LEU PRO ARG LEU LYS ILE LEU GLU VAL LEU          
SEQRES   3 B   83  GLN GLU PRO ASP ASN HIS HIS VAL SER ALA GLU ASP LEU          
SEQRES   4 B   83  TYR LYS ARG LEU ILE ASP MET GLY GLU GLU ILE GLY LEU          
SEQRES   5 B   83  ALA THR VAL TYR ARG VAL LEU ASN GLN PHE ASP ASP ALA          
SEQRES   6 B   83  GLY ILE VAL THR ARG HIS ASN PHE GLU GLY GLY LYS SER          
SEQRES   7 B   83  VAL PHE GLU LEU THR                                          
HET     CD      1       1                                                       
HET     CD      2       1                                                       
HET     CD      3       1                                                       
HET     CD      4       1                                                       
HET     CD      5       1                                                       
HET     CD      6       1                                                       
HET     CD      7       1                                                       
HET     CD      8       1                                                       
HET     CL      9       1                                                       
HET     CL     10       1                                                       
HET     CL     11       1                                                       
HET     CL     12       1                                                       
HET     CL     13       1                                                       
HET     CL     14       1                                                       
HET     CL     15       1                                                       
HET     CL     16       1                                                       
HET     CL     17       1                                                       
HET     CL     18       1                                                       
HET     CL     19       1                                                       
HET     CL     20       1                                                       
HET    GOL    181       6                                                       
HETNAM      CD CADMIUM ION                                                      
HETNAM      CL CHLORIDE ION                                                     
HETNAM     GOL GLYCEROL                                                         
FORMUL   3   CD    8(CD 2+)                                                     
FORMUL  11   CL    12(CL 1-)                                                    
FORMUL  23  GOL    C3 H8 O3                                                     
FORMUL  24  HOH   *160(H2 O)                                                    
CRYST1   38.500  159.270   28.650  90.00  90.00  90.00 P 21 21 2     8          
ATOM      1  N   ASP A   3      -8.729   7.712 -16.583  1.00 18.86           N  
ATOM      2  CA  ASP A   3      -7.384   7.959 -15.996  1.00 17.57           C  
ATOM      3  C   ASP A   3      -7.432   7.979 -14.467  1.00 16.33           C  
ATOM      4  O   ASP A   3      -7.789   8.988 -13.858  1.00 15.05           O  
ATOM      5  CB  ASP A   3      -6.789   9.265 -16.546  1.00 18.81           C  
ATOM      6  CG  ASP A   3      -5.304   9.415 -16.232  1.00 20.56           C  
ATOM      7  OD1 ASP A   3      -4.850   8.966 -15.162  1.00 22.62           O  
ATOM      8  OD2 ASP A   3      -4.576   9.989 -17.063  1.00 23.25           O  
ATOM      9  N   ASN A   4      -7.049   6.863 -13.848  1.00 15.18           N  
ATOM     10  CA  ASN A   4      -7.153   6.729 -12.387  1.00 14.12           C  
ATOM     11  C   ASN A   4      -6.025   7.457 -11.647  1.00 13.51           C  
ATOM     12  O   ASN A   4      -6.154   7.789 -10.475  1.00 12.93           O  
ATOM     13  CB  ASN A   4      -7.242   5.260 -11.961  1.00 13.99           C  
ATOM     14  CG  ASN A   4      -8.599   4.605 -12.326  1.00 13.32           C  
ATOM     15  OD1 ASN A   4      -9.652   5.241 -12.280  1.00 12.99           O  
ATOM     16  ND2 ASN A   4      -8.559   3.326 -12.673  1.00 11.12           N  
ATOM     17  N   ASN A   5      -4.914   7.690 -12.338  1.00 13.55           N  
ATOM     18  CA  ASN A   5      -3.851   8.558 -11.835  1.00 13.62           C  
ATOM     19  C   ASN A   5      -4.414   9.957 -11.546  1.00 13.59           C  
ATOM     20  O   ASN A   5      -4.259  10.505 -10.443  1.00 13.37           O  
ATOM     21  CB  ASN A   5      -2.729   8.614 -12.869  1.00 14.56           C  
ATOM     22  CG  ASN A   5      -1.553   9.438 -12.417  1.00 17.75           C  
ATOM     23  OD1 ASN A   5      -1.634  10.664 -12.313  1.00 20.54           O  
ATOM     24  ND2 ASN A   5      -0.426   8.772 -12.174  1.00 20.27           N  
ATOM     25  N   THR A   6      -5.103  10.505 -12.540  1.00 14.21           N  
ATOM     26  CA  THR A   6      -5.711  11.836 -12.439  1.00 14.38           C  
ATOM     27  C   THR A   6      -6.821  11.838 -11.407  1.00 14.32           C  
ATOM     28  O   THR A   6      -6.940  12.777 -10.631  1.00 14.78           O  
ATOM     29  CB  THR A   6      -6.247  12.324 -13.809  1.00 14.56           C  
ATOM     30  OG1 THR A   6      -5.179  12.367 -14.752  1.00 15.38           O  
ATOM     31  CG2 THR A   6      -6.844  13.721 -13.704  1.00 14.74           C  
ATOM     32  N   ALA A   7      -7.635  10.783 -11.386  1.00 14.58           N  
ATOM     33  CA  ALA A   7      -8.674  10.649 -10.360  1.00 14.25           C  
ATOM     34  C   ALA A   7      -8.135  10.753  -8.920  1.00 13.44           C  
ATOM     35  O   ALA A   7      -8.701  11.456  -8.066  1.00 12.76           O  
ATOM     36  CB  ALA A   7      -9.442   9.338 -10.554  1.00 14.61           C  
ATOM     37  N   LEU A   8      -7.040  10.052  -8.650  1.00 12.53           N  
ATOM     38  CA  LEU A   8      -6.446  10.077  -7.329  1.00 12.30           C  
ATOM     39  C   LEU A   8      -5.880  11.463  -6.992  1.00 12.07           C  
ATOM     40  O   LEU A   8      -6.078  11.968  -5.884  1.00 11.60           O  
ATOM     41  CB  LEU A   8      -5.380   8.979  -7.206  1.00 12.06           C  
ATOM     42  CG  LEU A   8      -5.922   7.540  -7.182  1.00 10.96           C  
ATOM     43  CD1 LEU A   8      -4.792   6.509  -7.365  1.00 10.31           C  
ATOM     44  CD2 LEU A   8      -6.725   7.252  -5.887  1.00 11.09           C  
ATOM     45  N   LYS A   9      -5.184  12.085  -7.945  1.00 13.04           N  
ATOM     46  CA  LYS A   9      -4.652  13.427  -7.717  1.00 13.58           C  
ATOM     47  C   LYS A   9      -5.792  14.400  -7.427  1.00 14.15           C  
ATOM     48  O   LYS A   9      -5.717  15.192  -6.483  1.00 13.85           O  
ATOM     49  CB  LYS A   9      -3.819  13.905  -8.905  1.00 13.66           C  
ATOM     50  CG  LYS A   9      -2.468  13.208  -8.991  1.00 14.83           C  
ATOM     51  CD  LYS A   9      -1.715  13.646 -10.226  1.00 17.27           C  
ATOM     52  CE  LYS A   9      -0.306  13.090 -10.235  1.00 18.93           C  
ATOM     53  NZ  LYS A   9      -0.346  11.609 -10.271  0.50 20.10           N  
ATOM     54  N   LYS A  10      -6.854  14.293  -8.222  1.00 14.89           N  
ATOM     55  CA  LYS A  10      -8.000  15.185  -8.128  1.00 16.20           C  
ATOM     56  C   LYS A  10      -8.641  15.032  -6.759  1.00 16.17           C  
ATOM     57  O   LYS A  10      -9.187  15.993  -6.220  1.00 17.10           O  
ATOM     58  CB  LYS A  10      -9.005  14.851  -9.231  1.00 16.40           C  
ATOM     59  CG  LYS A  10     -10.038  15.920  -9.547  1.00 19.07           C  
ATOM     60  CD  LYS A  10     -10.863  15.472 -10.773  1.00 20.31           C  
ATOM     61  CE  LYS A  10     -12.161  16.266 -10.944  1.00 22.03           C  
ATOM     62  NZ  LYS A  10     -12.997  16.329  -9.702  1.00 24.97           N  
ATOM     63  N   ALA A  11      -8.555  13.833  -6.185  1.00 16.09           N  
ATOM     64  CA  ALA A  11      -9.057  13.589  -4.828  1.00 15.70           C  
ATOM     65  C   ALA A  11      -8.040  13.839  -3.701  1.00 15.23           C  
ATOM     66  O   ALA A  11      -8.327  13.587  -2.530  1.00 15.59           O  
ATOM     67  CB  ALA A  11      -9.659  12.193  -4.716  1.00 16.04           C  
ATOM     68  N   GLY A  12      -6.858  14.326  -4.054  1.00 14.42           N  
ATOM     69  CA  GLY A  12      -5.858  14.683  -3.067  1.00 13.96           C  
ATOM     70  C   GLY A  12      -5.097  13.517  -2.455  1.00 13.43           C  
ATOM     71  O   GLY A  12      -4.617  13.614  -1.317  1.00 12.79           O  
ATOM     72  N   LEU A  13      -4.951  12.431  -3.220  1.00 13.13           N  
ATOM     73  CA  LEU A  13      -4.292  11.223  -2.736  1.00 13.44           C  
ATOM     74  C   LEU A  13      -3.075  10.874  -3.591  1.00 13.38           C  
ATOM     75  O   LEU A  13      -3.134  10.961  -4.815  1.00 13.40           O  
ATOM     76  CB  LEU A  13      -5.280  10.040  -2.739  1.00 13.64           C  
ATOM     77  CG  LEU A  13      -6.426  10.075  -1.720  1.00 14.17           C  
ATOM     78  CD1 LEU A  13      -7.346   8.857  -1.924  1.00 14.78           C  
ATOM     79  CD2 LEU A  13      -5.909  10.120  -0.283  1.00 14.83           C  
ATOM     80  N   LYS A  14      -1.975  10.500  -2.938  1.00 13.40           N  
ATOM     81  CA  LYS A  14      -0.780  10.014  -3.642  1.00 12.75           C  
ATOM     82  C   LYS A  14      -1.125   8.737  -4.405  1.00 12.15           C  
ATOM     83  O   LYS A  14      -1.844   7.878  -3.886  1.00 10.81           O  
ATOM     84  CB  LYS A  14       0.361   9.753  -2.648  1.00 14.15           C  
ATOM     85  CG  LYS A  14       1.659   9.207  -3.275  1.00 14.00           C  
ATOM     86  CD  LYS A  14       2.735   9.004  -2.183  1.00 16.25           C  
ATOM     87  CE  LYS A  14       3.970   8.264  -2.742  1.00 17.17           C  
ATOM     88  NZ  LYS A  14       4.569   8.946  -3.929  1.00 16.66           N  
ATOM     89  N   VAL A  15      -0.628   8.627  -5.629  1.00 11.32           N  
ATOM     90  CA  VAL A  15      -0.873   7.444  -6.447  1.00 11.23           C  
ATOM     91  C   VAL A  15      -0.021   6.299  -5.881  1.00 11.13           C  
ATOM     92  O   VAL A  15       1.176   6.464  -5.639  1.00 11.60           O  
ATOM     93  CB  VAL A  15      -0.557   7.695  -7.946  1.00 10.72           C  
ATOM     94  CG1 VAL A  15      -0.783   6.433  -8.780  1.00 10.77           C  
ATOM     95  CG2 VAL A  15      -1.394   8.855  -8.499  1.00 11.52           C  
ATOM     96  N   THR A  16      -0.672   5.172  -5.605  1.00 10.83           N  
ATOM     97  CA  THR A  16       0.003   3.967  -5.134  1.00 11.26           C  
ATOM     98  C   THR A  16      -0.628   2.791  -5.864  1.00 10.82           C  
ATOM     99  O   THR A  16      -1.722   2.921  -6.414  1.00  9.95           O  
ATOM    100  CB  THR A  16      -0.186   3.734  -3.608  1.00 11.26           C  
ATOM    101  OG1 THR A  16      -1.556   3.426  -3.346  1.00 12.00           O  
ATOM    102  CG2 THR A  16       0.246   4.950  -2.771  1.00 11.75           C  
ATOM    103  N   LEU A  17       0.031   1.639  -5.844  1.00 10.93           N  
ATOM    104  CA  LEU A  17      -0.517   0.467  -6.533  1.00 10.68           C  
ATOM    105  C   LEU A  17      -1.832  -0.024  -5.909  1.00 10.13           C  
ATOM    106  O   LEU A  17      -2.790  -0.256  -6.637  1.00  9.80           O  
ATOM    107  CB  LEU A  17       0.541  -0.659  -6.689  1.00 11.37           C  
ATOM    108  CG  LEU A  17       0.120  -1.975  -7.373  1.00 12.69           C  
ATOM    109  CD1 LEU A  17      -0.434  -1.762  -8.794  1.00 15.32           C  
ATOM    110  CD2 LEU A  17       1.267  -2.982  -7.405  1.00 13.82           C  
ATOM    111  N   PRO A  18      -1.900  -0.159  -4.566  1.00  9.61           N  
ATOM    112  CA  PRO A  18      -3.180  -0.548  -3.998  1.00  9.71           C  
ATOM    113  C   PRO A  18      -4.323   0.414  -4.344  1.00  9.21           C  
ATOM    114  O   PRO A  18      -5.412  -0.042  -4.639  1.00  9.42           O  
ATOM    115  CB  PRO A  18      -2.909  -0.571  -2.486  1.00  9.67           C  
ATOM    116  CG  PRO A  18      -1.430  -0.840  -2.386  1.00  9.71           C  
ATOM    117  CD  PRO A  18      -0.857  -0.039  -3.524  1.00 10.30           C  
ATOM    118  N   ARG A  19      -4.081   1.718  -4.343  1.00  8.68           N  
ATOM    119  CA  ARG A  19      -5.162   2.650  -4.702  1.00  9.03           C  
ATOM    120  C   ARG A  19      -5.611   2.476  -6.143  1.00  8.92           C  
ATOM    121  O   ARG A  19      -6.815   2.454  -6.419  1.00  9.40           O  
ATOM    122  CB  ARG A  19      -4.784   4.109  -4.392  1.00  8.73           C  
ATOM    123  CG  ARG A  19      -4.776   4.419  -2.905  1.00  8.72           C  
ATOM    124  CD  ARG A  19      -4.142   5.809  -2.607  1.00 10.55           C  
ATOM    125  NE  ARG A  19      -4.123   6.033  -1.156  1.00 12.83           N  
ATOM    126  CZ  ARG A  19      -3.256   6.800  -0.493  1.00 13.39           C  
ATOM    127  NH1 ARG A  19      -2.287   7.450  -1.128  1.00 12.95           N  
ATOM    128  NH2 ARG A  19      -3.357   6.905   0.820  1.00 14.45           N  
ATOM    129  N   LEU A  20      -4.651   2.314  -7.055  1.00  8.75           N  
ATOM    130  CA  LEU A  20      -4.973   2.070  -8.456  1.00  8.80           C  
ATOM    131  C   LEU A  20      -5.750   0.755  -8.635  1.00  9.29           C  
ATOM    132  O   LEU A  20      -6.748   0.727  -9.362  1.00  9.60           O  
ATOM    133  CB  LEU A  20      -3.710   2.055  -9.317  1.00  9.04           C  
ATOM    134  CG  LEU A  20      -2.951   3.378  -9.521  1.00  9.82           C  
ATOM    135  CD1 LEU A  20      -1.564   3.144 -10.114  1.00 11.13           C  
ATOM    136  CD2 LEU A  20      -3.732   4.370 -10.368  1.00 12.66           C  
ATOM    137  N   LYS A  21      -5.286  -0.326  -8.005  1.00  8.85           N  
ATOM    138  CA  LYS A  21      -5.928  -1.629  -8.192  1.00  9.57           C  
ATOM    139  C   LYS A  21      -7.312  -1.711  -7.563  1.00  9.14           C  
ATOM    140  O   LYS A  21      -8.203  -2.402  -8.080  1.00  8.29           O  
ATOM    141  CB  LYS A  21      -5.059  -2.768  -7.665  1.00 10.37           C  
ATOM    142  CG  LYS A  21      -3.724  -2.958  -8.391  1.00 11.75           C  
ATOM    143  CD  LYS A  21      -3.852  -3.029  -9.926  1.00 16.96           C  
ATOM    144  CE  LYS A  21      -3.971  -4.448 -10.416  1.00 18.03           C  
ATOM    145  NZ  LYS A  21      -4.155  -4.595 -11.898  1.00 19.34           N  
ATOM    146  N   ILE A  22      -7.497  -1.006  -6.454  1.00  9.30           N  
ATOM    147  CA  ILE A  22      -8.799  -0.923  -5.769  0.50  9.56           C  
ATOM    149  C   ILE A  22      -9.797  -0.152  -6.633  1.00  9.75           C  
ATOM    150  O   ILE A  22     -10.957  -0.563  -6.806  1.00  9.82           O  
ATOM    151  CB  ILE A  22      -8.640  -0.260  -4.361  0.50  9.70           C  
ATOM    153  CG1 ILE A  22      -7.867  -1.193  -3.417  0.50 10.37           C  
ATOM    155  CG2 ILE A  22      -9.996   0.146  -3.751  0.50  9.92           C  
ATOM    157  CD1 ILE A  22      -8.638  -2.395  -2.936  0.50 11.29           C  
ATOM    159  N   LEU A  23      -9.342   0.974  -7.197  1.00  9.74           N  
ATOM    160  CA  LEU A  23     -10.167   1.726  -8.166  1.00 10.13           C  
ATOM    161  C   LEU A  23     -10.558   0.841  -9.345  1.00  9.86           C  
ATOM    162  O   LEU A  23     -11.718   0.793  -9.744  1.00  9.39           O  
ATOM    163  CB  LEU A  23      -9.428   2.967  -8.679  1.00 11.33           C  
ATOM    164  CG  LEU A  23      -9.405   4.176  -7.749  1.00 11.86           C  
ATOM    165  CD1 LEU A  23      -8.575   5.288  -8.405  1.00 12.44           C  
ATOM    166  CD2 LEU A  23     -10.813   4.683  -7.482  1.00 14.36           C  
ATOM    167  N   GLU A  24      -9.591   0.098  -9.870  1.00  9.44           N  
ATOM    168  CA  GLU A  24      -9.828  -0.793 -10.990  1.00 10.55           C  
ATOM    169  C   GLU A  24     -10.959  -1.774 -10.691  1.00  9.85           C  
ATOM    170  O   GLU A  24     -11.866  -1.968 -11.517  1.00 10.62           O  
ATOM    171  CB  GLU A  24      -8.556  -1.562 -11.326  1.00 11.02           C  
ATOM    172  CG  GLU A  24      -8.692  -2.467 -12.508  1.00 15.49           C  
ATOM    173  CD  GLU A  24      -7.453  -3.276 -12.785  1.00 19.15           C  
ATOM    174  OE1 GLU A  24      -6.348  -2.883 -12.338  1.00 19.32           O  
ATOM    175  OE2 GLU A  24      -7.593  -4.307 -13.482  1.00 22.61           O  
ATOM    176  N   VAL A  25     -10.921  -2.387  -9.514  1.00  8.70           N  
ATOM    177  CA  VAL A  25     -11.960  -3.360  -9.165  1.00  8.54           C  
ATOM    178  C   VAL A  25     -13.326  -2.689  -9.077  1.00  8.36           C  
ATOM    179  O   VAL A  25     -14.317  -3.217  -9.581  1.00  8.78           O  
ATOM    180  CB  VAL A  25     -11.654  -4.132  -7.881  1.00  7.71           C  
ATOM    181  CG1 VAL A  25     -12.863  -5.006  -7.451  1.00  6.74           C  
ATOM    182  CG2 VAL A  25     -10.389  -5.021  -8.054  1.00  7.76           C  
ATOM    183  N   LEU A  26     -13.370  -1.529  -8.443  1.00  8.62           N  
ATOM    184  CA  LEU A  26     -14.619  -0.780  -8.303  1.00  9.42           C  
ATOM    185  C   LEU A  26     -15.207  -0.400  -9.660  1.00 10.24           C  
ATOM    186  O   LEU A  26     -16.409  -0.145  -9.770  1.00 10.69           O  
ATOM    187  CB  LEU A  26     -14.418   0.447  -7.407  1.00  9.27           C  
ATOM    188  CG  LEU A  26     -14.291   0.194  -5.891  1.00 10.73           C  
ATOM    189  CD1 LEU A  26     -13.684   1.412  -5.168  1.00 11.25           C  
ATOM    190  CD2 LEU A  26     -15.618  -0.200  -5.266  1.00 11.54           C  
ATOM    191  N   GLN A  27     -14.352  -0.352 -10.687  1.00  9.92           N  
ATOM    192  CA  GLN A  27     -14.795  -0.034 -12.044  1.00 10.92           C  
ATOM    193  C   GLN A  27     -15.277  -1.230 -12.877  1.00 11.60           C  
ATOM    194  O   GLN A  27     -15.769  -1.043 -14.003  1.00 12.18           O  
ATOM    195  CB  GLN A  27     -13.693   0.758 -12.763  1.00 11.14           C  
ATOM    196  CG  GLN A  27     -13.483   2.145 -12.120  1.00 10.24           C  
ATOM    197  CD  GLN A  27     -12.163   2.809 -12.506  1.00 11.99           C  
ATOM    198  OE1 GLN A  27     -11.227   2.156 -12.988  1.00 11.57           O  
ATOM    199  NE2 GLN A  27     -12.090   4.125 -12.297  1.00 12.98           N  
ATOM    200  N   GLU A  28     -15.168  -2.445 -12.326  1.00 11.89           N  
ATOM    201  CA  GLU A  28     -15.690  -3.641 -12.986  1.00 12.24           C  
ATOM    202  C   GLU A  28     -17.205  -3.696 -12.782  1.00 11.98           C  
ATOM    203  O   GLU A  28     -17.681  -3.492 -11.679  1.00 11.84           O  
ATOM    204  CB  GLU A  28     -15.046  -4.902 -12.414  1.00 13.00           C  
ATOM    205  CG  GLU A  28     -13.520  -4.900 -12.520  1.00 12.79           C  
ATOM    206  CD  GLU A  28     -12.868  -6.165 -11.970  1.00 14.67           C  
ATOM    207  OE1 GLU A  28     -11.754  -6.477 -12.433  1.00 17.42           O  
ATOM    208  OE2 GLU A  28     -13.457  -6.857 -11.099  1.00 14.56           O  
ATOM    209  N   PRO A  29     -17.972  -3.959 -13.855  1.00 11.58           N  
ATOM    210  CA  PRO A  29     -19.443  -4.061 -13.718  1.00 11.30           C  
ATOM    211  C   PRO A  29     -19.932  -4.951 -12.568  1.00 10.84           C  
ATOM    212  O   PRO A  29     -20.809  -4.538 -11.828  1.00 10.88           O  
ATOM    213  CB  PRO A  29     -19.875  -4.656 -15.060  1.00 11.10           C  
ATOM    214  CG  PRO A  29     -18.852  -4.123 -16.021  1.00 11.62           C  
ATOM    215  CD  PRO A  29     -17.539  -4.120 -15.255  1.00 11.86           C  
ATOM    216  N   ASP A  30     -19.365  -6.144 -12.416  1.00 10.33           N  
ATOM    217  CA  ASP A  30     -19.830  -7.068 -11.394  1.00 11.34           C  
ATOM    218  C   ASP A  30     -19.519  -6.602  -9.970  1.00 10.83           C  
ATOM    219  O   ASP A  30     -20.102  -7.124  -8.998  1.00 11.07           O  
ATOM    220  CB  ASP A  30     -19.211  -8.445 -11.600  1.00 11.60           C  
ATOM    221  CG  ASP A  30     -19.774  -9.163 -12.801  1.00 14.18           C  
ATOM    222  OD1 ASP A  30     -20.756  -8.688 -13.399  1.00 13.97           O  
ATOM    223  OD2 ASP A  30     -19.211 -10.213 -13.159  1.00 17.10           O  
ATOM    224  N   ASN A  31     -18.575  -5.664  -9.853  1.00 10.13           N  
ATOM    225  CA  ASN A  31     -18.155  -5.120  -8.558  1.00 10.66           C  
ATOM    226  C   ASN A  31     -18.552  -3.669  -8.345  1.00 10.38           C  
ATOM    227  O   ASN A  31     -17.945  -2.952  -7.547  1.00 10.59           O  
ATOM    228  CB  ASN A  31     -16.653  -5.307  -8.391  1.00  9.93           C  
ATOM    229  CG  ASN A  31     -16.284  -6.759  -8.304  1.00 11.38           C  
ATOM    230  OD1 ASN A  31     -15.499  -7.267  -9.089  1.00 14.58           O  
ATOM    231  ND2 ASN A  31     -16.910  -7.453  -7.380  1.00 10.32           N  
ATOM    232  N   HIS A  32     -19.586  -3.251  -9.065  1.00 10.46           N  
ATOM    233  CA  HIS A  32     -20.115  -1.888  -8.975  1.00 10.67           C  
ATOM    234  C   HIS A  32     -20.378  -1.537  -7.508  1.00 10.22           C  
ATOM    235  O   HIS A  32     -19.998  -0.458  -7.043  1.00  9.99           O  
ATOM    236  CB  HIS A  32     -21.408  -1.783  -9.775  1.00 11.08           C  
ATOM    237  CG  HIS A  32     -21.932  -0.387  -9.899  1.00 13.66           C  
ATOM    238  ND1 HIS A  32     -21.884   0.316 -11.081  1.00 15.39           N  
ATOM    239  CD2 HIS A  32     -22.533   0.429  -9.000  1.00 14.87           C  
ATOM    240  CE1 HIS A  32     -22.423   1.510 -10.905  1.00 16.58           C  
ATOM    241  NE2 HIS A  32     -22.813   1.609  -9.648  1.00 15.59           N  
ATOM    242  N   HIS A  33     -21.028  -2.451  -6.792  1.00 10.01           N  
ATOM    243  CA  HIS A  33     -21.087  -2.382  -5.325  1.00  9.93           C  
ATOM    244  C   HIS A  33     -20.318  -3.565  -4.797  1.00 10.27           C  
ATOM    245  O   HIS A  33     -20.524  -4.690  -5.268  1.00 10.35           O  
ATOM    246  CB  HIS A  33     -22.520  -2.519  -4.809  1.00 10.12           C  
ATOM    247  CG  HIS A  33     -23.492  -1.606  -5.456  1.00  9.24           C  
ATOM    248  ND1 HIS A  33     -24.235  -1.986  -6.547  1.00  9.27           N  
ATOM    249  CD2 HIS A  33     -23.898  -0.350  -5.142  1.00 10.01           C  
ATOM    250  CE1 HIS A  33     -25.036  -0.995  -6.899  1.00 10.06           C  
ATOM    251  NE2 HIS A  33     -24.847   0.011  -6.068  1.00  9.63           N  
ATOM    252  N   VAL A  34     -19.431  -3.339  -3.827  1.00  9.95           N  
ATOM    253  CA  VAL A  34     -18.629  -4.439  -3.331  1.00 10.88           C  
ATOM    254  C   VAL A  34     -18.264  -4.219  -1.856  1.00 10.79           C  
ATOM    255  O   VAL A  34     -17.974  -3.085  -1.445  1.00 10.90           O  
ATOM    256  CB  VAL A  34     -17.357  -4.647  -4.246  1.00 11.05           C  
ATOM    257  CG1 VAL A  34     -16.388  -3.467  -4.126  1.00 10.66           C  
ATOM    258  CG2 VAL A  34     -16.659  -5.965  -3.960  1.00 12.68           C  
ATOM    259  N   SER A  35     -18.295  -5.304  -1.075  1.00 11.10           N  
ATOM    260  CA  SER A  35     -17.783  -5.308   0.294  1.00 11.35           C  
ATOM    261  C   SER A  35     -16.266  -5.297   0.260  1.00 11.47           C  
ATOM    262  O   SER A  35     -15.653  -5.696  -0.727  1.00 11.53           O  
ATOM    263  CB  SER A  35     -18.268  -6.547   1.074  1.00 11.16           C  
ATOM    264  OG  SER A  35     -17.735  -7.766   0.545  1.00 11.75           O  
ATOM    265  N   ALA A  36     -15.652  -4.827   1.346  1.00 11.62           N  
ATOM    266  CA  ALA A  36     -14.200  -4.886   1.457  1.00 11.26           C  
ATOM    267  C   ALA A  36     -13.706  -6.323   1.277  1.00 11.22           C  
ATOM    268  O   ALA A  36     -12.731  -6.542   0.593  1.00 10.71           O  
ATOM    269  CB  ALA A  36     -13.753  -4.352   2.771  1.00 11.09           C  
ATOM    270  N   GLU A  37     -14.397  -7.282   1.888  1.00 11.25           N  
ATOM    271  CA  GLU A  37     -14.019  -8.706   1.830  1.00 11.67           C  
ATOM    272  C   GLU A  37     -14.054  -9.247   0.389  1.00 11.47           C  
ATOM    273  O   GLU A  37     -13.111  -9.901  -0.065  1.00 11.45           O  
ATOM    274  CB  GLU A  37     -14.933  -9.530   2.752  1.00 12.61           C  
ATOM    275  CG  GLU A  37     -15.191  -8.907   4.153  0.50 15.36           C  
ATOM    276  CD  GLU A  37     -16.391  -7.946   4.211  1.00 18.51           C  
ATOM    277  OE1 GLU A  37     -17.537  -8.408   4.420  0.50 20.47           O  
ATOM    278  OE2 GLU A  37     -16.185  -6.719   4.082  1.00 19.49           O  
ATOM    279  N   ASP A  38     -15.120  -8.941  -0.355  1.00 10.76           N  
ATOM    280  CA  ASP A  38     -15.221  -9.370  -1.751  1.00 10.65           C  
ATOM    281  C   ASP A  38     -14.231  -8.671  -2.669  1.00  9.37           C  
ATOM    282  O   ASP A  38     -13.735  -9.263  -3.614  1.00  8.45           O  
ATOM    283  CB  ASP A  38     -16.640  -9.151  -2.280  1.00 11.37           C  
ATOM    284  CG  ASP A  38     -17.606 -10.210  -1.783  1.00 15.30           C  
ATOM    285  OD1 ASP A  38     -17.137 -11.271  -1.332  1.00 18.42           O  
ATOM    286  OD2 ASP A  38     -18.829  -9.994  -1.849  1.00 18.71           O  
ATOM    287  N   LEU A  39     -13.937  -7.410  -2.377  1.00  8.99           N  
ATOM    288  CA  LEU A  39     -12.951  -6.658  -3.164  1.00  9.10           C  
ATOM    289  C   LEU A  39     -11.563  -7.294  -2.951  1.00  8.85           C  
ATOM    290  O   LEU A  39     -10.804  -7.533  -3.897  1.00  8.75           O  
ATOM    291  CB  LEU A  39     -13.013  -5.177  -2.753  1.00  9.12           C  
ATOM    292  CG  LEU A  39     -12.085  -4.057  -3.217  1.00 11.19           C  
ATOM    293  CD1 LEU A  39     -11.283  -4.275  -4.459  1.00 12.30           C  
ATOM    294  CD2 LEU A  39     -12.778  -2.665  -3.231  1.00 11.24           C  
ATOM    295  N   TYR A  40     -11.247  -7.595  -1.697  1.00  8.82           N  
ATOM    296  CA  TYR A  40     -10.020  -8.332  -1.384  1.00  8.67           C  
ATOM    297  C   TYR A  40      -9.937  -9.670  -2.145  1.00  8.95           C  
ATOM    298  O   TYR A  40      -8.883 -10.013  -2.713  1.00  8.74           O  
ATOM    299  CB  TYR A  40      -9.936  -8.508   0.137  1.00  8.73           C  
ATOM    300  CG  TYR A  40      -8.856  -9.412   0.656  1.00  9.95           C  
ATOM    301  CD1 TYR A  40      -7.508  -9.122   0.437  1.00 10.34           C  
ATOM    302  CD2 TYR A  40      -9.184 -10.524   1.442  1.00 10.17           C  
ATOM    303  CE1 TYR A  40      -6.505  -9.960   0.934  1.00 11.64           C  
ATOM    304  CE2 TYR A  40      -8.188 -11.375   1.942  1.00 11.47           C  
ATOM    305  CZ  TYR A  40      -6.852 -11.069   1.694  1.00 11.91           C  
ATOM    306  OH  TYR A  40      -5.849 -11.906   2.191  1.00 14.59           O  
ATOM    307  N   LYS A  41     -11.035 -10.426  -2.162  1.00  9.06           N  
ATOM    308  CA  LYS A  41     -11.032 -11.717  -2.869  1.00  9.63           C  
ATOM    309  C   LYS A  41     -10.785 -11.564  -4.366  1.00  9.36           C  
ATOM    310  O   LYS A  41     -10.070 -12.363  -4.984  1.00  8.69           O  
ATOM    311  CB  LYS A  41     -12.342 -12.453  -2.621  1.00 10.16           C  
ATOM    312  CG  LYS A  41     -12.340 -13.158  -1.270  1.00 13.36           C  
ATOM    313  CD  LYS A  41     -13.624 -13.916  -1.017  1.00 17.41           C  
ATOM    314  CE  LYS A  41     -14.596 -13.067  -0.206  1.00 20.02           C  
ATOM    315  NZ  LYS A  41     -15.735 -13.867   0.349  1.00 22.88           N  
ATOM    316  N   ARG A  42     -11.401 -10.538  -4.950  1.00  8.70           N  
ATOM    317  CA  ARG A  42     -11.146 -10.211  -6.350  1.00  8.64           C  
ATOM    318  C   ARG A  42      -9.672  -9.849  -6.581  1.00  8.73           C  
ATOM    319  O   ARG A  42      -9.064 -10.271  -7.571  1.00  8.28           O  
ATOM    320  CB  ARG A  42     -12.093  -9.110  -6.833  1.00  9.14           C  
ATOM    321  CG  ARG A  42     -11.817  -8.660  -8.270  1.00 10.69           C  
ATOM    322  CD  ARG A  42     -11.971  -9.787  -9.308  1.00 13.62           C  
ATOM    323  NE  ARG A  42     -11.770  -9.221 -10.642  1.00 15.28           N  
ATOM    324  CZ  ARG A  42     -11.095  -9.807 -11.624  1.00 17.60           C  
ATOM    325  NH1 ARG A  42     -10.560 -11.013 -11.454  1.00 18.07           N  
ATOM    326  NH2 ARG A  42     -10.957  -9.182 -12.795  1.00 17.71           N  
ATOM    327  N   LEU A  43      -9.077  -9.115  -5.643  1.00  7.93           N  
ATOM    328  CA  LEU A  43      -7.655  -8.807  -5.757  1.00  8.34           C  
ATOM    329  C   LEU A  43      -6.799 -10.094  -5.724  1.00  8.52           C  
ATOM    330  O   LEU A  43      -5.866 -10.230  -6.527  1.00  8.51           O  
ATOM    331  CB  LEU A  43      -7.219  -7.817  -4.679  1.00  8.15           C  
ATOM    332  CG  LEU A  43      -7.781  -6.390  -4.853  1.00  8.05           C  
ATOM    333  CD1 LEU A  43      -7.489  -5.620  -3.588  1.00  8.09           C  
ATOM    334  CD2 LEU A  43      -7.187  -5.682  -6.071  1.00  9.46           C  
ATOM    335  N   ILE A  44      -7.130 -11.015  -4.809  1.00  9.15           N  
ATOM    336  CA  ILE A  44      -6.444 -12.321  -4.726  1.00  9.27           C  
ATOM    337  C   ILE A  44      -6.556 -13.070  -6.051  1.00 10.66           C  
ATOM    338  O   ILE A  44      -5.543 -13.566  -6.588  1.00 10.85           O  
ATOM    339  CB  ILE A  44      -6.974 -13.183  -3.560  1.00  9.40           C  
ATOM    340  CG1 ILE A  44      -6.592 -12.550  -2.214  1.00  9.07           C  
ATOM    341  CG2 ILE A  44      -6.426 -14.642  -3.666  1.00  9.75           C  
ATOM    342  CD1 ILE A  44      -7.235 -13.252  -0.973  1.00 11.81           C  
ATOM    343  N   ASP A  45      -7.779 -13.113  -6.595  1.00 10.82           N  
ATOM    344  CA  ASP A  45      -8.073 -13.749  -7.894  1.00 12.32           C  
ATOM    345  C   ASP A  45      -7.231 -13.142  -9.037  1.00 12.98           C  
ATOM    346  O   ASP A  45      -6.740 -13.868  -9.924  1.00 12.69           O  
ATOM    347  CB  ASP A  45      -9.588 -13.643  -8.168  1.00 13.17           C  
ATOM    348  CG  ASP A  45     -10.020 -14.368  -9.430  1.00 16.16           C  
ATOM    349  OD1 ASP A  45      -9.616 -15.534  -9.633  1.00 18.34           O  
ATOM    350  OD2 ASP A  45     -10.783 -13.763 -10.214  1.00 20.59           O  
ATOM    351  N   MET A  46      -7.042 -11.827  -9.010  1.00 13.70           N  
ATOM    352  CA  MET A  46      -6.205 -11.134  -9.995  1.00 14.69           C  
ATOM    353  C   MET A  46      -4.692 -11.374  -9.847  1.00 15.00           C  
ATOM    354  O   MET A  46      -3.898 -10.937 -10.682  1.00 15.64           O  
ATOM    355  CB  MET A  46      -6.443  -9.621  -9.938  1.00 15.99           C  
ATOM    356  CG  MET A  46      -7.789  -9.133 -10.432  1.00 16.73           C  
ATOM    357  SD  MET A  46      -8.139  -7.468  -9.797  1.00 21.51           S  
ATOM    358  CE  MET A  46      -7.092  -6.435 -10.807  1.00 22.15           C  
ATOM    359  N   GLY A  47      -4.281 -12.011  -8.767  1.00 14.64           N  
ATOM    360  CA  GLY A  47      -2.850 -12.251  -8.553  1.00 13.78           C  
ATOM    361  C   GLY A  47      -2.120 -11.187  -7.767  1.00 13.39           C  
ATOM    362  O   GLY A  47      -0.899 -11.232  -7.653  1.00 12.76           O  
ATOM    363  N   GLU A  48      -2.864 -10.242  -7.191  1.00 13.05           N  
ATOM    364  CA  GLU A  48      -2.287  -9.245  -6.301  1.00 13.69           C  
ATOM    365  C   GLU A  48      -1.948  -9.790  -4.913  1.00 13.70           C  
ATOM    366  O   GLU A  48      -2.509 -10.803  -4.467  1.00 12.88           O  
ATOM    367  CB  GLU A  48      -3.247  -8.057  -6.142  1.00 14.35           C  
ATOM    368  CG  GLU A  48      -3.624  -7.376  -7.451  1.00 17.84           C  
ATOM    369  CD  GLU A  48      -2.428  -6.890  -8.262  1.00 21.79           C  
ATOM    370  OE1 GLU A  48      -1.467  -6.295  -7.697  1.00 23.26           O  
ATOM    371  OE2 GLU A  48      -2.462  -7.094  -9.495  1.00 25.32           O  
ATOM    372  N   GLU A  49      -1.007  -9.112  -4.251  1.00 13.72           N  
ATOM    373  CA  GLU A  49      -0.703  -9.346  -2.847  1.00 14.16           C  
ATOM    374  C   GLU A  49      -0.945  -8.075  -2.052  1.00 13.49           C  
ATOM    375  O   GLU A  49      -0.030  -7.449  -1.522  1.00 15.24           O  
ATOM    376  CB  GLU A  49       0.726  -9.839  -2.674  1.00 15.25           C  
ATOM    377  CG  GLU A  49       1.013 -11.057  -3.476  1.00 17.11           C  
ATOM    378  CD  GLU A  49       2.384 -11.585  -3.193  1.00 21.33           C  
ATOM    379  OE1 GLU A  49       2.667 -11.914  -2.020  1.00 22.78           O  
ATOM    380  OE2 GLU A  49       3.179 -11.656  -4.150  1.00 24.30           O  
ATOM    381  N   ILE A  50      -2.210  -7.700  -2.002  1.00 12.42           N  
ATOM    382  CA  ILE A  50      -2.702  -6.577  -1.216  1.00 11.26           C  
ATOM    383  C   ILE A  50      -3.529  -7.183  -0.092  1.00 11.09           C  
ATOM    384  O   ILE A  50      -4.481  -7.925  -0.349  1.00 11.11           O  
ATOM    385  CB  ILE A  50      -3.542  -5.633  -2.109  1.00 11.40           C  
ATOM    386  CG1 ILE A  50      -2.656  -5.058  -3.231  1.00 10.42           C  
ATOM    387  CG2 ILE A  50      -4.212  -4.505  -1.275  1.00  9.91           C  
ATOM    388  CD1 ILE A  50      -3.418  -4.489  -4.426  1.00 12.28           C  
ATOM    389  N   GLY A  51      -3.166  -6.873   1.151  1.00 10.42           N  
ATOM    390  CA  GLY A  51      -3.832  -7.455   2.309  1.00  9.61           C  
ATOM    391  C   GLY A  51      -5.180  -6.825   2.624  1.00  9.62           C  
ATOM    392  O   GLY A  51      -5.491  -5.715   2.185  1.00  9.12           O  
ATOM    393  N   LEU A  52      -5.986  -7.542   3.389  1.00  9.17           N  
ATOM    394  CA  LEU A  52      -7.318  -7.066   3.702  1.00  8.83           C  
ATOM    395  C   LEU A  52      -7.328  -5.759   4.489  1.00  7.89           C  
ATOM    396  O   LEU A  52      -8.174  -4.912   4.220  1.00  6.83           O  
ATOM    397  CB  LEU A  52      -8.108  -8.145   4.435  1.00  9.67           C  
ATOM    398  CG  LEU A  52      -9.543  -7.846   4.839  1.00 10.54           C  
ATOM    399  CD1 LEU A  52     -10.440  -7.550   3.610  1.00 10.47           C  
ATOM    400  CD2 LEU A  52     -10.047  -9.070   5.569  1.00 12.30           C  
ATOM    401  N   ALA A  53      -6.407  -5.572   5.450  1.00  7.60           N  
ATOM    402  CA  ALA A  53      -6.385  -4.302   6.205  1.00  7.11           C  
ATOM    403  C   ALA A  53      -6.106  -3.128   5.278  1.00  7.20           C  
ATOM    404  O   ALA A  53      -6.653  -2.035   5.464  1.00  7.94           O  
ATOM    405  CB  ALA A  53      -5.360  -4.342   7.335  1.00  7.88           C  
ATOM    406  N   THR A  54      -5.250  -3.348   4.283  1.00  6.79           N  
ATOM    407  CA  THR A  54      -4.966  -2.321   3.299  1.00  7.03           C  
ATOM    408  C   THR A  54      -6.224  -1.960   2.501  1.00  7.33           C  
ATOM    409  O   THR A  54      -6.512  -0.783   2.266  1.00  7.09           O  
ATOM    410  CB  THR A  54      -3.832  -2.767   2.368  1.00  7.10           C  
ATOM    411  OG1 THR A  54      -2.612  -2.788   3.131  1.00  9.60           O  
ATOM    412  CG2 THR A  54      -3.692  -1.810   1.205  1.00  6.70           C  
ATOM    413  N   VAL A  55      -6.968  -2.976   2.095  1.00  7.73           N  
ATOM    414  CA  VAL A  55      -8.234  -2.748   1.405  1.00  7.20           C  
ATOM    415  C   VAL A  55      -9.176  -1.865   2.229  1.00  7.42           C  
ATOM    416  O   VAL A  55      -9.665  -0.856   1.729  1.00  7.43           O  
ATOM    417  CB  VAL A  55      -8.901  -4.079   1.034  1.00  7.41           C  
ATOM    418  CG1 VAL A  55     -10.291  -3.834   0.447  1.00  8.08           C  
ATOM    419  CG2 VAL A  55      -8.028  -4.832   0.025  1.00  8.64           C  
ATOM    420  N   TYR A  56      -9.411  -2.223   3.487  1.00  7.91           N  
ATOM    421  CA  TYR A  56     -10.220  -1.395   4.403  1.00  9.32           C  
ATOM    422  C   TYR A  56      -9.691   0.038   4.523  1.00  9.50           C  
ATOM    423  O   TYR A  56     -10.450   1.001   4.419  1.00  9.84           O  
ATOM    424  CB  TYR A  56     -10.292  -2.038   5.790  1.00  9.17           C  
ATOM    425  CG  TYR A  56     -11.378  -3.080   5.953  1.00 10.66           C  
ATOM    426  CD1 TYR A  56     -11.100  -4.441   5.803  1.00 12.13           C  
ATOM    427  CD2 TYR A  56     -12.686  -2.701   6.273  1.00 13.05           C  
ATOM    428  CE1 TYR A  56     -12.100  -5.396   5.967  1.00 13.10           C  
ATOM    429  CE2 TYR A  56     -13.684  -3.643   6.441  1.00 13.63           C  
ATOM    430  CZ  TYR A  56     -13.381  -4.982   6.292  1.00 13.81           C  
ATOM    431  OH  TYR A  56     -14.364  -5.911   6.480  1.00 15.44           O  
ATOM    432  N   ARG A  57      -8.386   0.174   4.753  1.00  9.22           N  
ATOM    433  CA  ARG A  57      -7.770   1.486   4.904  1.00  9.43           C  
ATOM    434  C   ARG A  57      -7.967   2.343   3.654  1.00  9.24           C  
ATOM    435  O   ARG A  57      -8.402   3.497   3.761  1.00  8.99           O  
ATOM    436  CB  ARG A  57      -6.291   1.348   5.318  1.00 10.29           C  
ATOM    437  CG  ARG A  57      -6.144   0.969   6.800  1.00 11.13           C  
ATOM    438  CD  ARG A  57      -4.687   1.198   7.344  1.00 14.49           C  
ATOM    439  NE  ARG A  57      -3.746   0.275   6.720  1.00 13.63           N  
ATOM    440  CZ  ARG A  57      -3.377  -0.891   7.244  1.00 16.89           C  
ATOM    441  NH1 ARG A  57      -3.861  -1.278   8.427  1.00 17.35           N  
ATOM    442  NH2 ARG A  57      -2.508  -1.673   6.581  1.00 17.75           N  
ATOM    443  N   VAL A  58      -7.742   1.756   2.478  1.00  8.01           N  
ATOM    444  CA  VAL A  58      -7.907   2.481   1.212  1.00  8.28           C  
ATOM    445  C   VAL A  58      -9.361   2.898   0.979  1.00  7.83           C  
ATOM    446  O   VAL A  58      -9.644   4.052   0.598  1.00  8.15           O  
ATOM    447  CB  VAL A  58      -7.351   1.666   0.042  1.00  8.28           C  
ATOM    448  CG1 VAL A  58      -7.805   2.239  -1.317  1.00  8.63           C  
ATOM    449  CG2 VAL A  58      -5.808   1.587   0.156  1.00  8.87           C  
ATOM    450  N   LEU A  59     -10.289   1.980   1.218  1.00  8.04           N  
ATOM    451  CA  LEU A  59     -11.719   2.282   1.009  1.00  8.10           C  
ATOM    452  C   LEU A  59     -12.203   3.403   1.932  1.00  8.55           C  
ATOM    453  O   LEU A  59     -12.958   4.280   1.533  1.00  8.42           O  
ATOM    454  CB  LEU A  59     -12.551   1.023   1.226  1.00  8.15           C  
ATOM    455  CG  LEU A  59     -12.478   0.033   0.068  1.00  8.09           C  
ATOM    456  CD1 LEU A  59     -13.142  -1.312   0.471  1.00  8.25           C  
ATOM    457  CD2 LEU A  59     -13.151   0.651  -1.199  1.00  7.71           C  
ATOM    458  N   ASN A  60     -11.718   3.391   3.161  1.00  9.08           N  
ATOM    459  CA  ASN A  60     -12.129   4.397   4.124  1.00 10.03           C  
ATOM    460  C   ASN A  60     -11.530   5.763   3.798  1.00  9.93           C  
ATOM    461  O   ASN A  60     -12.165   6.816   4.007  1.00  9.15           O  
ATOM    462  CB  ASN A  60     -11.837   3.899   5.544  1.00 10.63           C  
ATOM    463  CG  ASN A  60     -12.849   2.840   6.008  1.00 12.49           C  
ATOM    464  OD1 ASN A  60     -12.490   1.713   6.341  1.00 16.57           O  
ATOM    465  ND2 ASN A  60     -14.119   3.213   6.048  1.00 13.57           N  
ATOM    466  N   GLN A  61     -10.323   5.742   3.237  1.00  9.95           N  
ATOM    467  CA  GLN A  61      -9.700   6.961   2.731  1.00 10.40           C  
ATOM    468  C   GLN A  61     -10.480   7.492   1.517  1.00 10.22           C  
ATOM    469  O   GLN A  61     -10.720   8.693   1.397  1.00  8.74           O  
ATOM    470  CB  GLN A  61      -8.240   6.715   2.352  1.00 11.22           C  
ATOM    471  CG  GLN A  61      -7.304   6.516   3.546  1.00 12.84           C  
ATOM    472  CD  GLN A  61      -5.979   5.914   3.146  1.00 15.33           C  
ATOM    473  OE1 GLN A  61      -5.720   5.716   1.965  1.00 15.97           O  
ATOM    474  NE2 GLN A  61      -5.130   5.597   4.138  1.00 16.68           N  
ATOM    475  N   PHE A  62     -10.878   6.583   0.625  1.00 10.02           N  
ATOM    476  CA  PHE A  62     -11.686   6.935  -0.549  1.00 10.33           C  
ATOM    477  C   PHE A  62     -13.018   7.552  -0.129  1.00 10.74           C  
ATOM    478  O   PHE A  62     -13.507   8.503  -0.772  1.00 11.35           O  
ATOM    479  CB  PHE A  62     -11.951   5.687  -1.395  1.00 10.23           C  
ATOM    480  CG  PHE A  62     -10.811   5.295  -2.309  1.00  9.69           C  
ATOM    481  CD1 PHE A  62      -9.542   5.881  -2.204  1.00 10.54           C  
ATOM    482  CD2 PHE A  62     -11.008   4.284  -3.269  1.00  9.18           C  
ATOM    483  CE1 PHE A  62      -8.489   5.487  -3.069  1.00 10.52           C  
ATOM    484  CE2 PHE A  62      -9.976   3.868  -4.109  1.00  8.82           C  
ATOM    485  CZ  PHE A  62      -8.711   4.496  -4.025  1.00 10.09           C  
ATOM    486  N   ASP A  63     -13.590   7.032   0.955  1.00 10.13           N  
ATOM    487  CA  ASP A  63     -14.860   7.568   1.456  1.00 11.61           C  
ATOM    488  C   ASP A  63     -14.631   9.005   1.941  1.00 12.45           C  
ATOM    489  O   ASP A  63     -15.382   9.921   1.591  1.00 13.62           O  
ATOM    490  CB  ASP A  63     -15.418   6.700   2.583  1.00 11.01           C  
ATOM    491  CG  ASP A  63     -16.596   7.369   3.293  1.00 13.00           C  
ATOM    492  OD1 ASP A  63     -17.618   7.639   2.640  1.00 15.39           O  
ATOM    493  OD2 ASP A  63     -16.481   7.667   4.491  1.00 13.57           O  
ATOM    494  N   ASP A  64     -13.569   9.210   2.713  1.00 13.57           N  
ATOM    495  CA  ASP A  64     -13.216  10.566   3.170  1.00 14.81           C  
ATOM    496  C   ASP A  64     -12.971  11.542   2.031  1.00 15.37           C  
ATOM    497  O   ASP A  64     -13.294  12.730   2.143  1.00 15.65           O  
ATOM    498  CB  ASP A  64     -12.001  10.535   4.088  1.00 14.89           C  
ATOM    499  CG  ASP A  64     -12.313   9.907   5.409  1.00 17.06           C  
ATOM    500  OD1 ASP A  64     -13.516   9.817   5.735  1.00 19.09           O  
ATOM    501  OD2 ASP A  64     -11.373   9.497   6.119  1.00 19.90           O  
ATOM    502  N   ALA A  65     -12.384  11.038   0.956  1.00 15.17           N  
ATOM    503  CA  ALA A  65     -12.024  11.845  -0.191  1.00 15.91           C  
ATOM    504  C   ALA A  65     -13.216  12.092  -1.118  1.00 15.95           C  
ATOM    505  O   ALA A  65     -13.113  12.866  -2.070  1.00 17.34           O  
ATOM    506  CB  ALA A  65     -10.883  11.156  -0.961  1.00 16.28           C  
ATOM    507  N   GLY A  66     -14.331  11.414  -0.852  1.00 16.05           N  
ATOM    508  CA  GLY A  66     -15.523  11.509  -1.685  1.00 16.27           C  
ATOM    509  C   GLY A  66     -15.481  10.706  -2.978  1.00 16.39           C  
ATOM    510  O   GLY A  66     -16.275  10.961  -3.885  1.00 17.94           O  
ATOM    511  N   ILE A  67     -14.565   9.747  -3.057  1.00 15.40           N  
ATOM    512  CA  ILE A  67     -14.399   8.858  -4.220  1.00 15.49           C  
ATOM    513  C   ILE A  67     -15.419   7.721  -4.169  1.00 14.20           C  
ATOM    514  O   ILE A  67     -15.865   7.235  -5.219  1.00 13.82           O  
ATOM    515  CB  ILE A  67     -12.956   8.240  -4.279  1.00 15.90           C  
ATOM    516  CG1 ILE A  67     -11.914   9.292  -4.647  1.00 17.88           C  
ATOM    517  CG2 ILE A  67     -12.862   7.056  -5.267  1.00 17.62           C  
ATOM    518  CD1 ILE A  67     -10.477   8.823  -4.472  1.00 17.44           C  
ATOM    519  N   VAL A  68     -15.761   7.276  -2.958  1.00 13.13           N  
ATOM    520  CA  VAL A  68     -16.732   6.184  -2.805  1.00 12.93           C  
ATOM    521  C   VAL A  68     -17.847   6.521  -1.832  1.00 13.03           C  
ATOM    522  O   VAL A  68     -17.693   7.400  -0.971  1.00 11.56           O  
ATOM    523  CB  VAL A  68     -16.110   4.813  -2.389  1.00 13.12           C  
ATOM    524  CG1 VAL A  68     -15.060   4.337  -3.419  1.00 12.41           C  
ATOM    525  CG2 VAL A  68     -15.566   4.868  -0.961  1.00 12.36           C  
ATOM    526  N   THR A  69     -18.960   5.803  -2.006  1.00 13.23           N  
ATOM    527  CA  THR A  69     -20.108   5.845  -1.112  1.00 14.63           C  
ATOM    528  C   THR A  69     -20.224   4.518  -0.372  1.00 14.50           C  
ATOM    529  O   THR A  69     -20.111   3.449  -0.965  1.00 14.71           O  
ATOM    530  CB  THR A  69     -21.427   6.107  -1.896  1.00 14.54           C  
ATOM    531  OG1 THR A  69     -21.345   7.375  -2.551  1.00 17.38           O  
ATOM    532  CG2 THR A  69     -22.626   6.116  -0.945  1.00 15.93           C  
ATOM    533  N   ARG A  70     -20.443   4.601   0.932  1.00 14.64           N  
ATOM    534  CA  ARG A  70     -20.603   3.431   1.769  1.00 14.82           C  
ATOM    535  C   ARG A  70     -22.092   3.215   2.002  1.00 14.80           C  
ATOM    536  O   ARG A  70     -22.821   4.190   2.236  1.00 15.66           O  
ATOM    537  CB  ARG A  70     -19.864   3.688   3.095  1.00 14.98           C  
ATOM    538  CG  ARG A  70     -20.088   2.678   4.206  1.00 15.78           C  
ATOM    539  CD  ARG A  70     -19.706   3.290   5.570  1.00 14.36           C  
ATOM    540  NE  ARG A  70     -18.567   4.213   5.485  1.00 13.85           N  
ATOM    541  CZ  ARG A  70     -17.291   3.858   5.599  1.00 12.37           C  
ATOM    542  NH1 ARG A  70     -16.963   2.597   5.812  1.00 12.59           N  
ATOM    543  NH2 ARG A  70     -16.337   4.777   5.502  1.00 13.46           N  
ATOM    544  N   HIS A  71     -22.540   1.964   1.908  1.00 14.19           N  
ATOM    545  CA  HIS A  71     -23.898   1.582   2.299  1.00 13.78           C  
ATOM    546  C   HIS A  71     -23.893   0.514   3.386  1.00 13.98           C  
ATOM    547  O   HIS A  71     -23.198  -0.488   3.266  1.00 14.31           O  
ATOM    548  CB  HIS A  71     -24.678   1.043   1.104  1.00 13.41           C  
ATOM    549  CG  HIS A  71     -24.745   1.995  -0.044  1.00 12.50           C  
ATOM    550  ND1 HIS A  71     -25.561   3.106  -0.039  1.00 13.73           N  
ATOM    551  CD2 HIS A  71     -24.105   1.999  -1.235  1.00 11.35           C  
ATOM    552  CE1 HIS A  71     -25.411   3.761  -1.176  1.00 12.09           C  
ATOM    553  NE2 HIS A  71     -24.533   3.109  -1.920  1.00 12.68           N  
ATOM    554  N   ASN A  72     -24.720   0.705   4.406  1.00 13.52           N  
ATOM    555  CA  ASN A  72     -24.800  -0.230   5.528  1.00 13.83           C  
ATOM    556  C   ASN A  72     -26.170  -0.871   5.504  1.00 13.56           C  
ATOM    557  O   ASN A  72     -27.180  -0.167   5.605  1.00 13.69           O  
ATOM    558  CB  ASN A  72     -24.587   0.504   6.853  1.00 14.03           C  
ATOM    559  CG  ASN A  72     -23.137   0.997   7.026  1.00 16.21           C  
ATOM    560  OD1 ASN A  72     -22.202   0.196   7.137  1.00 17.97           O  
ATOM    561  ND2 ASN A  72     -22.955   2.314   7.042  1.00 17.97           N  
ATOM    562  N   PHE A  73     -26.203  -2.190   5.362  1.00 13.52           N  
ATOM    563  CA  PHE A  73     -27.457  -2.939   5.246  1.00 13.85           C  
ATOM    564  C   PHE A  73     -27.787  -3.663   6.548  1.00 14.25           C  
ATOM    565  O   PHE A  73     -26.952  -3.736   7.455  1.00 13.64           O  
ATOM    566  CB  PHE A  73     -27.360  -3.948   4.078  1.00 14.72           C  
ATOM    567  CG  PHE A  73     -27.150  -3.298   2.745  1.00 16.33           C  
ATOM    568  CD1 PHE A  73     -28.209  -2.704   2.072  1.00 18.14           C  
ATOM    569  CD2 PHE A  73     -25.898  -3.270   2.157  1.00 19.36           C  
ATOM    570  CE1 PHE A  73     -28.023  -2.071   0.832  1.00 19.62           C  
ATOM    571  CE2 PHE A  73     -25.706  -2.640   0.907  1.00 21.00           C  
ATOM    572  CZ  PHE A  73     -26.779  -2.039   0.255  1.00 20.31           C  
ATOM    573  N   GLU A  74     -28.995  -4.217   6.623  1.00 14.36           N  
ATOM    574  CA  GLU A  74     -29.371  -5.148   7.695  1.00 15.44           C  
ATOM    575  C   GLU A  74     -28.309  -6.218   7.959  1.00 16.19           C  
ATOM    576  O   GLU A  74     -27.699  -6.746   7.034  1.00 16.09           O  
ATOM    577  CB  GLU A  74     -30.707  -5.831   7.377  1.00 15.55           C  
ATOM    578  CG  GLU A  74     -31.894  -4.920   7.566  1.00 15.71           C  
ATOM    579  CD  GLU A  74     -31.976  -4.381   8.993  1.00 15.05           C  
ATOM    580  OE1 GLU A  74     -32.521  -5.079   9.865  1.00 13.96           O  
ATOM    581  OE2 GLU A  74     -31.471  -3.260   9.240  1.00 15.09           O  
ATOM    582  N   GLY A  75     -28.096  -6.520   9.236  1.00 17.38           N  
ATOM    583  CA  GLY A  75     -27.182  -7.583   9.643  1.00 18.20           C  
ATOM    584  C   GLY A  75     -25.724  -7.168   9.630  1.00 18.72           C  
ATOM    585  O   GLY A  75     -24.844  -8.017   9.733  1.00 19.09           O  
ATOM    586  N   GLY A  76     -25.457  -5.872   9.498  1.00 18.74           N  
ATOM    587  CA  GLY A  76     -24.084  -5.365   9.565  1.00 19.29           C  
ATOM    588  C   GLY A  76     -23.274  -5.580   8.297  1.00 20.06           C  
ATOM    589  O   GLY A  76     -22.049  -5.425   8.296  1.00 20.76           O  
ATOM    590  N   LYS A  77     -23.964  -5.946   7.219  1.00 19.82           N  
ATOM    591  CA  LYS A  77     -23.351  -6.109   5.912  1.00 19.64           C  
ATOM    592  C   LYS A  77     -23.189  -4.751   5.271  1.00 18.95           C  
ATOM    593  O   LYS A  77     -24.092  -3.907   5.348  1.00 19.10           O  
ATOM    594  CB  LYS A  77     -24.199  -7.021   5.036  1.00 20.53           C  
ATOM    595  CG  LYS A  77     -24.413  -8.412   5.633  1.00 22.52           C  
ATOM    596  CD  LYS A  77     -24.472  -9.488   4.557  1.00 26.27           C  
ATOM    597  CE  LYS A  77     -25.850  -9.607   3.912  1.00 29.40           C  
ATOM    598  NZ  LYS A  77     -26.842 -10.316   4.792  1.00 31.02           N  
ATOM    599  N   SER A  78     -22.028  -4.525   4.665  0.50 18.17           N  
ATOM    601  CA  SER A  78     -21.697  -3.227   4.074  0.50 17.64           C  
ATOM    603  C   SER A  78     -21.122  -3.391   2.679  0.50 16.96           C  
ATOM    605  O   SER A  78     -20.490  -4.409   2.377  0.50 16.70           O  
ATOM    607  CB  SER A  78     -20.687  -2.475   4.943  0.50 17.66           C  
ATOM    609  OG  SER A  78     -21.150  -2.333   6.275  0.50 17.81           O  
ATOM    611  N   VAL A  79     -21.343  -2.379   1.839  1.00 16.15           N  
ATOM    612  CA  VAL A  79     -20.775  -2.324   0.485  1.00 14.63           C  
ATOM    613  C   VAL A  79     -20.355  -0.908   0.107  1.00 13.33           C  
ATOM    614  O   VAL A  79     -20.839   0.088   0.670  1.00 12.37           O  
ATOM    615  CB  VAL A  79     -21.707  -2.900  -0.648  1.00 14.28           C  
ATOM    616  CG1 VAL A  79     -22.200  -4.324  -0.301  1.00 14.61           C  
ATOM    617  CG2 VAL A  79     -22.890  -1.975  -0.920  1.00 14.70           C  
ATOM    618  N   PHE A  80     -19.462  -0.841  -0.875  1.00 12.33           N  
ATOM    619  CA  PHE A  80     -18.921   0.413  -1.371  1.00 11.46           C  
ATOM    620  C   PHE A  80     -19.178   0.514  -2.855  1.00 11.28           C  
ATOM    621  O   PHE A  80     -19.163  -0.500  -3.538  1.00 10.57           O  
ATOM    622  CB  PHE A  80     -17.415   0.434  -1.154  1.00 11.47           C  
ATOM    623  CG  PHE A  80     -17.026   0.392   0.295  1.00 12.35           C  
ATOM    624  CD1 PHE A  80     -16.896   1.570   1.017  1.00 12.03           C  
ATOM    625  CD2 PHE A  80     -16.871  -0.822   0.944  1.00 13.52           C  
ATOM    626  CE1 PHE A  80     -16.549   1.534   2.362  1.00 12.33           C  
ATOM    627  CE2 PHE A  80     -16.523  -0.860   2.301  1.00 15.03           C  
ATOM    628  CZ  PHE A  80     -16.370   0.330   2.999  1.00 12.25           C  
ATOM    629  N   GLU A  81     -19.403   1.734  -3.333  1.00 11.26           N  
ATOM    630  CA  GLU A  81     -19.424   2.029  -4.771  1.00 11.66           C  
ATOM    631  C   GLU A  81     -18.788   3.378  -5.059  1.00 12.02           C  
ATOM    632  O   GLU A  81     -18.726   4.227  -4.189  1.00 12.17           O  
ATOM    633  CB  GLU A  81     -20.854   1.981  -5.328  1.00 11.32           C  
ATOM    634  CG  GLU A  81     -21.762   3.089  -4.847  1.00 11.25           C  
ATOM    635  CD  GLU A  81     -23.168   2.947  -5.431  1.00 10.66           C  
ATOM    636  OE1 GLU A  81     -23.300   2.829  -6.668  1.00 12.62           O  
ATOM    637  OE2 GLU A  81     -24.139   2.943  -4.650  1.00 11.03           O  
ATOM    638  N   LEU A  82     -18.323   3.579  -6.285  1.00 13.16           N  
ATOM    639  CA  LEU A  82     -17.786   4.874  -6.678  1.00 14.05           C  
ATOM    640  C   LEU A  82     -18.908   5.897  -6.699  1.00 15.00           C  
ATOM    641  O   LEU A  82     -20.022   5.595  -7.145  1.00 14.65           O  
ATOM    642  CB  LEU A  82     -17.099   4.798  -8.042  1.00 14.29           C  
ATOM    643  CG  LEU A  82     -15.811   3.972  -8.061  1.00 13.91           C  
ATOM    644  CD1 LEU A  82     -15.477   3.455  -9.448  1.00 15.48           C  
ATOM    645  CD2 LEU A  82     -14.675   4.800  -7.478  1.00 14.30           C  
ATOM    646  N   THR A  83     -18.634   7.095  -6.197  0.50 15.01           N  
ATOM    648  CA  THR A  83     -19.657   8.148  -6.114  0.50 15.40           C  
ATOM    650  C   THR A  83     -19.946   8.786  -7.475  0.50 15.63           C  
ATOM    652  O   THR A  83     -19.314   8.446  -8.479  0.50 16.22           O  
ATOM    654  CB  THR A  83     -19.247   9.239  -5.120  0.50 15.18           C  
ATOM    656  OG1 THR A  83     -18.732   8.626  -3.935  0.50 14.33           O  
ATOM    658  CG2 THR A  83     -20.434  10.134  -4.764  0.50 14.82           C  
TER     660      THR A  83                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
