
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  215 ( 1660),  selected  215 , name 1fuu_A
# Molecule2: number of CA atoms  240 ( 1868),  selected  240 , name T0477.pdb
# PARAMETERS: 1fuu_A.T0477.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      M       2           -
LGA    -       -      K       3           -
LGA    -       -      I       4           -
LGA    -       -      N       5           -
LGA    -       -      F       6           -
LGA    -       -      L       7           -
LGA    -       -      R       8           -
LGA    -       -      N       9           -
LGA    -       -      K      10           -
LGA    -       -      H      11           -
LGA    Q    11_A      K      12          2.406
LGA    I    12_A      I      13          2.386
LGA    Q    13_A      H      14          1.257
LGA    T    14_A      V      15          0.781
LGA    N    15_A      Q      16          3.535
LGA    -       -      G      17           -
LGA    -       -      T      18           -
LGA    Y    16_A      D      19           #
LGA    D    17_A      L      20           #
LGA    -       -      P      21           -
LGA    K    18_A      D      22          1.349
LGA    V    19_A      P      23          2.018
LGA    V    20_A      I      24          1.317
LGA    Y    21_A      A      25          1.580
LGA    K    22_A      T      26          1.254
LGA    F    23_A      F      27          0.616
LGA    D    24_A      Q      28          1.014
LGA    D    25_A      Q      29          0.621
LGA    X    26_A      L      30          1.094
LGA    E    27_A      D      31          2.725
LGA    -       -      Q      32           -
LGA    -       -      E      33           -
LGA    -       -      Y      34           -
LGA    -       -      K      35           -
LGA    L    28_A      I      36          1.608
LGA    D    29_A      N      37          1.321
LGA    E    30_A      S      38          0.823
LGA    N    31_A      R      39          1.575
LGA    L    32_A      L      40          1.138
LGA    L    33_A      L      41          0.590
LGA    R    34_A      Q      42          1.519
LGA    G    35_A      N      43          1.679
LGA    V    36_A      I      44          0.955
LGA    F    37_A      L      45          1.308
LGA    G    38_A      D      46          2.423
LGA    Y    39_A      A      47          2.323
LGA    G    40_A      G      48          2.510
LGA    F    41_A      F      49          1.222
LGA    E    42_A      Q      50          1.217
LGA    E    43_A      M      51          0.731
LGA    P    44_A      P      52          0.633
LGA    S    45_A      T      53          0.961
LGA    A    46_A      P      54          0.931
LGA    I    47_A      I      55          0.972
LGA    Q    48_A      Q      56          0.958
LGA    Q    49_A      M      57          1.061
LGA    R    50_A      Q      58          1.031
LGA    A    51_A      A      59          0.991
LGA    I    52_A      I      60          0.811
LGA    X    53_A      P      61          1.231
LGA    P    54_A      V      62          1.325
LGA    I    55_A      M      63          0.854
LGA    I    56_A      L      64          1.488
LGA    E    57_A      H      65          1.777
LGA    G    58_A      G      66          0.967
LGA    H    59_A      R      67          0.867
LGA    D    60_A      E      68          0.651
LGA    V    61_A      L      69          1.143
LGA    L    62_A      L      70          1.059
LGA    A    63_A      A      71          0.657
LGA    Q    64_A      S      72          0.671
LGA    A    65_A      A      73          1.776
LGA    Q    66_A      P      74          2.207
LGA    S    67_A      T      75          2.712
LGA    G    68_A      G      76          3.157
LGA    T    69_A      S      77           #
LGA    G    70_A      G      78          1.143
LGA    K    71_A      K      79          1.002
LGA    T    72_A      T      80          0.606
LGA    G    73_A      L      81          1.001
LGA    T    74_A      A      82          0.853
LGA    F    75_A      F      83          0.457
LGA    S    76_A      S      84          0.857
LGA    I    77_A      I      85          1.027
LGA    A    78_A      P      86          1.099
LGA    A    79_A      I      87          0.778
LGA    L    80_A      L      88          0.747
LGA    Q    81_A      M      89          0.635
LGA    R    82_A      Q      90          1.067
LGA    I    83_A      L      91          1.242
LGA    D    84_A      K      92          4.092
LGA    T    85_A      Q      93          2.167
LGA    S    86_A      P      94          5.126
LGA    V    87_A      A      95          2.445
LGA    K    88_A      N      96          1.922
LGA    -       -      K      97           -
LGA    A    89_A      G      98          1.228
LGA    P    90_A      F      99          0.412
LGA    Q    91_A      R     100          0.373
LGA    A    92_A      A     101          0.373
LGA    L    93_A      L     102          0.370
LGA    X    94_A      I     103          0.274
LGA    L    95_A      I     104          0.391
LGA    A    96_A      S     105          0.416
LGA    P    97_A      P     106          0.779
LGA    T    98_A      T     107          0.626
LGA    R    99_A      R     108          0.545
LGA    E   100_A      E     109          0.352
LGA    L   101_A      L     110          0.316
LGA    A   102_A      A     111          0.355
LGA    L   103_A      S     112          0.551
LGA    Q   104_A      Q     113          0.394
LGA    I   105_A      I     114          0.234
LGA    Q   106_A      H     115          0.404
LGA    K   107_A      R     116          0.367
LGA    V   108_A      E     117          0.475
LGA    V   109_A      L     118          0.630
LGA    X   110_A      I     119          0.598
LGA    A   111_A      K     120          0.452
LGA    L   112_A      I     121          0.658
LGA    A   113_A      S     122          0.375
LGA    F   114_A      E     123          0.544
LGA    H   115_A      G     124          2.071
LGA    X   116_A      T     125          0.497
LGA    D   117_A      G     126          0.154
LGA    I   118_A      F     127          0.417
LGA    K   119_A      R     128          0.478
LGA    V   120_A      I     129          0.592
LGA    H   121_A      H     130          1.063
LGA    A   122_A      M     131          0.797
LGA    C   123_A      I     132          3.006
LGA    I   124_A      H     133          5.208
LGA    G   125_A      -       -           -
LGA    G   126_A      K     134          3.915
LGA    T   127_A      A     135          3.866
LGA    S   128_A      A     136          4.082
LGA    F   129_A      V     137          1.783
LGA    V   130_A      A     138          3.416
LGA    E   131_A      A     139          4.569
LGA    D   132_A      -       -           -
LGA    A   133_A      K     140          2.738
LGA    E   134_A      K     141          1.554
LGA    G   135_A      F     142          4.350
LGA    L   136_A      G     143           #
LGA    R   137_A      P     144           #
LGA    -       -      K     145           -
LGA    -       -      S     146           -
LGA    -       -      S     147           -
LGA    -       -      K     148           -
LGA    D   138_A      K     149          2.689
LGA    A   139_A      F     150          1.885
LGA    Q   140_A      D     151          0.552
LGA    I   141_A      I     152          0.416
LGA    V   142_A      L     153          0.517
LGA    V   143_A      V     154          0.747
LGA    G   144_A      T     155          0.524
LGA    T   145_A      T     156          0.261
LGA    P   146_A      P     157          0.453
LGA    G   147_A      N     158          1.046
LGA    R   148_A      R     159          0.634
LGA    V   149_A      L     160          0.590
LGA    F   150_A      I     161          1.500
LGA    D   151_A      Y     162          1.619
LGA    N   152_A      L     163          0.991
LGA    I   153_A      L     164          2.066
LGA    Q   154_A      K     165          2.738
LGA    R   155_A      Q     166          2.309
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    R   156_A      P     169          1.632
LGA    R   157_A      G     170          1.747
LGA    F   158_A      I     171          1.285
LGA    R   159_A      D     172          1.027
LGA    T   160_A      L     173          0.804
LGA    D   161_A      A     174          0.923
LGA    K   162_A      S     175          0.723
LGA    I   163_A      V     176          0.554
LGA    K   164_A      E     177          0.537
LGA    X   165_A      W     178          0.489
LGA    F   166_A      L     179          0.530
LGA    I   167_A      V     180          0.452
LGA    L   168_A      V     181          0.607
LGA    D   169_A      D     182          0.468
LGA    E   170_A      E     183          0.705
LGA    A   171_A      S     184          0.386
LGA    D   172_A      D     185          0.916
LGA    E   173_A      K     186          0.601
LGA    X   174_A      L     187          1.187
LGA    L   175_A      F     188          1.546
LGA    S   176_A      E     189          1.257
LGA    S   177_A      D     190          1.623
LGA    G   178_A      G     191          0.895
LGA    F   179_A      G     194          5.121
LGA    K   180_A      F     195          1.420
LGA    -       -      R     196           -
LGA    E   181_A      D     197          2.230
LGA    Q   182_A      Q     198          1.252
LGA    I   183_A      L     199          1.638
LGA    Y   184_A      A     200          2.035
LGA    Q   185_A      S     201          1.510
LGA    I   186_A      I     202          0.713
LGA    F   187_A      F     203          1.306
LGA    T   188_A      L     204          1.316
LGA    L   189_A      A     205          1.427
LGA    L   190_A      C     206          1.141
LGA    P   191_A      T     207          1.717
LGA    -       -      S     208           -
LGA    P   192_A      H     209          6.113
LGA    T   193_A      K     210          4.638
LGA    T   194_A      V     211          1.179
LGA    Q   195_A      R     212          0.662
LGA    V   196_A      R     213          0.625
LGA    V   197_A      A     214          0.706
LGA    L   198_A      M     215          0.781
LGA    L   199_A      F     216          0.674
LGA    S   200_A      S     217          0.762
LGA    A   201_A      A     218          1.570
LGA    T   202_A      T     219          1.954
LGA    X   203_A      F     220          3.083
LGA    P   204_A      A     221          2.766
LGA    N   205_A      Y     222          3.166
LGA    D   206_A      D     223          2.703
LGA    V   207_A      V     224          0.779
LGA    L   208_A      E     225          2.301
LGA    E   209_A      Q     226          3.600
LGA    V   210_A      W     227          2.728
LGA    T   211_A      C     228          0.450
LGA    T   212_A      K     229          2.575
LGA    K   213_A      L     230          3.358
LGA    F   214_A      N     231          2.501
LGA    X   215_A      L     232          0.956
LGA    R   216_A      D     233          0.866
LGA    N   217_A      N     234          0.794
LGA    P   218_A      V     235          1.695
LGA    V   219_A      I     236          1.717
LGA    R   220_A      S     237          1.331
LGA    I   221_A      V     238          0.571
LGA    L   222_A      S     239          1.911
LGA    V   223_A      I     240          3.829
LGA    -       -      G     241           -
LGA    K   224_A      A     242           #
LGA    K   225_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  215  240    5.0    206    1.79    25.24     79.045    10.877

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.983580 * X  +  -0.019912 * Y  +  -0.179369 * Z  +  20.640642
  Y_new =  -0.047831 * X  +  -0.987113 * Y  +  -0.152707 * Z  +  35.325695
  Z_new =  -0.174017 * X  +   0.158779 * Y  +  -0.971858 * Z  +  51.331429 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.979646   -0.161946  [ DEG:   170.7212     -9.2788 ]
  Theta =   0.174908    2.966685  [ DEG:    10.0215    169.9785 ]
  Phi   =  -0.048592    3.093001  [ DEG:    -2.7841    177.2159 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1fuu_A                                        
REMARK     2: T0477.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1fuu_A.T0477.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  215  240   5.0  206   1.79   25.24  79.045
REMARK  ---------------------------------------------------------- 
MOLECULE 1fuu_A
HEADER    TRANSLATION                             15-SEP-00   1FUU              
TITLE     YEAST INITIATION FACTOR 4A                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: YEAST INITIATION FACTOR 4A;                                
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: MRNA HELICASE;                                             
COMPND   5 SYNONYM: EUKARYOTIC INITIATION FACTOR 4A;                            
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    IF4A, HELICASE, DEAD-BOX PROTEIN                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.M.CARUTHERS,E.R.JOHNSON,D.B.MCKAY                                   
REVDAT   1   29-NOV-00 1FUU    0                                                
JRNL        AUTH   J.M.CARUTHERS,E.R.JOHNSON,D.B.MCKAY                          
JRNL        TITL   CRYSTAL STRUCTURE OF YEAST INITIATION FACTOR 4A, A           
JRNL        TITL 2 DEAD-BOX RNA HELICASE.                                       
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V.  97 13080 2000              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1FUU A    1   394  UNP    P10081   IF4A_YEAST       1    394             
DBREF  1FUU B    1   394  UNP    P10081   IF4A_YEAST       1    394             
SEQRES   1 A  394  SER GLU GLY ILE THR ASP ILE GLU GLU SER GLN ILE GLN          
SEQRES   2 A  394  THR ASN TYR ASP LYS VAL VAL TYR LYS PHE ASP ASP MSE          
SEQRES   3 A  394  GLU LEU ASP GLU ASN LEU LEU ARG GLY VAL PHE GLY TYR          
SEQRES   4 A  394  GLY PHE GLU GLU PRO SER ALA ILE GLN GLN ARG ALA ILE          
SEQRES   5 A  394  MSE PRO ILE ILE GLU GLY HIS ASP VAL LEU ALA GLN ALA          
SEQRES   6 A  394  GLN SER GLY THR GLY LYS THR GLY THR PHE SER ILE ALA          
SEQRES   7 A  394  ALA LEU GLN ARG ILE ASP THR SER VAL LYS ALA PRO GLN          
SEQRES   8 A  394  ALA LEU MSE LEU ALA PRO THR ARG GLU LEU ALA LEU GLN          
SEQRES   9 A  394  ILE GLN LYS VAL VAL MSE ALA LEU ALA PHE HIS MSE ASP          
SEQRES  10 A  394  ILE LYS VAL HIS ALA CYS ILE GLY GLY THR SER PHE VAL          
SEQRES  11 A  394  GLU ASP ALA GLU GLY LEU ARG ASP ALA GLN ILE VAL VAL          
SEQRES  12 A  394  GLY THR PRO GLY ARG VAL PHE ASP ASN ILE GLN ARG ARG          
SEQRES  13 A  394  ARG PHE ARG THR ASP LYS ILE LYS MSE PHE ILE LEU ASP          
SEQRES  14 A  394  GLU ALA ASP GLU MSE LEU SER SER GLY PHE LYS GLU GLN          
SEQRES  15 A  394  ILE TYR GLN ILE PHE THR LEU LEU PRO PRO THR THR GLN          
SEQRES  16 A  394  VAL VAL LEU LEU SER ALA THR MSE PRO ASN ASP VAL LEU          
SEQRES  17 A  394  GLU VAL THR THR LYS PHE MSE ARG ASN PRO VAL ARG ILE          
SEQRES  18 A  394  LEU VAL LYS LYS ASP GLU LEU THR LEU GLU GLY ILE LYS          
SEQRES  19 A  394  GLN PHE TYR VAL ASN VAL GLU GLU GLU GLU TYR LYS TYR          
SEQRES  20 A  394  GLU CYS LEU THR ASP LEU TYR ASP SER ILE SER VAL THR          
SEQRES  21 A  394  GLN ALA VAL ILE PHE CYS ASN THR ARG ARG LYS VAL GLU          
SEQRES  22 A  394  GLU LEU THR THR LYS LEU ARG ASN ASP LYS PHE THR VAL          
SEQRES  23 A  394  SER ALA ILE TYR SER ASP LEU PRO GLN GLN GLU ARG ASP          
SEQRES  24 A  394  THR ILE MSE LYS GLU PHE ARG SER GLY SER SER ARG ILE          
SEQRES  25 A  394  LEU ILE SER THR ASP LEU LEU ALA ARG GLY ILE ASP VAL          
SEQRES  26 A  394  GLN GLN VAL SER LEU VAL ILE ASN TYR ASP LEU PRO ALA          
SEQRES  27 A  394  ASN LYS GLU ASN TYR ILE HIS ARG ILE GLY ARG GLY GLY          
SEQRES  28 A  394  ARG PHE GLY ARG LYS GLY VAL ALA ILE ASN PHE VAL THR          
SEQRES  29 A  394  ASN GLU ASP VAL GLY ALA MSE ARG GLU LEU GLU LYS PHE          
SEQRES  30 A  394  TYR SER THR GLN ILE GLU GLU LEU PRO SER ASP ILE ALA          
SEQRES  31 A  394  THR LEU LEU ASN                                              
SEQRES   1 B  394  SER GLU GLY ILE THR ASP ILE GLU GLU SER GLN ILE GLN          
SEQRES   2 B  394  THR ASN TYR ASP LYS VAL VAL TYR LYS PHE ASP ASP MSE          
SEQRES   3 B  394  GLU LEU ASP GLU ASN LEU LEU ARG GLY VAL PHE GLY TYR          
SEQRES   4 B  394  GLY PHE GLU GLU PRO SER ALA ILE GLN GLN ARG ALA ILE          
SEQRES   5 B  394  MSE PRO ILE ILE GLU GLY HIS ASP VAL LEU ALA GLN ALA          
SEQRES   6 B  394  GLN SER GLY THR GLY LYS THR GLY THR PHE SER ILE ALA          
SEQRES   7 B  394  ALA LEU GLN ARG ILE ASP THR SER VAL LYS ALA PRO GLN          
SEQRES   8 B  394  ALA LEU MSE LEU ALA PRO THR ARG GLU LEU ALA LEU GLN          
SEQRES   9 B  394  ILE GLN LYS VAL VAL MSE ALA LEU ALA PHE HIS MSE ASP          
SEQRES  10 B  394  ILE LYS VAL HIS ALA CYS ILE GLY GLY THR SER PHE VAL          
SEQRES  11 B  394  GLU ASP ALA GLU GLY LEU ARG ASP ALA GLN ILE VAL VAL          
SEQRES  12 B  394  GLY THR PRO GLY ARG VAL PHE ASP ASN ILE GLN ARG ARG          
SEQRES  13 B  394  ARG PHE ARG THR ASP LYS ILE LYS MSE PHE ILE LEU ASP          
SEQRES  14 B  394  GLU ALA ASP GLU MSE LEU SER SER GLY PHE LYS GLU GLN          
SEQRES  15 B  394  ILE TYR GLN ILE PHE THR LEU LEU PRO PRO THR THR GLN          
SEQRES  16 B  394  VAL VAL LEU LEU SER ALA THR MSE PRO ASN ASP VAL LEU          
SEQRES  17 B  394  GLU VAL THR THR LYS PHE MSE ARG ASN PRO VAL ARG ILE          
SEQRES  18 B  394  LEU VAL LYS LYS ASP GLU LEU THR LEU GLU GLY ILE LYS          
SEQRES  19 B  394  GLN PHE TYR VAL ASN VAL GLU GLU GLU GLU TYR LYS TYR          
SEQRES  20 B  394  GLU CYS LEU THR ASP LEU TYR ASP SER ILE SER VAL THR          
SEQRES  21 B  394  GLN ALA VAL ILE PHE CYS ASN THR ARG ARG LYS VAL GLU          
SEQRES  22 B  394  GLU LEU THR THR LYS LEU ARG ASN ASP LYS PHE THR VAL          
SEQRES  23 B  394  SER ALA ILE TYR SER ASP LEU PRO GLN GLN GLU ARG ASP          
SEQRES  24 B  394  THR ILE MSE LYS GLU PHE ARG SER GLY SER SER ARG ILE          
SEQRES  25 B  394  LEU ILE SER THR ASP LEU LEU ALA ARG GLY ILE ASP VAL          
SEQRES  26 B  394  GLN GLN VAL SER LEU VAL ILE ASN TYR ASP LEU PRO ALA          
SEQRES  27 B  394  ASN LYS GLU ASN TYR ILE HIS ARG ILE GLY ARG GLY GLY          
SEQRES  28 B  394  ARG PHE GLY ARG LYS GLY VAL ALA ILE ASN PHE VAL THR          
SEQRES  29 B  394  ASN GLU ASP VAL GLY ALA MSE ARG GLU LEU GLU LYS PHE          
SEQRES  30 B  394  TYR SER THR GLN ILE GLU GLU LEU PRO SER ASP ILE ALA          
SEQRES  31 B  394  THR LEU LEU ASN                                              
HET    MSE  A  26       8                                                       
HET    MSE  A  53       8                                                       
HET    MSE  A  94       8                                                       
HET    MSE  A 110       8                                                       
HET    MSE  A 116       8                                                       
HET    MSE  A 165       8                                                       
HET    MSE  A 174       8                                                       
HET    MSE  A 203       8                                                       
HET    MSE  A 215       8                                                       
HET    MSE  B  26       8                                                       
HET    MSE  B  53       8                                                       
HET    MSE  B  94       8                                                       
HET    MSE  B 110       8                                                       
HET    MSE  B 116       8                                                       
HET    MSE  B 165       8                                                       
HET    MSE  B 174       8                                                       
HET    MSE  B 203       8                                                       
HET    MSE  B 215       8                                                       
HET    MSE  B 302       8                                                       
HET    MSE  B 371       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    20(C5 H11 N O2 SE)                                           
FORMUL   3  HOH   *146(H2 O)                                                    
CRYST1   38.800   71.200   73.200  94.00  89.60 101.00 P 1           2          
ATOM      1  N   GLN A  11      -5.756 -12.156  11.680  1.00 43.10           N  
ATOM      2  CA  GLN A  11      -4.721 -11.983  12.738  1.00 44.11           C  
ATOM      3  C   GLN A  11      -4.601 -10.535  13.219  1.00 43.20           C  
ATOM      4  O   GLN A  11      -4.777 -10.252  14.403  1.00 43.82           O  
ATOM      5  CB  GLN A  11      -3.355 -12.489  12.241  1.00 46.08           C  
ATOM      6  CG  GLN A  11      -3.180 -12.629  10.710  1.00 49.60           C  
ATOM      7  CD  GLN A  11      -2.834 -11.318   9.991  1.00 51.86           C  
ATOM      8  OE1 GLN A  11      -3.702 -10.475   9.751  1.00 51.35           O  
ATOM      9  NE2 GLN A  11      -1.555 -11.149   9.646  1.00 51.42           N  
ATOM     10  N   ILE A  12      -4.308  -9.624  12.297  1.00 40.84           N  
ATOM     11  CA  ILE A  12      -4.162  -8.211  12.622  1.00 37.73           C  
ATOM     12  C   ILE A  12      -5.440  -7.415  12.362  1.00 36.53           C  
ATOM     13  O   ILE A  12      -6.220  -7.731  11.461  1.00 36.39           O  
ATOM     14  CB  ILE A  12      -3.028  -7.560  11.794  1.00 37.99           C  
ATOM     15  CG1 ILE A  12      -1.692  -8.250  12.084  1.00 37.57           C  
ATOM     16  CG2 ILE A  12      -2.937  -6.067  12.109  1.00 37.96           C  
ATOM     17  CD1 ILE A  12      -1.211  -8.106  13.511  1.00 37.81           C  
ATOM     18  N   GLN A  13      -5.642  -6.383  13.169  1.00 33.96           N  
ATOM     19  CA  GLN A  13      -6.783  -5.487  13.046  1.00 32.94           C  
ATOM     20  C   GLN A  13      -6.144  -4.103  12.916  1.00 29.59           C  
ATOM     21  O   GLN A  13      -5.434  -3.658  13.811  1.00 27.27           O  
ATOM     22  CB  GLN A  13      -7.647  -5.571  14.311  1.00 37.58           C  
ATOM     23  CG  GLN A  13      -8.756  -4.527  14.418  1.00 43.67           C  
ATOM     24  CD  GLN A  13      -9.497  -4.586  15.758  1.00 48.34           C  
ATOM     25  OE1 GLN A  13      -9.833  -5.669  16.247  1.00 50.92           O  
ATOM     26  NE2 GLN A  13      -9.766  -3.419  16.345  1.00 48.61           N  
ATOM     27  N   THR A  14      -6.362  -3.429  11.794  1.00 28.25           N  
ATOM     28  CA  THR A  14      -5.764  -2.110  11.613  1.00 27.93           C  
ATOM     29  C   THR A  14      -6.688  -1.109  10.942  1.00 26.45           C  
ATOM     30  O   THR A  14      -7.642  -1.486  10.285  1.00 27.72           O  
ATOM     31  CB  THR A  14      -4.472  -2.190  10.781  1.00 27.64           C  
ATOM     32  OG1 THR A  14      -3.915  -0.878  10.643  1.00 29.48           O  
ATOM     33  CG2 THR A  14      -4.758  -2.750   9.400  1.00 26.96           C  
ATOM     34  N   ASN A  15      -6.389   0.171  11.120  1.00 25.53           N  
ATOM     35  CA  ASN A  15      -7.166   1.234  10.516  1.00 24.82           C  
ATOM     36  C   ASN A  15      -6.339   1.919   9.436  1.00 26.72           C  
ATOM     37  O   ASN A  15      -6.698   2.998   8.950  1.00 25.97           O  
ATOM     38  CB  ASN A  15      -7.587   2.262  11.569  1.00 23.94           C  
ATOM     39  CG  ASN A  15      -6.401   2.929  12.261  1.00 25.37           C  
ATOM     40  OD1 ASN A  15      -5.233   2.661  11.949  1.00 24.45           O  
ATOM     41  ND2 ASN A  15      -6.702   3.807  13.210  1.00 23.57           N  
ATOM     42  N   TYR A  16      -5.226   1.295   9.063  1.00 27.36           N  
ATOM     43  CA  TYR A  16      -4.367   1.853   8.037  1.00 30.10           C  
ATOM     44  C   TYR A  16      -4.405   0.993   6.772  1.00 35.15           C  
ATOM     45  O   TYR A  16      -4.320   1.522   5.660  1.00 38.28           O  
ATOM     46  CB  TYR A  16      -2.936   1.973   8.557  1.00 27.83           C  
ATOM     47  CG  TYR A  16      -1.953   2.548   7.559  1.00 24.98           C  
ATOM     48  CD1 TYR A  16      -1.958   3.900   7.234  1.00 25.19           C  
ATOM     49  CD2 TYR A  16      -1.015   1.737   6.945  1.00 24.92           C  
ATOM     50  CE1 TYR A  16      -1.047   4.425   6.329  1.00 23.30           C  
ATOM     51  CE2 TYR A  16      -0.103   2.249   6.036  1.00 23.80           C  
ATOM     52  CZ  TYR A  16      -0.118   3.590   5.732  1.00 24.13           C  
ATOM     53  OH  TYR A  16       0.817   4.086   4.848  1.00 22.51           O  
ATOM     54  N   ASP A  17      -4.552  -0.321   6.938  1.00 38.07           N  
ATOM     55  CA  ASP A  17      -4.612  -1.257   5.801  1.00 42.20           C  
ATOM     56  C   ASP A  17      -4.030  -0.711   4.520  1.00 42.65           C  
ATOM     57  O   ASP A  17      -4.702  -0.047   3.734  1.00 43.90           O  
ATOM     58  CB  ASP A  17      -6.045  -1.739   5.525  1.00 44.47           C  
ATOM     59  CG  ASP A  17      -6.321  -3.128   6.123  1.00 48.15           C  
ATOM     60  OD1 ASP A  17      -5.546  -4.079   5.811  1.00 46.08           O  
ATOM     61  OD2 ASP A  17      -7.303  -3.261   6.904  1.00 44.82           O  
ATOM     62  N   LYS A  18      -2.756  -1.021   4.349  1.00 42.77           N  
ATOM     63  CA  LYS A  18      -1.921  -0.630   3.226  1.00 40.43           C  
ATOM     64  C   LYS A  18      -0.719  -1.453   3.624  1.00 37.61           C  
ATOM     65  O   LYS A  18      -0.075  -1.168   4.626  1.00 38.44           O  
ATOM     66  CB  LYS A  18      -1.606   0.864   3.293  1.00 41.99           C  
ATOM     67  CG  LYS A  18      -0.721   1.398   2.174  1.00 43.51           C  
ATOM     68  CD  LYS A  18       0.710   0.896   2.290  1.00 45.36           C  
ATOM     69  CE  LYS A  18       1.679   1.787   1.525  1.00 45.16           C  
ATOM     70  NZ  LYS A  18       1.721   3.170   2.085  1.00 44.27           N  
ATOM     71  N   VAL A  19      -0.451  -2.500   2.867  1.00 34.80           N  
ATOM     72  CA  VAL A  19       0.634  -3.406   3.181  1.00 31.54           C  
ATOM     73  C   VAL A  19       1.713  -3.392   2.106  1.00 30.32           C  
ATOM     74  O   VAL A  19       1.445  -3.102   0.941  1.00 30.96           O  
ATOM     75  CB  VAL A  19       0.067  -4.840   3.345  1.00 31.32           C  
ATOM     76  CG1 VAL A  19       1.157  -5.826   3.712  1.00 29.44           C  
ATOM     77  CG2 VAL A  19      -1.021  -4.823   4.386  1.00 30.31           C  
ATOM     78  N   VAL A  20       2.937  -3.700   2.515  1.00 25.99           N  
ATOM     79  CA  VAL A  20       4.062  -3.735   1.607  1.00 23.34           C  
ATOM     80  C   VAL A  20       4.748  -5.052   1.903  1.00 24.59           C  
ATOM     81  O   VAL A  20       5.025  -5.365   3.061  1.00 24.08           O  
ATOM     82  CB  VAL A  20       4.999  -2.550   1.865  1.00 20.98           C  
ATOM     83  CG1 VAL A  20       6.150  -2.562   0.870  1.00 19.07           C  
ATOM     84  CG2 VAL A  20       4.215  -1.255   1.755  1.00 18.57           C  
ATOM     85  N   TYR A  21       5.023  -5.823   0.857  1.00 23.88           N  
ATOM     86  CA  TYR A  21       5.613  -7.135   1.041  1.00 25.29           C  
ATOM     87  C   TYR A  21       7.115  -7.302   0.865  1.00 24.69           C  
ATOM     88  O   TYR A  21       7.658  -8.336   1.227  1.00 24.72           O  
ATOM     89  CB  TYR A  21       4.900  -8.134   0.137  1.00 26.07           C  
ATOM     90  CG  TYR A  21       3.427  -8.236   0.406  1.00 28.27           C  
ATOM     91  CD1 TYR A  21       2.507  -7.546  -0.377  1.00 28.14           C  
ATOM     92  CD2 TYR A  21       2.949  -9.029   1.446  1.00 31.35           C  
ATOM     93  CE1 TYR A  21       1.141  -7.647  -0.136  1.00 28.74           C  
ATOM     94  CE2 TYR A  21       1.585  -9.139   1.700  1.00 31.28           C  
ATOM     95  CZ  TYR A  21       0.689  -8.445   0.901  1.00 31.21           C  
ATOM     96  OH  TYR A  21      -0.660  -8.564   1.138  1.00 34.98           O  
ATOM     97  N   LYS A  22       7.786  -6.309   0.306  1.00 25.85           N  
ATOM     98  CA  LYS A  22       9.229  -6.406   0.098  1.00 27.13           C  
ATOM     99  C   LYS A  22       9.842  -5.097   0.547  1.00 25.72           C  
ATOM    100  O   LYS A  22       9.173  -4.072   0.541  1.00 28.08           O  
ATOM    101  CB  LYS A  22       9.548  -6.621  -1.394  1.00 30.79           C  
ATOM    102  CG  LYS A  22       8.863  -7.808  -2.046  1.00 31.56           C  
ATOM    103  CD  LYS A  22       9.357  -9.125  -1.471  1.00 37.92           C  
ATOM    104  CE  LYS A  22       8.590 -10.316  -2.065  1.00 41.24           C  
ATOM    105  NZ  LYS A  22       8.712 -10.403  -3.557  1.00 43.22           N  
ATOM    106  N   PHE A  23      11.109  -5.107   0.929  1.00 24.06           N  
ATOM    107  CA  PHE A  23      11.725  -3.856   1.345  1.00 24.83           C  
ATOM    108  C   PHE A  23      12.034  -2.963   0.134  1.00 25.25           C  
ATOM    109  O   PHE A  23      12.190  -1.752   0.264  1.00 25.35           O  
ATOM    110  CB  PHE A  23      12.988  -4.138   2.152  1.00 22.99           C  
ATOM    111  CG  PHE A  23      12.724  -4.806   3.472  1.00 23.11           C  
ATOM    112  CD1 PHE A  23      13.091  -6.132   3.683  1.00 21.65           C  
ATOM    113  CD2 PHE A  23      12.107  -4.103   4.509  1.00 21.92           C  
ATOM    114  CE1 PHE A  23      12.851  -6.749   4.896  1.00 20.49           C  
ATOM    115  CE2 PHE A  23      11.862  -4.707   5.725  1.00 23.26           C  
ATOM    116  CZ  PHE A  23      12.234  -6.038   5.924  1.00 24.28           C  
ATOM    117  N   ASP A  24      12.105  -3.565  -1.046  1.00 25.44           N  
ATOM    118  CA  ASP A  24      12.376  -2.812  -2.271  1.00 28.98           C  
ATOM    119  C   ASP A  24      11.247  -1.815  -2.528  1.00 29.54           C  
ATOM    120  O   ASP A  24      11.471  -0.716  -3.050  1.00 26.53           O  
ATOM    121  CB  ASP A  24      12.440  -3.752  -3.477  1.00 31.85           C  
ATOM    122  CG  ASP A  24      13.186  -5.033  -3.181  1.00 38.03           C  
ATOM    123  OD1 ASP A  24      12.834  -5.725  -2.189  1.00 40.35           O  
ATOM    124  OD2 ASP A  24      14.119  -5.352  -3.951  1.00 39.54           O  
ATOM    125  N   ASP A  25      10.033  -2.221  -2.157  1.00 30.97           N  
ATOM    126  CA  ASP A  25       8.842  -1.416  -2.377  1.00 30.78           C  
ATOM    127  C   ASP A  25       8.595  -0.350  -1.338  1.00 30.53           C  
ATOM    128  O   ASP A  25       7.557   0.316  -1.382  1.00 31.59           O  
ATOM    129  CB  ASP A  25       7.611  -2.316  -2.456  1.00 34.22           C  
ATOM    130  CG  ASP A  25       7.737  -3.384  -3.529  1.00 39.64           C  
ATOM    131  OD1 ASP A  25       7.998  -3.032  -4.705  1.00 41.78           O  
ATOM    132  OD2 ASP A  25       7.569  -4.579  -3.194  1.00 42.19           O  
HETATM  133  N   MSE A  26       9.535  -0.168  -0.413  1.00 29.38           N  
HETATM  134  CA  MSE A  26       9.334   0.818   0.644  1.00 26.90           C  
HETATM  135  C   MSE A  26       9.980   2.173   0.440  1.00 25.46           C  
HETATM  136  O   MSE A  26       9.806   3.066   1.255  1.00 23.45           O  
HETATM  137  CB  MSE A  26       9.761   0.236   1.985  1.00 26.09           C  
HETATM  138  CG  MSE A  26       8.810  -0.818   2.508  1.00 26.20           C  
HETATM  139 SE   MSE A  26       9.391  -1.472   4.214  1.00 28.58          SE  
HETATM  140  CE  MSE A  26       8.727  -3.265   4.171  1.00 26.15           C  
ATOM    141  N   GLU A  27      10.714   2.334  -0.649  1.00 25.72           N  
ATOM    142  CA  GLU A  27      11.361   3.604  -0.935  1.00 28.38           C  
ATOM    143  C   GLU A  27      12.369   4.037   0.126  1.00 28.16           C  
ATOM    144  O   GLU A  27      12.396   5.197   0.547  1.00 27.00           O  
ATOM    145  CB  GLU A  27      10.297   4.687  -1.151  1.00 31.03           C  
ATOM    146  CG  GLU A  27       9.462   4.398  -2.401  1.00 39.04           C  
ATOM    147  CD  GLU A  27       8.282   5.330  -2.601  1.00 42.97           C  
ATOM    148  OE1 GLU A  27       7.480   5.047  -3.518  1.00 44.53           O  
ATOM    149  OE2 GLU A  27       8.153   6.333  -1.860  1.00 45.13           O  
ATOM    150  N   LEU A  28      13.212   3.095   0.536  1.00 26.95           N  
ATOM    151  CA  LEU A  28      14.241   3.378   1.521  1.00 26.86           C  
ATOM    152  C   LEU A  28      15.470   3.911   0.811  1.00 26.49           C  
ATOM    153  O   LEU A  28      15.752   3.528  -0.316  1.00 25.75           O  
ATOM    154  CB  LEU A  28      14.655   2.105   2.277  1.00 25.29           C  
ATOM    155  CG  LEU A  28      13.698   1.311   3.162  1.00 24.11           C  
ATOM    156  CD1 LEU A  28      12.771   2.257   3.882  1.00 24.64           C  
ATOM    157  CD2 LEU A  28      12.919   0.358   2.339  1.00 23.72           C  
ATOM    158  N   ASP A  29      16.195   4.800   1.477  1.00 29.12           N  
ATOM    159  CA  ASP A  29      17.439   5.348   0.946  1.00 30.12           C  
ATOM    160  C   ASP A  29      18.276   4.101   0.635  1.00 29.01           C  
ATOM    161  O   ASP A  29      18.234   3.131   1.389  1.00 27.48           O  
ATOM    162  CB  ASP A  29      18.080   6.243   2.024  1.00 34.97           C  
ATOM    163  CG  ASP A  29      19.586   6.416   1.860  1.00 40.16           C  
ATOM    164  OD1 ASP A  29      20.055   6.691   0.729  1.00 45.36           O  
ATOM    165  OD2 ASP A  29      20.303   6.297   2.881  1.00 41.07           O  
ATOM    166  N   GLU A  30      19.003   4.110  -0.483  1.00 28.50           N  
ATOM    167  CA  GLU A  30      19.800   2.949  -0.889  1.00 27.63           C  
ATOM    168  C   GLU A  30      20.736   2.366   0.175  1.00 24.57           C  
ATOM    169  O   GLU A  30      20.822   1.142   0.339  1.00 19.14           O  
ATOM    170  CB  GLU A  30      20.581   3.259  -2.177  1.00 31.58           C  
ATOM    171  CG  GLU A  30      21.353   4.566  -2.188  1.00 37.94           C  
ATOM    172  CD  GLU A  30      22.285   4.678  -3.396  1.00 41.99           C  
ATOM    173  OE1 GLU A  30      22.620   5.822  -3.796  1.00 42.01           O  
ATOM    174  OE2 GLU A  30      22.690   3.622  -3.937  1.00 42.48           O  
ATOM    175  N   ASN A  31      21.429   3.234   0.901  1.00 23.53           N  
ATOM    176  CA  ASN A  31      22.322   2.758   1.947  1.00 24.60           C  
ATOM    177  C   ASN A  31      21.570   2.047   3.069  1.00 23.26           C  
ATOM    178  O   ASN A  31      22.016   1.000   3.558  1.00 25.11           O  
ATOM    179  CB  ASN A  31      23.157   3.907   2.509  1.00 26.61           C  
ATOM    180  CG  ASN A  31      24.213   4.373   1.533  1.00 27.27           C  
ATOM    181  OD1 ASN A  31      24.780   3.577   0.787  1.00 25.66           O  
ATOM    182  ND2 ASN A  31      24.494   5.665   1.540  1.00 30.52           N  
ATOM    183  N   LEU A  32      20.440   2.607   3.488  1.00 19.91           N  
ATOM    184  CA  LEU A  32      19.646   1.953   4.523  1.00 20.57           C  
ATOM    185  C   LEU A  32      19.205   0.559   4.037  1.00 19.27           C  
ATOM    186  O   LEU A  32      19.307  -0.417   4.776  1.00 17.65           O  
ATOM    187  CB  LEU A  32      18.412   2.790   4.880  1.00 18.43           C  
ATOM    188  CG  LEU A  32      17.379   2.050   5.742  1.00 20.93           C  
ATOM    189  CD1 LEU A  32      17.990   1.696   7.093  1.00 18.12           C  
ATOM    190  CD2 LEU A  32      16.128   2.912   5.918  1.00 19.05           C  
ATOM    191  N   LEU A  33      18.729   0.476   2.795  1.00 19.28           N  
ATOM    192  CA  LEU A  33      18.283  -0.795   2.221  1.00 22.06           C  
ATOM    193  C   LEU A  33      19.429  -1.803   2.176  1.00 24.39           C  
ATOM    194  O   LEU A  33      19.239  -2.992   2.441  1.00 25.05           O  
ATOM    195  CB  LEU A  33      17.742  -0.580   0.814  1.00 22.06           C  
ATOM    196  CG  LEU A  33      17.262  -1.857   0.120  1.00 24.99           C  
ATOM    197  CD1 LEU A  33      16.041  -2.405   0.864  1.00 25.01           C  
ATOM    198  CD2 LEU A  33      16.917  -1.562  -1.343  1.00 22.19           C  
ATOM    199  N   ARG A  34      20.617  -1.325   1.831  1.00 24.57           N  
ATOM    200  CA  ARG A  34      21.796  -2.180   1.792  1.00 26.91           C  
ATOM    201  C   ARG A  34      21.944  -2.688   3.231  1.00 24.58           C  
ATOM    202  O   ARG A  34      22.244  -3.862   3.472  1.00 25.16           O  
ATOM    203  CB  ARG A  34      23.021  -1.346   1.396  1.00 32.02           C  
ATOM    204  CG  ARG A  34      24.164  -2.096   0.722  1.00 38.39           C  
ATOM    205  CD  ARG A  34      23.839  -2.451  -0.739  1.00 45.05           C  
ATOM    206  NE  ARG A  34      23.356  -3.826  -0.909  1.00 47.29           N  
ATOM    207  CZ  ARG A  34      22.120  -4.168  -1.267  1.00 46.13           C  
ATOM    208  NH1 ARG A  34      21.814  -5.459  -1.384  1.00 45.84           N  
ATOM    209  NH2 ARG A  34      21.195  -3.238  -1.509  1.00 42.35           N  
ATOM    210  N   GLY A  35      21.712  -1.785   4.182  1.00 22.44           N  
ATOM    211  CA  GLY A  35      21.806  -2.139   5.589  1.00 19.88           C  
ATOM    212  C   GLY A  35      20.764  -3.154   6.039  1.00 16.70           C  
ATOM    213  O   GLY A  35      21.061  -4.020   6.853  1.00 16.30           O  
ATOM    214  N   VAL A  36      19.547  -3.040   5.516  1.00 14.65           N  
ATOM    215  CA  VAL A  36      18.471  -3.959   5.854  1.00 15.34           C  
ATOM    216  C   VAL A  36      18.851  -5.391   5.426  1.00 16.73           C  
ATOM    217  O   VAL A  36      18.932  -6.290   6.253  1.00 14.91           O  
ATOM    218  CB  VAL A  36      17.149  -3.518   5.162  1.00 15.55           C  
ATOM    219  CG1 VAL A  36      16.032  -4.509   5.460  1.00 14.40           C  
ATOM    220  CG2 VAL A  36      16.746  -2.133   5.644  1.00 12.85           C  
ATOM    221  N   PHE A  37      19.099  -5.599   4.132  1.00 20.40           N  
ATOM    222  CA  PHE A  37      19.501  -6.923   3.641  1.00 21.19           C  
ATOM    223  C   PHE A  37      20.814  -7.301   4.316  1.00 22.25           C  
ATOM    224  O   PHE A  37      21.013  -8.448   4.721  1.00 22.76           O  
ATOM    225  CB  PHE A  37      19.712  -6.918   2.125  1.00 20.12           C  
ATOM    226  CG  PHE A  37      18.474  -6.601   1.340  1.00 22.35           C  
ATOM    227  CD1 PHE A  37      17.265  -7.236   1.629  1.00 23.27           C  
ATOM    228  CD2 PHE A  37      18.514  -5.666   0.311  1.00 20.97           C  
ATOM    229  CE1 PHE A  37      16.113  -6.936   0.900  1.00 23.16           C  
ATOM    230  CE2 PHE A  37      17.375  -5.359  -0.420  1.00 21.37           C  
ATOM    231  CZ  PHE A  37      16.168  -5.996  -0.125  1.00 23.42           C  
ATOM    232  N   GLY A  38      21.709  -6.326   4.437  1.00 21.52           N  
ATOM    233  CA  GLY A  38      22.982  -6.598   5.068  1.00 21.37           C  
ATOM    234  C   GLY A  38      22.854  -7.185   6.456  1.00 22.34           C  
ATOM    235  O   GLY A  38      23.677  -8.000   6.852  1.00 22.58           O  
ATOM    236  N   TYR A  39      21.821  -6.778   7.195  1.00 23.73           N  
ATOM    237  CA  TYR A  39      21.605  -7.252   8.563  1.00 25.05           C  
ATOM    238  C   TYR A  39      21.031  -8.668   8.672  1.00 26.32           C  
ATOM    239  O   TYR A  39      21.044  -9.269   9.750  1.00 25.72           O  
ATOM    240  CB  TYR A  39      20.702  -6.262   9.310  1.00 25.70           C  
ATOM    241  CG  TYR A  39      20.431  -6.603  10.763  1.00 24.78           C  
ATOM    242  CD1 TYR A  39      19.214  -7.156  11.153  1.00 25.20           C  
ATOM    243  CD2 TYR A  39      21.396  -6.377  11.746  1.00 25.81           C  
ATOM    244  CE1 TYR A  39      18.963  -7.474  12.479  1.00 24.75           C  
ATOM    245  CE2 TYR A  39      21.155  -6.691  13.082  1.00 24.82           C  
ATOM    246  CZ  TYR A  39      19.939  -7.239  13.439  1.00 27.10           C  
ATOM    247  OH  TYR A  39      19.695  -7.564  14.757  1.00 31.49           O  
ATOM    248  N   GLY A  40      20.537  -9.204   7.561  1.00 27.63           N  
ATOM    249  CA  GLY A  40      19.974 -10.542   7.586  1.00 28.68           C  
ATOM    250  C   GLY A  40      18.485 -10.533   7.309  1.00 31.42           C  
ATOM    251  O   GLY A  40      17.868 -11.588   7.151  1.00 32.45           O  
ATOM    252  N   PHE A  41      17.896  -9.342   7.263  1.00 31.39           N  
ATOM    253  CA  PHE A  41      16.477  -9.220   6.983  1.00 31.60           C  
ATOM    254  C   PHE A  41      16.261  -9.630   5.540  1.00 33.46           C  
ATOM    255  O   PHE A  41      16.988  -9.194   4.648  1.00 35.22           O  
ATOM    256  CB  PHE A  41      16.007  -7.783   7.168  1.00 29.39           C  
ATOM    257  CG  PHE A  41      15.694  -7.420   8.589  1.00 28.43           C  
ATOM    258  CD1 PHE A  41      16.267  -6.297   9.173  1.00 28.02           C  
ATOM    259  CD2 PHE A  41      14.805  -8.183   9.336  1.00 27.05           C  
ATOM    260  CE1 PHE A  41      15.954  -5.940  10.482  1.00 28.62           C  
ATOM    261  CE2 PHE A  41      14.486  -7.837  10.640  1.00 26.05           C  
ATOM    262  CZ  PHE A  41      15.061  -6.714  11.216  1.00 28.40           C  
ATOM    263  N   GLU A  42      15.268 -10.474   5.308  1.00 34.39           N  
ATOM    264  CA  GLU A  42      14.992 -10.912   3.956  1.00 35.48           C  
ATOM    265  C   GLU A  42      13.677 -10.296   3.482  1.00 35.75           C  
ATOM    266  O   GLU A  42      13.674  -9.426   2.617  1.00 37.09           O  
ATOM    267  CB  GLU A  42      14.949 -12.439   3.901  1.00 35.10           C  
ATOM    268  CG  GLU A  42      15.510 -12.990   2.607  1.00 40.42           C  
ATOM    269  CD  GLU A  42      17.024 -12.827   2.483  1.00 41.85           C  
ATOM    270  OE1 GLU A  42      17.504 -12.613   1.347  1.00 44.15           O  
ATOM    271  OE2 GLU A  42      17.735 -12.928   3.507  1.00 42.62           O  
ATOM    272  N   GLU A  43      12.562 -10.733   4.047  1.00 36.16           N  
ATOM    273  CA  GLU A  43      11.271 -10.173   3.670  1.00 35.96           C  
ATOM    274  C   GLU A  43      10.564  -9.663   4.922  1.00 33.84           C  
ATOM    275  O   GLU A  43      10.682 -10.241   6.001  1.00 33.86           O  
ATOM    276  CB  GLU A  43      10.393 -11.220   2.961  1.00 40.10           C  
ATOM    277  CG  GLU A  43       9.796 -12.290   3.874  1.00 44.14           C  
ATOM    278  CD  GLU A  43      10.838 -13.227   4.452  1.00 47.92           C  
ATOM    279  OE1 GLU A  43      10.505 -13.973   5.397  1.00 51.50           O  
ATOM    280  OE2 GLU A  43      11.989 -13.229   3.961  1.00 48.88           O  
ATOM    281  N   PRO A  44       9.817  -8.568   4.789  1.00 31.25           N  
ATOM    282  CA  PRO A  44       9.089  -7.981   5.913  1.00 31.24           C  
ATOM    283  C   PRO A  44       8.190  -8.990   6.637  1.00 31.11           C  
ATOM    284  O   PRO A  44       7.475  -9.760   5.998  1.00 32.80           O  
ATOM    285  CB  PRO A  44       8.267  -6.874   5.252  1.00 29.79           C  
ATOM    286  CG  PRO A  44       9.062  -6.510   4.065  1.00 30.21           C  
ATOM    287  CD  PRO A  44       9.564  -7.825   3.546  1.00 29.90           C  
ATOM    288  N   SER A  45       8.232  -8.984   7.967  1.00 30.61           N  
ATOM    289  CA  SER A  45       7.382  -9.866   8.760  1.00 29.73           C  
ATOM    290  C   SER A  45       6.022  -9.175   8.818  1.00 28.70           C  
ATOM    291  O   SER A  45       5.896  -8.030   8.387  1.00 28.77           O  
ATOM    292  CB  SER A  45       7.947 -10.033  10.167  1.00 29.12           C  
ATOM    293  OG  SER A  45       8.016  -8.782  10.824  1.00 33.91           O  
ATOM    294  N   ALA A  46       5.011  -9.850   9.353  1.00 27.52           N  
ATOM    295  CA  ALA A  46       3.667  -9.275   9.415  1.00 26.24           C  
ATOM    296  C   ALA A  46       3.585  -7.828   9.910  1.00 26.06           C  
ATOM    297  O   ALA A  46       2.921  -6.992   9.285  1.00 25.53           O  
ATOM    298  CB  ALA A  46       2.762 -10.162  10.258  1.00 26.77           C  
ATOM    299  N   ILE A  47       4.240  -7.523  11.026  1.00 25.60           N  
ATOM    300  CA  ILE A  47       4.197  -6.157  11.554  1.00 25.32           C  
ATOM    301  C   ILE A  47       5.019  -5.188  10.701  1.00 24.30           C  
ATOM    302  O   ILE A  47       4.618  -4.044  10.505  1.00 25.13           O  
ATOM    303  CB  ILE A  47       4.674  -6.089  13.041  1.00 25.67           C  
ATOM    304  CG1 ILE A  47       3.719  -6.890  13.932  1.00 26.92           C  
ATOM    305  CG2 ILE A  47       4.711  -4.638  13.530  1.00 24.42           C  
ATOM    306  CD1 ILE A  47       2.254  -6.445  13.864  1.00 24.62           C  
ATOM    307  N   GLN A  48       6.155  -5.639  10.183  1.00 23.21           N  
ATOM    308  CA  GLN A  48       6.978  -4.775   9.343  1.00 23.07           C  
ATOM    309  C   GLN A  48       6.228  -4.401   8.073  1.00 23.29           C  
ATOM    310  O   GLN A  48       6.341  -3.273   7.581  1.00 23.80           O  
ATOM    311  CB  GLN A  48       8.280  -5.469   8.971  1.00 24.29           C  
ATOM    312  CG  GLN A  48       9.096  -5.926  10.155  1.00 23.48           C  
ATOM    313  CD  GLN A  48      10.476  -6.354   9.742  1.00 26.37           C  
ATOM    314  OE1 GLN A  48      10.642  -7.232   8.893  1.00 25.79           O  
ATOM    315  NE2 GLN A  48      11.485  -5.728  10.331  1.00 27.74           N  
ATOM    316  N   GLN A  49       5.458  -5.351   7.547  1.00 22.84           N  
ATOM    317  CA  GLN A  49       4.671  -5.127   6.339  1.00 23.05           C  
ATOM    318  C   GLN A  49       3.611  -4.058   6.550  1.00 22.21           C  
ATOM    319  O   GLN A  49       3.130  -3.456   5.587  1.00 19.81           O  
ATOM    320  CB  GLN A  49       3.991  -6.428   5.893  1.00 24.13           C  
ATOM    321  CG  GLN A  49       4.978  -7.567   5.675  1.00 28.53           C  
ATOM    322  CD  GLN A  49       4.322  -8.883   5.310  1.00 28.80           C  
ATOM    323  OE1 GLN A  49       3.375  -9.326   5.956  1.00 30.65           O  
ATOM    324  NE2 GLN A  49       4.837  -9.523   4.276  1.00 33.80           N  
ATOM    325  N   ARG A  50       3.256  -3.802   7.805  1.00 23.39           N  
ATOM    326  CA  ARG A  50       2.225  -2.806   8.078  1.00 24.63           C  
ATOM    327  C   ARG A  50       2.651  -1.576   8.831  1.00 24.43           C  
ATOM    328  O   ARG A  50       2.075  -0.503   8.667  1.00 24.94           O  
ATOM    329  CB  ARG A  50       1.091  -3.440   8.859  1.00 26.72           C  
ATOM    330  CG  ARG A  50      -0.268  -2.955   8.421  1.00 32.51           C  
ATOM    331  CD  ARG A  50      -1.225  -4.087   8.587  1.00 36.82           C  
ATOM    332  NE  ARG A  50      -0.517  -5.355   8.436  1.00 35.08           N  
ATOM    333  CZ  ARG A  50      -1.101  -6.477   8.038  1.00 37.40           C  
ATOM    334  NH1 ARG A  50      -2.402  -6.472   7.758  1.00 32.63           N  
ATOM    335  NH2 ARG A  50      -0.380  -7.589   7.905  1.00 36.49           N  
ATOM    336  N   ALA A  51       3.667  -1.732   9.661  1.00 23.59           N  
ATOM    337  CA  ALA A  51       4.096  -0.649  10.497  1.00 21.57           C  
ATOM    338  C   ALA A  51       5.122   0.310   9.920  1.00 22.53           C  
ATOM    339  O   ALA A  51       5.046   1.508  10.184  1.00 23.07           O  
ATOM    340  CB  ALA A  51       4.588  -1.220  11.816  1.00 20.75           C  
ATOM    341  N   ILE A  52       6.071  -0.187   9.132  1.00 20.64           N  
ATOM    342  CA  ILE A  52       7.108   0.696   8.600  1.00 18.42           C  
ATOM    343  C   ILE A  52       6.618   1.924   7.838  1.00 19.34           C  
ATOM    344  O   ILE A  52       6.941   3.061   8.216  1.00 21.45           O  
ATOM    345  CB  ILE A  52       8.104  -0.061   7.700  1.00 16.75           C  
ATOM    346  CG1 ILE A  52       8.765  -1.179   8.498  1.00 14.81           C  
ATOM    347  CG2 ILE A  52       9.159   0.906   7.174  1.00 14.84           C  
ATOM    348  CD1 ILE A  52       9.901  -1.827   7.797  1.00 15.14           C  
HETATM  349  N   MSE A  53       5.842   1.708   6.779  1.00 16.27           N  
HETATM  350  CA  MSE A  53       5.357   2.823   5.976  1.00 16.42           C  
HETATM  351  C   MSE A  53       4.589   3.902   6.751  1.00 16.59           C  
HETATM  352  O   MSE A  53       4.852   5.090   6.568  1.00 15.21           O  
HETATM  353  CB  MSE A  53       4.536   2.304   4.793  1.00 17.45           C  
HETATM  354  CG  MSE A  53       5.355   1.474   3.795  1.00 21.30           C  
HETATM  355 SE   MSE A  53       7.064   2.294   3.275  1.00 26.82          SE  
HETATM  356  CE  MSE A  53       6.397   3.991   2.617  1.00 20.61           C  
ATOM    357  N   PRO A  54       3.634   3.516   7.621  1.00 16.27           N  
ATOM    358  CA  PRO A  54       2.966   4.620   8.316  1.00 16.26           C  
ATOM    359  C   PRO A  54       3.938   5.414   9.178  1.00 15.32           C  
ATOM    360  O   PRO A  54       3.867   6.639   9.230  1.00 14.82           O  
ATOM    361  CB  PRO A  54       1.854   3.927   9.121  1.00 15.14           C  
ATOM    362  CG  PRO A  54       2.288   2.501   9.203  1.00 15.99           C  
ATOM    363  CD  PRO A  54       2.930   2.246   7.862  1.00 15.27           C  
ATOM    364  N   ILE A  55       4.855   4.727   9.847  1.00 15.23           N  
ATOM    365  CA  ILE A  55       5.826   5.442  10.669  1.00 15.84           C  
ATOM    366  C   ILE A  55       6.603   6.425   9.772  1.00 15.16           C  
ATOM    367  O   ILE A  55       6.653   7.622  10.044  1.00 13.13           O  
ATOM    368  CB  ILE A  55       6.800   4.470  11.377  1.00 14.35           C  
ATOM    369  CG1 ILE A  55       6.016   3.534  12.296  1.00 12.46           C  
ATOM    370  CG2 ILE A  55       7.822   5.250  12.210  1.00 11.75           C  
ATOM    371  CD1 ILE A  55       6.889   2.667  13.172  1.00  8.95           C  
ATOM    372  N   ILE A  56       7.180   5.920   8.689  1.00 15.75           N  
ATOM    373  CA  ILE A  56       7.913   6.777   7.767  1.00 17.25           C  
ATOM    374  C   ILE A  56       7.062   7.957   7.286  1.00 19.89           C  
ATOM    375  O   ILE A  56       7.537   9.089   7.228  1.00 22.06           O  
ATOM    376  CB  ILE A  56       8.385   5.996   6.524  1.00 15.84           C  
ATOM    377  CG1 ILE A  56       9.581   5.118   6.885  1.00 11.92           C  
ATOM    378  CG2 ILE A  56       8.735   6.969   5.392  1.00 14.36           C  
ATOM    379  CD1 ILE A  56      10.065   4.259   5.731  1.00 10.82           C  
ATOM    380  N   GLU A  57       5.806   7.685   6.945  1.00 20.39           N  
ATOM    381  CA  GLU A  57       4.891   8.710   6.453  1.00 20.44           C  
ATOM    382  C   GLU A  57       4.562   9.809   7.443  1.00 19.37           C  
ATOM    383  O   GLU A  57       4.015  10.842   7.061  1.00 20.62           O  
ATOM    384  CB  GLU A  57       3.601   8.056   5.963  1.00 23.12           C  
ATOM    385  CG  GLU A  57       3.659   7.609   4.524  1.00 28.51           C  
ATOM    386  CD  GLU A  57       2.777   6.411   4.254  1.00 33.24           C  
ATOM    387  OE1 GLU A  57       1.709   6.295   4.900  1.00 34.41           O  
ATOM    388  OE2 GLU A  57       3.155   5.592   3.386  1.00 35.64           O  
ATOM    389  N   GLY A  58       4.871   9.583   8.715  1.00 19.62           N  
ATOM    390  CA  GLY A  58       4.624  10.598   9.726  1.00 17.94           C  
ATOM    391  C   GLY A  58       3.482  10.397  10.698  1.00 17.62           C  
ATOM    392  O   GLY A  58       3.291  11.216  11.599  1.00 16.65           O  
ATOM    393  N   HIS A  59       2.710   9.329  10.537  1.00 18.46           N  
ATOM    394  CA  HIS A  59       1.586   9.088  11.446  1.00 19.57           C  
ATOM    395  C   HIS A  59       1.974   8.663  12.865  1.00 20.17           C  
ATOM    396  O   HIS A  59       2.961   7.951  13.048  1.00 22.09           O  
ATOM    397  CB  HIS A  59       0.684   7.990  10.904  1.00 19.47           C  
ATOM    398  CG  HIS A  59       0.052   8.302   9.586  1.00 22.09           C  
ATOM    399  ND1 HIS A  59       0.683   8.074   8.384  1.00 24.86           N  
ATOM    400  CD2 HIS A  59      -1.178   8.773   9.280  1.00 22.01           C  
ATOM    401  CE1 HIS A  59      -0.133   8.386   7.393  1.00 21.99           C  
ATOM    402  NE2 HIS A  59      -1.268   8.813   7.911  1.00 22.81           N  
ATOM    403  N   ASP A  60       1.216   9.103  13.869  1.00 18.38           N  
ATOM    404  CA  ASP A  60       1.470   8.619  15.218  1.00 18.74           C  
ATOM    405  C   ASP A  60       1.014   7.174  15.040  1.00 19.32           C  
ATOM    406  O   ASP A  60      -0.042   6.926  14.457  1.00 20.81           O  
ATOM    407  CB  ASP A  60       0.573   9.282  16.262  1.00 18.65           C  
ATOM    408  CG  ASP A  60       1.042  10.666  16.656  1.00 22.01           C  
ATOM    409  OD1 ASP A  60       2.169  11.070  16.267  1.00 21.16           O  
ATOM    410  OD2 ASP A  60       0.274  11.350  17.371  1.00 22.80           O  
ATOM    411  N   VAL A  61       1.798   6.223  15.525  1.00 18.70           N  
ATOM    412  CA  VAL A  61       1.448   4.832  15.355  1.00 16.88           C  
ATOM    413  C   VAL A  61       1.451   4.055  16.653  1.00 17.61           C  
ATOM    414  O   VAL A  61       2.335   4.211  17.495  1.00 17.95           O  
ATOM    415  CB  VAL A  61       2.410   4.158  14.368  1.00 16.93           C  
ATOM    416  CG1 VAL A  61       1.988   2.723  14.121  1.00 18.70           C  
ATOM    417  CG2 VAL A  61       2.429   4.926  13.071  1.00 15.85           C  
ATOM    418  N   LEU A  62       0.424   3.232  16.802  1.00 17.51           N  
ATOM    419  CA  LEU A  62       0.242   2.377  17.958  1.00 16.43           C  
ATOM    420  C   LEU A  62       0.276   0.963  17.368  1.00 15.52           C  
ATOM    421  O   LEU A  62      -0.575   0.597  16.556  1.00 15.07           O  
ATOM    422  CB  LEU A  62      -1.113   2.664  18.607  1.00 18.65           C  
ATOM    423  CG  LEU A  62      -1.621   1.713  19.700  1.00 23.03           C  
ATOM    424  CD1 LEU A  62      -0.827   1.942  20.971  1.00 24.88           C  
ATOM    425  CD2 LEU A  62      -3.097   1.956  19.960  1.00 22.11           C  
ATOM    426  N   ALA A  63       1.278   0.183  17.753  1.00 14.26           N  
ATOM    427  CA  ALA A  63       1.414  -1.170  17.233  1.00 13.61           C  
ATOM    428  C   ALA A  63       1.599  -2.233  18.306  1.00 13.75           C  
ATOM    429  O   ALA A  63       2.457  -2.118  19.191  1.00  8.61           O  
ATOM    430  CB  ALA A  63       2.583  -1.232  16.239  1.00 14.18           C  
ATOM    431  N   GLN A  64       0.774  -3.270  18.210  1.00 15.40           N  
ATOM    432  CA  GLN A  64       0.829  -4.392  19.131  1.00 17.04           C  
ATOM    433  C   GLN A  64       1.824  -5.367  18.543  1.00 19.92           C  
ATOM    434  O   GLN A  64       1.505  -6.081  17.603  1.00 24.53           O  
ATOM    435  CB  GLN A  64      -0.551  -5.043  19.247  1.00 16.39           C  
ATOM    436  CG  GLN A  64      -0.624  -6.235  20.200  1.00 18.92           C  
ATOM    437  CD  GLN A  64      -2.016  -6.439  20.784  1.00 17.25           C  
ATOM    438  OE1 GLN A  64      -3.023  -6.261  20.101  1.00 21.42           O  
ATOM    439  NE2 GLN A  64      -2.074  -6.820  22.047  1.00 14.34           N  
ATOM    440  N   ALA A  65       3.032  -5.395  19.090  1.00 22.71           N  
ATOM    441  CA  ALA A  65       4.074  -6.283  18.591  1.00 22.25           C  
ATOM    442  C   ALA A  65       4.842  -6.935  19.730  1.00 24.68           C  
ATOM    443  O   ALA A  65       5.137  -6.295  20.731  1.00 27.25           O  
ATOM    444  CB  ALA A  65       5.021  -5.505  17.709  1.00 22.27           C  
ATOM    445  N   GLN A  66       5.157  -8.213  19.582  1.00 26.83           N  
ATOM    446  CA  GLN A  66       5.895  -8.930  20.611  1.00 30.07           C  
ATOM    447  C   GLN A  66       7.377  -8.599  20.487  1.00 30.11           C  
ATOM    448  O   GLN A  66       7.825  -8.138  19.437  1.00 29.07           O  
ATOM    449  CB  GLN A  66       5.676 -10.442  20.462  1.00 33.44           C  
ATOM    450  CG  GLN A  66       4.521 -11.001  21.302  1.00 40.28           C  
ATOM    451  CD  GLN A  66       3.164 -10.400  20.951  1.00 45.59           C  
ATOM    452  OE1 GLN A  66       2.235 -10.402  21.773  1.00 47.41           O  
ATOM    453  NE2 GLN A  66       3.034  -9.898  19.722  1.00 47.67           N  
ATOM    454  N   SER A  67       8.134  -8.815  21.563  1.00 29.51           N  
ATOM    455  CA  SER A  67       9.567  -8.547  21.537  1.00 29.44           C  
ATOM    456  C   SER A  67      10.162  -9.330  20.392  1.00 30.30           C  
ATOM    457  O   SER A  67       9.662 -10.395  20.037  1.00 30.24           O  
ATOM    458  CB  SER A  67      10.235  -8.987  22.833  1.00 29.85           C  
ATOM    459  OG  SER A  67       9.820  -8.180  23.915  1.00 33.95           O  
ATOM    460  N   GLY A  68      11.236  -8.807  19.816  1.00 30.87           N  
ATOM    461  CA  GLY A  68      11.859  -9.486  18.703  1.00 31.00           C  
ATOM    462  C   GLY A  68      12.547  -8.538  17.744  1.00 32.46           C  
ATOM    463  O   GLY A  68      12.242  -7.335  17.678  1.00 30.66           O  
ATOM    464  N   THR A  69      13.480  -9.102  16.987  1.00 31.74           N  
ATOM    465  CA  THR A  69      14.253  -8.345  16.030  1.00 31.99           C  
ATOM    466  C   THR A  69      13.311  -7.781  14.962  1.00 30.22           C  
ATOM    467  O   THR A  69      13.590  -6.744  14.365  1.00 31.31           O  
ATOM    468  CB  THR A  69      15.353  -9.243  15.400  1.00 34.56           C  
ATOM    469  OG1 THR A  69      16.498  -8.440  15.077  1.00 38.30           O  
ATOM    470  CG2 THR A  69      14.839  -9.926  14.135  1.00 35.33           C  
ATOM    471  N   GLY A  70      12.187  -8.458  14.748  1.00 26.41           N  
ATOM    472  CA  GLY A  70      11.221  -7.992  13.770  1.00 24.46           C  
ATOM    473  C   GLY A  70      10.598  -6.665  14.166  1.00 23.46           C  
ATOM    474  O   GLY A  70      10.506  -5.742  13.361  1.00 24.02           O  
ATOM    475  N   LYS A  71      10.159  -6.570  15.412  1.00 20.60           N  
ATOM    476  CA  LYS A  71       9.574  -5.341  15.914  1.00 19.54           C  
ATOM    477  C   LYS A  71      10.645  -4.238  15.973  1.00 18.76           C  
ATOM    478  O   LYS A  71      10.421  -3.113  15.531  1.00 17.85           O  
ATOM    479  CB  LYS A  71       8.996  -5.573  17.313  1.00 19.25           C  
ATOM    480  CG  LYS A  71       8.439  -4.326  17.981  1.00 21.63           C  
ATOM    481  CD  LYS A  71       8.147  -4.570  19.453  1.00 22.58           C  
ATOM    482  CE  LYS A  71       9.413  -4.982  20.183  1.00 23.22           C  
ATOM    483  NZ  LYS A  71       9.231  -5.082  21.654  1.00 24.88           N  
ATOM    484  N   THR A  72      11.810  -4.575  16.521  1.00 18.73           N  
ATOM    485  CA  THR A  72      12.904  -3.622  16.646  1.00 16.71           C  
ATOM    486  C   THR A  72      13.254  -3.076  15.276  1.00 16.65           C  
ATOM    487  O   THR A  72      13.364  -1.855  15.085  1.00 15.28           O  
ATOM    488  CB  THR A  72      14.138  -4.289  17.262  1.00 16.48           C  
ATOM    489  OG1 THR A  72      13.785  -4.819  18.542  1.00 18.04           O  
ATOM    490  CG2 THR A  72      15.272  -3.287  17.434  1.00 14.95           C  
ATOM    491  N   GLY A  73      13.423  -3.991  14.326  1.00 15.98           N  
ATOM    492  CA  GLY A  73      13.742  -3.596  12.969  1.00 16.14           C  
ATOM    493  C   GLY A  73      12.716  -2.611  12.445  1.00 15.79           C  
ATOM    494  O   GLY A  73      13.064  -1.687  11.719  1.00 17.03           O  
ATOM    495  N   THR A  74      11.456  -2.808  12.838  1.00 14.26           N  
ATOM    496  CA  THR A  74      10.356  -1.965  12.419  1.00 12.82           C  
ATOM    497  C   THR A  74      10.530  -0.494  12.719  1.00 12.15           C  
ATOM    498  O   THR A  74      10.510   0.324  11.802  1.00 13.28           O  
ATOM    499  CB  THR A  74       9.022  -2.407  13.043  1.00 14.99           C  
ATOM    500  OG1 THR A  74       8.670  -3.699  12.543  1.00 18.56           O  
ATOM    501  CG2 THR A  74       7.906  -1.423  12.682  1.00 15.87           C  
ATOM    502  N   PHE A  75      10.673  -0.127  13.983  1.00 10.65           N  
ATOM    503  CA  PHE A  75      10.827   1.296  14.249  1.00 11.15           C  
ATOM    504  C   PHE A  75      12.246   1.792  13.953  1.00 12.78           C  
ATOM    505  O   PHE A  75      12.456   2.983  13.710  1.00 14.21           O  
ATOM    506  CB  PHE A  75      10.366   1.659  15.671  1.00  5.51           C  
ATOM    507  CG  PHE A  75      11.121   0.961  16.772  1.00  7.50           C  
ATOM    508  CD1 PHE A  75      12.378   1.409  17.175  1.00  6.47           C  
ATOM    509  CD2 PHE A  75      10.567  -0.146  17.418  1.00  4.64           C  
ATOM    510  CE1 PHE A  75      13.072   0.755  18.206  1.00  5.94           C  
ATOM    511  CE2 PHE A  75      11.248  -0.800  18.446  1.00  3.50           C  
ATOM    512  CZ  PHE A  75      12.496  -0.355  18.839  1.00  3.90           C  
ATOM    513  N   SER A  76      13.213   0.875  13.932  1.00 15.01           N  
ATOM    514  CA  SER A  76      14.599   1.243  13.637  1.00 14.97           C  
ATOM    515  C   SER A  76      14.724   1.650  12.170  1.00 16.07           C  
ATOM    516  O   SER A  76      15.265   2.714  11.849  1.00 15.50           O  
ATOM    517  CB  SER A  76      15.536   0.071  13.917  1.00 14.78           C  
ATOM    518  OG  SER A  76      15.476  -0.322  15.283  1.00 17.28           O  
ATOM    519  N   ILE A  77      14.210   0.804  11.279  1.00 14.69           N  
ATOM    520  CA  ILE A  77      14.278   1.103   9.863  1.00 15.06           C  
ATOM    521  C   ILE A  77      13.543   2.411   9.518  1.00 16.12           C  
ATOM    522  O   ILE A  77      14.067   3.258   8.785  1.00 13.92           O  
ATOM    523  CB  ILE A  77      13.718  -0.072   9.033  1.00 12.65           C  
ATOM    524  CG1 ILE A  77      14.704  -1.248   9.077  1.00 14.85           C  
ATOM    525  CG2 ILE A  77      13.526   0.341   7.599  1.00 12.22           C  
ATOM    526  CD1 ILE A  77      14.177  -2.525   8.429  1.00 11.79           C  
ATOM    527  N   ALA A  78      12.346   2.582  10.071  1.00 14.63           N  
ATOM    528  CA  ALA A  78      11.571   3.766   9.799  1.00 15.75           C  
ATOM    529  C   ALA A  78      12.307   4.992  10.300  1.00 17.39           C  
ATOM    530  O   ALA A  78      12.516   5.944   9.553  1.00 18.95           O  
ATOM    531  CB  ALA A  78      10.208   3.659  10.443  1.00 16.98           C  
ATOM    532  N   ALA A  79      12.710   4.965  11.562  1.00 17.66           N  
ATOM    533  CA  ALA A  79      13.436   6.079  12.140  1.00 16.09           C  
ATOM    534  C   ALA A  79      14.683   6.454  11.334  1.00 16.24           C  
ATOM    535  O   ALA A  79      14.991   7.634  11.195  1.00 18.18           O  
ATOM    536  CB  ALA A  79      13.819   5.757  13.568  1.00 14.35           C  
ATOM    537  N   LEU A  80      15.397   5.468  10.798  1.00 17.56           N  
ATOM    538  CA  LEU A  80      16.606   5.760  10.025  1.00 19.99           C  
ATOM    539  C   LEU A  80      16.313   6.481   8.700  1.00 22.58           C  
ATOM    540  O   LEU A  80      17.097   7.328   8.246  1.00 22.88           O  
ATOM    541  CB  LEU A  80      17.391   4.474   9.754  1.00 18.38           C  
ATOM    542  CG  LEU A  80      18.306   3.972  10.880  1.00 18.77           C  
ATOM    543  CD1 LEU A  80      18.785   2.559  10.567  1.00 19.16           C  
ATOM    544  CD2 LEU A  80      19.494   4.909  11.042  1.00 17.57           C  
ATOM    545  N   GLN A  81      15.179   6.142   8.097  1.00 22.15           N  
ATOM    546  CA  GLN A  81      14.751   6.735   6.842  1.00 24.46           C  
ATOM    547  C   GLN A  81      14.396   8.215   7.044  1.00 26.29           C  
ATOM    548  O   GLN A  81      14.615   9.049   6.168  1.00 25.85           O  
ATOM    549  CB  GLN A  81      13.533   5.960   6.317  1.00 24.29           C  
ATOM    550  CG  GLN A  81      12.974   6.405   4.972  1.00 21.95           C  
ATOM    551  CD  GLN A  81      14.005   6.384   3.861  1.00 25.34           C  
ATOM    552  OE1 GLN A  81      14.711   5.391   3.656  1.00 23.45           O  
ATOM    553  NE2 GLN A  81      14.093   7.487   3.128  1.00 26.24           N  
ATOM    554  N   ARG A  82      13.870   8.527   8.220  1.00 27.68           N  
ATOM    555  CA  ARG A  82      13.449   9.875   8.550  1.00 29.17           C  
ATOM    556  C   ARG A  82      14.540  10.818   9.029  1.00 29.97           C  
ATOM    557  O   ARG A  82      14.341  12.035   9.055  1.00 30.37           O  
ATOM    558  CB  ARG A  82      12.357   9.805   9.598  1.00 30.75           C  
ATOM    559  CG  ARG A  82      11.078   9.241   9.066  1.00 35.58           C  
ATOM    560  CD  ARG A  82      10.385  10.245   8.179  1.00 39.26           C  
ATOM    561  NE  ARG A  82       9.043  10.537   8.678  1.00 44.72           N  
ATOM    562  CZ  ARG A  82       8.781  11.117   9.845  1.00 45.97           C  
ATOM    563  NH1 ARG A  82       9.766  11.480  10.657  1.00 46.13           N  
ATOM    564  NH2 ARG A  82       7.524  11.338  10.197  1.00 48.62           N  
ATOM    565  N   ILE A  83      15.683  10.265   9.414  1.00 29.36           N  
ATOM    566  CA  ILE A  83      16.795  11.082   9.891  1.00 29.80           C  
ATOM    567  C   ILE A  83      17.338  11.994   8.791  1.00 30.98           C  
ATOM    568  O   ILE A  83      17.434  11.589   7.632  1.00 30.39           O  
ATOM    569  CB  ILE A  83      17.971  10.197  10.385  1.00 28.83           C  
ATOM    570  CG1 ILE A  83      17.534   9.346  11.580  1.00 28.56           C  
ATOM    571  CG2 ILE A  83      19.158  11.069  10.762  1.00 27.91           C  
ATOM    572  CD1 ILE A  83      17.254  10.144  12.850  1.00 26.10           C  
ATOM    573  N   ASP A  84      17.677  13.228   9.149  1.00 32.56           N  
ATOM    574  CA  ASP A  84      18.267  14.149   8.188  1.00 33.63           C  
ATOM    575  C   ASP A  84      19.763  14.174   8.485  1.00 34.04           C  
ATOM    576  O   ASP A  84      20.187  14.708   9.502  1.00 34.38           O  
ATOM    577  CB  ASP A  84      17.715  15.562   8.344  1.00 34.81           C  
ATOM    578  CG  ASP A  84      18.291  16.526   7.310  1.00 37.01           C  
ATOM    579  OD1 ASP A  84      19.433  16.305   6.842  1.00 34.45           O  
ATOM    580  OD2 ASP A  84      17.603  17.516   6.975  1.00 39.31           O  
ATOM    581  N   THR A  85      20.545  13.585   7.594  1.00 35.82           N  
ATOM    582  CA  THR A  85      22.001  13.508   7.707  1.00 37.19           C  
ATOM    583  C   THR A  85      22.684  14.827   8.067  1.00 37.18           C  
ATOM    584  O   THR A  85      23.584  14.860   8.904  1.00 34.40           O  
ATOM    585  CB  THR A  85      22.598  13.022   6.376  1.00 39.70           C  
ATOM    586  OG1 THR A  85      22.156  11.683   6.126  1.00 44.07           O  
ATOM    587  CG2 THR A  85      24.120  13.081   6.402  1.00 41.87           C  
ATOM    588  N   SER A  86      22.258  15.911   7.418  1.00 38.82           N  
ATOM    589  CA  SER A  86      22.854  17.224   7.643  1.00 38.90           C  
ATOM    590  C   SER A  86      22.672  17.714   9.070  1.00 38.48           C  
ATOM    591  O   SER A  86      23.517  18.440   9.590  1.00 41.67           O  
ATOM    592  CB  SER A  86      22.269  18.256   6.673  1.00 39.56           C  
ATOM    593  OG  SER A  86      21.022  18.751   7.135  1.00 41.87           O  
ATOM    594  N   VAL A  87      21.574  17.336   9.708  1.00 36.10           N  
ATOM    595  CA  VAL A  87      21.361  17.766  11.074  1.00 34.41           C  
ATOM    596  C   VAL A  87      22.134  16.845  12.012  1.00 35.56           C  
ATOM    597  O   VAL A  87      21.982  15.615  11.989  1.00 34.69           O  
ATOM    598  CB  VAL A  87      19.875  17.767  11.433  1.00 33.64           C  
ATOM    599  CG1 VAL A  87      19.680  18.258  12.855  1.00 33.94           C  
ATOM    600  CG2 VAL A  87      19.128  18.657  10.472  1.00 34.39           C  
ATOM    601  N   LYS A  88      22.980  17.461  12.828  1.00 34.94           N  
ATOM    602  CA  LYS A  88      23.814  16.743  13.773  1.00 32.41           C  
ATOM    603  C   LYS A  88      23.331  16.965  15.202  1.00 31.85           C  
ATOM    604  O   LYS A  88      24.113  17.312  16.082  1.00 33.39           O  
ATOM    605  CB  LYS A  88      25.258  17.218  13.629  1.00 33.67           C  
ATOM    606  CG  LYS A  88      25.746  17.313  12.186  1.00 31.11           C  
ATOM    607  CD  LYS A  88      25.822  15.953  11.524  1.00 31.15           C  
ATOM    608  CE  LYS A  88      26.399  16.061  10.114  1.00 32.82           C  
ATOM    609  NZ  LYS A  88      26.448  14.751   9.391  1.00 34.82           N  
ATOM    610  N   ALA A  89      22.034  16.768  15.419  1.00 31.09           N  
ATOM    611  CA  ALA A  89      21.418  16.921  16.733  1.00 29.30           C  
ATOM    612  C   ALA A  89      20.345  15.856  16.847  1.00 27.78           C  
ATOM    613  O   ALA A  89      19.858  15.350  15.845  1.00 27.16           O  
ATOM    614  CB  ALA A  89      20.798  18.304  16.879  1.00 30.68           C  
ATOM    615  N   PRO A  90      19.966  15.497  18.075  1.00 26.45           N  
ATOM    616  CA  PRO A  90      18.942  14.472  18.280  1.00 25.86           C  
ATOM    617  C   PRO A  90      17.659  14.699  17.480  1.00 25.08           C  
ATOM    618  O   PRO A  90      16.997  15.720  17.636  1.00 25.57           O  
ATOM    619  CB  PRO A  90      18.708  14.518  19.784  1.00 26.96           C  
ATOM    620  CG  PRO A  90      20.085  14.860  20.305  1.00 28.55           C  
ATOM    621  CD  PRO A  90      20.536  15.947  19.356  1.00 26.27           C  
ATOM    622  N   GLN A  91      17.322  13.733  16.628  1.00 23.28           N  
ATOM    623  CA  GLN A  91      16.122  13.800  15.813  1.00 22.24           C  
ATOM    624  C   GLN A  91      15.105  12.746  16.221  1.00 20.39           C  
ATOM    625  O   GLN A  91      13.902  12.934  16.038  1.00 21.17           O  
ATOM    626  CB  GLN A  91      16.473  13.625  14.337  1.00 23.09           C  
ATOM    627  CG  GLN A  91      17.296  14.765  13.786  1.00 24.86           C  
ATOM    628  CD  GLN A  91      17.724  14.518  12.367  1.00 25.74           C  
ATOM    629  OE1 GLN A  91      16.893  14.309  11.487  1.00 27.97           O  
ATOM    630  NE2 GLN A  91      19.028  14.537  12.130  1.00 26.04           N  
ATOM    631  N   ALA A  92      15.585  11.636  16.773  1.00 19.10           N  
ATOM    632  CA  ALA A  92      14.693  10.557  17.213  1.00 16.37           C  
ATOM    633  C   ALA A  92      15.073  10.099  18.609  1.00 14.15           C  
ATOM    634  O   ALA A  92      16.255   9.972  18.923  1.00 14.73           O  
ATOM    635  CB  ALA A  92      14.778   9.389  16.256  1.00 14.76           C  
ATOM    636  N   LEU A  93      14.068   9.876  19.446  1.00 11.50           N  
ATOM    637  CA  LEU A  93      14.276   9.405  20.809  1.00 12.05           C  
ATOM    638  C   LEU A  93      13.495   8.089  21.000  1.00 14.46           C  
ATOM    639  O   LEU A  93      12.274   8.042  20.787  1.00 13.21           O  
ATOM    640  CB  LEU A  93      13.794  10.452  21.830  1.00 10.94           C  
ATOM    641  CG  LEU A  93      13.642   9.967  23.293  1.00 12.23           C  
ATOM    642  CD1 LEU A  93      15.001   9.595  23.873  1.00  8.52           C  
ATOM    643  CD2 LEU A  93      12.989  11.049  24.149  1.00  9.77           C  
HETATM  644  N   MSE A  94      14.206   7.030  21.389  1.00 12.70           N  
HETATM  645  CA  MSE A  94      13.589   5.729  21.615  1.00 15.13           C  
HETATM  646  C   MSE A  94      13.756   5.385  23.091  1.00 15.82           C  
HETATM  647  O   MSE A  94      14.818   5.593  23.658  1.00 18.97           O  
HETATM  648  CB  MSE A  94      14.271   4.659  20.761  1.00 13.86           C  
HETATM  649  CG  MSE A  94      14.569   5.137  19.357  1.00 17.56           C  
HETATM  650 SE   MSE A  94      15.441   3.845  18.234  1.00 15.46          SE  
HETATM  651  CE  MSE A  94      17.072   3.655  19.163  1.00 25.81           C  
ATOM    652  N   LEU A  95      12.703   4.875  23.713  1.00 14.41           N  
ATOM    653  CA  LEU A  95      12.770   4.499  25.116  1.00 14.04           C  
ATOM    654  C   LEU A  95      12.458   3.016  25.297  1.00 12.80           C  
ATOM    655  O   LEU A  95      11.560   2.478  24.648  1.00  8.03           O  
ATOM    656  CB  LEU A  95      11.783   5.326  25.951  1.00 14.71           C  
ATOM    657  CG  LEU A  95      11.980   6.836  26.133  1.00 15.48           C  
ATOM    658  CD1 LEU A  95      10.913   7.360  27.089  1.00 13.31           C  
ATOM    659  CD2 LEU A  95      13.363   7.127  26.686  1.00 14.45           C  
ATOM    660  N   ALA A  96      13.209   2.370  26.188  1.00 13.80           N  
ATOM    661  CA  ALA A  96      13.026   0.947  26.488  1.00 15.23           C  
ATOM    662  C   ALA A  96      12.975   0.760  28.014  1.00 16.97           C  
ATOM    663  O   ALA A  96      13.482   1.588  28.762  1.00 17.50           O  
ATOM    664  CB  ALA A  96      14.168   0.128  25.867  1.00 12.64           C  
ATOM    665  N   PRO A  97      12.388  -0.349  28.490  1.00 19.34           N  
ATOM    666  CA  PRO A  97      12.265  -0.628  29.930  1.00 20.48           C  
ATOM    667  C   PRO A  97      13.548  -0.808  30.742  1.00 19.88           C  
ATOM    668  O   PRO A  97      13.541  -0.584  31.954  1.00 21.97           O  
ATOM    669  CB  PRO A  97      11.410  -1.909  29.977  1.00 19.60           C  
ATOM    670  CG  PRO A  97      10.819  -2.028  28.594  1.00 20.38           C  
ATOM    671  CD  PRO A  97      11.899  -1.492  27.703  1.00 19.44           C  
ATOM    672  N   THR A  98      14.635  -1.205  30.087  1.00 18.93           N  
ATOM    673  CA  THR A  98      15.892  -1.467  30.777  1.00 18.13           C  
ATOM    674  C   THR A  98      17.139  -1.127  29.960  1.00 19.61           C  
ATOM    675  O   THR A  98      17.078  -1.067  28.730  1.00 19.57           O  
ATOM    676  CB  THR A  98      15.994  -2.966  31.130  1.00 20.06           C  
ATOM    677  OG1 THR A  98      16.202  -3.719  29.921  1.00 22.38           O  
ATOM    678  CG2 THR A  98      14.712  -3.462  31.804  1.00 16.09           C  
ATOM    679  N   ARG A  99      18.266  -0.942  30.653  1.00 20.40           N  
ATOM    680  CA  ARG A  99      19.557  -0.636  30.020  1.00 22.34           C  
ATOM    681  C   ARG A  99      19.880  -1.660  28.940  1.00 22.72           C  
ATOM    682  O   ARG A  99      20.274  -1.310  27.824  1.00 23.08           O  
ATOM    683  CB  ARG A  99      20.697  -0.688  31.042  1.00 23.96           C  
ATOM    684  CG  ARG A  99      20.627   0.316  32.152  1.00 25.64           C  
ATOM    685  CD  ARG A  99      21.803   0.173  33.124  1.00 28.38           C  
ATOM    686  NE  ARG A  99      23.089   0.547  32.534  1.00 30.29           N  
ATOM    687  CZ  ARG A  99      23.854  -0.258  31.804  1.00 30.77           C  
ATOM    688  NH1 ARG A  99      23.477  -1.505  31.562  1.00 28.88           N  
ATOM    689  NH2 ARG A  99      25.005   0.188  31.316  1.00 34.03           N  
ATOM    690  N   GLU A 100      19.738  -2.931  29.312  1.00 23.72           N  
ATOM    691  CA  GLU A 100      19.993  -4.061  28.428  1.00 23.37           C  
ATOM    692  C   GLU A 100      19.202  -3.878  27.136  1.00 19.51           C  
ATOM    693  O   GLU A 100      19.772  -3.855  26.050  1.00 17.37           O  
ATOM    694  CB  GLU A 100      19.599  -5.370  29.143  1.00 27.94           C  
ATOM    695  CG  GLU A 100      19.692  -6.658  28.304  1.00 35.26           C  
ATOM    696  CD  GLU A 100      18.387  -7.010  27.565  1.00 40.11           C  
ATOM    697  OE1 GLU A 100      18.424  -7.184  26.316  1.00 42.94           O  
ATOM    698  OE2 GLU A 100      17.331  -7.128  28.234  1.00 39.16           O  
ATOM    699  N   LEU A 101      17.893  -3.724  27.270  1.00 18.52           N  
ATOM    700  CA  LEU A 101      17.014  -3.533  26.124  1.00 19.16           C  
ATOM    701  C   LEU A 101      17.407  -2.340  25.267  1.00 19.67           C  
ATOM    702  O   LEU A 101      17.352  -2.412  24.043  1.00 22.04           O  
ATOM    703  CB  LEU A 101      15.568  -3.373  26.597  1.00 20.88           C  
ATOM    704  CG  LEU A 101      15.015  -4.638  27.259  1.00 21.77           C  
ATOM    705  CD1 LEU A 101      13.689  -4.332  27.900  1.00 24.10           C  
ATOM    706  CD2 LEU A 101      14.881  -5.750  26.213  1.00 21.20           C  
ATOM    707  N   ALA A 102      17.807  -1.244  25.907  1.00 17.63           N  
ATOM    708  CA  ALA A 102      18.209  -0.049  25.181  1.00 16.24           C  
ATOM    709  C   ALA A 102      19.464  -0.320  24.357  1.00 16.85           C  
ATOM    710  O   ALA A 102      19.524   0.030  23.172  1.00 16.07           O  
ATOM    711  CB  ALA A 102      18.455   1.119  26.161  1.00 11.49           C  
ATOM    712  N   LEU A 103      20.459  -0.940  24.991  1.00 16.08           N  
ATOM    713  CA  LEU A 103      21.708  -1.255  24.330  1.00 15.68           C  
ATOM    714  C   LEU A 103      21.460  -2.177  23.150  1.00 19.37           C  
ATOM    715  O   LEU A 103      22.110  -2.061  22.107  1.00 19.80           O  
ATOM    716  CB  LEU A 103      22.662  -1.929  25.301  1.00 14.00           C  
ATOM    717  CG  LEU A 103      23.325  -1.077  26.373  1.00 15.48           C  
ATOM    718  CD1 LEU A 103      24.134  -1.987  27.260  1.00  8.56           C  
ATOM    719  CD2 LEU A 103      24.214   0.006  25.739  1.00 12.23           C  
ATOM    720  N   GLN A 104      20.525  -3.107  23.313  1.00 20.41           N  
ATOM    721  CA  GLN A 104      20.225  -4.012  22.217  1.00 22.64           C  
ATOM    722  C   GLN A 104      19.698  -3.189  21.035  1.00 21.68           C  
ATOM    723  O   GLN A 104      20.118  -3.374  19.889  1.00 21.70           O  
ATOM    724  CB  GLN A 104      19.194  -5.063  22.654  1.00 24.51           C  
ATOM    725  CG  GLN A 104      18.667  -5.924  21.526  1.00 30.14           C  
ATOM    726  CD  GLN A 104      19.758  -6.711  20.795  1.00 37.33           C  
ATOM    727  OE1 GLN A 104      19.489  -7.346  19.765  1.00 38.94           O  
ATOM    728  NE2 GLN A 104      20.987  -6.684  21.326  1.00 38.71           N  
ATOM    729  N   ILE A 105      18.789  -2.266  21.325  1.00 18.20           N  
ATOM    730  CA  ILE A 105      18.229  -1.443  20.284  1.00 17.73           C  
ATOM    731  C   ILE A 105      19.319  -0.629  19.596  1.00 19.66           C  
ATOM    732  O   ILE A 105      19.332  -0.528  18.366  1.00 21.37           O  
ATOM    733  CB  ILE A 105      17.143  -0.529  20.849  1.00 16.90           C  
ATOM    734  CG1 ILE A 105      15.906  -1.374  21.188  1.00 14.05           C  
ATOM    735  CG2 ILE A 105      16.827   0.587  19.863  1.00 12.17           C  
ATOM    736  CD1 ILE A 105      14.848  -0.646  22.017  1.00 11.22           C  
ATOM    737  N   GLN A 106      20.250  -0.081  20.372  1.00 18.41           N  
ATOM    738  CA  GLN A 106      21.334   0.711  19.792  1.00 18.20           C  
ATOM    739  C   GLN A 106      22.153  -0.162  18.851  1.00 18.00           C  
ATOM    740  O   GLN A 106      22.656   0.285  17.814  1.00 16.53           O  
ATOM    741  CB  GLN A 106      22.234   1.274  20.894  1.00 19.12           C  
ATOM    742  CG  GLN A 106      23.610   1.705  20.391  1.00 20.29           C  
ATOM    743  CD  GLN A 106      24.410   2.442  21.441  1.00 21.91           C  
ATOM    744  OE1 GLN A 106      24.631   1.934  22.542  1.00 24.91           O  
ATOM    745  NE2 GLN A 106      24.846   3.650  21.109  1.00 19.90           N  
ATOM    746  N   LYS A 107      22.275  -1.424  19.230  1.00 18.06           N  
ATOM    747  CA  LYS A 107      23.001  -2.396  18.442  1.00 17.45           C  
ATOM    748  C   LYS A 107      22.265  -2.645  17.119  1.00 14.07           C  
ATOM    749  O   LYS A 107      22.878  -2.705  16.060  1.00 14.05           O  
ATOM    750  CB  LYS A 107      23.121  -3.681  19.256  1.00 24.73           C  
ATOM    751  CG  LYS A 107      24.183  -4.658  18.814  1.00 30.57           C  
ATOM    752  CD  LYS A 107      24.195  -5.844  19.779  1.00 35.31           C  
ATOM    753  CE  LYS A 107      25.135  -6.950  19.316  1.00 37.39           C  
ATOM    754  NZ  LYS A 107      25.019  -8.148  20.204  1.00 39.82           N  
ATOM    755  N   VAL A 108      20.945  -2.754  17.168  1.00 12.70           N  
ATOM    756  CA  VAL A 108      20.182  -3.000  15.951  1.00 13.25           C  
ATOM    757  C   VAL A 108      20.208  -1.829  14.980  1.00 15.14           C  
ATOM    758  O   VAL A 108      20.435  -2.046  13.784  1.00 15.13           O  
ATOM    759  CB  VAL A 108      18.693  -3.365  16.251  1.00 15.97           C  
ATOM    760  CG1 VAL A 108      17.943  -3.576  14.961  1.00 13.51           C  
ATOM    761  CG2 VAL A 108      18.611  -4.637  17.089  1.00 14.94           C  
ATOM    762  N   VAL A 109      19.991  -0.596  15.461  1.00 15.91           N  
ATOM    763  CA  VAL A 109      20.006   0.531  14.525  1.00 17.79           C  
ATOM    764  C   VAL A 109      21.396   0.790  13.956  1.00 18.36           C  
ATOM    765  O   VAL A 109      21.518   1.183  12.796  1.00 19.27           O  
ATOM    766  CB  VAL A 109      19.360   1.879  15.113  1.00 17.58           C  
ATOM    767  CG1 VAL A 109      18.844   1.674  16.522  1.00 17.73           C  
ATOM    768  CG2 VAL A 109      20.335   3.047  15.015  1.00 13.98           C  
HETATM  769  N   MSE A 110      22.433   0.547  14.757  1.00 21.26           N  
HETATM  770  CA  MSE A 110      23.825   0.716  14.316  1.00 23.03           C  
HETATM  771  C   MSE A 110      24.119  -0.219  13.136  1.00 20.68           C  
HETATM  772  O   MSE A 110      24.730   0.181  12.138  1.00 18.08           O  
HETATM  773  CB  MSE A 110      24.798   0.382  15.452  1.00 30.99           C  
HETATM  774  CG  MSE A 110      24.901   1.420  16.562  1.00 41.90           C  
HETATM  775 SE   MSE A 110      25.737   3.016  15.922  1.00 59.71          SE  
HETATM  776  CE  MSE A 110      27.559   2.626  16.450  1.00 55.26           C  
ATOM    777  N   ALA A 111      23.682  -1.472  13.257  1.00 17.05           N  
ATOM    778  CA  ALA A 111      23.903  -2.442  12.200  1.00 16.26           C  
ATOM    779  C   ALA A 111      23.134  -1.992  10.977  1.00 17.88           C  
ATOM    780  O   ALA A 111      23.692  -1.913   9.877  1.00 19.02           O  
ATOM    781  CB  ALA A 111      23.439  -3.819  12.636  1.00 12.33           C  
ATOM    782  N   LEU A 112      21.853  -1.696  11.180  1.00 18.22           N  
ATOM    783  CA  LEU A 112      20.982  -1.243  10.101  1.00 18.16           C  
ATOM    784  C   LEU A 112      21.579  -0.014   9.424  1.00 17.30           C  
ATOM    785  O   LEU A 112      21.394   0.166   8.230  1.00 18.21           O  
ATOM    786  CB  LEU A 112      19.574  -0.926  10.643  1.00 17.36           C  
ATOM    787  CG  LEU A 112      18.384  -1.855  10.357  1.00 17.85           C  
ATOM    788  CD1 LEU A 112      18.819  -3.288  10.041  1.00 17.99           C  
ATOM    789  CD2 LEU A 112      17.479  -1.853  11.587  1.00 18.59           C  
ATOM    790  N   ALA A 113      22.298   0.818  10.179  1.00 15.43           N  
ATOM    791  CA  ALA A 113      22.932   2.026   9.615  1.00 17.63           C  
ATOM    792  C   ALA A 113      24.407   1.815   9.205  1.00 18.24           C  
ATOM    793  O   ALA A 113      25.161   2.775   9.028  1.00 19.34           O  
ATOM    794  CB  ALA A 113      22.837   3.187  10.621  1.00 11.57           C  
ATOM    795  N   PHE A 114      24.811   0.562   9.039  1.00 18.44           N  
ATOM    796  CA  PHE A 114      26.192   0.229   8.676  1.00 19.53           C  
ATOM    797  C   PHE A 114      26.782   0.964   7.459  1.00 18.82           C  
ATOM    798  O   PHE A 114      27.976   1.273   7.430  1.00 20.04           O  
ATOM    799  CB  PHE A 114      26.314  -1.284   8.459  1.00 18.80           C  
ATOM    800  CG  PHE A 114      27.729  -1.771   8.360  1.00 18.43           C  
ATOM    801  CD1 PHE A 114      28.588  -1.663   9.446  1.00 15.15           C  
ATOM    802  CD2 PHE A 114      28.206  -2.342   7.175  1.00 19.47           C  
ATOM    803  CE1 PHE A 114      29.894  -2.108   9.369  1.00 11.25           C  
ATOM    804  CE2 PHE A 114      29.525  -2.799   7.085  1.00 15.28           C  
ATOM    805  CZ  PHE A 114      30.365  -2.678   8.184  1.00 16.38           C  
ATOM    806  N   HIS A 115      25.962   1.219   6.450  1.00 17.90           N  
ATOM    807  CA  HIS A 115      26.427   1.908   5.254  1.00 17.69           C  
ATOM    808  C   HIS A 115      26.019   3.374   5.295  1.00 18.73           C  
ATOM    809  O   HIS A 115      26.029   4.052   4.274  1.00 20.07           O  
ATOM    810  CB  HIS A 115      25.837   1.247   4.010  1.00 16.21           C  
ATOM    811  CG  HIS A 115      26.123  -0.220   3.910  1.00 18.77           C  
ATOM    812  ND1 HIS A 115      27.270  -0.722   3.330  1.00 20.77           N  
ATOM    813  CD2 HIS A 115      25.411  -1.296   4.322  1.00 19.03           C  
ATOM    814  CE1 HIS A 115      27.250  -2.042   3.388  1.00 20.71           C  
ATOM    815  NE2 HIS A 115      26.132  -2.417   3.984  1.00 18.45           N  
HETATM  816  N   MSE A 116      25.653   3.854   6.480  1.00 17.81           N  
HETATM  817  CA  MSE A 116      25.238   5.235   6.656  1.00 19.22           C  
HETATM  818  C   MSE A 116      26.166   5.863   7.678  1.00 21.69           C  
HETATM  819  O   MSE A 116      26.990   5.177   8.266  1.00 24.36           O  
HETATM  820  CB  MSE A 116      23.794   5.304   7.158  1.00 19.34           C  
HETATM  821  CG  MSE A 116      22.769   4.597   6.275  1.00 17.60           C  
HETATM  822 SE   MSE A 116      21.030   4.466   7.135  1.00 17.24          SE  
HETATM  823  CE  MSE A 116      20.679   6.356   7.315  1.00 19.26           C  
ATOM    824  N   ASP A 117      26.030   7.167   7.884  1.00 25.45           N  
ATOM    825  CA  ASP A 117      26.856   7.898   8.838  1.00 28.35           C  
ATOM    826  C   ASP A 117      25.952   8.572   9.877  1.00 29.55           C  
ATOM    827  O   ASP A 117      25.861   9.804   9.945  1.00 31.05           O  
ATOM    828  CB  ASP A 117      27.698   8.939   8.093  1.00 30.58           C  
ATOM    829  CG  ASP A 117      28.724   9.611   8.986  1.00 35.33           C  
ATOM    830  OD1 ASP A 117      29.213   8.960   9.932  1.00 36.52           O  
ATOM    831  OD2 ASP A 117      29.060  10.787   8.726  1.00 39.09           O  
ATOM    832  N   ILE A 118      25.290   7.740  10.678  1.00 28.95           N  
ATOM    833  CA  ILE A 118      24.360   8.189  11.714  1.00 26.41           C  
ATOM    834  C   ILE A 118      24.955   7.929  13.087  1.00 25.11           C  
ATOM    835  O   ILE A 118      25.510   6.870  13.333  1.00 27.86           O  
ATOM    836  CB  ILE A 118      23.016   7.409  11.638  1.00 25.75           C  
ATOM    837  CG1 ILE A 118      22.399   7.548  10.250  1.00 25.40           C  
ATOM    838  CG2 ILE A 118      22.049   7.922  12.701  1.00 26.50           C  
ATOM    839  CD1 ILE A 118      22.031   8.966   9.890  1.00 25.70           C  
ATOM    840  N   LYS A 119      24.822   8.884  13.989  1.00 25.08           N  
ATOM    841  CA  LYS A 119      25.360   8.706  15.328  1.00 24.97           C  
ATOM    842  C   LYS A 119      24.221   8.301  16.258  1.00 22.86           C  
ATOM    843  O   LYS A 119      23.154   8.915  16.252  1.00 21.42           O  
ATOM    844  CB  LYS A 119      26.022  10.003  15.800  1.00 28.32           C  
ATOM    845  CG  LYS A 119      26.751   9.871  17.115  1.00 32.30           C  
ATOM    846  CD  LYS A 119      27.618  11.095  17.388  1.00 35.62           C  
ATOM    847  CE  LYS A 119      28.302  10.985  18.742  1.00 35.00           C  
ATOM    848  NZ  LYS A 119      27.283  10.919  19.828  1.00 35.47           N  
ATOM    849  N   VAL A 120      24.444   7.241  17.032  1.00 20.56           N  
ATOM    850  CA  VAL A 120      23.423   6.744  17.944  1.00 16.58           C  
ATOM    851  C   VAL A 120      23.941   6.710  19.376  1.00 17.04           C  
ATOM    852  O   VAL A 120      24.855   5.948  19.686  1.00 18.85           O  
ATOM    853  CB  VAL A 120      22.973   5.320  17.543  1.00 11.04           C  
ATOM    854  CG1 VAL A 120      21.804   4.898  18.394  1.00 12.63           C  
ATOM    855  CG2 VAL A 120      22.586   5.279  16.104  1.00  3.55           C  
ATOM    856  N   HIS A 121      23.358   7.527  20.248  1.00 16.29           N  
ATOM    857  CA  HIS A 121      23.784   7.568  21.651  1.00 16.37           C  
ATOM    858  C   HIS A 121      22.846   6.889  22.648  1.00 17.03           C  
ATOM    859  O   HIS A 121      21.622   7.080  22.613  1.00 17.14           O  
ATOM    860  CB  HIS A 121      24.008   9.007  22.099  1.00 12.45           C  
ATOM    861  CG  HIS A 121      24.593   9.122  23.470  1.00 12.40           C  
ATOM    862  ND1 HIS A 121      23.835   9.425  24.583  1.00 13.53           N  
ATOM    863  CD2 HIS A 121      25.864   8.966  23.912  1.00 12.04           C  
ATOM    864  CE1 HIS A 121      24.611   9.454  25.651  1.00 11.02           C  
ATOM    865  NE2 HIS A 121      25.847   9.177  25.271  1.00 15.27           N  
ATOM    866  N   ALA A 122      23.432   6.106  23.549  1.00 17.70           N  
ATOM    867  CA  ALA A 122      22.654   5.412  24.564  1.00 18.58           C  
ATOM    868  C   ALA A 122      22.697   6.170  25.883  1.00 20.45           C  
ATOM    869  O   ALA A 122      23.741   6.268  26.529  1.00 20.24           O  
ATOM    870  CB  ALA A 122      23.167   4.006  24.756  1.00 14.70           C  
ATOM    871  N   CYS A 123      21.548   6.711  26.272  1.00 21.81           N  
ATOM    872  CA  CYS A 123      21.433   7.458  27.512  1.00 24.21           C  
ATOM    873  C   CYS A 123      20.899   6.488  28.556  1.00 24.99           C  
ATOM    874  O   CYS A 123      19.702   6.413  28.814  1.00 24.66           O  
ATOM    875  CB  CYS A 123      20.485   8.639  27.309  1.00 23.80           C  
ATOM    876  SG  CYS A 123      20.368   9.735  28.703  1.00 31.44           S  
ATOM    877  N   ILE A 124      21.817   5.738  29.151  1.00 28.35           N  
ATOM    878  CA  ILE A 124      21.469   4.721  30.129  1.00 31.50           C  
ATOM    879  C   ILE A 124      22.253   4.853  31.432  1.00 36.57           C  
ATOM    880  O   ILE A 124      23.111   5.728  31.567  1.00 36.93           O  
ATOM    881  CB  ILE A 124      21.725   3.326  29.527  1.00 30.54           C  
ATOM    882  CG1 ILE A 124      23.188   3.209  29.064  1.00 26.20           C  
ATOM    883  CG2 ILE A 124      20.813   3.109  28.329  1.00 26.82           C  
ATOM    884  CD1 ILE A 124      23.584   1.818  28.591  1.00 23.40           C  
ATOM    885  N   GLY A 125      21.959   3.967  32.380  1.00 41.08           N  
ATOM    886  CA  GLY A 125      22.632   3.990  33.669  1.00 46.72           C  
ATOM    887  C   GLY A 125      24.142   3.814  33.603  1.00 51.89           C  
ATOM    888  O   GLY A 125      24.673   3.151  32.698  1.00 52.55           O  
ATOM    889  N   GLY A 126      24.839   4.404  34.571  1.00 54.10           N  
ATOM    890  CA  GLY A 126      26.284   4.301  34.598  1.00 57.99           C  
ATOM    891  C   GLY A 126      26.893   4.853  33.329  1.00 60.93           C  
ATOM    892  O   GLY A 126      27.083   4.136  32.345  1.00 60.48           O  
ATOM    893  N   THR A 127      27.189   6.146  33.358  1.00 63.83           N  
ATOM    894  CA  THR A 127      27.781   6.842  32.225  1.00 66.70           C  
ATOM    895  C   THR A 127      28.198   8.245  32.671  1.00 68.28           C  
ATOM    896  O   THR A 127      27.359   9.078  33.038  1.00 67.81           O  
ATOM    897  CB  THR A 127      26.780   6.934  31.041  1.00 66.96           C  
ATOM    898  OG1 THR A 127      27.349   7.723  29.992  1.00 66.87           O  
ATOM    899  CG2 THR A 127      25.464   7.557  31.490  1.00 68.02           C  
ATOM    900  N   SER A 128      29.506   8.489  32.656  1.00 69.79           N  
ATOM    901  CA  SER A 128      30.055   9.776  33.064  1.00 71.71           C  
ATOM    902  C   SER A 128      29.236  10.916  32.478  1.00 72.83           C  
ATOM    903  O   SER A 128      29.174  11.074  31.258  1.00 74.14           O  
ATOM    904  CB  SER A 128      31.509   9.894  32.601  1.00 71.97           C  
ATOM    905  OG  SER A 128      32.102  11.088  33.079  1.00 72.40           O  
ATOM    906  N   PHE A 129      28.607  11.704  33.347  1.00 73.36           N  
ATOM    907  CA  PHE A 129      27.792  12.836  32.910  1.00 73.75           C  
ATOM    908  C   PHE A 129      28.524  13.712  31.896  1.00 72.98           C  
ATOM    909  O   PHE A 129      27.928  14.605  31.290  1.00 73.20           O  
ATOM    910  CB  PHE A 129      27.362  13.676  34.118  1.00 75.80           C  
ATOM    911  CG  PHE A 129      28.442  13.855  35.148  1.00 78.46           C  
ATOM    912  CD1 PHE A 129      29.626  14.518  34.833  1.00 79.24           C  
ATOM    913  CD2 PHE A 129      28.284  13.339  36.433  1.00 79.02           C  
ATOM    914  CE1 PHE A 129      30.639  14.662  35.783  1.00 80.39           C  
ATOM    915  CE2 PHE A 129      29.288  13.476  37.389  1.00 79.75           C  
ATOM    916  CZ  PHE A 129      30.469  14.139  37.063  1.00 80.20           C  
ATOM    917  N   VAL A 130      29.816  13.451  31.720  1.00 71.20           N  
ATOM    918  CA  VAL A 130      30.641  14.193  30.773  1.00 69.47           C  
ATOM    919  C   VAL A 130      30.503  13.573  29.386  1.00 68.33           C  
ATOM    920  O   VAL A 130      30.258  14.276  28.405  1.00 68.14           O  
ATOM    921  CB  VAL A 130      32.132  14.164  31.187  1.00 69.81           C  
ATOM    922  CG1 VAL A 130      32.970  14.941  30.179  1.00 68.62           C  
ATOM    923  CG2 VAL A 130      32.294  14.744  32.587  1.00 69.22           C  
ATOM    924  N   GLU A 131      30.674  12.256  29.305  1.00 66.93           N  
ATOM    925  CA  GLU A 131      30.548  11.565  28.028  1.00 65.69           C  
ATOM    926  C   GLU A 131      29.088  11.555  27.607  1.00 62.81           C  
ATOM    927  O   GLU A 131      28.769  11.591  26.420  1.00 62.07           O  
ATOM    928  CB  GLU A 131      31.056  10.127  28.127  1.00 68.56           C  
ATOM    929  CG  GLU A 131      32.556   9.983  27.983  1.00 72.07           C  
ATOM    930  CD  GLU A 131      32.952   8.607  27.475  1.00 75.06           C  
ATOM    931  OE1 GLU A 131      32.594   7.600  28.126  1.00 75.92           O  
ATOM    932  OE2 GLU A 131      33.622   8.533  26.418  1.00 76.71           O  
ATOM    933  N   ASP A 132      28.202  11.495  28.591  1.00 59.20           N  
ATOM    934  CA  ASP A 132      26.775  11.500  28.321  1.00 56.37           C  
ATOM    935  C   ASP A 132      26.484  12.813  27.599  1.00 53.38           C  
ATOM    936  O   ASP A 132      25.743  12.853  26.619  1.00 53.26           O  
ATOM    937  CB  ASP A 132      25.995  11.435  29.638  1.00 57.08           C  
ATOM    938  CG  ASP A 132      24.575  10.926  29.460  1.00 58.16           C  
ATOM    939  OD1 ASP A 132      23.784  11.058  30.415  1.00 59.87           O  
ATOM    940  OD2 ASP A 132      24.245  10.387  28.381  1.00 59.76           O  
ATOM    941  N   ALA A 133      27.094  13.885  28.092  1.00 50.08           N  
ATOM    942  CA  ALA A 133      26.922  15.207  27.515  1.00 47.36           C  
ATOM    943  C   ALA A 133      27.455  15.240  26.091  1.00 46.03           C  
ATOM    944  O   ALA A 133      26.757  15.652  25.168  1.00 47.04           O  
ATOM    945  CB  ALA A 133      27.643  16.243  28.366  1.00 46.33           C  
ATOM    946  N   GLU A 134      28.693  14.801  25.911  1.00 44.31           N  
ATOM    947  CA  GLU A 134      29.301  14.794  24.590  1.00 43.45           C  
ATOM    948  C   GLU A 134      28.520  13.894  23.624  1.00 41.38           C  
ATOM    949  O   GLU A 134      28.355  14.215  22.448  1.00 40.96           O  
ATOM    950  CB  GLU A 134      30.748  14.313  24.689  1.00 44.75           C  
ATOM    951  CG  GLU A 134      31.596  14.700  23.496  1.00 50.44           C  
ATOM    952  CD  GLU A 134      32.932  13.980  23.467  1.00 54.52           C  
ATOM    953  OE1 GLU A 134      33.666  14.041  24.481  1.00 55.84           O  
ATOM    954  OE2 GLU A 134      33.247  13.355  22.427  1.00 55.57           O  
ATOM    955  N   GLY A 135      28.038  12.765  24.134  1.00 40.03           N  
ATOM    956  CA  GLY A 135      27.285  11.838  23.312  1.00 36.80           C  
ATOM    957  C   GLY A 135      25.961  12.386  22.818  1.00 35.10           C  
ATOM    958  O   GLY A 135      25.555  12.095  21.702  1.00 32.92           O  
ATOM    959  N   LEU A 136      25.291  13.186  23.641  1.00 34.58           N  
ATOM    960  CA  LEU A 136      24.004  13.768  23.273  1.00 35.17           C  
ATOM    961  C   LEU A 136      24.152  15.023  22.414  1.00 37.08           C  
ATOM    962  O   LEU A 136      23.217  15.417  21.718  1.00 39.55           O  
ATOM    963  CB  LEU A 136      23.216  14.136  24.529  1.00 32.79           C  
ATOM    964  CG  LEU A 136      22.884  13.029  25.528  1.00 32.64           C  
ATOM    965  CD1 LEU A 136      22.725  13.631  26.911  1.00 29.80           C  
ATOM    966  CD2 LEU A 136      21.620  12.292  25.090  1.00 31.35           C  
ATOM    967  N   ARG A 137      25.317  15.659  22.469  1.00 37.44           N  
ATOM    968  CA  ARG A 137      25.531  16.888  21.713  1.00 36.50           C  
ATOM    969  C   ARG A 137      25.250  16.714  20.234  1.00 36.02           C  
ATOM    970  O   ARG A 137      24.448  17.452  19.660  1.00 36.83           O  
ATOM    971  CB  ARG A 137      26.960  17.402  21.917  1.00 36.79           C  
ATOM    972  N   ASP A 138      25.903  15.741  19.611  1.00 34.47           N  
ATOM    973  CA  ASP A 138      25.717  15.523  18.189  1.00 33.28           C  
ATOM    974  C   ASP A 138      25.028  14.221  17.790  1.00 30.85           C  
ATOM    975  O   ASP A 138      24.992  13.876  16.611  1.00 29.24           O  
ATOM    976  CB  ASP A 138      27.062  15.638  17.468  1.00 38.46           C  
ATOM    977  CG  ASP A 138      28.183  14.958  18.218  1.00 42.68           C  
ATOM    978  OD1 ASP A 138      27.951  13.846  18.749  1.00 42.99           O  
ATOM    979  OD2 ASP A 138      29.295  15.538  18.266  1.00 45.85           O  
ATOM    980  N   ALA A 139      24.481  13.497  18.759  1.00 28.13           N  
ATOM    981  CA  ALA A 139      23.775  12.263  18.437  1.00 26.24           C  
ATOM    982  C   ALA A 139      22.535  12.607  17.613  1.00 24.36           C  
ATOM    983  O   ALA A 139      21.911  13.653  17.814  1.00 24.84           O  
ATOM    984  CB  ALA A 139      23.358  11.541  19.713  1.00 25.93           C  
ATOM    985  N   GLN A 140      22.180  11.733  16.682  1.00 21.10           N  
ATOM    986  CA  GLN A 140      21.002  11.966  15.861  1.00 20.11           C  
ATOM    987  C   GLN A 140      19.849  11.070  16.324  1.00 17.52           C  
ATOM    988  O   GLN A 140      18.682  11.438  16.217  1.00 16.96           O  
ATOM    989  CB  GLN A 140      21.348  11.734  14.395  1.00 20.39           C  
ATOM    990  CG  GLN A 140      22.444  12.675  13.916  1.00 19.89           C  
ATOM    991  CD  GLN A 140      23.162  12.168  12.695  1.00 19.82           C  
ATOM    992  OE1 GLN A 140      23.819  11.129  12.730  1.00 19.77           O  
ATOM    993  NE2 GLN A 140      23.044  12.902  11.603  1.00 22.33           N  
ATOM    994  N   ILE A 141      20.189   9.901  16.853  1.00 16.22           N  
ATOM    995  CA  ILE A 141      19.202   8.965  17.389  1.00 13.21           C  
ATOM    996  C   ILE A 141      19.626   8.692  18.823  1.00 12.54           C  
ATOM    997  O   ILE A 141      20.727   8.195  19.068  1.00 12.01           O  
ATOM    998  CB  ILE A 141      19.177   7.619  16.604  1.00 15.34           C  
ATOM    999  CG1 ILE A 141      18.586   7.841  15.212  1.00 13.56           C  
ATOM   1000  CG2 ILE A 141      18.385   6.560  17.390  1.00 12.99           C  
ATOM   1001  CD1 ILE A 141      18.443   6.586  14.389  1.00 15.66           C  
ATOM   1002  N   VAL A 142      18.769   9.053  19.769  1.00 11.43           N  
ATOM   1003  CA  VAL A 142      19.055   8.833  21.177  1.00  9.94           C  
ATOM   1004  C   VAL A 142      18.139   7.727  21.699  1.00 11.42           C  
ATOM   1005  O   VAL A 142      16.928   7.743  21.449  1.00 11.99           O  
ATOM   1006  CB  VAL A 142      18.823  10.129  21.997  1.00  9.91           C  
ATOM   1007  CG1 VAL A 142      18.920   9.834  23.498  1.00  4.42           C  
ATOM   1008  CG2 VAL A 142      19.834  11.193  21.579  1.00  7.12           C  
ATOM   1009  N   VAL A 143      18.721   6.769  22.414  1.00 11.48           N  
ATOM   1010  CA  VAL A 143      17.968   5.645  22.974  1.00 12.76           C  
ATOM   1011  C   VAL A 143      18.347   5.459  24.433  1.00 12.27           C  
ATOM   1012  O   VAL A 143      19.513   5.606  24.796  1.00 15.42           O  
ATOM   1013  CB  VAL A 143      18.271   4.311  22.210  1.00 14.66           C  
ATOM   1014  CG1 VAL A 143      19.731   3.915  22.398  1.00 15.72           C  
ATOM   1015  CG2 VAL A 143      17.361   3.193  22.717  1.00 15.70           C  
ATOM   1016  N   GLY A 144      17.375   5.144  25.282  1.00 12.52           N  
ATOM   1017  CA  GLY A 144      17.707   4.944  26.687  1.00 11.27           C  
ATOM   1018  C   GLY A 144      16.507   4.691  27.557  1.00  9.06           C  
ATOM   1019  O   GLY A 144      15.421   4.426  27.052  1.00  9.47           O  
ATOM   1020  N   THR A 145      16.699   4.764  28.866  1.00 10.05           N  
ATOM   1021  CA  THR A 145      15.589   4.557  29.791  1.00 13.97           C  
ATOM   1022  C   THR A 145      14.966   5.893  30.192  1.00 15.20           C  
ATOM   1023  O   THR A 145      15.642   6.912  30.195  1.00 15.48           O  
ATOM   1024  CB  THR A 145      16.044   3.773  31.025  1.00 13.81           C  
ATOM   1025  OG1 THR A 145      17.182   4.412  31.613  1.00 15.30           O  
ATOM   1026  CG2 THR A 145      16.426   2.368  30.621  1.00 16.69           C  
ATOM   1027  N   PRO A 146      13.666   5.893  30.547  1.00 18.12           N  
ATOM   1028  CA  PRO A 146      12.882   7.065  30.945  1.00 19.77           C  
ATOM   1029  C   PRO A 146      13.514   8.021  31.935  1.00 22.09           C  
ATOM   1030  O   PRO A 146      13.590   9.220  31.670  1.00 21.74           O  
ATOM   1031  CB  PRO A 146      11.597   6.449  31.486  1.00 17.17           C  
ATOM   1032  CG  PRO A 146      11.445   5.249  30.658  1.00 17.20           C  
ATOM   1033  CD  PRO A 146      12.846   4.680  30.713  1.00 19.52           C  
ATOM   1034  N   GLY A 147      13.957   7.485  33.069  1.00 24.67           N  
ATOM   1035  CA  GLY A 147      14.567   8.309  34.094  1.00 25.81           C  
ATOM   1036  C   GLY A 147      15.815   9.017  33.614  1.00 28.31           C  
ATOM   1037  O   GLY A 147      15.899  10.248  33.655  1.00 29.40           O  
ATOM   1038  N   ARG A 148      16.787   8.242  33.151  1.00 29.07           N  
ATOM   1039  CA  ARG A 148      18.032   8.819  32.667  1.00 30.39           C  
ATOM   1040  C   ARG A 148      17.782   9.874  31.593  1.00 28.86           C  
ATOM   1041  O   ARG A 148      18.439  10.918  31.573  1.00 27.90           O  
ATOM   1042  CB  ARG A 148      18.952   7.714  32.136  1.00 32.05           C  
ATOM   1043  CG  ARG A 148      20.207   7.513  32.982  1.00 39.71           C  
ATOM   1044  CD  ARG A 148      19.890   7.235  34.460  1.00 43.06           C  
ATOM   1045  NE  ARG A 148      19.630   5.821  34.711  1.00 48.70           N  
ATOM   1046  CZ  ARG A 148      19.171   5.322  35.859  1.00 51.44           C  
ATOM   1047  NH1 ARG A 148      18.976   4.014  35.979  1.00 51.79           N  
ATOM   1048  NH2 ARG A 148      18.892   6.121  36.884  1.00 52.42           N  
ATOM   1049  N   VAL A 149      16.818   9.610  30.715  1.00 26.37           N  
ATOM   1050  CA  VAL A 149      16.507  10.552  29.654  1.00 25.29           C  
ATOM   1051  C   VAL A 149      15.874  11.809  30.232  1.00 24.23           C  
ATOM   1052  O   VAL A 149      16.289  12.918  29.906  1.00 22.09           O  
ATOM   1053  CB  VAL A 149      15.572   9.924  28.591  1.00 23.37           C  
ATOM   1054  CG1 VAL A 149      15.044  10.992  27.654  1.00 21.29           C  
ATOM   1055  CG2 VAL A 149      16.342   8.898  27.792  1.00 21.97           C  
ATOM   1056  N   PHE A 150      14.880  11.641  31.097  1.00 25.03           N  
ATOM   1057  CA  PHE A 150      14.241  12.798  31.707  1.00 28.04           C  
ATOM   1058  C   PHE A 150      15.303  13.645  32.409  1.00 30.72           C  
ATOM   1059  O   PHE A 150      15.401  14.857  32.187  1.00 30.26           O  
ATOM   1060  CB  PHE A 150      13.185  12.370  32.723  1.00 26.97           C  
ATOM   1061  CG  PHE A 150      12.563  13.520  33.466  1.00 28.32           C  
ATOM   1062  CD1 PHE A 150      11.881  14.522  32.783  1.00 29.04           C  
ATOM   1063  CD2 PHE A 150      12.670  13.611  34.848  1.00 30.09           C  
ATOM   1064  CE1 PHE A 150      11.312  15.599  33.462  1.00 28.81           C  
ATOM   1065  CE2 PHE A 150      12.103  14.690  35.542  1.00 31.75           C  
ATOM   1066  CZ  PHE A 150      11.421  15.685  34.841  1.00 29.08           C  
ATOM   1067  N   ASP A 151      16.104  12.997  33.249  1.00 32.19           N  
ATOM   1068  CA  ASP A 151      17.154  13.695  33.974  1.00 34.18           C  
ATOM   1069  C   ASP A 151      18.055  14.480  33.033  1.00 33.24           C  
ATOM   1070  O   ASP A 151      18.337  15.647  33.276  1.00 31.74           O  
ATOM   1071  CB  ASP A 151      17.994  12.712  34.790  1.00 37.77           C  
ATOM   1072  CG  ASP A 151      18.875  13.411  35.811  1.00 44.00           C  
ATOM   1073  OD1 ASP A 151      18.340  14.277  36.545  1.00 48.64           O  
ATOM   1074  OD2 ASP A 151      20.089  13.100  35.892  1.00 45.14           O  
ATOM   1075  N   ASN A 152      18.497  13.849  31.949  1.00 34.03           N  
ATOM   1076  CA  ASN A 152      19.370  14.537  31.012  1.00 34.00           C  
ATOM   1077  C   ASN A 152      18.697  15.689  30.286  1.00 34.80           C  
ATOM   1078  O   ASN A 152      19.365  16.629  29.869  1.00 35.37           O  
ATOM   1079  CB  ASN A 152      19.966  13.558  30.004  1.00 33.53           C  
ATOM   1080  CG  ASN A 152      21.175  12.822  30.556  1.00 33.47           C  
ATOM   1081  OD1 ASN A 152      21.057  11.764  31.177  1.00 32.11           O  
ATOM   1082  ND2 ASN A 152      22.347  13.398  30.347  1.00 34.14           N  
ATOM   1083  N   ILE A 153      17.378  15.630  30.138  1.00 35.84           N  
ATOM   1084  CA  ILE A 153      16.671  16.715  29.469  1.00 36.21           C  
ATOM   1085  C   ILE A 153      16.530  17.917  30.398  1.00 37.63           C  
ATOM   1086  O   ILE A 153      16.649  19.063  29.970  1.00 37.63           O  
ATOM   1087  CB  ILE A 153      15.272  16.278  28.983  1.00 34.76           C  
ATOM   1088  CG1 ILE A 153      15.421  15.218  27.888  1.00 32.48           C  
ATOM   1089  CG2 ILE A 153      14.503  17.486  28.445  1.00 31.81           C  
ATOM   1090  CD1 ILE A 153      14.119  14.807  27.254  1.00 31.13           C  
ATOM   1091  N   GLN A 154      16.283  17.654  31.673  1.00 40.28           N  
ATOM   1092  CA  GLN A 154      16.143  18.730  32.647  1.00 42.46           C  
ATOM   1093  C   GLN A 154      17.483  19.438  32.870  1.00 43.74           C  
ATOM   1094  O   GLN A 154      17.548  20.666  32.858  1.00 44.95           O  
ATOM   1095  CB  GLN A 154      15.611  18.178  33.957  1.00 41.34           C  
ATOM   1096  N   ARG A 155      18.551  18.667  33.064  1.00 44.31           N  
ATOM   1097  CA  ARG A 155      19.867  19.249  33.289  1.00 44.83           C  
ATOM   1098  C   ARG A 155      20.386  19.853  31.998  1.00 44.90           C  
ATOM   1099  O   ARG A 155      21.479  20.404  31.952  1.00 46.06           O  
ATOM   1100  CB  ARG A 155      20.843  18.196  33.807  1.00 47.14           C  
ATOM   1101  CG  ARG A 155      20.385  17.470  35.071  1.00 50.76           C  
ATOM   1102  CD  ARG A 155      21.426  16.437  35.485  1.00 54.93           C  
ATOM   1103  NE  ARG A 155      21.857  15.636  34.339  1.00 58.57           N  
ATOM   1104  CZ  ARG A 155      22.976  14.916  34.296  1.00 61.32           C  
ATOM   1105  NH1 ARG A 155      23.797  14.890  35.341  1.00 62.79           N  
ATOM   1106  NH2 ARG A 155      23.282  14.230  33.200  1.00 61.84           N  
ATOM   1107  N   ARG A 156      19.595  19.716  30.940  1.00 44.92           N  
ATOM   1108  CA  ARG A 156      19.904  20.283  29.628  1.00 44.81           C  
ATOM   1109  C   ARG A 156      21.049  19.703  28.791  1.00 43.19           C  
ATOM   1110  O   ARG A 156      21.497  20.334  27.830  1.00 43.14           O  
ATOM   1111  CB  ARG A 156      20.093  21.793  29.781  1.00 46.88           C  
ATOM   1112  CG  ARG A 156      18.989  22.437  30.616  1.00 51.42           C  
ATOM   1113  CD  ARG A 156      18.980  23.946  30.478  1.00 55.79           C  
ATOM   1114  NE  ARG A 156      18.659  24.350  29.113  1.00 58.05           N  
ATOM   1115  CZ  ARG A 156      17.503  24.091  28.513  1.00 59.07           C  
ATOM   1116  NH1 ARG A 156      16.550  23.428  29.161  1.00 59.51           N  
ATOM   1117  NH2 ARG A 156      17.300  24.492  27.263  1.00 59.21           N  
ATOM   1118  N   ARG A 157      21.516  18.507  29.128  1.00 40.77           N  
ATOM   1119  CA  ARG A 157      22.589  17.885  28.359  1.00 37.22           C  
ATOM   1120  C   ARG A 157      22.013  17.324  27.051  1.00 35.49           C  
ATOM   1121  O   ARG A 157      22.725  17.140  26.065  1.00 34.48           O  
ATOM   1122  CB  ARG A 157      23.239  16.768  29.180  1.00 36.77           C  
ATOM   1123  N   PHE A 158      20.706  17.084  27.050  1.00 33.22           N  
ATOM   1124  CA  PHE A 158      20.000  16.527  25.898  1.00 30.00           C  
ATOM   1125  C   PHE A 158      19.004  17.543  25.327  1.00 28.64           C  
ATOM   1126  O   PHE A 158      17.920  17.733  25.877  1.00 29.36           O  
ATOM   1127  CB  PHE A 158      19.300  15.229  26.362  1.00 27.47           C  
ATOM   1128  CG  PHE A 158      18.399  14.575  25.333  1.00 24.40           C  
ATOM   1129  CD1 PHE A 158      18.390  14.976  23.997  1.00 22.98           C  
ATOM   1130  CD2 PHE A 158      17.556  13.533  25.721  1.00 22.77           C  
ATOM   1131  CE1 PHE A 158      17.557  14.353  23.068  1.00 22.18           C  
ATOM   1132  CE2 PHE A 158      16.719  12.902  24.798  1.00 24.15           C  
ATOM   1133  CZ  PHE A 158      16.721  13.317  23.465  1.00 21.61           C  
ATOM   1134  N   ARG A 159      19.383  18.193  24.226  1.00 26.93           N  
ATOM   1135  CA  ARG A 159      18.529  19.183  23.561  1.00 26.99           C  
ATOM   1136  C   ARG A 159      17.461  18.480  22.723  1.00 27.65           C  
ATOM   1137  O   ARG A 159      17.776  17.637  21.885  1.00 28.00           O  
ATOM   1138  CB  ARG A 159      19.371  20.089  22.672  1.00 26.63           C  
ATOM   1139  N   THR A 160      16.201  18.856  22.914  1.00 28.17           N  
ATOM   1140  CA  THR A 160      15.119  18.196  22.207  1.00 28.72           C  
ATOM   1141  C   THR A 160      14.421  18.948  21.083  1.00 30.25           C  
ATOM   1142  O   THR A 160      13.580  18.377  20.394  1.00 30.65           O  
ATOM   1143  CB  THR A 160      14.059  17.782  23.199  1.00 29.32           C  
ATOM   1144  OG1 THR A 160      13.464  18.958  23.750  1.00 31.96           O  
ATOM   1145  CG2 THR A 160      14.679  16.973  24.333  1.00 29.14           C  
ATOM   1146  N   ASP A 161      14.773  20.211  20.876  1.00 32.67           N  
ATOM   1147  CA  ASP A 161      14.118  21.022  19.846  1.00 33.11           C  
ATOM   1148  C   ASP A 161      14.092  20.451  18.427  1.00 32.17           C  
ATOM   1149  O   ASP A 161      13.205  20.801  17.648  1.00 32.67           O  
ATOM   1150  CB  ASP A 161      14.719  22.438  19.830  1.00 34.89           C  
ATOM   1151  CG  ASP A 161      16.154  22.460  19.357  1.00 36.80           C  
ATOM   1152  OD1 ASP A 161      16.378  22.643  18.142  1.00 39.20           O  
ATOM   1153  OD2 ASP A 161      17.059  22.285  20.200  1.00 37.72           O  
ATOM   1154  N   LYS A 162      15.040  19.577  18.088  1.00 30.25           N  
ATOM   1155  CA  LYS A 162      15.084  18.973  16.755  1.00 30.47           C  
ATOM   1156  C   LYS A 162      14.408  17.597  16.710  1.00 29.31           C  
ATOM   1157  O   LYS A 162      14.279  16.994  15.641  1.00 26.88           O  
ATOM   1158  CB  LYS A 162      16.531  18.816  16.282  1.00 32.93           C  
ATOM   1159  CG  LYS A 162      17.294  20.116  16.111  1.00 37.04           C  
ATOM   1160  CD  LYS A 162      16.718  20.940  14.986  1.00 41.18           C  
ATOM   1161  CE  LYS A 162      17.456  22.254  14.819  1.00 41.61           C  
ATOM   1162  NZ  LYS A 162      16.870  23.026  13.689  1.00 44.15           N  
ATOM   1163  N   ILE A 163      13.993  17.096  17.870  1.00 28.06           N  
ATOM   1164  CA  ILE A 163      13.346  15.789  17.942  1.00 28.73           C  
ATOM   1165  C   ILE A 163      12.060  15.802  17.125  1.00 29.84           C  
ATOM   1166  O   ILE A 163      11.198  16.646  17.351  1.00 31.47           O  
ATOM   1167  CB  ILE A 163      12.991  15.422  19.394  1.00 26.57           C  
ATOM   1168  CG1 ILE A 163      14.266  15.136  20.198  1.00 25.25           C  
ATOM   1169  CG2 ILE A 163      12.035  14.246  19.405  1.00 25.44           C  
ATOM   1170  CD1 ILE A 163      14.991  13.873  19.790  1.00 24.30           C  
ATOM   1171  N   LYS A 164      11.930  14.870  16.186  1.00 29.31           N  
ATOM   1172  CA  LYS A 164      10.733  14.796  15.352  1.00 29.71           C  
ATOM   1173  C   LYS A 164       9.984  13.485  15.593  1.00 28.25           C  
ATOM   1174  O   LYS A 164       8.807  13.369  15.279  1.00 29.27           O  
ATOM   1175  CB  LYS A 164      11.107  14.899  13.866  1.00 31.75           C  
ATOM   1176  CG  LYS A 164      12.033  16.066  13.528  1.00 36.98           C  
ATOM   1177  CD  LYS A 164      11.338  17.433  13.626  1.00 39.02           C  
ATOM   1178  CE  LYS A 164      10.745  17.874  12.289  1.00 40.45           C  
ATOM   1179  NZ  LYS A 164      11.793  18.151  11.258  1.00 38.67           N  
HETATM 1180  N   MSE A 165      10.671  12.500  16.160  1.00 27.27           N  
HETATM 1181  CA  MSE A 165      10.060  11.198  16.422  1.00 25.01           C  
HETATM 1182  C   MSE A 165      10.368  10.673  17.836  1.00 22.60           C  
HETATM 1183  O   MSE A 165      11.512  10.702  18.298  1.00 23.72           O  
HETATM 1184  CB  MSE A 165      10.542  10.199  15.375  1.00 25.87           C  
HETATM 1185  CG  MSE A 165       9.762   8.892  15.328  1.00 29.01           C  
HETATM 1186 SE   MSE A 165      10.534   7.707  14.004  1.00 32.40          SE  
HETATM 1187  CE  MSE A 165      11.363   9.050  12.887  1.00 29.94           C  
ATOM   1188  N   PHE A 166       9.323  10.199  18.504  1.00 18.38           N  
ATOM   1189  CA  PHE A 166       9.390   9.677  19.856  1.00 13.21           C  
ATOM   1190  C   PHE A 166       8.857   8.229  19.827  1.00 12.31           C  
ATOM   1191  O   PHE A 166       7.673   8.000  19.649  1.00  9.30           O  
ATOM   1192  CB  PHE A 166       8.533  10.587  20.756  1.00 12.02           C  
ATOM   1193  CG  PHE A 166       8.529  10.223  22.224  1.00 10.36           C  
ATOM   1194  CD1 PHE A 166       9.668   9.736  22.856  1.00 12.19           C  
ATOM   1195  CD2 PHE A 166       7.382  10.420  22.984  1.00 10.43           C  
ATOM   1196  CE1 PHE A 166       9.661   9.451  24.229  1.00 11.49           C  
ATOM   1197  CE2 PHE A 166       7.355  10.142  24.353  1.00  9.34           C  
ATOM   1198  CZ  PHE A 166       8.498   9.655  24.979  1.00 11.84           C  
ATOM   1199  N   ILE A 167       9.759   7.263  19.983  1.00 11.90           N  
ATOM   1200  CA  ILE A 167       9.404   5.852  19.986  1.00 11.72           C  
ATOM   1201  C   ILE A 167       9.341   5.331  21.416  1.00 12.47           C  
ATOM   1202  O   ILE A 167      10.294   5.503  22.174  1.00 12.60           O  
ATOM   1203  CB  ILE A 167      10.471   4.992  19.275  1.00 12.95           C  
ATOM   1204  CG1 ILE A 167      10.829   5.594  17.908  1.00 16.06           C  
ATOM   1205  CG2 ILE A 167       9.982   3.567  19.142  1.00  8.62           C  
ATOM   1206  CD1 ILE A 167       9.653   5.841  17.026  1.00 21.14           C  
ATOM   1207  N   LEU A 168       8.230   4.695  21.782  1.00 11.78           N  
ATOM   1208  CA  LEU A 168       8.098   4.104  23.118  1.00 14.30           C  
ATOM   1209  C   LEU A 168       8.017   2.582  22.943  1.00 15.57           C  
ATOM   1210  O   LEU A 168       6.968   2.047  22.584  1.00 19.74           O  
ATOM   1211  CB  LEU A 168       6.843   4.624  23.830  1.00 15.15           C  
ATOM   1212  CG  LEU A 168       6.801   6.100  24.264  1.00 18.84           C  
ATOM   1213  CD1 LEU A 168       6.333   6.999  23.110  1.00 19.37           C  
ATOM   1214  CD2 LEU A 168       5.844   6.255  25.417  1.00 18.00           C  
ATOM   1215  N   ASP A 169       9.122   1.881  23.180  1.00 15.58           N  
ATOM   1216  CA  ASP A 169       9.155   0.423  23.010  1.00 15.11           C  
ATOM   1217  C   ASP A 169       8.708  -0.305  24.282  1.00 16.08           C  
ATOM   1218  O   ASP A 169       9.100   0.065  25.392  1.00 14.80           O  
ATOM   1219  CB  ASP A 169      10.569  -0.009  22.592  1.00 14.30           C  
ATOM   1220  CG  ASP A 169      10.658  -1.488  22.211  1.00 18.08           C  
ATOM   1221  OD1 ASP A 169       9.660  -2.057  21.715  1.00 19.46           O  
ATOM   1222  OD2 ASP A 169      11.746  -2.075  22.386  1.00 15.79           O  
ATOM   1223  N   GLU A 170       7.885  -1.339  24.105  1.00 17.58           N  
ATOM   1224  CA  GLU A 170       7.335  -2.126  25.209  1.00 18.52           C  
ATOM   1225  C   GLU A 170       6.724  -1.191  26.234  1.00 19.94           C  
ATOM   1226  O   GLU A 170       7.080  -1.202  27.398  1.00 22.17           O  
ATOM   1227  CB  GLU A 170       8.418  -2.984  25.857  1.00 17.90           C  
ATOM   1228  CG  GLU A 170       9.106  -3.939  24.892  1.00 18.40           C  
ATOM   1229  CD  GLU A 170      10.079  -4.860  25.593  1.00 21.11           C  
ATOM   1230  OE1 GLU A 170      10.937  -5.457  24.909  1.00 21.86           O  
ATOM   1231  OE2 GLU A 170       9.987  -4.987  26.835  1.00 22.55           O  
ATOM   1232  N   ALA A 171       5.789  -0.375  25.778  1.00 22.51           N  
ATOM   1233  CA  ALA A 171       5.134   0.600  26.634  1.00 23.61           C  
ATOM   1234  C   ALA A 171       4.543   0.019  27.897  1.00 25.07           C  
ATOM   1235  O   ALA A 171       4.642   0.634  28.964  1.00 27.52           O  
ATOM   1236  CB  ALA A 171       4.054   1.315  25.857  1.00 25.76           C  
ATOM   1237  N   ASP A 172       3.917  -1.150  27.779  1.00 24.22           N  
ATOM   1238  CA  ASP A 172       3.286  -1.793  28.924  1.00 25.52           C  
ATOM   1239  C   ASP A 172       4.307  -2.170  29.990  1.00 27.66           C  
ATOM   1240  O   ASP A 172       4.044  -2.065  31.196  1.00 27.53           O  
ATOM   1241  CB  ASP A 172       2.517  -3.032  28.468  1.00 26.66           C  
ATOM   1242  CG  ASP A 172       3.396  -4.034  27.738  1.00 29.50           C  
ATOM   1243  OD1 ASP A 172       4.554  -3.698  27.414  1.00 29.74           O  
ATOM   1244  OD2 ASP A 172       2.921  -5.159  27.476  1.00 31.49           O  
ATOM   1245  N   GLU A 173       5.476  -2.606  29.541  1.00 28.34           N  
ATOM   1246  CA  GLU A 173       6.542  -2.995  30.443  1.00 28.92           C  
ATOM   1247  C   GLU A 173       7.103  -1.749  31.116  1.00 29.06           C  
ATOM   1248  O   GLU A 173       7.334  -1.736  32.328  1.00 30.72           O  
ATOM   1249  CB  GLU A 173       7.639  -3.719  29.675  1.00 30.91           C  
ATOM   1250  CG  GLU A 173       8.179  -4.922  30.405  1.00 37.43           C  
ATOM   1251  CD  GLU A 173       7.109  -5.966  30.662  1.00 39.03           C  
ATOM   1252  OE1 GLU A 173       6.520  -6.474  29.682  1.00 39.92           O  
ATOM   1253  OE2 GLU A 173       6.853  -6.273  31.848  1.00 41.87           O  
HETATM 1254  N   MSE A 174       7.315  -0.690  30.344  1.00 26.84           N  
HETATM 1255  CA  MSE A 174       7.836   0.530  30.938  1.00 27.13           C  
HETATM 1256  C   MSE A 174       6.867   1.082  31.968  1.00 26.16           C  
HETATM 1257  O   MSE A 174       7.275   1.586  33.011  1.00 27.36           O  
HETATM 1258  CB  MSE A 174       8.099   1.601  29.877  1.00 26.19           C  
HETATM 1259  CG  MSE A 174       9.217   1.262  28.917  1.00 27.67           C  
HETATM 1260 SE   MSE A 174       9.833   2.844  27.990  1.00 30.25          SE  
HETATM 1261  CE  MSE A 174       8.338   3.130  26.814  1.00 25.23           C  
ATOM   1262  N   LEU A 175       5.579   1.001  31.668  1.00 25.18           N  
ATOM   1263  CA  LEU A 175       4.580   1.513  32.588  1.00 26.16           C  
ATOM   1264  C   LEU A 175       4.481   0.604  33.819  1.00 26.34           C  
ATOM   1265  O   LEU A 175       4.428   1.077  34.959  1.00 26.50           O  
ATOM   1266  CB  LEU A 175       3.234   1.639  31.861  1.00 26.23           C  
ATOM   1267  CG  LEU A 175       2.825   3.026  31.329  1.00 27.40           C  
ATOM   1268  CD1 LEU A 175       4.025   3.857  30.931  1.00 26.75           C  
ATOM   1269  CD2 LEU A 175       1.895   2.841  30.143  1.00 28.75           C  
ATOM   1270  N   SER A 176       4.491  -0.700  33.582  1.00 25.88           N  
ATOM   1271  CA  SER A 176       4.412  -1.675  34.652  1.00 25.22           C  
ATOM   1272  C   SER A 176       5.639  -1.572  35.564  1.00 25.08           C  
ATOM   1273  O   SER A 176       5.638  -2.068  36.689  1.00 23.55           O  
ATOM   1274  CB  SER A 176       4.325  -3.068  34.049  1.00 27.81           C  
ATOM   1275  OG  SER A 176       3.964  -4.010  35.033  1.00 33.91           O  
ATOM   1276  N   SER A 177       6.687  -0.923  35.065  1.00 24.22           N  
ATOM   1277  CA  SER A 177       7.915  -0.741  35.828  1.00 22.60           C  
ATOM   1278  C   SER A 177       7.905   0.574  36.575  1.00 21.91           C  
ATOM   1279  O   SER A 177       8.868   0.891  37.254  1.00 23.23           O  
ATOM   1280  CB  SER A 177       9.144  -0.769  34.918  1.00 20.82           C  
ATOM   1281  OG  SER A 177       9.377  -2.063  34.425  1.00 20.70           O  
ATOM   1282  N   GLY A 178       6.842   1.354  36.429  1.00 22.24           N  
ATOM   1283  CA  GLY A 178       6.769   2.624  37.143  1.00 24.27           C  
ATOM   1284  C   GLY A 178       7.269   3.891  36.457  1.00 25.11           C  
ATOM   1285  O   GLY A 178       7.399   4.927  37.111  1.00 25.36           O  
ATOM   1286  N   PHE A 179       7.528   3.840  35.150  1.00 25.50           N  
ATOM   1287  CA  PHE A 179       8.032   5.018  34.430  1.00 25.02           C  
ATOM   1288  C   PHE A 179       6.971   5.991  33.913  1.00 25.77           C  
ATOM   1289  O   PHE A 179       7.300   6.941  33.203  1.00 26.24           O  
ATOM   1290  CB  PHE A 179       8.906   4.577  33.255  1.00 21.99           C  
ATOM   1291  CG  PHE A 179      10.206   3.947  33.670  1.00 21.72           C  
ATOM   1292  CD1 PHE A 179      10.505   2.638  33.313  1.00 20.15           C  
ATOM   1293  CD2 PHE A 179      11.140   4.668  34.403  1.00 20.85           C  
ATOM   1294  CE1 PHE A 179      11.717   2.063  33.683  1.00 20.47           C  
ATOM   1295  CE2 PHE A 179      12.363   4.094  34.775  1.00 20.55           C  
ATOM   1296  CZ  PHE A 179      12.649   2.801  34.417  1.00 17.49           C  
ATOM   1297  N   LYS A 180       5.711   5.754  34.273  1.00 25.60           N  
ATOM   1298  CA  LYS A 180       4.600   6.591  33.838  1.00 27.60           C  
ATOM   1299  C   LYS A 180       4.851   8.100  33.982  1.00 29.94           C  
ATOM   1300  O   LYS A 180       4.802   8.844  32.998  1.00 30.05           O  
ATOM   1301  CB  LYS A 180       3.330   6.182  34.603  1.00 29.32           C  
ATOM   1302  CG  LYS A 180       2.053   6.993  34.314  1.00 29.21           C  
ATOM   1303  CD  LYS A 180       0.874   6.389  35.075  1.00 31.27           C  
ATOM   1304  CE  LYS A 180      -0.225   7.400  35.381  1.00 33.88           C  
ATOM   1305  NZ  LYS A 180      -0.906   7.922  34.168  1.00 37.36           N  
ATOM   1306  N   GLU A 181       5.126   8.549  35.199  1.00 30.26           N  
ATOM   1307  CA  GLU A 181       5.363   9.963  35.430  1.00 32.30           C  
ATOM   1308  C   GLU A 181       6.441  10.533  34.527  1.00 31.10           C  
ATOM   1309  O   GLU A 181       6.245  11.574  33.893  1.00 31.71           O  
ATOM   1310  CB  GLU A 181       5.718  10.213  36.898  1.00 36.70           C  
ATOM   1311  CG  GLU A 181       6.370   9.027  37.623  1.00 45.64           C  
ATOM   1312  CD  GLU A 181       5.374   7.926  38.025  1.00 48.53           C  
ATOM   1313  OE1 GLU A 181       5.035   7.062  37.182  1.00 47.53           O  
ATOM   1314  OE2 GLU A 181       4.929   7.934  39.198  1.00 51.85           O  
ATOM   1315  N   GLN A 182       7.577   9.848  34.455  1.00 29.26           N  
ATOM   1316  CA  GLN A 182       8.677  10.310  33.621  1.00 27.58           C  
ATOM   1317  C   GLN A 182       8.308  10.347  32.140  1.00 25.68           C  
ATOM   1318  O   GLN A 182       8.650  11.295  31.435  1.00 22.87           O  
ATOM   1319  CB  GLN A 182       9.910   9.428  33.826  1.00 29.56           C  
ATOM   1320  CG  GLN A 182      10.469   9.472  35.239  1.00 32.11           C  
ATOM   1321  CD  GLN A 182      10.052   8.271  36.069  1.00 33.86           C  
ATOM   1322  OE1 GLN A 182       8.911   7.800  35.982  1.00 36.13           O  
ATOM   1323  NE2 GLN A 182      10.971   7.776  36.886  1.00 33.64           N  
ATOM   1324  N   ILE A 183       7.609   9.322  31.663  1.00 24.34           N  
ATOM   1325  CA  ILE A 183       7.223   9.305  30.260  1.00 23.43           C  
ATOM   1326  C   ILE A 183       6.307  10.493  29.967  1.00 25.00           C  
ATOM   1327  O   ILE A 183       6.459  11.162  28.936  1.00 25.17           O  
ATOM   1328  CB  ILE A 183       6.527   7.977  29.884  1.00 20.34           C  
ATOM   1329  CG1 ILE A 183       7.557   6.841  29.874  1.00 16.59           C  
ATOM   1330  CG2 ILE A 183       5.859   8.102  28.521  1.00 19.88           C  
ATOM   1331  CD1 ILE A 183       6.977   5.473  29.591  1.00 16.77           C  
ATOM   1332  N   TYR A 184       5.370  10.758  30.881  1.00 25.22           N  
ATOM   1333  CA  TYR A 184       4.446  11.881  30.735  1.00 25.79           C  
ATOM   1334  C   TYR A 184       5.205  13.194  30.733  1.00 26.43           C  
ATOM   1335  O   TYR A 184       4.921  14.073  29.932  1.00 28.41           O  
ATOM   1336  CB  TYR A 184       3.411  11.896  31.862  1.00 24.40           C  
ATOM   1337  CG  TYR A 184       2.238  10.964  31.649  1.00 24.84           C  
ATOM   1338  CD1 TYR A 184       2.439   9.601  31.439  1.00 24.79           C  
ATOM   1339  CD2 TYR A 184       0.925  11.433  31.697  1.00 25.13           C  
ATOM   1340  CE1 TYR A 184       1.370   8.727  31.288  1.00 25.44           C  
ATOM   1341  CE2 TYR A 184      -0.159  10.560  31.549  1.00 25.11           C  
ATOM   1342  CZ  TYR A 184       0.074   9.208  31.347  1.00 26.18           C  
ATOM   1343  OH  TYR A 184      -0.976   8.319  31.229  1.00 26.52           O  
ATOM   1344  N   GLN A 185       6.172  13.332  31.632  1.00 28.40           N  
ATOM   1345  CA  GLN A 185       6.968  14.556  31.690  1.00 30.45           C  
ATOM   1346  C   GLN A 185       7.742  14.779  30.393  1.00 30.20           C  
ATOM   1347  O   GLN A 185       7.807  15.900  29.880  1.00 31.17           O  
ATOM   1348  CB  GLN A 185       7.947  14.501  32.864  1.00 32.35           C  
ATOM   1349  CG  GLN A 185       7.320  14.807  34.214  1.00 38.70           C  
ATOM   1350  CD  GLN A 185       6.917  16.268  34.352  1.00 42.45           C  
ATOM   1351  OE1 GLN A 185       6.015  16.750  33.660  1.00 43.81           O  
ATOM   1352  NE2 GLN A 185       7.593  16.984  35.248  1.00 44.52           N  
ATOM   1353  N   ILE A 186       8.329  13.711  29.861  1.00 28.20           N  
ATOM   1354  CA  ILE A 186       9.094  13.812  28.633  1.00 26.26           C  
ATOM   1355  C   ILE A 186       8.226  14.337  27.486  1.00 26.10           C  
ATOM   1356  O   ILE A 186       8.658  15.215  26.738  1.00 25.82           O  
ATOM   1357  CB  ILE A 186       9.727  12.439  28.271  1.00 26.13           C  
ATOM   1358  CG1 ILE A 186      10.821  12.103  29.289  1.00 23.35           C  
ATOM   1359  CG2 ILE A 186      10.308  12.461  26.862  1.00 23.69           C  
ATOM   1360  CD1 ILE A 186      11.503  10.785  29.044  1.00 22.98           C  
ATOM   1361  N   PHE A 187       7.011  13.811  27.350  1.00 24.57           N  
ATOM   1362  CA  PHE A 187       6.108  14.266  26.286  1.00 24.69           C  
ATOM   1363  C   PHE A 187       5.990  15.796  26.290  1.00 25.14           C  
ATOM   1364  O   PHE A 187       6.005  16.438  25.240  1.00 23.08           O  
ATOM   1365  CB  PHE A 187       4.699  13.675  26.459  1.00 22.87           C  
ATOM   1366  CG  PHE A 187       4.488  12.337  25.790  1.00 21.96           C  
ATOM   1367  CD1 PHE A 187       4.245  11.192  26.551  1.00 21.79           C  
ATOM   1368  CD2 PHE A 187       4.462  12.230  24.405  1.00 20.51           C  
ATOM   1369  CE1 PHE A 187       3.969   9.959  25.941  1.00 21.07           C  
ATOM   1370  CE2 PHE A 187       4.188  11.007  23.787  1.00 21.62           C  
ATOM   1371  CZ  PHE A 187       3.939   9.868  24.557  1.00 20.79           C  
ATOM   1372  N   THR A 188       5.873  16.377  27.478  1.00 26.99           N  
ATOM   1373  CA  THR A 188       5.726  17.826  27.589  1.00 29.32           C  
ATOM   1374  C   THR A 188       7.043  18.537  27.313  1.00 30.79           C  
ATOM   1375  O   THR A 188       7.059  19.711  26.942  1.00 33.31           O  
ATOM   1376  CB  THR A 188       5.218  18.242  28.989  1.00 27.91           C  
ATOM   1377  OG1 THR A 188       6.332  18.512  29.845  1.00 27.85           O  
ATOM   1378  CG2 THR A 188       4.385  17.130  29.601  1.00 27.80           C  
ATOM   1379  N   LEU A 189       8.145  17.816  27.497  1.00 31.15           N  
ATOM   1380  CA  LEU A 189       9.470  18.369  27.261  1.00 31.20           C  
ATOM   1381  C   LEU A 189       9.912  18.195  25.812  1.00 31.69           C  
ATOM   1382  O   LEU A 189      11.005  18.609  25.434  1.00 34.16           O  
ATOM   1383  CB  LEU A 189      10.486  17.709  28.194  1.00 31.06           C  
ATOM   1384  CG  LEU A 189      10.389  18.086  29.680  1.00 33.91           C  
ATOM   1385  CD1 LEU A 189      11.262  17.144  30.506  1.00 31.58           C  
ATOM   1386  CD2 LEU A 189      10.819  19.545  29.879  1.00 29.49           C  
ATOM   1387  N   LEU A 190       9.070  17.573  24.996  1.00 30.53           N  
ATOM   1388  CA  LEU A 190       9.403  17.369  23.592  1.00 29.47           C  
ATOM   1389  C   LEU A 190       8.560  18.292  22.724  1.00 28.61           C  
ATOM   1390  O   LEU A 190       7.439  18.639  23.088  1.00 28.70           O  
ATOM   1391  CB  LEU A 190       9.152  15.906  23.186  1.00 28.83           C  
ATOM   1392  CG  LEU A 190      10.286  14.874  23.308  1.00 30.38           C  
ATOM   1393  CD1 LEU A 190      10.848  14.875  24.697  1.00 30.17           C  
ATOM   1394  CD2 LEU A 190       9.765  13.483  22.957  1.00 29.63           C  
ATOM   1395  N   PRO A 191       9.095  18.725  21.574  1.00 28.87           N  
ATOM   1396  CA  PRO A 191       8.274  19.602  20.743  1.00 29.38           C  
ATOM   1397  C   PRO A 191       6.905  18.965  20.503  1.00 32.25           C  
ATOM   1398  O   PRO A 191       6.802  17.803  20.115  1.00 32.85           O  
ATOM   1399  CB  PRO A 191       9.106  19.775  19.472  1.00 27.01           C  
ATOM   1400  CG  PRO A 191      10.190  18.733  19.569  1.00 27.83           C  
ATOM   1401  CD  PRO A 191      10.449  18.591  21.022  1.00 28.24           C  
ATOM   1402  N   PRO A 192       5.833  19.739  20.735  1.00 34.22           N  
ATOM   1403  CA  PRO A 192       4.416  19.373  20.598  1.00 33.34           C  
ATOM   1404  C   PRO A 192       4.017  18.543  19.387  1.00 31.60           C  
ATOM   1405  O   PRO A 192       3.161  17.667  19.490  1.00 31.44           O  
ATOM   1406  CB  PRO A 192       3.710  20.730  20.627  1.00 34.50           C  
ATOM   1407  CG  PRO A 192       4.731  21.646  20.020  1.00 35.93           C  
ATOM   1408  CD  PRO A 192       5.976  21.205  20.745  1.00 34.72           C  
ATOM   1409  N   THR A 193       4.630  18.805  18.242  1.00 30.98           N  
ATOM   1410  CA  THR A 193       4.279  18.055  17.041  1.00 30.87           C  
ATOM   1411  C   THR A 193       4.986  16.710  16.882  1.00 28.43           C  
ATOM   1412  O   THR A 193       4.652  15.940  15.979  1.00 28.63           O  
ATOM   1413  CB  THR A 193       4.543  18.883  15.770  1.00 31.14           C  
ATOM   1414  OG1 THR A 193       5.907  19.322  15.762  1.00 30.28           O  
ATOM   1415  CG2 THR A 193       3.607  20.078  15.720  1.00 31.16           C  
ATOM   1416  N   THR A 194       5.954  16.425  17.745  1.00 24.68           N  
ATOM   1417  CA  THR A 194       6.685  15.163  17.658  1.00 23.36           C  
ATOM   1418  C   THR A 194       5.805  13.944  17.327  1.00 20.39           C  
ATOM   1419  O   THR A 194       4.755  13.722  17.927  1.00 18.19           O  
ATOM   1420  CB  THR A 194       7.448  14.872  18.971  1.00 25.17           C  
ATOM   1421  OG1 THR A 194       8.444  15.885  19.182  1.00 28.85           O  
ATOM   1422  CG2 THR A 194       8.136  13.507  18.900  1.00 24.66           C  
ATOM   1423  N   GLN A 195       6.235  13.170  16.344  1.00 17.15           N  
ATOM   1424  CA  GLN A 195       5.515  11.965  15.962  1.00 16.73           C  
ATOM   1425  C   GLN A 195       5.696  10.960  17.112  1.00 16.26           C  
ATOM   1426  O   GLN A 195       6.792  10.809  17.663  1.00 15.37           O  
ATOM   1427  CB  GLN A 195       6.097  11.417  14.653  1.00 16.00           C  
ATOM   1428  CG  GLN A 195       5.513  10.111  14.161  1.00 15.14           C  
ATOM   1429  CD  GLN A 195       6.171   9.643  12.874  1.00 15.83           C  
ATOM   1430  OE1 GLN A 195       5.724   8.692  12.240  1.00 17.57           O  
ATOM   1431  NE2 GLN A 195       7.239  10.313  12.485  1.00 14.82           N  
ATOM   1432  N   VAL A 196       4.616  10.289  17.484  1.00 14.01           N  
ATOM   1433  CA  VAL A 196       4.674   9.335  18.575  1.00 12.97           C  
ATOM   1434  C   VAL A 196       4.475   7.897  18.074  1.00 13.87           C  
ATOM   1435  O   VAL A 196       3.511   7.602  17.363  1.00 13.27           O  
ATOM   1436  CB  VAL A 196       3.610   9.708  19.642  1.00 13.20           C  
ATOM   1437  CG1 VAL A 196       3.546   8.657  20.740  1.00  9.68           C  
ATOM   1438  CG2 VAL A 196       3.940  11.090  20.222  1.00  9.47           C  
ATOM   1439  N   VAL A 197       5.407   7.014  18.415  1.00 11.87           N  
ATOM   1440  CA  VAL A 197       5.303   5.618  17.999  1.00 13.53           C  
ATOM   1441  C   VAL A 197       5.366   4.773  19.251  1.00 13.56           C  
ATOM   1442  O   VAL A 197       6.297   4.918  20.048  1.00 13.18           O  
ATOM   1443  CB  VAL A 197       6.445   5.192  17.041  1.00 13.06           C  
ATOM   1444  CG1 VAL A 197       6.371   3.691  16.776  1.00 13.40           C  
ATOM   1445  CG2 VAL A 197       6.330   5.938  15.732  1.00 12.05           C  
ATOM   1446  N   LEU A 198       4.374   3.899  19.416  1.00 13.15           N  
ATOM   1447  CA  LEU A 198       4.288   3.055  20.599  1.00 14.69           C  
ATOM   1448  C   LEU A 198       4.080   1.563  20.284  1.00 16.25           C  
ATOM   1449  O   LEU A 198       3.059   1.159  19.721  1.00 13.84           O  
ATOM   1450  CB  LEU A 198       3.164   3.568  21.510  1.00 14.57           C  
ATOM   1451  CG  LEU A 198       2.963   2.940  22.903  1.00 17.28           C  
ATOM   1452  CD1 LEU A 198       2.042   3.841  23.712  1.00 14.41           C  
ATOM   1453  CD2 LEU A 198       2.383   1.512  22.800  1.00 14.60           C  
ATOM   1454  N   LEU A 199       5.077   0.762  20.656  1.00 14.84           N  
ATOM   1455  CA  LEU A 199       5.054  -0.667  20.453  1.00 15.95           C  
ATOM   1456  C   LEU A 199       4.795  -1.309  21.807  1.00 17.32           C  
ATOM   1457  O   LEU A 199       5.445  -0.960  22.793  1.00 17.35           O  
ATOM   1458  CB  LEU A 199       6.396  -1.154  19.916  1.00 13.86           C  
ATOM   1459  CG  LEU A 199       6.966  -0.512  18.651  1.00 15.04           C  
ATOM   1460  CD1 LEU A 199       5.888  -0.500  17.585  1.00 15.71           C  
ATOM   1461  CD2 LEU A 199       7.479   0.914  18.948  1.00 14.25           C  
ATOM   1462  N   SER A 200       3.844  -2.241  21.856  1.00 17.91           N  
ATOM   1463  CA  SER A 200       3.524  -2.923  23.104  1.00 18.87           C  
ATOM   1464  C   SER A 200       2.838  -4.273  22.874  1.00 19.98           C  
ATOM   1465  O   SER A 200       1.875  -4.374  22.117  1.00 20.77           O  
ATOM   1466  CB  SER A 200       2.637  -2.036  23.977  1.00 17.91           C  
ATOM   1467  OG  SER A 200       2.415  -2.637  25.239  1.00 20.22           O  
ATOM   1468  N   ALA A 201       3.343  -5.308  23.538  1.00 19.80           N  
ATOM   1469  CA  ALA A 201       2.779  -6.644  23.406  1.00 20.43           C  
ATOM   1470  C   ALA A 201       1.305  -6.694  23.856  1.00 21.34           C  
ATOM   1471  O   ALA A 201       0.479  -7.355  23.223  1.00 19.44           O  
ATOM   1472  CB  ALA A 201       3.613  -7.627  24.211  1.00 17.41           C  
ATOM   1473  N   THR A 202       0.990  -5.987  24.940  1.00 21.42           N  
ATOM   1474  CA  THR A 202      -0.370  -5.944  25.480  1.00 21.82           C  
ATOM   1475  C   THR A 202      -0.925  -4.516  25.442  1.00 22.55           C  
ATOM   1476  O   THR A 202      -0.169  -3.538  25.389  1.00 23.10           O  
ATOM   1477  CB  THR A 202      -0.405  -6.459  26.949  1.00 21.37           C  
ATOM   1478  OG1 THR A 202       0.265  -5.529  27.819  1.00 18.88           O  
ATOM   1479  CG2 THR A 202       0.296  -7.812  27.045  1.00 18.50           C  
HETATM 1480  N   MSE A 203      -2.245  -4.394  25.471  1.00 21.29           N  
HETATM 1481  CA  MSE A 203      -2.868  -3.078  25.435  1.00 21.84           C  
HETATM 1482  C   MSE A 203      -3.681  -2.782  26.686  1.00 21.75           C  
HETATM 1483  O   MSE A 203      -4.894  -2.608  26.612  1.00 22.44           O  
HETATM 1484  CB  MSE A 203      -3.776  -2.946  24.208  1.00 20.22           C  
HETATM 1485  CG  MSE A 203      -3.063  -2.891  22.873  1.00 21.15           C  
HETATM 1486 SE   MSE A 203      -1.868  -1.365  22.672  1.00 26.41          SE  
HETATM 1487  CE  MSE A 203      -3.125   0.080  22.792  1.00 27.95           C  
ATOM   1488  N   PRO A 204      -3.029  -2.711  27.855  1.00 22.18           N  
ATOM   1489  CA  PRO A 204      -3.761  -2.426  29.095  1.00 22.11           C  
ATOM   1490  C   PRO A 204      -4.166  -0.953  29.154  1.00 24.72           C  
ATOM   1491  O   PRO A 204      -3.724  -0.151  28.332  1.00 25.01           O  
ATOM   1492  CB  PRO A 204      -2.757  -2.787  30.170  1.00 18.38           C  
ATOM   1493  CG  PRO A 204      -1.474  -2.316  29.558  1.00 21.37           C  
ATOM   1494  CD  PRO A 204      -1.582  -2.821  28.116  1.00 21.85           C  
ATOM   1495  N   ASN A 205      -4.993  -0.598  30.131  1.00 26.95           N  
ATOM   1496  CA  ASN A 205      -5.452   0.777  30.267  1.00 28.48           C  
ATOM   1497  C   ASN A 205      -4.314   1.777  30.336  1.00 27.25           C  
ATOM   1498  O   ASN A 205      -4.443   2.872  29.808  1.00 24.45           O  
ATOM   1499  CB  ASN A 205      -6.336   0.929  31.508  1.00 34.71           C  
ATOM   1500  CG  ASN A 205      -7.451  -0.100  31.557  1.00 39.90           C  
ATOM   1501  OD1 ASN A 205      -8.305  -0.162  30.661  1.00 42.42           O  
ATOM   1502  ND2 ASN A 205      -7.448  -0.922  32.607  1.00 41.77           N  
ATOM   1503  N   ASP A 206      -3.214   1.412  30.999  1.00 28.26           N  
ATOM   1504  CA  ASP A 206      -2.063   2.311  31.106  1.00 30.20           C  
ATOM   1505  C   ASP A 206      -1.661   2.764  29.707  1.00 29.97           C  
ATOM   1506  O   ASP A 206      -1.371   3.934  29.473  1.00 29.40           O  
ATOM   1507  CB  ASP A 206      -0.840   1.617  31.717  1.00 35.57           C  
ATOM   1508  CG  ASP A 206      -1.113   0.995  33.069  1.00 39.94           C  
ATOM   1509  OD1 ASP A 206      -1.781   1.649  33.897  1.00 39.92           O  
ATOM   1510  OD2 ASP A 206      -0.630  -0.147  33.297  1.00 42.29           O  
ATOM   1511  N   VAL A 207      -1.625   1.808  28.784  1.00 29.03           N  
ATOM   1512  CA  VAL A 207      -1.252   2.088  27.409  1.00 28.58           C  
ATOM   1513  C   VAL A 207      -2.335   2.893  26.711  1.00 28.10           C  
ATOM   1514  O   VAL A 207      -2.052   3.880  26.040  1.00 29.51           O  
ATOM   1515  CB  VAL A 207      -1.019   0.782  26.631  1.00 29.09           C  
ATOM   1516  CG1 VAL A 207      -0.667   1.093  25.194  1.00 28.60           C  
ATOM   1517  CG2 VAL A 207       0.094  -0.029  27.296  1.00 29.00           C  
ATOM   1518  N   LEU A 208      -3.578   2.464  26.870  1.00 26.12           N  
ATOM   1519  CA  LEU A 208      -4.691   3.155  26.253  1.00 24.67           C  
ATOM   1520  C   LEU A 208      -4.731   4.603  26.714  1.00 23.06           C  
ATOM   1521  O   LEU A 208      -5.054   5.489  25.944  1.00 22.89           O  
ATOM   1522  CB  LEU A 208      -6.004   2.442  26.603  1.00 26.23           C  
ATOM   1523  CG  LEU A 208      -6.434   1.231  25.761  1.00 28.32           C  
ATOM   1524  CD1 LEU A 208      -5.256   0.336  25.428  1.00 30.55           C  
ATOM   1525  CD2 LEU A 208      -7.476   0.455  26.518  1.00 29.50           C  
ATOM   1526  N   GLU A 209      -4.391   4.840  27.972  1.00 22.54           N  
ATOM   1527  CA  GLU A 209      -4.394   6.187  28.513  1.00 23.49           C  
ATOM   1528  C   GLU A 209      -3.320   7.019  27.821  1.00 24.84           C  
ATOM   1529  O   GLU A 209      -3.557   8.166  27.434  1.00 24.45           O  
ATOM   1530  CB  GLU A 209      -4.139   6.149  30.018  1.00 25.96           C  
ATOM   1531  CG  GLU A 209      -4.241   7.491  30.712  1.00 28.98           C  
ATOM   1532  CD  GLU A 209      -3.924   7.396  32.190  1.00 34.11           C  
ATOM   1533  OE1 GLU A 209      -4.482   6.488  32.852  1.00 33.33           O  
ATOM   1534  OE2 GLU A 209      -3.124   8.230  32.690  1.00 36.05           O  
ATOM   1535  N   VAL A 210      -2.131   6.448  27.670  1.00 24.33           N  
ATOM   1536  CA  VAL A 210      -1.064   7.170  26.999  1.00 24.68           C  
ATOM   1537  C   VAL A 210      -1.524   7.498  25.587  1.00 23.69           C  
ATOM   1538  O   VAL A 210      -1.425   8.631  25.140  1.00 22.67           O  
ATOM   1539  CB  VAL A 210       0.224   6.329  26.931  1.00 24.04           C  
ATOM   1540  CG1 VAL A 210       1.222   6.970  25.971  1.00 23.30           C  
ATOM   1541  CG2 VAL A 210       0.831   6.223  28.315  1.00 26.58           C  
ATOM   1542  N   THR A 211      -2.035   6.487  24.901  1.00 25.21           N  
ATOM   1543  CA  THR A 211      -2.516   6.636  23.540  1.00 28.54           C  
ATOM   1544  C   THR A 211      -3.530   7.761  23.387  1.00 29.63           C  
ATOM   1545  O   THR A 211      -3.405   8.604  22.488  1.00 30.83           O  
ATOM   1546  CB  THR A 211      -3.144   5.329  23.041  1.00 28.56           C  
ATOM   1547  OG1 THR A 211      -2.104   4.384  22.753  1.00 31.64           O  
ATOM   1548  CG2 THR A 211      -3.962   5.572  21.797  1.00 30.80           C  
ATOM   1549  N   THR A 212      -4.524   7.784  24.266  1.00 28.84           N  
ATOM   1550  CA  THR A 212      -5.557   8.809  24.190  1.00 30.05           C  
ATOM   1551  C   THR A 212      -5.083  10.212  24.569  1.00 28.87           C  
ATOM   1552  O   THR A 212      -5.529  11.206  23.990  1.00 29.49           O  
ATOM   1553  CB  THR A 212      -6.776   8.456  25.071  1.00 30.22           C  
ATOM   1554  OG1 THR A 212      -7.816   9.412  24.833  1.00 33.14           O  
ATOM   1555  CG2 THR A 212      -6.411   8.490  26.545  1.00 29.47           C  
ATOM   1556  N   LYS A 213      -4.166  10.292  25.520  1.00 27.00           N  
ATOM   1557  CA  LYS A 213      -3.671  11.574  25.983  1.00 25.45           C  
ATOM   1558  C   LYS A 213      -2.586  12.201  25.131  1.00 24.86           C  
ATOM   1559  O   LYS A 213      -2.487  13.422  25.075  1.00 27.60           O  
ATOM   1560  CB  LYS A 213      -3.186  11.437  27.423  1.00 28.51           C  
ATOM   1561  CG  LYS A 213      -2.611  12.696  28.031  1.00 32.04           C  
ATOM   1562  CD  LYS A 213      -2.398  12.498  29.532  1.00 36.03           C  
ATOM   1563  CE  LYS A 213      -1.656  13.675  30.152  1.00 37.75           C  
ATOM   1564  NZ  LYS A 213      -2.300  14.982  29.837  1.00 38.96           N  
ATOM   1565  N   PHE A 214      -1.783  11.395  24.446  1.00 23.12           N  
ATOM   1566  CA  PHE A 214      -0.715  11.971  23.643  1.00 22.98           C  
ATOM   1567  C   PHE A 214      -0.717  11.708  22.144  1.00 23.56           C  
ATOM   1568  O   PHE A 214      -0.104  12.459  21.388  1.00 25.60           O  
ATOM   1569  CB  PHE A 214       0.643  11.560  24.199  1.00 23.74           C  
ATOM   1570  CG  PHE A 214       0.853  11.956  25.620  1.00 25.22           C  
ATOM   1571  CD1 PHE A 214       0.731  11.023  26.639  1.00 26.48           C  
ATOM   1572  CD2 PHE A 214       1.161  13.265  25.944  1.00 25.88           C  
ATOM   1573  CE1 PHE A 214       0.919  11.391  27.965  1.00 26.79           C  
ATOM   1574  CE2 PHE A 214       1.348  13.641  27.264  1.00 26.37           C  
ATOM   1575  CZ  PHE A 214       1.228  12.699  28.276  1.00 26.95           C  
HETATM 1576  N   MSE A 215      -1.389  10.664  21.690  1.00 24.29           N  
HETATM 1577  CA  MSE A 215      -1.376  10.407  20.263  1.00 25.65           C  
HETATM 1578  C   MSE A 215      -2.515  11.104  19.513  1.00 26.09           C  
HETATM 1579  O   MSE A 215      -3.596  11.333  20.055  1.00 25.29           O  
HETATM 1580  CB  MSE A 215      -1.367   8.902  20.030  1.00 26.15           C  
HETATM 1581  CG  MSE A 215      -0.210   8.250  20.754  1.00 27.36           C  
HETATM 1582 SE   MSE A 215      -0.045   6.358  20.472  1.00 28.73          SE  
HETATM 1583  CE  MSE A 215       0.721   6.402  18.721  1.00 26.46           C  
ATOM   1584  N   ARG A 216      -2.255  11.456  18.262  1.00 26.51           N  
ATOM   1585  CA  ARG A 216      -3.248  12.147  17.459  1.00 27.30           C  
ATOM   1586  C   ARG A 216      -3.762  11.307  16.301  1.00 24.34           C  
ATOM   1587  O   ARG A 216      -3.025  11.035  15.362  1.00 21.68           O  
ATOM   1588  CB  ARG A 216      -2.660  13.467  16.929  1.00 31.79           C  
ATOM   1589  CG  ARG A 216      -2.222  14.418  18.039  1.00 38.59           C  
ATOM   1590  CD  ARG A 216      -1.942  15.847  17.555  1.00 43.97           C  
ATOM   1591  NE  ARG A 216      -0.718  15.986  16.758  1.00 48.29           N  
ATOM   1592  CZ  ARG A 216      -0.675  15.980  15.426  1.00 49.49           C  
ATOM   1593  NH1 ARG A 216      -1.797  15.837  14.720  1.00 48.65           N  
ATOM   1594  NH2 ARG A 216       0.491  16.126  14.798  1.00 47.48           N  
ATOM   1595  N   ASN A 217      -5.025  10.898  16.381  1.00 21.62           N  
ATOM   1596  CA  ASN A 217      -5.637  10.113  15.321  1.00 21.64           C  
ATOM   1597  C   ASN A 217      -4.584   9.183  14.737  1.00 20.54           C  
ATOM   1598  O   ASN A 217      -4.285   9.203  13.538  1.00 19.96           O  
ATOM   1599  CB  ASN A 217      -6.150  11.037  14.229  1.00 23.02           C  
ATOM   1600  CG  ASN A 217      -6.909  10.300  13.172  1.00 24.92           C  
ATOM   1601  OD1 ASN A 217      -7.017  10.766  12.039  1.00 28.05           O  
ATOM   1602  ND2 ASN A 217      -7.452   9.137  13.532  1.00 24.97           N  
ATOM   1603  N   PRO A 218      -4.022   8.335  15.593  1.00 18.75           N  
ATOM   1604  CA  PRO A 218      -2.985   7.376  15.243  1.00 15.96           C  
ATOM   1605  C   PRO A 218      -3.459   6.198  14.432  1.00 17.57           C  
ATOM   1606  O   PRO A 218      -4.627   5.814  14.486  1.00 16.63           O  
ATOM   1607  CB  PRO A 218      -2.493   6.930  16.599  1.00 17.14           C  
ATOM   1608  CG  PRO A 218      -3.801   6.851  17.373  1.00 15.50           C  
ATOM   1609  CD  PRO A 218      -4.493   8.125  16.980  1.00 16.24           C  
ATOM   1610  N   VAL A 219      -2.548   5.622  13.663  1.00 17.94           N  
ATOM   1611  CA  VAL A 219      -2.918   4.434  12.938  1.00 17.76           C  
ATOM   1612  C   VAL A 219      -2.790   3.400  14.059  1.00 19.52           C  
ATOM   1613  O   VAL A 219      -1.890   3.490  14.906  1.00 18.50           O  
ATOM   1614  CB  VAL A 219      -1.939   4.113  11.777  1.00 16.15           C  
ATOM   1615  CG1 VAL A 219      -1.524   5.392  11.078  1.00  9.80           C  
ATOM   1616  CG2 VAL A 219      -0.779   3.312  12.277  1.00 12.02           C  
ATOM   1617  N   ARG A 220      -3.706   2.444  14.089  1.00 20.34           N  
ATOM   1618  CA  ARG A 220      -3.684   1.422  15.119  1.00 19.76           C  
ATOM   1619  C   ARG A 220      -3.536   0.060  14.463  1.00 20.00           C  
ATOM   1620  O   ARG A 220      -4.325  -0.327  13.596  1.00 20.17           O  
ATOM   1621  CB  ARG A 220      -4.975   1.487  15.942  1.00 20.16           C  
ATOM   1622  CG  ARG A 220      -5.214   2.820  16.645  1.00 20.36           C  
ATOM   1623  CD  ARG A 220      -6.653   2.923  17.128  1.00 21.74           C  
ATOM   1624  NE  ARG A 220      -6.975   4.226  17.712  1.00 24.12           N  
ATOM   1625  CZ  ARG A 220      -6.813   4.541  18.999  1.00 26.39           C  
ATOM   1626  NH1 ARG A 220      -7.133   5.753  19.429  1.00 25.40           N  
ATOM   1627  NH2 ARG A 220      -6.343   3.648  19.863  1.00 25.14           N  
ATOM   1628  N   ILE A 221      -2.502  -0.658  14.871  1.00 19.84           N  
ATOM   1629  CA  ILE A 221      -2.227  -1.983  14.337  1.00 20.03           C  
ATOM   1630  C   ILE A 221      -2.302  -2.917  15.536  1.00 21.70           C  
ATOM   1631  O   ILE A 221      -1.356  -3.026  16.304  1.00 24.15           O  
ATOM   1632  CB  ILE A 221      -0.827  -2.010  13.711  1.00 19.21           C  
ATOM   1633  CG1 ILE A 221      -0.769  -0.978  12.580  1.00 17.52           C  
ATOM   1634  CG2 ILE A 221      -0.497  -3.412  13.218  1.00 17.72           C  
ATOM   1635  CD1 ILE A 221       0.623  -0.620  12.122  1.00 18.05           C  
ATOM   1636  N   LEU A 222      -3.437  -3.586  15.686  1.00 23.57           N  
ATOM   1637  CA  LEU A 222      -3.674  -4.460  16.823  1.00 25.26           C  
ATOM   1638  C   LEU A 222      -3.789  -5.942  16.512  1.00 27.39           C  
ATOM   1639  O   LEU A 222      -3.858  -6.350  15.358  1.00 27.00           O  
ATOM   1640  CB  LEU A 222      -4.946  -4.005  17.542  1.00 22.82           C  
ATOM   1641  CG  LEU A 222      -4.964  -2.558  18.045  1.00 23.94           C  
ATOM   1642  CD1 LEU A 222      -6.297  -2.264  18.747  1.00 21.51           C  
ATOM   1643  CD2 LEU A 222      -3.789  -2.336  18.997  1.00 20.05           C  
ATOM   1644  N   VAL A 223      -3.821  -6.743  17.569  1.00 30.44           N  
ATOM   1645  CA  VAL A 223      -3.946  -8.185  17.429  1.00 35.60           C  
ATOM   1646  C   VAL A 223      -5.382  -8.663  17.668  1.00 38.83           C  
ATOM   1647  O   VAL A 223      -5.984  -8.360  18.696  1.00 39.51           O  
ATOM   1648  CB  VAL A 223      -2.986  -8.918  18.394  1.00 35.21           C  
ATOM   1649  CG1 VAL A 223      -3.430 -10.357  18.587  1.00 34.30           C  
ATOM   1650  CG2 VAL A 223      -1.567  -8.875  17.827  1.00 32.54           C  
ATOM   1651  N   LYS A 224      -5.906  -9.401  16.691  1.00 42.44           N  
ATOM   1652  CA  LYS A 224      -7.257  -9.968  16.702  1.00 46.29           C  
ATOM   1653  C   LYS A 224      -8.037  -9.890  18.021  1.00 48.60           C  
ATOM   1654  O   LYS A 224      -9.019  -9.145  18.118  1.00 49.06           O  
ATOM   1655  CB  LYS A 224      -7.196 -11.424  16.224  1.00 47.01           C  
ATOM   1656  N   LYS A 225      -7.600 -10.673  19.012  1.00 50.73           N  
ATOM   1657  CA  LYS A 225      -8.218 -10.745  20.348  1.00 53.38           C  
ATOM   1658  C   LYS A 225      -9.246 -11.880  20.466  1.00 54.95           C  
ATOM   1659  O   LYS A 225     -10.402 -11.596  20.853  1.00 55.69           O  
ATOM   1660  CB  LYS A 225      -8.875  -9.400  20.725  1.00 52.59           C  
TER    1661      LYS A 225                                                      
END
MOLECULE T0477.pdb
ATOM      1  N   SER     1      -5.659  -3.669  -3.054  1.00 17.95           N
ATOM      2  CA  SER     1      -7.095  -3.767  -2.643  1.00 17.35           C
ATOM      3  CB  SER     1      -8.006  -3.336  -3.778  1.00 17.52           C
ATOM      4  OG  SER     1      -7.556  -3.920  -4.983  1.00 19.58           O
ATOM      5  C   SER     1      -7.406  -5.196  -2.216  1.00 16.26           C
ATOM      6  O   SER     1      -7.452  -5.474  -1.016  1.00 15.55           O
ATOM      7  N   MET     2      -7.636  -6.090  -3.185  1.00 15.05           N
ATOM      8  CA  MET     2      -7.535  -7.518  -2.895  1.00 14.46           C
ATOM      9  CB  MET     2      -7.833  -8.357  -4.115  1.00 14.66           C
ATOM     10  CG  MET     2      -9.282  -8.693  -4.242  1.00 17.58           C
ATOM     11  SD  MET     2      -9.760 -10.089  -3.220  1.00 21.31           S
ATOM     12  CE  MET     2     -11.366 -10.405  -3.940  1.00 19.89           C
ATOM     13  C   MET     2      -6.145  -7.880  -2.369  1.00 13.11           C
ATOM     14  O   MET     2      -6.025  -8.668  -1.432  1.00 12.74           O
ATOM     15  N   LYS     3      -5.109  -7.331  -2.997  1.00 11.97           N
ATOM     16  CA  LYS     3      -3.733  -7.461  -2.521  1.00 11.94           C
ATOM     17  CB  LYS     3      -2.799  -6.595  -3.375  1.00 12.58           C
ATOM     18  CG  LYS     3      -2.014  -7.344  -4.446  1.00 15.44           C
ATOM     19  CD  LYS     3      -1.131  -6.388  -5.255  1.00 19.75           C
ATOM     20  CE  LYS     3      -1.957  -5.548  -6.242  1.00 21.62           C
ATOM     21  NZ  LYS     3      -1.229  -4.326  -6.698  1.00 21.88           N
ATOM     22  C   LYS     3      -3.600  -7.025  -1.054  1.00 11.20           C
ATOM     23  O   LYS     3      -3.057  -7.735  -0.218  1.00 10.86           O
ATOM     24  N   ILE     4      -4.114  -5.840  -0.760  1.00 10.33           N
ATOM     25  CA  ILE     4      -4.024  -5.242   0.550  1.00  9.80           C
ATOM     26  CB  ILE     4      -4.492  -3.780   0.479  1.00 10.33           C
ATOM     27  CG1 ILE     4      -3.621  -3.033  -0.527  1.00 10.13           C
ATOM     28  CD1 ILE     4      -2.180  -2.968  -0.117  1.00 13.19           C
ATOM     29  CG2 ILE     4      -4.447  -3.109   1.855  1.00 10.34           C
ATOM     30  C   ILE     4      -4.840  -5.997   1.569  1.00  9.20           C
ATOM     31  O   ILE     4      -4.358  -6.253   2.663  1.00  9.45           O
ATOM     32  N   ASN     5      -6.084  -6.335   1.224  1.00  7.85           N
ATOM     33  CA  ASN     5      -6.909  -7.155   2.093  1.00  7.06           C
ATOM     34  CB  ASN     5      -8.309  -7.400   1.482  1.00  7.38           C
ATOM     35  CG  ASN     5      -9.209  -6.155   1.522  1.00  9.03           C
ATOM     36  OD1 ASN     5      -8.895  -5.152   2.183  1.00 14.61           O
ATOM     37  ND2 ASN     5     -10.333  -6.220   0.810  1.00 10.87           N
ATOM     38  C   ASN     5      -6.229  -8.498   2.404  1.00  5.63           C
ATOM     39  O   ASN     5      -6.249  -8.982   3.543  1.00  5.56           O
ATOM     40  N   PHE     6      -5.638  -9.110   1.390  1.00  4.41           N
ATOM     41  CA  PHE     6      -4.878 -10.325   1.598  1.00  2.63           C
ATOM     42  CB  PHE     6      -4.282 -10.808   0.278  1.00  2.68           C
ATOM     43  CG  PHE     6      -3.341 -11.973   0.428  1.00  2.00           C
ATOM     44  CD1 PHE     6      -3.819 -13.269   0.457  1.00  2.00           C
ATOM     45  CE1 PHE     6      -2.963 -14.352   0.591  1.00  2.00           C
ATOM     46  CZ  PHE     6      -1.594 -14.134   0.678  1.00  2.00           C
ATOM     47  CE2 PHE     6      -1.094 -12.824   0.643  1.00  3.17           C
ATOM     48  CD2 PHE     6      -1.979 -11.756   0.517  1.00  2.77           C
ATOM     49  C   PHE     6      -3.767 -10.154   2.628  1.00  2.55           C
ATOM     50  O   PHE     6      -3.563 -11.008   3.493  1.00  2.00           O
ATOM     51  N   LEU     7      -3.014  -9.071   2.503  1.00  2.73           N
ATOM     52  CA  LEU     7      -1.892  -8.824   3.393  1.00  3.85           C
ATOM     53  CB  LEU     7      -1.215  -7.478   3.076  1.00  3.76           C
ATOM     54  CG  LEU     7      -0.192  -7.445   1.935  1.00  6.53           C
ATOM     55  CD1 LEU     7       0.496  -6.061   1.874  1.00  8.73           C
ATOM     56  CD2 LEU     7       0.852  -8.552   2.094  1.00  6.22           C
ATOM     57  C   LEU     7      -2.367  -8.814   4.835  1.00  3.44           C
ATOM     58  O   LEU     7      -1.824  -9.500   5.688  1.00  2.66           O
ATOM     59  N   ARG     8      -3.405  -8.032   5.082  1.00  3.96           N
ATOM     60  CA  ARG     8      -3.892  -7.848   6.429  1.00  4.55           C
ATOM     61  CB  ARG     8      -4.829  -6.655   6.487  1.00  4.13           C
ATOM     62  CG  ARG     8      -4.123  -5.294   6.366  1.00  4.29           C
ATOM     63  CD  ARG     8      -4.991  -4.240   6.966  1.00  7.06           C
ATOM     64  NE  ARG     8      -4.449  -2.888   6.846  1.00 10.41           N
ATOM     65  CZ  ARG     8      -4.948  -1.950   6.046  1.00  7.79           C
ATOM     66  NH1 ARG     8      -5.979  -2.236   5.281  1.00  7.63           N
ATOM     67  NH2 ARG     8      -4.392  -0.742   5.987  1.00  7.49           N
ATOM     68  C   ARG     8      -4.569  -9.123   6.949  1.00  5.35           C
ATOM     69  O   ARG     8      -4.409  -9.472   8.114  1.00  5.41           O
ATOM     70  N   ASN     9      -5.283  -9.840   6.084  1.00  5.63           N
ATOM     71  CA  ASN     9      -5.972 -11.056   6.534  1.00  6.49           C
ATOM     72  CB  ASN     9      -7.125 -11.439   5.576  1.00  7.74           C
ATOM     73  CG  ASN     9      -8.388 -10.566   5.779  1.00  9.38           C
ATOM     74  OD1 ASN     9      -9.383 -11.021   6.336  1.00 17.28           O
ATOM     75  ND2 ASN     9      -8.342  -9.330   5.337  1.00 12.60           N
ATOM     76  C   ASN     9      -4.992 -12.221   6.731  1.00  6.61           C
ATOM     77  O   ASN     9      -5.005 -12.885   7.777  1.00  5.28           O
ATOM     78  N   LYS    10      -4.112 -12.441   5.747  1.00  6.56           N
ATOM     79  CA  LYS    10      -3.100 -13.501   5.854  1.00  6.19           C
ATOM     80  CB  LYS    10      -2.251 -13.598   4.583  1.00  6.80           C
ATOM     81  CG  LYS    10      -1.160 -14.712   4.617  1.00  7.78           C
ATOM     82  CD  LYS    10      -1.740 -16.036   4.190  1.00  9.64           C
ATOM     83  CE  LYS    10      -0.693 -17.170   4.091  1.00 13.22           C
ATOM     84  NZ  LYS    10       0.570 -16.755   3.402  1.00 12.50           N
ATOM     85  C   LYS    10      -2.157 -13.309   7.047  1.00  6.31           C
ATOM     86  O   LYS    10      -1.809 -14.284   7.707  1.00  6.75           O
ATOM     87  N   HIS    11      -1.727 -12.071   7.312  1.00  5.77           N
ATOM     88  CA  HIS    11      -0.688 -11.842   8.338  1.00  5.29           C
ATOM     89  CB  HIS    11       0.428 -10.898   7.820  1.00  4.67           C
ATOM     90  CG  HIS    11       1.127 -11.403   6.587  1.00  5.24           C
ATOM     91  ND1 HIS    11       1.933 -12.523   6.587  1.00  3.26           N
ATOM     92  CE1 HIS    11       2.399 -12.731   5.372  1.00  6.26           C
ATOM     93  NE2 HIS    11       1.942 -11.772   4.585  1.00  7.13           N
ATOM     94  CD2 HIS    11       1.147 -10.930   5.318  1.00  5.65           C
ATOM     95  C   HIS    11      -1.274 -11.373   9.665  1.00  5.27           C
ATOM     96  O   HIS    11      -0.533 -11.015  10.597  1.00  5.26           O
ATOM     97  N   LYS    12      -2.606 -11.399   9.750  1.00  5.55           N
ATOM     98  CA  LYS    12      -3.344 -11.075  10.986  1.00  5.59           C
ATOM     99  CB  LYS    12      -3.030 -12.087  12.091  1.00  6.39           C
ATOM    100  CG  LYS    12      -3.151 -13.543  11.634  1.00  7.17           C
ATOM    101  CD  LYS    12      -4.545 -13.841  11.086  1.00 10.08           C
ATOM    102  CE  LYS    12      -4.682 -15.305  10.536  1.00 11.56           C
ATOM    103  NZ  LYS    12      -4.795 -16.289  11.651  1.00 12.60           N
ATOM    104  C   LYS    12      -3.096  -9.667  11.493  1.00  4.90           C
ATOM    105  O   LYS    12      -3.036  -9.419  12.708  1.00  4.82           O
ATOM    106  N   ILE    13      -2.991  -8.738  10.561  1.00  4.03           N
ATOM    107  CA  ILE    13      -2.760  -7.341  10.899  1.00  3.91           C
ATOM    108  CB  ILE    13      -2.127  -6.611   9.722  1.00  3.35           C
ATOM    109  CG1 ILE    13      -0.834  -7.306   9.290  1.00  5.05           C
ATOM    110  CD1 ILE    13      -0.265  -6.783   7.969  1.00  3.66           C
ATOM    111  CG2 ILE    13      -1.871  -5.166  10.075  1.00  3.40           C
ATOM    112  C   ILE    13      -4.078  -6.652  11.220  1.00  4.10           C
ATOM    113  O   ILE    13      -4.869  -6.340  10.314  1.00  4.62           O
ATOM    114  N   HIS    14      -4.324  -6.401  12.492  1.00  4.34           N
ATOM    115  CA  HIS    14      -5.564  -5.749  12.886  1.00  5.42           C
ATOM    116  CB  HIS    14      -6.072  -6.309  14.220  1.00  6.20           C
ATOM    117  CG  HIS    14      -6.502  -7.741  14.161  1.00  8.71           C
ATOM    118  ND1 HIS    14      -5.690  -8.778  14.565  1.00 15.22           N
ATOM    119  CE1 HIS    14      -6.325  -9.929  14.404  1.00 13.26           C
ATOM    120  NE2 HIS    14      -7.530  -9.671  13.928  1.00 15.10           N
ATOM    121  CD2 HIS    14      -7.671  -8.309  13.777  1.00 12.48           C
ATOM    122  C   HIS    14      -5.272  -4.283  13.064  1.00  5.47           C
ATOM    123  O   HIS    14      -4.397  -3.932  13.844  1.00  5.02           O
ATOM    124  N   VAL    15      -6.031  -3.425  12.392  1.00  5.61           N
ATOM    125  CA  VAL    15      -5.723  -1.999  12.385  1.00  5.96           C
ATOM    126  CB  VAL    15      -5.187  -1.551  11.006  1.00  6.55           C
ATOM    127  CG1 VAL    15      -3.953  -2.359  10.627  1.00  4.10           C
ATOM    128  CG2 VAL    15      -6.269  -1.725   9.880  1.00  7.69           C
ATOM    129  C   VAL    15      -6.965  -1.209  12.756  1.00  7.11           C
ATOM    130  O   VAL    15      -8.046  -1.508  12.267  1.00  7.66           O
ATOM    131  N   GLN    16      -6.830  -0.228  13.643  1.00  7.29           N
ATOM    132  CA  GLN    16      -7.942   0.680  13.920  1.00  8.99           C
ATOM    133  CB  GLN    16      -8.433   0.491  15.354  1.00  9.09           C
ATOM    134  CG  GLN    16      -9.941   0.475  15.522  1.00 14.25           C
ATOM    135  CD  GLN    16     -10.344   0.081  16.940  1.00 19.16           C
ATOM    136  OE1 GLN    16      -9.703  -0.776  17.558  1.00 23.17           O
ATOM    137  NE2 GLN    16     -11.393   0.705  17.462  1.00 20.49           N
ATOM    138  C   GLN    16      -7.426   2.098  13.721  1.00  8.81           C
ATOM    139  O   GLN    16      -6.240   2.368  13.967  1.00  7.01           O
ATOM    140  N   GLY    17      -8.301   2.996  13.258  1.00  8.72           N
ATOM    141  CA  GLY    17      -7.919   4.401  13.073  1.00  9.42           C
ATOM    142  C   GLY    17      -8.501   4.976  11.801  1.00  9.78           C
ATOM    143  O   GLY    17      -9.215   4.280  11.091  1.00  9.86           O
ATOM    144  N   THR    18      -8.213   6.241  11.504  1.00  9.63           N
ATOM    145  CA  THR    18      -8.760   6.853  10.300  1.00 10.09           C
ATOM    146  CB  THR    18      -9.633   8.120  10.631  1.00 10.26           C
ATOM    147  OG1 THR    18      -8.796   9.186  11.072  1.00 13.22           O
ATOM    148  CG2 THR    18     -10.639   7.806  11.735  1.00 10.14           C
ATOM    149  C   THR    18      -7.663   7.158   9.285  1.00  9.97           C
ATOM    150  O   THR    18      -6.531   7.432   9.668  1.00 10.18           O
ATOM    151  N   ASP    19      -7.978   7.070   7.994  1.00 10.12           N
ATOM    152  CA  ASP    19      -7.008   7.388   6.939  1.00 10.87           C
ATOM    153  CB  ASP    19      -6.568   8.847   7.076  1.00 11.72           C
ATOM    154  CG  ASP    19      -6.706   9.608   5.794  1.00 16.05           C
ATOM    155  OD1 ASP    19      -5.810   9.456   4.938  1.00 20.87           O
ATOM    156  OD2 ASP    19      -7.723  10.340   5.641  1.00 16.82           O
ATOM    157  C   ASP    19      -5.757   6.507   6.998  1.00 10.23           C
ATOM    158  O   ASP    19      -4.628   7.007   6.905  1.00 10.35           O
ATOM    159  N   LEU    20      -5.963   5.205   7.131  1.00  9.45           N
ATOM    160  CA  LEU    20      -4.884   4.242   7.274  1.00  8.26           C
ATOM    161  CB  LEU    20      -5.473   2.867   7.597  1.00  7.80           C
ATOM    162  CG  LEU    20      -6.490   2.867   8.735  1.00  8.16           C
ATOM    163  CD1 LEU    20      -7.139   1.475   8.895  1.00  9.83           C
ATOM    164  CD2 LEU    20      -5.806   3.316  10.025  1.00  5.08           C
ATOM    165  C   LEU    20      -4.025   4.107   6.028  1.00  8.14           C
ATOM    166  O   LEU    20      -4.532   3.802   4.959  1.00  7.97           O
ATOM    167  N   PRO    21      -2.695   4.265   6.176  1.00  8.38           N
ATOM    168  CA  PRO    21      -1.776   3.949   5.082  1.00  7.07           C
ATOM    169  CB  PRO    21      -0.393   4.320   5.672  1.00  7.84           C
ATOM    170  CG  PRO    21      -0.700   5.241   6.855  1.00  7.81           C
ATOM    171  CD  PRO    21      -1.982   4.674   7.404  1.00  7.70           C
ATOM    172  C   PRO    21      -1.810   2.448   4.799  1.00  7.20           C
ATOM    173  O   PRO    21      -1.935   1.631   5.727  1.00  6.28           O
ATOM    174  N   ASP    22      -1.710   2.078   3.533  1.00  6.41           N
ATOM    175  CA  ASP    22      -1.571   0.673   3.196  1.00  6.59           C
ATOM    176  CB  ASP    22      -1.646   0.467   1.692  1.00  6.57           C
ATOM    177  CG  ASP    22      -2.988   0.813   1.152  1.00  9.72           C
ATOM    178  OD1 ASP    22      -3.967   0.783   1.944  1.00 13.39           O
ATOM    179  OD2 ASP    22      -3.082   1.126  -0.047  1.00 12.17           O
ATOM    180  C   ASP    22      -0.279   0.074   3.729  1.00  6.33           C
ATOM    181  O   ASP    22       0.773   0.750   3.832  1.00  5.40           O
ATOM    182  N   PRO    23      -0.353  -1.207   4.091  1.00  5.78           N
ATOM    183  CA  PRO    23       0.849  -1.900   4.506  1.00  6.27           C
ATOM    184  CB  PRO    23       0.330  -3.242   5.062  1.00  5.96           C
ATOM    185  CG  PRO    23      -1.029  -3.437   4.457  1.00  5.73           C
ATOM    186  CD  PRO    23      -1.567  -2.042   4.147  1.00  6.03           C
ATOM    187  C   PRO    23       1.757  -2.126   3.295  1.00  6.84           C
ATOM    188  O   PRO    23       1.284  -2.119   2.159  1.00  6.83           O
ATOM    189  N   ILE    24       3.054  -2.291   3.521  1.00  6.64           N
ATOM    190  CA  ILE    24       3.906  -2.707   2.415  1.00  8.19           C
ATOM    191  CB  ILE    24       5.272  -2.013   2.444  1.00  8.19           C
ATOM    192  CG1 ILE    24       5.927  -2.229   3.804  1.00 10.05           C
ATOM    193  CD1 ILE    24       7.106  -3.104   3.791  1.00 12.47           C
ATOM    194  CG2 ILE    24       5.125  -0.528   2.189  1.00  8.08           C
ATOM    195  C   ILE    24       4.094  -4.229   2.433  1.00  7.88           C
ATOM    196  O   ILE    24       4.215  -4.854   3.506  1.00  7.51           O
ATOM    197  N   ALA    25       4.108  -4.816   1.244  1.00  7.03           N
ATOM    198  CA  ALA    25       4.312  -6.242   1.098  1.00  7.10           C
ATOM    199  CB  ALA    25       3.685  -6.704  -0.224  1.00  7.01           C
ATOM    200  C   ALA    25       5.799  -6.643   1.149  1.00  7.21           C
ATOM    201  O   ALA    25       6.153  -7.750   1.571  1.00  7.08           O
ATOM    202  N   THR    26       6.670  -5.761   0.674  1.00  6.89           N
ATOM    203  CA  THR    26       8.073  -6.122   0.494  1.00  7.41           C
ATOM    204  CB  THR    26       8.351  -6.486  -0.983  1.00  7.50           C
ATOM    205  OG1 THR    26       8.245  -5.295  -1.750  1.00  9.52           O
ATOM    206  CG2 THR    26       7.366  -7.534  -1.532  1.00  6.04           C
ATOM    207  C   THR    26       8.959  -4.925   0.809  1.00  7.38           C
ATOM    208  O   THR    26       8.503  -3.782   0.699  1.00  5.97           O
ATOM    209  N   PHE    27      10.221  -5.149   1.186  1.00  7.87           N
ATOM    210  CA  PHE    27      11.124  -3.989   1.371  1.00  9.14           C
ATOM    211  CB  PHE    27      12.436  -4.352   2.066  1.00  8.85           C
ATOM    212  CG  PHE    27      12.264  -4.758   3.503  1.00  8.65           C
ATOM    213  CD1 PHE    27      11.713  -3.883   4.427  1.00  9.20           C
ATOM    214  CE1 PHE    27      11.560  -4.267   5.745  1.00  8.54           C
ATOM    215  CZ  PHE    27      11.960  -5.535   6.151  1.00  6.73           C
ATOM    216  CE2 PHE    27      12.500  -6.400   5.248  1.00  8.63           C
ATOM    217  CD2 PHE    27      12.661  -6.014   3.927  1.00  9.55           C
ATOM    218  C   PHE    27      11.412  -3.239   0.073  1.00  9.88           C
ATOM    219  O   PHE    27      11.730  -2.044   0.087  1.00 10.95           O
ATOM    220  N   GLN    28      11.288  -3.931  -1.044  1.00 11.33           N
ATOM    221  CA  GLN    28      11.498  -3.311  -2.362  1.00 13.30           C
ATOM    222  CB  GLN    28      11.477  -4.383  -3.455  1.00 12.59           C
ATOM    223  CG  GLN    28      12.709  -5.296  -3.464  1.00 14.77           C
ATOM    224  CD  GLN    28      12.657  -6.415  -2.413  1.00 17.46           C
ATOM    225  OE1 GLN    28      11.599  -6.717  -1.867  1.00 19.05           O
ATOM    226  NE2 GLN    28      13.802  -7.053  -2.157  1.00 17.01           N
ATOM    227  C   GLN    28      10.493  -2.175  -2.666  1.00 14.26           C
ATOM    228  O   GLN    28      10.857  -1.158  -3.239  1.00 14.44           O
ATOM    229  N   GLN    29       9.232  -2.364  -2.290  1.00 16.58           N
ATOM    230  CA  GLN    29       8.243  -1.271  -2.303  1.00 18.31           C
ATOM    231  CB  GLN    29       7.084  -1.599  -1.392  1.00 19.04           C
ATOM    232  CG  GLN    29       6.348  -2.870  -1.708  1.00 20.63           C
ATOM    233  CD  GLN    29       4.876  -2.671  -1.516  1.00 22.61           C
ATOM    234  OE1 GLN    29       4.126  -3.610  -1.221  1.00 23.50           O
ATOM    235  NE2 GLN    29       4.442  -1.430  -1.680  1.00 22.36           N
ATOM    236  C   GLN    29       8.791   0.045  -1.783  1.00 19.43           C
ATOM    237  O   GLN    29       8.474   1.093  -2.326  1.00 19.91           O
ATOM    238  N   LEU    30       9.578  -0.008  -0.697  1.00 20.35           N
ATOM    239  CA  LEU    30      10.090   1.197  -0.050  1.00 20.07           C
ATOM    240  CB  LEU    30      10.819   0.852   1.269  1.00 20.80           C
ATOM    241  CG  LEU    30      10.016   0.221   2.409  1.00 18.32           C
ATOM    242  CD1 LEU    30      10.955  -0.112   3.566  1.00 17.02           C
ATOM    243  CD2 LEU    30       8.897   1.175   2.855  1.00 16.63           C
ATOM    244  C   LEU    30      11.058   1.931  -0.947  1.00 20.93           C
ATOM    245  O   LEU    30      11.216   3.151  -0.834  1.00 20.57           O
ATOM    246  N   ASP    31      11.741   1.220  -1.834  1.00 20.86           N
ATOM    247  CA  ASP    31      12.552   1.977  -2.768  1.00 22.27           C
ATOM    248  CB  ASP    31      13.641   1.146  -3.459  1.00 22.39           C
ATOM    249  CG  ASP    31      14.248   1.886  -4.652  1.00 25.04           C
ATOM    250  OD1 ASP    31      14.351   3.133  -4.567  1.00 27.40           O
ATOM    251  OD2 ASP    31      14.606   1.250  -5.679  1.00 25.37           O
ATOM    252  C   ASP    31      11.602   2.630  -3.774  1.00 21.84           C
ATOM    253  O   ASP    31      11.720   3.823  -4.080  1.00 21.76           O
ATOM    254  N   GLN    32      10.633   1.853  -4.249  1.00 21.73           N
ATOM    255  CA  GLN    32       9.721   2.338  -5.283  1.00 21.51           C
ATOM    256  CB  GLN    32       8.873   1.181  -5.845  1.00 21.95           C
ATOM    257  CG  GLN    32       9.713   0.182  -6.669  1.00 24.69           C
ATOM    258  CD  GLN    32       9.226  -1.281  -6.600  1.00 29.21           C
ATOM    259  OE1 GLN    32       8.056  -1.560  -6.290  1.00 30.67           O
ATOM    260  NE2 GLN    32      10.132  -2.220  -6.906  1.00 28.57           N
ATOM    261  C   GLN    32       8.853   3.474  -4.750  1.00 20.66           C
ATOM    262  O   GLN    32       8.680   4.472  -5.414  1.00 20.02           O
ATOM    263  N   GLU    33       8.338   3.336  -3.530  1.00 20.19           N
ATOM    264  CA  GLU    33       7.380   4.318  -3.000  1.00 20.03           C
ATOM    265  CB  GLU    33       6.264   3.609  -2.223  1.00 19.71           C
ATOM    266  CG  GLU    33       5.589   2.487  -3.043  1.00 21.07           C
ATOM    267  CD  GLU    33       4.501   1.708  -2.297  1.00 21.95           C
ATOM    268  OE1 GLU    33       4.510   1.665  -1.057  1.00 23.44           O
ATOM    269  OE2 GLU    33       3.628   1.123  -2.967  1.00 24.25           O
ATOM    270  C   GLU    33       7.997   5.486  -2.197  1.00 19.96           C
ATOM    271  O   GLU    33       7.560   6.627  -2.347  1.00 19.73           O
ATOM    272  N   TYR    34       9.016   5.207  -1.375  1.00 19.86           N
ATOM    273  CA  TYR    34       9.659   6.232  -0.522  1.00 19.80           C
ATOM    274  CB  TYR    34       9.555   5.858   0.958  1.00 20.03           C
ATOM    275  CG  TYR    34       8.155   5.587   1.407  1.00 18.02           C
ATOM    276  CD1 TYR    34       7.378   6.586   1.986  1.00 17.16           C
ATOM    277  CE1 TYR    34       6.087   6.329   2.394  1.00 14.98           C
ATOM    278  CZ  TYR    34       5.562   5.085   2.208  1.00 15.25           C
ATOM    279  OH  TYR    34       4.270   4.796   2.581  1.00 17.03           O
ATOM    280  CE2 TYR    34       6.311   4.092   1.619  1.00 16.16           C
ATOM    281  CD2 TYR    34       7.597   4.349   1.230  1.00 16.18           C
ATOM    282  C   TYR    34      11.125   6.491  -0.826  1.00 20.35           C
ATOM    283  O   TYR    34      11.734   7.383  -0.234  1.00 22.01           O
ATOM    284  N   LYS    35      11.728   5.724  -1.722  1.00 19.60           N
ATOM    285  CA  LYS    35      13.058   6.121  -2.172  1.00 18.68           C
ATOM    286  CB  LYS    35      12.989   7.512  -2.764  1.00 19.29           C
ATOM    287  CG  LYS    35      14.321   8.044  -3.254  1.00 20.61           C
ATOM    288  CD  LYS    35      14.112   9.110  -4.324  1.00 23.53           C
ATOM    289  CE  LYS    35      13.101   8.654  -5.375  1.00 25.65           C
ATOM    290  NZ  LYS    35      13.210   9.485  -6.616  1.00 25.37           N
ATOM    291  C   LYS    35      14.098   6.088  -1.040  1.00 17.71           C
ATOM    292  O   LYS    35      14.986   6.976  -0.932  1.00 17.81           O
ATOM    293  N   ILE    36      13.972   5.045  -0.220  1.00 15.11           N
ATOM    294  CA  ILE    36      14.920   4.656   0.821  1.00 12.81           C
ATOM    295  CB  ILE    36      14.567   3.230   1.288  1.00 12.59           C
ATOM    296  CG1 ILE    36      15.539   2.751   2.376  1.00 12.56           C
ATOM    297  CD1 ILE    36      15.291   1.342   2.861  1.00 12.40           C
ATOM    298  CG2 ILE    36      14.577   2.277   0.083  1.00 11.79           C
ATOM    299  C   ILE    36      16.397   4.647   0.377  1.00 11.23           C
ATOM    300  O   ILE    36      16.738   4.270  -0.743  1.00 10.98           O
ATOM    301  N   ASN    37      17.268   5.067   1.276  1.00  9.64           N
ATOM    302  CA  ASN    37      18.715   5.023   1.059  1.00  8.41           C
ATOM    303  CB  ASN    37      19.411   5.291   2.395  1.00  8.19           C
ATOM    304  CG  ASN    37      20.893   5.456   2.250  1.00  9.36           C
ATOM    305  OD1 ASN    37      21.661   4.524   2.472  1.00 11.55           O
ATOM    306  ND2 ASN    37      21.311   6.645   1.867  1.00  9.77           N
ATOM    307  C   ASN    37      19.144   3.653   0.556  1.00  7.48           C
ATOM    308  O   ASN    37      18.781   2.626   1.161  1.00  7.31           O
ATOM    309  N   SER    38      19.914   3.621  -0.529  1.00  6.13           N
ATOM    310  CA  SER    38      20.308   2.350  -1.137  1.00  6.04           C
ATOM    311  CB  SER    38      20.954   2.562  -2.519  1.00  6.04           C
ATOM    312  OG  SER    38      22.193   3.233  -2.398  1.00  7.40           O
ATOM    313  C   SER    38      21.205   1.492  -0.245  1.00  5.54           C
ATOM    314  O   SER    38      21.123   0.260  -0.275  1.00  5.89           O
ATOM    315  N   ARG    39      22.057   2.122   0.554  1.00  4.42           N
ATOM    316  CA  ARG    39      22.871   1.358   1.481  1.00  4.50           C
ATOM    317  CB  ARG    39      24.010   2.204   2.087  1.00  4.28           C
ATOM    318  CG  ARG    39      24.765   1.443   3.159  1.00  5.12           C
ATOM    319  CD  ARG    39      25.584   0.330   2.557  1.00  6.51           C
ATOM    320  NE  ARG    39      26.278  -0.480   3.549  1.00  6.87           N
ATOM    321  CZ  ARG    39      27.545  -0.298   3.905  1.00  6.84           C
ATOM    322  NH1 ARG    39      28.236   0.685   3.344  1.00  5.71           N
ATOM    323  NH2 ARG    39      28.106  -1.087   4.824  1.00  4.29           N
ATOM    324  C   ARG    39      22.029   0.732   2.590  1.00  3.74           C
ATOM    325  O   ARG    39      22.211  -0.439   2.918  1.00  3.30           O
ATOM    326  N   LEU    40      21.136   1.530   3.181  1.00  4.10           N
ATOM    327  CA  LEU    40      20.192   1.015   4.183  1.00  4.15           C
ATOM    328  CB  LEU    40      19.194   2.110   4.618  1.00  4.56           C
ATOM    329  CG  LEU    40      18.088   1.834   5.643  1.00  5.36           C
ATOM    330  CD1 LEU    40      18.604   1.114   6.913  1.00  4.80           C
ATOM    331  CD2 LEU    40      17.396   3.161   6.041  1.00  5.69           C
ATOM    332  C   LEU    40      19.445  -0.220   3.658  1.00  3.51           C
ATOM    333  O   LEU    40      19.436  -1.262   4.315  1.00  3.52           O
ATOM    334  N   LEU    41      18.811  -0.109   2.492  1.00  2.79           N
ATOM    335  CA  LEU    41      18.096  -1.261   1.912  1.00  2.44           C
ATOM    336  CB  LEU    41      17.389  -0.884   0.598  1.00  2.50           C
ATOM    337  CG  LEU    41      16.668  -2.004  -0.175  1.00  2.03           C
ATOM    338  CD1 LEU    41      15.517  -2.578   0.664  1.00  2.00           C
ATOM    339  CD2 LEU    41      16.125  -1.540  -1.547  1.00  2.00           C
ATOM    340  C   LEU    41      19.025  -2.485   1.704  1.00  3.30           C
ATOM    341  O   LEU    41      18.624  -3.638   1.957  1.00  2.99           O
ATOM    342  N   GLN    42      20.258  -2.254   1.262  1.00  2.73           N
ATOM    343  CA  GLN    42      21.175  -3.381   1.100  1.00  3.62           C
ATOM    344  CB  GLN    42      22.434  -2.987   0.315  1.00  2.71           C
ATOM    345  CG  GLN    42      23.294  -4.212  -0.116  1.00  5.86           C
ATOM    346  CD  GLN    42      22.524  -5.200  -1.024  1.00  9.82           C
ATOM    347  OE1 GLN    42      21.977  -4.816  -2.060  1.00  9.25           O
ATOM    348  NE2 GLN    42      22.479  -6.479  -0.623  1.00 11.74           N
ATOM    349  C   GLN    42      21.554  -3.974   2.467  1.00  3.97           C
ATOM    350  O   GLN    42      21.719  -5.195   2.596  1.00  3.81           O
ATOM    351  N   ASN    43      21.704  -3.118   3.482  1.00  3.76           N
ATOM    352  CA  ASN    43      22.003  -3.626   4.834  1.00  4.12           C
ATOM    353  CB  ASN    43      22.180  -2.475   5.821  1.00  3.08           C
ATOM    354  CG  ASN    43      23.479  -1.743   5.631  1.00  2.00           C
ATOM    355  OD1 ASN    43      24.378  -2.223   4.958  1.00  2.00           O
ATOM    356  ND2 ASN    43      23.585  -0.582   6.224  1.00  2.00           N
ATOM    357  C   ASN    43      20.896  -4.561   5.337  1.00  4.09           C
ATOM    358  O   ASN    43      21.153  -5.636   5.873  1.00  4.14           O
ATOM    359  N   ILE    44      19.664  -4.105   5.179  1.00  5.02           N
ATOM    360  CA  ILE    44      18.470  -4.865   5.552  1.00  5.62           C
ATOM    361  CB  ILE    44      17.193  -4.035   5.209  1.00  5.65           C
ATOM    362  CG1 ILE    44      17.058  -2.859   6.184  1.00  6.47           C
ATOM    363  CD1 ILE    44      16.122  -1.755   5.720  1.00  4.91           C
ATOM    364  CG2 ILE    44      15.930  -4.893   5.244  1.00  5.42           C
ATOM    365  C   ILE    44      18.471  -6.239   4.857  1.00  6.19           C
ATOM    366  O   ILE    44      18.346  -7.278   5.502  1.00  7.14           O
ATOM    367  N   LEU    45      18.655  -6.247   3.542  1.00  6.20           N
ATOM    368  CA  LEU    45      18.691  -7.493   2.787  1.00  6.82           C
ATOM    369  CB  LEU    45      18.572  -7.197   1.279  1.00  7.28           C
ATOM    370  CG  LEU    45      17.323  -6.366   0.880  1.00  6.92           C
ATOM    371  CD1 LEU    45      17.201  -6.241  -0.647  1.00  8.11           C
ATOM    372  CD2 LEU    45      16.026  -6.988   1.420  1.00  5.85           C
ATOM    373  C   LEU    45      19.906  -8.393   3.137  1.00  7.19           C
ATOM    374  O   LEU    45      19.750  -9.604   3.332  1.00  6.65           O
ATOM    375  N   ASP    46      21.095  -7.798   3.257  1.00  7.54           N
ATOM    376  CA  ASP    46      22.297  -8.509   3.745  1.00  7.92           C
ATOM    377  CB  ASP    46      23.496  -7.566   3.839  1.00  7.77           C
ATOM    378  CG  ASP    46      24.082  -7.204   2.492  1.00  9.57           C
ATOM    379  OD1 ASP    46      23.699  -7.801   1.465  1.00  9.79           O
ATOM    380  OD2 ASP    46      24.967  -6.323   2.474  1.00 11.70           O
ATOM    381  C   ASP    46      22.135  -9.137   5.136  1.00  8.26           C
ATOM    382  O   ASP    46      22.823 -10.093   5.468  1.00  7.99           O
ATOM    383  N   ALA    47      21.285  -8.556   5.971  1.00  8.87           N
ATOM    384  CA  ALA    47      21.038  -9.116   7.297  1.00  9.92           C
ATOM    385  CB  ALA    47      20.415  -8.078   8.221  1.00  9.39           C
ATOM    386  C   ALA    47      20.147 -10.359   7.209  1.00 10.55           C
ATOM    387  O   ALA    47      19.913 -11.025   8.214  1.00 11.19           O
ATOM    388  N   GLY    48      19.669 -10.665   6.000  1.00 10.64           N
ATOM    389  CA  GLY    48      18.837 -11.832   5.758  1.00 10.65           C
ATOM    390  C   GLY    48      17.370 -11.500   5.981  1.00 11.02           C
ATOM    391  O   GLY    48      16.527 -12.382   6.040  1.00 11.61           O
ATOM    392  N   PHE    49      17.058 -10.221   6.123  1.00 10.84           N
ATOM    393  CA  PHE    49      15.678  -9.843   6.300  1.00 10.34           C
ATOM    394  CB  PHE    49      15.553  -8.524   7.041  1.00 10.27           C
ATOM    395  CG  PHE    49      16.289  -8.482   8.367  1.00 10.53           C
ATOM    396  CD1 PHE    49      16.438  -9.629   9.151  1.00  9.15           C
ATOM    397  CE1 PHE    49      17.103  -9.572  10.380  1.00  8.21           C
ATOM    398  CZ  PHE    49      17.629  -8.371  10.827  1.00  6.77           C
ATOM    399  CE2 PHE    49      17.508  -7.237  10.048  1.00  8.64           C
ATOM    400  CD2 PHE    49      16.836  -7.296   8.822  1.00  7.85           C
ATOM    401  C   PHE    49      15.100  -9.743   4.921  1.00 10.17           C
ATOM    402  O   PHE    49      15.013  -8.653   4.357  1.00 11.58           O
ATOM    403  N   GLN    50      14.728 -10.898   4.375  1.00  8.82           N
ATOM    404  CA  GLN    50      14.202 -10.994   3.034  1.00  7.78           C
ATOM    405  CB  GLN    50      14.172 -12.463   2.634  1.00  7.84           C
ATOM    406  CG  GLN    50      13.041 -12.864   1.715  1.00  9.37           C
ATOM    410  C   GLN    50      12.807 -10.336   2.852  1.00  6.87           C
ATOM    411  O   GLN    50      12.495  -9.781   1.792  1.00  6.01           O
ATOM    412  N   MET    51      11.990 -10.386   3.902  1.00  5.70           N
ATOM    413  CA  MET    51      10.599  -9.939   3.838  0.50  5.02           C
ATOM    415  CB  MET    51       9.688 -11.156   3.635  0.50  5.14           C
ATOM    417  CG  MET    51       9.832 -11.859   2.288  0.50  6.48           C
ATOM    419  SD  MET    51       9.048 -10.903   0.976  0.50  9.57           S
ATOM    421  CE  MET    51       7.496 -10.519   1.767  0.50  9.06           C
ATOM    423  C   MET    51      10.212  -9.260   5.149  1.00  3.99           C
ATOM    424  O   MET    51      10.524  -9.765   6.213  1.00  4.09           O
ATOM    425  N   PRO    52       9.504  -8.123   5.086  1.00  3.02           N
ATOM    426  CA  PRO    52       9.134  -7.550   6.375  1.00  2.00           C
ATOM    427  CB  PRO    52       8.329  -6.297   5.996  1.00  2.00           C
ATOM    428  CG  PRO    52       7.949  -6.512   4.577  1.00  2.45           C
ATOM    429  CD  PRO    52       9.009  -7.330   3.954  1.00  2.00           C
ATOM    430  C   PRO    52       8.207  -8.466   7.127  1.00  2.00           C
ATOM    431  O   PRO    52       7.423  -9.216   6.512  1.00  2.00           O
ATOM    432  N   THR    53       8.251  -8.348   8.452  1.00  2.00           N
ATOM    433  CA  THR    53       7.363  -9.088   9.323  1.00  2.00           C
ATOM    434  CB  THR    53       7.910  -9.173  10.752  1.00  2.00           C
ATOM    435  OG1 THR    53       7.929  -7.863  11.336  1.00  2.00           O
ATOM    436  CG2 THR    53       9.302  -9.781  10.762  1.00  2.00           C
ATOM    437  C   THR    53       6.013  -8.372   9.336  1.00  2.00           C
ATOM    438  O   THR    53       5.923  -7.240   8.902  1.00  2.00           O
ATOM    439  N   PRO    54       4.951  -9.061   9.817  1.00  2.00           N
ATOM    440  CA  PRO    54       3.614  -8.446   9.836  1.00  2.00           C
ATOM    441  CB  PRO    54       2.764  -9.499  10.554  1.00  2.00           C
ATOM    442  CG  PRO    54       3.434 -10.845  10.109  1.00  2.00           C
ATOM    443  CD  PRO    54       4.913 -10.522  10.084  1.00  2.00           C
ATOM    444  C   PRO    54       3.575  -7.045  10.511  1.00  2.00           C
ATOM    445  O   PRO    54       2.921  -6.128   9.970  1.00  2.12           O
ATOM    446  N   ILE    55       4.286  -6.857  11.631  1.00  2.00           N
ATOM    447  CA  ILE    55       4.277  -5.552  12.311  1.00  2.00           C
ATOM    448  CB  ILE    55       4.798  -5.637  13.788  1.00  2.00           C
ATOM    449  CG1 ILE    55       4.445  -4.380  14.592  1.00  2.25           C
ATOM    450  CD1 ILE    55       2.939  -4.024  14.606  1.00  2.00           C
ATOM    451  CG2 ILE    55       6.303  -5.838  13.848  1.00  2.00           C
ATOM    452  C   ILE    55       5.031  -4.496  11.479  1.00  2.00           C
ATOM    453  O   ILE    55       4.572  -3.360  11.336  1.00  2.00           O
ATOM    454  N   GLN    56       6.172  -4.885  10.921  1.00  2.00           N
ATOM    455  CA  GLN    56       6.886  -4.046   9.958  1.00  2.00           C
ATOM    456  CB  GLN    56       8.151  -4.760   9.495  1.00  2.00           C
ATOM    457  CG  GLN    56       9.140  -4.972  10.662  1.00  2.00           C
ATOM    458  CD  GLN    56      10.206  -5.998  10.364  1.00  2.68           C
ATOM    459  OE1 GLN    56      10.304  -6.506   9.228  1.00  2.00           O
ATOM    460  NE2 GLN    56      11.013  -6.336  11.397  1.00  2.00           N
ATOM    461  C   GLN    56       6.012  -3.665   8.771  1.00  2.00           C
ATOM    462  O   GLN    56       5.979  -2.513   8.367  1.00  2.00           O
ATOM    463  N   MET    57       5.295  -4.632   8.209  1.00  2.00           N
ATOM    464  CA  MET    57       4.436  -4.374   7.048  1.00  2.00           C
ATOM    465  CB  MET    57       3.590  -5.610   6.715  1.00  2.00           C
ATOM    466  CG  MET    57       4.390  -6.774   6.183  1.00  2.00           C
ATOM    467  SD  MET    57       3.250  -8.128   5.782  1.00  2.36           S
ATOM    468  CE  MET    57       4.399  -9.242   4.913  1.00  2.00           C
ATOM    469  C   MET    57       3.510  -3.178   7.261  1.00  2.00           C
ATOM    470  O   MET    57       3.329  -2.347   6.356  1.00  2.00           O
ATOM    471  N   GLN    58       2.877  -3.113   8.430  1.00  2.00           N
ATOM    472  CA  GLN    58       1.941  -2.027   8.691  1.00  2.00           C
ATOM    473  CB  GLN    58       0.626  -2.532   9.308  1.00  2.00           C
ATOM    474  CG  GLN    58      -0.428  -1.426   9.490  1.00  2.00           C
ATOM    475  CD  GLN    58      -1.001  -0.929   8.177  1.00  2.00           C
ATOM    476  OE1 GLN    58      -1.953  -1.504   7.637  1.00  2.07           O
ATOM    477  NE2 GLN    58      -0.439   0.152   7.659  1.00  2.00           N
ATOM    478  C   GLN    58       2.523  -0.876   9.528  1.00  2.00           C
ATOM    479  O   GLN    58       2.118   0.265   9.361  1.00  2.31           O
ATOM    480  N   ALA    59       3.451  -1.156  10.433  1.00  2.00           N
ATOM    481  CA  ALA    59       3.966  -0.066  11.288  1.00  2.00           C
ATOM    482  CB  ALA    59       4.767  -0.610  12.451  1.00  2.00           C
ATOM    483  C   ALA    59       4.833   0.926  10.499  1.00  2.62           C
ATOM    484  O   ALA    59       4.805   2.132  10.746  1.00  2.00           O
ATOM    485  N   ILE    60       5.649   0.398   9.588  1.00  2.19           N
ATOM    486  CA  ILE    60       6.577   1.248   8.866  1.00  2.13           C
ATOM    487  CB  ILE    60       7.525   0.403   7.984  1.00  2.84           C
ATOM    488  CG1 ILE    60       8.507  -0.352   8.905  1.00  2.72           C
ATOM    489  CD1 ILE    60       9.371  -1.389   8.203  1.00  2.00           C
ATOM    490  CG2 ILE    60       8.257   1.278   6.969  1.00  2.00           C
ATOM    491  C   ILE    60       5.876   2.348   8.080  1.00  2.31           C
ATOM    492  O   ILE    60       6.241   3.532   8.195  1.00  2.00           O
ATOM    493  N   PRO    61       4.884   1.970   7.241  1.00  2.57           N
ATOM    494  CA  PRO    61       4.244   3.028   6.459  1.00  2.12           C
ATOM    495  CB  PRO    61       3.383   2.273   5.452  1.00  2.00           C
ATOM    496  CG  PRO    61       3.304   0.855   5.965  1.00  3.34           C
ATOM    497  CD  PRO    61       4.543   0.618   6.756  1.00  2.61           C
ATOM    498  C   PRO    61       3.420   3.982   7.338  1.00  2.11           C
ATOM    499  O   PRO    61       3.307   5.160   7.012  1.00  2.10           O
ATOM    500  N   VAL    62       2.884   3.500   8.459  1.00  2.00           N
ATOM    501  CA  VAL    62       2.221   4.401   9.390  1.00  2.00           C
ATOM    502  CB  VAL    62       1.589   3.678  10.592  1.00  2.00           C
ATOM    503  CG1 VAL    62       1.036   4.716  11.619  1.00  2.38           C
ATOM    504  CG2 VAL    62       0.437   2.750  10.116  1.00  2.00           C
ATOM    505  C   VAL    62       3.168   5.524   9.877  1.00  2.00           C
ATOM    506  O   VAL    62       2.783   6.682   9.881  1.00  2.00           O
ATOM    507  N   MET    63       4.391   5.170  10.273  1.00  2.00           N
ATOM    508  CA  MET    63       5.376   6.165  10.740  1.00  2.00           C
ATOM    509  CB  MET    63       6.544   5.475  11.473  1.00  2.00           C
ATOM    510  CG  MET    63       6.093   4.863  12.793  1.00  3.01           C
ATOM    511  SD  MET    63       7.416   4.028  13.721  1.00  2.45           S
ATOM    512  CE  MET    63       8.532   5.387  14.031  1.00  2.00           C
ATOM    513  C   MET    63       5.894   7.038   9.613  1.00  2.00           C
ATOM    514  O   MET    63       6.115   8.238   9.795  1.00  2.00           O
ATOM    515  N   LEU    64       6.060   6.446   8.433  1.00  2.00           N
ATOM    516  CA  LEU    64       6.559   7.193   7.312  1.00  2.00           C
ATOM    517  CB  LEU    64       6.878   6.264   6.106  1.00  2.00           C
ATOM    518  CG  LEU    64       8.097   5.312   6.217  1.00  2.00           C
ATOM    519  CD1 LEU    64       8.242   4.334   5.003  1.00  2.00           C
ATOM    520  CD2 LEU    64       9.395   6.073   6.409  1.00  2.00           C
ATOM    521  C   LEU    64       5.536   8.299   6.971  1.00  2.00           C
ATOM    522  O   LEU    64       5.919   9.381   6.543  1.00  2.00           O
ATOM    523  N   HIS    65       4.253   8.027   7.203  1.00  2.00           N
ATOM    524  CA  HIS    65       3.195   8.987   6.903  1.00  2.60           C
ATOM    525  CB  HIS    65       1.863   8.284   6.553  1.00  2.89           C
ATOM    526  CG  HIS    65       1.806   7.810   5.139  1.00  2.94           C
ATOM    527  ND1 HIS    65       1.119   8.481   4.152  1.00  5.30           N
ATOM    528  CE1 HIS    65       1.266   7.840   3.003  1.00  4.25           C
ATOM    529  NE2 HIS    65       2.040   6.789   3.208  1.00  3.79           N
ATOM    530  CD2 HIS    65       2.395   6.749   4.534  1.00  4.11           C
ATOM    531  C   HIS    65       2.995   9.978   8.028  1.00  3.62           C
ATOM    532  O   HIS    65       2.083  10.783   7.967  1.00  3.71           O
ATOM    533  N   GLY    66       3.867   9.936   9.043  1.00  3.80           N
ATOM    534  CA  GLY    66       3.801  10.915  10.123  1.00  3.84           C
ATOM    535  C   GLY    66       2.617  10.746  11.080  1.00  4.06           C
ATOM    536  O   GLY    66       2.163  11.726  11.693  1.00  4.10           O
ATOM    537  N   ARG    67       2.139   9.511  11.229  1.00  2.77           N
ATOM    538  CA  ARG    67       0.969   9.234  12.037  1.00  2.47           C
ATOM    539  CB  ARG    67       0.004   8.306  11.288  1.00  2.00           C
ATOM    540  CG  ARG    67      -0.658   8.986  10.043  1.00  2.00           C
ATOM    541  CD  ARG    67      -1.548  10.165  10.431  1.00  2.00           C
ATOM    542  NE  ARG    67      -2.656   9.676  11.231  1.00  2.00           N
ATOM    543  CZ  ARG    67      -3.725   9.049  10.737  1.00  3.82           C
ATOM    544  NH1 ARG    67      -3.872   8.866   9.422  1.00  4.83           N
ATOM    545  NH2 ARG    67      -4.664   8.615  11.560  1.00  3.19           N
ATOM    546  C   ARG    67       1.408   8.614  13.341  1.00  3.21           C
ATOM    547  O   ARG    67       2.270   7.744  13.338  1.00  3.81           O
ATOM    548  N   GLU    68       0.855   9.092  14.455  1.00  3.11           N
ATOM    549  CA  GLU    68       1.120   8.485  15.750  1.00  3.33           C
ATOM    550  CB  GLU    68       0.557   9.354  16.887  1.00  3.14           C
ATOM    551  CG  GLU    68       0.934  10.866  16.706  1.00  4.51           C
ATOM    552  CD  GLU    68       1.246  11.586  18.027  1.00  7.62           C
ATOM    553  OE1 GLU    68       0.321  11.841  18.816  1.00 11.49           O
ATOM    554  OE2 GLU    68       2.419  11.917  18.286  1.00  8.02           O
ATOM    555  C   GLU    68       0.561   7.077  15.773  1.00  3.85           C
ATOM    556  O   GLU    68      -0.427   6.777  15.094  1.00  4.04           O
ATOM    557  N   LEU    69       1.180   6.215  16.569  1.00  3.09           N
ATOM    558  CA  LEU    69       1.015   4.793  16.412  1.00  3.00           C
ATOM    559  CB  LEU    69       2.211   4.247  15.599  1.00  2.82           C
ATOM    560  CG  LEU    69       2.403   2.745  15.372  1.00  4.17           C
ATOM    561  CD1 LEU    69       1.227   2.120  14.586  1.00  5.87           C
ATOM    562  CD2 LEU    69       3.738   2.421  14.660  1.00  2.00           C
ATOM    563  C   LEU    69       1.014   4.113  17.766  1.00  2.93           C
ATOM    564  O   LEU    69       1.856   4.390  18.619  1.00  2.47           O
ATOM    565  N   LEU    70       0.074   3.211  17.961  1.00  3.47           N
ATOM    566  CA  LEU    70       0.215   2.203  19.002  1.00  4.88           C
ATOM    567  CB  LEU    70      -0.994   2.209  19.953  1.00  5.32           C
ATOM    568  CG  LEU    70      -1.060   1.042  20.952  1.00  9.07           C
ATOM    569  CD1 LEU    70       0.135   1.034  21.875  1.00 11.28           C
ATOM    570  CD2 LEU    70      -2.370   1.059  21.793  1.00  9.52           C
ATOM    571  C   LEU    70       0.344   0.863  18.276  1.00  5.01           C
ATOM    572  O   LEU    70      -0.567   0.456  17.558  1.00  5.32           O
ATOM    573  N   ALA    71       1.490   0.208  18.440  1.00  4.65           N
ATOM    574  CA  ALA    71       1.791  -1.027  17.751  1.00  4.52           C
ATOM    575  CB  ALA    71       3.038  -0.867  16.900  1.00  3.53           C
ATOM    576  C   ALA    71       2.010  -2.141  18.752  1.00  5.13           C
ATOM    577  O   ALA    71       2.853  -1.997  19.655  1.00  6.52           O
ATOM    578  N   SER    72       1.294  -3.251  18.580  1.00  4.10           N
ATOM    579  CA  SER    72       1.398  -4.381  19.487  1.00  4.12           C
ATOM    580  CB  SER    72       0.114  -4.568  20.325  1.00  4.46           C
ATOM    581  OG  SER    72      -0.237  -3.354  21.002  1.00 10.59           O
ATOM    582  C   SER    72       1.664  -5.652  18.720  1.00  3.39           C
ATOM    583  O   SER    72       0.954  -5.987  17.748  1.00  3.27           O
ATOM    584  N   ALA    73       2.668  -6.388  19.170  1.00  2.47           N
ATOM    585  CA  ALA    73       2.975  -7.679  18.585  1.00  2.45           C
ATOM    586  CB  ALA    73       3.727  -7.478  17.264  1.00  2.35           C
ATOM    587  C   ALA    73       3.835  -8.453  19.586  1.00  2.00           C
ATOM    588  O   ALA    73       4.648  -7.858  20.258  1.00  2.00           O
ATOM    589  N   PRO    74       3.670  -9.780  19.667  1.00  2.62           N
ATOM    590  CA  PRO    74       4.425 -10.575  20.664  1.00  2.95           C
ATOM    591  CB  PRO    74       4.066 -12.037  20.329  1.00  3.18           C
ATOM    592  CG  PRO    74       2.831 -11.980  19.469  1.00  3.56           C
ATOM    593  CD  PRO    74       2.768 -10.592  18.830  1.00  3.29           C
ATOM    594  C   PRO    74       5.937 -10.379  20.527  1.00  2.89           C
ATOM    595  O   PRO    74       6.410  -9.920  19.481  1.00  3.93           O
ATOM    596  N   THR    75       6.681 -10.674  21.579  1.00  2.00           N
ATOM    597  CA  THR    75       8.129 -10.846  21.482  1.00  2.28           C
ATOM    598  CB  THR    75       8.670 -11.503  22.801  1.00  2.76           C
ATOM    599  OG1 THR    75       8.280 -10.686  23.918  1.00  4.52           O
ATOM    600  CG2 THR    75      10.179 -11.637  22.788  1.00  2.48           C
ATOM    601  C   THR    75       8.533 -11.705  20.268  1.00  2.19           C
ATOM    602  O   THR    75       7.918 -12.735  19.975  1.00  2.22           O
ATOM    603  N   GLY    76       9.579 -11.287  19.562  1.00  2.00           N
ATOM    604  CA  GLY    76      10.046 -12.055  18.421  1.00  2.00           C
ATOM    605  C   GLY    76       9.407 -11.587  17.120  1.00  2.00           C
ATOM    606  O   GLY    76       9.570 -12.216  16.086  1.00  2.28           O
ATOM    607  N   SER    77       8.685 -10.481  17.154  1.00  2.00           N
ATOM    608  CA  SER    77       7.941 -10.080  15.975  1.00  2.00           C
ATOM    609  CB  SER    77       6.635  -9.399  16.387  1.00  2.00           C
ATOM    610  OG  SER    77       5.809 -10.325  17.065  1.00  2.05           O
ATOM    611  C   SER    77       8.701  -9.156  15.013  1.00  2.00           C
ATOM    612  O   SER    77       8.199  -8.910  13.918  1.00  2.00           O
ATOM    613  N   GLY    78       9.874  -8.659  15.437  1.00  2.00           N
ATOM    614  CA  GLY    78      10.666  -7.657  14.711  1.00  2.00           C
ATOM    615  C   GLY    78      10.248  -6.214  14.970  1.00  2.00           C
ATOM    616  O   GLY    78      10.280  -5.361  14.067  1.00  2.00           O
ATOM    617  N   LYS    79       9.842  -5.911  16.204  1.00  2.00           N
ATOM    618  CA  LYS    79       9.396  -4.551  16.505  1.00  2.00           C
ATOM    619  CB  LYS    79       8.665  -4.468  17.856  1.00  2.01           C
ATOM    620  CG  LYS    79       7.351  -5.229  17.876  1.00  2.00           C
ATOM    621  CD  LYS    79       6.554  -4.973  19.148  1.00  2.00           C
ATOM    622  CE  LYS    79       7.197  -5.686  20.342  1.00  2.75           C
ATOM    623  NZ  LYS    79       7.418  -7.177  20.125  1.00  2.00           N
ATOM    624  C   LYS    79      10.556  -3.541  16.451  1.00  2.37           C
ATOM    625  O   LYS    79      10.331  -2.376  16.122  1.00  2.00           O
ATOM    626  N   THR    80      11.796  -3.974  16.713  1.00  2.00           N
ATOM    627  CA  THR    80      12.921  -3.018  16.596  1.00  2.00           C
ATOM    628  CB  THR    80      14.269  -3.618  17.038  1.00  2.00           C
ATOM    629  OG1 THR    80      14.106  -4.198  18.327  1.00  3.32           O
ATOM    630  CG2 THR    80      15.361  -2.544  17.141  1.00  2.00           C
ATOM    631  C   THR    80      13.064  -2.434  15.200  1.00  2.03           C
ATOM    632  O   THR    80      13.161  -1.234  15.037  1.00  2.00           O
ATOM    633  N   LEU    81      13.045  -3.279  14.168  1.00  2.61           N
ATOM    634  CA  LEU    81      13.222  -2.754  12.814  1.00  3.14           C
ATOM    635  CB  LEU    81      13.462  -3.919  11.869  1.00  4.34           C
ATOM    636  CG  LEU    81      14.566  -3.711  10.896  1.00  8.83           C
ATOM    637  CD1 LEU    81      15.794  -3.641  11.784  1.00 12.92           C
ATOM    638  CD2 LEU    81      14.567  -4.933   9.911  1.00 11.75           C
ATOM    639  C   LEU    81      12.006  -1.973  12.343  1.00  2.84           C
ATOM    640  O   LEU    81      12.130  -1.034  11.520  1.00  2.37           O
ATOM    641  N   ALA    82      10.831  -2.381  12.836  1.00  2.00           N
ATOM    642  CA  ALA    82       9.572  -1.669  12.583  1.00  2.39           C
ATOM    643  CB  ALA    82       8.396  -2.352  13.314  1.00  2.00           C
ATOM    644  C   ALA    82       9.603  -0.163  12.947  1.00  2.88           C
ATOM    645  O   ALA    82       8.961   0.669  12.260  1.00  2.31           O
ATOM    646  N   PHE    83      10.306   0.189  14.029  1.00  2.48           N
ATOM    647  CA  PHE    83      10.511   1.621  14.303  1.00  3.05           C
ATOM    648  CB  PHE    83      10.226   2.002  15.768  1.00  2.70           C
ATOM    649  CG  PHE    83      11.113   1.319  16.792  1.00  4.42           C
ATOM    650  CD1 PHE    83      12.417   1.747  17.006  1.00  3.70           C
ATOM    651  CE1 PHE    83      13.216   1.146  17.996  1.00  2.00           C
ATOM    652  CZ  PHE    83      12.710   0.142  18.784  1.00  2.00           C
ATOM    653  CE2 PHE    83      11.393  -0.285  18.595  1.00  3.79           C
ATOM    654  CD2 PHE    83      10.606   0.304  17.603  1.00  4.41           C
ATOM    655  C   PHE    83      11.836   2.224  13.820  1.00  3.40           C
ATOM    656  O   PHE    83      11.918   3.437  13.618  1.00  2.94           O
ATOM    657  N   SER    84      12.851   1.388  13.596  1.00  2.76           N
ATOM    658  CA  SER    84      14.182   1.899  13.276  1.00  3.03           C
ATOM    659  CB  SER    84      15.231   0.823  13.581  1.00  2.28           C
ATOM    660  OG  SER    84      15.209   0.603  14.977  1.00  4.99           O
ATOM    661  C   SER    84      14.308   2.358  11.831  1.00  2.92           C
ATOM    662  O   SER    84      14.958   3.365  11.538  1.00  2.00           O
ATOM    663  N   ILE    85      13.699   1.575  10.934  1.00  2.00           N
ATOM    664  CA  ILE    85      13.707   1.884   9.519  1.00  2.00           C
ATOM    665  CB  ILE    85      13.043   0.728   8.700  1.00  2.00           C
ATOM    666  CG1 ILE    85      14.013  -0.477   8.618  1.00  2.00           C
ATOM    667  CD1 ILE    85      13.414  -1.658   7.850  1.00  2.00           C
ATOM    668  CG2 ILE    85      12.662   1.184   7.291  1.00  2.00           C
ATOM    669  C   ILE    85      13.044   3.212   9.191  1.00  2.00           C
ATOM    670  O   ILE    85      13.618   4.041   8.510  1.00  2.00           O
ATOM    671  N   PRO    86      11.824   3.418   9.659  1.00  2.00           N
ATOM    672  CA  PRO    86      11.180   4.698   9.366  1.00  2.00           C
ATOM    673  CB  PRO    86       9.775   4.557   9.979  1.00  2.00           C
ATOM    674  CG  PRO    86       9.739   3.315  10.697  1.00  2.00           C
ATOM    675  CD  PRO    86      10.912   2.449  10.291  1.00  2.00           C
ATOM    676  C   PRO    86      11.895   5.889  10.016  1.00  2.56           C
ATOM    677  O   PRO    86      11.934   6.966   9.428  1.00  3.83           O
ATOM    678  N   ILE    87      12.434   5.711  11.214  1.00  2.17           N
ATOM    679  CA  ILE    87      13.258   6.763  11.814  1.00  2.12           C
ATOM    680  CB  ILE    87      13.775   6.329  13.208  1.00  2.41           C
ATOM    681  CG1 ILE    87      12.618   6.402  14.214  1.00  2.71           C
ATOM    682  CD1 ILE    87      12.971   5.703  15.499  1.00  4.63           C
ATOM    683  CG2 ILE    87      14.981   7.173  13.656  1.00  2.00           C
ATOM    684  C   ILE    87      14.461   7.096  10.935  1.00  2.00           C
ATOM    685  O   ILE    87      14.716   8.258  10.630  1.00  2.15           O
ATOM    686  N   LEU    88      15.231   6.082  10.549  1.00  2.00           N
ATOM    687  CA  LEU    88      16.350   6.343   9.634  1.00  2.00           C
ATOM    688  CB  LEU    88      17.093   5.038   9.367  1.00  2.00           C
ATOM    689  CG  LEU    88      17.805   4.450  10.583  1.00  2.54           C
ATOM    690  CD1 LEU    88      18.288   3.037  10.235  1.00  2.00           C
ATOM    691  CD2 LEU    88      18.987   5.353  11.039  1.00  2.00           C
ATOM    692  C   LEU    88      15.915   6.977   8.304  1.00  2.00           C
ATOM    693  O   LEU    88      16.578   7.891   7.784  1.00  2.00           O
ATOM    694  N   MET    89      14.827   6.463   7.726  1.00  2.00           N
ATOM    695  CA  MET    89      14.320   7.002   6.460  1.00  2.00           C
ATOM    696  CB  MET    89      13.151   6.161   5.945  1.00  2.00           C
ATOM    697  CG  MET    89      13.552   4.799   5.480  1.00  3.11           C
ATOM    698  SD  MET    89      12.178   3.813   4.889  1.00  2.61           S
ATOM    699  CE  MET    89      11.669   4.767   3.476  1.00  2.00           C
ATOM    700  C   MET    89      13.871   8.460   6.571  1.00  2.00           C
ATOM    701  O   MET    89      14.167   9.280   5.701  1.00  2.00           O
ATOM    702  N   GLN    90      13.142   8.775   7.641  1.00  2.20           N
ATOM    703  CA  GLN    90      12.672  10.145   7.870  1.00  2.77           C
ATOM    704  CB  GLN    90      11.746  10.223   9.101  1.00  3.27           C
ATOM    705  CG  GLN    90      11.113  11.643   9.262  1.00  6.16           C
ATOM    706  CD  GLN    90       9.921  11.690  10.217  1.00 11.29           C
ATOM    707  OE1 GLN    90       8.946  10.928  10.082  1.00 11.99           O
ATOM    708  NE2 GLN    90       9.977  12.607  11.169  1.00 13.52           N
ATOM    709  C   GLN    90      13.839  11.103   8.056  1.00  2.64           C
ATOM    710  O   GLN    90      13.865  12.217   7.497  1.00  2.68           O
ATOM    711  N   LEU    91      14.833  10.676   8.829  1.00  2.94           N
ATOM    712  CA  LEU    91      15.930  11.578   9.151  1.00  2.56           C
ATOM    713  CB  LEU    91      16.769  11.006  10.282  1.00  2.98           C
ATOM    714  CG  LEU    91      16.111  10.876  11.662  1.00  4.89           C
ATOM    715  CD1 LEU    91      17.152  10.647  12.756  1.00  2.00           C
ATOM    716  CD2 LEU    91      15.273  12.104  11.976  1.00  7.22           C
ATOM    717  C   LEU    91      16.808  11.874   7.906  1.00  3.02           C
ATOM    718  O   LEU    91      17.500  12.898   7.854  1.00  2.00           O
ATOM    719  N   LYS    92      16.749  10.964   6.931  1.00  3.61           N
ATOM    720  CA  LYS    92      17.442  11.063   5.630  1.00  5.29           C
ATOM    721  CB  LYS    92      17.013  12.332   4.874  1.00  5.67           C
ATOM    722  CG  LYS    92      15.534  12.413   4.631  1.00  9.99           C
ATOM    723  CD  LYS    92      15.180  13.725   3.945  1.00 15.63           C
ATOM    724  CE  LYS    92      13.804  13.621   3.319  1.00 19.94           C
ATOM    725  NZ  LYS    92      13.651  12.321   2.584  1.00 21.82           N
ATOM    726  C   LYS    92      18.967  10.983   5.662  1.00  5.67           C
ATOM    727  O   LYS    92      19.566  10.142   4.976  1.00  6.66           O
ATOM    728  N   GLN    93      19.589  11.897   6.405  1.00  5.46           N
ATOM    729  CA  GLN    93      21.045  12.032   6.441  1.00  5.18           C
ATOM    730  CB  GLN    93      21.555  13.177   5.535  1.00  5.51           C
ATOM    731  CG  GLN    93      21.266  13.102   4.027  1.00  8.17           C
ATOM    732  CD  GLN    93      21.817  14.343   3.323  1.00 11.14           C
ATOM    733  OE1 GLN    93      22.946  14.770   3.591  1.00 15.39           O
ATOM    734  NE2 GLN    93      21.023  14.942   2.453  1.00 12.80           N
ATOM    735  C   GLN    93      21.467  12.409   7.839  1.00  4.54           C
ATOM    736  O   GLN    93      20.721  13.104   8.544  1.00  3.67           O
ATOM    737  N   PRO    94      22.691  11.997   8.226  1.00  4.14           N
ATOM    738  CA  PRO    94      23.272  12.456   9.478  1.00  4.11           C
ATOM    739  CB  PRO    94      24.724  11.970   9.412  1.00  3.31           C
ATOM    740  CG  PRO    94      24.849  11.137   8.158  1.00  3.98           C
ATOM    741  CD  PRO    94      23.537  11.025   7.504  1.00  4.01           C
ATOM    742  C   PRO    94      23.248  13.973   9.460  1.00  4.37           C
ATOM    743  O   PRO    94      23.379  14.570   8.408  1.00  3.84           O
ATOM    744  N   ALA    95      23.093  14.603  10.616  1.00  4.85           N
ATOM    745  CA  ALA    95      23.059  16.058  10.653  1.00  5.05           C
ATOM    746  CB  ALA    95      21.601  16.587  10.447  1.00  4.19           C
ATOM    747  C   ALA    95      23.625  16.539  11.980  1.00  5.56           C
ATOM    748  O   ALA    95      23.797  15.744  12.893  1.00  5.25           O
ATOM    749  N   ASN    96      23.892  17.842  12.071  1.00  5.99           N
ATOM    750  CA  ASN    96      24.551  18.431  13.225  1.00  7.05           C
ATOM    751  CB  ASN    96      25.730  19.316  12.791  1.00  6.79           C
ATOM    755  C   ASN    96      23.556  19.237  14.036  1.00  7.61           C
ATOM    756  O   ASN    96      23.886  20.285  14.580  1.00  7.55           O
ATOM    757  N   LYS    97      22.331  18.712  14.118  1.00  8.01           N
ATOM    758  CA  LYS    97      21.205  19.404  14.734  1.00  7.98           C
ATOM    759  CB  LYS    97      19.945  19.196  13.854  1.00  8.66           C
ATOM    760  CG  LYS    97      19.648  20.246  12.750  1.00  9.51           C
ATOM    761  CD  LYS    97      20.770  21.221  12.504  1.00 11.14           C
ATOM    764  C   LYS    97      20.920  18.847  16.131  1.00  7.75           C
ATOM    765  O   LYS    97      19.918  19.198  16.732  1.00  7.92           O
ATOM    766  N   GLY    98      21.765  17.942  16.629  1.00  6.64           N
ATOM    767  CA  GLY    98      21.469  17.262  17.911  1.00  4.72           C
ATOM    768  C   GLY    98      20.448  16.171  17.672  1.00  3.30           C
ATOM    769  O   GLY    98      20.003  16.000  16.538  1.00  3.19           O
ATOM    770  N   PHE    99      20.030  15.460  18.723  1.00  2.62           N
ATOM    771  CA  PHE    99      19.193  14.254  18.523  1.00  2.00           C
ATOM    772  CB  PHE    99      18.920  13.517  19.833  1.00  2.00           C
ATOM    773  CG  PHE    99      20.144  12.939  20.458  1.00  2.82           C
ATOM    774  CD1 PHE    99      20.807  11.884  19.860  1.00  4.02           C
ATOM    775  CE1 PHE    99      21.958  11.341  20.437  1.00  4.64           C
ATOM    776  CZ  PHE    99      22.440  11.853  21.632  1.00  6.05           C
ATOM    777  CE2 PHE    99      21.788  12.916  22.237  1.00  6.13           C
ATOM    778  CD2 PHE    99      20.637  13.451  21.653  1.00  4.45           C
ATOM    779  C   PHE    99      17.879  14.560  17.845  1.00  2.00           C
ATOM    780  O   PHE    99      17.141  15.436  18.289  1.00  2.00           O
ATOM    781  N   ARG   100      17.593  13.824  16.777  1.00  2.00           N
ATOM    782  CA  ARG   100      16.347  14.003  16.029  1.00  2.00           C
ATOM    783  CB  ARG   100      16.636  14.226  14.534  1.00  2.00           C
ATOM    784  CG  ARG   100      17.194  15.663  14.239  1.00  2.00           C
ATOM    785  CD  ARG   100      17.570  15.857  12.763  1.00  2.00           C
ATOM    786  NE  ARG   100      18.702  14.983  12.442  1.00  2.00           N
ATOM    787  CZ  ARG   100      18.848  14.363  11.281  1.00  2.00           C
ATOM    788  NH1 ARG   100      17.939  14.536  10.318  1.00  2.00           N
ATOM    789  NH2 ARG   100      19.894  13.569  11.082  1.00  2.00           N
ATOM    790  C   ARG   100      15.389  12.845  16.260  1.00  2.00           C
ATOM    791  O   ARG   100      14.286  12.805  15.747  1.00  2.00           O
ATOM    792  N   ALA   101      15.818  11.891  17.056  1.00  2.00           N
ATOM    793  CA  ALA   101      14.955  10.779  17.358  1.00  2.00           C
ATOM    794  CB  ALA   101      14.984   9.708  16.249  1.00  2.00           C
ATOM    795  C   ALA   101      15.399  10.225  18.683  1.00  2.00           C
ATOM    796  O   ALA   101      16.577  10.283  19.019  1.00  2.00           O
ATOM    797  N   LEU   102      14.438   9.694  19.411  1.00  2.00           N
ATOM    798  CA  LEU   102      14.628   9.293  20.789  1.00  2.68           C
ATOM    799  CB  LEU   102      14.087  10.411  21.707  1.00  3.10           C
ATOM    800  CG  LEU   102      14.000  10.196  23.215  1.00  5.28           C
ATOM    801  CD1 LEU   102      15.328   9.757  23.804  1.00 11.18           C
ATOM    802  CD2 LEU   102      13.480  11.465  23.900  1.00 10.50           C
ATOM    803  C   LEU   102      13.841   8.008  21.017  1.00  2.36           C
ATOM    804  O   LEU   102      12.646   7.984  20.817  1.00  2.00           O
ATOM    805  N   ILE   103      14.509   6.960  21.471  1.00  2.00           N
ATOM    806  CA  ILE   103      13.842   5.699  21.715  1.00  2.00           C
ATOM    807  CB  ILE   103      14.530   4.571  20.899  1.00  2.00           C
ATOM    808  CG1 ILE   103      14.256   4.789  19.391  1.00  2.00           C
ATOM    809  CD1 ILE   103      15.330   4.253  18.435  1.00  2.00           C
ATOM    810  CG2 ILE   103      14.035   3.219  21.402  1.00  2.00           C
ATOM    811  C   ILE   103      13.995   5.379  23.192  1.00  2.00           C
ATOM    812  O   ILE   103      15.105   5.367  23.705  1.00  2.00           O
ATOM    813  N   ILE   104      12.892   5.116  23.860  1.00  2.00           N
ATOM    814  CA  ILE   104      12.894   4.833  25.276  1.00  2.92           C
ATOM    815  CB  ILE   104      11.850   5.738  25.979  1.00  3.13           C
ATOM    816  CG1 ILE   104      12.324   7.190  25.955  1.00  6.62           C
ATOM    817  CD1 ILE   104      11.146   8.150  26.134  1.00 11.71           C
ATOM    818  CG2 ILE   104      11.605   5.338  27.421  1.00  5.31           C
ATOM    819  C   ILE   104      12.587   3.353  25.490  1.00  2.55           C
ATOM    820  O   ILE   104      11.620   2.806  24.943  1.00  2.64           O
ATOM    821  N   SER   105      13.417   2.703  26.280  1.00  2.48           N
ATOM    822  CA  SER   105      13.259   1.287  26.544  1.00  3.30           C
ATOM    823  CB  SER   105      14.324   0.532  25.733  1.00  3.85           C
ATOM    824  OG  SER   105      14.528  -0.788  26.190  1.00  7.51           O
ATOM    825  C   SER   105      13.425   1.116  28.044  1.00  3.08           C
ATOM    826  O   SER   105      14.031   1.978  28.682  1.00  2.39           O
ATOM    827  N   PRO   106      12.870   0.017  28.627  1.00  3.28           N
ATOM    828  CA  PRO   106      12.837  -0.123  30.085  1.00  3.43           C
ATOM    829  CB  PRO   106      12.050  -1.441  30.306  1.00  4.16           C
ATOM    830  CG  PRO   106      11.330  -1.706  29.026  1.00  3.07           C
ATOM    831  CD  PRO   106      12.204  -1.115  27.950  1.00  3.01           C
ATOM    832  C   PRO   106      14.207  -0.223  30.765  1.00  3.80           C
ATOM    833  O   PRO   106      14.375   0.279  31.880  1.00  2.85           O
ATOM    834  N   THR   107      15.170  -0.877  30.126  1.00  3.73           N
ATOM    835  CA  THR   107      16.429  -1.149  30.821  1.00  4.76           C
ATOM    836  CB  THR   107      16.501  -2.613  31.359  1.00  4.32           C
ATOM    837  OG1 THR   107      16.383  -3.540  30.270  1.00  6.22           O
ATOM    838  CG2 THR   107      15.396  -2.885  32.363  1.00  4.98           C
ATOM    839  C   THR   107      17.658  -0.893  29.962  1.00  5.12           C
ATOM    840  O   THR   107      17.565  -0.841  28.740  1.00  4.73           O
ATOM    841  N   ARG   108      18.804  -0.710  30.622  1.00  5.75           N
ATOM    842  CA  ARG   108      20.093  -0.699  29.942  1.00  6.24           C
ATOM    843  CB  ARG   108      21.244  -0.669  30.971  1.00  6.48           C
ATOM    844  CG  ARG   108      22.626  -0.554  30.332  1.00  9.74           C
ATOM    845  CD  ARG   108      23.752  -0.526  31.355  1.00 13.87           C
ATOM    846  NE  ARG   108      23.490  -1.420  32.477  1.00 17.31           N
ATOM    847  CZ  ARG   108      23.059  -1.008  33.667  1.00 17.75           C
ATOM    848  NH1 ARG   108      22.852   0.284  33.891  1.00 18.97           N
ATOM    849  NH2 ARG   108      22.840  -1.883  34.633  1.00 17.54           N
ATOM    850  C   ARG   108      20.242  -1.898  28.983  1.00  5.78           C
ATOM    851  O   ARG   108      20.658  -1.711  27.840  1.00  6.04           O
ATOM    852  N   GLU   109      19.900  -3.112  29.446  1.00  5.39           N
ATOM    853  CA  GLU   109      20.001  -4.343  28.637  1.00  5.47           C
ATOM    854  CB  GLU   109      19.490  -5.574  29.414  1.00  5.95           C
ATOM    855  CG  GLU   109      20.008  -5.720  30.846  1.00  9.99           C
ATOM    856  CD  GLU   109      19.128  -5.019  31.915  1.00 13.36           C
ATOM    857  OE1 GLU   109      18.055  -5.578  32.307  1.00 12.23           O
ATOM    858  OE2 GLU   109      19.541  -3.923  32.380  1.00 13.33           O
ATOM    859  C   GLU   109      19.216  -4.239  27.331  1.00  4.33           C
ATOM    860  O   GLU   109      19.752  -4.436  26.231  1.00  3.59           O
ATOM    861  N   LEU   110      17.937  -3.914  27.453  1.00  3.40           N
ATOM    862  CA  LEU   110      17.094  -3.800  26.274  1.00  2.93           C
ATOM    863  CB  LEU   110      15.625  -3.720  26.668  1.00  2.90           C
ATOM    864  CG  LEU   110      15.178  -5.006  27.372  1.00  4.84           C
ATOM    865  CD1 LEU   110      13.763  -4.890  27.946  1.00  7.07           C
ATOM    866  CD2 LEU   110      15.307  -6.208  26.469  1.00  4.99           C
ATOM    867  C   LEU   110      17.506  -2.613  25.397  1.00  2.63           C
ATOM    868  O   LEU   110      17.468  -2.710  24.178  1.00  2.00           O
ATOM    869  N   ALA   111      17.871  -1.495  26.019  1.00  2.83           N
ATOM    870  CA  ALA   111      18.388  -0.341  25.273  1.00  3.71           C
ATOM    871  CB  ALA   111      18.667   0.854  26.204  1.00  2.80           C
ATOM    872  C   ALA   111      19.641  -0.728  24.480  1.00  4.78           C
ATOM    873  O   ALA   111      19.769  -0.407  23.288  1.00  4.84           O
ATOM    874  N   SER   112      20.563  -1.434  25.126  1.00  6.27           N
ATOM    875  CA  SER   112      21.794  -1.791  24.428  1.00  7.57           C
ATOM    876  CB  SER   112      22.806  -2.459  25.360  1.00  7.45           C
ATOM    877  OG  SER   112      22.466  -3.823  25.495  1.00 12.33           O
ATOM    878  C   SER   112      21.525  -2.640  23.165  1.00  7.23           C
ATOM    879  O   SER   112      22.145  -2.405  22.128  1.00  5.94           O
ATOM    880  N   GLN   113      20.574  -3.578  23.239  1.00  7.50           N
ATOM    881  CA  GLN   113      20.190  -4.370  22.056  1.00  7.95           C
ATOM    882  CB  GLN   113      19.224  -5.504  22.421  1.00  9.10           C
ATOM    883  CG  GLN   113      19.803  -6.597  23.301  1.00 15.35           C
ATOM    884  CD  GLN   113      18.744  -7.602  23.705  1.00 20.73           C
ATOM    885  OE1 GLN   113      18.007  -7.393  24.671  1.00 23.30           O
ATOM    886  NE2 GLN   113      18.653  -8.698  22.954  1.00 23.56           N
ATOM    887  C   GLN   113      19.572  -3.531  20.923  1.00  6.67           C
ATOM    888  O   GLN   113      19.860  -3.759  19.737  1.00  5.80           O
ATOM    889  N   ILE   114      18.703  -2.579  21.262  1.00  5.06           N
ATOM    890  CA  ILE   114      18.209  -1.670  20.233  1.00  4.34           C
ATOM    891  CB  ILE   114      17.156  -0.680  20.793  1.00  5.00           C
ATOM    892  CG1 ILE   114      15.855  -1.431  21.147  1.00  5.80           C
ATOM    893  CD1 ILE   114      14.988  -0.711  22.207  1.00  5.98           C
ATOM    894  CG2 ILE   114      16.911   0.454  19.814  1.00  4.99           C
ATOM    895  C   ILE   114      19.371  -0.892  19.613  1.00  4.38           C
ATOM    896  O   ILE   114      19.452  -0.707  18.397  1.00  3.41           O
ATOM    897  N   HIS   115      20.281  -0.429  20.452  1.00  4.02           N
ATOM    898  CA  HIS   115      21.414   0.354  19.963  1.00  5.12           C
ATOM    899  CB  HIS   115      22.276   0.791  21.171  1.00  4.94           C
ATOM    900  CG  HIS   115      23.448   1.639  20.808  1.00  4.43           C
ATOM    901  ND1 HIS   115      24.744   1.186  20.868  1.00  8.16           N
ATOM    902  CE1 HIS   115      25.567   2.155  20.517  1.00  7.33           C
ATOM    903  NE2 HIS   115      24.846   3.223  20.230  1.00  6.55           N
ATOM    904  CD2 HIS   115      23.519   2.925  20.403  1.00  5.61           C
ATOM    905  C   HIS   115      22.252  -0.459  18.941  1.00  5.67           C
ATOM    906  O   HIS   115      22.635   0.048  17.869  1.00  5.57           O
ATOM    907  N   ARG   116      22.540  -1.715  19.265  1.00  6.93           N
ATOM    908  CA  ARG   116      23.320  -2.556  18.359  1.00  8.35           C
ATOM    909  CB  ARG   116      23.750  -3.858  19.061  1.00  9.22           C
ATOM    910  CG  ARG   116      24.782  -3.632  20.153  1.00 11.28           C
ATOM    911  CD  ARG   116      25.399  -4.933  20.636  1.00 16.80           C
ATOM    912  NE  ARG   116      26.241  -5.571  19.621  1.00 21.11           N
ATOM    913  CZ  ARG   116      27.239  -6.406  19.911  1.00 21.97           C
ATOM    914  NH1 ARG   116      27.504  -6.699  21.183  1.00 22.55           N
ATOM    915  NH2 ARG   116      27.971  -6.952  18.943  1.00 21.73           N
ATOM    916  C   ARG   116      22.609  -2.839  17.016  1.00  8.58           C
ATOM    917  O   ARG   116      23.240  -2.848  15.956  1.00  9.07           O
ATOM    918  N   GLU   117      21.309  -3.085  17.071  1.00  8.39           N
ATOM    919  CA  GLU   117      20.528  -3.315  15.868  1.00  9.36           C
ATOM    920  CB  GLU   117      19.080  -3.651  16.232  1.00  9.61           C
ATOM    921  CG  GLU   117      18.180  -3.895  15.025  1.00 14.15           C
ATOM    922  CD  GLU   117      18.004  -5.400  14.739  1.00 20.80           C
ATOM    923  OE1 GLU   117      19.035  -6.104  14.634  1.00 21.79           O
ATOM    924  OE2 GLU   117      16.837  -5.871  14.644  1.00 24.25           O
ATOM    925  C   GLU   117      20.585  -2.065  14.965  1.00  8.68           C
ATOM    926  O   GLU   117      20.785  -2.169  13.755  1.00  8.54           O
ATOM    927  N   LEU   118      20.445  -0.888  15.564  1.00  7.27           N
ATOM    928  CA  LEU   118      20.543   0.358  14.806  1.00  7.76           C
ATOM    929  CB  LEU   118      20.237   1.571  15.702  1.00  7.42           C
ATOM    930  CG  LEU   118      18.764   1.954  15.829  1.00  7.92           C
ATOM    931  CD1 LEU   118      18.488   2.869  17.054  1.00  8.32           C
ATOM    932  CD2 LEU   118      18.276   2.606  14.542  1.00  6.55           C
ATOM    933  C   LEU   118      21.924   0.535  14.175  1.00  7.42           C
ATOM    934  O   LEU   118      22.048   0.967  13.022  1.00  7.74           O
ATOM    935  N   ILE   119      22.954   0.257  14.955  1.00  6.50           N
ATOM    936  CA  ILE   119      24.307   0.407  14.488  1.00  6.76           C
ATOM    937  CB  ILE   119      25.324  -0.048  15.553  1.00  6.73           C
ATOM    938  CG1 ILE   119      25.377   0.962  16.700  1.00  7.32           C
ATOM    939  CD1 ILE   119      25.589   2.336  16.211  1.00  8.63           C
ATOM    940  CG2 ILE   119      26.703  -0.226  14.932  1.00  5.63           C
ATOM    941  C   ILE   119      24.467  -0.483  13.269  1.00  7.02           C
ATOM    942  O   ILE   119      24.972  -0.047  12.239  1.00  6.37           O
ATOM    943  N   LYS   120      24.002  -1.728  13.387  1.00  7.26           N
ATOM    944  CA  LYS   120      24.234  -2.719  12.337  1.00  7.41           C
ATOM    945  CB  LYS   120      23.900  -4.129  12.841  1.00  7.82           C
ATOM    946  CG  LYS   120      24.586  -5.263  12.083  1.00 11.90           C
ATOM    947  CD  LYS   120      23.801  -6.553  12.270  1.00 16.51           C
ATOM    948  CE  LYS   120      22.459  -6.496  11.510  1.00 18.66           C
ATOM    949  NZ  LYS   120      21.406  -7.252  12.249  1.00 21.96           N
ATOM    950  C   LYS   120      23.465  -2.374  11.053  1.00  6.64           C
ATOM    951  O   LYS   120      24.051  -2.371   9.968  1.00  6.78           O
ATOM    952  N   ILE   121      22.175  -2.047  11.175  1.00  5.79           N
ATOM    953  CA  ILE   121      21.364  -1.766   9.984  0.50  5.80           C
ATOM    955  CB  ILE   121      19.824  -1.783  10.237  0.50  5.78           C
ATOM    957  CG1 ILE   121      19.391  -0.613  11.126  0.50  4.91           C
ATOM    959  CD1 ILE   121      17.936  -0.272  10.967  0.50  2.62           C
ATOM    961  CG2 ILE   121      19.361  -3.128  10.790  0.50  7.00           C
ATOM    963  C   ILE   121      21.737  -0.442   9.340  1.00  5.51           C
ATOM    964  O   ILE   121      21.449  -0.203   8.168  1.00  6.07           O
ATOM    965  N   SER   122      22.424   0.414  10.068  1.00  5.61           N
ATOM    966  CA  SER   122      22.780   1.704   9.498  1.00  5.53           C
ATOM    967  CB  SER   122      22.372   2.854  10.439  1.00  6.02           C
ATOM    968  OG  SER   122      23.234   2.952  11.569  1.00  6.51           O
ATOM    969  C   SER   122      24.250   1.808   9.093  1.00  5.41           C
ATOM    970  O   SER   122      24.705   2.878   8.684  1.00  5.28           O
ATOM    971  N   GLU   123      24.990   0.697   9.158  1.00  5.57           N
ATOM    972  CA  GLU   123      26.402   0.719   8.783  1.00  6.04           C
ATOM    973  CB  GLU   123      26.998  -0.694   8.762  1.00  7.03           C
ATOM    974  CG  GLU   123      27.265  -1.228  10.146  1.00 10.40           C
ATOM    975  CD  GLU   123      27.928  -2.592  10.122  1.00 16.71           C
ATOM    976  OE1 GLU   123      28.176  -3.138   9.010  1.00 18.65           O
ATOM    977  OE2 GLU   123      28.196  -3.120  11.226  1.00 19.05           O
ATOM    978  C   GLU   123      26.622   1.399   7.439  1.00  5.58           C
ATOM    979  O   GLU   123      25.891   1.135   6.457  1.00  5.05           O
ATOM    980  N   GLY   124      27.617   2.277   7.395  1.00  4.24           N
ATOM    981  CA  GLY   124      27.957   2.970   6.159  1.00  3.98           C
ATOM    982  C   GLY   124      27.079   4.158   5.779  1.00  3.83           C
ATOM    983  O   GLY   124      27.319   4.781   4.759  1.00  3.96           O
ATOM    984  N   THR   125      26.071   4.479   6.593  1.00  3.61           N
ATOM    985  CA  THR   125      25.171   5.603   6.329  1.00  3.88           C
ATOM    986  CB  THR   125      23.719   5.285   6.790  1.00  3.79           C
ATOM    987  OG1 THR   125      23.635   5.329   8.224  1.00  2.98           O
ATOM    988  CG2 THR   125      23.292   3.903   6.295  1.00  5.14           C
ATOM    989  C   THR   125      25.594   6.892   7.025  1.00  4.01           C
ATOM    990  O   THR   125      25.047   7.975   6.739  1.00  4.24           O
ATOM    991  N   GLY   126      26.509   6.763   7.986  1.00  3.16           N
ATOM    992  CA  GLY   126      26.991   7.896   8.764  1.00  3.02           C
ATOM    993  C   GLY   126      26.126   8.369   9.924  1.00  2.57           C
ATOM    994  O   GLY   126      26.458   9.350  10.569  1.00  2.12           O
ATOM    995  N   PHE   127      24.993   7.721  10.174  1.00  3.20           N
ATOM    996  CA  PHE   127      24.185   8.100  11.346  1.00  2.65           C
ATOM    997  CB  PHE   127      22.818   7.420  11.353  1.00  3.03           C
ATOM    998  CG  PHE   127      21.811   8.082  10.454  1.00  4.00           C
ATOM    999  CD1 PHE   127      21.113   9.208  10.880  1.00  4.40           C
ATOM   1000  CE1 PHE   127      20.186   9.841  10.040  1.00  2.17           C
ATOM   1001  CZ  PHE   127      19.955   9.342   8.796  1.00  3.15           C
ATOM   1002  CE2 PHE   127      20.621   8.202   8.366  1.00  3.16           C
ATOM   1003  CD2 PHE   127      21.561   7.586   9.183  1.00  2.91           C
ATOM   1004  C   PHE   127      24.935   7.766  12.647  1.00  2.77           C
ATOM   1005  O   PHE   127      25.556   6.706  12.774  1.00  2.00           O
ATOM   1006  N   ARG   128      24.857   8.686  13.600  1.00  2.53           N
ATOM   1007  CA  ARG   128      25.471   8.512  14.905  1.00  3.52           C
ATOM   1008  CB  ARG   128      26.287   9.757  15.260  1.00  3.97           C
ATOM   1009  CG  ARG   128      27.535   9.823  14.398  1.00  7.72           C
ATOM   1010  CD  ARG   128      27.795  11.209  13.917  1.00 11.74           C
ATOM   1011  NE  ARG   128      26.517  11.828  13.563  1.00 13.54           N
ATOM   1012  CZ  ARG   128      26.392  13.088  13.169  1.00 10.99           C
ATOM   1013  NH1 ARG   128      27.495  13.850  13.047  1.00 10.55           N
ATOM   1014  NH2 ARG   128      25.191  13.563  12.879  1.00  4.20           N
ATOM   1015  C   ARG   128      24.388   8.215  15.933  1.00  3.59           C
ATOM   1016  O   ARG   128      23.474   9.017  16.178  1.00  3.03           O
ATOM   1017  N   ILE   129      24.471   7.024  16.500  1.00  3.61           N
ATOM   1018  CA  ILE   129      23.449   6.543  17.388  1.00  3.38           C
ATOM   1019  CB  ILE   129      22.873   5.265  16.837  1.00  3.90           C
ATOM   1020  CG1 ILE   129      22.297   5.513  15.431  1.00  5.13           C
ATOM   1021  CD1 ILE   129      22.597   4.385  14.452  1.00  5.34           C
ATOM   1022  CG2 ILE   129      21.843   4.676  17.796  1.00  2.38           C
ATOM   1023  C   ILE   129      24.147   6.276  18.709  1.00  4.22           C
ATOM   1024  O   ILE   129      25.225   5.666  18.750  1.00  3.31           O
ATOM   1025  N   HIS   130      23.550   6.753  19.788  1.00  4.46           N
ATOM   1026  CA  HIS   130      24.240   6.805  21.068  1.00  5.28           C
ATOM   1027  CB  HIS   130      24.653   8.249  21.391  1.00  5.77           C
ATOM   1028  CG  HIS   130      25.719   8.786  20.496  1.00  8.01           C
ATOM   1029  ND1 HIS   130      27.051   8.470  20.655  1.00 12.01           N
ATOM   1030  CE1 HIS   130      27.761   9.075  19.715  1.00 11.42           C
ATOM   1031  NE2 HIS   130      26.931   9.758  18.944  1.00 11.39           N
ATOM   1032  CD2 HIS   130      25.649   9.592  19.407  1.00  8.29           C
ATOM   1033  C   HIS   130      23.361   6.307  22.193  1.00  4.99           C
ATOM   1034  O   HIS   130      22.137   6.374  22.117  1.00  3.70           O
ATOM   1035  N   MET   131      24.005   5.811  23.233  1.00  5.47           N
ATOM   1036  CA  MET   131      23.395   5.704  24.542  1.00  6.59           C
ATOM   1037  CB  MET   131      23.569   4.289  25.089  1.00  6.48           C
ATOM   1038  CG  MET   131      22.939   3.255  24.175  1.00  8.78           C
ATOM   1039  SD  MET   131      22.701   1.658  24.951  1.00  9.07           S
ATOM   1040  CE  MET   131      24.337   0.955  24.850  1.00 13.73           C
ATOM   1041  C   MET   131      24.178   6.728  25.360  1.00  7.00           C
ATOM   1042  O   MET   131      25.341   6.997  25.052  1.00  7.28           O
ATOM   1043  N   ILE   132      23.564   7.338  26.363  1.00  7.35           N
ATOM   1044  CA  ILE   132      24.318   8.245  27.214  1.00  7.34           C
ATOM   1045  CB  ILE   132      23.625   9.612  27.363  1.00  7.59           C
ATOM   1046  CG1 ILE   132      23.469  10.281  25.985  1.00  6.69           C
ATOM   1047  CD1 ILE   132      22.551  11.485  25.985  1.00  7.48           C
ATOM   1048  CG2 ILE   132      24.438  10.489  28.330  1.00  7.04           C
ATOM   1049  C   ILE   132      24.643   7.624  28.598  1.00  7.77           C
ATOM   1050  O   ILE   132      23.787   7.504  29.480  1.00  7.79           O
ATOM   1051  N   HIS   133      25.891   7.223  28.763  1.00  7.80           N
ATOM   1052  CA  HIS   133      26.340   6.557  29.971  1.00  8.35           C
ATOM   1053  CB  HIS   133      27.483   5.565  29.655  1.00  8.72           C
ATOM   1054  CG  HIS   133      27.048   4.398  28.823  1.00 10.75           C
ATOM   1055  ND1 HIS   133      26.449   3.279  29.368  1.00 13.62           N
ATOM   1056  CE1 HIS   133      26.145   2.430  28.400  1.00 14.32           C
ATOM   1057  NE2 HIS   133      26.508   2.965  27.245  1.00 14.63           N
ATOM   1058  CD2 HIS   133      27.069   4.199  27.482  1.00 12.82           C
ATOM   1059  C   HIS   133      26.784   7.562  31.018  1.00  8.10           C
ATOM   1060  O   HIS   133      26.924   8.757  30.726  1.00  7.93           O
ATOM   1061  N   LYS   134      27.017   7.057  32.227  1.00  7.98           N
ATOM   1062  CA  LYS   134      27.360   7.867  33.392  1.00  8.10           C
ATOM   1063  CB  LYS   134      27.757   6.958  34.568  1.00  8.20           C
ATOM   1064  CG  LYS   134      26.594   6.413  35.404  1.00  8.64           C
ATOM   1065  CD  LYS   134      27.152   5.631  36.614  1.00  9.93           C
ATOM   1066  CE  LYS   134      26.100   5.414  37.689  1.00 10.02           C
ATOM   1067  NZ  LYS   134      24.906   4.719  37.135  1.00 10.40           N
ATOM   1068  C   LYS   134      28.469   8.886  33.158  1.00  8.09           C
ATOM   1069  O   LYS   134      28.315  10.066  33.474  1.00  8.89           O
ATOM   1070  N   ALA   135      29.601   8.435  32.634  1.00  7.78           N
ATOM   1071  CA  ALA   135      30.725   9.344  32.348  1.00  7.06           C
ATOM   1072  CB  ALA   135      31.933   8.544  31.953  1.00  6.58           C
ATOM   1073  C   ALA   135      30.388  10.416  31.272  1.00  7.07           C
ATOM   1074  O   ALA   135      30.828  11.569  31.361  1.00  5.86           O
ATOM   1075  N   ALA   136      29.612  10.037  30.259  1.00  7.08           N
ATOM   1076  CA  ALA   136      29.136  11.015  29.285  1.00  8.14           C
ATOM   1077  CB  ALA   136      28.414  10.320  28.132  1.00  8.53           C
ATOM   1078  C   ALA   136      28.208  12.054  29.949  1.00  9.04           C
ATOM   1079  O   ALA   136      28.216  13.240  29.594  1.00  8.86           O
ATOM   1080  N   VAL   137      27.402  11.597  30.902  1.00  9.47           N
ATOM   1081  CA  VAL   137      26.561  12.496  31.665  1.00 10.61           C
ATOM   1082  CB  VAL   137      25.621  11.706  32.624  1.00 10.83           C
ATOM   1083  CG1 VAL   137      24.750  12.663  33.472  1.00 10.73           C
ATOM   1084  CG2 VAL   137      24.760  10.711  31.837  1.00  8.15           C
ATOM   1085  C   VAL   137      27.462  13.446  32.466  1.00 11.72           C
ATOM   1086  O   VAL   137      27.307  14.663  32.410  1.00 11.69           O
ATOM   1087  N   ALA   138      28.414  12.883  33.205  1.00 12.47           N
ATOM   1088  CA  ALA   138      29.390  13.703  33.914  1.00 13.56           C
ATOM   1089  CB  ALA   138      30.415  12.826  34.616  1.00 13.10           C
ATOM   1090  C   ALA   138      30.077  14.704  32.967  1.00 14.14           C
ATOM   1091  O   ALA   138      30.207  15.878  33.291  1.00 14.53           O
ATOM   1092  N   ALA   139      30.490  14.243  31.792  1.00 14.92           N
ATOM   1093  CA  ALA   139      31.201  15.105  30.842  1.00 16.02           C
ATOM   1094  CB  ALA   139      32.042  14.274  29.896  1.00 16.22           C
ATOM   1095  C   ALA   139      30.335  16.087  30.040  1.00 16.61           C
ATOM   1096  O   ALA   139      30.876  16.962  29.375  1.00 16.58           O
ATOM   1097  N   LYS   140      29.009  15.943  30.086  1.00 17.36           N
ATOM   1098  CA  LYS   140      28.133  16.847  29.343  1.00 17.49           C
ATOM   1099  CB  LYS   140      28.375  18.302  29.775  1.00 17.87           C
ATOM   1100  CG  LYS   140      27.917  18.654  31.192  1.00 19.17           C
ATOM   1101  CD  LYS   140      26.449  19.124  31.199  1.00 21.75           C
ATOM   1102  CE  LYS   140      25.975  19.491  32.608  1.00 22.07           C
ATOM   1103  NZ  LYS   140      24.537  19.921  32.677  1.00 21.26           N
ATOM   1104  C   LYS   140      28.410  16.710  27.853  1.00 17.29           C
ATOM   1105  O   LYS   140      28.281  17.664  27.094  1.00 17.27           O
ATOM   1106  N   LYS   141      28.795  15.513  27.432  1.00 17.15           N
ATOM   1107  CA  LYS   141      29.212  15.306  26.054  1.00 17.26           C
ATOM   1108  CB  LYS   141      29.758  13.883  25.865  1.00 17.28           C
ATOM   1109  CG  LYS   141      30.601  13.701  24.603  1.00 19.02           C
ATOM   1110  CD  LYS   141      30.559  12.250  24.107  1.00 21.82           C
ATOM   1111  CE  LYS   141      30.748  12.166  22.586  1.00 21.87           C
ATOM   1112  NZ  LYS   141      31.105  10.793  22.133  1.00 21.82           N
ATOM   1113  C   LYS   141      28.084  15.598  25.043  1.00 17.19           C
ATOM   1114  O   LYS   141      28.347  15.921  23.885  1.00 16.57           O
ATOM   1115  N   PHE   142      26.830  15.471  25.467  1.00 17.38           N
ATOM   1116  CA  PHE   142      25.708  15.700  24.542  1.00 18.04           C
ATOM   1117  CB  PHE   142      24.792  14.479  24.463  1.00 17.39           C
ATOM   1118  CG  PHE   142      25.492  13.239  24.020  1.00 17.23           C
ATOM   1119  CD1 PHE   142      26.091  12.400  24.946  1.00 18.95           C
ATOM   1120  CE1 PHE   142      26.751  11.258  24.540  1.00 18.92           C
ATOM   1121  CZ  PHE   142      26.822  10.945  23.197  1.00 19.30           C
ATOM   1122  CE2 PHE   142      26.221  11.770  22.263  1.00 19.14           C
ATOM   1123  CD2 PHE   142      25.569  12.913  22.677  1.00 18.44           C
ATOM   1124  C   PHE   142      24.916  16.919  24.949  1.00 18.77           C
ATOM   1125  O   PHE   142      23.770  17.086  24.539  1.00 19.52           O
ATOM   1126  N   GLY   143      25.531  17.767  25.764  1.00 19.79           N
ATOM   1127  CA  GLY   143      24.896  19.001  26.208  1.00 20.51           C
ATOM   1128  C   GLY   143      24.483  19.922  25.071  1.00 21.43           C
ATOM   1129  O   GLY   143      24.968  19.804  23.941  1.00 21.03           O
ATOM   1130  N   PRO   144      23.545  20.839  25.363  1.00 22.22           N
ATOM   1131  CA  PRO   144      23.202  21.927  24.444  1.00 22.20           C
ATOM   1132  CB  PRO   144      22.248  22.788  25.278  1.00 22.24           C
ATOM   1133  CG  PRO   144      21.518  21.754  26.140  1.00 22.75           C
ATOM   1134  CD  PRO   144      22.589  20.730  26.489  1.00 21.98           C
ATOM   1135  C   PRO   144      24.431  22.731  23.959  1.00 22.05           C
ATOM   1136  O   PRO   144      24.429  23.219  22.822  1.00 22.83           O
ATOM   1137  N   LYS   145      25.485  22.841  24.765  1.00 20.97           N
ATOM   1138  CA  LYS   145      26.684  23.546  24.279  1.00 20.14           C
ATOM   1139  CB  LYS   145      27.315  24.406  25.380  1.00 20.22           C
ATOM   1144  C   LYS   145      27.739  22.630  23.640  1.00 19.49           C
ATOM   1145  O   LYS   145      28.912  22.976  23.579  1.00 19.66           O
ATOM   1146  N   SER   146      27.322  21.468  23.152  1.00 18.25           N
ATOM   1147  CA  SER   146      28.250  20.547  22.495  1.00 16.80           C
ATOM   1148  CB  SER   146      27.864  19.099  22.807  1.00 16.94           C
ATOM   1149  OG  SER   146      26.706  18.719  22.061  1.00 14.20           O
ATOM   1150  C   SER   146      28.232  20.739  20.978  1.00 16.24           C
ATOM   1151  O   SER   146      27.574  21.642  20.460  1.00 15.50           O
ATOM   1152  N   SER   147      28.937  19.853  20.285  1.00 15.80           N
ATOM   1153  CA  SER   147      29.011  19.824  18.815  1.00 15.62           C
ATOM   1154  CB  SER   147      29.947  18.683  18.396  1.00 15.78           C
ATOM   1155  OG  SER   147      29.349  17.415  18.708  1.00 17.28           O
ATOM   1156  C   SER   147      27.648  19.610  18.118  1.00 14.85           C
ATOM   1157  O   SER   147      27.420  20.110  17.025  1.00 15.12           O
ATOM   1158  N   LYS   148      26.768  18.838  18.742  1.00 13.81           N
ATOM   1159  CA  LYS   148      25.466  18.470  18.151  1.00 13.28           C
ATOM   1160  CB  LYS   148      24.645  19.698  17.773  1.00 13.70           C
ATOM   1161  CG  LYS   148      24.599  20.705  18.891  1.00 16.01           C
ATOM   1162  CD  LYS   148      23.301  21.495  18.977  1.00 20.40           C
ATOM   1163  CE  LYS   148      23.398  22.428  20.204  1.00 23.32           C
ATOM   1164  NZ  LYS   148      22.284  23.426  20.342  1.00 25.99           N
ATOM   1165  C   LYS   148      25.561  17.493  16.976  1.00 12.03           C
ATOM   1166  O   LYS   148      24.594  17.278  16.250  1.00 11.95           O
ATOM   1167  N   LYS   149      26.726  16.894  16.810  1.00 10.19           N
ATOM   1168  CA  LYS   149      26.897  15.889  15.801  1.00  9.30           C
ATOM   1169  CB  LYS   149      28.340  15.866  15.295  1.00  9.29           C
ATOM   1170  CG  LYS   149      28.825  17.235  14.822  1.00 11.57           C
ATOM   1171  CD  LYS   149      29.563  17.189  13.475  1.00 14.93           C
ATOM   1172  CE  LYS   149      30.943  16.580  13.631  1.00 17.83           C
ATOM   1173  NZ  LYS   149      31.599  17.084  14.872  1.00 19.27           N
ATOM   1174  C   LYS   149      26.490  14.534  16.362  1.00  7.95           C
ATOM   1175  O   LYS   149      27.334  13.674  16.612  1.00  8.28           O
ATOM   1176  N   PHE   150      25.190  14.369  16.571  1.00  6.10           N
ATOM   1177  CA  PHE   150      24.603  13.100  16.965  1.00  5.12           C
ATOM   1178  CB  PHE   150      24.702  12.886  18.475  1.00  5.47           C
ATOM   1179  CG  PHE   150      24.635  14.160  19.287  1.00  7.37           C
ATOM   1180  CD1 PHE   150      23.421  14.643  19.755  1.00  9.59           C
ATOM   1181  CE1 PHE   150      23.357  15.800  20.500  1.00  9.47           C
ATOM   1182  CZ  PHE   150      24.499  16.487  20.800  1.00  9.07           C
ATOM   1183  CE2 PHE   150      25.724  16.029  20.342  1.00  9.88           C
ATOM   1184  CD2 PHE   150      25.790  14.869  19.585  1.00  8.47           C
ATOM   1185  C   PHE   150      23.154  13.106  16.500  1.00  3.91           C
ATOM   1186  O   PHE   150      22.532  14.161  16.441  1.00  3.83           O
ATOM   1187  N   ASP   151      22.619  11.934  16.171  1.00  2.77           N
ATOM   1188  CA  ASP   151      21.342  11.847  15.442  1.00  2.00           C
ATOM   1189  CB  ASP   151      21.556  11.065  14.129  1.00  2.00           C
ATOM   1190  CG  ASP   151      22.543  11.759  13.176  1.00  2.00           C
ATOM   1191  OD1 ASP   151      22.199  12.859  12.726  1.00  2.00           O
ATOM   1192  OD2 ASP   151      23.628  11.195  12.869  1.00  2.00           O
ATOM   1193  C   ASP   151      20.233  11.175  16.258  1.00  2.00           C
ATOM   1194  O   ASP   151      19.088  11.648  16.299  1.00  2.00           O
ATOM   1195  N   ILE   152      20.562  10.042  16.867  1.00  2.00           N
ATOM   1196  CA  ILE   152      19.550   9.177  17.472  1.00  2.00           C
ATOM   1197  CB  ILE   152      19.290   7.938  16.625  1.00  2.00           C
ATOM   1198  CG1 ILE   152      18.757   8.344  15.239  1.00  2.80           C
ATOM   1199  CD1 ILE   152      18.685   7.140  14.237  1.00  3.82           C
ATOM   1200  CG2 ILE   152      18.272   6.982  17.326  1.00  2.00           C
ATOM   1201  C   ILE   152      20.018   8.762  18.854  1.00  2.00           C
ATOM   1202  O   ILE   152      21.188   8.342  19.010  1.00  2.00           O
ATOM   1203  N   LEU   153      19.136   8.914  19.854  1.00  2.00           N
ATOM   1204  CA  LEU   153      19.447   8.502  21.237  1.00  2.00           C
ATOM   1205  CB  LEU   153      19.176   9.677  22.209  1.00  2.00           C
ATOM   1206  CG  LEU   153      19.434   9.376  23.700  1.00  2.00           C
ATOM   1207  CD1 LEU   153      20.914   9.084  23.976  1.00  2.00           C
ATOM   1208  CD2 LEU   153      18.933  10.532  24.619  1.00  2.00           C
ATOM   1209  C   LEU   153      18.604   7.302  21.655  1.00  2.00           C
ATOM   1210  O   LEU   153      17.371   7.331  21.519  1.00  2.00           O
ATOM   1211  N   VAL   154      19.246   6.246  22.157  1.00  2.36           N
ATOM   1212  CA  VAL   154      18.499   5.148  22.804  1.00  2.17           C
ATOM   1213  CB  VAL   154      18.931   3.724  22.300  1.00  3.16           C
ATOM   1214  CG1 VAL   154      17.880   2.664  22.743  1.00  2.00           C
ATOM   1215  CG2 VAL   154      19.050   3.693  20.759  1.00  2.42           C
ATOM   1216  C   VAL   154      18.716   5.243  24.310  1.00  2.60           C
ATOM   1217  O   VAL   154      19.842   5.361  24.766  1.00  2.46           O
ATOM   1218  N   THR   155      17.653   5.181  25.105  1.00  2.34           N
ATOM   1219  CA  THR   155      17.830   5.427  26.527  1.00  2.60           C
ATOM   1220  CB  THR   155      17.955   6.970  26.783  1.00  2.96           C
ATOM   1221  OG1 THR   155      18.328   7.209  28.135  1.00  4.18           O
ATOM   1222  CG2 THR   155      16.639   7.665  26.526  1.00  2.00           C
ATOM   1223  C   THR   155      16.684   4.825  27.363  1.00  2.43           C
ATOM   1224  O   THR   155      15.748   4.224  26.822  1.00  2.00           O
ATOM   1225  N   THR   156      16.799   4.974  28.677  1.00  2.00           N
ATOM   1226  CA  THR   156      15.783   4.571  29.617  1.00  2.10           C
ATOM   1227  CB  THR   156      16.417   3.916  30.836  1.00  2.00           C
ATOM   1228  OG1 THR   156      17.341   4.846  31.414  1.00  2.00           O
ATOM   1229  CG2 THR   156      17.152   2.646  30.439  1.00  3.36           C
ATOM   1230  C   THR   156      15.074   5.833  30.110  1.00  2.00           C
ATOM   1231  O   THR   156      15.585   6.933  29.971  1.00  2.88           O
ATOM   1232  N   PRO   157      13.887   5.670  30.693  1.00  2.41           N
ATOM   1233  CA  PRO   157      13.150   6.821  31.217  1.00  2.25           C
ATOM   1234  CB  PRO   157      11.909   6.180  31.832  1.00  2.61           C
ATOM   1235  CG  PRO   157      11.802   4.788  31.141  1.00  2.11           C
ATOM   1236  CD  PRO   157      13.179   4.382  30.870  1.00  2.00           C
ATOM   1237  C   PRO   157      13.949   7.585  32.299  1.00  3.24           C
ATOM   1238  O   PRO   157      13.993   8.840  32.273  1.00  3.29           O
ATOM   1239  N   ASN   158      14.536   6.861  33.260  1.00  2.64           N
ATOM   1240  CA  ASN   158      15.203   7.533  34.391  1.00  3.59           C
ATOM   1241  CB  ASN   158      15.594   6.548  35.497  1.00  3.31           C
ATOM   1242  CG  ASN   158      14.403   6.039  36.274  1.00  5.55           C
ATOM   1243  OD1 ASN   158      13.294   6.572  36.171  1.00  5.84           O
ATOM   1244  ND2 ASN   158      14.631   5.001  37.073  1.00  6.54           N
ATOM   1245  C   ASN   158      16.452   8.289  33.967  1.00  3.08           C
ATOM   1246  O   ASN   158      16.742   9.365  34.487  1.00  2.08           O
ATOM   1247  N   ARG   159      17.191   7.707  33.032  1.00  2.89           N
ATOM   1248  CA  ARG   159      18.421   8.335  32.542  1.00  4.01           C
ATOM   1249  CB  ARG   159      19.200   7.377  31.611  1.00  4.52           C
ATOM   1250  CG  ARG   159      20.411   8.033  30.878  1.00  6.25           C
ATOM   1251  CD  ARG   159      21.462   8.624  31.859  1.00  8.89           C
ATOM   1252  NE  ARG   159      21.787   7.727  32.977  1.00 10.47           N
ATOM   1253  CZ  ARG   159      22.765   6.812  32.958  1.00 12.46           C
ATOM   1254  NH1 ARG   159      23.533   6.649  31.883  1.00 11.80           N
ATOM   1255  NH2 ARG   159      22.980   6.051  34.020  1.00 12.56           N
ATOM   1256  C   ARG   159      18.097   9.615  31.801  1.00  3.36           C
ATOM   1257  O   ARG   159      18.780  10.640  31.965  1.00  4.40           O
ATOM   1258  N   LEU   160      17.054   9.559  30.989  1.00  2.00           N
ATOM   1259  CA  LEU   160      16.660  10.706  30.202  1.00  2.44           C
ATOM   1260  CB  LEU   160      15.622  10.313  29.171  1.00  2.28           C
ATOM   1261  CG  LEU   160      14.998  11.428  28.342  1.00  3.82           C
ATOM   1262  CD1 LEU   160      16.069  12.209  27.507  1.00  2.00           C
ATOM   1263  CD2 LEU   160      13.957  10.827  27.432  1.00  2.95           C
ATOM   1264  C   LEU   160      16.135  11.830  31.107  1.00  2.72           C
ATOM   1265  O   LEU   160      16.424  13.008  30.874  1.00  2.76           O
ATOM   1266  N   ILE   161      15.397  11.455  32.152  1.00  2.00           N
ATOM   1267  CA  ILE   161      14.815  12.430  33.043  1.00  2.02           C
ATOM   1268  CB  ILE   161      13.787  11.796  34.017  1.00  2.00           C
ATOM   1269  CG1 ILE   161      12.568  11.306  33.241  1.00  2.11           C
ATOM   1270  CD1 ILE   161      11.596  12.437  32.909  1.00  3.36           C
ATOM   1271  CG2 ILE   161      13.313  12.862  35.069  1.00  2.00           C
ATOM   1272  C   ILE   161      15.926  13.057  33.866  1.00  2.03           C
ATOM   1273  O   ILE   161      15.916  14.253  34.155  1.00  2.00           O
ATOM   1274  N   TYR   162      16.882  12.233  34.271  1.00  2.15           N
ATOM   1275  CA  TYR   162      18.036  12.769  34.967  1.00  2.55           C
ATOM   1276  CB  TYR   162      19.022  11.651  35.303  1.00  3.03           C
ATOM   1277  CG  TYR   162      20.128  12.132  36.191  1.00  2.26           C
ATOM   1278  CD1 TYR   162      19.958  12.170  37.560  1.00  4.34           C
ATOM   1279  CE1 TYR   162      20.956  12.618  38.396  1.00  4.04           C
ATOM   1280  CZ  TYR   162      22.146  13.044  37.847  1.00  5.35           C
ATOM   1281  OH  TYR   162      23.138  13.498  38.670  1.00  5.30           O
ATOM   1282  CE2 TYR   162      22.341  13.034  36.479  1.00  5.58           C
ATOM   1283  CD2 TYR   162      21.322  12.579  35.655  1.00  3.64           C
ATOM   1284  C   TYR   162      18.713  13.877  34.142  1.00  2.00           C
ATOM   1285  O   TYR   162      19.035  14.948  34.655  1.00  2.26           O
ATOM   1286  N   LEU   163      18.931  13.625  32.864  1.00  2.00           N
ATOM   1287  CA  LEU   163      19.542  14.638  31.983  1.00  2.00           C
ATOM   1288  CB  LEU   163      19.791  14.064  30.593  1.00  2.00           C
ATOM   1289  CG  LEU   163      20.802  12.921  30.505  1.00  2.76           C
ATOM   1290  CD1 LEU   163      20.720  12.258  29.132  1.00  4.31           C
ATOM   1291  CD2 LEU   163      22.192  13.419  30.802  1.00  6.30           C
ATOM   1292  C   LEU   163      18.709  15.933  31.865  1.00  2.00           C
ATOM   1293  O   LEU   163      19.251  17.026  31.953  1.00  2.00           O
ATOM   1294  N   LEU   164      17.403  15.782  31.657  1.00  2.29           N
ATOM   1295  CA  LEU   164      16.484  16.898  31.519  1.00  3.44           C
ATOM   1296  CB  LEU   164      15.062  16.385  31.240  1.00  3.14           C
ATOM   1297  CG  LEU   164      14.812  15.873  29.811  1.00  4.59           C
ATOM   1298  CD1 LEU   164      13.444  15.173  29.600  1.00  2.00           C
ATOM   1299  CD2 LEU   164      15.015  17.001  28.789  1.00  4.77           C
ATOM   1300  C   LEU   164      16.476  17.758  32.782  1.00  4.24           C
ATOM   1301  O   LEU   164      16.260  18.967  32.716  1.00  4.53           O
ATOM   1302  N   LYS   165      16.708  17.133  33.936  1.00  4.83           N
ATOM   1303  CA  LYS   165      16.526  17.820  35.201  1.00  5.58           C
ATOM   1304  CB  LYS   165      15.909  16.890  36.253  1.00  6.35           C
ATOM   1305  CG  LYS   165      14.449  16.500  35.958  1.00 11.04           C
ATOM   1306  CD  LYS   165      13.647  17.692  35.409  1.00 15.28           C
ATOM   1307  CE  LYS   165      12.149  17.344  35.249  1.00 18.91           C
ATOM   1308  NZ  LYS   165      11.875  16.295  34.186  1.00 21.31           N
ATOM   1309  C   LYS   165      17.812  18.409  35.739  1.00  5.38           C
ATOM   1310  O   LYS   165      17.779  19.139  36.713  1.00  4.35           O
ATOM   1311  N   GLN   166      18.947  18.079  35.127  1.00  5.29           N
ATOM   1312  CA  GLN   166      20.202  18.710  35.509  1.00  5.66           C
ATOM   1313  CB  GLN   166      21.339  18.167  34.657  1.00  5.33           C
ATOM   1314  CG  GLN   166      21.743  16.762  34.980  1.00  5.29           C
ATOM   1315  CD  GLN   166      22.934  16.298  34.160  1.00  7.26           C
ATOM   1316  OE1 GLN   166      22.846  16.161  32.934  1.00  9.26           O
ATOM   1317  NE2 GLN   166      24.041  16.022  34.834  1.00  6.06           N
ATOM   1318  C   GLN   166      20.136  20.239  35.356  1.00  6.66           C
ATOM   1319  O   GLN   166      19.363  20.759  34.560  1.00  7.21           O
ATOM   1320  N   ASP   167      20.967  20.952  36.104  1.00  7.72           N
ATOM   1321  CA  ASP   167      21.025  22.401  36.022  1.00  8.65           C
ATOM   1322  CB  ASP   167      20.678  23.013  37.382  1.00  8.72           C
ATOM   1323  CG  ASP   167      20.897  24.518  37.421  1.00 11.15           C
ATOM   1324  OD1 ASP   167      20.741  25.165  36.355  1.00 12.51           O
ATOM   1325  OD2 ASP   167      21.223  25.053  38.514  1.00  9.59           O
ATOM   1326  C   ASP   167      22.422  22.836  35.605  1.00  8.92           C
ATOM   1327  O   ASP   167      23.338  22.835  36.430  1.00  8.62           O
ATOM   1328  N   PRO   168      22.591  23.215  34.318  1.00  9.32           N
ATOM   1329  CA  PRO   168      21.510  23.299  33.333  1.00  9.33           C
ATOM   1330  CB  PRO   168      22.045  24.310  32.317  1.00  9.51           C
ATOM   1331  CG  PRO   168      23.555  24.122  32.369  1.00 10.10           C
ATOM   1332  CD  PRO   168      23.904  23.495  33.712  1.00  9.20           C
ATOM   1333  C   PRO   168      21.313  21.951  32.672  1.00  9.12           C
ATOM   1334  O   PRO   168      22.095  21.036  32.921  1.00  8.91           O
ATOM   1335  N   PRO   169      20.275  21.826  31.830  1.00  9.05           N
ATOM   1336  CA  PRO   169      19.880  20.539  31.239  1.00  8.86           C
ATOM   1337  CB  PRO   169      18.774  20.932  30.262  1.00  8.62           C
ATOM   1338  CG  PRO   169      18.186  22.178  30.867  1.00  9.71           C
ATOM   1339  CD  PRO   169      19.373  22.917  31.427  1.00  9.23           C
ATOM   1340  C   PRO   169      21.020  19.850  30.489  1.00  8.21           C
ATOM   1341  O   PRO   169      21.704  20.501  29.705  1.00  8.96           O
ATOM   1342  N   GLY   170      21.218  18.561  30.742  1.00  6.31           N
ATOM   1343  CA  GLY   170      22.252  17.784  30.070  1.00  5.80           C
ATOM   1344  C   GLY   170      21.862  17.295  28.677  1.00  5.66           C
ATOM   1345  O   GLY   170      22.621  16.585  28.022  1.00  5.58           O
ATOM   1346  N   ILE   171      20.675  17.679  28.212  1.00  4.95           N
ATOM   1347  CA  ILE   171      20.250  17.331  26.869  1.00  5.59           C
ATOM   1348  CB  ILE   171      19.715  15.892  26.813  1.00  5.67           C
ATOM   1349  CG1 ILE   171      19.618  15.397  25.383  1.00  5.60           C
ATOM   1350  CD1 ILE   171      19.090  14.010  25.321  1.00  7.42           C
ATOM   1351  CG2 ILE   171      18.363  15.780  27.473  1.00  6.75           C
ATOM   1352  C   ILE   171      19.192  18.320  26.388  1.00  5.19           C
ATOM   1353  O   ILE   171      18.526  18.950  27.196  1.00  4.11           O
ATOM   1354  N   ASP   172      19.097  18.494  25.075  1.00  4.97           N
ATOM   1355  CA  ASP   172      18.110  19.393  24.474  1.00  6.12           C
ATOM   1356  CB  ASP   172      18.831  20.532  23.751  1.00  6.06           C
ATOM   1357  CG  ASP   172      17.886  21.393  22.911  1.00 10.18           C
ATOM   1358  OD1 ASP   172      16.647  21.245  23.020  1.00 13.82           O
ATOM   1359  OD2 ASP   172      18.379  22.240  22.143  1.00 12.47           O
ATOM   1360  C   ASP   172      17.299  18.554  23.486  1.00  5.65           C
ATOM   1361  O   ASP   172      17.876  17.916  22.617  1.00  6.36           O
ATOM   1362  N   LEU   173      15.977  18.546  23.630  1.00  5.44           N
ATOM   1363  CA  LEU   173      15.096  17.693  22.834  1.00  4.83           C
ATOM   1364  CB  LEU   173      14.097  16.970  23.740  1.00  4.83           C
ATOM   1365  CG  LEU   173      14.736  16.043  24.769  1.00  3.60           C
ATOM   1366  CD1 LEU   173      13.682  15.251  25.511  1.00  3.57           C
ATOM   1367  CD2 LEU   173      15.671  15.086  24.074  1.00  2.00           C
ATOM   1368  C   LEU   173      14.329  18.473  21.787  1.00  4.66           C
ATOM   1369  O   LEU   173      13.403  17.945  21.168  1.00  4.61           O
ATOM   1370  N   ALA   174      14.751  19.709  21.560  1.00  3.85           N
ATOM   1371  CA  ALA   174      14.048  20.606  20.666  1.00  4.01           C
ATOM   1372  CB  ALA   174      14.635  22.050  20.737  1.00  3.42           C
ATOM   1373  C   ALA   174      13.975  20.109  19.222  1.00  3.45           C
ATOM   1374  O   ALA   174      13.076  20.490  18.512  1.00  3.66           O
ATOM   1375  N   SER   175      14.899  19.266  18.777  1.00  2.95           N
ATOM   1376  CA  SER   175      14.824  18.762  17.396  1.00  2.37           C
ATOM   1377  CB  SER   175      16.187  18.841  16.742  1.00  3.34           C
ATOM   1378  OG  SER   175      16.712  20.149  16.915  1.00  4.22           O
ATOM   1379  C   SER   175      14.295  17.337  17.230  1.00  2.00           C
ATOM   1380  O   SER   175      14.289  16.790  16.112  1.00  2.00           O
ATOM   1381  N   VAL   176      13.870  16.722  18.326  1.00  2.00           N
ATOM   1382  CA  VAL   176      13.402  15.344  18.268  1.00  2.00           C
ATOM   1383  CB  VAL   176      13.076  14.746  19.694  1.00  2.13           C
ATOM   1384  CG1 VAL   176      12.382  13.348  19.597  1.00  2.00           C
ATOM   1385  CG2 VAL   176      14.320  14.621  20.539  1.00  2.00           C
ATOM   1386  C   VAL   176      12.152  15.311  17.395  1.00  2.53           C
ATOM   1387  O   VAL   176      11.166  16.004  17.656  1.00  2.00           O
ATOM   1388  N   GLU   177      12.189  14.499  16.356  1.00  2.40           N
ATOM   1389  CA  GLU   177      11.043  14.375  15.474  1.00  3.02           C
ATOM   1390  CB  GLU   177      11.535  14.368  14.030  1.00  3.09           C
ATOM   1391  CG  GLU   177      12.336  15.590  13.659  1.00  2.88           C
ATOM   1392  CD  GLU   177      12.863  15.540  12.210  1.00  6.49           C
ATOM   1393  OE1 GLU   177      12.427  14.653  11.417  1.00  8.10           O
ATOM   1394  OE2 GLU   177      13.713  16.396  11.870  1.00  5.79           O
ATOM   1395  C   GLU   177      10.274  13.087  15.769  1.00  3.31           C
ATOM   1396  O   GLU   177       9.071  12.987  15.514  1.00  2.97           O
ATOM   1397  N   TRP   178      10.971  12.087  16.302  1.00  4.21           N
ATOM   1398  CA  TRP   178      10.290  10.831  16.649  1.00  4.32           C
ATOM   1399  CB  TRP   178      10.708   9.682  15.691  1.00  3.79           C
ATOM   1400  CG  TRP   178       9.758   9.549  14.506  1.00  3.47           C
ATOM   1401  CD1 TRP   178      10.036   9.811  13.182  1.00  2.59           C
ATOM   1402  NE1 TRP   178       8.902   9.609  12.412  1.00  2.84           N
ATOM   1403  CE2 TRP   178       7.877   9.195  13.227  1.00  2.00           C
ATOM   1404  CD2 TRP   178       8.378   9.145  14.555  1.00  2.00           C
ATOM   1405  CE3 TRP   178       7.525   8.726  15.590  1.00  2.00           C
ATOM   1406  CZ3 TRP   178       6.218   8.391  15.272  1.00  2.99           C
ATOM   1407  CH2 TRP   178       5.751   8.446  13.929  1.00  3.97           C
ATOM   1408  CZ2 TRP   178       6.573   8.824  12.903  1.00  2.00           C
ATOM   1409  C   TRP   178      10.612  10.461  18.086  1.00  4.04           C
ATOM   1410  O   TRP   178      11.774  10.353  18.434  1.00  3.49           O
ATOM   1411  N   LEU   179       9.578  10.248  18.896  1.00  4.24           N
ATOM   1412  CA  LEU   179       9.748   9.723  20.245  1.00  5.21           C
ATOM   1413  CB  LEU   179       9.118  10.669  21.284  1.00  6.21           C
ATOM   1414  CG  LEU   179       9.038  10.281  22.767  1.00  6.16           C
ATOM   1415  CD1 LEU   179      10.432  10.225  23.341  1.00  8.08           C
ATOM   1416  CD2 LEU   179       8.229  11.336  23.507  1.00  7.38           C
ATOM   1417  C   LEU   179       9.079   8.351  20.289  1.00  5.60           C
ATOM   1418  O   LEU   179       7.851   8.224  20.088  1.00  4.36           O
ATOM   1419  N   VAL   180       9.907   7.323  20.469  1.00  4.72           N
ATOM   1420  CA  VAL   180       9.442   5.959  20.423  1.00  4.27           C
ATOM   1421  CB  VAL   180      10.286   5.111  19.432  1.00  4.63           C
ATOM   1422  CG1 VAL   180       9.896   3.636  19.532  1.00  3.54           C
ATOM   1423  CG2 VAL   180      10.113   5.628  17.984  1.00  3.58           C
ATOM   1424  C   VAL   180       9.582   5.333  21.808  1.00  4.59           C
ATOM   1425  O   VAL   180      10.658   5.404  22.421  1.00  3.03           O
ATOM   1426  N   VAL   181       8.489   4.740  22.296  1.00  3.74           N
ATOM   1427  CA  VAL   181       8.516   3.978  23.539  1.00  4.66           C
ATOM   1428  CB  VAL   181       7.414   4.456  24.532  1.00  4.72           C
ATOM   1429  CG1 VAL   181       7.486   3.707  25.845  1.00  5.80           C
ATOM   1430  CG2 VAL   181       7.564   5.961  24.804  1.00  3.26           C
ATOM   1431  C   VAL   181       8.410   2.489  23.195  1.00  5.58           C
ATOM   1432  O   VAL   181       7.422   2.024  22.579  1.00  5.52           O
ATOM   1433  N   ASP   182       9.456   1.753  23.545  1.00  6.03           N
ATOM   1434  CA  ASP   182       9.507   0.329  23.304  1.00  7.74           C
ATOM   1435  CB  ASP   182      10.906  -0.039  22.822  1.00  8.58           C
ATOM   1436  CG  ASP   182      11.008  -1.465  22.274  1.00 10.54           C
ATOM   1437  OD1 ASP   182      10.009  -2.067  21.787  1.00 11.50           O
ATOM   1438  OD2 ASP   182      12.135  -1.974  22.307  1.00 14.04           O
ATOM   1439  C   ASP   182       9.158  -0.399  24.596  1.00  8.09           C
ATOM   1440  O   ASP   182       9.537   0.041  25.690  1.00  8.59           O
ATOM   1441  N   GLU   183       8.435  -1.516  24.471  1.00  8.60           N
ATOM   1442  CA  GLU   183       7.890  -2.244  25.627  1.00  9.16           C
ATOM   1443  CB  GLU   183       9.006  -2.962  26.413  1.00  9.21           C
ATOM   1444  CG  GLU   183       9.852  -3.944  25.567  1.00 10.64           C
ATOM   1445  CD  GLU   183       9.104  -5.229  25.239  1.00 14.44           C
ATOM   1446  OE1 GLU   183       9.014  -6.089  26.130  1.00 15.05           O
ATOM   1447  OE2 GLU   183       8.599  -5.392  24.091  1.00 15.79           O
ATOM   1448  C   GLU   183       7.054  -1.341  26.551  1.00  9.83           C
ATOM   1449  O   GLU   183       7.249  -1.315  27.771  1.00 10.13           O
ATOM   1450  N   SER   184       6.122  -0.607  25.953  1.00 10.57           N
ATOM   1451  CA  SER   184       5.166   0.218  26.675  1.00 11.54           C
ATOM   1452  CB  SER   184       4.189   0.848  25.692  1.00 11.36           C
ATOM   1453  OG  SER   184       4.892   1.489  24.656  1.00 15.74           O
ATOM   1454  C   SER   184       4.344  -0.528  27.724  1.00 12.18           C
ATOM   1455  O   SER   184       4.029   0.032  28.788  1.00 11.97           O
ATOM   1456  N   ASP   185       3.935  -1.755  27.408  1.00 12.39           N
ATOM   1457  CA  ASP   185       3.155  -2.515  28.375  1.00 12.76           C
ATOM   1458  CB  ASP   185       2.746  -3.879  27.829  1.00 12.83           C
ATOM   1459  CG  ASP   185       3.864  -4.577  27.061  1.00 13.81           C
ATOM   1460  OD1 ASP   185       4.009  -5.809  27.247  1.00 15.77           O
ATOM   1461  OD2 ASP   185       4.566  -3.912  26.252  1.00 13.82           O
ATOM   1462  C   ASP   185       3.967  -2.665  29.653  1.00 13.02           C
ATOM   1463  O   ASP   185       3.457  -2.478  30.746  1.00 13.40           O
ATOM   1464  N   LYS   186       5.246  -2.990  29.527  1.00 13.78           N
ATOM   1465  CA  LYS   186       6.053  -3.198  30.727  1.00 14.23           C
ATOM   1466  CB  LYS   186       7.443  -3.752  30.390  1.00 14.24           C
ATOM   1467  CG  LYS   186       7.487  -4.916  29.373  1.00 15.92           C
ATOM   1468  CD  LYS   186       6.760  -6.177  29.846  1.00 17.57           C
ATOM   1469  CE  LYS   186       7.224  -7.427  29.051  1.00 19.17           C
ATOM   1470  NZ  LYS   186       6.857  -7.409  27.575  1.00 18.50           N
ATOM   1471  C   LYS   186       6.172  -1.884  31.499  1.00 14.39           C
ATOM   1472  O   LYS   186       5.892  -1.830  32.687  1.00 14.68           O
ATOM   1473  N   LEU   187       6.584  -0.825  30.810  1.00 14.72           N
ATOM   1474  CA  LEU   187       6.751   0.485  31.417  1.00 15.43           C
ATOM   1475  CB  LEU   187       7.222   1.520  30.368  1.00 14.73           C
ATOM   1476  CG  LEU   187       8.659   1.292  29.849  1.00 14.29           C
ATOM   1477  CD1 LEU   187       8.949   2.051  28.553  1.00 13.90           C
ATOM   1478  CD2 LEU   187       9.698   1.641  30.926  1.00 13.34           C
ATOM   1479  C   LEU   187       5.488   0.979  32.156  1.00 16.62           C
ATOM   1480  O   LEU   187       5.591   1.543  33.234  1.00 15.73           O
ATOM   1481  N   PHE   188       4.305   0.798  31.574  1.00 18.32           N
ATOM   1482  CA  PHE   188       3.091   1.261  32.258  1.00 20.50           C
ATOM   1483  CB  PHE   188       1.887   1.365  31.312  1.00 20.67           C
ATOM   1484  CG  PHE   188       1.959   2.508  30.348  1.00 21.46           C
ATOM   1485  CD1 PHE   188       1.542   3.780  30.724  1.00 23.32           C
ATOM   1486  CE1 PHE   188       1.607   4.848  29.824  1.00 22.90           C
ATOM   1487  CZ  PHE   188       2.081   4.640  28.549  1.00 22.23           C
ATOM   1488  CE2 PHE   188       2.498   3.370  28.164  1.00 23.53           C
ATOM   1489  CD2 PHE   188       2.430   2.314  29.061  1.00 21.49           C
ATOM   1490  C   PHE   188       2.732   0.338  33.416  1.00 21.63           C
ATOM   1491  O   PHE   188       1.770   0.587  34.131  1.00 22.07           O
ATOM   1492  N   GLU   189       3.483  -0.740  33.601  1.00 23.22           N
ATOM   1493  CA  GLU   189       3.156  -1.665  34.694  1.00 24.79           C
ATOM   1494  CB  GLU   189       3.031  -3.101  34.193  1.00 24.76           C
ATOM   1495  CG  GLU   189       2.816  -4.095  35.325  1.00 26.52           C
ATOM   1496  CD  GLU   189       3.397  -5.458  35.019  1.00 27.72           C
ATOM   1497  OE1 GLU   189       3.601  -5.763  33.821  1.00 28.72           O
ATOM   1498  OE2 GLU   189       3.646  -6.220  35.975  1.00 28.44           O
ATOM   1499  C   GLU   189       4.177  -1.627  35.817  1.00 25.36           C
ATOM   1500  O   GLU   189       3.869  -1.998  36.939  1.00 25.41           O
ATOM   1501  N   ASP   190       5.397  -1.202  35.495  1.00 26.50           N
ATOM   1502  CA  ASP   190       6.473  -1.105  36.478  1.00 27.41           C
ATOM   1503  CB  ASP   190       7.848  -1.099  35.794  1.00 27.50           C
ATOM   1507  C   ASP   190       6.292   0.147  37.332  1.00 27.94           C
ATOM   1508  O   ASP   190       6.213   0.057  38.551  1.00 28.15           O
ATOM   1509  N   GLY   191       6.219   1.310  36.686  1.00 28.41           N
ATOM   1510  CA  GLY   191       5.912   2.557  37.392  1.00 28.88           C
ATOM   1511  C   GLY   191       4.454   2.930  37.209  1.00 28.86           C
ATOM   1512  O   GLY   191       3.867   2.656  36.156  1.00 29.00           O
ATOM   1513  N   GLY   194       3.280   7.441  37.532  1.00 13.65           N
ATOM   1514  CA  GLY   194       4.742   7.291  37.628  1.00 14.04           C
ATOM   1515  C   GLY   194       5.459   7.423  36.293  1.00 14.29           C
ATOM   1516  O   GLY   194       6.032   8.465  35.983  1.00 14.10           O
ATOM   1517  N   PHE   195       5.447   6.353  35.498  1.00 14.67           N
ATOM   1518  CA  PHE   195       5.976   6.424  34.145  1.00 14.34           C
ATOM   1519  CB  PHE   195       5.991   5.039  33.477  1.00 14.07           C
ATOM   1520  CG  PHE   195       6.408   5.073  32.031  1.00 14.25           C
ATOM   1521  CD1 PHE   195       7.677   5.490  31.666  1.00 13.19           C
ATOM   1522  CE1 PHE   195       8.044   5.560  30.341  1.00 13.21           C
ATOM   1523  CZ  PHE   195       7.147   5.203  29.359  1.00 14.41           C
ATOM   1524  CE2 PHE   195       5.888   4.796  29.704  1.00 13.00           C
ATOM   1525  CD2 PHE   195       5.521   4.730  31.032  1.00 15.27           C
ATOM   1526  C   PHE   195       5.134   7.431  33.347  1.00 14.51           C
ATOM   1527  O   PHE   195       5.666   8.211  32.546  1.00 14.73           O
ATOM   1528  N   ARG   196       3.825   7.438  33.597  1.00 14.51           N
ATOM   1529  CA  ARG   196       2.907   8.343  32.881  1.00 14.80           C
ATOM   1530  CB  ARG   196       1.464   8.192  33.386  1.00 14.62           C
ATOM   1531  CG  ARG   196       0.747   6.941  32.888  1.00 17.16           C
ATOM   1532  CD  ARG   196      -0.635   6.773  33.559  1.00 20.06           C
ATOM   1533  NE  ARG   196      -0.975   5.358  33.714  1.00 23.74           N
ATOM   1534  CZ  ARG   196      -1.735   4.668  32.864  1.00 25.74           C
ATOM   1535  NH1 ARG   196      -2.250   5.261  31.797  1.00 28.10           N
ATOM   1536  NH2 ARG   196      -1.983   3.384  33.074  1.00 25.54           N
ATOM   1537  C   ARG   196       3.327   9.811  32.987  1.00 14.07           C
ATOM   1538  O   ARG   196       3.251  10.570  32.007  1.00 13.47           O
ATOM   1539  N   ASP   197       3.765  10.200  34.178  1.00 13.40           N
ATOM   1540  CA  ASP   197       4.198  11.571  34.414  1.00 13.44           C
ATOM   1541  CB  ASP   197       4.210  11.892  35.911  1.00 13.83           C
ATOM   1542  CG  ASP   197       2.820  11.896  36.512  1.00 15.53           C
ATOM   1543  OD1 ASP   197       1.844  12.178  35.775  1.00 18.69           O
ATOM   1544  OD2 ASP   197       2.701  11.597  37.715  1.00 17.58           O
ATOM   1545  C   ASP   197       5.557  11.868  33.796  1.00 12.75           C
ATOM   1546  O   ASP   197       5.771  12.969  33.287  1.00 12.41           O
ATOM   1547  N   GLN   198       6.473  10.893  33.845  1.00 12.40           N
ATOM   1548  CA  GLN   198       7.753  11.021  33.164  1.00 12.22           C
ATOM   1549  CB  GLN   198       8.566   9.738  33.315  1.00 12.10           C
ATOM   1550  CG  GLN   198       8.936   9.373  34.740  1.00 13.24           C
ATOM   1551  CD  GLN   198       9.944   8.211  34.794  1.00 14.17           C
ATOM   1552  OE1 GLN   198       9.743   7.171  34.160  1.00 12.65           O
ATOM   1553  NE2 GLN   198      11.030   8.396  35.544  1.00 11.92           N
ATOM   1554  C   GLN   198       7.518  11.297  31.678  1.00 12.38           C
ATOM   1555  O   GLN   198       8.072  12.232  31.095  1.00 12.34           O
ATOM   1556  N   LEU   199       6.698  10.461  31.058  1.00 12.17           N
ATOM   1557  CA  LEU   199       6.424  10.595  29.642  1.00 12.20           C
ATOM   1558  CB  LEU   199       5.543   9.430  29.205  1.00 12.49           C
ATOM   1559  CG  LEU   199       5.421   9.117  27.734  1.00 12.24           C
ATOM   1560  CD1 LEU   199       6.803   8.862  27.202  1.00 13.43           C
ATOM   1561  CD2 LEU   199       4.538   7.882  27.585  1.00 13.51           C
ATOM   1562  C   LEU   199       5.766  11.950  29.319  1.00 12.47           C
ATOM   1563  O   LEU   199       6.000  12.533  28.259  1.00 12.63           O
ATOM   1564  N   ALA   200       4.966  12.472  30.244  1.00 12.20           N
ATOM   1565  CA  ALA   200       4.410  13.800  30.059  1.00 12.43           C
ATOM   1566  CB  ALA   200       3.387  14.137  31.182  1.00 12.39           C
ATOM   1567  C   ALA   200       5.512  14.859  30.010  1.00 12.64           C
ATOM   1568  O   ALA   200       5.482  15.745  29.144  1.00 13.01           O
ATOM   1569  N   SER   201       6.469  14.784  30.939  1.00 12.08           N
ATOM   1570  CA  SER   201       7.543  15.767  30.996  1.00 12.37           C
ATOM   1571  CB  SER   201       8.272  15.725  32.337  1.00 12.50           C
ATOM   1572  OG  SER   201       8.865  14.464  32.527  1.00 15.19           O
ATOM   1573  C   SER   201       8.521  15.595  29.834  1.00 11.84           C
ATOM   1574  O   SER   201       8.949  16.569  29.235  1.00 12.03           O
ATOM   1575  N   ILE   202       8.858  14.364  29.492  1.00 11.64           N
ATOM   1576  CA  ILE   202       9.593  14.149  28.250  1.00 11.50           C
ATOM   1577  CB  ILE   202       9.883  12.661  27.987  1.00 10.98           C
ATOM   1578  CG1 ILE   202      10.881  12.131  29.032  1.00 10.77           C
ATOM   1579  CD1 ILE   202      10.783  10.603  29.318  1.00  8.30           C
ATOM   1580  CG2 ILE   202      10.451  12.473  26.573  1.00 11.35           C
ATOM   1581  C   ILE   202       8.880  14.814  27.051  1.00 11.56           C
ATOM   1582  O   ILE   202       9.453  15.672  26.385  1.00 11.84           O
ATOM   1583  N   PHE   203       7.635  14.441  26.787  1.00 11.93           N
ATOM   1584  CA  PHE   203       6.965  14.996  25.624  0.50 11.94           C
ATOM   1586  CB  PHE   203       5.571  14.404  25.461  0.50 11.71           C
ATOM   1588  CG  PHE   203       4.848  14.874  24.230  0.50 11.88           C
ATOM   1590  CD1 PHE   203       5.389  14.667  22.969  0.50 10.91           C
ATOM   1592  CE1 PHE   203       4.725  15.090  21.847  0.50 10.71           C
ATOM   1594  CZ  PHE   203       3.499  15.724  21.965  0.50  9.98           C
ATOM   1596  CE2 PHE   203       2.948  15.928  23.210  0.50 10.17           C
ATOM   1598  CD2 PHE   203       3.617  15.502  24.335  0.50  9.43           C
ATOM   1600  C   PHE   203       6.934  16.521  25.692  1.00 12.32           C
ATOM   1601  O   PHE   203       7.109  17.177  24.664  1.00 12.57           O
ATOM   1602  N   LEU   204       6.748  17.079  26.886  1.00 12.06           N
ATOM   1603  CA  LEU   204       6.676  18.536  27.017  1.00 11.46           C
ATOM   1604  CB  LEU   204       6.340  18.939  28.456  1.00 11.75           C
ATOM   1605  CG  LEU   204       6.267  20.424  28.832  1.00 11.35           C
ATOM   1606  CD1 LEU   204       5.007  21.076  28.246  1.00 12.68           C
ATOM   1607  CD2 LEU   204       6.305  20.559  30.360  1.00  9.95           C
ATOM   1608  C   LEU   204       7.983  19.171  26.568  1.00 10.99           C
ATOM   1609  O   LEU   204       7.980  20.273  26.045  1.00  9.86           O
ATOM   1610  N   ALA   205       9.093  18.444  26.743  1.00 10.33           N
ATOM   1611  CA  ALA   205      10.423  18.951  26.374  1.00  9.39           C
ATOM   1612  CB  ALA   205      11.479  18.195  27.157  1.00  8.99           C
ATOM   1613  C   ALA   205      10.690  18.866  24.843  1.00  9.23           C
ATOM   1614  O   ALA   205      11.560  19.564  24.288  1.00  7.95           O
ATOM   1615  N   CYS   206       9.931  18.004  24.174  1.00  8.66           N
ATOM   1616  CA  CYS   206      10.042  17.784  22.743  1.00  8.14           C
ATOM   1617  CB  CYS   206       9.561  16.367  22.408  1.00  8.61           C
ATOM   1618  SG  CYS   206      10.609  15.008  22.963  1.00  7.47           S
ATOM   1619  C   CYS   206       9.174  18.775  21.971  1.00  8.69           C
ATOM   1620  O   CYS   206       8.042  18.450  21.608  1.00  8.50           O
ATOM   1621  N   THR   207       9.727  19.955  21.687  1.00  8.50           N
ATOM   1622  CA  THR   207       8.957  21.096  21.239  1.00  8.61           C
ATOM   1623  CB  THR   207       9.537  22.436  21.809  1.00  9.24           C
ATOM   1624  OG1 THR   207      10.972  22.399  21.770  1.00  8.99           O
ATOM   1625  CG2 THR   207       9.056  22.698  23.262  1.00  9.22           C
ATOM   1626  C   THR   207       8.962  21.248  19.721  1.00  7.85           C
ATOM   1627  O   THR   207       8.432  22.208  19.209  1.00  7.52           O
ATOM   1628  N   SER   208       9.587  20.317  19.005  1.00  6.77           N
ATOM   1629  CA  SER   208       9.620  20.407  17.541  1.00  5.87           C
ATOM   1630  CB  SER   208      10.397  19.230  16.935  1.00  5.73           C
ATOM   1631  OG  SER   208      10.199  19.169  15.524  1.00  6.44           O
ATOM   1632  C   SER   208       8.219  20.394  16.966  1.00  5.58           C
ATOM   1633  O   SER   208       7.373  19.582  17.373  1.00  5.60           O
ATOM   1634  N   HIS   209       7.983  21.254  15.988  1.00  5.81           N
ATOM   1635  CA  HIS   209       6.730  21.244  15.258  1.00  6.57           C
ATOM   1636  CB  HIS   209       6.696  22.373  14.210  1.00  7.29           C
ATOM   1637  CG  HIS   209       7.680  22.206  13.087  1.00  8.13           C
ATOM   1638  ND1 HIS   209       7.304  21.805  11.820  1.00 10.61           N
ATOM   1639  CE1 HIS   209       8.373  21.746  11.041  1.00 10.03           C
ATOM   1640  NE2 HIS   209       9.426  22.104  11.755  1.00  9.86           N
ATOM   1641  CD2 HIS   209       9.019  22.404  13.034  1.00  8.52           C
ATOM   1642  C   HIS   209       6.517  19.895  14.591  1.00  6.78           C
ATOM   1643  O   HIS   209       5.392  19.545  14.240  1.00  6.70           O
ATOM   1644  N   LYS   210       7.593  19.119  14.449  1.00  5.95           N
ATOM   1645  CA  LYS   210       7.508  17.858  13.718  1.00  6.38           C
ATOM   1646  CB  LYS   210       8.816  17.559  12.956  1.00  6.79           C
ATOM   1647  CG  LYS   210       9.243  18.475  11.827  1.00  7.73           C
ATOM   1648  CD  LYS   210      10.190  17.692  10.897  1.00 11.94           C
ATOM   1649  CE  LYS   210      10.743  18.551   9.744  1.00 14.22           C
ATOM   1650  NZ  LYS   210      12.176  18.933   9.962  1.00 15.72           N
ATOM   1651  C   LYS   210       7.273  16.622  14.603  1.00  5.72           C
ATOM   1652  O   LYS   210       7.110  15.534  14.060  1.00  4.45           O
ATOM   1653  N   VAL   211       7.293  16.773  15.930  1.00  5.05           N
ATOM   1654  CA  VAL   211       7.372  15.593  16.802  1.00  5.54           C
ATOM   1655  CB  VAL   211       7.568  15.963  18.279  1.00  5.85           C
ATOM   1656  CG1 VAL   211       6.302  16.700  18.848  1.00  4.88           C
ATOM   1657  CG2 VAL   211       7.953  14.708  19.085  1.00  7.06           C
ATOM   1658  C   VAL   211       6.190  14.635  16.621  1.00  6.08           C
ATOM   1659  O   VAL   211       5.033  15.047  16.528  1.00  5.71           O
ATOM   1660  N   ARG   212       6.495  13.353  16.489  1.00  6.25           N
ATOM   1661  CA  ARG   212       5.447  12.346  16.499  1.00  6.87           C
ATOM   1662  CB  ARG   212       5.242  11.738  15.099  1.00  6.95           C
ATOM   1663  CG  ARG   212       4.868  12.782  14.018  1.00  7.15           C
ATOM   1664  CD  ARG   212       3.486  13.385  14.336  1.00  9.91           C
ATOM   1665  NE  ARG   212       3.017  14.177  13.223  1.00 13.37           N
ATOM   1666  CZ  ARG   212       3.284  15.470  13.067  1.00 18.86           C
ATOM   1667  NH1 ARG   212       4.011  16.113  13.968  1.00 20.13           N
ATOM   1668  NH2 ARG   212       2.814  16.128  12.019  1.00 20.40           N
ATOM   1669  C   ARG   212       5.830  11.277  17.499  1.00  7.01           C
ATOM   1670  O   ARG   212       7.002  11.097  17.763  1.00  6.38           O
ATOM   1671  N   ARG   213       4.834  10.582  18.040  1.00  6.71           N
ATOM   1672  CA  ARG   213       5.040   9.531  19.041  1.00  7.05           C
ATOM   1673  CB  ARG   213       4.278   9.874  20.347  1.00  6.81           C
ATOM   1674  CG  ARG   213       4.856  11.085  21.094  1.00  8.21           C
ATOM   1675  CD  ARG   213       3.899  11.702  22.059  1.00 12.29           C
ATOM   1676  NE  ARG   213       2.776  12.327  21.355  1.00 16.12           N
ATOM   1677  CZ  ARG   213       1.762  12.954  21.961  1.00 17.02           C
ATOM   1678  NH1 ARG   213       1.721  13.033  23.294  1.00 14.75           N
ATOM   1679  NH2 ARG   213       0.773  13.482  21.231  1.00 12.42           N
ATOM   1680  C   ARG   213       4.581   8.160  18.539  1.00  7.44           C
ATOM   1681  O   ARG   213       3.526   8.013  17.892  1.00  7.88           O
ATOM   1682  N   ALA   214       5.343   7.144  18.880  1.00  6.79           N
ATOM   1683  CA  ALA   214       4.918   5.798  18.563  1.00  6.25           C
ATOM   1684  CB  ALA   214       5.749   5.257  17.391  1.00  4.60           C
ATOM   1685  C   ALA   214       5.129   4.970  19.809  1.00  6.08           C
ATOM   1686  O   ALA   214       6.212   5.025  20.421  1.00  6.74           O
ATOM   1687  N   MET   215       4.102   4.213  20.206  1.00  5.11           N
ATOM   1688  CA  MET   215       4.236   3.318  21.332  1.00  5.53           C
ATOM   1689  CB  MET   215       3.099   3.502  22.325  1.00  5.46           C
ATOM   1690  CG  MET   215       2.756   4.944  22.683  1.00  8.94           C
ATOM   1691  SD  MET   215       4.000   5.739  23.717  1.00 12.43           S
ATOM   1692  CE  MET   215       3.548   5.088  25.322  1.00  9.43           C
ATOM   1693  C   MET   215       4.230   1.858  20.861  1.00  5.58           C
ATOM   1694  O   MET   215       3.277   1.415  20.217  1.00  5.62           O
ATOM   1695  N   PHE   216       5.268   1.118  21.224  1.00  4.63           N
ATOM   1696  CA  PHE   216       5.381  -0.282  20.899  1.00  4.89           C
ATOM   1697  CB  PHE   216       6.727  -0.559  20.202  1.00  4.64           C
ATOM   1698  CG  PHE   216       6.734  -0.172  18.746  1.00  4.39           C
ATOM   1699  CD1 PHE   216       6.676  -1.146  17.750  1.00  2.00           C
ATOM   1700  CE1 PHE   216       6.659  -0.786  16.377  1.00  2.00           C
ATOM   1701  CZ  PHE   216       6.718   0.554  16.029  1.00  2.00           C
ATOM   1702  CE2 PHE   216       6.765   1.543  17.014  1.00  2.00           C
ATOM   1703  CD2 PHE   216       6.778   1.176  18.372  1.00  4.24           C
ATOM   1704  C   PHE   216       5.228  -1.110  22.178  1.00  5.74           C
ATOM   1705  O   PHE   216       5.722  -0.727  23.245  1.00  6.17           O
ATOM   1706  N   SER   217       4.515  -2.222  22.068  1.00  5.46           N
ATOM   1707  CA  SER   217       4.262  -3.076  23.216  0.50  6.34           C
ATOM   1709  CB  SER   217       2.971  -2.670  23.906  0.50  6.10           C
ATOM   1711  OG  SER   217       1.890  -2.925  23.039  0.50  7.75           O
ATOM   1713  C   SER   217       4.143  -4.524  22.776  1.00  6.59           C
ATOM   1714  O   SER   217       3.816  -4.815  21.618  1.00  5.80           O
ATOM   1715  N   ALA   218       4.422  -5.436  23.704  1.00  7.17           N
ATOM   1716  CA  ALA   218       4.335  -6.854  23.398  1.00  9.39           C
ATOM   1717  CB  ALA   218       5.139  -7.677  24.397  1.00  9.06           C
ATOM   1718  C   ALA   218       2.886  -7.315  23.390  1.00 11.47           C
ATOM   1719  O   ALA   218       2.525  -8.250  22.674  1.00 12.22           O
ATOM   1720  N   THR   219       2.056  -6.676  24.197  1.00 13.13           N
ATOM   1721  CA  THR   219       0.703  -7.144  24.372  1.00 15.75           C
ATOM   1722  CB  THR   219       0.460  -7.633  25.803  1.00 16.00           C
ATOM   1723  OG1 THR   219       0.714  -6.555  26.712  1.00 15.79           O
ATOM   1724  CG2 THR   219       1.352  -8.830  26.155  1.00 16.51           C
ATOM   1725  C   THR   219      -0.252  -5.991  24.172  1.00 17.61           C
ATOM   1726  O   THR   219       0.005  -4.871  24.629  1.00 17.37           O
ATOM   1727  N   PHE   220      -1.381  -6.281  23.537  1.00 19.65           N
ATOM   1728  CA  PHE   220      -2.409  -5.277  23.323  1.00 21.75           C
ATOM   1729  CB  PHE   220      -3.269  -5.662  22.099  1.00 22.32           C
ATOM   1730  CG  PHE   220      -4.248  -4.592  21.653  1.00 25.67           C
ATOM   1731  CD1 PHE   220      -3.857  -3.253  21.481  1.00 27.90           C
ATOM   1732  CE1 PHE   220      -4.765  -2.286  21.056  1.00 29.11           C
ATOM   1733  CZ  PHE   220      -6.073  -2.651  20.768  1.00 29.43           C
ATOM   1734  CE2 PHE   220      -6.469  -3.975  20.914  1.00 29.06           C
ATOM   1735  CD2 PHE   220      -5.558  -4.938  21.345  1.00 27.95           C
ATOM   1736  C   PHE   220      -3.236  -5.075  24.604  1.00 22.23           C
ATOM   1737  O   PHE   220      -4.224  -5.791  24.843  1.00 22.55           O
ATOM   1738  N   ALA   221      -2.800  -4.099  25.420  1.00 22.77           N
ATOM   1739  CA  ALA   221      -3.206  -3.919  26.834  1.00 23.15           C
ATOM   1740  CB  ALA   221      -1.987  -3.967  27.735  1.00 23.36           C
ATOM   1741  C   ALA   221      -3.995  -2.643  27.128  1.00 23.64           C
ATOM   1742  O   ALA   221      -3.836  -1.633  26.437  1.00 24.08           O
ATOM   1743  N   TYR   222      -4.778  -2.676  28.213  1.00 23.88           N
ATOM   1744  CA  TYR   222      -5.899  -1.747  28.409  1.00 23.76           C
ATOM   1745  CB  TYR   222      -6.852  -2.219  29.525  1.00 23.84           C
ATOM   1746  CG  TYR   222      -8.114  -1.373  29.611  1.00 22.95           C
ATOM   1747  CD1 TYR   222      -8.362  -0.553  30.706  1.00 21.11           C
ATOM   1748  CE1 TYR   222      -9.505   0.234  30.764  1.00 20.73           C
ATOM   1749  CZ  TYR   222     -10.405   0.210  29.706  1.00 21.43           C
ATOM   1750  OH  TYR   222     -11.558   0.970  29.733  1.00 21.30           O
ATOM   1751  CE2 TYR   222     -10.167  -0.588  28.612  1.00 21.07           C
ATOM   1752  CD2 TYR   222      -9.035  -1.368  28.568  1.00 22.41           C
ATOM   1753  C   TYR   222      -5.536  -0.274  28.604  1.00 23.93           C
ATOM   1754  O   TYR   222      -6.041   0.587  27.871  1.00 23.70           O
ATOM   1755  N   ASP   223      -4.667   0.010  29.573  1.00 23.89           N
ATOM   1756  CA  ASP   223      -4.299   1.390  29.899  1.00 23.93           C
ATOM   1757  CB  ASP   223      -3.867   1.480  31.354  1.00 24.12           C
ATOM   1758  CG  ASP   223      -4.913   0.940  32.289  1.00 25.07           C
ATOM   1759  OD1 ASP   223      -5.890   0.337  31.786  1.00 26.45           O
ATOM   1760  OD2 ASP   223      -4.766   1.112  33.514  1.00 26.55           O
ATOM   1761  C   ASP   223      -3.218   1.970  28.989  1.00 23.63           C
ATOM   1762  O   ASP   223      -2.873   3.151  29.085  1.00 24.03           O
ATOM   1763  N   VAL   224      -2.654   1.130  28.133  1.00 23.23           N
ATOM   1764  CA  VAL   224      -1.780   1.621  27.078  1.00 22.54           C
ATOM   1765  CB  VAL   224      -0.801   0.530  26.574  1.00 22.68           C
ATOM   1766  CG1 VAL   224      -0.116   0.972  25.282  1.00 22.70           C
ATOM   1767  CG2 VAL   224       0.231   0.192  27.650  1.00 21.90           C
ATOM   1768  C   VAL   224      -2.725   2.025  25.959  1.00 22.12           C
ATOM   1769  O   VAL   224      -2.613   3.108  25.397  1.00 21.74           O
ATOM   1770  N   GLU   225      -3.683   1.156  25.657  1.00 21.44           N
ATOM   1771  CA  GLU   225      -4.665   1.496  24.659  1.00 21.09           C
ATOM   1772  CB  GLU   225      -5.676   0.372  24.484  1.00 21.13           C
ATOM   1773  CG  GLU   225      -6.498   0.482  23.211  1.00 22.03           C
ATOM   1777  C   GLU   225      -5.356   2.814  25.024  1.00 20.98           C
ATOM   1778  O   GLU   225      -5.438   3.701  24.184  1.00 20.36           O
ATOM   1779  N   GLN   226      -5.844   2.940  26.269  1.00 20.87           N
ATOM   1780  CA  GLN   226      -6.664   4.097  26.658  1.00 20.84           C
ATOM   1781  CB  GLN   226      -7.444   3.858  27.961  1.00 21.10           C
ATOM   1782  CG  GLN   226      -8.284   2.562  28.033  1.00 22.57           C
ATOM   1783  CD  GLN   226      -9.060   2.263  26.755  1.00 24.68           C
ATOM   1784  OE1 GLN   226      -9.809   3.104  26.254  1.00 25.31           O
ATOM   1785  NE2 GLN   226      -8.887   1.052  26.229  1.00 24.97           N
ATOM   1786  C   GLN   226      -5.814   5.344  26.817  1.00 20.54           C
ATOM   1787  O   GLN   226      -6.284   6.451  26.583  1.00 20.01           O
ATOM   1788  N   TRP   227      -4.564   5.158  27.233  1.00 20.27           N
ATOM   1789  CA  TRP   227      -3.615   6.260  27.325  1.00 20.01           C
ATOM   1790  CB  TRP   227      -2.295   5.772  27.915  1.00 19.94           C
ATOM   1791  CG  TRP   227      -1.322   6.886  28.125  1.00 19.70           C
ATOM   1792  CD1 TRP   227      -1.138   7.609  29.273  1.00 18.72           C
ATOM   1793  NE1 TRP   227      -0.162   8.558  29.074  1.00 20.06           N
ATOM   1794  CE2 TRP   227       0.300   8.463  27.785  1.00 19.66           C
ATOM   1795  CD2 TRP   227      -0.410   7.423  27.157  1.00 18.96           C
ATOM   1796  CE3 TRP   227      -0.130   7.127  25.819  1.00 18.76           C
ATOM   1797  CZ3 TRP   227       0.832   7.861  25.160  1.00 19.10           C
ATOM   1798  CH2 TRP   227       1.530   8.890  25.812  1.00 20.17           C
ATOM   1799  CZ2 TRP   227       1.278   9.204  27.121  1.00 20.71           C
ATOM   1800  C   TRP   227      -3.356   6.873  25.954  1.00 19.96           C
ATOM   1801  O   TRP   227      -3.308   8.094  25.807  1.00 20.42           O
ATOM   1802  N   CYS   228      -3.176   6.013  24.954  1.00 19.31           N
ATOM   1803  CA  CYS   228      -2.920   6.445  23.593  1.00 18.95           C
ATOM   1804  CB  CYS   228      -2.504   5.252  22.741  1.00 19.03           C
ATOM   1805  SG  CYS   228      -0.861   4.603  23.147  1.00 19.79           S
ATOM   1806  C   CYS   228      -4.119   7.132  22.939  1.00 18.92           C
ATOM   1807  O   CYS   228      -3.968   8.178  22.327  1.00 18.65           O
ATOM   1808  N   LYS   229      -5.302   6.536  23.055  1.00 18.56           N
ATOM   1809  CA  LYS   229      -6.505   7.127  22.486  1.00 18.76           C
ATOM   1810  CB  LYS   229      -7.734   6.230  22.716  1.00 19.36           C
ATOM   1811  CG  LYS   229      -7.663   4.852  22.059  1.00 21.21           C
ATOM   1812  CD  LYS   229      -7.392   4.929  20.565  1.00 23.63           C
ATOM   1813  CE  LYS   229      -7.177   3.540  19.966  1.00 25.76           C
ATOM   1814  NZ  LYS   229      -6.805   3.585  18.506  1.00 27.82           N
ATOM   1815  C   LYS   229      -6.749   8.497  23.101  1.00 18.28           C
ATOM   1816  O   LYS   229      -7.415   9.350  22.511  1.00 18.13           O
ATOM   1817  N   LEU   230      -6.204   8.686  24.297  1.00 17.51           N
ATOM   1818  CA  LEU   230      -6.429   9.882  25.085  1.00 16.44           C
ATOM   1819  CB  LEU   230      -6.469   9.507  26.565  1.00 16.68           C
ATOM   1820  CG  LEU   230      -6.671  10.597  27.622  1.00 17.29           C
ATOM   1821  CD1 LEU   230      -7.998  11.361  27.431  1.00 15.25           C
ATOM   1822  CD2 LEU   230      -6.575  10.007  29.036  1.00 16.30           C
ATOM   1823  C   LEU   230      -5.338  10.918  24.870  1.00 16.41           C
ATOM   1824  O   LEU   230      -5.627  12.113  24.847  1.00 15.62           O
ATOM   1825  N   ASN   231      -4.086  10.455  24.726  1.00 15.18           N
ATOM   1826  CA  ASN   231      -2.936  11.358  24.616  1.00 15.10           C
ATOM   1827  CB  ASN   231      -1.780  10.908  25.524  1.00 15.20           C
ATOM   1828  CG  ASN   231      -2.118  11.024  26.989  1.00 16.40           C
ATOM   1829  OD1 ASN   231      -1.876  12.050  27.600  1.00 19.89           O
ATOM   1830  ND2 ASN   231      -2.699   9.980  27.556  1.00 16.14           N
ATOM   1831  C   ASN   231      -2.388  11.572  23.211  1.00 14.43           C
ATOM   1832  O   ASN   231      -1.910  12.649  22.886  1.00 14.38           O
ATOM   1833  N   LEU   232      -2.427  10.548  22.376  1.00 13.75           N
ATOM   1834  CA  LEU   232      -1.818  10.675  21.068  1.00 13.37           C
ATOM   1835  CB  LEU   232      -1.364   9.307  20.553  1.00 13.33           C
ATOM   1836  CG  LEU   232      -0.354   8.650  21.496  1.00 14.58           C
ATOM   1837  CD1 LEU   232       0.263   7.332  20.959  1.00 13.39           C
ATOM   1838  CD2 LEU   232       0.744   9.642  21.859  1.00 13.48           C
ATOM   1839  C   LEU   232      -2.818  11.348  20.129  1.00 13.09           C
ATOM   1840  O   LEU   232      -4.015  11.348  20.384  1.00 12.53           O
ATOM   1841  N   ASP   233      -2.319  11.945  19.058  1.00 12.29           N
ATOM   1842  CA  ASP   233      -3.169  12.669  18.146  1.00 12.14           C
ATOM   1843  CB  ASP   233      -2.389  13.850  17.580  1.00 12.64           C
ATOM   1844  CG  ASP   233      -3.134  14.554  16.480  1.00 16.19           C
ATOM   1845  OD1 ASP   233      -4.346  14.788  16.653  1.00 18.48           O
ATOM   1846  OD2 ASP   233      -2.510  14.879  15.441  1.00 21.07           O
ATOM   1847  C   ASP   233      -3.597  11.748  17.008  1.00 10.84           C
ATOM   1848  O   ASP   233      -2.756  11.236  16.292  1.00  9.89           O
ATOM   1849  N   ASN   234      -4.898  11.546  16.836  1.00 10.24           N
ATOM   1850  CA  ASN   234      -5.405  10.779  15.685  1.00  9.30           C
ATOM   1851  CB  ASN   234      -5.152  11.575  14.396  1.00  9.66           C
ATOM   1852  CG  ASN   234      -6.078  11.181  13.249  1.00 11.52           C
ATOM   1853  OD1 ASN   234      -7.079  10.490  13.444  1.00 13.90           O
ATOM   1854  ND2 ASN   234      -5.742  11.635  12.035  1.00 10.14           N
ATOM   1855  C   ASN   234      -4.697   9.433  15.603  1.00  8.61           C
ATOM   1856  O   ASN   234      -4.295   9.007  14.540  1.00  8.68           O
ATOM   1857  N   VAL   235      -4.566   8.742  16.721  1.00  7.61           N
ATOM   1858  CA  VAL   235      -3.765   7.516  16.741  1.00  7.11           C
ATOM   1859  CB  VAL   235      -3.617   6.954  18.179  1.00  6.87           C
ATOM   1860  CG1 VAL   235      -4.926   6.281  18.651  1.00  7.79           C
ATOM   1861  CG2 VAL   235      -2.433   6.008  18.249  1.00  8.36           C
ATOM   1862  C   VAL   235      -4.228   6.397  15.780  1.00  6.32           C
ATOM   1863  O   VAL   235      -5.420   6.234  15.469  1.00  6.31           O
ATOM   1864  N   ILE   236      -3.259   5.649  15.279  1.00  4.55           N
ATOM   1865  CA  ILE   236      -3.546   4.446  14.536  1.00  3.33           C
ATOM   1866  CB  ILE   236      -2.837   4.470  13.165  1.00  2.95           C
ATOM   1867  CG1 ILE   236      -3.664   5.300  12.160  1.00  2.46           C
ATOM   1868  CD1 ILE   236      -2.974   5.455  10.825  1.00  2.00           C
ATOM   1869  CG2 ILE   236      -2.662   3.047  12.585  1.00  2.09           C
ATOM   1870  C   ILE   236      -3.080   3.279  15.408  1.00  2.76           C
ATOM   1871  O   ILE   236      -1.957   3.284  15.893  1.00  2.00           O
ATOM   1872  N   SER   237      -3.951   2.309  15.658  1.00  2.17           N
ATOM   1873  CA  SER   237      -3.561   1.124  16.410  0.50  2.36           C
ATOM   1875  CB  SER   237      -4.639   0.748  17.432  0.50  2.26           C
ATOM   1877  OG  SER   237      -4.774   1.743  18.432  0.50  3.72           O
ATOM   1879  C   SER   237      -3.319  -0.046  15.458  1.00  2.07           C
ATOM   1880  O   SER   237      -4.172  -0.361  14.637  1.00  2.41           O
ATOM   1881  N   VAL   238      -2.169  -0.693  15.576  1.00  2.00           N
ATOM   1882  CA  VAL   238      -1.904  -1.903  14.802  1.00  2.00           C
ATOM   1883  CB  VAL   238      -0.658  -1.761  13.899  1.00  2.00           C
ATOM   1884  CG1 VAL   238      -0.567  -2.949  12.933  1.00  2.00           C
ATOM   1885  CG2 VAL   238      -0.641  -0.414  13.145  1.00  2.00           C
ATOM   1886  C   VAL   238      -1.579  -2.991  15.804  1.00  2.00           C
ATOM   1887  O   VAL   238      -0.754  -2.789  16.712  1.00  2.00           O
ATOM   1888  N   SER   239      -2.214  -4.145  15.649  1.00  2.00           N
ATOM   1889  CA  SER   239      -1.970  -5.273  16.524  1.00  2.34           C
ATOM   1890  CB  SER   239      -3.114  -5.366  17.533  1.00  2.00           C
ATOM   1891  OG  SER   239      -2.943  -6.508  18.344  1.00  6.75           O
ATOM   1892  C   SER   239      -1.921  -6.548  15.658  1.00  2.00           C
ATOM   1893  O   SER   239      -2.731  -6.687  14.745  1.00  2.00           O
ATOM   1894  N   ILE   240      -0.966  -7.442  15.925  1.00  2.00           N
ATOM   1895  CA  ILE   240      -0.873  -8.715  15.206  1.00  2.00           C
ATOM   1896  CB  ILE   240       0.595  -9.118  14.933  1.00  2.16           C
ATOM   1897  CG1 ILE   240       1.417  -7.921  14.411  1.00  2.00           C
ATOM   1898  CD1 ILE   240       0.949  -7.394  13.061  1.00  2.00           C
ATOM   1899  CG2 ILE   240       0.656 -10.318  13.958  1.00  2.00           C
ATOM   1900  C   ILE   240      -1.531  -9.835  16.014  1.00  2.82           C
ATOM   1901  O   ILE   240      -1.113 -10.118  17.139  1.00  2.41           O
ATOM   1902  N   GLY   241      -2.549 -10.469  15.440  1.00  4.28           N
ATOM   1903  CA  GLY   241      -3.271 -11.528  16.131  1.00  5.85           C
ATOM   1904  C   GLY   241      -2.385 -12.757  16.158  1.00  7.38           C
ATOM   1905  O   GLY   241      -1.456 -12.859  15.349  1.00  7.69           O
ATOM   1906  N   ALA   242      -2.657 -13.683  17.082  1.00  8.07           N
ATOM   1907  CA  ALA   242      -1.779 -14.844  17.290  1.00  8.80           C
ATOM   1908  CB  ALA   242      -2.010 -15.465  18.671  1.00  8.95           C
ATOM   1909  C   ALA   242      -2.025 -15.864  16.210  1.00  8.74           C
ATOM   1910  O   ALA   242      -3.069 -15.819  15.578  1.00  9.49           O
END
