
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  201 ( 1588),  selected  201 , name 1qde_A
# Molecule2: number of CA atoms  240 ( 1868),  selected  240 , name T0477.pdb
# PARAMETERS: 1qde_A.T0477.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      M       2           -
LGA    -       -      K       3           -
LGA    -       -      I       4           -
LGA    -       -      N       5           -
LGA    -       -      F       6           -
LGA    -       -      L       7           -
LGA    -       -      R       8           -
LGA    -       -      N       9           -
LGA    -       -      K      10           -
LGA    -       -      H      11           -
LGA    -       -      K      12           -
LGA    I    12_A      I      13          2.664
LGA    Q    13_A      H      14          1.058
LGA    T    14_A      V      15          0.829
LGA    N    15_A      Q      16          3.496
LGA    Y    16_A      G      17           #
LGA    D    17_A      T      18           -
LGA    -       -      D      19           -
LGA    -       -      L      20           -
LGA    -       -      P      21           -
LGA    K    18_A      D      22          1.143
LGA    V    19_A      P      23          2.368
LGA    V    20_A      I      24          1.428
LGA    Y    21_A      A      25          1.680
LGA    K    22_A      T      26          1.232
LGA    F    23_A      F      27          0.521
LGA    D    24_A      Q      28          0.982
LGA    D    25_A      Q      29          0.703
LGA    M    26_A      L      30          1.384
LGA    E    27_A      D      31          2.367
LGA    -       -      Q      32           -
LGA    -       -      E      33           -
LGA    -       -      Y      34           -
LGA    -       -      K      35           -
LGA    L    28_A      I      36          1.834
LGA    D    29_A      N      37          1.502
LGA    E    30_A      S      38          0.874
LGA    N    31_A      R      39          1.702
LGA    L    32_A      L      40          1.147
LGA    L    33_A      L      41          0.546
LGA    R    34_A      Q      42          1.668
LGA    G    35_A      N      43          1.638
LGA    V    36_A      I      44          0.998
LGA    F    37_A      L      45          1.424
LGA    G    38_A      D      46          2.363
LGA    Y    39_A      A      47          2.208
LGA    G    40_A      G      48          2.379
LGA    F    41_A      F      49          1.269
LGA    E    42_A      Q      50          1.268
LGA    E    43_A      M      51          0.980
LGA    P    44_A      P      52          0.645
LGA    S    45_A      T      53          0.757
LGA    A    46_A      P      54          0.973
LGA    I    47_A      I      55          1.030
LGA    Q    48_A      Q      56          0.848
LGA    Q    49_A      M      57          1.136
LGA    R    50_A      Q      58          1.174
LGA    A    51_A      A      59          1.072
LGA    I    52_A      I      60          0.653
LGA    M    53_A      P      61          1.094
LGA    P    54_A      V      62          1.312
LGA    I    55_A      M      63          0.643
LGA    I    56_A      L      64          1.256
LGA    E    57_A      H      65          1.529
LGA    G    58_A      G      66          0.771
LGA    H    59_A      R      67          0.742
LGA    D    60_A      E      68          0.595
LGA    V    61_A      L      69          0.997
LGA    L    62_A      L      70          0.989
LGA    A    63_A      A      71          0.722
LGA    Q    64_A      S      72          1.109
LGA    A    65_A      A      73          1.176
LGA    Q    66_A      P      74          1.036
LGA    S    67_A      T      75          1.179
LGA    G    68_A      G      76          0.556
LGA    T    69_A      S      77          0.411
LGA    G    70_A      G      78          0.580
LGA    K    71_A      K      79          0.195
LGA    T    72_A      T      80          0.362
LGA    G    73_A      L      81          0.812
LGA    T    74_A      A      82          0.531
LGA    F    75_A      F      83          0.344
LGA    S    76_A      S      84          0.771
LGA    I    77_A      I      85          0.874
LGA    A    78_A      P      86          0.966
LGA    A    79_A      I      87          0.726
LGA    L    80_A      L      88          0.738
LGA    Q    81_A      M      89          0.639
LGA    R    82_A      Q      90          1.113
LGA    I    83_A      L      91          1.229
LGA    D    84_A      K      92          4.112
LGA    T    85_A      Q      93          2.331
LGA    S    86_A      P      94          4.672
LGA    V    87_A      A      95          2.313
LGA    K    88_A      N      96          1.945
LGA    -       -      K      97           -
LGA    A    89_A      G      98          1.212
LGA    P    90_A      F      99          0.402
LGA    Q    91_A      R     100          0.490
LGA    A    92_A      A     101          0.484
LGA    L    93_A      L     102          0.351
LGA    M    94_A      I     103          0.128
LGA    L    95_A      I     104          0.190
LGA    A    96_A      S     105          0.251
LGA    P    97_A      P     106          0.717
LGA    T    98_A      T     107          0.990
LGA    R    99_A      R     108          0.856
LGA    E   100_A      E     109          0.651
LGA    L   101_A      L     110          0.615
LGA    A   102_A      A     111          0.277
LGA    L   103_A      S     112          0.242
LGA    Q   104_A      Q     113          0.243
LGA    I   105_A      I     114          0.230
LGA    Q   106_A      H     115          0.203
LGA    K   107_A      R     116          0.315
LGA    V   108_A      E     117          0.332
LGA    V   109_A      L     118          0.450
LGA    M   110_A      I     119          0.558
LGA    A   111_A      K     120          0.502
LGA    L   112_A      I     121          0.765
LGA    A   113_A      S     122          0.633
LGA    F   114_A      E     123          0.261
LGA    H   115_A      G     124          2.035
LGA    M   116_A      T     125          0.308
LGA    D   117_A      G     126          0.689
LGA    I   118_A      F     127          0.436
LGA    K   119_A      R     128          0.389
LGA    V   120_A      I     129          0.366
LGA    H   121_A      H     130          0.510
LGA    A   122_A      M     131          0.945
LGA    C   123_A      I     132          3.092
LGA    I   124_A      H     133          4.762
LGA    -       -      K     134           -
LGA    -       -      A     135           -
LGA    -       -      A     136           -
LGA    -       -      V     137           -
LGA    -       -      A     138           -
LGA    -       -      A     139           -
LGA    -       -      K     140           -
LGA    G   135_A      K     141          4.217
LGA    L   136_A      F     142          3.017
LGA    -       -      G     143           -
LGA    -       -      P     144           -
LGA    -       -      K     145           -
LGA    -       -      S     146           -
LGA    R   137_A      S     147          6.063
LGA    -       -      K     148           -
LGA    D   138_A      K     149          2.993
LGA    A   139_A      F     150          1.860
LGA    Q   140_A      D     151          0.471
LGA    I   141_A      I     152          0.303
LGA    V   142_A      L     153          0.238
LGA    V   143_A      V     154          0.404
LGA    G   144_A      T     155          0.484
LGA    T   145_A      T     156          0.325
LGA    P   146_A      P     157          0.254
LGA    G   147_A      N     158          0.540
LGA    R   148_A      R     159          0.109
LGA    V   149_A      L     160          0.823
LGA    F   150_A      I     161          1.353
LGA    D   151_A      Y     162          1.233
LGA    N   152_A      L     163          1.257
LGA    I   153_A      L     164          2.184
LGA    Q   154_A      K     165          2.397
LGA    R   155_A      Q     166          2.537
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    R   156_A      P     169          2.130
LGA    R   157_A      G     170          2.167
LGA    F   158_A      I     171          2.223
LGA    R   159_A      D     172          1.423
LGA    T   160_A      L     173          0.890
LGA    D   161_A      A     174          1.074
LGA    K   162_A      S     175          0.814
LGA    I   163_A      V     176          0.539
LGA    K   164_A      E     177          0.350
LGA    M   165_A      W     178          0.331
LGA    F   166_A      L     179          0.428
LGA    I   167_A      V     180          0.223
LGA    L   168_A      V     181          0.398
LGA    D   169_A      D     182          0.406
LGA    E   170_A      E     183          0.680
LGA    A   171_A      S     184          0.546
LGA    D   172_A      D     185          1.040
LGA    E   173_A      K     186          0.738
LGA    M   174_A      L     187          0.964
LGA    L   175_A      F     188          1.628
LGA    S   176_A      E     189          1.442
LGA    S   177_A      D     190          1.638
LGA    G   178_A      G     191          1.213
LGA    -       -      G     194           -
LGA    F   179_A      F     195          2.403
LGA    K   180_A      R     196          2.502
LGA    E   181_A      D     197          2.047
LGA    Q   182_A      Q     198          1.370
LGA    I   183_A      L     199          1.470
LGA    Y   184_A      A     200          1.645
LGA    Q   185_A      S     201          1.104
LGA    I   186_A      I     202          0.507
LGA    F   187_A      F     203          1.154
LGA    T   188_A      L     204          1.196
LGA    L   189_A      A     205          1.167
LGA    L   190_A      C     206          0.922
LGA    P   191_A      T     207          1.658
LGA    -       -      S     208           -
LGA    P   192_A      H     209          5.642
LGA    T   193_A      K     210          4.086
LGA    T   194_A      V     211          1.160
LGA    Q   195_A      R     212          0.523
LGA    V   196_A      R     213          0.517
LGA    V   197_A      A     214          0.549
LGA    L   198_A      M     215          0.466
LGA    L   199_A      F     216          0.651
LGA    S   200_A      S     217          1.041
LGA    A   201_A      A     218          1.782
LGA    T   202_A      T     219          2.296
LGA    -       -      F     220           -
LGA    M   203_A      A     221          1.090
LGA    P   204_A      Y     222          2.914
LGA    N   205_A      D     223          1.821
LGA    D   206_A      -       -           -
LGA    V   207_A      V     224          0.914
LGA    L   208_A      E     225          2.315
LGA    E   209_A      Q     226          3.552
LGA    V   210_A      W     227          2.837
LGA    T   211_A      C     228          0.686
LGA    T   212_A      K     229          2.734
LGA    K   213_A      L     230          3.671
LGA    F   214_A      N     231          2.935
LGA    M   215_A      L     232          1.134
LGA    R   216_A      D     233          0.935
LGA    N   217_A      N     234          0.850
LGA    P   218_A      V     235          1.407
LGA    V   219_A      I     236          1.652
LGA    R   220_A      S     237          1.406
LGA    I   221_A      V     238          0.662
LGA    L   222_A      S     239          1.535
LGA    -       -      I     240           -
LGA    -       -      G     241           -
LGA    -       -      A     242           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  201  240    5.0    198    1.63    26.26     76.404    11.476

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.982938 * X  +   0.179795 * Y  +   0.038811 * Z  +  24.633545
  Y_new =   0.025568 * X  +  -0.075395 * Y  +   0.996826 * Z  + -51.505859
  Z_new =   0.182151 * X  +   0.980811 * Y  +   0.069512 * Z  + -21.677629 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.500043   -1.641550  [ DEG:    85.9461    -94.0539 ]
  Theta =  -0.183173   -2.958419  [ DEG:   -10.4951   -169.5049 ]
  Phi   =   3.115587   -0.026006  [ DEG:   178.5100     -1.4900 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1qde_A                                        
REMARK     2: T0477.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1qde_A.T0477.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  201  240   5.0  198   1.63   26.26  76.404
REMARK  ---------------------------------------------------------- 
MOLECULE 1qde_A
HEADER    GENE REGULATION                         20-MAY-99   1QDE              
TITLE     CRYSTAL STRUCTURE OF THE ATPASE DOMAIN OF TRANSLATION                 
TITLE    2 INITIATION FACTOR 4A FROM SACCHAROMYCES CEREVISIAE-THE               
TITLE    3 PROTOTYPE OF THE DEAD BOX PROTEIN FAMILY                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSLATION INITIATION FACTOR 4A;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN, RESIDUES 9-232;                         
COMPND   5 SYNONYM: EIF4A;                                                      
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PQE30                                     
KEYWDS    TRANSLATION INITIATION, SACCHAROMYCES CEREVISIAE, DEAD BOX            
KEYWDS   2 PROTEIN FAMILY                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.BENZ,H.TRACHSEL,U.BAUMANN                                           
REVDAT   2   01-APR-03 1QDE    1       JRNL                                     
REVDAT   1   23-MAY-00 1QDE    0                                                
JRNL        AUTH   J.BENZ,H.TRACHSEL,U.BAUMANN                                  
JRNL        TITL   CRYSTAL STRUCTURE OF THE ATPASE DOMAIN OF                    
JRNL        TITL 2 TRANSLATION INITIATION FACTOR 4A FROM                        
JRNL        TITL 3 SACCHAROMYCES CEREVISIAE--THE PROTOTYPE OF THE               
JRNL        TITL 4 DEAD BOX PROTEIN FAMILY.                                     
JRNL        REF    STRUCTURE FOLD.DES.           V.   7   671 1999              
JRNL        REFN   ASTM FODEFH  UK ISSN 1359-0278                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1QDE A    8   231  UNP    P10081   IF4A_YEAST       9    232             
SEQRES   1 A  224  GLU GLU SER GLN ILE GLN THR ASN TYR ASP LYS VAL VAL          
SEQRES   2 A  224  TYR LYS PHE ASP ASP MET GLU LEU ASP GLU ASN LEU LEU          
SEQRES   3 A  224  ARG GLY VAL PHE GLY TYR GLY PHE GLU GLU PRO SER ALA          
SEQRES   4 A  224  ILE GLN GLN ARG ALA ILE MET PRO ILE ILE GLU GLY HIS          
SEQRES   5 A  224  ASP VAL LEU ALA GLN ALA GLN SER GLY THR GLY LYS THR          
SEQRES   6 A  224  GLY THR PHE SER ILE ALA ALA LEU GLN ARG ILE ASP THR          
SEQRES   7 A  224  SER VAL LYS ALA PRO GLN ALA LEU MET LEU ALA PRO THR          
SEQRES   8 A  224  ARG GLU LEU ALA LEU GLN ILE GLN LYS VAL VAL MET ALA          
SEQRES   9 A  224  LEU ALA PHE HIS MET ASP ILE LYS VAL HIS ALA CYS ILE          
SEQRES  10 A  224  GLY GLY THR SER PHE VAL GLU ASP ALA GLU GLY LEU ARG          
SEQRES  11 A  224  ASP ALA GLN ILE VAL VAL GLY THR PRO GLY ARG VAL PHE          
SEQRES  12 A  224  ASP ASN ILE GLN ARG ARG ARG PHE ARG THR ASP LYS ILE          
SEQRES  13 A  224  LYS MET PHE ILE LEU ASP GLU ALA ASP GLU MET LEU SER          
SEQRES  14 A  224  SER GLY PHE LYS GLU GLN ILE TYR GLN ILE PHE THR LEU          
SEQRES  15 A  224  LEU PRO PRO THR THR GLN VAL VAL LEU LEU SER ALA THR          
SEQRES  16 A  224  MET PRO ASN ASP VAL LEU GLU VAL THR THR LYS PHE MET          
SEQRES  17 A  224  ARG ASN PRO VAL ARG ILE LEU VAL LYS LYS ASP GLU LEU          
SEQRES  18 A  224  THR LEU GLU                                                  
HET    SO4    273       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   2  SO4    O4 S 2-                                                      
FORMUL   3  HOH   *50(H2 O)                                                     
CRYST1   38.880   59.280   92.050  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   ILE A  12      -4.822 -10.045  12.898  1.00 49.74           N  
ATOM      2  CA  ILE A  12      -4.309  -8.662  12.617  1.00 50.28           C  
ATOM      3  C   ILE A  12      -5.437  -7.674  12.352  1.00 48.90           C  
ATOM      4  O   ILE A  12      -6.167  -7.799  11.372  1.00 49.61           O  
ATOM      5  CB  ILE A  12      -3.380  -8.624  11.389  1.00 51.59           C  
ATOM      6  CG1 ILE A  12      -2.290  -9.691  11.517  1.00 52.63           C  
ATOM      7  CG2 ILE A  12      -2.765  -7.230  11.252  1.00 51.05           C  
ATOM      8  CD1 ILE A  12      -2.796 -11.106  11.304  1.00 53.63           C  
ATOM      9  N   GLN A  13      -5.546  -6.669  13.211  1.00 46.89           N  
ATOM     10  CA  GLN A  13      -6.595  -5.664  13.110  1.00 44.22           C  
ATOM     11  C   GLN A  13      -5.973  -4.276  12.926  1.00 41.54           C  
ATOM     12  O   GLN A  13      -5.215  -3.817  13.773  1.00 39.49           O  
ATOM     13  CB  GLN A  13      -7.413  -5.725  14.395  1.00 47.18           C  
ATOM     14  CG  GLN A  13      -8.756  -5.053  14.367  1.00 51.61           C  
ATOM     15  CD  GLN A  13      -9.658  -5.579  15.474  1.00 55.09           C  
ATOM     16  OE1 GLN A  13     -10.737  -5.035  15.728  1.00 57.28           O  
ATOM     17  NE2 GLN A  13      -9.219  -6.655  16.138  1.00 55.70           N  
ATOM     18  N   THR A  14      -6.290  -3.601  11.830  1.00 38.03           N  
ATOM     19  CA  THR A  14      -5.695  -2.297  11.611  1.00 36.58           C  
ATOM     20  C   THR A  14      -6.633  -1.296  10.934  1.00 35.09           C  
ATOM     21  O   THR A  14      -7.565  -1.691  10.247  1.00 36.26           O  
ATOM     22  CB  THR A  14      -4.374  -2.467  10.791  1.00 36.88           C  
ATOM     23  OG1 THR A  14      -3.772  -1.189  10.540  1.00 38.13           O  
ATOM     24  CG2 THR A  14      -4.649  -3.173   9.482  1.00 37.12           C  
ATOM     25  N   ASN A  15      -6.408  -0.003  11.156  1.00 33.18           N  
ATOM     26  CA  ASN A  15      -7.219   1.034  10.518  1.00 32.26           C  
ATOM     27  C   ASN A  15      -6.405   1.733   9.421  1.00 32.15           C  
ATOM     28  O   ASN A  15      -6.722   2.843   9.010  1.00 32.71           O  
ATOM     29  CB  ASN A  15      -7.723   2.056  11.549  1.00 32.38           C  
ATOM     30  CG  ASN A  15      -6.596   2.857  12.187  1.00 34.74           C  
ATOM     31  OD1 ASN A  15      -5.427   2.467  12.122  1.00 33.34           O  
ATOM     32  ND2 ASN A  15      -6.947   3.979  12.824  1.00 32.98           N  
ATOM     33  N   TYR A  16      -5.351   1.059   8.961  1.00 32.53           N  
ATOM     34  CA  TYR A  16      -4.458   1.528   7.890  1.00 33.03           C  
ATOM     35  C   TYR A  16      -4.430   0.297   6.981  1.00 34.00           C  
ATOM     36  O   TYR A  16      -4.217  -0.817   7.463  1.00 34.64           O  
ATOM     37  CB  TYR A  16      -3.061   1.814   8.454  1.00 32.56           C  
ATOM     38  CG  TYR A  16      -2.066   2.381   7.461  1.00 31.58           C  
ATOM     39  CD1 TYR A  16      -2.148   3.708   7.037  1.00 31.25           C  
ATOM     40  CD2 TYR A  16      -1.022   1.598   6.966  1.00 31.92           C  
ATOM     41  CE1 TYR A  16      -1.211   4.245   6.147  1.00 30.34           C  
ATOM     42  CE2 TYR A  16      -0.078   2.128   6.073  1.00 31.29           C  
ATOM     43  CZ  TYR A  16      -0.183   3.451   5.674  1.00 30.69           C  
ATOM     44  OH  TYR A  16       0.751   3.985   4.816  1.00 31.89           O  
ATOM     45  N   ASP A  17      -4.624   0.469   5.681  1.00 35.02           N  
ATOM     46  CA  ASP A  17      -4.696  -0.712   4.819  1.00 37.41           C  
ATOM     47  C   ASP A  17      -3.554  -1.049   3.862  1.00 37.05           C  
ATOM     48  O   ASP A  17      -3.604  -2.064   3.161  1.00 37.82           O  
ATOM     49  CB  ASP A  17      -6.023  -0.676   4.054  1.00 39.39           C  
ATOM     50  CG  ASP A  17      -7.236  -0.854   4.980  1.00 42.00           C  
ATOM     51  OD1 ASP A  17      -8.355  -0.465   4.571  1.00 42.50           O  
ATOM     52  OD2 ASP A  17      -7.069  -1.390   6.107  1.00 42.26           O  
ATOM     53  N   LYS A  18      -2.527  -0.213   3.842  1.00 36.19           N  
ATOM     54  CA  LYS A  18      -1.370  -0.432   2.986  1.00 34.81           C  
ATOM     55  C   LYS A  18      -0.568  -1.615   3.538  1.00 32.89           C  
ATOM     56  O   LYS A  18      -0.237  -1.650   4.717  1.00 31.64           O  
ATOM     57  CB  LYS A  18      -0.525   0.835   3.003  1.00 36.73           C  
ATOM     58  CG  LYS A  18       0.664   0.907   2.072  1.00 40.09           C  
ATOM     59  CD  LYS A  18       1.348   2.254   2.340  1.00 44.37           C  
ATOM     60  CE  LYS A  18       2.321   2.671   1.250  1.00 48.22           C  
ATOM     61  NZ  LYS A  18       2.823   4.074   1.457  1.00 49.81           N  
ATOM     62  N   VAL A  19      -0.292  -2.597   2.688  1.00 31.62           N  
ATOM     63  CA  VAL A  19       0.498  -3.756   3.079  1.00 30.88           C  
ATOM     64  C   VAL A  19       1.624  -3.876   2.049  1.00 31.93           C  
ATOM     65  O   VAL A  19       1.365  -4.018   0.854  1.00 32.09           O  
ATOM     66  CB  VAL A  19      -0.326  -5.068   3.063  1.00 30.18           C  
ATOM     67  CG1 VAL A  19       0.569  -6.243   3.436  1.00 29.15           C  
ATOM     68  CG2 VAL A  19      -1.485  -4.976   4.037  1.00 29.42           C  
ATOM     69  N   VAL A  20       2.869  -3.798   2.510  1.00 32.79           N  
ATOM     70  CA  VAL A  20       4.023  -3.887   1.619  1.00 33.73           C  
ATOM     71  C   VAL A  20       4.746  -5.197   1.891  1.00 34.53           C  
ATOM     72  O   VAL A  20       5.091  -5.487   3.037  1.00 35.62           O  
ATOM     73  CB  VAL A  20       4.973  -2.708   1.849  1.00 33.59           C  
ATOM     74  CG1 VAL A  20       6.184  -2.840   0.962  1.00 35.53           C  
ATOM     75  CG2 VAL A  20       4.260  -1.412   1.531  1.00 34.32           C  
ATOM     76  N   TYR A  21       4.980  -5.989   0.844  1.00 35.06           N  
ATOM     77  CA  TYR A  21       5.621  -7.292   1.017  1.00 35.51           C  
ATOM     78  C   TYR A  21       7.128  -7.372   0.868  1.00 35.09           C  
ATOM     79  O   TYR A  21       7.733  -8.328   1.344  1.00 34.76           O  
ATOM     80  CB  TYR A  21       4.985  -8.322   0.087  1.00 36.01           C  
ATOM     81  CG  TYR A  21       3.557  -8.633   0.442  1.00 37.50           C  
ATOM     82  CD1 TYR A  21       2.501  -7.926  -0.136  1.00 38.33           C  
ATOM     83  CD2 TYR A  21       3.260  -9.601   1.396  1.00 38.26           C  
ATOM     84  CE1 TYR A  21       1.184  -8.176   0.234  1.00 39.16           C  
ATOM     85  CE2 TYR A  21       1.952  -9.857   1.777  1.00 39.82           C  
ATOM     86  CZ  TYR A  21       0.921  -9.141   1.195  1.00 40.10           C  
ATOM     87  OH  TYR A  21      -0.369  -9.379   1.602  1.00 42.93           O  
ATOM     88  N   LYS A  22       7.733  -6.388   0.209  1.00 34.84           N  
ATOM     89  CA  LYS A  22       9.180  -6.387   0.023  1.00 34.98           C  
ATOM     90  C   LYS A  22       9.796  -5.073   0.484  1.00 34.00           C  
ATOM     91  O   LYS A  22       9.243  -4.009   0.227  1.00 33.18           O  
ATOM     92  CB  LYS A  22       9.532  -6.605  -1.453  1.00 36.75           C  
ATOM     93  CG  LYS A  22       8.945  -7.864  -2.074  1.00 39.77           C  
ATOM     94  CD  LYS A  22       9.640  -8.240  -3.390  1.00 42.72           C  
ATOM     95  CE  LYS A  22       9.454  -7.196  -4.486  1.00 44.44           C  
ATOM     96  NZ  LYS A  22      10.097  -7.639  -5.761  1.00 45.44           N  
ATOM     97  N   PHE A  23      10.940  -5.137   1.158  1.00 33.65           N  
ATOM     98  CA  PHE A  23      11.587  -3.908   1.596  1.00 34.51           C  
ATOM     99  C   PHE A  23      11.916  -3.051   0.379  1.00 36.00           C  
ATOM    100  O   PHE A  23      12.029  -1.830   0.490  1.00 36.08           O  
ATOM    101  CB  PHE A  23      12.869  -4.205   2.369  1.00 32.89           C  
ATOM    102  CG  PHE A  23      12.638  -4.851   3.701  1.00 30.90           C  
ATOM    103  CD1 PHE A  23      13.007  -6.172   3.918  1.00 29.10           C  
ATOM    104  CD2 PHE A  23      12.076  -4.125   4.753  1.00 31.56           C  
ATOM    105  CE1 PHE A  23      12.826  -6.768   5.164  1.00 29.78           C  
ATOM    106  CE2 PHE A  23      11.889  -4.713   6.012  1.00 30.87           C  
ATOM    107  CZ  PHE A  23      12.267  -6.039   6.219  1.00 30.01           C  
ATOM    108  N   ASP A  24      12.064  -3.697  -0.780  1.00 38.17           N  
ATOM    109  CA  ASP A  24      12.372  -3.000  -2.038  1.00 39.50           C  
ATOM    110  C   ASP A  24      11.233  -2.053  -2.376  1.00 39.56           C  
ATOM    111  O   ASP A  24      11.433  -1.027  -3.020  1.00 39.90           O  
ATOM    112  CB  ASP A  24      12.478  -3.975  -3.224  1.00 42.30           C  
ATOM    113  CG  ASP A  24      13.270  -5.214  -2.910  1.00 43.16           C  
ATOM    114  OD1 ASP A  24      14.502  -5.120  -2.788  1.00 46.01           O  
ATOM    115  OD2 ASP A  24      12.658  -6.294  -2.789  1.00 45.81           O  
ATOM    116  N   ASP A  25      10.029  -2.423  -1.955  1.00 39.50           N  
ATOM    117  CA  ASP A  25       8.843  -1.636  -2.257  1.00 39.25           C  
ATOM    118  C   ASP A  25       8.582  -0.457  -1.319  1.00 38.16           C  
ATOM    119  O   ASP A  25       7.752   0.404  -1.621  1.00 38.77           O  
ATOM    120  CB  ASP A  25       7.610  -2.550  -2.290  1.00 41.18           C  
ATOM    121  CG  ASP A  25       7.770  -3.724  -3.259  1.00 43.29           C  
ATOM    122  OD1 ASP A  25       8.239  -3.498  -4.396  1.00 44.21           O  
ATOM    123  OD2 ASP A  25       7.411  -4.868  -2.887  1.00 44.76           O  
ATOM    124  N   MET A  26       9.286  -0.397  -0.196  1.00 35.81           N  
ATOM    125  CA  MET A  26       9.074   0.696   0.745  1.00 34.22           C  
ATOM    126  C   MET A  26       9.768   2.001   0.354  1.00 34.26           C  
ATOM    127  O   MET A  26       9.665   2.995   1.074  1.00 33.80           O  
ATOM    128  CB  MET A  26       9.514   0.262   2.144  1.00 33.29           C  
ATOM    129  CG  MET A  26       8.668  -0.861   2.706  1.00 32.34           C  
ATOM    130  SD  MET A  26       9.351  -1.613   4.175  1.00 31.81           S  
ATOM    131  CE  MET A  26       8.277  -3.034   4.369  1.00 31.62           C  
ATOM    132  N   GLU A  27      10.456   2.004  -0.789  1.00 33.80           N  
ATOM    133  CA  GLU A  27      11.179   3.191  -1.271  1.00 34.69           C  
ATOM    134  C   GLU A  27      12.198   3.760  -0.274  1.00 32.81           C  
ATOM    135  O   GLU A  27      12.352   4.979  -0.146  1.00 31.23           O  
ATOM    136  CB  GLU A  27      10.199   4.296  -1.663  1.00 37.71           C  
ATOM    137  CG  GLU A  27       9.536   4.085  -3.001  1.00 43.36           C  
ATOM    138  CD  GLU A  27       8.617   5.236  -3.364  1.00 47.91           C  
ATOM    139  OE1 GLU A  27       9.101   6.394  -3.445  1.00 49.92           O  
ATOM    140  OE2 GLU A  27       7.406   4.979  -3.566  1.00 50.36           O  
ATOM    141  N   LEU A  28      12.899   2.865   0.411  1.00 31.36           N  
ATOM    142  CA  LEU A  28      13.895   3.250   1.398  1.00 30.62           C  
ATOM    143  C   LEU A  28      15.176   3.733   0.731  1.00 31.21           C  
ATOM    144  O   LEU A  28      15.454   3.403  -0.419  1.00 31.33           O  
ATOM    145  CB  LEU A  28      14.214   2.057   2.302  1.00 28.15           C  
ATOM    146  CG  LEU A  28      12.995   1.374   2.917  1.00 27.83           C  
ATOM    147  CD1 LEU A  28      13.441   0.188   3.738  1.00 27.70           C  
ATOM    148  CD2 LEU A  28      12.213   2.368   3.768  1.00 26.93           C  
ATOM    149  N   ASP A  29      15.942   4.535   1.459  1.00 31.84           N  
ATOM    150  CA  ASP A  29      17.215   5.034   0.973  1.00 31.89           C  
ATOM    151  C   ASP A  29      18.012   3.770   0.659  1.00 32.35           C  
ATOM    152  O   ASP A  29      17.936   2.791   1.401  1.00 31.69           O  
ATOM    153  CB  ASP A  29      17.901   5.812   2.088  1.00 33.82           C  
ATOM    154  CG  ASP A  29      19.231   6.366   1.674  1.00 35.00           C  
ATOM    155  OD1 ASP A  29      19.240   7.407   0.994  1.00 37.71           O  
ATOM    156  OD2 ASP A  29      20.263   5.759   2.018  1.00 37.53           O  
ATOM    157  N   GLU A  30      18.778   3.774  -0.427  1.00 33.95           N  
ATOM    158  CA  GLU A  30      19.542   2.582  -0.785  1.00 34.73           C  
ATOM    159  C   GLU A  30      20.606   2.196   0.236  1.00 32.79           C  
ATOM    160  O   GLU A  30      20.856   1.007   0.462  1.00 32.00           O  
ATOM    161  CB  GLU A  30      20.192   2.745  -2.159  1.00 39.61           C  
ATOM    162  CG  GLU A  30      20.827   1.445  -2.664  1.00 45.81           C  
ATOM    163  CD  GLU A  30      21.403   1.570  -4.063  1.00 49.64           C  
ATOM    164  OE1 GLU A  30      22.265   2.458  -4.282  1.00 52.43           O  
ATOM    165  OE2 GLU A  30      20.996   0.774  -4.942  1.00 51.49           O  
ATOM    166  N   ASN A  31      21.238   3.186   0.852  1.00 31.20           N  
ATOM    167  CA  ASN A  31      22.249   2.896   1.856  1.00 30.09           C  
ATOM    168  C   ASN A  31      21.597   2.222   3.049  1.00 28.96           C  
ATOM    169  O   ASN A  31      22.217   1.398   3.725  1.00 27.63           O  
ATOM    170  CB  ASN A  31      22.940   4.178   2.291  1.00 32.04           C  
ATOM    171  CG  ASN A  31      23.785   4.767   1.190  1.00 34.00           C  
ATOM    172  OD1 ASN A  31      24.603   4.066   0.577  1.00 34.12           O  
ATOM    173  ND2 ASN A  31      23.602   6.058   0.928  1.00 35.17           N  
ATOM    174  N   LEU A  32      20.344   2.583   3.306  1.00 27.43           N  
ATOM    175  CA  LEU A  32      19.603   1.976   4.397  1.00 26.81           C  
ATOM    176  C   LEU A  32      19.253   0.567   3.956  1.00 27.54           C  
ATOM    177  O   LEU A  32      19.508  -0.393   4.678  1.00 27.70           O  
ATOM    178  CB  LEU A  32      18.314   2.750   4.697  1.00 24.95           C  
ATOM    179  CG  LEU A  32      17.330   2.064   5.660  1.00 23.51           C  
ATOM    180  CD1 LEU A  32      18.037   1.578   6.927  1.00 22.83           C  
ATOM    181  CD2 LEU A  32      16.233   3.051   6.011  1.00 23.54           C  
ATOM    182  N   LEU A  33      18.680   0.453   2.760  1.00 29.16           N  
ATOM    183  CA  LEU A  33      18.280  -0.844   2.213  1.00 31.08           C  
ATOM    184  C   LEU A  33      19.454  -1.817   2.247  1.00 31.70           C  
ATOM    185  O   LEU A  33      19.302  -2.993   2.567  1.00 31.65           O  
ATOM    186  CB  LEU A  33      17.784  -0.658   0.783  1.00 31.55           C  
ATOM    187  CG  LEU A  33      16.869  -1.739   0.209  1.00 32.85           C  
ATOM    188  CD1 LEU A  33      15.811  -2.170   1.227  1.00 31.87           C  
ATOM    189  CD2 LEU A  33      16.220  -1.180  -1.046  1.00 33.33           C  
ATOM    190  N   ARG A  34      20.634  -1.309   1.921  1.00 33.23           N  
ATOM    191  CA  ARG A  34      21.846  -2.109   1.944  1.00 35.25           C  
ATOM    192  C   ARG A  34      22.015  -2.689   3.352  1.00 34.25           C  
ATOM    193  O   ARG A  34      22.267  -3.883   3.522  1.00 34.23           O  
ATOM    194  CB  ARG A  34      23.028  -1.214   1.617  1.00 38.14           C  
ATOM    195  CG  ARG A  34      24.159  -1.897   0.922  1.00 43.31           C  
ATOM    196  CD  ARG A  34      25.220  -0.864   0.610  1.00 47.71           C  
ATOM    197  NE  ARG A  34      24.707   0.200  -0.246  1.00 50.98           N  
ATOM    198  CZ  ARG A  34      24.797   0.195  -1.572  1.00 53.08           C  
ATOM    199  NH1 ARG A  34      25.391  -0.815  -2.199  1.00 53.63           N  
ATOM    200  NH2 ARG A  34      24.286   1.198  -2.275  1.00 53.87           N  
ATOM    201  N   GLY A  35      21.868  -1.829   4.359  1.00 33.04           N  
ATOM    202  CA  GLY A  35      22.005  -2.260   5.739  1.00 31.96           C  
ATOM    203  C   GLY A  35      20.961  -3.277   6.168  1.00 31.33           C  
ATOM    204  O   GLY A  35      21.271  -4.202   6.909  1.00 30.69           O  
ATOM    205  N   VAL A  36      19.723  -3.100   5.710  1.00 31.58           N  
ATOM    206  CA  VAL A  36      18.632  -4.015   6.049  1.00 31.81           C  
ATOM    207  C   VAL A  36      18.995  -5.425   5.599  1.00 32.33           C  
ATOM    208  O   VAL A  36      19.046  -6.352   6.413  1.00 32.55           O  
ATOM    209  CB  VAL A  36      17.301  -3.630   5.335  1.00 31.63           C  
ATOM    210  CG1 VAL A  36      16.242  -4.674   5.640  1.00 31.21           C  
ATOM    211  CG2 VAL A  36      16.832  -2.250   5.764  1.00 30.24           C  
ATOM    212  N   PHE A  37      19.230  -5.572   4.291  1.00 33.51           N  
ATOM    213  CA  PHE A  37      19.589  -6.856   3.691  1.00 34.70           C  
ATOM    214  C   PHE A  37      20.898  -7.344   4.278  1.00 36.88           C  
ATOM    215  O   PHE A  37      21.078  -8.539   4.510  1.00 38.47           O  
ATOM    216  CB  PHE A  37      19.698  -6.711   2.175  1.00 33.09           C  
ATOM    217  CG  PHE A  37      18.364  -6.550   1.486  1.00 32.95           C  
ATOM    218  CD1 PHE A  37      18.199  -5.624   0.461  1.00 32.48           C  
ATOM    219  CD2 PHE A  37      17.272  -7.330   1.861  1.00 33.24           C  
ATOM    220  CE1 PHE A  37      16.970  -5.478  -0.178  1.00 32.22           C  
ATOM    221  CE2 PHE A  37      16.035  -7.196   1.230  1.00 32.75           C  
ATOM    222  CZ  PHE A  37      15.883  -6.268   0.207  1.00 32.84           C  
ATOM    223  N   GLY A  38      21.798  -6.405   4.548  1.00 38.61           N  
ATOM    224  CA  GLY A  38      23.081  -6.756   5.123  1.00 39.62           C  
ATOM    225  C   GLY A  38      22.931  -7.304   6.524  1.00 40.93           C  
ATOM    226  O   GLY A  38      23.773  -8.055   6.994  1.00 41.73           O  
ATOM    227  N   TYR A  39      21.850  -6.942   7.200  1.00 42.23           N  
ATOM    228  CA  TYR A  39      21.637  -7.406   8.560  1.00 43.44           C  
ATOM    229  C   TYR A  39      21.065  -8.813   8.620  1.00 43.18           C  
ATOM    230  O   TYR A  39      21.198  -9.499   9.631  1.00 42.42           O  
ATOM    231  CB  TYR A  39      20.710  -6.448   9.305  1.00 45.53           C  
ATOM    232  CG  TYR A  39      20.545  -6.804  10.759  1.00 47.60           C  
ATOM    233  CD1 TYR A  39      21.642  -6.799  11.621  1.00 48.32           C  
ATOM    234  CD2 TYR A  39      19.303  -7.184  11.268  1.00 48.36           C  
ATOM    235  CE1 TYR A  39      21.511  -7.167  12.952  1.00 49.78           C  
ATOM    236  CE2 TYR A  39      19.157  -7.556  12.598  1.00 49.87           C  
ATOM    237  CZ  TYR A  39      20.267  -7.546  13.437  1.00 50.63           C  
ATOM    238  OH  TYR A  39      20.135  -7.921  14.755  1.00 52.05           O  
ATOM    239  N   GLY A  40      20.436  -9.240   7.534  1.00 44.10           N  
ATOM    240  CA  GLY A  40      19.845 -10.564   7.501  1.00 46.67           C  
ATOM    241  C   GLY A  40      18.332 -10.503   7.347  1.00 48.49           C  
ATOM    242  O   GLY A  40      17.644 -11.531   7.388  1.00 48.76           O  
ATOM    243  N   PHE A  41      17.814  -9.286   7.193  1.00 49.48           N  
ATOM    244  CA  PHE A  41      16.387  -9.063   7.007  1.00 49.72           C  
ATOM    245  C   PHE A  41      16.071  -9.362   5.561  1.00 50.19           C  
ATOM    246  O   PHE A  41      16.427  -8.593   4.674  1.00 51.28           O  
ATOM    247  CB  PHE A  41      16.032  -7.612   7.309  1.00 50.03           C  
ATOM    248  CG  PHE A  41      15.831  -7.326   8.762  1.00 50.92           C  
ATOM    249  CD1 PHE A  41      15.833  -6.020   9.227  1.00 50.91           C  
ATOM    250  CD2 PHE A  41      15.608  -8.359   9.666  1.00 51.61           C  
ATOM    251  CE1 PHE A  41      15.616  -5.743  10.569  1.00 51.69           C  
ATOM    252  CE2 PHE A  41      15.391  -8.095  11.009  1.00 52.31           C  
ATOM    253  CZ  PHE A  41      15.394  -6.782  11.464  1.00 51.61           C  
ATOM    254  N   GLU A  42      15.393 -10.475   5.322  1.00 50.71           N  
ATOM    255  CA  GLU A  42      15.056 -10.876   3.964  1.00 50.81           C  
ATOM    256  C   GLU A  42      13.644 -10.452   3.550  1.00 49.05           C  
ATOM    257  O   GLU A  42      13.453  -9.738   2.561  1.00 47.62           O  
ATOM    258  CB  GLU A  42      15.183 -12.395   3.850  1.00 53.82           C  
ATOM    259  CG  GLU A  42      16.333 -12.974   4.656  1.00 57.71           C  
ATOM    260  CD  GLU A  42      17.694 -12.455   4.202  1.00 60.96           C  
ATOM    261  OE1 GLU A  42      17.915 -11.217   4.223  1.00 62.05           O  
ATOM    262  OE2 GLU A  42      18.546 -13.294   3.825  1.00 62.09           O  
ATOM    263  N   GLU A  43      12.663 -10.907   4.323  1.00 47.55           N  
ATOM    264  CA  GLU A  43      11.257 -10.629   4.064  1.00 45.90           C  
ATOM    265  C   GLU A  43      10.630  -9.879   5.221  1.00 42.20           C  
ATOM    266  O   GLU A  43      10.814 -10.251   6.382  1.00 40.94           O  
ATOM    267  CB  GLU A  43      10.491 -11.945   3.871  1.00 49.75           C  
ATOM    268  CG  GLU A  43      10.829 -12.705   2.606  1.00 54.97           C  
ATOM    269  CD  GLU A  43      10.403 -11.949   1.361  1.00 58.18           C  
ATOM    270  OE1 GLU A  43       9.183 -11.719   1.187  1.00 60.57           O  
ATOM    271  OE2 GLU A  43      11.287 -11.581   0.560  1.00 60.89           O  
ATOM    272  N   PRO A  44       9.876  -8.809   4.923  1.00 39.67           N  
ATOM    273  CA  PRO A  44       9.260  -8.086   6.039  1.00 37.67           C  
ATOM    274  C   PRO A  44       8.250  -8.971   6.762  1.00 35.26           C  
ATOM    275  O   PRO A  44       7.522  -9.723   6.133  1.00 34.42           O  
ATOM    276  CB  PRO A  44       8.628  -6.862   5.361  1.00 38.01           C  
ATOM    277  CG  PRO A  44       8.452  -7.285   3.925  1.00 38.77           C  
ATOM    278  CD  PRO A  44       9.681  -8.097   3.647  1.00 38.49           C  
ATOM    279  N   SER A  45       8.230  -8.900   8.086  1.00 34.23           N  
ATOM    280  CA  SER A  45       7.296  -9.693   8.873  1.00 33.72           C  
ATOM    281  C   SER A  45       5.908  -9.062   8.805  1.00 33.54           C  
ATOM    282  O   SER A  45       5.745  -7.955   8.282  1.00 32.80           O  
ATOM    283  CB  SER A  45       7.749  -9.764  10.339  1.00 33.71           C  
ATOM    284  OG  SER A  45       7.632  -8.506  10.987  1.00 34.12           O  
ATOM    285  N   ALA A  46       4.914  -9.772   9.341  1.00 33.00           N  
ATOM    286  CA  ALA A  46       3.538  -9.292   9.362  1.00 31.96           C  
ATOM    287  C   ALA A  46       3.478  -7.827   9.806  1.00 31.67           C  
ATOM    288  O   ALA A  46       2.882  -6.982   9.135  1.00 31.75           O  
ATOM    289  CB  ALA A  46       2.712 -10.152  10.304  1.00 31.60           C  
ATOM    290  N   ILE A  47       4.116  -7.541  10.938  1.00 30.98           N  
ATOM    291  CA  ILE A  47       4.154  -6.201  11.520  1.00 31.06           C  
ATOM    292  C   ILE A  47       4.873  -5.164  10.664  1.00 29.49           C  
ATOM    293  O   ILE A  47       4.375  -4.054  10.485  1.00 28.52           O  
ATOM    294  CB  ILE A  47       4.837  -6.216  12.905  1.00 32.30           C  
ATOM    295  CG1 ILE A  47       4.423  -7.465  13.701  1.00 36.39           C  
ATOM    296  CG2 ILE A  47       4.427  -4.984  13.677  1.00 32.86           C  
ATOM    297  CD1 ILE A  47       4.980  -8.830  13.162  1.00 35.67           C  
ATOM    298  N   GLN A  48       6.051  -5.518  10.152  1.00 28.70           N  
ATOM    299  CA  GLN A  48       6.831  -4.602   9.319  1.00 28.66           C  
ATOM    300  C   GLN A  48       6.137  -4.381   7.978  1.00 27.62           C  
ATOM    301  O   GLN A  48       6.349  -3.369   7.306  1.00 27.45           O  
ATOM    302  CB  GLN A  48       8.229  -5.166   9.088  1.00 29.71           C  
ATOM    303  CG  GLN A  48       8.851  -5.751  10.339  1.00 32.07           C  
ATOM    304  CD  GLN A  48      10.226  -6.361  10.084  1.00 33.73           C  
ATOM    305  OE1 GLN A  48      10.461  -6.967   9.034  1.00 34.05           O  
ATOM    306  NE2 GLN A  48      11.135  -6.220  11.053  1.00 33.30           N  
ATOM    307  N   GLN A  49       5.307  -5.341   7.589  1.00 27.50           N  
ATOM    308  CA  GLN A  49       4.555  -5.253   6.338  1.00 27.50           C  
ATOM    309  C   GLN A  49       3.516  -4.156   6.427  1.00 26.49           C  
ATOM    310  O   GLN A  49       3.081  -3.619   5.416  1.00 26.54           O  
ATOM    311  CB  GLN A  49       3.813  -6.558   6.079  1.00 28.62           C  
ATOM    312  CG  GLN A  49       4.486  -7.484   5.116  1.00 32.25           C  
ATOM    313  CD  GLN A  49       4.003  -8.900   5.283  1.00 34.54           C  
ATOM    314  OE1 GLN A  49       2.816  -9.142   5.506  1.00 35.65           O  
ATOM    315  NE2 GLN A  49       4.919  -9.851   5.176  1.00 36.38           N  
ATOM    316  N   ARG A  50       3.124  -3.825   7.648  1.00 25.68           N  
ATOM    317  CA  ARG A  50       2.089  -2.835   7.853  1.00 25.59           C  
ATOM    318  C   ARG A  50       2.470  -1.559   8.585  1.00 25.34           C  
ATOM    319  O   ARG A  50       1.895  -0.501   8.313  1.00 26.01           O  
ATOM    320  CB  ARG A  50       0.946  -3.492   8.607  1.00 27.23           C  
ATOM    321  CG  ARG A  50       0.400  -4.707   7.906  1.00 29.74           C  
ATOM    322  CD  ARG A  50      -0.740  -5.328   8.684  1.00 31.94           C  
ATOM    323  NE  ARG A  50      -1.465  -6.266   7.836  1.00 34.58           N  
ATOM    324  CZ  ARG A  50      -0.916  -7.344   7.283  1.00 35.71           C  
ATOM    325  NH1 ARG A  50       0.368  -7.632   7.495  1.00 36.01           N  
ATOM    326  NH2 ARG A  50      -1.644  -8.126   6.499  1.00 35.35           N  
ATOM    327  N   ALA A  51       3.430  -1.651   9.500  1.00 23.53           N  
ATOM    328  CA  ALA A  51       3.814  -0.501  10.320  1.00 22.47           C  
ATOM    329  C   ALA A  51       4.942   0.412   9.873  1.00 21.82           C  
ATOM    330  O   ALA A  51       4.959   1.582  10.249  1.00 22.54           O  
ATOM    331  CB  ALA A  51       4.093  -0.972  11.742  1.00 22.65           C  
ATOM    332  N   ILE A  52       5.891  -0.090   9.095  1.00 20.34           N  
ATOM    333  CA  ILE A  52       6.982   0.771   8.679  1.00 19.74           C  
ATOM    334  C   ILE A  52       6.507   1.981   7.891  1.00 20.16           C  
ATOM    335  O   ILE A  52       6.858   3.119   8.226  1.00 19.79           O  
ATOM    336  CB  ILE A  52       8.013   0.021   7.825  1.00 20.31           C  
ATOM    337  CG1 ILE A  52       8.677  -1.076   8.662  1.00 19.31           C  
ATOM    338  CG2 ILE A  52       9.048   1.008   7.277  1.00 18.01           C  
ATOM    339  CD1 ILE A  52       9.539  -2.031   7.842  1.00 19.84           C  
ATOM    340  N   MET A  53       5.703   1.744   6.855  1.00 20.23           N  
ATOM    341  CA  MET A  53       5.222   2.832   6.011  1.00 20.94           C  
ATOM    342  C   MET A  53       4.512   3.975   6.738  1.00 20.16           C  
ATOM    343  O   MET A  53       4.862   5.150   6.543  1.00 20.76           O  
ATOM    344  CB  MET A  53       4.326   2.294   4.891  1.00 22.56           C  
ATOM    345  CG  MET A  53       5.062   1.493   3.818  1.00 27.36           C  
ATOM    346  SD  MET A  53       6.471   2.369   3.074  1.00 32.00           S  
ATOM    347  CE  MET A  53       5.765   4.054   2.875  1.00 31.15           C  
ATOM    348  N   PRO A  54       3.500   3.665   7.573  1.00 18.90           N  
ATOM    349  CA  PRO A  54       2.813   4.760   8.276  1.00 18.69           C  
ATOM    350  C   PRO A  54       3.744   5.564   9.178  1.00 18.61           C  
ATOM    351  O   PRO A  54       3.560   6.773   9.334  1.00 18.59           O  
ATOM    352  CB  PRO A  54       1.705   4.043   9.046  1.00 18.92           C  
ATOM    353  CG  PRO A  54       2.246   2.634   9.223  1.00 18.82           C  
ATOM    354  CD  PRO A  54       2.860   2.370   7.872  1.00 19.12           C  
ATOM    355  N   ILE A  55       4.737   4.905   9.778  1.00 17.14           N  
ATOM    356  CA  ILE A  55       5.689   5.616  10.619  1.00 17.20           C  
ATOM    357  C   ILE A  55       6.499   6.569   9.728  1.00 18.81           C  
ATOM    358  O   ILE A  55       6.686   7.738  10.063  1.00 20.63           O  
ATOM    359  CB  ILE A  55       6.652   4.657  11.342  1.00 16.95           C  
ATOM    360  CG1 ILE A  55       5.869   3.768  12.310  1.00 16.36           C  
ATOM    361  CG2 ILE A  55       7.725   5.463  12.102  1.00 14.44           C  
ATOM    362  CD1 ILE A  55       6.724   2.724  13.008  1.00 16.65           C  
ATOM    363  N   ILE A  56       6.973   6.086   8.588  1.00 19.00           N  
ATOM    364  CA  ILE A  56       7.733   6.947   7.683  1.00 19.50           C  
ATOM    365  C   ILE A  56       6.870   8.150   7.245  1.00 20.49           C  
ATOM    366  O   ILE A  56       7.344   9.285   7.171  1.00 19.87           O  
ATOM    367  CB  ILE A  56       8.185   6.160   6.437  1.00 19.54           C  
ATOM    368  CG1 ILE A  56       9.264   5.152   6.836  1.00 19.25           C  
ATOM    369  CG2 ILE A  56       8.684   7.113   5.356  1.00 19.72           C  
ATOM    370  CD1 ILE A  56       9.712   4.271   5.699  1.00 20.05           C  
ATOM    371  N   GLU A  57       5.592   7.895   6.989  1.00 21.23           N  
ATOM    372  CA  GLU A  57       4.680   8.939   6.545  1.00 22.63           C  
ATOM    373  C   GLU A  57       4.312   9.967   7.592  1.00 22.40           C  
ATOM    374  O   GLU A  57       3.605  10.914   7.291  1.00 22.97           O  
ATOM    375  CB  GLU A  57       3.424   8.303   5.955  1.00 24.92           C  
ATOM    376  CG  GLU A  57       3.780   7.373   4.810  1.00 28.45           C  
ATOM    377  CD  GLU A  57       2.593   6.673   4.237  1.00 30.94           C  
ATOM    378  OE1 GLU A  57       1.608   6.480   4.977  1.00 32.80           O  
ATOM    379  OE2 GLU A  57       2.660   6.297   3.048  1.00 34.84           O  
ATOM    380  N   GLY A  58       4.770   9.774   8.823  1.00 22.27           N  
ATOM    381  CA  GLY A  58       4.506  10.763   9.852  1.00 22.24           C  
ATOM    382  C   GLY A  58       3.342  10.560  10.793  1.00 21.86           C  
ATOM    383  O   GLY A  58       3.107  11.396  11.666  1.00 22.30           O  
ATOM    384  N   HIS A  59       2.613   9.468  10.632  1.00 20.67           N  
ATOM    385  CA  HIS A  59       1.475   9.196  11.495  1.00 21.15           C  
ATOM    386  C   HIS A  59       1.919   8.805  12.895  1.00 21.20           C  
ATOM    387  O   HIS A  59       3.001   8.240  13.074  1.00 21.44           O  
ATOM    388  CB  HIS A  59       0.661   8.028  10.947  1.00 21.95           C  
ATOM    389  CG  HIS A  59       0.031   8.292   9.622  1.00 23.96           C  
ATOM    390  ND1 HIS A  59      -1.106   9.056   9.481  1.00 25.16           N  
ATOM    391  CD2 HIS A  59       0.374   7.888   8.378  1.00 24.73           C  
ATOM    392  CE1 HIS A  59      -1.437   9.111   8.204  1.00 26.92           C  
ATOM    393  NE2 HIS A  59      -0.555   8.411   7.513  1.00 26.44           N  
ATOM    394  N   ASP A  60       1.088   9.123  13.882  1.00 20.72           N  
ATOM    395  CA  ASP A  60       1.352   8.700  15.246  1.00 20.35           C  
ATOM    396  C   ASP A  60       0.946   7.239  15.073  1.00 20.77           C  
ATOM    397  O   ASP A  60      -0.030   6.952  14.364  1.00 20.84           O  
ATOM    398  CB  ASP A  60       0.421   9.409  16.235  1.00 22.45           C  
ATOM    399  CG  ASP A  60       0.956  10.773  16.683  1.00 23.96           C  
ATOM    400  OD1 ASP A  60       0.243  11.479  17.421  1.00 24.99           O  
ATOM    401  OD2 ASP A  60       2.091  11.140  16.311  1.00 22.89           O  
ATOM    402  N   VAL A  61       1.687   6.311  15.672  1.00 20.28           N  
ATOM    403  CA  VAL A  61       1.363   4.900  15.484  1.00 20.69           C  
ATOM    404  C   VAL A  61       1.311   4.094  16.766  1.00 22.46           C  
ATOM    405  O   VAL A  61       2.225   4.152  17.593  1.00 22.38           O  
ATOM    406  CB  VAL A  61       2.385   4.210  14.512  1.00 19.79           C  
ATOM    407  CG1 VAL A  61       2.125   2.721  14.447  1.00 17.76           C  
ATOM    408  CG2 VAL A  61       2.291   4.826  13.110  1.00 17.98           C  
ATOM    409  N   LEU A  62       0.216   3.357  16.927  1.00 24.74           N  
ATOM    410  CA  LEU A  62       0.026   2.478  18.072  1.00 27.23           C  
ATOM    411  C   LEU A  62       0.067   1.054  17.512  1.00 28.78           C  
ATOM    412  O   LEU A  62      -0.708   0.703  16.617  1.00 27.90           O  
ATOM    413  CB  LEU A  62      -1.323   2.731  18.748  1.00 28.03           C  
ATOM    414  CG  LEU A  62      -1.758   1.675  19.778  1.00 29.14           C  
ATOM    415  CD1 LEU A  62      -0.715   1.512  20.878  1.00 29.99           C  
ATOM    416  CD2 LEU A  62      -3.094   2.088  20.364  1.00 29.89           C  
ATOM    417  N   ALA A  63       0.970   0.236  18.039  1.00 30.83           N  
ATOM    418  CA  ALA A  63       1.103  -1.128  17.558  1.00 34.00           C  
ATOM    419  C   ALA A  63       1.243  -2.143  18.683  1.00 36.62           C  
ATOM    420  O   ALA A  63       2.204  -2.095  19.459  1.00 36.61           O  
ATOM    421  CB  ALA A  63       2.309  -1.228  16.620  1.00 32.32           C  
ATOM    422  N   GLN A  64       0.280  -3.055  18.785  1.00 39.82           N  
ATOM    423  CA  GLN A  64       0.374  -4.092  19.799  1.00 43.55           C  
ATOM    424  C   GLN A  64       1.075  -5.253  19.122  1.00 45.04           C  
ATOM    425  O   GLN A  64       0.496  -5.924  18.271  1.00 45.47           O  
ATOM    426  CB  GLN A  64      -0.989  -4.555  20.281  1.00 45.20           C  
ATOM    427  CG  GLN A  64      -0.866  -5.676  21.298  1.00 48.92           C  
ATOM    428  CD  GLN A  64      -2.202  -6.220  21.746  1.00 51.08           C  
ATOM    429  OE1 GLN A  64      -2.265  -7.153  22.543  1.00 52.31           O  
ATOM    430  NE2 GLN A  64      -3.282  -5.639  21.236  1.00 52.75           N  
ATOM    431  N   ALA A  65       2.325  -5.482  19.495  1.00 46.47           N  
ATOM    432  CA  ALA A  65       3.090  -6.548  18.886  1.00 49.05           C  
ATOM    433  C   ALA A  65       3.883  -7.341  19.904  1.00 50.54           C  
ATOM    434  O   ALA A  65       4.574  -6.779  20.756  1.00 50.37           O  
ATOM    435  CB  ALA A  65       4.021  -5.966  17.834  1.00 49.56           C  
ATOM    436  N   GLN A  66       3.776  -8.658  19.804  1.00 52.67           N  
ATOM    437  CA  GLN A  66       4.486  -9.542  20.707  1.00 55.42           C  
ATOM    438  C   GLN A  66       5.966  -9.466  20.370  1.00 55.50           C  
ATOM    439  O   GLN A  66       6.337  -9.129  19.247  1.00 55.20           O  
ATOM    440  CB  GLN A  66       3.979 -10.979  20.545  1.00 58.00           C  
ATOM    441  CG  GLN A  66       2.461 -11.122  20.659  1.00 62.01           C  
ATOM    442  CD  GLN A  66       1.897 -10.427  21.891  1.00 64.94           C  
ATOM    443  OE1 GLN A  66       2.314 -10.700  23.025  1.00 66.40           O  
ATOM    444  NE2 GLN A  66       0.941  -9.518  21.674  1.00 65.73           N  
ATOM    445  N   SER A  67       6.813  -9.764  21.346  1.00 56.07           N  
ATOM    446  CA  SER A  67       8.251  -9.729  21.126  1.00 56.82           C  
ATOM    447  C   SER A  67       8.648 -10.802  20.110  1.00 56.42           C  
ATOM    448  O   SER A  67       7.959 -11.819  19.955  1.00 56.70           O  
ATOM    449  CB  SER A  67       8.987  -9.962  22.445  1.00 58.14           C  
ATOM    450  OG  SER A  67       8.482  -9.102  23.452  1.00 60.36           O  
ATOM    451  N   GLY A  68       9.754 -10.567  19.414  1.00 54.78           N  
ATOM    452  CA  GLY A  68      10.210 -11.524  18.424  1.00 52.96           C  
ATOM    453  C   GLY A  68       9.456 -11.457  17.107  1.00 51.75           C  
ATOM    454  O   GLY A  68       9.706 -12.267  16.216  1.00 52.84           O  
ATOM    455  N   THR A  69       8.541 -10.501  16.969  1.00 49.85           N  
ATOM    456  CA  THR A  69       7.767 -10.365  15.737  1.00 47.49           C  
ATOM    457  C   THR A  69       8.370  -9.315  14.803  1.00 46.50           C  
ATOM    458  O   THR A  69       7.786  -8.985  13.764  1.00 45.48           O  
ATOM    459  CB  THR A  69       6.291  -9.986  16.032  1.00 47.47           C  
ATOM    460  OG1 THR A  69       6.243  -8.765  16.775  1.00 46.98           O  
ATOM    461  CG2 THR A  69       5.609 -11.076  16.838  1.00 47.02           C  
ATOM    462  N   GLY A  70       9.541  -8.802  15.178  1.00 45.00           N  
ATOM    463  CA  GLY A  70      10.212  -7.794  14.377  1.00 42.91           C  
ATOM    464  C   GLY A  70       9.884  -6.350  14.743  1.00 41.14           C  
ATOM    465  O   GLY A  70       9.858  -5.488  13.865  1.00 40.95           O  
ATOM    466  N   LYS A  71       9.635  -6.083  16.026  1.00 39.23           N  
ATOM    467  CA  LYS A  71       9.316  -4.728  16.494  1.00 38.07           C  
ATOM    468  C   LYS A  71      10.501  -3.775  16.332  1.00 35.54           C  
ATOM    469  O   LYS A  71      10.374  -2.693  15.771  1.00 34.77           O  
ATOM    470  CB  LYS A  71       8.916  -4.724  17.978  1.00 39.83           C  
ATOM    471  CG  LYS A  71       7.589  -5.381  18.330  1.00 43.51           C  
ATOM    472  CD  LYS A  71       7.225  -5.139  19.812  1.00 45.90           C  
ATOM    473  CE  LYS A  71       8.308  -5.646  20.785  1.00 47.16           C  
ATOM    474  NZ  LYS A  71       8.000  -5.350  22.226  1.00 47.34           N  
ATOM    475  N   THR A  72      11.656  -4.177  16.836  1.00 32.81           N  
ATOM    476  CA  THR A  72      12.830  -3.330  16.757  1.00 32.15           C  
ATOM    477  C   THR A  72      13.132  -2.891  15.333  1.00 30.86           C  
ATOM    478  O   THR A  72      13.392  -1.717  15.081  1.00 30.49           O  
ATOM    479  CB  THR A  72      14.048  -4.047  17.342  1.00 31.51           C  
ATOM    480  OG1 THR A  72      13.713  -4.552  18.638  1.00 31.92           O  
ATOM    481  CG2 THR A  72      15.218  -3.083  17.468  1.00 31.87           C  
ATOM    482  N   GLY A  73      13.089  -3.839  14.402  1.00 30.07           N  
ATOM    483  CA  GLY A  73      13.363  -3.529  13.010  1.00 27.94           C  
ATOM    484  C   GLY A  73      12.353  -2.560  12.427  1.00 26.89           C  
ATOM    485  O   GLY A  73      12.706  -1.703  11.616  1.00 26.95           O  
ATOM    486  N   THR A  74      11.095  -2.693  12.843  1.00 25.90           N  
ATOM    487  CA  THR A  74      10.032  -1.815  12.362  1.00 25.73           C  
ATOM    488  C   THR A  74      10.314  -0.331  12.648  1.00 24.43           C  
ATOM    489  O   THR A  74      10.346   0.493  11.723  1.00 24.47           O  
ATOM    490  CB  THR A  74       8.663  -2.186  12.991  1.00 25.33           C  
ATOM    491  OG1 THR A  74       8.293  -3.513  12.591  1.00 25.82           O  
ATOM    492  CG2 THR A  74       7.583  -1.207  12.535  1.00 24.50           C  
ATOM    493  N   PHE A  75      10.526   0.022  13.915  1.00 22.03           N  
ATOM    494  CA  PHE A  75      10.773   1.417  14.212  1.00 22.12           C  
ATOM    495  C   PHE A  75      12.197   1.868  13.907  1.00 21.91           C  
ATOM    496  O   PHE A  75      12.428   3.058  13.675  1.00 22.30           O  
ATOM    497  CB  PHE A  75      10.360   1.765  15.658  1.00 21.66           C  
ATOM    498  CG  PHE A  75      11.141   1.051  16.742  1.00 23.07           C  
ATOM    499  CD1 PHE A  75      12.443   1.437  17.063  1.00 23.44           C  
ATOM    500  CD2 PHE A  75      10.541   0.045  17.499  1.00 22.75           C  
ATOM    501  CE1 PHE A  75      13.128   0.835  18.131  1.00 24.32           C  
ATOM    502  CE2 PHE A  75      11.219  -0.557  18.560  1.00 22.57           C  
ATOM    503  CZ  PHE A  75      12.512  -0.162  18.877  1.00 22.32           C  
ATOM    504  N   SER A  76      13.141   0.926  13.863  1.00 20.47           N  
ATOM    505  CA  SER A  76      14.531   1.274  13.562  1.00 20.92           C  
ATOM    506  C   SER A  76      14.682   1.679  12.104  1.00 19.99           C  
ATOM    507  O   SER A  76      15.318   2.690  11.796  1.00 19.93           O  
ATOM    508  CB  SER A  76      15.464   0.103  13.875  1.00 21.35           C  
ATOM    509  OG  SER A  76      15.500  -0.138  15.270  1.00 21.04           O  
ATOM    510  N   ILE A  77      14.086   0.888  11.213  1.00 19.68           N  
ATOM    511  CA  ILE A  77      14.132   1.166   9.779  1.00 18.65           C  
ATOM    512  C   ILE A  77      13.399   2.472   9.463  1.00 17.99           C  
ATOM    513  O   ILE A  77      13.915   3.313   8.724  1.00 18.05           O  
ATOM    514  CB  ILE A  77      13.500   0.003   8.961  1.00 18.72           C  
ATOM    515  CG1 ILE A  77      14.352  -1.263   9.131  1.00 19.31           C  
ATOM    516  CG2 ILE A  77      13.372   0.397   7.495  1.00 16.76           C  
ATOM    517  CD1 ILE A  77      13.790  -2.509   8.458  1.00 19.33           C  
ATOM    518  N   ALA A  78      12.207   2.649  10.029  1.00 17.59           N  
ATOM    519  CA  ALA A  78      11.438   3.866   9.783  1.00 18.05           C  
ATOM    520  C   ALA A  78      12.144   5.089  10.340  1.00 18.01           C  
ATOM    521  O   ALA A  78      12.147   6.132   9.709  1.00 19.16           O  
ATOM    522  CB  ALA A  78      10.039   3.753  10.388  1.00 18.37           C  
ATOM    523  N   ALA A  79      12.737   4.975  11.525  1.00 18.30           N  
ATOM    524  CA  ALA A  79      13.442   6.119  12.094  1.00 18.38           C  
ATOM    525  C   ALA A  79      14.657   6.500  11.251  1.00 18.35           C  
ATOM    526  O   ALA A  79      14.901   7.686  11.011  1.00 18.54           O  
ATOM    527  CB  ALA A  79      13.869   5.820  13.517  1.00 18.78           C  
ATOM    528  N   LEU A  80      15.410   5.499  10.790  1.00 18.22           N  
ATOM    529  CA  LEU A  80      16.610   5.751   9.990  1.00 18.05           C  
ATOM    530  C   LEU A  80      16.269   6.409   8.663  1.00 18.60           C  
ATOM    531  O   LEU A  80      17.005   7.267   8.180  1.00 19.04           O  
ATOM    532  CB  LEU A  80      17.398   4.448   9.785  1.00 17.85           C  
ATOM    533  CG  LEU A  80      18.212   4.026  11.024  1.00 17.38           C  
ATOM    534  CD1 LEU A  80      18.782   2.623  10.884  1.00 18.33           C  
ATOM    535  CD2 LEU A  80      19.325   5.025  11.223  1.00 16.67           C  
ATOM    536  N   GLN A  81      15.135   6.029   8.082  1.00 19.62           N  
ATOM    537  CA  GLN A  81      14.693   6.627   6.818  1.00 19.58           C  
ATOM    538  C   GLN A  81      14.324   8.106   7.004  1.00 19.91           C  
ATOM    539  O   GLN A  81      14.409   8.905   6.073  1.00 20.12           O  
ATOM    540  CB  GLN A  81      13.475   5.870   6.276  1.00 19.03           C  
ATOM    541  CG  GLN A  81      12.925   6.407   4.971  1.00 20.20           C  
ATOM    542  CD  GLN A  81      13.942   6.322   3.861  1.00 21.50           C  
ATOM    543  OE1 GLN A  81      14.695   5.357   3.777  1.00 22.58           O  
ATOM    544  NE2 GLN A  81      13.965   7.328   2.993  1.00 22.58           N  
ATOM    545  N   ARG A  82      13.931   8.463   8.218  1.00 20.42           N  
ATOM    546  CA  ARG A  82      13.510   9.819   8.525  1.00 20.54           C  
ATOM    547  C   ARG A  82      14.604  10.752   9.037  1.00 22.16           C  
ATOM    548  O   ARG A  82      14.374  11.949   9.224  1.00 23.39           O  
ATOM    549  CB  ARG A  82      12.370   9.756   9.530  1.00 18.61           C  
ATOM    550  CG  ARG A  82      11.114   9.141   8.958  1.00 19.77           C  
ATOM    551  CD  ARG A  82      10.405  10.134   8.057  1.00 22.52           C  
ATOM    552  NE  ARG A  82      10.135  11.381   8.780  1.00 24.70           N  
ATOM    553  CZ  ARG A  82       9.224  11.518   9.741  1.00 26.30           C  
ATOM    554  NH1 ARG A  82       8.468  10.486  10.098  1.00 26.81           N  
ATOM    555  NH2 ARG A  82       9.096  12.680  10.375  1.00 26.67           N  
ATOM    556  N   ILE A  83      15.799  10.229   9.256  1.00 22.82           N  
ATOM    557  CA  ILE A  83      16.879  11.074   9.749  1.00 23.85           C  
ATOM    558  C   ILE A  83      17.443  12.001   8.660  1.00 25.78           C  
ATOM    559  O   ILE A  83      17.632  11.591   7.516  1.00 24.87           O  
ATOM    560  CB  ILE A  83      18.029  10.206  10.344  1.00 22.97           C  
ATOM    561  CG1 ILE A  83      17.528   9.443  11.577  1.00 21.63           C  
ATOM    562  CG2 ILE A  83      19.220  11.074  10.709  1.00 23.03           C  
ATOM    563  CD1 ILE A  83      16.920  10.302  12.650  1.00 18.91           C  
ATOM    564  N   ASP A  84      17.661  13.267   9.014  1.00 27.67           N  
ATOM    565  CA  ASP A  84      18.262  14.244   8.103  1.00 29.20           C  
ATOM    566  C   ASP A  84      19.715  14.166   8.552  1.00 30.31           C  
ATOM    567  O   ASP A  84      20.094  14.807   9.524  1.00 30.72           O  
ATOM    568  CB  ASP A  84      17.708  15.649   8.378  1.00 29.84           C  
ATOM    569  CG  ASP A  84      18.315  16.726   7.467  1.00 30.69           C  
ATOM    570  OD1 ASP A  84      19.475  16.569   7.026  1.00 29.86           O  
ATOM    571  OD2 ASP A  84      17.631  17.743   7.210  1.00 30.72           O  
ATOM    572  N   THR A  85      20.522  13.362   7.872  1.00 32.96           N  
ATOM    573  CA  THR A  85      21.918  13.181   8.271  1.00 35.60           C  
ATOM    574  C   THR A  85      22.773  14.442   8.260  1.00 35.96           C  
ATOM    575  O   THR A  85      23.895  14.433   8.772  1.00 36.84           O  
ATOM    576  CB  THR A  85      22.626  12.102   7.415  1.00 36.36           C  
ATOM    577  OG1 THR A  85      22.770  12.576   6.071  1.00 38.77           O  
ATOM    578  CG2 THR A  85      21.821  10.807   7.416  1.00 36.37           C  
ATOM    579  N   SER A  86      22.258  15.523   7.688  1.00 36.02           N  
ATOM    580  CA  SER A  86      23.022  16.761   7.678  1.00 37.14           C  
ATOM    581  C   SER A  86      22.946  17.361   9.084  1.00 37.41           C  
ATOM    582  O   SER A  86      23.934  17.905   9.574  1.00 38.46           O  
ATOM    583  CB  SER A  86      22.468  17.755   6.647  1.00 36.36           C  
ATOM    584  OG  SER A  86      21.316  18.437   7.121  1.00 36.80           O  
ATOM    585  N   VAL A  87      21.777  17.240   9.724  1.00 36.35           N  
ATOM    586  CA  VAL A  87      21.545  17.753  11.082  1.00 35.50           C  
ATOM    587  C   VAL A  87      22.168  16.864  12.173  1.00 35.58           C  
ATOM    588  O   VAL A  87      21.740  15.731  12.416  1.00 34.24           O  
ATOM    589  CB  VAL A  87      20.040  17.902  11.363  1.00 35.09           C  
ATOM    590  CG1 VAL A  87      19.814  18.382  12.791  1.00 33.27           C  
ATOM    591  CG2 VAL A  87      19.431  18.869  10.360  1.00 35.83           C  
ATOM    592  N   LYS A  88      23.176  17.416  12.840  1.00 35.25           N  
ATOM    593  CA  LYS A  88      23.918  16.714  13.882  1.00 34.73           C  
ATOM    594  C   LYS A  88      23.394  16.993  15.300  1.00 33.19           C  
ATOM    595  O   LYS A  88      24.077  17.598  16.132  1.00 32.88           O  
ATOM    596  CB  LYS A  88      25.391  17.102  13.757  1.00 36.67           C  
ATOM    597  CG  LYS A  88      25.908  17.065  12.311  1.00 37.80           C  
ATOM    598  CD  LYS A  88      25.909  15.646  11.759  1.00 38.71           C  
ATOM    599  CE  LYS A  88      26.386  15.591  10.315  1.00 39.89           C  
ATOM    600  NZ  LYS A  88      26.526  14.170   9.827  1.00 42.37           N  
ATOM    601  N   ALA A  89      22.171  16.538  15.553  1.00 30.21           N  
ATOM    602  CA  ALA A  89      21.494  16.704  16.835  1.00 27.61           C  
ATOM    603  C   ALA A  89      20.411  15.632  16.915  1.00 26.83           C  
ATOM    604  O   ALA A  89      20.024  15.051  15.892  1.00 26.53           O  
ATOM    605  CB  ALA A  89      20.863  18.081  16.921  1.00 27.61           C  
ATOM    606  N   PRO A  90      19.905  15.354  18.128  1.00 25.22           N  
ATOM    607  CA  PRO A  90      18.862  14.337  18.310  1.00 23.35           C  
ATOM    608  C   PRO A  90      17.608  14.579  17.467  1.00 22.00           C  
ATOM    609  O   PRO A  90      17.011  15.657  17.537  1.00 19.75           O  
ATOM    610  CB  PRO A  90      18.571  14.411  19.811  1.00 23.26           C  
ATOM    611  CG  PRO A  90      19.906  14.788  20.384  1.00 23.56           C  
ATOM    612  CD  PRO A  90      20.345  15.883  19.434  1.00 24.29           C  
ATOM    613  N   GLN A  91      17.212  13.575  16.681  1.00 19.50           N  
ATOM    614  CA  GLN A  91      16.016  13.689  15.850  1.00 19.01           C  
ATOM    615  C   GLN A  91      15.008  12.616  16.232  1.00 19.25           C  
ATOM    616  O   GLN A  91      13.806  12.782  16.027  1.00 19.81           O  
ATOM    617  CB  GLN A  91      16.386  13.582  14.370  1.00 19.15           C  
ATOM    618  CG  GLN A  91      17.073  14.843  13.832  1.00 18.68           C  
ATOM    619  CD  GLN A  91      17.796  14.611  12.530  1.00 19.99           C  
ATOM    620  OE1 GLN A  91      19.028  14.732  12.457  1.00 22.37           O  
ATOM    621  NE2 GLN A  91      17.046  14.264  11.491  1.00 17.88           N  
ATOM    622  N   ALA A  92      15.510  11.515  16.791  1.00 18.70           N  
ATOM    623  CA  ALA A  92      14.668  10.409  17.236  1.00 18.48           C  
ATOM    624  C   ALA A  92      15.092   9.975  18.640  1.00 19.41           C  
ATOM    625  O   ALA A  92      16.271   9.745  18.913  1.00 20.08           O  
ATOM    626  CB  ALA A  92      14.768   9.231  16.267  1.00 17.60           C  
ATOM    627  N   LEU A  93      14.119   9.890  19.534  1.00 19.26           N  
ATOM    628  CA  LEU A  93      14.359   9.487  20.904  1.00 19.97           C  
ATOM    629  C   LEU A  93      13.637   8.168  21.089  1.00 19.95           C  
ATOM    630  O   LEU A  93      12.437   8.080  20.851  1.00 19.32           O  
ATOM    631  CB  LEU A  93      13.787  10.528  21.871  1.00 19.50           C  
ATOM    632  CG  LEU A  93      13.853  10.215  23.371  1.00 21.03           C  
ATOM    633  CD1 LEU A  93      15.298   9.995  23.785  1.00 19.11           C  
ATOM    634  CD2 LEU A  93      13.223  11.363  24.167  1.00 20.25           C  
ATOM    635  N   MET A  94      14.374   7.144  21.500  1.00 20.73           N  
ATOM    636  CA  MET A  94      13.807   5.822  21.712  1.00 22.43           C  
ATOM    637  C   MET A  94      13.938   5.466  23.184  1.00 23.28           C  
ATOM    638  O   MET A  94      15.030   5.548  23.751  1.00 24.27           O  
ATOM    639  CB  MET A  94      14.541   4.805  20.837  1.00 21.47           C  
ATOM    640  CG  MET A  94      14.541   5.179  19.359  1.00 21.53           C  
ATOM    641  SD  MET A  94      15.484   4.009  18.416  1.00 24.09           S  
ATOM    642  CE  MET A  94      15.346   4.719  16.779  1.00 23.34           C  
ATOM    643  N   LEU A  95      12.813   5.097  23.794  1.00 23.71           N  
ATOM    644  CA  LEU A  95      12.751   4.730  25.206  1.00 23.99           C  
ATOM    645  C   LEU A  95      12.453   3.227  25.385  1.00 26.59           C  
ATOM    646  O   LEU A  95      11.507   2.688  24.791  1.00 26.72           O  
ATOM    647  CB  LEU A  95      11.672   5.573  25.905  1.00 22.61           C  
ATOM    648  CG  LEU A  95      12.103   6.665  26.902  1.00 24.39           C  
ATOM    649  CD1 LEU A  95      13.219   7.490  26.321  1.00 23.98           C  
ATOM    650  CD2 LEU A  95      10.928   7.553  27.265  1.00 22.07           C  
ATOM    651  N   ALA A  96      13.282   2.547  26.177  1.00 27.52           N  
ATOM    652  CA  ALA A  96      13.091   1.123  26.453  1.00 29.47           C  
ATOM    653  C   ALA A  96      12.998   0.968  27.973  1.00 31.17           C  
ATOM    654  O   ALA A  96      13.531   1.783  28.724  1.00 30.42           O  
ATOM    655  CB  ALA A  96      14.258   0.303  25.896  1.00 28.38           C  
ATOM    656  N   PRO A  97      12.310  -0.079  28.444  1.00 32.57           N  
ATOM    657  CA  PRO A  97      12.168  -0.295  29.890  1.00 33.85           C  
ATOM    658  C   PRO A  97      13.441  -0.673  30.653  1.00 34.91           C  
ATOM    659  O   PRO A  97      13.552  -0.382  31.843  1.00 35.41           O  
ATOM    660  CB  PRO A  97      11.099  -1.380  29.970  1.00 33.98           C  
ATOM    661  CG  PRO A  97      11.350  -2.182  28.698  1.00 34.53           C  
ATOM    662  CD  PRO A  97      11.573  -1.096  27.670  1.00 33.09           C  
ATOM    663  N   THR A  98      14.402  -1.299  29.975  1.00 36.13           N  
ATOM    664  CA  THR A  98      15.645  -1.721  30.626  1.00 37.98           C  
ATOM    665  C   THR A  98      16.883  -1.330  29.846  1.00 38.91           C  
ATOM    666  O   THR A  98      16.804  -1.015  28.662  1.00 38.17           O  
ATOM    667  CB  THR A  98      15.705  -3.245  30.801  1.00 37.82           C  
ATOM    668  OG1 THR A  98      15.838  -3.872  29.514  1.00 37.91           O  
ATOM    669  CG2 THR A  98      14.450  -3.743  31.485  1.00 37.15           C  
ATOM    670  N   ARG A  99      18.030  -1.382  30.522  1.00 41.13           N  
ATOM    671  CA  ARG A  99      19.307  -1.038  29.912  1.00 43.64           C  
ATOM    672  C   ARG A  99      19.735  -2.091  28.900  1.00 43.47           C  
ATOM    673  O   ARG A  99      20.504  -1.792  27.987  1.00 43.18           O  
ATOM    674  CB  ARG A  99      20.401  -0.877  30.981  1.00 46.89           C  
ATOM    675  CG  ARG A  99      20.644   0.567  31.507  1.00 52.73           C  
ATOM    676  CD  ARG A  99      19.652   1.019  32.612  1.00 57.03           C  
ATOM    677  NE  ARG A  99      20.002   2.310  33.234  1.00 60.03           N  
ATOM    678  CZ  ARG A  99      19.320   2.876  34.234  1.00 61.42           C  
ATOM    679  NH1 ARG A  99      18.246   2.278  34.733  1.00 62.23           N  
ATOM    680  NH2 ARG A  99      19.709   4.042  34.742  1.00 62.22           N  
ATOM    681  N   GLU A 100      19.244  -3.320  29.065  1.00 43.52           N  
ATOM    682  CA  GLU A 100      19.578  -4.413  28.147  1.00 44.20           C  
ATOM    683  C   GLU A 100      18.835  -4.226  26.838  1.00 42.41           C  
ATOM    684  O   GLU A 100      19.398  -4.368  25.752  1.00 42.59           O  
ATOM    685  CB  GLU A 100      19.175  -5.762  28.734  1.00 47.54           C  
ATOM    686  CG  GLU A 100      20.076  -6.269  29.838  1.00 52.73           C  
ATOM    687  CD  GLU A 100      20.236  -5.270  30.961  1.00 55.60           C  
ATOM    688  OE1 GLU A 100      19.209  -4.704  31.405  1.00 56.59           O  
ATOM    689  OE2 GLU A 100      21.391  -5.058  31.400  1.00 57.69           O  
ATOM    690  N   LEU A 101      17.553  -3.924  26.952  1.00 40.02           N  
ATOM    691  CA  LEU A 101      16.740  -3.703  25.780  1.00 38.25           C  
ATOM    692  C   LEU A 101      17.345  -2.524  25.020  1.00 36.95           C  
ATOM    693  O   LEU A 101      17.602  -2.603  23.823  1.00 36.57           O  
ATOM    694  CB  LEU A 101      15.310  -3.392  26.211  1.00 38.50           C  
ATOM    695  CG  LEU A 101      14.283  -3.391  25.086  1.00 39.36           C  
ATOM    696  CD1 LEU A 101      14.430  -4.661  24.265  1.00 39.97           C  
ATOM    697  CD2 LEU A 101      12.893  -3.286  25.673  1.00 40.05           C  
ATOM    698  N   ALA A 102      17.591  -1.436  25.740  1.00 36.06           N  
ATOM    699  CA  ALA A 102      18.163  -0.227  25.158  1.00 35.57           C  
ATOM    700  C   ALA A 102      19.457  -0.502  24.406  1.00 36.10           C  
ATOM    701  O   ALA A 102      19.691   0.019  23.312  1.00 35.49           O  
ATOM    702  CB  ALA A 102      18.415   0.789  26.250  1.00 35.20           C  
ATOM    703  N   LEU A 103      20.305  -1.320  25.011  1.00 37.09           N  
ATOM    704  CA  LEU A 103      21.580  -1.677  24.421  1.00 37.66           C  
ATOM    705  C   LEU A 103      21.345  -2.454  23.144  1.00 38.10           C  
ATOM    706  O   LEU A 103      22.021  -2.243  22.140  1.00 37.52           O  
ATOM    707  CB  LEU A 103      22.368  -2.531  25.397  1.00 39.00           C  
ATOM    708  CG  LEU A 103      23.788  -2.042  25.632  1.00 40.84           C  
ATOM    709  CD1 LEU A 103      23.800  -0.545  25.906  1.00 40.82           C  
ATOM    710  CD2 LEU A 103      24.360  -2.811  26.804  1.00 41.93           C  
ATOM    711  N   GLN A 104      20.380  -3.364  23.193  1.00 38.64           N  
ATOM    712  CA  GLN A 104      20.055  -4.169  22.031  1.00 39.12           C  
ATOM    713  C   GLN A 104      19.551  -3.300  20.883  1.00 37.30           C  
ATOM    714  O   GLN A 104      19.948  -3.493  19.736  1.00 36.70           O  
ATOM    715  CB  GLN A 104      18.996  -5.212  22.381  1.00 42.54           C  
ATOM    716  CG  GLN A 104      18.567  -6.031  21.178  1.00 48.07           C  
ATOM    717  CD  GLN A 104      17.437  -6.985  21.489  1.00 52.00           C  
ATOM    718  OE1 GLN A 104      16.430  -6.602  22.095  1.00 54.83           O  
ATOM    719  NE2 GLN A 104      17.588  -8.239  21.065  1.00 54.48           N  
ATOM    720  N   ILE A 105      18.670  -2.351  21.187  1.00 35.69           N  
ATOM    721  CA  ILE A 105      18.135  -1.468  20.151  1.00 34.17           C  
ATOM    722  C   ILE A 105      19.272  -0.673  19.506  1.00 33.66           C  
ATOM    723  O   ILE A 105      19.237  -0.392  18.313  1.00 33.15           O  
ATOM    724  CB  ILE A 105      17.077  -0.474  20.721  1.00 33.43           C  
ATOM    725  CG1 ILE A 105      15.868  -1.240  21.269  1.00 33.01           C  
ATOM    726  CG2 ILE A 105      16.638   0.497  19.637  1.00 31.92           C  
ATOM    727  CD1 ILE A 105      14.833  -0.365  21.976  1.00 31.94           C  
ATOM    728  N   GLN A 106      20.279  -0.317  20.299  1.00 32.56           N  
ATOM    729  CA  GLN A 106      21.407   0.431  19.776  1.00 32.99           C  
ATOM    730  C   GLN A 106      22.193  -0.453  18.810  1.00 33.10           C  
ATOM    731  O   GLN A 106      22.664   0.012  17.770  1.00 32.74           O  
ATOM    732  CB  GLN A 106      22.318   0.888  20.914  1.00 34.41           C  
ATOM    733  CG  GLN A 106      23.397   1.866  20.474  1.00 36.42           C  
ATOM    734  CD  GLN A 106      24.515   2.036  21.497  1.00 37.14           C  
ATOM    735  OE1 GLN A 106      25.346   2.934  21.377  1.00 37.98           O  
ATOM    736  NE2 GLN A 106      24.543   1.169  22.501  1.00 38.28           N  
ATOM    737  N   LYS A 107      22.328  -1.731  19.164  1.00 34.03           N  
ATOM    738  CA  LYS A 107      23.046  -2.711  18.339  1.00 34.29           C  
ATOM    739  C   LYS A 107      22.418  -2.786  16.956  1.00 32.27           C  
ATOM    740  O   LYS A 107      23.106  -2.664  15.948  1.00 32.53           O  
ATOM    741  CB  LYS A 107      22.971  -4.112  18.957  1.00 38.34           C  
ATOM    742  CG  LYS A 107      23.296  -4.198  20.446  1.00 44.25           C  
ATOM    743  CD  LYS A 107      24.795  -4.228  20.731  1.00 48.46           C  
ATOM    744  CE  LYS A 107      25.053  -4.285  22.239  1.00 51.44           C  
ATOM    745  NZ  LYS A 107      26.506  -4.315  22.584  1.00 53.94           N  
ATOM    746  N   VAL A 108      21.102  -2.991  16.930  1.00 30.32           N  
ATOM    747  CA  VAL A 108      20.343  -3.104  15.690  1.00 28.85           C  
ATOM    748  C   VAL A 108      20.408  -1.840  14.838  1.00 28.75           C  
ATOM    749  O   VAL A 108      20.706  -1.913  13.643  1.00 27.35           O  
ATOM    750  CB  VAL A 108      18.869  -3.458  15.987  1.00 28.16           C  
ATOM    751  CG1 VAL A 108      18.058  -3.445  14.718  1.00 28.12           C  
ATOM    752  CG2 VAL A 108      18.792  -4.824  16.613  1.00 27.92           C  
ATOM    753  N   VAL A 109      20.140  -0.688  15.458  1.00 28.56           N  
ATOM    754  CA  VAL A 109      20.165   0.599  14.762  1.00 28.70           C  
ATOM    755  C   VAL A 109      21.516   0.845  14.093  1.00 30.18           C  
ATOM    756  O   VAL A 109      21.584   1.303  12.952  1.00 29.97           O  
ATOM    757  CB  VAL A 109      19.876   1.767  15.733  1.00 27.69           C  
ATOM    758  CG1 VAL A 109      19.962   3.095  15.000  1.00 28.06           C  
ATOM    759  CG2 VAL A 109      18.516   1.601  16.345  1.00 26.16           C  
ATOM    760  N   MET A 110      22.592   0.539  14.810  1.00 31.79           N  
ATOM    761  CA  MET A 110      23.920   0.737  14.259  1.00 33.98           C  
ATOM    762  C   MET A 110      24.180  -0.205  13.085  1.00 33.19           C  
ATOM    763  O   MET A 110      24.783   0.187  12.078  1.00 33.73           O  
ATOM    764  CB  MET A 110      24.974   0.555  15.352  1.00 36.83           C  
ATOM    765  CG  MET A 110      24.953   1.702  16.349  1.00 41.40           C  
ATOM    766  SD  MET A 110      26.455   1.832  17.347  1.00 47.86           S  
ATOM    767  CE  MET A 110      27.645   2.476  16.086  1.00 45.69           C  
ATOM    768  N   ALA A 111      23.713  -1.442  13.201  1.00 31.57           N  
ATOM    769  CA  ALA A 111      23.904  -2.405  12.127  1.00 29.80           C  
ATOM    770  C   ALA A 111      23.155  -1.957  10.873  1.00 28.54           C  
ATOM    771  O   ALA A 111      23.684  -2.031   9.763  1.00 28.54           O  
ATOM    772  CB  ALA A 111      23.423  -3.779  12.569  1.00 30.26           C  
ATOM    773  N   LEU A 112      21.930  -1.477  11.044  1.00 26.91           N  
ATOM    774  CA  LEU A 112      21.139  -1.040   9.898  1.00 26.11           C  
ATOM    775  C   LEU A 112      21.727   0.205   9.261  1.00 25.47           C  
ATOM    776  O   LEU A 112      21.635   0.395   8.047  1.00 25.64           O  
ATOM    777  CB  LEU A 112      19.683  -0.777  10.325  1.00 25.29           C  
ATOM    778  CG  LEU A 112      18.925  -2.014  10.830  1.00 25.17           C  
ATOM    779  CD1 LEU A 112      17.581  -1.594  11.396  1.00 24.26           C  
ATOM    780  CD2 LEU A 112      18.753  -3.032   9.694  1.00 24.68           C  
ATOM    781  N   ALA A 113      22.346   1.041  10.096  1.00 26.55           N  
ATOM    782  CA  ALA A 113      22.953   2.293   9.653  1.00 27.02           C  
ATOM    783  C   ALA A 113      24.398   2.127   9.192  1.00 28.35           C  
ATOM    784  O   ALA A 113      25.092   3.112   8.947  1.00 28.34           O  
ATOM    785  CB  ALA A 113      22.884   3.323  10.782  1.00 25.93           C  
ATOM    786  N   PHE A 114      24.840   0.881   9.057  1.00 29.21           N  
ATOM    787  CA  PHE A 114      26.212   0.593   8.657  1.00 30.16           C  
ATOM    788  C   PHE A 114      26.712   1.359   7.448  1.00 29.86           C  
ATOM    789  O   PHE A 114      27.870   1.766   7.409  1.00 31.25           O  
ATOM    790  CB  PHE A 114      26.398  -0.895   8.383  1.00 31.77           C  
ATOM    791  CG  PHE A 114      27.830  -1.278   8.139  1.00 34.51           C  
ATOM    792  CD1 PHE A 114      28.749  -1.290   9.191  1.00 35.42           C  
ATOM    793  CD2 PHE A 114      28.272  -1.601   6.855  1.00 35.55           C  
ATOM    794  CE1 PHE A 114      30.090  -1.619   8.975  1.00 36.91           C  
ATOM    795  CE2 PHE A 114      29.608  -1.932   6.624  1.00 37.01           C  
ATOM    796  CZ  PHE A 114      30.523  -1.940   7.690  1.00 36.57           C  
ATOM    797  N   HIS A 115      25.861   1.534   6.449  1.00 29.77           N  
ATOM    798  CA  HIS A 115      26.276   2.257   5.260  1.00 29.76           C  
ATOM    799  C   HIS A 115      25.817   3.697   5.296  1.00 29.71           C  
ATOM    800  O   HIS A 115      25.751   4.357   4.263  1.00 30.15           O  
ATOM    801  CB  HIS A 115      25.740   1.583   3.994  1.00 31.23           C  
ATOM    802  CG  HIS A 115      26.211   0.176   3.815  1.00 32.54           C  
ATOM    803  ND1 HIS A 115      25.758  -0.866   4.597  1.00 33.86           N  
ATOM    804  CD2 HIS A 115      27.123  -0.357   2.970  1.00 31.91           C  
ATOM    805  CE1 HIS A 115      26.369  -1.981   4.239  1.00 32.88           C  
ATOM    806  NE2 HIS A 115      27.202  -1.699   3.253  1.00 33.11           N  
ATOM    807  N   MET A 116      25.501   4.193   6.484  1.00 29.88           N  
ATOM    808  CA  MET A 116      25.057   5.570   6.613  1.00 31.39           C  
ATOM    809  C   MET A 116      25.942   6.314   7.602  1.00 32.26           C  
ATOM    810  O   MET A 116      26.694   5.704   8.363  1.00 32.76           O  
ATOM    811  CB  MET A 116      23.601   5.612   7.073  1.00 31.13           C  
ATOM    812  CG  MET A 116      22.716   4.680   6.279  1.00 32.24           C  
ATOM    813  SD  MET A 116      20.983   4.901   6.660  1.00 33.20           S  
ATOM    814  CE  MET A 116      20.867   4.026   8.134  1.00 35.63           C  
ATOM    815  N   ASP A 117      25.862   7.636   7.582  1.00 33.24           N  
ATOM    816  CA  ASP A 117      26.661   8.435   8.488  1.00 34.41           C  
ATOM    817  C   ASP A 117      25.722   8.937   9.575  1.00 34.73           C  
ATOM    818  O   ASP A 117      25.309  10.096   9.577  1.00 34.87           O  
ATOM    819  CB  ASP A 117      27.311   9.585   7.720  1.00 35.58           C  
ATOM    820  CG  ASP A 117      28.289  10.378   8.570  1.00 38.63           C  
ATOM    821  OD1 ASP A 117      28.996   9.767   9.416  1.00 38.74           O  
ATOM    822  OD2 ASP A 117      28.353  11.616   8.380  1.00 39.82           O  
ATOM    823  N   ILE A 118      25.377   8.037  10.492  1.00 35.05           N  
ATOM    824  CA  ILE A 118      24.458   8.344  11.583  1.00 35.63           C  
ATOM    825  C   ILE A 118      25.061   8.006  12.936  1.00 36.07           C  
ATOM    826  O   ILE A 118      25.649   6.938  13.124  1.00 36.33           O  
ATOM    827  CB  ILE A 118      23.137   7.559  11.419  1.00 35.66           C  
ATOM    828  CG1 ILE A 118      22.416   8.031  10.157  1.00 35.89           C  
ATOM    829  CG2 ILE A 118      22.253   7.744  12.642  1.00 34.67           C  
ATOM    830  CD1 ILE A 118      21.291   7.122   9.735  1.00 37.96           C  
ATOM    831  N   LYS A 119      24.897   8.922  13.879  1.00 35.85           N  
ATOM    832  CA  LYS A 119      25.427   8.738  15.219  1.00 36.58           C  
ATOM    833  C   LYS A 119      24.301   8.341  16.187  1.00 35.18           C  
ATOM    834  O   LYS A 119      23.327   9.078  16.361  1.00 34.06           O  
ATOM    835  CB  LYS A 119      26.121  10.032  15.668  1.00 38.36           C  
ATOM    836  CG  LYS A 119      26.779   9.948  17.033  1.00 42.70           C  
ATOM    837  CD  LYS A 119      27.433  11.275  17.426  1.00 45.23           C  
ATOM    838  CE  LYS A 119      27.988  11.217  18.855  1.00 46.50           C  
ATOM    839  NZ  LYS A 119      28.741  12.453  19.213  1.00 47.66           N  
ATOM    840  N   VAL A 120      24.449   7.160  16.792  1.00 34.21           N  
ATOM    841  CA  VAL A 120      23.485   6.606  17.747  1.00 34.31           C  
ATOM    842  C   VAL A 120      24.131   6.535  19.130  1.00 34.76           C  
ATOM    843  O   VAL A 120      25.212   5.975  19.288  1.00 36.11           O  
ATOM    844  CB  VAL A 120      23.064   5.164  17.360  1.00 33.22           C  
ATOM    845  CG1 VAL A 120      22.082   4.608  18.390  1.00 31.96           C  
ATOM    846  CG2 VAL A 120      22.462   5.154  15.969  1.00 33.84           C  
ATOM    847  N   HIS A 121      23.476   7.084  20.139  1.00 34.70           N  
ATOM    848  CA  HIS A 121      24.048   7.049  21.473  1.00 34.33           C  
ATOM    849  C   HIS A 121      23.055   6.498  22.467  1.00 33.31           C  
ATOM    850  O   HIS A 121      21.870   6.809  22.381  1.00 32.75           O  
ATOM    851  CB  HIS A 121      24.453   8.449  21.914  1.00 36.97           C  
ATOM    852  CG  HIS A 121      24.996   8.496  23.305  1.00 41.13           C  
ATOM    853  ND1 HIS A 121      26.249   8.022  23.629  1.00 43.40           N  
ATOM    854  CD2 HIS A 121      24.435   8.904  24.467  1.00 42.82           C  
ATOM    855  CE1 HIS A 121      26.435   8.136  24.934  1.00 43.52           C  
ATOM    856  NE2 HIS A 121      25.349   8.668  25.465  1.00 43.80           N  
ATOM    857  N   ALA A 122      23.534   5.689  23.410  1.00 31.78           N  
ATOM    858  CA  ALA A 122      22.659   5.122  24.430  1.00 32.89           C  
ATOM    859  C   ALA A 122      22.792   5.876  25.759  1.00 33.97           C  
ATOM    860  O   ALA A 122      23.898   6.209  26.185  1.00 34.42           O  
ATOM    861  CB  ALA A 122      22.970   3.638  24.630  1.00 31.48           C  
ATOM    862  N   CYS A 123      21.653   6.155  26.395  1.00 35.62           N  
ATOM    863  CA  CYS A 123      21.600   6.848  27.682  1.00 38.09           C  
ATOM    864  C   CYS A 123      21.279   5.834  28.767  1.00 38.79           C  
ATOM    865  O   CYS A 123      20.114   5.570  29.066  1.00 39.47           O  
ATOM    866  CB  CYS A 123      20.513   7.921  27.676  1.00 38.92           C  
ATOM    867  SG  CYS A 123      21.107   9.595  27.533  1.00 42.76           S  
ATOM    868  N   ILE A 124      22.326   5.278  29.360  1.00 41.03           N  
ATOM    869  CA  ILE A 124      22.181   4.279  30.406  1.00 42.21           C  
ATOM    870  C   ILE A 124      23.081   4.597  31.609  1.00 43.39           C  
ATOM    871  O   ILE A 124      22.672   4.335  32.739  1.00 43.54           O  
ATOM    872  CB  ILE A 124      22.536   2.891  29.837  1.00 44.04           C  
ATOM    873  CG1 ILE A 124      23.906   2.949  29.149  1.00 42.67           C  
ATOM    874  CG2 ILE A 124      21.487   2.464  28.820  1.00 41.66           C  
ATOM    875  CD1 ILE A 124      24.323   1.647  28.501  1.00 43.53           C  
ATOM    876  N   GLY A 125      24.183   5.104  31.406  1.00 44.81           N  
ATOM    877  N   GLY A 135      29.073  13.600  23.811  1.00 47.24           N  
ATOM    878  CA  GLY A 135      28.622  12.336  23.118  1.00 47.11           C  
ATOM    879  C   GLY A 135      27.148  12.381  22.746  1.00 46.92           C  
ATOM    880  O   GLY A 135      26.745  11.995  21.647  1.00 46.12           O  
ATOM    881  N   LEU A 136      26.337  12.860  23.681  1.00 46.57           N  
ATOM    882  CA  LEU A 136      24.901  12.991  23.489  1.00 46.53           C  
ATOM    883  C   LEU A 136      24.531  14.239  22.688  1.00 46.85           C  
ATOM    884  O   LEU A 136      23.484  14.280  22.052  1.00 47.17           O  
ATOM    885  CB  LEU A 136      24.193  13.074  24.850  1.00 46.56           C  
ATOM    886  CG  LEU A 136      23.774  11.811  25.602  1.00 45.70           C  
ATOM    887  CD1 LEU A 136      23.489  12.118  27.070  1.00 45.10           C  
ATOM    888  CD2 LEU A 136      22.547  11.245  24.922  1.00 46.28           C  
ATOM    889  N   ARG A 137      25.390  15.251  22.706  1.00 47.40           N  
ATOM    890  CA  ARG A 137      25.080  16.513  22.031  1.00 48.23           C  
ATOM    891  C   ARG A 137      24.844  16.510  20.522  1.00 46.49           C  
ATOM    892  O   ARG A 137      24.018  17.288  20.035  1.00 46.31           O  
ATOM    893  CB  ARG A 137      26.118  17.584  22.430  1.00 50.49           C  
ATOM    894  CG  ARG A 137      26.042  17.853  23.939  1.00 55.01           C  
ATOM    895  CD  ARG A 137      26.840  19.045  24.474  1.00 58.37           C  
ATOM    896  NE  ARG A 137      26.560  19.222  25.909  1.00 61.65           N  
ATOM    897  CZ  ARG A 137      27.015  20.216  26.678  1.00 63.44           C  
ATOM    898  NH1 ARG A 137      27.798  21.166  26.170  1.00 64.55           N  
ATOM    899  NH2 ARG A 137      26.676  20.265  27.966  1.00 64.00           N  
ATOM    900  N   ASP A 138      25.537  15.648  19.781  1.00 44.12           N  
ATOM    901  CA  ASP A 138      25.329  15.597  18.334  1.00 42.05           C  
ATOM    902  C   ASP A 138      24.923  14.205  17.833  1.00 40.32           C  
ATOM    903  O   ASP A 138      25.119  13.866  16.661  1.00 41.08           O  
ATOM    904  CB  ASP A 138      26.578  16.094  17.598  1.00 43.46           C  
ATOM    905  CG  ASP A 138      27.794  15.244  17.873  1.00 44.45           C  
ATOM    906  OD1 ASP A 138      27.978  14.829  19.037  1.00 45.45           O  
ATOM    907  OD2 ASP A 138      28.573  15.004  16.925  1.00 45.79           O  
ATOM    908  N   ALA A 139      24.364  13.395  18.727  1.00 36.72           N  
ATOM    909  CA  ALA A 139      23.903  12.067  18.345  1.00 33.53           C  
ATOM    910  C   ALA A 139      22.580  12.327  17.656  1.00 30.62           C  
ATOM    911  O   ALA A 139      21.799  13.148  18.135  1.00 30.41           O  
ATOM    912  CB  ALA A 139      23.687  11.194  19.583  1.00 33.72           C  
ATOM    913  N   GLN A 140      22.326  11.652  16.540  1.00 26.98           N  
ATOM    914  CA  GLN A 140      21.073  11.856  15.829  1.00 24.51           C  
ATOM    915  C   GLN A 140      19.963  10.965  16.359  1.00 22.65           C  
ATOM    916  O   GLN A 140      18.783  11.297  16.281  1.00 20.93           O  
ATOM    917  CB  GLN A 140      21.294  11.648  14.340  1.00 24.20           C  
ATOM    918  CG  GLN A 140      22.032  12.825  13.751  1.00 26.13           C  
ATOM    919  CD  GLN A 140      22.913  12.441  12.607  1.00 25.03           C  
ATOM    920  OE1 GLN A 140      23.566  11.403  12.638  1.00 26.63           O  
ATOM    921  NE2 GLN A 140      22.960  13.286  11.592  1.00 27.67           N  
ATOM    922  N   ILE A 141      20.355   9.834  16.920  1.00 22.25           N  
ATOM    923  CA  ILE A 141      19.402   8.915  17.506  1.00 22.44           C  
ATOM    924  C   ILE A 141      19.871   8.690  18.933  1.00 22.45           C  
ATOM    925  O   ILE A 141      21.042   8.407  19.170  1.00 21.96           O  
ATOM    926  CB  ILE A 141      19.361   7.560  16.751  1.00 22.73           C  
ATOM    927  CG1 ILE A 141      18.809   7.759  15.338  1.00 22.67           C  
ATOM    928  CG2 ILE A 141      18.488   6.560  17.509  1.00 21.42           C  
ATOM    929  CD1 ILE A 141      18.780   6.474  14.513  1.00 24.28           C  
ATOM    930  N   VAL A 142      18.958   8.855  19.881  1.00 22.79           N  
ATOM    931  CA  VAL A 142      19.267   8.650  21.287  1.00 23.64           C  
ATOM    932  C   VAL A 142      18.377   7.536  21.833  1.00 25.32           C  
ATOM    933  O   VAL A 142      17.152   7.580  21.697  1.00 25.61           O  
ATOM    934  CB  VAL A 142      19.042   9.941  22.107  1.00 23.42           C  
ATOM    935  CG1 VAL A 142      19.099   9.640  23.600  1.00 23.06           C  
ATOM    936  CG2 VAL A 142      20.109  10.945  21.761  1.00 22.79           C  
ATOM    937  N   VAL A 143      18.999   6.529  22.437  1.00 25.91           N  
ATOM    938  CA  VAL A 143      18.257   5.405  23.000  1.00 27.37           C  
ATOM    939  C   VAL A 143      18.524   5.353  24.496  1.00 27.25           C  
ATOM    940  O   VAL A 143      19.651   5.561  24.923  1.00 28.22           O  
ATOM    941  CB  VAL A 143      18.721   4.054  22.408  1.00 27.77           C  
ATOM    942  CG1 VAL A 143      17.690   2.974  22.744  1.00 28.11           C  
ATOM    943  CG2 VAL A 143      18.957   4.177  20.908  1.00 28.41           C  
ATOM    944  N   GLY A 144      17.506   5.060  25.295  1.00 27.78           N  
ATOM    945  CA  GLY A 144      17.739   4.995  26.726  1.00 27.89           C  
ATOM    946  C   GLY A 144      16.539   4.668  27.587  1.00 28.35           C  
ATOM    947  O   GLY A 144      15.436   4.444  27.095  1.00 27.76           O  
ATOM    948  N   THR A 145      16.771   4.624  28.893  1.00 28.71           N  
ATOM    949  CA  THR A 145      15.712   4.343  29.838  1.00 28.77           C  
ATOM    950  C   THR A 145      15.125   5.685  30.250  1.00 28.08           C  
ATOM    951  O   THR A 145      15.826   6.693  30.267  1.00 28.20           O  
ATOM    952  CB  THR A 145      16.247   3.560  31.063  1.00 29.20           C  
ATOM    953  OG1 THR A 145      17.369   4.247  31.639  1.00 30.21           O  
ATOM    954  CG2 THR A 145      16.673   2.165  30.632  1.00 28.46           C  
ATOM    955  N   PRO A 146      13.829   5.711  30.585  1.00 27.96           N  
ATOM    956  CA  PRO A 146      13.118   6.928  30.989  1.00 28.66           C  
ATOM    957  C   PRO A 146      13.816   7.806  32.022  1.00 29.71           C  
ATOM    958  O   PRO A 146      13.925   9.019  31.834  1.00 30.19           O  
ATOM    959  CB  PRO A 146      11.784   6.391  31.490  1.00 28.48           C  
ATOM    960  CG  PRO A 146      11.590   5.157  30.651  1.00 28.98           C  
ATOM    961  CD  PRO A 146      12.951   4.533  30.695  1.00 27.71           C  
ATOM    962  N   GLY A 147      14.277   7.192  33.109  1.00 30.04           N  
ATOM    963  CA  GLY A 147      14.944   7.945  34.157  1.00 29.85           C  
ATOM    964  C   GLY A 147      16.213   8.634  33.701  1.00 29.44           C  
ATOM    965  O   GLY A 147      16.390   9.835  33.921  1.00 29.06           O  
ATOM    966  N   ARG A 148      17.098   7.872  33.070  1.00 28.97           N  
ATOM    967  CA  ARG A 148      18.354   8.413  32.578  1.00 29.46           C  
ATOM    968  C   ARG A 148      18.113   9.514  31.556  1.00 28.51           C  
ATOM    969  O   ARG A 148      18.723  10.579  31.630  1.00 28.43           O  
ATOM    970  CB  ARG A 148      19.193   7.304  31.947  1.00 32.75           C  
ATOM    971  CG  ARG A 148      19.742   6.296  32.936  1.00 38.94           C  
ATOM    972  CD  ARG A 148      20.878   6.907  33.746  1.00 44.74           C  
ATOM    973  NE  ARG A 148      21.872   7.521  32.861  1.00 50.53           N  
ATOM    974  CZ  ARG A 148      22.970   8.157  33.268  1.00 51.94           C  
ATOM    975  NH1 ARG A 148      23.236   8.273  34.564  1.00 53.03           N  
ATOM    976  NH2 ARG A 148      23.801   8.685  32.373  1.00 52.96           N  
ATOM    977  N   VAL A 149      17.224   9.263  30.598  1.00 26.06           N  
ATOM    978  CA  VAL A 149      16.943  10.259  29.571  1.00 23.61           C  
ATOM    979  C   VAL A 149      16.387  11.542  30.164  1.00 24.04           C  
ATOM    980  O   VAL A 149      16.802  12.638  29.796  1.00 24.01           O  
ATOM    981  CB  VAL A 149      15.949   9.730  28.509  1.00 21.93           C  
ATOM    982  CG1 VAL A 149      15.461  10.871  27.634  1.00 19.70           C  
ATOM    983  CG2 VAL A 149      16.628   8.691  27.644  1.00 19.72           C  
ATOM    984  N   PHE A 150      15.440  11.405  31.081  1.00 24.69           N  
ATOM    985  CA  PHE A 150      14.836  12.574  31.697  1.00 24.88           C  
ATOM    986  C   PHE A 150      15.879  13.399  32.438  1.00 25.43           C  
ATOM    987  O   PHE A 150      15.883  14.630  32.364  1.00 25.23           O  
ATOM    988  CB  PHE A 150      13.742  12.146  32.663  1.00 25.53           C  
ATOM    989  CG  PHE A 150      13.070  13.288  33.330  1.00 26.64           C  
ATOM    990  CD1 PHE A 150      12.500  14.306  32.573  1.00 28.42           C  
ATOM    991  CD2 PHE A 150      13.022  13.368  34.714  1.00 28.05           C  
ATOM    992  CE1 PHE A 150      11.890  15.402  33.182  1.00 29.46           C  
ATOM    993  CE2 PHE A 150      12.415  14.453  35.338  1.00 29.16           C  
ATOM    994  CZ  PHE A 150      11.846  15.477  34.567  1.00 29.67           C  
ATOM    995  N   ASP A 151      16.769  12.709  33.143  1.00 25.96           N  
ATOM    996  CA  ASP A 151      17.827  13.360  33.905  1.00 27.17           C  
ATOM    997  C   ASP A 151      18.789  14.118  32.989  1.00 26.66           C  
ATOM    998  O   ASP A 151      19.234  15.224  33.319  1.00 26.00           O  
ATOM    999  CB  ASP A 151      18.590  12.316  34.730  1.00 29.27           C  
ATOM   1000  CG  ASP A 151      19.705  12.930  35.577  1.00 32.87           C  
ATOM   1001  OD1 ASP A 151      19.419  13.850  36.376  1.00 33.75           O  
ATOM   1002  OD2 ASP A 151      20.870  12.487  35.449  1.00 34.39           O  
ATOM   1003  N   ASN A 152      19.110  13.534  31.837  1.00 25.99           N  
ATOM   1004  CA  ASN A 152      20.010  14.196  30.903  1.00 26.28           C  
ATOM   1005  C   ASN A 152      19.340  15.377  30.251  1.00 25.74           C  
ATOM   1006  O   ASN A 152      20.009  16.323  29.858  1.00 26.47           O  
ATOM   1007  CB  ASN A 152      20.515  13.223  29.846  1.00 27.04           C  
ATOM   1008  CG  ASN A 152      21.621  12.346  30.371  1.00 30.02           C  
ATOM   1009  OD1 ASN A 152      21.641  11.146  30.131  1.00 34.44           O  
ATOM   1010  ND2 ASN A 152      22.554  12.943  31.095  1.00 31.00           N  
ATOM   1011  N   ILE A 153      18.020  15.337  30.136  1.00 25.56           N  
ATOM   1012  CA  ILE A 153      17.307  16.460  29.544  1.00 26.24           C  
ATOM   1013  C   ILE A 153      17.296  17.594  30.565  1.00 27.58           C  
ATOM   1014  O   ILE A 153      17.507  18.754  30.226  1.00 28.22           O  
ATOM   1015  CB  ILE A 153      15.860  16.078  29.162  1.00 25.73           C  
ATOM   1016  CG1 ILE A 153      15.880  15.172  27.929  1.00 26.10           C  
ATOM   1017  CG2 ILE A 153      15.049  17.321  28.861  1.00 25.09           C  
ATOM   1018  CD1 ILE A 153      14.540  14.619  27.563  1.00 25.41           C  
ATOM   1019  N   GLN A 154      17.061  17.244  31.822  1.00 28.42           N  
ATOM   1020  CA  GLN A 154      17.037  18.228  32.895  1.00 29.54           C  
ATOM   1021  C   GLN A 154      18.392  18.927  33.041  1.00 29.20           C  
ATOM   1022  O   GLN A 154      18.451  20.132  33.254  1.00 28.32           O  
ATOM   1023  CB  GLN A 154      16.653  17.550  34.213  1.00 30.79           C  
ATOM   1024  CG  GLN A 154      15.197  17.720  34.605  1.00 32.94           C  
ATOM   1025  CD  GLN A 154      14.906  17.190  36.011  1.00 34.67           C  
ATOM   1026  OE1 GLN A 154      13.985  17.659  36.691  1.00 35.90           O  
ATOM   1027  NE2 GLN A 154      15.685  16.201  36.445  1.00 34.33           N  
ATOM   1028  N   ARG A 155      19.481  18.175  32.935  1.00 29.80           N  
ATOM   1029  CA  ARG A 155      20.800  18.779  33.045  1.00 31.78           C  
ATOM   1030  C   ARG A 155      21.295  19.274  31.698  1.00 33.41           C  
ATOM   1031  O   ARG A 155      22.483  19.571  31.530  1.00 33.73           O  
ATOM   1032  CB  ARG A 155      21.802  17.791  33.615  1.00 32.95           C  
ATOM   1033  CG  ARG A 155      21.627  17.551  35.093  1.00 36.08           C  
ATOM   1034  CD  ARG A 155      22.607  16.512  35.546  1.00 39.49           C  
ATOM   1035  NE  ARG A 155      22.584  15.387  34.626  1.00 43.32           N  
ATOM   1036  CZ  ARG A 155      23.246  14.253  34.809  1.00 46.35           C  
ATOM   1037  NH1 ARG A 155      23.993  14.088  35.895  1.00 47.51           N  
ATOM   1038  NH2 ARG A 155      23.165  13.287  33.899  1.00 47.19           N  
ATOM   1039  N   ARG A 156      20.373  19.340  30.741  1.00 34.49           N  
ATOM   1040  CA  ARG A 156      20.652  19.814  29.391  1.00 34.90           C  
ATOM   1041  C   ARG A 156      21.875  19.208  28.726  1.00 34.87           C  
ATOM   1042  O   ARG A 156      22.705  19.921  28.178  1.00 35.65           O  
ATOM   1043  CB  ARG A 156      20.757  21.328  29.435  1.00 35.42           C  
ATOM   1044  CG  ARG A 156      19.662  21.877  30.308  1.00 38.31           C  
ATOM   1045  CD  ARG A 156      19.602  23.359  30.354  1.00 40.55           C  
ATOM   1046  NE  ARG A 156      18.422  23.763  31.109  1.00 43.21           N  
ATOM   1047  CZ  ARG A 156      18.137  25.019  31.420  1.00 44.71           C  
ATOM   1048  NH1 ARG A 156      18.954  25.989  31.032  1.00 45.22           N  
ATOM   1049  NH2 ARG A 156      17.048  25.305  32.126  1.00 44.94           N  
ATOM   1050  N   ARG A 157      21.967  17.885  28.772  1.00 36.18           N  
ATOM   1051  CA  ARG A 157      23.070  17.150  28.166  1.00 38.82           C  
ATOM   1052  C   ARG A 157      22.829  17.033  26.667  1.00 38.49           C  
ATOM   1053  O   ARG A 157      23.735  16.705  25.895  1.00 37.25           O  
ATOM   1054  CB  ARG A 157      23.167  15.762  28.786  1.00 41.44           C  
ATOM   1055  CG  ARG A 157      23.642  15.776  30.219  1.00 46.34           C  
ATOM   1056  CD  ARG A 157      25.145  15.866  30.274  1.00 51.14           C  
ATOM   1057  NE  ARG A 157      25.650  15.680  31.630  1.00 55.91           N  
ATOM   1058  CZ  ARG A 157      26.805  15.085  31.920  1.00 58.75           C  
ATOM   1059  NH1 ARG A 157      27.579  14.607  30.942  1.00 59.71           N  
ATOM   1060  NH2 ARG A 157      27.192  14.969  33.188  1.00 60.22           N  
ATOM   1061  N   PHE A 158      21.585  17.280  26.272  1.00 38.99           N  
ATOM   1062  CA  PHE A 158      21.203  17.262  24.862  1.00 39.53           C  
ATOM   1063  C   PHE A 158      19.915  18.058  24.654  1.00 39.10           C  
ATOM   1064  O   PHE A 158      19.029  18.072  25.519  1.00 39.21           O  
ATOM   1065  CB  PHE A 158      21.079  15.816  24.327  1.00 39.90           C  
ATOM   1066  CG  PHE A 158      19.859  15.061  24.802  1.00 40.12           C  
ATOM   1067  CD1 PHE A 158      18.607  15.308  24.250  1.00 39.26           C  
ATOM   1068  CD2 PHE A 158      19.984  14.040  25.746  1.00 39.93           C  
ATOM   1069  CE1 PHE A 158      17.505  14.550  24.623  1.00 39.86           C  
ATOM   1070  CE2 PHE A 158      18.887  13.275  26.126  1.00 39.22           C  
ATOM   1071  CZ  PHE A 158      17.646  13.529  25.564  1.00 39.32           C  
ATOM   1072  N   ARG A 159      19.845  18.751  23.520  1.00 38.06           N  
ATOM   1073  CA  ARG A 159      18.688  19.568  23.186  1.00 37.91           C  
ATOM   1074  C   ARG A 159      17.573  18.701  22.613  1.00 34.64           C  
ATOM   1075  O   ARG A 159      17.824  17.654  22.033  1.00 33.11           O  
ATOM   1076  CB  ARG A 159      19.091  20.641  22.176  1.00 41.54           C  
ATOM   1077  CG  ARG A 159      20.273  21.493  22.611  1.00 47.12           C  
ATOM   1078  CD  ARG A 159      19.963  22.320  23.859  1.00 52.29           C  
ATOM   1079  NE  ARG A 159      21.067  23.226  24.197  1.00 58.07           N  
ATOM   1080  CZ  ARG A 159      21.442  24.277  23.463  1.00 60.13           C  
ATOM   1081  NH1 ARG A 159      20.801  24.576  22.333  1.00 60.81           N  
ATOM   1082  NH2 ARG A 159      22.472  25.026  23.852  1.00 60.81           N  
ATOM   1083  N   THR A 160      16.339  19.143  22.769  1.00 33.17           N  
ATOM   1084  CA  THR A 160      15.218  18.370  22.269  1.00 33.26           C  
ATOM   1085  C   THR A 160      14.456  19.082  21.154  1.00 32.99           C  
ATOM   1086  O   THR A 160      13.435  18.581  20.680  1.00 32.88           O  
ATOM   1087  CB  THR A 160      14.231  18.064  23.406  1.00 32.78           C  
ATOM   1088  OG1 THR A 160      13.646  19.286  23.875  1.00 33.13           O  
ATOM   1089  CG2 THR A 160      14.945  17.381  24.552  1.00 32.55           C  
ATOM   1090  N   ASP A 161      14.957  20.237  20.724  1.00 33.74           N  
ATOM   1091  CA  ASP A 161      14.270  21.021  19.701  1.00 33.94           C  
ATOM   1092  C   ASP A 161      14.236  20.424  18.302  1.00 32.45           C  
ATOM   1093  O   ASP A 161      13.364  20.767  17.514  1.00 32.14           O  
ATOM   1094  CB  ASP A 161      14.829  22.457  19.654  1.00 37.24           C  
ATOM   1095  CG  ASP A 161      16.301  22.516  19.292  1.00 39.76           C  
ATOM   1096  OD1 ASP A 161      17.141  22.022  20.075  1.00 42.20           O  
ATOM   1097  OD2 ASP A 161      16.617  23.068  18.215  1.00 42.61           O  
ATOM   1098  N   LYS A 162      15.167  19.529  17.997  1.00 30.68           N  
ATOM   1099  CA  LYS A 162      15.197  18.893  16.685  1.00 29.91           C  
ATOM   1100  C   LYS A 162      14.538  17.510  16.687  1.00 27.93           C  
ATOM   1101  O   LYS A 162      14.479  16.846  15.658  1.00 25.91           O  
ATOM   1102  CB  LYS A 162      16.639  18.755  16.204  1.00 32.23           C  
ATOM   1103  CG  LYS A 162      17.387  20.063  16.126  1.00 36.21           C  
ATOM   1104  CD  LYS A 162      16.714  21.003  15.150  1.00 39.99           C  
ATOM   1105  CE  LYS A 162      17.512  22.282  14.986  1.00 42.79           C  
ATOM   1106  NZ  LYS A 162      18.849  21.987  14.406  1.00 45.51           N  
ATOM   1107  N   ILE A 163      14.040  17.076  17.838  1.00 26.70           N  
ATOM   1108  CA  ILE A 163      13.417  15.759  17.925  1.00 26.27           C  
ATOM   1109  C   ILE A 163      12.121  15.678  17.137  1.00 25.40           C  
ATOM   1110  O   ILE A 163      11.170  16.396  17.427  1.00 26.93           O  
ATOM   1111  CB  ILE A 163      13.178  15.364  19.393  1.00 26.81           C  
ATOM   1112  CG1 ILE A 163      14.532  15.076  20.044  1.00 27.06           C  
ATOM   1113  CG2 ILE A 163      12.262  14.135  19.476  1.00 26.45           C  
ATOM   1114  CD1 ILE A 163      14.466  14.736  21.503  1.00 29.68           C  
ATOM   1115  N   LYS A 164      12.088  14.795  16.144  1.00 23.99           N  
ATOM   1116  CA  LYS A 164      10.907  14.648  15.303  1.00 24.22           C  
ATOM   1117  C   LYS A 164      10.141  13.351  15.564  1.00 23.39           C  
ATOM   1118  O   LYS A 164       8.976  13.229  15.184  1.00 22.81           O  
ATOM   1119  CB  LYS A 164      11.304  14.738  13.828  1.00 24.24           C  
ATOM   1120  CG  LYS A 164      12.208  13.623  13.381  1.00 30.03           C  
ATOM   1121  CD  LYS A 164      12.594  13.723  11.899  1.00 33.39           C  
ATOM   1122  CE  LYS A 164      13.710  14.726  11.658  1.00 34.88           C  
ATOM   1123  NZ  LYS A 164      14.182  14.669  10.243  1.00 35.92           N  
ATOM   1124  N   MET A 165      10.786  12.398  16.231  1.00 22.28           N  
ATOM   1125  CA  MET A 165      10.163  11.113  16.530  1.00 22.76           C  
ATOM   1126  C   MET A 165      10.381  10.686  17.972  1.00 21.41           C  
ATOM   1127  O   MET A 165      11.495  10.747  18.471  1.00 20.82           O  
ATOM   1128  CB  MET A 165      10.745  10.028  15.628  1.00 26.14           C  
ATOM   1129  CG  MET A 165       9.783   9.482  14.609  1.00 30.40           C  
ATOM   1130  SD  MET A 165      10.630   8.307  13.565  1.00 35.74           S  
ATOM   1131  CE  MET A 165      11.802   9.414  12.765  1.00 31.40           C  
ATOM   1132  N   PHE A 166       9.317  10.233  18.623  1.00 20.25           N  
ATOM   1133  CA  PHE A 166       9.392   9.768  20.012  1.00 20.29           C  
ATOM   1134  C   PHE A 166       8.845   8.338  20.045  1.00 19.68           C  
ATOM   1135  O   PHE A 166       7.635   8.130  19.926  1.00 19.68           O  
ATOM   1136  CB  PHE A 166       8.562  10.692  20.912  1.00 20.19           C  
ATOM   1137  CG  PHE A 166       8.671  10.388  22.381  1.00 22.08           C  
ATOM   1138  CD1 PHE A 166       9.876   9.986  22.940  1.00 23.38           C  
ATOM   1139  CD2 PHE A 166       7.567  10.550  23.218  1.00 23.12           C  
ATOM   1140  CE1 PHE A 166       9.979   9.748  24.313  1.00 25.14           C  
ATOM   1141  CE2 PHE A 166       7.658  10.318  24.590  1.00 22.80           C  
ATOM   1142  CZ  PHE A 166       8.864   9.917  25.136  1.00 24.60           C  
ATOM   1143  N   ILE A 167       9.747   7.363  20.192  1.00 19.25           N  
ATOM   1144  CA  ILE A 167       9.385   5.947  20.207  1.00 19.74           C  
ATOM   1145  C   ILE A 167       9.431   5.318  21.594  1.00 20.78           C  
ATOM   1146  O   ILE A 167      10.443   5.393  22.279  1.00 20.76           O  
ATOM   1147  CB  ILE A 167      10.314   5.150  19.280  1.00 18.03           C  
ATOM   1148  CG1 ILE A 167      10.297   5.786  17.886  1.00 19.03           C  
ATOM   1149  CG2 ILE A 167       9.848   3.709  19.181  1.00 17.59           C  
ATOM   1150  CD1 ILE A 167      11.430   5.339  16.989  1.00 21.39           C  
ATOM   1151  N   LEU A 168       8.318   4.708  21.998  1.00 21.62           N  
ATOM   1152  CA  LEU A 168       8.210   4.035  23.291  1.00 23.07           C  
ATOM   1153  C   LEU A 168       8.118   2.533  23.046  1.00 23.34           C  
ATOM   1154  O   LEU A 168       7.063   2.006  22.703  1.00 22.34           O  
ATOM   1155  CB  LEU A 168       6.958   4.501  24.048  1.00 24.95           C  
ATOM   1156  CG  LEU A 168       6.964   5.854  24.771  1.00 26.50           C  
ATOM   1157  CD1 LEU A 168       7.517   6.920  23.880  1.00 28.55           C  
ATOM   1158  CD2 LEU A 168       5.553   6.213  25.183  1.00 27.66           C  
ATOM   1159  N   ASP A 169       9.227   1.843  23.221  1.00 24.37           N  
ATOM   1160  CA  ASP A 169       9.235   0.414  23.015  1.00 27.77           C  
ATOM   1161  C   ASP A 169       8.812  -0.281  24.311  1.00 29.08           C  
ATOM   1162  O   ASP A 169       9.312   0.035  25.386  1.00 28.98           O  
ATOM   1163  CB  ASP A 169      10.629  -0.027  22.575  1.00 27.70           C  
ATOM   1164  CG  ASP A 169      10.667  -1.462  22.094  1.00 29.06           C  
ATOM   1165  OD1 ASP A 169       9.621  -1.962  21.626  1.00 28.77           O  
ATOM   1166  OD2 ASP A 169      11.750  -2.085  22.165  1.00 30.20           O  
ATOM   1167  N   GLU A 170       7.873  -1.215  24.188  1.00 30.93           N  
ATOM   1168  CA  GLU A 170       7.351  -1.966  25.320  1.00 32.62           C  
ATOM   1169  C   GLU A 170       6.748  -1.009  26.317  1.00 32.53           C  
ATOM   1170  O   GLU A 170       7.147  -0.979  27.476  1.00 32.14           O  
ATOM   1171  CB  GLU A 170       8.465  -2.769  25.982  1.00 34.70           C  
ATOM   1172  CG  GLU A 170       9.191  -3.666  25.014  1.00 39.03           C  
ATOM   1173  CD  GLU A 170       9.464  -5.031  25.591  1.00 42.74           C  
ATOM   1174  OE1 GLU A 170      10.172  -5.120  26.625  1.00 44.01           O  
ATOM   1175  OE2 GLU A 170       8.960  -6.017  25.005  1.00 46.51           O  
ATOM   1176  N   ALA A 171       5.777  -0.229  25.856  1.00 33.11           N  
ATOM   1177  CA  ALA A 171       5.118   0.762  26.695  1.00 34.48           C  
ATOM   1178  C   ALA A 171       4.479   0.158  27.943  1.00 35.37           C  
ATOM   1179  O   ALA A 171       4.586   0.733  29.034  1.00 35.85           O  
ATOM   1180  CB  ALA A 171       4.067   1.533  25.881  1.00 32.60           C  
ATOM   1181  N   ASP A 172       3.817  -0.987  27.791  1.00 36.33           N  
ATOM   1182  CA  ASP A 172       3.174  -1.636  28.930  1.00 37.76           C  
ATOM   1183  C   ASP A 172       4.185  -1.952  30.030  1.00 38.19           C  
ATOM   1184  O   ASP A 172       3.863  -1.863  31.213  1.00 38.49           O  
ATOM   1185  CB  ASP A 172       2.433  -2.907  28.482  1.00 38.15           C  
ATOM   1186  CG  ASP A 172       3.347  -3.939  27.833  1.00 38.44           C  
ATOM   1187  OD1 ASP A 172       4.466  -3.588  27.406  1.00 37.96           O  
ATOM   1188  OD2 ASP A 172       2.926  -5.115  27.733  1.00 39.88           O  
ATOM   1189  N   GLU A 173       5.407  -2.309  29.634  1.00 39.44           N  
ATOM   1190  CA  GLU A 173       6.487  -2.620  30.578  1.00 40.95           C  
ATOM   1191  C   GLU A 173       6.887  -1.374  31.350  1.00 40.72           C  
ATOM   1192  O   GLU A 173       6.980  -1.393  32.573  1.00 41.09           O  
ATOM   1193  CB  GLU A 173       7.736  -3.112  29.844  1.00 43.06           C  
ATOM   1194  CG  GLU A 173       7.659  -4.496  29.265  1.00 47.76           C  
ATOM   1195  CD  GLU A 173       7.635  -5.557  30.336  1.00 50.54           C  
ATOM   1196  OE1 GLU A 173       6.536  -5.859  30.856  1.00 51.92           O  
ATOM   1197  OE2 GLU A 173       8.723  -6.077  30.668  1.00 52.86           O  
ATOM   1198  N   MET A 174       7.128  -0.293  30.614  1.00 40.52           N  
ATOM   1199  CA  MET A 174       7.550   0.976  31.193  1.00 40.69           C  
ATOM   1200  C   MET A 174       6.562   1.637  32.136  1.00 41.45           C  
ATOM   1201  O   MET A 174       6.945   2.127  33.197  1.00 40.70           O  
ATOM   1202  CB  MET A 174       7.917   1.953  30.081  1.00 39.04           C  
ATOM   1203  CG  MET A 174       9.132   1.527  29.302  1.00 38.76           C  
ATOM   1204  SD  MET A 174       9.706   2.836  28.233  1.00 38.44           S  
ATOM   1205  CE  MET A 174       8.690   2.542  26.827  1.00 39.79           C  
ATOM   1206  N   LEU A 175       5.295   1.671  31.753  1.00 43.26           N  
ATOM   1207  CA  LEU A 175       4.295   2.301  32.602  1.00 46.20           C  
ATOM   1208  C   LEU A 175       4.046   1.496  33.873  1.00 47.71           C  
ATOM   1209  O   LEU A 175       3.604   2.044  34.881  1.00 48.09           O  
ATOM   1210  CB  LEU A 175       2.997   2.485  31.825  1.00 46.25           C  
ATOM   1211  CG  LEU A 175       3.212   3.349  30.580  1.00 47.14           C  
ATOM   1212  CD1 LEU A 175       1.957   3.356  29.733  1.00 46.95           C  
ATOM   1213  CD2 LEU A 175       3.602   4.756  31.001  1.00 46.92           C  
ATOM   1214  N   SER A 176       4.351   0.202  33.834  1.00 48.97           N  
ATOM   1215  CA  SER A 176       4.143  -0.658  34.995  1.00 49.58           C  
ATOM   1216  C   SER A 176       5.324  -0.597  35.952  1.00 50.08           C  
ATOM   1217  O   SER A 176       5.212  -1.012  37.102  1.00 51.37           O  
ATOM   1218  CB  SER A 176       3.909  -2.114  34.560  1.00 49.76           C  
ATOM   1219  OG  SER A 176       5.116  -2.745  34.166  1.00 50.24           O  
ATOM   1220  N   SER A 177       6.454  -0.079  35.482  1.00 49.64           N  
ATOM   1221  CA  SER A 177       7.647   0.025  36.313  1.00 48.46           C  
ATOM   1222  C   SER A 177       7.787   1.407  36.922  1.00 47.93           C  
ATOM   1223  O   SER A 177       8.881   1.816  37.302  1.00 48.13           O  
ATOM   1224  CB  SER A 177       8.898  -0.299  35.497  1.00 48.68           C  
ATOM   1225  OG  SER A 177       8.859  -1.637  35.039  1.00 49.44           O  
ATOM   1226  N   GLY A 178       6.680   2.134  36.985  1.00 47.32           N  
ATOM   1227  CA  GLY A 178       6.705   3.454  37.587  1.00 47.25           C  
ATOM   1228  C   GLY A 178       7.294   4.591  36.776  1.00 46.88           C  
ATOM   1229  O   GLY A 178       7.524   5.683  37.309  1.00 47.21           O  
ATOM   1230  N   PHE A 179       7.535   4.363  35.493  1.00 45.46           N  
ATOM   1231  CA  PHE A 179       8.095   5.419  34.667  1.00 43.99           C  
ATOM   1232  C   PHE A 179       7.026   6.359  34.122  1.00 42.81           C  
ATOM   1233  O   PHE A 179       7.347   7.377  33.511  1.00 42.71           O  
ATOM   1234  CB  PHE A 179       8.892   4.822  33.507  1.00 44.27           C  
ATOM   1235  CG  PHE A 179      10.188   4.193  33.923  1.00 45.55           C  
ATOM   1236  CD1 PHE A 179      10.345   2.815  33.903  1.00 46.38           C  
ATOM   1237  CD2 PHE A 179      11.265   4.985  34.312  1.00 46.53           C  
ATOM   1238  CE1 PHE A 179      11.560   2.234  34.261  1.00 47.21           C  
ATOM   1239  CE2 PHE A 179      12.486   4.418  34.673  1.00 46.71           C  
ATOM   1240  CZ  PHE A 179      12.635   3.041  34.646  1.00 47.35           C  
ATOM   1241  N   LYS A 180       5.758   6.037  34.357  1.00 40.92           N  
ATOM   1242  CA  LYS A 180       4.682   6.858  33.832  1.00 41.49           C  
ATOM   1243  C   LYS A 180       4.887   8.352  33.949  1.00 40.88           C  
ATOM   1244  O   LYS A 180       4.710   9.077  32.974  1.00 41.09           O  
ATOM   1245  CB  LYS A 180       3.351   6.508  34.486  1.00 43.41           C  
ATOM   1246  CG  LYS A 180       2.246   7.473  34.090  1.00 45.58           C  
ATOM   1247  CD  LYS A 180       0.895   7.023  34.591  1.00 47.99           C  
ATOM   1248  CE  LYS A 180      -0.164   8.039  34.209  1.00 49.61           C  
ATOM   1249  NZ  LYS A 180      -1.545   7.489  34.339  1.00 51.12           N  
ATOM   1250  N   GLU A 181       5.245   8.817  35.143  1.00 40.68           N  
ATOM   1251  CA  GLU A 181       5.441  10.249  35.362  1.00 39.20           C  
ATOM   1252  C   GLU A 181       6.610  10.829  34.580  1.00 36.63           C  
ATOM   1253  O   GLU A 181       6.497  11.912  34.016  1.00 36.23           O  
ATOM   1254  CB  GLU A 181       5.602  10.536  36.856  1.00 41.38           C  
ATOM   1255  CG  GLU A 181       4.410  10.075  37.679  1.00 45.55           C  
ATOM   1256  CD  GLU A 181       3.090  10.650  37.179  1.00 48.84           C  
ATOM   1257  OE1 GLU A 181       2.023  10.148  37.598  1.00 51.93           O  
ATOM   1258  OE2 GLU A 181       3.109  11.608  36.370  1.00 50.35           O  
ATOM   1259  N   GLN A 182       7.729  10.114  34.541  1.00 35.03           N  
ATOM   1260  CA  GLN A 182       8.890  10.591  33.795  1.00 34.36           C  
ATOM   1261  C   GLN A 182       8.515  10.744  32.324  1.00 32.90           C  
ATOM   1262  O   GLN A 182       8.858  11.731  31.681  1.00 32.08           O  
ATOM   1263  CB  GLN A 182      10.064   9.609  33.917  1.00 35.75           C  
ATOM   1264  CG  GLN A 182      10.802   9.640  35.255  1.00 40.03           C  
ATOM   1265  CD  GLN A 182       9.903   9.319  36.442  1.00 44.01           C  
ATOM   1266  OE1 GLN A 182       9.073   8.402  36.385  1.00 45.21           O  
ATOM   1267  NE2 GLN A 182      10.070  10.070  37.535  1.00 45.16           N  
ATOM   1268  N   ILE A 183       7.792   9.760  31.800  1.00 31.41           N  
ATOM   1269  CA  ILE A 183       7.383   9.785  30.406  1.00 30.15           C  
ATOM   1270  C   ILE A 183       6.466  10.960  30.103  1.00 30.11           C  
ATOM   1271  O   ILE A 183       6.642  11.622  29.088  1.00 29.59           O  
ATOM   1272  CB  ILE A 183       6.696   8.460  30.005  1.00 28.74           C  
ATOM   1273  CG1 ILE A 183       7.674   7.300  30.184  1.00 27.18           C  
ATOM   1274  CG2 ILE A 183       6.255   8.519  28.555  1.00 28.49           C  
ATOM   1275  CD1 ILE A 183       7.064   5.947  29.948  1.00 28.77           C  
ATOM   1276  N   TYR A 184       5.499  11.221  30.980  1.00 31.30           N  
ATOM   1277  CA  TYR A 184       4.574  12.333  30.787  1.00 32.22           C  
ATOM   1278  C   TYR A 184       5.347  13.628  30.730  1.00 32.26           C  
ATOM   1279  O   TYR A 184       5.010  14.529  29.966  1.00 32.29           O  
ATOM   1280  CB  TYR A 184       3.584  12.429  31.942  1.00 36.55           C  
ATOM   1281  CG  TYR A 184       2.363  11.559  31.795  1.00 41.31           C  
ATOM   1282  CD1 TYR A 184       2.478  10.183  31.637  1.00 43.92           C  
ATOM   1283  CD2 TYR A 184       1.086  12.112  31.819  1.00 43.45           C  
ATOM   1284  CE1 TYR A 184       1.354   9.375  31.506  1.00 45.64           C  
ATOM   1285  CE2 TYR A 184      -0.048  11.317  31.689  1.00 45.57           C  
ATOM   1286  CZ  TYR A 184       0.096   9.949  31.532  1.00 46.51           C  
ATOM   1287  OH  TYR A 184      -1.016   9.148  31.409  1.00 48.72           O  
ATOM   1288  N   GLN A 185       6.380  13.723  31.559  1.00 31.53           N  
ATOM   1289  CA  GLN A 185       7.204  14.922  31.620  1.00 31.38           C  
ATOM   1290  C   GLN A 185       8.078  15.081  30.390  1.00 30.20           C  
ATOM   1291  O   GLN A 185       8.278  16.184  29.889  1.00 29.69           O  
ATOM   1292  CB  GLN A 185       8.081  14.881  32.861  1.00 32.99           C  
ATOM   1293  CG  GLN A 185       7.297  14.665  34.127  1.00 35.69           C  
ATOM   1294  CD  GLN A 185       8.124  14.933  35.348  1.00 37.29           C  
ATOM   1295  OE1 GLN A 185       8.427  16.084  35.655  1.00 39.91           O  
ATOM   1296  NE2 GLN A 185       8.516  13.874  36.048  1.00 38.37           N  
ATOM   1297  N   ILE A 186       8.627  13.976  29.913  1.00 29.32           N  
ATOM   1298  CA  ILE A 186       9.452  14.047  28.726  1.00 28.04           C  
ATOM   1299  C   ILE A 186       8.553  14.557  27.591  1.00 28.74           C  
ATOM   1300  O   ILE A 186       8.926  15.481  26.872  1.00 28.09           O  
ATOM   1301  CB  ILE A 186      10.064  12.661  28.420  1.00 25.51           C  
ATOM   1302  CG1 ILE A 186      11.105  12.339  29.492  1.00 22.77           C  
ATOM   1303  CG2 ILE A 186      10.693  12.636  27.032  1.00 23.83           C  
ATOM   1304  CD1 ILE A 186      11.742  10.979  29.343  1.00 23.54           C  
ATOM   1305  N   PHE A 187       7.358  13.980  27.465  1.00 29.85           N  
ATOM   1306  CA  PHE A 187       6.406  14.392  26.433  1.00 32.27           C  
ATOM   1307  C   PHE A 187       6.270  15.906  26.374  1.00 33.54           C  
ATOM   1308  O   PHE A 187       6.418  16.509  25.312  1.00 33.92           O  
ATOM   1309  CB  PHE A 187       5.012  13.820  26.703  1.00 34.31           C  
ATOM   1310  CG  PHE A 187       4.765  12.458  26.100  1.00 37.43           C  
ATOM   1311  CD1 PHE A 187       4.622  11.334  26.913  1.00 38.06           C  
ATOM   1312  CD2 PHE A 187       4.617  12.308  24.722  1.00 38.52           C  
ATOM   1313  CE1 PHE A 187       4.331  10.082  26.363  1.00 38.64           C  
ATOM   1314  CE2 PHE A 187       4.326  11.057  24.162  1.00 38.43           C  
ATOM   1315  CZ  PHE A 187       4.183   9.945  24.986  1.00 39.20           C  
ATOM   1316  N   THR A 188       5.978  16.517  27.518  1.00 34.92           N  
ATOM   1317  CA  THR A 188       5.797  17.964  27.592  1.00 35.06           C  
ATOM   1318  C   THR A 188       7.053  18.753  27.181  1.00 35.53           C  
ATOM   1319  O   THR A 188       6.953  19.859  26.645  1.00 36.12           O  
ATOM   1320  CB  THR A 188       5.335  18.387  29.023  1.00 35.42           C  
ATOM   1321  OG1 THR A 188       6.355  18.074  29.975  1.00 36.37           O  
ATOM   1322  CG2 THR A 188       4.065  17.635  29.421  1.00 34.23           C  
ATOM   1323  N   LEU A 189       8.229  18.173  27.406  1.00 35.55           N  
ATOM   1324  CA  LEU A 189       9.491  18.826  27.066  1.00 35.19           C  
ATOM   1325  C   LEU A 189       9.866  18.720  25.586  1.00 35.04           C  
ATOM   1326  O   LEU A 189      10.829  19.358  25.134  1.00 35.48           O  
ATOM   1327  CB  LEU A 189      10.628  18.232  27.902  1.00 35.81           C  
ATOM   1328  CG  LEU A 189      10.602  18.527  29.399  1.00 36.43           C  
ATOM   1329  CD1 LEU A 189      11.614  17.646  30.107  1.00 36.24           C  
ATOM   1330  CD2 LEU A 189      10.890  20.001  29.627  1.00 35.74           C  
ATOM   1331  N   LEU A 190       9.124  17.909  24.836  1.00 33.04           N  
ATOM   1332  CA  LEU A 190       9.416  17.729  23.418  1.00 30.42           C  
ATOM   1333  C   LEU A 190       8.567  18.650  22.564  1.00 29.66           C  
ATOM   1334  O   LEU A 190       7.501  19.102  22.991  1.00 30.33           O  
ATOM   1335  CB  LEU A 190       9.149  16.285  22.996  1.00 29.72           C  
ATOM   1336  CG  LEU A 190       9.920  15.163  23.688  1.00 29.14           C  
ATOM   1337  CD1 LEU A 190       9.526  13.829  23.068  1.00 28.29           C  
ATOM   1338  CD2 LEU A 190      11.410  15.400  23.541  1.00 29.07           C  
ATOM   1339  N   PRO A 191       9.025  18.938  21.339  1.00 28.34           N  
ATOM   1340  CA  PRO A 191       8.266  19.815  20.445  1.00 28.12           C  
ATOM   1341  C   PRO A 191       6.821  19.332  20.362  1.00 29.62           C  
ATOM   1342  O   PRO A 191       6.560  18.136  20.332  1.00 29.04           O  
ATOM   1343  CB  PRO A 191       9.009  19.676  19.122  1.00 27.85           C  
ATOM   1344  CG  PRO A 191      10.419  19.441  19.551  1.00 26.51           C  
ATOM   1345  CD  PRO A 191      10.266  18.469  20.696  1.00 26.81           C  
ATOM   1346  N   PRO A 192       5.865  20.262  20.309  1.00 31.31           N  
ATOM   1347  CA  PRO A 192       4.454  19.888  20.239  1.00 32.64           C  
ATOM   1348  C   PRO A 192       4.113  19.120  18.975  1.00 33.55           C  
ATOM   1349  O   PRO A 192       3.048  18.509  18.876  1.00 33.98           O  
ATOM   1350  CB  PRO A 192       3.751  21.234  20.305  1.00 33.03           C  
ATOM   1351  CG  PRO A 192       4.687  22.108  19.524  1.00 32.84           C  
ATOM   1352  CD  PRO A 192       6.035  21.708  20.077  1.00 32.47           C  
ATOM   1353  N   THR A 193       5.026  19.150  18.013  1.00 33.03           N  
ATOM   1354  CA  THR A 193       4.827  18.476  16.739  1.00 33.51           C  
ATOM   1355  C   THR A 193       5.525  17.110  16.606  1.00 31.59           C  
ATOM   1356  O   THR A 193       5.648  16.573  15.504  1.00 32.04           O  
ATOM   1357  CB  THR A 193       5.319  19.371  15.587  1.00 35.60           C  
ATOM   1358  OG1 THR A 193       6.733  19.576  15.719  1.00 37.55           O  
ATOM   1359  CG2 THR A 193       4.610  20.725  15.623  1.00 37.39           C  
ATOM   1360  N   THR A 194       5.976  16.541  17.715  1.00 28.78           N  
ATOM   1361  CA  THR A 194       6.667  15.263  17.662  1.00 25.64           C  
ATOM   1362  C   THR A 194       5.758  14.092  17.340  1.00 23.24           C  
ATOM   1363  O   THR A 194       4.668  13.961  17.893  1.00 23.09           O  
ATOM   1364  CB  THR A 194       7.375  14.959  18.986  1.00 25.13           C  
ATOM   1365  OG1 THR A 194       8.260  16.039  19.299  1.00 27.36           O  
ATOM   1366  CG2 THR A 194       8.189  13.670  18.878  1.00 24.14           C  
ATOM   1367  N   GLN A 195       6.219  13.237  16.436  1.00 21.10           N  
ATOM   1368  CA  GLN A 195       5.461  12.053  16.066  1.00 19.63           C  
ATOM   1369  C   GLN A 195       5.666  11.041  17.195  1.00 19.50           C  
ATOM   1370  O   GLN A 195       6.782  10.875  17.702  1.00 18.49           O  
ATOM   1371  CB  GLN A 195       5.979  11.493  14.736  1.00 18.80           C  
ATOM   1372  CG  GLN A 195       5.290  10.224  14.277  1.00 18.99           C  
ATOM   1373  CD  GLN A 195       5.899   9.668  13.018  1.00 20.53           C  
ATOM   1374  OE1 GLN A 195       5.412   8.681  12.477  1.00 22.40           O  
ATOM   1375  NE2 GLN A 195       6.973  10.294  12.539  1.00 18.76           N  
ATOM   1376  N   VAL A 196       4.593  10.373  17.602  1.00 18.89           N  
ATOM   1377  CA  VAL A 196       4.695   9.401  18.679  1.00 18.40           C  
ATOM   1378  C   VAL A 196       4.431   7.986  18.185  1.00 19.06           C  
ATOM   1379  O   VAL A 196       3.415   7.718  17.533  1.00 19.12           O  
ATOM   1380  CB  VAL A 196       3.688   9.723  19.803  1.00 19.18           C  
ATOM   1381  CG1 VAL A 196       3.796   8.694  20.937  1.00 20.18           C  
ATOM   1382  CG2 VAL A 196       3.937  11.122  20.312  1.00 19.65           C  
ATOM   1383  N   VAL A 197       5.357   7.087  18.499  1.00 18.65           N  
ATOM   1384  CA  VAL A 197       5.232   5.690  18.126  1.00 19.36           C  
ATOM   1385  C   VAL A 197       5.306   4.859  19.399  1.00 20.88           C  
ATOM   1386  O   VAL A 197       6.317   4.848  20.103  1.00 20.45           O  
ATOM   1387  CB  VAL A 197       6.354   5.257  17.181  1.00 18.94           C  
ATOM   1388  CG1 VAL A 197       6.263   3.770  16.918  1.00 19.31           C  
ATOM   1389  CG2 VAL A 197       6.258   6.035  15.887  1.00 18.35           C  
ATOM   1390  N   LEU A 198       4.223   4.153  19.682  1.00 21.34           N  
ATOM   1391  CA  LEU A 198       4.158   3.344  20.874  1.00 23.27           C  
ATOM   1392  C   LEU A 198       3.960   1.867  20.521  1.00 24.11           C  
ATOM   1393  O   LEU A 198       3.034   1.514  19.792  1.00 24.43           O  
ATOM   1394  CB  LEU A 198       3.011   3.865  21.752  1.00 23.90           C  
ATOM   1395  CG  LEU A 198       2.811   3.299  23.156  1.00 25.77           C  
ATOM   1396  CD1 LEU A 198       1.883   4.197  23.951  1.00 25.79           C  
ATOM   1397  CD2 LEU A 198       2.233   1.894  23.055  1.00 27.39           C  
ATOM   1398  N   LEU A 199       4.842   1.014  21.032  1.00 25.14           N  
ATOM   1399  CA  LEU A 199       4.753  -0.426  20.803  1.00 28.10           C  
ATOM   1400  C   LEU A 199       4.581  -1.117  22.141  1.00 29.80           C  
ATOM   1401  O   LEU A 199       5.327  -0.858  23.092  1.00 29.49           O  
ATOM   1402  CB  LEU A 199       6.006  -0.961  20.122  1.00 27.02           C  
ATOM   1403  CG  LEU A 199       6.275  -0.330  18.765  1.00 28.09           C  
ATOM   1404  CD1 LEU A 199       7.280   0.813  18.933  1.00 27.81           C  
ATOM   1405  CD2 LEU A 199       6.803  -1.387  17.810  1.00 28.70           C  
ATOM   1406  N   SER A 200       3.592  -1.997  22.213  1.00 32.49           N  
ATOM   1407  CA  SER A 200       3.317  -2.710  23.453  1.00 35.55           C  
ATOM   1408  C   SER A 200       2.787  -4.098  23.128  1.00 37.13           C  
ATOM   1409  O   SER A 200       2.090  -4.281  22.130  1.00 37.98           O  
ATOM   1410  CB  SER A 200       2.278  -1.931  24.268  1.00 35.39           C  
ATOM   1411  OG  SER A 200       2.167  -2.424  25.591  1.00 37.42           O  
ATOM   1412  N   ALA A 201       3.126  -5.078  23.958  1.00 37.36           N  
ATOM   1413  CA  ALA A 201       2.638  -6.430  23.738  1.00 38.24           C  
ATOM   1414  C   ALA A 201       1.190  -6.517  24.230  1.00 38.60           C  
ATOM   1415  O   ALA A 201       0.327  -7.099  23.570  1.00 38.24           O  
ATOM   1416  CB  ALA A 201       3.511  -7.423  24.481  1.00 38.89           C  
ATOM   1417  N   THR A 202       0.932  -5.924  25.390  1.00 39.07           N  
ATOM   1418  CA  THR A 202      -0.399  -5.926  25.977  1.00 40.30           C  
ATOM   1419  C   THR A 202      -1.014  -4.546  25.836  1.00 42.25           C  
ATOM   1420  O   THR A 202      -0.340  -3.590  25.460  1.00 41.62           O  
ATOM   1421  CB  THR A 202      -0.363  -6.291  27.489  1.00 39.49           C  
ATOM   1422  OG1 THR A 202       0.377  -5.300  28.214  1.00 37.28           O  
ATOM   1423  CG2 THR A 202       0.289  -7.635  27.694  1.00 38.94           C  
ATOM   1424  N   MET A 203      -2.297  -4.444  26.152  1.00 45.13           N  
ATOM   1425  CA  MET A 203      -2.996  -3.171  26.069  1.00 48.50           C  
ATOM   1426  C   MET A 203      -3.634  -2.725  27.397  1.00 50.45           C  
ATOM   1427  O   MET A 203      -4.840  -2.464  27.462  1.00 50.58           O  
ATOM   1428  CB  MET A 203      -4.061  -3.243  24.975  1.00 49.68           C  
ATOM   1429  CG  MET A 203      -3.513  -3.047  23.573  1.00 51.58           C  
ATOM   1430  SD  MET A 203      -2.839  -1.376  23.353  1.00 53.70           S  
ATOM   1431  CE  MET A 203      -1.299  -1.720  22.460  1.00 53.10           C  
ATOM   1432  N   PRO A 204      -2.828  -2.628  28.473  1.00 51.58           N  
ATOM   1433  CA  PRO A 204      -3.364  -2.206  29.771  1.00 52.81           C  
ATOM   1434  C   PRO A 204      -4.104  -0.877  29.633  1.00 54.04           C  
ATOM   1435  O   PRO A 204      -3.770  -0.068  28.768  1.00 53.81           O  
ATOM   1436  CB  PRO A 204      -2.108  -2.079  30.630  1.00 53.02           C  
ATOM   1437  CG  PRO A 204      -1.194  -3.116  30.044  1.00 52.69           C  
ATOM   1438  CD  PRO A 204      -1.383  -2.909  28.568  1.00 52.03           C  
ATOM   1439  N   ASN A 205      -5.104  -0.645  30.478  1.00 55.89           N  
ATOM   1440  CA  ASN A 205      -5.861   0.606  30.412  1.00 58.15           C  
ATOM   1441  C   ASN A 205      -4.908   1.798  30.434  1.00 57.92           C  
ATOM   1442  O   ASN A 205      -5.203   2.870  29.897  1.00 57.59           O  
ATOM   1443  CB  ASN A 205      -6.827   0.728  31.597  1.00 60.32           C  
ATOM   1444  CG  ASN A 205      -7.884  -0.359  31.609  1.00 63.16           C  
ATOM   1445  OD1 ASN A 205      -8.622  -0.545  30.633  1.00 64.53           O  
ATOM   1446  ND2 ASN A 205      -7.971  -1.084  32.723  1.00 64.71           N  
ATOM   1447  N   ASP A 206      -3.760   1.594  31.066  1.00 57.60           N  
ATOM   1448  CA  ASP A 206      -2.755   2.634  31.183  1.00 56.91           C  
ATOM   1449  C   ASP A 206      -2.153   2.978  29.834  1.00 55.39           C  
ATOM   1450  O   ASP A 206      -1.879   4.144  29.549  1.00 55.43           O  
ATOM   1451  CB  ASP A 206      -1.656   2.181  32.140  1.00 59.32           C  
ATOM   1452  CG  ASP A 206      -1.419   3.175  33.252  1.00 61.71           C  
ATOM   1453  OD1 ASP A 206      -0.619   2.863  34.161  1.00 62.26           O  
ATOM   1454  OD2 ASP A 206      -2.035   4.270  33.213  1.00 63.23           O  
ATOM   1455  N   VAL A 207      -1.941   1.960  29.005  1.00 53.46           N  
ATOM   1456  CA  VAL A 207      -1.378   2.174  27.685  1.00 51.00           C  
ATOM   1457  C   VAL A 207      -2.367   2.968  26.846  1.00 49.92           C  
ATOM   1458  O   VAL A 207      -1.980   3.923  26.181  1.00 49.41           O  
ATOM   1459  CB  VAL A 207      -1.064   0.840  26.982  1.00 50.65           C  
ATOM   1460  CG1 VAL A 207      -0.534   1.100  25.590  1.00 49.91           C  
ATOM   1461  CG2 VAL A 207      -0.042   0.059  27.788  1.00 50.49           C  
ATOM   1462  N   LEU A 208      -3.643   2.588  26.888  1.00 49.12           N  
ATOM   1463  CA  LEU A 208      -4.660   3.299  26.110  1.00 49.11           C  
ATOM   1464  C   LEU A 208      -4.721   4.758  26.525  1.00 48.47           C  
ATOM   1465  O   LEU A 208      -4.992   5.649  25.717  1.00 47.92           O  
ATOM   1466  CB  LEU A 208      -6.046   2.670  26.300  1.00 49.67           C  
ATOM   1467  CG  LEU A 208      -6.255   1.222  25.840  1.00 50.53           C  
ATOM   1468  CD1 LEU A 208      -5.537   0.970  24.505  1.00 50.35           C  
ATOM   1469  CD2 LEU A 208      -5.732   0.284  26.913  1.00 51.22           C  
ATOM   1470  N   GLU A 209      -4.460   4.989  27.802  1.00 47.84           N  
ATOM   1471  CA  GLU A 209      -4.478   6.321  28.357  1.00 48.01           C  
ATOM   1472  C   GLU A 209      -3.407   7.216  27.742  1.00 46.31           C  
ATOM   1473  O   GLU A 209      -3.699   8.320  27.293  1.00 46.41           O  
ATOM   1474  CB  GLU A 209      -4.299   6.232  29.866  1.00 51.56           C  
ATOM   1475  CG  GLU A 209      -4.382   7.561  30.571  1.00 57.55           C  
ATOM   1476  CD  GLU A 209      -4.764   7.404  32.028  1.00 61.35           C  
ATOM   1477  OE1 GLU A 209      -5.938   7.046  32.290  1.00 62.98           O  
ATOM   1478  OE2 GLU A 209      -3.892   7.628  32.902  1.00 63.46           O  
ATOM   1479  N   VAL A 210      -2.164   6.753  27.724  1.00 43.99           N  
ATOM   1480  CA  VAL A 210      -1.096   7.552  27.136  1.00 42.82           C  
ATOM   1481  C   VAL A 210      -1.422   7.810  25.676  1.00 41.96           C  
ATOM   1482  O   VAL A 210      -1.123   8.871  25.135  1.00 41.63           O  
ATOM   1483  CB  VAL A 210       0.259   6.832  27.198  1.00 42.45           C  
ATOM   1484  CG1 VAL A 210       1.324   7.675  26.503  1.00 42.53           C  
ATOM   1485  CG2 VAL A 210       0.641   6.577  28.644  1.00 43.07           C  
ATOM   1486  N   THR A 211      -2.044   6.821  25.048  1.00 41.25           N  
ATOM   1487  CA  THR A 211      -2.416   6.907  23.649  1.00 41.99           C  
ATOM   1488  C   THR A 211      -3.425   8.003  23.369  1.00 42.58           C  
ATOM   1489  O   THR A 211      -3.309   8.728  22.381  1.00 43.55           O  
ATOM   1490  CB  THR A 211      -3.018   5.594  23.159  1.00 41.50           C  
ATOM   1491  OG1 THR A 211      -2.024   4.568  23.228  1.00 42.09           O  
ATOM   1492  CG2 THR A 211      -3.503   5.735  21.732  1.00 41.91           C  
ATOM   1493  N   THR A 212      -4.432   8.116  24.223  1.00 42.70           N  
ATOM   1494  CA  THR A 212      -5.446   9.134  24.011  1.00 43.11           C  
ATOM   1495  C   THR A 212      -4.921  10.506  24.376  1.00 42.35           C  
ATOM   1496  O   THR A 212      -5.380  11.500  23.831  1.00 42.73           O  
ATOM   1497  CB  THR A 212      -6.712   8.855  24.836  1.00 44.21           C  
ATOM   1498  OG1 THR A 212      -6.367   8.803  26.225  1.00 46.65           O  
ATOM   1499  CG2 THR A 212      -7.343   7.527  24.417  1.00 44.87           C  
ATOM   1500  N   LYS A 213      -3.944  10.559  25.279  1.00 41.52           N  
ATOM   1501  CA  LYS A 213      -3.382  11.832  25.711  1.00 41.00           C  
ATOM   1502  C   LYS A 213      -2.276  12.432  24.839  1.00 39.81           C  
ATOM   1503  O   LYS A 213      -2.132  13.659  24.777  1.00 39.57           O  
ATOM   1504  CB  LYS A 213      -2.874  11.729  27.156  1.00 42.98           C  
ATOM   1505  CG  LYS A 213      -2.296  13.047  27.649  1.00 45.74           C  
ATOM   1506  CD  LYS A 213      -2.154  13.144  29.155  1.00 48.36           C  
ATOM   1507  CE  LYS A 213      -1.821  14.592  29.527  1.00 50.35           C  
ATOM   1508  NZ  LYS A 213      -1.643  14.809  30.989  1.00 52.95           N  
ATOM   1509  N   PHE A 214      -1.502  11.593  24.155  1.00 38.53           N  
ATOM   1510  CA  PHE A 214      -0.405  12.111  23.334  1.00 38.17           C  
ATOM   1511  C   PHE A 214      -0.437  11.832  21.829  1.00 36.33           C  
ATOM   1512  O   PHE A 214       0.381  12.353  21.074  1.00 35.40           O  
ATOM   1513  CB  PHE A 214       0.919  11.648  23.942  1.00 39.28           C  
ATOM   1514  CG  PHE A 214       1.082  12.072  25.369  1.00 42.19           C  
ATOM   1515  CD1 PHE A 214       1.078  11.132  26.397  1.00 42.98           C  
ATOM   1516  CD2 PHE A 214       1.160  13.432  25.695  1.00 43.54           C  
ATOM   1517  CE1 PHE A 214       1.145  11.535  27.738  1.00 44.44           C  
ATOM   1518  CE2 PHE A 214       1.227  13.849  27.028  1.00 44.75           C  
ATOM   1519  CZ  PHE A 214       1.218  12.892  28.055  1.00 44.76           C  
ATOM   1520  N   MET A 215      -1.387  11.023  21.391  1.00 34.47           N  
ATOM   1521  CA  MET A 215      -1.492  10.728  19.983  1.00 33.72           C  
ATOM   1522  C   MET A 215      -2.688  11.426  19.362  1.00 34.30           C  
ATOM   1523  O   MET A 215      -3.698  11.676  20.017  1.00 33.45           O  
ATOM   1524  CB  MET A 215      -1.569   9.224  19.775  1.00 33.40           C  
ATOM   1525  CG  MET A 215      -0.289   8.538  20.188  1.00 32.55           C  
ATOM   1526  SD  MET A 215      -0.232   6.837  19.664  1.00 33.04           S  
ATOM   1527  CE  MET A 215       0.567   6.152  21.033  1.00 31.72           C  
ATOM   1528  N   ARG A 216      -2.547  11.751  18.087  1.00 35.33           N  
ATOM   1529  CA  ARG A 216      -3.575  12.440  17.336  1.00 36.63           C  
ATOM   1530  C   ARG A 216      -3.994  11.569  16.160  1.00 35.48           C  
ATOM   1531  O   ARG A 216      -3.210  11.349  15.232  1.00 35.46           O  
ATOM   1532  CB  ARG A 216      -3.014  13.780  16.855  1.00 39.94           C  
ATOM   1533  CG  ARG A 216      -2.387  14.561  18.001  1.00 46.68           C  
ATOM   1534  CD  ARG A 216      -1.569  15.778  17.586  1.00 51.84           C  
ATOM   1535  NE  ARG A 216      -0.993  16.423  18.774  1.00 57.50           N  
ATOM   1536  CZ  ARG A 216      -0.342  17.591  18.780  1.00 59.83           C  
ATOM   1537  NH1 ARG A 216      -0.170  18.272  17.648  1.00 60.30           N  
ATOM   1538  NH2 ARG A 216       0.137  18.083  19.926  1.00 59.97           N  
ATOM   1539  N   ASN A 217      -5.226  11.066  16.222  1.00 34.43           N  
ATOM   1540  CA  ASN A 217      -5.787  10.216  15.177  1.00 33.71           C  
ATOM   1541  C   ASN A 217      -4.739   9.206  14.757  1.00 32.02           C  
ATOM   1542  O   ASN A 217      -4.379   9.113  13.584  1.00 31.53           O  
ATOM   1543  CB  ASN A 217      -6.191  11.054  13.968  1.00 35.41           C  
ATOM   1544  CG  ASN A 217      -7.187  10.335  13.078  1.00 38.46           C  
ATOM   1545  OD1 ASN A 217      -7.387  10.715  11.922  1.00 42.65           O  
ATOM   1546  ND2 ASN A 217      -7.834   9.299  13.617  1.00 37.85           N  
ATOM   1547  N   PRO A 218      -4.251   8.413  15.716  1.00 30.45           N  
ATOM   1548  CA  PRO A 218      -3.222   7.410  15.447  1.00 29.52           C  
ATOM   1549  C   PRO A 218      -3.611   6.259  14.538  1.00 28.51           C  
ATOM   1550  O   PRO A 218      -4.782   5.918  14.405  1.00 28.85           O  
ATOM   1551  CB  PRO A 218      -2.871   6.919  16.843  1.00 28.80           C  
ATOM   1552  CG  PRO A 218      -4.225   6.927  17.502  1.00 28.80           C  
ATOM   1553  CD  PRO A 218      -4.783   8.263  17.084  1.00 29.92           C  
ATOM   1554  N   VAL A 219      -2.601   5.686  13.895  1.00 27.54           N  
ATOM   1555  CA  VAL A 219      -2.788   4.510  13.070  1.00 25.63           C  
ATOM   1556  C   VAL A 219      -2.748   3.416  14.131  1.00 26.48           C  
ATOM   1557  O   VAL A 219      -1.892   3.451  15.022  1.00 26.30           O  
ATOM   1558  CB  VAL A 219      -1.618   4.319  12.087  1.00 23.92           C  
ATOM   1559  CG1 VAL A 219      -1.590   2.887  11.566  1.00 22.71           C  
ATOM   1560  CG2 VAL A 219      -1.771   5.286  10.933  1.00 22.94           C  
ATOM   1561  N   ARG A 220      -3.684   2.477  14.067  1.00 27.30           N  
ATOM   1562  CA  ARG A 220      -3.745   1.391  15.041  1.00 29.75           C  
ATOM   1563  C   ARG A 220      -3.507   0.062  14.341  1.00 30.22           C  
ATOM   1564  O   ARG A 220      -4.152  -0.242  13.348  1.00 29.84           O  
ATOM   1565  CB  ARG A 220      -5.118   1.362  15.727  1.00 32.10           C  
ATOM   1566  CG  ARG A 220      -5.432   2.593  16.565  1.00 36.69           C  
ATOM   1567  CD  ARG A 220      -6.919   2.669  16.961  1.00 41.13           C  
ATOM   1568  NE  ARG A 220      -7.224   3.953  17.597  1.00 46.32           N  
ATOM   1569  CZ  ARG A 220      -6.939   4.256  18.867  1.00 50.13           C  
ATOM   1570  NH1 ARG A 220      -6.355   3.363  19.659  1.00 51.11           N  
ATOM   1571  NH2 ARG A 220      -7.193   5.474  19.344  1.00 51.84           N  
ATOM   1572  N   ILE A 221      -2.569  -0.722  14.853  1.00 31.22           N  
ATOM   1573  CA  ILE A 221      -2.271  -2.022  14.264  1.00 33.54           C  
ATOM   1574  C   ILE A 221      -2.256  -3.017  15.411  1.00 36.06           C  
ATOM   1575  O   ILE A 221      -1.311  -3.049  16.196  1.00 37.39           O  
ATOM   1576  CB  ILE A 221      -0.890  -2.035  13.554  1.00 33.18           C  
ATOM   1577  CG1 ILE A 221      -0.859  -0.996  12.431  1.00 32.55           C  
ATOM   1578  CG2 ILE A 221      -0.616  -3.414  12.973  1.00 32.34           C  
ATOM   1579  CD1 ILE A 221       0.510  -0.798  11.828  1.00 33.29           C  
ATOM   1580  N   LEU A 222      -3.312  -3.817  15.514  1.00 38.40           N  
ATOM   1581  CA  LEU A 222      -3.429  -4.799  16.583  1.00 40.20           C  
ATOM   1582  C   LEU A 222      -3.576  -6.208  16.022  1.00 41.62           C  
ATOM   1583  O   LEU A 222      -2.565  -6.940  16.121  1.00 44.41           O  
ATOM   1584  CB  LEU A 222      -4.628  -4.453  17.458  1.00 40.63           C  
ATOM   1585  CG  LEU A 222      -4.595  -3.041  18.045  1.00 41.85           C  
ATOM   1586  CD1 LEU A 222      -5.899  -2.747  18.762  1.00 43.28           C  
ATOM   1587  CD2 LEU A 222      -3.427  -2.905  19.002  1.00 42.14           C  
ATOM   1588  N   VAL A 223      -4.649  -6.535  15.519  1.00 42.64           N  
TER    1589      VAL A 223                                                      
END
MOLECULE T0477.pdb
ATOM      1  N   SER     1      -5.659  -3.669  -3.054  1.00 17.95           N
ATOM      2  CA  SER     1      -7.095  -3.767  -2.643  1.00 17.35           C
ATOM      3  CB  SER     1      -8.006  -3.336  -3.778  1.00 17.52           C
ATOM      4  OG  SER     1      -7.556  -3.920  -4.983  1.00 19.58           O
ATOM      5  C   SER     1      -7.406  -5.196  -2.216  1.00 16.26           C
ATOM      6  O   SER     1      -7.452  -5.474  -1.016  1.00 15.55           O
ATOM      7  N   MET     2      -7.636  -6.090  -3.185  1.00 15.05           N
ATOM      8  CA  MET     2      -7.535  -7.518  -2.895  1.00 14.46           C
ATOM      9  CB  MET     2      -7.833  -8.357  -4.115  1.00 14.66           C
ATOM     10  CG  MET     2      -9.282  -8.693  -4.242  1.00 17.58           C
ATOM     11  SD  MET     2      -9.760 -10.089  -3.220  1.00 21.31           S
ATOM     12  CE  MET     2     -11.366 -10.405  -3.940  1.00 19.89           C
ATOM     13  C   MET     2      -6.145  -7.880  -2.369  1.00 13.11           C
ATOM     14  O   MET     2      -6.025  -8.668  -1.432  1.00 12.74           O
ATOM     15  N   LYS     3      -5.109  -7.331  -2.997  1.00 11.97           N
ATOM     16  CA  LYS     3      -3.733  -7.461  -2.521  1.00 11.94           C
ATOM     17  CB  LYS     3      -2.799  -6.595  -3.375  1.00 12.58           C
ATOM     18  CG  LYS     3      -2.014  -7.344  -4.446  1.00 15.44           C
ATOM     19  CD  LYS     3      -1.131  -6.388  -5.255  1.00 19.75           C
ATOM     20  CE  LYS     3      -1.957  -5.548  -6.242  1.00 21.62           C
ATOM     21  NZ  LYS     3      -1.229  -4.326  -6.698  1.00 21.88           N
ATOM     22  C   LYS     3      -3.600  -7.025  -1.054  1.00 11.20           C
ATOM     23  O   LYS     3      -3.057  -7.735  -0.218  1.00 10.86           O
ATOM     24  N   ILE     4      -4.114  -5.840  -0.760  1.00 10.33           N
ATOM     25  CA  ILE     4      -4.024  -5.242   0.550  1.00  9.80           C
ATOM     26  CB  ILE     4      -4.492  -3.780   0.479  1.00 10.33           C
ATOM     27  CG1 ILE     4      -3.621  -3.033  -0.527  1.00 10.13           C
ATOM     28  CD1 ILE     4      -2.180  -2.968  -0.117  1.00 13.19           C
ATOM     29  CG2 ILE     4      -4.447  -3.109   1.855  1.00 10.34           C
ATOM     30  C   ILE     4      -4.840  -5.997   1.569  1.00  9.20           C
ATOM     31  O   ILE     4      -4.358  -6.253   2.663  1.00  9.45           O
ATOM     32  N   ASN     5      -6.084  -6.335   1.224  1.00  7.85           N
ATOM     33  CA  ASN     5      -6.909  -7.155   2.093  1.00  7.06           C
ATOM     34  CB  ASN     5      -8.309  -7.400   1.482  1.00  7.38           C
ATOM     35  CG  ASN     5      -9.209  -6.155   1.522  1.00  9.03           C
ATOM     36  OD1 ASN     5      -8.895  -5.152   2.183  1.00 14.61           O
ATOM     37  ND2 ASN     5     -10.333  -6.220   0.810  1.00 10.87           N
ATOM     38  C   ASN     5      -6.229  -8.498   2.404  1.00  5.63           C
ATOM     39  O   ASN     5      -6.249  -8.982   3.543  1.00  5.56           O
ATOM     40  N   PHE     6      -5.638  -9.110   1.390  1.00  4.41           N
ATOM     41  CA  PHE     6      -4.878 -10.325   1.598  1.00  2.63           C
ATOM     42  CB  PHE     6      -4.282 -10.808   0.278  1.00  2.68           C
ATOM     43  CG  PHE     6      -3.341 -11.973   0.428  1.00  2.00           C
ATOM     44  CD1 PHE     6      -3.819 -13.269   0.457  1.00  2.00           C
ATOM     45  CE1 PHE     6      -2.963 -14.352   0.591  1.00  2.00           C
ATOM     46  CZ  PHE     6      -1.594 -14.134   0.678  1.00  2.00           C
ATOM     47  CE2 PHE     6      -1.094 -12.824   0.643  1.00  3.17           C
ATOM     48  CD2 PHE     6      -1.979 -11.756   0.517  1.00  2.77           C
ATOM     49  C   PHE     6      -3.767 -10.154   2.628  1.00  2.55           C
ATOM     50  O   PHE     6      -3.563 -11.008   3.493  1.00  2.00           O
ATOM     51  N   LEU     7      -3.014  -9.071   2.503  1.00  2.73           N
ATOM     52  CA  LEU     7      -1.892  -8.824   3.393  1.00  3.85           C
ATOM     53  CB  LEU     7      -1.215  -7.478   3.076  1.00  3.76           C
ATOM     54  CG  LEU     7      -0.192  -7.445   1.935  1.00  6.53           C
ATOM     55  CD1 LEU     7       0.496  -6.061   1.874  1.00  8.73           C
ATOM     56  CD2 LEU     7       0.852  -8.552   2.094  1.00  6.22           C
ATOM     57  C   LEU     7      -2.367  -8.814   4.835  1.00  3.44           C
ATOM     58  O   LEU     7      -1.824  -9.500   5.688  1.00  2.66           O
ATOM     59  N   ARG     8      -3.405  -8.032   5.082  1.00  3.96           N
ATOM     60  CA  ARG     8      -3.892  -7.848   6.429  1.00  4.55           C
ATOM     61  CB  ARG     8      -4.829  -6.655   6.487  1.00  4.13           C
ATOM     62  CG  ARG     8      -4.123  -5.294   6.366  1.00  4.29           C
ATOM     63  CD  ARG     8      -4.991  -4.240   6.966  1.00  7.06           C
ATOM     64  NE  ARG     8      -4.449  -2.888   6.846  1.00 10.41           N
ATOM     65  CZ  ARG     8      -4.948  -1.950   6.046  1.00  7.79           C
ATOM     66  NH1 ARG     8      -5.979  -2.236   5.281  1.00  7.63           N
ATOM     67  NH2 ARG     8      -4.392  -0.742   5.987  1.00  7.49           N
ATOM     68  C   ARG     8      -4.569  -9.123   6.949  1.00  5.35           C
ATOM     69  O   ARG     8      -4.409  -9.472   8.114  1.00  5.41           O
ATOM     70  N   ASN     9      -5.283  -9.840   6.084  1.00  5.63           N
ATOM     71  CA  ASN     9      -5.972 -11.056   6.534  1.00  6.49           C
ATOM     72  CB  ASN     9      -7.125 -11.439   5.576  1.00  7.74           C
ATOM     73  CG  ASN     9      -8.388 -10.566   5.779  1.00  9.38           C
ATOM     74  OD1 ASN     9      -9.383 -11.021   6.336  1.00 17.28           O
ATOM     75  ND2 ASN     9      -8.342  -9.330   5.337  1.00 12.60           N
ATOM     76  C   ASN     9      -4.992 -12.221   6.731  1.00  6.61           C
ATOM     77  O   ASN     9      -5.005 -12.885   7.777  1.00  5.28           O
ATOM     78  N   LYS    10      -4.112 -12.441   5.747  1.00  6.56           N
ATOM     79  CA  LYS    10      -3.100 -13.501   5.854  1.00  6.19           C
ATOM     80  CB  LYS    10      -2.251 -13.598   4.583  1.00  6.80           C
ATOM     81  CG  LYS    10      -1.160 -14.712   4.617  1.00  7.78           C
ATOM     82  CD  LYS    10      -1.740 -16.036   4.190  1.00  9.64           C
ATOM     83  CE  LYS    10      -0.693 -17.170   4.091  1.00 13.22           C
ATOM     84  NZ  LYS    10       0.570 -16.755   3.402  1.00 12.50           N
ATOM     85  C   LYS    10      -2.157 -13.309   7.047  1.00  6.31           C
ATOM     86  O   LYS    10      -1.809 -14.284   7.707  1.00  6.75           O
ATOM     87  N   HIS    11      -1.727 -12.071   7.312  1.00  5.77           N
ATOM     88  CA  HIS    11      -0.688 -11.842   8.338  1.00  5.29           C
ATOM     89  CB  HIS    11       0.428 -10.898   7.820  1.00  4.67           C
ATOM     90  CG  HIS    11       1.127 -11.403   6.587  1.00  5.24           C
ATOM     91  ND1 HIS    11       1.933 -12.523   6.587  1.00  3.26           N
ATOM     92  CE1 HIS    11       2.399 -12.731   5.372  1.00  6.26           C
ATOM     93  NE2 HIS    11       1.942 -11.772   4.585  1.00  7.13           N
ATOM     94  CD2 HIS    11       1.147 -10.930   5.318  1.00  5.65           C
ATOM     95  C   HIS    11      -1.274 -11.373   9.665  1.00  5.27           C
ATOM     96  O   HIS    11      -0.533 -11.015  10.597  1.00  5.26           O
ATOM     97  N   LYS    12      -2.606 -11.399   9.750  1.00  5.55           N
ATOM     98  CA  LYS    12      -3.344 -11.075  10.986  1.00  5.59           C
ATOM     99  CB  LYS    12      -3.030 -12.087  12.091  1.00  6.39           C
ATOM    100  CG  LYS    12      -3.151 -13.543  11.634  1.00  7.17           C
ATOM    101  CD  LYS    12      -4.545 -13.841  11.086  1.00 10.08           C
ATOM    102  CE  LYS    12      -4.682 -15.305  10.536  1.00 11.56           C
ATOM    103  NZ  LYS    12      -4.795 -16.289  11.651  1.00 12.60           N
ATOM    104  C   LYS    12      -3.096  -9.667  11.493  1.00  4.90           C
ATOM    105  O   LYS    12      -3.036  -9.419  12.708  1.00  4.82           O
ATOM    106  N   ILE    13      -2.991  -8.738  10.561  1.00  4.03           N
ATOM    107  CA  ILE    13      -2.760  -7.341  10.899  1.00  3.91           C
ATOM    108  CB  ILE    13      -2.127  -6.611   9.722  1.00  3.35           C
ATOM    109  CG1 ILE    13      -0.834  -7.306   9.290  1.00  5.05           C
ATOM    110  CD1 ILE    13      -0.265  -6.783   7.969  1.00  3.66           C
ATOM    111  CG2 ILE    13      -1.871  -5.166  10.075  1.00  3.40           C
ATOM    112  C   ILE    13      -4.078  -6.652  11.220  1.00  4.10           C
ATOM    113  O   ILE    13      -4.869  -6.340  10.314  1.00  4.62           O
ATOM    114  N   HIS    14      -4.324  -6.401  12.492  1.00  4.34           N
ATOM    115  CA  HIS    14      -5.564  -5.749  12.886  1.00  5.42           C
ATOM    116  CB  HIS    14      -6.072  -6.309  14.220  1.00  6.20           C
ATOM    117  CG  HIS    14      -6.502  -7.741  14.161  1.00  8.71           C
ATOM    118  ND1 HIS    14      -5.690  -8.778  14.565  1.00 15.22           N
ATOM    119  CE1 HIS    14      -6.325  -9.929  14.404  1.00 13.26           C
ATOM    120  NE2 HIS    14      -7.530  -9.671  13.928  1.00 15.10           N
ATOM    121  CD2 HIS    14      -7.671  -8.309  13.777  1.00 12.48           C
ATOM    122  C   HIS    14      -5.272  -4.283  13.064  1.00  5.47           C
ATOM    123  O   HIS    14      -4.397  -3.932  13.844  1.00  5.02           O
ATOM    124  N   VAL    15      -6.031  -3.425  12.392  1.00  5.61           N
ATOM    125  CA  VAL    15      -5.723  -1.999  12.385  1.00  5.96           C
ATOM    126  CB  VAL    15      -5.187  -1.551  11.006  1.00  6.55           C
ATOM    127  CG1 VAL    15      -3.953  -2.359  10.627  1.00  4.10           C
ATOM    128  CG2 VAL    15      -6.269  -1.725   9.880  1.00  7.69           C
ATOM    129  C   VAL    15      -6.965  -1.209  12.756  1.00  7.11           C
ATOM    130  O   VAL    15      -8.046  -1.508  12.267  1.00  7.66           O
ATOM    131  N   GLN    16      -6.830  -0.228  13.643  1.00  7.29           N
ATOM    132  CA  GLN    16      -7.942   0.680  13.920  1.00  8.99           C
ATOM    133  CB  GLN    16      -8.433   0.491  15.354  1.00  9.09           C
ATOM    134  CG  GLN    16      -9.941   0.475  15.522  1.00 14.25           C
ATOM    135  CD  GLN    16     -10.344   0.081  16.940  1.00 19.16           C
ATOM    136  OE1 GLN    16      -9.703  -0.776  17.558  1.00 23.17           O
ATOM    137  NE2 GLN    16     -11.393   0.705  17.462  1.00 20.49           N
ATOM    138  C   GLN    16      -7.426   2.098  13.721  1.00  8.81           C
ATOM    139  O   GLN    16      -6.240   2.368  13.967  1.00  7.01           O
ATOM    140  N   GLY    17      -8.301   2.996  13.258  1.00  8.72           N
ATOM    141  CA  GLY    17      -7.919   4.401  13.073  1.00  9.42           C
ATOM    142  C   GLY    17      -8.501   4.976  11.801  1.00  9.78           C
ATOM    143  O   GLY    17      -9.215   4.280  11.091  1.00  9.86           O
ATOM    144  N   THR    18      -8.213   6.241  11.504  1.00  9.63           N
ATOM    145  CA  THR    18      -8.760   6.853  10.300  1.00 10.09           C
ATOM    146  CB  THR    18      -9.633   8.120  10.631  1.00 10.26           C
ATOM    147  OG1 THR    18      -8.796   9.186  11.072  1.00 13.22           O
ATOM    148  CG2 THR    18     -10.639   7.806  11.735  1.00 10.14           C
ATOM    149  C   THR    18      -7.663   7.158   9.285  1.00  9.97           C
ATOM    150  O   THR    18      -6.531   7.432   9.668  1.00 10.18           O
ATOM    151  N   ASP    19      -7.978   7.070   7.994  1.00 10.12           N
ATOM    152  CA  ASP    19      -7.008   7.388   6.939  1.00 10.87           C
ATOM    153  CB  ASP    19      -6.568   8.847   7.076  1.00 11.72           C
ATOM    154  CG  ASP    19      -6.706   9.608   5.794  1.00 16.05           C
ATOM    155  OD1 ASP    19      -5.810   9.456   4.938  1.00 20.87           O
ATOM    156  OD2 ASP    19      -7.723  10.340   5.641  1.00 16.82           O
ATOM    157  C   ASP    19      -5.757   6.507   6.998  1.00 10.23           C
ATOM    158  O   ASP    19      -4.628   7.007   6.905  1.00 10.35           O
ATOM    159  N   LEU    20      -5.963   5.205   7.131  1.00  9.45           N
ATOM    160  CA  LEU    20      -4.884   4.242   7.274  1.00  8.26           C
ATOM    161  CB  LEU    20      -5.473   2.867   7.597  1.00  7.80           C
ATOM    162  CG  LEU    20      -6.490   2.867   8.735  1.00  8.16           C
ATOM    163  CD1 LEU    20      -7.139   1.475   8.895  1.00  9.83           C
ATOM    164  CD2 LEU    20      -5.806   3.316  10.025  1.00  5.08           C
ATOM    165  C   LEU    20      -4.025   4.107   6.028  1.00  8.14           C
ATOM    166  O   LEU    20      -4.532   3.802   4.959  1.00  7.97           O
ATOM    167  N   PRO    21      -2.695   4.265   6.176  1.00  8.38           N
ATOM    168  CA  PRO    21      -1.776   3.949   5.082  1.00  7.07           C
ATOM    169  CB  PRO    21      -0.393   4.320   5.672  1.00  7.84           C
ATOM    170  CG  PRO    21      -0.700   5.241   6.855  1.00  7.81           C
ATOM    171  CD  PRO    21      -1.982   4.674   7.404  1.00  7.70           C
ATOM    172  C   PRO    21      -1.810   2.448   4.799  1.00  7.20           C
ATOM    173  O   PRO    21      -1.935   1.631   5.727  1.00  6.28           O
ATOM    174  N   ASP    22      -1.710   2.078   3.533  1.00  6.41           N
ATOM    175  CA  ASP    22      -1.571   0.673   3.196  1.00  6.59           C
ATOM    176  CB  ASP    22      -1.646   0.467   1.692  1.00  6.57           C
ATOM    177  CG  ASP    22      -2.988   0.813   1.152  1.00  9.72           C
ATOM    178  OD1 ASP    22      -3.967   0.783   1.944  1.00 13.39           O
ATOM    179  OD2 ASP    22      -3.082   1.126  -0.047  1.00 12.17           O
ATOM    180  C   ASP    22      -0.279   0.074   3.729  1.00  6.33           C
ATOM    181  O   ASP    22       0.773   0.750   3.832  1.00  5.40           O
ATOM    182  N   PRO    23      -0.353  -1.207   4.091  1.00  5.78           N
ATOM    183  CA  PRO    23       0.849  -1.900   4.506  1.00  6.27           C
ATOM    184  CB  PRO    23       0.330  -3.242   5.062  1.00  5.96           C
ATOM    185  CG  PRO    23      -1.029  -3.437   4.457  1.00  5.73           C
ATOM    186  CD  PRO    23      -1.567  -2.042   4.147  1.00  6.03           C
ATOM    187  C   PRO    23       1.757  -2.126   3.295  1.00  6.84           C
ATOM    188  O   PRO    23       1.284  -2.119   2.159  1.00  6.83           O
ATOM    189  N   ILE    24       3.054  -2.291   3.521  1.00  6.64           N
ATOM    190  CA  ILE    24       3.906  -2.707   2.415  1.00  8.19           C
ATOM    191  CB  ILE    24       5.272  -2.013   2.444  1.00  8.19           C
ATOM    192  CG1 ILE    24       5.927  -2.229   3.804  1.00 10.05           C
ATOM    193  CD1 ILE    24       7.106  -3.104   3.791  1.00 12.47           C
ATOM    194  CG2 ILE    24       5.125  -0.528   2.189  1.00  8.08           C
ATOM    195  C   ILE    24       4.094  -4.229   2.433  1.00  7.88           C
ATOM    196  O   ILE    24       4.215  -4.854   3.506  1.00  7.51           O
ATOM    197  N   ALA    25       4.108  -4.816   1.244  1.00  7.03           N
ATOM    198  CA  ALA    25       4.312  -6.242   1.098  1.00  7.10           C
ATOM    199  CB  ALA    25       3.685  -6.704  -0.224  1.00  7.01           C
ATOM    200  C   ALA    25       5.799  -6.643   1.149  1.00  7.21           C
ATOM    201  O   ALA    25       6.153  -7.750   1.571  1.00  7.08           O
ATOM    202  N   THR    26       6.670  -5.761   0.674  1.00  6.89           N
ATOM    203  CA  THR    26       8.073  -6.122   0.494  1.00  7.41           C
ATOM    204  CB  THR    26       8.351  -6.486  -0.983  1.00  7.50           C
ATOM    205  OG1 THR    26       8.245  -5.295  -1.750  1.00  9.52           O
ATOM    206  CG2 THR    26       7.366  -7.534  -1.532  1.00  6.04           C
ATOM    207  C   THR    26       8.959  -4.925   0.809  1.00  7.38           C
ATOM    208  O   THR    26       8.503  -3.782   0.699  1.00  5.97           O
ATOM    209  N   PHE    27      10.221  -5.149   1.186  1.00  7.87           N
ATOM    210  CA  PHE    27      11.124  -3.989   1.371  1.00  9.14           C
ATOM    211  CB  PHE    27      12.436  -4.352   2.066  1.00  8.85           C
ATOM    212  CG  PHE    27      12.264  -4.758   3.503  1.00  8.65           C
ATOM    213  CD1 PHE    27      11.713  -3.883   4.427  1.00  9.20           C
ATOM    214  CE1 PHE    27      11.560  -4.267   5.745  1.00  8.54           C
ATOM    215  CZ  PHE    27      11.960  -5.535   6.151  1.00  6.73           C
ATOM    216  CE2 PHE    27      12.500  -6.400   5.248  1.00  8.63           C
ATOM    217  CD2 PHE    27      12.661  -6.014   3.927  1.00  9.55           C
ATOM    218  C   PHE    27      11.412  -3.239   0.073  1.00  9.88           C
ATOM    219  O   PHE    27      11.730  -2.044   0.087  1.00 10.95           O
ATOM    220  N   GLN    28      11.288  -3.931  -1.044  1.00 11.33           N
ATOM    221  CA  GLN    28      11.498  -3.311  -2.362  1.00 13.30           C
ATOM    222  CB  GLN    28      11.477  -4.383  -3.455  1.00 12.59           C
ATOM    223  CG  GLN    28      12.709  -5.296  -3.464  1.00 14.77           C
ATOM    224  CD  GLN    28      12.657  -6.415  -2.413  1.00 17.46           C
ATOM    225  OE1 GLN    28      11.599  -6.717  -1.867  1.00 19.05           O
ATOM    226  NE2 GLN    28      13.802  -7.053  -2.157  1.00 17.01           N
ATOM    227  C   GLN    28      10.493  -2.175  -2.666  1.00 14.26           C
ATOM    228  O   GLN    28      10.857  -1.158  -3.239  1.00 14.44           O
ATOM    229  N   GLN    29       9.232  -2.364  -2.290  1.00 16.58           N
ATOM    230  CA  GLN    29       8.243  -1.271  -2.303  1.00 18.31           C
ATOM    231  CB  GLN    29       7.084  -1.599  -1.392  1.00 19.04           C
ATOM    232  CG  GLN    29       6.348  -2.870  -1.708  1.00 20.63           C
ATOM    233  CD  GLN    29       4.876  -2.671  -1.516  1.00 22.61           C
ATOM    234  OE1 GLN    29       4.126  -3.610  -1.221  1.00 23.50           O
ATOM    235  NE2 GLN    29       4.442  -1.430  -1.680  1.00 22.36           N
ATOM    236  C   GLN    29       8.791   0.045  -1.783  1.00 19.43           C
ATOM    237  O   GLN    29       8.474   1.093  -2.326  1.00 19.91           O
ATOM    238  N   LEU    30       9.578  -0.008  -0.697  1.00 20.35           N
ATOM    239  CA  LEU    30      10.090   1.197  -0.050  1.00 20.07           C
ATOM    240  CB  LEU    30      10.819   0.852   1.269  1.00 20.80           C
ATOM    241  CG  LEU    30      10.016   0.221   2.409  1.00 18.32           C
ATOM    242  CD1 LEU    30      10.955  -0.112   3.566  1.00 17.02           C
ATOM    243  CD2 LEU    30       8.897   1.175   2.855  1.00 16.63           C
ATOM    244  C   LEU    30      11.058   1.931  -0.947  1.00 20.93           C
ATOM    245  O   LEU    30      11.216   3.151  -0.834  1.00 20.57           O
ATOM    246  N   ASP    31      11.741   1.220  -1.834  1.00 20.86           N
ATOM    247  CA  ASP    31      12.552   1.977  -2.768  1.00 22.27           C
ATOM    248  CB  ASP    31      13.641   1.146  -3.459  1.00 22.39           C
ATOM    249  CG  ASP    31      14.248   1.886  -4.652  1.00 25.04           C
ATOM    250  OD1 ASP    31      14.351   3.133  -4.567  1.00 27.40           O
ATOM    251  OD2 ASP    31      14.606   1.250  -5.679  1.00 25.37           O
ATOM    252  C   ASP    31      11.602   2.630  -3.774  1.00 21.84           C
ATOM    253  O   ASP    31      11.720   3.823  -4.080  1.00 21.76           O
ATOM    254  N   GLN    32      10.633   1.853  -4.249  1.00 21.73           N
ATOM    255  CA  GLN    32       9.721   2.338  -5.283  1.00 21.51           C
ATOM    256  CB  GLN    32       8.873   1.181  -5.845  1.00 21.95           C
ATOM    257  CG  GLN    32       9.713   0.182  -6.669  1.00 24.69           C
ATOM    258  CD  GLN    32       9.226  -1.281  -6.600  1.00 29.21           C
ATOM    259  OE1 GLN    32       8.056  -1.560  -6.290  1.00 30.67           O
ATOM    260  NE2 GLN    32      10.132  -2.220  -6.906  1.00 28.57           N
ATOM    261  C   GLN    32       8.853   3.474  -4.750  1.00 20.66           C
ATOM    262  O   GLN    32       8.680   4.472  -5.414  1.00 20.02           O
ATOM    263  N   GLU    33       8.338   3.336  -3.530  1.00 20.19           N
ATOM    264  CA  GLU    33       7.380   4.318  -3.000  1.00 20.03           C
ATOM    265  CB  GLU    33       6.264   3.609  -2.223  1.00 19.71           C
ATOM    266  CG  GLU    33       5.589   2.487  -3.043  1.00 21.07           C
ATOM    267  CD  GLU    33       4.501   1.708  -2.297  1.00 21.95           C
ATOM    268  OE1 GLU    33       4.510   1.665  -1.057  1.00 23.44           O
ATOM    269  OE2 GLU    33       3.628   1.123  -2.967  1.00 24.25           O
ATOM    270  C   GLU    33       7.997   5.486  -2.197  1.00 19.96           C
ATOM    271  O   GLU    33       7.560   6.627  -2.347  1.00 19.73           O
ATOM    272  N   TYR    34       9.016   5.207  -1.375  1.00 19.86           N
ATOM    273  CA  TYR    34       9.659   6.232  -0.522  1.00 19.80           C
ATOM    274  CB  TYR    34       9.555   5.858   0.958  1.00 20.03           C
ATOM    275  CG  TYR    34       8.155   5.587   1.407  1.00 18.02           C
ATOM    276  CD1 TYR    34       7.378   6.586   1.986  1.00 17.16           C
ATOM    277  CE1 TYR    34       6.087   6.329   2.394  1.00 14.98           C
ATOM    278  CZ  TYR    34       5.562   5.085   2.208  1.00 15.25           C
ATOM    279  OH  TYR    34       4.270   4.796   2.581  1.00 17.03           O
ATOM    280  CE2 TYR    34       6.311   4.092   1.619  1.00 16.16           C
ATOM    281  CD2 TYR    34       7.597   4.349   1.230  1.00 16.18           C
ATOM    282  C   TYR    34      11.125   6.491  -0.826  1.00 20.35           C
ATOM    283  O   TYR    34      11.734   7.383  -0.234  1.00 22.01           O
ATOM    284  N   LYS    35      11.728   5.724  -1.722  1.00 19.60           N
ATOM    285  CA  LYS    35      13.058   6.121  -2.172  1.00 18.68           C
ATOM    286  CB  LYS    35      12.989   7.512  -2.764  1.00 19.29           C
ATOM    287  CG  LYS    35      14.321   8.044  -3.254  1.00 20.61           C
ATOM    288  CD  LYS    35      14.112   9.110  -4.324  1.00 23.53           C
ATOM    289  CE  LYS    35      13.101   8.654  -5.375  1.00 25.65           C
ATOM    290  NZ  LYS    35      13.210   9.485  -6.616  1.00 25.37           N
ATOM    291  C   LYS    35      14.098   6.088  -1.040  1.00 17.71           C
ATOM    292  O   LYS    35      14.986   6.976  -0.932  1.00 17.81           O
ATOM    293  N   ILE    36      13.972   5.045  -0.220  1.00 15.11           N
ATOM    294  CA  ILE    36      14.920   4.656   0.821  1.00 12.81           C
ATOM    295  CB  ILE    36      14.567   3.230   1.288  1.00 12.59           C
ATOM    296  CG1 ILE    36      15.539   2.751   2.376  1.00 12.56           C
ATOM    297  CD1 ILE    36      15.291   1.342   2.861  1.00 12.40           C
ATOM    298  CG2 ILE    36      14.577   2.277   0.083  1.00 11.79           C
ATOM    299  C   ILE    36      16.397   4.647   0.377  1.00 11.23           C
ATOM    300  O   ILE    36      16.738   4.270  -0.743  1.00 10.98           O
ATOM    301  N   ASN    37      17.268   5.067   1.276  1.00  9.64           N
ATOM    302  CA  ASN    37      18.715   5.023   1.059  1.00  8.41           C
ATOM    303  CB  ASN    37      19.411   5.291   2.395  1.00  8.19           C
ATOM    304  CG  ASN    37      20.893   5.456   2.250  1.00  9.36           C
ATOM    305  OD1 ASN    37      21.661   4.524   2.472  1.00 11.55           O
ATOM    306  ND2 ASN    37      21.311   6.645   1.867  1.00  9.77           N
ATOM    307  C   ASN    37      19.144   3.653   0.556  1.00  7.48           C
ATOM    308  O   ASN    37      18.781   2.626   1.161  1.00  7.31           O
ATOM    309  N   SER    38      19.914   3.621  -0.529  1.00  6.13           N
ATOM    310  CA  SER    38      20.308   2.350  -1.137  1.00  6.04           C
ATOM    311  CB  SER    38      20.954   2.562  -2.519  1.00  6.04           C
ATOM    312  OG  SER    38      22.193   3.233  -2.398  1.00  7.40           O
ATOM    313  C   SER    38      21.205   1.492  -0.245  1.00  5.54           C
ATOM    314  O   SER    38      21.123   0.260  -0.275  1.00  5.89           O
ATOM    315  N   ARG    39      22.057   2.122   0.554  1.00  4.42           N
ATOM    316  CA  ARG    39      22.871   1.358   1.481  1.00  4.50           C
ATOM    317  CB  ARG    39      24.010   2.204   2.087  1.00  4.28           C
ATOM    318  CG  ARG    39      24.765   1.443   3.159  1.00  5.12           C
ATOM    319  CD  ARG    39      25.584   0.330   2.557  1.00  6.51           C
ATOM    320  NE  ARG    39      26.278  -0.480   3.549  1.00  6.87           N
ATOM    321  CZ  ARG    39      27.545  -0.298   3.905  1.00  6.84           C
ATOM    322  NH1 ARG    39      28.236   0.685   3.344  1.00  5.71           N
ATOM    323  NH2 ARG    39      28.106  -1.087   4.824  1.00  4.29           N
ATOM    324  C   ARG    39      22.029   0.732   2.590  1.00  3.74           C
ATOM    325  O   ARG    39      22.211  -0.439   2.918  1.00  3.30           O
ATOM    326  N   LEU    40      21.136   1.530   3.181  1.00  4.10           N
ATOM    327  CA  LEU    40      20.192   1.015   4.183  1.00  4.15           C
ATOM    328  CB  LEU    40      19.194   2.110   4.618  1.00  4.56           C
ATOM    329  CG  LEU    40      18.088   1.834   5.643  1.00  5.36           C
ATOM    330  CD1 LEU    40      18.604   1.114   6.913  1.00  4.80           C
ATOM    331  CD2 LEU    40      17.396   3.161   6.041  1.00  5.69           C
ATOM    332  C   LEU    40      19.445  -0.220   3.658  1.00  3.51           C
ATOM    333  O   LEU    40      19.436  -1.262   4.315  1.00  3.52           O
ATOM    334  N   LEU    41      18.811  -0.109   2.492  1.00  2.79           N
ATOM    335  CA  LEU    41      18.096  -1.261   1.912  1.00  2.44           C
ATOM    336  CB  LEU    41      17.389  -0.884   0.598  1.00  2.50           C
ATOM    337  CG  LEU    41      16.668  -2.004  -0.175  1.00  2.03           C
ATOM    338  CD1 LEU    41      15.517  -2.578   0.664  1.00  2.00           C
ATOM    339  CD2 LEU    41      16.125  -1.540  -1.547  1.00  2.00           C
ATOM    340  C   LEU    41      19.025  -2.485   1.704  1.00  3.30           C
ATOM    341  O   LEU    41      18.624  -3.638   1.957  1.00  2.99           O
ATOM    342  N   GLN    42      20.258  -2.254   1.262  1.00  2.73           N
ATOM    343  CA  GLN    42      21.175  -3.381   1.100  1.00  3.62           C
ATOM    344  CB  GLN    42      22.434  -2.987   0.315  1.00  2.71           C
ATOM    345  CG  GLN    42      23.294  -4.212  -0.116  1.00  5.86           C
ATOM    346  CD  GLN    42      22.524  -5.200  -1.024  1.00  9.82           C
ATOM    347  OE1 GLN    42      21.977  -4.816  -2.060  1.00  9.25           O
ATOM    348  NE2 GLN    42      22.479  -6.479  -0.623  1.00 11.74           N
ATOM    349  C   GLN    42      21.554  -3.974   2.467  1.00  3.97           C
ATOM    350  O   GLN    42      21.719  -5.195   2.596  1.00  3.81           O
ATOM    351  N   ASN    43      21.704  -3.118   3.482  1.00  3.76           N
ATOM    352  CA  ASN    43      22.003  -3.626   4.834  1.00  4.12           C
ATOM    353  CB  ASN    43      22.180  -2.475   5.821  1.00  3.08           C
ATOM    354  CG  ASN    43      23.479  -1.743   5.631  1.00  2.00           C
ATOM    355  OD1 ASN    43      24.378  -2.223   4.958  1.00  2.00           O
ATOM    356  ND2 ASN    43      23.585  -0.582   6.224  1.00  2.00           N
ATOM    357  C   ASN    43      20.896  -4.561   5.337  1.00  4.09           C
ATOM    358  O   ASN    43      21.153  -5.636   5.873  1.00  4.14           O
ATOM    359  N   ILE    44      19.664  -4.105   5.179  1.00  5.02           N
ATOM    360  CA  ILE    44      18.470  -4.865   5.552  1.00  5.62           C
ATOM    361  CB  ILE    44      17.193  -4.035   5.209  1.00  5.65           C
ATOM    362  CG1 ILE    44      17.058  -2.859   6.184  1.00  6.47           C
ATOM    363  CD1 ILE    44      16.122  -1.755   5.720  1.00  4.91           C
ATOM    364  CG2 ILE    44      15.930  -4.893   5.244  1.00  5.42           C
ATOM    365  C   ILE    44      18.471  -6.239   4.857  1.00  6.19           C
ATOM    366  O   ILE    44      18.346  -7.278   5.502  1.00  7.14           O
ATOM    367  N   LEU    45      18.655  -6.247   3.542  1.00  6.20           N
ATOM    368  CA  LEU    45      18.691  -7.493   2.787  1.00  6.82           C
ATOM    369  CB  LEU    45      18.572  -7.197   1.279  1.00  7.28           C
ATOM    370  CG  LEU    45      17.323  -6.366   0.880  1.00  6.92           C
ATOM    371  CD1 LEU    45      17.201  -6.241  -0.647  1.00  8.11           C
ATOM    372  CD2 LEU    45      16.026  -6.988   1.420  1.00  5.85           C
ATOM    373  C   LEU    45      19.906  -8.393   3.137  1.00  7.19           C
ATOM    374  O   LEU    45      19.750  -9.604   3.332  1.00  6.65           O
ATOM    375  N   ASP    46      21.095  -7.798   3.257  1.00  7.54           N
ATOM    376  CA  ASP    46      22.297  -8.509   3.745  1.00  7.92           C
ATOM    377  CB  ASP    46      23.496  -7.566   3.839  1.00  7.77           C
ATOM    378  CG  ASP    46      24.082  -7.204   2.492  1.00  9.57           C
ATOM    379  OD1 ASP    46      23.699  -7.801   1.465  1.00  9.79           O
ATOM    380  OD2 ASP    46      24.967  -6.323   2.474  1.00 11.70           O
ATOM    381  C   ASP    46      22.135  -9.137   5.136  1.00  8.26           C
ATOM    382  O   ASP    46      22.823 -10.093   5.468  1.00  7.99           O
ATOM    383  N   ALA    47      21.285  -8.556   5.971  1.00  8.87           N
ATOM    384  CA  ALA    47      21.038  -9.116   7.297  1.00  9.92           C
ATOM    385  CB  ALA    47      20.415  -8.078   8.221  1.00  9.39           C
ATOM    386  C   ALA    47      20.147 -10.359   7.209  1.00 10.55           C
ATOM    387  O   ALA    47      19.913 -11.025   8.214  1.00 11.19           O
ATOM    388  N   GLY    48      19.669 -10.665   6.000  1.00 10.64           N
ATOM    389  CA  GLY    48      18.837 -11.832   5.758  1.00 10.65           C
ATOM    390  C   GLY    48      17.370 -11.500   5.981  1.00 11.02           C
ATOM    391  O   GLY    48      16.527 -12.382   6.040  1.00 11.61           O
ATOM    392  N   PHE    49      17.058 -10.221   6.123  1.00 10.84           N
ATOM    393  CA  PHE    49      15.678  -9.843   6.300  1.00 10.34           C
ATOM    394  CB  PHE    49      15.553  -8.524   7.041  1.00 10.27           C
ATOM    395  CG  PHE    49      16.289  -8.482   8.367  1.00 10.53           C
ATOM    396  CD1 PHE    49      16.438  -9.629   9.151  1.00  9.15           C
ATOM    397  CE1 PHE    49      17.103  -9.572  10.380  1.00  8.21           C
ATOM    398  CZ  PHE    49      17.629  -8.371  10.827  1.00  6.77           C
ATOM    399  CE2 PHE    49      17.508  -7.237  10.048  1.00  8.64           C
ATOM    400  CD2 PHE    49      16.836  -7.296   8.822  1.00  7.85           C
ATOM    401  C   PHE    49      15.100  -9.743   4.921  1.00 10.17           C
ATOM    402  O   PHE    49      15.013  -8.653   4.357  1.00 11.58           O
ATOM    403  N   GLN    50      14.728 -10.898   4.375  1.00  8.82           N
ATOM    404  CA  GLN    50      14.202 -10.994   3.034  1.00  7.78           C
ATOM    405  CB  GLN    50      14.172 -12.463   2.634  1.00  7.84           C
ATOM    406  CG  GLN    50      13.041 -12.864   1.715  1.00  9.37           C
ATOM    410  C   GLN    50      12.807 -10.336   2.852  1.00  6.87           C
ATOM    411  O   GLN    50      12.495  -9.781   1.792  1.00  6.01           O
ATOM    412  N   MET    51      11.990 -10.386   3.902  1.00  5.70           N
ATOM    413  CA  MET    51      10.599  -9.939   3.838  0.50  5.02           C
ATOM    415  CB  MET    51       9.688 -11.156   3.635  0.50  5.14           C
ATOM    417  CG  MET    51       9.832 -11.859   2.288  0.50  6.48           C
ATOM    419  SD  MET    51       9.048 -10.903   0.976  0.50  9.57           S
ATOM    421  CE  MET    51       7.496 -10.519   1.767  0.50  9.06           C
ATOM    423  C   MET    51      10.212  -9.260   5.149  1.00  3.99           C
ATOM    424  O   MET    51      10.524  -9.765   6.213  1.00  4.09           O
ATOM    425  N   PRO    52       9.504  -8.123   5.086  1.00  3.02           N
ATOM    426  CA  PRO    52       9.134  -7.550   6.375  1.00  2.00           C
ATOM    427  CB  PRO    52       8.329  -6.297   5.996  1.00  2.00           C
ATOM    428  CG  PRO    52       7.949  -6.512   4.577  1.00  2.45           C
ATOM    429  CD  PRO    52       9.009  -7.330   3.954  1.00  2.00           C
ATOM    430  C   PRO    52       8.207  -8.466   7.127  1.00  2.00           C
ATOM    431  O   PRO    52       7.423  -9.216   6.512  1.00  2.00           O
ATOM    432  N   THR    53       8.251  -8.348   8.452  1.00  2.00           N
ATOM    433  CA  THR    53       7.363  -9.088   9.323  1.00  2.00           C
ATOM    434  CB  THR    53       7.910  -9.173  10.752  1.00  2.00           C
ATOM    435  OG1 THR    53       7.929  -7.863  11.336  1.00  2.00           O
ATOM    436  CG2 THR    53       9.302  -9.781  10.762  1.00  2.00           C
ATOM    437  C   THR    53       6.013  -8.372   9.336  1.00  2.00           C
ATOM    438  O   THR    53       5.923  -7.240   8.902  1.00  2.00           O
ATOM    439  N   PRO    54       4.951  -9.061   9.817  1.00  2.00           N
ATOM    440  CA  PRO    54       3.614  -8.446   9.836  1.00  2.00           C
ATOM    441  CB  PRO    54       2.764  -9.499  10.554  1.00  2.00           C
ATOM    442  CG  PRO    54       3.434 -10.845  10.109  1.00  2.00           C
ATOM    443  CD  PRO    54       4.913 -10.522  10.084  1.00  2.00           C
ATOM    444  C   PRO    54       3.575  -7.045  10.511  1.00  2.00           C
ATOM    445  O   PRO    54       2.921  -6.128   9.970  1.00  2.12           O
ATOM    446  N   ILE    55       4.286  -6.857  11.631  1.00  2.00           N
ATOM    447  CA  ILE    55       4.277  -5.552  12.311  1.00  2.00           C
ATOM    448  CB  ILE    55       4.798  -5.637  13.788  1.00  2.00           C
ATOM    449  CG1 ILE    55       4.445  -4.380  14.592  1.00  2.25           C
ATOM    450  CD1 ILE    55       2.939  -4.024  14.606  1.00  2.00           C
ATOM    451  CG2 ILE    55       6.303  -5.838  13.848  1.00  2.00           C
ATOM    452  C   ILE    55       5.031  -4.496  11.479  1.00  2.00           C
ATOM    453  O   ILE    55       4.572  -3.360  11.336  1.00  2.00           O
ATOM    454  N   GLN    56       6.172  -4.885  10.921  1.00  2.00           N
ATOM    455  CA  GLN    56       6.886  -4.046   9.958  1.00  2.00           C
ATOM    456  CB  GLN    56       8.151  -4.760   9.495  1.00  2.00           C
ATOM    457  CG  GLN    56       9.140  -4.972  10.662  1.00  2.00           C
ATOM    458  CD  GLN    56      10.206  -5.998  10.364  1.00  2.68           C
ATOM    459  OE1 GLN    56      10.304  -6.506   9.228  1.00  2.00           O
ATOM    460  NE2 GLN    56      11.013  -6.336  11.397  1.00  2.00           N
ATOM    461  C   GLN    56       6.012  -3.665   8.771  1.00  2.00           C
ATOM    462  O   GLN    56       5.979  -2.513   8.367  1.00  2.00           O
ATOM    463  N   MET    57       5.295  -4.632   8.209  1.00  2.00           N
ATOM    464  CA  MET    57       4.436  -4.374   7.048  1.00  2.00           C
ATOM    465  CB  MET    57       3.590  -5.610   6.715  1.00  2.00           C
ATOM    466  CG  MET    57       4.390  -6.774   6.183  1.00  2.00           C
ATOM    467  SD  MET    57       3.250  -8.128   5.782  1.00  2.36           S
ATOM    468  CE  MET    57       4.399  -9.242   4.913  1.00  2.00           C
ATOM    469  C   MET    57       3.510  -3.178   7.261  1.00  2.00           C
ATOM    470  O   MET    57       3.329  -2.347   6.356  1.00  2.00           O
ATOM    471  N   GLN    58       2.877  -3.113   8.430  1.00  2.00           N
ATOM    472  CA  GLN    58       1.941  -2.027   8.691  1.00  2.00           C
ATOM    473  CB  GLN    58       0.626  -2.532   9.308  1.00  2.00           C
ATOM    474  CG  GLN    58      -0.428  -1.426   9.490  1.00  2.00           C
ATOM    475  CD  GLN    58      -1.001  -0.929   8.177  1.00  2.00           C
ATOM    476  OE1 GLN    58      -1.953  -1.504   7.637  1.00  2.07           O
ATOM    477  NE2 GLN    58      -0.439   0.152   7.659  1.00  2.00           N
ATOM    478  C   GLN    58       2.523  -0.876   9.528  1.00  2.00           C
ATOM    479  O   GLN    58       2.118   0.265   9.361  1.00  2.31           O
ATOM    480  N   ALA    59       3.451  -1.156  10.433  1.00  2.00           N
ATOM    481  CA  ALA    59       3.966  -0.066  11.288  1.00  2.00           C
ATOM    482  CB  ALA    59       4.767  -0.610  12.451  1.00  2.00           C
ATOM    483  C   ALA    59       4.833   0.926  10.499  1.00  2.62           C
ATOM    484  O   ALA    59       4.805   2.132  10.746  1.00  2.00           O
ATOM    485  N   ILE    60       5.649   0.398   9.588  1.00  2.19           N
ATOM    486  CA  ILE    60       6.577   1.248   8.866  1.00  2.13           C
ATOM    487  CB  ILE    60       7.525   0.403   7.984  1.00  2.84           C
ATOM    488  CG1 ILE    60       8.507  -0.352   8.905  1.00  2.72           C
ATOM    489  CD1 ILE    60       9.371  -1.389   8.203  1.00  2.00           C
ATOM    490  CG2 ILE    60       8.257   1.278   6.969  1.00  2.00           C
ATOM    491  C   ILE    60       5.876   2.348   8.080  1.00  2.31           C
ATOM    492  O   ILE    60       6.241   3.532   8.195  1.00  2.00           O
ATOM    493  N   PRO    61       4.884   1.970   7.241  1.00  2.57           N
ATOM    494  CA  PRO    61       4.244   3.028   6.459  1.00  2.12           C
ATOM    495  CB  PRO    61       3.383   2.273   5.452  1.00  2.00           C
ATOM    496  CG  PRO    61       3.304   0.855   5.965  1.00  3.34           C
ATOM    497  CD  PRO    61       4.543   0.618   6.756  1.00  2.61           C
ATOM    498  C   PRO    61       3.420   3.982   7.338  1.00  2.11           C
ATOM    499  O   PRO    61       3.307   5.160   7.012  1.00  2.10           O
ATOM    500  N   VAL    62       2.884   3.500   8.459  1.00  2.00           N
ATOM    501  CA  VAL    62       2.221   4.401   9.390  1.00  2.00           C
ATOM    502  CB  VAL    62       1.589   3.678  10.592  1.00  2.00           C
ATOM    503  CG1 VAL    62       1.036   4.716  11.619  1.00  2.38           C
ATOM    504  CG2 VAL    62       0.437   2.750  10.116  1.00  2.00           C
ATOM    505  C   VAL    62       3.168   5.524   9.877  1.00  2.00           C
ATOM    506  O   VAL    62       2.783   6.682   9.881  1.00  2.00           O
ATOM    507  N   MET    63       4.391   5.170  10.273  1.00  2.00           N
ATOM    508  CA  MET    63       5.376   6.165  10.740  1.00  2.00           C
ATOM    509  CB  MET    63       6.544   5.475  11.473  1.00  2.00           C
ATOM    510  CG  MET    63       6.093   4.863  12.793  1.00  3.01           C
ATOM    511  SD  MET    63       7.416   4.028  13.721  1.00  2.45           S
ATOM    512  CE  MET    63       8.532   5.387  14.031  1.00  2.00           C
ATOM    513  C   MET    63       5.894   7.038   9.613  1.00  2.00           C
ATOM    514  O   MET    63       6.115   8.238   9.795  1.00  2.00           O
ATOM    515  N   LEU    64       6.060   6.446   8.433  1.00  2.00           N
ATOM    516  CA  LEU    64       6.559   7.193   7.312  1.00  2.00           C
ATOM    517  CB  LEU    64       6.878   6.264   6.106  1.00  2.00           C
ATOM    518  CG  LEU    64       8.097   5.312   6.217  1.00  2.00           C
ATOM    519  CD1 LEU    64       8.242   4.334   5.003  1.00  2.00           C
ATOM    520  CD2 LEU    64       9.395   6.073   6.409  1.00  2.00           C
ATOM    521  C   LEU    64       5.536   8.299   6.971  1.00  2.00           C
ATOM    522  O   LEU    64       5.919   9.381   6.543  1.00  2.00           O
ATOM    523  N   HIS    65       4.253   8.027   7.203  1.00  2.00           N
ATOM    524  CA  HIS    65       3.195   8.987   6.903  1.00  2.60           C
ATOM    525  CB  HIS    65       1.863   8.284   6.553  1.00  2.89           C
ATOM    526  CG  HIS    65       1.806   7.810   5.139  1.00  2.94           C
ATOM    527  ND1 HIS    65       1.119   8.481   4.152  1.00  5.30           N
ATOM    528  CE1 HIS    65       1.266   7.840   3.003  1.00  4.25           C
ATOM    529  NE2 HIS    65       2.040   6.789   3.208  1.00  3.79           N
ATOM    530  CD2 HIS    65       2.395   6.749   4.534  1.00  4.11           C
ATOM    531  C   HIS    65       2.995   9.978   8.028  1.00  3.62           C
ATOM    532  O   HIS    65       2.083  10.783   7.967  1.00  3.71           O
ATOM    533  N   GLY    66       3.867   9.936   9.043  1.00  3.80           N
ATOM    534  CA  GLY    66       3.801  10.915  10.123  1.00  3.84           C
ATOM    535  C   GLY    66       2.617  10.746  11.080  1.00  4.06           C
ATOM    536  O   GLY    66       2.163  11.726  11.693  1.00  4.10           O
ATOM    537  N   ARG    67       2.139   9.511  11.229  1.00  2.77           N
ATOM    538  CA  ARG    67       0.969   9.234  12.037  1.00  2.47           C
ATOM    539  CB  ARG    67       0.004   8.306  11.288  1.00  2.00           C
ATOM    540  CG  ARG    67      -0.658   8.986  10.043  1.00  2.00           C
ATOM    541  CD  ARG    67      -1.548  10.165  10.431  1.00  2.00           C
ATOM    542  NE  ARG    67      -2.656   9.676  11.231  1.00  2.00           N
ATOM    543  CZ  ARG    67      -3.725   9.049  10.737  1.00  3.82           C
ATOM    544  NH1 ARG    67      -3.872   8.866   9.422  1.00  4.83           N
ATOM    545  NH2 ARG    67      -4.664   8.615  11.560  1.00  3.19           N
ATOM    546  C   ARG    67       1.408   8.614  13.341  1.00  3.21           C
ATOM    547  O   ARG    67       2.270   7.744  13.338  1.00  3.81           O
ATOM    548  N   GLU    68       0.855   9.092  14.455  1.00  3.11           N
ATOM    549  CA  GLU    68       1.120   8.485  15.750  1.00  3.33           C
ATOM    550  CB  GLU    68       0.557   9.354  16.887  1.00  3.14           C
ATOM    551  CG  GLU    68       0.934  10.866  16.706  1.00  4.51           C
ATOM    552  CD  GLU    68       1.246  11.586  18.027  1.00  7.62           C
ATOM    553  OE1 GLU    68       0.321  11.841  18.816  1.00 11.49           O
ATOM    554  OE2 GLU    68       2.419  11.917  18.286  1.00  8.02           O
ATOM    555  C   GLU    68       0.561   7.077  15.773  1.00  3.85           C
ATOM    556  O   GLU    68      -0.427   6.777  15.094  1.00  4.04           O
ATOM    557  N   LEU    69       1.180   6.215  16.569  1.00  3.09           N
ATOM    558  CA  LEU    69       1.015   4.793  16.412  1.00  3.00           C
ATOM    559  CB  LEU    69       2.211   4.247  15.599  1.00  2.82           C
ATOM    560  CG  LEU    69       2.403   2.745  15.372  1.00  4.17           C
ATOM    561  CD1 LEU    69       1.227   2.120  14.586  1.00  5.87           C
ATOM    562  CD2 LEU    69       3.738   2.421  14.660  1.00  2.00           C
ATOM    563  C   LEU    69       1.014   4.113  17.766  1.00  2.93           C
ATOM    564  O   LEU    69       1.856   4.390  18.619  1.00  2.47           O
ATOM    565  N   LEU    70       0.074   3.211  17.961  1.00  3.47           N
ATOM    566  CA  LEU    70       0.215   2.203  19.002  1.00  4.88           C
ATOM    567  CB  LEU    70      -0.994   2.209  19.953  1.00  5.32           C
ATOM    568  CG  LEU    70      -1.060   1.042  20.952  1.00  9.07           C
ATOM    569  CD1 LEU    70       0.135   1.034  21.875  1.00 11.28           C
ATOM    570  CD2 LEU    70      -2.370   1.059  21.793  1.00  9.52           C
ATOM    571  C   LEU    70       0.344   0.863  18.276  1.00  5.01           C
ATOM    572  O   LEU    70      -0.567   0.456  17.558  1.00  5.32           O
ATOM    573  N   ALA    71       1.490   0.208  18.440  1.00  4.65           N
ATOM    574  CA  ALA    71       1.791  -1.027  17.751  1.00  4.52           C
ATOM    575  CB  ALA    71       3.038  -0.867  16.900  1.00  3.53           C
ATOM    576  C   ALA    71       2.010  -2.141  18.752  1.00  5.13           C
ATOM    577  O   ALA    71       2.853  -1.997  19.655  1.00  6.52           O
ATOM    578  N   SER    72       1.294  -3.251  18.580  1.00  4.10           N
ATOM    579  CA  SER    72       1.398  -4.381  19.487  1.00  4.12           C
ATOM    580  CB  SER    72       0.114  -4.568  20.325  1.00  4.46           C
ATOM    581  OG  SER    72      -0.237  -3.354  21.002  1.00 10.59           O
ATOM    582  C   SER    72       1.664  -5.652  18.720  1.00  3.39           C
ATOM    583  O   SER    72       0.954  -5.987  17.748  1.00  3.27           O
ATOM    584  N   ALA    73       2.668  -6.388  19.170  1.00  2.47           N
ATOM    585  CA  ALA    73       2.975  -7.679  18.585  1.00  2.45           C
ATOM    586  CB  ALA    73       3.727  -7.478  17.264  1.00  2.35           C
ATOM    587  C   ALA    73       3.835  -8.453  19.586  1.00  2.00           C
ATOM    588  O   ALA    73       4.648  -7.858  20.258  1.00  2.00           O
ATOM    589  N   PRO    74       3.670  -9.780  19.667  1.00  2.62           N
ATOM    590  CA  PRO    74       4.425 -10.575  20.664  1.00  2.95           C
ATOM    591  CB  PRO    74       4.066 -12.037  20.329  1.00  3.18           C
ATOM    592  CG  PRO    74       2.831 -11.980  19.469  1.00  3.56           C
ATOM    593  CD  PRO    74       2.768 -10.592  18.830  1.00  3.29           C
ATOM    594  C   PRO    74       5.937 -10.379  20.527  1.00  2.89           C
ATOM    595  O   PRO    74       6.410  -9.920  19.481  1.00  3.93           O
ATOM    596  N   THR    75       6.681 -10.674  21.579  1.00  2.00           N
ATOM    597  CA  THR    75       8.129 -10.846  21.482  1.00  2.28           C
ATOM    598  CB  THR    75       8.670 -11.503  22.801  1.00  2.76           C
ATOM    599  OG1 THR    75       8.280 -10.686  23.918  1.00  4.52           O
ATOM    600  CG2 THR    75      10.179 -11.637  22.788  1.00  2.48           C
ATOM    601  C   THR    75       8.533 -11.705  20.268  1.00  2.19           C
ATOM    602  O   THR    75       7.918 -12.735  19.975  1.00  2.22           O
ATOM    603  N   GLY    76       9.579 -11.287  19.562  1.00  2.00           N
ATOM    604  CA  GLY    76      10.046 -12.055  18.421  1.00  2.00           C
ATOM    605  C   GLY    76       9.407 -11.587  17.120  1.00  2.00           C
ATOM    606  O   GLY    76       9.570 -12.216  16.086  1.00  2.28           O
ATOM    607  N   SER    77       8.685 -10.481  17.154  1.00  2.00           N
ATOM    608  CA  SER    77       7.941 -10.080  15.975  1.00  2.00           C
ATOM    609  CB  SER    77       6.635  -9.399  16.387  1.00  2.00           C
ATOM    610  OG  SER    77       5.809 -10.325  17.065  1.00  2.05           O
ATOM    611  C   SER    77       8.701  -9.156  15.013  1.00  2.00           C
ATOM    612  O   SER    77       8.199  -8.910  13.918  1.00  2.00           O
ATOM    613  N   GLY    78       9.874  -8.659  15.437  1.00  2.00           N
ATOM    614  CA  GLY    78      10.666  -7.657  14.711  1.00  2.00           C
ATOM    615  C   GLY    78      10.248  -6.214  14.970  1.00  2.00           C
ATOM    616  O   GLY    78      10.280  -5.361  14.067  1.00  2.00           O
ATOM    617  N   LYS    79       9.842  -5.911  16.204  1.00  2.00           N
ATOM    618  CA  LYS    79       9.396  -4.551  16.505  1.00  2.00           C
ATOM    619  CB  LYS    79       8.665  -4.468  17.856  1.00  2.01           C
ATOM    620  CG  LYS    79       7.351  -5.229  17.876  1.00  2.00           C
ATOM    621  CD  LYS    79       6.554  -4.973  19.148  1.00  2.00           C
ATOM    622  CE  LYS    79       7.197  -5.686  20.342  1.00  2.75           C
ATOM    623  NZ  LYS    79       7.418  -7.177  20.125  1.00  2.00           N
ATOM    624  C   LYS    79      10.556  -3.541  16.451  1.00  2.37           C
ATOM    625  O   LYS    79      10.331  -2.376  16.122  1.00  2.00           O
ATOM    626  N   THR    80      11.796  -3.974  16.713  1.00  2.00           N
ATOM    627  CA  THR    80      12.921  -3.018  16.596  1.00  2.00           C
ATOM    628  CB  THR    80      14.269  -3.618  17.038  1.00  2.00           C
ATOM    629  OG1 THR    80      14.106  -4.198  18.327  1.00  3.32           O
ATOM    630  CG2 THR    80      15.361  -2.544  17.141  1.00  2.00           C
ATOM    631  C   THR    80      13.064  -2.434  15.200  1.00  2.03           C
ATOM    632  O   THR    80      13.161  -1.234  15.037  1.00  2.00           O
ATOM    633  N   LEU    81      13.045  -3.279  14.168  1.00  2.61           N
ATOM    634  CA  LEU    81      13.222  -2.754  12.814  1.00  3.14           C
ATOM    635  CB  LEU    81      13.462  -3.919  11.869  1.00  4.34           C
ATOM    636  CG  LEU    81      14.566  -3.711  10.896  1.00  8.83           C
ATOM    637  CD1 LEU    81      15.794  -3.641  11.784  1.00 12.92           C
ATOM    638  CD2 LEU    81      14.567  -4.933   9.911  1.00 11.75           C
ATOM    639  C   LEU    81      12.006  -1.973  12.343  1.00  2.84           C
ATOM    640  O   LEU    81      12.130  -1.034  11.520  1.00  2.37           O
ATOM    641  N   ALA    82      10.831  -2.381  12.836  1.00  2.00           N
ATOM    642  CA  ALA    82       9.572  -1.669  12.583  1.00  2.39           C
ATOM    643  CB  ALA    82       8.396  -2.352  13.314  1.00  2.00           C
ATOM    644  C   ALA    82       9.603  -0.163  12.947  1.00  2.88           C
ATOM    645  O   ALA    82       8.961   0.669  12.260  1.00  2.31           O
ATOM    646  N   PHE    83      10.306   0.189  14.029  1.00  2.48           N
ATOM    647  CA  PHE    83      10.511   1.621  14.303  1.00  3.05           C
ATOM    648  CB  PHE    83      10.226   2.002  15.768  1.00  2.70           C
ATOM    649  CG  PHE    83      11.113   1.319  16.792  1.00  4.42           C
ATOM    650  CD1 PHE    83      12.417   1.747  17.006  1.00  3.70           C
ATOM    651  CE1 PHE    83      13.216   1.146  17.996  1.00  2.00           C
ATOM    652  CZ  PHE    83      12.710   0.142  18.784  1.00  2.00           C
ATOM    653  CE2 PHE    83      11.393  -0.285  18.595  1.00  3.79           C
ATOM    654  CD2 PHE    83      10.606   0.304  17.603  1.00  4.41           C
ATOM    655  C   PHE    83      11.836   2.224  13.820  1.00  3.40           C
ATOM    656  O   PHE    83      11.918   3.437  13.618  1.00  2.94           O
ATOM    657  N   SER    84      12.851   1.388  13.596  1.00  2.76           N
ATOM    658  CA  SER    84      14.182   1.899  13.276  1.00  3.03           C
ATOM    659  CB  SER    84      15.231   0.823  13.581  1.00  2.28           C
ATOM    660  OG  SER    84      15.209   0.603  14.977  1.00  4.99           O
ATOM    661  C   SER    84      14.308   2.358  11.831  1.00  2.92           C
ATOM    662  O   SER    84      14.958   3.365  11.538  1.00  2.00           O
ATOM    663  N   ILE    85      13.699   1.575  10.934  1.00  2.00           N
ATOM    664  CA  ILE    85      13.707   1.884   9.519  1.00  2.00           C
ATOM    665  CB  ILE    85      13.043   0.728   8.700  1.00  2.00           C
ATOM    666  CG1 ILE    85      14.013  -0.477   8.618  1.00  2.00           C
ATOM    667  CD1 ILE    85      13.414  -1.658   7.850  1.00  2.00           C
ATOM    668  CG2 ILE    85      12.662   1.184   7.291  1.00  2.00           C
ATOM    669  C   ILE    85      13.044   3.212   9.191  1.00  2.00           C
ATOM    670  O   ILE    85      13.618   4.041   8.510  1.00  2.00           O
ATOM    671  N   PRO    86      11.824   3.418   9.659  1.00  2.00           N
ATOM    672  CA  PRO    86      11.180   4.698   9.366  1.00  2.00           C
ATOM    673  CB  PRO    86       9.775   4.557   9.979  1.00  2.00           C
ATOM    674  CG  PRO    86       9.739   3.315  10.697  1.00  2.00           C
ATOM    675  CD  PRO    86      10.912   2.449  10.291  1.00  2.00           C
ATOM    676  C   PRO    86      11.895   5.889  10.016  1.00  2.56           C
ATOM    677  O   PRO    86      11.934   6.966   9.428  1.00  3.83           O
ATOM    678  N   ILE    87      12.434   5.711  11.214  1.00  2.17           N
ATOM    679  CA  ILE    87      13.258   6.763  11.814  1.00  2.12           C
ATOM    680  CB  ILE    87      13.775   6.329  13.208  1.00  2.41           C
ATOM    681  CG1 ILE    87      12.618   6.402  14.214  1.00  2.71           C
ATOM    682  CD1 ILE    87      12.971   5.703  15.499  1.00  4.63           C
ATOM    683  CG2 ILE    87      14.981   7.173  13.656  1.00  2.00           C
ATOM    684  C   ILE    87      14.461   7.096  10.935  1.00  2.00           C
ATOM    685  O   ILE    87      14.716   8.258  10.630  1.00  2.15           O
ATOM    686  N   LEU    88      15.231   6.082  10.549  1.00  2.00           N
ATOM    687  CA  LEU    88      16.350   6.343   9.634  1.00  2.00           C
ATOM    688  CB  LEU    88      17.093   5.038   9.367  1.00  2.00           C
ATOM    689  CG  LEU    88      17.805   4.450  10.583  1.00  2.54           C
ATOM    690  CD1 LEU    88      18.288   3.037  10.235  1.00  2.00           C
ATOM    691  CD2 LEU    88      18.987   5.353  11.039  1.00  2.00           C
ATOM    692  C   LEU    88      15.915   6.977   8.304  1.00  2.00           C
ATOM    693  O   LEU    88      16.578   7.891   7.784  1.00  2.00           O
ATOM    694  N   MET    89      14.827   6.463   7.726  1.00  2.00           N
ATOM    695  CA  MET    89      14.320   7.002   6.460  1.00  2.00           C
ATOM    696  CB  MET    89      13.151   6.161   5.945  1.00  2.00           C
ATOM    697  CG  MET    89      13.552   4.799   5.480  1.00  3.11           C
ATOM    698  SD  MET    89      12.178   3.813   4.889  1.00  2.61           S
ATOM    699  CE  MET    89      11.669   4.767   3.476  1.00  2.00           C
ATOM    700  C   MET    89      13.871   8.460   6.571  1.00  2.00           C
ATOM    701  O   MET    89      14.167   9.280   5.701  1.00  2.00           O
ATOM    702  N   GLN    90      13.142   8.775   7.641  1.00  2.20           N
ATOM    703  CA  GLN    90      12.672  10.145   7.870  1.00  2.77           C
ATOM    704  CB  GLN    90      11.746  10.223   9.101  1.00  3.27           C
ATOM    705  CG  GLN    90      11.113  11.643   9.262  1.00  6.16           C
ATOM    706  CD  GLN    90       9.921  11.690  10.217  1.00 11.29           C
ATOM    707  OE1 GLN    90       8.946  10.928  10.082  1.00 11.99           O
ATOM    708  NE2 GLN    90       9.977  12.607  11.169  1.00 13.52           N
ATOM    709  C   GLN    90      13.839  11.103   8.056  1.00  2.64           C
ATOM    710  O   GLN    90      13.865  12.217   7.497  1.00  2.68           O
ATOM    711  N   LEU    91      14.833  10.676   8.829  1.00  2.94           N
ATOM    712  CA  LEU    91      15.930  11.578   9.151  1.00  2.56           C
ATOM    713  CB  LEU    91      16.769  11.006  10.282  1.00  2.98           C
ATOM    714  CG  LEU    91      16.111  10.876  11.662  1.00  4.89           C
ATOM    715  CD1 LEU    91      17.152  10.647  12.756  1.00  2.00           C
ATOM    716  CD2 LEU    91      15.273  12.104  11.976  1.00  7.22           C
ATOM    717  C   LEU    91      16.808  11.874   7.906  1.00  3.02           C
ATOM    718  O   LEU    91      17.500  12.898   7.854  1.00  2.00           O
ATOM    719  N   LYS    92      16.749  10.964   6.931  1.00  3.61           N
ATOM    720  CA  LYS    92      17.442  11.063   5.630  1.00  5.29           C
ATOM    721  CB  LYS    92      17.013  12.332   4.874  1.00  5.67           C
ATOM    722  CG  LYS    92      15.534  12.413   4.631  1.00  9.99           C
ATOM    723  CD  LYS    92      15.180  13.725   3.945  1.00 15.63           C
ATOM    724  CE  LYS    92      13.804  13.621   3.319  1.00 19.94           C
ATOM    725  NZ  LYS    92      13.651  12.321   2.584  1.00 21.82           N
ATOM    726  C   LYS    92      18.967  10.983   5.662  1.00  5.67           C
ATOM    727  O   LYS    92      19.566  10.142   4.976  1.00  6.66           O
ATOM    728  N   GLN    93      19.589  11.897   6.405  1.00  5.46           N
ATOM    729  CA  GLN    93      21.045  12.032   6.441  1.00  5.18           C
ATOM    730  CB  GLN    93      21.555  13.177   5.535  1.00  5.51           C
ATOM    731  CG  GLN    93      21.266  13.102   4.027  1.00  8.17           C
ATOM    732  CD  GLN    93      21.817  14.343   3.323  1.00 11.14           C
ATOM    733  OE1 GLN    93      22.946  14.770   3.591  1.00 15.39           O
ATOM    734  NE2 GLN    93      21.023  14.942   2.453  1.00 12.80           N
ATOM    735  C   GLN    93      21.467  12.409   7.839  1.00  4.54           C
ATOM    736  O   GLN    93      20.721  13.104   8.544  1.00  3.67           O
ATOM    737  N   PRO    94      22.691  11.997   8.226  1.00  4.14           N
ATOM    738  CA  PRO    94      23.272  12.456   9.478  1.00  4.11           C
ATOM    739  CB  PRO    94      24.724  11.970   9.412  1.00  3.31           C
ATOM    740  CG  PRO    94      24.849  11.137   8.158  1.00  3.98           C
ATOM    741  CD  PRO    94      23.537  11.025   7.504  1.00  4.01           C
ATOM    742  C   PRO    94      23.248  13.973   9.460  1.00  4.37           C
ATOM    743  O   PRO    94      23.379  14.570   8.408  1.00  3.84           O
ATOM    744  N   ALA    95      23.093  14.603  10.616  1.00  4.85           N
ATOM    745  CA  ALA    95      23.059  16.058  10.653  1.00  5.05           C
ATOM    746  CB  ALA    95      21.601  16.587  10.447  1.00  4.19           C
ATOM    747  C   ALA    95      23.625  16.539  11.980  1.00  5.56           C
ATOM    748  O   ALA    95      23.797  15.744  12.893  1.00  5.25           O
ATOM    749  N   ASN    96      23.892  17.842  12.071  1.00  5.99           N
ATOM    750  CA  ASN    96      24.551  18.431  13.225  1.00  7.05           C
ATOM    751  CB  ASN    96      25.730  19.316  12.791  1.00  6.79           C
ATOM    755  C   ASN    96      23.556  19.237  14.036  1.00  7.61           C
ATOM    756  O   ASN    96      23.886  20.285  14.580  1.00  7.55           O
ATOM    757  N   LYS    97      22.331  18.712  14.118  1.00  8.01           N
ATOM    758  CA  LYS    97      21.205  19.404  14.734  1.00  7.98           C
ATOM    759  CB  LYS    97      19.945  19.196  13.854  1.00  8.66           C
ATOM    760  CG  LYS    97      19.648  20.246  12.750  1.00  9.51           C
ATOM    761  CD  LYS    97      20.770  21.221  12.504  1.00 11.14           C
ATOM    764  C   LYS    97      20.920  18.847  16.131  1.00  7.75           C
ATOM    765  O   LYS    97      19.918  19.198  16.732  1.00  7.92           O
ATOM    766  N   GLY    98      21.765  17.942  16.629  1.00  6.64           N
ATOM    767  CA  GLY    98      21.469  17.262  17.911  1.00  4.72           C
ATOM    768  C   GLY    98      20.448  16.171  17.672  1.00  3.30           C
ATOM    769  O   GLY    98      20.003  16.000  16.538  1.00  3.19           O
ATOM    770  N   PHE    99      20.030  15.460  18.723  1.00  2.62           N
ATOM    771  CA  PHE    99      19.193  14.254  18.523  1.00  2.00           C
ATOM    772  CB  PHE    99      18.920  13.517  19.833  1.00  2.00           C
ATOM    773  CG  PHE    99      20.144  12.939  20.458  1.00  2.82           C
ATOM    774  CD1 PHE    99      20.807  11.884  19.860  1.00  4.02           C
ATOM    775  CE1 PHE    99      21.958  11.341  20.437  1.00  4.64           C
ATOM    776  CZ  PHE    99      22.440  11.853  21.632  1.00  6.05           C
ATOM    777  CE2 PHE    99      21.788  12.916  22.237  1.00  6.13           C
ATOM    778  CD2 PHE    99      20.637  13.451  21.653  1.00  4.45           C
ATOM    779  C   PHE    99      17.879  14.560  17.845  1.00  2.00           C
ATOM    780  O   PHE    99      17.141  15.436  18.289  1.00  2.00           O
ATOM    781  N   ARG   100      17.593  13.824  16.777  1.00  2.00           N
ATOM    782  CA  ARG   100      16.347  14.003  16.029  1.00  2.00           C
ATOM    783  CB  ARG   100      16.636  14.226  14.534  1.00  2.00           C
ATOM    784  CG  ARG   100      17.194  15.663  14.239  1.00  2.00           C
ATOM    785  CD  ARG   100      17.570  15.857  12.763  1.00  2.00           C
ATOM    786  NE  ARG   100      18.702  14.983  12.442  1.00  2.00           N
ATOM    787  CZ  ARG   100      18.848  14.363  11.281  1.00  2.00           C
ATOM    788  NH1 ARG   100      17.939  14.536  10.318  1.00  2.00           N
ATOM    789  NH2 ARG   100      19.894  13.569  11.082  1.00  2.00           N
ATOM    790  C   ARG   100      15.389  12.845  16.260  1.00  2.00           C
ATOM    791  O   ARG   100      14.286  12.805  15.747  1.00  2.00           O
ATOM    792  N   ALA   101      15.818  11.891  17.056  1.00  2.00           N
ATOM    793  CA  ALA   101      14.955  10.779  17.358  1.00  2.00           C
ATOM    794  CB  ALA   101      14.984   9.708  16.249  1.00  2.00           C
ATOM    795  C   ALA   101      15.399  10.225  18.683  1.00  2.00           C
ATOM    796  O   ALA   101      16.577  10.283  19.019  1.00  2.00           O
ATOM    797  N   LEU   102      14.438   9.694  19.411  1.00  2.00           N
ATOM    798  CA  LEU   102      14.628   9.293  20.789  1.00  2.68           C
ATOM    799  CB  LEU   102      14.087  10.411  21.707  1.00  3.10           C
ATOM    800  CG  LEU   102      14.000  10.196  23.215  1.00  5.28           C
ATOM    801  CD1 LEU   102      15.328   9.757  23.804  1.00 11.18           C
ATOM    802  CD2 LEU   102      13.480  11.465  23.900  1.00 10.50           C
ATOM    803  C   LEU   102      13.841   8.008  21.017  1.00  2.36           C
ATOM    804  O   LEU   102      12.646   7.984  20.817  1.00  2.00           O
ATOM    805  N   ILE   103      14.509   6.960  21.471  1.00  2.00           N
ATOM    806  CA  ILE   103      13.842   5.699  21.715  1.00  2.00           C
ATOM    807  CB  ILE   103      14.530   4.571  20.899  1.00  2.00           C
ATOM    808  CG1 ILE   103      14.256   4.789  19.391  1.00  2.00           C
ATOM    809  CD1 ILE   103      15.330   4.253  18.435  1.00  2.00           C
ATOM    810  CG2 ILE   103      14.035   3.219  21.402  1.00  2.00           C
ATOM    811  C   ILE   103      13.995   5.379  23.192  1.00  2.00           C
ATOM    812  O   ILE   103      15.105   5.367  23.705  1.00  2.00           O
ATOM    813  N   ILE   104      12.892   5.116  23.860  1.00  2.00           N
ATOM    814  CA  ILE   104      12.894   4.833  25.276  1.00  2.92           C
ATOM    815  CB  ILE   104      11.850   5.738  25.979  1.00  3.13           C
ATOM    816  CG1 ILE   104      12.324   7.190  25.955  1.00  6.62           C
ATOM    817  CD1 ILE   104      11.146   8.150  26.134  1.00 11.71           C
ATOM    818  CG2 ILE   104      11.605   5.338  27.421  1.00  5.31           C
ATOM    819  C   ILE   104      12.587   3.353  25.490  1.00  2.55           C
ATOM    820  O   ILE   104      11.620   2.806  24.943  1.00  2.64           O
ATOM    821  N   SER   105      13.417   2.703  26.280  1.00  2.48           N
ATOM    822  CA  SER   105      13.259   1.287  26.544  1.00  3.30           C
ATOM    823  CB  SER   105      14.324   0.532  25.733  1.00  3.85           C
ATOM    824  OG  SER   105      14.528  -0.788  26.190  1.00  7.51           O
ATOM    825  C   SER   105      13.425   1.116  28.044  1.00  3.08           C
ATOM    826  O   SER   105      14.031   1.978  28.682  1.00  2.39           O
ATOM    827  N   PRO   106      12.870   0.017  28.627  1.00  3.28           N
ATOM    828  CA  PRO   106      12.837  -0.123  30.085  1.00  3.43           C
ATOM    829  CB  PRO   106      12.050  -1.441  30.306  1.00  4.16           C
ATOM    830  CG  PRO   106      11.330  -1.706  29.026  1.00  3.07           C
ATOM    831  CD  PRO   106      12.204  -1.115  27.950  1.00  3.01           C
ATOM    832  C   PRO   106      14.207  -0.223  30.765  1.00  3.80           C
ATOM    833  O   PRO   106      14.375   0.279  31.880  1.00  2.85           O
ATOM    834  N   THR   107      15.170  -0.877  30.126  1.00  3.73           N
ATOM    835  CA  THR   107      16.429  -1.149  30.821  1.00  4.76           C
ATOM    836  CB  THR   107      16.501  -2.613  31.359  1.00  4.32           C
ATOM    837  OG1 THR   107      16.383  -3.540  30.270  1.00  6.22           O
ATOM    838  CG2 THR   107      15.396  -2.885  32.363  1.00  4.98           C
ATOM    839  C   THR   107      17.658  -0.893  29.962  1.00  5.12           C
ATOM    840  O   THR   107      17.565  -0.841  28.740  1.00  4.73           O
ATOM    841  N   ARG   108      18.804  -0.710  30.622  1.00  5.75           N
ATOM    842  CA  ARG   108      20.093  -0.699  29.942  1.00  6.24           C
ATOM    843  CB  ARG   108      21.244  -0.669  30.971  1.00  6.48           C
ATOM    844  CG  ARG   108      22.626  -0.554  30.332  1.00  9.74           C
ATOM    845  CD  ARG   108      23.752  -0.526  31.355  1.00 13.87           C
ATOM    846  NE  ARG   108      23.490  -1.420  32.477  1.00 17.31           N
ATOM    847  CZ  ARG   108      23.059  -1.008  33.667  1.00 17.75           C
ATOM    848  NH1 ARG   108      22.852   0.284  33.891  1.00 18.97           N
ATOM    849  NH2 ARG   108      22.840  -1.883  34.633  1.00 17.54           N
ATOM    850  C   ARG   108      20.242  -1.898  28.983  1.00  5.78           C
ATOM    851  O   ARG   108      20.658  -1.711  27.840  1.00  6.04           O
ATOM    852  N   GLU   109      19.900  -3.112  29.446  1.00  5.39           N
ATOM    853  CA  GLU   109      20.001  -4.343  28.637  1.00  5.47           C
ATOM    854  CB  GLU   109      19.490  -5.574  29.414  1.00  5.95           C
ATOM    855  CG  GLU   109      20.008  -5.720  30.846  1.00  9.99           C
ATOM    856  CD  GLU   109      19.128  -5.019  31.915  1.00 13.36           C
ATOM    857  OE1 GLU   109      18.055  -5.578  32.307  1.00 12.23           O
ATOM    858  OE2 GLU   109      19.541  -3.923  32.380  1.00 13.33           O
ATOM    859  C   GLU   109      19.216  -4.239  27.331  1.00  4.33           C
ATOM    860  O   GLU   109      19.752  -4.436  26.231  1.00  3.59           O
ATOM    861  N   LEU   110      17.937  -3.914  27.453  1.00  3.40           N
ATOM    862  CA  LEU   110      17.094  -3.800  26.274  1.00  2.93           C
ATOM    863  CB  LEU   110      15.625  -3.720  26.668  1.00  2.90           C
ATOM    864  CG  LEU   110      15.178  -5.006  27.372  1.00  4.84           C
ATOM    865  CD1 LEU   110      13.763  -4.890  27.946  1.00  7.07           C
ATOM    866  CD2 LEU   110      15.307  -6.208  26.469  1.00  4.99           C
ATOM    867  C   LEU   110      17.506  -2.613  25.397  1.00  2.63           C
ATOM    868  O   LEU   110      17.468  -2.710  24.178  1.00  2.00           O
ATOM    869  N   ALA   111      17.871  -1.495  26.019  1.00  2.83           N
ATOM    870  CA  ALA   111      18.388  -0.341  25.273  1.00  3.71           C
ATOM    871  CB  ALA   111      18.667   0.854  26.204  1.00  2.80           C
ATOM    872  C   ALA   111      19.641  -0.728  24.480  1.00  4.78           C
ATOM    873  O   ALA   111      19.769  -0.407  23.288  1.00  4.84           O
ATOM    874  N   SER   112      20.563  -1.434  25.126  1.00  6.27           N
ATOM    875  CA  SER   112      21.794  -1.791  24.428  1.00  7.57           C
ATOM    876  CB  SER   112      22.806  -2.459  25.360  1.00  7.45           C
ATOM    877  OG  SER   112      22.466  -3.823  25.495  1.00 12.33           O
ATOM    878  C   SER   112      21.525  -2.640  23.165  1.00  7.23           C
ATOM    879  O   SER   112      22.145  -2.405  22.128  1.00  5.94           O
ATOM    880  N   GLN   113      20.574  -3.578  23.239  1.00  7.50           N
ATOM    881  CA  GLN   113      20.190  -4.370  22.056  1.00  7.95           C
ATOM    882  CB  GLN   113      19.224  -5.504  22.421  1.00  9.10           C
ATOM    883  CG  GLN   113      19.803  -6.597  23.301  1.00 15.35           C
ATOM    884  CD  GLN   113      18.744  -7.602  23.705  1.00 20.73           C
ATOM    885  OE1 GLN   113      18.007  -7.393  24.671  1.00 23.30           O
ATOM    886  NE2 GLN   113      18.653  -8.698  22.954  1.00 23.56           N
ATOM    887  C   GLN   113      19.572  -3.531  20.923  1.00  6.67           C
ATOM    888  O   GLN   113      19.860  -3.759  19.737  1.00  5.80           O
ATOM    889  N   ILE   114      18.703  -2.579  21.262  1.00  5.06           N
ATOM    890  CA  ILE   114      18.209  -1.670  20.233  1.00  4.34           C
ATOM    891  CB  ILE   114      17.156  -0.680  20.793  1.00  5.00           C
ATOM    892  CG1 ILE   114      15.855  -1.431  21.147  1.00  5.80           C
ATOM    893  CD1 ILE   114      14.988  -0.711  22.207  1.00  5.98           C
ATOM    894  CG2 ILE   114      16.911   0.454  19.814  1.00  4.99           C
ATOM    895  C   ILE   114      19.371  -0.892  19.613  1.00  4.38           C
ATOM    896  O   ILE   114      19.452  -0.707  18.397  1.00  3.41           O
ATOM    897  N   HIS   115      20.281  -0.429  20.452  1.00  4.02           N
ATOM    898  CA  HIS   115      21.414   0.354  19.963  1.00  5.12           C
ATOM    899  CB  HIS   115      22.276   0.791  21.171  1.00  4.94           C
ATOM    900  CG  HIS   115      23.448   1.639  20.808  1.00  4.43           C
ATOM    901  ND1 HIS   115      24.744   1.186  20.868  1.00  8.16           N
ATOM    902  CE1 HIS   115      25.567   2.155  20.517  1.00  7.33           C
ATOM    903  NE2 HIS   115      24.846   3.223  20.230  1.00  6.55           N
ATOM    904  CD2 HIS   115      23.519   2.925  20.403  1.00  5.61           C
ATOM    905  C   HIS   115      22.252  -0.459  18.941  1.00  5.67           C
ATOM    906  O   HIS   115      22.635   0.048  17.869  1.00  5.57           O
ATOM    907  N   ARG   116      22.540  -1.715  19.265  1.00  6.93           N
ATOM    908  CA  ARG   116      23.320  -2.556  18.359  1.00  8.35           C
ATOM    909  CB  ARG   116      23.750  -3.858  19.061  1.00  9.22           C
ATOM    910  CG  ARG   116      24.782  -3.632  20.153  1.00 11.28           C
ATOM    911  CD  ARG   116      25.399  -4.933  20.636  1.00 16.80           C
ATOM    912  NE  ARG   116      26.241  -5.571  19.621  1.00 21.11           N
ATOM    913  CZ  ARG   116      27.239  -6.406  19.911  1.00 21.97           C
ATOM    914  NH1 ARG   116      27.504  -6.699  21.183  1.00 22.55           N
ATOM    915  NH2 ARG   116      27.971  -6.952  18.943  1.00 21.73           N
ATOM    916  C   ARG   116      22.609  -2.839  17.016  1.00  8.58           C
ATOM    917  O   ARG   116      23.240  -2.848  15.956  1.00  9.07           O
ATOM    918  N   GLU   117      21.309  -3.085  17.071  1.00  8.39           N
ATOM    919  CA  GLU   117      20.528  -3.315  15.868  1.00  9.36           C
ATOM    920  CB  GLU   117      19.080  -3.651  16.232  1.00  9.61           C
ATOM    921  CG  GLU   117      18.180  -3.895  15.025  1.00 14.15           C
ATOM    922  CD  GLU   117      18.004  -5.400  14.739  1.00 20.80           C
ATOM    923  OE1 GLU   117      19.035  -6.104  14.634  1.00 21.79           O
ATOM    924  OE2 GLU   117      16.837  -5.871  14.644  1.00 24.25           O
ATOM    925  C   GLU   117      20.585  -2.065  14.965  1.00  8.68           C
ATOM    926  O   GLU   117      20.785  -2.169  13.755  1.00  8.54           O
ATOM    927  N   LEU   118      20.445  -0.888  15.564  1.00  7.27           N
ATOM    928  CA  LEU   118      20.543   0.358  14.806  1.00  7.76           C
ATOM    929  CB  LEU   118      20.237   1.571  15.702  1.00  7.42           C
ATOM    930  CG  LEU   118      18.764   1.954  15.829  1.00  7.92           C
ATOM    931  CD1 LEU   118      18.488   2.869  17.054  1.00  8.32           C
ATOM    932  CD2 LEU   118      18.276   2.606  14.542  1.00  6.55           C
ATOM    933  C   LEU   118      21.924   0.535  14.175  1.00  7.42           C
ATOM    934  O   LEU   118      22.048   0.967  13.022  1.00  7.74           O
ATOM    935  N   ILE   119      22.954   0.257  14.955  1.00  6.50           N
ATOM    936  CA  ILE   119      24.307   0.407  14.488  1.00  6.76           C
ATOM    937  CB  ILE   119      25.324  -0.048  15.553  1.00  6.73           C
ATOM    938  CG1 ILE   119      25.377   0.962  16.700  1.00  7.32           C
ATOM    939  CD1 ILE   119      25.589   2.336  16.211  1.00  8.63           C
ATOM    940  CG2 ILE   119      26.703  -0.226  14.932  1.00  5.63           C
ATOM    941  C   ILE   119      24.467  -0.483  13.269  1.00  7.02           C
ATOM    942  O   ILE   119      24.972  -0.047  12.239  1.00  6.37           O
ATOM    943  N   LYS   120      24.002  -1.728  13.387  1.00  7.26           N
ATOM    944  CA  LYS   120      24.234  -2.719  12.337  1.00  7.41           C
ATOM    945  CB  LYS   120      23.900  -4.129  12.841  1.00  7.82           C
ATOM    946  CG  LYS   120      24.586  -5.263  12.083  1.00 11.90           C
ATOM    947  CD  LYS   120      23.801  -6.553  12.270  1.00 16.51           C
ATOM    948  CE  LYS   120      22.459  -6.496  11.510  1.00 18.66           C
ATOM    949  NZ  LYS   120      21.406  -7.252  12.249  1.00 21.96           N
ATOM    950  C   LYS   120      23.465  -2.374  11.053  1.00  6.64           C
ATOM    951  O   LYS   120      24.051  -2.371   9.968  1.00  6.78           O
ATOM    952  N   ILE   121      22.175  -2.047  11.175  1.00  5.79           N
ATOM    953  CA  ILE   121      21.364  -1.766   9.984  0.50  5.80           C
ATOM    955  CB  ILE   121      19.824  -1.783  10.237  0.50  5.78           C
ATOM    957  CG1 ILE   121      19.391  -0.613  11.126  0.50  4.91           C
ATOM    959  CD1 ILE   121      17.936  -0.272  10.967  0.50  2.62           C
ATOM    961  CG2 ILE   121      19.361  -3.128  10.790  0.50  7.00           C
ATOM    963  C   ILE   121      21.737  -0.442   9.340  1.00  5.51           C
ATOM    964  O   ILE   121      21.449  -0.203   8.168  1.00  6.07           O
ATOM    965  N   SER   122      22.424   0.414  10.068  1.00  5.61           N
ATOM    966  CA  SER   122      22.780   1.704   9.498  1.00  5.53           C
ATOM    967  CB  SER   122      22.372   2.854  10.439  1.00  6.02           C
ATOM    968  OG  SER   122      23.234   2.952  11.569  1.00  6.51           O
ATOM    969  C   SER   122      24.250   1.808   9.093  1.00  5.41           C
ATOM    970  O   SER   122      24.705   2.878   8.684  1.00  5.28           O
ATOM    971  N   GLU   123      24.990   0.697   9.158  1.00  5.57           N
ATOM    972  CA  GLU   123      26.402   0.719   8.783  1.00  6.04           C
ATOM    973  CB  GLU   123      26.998  -0.694   8.762  1.00  7.03           C
ATOM    974  CG  GLU   123      27.265  -1.228  10.146  1.00 10.40           C
ATOM    975  CD  GLU   123      27.928  -2.592  10.122  1.00 16.71           C
ATOM    976  OE1 GLU   123      28.176  -3.138   9.010  1.00 18.65           O
ATOM    977  OE2 GLU   123      28.196  -3.120  11.226  1.00 19.05           O
ATOM    978  C   GLU   123      26.622   1.399   7.439  1.00  5.58           C
ATOM    979  O   GLU   123      25.891   1.135   6.457  1.00  5.05           O
ATOM    980  N   GLY   124      27.617   2.277   7.395  1.00  4.24           N
ATOM    981  CA  GLY   124      27.957   2.970   6.159  1.00  3.98           C
ATOM    982  C   GLY   124      27.079   4.158   5.779  1.00  3.83           C
ATOM    983  O   GLY   124      27.319   4.781   4.759  1.00  3.96           O
ATOM    984  N   THR   125      26.071   4.479   6.593  1.00  3.61           N
ATOM    985  CA  THR   125      25.171   5.603   6.329  1.00  3.88           C
ATOM    986  CB  THR   125      23.719   5.285   6.790  1.00  3.79           C
ATOM    987  OG1 THR   125      23.635   5.329   8.224  1.00  2.98           O
ATOM    988  CG2 THR   125      23.292   3.903   6.295  1.00  5.14           C
ATOM    989  C   THR   125      25.594   6.892   7.025  1.00  4.01           C
ATOM    990  O   THR   125      25.047   7.975   6.739  1.00  4.24           O
ATOM    991  N   GLY   126      26.509   6.763   7.986  1.00  3.16           N
ATOM    992  CA  GLY   126      26.991   7.896   8.764  1.00  3.02           C
ATOM    993  C   GLY   126      26.126   8.369   9.924  1.00  2.57           C
ATOM    994  O   GLY   126      26.458   9.350  10.569  1.00  2.12           O
ATOM    995  N   PHE   127      24.993   7.721  10.174  1.00  3.20           N
ATOM    996  CA  PHE   127      24.185   8.100  11.346  1.00  2.65           C
ATOM    997  CB  PHE   127      22.818   7.420  11.353  1.00  3.03           C
ATOM    998  CG  PHE   127      21.811   8.082  10.454  1.00  4.00           C
ATOM    999  CD1 PHE   127      21.113   9.208  10.880  1.00  4.40           C
ATOM   1000  CE1 PHE   127      20.186   9.841  10.040  1.00  2.17           C
ATOM   1001  CZ  PHE   127      19.955   9.342   8.796  1.00  3.15           C
ATOM   1002  CE2 PHE   127      20.621   8.202   8.366  1.00  3.16           C
ATOM   1003  CD2 PHE   127      21.561   7.586   9.183  1.00  2.91           C
ATOM   1004  C   PHE   127      24.935   7.766  12.647  1.00  2.77           C
ATOM   1005  O   PHE   127      25.556   6.706  12.774  1.00  2.00           O
ATOM   1006  N   ARG   128      24.857   8.686  13.600  1.00  2.53           N
ATOM   1007  CA  ARG   128      25.471   8.512  14.905  1.00  3.52           C
ATOM   1008  CB  ARG   128      26.287   9.757  15.260  1.00  3.97           C
ATOM   1009  CG  ARG   128      27.535   9.823  14.398  1.00  7.72           C
ATOM   1010  CD  ARG   128      27.795  11.209  13.917  1.00 11.74           C
ATOM   1011  NE  ARG   128      26.517  11.828  13.563  1.00 13.54           N
ATOM   1012  CZ  ARG   128      26.392  13.088  13.169  1.00 10.99           C
ATOM   1013  NH1 ARG   128      27.495  13.850  13.047  1.00 10.55           N
ATOM   1014  NH2 ARG   128      25.191  13.563  12.879  1.00  4.20           N
ATOM   1015  C   ARG   128      24.388   8.215  15.933  1.00  3.59           C
ATOM   1016  O   ARG   128      23.474   9.017  16.178  1.00  3.03           O
ATOM   1017  N   ILE   129      24.471   7.024  16.500  1.00  3.61           N
ATOM   1018  CA  ILE   129      23.449   6.543  17.388  1.00  3.38           C
ATOM   1019  CB  ILE   129      22.873   5.265  16.837  1.00  3.90           C
ATOM   1020  CG1 ILE   129      22.297   5.513  15.431  1.00  5.13           C
ATOM   1021  CD1 ILE   129      22.597   4.385  14.452  1.00  5.34           C
ATOM   1022  CG2 ILE   129      21.843   4.676  17.796  1.00  2.38           C
ATOM   1023  C   ILE   129      24.147   6.276  18.709  1.00  4.22           C
ATOM   1024  O   ILE   129      25.225   5.666  18.750  1.00  3.31           O
ATOM   1025  N   HIS   130      23.550   6.753  19.788  1.00  4.46           N
ATOM   1026  CA  HIS   130      24.240   6.805  21.068  1.00  5.28           C
ATOM   1027  CB  HIS   130      24.653   8.249  21.391  1.00  5.77           C
ATOM   1028  CG  HIS   130      25.719   8.786  20.496  1.00  8.01           C
ATOM   1029  ND1 HIS   130      27.051   8.470  20.655  1.00 12.01           N
ATOM   1030  CE1 HIS   130      27.761   9.075  19.715  1.00 11.42           C
ATOM   1031  NE2 HIS   130      26.931   9.758  18.944  1.00 11.39           N
ATOM   1032  CD2 HIS   130      25.649   9.592  19.407  1.00  8.29           C
ATOM   1033  C   HIS   130      23.361   6.307  22.193  1.00  4.99           C
ATOM   1034  O   HIS   130      22.137   6.374  22.117  1.00  3.70           O
ATOM   1035  N   MET   131      24.005   5.811  23.233  1.00  5.47           N
ATOM   1036  CA  MET   131      23.395   5.704  24.542  1.00  6.59           C
ATOM   1037  CB  MET   131      23.569   4.289  25.089  1.00  6.48           C
ATOM   1038  CG  MET   131      22.939   3.255  24.175  1.00  8.78           C
ATOM   1039  SD  MET   131      22.701   1.658  24.951  1.00  9.07           S
ATOM   1040  CE  MET   131      24.337   0.955  24.850  1.00 13.73           C
ATOM   1041  C   MET   131      24.178   6.728  25.360  1.00  7.00           C
ATOM   1042  O   MET   131      25.341   6.997  25.052  1.00  7.28           O
ATOM   1043  N   ILE   132      23.564   7.338  26.363  1.00  7.35           N
ATOM   1044  CA  ILE   132      24.318   8.245  27.214  1.00  7.34           C
ATOM   1045  CB  ILE   132      23.625   9.612  27.363  1.00  7.59           C
ATOM   1046  CG1 ILE   132      23.469  10.281  25.985  1.00  6.69           C
ATOM   1047  CD1 ILE   132      22.551  11.485  25.985  1.00  7.48           C
ATOM   1048  CG2 ILE   132      24.438  10.489  28.330  1.00  7.04           C
ATOM   1049  C   ILE   132      24.643   7.624  28.598  1.00  7.77           C
ATOM   1050  O   ILE   132      23.787   7.504  29.480  1.00  7.79           O
ATOM   1051  N   HIS   133      25.891   7.223  28.763  1.00  7.80           N
ATOM   1052  CA  HIS   133      26.340   6.557  29.971  1.00  8.35           C
ATOM   1053  CB  HIS   133      27.483   5.565  29.655  1.00  8.72           C
ATOM   1054  CG  HIS   133      27.048   4.398  28.823  1.00 10.75           C
ATOM   1055  ND1 HIS   133      26.449   3.279  29.368  1.00 13.62           N
ATOM   1056  CE1 HIS   133      26.145   2.430  28.400  1.00 14.32           C
ATOM   1057  NE2 HIS   133      26.508   2.965  27.245  1.00 14.63           N
ATOM   1058  CD2 HIS   133      27.069   4.199  27.482  1.00 12.82           C
ATOM   1059  C   HIS   133      26.784   7.562  31.018  1.00  8.10           C
ATOM   1060  O   HIS   133      26.924   8.757  30.726  1.00  7.93           O
ATOM   1061  N   LYS   134      27.017   7.057  32.227  1.00  7.98           N
ATOM   1062  CA  LYS   134      27.360   7.867  33.392  1.00  8.10           C
ATOM   1063  CB  LYS   134      27.757   6.958  34.568  1.00  8.20           C
ATOM   1064  CG  LYS   134      26.594   6.413  35.404  1.00  8.64           C
ATOM   1065  CD  LYS   134      27.152   5.631  36.614  1.00  9.93           C
ATOM   1066  CE  LYS   134      26.100   5.414  37.689  1.00 10.02           C
ATOM   1067  NZ  LYS   134      24.906   4.719  37.135  1.00 10.40           N
ATOM   1068  C   LYS   134      28.469   8.886  33.158  1.00  8.09           C
ATOM   1069  O   LYS   134      28.315  10.066  33.474  1.00  8.89           O
ATOM   1070  N   ALA   135      29.601   8.435  32.634  1.00  7.78           N
ATOM   1071  CA  ALA   135      30.725   9.344  32.348  1.00  7.06           C
ATOM   1072  CB  ALA   135      31.933   8.544  31.953  1.00  6.58           C
ATOM   1073  C   ALA   135      30.388  10.416  31.272  1.00  7.07           C
ATOM   1074  O   ALA   135      30.828  11.569  31.361  1.00  5.86           O
ATOM   1075  N   ALA   136      29.612  10.037  30.259  1.00  7.08           N
ATOM   1076  CA  ALA   136      29.136  11.015  29.285  1.00  8.14           C
ATOM   1077  CB  ALA   136      28.414  10.320  28.132  1.00  8.53           C
ATOM   1078  C   ALA   136      28.208  12.054  29.949  1.00  9.04           C
ATOM   1079  O   ALA   136      28.216  13.240  29.594  1.00  8.86           O
ATOM   1080  N   VAL   137      27.402  11.597  30.902  1.00  9.47           N
ATOM   1081  CA  VAL   137      26.561  12.496  31.665  1.00 10.61           C
ATOM   1082  CB  VAL   137      25.621  11.706  32.624  1.00 10.83           C
ATOM   1083  CG1 VAL   137      24.750  12.663  33.472  1.00 10.73           C
ATOM   1084  CG2 VAL   137      24.760  10.711  31.837  1.00  8.15           C
ATOM   1085  C   VAL   137      27.462  13.446  32.466  1.00 11.72           C
ATOM   1086  O   VAL   137      27.307  14.663  32.410  1.00 11.69           O
ATOM   1087  N   ALA   138      28.414  12.883  33.205  1.00 12.47           N
ATOM   1088  CA  ALA   138      29.390  13.703  33.914  1.00 13.56           C
ATOM   1089  CB  ALA   138      30.415  12.826  34.616  1.00 13.10           C
ATOM   1090  C   ALA   138      30.077  14.704  32.967  1.00 14.14           C
ATOM   1091  O   ALA   138      30.207  15.878  33.291  1.00 14.53           O
ATOM   1092  N   ALA   139      30.490  14.243  31.792  1.00 14.92           N
ATOM   1093  CA  ALA   139      31.201  15.105  30.842  1.00 16.02           C
ATOM   1094  CB  ALA   139      32.042  14.274  29.896  1.00 16.22           C
ATOM   1095  C   ALA   139      30.335  16.087  30.040  1.00 16.61           C
ATOM   1096  O   ALA   139      30.876  16.962  29.375  1.00 16.58           O
ATOM   1097  N   LYS   140      29.009  15.943  30.086  1.00 17.36           N
ATOM   1098  CA  LYS   140      28.133  16.847  29.343  1.00 17.49           C
ATOM   1099  CB  LYS   140      28.375  18.302  29.775  1.00 17.87           C
ATOM   1100  CG  LYS   140      27.917  18.654  31.192  1.00 19.17           C
ATOM   1101  CD  LYS   140      26.449  19.124  31.199  1.00 21.75           C
ATOM   1102  CE  LYS   140      25.975  19.491  32.608  1.00 22.07           C
ATOM   1103  NZ  LYS   140      24.537  19.921  32.677  1.00 21.26           N
ATOM   1104  C   LYS   140      28.410  16.710  27.853  1.00 17.29           C
ATOM   1105  O   LYS   140      28.281  17.664  27.094  1.00 17.27           O
ATOM   1106  N   LYS   141      28.795  15.513  27.432  1.00 17.15           N
ATOM   1107  CA  LYS   141      29.212  15.306  26.054  1.00 17.26           C
ATOM   1108  CB  LYS   141      29.758  13.883  25.865  1.00 17.28           C
ATOM   1109  CG  LYS   141      30.601  13.701  24.603  1.00 19.02           C
ATOM   1110  CD  LYS   141      30.559  12.250  24.107  1.00 21.82           C
ATOM   1111  CE  LYS   141      30.748  12.166  22.586  1.00 21.87           C
ATOM   1112  NZ  LYS   141      31.105  10.793  22.133  1.00 21.82           N
ATOM   1113  C   LYS   141      28.084  15.598  25.043  1.00 17.19           C
ATOM   1114  O   LYS   141      28.347  15.921  23.885  1.00 16.57           O
ATOM   1115  N   PHE   142      26.830  15.471  25.467  1.00 17.38           N
ATOM   1116  CA  PHE   142      25.708  15.700  24.542  1.00 18.04           C
ATOM   1117  CB  PHE   142      24.792  14.479  24.463  1.00 17.39           C
ATOM   1118  CG  PHE   142      25.492  13.239  24.020  1.00 17.23           C
ATOM   1119  CD1 PHE   142      26.091  12.400  24.946  1.00 18.95           C
ATOM   1120  CE1 PHE   142      26.751  11.258  24.540  1.00 18.92           C
ATOM   1121  CZ  PHE   142      26.822  10.945  23.197  1.00 19.30           C
ATOM   1122  CE2 PHE   142      26.221  11.770  22.263  1.00 19.14           C
ATOM   1123  CD2 PHE   142      25.569  12.913  22.677  1.00 18.44           C
ATOM   1124  C   PHE   142      24.916  16.919  24.949  1.00 18.77           C
ATOM   1125  O   PHE   142      23.770  17.086  24.539  1.00 19.52           O
ATOM   1126  N   GLY   143      25.531  17.767  25.764  1.00 19.79           N
ATOM   1127  CA  GLY   143      24.896  19.001  26.208  1.00 20.51           C
ATOM   1128  C   GLY   143      24.483  19.922  25.071  1.00 21.43           C
ATOM   1129  O   GLY   143      24.968  19.804  23.941  1.00 21.03           O
ATOM   1130  N   PRO   144      23.545  20.839  25.363  1.00 22.22           N
ATOM   1131  CA  PRO   144      23.202  21.927  24.444  1.00 22.20           C
ATOM   1132  CB  PRO   144      22.248  22.788  25.278  1.00 22.24           C
ATOM   1133  CG  PRO   144      21.518  21.754  26.140  1.00 22.75           C
ATOM   1134  CD  PRO   144      22.589  20.730  26.489  1.00 21.98           C
ATOM   1135  C   PRO   144      24.431  22.731  23.959  1.00 22.05           C
ATOM   1136  O   PRO   144      24.429  23.219  22.822  1.00 22.83           O
ATOM   1137  N   LYS   145      25.485  22.841  24.765  1.00 20.97           N
ATOM   1138  CA  LYS   145      26.684  23.546  24.279  1.00 20.14           C
ATOM   1139  CB  LYS   145      27.315  24.406  25.380  1.00 20.22           C
ATOM   1144  C   LYS   145      27.739  22.630  23.640  1.00 19.49           C
ATOM   1145  O   LYS   145      28.912  22.976  23.579  1.00 19.66           O
ATOM   1146  N   SER   146      27.322  21.468  23.152  1.00 18.25           N
ATOM   1147  CA  SER   146      28.250  20.547  22.495  1.00 16.80           C
ATOM   1148  CB  SER   146      27.864  19.099  22.807  1.00 16.94           C
ATOM   1149  OG  SER   146      26.706  18.719  22.061  1.00 14.20           O
ATOM   1150  C   SER   146      28.232  20.739  20.978  1.00 16.24           C
ATOM   1151  O   SER   146      27.574  21.642  20.460  1.00 15.50           O
ATOM   1152  N   SER   147      28.937  19.853  20.285  1.00 15.80           N
ATOM   1153  CA  SER   147      29.011  19.824  18.815  1.00 15.62           C
ATOM   1154  CB  SER   147      29.947  18.683  18.396  1.00 15.78           C
ATOM   1155  OG  SER   147      29.349  17.415  18.708  1.00 17.28           O
ATOM   1156  C   SER   147      27.648  19.610  18.118  1.00 14.85           C
ATOM   1157  O   SER   147      27.420  20.110  17.025  1.00 15.12           O
ATOM   1158  N   LYS   148      26.768  18.838  18.742  1.00 13.81           N
ATOM   1159  CA  LYS   148      25.466  18.470  18.151  1.00 13.28           C
ATOM   1160  CB  LYS   148      24.645  19.698  17.773  1.00 13.70           C
ATOM   1161  CG  LYS   148      24.599  20.705  18.891  1.00 16.01           C
ATOM   1162  CD  LYS   148      23.301  21.495  18.977  1.00 20.40           C
ATOM   1163  CE  LYS   148      23.398  22.428  20.204  1.00 23.32           C
ATOM   1164  NZ  LYS   148      22.284  23.426  20.342  1.00 25.99           N
ATOM   1165  C   LYS   148      25.561  17.493  16.976  1.00 12.03           C
ATOM   1166  O   LYS   148      24.594  17.278  16.250  1.00 11.95           O
ATOM   1167  N   LYS   149      26.726  16.894  16.810  1.00 10.19           N
ATOM   1168  CA  LYS   149      26.897  15.889  15.801  1.00  9.30           C
ATOM   1169  CB  LYS   149      28.340  15.866  15.295  1.00  9.29           C
ATOM   1170  CG  LYS   149      28.825  17.235  14.822  1.00 11.57           C
ATOM   1171  CD  LYS   149      29.563  17.189  13.475  1.00 14.93           C
ATOM   1172  CE  LYS   149      30.943  16.580  13.631  1.00 17.83           C
ATOM   1173  NZ  LYS   149      31.599  17.084  14.872  1.00 19.27           N
ATOM   1174  C   LYS   149      26.490  14.534  16.362  1.00  7.95           C
ATOM   1175  O   LYS   149      27.334  13.674  16.612  1.00  8.28           O
ATOM   1176  N   PHE   150      25.190  14.369  16.571  1.00  6.10           N
ATOM   1177  CA  PHE   150      24.603  13.100  16.965  1.00  5.12           C
ATOM   1178  CB  PHE   150      24.702  12.886  18.475  1.00  5.47           C
ATOM   1179  CG  PHE   150      24.635  14.160  19.287  1.00  7.37           C
ATOM   1180  CD1 PHE   150      23.421  14.643  19.755  1.00  9.59           C
ATOM   1181  CE1 PHE   150      23.357  15.800  20.500  1.00  9.47           C
ATOM   1182  CZ  PHE   150      24.499  16.487  20.800  1.00  9.07           C
ATOM   1183  CE2 PHE   150      25.724  16.029  20.342  1.00  9.88           C
ATOM   1184  CD2 PHE   150      25.790  14.869  19.585  1.00  8.47           C
ATOM   1185  C   PHE   150      23.154  13.106  16.500  1.00  3.91           C
ATOM   1186  O   PHE   150      22.532  14.161  16.441  1.00  3.83           O
ATOM   1187  N   ASP   151      22.619  11.934  16.171  1.00  2.77           N
ATOM   1188  CA  ASP   151      21.342  11.847  15.442  1.00  2.00           C
ATOM   1189  CB  ASP   151      21.556  11.065  14.129  1.00  2.00           C
ATOM   1190  CG  ASP   151      22.543  11.759  13.176  1.00  2.00           C
ATOM   1191  OD1 ASP   151      22.199  12.859  12.726  1.00  2.00           O
ATOM   1192  OD2 ASP   151      23.628  11.195  12.869  1.00  2.00           O
ATOM   1193  C   ASP   151      20.233  11.175  16.258  1.00  2.00           C
ATOM   1194  O   ASP   151      19.088  11.648  16.299  1.00  2.00           O
ATOM   1195  N   ILE   152      20.562  10.042  16.867  1.00  2.00           N
ATOM   1196  CA  ILE   152      19.550   9.177  17.472  1.00  2.00           C
ATOM   1197  CB  ILE   152      19.290   7.938  16.625  1.00  2.00           C
ATOM   1198  CG1 ILE   152      18.757   8.344  15.239  1.00  2.80           C
ATOM   1199  CD1 ILE   152      18.685   7.140  14.237  1.00  3.82           C
ATOM   1200  CG2 ILE   152      18.272   6.982  17.326  1.00  2.00           C
ATOM   1201  C   ILE   152      20.018   8.762  18.854  1.00  2.00           C
ATOM   1202  O   ILE   152      21.188   8.342  19.010  1.00  2.00           O
ATOM   1203  N   LEU   153      19.136   8.914  19.854  1.00  2.00           N
ATOM   1204  CA  LEU   153      19.447   8.502  21.237  1.00  2.00           C
ATOM   1205  CB  LEU   153      19.176   9.677  22.209  1.00  2.00           C
ATOM   1206  CG  LEU   153      19.434   9.376  23.700  1.00  2.00           C
ATOM   1207  CD1 LEU   153      20.914   9.084  23.976  1.00  2.00           C
ATOM   1208  CD2 LEU   153      18.933  10.532  24.619  1.00  2.00           C
ATOM   1209  C   LEU   153      18.604   7.302  21.655  1.00  2.00           C
ATOM   1210  O   LEU   153      17.371   7.331  21.519  1.00  2.00           O
ATOM   1211  N   VAL   154      19.246   6.246  22.157  1.00  2.36           N
ATOM   1212  CA  VAL   154      18.499   5.148  22.804  1.00  2.17           C
ATOM   1213  CB  VAL   154      18.931   3.724  22.300  1.00  3.16           C
ATOM   1214  CG1 VAL   154      17.880   2.664  22.743  1.00  2.00           C
ATOM   1215  CG2 VAL   154      19.050   3.693  20.759  1.00  2.42           C
ATOM   1216  C   VAL   154      18.716   5.243  24.310  1.00  2.60           C
ATOM   1217  O   VAL   154      19.842   5.361  24.766  1.00  2.46           O
ATOM   1218  N   THR   155      17.653   5.181  25.105  1.00  2.34           N
ATOM   1219  CA  THR   155      17.830   5.427  26.527  1.00  2.60           C
ATOM   1220  CB  THR   155      17.955   6.970  26.783  1.00  2.96           C
ATOM   1221  OG1 THR   155      18.328   7.209  28.135  1.00  4.18           O
ATOM   1222  CG2 THR   155      16.639   7.665  26.526  1.00  2.00           C
ATOM   1223  C   THR   155      16.684   4.825  27.363  1.00  2.43           C
ATOM   1224  O   THR   155      15.748   4.224  26.822  1.00  2.00           O
ATOM   1225  N   THR   156      16.799   4.974  28.677  1.00  2.00           N
ATOM   1226  CA  THR   156      15.783   4.571  29.617  1.00  2.10           C
ATOM   1227  CB  THR   156      16.417   3.916  30.836  1.00  2.00           C
ATOM   1228  OG1 THR   156      17.341   4.846  31.414  1.00  2.00           O
ATOM   1229  CG2 THR   156      17.152   2.646  30.439  1.00  3.36           C
ATOM   1230  C   THR   156      15.074   5.833  30.110  1.00  2.00           C
ATOM   1231  O   THR   156      15.585   6.933  29.971  1.00  2.88           O
ATOM   1232  N   PRO   157      13.887   5.670  30.693  1.00  2.41           N
ATOM   1233  CA  PRO   157      13.150   6.821  31.217  1.00  2.25           C
ATOM   1234  CB  PRO   157      11.909   6.180  31.832  1.00  2.61           C
ATOM   1235  CG  PRO   157      11.802   4.788  31.141  1.00  2.11           C
ATOM   1236  CD  PRO   157      13.179   4.382  30.870  1.00  2.00           C
ATOM   1237  C   PRO   157      13.949   7.585  32.299  1.00  3.24           C
ATOM   1238  O   PRO   157      13.993   8.840  32.273  1.00  3.29           O
ATOM   1239  N   ASN   158      14.536   6.861  33.260  1.00  2.64           N
ATOM   1240  CA  ASN   158      15.203   7.533  34.391  1.00  3.59           C
ATOM   1241  CB  ASN   158      15.594   6.548  35.497  1.00  3.31           C
ATOM   1242  CG  ASN   158      14.403   6.039  36.274  1.00  5.55           C
ATOM   1243  OD1 ASN   158      13.294   6.572  36.171  1.00  5.84           O
ATOM   1244  ND2 ASN   158      14.631   5.001  37.073  1.00  6.54           N
ATOM   1245  C   ASN   158      16.452   8.289  33.967  1.00  3.08           C
ATOM   1246  O   ASN   158      16.742   9.365  34.487  1.00  2.08           O
ATOM   1247  N   ARG   159      17.191   7.707  33.032  1.00  2.89           N
ATOM   1248  CA  ARG   159      18.421   8.335  32.542  1.00  4.01           C
ATOM   1249  CB  ARG   159      19.200   7.377  31.611  1.00  4.52           C
ATOM   1250  CG  ARG   159      20.411   8.033  30.878  1.00  6.25           C
ATOM   1251  CD  ARG   159      21.462   8.624  31.859  1.00  8.89           C
ATOM   1252  NE  ARG   159      21.787   7.727  32.977  1.00 10.47           N
ATOM   1253  CZ  ARG   159      22.765   6.812  32.958  1.00 12.46           C
ATOM   1254  NH1 ARG   159      23.533   6.649  31.883  1.00 11.80           N
ATOM   1255  NH2 ARG   159      22.980   6.051  34.020  1.00 12.56           N
ATOM   1256  C   ARG   159      18.097   9.615  31.801  1.00  3.36           C
ATOM   1257  O   ARG   159      18.780  10.640  31.965  1.00  4.40           O
ATOM   1258  N   LEU   160      17.054   9.559  30.989  1.00  2.00           N
ATOM   1259  CA  LEU   160      16.660  10.706  30.202  1.00  2.44           C
ATOM   1260  CB  LEU   160      15.622  10.313  29.171  1.00  2.28           C
ATOM   1261  CG  LEU   160      14.998  11.428  28.342  1.00  3.82           C
ATOM   1262  CD1 LEU   160      16.069  12.209  27.507  1.00  2.00           C
ATOM   1263  CD2 LEU   160      13.957  10.827  27.432  1.00  2.95           C
ATOM   1264  C   LEU   160      16.135  11.830  31.107  1.00  2.72           C
ATOM   1265  O   LEU   160      16.424  13.008  30.874  1.00  2.76           O
ATOM   1266  N   ILE   161      15.397  11.455  32.152  1.00  2.00           N
ATOM   1267  CA  ILE   161      14.815  12.430  33.043  1.00  2.02           C
ATOM   1268  CB  ILE   161      13.787  11.796  34.017  1.00  2.00           C
ATOM   1269  CG1 ILE   161      12.568  11.306  33.241  1.00  2.11           C
ATOM   1270  CD1 ILE   161      11.596  12.437  32.909  1.00  3.36           C
ATOM   1271  CG2 ILE   161      13.313  12.862  35.069  1.00  2.00           C
ATOM   1272  C   ILE   161      15.926  13.057  33.866  1.00  2.03           C
ATOM   1273  O   ILE   161      15.916  14.253  34.155  1.00  2.00           O
ATOM   1274  N   TYR   162      16.882  12.233  34.271  1.00  2.15           N
ATOM   1275  CA  TYR   162      18.036  12.769  34.967  1.00  2.55           C
ATOM   1276  CB  TYR   162      19.022  11.651  35.303  1.00  3.03           C
ATOM   1277  CG  TYR   162      20.128  12.132  36.191  1.00  2.26           C
ATOM   1278  CD1 TYR   162      19.958  12.170  37.560  1.00  4.34           C
ATOM   1279  CE1 TYR   162      20.956  12.618  38.396  1.00  4.04           C
ATOM   1280  CZ  TYR   162      22.146  13.044  37.847  1.00  5.35           C
ATOM   1281  OH  TYR   162      23.138  13.498  38.670  1.00  5.30           O
ATOM   1282  CE2 TYR   162      22.341  13.034  36.479  1.00  5.58           C
ATOM   1283  CD2 TYR   162      21.322  12.579  35.655  1.00  3.64           C
ATOM   1284  C   TYR   162      18.713  13.877  34.142  1.00  2.00           C
ATOM   1285  O   TYR   162      19.035  14.948  34.655  1.00  2.26           O
ATOM   1286  N   LEU   163      18.931  13.625  32.864  1.00  2.00           N
ATOM   1287  CA  LEU   163      19.542  14.638  31.983  1.00  2.00           C
ATOM   1288  CB  LEU   163      19.791  14.064  30.593  1.00  2.00           C
ATOM   1289  CG  LEU   163      20.802  12.921  30.505  1.00  2.76           C
ATOM   1290  CD1 LEU   163      20.720  12.258  29.132  1.00  4.31           C
ATOM   1291  CD2 LEU   163      22.192  13.419  30.802  1.00  6.30           C
ATOM   1292  C   LEU   163      18.709  15.933  31.865  1.00  2.00           C
ATOM   1293  O   LEU   163      19.251  17.026  31.953  1.00  2.00           O
ATOM   1294  N   LEU   164      17.403  15.782  31.657  1.00  2.29           N
ATOM   1295  CA  LEU   164      16.484  16.898  31.519  1.00  3.44           C
ATOM   1296  CB  LEU   164      15.062  16.385  31.240  1.00  3.14           C
ATOM   1297  CG  LEU   164      14.812  15.873  29.811  1.00  4.59           C
ATOM   1298  CD1 LEU   164      13.444  15.173  29.600  1.00  2.00           C
ATOM   1299  CD2 LEU   164      15.015  17.001  28.789  1.00  4.77           C
ATOM   1300  C   LEU   164      16.476  17.758  32.782  1.00  4.24           C
ATOM   1301  O   LEU   164      16.260  18.967  32.716  1.00  4.53           O
ATOM   1302  N   LYS   165      16.708  17.133  33.936  1.00  4.83           N
ATOM   1303  CA  LYS   165      16.526  17.820  35.201  1.00  5.58           C
ATOM   1304  CB  LYS   165      15.909  16.890  36.253  1.00  6.35           C
ATOM   1305  CG  LYS   165      14.449  16.500  35.958  1.00 11.04           C
ATOM   1306  CD  LYS   165      13.647  17.692  35.409  1.00 15.28           C
ATOM   1307  CE  LYS   165      12.149  17.344  35.249  1.00 18.91           C
ATOM   1308  NZ  LYS   165      11.875  16.295  34.186  1.00 21.31           N
ATOM   1309  C   LYS   165      17.812  18.409  35.739  1.00  5.38           C
ATOM   1310  O   LYS   165      17.779  19.139  36.713  1.00  4.35           O
ATOM   1311  N   GLN   166      18.947  18.079  35.127  1.00  5.29           N
ATOM   1312  CA  GLN   166      20.202  18.710  35.509  1.00  5.66           C
ATOM   1313  CB  GLN   166      21.339  18.167  34.657  1.00  5.33           C
ATOM   1314  CG  GLN   166      21.743  16.762  34.980  1.00  5.29           C
ATOM   1315  CD  GLN   166      22.934  16.298  34.160  1.00  7.26           C
ATOM   1316  OE1 GLN   166      22.846  16.161  32.934  1.00  9.26           O
ATOM   1317  NE2 GLN   166      24.041  16.022  34.834  1.00  6.06           N
ATOM   1318  C   GLN   166      20.136  20.239  35.356  1.00  6.66           C
ATOM   1319  O   GLN   166      19.363  20.759  34.560  1.00  7.21           O
ATOM   1320  N   ASP   167      20.967  20.952  36.104  1.00  7.72           N
ATOM   1321  CA  ASP   167      21.025  22.401  36.022  1.00  8.65           C
ATOM   1322  CB  ASP   167      20.678  23.013  37.382  1.00  8.72           C
ATOM   1323  CG  ASP   167      20.897  24.518  37.421  1.00 11.15           C
ATOM   1324  OD1 ASP   167      20.741  25.165  36.355  1.00 12.51           O
ATOM   1325  OD2 ASP   167      21.223  25.053  38.514  1.00  9.59           O
ATOM   1326  C   ASP   167      22.422  22.836  35.605  1.00  8.92           C
ATOM   1327  O   ASP   167      23.338  22.835  36.430  1.00  8.62           O
ATOM   1328  N   PRO   168      22.591  23.215  34.318  1.00  9.32           N
ATOM   1329  CA  PRO   168      21.510  23.299  33.333  1.00  9.33           C
ATOM   1330  CB  PRO   168      22.045  24.310  32.317  1.00  9.51           C
ATOM   1331  CG  PRO   168      23.555  24.122  32.369  1.00 10.10           C
ATOM   1332  CD  PRO   168      23.904  23.495  33.712  1.00  9.20           C
ATOM   1333  C   PRO   168      21.313  21.951  32.672  1.00  9.12           C
ATOM   1334  O   PRO   168      22.095  21.036  32.921  1.00  8.91           O
ATOM   1335  N   PRO   169      20.275  21.826  31.830  1.00  9.05           N
ATOM   1336  CA  PRO   169      19.880  20.539  31.239  1.00  8.86           C
ATOM   1337  CB  PRO   169      18.774  20.932  30.262  1.00  8.62           C
ATOM   1338  CG  PRO   169      18.186  22.178  30.867  1.00  9.71           C
ATOM   1339  CD  PRO   169      19.373  22.917  31.427  1.00  9.23           C
ATOM   1340  C   PRO   169      21.020  19.850  30.489  1.00  8.21           C
ATOM   1341  O   PRO   169      21.704  20.501  29.705  1.00  8.96           O
ATOM   1342  N   GLY   170      21.218  18.561  30.742  1.00  6.31           N
ATOM   1343  CA  GLY   170      22.252  17.784  30.070  1.00  5.80           C
ATOM   1344  C   GLY   170      21.862  17.295  28.677  1.00  5.66           C
ATOM   1345  O   GLY   170      22.621  16.585  28.022  1.00  5.58           O
ATOM   1346  N   ILE   171      20.675  17.679  28.212  1.00  4.95           N
ATOM   1347  CA  ILE   171      20.250  17.331  26.869  1.00  5.59           C
ATOM   1348  CB  ILE   171      19.715  15.892  26.813  1.00  5.67           C
ATOM   1349  CG1 ILE   171      19.618  15.397  25.383  1.00  5.60           C
ATOM   1350  CD1 ILE   171      19.090  14.010  25.321  1.00  7.42           C
ATOM   1351  CG2 ILE   171      18.363  15.780  27.473  1.00  6.75           C
ATOM   1352  C   ILE   171      19.192  18.320  26.388  1.00  5.19           C
ATOM   1353  O   ILE   171      18.526  18.950  27.196  1.00  4.11           O
ATOM   1354  N   ASP   172      19.097  18.494  25.075  1.00  4.97           N
ATOM   1355  CA  ASP   172      18.110  19.393  24.474  1.00  6.12           C
ATOM   1356  CB  ASP   172      18.831  20.532  23.751  1.00  6.06           C
ATOM   1357  CG  ASP   172      17.886  21.393  22.911  1.00 10.18           C
ATOM   1358  OD1 ASP   172      16.647  21.245  23.020  1.00 13.82           O
ATOM   1359  OD2 ASP   172      18.379  22.240  22.143  1.00 12.47           O
ATOM   1360  C   ASP   172      17.299  18.554  23.486  1.00  5.65           C
ATOM   1361  O   ASP   172      17.876  17.916  22.617  1.00  6.36           O
ATOM   1362  N   LEU   173      15.977  18.546  23.630  1.00  5.44           N
ATOM   1363  CA  LEU   173      15.096  17.693  22.834  1.00  4.83           C
ATOM   1364  CB  LEU   173      14.097  16.970  23.740  1.00  4.83           C
ATOM   1365  CG  LEU   173      14.736  16.043  24.769  1.00  3.60           C
ATOM   1366  CD1 LEU   173      13.682  15.251  25.511  1.00  3.57           C
ATOM   1367  CD2 LEU   173      15.671  15.086  24.074  1.00  2.00           C
ATOM   1368  C   LEU   173      14.329  18.473  21.787  1.00  4.66           C
ATOM   1369  O   LEU   173      13.403  17.945  21.168  1.00  4.61           O
ATOM   1370  N   ALA   174      14.751  19.709  21.560  1.00  3.85           N
ATOM   1371  CA  ALA   174      14.048  20.606  20.666  1.00  4.01           C
ATOM   1372  CB  ALA   174      14.635  22.050  20.737  1.00  3.42           C
ATOM   1373  C   ALA   174      13.975  20.109  19.222  1.00  3.45           C
ATOM   1374  O   ALA   174      13.076  20.490  18.512  1.00  3.66           O
ATOM   1375  N   SER   175      14.899  19.266  18.777  1.00  2.95           N
ATOM   1376  CA  SER   175      14.824  18.762  17.396  1.00  2.37           C
ATOM   1377  CB  SER   175      16.187  18.841  16.742  1.00  3.34           C
ATOM   1378  OG  SER   175      16.712  20.149  16.915  1.00  4.22           O
ATOM   1379  C   SER   175      14.295  17.337  17.230  1.00  2.00           C
ATOM   1380  O   SER   175      14.289  16.790  16.112  1.00  2.00           O
ATOM   1381  N   VAL   176      13.870  16.722  18.326  1.00  2.00           N
ATOM   1382  CA  VAL   176      13.402  15.344  18.268  1.00  2.00           C
ATOM   1383  CB  VAL   176      13.076  14.746  19.694  1.00  2.13           C
ATOM   1384  CG1 VAL   176      12.382  13.348  19.597  1.00  2.00           C
ATOM   1385  CG2 VAL   176      14.320  14.621  20.539  1.00  2.00           C
ATOM   1386  C   VAL   176      12.152  15.311  17.395  1.00  2.53           C
ATOM   1387  O   VAL   176      11.166  16.004  17.656  1.00  2.00           O
ATOM   1388  N   GLU   177      12.189  14.499  16.356  1.00  2.40           N
ATOM   1389  CA  GLU   177      11.043  14.375  15.474  1.00  3.02           C
ATOM   1390  CB  GLU   177      11.535  14.368  14.030  1.00  3.09           C
ATOM   1391  CG  GLU   177      12.336  15.590  13.659  1.00  2.88           C
ATOM   1392  CD  GLU   177      12.863  15.540  12.210  1.00  6.49           C
ATOM   1393  OE1 GLU   177      12.427  14.653  11.417  1.00  8.10           O
ATOM   1394  OE2 GLU   177      13.713  16.396  11.870  1.00  5.79           O
ATOM   1395  C   GLU   177      10.274  13.087  15.769  1.00  3.31           C
ATOM   1396  O   GLU   177       9.071  12.987  15.514  1.00  2.97           O
ATOM   1397  N   TRP   178      10.971  12.087  16.302  1.00  4.21           N
ATOM   1398  CA  TRP   178      10.290  10.831  16.649  1.00  4.32           C
ATOM   1399  CB  TRP   178      10.708   9.682  15.691  1.00  3.79           C
ATOM   1400  CG  TRP   178       9.758   9.549  14.506  1.00  3.47           C
ATOM   1401  CD1 TRP   178      10.036   9.811  13.182  1.00  2.59           C
ATOM   1402  NE1 TRP   178       8.902   9.609  12.412  1.00  2.84           N
ATOM   1403  CE2 TRP   178       7.877   9.195  13.227  1.00  2.00           C
ATOM   1404  CD2 TRP   178       8.378   9.145  14.555  1.00  2.00           C
ATOM   1405  CE3 TRP   178       7.525   8.726  15.590  1.00  2.00           C
ATOM   1406  CZ3 TRP   178       6.218   8.391  15.272  1.00  2.99           C
ATOM   1407  CH2 TRP   178       5.751   8.446  13.929  1.00  3.97           C
ATOM   1408  CZ2 TRP   178       6.573   8.824  12.903  1.00  2.00           C
ATOM   1409  C   TRP   178      10.612  10.461  18.086  1.00  4.04           C
ATOM   1410  O   TRP   178      11.774  10.353  18.434  1.00  3.49           O
ATOM   1411  N   LEU   179       9.578  10.248  18.896  1.00  4.24           N
ATOM   1412  CA  LEU   179       9.748   9.723  20.245  1.00  5.21           C
ATOM   1413  CB  LEU   179       9.118  10.669  21.284  1.00  6.21           C
ATOM   1414  CG  LEU   179       9.038  10.281  22.767  1.00  6.16           C
ATOM   1415  CD1 LEU   179      10.432  10.225  23.341  1.00  8.08           C
ATOM   1416  CD2 LEU   179       8.229  11.336  23.507  1.00  7.38           C
ATOM   1417  C   LEU   179       9.079   8.351  20.289  1.00  5.60           C
ATOM   1418  O   LEU   179       7.851   8.224  20.088  1.00  4.36           O
ATOM   1419  N   VAL   180       9.907   7.323  20.469  1.00  4.72           N
ATOM   1420  CA  VAL   180       9.442   5.959  20.423  1.00  4.27           C
ATOM   1421  CB  VAL   180      10.286   5.111  19.432  1.00  4.63           C
ATOM   1422  CG1 VAL   180       9.896   3.636  19.532  1.00  3.54           C
ATOM   1423  CG2 VAL   180      10.113   5.628  17.984  1.00  3.58           C
ATOM   1424  C   VAL   180       9.582   5.333  21.808  1.00  4.59           C
ATOM   1425  O   VAL   180      10.658   5.404  22.421  1.00  3.03           O
ATOM   1426  N   VAL   181       8.489   4.740  22.296  1.00  3.74           N
ATOM   1427  CA  VAL   181       8.516   3.978  23.539  1.00  4.66           C
ATOM   1428  CB  VAL   181       7.414   4.456  24.532  1.00  4.72           C
ATOM   1429  CG1 VAL   181       7.486   3.707  25.845  1.00  5.80           C
ATOM   1430  CG2 VAL   181       7.564   5.961  24.804  1.00  3.26           C
ATOM   1431  C   VAL   181       8.410   2.489  23.195  1.00  5.58           C
ATOM   1432  O   VAL   181       7.422   2.024  22.579  1.00  5.52           O
ATOM   1433  N   ASP   182       9.456   1.753  23.545  1.00  6.03           N
ATOM   1434  CA  ASP   182       9.507   0.329  23.304  1.00  7.74           C
ATOM   1435  CB  ASP   182      10.906  -0.039  22.822  1.00  8.58           C
ATOM   1436  CG  ASP   182      11.008  -1.465  22.274  1.00 10.54           C
ATOM   1437  OD1 ASP   182      10.009  -2.067  21.787  1.00 11.50           O
ATOM   1438  OD2 ASP   182      12.135  -1.974  22.307  1.00 14.04           O
ATOM   1439  C   ASP   182       9.158  -0.399  24.596  1.00  8.09           C
ATOM   1440  O   ASP   182       9.537   0.041  25.690  1.00  8.59           O
ATOM   1441  N   GLU   183       8.435  -1.516  24.471  1.00  8.60           N
ATOM   1442  CA  GLU   183       7.890  -2.244  25.627  1.00  9.16           C
ATOM   1443  CB  GLU   183       9.006  -2.962  26.413  1.00  9.21           C
ATOM   1444  CG  GLU   183       9.852  -3.944  25.567  1.00 10.64           C
ATOM   1445  CD  GLU   183       9.104  -5.229  25.239  1.00 14.44           C
ATOM   1446  OE1 GLU   183       9.014  -6.089  26.130  1.00 15.05           O
ATOM   1447  OE2 GLU   183       8.599  -5.392  24.091  1.00 15.79           O
ATOM   1448  C   GLU   183       7.054  -1.341  26.551  1.00  9.83           C
ATOM   1449  O   GLU   183       7.249  -1.315  27.771  1.00 10.13           O
ATOM   1450  N   SER   184       6.122  -0.607  25.953  1.00 10.57           N
ATOM   1451  CA  SER   184       5.166   0.218  26.675  1.00 11.54           C
ATOM   1452  CB  SER   184       4.189   0.848  25.692  1.00 11.36           C
ATOM   1453  OG  SER   184       4.892   1.489  24.656  1.00 15.74           O
ATOM   1454  C   SER   184       4.344  -0.528  27.724  1.00 12.18           C
ATOM   1455  O   SER   184       4.029   0.032  28.788  1.00 11.97           O
ATOM   1456  N   ASP   185       3.935  -1.755  27.408  1.00 12.39           N
ATOM   1457  CA  ASP   185       3.155  -2.515  28.375  1.00 12.76           C
ATOM   1458  CB  ASP   185       2.746  -3.879  27.829  1.00 12.83           C
ATOM   1459  CG  ASP   185       3.864  -4.577  27.061  1.00 13.81           C
ATOM   1460  OD1 ASP   185       4.009  -5.809  27.247  1.00 15.77           O
ATOM   1461  OD2 ASP   185       4.566  -3.912  26.252  1.00 13.82           O
ATOM   1462  C   ASP   185       3.967  -2.665  29.653  1.00 13.02           C
ATOM   1463  O   ASP   185       3.457  -2.478  30.746  1.00 13.40           O
ATOM   1464  N   LYS   186       5.246  -2.990  29.527  1.00 13.78           N
ATOM   1465  CA  LYS   186       6.053  -3.198  30.727  1.00 14.23           C
ATOM   1466  CB  LYS   186       7.443  -3.752  30.390  1.00 14.24           C
ATOM   1467  CG  LYS   186       7.487  -4.916  29.373  1.00 15.92           C
ATOM   1468  CD  LYS   186       6.760  -6.177  29.846  1.00 17.57           C
ATOM   1469  CE  LYS   186       7.224  -7.427  29.051  1.00 19.17           C
ATOM   1470  NZ  LYS   186       6.857  -7.409  27.575  1.00 18.50           N
ATOM   1471  C   LYS   186       6.172  -1.884  31.499  1.00 14.39           C
ATOM   1472  O   LYS   186       5.892  -1.830  32.687  1.00 14.68           O
ATOM   1473  N   LEU   187       6.584  -0.825  30.810  1.00 14.72           N
ATOM   1474  CA  LEU   187       6.751   0.485  31.417  1.00 15.43           C
ATOM   1475  CB  LEU   187       7.222   1.520  30.368  1.00 14.73           C
ATOM   1476  CG  LEU   187       8.659   1.292  29.849  1.00 14.29           C
ATOM   1477  CD1 LEU   187       8.949   2.051  28.553  1.00 13.90           C
ATOM   1478  CD2 LEU   187       9.698   1.641  30.926  1.00 13.34           C
ATOM   1479  C   LEU   187       5.488   0.979  32.156  1.00 16.62           C
ATOM   1480  O   LEU   187       5.591   1.543  33.234  1.00 15.73           O
ATOM   1481  N   PHE   188       4.305   0.798  31.574  1.00 18.32           N
ATOM   1482  CA  PHE   188       3.091   1.261  32.258  1.00 20.50           C
ATOM   1483  CB  PHE   188       1.887   1.365  31.312  1.00 20.67           C
ATOM   1484  CG  PHE   188       1.959   2.508  30.348  1.00 21.46           C
ATOM   1485  CD1 PHE   188       1.542   3.780  30.724  1.00 23.32           C
ATOM   1486  CE1 PHE   188       1.607   4.848  29.824  1.00 22.90           C
ATOM   1487  CZ  PHE   188       2.081   4.640  28.549  1.00 22.23           C
ATOM   1488  CE2 PHE   188       2.498   3.370  28.164  1.00 23.53           C
ATOM   1489  CD2 PHE   188       2.430   2.314  29.061  1.00 21.49           C
ATOM   1490  C   PHE   188       2.732   0.338  33.416  1.00 21.63           C
ATOM   1491  O   PHE   188       1.770   0.587  34.131  1.00 22.07           O
ATOM   1492  N   GLU   189       3.483  -0.740  33.601  1.00 23.22           N
ATOM   1493  CA  GLU   189       3.156  -1.665  34.694  1.00 24.79           C
ATOM   1494  CB  GLU   189       3.031  -3.101  34.193  1.00 24.76           C
ATOM   1495  CG  GLU   189       2.816  -4.095  35.325  1.00 26.52           C
ATOM   1496  CD  GLU   189       3.397  -5.458  35.019  1.00 27.72           C
ATOM   1497  OE1 GLU   189       3.601  -5.763  33.821  1.00 28.72           O
ATOM   1498  OE2 GLU   189       3.646  -6.220  35.975  1.00 28.44           O
ATOM   1499  C   GLU   189       4.177  -1.627  35.817  1.00 25.36           C
ATOM   1500  O   GLU   189       3.869  -1.998  36.939  1.00 25.41           O
ATOM   1501  N   ASP   190       5.397  -1.202  35.495  1.00 26.50           N
ATOM   1502  CA  ASP   190       6.473  -1.105  36.478  1.00 27.41           C
ATOM   1503  CB  ASP   190       7.848  -1.099  35.794  1.00 27.50           C
ATOM   1507  C   ASP   190       6.292   0.147  37.332  1.00 27.94           C
ATOM   1508  O   ASP   190       6.213   0.057  38.551  1.00 28.15           O
ATOM   1509  N   GLY   191       6.219   1.310  36.686  1.00 28.41           N
ATOM   1510  CA  GLY   191       5.912   2.557  37.392  1.00 28.88           C
ATOM   1511  C   GLY   191       4.454   2.930  37.209  1.00 28.86           C
ATOM   1512  O   GLY   191       3.867   2.656  36.156  1.00 29.00           O
ATOM   1513  N   GLY   194       3.280   7.441  37.532  1.00 13.65           N
ATOM   1514  CA  GLY   194       4.742   7.291  37.628  1.00 14.04           C
ATOM   1515  C   GLY   194       5.459   7.423  36.293  1.00 14.29           C
ATOM   1516  O   GLY   194       6.032   8.465  35.983  1.00 14.10           O
ATOM   1517  N   PHE   195       5.447   6.353  35.498  1.00 14.67           N
ATOM   1518  CA  PHE   195       5.976   6.424  34.145  1.00 14.34           C
ATOM   1519  CB  PHE   195       5.991   5.039  33.477  1.00 14.07           C
ATOM   1520  CG  PHE   195       6.408   5.073  32.031  1.00 14.25           C
ATOM   1521  CD1 PHE   195       7.677   5.490  31.666  1.00 13.19           C
ATOM   1522  CE1 PHE   195       8.044   5.560  30.341  1.00 13.21           C
ATOM   1523  CZ  PHE   195       7.147   5.203  29.359  1.00 14.41           C
ATOM   1524  CE2 PHE   195       5.888   4.796  29.704  1.00 13.00           C
ATOM   1525  CD2 PHE   195       5.521   4.730  31.032  1.00 15.27           C
ATOM   1526  C   PHE   195       5.134   7.431  33.347  1.00 14.51           C
ATOM   1527  O   PHE   195       5.666   8.211  32.546  1.00 14.73           O
ATOM   1528  N   ARG   196       3.825   7.438  33.597  1.00 14.51           N
ATOM   1529  CA  ARG   196       2.907   8.343  32.881  1.00 14.80           C
ATOM   1530  CB  ARG   196       1.464   8.192  33.386  1.00 14.62           C
ATOM   1531  CG  ARG   196       0.747   6.941  32.888  1.00 17.16           C
ATOM   1532  CD  ARG   196      -0.635   6.773  33.559  1.00 20.06           C
ATOM   1533  NE  ARG   196      -0.975   5.358  33.714  1.00 23.74           N
ATOM   1534  CZ  ARG   196      -1.735   4.668  32.864  1.00 25.74           C
ATOM   1535  NH1 ARG   196      -2.250   5.261  31.797  1.00 28.10           N
ATOM   1536  NH2 ARG   196      -1.983   3.384  33.074  1.00 25.54           N
ATOM   1537  C   ARG   196       3.327   9.811  32.987  1.00 14.07           C
ATOM   1538  O   ARG   196       3.251  10.570  32.007  1.00 13.47           O
ATOM   1539  N   ASP   197       3.765  10.200  34.178  1.00 13.40           N
ATOM   1540  CA  ASP   197       4.198  11.571  34.414  1.00 13.44           C
ATOM   1541  CB  ASP   197       4.210  11.892  35.911  1.00 13.83           C
ATOM   1542  CG  ASP   197       2.820  11.896  36.512  1.00 15.53           C
ATOM   1543  OD1 ASP   197       1.844  12.178  35.775  1.00 18.69           O
ATOM   1544  OD2 ASP   197       2.701  11.597  37.715  1.00 17.58           O
ATOM   1545  C   ASP   197       5.557  11.868  33.796  1.00 12.75           C
ATOM   1546  O   ASP   197       5.771  12.969  33.287  1.00 12.41           O
ATOM   1547  N   GLN   198       6.473  10.893  33.845  1.00 12.40           N
ATOM   1548  CA  GLN   198       7.753  11.021  33.164  1.00 12.22           C
ATOM   1549  CB  GLN   198       8.566   9.738  33.315  1.00 12.10           C
ATOM   1550  CG  GLN   198       8.936   9.373  34.740  1.00 13.24           C
ATOM   1551  CD  GLN   198       9.944   8.211  34.794  1.00 14.17           C
ATOM   1552  OE1 GLN   198       9.743   7.171  34.160  1.00 12.65           O
ATOM   1553  NE2 GLN   198      11.030   8.396  35.544  1.00 11.92           N
ATOM   1554  C   GLN   198       7.518  11.297  31.678  1.00 12.38           C
ATOM   1555  O   GLN   198       8.072  12.232  31.095  1.00 12.34           O
ATOM   1556  N   LEU   199       6.698  10.461  31.058  1.00 12.17           N
ATOM   1557  CA  LEU   199       6.424  10.595  29.642  1.00 12.20           C
ATOM   1558  CB  LEU   199       5.543   9.430  29.205  1.00 12.49           C
ATOM   1559  CG  LEU   199       5.421   9.117  27.734  1.00 12.24           C
ATOM   1560  CD1 LEU   199       6.803   8.862  27.202  1.00 13.43           C
ATOM   1561  CD2 LEU   199       4.538   7.882  27.585  1.00 13.51           C
ATOM   1562  C   LEU   199       5.766  11.950  29.319  1.00 12.47           C
ATOM   1563  O   LEU   199       6.000  12.533  28.259  1.00 12.63           O
ATOM   1564  N   ALA   200       4.966  12.472  30.244  1.00 12.20           N
ATOM   1565  CA  ALA   200       4.410  13.800  30.059  1.00 12.43           C
ATOM   1566  CB  ALA   200       3.387  14.137  31.182  1.00 12.39           C
ATOM   1567  C   ALA   200       5.512  14.859  30.010  1.00 12.64           C
ATOM   1568  O   ALA   200       5.482  15.745  29.144  1.00 13.01           O
ATOM   1569  N   SER   201       6.469  14.784  30.939  1.00 12.08           N
ATOM   1570  CA  SER   201       7.543  15.767  30.996  1.00 12.37           C
ATOM   1571  CB  SER   201       8.272  15.725  32.337  1.00 12.50           C
ATOM   1572  OG  SER   201       8.865  14.464  32.527  1.00 15.19           O
ATOM   1573  C   SER   201       8.521  15.595  29.834  1.00 11.84           C
ATOM   1574  O   SER   201       8.949  16.569  29.235  1.00 12.03           O
ATOM   1575  N   ILE   202       8.858  14.364  29.492  1.00 11.64           N
ATOM   1576  CA  ILE   202       9.593  14.149  28.250  1.00 11.50           C
ATOM   1577  CB  ILE   202       9.883  12.661  27.987  1.00 10.98           C
ATOM   1578  CG1 ILE   202      10.881  12.131  29.032  1.00 10.77           C
ATOM   1579  CD1 ILE   202      10.783  10.603  29.318  1.00  8.30           C
ATOM   1580  CG2 ILE   202      10.451  12.473  26.573  1.00 11.35           C
ATOM   1581  C   ILE   202       8.880  14.814  27.051  1.00 11.56           C
ATOM   1582  O   ILE   202       9.453  15.672  26.385  1.00 11.84           O
ATOM   1583  N   PHE   203       7.635  14.441  26.787  1.00 11.93           N
ATOM   1584  CA  PHE   203       6.965  14.996  25.624  0.50 11.94           C
ATOM   1586  CB  PHE   203       5.571  14.404  25.461  0.50 11.71           C
ATOM   1588  CG  PHE   203       4.848  14.874  24.230  0.50 11.88           C
ATOM   1590  CD1 PHE   203       5.389  14.667  22.969  0.50 10.91           C
ATOM   1592  CE1 PHE   203       4.725  15.090  21.847  0.50 10.71           C
ATOM   1594  CZ  PHE   203       3.499  15.724  21.965  0.50  9.98           C
ATOM   1596  CE2 PHE   203       2.948  15.928  23.210  0.50 10.17           C
ATOM   1598  CD2 PHE   203       3.617  15.502  24.335  0.50  9.43           C
ATOM   1600  C   PHE   203       6.934  16.521  25.692  1.00 12.32           C
ATOM   1601  O   PHE   203       7.109  17.177  24.664  1.00 12.57           O
ATOM   1602  N   LEU   204       6.748  17.079  26.886  1.00 12.06           N
ATOM   1603  CA  LEU   204       6.676  18.536  27.017  1.00 11.46           C
ATOM   1604  CB  LEU   204       6.340  18.939  28.456  1.00 11.75           C
ATOM   1605  CG  LEU   204       6.267  20.424  28.832  1.00 11.35           C
ATOM   1606  CD1 LEU   204       5.007  21.076  28.246  1.00 12.68           C
ATOM   1607  CD2 LEU   204       6.305  20.559  30.360  1.00  9.95           C
ATOM   1608  C   LEU   204       7.983  19.171  26.568  1.00 10.99           C
ATOM   1609  O   LEU   204       7.980  20.273  26.045  1.00  9.86           O
ATOM   1610  N   ALA   205       9.093  18.444  26.743  1.00 10.33           N
ATOM   1611  CA  ALA   205      10.423  18.951  26.374  1.00  9.39           C
ATOM   1612  CB  ALA   205      11.479  18.195  27.157  1.00  8.99           C
ATOM   1613  C   ALA   205      10.690  18.866  24.843  1.00  9.23           C
ATOM   1614  O   ALA   205      11.560  19.564  24.288  1.00  7.95           O
ATOM   1615  N   CYS   206       9.931  18.004  24.174  1.00  8.66           N
ATOM   1616  CA  CYS   206      10.042  17.784  22.743  1.00  8.14           C
ATOM   1617  CB  CYS   206       9.561  16.367  22.408  1.00  8.61           C
ATOM   1618  SG  CYS   206      10.609  15.008  22.963  1.00  7.47           S
ATOM   1619  C   CYS   206       9.174  18.775  21.971  1.00  8.69           C
ATOM   1620  O   CYS   206       8.042  18.450  21.608  1.00  8.50           O
ATOM   1621  N   THR   207       9.727  19.955  21.687  1.00  8.50           N
ATOM   1622  CA  THR   207       8.957  21.096  21.239  1.00  8.61           C
ATOM   1623  CB  THR   207       9.537  22.436  21.809  1.00  9.24           C
ATOM   1624  OG1 THR   207      10.972  22.399  21.770  1.00  8.99           O
ATOM   1625  CG2 THR   207       9.056  22.698  23.262  1.00  9.22           C
ATOM   1626  C   THR   207       8.962  21.248  19.721  1.00  7.85           C
ATOM   1627  O   THR   207       8.432  22.208  19.209  1.00  7.52           O
ATOM   1628  N   SER   208       9.587  20.317  19.005  1.00  6.77           N
ATOM   1629  CA  SER   208       9.620  20.407  17.541  1.00  5.87           C
ATOM   1630  CB  SER   208      10.397  19.230  16.935  1.00  5.73           C
ATOM   1631  OG  SER   208      10.199  19.169  15.524  1.00  6.44           O
ATOM   1632  C   SER   208       8.219  20.394  16.966  1.00  5.58           C
ATOM   1633  O   SER   208       7.373  19.582  17.373  1.00  5.60           O
ATOM   1634  N   HIS   209       7.983  21.254  15.988  1.00  5.81           N
ATOM   1635  CA  HIS   209       6.730  21.244  15.258  1.00  6.57           C
ATOM   1636  CB  HIS   209       6.696  22.373  14.210  1.00  7.29           C
ATOM   1637  CG  HIS   209       7.680  22.206  13.087  1.00  8.13           C
ATOM   1638  ND1 HIS   209       7.304  21.805  11.820  1.00 10.61           N
ATOM   1639  CE1 HIS   209       8.373  21.746  11.041  1.00 10.03           C
ATOM   1640  NE2 HIS   209       9.426  22.104  11.755  1.00  9.86           N
ATOM   1641  CD2 HIS   209       9.019  22.404  13.034  1.00  8.52           C
ATOM   1642  C   HIS   209       6.517  19.895  14.591  1.00  6.78           C
ATOM   1643  O   HIS   209       5.392  19.545  14.240  1.00  6.70           O
ATOM   1644  N   LYS   210       7.593  19.119  14.449  1.00  5.95           N
ATOM   1645  CA  LYS   210       7.508  17.858  13.718  1.00  6.38           C
ATOM   1646  CB  LYS   210       8.816  17.559  12.956  1.00  6.79           C
ATOM   1647  CG  LYS   210       9.243  18.475  11.827  1.00  7.73           C
ATOM   1648  CD  LYS   210      10.190  17.692  10.897  1.00 11.94           C
ATOM   1649  CE  LYS   210      10.743  18.551   9.744  1.00 14.22           C
ATOM   1650  NZ  LYS   210      12.176  18.933   9.962  1.00 15.72           N
ATOM   1651  C   LYS   210       7.273  16.622  14.603  1.00  5.72           C
ATOM   1652  O   LYS   210       7.110  15.534  14.060  1.00  4.45           O
ATOM   1653  N   VAL   211       7.293  16.773  15.930  1.00  5.05           N
ATOM   1654  CA  VAL   211       7.372  15.593  16.802  1.00  5.54           C
ATOM   1655  CB  VAL   211       7.568  15.963  18.279  1.00  5.85           C
ATOM   1656  CG1 VAL   211       6.302  16.700  18.848  1.00  4.88           C
ATOM   1657  CG2 VAL   211       7.953  14.708  19.085  1.00  7.06           C
ATOM   1658  C   VAL   211       6.190  14.635  16.621  1.00  6.08           C
ATOM   1659  O   VAL   211       5.033  15.047  16.528  1.00  5.71           O
ATOM   1660  N   ARG   212       6.495  13.353  16.489  1.00  6.25           N
ATOM   1661  CA  ARG   212       5.447  12.346  16.499  1.00  6.87           C
ATOM   1662  CB  ARG   212       5.242  11.738  15.099  1.00  6.95           C
ATOM   1663  CG  ARG   212       4.868  12.782  14.018  1.00  7.15           C
ATOM   1664  CD  ARG   212       3.486  13.385  14.336  1.00  9.91           C
ATOM   1665  NE  ARG   212       3.017  14.177  13.223  1.00 13.37           N
ATOM   1666  CZ  ARG   212       3.284  15.470  13.067  1.00 18.86           C
ATOM   1667  NH1 ARG   212       4.011  16.113  13.968  1.00 20.13           N
ATOM   1668  NH2 ARG   212       2.814  16.128  12.019  1.00 20.40           N
ATOM   1669  C   ARG   212       5.830  11.277  17.499  1.00  7.01           C
ATOM   1670  O   ARG   212       7.002  11.097  17.763  1.00  6.38           O
ATOM   1671  N   ARG   213       4.834  10.582  18.040  1.00  6.71           N
ATOM   1672  CA  ARG   213       5.040   9.531  19.041  1.00  7.05           C
ATOM   1673  CB  ARG   213       4.278   9.874  20.347  1.00  6.81           C
ATOM   1674  CG  ARG   213       4.856  11.085  21.094  1.00  8.21           C
ATOM   1675  CD  ARG   213       3.899  11.702  22.059  1.00 12.29           C
ATOM   1676  NE  ARG   213       2.776  12.327  21.355  1.00 16.12           N
ATOM   1677  CZ  ARG   213       1.762  12.954  21.961  1.00 17.02           C
ATOM   1678  NH1 ARG   213       1.721  13.033  23.294  1.00 14.75           N
ATOM   1679  NH2 ARG   213       0.773  13.482  21.231  1.00 12.42           N
ATOM   1680  C   ARG   213       4.581   8.160  18.539  1.00  7.44           C
ATOM   1681  O   ARG   213       3.526   8.013  17.892  1.00  7.88           O
ATOM   1682  N   ALA   214       5.343   7.144  18.880  1.00  6.79           N
ATOM   1683  CA  ALA   214       4.918   5.798  18.563  1.00  6.25           C
ATOM   1684  CB  ALA   214       5.749   5.257  17.391  1.00  4.60           C
ATOM   1685  C   ALA   214       5.129   4.970  19.809  1.00  6.08           C
ATOM   1686  O   ALA   214       6.212   5.025  20.421  1.00  6.74           O
ATOM   1687  N   MET   215       4.102   4.213  20.206  1.00  5.11           N
ATOM   1688  CA  MET   215       4.236   3.318  21.332  1.00  5.53           C
ATOM   1689  CB  MET   215       3.099   3.502  22.325  1.00  5.46           C
ATOM   1690  CG  MET   215       2.756   4.944  22.683  1.00  8.94           C
ATOM   1691  SD  MET   215       4.000   5.739  23.717  1.00 12.43           S
ATOM   1692  CE  MET   215       3.548   5.088  25.322  1.00  9.43           C
ATOM   1693  C   MET   215       4.230   1.858  20.861  1.00  5.58           C
ATOM   1694  O   MET   215       3.277   1.415  20.217  1.00  5.62           O
ATOM   1695  N   PHE   216       5.268   1.118  21.224  1.00  4.63           N
ATOM   1696  CA  PHE   216       5.381  -0.282  20.899  1.00  4.89           C
ATOM   1697  CB  PHE   216       6.727  -0.559  20.202  1.00  4.64           C
ATOM   1698  CG  PHE   216       6.734  -0.172  18.746  1.00  4.39           C
ATOM   1699  CD1 PHE   216       6.676  -1.146  17.750  1.00  2.00           C
ATOM   1700  CE1 PHE   216       6.659  -0.786  16.377  1.00  2.00           C
ATOM   1701  CZ  PHE   216       6.718   0.554  16.029  1.00  2.00           C
ATOM   1702  CE2 PHE   216       6.765   1.543  17.014  1.00  2.00           C
ATOM   1703  CD2 PHE   216       6.778   1.176  18.372  1.00  4.24           C
ATOM   1704  C   PHE   216       5.228  -1.110  22.178  1.00  5.74           C
ATOM   1705  O   PHE   216       5.722  -0.727  23.245  1.00  6.17           O
ATOM   1706  N   SER   217       4.515  -2.222  22.068  1.00  5.46           N
ATOM   1707  CA  SER   217       4.262  -3.076  23.216  0.50  6.34           C
ATOM   1709  CB  SER   217       2.971  -2.670  23.906  0.50  6.10           C
ATOM   1711  OG  SER   217       1.890  -2.925  23.039  0.50  7.75           O
ATOM   1713  C   SER   217       4.143  -4.524  22.776  1.00  6.59           C
ATOM   1714  O   SER   217       3.816  -4.815  21.618  1.00  5.80           O
ATOM   1715  N   ALA   218       4.422  -5.436  23.704  1.00  7.17           N
ATOM   1716  CA  ALA   218       4.335  -6.854  23.398  1.00  9.39           C
ATOM   1717  CB  ALA   218       5.139  -7.677  24.397  1.00  9.06           C
ATOM   1718  C   ALA   218       2.886  -7.315  23.390  1.00 11.47           C
ATOM   1719  O   ALA   218       2.525  -8.250  22.674  1.00 12.22           O
ATOM   1720  N   THR   219       2.056  -6.676  24.197  1.00 13.13           N
ATOM   1721  CA  THR   219       0.703  -7.144  24.372  1.00 15.75           C
ATOM   1722  CB  THR   219       0.460  -7.633  25.803  1.00 16.00           C
ATOM   1723  OG1 THR   219       0.714  -6.555  26.712  1.00 15.79           O
ATOM   1724  CG2 THR   219       1.352  -8.830  26.155  1.00 16.51           C
ATOM   1725  C   THR   219      -0.252  -5.991  24.172  1.00 17.61           C
ATOM   1726  O   THR   219       0.005  -4.871  24.629  1.00 17.37           O
ATOM   1727  N   PHE   220      -1.381  -6.281  23.537  1.00 19.65           N
ATOM   1728  CA  PHE   220      -2.409  -5.277  23.323  1.00 21.75           C
ATOM   1729  CB  PHE   220      -3.269  -5.662  22.099  1.00 22.32           C
ATOM   1730  CG  PHE   220      -4.248  -4.592  21.653  1.00 25.67           C
ATOM   1731  CD1 PHE   220      -3.857  -3.253  21.481  1.00 27.90           C
ATOM   1732  CE1 PHE   220      -4.765  -2.286  21.056  1.00 29.11           C
ATOM   1733  CZ  PHE   220      -6.073  -2.651  20.768  1.00 29.43           C
ATOM   1734  CE2 PHE   220      -6.469  -3.975  20.914  1.00 29.06           C
ATOM   1735  CD2 PHE   220      -5.558  -4.938  21.345  1.00 27.95           C
ATOM   1736  C   PHE   220      -3.236  -5.075  24.604  1.00 22.23           C
ATOM   1737  O   PHE   220      -4.224  -5.791  24.843  1.00 22.55           O
ATOM   1738  N   ALA   221      -2.800  -4.099  25.420  1.00 22.77           N
ATOM   1739  CA  ALA   221      -3.206  -3.919  26.834  1.00 23.15           C
ATOM   1740  CB  ALA   221      -1.987  -3.967  27.735  1.00 23.36           C
ATOM   1741  C   ALA   221      -3.995  -2.643  27.128  1.00 23.64           C
ATOM   1742  O   ALA   221      -3.836  -1.633  26.437  1.00 24.08           O
ATOM   1743  N   TYR   222      -4.778  -2.676  28.213  1.00 23.88           N
ATOM   1744  CA  TYR   222      -5.899  -1.747  28.409  1.00 23.76           C
ATOM   1745  CB  TYR   222      -6.852  -2.219  29.525  1.00 23.84           C
ATOM   1746  CG  TYR   222      -8.114  -1.373  29.611  1.00 22.95           C
ATOM   1747  CD1 TYR   222      -8.362  -0.553  30.706  1.00 21.11           C
ATOM   1748  CE1 TYR   222      -9.505   0.234  30.764  1.00 20.73           C
ATOM   1749  CZ  TYR   222     -10.405   0.210  29.706  1.00 21.43           C
ATOM   1750  OH  TYR   222     -11.558   0.970  29.733  1.00 21.30           O
ATOM   1751  CE2 TYR   222     -10.167  -0.588  28.612  1.00 21.07           C
ATOM   1752  CD2 TYR   222      -9.035  -1.368  28.568  1.00 22.41           C
ATOM   1753  C   TYR   222      -5.536  -0.274  28.604  1.00 23.93           C
ATOM   1754  O   TYR   222      -6.041   0.587  27.871  1.00 23.70           O
ATOM   1755  N   ASP   223      -4.667   0.010  29.573  1.00 23.89           N
ATOM   1756  CA  ASP   223      -4.299   1.390  29.899  1.00 23.93           C
ATOM   1757  CB  ASP   223      -3.867   1.480  31.354  1.00 24.12           C
ATOM   1758  CG  ASP   223      -4.913   0.940  32.289  1.00 25.07           C
ATOM   1759  OD1 ASP   223      -5.890   0.337  31.786  1.00 26.45           O
ATOM   1760  OD2 ASP   223      -4.766   1.112  33.514  1.00 26.55           O
ATOM   1761  C   ASP   223      -3.218   1.970  28.989  1.00 23.63           C
ATOM   1762  O   ASP   223      -2.873   3.151  29.085  1.00 24.03           O
ATOM   1763  N   VAL   224      -2.654   1.130  28.133  1.00 23.23           N
ATOM   1764  CA  VAL   224      -1.780   1.621  27.078  1.00 22.54           C
ATOM   1765  CB  VAL   224      -0.801   0.530  26.574  1.00 22.68           C
ATOM   1766  CG1 VAL   224      -0.116   0.972  25.282  1.00 22.70           C
ATOM   1767  CG2 VAL   224       0.231   0.192  27.650  1.00 21.90           C
ATOM   1768  C   VAL   224      -2.725   2.025  25.959  1.00 22.12           C
ATOM   1769  O   VAL   224      -2.613   3.108  25.397  1.00 21.74           O
ATOM   1770  N   GLU   225      -3.683   1.156  25.657  1.00 21.44           N
ATOM   1771  CA  GLU   225      -4.665   1.496  24.659  1.00 21.09           C
ATOM   1772  CB  GLU   225      -5.676   0.372  24.484  1.00 21.13           C
ATOM   1773  CG  GLU   225      -6.498   0.482  23.211  1.00 22.03           C
ATOM   1777  C   GLU   225      -5.356   2.814  25.024  1.00 20.98           C
ATOM   1778  O   GLU   225      -5.438   3.701  24.184  1.00 20.36           O
ATOM   1779  N   GLN   226      -5.844   2.940  26.269  1.00 20.87           N
ATOM   1780  CA  GLN   226      -6.664   4.097  26.658  1.00 20.84           C
ATOM   1781  CB  GLN   226      -7.444   3.858  27.961  1.00 21.10           C
ATOM   1782  CG  GLN   226      -8.284   2.562  28.033  1.00 22.57           C
ATOM   1783  CD  GLN   226      -9.060   2.263  26.755  1.00 24.68           C
ATOM   1784  OE1 GLN   226      -9.809   3.104  26.254  1.00 25.31           O
ATOM   1785  NE2 GLN   226      -8.887   1.052  26.229  1.00 24.97           N
ATOM   1786  C   GLN   226      -5.814   5.344  26.817  1.00 20.54           C
ATOM   1787  O   GLN   226      -6.284   6.451  26.583  1.00 20.01           O
ATOM   1788  N   TRP   227      -4.564   5.158  27.233  1.00 20.27           N
ATOM   1789  CA  TRP   227      -3.615   6.260  27.325  1.00 20.01           C
ATOM   1790  CB  TRP   227      -2.295   5.772  27.915  1.00 19.94           C
ATOM   1791  CG  TRP   227      -1.322   6.886  28.125  1.00 19.70           C
ATOM   1792  CD1 TRP   227      -1.138   7.609  29.273  1.00 18.72           C
ATOM   1793  NE1 TRP   227      -0.162   8.558  29.074  1.00 20.06           N
ATOM   1794  CE2 TRP   227       0.300   8.463  27.785  1.00 19.66           C
ATOM   1795  CD2 TRP   227      -0.410   7.423  27.157  1.00 18.96           C
ATOM   1796  CE3 TRP   227      -0.130   7.127  25.819  1.00 18.76           C
ATOM   1797  CZ3 TRP   227       0.832   7.861  25.160  1.00 19.10           C
ATOM   1798  CH2 TRP   227       1.530   8.890  25.812  1.00 20.17           C
ATOM   1799  CZ2 TRP   227       1.278   9.204  27.121  1.00 20.71           C
ATOM   1800  C   TRP   227      -3.356   6.873  25.954  1.00 19.96           C
ATOM   1801  O   TRP   227      -3.308   8.094  25.807  1.00 20.42           O
ATOM   1802  N   CYS   228      -3.176   6.013  24.954  1.00 19.31           N
ATOM   1803  CA  CYS   228      -2.920   6.445  23.593  1.00 18.95           C
ATOM   1804  CB  CYS   228      -2.504   5.252  22.741  1.00 19.03           C
ATOM   1805  SG  CYS   228      -0.861   4.603  23.147  1.00 19.79           S
ATOM   1806  C   CYS   228      -4.119   7.132  22.939  1.00 18.92           C
ATOM   1807  O   CYS   228      -3.968   8.178  22.327  1.00 18.65           O
ATOM   1808  N   LYS   229      -5.302   6.536  23.055  1.00 18.56           N
ATOM   1809  CA  LYS   229      -6.505   7.127  22.486  1.00 18.76           C
ATOM   1810  CB  LYS   229      -7.734   6.230  22.716  1.00 19.36           C
ATOM   1811  CG  LYS   229      -7.663   4.852  22.059  1.00 21.21           C
ATOM   1812  CD  LYS   229      -7.392   4.929  20.565  1.00 23.63           C
ATOM   1813  CE  LYS   229      -7.177   3.540  19.966  1.00 25.76           C
ATOM   1814  NZ  LYS   229      -6.805   3.585  18.506  1.00 27.82           N
ATOM   1815  C   LYS   229      -6.749   8.497  23.101  1.00 18.28           C
ATOM   1816  O   LYS   229      -7.415   9.350  22.511  1.00 18.13           O
ATOM   1817  N   LEU   230      -6.204   8.686  24.297  1.00 17.51           N
ATOM   1818  CA  LEU   230      -6.429   9.882  25.085  1.00 16.44           C
ATOM   1819  CB  LEU   230      -6.469   9.507  26.565  1.00 16.68           C
ATOM   1820  CG  LEU   230      -6.671  10.597  27.622  1.00 17.29           C
ATOM   1821  CD1 LEU   230      -7.998  11.361  27.431  1.00 15.25           C
ATOM   1822  CD2 LEU   230      -6.575  10.007  29.036  1.00 16.30           C
ATOM   1823  C   LEU   230      -5.338  10.918  24.870  1.00 16.41           C
ATOM   1824  O   LEU   230      -5.627  12.113  24.847  1.00 15.62           O
ATOM   1825  N   ASN   231      -4.086  10.455  24.726  1.00 15.18           N
ATOM   1826  CA  ASN   231      -2.936  11.358  24.616  1.00 15.10           C
ATOM   1827  CB  ASN   231      -1.780  10.908  25.524  1.00 15.20           C
ATOM   1828  CG  ASN   231      -2.118  11.024  26.989  1.00 16.40           C
ATOM   1829  OD1 ASN   231      -1.876  12.050  27.600  1.00 19.89           O
ATOM   1830  ND2 ASN   231      -2.699   9.980  27.556  1.00 16.14           N
ATOM   1831  C   ASN   231      -2.388  11.572  23.211  1.00 14.43           C
ATOM   1832  O   ASN   231      -1.910  12.649  22.886  1.00 14.38           O
ATOM   1833  N   LEU   232      -2.427  10.548  22.376  1.00 13.75           N
ATOM   1834  CA  LEU   232      -1.818  10.675  21.068  1.00 13.37           C
ATOM   1835  CB  LEU   232      -1.364   9.307  20.553  1.00 13.33           C
ATOM   1836  CG  LEU   232      -0.354   8.650  21.496  1.00 14.58           C
ATOM   1837  CD1 LEU   232       0.263   7.332  20.959  1.00 13.39           C
ATOM   1838  CD2 LEU   232       0.744   9.642  21.859  1.00 13.48           C
ATOM   1839  C   LEU   232      -2.818  11.348  20.129  1.00 13.09           C
ATOM   1840  O   LEU   232      -4.015  11.348  20.384  1.00 12.53           O
ATOM   1841  N   ASP   233      -2.319  11.945  19.058  1.00 12.29           N
ATOM   1842  CA  ASP   233      -3.169  12.669  18.146  1.00 12.14           C
ATOM   1843  CB  ASP   233      -2.389  13.850  17.580  1.00 12.64           C
ATOM   1844  CG  ASP   233      -3.134  14.554  16.480  1.00 16.19           C
ATOM   1845  OD1 ASP   233      -4.346  14.788  16.653  1.00 18.48           O
ATOM   1846  OD2 ASP   233      -2.510  14.879  15.441  1.00 21.07           O
ATOM   1847  C   ASP   233      -3.597  11.748  17.008  1.00 10.84           C
ATOM   1848  O   ASP   233      -2.756  11.236  16.292  1.00  9.89           O
ATOM   1849  N   ASN   234      -4.898  11.546  16.836  1.00 10.24           N
ATOM   1850  CA  ASN   234      -5.405  10.779  15.685  1.00  9.30           C
ATOM   1851  CB  ASN   234      -5.152  11.575  14.396  1.00  9.66           C
ATOM   1852  CG  ASN   234      -6.078  11.181  13.249  1.00 11.52           C
ATOM   1853  OD1 ASN   234      -7.079  10.490  13.444  1.00 13.90           O
ATOM   1854  ND2 ASN   234      -5.742  11.635  12.035  1.00 10.14           N
ATOM   1855  C   ASN   234      -4.697   9.433  15.603  1.00  8.61           C
ATOM   1856  O   ASN   234      -4.295   9.007  14.540  1.00  8.68           O
ATOM   1857  N   VAL   235      -4.566   8.742  16.721  1.00  7.61           N
ATOM   1858  CA  VAL   235      -3.765   7.516  16.741  1.00  7.11           C
ATOM   1859  CB  VAL   235      -3.617   6.954  18.179  1.00  6.87           C
ATOM   1860  CG1 VAL   235      -4.926   6.281  18.651  1.00  7.79           C
ATOM   1861  CG2 VAL   235      -2.433   6.008  18.249  1.00  8.36           C
ATOM   1862  C   VAL   235      -4.228   6.397  15.780  1.00  6.32           C
ATOM   1863  O   VAL   235      -5.420   6.234  15.469  1.00  6.31           O
ATOM   1864  N   ILE   236      -3.259   5.649  15.279  1.00  4.55           N
ATOM   1865  CA  ILE   236      -3.546   4.446  14.536  1.00  3.33           C
ATOM   1866  CB  ILE   236      -2.837   4.470  13.165  1.00  2.95           C
ATOM   1867  CG1 ILE   236      -3.664   5.300  12.160  1.00  2.46           C
ATOM   1868  CD1 ILE   236      -2.974   5.455  10.825  1.00  2.00           C
ATOM   1869  CG2 ILE   236      -2.662   3.047  12.585  1.00  2.09           C
ATOM   1870  C   ILE   236      -3.080   3.279  15.408  1.00  2.76           C
ATOM   1871  O   ILE   236      -1.957   3.284  15.893  1.00  2.00           O
ATOM   1872  N   SER   237      -3.951   2.309  15.658  1.00  2.17           N
ATOM   1873  CA  SER   237      -3.561   1.124  16.410  0.50  2.36           C
ATOM   1875  CB  SER   237      -4.639   0.748  17.432  0.50  2.26           C
ATOM   1877  OG  SER   237      -4.774   1.743  18.432  0.50  3.72           O
ATOM   1879  C   SER   237      -3.319  -0.046  15.458  1.00  2.07           C
ATOM   1880  O   SER   237      -4.172  -0.361  14.637  1.00  2.41           O
ATOM   1881  N   VAL   238      -2.169  -0.693  15.576  1.00  2.00           N
ATOM   1882  CA  VAL   238      -1.904  -1.903  14.802  1.00  2.00           C
ATOM   1883  CB  VAL   238      -0.658  -1.761  13.899  1.00  2.00           C
ATOM   1884  CG1 VAL   238      -0.567  -2.949  12.933  1.00  2.00           C
ATOM   1885  CG2 VAL   238      -0.641  -0.414  13.145  1.00  2.00           C
ATOM   1886  C   VAL   238      -1.579  -2.991  15.804  1.00  2.00           C
ATOM   1887  O   VAL   238      -0.754  -2.789  16.712  1.00  2.00           O
ATOM   1888  N   SER   239      -2.214  -4.145  15.649  1.00  2.00           N
ATOM   1889  CA  SER   239      -1.970  -5.273  16.524  1.00  2.34           C
ATOM   1890  CB  SER   239      -3.114  -5.366  17.533  1.00  2.00           C
ATOM   1891  OG  SER   239      -2.943  -6.508  18.344  1.00  6.75           O
ATOM   1892  C   SER   239      -1.921  -6.548  15.658  1.00  2.00           C
ATOM   1893  O   SER   239      -2.731  -6.687  14.745  1.00  2.00           O
ATOM   1894  N   ILE   240      -0.966  -7.442  15.925  1.00  2.00           N
ATOM   1895  CA  ILE   240      -0.873  -8.715  15.206  1.00  2.00           C
ATOM   1896  CB  ILE   240       0.595  -9.118  14.933  1.00  2.16           C
ATOM   1897  CG1 ILE   240       1.417  -7.921  14.411  1.00  2.00           C
ATOM   1898  CD1 ILE   240       0.949  -7.394  13.061  1.00  2.00           C
ATOM   1899  CG2 ILE   240       0.656 -10.318  13.958  1.00  2.00           C
ATOM   1900  C   ILE   240      -1.531  -9.835  16.014  1.00  2.82           C
ATOM   1901  O   ILE   240      -1.113 -10.118  17.139  1.00  2.41           O
ATOM   1902  N   GLY   241      -2.549 -10.469  15.440  1.00  4.28           N
ATOM   1903  CA  GLY   241      -3.271 -11.528  16.131  1.00  5.85           C
ATOM   1904  C   GLY   241      -2.385 -12.757  16.158  1.00  7.38           C
ATOM   1905  O   GLY   241      -1.456 -12.859  15.349  1.00  7.69           O
ATOM   1906  N   ALA   242      -2.657 -13.683  17.082  1.00  8.07           N
ATOM   1907  CA  ALA   242      -1.779 -14.844  17.290  1.00  8.80           C
ATOM   1908  CB  ALA   242      -2.010 -15.465  18.671  1.00  8.95           C
ATOM   1909  C   ALA   242      -2.025 -15.864  16.210  1.00  8.74           C
ATOM   1910  O   ALA   242      -3.069 -15.819  15.578  1.00  9.49           O
END
