
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  120 (  955),  selected  120 , name 1yo7_A
# Molecule2: number of CA atoms  130 ( 1063),  selected  130 , name T0478_138_267.pdb
# PARAMETERS: 1yo7_A.T0478_138_267.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    T     2_A      D     138          5.491
LGA    K     3_A      A     139           #
LGA    -       -      L     140           -
LGA    -       -      P     141           -
LGA    -       -      D     142           -
LGA    Q     4_A      A     143          1.787
LGA    E     5_A      I     144          4.012
LGA    -       -      I     145           -
LGA    K     6_A      K     146          2.082
LGA    T     7_A      E     147          3.257
LGA    A     8_A      N     148          3.037
LGA    L     9_A      V     149          1.458
LGA    N    10_A      F     150          1.377
LGA    M    11_A      F     151          1.728
LGA    A    12_A      L     152          1.593
LGA    R    13_A      R     153          1.253
LGA    F    14_A      I     154          2.009
LGA    I    15_A      M     155          1.924
LGA    R    16_A      A     156          1.586
LGA    S    17_A      D     157          1.680
LGA    Q    18_A      X     158          2.251
LGA    T    19_A      A     159          1.758
LGA    L    20_A      K     160          1.503
LGA    T    21_A      F     161          2.054
LGA    L    22_A      I     162          2.191
LGA    L    23_A      G     163          1.246
LGA    E    24_A      X     164          0.873
LGA    K    25_A      L     165          0.727
LGA    L    26_A      L     166          0.962
LGA    N    27_A      D     167          3.611
LGA    E    28_A      -       -           -
LGA    L    29_A      P     168           #
LGA    D    30_A      S     169          2.467
LGA    A    31_A      E     170          2.281
LGA    D    32_A      R     171          2.183
LGA    E    33_A      K     172          2.476
LGA    Q    34_A      L     173          1.963
LGA    A    35_A      V     174          1.116
LGA    D    36_A      D     175          1.660
LGA    I    37_A      T     176          1.659
LGA    C    38_A      A     177          1.010
LGA    E    39_A      R     178          1.299
LGA    S    40_A      N     179          1.719
LGA    L    41_A      F     180          1.472
LGA    H    42_A      S     181          0.883
LGA    D    43_A      N     182          1.755
LGA    H    44_A      D     183          1.903
LGA    A    45_A      F     184          1.091
LGA    D    46_A      D     185          1.304
LGA    E    47_A      E     186          2.062
LGA    L    48_A      L     187          1.745
LGA    Y    49_A      M     188          1.072
LGA    R    50_A      Y     189          1.689
LGA    S    51_A      Q     190          2.038
LGA    C    52_A      A     191          1.818
LGA    L    53_A      I     192          2.006
LGA    A    54_A      D     193          2.590
LGA    S    55_A      L     194          2.395
LGA    F    56_A      E     195          2.650
LGA    K    57_A      S     196          2.759
LGA    K    58_A      M     197          2.784
LGA    -       -      K     198           -
LGA    -       -      P     199           -
LGA    -       -      Q     200           -
LGA    N    59_A      S     201          2.884
LGA    G    60_A      Q     202          3.584
LGA    -       -      T     203           -
LGA    -       -      A     204           -
LGA    -       -      P     205           -
LGA    Q    61_A      L     206          3.971
LGA    I    62_A      L     207          1.760
LGA    D    63_A      D     208          2.432
LGA    E    64_A      Q     209          3.099
LGA    Q    65_A      F     210          3.071
LGA    A    66_A      L     211          2.346
LGA    D    67_A      D     212          2.814
LGA    I    68_A      Q     213          3.111
LGA    C    69_A      N     214          3.149
LGA    E    70_A      R     215          2.764
LGA    S    71_A      V     216          2.652
LGA    L    72_A      S     217          2.318
LGA    H    73_A      V     218          2.991
LGA    -       -      A     219           -
LGA    D    74_A      S     220          1.424
LGA    H    75_A      L     221          3.031
LGA    A    76_A      R     222          3.358
LGA    D    77_A      D     223          1.339
LGA    E    78_A      F     224          2.448
LGA    L    79_A      K     225          4.082
LGA    Y    80_A      K     226          3.194
LGA    R    81_A      T     227          0.986
LGA    S    82_A      A     228          4.241
LGA    C    83_A      R     229          5.047
LGA    L    84_A      D     230          2.156
LGA    A    85_A      L     231          3.135
LGA    -       -      I     232           -
LGA    -       -      E     233           -
LGA    -       -      Q     234           -
LGA    -       -      C     235           -
LGA    R    86_A      K     236          1.974
LGA    F    87_A      I     237          3.228
LGA    G    88_A      K     238           #
LGA    G    89_A      -       -           -
LGA    S    90_A      -       -           -
LGA    K    91_A      -       -           -
LGA    Q    92_A      -       -           -
LGA    E    93_A      S     239          4.458
LGA    K    94_A      I     240           #
LGA    T    95_A      I     241          3.131
LGA    A    96_A      X     242          4.529
LGA    L    97_A      P     243          3.572
LGA    N    98_A      L     244          3.093
LGA    M    99_A      L     245          2.895
LGA    A   100_A      A     246          3.020
LGA    R   101_A      D     247          2.717
LGA    F   102_A      X     248          2.537
LGA    I   103_A      V     249          2.568
LGA    R   104_A      F     250          2.583
LGA    S   105_A      R     251          2.343
LGA    Q   106_A      E     252          1.984
LGA    T   107_A      A     253          2.087
LGA    L   108_A      D     254          2.248
LGA    T   109_A      R     255          1.984
LGA    L   110_A      F     256          1.715
LGA    L   111_A      L     257          2.617
LGA    E   112_A      E     258          2.496
LGA    K   113_A      I     259          2.017
LGA    L   114_A      I     260          2.696
LGA    N   115_A      D     261          3.404
LGA    E   116_A      M     262          3.217
LGA    L   117_A      Y     263          3.134
LGA    A   118_A      D     264          3.802
LGA    -       -      V     265           -
LGA    -       -      X     266           -
LGA    K   119_A      L     267          0.516
LGA    G   120_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  120  130    5.0    109    2.56    11.93     60.706     4.099

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.245116 * X  +  -0.425657 * Y  +  -0.871053 * Z  +  50.845497
  Y_new =  -0.151333 * X  +  -0.870650 * Y  +   0.468046 * Z  +  69.922485
  Z_new =  -0.957610 * X  +   0.246545 * Y  +   0.148994 * Z  +  95.656830 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.027201   -2.114392  [ DEG:    58.8543   -121.1457 ]
  Theta =   1.278587    1.863006  [ DEG:    73.2576    106.7424 ]
  Phi   =  -2.588480    0.553112  [ DEG:  -148.3090     31.6910 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yo7_A                                        
REMARK     2: T0478_138_267.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yo7_A.T0478_138_267.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  120  130   5.0  109   2.56   11.93  60.706
REMARK  ---------------------------------------------------------- 
MOLECULE 1yo7_A
HEADER    REPLICATION REGULATOR                   26-JAN-05   1YO7              
TITLE     RE-ENGINEERING TOPOLOGY OF THE HOMODIMERIC ROP PROTEIN INTO           
TITLE    2 A SINGLE-CHAIN 4-HELIX BUNDLE                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: REGULATORY PROTEIN ROP;                                    
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: RNA ONE MODULATOR, ROM;                                     
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ROP;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: K-12;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PEX70;                                    
SOURCE  10 OTHER_DETAILS: THE GENE FOR LMROP2 WAS ARTIFICIALLY                  
SOURCE  11 ASSEMBLED USING CASSETTE MUTAGENESIS AND CLONED INTO THE             
SOURCE  12 EXPRESSION VECTOR                                                    
KEYWDS    PROTEIN DESIGN, RE-ENGINEERING OF TOPOLOGY, FOUR-HELIX                
KEYWDS   2 BUNDLE                                                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.SAGERMANN,S.C.EMERY,C.SANDER                                        
REVDAT   1   15-FEB-05 1YO7    0                                                
JRNL        AUTH   M.SAGERMANN,S.C.EMERY,C.SANDER                               
JRNL        TITL   RE-ENGINEERING TOPOLOGY OF THE HOMODIMERIC ROP               
JRNL        TITL 2 PROTEIN INTO A SINGLE-CHAIN 4-HELIX BUNDLE.                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  1YO7 A    1    56  UNP    P03051   ROP_ECOLI        1     56             
DBREF  1YO7 A   63    87  UNP    P03051   ROP_ECOLI       32     56             
DBREF  1YO7 A   91   117  UNP    P03051   ROP_ECOLI        3     29             
DBREF  1YO7 B    1    56  UNP    P03051   ROP_ECOLI        1     56             
DBREF  1YO7 B   63    87  UNP    P03051   ROP_ECOLI       32     56             
DBREF  1YO7 B   91   117  UNP    P03051   ROP_ECOLI        3     29             
SEQRES   1 A  120  MET THR LYS GLN GLU LYS THR ALA LEU ASN MET ALA ARG          
SEQRES   2 A  120  PHE ILE ARG SER GLN THR LEU THR LEU LEU GLU LYS LEU          
SEQRES   3 A  120  ASN GLU LEU ASP ALA ASP GLU GLN ALA ASP ILE CYS GLU          
SEQRES   4 A  120  SER LEU HIS ASP HIS ALA ASP GLU LEU TYR ARG SER CYS          
SEQRES   5 A  120  LEU ALA SER PHE LYS LYS ASN GLY GLN ILE ASP GLU GLN          
SEQRES   6 A  120  ALA ASP ILE CYS GLU SER LEU HIS ASP HIS ALA ASP GLU          
SEQRES   7 A  120  LEU TYR ARG SER CYS LEU ALA ARG PHE GLY GLY SER LYS          
SEQRES   8 A  120  GLN GLU LYS THR ALA LEU ASN MET ALA ARG PHE ILE ARG          
SEQRES   9 A  120  SER GLN THR LEU THR LEU LEU GLU LYS LEU ASN GLU LEU          
SEQRES  10 A  120  ALA LYS GLY                                                  
SEQRES   1 B  120  MET THR LYS GLN GLU LYS THR ALA LEU ASN MET ALA ARG          
SEQRES   2 B  120  PHE ILE ARG SER GLN THR LEU THR LEU LEU GLU LYS LEU          
SEQRES   3 B  120  ASN GLU LEU ASP ALA ASP GLU GLN ALA ASP ILE CYS GLU          
SEQRES   4 B  120  SER LEU HIS ASP HIS ALA ASP GLU LEU TYR ARG SER CYS          
SEQRES   5 B  120  LEU ALA SER PHE LYS LYS ASN GLY GLN ILE ASP GLU GLN          
SEQRES   6 B  120  ALA ASP ILE CYS GLU SER LEU HIS ASP HIS ALA ASP GLU          
SEQRES   7 B  120  LEU TYR ARG SER CYS LEU ALA ARG PHE GLY GLY SER LYS          
SEQRES   8 B  120  GLN GLU LYS THR ALA LEU ASN MET ALA ARG PHE ILE ARG          
SEQRES   9 B  120  SER GLN THR LEU THR LEU LEU GLU LYS LEU ASN GLU LEU          
SEQRES  10 B  120  ALA LYS GLY                                                  
HET     ZN    201       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   3   ZN    ZN 2+                                                        
FORMUL   4  HOH   *21(H2 O)                                                     
CRYST1   46.607   52.830   50.360  90.00  94.99  90.00 P 1 21 1      4          
ATOM      1  N   MET A   1      26.419  82.626 110.489  1.00  4.27           N  
ATOM      2  CA  MET A   1      25.437  82.797 109.391  1.00  4.18           C  
ATOM      3  C   MET A   1      24.075  82.314 109.870  1.00  3.93           C  
ATOM      4  O   MET A   1      23.982  81.332 110.597  1.00  4.61           O  
ATOM      5  CB  MET A   1      25.892  81.984 108.178  1.00  5.40           C  
ATOM      6  CG  MET A   1      25.146  82.277 106.881  1.00  7.71           C  
ATOM      7  SD  MET A   1      25.537  81.052 105.632  1.00 10.45           S  
ATOM      8  CE  MET A   1      27.318  81.345 105.463  1.00  8.80           C  
ATOM      9  N   THR A   2      23.017  82.996 109.450  1.00  5.10           N  
ATOM     10  CA  THR A   2      21.658  82.644 109.839  1.00  5.98           C  
ATOM     11  C   THR A   2      21.017  81.641 108.886  1.00  6.79           C  
ATOM     12  O   THR A   2      21.535  81.396 107.798  1.00  6.63           O  
ATOM     13  CB  THR A   2      20.789  83.899 109.885  1.00  6.13           C  
ATOM     14  OG1 THR A   2      21.338  84.821 110.833  1.00  6.66           O  
ATOM     15  CG2 THR A   2      19.374  83.550 110.293  1.00  7.96           C  
ATOM     16  N   LYS A   3      19.894  81.053 109.306  1.00  9.39           N  
ATOM     17  CA  LYS A   3      19.167  80.080 108.482  1.00 10.56           C  
ATOM     18  C   LYS A   3      18.759  80.800 107.219  1.00 10.62           C  
ATOM     19  O   LYS A   3      18.842  80.249 106.131  1.00 10.89           O  
ATOM     20  CB  LYS A   3      17.900  79.573 109.186  1.00 13.39           C  
ATOM     21  CG  LYS A   3      18.114  78.870 110.529  1.00 15.87           C  
ATOM     22  CD  LYS A   3      16.782  78.382 111.107  1.00 17.58           C  
ATOM     23  CE  LYS A   3      16.913  77.905 112.560  1.00 20.88           C  
ATOM     24  NZ  LYS A   3      17.785  76.700 112.755  1.00 21.98           N  
ATOM     25  N   GLN A   4      18.309  82.038 107.375  1.00 10.72           N  
ATOM     26  CA  GLN A   4      17.906  82.845 106.236  1.00 12.36           C  
ATOM     27  C   GLN A   4      19.036  82.868 105.215  1.00 11.04           C  
ATOM     28  O   GLN A   4      18.887  82.404 104.086  1.00 11.82           O  
ATOM     29  CB  GLN A   4      17.619  84.284 106.670  1.00 15.60           C  
ATOM     30  CG  GLN A   4      16.369  84.491 107.503  1.00 19.64           C  
ATOM     31  CD  GLN A   4      16.134  85.968 107.800  1.00 22.71           C  
ATOM     32  OE1 GLN A   4      16.931  86.612 108.490  1.00 23.76           O  
ATOM     33  NE2 GLN A   4      15.045  86.512 107.266  1.00 23.60           N  
ATOM     34  N   GLU A   5      20.164  83.428 105.641  1.00 10.09           N  
ATOM     35  CA  GLU A   5      21.364  83.556 104.824  1.00  8.12           C  
ATOM     36  C   GLU A   5      21.775  82.229 104.199  1.00  7.20           C  
ATOM     37  O   GLU A   5      22.034  82.156 103.006  1.00  7.71           O  
ATOM     38  CB  GLU A   5      22.501  84.096 105.687  1.00  8.28           C  
ATOM     39  CG  GLU A   5      21.997  84.864 106.906  1.00  7.70           C  
ATOM     40  CD  GLU A   5      22.861  86.060 107.261  1.00  8.98           C  
ATOM     41  OE1 GLU A   5      24.018  85.866 107.703  1.00  8.27           O  
ATOM     42  OE2 GLU A   5      22.372  87.200 107.088  1.00  9.24           O  
ATOM     43  N   LYS A   6      21.824  81.178 105.010  1.00  6.87           N  
ATOM     44  CA  LYS A   6      22.212  79.856 104.529  1.00  5.80           C  
ATOM     45  C   LYS A   6      21.327  79.383 103.376  1.00  4.82           C  
ATOM     46  O   LYS A   6      21.824  78.944 102.344  1.00  4.47           O  
ATOM     47  CB  LYS A   6      22.166  78.854 105.682  1.00  5.90           C  
ATOM     48  CG  LYS A   6      22.877  77.560 105.393  1.00  6.89           C  
ATOM     49  CD  LYS A   6      22.822  76.638 106.595  1.00  9.34           C  
ATOM     50  CE  LYS A   6      23.691  77.141 107.745  1.00 12.51           C  
ATOM     51  NZ  LYS A   6      25.161  76.941 107.507  1.00 13.87           N  
ATOM     52  N   THR A   7      20.011  79.473 103.555  1.00  4.92           N  
ATOM     53  CA  THR A   7      19.064  79.072 102.523  1.00  3.33           C  
ATOM     54  C   THR A   7      19.404  79.846 101.264  1.00  3.64           C  
ATOM     55  O   THR A   7      19.600  79.255 100.205  1.00  4.66           O  
ATOM     56  CB  THR A   7      17.616  79.409 102.922  1.00  3.06           C  
ATOM     57  OG1 THR A   7      17.292  78.743 104.143  1.00  1.77           O  
ATOM     58  CG2 THR A   7      16.648  78.970 101.845  1.00  2.10           C  
ATOM     59  N   ALA A   8      19.470  81.170 101.380  1.00  3.15           N  
ATOM     60  CA  ALA A   8      19.806  82.016 100.239  1.00  4.06           C  
ATOM     61  C   ALA A   8      21.167  81.619  99.659  1.00  4.43           C  
ATOM     62  O   ALA A   8      21.384  81.697  98.453  1.00  4.71           O  
ATOM     63  CB  ALA A   8      19.822  83.474 100.651  1.00  3.35           C  
ATOM     64  N   LEU A   9      22.094  81.195 100.508  1.00  4.51           N  
ATOM     65  CA  LEU A   9      23.386  80.786  99.991  1.00  5.56           C  
ATOM     66  C   LEU A   9      23.191  79.455  99.273  1.00  5.70           C  
ATOM     67  O   LEU A   9      23.705  79.245  98.166  1.00  5.96           O  
ATOM     68  CB  LEU A   9      24.406  80.611 101.113  1.00  6.30           C  
ATOM     69  CG  LEU A   9      25.833  80.463 100.578  1.00  6.62           C  
ATOM     70  CD1 LEU A   9      26.322  81.803 100.045  1.00  7.11           C  
ATOM     71  CD2 LEU A   9      26.747  79.980 101.679  1.00  8.51           C  
ATOM     72  N   ASN A  10      22.429  78.564  99.904  1.00  4.87           N  
ATOM     73  CA  ASN A  10      22.169  77.247  99.341  1.00  3.59           C  
ATOM     74  C   ASN A  10      21.389  77.304  98.044  1.00  1.91           C  
ATOM     75  O   ASN A  10      21.369  76.342  97.294  1.00  3.12           O  
ATOM     76  CB  ASN A  10      21.426  76.360 100.347  1.00  4.08           C  
ATOM     77  CG  ASN A  10      22.349  75.757 101.405  1.00  4.96           C  
ATOM     78  OD1 ASN A  10      21.914  74.973 102.254  1.00  4.28           O  
ATOM     79  ND2 ASN A  10      23.624  76.119 101.357  1.00  4.56           N  
ATOM     80  N   MET A  11      20.752  78.433  97.770  1.00  1.68           N  
ATOM     81  CA  MET A  11      19.972  78.562  96.549  1.00  1.00           C  
ATOM     82  C   MET A  11      20.873  79.054  95.432  1.00  1.00           C  
ATOM     83  O   MET A  11      20.735  78.646  94.279  1.00  1.00           O  
ATOM     84  CB  MET A  11      18.818  79.531  96.776  1.00  1.93           C  
ATOM     85  CG  MET A  11      17.598  79.249  95.928  1.00  3.29           C  
ATOM     86  SD  MET A  11      16.147  80.140  96.539  1.00  8.09           S  
ATOM     87  CE  MET A  11      15.855  79.244  98.082  1.00  5.23           C  
ATOM     88  N   ALA A  12      21.814  79.921  95.800  1.00  1.25           N  
ATOM     89  CA  ALA A  12      22.773  80.491  94.863  1.00  1.31           C  
ATOM     90  C   ALA A  12      23.677  79.396  94.305  1.00  1.11           C  
ATOM     91  O   ALA A  12      23.824  79.266  93.094  1.00  1.11           O  
ATOM     92  CB  ALA A  12      23.602  81.555  95.560  1.00  1.00           C  
ATOM     93  N   ARG A  13      24.279  78.607  95.191  1.00  1.55           N  
ATOM     94  CA  ARG A  13      25.157  77.529  94.757  1.00  2.32           C  
ATOM     95  C   ARG A  13      24.399  76.555  93.871  1.00  1.39           C  
ATOM     96  O   ARG A  13      24.918  76.053  92.877  1.00  1.95           O  
ATOM     97  CB  ARG A  13      25.737  76.786  95.964  1.00  4.05           C  
ATOM     98  CG  ARG A  13      24.719  76.434  97.034  1.00  6.49           C  
ATOM     99  CD  ARG A  13      25.284  75.408  98.024  1.00 10.40           C  
ATOM    100  NE  ARG A  13      26.508  75.851  98.699  1.00 12.96           N  
ATOM    101  CZ  ARG A  13      26.546  76.592  99.807  1.00 13.37           C  
ATOM    102  NH1 ARG A  13      27.715  76.937 100.332  1.00 14.44           N  
ATOM    103  NH2 ARG A  13      25.427  76.983 100.399  1.00 12.70           N  
ATOM    104  N   PHE A  14      23.161  76.275  94.231  1.00  1.00           N  
ATOM    105  CA  PHE A  14      22.384  75.368  93.424  1.00  2.20           C  
ATOM    106  C   PHE A  14      22.251  75.920  92.001  1.00  2.35           C  
ATOM    107  O   PHE A  14      22.359  75.178  91.026  1.00  3.23           O  
ATOM    108  CB  PHE A  14      21.017  75.161  94.059  1.00  3.23           C  
ATOM    109  CG  PHE A  14      20.127  74.266  93.272  1.00  5.79           C  
ATOM    110  CD1 PHE A  14      19.251  74.793  92.331  1.00  7.53           C  
ATOM    111  CD2 PHE A  14      20.187  72.887  93.444  1.00  6.35           C  
ATOM    112  CE1 PHE A  14      18.441  73.957  91.570  1.00  9.59           C  
ATOM    113  CE2 PHE A  14      19.388  72.039  92.692  1.00  7.30           C  
ATOM    114  CZ  PHE A  14      18.511  72.570  91.750  1.00  9.32           C  
ATOM    115  N   ILE A  15      22.032  77.224  91.876  1.00  1.46           N  
ATOM    116  CA  ILE A  15      21.898  77.826  90.558  1.00  1.00           C  
ATOM    117  C   ILE A  15      23.211  77.752  89.767  1.00  1.59           C  
ATOM    118  O   ILE A  15      23.185  77.620  88.542  1.00  1.99           O  
ATOM    119  CB  ILE A  15      21.412  79.295  90.661  1.00  1.09           C  
ATOM    120  CG1 ILE A  15      20.027  79.333  91.319  1.00  2.24           C  
ATOM    121  CG2 ILE A  15      21.338  79.935  89.283  1.00  1.00           C  
ATOM    122  CD1 ILE A  15      19.465  80.740  91.542  1.00  2.24           C  
ATOM    123  N   ARG A  16      24.353  77.832  90.454  1.00  1.74           N  
ATOM    124  CA  ARG A  16      25.652  77.730  89.777  1.00  1.89           C  
ATOM    125  C   ARG A  16      25.828  76.387  89.076  1.00  1.97           C  
ATOM    126  O   ARG A  16      26.441  76.321  88.008  1.00  2.16           O  
ATOM    127  CB  ARG A  16      26.804  77.904  90.757  1.00  1.05           C  
ATOM    128  CG  ARG A  16      27.048  79.319  91.152  1.00  1.00           C  
ATOM    129  CD  ARG A  16      28.244  79.425  92.058  1.00  1.00           C  
ATOM    130  NE  ARG A  16      29.494  79.215  91.343  1.00  1.00           N  
ATOM    131  CZ  ARG A  16      30.687  79.480  91.859  1.00  1.00           C  
ATOM    132  NH1 ARG A  16      30.789  79.964  93.084  1.00  1.55           N  
ATOM    133  NH2 ARG A  16      31.779  79.258  91.158  1.00  2.14           N  
ATOM    134  N   SER A  17      25.302  75.325  89.688  1.00  2.43           N  
ATOM    135  CA  SER A  17      25.372  73.973  89.133  1.00  2.88           C  
ATOM    136  C   SER A  17      24.336  73.759  88.035  1.00  3.97           C  
ATOM    137  O   SER A  17      24.637  73.175  86.994  1.00  4.16           O  
ATOM    138  CB  SER A  17      25.132  72.938  90.222  1.00  3.31           C  
ATOM    139  OG  SER A  17      26.257  72.809  91.058  1.00  6.69           O  
ATOM    140  N   GLN A  18      23.110  74.209  88.273  1.00  3.81           N  
ATOM    141  CA  GLN A  18      22.064  74.050  87.279  1.00  4.58           C  
ATOM    142  C   GLN A  18      22.432  74.700  85.947  1.00  4.37           C  
ATOM    143  O   GLN A  18      22.167  74.135  84.886  1.00  3.82           O  
ATOM    144  CB  GLN A  18      20.749  74.638  87.786  1.00  5.81           C  
ATOM    145  CG  GLN A  18      19.995  73.746  88.736  1.00  7.87           C  
ATOM    146  CD  GLN A  18      19.775  72.354  88.173  1.00 10.20           C  
ATOM    147  OE1 GLN A  18      20.686  71.525  88.164  1.00 12.25           O  
ATOM    148  NE2 GLN A  18      18.568  72.094  87.693  1.00  9.87           N  
ATOM    149  N   THR A  19      23.032  75.887  85.999  1.00  3.49           N  
ATOM    150  CA  THR A  19      23.426  76.588  84.781  1.00  3.72           C  
ATOM    151  C   THR A  19      24.436  75.750  83.997  1.00  3.70           C  
ATOM    152  O   THR A  19      24.561  75.868  82.775  1.00  2.87           O  
ATOM    153  CB  THR A  19      24.047  77.980  85.090  1.00  3.96           C  
ATOM    154  OG1 THR A  19      25.153  77.828  85.981  1.00  4.53           O  
ATOM    155  CG2 THR A  19      23.025  78.895  85.718  1.00  3.37           C  
ATOM    156  N   LEU A  20      25.145  74.890  84.718  1.00  3.99           N  
ATOM    157  CA  LEU A  20      26.140  74.004  84.128  1.00  3.34           C  
ATOM    158  C   LEU A  20      25.457  72.785  83.512  1.00  3.25           C  
ATOM    159  O   LEU A  20      25.789  72.381  82.403  1.00  4.06           O  
ATOM    160  CB  LEU A  20      27.137  73.566  85.208  1.00  3.77           C  
ATOM    161  CG  LEU A  20      28.624  73.868  84.986  1.00  6.01           C  
ATOM    162  CD1 LEU A  20      28.820  75.258  84.380  1.00  6.48           C  
ATOM    163  CD2 LEU A  20      29.352  73.747  86.308  1.00  5.22           C  
ATOM    164  N   THR A  21      24.495  72.212  84.234  1.00  3.28           N  
ATOM    165  CA  THR A  21      23.772  71.037  83.761  1.00  2.53           C  
ATOM    166  C   THR A  21      22.990  71.391  82.505  1.00  1.69           C  
ATOM    167  O   THR A  21      22.958  70.617  81.555  1.00  2.56           O  
ATOM    168  CB  THR A  21      22.777  70.499  84.824  1.00  4.21           C  
ATOM    169  OG1 THR A  21      23.322  70.677  86.138  1.00  5.20           O  
ATOM    170  CG2 THR A  21      22.514  69.012  84.604  1.00  2.94           C  
ATOM    171  N   LEU A  22      22.356  72.557  82.501  1.00  1.00           N  
ATOM    172  CA  LEU A  22      21.600  72.997  81.337  1.00  1.62           C  
ATOM    173  C   LEU A  22      22.511  73.453  80.187  1.00  2.48           C  
ATOM    174  O   LEU A  22      22.115  73.420  79.020  1.00  2.02           O  
ATOM    175  CB  LEU A  22      20.664  74.145  81.705  1.00  1.00           C  
ATOM    176  CG  LEU A  22      19.976  74.751  80.475  1.00  2.77           C  
ATOM    177  CD1 LEU A  22      18.864  73.824  80.000  1.00  2.11           C  
ATOM    178  CD2 LEU A  22      19.425  76.117  80.803  1.00  2.01           C  
ATOM    179  N   LEU A  23      23.723  73.895  80.513  1.00  2.93           N  
ATOM    180  CA  LEU A  23      24.660  74.343  79.489  1.00  3.78           C  
ATOM    181  C   LEU A  23      25.034  73.135  78.645  1.00  3.67           C  
ATOM    182  O   LEU A  23      25.172  73.211  77.425  1.00  1.00           O  
ATOM    183  CB  LEU A  23      25.907  74.922  80.146  1.00  5.93           C  
ATOM    184  CG  LEU A  23      26.508  76.156  79.465  1.00  8.32           C  
ATOM    185  CD1 LEU A  23      27.556  76.781  80.375  1.00  7.64           C  
ATOM    186  CD2 LEU A  23      27.111  75.766  78.115  1.00 10.16           C  
ATOM    187  N   GLU A  24      25.194  72.014  79.334  1.00  4.96           N  
ATOM    188  CA  GLU A  24      25.532  70.742  78.721  1.00  6.23           C  
ATOM    189  C   GLU A  24      24.458  70.377  77.703  1.00  5.54           C  
ATOM    190  O   GLU A  24      24.731  70.265  76.519  1.00  5.34           O  
ATOM    191  CB  GLU A  24      25.613  69.671  79.810  1.00  8.68           C  
ATOM    192  CG  GLU A  24      25.946  68.273  79.336  1.00 12.02           C  
ATOM    193  CD  GLU A  24      26.099  67.308  80.502  1.00 16.53           C  
ATOM    194  OE1 GLU A  24      26.877  67.624  81.434  1.00 16.74           O  
ATOM    195  OE2 GLU A  24      25.443  66.238  80.489  1.00 19.47           O  
ATOM    196  N   LYS A  25      23.233  70.205  78.184  1.00  4.69           N  
ATOM    197  CA  LYS A  25      22.108  69.852  77.336  1.00  4.08           C  
ATOM    198  C   LYS A  25      21.905  70.808  76.177  1.00  3.36           C  
ATOM    199  O   LYS A  25      21.481  70.403  75.098  1.00  3.73           O  
ATOM    200  CB  LYS A  25      20.837  69.765  78.177  1.00  4.61           C  
ATOM    201  CG  LYS A  25      20.851  68.575  79.114  1.00  6.51           C  
ATOM    202  CD  LYS A  25      19.556  68.434  79.881  1.00  9.15           C  
ATOM    203  CE  LYS A  25      19.471  67.055  80.532  1.00  9.98           C  
ATOM    204  NZ  LYS A  25      20.650  66.758  81.396  1.00 10.80           N  
ATOM    205  N   LEU A  26      22.218  72.077  76.399  1.00  3.32           N  
ATOM    206  CA  LEU A  26      22.073  73.099  75.370  1.00  3.53           C  
ATOM    207  C   LEU A  26      23.067  72.925  74.213  1.00  3.86           C  
ATOM    208  O   LEU A  26      22.773  73.249  73.065  1.00  2.75           O  
ATOM    209  CB  LEU A  26      22.243  74.469  76.020  1.00  4.42           C  
ATOM    210  CG  LEU A  26      21.070  75.451  75.940  1.00  4.70           C  
ATOM    211  CD1 LEU A  26      19.756  74.708  76.046  1.00  5.02           C  
ATOM    212  CD2 LEU A  26      21.205  76.489  77.041  1.00  4.55           C  
ATOM    213  N   ASN A  27      24.242  72.405  74.542  1.00  6.02           N  
ATOM    214  CA  ASN A  27      25.314  72.162  73.585  1.00  7.58           C  
ATOM    215  C   ASN A  27      25.023  70.982  72.687  1.00  7.69           C  
ATOM    216  O   ASN A  27      25.448  70.946  71.535  1.00  7.60           O  
ATOM    217  CB  ASN A  27      26.616  71.903  74.334  1.00  9.99           C  
ATOM    218  CG  ASN A  27      27.265  73.171  74.817  1.00 12.64           C  
ATOM    219  OD1 ASN A  27      27.943  73.183  75.844  1.00 14.40           O  
ATOM    220  ND2 ASN A  27      27.077  74.254  74.065  1.00 13.32           N  
ATOM    221  N   GLU A  28      24.312  70.004  73.224  1.00  8.44           N  
ATOM    222  CA  GLU A  28      23.974  68.829  72.448  1.00 10.99           C  
ATOM    223  C   GLU A  28      22.985  69.158  71.341  1.00 11.45           C  
ATOM    224  O   GLU A  28      23.029  68.554  70.268  1.00 13.20           O  
ATOM    225  CB  GLU A  28      23.392  67.745  73.346  1.00 11.72           C  
ATOM    226  CG  GLU A  28      24.423  67.060  74.203  1.00 14.54           C  
ATOM    227  CD  GLU A  28      23.807  65.998  75.086  1.00 18.27           C  
ATOM    228  OE1 GLU A  28      24.573  65.279  75.771  1.00 18.77           O  
ATOM    229  OE2 GLU A  28      22.558  65.887  75.097  1.00 17.56           O  
ATOM    230  N   LEU A  29      22.104  70.119  71.598  1.00 11.15           N  
ATOM    231  CA  LEU A  29      21.095  70.512  70.623  1.00 10.62           C  
ATOM    232  C   LEU A  29      21.671  71.480  69.615  1.00 11.17           C  
ATOM    233  O   LEU A  29      21.001  71.883  68.670  1.00 12.06           O  
ATOM    234  CB  LEU A  29      19.906  71.163  71.331  1.00 10.31           C  
ATOM    235  CG  LEU A  29      19.228  70.331  72.422  1.00  9.37           C  
ATOM    236  CD1 LEU A  29      18.040  71.084  73.031  1.00  6.25           C  
ATOM    237  CD2 LEU A  29      18.788  69.009  71.812  1.00  9.35           C  
ATOM    238  N   ASP A  30      22.926  71.847  69.815  1.00 12.09           N  
ATOM    239  CA  ASP A  30      23.577  72.788  68.921  1.00 13.21           C  
ATOM    240  C   ASP A  30      22.791  74.089  68.900  1.00 12.19           C  
ATOM    241  O   ASP A  30      22.698  74.754  67.870  1.00 12.34           O  
ATOM    242  CB  ASP A  30      23.683  72.207  67.509  1.00 15.35           C  
ATOM    243  CG  ASP A  30      24.888  71.300  67.345  1.00 18.33           C  
ATOM    244  OD1 ASP A  30      24.931  70.226  67.990  1.00 18.86           O  
ATOM    245  OD2 ASP A  30      25.797  71.674  66.571  1.00 19.84           O  
ATOM    246  N   ALA A  31      22.215  74.430  70.050  1.00 11.84           N  
ATOM    247  CA  ALA A  31      21.448  75.661  70.210  1.00 10.08           C  
ATOM    248  C   ALA A  31      22.463  76.687  70.670  1.00 10.33           C  
ATOM    249  O   ALA A  31      22.445  77.117  71.826  1.00 11.65           O  
ATOM    250  CB  ALA A  31      20.376  75.481  71.265  1.00  8.69           C  
ATOM    251  N   ASP A  32      23.348  77.060  69.746  1.00  9.77           N  
ATOM    252  CA  ASP A  32      24.435  78.006  69.980  1.00  7.60           C  
ATOM    253  C   ASP A  32      24.084  79.330  70.643  1.00  7.47           C  
ATOM    254  O   ASP A  32      24.815  79.778  71.517  1.00  8.72           O  
ATOM    255  CB  ASP A  32      25.161  78.276  68.665  1.00  7.56           C  
ATOM    256  CG  ASP A  32      25.926  77.067  68.161  1.00  8.81           C  
ATOM    257  OD1 ASP A  32      26.516  77.158  67.067  1.00 11.52           O  
ATOM    258  OD2 ASP A  32      25.946  76.029  68.853  1.00  8.62           O  
ATOM    259  N   GLU A  33      22.990  79.967  70.230  1.00  7.21           N  
ATOM    260  CA  GLU A  33      22.595  81.235  70.832  1.00  7.27           C  
ATOM    261  C   GLU A  33      22.233  81.049  72.295  1.00  7.29           C  
ATOM    262  O   GLU A  33      22.643  81.834  73.155  1.00  8.73           O  
ATOM    263  CB  GLU A  33      21.387  81.845  70.125  1.00  8.94           C  
ATOM    264  CG  GLU A  33      21.632  82.339  68.718  1.00 13.80           C  
ATOM    265  CD  GLU A  33      20.519  83.264  68.236  1.00 16.13           C  
ATOM    266  OE1 GLU A  33      19.327  82.877  68.341  1.00 15.14           O  
ATOM    267  OE2 GLU A  33      20.845  84.378  67.754  1.00 16.08           O  
ATOM    268  N   GLN A  34      21.457  80.009  72.577  1.00  4.88           N  
ATOM    269  CA  GLN A  34      21.039  79.736  73.938  1.00  4.61           C  
ATOM    270  C   GLN A  34      22.219  79.337  74.815  1.00  3.67           C  
ATOM    271  O   GLN A  34      22.334  79.779  75.955  1.00  3.47           O  
ATOM    272  CB  GLN A  34      19.953  78.656  73.937  1.00  5.46           C  
ATOM    273  CG  GLN A  34      18.607  79.153  73.388  1.00  5.28           C  
ATOM    274  CD  GLN A  34      18.685  79.601  71.933  1.00  4.62           C  
ATOM    275  OE1 GLN A  34      17.855  80.375  71.463  1.00  4.31           O  
ATOM    276  NE2 GLN A  34      19.678  79.102  71.214  1.00  4.27           N  
ATOM    277  N   ALA A  35      23.102  78.508  74.279  1.00  2.90           N  
ATOM    278  CA  ALA A  35      24.279  78.085  75.017  1.00  2.83           C  
ATOM    279  C   ALA A  35      25.089  79.322  75.425  1.00  3.42           C  
ATOM    280  O   ALA A  35      25.619  79.390  76.533  1.00  3.58           O  
ATOM    281  CB  ALA A  35      25.123  77.150  74.153  1.00  1.00           C  
ATOM    282  N   ASP A  36      25.168  80.304  74.530  1.00  3.95           N  
ATOM    283  CA  ASP A  36      25.908  81.542  74.788  1.00  4.36           C  
ATOM    284  C   ASP A  36      25.297  82.376  75.904  1.00  3.70           C  
ATOM    285  O   ASP A  36      26.007  82.984  76.704  1.00  2.13           O  
ATOM    286  CB  ASP A  36      25.964  82.397  73.527  1.00  7.05           C  
ATOM    287  CG  ASP A  36      27.373  82.576  73.008  1.00 10.57           C  
ATOM    288  OD1 ASP A  36      27.896  81.636  72.363  1.00 12.45           O  
ATOM    289  OD2 ASP A  36      27.959  83.653  73.259  1.00 12.44           O  
ATOM    290  N   ILE A  37      23.970  82.418  75.926  1.00  2.88           N  
ATOM    291  CA  ILE A  37      23.233  83.163  76.932  1.00  1.56           C  
ATOM    292  C   ILE A  37      23.373  82.490  78.281  1.00  1.82           C  
ATOM    293  O   ILE A  37      23.545  83.156  79.295  1.00  1.00           O  
ATOM    294  CB  ILE A  37      21.744  83.248  76.562  1.00  3.48           C  
ATOM    295  CG1 ILE A  37      21.582  84.103  75.303  1.00  2.29           C  
ATOM    296  CG2 ILE A  37      20.935  83.810  77.731  1.00  2.05           C  
ATOM    297  CD1 ILE A  37      20.151  84.264  74.858  1.00  2.26           C  
ATOM    298  N   CYS A  38      23.302  81.163  78.292  1.00  1.00           N  
ATOM    299  CA  CYS A  38      23.439  80.417  79.535  1.00  1.64           C  
ATOM    300  C   CYS A  38      24.815  80.690  80.167  1.00  1.37           C  
ATOM    301  O   CYS A  38      24.954  80.707  81.386  1.00  1.00           O  
ATOM    302  CB  CYS A  38      23.265  78.918  79.274  1.00  2.02           C  
ATOM    303  SG  CYS A  38      23.129  77.871  80.770  1.00  2.83           S  
ATOM    304  N   GLU A  39      25.822  80.913  79.335  1.00  1.00           N  
ATOM    305  CA  GLU A  39      27.159  81.184  79.831  1.00  1.04           C  
ATOM    306  C   GLU A  39      27.224  82.474  80.623  1.00  1.99           C  
ATOM    307  O   GLU A  39      27.807  82.523  81.710  1.00  2.41           O  
ATOM    308  CB  GLU A  39      28.150  81.236  78.672  1.00  1.00           C  
ATOM    309  CG  GLU A  39      28.580  79.868  78.207  1.00  1.00           C  
ATOM    310  CD  GLU A  39      29.359  79.111  79.270  1.00  2.22           C  
ATOM    311  OE1 GLU A  39      29.709  77.939  79.016  1.00  1.90           O  
ATOM    312  OE2 GLU A  39      29.622  79.686  80.357  1.00  2.10           O  
ATOM    313  N   SER A  40      26.636  83.530  80.078  1.00  2.04           N  
ATOM    314  CA  SER A  40      26.641  84.797  80.779  1.00  1.00           C  
ATOM    315  C   SER A  40      25.858  84.504  82.036  1.00  1.00           C  
ATOM    316  O   SER A  40      26.231  84.918  83.123  1.00  1.79           O  
ATOM    317  CB  SER A  40      25.931  85.862  79.958  1.00  1.00           C  
ATOM    318  OG  SER A  40      26.361  85.829  78.604  1.00  4.13           O  
ATOM    319  N   LEU A  41      24.773  83.755  81.884  1.00  1.29           N  
ATOM    320  CA  LEU A  41      23.956  83.421  83.034  1.00  1.51           C  
ATOM    321  C   LEU A  41      24.793  82.736  84.104  1.00  1.06           C  
ATOM    322  O   LEU A  41      24.677  83.062  85.280  1.00  1.28           O  
ATOM    323  CB  LEU A  41      22.785  82.513  82.648  1.00  1.30           C  
ATOM    324  CG  LEU A  41      21.881  82.287  83.870  1.00  2.14           C  
ATOM    325  CD1 LEU A  41      21.325  83.624  84.311  1.00  2.54           C  
ATOM    326  CD2 LEU A  41      20.759  81.339  83.570  1.00  1.02           C  
ATOM    327  N   HIS A  42      25.632  81.785  83.693  1.00  1.92           N  
ATOM    328  CA  HIS A  42      26.485  81.057  84.625  1.00  1.00           C  
ATOM    329  C   HIS A  42      27.525  81.993  85.213  1.00  1.47           C  
ATOM    330  O   HIS A  42      27.850  81.903  86.392  1.00  1.74           O  
ATOM    331  CB  HIS A  42      27.185  79.892  83.935  1.00  1.00           C  
ATOM    332  CG  HIS A  42      28.124  79.142  84.828  1.00  1.00           C  
ATOM    333  ND1 HIS A  42      27.692  78.341  85.862  1.00  1.44           N  
ATOM    334  CD2 HIS A  42      29.478  79.093  84.859  1.00  1.36           C  
ATOM    335  CE1 HIS A  42      28.735  77.832  86.492  1.00  1.00           C  
ATOM    336  NE2 HIS A  42      29.831  78.274  85.902  1.00  1.00           N  
ATOM    337  N   ASP A  43      28.038  82.906  84.399  1.00  1.00           N  
ATOM    338  CA  ASP A  43      29.033  83.840  84.899  1.00  1.00           C  
ATOM    339  C   ASP A  43      28.475  84.815  85.914  1.00  1.02           C  
ATOM    340  O   ASP A  43      29.213  85.329  86.743  1.00  2.16           O  
ATOM    341  CB  ASP A  43      29.693  84.597  83.751  1.00  1.00           C  
ATOM    342  CG  ASP A  43      30.911  83.874  83.221  1.00  1.38           C  
ATOM    343  OD1 ASP A  43      31.533  84.371  82.263  1.00  1.00           O  
ATOM    344  OD2 ASP A  43      31.246  82.804  83.774  1.00  1.00           O  
ATOM    345  N   HIS A  44      27.174  85.068  85.851  1.00  2.04           N  
ATOM    346  CA  HIS A  44      26.533  85.969  86.796  1.00  3.22           C  
ATOM    347  C   HIS A  44      26.320  85.204  88.090  1.00  2.93           C  
ATOM    348  O   HIS A  44      26.400  85.771  89.175  1.00  2.35           O  
ATOM    349  CB  HIS A  44      25.186  86.443  86.258  1.00  6.16           C  
ATOM    350  CG  HIS A  44      25.185  87.859  85.775  1.00  8.91           C  
ATOM    351  ND1 HIS A  44      26.030  88.309  84.782  1.00 11.19           N  
ATOM    352  CD2 HIS A  44      24.424  88.919  86.133  1.00  9.40           C  
ATOM    353  CE1 HIS A  44      25.787  89.587  84.547  1.00 11.07           C  
ATOM    354  NE2 HIS A  44      24.816  89.981  85.353  1.00 11.81           N  
ATOM    355  N   ALA A  45      26.039  83.910  87.963  1.00  2.98           N  
ATOM    356  CA  ALA A  45      25.830  83.054  89.125  1.00  2.59           C  
ATOM    357  C   ALA A  45      27.137  82.871  89.898  1.00  2.42           C  
ATOM    358  O   ALA A  45      27.118  82.643  91.099  1.00  2.27           O  
ATOM    359  CB  ALA A  45      25.286  81.702  88.690  1.00  1.21           C  
ATOM    360  N   ASP A  46      28.272  82.973  89.216  1.00  2.61           N  
ATOM    361  CA  ASP A  46      29.542  82.826  89.899  1.00  3.22           C  
ATOM    362  C   ASP A  46      29.802  84.056  90.731  1.00  3.21           C  
ATOM    363  O   ASP A  46      30.236  83.951  91.866  1.00  3.30           O  
ATOM    364  CB  ASP A  46      30.697  82.627  88.915  1.00  5.63           C  
ATOM    365  CG  ASP A  46      30.693  81.245  88.263  1.00  9.08           C  
ATOM    366  OD1 ASP A  46      30.426  80.246  88.968  1.00  9.80           O  
ATOM    367  OD2 ASP A  46      30.970  81.159  87.045  1.00  9.46           O  
ATOM    368  N   GLU A  47      29.530  85.228  90.173  1.00  3.71           N  
ATOM    369  CA  GLU A  47      29.749  86.474  90.902  1.00  4.59           C  
ATOM    370  C   GLU A  47      28.772  86.637  92.070  1.00  4.13           C  
ATOM    371  O   GLU A  47      29.153  87.063  93.163  1.00  4.64           O  
ATOM    372  CB  GLU A  47      29.617  87.672  89.964  1.00  6.12           C  
ATOM    373  CG  GLU A  47      30.800  88.618  90.030  1.00 10.57           C  
ATOM    374  CD  GLU A  47      31.995  88.095  89.260  1.00 13.07           C  
ATOM    375  OE1 GLU A  47      33.120  88.611  89.452  1.00 15.48           O  
ATOM    376  OE2 GLU A  47      31.804  87.168  88.448  1.00 14.65           O  
ATOM    377  N   LEU A  48      27.511  86.299  91.832  1.00  3.42           N  
ATOM    378  CA  LEU A  48      26.489  86.405  92.861  1.00  2.10           C  
ATOM    379  C   LEU A  48      26.810  85.566  94.085  1.00  2.44           C  
ATOM    380  O   LEU A  48      26.693  86.038  95.212  1.00  4.03           O  
ATOM    381  CB  LEU A  48      25.129  85.985  92.304  1.00  1.45           C  
ATOM    382  CG  LEU A  48      23.981  85.792  93.302  1.00  1.17           C  
ATOM    383  CD1 LEU A  48      23.938  86.927  94.309  1.00  1.31           C  
ATOM    384  CD2 LEU A  48      22.680  85.716  92.539  1.00  1.42           C  
ATOM    385  N   TYR A  49      27.210  84.319  93.870  1.00  1.09           N  
ATOM    386  CA  TYR A  49      27.525  83.440  94.979  1.00  1.00           C  
ATOM    387  C   TYR A  49      28.680  83.989  95.787  1.00  1.00           C  
ATOM    388  O   TYR A  49      28.567  84.154  96.986  1.00  2.79           O  
ATOM    389  CB  TYR A  49      27.885  82.049  94.478  1.00  1.00           C  
ATOM    390  CG  TYR A  49      28.333  81.130  95.590  1.00  2.45           C  
ATOM    391  CD1 TYR A  49      27.408  80.374  96.315  1.00  1.00           C  
ATOM    392  CD2 TYR A  49      29.684  81.043  95.943  1.00  1.70           C  
ATOM    393  CE1 TYR A  49      27.812  79.559  97.349  1.00  1.00           C  
ATOM    394  CE2 TYR A  49      30.096  80.234  96.985  1.00  1.31           C  
ATOM    395  CZ  TYR A  49      29.156  79.495  97.681  1.00  1.06           C  
ATOM    396  OH  TYR A  49      29.565  78.692  98.714  1.00  2.33           O  
ATOM    397  N   ARG A  50      29.795  84.260  95.122  1.00  1.00           N  
ATOM    398  CA  ARG A  50      30.975  84.793  95.778  1.00  1.00           C  
ATOM    399  C   ARG A  50      30.606  85.992  96.619  1.00  1.18           C  
ATOM    400  O   ARG A  50      30.980  86.081  97.784  1.00  1.25           O  
ATOM    401  CB  ARG A  50      32.023  85.187  94.732  1.00  1.29           C  
ATOM    402  CG  ARG A  50      32.612  83.990  94.017  1.00  1.86           C  
ATOM    403  CD  ARG A  50      33.329  84.348  92.722  1.00  4.05           C  
ATOM    404  NE  ARG A  50      33.767  83.136  92.020  1.00  6.51           N  
ATOM    405  CZ  ARG A  50      34.214  83.099  90.767  1.00  5.07           C  
ATOM    406  NH1 ARG A  50      34.583  81.942  90.227  1.00  3.32           N  
ATOM    407  NH2 ARG A  50      34.283  84.216  90.055  1.00  5.12           N  
ATOM    408  N   SER A  51      29.867  86.915  96.022  1.00  2.34           N  
ATOM    409  CA  SER A  51      29.433  88.114  96.725  1.00  3.12           C  
ATOM    410  C   SER A  51      28.604  87.791  97.972  1.00  3.27           C  
ATOM    411  O   SER A  51      28.708  88.483  98.976  1.00  3.90           O  
ATOM    412  CB  SER A  51      28.617  89.000  95.782  1.00  5.22           C  
ATOM    413  OG  SER A  51      27.978  90.055  96.486  1.00  7.36           O  
ATOM    414  N   CYS A  52      27.775  86.753  97.911  1.00  2.23           N  
ATOM    415  CA  CYS A  52      26.963  86.384  99.067  1.00  1.73           C  
ATOM    416  C   CYS A  52      27.801  85.780 100.184  1.00  1.66           C  
ATOM    417  O   CYS A  52      27.562  86.053 101.351  1.00  1.35           O  
ATOM    418  CB  CYS A  52      25.862  85.398  98.670  1.00  2.33           C  
ATOM    419  SG  CYS A  52      24.483  86.121  97.754  1.00  1.00           S  
ATOM    420  N   LEU A  53      28.782  84.956  99.821  1.00  2.35           N  
ATOM    421  CA  LEU A  53      29.658  84.328 100.810  1.00  1.82           C  
ATOM    422  C   LEU A  53      30.375  85.413 101.572  1.00  1.47           C  
ATOM    423  O   LEU A  53      30.467  85.369 102.789  1.00  1.00           O  
ATOM    424  CB  LEU A  53      30.703  83.430 100.144  1.00  2.29           C  
ATOM    425  CG  LEU A  53      30.910  82.051 100.792  1.00  1.75           C  
ATOM    426  CD1 LEU A  53      32.105  81.366 100.161  1.00  1.88           C  
ATOM    427  CD2 LEU A  53      31.115  82.185 102.280  1.00  1.00           C  
ATOM    428  N   ALA A  54      30.886  86.392 100.841  1.00  1.93           N  
ATOM    429  CA  ALA A  54      31.591  87.494 101.463  1.00  2.82           C  
ATOM    430  C   ALA A  54      30.717  88.115 102.544  1.00  3.73           C  
ATOM    431  O   ALA A  54      31.125  88.212 103.698  1.00  5.05           O  
ATOM    432  CB  ALA A  54      31.967  88.532 100.419  1.00  2.04           C  
ATOM    433  N   SER A  55      29.511  88.521 102.169  1.00  5.09           N  
ATOM    434  CA  SER A  55      28.571  89.137 103.097  1.00  5.45           C  
ATOM    435  C   SER A  55      28.180  88.235 104.266  1.00  6.77           C  
ATOM    436  O   SER A  55      28.368  88.598 105.424  1.00  7.03           O  
ATOM    437  CB  SER A  55      27.312  89.565 102.345  1.00  6.12           C  
ATOM    438  OG  SER A  55      26.271  89.908 103.242  1.00  7.83           O  
ATOM    439  N   PHE A  56      27.638  87.058 103.964  1.00  7.45           N  
ATOM    440  CA  PHE A  56      27.203  86.123 105.003  1.00  8.20           C  
ATOM    441  C   PHE A  56      28.288  85.659 105.965  1.00  9.03           C  
ATOM    442  O   PHE A  56      27.994  85.035 106.984  1.00  9.29           O  
ATOM    443  CB  PHE A  56      26.532  84.915 104.361  1.00  6.58           C  
ATOM    444  CG  PHE A  56      25.268  85.254 103.636  1.00  6.77           C  
ATOM    445  CD1 PHE A  56      24.701  84.358 102.742  1.00  6.00           C  
ATOM    446  CD2 PHE A  56      24.639  86.475 103.850  1.00  6.02           C  
ATOM    447  CE1 PHE A  56      23.534  84.674 102.079  1.00  5.89           C  
ATOM    448  CE2 PHE A  56      23.472  86.795 103.189  1.00  4.83           C  
ATOM    449  CZ  PHE A  56      22.918  85.895 102.302  1.00  4.81           C  
ATOM    450  N   LYS A  57      29.540  85.954 105.643  1.00  9.57           N  
ATOM    451  CA  LYS A  57      30.626  85.577 106.523  1.00 10.93           C  
ATOM    452  C   LYS A  57      30.974  86.769 107.403  1.00 12.37           C  
ATOM    453  O   LYS A  57      31.470  86.603 108.515  1.00 12.57           O  
ATOM    454  CB  LYS A  57      31.837  85.112 105.718  1.00 10.55           C  
ATOM    455  CG  LYS A  57      31.752  83.653 105.308  1.00  9.31           C  
ATOM    456  CD  LYS A  57      33.122  83.003 105.389  1.00 10.79           C  
ATOM    457  CE  LYS A  57      33.040  81.490 105.266  1.00 11.53           C  
ATOM    458  NZ  LYS A  57      34.318  80.847 105.696  1.00 11.79           N  
ATOM    459  N   LYS A  58      30.698  87.968 106.898  1.00 13.66           N  
ATOM    460  CA  LYS A  58      30.923  89.220 107.633  1.00 14.35           C  
ATOM    461  C   LYS A  58      29.613  89.499 108.386  1.00 14.72           C  
ATOM    462  O   LYS A  58      29.523  89.330 109.600  1.00 15.24           O  
ATOM    463  CB  LYS A  58      31.213  90.357 106.650  1.00 13.64           C  
ATOM    464  CG  LYS A  58      32.586  90.964 106.785  1.00 13.00           C  
ATOM    465  CD  LYS A  58      33.687  89.953 106.531  1.00 12.49           C  
ATOM    466  CE  LYS A  58      35.064  90.627 106.610  1.00 12.52           C  
ATOM    467  NZ  LYS A  58      35.314  91.290 107.929  1.00 10.09           N  
ATOM    468  N   ASN A  59      28.604  89.935 107.643  1.00 15.65           N  
ATOM    469  CA  ASN A  59      27.272  90.175 108.183  1.00 17.20           C  
ATOM    470  C   ASN A  59      26.289  90.215 107.026  1.00 16.41           C  
ATOM    471  O   ASN A  59      26.572  90.805 105.991  1.00 18.06           O  
ATOM    472  CB  ASN A  59      27.171  91.484 108.959  1.00 18.14           C  
ATOM    473  CG  ASN A  59      25.815  91.626 109.650  1.00 22.28           C  
ATOM    474  OD1 ASN A  59      24.768  91.459 109.015  1.00 21.31           O  
ATOM    475  ND2 ASN A  59      25.827  91.922 110.956  1.00 22.48           N  
ATOM    476  N   GLY A  60      25.136  89.588 107.203  1.00 15.48           N  
ATOM    477  CA  GLY A  60      24.143  89.554 106.146  1.00 14.72           C  
ATOM    478  C   GLY A  60      23.652  90.903 105.647  1.00 14.27           C  
ATOM    479  O   GLY A  60      22.464  91.081 105.366  1.00 14.23           O  
ATOM    480  N   GLN A  61      24.566  91.858 105.537  1.00 12.98           N  
ATOM    481  CA  GLN A  61      24.221  93.181 105.058  1.00 11.88           C  
ATOM    482  C   GLN A  61      24.300  93.153 103.536  1.00 11.75           C  
ATOM    483  O   GLN A  61      25.213  93.712 102.933  1.00 11.31           O  
ATOM    484  CB  GLN A  61      25.191  94.203 105.644  1.00 11.59           C  
ATOM    485  CG  GLN A  61      24.916  95.634 105.244  1.00 12.63           C  
ATOM    486  CD  GLN A  61      26.022  96.185 104.386  1.00 13.41           C  
ATOM    487  OE1 GLN A  61      27.176  96.240 104.811  1.00 14.28           O  
ATOM    488  NE2 GLN A  61      25.688  96.588 103.164  1.00 13.71           N  
ATOM    489  N   ILE A  62      23.330  92.490 102.917  1.00 10.90           N  
ATOM    490  CA  ILE A  62      23.302  92.381 101.466  1.00 10.15           C  
ATOM    491  C   ILE A  62      22.662  93.610 100.804  1.00 11.58           C  
ATOM    492  O   ILE A  62      21.714  94.200 101.324  1.00 11.78           O  
ATOM    493  CB  ILE A  62      22.553  91.084 101.015  1.00  8.45           C  
ATOM    494  CG1 ILE A  62      21.042  91.293 101.061  1.00  6.85           C  
ATOM    495  CG2 ILE A  62      22.943  89.912 101.907  1.00  5.53           C  
ATOM    496  CD1 ILE A  62      20.444  91.550  99.699  1.00  3.68           C  
ATOM    497  N   ASP A  63      23.203  93.998  99.656  1.00 12.71           N  
ATOM    498  CA  ASP A  63      22.698  95.144  98.910  1.00 13.11           C  
ATOM    499  C   ASP A  63      23.008  94.967  97.420  1.00 13.48           C  
ATOM    500  O   ASP A  63      22.094  94.967  96.588  1.00 13.12           O  
ATOM    501  CB  ASP A  63      23.324  96.452  99.446  1.00 14.99           C  
ATOM    502  CG  ASP A  63      24.845  96.495  99.287  1.00 14.97           C  
ATOM    503  OD1 ASP A  63      25.329  96.662  98.146  1.00 14.92           O  
ATOM    504  OD2 ASP A  63      25.558  96.360 100.304  1.00 15.94           O  
ATOM    505  N   GLU A  64      24.293  94.793  97.098  1.00 11.67           N  
ATOM    506  CA  GLU A  64      24.729  94.618  95.719  1.00 11.18           C  
ATOM    507  C   GLU A  64      24.271  93.262  95.220  1.00 10.25           C  
ATOM    508  O   GLU A  64      23.946  93.102  94.038  1.00  9.99           O  
ATOM    509  CB  GLU A  64      26.257  94.708  95.605  1.00 12.39           C  
ATOM    510  CG  GLU A  64      26.751  94.791  94.159  1.00 15.59           C  
ATOM    511  CD  GLU A  64      28.273  94.722  94.013  1.00 19.66           C  
ATOM    512  OE1 GLU A  64      28.993  95.484  94.706  1.00 19.67           O  
ATOM    513  OE2 GLU A  64      28.750  93.909  93.186  1.00 19.39           O  
ATOM    514  N   GLN A  65      24.250  92.290  96.128  1.00  8.79           N  
ATOM    515  CA  GLN A  65      23.828  90.938  95.784  1.00  8.82           C  
ATOM    516  C   GLN A  65      22.437  91.005  95.170  1.00  8.19           C  
ATOM    517  O   GLN A  65      22.163  90.371  94.149  1.00  6.64           O  
ATOM    518  CB  GLN A  65      23.812  90.041  97.029  1.00  9.55           C  
ATOM    519  CG  GLN A  65      25.180  89.808  97.651  1.00  9.14           C  
ATOM    520  CD  GLN A  65      25.672  90.997  98.445  1.00 11.73           C  
ATOM    521  OE1 GLN A  65      26.828  91.045  98.864  1.00 12.38           O  
ATOM    522  NE2 GLN A  65      24.792  91.964  98.666  1.00 12.67           N  
ATOM    523  N   ALA A  66      21.571  91.790  95.799  1.00  7.51           N  
ATOM    524  CA  ALA A  66      20.213  91.970  95.321  1.00  7.93           C  
ATOM    525  C   ALA A  66      20.249  92.500  93.890  1.00  7.77           C  
ATOM    526  O   ALA A  66      19.501  92.040  93.021  1.00  8.55           O  
ATOM    527  CB  ALA A  66      19.477  92.946  96.216  1.00  8.08           C  
ATOM    528  N   ASP A  67      21.122  93.469  93.649  1.00  5.96           N  
ATOM    529  CA  ASP A  67      21.249  94.047  92.326  1.00  6.04           C  
ATOM    530  C   ASP A  67      21.702  92.991  91.337  1.00  5.73           C  
ATOM    531  O   ASP A  67      21.159  92.878  90.236  1.00  6.18           O  
ATOM    532  CB  ASP A  67      22.239  95.203  92.360  1.00  6.19           C  
ATOM    533  CG  ASP A  67      21.672  96.426  93.043  1.00  8.92           C  
ATOM    534  OD1 ASP A  67      22.446  97.373  93.290  1.00  9.65           O  
ATOM    535  OD2 ASP A  67      20.452  96.446  93.327  1.00  9.59           O  
ATOM    536  N   ILE A  68      22.695  92.208  91.729  1.00  4.49           N  
ATOM    537  CA  ILE A  68      23.178  91.161  90.853  1.00  5.33           C  
ATOM    538  C   ILE A  68      22.027  90.227  90.488  1.00  4.20           C  
ATOM    539  O   ILE A  68      21.656  90.115  89.320  1.00  3.08           O  
ATOM    540  CB  ILE A  68      24.310  90.357  91.522  1.00  6.68           C  
ATOM    541  CG1 ILE A  68      25.585  91.209  91.567  1.00  7.25           C  
ATOM    542  CG2 ILE A  68      24.553  89.057  90.763  1.00  6.21           C  
ATOM    543  CD1 ILE A  68      26.787  90.511  92.180  1.00  8.81           C  
ATOM    544  N   CYS A  69      21.461  89.572  91.496  1.00  4.13           N  
ATOM    545  CA  CYS A  69      20.350  88.649  91.303  1.00  3.76           C  
ATOM    546  C   CYS A  69      19.334  89.178  90.294  1.00  4.41           C  
ATOM    547  O   CYS A  69      18.733  88.413  89.543  1.00  4.64           O  
ATOM    548  CB  CYS A  69      19.654  88.388  92.632  1.00  3.30           C  
ATOM    549  SG  CYS A  69      18.800  86.821  92.674  1.00  4.77           S  
ATOM    550  N   GLU A  70      19.129  90.490  90.291  1.00  5.61           N  
ATOM    551  CA  GLU A  70      18.202  91.106  89.353  1.00  5.46           C  
ATOM    552  C   GLU A  70      18.686  90.849  87.931  1.00  4.86           C  
ATOM    553  O   GLU A  70      17.912  90.485  87.047  1.00  3.29           O  
ATOM    554  CB  GLU A  70      18.140  92.600  89.597  1.00  5.36           C  
ATOM    555  CG  GLU A  70      16.832  93.049  90.166  1.00  9.94           C  
ATOM    556  CD  GLU A  70      16.580  94.512  89.894  1.00 11.82           C  
ATOM    557  OE1 GLU A  70      16.601  94.899  88.706  1.00 12.52           O  
ATOM    558  OE2 GLU A  70      16.366  95.273  90.860  1.00 14.56           O  
ATOM    559  N   SER A  71      19.986  91.046  87.733  1.00  5.51           N  
ATOM    560  CA  SER A  71      20.625  90.843  86.442  1.00  5.44           C  
ATOM    561  C   SER A  71      20.710  89.360  86.138  1.00  5.51           C  
ATOM    562  O   SER A  71      20.881  88.965  84.989  1.00  6.61           O  
ATOM    563  CB  SER A  71      22.033  91.435  86.449  1.00  5.98           C  
ATOM    564  OG  SER A  71      22.015  92.792  86.866  1.00  9.51           O  
ATOM    565  N   LEU A  72      20.604  88.537  87.173  1.00  4.14           N  
ATOM    566  CA  LEU A  72      20.662  87.103  86.983  1.00  3.46           C  
ATOM    567  C   LEU A  72      19.284  86.657  86.526  1.00  3.83           C  
ATOM    568  O   LEU A  72      19.150  85.756  85.707  1.00  3.63           O  
ATOM    569  CB  LEU A  72      21.043  86.404  88.291  1.00  4.01           C  
ATOM    570  CG  LEU A  72      21.355  84.900  88.272  1.00  3.89           C  
ATOM    571  CD1 LEU A  72      22.473  84.645  87.302  1.00  3.25           C  
ATOM    572  CD2 LEU A  72      21.752  84.411  89.660  1.00  1.67           C  
ATOM    573  N   HIS A  73      18.257  87.311  87.052  1.00  4.82           N  
ATOM    574  CA  HIS A  73      16.886  86.973  86.692  1.00  4.83           C  
ATOM    575  C   HIS A  73      16.569  87.400  85.272  1.00  3.92           C  
ATOM    576  O   HIS A  73      15.782  86.757  84.582  1.00  2.59           O  
ATOM    577  CB  HIS A  73      15.903  87.648  87.629  1.00  5.40           C  
ATOM    578  CG  HIS A  73      14.476  87.428  87.250  1.00  6.02           C  
ATOM    579  ND1 HIS A  73      13.857  86.201  87.361  1.00  5.96           N  
ATOM    580  CD2 HIS A  73      13.542  88.277  86.761  1.00  6.51           C  
ATOM    581  CE1 HIS A  73      12.603  86.303  86.960  1.00  6.58           C  
ATOM    582  NE2 HIS A  73      12.386  87.554  86.590  1.00  7.41           N  
ATOM    583  N   ASP A  74      17.183  88.498  84.852  1.00  4.26           N  
ATOM    584  CA  ASP A  74      16.980  89.031  83.514  1.00  4.32           C  
ATOM    585  C   ASP A  74      17.493  88.053  82.488  1.00  4.09           C  
ATOM    586  O   ASP A  74      16.841  87.818  81.476  1.00  4.08           O  
ATOM    587  CB  ASP A  74      17.709  90.368  83.363  1.00  5.84           C  
ATOM    588  CG  ASP A  74      16.977  91.508  84.035  1.00  8.48           C  
ATOM    589  OD1 ASP A  74      17.595  92.574  84.229  1.00 10.96           O  
ATOM    590  OD2 ASP A  74      15.777  91.344  84.364  1.00  8.74           O  
ATOM    591  N   HIS A  75      18.665  87.487  82.754  1.00  3.90           N  
ATOM    592  CA  HIS A  75      19.272  86.520  81.852  1.00  4.30           C  
ATOM    593  C   HIS A  75      18.475  85.230  81.842  1.00  4.24           C  
ATOM    594  O   HIS A  75      18.187  84.679  80.785  1.00  4.96           O  
ATOM    595  CB  HIS A  75      20.702  86.217  82.281  1.00  7.46           C  
ATOM    596  CG  HIS A  75      21.658  87.338  82.037  1.00 12.08           C  
ATOM    597  ND1 HIS A  75      21.332  88.658  82.269  1.00 13.98           N  
ATOM    598  CD2 HIS A  75      22.949  87.335  81.631  1.00 12.46           C  
ATOM    599  CE1 HIS A  75      22.383  89.420  82.020  1.00 13.62           C  
ATOM    600  NE2 HIS A  75      23.378  88.641  81.632  1.00 13.81           N  
ATOM    601  N   ALA A  76      18.126  84.744  83.026  1.00  3.67           N  
ATOM    602  CA  ALA A  76      17.367  83.515  83.127  1.00  3.43           C  
ATOM    603  C   ALA A  76      16.055  83.666  82.377  1.00  4.46           C  
ATOM    604  O   ALA A  76      15.558  82.699  81.795  1.00  5.39           O  
ATOM    605  CB  ALA A  76      17.102  83.188  84.567  1.00  4.16           C  
ATOM    606  N   ASP A  77      15.501  84.878  82.391  1.00  3.72           N  
ATOM    607  CA  ASP A  77      14.245  85.161  81.702  1.00  2.79           C  
ATOM    608  C   ASP A  77      14.510  85.271  80.210  1.00  4.19           C  
ATOM    609  O   ASP A  77      13.772  84.720  79.394  1.00  4.55           O  
ATOM    610  CB  ASP A  77      13.634  86.460  82.227  1.00  1.00           C  
ATOM    611  CG  ASP A  77      12.293  86.766  81.604  1.00  1.00           C  
ATOM    612  OD1 ASP A  77      11.407  85.892  81.627  1.00  1.00           O  
ATOM    613  OD2 ASP A  77      12.117  87.889  81.094  1.00  2.17           O  
ATOM    614  N   GLU A  78      15.576  85.977  79.854  1.00  5.27           N  
ATOM    615  CA  GLU A  78      15.944  86.132  78.454  1.00  5.91           C  
ATOM    616  C   GLU A  78      16.194  84.741  77.890  1.00  3.86           C  
ATOM    617  O   GLU A  78      15.694  84.394  76.823  1.00  2.24           O  
ATOM    618  CB  GLU A  78      17.219  86.967  78.318  1.00  8.36           C  
ATOM    619  CG  GLU A  78      17.465  87.483  76.909  1.00 13.74           C  
ATOM    620  CD  GLU A  78      18.901  87.942  76.686  1.00 17.74           C  
ATOM    621  OE1 GLU A  78      19.466  88.616  77.581  1.00 18.34           O  
ATOM    622  OE2 GLU A  78      19.456  87.633  75.608  1.00 18.50           O  
ATOM    623  N   LEU A  79      16.964  83.942  78.627  1.00  3.13           N  
ATOM    624  CA  LEU A  79      17.283  82.583  78.204  1.00  2.34           C  
ATOM    625  C   LEU A  79      16.021  81.792  77.909  1.00  1.69           C  
ATOM    626  O   LEU A  79      15.907  81.159  76.866  1.00  1.00           O  
ATOM    627  CB  LEU A  79      18.102  81.856  79.273  1.00  1.00           C  
ATOM    628  CG  LEU A  79      18.533  80.434  78.891  1.00  1.00           C  
ATOM    629  CD1 LEU A  79      19.273  80.460  77.561  1.00  1.00           C  
ATOM    630  CD2 LEU A  79      19.416  79.853  79.976  1.00  1.00           C  
ATOM    631  N   TYR A  80      15.077  81.832  78.839  1.00  1.69           N  
ATOM    632  CA  TYR A  80      13.822  81.129  78.672  1.00  1.22           C  
ATOM    633  C   TYR A  80      13.086  81.656  77.446  1.00  2.74           C  
ATOM    634  O   TYR A  80      12.583  80.884  76.625  1.00  1.46           O  
ATOM    635  CB  TYR A  80      12.955  81.324  79.902  1.00  2.49           C  
ATOM    636  CG  TYR A  80      11.566  80.783  79.720  1.00  5.60           C  
ATOM    637  CD1 TYR A  80      11.346  79.414  79.634  1.00  6.71           C  
ATOM    638  CD2 TYR A  80      10.476  81.643  79.576  1.00  7.07           C  
ATOM    639  CE1 TYR A  80      10.077  78.909  79.407  1.00  9.25           C  
ATOM    640  CE2 TYR A  80       9.201  81.151  79.348  1.00  7.73           C  
ATOM    641  CZ  TYR A  80       9.008  79.781  79.265  1.00  9.30           C  
ATOM    642  OH  TYR A  80       7.749  79.268  79.048  1.00 10.61           O  
ATOM    643  N   ARG A  81      13.020  82.980  77.337  1.00  4.08           N  
ATOM    644  CA  ARG A  81      12.355  83.643  76.218  1.00  4.43           C  
ATOM    645  C   ARG A  81      12.896  83.159  74.865  1.00  3.64           C  
ATOM    646  O   ARG A  81      12.129  82.813  73.969  1.00  2.85           O  
ATOM    647  CB  ARG A  81      12.530  85.167  76.332  1.00  7.92           C  
ATOM    648  CG  ARG A  81      11.803  85.831  77.514  1.00 12.93           C  
ATOM    649  CD  ARG A  81      10.371  86.183  77.169  1.00 16.17           C  
ATOM    650  NE  ARG A  81       9.692  85.045  76.560  1.00 23.67           N  
ATOM    651  CZ  ARG A  81       8.580  85.123  75.832  1.00 25.35           C  
ATOM    652  NH1 ARG A  81       8.001  86.300  75.614  1.00 25.75           N  
ATOM    653  NH2 ARG A  81       8.061  84.018  75.305  1.00 25.06           N  
ATOM    654  N   SER A  82      14.218  83.131  74.724  1.00  3.26           N  
ATOM    655  CA  SER A  82      14.833  82.695  73.474  1.00  2.99           C  
ATOM    656  C   SER A  82      14.569  81.222  73.191  1.00  3.23           C  
ATOM    657  O   SER A  82      14.314  80.843  72.049  1.00  3.65           O  
ATOM    658  CB  SER A  82      16.337  82.957  73.494  1.00  1.79           C  
ATOM    659  OG  SER A  82      16.869  82.907  72.183  1.00  1.00           O  
ATOM    660  N   CYS A  83      14.635  80.390  74.224  1.00  3.44           N  
ATOM    661  CA  CYS A  83      14.367  78.971  74.048  1.00  5.63           C  
ATOM    662  C   CYS A  83      12.910  78.763  73.610  1.00  6.52           C  
ATOM    663  O   CYS A  83      12.625  77.899  72.773  1.00  6.38           O  
ATOM    664  CB  CYS A  83      14.647  78.200  75.345  1.00  6.73           C  
ATOM    665  SG  CYS A  83      16.414  77.935  75.706  1.00  9.17           S  
ATOM    666  N   LEU A  84      11.994  79.566  74.154  1.00  6.42           N  
ATOM    667  CA  LEU A  84      10.577  79.458  73.802  1.00  7.39           C  
ATOM    668  C   LEU A  84      10.266  79.995  72.410  1.00  7.61           C  
ATOM    669  O   LEU A  84       9.152  79.834  71.910  1.00  8.02           O  
ATOM    670  CB  LEU A  84       9.697  80.208  74.806  1.00  7.83           C  
ATOM    671  CG  LEU A  84       8.475  79.434  75.318  1.00  7.49           C  
ATOM    672  CD1 LEU A  84       7.628  80.359  76.147  1.00  7.57           C  
ATOM    673  CD2 LEU A  84       7.671  78.854  74.169  1.00  6.34           C  
ATOM    674  N   ALA A  85      11.240  80.631  71.780  1.00  6.82           N  
ATOM    675  CA  ALA A  85      11.002  81.186  70.464  1.00  6.12           C  
ATOM    676  C   ALA A  85      11.675  80.425  69.334  1.00  5.13           C  
ATOM    677  O   ALA A  85      11.337  80.620  68.171  1.00  5.84           O  
ATOM    678  CB  ALA A  85      11.434  82.652  70.441  1.00  5.84           C  
ATOM    679  N   ARG A  86      12.607  79.540  69.659  1.00  5.08           N  
ATOM    680  CA  ARG A  86      13.314  78.816  68.608  1.00  5.03           C  
ATOM    681  C   ARG A  86      13.290  77.288  68.663  1.00  4.25           C  
ATOM    682  O   ARG A  86      13.780  76.645  67.750  1.00  4.02           O  
ATOM    683  CB  ARG A  86      14.771  79.276  68.571  1.00  4.08           C  
ATOM    684  CG  ARG A  86      14.957  80.776  68.643  1.00  5.89           C  
ATOM    685  CD  ARG A  86      15.253  81.411  67.286  1.00  7.00           C  
ATOM    686  NE  ARG A  86      14.061  81.583  66.463  1.00  7.68           N  
ATOM    687  CZ  ARG A  86      13.736  80.802  65.437  1.00  8.64           C  
ATOM    688  NH1 ARG A  86      12.629  81.044  64.757  1.00  7.42           N  
ATOM    689  NH2 ARG A  86      14.519  79.790  65.084  1.00  9.55           N  
ATOM    690  N   PHE A  87      12.730  76.696  69.709  1.00  4.62           N  
ATOM    691  CA  PHE A  87      12.720  75.235  69.796  1.00  4.94           C  
ATOM    692  C   PHE A  87      11.616  74.520  69.023  1.00  5.90           C  
ATOM    693  O   PHE A  87      10.484  75.004  68.932  1.00  6.14           O  
ATOM    694  CB  PHE A  87      12.669  74.777  71.260  1.00  4.82           C  
ATOM    695  CG  PHE A  87      13.976  74.890  71.986  1.00  3.34           C  
ATOM    696  CD1 PHE A  87      14.156  74.251  73.202  1.00  3.32           C  
ATOM    697  CD2 PHE A  87      15.019  75.650  71.469  1.00  4.51           C  
ATOM    698  CE1 PHE A  87      15.350  74.365  73.899  1.00  5.42           C  
ATOM    699  CE2 PHE A  87      16.222  75.775  72.155  1.00  4.91           C  
ATOM    700  CZ  PHE A  87      16.389  75.130  73.375  1.00  5.99           C  
ATOM    701  N   GLY A  88      11.972  73.360  68.468  1.00  5.66           N  
ATOM    702  CA  GLY A  88      11.025  72.548  67.731  1.00  5.69           C  
ATOM    703  C   GLY A  88      10.093  71.934  68.756  1.00  6.36           C  
ATOM    704  O   GLY A  88       9.572  72.648  69.601  1.00  7.86           O  
ATOM    705  N   GLY A  89       9.889  70.623  68.713  1.00  6.40           N  
ATOM    706  CA  GLY A  89       9.001  70.003  69.681  1.00  6.01           C  
ATOM    707  C   GLY A  89       9.391  68.596  70.087  1.00  5.84           C  
ATOM    708  O   GLY A  89       8.536  67.718  70.152  1.00  5.94           O  
ATOM    709  N   SER A  90      10.671  68.368  70.363  1.00  4.64           N  
ATOM    710  CA  SER A  90      11.102  67.038  70.752  1.00  5.04           C  
ATOM    711  C   SER A  90      11.361  66.944  72.245  1.00  6.41           C  
ATOM    712  O   SER A  90      11.444  67.962  72.942  1.00  6.29           O  
ATOM    713  CB  SER A  90      12.362  66.628  69.989  1.00  4.97           C  
ATOM    714  OG  SER A  90      13.495  67.365  70.408  1.00  4.25           O  
ATOM    715  N   LYS A  91      11.487  65.704  72.717  1.00  6.27           N  
ATOM    716  CA  LYS A  91      11.728  65.404  74.121  1.00  6.52           C  
ATOM    717  C   LYS A  91      12.942  66.153  74.612  1.00  6.84           C  
ATOM    718  O   LYS A  91      12.870  66.891  75.588  1.00  8.47           O  
ATOM    719  CB  LYS A  91      11.946  63.898  74.306  1.00  7.96           C  
ATOM    720  CG  LYS A  91      10.996  63.234  75.303  1.00  9.47           C  
ATOM    721  CD  LYS A  91       9.533  63.386  74.893  1.00  9.10           C  
ATOM    722  CE  LYS A  91       8.578  62.825  75.943  1.00  9.05           C  
ATOM    723  NZ  LYS A  91       8.723  61.359  76.089  1.00  8.80           N  
ATOM    724  N   GLN A  92      14.062  65.953  73.928  1.00  7.30           N  
ATOM    725  CA  GLN A  92      15.315  66.610  74.281  1.00  8.32           C  
ATOM    726  C   GLN A  92      15.073  68.107  74.470  1.00  7.00           C  
ATOM    727  O   GLN A  92      15.475  68.692  75.469  1.00  7.36           O  
ATOM    728  CB  GLN A  92      16.355  66.386  73.178  1.00 10.85           C  
ATOM    729  CG  GLN A  92      16.605  64.907  72.797  1.00 15.56           C  
ATOM    730  CD  GLN A  92      15.429  64.235  72.051  1.00 18.33           C  
ATOM    731  OE1 GLN A  92      14.993  64.691  70.986  1.00 18.32           O  
ATOM    732  NE2 GLN A  92      14.928  63.138  72.612  1.00 19.68           N  
ATOM    733  N   GLU A  93      14.395  68.717  73.508  1.00  6.57           N  
ATOM    734  CA  GLU A  93      14.098  70.137  73.573  1.00  5.35           C  
ATOM    735  C   GLU A  93      13.134  70.461  74.707  1.00  4.39           C  
ATOM    736  O   GLU A  93      13.287  71.480  75.368  1.00  4.34           O  
ATOM    737  CB  GLU A  93      13.545  70.618  72.219  1.00  6.09           C  
ATOM    738  CG  GLU A  93      14.607  70.628  71.106  1.00  9.19           C  
ATOM    739  CD  GLU A  93      14.088  71.065  69.734  1.00 11.31           C  
ATOM    740  OE1 GLU A  93      13.257  70.348  69.127  1.00 13.41           O  
ATOM    741  OE2 GLU A  93      14.524  72.130  69.253  1.00 12.06           O  
ATOM    742  N   LYS A  94      12.147  69.595  74.939  1.00  3.69           N  
ATOM    743  CA  LYS A  94      11.171  69.812  76.007  1.00  2.95           C  
ATOM    744  C   LYS A  94      11.829  69.971  77.370  1.00  3.15           C  
ATOM    745  O   LYS A  94      11.441  70.843  78.149  1.00  2.54           O  
ATOM    746  CB  LYS A  94      10.180  68.658  76.077  1.00  2.70           C  
ATOM    747  CG  LYS A  94       9.228  68.587  74.913  1.00  5.43           C  
ATOM    748  CD  LYS A  94       8.345  69.801  74.852  1.00  6.45           C  
ATOM    749  CE  LYS A  94       7.417  69.728  73.659  1.00  8.22           C  
ATOM    750  NZ  LYS A  94       6.590  70.967  73.536  1.00  9.29           N  
ATOM    751  N   THR A  95      12.812  69.114  77.652  1.00  1.93           N  
ATOM    752  CA  THR A  95      13.549  69.152  78.913  1.00  1.17           C  
ATOM    753  C   THR A  95      14.337  70.451  79.079  1.00  1.00           C  
ATOM    754  O   THR A  95      14.191  71.146  80.076  1.00  1.25           O  
ATOM    755  CB  THR A  95      14.531  67.959  79.022  1.00  1.00           C  
ATOM    756  OG1 THR A  95      13.793  66.751  79.211  1.00  1.04           O  
ATOM    757  CG2 THR A  95      15.470  68.138  80.190  1.00  1.00           C  
ATOM    758  N   ALA A  96      15.176  70.770  78.103  1.00  1.00           N  
ATOM    759  CA  ALA A  96      15.979  71.982  78.149  1.00  1.00           C  
ATOM    760  C   ALA A  96      15.109  73.198  78.355  1.00  1.45           C  
ATOM    761  O   ALA A  96      15.570  74.212  78.860  1.00  2.26           O  
ATOM    762  CB  ALA A  96      16.778  72.138  76.870  1.00  1.00           C  
ATOM    763  N   LEU A  97      13.843  73.104  77.975  1.00  3.08           N  
ATOM    764  CA  LEU A  97      12.947  74.242  78.126  1.00  5.31           C  
ATOM    765  C   LEU A  97      12.406  74.363  79.547  1.00  7.07           C  
ATOM    766  O   LEU A  97      12.397  75.449  80.134  1.00  7.69           O  
ATOM    767  CB  LEU A  97      11.779  74.145  77.147  1.00  3.64           C  
ATOM    768  CG  LEU A  97      11.041  75.480  77.041  1.00  2.93           C  
ATOM    769  CD1 LEU A  97      11.520  76.199  75.802  1.00  1.06           C  
ATOM    770  CD2 LEU A  97       9.533  75.263  77.026  1.00  1.00           C  
ATOM    771  N   ASN A  98      11.946  73.249  80.100  1.00  8.78           N  
ATOM    772  CA  ASN A  98      11.410  73.264  81.449  1.00 11.07           C  
ATOM    773  C   ASN A  98      12.500  73.534  82.485  1.00  9.71           C  
ATOM    774  O   ASN A  98      12.228  74.092  83.548  1.00  8.90           O  
ATOM    775  CB  ASN A  98      10.681  71.946  81.752  1.00 14.96           C  
ATOM    776  CG  ASN A  98      11.535  70.713  81.471  1.00 19.90           C  
ATOM    777  OD1 ASN A  98      12.567  70.484  82.120  1.00 20.98           O  
ATOM    778  ND2 ASN A  98      11.102  69.909  80.501  1.00 21.45           N  
ATOM    779  N   MET A  99      13.735  73.152  82.173  1.00  8.67           N  
ATOM    780  CA  MET A  99      14.826  73.382  83.111  1.00  8.13           C  
ATOM    781  C   MET A  99      15.102  74.868  83.098  1.00  7.69           C  
ATOM    782  O   MET A  99      15.390  75.464  84.133  1.00  6.86           O  
ATOM    783  CB  MET A  99      16.084  72.615  82.695  1.00  8.22           C  
ATOM    784  CG  MET A  99      17.123  72.464  83.816  1.00  7.86           C  
ATOM    785  SD  MET A  99      18.597  71.487  83.372  1.00  8.04           S  
ATOM    786  CE  MET A  99      17.842  69.989  82.736  1.00  6.01           C  
ATOM    787  N   ALA A 100      14.998  75.448  81.903  1.00  7.69           N  
ATOM    788  CA  ALA A 100      15.212  76.872  81.683  1.00  5.85           C  
ATOM    789  C   ALA A 100      14.186  77.650  82.490  1.00  6.11           C  
ATOM    790  O   ALA A 100      14.510  78.655  83.125  1.00  7.27           O  
ATOM    791  CB  ALA A 100      15.071  77.196  80.200  1.00  3.71           C  
ATOM    792  N   ARG A 101      12.945  77.178  82.458  1.00  5.69           N  
ATOM    793  CA  ARG A 101      11.857  77.804  83.198  1.00  5.33           C  
ATOM    794  C   ARG A 101      12.081  77.589  84.694  1.00  4.13           C  
ATOM    795  O   ARG A 101      11.898  78.489  85.511  1.00  4.04           O  
ATOM    796  CB  ARG A 101      10.518  77.193  82.752  1.00  6.74           C  
ATOM    797  CG  ARG A 101       9.327  77.483  83.659  1.00  9.32           C  
ATOM    798  CD  ARG A 101       8.008  77.187  82.955  1.00 11.46           C  
ATOM    799  NE  ARG A 101       8.067  75.956  82.171  1.00 17.06           N  
ATOM    800  CZ  ARG A 101       8.202  74.735  82.682  1.00 18.63           C  
ATOM    801  NH1 ARG A 101       8.288  74.567  83.999  1.00 18.81           N  
ATOM    802  NH2 ARG A 101       8.262  73.678  81.874  1.00 17.00           N  
ATOM    803  N   PHE A 102      12.489  76.387  85.053  1.00  3.68           N  
ATOM    804  CA  PHE A 102      12.736  76.091  86.445  1.00  4.81           C  
ATOM    805  C   PHE A 102      13.735  77.097  87.023  1.00  4.99           C  
ATOM    806  O   PHE A 102      13.536  77.642  88.112  1.00  5.43           O  
ATOM    807  CB  PHE A 102      13.264  74.665  86.576  1.00  5.29           C  
ATOM    808  CG  PHE A 102      13.670  74.306  87.961  1.00  7.82           C  
ATOM    809  CD1 PHE A 102      15.006  74.390  88.350  1.00  9.04           C  
ATOM    810  CD2 PHE A 102      12.717  73.917  88.896  1.00  8.10           C  
ATOM    811  CE1 PHE A 102      15.387  74.091  89.654  1.00  9.41           C  
ATOM    812  CE2 PHE A 102      13.088  73.615  90.205  1.00  8.55           C  
ATOM    813  CZ  PHE A 102      14.425  73.703  90.584  1.00  9.16           C  
ATOM    814  N   ILE A 103      14.808  77.337  86.281  1.00  4.45           N  
ATOM    815  CA  ILE A 103      15.835  78.272  86.695  1.00  3.63           C  
ATOM    816  C   ILE A 103      15.246  79.657  86.883  1.00  2.89           C  
ATOM    817  O   ILE A 103      15.463  80.309  87.907  1.00  1.12           O  
ATOM    818  CB  ILE A 103      16.974  78.335  85.653  1.00  5.63           C  
ATOM    819  CG1 ILE A 103      17.765  77.020  85.668  1.00  5.23           C  
ATOM    820  CG2 ILE A 103      17.902  79.517  85.947  1.00  5.06           C  
ATOM    821  CD1 ILE A 103      18.329  76.657  87.030  1.00  5.93           C  
ATOM    822  N   ARG A 104      14.494  80.103  85.888  1.00  3.18           N  
ATOM    823  CA  ARG A 104      13.872  81.415  85.948  1.00  4.09           C  
ATOM    824  C   ARG A 104      13.132  81.570  87.276  1.00  3.86           C  
ATOM    825  O   ARG A 104      13.235  82.602  87.938  1.00  3.30           O  
ATOM    826  CB  ARG A 104      12.919  81.596  84.761  1.00  3.82           C  
ATOM    827  CG  ARG A 104      12.428  83.023  84.553  1.00  6.24           C  
ATOM    828  CD  ARG A 104      11.910  83.234  83.130  1.00  9.80           C  
ATOM    829  NE  ARG A 104      10.465  83.457  83.037  1.00 11.57           N  
ATOM    830  CZ  ARG A 104       9.538  82.614  83.486  1.00 14.17           C  
ATOM    831  NH1 ARG A 104       9.889  81.473  84.073  1.00 14.89           N  
ATOM    832  NH2 ARG A 104       8.253  82.911  83.344  1.00 15.55           N  
ATOM    833  N   SER A 105      12.408  80.532  87.679  1.00  5.34           N  
ATOM    834  CA  SER A 105      11.658  80.576  88.932  1.00  7.30           C  
ATOM    835  C   SER A 105      12.563  80.619  90.149  1.00  8.02           C  
ATOM    836  O   SER A 105      12.355  81.418  91.066  1.00  8.02           O  
ATOM    837  CB  SER A 105      10.733  79.370  89.033  1.00  7.24           C  
ATOM    838  OG  SER A 105       9.760  79.414  88.003  1.00 11.59           O  
ATOM    839  N   GLN A 106      13.573  79.760  90.153  1.00  8.40           N  
ATOM    840  CA  GLN A 106      14.498  79.716  91.264  1.00  8.32           C  
ATOM    841  C   GLN A 106      15.236  81.043  91.443  1.00  7.81           C  
ATOM    842  O   GLN A 106      15.581  81.418  92.565  1.00  8.18           O  
ATOM    843  CB  GLN A 106      15.484  78.558  91.082  1.00  9.76           C  
ATOM    844  CG  GLN A 106      15.488  77.595  92.264  1.00 11.80           C  
ATOM    845  CD  GLN A 106      14.109  77.003  92.532  1.00 14.17           C  
ATOM    846  OE1 GLN A 106      13.097  77.715  92.552  1.00 14.49           O  
ATOM    847  NE2 GLN A 106      14.065  75.694  92.749  1.00 13.91           N  
ATOM    848  N   THR A 107      15.468  81.758  90.343  1.00  6.32           N  
ATOM    849  CA  THR A 107      16.147  83.048  90.413  1.00  3.40           C  
ATOM    850  C   THR A 107      15.174  84.117  90.874  1.00  3.12           C  
ATOM    851  O   THR A 107      15.580  85.158  91.374  1.00  3.14           O  
ATOM    852  CB  THR A 107      16.726  83.480  89.050  1.00  3.23           C  
ATOM    853  OG1 THR A 107      15.758  83.252  88.026  1.00  3.48           O  
ATOM    854  CG2 THR A 107      17.986  82.719  88.733  1.00  1.75           C  
ATOM    855  N   LEU A 108      13.883  83.866  90.701  1.00  3.00           N  
ATOM    856  CA  LEU A 108      12.877  84.832  91.125  1.00  3.23           C  
ATOM    857  C   LEU A 108      12.764  84.820  92.644  1.00  3.30           C  
ATOM    858  O   LEU A 108      12.830  85.859  93.306  1.00  1.82           O  
ATOM    859  CB  LEU A 108      11.511  84.504  90.507  1.00  2.12           C  
ATOM    860  CG  LEU A 108      10.367  85.484  90.813  1.00  1.45           C  
ATOM    861  CD1 LEU A 108      10.789  86.910  90.518  1.00  1.00           C  
ATOM    862  CD2 LEU A 108       9.148  85.116  89.993  1.00  1.29           C  
ATOM    863  N   THR A 109      12.598  83.626  93.194  1.00  3.65           N  
ATOM    864  CA  THR A 109      12.471  83.488  94.628  1.00  4.12           C  
ATOM    865  C   THR A 109      13.757  83.876  95.329  1.00  4.89           C  
ATOM    866  O   THR A 109      13.718  84.352  96.465  1.00  5.25           O  
ATOM    867  CB  THR A 109      12.073  82.051  95.009  1.00  4.93           C  
ATOM    868  OG1 THR A 109      12.682  81.131  94.096  1.00  4.12           O  
ATOM    869  CG2 THR A 109      10.550  81.899  94.966  1.00  4.12           C  
ATOM    870  N   LEU A 110      14.893  83.687  94.658  1.00  3.95           N  
ATOM    871  CA  LEU A 110      16.174  84.047  95.253  1.00  3.16           C  
ATOM    872  C   LEU A 110      16.175  85.537  95.475  1.00  2.33           C  
ATOM    873  O   LEU A 110      16.469  86.014  96.572  1.00  1.30           O  
ATOM    874  CB  LEU A 110      17.334  83.680  94.334  1.00  5.13           C  
ATOM    875  CG  LEU A 110      18.737  83.985  94.892  1.00  7.12           C  
ATOM    876  CD1 LEU A 110      18.889  83.381  96.294  1.00  5.09           C  
ATOM    877  CD2 LEU A 110      19.802  83.438  93.936  1.00  4.88           C  
ATOM    878  N   LEU A 111      15.833  86.256  94.411  1.00  2.07           N  
ATOM    879  CA  LEU A 111      15.751  87.709  94.416  1.00  2.05           C  
ATOM    880  C   LEU A 111      14.831  88.160  95.553  1.00  2.60           C  
ATOM    881  O   LEU A 111      15.133  89.113  96.277  1.00  1.00           O  
ATOM    882  CB  LEU A 111      15.204  88.191  93.070  1.00  2.04           C  
ATOM    883  CG  LEU A 111      15.131  89.691  92.795  1.00  1.00           C  
ATOM    884  CD1 LEU A 111      16.509  90.213  92.474  1.00  1.24           C  
ATOM    885  CD2 LEU A 111      14.205  89.947  91.634  1.00  1.00           C  
ATOM    886  N   GLU A 112      13.708  87.469  95.709  1.00  3.36           N  
ATOM    887  CA  GLU A 112      12.775  87.800  96.778  1.00  5.85           C  
ATOM    888  C   GLU A 112      13.459  87.658  98.134  1.00  6.38           C  
ATOM    889  O   GLU A 112      13.530  88.614  98.907  1.00  6.29           O  
ATOM    890  CB  GLU A 112      11.551  86.886  96.735  1.00  5.29           C  
ATOM    891  CG  GLU A 112      10.371  87.454  95.986  1.00  6.93           C  
ATOM    892  CD  GLU A 112       9.719  86.432  95.064  1.00  8.67           C  
ATOM    893  OE1 GLU A 112       9.506  85.280  95.496  1.00 10.98           O  
ATOM    894  OE2 GLU A 112       9.417  86.782  93.906  1.00  7.54           O  
ATOM    895  N   LYS A 113      13.971  86.468  98.418  1.00  5.78           N  
ATOM    896  CA  LYS A 113      14.622  86.247  99.693  1.00  7.31           C  
ATOM    897  C   LYS A 113      15.788  87.203  99.940  1.00  8.13           C  
ATOM    898  O   LYS A 113      16.120  87.501 101.093  1.00  8.19           O  
ATOM    899  CB  LYS A 113      15.049  84.785  99.812  1.00  6.04           C  
ATOM    900  CG  LYS A 113      13.850  83.871  99.677  1.00  6.71           C  
ATOM    901  CD  LYS A 113      13.997  82.573 100.432  1.00  7.00           C  
ATOM    902  CE  LYS A 113      12.686  81.767 100.380  1.00  7.71           C  
ATOM    903  NZ  LYS A 113      11.466  82.522 100.844  1.00  5.68           N  
ATOM    904  N   LEU A 114      16.397  87.707  98.872  1.00  7.04           N  
ATOM    905  CA  LEU A 114      17.492  88.641  99.044  1.00  7.45           C  
ATOM    906  C   LEU A 114      16.974  90.031  99.415  1.00  8.62           C  
ATOM    907  O   LEU A 114      17.556  90.710 100.266  1.00  8.99           O  
ATOM    908  CB  LEU A 114      18.344  88.719  97.780  1.00  5.06           C  
ATOM    909  CG  LEU A 114      19.361  87.585  97.625  1.00  5.04           C  
ATOM    910  CD1 LEU A 114      20.348  87.943  96.526  1.00  4.45           C  
ATOM    911  CD2 LEU A 114      20.102  87.359  98.933  1.00  2.92           C  
ATOM    912  N   ASN A 115      15.884  90.450  98.779  1.00  9.02           N  
ATOM    913  CA  ASN A 115      15.287  91.755  99.061  1.00  9.50           C  
ATOM    914  C   ASN A 115      14.750  91.803 100.487  1.00  9.88           C  
ATOM    915  O   ASN A 115      14.964  92.770 101.220  1.00 10.10           O  
ATOM    916  CB  ASN A 115      14.142  92.044  98.086  1.00  9.86           C  
ATOM    917  CG  ASN A 115      14.627  92.596  96.757  1.00  8.43           C  
ATOM    918  OD1 ASN A 115      15.385  93.557  96.718  1.00  9.75           O  
ATOM    919  ND2 ASN A 115      14.174  91.999  95.661  1.00  9.18           N  
ATOM    920  N   GLU A 116      14.038  90.754 100.871  1.00 10.56           N  
ATOM    921  CA  GLU A 116      13.478  90.668 102.207  1.00 11.70           C  
ATOM    922  C   GLU A 116      14.623  90.633 103.226  1.00 12.21           C  
ATOM    923  O   GLU A 116      14.390  90.694 104.438  1.00 13.24           O  
ATOM    924  CB  GLU A 116      12.601  89.411 102.332  1.00 12.73           C  
ATOM    925  CG  GLU A 116      11.184  89.490 101.680  1.00 16.53           C  
ATOM    926  CD  GLU A 116      11.168  89.673 100.144  1.00 18.90           C  
ATOM    927  OE1 GLU A 116      11.260  90.823  99.651  1.00 19.09           O  
ATOM    928  OE2 GLU A 116      11.055  88.661  99.420  1.00 18.55           O  
ATOM    929  N   LEU A 117      15.859  90.546 102.725  1.00 11.35           N  
ATOM    930  CA  LEU A 117      17.056  90.512 103.575  1.00 10.41           C  
ATOM    931  C   LEU A 117      17.821  91.830 103.603  1.00 11.31           C  
ATOM    932  O   LEU A 117      18.565  92.094 104.545  1.00 11.26           O  
ATOM    933  CB  LEU A 117      18.013  89.405 103.130  1.00  7.96           C  
ATOM    934  CG  LEU A 117      17.659  87.970 103.514  1.00  5.17           C  
ATOM    935  CD1 LEU A 117      18.727  87.037 102.968  1.00  3.49           C  
ATOM    936  CD2 LEU A 117      17.548  87.844 105.026  1.00  2.92           C  
ATOM    937  N   ALA A 118      17.644  92.646 102.569  1.00 12.66           N  
ATOM    938  CA  ALA A 118      18.309  93.944 102.489  1.00 14.18           C  
ATOM    939  C   ALA A 118      17.586  94.956 103.382  1.00 15.40           C  
ATOM    940  O   ALA A 118      18.151  95.992 103.751  1.00 15.54           O  
ATOM    941  CB  ALA A 118      18.334  94.432 101.044  1.00 12.98           C  
ATOM    942  N   LYS A 119      16.331  94.655 103.708  1.00 16.26           N  
ATOM    943  CA  LYS A 119      15.523  95.508 104.581  1.00 18.43           C  
ATOM    944  C   LYS A 119      15.614  94.914 105.986  1.00 20.16           C  
ATOM    945  O   LYS A 119      14.622  94.862 106.724  1.00 21.38           O  
ATOM    946  CB  LYS A 119      14.049  95.520 104.137  1.00 17.61           C  
ATOM    947  CG  LYS A 119      13.691  96.522 103.049  1.00 16.04           C  
ATOM    948  CD  LYS A 119      12.339  96.171 102.431  1.00 15.03           C  
ATOM    949  CE  LYS A 119      11.933  97.154 101.332  1.00 15.93           C  
ATOM    950  NZ  LYS A 119      12.912  97.241 100.208  1.00 14.83           N  
ATOM    951  N   GLY A 120      16.812  94.467 106.345  1.00 20.48           N  
ATOM    952  CA  GLY A 120      17.030  93.860 107.643  1.00 22.02           C  
ATOM    953  C   GLY A 120      16.640  92.395 107.579  1.00 23.38           C  
ATOM    954  O   GLY A 120      17.534  91.547 107.327  1.00 24.26           O  
ATOM    955  OXT GLY A 120      15.433  92.096 107.748  1.00 24.44           O  
TER     956      GLY A 120                                                      
END
MOLECULE T0478_138_267.pdb
ATOM   1121  N   ASP   138      15.040  81.714 110.368  1.00 45.58          
ATOM   1122  CA  ASP   138      16.230  82.548 110.663  1.00 45.87          
ATOM   1123  C   ASP   138      15.852  84.016 110.769  1.00 45.10          
ATOM   1124  O   ASP   138      14.864  84.433 110.134  1.00 44.87          
ATOM   1125  CB  ASP   138      17.257  82.385 109.544  1.00 46.10          
ATOM   1126  CG  ASP   138      17.911  81.008 109.553  1.00 49.57          
ATOM   1127  OD1 ASP   138      18.669  80.727 110.517  1.00 49.14          
ATOM   1128  OD2 ASP   138      17.655  80.213 108.601  1.00 52.78          
ATOM   1129  N   ALA   139      16.613  84.786 111.564  1.00 43.27          
ATOM   1130  CA  ALA   139      16.452  86.237 111.613  1.00 42.60          
ATOM   1131  C   ALA   139      16.934  86.838 110.292  1.00 43.26          
ATOM   1132  O   ALA   139      17.769  86.235 109.618  1.00 43.42          
ATOM   1133  CB  ALA   139      17.218  86.844 112.770  1.00 41.93          
ATOM   1134  N   LEU   140      16.423  88.024 109.934  1.00 42.66          
ATOM   1135  CA  LEU   140      16.670  88.601 108.620  1.00 42.23          
ATOM   1136  C   LEU   140      18.154  88.621 108.146  1.00 41.65          
ATOM   1137  O   LEU   140      18.440  88.253 107.016  1.00 41.90          
ATOM   1138  CB  LEU   140      15.984  89.965 108.503  1.00 42.36          
ATOM   1139  CG  LEU   140      16.203  90.730 107.186  1.00 43.56          
ATOM   1140  CD1 LEU   140      15.427  90.137 106.035  1.00 40.46          
ATOM   1141  CD2 LEU   140      15.881  92.201 107.320  1.00 43.67          
ATOM   1142  N   PRO   141      19.106  89.030 109.004  1.00 41.42          
ATOM   1143  CA  PRO   141      20.469  89.087 108.466  1.00 41.37          
ATOM   1144  C   PRO   141      21.064  87.712 108.067  1.00 41.50          
ATOM   1145  O   PRO   141      21.768  87.599 107.049  1.00 40.11          
ATOM   1146  CB  PRO   141      21.291  89.741 109.596  1.00 41.72          
ATOM   1147  CG  PRO   141      20.341  90.185 110.620  1.00 41.83          
ATOM   1148  CD  PRO   141      19.032  89.459 110.412  1.00 40.93          
ATOM   1149  N   ASP   142      20.787  86.690 108.873  1.00 41.36          
ATOM   1150  CA  ASP   142      21.047  85.300 108.498  1.00 41.77          
ATOM   1151  C   ASP   142      20.293  84.742 107.308  1.00 40.91          
ATOM   1152  O   ASP   142      20.852  83.956 106.554  1.00 41.00          
ATOM   1153  CB  ASP   142      20.723  84.409 109.665  1.00 42.77          
ATOM   1154  CG  ASP   142      21.879  84.296 110.579  1.00 47.80          
ATOM   1155  OD1 ASP   142      22.791  83.493 110.242  1.00 53.89          
ATOM   1156  OD2 ASP   142      21.882  85.025 111.595  1.00 49.00          
ATOM   1157  N   ALA   143      19.012  85.078 107.186  1.00 39.57          
ATOM   1158  CA  ALA   143      18.239  84.595 106.090  1.00 38.75          
ATOM   1159  C   ALA   143      18.858  85.181 104.820  1.00 38.96          
ATOM   1160  O   ALA   143      18.996  84.506 103.828  1.00 39.36          
ATOM   1161  CB  ALA   143      16.796  85.020 106.243  1.00 38.14          
ATOM   1162  N   ILE   144      19.270  86.432 104.864  1.00 39.12          
ATOM   1163  CA  ILE   144      19.797  87.071 103.690  1.00 39.66          
ATOM   1164  C   ILE   144      21.048  86.334 103.234  1.00 40.81          
ATOM   1165  O   ILE   144      21.179  85.958 102.056  1.00 41.14          
ATOM   1166  CB  ILE   144      20.169  88.511 103.971  1.00 39.22          
ATOM   1167  CG1 ILE   144      18.916  89.387 104.041  1.00 40.15          
ATOM   1168  CG2 ILE   144      21.075  89.026 102.895  1.00 40.12          
ATOM   1169  CD  ILE   144      19.176  90.767 104.617  1.00 35.25          
ATOM   1170  N   ILE   145      21.974  86.114 104.155  1.00 40.49          
ATOM   1171  CA  ILE   145      23.184  85.440 103.770  1.00 41.50          
ATOM   1172  C   ILE   145      22.927  83.991 103.363  1.00 41.39          
ATOM   1173  O   ILE   145      23.310  83.567 102.282  1.00 41.80          
ATOM   1174  CB  ILE   145      24.299  85.506 104.856  1.00 41.78          
ATOM   1175  CG1 ILE   145      25.081  86.804 104.658  1.00 42.98          
ATOM   1176  CG2 ILE   145      25.230  84.333 104.646  1.00 41.68          
ATOM   1177  CD  ILE   145      26.028  87.196 105.784  1.00 44.38          
ATOM   1178  N   LYS   146      22.262  83.251 104.231  1.00 41.16          
ATOM   1179  CA  LYS   146      22.009  81.860 104.004  1.00 40.47          
ATOM   1180  C   LYS   146      21.234  81.527 102.725  1.00 40.27          
ATOM   1181  O   LYS   146      21.525  80.547 102.066  1.00 40.67          
ATOM   1182  CB  LYS   146      21.302  81.288 105.228  1.00 40.50          
ATOM   1183  CG  LYS   146      22.296  80.943 106.339  1.00 41.61          
ATOM   1184  CD  LYS   146      21.627  80.324 107.601  1.00 42.47          
ATOM   1185  CE  LYS   146      21.106  78.899 107.385  1.00 40.71          
ATOM   1186  NZ  LYS   146      20.212  78.492 108.538  1.00 43.00          
ATOM   1187  N   GLU   147      20.210  82.286 102.404  1.00 39.57          
ATOM   1188  CA  GLU   147      19.433  82.021 101.191  1.00 39.50          
ATOM   1189  C   GLU   147      20.244  82.372  99.929  1.00 38.54          
ATOM   1190  O   GLU   147      20.184  81.660  98.927  1.00 38.77          
ATOM   1191  CB  GLU   147      18.122  82.836 101.208  1.00 39.27          
ATOM   1192  CG  GLU   147      17.229  82.505 102.411  1.00 42.25          
ATOM   1193  CD  GLU   147      16.430  81.197 102.228  1.00 45.53          
ATOM   1194  OE1 GLU   147      15.624  80.866 103.127  1.00 47.81          
ATOM   1195  OE2 GLU   147      16.582  80.518 101.182  1.00 45.79          
ATOM   1196  N   ASN   148      21.001  83.464  99.966  1.00 36.99          
ATOM   1197  CA  ASN   148      21.768  83.827  98.793  1.00 35.95          
ATOM   1198  C   ASN   148      22.830  82.812  98.489  1.00 35.81          
ATOM   1199  O   ASN   148      22.930  82.379  97.387  1.00 36.79          
ATOM   1200  CB  ASN   148      22.328  85.237  98.897  1.00 35.42          
ATOM   1201  CG  ASN   148      21.300  86.302  98.535  1.00 36.15          
ATOM   1202  OD1 ASN   148      21.272  86.790  97.417  1.00 37.77          
ATOM   1203  ND2 ASN   148      20.434  86.648  99.480  1.00 38.10          
ATOM   1204  N   VAL   149      23.618  82.430  99.474  1.00 36.75          
ATOM   1205  CA  VAL   149      24.575  81.330  99.346  1.00 37.63          
ATOM   1206  C   VAL   149      23.926  80.060  98.773  1.00 38.22          
ATOM   1207  O   VAL   149      24.416  79.495  97.809  1.00 39.53          
ATOM   1208  CB  VAL   149      25.231  81.000 100.721  1.00 38.17          
ATOM   1209  CG1 VAL   149      25.993  79.701 100.654  1.00 37.22          
ATOM   1210  CG2 VAL   149      26.143  82.163 101.183  1.00 37.52          
ATOM   1211  N   PHE   150      22.807  79.616  99.322  1.00 37.55          
ATOM   1212  CA  PHE   150      22.133  78.480  98.730  1.00 36.83          
ATOM   1213  C   PHE   150      21.714  78.749  97.265  1.00 36.87          
ATOM   1214  O   PHE   150      22.089  77.989  96.374  1.00 36.79          
ATOM   1215  CB  PHE   150      20.935  78.035  99.579  1.00 35.87          
ATOM   1216  CG  PHE   150      19.984  77.085  98.862  1.00 36.96          
ATOM   1217  CD1 PHE   150      20.288  75.759  98.701  1.00 36.23          
ATOM   1218  CD2 PHE   150      18.759  77.526  98.386  1.00 39.93          
ATOM   1219  CE1 PHE   150      19.423  74.915  98.060  1.00 34.92          
ATOM   1220  CE2 PHE   150      17.886  76.664  97.739  1.00 37.78          
ATOM   1221  CZ  PHE   150      18.224  75.370  97.590  1.00 38.25          
ATOM   1222  N   PHE   151      20.952  79.819  97.004  1.00 36.72          
ATOM   1223  CA  PHE   151      20.297  80.025  95.688  1.00 35.51          
ATOM   1224  C   PHE   151      21.261  80.523  94.566  1.00 35.60          
ATOM   1225  O   PHE   151      21.074  80.213  93.396  1.00 34.93          
ATOM   1226  CB  PHE   151      19.151  81.014  95.838  1.00 35.96          
ATOM   1227  CG  PHE   151      17.837  80.401  96.208  1.00 37.00          
ATOM   1228  CD1 PHE   151      17.088  79.705  95.262  1.00 40.87          
ATOM   1229  CD2 PHE   151      17.306  80.562  97.485  1.00 37.73          
ATOM   1230  CE1 PHE   151      15.806  79.147  95.574  1.00 39.31          
ATOM   1231  CE2 PHE   151      16.053  80.019  97.818  1.00 36.20          
ATOM   1232  CZ  PHE   151      15.300  79.303  96.862  1.00 38.34          
ATOM   1233  N   LEU   152      22.318  81.265  94.915  1.00 35.36          
ATOM   1234  CA  LEU   152      23.317  81.637  93.899  1.00 35.09          
ATOM   1235  C   LEU   152      23.997  80.387  93.325  1.00 35.76          
ATOM   1236  O   LEU   152      24.300  80.341  92.126  1.00 37.03          
ATOM   1237  CB  LEU   152      24.353  82.631  94.435  1.00 34.49          
ATOM   1238  CG  LEU   152      23.815  84.011  94.851  1.00 36.42          
ATOM   1239  CD1 LEU   152      24.911  84.779  95.605  1.00 36.16          
ATOM   1240  CD2 LEU   152      23.169  84.855  93.648  1.00 28.34          
ATOM   1241  N   ARG   153      24.185  79.363  94.160  1.00 34.90          
ATOM   1242  CA  ARG   153      24.717  78.079  93.721  1.00 34.64          
ATOM   1243  C   ARG   153      23.680  77.360  92.802  1.00 34.38          
ATOM   1244  O   ARG   153      23.997  76.879  91.710  1.00 35.70          
ATOM   1245  CB  ARG   153      25.120  77.231  94.955  1.00 34.57          
ATOM   1246  CG  ARG   153      25.849  75.955  94.587  1.00 37.81          
ATOM   1247  CD  ARG   153      26.508  75.275  95.767  1.00 41.68          
ATOM   1248  NE  ARG   153      27.317  74.099  95.362  1.00 43.99          
ATOM   1249  CZ  ARG   153      27.835  73.213  96.221  1.00 43.27          
ATOM   1250  NH1 ARG   153      27.614  73.335  97.527  1.00 38.50          
ATOM   1251  NH2 ARG   153      28.547  72.183  95.784  1.00 43.56          
ATOM   1252  N   ILE   154      22.419  77.346  93.218  1.00 33.12          
ATOM   1253  CA  ILE   154      21.366  76.771  92.408  1.00 31.74          
ATOM   1254  C   ILE   154      21.323  77.412  90.994  1.00 31.97          
ATOM   1255  O   ILE   154      21.248  76.729  89.951  1.00 32.34          
ATOM   1256  CB  ILE   154      20.053  76.962  93.135  1.00 30.77          
ATOM   1257  CG1 ILE   154      20.000  76.138  94.457  1.00 29.63          
ATOM   1258  CG2 ILE   154      18.944  76.610  92.265  1.00 29.73          
ATOM   1259  CD  ILE   154      20.535  74.692  94.422  1.00 24.57          
ATOM   1260  N   MET   155      21.384  78.746  90.972  1.00 32.10          
ATOM   1261  CA  MET   155      21.431  79.512  89.756  1.00 30.15          
ATOM   1262  C   MET   155      22.658  79.205  88.929  1.00 30.64          
ATOM   1263  O   MET   155      22.579  79.190  87.718  1.00 30.42          
ATOM   1264  CB  MET   155      21.380  81.023  90.085  1.00 31.10          
ATOM   1265  CG  MET   155      20.094  81.570  90.736  1.00 30.70          
ATOM   1266  SD  MET   155      18.594  81.405  89.759  1.00 29.53          
ATOM   1267  CE  MET   155      17.743  80.027  90.556  1.00 33.00          
ATOM   1268  N   ALA   156      23.823  79.023  89.559  1.00 31.11          
ATOM   1269  CA  ALA   156      25.064  78.832  88.800  1.00 30.95          
ATOM   1270  C   ALA   156      25.024  77.445  88.206  1.00 31.71          
ATOM   1271  O   ALA   156      25.444  77.237  87.077  1.00 32.16          
ATOM   1272  CB  ALA   156      26.307  78.968  89.721  1.00 30.67          
ATOM   1273  N   ASP   157      24.544  76.473  88.975  1.00 32.22          
ATOM   1274  CA  ASP   157      24.353  75.104  88.421  1.00 32.73          
ATOM   1275  C   ASP   157      23.394  75.154  87.200  1.00 32.59          
ATOM   1276  O   ASP   157      23.646  74.500  86.189  1.00 32.68          
ATOM   1277  CB  ASP   157      23.746  74.164  89.466  1.00 31.03          
ATOM   1278  CG  ASP   157      24.681  73.839  90.605  1.00 36.56          
ATOM   1279  OD1 ASP   157      25.935  74.093  90.550  1.00 33.08          
ATOM   1280  OD2 ASP   157      24.138  73.268  91.584  1.00 42.31          
ATOM   1281  N   HSD   158      22.263  75.862  87.317  1.00 32.58          
ATOM   1282  CA  HSD   158      21.267  75.865  86.212  1.00 33.67          
ATOM   1283  C   HSD   158      21.812  76.386  84.905  1.00 34.27          
ATOM   1284  O   HSD   158      21.474  75.891  83.859  1.00 36.41          
ATOM   1285  CB  HSD   158      20.048  76.710  86.541  1.00 33.62          
ATOM   1286  CG  HSD   158      19.214  76.152  87.644  1.00 35.35          
ATOM   1287  ND1 HSD   158      18.549  76.950  88.546  1.00 38.91          
ATOM   1288  CD2 HSD   158      18.948  74.878  88.003  1.00 34.79          
ATOM   1289  CE1 HSD   158      17.885  76.188  89.397  1.00 38.31          
ATOM   1290  NE2 HSD   158      18.142  74.926  89.112  1.00 37.21          
ATOM   1291  N   ALA   159      22.637  77.413  84.955  1.00 34.98          
ATOM   1292  CA  ALA   159      23.142  77.995  83.765  1.00 35.22          
ATOM   1293  C   ALA   159      24.129  77.008  83.120  1.00 36.05          
ATOM   1294  O   ALA   159      24.337  77.007  81.904  1.00 36.49          
ATOM   1295  CB  ALA   159      23.767  79.320  84.087  1.00 35.70          
ATOM   1296  N   LYS   160      24.704  76.105  83.900  1.00 36.27          
ATOM   1297  CA  LYS   160      25.509  75.037  83.237  1.00 36.63          
ATOM   1298  C   LYS   160      24.617  73.922  82.701  1.00 35.70          
ATOM   1299  O   LYS   160      24.758  73.460  81.592  1.00 36.30          
ATOM   1300  CB  LYS   160      26.550  74.460  84.187  1.00 37.31          
ATOM   1301  CG  LYS   160      27.457  75.480  84.775  1.00 36.11          
ATOM   1302  CD  LYS   160      28.391  74.850  85.757  1.00 36.24          
ATOM   1303  CE  LYS   160      29.345  75.881  86.264  1.00 39.40          
ATOM   1304  NZ  LYS   160      28.604  76.896  87.094  1.00 37.17          
ATOM   1305  N   PHE   161      23.653  73.512  83.483  1.00 35.63          
ATOM   1306  CA  PHE   161      22.675  72.581  82.967  1.00 35.34          
ATOM   1307  C   PHE   161      22.119  73.093  81.635  1.00 35.19          
ATOM   1308  O   PHE   161      21.964  72.347  80.685  1.00 37.17          
ATOM   1309  CB  PHE   161      21.547  72.339  83.984  1.00 34.81          
ATOM   1310  CG  PHE   161      22.021  71.846  85.329  1.00 34.67          
ATOM   1311  CD1 PHE   161      23.239  71.194  85.469  1.00 36.02          
ATOM   1312  CD2 PHE   161      21.214  71.986  86.469  1.00 35.90          
ATOM   1313  CE1 PHE   161      23.701  70.698  86.771  1.00 35.61          
ATOM   1314  CE2 PHE   161      21.650  71.517  87.745  1.00 33.40          
ATOM   1315  CZ  PHE   161      22.908  70.880  87.886  1.00 33.62          
ATOM   1316  N   ILE   162      21.851  74.379  81.514  1.00 34.48          
ATOM   1317  CA  ILE   162      21.309  74.876  80.247  1.00 32.33          
ATOM   1318  C   ILE   162      22.447  74.848  79.245  1.00 30.98          
ATOM   1319  O   ILE   162      22.325  74.305  78.154  1.00 30.63          
ATOM   1320  CB  ILE   162      20.722  76.327  80.448  1.00 33.26          
ATOM   1321  CG1 ILE   162      19.564  76.297  81.447  1.00 34.68          
ATOM   1322  CG2 ILE   162      20.358  76.974  79.123  1.00 31.44          
ATOM   1323  CD  ILE   162      18.934  77.711  81.788  1.00 35.43          
ATOM   1324  N   GLY   163      23.619  75.366  79.635  1.00 30.82          
ATOM   1325  CA  GLY   163      24.782  75.333  78.742  1.00 27.80          
ATOM   1326  C   GLY   163      25.039  73.968  78.160  1.00 28.42          
ATOM   1327  O   GLY   163      25.347  73.833  76.985  1.00 28.60          
ATOM   1328  N   HSD   164      24.953  72.936  78.990  1.00 29.19          
ATOM   1329  CA  HSD   164      25.325  71.574  78.557  1.00 30.68          
ATOM   1330  C   HSD   164      24.203  70.896  77.784  1.00 31.47          
ATOM   1331  O   HSD   164      24.481  70.107  76.912  1.00 33.24          
ATOM   1332  CB  HSD   164      25.735  70.692  79.767  1.00 30.09          
ATOM   1333  CG  HSD   164      27.095  71.029  80.305  1.00 31.98          
ATOM   1334  ND1 HSD   164      28.110  70.098  80.436  1.00 32.42          
ATOM   1335  CD2 HSD   164      27.611  72.213  80.715  1.00 32.58          
ATOM   1336  CE1 HSD   164      29.195  70.702  80.901  1.00 34.46          
ATOM   1337  NE2 HSD   164      28.920  71.988  81.077  1.00 34.48          
ATOM   1338  N   LEU   165      22.944  71.199  78.094  1.00 32.56          
ATOM   1339  CA  LEU   165      21.808  70.502  77.460  1.00 33.05          
ATOM   1340  C   LEU   165      21.272  71.157  76.160  1.00 33.28          
ATOM   1341  O   LEU   165      20.489  70.561  75.405  1.00 34.32          
ATOM   1342  CB  LEU   165      20.690  70.343  78.479  1.00 32.81          
ATOM   1343  CG  LEU   165      20.457  69.125  79.386  1.00 34.49          
ATOM   1344  CD1 LEU   165      21.306  67.844  79.081  1.00 32.26          
ATOM   1345  CD2 LEU   165      20.462  69.528  80.832  1.00 34.95          
ATOM   1346  N   LEU   166      21.654  72.395  75.920  1.00 33.15          
ATOM   1347  CA  LEU   166      21.511  72.994  74.596  1.00 32.58          
ATOM   1348  C   LEU   166      22.364  72.194  73.579  1.00 33.76          
ATOM   1349  O   LEU   166      23.492  71.737  73.907  1.00 33.94          
ATOM   1350  CB  LEU   166      21.950  74.474  74.605  1.00 31.30          
ATOM   1351  CG  LEU   166      20.999  75.521  75.206  1.00 29.39          
ATOM   1352  CD1 LEU   166      21.648  76.829  75.352  1.00 24.85          
ATOM   1353  CD2 LEU   166      19.784  75.714  74.283  1.00 30.49          
ATOM   1354  N   ASP   167      21.830  72.027  72.358  1.00 32.65          
ATOM   1355  CA  ASP   167      22.628  71.493  71.266  1.00 32.19          
ATOM   1356  C   ASP   167      23.824  72.408  71.053  1.00 32.14          
ATOM   1357  O   ASP   167      23.696  73.656  71.076  1.00 32.16          
ATOM   1358  CB  ASP   167      21.824  71.492  69.996  1.00 30.98          
ATOM   1359  CG  ASP   167      22.476  70.688  68.893  1.00 31.96          
ATOM   1360  OD1 ASP   167      22.556  69.443  69.019  1.00 33.21          
ATOM   1361  OD2 ASP   167      22.832  71.269  67.838  1.00 30.74          
ATOM   1362  N   PRO   168      24.978  71.806  70.801  1.00 31.53          
ATOM   1363  CA  PRO   168      26.215  72.554  70.679  1.00 30.56          
ATOM   1364  C   PRO   168      26.171  73.408  69.390  1.00 32.57          
ATOM   1365  O   PRO   168      27.052  74.254  69.167  1.00 31.61          
ATOM   1366  CB  PRO   168      27.278  71.441  70.596  1.00 30.40          
ATOM   1367  CG  PRO   168      26.651  70.245  71.230  1.00 27.00          
ATOM   1368  CD  PRO   168      25.203  70.345  70.805  1.00 31.70          
ATOM   1369  N   SER   169      25.159  73.185  68.532  1.00 31.56          
ATOM   1370  CA  SER   169      25.038  73.994  67.340  1.00 31.29          
ATOM   1371  C   SER   169      24.308  75.329  67.653  1.00 32.30          
ATOM   1372  O   SER   169      24.077  76.179  66.752  1.00 31.95          
ATOM   1373  CB  SER   169      24.237  73.235  66.289  1.00 30.78          
ATOM   1374  OG  SER   169      22.848  73.324  66.611  1.00 28.80          
ATOM   1375  N   GLU   170      23.889  75.497  68.904  1.00 32.65          
ATOM   1376  CA  GLU   170      23.224  76.755  69.287  1.00 32.83          
ATOM   1377  C   GLU   170      24.305  77.570  69.990  1.00 32.03          
ATOM   1378  O   GLU   170      24.282  77.721  71.229  1.00 30.62          
ATOM   1379  CB  GLU   170      22.015  76.517  70.220  1.00 33.20          
ATOM   1380  CG  GLU   170      20.883  75.742  69.599  1.00 35.37          
ATOM   1381  CD  GLU   170      19.964  76.628  68.732  1.00 41.36          
ATOM   1382  OE1 GLU   170      20.168  77.872  68.664  1.00 43.97          
ATOM   1383  OE2 GLU   170      19.011  76.093  68.114  1.00 44.29          
ATOM   1384  N   ARG   171      25.248  78.060  69.182  1.00 31.72          
ATOM   1385  CA  ARG   171      26.475  78.723  69.681  1.00 32.79          
ATOM   1386  C   ARG   171      26.165  80.011  70.422  1.00 33.01          
ATOM   1387  O   ARG   171      26.712  80.261  71.486  1.00 32.87          
ATOM   1388  CB  ARG   171      27.439  79.025  68.531  1.00 30.94          
ATOM   1389  CG  ARG   171      27.905  77.771  67.858  1.00 32.75          
ATOM   1390  CD  ARG   171      28.556  78.085  66.550  1.00 32.73          
ATOM   1391  NE  ARG   171      29.166  76.876  66.013  1.00 35.50          
ATOM   1392  CZ  ARG   171      30.458  76.565  66.178  1.00 38.36          
ATOM   1393  NH1 ARG   171      31.278  77.357  66.877  1.00 33.16          
ATOM   1394  NH2 ARG   171      30.938  75.457  65.632  1.00 40.49          
ATOM   1395  N   LYS   172      25.275  80.821  69.859  1.00 32.97          
ATOM   1396  CA  LYS   172      24.909  82.056  70.513  1.00 34.25          
ATOM   1397  C   LYS   172      24.342  81.787  71.903  1.00 33.89          
ATOM   1398  O   LYS   172      24.881  82.262  72.902  1.00 33.98          
ATOM   1399  CB  LYS   172      23.921  82.817  69.629  1.00 35.35          
ATOM   1400  CG  LYS   172      23.384  84.111  70.221  1.00 39.92          
ATOM   1401  CD  LYS   172      24.461  85.188  70.359  1.00 47.90          
ATOM   1402  CE  LYS   172      23.900  86.493  70.904  1.00 49.36          
ATOM   1403  NZ  LYS   172      25.027  87.256  71.473  1.00 49.88          
ATOM   1404  N   LEU   173      23.285  80.989  71.972  1.00 33.35          
ATOM   1405  CA  LEU   173      22.641  80.631  73.238  1.00 33.25          
ATOM   1406  C   LEU   173      23.532  79.883  74.239  1.00 33.27          
ATOM   1407  O   LEU   173      23.439  80.131  75.431  1.00 33.00          
ATOM   1408  CB  LEU   173      21.419  79.758  72.970  1.00 33.12          
ATOM   1409  CG  LEU   173      20.317  80.456  72.191  1.00 32.94          
ATOM   1410  CD1 LEU   173      19.218  79.434  71.998  1.00 34.36          
ATOM   1411  CD2 LEU   173      19.801  81.657  73.003  1.00 32.64          
ATOM   1412  N   VAL   174      24.336  78.927  73.763  1.00 34.48          
ATOM   1413  CA  VAL   174      25.307  78.254  74.618  1.00 33.90          
ATOM   1414  C   VAL   174      26.267  79.318  75.111  1.00 34.97          
ATOM   1415  O   VAL   174      26.691  79.272  76.255  1.00 36.03          
ATOM   1416  CB  VAL   174      26.139  77.181  73.888  1.00 34.54          
ATOM   1417  CG1 VAL   174      27.324  76.760  74.740  1.00 30.95          
ATOM   1418  CG2 VAL   174      25.303  75.937  73.518  1.00 32.91          
ATOM   1419  N   ASP   175      26.628  80.299  74.294  1.00 35.67          
ATOM   1420  CA  ASP   175      27.554  81.331  74.851  1.00 37.21          
ATOM   1421  C   ASP   175      26.879  82.176  75.943  1.00 36.14          
ATOM   1422  O   ASP   175      27.507  82.580  76.918  1.00 35.58          
ATOM   1423  CB  ASP   175      28.143  82.245  73.773  1.00 38.38          
ATOM   1424  CG  ASP   175      29.279  83.129  74.314  1.00 44.70          
ATOM   1425  OD1 ASP   175      30.366  82.564  74.644  1.00 49.80          
ATOM   1426  OD2 ASP   175      29.094  84.387  74.425  1.00 48.60          
ATOM   1427  N   THR   176      25.585  82.415  75.789  1.00 35.27          
ATOM   1428  CA  THR   176      24.882  83.205  76.754  1.00 35.40          
ATOM   1429  C   THR   176      24.768  82.411  78.053  1.00 35.65          
ATOM   1430  O   THR   176      25.034  82.936  79.136  1.00 35.72          
ATOM   1431  CB  THR   176      23.510  83.564  76.226  1.00 36.01          
ATOM   1432  OG1 THR   176      23.653  84.245  74.968  1.00 36.23          
ATOM   1433  CG2 THR   176      22.779  84.443  77.209  1.00 36.24          
ATOM   1434  N   ALA   177      24.408  81.135  77.945  1.00 34.29          
ATOM   1435  CA  ALA   177      24.355  80.297  79.127  1.00 33.58          
ATOM   1436  C   ALA   177      25.674  80.438  79.863  1.00 33.02          
ATOM   1437  O   ALA   177      25.669  80.730  81.033  1.00 33.97          
ATOM   1438  CB  ALA   177      24.076  78.848  78.778  1.00 31.83          
ATOM   1439  N   ARG   178      26.799  80.273  79.179  1.00 33.42          
ATOM   1440  CA  ARG   178      28.134  80.325  79.830  1.00 34.65          
ATOM   1441  C   ARG   178      28.415  81.645  80.542  1.00 34.04          
ATOM   1442  O   ARG   178      29.048  81.656  81.596  1.00 34.83          
ATOM   1443  CB  ARG   178      29.252  80.030  78.805  1.00 35.48          
ATOM   1444  CG  ARG   178      30.657  80.272  79.307  1.00 42.13          
ATOM   1445  CD  ARG   178      31.708  79.985  78.259  1.00 52.54          
ATOM   1446  NE  ARG   178      33.012  80.544  78.645  1.00 61.90          
ATOM   1447  CZ  ARG   178      33.348  81.845  78.583  1.00 65.37          
ATOM   1448  NH1 ARG   178      32.486  82.780  78.163  1.00 64.21          
ATOM   1449  NH2 ARG   178      34.562  82.226  78.961  1.00 66.87          
ATOM   1450  N   ASN   179      27.982  82.760  79.960  1.00 33.38          
ATOM   1451  CA  ASN   179      28.177  84.048  80.593  1.00 34.01          
ATOM   1452  C   ASN   179      27.398  84.153  81.920  1.00 33.84          
ATOM   1453  O   ASN   179      27.935  84.607  82.908  1.00 35.72          
ATOM   1454  CB  ASN   179      27.833  85.197  79.665  1.00 33.36          
ATOM   1455  CG  ASN   179      28.828  85.382  78.547  1.00 37.32          
ATOM   1456  OD1 ASN   179      30.026  85.050  78.652  1.00 37.85          
ATOM   1457  ND2 ASN   179      28.332  85.918  77.440  1.00 38.66          
ATOM   1458  N   PHE   180      26.146  83.717  81.952  1.00 33.49          
ATOM   1459  CA  PHE   180      25.408  83.617  83.182  1.00 32.38          
ATOM   1460  C   PHE   180      26.108  82.695  84.152  1.00 33.70          
ATOM   1461  O   PHE   180      26.207  83.002  85.334  1.00 33.37          
ATOM   1462  CB  PHE   180      24.027  83.053  82.908  1.00 31.91          
ATOM   1463  CG  PHE   180      23.066  84.092  82.432  1.00 31.48          
ATOM   1464  CD1 PHE   180      22.770  85.203  83.232  1.00 32.14          
ATOM   1465  CD2 PHE   180      22.529  84.022  81.202  1.00 26.73          
ATOM   1466  CE1 PHE   180      21.923  86.187  82.799  1.00 34.54          
ATOM   1467  CE2 PHE   180      21.644  85.036  80.764  1.00 31.39          
ATOM   1468  CZ  PHE   180      21.350  86.099  81.566  1.00 29.88          
ATOM   1469  N   SER   181      26.522  81.522  83.666  1.00 34.68          
ATOM   1470  CA  SER   181      27.215  80.570  84.524  1.00 35.67          
ATOM   1471  C   SER   181      28.416  81.250  85.211  1.00 35.74          
ATOM   1472  O   SER   181      28.569  81.100  86.414  1.00 36.52          
ATOM   1473  CB  SER   181      27.669  79.345  83.738  1.00 35.73          
ATOM   1474  OG  SER   181      28.551  78.609  84.547  1.00 34.10          
ATOM   1475  N   ASN   182      29.205  82.046  84.480  1.00 35.86          
ATOM   1476  CA  ASN   182      30.391  82.738  85.051  1.00 36.69          
ATOM   1477  C   ASN   182      29.987  83.863  86.021  1.00 38.32          
ATOM   1478  O   ASN   182      30.717  84.162  86.982  1.00 38.20          
ATOM   1479  CB  ASN   182      31.273  83.410  83.986  1.00 36.52          
ATOM   1480  CG  ASN   182      31.972  82.430  83.027  1.00 38.44          
ATOM   1481  OD1 ASN   182      32.539  82.847  81.993  1.00 37.99          
ATOM   1482  ND2 ASN   182      31.924  81.146  83.340  1.00 38.87          
ATOM   1483  N   ASP   183      28.852  84.511  85.751  1.00 39.08          
ATOM   1484  CA  ASP   183      28.392  85.639  86.557  1.00 39.96          
ATOM   1485  C   ASP   183      28.039  85.127  87.961  1.00 40.07          
ATOM   1486  O   ASP   183      28.444  85.696  89.000  1.00 39.11          
ATOM   1487  CB  ASP   183      27.150  86.262  85.908  1.00 40.86          
ATOM   1488  CG  ASP   183      27.493  87.238  84.783  1.00 45.25          
ATOM   1489  OD1 ASP   183      28.707  87.527  84.610  1.00 45.91          
ATOM   1490  OD2 ASP   183      26.539  87.731  84.082  1.00 48.29          
ATOM   1491  N   PHE   184      27.299  84.026  87.979  1.00 39.47          
ATOM   1492  CA  PHE   184      26.830  83.479  89.213  1.00 39.05          
ATOM   1493  C   PHE   184      27.918  82.736  89.942  1.00 38.90          
ATOM   1494  O   PHE   184      27.894  82.691  91.165  1.00 39.59          
ATOM   1495  CB  PHE   184      25.606  82.607  88.989  1.00 37.65          
ATOM   1496  CG  PHE   184      24.334  83.396  88.889  1.00 37.50          
ATOM   1497  CD1 PHE   184      23.638  83.762  90.038  1.00 36.68          
ATOM   1498  CD2 PHE   184      23.847  83.798  87.663  1.00 34.67          
ATOM   1499  CE1 PHE   184      22.459  84.505  89.960  1.00 38.45          
ATOM   1500  CE2 PHE   184      22.678  84.551  87.570  1.00 37.65          
ATOM   1501  CZ  PHE   184      21.966  84.885  88.714  1.00 38.28          
ATOM   1502  N   ASP   185      28.878  82.156  89.228  1.00 39.48          
ATOM   1503  CA  ASP   185      30.069  81.633  89.928  1.00 39.10          
ATOM   1504  C   ASP   185      30.528  82.759  90.798  1.00 39.43          
ATOM   1505  O   ASP   185      30.616  82.615  92.011  1.00 40.10          
ATOM   1506  CB  ASP   185      31.207  81.269  88.989  1.00 39.05          
ATOM   1507  CG  ASP   185      31.093  79.859  88.360  1.00 39.64          
ATOM   1508  OD1 ASP   185      30.115  79.131  88.621  1.00 37.88          
ATOM   1509  OD2 ASP   185      32.039  79.487  87.580  1.00 39.49          
ATOM   1510  N   GLU   186      30.774  83.905  90.168  1.00 39.75          
ATOM   1511  CA  GLU   186      31.296  85.114  90.811  1.00 40.52          
ATOM   1512  C   GLU   186      30.432  85.734  91.946  1.00 39.69          
ATOM   1513  O   GLU   186      30.945  86.148  92.961  1.00 38.66          
ATOM   1514  CB  GLU   186      31.510  86.168  89.741  1.00 41.03          
ATOM   1515  CG  GLU   186      32.791  86.940  89.926  1.00 47.44          
ATOM   1516  CD  GLU   186      32.787  88.269  89.173  1.00 52.24          
ATOM   1517  OE1 GLU   186      31.672  88.740  88.798  1.00 51.05          
ATOM   1518  OE2 GLU   186      33.910  88.808  88.951  1.00 51.48          
ATOM   1519  N   LEU   187      29.127  85.827  91.740  1.00 38.67          
ATOM   1520  CA  LEU   187      28.220  86.196  92.799  1.00 38.18          
ATOM   1521  C   LEU   187      28.222  85.220  93.996  1.00 38.61          
ATOM   1522  O   LEU   187      28.081  85.657  95.160  1.00 38.10          
ATOM   1523  CB  LEU   187      26.785  86.310  92.274  1.00 37.27          
ATOM   1524  CG  LEU   187      26.542  87.440  91.311  1.00 35.64          
ATOM   1525  CD1 LEU   187      25.082  87.438  91.017  1.00 32.83          
ATOM   1526  CD2 LEU   187      27.010  88.775  91.896  1.00 32.69          
ATOM   1527  N   MET   188      28.304  83.918  93.697  1.00 38.69          
ATOM   1528  CA  MET   188      28.411  82.890  94.730  1.00 38.71          
ATOM   1529  C   MET   188      29.705  83.062  95.510  1.00 39.32          
ATOM   1530  O   MET   188      29.726  82.902  96.737  1.00 39.80          
ATOM   1531  CB  MET   188      28.375  81.484  94.133  1.00 38.04          
ATOM   1532  CG  MET   188      28.173  80.339  95.144  1.00 40.86          
ATOM   1533  SD  MET   188      28.539  78.681  94.431  1.00 43.30          
ATOM   1534  CE  MET   188      30.320  78.859  94.404  1.00 46.35          
ATOM   1535  N   TYR   189      30.800  83.359  94.832  1.00 40.21          
ATOM   1536  CA  TYR   189      32.027  83.486  95.584  1.00 42.08          
ATOM   1537  C   TYR   189      32.004  84.764  96.421  1.00 41.58          
ATOM   1538  O   TYR   189      32.632  84.835  97.453  1.00 42.12          
ATOM   1539  CB  TYR   189      33.273  83.418  94.692  1.00 43.73          
ATOM   1540  CG  TYR   189      34.535  83.048  95.478  1.00 50.34          
ATOM   1541  CD1 TYR   189      34.632  83.301  96.860  1.00 54.83          
ATOM   1542  CD2 TYR   189      35.640  82.472  94.848  1.00 56.38          
ATOM   1543  CE1 TYR   189      35.775  82.978  97.583  1.00 57.35          
ATOM   1544  CE2 TYR   189      36.811  82.166  95.570  1.00 57.43          
ATOM   1545  CZ  TYR   189      36.862  82.423  96.928  1.00 59.03          
ATOM   1546  OH  TYR   189      38.007  82.124  97.631  1.00 61.19          
ATOM   1547  N   GLN   190      31.257  85.776  95.992  1.00 41.03          
ATOM   1548  CA  GLN   190      31.114  86.965  96.818  1.00 39.72          
ATOM   1549  C   GLN   190      30.346  86.605  98.085  1.00 39.37          
ATOM   1550  O   GLN   190      30.758  87.010  99.186  1.00 37.96          
ATOM   1551  CB  GLN   190      30.447  88.108  96.050  1.00 39.72          
ATOM   1552  CG  GLN   190      31.440  88.905  95.231  1.00 38.26          
ATOM   1553  CD  GLN   190      30.804  90.034  94.437  1.00 39.05          
ATOM   1554  OE1 GLN   190      31.490  90.928  93.947  1.00 41.43          
ATOM   1555  NE2 GLN   190      29.514  89.984  94.285  1.00 35.26          
ATOM   1556  N   ALA   191      29.270  85.815  97.938  1.00 38.03          
ATOM   1557  CA  ALA   191      28.482  85.386  99.104  1.00 38.87          
ATOM   1558  C   ALA   191      29.259  84.510 100.092  1.00 39.85          
ATOM   1559  O   ALA   191      29.055  84.588 101.282  1.00 38.77          
ATOM   1560  CB  ALA   191      27.154  84.683  98.689  1.00 38.51          
ATOM   1561  N   ILE   192      30.130  83.643  99.582  1.00 41.25          
ATOM   1562  CA  ILE   192      30.892  82.790 100.436  1.00 42.32          
ATOM   1563  C   ILE   192      31.748  83.678 101.322  1.00 42.19          
ATOM   1564  O   ILE   192      31.715  83.531 102.519  1.00 42.64          
ATOM   1565  CB  ILE   192      31.745  81.801  99.599  1.00 42.95          
ATOM   1566  CG1 ILE   192      30.828  80.762  98.944  1.00 45.21          
ATOM   1567  CG2 ILE   192      32.849  81.156 100.453  1.00 43.92          
ATOM   1568  CD  ILE   192      31.441  80.074  97.686  1.00 47.75          
ATOM   1569  N   ASP   193      32.516  84.587 100.737  1.00 42.40          
ATOM   1570  CA  ASP   193      33.291  85.540 101.509  1.00 42.90          
ATOM   1571  C   ASP   193      32.439  86.336 102.529  1.00 42.89          
ATOM   1572  O   ASP   193      32.834  86.490 103.699  1.00 40.18          
ATOM   1573  CB  ASP   193      34.045  86.471 100.568  1.00 43.55          
ATOM   1574  CG  ASP   193      35.323  85.810  99.974  1.00 47.26          
ATOM   1575  OD1 ASP   193      35.827  84.796 100.551  1.00 46.34          
ATOM   1576  OD2 ASP   193      35.809  86.312  98.929  1.00 48.52          
ATOM   1577  N   LEU   194      31.263  86.808 102.087  1.00 42.95          
ATOM   1578  CA  LEU   194      30.400  87.599 102.938  1.00 44.09          
ATOM   1579  C   LEU   194      30.038  86.730 104.110  1.00 44.61          
ATOM   1580  O   LEU   194      30.001  87.189 105.239  1.00 44.64          
ATOM   1581  CB  LEU   194      29.124  88.052 102.209  1.00 44.93          
ATOM   1582  CG  LEU   194      28.760  89.536 102.010  1.00 45.93          
ATOM   1583  CD1 LEU   194      27.233  89.759 102.174  1.00 47.95          
ATOM   1584  CD2 LEU   194      29.490  90.453 102.934  1.00 46.58          
ATOM   1585  N   GLU   195      29.816  85.451 103.842  1.00 45.17          
ATOM   1586  CA  GLU   195      29.312  84.527 104.837  1.00 45.91          
ATOM   1587  C   GLU   195      30.390  84.206 105.872  1.00 45.81          
ATOM   1588  O   GLU   195      30.115  84.066 107.071  1.00 46.65          
ATOM   1589  CB  GLU   195      28.876  83.265 104.127  1.00 46.65          
ATOM   1590  CG  GLU   195      27.681  82.589 104.714  1.00 50.58          
ATOM   1591  CD  GLU   195      28.028  81.275 105.326  1.00 58.14          
ATOM   1592  OE1 GLU   195      27.366  80.266 104.927  1.00 61.46          
ATOM   1593  OE2 GLU   195      28.966  81.260 106.179  1.00 59.12          
ATOM   1594  N   SER   196      31.622  84.096 105.398  1.00 44.54          
ATOM   1595  CA  SER   196      32.757  83.845 106.257  1.00 43.80          
ATOM   1596  C   SER   196      33.031  85.050 107.134  1.00 43.45          
ATOM   1597  O   SER   196      33.396  84.893 108.286  1.00 43.53          
ATOM   1598  CB  SER   196      33.964  83.507 105.405  1.00 43.50          
ATOM   1599  OG  SER   196      33.720  82.225 104.808  1.00 45.94          
ATOM   1600  N   MET   197      32.843  86.254 106.579  1.00 42.56          
ATOM   1601  CA  MET   197      33.071  87.479 107.312  1.00 41.22          
ATOM   1602  C   MET   197      31.934  87.793 108.266  1.00 42.25          
ATOM   1603  O   MET   197      31.901  88.889 108.857  1.00 43.38          
ATOM   1604  CB  MET   197      33.302  88.675 106.384  1.00 40.11          
ATOM   1605  CG  MET   197      34.582  88.638 105.607  1.00 34.85          
ATOM   1606  SD  MET   197      34.623  90.017 104.472  1.00 33.66          
ATOM   1607  CE  MET   197      36.086  89.700 103.497  1.00 37.50          
ATOM   1608  N   LYS   198      31.004  86.872 108.450  1.00 42.69          
ATOM   1609  CA  LYS   198      29.882  87.223 109.310  1.00 44.75          
ATOM   1610  C   LYS   198      30.295  86.867 110.743  1.00 45.33          
ATOM   1611  O   LYS   198      31.259  86.109 110.920  1.00 46.91          
ATOM   1612  CB  LYS   198      28.596  86.537 108.863  1.00 44.58          
ATOM   1613  CG  LYS   198      28.355  85.235 109.548  1.00 46.60          
ATOM   1614  CD  LYS   198      27.299  84.427 108.822  1.00 50.04          
ATOM   1615  CE  LYS   198      27.039  83.088 109.531  1.00 51.74          
ATOM   1616  NZ  LYS   198      25.586  82.727 109.360  1.00 55.90          
ATOM   1617  N   PRO   199      29.636  87.440 111.773  1.00 45.22          
ATOM   1618  CA  PRO   199      28.523  88.394 111.778  1.00 44.46          
ATOM   1619  C   PRO   199      28.969  89.850 111.553  1.00 43.69          
ATOM   1620  O   PRO   199      28.141  90.729 111.346  1.00 42.99          
ATOM   1621  CB  PRO   199      27.918  88.220 113.176  1.00 44.79          
ATOM   1622  CG  PRO   199      29.061  87.740 114.053  1.00 44.85          
ATOM   1623  CD  PRO   199      30.051  87.044 113.144  1.00 45.32          
ATOM   1624  N   GLN   200      30.271  90.092 111.563  1.00 42.76          
ATOM   1625  CA  GLN   200      30.782  91.399 111.243  1.00 42.96          
ATOM   1626  C   GLN   200      30.254  91.988 109.917  1.00 43.43          
ATOM   1627  O   GLN   200      30.135  93.202 109.777  1.00 44.10          
ATOM   1628  CB  GLN   200      32.307  91.348 111.162  1.00 42.74          
ATOM   1629  CG  GLN   200      33.016  91.223 112.501  1.00 43.69          
ATOM   1630  CD  GLN   200      32.928  89.821 113.123  1.00 44.22          
ATOM   1631  OE1 GLN   200      32.724  88.786 112.442  1.00 39.34          
ATOM   1632  NE2 GLN   200      33.072  89.793 114.433  1.00 42.79          
ATOM   1633  N   SER   201      29.995  91.148 108.915  1.00 42.82          
ATOM   1634  CA  SER   201      29.673  91.659 107.592  1.00 41.89          
ATOM   1635  C   SER   201      28.192  91.947 107.499  1.00 41.94          
ATOM   1636  O   SER   201      27.722  92.536 106.518  1.00 42.01          
ATOM   1637  CB  SER   201      30.054  90.621 106.518  1.00 40.83          
ATOM   1638  OG  SER   201      29.329  89.426 106.763  1.00 38.85          
ATOM   1639  N   GLN   202      27.441  91.482 108.493  1.00 41.86          
ATOM   1640  CA  GLN   202      25.974  91.594 108.455  1.00 40.97          
ATOM   1641  C   GLN   202      25.465  92.995 108.846  1.00 40.82          
ATOM   1642  O   GLN   202      24.464  93.132 109.579  1.00 40.14          
ATOM   1643  CB  GLN   202      25.353  90.491 109.300  1.00 40.56          
ATOM   1644  CG  GLN   202      25.626  89.134 108.715  1.00 41.93          
ATOM   1645  CD  GLN   202      25.092  87.989 109.533  1.00 44.61          
ATOM   1646  OE1 GLN   202      25.626  87.665 110.603  1.00 48.41          
ATOM   1647  NE2 GLN   202      24.049  87.341 109.023  1.00 45.84          
ATOM   1648  N   THR   203      26.165  94.026 108.353  1.00 39.98          
ATOM   1649  CA  THR   203      25.714  95.415 108.489  1.00 39.52          
ATOM   1650  C   THR   203      24.626  95.644 107.443  1.00 40.21          
ATOM   1651  O   THR   203      24.617  94.993 106.403  1.00 40.13          
ATOM   1652  CB  THR   203      26.867  96.451 108.235  1.00 39.00          
ATOM   1653  OG1 THR   203      27.205  96.448 106.850  1.00 37.48          
ATOM   1654  CG2 THR   203      28.161  96.167 109.068  1.00 37.03          
ATOM   1655  N   ALA   204      23.718  96.582 107.692  1.00 40.85          
ATOM   1656  CA  ALA   204      22.635  96.852 106.745  1.00 41.10          
ATOM   1657  C   ALA   204      23.168  97.409 105.415  1.00 41.43          
ATOM   1658  O   ALA   204      22.655  97.064 104.360  1.00 41.76          
ATOM   1659  CB  ALA   204      21.582  97.817 107.365  1.00 41.70          
ATOM   1660  N   PRO   205      24.229  98.247 105.450  1.00 41.26          
ATOM   1661  CA  PRO   205      24.731  98.722 104.174  1.00 40.41          
ATOM   1662  C   PRO   205      25.357  97.631 103.299  1.00 40.56          
ATOM   1663  O   PRO   205      25.117  97.618 102.108  1.00 40.50          
ATOM   1664  CB  PRO   205      25.764  99.785 104.574  1.00 40.10          
ATOM   1665  CG  PRO   205      25.387 100.206 105.921  1.00 40.88          
ATOM   1666  CD  PRO   205      24.878  98.944 106.578  1.00 41.51          
ATOM   1667  N   LEU   206      26.152  96.729 103.879  1.00 41.41          
ATOM   1668  CA  LEU   206      26.737  95.575 103.133  1.00 41.70          
ATOM   1669  C   LEU   206      25.703  94.558 102.607  1.00 41.64          
ATOM   1670  O   LEU   206      25.826  94.098 101.492  1.00 41.73          
ATOM   1671  CB  LEU   206      27.829  94.876 103.950  1.00 40.89          
ATOM   1672  CG  LEU   206      29.070  95.728 104.212  1.00 39.91          
ATOM   1673  CD1 LEU   206      29.808  95.204 105.398  1.00 41.05          
ATOM   1674  CD2 LEU   206      29.968  95.730 102.993  1.00 36.85          
ATOM   1675  N   LEU   207      24.682  94.232 103.388  1.00 41.93          
ATOM   1676  CA  LEU   207      23.592  93.347 102.908  1.00 42.74          
ATOM   1677  C   LEU   207      22.698  93.972 101.857  1.00 42.61          
ATOM   1678  O   LEU   207      22.098  93.285 101.048  1.00 43.65          
ATOM   1679  CB  LEU   207      22.687  92.897 104.068  1.00 41.87          
ATOM   1680  CG  LEU   207      23.329  92.043 105.173  1.00 43.67          
ATOM   1681  CD1 LEU   207      22.325  91.807 106.294  1.00 44.14          
ATOM   1682  CD2 LEU   207      23.867  90.725 104.655  1.00 41.85          
ATOM   1683  N   ASP   208      22.543  95.282 101.928  1.00 42.93          
ATOM   1684  CA  ASP   208      21.744  96.013 100.972  1.00 42.43          
ATOM   1685  C   ASP   208      22.455  96.022  99.607  1.00 41.44          
ATOM   1686  O   ASP   208      21.831  95.755  98.579  1.00 40.32          
ATOM   1687  CB  ASP   208      21.519  97.426 101.535  1.00 43.87          
ATOM   1688  CG  ASP   208      20.793  98.337 100.588  1.00 48.46          
ATOM   1689  OD1 ASP   208      19.835  97.877  99.921  1.00 56.34          
ATOM   1690  OD2 ASP   208      21.166  99.531 100.529  1.00 51.53          
ATOM   1691  N   GLN   209      23.767  96.295  99.597  1.00 39.64          
ATOM   1692  CA  GLN   209      24.554  96.215  98.369  1.00 39.07          
ATOM   1693  C   GLN   209      24.641  94.780  97.780  1.00 38.76          
ATOM   1694  O   GLN   209      24.442  94.560  96.587  1.00 38.96          
ATOM   1695  CB  GLN   209      25.951  96.794  98.597  1.00 39.16          
ATOM   1696  CG  GLN   209      26.901  96.581  97.408  1.00 40.28          
ATOM   1697  CD  GLN   209      26.650  97.517  96.211  1.00 41.28          
ATOM   1698  OE1 GLN   209      27.319  97.410  95.163  1.00 44.18          
ATOM   1699  NE2 GLN   209      25.720  98.446  96.368  1.00 40.87          
ATOM   1700  N   PHE   210      24.945  93.811  98.625  1.00 38.71          
ATOM   1701  CA  PHE   210      24.846  92.381  98.297  1.00 38.52          
ATOM   1702  C   PHE   210      23.564  92.063  97.517  1.00 38.81          
ATOM   1703  O   PHE   210      23.640  91.587  96.385  1.00 38.68          
ATOM   1704  CB  PHE   210      24.838  91.606  99.606  1.00 38.49          
ATOM   1705  CG  PHE   210      24.846  90.132  99.458  1.00 40.01          
ATOM   1706  CD1 PHE   210      25.834  89.497  98.704  1.00 42.66          
ATOM   1707  CD2 PHE   210      23.922  89.358 100.144  1.00 39.68          
ATOM   1708  CE1 PHE   210      25.889  88.111  98.619  1.00 43.83          
ATOM   1709  CE2 PHE   210      23.956  87.957 100.060  1.00 40.76          
ATOM   1710  CZ  PHE   210      24.938  87.333  99.311  1.00 43.95          
ATOM   1711  N   LEU   211      22.402  92.300  98.126  1.00 38.08          
ATOM   1712  CA  LEU   211      21.130  91.975  97.480  1.00 39.54          
ATOM   1713  C   LEU   211      20.966  92.718  96.183  1.00 40.24          
ATOM   1714  O   LEU   211      20.451  92.191  95.207  1.00 41.15          
ATOM   1715  CB  LEU   211      19.933  92.291  98.385  1.00 38.28          
ATOM   1716  CG  LEU   211      19.678  91.405  99.603  1.00 39.40          
ATOM   1717  CD1 LEU   211      18.552  91.999 100.467  1.00 37.65          
ATOM   1718  CD2 LEU   211      19.371  89.924  99.210  1.00 33.77          
ATOM   1719  N   ASP   212      21.381  93.966  96.188  1.00 41.98          
ATOM   1720  CA  ASP   212      21.302  94.826  95.030  1.00 43.93          
ATOM   1721  C   ASP   212      21.989  94.250  93.780  1.00 44.11          
ATOM   1722  O   ASP   212      21.370  94.102  92.689  1.00 44.18          
ATOM   1723  CB  ASP   212      21.975  96.137  95.402  1.00 44.85          
ATOM   1724  CG  ASP   212      21.044  97.290  95.323  1.00 51.67          
ATOM   1725  OD1 ASP   212      21.358  98.184  94.492  1.00 57.38          
ATOM   1726  OD2 ASP   212      19.987  97.277  96.045  1.00 57.78          
ATOM   1727  N   GLN   213      23.285  93.989  93.937  1.00 43.77          
ATOM   1728  CA  GLN   213      24.069  93.259  92.970  1.00 44.34          
ATOM   1729  C   GLN   213      23.451  91.904  92.628  1.00 43.88          
ATOM   1730  O   GLN   213      23.334  91.550  91.476  1.00 44.90          
ATOM   1731  CB  GLN   213      25.482  93.011  93.520  1.00 44.63          
ATOM   1732  CG  GLN   213      26.448  94.129  93.295  1.00 46.85          
ATOM   1733  CD  GLN   213      27.905  93.650  93.403  1.00 50.14          
ATOM   1734  OE1 GLN   213      28.144  92.530  93.846  1.00 51.58          
ATOM   1735  NE2 GLN   213      28.871  94.486  92.982  1.00 45.46          
ATOM   1736  N   ASN   214      23.079  91.126  93.625  1.00 43.26          
ATOM   1737  CA  ASN   214      22.420  89.868  93.339  1.00 42.90          
ATOM   1738  C   ASN   214      21.183  90.029  92.438  1.00 42.62          
ATOM   1739  O   ASN   214      21.000  89.232  91.515  1.00 42.68          
ATOM   1740  CB  ASN   214      22.107  89.103  94.636  1.00 41.79          
ATOM   1741  CG  ASN   214      23.366  88.768  95.412  1.00 44.58          
ATOM   1742  OD1 ASN   214      24.466  89.141  95.003  1.00 44.53          
ATOM   1743  ND2 ASN   214      23.222  88.057  96.528  1.00 45.55          
ATOM   1744  N   ARG   215      20.366  91.067  92.680  1.00 42.19          
ATOM   1745  CA  ARG   215      19.087  91.214  91.970  1.00 41.92          
ATOM   1746  C   ARG   215      19.185  91.354  90.471  1.00 42.27          
ATOM   1747  O   ARG   215      18.322  90.856  89.728  1.00 42.91          
ATOM   1748  CB  ARG   215      18.279  92.388  92.478  1.00 41.19          
ATOM   1749  CG  ARG   215      16.826  92.135  92.146  1.00 42.40          
ATOM   1750  CD  ARG   215      16.091  93.324  91.658  1.00 40.50          
ATOM   1751  NE  ARG   215      14.664  93.036  91.713  1.00 38.86          
ATOM   1752  CZ  ARG   215      13.852  92.992  90.656  1.00 39.64          
ATOM   1753  NH1 ARG   215      14.306  93.251  89.428  1.00 40.37          
ATOM   1754  NH2 ARG   215      12.568  92.699  90.822  1.00 39.37          
ATOM   1755  N   VAL   216      20.190  92.097  90.007  1.00 42.32          
ATOM   1756  CA  VAL   216      20.267  92.382  88.572  1.00 42.34          
ATOM   1757  C   VAL   216      20.579  91.100  87.795  1.00 41.17          
ATOM   1758  O   VAL   216      20.035  90.873  86.737  1.00 39.92          
ATOM   1759  CB  VAL   216      21.248  93.574  88.213  1.00 42.59          
ATOM   1760  CG1 VAL   216      21.239  94.647  89.302  1.00 43.45          
ATOM   1761  CG2 VAL   216      22.639  93.097  87.993  1.00 44.41          
ATOM   1762  N   SER   217      21.478  90.270  88.332  1.00 40.80          
ATOM   1763  CA  SER   217      21.784  89.003  87.692  1.00 39.83          
ATOM   1764  C   SER   217      20.601  88.011  87.741  1.00 38.66          
ATOM   1765  O   SER   217      20.314  87.355  86.748  1.00 38.34          
ATOM   1766  CB  SER   217      23.049  88.400  88.294  1.00 41.19          
ATOM   1767  OG  SER   217      24.196  89.130  87.899  1.00 40.44          
ATOM   1768  N   VAL   218      19.913  87.931  88.876  1.00 36.55          
ATOM   1769  CA  VAL   218      18.756  87.056  89.024  1.00 36.35          
ATOM   1770  C   VAL   218      17.567  87.403  88.119  1.00 36.19          
ATOM   1771  O   VAL   218      17.027  86.525  87.441  1.00 36.51          
ATOM   1772  CB  VAL   218      18.261  87.011  90.494  1.00 37.04          
ATOM   1773  CG1 VAL   218      17.085  86.065  90.603  1.00 35.61          
ATOM   1774  CG2 VAL   218      19.379  86.565  91.408  1.00 33.79          
ATOM   1775  N   ALA   219      17.165  88.668  88.094  1.00 36.12          
ATOM   1776  CA  ALA   219      16.103  89.111  87.185  1.00 36.91          
ATOM   1777  C   ALA   219      16.550  88.794  85.750  1.00 37.54          
ATOM   1778  O   ALA   219      15.751  88.341  84.899  1.00 38.19          
ATOM   1779  CB  ALA   219      15.857  90.617  87.328  1.00 35.74          
ATOM   1780  N   SER   220      17.824  89.022  85.455  1.00 36.13          
ATOM   1781  CA  SER   220      18.248  88.754  84.101  1.00 37.00          
ATOM   1782  C   SER   220      18.247  87.235  83.745  1.00 36.84          
ATOM   1783  O   SER   220      17.787  86.859  82.664  1.00 35.71          
ATOM   1784  CB  SER   220      19.593  89.393  83.866  1.00 37.73          
ATOM   1785  OG  SER   220      19.716  89.763  82.513  1.00 43.51          
ATOM   1786  N   LEU   221      18.748  86.362  84.633  1.00 36.19          
ATOM   1787  CA  LEU   221      18.682  84.918  84.356  1.00 36.50          
ATOM   1788  C   LEU   221      17.226  84.460  84.271  1.00 36.18          
ATOM   1789  O   LEU   221      16.877  83.640  83.459  1.00 36.56          
ATOM   1790  CB  LEU   221      19.378  84.105  85.427  1.00 35.80          
ATOM   1791  CG  LEU   221      19.650  82.623  85.175  1.00 36.70          
ATOM   1792  CD1 LEU   221      20.152  82.296  83.761  1.00 33.08          
ATOM   1793  CD2 LEU   221      20.654  82.046  86.242  1.00 38.20          
ATOM   1794  N   ARG   222      16.399  84.990  85.142  1.00 36.66          
ATOM   1795  CA  ARG   222      14.970  84.670  85.176  1.00 37.31          
ATOM   1796  C   ARG   222      14.361  84.915  83.822  1.00 36.40          
ATOM   1797  O   ARG   222      13.642  84.085  83.290  1.00 35.54          
ATOM   1798  CB  ARG   222      14.270  85.559  86.203  1.00 36.68          
ATOM   1799  CG  ARG   222      13.098  84.895  86.843  1.00 40.32          
ATOM   1800  CD  ARG   222      11.966  85.855  87.103  1.00 43.39          
ATOM   1801  NE  ARG   222      11.553  86.421  85.838  1.00 50.01          
ATOM   1802  CZ  ARG   222      10.304  86.755  85.531  1.00 54.00          
ATOM   1803  NH1 ARG   222      10.034  87.282  84.325  1.00 54.78          
ATOM   1804  NH2 ARG   222       9.331  86.545  86.420  1.00 52.33          
ATOM   1805  N   ASP   223      14.686  86.074  83.263  1.00 37.24          
ATOM   1806  CA  ASP   223      14.191  86.476  81.949  1.00 37.39          
ATOM   1807  C   ASP   223      14.747  85.575  80.845  1.00 36.07          
ATOM   1808  O   ASP   223      14.025  85.213  79.913  1.00 34.91          
ATOM   1809  CB  ASP   223      14.573  87.923  81.645  1.00 38.92          
ATOM   1810  CG  ASP   223      13.808  88.948  82.501  1.00 43.63          
ATOM   1811  OD1 ASP   223      13.358  88.628  83.633  1.00 49.75          
ATOM   1812  OD2 ASP   223      13.700  90.113  82.046  1.00 49.26          
ATOM   1813  N   PHE   224      16.027  85.216  80.957  1.00 34.55          
ATOM   1814  CA  PHE   224      16.663  84.349  79.969  1.00 33.87          
ATOM   1815  C   PHE   224      15.997  82.996  80.002  1.00 33.67          
ATOM   1816  O   PHE   224      15.683  82.430  78.970  1.00 33.74          
ATOM   1817  CB  PHE   224      18.145  84.181  80.254  1.00 33.22          
ATOM   1818  CG  PHE   224      18.840  83.207  79.331  1.00 35.65          
ATOM   1819  CD1 PHE   224      18.970  83.492  77.962  1.00 35.80          
ATOM   1820  CD2 PHE   224      19.406  82.023  79.822  1.00 35.74          
ATOM   1821  CE1 PHE   224      19.634  82.604  77.109  1.00 36.62          
ATOM   1822  CE2 PHE   224      20.072  81.125  78.975  1.00 33.30          
ATOM   1823  CZ  PHE   224      20.180  81.403  77.627  1.00 35.41          
ATOM   1824  N   LYS   225      15.759  82.481  81.202  1.00 33.54          
ATOM   1825  CA  LYS   225      15.122  81.183  81.371  1.00 33.48          
ATOM   1826  C   LYS   225      13.673  81.193  80.875  1.00 34.42          
ATOM   1827  O   LYS   225      13.233  80.215  80.321  1.00 34.79          
ATOM   1828  CB  LYS   225      15.119  80.779  82.837  1.00 33.04          
ATOM   1829  CG  LYS   225      16.318  80.021  83.345  1.00 32.74          
ATOM   1830  CD  LYS   225      16.351  80.129  84.876  1.00 30.25          
ATOM   1831  CE  LYS   225      17.541  79.454  85.510  1.00 30.52          
ATOM   1832  NZ  LYS   225      17.311  79.305  87.011  1.00 25.84          
ATOM   1833  N   LYS   226      12.917  82.260  81.106  1.00 36.01          
ATOM   1834  CA  LYS   226      11.543  82.359  80.542  1.00 38.40          
ATOM   1835  C   LYS   226      11.597  82.375  79.010  1.00 38.75          
ATOM   1836  O   LYS   226      10.764  81.783  78.317  1.00 38.71          
ATOM   1837  CB  LYS   226      10.869  83.655  80.996  1.00 38.65          
ATOM   1838  CG  LYS   226       9.328  83.634  80.965  1.00 43.13          
ATOM   1839  CD  LYS   226       8.767  85.054  80.759  1.00 49.39          
ATOM   1840  CE  LYS   226       7.753  85.451  81.834  1.00 54.15          
ATOM   1841  NZ  LYS   226       6.413  84.774  81.680  1.00 59.22          
ATOM   1842  N   THR   227      12.568  83.097  78.468  1.00 38.37          
ATOM   1843  CA  THR   227      12.669  83.165  77.022  1.00 38.59          
ATOM   1844  C   THR   227      13.017  81.792  76.423  1.00 38.06          
ATOM   1845  O   THR   227      12.423  81.352  75.443  1.00 38.51          
ATOM   1846  CB  THR   227      13.710  84.196  76.631  1.00 38.17          
ATOM   1847  OG1 THR   227      13.214  85.507  76.965  1.00 39.62          
ATOM   1848  CG2 THR   227      14.027  84.093  75.150  1.00 39.87          
ATOM   1849  N   ALA   228      13.969  81.105  77.029  1.00 37.72          
ATOM   1850  CA  ALA   228      14.377  79.801  76.541  1.00 37.08          
ATOM   1851  C   ALA   228      13.260  78.807  76.733  1.00 36.48          
ATOM   1852  O   ALA   228      13.060  77.955  75.898  1.00 37.31          
ATOM   1853  CB  ALA   228      15.611  79.323  77.259  1.00 36.66          
ATOM   1854  N   ARG   229      12.597  78.844  77.874  1.00 35.79          
ATOM   1855  CA  ARG   229      11.417  78.037  78.035  1.00 36.32          
ATOM   1856  C   ARG   229      10.511  78.212  76.824  1.00 36.55          
ATOM   1857  O   ARG   229      10.219  77.228  76.171  1.00 38.02          
ATOM   1858  CB  ARG   229      10.622  78.377  79.308  1.00 35.97          
ATOM   1859  CG  ARG   229       9.277  77.583  79.390  1.00 35.71          
ATOM   1860  CD  ARG   229       8.416  78.165  80.501  1.00 34.61          
ATOM   1861  NE  ARG   229       7.878  79.459  80.089  1.00 36.34          
ATOM   1862  CZ  ARG   229       7.177  80.252  80.897  1.00 40.12          
ATOM   1863  NH1 ARG   229       6.729  81.406  80.451  1.00 38.47          
ATOM   1864  NH2 ARG   229       6.934  79.895  82.165  1.00 38.47          
ATOM   1865  N   ASP   230      10.061  79.437  76.535  1.00 36.04          
ATOM   1866  CA  ASP   230       9.160  79.700  75.409  1.00 36.95          
ATOM   1867  C   ASP   230       9.704  79.263  74.038  1.00 36.45          
ATOM   1868  O   ASP   230       8.960  78.753  73.187  1.00 35.99          
ATOM   1869  CB  ASP   230       8.792  81.182  75.346  1.00 37.70          
ATOM   1870  CG  ASP   230       7.985  81.662  76.575  1.00 41.70          
ATOM   1871  OD1 ASP   230       7.513  80.817  77.400  1.00 42.03          
ATOM   1872  OD2 ASP   230       7.855  82.928  76.714  1.00 48.38          
ATOM   1873  N   LEU   231      11.003  79.428  73.810  1.00 36.24          
ATOM   1874  CA  LEU   231      11.596  78.933  72.561  1.00 36.02          
ATOM   1875  C   LEU   231      11.598  77.408  72.455  1.00 35.72          
ATOM   1876  O   LEU   231      11.459  76.864  71.362  1.00 34.65          
ATOM   1877  CB  LEU   231      12.995  79.471  72.362  1.00 36.62          
ATOM   1878  CG  LEU   231      13.191  80.988  72.301  1.00 38.53          
ATOM   1879  CD1 LEU   231      14.708  81.288  72.295  1.00 36.72          
ATOM   1880  CD2 LEU   231      12.489  81.612  71.103  1.00 36.13          
ATOM   1881  N   ILE   232      11.736  76.708  73.573  1.00 35.63          
ATOM   1882  CA  ILE   232      11.661  75.235  73.529  1.00 37.41          
ATOM   1883  C   ILE   232      10.215  74.730  73.294  1.00 38.45          
ATOM   1884  O   ILE   232      10.002  73.795  72.514  1.00 39.03          
ATOM   1885  CB  ILE   232      12.247  74.603  74.804  1.00 37.23          
ATOM   1886  CG1 ILE   232      13.686  75.060  74.983  1.00 37.75          
ATOM   1887  CG2 ILE   232      12.202  73.077  74.734  1.00 36.36          
ATOM   1888  CD  ILE   232      14.162  74.877  76.363  1.00 39.09          
ATOM   1889  N   GLU   233       9.234  75.365  73.938  1.00 39.33          
ATOM   1890  CA  GLU   233       7.824  74.950  73.802  1.00 40.84          
ATOM   1891  C   GLU   233       7.370  75.097  72.376  1.00 41.56          
ATOM   1892  O   GLU   233       6.665  74.260  71.872  1.00 42.64          
ATOM   1893  CB  GLU   233       6.920  75.757  74.707  1.00 40.06          
ATOM   1894  CG  GLU   233       7.103  75.400  76.164  1.00 42.72          
ATOM   1895  CD  GLU   233       6.342  76.328  77.126  1.00 47.16          
ATOM   1896  OE1 GLU   233       5.861  77.425  76.683  1.00 49.88          
ATOM   1897  OE2 GLU   233       6.225  75.935  78.324  1.00 45.09          
ATOM   1898  N   GLN   234       7.838  76.158  71.737  1.00 42.77          
ATOM   1899  CA  GLN   234       7.617  76.478  70.338  1.00 42.86          
ATOM   1900  C   GLN   234       8.485  75.704  69.315  1.00 43.01          
ATOM   1901  O   GLN   234       8.212  75.749  68.120  1.00 42.42          
ATOM   1902  CB  GLN   234       7.800  77.995  70.154  1.00 43.01          
ATOM   1903  CG  GLN   234       6.906  78.790  71.046  1.00 45.96          
ATOM   1904  CD  GLN   234       6.790  80.256  70.647  1.00 50.65          
ATOM   1905  OE1 GLN   234       5.800  80.655  70.022  1.00 55.81          
ATOM   1906  NE2 GLN   234       7.779  81.066  71.014  1.00 47.86          
ATOM   1907  N   CYS   235       9.533  75.016  69.774  1.00 43.89          
ATOM   1908  CA  CYS   235      10.357  74.209  68.884  1.00 44.43          
ATOM   1909  C   CYS   235      11.249  75.073  68.019  1.00 42.74          
ATOM   1910  O   CYS   235      11.472  74.759  66.837  1.00 41.08          
ATOM   1911  CB  CYS   235       9.455  73.438  67.956  1.00 45.55          
ATOM   1912  SG  CYS   235       8.636  72.171  68.876  1.00 57.19          
ATOM   1913  N   LYS   236      11.702  76.168  68.616  1.00 40.52          
ATOM   1914  CA  LYS   236      12.418  77.194  67.927  1.00 39.58          
ATOM   1915  C   LYS   236      13.927  77.061  68.121  1.00 38.78          
ATOM   1916  O   LYS   236      14.691  77.509  67.297  1.00 39.58          
ATOM   1917  CB  LYS   236      11.908  78.568  68.356  1.00 39.26          
ATOM   1918  CG  LYS   236      10.668  79.003  67.637  1.00 39.13          
ATOM   1919  CD  LYS   236      10.315  80.413  67.990  1.00 41.11          
ATOM   1920  CE  LYS   236       9.434  81.012  66.895  1.00 43.44          
ATOM   1921  NZ  LYS   236       9.027  82.408  67.261  1.00 45.36          
ATOM   1922  N   ILE   237      14.361  76.416  69.175  1.00 38.02          
ATOM   1923  CA  ILE   237      15.791  76.094  69.295  1.00 38.03          
ATOM   1924  C   ILE   237      16.067  74.575  69.384  1.00 38.18          
ATOM   1925  O   ILE   237      15.137  73.766  69.506  1.00 38.27          
ATOM   1926  CB  ILE   237      16.438  76.805  70.478  1.00 37.23          
ATOM   1927  CG1 ILE   237      15.857  76.263  71.785  1.00 36.56          
ATOM   1928  CG2 ILE   237      16.256  78.324  70.351  1.00 37.08          
ATOM   1929  CD  ILE   237      16.588  76.838  73.015  1.00 31.73          
ATOM   1930  N   LYS   238      17.351  74.214  69.360  1.00 37.31          
ATOM   1931  CA  LYS   238      17.737  72.841  69.342  1.00 36.14          
ATOM   1932  C   LYS   238      18.390  72.501  70.636  1.00 36.38          
ATOM   1933  O   LYS   238      19.359  73.140  71.085  1.00 38.42          
ATOM   1934  CB  LYS   238      18.669  72.568  68.170  1.00 37.03          
ATOM   1935  CG  LYS   238      18.035  72.927  66.829  1.00 35.45          
ATOM   1936  CD  LYS   238      18.831  72.414  65.696  1.00 35.38          
ATOM   1937  CE  LYS   238      19.460  73.518  64.928  1.00 37.62          
ATOM   1938  NZ  LYS   238      20.472  74.077  65.782  1.00 40.96          
ATOM   1939  N   SER   239      17.865  71.467  71.249  1.00 34.86          
ATOM   1940  CA  SER   239      18.331  71.074  72.532  1.00 34.29          
ATOM   1941  C   SER   239      17.754  69.722  72.877  1.00 34.16          
ATOM   1942  O   SER   239      16.826  69.199  72.206  1.00 32.93          
ATOM   1943  CB  SER   239      17.850  72.108  73.591  1.00 35.56          
ATOM   1944  OG  SER   239      16.481  71.929  73.976  1.00 32.41          
ATOM   1945  N   ILE   240      18.269  69.194  73.979  1.00 34.06          
ATOM   1946  CA  ILE   240      17.652  68.049  74.651  1.00 33.92          
ATOM   1947  C   ILE   240      17.099  68.467  76.004  1.00 34.86          
ATOM   1948  O   ILE   240      17.135  67.681  76.955  1.00 36.49          
ATOM   1949  CB  ILE   240      18.656  66.872  74.847  1.00 33.25          
ATOM   1950  CG1 ILE   240      19.912  67.343  75.547  1.00 31.26          
ATOM   1951  CG2 ILE   240      19.095  66.301  73.535  1.00 30.82          
ATOM   1952  CD  ILE   240      20.877  66.181  75.769  1.00 23.52          
ATOM   1953  N   ILE   241      16.615  69.705  76.101  1.00 34.84          
ATOM   1954  CA  ILE   241      16.033  70.224  77.337  1.00 34.52          
ATOM   1955  C   ILE   241      14.536  69.945  77.259  1.00 36.36          
ATOM   1956  O   ILE   241      13.871  70.399  76.325  1.00 36.97          
ATOM   1957  CB  ILE   241      16.213  71.755  77.445  1.00 34.70          
ATOM   1958  CG1 ILE   241      17.698  72.142  77.494  1.00 32.68          
ATOM   1959  CG2 ILE   241      15.499  72.350  78.679  1.00 32.56          
ATOM   1960  CD  ILE   241      17.896  73.641  77.407  1.00 27.44          
ATOM   1961  N   HSD   242      14.017  69.189  78.218  1.00 36.14          
ATOM   1962  CA  HSD   242      12.618  68.948  78.272  1.00 37.06          
ATOM   1963  C   HSD   242      12.002  70.295  78.647  1.00 37.20          
ATOM   1964  O   HSD   242      12.524  71.019  79.507  1.00 37.50          
ATOM   1965  CB  HSD   242      12.297  67.873  79.325  1.00 36.82          
ATOM   1966  CG  HSD   242      10.897  67.362  79.232  1.00 37.87          
ATOM   1967  ND1 HSD   242       9.803  68.133  79.570  1.00 39.24          
ATOM   1968  CD2 HSD   242      10.401  66.173  78.801  1.00 39.12          
ATOM   1969  CE1 HSD   242       8.694  67.443  79.350  1.00 36.45          
ATOM   1970  NE2 HSD   242       9.030  66.251  78.886  1.00 37.56          
ATOM   1971  N   PRO   243      10.878  70.634  78.018  1.00 36.62          
ATOM   1972  CA  PRO   243      10.236  71.917  78.178  1.00 36.23          
ATOM   1973  C   PRO   243       9.830  72.126  79.635  1.00 36.42          
ATOM   1974  O   PRO   243       9.776  73.259  80.135  1.00 36.36          
ATOM   1975  CB  PRO   243       9.013  71.801  77.280  1.00 36.42          
ATOM   1976  CG  PRO   243       9.317  70.740  76.323  1.00 36.44          
ATOM   1977  CD  PRO   243      10.219  69.792  77.017  1.00 37.50          
ATOM   1978  N   LEU   244       9.590  71.023  80.333  1.00 36.56          
ATOM   1979  CA  LEU   244       9.218  71.098  81.720  1.00 36.32          
ATOM   1980  C   LEU   244      10.440  71.359  82.577  1.00 35.27          
ATOM   1981  O   LEU   244      10.299  71.944  83.638  1.00 35.70          
ATOM   1982  CB  LEU   244       8.536  69.805  82.134  1.00 37.38          
ATOM   1983  CG  LEU   244       8.170  69.602  83.596  1.00 39.63          
ATOM   1984  CD1 LEU   244       7.251  70.749  84.101  1.00 38.62          
ATOM   1985  CD2 LEU   244       7.510  68.211  83.729  1.00 42.95          
ATOM   1986  N   LEU   245      11.634  70.938  82.137  1.00 34.60          
ATOM   1987  CA  LEU   245      12.861  71.265  82.907  1.00 33.50          
ATOM   1988  C   LEU   245      13.092  72.765  82.777  1.00 33.76          
ATOM   1989  O   LEU   245      13.370  73.445  83.766  1.00 33.93          
ATOM   1990  CB  LEU   245      14.088  70.493  82.429  1.00 32.88          
ATOM   1991  CG  LEU   245      15.475  70.839  83.028  1.00 33.28          
ATOM   1992  CD1 LEU   245      15.485  70.701  84.556  1.00 29.82          
ATOM   1993  CD2 LEU   245      16.595  69.942  82.416  1.00 34.28          
ATOM   1994  N   ALA   246      12.938  73.294  81.568  1.00 33.30          
ATOM   1995  CA  ALA   246      13.101  74.733  81.381  1.00 34.49          
ATOM   1996  C   ALA   246      12.147  75.568  82.282  1.00 34.88          
ATOM   1997  O   ALA   246      12.519  76.583  82.845  1.00 34.31          
ATOM   1998  CB  ALA   246      12.936  75.105  79.897  1.00 34.35          
ATOM   1999  N   ASP   247      10.902  75.132  82.401  1.00 35.61          
ATOM   2000  CA  ASP   247       9.969  75.850  83.216  1.00 35.71          
ATOM   2001  C   ASP   247      10.263  75.690  84.725  1.00 35.92          
ATOM   2002  O   ASP   247      10.024  76.618  85.537  1.00 35.06          
ATOM   2003  CB  ASP   247       8.574  75.349  82.912  1.00 36.17          
ATOM   2004  CG  ASP   247       7.563  75.942  83.855  1.00 39.07          
ATOM   2005  OD1 ASP   247       7.541  77.197  83.937  1.00 40.29          
ATOM   2006  OD2 ASP   247       6.852  75.166  84.543  1.00 39.88          
ATOM   2007  N   HSD   248      10.792  74.514  85.079  1.00 35.87          
ATOM   2008  CA  HSD   248      11.132  74.125  86.450  1.00 35.69          
ATOM   2009  C   HSD   248      12.263  75.031  86.986  1.00 36.66          
ATOM   2010  O   HSD   248      12.203  75.528  88.125  1.00 37.02          
ATOM   2011  CB  HSD   248      11.570  72.667  86.395  1.00 34.87          
ATOM   2012  CG  HSD   248      12.070  72.103  87.691  1.00 35.56          
ATOM   2013  ND1 HSD   248      11.320  71.249  88.464  1.00 37.72          
ATOM   2014  CD2 HSD   248      13.270  72.209  88.314  1.00 37.44          
ATOM   2015  CE1 HSD   248      12.025  70.878  89.526  1.00 41.14          
ATOM   2016  NE2 HSD   248      13.208  71.451  89.468  1.00 35.16          
ATOM   2017  N   VAL   249      13.310  75.232  86.192  1.00 36.44          
ATOM   2018  CA  VAL   249      14.362  76.169  86.627  1.00 36.33          
ATOM   2019  C   VAL   249      13.953  77.652  86.480  1.00 36.69          
ATOM   2020  O   VAL   249      14.546  78.497  87.102  1.00 35.53          
ATOM   2021  CB  VAL   249      15.723  75.919  85.930  1.00 36.78          
ATOM   2022  CG1 VAL   249      16.161  74.460  86.084  1.00 35.72          
ATOM   2023  CG2 VAL   249      15.705  76.374  84.458  1.00 35.06          
ATOM   2024  N   PHE   250      12.936  77.975  85.659  1.00 36.70          
ATOM   2025  CA  PHE   250      12.374  79.328  85.680  1.00 35.79          
ATOM   2026  C   PHE   250      11.635  79.596  87.004  1.00 36.26          
ATOM   2027  O   PHE   250      11.711  80.693  87.575  1.00 36.29          
ATOM   2028  CB  PHE   250      11.398  79.556  84.524  1.00 36.25          
ATOM   2029  CG  PHE   250      10.543  80.758  84.719  1.00 36.32          
ATOM   2030  CD1 PHE   250      11.047  82.012  84.520  1.00 36.74          
ATOM   2031  CD2 PHE   250       9.241  80.633  85.162  1.00 39.08          
ATOM   2032  CE1 PHE   250      10.242  83.132  84.724  1.00 40.60          
ATOM   2033  CE2 PHE   250       8.427  81.751  85.359  1.00 41.35          
ATOM   2034  CZ  PHE   250       8.923  82.994  85.138  1.00 38.23          
ATOM   2035  N   ARG   251      10.918  78.597  87.512  1.00 36.02          
ATOM   2036  CA  ARG   251      10.157  78.784  88.770  1.00 35.38          
ATOM   2037  C   ARG   251      11.132  78.902  89.929  1.00 34.84          
ATOM   2038  O   ARG   251      10.931  79.669  90.861  1.00 34.77          
ATOM   2039  CB  ARG   251       9.191  77.627  89.038  1.00 35.12          
ATOM   2040  CG  ARG   251       7.777  77.884  88.516  1.00 36.72          
ATOM   2041  CD  ARG   251       6.858  76.641  88.670  1.00 35.43          
ATOM   2042  NE  ARG   251       7.067  75.686  87.583  1.00 36.83          
ATOM   2043  CZ  ARG   251       7.522  74.448  87.760  1.00 40.78          
ATOM   2044  NH1 ARG   251       7.709  73.648  86.721  1.00 38.52          
ATOM   2045  NH2 ARG   251       7.799  73.997  88.992  1.00 43.99          
ATOM   2046  N   GLU   252      12.194  78.131  89.899  1.00 34.34          
ATOM   2047  CA  GLU   252      13.154  78.286  90.973  1.00 34.62          
ATOM   2048  C   GLU   252      13.826  79.662  90.951  1.00 35.13          
ATOM   2049  O   GLU   252      13.900  80.294  91.972  1.00 36.45          
ATOM   2050  CB  GLU   252      14.192  77.157  90.970  1.00 34.99          
ATOM   2051  CG  GLU   252      13.601  75.786  91.138  1.00 36.07          
ATOM   2052  CD  GLU   252      14.628  74.710  90.966  1.00 37.48          
ATOM   2053  OE1 GLU   252      15.786  75.014  90.610  1.00 40.01          
ATOM   2054  OE2 GLU   252      14.298  73.560  91.241  1.00 38.45          
ATOM   2055  N   ALA   253      14.323  80.158  89.814  1.00 35.77          
ATOM   2056  CA  ALA   253      14.842  81.553  89.768  1.00 35.93          
ATOM   2057  C   ALA   253      13.821  82.592  90.243  1.00 36.75          
ATOM   2058  O   ALA   253      14.150  83.518  90.989  1.00 38.07          
ATOM   2059  CB  ALA   253      15.300  81.926  88.349  1.00 36.11          
ATOM   2060  N   ASP   254      12.586  82.459  89.776  1.00 37.16          
ATOM   2061  CA  ASP   254      11.516  83.352  90.120  1.00 37.28          
ATOM   2062  C   ASP   254      11.308  83.426  91.630  1.00 36.89          
ATOM   2063  O   ASP   254      11.192  84.516  92.199  1.00 36.76          
ATOM   2064  CB  ASP   254      10.249  82.905  89.414  1.00 38.58          
ATOM   2065  CG  ASP   254       9.113  83.882  89.605  1.00 43.22          
ATOM   2066  OD1 ASP   254       9.156  84.971  88.982  1.00 45.67          
ATOM   2067  OD2 ASP   254       8.185  83.561  90.383  1.00 48.43          
ATOM   2068  N   ARG   255      11.281  82.274  92.304  1.00 35.85          
ATOM   2069  CA  ARG   255      11.165  82.274  93.758  1.00 33.07          
ATOM   2070  C   ARG   255      12.380  82.983  94.402  1.00 33.19          
ATOM   2071  O   ARG   255      12.234  83.723  95.358  1.00 32.67          
ATOM   2072  CB  ARG   255      11.060  80.834  94.257  1.00 31.91          
ATOM   2073  CG  ARG   255      10.845  80.732  95.763  1.00 32.32          
ATOM   2074  CD  ARG   255      10.555  79.306  96.159  1.00 34.94          
ATOM   2075  NE  ARG   255      10.201  79.086  97.564  1.00 33.77          
ATOM   2076  CZ  ARG   255       8.937  79.067  98.013  1.00 32.26          
ATOM   2077  NH1 ARG   255       7.943  79.341  97.204  1.00 29.83          
ATOM   2078  NH2 ARG   255       8.682  78.845  99.287  1.00 32.00          
ATOM   2079  N   PHE   256      13.593  82.717  93.911  1.00 32.38          
ATOM   2080  CA  PHE   256      14.789  83.395  94.481  1.00 32.50          
ATOM   2081  C   PHE   256      14.597  84.895  94.349  1.00 32.63          
ATOM   2082  O   PHE   256      14.967  85.660  95.227  1.00 32.63          
ATOM   2083  CB  PHE   256      16.050  82.927  93.741  1.00 30.74          
ATOM   2084  CG  PHE   256      17.341  83.513  94.250  1.00 31.35          
ATOM   2085  CD1 PHE   256      17.474  83.952  95.544  1.00 32.13          
ATOM   2086  CD2 PHE   256      18.460  83.557  93.430  1.00 29.54          
ATOM   2087  CE1 PHE   256      18.651  84.420  95.991  1.00 31.71          
ATOM   2088  CE2 PHE   256      19.627  84.065  93.859  1.00 27.31          
ATOM   2089  CZ  PHE   256      19.723  84.496  95.142  1.00 32.30          
ATOM   2090  N   LEU   257      13.983  85.316  93.248  1.00 33.93          
ATOM   2091  CA  LEU   257      13.744  86.731  93.050  1.00 35.81          
ATOM   2092  C   LEU   257      12.745  87.343  94.061  1.00 37.41          
ATOM   2093  O   LEU   257      12.982  88.459  94.519  1.00 39.01          
ATOM   2094  CB  LEU   257      13.376  87.033  91.590  1.00 35.03          
ATOM   2095  CG  LEU   257      13.359  88.491  91.156  1.00 33.06          
ATOM   2096  CD1 LEU   257      14.749  89.190  91.187  1.00 29.17          
ATOM   2097  CD2 LEU   257      12.670  88.600  89.760  1.00 33.69          
ATOM   2098  N   GLU   258      11.660  86.643  94.416  1.00 38.61          
ATOM   2099  CA  GLU   258      10.757  87.107  95.483  1.00 39.83          
ATOM   2100  C   GLU   258      11.582  87.263  96.774  1.00 39.75          
ATOM   2101  O   GLU   258      11.575  88.310  97.420  1.00 39.64          
ATOM   2102  CB  GLU   258       9.660  86.073  95.790  1.00 40.69          
ATOM   2103  CG  GLU   258       8.296  86.277  95.163  1.00 45.44          
ATOM   2104  CD  GLU   258       7.139  86.068  96.158  1.00 50.39          
ATOM   2105  OE1 GLU   258       7.328  86.256  97.381  1.00 52.39          
ATOM   2106  OE2 GLU   258       6.015  85.743  95.718  1.00 53.30          
ATOM   2107  N   ILE   259      12.280  86.198  97.167  1.00 38.54          
ATOM   2108  CA  ILE   259      13.123  86.262  98.343  1.00 37.65          
ATOM   2109  C   ILE   259      14.043  87.487  98.318  1.00 38.23          
ATOM   2110  O   ILE   259      14.120  88.224  99.310  1.00 37.96          
ATOM   2111  CB  ILE   259      13.917  84.958  98.573  1.00 37.24          
ATOM   2112  CG1 ILE   259      12.977  83.779  98.775  1.00 34.24          
ATOM   2113  CG2 ILE   259      14.864  85.092  99.793  1.00 39.48          
ATOM   2114  CD  ILE   259      13.655  82.429  98.750  1.00 31.82          
ATOM   2115  N   ILE   260      14.712  87.751  97.196  1.00 38.49          
ATOM   2116  CA  ILE   260      15.603  88.918  97.140  1.00 38.41          
ATOM   2117  C   ILE   260      14.810  90.244  97.297  1.00 38.28          
ATOM   2118  O   ILE   260      15.168  91.134  98.079  1.00 37.09          
ATOM   2119  CB  ILE   260      16.421  88.952  95.821  1.00 38.67          
ATOM   2120  CG1 ILE   260      17.556  87.928  95.823  1.00 38.89          
ATOM   2121  CG2 ILE   260      17.077  90.320  95.630  1.00 39.79          
ATOM   2122  CD  ILE   260      18.273  87.891  94.528  1.00 35.72          
ATOM   2123  N   ASP   261      13.726  90.373  96.548  1.00 38.48          
ATOM   2124  CA  ASP   261      12.895  91.568  96.647  1.00 38.40          
ATOM   2125  C   ASP   261      12.231  91.753  98.019  1.00 38.68          
ATOM   2126  O   ASP   261      12.158  92.873  98.522  1.00 39.09          
ATOM   2127  CB  ASP   261      11.866  91.575  95.534  1.00 38.58          
ATOM   2128  CG  ASP   261      12.481  91.894  94.182  1.00 40.77          
ATOM   2129  OD1 ASP   261      13.670  92.342  94.133  1.00 41.03          
ATOM   2130  OD2 ASP   261      11.771  91.710  93.162  1.00 38.77          
ATOM   2131  N   MET   262      11.743  90.683  98.641  1.00 39.47          
ATOM   2132  CA  MET   262      11.163  90.817  99.979  1.00 39.79          
ATOM   2133  C   MET   262      12.221  91.140 101.026  1.00 41.29          
ATOM   2134  O   MET   262      11.989  91.976 101.920  1.00 41.10          
ATOM   2135  CB  MET   262      10.379  89.602 100.380  1.00 39.20          
ATOM   2136  CG  MET   262       9.088  89.311  99.509  1.00 41.06          
ATOM   2137  SD  MET   262       7.840  90.569  99.560  1.00 45.29          
ATOM   2138  CE  MET   262       8.180  91.327  97.969  1.00 50.88          
ATOM   2139  N   TYR   263      13.399  90.545 100.921  1.00 42.34          
ATOM   2140  CA  TYR   263      14.416  90.885 101.927  1.00 45.02          
ATOM   2141  C   TYR   263      14.825  92.330 101.786  1.00 46.06          
ATOM   2142  O   TYR   263      14.997  93.046 102.749  1.00 46.00          
ATOM   2143  CB  TYR   263      15.628  89.944 101.888  1.00 44.88          
ATOM   2144  CG  TYR   263      15.300  88.574 102.460  1.00 47.26          
ATOM   2145  CD1 TYR   263      14.210  88.408 103.285  1.00 49.66          
ATOM   2146  CD2 TYR   263      16.082  87.471 102.190  1.00 49.99          
ATOM   2147  CE1 TYR   263      13.890  87.202 103.800  1.00 52.17          
ATOM   2148  CE2 TYR   263      15.767  86.228 102.725  1.00 52.26          
ATOM   2149  CZ  TYR   263      14.673  86.115 103.531  1.00 52.86          
ATOM   2150  OH  TYR   263      14.318  84.906 104.078  1.00 56.78          
ATOM   2151  N   ASP   264      14.943  92.764 100.553  1.00 48.43          
ATOM   2152  CA  ASP   264      15.246  94.137 100.246  1.00 50.62          
ATOM   2153  C   ASP   264      14.287  95.120 100.937  1.00 51.70          
ATOM   2154  O   ASP   264      14.738  96.076 101.552  1.00 51.66          
ATOM   2155  CB  ASP   264      15.202  94.312  98.742  1.00 50.56          
ATOM   2156  CG  ASP   264      15.676  95.656  98.323  1.00 54.80          
ATOM   2157  OD1 ASP   264      16.922  95.811  98.218  1.00 58.40          
ATOM   2158  OD2 ASP   264      14.805  96.551  98.118  1.00 55.68          
ATOM   2159  N   VAL   265      12.978  94.875 100.842  1.00 52.89          
ATOM   2160  CA  VAL   265      11.975  95.695 101.522  1.00 54.42          
ATOM   2161  C   VAL   265      12.188  95.709 103.043  1.00 55.96          
ATOM   2162  O   VAL   265      12.361  96.784 103.663  1.00 55.94          
ATOM   2163  CB  VAL   265      10.530  95.207 101.223  1.00 53.98          
ATOM   2164  CG1 VAL   265       9.519  95.961 102.068  1.00 54.02          
ATOM   2165  CG2 VAL   265      10.217  95.379  99.766  1.00 54.30          
ATOM   2166  N   HSD   266      12.169  94.516 103.636  1.00 57.26          
ATOM   2167  CA  HSD   266      12.274  94.378 105.072  1.00 59.17          
ATOM   2168  C   HSD   266      13.520  95.172 105.471  1.00 59.86          
ATOM   2169  O   HSD   266      13.504  95.878 106.469  1.00 60.51          
ATOM   2170  CB  HSD   266      12.354  92.891 105.504  1.00 59.73          
ATOM   2171  CG  HSD   266      11.102  92.086 105.233  1.00 62.65          
ATOM   2172  ND1 HSD   266       9.986  92.609 104.606  1.00 65.72          
ATOM   2173  CD2 HSD   266      10.807  90.784 105.486  1.00 64.90          
ATOM   2174  CE1 HSD   266       9.048  91.680 104.517  1.00 65.77          
ATOM   2175  NE2 HSD   266       9.526  90.558 105.030  1.00 66.17          
ATOM   2176  N   LEU   267      14.571  95.091 104.645  1.00 60.20          
ATOM   2177  CA  LEU   267      15.831  95.816 104.858  1.00 60.13          
ATOM   2178  C   LEU   267      15.701  97.281 104.418  1.00 60.70          
ATOM   2179  O   LEU   267      15.840  98.206 105.225  1.00 60.80          
ATOM   2180  CB  LEU   267      16.996  95.143 104.095  1.00 59.56          
ATOM   2181  CG  LEU   267      18.401  95.350 104.679  1.00 59.35          
ATOM   2182  CD1 LEU   267      18.460  94.832 106.103  1.00 59.73          
ATOM   2183  CD2 LEU   267      19.539  94.737 103.847  1.00 57.90          
END
