
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  116 (  901),  selected  116 , name 2rld_C
# Molecule2: number of CA atoms  130 ( 1063),  selected  130 , name T0478_138_267.pdb
# PARAMETERS: 2rld_C.T0478_138_267.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_C      -       -           -
LGA    R     2_C      D     138          3.882
LGA    E     3_C      A     139          3.924
LGA    D     4_C      L     140          4.100
LGA    -       -      P     141           -
LGA    X     5_C      D     142          4.513
LGA    K     6_C      A     143          2.024
LGA    D     7_C      I     144          2.478
LGA    -       -      I     145           -
LGA    N     8_C      K     146          0.732
LGA    V     9_C      E     147          2.718
LGA    V    10_C      N     148          2.791
LGA    K    11_C      V     149          1.013
LGA    D    12_C      F     150          1.427
LGA    K    13_C      F     151          2.377
LGA    S    14_C      L     152          1.946
LGA    L    15_C      R     153          1.132
LGA    E    16_C      I     154          2.788
LGA    F    17_C      M     155          2.813
LGA    A    18_C      A     156          1.376
LGA    V    19_C      D     157          1.630
LGA    R    20_C      X     158          2.528
LGA    I    21_C      A     159          1.906
LGA    V    22_C      K     160          1.229
LGA    N    23_C      F     161          1.787
LGA    L    24_C      I     162          1.447
LGA    Y    25_C      G     163          0.580
LGA    K    26_C      X     164          0.949
LGA    F    27_C      L     165          1.119
LGA    L    28_C      L     166          1.465
LGA    V    29_C      -       -           -
LGA    N    30_C      -       -           -
LGA    E    31_C      D     167          2.761
LGA    Q    32_C      P     168          4.942
LGA    K    33_C      S     169          1.990
LGA    E    34_C      E     170          1.408
LGA    F    35_C      R     171          1.855
LGA    V    36_C      K     172          1.630
LGA    X    37_C      L     173          2.340
LGA    S    38_C      V     174          2.546
LGA    K    39_C      D     175          2.267
LGA    Q    40_C      T     176          2.155
LGA    I    41_C      A     177          3.058
LGA    L    42_C      R     178          2.919
LGA    R    43_C      N     179          2.489
LGA    S    44_C      F     180          2.541
LGA    G    45_C      S     181          4.695
LGA    T    46_C      N     182          4.984
LGA    S    47_C      D     183          2.621
LGA    I    48_C      F     184          3.808
LGA    G    49_C      D     185           #
LGA    A    50_C      E     186          3.051
LGA    N    51_C      L     187          2.406
LGA    -       -      M     188           -
LGA    -       -      Y     189           -
LGA    -       -      Q     190           -
LGA    I    52_C      A     191          3.404
LGA    R    53_C      I     192          3.762
LGA    E    54_C      D     193          5.656
LGA    A    55_C      L     194          4.773
LGA    E    56_C      E     195          3.965
LGA    -       -      S     196           -
LGA    Q    57_C      M     197          5.032
LGA    A    58_C      K     198           -
LGA    -       -      P     199           -
LGA    Q    59_C      Q     200           #
LGA    S    60_C      S     201          5.995
LGA    -       -      Q     202           -
LGA    -       -      T     203           -
LGA    R    61_C      A     204          3.122
LGA    A    62_C      P     205          1.556
LGA    D    63_C      L     206          3.056
LGA    F    64_C      L     207          2.830
LGA    I    65_C      D     208          1.479
LGA    N    66_C      Q     209          1.216
LGA    K    67_C      F     210          2.410
LGA    L    68_C      L     211          1.762
LGA    N    69_C      D     212          1.087
LGA    I    70_C      Q     213          1.224
LGA    A    71_C      N     214          1.077
LGA    L    72_C      R     215          1.032
LGA    K    73_C      V     216          0.564
LGA    E    74_C      S     217          0.364
LGA    A    75_C      V     218          0.648
LGA    N    76_C      A     219          0.919
LGA    E    77_C      S     220          0.935
LGA    T    78_C      L     221          0.647
LGA    E    79_C      R     222          1.450
LGA    Y    80_C      D     223          1.833
LGA    W    81_C      F     224          1.392
LGA    L    82_C      K     225          1.332
LGA    E    83_C      K     226          2.173
LGA    L    84_C      T     227          2.212
LGA    L    85_C      A     228          1.481
LGA    I    86_C      R     229          2.321
LGA    R    87_C      D     230          2.695
LGA    T    88_C      L     231          2.383
LGA    E    89_C      I     232          2.355
LGA    -       -      E     233           -
LGA    -       -      Q     234           -
LGA    -       -      C     235           -
LGA    -       -      K     236           -
LGA    Y    90_C      I     237          3.455
LGA    -       -      K     238           -
LGA    -       -      S     239           -
LGA    -       -      I     240           -
LGA    I    91_C      I     241           #
LGA    T    92_C      X     242          4.056
LGA    R    93_C      P     243          2.781
LGA    E    94_C      L     244          0.295
LGA    Q    95_C      L     245          1.862
LGA    Y    96_C      A     246          1.872
LGA    E    97_C      D     247          1.374
LGA    S    98_C      X     248          0.897
LGA    I    99_C      V     249          0.670
LGA    N   100_C      F     250          0.668
LGA    N   101_C      R     251          1.201
LGA    D   102_C      E     252          1.362
LGA    S   103_C      A     253          0.716
LGA    T   104_C      D     254          1.237
LGA    E   105_C      R     255          1.871
LGA    I   106_C      F     256          1.357
LGA    N   107_C      L     257          0.950
LGA    K   108_C      E     258          1.762
LGA    L   109_C      I     259          1.807
LGA    L   110_C      I     260          1.637
LGA    I   111_C      D     261          1.822
LGA    S   112_C      M     262          2.564
LGA    I   113_C      Y     263          2.426
LGA    I   114_C      D     264          1.992
LGA    K   115_C      V     265          1.944
LGA    T   116_C      X     266          2.029
LGA    -       -      L     267           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  116  130    5.0    109    2.49     5.50     59.420     4.207

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.707393 * X  +   0.698929 * Y  +  -0.105323 * Z  +  28.471695
  Y_new =   0.596562 * X  +   0.670297 * Y  +   0.441379 * Z  +  13.316484
  Z_new =   0.379090 * X  +   0.249397 * Y  +  -0.891118 * Z  +  87.451096 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.868705   -0.272888  [ DEG:   164.3647    -15.6353 ]
  Theta =  -0.388813   -2.752779  [ DEG:   -22.2773   -157.7227 ]
  Phi   =   2.440987   -0.700606  [ DEG:   139.8582    -40.1417 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rld_C                                        
REMARK     2: T0478_138_267.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rld_C.T0478_138_267.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  116  130   5.0  109   2.49    5.50  59.420
REMARK  ---------------------------------------------------------- 
MOLECULE 2rld_C
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-OCT-07   2RLD              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN (NP_809265.1)            
TITLE    2 FROM BACTEROIDES THETAIOTAOMICRON VPI-5482 AT 1.70 A                 
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B, C, D, E;                                                
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACTEROIDES THETAIOTAOMICRON VPI-5482;          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: VPI-5482, DSM 2079, NCTC 10582, E50;                         
SOURCE   5 ATCC: 29148;                                                         
SOURCE   6 GENE: NP_809265.1, BT_0352;                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_809265.1, UNCHARACTERIZED PROTEIN, STRUCTURAL GENOMICS,            
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI-2, STRUCTURAL GENOMICS, UNKNOWN            
KEYWDS   4 FUNCTION                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   30-OCT-07 2RLD    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN                 
JRNL        TITL 2 (NP_809265.1) FROM BACTEROIDES THETAIOTAOMICRON              
JRNL        TITL 3 VPI-5482 AT 1.70 A RESOLUTION                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2RLD A    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
DBREF  2RLD B    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
DBREF  2RLD C    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
DBREF  2RLD D    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
DBREF  2RLD E    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
SEQRES   1 A  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 A  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 A  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 A  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 A  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 A  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 A  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 A  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 A  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 A  121  THR LYS ASN ASN                                              
SEQRES   1 B  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 B  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 B  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 B  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 B  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 B  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 B  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 B  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 B  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 B  121  THR LYS ASN ASN                                              
SEQRES   1 C  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 C  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 C  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 C  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 C  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 C  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 C  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 C  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 C  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 C  121  THR LYS ASN ASN                                              
SEQRES   1 D  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 D  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 D  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 D  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 D  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 D  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 D  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 D  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 D  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 D  121  THR LYS ASN ASN                                              
SEQRES   1 E  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 E  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 E  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 E  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 E  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 E  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 E  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 E  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 E  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 E  121  THR LYS ASN ASN                                              
HET    MSE  A   1       8                                                       
HET    MSE  A   5      13                                                       
HET    MSE  A  37       8                                                       
HET    MSE  B   5       8                                                       
HET    MSE  B  37       8                                                       
HET    MSE  C   1       5                                                       
HET    MSE  C   5       5                                                       
HET    MSE  C  37       8                                                       
HET    MSE  D  37       8                                                       
HET    MSE  E  37       8                                                       
HET     CA  D 121       1                                                       
HET     CA  A 121       1                                                       
HET     CA  C 121       1                                                       
HET     CL  A 122       1                                                       
HET     CL  D 122       1                                                       
HET    EDO  B 121       4                                                       
HET    EDO  A 123       4                                                       
HET    EDO  C 122       4                                                       
HET    EDO  C 123       4                                                       
HET    EDO  B 122       4                                                       
HET    EDO  A 124       4                                                       
HET    EDO  B 123       4                                                       
HET    EDO  A 125       4                                                       
HET    EDO  B 124       4                                                       
HET    EDO  E 121       4                                                       
HET    EDO  A 126       4                                                       
HET    EDO  D 123       4                                                       
HET    EDO  B 125       4                                                       
HET    EDO  A 127       4                                                       
HET    EDO  E 122       4                                                       
HET    EDO  E 123       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CA CALCIUM ION                                                      
HETNAM      CL CHLORIDE ION                                                     
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   6   CA    3(CA 2+)                                                     
FORMUL   9   CL    2(CL 1-)                                                     
FORMUL  11  EDO    16(C2 H6 O2)                                                 
FORMUL  27  HOH   *518(H2 O)                                                    
CRYST1   57.238   83.823   63.923  90.00  97.42  90.00 P 1 21 1     10          
HETATM 1929  N   MSE C   1       9.501  81.293 105.718  1.00 44.73           N  
HETATM 1930  CA  MSE C   1      10.747  80.771 106.363  1.00 43.59           C  
HETATM 1931  C   MSE C   1      11.249  81.725 107.443  1.00 42.98           C  
HETATM 1932  O   MSE C   1      11.010  82.940 107.365  1.00 43.06           O  
HETATM 1933  CB  MSE C   1      11.851  80.566 105.317  1.00 44.17           C  
ATOM   1934  N   ARG C   2      11.941  81.167 108.441  1.00 42.00           N  
ATOM   1935  CA  ARG C   2      12.568  81.947 109.522  1.00 40.74           C  
ATOM   1936  C   ARG C   2      13.433  83.069 108.936  1.00 40.89           C  
ATOM   1937  O   ARG C   2      14.293  82.816 108.079  1.00 41.05           O  
ATOM   1938  CB  ARG C   2      13.422  81.043 110.419  1.00 38.99           C  
ATOM   1939  N   GLU C   3      13.189  84.303 109.386  1.00 39.52           N  
ATOM   1940  CA  GLU C   3      13.822  85.494 108.797  1.00 38.05           C  
ATOM   1941  C   GLU C   3      15.348  85.454 108.882  1.00 35.64           C  
ATOM   1942  O   GLU C   3      16.036  85.812 107.917  1.00 34.06           O  
ATOM   1943  CB  GLU C   3      13.295  86.771 109.464  1.00 38.61           C  
ATOM   1944  N   ASP C   4      15.859  84.996 110.024  1.00 33.23           N  
ATOM   1945  CA  ASP C   4      17.298  84.896 110.259  1.00 32.40           C  
ATOM   1946  C   ASP C   4      18.022  84.073 109.195  1.00 31.24           C  
ATOM   1947  O   ASP C   4      19.161  84.365 108.868  1.00 31.60           O  
ATOM   1948  CB  ASP C   4      17.575  84.270 111.621  1.00 32.11           C  
HETATM 1949  N   MSE C   5      17.352  83.051 108.667  1.00 31.75           N  
HETATM 1950  CA  MSE C   5      17.978  82.073 107.768  1.00 30.68           C  
HETATM 1951  C   MSE C   5      18.080  82.541 106.318  1.00 31.34           C  
HETATM 1952  O   MSE C   5      18.853  81.967 105.540  1.00 29.85           O  
HETATM 1953  CB  MSE C   5      17.193  80.752 107.811  1.00 30.73           C  
ATOM   1954  N   LYS C   6      17.312  83.571 105.954  1.00 30.55           N  
ATOM   1955  CA  LYS C   6      17.129  83.902 104.546  1.00 31.61           C  
ATOM   1956  C   LYS C   6      18.445  84.036 103.773  1.00 32.41           C  
ATOM   1957  O   LYS C   6      18.519  83.608 102.619  1.00 32.70           O  
ATOM   1958  CB  LYS C   6      16.234  85.141 104.356  1.00 32.20           C  
ATOM   1959  CG  LYS C   6      14.727  84.841 104.401  1.00 30.59           C  
ATOM   1960  N   ASP C   7      19.478  84.596 104.408  1.00 31.69           N  
ATOM   1961  CA  ASP C   7      20.767  84.792 103.733  1.00 31.23           C  
ATOM   1962  C   ASP C   7      21.531  83.477 103.549  1.00 28.96           C  
ATOM   1963  O   ASP C   7      22.152  83.250 102.511  1.00 26.01           O  
ATOM   1964  CB  ASP C   7      21.640  85.798 104.485  1.00 31.72           C  
ATOM   1965  CG  ASP C   7      22.059  85.291 105.846  1.00 32.91           C  
ATOM   1966  OD1 ASP C   7      21.192  85.234 106.734  1.00 32.32           O  
ATOM   1967  OD2 ASP C   7      23.237  84.907 106.012  1.00 46.60           O  
ATOM   1968  N   ASN C   8      21.484  82.607 104.550  1.00 29.66           N  
ATOM   1969  CA  ASN C   8      22.211  81.331 104.469  1.00 28.18           C  
ATOM   1970  C   ASN C   8      21.571  80.396 103.462  1.00 26.55           C  
ATOM   1971  O   ASN C   8      22.259  79.642 102.758  1.00 26.99           O  
ATOM   1972  CB  ASN C   8      22.231  80.618 105.822  1.00 30.99           C  
ATOM   1973  CG  ASN C   8      22.655  81.521 106.937  1.00 29.19           C  
ATOM   1974  OD1 ASN C   8      21.908  82.425 107.317  1.00 34.89           O  
ATOM   1975  ND2 ASN C   8      23.851  81.302 107.463  1.00 30.94           N  
ATOM   1976  N   VAL C   9      20.241  80.422 103.433  1.00 25.13           N  
ATOM   1977  CA  VAL C   9      19.486  79.629 102.481  1.00 23.76           C  
ATOM   1978  C   VAL C   9      19.654  80.134 101.050  1.00 21.52           C  
ATOM   1979  O   VAL C   9      19.786  79.327 100.132  1.00 21.53           O  
ATOM   1980  CB  VAL C   9      17.993  79.581 102.850  1.00 23.94           C  
ATOM   1981  CG1 VAL C   9      17.160  78.986 101.694  1.00 20.01           C  
ATOM   1982  CG2 VAL C   9      17.811  78.786 104.140  1.00 24.44           C  
ATOM   1983  N   VAL C  10      19.674  81.447 100.840  1.00 20.49           N  
ATOM   1984  CA  VAL C  10      19.819  81.946  99.468  1.00 20.19           C  
ATOM   1985  C   VAL C  10      21.218  81.640  98.908  1.00 21.39           C  
ATOM   1986  O   VAL C  10      21.360  81.414  97.710  1.00 19.49           O  
ATOM   1987  CB  VAL C  10      19.468  83.455  99.321  1.00 21.00           C  
ATOM   1988  CG1 VAL C  10      20.589  84.350  99.863  1.00 19.63           C  
ATOM   1989  CG2 VAL C  10      19.163  83.776  97.862  1.00 18.91           C  
ATOM   1990  N   LYS C  11      22.234  81.624  99.769  1.00 20.58           N  
ATOM   1991  CA  LYS C  11      23.570  81.204  99.360  1.00 20.56           C  
ATOM   1992  C   LYS C  11      23.538  79.772  98.857  1.00 19.63           C  
ATOM   1993  O   LYS C  11      23.981  79.497  97.740  1.00 20.22           O  
ATOM   1994  CB  LYS C  11      24.563  81.311 100.523  1.00 21.63           C  
ATOM   1995  CG  LYS C  11      25.944  80.769 100.198  1.00 26.24           C  
ATOM   1996  N   ASP C  12      23.044  78.844  99.676  1.00 17.69           N  
ATOM   1997  CA  ASP C  12      22.975  77.447  99.240  1.00 19.88           C  
ATOM   1998  C   ASP C  12      22.135  77.284  97.954  1.00 16.92           C  
ATOM   1999  O   ASP C  12      22.519  76.563  97.031  1.00 17.57           O  
ATOM   2000  CB  ASP C  12      22.410  76.543 100.331  1.00 20.40           C  
ATOM   2001  CG  ASP C  12      22.324  75.088  99.880  1.00 28.22           C  
ATOM   2002  OD1 ASP C  12      23.383  74.487  99.641  1.00 31.19           O  
ATOM   2003  OD2 ASP C  12      21.201  74.553  99.724  1.00 41.12           O  
ATOM   2004  N   LYS C  13      20.998  77.968  97.886  1.00 18.48           N  
ATOM   2005  CA  LYS C  13      20.161  77.870  96.683  1.00 18.59           C  
ATOM   2006  C   LYS C  13      20.894  78.375  95.454  1.00 16.74           C  
ATOM   2007  O   LYS C  13      20.719  77.836  94.370  1.00 17.28           O  
ATOM   2008  CB  LYS C  13      18.869  78.664  96.849  1.00 20.73           C  
ATOM   2009  CG  LYS C  13      17.990  78.162  97.964  1.00 24.19           C  
ATOM   2010  CD  LYS C  13      17.383  76.822  97.684  1.00 34.36           C  
ATOM   2011  CE  LYS C  13      16.151  76.604  98.574  1.00 37.47           C  
ATOM   2012  NZ  LYS C  13      15.668  75.205  98.499  1.00 39.10           N  
ATOM   2013  N   SER C  14      21.688  79.437  95.618  1.00 16.51           N  
ATOM   2014  CA  SER C  14      22.421  80.015  94.495  1.00 17.31           C  
ATOM   2015  C   SER C  14      23.512  79.079  93.973  1.00 17.51           C  
ATOM   2016  O   SER C  14      23.778  79.034  92.757  1.00 16.84           O  
ATOM   2017  CB  SER C  14      22.966  81.402  94.876  1.00 19.10           C  
ATOM   2018  OG  SER C  14      24.069  81.336  95.783  1.00 18.07           O  
ATOM   2019  N   LEU C  15      24.144  78.325  94.872  1.00 15.95           N  
ATOM   2020  CA  LEU C  15      25.177  77.363  94.468  1.00 17.85           C  
ATOM   2021  C   LEU C  15      24.555  76.178  93.725  1.00 17.24           C  
ATOM   2022  O   LEU C  15      25.042  75.743  92.663  1.00 17.34           O  
ATOM   2023  CB  LEU C  15      25.971  76.921  95.685  1.00 16.45           C  
ATOM   2024  CG  LEU C  15      26.965  77.939  96.227  1.00 19.48           C  
ATOM   2025  CD1 LEU C  15      27.374  77.620  97.686  1.00 22.04           C  
ATOM   2026  CD2 LEU C  15      28.209  77.984  95.327  1.00 23.28           C  
ATOM   2027  N   GLU C  16      23.449  75.663  94.262  1.00 16.67           N  
ATOM   2028  CA  GLU C  16      22.706  74.622  93.574  1.00 17.25           C  
ATOM   2029  C   GLU C  16      22.264  75.113  92.195  1.00 16.52           C  
ATOM   2030  O   GLU C  16      22.343  74.388  91.196  1.00 15.58           O  
ATOM   2031  CB  GLU C  16      21.508  74.162  94.403  1.00 17.06           C  
ATOM   2032  CG  GLU C  16      21.887  73.420  95.697  1.00 21.10           C  
ATOM   2033  CD  GLU C  16      22.786  72.207  95.484  1.00 31.39           C  
ATOM   2034  OE1 GLU C  16      22.579  71.420  94.532  1.00 34.50           O  
ATOM   2035  OE2 GLU C  16      23.720  72.045  96.283  1.00 36.92           O  
ATOM   2036  N   PHE C  17      21.828  76.366  92.131  1.00 16.77           N  
ATOM   2037  CA  PHE C  17      21.357  76.926  90.860  1.00 17.10           C  
ATOM   2038  C   PHE C  17      22.491  77.060  89.842  1.00 16.98           C  
ATOM   2039  O   PHE C  17      22.308  76.745  88.664  1.00 16.45           O  
ATOM   2040  CB  PHE C  17      20.705  78.287  91.075  1.00 16.76           C  
ATOM   2041  CG  PHE C  17      20.030  78.835  89.841  1.00 15.04           C  
ATOM   2042  CD1 PHE C  17      18.852  78.272  89.376  1.00 19.25           C  
ATOM   2043  CD2 PHE C  17      20.578  79.905  89.157  1.00 17.23           C  
ATOM   2044  CE1 PHE C  17      18.213  78.772  88.268  1.00 17.28           C  
ATOM   2045  CE2 PHE C  17      19.931  80.421  88.022  1.00 20.41           C  
ATOM   2046  CZ  PHE C  17      18.751  79.861  87.589  1.00 17.37           C  
ATOM   2047  N   ALA C  18      23.658  77.532  90.287  1.00 17.34           N  
ATOM   2048  CA  ALA C  18      24.835  77.635  89.438  1.00 15.27           C  
ATOM   2049  C   ALA C  18      25.104  76.276  88.776  1.00 14.67           C  
ATOM   2050  O   ALA C  18      25.398  76.190  87.578  1.00 15.22           O  
ATOM   2051  CB  ALA C  18      26.067  78.117  90.279  1.00 15.10           C  
ATOM   2052  N   VAL C  19      24.966  75.201  89.545  1.00 15.56           N  
ATOM   2053  CA  VAL C  19      25.234  73.868  89.013  1.00 16.05           C  
ATOM   2054  C   VAL C  19      24.181  73.513  87.907  1.00 15.08           C  
ATOM   2055  O   VAL C  19      24.515  72.984  86.836  1.00 16.24           O  
ATOM   2056  CB  VAL C  19      25.210  72.814  90.126  1.00 15.51           C  
ATOM   2057  CG1 VAL C  19      25.198  71.400  89.513  1.00 18.47           C  
ATOM   2058  CG2 VAL C  19      26.421  73.000  91.132  1.00 17.36           C  
ATOM   2059  N   ARG C  20      22.929  73.827  88.164  1.00 16.65           N  
ATOM   2060  CA  ARG C  20      21.893  73.612  87.174  1.00 16.04           C  
ATOM   2061  C   ARG C  20      22.191  74.438  85.913  1.00 15.63           C  
ATOM   2062  O   ARG C  20      21.993  73.959  84.791  1.00 15.30           O  
ATOM   2063  CB  ARG C  20      20.530  73.991  87.733  1.00 18.11           C  
ATOM   2064  CG  ARG C  20      20.076  73.101  88.897  1.00 16.66           C  
ATOM   2065  CD  ARG C  20      18.541  73.053  88.959  1.00 21.83           C  
ATOM   2066  NE  ARG C  20      17.955  72.299  87.852  1.00 20.04           N  
ATOM   2067  CZ  ARG C  20      16.653  72.298  87.555  1.00 21.47           C  
ATOM   2068  NH1 ARG C  20      15.799  73.027  88.271  1.00 19.07           N  
ATOM   2069  NH2 ARG C  20      16.209  71.599  86.523  1.00 21.27           N  
ATOM   2070  N   ILE C  21      22.667  75.672  86.092  1.00 13.67           N  
ATOM   2071  CA  ILE C  21      23.020  76.517  84.963  1.00 14.99           C  
ATOM   2072  C   ILE C  21      24.184  75.925  84.157  1.00 15.18           C  
ATOM   2073  O   ILE C  21      24.186  75.959  82.906  1.00 15.60           O  
ATOM   2074  CB  ILE C  21      23.269  77.966  85.429  1.00 16.82           C  
ATOM   2075  CG1 ILE C  21      21.939  78.606  85.841  1.00 18.21           C  
ATOM   2076  CG2 ILE C  21      24.009  78.778  84.317  1.00 16.06           C  
ATOM   2077  CD1 ILE C  21      20.975  78.817  84.633  1.00 17.76           C  
ATOM   2078  N   VAL C  22      25.162  75.359  84.849  1.00 16.66           N  
ATOM   2079  CA  VAL C  22      26.239  74.650  84.147  1.00 16.19           C  
ATOM   2080  C   VAL C  22      25.685  73.501  83.312  1.00 16.70           C  
ATOM   2081  O   VAL C  22      26.075  73.302  82.146  1.00 17.06           O  
ATOM   2082  CB  VAL C  22      27.352  74.183  85.099  1.00 15.80           C  
ATOM   2083  CG1 VAL C  22      28.341  73.257  84.424  1.00 19.01           C  
ATOM   2084  CG2 VAL C  22      28.101  75.355  85.650  1.00 16.26           C  
ATOM   2085  N   ASN C  23      24.796  72.713  83.895  1.00 15.42           N  
ATOM   2086  CA  ASN C  23      24.174  71.620  83.129  1.00 17.86           C  
ATOM   2087  C   ASN C  23      23.369  72.097  81.923  1.00 15.76           C  
ATOM   2088  O   ASN C  23      23.410  71.474  80.837  1.00 18.12           O  
ATOM   2089  CB  ASN C  23      23.319  70.761  84.065  1.00 19.22           C  
ATOM   2090  CG  ASN C  23      24.153  69.898  84.998  1.00 21.96           C  
ATOM   2091  OD1 ASN C  23      25.315  69.601  84.725  1.00 22.24           O  
ATOM   2092  ND2 ASN C  23      23.544  69.470  86.103  1.00 24.64           N  
ATOM   2093  N   LEU C  24      22.637  73.200  82.087  1.00 15.99           N  
ATOM   2094  CA  LEU C  24      21.897  73.788  80.999  1.00 16.25           C  
ATOM   2095  C   LEU C  24      22.821  74.249  79.893  1.00 16.55           C  
ATOM   2096  O   LEU C  24      22.497  74.115  78.718  1.00 15.86           O  
ATOM   2097  CB  LEU C  24      21.052  74.962  81.489  1.00 15.20           C  
ATOM   2098  CG  LEU C  24      20.230  75.673  80.409  1.00 14.61           C  
ATOM   2099  CD1 LEU C  24      19.196  74.721  79.746  1.00 17.21           C  
ATOM   2100  CD2 LEU C  24      19.552  76.932  80.998  1.00 17.29           C  
ATOM   2101  N   TYR C  25      23.939  74.850  80.271  1.00 15.76           N  
ATOM   2102  CA  TYR C  25      24.946  75.274  79.295  1.00 16.00           C  
ATOM   2103  C   TYR C  25      25.450  74.124  78.469  1.00 16.51           C  
ATOM   2104  O   TYR C  25      25.476  74.191  77.226  1.00 15.64           O  
ATOM   2105  CB  TYR C  25      26.096  75.975  79.998  1.00 16.36           C  
ATOM   2106  CG  TYR C  25      27.183  76.403  79.060  1.00 16.01           C  
ATOM   2107  CD1 TYR C  25      27.045  77.543  78.299  1.00 16.19           C  
ATOM   2108  CD2 TYR C  25      28.333  75.654  78.923  1.00 16.47           C  
ATOM   2109  CE1 TYR C  25      28.010  77.931  77.425  1.00 16.97           C  
ATOM   2110  CE2 TYR C  25      29.331  76.047  78.074  1.00 16.28           C  
ATOM   2111  CZ  TYR C  25      29.173  77.178  77.321  1.00 16.25           C  
ATOM   2112  OH  TYR C  25      30.157  77.587  76.448  1.00 23.09           O  
ATOM   2113  N   LYS C  26      25.810  73.035  79.137  1.00 16.28           N  
ATOM   2114  CA  LYS C  26      26.232  71.818  78.425  1.00 15.82           C  
ATOM   2115  C   LYS C  26      25.178  71.303  77.448  1.00 17.55           C  
ATOM   2116  O   LYS C  26      25.491  70.959  76.310  1.00 15.68           O  
ATOM   2117  CB  LYS C  26      26.583  70.722  79.434  1.00 16.16           C  
ATOM   2118  CG  LYS C  26      27.796  71.011  80.263  1.00 18.88           C  
ATOM   2119  CD  LYS C  26      27.920  70.001  81.392  1.00 21.32           C  
ATOM   2120  CE  LYS C  26      28.433  68.685  80.940  1.00 25.60           C  
ATOM   2121  NZ  LYS C  26      28.355  67.624  82.038  1.00 24.38           N  
ATOM   2122  N   PHE C  27      23.923  71.257  77.907  1.00 14.98           N  
ATOM   2123  CA  PHE C  27      22.796  70.858  77.076  1.00 15.38           C  
ATOM   2124  C   PHE C  27      22.701  71.721  75.837  1.00 15.01           C  
ATOM   2125  O   PHE C  27      22.641  71.191  74.723  1.00 15.81           O  
ATOM   2126  CB  PHE C  27      21.505  70.942  77.883  1.00 15.45           C  
ATOM   2127  CG  PHE C  27      20.266  70.717  77.068  1.00 15.28           C  
ATOM   2128  CD1 PHE C  27      19.862  69.426  76.726  1.00 18.63           C  
ATOM   2129  CD2 PHE C  27      19.495  71.776  76.669  1.00 15.36           C  
ATOM   2130  CE1 PHE C  27      18.711  69.203  75.967  1.00 18.95           C  
ATOM   2131  CE2 PHE C  27      18.321  71.550  75.903  1.00 18.06           C  
ATOM   2132  CZ  PHE C  27      17.941  70.251  75.575  1.00 17.47           C  
ATOM   2133  N   LEU C  28      22.731  73.044  76.026  1.00 15.65           N  
ATOM   2134  CA  LEU C  28      22.553  73.971  74.922  1.00 14.96           C  
ATOM   2135  C   LEU C  28      23.687  73.843  73.917  1.00 17.90           C  
ATOM   2136  O   LEU C  28      23.450  73.770  72.714  1.00 18.07           O  
ATOM   2137  CB  LEU C  28      22.436  75.409  75.418  1.00 12.41           C  
ATOM   2138  CG  LEU C  28      21.156  75.744  76.180  1.00 16.39           C  
ATOM   2139  CD1 LEU C  28      21.318  77.112  76.834  1.00 13.34           C  
ATOM   2140  CD2 LEU C  28      19.957  75.638  75.234  1.00 19.68           C  
ATOM   2141  N   VAL C  29      24.918  73.791  74.408  1.00 15.05           N  
ATOM   2142  CA  VAL C  29      26.058  73.729  73.504  1.00 14.09           C  
ATOM   2143  C   VAL C  29      26.169  72.361  72.824  1.00 15.16           C  
ATOM   2144  O   VAL C  29      26.292  72.288  71.605  1.00 17.22           O  
ATOM   2145  CB  VAL C  29      27.387  74.107  74.253  1.00 16.68           C  
ATOM   2146  CG1 VAL C  29      28.556  73.863  73.351  1.00 18.05           C  
ATOM   2147  CG2 VAL C  29      27.313  75.591  74.749  1.00 15.90           C  
ATOM   2148  N   ASN C  30      26.137  71.296  73.612  1.00 16.27           N  
ATOM   2149  CA  ASN C  30      26.446  69.949  73.107  1.00 17.32           C  
ATOM   2150  C   ASN C  30      25.294  69.312  72.344  1.00 16.67           C  
ATOM   2151  O   ASN C  30      25.513  68.675  71.290  1.00 19.70           O  
ATOM   2152  CB  ASN C  30      26.876  69.016  74.236  1.00 18.42           C  
ATOM   2153  CG  ASN C  30      28.172  69.447  74.881  1.00 21.87           C  
ATOM   2154  OD1 ASN C  30      29.076  69.941  74.213  1.00 23.19           O  
ATOM   2155  ND2 ASN C  30      28.260  69.276  76.186  1.00 22.60           N  
ATOM   2156  N   GLU C  31      24.075  69.523  72.832  1.00 18.49           N  
ATOM   2157  CA  GLU C  31      22.904  68.917  72.221  0.50 19.94           C  
ATOM   2159  C   GLU C  31      22.195  69.860  71.245  1.00 18.80           C  
ATOM   2160  O   GLU C  31      21.836  69.446  70.139  1.00 20.09           O  
ATOM   2161  CB  GLU C  31      21.971  68.394  73.315  0.50 20.52           C  
ATOM   2163  CG  GLU C  31      22.724  67.568  74.351  0.50 22.51           C  
ATOM   2165  CD  GLU C  31      21.827  66.897  75.351  0.50 24.39           C  
ATOM   2167  OE1 GLU C  31      20.758  66.387  74.949  0.50 26.74           O  
ATOM   2169  OE2 GLU C  31      22.199  66.875  76.540  0.50 21.11           O  
ATOM   2171  N   GLN C  32      22.014  71.119  71.629  1.00 17.64           N  
ATOM   2172  CA  GLN C  32      21.298  72.062  70.774  1.00 17.07           C  
ATOM   2173  C   GLN C  32      22.212  72.873  69.846  1.00 17.29           C  
ATOM   2174  O   GLN C  32      21.709  73.582  68.982  1.00 19.64           O  
ATOM   2175  CB  GLN C  32      20.415  73.012  71.587  1.00 16.83           C  
ATOM   2176  CG  GLN C  32      19.471  72.354  72.555  1.00 18.29           C  
ATOM   2177  CD  GLN C  32      18.313  71.634  71.870  1.00 25.54           C  
ATOM   2178  OE1 GLN C  32      18.527  70.742  71.062  1.00 26.99           O  
ATOM   2179  NE2 GLN C  32      17.082  72.021  72.196  1.00 23.41           N  
ATOM   2180  N   LYS C  33      23.530  72.738  69.998  1.00 16.91           N  
ATOM   2181  CA  LYS C  33      24.497  73.490  69.187  1.00 16.62           C  
ATOM   2182  C   LYS C  33      24.222  74.999  69.213  1.00 17.96           C  
ATOM   2183  O   LYS C  33      24.348  75.669  68.198  1.00 20.81           O  
ATOM   2184  CB  LYS C  33      24.527  72.972  67.745  1.00 16.90           C  
ATOM   2185  CG  LYS C  33      24.600  71.465  67.651  1.00 18.35           C  
ATOM   2186  CD  LYS C  33      25.747  70.891  68.434  1.00 19.87           C  
ATOM   2187  CE  LYS C  33      25.956  69.413  68.095  1.00 27.93           C  
ATOM   2188  NZ  LYS C  33      26.938  68.808  69.027  1.00 24.67           N  
ATOM   2189  N   GLU C  34      23.873  75.508  70.397  1.00 15.47           N  
ATOM   2190  CA  GLU C  34      23.588  76.912  70.639  1.00 15.65           C  
ATOM   2191  C   GLU C  34      24.678  77.522  71.499  1.00 17.67           C  
ATOM   2192  O   GLU C  34      24.925  77.093  72.642  1.00 17.58           O  
ATOM   2193  CB  GLU C  34      22.207  77.056  71.289  1.00 18.35           C  
ATOM   2194  CG  GLU C  34      21.584  78.438  71.133  1.00 18.27           C  
ATOM   2195  CD  GLU C  34      22.331  79.549  71.879  1.00 20.18           C  
ATOM   2196  OE1 GLU C  34      22.607  79.356  73.089  1.00 23.30           O  
ATOM   2197  OE2 GLU C  34      22.635  80.605  71.244  1.00 20.99           O  
ATOM   2198  N   PHE C  35      25.331  78.542  70.949  1.00 18.05           N  
ATOM   2199  CA  PHE C  35      26.575  79.051  71.504  1.00 18.55           C  
ATOM   2200  C   PHE C  35      26.498  80.476  72.015  1.00 20.96           C  
ATOM   2201  O   PHE C  35      27.377  80.903  72.740  1.00 24.88           O  
ATOM   2202  CB  PHE C  35      27.659  78.960  70.439  1.00 21.55           C  
ATOM   2203  CG  PHE C  35      27.883  77.563  69.933  1.00 23.21           C  
ATOM   2204  CD1 PHE C  35      28.427  76.612  70.763  1.00 33.34           C  
ATOM   2205  CD2 PHE C  35      27.533  77.207  68.658  1.00 29.78           C  
ATOM   2206  CE1 PHE C  35      28.630  75.324  70.321  1.00 32.25           C  
ATOM   2207  CE2 PHE C  35      27.739  75.912  68.206  1.00 32.12           C  
ATOM   2208  CZ  PHE C  35      28.284  74.976  69.051  1.00 29.98           C  
ATOM   2209  N   VAL C  36      25.454  81.208  71.658  1.00 18.90           N  
ATOM   2210  CA  VAL C  36      25.387  82.644  71.956  1.00 18.27           C  
ATOM   2211  C   VAL C  36      24.576  82.893  73.237  1.00 17.75           C  
ATOM   2212  O   VAL C  36      25.103  83.416  74.225  1.00 19.82           O  
ATOM   2213  CB  VAL C  36      24.789  83.432  70.734  1.00 20.73           C  
ATOM   2214  CG1 VAL C  36      24.498  84.899  71.099  1.00 18.49           C  
ATOM   2215  CG2 VAL C  36      25.750  83.392  69.562  1.00 21.61           C  
HETATM 2216  N   MSE C  37      23.310  82.476  73.246  1.00 17.96           N  
HETATM 2217  CA  MSE C  37      22.490  82.647  74.416  1.00 20.02           C  
HETATM 2218  C   MSE C  37      23.025  81.831  75.598  1.00 17.50           C  
HETATM 2219  O   MSE C  37      23.014  82.284  76.753  1.00 18.21           O  
HETATM 2220  CB  MSE C  37      21.020  82.353  74.080  1.00 22.11           C  
HETATM 2221  CG  MSE C  37      20.535  83.197  72.944  1.00 22.98           C  
HETATM 2222 SE   MSE C  37      18.653  82.866  72.605  0.75 30.84          SE  
HETATM 2223  CE  MSE C  37      18.835  81.101  71.636  1.00 20.24           C  
ATOM   2224  N   SER C  38      23.536  80.642  75.287  1.00 17.52           N  
ATOM   2225  CA  SER C  38      24.102  79.753  76.286  1.00 16.83           C  
ATOM   2226  C   SER C  38      25.236  80.428  77.055  1.00 17.01           C  
ATOM   2227  O   SER C  38      25.305  80.331  78.301  1.00 17.43           O  
ATOM   2228  CB  SER C  38      24.574  78.467  75.615  1.00 18.22           C  
ATOM   2229  OG  SER C  38      25.575  78.703  74.649  1.00 16.94           O  
ATOM   2230  N   LYS C  39      26.118  81.127  76.350  1.00 16.68           N  
ATOM   2231  CA  LYS C  39      27.229  81.787  77.048  1.00 18.99           C  
ATOM   2232  C   LYS C  39      26.736  82.913  77.939  1.00 18.09           C  
ATOM   2233  O   LYS C  39      27.224  83.089  79.069  1.00 19.21           O  
ATOM   2234  CB  LYS C  39      28.251  82.318  76.057  1.00 20.07           C  
ATOM   2235  CG  LYS C  39      28.767  81.312  75.116  1.00 29.21           C  
ATOM   2236  N   GLN C  40      25.725  83.632  77.474  1.00 16.83           N  
ATOM   2237  CA  GLN C  40      25.160  84.741  78.240  1.00 16.00           C  
ATOM   2238  C   GLN C  40      24.558  84.228  79.539  1.00 15.84           C  
ATOM   2239  O   GLN C  40      24.819  84.766  80.611  1.00 16.41           O  
ATOM   2240  CB  GLN C  40      24.109  85.487  77.458  1.00 16.79           C  
ATOM   2241  CG  GLN C  40      24.615  86.193  76.227  1.00 17.32           C  
ATOM   2242  CD  GLN C  40      25.121  87.563  76.511  1.00 26.39           C  
ATOM   2243  OE1 GLN C  40      25.740  87.800  77.550  1.00 28.98           O  
ATOM   2244  NE2 GLN C  40      24.868  88.492  75.588  1.00 29.76           N  
ATOM   2245  N   ILE C  41      23.797  83.137  79.463  1.00 16.05           N  
ATOM   2246  CA  ILE C  41      23.104  82.638  80.646  1.00 16.07           C  
ATOM   2247  C   ILE C  41      24.028  81.868  81.577  1.00 17.08           C  
ATOM   2248  O   ILE C  41      23.792  81.834  82.791  1.00 17.59           O  
ATOM   2249  CB  ILE C  41      21.843  81.797  80.269  1.00 16.90           C  
ATOM   2250  CG1 ILE C  41      20.897  81.729  81.470  1.00 16.91           C  
ATOM   2251  CG2 ILE C  41      22.205  80.419  79.731  1.00 17.58           C  
ATOM   2252  CD1 ILE C  41      19.635  80.913  81.240  1.00 15.47           C  
ATOM   2253  N   LEU C  42      25.085  81.258  81.041  1.00 16.55           N  
ATOM   2254  CA  LEU C  42      26.110  80.681  81.903  1.00 15.29           C  
ATOM   2255  C   LEU C  42      26.684  81.750  82.815  1.00 15.88           C  
ATOM   2256  O   LEU C  42      26.818  81.556  84.022  1.00 16.29           O  
ATOM   2257  CB  LEU C  42      27.230  80.077  81.061  1.00 14.80           C  
ATOM   2258  CG  LEU C  42      28.409  79.526  81.864  1.00 17.36           C  
ATOM   2259  CD1 LEU C  42      27.996  78.385  82.796  1.00 13.94           C  
ATOM   2260  CD2 LEU C  42      29.500  79.093  80.869  1.00 13.58           C  
ATOM   2261  N   ARG C  43      26.979  82.906  82.233  1.00 16.80           N  
ATOM   2262  CA  ARG C  43      27.524  84.020  82.995  0.50 17.14           C  
ATOM   2264  C   ARG C  43      26.531  84.585  84.016  1.00 17.98           C  
ATOM   2265  O   ARG C  43      26.852  84.706  85.213  1.00 17.96           O  
ATOM   2266  CB  ARG C  43      27.999  85.132  82.057  0.50 16.60           C  
ATOM   2268  CG  ARG C  43      28.661  86.311  82.778  0.50 17.05           C  
ATOM   2270  N   SER C  44      25.327  84.920  83.579  1.00 17.81           N  
ATOM   2271  CA  SER C  44      24.383  85.543  84.484  1.00 17.15           C  
ATOM   2272  C   SER C  44      23.953  84.562  85.567  1.00 15.72           C  
ATOM   2273  O   SER C  44      23.935  84.919  86.737  1.00 17.18           O  
ATOM   2274  CB  SER C  44      23.183  86.161  83.736  1.00 16.69           C  
ATOM   2275  OG  SER C  44      22.318  85.208  83.136  1.00 15.95           O  
ATOM   2276  N   GLY C  45      23.719  83.310  85.196  1.00 14.54           N  
ATOM   2277  CA  GLY C  45      23.163  82.322  86.124  1.00 16.03           C  
ATOM   2278  C   GLY C  45      24.149  81.937  87.220  1.00 16.17           C  
ATOM   2279  O   GLY C  45      23.757  81.671  88.350  1.00 16.17           O  
ATOM   2280  N   THR C  46      25.426  81.872  86.878  1.00 15.81           N  
ATOM   2281  CA  THR C  46      26.458  81.543  87.870  1.00 16.14           C  
ATOM   2282  C   THR C  46      26.917  82.760  88.659  1.00 18.12           C  
ATOM   2283  O   THR C  46      27.425  82.627  89.793  1.00 17.27           O  
ATOM   2284  CB  THR C  46      27.697  80.837  87.203  1.00 15.18           C  
ATOM   2285  OG1 THR C  46      28.279  81.731  86.254  1.00 15.05           O  
ATOM   2286  CG2 THR C  46      27.278  79.503  86.558  1.00 16.19           C  
ATOM   2287  N   SER C  47      26.670  83.957  88.122  1.00 16.20           N  
ATOM   2288  CA  SER C  47      27.075  85.208  88.781  1.00 18.28           C  
ATOM   2289  C   SER C  47      26.161  85.559  89.965  1.00 17.48           C  
ATOM   2290  O   SER C  47      26.553  86.336  90.837  1.00 18.59           O  
ATOM   2291  CB  SER C  47      27.118  86.368  87.791  1.00 19.41           C  
ATOM   2292  OG  SER C  47      28.155  86.195  86.820  1.00 19.73           O  
ATOM   2293  N   ILE C  48      24.938  85.030  89.974  1.00 17.17           N  
ATOM   2294  CA  ILE C  48      24.035  85.216  91.128  1.00 17.50           C  
ATOM   2295  C   ILE C  48      24.788  84.776  92.408  1.00 17.22           C  
ATOM   2296  O   ILE C  48      25.005  85.577  93.326  1.00 17.09           O  
ATOM   2297  CB  ILE C  48      22.722  84.406  90.969  1.00 16.99           C  
ATOM   2298  CG1 ILE C  48      21.994  84.765  89.663  1.00 18.96           C  
ATOM   2299  CG2 ILE C  48      21.759  84.611  92.168  1.00 19.79           C  
ATOM   2300  CD1 ILE C  48      20.819  83.827  89.352  1.00 17.60           C  
ATOM   2301  N   GLY C  49      25.267  83.526  92.431  1.00 17.81           N  
ATOM   2302  CA  GLY C  49      25.982  82.994  93.623  1.00 17.29           C  
ATOM   2303  C   GLY C  49      27.272  83.733  93.928  1.00 16.43           C  
ATOM   2304  O   GLY C  49      27.617  83.940  95.101  1.00 17.75           O  
ATOM   2305  N   ALA C  50      27.995  84.125  92.882  1.00 17.43           N  
ATOM   2306  CA  ALA C  50      29.254  84.822  93.058  1.00 17.84           C  
ATOM   2307  C   ALA C  50      29.046  86.177  93.792  1.00 18.07           C  
ATOM   2308  O   ALA C  50      29.826  86.556  94.658  1.00 20.73           O  
ATOM   2309  CB  ALA C  50      29.950  85.028  91.710  1.00 18.37           C  
ATOM   2310  N   ASN C  51      28.001  86.895  93.443  1.00 18.51           N  
ATOM   2311  CA  ASN C  51      27.720  88.149  94.113  1.00 18.27           C  
ATOM   2312  C   ASN C  51      27.213  87.959  95.516  1.00 19.74           C  
ATOM   2313  O   ASN C  51      27.507  88.786  96.393  1.00 21.76           O  
ATOM   2314  CB  ASN C  51      26.729  88.980  93.302  1.00 18.34           C  
ATOM   2315  CG  ASN C  51      27.414  89.691  92.166  1.00 22.35           C  
ATOM   2316  OD1 ASN C  51      28.043  90.735  92.393  1.00 26.67           O  
ATOM   2317  ND2 ASN C  51      27.319  89.140  90.947  1.00 20.89           N  
ATOM   2318  N   ILE C  52      26.458  86.882  95.751  1.00 18.13           N  
ATOM   2319  CA  ILE C  52      25.997  86.580  97.107  1.00 18.69           C  
ATOM   2320  C   ILE C  52      27.222  86.319  97.975  1.00 21.22           C  
ATOM   2321  O   ILE C  52      27.301  86.790  99.111  1.00 20.71           O  
ATOM   2322  CB  ILE C  52      25.010  85.391  97.142  1.00 18.00           C  
ATOM   2323  CG1 ILE C  52      23.710  85.786  96.409  1.00 19.33           C  
ATOM   2324  CG2 ILE C  52      24.706  85.010  98.587  1.00 19.27           C  
ATOM   2325  CD1 ILE C  52      22.729  84.638  96.089  1.00 18.86           C  
ATOM   2326  N   ARG C  53      28.194  85.600  97.420  1.00 22.24           N  
ATOM   2327  CA  ARG C  53      29.467  85.375  98.103  1.00 23.29           C  
ATOM   2328  C   ARG C  53      30.217  86.681  98.398  1.00 22.82           C  
ATOM   2329  O   ARG C  53      30.836  86.817  99.477  1.00 24.29           O  
ATOM   2330  CB  ARG C  53      30.357  84.416  97.302  1.00 22.27           C  
ATOM   2331  CG  ARG C  53      31.576  83.927  98.081  1.00 24.78           C  
ATOM   2332  CD  ARG C  53      32.448  82.974  97.277  1.00 25.66           C  
ATOM   2333  NE  ARG C  53      33.322  82.223  98.157  1.00 24.46           N  
ATOM   2334  CZ  ARG C  53      34.498  82.635  98.616  1.00 26.87           C  
ATOM   2335  NH1 ARG C  53      34.999  83.802  98.256  1.00 26.99           N  
ATOM   2336  NH2 ARG C  53      35.183  81.848  99.430  1.00 26.20           N  
ATOM   2337  N   GLU C  54      30.191  87.637  97.468  1.00 22.46           N  
ATOM   2338  CA  GLU C  54      30.793  88.948  97.749  1.00 23.03           C  
ATOM   2339  C   GLU C  54      30.029  89.636  98.862  1.00 22.42           C  
ATOM   2340  O   GLU C  54      30.648  90.232  99.756  1.00 21.35           O  
ATOM   2341  CB  GLU C  54      30.815  89.857  96.518  1.00 25.30           C  
ATOM   2342  CG  GLU C  54      31.916  89.524  95.527  1.00 27.86           C  
ATOM   2343  CD  GLU C  54      32.161  90.628  94.493  1.00 32.99           C  
ATOM   2344  OE1 GLU C  54      31.603  91.748  94.641  1.00 41.94           O  
ATOM   2345  OE2 GLU C  54      32.934  90.380  93.528  1.00 45.13           O  
ATOM   2346  N   ALA C  55      28.692  89.564  98.811  1.00 21.99           N  
ATOM   2347  CA  ALA C  55      27.834  90.176  99.846  1.00 23.53           C  
ATOM   2348  C   ALA C  55      28.219  89.703 101.241  1.00 23.06           C  
ATOM   2349  O   ALA C  55      28.336  90.509 102.184  1.00 23.42           O  
ATOM   2350  CB  ALA C  55      26.358  89.876  99.581  1.00 22.03           C  
ATOM   2351  N   GLU C  56      28.438  88.404 101.373  1.00 23.93           N  
ATOM   2352  CA  GLU C  56      28.743  87.808 102.684  1.00 27.59           C  
ATOM   2353  C   GLU C  56      30.055  88.365 103.260  1.00 27.61           C  
ATOM   2354  O   GLU C  56      30.272  88.337 104.475  1.00 25.84           O  
ATOM   2355  CB  GLU C  56      28.817  86.278 102.586  1.00 28.51           C  
ATOM   2356  CG  GLU C  56      27.516  85.580 102.105  1.00 33.77           C  
ATOM   2357  CD  GLU C  56      26.545  85.144 103.215  1.00 45.30           C  
ATOM   2358  OE1 GLU C  56      26.904  85.169 104.412  1.00 52.38           O  
ATOM   2359  OE2 GLU C  56      25.410  84.744 102.876  1.00 51.52           O  
ATOM   2360  N   GLN C  57      30.906  88.891 102.383  1.00 26.98           N  
ATOM   2361  CA  GLN C  57      32.201  89.447 102.763  1.00 26.60           C  
ATOM   2362  C   GLN C  57      32.195  90.957 102.939  1.00 27.39           C  
ATOM   2363  O   GLN C  57      33.248  91.551 103.190  1.00 27.35           O  
ATOM   2364  CB  GLN C  57      33.239  89.051 101.719  1.00 26.09           C  
ATOM   2365  CG  GLN C  57      33.587  87.566 101.778  1.00 29.51           C  
ATOM   2366  CD  GLN C  57      34.466  87.133 100.631  1.00 29.74           C  
ATOM   2367  OE1 GLN C  57      34.010  87.024  99.509  1.00 32.51           O  
ATOM   2368  NE2 GLN C  57      35.737  86.884 100.915  1.00 31.44           N  
ATOM   2369  N   ALA C  58      31.017  91.569 102.827  1.00 27.24           N  
ATOM   2370  CA  ALA C  58      30.874  93.027 102.901  1.00 27.84           C  
ATOM   2371  C   ALA C  58      31.379  93.575 104.219  1.00 28.07           C  
ATOM   2372  O   ALA C  58      31.175  92.958 105.269  1.00 26.51           O  
ATOM   2373  CB  ALA C  58      29.423  93.432 102.715  1.00 26.40           C  
ATOM   2374  N   GLN C  59      32.017  94.744 104.157  1.00 29.60           N  
ATOM   2375  CA  GLN C  59      32.521  95.425 105.350  1.00 30.64           C  
ATOM   2376  C   GLN C  59      31.439  96.307 105.969  1.00 30.29           C  
ATOM   2377  O   GLN C  59      31.574  96.737 107.101  1.00 30.93           O  
ATOM   2378  CB  GLN C  59      33.764  96.267 105.024  1.00 30.42           C  
ATOM   2379  N   SER C  60      30.376  96.566 105.212  1.00 30.54           N  
ATOM   2380  CA  SER C  60      29.224  97.325 105.685  1.00 30.60           C  
ATOM   2381  C   SER C  60      27.933  96.619 105.290  1.00 30.34           C  
ATOM   2382  O   SER C  60      27.915  95.830 104.349  1.00 29.24           O  
ATOM   2383  CB  SER C  60      29.234  98.749 105.094  1.00 30.69           C  
ATOM   2384  OG  SER C  60      29.541  98.752 103.706  1.00 33.25           O  
ATOM   2385  N   ARG C  61      26.852  96.914 106.010  1.00 30.48           N  
ATOM   2386  CA  ARG C  61      25.519  96.455 105.616  1.00 30.34           C  
ATOM   2387  C   ARG C  61      25.107  97.098 104.286  1.00 30.65           C  
ATOM   2388  O   ARG C  61      24.357  96.501 103.508  1.00 28.66           O  
ATOM   2389  CB  ARG C  61      24.489  96.780 106.702  1.00 30.16           C  
ATOM   2390  N   ALA C  62      25.594  98.318 104.045  1.00 30.12           N  
ATOM   2391  CA  ALA C  62      25.369  99.034 102.790  1.00 29.75           C  
ATOM   2392  C   ALA C  62      25.932  98.246 101.629  1.00 28.97           C  
ATOM   2393  O   ALA C  62      25.240  98.022 100.640  1.00 28.38           O  
ATOM   2394  CB  ALA C  62      26.019 100.413 102.844  1.00 30.68           C  
ATOM   2395  N   ASP C  63      27.195  97.836 101.763  1.00 28.00           N  
ATOM   2396  CA  ASP C  63      27.888  97.071 100.730  1.00 26.81           C  
ATOM   2397  C   ASP C  63      27.237  95.704 100.549  1.00 25.33           C  
ATOM   2398  O   ASP C  63      27.107  95.206  99.434  1.00 25.38           O  
ATOM   2399  CB  ASP C  63      29.361  96.911 101.109  1.00 28.90           C  
ATOM   2400  N   PHE C  64      26.840  95.093 101.658  1.00 23.86           N  
ATOM   2401  CA  PHE C  64      26.070  93.848 101.638  1.00 22.99           C  
ATOM   2402  C   PHE C  64      24.801  93.940 100.776  1.00 21.69           C  
ATOM   2403  O   PHE C  64      24.597  93.123  99.869  1.00 18.52           O  
ATOM   2404  CB  PHE C  64      25.696  93.491 103.065  1.00 21.37           C  
ATOM   2405  CG  PHE C  64      24.765  92.325 103.195  1.00 19.54           C  
ATOM   2406  CD1 PHE C  64      25.232  91.032 103.081  1.00 22.60           C  
ATOM   2407  CD2 PHE C  64      23.432  92.523 103.519  1.00 26.53           C  
ATOM   2408  CE1 PHE C  64      24.383  89.955 103.247  1.00 22.24           C  
ATOM   2409  CE2 PHE C  64      22.575  91.452 103.679  1.00 24.49           C  
ATOM   2410  CZ  PHE C  64      23.046  90.170 103.548  1.00 25.34           C  
ATOM   2411  N   ILE C  65      23.952  94.918 101.069  1.00 22.12           N  
ATOM   2412  CA  ILE C  65      22.709  95.106 100.314  1.00 21.70           C  
ATOM   2413  C   ILE C  65      23.011  95.354  98.842  1.00 22.94           C  
ATOM   2414  O   ILE C  65      22.332  94.801  97.946  1.00 21.74           O  
ATOM   2415  CB  ILE C  65      21.852  96.282 100.900  1.00 22.88           C  
ATOM   2416  CG1 ILE C  65      21.318  95.922 102.287  1.00 23.58           C  
ATOM   2417  CG2 ILE C  65      20.676  96.610 100.007  1.00 22.36           C  
ATOM   2418  CD1 ILE C  65      20.381  94.728 102.320  1.00 25.70           C  
ATOM   2419  N   ASN C  66      24.034  96.156  98.572  1.00 22.46           N  
ATOM   2420  CA  ASN C  66      24.398  96.455  97.187  1.00 24.36           C  
ATOM   2421  C   ASN C  66      24.853  95.227  96.387  1.00 23.35           C  
ATOM   2422  O   ASN C  66      24.462  95.040  95.224  1.00 25.00           O  
ATOM   2423  CB  ASN C  66      25.440  97.577  97.128  1.00 27.09           C  
ATOM   2424  CG  ASN C  66      24.808  98.963  97.295  1.00 27.28           C  
ATOM   2425  OD1 ASN C  66      24.041  99.197  98.230  1.00 43.80           O  
ATOM   2426  ND2 ASN C  66      25.114  99.873  96.379  1.00 39.60           N  
ATOM   2427  N   LYS C  67      25.658  94.377  97.011  1.00 22.80           N  
ATOM   2428  CA  LYS C  67      26.064  93.137  96.360  1.00 22.03           C  
ATOM   2429  C   LYS C  67      24.853  92.222  96.141  1.00 20.94           C  
ATOM   2430  O   LYS C  67      24.750  91.554  95.101  1.00 20.19           O  
ATOM   2431  CB  LYS C  67      27.169  92.440  97.160  1.00 22.84           C  
ATOM   2432  CG  LYS C  67      28.479  93.223  97.156  1.00 25.79           C  
ATOM   2433  CD  LYS C  67      29.095  93.256  95.777  1.00 31.67           C  
ATOM   2434  N   LEU C  68      23.909  92.211  97.086  1.00 19.48           N  
ATOM   2435  CA  LEU C  68      22.696  91.423  96.890  1.00 19.19           C  
ATOM   2436  C   LEU C  68      21.861  91.978  95.737  1.00 18.53           C  
ATOM   2437  O   LEU C  68      21.207  91.224  95.004  1.00 20.22           O  
ATOM   2438  CB  LEU C  68      21.869  91.358  98.163  1.00 17.83           C  
ATOM   2439  CG  LEU C  68      22.435  90.563  99.347  1.00 16.83           C  
ATOM   2440  CD1 LEU C  68      21.355  90.396 100.406  1.00 19.59           C  
ATOM   2441  CD2 LEU C  68      22.976  89.210  98.893  1.00 18.75           C  
ATOM   2442  N   ASN C  69      21.875  93.296  95.570  1.00 19.18           N  
ATOM   2443  CA  ASN C  69      21.160  93.913  94.459  1.00 18.08           C  
ATOM   2444  C   ASN C  69      21.765  93.531  93.122  1.00 17.94           C  
ATOM   2445  O   ASN C  69      21.028  93.345  92.145  1.00 17.45           O  
ATOM   2446  CB  ASN C  69      21.160  95.429  94.595  1.00 19.87           C  
ATOM   2447  CG  ASN C  69      20.233  96.110  93.577  1.00 27.17           C  
ATOM   2448  OD1 ASN C  69      20.700  96.802  92.671  1.00 35.48           O  
ATOM   2449  ND2 ASN C  69      18.914  95.922  93.738  1.00 31.41           N  
ATOM   2450  N   ILE C  70      23.095  93.405  93.069  1.00 18.07           N  
ATOM   2451  CA  ILE C  70      23.744  92.875  91.854  1.00 19.76           C  
ATOM   2452  C   ILE C  70      23.363  91.399  91.620  1.00 18.72           C  
ATOM   2453  O   ILE C  70      23.086  91.005  90.480  1.00 18.94           O  
ATOM   2454  CB  ILE C  70      25.278  92.998  91.894  1.00 19.75           C  
ATOM   2455  CG1 ILE C  70      25.716  94.456  92.065  1.00 24.21           C  
ATOM   2456  CG2 ILE C  70      25.907  92.437  90.589  1.00 19.86           C  
ATOM   2457  CD1 ILE C  70      27.217  94.593  92.355  1.00 23.97           C  
ATOM   2458  N   ALA C  71      23.279  90.600  92.686  1.00 18.05           N  
ATOM   2459  CA  ALA C  71      22.773  89.207  92.566  1.00 16.85           C  
ATOM   2460  C   ALA C  71      21.356  89.178  91.981  1.00 16.45           C  
ATOM   2461  O   ALA C  71      21.039  88.380  91.094  1.00 18.57           O  
ATOM   2462  CB  ALA C  71      22.786  88.506  93.936  1.00 14.30           C  
ATOM   2463  N   LEU C  72      20.509  90.088  92.469  1.00 16.95           N  
ATOM   2464  CA  LEU C  72      19.147  90.184  91.961  1.00 16.62           C  
ATOM   2465  C   LEU C  72      19.105  90.559  90.464  1.00 17.09           C  
ATOM   2466  O   LEU C  72      18.261  90.072  89.701  1.00 15.16           O  
ATOM   2467  CB  LEU C  72      18.380  91.220  92.771  1.00 18.58           C  
ATOM   2468  CG  LEU C  72      16.922  91.420  92.393  1.00 18.39           C  
ATOM   2469  CD1 LEU C  72      16.177  90.081  92.381  1.00 17.65           C  
ATOM   2470  CD2 LEU C  72      16.300  92.423  93.358  1.00 18.63           C  
ATOM   2471  N   LYS C  73      20.015  91.439  90.065  1.00 15.46           N  
ATOM   2472  CA  LYS C  73      20.132  91.843  88.671  1.00 15.87           C  
ATOM   2473  C   LYS C  73      20.435  90.641  87.811  1.00 16.14           C  
ATOM   2474  O   LYS C  73      19.849  90.436  86.725  1.00 16.45           O  
ATOM   2475  CB  LYS C  73      21.266  92.840  88.516  1.00 17.15           C  
ATOM   2476  CG  LYS C  73      21.483  93.340  87.090  1.00 21.73           C  
ATOM   2477  CD  LYS C  73      22.540  94.444  87.047  1.00 20.98           C  
ATOM   2478  CE  LYS C  73      23.981  93.906  87.262  1.00 26.15           C  
ATOM   2479  NZ  LYS C  73      24.490  93.262  86.010  1.00 28.23           N  
ATOM   2480  N   GLU C  74      21.387  89.864  88.294  1.00 15.97           N  
ATOM   2481  CA  GLU C  74      21.841  88.664  87.572  1.00 15.67           C  
ATOM   2482  C   GLU C  74      20.718  87.614  87.494  1.00 17.40           C  
ATOM   2483  O   GLU C  74      20.520  86.967  86.459  1.00 16.08           O  
ATOM   2484  CB  GLU C  74      23.107  88.110  88.227  1.00 17.47           C  
ATOM   2485  CG  GLU C  74      24.338  89.029  88.162  1.00 20.27           C  
ATOM   2486  CD  GLU C  74      24.926  89.226  86.762  1.00 25.06           C  
ATOM   2487  OE1 GLU C  74      24.351  88.766  85.754  1.00 24.46           O  
ATOM   2488  OE2 GLU C  74      26.017  89.836  86.688  1.00 33.53           O  
ATOM   2489  N   ALA C  75      19.951  87.470  88.565  1.00 17.30           N  
ATOM   2490  CA  ALA C  75      18.761  86.598  88.566  1.00 16.29           C  
ATOM   2491  C   ALA C  75      17.748  87.050  87.508  1.00 14.93           C  
ATOM   2492  O   ALA C  75      17.214  86.226  86.752  1.00 15.55           O  
ATOM   2493  CB  ALA C  75      18.122  86.583  89.951  1.00 15.35           C  
ATOM   2494  N   ASN C  76      17.521  88.356  87.428  1.00 17.41           N  
ATOM   2495  CA  ASN C  76      16.595  88.876  86.445  0.50 14.51           C  
ATOM   2497  C   ASN C  76      17.084  88.713  85.029  1.00 15.66           C  
ATOM   2498  O   ASN C  76      16.297  88.330  84.150  1.00 17.61           O  
ATOM   2499  CB  ASN C  76      16.246  90.317  86.736  0.50 15.13           C  
ATOM   2501  CG  ASN C  76      15.125  90.417  87.712  0.50 13.17           C  
ATOM   2503  OD1 ASN C  76      13.962  90.265  87.328  0.50 16.26           O  
ATOM   2505  ND2 ASN C  76      15.449  90.631  88.981  0.50 17.28           N  
ATOM   2507  N   GLU C  77      18.376  88.929  84.798  1.00 15.56           N  
ATOM   2508  CA  GLU C  77      18.907  88.692  83.441  1.00 13.58           C  
ATOM   2509  C   GLU C  77      18.773  87.218  83.052  1.00 16.22           C  
ATOM   2510  O   GLU C  77      18.403  86.887  81.915  1.00 16.65           O  
ATOM   2511  CB  GLU C  77      20.359  89.143  83.331  1.00 14.90           C  
ATOM   2512  CG  GLU C  77      20.815  89.094  81.881  1.00 15.14           C  
ATOM   2513  CD  GLU C  77      22.278  89.364  81.663  1.00 21.00           C  
ATOM   2514  OE1 GLU C  77      22.901  90.050  82.506  1.00 25.51           O  
ATOM   2515  OE2 GLU C  77      22.794  88.884  80.627  1.00 17.47           O  
ATOM   2516  N   THR C  78      19.046  86.344  84.001  1.00 15.41           N  
ATOM   2517  CA  THR C  78      18.957  84.896  83.771  1.00 15.08           C  
ATOM   2518  C   THR C  78      17.518  84.546  83.366  1.00 15.60           C  
ATOM   2519  O   THR C  78      17.301  83.750  82.465  1.00 15.68           O  
ATOM   2520  CB  THR C  78      19.380  84.108  85.043  1.00 17.74           C  
ATOM   2521  OG1 THR C  78      20.744  84.417  85.384  1.00 15.73           O  
ATOM   2522  CG2 THR C  78      19.237  82.597  84.838  1.00 17.87           C  
ATOM   2523  N   GLU C  79      16.552  85.137  84.056  1.00 15.86           N  
ATOM   2524  CA  GLU C  79      15.118  84.919  83.755  1.00 13.46           C  
ATOM   2525  C   GLU C  79      14.770  85.384  82.335  1.00 15.41           C  
ATOM   2526  O   GLU C  79      13.980  84.758  81.641  1.00 16.06           O  
ATOM   2527  CB  GLU C  79      14.275  85.561  84.864  1.00 17.76           C  
ATOM   2528  CG  GLU C  79      14.365  84.687  86.141  1.00 20.85           C  
ATOM   2529  CD  GLU C  79      14.386  85.446  87.458  1.00 26.56           C  
ATOM   2530  OE1 GLU C  79      14.029  86.643  87.474  1.00 22.78           O  
ATOM   2531  OE2 GLU C  79      14.787  84.826  88.477  1.00 25.68           O  
ATOM   2532  N   TYR C  80      15.384  86.475  81.904  1.00 14.82           N  
ATOM   2533  CA  TYR C  80      15.243  86.950  80.525  1.00 15.66           C  
ATOM   2534  C   TYR C  80      15.733  85.887  79.561  1.00 15.10           C  
ATOM   2535  O   TYR C  80      15.025  85.503  78.623  1.00 14.79           O  
ATOM   2536  CB  TYR C  80      16.058  88.242  80.325  1.00 15.97           C  
ATOM   2537  CG  TYR C  80      16.206  88.695  78.860  1.00 14.36           C  
ATOM   2538  CD1 TYR C  80      15.206  89.388  78.212  1.00 18.52           C  
ATOM   2539  CD2 TYR C  80      17.369  88.432  78.168  1.00 19.01           C  
ATOM   2540  CE1 TYR C  80      15.363  89.800  76.872  1.00 16.12           C  
ATOM   2541  CE2 TYR C  80      17.536  88.809  76.828  1.00 16.79           C  
ATOM   2542  CZ  TYR C  80      16.525  89.482  76.190  1.00 16.85           C  
ATOM   2543  OH  TYR C  80      16.732  89.893  74.889  1.00 18.02           O  
ATOM   2544  N   TRP C  81      16.948  85.396  79.788  1.00 14.50           N  
ATOM   2545  CA  TRP C  81      17.502  84.388  78.859  1.00 14.09           C  
ATOM   2546  C   TRP C  81      16.650  83.120  78.871  1.00 16.04           C  
ATOM   2547  O   TRP C  81      16.397  82.538  77.809  1.00 13.85           O  
ATOM   2548  CB  TRP C  81      18.992  84.058  79.147  1.00 15.74           C  
ATOM   2549  CG  TRP C  81      19.908  85.227  78.881  1.00 14.48           C  
ATOM   2550  CD1 TRP C  81      20.619  85.959  79.805  1.00 16.14           C  
ATOM   2551  CD2 TRP C  81      20.170  85.821  77.607  1.00 13.54           C  
ATOM   2552  NE1 TRP C  81      21.317  86.970  79.159  1.00 17.17           N  
ATOM   2553  CE2 TRP C  81      21.045  86.911  77.820  1.00 14.66           C  
ATOM   2554  CE3 TRP C  81      19.736  85.536  76.296  1.00 14.49           C  
ATOM   2555  CZ2 TRP C  81      21.498  87.710  76.783  1.00 17.62           C  
ATOM   2556  CZ3 TRP C  81      20.216  86.314  75.265  1.00 17.65           C  
ATOM   2557  CH2 TRP C  81      21.080  87.403  75.517  1.00 15.58           C  
ATOM   2558  N   LEU C  82      16.145  82.724  80.039  1.00 14.90           N  
ATOM   2559  CA  LEU C  82      15.307  81.520  80.095  1.00 14.34           C  
ATOM   2560  C   LEU C  82      14.032  81.711  79.265  1.00 15.55           C  
ATOM   2561  O   LEU C  82      13.561  80.814  78.564  1.00 15.99           O  
ATOM   2562  CB  LEU C  82      14.954  81.188  81.537  1.00 17.41           C  
ATOM   2563  CG  LEU C  82      16.084  80.616  82.391  1.00 18.15           C  
ATOM   2564  CD1 LEU C  82      15.651  80.537  83.862  1.00 19.84           C  
ATOM   2565  CD2 LEU C  82      16.571  79.220  81.864  1.00 18.72           C  
ATOM   2566  N   GLU C  83      13.437  82.882  79.375  1.00 14.45           N  
ATOM   2567  CA  GLU C  83      12.216  83.170  78.642  1.00 16.41           C  
ATOM   2568  C   GLU C  83      12.469  83.129  77.136  1.00 15.02           C  
ATOM   2569  O   GLU C  83      11.683  82.575  76.345  1.00 14.33           O  
ATOM   2570  CB  GLU C  83      11.703  84.554  79.038  1.00 16.73           C  
ATOM   2571  CG  GLU C  83      10.304  84.836  78.492  1.00 24.64           C  
ATOM   2572  CD  GLU C  83       9.715  86.169  78.969  1.00 28.59           C  
ATOM   2573  OE1 GLU C  83      10.268  86.792  79.910  1.00 31.02           O  
ATOM   2574  OE2 GLU C  83       8.679  86.571  78.398  1.00 33.10           O  
ATOM   2575  N   LEU C  84      13.569  83.747  76.725  1.00 15.55           N  
ATOM   2576  CA  LEU C  84      13.974  83.686  75.314  1.00 14.43           C  
ATOM   2577  C   LEU C  84      14.192  82.249  74.826  1.00 14.65           C  
ATOM   2578  O   LEU C  84      13.737  81.878  73.738  1.00 16.42           O  
ATOM   2579  CB  LEU C  84      15.233  84.535  75.099  1.00 15.47           C  
ATOM   2580  CG  LEU C  84      15.657  84.807  73.668  1.00 18.20           C  
ATOM   2581  CD1 LEU C  84      14.508  85.231  72.762  1.00 17.66           C  
ATOM   2582  CD2 LEU C  84      16.789  85.842  73.700  1.00 17.42           C  
ATOM   2583  N   LEU C  85      14.866  81.443  75.632  1.00 16.30           N  
ATOM   2584  CA  LEU C  85      15.107  80.051  75.276  1.00 15.28           C  
ATOM   2585  C   LEU C  85      13.825  79.215  75.112  1.00 16.27           C  
ATOM   2586  O   LEU C  85      13.715  78.470  74.159  1.00 17.14           O  
ATOM   2587  CB  LEU C  85      16.062  79.395  76.270  1.00 15.87           C  
ATOM   2588  CG  LEU C  85      17.513  79.914  76.283  1.00 15.79           C  
ATOM   2589  CD1 LEU C  85      18.244  79.487  77.560  1.00 14.57           C  
ATOM   2590  CD2 LEU C  85      18.255  79.385  75.001  1.00 18.26           C  
ATOM   2591  N   ILE C  86      12.837  79.365  76.002  1.00 16.30           N  
ATOM   2592  CA  ILE C  86      11.554  78.650  75.800  1.00 14.97           C  
ATOM   2593  C   ILE C  86      10.794  79.188  74.605  1.00 14.63           C  
ATOM   2594  O   ILE C  86      10.257  78.423  73.814  1.00 14.24           O  
ATOM   2595  CB  ILE C  86      10.669  78.601  77.096  1.00 16.64           C  
ATOM   2596  CG1 ILE C  86       9.429  77.698  76.890  1.00 20.18           C  
ATOM   2597  CG2 ILE C  86      10.231  79.984  77.539  1.00 14.17           C  
ATOM   2598  CD1 ILE C  86       9.756  76.276  76.594  1.00 26.72           C  
ATOM   2599  N   ARG C  87      10.770  80.513  74.428  1.00 15.15           N  
ATOM   2600  CA  ARG C  87      10.047  81.087  73.276  1.00 14.45           C  
ATOM   2601  C   ARG C  87      10.637  80.688  71.936  1.00 16.07           C  
ATOM   2602  O   ARG C  87       9.919  80.577  70.959  1.00 17.39           O  
ATOM   2603  CB  ARG C  87       9.979  82.609  73.382  1.00 15.06           C  
ATOM   2604  CG  ARG C  87       9.089  83.083  74.532  1.00 15.55           C  
ATOM   2605  CD  ARG C  87       7.619  83.000  74.167  1.00 20.23           C  
ATOM   2606  NE  ARG C  87       7.321  83.651  72.887  1.00 23.64           N  
ATOM   2607  CZ  ARG C  87       7.162  84.956  72.729  1.00 25.94           C  
ATOM   2608  NH1 ARG C  87       7.305  85.789  73.751  1.00 23.80           N  
ATOM   2609  NH2 ARG C  87       6.891  85.433  71.536  1.00 26.21           N  
ATOM   2610  N   THR C  88      11.935  80.422  71.894  1.00 14.47           N  
ATOM   2611  CA  THR C  88      12.577  79.977  70.656  1.00 14.80           C  
ATOM   2612  C   THR C  88      12.842  78.452  70.604  1.00 15.68           C  
ATOM   2613  O   THR C  88      13.548  77.993  69.724  1.00 16.92           O  
ATOM   2614  CB  THR C  88      13.883  80.746  70.428  1.00 15.41           C  
ATOM   2615  OG1 THR C  88      14.747  80.596  71.565  1.00 15.83           O  
ATOM   2616  CG2 THR C  88      13.586  82.229  70.201  1.00 16.01           C  
ATOM   2617  N   GLU C  89      12.249  77.692  71.520  1.00 15.62           N  
ATOM   2618  CA  GLU C  89      12.208  76.233  71.468  1.00 17.62           C  
ATOM   2619  C   GLU C  89      13.567  75.550  71.675  1.00 15.94           C  
ATOM   2620  O   GLU C  89      13.747  74.378  71.307  1.00 18.32           O  
ATOM   2621  CB  GLU C  89      11.505  75.754  70.196  1.00 16.41           C  
ATOM   2622  CG  GLU C  89      10.056  76.325  70.074  1.00 20.10           C  
ATOM   2623  CD  GLU C  89       9.365  75.986  68.762  1.00 23.51           C  
ATOM   2624  OE1 GLU C  89       9.809  75.060  68.062  1.00 31.46           O  
ATOM   2625  OE2 GLU C  89       8.373  76.653  68.448  1.00 33.90           O  
ATOM   2626  N   TYR C  90      14.493  76.270  72.300  1.00 16.54           N  
ATOM   2627  CA  TYR C  90      15.767  75.675  72.724  1.00 16.23           C  
ATOM   2628  C   TYR C  90      15.649  74.812  73.973  1.00 17.73           C  
ATOM   2629  O   TYR C  90      16.453  73.915  74.175  1.00 19.40           O  
ATOM   2630  CB  TYR C  90      16.860  76.737  72.880  1.00 17.84           C  
ATOM   2631  CG  TYR C  90      17.419  77.114  71.540  1.00 17.69           C  
ATOM   2632  CD1 TYR C  90      18.420  76.342  70.943  1.00 19.77           C  
ATOM   2633  CD2 TYR C  90      16.940  78.215  70.854  1.00 20.99           C  
ATOM   2634  CE1 TYR C  90      18.921  76.666  69.668  1.00 22.42           C  
ATOM   2635  CE2 TYR C  90      17.415  78.545  69.569  1.00 19.45           C  
ATOM   2636  CZ  TYR C  90      18.417  77.774  68.997  1.00 24.91           C  
ATOM   2637  OH  TYR C  90      18.918  78.138  67.758  1.00 28.33           O  
ATOM   2638  N   ILE C  91      14.653  75.080  74.806  1.00 18.19           N  
ATOM   2639  CA  ILE C  91      14.357  74.236  75.966  1.00 17.06           C  
ATOM   2640  C   ILE C  91      12.861  73.929  75.986  1.00 17.43           C  
ATOM   2641  O   ILE C  91      12.035  74.691  75.421  1.00 18.93           O  
ATOM   2642  CB  ILE C  91      14.761  74.897  77.300  1.00 15.18           C  
ATOM   2643  CG1 ILE C  91      14.046  76.252  77.492  1.00 17.55           C  
ATOM   2644  CG2 ILE C  91      16.319  74.995  77.414  1.00 18.21           C  
ATOM   2645  CD1 ILE C  91      14.308  76.861  78.853  1.00 14.73           C  
ATOM   2646  N   THR C  92      12.503  72.794  76.609  1.00 18.31           N  
ATOM   2647  CA  THR C  92      11.112  72.380  76.722  1.00 19.61           C  
ATOM   2648  C   THR C  92      10.416  73.186  77.805  1.00 18.34           C  
ATOM   2649  O   THR C  92      11.074  73.821  78.623  1.00 17.64           O  
ATOM   2650  CB  THR C  92      11.008  70.871  77.103  1.00 20.30           C  
ATOM   2651  OG1 THR C  92      11.571  70.666  78.409  1.00 19.12           O  
ATOM   2652  CG2 THR C  92      11.765  70.002  76.109  1.00 21.79           C  
ATOM   2653  N   ARG C  93       9.087  73.129  77.845  1.00 20.38           N  
ATOM   2654  CA  ARG C  93       8.343  73.823  78.896  1.00 19.52           C  
ATOM   2655  C   ARG C  93       8.715  73.254  80.260  1.00 17.92           C  
ATOM   2656  O   ARG C  93       8.812  73.988  81.237  1.00 18.71           O  
ATOM   2657  CB  ARG C  93       6.828  73.723  78.644  1.00 21.52           C  
ATOM   2658  CG  ARG C  93       5.937  74.219  79.790  1.00 31.08           C  
ATOM   2659  CD  ARG C  93       6.114  75.690  80.131  1.00 43.16           C  
ATOM   2660  NE  ARG C  93       5.704  76.600  79.062  1.00 48.75           N  
ATOM   2661  CZ  ARG C  93       5.548  77.917  79.209  1.00 49.47           C  
ATOM   2662  NH1 ARG C  93       5.751  78.505  80.384  1.00 49.14           N  
ATOM   2663  NH2 ARG C  93       5.174  78.658  78.174  1.00 49.60           N  
ATOM   2664  N   GLU C  94       8.964  71.946  80.312  1.00 17.74           N  
ATOM   2665  CA  GLU C  94       9.389  71.271  81.552  1.00 21.37           C  
ATOM   2666  C   GLU C  94      10.717  71.788  82.047  1.00 18.66           C  
ATOM   2667  O   GLU C  94      10.896  72.050  83.252  1.00 20.09           O  
ATOM   2668  CB  GLU C  94       9.503  69.758  81.327  1.00 21.39           C  
ATOM   2669  CG  GLU C  94       9.841  68.966  82.569  1.00 28.51           C  
ATOM   2670  CD  GLU C  94      10.052  67.467  82.302  1.00 31.19           C  
ATOM   2671  OE1 GLU C  94       9.931  67.013  81.137  1.00 30.01           O  
ATOM   2672  OE2 GLU C  94      10.358  66.741  83.282  1.00 41.47           O  
ATOM   2673  N   GLN C  95      11.667  71.943  81.131  1.00 18.29           N  
ATOM   2674  CA  GLN C  95      12.972  72.479  81.500  1.00 17.99           C  
ATOM   2675  C   GLN C  95      12.828  73.923  81.986  1.00 16.39           C  
ATOM   2676  O   GLN C  95      13.380  74.299  83.025  1.00 16.49           O  
ATOM   2677  CB  GLN C  95      13.965  72.399  80.333  1.00 19.42           C  
ATOM   2678  CG  GLN C  95      14.473  71.001  80.004  1.00 20.23           C  
ATOM   2679  CD  GLN C  95      15.274  70.961  78.698  1.00 22.30           C  
ATOM   2680  OE1 GLN C  95      14.768  71.341  77.638  1.00 20.10           O  
ATOM   2681  NE2 GLN C  95      16.532  70.500  78.774  1.00 24.98           N  
ATOM   2682  N   TYR C  96      12.076  74.701  81.221  1.00 15.72           N  
ATOM   2683  CA  TYR C  96      11.841  76.108  81.547  1.00 16.57           C  
ATOM   2684  C   TYR C  96      11.271  76.253  82.955  1.00 16.75           C  
ATOM   2685  O   TYR C  96      11.834  76.976  83.800  1.00 16.13           O  
ATOM   2686  CB  TYR C  96      10.886  76.744  80.528  1.00 18.01           C  
ATOM   2687  CG  TYR C  96      10.503  78.151  80.933  1.00 16.27           C  
ATOM   2688  CD1 TYR C  96      11.421  79.192  80.840  1.00 15.30           C  
ATOM   2689  CD2 TYR C  96       9.236  78.440  81.418  1.00 22.19           C  
ATOM   2690  CE1 TYR C  96      11.094  80.481  81.231  1.00 21.80           C  
ATOM   2691  CE2 TYR C  96       8.889  79.747  81.808  1.00 24.70           C  
ATOM   2692  CZ  TYR C  96       9.835  80.756  81.717  1.00 22.77           C  
ATOM   2693  OH  TYR C  96       9.527  82.057  82.092  1.00 22.25           O  
ATOM   2694  N   GLU C  97      10.161  75.562  83.213  1.00 17.01           N  
ATOM   2695  CA  GLU C  97       9.463  75.720  84.487  1.00 17.48           C  
ATOM   2696  C   GLU C  97      10.343  75.320  85.654  1.00 17.84           C  
ATOM   2697  O   GLU C  97      10.380  76.012  86.654  1.00 17.83           O  
ATOM   2698  CB  GLU C  97       8.145  74.951  84.503  1.00 17.92           C  
ATOM   2699  CG  GLU C  97       7.121  75.594  83.585  1.00 19.54           C  
ATOM   2700  CD  GLU C  97       5.696  75.136  83.827  1.00 27.75           C  
ATOM   2701  OE1 GLU C  97       5.479  74.094  84.498  1.00 31.95           O  
ATOM   2702  OE2 GLU C  97       4.787  75.834  83.324  1.00 33.38           O  
ATOM   2703  N   SER C  98      11.053  74.207  85.509  1.00 17.56           N  
ATOM   2704  CA  SER C  98      11.913  73.698  86.564  1.00 17.82           C  
ATOM   2705  C   SER C  98      12.999  74.698  86.950  1.00 17.71           C  
ATOM   2706  O   SER C  98      13.178  74.993  88.126  1.00 17.86           O  
ATOM   2707  CB  SER C  98      12.539  72.374  86.113  1.00 18.03           C  
ATOM   2708  OG  SER C  98      13.267  71.768  87.164  1.00 18.80           O  
ATOM   2709  N   ILE C  99      13.701  75.227  85.953  1.00 17.32           N  
ATOM   2710  CA  ILE C  99      14.858  76.087  86.184  1.00 18.86           C  
ATOM   2711  C   ILE C  99      14.359  77.472  86.570  1.00 19.02           C  
ATOM   2712  O   ILE C  99      14.889  78.099  87.485  1.00 18.21           O  
ATOM   2713  CB  ILE C  99      15.797  76.156  84.943  1.00 17.40           C  
ATOM   2714  CG1 ILE C  99      16.311  74.770  84.596  1.00 20.71           C  
ATOM   2715  CG2 ILE C  99      16.966  77.073  85.209  1.00 21.58           C  
ATOM   2716  CD1 ILE C  99      16.998  74.685  83.243  1.00 23.82           C  
ATOM   2717  N   ASN C 100      13.308  77.939  85.904  1.00 19.27           N  
ATOM   2718  CA  ASN C 100      12.798  79.276  86.194  1.00 17.76           C  
ATOM   2719  C   ASN C 100      12.203  79.391  87.599  1.00 18.82           C  
ATOM   2720  O   ASN C 100      12.321  80.430  88.237  1.00 19.28           O  
ATOM   2721  CB  ASN C 100      11.769  79.710  85.148  1.00 20.04           C  
ATOM   2722  CG  ASN C 100      11.378  81.173  85.297  1.00 19.73           C  
ATOM   2723  OD1 ASN C 100      12.190  82.065  85.066  1.00 25.82           O  
ATOM   2724  ND2 ASN C 100      10.139  81.420  85.690  1.00 30.01           N  
ATOM   2725  N   ASN C 101      11.569  78.327  88.072  1.00 17.55           N  
ATOM   2726  CA  ASN C 101      11.037  78.290  89.421  1.00 17.71           C  
ATOM   2727  C   ASN C 101      12.159  78.394  90.445  1.00 18.80           C  
ATOM   2728  O   ASN C 101      12.007  79.076  91.446  1.00 17.55           O  
ATOM   2729  CB  ASN C 101      10.241  77.010  89.658  1.00 18.71           C  
ATOM   2730  CG  ASN C 101       8.872  77.043  89.008  1.00 21.23           C  
ATOM   2731  OD1 ASN C 101       8.396  78.105  88.581  1.00 25.78           O  
ATOM   2732  ND2 ASN C 101       8.234  75.878  88.914  1.00 22.27           N  
ATOM   2733  N   ASP C 102      13.289  77.740  90.185  1.00 19.88           N  
ATOM   2734  CA  ASP C 102      14.446  77.866  91.079  1.00 18.06           C  
ATOM   2735  C   ASP C 102      15.002  79.304  91.057  1.00 18.59           C  
ATOM   2736  O   ASP C 102      15.437  79.845  92.097  1.00 18.59           O  
ATOM   2737  CB  ASP C 102      15.528  76.853  90.688  1.00 17.27           C  
ATOM   2738  CG  ASP C 102      15.174  75.424  91.063  1.00 19.40           C  
ATOM   2739  OD1 ASP C 102      14.151  75.226  91.735  1.00 19.83           O  
ATOM   2740  OD2 ASP C 102      15.956  74.493  90.729  1.00 20.83           O  
ATOM   2741  N   SER C 103      15.027  79.902  89.869  1.00 17.93           N  
ATOM   2742  CA  SER C 103      15.503  81.285  89.702  1.00 17.89           C  
ATOM   2743  C   SER C 103      14.637  82.246  90.482  1.00 20.50           C  
ATOM   2744  O   SER C 103      15.129  83.080  91.253  1.00 22.50           O  
ATOM   2745  CB  SER C 103      15.552  81.678  88.222  1.00 22.08           C  
ATOM   2746  OG  SER C 103      16.540  82.686  88.003  1.00 24.98           O  
ATOM   2747  N   THR C 104      13.328  82.098  90.336  1.00 20.96           N  
ATOM   2748  CA  THR C 104      12.421  83.067  90.914  1.00 20.74           C  
ATOM   2749  C   THR C 104      12.346  82.905  92.443  1.00 20.21           C  
ATOM   2750  O   THR C 104      12.108  83.877  93.180  1.00 19.55           O  
ATOM   2751  CB  THR C 104      11.039  83.007  90.228  1.00 22.25           C  
ATOM   2752  OG1 THR C 104      10.527  81.683  90.303  1.00 26.42           O  
ATOM   2753  CG2 THR C 104      11.159  83.392  88.759  1.00 22.12           C  
ATOM   2754  N   GLU C 105      12.579  81.686  92.928  1.00 21.52           N  
ATOM   2755  CA  GLU C 105      12.736  81.462  94.370  1.00 21.74           C  
ATOM   2756  C   GLU C 105      13.880  82.309  94.916  1.00 19.79           C  
ATOM   2757  O   GLU C 105      13.782  82.848  96.002  1.00 22.00           O  
ATOM   2758  CB  GLU C 105      12.983  79.977  94.656  1.00 22.07           C  
ATOM   2759  CG  GLU C 105      13.265  79.643  96.103  1.00 25.32           C  
ATOM   2760  CD  GLU C 105      13.508  78.149  96.330  1.00 28.43           C  
ATOM   2761  OE1 GLU C 105      14.042  77.467  95.417  1.00 26.80           O  
ATOM   2762  OE2 GLU C 105      13.152  77.656  97.423  1.00 34.02           O  
ATOM   2763  N   ILE C 106      14.986  82.402  94.166  1.00 19.89           N  
ATOM   2764  CA  ILE C 106      16.131  83.215  94.575  1.00 19.64           C  
ATOM   2765  C   ILE C 106      15.792  84.706  94.553  1.00 19.76           C  
ATOM   2766  O   ILE C 106      16.169  85.444  95.481  1.00 17.44           O  
ATOM   2767  CB  ILE C 106      17.404  82.881  93.716  1.00 18.63           C  
ATOM   2768  CG1 ILE C 106      17.919  81.484  94.069  1.00 20.64           C  
ATOM   2769  CG2 ILE C 106      18.504  83.942  93.869  1.00 20.84           C  
ATOM   2770  CD1 ILE C 106      18.947  80.954  93.102  1.00 19.98           C  
ATOM   2771  N   ASN C 107      15.071  85.150  93.520  1.00 19.60           N  
ATOM   2772  CA  ASN C 107      14.565  86.526  93.483  1.00 20.10           C  
ATOM   2773  C   ASN C 107      13.857  86.915  94.784  1.00 20.43           C  
ATOM   2774  O   ASN C 107      14.104  87.973  95.368  1.00 20.34           O  
ATOM   2775  CB  ASN C 107      13.548  86.701  92.362  1.00 19.61           C  
ATOM   2776  CG  ASN C 107      14.176  86.809  91.003  1.00 22.88           C  
ATOM   2777  OD1 ASN C 107      15.163  86.154  90.712  1.00 26.97           O  
ATOM   2778  ND2 ASN C 107      13.586  87.647  90.145  1.00 29.35           N  
ATOM   2779  N   LYS C 108      12.962  86.036  95.211  1.00 20.40           N  
ATOM   2780  CA  LYS C 108      12.069  86.298  96.337  1.00 21.97           C  
ATOM   2781  C   LYS C 108      12.884  86.475  97.624  1.00 21.95           C  
ATOM   2782  O   LYS C 108      12.660  87.411  98.401  1.00 21.97           O  
ATOM   2783  CB  LYS C 108      11.115  85.120  96.456  1.00 23.26           C  
ATOM   2784  CG  LYS C 108      10.084  85.217  97.552  1.00 24.31           C  
ATOM   2785  CD  LYS C 108       9.250  83.943  97.619  1.00 28.75           C  
ATOM   2786  CE  LYS C 108      10.118  82.708  97.803  1.00 30.41           C  
ATOM   2787  NZ  LYS C 108       9.506  81.707  98.709  1.00 30.01           N  
ATOM   2788  N   LEU C 109      13.845  85.580  97.833  1.00 20.63           N  
ATOM   2789  CA  LEU C 109      14.667  85.627  99.034  1.00 21.02           C  
ATOM   2790  C   LEU C 109      15.567  86.879  99.030  1.00 21.58           C  
ATOM   2791  O   LEU C 109      15.696  87.588 100.054  1.00 19.57           O  
ATOM   2792  CB  LEU C 109      15.503  84.350  99.126  1.00 21.79           C  
ATOM   2793  CG  LEU C 109      14.684  83.056  99.254  1.00 23.54           C  
ATOM   2794  CD1 LEU C 109      15.539  81.787  99.048  1.00 22.13           C  
ATOM   2795  CD2 LEU C 109      13.991  83.043 100.606  1.00 25.18           C  
ATOM   2796  N   LEU C 110      16.172  87.170  97.873  1.00 19.82           N  
ATOM   2797  CA  LEU C 110      17.010  88.372  97.773  1.00 20.42           C  
ATOM   2798  C   LEU C 110      16.215  89.640  98.061  1.00 19.80           C  
ATOM   2799  O   LEU C 110      16.669  90.528  98.788  1.00 22.32           O  
ATOM   2800  CB  LEU C 110      17.673  88.476  96.409  1.00 18.12           C  
ATOM   2801  CG  LEU C 110      18.706  87.398  96.090  1.00 17.60           C  
ATOM   2802  CD1 LEU C 110      19.020  87.452  94.599  1.00 20.47           C  
ATOM   2803  CD2 LEU C 110      19.966  87.591  96.924  1.00 17.92           C  
ATOM   2804  N   ILE C 111      15.002  89.708  97.533  1.00 21.92           N  
ATOM   2805  CA  ILE C 111      14.169  90.885  97.755  1.00 21.38           C  
ATOM   2806  C   ILE C 111      13.811  91.036  99.236  1.00 23.70           C  
ATOM   2807  O   ILE C 111      13.839  92.156  99.789  1.00 24.04           O  
ATOM   2808  CB  ILE C 111      12.903  90.857  96.877  1.00 21.16           C  
ATOM   2809  CG1 ILE C 111      13.303  91.058  95.415  1.00 22.95           C  
ATOM   2810  CG2 ILE C 111      11.907  91.956  97.335  1.00 21.38           C  
ATOM   2811  CD1 ILE C 111      12.283  90.575  94.420  1.00 23.81           C  
ATOM   2812  N   SER C 112      13.502  89.917  99.890  1.00 24.58           N  
ATOM   2813  CA  SER C 112      13.165  89.927 101.311  0.50 25.92           C  
ATOM   2815  C   SER C 112      14.319  90.493 102.130  1.00 25.29           C  
ATOM   2816  O   SER C 112      14.154  91.433 102.899  1.00 23.38           O  
ATOM   2817  CB  SER C 112      12.835  88.511 101.794  0.50 27.19           C  
ATOM   2819  OG  SER C 112      12.347  88.532 103.122  0.50 27.48           O  
ATOM   2821  N   ILE C 113      15.496  89.916 101.952  1.00 22.92           N  
ATOM   2822  CA  ILE C 113      16.680  90.393 102.645  1.00 23.36           C  
ATOM   2823  C   ILE C 113      16.852  91.901 102.378  1.00 24.33           C  
ATOM   2824  O   ILE C 113      16.909  92.722 103.312  1.00 24.15           O  
ATOM   2825  CB  ILE C 113      17.926  89.619 102.184  1.00 21.81           C  
ATOM   2826  CG1 ILE C 113      17.852  88.157 102.644  1.00 22.61           C  
ATOM   2827  CG2 ILE C 113      19.194  90.274 102.712  1.00 21.42           C  
ATOM   2828  CD1 ILE C 113      18.708  87.222 101.838  1.00 23.14           C  
ATOM   2829  N   ILE C 114      16.880  92.263 101.098  1.00 23.34           N  
ATOM   2830  CA  ILE C 114      17.125  93.647 100.691  1.00 24.57           C  
ATOM   2831  C   ILE C 114      16.108  94.600 101.308  1.00 27.84           C  
ATOM   2832  O   ILE C 114      16.472  95.679 101.792  1.00 28.86           O  
ATOM   2833  CB  ILE C 114      17.120  93.795  99.161  1.00 24.96           C  
ATOM   2834  CG1 ILE C 114      18.343  93.075  98.574  1.00 23.79           C  
ATOM   2835  CG2 ILE C 114      17.127  95.291  98.766  1.00 23.89           C  
ATOM   2836  CD1 ILE C 114      18.205  92.675  97.117  1.00 22.53           C  
ATOM   2837  N   LYS C 115      14.848  94.175 101.315  1.00 29.84           N  
ATOM   2838  CA  LYS C 115      13.749  94.968 101.841  1.00 31.09           C  
ATOM   2839  C   LYS C 115      13.623  94.838 103.367  1.00 33.36           C  
ATOM   2840  O   LYS C 115      13.045  95.710 104.020  1.00 34.87           O  
ATOM   2841  CB  LYS C 115      12.448  94.556 101.143  1.00 30.25           C  
ATOM   2842  N   THR C 116      14.167  93.763 103.934  1.00 35.39           N  
ATOM   2843  CA  THR C 116      14.083  93.510 105.371  1.00 37.06           C  
ATOM   2844  C   THR C 116      14.934  94.498 106.164  1.00 37.88           C  
ATOM   2845  O   THR C 116      15.293  94.238 107.314  1.00 40.22           O  
ATOM   2846  CB  THR C 116      14.538  92.076 105.728  1.00 36.96           C  
TER    2847      THR C 116                                                      
END
MOLECULE T0478_138_267.pdb
ATOM   1121  N   ASP   138      15.040  81.714 110.368  1.00 45.58          
ATOM   1122  CA  ASP   138      16.230  82.548 110.663  1.00 45.87          
ATOM   1123  C   ASP   138      15.852  84.016 110.769  1.00 45.10          
ATOM   1124  O   ASP   138      14.864  84.433 110.134  1.00 44.87          
ATOM   1125  CB  ASP   138      17.257  82.385 109.544  1.00 46.10          
ATOM   1126  CG  ASP   138      17.911  81.008 109.553  1.00 49.57          
ATOM   1127  OD1 ASP   138      18.669  80.727 110.517  1.00 49.14          
ATOM   1128  OD2 ASP   138      17.655  80.213 108.601  1.00 52.78          
ATOM   1129  N   ALA   139      16.613  84.786 111.564  1.00 43.27          
ATOM   1130  CA  ALA   139      16.452  86.237 111.613  1.00 42.60          
ATOM   1131  C   ALA   139      16.934  86.838 110.292  1.00 43.26          
ATOM   1132  O   ALA   139      17.769  86.235 109.618  1.00 43.42          
ATOM   1133  CB  ALA   139      17.218  86.844 112.770  1.00 41.93          
ATOM   1134  N   LEU   140      16.423  88.024 109.934  1.00 42.66          
ATOM   1135  CA  LEU   140      16.670  88.601 108.620  1.00 42.23          
ATOM   1136  C   LEU   140      18.154  88.621 108.146  1.00 41.65          
ATOM   1137  O   LEU   140      18.440  88.253 107.016  1.00 41.90          
ATOM   1138  CB  LEU   140      15.984  89.965 108.503  1.00 42.36          
ATOM   1139  CG  LEU   140      16.203  90.730 107.186  1.00 43.56          
ATOM   1140  CD1 LEU   140      15.427  90.137 106.035  1.00 40.46          
ATOM   1141  CD2 LEU   140      15.881  92.201 107.320  1.00 43.67          
ATOM   1142  N   PRO   141      19.106  89.030 109.004  1.00 41.42          
ATOM   1143  CA  PRO   141      20.469  89.087 108.466  1.00 41.37          
ATOM   1144  C   PRO   141      21.064  87.712 108.067  1.00 41.50          
ATOM   1145  O   PRO   141      21.768  87.599 107.049  1.00 40.11          
ATOM   1146  CB  PRO   141      21.291  89.741 109.596  1.00 41.72          
ATOM   1147  CG  PRO   141      20.341  90.185 110.620  1.00 41.83          
ATOM   1148  CD  PRO   141      19.032  89.459 110.412  1.00 40.93          
ATOM   1149  N   ASP   142      20.787  86.690 108.873  1.00 41.36          
ATOM   1150  CA  ASP   142      21.047  85.300 108.498  1.00 41.77          
ATOM   1151  C   ASP   142      20.293  84.742 107.308  1.00 40.91          
ATOM   1152  O   ASP   142      20.852  83.956 106.554  1.00 41.00          
ATOM   1153  CB  ASP   142      20.723  84.409 109.665  1.00 42.77          
ATOM   1154  CG  ASP   142      21.879  84.296 110.579  1.00 47.80          
ATOM   1155  OD1 ASP   142      22.791  83.493 110.242  1.00 53.89          
ATOM   1156  OD2 ASP   142      21.882  85.025 111.595  1.00 49.00          
ATOM   1157  N   ALA   143      19.012  85.078 107.186  1.00 39.57          
ATOM   1158  CA  ALA   143      18.239  84.595 106.090  1.00 38.75          
ATOM   1159  C   ALA   143      18.858  85.181 104.820  1.00 38.96          
ATOM   1160  O   ALA   143      18.996  84.506 103.828  1.00 39.36          
ATOM   1161  CB  ALA   143      16.796  85.020 106.243  1.00 38.14          
ATOM   1162  N   ILE   144      19.270  86.432 104.864  1.00 39.12          
ATOM   1163  CA  ILE   144      19.797  87.071 103.690  1.00 39.66          
ATOM   1164  C   ILE   144      21.048  86.334 103.234  1.00 40.81          
ATOM   1165  O   ILE   144      21.179  85.958 102.056  1.00 41.14          
ATOM   1166  CB  ILE   144      20.169  88.511 103.971  1.00 39.22          
ATOM   1167  CG1 ILE   144      18.916  89.387 104.041  1.00 40.15          
ATOM   1168  CG2 ILE   144      21.075  89.026 102.895  1.00 40.12          
ATOM   1169  CD  ILE   144      19.176  90.767 104.617  1.00 35.25          
ATOM   1170  N   ILE   145      21.974  86.114 104.155  1.00 40.49          
ATOM   1171  CA  ILE   145      23.184  85.440 103.770  1.00 41.50          
ATOM   1172  C   ILE   145      22.927  83.991 103.363  1.00 41.39          
ATOM   1173  O   ILE   145      23.310  83.567 102.282  1.00 41.80          
ATOM   1174  CB  ILE   145      24.299  85.506 104.856  1.00 41.78          
ATOM   1175  CG1 ILE   145      25.081  86.804 104.658  1.00 42.98          
ATOM   1176  CG2 ILE   145      25.230  84.333 104.646  1.00 41.68          
ATOM   1177  CD  ILE   145      26.028  87.196 105.784  1.00 44.38          
ATOM   1178  N   LYS   146      22.262  83.251 104.231  1.00 41.16          
ATOM   1179  CA  LYS   146      22.009  81.860 104.004  1.00 40.47          
ATOM   1180  C   LYS   146      21.234  81.527 102.725  1.00 40.27          
ATOM   1181  O   LYS   146      21.525  80.547 102.066  1.00 40.67          
ATOM   1182  CB  LYS   146      21.302  81.288 105.228  1.00 40.50          
ATOM   1183  CG  LYS   146      22.296  80.943 106.339  1.00 41.61          
ATOM   1184  CD  LYS   146      21.627  80.324 107.601  1.00 42.47          
ATOM   1185  CE  LYS   146      21.106  78.899 107.385  1.00 40.71          
ATOM   1186  NZ  LYS   146      20.212  78.492 108.538  1.00 43.00          
ATOM   1187  N   GLU   147      20.210  82.286 102.404  1.00 39.57          
ATOM   1188  CA  GLU   147      19.433  82.021 101.191  1.00 39.50          
ATOM   1189  C   GLU   147      20.244  82.372  99.929  1.00 38.54          
ATOM   1190  O   GLU   147      20.184  81.660  98.927  1.00 38.77          
ATOM   1191  CB  GLU   147      18.122  82.836 101.208  1.00 39.27          
ATOM   1192  CG  GLU   147      17.229  82.505 102.411  1.00 42.25          
ATOM   1193  CD  GLU   147      16.430  81.197 102.228  1.00 45.53          
ATOM   1194  OE1 GLU   147      15.624  80.866 103.127  1.00 47.81          
ATOM   1195  OE2 GLU   147      16.582  80.518 101.182  1.00 45.79          
ATOM   1196  N   ASN   148      21.001  83.464  99.966  1.00 36.99          
ATOM   1197  CA  ASN   148      21.768  83.827  98.793  1.00 35.95          
ATOM   1198  C   ASN   148      22.830  82.812  98.489  1.00 35.81          
ATOM   1199  O   ASN   148      22.930  82.379  97.387  1.00 36.79          
ATOM   1200  CB  ASN   148      22.328  85.237  98.897  1.00 35.42          
ATOM   1201  CG  ASN   148      21.300  86.302  98.535  1.00 36.15          
ATOM   1202  OD1 ASN   148      21.272  86.790  97.417  1.00 37.77          
ATOM   1203  ND2 ASN   148      20.434  86.648  99.480  1.00 38.10          
ATOM   1204  N   VAL   149      23.618  82.430  99.474  1.00 36.75          
ATOM   1205  CA  VAL   149      24.575  81.330  99.346  1.00 37.63          
ATOM   1206  C   VAL   149      23.926  80.060  98.773  1.00 38.22          
ATOM   1207  O   VAL   149      24.416  79.495  97.809  1.00 39.53          
ATOM   1208  CB  VAL   149      25.231  81.000 100.721  1.00 38.17          
ATOM   1209  CG1 VAL   149      25.993  79.701 100.654  1.00 37.22          
ATOM   1210  CG2 VAL   149      26.143  82.163 101.183  1.00 37.52          
ATOM   1211  N   PHE   150      22.807  79.616  99.322  1.00 37.55          
ATOM   1212  CA  PHE   150      22.133  78.480  98.730  1.00 36.83          
ATOM   1213  C   PHE   150      21.714  78.749  97.265  1.00 36.87          
ATOM   1214  O   PHE   150      22.089  77.989  96.374  1.00 36.79          
ATOM   1215  CB  PHE   150      20.935  78.035  99.579  1.00 35.87          
ATOM   1216  CG  PHE   150      19.984  77.085  98.862  1.00 36.96          
ATOM   1217  CD1 PHE   150      20.288  75.759  98.701  1.00 36.23          
ATOM   1218  CD2 PHE   150      18.759  77.526  98.386  1.00 39.93          
ATOM   1219  CE1 PHE   150      19.423  74.915  98.060  1.00 34.92          
ATOM   1220  CE2 PHE   150      17.886  76.664  97.739  1.00 37.78          
ATOM   1221  CZ  PHE   150      18.224  75.370  97.590  1.00 38.25          
ATOM   1222  N   PHE   151      20.952  79.819  97.004  1.00 36.72          
ATOM   1223  CA  PHE   151      20.297  80.025  95.688  1.00 35.51          
ATOM   1224  C   PHE   151      21.261  80.523  94.566  1.00 35.60          
ATOM   1225  O   PHE   151      21.074  80.213  93.396  1.00 34.93          
ATOM   1226  CB  PHE   151      19.151  81.014  95.838  1.00 35.96          
ATOM   1227  CG  PHE   151      17.837  80.401  96.208  1.00 37.00          
ATOM   1228  CD1 PHE   151      17.088  79.705  95.262  1.00 40.87          
ATOM   1229  CD2 PHE   151      17.306  80.562  97.485  1.00 37.73          
ATOM   1230  CE1 PHE   151      15.806  79.147  95.574  1.00 39.31          
ATOM   1231  CE2 PHE   151      16.053  80.019  97.818  1.00 36.20          
ATOM   1232  CZ  PHE   151      15.300  79.303  96.862  1.00 38.34          
ATOM   1233  N   LEU   152      22.318  81.265  94.915  1.00 35.36          
ATOM   1234  CA  LEU   152      23.317  81.637  93.899  1.00 35.09          
ATOM   1235  C   LEU   152      23.997  80.387  93.325  1.00 35.76          
ATOM   1236  O   LEU   152      24.300  80.341  92.126  1.00 37.03          
ATOM   1237  CB  LEU   152      24.353  82.631  94.435  1.00 34.49          
ATOM   1238  CG  LEU   152      23.815  84.011  94.851  1.00 36.42          
ATOM   1239  CD1 LEU   152      24.911  84.779  95.605  1.00 36.16          
ATOM   1240  CD2 LEU   152      23.169  84.855  93.648  1.00 28.34          
ATOM   1241  N   ARG   153      24.185  79.363  94.160  1.00 34.90          
ATOM   1242  CA  ARG   153      24.717  78.079  93.721  1.00 34.64          
ATOM   1243  C   ARG   153      23.680  77.360  92.802  1.00 34.38          
ATOM   1244  O   ARG   153      23.997  76.879  91.710  1.00 35.70          
ATOM   1245  CB  ARG   153      25.120  77.231  94.955  1.00 34.57          
ATOM   1246  CG  ARG   153      25.849  75.955  94.587  1.00 37.81          
ATOM   1247  CD  ARG   153      26.508  75.275  95.767  1.00 41.68          
ATOM   1248  NE  ARG   153      27.317  74.099  95.362  1.00 43.99          
ATOM   1249  CZ  ARG   153      27.835  73.213  96.221  1.00 43.27          
ATOM   1250  NH1 ARG   153      27.614  73.335  97.527  1.00 38.50          
ATOM   1251  NH2 ARG   153      28.547  72.183  95.784  1.00 43.56          
ATOM   1252  N   ILE   154      22.419  77.346  93.218  1.00 33.12          
ATOM   1253  CA  ILE   154      21.366  76.771  92.408  1.00 31.74          
ATOM   1254  C   ILE   154      21.323  77.412  90.994  1.00 31.97          
ATOM   1255  O   ILE   154      21.248  76.729  89.951  1.00 32.34          
ATOM   1256  CB  ILE   154      20.053  76.962  93.135  1.00 30.77          
ATOM   1257  CG1 ILE   154      20.000  76.138  94.457  1.00 29.63          
ATOM   1258  CG2 ILE   154      18.944  76.610  92.265  1.00 29.73          
ATOM   1259  CD  ILE   154      20.535  74.692  94.422  1.00 24.57          
ATOM   1260  N   MET   155      21.384  78.746  90.972  1.00 32.10          
ATOM   1261  CA  MET   155      21.431  79.512  89.756  1.00 30.15          
ATOM   1262  C   MET   155      22.658  79.205  88.929  1.00 30.64          
ATOM   1263  O   MET   155      22.579  79.190  87.718  1.00 30.42          
ATOM   1264  CB  MET   155      21.380  81.023  90.085  1.00 31.10          
ATOM   1265  CG  MET   155      20.094  81.570  90.736  1.00 30.70          
ATOM   1266  SD  MET   155      18.594  81.405  89.759  1.00 29.53          
ATOM   1267  CE  MET   155      17.743  80.027  90.556  1.00 33.00          
ATOM   1268  N   ALA   156      23.823  79.023  89.559  1.00 31.11          
ATOM   1269  CA  ALA   156      25.064  78.832  88.800  1.00 30.95          
ATOM   1270  C   ALA   156      25.024  77.445  88.206  1.00 31.71          
ATOM   1271  O   ALA   156      25.444  77.237  87.077  1.00 32.16          
ATOM   1272  CB  ALA   156      26.307  78.968  89.721  1.00 30.67          
ATOM   1273  N   ASP   157      24.544  76.473  88.975  1.00 32.22          
ATOM   1274  CA  ASP   157      24.353  75.104  88.421  1.00 32.73          
ATOM   1275  C   ASP   157      23.394  75.154  87.200  1.00 32.59          
ATOM   1276  O   ASP   157      23.646  74.500  86.189  1.00 32.68          
ATOM   1277  CB  ASP   157      23.746  74.164  89.466  1.00 31.03          
ATOM   1278  CG  ASP   157      24.681  73.839  90.605  1.00 36.56          
ATOM   1279  OD1 ASP   157      25.935  74.093  90.550  1.00 33.08          
ATOM   1280  OD2 ASP   157      24.138  73.268  91.584  1.00 42.31          
ATOM   1281  N   HSD   158      22.263  75.862  87.317  1.00 32.58          
ATOM   1282  CA  HSD   158      21.267  75.865  86.212  1.00 33.67          
ATOM   1283  C   HSD   158      21.812  76.386  84.905  1.00 34.27          
ATOM   1284  O   HSD   158      21.474  75.891  83.859  1.00 36.41          
ATOM   1285  CB  HSD   158      20.048  76.710  86.541  1.00 33.62          
ATOM   1286  CG  HSD   158      19.214  76.152  87.644  1.00 35.35          
ATOM   1287  ND1 HSD   158      18.549  76.950  88.546  1.00 38.91          
ATOM   1288  CD2 HSD   158      18.948  74.878  88.003  1.00 34.79          
ATOM   1289  CE1 HSD   158      17.885  76.188  89.397  1.00 38.31          
ATOM   1290  NE2 HSD   158      18.142  74.926  89.112  1.00 37.21          
ATOM   1291  N   ALA   159      22.637  77.413  84.955  1.00 34.98          
ATOM   1292  CA  ALA   159      23.142  77.995  83.765  1.00 35.22          
ATOM   1293  C   ALA   159      24.129  77.008  83.120  1.00 36.05          
ATOM   1294  O   ALA   159      24.337  77.007  81.904  1.00 36.49          
ATOM   1295  CB  ALA   159      23.767  79.320  84.087  1.00 35.70          
ATOM   1296  N   LYS   160      24.704  76.105  83.900  1.00 36.27          
ATOM   1297  CA  LYS   160      25.509  75.037  83.237  1.00 36.63          
ATOM   1298  C   LYS   160      24.617  73.922  82.701  1.00 35.70          
ATOM   1299  O   LYS   160      24.758  73.460  81.592  1.00 36.30          
ATOM   1300  CB  LYS   160      26.550  74.460  84.187  1.00 37.31          
ATOM   1301  CG  LYS   160      27.457  75.480  84.775  1.00 36.11          
ATOM   1302  CD  LYS   160      28.391  74.850  85.757  1.00 36.24          
ATOM   1303  CE  LYS   160      29.345  75.881  86.264  1.00 39.40          
ATOM   1304  NZ  LYS   160      28.604  76.896  87.094  1.00 37.17          
ATOM   1305  N   PHE   161      23.653  73.512  83.483  1.00 35.63          
ATOM   1306  CA  PHE   161      22.675  72.581  82.967  1.00 35.34          
ATOM   1307  C   PHE   161      22.119  73.093  81.635  1.00 35.19          
ATOM   1308  O   PHE   161      21.964  72.347  80.685  1.00 37.17          
ATOM   1309  CB  PHE   161      21.547  72.339  83.984  1.00 34.81          
ATOM   1310  CG  PHE   161      22.021  71.846  85.329  1.00 34.67          
ATOM   1311  CD1 PHE   161      23.239  71.194  85.469  1.00 36.02          
ATOM   1312  CD2 PHE   161      21.214  71.986  86.469  1.00 35.90          
ATOM   1313  CE1 PHE   161      23.701  70.698  86.771  1.00 35.61          
ATOM   1314  CE2 PHE   161      21.650  71.517  87.745  1.00 33.40          
ATOM   1315  CZ  PHE   161      22.908  70.880  87.886  1.00 33.62          
ATOM   1316  N   ILE   162      21.851  74.379  81.514  1.00 34.48          
ATOM   1317  CA  ILE   162      21.309  74.876  80.247  1.00 32.33          
ATOM   1318  C   ILE   162      22.447  74.848  79.245  1.00 30.98          
ATOM   1319  O   ILE   162      22.325  74.305  78.154  1.00 30.63          
ATOM   1320  CB  ILE   162      20.722  76.327  80.448  1.00 33.26          
ATOM   1321  CG1 ILE   162      19.564  76.297  81.447  1.00 34.68          
ATOM   1322  CG2 ILE   162      20.358  76.974  79.123  1.00 31.44          
ATOM   1323  CD  ILE   162      18.934  77.711  81.788  1.00 35.43          
ATOM   1324  N   GLY   163      23.619  75.366  79.635  1.00 30.82          
ATOM   1325  CA  GLY   163      24.782  75.333  78.742  1.00 27.80          
ATOM   1326  C   GLY   163      25.039  73.968  78.160  1.00 28.42          
ATOM   1327  O   GLY   163      25.347  73.833  76.985  1.00 28.60          
ATOM   1328  N   HSD   164      24.953  72.936  78.990  1.00 29.19          
ATOM   1329  CA  HSD   164      25.325  71.574  78.557  1.00 30.68          
ATOM   1330  C   HSD   164      24.203  70.896  77.784  1.00 31.47          
ATOM   1331  O   HSD   164      24.481  70.107  76.912  1.00 33.24          
ATOM   1332  CB  HSD   164      25.735  70.692  79.767  1.00 30.09          
ATOM   1333  CG  HSD   164      27.095  71.029  80.305  1.00 31.98          
ATOM   1334  ND1 HSD   164      28.110  70.098  80.436  1.00 32.42          
ATOM   1335  CD2 HSD   164      27.611  72.213  80.715  1.00 32.58          
ATOM   1336  CE1 HSD   164      29.195  70.702  80.901  1.00 34.46          
ATOM   1337  NE2 HSD   164      28.920  71.988  81.077  1.00 34.48          
ATOM   1338  N   LEU   165      22.944  71.199  78.094  1.00 32.56          
ATOM   1339  CA  LEU   165      21.808  70.502  77.460  1.00 33.05          
ATOM   1340  C   LEU   165      21.272  71.157  76.160  1.00 33.28          
ATOM   1341  O   LEU   165      20.489  70.561  75.405  1.00 34.32          
ATOM   1342  CB  LEU   165      20.690  70.343  78.479  1.00 32.81          
ATOM   1343  CG  LEU   165      20.457  69.125  79.386  1.00 34.49          
ATOM   1344  CD1 LEU   165      21.306  67.844  79.081  1.00 32.26          
ATOM   1345  CD2 LEU   165      20.462  69.528  80.832  1.00 34.95          
ATOM   1346  N   LEU   166      21.654  72.395  75.920  1.00 33.15          
ATOM   1347  CA  LEU   166      21.511  72.994  74.596  1.00 32.58          
ATOM   1348  C   LEU   166      22.364  72.194  73.579  1.00 33.76          
ATOM   1349  O   LEU   166      23.492  71.737  73.907  1.00 33.94          
ATOM   1350  CB  LEU   166      21.950  74.474  74.605  1.00 31.30          
ATOM   1351  CG  LEU   166      20.999  75.521  75.206  1.00 29.39          
ATOM   1352  CD1 LEU   166      21.648  76.829  75.352  1.00 24.85          
ATOM   1353  CD2 LEU   166      19.784  75.714  74.283  1.00 30.49          
ATOM   1354  N   ASP   167      21.830  72.027  72.358  1.00 32.65          
ATOM   1355  CA  ASP   167      22.628  71.493  71.266  1.00 32.19          
ATOM   1356  C   ASP   167      23.824  72.408  71.053  1.00 32.14          
ATOM   1357  O   ASP   167      23.696  73.656  71.076  1.00 32.16          
ATOM   1358  CB  ASP   167      21.824  71.492  69.996  1.00 30.98          
ATOM   1359  CG  ASP   167      22.476  70.688  68.893  1.00 31.96          
ATOM   1360  OD1 ASP   167      22.556  69.443  69.019  1.00 33.21          
ATOM   1361  OD2 ASP   167      22.832  71.269  67.838  1.00 30.74          
ATOM   1362  N   PRO   168      24.978  71.806  70.801  1.00 31.53          
ATOM   1363  CA  PRO   168      26.215  72.554  70.679  1.00 30.56          
ATOM   1364  C   PRO   168      26.171  73.408  69.390  1.00 32.57          
ATOM   1365  O   PRO   168      27.052  74.254  69.167  1.00 31.61          
ATOM   1366  CB  PRO   168      27.278  71.441  70.596  1.00 30.40          
ATOM   1367  CG  PRO   168      26.651  70.245  71.230  1.00 27.00          
ATOM   1368  CD  PRO   168      25.203  70.345  70.805  1.00 31.70          
ATOM   1369  N   SER   169      25.159  73.185  68.532  1.00 31.56          
ATOM   1370  CA  SER   169      25.038  73.994  67.340  1.00 31.29          
ATOM   1371  C   SER   169      24.308  75.329  67.653  1.00 32.30          
ATOM   1372  O   SER   169      24.077  76.179  66.752  1.00 31.95          
ATOM   1373  CB  SER   169      24.237  73.235  66.289  1.00 30.78          
ATOM   1374  OG  SER   169      22.848  73.324  66.611  1.00 28.80          
ATOM   1375  N   GLU   170      23.889  75.497  68.904  1.00 32.65          
ATOM   1376  CA  GLU   170      23.224  76.755  69.287  1.00 32.83          
ATOM   1377  C   GLU   170      24.305  77.570  69.990  1.00 32.03          
ATOM   1378  O   GLU   170      24.282  77.721  71.229  1.00 30.62          
ATOM   1379  CB  GLU   170      22.015  76.517  70.220  1.00 33.20          
ATOM   1380  CG  GLU   170      20.883  75.742  69.599  1.00 35.37          
ATOM   1381  CD  GLU   170      19.964  76.628  68.732  1.00 41.36          
ATOM   1382  OE1 GLU   170      20.168  77.872  68.664  1.00 43.97          
ATOM   1383  OE2 GLU   170      19.011  76.093  68.114  1.00 44.29          
ATOM   1384  N   ARG   171      25.248  78.060  69.182  1.00 31.72          
ATOM   1385  CA  ARG   171      26.475  78.723  69.681  1.00 32.79          
ATOM   1386  C   ARG   171      26.165  80.011  70.422  1.00 33.01          
ATOM   1387  O   ARG   171      26.712  80.261  71.486  1.00 32.87          
ATOM   1388  CB  ARG   171      27.439  79.025  68.531  1.00 30.94          
ATOM   1389  CG  ARG   171      27.905  77.771  67.858  1.00 32.75          
ATOM   1390  CD  ARG   171      28.556  78.085  66.550  1.00 32.73          
ATOM   1391  NE  ARG   171      29.166  76.876  66.013  1.00 35.50          
ATOM   1392  CZ  ARG   171      30.458  76.565  66.178  1.00 38.36          
ATOM   1393  NH1 ARG   171      31.278  77.357  66.877  1.00 33.16          
ATOM   1394  NH2 ARG   171      30.938  75.457  65.632  1.00 40.49          
ATOM   1395  N   LYS   172      25.275  80.821  69.859  1.00 32.97          
ATOM   1396  CA  LYS   172      24.909  82.056  70.513  1.00 34.25          
ATOM   1397  C   LYS   172      24.342  81.787  71.903  1.00 33.89          
ATOM   1398  O   LYS   172      24.881  82.262  72.902  1.00 33.98          
ATOM   1399  CB  LYS   172      23.921  82.817  69.629  1.00 35.35          
ATOM   1400  CG  LYS   172      23.384  84.111  70.221  1.00 39.92          
ATOM   1401  CD  LYS   172      24.461  85.188  70.359  1.00 47.90          
ATOM   1402  CE  LYS   172      23.900  86.493  70.904  1.00 49.36          
ATOM   1403  NZ  LYS   172      25.027  87.256  71.473  1.00 49.88          
ATOM   1404  N   LEU   173      23.285  80.989  71.972  1.00 33.35          
ATOM   1405  CA  LEU   173      22.641  80.631  73.238  1.00 33.25          
ATOM   1406  C   LEU   173      23.532  79.883  74.239  1.00 33.27          
ATOM   1407  O   LEU   173      23.439  80.131  75.431  1.00 33.00          
ATOM   1408  CB  LEU   173      21.419  79.758  72.970  1.00 33.12          
ATOM   1409  CG  LEU   173      20.317  80.456  72.191  1.00 32.94          
ATOM   1410  CD1 LEU   173      19.218  79.434  71.998  1.00 34.36          
ATOM   1411  CD2 LEU   173      19.801  81.657  73.003  1.00 32.64          
ATOM   1412  N   VAL   174      24.336  78.927  73.763  1.00 34.48          
ATOM   1413  CA  VAL   174      25.307  78.254  74.618  1.00 33.90          
ATOM   1414  C   VAL   174      26.267  79.318  75.111  1.00 34.97          
ATOM   1415  O   VAL   174      26.691  79.272  76.255  1.00 36.03          
ATOM   1416  CB  VAL   174      26.139  77.181  73.888  1.00 34.54          
ATOM   1417  CG1 VAL   174      27.324  76.760  74.740  1.00 30.95          
ATOM   1418  CG2 VAL   174      25.303  75.937  73.518  1.00 32.91          
ATOM   1419  N   ASP   175      26.628  80.299  74.294  1.00 35.67          
ATOM   1420  CA  ASP   175      27.554  81.331  74.851  1.00 37.21          
ATOM   1421  C   ASP   175      26.879  82.176  75.943  1.00 36.14          
ATOM   1422  O   ASP   175      27.507  82.580  76.918  1.00 35.58          
ATOM   1423  CB  ASP   175      28.143  82.245  73.773  1.00 38.38          
ATOM   1424  CG  ASP   175      29.279  83.129  74.314  1.00 44.70          
ATOM   1425  OD1 ASP   175      30.366  82.564  74.644  1.00 49.80          
ATOM   1426  OD2 ASP   175      29.094  84.387  74.425  1.00 48.60          
ATOM   1427  N   THR   176      25.585  82.415  75.789  1.00 35.27          
ATOM   1428  CA  THR   176      24.882  83.205  76.754  1.00 35.40          
ATOM   1429  C   THR   176      24.768  82.411  78.053  1.00 35.65          
ATOM   1430  O   THR   176      25.034  82.936  79.136  1.00 35.72          
ATOM   1431  CB  THR   176      23.510  83.564  76.226  1.00 36.01          
ATOM   1432  OG1 THR   176      23.653  84.245  74.968  1.00 36.23          
ATOM   1433  CG2 THR   176      22.779  84.443  77.209  1.00 36.24          
ATOM   1434  N   ALA   177      24.408  81.135  77.945  1.00 34.29          
ATOM   1435  CA  ALA   177      24.355  80.297  79.127  1.00 33.58          
ATOM   1436  C   ALA   177      25.674  80.438  79.863  1.00 33.02          
ATOM   1437  O   ALA   177      25.669  80.730  81.033  1.00 33.97          
ATOM   1438  CB  ALA   177      24.076  78.848  78.778  1.00 31.83          
ATOM   1439  N   ARG   178      26.799  80.273  79.179  1.00 33.42          
ATOM   1440  CA  ARG   178      28.134  80.325  79.830  1.00 34.65          
ATOM   1441  C   ARG   178      28.415  81.645  80.542  1.00 34.04          
ATOM   1442  O   ARG   178      29.048  81.656  81.596  1.00 34.83          
ATOM   1443  CB  ARG   178      29.252  80.030  78.805  1.00 35.48          
ATOM   1444  CG  ARG   178      30.657  80.272  79.307  1.00 42.13          
ATOM   1445  CD  ARG   178      31.708  79.985  78.259  1.00 52.54          
ATOM   1446  NE  ARG   178      33.012  80.544  78.645  1.00 61.90          
ATOM   1447  CZ  ARG   178      33.348  81.845  78.583  1.00 65.37          
ATOM   1448  NH1 ARG   178      32.486  82.780  78.163  1.00 64.21          
ATOM   1449  NH2 ARG   178      34.562  82.226  78.961  1.00 66.87          
ATOM   1450  N   ASN   179      27.982  82.760  79.960  1.00 33.38          
ATOM   1451  CA  ASN   179      28.177  84.048  80.593  1.00 34.01          
ATOM   1452  C   ASN   179      27.398  84.153  81.920  1.00 33.84          
ATOM   1453  O   ASN   179      27.935  84.607  82.908  1.00 35.72          
ATOM   1454  CB  ASN   179      27.833  85.197  79.665  1.00 33.36          
ATOM   1455  CG  ASN   179      28.828  85.382  78.547  1.00 37.32          
ATOM   1456  OD1 ASN   179      30.026  85.050  78.652  1.00 37.85          
ATOM   1457  ND2 ASN   179      28.332  85.918  77.440  1.00 38.66          
ATOM   1458  N   PHE   180      26.146  83.717  81.952  1.00 33.49          
ATOM   1459  CA  PHE   180      25.408  83.617  83.182  1.00 32.38          
ATOM   1460  C   PHE   180      26.108  82.695  84.152  1.00 33.70          
ATOM   1461  O   PHE   180      26.207  83.002  85.334  1.00 33.37          
ATOM   1462  CB  PHE   180      24.027  83.053  82.908  1.00 31.91          
ATOM   1463  CG  PHE   180      23.066  84.092  82.432  1.00 31.48          
ATOM   1464  CD1 PHE   180      22.770  85.203  83.232  1.00 32.14          
ATOM   1465  CD2 PHE   180      22.529  84.022  81.202  1.00 26.73          
ATOM   1466  CE1 PHE   180      21.923  86.187  82.799  1.00 34.54          
ATOM   1467  CE2 PHE   180      21.644  85.036  80.764  1.00 31.39          
ATOM   1468  CZ  PHE   180      21.350  86.099  81.566  1.00 29.88          
ATOM   1469  N   SER   181      26.522  81.522  83.666  1.00 34.68          
ATOM   1470  CA  SER   181      27.215  80.570  84.524  1.00 35.67          
ATOM   1471  C   SER   181      28.416  81.250  85.211  1.00 35.74          
ATOM   1472  O   SER   181      28.569  81.100  86.414  1.00 36.52          
ATOM   1473  CB  SER   181      27.669  79.345  83.738  1.00 35.73          
ATOM   1474  OG  SER   181      28.551  78.609  84.547  1.00 34.10          
ATOM   1475  N   ASN   182      29.205  82.046  84.480  1.00 35.86          
ATOM   1476  CA  ASN   182      30.391  82.738  85.051  1.00 36.69          
ATOM   1477  C   ASN   182      29.987  83.863  86.021  1.00 38.32          
ATOM   1478  O   ASN   182      30.717  84.162  86.982  1.00 38.20          
ATOM   1479  CB  ASN   182      31.273  83.410  83.986  1.00 36.52          
ATOM   1480  CG  ASN   182      31.972  82.430  83.027  1.00 38.44          
ATOM   1481  OD1 ASN   182      32.539  82.847  81.993  1.00 37.99          
ATOM   1482  ND2 ASN   182      31.924  81.146  83.340  1.00 38.87          
ATOM   1483  N   ASP   183      28.852  84.511  85.751  1.00 39.08          
ATOM   1484  CA  ASP   183      28.392  85.639  86.557  1.00 39.96          
ATOM   1485  C   ASP   183      28.039  85.127  87.961  1.00 40.07          
ATOM   1486  O   ASP   183      28.444  85.696  89.000  1.00 39.11          
ATOM   1487  CB  ASP   183      27.150  86.262  85.908  1.00 40.86          
ATOM   1488  CG  ASP   183      27.493  87.238  84.783  1.00 45.25          
ATOM   1489  OD1 ASP   183      28.707  87.527  84.610  1.00 45.91          
ATOM   1490  OD2 ASP   183      26.539  87.731  84.082  1.00 48.29          
ATOM   1491  N   PHE   184      27.299  84.026  87.979  1.00 39.47          
ATOM   1492  CA  PHE   184      26.830  83.479  89.213  1.00 39.05          
ATOM   1493  C   PHE   184      27.918  82.736  89.942  1.00 38.90          
ATOM   1494  O   PHE   184      27.894  82.691  91.165  1.00 39.59          
ATOM   1495  CB  PHE   184      25.606  82.607  88.989  1.00 37.65          
ATOM   1496  CG  PHE   184      24.334  83.396  88.889  1.00 37.50          
ATOM   1497  CD1 PHE   184      23.638  83.762  90.038  1.00 36.68          
ATOM   1498  CD2 PHE   184      23.847  83.798  87.663  1.00 34.67          
ATOM   1499  CE1 PHE   184      22.459  84.505  89.960  1.00 38.45          
ATOM   1500  CE2 PHE   184      22.678  84.551  87.570  1.00 37.65          
ATOM   1501  CZ  PHE   184      21.966  84.885  88.714  1.00 38.28          
ATOM   1502  N   ASP   185      28.878  82.156  89.228  1.00 39.48          
ATOM   1503  CA  ASP   185      30.069  81.633  89.928  1.00 39.10          
ATOM   1504  C   ASP   185      30.528  82.759  90.798  1.00 39.43          
ATOM   1505  O   ASP   185      30.616  82.615  92.011  1.00 40.10          
ATOM   1506  CB  ASP   185      31.207  81.269  88.989  1.00 39.05          
ATOM   1507  CG  ASP   185      31.093  79.859  88.360  1.00 39.64          
ATOM   1508  OD1 ASP   185      30.115  79.131  88.621  1.00 37.88          
ATOM   1509  OD2 ASP   185      32.039  79.487  87.580  1.00 39.49          
ATOM   1510  N   GLU   186      30.774  83.905  90.168  1.00 39.75          
ATOM   1511  CA  GLU   186      31.296  85.114  90.811  1.00 40.52          
ATOM   1512  C   GLU   186      30.432  85.734  91.946  1.00 39.69          
ATOM   1513  O   GLU   186      30.945  86.148  92.961  1.00 38.66          
ATOM   1514  CB  GLU   186      31.510  86.168  89.741  1.00 41.03          
ATOM   1515  CG  GLU   186      32.791  86.940  89.926  1.00 47.44          
ATOM   1516  CD  GLU   186      32.787  88.269  89.173  1.00 52.24          
ATOM   1517  OE1 GLU   186      31.672  88.740  88.798  1.00 51.05          
ATOM   1518  OE2 GLU   186      33.910  88.808  88.951  1.00 51.48          
ATOM   1519  N   LEU   187      29.127  85.827  91.740  1.00 38.67          
ATOM   1520  CA  LEU   187      28.220  86.196  92.799  1.00 38.18          
ATOM   1521  C   LEU   187      28.222  85.220  93.996  1.00 38.61          
ATOM   1522  O   LEU   187      28.081  85.657  95.160  1.00 38.10          
ATOM   1523  CB  LEU   187      26.785  86.310  92.274  1.00 37.27          
ATOM   1524  CG  LEU   187      26.542  87.440  91.311  1.00 35.64          
ATOM   1525  CD1 LEU   187      25.082  87.438  91.017  1.00 32.83          
ATOM   1526  CD2 LEU   187      27.010  88.775  91.896  1.00 32.69          
ATOM   1527  N   MET   188      28.304  83.918  93.697  1.00 38.69          
ATOM   1528  CA  MET   188      28.411  82.890  94.730  1.00 38.71          
ATOM   1529  C   MET   188      29.705  83.062  95.510  1.00 39.32          
ATOM   1530  O   MET   188      29.726  82.902  96.737  1.00 39.80          
ATOM   1531  CB  MET   188      28.375  81.484  94.133  1.00 38.04          
ATOM   1532  CG  MET   188      28.173  80.339  95.144  1.00 40.86          
ATOM   1533  SD  MET   188      28.539  78.681  94.431  1.00 43.30          
ATOM   1534  CE  MET   188      30.320  78.859  94.404  1.00 46.35          
ATOM   1535  N   TYR   189      30.800  83.359  94.832  1.00 40.21          
ATOM   1536  CA  TYR   189      32.027  83.486  95.584  1.00 42.08          
ATOM   1537  C   TYR   189      32.004  84.764  96.421  1.00 41.58          
ATOM   1538  O   TYR   189      32.632  84.835  97.453  1.00 42.12          
ATOM   1539  CB  TYR   189      33.273  83.418  94.692  1.00 43.73          
ATOM   1540  CG  TYR   189      34.535  83.048  95.478  1.00 50.34          
ATOM   1541  CD1 TYR   189      34.632  83.301  96.860  1.00 54.83          
ATOM   1542  CD2 TYR   189      35.640  82.472  94.848  1.00 56.38          
ATOM   1543  CE1 TYR   189      35.775  82.978  97.583  1.00 57.35          
ATOM   1544  CE2 TYR   189      36.811  82.166  95.570  1.00 57.43          
ATOM   1545  CZ  TYR   189      36.862  82.423  96.928  1.00 59.03          
ATOM   1546  OH  TYR   189      38.007  82.124  97.631  1.00 61.19          
ATOM   1547  N   GLN   190      31.257  85.776  95.992  1.00 41.03          
ATOM   1548  CA  GLN   190      31.114  86.965  96.818  1.00 39.72          
ATOM   1549  C   GLN   190      30.346  86.605  98.085  1.00 39.37          
ATOM   1550  O   GLN   190      30.758  87.010  99.186  1.00 37.96          
ATOM   1551  CB  GLN   190      30.447  88.108  96.050  1.00 39.72          
ATOM   1552  CG  GLN   190      31.440  88.905  95.231  1.00 38.26          
ATOM   1553  CD  GLN   190      30.804  90.034  94.437  1.00 39.05          
ATOM   1554  OE1 GLN   190      31.490  90.928  93.947  1.00 41.43          
ATOM   1555  NE2 GLN   190      29.514  89.984  94.285  1.00 35.26          
ATOM   1556  N   ALA   191      29.270  85.815  97.938  1.00 38.03          
ATOM   1557  CA  ALA   191      28.482  85.386  99.104  1.00 38.87          
ATOM   1558  C   ALA   191      29.259  84.510 100.092  1.00 39.85          
ATOM   1559  O   ALA   191      29.055  84.588 101.282  1.00 38.77          
ATOM   1560  CB  ALA   191      27.154  84.683  98.689  1.00 38.51          
ATOM   1561  N   ILE   192      30.130  83.643  99.582  1.00 41.25          
ATOM   1562  CA  ILE   192      30.892  82.790 100.436  1.00 42.32          
ATOM   1563  C   ILE   192      31.748  83.678 101.322  1.00 42.19          
ATOM   1564  O   ILE   192      31.715  83.531 102.519  1.00 42.64          
ATOM   1565  CB  ILE   192      31.745  81.801  99.599  1.00 42.95          
ATOM   1566  CG1 ILE   192      30.828  80.762  98.944  1.00 45.21          
ATOM   1567  CG2 ILE   192      32.849  81.156 100.453  1.00 43.92          
ATOM   1568  CD  ILE   192      31.441  80.074  97.686  1.00 47.75          
ATOM   1569  N   ASP   193      32.516  84.587 100.737  1.00 42.40          
ATOM   1570  CA  ASP   193      33.291  85.540 101.509  1.00 42.90          
ATOM   1571  C   ASP   193      32.439  86.336 102.529  1.00 42.89          
ATOM   1572  O   ASP   193      32.834  86.490 103.699  1.00 40.18          
ATOM   1573  CB  ASP   193      34.045  86.471 100.568  1.00 43.55          
ATOM   1574  CG  ASP   193      35.323  85.810  99.974  1.00 47.26          
ATOM   1575  OD1 ASP   193      35.827  84.796 100.551  1.00 46.34          
ATOM   1576  OD2 ASP   193      35.809  86.312  98.929  1.00 48.52          
ATOM   1577  N   LEU   194      31.263  86.808 102.087  1.00 42.95          
ATOM   1578  CA  LEU   194      30.400  87.599 102.938  1.00 44.09          
ATOM   1579  C   LEU   194      30.038  86.730 104.110  1.00 44.61          
ATOM   1580  O   LEU   194      30.001  87.189 105.239  1.00 44.64          
ATOM   1581  CB  LEU   194      29.124  88.052 102.209  1.00 44.93          
ATOM   1582  CG  LEU   194      28.760  89.536 102.010  1.00 45.93          
ATOM   1583  CD1 LEU   194      27.233  89.759 102.174  1.00 47.95          
ATOM   1584  CD2 LEU   194      29.490  90.453 102.934  1.00 46.58          
ATOM   1585  N   GLU   195      29.816  85.451 103.842  1.00 45.17          
ATOM   1586  CA  GLU   195      29.312  84.527 104.837  1.00 45.91          
ATOM   1587  C   GLU   195      30.390  84.206 105.872  1.00 45.81          
ATOM   1588  O   GLU   195      30.115  84.066 107.071  1.00 46.65          
ATOM   1589  CB  GLU   195      28.876  83.265 104.127  1.00 46.65          
ATOM   1590  CG  GLU   195      27.681  82.589 104.714  1.00 50.58          
ATOM   1591  CD  GLU   195      28.028  81.275 105.326  1.00 58.14          
ATOM   1592  OE1 GLU   195      27.366  80.266 104.927  1.00 61.46          
ATOM   1593  OE2 GLU   195      28.966  81.260 106.179  1.00 59.12          
ATOM   1594  N   SER   196      31.622  84.096 105.398  1.00 44.54          
ATOM   1595  CA  SER   196      32.757  83.845 106.257  1.00 43.80          
ATOM   1596  C   SER   196      33.031  85.050 107.134  1.00 43.45          
ATOM   1597  O   SER   196      33.396  84.893 108.286  1.00 43.53          
ATOM   1598  CB  SER   196      33.964  83.507 105.405  1.00 43.50          
ATOM   1599  OG  SER   196      33.720  82.225 104.808  1.00 45.94          
ATOM   1600  N   MET   197      32.843  86.254 106.579  1.00 42.56          
ATOM   1601  CA  MET   197      33.071  87.479 107.312  1.00 41.22          
ATOM   1602  C   MET   197      31.934  87.793 108.266  1.00 42.25          
ATOM   1603  O   MET   197      31.901  88.889 108.857  1.00 43.38          
ATOM   1604  CB  MET   197      33.302  88.675 106.384  1.00 40.11          
ATOM   1605  CG  MET   197      34.582  88.638 105.607  1.00 34.85          
ATOM   1606  SD  MET   197      34.623  90.017 104.472  1.00 33.66          
ATOM   1607  CE  MET   197      36.086  89.700 103.497  1.00 37.50          
ATOM   1608  N   LYS   198      31.004  86.872 108.450  1.00 42.69          
ATOM   1609  CA  LYS   198      29.882  87.223 109.310  1.00 44.75          
ATOM   1610  C   LYS   198      30.295  86.867 110.743  1.00 45.33          
ATOM   1611  O   LYS   198      31.259  86.109 110.920  1.00 46.91          
ATOM   1612  CB  LYS   198      28.596  86.537 108.863  1.00 44.58          
ATOM   1613  CG  LYS   198      28.355  85.235 109.548  1.00 46.60          
ATOM   1614  CD  LYS   198      27.299  84.427 108.822  1.00 50.04          
ATOM   1615  CE  LYS   198      27.039  83.088 109.531  1.00 51.74          
ATOM   1616  NZ  LYS   198      25.586  82.727 109.360  1.00 55.90          
ATOM   1617  N   PRO   199      29.636  87.440 111.773  1.00 45.22          
ATOM   1618  CA  PRO   199      28.523  88.394 111.778  1.00 44.46          
ATOM   1619  C   PRO   199      28.969  89.850 111.553  1.00 43.69          
ATOM   1620  O   PRO   199      28.141  90.729 111.346  1.00 42.99          
ATOM   1621  CB  PRO   199      27.918  88.220 113.176  1.00 44.79          
ATOM   1622  CG  PRO   199      29.061  87.740 114.053  1.00 44.85          
ATOM   1623  CD  PRO   199      30.051  87.044 113.144  1.00 45.32          
ATOM   1624  N   GLN   200      30.271  90.092 111.563  1.00 42.76          
ATOM   1625  CA  GLN   200      30.782  91.399 111.243  1.00 42.96          
ATOM   1626  C   GLN   200      30.254  91.988 109.917  1.00 43.43          
ATOM   1627  O   GLN   200      30.135  93.202 109.777  1.00 44.10          
ATOM   1628  CB  GLN   200      32.307  91.348 111.162  1.00 42.74          
ATOM   1629  CG  GLN   200      33.016  91.223 112.501  1.00 43.69          
ATOM   1630  CD  GLN   200      32.928  89.821 113.123  1.00 44.22          
ATOM   1631  OE1 GLN   200      32.724  88.786 112.442  1.00 39.34          
ATOM   1632  NE2 GLN   200      33.072  89.793 114.433  1.00 42.79          
ATOM   1633  N   SER   201      29.995  91.148 108.915  1.00 42.82          
ATOM   1634  CA  SER   201      29.673  91.659 107.592  1.00 41.89          
ATOM   1635  C   SER   201      28.192  91.947 107.499  1.00 41.94          
ATOM   1636  O   SER   201      27.722  92.536 106.518  1.00 42.01          
ATOM   1637  CB  SER   201      30.054  90.621 106.518  1.00 40.83          
ATOM   1638  OG  SER   201      29.329  89.426 106.763  1.00 38.85          
ATOM   1639  N   GLN   202      27.441  91.482 108.493  1.00 41.86          
ATOM   1640  CA  GLN   202      25.974  91.594 108.455  1.00 40.97          
ATOM   1641  C   GLN   202      25.465  92.995 108.846  1.00 40.82          
ATOM   1642  O   GLN   202      24.464  93.132 109.579  1.00 40.14          
ATOM   1643  CB  GLN   202      25.353  90.491 109.300  1.00 40.56          
ATOM   1644  CG  GLN   202      25.626  89.134 108.715  1.00 41.93          
ATOM   1645  CD  GLN   202      25.092  87.989 109.533  1.00 44.61          
ATOM   1646  OE1 GLN   202      25.626  87.665 110.603  1.00 48.41          
ATOM   1647  NE2 GLN   202      24.049  87.341 109.023  1.00 45.84          
ATOM   1648  N   THR   203      26.165  94.026 108.353  1.00 39.98          
ATOM   1649  CA  THR   203      25.714  95.415 108.489  1.00 39.52          
ATOM   1650  C   THR   203      24.626  95.644 107.443  1.00 40.21          
ATOM   1651  O   THR   203      24.617  94.993 106.403  1.00 40.13          
ATOM   1652  CB  THR   203      26.867  96.451 108.235  1.00 39.00          
ATOM   1653  OG1 THR   203      27.205  96.448 106.850  1.00 37.48          
ATOM   1654  CG2 THR   203      28.161  96.167 109.068  1.00 37.03          
ATOM   1655  N   ALA   204      23.718  96.582 107.692  1.00 40.85          
ATOM   1656  CA  ALA   204      22.635  96.852 106.745  1.00 41.10          
ATOM   1657  C   ALA   204      23.168  97.409 105.415  1.00 41.43          
ATOM   1658  O   ALA   204      22.655  97.064 104.360  1.00 41.76          
ATOM   1659  CB  ALA   204      21.582  97.817 107.365  1.00 41.70          
ATOM   1660  N   PRO   205      24.229  98.247 105.450  1.00 41.26          
ATOM   1661  CA  PRO   205      24.731  98.722 104.174  1.00 40.41          
ATOM   1662  C   PRO   205      25.357  97.631 103.299  1.00 40.56          
ATOM   1663  O   PRO   205      25.117  97.618 102.108  1.00 40.50          
ATOM   1664  CB  PRO   205      25.764  99.785 104.574  1.00 40.10          
ATOM   1665  CG  PRO   205      25.387 100.206 105.921  1.00 40.88          
ATOM   1666  CD  PRO   205      24.878  98.944 106.578  1.00 41.51          
ATOM   1667  N   LEU   206      26.152  96.729 103.879  1.00 41.41          
ATOM   1668  CA  LEU   206      26.737  95.575 103.133  1.00 41.70          
ATOM   1669  C   LEU   206      25.703  94.558 102.607  1.00 41.64          
ATOM   1670  O   LEU   206      25.826  94.098 101.492  1.00 41.73          
ATOM   1671  CB  LEU   206      27.829  94.876 103.950  1.00 40.89          
ATOM   1672  CG  LEU   206      29.070  95.728 104.212  1.00 39.91          
ATOM   1673  CD1 LEU   206      29.808  95.204 105.398  1.00 41.05          
ATOM   1674  CD2 LEU   206      29.968  95.730 102.993  1.00 36.85          
ATOM   1675  N   LEU   207      24.682  94.232 103.388  1.00 41.93          
ATOM   1676  CA  LEU   207      23.592  93.347 102.908  1.00 42.74          
ATOM   1677  C   LEU   207      22.698  93.972 101.857  1.00 42.61          
ATOM   1678  O   LEU   207      22.098  93.285 101.048  1.00 43.65          
ATOM   1679  CB  LEU   207      22.687  92.897 104.068  1.00 41.87          
ATOM   1680  CG  LEU   207      23.329  92.043 105.173  1.00 43.67          
ATOM   1681  CD1 LEU   207      22.325  91.807 106.294  1.00 44.14          
ATOM   1682  CD2 LEU   207      23.867  90.725 104.655  1.00 41.85          
ATOM   1683  N   ASP   208      22.543  95.282 101.928  1.00 42.93          
ATOM   1684  CA  ASP   208      21.744  96.013 100.972  1.00 42.43          
ATOM   1685  C   ASP   208      22.455  96.022  99.607  1.00 41.44          
ATOM   1686  O   ASP   208      21.831  95.755  98.579  1.00 40.32          
ATOM   1687  CB  ASP   208      21.519  97.426 101.535  1.00 43.87          
ATOM   1688  CG  ASP   208      20.793  98.337 100.588  1.00 48.46          
ATOM   1689  OD1 ASP   208      19.835  97.877  99.921  1.00 56.34          
ATOM   1690  OD2 ASP   208      21.166  99.531 100.529  1.00 51.53          
ATOM   1691  N   GLN   209      23.767  96.295  99.597  1.00 39.64          
ATOM   1692  CA  GLN   209      24.554  96.215  98.369  1.00 39.07          
ATOM   1693  C   GLN   209      24.641  94.780  97.780  1.00 38.76          
ATOM   1694  O   GLN   209      24.442  94.560  96.587  1.00 38.96          
ATOM   1695  CB  GLN   209      25.951  96.794  98.597  1.00 39.16          
ATOM   1696  CG  GLN   209      26.901  96.581  97.408  1.00 40.28          
ATOM   1697  CD  GLN   209      26.650  97.517  96.211  1.00 41.28          
ATOM   1698  OE1 GLN   209      27.319  97.410  95.163  1.00 44.18          
ATOM   1699  NE2 GLN   209      25.720  98.446  96.368  1.00 40.87          
ATOM   1700  N   PHE   210      24.945  93.811  98.625  1.00 38.71          
ATOM   1701  CA  PHE   210      24.846  92.381  98.297  1.00 38.52          
ATOM   1702  C   PHE   210      23.564  92.063  97.517  1.00 38.81          
ATOM   1703  O   PHE   210      23.640  91.587  96.385  1.00 38.68          
ATOM   1704  CB  PHE   210      24.838  91.606  99.606  1.00 38.49          
ATOM   1705  CG  PHE   210      24.846  90.132  99.458  1.00 40.01          
ATOM   1706  CD1 PHE   210      25.834  89.497  98.704  1.00 42.66          
ATOM   1707  CD2 PHE   210      23.922  89.358 100.144  1.00 39.68          
ATOM   1708  CE1 PHE   210      25.889  88.111  98.619  1.00 43.83          
ATOM   1709  CE2 PHE   210      23.956  87.957 100.060  1.00 40.76          
ATOM   1710  CZ  PHE   210      24.938  87.333  99.311  1.00 43.95          
ATOM   1711  N   LEU   211      22.402  92.300  98.126  1.00 38.08          
ATOM   1712  CA  LEU   211      21.130  91.975  97.480  1.00 39.54          
ATOM   1713  C   LEU   211      20.966  92.718  96.183  1.00 40.24          
ATOM   1714  O   LEU   211      20.451  92.191  95.207  1.00 41.15          
ATOM   1715  CB  LEU   211      19.933  92.291  98.385  1.00 38.28          
ATOM   1716  CG  LEU   211      19.678  91.405  99.603  1.00 39.40          
ATOM   1717  CD1 LEU   211      18.552  91.999 100.467  1.00 37.65          
ATOM   1718  CD2 LEU   211      19.371  89.924  99.210  1.00 33.77          
ATOM   1719  N   ASP   212      21.381  93.966  96.188  1.00 41.98          
ATOM   1720  CA  ASP   212      21.302  94.826  95.030  1.00 43.93          
ATOM   1721  C   ASP   212      21.989  94.250  93.780  1.00 44.11          
ATOM   1722  O   ASP   212      21.370  94.102  92.689  1.00 44.18          
ATOM   1723  CB  ASP   212      21.975  96.137  95.402  1.00 44.85          
ATOM   1724  CG  ASP   212      21.044  97.290  95.323  1.00 51.67          
ATOM   1725  OD1 ASP   212      21.358  98.184  94.492  1.00 57.38          
ATOM   1726  OD2 ASP   212      19.987  97.277  96.045  1.00 57.78          
ATOM   1727  N   GLN   213      23.285  93.989  93.937  1.00 43.77          
ATOM   1728  CA  GLN   213      24.069  93.259  92.970  1.00 44.34          
ATOM   1729  C   GLN   213      23.451  91.904  92.628  1.00 43.88          
ATOM   1730  O   GLN   213      23.334  91.550  91.476  1.00 44.90          
ATOM   1731  CB  GLN   213      25.482  93.011  93.520  1.00 44.63          
ATOM   1732  CG  GLN   213      26.448  94.129  93.295  1.00 46.85          
ATOM   1733  CD  GLN   213      27.905  93.650  93.403  1.00 50.14          
ATOM   1734  OE1 GLN   213      28.144  92.530  93.846  1.00 51.58          
ATOM   1735  NE2 GLN   213      28.871  94.486  92.982  1.00 45.46          
ATOM   1736  N   ASN   214      23.079  91.126  93.625  1.00 43.26          
ATOM   1737  CA  ASN   214      22.420  89.868  93.339  1.00 42.90          
ATOM   1738  C   ASN   214      21.183  90.029  92.438  1.00 42.62          
ATOM   1739  O   ASN   214      21.000  89.232  91.515  1.00 42.68          
ATOM   1740  CB  ASN   214      22.107  89.103  94.636  1.00 41.79          
ATOM   1741  CG  ASN   214      23.366  88.768  95.412  1.00 44.58          
ATOM   1742  OD1 ASN   214      24.466  89.141  95.003  1.00 44.53          
ATOM   1743  ND2 ASN   214      23.222  88.057  96.528  1.00 45.55          
ATOM   1744  N   ARG   215      20.366  91.067  92.680  1.00 42.19          
ATOM   1745  CA  ARG   215      19.087  91.214  91.970  1.00 41.92          
ATOM   1746  C   ARG   215      19.185  91.354  90.471  1.00 42.27          
ATOM   1747  O   ARG   215      18.322  90.856  89.728  1.00 42.91          
ATOM   1748  CB  ARG   215      18.279  92.388  92.478  1.00 41.19          
ATOM   1749  CG  ARG   215      16.826  92.135  92.146  1.00 42.40          
ATOM   1750  CD  ARG   215      16.091  93.324  91.658  1.00 40.50          
ATOM   1751  NE  ARG   215      14.664  93.036  91.713  1.00 38.86          
ATOM   1752  CZ  ARG   215      13.852  92.992  90.656  1.00 39.64          
ATOM   1753  NH1 ARG   215      14.306  93.251  89.428  1.00 40.37          
ATOM   1754  NH2 ARG   215      12.568  92.699  90.822  1.00 39.37          
ATOM   1755  N   VAL   216      20.190  92.097  90.007  1.00 42.32          
ATOM   1756  CA  VAL   216      20.267  92.382  88.572  1.00 42.34          
ATOM   1757  C   VAL   216      20.579  91.100  87.795  1.00 41.17          
ATOM   1758  O   VAL   216      20.035  90.873  86.737  1.00 39.92          
ATOM   1759  CB  VAL   216      21.248  93.574  88.213  1.00 42.59          
ATOM   1760  CG1 VAL   216      21.239  94.647  89.302  1.00 43.45          
ATOM   1761  CG2 VAL   216      22.639  93.097  87.993  1.00 44.41          
ATOM   1762  N   SER   217      21.478  90.270  88.332  1.00 40.80          
ATOM   1763  CA  SER   217      21.784  89.003  87.692  1.00 39.83          
ATOM   1764  C   SER   217      20.601  88.011  87.741  1.00 38.66          
ATOM   1765  O   SER   217      20.314  87.355  86.748  1.00 38.34          
ATOM   1766  CB  SER   217      23.049  88.400  88.294  1.00 41.19          
ATOM   1767  OG  SER   217      24.196  89.130  87.899  1.00 40.44          
ATOM   1768  N   VAL   218      19.913  87.931  88.876  1.00 36.55          
ATOM   1769  CA  VAL   218      18.756  87.056  89.024  1.00 36.35          
ATOM   1770  C   VAL   218      17.567  87.403  88.119  1.00 36.19          
ATOM   1771  O   VAL   218      17.027  86.525  87.441  1.00 36.51          
ATOM   1772  CB  VAL   218      18.261  87.011  90.494  1.00 37.04          
ATOM   1773  CG1 VAL   218      17.085  86.065  90.603  1.00 35.61          
ATOM   1774  CG2 VAL   218      19.379  86.565  91.408  1.00 33.79          
ATOM   1775  N   ALA   219      17.165  88.668  88.094  1.00 36.12          
ATOM   1776  CA  ALA   219      16.103  89.111  87.185  1.00 36.91          
ATOM   1777  C   ALA   219      16.550  88.794  85.750  1.00 37.54          
ATOM   1778  O   ALA   219      15.751  88.341  84.899  1.00 38.19          
ATOM   1779  CB  ALA   219      15.857  90.617  87.328  1.00 35.74          
ATOM   1780  N   SER   220      17.824  89.022  85.455  1.00 36.13          
ATOM   1781  CA  SER   220      18.248  88.754  84.101  1.00 37.00          
ATOM   1782  C   SER   220      18.247  87.235  83.745  1.00 36.84          
ATOM   1783  O   SER   220      17.787  86.859  82.664  1.00 35.71          
ATOM   1784  CB  SER   220      19.593  89.393  83.866  1.00 37.73          
ATOM   1785  OG  SER   220      19.716  89.763  82.513  1.00 43.51          
ATOM   1786  N   LEU   221      18.748  86.362  84.633  1.00 36.19          
ATOM   1787  CA  LEU   221      18.682  84.918  84.356  1.00 36.50          
ATOM   1788  C   LEU   221      17.226  84.460  84.271  1.00 36.18          
ATOM   1789  O   LEU   221      16.877  83.640  83.459  1.00 36.56          
ATOM   1790  CB  LEU   221      19.378  84.105  85.427  1.00 35.80          
ATOM   1791  CG  LEU   221      19.650  82.623  85.175  1.00 36.70          
ATOM   1792  CD1 LEU   221      20.152  82.296  83.761  1.00 33.08          
ATOM   1793  CD2 LEU   221      20.654  82.046  86.242  1.00 38.20          
ATOM   1794  N   ARG   222      16.399  84.990  85.142  1.00 36.66          
ATOM   1795  CA  ARG   222      14.970  84.670  85.176  1.00 37.31          
ATOM   1796  C   ARG   222      14.361  84.915  83.822  1.00 36.40          
ATOM   1797  O   ARG   222      13.642  84.085  83.290  1.00 35.54          
ATOM   1798  CB  ARG   222      14.270  85.559  86.203  1.00 36.68          
ATOM   1799  CG  ARG   222      13.098  84.895  86.843  1.00 40.32          
ATOM   1800  CD  ARG   222      11.966  85.855  87.103  1.00 43.39          
ATOM   1801  NE  ARG   222      11.553  86.421  85.838  1.00 50.01          
ATOM   1802  CZ  ARG   222      10.304  86.755  85.531  1.00 54.00          
ATOM   1803  NH1 ARG   222      10.034  87.282  84.325  1.00 54.78          
ATOM   1804  NH2 ARG   222       9.331  86.545  86.420  1.00 52.33          
ATOM   1805  N   ASP   223      14.686  86.074  83.263  1.00 37.24          
ATOM   1806  CA  ASP   223      14.191  86.476  81.949  1.00 37.39          
ATOM   1807  C   ASP   223      14.747  85.575  80.845  1.00 36.07          
ATOM   1808  O   ASP   223      14.025  85.213  79.913  1.00 34.91          
ATOM   1809  CB  ASP   223      14.573  87.923  81.645  1.00 38.92          
ATOM   1810  CG  ASP   223      13.808  88.948  82.501  1.00 43.63          
ATOM   1811  OD1 ASP   223      13.358  88.628  83.633  1.00 49.75          
ATOM   1812  OD2 ASP   223      13.700  90.113  82.046  1.00 49.26          
ATOM   1813  N   PHE   224      16.027  85.216  80.957  1.00 34.55          
ATOM   1814  CA  PHE   224      16.663  84.349  79.969  1.00 33.87          
ATOM   1815  C   PHE   224      15.997  82.996  80.002  1.00 33.67          
ATOM   1816  O   PHE   224      15.683  82.430  78.970  1.00 33.74          
ATOM   1817  CB  PHE   224      18.145  84.181  80.254  1.00 33.22          
ATOM   1818  CG  PHE   224      18.840  83.207  79.331  1.00 35.65          
ATOM   1819  CD1 PHE   224      18.970  83.492  77.962  1.00 35.80          
ATOM   1820  CD2 PHE   224      19.406  82.023  79.822  1.00 35.74          
ATOM   1821  CE1 PHE   224      19.634  82.604  77.109  1.00 36.62          
ATOM   1822  CE2 PHE   224      20.072  81.125  78.975  1.00 33.30          
ATOM   1823  CZ  PHE   224      20.180  81.403  77.627  1.00 35.41          
ATOM   1824  N   LYS   225      15.759  82.481  81.202  1.00 33.54          
ATOM   1825  CA  LYS   225      15.122  81.183  81.371  1.00 33.48          
ATOM   1826  C   LYS   225      13.673  81.193  80.875  1.00 34.42          
ATOM   1827  O   LYS   225      13.233  80.215  80.321  1.00 34.79          
ATOM   1828  CB  LYS   225      15.119  80.779  82.837  1.00 33.04          
ATOM   1829  CG  LYS   225      16.318  80.021  83.345  1.00 32.74          
ATOM   1830  CD  LYS   225      16.351  80.129  84.876  1.00 30.25          
ATOM   1831  CE  LYS   225      17.541  79.454  85.510  1.00 30.52          
ATOM   1832  NZ  LYS   225      17.311  79.305  87.011  1.00 25.84          
ATOM   1833  N   LYS   226      12.917  82.260  81.106  1.00 36.01          
ATOM   1834  CA  LYS   226      11.543  82.359  80.542  1.00 38.40          
ATOM   1835  C   LYS   226      11.597  82.375  79.010  1.00 38.75          
ATOM   1836  O   LYS   226      10.764  81.783  78.317  1.00 38.71          
ATOM   1837  CB  LYS   226      10.869  83.655  80.996  1.00 38.65          
ATOM   1838  CG  LYS   226       9.328  83.634  80.965  1.00 43.13          
ATOM   1839  CD  LYS   226       8.767  85.054  80.759  1.00 49.39          
ATOM   1840  CE  LYS   226       7.753  85.451  81.834  1.00 54.15          
ATOM   1841  NZ  LYS   226       6.413  84.774  81.680  1.00 59.22          
ATOM   1842  N   THR   227      12.568  83.097  78.468  1.00 38.37          
ATOM   1843  CA  THR   227      12.669  83.165  77.022  1.00 38.59          
ATOM   1844  C   THR   227      13.017  81.792  76.423  1.00 38.06          
ATOM   1845  O   THR   227      12.423  81.352  75.443  1.00 38.51          
ATOM   1846  CB  THR   227      13.710  84.196  76.631  1.00 38.17          
ATOM   1847  OG1 THR   227      13.214  85.507  76.965  1.00 39.62          
ATOM   1848  CG2 THR   227      14.027  84.093  75.150  1.00 39.87          
ATOM   1849  N   ALA   228      13.969  81.105  77.029  1.00 37.72          
ATOM   1850  CA  ALA   228      14.377  79.801  76.541  1.00 37.08          
ATOM   1851  C   ALA   228      13.260  78.807  76.733  1.00 36.48          
ATOM   1852  O   ALA   228      13.060  77.955  75.898  1.00 37.31          
ATOM   1853  CB  ALA   228      15.611  79.323  77.259  1.00 36.66          
ATOM   1854  N   ARG   229      12.597  78.844  77.874  1.00 35.79          
ATOM   1855  CA  ARG   229      11.417  78.037  78.035  1.00 36.32          
ATOM   1856  C   ARG   229      10.511  78.212  76.824  1.00 36.55          
ATOM   1857  O   ARG   229      10.219  77.228  76.171  1.00 38.02          
ATOM   1858  CB  ARG   229      10.622  78.377  79.308  1.00 35.97          
ATOM   1859  CG  ARG   229       9.277  77.583  79.390  1.00 35.71          
ATOM   1860  CD  ARG   229       8.416  78.165  80.501  1.00 34.61          
ATOM   1861  NE  ARG   229       7.878  79.459  80.089  1.00 36.34          
ATOM   1862  CZ  ARG   229       7.177  80.252  80.897  1.00 40.12          
ATOM   1863  NH1 ARG   229       6.729  81.406  80.451  1.00 38.47          
ATOM   1864  NH2 ARG   229       6.934  79.895  82.165  1.00 38.47          
ATOM   1865  N   ASP   230      10.061  79.437  76.535  1.00 36.04          
ATOM   1866  CA  ASP   230       9.160  79.700  75.409  1.00 36.95          
ATOM   1867  C   ASP   230       9.704  79.263  74.038  1.00 36.45          
ATOM   1868  O   ASP   230       8.960  78.753  73.187  1.00 35.99          
ATOM   1869  CB  ASP   230       8.792  81.182  75.346  1.00 37.70          
ATOM   1870  CG  ASP   230       7.985  81.662  76.575  1.00 41.70          
ATOM   1871  OD1 ASP   230       7.513  80.817  77.400  1.00 42.03          
ATOM   1872  OD2 ASP   230       7.855  82.928  76.714  1.00 48.38          
ATOM   1873  N   LEU   231      11.003  79.428  73.810  1.00 36.24          
ATOM   1874  CA  LEU   231      11.596  78.933  72.561  1.00 36.02          
ATOM   1875  C   LEU   231      11.598  77.408  72.455  1.00 35.72          
ATOM   1876  O   LEU   231      11.459  76.864  71.362  1.00 34.65          
ATOM   1877  CB  LEU   231      12.995  79.471  72.362  1.00 36.62          
ATOM   1878  CG  LEU   231      13.191  80.988  72.301  1.00 38.53          
ATOM   1879  CD1 LEU   231      14.708  81.288  72.295  1.00 36.72          
ATOM   1880  CD2 LEU   231      12.489  81.612  71.103  1.00 36.13          
ATOM   1881  N   ILE   232      11.736  76.708  73.573  1.00 35.63          
ATOM   1882  CA  ILE   232      11.661  75.235  73.529  1.00 37.41          
ATOM   1883  C   ILE   232      10.215  74.730  73.294  1.00 38.45          
ATOM   1884  O   ILE   232      10.002  73.795  72.514  1.00 39.03          
ATOM   1885  CB  ILE   232      12.247  74.603  74.804  1.00 37.23          
ATOM   1886  CG1 ILE   232      13.686  75.060  74.983  1.00 37.75          
ATOM   1887  CG2 ILE   232      12.202  73.077  74.734  1.00 36.36          
ATOM   1888  CD  ILE   232      14.162  74.877  76.363  1.00 39.09          
ATOM   1889  N   GLU   233       9.234  75.365  73.938  1.00 39.33          
ATOM   1890  CA  GLU   233       7.824  74.950  73.802  1.00 40.84          
ATOM   1891  C   GLU   233       7.370  75.097  72.376  1.00 41.56          
ATOM   1892  O   GLU   233       6.665  74.260  71.872  1.00 42.64          
ATOM   1893  CB  GLU   233       6.920  75.757  74.707  1.00 40.06          
ATOM   1894  CG  GLU   233       7.103  75.400  76.164  1.00 42.72          
ATOM   1895  CD  GLU   233       6.342  76.328  77.126  1.00 47.16          
ATOM   1896  OE1 GLU   233       5.861  77.425  76.683  1.00 49.88          
ATOM   1897  OE2 GLU   233       6.225  75.935  78.324  1.00 45.09          
ATOM   1898  N   GLN   234       7.838  76.158  71.737  1.00 42.77          
ATOM   1899  CA  GLN   234       7.617  76.478  70.338  1.00 42.86          
ATOM   1900  C   GLN   234       8.485  75.704  69.315  1.00 43.01          
ATOM   1901  O   GLN   234       8.212  75.749  68.120  1.00 42.42          
ATOM   1902  CB  GLN   234       7.800  77.995  70.154  1.00 43.01          
ATOM   1903  CG  GLN   234       6.906  78.790  71.046  1.00 45.96          
ATOM   1904  CD  GLN   234       6.790  80.256  70.647  1.00 50.65          
ATOM   1905  OE1 GLN   234       5.800  80.655  70.022  1.00 55.81          
ATOM   1906  NE2 GLN   234       7.779  81.066  71.014  1.00 47.86          
ATOM   1907  N   CYS   235       9.533  75.016  69.774  1.00 43.89          
ATOM   1908  CA  CYS   235      10.357  74.209  68.884  1.00 44.43          
ATOM   1909  C   CYS   235      11.249  75.073  68.019  1.00 42.74          
ATOM   1910  O   CYS   235      11.472  74.759  66.837  1.00 41.08          
ATOM   1911  CB  CYS   235       9.455  73.438  67.956  1.00 45.55          
ATOM   1912  SG  CYS   235       8.636  72.171  68.876  1.00 57.19          
ATOM   1913  N   LYS   236      11.702  76.168  68.616  1.00 40.52          
ATOM   1914  CA  LYS   236      12.418  77.194  67.927  1.00 39.58          
ATOM   1915  C   LYS   236      13.927  77.061  68.121  1.00 38.78          
ATOM   1916  O   LYS   236      14.691  77.509  67.297  1.00 39.58          
ATOM   1917  CB  LYS   236      11.908  78.568  68.356  1.00 39.26          
ATOM   1918  CG  LYS   236      10.668  79.003  67.637  1.00 39.13          
ATOM   1919  CD  LYS   236      10.315  80.413  67.990  1.00 41.11          
ATOM   1920  CE  LYS   236       9.434  81.012  66.895  1.00 43.44          
ATOM   1921  NZ  LYS   236       9.027  82.408  67.261  1.00 45.36          
ATOM   1922  N   ILE   237      14.361  76.416  69.175  1.00 38.02          
ATOM   1923  CA  ILE   237      15.791  76.094  69.295  1.00 38.03          
ATOM   1924  C   ILE   237      16.067  74.575  69.384  1.00 38.18          
ATOM   1925  O   ILE   237      15.137  73.766  69.506  1.00 38.27          
ATOM   1926  CB  ILE   237      16.438  76.805  70.478  1.00 37.23          
ATOM   1927  CG1 ILE   237      15.857  76.263  71.785  1.00 36.56          
ATOM   1928  CG2 ILE   237      16.256  78.324  70.351  1.00 37.08          
ATOM   1929  CD  ILE   237      16.588  76.838  73.015  1.00 31.73          
ATOM   1930  N   LYS   238      17.351  74.214  69.360  1.00 37.31          
ATOM   1931  CA  LYS   238      17.737  72.841  69.342  1.00 36.14          
ATOM   1932  C   LYS   238      18.390  72.501  70.636  1.00 36.38          
ATOM   1933  O   LYS   238      19.359  73.140  71.085  1.00 38.42          
ATOM   1934  CB  LYS   238      18.669  72.568  68.170  1.00 37.03          
ATOM   1935  CG  LYS   238      18.035  72.927  66.829  1.00 35.45          
ATOM   1936  CD  LYS   238      18.831  72.414  65.696  1.00 35.38          
ATOM   1937  CE  LYS   238      19.460  73.518  64.928  1.00 37.62          
ATOM   1938  NZ  LYS   238      20.472  74.077  65.782  1.00 40.96          
ATOM   1939  N   SER   239      17.865  71.467  71.249  1.00 34.86          
ATOM   1940  CA  SER   239      18.331  71.074  72.532  1.00 34.29          
ATOM   1941  C   SER   239      17.754  69.722  72.877  1.00 34.16          
ATOM   1942  O   SER   239      16.826  69.199  72.206  1.00 32.93          
ATOM   1943  CB  SER   239      17.850  72.108  73.591  1.00 35.56          
ATOM   1944  OG  SER   239      16.481  71.929  73.976  1.00 32.41          
ATOM   1945  N   ILE   240      18.269  69.194  73.979  1.00 34.06          
ATOM   1946  CA  ILE   240      17.652  68.049  74.651  1.00 33.92          
ATOM   1947  C   ILE   240      17.099  68.467  76.004  1.00 34.86          
ATOM   1948  O   ILE   240      17.135  67.681  76.955  1.00 36.49          
ATOM   1949  CB  ILE   240      18.656  66.872  74.847  1.00 33.25          
ATOM   1950  CG1 ILE   240      19.912  67.343  75.547  1.00 31.26          
ATOM   1951  CG2 ILE   240      19.095  66.301  73.535  1.00 30.82          
ATOM   1952  CD  ILE   240      20.877  66.181  75.769  1.00 23.52          
ATOM   1953  N   ILE   241      16.615  69.705  76.101  1.00 34.84          
ATOM   1954  CA  ILE   241      16.033  70.224  77.337  1.00 34.52          
ATOM   1955  C   ILE   241      14.536  69.945  77.259  1.00 36.36          
ATOM   1956  O   ILE   241      13.871  70.399  76.325  1.00 36.97          
ATOM   1957  CB  ILE   241      16.213  71.755  77.445  1.00 34.70          
ATOM   1958  CG1 ILE   241      17.698  72.142  77.494  1.00 32.68          
ATOM   1959  CG2 ILE   241      15.499  72.350  78.679  1.00 32.56          
ATOM   1960  CD  ILE   241      17.896  73.641  77.407  1.00 27.44          
ATOM   1961  N   HSD   242      14.017  69.189  78.218  1.00 36.14          
ATOM   1962  CA  HSD   242      12.618  68.948  78.272  1.00 37.06          
ATOM   1963  C   HSD   242      12.002  70.295  78.647  1.00 37.20          
ATOM   1964  O   HSD   242      12.524  71.019  79.507  1.00 37.50          
ATOM   1965  CB  HSD   242      12.297  67.873  79.325  1.00 36.82          
ATOM   1966  CG  HSD   242      10.897  67.362  79.232  1.00 37.87          
ATOM   1967  ND1 HSD   242       9.803  68.133  79.570  1.00 39.24          
ATOM   1968  CD2 HSD   242      10.401  66.173  78.801  1.00 39.12          
ATOM   1969  CE1 HSD   242       8.694  67.443  79.350  1.00 36.45          
ATOM   1970  NE2 HSD   242       9.030  66.251  78.886  1.00 37.56          
ATOM   1971  N   PRO   243      10.878  70.634  78.018  1.00 36.62          
ATOM   1972  CA  PRO   243      10.236  71.917  78.178  1.00 36.23          
ATOM   1973  C   PRO   243       9.830  72.126  79.635  1.00 36.42          
ATOM   1974  O   PRO   243       9.776  73.259  80.135  1.00 36.36          
ATOM   1975  CB  PRO   243       9.013  71.801  77.280  1.00 36.42          
ATOM   1976  CG  PRO   243       9.317  70.740  76.323  1.00 36.44          
ATOM   1977  CD  PRO   243      10.219  69.792  77.017  1.00 37.50          
ATOM   1978  N   LEU   244       9.590  71.023  80.333  1.00 36.56          
ATOM   1979  CA  LEU   244       9.218  71.098  81.720  1.00 36.32          
ATOM   1980  C   LEU   244      10.440  71.359  82.577  1.00 35.27          
ATOM   1981  O   LEU   244      10.299  71.944  83.638  1.00 35.70          
ATOM   1982  CB  LEU   244       8.536  69.805  82.134  1.00 37.38          
ATOM   1983  CG  LEU   244       8.170  69.602  83.596  1.00 39.63          
ATOM   1984  CD1 LEU   244       7.251  70.749  84.101  1.00 38.62          
ATOM   1985  CD2 LEU   244       7.510  68.211  83.729  1.00 42.95          
ATOM   1986  N   LEU   245      11.634  70.938  82.137  1.00 34.60          
ATOM   1987  CA  LEU   245      12.861  71.265  82.907  1.00 33.50          
ATOM   1988  C   LEU   245      13.092  72.765  82.777  1.00 33.76          
ATOM   1989  O   LEU   245      13.370  73.445  83.766  1.00 33.93          
ATOM   1990  CB  LEU   245      14.088  70.493  82.429  1.00 32.88          
ATOM   1991  CG  LEU   245      15.475  70.839  83.028  1.00 33.28          
ATOM   1992  CD1 LEU   245      15.485  70.701  84.556  1.00 29.82          
ATOM   1993  CD2 LEU   245      16.595  69.942  82.416  1.00 34.28          
ATOM   1994  N   ALA   246      12.938  73.294  81.568  1.00 33.30          
ATOM   1995  CA  ALA   246      13.101  74.733  81.381  1.00 34.49          
ATOM   1996  C   ALA   246      12.147  75.568  82.282  1.00 34.88          
ATOM   1997  O   ALA   246      12.519  76.583  82.845  1.00 34.31          
ATOM   1998  CB  ALA   246      12.936  75.105  79.897  1.00 34.35          
ATOM   1999  N   ASP   247      10.902  75.132  82.401  1.00 35.61          
ATOM   2000  CA  ASP   247       9.969  75.850  83.216  1.00 35.71          
ATOM   2001  C   ASP   247      10.263  75.690  84.725  1.00 35.92          
ATOM   2002  O   ASP   247      10.024  76.618  85.537  1.00 35.06          
ATOM   2003  CB  ASP   247       8.574  75.349  82.912  1.00 36.17          
ATOM   2004  CG  ASP   247       7.563  75.942  83.855  1.00 39.07          
ATOM   2005  OD1 ASP   247       7.541  77.197  83.937  1.00 40.29          
ATOM   2006  OD2 ASP   247       6.852  75.166  84.543  1.00 39.88          
ATOM   2007  N   HSD   248      10.792  74.514  85.079  1.00 35.87          
ATOM   2008  CA  HSD   248      11.132  74.125  86.450  1.00 35.69          
ATOM   2009  C   HSD   248      12.263  75.031  86.986  1.00 36.66          
ATOM   2010  O   HSD   248      12.203  75.528  88.125  1.00 37.02          
ATOM   2011  CB  HSD   248      11.570  72.667  86.395  1.00 34.87          
ATOM   2012  CG  HSD   248      12.070  72.103  87.691  1.00 35.56          
ATOM   2013  ND1 HSD   248      11.320  71.249  88.464  1.00 37.72          
ATOM   2014  CD2 HSD   248      13.270  72.209  88.314  1.00 37.44          
ATOM   2015  CE1 HSD   248      12.025  70.878  89.526  1.00 41.14          
ATOM   2016  NE2 HSD   248      13.208  71.451  89.468  1.00 35.16          
ATOM   2017  N   VAL   249      13.310  75.232  86.192  1.00 36.44          
ATOM   2018  CA  VAL   249      14.362  76.169  86.627  1.00 36.33          
ATOM   2019  C   VAL   249      13.953  77.652  86.480  1.00 36.69          
ATOM   2020  O   VAL   249      14.546  78.497  87.102  1.00 35.53          
ATOM   2021  CB  VAL   249      15.723  75.919  85.930  1.00 36.78          
ATOM   2022  CG1 VAL   249      16.161  74.460  86.084  1.00 35.72          
ATOM   2023  CG2 VAL   249      15.705  76.374  84.458  1.00 35.06          
ATOM   2024  N   PHE   250      12.936  77.975  85.659  1.00 36.70          
ATOM   2025  CA  PHE   250      12.374  79.328  85.680  1.00 35.79          
ATOM   2026  C   PHE   250      11.635  79.596  87.004  1.00 36.26          
ATOM   2027  O   PHE   250      11.711  80.693  87.575  1.00 36.29          
ATOM   2028  CB  PHE   250      11.398  79.556  84.524  1.00 36.25          
ATOM   2029  CG  PHE   250      10.543  80.758  84.719  1.00 36.32          
ATOM   2030  CD1 PHE   250      11.047  82.012  84.520  1.00 36.74          
ATOM   2031  CD2 PHE   250       9.241  80.633  85.162  1.00 39.08          
ATOM   2032  CE1 PHE   250      10.242  83.132  84.724  1.00 40.60          
ATOM   2033  CE2 PHE   250       8.427  81.751  85.359  1.00 41.35          
ATOM   2034  CZ  PHE   250       8.923  82.994  85.138  1.00 38.23          
ATOM   2035  N   ARG   251      10.918  78.597  87.512  1.00 36.02          
ATOM   2036  CA  ARG   251      10.157  78.784  88.770  1.00 35.38          
ATOM   2037  C   ARG   251      11.132  78.902  89.929  1.00 34.84          
ATOM   2038  O   ARG   251      10.931  79.669  90.861  1.00 34.77          
ATOM   2039  CB  ARG   251       9.191  77.627  89.038  1.00 35.12          
ATOM   2040  CG  ARG   251       7.777  77.884  88.516  1.00 36.72          
ATOM   2041  CD  ARG   251       6.858  76.641  88.670  1.00 35.43          
ATOM   2042  NE  ARG   251       7.067  75.686  87.583  1.00 36.83          
ATOM   2043  CZ  ARG   251       7.522  74.448  87.760  1.00 40.78          
ATOM   2044  NH1 ARG   251       7.709  73.648  86.721  1.00 38.52          
ATOM   2045  NH2 ARG   251       7.799  73.997  88.992  1.00 43.99          
ATOM   2046  N   GLU   252      12.194  78.131  89.899  1.00 34.34          
ATOM   2047  CA  GLU   252      13.154  78.286  90.973  1.00 34.62          
ATOM   2048  C   GLU   252      13.826  79.662  90.951  1.00 35.13          
ATOM   2049  O   GLU   252      13.900  80.294  91.972  1.00 36.45          
ATOM   2050  CB  GLU   252      14.192  77.157  90.970  1.00 34.99          
ATOM   2051  CG  GLU   252      13.601  75.786  91.138  1.00 36.07          
ATOM   2052  CD  GLU   252      14.628  74.710  90.966  1.00 37.48          
ATOM   2053  OE1 GLU   252      15.786  75.014  90.610  1.00 40.01          
ATOM   2054  OE2 GLU   252      14.298  73.560  91.241  1.00 38.45          
ATOM   2055  N   ALA   253      14.323  80.158  89.814  1.00 35.77          
ATOM   2056  CA  ALA   253      14.842  81.553  89.768  1.00 35.93          
ATOM   2057  C   ALA   253      13.821  82.592  90.243  1.00 36.75          
ATOM   2058  O   ALA   253      14.150  83.518  90.989  1.00 38.07          
ATOM   2059  CB  ALA   253      15.300  81.926  88.349  1.00 36.11          
ATOM   2060  N   ASP   254      12.586  82.459  89.776  1.00 37.16          
ATOM   2061  CA  ASP   254      11.516  83.352  90.120  1.00 37.28          
ATOM   2062  C   ASP   254      11.308  83.426  91.630  1.00 36.89          
ATOM   2063  O   ASP   254      11.192  84.516  92.199  1.00 36.76          
ATOM   2064  CB  ASP   254      10.249  82.905  89.414  1.00 38.58          
ATOM   2065  CG  ASP   254       9.113  83.882  89.605  1.00 43.22          
ATOM   2066  OD1 ASP   254       9.156  84.971  88.982  1.00 45.67          
ATOM   2067  OD2 ASP   254       8.185  83.561  90.383  1.00 48.43          
ATOM   2068  N   ARG   255      11.281  82.274  92.304  1.00 35.85          
ATOM   2069  CA  ARG   255      11.165  82.274  93.758  1.00 33.07          
ATOM   2070  C   ARG   255      12.380  82.983  94.402  1.00 33.19          
ATOM   2071  O   ARG   255      12.234  83.723  95.358  1.00 32.67          
ATOM   2072  CB  ARG   255      11.060  80.834  94.257  1.00 31.91          
ATOM   2073  CG  ARG   255      10.845  80.732  95.763  1.00 32.32          
ATOM   2074  CD  ARG   255      10.555  79.306  96.159  1.00 34.94          
ATOM   2075  NE  ARG   255      10.201  79.086  97.564  1.00 33.77          
ATOM   2076  CZ  ARG   255       8.937  79.067  98.013  1.00 32.26          
ATOM   2077  NH1 ARG   255       7.943  79.341  97.204  1.00 29.83          
ATOM   2078  NH2 ARG   255       8.682  78.845  99.287  1.00 32.00          
ATOM   2079  N   PHE   256      13.593  82.717  93.911  1.00 32.38          
ATOM   2080  CA  PHE   256      14.789  83.395  94.481  1.00 32.50          
ATOM   2081  C   PHE   256      14.597  84.895  94.349  1.00 32.63          
ATOM   2082  O   PHE   256      14.967  85.660  95.227  1.00 32.63          
ATOM   2083  CB  PHE   256      16.050  82.927  93.741  1.00 30.74          
ATOM   2084  CG  PHE   256      17.341  83.513  94.250  1.00 31.35          
ATOM   2085  CD1 PHE   256      17.474  83.952  95.544  1.00 32.13          
ATOM   2086  CD2 PHE   256      18.460  83.557  93.430  1.00 29.54          
ATOM   2087  CE1 PHE   256      18.651  84.420  95.991  1.00 31.71          
ATOM   2088  CE2 PHE   256      19.627  84.065  93.859  1.00 27.31          
ATOM   2089  CZ  PHE   256      19.723  84.496  95.142  1.00 32.30          
ATOM   2090  N   LEU   257      13.983  85.316  93.248  1.00 33.93          
ATOM   2091  CA  LEU   257      13.744  86.731  93.050  1.00 35.81          
ATOM   2092  C   LEU   257      12.745  87.343  94.061  1.00 37.41          
ATOM   2093  O   LEU   257      12.982  88.459  94.519  1.00 39.01          
ATOM   2094  CB  LEU   257      13.376  87.033  91.590  1.00 35.03          
ATOM   2095  CG  LEU   257      13.359  88.491  91.156  1.00 33.06          
ATOM   2096  CD1 LEU   257      14.749  89.190  91.187  1.00 29.17          
ATOM   2097  CD2 LEU   257      12.670  88.600  89.760  1.00 33.69          
ATOM   2098  N   GLU   258      11.660  86.643  94.416  1.00 38.61          
ATOM   2099  CA  GLU   258      10.757  87.107  95.483  1.00 39.83          
ATOM   2100  C   GLU   258      11.582  87.263  96.774  1.00 39.75          
ATOM   2101  O   GLU   258      11.575  88.310  97.420  1.00 39.64          
ATOM   2102  CB  GLU   258       9.660  86.073  95.790  1.00 40.69          
ATOM   2103  CG  GLU   258       8.296  86.277  95.163  1.00 45.44          
ATOM   2104  CD  GLU   258       7.139  86.068  96.158  1.00 50.39          
ATOM   2105  OE1 GLU   258       7.328  86.256  97.381  1.00 52.39          
ATOM   2106  OE2 GLU   258       6.015  85.743  95.718  1.00 53.30          
ATOM   2107  N   ILE   259      12.280  86.198  97.167  1.00 38.54          
ATOM   2108  CA  ILE   259      13.123  86.262  98.343  1.00 37.65          
ATOM   2109  C   ILE   259      14.043  87.487  98.318  1.00 38.23          
ATOM   2110  O   ILE   259      14.120  88.224  99.310  1.00 37.96          
ATOM   2111  CB  ILE   259      13.917  84.958  98.573  1.00 37.24          
ATOM   2112  CG1 ILE   259      12.977  83.779  98.775  1.00 34.24          
ATOM   2113  CG2 ILE   259      14.864  85.092  99.793  1.00 39.48          
ATOM   2114  CD  ILE   259      13.655  82.429  98.750  1.00 31.82          
ATOM   2115  N   ILE   260      14.712  87.751  97.196  1.00 38.49          
ATOM   2116  CA  ILE   260      15.603  88.918  97.140  1.00 38.41          
ATOM   2117  C   ILE   260      14.810  90.244  97.297  1.00 38.28          
ATOM   2118  O   ILE   260      15.168  91.134  98.079  1.00 37.09          
ATOM   2119  CB  ILE   260      16.421  88.952  95.821  1.00 38.67          
ATOM   2120  CG1 ILE   260      17.556  87.928  95.823  1.00 38.89          
ATOM   2121  CG2 ILE   260      17.077  90.320  95.630  1.00 39.79          
ATOM   2122  CD  ILE   260      18.273  87.891  94.528  1.00 35.72          
ATOM   2123  N   ASP   261      13.726  90.373  96.548  1.00 38.48          
ATOM   2124  CA  ASP   261      12.895  91.568  96.647  1.00 38.40          
ATOM   2125  C   ASP   261      12.231  91.753  98.019  1.00 38.68          
ATOM   2126  O   ASP   261      12.158  92.873  98.522  1.00 39.09          
ATOM   2127  CB  ASP   261      11.866  91.575  95.534  1.00 38.58          
ATOM   2128  CG  ASP   261      12.481  91.894  94.182  1.00 40.77          
ATOM   2129  OD1 ASP   261      13.670  92.342  94.133  1.00 41.03          
ATOM   2130  OD2 ASP   261      11.771  91.710  93.162  1.00 38.77          
ATOM   2131  N   MET   262      11.743  90.683  98.641  1.00 39.47          
ATOM   2132  CA  MET   262      11.163  90.817  99.979  1.00 39.79          
ATOM   2133  C   MET   262      12.221  91.140 101.026  1.00 41.29          
ATOM   2134  O   MET   262      11.989  91.976 101.920  1.00 41.10          
ATOM   2135  CB  MET   262      10.379  89.602 100.380  1.00 39.20          
ATOM   2136  CG  MET   262       9.088  89.311  99.509  1.00 41.06          
ATOM   2137  SD  MET   262       7.840  90.569  99.560  1.00 45.29          
ATOM   2138  CE  MET   262       8.180  91.327  97.969  1.00 50.88          
ATOM   2139  N   TYR   263      13.399  90.545 100.921  1.00 42.34          
ATOM   2140  CA  TYR   263      14.416  90.885 101.927  1.00 45.02          
ATOM   2141  C   TYR   263      14.825  92.330 101.786  1.00 46.06          
ATOM   2142  O   TYR   263      14.997  93.046 102.749  1.00 46.00          
ATOM   2143  CB  TYR   263      15.628  89.944 101.888  1.00 44.88          
ATOM   2144  CG  TYR   263      15.300  88.574 102.460  1.00 47.26          
ATOM   2145  CD1 TYR   263      14.210  88.408 103.285  1.00 49.66          
ATOM   2146  CD2 TYR   263      16.082  87.471 102.190  1.00 49.99          
ATOM   2147  CE1 TYR   263      13.890  87.202 103.800  1.00 52.17          
ATOM   2148  CE2 TYR   263      15.767  86.228 102.725  1.00 52.26          
ATOM   2149  CZ  TYR   263      14.673  86.115 103.531  1.00 52.86          
ATOM   2150  OH  TYR   263      14.318  84.906 104.078  1.00 56.78          
ATOM   2151  N   ASP   264      14.943  92.764 100.553  1.00 48.43          
ATOM   2152  CA  ASP   264      15.246  94.137 100.246  1.00 50.62          
ATOM   2153  C   ASP   264      14.287  95.120 100.937  1.00 51.70          
ATOM   2154  O   ASP   264      14.738  96.076 101.552  1.00 51.66          
ATOM   2155  CB  ASP   264      15.202  94.312  98.742  1.00 50.56          
ATOM   2156  CG  ASP   264      15.676  95.656  98.323  1.00 54.80          
ATOM   2157  OD1 ASP   264      16.922  95.811  98.218  1.00 58.40          
ATOM   2158  OD2 ASP   264      14.805  96.551  98.118  1.00 55.68          
ATOM   2159  N   VAL   265      12.978  94.875 100.842  1.00 52.89          
ATOM   2160  CA  VAL   265      11.975  95.695 101.522  1.00 54.42          
ATOM   2161  C   VAL   265      12.188  95.709 103.043  1.00 55.96          
ATOM   2162  O   VAL   265      12.361  96.784 103.663  1.00 55.94          
ATOM   2163  CB  VAL   265      10.530  95.207 101.223  1.00 53.98          
ATOM   2164  CG1 VAL   265       9.519  95.961 102.068  1.00 54.02          
ATOM   2165  CG2 VAL   265      10.217  95.379  99.766  1.00 54.30          
ATOM   2166  N   HSD   266      12.169  94.516 103.636  1.00 57.26          
ATOM   2167  CA  HSD   266      12.274  94.378 105.072  1.00 59.17          
ATOM   2168  C   HSD   266      13.520  95.172 105.471  1.00 59.86          
ATOM   2169  O   HSD   266      13.504  95.878 106.469  1.00 60.51          
ATOM   2170  CB  HSD   266      12.354  92.891 105.504  1.00 59.73          
ATOM   2171  CG  HSD   266      11.102  92.086 105.233  1.00 62.65          
ATOM   2172  ND1 HSD   266       9.986  92.609 104.606  1.00 65.72          
ATOM   2173  CD2 HSD   266      10.807  90.784 105.486  1.00 64.90          
ATOM   2174  CE1 HSD   266       9.048  91.680 104.517  1.00 65.77          
ATOM   2175  NE2 HSD   266       9.526  90.558 105.030  1.00 66.17          
ATOM   2176  N   LEU   267      14.571  95.091 104.645  1.00 60.20          
ATOM   2177  CA  LEU   267      15.831  95.816 104.858  1.00 60.13          
ATOM   2178  C   LEU   267      15.701  97.281 104.418  1.00 60.70          
ATOM   2179  O   LEU   267      15.840  98.206 105.225  1.00 60.80          
ATOM   2180  CB  LEU   267      16.996  95.143 104.095  1.00 59.56          
ATOM   2181  CG  LEU   267      18.401  95.350 104.679  1.00 59.35          
ATOM   2182  CD1 LEU   267      18.460  94.832 106.103  1.00 59.73          
ATOM   2183  CD2 LEU   267      19.539  94.737 103.847  1.00 57.90          
END
