
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  146 ( 1119),  selected  146 , name 1vi8_B
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1vi8_B.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     0_B      -       -           -
LGA    L     1_B      -       -           -
LGA    I     2_B      -       -           -
LGA    W     3_B      -       -           -
LGA    K     4_B      -       -           -
LGA    R     5_B      -       -           -
LGA    K     6_B      -       -           -
LGA    I     7_B      -       -           -
LGA    T     8_B      -       -           -
LGA    L     9_B      -       -           -
LGA    E    10_B      -       -           -
LGA    A    11_B      -       -           -
LGA    L    12_B      -       -           -
LGA    N    13_B      T       6          4.651
LGA    A    14_B      D       7          1.432
LGA    M    15_B      F       8          3.727
LGA    -       -      F       9           -
LGA    -       -      G      10           -
LGA    -       -      L      11           -
LGA    G    16_B      T      12          3.784
LGA    E    17_B      I      13          5.910
LGA    G    18_B      -       -           -
LGA    N    19_B      P      14          0.710
LGA    M    20_B      F      15          1.139
LGA    V    21_B      M      16          0.898
LGA    G    22_B      Q      17          0.680
LGA    F    23_B      L      18          0.913
LGA    L    24_B      L      19          0.936
LGA    D    25_B      G      20          1.112
LGA    I    26_B      V      21          0.844
LGA    R    27_B      V      22          0.479
LGA    F    28_B      P      23          1.057
LGA    E    29_B      E      24          1.515
LGA    H    30_B      H      25          2.649
LGA    I    31_B      S      26          3.491
LGA    G    32_B      G      27          5.189
LGA    D    33_B      N      28          3.234
LGA    D    34_B      G      29          3.155
LGA    T    35_B      T      30          1.737
LGA    L    36_B      A      31          0.848
LGA    E    37_B      R      32          0.252
LGA    A    38_B      T      33          0.152
LGA    T    39_B      R      34          0.342
LGA    M    40_B      L      35          0.643
LGA    P    41_B      P      36          2.228
LGA    V    42_B      A      37          3.062
LGA    D    43_B      R      38          2.191
LGA    S    44_B      A      39          1.501
LGA    R    45_B      D      40          1.965
LGA    T    46_B      L      41          1.494
LGA    K    47_B      V      42          0.783
LGA    Q    48_B      N      43          1.050
LGA    P    49_B      S      44          1.693
LGA    F    50_B      R      45          1.934
LGA    G    51_B      G      46          0.790
LGA    L    52_B      D      47          0.680
LGA    L    53_B      I      48          1.055
LGA    H    54_B      H      49          0.574
LGA    G    55_B      G      50          0.684
LGA    G    56_B      G      51          0.775
LGA    A    57_B      T      52          0.755
LGA    S    58_B      L      53          0.649
LGA    V    59_B      M      54          0.300
LGA    V    60_B      S      55          0.464
LGA    L    61_B      V      56          0.794
LGA    A    62_B      L      57          0.602
LGA    E    63_B      D      58          0.320
LGA    S    64_B      F      59          0.621
LGA    I    65_B      T      60          0.834
LGA    G    66_B      L      61          1.424
LGA    S    67_B      G      62          2.161
LGA    V    68_B      A      63          2.688
LGA    A    69_B      A      64          2.616
LGA    G    70_B      I      65          2.403
LGA    Y    71_B      R      66          2.536
LGA    L    72_B      G      67          2.741
LGA    C    73_B      D      68          3.882
LGA    T    74_B      T      69          4.187
LGA    E    75_B      P      70           #
LGA    G    76_B      E      71          4.001
LGA    E    77_B      -       -           -
LGA    Q    78_B      V      72          3.488
LGA    K    79_B      G      73          1.472
LGA    V    80_B      V      74          1.350
LGA    V    81_B      A      75          1.001
LGA    G    82_B      T      76          0.629
LGA    L    83_B      I      77          0.243
LGA    E    84_B      D      78          0.390
LGA    I    85_B      M      79          0.554
LGA    N    86_B      N      80          0.788
LGA    A    87_B      T      81          0.597
LGA    N    88_B      S      82          0.456
LGA    H    89_B      F      83          0.627
LGA    V    90_B      M      84          0.341
LGA    R    91_B      S      85          0.490
LGA    S    92_B      P      86          0.711
LGA    A    93_B      G      87          2.063
LGA    R    94_B      R      88          2.653
LGA    E    95_B      G      89          2.384
LGA    G    96_B      -       -           -
LGA    R    97_B      D      90          0.919
LGA    V    98_B      L      91          0.719
LGA    R    99_B      V      92          0.601
LGA    G   100_B      I      93          0.493
LGA    V   101_B      E      94          0.433
LGA    C   102_B      T      95          0.683
LGA    K   103_B      R      96          0.535
LGA    P   104_B      C      97          0.884
LGA    L   105_B      L      98          1.049
LGA    H   106_B      R      99          1.114
LGA    L   107_B      R     100          1.158
LGA    G   108_B      G     101          1.417
LGA    S   109_B      A     102          1.542
LGA    R   110_B      S     103          1.248
LGA    H   111_B      I     104          0.508
LGA    Q   112_B      A     105          0.459
LGA    V   113_B      F     106          0.738
LGA    W   114_B      C     107          0.803
LGA    Q   115_B      E     108          0.674
LGA    I   116_B      G     109          1.251
LGA    E   117_B      E     110          0.667
LGA    I   118_B      I     111          0.564
LGA    F   119_B      R     112          0.565
LGA    D   120_B      D     113          0.481
LGA    E   121_B      S     114          0.416
LGA    K   122_B      A     115          1.276
LGA    G   123_B      G     116          1.103
LGA    R   124_B      E     117          0.846
LGA    L   125_B      L     118          0.722
LGA    C   126_B      V     119          0.441
LGA    C   127_B      A     120          0.441
LGA    S   128_B      K     121          0.240
LGA    S   129_B      A     122          0.406
LGA    R   130_B      T     123          0.726
LGA    L   131_B      A     124          1.286
LGA    T   132_B      T     125          0.625
LGA    T   133_B      F     126          0.286
LGA    A   134_B      K     127          0.877
LGA    I   135_B      I     128          1.446
LGA    L   136_B      I     129          1.894
LGA    E   137_B      Q     130          1.962
LGA    G   138_B      -       -           -
LGA    G   139_B      -       -           -
LGA    S   140_B      -       -           -
LGA    H   141_B      -       -           -
LGA    H   142_B      -       -           -
LGA    H   143_B      -       -           -
LGA    H   144_B      -       -           -
LGA    H   145_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  146  125    5.0    121    1.76    19.83     89.186     6.515

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.155011 * X  +  -0.773011 * Y  +   0.615163 * Z  + -10.963294
  Y_new =  -0.875819 * X  +  -0.180565 * Y  +  -0.447590 * Z  + 111.286354
  Z_new =   0.457069 * X  +  -0.608153 * Y  +  -0.649028 * Z  +  69.643982 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.388696    0.752896  [ DEG:  -136.8622     43.1378 ]
  Theta =  -0.474697   -2.666896  [ DEG:   -27.1981   -152.8019 ]
  Phi   =  -1.745972    1.395620  [ DEG:  -100.0368     79.9632 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vi8_B                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vi8_B.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  146  125   5.0  121   1.76   19.83  89.186
REMARK  ---------------------------------------------------------- 
MOLECULE 1vi8_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   01-DEC-03   1VI8              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE THIOESTERASE                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN YDII;                                 
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YDII, B1686;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, NEW           
KEYWDS   2 YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM, NYSGXRC                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    STRUCTURAL GENOMIX,S.K.BURLEY,NEW YORK STRUCTURAL GENOMIX             
AUTHOR   2 RESEARCH CONSORTIUM (NYSGXRC)                                        
REVDAT   3   30-AUG-05 1VI8    1       JRNL                                     
REVDAT   2   25-JAN-05 1VI8    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   30-DEC-03 1VI8    0                                                
JRNL        AUTH   J.BADGER,J.M.SAUDER,J.M.ADAMS,S.ANTONYSAMY,K.BAIN,           
JRNL        AUTH 2 M.G.BERGSEID,S.G.BUCHANAN,M.D.BUCHANAN,Y.BATIYENKO,          
JRNL        AUTH 3 J.A.CHRISTOPHER,S.EMTAGE,A.EROSHKINA,I.FEIL,                 
JRNL        AUTH 4 E.B.FURLONG,K.S.GAJIWALA,X.GAO,D.HE,J.HENDLE,                
JRNL        AUTH 5 A.HUBER,K.HODA,P.KEARINS,C.KISSINGER,B.LAUBERT,              
JRNL        AUTH 6 H.A.LEWIS,J.LIN,K.LOOMIS,D.LORIMER,G.LOUIE,                  
JRNL        AUTH 7 M.MALETIC,C.D.MARSH,I.MILLER,J.MOLINARI,                     
JRNL        AUTH 8 H.J.MULLER-DIECKMANN,J.M.NEWMAN,B.W.NOLAND,                  
JRNL        AUTH 9 B.PAGARIGAN,F.PARK,T.S.PEAT,K.W.POST,S.RADOJICIC,            
JRNL        AUTH10 A.RAMOS,R.ROMERO,M.E.RUTTER,W.E.SANDERSON,                   
JRNL        AUTH11 K.D.SCHWINN,J.TRESSER,J.WINHOVEN,T.A.WRIGHT,L.WU,            
JRNL        AUTH12 J.XU,T.J.HARRIS                                              
JRNL        TITL   STRUCTURAL ANALYSIS OF A SET OF PROTEINS RESULTING           
JRNL        TITL 2 FROM A BACTERIAL GENOMICS PROJECT                            
JRNL        REF    PROTEINS                      V.  60   787 2005              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  1VI8 A    2   136  UNP    P77781   YDII_ECOLI       2    136             
DBREF  1VI8 B    2   136  UNP    P77781   YDII_ECOLI       2    136             
DBREF  1VI8 C    2   136  UNP    P77781   YDII_ECOLI       2    136             
DBREF  1VI8 D    2   136  UNP    P77781   YDII_ECOLI       2    136             
DBREF  1VI8 E    2   136  UNP    P77781   YDII_ECOLI       2    136             
DBREF  1VI8 F    2   136  UNP    P77781   YDII_ECOLI       2    136             
DBREF  1VI8 G    2   136  UNP    P77781   YDII_ECOLI       2    136             
DBREF  1VI8 H    2   136  UNP    P77781   YDII_ECOLI       2    136             
SEQRES   1 A  148  MET SER LEU ILE TRP LYS ARG LYS ILE THR LEU GLU ALA          
SEQRES   2 A  148  LEU ASN ALA MET GLY GLU GLY ASN MET VAL GLY PHE LEU          
SEQRES   3 A  148  ASP ILE ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU          
SEQRES   4 A  148  ALA THR MET PRO VAL ASP SER ARG THR LYS GLN PRO PHE          
SEQRES   5 A  148  GLY LEU LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU          
SEQRES   6 A  148  SER ILE GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY          
SEQRES   7 A  148  GLU GLN LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS          
SEQRES   8 A  148  VAL ARG SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS          
SEQRES   9 A  148  LYS PRO LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN          
SEQRES  10 A  148  ILE GLU ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER          
SEQRES  11 A  148  SER ARG LEU THR THR ALA ILE LEU GLU GLY GLY SER HIS          
SEQRES  12 A  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 B  148  MET SER LEU ILE TRP LYS ARG LYS ILE THR LEU GLU ALA          
SEQRES   2 B  148  LEU ASN ALA MET GLY GLU GLY ASN MET VAL GLY PHE LEU          
SEQRES   3 B  148  ASP ILE ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU          
SEQRES   4 B  148  ALA THR MET PRO VAL ASP SER ARG THR LYS GLN PRO PHE          
SEQRES   5 B  148  GLY LEU LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU          
SEQRES   6 B  148  SER ILE GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY          
SEQRES   7 B  148  GLU GLN LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS          
SEQRES   8 B  148  VAL ARG SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS          
SEQRES   9 B  148  LYS PRO LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN          
SEQRES  10 B  148  ILE GLU ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER          
SEQRES  11 B  148  SER ARG LEU THR THR ALA ILE LEU GLU GLY GLY SER HIS          
SEQRES  12 B  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 C  148  MET SER LEU ILE TRP LYS ARG LYS ILE THR LEU GLU ALA          
SEQRES   2 C  148  LEU ASN ALA MET GLY GLU GLY ASN MET VAL GLY PHE LEU          
SEQRES   3 C  148  ASP ILE ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU          
SEQRES   4 C  148  ALA THR MET PRO VAL ASP SER ARG THR LYS GLN PRO PHE          
SEQRES   5 C  148  GLY LEU LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU          
SEQRES   6 C  148  SER ILE GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY          
SEQRES   7 C  148  GLU GLN LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS          
SEQRES   8 C  148  VAL ARG SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS          
SEQRES   9 C  148  LYS PRO LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN          
SEQRES  10 C  148  ILE GLU ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER          
SEQRES  11 C  148  SER ARG LEU THR THR ALA ILE LEU GLU GLY GLY SER HIS          
SEQRES  12 C  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 D  148  MET SER LEU ILE TRP LYS ARG LYS ILE THR LEU GLU ALA          
SEQRES   2 D  148  LEU ASN ALA MET GLY GLU GLY ASN MET VAL GLY PHE LEU          
SEQRES   3 D  148  ASP ILE ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU          
SEQRES   4 D  148  ALA THR MET PRO VAL ASP SER ARG THR LYS GLN PRO PHE          
SEQRES   5 D  148  GLY LEU LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU          
SEQRES   6 D  148  SER ILE GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY          
SEQRES   7 D  148  GLU GLN LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS          
SEQRES   8 D  148  VAL ARG SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS          
SEQRES   9 D  148  LYS PRO LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN          
SEQRES  10 D  148  ILE GLU ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER          
SEQRES  11 D  148  SER ARG LEU THR THR ALA ILE LEU GLU GLY GLY SER HIS          
SEQRES  12 D  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 E  148  MET SER LEU ILE TRP LYS ARG LYS ILE THR LEU GLU ALA          
SEQRES   2 E  148  LEU ASN ALA MET GLY GLU GLY ASN MET VAL GLY PHE LEU          
SEQRES   3 E  148  ASP ILE ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU          
SEQRES   4 E  148  ALA THR MET PRO VAL ASP SER ARG THR LYS GLN PRO PHE          
SEQRES   5 E  148  GLY LEU LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU          
SEQRES   6 E  148  SER ILE GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY          
SEQRES   7 E  148  GLU GLN LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS          
SEQRES   8 E  148  VAL ARG SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS          
SEQRES   9 E  148  LYS PRO LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN          
SEQRES  10 E  148  ILE GLU ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER          
SEQRES  11 E  148  SER ARG LEU THR THR ALA ILE LEU GLU GLY GLY SER HIS          
SEQRES  12 E  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 F  148  MET SER LEU ILE TRP LYS ARG LYS ILE THR LEU GLU ALA          
SEQRES   2 F  148  LEU ASN ALA MET GLY GLU GLY ASN MET VAL GLY PHE LEU          
SEQRES   3 F  148  ASP ILE ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU          
SEQRES   4 F  148  ALA THR MET PRO VAL ASP SER ARG THR LYS GLN PRO PHE          
SEQRES   5 F  148  GLY LEU LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU          
SEQRES   6 F  148  SER ILE GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY          
SEQRES   7 F  148  GLU GLN LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS          
SEQRES   8 F  148  VAL ARG SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS          
SEQRES   9 F  148  LYS PRO LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN          
SEQRES  10 F  148  ILE GLU ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER          
SEQRES  11 F  148  SER ARG LEU THR THR ALA ILE LEU GLU GLY GLY SER HIS          
SEQRES  12 F  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 G  148  MET SER LEU ILE TRP LYS ARG LYS ILE THR LEU GLU ALA          
SEQRES   2 G  148  LEU ASN ALA MET GLY GLU GLY ASN MET VAL GLY PHE LEU          
SEQRES   3 G  148  ASP ILE ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU          
SEQRES   4 G  148  ALA THR MET PRO VAL ASP SER ARG THR LYS GLN PRO PHE          
SEQRES   5 G  148  GLY LEU LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU          
SEQRES   6 G  148  SER ILE GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY          
SEQRES   7 G  148  GLU GLN LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS          
SEQRES   8 G  148  VAL ARG SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS          
SEQRES   9 G  148  LYS PRO LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN          
SEQRES  10 G  148  ILE GLU ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER          
SEQRES  11 G  148  SER ARG LEU THR THR ALA ILE LEU GLU GLY GLY SER HIS          
SEQRES  12 G  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 H  148  MET SER LEU ILE TRP LYS ARG LYS ILE THR LEU GLU ALA          
SEQRES   2 H  148  LEU ASN ALA MET GLY GLU GLY ASN MET VAL GLY PHE LEU          
SEQRES   3 H  148  ASP ILE ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU          
SEQRES   4 H  148  ALA THR MET PRO VAL ASP SER ARG THR LYS GLN PRO PHE          
SEQRES   5 H  148  GLY LEU LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU          
SEQRES   6 H  148  SER ILE GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY          
SEQRES   7 H  148  GLU GLN LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS          
SEQRES   8 H  148  VAL ARG SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS          
SEQRES   9 H  148  LYS PRO LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN          
SEQRES  10 H  148  ILE GLU ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER          
SEQRES  11 H  148  SER ARG LEU THR THR ALA ILE LEU GLU GLY GLY SER HIS          
SEQRES  12 H  148  HIS HIS HIS HIS HIS                                          
FORMUL   9  HOH   *621(H2 O)                                                    
CRYST1   78.657   67.456  105.195  90.00  92.33  90.00 P 1 21 1     16          
ATOM   1071  N   SER B   0      28.821  32.236  28.069  1.00 59.66           N  
ATOM   1072  CA  SER B   0      28.406  33.038  26.885  1.00 59.87           C  
ATOM   1073  C   SER B   0      28.060  34.463  27.285  1.00 57.46           C  
ATOM   1074  O   SER B   0      28.055  34.802  28.467  1.00 57.82           O  
ATOM   1075  CB  SER B   0      27.203  32.385  26.202  1.00 62.34           C  
ATOM   1076  OG  SER B   0      27.520  31.064  25.794  1.00 67.68           O  
ATOM   1077  N   LEU B   1      27.769  35.293  26.292  1.00 55.02           N  
ATOM   1078  CA  LEU B   1      27.436  36.687  26.541  1.00 52.49           C  
ATOM   1079  C   LEU B   1      26.054  36.840  27.156  1.00 50.02           C  
ATOM   1080  O   LEU B   1      25.047  36.619  26.485  1.00 54.80           O  
ATOM   1081  CB  LEU B   1      27.504  37.482  25.239  1.00 52.03           C  
ATOM   1082  CG  LEU B   1      27.157  38.966  25.367  1.00 53.72           C  
ATOM   1083  CD1 LEU B   1      28.174  39.647  26.273  1.00 51.91           C  
ATOM   1084  CD2 LEU B   1      27.140  39.612  23.992  1.00 52.45           C  
ATOM   1085  N   ILE B   2      26.007  37.227  28.428  1.00 44.60           N  
ATOM   1086  CA  ILE B   2      24.738  37.414  29.121  1.00 41.91           C  
ATOM   1087  C   ILE B   2      24.329  38.876  29.100  1.00 41.00           C  
ATOM   1088  O   ILE B   2      23.149  39.198  29.169  1.00 42.82           O  
ATOM   1089  CB  ILE B   2      24.810  36.953  30.593  1.00 40.18           C  
ATOM   1090  CG1 ILE B   2      25.852  37.770  31.357  1.00 39.53           C  
ATOM   1091  CG2 ILE B   2      25.152  35.475  30.659  1.00 41.32           C  
ATOM   1092  CD1 ILE B   2      25.900  37.455  32.849  1.00 37.65           C  
ATOM   1093  N   TRP B   3      25.317  39.755  28.996  1.00 39.38           N  
ATOM   1094  CA  TRP B   3      25.084  41.189  28.964  1.00 39.04           C  
ATOM   1095  C   TRP B   3      24.212  41.608  27.782  1.00 42.91           C  
ATOM   1096  O   TRP B   3      24.391  41.123  26.664  1.00 43.23           O  
ATOM   1097  CB  TRP B   3      26.416  41.928  28.860  1.00 38.63           C  
ATOM   1098  CG  TRP B   3      27.460  41.466  29.825  1.00 38.78           C  
ATOM   1099  CD1 TRP B   3      28.776  41.234  29.549  1.00 41.13           C  
ATOM   1100  CD2 TRP B   3      27.294  41.216  31.226  1.00 38.61           C  
ATOM   1101  NE1 TRP B   3      29.440  40.858  30.690  1.00 41.71           N  
ATOM   1102  CE2 TRP B   3      28.555  40.841  31.734  1.00 39.99           C  
ATOM   1103  CE3 TRP B   3      26.204  41.274  32.103  1.00 39.23           C  
ATOM   1104  CZ2 TRP B   3      28.754  40.526  33.079  1.00 38.28           C  
ATOM   1105  CZ3 TRP B   3      26.408  40.960  33.443  1.00 33.02           C  
ATOM   1106  CH2 TRP B   3      27.672  40.593  33.913  1.00 33.05           C  
ATOM   1107  N   LYS B   4      23.270  42.513  28.036  1.00 42.54           N  
ATOM   1108  CA  LYS B   4      22.411  43.032  26.989  1.00 42.02           C  
ATOM   1109  C   LYS B   4      22.815  44.472  26.667  1.00 43.88           C  
ATOM   1110  O   LYS B   4      22.538  44.969  25.576  1.00 45.83           O  
ATOM   1111  CB  LYS B   4      20.940  42.952  27.400  1.00 36.70           C  
ATOM   1112  CG  LYS B   4      20.393  41.550  27.298  1.00 31.86           C  
ATOM   1113  CD  LYS B   4      18.919  41.475  27.617  1.00 33.00           C  
ATOM   1114  CE  LYS B   4      18.435  40.049  27.408  1.00 38.30           C  
ATOM   1115  NZ  LYS B   4      17.024  39.827  27.803  1.00 42.54           N  
ATOM   1116  N   ARG B   5      23.474  45.137  27.614  1.00 42.80           N  
ATOM   1117  CA  ARG B   5      23.954  46.504  27.391  1.00 44.37           C  
ATOM   1118  C   ARG B   5      25.466  46.434  27.210  1.00 45.36           C  
ATOM   1119  O   ARG B   5      26.112  45.528  27.735  1.00 44.38           O  
ATOM   1120  CB  ARG B   5      23.674  47.407  28.591  1.00 46.15           C  
ATOM   1121  CG  ARG B   5      22.225  47.594  28.956  1.00 47.41           C  
ATOM   1122  CD  ARG B   5      22.128  48.336  30.275  1.00 43.28           C  
ATOM   1123  NE  ARG B   5      20.815  48.173  30.878  1.00 49.89           N  
ATOM   1124  CZ  ARG B   5      19.716  48.782  30.451  1.00 49.87           C  
ATOM   1125  NH1 ARG B   5      18.563  48.562  31.065  1.00 49.44           N  
ATOM   1126  NH2 ARG B   5      19.773  49.620  29.427  1.00 48.74           N  
ATOM   1127  N   LYS B   6      26.031  47.384  26.474  1.00 43.71           N  
ATOM   1128  CA  LYS B   6      27.473  47.406  26.265  1.00 45.98           C  
ATOM   1129  C   LYS B   6      28.005  48.622  27.009  1.00 45.62           C  
ATOM   1130  O   LYS B   6      27.672  49.765  26.683  1.00 46.23           O  
ATOM   1131  CB  LYS B   6      27.806  47.517  24.775  1.00 49.29           C  
ATOM   1132  CG  LYS B   6      29.208  47.028  24.409  1.00 58.79           C  
ATOM   1133  CD  LYS B   6      29.297  45.505  24.509  1.00 64.17           C  
ATOM   1134  CE  LYS B   6      30.610  44.953  23.949  1.00 67.08           C  
ATOM   1135  NZ  LYS B   6      31.803  45.339  24.756  1.00 66.25           N  
ATOM   1136  N   ILE B   7      28.831  48.376  28.015  1.00 42.40           N  
ATOM   1137  CA  ILE B   7      29.374  49.461  28.811  1.00 42.98           C  
ATOM   1138  C   ILE B   7      30.884  49.311  28.954  1.00 41.20           C  
ATOM   1139  O   ILE B   7      31.398  48.196  28.987  1.00 41.88           O  
ATOM   1140  CB  ILE B   7      28.714  49.467  30.219  1.00 45.59           C  
ATOM   1141  CG1 ILE B   7      29.010  50.775  30.947  1.00 46.57           C  
ATOM   1142  CG2 ILE B   7      29.218  48.288  31.040  1.00 46.34           C  
ATOM   1143  CD1 ILE B   7      28.394  51.986  30.283  1.00 54.72           C  
ATOM   1144  N   THR B   8      31.594  50.433  29.011  1.00 39.45           N  
ATOM   1145  CA  THR B   8      33.044  50.387  29.189  1.00 35.74           C  
ATOM   1146  C   THR B   8      33.313  50.334  30.690  1.00 33.56           C  
ATOM   1147  O   THR B   8      32.419  50.630  31.490  1.00 31.39           O  
ATOM   1148  CB  THR B   8      33.739  51.639  28.621  1.00 31.69           C  
ATOM   1149  OG1 THR B   8      33.207  52.811  29.250  1.00 38.49           O  
ATOM   1150  CG2 THR B   8      33.531  51.729  27.115  1.00 34.14           C  
ATOM   1151  N   LEU B   9      34.523  49.936  31.072  1.00 29.82           N  
ATOM   1152  CA  LEU B   9      34.869  49.884  32.483  1.00 30.64           C  
ATOM   1153  C   LEU B   9      34.806  51.307  32.989  1.00 26.45           C  
ATOM   1154  O   LEU B   9      34.304  51.572  34.071  1.00 29.88           O  
ATOM   1155  CB  LEU B   9      36.280  49.330  32.683  1.00 31.45           C  
ATOM   1156  CG  LEU B   9      36.484  47.816  32.602  1.00 36.12           C  
ATOM   1157  CD1 LEU B   9      37.964  47.516  32.702  1.00 30.09           C  
ATOM   1158  CD2 LEU B   9      35.725  47.122  33.718  1.00 32.79           C  
ATOM   1159  N   GLU B  10      35.330  52.217  32.177  1.00 29.05           N  
ATOM   1160  CA  GLU B  10      35.359  53.640  32.482  1.00 33.16           C  
ATOM   1161  C   GLU B  10      33.955  54.155  32.842  1.00 30.82           C  
ATOM   1162  O   GLU B  10      33.765  54.822  33.867  1.00 28.11           O  
ATOM   1163  CB  GLU B  10      35.920  54.404  31.267  1.00 42.29           C  
ATOM   1164  CG  GLU B  10      35.352  55.809  31.062  1.00 51.18           C  
ATOM   1165  CD  GLU B  10      35.305  56.220  29.590  1.00 58.07           C  
ATOM   1166  OE1 GLU B  10      36.381  56.468  28.993  1.00 59.93           O  
ATOM   1167  OE2 GLU B  10      34.185  56.286  29.029  1.00 58.97           O  
ATOM   1168  N   ALA B  11      32.978  53.844  31.999  1.00 25.11           N  
ATOM   1169  CA  ALA B  11      31.618  54.292  32.252  1.00 25.41           C  
ATOM   1170  C   ALA B  11      31.044  53.573  33.469  1.00 23.78           C  
ATOM   1171  O   ALA B  11      30.282  54.143  34.230  1.00 23.71           O  
ATOM   1172  CB  ALA B  11      30.742  54.049  31.022  1.00 24.51           C  
ATOM   1173  N   LEU B  12      31.434  52.320  33.654  1.00 28.66           N  
ATOM   1174  CA  LEU B  12      30.951  51.539  34.775  1.00 27.45           C  
ATOM   1175  C   LEU B  12      31.434  52.189  36.077  1.00 28.84           C  
ATOM   1176  O   LEU B  12      30.644  52.419  37.000  1.00 28.18           O  
ATOM   1177  CB  LEU B  12      31.453  50.102  34.639  1.00 29.31           C  
ATOM   1178  CG  LEU B  12      30.771  48.977  35.421  1.00 33.49           C  
ATOM   1179  CD1 LEU B  12      29.268  49.224  35.511  1.00 37.62           C  
ATOM   1180  CD2 LEU B  12      31.054  47.644  34.728  1.00 31.33           C  
ATOM   1181  N   ASN B  13      32.725  52.514  36.134  1.00 26.99           N  
ATOM   1182  CA  ASN B  13      33.303  53.146  37.317  1.00 24.19           C  
ATOM   1183  C   ASN B  13      32.835  54.594  37.533  1.00 26.76           C  
ATOM   1184  O   ASN B  13      32.806  55.079  38.665  1.00 23.77           O  
ATOM   1185  CB  ASN B  13      34.833  53.087  37.246  1.00 22.62           C  
ATOM   1186  CG  ASN B  13      35.384  51.693  37.591  1.00 24.41           C  
ATOM   1187  OD1 ASN B  13      35.052  51.135  38.640  1.00 26.35           O  
ATOM   1188  ND2 ASN B  13      36.232  51.137  36.716  1.00 18.36           N  
ATOM   1189  N   ALA B  14      32.466  55.291  36.461  1.00 27.15           N  
ATOM   1190  CA  ALA B  14      31.989  56.672  36.608  1.00 28.19           C  
ATOM   1191  C   ALA B  14      30.674  56.720  37.387  1.00 25.98           C  
ATOM   1192  O   ALA B  14      30.370  57.716  38.034  1.00 28.02           O  
ATOM   1193  CB  ALA B  14      31.808  57.328  35.232  1.00 28.60           C  
ATOM   1194  N   MET B  15      29.904  55.635  37.331  1.00 27.74           N  
ATOM   1195  CA  MET B  15      28.621  55.552  38.035  1.00 28.94           C  
ATOM   1196  C   MET B  15      28.765  55.777  39.534  1.00 28.80           C  
ATOM   1197  O   MET B  15      27.855  56.301  40.173  1.00 26.42           O  
ATOM   1198  CB  MET B  15      27.971  54.173  37.832  1.00 33.04           C  
ATOM   1199  CG  MET B  15      27.407  53.900  36.436  1.00 37.41           C  
ATOM   1200  SD  MET B  15      26.784  52.191  36.274  1.00 37.87           S  
ATOM   1201  CE  MET B  15      25.348  52.228  37.400  1.00 38.93           C  
ATOM   1202  N   GLY B  16      29.912  55.379  40.087  1.00 26.35           N  
ATOM   1203  CA  GLY B  16      30.130  55.501  41.515  1.00 25.31           C  
ATOM   1204  C   GLY B  16      30.606  56.814  42.102  1.00 26.21           C  
ATOM   1205  O   GLY B  16      30.619  56.958  43.323  1.00 24.63           O  
ATOM   1206  N   GLU B  17      30.996  57.768  41.268  1.00 28.46           N  
ATOM   1207  CA  GLU B  17      31.474  59.049  41.791  1.00 34.84           C  
ATOM   1208  C   GLU B  17      30.345  59.743  42.533  1.00 30.26           C  
ATOM   1209  O   GLU B  17      29.210  59.786  42.049  1.00 31.33           O  
ATOM   1210  CB  GLU B  17      31.961  59.960  40.662  1.00 42.34           C  
ATOM   1211  CG  GLU B  17      32.883  59.276  39.673  1.00 55.66           C  
ATOM   1212  CD  GLU B  17      33.420  60.232  38.629  1.00 63.60           C  
ATOM   1213  OE1 GLU B  17      33.840  59.757  37.550  1.00 67.05           O  
ATOM   1214  OE2 GLU B  17      33.428  61.458  38.890  1.00 68.59           O  
ATOM   1215  N   GLY B  18      30.653  60.265  43.714  1.00 26.51           N  
ATOM   1216  CA  GLY B  18      29.636  60.955  44.493  1.00 30.96           C  
ATOM   1217  C   GLY B  18      28.784  60.086  45.405  1.00 30.85           C  
ATOM   1218  O   GLY B  18      27.975  60.613  46.172  1.00 31.52           O  
ATOM   1219  N   ASN B  19      28.934  58.765  45.331  1.00 28.99           N  
ATOM   1220  CA  ASN B  19      28.151  57.900  46.202  1.00 31.46           C  
ATOM   1221  C   ASN B  19      28.989  56.820  46.904  1.00 33.77           C  
ATOM   1222  O   ASN B  19      30.219  56.805  46.785  1.00 30.13           O  
ATOM   1223  CB  ASN B  19      26.950  57.302  45.446  1.00 28.76           C  
ATOM   1224  CG  ASN B  19      27.346  56.580  44.177  1.00 34.03           C  
ATOM   1225  OD1 ASN B  19      27.917  55.494  44.228  1.00 32.23           O  
ATOM   1226  ND2 ASN B  19      27.039  57.183  43.026  1.00 30.32           N  
ATOM   1227  N   MET B  20      28.327  55.931  47.643  1.00 30.69           N  
ATOM   1228  CA  MET B  20      29.035  54.913  48.404  1.00 27.58           C  
ATOM   1229  C   MET B  20      30.137  54.165  47.667  1.00 24.86           C  
ATOM   1230  O   MET B  20      31.233  53.992  48.204  1.00 19.83           O  
ATOM   1231  CB  MET B  20      28.055  53.915  49.009  1.00 26.05           C  
ATOM   1232  CG  MET B  20      28.736  52.890  49.898  1.00 24.51           C  
ATOM   1233  SD  MET B  20      27.616  52.097  51.056  1.00 27.53           S  
ATOM   1234  CE  MET B  20      28.490  52.408  52.547  1.00 22.34           C  
ATOM   1235  N   VAL B  21      29.849  53.718  46.450  1.00 21.34           N  
ATOM   1236  CA  VAL B  21      30.841  53.002  45.680  1.00 26.72           C  
ATOM   1237  C   VAL B  21      32.102  53.856  45.497  1.00 27.59           C  
ATOM   1238  O   VAL B  21      33.216  53.373  45.683  1.00 24.45           O  
ATOM   1239  CB  VAL B  21      30.267  52.576  44.309  1.00 28.48           C  
ATOM   1240  CG1 VAL B  21      31.386  52.245  43.353  1.00 23.13           C  
ATOM   1241  CG2 VAL B  21      29.368  51.361  44.489  1.00 31.18           C  
ATOM   1242  N   GLY B  22      31.921  55.128  45.153  1.00 27.20           N  
ATOM   1243  CA  GLY B  22      33.063  56.003  44.972  1.00 23.83           C  
ATOM   1244  C   GLY B  22      33.792  56.268  46.278  1.00 26.11           C  
ATOM   1245  O   GLY B  22      35.020  56.362  46.308  1.00 24.94           O  
ATOM   1246  N   PHE B  23      33.045  56.373  47.372  1.00 26.15           N  
ATOM   1247  CA  PHE B  23      33.663  56.650  48.659  1.00 30.91           C  
ATOM   1248  C   PHE B  23      34.464  55.512  49.274  1.00 28.08           C  
ATOM   1249  O   PHE B  23      35.332  55.755  50.098  1.00 27.94           O  
ATOM   1250  CB  PHE B  23      32.619  57.182  49.647  1.00 37.68           C  
ATOM   1251  CG  PHE B  23      32.392  58.670  49.528  1.00 52.52           C  
ATOM   1252  CD1 PHE B  23      31.772  59.212  48.395  1.00 52.20           C  
ATOM   1253  CD2 PHE B  23      32.851  59.541  50.523  1.00 53.87           C  
ATOM   1254  CE1 PHE B  23      31.616  60.599  48.254  1.00 56.09           C  
ATOM   1255  CE2 PHE B  23      32.701  60.932  50.391  1.00 54.55           C  
ATOM   1256  CZ  PHE B  23      32.083  61.462  49.255  1.00 55.82           C  
ATOM   1257  N   LEU B  24      34.197  54.272  48.875  1.00 29.52           N  
ATOM   1258  CA  LEU B  24      34.968  53.150  49.413  1.00 28.09           C  
ATOM   1259  C   LEU B  24      36.003  52.687  48.379  1.00 28.06           C  
ATOM   1260  O   LEU B  24      36.642  51.642  48.540  1.00 29.07           O  
ATOM   1261  CB  LEU B  24      34.040  51.992  49.806  1.00 23.39           C  
ATOM   1262  CG  LEU B  24      32.863  52.343  50.735  1.00 26.31           C  
ATOM   1263  CD1 LEU B  24      32.095  51.072  51.081  1.00 22.14           C  
ATOM   1264  CD2 LEU B  24      33.361  53.042  51.997  1.00 20.83           C  
ATOM   1265  N   ASP B  25      36.174  53.483  47.324  1.00 29.43           N  
ATOM   1266  CA  ASP B  25      37.134  53.166  46.270  1.00 27.62           C  
ATOM   1267  C   ASP B  25      36.871  51.790  45.661  1.00 26.87           C  
ATOM   1268  O   ASP B  25      37.792  51.013  45.431  1.00 22.28           O  
ATOM   1269  CB  ASP B  25      38.576  53.207  46.807  1.00 30.56           C  
ATOM   1270  CG  ASP B  25      39.140  54.622  46.909  1.00 32.88           C  
ATOM   1271  OD1 ASP B  25      38.479  55.577  46.454  1.00 34.86           O  
ATOM   1272  OD2 ASP B  25      40.264  54.773  47.441  1.00 34.61           O  
ATOM   1273  N   ILE B  26      35.607  51.488  45.408  1.00 26.78           N  
ATOM   1274  CA  ILE B  26      35.269  50.226  44.794  1.00 26.15           C  
ATOM   1275  C   ILE B  26      35.469  50.428  43.300  1.00 27.65           C  
ATOM   1276  O   ILE B  26      34.846  51.305  42.694  1.00 30.93           O  
ATOM   1277  CB  ILE B  26      33.819  49.818  45.130  1.00 25.19           C  
ATOM   1278  CG1 ILE B  26      33.766  49.311  46.581  1.00 21.53           C  
ATOM   1279  CG2 ILE B  26      33.340  48.747  44.165  1.00 24.67           C  
ATOM   1280  CD1 ILE B  26      32.371  49.119  47.126  1.00 21.96           C  
ATOM   1281  N   ARG B  27      36.354  49.617  42.719  1.00 26.55           N  
ATOM   1282  CA  ARG B  27      36.689  49.718  41.310  1.00 26.08           C  
ATOM   1283  C   ARG B  27      36.385  48.463  40.508  1.00 26.00           C  
ATOM   1284  O   ARG B  27      36.865  47.373  40.829  1.00 22.31           O  
ATOM   1285  CB  ARG B  27      38.183  50.039  41.130  1.00 24.65           C  
ATOM   1286  CG  ARG B  27      38.697  51.283  41.867  1.00 30.18           C  
ATOM   1287  CD  ARG B  27      37.920  52.537  41.491  1.00 31.60           C  
ATOM   1288  NE  ARG B  27      38.146  52.945  40.105  1.00 31.53           N  
ATOM   1289  CZ  ARG B  27      37.578  54.006  39.537  1.00 26.88           C  
ATOM   1290  NH1 ARG B  27      37.838  54.308  38.272  1.00 27.34           N  
ATOM   1291  NH2 ARG B  27      36.739  54.764  40.233  1.00 23.74           N  
ATOM   1292  N   PHE B  28      35.587  48.622  39.461  1.00 22.01           N  
ATOM   1293  CA  PHE B  28      35.297  47.505  38.595  1.00 25.68           C  
ATOM   1294  C   PHE B  28      36.563  47.368  37.754  1.00 27.35           C  
ATOM   1295  O   PHE B  28      37.065  48.352  37.198  1.00 27.78           O  
ATOM   1296  CB  PHE B  28      34.083  47.807  37.716  1.00 23.87           C  
ATOM   1297  CG  PHE B  28      32.796  47.840  38.477  1.00 23.62           C  
ATOM   1298  CD1 PHE B  28      32.354  49.015  39.073  1.00 25.38           C  
ATOM   1299  CD2 PHE B  28      32.061  46.671  38.664  1.00 26.03           C  
ATOM   1300  CE1 PHE B  28      31.197  49.024  39.846  1.00 25.89           C  
ATOM   1301  CE2 PHE B  28      30.908  46.670  39.435  1.00 24.03           C  
ATOM   1302  CZ  PHE B  28      30.476  47.846  40.026  1.00 24.51           C  
ATOM   1303  N   GLU B  29      37.101  46.159  37.688  1.00 26.54           N  
ATOM   1304  CA  GLU B  29      38.315  45.945  36.930  1.00 27.46           C  
ATOM   1305  C   GLU B  29      38.191  44.935  35.807  1.00 26.06           C  
ATOM   1306  O   GLU B  29      39.122  44.740  35.040  1.00 25.56           O  
ATOM   1307  CB  GLU B  29      39.444  45.541  37.876  1.00 32.96           C  
ATOM   1308  CG  GLU B  29      39.851  46.657  38.822  1.00 32.27           C  
ATOM   1309  CD  GLU B  29      41.164  46.367  39.510  1.00 35.19           C  
ATOM   1310  OE1 GLU B  29      41.163  46.193  40.746  1.00 39.01           O  
ATOM   1311  OE2 GLU B  29      42.198  46.301  38.809  1.00 36.40           O  
ATOM   1312  N   HIS B  30      37.037  44.298  35.681  1.00 29.15           N  
ATOM   1313  CA  HIS B  30      36.900  43.329  34.611  1.00 31.16           C  
ATOM   1314  C   HIS B  30      35.482  42.888  34.310  1.00 29.89           C  
ATOM   1315  O   HIS B  30      34.727  42.506  35.204  1.00 25.82           O  
ATOM   1316  CB  HIS B  30      37.774  42.096  34.897  1.00 32.59           C  
ATOM   1317  CG  HIS B  30      37.721  41.061  33.820  1.00 33.16           C  
ATOM   1318  ND1 HIS B  30      36.819  40.017  33.832  1.00 39.45           N  
ATOM   1319  CD2 HIS B  30      38.409  40.947  32.660  1.00 32.52           C  
ATOM   1320  CE1 HIS B  30      36.952  39.309  32.725  1.00 29.45           C  
ATOM   1321  NE2 HIS B  30      37.909  39.852  31.996  1.00 30.48           N  
ATOM   1322  N   ILE B  31      35.139  42.965  33.030  1.00 28.44           N  
ATOM   1323  CA  ILE B  31      33.839  42.545  32.538  1.00 31.43           C  
ATOM   1324  C   ILE B  31      34.089  41.395  31.561  1.00 32.57           C  
ATOM   1325  O   ILE B  31      34.674  41.594  30.495  1.00 30.28           O  
ATOM   1326  CB  ILE B  31      33.134  43.670  31.771  1.00 26.45           C  
ATOM   1327  CG1 ILE B  31      33.191  44.966  32.579  1.00 34.42           C  
ATOM   1328  CG2 ILE B  31      31.701  43.266  31.482  1.00 26.14           C  
ATOM   1329  CD1 ILE B  31      32.565  46.151  31.875  1.00 34.72           C  
ATOM   1330  N   GLY B  32      33.675  40.193  31.940  1.00 34.62           N  
ATOM   1331  CA  GLY B  32      33.854  39.054  31.064  1.00 35.68           C  
ATOM   1332  C   GLY B  32      32.545  38.808  30.344  1.00 38.72           C  
ATOM   1333  O   GLY B  32      31.621  39.619  30.446  1.00 40.48           O  
ATOM   1334  N   ASP B  33      32.455  37.697  29.623  1.00 37.32           N  
ATOM   1335  CA  ASP B  33      31.235  37.356  28.908  1.00 34.65           C  
ATOM   1336  C   ASP B  33      30.080  37.124  29.861  1.00 31.55           C  
ATOM   1337  O   ASP B  33      28.947  37.514  29.583  1.00 34.24           O  
ATOM   1338  CB  ASP B  33      31.437  36.092  28.067  1.00 40.54           C  
ATOM   1339  CG  ASP B  33      31.803  36.404  26.630  1.00 49.53           C  
ATOM   1340  OD1 ASP B  33      31.945  35.451  25.837  1.00 52.40           O  
ATOM   1341  OD2 ASP B  33      31.944  37.603  26.296  1.00 48.45           O  
ATOM   1342  N   ASP B  34      30.367  36.480  30.985  1.00 30.70           N  
ATOM   1343  CA  ASP B  34      29.334  36.166  31.967  1.00 31.25           C  
ATOM   1344  C   ASP B  34      29.816  36.326  33.401  1.00 30.66           C  
ATOM   1345  O   ASP B  34      29.361  35.610  34.296  1.00 33.13           O  
ATOM   1346  CB  ASP B  34      28.845  34.736  31.754  1.00 35.69           C  
ATOM   1347  CG  ASP B  34      29.971  33.720  31.815  1.00 39.32           C  
ATOM   1348  OD1 ASP B  34      29.732  32.546  31.460  1.00 52.18           O  
ATOM   1349  OD2 ASP B  34      31.093  34.087  32.224  1.00 33.74           O  
ATOM   1350  N   THR B  35      30.742  37.254  33.612  1.00 29.25           N  
ATOM   1351  CA  THR B  35      31.271  37.531  34.941  1.00 30.03           C  
ATOM   1352  C   THR B  35      31.598  39.019  35.051  1.00 30.34           C  
ATOM   1353  O   THR B  35      31.878  39.685  34.056  1.00 29.61           O  
ATOM   1354  CB  THR B  35      32.558  36.714  35.228  1.00 36.24           C  
ATOM   1355  OG1 THR B  35      32.253  35.314  35.206  1.00 42.34           O  
ATOM   1356  CG2 THR B  35      33.121  37.058  36.599  1.00 39.46           C  
ATOM   1357  N   LEU B  36      31.543  39.543  36.266  1.00 29.08           N  
ATOM   1358  CA  LEU B  36      31.847  40.943  36.501  1.00 27.98           C  
ATOM   1359  C   LEU B  36      32.682  40.975  37.759  1.00 25.17           C  
ATOM   1360  O   LEU B  36      32.361  40.286  38.715  1.00 26.72           O  
ATOM   1361  CB  LEU B  36      30.559  41.743  36.704  1.00 25.34           C  
ATOM   1362  CG  LEU B  36      30.771  43.242  36.905  1.00 25.62           C  
ATOM   1363  CD1 LEU B  36      31.556  43.821  35.721  1.00 16.92           C  
ATOM   1364  CD2 LEU B  36      29.408  43.914  37.028  1.00 29.18           C  
ATOM   1365  N   GLU B  37      33.744  41.771  37.765  1.00 25.01           N  
ATOM   1366  CA  GLU B  37      34.626  41.836  38.929  1.00 27.29           C  
ATOM   1367  C   GLU B  37      34.924  43.244  39.410  1.00 28.73           C  
ATOM   1368  O   GLU B  37      35.105  44.165  38.613  1.00 30.17           O  
ATOM   1369  CB  GLU B  37      35.948  41.139  38.614  1.00 30.53           C  
ATOM   1370  CG  GLU B  37      35.817  39.665  38.284  1.00 36.09           C  
ATOM   1371  CD  GLU B  37      37.145  39.050  37.886  1.00 39.35           C  
ATOM   1372  OE1 GLU B  37      38.162  39.357  38.546  1.00 37.96           O  
ATOM   1373  OE2 GLU B  37      37.166  38.259  36.921  1.00 36.31           O  
ATOM   1374  N   ALA B  38      34.997  43.402  40.725  1.00 26.87           N  
ATOM   1375  CA  ALA B  38      35.295  44.696  41.312  1.00 27.60           C  
ATOM   1376  C   ALA B  38      36.183  44.497  42.538  1.00 28.10           C  
ATOM   1377  O   ALA B  38      36.100  43.476  43.214  1.00 26.86           O  
ATOM   1378  CB  ALA B  38      34.004  45.405  41.698  1.00 21.94           C  
ATOM   1379  N   THR B  39      37.036  45.479  42.802  1.00 27.13           N  
ATOM   1380  CA  THR B  39      37.952  45.447  43.933  1.00 31.58           C  
ATOM   1381  C   THR B  39      37.607  46.509  44.973  1.00 29.31           C  
ATOM   1382  O   THR B  39      36.994  47.530  44.661  1.00 31.00           O  
ATOM   1383  CB  THR B  39      39.412  45.665  43.470  1.00 32.43           C  
ATOM   1384  OG1 THR B  39      39.841  44.543  42.684  1.00 42.76           O  
ATOM   1385  CG2 THR B  39      40.326  45.800  44.653  1.00 40.97           C  
ATOM   1386  N   MET B  40      38.027  46.257  46.207  1.00 28.62           N  
ATOM   1387  CA  MET B  40      37.774  47.156  47.322  1.00 25.71           C  
ATOM   1388  C   MET B  40      38.951  47.126  48.294  1.00 24.75           C  
ATOM   1389  O   MET B  40      39.462  46.060  48.645  1.00 26.10           O  
ATOM   1390  CB  MET B  40      36.484  46.740  48.038  1.00 24.91           C  
ATOM   1391  CG  MET B  40      36.080  47.632  49.198  1.00 27.72           C  
ATOM   1392  SD  MET B  40      34.536  47.115  49.981  1.00 30.12           S  
ATOM   1393  CE  MET B  40      35.042  45.577  50.799  1.00 21.98           C  
ATOM   1394  N   PRO B  41      39.412  48.304  48.726  1.00 21.55           N  
ATOM   1395  CA  PRO B  41      40.536  48.334  49.662  1.00 22.66           C  
ATOM   1396  C   PRO B  41      40.094  47.897  51.054  1.00 22.11           C  
ATOM   1397  O   PRO B  41      38.941  48.077  51.436  1.00 25.43           O  
ATOM   1398  CB  PRO B  41      40.962  49.800  49.639  1.00 25.67           C  
ATOM   1399  CG  PRO B  41      39.646  50.517  49.464  1.00 25.59           C  
ATOM   1400  CD  PRO B  41      38.975  49.669  48.378  1.00 24.93           C  
ATOM   1401  N   VAL B  42      41.009  47.296  51.793  1.00 23.43           N  
ATOM   1402  CA  VAL B  42      40.739  46.888  53.165  1.00 26.94           C  
ATOM   1403  C   VAL B  42      41.474  47.941  53.993  1.00 28.40           C  
ATOM   1404  O   VAL B  42      42.642  47.768  54.323  1.00 32.73           O  
ATOM   1405  CB  VAL B  42      41.327  45.484  53.479  1.00 25.62           C  
ATOM   1406  CG1 VAL B  42      41.126  45.142  54.956  1.00 29.02           C  
ATOM   1407  CG2 VAL B  42      40.667  44.438  52.595  1.00 29.27           C  
ATOM   1408  N   ASP B  43      40.813  49.057  54.286  1.00 29.62           N  
ATOM   1409  CA  ASP B  43      41.458  50.101  55.066  1.00 29.60           C  
ATOM   1410  C   ASP B  43      40.541  50.730  56.116  1.00 30.71           C  
ATOM   1411  O   ASP B  43      39.494  50.164  56.443  1.00 25.15           O  
ATOM   1412  CB  ASP B  43      42.096  51.158  54.141  1.00 31.74           C  
ATOM   1413  CG  ASP B  43      41.091  51.875  53.244  1.00 37.86           C  
ATOM   1414  OD1 ASP B  43      41.483  52.227  52.108  1.00 34.76           O  
ATOM   1415  OD2 ASP B  43      39.934  52.115  53.664  1.00 37.04           O  
ATOM   1416  N   SER B  44      40.934  51.884  56.655  1.00 29.35           N  
ATOM   1417  CA  SER B  44      40.157  52.518  57.713  1.00 28.90           C  
ATOM   1418  C   SER B  44      38.705  52.796  57.347  1.00 29.95           C  
ATOM   1419  O   SER B  44      37.851  52.903  58.229  1.00 30.63           O  
ATOM   1420  CB  SER B  44      40.840  53.807  58.190  1.00 24.77           C  
ATOM   1421  OG  SER B  44      40.505  54.916  57.375  1.00 34.29           O  
ATOM   1422  N   ARG B  45      38.414  52.894  56.053  1.00 30.39           N  
ATOM   1423  CA  ARG B  45      37.049  53.162  55.615  1.00 27.92           C  
ATOM   1424  C   ARG B  45      36.220  51.886  55.561  1.00 27.31           C  
ATOM   1425  O   ARG B  45      34.989  51.933  55.526  1.00 27.45           O  
ATOM   1426  CB  ARG B  45      37.055  53.795  54.220  1.00 31.78           C  
ATOM   1427  CG  ARG B  45      37.728  55.157  54.130  1.00 32.83           C  
ATOM   1428  CD  ARG B  45      37.976  55.553  52.671  1.00 36.52           C  
ATOM   1429  NE  ARG B  45      39.043  54.746  52.081  1.00 38.07           N  
ATOM   1430  CZ  ARG B  45      39.459  54.842  50.819  1.00 35.54           C  
ATOM   1431  NH1 ARG B  45      40.443  54.064  50.384  1.00 26.36           N  
ATOM   1432  NH2 ARG B  45      38.890  55.706  49.991  1.00 29.24           N  
ATOM   1433  N   THR B  46      36.893  50.744  55.566  1.00 22.77           N  
ATOM   1434  CA  THR B  46      36.189  49.485  55.454  1.00 26.96           C  
ATOM   1435  C   THR B  46      36.465  48.484  56.553  1.00 27.81           C  
ATOM   1436  O   THR B  46      36.061  47.335  56.448  1.00 31.35           O  
ATOM   1437  CB  THR B  46      36.516  48.822  54.111  1.00 28.16           C  
ATOM   1438  OG1 THR B  46      37.936  48.625  54.020  1.00 29.15           O  
ATOM   1439  CG2 THR B  46      36.046  49.706  52.953  1.00 24.78           C  
ATOM   1440  N   LYS B  47      37.163  48.910  57.597  1.00 29.00           N  
ATOM   1441  CA  LYS B  47      37.477  48.019  58.707  1.00 31.67           C  
ATOM   1442  C   LYS B  47      36.559  48.275  59.890  1.00 34.13           C  
ATOM   1443  O   LYS B  47      36.011  49.376  60.038  1.00 30.35           O  
ATOM   1444  CB  LYS B  47      38.923  48.221  59.169  1.00 32.53           C  
ATOM   1445  CG  LYS B  47      39.981  47.723  58.198  1.00 32.37           C  
ATOM   1446  CD  LYS B  47      41.363  47.953  58.759  1.00 32.09           C  
ATOM   1447  CE  LYS B  47      42.433  47.603  57.754  1.00 35.97           C  
ATOM   1448  NZ  LYS B  47      43.782  47.897  58.298  1.00 40.46           N  
ATOM   1449  N   GLN B  48      36.381  47.256  60.726  1.00 31.91           N  
ATOM   1450  CA  GLN B  48      35.576  47.420  61.930  1.00 35.78           C  
ATOM   1451  C   GLN B  48      36.544  47.879  63.044  1.00 38.83           C  
ATOM   1452  O   GLN B  48      37.755  47.946  62.823  1.00 34.96           O  
ATOM   1453  CB  GLN B  48      34.844  46.109  62.268  1.00 35.37           C  
ATOM   1454  CG  GLN B  48      35.517  44.857  61.772  1.00 35.67           C  
ATOM   1455  CD  GLN B  48      36.613  44.396  62.694  1.00 37.09           C  
ATOM   1456  OE1 GLN B  48      37.412  45.197  63.172  1.00 39.52           O  
ATOM   1457  NE2 GLN B  48      36.663  43.097  62.945  1.00 40.45           N  
ATOM   1458  N   PRO B  49      36.030  48.218  64.242  1.00 41.69           N  
ATOM   1459  CA  PRO B  49      36.880  48.679  65.351  1.00 41.42           C  
ATOM   1460  C   PRO B  49      38.135  47.867  65.695  1.00 41.40           C  
ATOM   1461  O   PRO B  49      39.094  48.407  66.249  1.00 42.21           O  
ATOM   1462  CB  PRO B  49      35.903  48.746  66.524  1.00 41.75           C  
ATOM   1463  CG  PRO B  49      34.603  49.104  65.850  1.00 44.62           C  
ATOM   1464  CD  PRO B  49      34.616  48.173  64.658  1.00 42.05           C  
ATOM   1465  N   PHE B  50      38.142  46.585  65.355  1.00 42.50           N  
ATOM   1466  CA  PHE B  50      39.278  45.722  65.670  1.00 45.10           C  
ATOM   1467  C   PHE B  50      40.374  45.633  64.602  1.00 43.24           C  
ATOM   1468  O   PHE B  50      41.220  44.738  64.642  1.00 45.28           O  
ATOM   1469  CB  PHE B  50      38.770  44.321  66.017  1.00 46.74           C  
ATOM   1470  CG  PHE B  50      37.794  44.303  67.166  1.00 55.32           C  
ATOM   1471  CD1 PHE B  50      36.495  44.782  67.005  1.00 52.29           C  
ATOM   1472  CD2 PHE B  50      38.182  43.830  68.421  1.00 58.60           C  
ATOM   1473  CE1 PHE B  50      35.597  44.792  68.074  1.00 58.04           C  
ATOM   1474  CE2 PHE B  50      37.289  43.836  69.500  1.00 59.47           C  
ATOM   1475  CZ  PHE B  50      35.996  44.318  69.325  1.00 60.41           C  
ATOM   1476  N   GLY B  51      40.351  46.555  63.647  1.00 40.42           N  
ATOM   1477  CA  GLY B  51      41.365  46.571  62.609  1.00 36.69           C  
ATOM   1478  C   GLY B  51      41.219  45.567  61.485  1.00 38.76           C  
ATOM   1479  O   GLY B  51      42.150  45.401  60.694  1.00 39.06           O  
ATOM   1480  N   LEU B  52      40.068  44.901  61.398  1.00 33.61           N  
ATOM   1481  CA  LEU B  52      39.853  43.917  60.338  1.00 35.63           C  
ATOM   1482  C   LEU B  52      38.744  44.338  59.384  1.00 34.76           C  
ATOM   1483  O   LEU B  52      37.930  45.202  59.706  1.00 35.00           O  
ATOM   1484  CB  LEU B  52      39.484  42.549  60.924  1.00 36.28           C  
ATOM   1485  CG  LEU B  52      40.484  41.781  61.792  1.00 37.17           C  
ATOM   1486  CD1 LEU B  52      39.845  40.478  62.256  1.00 33.46           C  
ATOM   1487  CD2 LEU B  52      41.748  41.503  60.993  1.00 41.68           C  
ATOM   1488  N   LEU B  53      38.712  43.710  58.213  1.00 31.85           N  
ATOM   1489  CA  LEU B  53      37.683  44.004  57.220  1.00 33.14           C  
ATOM   1490  C   LEU B  53      36.267  43.858  57.788  1.00 29.99           C  
ATOM   1491  O   LEU B  53      35.893  42.797  58.274  1.00 30.48           O  
ATOM   1492  CB  LEU B  53      37.815  43.067  56.021  1.00 30.22           C  
ATOM   1493  CG  LEU B  53      36.597  43.129  55.096  1.00 35.35           C  
ATOM   1494  CD1 LEU B  53      36.547  44.485  54.417  1.00 29.60           C  
ATOM   1495  CD2 LEU B  53      36.662  42.019  54.073  1.00 35.79           C  
ATOM   1496  N   HIS B  54      35.484  44.925  57.697  1.00 29.57           N  
ATOM   1497  CA  HIS B  54      34.103  44.940  58.183  1.00 28.85           C  
ATOM   1498  C   HIS B  54      33.208  44.092  57.275  1.00 27.90           C  
ATOM   1499  O   HIS B  54      33.098  44.355  56.083  1.00 27.83           O  
ATOM   1500  CB  HIS B  54      33.589  46.382  58.195  1.00 27.79           C  
ATOM   1501  CG  HIS B  54      32.315  46.573  58.956  1.00 32.25           C  
ATOM   1502  ND1 HIS B  54      31.213  45.762  58.784  1.00 32.22           N  
ATOM   1503  CD2 HIS B  54      31.958  47.507  59.875  1.00 31.93           C  
ATOM   1504  CE1 HIS B  54      30.231  46.188  59.564  1.00 33.13           C  
ATOM   1505  NE2 HIS B  54      30.656  47.243  60.234  1.00 32.05           N  
ATOM   1506  N   GLY B  55      32.578  43.069  57.841  1.00 28.65           N  
ATOM   1507  CA  GLY B  55      31.702  42.222  57.054  1.00 27.01           C  
ATOM   1508  C   GLY B  55      30.671  43.008  56.263  1.00 25.54           C  
ATOM   1509  O   GLY B  55      30.269  42.587  55.176  1.00 26.56           O  
ATOM   1510  N   GLY B  56      30.231  44.140  56.807  1.00 25.06           N  
ATOM   1511  CA  GLY B  56      29.263  44.965  56.104  1.00 24.38           C  
ATOM   1512  C   GLY B  56      29.839  45.471  54.790  1.00 23.65           C  
ATOM   1513  O   GLY B  56      29.133  45.548  53.783  1.00 24.72           O  
ATOM   1514  N   ALA B  57      31.121  45.833  54.799  1.00 23.34           N  
ATOM   1515  CA  ALA B  57      31.798  46.310  53.586  1.00 24.39           C  
ATOM   1516  C   ALA B  57      31.756  45.221  52.526  1.00 25.73           C  
ATOM   1517  O   ALA B  57      31.493  45.484  51.349  1.00 27.65           O  
ATOM   1518  CB  ALA B  57      33.241  46.666  53.892  1.00 25.12           C  
ATOM   1519  N   SER B  58      32.037  43.991  52.939  1.00 23.99           N  
ATOM   1520  CA  SER B  58      32.008  42.887  51.996  1.00 24.12           C  
ATOM   1521  C   SER B  58      30.629  42.812  51.350  1.00 25.16           C  
ATOM   1522  O   SER B  58      30.521  42.573  50.153  1.00 28.56           O  
ATOM   1523  CB  SER B  58      32.347  41.563  52.700  1.00 23.91           C  
ATOM   1524  OG  SER B  58      33.728  41.522  53.047  1.00 24.77           O  
ATOM   1525  N   VAL B  59      29.575  43.018  52.137  1.00 22.45           N  
ATOM   1526  CA  VAL B  59      28.233  42.978  51.581  1.00 23.07           C  
ATOM   1527  C   VAL B  59      28.030  44.200  50.682  1.00 22.76           C  
ATOM   1528  O   VAL B  59      27.310  44.121  49.688  1.00 20.63           O  
ATOM   1529  CB  VAL B  59      27.150  42.909  52.687  1.00 22.80           C  
ATOM   1530  CG1 VAL B  59      25.748  42.948  52.072  1.00 14.51           C  
ATOM   1531  CG2 VAL B  59      27.309  41.612  53.470  1.00 24.66           C  
ATOM   1532  N   VAL B  60      28.670  45.323  51.017  1.00 22.18           N  
ATOM   1533  CA  VAL B  60      28.569  46.509  50.167  1.00 22.06           C  
ATOM   1534  C   VAL B  60      29.193  46.161  48.802  1.00 22.94           C  
ATOM   1535  O   VAL B  60      28.614  46.450  47.760  1.00 21.28           O  
ATOM   1536  CB  VAL B  60      29.313  47.732  50.763  1.00 23.26           C  
ATOM   1537  CG1 VAL B  60      29.494  48.803  49.679  1.00 19.96           C  
ATOM   1538  CG2 VAL B  60      28.511  48.319  51.941  1.00 21.35           C  
ATOM   1539  N   LEU B  61      30.365  45.530  48.811  1.00 20.07           N  
ATOM   1540  CA  LEU B  61      31.014  45.152  47.552  1.00 24.15           C  
ATOM   1541  C   LEU B  61      30.130  44.226  46.719  1.00 24.85           C  
ATOM   1542  O   LEU B  61      29.931  44.450  45.522  1.00 22.80           O  
ATOM   1543  CB  LEU B  61      32.344  44.442  47.814  1.00 23.69           C  
ATOM   1544  CG  LEU B  61      33.147  44.007  46.581  1.00 27.97           C  
ATOM   1545  CD1 LEU B  61      33.417  45.211  45.645  1.00 19.17           C  
ATOM   1546  CD2 LEU B  61      34.462  43.374  47.062  1.00 21.87           C  
ATOM   1547  N   ALA B  62      29.609  43.185  47.363  1.00 20.95           N  
ATOM   1548  CA  ALA B  62      28.753  42.213  46.699  1.00 21.13           C  
ATOM   1549  C   ALA B  62      27.493  42.849  46.106  1.00 21.79           C  
ATOM   1550  O   ALA B  62      27.191  42.662  44.927  1.00 25.36           O  
ATOM   1551  CB  ALA B  62      28.361  41.098  47.689  1.00 15.93           C  
ATOM   1552  N   GLU B  63      26.745  43.594  46.907  1.00 22.13           N  
ATOM   1553  CA  GLU B  63      25.544  44.186  46.360  1.00 22.47           C  
ATOM   1554  C   GLU B  63      25.878  45.169  45.267  1.00 21.41           C  
ATOM   1555  O   GLU B  63      25.140  45.285  44.300  1.00 22.69           O  
ATOM   1556  CB  GLU B  63      24.701  44.883  47.429  1.00 28.23           C  
ATOM   1557  CG  GLU B  63      23.293  45.179  46.893  1.00 33.64           C  
ATOM   1558  CD  GLU B  63      22.271  45.436  47.975  1.00 36.87           C  
ATOM   1559  OE1 GLU B  63      22.322  44.761  49.028  1.00 34.56           O  
ATOM   1560  OE2 GLU B  63      21.402  46.306  47.757  1.00 39.30           O  
ATOM   1561  N   SER B  64      27.003  45.860  45.403  1.00 22.73           N  
ATOM   1562  CA  SER B  64      27.405  46.835  44.390  1.00 24.38           C  
ATOM   1563  C   SER B  64      27.687  46.179  43.042  1.00 25.28           C  
ATOM   1564  O   SER B  64      27.289  46.703  42.000  1.00 20.61           O  
ATOM   1565  CB  SER B  64      28.637  47.606  44.858  1.00 26.38           C  
ATOM   1566  OG  SER B  64      28.344  48.393  46.005  1.00 26.72           O  
ATOM   1567  N   ILE B  65      28.383  45.041  43.057  1.00 21.86           N  
ATOM   1568  CA  ILE B  65      28.683  44.337  41.816  1.00 23.26           C  
ATOM   1569  C   ILE B  65      27.415  43.683  41.274  1.00 23.76           C  
ATOM   1570  O   ILE B  65      27.086  43.821  40.098  1.00 23.17           O  
ATOM   1571  CB  ILE B  65      29.723  43.196  42.002  1.00 23.13           C  
ATOM   1572  CG1 ILE B  65      31.038  43.736  42.556  1.00 23.60           C  
ATOM   1573  CG2 ILE B  65      29.981  42.541  40.661  1.00 23.51           C  
ATOM   1574  CD1 ILE B  65      32.037  42.647  42.957  1.00 19.02           C  
ATOM   1575  N   GLY B  66      26.720  42.961  42.146  1.00 24.06           N  
ATOM   1576  CA  GLY B  66      25.511  42.258  41.742  1.00 24.97           C  
ATOM   1577  C   GLY B  66      24.445  43.168  41.154  1.00 29.58           C  
ATOM   1578  O   GLY B  66      23.761  42.804  40.195  1.00 26.93           O  
ATOM   1579  N   SER B  67      24.311  44.354  41.737  1.00 28.55           N  
ATOM   1580  CA  SER B  67      23.328  45.328  41.292  1.00 28.59           C  
ATOM   1581  C   SER B  67      23.567  45.747  39.837  1.00 26.81           C  
ATOM   1582  O   SER B  67      22.640  45.731  39.028  1.00 26.47           O  
ATOM   1583  CB  SER B  67      23.354  46.553  42.227  1.00 26.24           C  
ATOM   1584  OG  SER B  67      22.333  47.473  41.893  0.65 41.91           O  
ATOM   1586  N   VAL B  68      24.805  46.106  39.502  1.00 28.46           N  
ATOM   1587  CA  VAL B  68      25.133  46.518  38.135  1.00 29.50           C  
ATOM   1588  C   VAL B  68      25.100  45.344  37.140  1.00 27.83           C  
ATOM   1589  O   VAL B  68      24.660  45.499  35.997  1.00 25.45           O  
ATOM   1590  CB  VAL B  68      26.523  47.205  38.064  1.00 29.99           C  
ATOM   1591  CG1 VAL B  68      26.577  48.379  39.034  1.00 35.13           C  
ATOM   1592  CG2 VAL B  68      27.616  46.218  38.376  1.00 38.25           C  
ATOM   1593  N   ALA B  69      25.571  44.175  37.566  1.00 24.48           N  
ATOM   1594  CA  ALA B  69      25.548  43.011  36.691  1.00 25.62           C  
ATOM   1595  C   ALA B  69      24.101  42.766  36.296  1.00 28.18           C  
ATOM   1596  O   ALA B  69      23.798  42.498  35.133  1.00 27.91           O  
ATOM   1597  CB  ALA B  69      26.103  41.803  37.403  1.00 25.51           C  
ATOM   1598  N   GLY B  70      23.208  42.869  37.281  1.00 32.33           N  
ATOM   1599  CA  GLY B  70      21.792  42.660  37.037  1.00 32.40           C  
ATOM   1600  C   GLY B  70      21.231  43.666  36.051  1.00 34.28           C  
ATOM   1601  O   GLY B  70      20.377  43.332  35.230  1.00 36.56           O  
ATOM   1602  N   TYR B  71      21.705  44.904  36.143  1.00 35.91           N  
ATOM   1603  CA  TYR B  71      21.276  45.984  35.253  1.00 36.67           C  
ATOM   1604  C   TYR B  71      21.758  45.731  33.826  1.00 38.30           C  
ATOM   1605  O   TYR B  71      21.027  45.964  32.860  1.00 38.32           O  
ATOM   1606  CB  TYR B  71      21.843  47.309  35.760  1.00 38.65           C  
ATOM   1607  CG  TYR B  71      21.841  48.447  34.760  1.00 47.03           C  
ATOM   1608  CD1 TYR B  71      20.651  48.928  34.216  1.00 53.14           C  
ATOM   1609  CD2 TYR B  71      23.032  49.072  34.391  1.00 49.10           C  
ATOM   1610  CE1 TYR B  71      20.649  50.010  33.332  1.00 53.64           C  
ATOM   1611  CE2 TYR B  71      23.042  50.149  33.513  1.00 51.47           C  
ATOM   1612  CZ  TYR B  71      21.848  50.614  32.987  1.00 54.27           C  
ATOM   1613  OH  TYR B  71      21.854  51.683  32.119  1.00 57.41           O  
ATOM   1614  N   LEU B  72      22.992  45.255  33.701  1.00 36.03           N  
ATOM   1615  CA  LEU B  72      23.574  44.989  32.394  1.00 36.43           C  
ATOM   1616  C   LEU B  72      22.833  43.882  31.667  1.00 34.61           C  
ATOM   1617  O   LEU B  72      22.946  43.748  30.453  1.00 33.24           O  
ATOM   1618  CB  LEU B  72      25.055  44.617  32.538  1.00 34.74           C  
ATOM   1619  CG  LEU B  72      25.947  45.719  33.120  1.00 34.70           C  
ATOM   1620  CD1 LEU B  72      27.306  45.153  33.457  1.00 33.01           C  
ATOM   1621  CD2 LEU B  72      26.065  46.869  32.142  1.00 30.93           C  
ATOM   1622  N   CYS B  73      22.080  43.085  32.415  1.00 34.53           N  
ATOM   1623  CA  CYS B  73      21.331  41.987  31.821  1.00 31.36           C  
ATOM   1624  C   CYS B  73      19.898  42.374  31.492  1.00 31.11           C  
ATOM   1625  O   CYS B  73      19.064  41.510  31.271  1.00 30.67           O  
ATOM   1626  CB  CYS B  73      21.352  40.760  32.741  1.00 34.56           C  
ATOM   1627  SG  CYS B  73      22.975  39.926  32.871  1.00 34.93           S  
ATOM   1628  N   THR B  74      19.620  43.675  31.459  1.00 35.99           N  
ATOM   1629  CA  THR B  74      18.288  44.176  31.110  1.00 38.93           C  
ATOM   1630  C   THR B  74      18.430  45.179  29.963  1.00 43.16           C  
ATOM   1631  O   THR B  74      19.410  45.920  29.891  1.00 45.17           O  
ATOM   1632  CB  THR B  74      17.592  44.904  32.287  1.00 35.80           C  
ATOM   1633  OG1 THR B  74      18.305  46.105  32.592  1.00 25.91           O  
ATOM   1634  CG2 THR B  74      17.518  44.003  33.527  1.00 29.29           C  
ATOM   1635  N   GLU B  75      17.444  45.214  29.076  1.00 45.62           N  
ATOM   1636  CA  GLU B  75      17.489  46.107  27.925  1.00 44.91           C  
ATOM   1637  C   GLU B  75      16.573  47.313  28.114  1.00 46.80           C  
ATOM   1638  O   GLU B  75      15.671  47.295  28.956  1.00 47.75           O  
ATOM   1639  CB  GLU B  75      17.092  45.326  26.662  1.00 45.21           C  
ATOM   1640  CG  GLU B  75      15.774  44.550  26.801  1.00 51.76           C  
ATOM   1641  CD  GLU B  75      15.430  43.692  25.581  1.00 57.89           C  
ATOM   1642  OE1 GLU B  75      16.210  42.770  25.246  1.00 60.82           O  
ATOM   1643  OE2 GLU B  75      14.370  43.936  24.960  1.00 59.42           O  
ATOM   1644  N   GLY B  76      16.819  48.361  27.337  1.00 47.22           N  
ATOM   1645  CA  GLY B  76      16.001  49.562  27.409  1.00 48.17           C  
ATOM   1646  C   GLY B  76      15.965  50.280  28.744  1.00 45.77           C  
ATOM   1647  O   GLY B  76      16.991  50.412  29.414  1.00 44.58           O  
ATOM   1648  N   GLU B  77      14.778  50.766  29.114  1.00 44.44           N  
ATOM   1649  CA  GLU B  77      14.584  51.486  30.376  1.00 38.68           C  
ATOM   1650  C   GLU B  77      14.280  50.538  31.524  1.00 36.77           C  
ATOM   1651  O   GLU B  77      13.849  50.981  32.585  1.00 32.81           O  
ATOM   1652  CB  GLU B  77      13.442  52.509  30.267  1.00 35.94           C  
ATOM   1653  CG  GLU B  77      13.705  53.667  29.327  1.00 36.21           C  
ATOM   1654  CD  GLU B  77      12.519  54.614  29.210  1.00 33.79           C  
ATOM   1655  OE1 GLU B  77      12.467  55.616  29.955  1.00 32.80           O  
ATOM   1656  OE2 GLU B  77      11.629  54.344  28.376  1.00 29.64           O  
ATOM   1657  N   GLN B  78      14.480  49.237  31.308  1.00 37.32           N  
ATOM   1658  CA  GLN B  78      14.257  48.251  32.366  1.00 37.53           C  
ATOM   1659  C   GLN B  78      15.226  48.526  33.501  1.00 36.56           C  
ATOM   1660  O   GLN B  78      16.229  49.217  33.318  1.00 35.70           O  
ATOM   1661  CB  GLN B  78      14.516  46.832  31.876  1.00 37.32           C  
ATOM   1662  CG  GLN B  78      13.464  46.260  30.991  1.00 39.55           C  
ATOM   1663  CD  GLN B  78      13.789  44.843  30.617  1.00 38.00           C  
ATOM   1664  OE1 GLN B  78      14.923  44.539  30.256  1.00 41.05           O  
ATOM   1665  NE2 GLN B  78      12.799  43.963  30.696  1.00 44.02           N  
ATOM   1666  N   LYS B  79      14.927  47.989  34.675  1.00 36.44           N  
ATOM   1667  CA  LYS B  79      15.799  48.183  35.827  1.00 36.92           C  
ATOM   1668  C   LYS B  79      15.697  47.040  36.815  1.00 34.94           C  
ATOM   1669  O   LYS B  79      14.760  46.251  36.781  1.00 35.43           O  
ATOM   1670  CB  LYS B  79      15.485  49.520  36.508  1.00 41.64           C  
ATOM   1671  CG  LYS B  79      16.189  50.676  35.832  1.00 48.43           C  
ATOM   1672  CD  LYS B  79      15.335  51.923  35.727  1.00 54.86           C  
ATOM   1673  CE  LYS B  79      16.020  52.945  34.821  1.00 51.08           C  
ATOM   1674  NZ  LYS B  79      15.255  54.212  34.723  1.00 58.58           N  
ATOM   1675  N   VAL B  80      16.681  46.938  37.691  1.00 35.45           N  
ATOM   1676  CA  VAL B  80      16.674  45.880  38.679  1.00 34.44           C  
ATOM   1677  C   VAL B  80      16.646  46.483  40.066  1.00 33.26           C  
ATOM   1678  O   VAL B  80      17.205  47.560  40.305  1.00 34.06           O  
ATOM   1679  CB  VAL B  80      17.921  44.990  38.564  1.00 34.88           C  
ATOM   1680  CG1 VAL B  80      18.037  44.441  37.157  1.00 33.37           C  
ATOM   1681  CG2 VAL B  80      19.152  45.781  38.942  1.00 35.83           C  
ATOM   1682  N   VAL B  81      15.983  45.786  40.976  1.00 29.11           N  
ATOM   1683  CA  VAL B  81      15.895  46.241  42.345  1.00 32.92           C  
ATOM   1684  C   VAL B  81      16.350  45.078  43.227  1.00 31.21           C  
ATOM   1685  O   VAL B  81      15.959  43.929  43.001  1.00 29.96           O  
ATOM   1686  CB  VAL B  81      14.434  46.696  42.693  1.00 32.13           C  
ATOM   1687  CG1 VAL B  81      13.459  45.552  42.504  1.00 33.78           C  
ATOM   1688  CG2 VAL B  81      14.367  47.220  44.117  1.00 37.35           C  
ATOM   1689  N   GLY B  82      17.210  45.374  44.200  1.00 30.89           N  
ATOM   1690  CA  GLY B  82      17.690  44.336  45.099  1.00 26.63           C  
ATOM   1691  C   GLY B  82      16.582  43.916  46.049  1.00 28.67           C  
ATOM   1692  O   GLY B  82      16.004  44.758  46.742  1.00 27.65           O  
ATOM   1693  N   LEU B  83      16.253  42.627  46.076  1.00 25.25           N  
ATOM   1694  CA  LEU B  83      15.218  42.156  46.990  1.00 25.36           C  
ATOM   1695  C   LEU B  83      15.841  41.678  48.304  1.00 25.94           C  
ATOM   1696  O   LEU B  83      15.532  42.199  49.379  1.00 24.61           O  
ATOM   1697  CB  LEU B  83      14.407  41.025  46.354  1.00 25.48           C  
ATOM   1698  CG  LEU B  83      13.484  41.466  45.211  1.00 25.86           C  
ATOM   1699  CD1 LEU B  83      12.838  40.264  44.527  1.00 21.20           C  
ATOM   1700  CD2 LEU B  83      12.435  42.374  45.780  1.00 19.12           C  
ATOM   1701  N   GLU B  84      16.722  40.688  48.221  1.00 26.29           N  
ATOM   1702  CA  GLU B  84      17.357  40.181  49.421  1.00 28.36           C  
ATOM   1703  C   GLU B  84      18.785  39.708  49.170  1.00 28.80           C  
ATOM   1704  O   GLU B  84      19.151  39.318  48.057  1.00 27.83           O  
ATOM   1705  CB  GLU B  84      16.489  39.085  50.065  1.00 30.11           C  
ATOM   1706  CG  GLU B  84      16.847  37.663  49.751  1.00 36.94           C  
ATOM   1707  CD  GLU B  84      17.811  37.050  50.763  1.00 29.87           C  
ATOM   1708  OE1 GLU B  84      17.493  37.001  51.966  1.00 28.98           O  
ATOM   1709  OE2 GLU B  84      18.889  36.607  50.339  1.00 33.77           O  
ATOM   1710  N   ILE B  85      19.595  39.781  50.217  1.00 27.80           N  
ATOM   1711  CA  ILE B  85      20.993  39.400  50.137  1.00 28.32           C  
ATOM   1712  C   ILE B  85      21.396  38.604  51.366  1.00 26.49           C  
ATOM   1713  O   ILE B  85      20.837  38.788  52.440  1.00 26.78           O  
ATOM   1714  CB  ILE B  85      21.890  40.662  50.035  1.00 25.71           C  
ATOM   1715  CG1 ILE B  85      23.360  40.257  49.964  1.00 24.90           C  
ATOM   1716  CG2 ILE B  85      21.645  41.584  51.242  1.00 26.68           C  
ATOM   1717  CD1 ILE B  85      24.231  41.288  49.295  1.00 29.16           C  
ATOM   1718  N   ASN B  86      22.359  37.709  51.193  1.00 28.08           N  
ATOM   1719  CA  ASN B  86      22.870  36.915  52.302  1.00 27.48           C  
ATOM   1720  C   ASN B  86      24.344  36.687  52.043  1.00 28.57           C  
ATOM   1721  O   ASN B  86      24.786  36.720  50.902  1.00 30.32           O  
ATOM   1722  CB  ASN B  86      22.117  35.589  52.409  1.00 30.97           C  
ATOM   1723  CG  ASN B  86      22.006  34.871  51.084  1.00 33.43           C  
ATOM   1724  OD1 ASN B  86      22.995  34.377  50.556  1.00 34.79           O  
ATOM   1725  ND2 ASN B  86      20.796  34.827  50.530  1.00 32.98           N  
ATOM   1726  N   ALA B  87      25.118  36.490  53.103  1.00 30.48           N  
ATOM   1727  CA  ALA B  87      26.543  36.266  52.943  1.00 27.79           C  
ATOM   1728  C   ALA B  87      27.172  35.525  54.112  1.00 29.09           C  
ATOM   1729  O   ALA B  87      26.761  35.672  55.268  1.00 26.62           O  
ATOM   1730  CB  ALA B  87      27.254  37.600  52.747  1.00 31.14           C  
ATOM   1731  N   ASN B  88      28.179  34.727  53.794  1.00 27.78           N  
ATOM   1732  CA  ASN B  88      28.916  33.992  54.798  1.00 28.19           C  
ATOM   1733  C   ASN B  88      30.335  34.510  54.857  1.00 27.98           C  
ATOM   1734  O   ASN B  88      31.041  34.547  53.847  1.00 24.98           O  
ATOM   1735  CB  ASN B  88      28.950  32.502  54.484  1.00 29.83           C  
ATOM   1736  CG  ASN B  88      27.616  31.856  54.669  1.00 33.16           C  
ATOM   1737  OD1 ASN B  88      26.771  31.889  53.774  1.00 35.07           O  
ATOM   1738  ND2 ASN B  88      27.399  31.276  55.848  1.00 27.24           N  
ATOM   1739  N   HIS B  89      30.740  34.933  56.047  1.00 29.06           N  
ATOM   1740  CA  HIS B  89      32.083  35.414  56.250  1.00 29.32           C  
ATOM   1741  C   HIS B  89      32.849  34.178  56.678  1.00 33.31           C  
ATOM   1742  O   HIS B  89      32.632  33.649  57.767  1.00 32.00           O  
ATOM   1743  CB  HIS B  89      32.078  36.493  57.324  1.00 32.58           C  
ATOM   1744  CG  HIS B  89      31.182  37.646  56.996  1.00 31.29           C  
ATOM   1745  ND1 HIS B  89      31.271  38.338  55.806  1.00 32.53           N  
ATOM   1746  CD2 HIS B  89      30.178  38.225  57.694  1.00 31.77           C  
ATOM   1747  CE1 HIS B  89      30.364  39.297  55.788  1.00 28.76           C  
ATOM   1748  NE2 HIS B  89      29.688  39.250  56.921  1.00 34.99           N  
ATOM   1749  N   VAL B  90      33.719  33.697  55.794  1.00 36.65           N  
ATOM   1750  CA  VAL B  90      34.480  32.486  56.067  1.00 37.26           C  
ATOM   1751  C   VAL B  90      35.950  32.724  56.378  1.00 41.70           C  
ATOM   1752  O   VAL B  90      36.670  31.791  56.718  1.00 44.74           O  
ATOM   1753  CB  VAL B  90      34.381  31.510  54.892  1.00 35.82           C  
ATOM   1754  CG1 VAL B  90      32.921  31.215  54.595  1.00 36.63           C  
ATOM   1755  CG2 VAL B  90      35.065  32.088  53.671  1.00 32.26           C  
ATOM   1756  N   ARG B  91      36.398  33.967  56.255  1.00 41.47           N  
ATOM   1757  CA  ARG B  91      37.786  34.294  56.542  1.00 40.03           C  
ATOM   1758  C   ARG B  91      37.949  35.809  56.593  1.00 39.32           C  
ATOM   1759  O   ARG B  91      37.333  36.528  55.817  1.00 42.85           O  
ATOM   1760  CB  ARG B  91      38.706  33.716  55.465  1.00 41.01           C  
ATOM   1761  CG  ARG B  91      40.161  33.850  55.825  1.00 44.60           C  
ATOM   1762  CD  ARG B  91      41.093  33.701  54.646  1.00 51.26           C  
ATOM   1763  NE  ARG B  91      42.468  33.600  55.126  1.00 57.39           N  
ATOM   1764  CZ  ARG B  91      43.041  32.461  55.506  1.00 58.70           C  
ATOM   1765  NH1 ARG B  91      44.292  32.463  55.943  1.00 64.59           N  
ATOM   1766  NH2 ARG B  91      42.377  31.315  55.414  1.00 57.13           N  
ATOM   1767  N   SER B  92      38.788  36.288  57.499  1.00 39.13           N  
ATOM   1768  CA  SER B  92      39.008  37.718  57.656  1.00 41.66           C  
ATOM   1769  C   SER B  92      40.099  38.276  56.739  1.00 39.21           C  
ATOM   1770  O   SER B  92      40.820  37.528  56.085  1.00 41.79           O  
ATOM   1771  CB  SER B  92      39.370  38.020  59.109  1.00 45.61           C  
ATOM   1772  OG  SER B  92      40.596  37.401  59.461  1.00 46.64           O  
ATOM   1773  N   ALA B  93      40.207  39.601  56.708  1.00 37.70           N  
ATOM   1774  CA  ALA B  93      41.197  40.296  55.891  1.00 35.92           C  
ATOM   1775  C   ALA B  93      41.603  41.524  56.687  1.00 36.18           C  
ATOM   1776  O   ALA B  93      40.778  42.084  57.409  1.00 38.31           O  
ATOM   1777  CB  ALA B  93      40.583  40.711  54.555  1.00 35.37           C  
ATOM   1778  N   ARG B  94      42.857  41.950  56.564  1.00 34.42           N  
ATOM   1779  CA  ARG B  94      43.331  43.103  57.321  1.00 37.90           C  
ATOM   1780  C   ARG B  94      44.113  44.143  56.511  1.00 39.17           C  
ATOM   1781  O   ARG B  94      44.424  45.232  57.020  1.00 36.85           O  
ATOM   1782  CB  ARG B  94      44.196  42.630  58.501  1.00 43.82           C  
ATOM   1783  CG  ARG B  94      45.343  41.722  58.100  1.00 49.53           C  
ATOM   1784  CD  ARG B  94      46.407  41.625  59.187  1.00 57.22           C  
ATOM   1785  NE  ARG B  94      47.588  40.905  58.709  1.00 63.35           N  
ATOM   1786  CZ  ARG B  94      48.783  40.926  59.296  1.00 62.34           C  
ATOM   1787  NH1 ARG B  94      49.788  40.234  58.775  1.00 61.89           N  
ATOM   1788  NH2 ARG B  94      48.981  41.641  60.396  1.00 63.61           N  
ATOM   1789  N   GLU B  95      44.443  43.816  55.265  1.00 35.98           N  
ATOM   1790  CA  GLU B  95      45.181  44.758  54.434  1.00 37.54           C  
ATOM   1791  C   GLU B  95      45.073  44.406  52.960  1.00 34.93           C  
ATOM   1792  O   GLU B  95      44.673  43.307  52.602  1.00 33.62           O  
ATOM   1793  CB  GLU B  95      46.656  44.789  54.845  1.00 37.59           C  
ATOM   1794  CG  GLU B  95      47.439  43.567  54.408  1.00 41.82           C  
ATOM   1795  CD  GLU B  95      48.708  43.383  55.203  1.00 47.66           C  
ATOM   1796  OE1 GLU B  95      49.538  44.312  55.224  1.00 49.91           O  
ATOM   1797  OE2 GLU B  95      48.871  42.304  55.810  1.00 52.19           O  
ATOM   1798  N   GLY B  96      45.439  45.358  52.114  1.00 34.62           N  
ATOM   1799  CA  GLY B  96      45.377  45.135  50.688  1.00 29.69           C  
ATOM   1800  C   GLY B  96      43.995  45.412  50.148  1.00 30.95           C  
ATOM   1801  O   GLY B  96      43.357  46.420  50.476  1.00 28.67           O  
ATOM   1802  N   ARG B  97      43.518  44.500  49.321  1.00 27.82           N  
ATOM   1803  CA  ARG B  97      42.214  44.661  48.716  1.00 29.71           C  
ATOM   1804  C   ARG B  97      41.559  43.303  48.622  1.00 27.32           C  
ATOM   1805  O   ARG B  97      42.212  42.277  48.756  1.00 29.49           O  
ATOM   1806  CB  ARG B  97      42.371  45.251  47.307  1.00 32.45           C  
ATOM   1807  CG  ARG B  97      43.493  46.302  47.218  0.65 36.97           C  
ATOM   1809  CD  ARG B  97      43.639  46.952  45.834  0.65 41.15           C  
ATOM   1811  NE  ARG B  97      42.830  48.167  45.692  0.65 42.10           N  
ATOM   1813  CZ  ARG B  97      43.049  49.314  46.342  0.65 38.61           C  
ATOM   1815  NH1 ARG B  97      42.244  50.359  46.141  0.65 18.85           N  
ATOM   1817  NH2 ARG B  97      44.070  49.422  47.186  0.65 26.24           N  
ATOM   1819  N   VAL B  98      40.252  43.300  48.442  1.00 24.33           N  
ATOM   1820  CA  VAL B  98      39.546  42.060  48.266  1.00 25.55           C  
ATOM   1821  C   VAL B  98      38.909  42.191  46.892  1.00 25.17           C  
ATOM   1822  O   VAL B  98      38.598  43.301  46.430  1.00 24.88           O  
ATOM   1823  CB  VAL B  98      38.502  41.825  49.380  1.00 26.66           C  
ATOM   1824  CG1 VAL B  98      39.219  41.409  50.663  1.00 25.45           C  
ATOM   1825  CG2 VAL B  98      37.685  43.084  49.622  1.00 32.32           C  
ATOM   1826  N   ARG B  99      38.743  41.063  46.224  1.00 24.42           N  
ATOM   1827  CA  ARG B  99      38.186  41.060  44.884  1.00 27.56           C  
ATOM   1828  C   ARG B  99      36.875  40.310  44.833  1.00 24.18           C  
ATOM   1829  O   ARG B  99      36.788  39.174  45.297  1.00 27.39           O  
ATOM   1830  CB  ARG B  99      39.194  40.430  43.912  1.00 30.15           C  
ATOM   1831  CG  ARG B  99      38.689  40.270  42.480  1.00 37.12           C  
ATOM   1832  CD  ARG B  99      39.702  39.565  41.589  0.65 37.75           C  
ATOM   1834  NE  ARG B  99      40.835  40.425  41.265  0.65 44.03           N  
ATOM   1836  CZ  ARG B  99      40.839  41.334  40.293  0.65 42.99           C  
ATOM   1838  NH1 ARG B  99      41.924  42.072  40.086  0.65 41.30           N  
ATOM   1840  NH2 ARG B  99      39.773  41.495  39.517  0.65 39.62           N  
ATOM   1842  N   GLY B 100      35.861  40.953  44.261  1.00 25.96           N  
ATOM   1843  CA  GLY B 100      34.544  40.351  44.134  1.00 23.24           C  
ATOM   1844  C   GLY B 100      34.339  39.817  42.731  1.00 23.86           C  
ATOM   1845  O   GLY B 100      34.634  40.505  41.752  1.00 23.81           O  
ATOM   1846  N   VAL B 101      33.841  38.586  42.631  1.00 25.19           N  
ATOM   1847  CA  VAL B 101      33.606  37.925  41.345  1.00 22.93           C  
ATOM   1848  C   VAL B 101      32.150  37.497  41.311  1.00 23.40           C  
ATOM   1849  O   VAL B 101      31.738  36.571  42.015  1.00 21.03           O  
ATOM   1850  CB  VAL B 101      34.539  36.693  41.184  1.00 24.05           C  
ATOM   1851  CG1 VAL B 101      34.284  35.991  39.858  1.00 24.78           C  
ATOM   1852  CG2 VAL B 101      35.982  37.140  41.266  1.00 16.73           C  
ATOM   1853  N   CYS B 102      31.384  38.190  40.475  1.00 23.14           N  
ATOM   1854  CA  CYS B 102      29.952  37.988  40.346  1.00 26.41           C  
ATOM   1855  C   CYS B 102      29.543  37.157  39.136  1.00 28.17           C  
ATOM   1856  O   CYS B 102      29.814  37.537  38.001  1.00 27.29           O  
ATOM   1857  CB  CYS B 102      29.277  39.366  40.291  1.00 23.58           C  
ATOM   1858  SG  CYS B 102      27.486  39.384  40.208  1.00 29.36           S  
ATOM   1859  N   LYS B 103      28.873  36.034  39.394  1.00 27.02           N  
ATOM   1860  CA  LYS B 103      28.403  35.135  38.342  1.00 30.34           C  
ATOM   1861  C   LYS B 103      26.895  34.984  38.500  1.00 31.27           C  
ATOM   1862  O   LYS B 103      26.365  35.055  39.612  1.00 25.53           O  
ATOM   1863  CB  LYS B 103      29.021  33.737  38.481  1.00 35.45           C  
ATOM   1864  CG  LYS B 103      30.499  33.704  38.814  1.00 44.98           C  
ATOM   1865  CD  LYS B 103      31.014  32.265  38.843  1.00 49.24           C  
ATOM   1866  CE  LYS B 103      32.460  32.189  39.324  1.00 51.53           C  
ATOM   1867  NZ  LYS B 103      33.370  33.063  38.534  1.00 54.16           N  
ATOM   1868  N   PRO B 104      26.186  34.753  37.393  1.00 28.71           N  
ATOM   1869  CA  PRO B 104      24.737  34.600  37.494  1.00 33.22           C  
ATOM   1870  C   PRO B 104      24.363  33.167  37.865  1.00 35.85           C  
ATOM   1871  O   PRO B 104      25.008  32.228  37.408  1.00 36.93           O  
ATOM   1872  CB  PRO B 104      24.266  34.980  36.096  1.00 29.79           C  
ATOM   1873  CG  PRO B 104      25.363  34.424  35.233  1.00 28.58           C  
ATOM   1874  CD  PRO B 104      26.615  34.830  35.986  1.00 27.49           C  
ATOM   1875  N   LEU B 105      23.347  33.008  38.713  1.00 35.90           N  
ATOM   1876  CA  LEU B 105      22.874  31.684  39.104  1.00 39.08           C  
ATOM   1877  C   LEU B 105      21.533  31.492  38.410  1.00 38.90           C  
ATOM   1878  O   LEU B 105      21.136  30.371  38.089  1.00 39.27           O  
ATOM   1879  CB  LEU B 105      22.704  31.577  40.624  1.00 39.42           C  
ATOM   1880  CG  LEU B 105      23.995  31.475  41.440  1.00 41.38           C  
ATOM   1881  CD1 LEU B 105      23.662  31.318  42.914  1.00 41.84           C  
ATOM   1882  CD2 LEU B 105      24.817  30.286  40.963  1.00 40.70           C  
ATOM   1883  N   HIS B 106      20.854  32.611  38.172  1.00 38.90           N  
ATOM   1884  CA  HIS B 106      19.563  32.625  37.494  1.00 39.86           C  
ATOM   1885  C   HIS B 106      19.307  34.000  36.861  1.00 42.46           C  
ATOM   1886  O   HIS B 106      19.421  35.034  37.521  1.00 40.03           O  
ATOM   1887  CB  HIS B 106      18.434  32.299  38.470  1.00 44.37           C  
ATOM   1888  CG  HIS B 106      17.087  32.252  37.822  1.00 47.11           C  
ATOM   1889  ND1 HIS B 106      16.723  31.260  36.937  1.00 50.05           N  
ATOM   1890  CD2 HIS B 106      16.046  33.116  37.866  1.00 47.26           C  
ATOM   1891  CE1 HIS B 106      15.518  31.516  36.463  1.00 49.78           C  
ATOM   1892  NE2 HIS B 106      15.085  32.637  37.010  1.00 49.80           N  
ATOM   1893  N   LEU B 107      18.965  34.008  35.578  1.00 42.20           N  
ATOM   1894  CA  LEU B 107      18.699  35.257  34.873  1.00 46.03           C  
ATOM   1895  C   LEU B 107      17.280  35.239  34.332  1.00 47.99           C  
ATOM   1896  O   LEU B 107      17.052  35.424  33.136  1.00 50.69           O  
ATOM   1897  CB  LEU B 107      19.704  35.442  33.731  1.00 45.25           C  
ATOM   1898  CG  LEU B 107      21.129  35.765  34.198  1.00 45.89           C  
ATOM   1899  CD1 LEU B 107      22.117  35.715  33.034  1.00 37.39           C  
ATOM   1900  CD2 LEU B 107      21.119  37.137  34.848  1.00 38.29           C  
ATOM   1901  N   GLY B 108      16.333  35.016  35.235  1.00 48.85           N  
ATOM   1902  CA  GLY B 108      14.935  34.944  34.864  1.00 46.31           C  
ATOM   1903  C   GLY B 108      14.390  36.126  34.098  1.00 45.73           C  
ATOM   1904  O   GLY B 108      15.068  37.129  33.870  1.00 46.32           O  
ATOM   1905  N   SER B 109      13.136  35.995  33.704  1.00 44.84           N  
ATOM   1906  CA  SER B 109      12.451  37.029  32.957  1.00 49.24           C  
ATOM   1907  C   SER B 109      11.895  38.077  33.911  1.00 49.19           C  
ATOM   1908  O   SER B 109      11.695  39.225  33.532  1.00 48.14           O  
ATOM   1909  CB  SER B 109      11.315  36.398  32.150  1.00 50.56           C  
ATOM   1910  OG  SER B 109      10.493  35.598  32.985  1.00 49.10           O  
ATOM   1911  N   ARG B 110      11.654  37.670  35.153  1.00 50.80           N  
ATOM   1912  CA  ARG B 110      11.099  38.564  36.161  1.00 52.35           C  
ATOM   1913  C   ARG B 110      12.034  38.816  37.353  1.00 50.02           C  
ATOM   1914  O   ARG B 110      11.884  39.806  38.067  1.00 51.41           O  
ATOM   1915  CB  ARG B 110       9.769  37.997  36.663  1.00 54.12           C  
ATOM   1916  CG  ARG B 110       8.651  38.039  35.636  1.00 58.40           C  
ATOM   1917  CD  ARG B 110       8.236  39.472  35.357  1.00 66.34           C  
ATOM   1918  NE  ARG B 110       7.943  40.190  36.597  1.00 72.38           N  
ATOM   1919  CZ  ARG B 110       7.479  41.434  36.657  1.00 76.36           C  
ATOM   1920  NH1 ARG B 110       7.247  42.003  37.836  1.00 79.57           N  
ATOM   1921  NH2 ARG B 110       7.242  42.109  35.541  1.00 79.20           N  
ATOM   1922  N   HIS B 111      12.989  37.920  37.566  1.00 47.66           N  
ATOM   1923  CA  HIS B 111      13.925  38.066  38.675  1.00 45.62           C  
ATOM   1924  C   HIS B 111      15.259  37.377  38.363  1.00 41.69           C  
ATOM   1925  O   HIS B 111      15.337  36.527  37.475  1.00 39.86           O  
ATOM   1926  CB  HIS B 111      13.329  37.459  39.951  1.00 46.47           C  
ATOM   1927  CG  HIS B 111      13.390  35.962  39.991  1.00 49.40           C  
ATOM   1928  ND1 HIS B 111      12.674  35.163  39.126  1.00 51.99           N  
ATOM   1929  CD2 HIS B 111      14.110  35.121  40.772  1.00 50.88           C  
ATOM   1930  CE1 HIS B 111      12.952  33.894  39.369  1.00 52.44           C  
ATOM   1931  NE2 HIS B 111      13.821  33.841  40.364  1.00 49.73           N  
ATOM   1932  N   GLN B 112      16.303  37.748  39.102  1.00 38.35           N  
ATOM   1933  CA  GLN B 112      17.625  37.155  38.921  1.00 34.20           C  
ATOM   1934  C   GLN B 112      18.237  36.831  40.278  1.00 33.03           C  
ATOM   1935  O   GLN B 112      17.877  37.423  41.298  1.00 33.88           O  
ATOM   1936  CB  GLN B 112      18.573  38.116  38.197  1.00 30.55           C  
ATOM   1937  CG  GLN B 112      17.948  38.926  37.089  1.00 27.62           C  
ATOM   1938  CD  GLN B 112      18.722  40.207  36.853  1.00 30.07           C  
ATOM   1939  OE1 GLN B 112      19.130  40.876  37.806  1.00 30.66           O  
ATOM   1940  NE2 GLN B 112      18.926  40.561  35.590  1.00 29.15           N  
ATOM   1941  N   VAL B 113      19.170  35.887  40.267  1.00 31.48           N  
ATOM   1942  CA  VAL B 113      19.892  35.470  41.459  1.00 31.49           C  
ATOM   1943  C   VAL B 113      21.360  35.626  41.071  1.00 33.39           C  
ATOM   1944  O   VAL B 113      21.786  35.151  40.022  1.00 31.97           O  
ATOM   1945  CB  VAL B 113      19.610  33.990  41.823  1.00 30.23           C  
ATOM   1946  CG1 VAL B 113      20.184  33.667  43.188  1.00 26.06           C  
ATOM   1947  CG2 VAL B 113      18.104  33.723  41.807  1.00 36.65           C  
ATOM   1948  N   TRP B 114      22.125  36.320  41.902  1.00 31.62           N  
ATOM   1949  CA  TRP B 114      23.531  36.537  41.621  1.00 28.88           C  
ATOM   1950  C   TRP B 114      24.386  35.955  42.731  1.00 31.12           C  
ATOM   1951  O   TRP B 114      24.000  35.955  43.904  1.00 27.24           O  
ATOM   1952  CB  TRP B 114      23.824  38.036  41.476  1.00 24.93           C  
ATOM   1953  CG  TRP B 114      23.259  38.627  40.235  1.00 26.74           C  
ATOM   1954  CD1 TRP B 114      22.079  39.302  40.107  1.00 22.98           C  
ATOM   1955  CD2 TRP B 114      23.824  38.547  38.917  1.00 25.65           C  
ATOM   1956  NE1 TRP B 114      21.872  39.648  38.792  1.00 28.18           N  
ATOM   1957  CE2 TRP B 114      22.928  39.196  38.039  1.00 26.71           C  
ATOM   1958  CE3 TRP B 114      25.002  37.988  38.394  1.00 22.91           C  
ATOM   1959  CZ2 TRP B 114      23.170  39.302  36.662  1.00 27.18           C  
ATOM   1960  CZ3 TRP B 114      25.248  38.093  37.025  1.00 25.54           C  
ATOM   1961  CH2 TRP B 114      24.331  38.747  36.175  1.00 28.16           C  
ATOM   1962  N   GLN B 115      25.547  35.441  42.348  1.00 31.45           N  
ATOM   1963  CA  GLN B 115      26.460  34.864  43.306  1.00 30.06           C  
ATOM   1964  C   GLN B 115      27.748  35.660  43.234  1.00 29.38           C  
ATOM   1965  O   GLN B 115      28.337  35.837  42.166  1.00 29.62           O  
ATOM   1966  CB  GLN B 115      26.717  33.386  42.996  1.00 36.18           C  
ATOM   1967  CG  GLN B 115      27.601  32.695  44.037  1.00 45.52           C  
ATOM   1968  CD  GLN B 115      27.561  31.175  43.948  1.00 49.67           C  
ATOM   1969  OE1 GLN B 115      28.571  30.530  43.656  1.00 55.59           O  
ATOM   1970  NE2 GLN B 115      26.391  30.599  44.196  1.00 48.58           N  
ATOM   1971  N   ILE B 116      28.173  36.164  44.377  1.00 26.96           N  
ATOM   1972  CA  ILE B 116      29.383  36.945  44.418  1.00 27.18           C  
ATOM   1973  C   ILE B 116      30.331  36.337  45.433  1.00 29.13           C  
ATOM   1974  O   ILE B 116      29.967  36.157  46.593  1.00 30.91           O  
ATOM   1975  CB  ILE B 116      29.095  38.414  44.833  1.00 22.50           C  
ATOM   1976  CG1 ILE B 116      28.079  39.066  43.877  1.00 21.70           C  
ATOM   1977  CG2 ILE B 116      30.404  39.211  44.831  1.00 24.80           C  
ATOM   1978  CD1 ILE B 116      26.638  38.964  44.331  1.00 21.35           C  
ATOM   1979  N   GLU B 117      31.545  36.017  45.005  1.00 27.80           N  
ATOM   1980  CA  GLU B 117      32.521  35.467  45.931  1.00 28.01           C  
ATOM   1981  C   GLU B 117      33.625  36.503  46.038  1.00 27.06           C  
ATOM   1982  O   GLU B 117      34.112  37.011  45.034  1.00 25.97           O  
ATOM   1983  CB  GLU B 117      33.068  34.122  45.433  1.00 29.36           C  
ATOM   1984  CG  GLU B 117      31.992  33.066  45.186  1.00 35.92           C  
ATOM   1985  CD  GLU B 117      32.572  31.678  44.937  1.00 40.98           C  
ATOM   1986  OE1 GLU B 117      33.572  31.575  44.202  1.00 43.22           O  
ATOM   1987  OE2 GLU B 117      32.023  30.688  45.468  1.00 49.99           O  
ATOM   1988  N   ILE B 118      33.999  36.819  47.272  1.00 29.48           N  
ATOM   1989  CA  ILE B 118      35.012  37.817  47.549  1.00 28.78           C  
ATOM   1990  C   ILE B 118      36.272  37.123  48.020  1.00 32.25           C  
ATOM   1991  O   ILE B 118      36.254  36.398  49.009  1.00 33.93           O  
ATOM   1992  CB  ILE B 118      34.502  38.789  48.626  1.00 27.74           C  
ATOM   1993  CG1 ILE B 118      33.333  39.594  48.058  1.00 30.05           C  
ATOM   1994  CG2 ILE B 118      35.632  39.681  49.119  1.00 22.97           C  
ATOM   1995  CD1 ILE B 118      32.538  40.359  49.103  1.00 28.46           C  
ATOM   1996  N   PHE B 119      37.367  37.363  47.305  1.00 35.67           N  
ATOM   1997  CA  PHE B 119      38.654  36.750  47.608  1.00 33.47           C  
ATOM   1998  C   PHE B 119      39.707  37.758  48.039  1.00 35.16           C  
ATOM   1999  O   PHE B 119      39.636  38.939  47.685  1.00 31.85           O  
ATOM   2000  CB  PHE B 119      39.184  36.012  46.376  1.00 27.80           C  
ATOM   2001  CG  PHE B 119      38.245  34.966  45.829  1.00 31.27           C  
ATOM   2002  CD1 PHE B 119      37.276  35.297  44.885  1.00 33.41           C  
ATOM   2003  CD2 PHE B 119      38.367  33.633  46.223  1.00 27.85           C  
ATOM   2004  CE1 PHE B 119      36.436  34.308  44.328  1.00 27.90           C  
ATOM   2005  CE2 PHE B 119      37.544  32.641  45.683  1.00 30.68           C  
ATOM   2006  CZ  PHE B 119      36.576  32.981  44.730  1.00 33.28           C  
ATOM   2007  N   ASP B 120      40.697  37.286  48.797  1.00 39.43           N  
ATOM   2008  CA  ASP B 120      41.784  38.161  49.233  1.00 39.84           C  
ATOM   2009  C   ASP B 120      42.892  38.095  48.182  1.00 38.34           C  
ATOM   2010  O   ASP B 120      42.695  37.527  47.113  1.00 36.73           O  
ATOM   2011  CB  ASP B 120      42.311  37.744  50.616  1.00 43.69           C  
ATOM   2012  CG  ASP B 120      42.962  36.363  50.626  1.00 41.57           C  
ATOM   2013  OD1 ASP B 120      43.370  35.934  51.721  1.00 42.18           O  
ATOM   2014  OD2 ASP B 120      43.067  35.708  49.566  1.00 43.61           O  
ATOM   2015  N   GLU B 121      44.048  38.676  48.479  1.00 41.72           N  
ATOM   2016  CA  GLU B 121      45.169  38.681  47.537  1.00 46.75           C  
ATOM   2017  C   GLU B 121      45.590  37.288  47.078  1.00 46.70           C  
ATOM   2018  O   GLU B 121      45.929  37.077  45.911  1.00 47.81           O  
ATOM   2019  CB  GLU B 121      46.387  39.349  48.176  1.00 50.85           C  
ATOM   2020  CG  GLU B 121      46.077  40.632  48.921  1.00 57.20           C  
ATOM   2021  CD  GLU B 121      47.249  41.110  49.764  1.00 57.09           C  
ATOM   2022  OE1 GLU B 121      48.287  41.492  49.183  1.00 50.97           O  
ATOM   2023  OE2 GLU B 121      47.125  41.094  51.011  1.00 58.62           O  
ATOM   2024  N   LYS B 122      45.570  36.335  48.000  1.00 46.83           N  
ATOM   2025  CA  LYS B 122      46.003  34.980  47.690  1.00 47.36           C  
ATOM   2026  C   LYS B 122      44.962  34.085  47.028  1.00 47.94           C  
ATOM   2027  O   LYS B 122      45.205  32.898  46.809  1.00 48.55           O  
ATOM   2028  CB  LYS B 122      46.533  34.328  48.966  1.00 49.05           C  
ATOM   2029  CG  LYS B 122      47.551  35.201  49.683  1.00 51.39           C  
ATOM   2030  CD  LYS B 122      48.209  34.495  50.849  1.00 55.29           C  
ATOM   2031  CE  LYS B 122      49.168  35.436  51.553  1.00 60.51           C  
ATOM   2032  NZ  LYS B 122      49.803  34.811  52.746  1.00 65.78           N  
ATOM   2033  N   GLY B 123      43.806  34.654  46.699  1.00 47.10           N  
ATOM   2034  CA  GLY B 123      42.769  33.866  46.058  1.00 42.23           C  
ATOM   2035  C   GLY B 123      41.975  33.050  47.057  1.00 38.36           C  
ATOM   2036  O   GLY B 123      41.281  32.106  46.689  1.00 39.58           O  
ATOM   2037  N   ARG B 124      42.091  33.404  48.331  1.00 35.65           N  
ATOM   2038  CA  ARG B 124      41.353  32.702  49.365  1.00 39.33           C  
ATOM   2039  C   ARG B 124      40.003  33.371  49.574  1.00 38.37           C  
ATOM   2040  O   ARG B 124      39.908  34.599  49.660  1.00 37.97           O  
ATOM   2041  CB  ARG B 124      42.147  32.679  50.675  1.00 38.10           C  
ATOM   2042  CG  ARG B 124      43.381  31.792  50.608  1.00 41.14           C  
ATOM   2043  CD  ARG B 124      44.245  31.973  51.832  1.00 43.17           C  
ATOM   2044  NE  ARG B 124      44.478  33.387  52.113  1.00 46.01           N  
ATOM   2045  CZ  ARG B 124      45.391  33.839  52.962  1.00 47.20           C  
ATOM   2046  NH1 ARG B 124      45.529  35.144  53.157  1.00 46.43           N  
ATOM   2047  NH2 ARG B 124      46.176  32.984  53.608  1.00 49.90           N  
ATOM   2048  N   LEU B 125      38.967  32.540  49.633  1.00 35.96           N  
ATOM   2049  CA  LEU B 125      37.598  32.992  49.815  1.00 33.86           C  
ATOM   2050  C   LEU B 125      37.407  33.595  51.202  1.00 34.20           C  
ATOM   2051  O   LEU B 125      37.719  32.972  52.215  1.00 35.58           O  
ATOM   2052  CB  LEU B 125      36.642  31.811  49.611  1.00 27.00           C  
ATOM   2053  CG  LEU B 125      35.136  32.067  49.698  1.00 33.27           C  
ATOM   2054  CD1 LEU B 125      34.652  32.900  48.495  1.00 23.15           C  
ATOM   2055  CD2 LEU B 125      34.422  30.726  49.743  1.00 25.98           C  
ATOM   2056  N   CYS B 126      36.911  34.826  51.243  1.00 35.56           N  
ATOM   2057  CA  CYS B 126      36.670  35.500  52.514  1.00 33.22           C  
ATOM   2058  C   CYS B 126      35.178  35.689  52.751  1.00 31.76           C  
ATOM   2059  O   CYS B 126      34.731  35.748  53.899  1.00 33.07           O  
ATOM   2060  CB  CYS B 126      37.368  36.861  52.536  1.00 37.95           C  
ATOM   2061  SG  CYS B 126      39.159  36.765  52.434  1.00 37.87           S  
ATOM   2062  N   CYS B 127      34.416  35.789  51.664  1.00 27.88           N  
ATOM   2063  CA  CYS B 127      32.975  35.981  51.757  1.00 26.96           C  
ATOM   2064  C   CYS B 127      32.244  35.455  50.531  1.00 23.86           C  
ATOM   2065  O   CYS B 127      32.658  35.694  49.396  1.00 26.29           O  
ATOM   2066  CB  CYS B 127      32.640  37.463  51.953  1.00 26.82           C  
ATOM   2067  SG  CYS B 127      30.855  37.765  52.091  1.00 28.51           S  
ATOM   2068  N   SER B 128      31.162  34.731  50.776  1.00 20.95           N  
ATOM   2069  CA  SER B 128      30.346  34.141  49.713  1.00 26.60           C  
ATOM   2070  C   SER B 128      28.954  34.716  49.891  1.00 24.63           C  
ATOM   2071  O   SER B 128      28.354  34.576  50.954  1.00 19.62           O  
ATOM   2072  CB  SER B 128      30.312  32.611  49.848  1.00 27.60           C  
ATOM   2073  OG  SER B 128      29.449  32.031  48.885  1.00 31.08           O  
ATOM   2074  N   SER B 129      28.441  35.337  48.840  1.00 25.37           N  
ATOM   2075  CA  SER B 129      27.154  36.010  48.904  1.00 25.53           C  
ATOM   2076  C   SER B 129      26.225  35.789  47.722  1.00 25.53           C  
ATOM   2077  O   SER B 129      26.664  35.571  46.594  1.00 23.18           O  
ATOM   2078  CB  SER B 129      27.406  37.513  49.054  1.00 29.39           C  
ATOM   2079  OG  SER B 129      26.230  38.246  48.782  1.00 37.09           O  
ATOM   2080  N   ARG B 130      24.931  35.864  48.004  1.00 27.24           N  
ATOM   2081  CA  ARG B 130      23.897  35.709  47.001  1.00 27.51           C  
ATOM   2082  C   ARG B 130      22.974  36.920  47.087  1.00 28.48           C  
ATOM   2083  O   ARG B 130      22.595  37.361  48.169  1.00 25.64           O  
ATOM   2084  CB  ARG B 130      23.079  34.428  47.225  1.00 28.66           C  
ATOM   2085  CG  ARG B 130      23.733  33.153  46.701  1.00 38.83           C  
ATOM   2086  CD  ARG B 130      25.011  32.816  47.465  1.00 43.02           C  
ATOM   2087  NE  ARG B 130      24.779  32.757  48.906  1.00 47.01           N  
ATOM   2088  CZ  ARG B 130      25.667  32.317  49.793  1.00 53.33           C  
ATOM   2089  NH1 ARG B 130      25.364  32.307  51.086  1.00 48.86           N  
ATOM   2090  NH2 ARG B 130      26.851  31.873  49.388  1.00 55.87           N  
ATOM   2091  N   LEU B 131      22.633  37.454  45.925  1.00 28.21           N  
ATOM   2092  CA  LEU B 131      21.763  38.607  45.828  1.00 27.56           C  
ATOM   2093  C   LEU B 131      20.624  38.241  44.895  1.00 21.96           C  
ATOM   2094  O   LEU B 131      20.851  37.730  43.802  1.00 23.71           O  
ATOM   2095  CB  LEU B 131      22.530  39.802  45.251  1.00 25.92           C  
ATOM   2096  CG  LEU B 131      21.630  40.961  44.816  1.00 26.90           C  
ATOM   2097  CD1 LEU B 131      21.061  41.651  46.069  1.00 20.91           C  
ATOM   2098  CD2 LEU B 131      22.408  41.934  43.939  1.00 22.36           C  
ATOM   2099  N   THR B 132      19.403  38.478  45.346  1.00 22.27           N  
ATOM   2100  CA  THR B 132      18.217  38.209  44.541  1.00 25.90           C  
ATOM   2101  C   THR B 132      17.627  39.568  44.164  1.00 28.21           C  
ATOM   2102  O   THR B 132      17.374  40.404  45.036  1.00 26.81           O  
ATOM   2103  CB  THR B 132      17.162  37.405  45.333  1.00 30.79           C  
ATOM   2104  OG1 THR B 132      17.735  36.172  45.798  1.00 25.75           O  
ATOM   2105  CG2 THR B 132      15.958  37.101  44.441  1.00 27.86           C  
ATOM   2106  N   THR B 133      17.425  39.790  42.869  1.00 30.56           N  
ATOM   2107  CA  THR B 133      16.891  41.056  42.380  1.00 26.31           C  
ATOM   2108  C   THR B 133      15.618  40.855  41.598  1.00 30.95           C  
ATOM   2109  O   THR B 133      15.311  39.752  41.135  1.00 29.93           O  
ATOM   2110  CB  THR B 133      17.867  41.779  41.417  1.00 30.32           C  
ATOM   2111  OG1 THR B 133      18.050  40.982  40.238  1.00 28.77           O  
ATOM   2112  CG2 THR B 133      19.204  42.032  42.074  1.00 20.00           C  
ATOM   2113  N   ALA B 134      14.877  41.941  41.448  1.00 32.95           N  
ATOM   2114  CA  ALA B 134      13.639  41.906  40.687  1.00 36.32           C  
ATOM   2115  C   ALA B 134      13.841  42.810  39.486  1.00 35.64           C  
ATOM   2116  O   ALA B 134      14.493  43.849  39.595  1.00 30.92           O  
ATOM   2117  CB  ALA B 134      12.488  42.415  41.532  1.00 37.30           C  
ATOM   2118  N   ILE B 135      13.297  42.411  38.341  1.00 36.41           N  
ATOM   2119  CA  ILE B 135      13.420  43.227  37.142  1.00 36.58           C  
ATOM   2120  C   ILE B 135      12.169  44.082  36.992  1.00 38.23           C  
ATOM   2121  O   ILE B 135      11.047  43.573  37.038  1.00 41.19           O  
ATOM   2122  CB  ILE B 135      13.593  42.354  35.892  1.00 39.30           C  
ATOM   2123  CG1 ILE B 135      14.845  41.490  36.041  1.00 41.70           C  
ATOM   2124  CG2 ILE B 135      13.727  43.230  34.661  1.00 44.78           C  
ATOM   2125  CD1 ILE B 135      14.954  40.358  35.031  1.00 43.53           C  
ATOM   2126  N   LEU B 136      12.365  45.385  36.837  1.00 36.68           N  
ATOM   2127  CA  LEU B 136      11.254  46.306  36.671  1.00 40.65           C  
ATOM   2128  C   LEU B 136      11.128  46.694  35.203  1.00 40.24           C  
ATOM   2129  O   LEU B 136      12.090  47.148  34.589  1.00 37.87           O  
ATOM   2130  CB  LEU B 136      11.474  47.563  37.514  1.00 42.68           C  
ATOM   2131  CG  LEU B 136      11.635  47.361  39.021  1.00 49.24           C  
ATOM   2132  CD1 LEU B 136      11.683  48.720  39.713  1.00 47.22           C  
ATOM   2133  CD2 LEU B 136      10.484  46.524  39.559  1.00 46.12           C  
ATOM   2134  N   GLU B 137       9.939  46.510  34.643  1.00 42.05           N  
ATOM   2135  CA  GLU B 137       9.705  46.844  33.245  1.00 43.52           C  
ATOM   2136  C   GLU B 137       9.893  48.331  32.982  1.00 41.80           C  
ATOM   2137  O   GLU B 137       9.761  49.154  33.887  1.00 38.94           O  
ATOM   2138  CB  GLU B 137       8.297  46.422  32.832  1.00 49.02           C  
ATOM   2139  CG  GLU B 137       8.094  44.921  32.814  1.00 56.24           C  
ATOM   2140  CD  GLU B 137       9.185  44.203  32.039  1.00 63.21           C  
ATOM   2141  OE1 GLU B 137       9.381  44.517  30.844  1.00 67.76           O  
ATOM   2142  OE2 GLU B 137       9.847  43.324  32.630  1.00 66.40           O  
ATOM   2143  N   GLY B 138      10.207  48.667  31.734  1.00 38.50           N  
ATOM   2144  CA  GLY B 138      10.400  50.059  31.371  1.00 37.62           C  
ATOM   2145  C   GLY B 138      10.345  50.261  29.870  1.00 35.85           C  
ATOM   2146  O   GLY B 138      10.524  49.314  29.105  1.00 33.48           O  
ATOM   2147  N   GLY B 139      10.087  51.497  29.454  1.00 33.37           N  
ATOM   2148  CA  GLY B 139      10.020  51.811  28.038  1.00 32.17           C  
ATOM   2149  C   GLY B 139       8.635  52.206  27.564  1.00 33.47           C  
ATOM   2150  O   GLY B 139       7.632  51.952  28.241  1.00 30.12           O  
ATOM   2151  N   SER B 140       8.578  52.841  26.396  1.00 33.81           N  
ATOM   2152  CA  SER B 140       7.307  53.260  25.827  1.00 30.30           C  
ATOM   2153  C   SER B 140       6.619  52.058  25.168  1.00 32.63           C  
ATOM   2154  O   SER B 140       7.277  51.145  24.657  1.00 29.04           O  
ATOM   2155  CB  SER B 140       7.526  54.364  24.792  1.00 29.88           C  
ATOM   2156  OG  SER B 140       6.287  54.840  24.285  1.00 34.08           O  
ATOM   2157  N   HIS B 141       5.292  52.063  25.193  1.00 32.72           N  
ATOM   2158  CA  HIS B 141       4.510  50.986  24.603  1.00 32.86           C  
ATOM   2159  C   HIS B 141       3.639  51.478  23.460  1.00 30.12           C  
ATOM   2160  O   HIS B 141       3.092  52.574  23.506  1.00 32.60           O  
ATOM   2161  CB  HIS B 141       3.599  50.350  25.654  1.00 36.54           C  
ATOM   2162  CG  HIS B 141       4.310  49.457  26.620  1.00 43.31           C  
ATOM   2163  ND1 HIS B 141       4.059  48.101  26.699  1.00 43.08           N  
ATOM   2164  CD2 HIS B 141       5.257  49.722  27.551  1.00 42.86           C  
ATOM   2165  CE1 HIS B 141       4.820  47.571  27.640  1.00 43.92           C  
ATOM   2166  NE2 HIS B 141       5.555  48.533  28.173  1.00 46.98           N  
ATOM   2167  N   HIS B 142       3.511  50.655  22.434  1.00 31.12           N  
ATOM   2168  CA  HIS B 142       2.660  50.983  21.308  1.00 31.66           C  
ATOM   2169  C   HIS B 142       1.213  51.036  21.795  1.00 34.93           C  
ATOM   2170  O   HIS B 142       0.842  50.383  22.771  1.00 31.09           O  
ATOM   2171  CB  HIS B 142       2.758  49.885  20.243  1.00 35.73           C  
ATOM   2172  CG  HIS B 142       1.646  49.909  19.237  1.00 36.95           C  
ATOM   2173  ND1 HIS B 142       1.650  50.739  18.136  1.00 37.29           N  
ATOM   2174  CD2 HIS B 142       0.478  49.222  19.184  1.00 34.11           C  
ATOM   2175  CE1 HIS B 142       0.535  50.562  17.449  1.00 38.28           C  
ATOM   2176  NE2 HIS B 142      -0.195  49.648  18.063  1.00 30.75           N  
ATOM   2177  N   HIS B 143       0.402  51.834  21.122  1.00 35.43           N  
ATOM   2178  CA  HIS B 143      -1.017  51.893  21.419  1.00 36.31           C  
ATOM   2179  C   HIS B 143      -1.662  52.173  20.074  1.00 38.69           C  
ATOM   2180  O   HIS B 143      -1.061  52.820  19.210  1.00 36.49           O  
ATOM   2181  CB  HIS B 143      -1.367  52.957  22.476  1.00 34.43           C  
ATOM   2182  CG  HIS B 143      -1.025  54.360  22.087  1.00 39.44           C  
ATOM   2183  ND1 HIS B 143      -0.076  55.102  22.758  1.00 35.94           N  
ATOM   2184  CD2 HIS B 143      -1.533  55.173  21.132  1.00 35.77           C  
ATOM   2185  CE1 HIS B 143      -0.015  56.312  22.233  1.00 39.72           C  
ATOM   2186  NE2 HIS B 143      -0.888  56.382  21.245  1.00 43.90           N  
ATOM   2187  N   HIS B 144      -2.862  51.641  19.879  1.00 40.91           N  
ATOM   2188  CA  HIS B 144      -3.564  51.805  18.620  1.00 46.26           C  
ATOM   2189  C   HIS B 144      -4.134  53.195  18.417  1.00 47.66           C  
ATOM   2190  O   HIS B 144      -4.600  53.828  19.360  1.00 46.71           O  
ATOM   2191  CB  HIS B 144      -4.662  50.746  18.505  1.00 44.95           C  
ATOM   2192  CG  HIS B 144      -4.152  49.347  18.660  1.00 51.05           C  
ATOM   2193  ND1 HIS B 144      -3.195  48.803  17.831  1.00 53.10           N  
ATOM   2194  CD2 HIS B 144      -4.501  48.365  19.530  1.00 53.20           C  
ATOM   2195  CE1 HIS B 144      -2.977  47.546  18.180  1.00 49.77           C  
ATOM   2196  NE2 HIS B 144      -3.756  47.255  19.207  1.00 48.70           N  
ATOM   2197  N   HIS B 145      -4.061  53.658  17.171  1.00 53.21           N  
ATOM   2198  CA  HIS B 145      -4.568  54.968  16.766  1.00 57.10           C  
ATOM   2199  C   HIS B 145      -4.620  55.035  15.237  1.00 61.36           C  
ATOM   2200  O   HIS B 145      -4.156  54.073  14.584  1.00 61.80           O  
ATOM   2201  CB  HIS B 145      -3.668  56.075  17.313  1.00 56.24           C  
TER    2202      HIS B 145                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
