
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   68 ( 1149),  selected   68 , name 2jr6_A
# Molecule2: number of CA atoms   29 (  432),  selected   29 , name T0480.pdb
# PARAMETERS: 2jr6_A.T0480.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    E     2_A      -       -           -
LGA    K     3_A      -       -           -
LGA    K     4_A      -       -           -
LGA    F     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    I     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    V    10_A      F      20          1.520
LGA    C    11_A      C      21          0.593
LGA    P    12_A      P      22          0.633
LGA    V    13_A      R      23          1.446
LGA    T    14_A      C      24          1.725
LGA    K    15_A      G      25          1.389
LGA    -       -      P      26           -
LGA    -       -      G      27           -
LGA    G    16_A      V      28          1.581
LGA    R    17_A      F      29          1.048
LGA    L    18_A      L      30          1.940
LGA    E    19_A      A      31          2.369
LGA    Y    20_A      E      32          1.450
LGA    H    21_A      H      33          1.436
LGA    Q    22_A      A      34          1.565
LGA    D    23_A      D      35          3.577
LGA    K    24_A      -       -           -
LGA    Q    25_A      -       -           -
LGA    E    26_A      R      36          1.060
LGA    L    27_A      Y      37          0.674
LGA    W    28_A      S      38          1.074
LGA    S    29_A      C      39          0.331
LGA    R    30_A      G      40          1.051
LGA    Q    31_A      R      41          1.467
LGA    A    32_A      C      42          1.527
LGA    K    33_A      G      43          1.090
LGA    L    34_A      Y      44          2.027
LGA    A    35_A      T      45          0.474
LGA    Y    36_A      E      46          1.263
LGA    P    37_A      F      47          1.947
LGA    I    38_A      K      48          2.491
LGA    K    39_A      -       -           -
LGA    D    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    I    42_A      -       -           -
LGA    P    43_A      -       -           -
LGA    Y    44_A      -       -           -
LGA    M    45_A      -       -           -
LGA    L    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    N    48_A      -       -           -
LGA    E    49_A      -       -           -
LGA    A    50_A      -       -           -
LGA    R    51_A      -       -           -
LGA    P    52_A      -       -           -
LGA    L    53_A      -       -           -
LGA    S    54_A      -       -           -
LGA    E    55_A      -       -           -
LGA    E    56_A      -       -           -
LGA    E    57_A      -       -           -
LGA    L    58_A      -       -           -
LGA    K    59_A      -       -           -
LGA    A    60_A      -       -           -
LGA    L    61_A      -       -           -
LGA    E    62_A      -       -           -
LGA    H    63_A      -       -           -
LGA    H    64_A      -       -           -
LGA    H    65_A      -       -           -
LGA    H    66_A      -       -           -
LGA    H    67_A      -       -           -
LGA    H    68_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   68   29    5.0     27    1.59    18.52     85.541     1.601

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.964823 * X  +   0.139237 * Y  +  -0.223003 * Z  +  -6.510539
  Y_new =  -0.010142 * X  +   0.867317 * Y  +   0.497652 * Z  +  46.954201
  Z_new =   0.262706 * X  +  -0.477884 * Y  +   0.838220 * Z  +   4.587449 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.518158    2.623435  [ DEG:   -29.6883    150.3118 ]
  Theta =  -0.265825   -2.875767  [ DEG:   -15.2307   -164.7693 ]
  Phi   =  -0.010511    3.131082  [ DEG:    -0.6022    179.3978 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jr6_A                                        
REMARK     2: T0480.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jr6_A.T0480.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   68   29   5.0   27   1.59   18.52  85.541
REMARK  ---------------------------------------------------------- 
MOLECULE 2jr6_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   20-JUN-07   2JR6              
TITLE     SOLUTION STRUCTURE OF UPF0434 PROTEIN NMA0874. NORTHEAST              
TITLE    2 STRUCTURAL GENOMICS TARGET MR32                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0434 PROTEIN NMA0874;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS SEROGROUP A;             
SOURCE   3 STRAIN: Z2491;                                                       
SOURCE   4 GENE: NMA0874;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    SOLUTION, NMR, UPF0434 PROTEIN NMA0874, STRUCTURAL GENOMICS,          
KEYWDS   2 PSI, PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL              
KEYWDS   3 GENOMICS CONSORTIUM, NESG, STRUCTURAL GENOMICS, UNKNOWN              
KEYWDS   4 FUNCTION                                                             
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.GHOSH,K.K.SINGARAPU,Y.WU,G.LIU,D.SUKUMARAN,C.X.CHEN,                
AUTHOR   2 C.NWOSU,L.OWENS,R.XIAO,J.LIU,M.C.BARAN,G.SWAPNA,T.B.ACTON,           
AUTHOR   3 B.ROST,G.T.MONTELIONE,T.SZYPERSKI,NORTHEAST STRUCTURAL               
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   3   06-MAY-08 2JR6    1       SOURCE                                   
REVDAT   2   31-JUL-07 2JR6    1       AUTHOR                                   
REVDAT   1   24-JUL-07 2JR6    0                                                
JRNL        AUTH   A.GHOSH,K.K.SINGARAPU,Y.WU,G.LIU,D.SUKUMARAN,                
JRNL        AUTH 2 C.X.CHEN,C.NWOSU,L.OWENS,R.XIAO,J.LIU,M.C.BARAN,             
JRNL        AUTH 3 G.SWAPNA,T.B.ACTON,B.ROST,G.T.MONTELIONE,                    
JRNL        AUTH 4 T.SZYPERSKI                                                  
JRNL        TITL   SOLUTION STRUCTURE OF UPF0434 PROTEIN NMA0874.               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JR6 A    1    60  UNP    A1IQS5   Y874_NEIMA       1     60             
SEQRES   1 A   68  MET GLU LYS LYS PHE LEU ASP ILE LEU VAL CYS PRO VAL          
SEQRES   2 A   68  THR LYS GLY ARG LEU GLU TYR HIS GLN ASP LYS GLN GLU          
SEQRES   3 A   68  LEU TRP SER ARG GLN ALA LYS LEU ALA TYR PRO ILE LYS          
SEQRES   4 A   68  ASP GLY ILE PRO TYR MET LEU GLU ASN GLU ALA ARG PRO          
SEQRES   5 A   68  LEU SER GLU GLU GLU LEU LYS ALA LEU GLU HIS HIS HIS          
SEQRES   6 A   68  HIS HIS HIS                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       7.273  53.605 -11.187  1.00  0.00           N  
ATOM      2  CA  MET A   1       5.938  54.225 -11.355  1.00  0.00           C  
ATOM      3  C   MET A   1       4.828  53.220 -11.068  1.00  0.00           C  
ATOM      4  O   MET A   1       3.652  53.509 -11.287  1.00  0.00           O  
ATOM      5  CB  MET A   1       5.772  54.770 -12.779  1.00  0.00           C  
ATOM      6  CG  MET A   1       6.697  55.927 -13.116  1.00  0.00           C  
ATOM      7  SD  MET A   1       6.448  56.542 -14.796  1.00  0.00           S  
ATOM      8  CE  MET A   1       7.617  57.899 -14.838  1.00  0.00           C  
ATOM      9  H1  MET A   1       7.399  53.285 -10.200  1.00  0.00           H  
ATOM     10  H2  MET A   1       8.022  54.287 -11.420  1.00  0.00           H  
ATOM     11  H3  MET A   1       7.366  52.783 -11.819  1.00  0.00           H  
ATOM     12  HA  MET A   1       5.855  55.041 -10.653  1.00  0.00           H  
ATOM     13  HB2 MET A   1       5.964  53.973 -13.479  1.00  0.00           H  
ATOM     14  HB3 MET A   1       4.753  55.107 -12.903  1.00  0.00           H  
ATOM     15  HG2 MET A   1       6.514  56.732 -12.418  1.00  0.00           H  
ATOM     16  HG3 MET A   1       7.719  55.592 -13.019  1.00  0.00           H  
ATOM     17  HE1 MET A   1       7.572  58.384 -15.803  1.00  0.00           H  
ATOM     18  HE2 MET A   1       8.614  57.521 -14.671  1.00  0.00           H  
ATOM     19  HE3 MET A   1       7.369  58.612 -14.067  1.00  0.00           H  
ATOM     20  N   GLU A   2       5.187  52.041 -10.569  1.00  0.00           N  
ATOM     21  CA  GLU A   2       4.201  50.994 -10.341  1.00  0.00           C  
ATOM     22  C   GLU A   2       3.429  51.214  -9.042  1.00  0.00           C  
ATOM     23  O   GLU A   2       3.624  50.520  -8.045  1.00  0.00           O  
ATOM     24  CB  GLU A   2       4.819  49.582 -10.386  1.00  0.00           C  
ATOM     25  CG  GLU A   2       6.167  49.437  -9.693  1.00  0.00           C  
ATOM     26  CD  GLU A   2       7.308  50.021 -10.499  1.00  0.00           C  
ATOM     27  OE1 GLU A   2       7.753  49.373 -11.470  1.00  0.00           O  
ATOM     28  OE2 GLU A   2       7.740  51.147 -10.184  1.00  0.00           O  
ATOM     29  H   GLU A   2       6.130  51.874 -10.342  1.00  0.00           H  
ATOM     30  HA  GLU A   2       3.489  51.067 -11.153  1.00  0.00           H  
ATOM     31  HB2 GLU A   2       4.132  48.894  -9.918  1.00  0.00           H  
ATOM     32  HB3 GLU A   2       4.941  49.295 -11.421  1.00  0.00           H  
ATOM     33  HG2 GLU A   2       6.122  49.946  -8.743  1.00  0.00           H  
ATOM     34  HG3 GLU A   2       6.362  48.386  -9.528  1.00  0.00           H  
ATOM     35  N   LYS A   3       2.578  52.224  -9.065  1.00  0.00           N  
ATOM     36  CA  LYS A   3       1.583  52.429  -8.040  1.00  0.00           C  
ATOM     37  C   LYS A   3       0.293  52.829  -8.724  1.00  0.00           C  
ATOM     38  O   LYS A   3       0.324  53.300  -9.862  1.00  0.00           O  
ATOM     39  CB  LYS A   3       2.015  53.474  -7.007  1.00  0.00           C  
ATOM     40  CG  LYS A   3       2.607  54.753  -7.587  1.00  0.00           C  
ATOM     41  CD  LYS A   3       2.867  55.780  -6.492  1.00  0.00           C  
ATOM     42  CE  LYS A   3       3.642  55.173  -5.327  1.00  0.00           C  
ATOM     43  NZ  LYS A   3       3.758  56.112  -4.178  1.00  0.00           N  
ATOM     44  H   LYS A   3       2.616  52.861  -9.812  1.00  0.00           H  
ATOM     45  HA  LYS A   3       1.427  51.481  -7.543  1.00  0.00           H  
ATOM     46  HB2 LYS A   3       1.156  53.747  -6.420  1.00  0.00           H  
ATOM     47  HB3 LYS A   3       2.753  53.029  -6.353  1.00  0.00           H  
ATOM     48  HG2 LYS A   3       3.540  54.518  -8.078  1.00  0.00           H  
ATOM     49  HG3 LYS A   3       1.913  55.168  -8.301  1.00  0.00           H  
ATOM     50  HD2 LYS A   3       3.440  56.597  -6.907  1.00  0.00           H  
ATOM     51  HD3 LYS A   3       1.921  56.148  -6.129  1.00  0.00           H  
ATOM     52  HE2 LYS A   3       3.128  54.284  -4.998  1.00  0.00           H  
ATOM     53  HE3 LYS A   3       4.633  54.908  -5.668  1.00  0.00           H  
ATOM     54  HZ1 LYS A   3       4.141  55.612  -3.344  1.00  0.00           H  
ATOM     55  HZ2 LYS A   3       2.823  56.502  -3.932  1.00  0.00           H  
ATOM     56  HZ3 LYS A   3       4.402  56.900  -4.417  1.00  0.00           H  
ATOM     57  N   LYS A   4      -0.826  52.634  -8.040  1.00  0.00           N  
ATOM     58  CA  LYS A   4      -2.139  52.736  -8.642  1.00  0.00           C  
ATOM     59  C   LYS A   4      -2.343  51.658  -9.713  1.00  0.00           C  
ATOM     60  O   LYS A   4      -3.276  51.724 -10.509  1.00  0.00           O  
ATOM     61  CB  LYS A   4      -2.367  54.125  -9.204  1.00  0.00           C  
ATOM     62  CG  LYS A   4      -2.441  55.202  -8.137  1.00  0.00           C  
ATOM     63  CD  LYS A   4      -2.606  56.573  -8.761  1.00  0.00           C  
ATOM     64  CE  LYS A   4      -2.795  57.653  -7.706  1.00  0.00           C  
ATOM     65  NZ  LYS A   4      -2.955  59.002  -8.314  1.00  0.00           N  
ATOM     66  H   LYS A   4      -0.772  52.456  -7.093  1.00  0.00           H  
ATOM     67  HA  LYS A   4      -2.859  52.572  -7.858  1.00  0.00           H  
ATOM     68  HB2 LYS A   4      -1.565  54.370  -9.884  1.00  0.00           H  
ATOM     69  HB3 LYS A   4      -3.289  54.116  -9.736  1.00  0.00           H  
ATOM     70  HG2 LYS A   4      -3.286  55.005  -7.493  1.00  0.00           H  
ATOM     71  HG3 LYS A   4      -1.531  55.186  -7.559  1.00  0.00           H  
ATOM     72  HD2 LYS A   4      -1.724  56.792  -9.337  1.00  0.00           H  
ATOM     73  HD3 LYS A   4      -3.469  56.559  -9.410  1.00  0.00           H  
ATOM     74  HE2 LYS A   4      -3.676  57.423  -7.126  1.00  0.00           H  
ATOM     75  HE3 LYS A   4      -1.932  57.659  -7.056  1.00  0.00           H  
ATOM     76  HZ1 LYS A   4      -3.666  58.970  -9.079  1.00  0.00           H  
ATOM     77  HZ2 LYS A   4      -2.050  59.331  -8.712  1.00  0.00           H  
ATOM     78  HZ3 LYS A   4      -3.274  59.689  -7.593  1.00  0.00           H  
ATOM     79  N   PHE A   5      -1.458  50.666  -9.718  1.00  0.00           N  
ATOM     80  CA  PHE A   5      -1.635  49.476 -10.543  1.00  0.00           C  
ATOM     81  C   PHE A   5      -2.126  48.330  -9.672  1.00  0.00           C  
ATOM     82  O   PHE A   5      -3.278  47.920  -9.760  1.00  0.00           O  
ATOM     83  CB  PHE A   5      -0.326  49.086 -11.235  1.00  0.00           C  
ATOM     84  CG  PHE A   5       0.071  50.008 -12.353  1.00  0.00           C  
ATOM     85  CD1 PHE A   5      -0.417  49.810 -13.634  1.00  0.00           C  
ATOM     86  CD2 PHE A   5       0.937  51.066 -12.126  1.00  0.00           C  
ATOM     87  CE1 PHE A   5      -0.054  50.650 -14.667  1.00  0.00           C  
ATOM     88  CE2 PHE A   5       1.305  51.910 -13.155  1.00  0.00           C  
ATOM     89  CZ  PHE A   5       0.809  51.701 -14.427  1.00  0.00           C  
ATOM     90  H   PHE A   5      -0.660  50.742  -9.160  1.00  0.00           H  
ATOM     91  HA  PHE A   5      -2.380  49.695 -11.291  1.00  0.00           H  
ATOM     92  HB2 PHE A   5       0.470  49.089 -10.507  1.00  0.00           H  
ATOM     93  HB3 PHE A   5      -0.429  48.091 -11.643  1.00  0.00           H  
ATOM     94  HD1 PHE A   5      -1.091  48.987 -13.821  1.00  0.00           H  
ATOM     95  HD2 PHE A   5       1.324  51.230 -11.131  1.00  0.00           H  
ATOM     96  HE1 PHE A   5      -0.443  50.485 -15.662  1.00  0.00           H  
ATOM     97  HE2 PHE A   5       1.979  52.731 -12.966  1.00  0.00           H  
ATOM     98  HZ  PHE A   5       1.095  52.360 -15.234  1.00  0.00           H  
ATOM     99  N   LEU A   6      -1.241  47.818  -8.829  1.00  0.00           N  
ATOM    100  CA  LEU A   6      -1.626  46.859  -7.804  1.00  0.00           C  
ATOM    101  C   LEU A   6      -2.041  47.619  -6.549  1.00  0.00           C  
ATOM    102  O   LEU A   6      -2.600  47.059  -5.608  1.00  0.00           O  
ATOM    103  CB  LEU A   6      -0.469  45.902  -7.482  1.00  0.00           C  
ATOM    104  CG  LEU A   6       0.636  46.453  -6.568  1.00  0.00           C  
ATOM    105  CD1 LEU A   6       1.586  45.342  -6.154  1.00  0.00           C  
ATOM    106  CD2 LEU A   6       1.413  47.580  -7.240  1.00  0.00           C  
ATOM    107  H   LEU A   6      -0.300  48.071  -8.909  1.00  0.00           H  
ATOM    108  HA  LEU A   6      -2.472  46.294  -8.170  1.00  0.00           H  
ATOM    109  HB2 LEU A   6      -0.882  45.022  -7.017  1.00  0.00           H  
ATOM    110  HB3 LEU A   6      -0.012  45.608  -8.410  1.00  0.00           H  
ATOM    111  HG  LEU A   6       0.181  46.847  -5.679  1.00  0.00           H  
ATOM    112 HD11 LEU A   6       2.042  44.910  -7.034  1.00  0.00           H  
ATOM    113 HD12 LEU A   6       1.038  44.578  -5.621  1.00  0.00           H  
ATOM    114 HD13 LEU A   6       2.356  45.746  -5.513  1.00  0.00           H  
ATOM    115 HD21 LEU A   6       0.747  48.407  -7.441  1.00  0.00           H  
ATOM    116 HD22 LEU A   6       1.834  47.224  -8.170  1.00  0.00           H  
ATOM    117 HD23 LEU A   6       2.209  47.909  -6.587  1.00  0.00           H  
ATOM    118  N   ASP A   7      -1.774  48.917  -6.576  1.00  0.00           N  
ATOM    119  CA  ASP A   7      -2.033  49.794  -5.450  1.00  0.00           C  
ATOM    120  C   ASP A   7      -3.346  50.534  -5.680  1.00  0.00           C  
ATOM    121  O   ASP A   7      -3.389  51.750  -5.844  1.00  0.00           O  
ATOM    122  CB  ASP A   7      -0.860  50.767  -5.264  1.00  0.00           C  
ATOM    123  CG  ASP A   7      -1.075  51.755  -4.136  1.00  0.00           C  
ATOM    124  OD1 ASP A   7      -1.263  51.321  -2.979  1.00  0.00           O  
ATOM    125  OD2 ASP A   7      -1.078  52.975  -4.409  1.00  0.00           O  
ATOM    126  H   ASP A   7      -1.420  49.300  -7.395  1.00  0.00           H  
ATOM    127  HA  ASP A   7      -2.130  49.179  -4.568  1.00  0.00           H  
ATOM    128  HB2 ASP A   7       0.033  50.199  -5.049  1.00  0.00           H  
ATOM    129  HB3 ASP A   7      -0.715  51.320  -6.178  1.00  0.00           H  
ATOM    130  N   ILE A   8      -4.405  49.755  -5.775  1.00  0.00           N  
ATOM    131  CA  ILE A   8      -5.753  50.284  -5.936  1.00  0.00           C  
ATOM    132  C   ILE A   8      -6.719  49.549  -5.018  1.00  0.00           C  
ATOM    133  O   ILE A   8      -7.916  49.450  -5.306  1.00  0.00           O  
ATOM    134  CB  ILE A   8      -6.248  50.161  -7.393  1.00  0.00           C  
ATOM    135  CG1 ILE A   8      -5.990  48.748  -7.932  1.00  0.00           C  
ATOM    136  CG2 ILE A   8      -5.594  51.217  -8.273  1.00  0.00           C  
ATOM    137  CD1 ILE A   8      -6.492  48.534  -9.343  1.00  0.00           C  
ATOM    138  H   ILE A   8      -4.276  48.781  -5.746  1.00  0.00           H  
ATOM    139  HA  ILE A   8      -5.735  51.331  -5.666  1.00  0.00           H  
ATOM    140  HB  ILE A   8      -7.312  50.343  -7.399  1.00  0.00           H  
ATOM    141 HG12 ILE A   8      -4.928  48.557  -7.928  1.00  0.00           H  
ATOM    142 HG13 ILE A   8      -6.485  48.034  -7.291  1.00  0.00           H  
ATOM    143 HG21 ILE A   8      -5.854  52.200  -7.907  1.00  0.00           H  
ATOM    144 HG22 ILE A   8      -5.944  51.110  -9.289  1.00  0.00           H  
ATOM    145 HG23 ILE A   8      -4.522  51.097  -8.247  1.00  0.00           H  
ATOM    146 HD11 ILE A   8      -6.282  47.519  -9.650  1.00  0.00           H  
ATOM    147 HD12 ILE A   8      -5.996  49.223 -10.012  1.00  0.00           H  
ATOM    148 HD13 ILE A   8      -7.558  48.706  -9.375  1.00  0.00           H  
ATOM    149  N   LEU A   9      -6.195  49.044  -3.909  1.00  0.00           N  
ATOM    150  CA  LEU A   9      -6.997  48.272  -2.972  1.00  0.00           C  
ATOM    151  C   LEU A   9      -7.914  49.180  -2.168  1.00  0.00           C  
ATOM    152  O   LEU A   9      -7.456  50.084  -1.463  1.00  0.00           O  
ATOM    153  CB  LEU A   9      -6.108  47.471  -2.027  1.00  0.00           C  
ATOM    154  CG  LEU A   9      -5.142  46.497  -2.706  1.00  0.00           C  
ATOM    155  CD1 LEU A   9      -4.284  45.790  -1.666  1.00  0.00           C  
ATOM    156  CD2 LEU A   9      -5.907  45.480  -3.544  1.00  0.00           C  
ATOM    157  H   LEU A   9      -5.246  49.208  -3.707  1.00  0.00           H  
ATOM    158  HA  LEU A   9      -7.606  47.588  -3.546  1.00  0.00           H  
ATOM    159  HB2 LEU A   9      -5.533  48.167  -1.438  1.00  0.00           H  
ATOM    160  HB3 LEU A   9      -6.744  46.906  -1.363  1.00  0.00           H  
ATOM    161  HG  LEU A   9      -4.486  47.049  -3.362  1.00  0.00           H  
ATOM    162 HD11 LEU A   9      -4.922  45.256  -0.975  1.00  0.00           H  
ATOM    163 HD12 LEU A   9      -3.698  46.519  -1.125  1.00  0.00           H  
ATOM    164 HD13 LEU A   9      -3.623  45.091  -2.157  1.00  0.00           H  
ATOM    165 HD21 LEU A   9      -6.460  45.993  -4.318  1.00  0.00           H  
ATOM    166 HD22 LEU A   9      -6.594  44.937  -2.912  1.00  0.00           H  
ATOM    167 HD23 LEU A   9      -5.211  44.789  -3.996  1.00  0.00           H  
ATOM    168  N   VAL A  10      -9.206  48.931  -2.285  1.00  0.00           N  
ATOM    169  CA  VAL A  10     -10.214  49.699  -1.573  1.00  0.00           C  
ATOM    170  C   VAL A  10     -11.253  48.770  -0.960  1.00  0.00           C  
ATOM    171  O   VAL A  10     -11.374  47.611  -1.363  1.00  0.00           O  
ATOM    172  CB  VAL A  10     -10.930  50.719  -2.487  1.00  0.00           C  
ATOM    173  CG1 VAL A  10      -9.986  51.840  -2.896  1.00  0.00           C  
ATOM    174  CG2 VAL A  10     -11.516  50.032  -3.716  1.00  0.00           C  
ATOM    175  H   VAL A  10      -9.491  48.192  -2.859  1.00  0.00           H  
ATOM    176  HA  VAL A  10      -9.718  50.241  -0.778  1.00  0.00           H  
ATOM    177  HB  VAL A  10     -11.746  51.157  -1.928  1.00  0.00           H  
ATOM    178 HG11 VAL A  10      -9.159  51.429  -3.455  1.00  0.00           H  
ATOM    179 HG12 VAL A  10      -9.613  52.335  -2.011  1.00  0.00           H  
ATOM    180 HG13 VAL A  10     -10.519  52.552  -3.508  1.00  0.00           H  
ATOM    181 HG21 VAL A  10     -12.217  49.273  -3.404  1.00  0.00           H  
ATOM    182 HG22 VAL A  10     -10.722  49.575  -4.287  1.00  0.00           H  
ATOM    183 HG23 VAL A  10     -12.025  50.762  -4.327  1.00  0.00           H  
ATOM    184  N   CYS A  11     -11.987  49.279   0.018  1.00  0.00           N  
ATOM    185  CA  CYS A  11     -13.046  48.515   0.665  1.00  0.00           C  
ATOM    186  C   CYS A  11     -14.203  48.279  -0.306  1.00  0.00           C  
ATOM    187  O   CYS A  11     -14.484  49.121  -1.154  1.00  0.00           O  
ATOM    188  CB  CYS A  11     -13.551  49.266   1.896  1.00  0.00           C  
ATOM    189  SG  CYS A  11     -12.244  49.796   3.021  1.00  0.00           S  
ATOM    190  H   CYS A  11     -11.808  50.197   0.316  1.00  0.00           H  
ATOM    191  HA  CYS A  11     -12.638  47.563   0.969  1.00  0.00           H  
ATOM    192  HB2 CYS A  11     -14.085  50.148   1.575  1.00  0.00           H  
ATOM    193  HB3 CYS A  11     -14.224  48.626   2.448  1.00  0.00           H  
ATOM    194  HG  CYS A  11     -11.210  48.980   2.860  1.00  0.00           H  
ATOM    195  N   PRO A  12     -14.899  47.138  -0.194  1.00  0.00           N  
ATOM    196  CA  PRO A  12     -16.010  46.804  -1.094  1.00  0.00           C  
ATOM    197  C   PRO A  12     -17.242  47.680  -0.866  1.00  0.00           C  
ATOM    198  O   PRO A  12     -18.056  47.869  -1.770  1.00  0.00           O  
ATOM    199  CB  PRO A  12     -16.314  45.343  -0.752  1.00  0.00           C  
ATOM    200  CG  PRO A  12     -15.846  45.174   0.652  1.00  0.00           C  
ATOM    201  CD  PRO A  12     -14.652  46.076   0.801  1.00  0.00           C  
ATOM    202  HA  PRO A  12     -15.710  46.875  -2.131  1.00  0.00           H  
ATOM    203  HB2 PRO A  12     -17.375  45.162  -0.841  1.00  0.00           H  
ATOM    204  HB3 PRO A  12     -15.775  44.694  -1.425  1.00  0.00           H  
ATOM    205  HG2 PRO A  12     -16.627  45.467   1.339  1.00  0.00           H  
ATOM    206  HG3 PRO A  12     -15.561  44.147   0.822  1.00  0.00           H  
ATOM    207  HD2 PRO A  12     -14.611  46.486   1.800  1.00  0.00           H  
ATOM    208  HD3 PRO A  12     -13.743  45.539   0.575  1.00  0.00           H  
ATOM    209  N   VAL A  13     -17.370  48.219   0.340  1.00  0.00           N  
ATOM    210  CA  VAL A  13     -18.534  49.022   0.694  1.00  0.00           C  
ATOM    211  C   VAL A  13     -18.182  50.509   0.727  1.00  0.00           C  
ATOM    212  O   VAL A  13     -18.663  51.293  -0.091  1.00  0.00           O  
ATOM    213  CB  VAL A  13     -19.116  48.600   2.065  1.00  0.00           C  
ATOM    214  CG1 VAL A  13     -20.394  49.368   2.370  1.00  0.00           C  
ATOM    215  CG2 VAL A  13     -19.371  47.100   2.108  1.00  0.00           C  
ATOM    216  H   VAL A  13     -16.665  48.076   1.004  1.00  0.00           H  
ATOM    217  HA  VAL A  13     -19.290  48.860  -0.059  1.00  0.00           H  
ATOM    218  HB  VAL A  13     -18.391  48.839   2.829  1.00  0.00           H  
ATOM    219 HG11 VAL A  13     -21.139  49.144   1.618  1.00  0.00           H  
ATOM    220 HG12 VAL A  13     -20.187  50.427   2.365  1.00  0.00           H  
ATOM    221 HG13 VAL A  13     -20.763  49.078   3.342  1.00  0.00           H  
ATOM    222 HG21 VAL A  13     -19.770  46.830   3.073  1.00  0.00           H  
ATOM    223 HG22 VAL A  13     -18.445  46.572   1.941  1.00  0.00           H  
ATOM    224 HG23 VAL A  13     -20.081  46.832   1.339  1.00  0.00           H  
ATOM    225  N   THR A  14     -17.324  50.889   1.665  1.00  0.00           N  
ATOM    226  CA  THR A  14     -16.954  52.285   1.839  1.00  0.00           C  
ATOM    227  C   THR A  14     -16.034  52.754   0.717  1.00  0.00           C  
ATOM    228  O   THR A  14     -15.967  53.945   0.417  1.00  0.00           O  
ATOM    229  CB  THR A  14     -16.271  52.496   3.199  1.00  0.00           C  
ATOM    230  OG1 THR A  14     -15.246  51.511   3.384  1.00  0.00           O  
ATOM    231  CG2 THR A  14     -17.282  52.395   4.330  1.00  0.00           C  
ATOM    232  H   THR A  14     -16.933  50.217   2.258  1.00  0.00           H  
ATOM    233  HA  THR A  14     -17.859  52.874   1.818  1.00  0.00           H  
ATOM    234  HB  THR A  14     -15.826  53.481   3.218  1.00  0.00           H  
ATOM    235  HG1 THR A  14     -14.961  51.516   4.304  1.00  0.00           H  
ATOM    236 HG21 THR A  14     -16.781  52.548   5.276  1.00  0.00           H  
ATOM    237 HG22 THR A  14     -17.736  51.415   4.321  1.00  0.00           H  
ATOM    238 HG23 THR A  14     -18.047  53.147   4.200  1.00  0.00           H  
ATOM    239  N   LYS A  15     -15.327  51.799   0.112  1.00  0.00           N  
ATOM    240  CA  LYS A  15     -14.441  52.064  -1.024  1.00  0.00           C  
ATOM    241  C   LYS A  15     -13.344  53.061  -0.659  1.00  0.00           C  
ATOM    242  O   LYS A  15     -12.812  53.766  -1.518  1.00  0.00           O  
ATOM    243  CB  LYS A  15     -15.256  52.542  -2.233  1.00  0.00           C  
ATOM    244  CG  LYS A  15     -16.260  51.501  -2.705  1.00  0.00           C  
ATOM    245  CD  LYS A  15     -17.042  51.951  -3.924  1.00  0.00           C  
ATOM    246  CE  LYS A  15     -18.064  50.898  -4.322  1.00  0.00           C  
ATOM    247  NZ  LYS A  15     -18.809  51.272  -5.551  1.00  0.00           N  
ATOM    248  H   LYS A  15     -15.411  50.880   0.434  1.00  0.00           H  
ATOM    249  HA  LYS A  15     -13.970  51.127  -1.282  1.00  0.00           H  
ATOM    250  HB2 LYS A  15     -15.791  53.439  -1.964  1.00  0.00           H  
ATOM    251  HB3 LYS A  15     -14.583  52.760  -3.048  1.00  0.00           H  
ATOM    252  HG2 LYS A  15     -15.728  50.596  -2.956  1.00  0.00           H  
ATOM    253  HG3 LYS A  15     -16.952  51.299  -1.901  1.00  0.00           H  
ATOM    254  HD2 LYS A  15     -17.556  52.873  -3.694  1.00  0.00           H  
ATOM    255  HD3 LYS A  15     -16.359  52.110  -4.745  1.00  0.00           H  
ATOM    256  HE2 LYS A  15     -17.549  49.967  -4.495  1.00  0.00           H  
ATOM    257  HE3 LYS A  15     -18.766  50.774  -3.510  1.00  0.00           H  
ATOM    258  HZ1 LYS A  15     -19.347  52.151  -5.393  1.00  0.00           H  
ATOM    259  HZ2 LYS A  15     -19.478  50.514  -5.807  1.00  0.00           H  
ATOM    260  HZ3 LYS A  15     -18.146  51.420  -6.346  1.00  0.00           H  
ATOM    261  N   GLY A  16     -12.992  53.092   0.621  1.00  0.00           N  
ATOM    262  CA  GLY A  16     -11.893  53.920   1.070  1.00  0.00           C  
ATOM    263  C   GLY A  16     -10.561  53.227   0.869  1.00  0.00           C  
ATOM    264  O   GLY A  16     -10.526  52.043   0.533  1.00  0.00           O  
ATOM    265  H   GLY A  16     -13.486  52.547   1.265  1.00  0.00           H  
ATOM    266  HA2 GLY A  16     -11.899  54.845   0.512  1.00  0.00           H  
ATOM    267  HA3 GLY A  16     -12.019  54.140   2.120  1.00  0.00           H  
ATOM    268  N   ARG A  17      -9.470  53.949   1.086  1.00  0.00           N  
ATOM    269  CA  ARG A  17      -8.139  53.419   0.847  1.00  0.00           C  
ATOM    270  C   ARG A  17      -7.746  52.363   1.869  1.00  0.00           C  
ATOM    271  O   ARG A  17      -8.210  52.369   3.009  1.00  0.00           O  
ATOM    272  CB  ARG A  17      -7.128  54.552   0.871  1.00  0.00           C  
ATOM    273  CG  ARG A  17      -6.599  54.928  -0.498  1.00  0.00           C  
ATOM    274  CD  ARG A  17      -5.700  53.837  -1.057  1.00  0.00           C  
ATOM    275  NE  ARG A  17      -5.116  54.203  -2.344  1.00  0.00           N  
ATOM    276  CZ  ARG A  17      -3.971  53.707  -2.808  1.00  0.00           C  
ATOM    277  NH1 ARG A  17      -3.279  52.836  -2.087  1.00  0.00           N  
ATOM    278  NH2 ARG A  17      -3.522  54.083  -3.996  1.00  0.00           N  
ATOM    279  H   ARG A  17      -9.557  54.868   1.423  1.00  0.00           H  
ATOM    280  HA  ARG A  17      -8.132  52.971  -0.134  1.00  0.00           H  
ATOM    281  HB2 ARG A  17      -7.596  55.415   1.301  1.00  0.00           H  
ATOM    282  HB3 ARG A  17      -6.298  54.263   1.491  1.00  0.00           H  
ATOM    283  HG2 ARG A  17      -7.434  55.073  -1.168  1.00  0.00           H  
ATOM    284  HG3 ARG A  17      -6.037  55.844  -0.416  1.00  0.00           H  
ATOM    285  HD2 ARG A  17      -4.904  53.650  -0.354  1.00  0.00           H  
ATOM    286  HD3 ARG A  17      -6.283  52.935  -1.182  1.00  0.00           H  
ATOM    287  HE  ARG A  17      -5.609  54.850  -2.901  1.00  0.00           H  
ATOM    288 HH11 ARG A  17      -3.613  52.548  -1.192  1.00  0.00           H  
ATOM    289 HH12 ARG A  17      -2.413  52.451  -2.447  1.00  0.00           H  
ATOM    290 HH21 ARG A  17      -4.046  54.740  -4.549  1.00  0.00           H  
ATOM    291 HH22 ARG A  17      -2.651  53.705  -4.351  1.00  0.00           H  
ATOM    292  N   LEU A  18      -6.872  51.474   1.440  1.00  0.00           N  
ATOM    293  CA  LEU A  18      -6.371  50.399   2.282  1.00  0.00           C  
ATOM    294  C   LEU A  18      -4.860  50.284   2.144  1.00  0.00           C  
ATOM    295  O   LEU A  18      -4.320  50.408   1.042  1.00  0.00           O  
ATOM    296  CB  LEU A  18      -7.009  49.063   1.889  1.00  0.00           C  
ATOM    297  CG  LEU A  18      -8.516  48.946   2.119  1.00  0.00           C  
ATOM    298  CD1 LEU A  18      -9.033  47.620   1.586  1.00  0.00           C  
ATOM    299  CD2 LEU A  18      -8.838  49.083   3.596  1.00  0.00           C  
ATOM    300  H   LEU A  18      -6.545  51.546   0.520  1.00  0.00           H  
ATOM    301  HA  LEU A  18      -6.619  50.627   3.308  1.00  0.00           H  
ATOM    302  HB2 LEU A  18      -6.813  48.893   0.841  1.00  0.00           H  
ATOM    303  HB3 LEU A  18      -6.522  48.281   2.456  1.00  0.00           H  
ATOM    304  HG  LEU A  18      -9.022  49.741   1.588  1.00  0.00           H  
ATOM    305 HD11 LEU A  18      -8.858  47.567   0.522  1.00  0.00           H  
ATOM    306 HD12 LEU A  18     -10.093  47.542   1.781  1.00  0.00           H  
ATOM    307 HD13 LEU A  18      -8.516  46.810   2.076  1.00  0.00           H  
ATOM    308 HD21 LEU A  18      -9.906  49.010   3.741  1.00  0.00           H  
ATOM    309 HD22 LEU A  18      -8.493  50.043   3.951  1.00  0.00           H  
ATOM    310 HD23 LEU A  18      -8.346  48.297   4.148  1.00  0.00           H  
ATOM    311  N   GLU A  19      -4.181  50.059   3.258  1.00  0.00           N  
ATOM    312  CA  GLU A  19      -2.762  49.762   3.232  1.00  0.00           C  
ATOM    313  C   GLU A  19      -2.501  48.446   3.952  1.00  0.00           C  
ATOM    314  O   GLU A  19      -2.925  48.246   5.094  1.00  0.00           O  
ATOM    315  CB  GLU A  19      -1.932  50.906   3.828  1.00  0.00           C  
ATOM    316  CG  GLU A  19      -2.384  51.376   5.199  1.00  0.00           C  
ATOM    317  CD  GLU A  19      -1.534  52.521   5.714  1.00  0.00           C  
ATOM    318  OE1 GLU A  19      -1.618  53.627   5.146  1.00  0.00           O  
ATOM    319  OE2 GLU A  19      -0.775  52.317   6.684  1.00  0.00           O  
ATOM    320  H   GLU A  19      -4.644  50.091   4.120  1.00  0.00           H  
ATOM    321  HA  GLU A  19      -2.482  49.637   2.195  1.00  0.00           H  
ATOM    322  HB2 GLU A  19      -0.907  50.581   3.909  1.00  0.00           H  
ATOM    323  HB3 GLU A  19      -1.975  51.750   3.152  1.00  0.00           H  
ATOM    324  HG2 GLU A  19      -3.412  51.706   5.133  1.00  0.00           H  
ATOM    325  HG3 GLU A  19      -2.313  50.550   5.892  1.00  0.00           H  
ATOM    326  N   TYR A  20      -1.839  47.539   3.258  1.00  0.00           N  
ATOM    327  CA  TYR A  20      -1.607  46.199   3.765  1.00  0.00           C  
ATOM    328  C   TYR A  20      -0.299  46.125   4.531  1.00  0.00           C  
ATOM    329  O   TYR A  20       0.634  46.882   4.267  1.00  0.00           O  
ATOM    330  CB  TYR A  20      -1.593  45.188   2.610  1.00  0.00           C  
ATOM    331  CG  TYR A  20      -0.615  45.526   1.501  1.00  0.00           C  
ATOM    332  CD1 TYR A  20      -0.993  46.342   0.440  1.00  0.00           C  
ATOM    333  CD2 TYR A  20       0.682  45.027   1.512  1.00  0.00           C  
ATOM    334  CE1 TYR A  20      -0.105  46.652  -0.574  1.00  0.00           C  
ATOM    335  CE2 TYR A  20       1.576  45.334   0.502  1.00  0.00           C  
ATOM    336  CZ  TYR A  20       1.177  46.147  -0.538  1.00  0.00           C  
ATOM    337  OH  TYR A  20       2.064  46.455  -1.546  1.00  0.00           O  
ATOM    338  H   TYR A  20      -1.481  47.783   2.379  1.00  0.00           H  
ATOM    339  HA  TYR A  20      -2.416  45.952   4.434  1.00  0.00           H  
ATOM    340  HB2 TYR A  20      -1.329  44.216   2.998  1.00  0.00           H  
ATOM    341  HB3 TYR A  20      -2.580  45.138   2.173  1.00  0.00           H  
ATOM    342  HD1 TYR A  20      -1.997  46.736   0.413  1.00  0.00           H  
ATOM    343  HD2 TYR A  20       0.992  44.392   2.328  1.00  0.00           H  
ATOM    344  HE1 TYR A  20      -0.418  47.290  -1.388  1.00  0.00           H  
ATOM    345  HE2 TYR A  20       2.579  44.933   0.530  1.00  0.00           H  
ATOM    346  HH  TYR A  20       1.989  47.401  -1.764  1.00  0.00           H  
ATOM    347  N   HIS A  21      -0.242  45.221   5.490  1.00  0.00           N  
ATOM    348  CA  HIS A  21       0.996  44.942   6.190  1.00  0.00           C  
ATOM    349  C   HIS A  21       1.239  43.440   6.187  1.00  0.00           C  
ATOM    350  O   HIS A  21       0.311  42.657   6.412  1.00  0.00           O  
ATOM    351  CB  HIS A  21       0.982  45.514   7.623  1.00  0.00           C  
ATOM    352  CG  HIS A  21       0.048  44.829   8.589  1.00  0.00           C  
ATOM    353  ND1 HIS A  21       0.472  44.303   9.791  1.00  0.00           N  
ATOM    354  CD2 HIS A  21      -1.291  44.612   8.544  1.00  0.00           C  
ATOM    355  CE1 HIS A  21      -0.557  43.790  10.437  1.00  0.00           C  
ATOM    356  NE2 HIS A  21      -1.640  43.964   9.706  1.00  0.00           N  
ATOM    357  H   HIS A  21      -1.052  44.716   5.722  1.00  0.00           H  
ATOM    358  HA  HIS A  21       1.794  45.416   5.633  1.00  0.00           H  
ATOM    359  HB2 HIS A  21       1.979  45.441   8.032  1.00  0.00           H  
ATOM    360  HB3 HIS A  21       0.700  46.557   7.577  1.00  0.00           H  
ATOM    361  HD1 HIS A  21       1.398  44.326  10.133  1.00  0.00           H  
ATOM    362  HD2 HIS A  21      -1.960  44.895   7.744  1.00  0.00           H  
ATOM    363  HE1 HIS A  21      -0.519  43.314  11.407  1.00  0.00           H  
ATOM    364  HE2 HIS A  21      -2.559  43.837  10.028  1.00  0.00           H  
ATOM    365  N   GLN A  22       2.473  43.047   5.903  1.00  0.00           N  
ATOM    366  CA  GLN A  22       2.832  41.636   5.779  1.00  0.00           C  
ATOM    367  C   GLN A  22       2.763  40.909   7.122  1.00  0.00           C  
ATOM    368  O   GLN A  22       2.195  41.424   8.089  1.00  0.00           O  
ATOM    369  CB  GLN A  22       4.231  41.505   5.170  1.00  0.00           C  
ATOM    370  CG  GLN A  22       4.240  41.401   3.649  1.00  0.00           C  
ATOM    371  CD  GLN A  22       3.444  42.498   2.967  1.00  0.00           C  
ATOM    372  OE1 GLN A  22       3.966  43.577   2.691  1.00  0.00           O  
ATOM    373  NE2 GLN A  22       2.184  42.223   2.662  1.00  0.00           N  
ATOM    374  H   GLN A  22       3.169  43.725   5.772  1.00  0.00           H  
ATOM    375  HA  GLN A  22       2.121  41.178   5.108  1.00  0.00           H  
ATOM    376  HB2 GLN A  22       4.813  42.372   5.448  1.00  0.00           H  
ATOM    377  HB3 GLN A  22       4.706  40.623   5.572  1.00  0.00           H  
ATOM    378  HG2 GLN A  22       5.262  41.460   3.305  1.00  0.00           H  
ATOM    379  HG3 GLN A  22       3.824  40.445   3.366  1.00  0.00           H  
ATOM    380 HE21 GLN A  22       1.829  41.332   2.890  1.00  0.00           H  
ATOM    381 HE22 GLN A  22       1.659  42.913   2.209  1.00  0.00           H  
ATOM    382  N   ASP A  23       3.315  39.692   7.148  1.00  0.00           N  
ATOM    383  CA  ASP A  23       3.311  38.824   8.330  1.00  0.00           C  
ATOM    384  C   ASP A  23       1.930  38.209   8.554  1.00  0.00           C  
ATOM    385  O   ASP A  23       1.791  36.983   8.599  1.00  0.00           O  
ATOM    386  CB  ASP A  23       3.781  39.574   9.579  1.00  0.00           C  
ATOM    387  CG  ASP A  23       3.790  38.701  10.814  1.00  0.00           C  
ATOM    388  OD1 ASP A  23       4.780  37.968  11.026  1.00  0.00           O  
ATOM    389  OD2 ASP A  23       2.809  38.745  11.580  1.00  0.00           O  
ATOM    390  H   ASP A  23       3.747  39.356   6.330  1.00  0.00           H  
ATOM    391  HA  ASP A  23       4.006  38.021   8.134  1.00  0.00           H  
ATOM    392  HB2 ASP A  23       4.783  39.942   9.413  1.00  0.00           H  
ATOM    393  HB3 ASP A  23       3.121  40.409   9.755  1.00  0.00           H  
ATOM    394  N   LYS A  24       0.909  39.052   8.676  1.00  0.00           N  
ATOM    395  CA  LYS A  24      -0.459  38.576   8.826  1.00  0.00           C  
ATOM    396  C   LYS A  24      -1.250  38.804   7.543  1.00  0.00           C  
ATOM    397  O   LYS A  24      -2.325  38.236   7.365  1.00  0.00           O  
ATOM    398  CB  LYS A  24      -1.150  39.265  10.006  1.00  0.00           C  
ATOM    399  CG  LYS A  24      -0.543  38.909  11.352  1.00  0.00           C  
ATOM    400  CD  LYS A  24      -1.388  39.426  12.509  1.00  0.00           C  
ATOM    401  CE  LYS A  24      -0.815  38.985  13.851  1.00  0.00           C  
ATOM    402  NZ  LYS A  24      -1.658  39.409  15.005  1.00  0.00           N  
ATOM    403  H   LYS A  24       1.084  40.020   8.666  1.00  0.00           H  
ATOM    404  HA  LYS A  24      -0.416  37.516   9.021  1.00  0.00           H  
ATOM    405  HB2 LYS A  24      -1.082  40.334   9.876  1.00  0.00           H  
ATOM    406  HB3 LYS A  24      -2.191  38.979  10.017  1.00  0.00           H  
ATOM    407  HG2 LYS A  24      -0.469  37.835  11.427  1.00  0.00           H  
ATOM    408  HG3 LYS A  24       0.443  39.343  11.415  1.00  0.00           H  
ATOM    409  HD2 LYS A  24      -1.410  40.504  12.472  1.00  0.00           H  
ATOM    410  HD3 LYS A  24      -2.390  39.038  12.408  1.00  0.00           H  
ATOM    411  HE2 LYS A  24      -0.735  37.909  13.855  1.00  0.00           H  
ATOM    412  HE3 LYS A  24       0.171  39.414  13.963  1.00  0.00           H  
ATOM    413  HZ1 LYS A  24      -1.250  39.050  15.898  1.00  0.00           H  
ATOM    414  HZ2 LYS A  24      -2.628  39.034  14.906  1.00  0.00           H  
ATOM    415  HZ3 LYS A  24      -1.706  40.451  15.057  1.00  0.00           H  
ATOM    416  N   GLN A  25      -0.676  39.606   6.641  1.00  0.00           N  
ATOM    417  CA  GLN A  25      -1.316  39.967   5.372  1.00  0.00           C  
ATOM    418  C   GLN A  25      -2.703  40.566   5.604  1.00  0.00           C  
ATOM    419  O   GLN A  25      -3.669  40.210   4.929  1.00  0.00           O  
ATOM    420  CB  GLN A  25      -1.412  38.742   4.459  1.00  0.00           C  
ATOM    421  CG  GLN A  25      -0.108  37.965   4.335  1.00  0.00           C  
ATOM    422  CD  GLN A  25       1.044  38.797   3.806  1.00  0.00           C  
ATOM    423  OE1 GLN A  25       0.852  39.765   3.072  1.00  0.00           O  
ATOM    424  NE2 GLN A  25       2.256  38.412   4.168  1.00  0.00           N  
ATOM    425  H   GLN A  25       0.219  39.944   6.820  1.00  0.00           H  
ATOM    426  HA  GLN A  25      -0.696  40.709   4.894  1.00  0.00           H  
ATOM    427  HB2 GLN A  25      -2.166  38.074   4.849  1.00  0.00           H  
ATOM    428  HB3 GLN A  25      -1.707  39.067   3.472  1.00  0.00           H  
ATOM    429  HG2 GLN A  25       0.163  37.592   5.311  1.00  0.00           H  
ATOM    430  HG3 GLN A  25      -0.264  37.136   3.672  1.00  0.00           H  
ATOM    431 HE21 GLN A  25       2.341  37.621   4.754  1.00  0.00           H  
ATOM    432 HE22 GLN A  25       3.024  38.912   3.822  1.00  0.00           H  
ATOM    433  N   GLU A  26      -2.785  41.490   6.550  1.00  0.00           N  
ATOM    434  CA  GLU A  26      -4.060  42.098   6.920  1.00  0.00           C  
ATOM    435  C   GLU A  26      -4.252  43.471   6.269  1.00  0.00           C  
ATOM    436  O   GLU A  26      -3.306  44.263   6.167  1.00  0.00           O  
ATOM    437  CB  GLU A  26      -4.140  42.249   8.439  1.00  0.00           C  
ATOM    438  CG  GLU A  26      -4.141  40.933   9.196  1.00  0.00           C  
ATOM    439  CD  GLU A  26      -5.456  40.191   9.085  1.00  0.00           C  
ATOM    440  OE1 GLU A  26      -6.380  40.493   9.873  1.00  0.00           O  
ATOM    441  OE2 GLU A  26      -5.565  39.290   8.234  1.00  0.00           O  
ATOM    442  H   GLU A  26      -1.971  41.767   7.014  1.00  0.00           H  
ATOM    443  HA  GLU A  26      -4.852  41.442   6.592  1.00  0.00           H  
ATOM    444  HB2 GLU A  26      -3.292  42.827   8.774  1.00  0.00           H  
ATOM    445  HB3 GLU A  26      -5.046  42.781   8.686  1.00  0.00           H  
ATOM    446  HG2 GLU A  26      -3.357  40.304   8.798  1.00  0.00           H  
ATOM    447  HG3 GLU A  26      -3.945  41.133  10.238  1.00  0.00           H  
ATOM    448  N   LEU A  27      -5.481  43.741   5.846  1.00  0.00           N  
ATOM    449  CA  LEU A  27      -5.873  45.056   5.346  1.00  0.00           C  
ATOM    450  C   LEU A  27      -6.607  45.819   6.444  1.00  0.00           C  
ATOM    451  O   LEU A  27      -7.601  45.331   6.974  1.00  0.00           O  
ATOM    452  CB  LEU A  27      -6.793  44.920   4.127  1.00  0.00           C  
ATOM    453  CG  LEU A  27      -6.163  44.298   2.881  1.00  0.00           C  
ATOM    454  CD1 LEU A  27      -7.225  44.066   1.817  1.00  0.00           C  
ATOM    455  CD2 LEU A  27      -5.060  45.194   2.338  1.00  0.00           C  
ATOM    456  H   LEU A  27      -6.157  43.023   5.871  1.00  0.00           H  
ATOM    457  HA  LEU A  27      -4.980  45.597   5.069  1.00  0.00           H  
ATOM    458  HB2 LEU A  27      -7.639  44.314   4.414  1.00  0.00           H  
ATOM    459  HB3 LEU A  27      -7.152  45.905   3.866  1.00  0.00           H  
ATOM    460  HG  LEU A  27      -5.728  43.342   3.138  1.00  0.00           H  
ATOM    461 HD11 LEU A  27      -6.765  43.652   0.933  1.00  0.00           H  
ATOM    462 HD12 LEU A  27      -7.700  45.004   1.571  1.00  0.00           H  
ATOM    463 HD13 LEU A  27      -7.966  43.376   2.193  1.00  0.00           H  
ATOM    464 HD21 LEU A  27      -4.626  44.738   1.460  1.00  0.00           H  
ATOM    465 HD22 LEU A  27      -4.299  45.322   3.092  1.00  0.00           H  
ATOM    466 HD23 LEU A  27      -5.474  46.157   2.076  1.00  0.00           H  
ATOM    467  N   TRP A  28      -6.130  47.008   6.780  1.00  0.00           N  
ATOM    468  CA  TRP A  28      -6.733  47.790   7.857  1.00  0.00           C  
ATOM    469  C   TRP A  28      -7.578  48.931   7.312  1.00  0.00           C  
ATOM    470  O   TRP A  28      -7.133  49.685   6.447  1.00  0.00           O  
ATOM    471  CB  TRP A  28      -5.650  48.341   8.788  1.00  0.00           C  
ATOM    472  CG  TRP A  28      -5.191  47.354   9.820  1.00  0.00           C  
ATOM    473  CD1 TRP A  28      -5.441  46.011   9.842  1.00  0.00           C  
ATOM    474  CD2 TRP A  28      -4.411  47.637  10.990  1.00  0.00           C  
ATOM    475  NE1 TRP A  28      -4.870  45.443  10.953  1.00  0.00           N  
ATOM    476  CE2 TRP A  28      -4.231  46.420  11.673  1.00  0.00           C  
ATOM    477  CE3 TRP A  28      -3.850  48.798  11.524  1.00  0.00           C  
ATOM    478  CZ2 TRP A  28      -3.511  46.334  12.863  1.00  0.00           C  
ATOM    479  CZ3 TRP A  28      -3.136  48.712  12.706  1.00  0.00           C  
ATOM    480  CH2 TRP A  28      -2.973  47.487  13.362  1.00  0.00           C  
ATOM    481  H   TRP A  28      -5.369  47.380   6.287  1.00  0.00           H  
ATOM    482  HA  TRP A  28      -7.372  47.129   8.423  1.00  0.00           H  
ATOM    483  HB2 TRP A  28      -4.793  48.628   8.196  1.00  0.00           H  
ATOM    484  HB3 TRP A  28      -6.035  49.210   9.301  1.00  0.00           H  
ATOM    485  HD1 TRP A  28      -6.012  45.485   9.090  1.00  0.00           H  
ATOM    486  HE1 TRP A  28      -4.920  44.483  11.195  1.00  0.00           H  
ATOM    487  HE3 TRP A  28      -3.966  49.751  11.031  1.00  0.00           H  
ATOM    488  HZ2 TRP A  28      -3.376  45.397  13.381  1.00  0.00           H  
ATOM    489  HZ3 TRP A  28      -2.694  49.599  13.133  1.00  0.00           H  
ATOM    490  HH2 TRP A  28      -2.407  47.464  14.282  1.00  0.00           H  
ATOM    491  N   SER A  29      -8.794  49.054   7.826  1.00  0.00           N  
ATOM    492  CA  SER A  29      -9.697  50.110   7.405  1.00  0.00           C  
ATOM    493  C   SER A  29     -10.356  50.778   8.612  1.00  0.00           C  
ATOM    494  O   SER A  29     -11.051  50.126   9.391  1.00  0.00           O  
ATOM    495  CB  SER A  29     -10.768  49.542   6.470  1.00  0.00           C  
ATOM    496  OG  SER A  29     -11.492  48.487   7.084  1.00  0.00           O  
ATOM    497  H   SER A  29      -9.095  48.416   8.507  1.00  0.00           H  
ATOM    498  HA  SER A  29      -9.119  50.847   6.871  1.00  0.00           H  
ATOM    499  HB2 SER A  29     -11.460  50.326   6.206  1.00  0.00           H  
ATOM    500  HB3 SER A  29     -10.295  49.163   5.575  1.00  0.00           H  
ATOM    501  HG  SER A  29     -10.910  48.003   7.684  1.00  0.00           H  
ATOM    502  N   ARG A  30     -10.139  52.078   8.766  1.00  0.00           N  
ATOM    503  CA  ARG A  30     -10.777  52.830   9.843  1.00  0.00           C  
ATOM    504  C   ARG A  30     -12.165  53.267   9.397  1.00  0.00           C  
ATOM    505  O   ARG A  30     -13.078  53.425  10.207  1.00  0.00           O  
ATOM    506  CB  ARG A  30      -9.918  54.042  10.242  1.00  0.00           C  
ATOM    507  CG  ARG A  30     -10.421  54.775  11.479  1.00  0.00           C  
ATOM    508  CD  ARG A  30     -11.183  56.040  11.120  1.00  0.00           C  
ATOM    509  NE  ARG A  30     -11.848  56.624  12.284  1.00  0.00           N  
ATOM    510  CZ  ARG A  30     -11.505  57.786  12.838  1.00  0.00           C  
ATOM    511  NH1 ARG A  30     -10.471  58.478  12.366  1.00  0.00           N  
ATOM    512  NH2 ARG A  30     -12.193  58.256  13.871  1.00  0.00           N  
ATOM    513  H   ARG A  30      -9.543  52.543   8.140  1.00  0.00           H  
ATOM    514  HA  ARG A  30     -10.876  52.171  10.693  1.00  0.00           H  
ATOM    515  HB2 ARG A  30      -8.911  53.706  10.439  1.00  0.00           H  
ATOM    516  HB3 ARG A  30      -9.899  54.742   9.419  1.00  0.00           H  
ATOM    517  HG2 ARG A  30     -11.078  54.117  12.030  1.00  0.00           H  
ATOM    518  HG3 ARG A  30      -9.575  55.038  12.097  1.00  0.00           H  
ATOM    519  HD2 ARG A  30     -10.489  56.761  10.714  1.00  0.00           H  
ATOM    520  HD3 ARG A  30     -11.927  55.798  10.376  1.00  0.00           H  
ATOM    521  HE  ARG A  30     -12.606  56.115  12.668  1.00  0.00           H  
ATOM    522 HH11 ARG A  30      -9.940  58.127  11.587  1.00  0.00           H  
ATOM    523 HH12 ARG A  30     -10.205  59.349  12.795  1.00  0.00           H  
ATOM    524 HH21 ARG A  30     -12.975  57.734  14.242  1.00  0.00           H  
ATOM    525 HH22 ARG A  30     -11.943  59.137  14.287  1.00  0.00           H  
ATOM    526  N   GLN A  31     -12.315  53.421   8.088  1.00  0.00           N  
ATOM    527  CA  GLN A  31     -13.563  53.828   7.480  1.00  0.00           C  
ATOM    528  C   GLN A  31     -14.630  52.739   7.600  1.00  0.00           C  
ATOM    529  O   GLN A  31     -15.818  53.007   7.441  1.00  0.00           O  
ATOM    530  CB  GLN A  31     -13.325  54.169   6.004  1.00  0.00           C  
ATOM    531  CG  GLN A  31     -12.788  53.015   5.162  1.00  0.00           C  
ATOM    532  CD  GLN A  31     -11.269  52.920   5.153  1.00  0.00           C  
ATOM    533  OE1 GLN A  31     -10.593  53.305   6.105  1.00  0.00           O  
ATOM    534  NE2 GLN A  31     -10.726  52.380   4.077  1.00  0.00           N  
ATOM    535  H   GLN A  31     -11.543  53.275   7.500  1.00  0.00           H  
ATOM    536  HA  GLN A  31     -13.910  54.714   7.991  1.00  0.00           H  
ATOM    537  HB2 GLN A  31     -14.252  54.488   5.577  1.00  0.00           H  
ATOM    538  HB3 GLN A  31     -12.618  54.985   5.947  1.00  0.00           H  
ATOM    539  HG2 GLN A  31     -13.183  52.092   5.555  1.00  0.00           H  
ATOM    540  HG3 GLN A  31     -13.131  53.144   4.145  1.00  0.00           H  
ATOM    541 HE21 GLN A  31     -11.320  52.071   3.362  1.00  0.00           H  
ATOM    542 HE22 GLN A  31      -9.741  52.319   4.029  1.00  0.00           H  
ATOM    543  N   ALA A  32     -14.203  51.507   7.866  1.00  0.00           N  
ATOM    544  CA  ALA A  32     -15.133  50.401   8.029  1.00  0.00           C  
ATOM    545  C   ALA A  32     -14.990  49.777   9.412  1.00  0.00           C  
ATOM    546  O   ALA A  32     -15.823  48.971   9.831  1.00  0.00           O  
ATOM    547  CB  ALA A  32     -14.902  49.356   6.945  1.00  0.00           C  
ATOM    548  H   ALA A  32     -13.243  51.342   7.957  1.00  0.00           H  
ATOM    549  HA  ALA A  32     -16.136  50.787   7.918  1.00  0.00           H  
ATOM    550  HB1 ALA A  32     -13.898  48.965   7.032  1.00  0.00           H  
ATOM    551  HB2 ALA A  32     -15.029  49.810   5.975  1.00  0.00           H  
ATOM    552  HB3 ALA A  32     -15.612  48.551   7.060  1.00  0.00           H  
ATOM    553  N   LYS A  33     -13.920  50.169  10.113  1.00  0.00           N  
ATOM    554  CA  LYS A  33     -13.604  49.643  11.443  1.00  0.00           C  
ATOM    555  C   LYS A  33     -13.364  48.137  11.388  1.00  0.00           C  
ATOM    556  O   LYS A  33     -13.569  47.424  12.374  1.00  0.00           O  
ATOM    557  CB  LYS A  33     -14.724  49.968  12.441  1.00  0.00           C  
ATOM    558  CG  LYS A  33     -14.975  51.457  12.608  1.00  0.00           C  
ATOM    559  CD  LYS A  33     -16.025  51.743  13.669  1.00  0.00           C  
ATOM    560  CE  LYS A  33     -15.588  51.246  15.036  1.00  0.00           C  
ATOM    561  NZ  LYS A  33     -16.442  51.791  16.123  1.00  0.00           N  
ATOM    562  H   LYS A  33     -13.325  50.840   9.724  1.00  0.00           H  
ATOM    563  HA  LYS A  33     -12.693  50.121  11.772  1.00  0.00           H  
ATOM    564  HB2 LYS A  33     -15.639  49.507  12.098  1.00  0.00           H  
ATOM    565  HB3 LYS A  33     -14.465  49.557  13.406  1.00  0.00           H  
ATOM    566  HG2 LYS A  33     -14.053  51.937  12.895  1.00  0.00           H  
ATOM    567  HG3 LYS A  33     -15.311  51.861  11.664  1.00  0.00           H  
ATOM    568  HD2 LYS A  33     -16.191  52.809  13.721  1.00  0.00           H  
ATOM    569  HD3 LYS A  33     -16.945  51.247  13.393  1.00  0.00           H  
ATOM    570  HE2 LYS A  33     -15.651  50.167  15.050  1.00  0.00           H  
ATOM    571  HE3 LYS A  33     -14.566  51.549  15.206  1.00  0.00           H  
ATOM    572  HZ1 LYS A  33     -17.424  51.452  16.021  1.00  0.00           H  
ATOM    573  HZ2 LYS A  33     -16.443  52.834  16.082  1.00  0.00           H  
ATOM    574  HZ3 LYS A  33     -16.075  51.496  17.054  1.00  0.00           H  
ATOM    575  N   LEU A  34     -12.903  47.664  10.238  1.00  0.00           N  
ATOM    576  CA  LEU A  34     -12.674  46.244  10.040  1.00  0.00           C  
ATOM    577  C   LEU A  34     -11.276  45.987   9.500  1.00  0.00           C  
ATOM    578  O   LEU A  34     -10.539  46.917   9.158  1.00  0.00           O  
ATOM    579  CB  LEU A  34     -13.699  45.666   9.058  1.00  0.00           C  
ATOM    580  CG  LEU A  34     -15.169  45.845   9.443  1.00  0.00           C  
ATOM    581  CD1 LEU A  34     -16.069  45.381   8.311  1.00  0.00           C  
ATOM    582  CD2 LEU A  34     -15.487  45.081  10.717  1.00  0.00           C  
ATOM    583  H   LEU A  34     -12.700  48.287   9.508  1.00  0.00           H  
ATOM    584  HA  LEU A  34     -12.781  45.748  10.992  1.00  0.00           H  
ATOM    585  HB2 LEU A  34     -13.540  46.129   8.098  1.00  0.00           H  
ATOM    586  HB3 LEU A  34     -13.506  44.610   8.958  1.00  0.00           H  
ATOM    587  HG  LEU A  34     -15.365  46.893   9.622  1.00  0.00           H  
ATOM    588 HD11 LEU A  34     -15.901  44.329   8.126  1.00  0.00           H  
ATOM    589 HD12 LEU A  34     -15.840  45.945   7.420  1.00  0.00           H  
ATOM    590 HD13 LEU A  34     -17.103  45.538   8.585  1.00  0.00           H  
ATOM    591 HD21 LEU A  34     -14.896  45.474  11.529  1.00  0.00           H  
ATOM    592 HD22 LEU A  34     -15.257  44.033  10.577  1.00  0.00           H  
ATOM    593 HD23 LEU A  34     -16.538  45.190  10.947  1.00  0.00           H  
ATOM    594  N   ALA A  35     -10.943  44.713   9.409  1.00  0.00           N  
ATOM    595  CA  ALA A  35      -9.686  44.265   8.847  1.00  0.00           C  
ATOM    596  C   ALA A  35      -9.939  43.050   7.972  1.00  0.00           C  
ATOM    597  O   ALA A  35     -10.637  42.118   8.381  1.00  0.00           O  
ATOM    598  CB  ALA A  35      -8.689  43.927   9.943  1.00  0.00           C  
ATOM    599  H   ALA A  35     -11.575  44.036   9.742  1.00  0.00           H  
ATOM    600  HA  ALA A  35      -9.280  45.063   8.242  1.00  0.00           H  
ATOM    601  HB1 ALA A  35      -9.083  43.131  10.559  1.00  0.00           H  
ATOM    602  HB2 ALA A  35      -8.515  44.801  10.553  1.00  0.00           H  
ATOM    603  HB3 ALA A  35      -7.759  43.609   9.497  1.00  0.00           H  
ATOM    604  N   TYR A  36      -9.398  43.065   6.768  1.00  0.00           N  
ATOM    605  CA  TYR A  36      -9.622  41.976   5.833  1.00  0.00           C  
ATOM    606  C   TYR A  36      -8.361  41.131   5.694  1.00  0.00           C  
ATOM    607  O   TYR A  36      -7.251  41.662   5.701  1.00  0.00           O  
ATOM    608  CB  TYR A  36     -10.026  42.529   4.461  1.00  0.00           C  
ATOM    609  CG  TYR A  36     -11.201  43.483   4.502  1.00  0.00           C  
ATOM    610  CD1 TYR A  36     -12.487  43.023   4.759  1.00  0.00           C  
ATOM    611  CD2 TYR A  36     -11.024  44.844   4.279  1.00  0.00           C  
ATOM    612  CE1 TYR A  36     -13.561  43.892   4.793  1.00  0.00           C  
ATOM    613  CE2 TYR A  36     -12.094  45.718   4.313  1.00  0.00           C  
ATOM    614  CZ  TYR A  36     -13.359  45.236   4.571  1.00  0.00           C  
ATOM    615  OH  TYR A  36     -14.428  46.101   4.602  1.00  0.00           O  
ATOM    616  H   TYR A  36      -8.821  43.815   6.508  1.00  0.00           H  
ATOM    617  HA  TYR A  36     -10.419  41.360   6.217  1.00  0.00           H  
ATOM    618  HB2 TYR A  36      -9.188  43.059   4.037  1.00  0.00           H  
ATOM    619  HB3 TYR A  36     -10.288  41.705   3.813  1.00  0.00           H  
ATOM    620  HD1 TYR A  36     -12.643  41.969   4.934  1.00  0.00           H  
ATOM    621  HD2 TYR A  36     -10.031  45.219   4.076  1.00  0.00           H  
ATOM    622  HE1 TYR A  36     -14.551  43.516   4.994  1.00  0.00           H  
ATOM    623  HE2 TYR A  36     -11.936  46.773   4.138  1.00  0.00           H  
ATOM    624  HH  TYR A  36     -14.965  45.914   5.378  1.00  0.00           H  
ATOM    625  N   PRO A  37      -8.520  39.809   5.567  1.00  0.00           N  
ATOM    626  CA  PRO A  37      -7.405  38.898   5.362  1.00  0.00           C  
ATOM    627  C   PRO A  37      -7.073  38.696   3.886  1.00  0.00           C  
ATOM    628  O   PRO A  37      -7.963  38.624   3.031  1.00  0.00           O  
ATOM    629  CB  PRO A  37      -7.912  37.599   5.985  1.00  0.00           C  
ATOM    630  CG  PRO A  37      -9.402  37.644   5.851  1.00  0.00           C  
ATOM    631  CD  PRO A  37      -9.799  39.091   5.659  1.00  0.00           C  
ATOM    632  HA  PRO A  37      -6.523  39.229   5.885  1.00  0.00           H  
ATOM    633  HB2 PRO A  37      -7.494  36.756   5.453  1.00  0.00           H  
ATOM    634  HB3 PRO A  37      -7.613  37.559   7.022  1.00  0.00           H  
ATOM    635  HG2 PRO A  37      -9.706  37.062   4.996  1.00  0.00           H  
ATOM    636  HG3 PRO A  37      -9.858  37.251   6.748  1.00  0.00           H  
ATOM    637  HD2 PRO A  37     -10.367  39.206   4.747  1.00  0.00           H  
ATOM    638  HD3 PRO A  37     -10.374  39.436   6.506  1.00  0.00           H  
ATOM    639  N   ILE A  38      -5.786  38.626   3.593  1.00  0.00           N  
ATOM    640  CA  ILE A  38      -5.316  38.359   2.245  1.00  0.00           C  
ATOM    641  C   ILE A  38      -4.704  36.966   2.168  1.00  0.00           C  
ATOM    642  O   ILE A  38      -3.790  36.637   2.928  1.00  0.00           O  
ATOM    643  CB  ILE A  38      -4.270  39.412   1.808  1.00  0.00           C  
ATOM    644  CG1 ILE A  38      -4.933  40.783   1.636  1.00  0.00           C  
ATOM    645  CG2 ILE A  38      -3.568  38.992   0.523  1.00  0.00           C  
ATOM    646  CD1 ILE A  38      -5.712  40.932   0.351  1.00  0.00           C  
ATOM    647  H   ILE A  38      -5.127  38.776   4.308  1.00  0.00           H  
ATOM    648  HA  ILE A  38      -6.162  38.415   1.574  1.00  0.00           H  
ATOM    649  HB  ILE A  38      -3.523  39.482   2.584  1.00  0.00           H  
ATOM    650 HG12 ILE A  38      -5.615  40.952   2.454  1.00  0.00           H  
ATOM    651 HG13 ILE A  38      -4.177  41.541   1.647  1.00  0.00           H  
ATOM    652 HG21 ILE A  38      -2.855  39.750   0.237  1.00  0.00           H  
ATOM    653 HG22 ILE A  38      -4.298  38.871  -0.263  1.00  0.00           H  
ATOM    654 HG23 ILE A  38      -3.054  38.055   0.683  1.00  0.00           H  
ATOM    655 HD11 ILE A  38      -6.227  41.882   0.350  1.00  0.00           H  
ATOM    656 HD12 ILE A  38      -6.430  40.132   0.271  1.00  0.00           H  
ATOM    657 HD13 ILE A  38      -5.033  40.890  -0.488  1.00  0.00           H  
ATOM    658  N   LYS A  39      -5.211  36.140   1.264  1.00  0.00           N  
ATOM    659  CA  LYS A  39      -4.639  34.820   1.062  1.00  0.00           C  
ATOM    660  C   LYS A  39      -3.806  34.800  -0.215  1.00  0.00           C  
ATOM    661  O   LYS A  39      -4.311  34.475  -1.291  1.00  0.00           O  
ATOM    662  CB  LYS A  39      -5.727  33.741   1.012  1.00  0.00           C  
ATOM    663  CG  LYS A  39      -5.174  32.325   1.041  1.00  0.00           C  
ATOM    664  CD  LYS A  39      -6.287  31.289   1.065  1.00  0.00           C  
ATOM    665  CE  LYS A  39      -5.741  29.878   1.241  1.00  0.00           C  
ATOM    666  NZ  LYS A  39      -4.886  29.457   0.102  1.00  0.00           N  
ATOM    667  H   LYS A  39      -5.995  36.419   0.733  1.00  0.00           H  
ATOM    668  HA  LYS A  39      -3.986  34.619   1.898  1.00  0.00           H  
ATOM    669  HB2 LYS A  39      -6.384  33.868   1.860  1.00  0.00           H  
ATOM    670  HB3 LYS A  39      -6.300  33.862   0.103  1.00  0.00           H  
ATOM    671  HG2 LYS A  39      -4.572  32.169   0.159  1.00  0.00           H  
ATOM    672  HG3 LYS A  39      -4.561  32.205   1.923  1.00  0.00           H  
ATOM    673  HD2 LYS A  39      -6.953  31.510   1.887  1.00  0.00           H  
ATOM    674  HD3 LYS A  39      -6.830  31.344   0.133  1.00  0.00           H  
ATOM    675  HE2 LYS A  39      -5.155  29.841   2.146  1.00  0.00           H  
ATOM    676  HE3 LYS A  39      -6.573  29.193   1.325  1.00  0.00           H  
ATOM    677  HZ1 LYS A  39      -4.525  28.490   0.261  1.00  0.00           H  
ATOM    678  HZ2 LYS A  39      -4.073  30.102   0.002  1.00  0.00           H  
ATOM    679  HZ3 LYS A  39      -5.434  29.469  -0.787  1.00  0.00           H  
ATOM    680  N   ASP A  40      -2.549  35.230  -0.088  1.00  0.00           N  
ATOM    681  CA  ASP A  40      -1.574  35.195  -1.185  1.00  0.00           C  
ATOM    682  C   ASP A  40      -2.039  36.027  -2.385  1.00  0.00           C  
ATOM    683  O   ASP A  40      -1.609  35.810  -3.515  1.00  0.00           O  
ATOM    684  CB  ASP A  40      -1.314  33.743  -1.608  1.00  0.00           C  
ATOM    685  CG  ASP A  40      -0.027  33.577  -2.395  1.00  0.00           C  
ATOM    686  OD1 ASP A  40       1.058  33.774  -1.807  1.00  0.00           O  
ATOM    687  OD2 ASP A  40      -0.087  33.226  -3.593  1.00  0.00           O  
ATOM    688  H   ASP A  40      -2.263  35.582   0.781  1.00  0.00           H  
ATOM    689  HA  ASP A  40      -0.651  35.617  -0.815  1.00  0.00           H  
ATOM    690  HB2 ASP A  40      -1.253  33.126  -0.725  1.00  0.00           H  
ATOM    691  HB3 ASP A  40      -2.137  33.402  -2.222  1.00  0.00           H  
ATOM    692  N   GLY A  41      -2.899  37.000  -2.128  1.00  0.00           N  
ATOM    693  CA  GLY A  41      -3.410  37.837  -3.198  1.00  0.00           C  
ATOM    694  C   GLY A  41      -4.911  37.718  -3.353  1.00  0.00           C  
ATOM    695  O   GLY A  41      -5.509  38.376  -4.205  1.00  0.00           O  
ATOM    696  H   GLY A  41      -3.188  37.152  -1.207  1.00  0.00           H  
ATOM    697  HA2 GLY A  41      -3.160  38.865  -2.984  1.00  0.00           H  
ATOM    698  HA3 GLY A  41      -2.939  37.547  -4.125  1.00  0.00           H  
ATOM    699  N   ILE A  42      -5.512  36.862  -2.540  1.00  0.00           N  
ATOM    700  CA  ILE A  42      -6.961  36.676  -2.534  1.00  0.00           C  
ATOM    701  C   ILE A  42      -7.586  37.334  -1.302  1.00  0.00           C  
ATOM    702  O   ILE A  42      -7.638  36.733  -0.227  1.00  0.00           O  
ATOM    703  CB  ILE A  42      -7.355  35.180  -2.578  1.00  0.00           C  
ATOM    704  CG1 ILE A  42      -6.774  34.501  -3.825  1.00  0.00           C  
ATOM    705  CG2 ILE A  42      -8.874  35.022  -2.548  1.00  0.00           C  
ATOM    706  CD1 ILE A  42      -7.266  35.090  -5.133  1.00  0.00           C  
ATOM    707  H   ILE A  42      -4.964  36.319  -1.935  1.00  0.00           H  
ATOM    708  HA  ILE A  42      -7.356  37.156  -3.419  1.00  0.00           H  
ATOM    709  HB  ILE A  42      -6.952  34.704  -1.700  1.00  0.00           H  
ATOM    710 HG12 ILE A  42      -5.696  34.591  -3.809  1.00  0.00           H  
ATOM    711 HG13 ILE A  42      -7.042  33.453  -3.810  1.00  0.00           H  
ATOM    712 HG21 ILE A  42      -9.126  33.974  -2.603  1.00  0.00           H  
ATOM    713 HG22 ILE A  42      -9.308  35.541  -3.389  1.00  0.00           H  
ATOM    714 HG23 ILE A  42      -9.264  35.436  -1.629  1.00  0.00           H  
ATOM    715 HD11 ILE A  42      -6.990  36.133  -5.188  1.00  0.00           H  
ATOM    716 HD12 ILE A  42      -8.340  34.996  -5.188  1.00  0.00           H  
ATOM    717 HD13 ILE A  42      -6.818  34.556  -5.958  1.00  0.00           H  
ATOM    718  N   PRO A  43      -7.985  38.612  -1.413  1.00  0.00           N  
ATOM    719  CA  PRO A  43      -8.623  39.335  -0.310  1.00  0.00           C  
ATOM    720  C   PRO A  43      -9.976  38.726   0.060  1.00  0.00           C  
ATOM    721  O   PRO A  43     -10.833  38.529  -0.804  1.00  0.00           O  
ATOM    722  CB  PRO A  43      -8.820  40.748  -0.868  1.00  0.00           C  
ATOM    723  CG  PRO A  43      -8.802  40.586  -2.351  1.00  0.00           C  
ATOM    724  CD  PRO A  43      -7.874  39.441  -2.629  1.00  0.00           C  
ATOM    725  HA  PRO A  43      -7.981  39.373   0.565  1.00  0.00           H  
ATOM    726  HB2 PRO A  43      -9.766  41.142  -0.525  1.00  0.00           H  
ATOM    727  HB3 PRO A  43      -8.016  41.384  -0.530  1.00  0.00           H  
ATOM    728  HG2 PRO A  43      -9.794  40.358  -2.710  1.00  0.00           H  
ATOM    729  HG3 PRO A  43      -8.432  41.489  -2.816  1.00  0.00           H  
ATOM    730  HD2 PRO A  43      -8.200  38.892  -3.501  1.00  0.00           H  
ATOM    731  HD3 PRO A  43      -6.862  39.797  -2.761  1.00  0.00           H  
ATOM    732  N   TYR A  44     -10.172  38.426   1.333  1.00  0.00           N  
ATOM    733  CA  TYR A  44     -11.434  37.866   1.788  1.00  0.00           C  
ATOM    734  C   TYR A  44     -12.244  38.909   2.541  1.00  0.00           C  
ATOM    735  O   TYR A  44     -12.243  38.956   3.769  1.00  0.00           O  
ATOM    736  CB  TYR A  44     -11.216  36.629   2.664  1.00  0.00           C  
ATOM    737  CG  TYR A  44     -10.860  35.383   1.886  1.00  0.00           C  
ATOM    738  CD1 TYR A  44     -11.729  34.876   0.930  1.00  0.00           C  
ATOM    739  CD2 TYR A  44      -9.664  34.714   2.106  1.00  0.00           C  
ATOM    740  CE1 TYR A  44     -11.418  33.737   0.215  1.00  0.00           C  
ATOM    741  CE2 TYR A  44      -9.345  33.571   1.396  1.00  0.00           C  
ATOM    742  CZ  TYR A  44     -10.226  33.087   0.452  1.00  0.00           C  
ATOM    743  OH  TYR A  44      -9.919  31.947  -0.258  1.00  0.00           O  
ATOM    744  H   TYR A  44      -9.458  38.594   1.985  1.00  0.00           H  
ATOM    745  HA  TYR A  44     -11.989  37.574   0.910  1.00  0.00           H  
ATOM    746  HB2 TYR A  44     -10.411  36.825   3.355  1.00  0.00           H  
ATOM    747  HB3 TYR A  44     -12.120  36.428   3.221  1.00  0.00           H  
ATOM    748  HD1 TYR A  44     -12.662  35.388   0.745  1.00  0.00           H  
ATOM    749  HD2 TYR A  44      -8.978  35.095   2.848  1.00  0.00           H  
ATOM    750  HE1 TYR A  44     -12.108  33.360  -0.526  1.00  0.00           H  
ATOM    751  HE2 TYR A  44      -8.409  33.064   1.581  1.00  0.00           H  
ATOM    752  HH  TYR A  44      -9.766  31.217   0.359  1.00  0.00           H  
ATOM    753  N   MET A  45     -12.918  39.760   1.786  1.00  0.00           N  
ATOM    754  CA  MET A  45     -13.795  40.784   2.355  1.00  0.00           C  
ATOM    755  C   MET A  45     -15.169  40.195   2.674  1.00  0.00           C  
ATOM    756  O   MET A  45     -16.191  40.874   2.576  1.00  0.00           O  
ATOM    757  CB  MET A  45     -13.944  41.964   1.384  1.00  0.00           C  
ATOM    758  CG  MET A  45     -14.581  41.597   0.049  1.00  0.00           C  
ATOM    759  SD  MET A  45     -13.481  40.660  -1.027  1.00  0.00           S  
ATOM    760  CE  MET A  45     -12.254  41.905  -1.428  1.00  0.00           C  
ATOM    761  H   MET A  45     -12.814  39.708   0.811  1.00  0.00           H  
ATOM    762  HA  MET A  45     -13.344  41.134   3.271  1.00  0.00           H  
ATOM    763  HB2 MET A  45     -14.555  42.722   1.849  1.00  0.00           H  
ATOM    764  HB3 MET A  45     -12.966  42.375   1.190  1.00  0.00           H  
ATOM    765  HG2 MET A  45     -15.459  41.000   0.242  1.00  0.00           H  
ATOM    766  HG3 MET A  45     -14.867  42.508  -0.458  1.00  0.00           H  
ATOM    767  HE1 MET A  45     -12.739  42.741  -1.908  1.00  0.00           H  
ATOM    768  HE2 MET A  45     -11.511  41.487  -2.095  1.00  0.00           H  
ATOM    769  HE3 MET A  45     -11.775  42.244  -0.522  1.00  0.00           H  
ATOM    770  N   LEU A  46     -15.178  38.937   3.077  1.00  0.00           N  
ATOM    771  CA  LEU A  46     -16.409  38.216   3.334  1.00  0.00           C  
ATOM    772  C   LEU A  46     -16.824  38.368   4.791  1.00  0.00           C  
ATOM    773  O   LEU A  46     -15.975  38.463   5.672  1.00  0.00           O  
ATOM    774  CB  LEU A  46     -16.217  36.746   2.979  1.00  0.00           C  
ATOM    775  CG  LEU A  46     -15.779  36.489   1.538  1.00  0.00           C  
ATOM    776  CD1 LEU A  46     -15.658  35.002   1.272  1.00  0.00           C  
ATOM    777  CD2 LEU A  46     -16.754  37.129   0.566  1.00  0.00           C  
ATOM    778  H   LEU A  46     -14.325  38.480   3.225  1.00  0.00           H  
ATOM    779  HA  LEU A  46     -17.179  38.634   2.704  1.00  0.00           H  
ATOM    780  HB2 LEU A  46     -15.471  36.328   3.641  1.00  0.00           H  
ATOM    781  HB3 LEU A  46     -17.148  36.234   3.145  1.00  0.00           H  
ATOM    782  HG  LEU A  46     -14.807  36.935   1.380  1.00  0.00           H  
ATOM    783 HD11 LEU A  46     -15.346  34.843   0.253  1.00  0.00           H  
ATOM    784 HD12 LEU A  46     -16.615  34.529   1.436  1.00  0.00           H  
ATOM    785 HD13 LEU A  46     -14.928  34.578   1.945  1.00  0.00           H  
ATOM    786 HD21 LEU A  46     -16.442  36.919  -0.447  1.00  0.00           H  
ATOM    787 HD22 LEU A  46     -16.769  38.197   0.724  1.00  0.00           H  
ATOM    788 HD23 LEU A  46     -17.742  36.726   0.730  1.00  0.00           H  
ATOM    789  N   GLU A  47     -18.132  38.375   5.030  1.00  0.00           N  
ATOM    790  CA  GLU A  47     -18.693  38.618   6.361  1.00  0.00           C  
ATOM    791  C   GLU A  47     -18.071  37.718   7.424  1.00  0.00           C  
ATOM    792  O   GLU A  47     -17.755  38.164   8.525  1.00  0.00           O  
ATOM    793  CB  GLU A  47     -20.204  38.386   6.346  1.00  0.00           C  
ATOM    794  CG  GLU A  47     -20.934  39.105   5.227  1.00  0.00           C  
ATOM    795  CD  GLU A  47     -20.604  40.580   5.152  1.00  0.00           C  
ATOM    796  OE1 GLU A  47     -20.965  41.325   6.088  1.00  0.00           O  
ATOM    797  OE2 GLU A  47     -20.002  41.000   4.149  1.00  0.00           O  
ATOM    798  H   GLU A  47     -18.746  38.225   4.281  1.00  0.00           H  
ATOM    799  HA  GLU A  47     -18.501  39.647   6.621  1.00  0.00           H  
ATOM    800  HB2 GLU A  47     -20.390  37.326   6.239  1.00  0.00           H  
ATOM    801  HB3 GLU A  47     -20.614  38.716   7.285  1.00  0.00           H  
ATOM    802  HG2 GLU A  47     -20.660  38.646   4.292  1.00  0.00           H  
ATOM    803  HG3 GLU A  47     -21.997  38.996   5.382  1.00  0.00           H  
ATOM    804  N   ASN A  48     -17.905  36.451   7.083  1.00  0.00           N  
ATOM    805  CA  ASN A  48     -17.445  35.450   8.037  1.00  0.00           C  
ATOM    806  C   ASN A  48     -15.963  35.604   8.359  1.00  0.00           C  
ATOM    807  O   ASN A  48     -15.524  35.329   9.477  1.00  0.00           O  
ATOM    808  CB  ASN A  48     -17.714  34.052   7.476  1.00  0.00           C  
ATOM    809  CG  ASN A  48     -17.374  32.941   8.449  1.00  0.00           C  
ATOM    810  OD1 ASN A  48     -16.254  32.426   8.458  1.00  0.00           O  
ATOM    811  ND2 ASN A  48     -18.346  32.550   9.257  1.00  0.00           N  
ATOM    812  H   ASN A  48     -18.106  36.175   6.163  1.00  0.00           H  
ATOM    813  HA  ASN A  48     -18.009  35.577   8.941  1.00  0.00           H  
ATOM    814  HB2 ASN A  48     -18.758  33.967   7.221  1.00  0.00           H  
ATOM    815  HB3 ASN A  48     -17.120  33.915   6.586  1.00  0.00           H  
ATOM    816 HD21 ASN A  48     -19.220  32.999   9.181  1.00  0.00           H  
ATOM    817 HD22 ASN A  48     -18.160  31.827   9.895  1.00  0.00           H  
ATOM    818  N   GLU A  49     -15.198  36.061   7.386  1.00  0.00           N  
ATOM    819  CA  GLU A  49     -13.747  36.089   7.512  1.00  0.00           C  
ATOM    820  C   GLU A  49     -13.224  37.484   7.841  1.00  0.00           C  
ATOM    821  O   GLU A  49     -12.087  37.639   8.291  1.00  0.00           O  
ATOM    822  CB  GLU A  49     -13.120  35.556   6.227  1.00  0.00           C  
ATOM    823  CG  GLU A  49     -13.517  34.119   5.948  1.00  0.00           C  
ATOM    824  CD  GLU A  49     -12.988  33.600   4.632  1.00  0.00           C  
ATOM    825  OE1 GLU A  49     -11.825  33.136   4.594  1.00  0.00           O  
ATOM    826  OE2 GLU A  49     -13.743  33.635   3.636  1.00  0.00           O  
ATOM    827  H   GLU A  49     -15.615  36.390   6.568  1.00  0.00           H  
ATOM    828  HA  GLU A  49     -13.481  35.428   8.324  1.00  0.00           H  
ATOM    829  HB2 GLU A  49     -13.441  36.166   5.396  1.00  0.00           H  
ATOM    830  HB3 GLU A  49     -12.047  35.603   6.310  1.00  0.00           H  
ATOM    831  HG2 GLU A  49     -13.137  33.495   6.741  1.00  0.00           H  
ATOM    832  HG3 GLU A  49     -14.595  34.060   5.933  1.00  0.00           H  
ATOM    833  N   ALA A  50     -14.053  38.496   7.625  1.00  0.00           N  
ATOM    834  CA  ALA A  50     -13.687  39.864   7.960  1.00  0.00           C  
ATOM    835  C   ALA A  50     -13.872  40.111   9.451  1.00  0.00           C  
ATOM    836  O   ALA A  50     -14.944  39.869  10.004  1.00  0.00           O  
ATOM    837  CB  ALA A  50     -14.509  40.850   7.147  1.00  0.00           C  
ATOM    838  H   ALA A  50     -14.933  38.320   7.229  1.00  0.00           H  
ATOM    839  HA  ALA A  50     -12.646  40.004   7.709  1.00  0.00           H  
ATOM    840  HB1 ALA A  50     -14.208  41.858   7.393  1.00  0.00           H  
ATOM    841  HB2 ALA A  50     -15.557  40.722   7.378  1.00  0.00           H  
ATOM    842  HB3 ALA A  50     -14.349  40.672   6.094  1.00  0.00           H  
ATOM    843  N   ARG A  51     -12.822  40.594  10.096  1.00  0.00           N  
ATOM    844  CA  ARG A  51     -12.837  40.812  11.529  1.00  0.00           C  
ATOM    845  C   ARG A  51     -12.772  42.297  11.839  1.00  0.00           C  
ATOM    846  O   ARG A  51     -12.191  43.063  11.077  1.00  0.00           O  
ATOM    847  CB  ARG A  51     -11.674  40.074  12.217  1.00  0.00           C  
ATOM    848  CG  ARG A  51     -10.317  40.176  11.519  1.00  0.00           C  
ATOM    849  CD  ARG A  51     -10.243  39.259  10.307  1.00  0.00           C  
ATOM    850  NE  ARG A  51      -8.873  38.954   9.903  1.00  0.00           N  
ATOM    851  CZ  ARG A  51      -8.451  37.716   9.657  1.00  0.00           C  
ATOM    852  NH1 ARG A  51      -9.296  36.695   9.770  1.00  0.00           N  
ATOM    853  NH2 ARG A  51      -7.205  37.502   9.267  1.00  0.00           N  
ATOM    854  H   ARG A  51     -12.015  40.824   9.594  1.00  0.00           H  
ATOM    855  HA  ARG A  51     -13.768  40.423  11.909  1.00  0.00           H  
ATOM    856  HB2 ARG A  51     -11.560  40.479  13.205  1.00  0.00           H  
ATOM    857  HB3 ARG A  51     -11.932  39.029  12.298  1.00  0.00           H  
ATOM    858  HG2 ARG A  51     -10.163  41.195  11.196  1.00  0.00           H  
ATOM    859  HG3 ARG A  51      -9.542  39.897  12.218  1.00  0.00           H  
ATOM    860  HD2 ARG A  51     -10.748  38.334  10.545  1.00  0.00           H  
ATOM    861  HD3 ARG A  51     -10.751  39.738   9.481  1.00  0.00           H  
ATOM    862  HE  ARG A  51      -8.239  39.709   9.806  1.00  0.00           H  
ATOM    863 HH11 ARG A  51     -10.248  36.856  10.038  1.00  0.00           H  
ATOM    864 HH12 ARG A  51      -8.986  35.754   9.586  1.00  0.00           H  
ATOM    865 HH21 ARG A  51      -6.570  38.283   9.141  1.00  0.00           H  
ATOM    866 HH22 ARG A  51      -6.877  36.565   9.107  1.00  0.00           H  
ATOM    867  N   PRO A  52     -13.396  42.729  12.941  1.00  0.00           N  
ATOM    868  CA  PRO A  52     -13.348  44.125  13.368  1.00  0.00           C  
ATOM    869  C   PRO A  52     -12.015  44.490  14.006  1.00  0.00           C  
ATOM    870  O   PRO A  52     -11.270  43.616  14.457  1.00  0.00           O  
ATOM    871  CB  PRO A  52     -14.473  44.221  14.395  1.00  0.00           C  
ATOM    872  CG  PRO A  52     -14.605  42.843  14.951  1.00  0.00           C  
ATOM    873  CD  PRO A  52     -14.210  41.896  13.848  1.00  0.00           C  
ATOM    874  HA  PRO A  52     -13.549  44.797  12.546  1.00  0.00           H  
ATOM    875  HB2 PRO A  52     -14.198  44.933  15.162  1.00  0.00           H  
ATOM    876  HB3 PRO A  52     -15.378  44.540  13.907  1.00  0.00           H  
ATOM    877  HG2 PRO A  52     -13.946  42.725  15.798  1.00  0.00           H  
ATOM    878  HG3 PRO A  52     -15.629  42.666  15.245  1.00  0.00           H  
ATOM    879  HD2 PRO A  52     -13.628  41.078  14.245  1.00  0.00           H  
ATOM    880  HD3 PRO A  52     -15.088  41.521  13.342  1.00  0.00           H  
ATOM    881  N   LEU A  53     -11.723  45.778  14.040  1.00  0.00           N  
ATOM    882  CA  LEU A  53     -10.516  46.272  14.658  1.00  0.00           C  
ATOM    883  C   LEU A  53     -10.818  46.796  16.043  1.00  0.00           C  
ATOM    884  O   LEU A  53     -11.947  47.192  16.338  1.00  0.00           O  
ATOM    885  CB  LEU A  53      -9.899  47.389  13.822  1.00  0.00           C  
ATOM    886  CG  LEU A  53      -9.166  46.937  12.567  1.00  0.00           C  
ATOM    887  CD1 LEU A  53      -8.675  48.135  11.768  1.00  0.00           C  
ATOM    888  CD2 LEU A  53      -8.003  46.025  12.923  1.00  0.00           C  
ATOM    889  H   LEU A  53     -12.348  46.423  13.654  1.00  0.00           H  
ATOM    890  HA  LEU A  53      -9.817  45.454  14.734  1.00  0.00           H  
ATOM    891  HB2 LEU A  53     -10.689  48.064  13.525  1.00  0.00           H  
ATOM    892  HB3 LEU A  53      -9.210  47.928  14.445  1.00  0.00           H  
ATOM    893  HG  LEU A  53      -9.848  46.382  11.954  1.00  0.00           H  
ATOM    894 HD11 LEU A  53      -7.991  48.714  12.372  1.00  0.00           H  
ATOM    895 HD12 LEU A  53      -9.518  48.751  11.487  1.00  0.00           H  
ATOM    896 HD13 LEU A  53      -8.169  47.789  10.879  1.00  0.00           H  
ATOM    897 HD21 LEU A  53      -7.294  46.565  13.532  1.00  0.00           H  
ATOM    898 HD22 LEU A  53      -7.517  45.690  12.018  1.00  0.00           H  
ATOM    899 HD23 LEU A  53      -8.372  45.170  13.471  1.00  0.00           H  
ATOM    900  N   SER A  54      -9.811  46.801  16.885  1.00  0.00           N  
ATOM    901  CA  SER A  54      -9.956  47.362  18.210  1.00  0.00           C  
ATOM    902  C   SER A  54      -9.698  48.859  18.168  1.00  0.00           C  
ATOM    903  O   SER A  54      -9.163  49.376  17.186  1.00  0.00           O  
ATOM    904  CB  SER A  54      -9.015  46.686  19.209  1.00  0.00           C  
ATOM    905  OG  SER A  54      -7.683  46.630  18.721  1.00  0.00           O  
ATOM    906  H   SER A  54      -8.944  46.426  16.599  1.00  0.00           H  
ATOM    907  HA  SER A  54     -10.976  47.196  18.519  1.00  0.00           H  
ATOM    908  HB2 SER A  54      -9.017  47.246  20.132  1.00  0.00           H  
ATOM    909  HB3 SER A  54      -9.360  45.685  19.400  1.00  0.00           H  
ATOM    910  HG  SER A  54      -7.676  46.189  17.851  1.00  0.00           H  
ATOM    911  N   GLU A  55     -10.066  49.541  19.237  1.00  0.00           N  
ATOM    912  CA  GLU A  55      -9.922  50.975  19.328  1.00  0.00           C  
ATOM    913  C   GLU A  55      -8.471  51.388  19.164  1.00  0.00           C  
ATOM    914  O   GLU A  55      -8.175  52.361  18.480  1.00  0.00           O  
ATOM    915  CB  GLU A  55     -10.458  51.452  20.666  1.00  0.00           C  
ATOM    916  CG  GLU A  55     -11.958  51.689  20.670  1.00  0.00           C  
ATOM    917  CD  GLU A  55     -12.429  52.440  21.895  1.00  0.00           C  
ATOM    918  OE1 GLU A  55     -12.613  51.812  22.957  1.00  0.00           O  
ATOM    919  OE2 GLU A  55     -12.628  53.668  21.801  1.00  0.00           O  
ATOM    920  H   GLU A  55     -10.435  49.062  20.006  1.00  0.00           H  
ATOM    921  HA  GLU A  55     -10.506  51.420  18.537  1.00  0.00           H  
ATOM    922  HB2 GLU A  55     -10.232  50.705  21.413  1.00  0.00           H  
ATOM    923  HB3 GLU A  55      -9.962  52.356  20.926  1.00  0.00           H  
ATOM    924  HG2 GLU A  55     -12.221  52.262  19.796  1.00  0.00           H  
ATOM    925  HG3 GLU A  55     -12.460  50.732  20.637  1.00  0.00           H  
ATOM    926  N   GLU A  56      -7.582  50.650  19.812  1.00  0.00           N  
ATOM    927  CA  GLU A  56      -6.155  50.845  19.677  1.00  0.00           C  
ATOM    928  C   GLU A  56      -5.747  50.872  18.210  1.00  0.00           C  
ATOM    929  O   GLU A  56      -5.122  51.822  17.742  1.00  0.00           O  
ATOM    930  CB  GLU A  56      -5.437  49.703  20.382  1.00  0.00           C  
ATOM    931  CG  GLU A  56      -3.962  49.942  20.556  1.00  0.00           C  
ATOM    932  CD  GLU A  56      -3.142  48.672  20.433  1.00  0.00           C  
ATOM    933  OE1 GLU A  56      -3.628  47.593  20.837  1.00  0.00           O  
ATOM    934  OE2 GLU A  56      -2.005  48.746  19.921  1.00  0.00           O  
ATOM    935  H   GLU A  56      -7.897  49.960  20.427  1.00  0.00           H  
ATOM    936  HA  GLU A  56      -5.890  51.781  20.136  1.00  0.00           H  
ATOM    937  HB2 GLU A  56      -5.878  49.564  21.358  1.00  0.00           H  
ATOM    938  HB3 GLU A  56      -5.568  48.800  19.807  1.00  0.00           H  
ATOM    939  HG2 GLU A  56      -3.643  50.637  19.801  1.00  0.00           H  
ATOM    940  HG3 GLU A  56      -3.799  50.370  21.533  1.00  0.00           H  
ATOM    941  N   GLU A  57      -6.112  49.815  17.504  1.00  0.00           N  
ATOM    942  CA  GLU A  57      -5.826  49.679  16.088  1.00  0.00           C  
ATOM    943  C   GLU A  57      -6.442  50.814  15.280  1.00  0.00           C  
ATOM    944  O   GLU A  57      -5.776  51.430  14.454  1.00  0.00           O  
ATOM    945  CB  GLU A  57      -6.355  48.334  15.628  1.00  0.00           C  
ATOM    946  CG  GLU A  57      -5.642  47.178  16.306  1.00  0.00           C  
ATOM    947  CD  GLU A  57      -6.245  45.830  15.991  1.00  0.00           C  
ATOM    948  OE1 GLU A  57      -7.436  45.627  16.302  1.00  0.00           O  
ATOM    949  OE2 GLU A  57      -5.522  44.952  15.477  1.00  0.00           O  
ATOM    950  H   GLU A  57      -6.589  49.088  17.954  1.00  0.00           H  
ATOM    951  HA  GLU A  57      -4.758  49.697  15.959  1.00  0.00           H  
ATOM    952  HB2 GLU A  57      -7.407  48.272  15.865  1.00  0.00           H  
ATOM    953  HB3 GLU A  57      -6.231  48.249  14.569  1.00  0.00           H  
ATOM    954  HG2 GLU A  57      -4.614  47.177  15.992  1.00  0.00           H  
ATOM    955  HG3 GLU A  57      -5.685  47.330  17.375  1.00  0.00           H  
ATOM    956  N   LEU A  58      -7.718  51.062  15.523  1.00  0.00           N  
ATOM    957  CA  LEU A  58      -8.424  52.196  14.931  1.00  0.00           C  
ATOM    958  C   LEU A  58      -7.677  53.513  15.150  1.00  0.00           C  
ATOM    959  O   LEU A  58      -7.530  54.315  14.226  1.00  0.00           O  
ATOM    960  CB  LEU A  58      -9.819  52.307  15.530  1.00  0.00           C  
ATOM    961  CG  LEU A  58     -10.735  51.120  15.259  1.00  0.00           C  
ATOM    962  CD1 LEU A  58     -12.061  51.295  15.983  1.00  0.00           C  
ATOM    963  CD2 LEU A  58     -10.961  50.947  13.764  1.00  0.00           C  
ATOM    964  H   LEU A  58      -8.218  50.435  16.097  1.00  0.00           H  
ATOM    965  HA  LEU A  58      -8.512  52.018  13.875  1.00  0.00           H  
ATOM    966  HB2 LEU A  58      -9.719  52.420  16.597  1.00  0.00           H  
ATOM    967  HB3 LEU A  58     -10.284  53.191  15.137  1.00  0.00           H  
ATOM    968  HG  LEU A  58     -10.262  50.225  15.635  1.00  0.00           H  
ATOM    969 HD11 LEU A  58     -12.539  52.202  15.643  1.00  0.00           H  
ATOM    970 HD12 LEU A  58     -11.884  51.357  17.046  1.00  0.00           H  
ATOM    971 HD13 LEU A  58     -12.699  50.449  15.774  1.00  0.00           H  
ATOM    972 HD21 LEU A  58     -11.630  50.116  13.595  1.00  0.00           H  
ATOM    973 HD22 LEU A  58     -10.016  50.753  13.276  1.00  0.00           H  
ATOM    974 HD23 LEU A  58     -11.397  51.848  13.358  1.00  0.00           H  
ATOM    975  N   LYS A  59      -7.221  53.733  16.376  1.00  0.00           N  
ATOM    976  CA  LYS A  59      -6.505  54.937  16.732  1.00  0.00           C  
ATOM    977  C   LYS A  59      -5.137  54.995  16.066  1.00  0.00           C  
ATOM    978  O   LYS A  59      -4.590  56.073  15.842  1.00  0.00           O  
ATOM    979  CB  LYS A  59      -6.360  54.995  18.247  1.00  0.00           C  
ATOM    980  CG  LYS A  59      -7.587  55.542  18.960  1.00  0.00           C  
ATOM    981  CD  LYS A  59      -7.418  55.534  20.472  1.00  0.00           C  
ATOM    982  CE  LYS A  59      -7.243  54.123  21.006  1.00  0.00           C  
ATOM    983  NZ  LYS A  59      -7.247  54.081  22.490  1.00  0.00           N  
ATOM    984  H   LYS A  59      -7.375  53.063  17.077  1.00  0.00           H  
ATOM    985  HA  LYS A  59      -7.087  55.776  16.402  1.00  0.00           H  
ATOM    986  HB2 LYS A  59      -6.177  53.995  18.613  1.00  0.00           H  
ATOM    987  HB3 LYS A  59      -5.523  55.604  18.484  1.00  0.00           H  
ATOM    988  HG2 LYS A  59      -7.756  56.557  18.634  1.00  0.00           H  
ATOM    989  HG3 LYS A  59      -8.441  54.934  18.700  1.00  0.00           H  
ATOM    990  HD2 LYS A  59      -6.548  56.117  20.732  1.00  0.00           H  
ATOM    991  HD3 LYS A  59      -8.297  55.974  20.924  1.00  0.00           H  
ATOM    992  HE2 LYS A  59      -8.051  53.510  20.637  1.00  0.00           H  
ATOM    993  HE3 LYS A  59      -6.302  53.732  20.646  1.00  0.00           H  
ATOM    994  HZ1 LYS A  59      -6.433  54.610  22.871  1.00  0.00           H  
ATOM    995  HZ2 LYS A  59      -7.190  53.094  22.820  1.00  0.00           H  
ATOM    996  HZ3 LYS A  59      -8.129  54.505  22.858  1.00  0.00           H  
ATOM    997  N   ALA A  60      -4.602  53.833  15.737  1.00  0.00           N  
ATOM    998  CA  ALA A  60      -3.296  53.747  15.088  1.00  0.00           C  
ATOM    999  C   ALA A  60      -3.421  53.914  13.580  1.00  0.00           C  
ATOM   1000  O   ALA A  60      -2.487  53.646  12.823  1.00  0.00           O  
ATOM   1001  CB  ALA A  60      -2.615  52.431  15.428  1.00  0.00           C  
ATOM   1002  H   ALA A  60      -5.093  53.010  15.941  1.00  0.00           H  
ATOM   1003  HA  ALA A  60      -2.694  54.549  15.468  1.00  0.00           H  
ATOM   1004  HB1 ALA A  60      -3.191  51.610  15.026  1.00  0.00           H  
ATOM   1005  HB2 ALA A  60      -2.546  52.332  16.501  1.00  0.00           H  
ATOM   1006  HB3 ALA A  60      -1.621  52.418  15.002  1.00  0.00           H  
ATOM   1007  N   LEU A  61      -4.572  54.396  13.163  1.00  0.00           N  
ATOM   1008  CA  LEU A  61      -4.846  54.641  11.755  1.00  0.00           C  
ATOM   1009  C   LEU A  61      -4.939  56.135  11.497  1.00  0.00           C  
ATOM   1010  O   LEU A  61      -5.514  56.587  10.504  1.00  0.00           O  
ATOM   1011  CB  LEU A  61      -6.135  53.932  11.334  1.00  0.00           C  
ATOM   1012  CG  LEU A  61      -6.057  52.401  11.347  1.00  0.00           C  
ATOM   1013  CD1 LEU A  61      -7.427  51.782  11.117  1.00  0.00           C  
ATOM   1014  CD2 LEU A  61      -5.078  51.914  10.290  1.00  0.00           C  
ATOM   1015  H   LEU A  61      -5.259  54.599  13.828  1.00  0.00           H  
ATOM   1016  HA  LEU A  61      -4.021  54.246  11.189  1.00  0.00           H  
ATOM   1017  HB2 LEU A  61      -6.925  54.240  12.004  1.00  0.00           H  
ATOM   1018  HB3 LEU A  61      -6.384  54.253  10.336  1.00  0.00           H  
ATOM   1019  HG  LEU A  61      -5.701  52.072  12.310  1.00  0.00           H  
ATOM   1020 HD11 LEU A  61      -8.115  52.136  11.871  1.00  0.00           H  
ATOM   1021 HD12 LEU A  61      -7.351  50.705  11.179  1.00  0.00           H  
ATOM   1022 HD13 LEU A  61      -7.791  52.060  10.138  1.00  0.00           H  
ATOM   1023 HD21 LEU A  61      -4.104  52.343  10.477  1.00  0.00           H  
ATOM   1024 HD22 LEU A  61      -5.423  52.216   9.312  1.00  0.00           H  
ATOM   1025 HD23 LEU A  61      -5.011  50.836  10.333  1.00  0.00           H  
ATOM   1026  N   GLU A  62      -4.349  56.892  12.407  1.00  0.00           N  
ATOM   1027  CA  GLU A  62      -4.258  58.341  12.288  1.00  0.00           C  
ATOM   1028  C   GLU A  62      -3.288  58.714  11.169  1.00  0.00           C  
ATOM   1029  O   GLU A  62      -3.350  59.807  10.598  1.00  0.00           O  
ATOM   1030  CB  GLU A  62      -3.783  58.934  13.618  1.00  0.00           C  
ATOM   1031  CG  GLU A  62      -3.627  60.447  13.604  1.00  0.00           C  
ATOM   1032  CD  GLU A  62      -3.043  60.990  14.890  1.00  0.00           C  
ATOM   1033  OE1 GLU A  62      -1.824  60.833  15.110  1.00  0.00           O  
ATOM   1034  OE2 GLU A  62      -3.799  61.577  15.688  1.00  0.00           O  
ATOM   1035  H   GLU A  62      -3.966  56.454  13.194  1.00  0.00           H  
ATOM   1036  HA  GLU A  62      -5.239  58.727  12.053  1.00  0.00           H  
ATOM   1037  HB2 GLU A  62      -4.496  58.676  14.387  1.00  0.00           H  
ATOM   1038  HB3 GLU A  62      -2.827  58.497  13.869  1.00  0.00           H  
ATOM   1039  HG2 GLU A  62      -2.976  60.720  12.787  1.00  0.00           H  
ATOM   1040  HG3 GLU A  62      -4.599  60.891  13.452  1.00  0.00           H  
ATOM   1041  N   HIS A  63      -2.394  57.787  10.864  1.00  0.00           N  
ATOM   1042  CA  HIS A  63      -1.385  57.988   9.837  1.00  0.00           C  
ATOM   1043  C   HIS A  63      -0.997  56.650   9.235  1.00  0.00           C  
ATOM   1044  O   HIS A  63      -1.435  55.606   9.716  1.00  0.00           O  
ATOM   1045  CB  HIS A  63      -0.147  58.691  10.412  1.00  0.00           C  
ATOM   1046  CG  HIS A  63       0.526  57.954  11.538  1.00  0.00           C  
ATOM   1047  ND1 HIS A  63       1.477  56.972  11.344  1.00  0.00           N  
ATOM   1048  CD2 HIS A  63       0.386  58.072  12.882  1.00  0.00           C  
ATOM   1049  CE1 HIS A  63       1.888  56.520  12.514  1.00  0.00           C  
ATOM   1050  NE2 HIS A  63       1.242  57.169  13.464  1.00  0.00           N  
ATOM   1051  H   HIS A  63      -2.428  56.923  11.332  1.00  0.00           H  
ATOM   1052  HA  HIS A  63      -1.817  58.607   9.063  1.00  0.00           H  
ATOM   1053  HB2 HIS A  63       0.582  58.818   9.626  1.00  0.00           H  
ATOM   1054  HB3 HIS A  63      -0.439  59.664  10.781  1.00  0.00           H  
ATOM   1055  HD1 HIS A  63       1.808  56.653  10.470  1.00  0.00           H  
ATOM   1056  HD2 HIS A  63      -0.276  58.753  13.400  1.00  0.00           H  
ATOM   1057  HE1 HIS A  63       2.629  55.751  12.668  1.00  0.00           H  
ATOM   1058  HE2 HIS A  63       1.501  57.169  14.423  1.00  0.00           H  
ATOM   1059  N   HIS A  64      -0.179  56.685   8.189  1.00  0.00           N  
ATOM   1060  CA  HIS A  64       0.312  55.463   7.561  1.00  0.00           C  
ATOM   1061  C   HIS A  64       1.117  54.650   8.564  1.00  0.00           C  
ATOM   1062  O   HIS A  64       1.973  55.194   9.266  1.00  0.00           O  
ATOM   1063  CB  HIS A  64       1.182  55.782   6.340  1.00  0.00           C  
ATOM   1064  CG  HIS A  64       0.451  56.472   5.229  1.00  0.00           C  
ATOM   1065  ND1 HIS A  64      -0.626  55.917   4.578  1.00  0.00           N  
ATOM   1066  CD2 HIS A  64       0.657  57.679   4.651  1.00  0.00           C  
ATOM   1067  CE1 HIS A  64      -1.055  56.751   3.650  1.00  0.00           C  
ATOM   1068  NE2 HIS A  64      -0.293  57.830   3.674  1.00  0.00           N  
ATOM   1069  H   HIS A  64       0.098  57.553   7.829  1.00  0.00           H  
ATOM   1070  HA  HIS A  64      -0.542  54.884   7.247  1.00  0.00           H  
ATOM   1071  HB2 HIS A  64       1.995  56.424   6.646  1.00  0.00           H  
ATOM   1072  HB3 HIS A  64       1.588  54.860   5.948  1.00  0.00           H  
ATOM   1073  HD1 HIS A  64      -1.033  55.027   4.778  1.00  0.00           H  
ATOM   1074  HD2 HIS A  64       1.427  58.391   4.913  1.00  0.00           H  
ATOM   1075  HE1 HIS A  64      -1.886  56.579   2.982  1.00  0.00           H  
ATOM   1076  HE2 HIS A  64      -0.284  58.533   2.977  1.00  0.00           H  
ATOM   1077  N   HIS A  65       0.845  53.361   8.632  1.00  0.00           N  
ATOM   1078  CA  HIS A  65       1.520  52.493   9.586  1.00  0.00           C  
ATOM   1079  C   HIS A  65       2.475  51.547   8.865  1.00  0.00           C  
ATOM   1080  O   HIS A  65       2.062  50.736   8.034  1.00  0.00           O  
ATOM   1081  CB  HIS A  65       0.510  51.704  10.443  1.00  0.00           C  
ATOM   1082  CG  HIS A  65      -0.499  50.919   9.662  1.00  0.00           C  
ATOM   1083  ND1 HIS A  65      -0.264  49.647   9.192  1.00  0.00           N  
ATOM   1084  CD2 HIS A  65      -1.749  51.241   9.264  1.00  0.00           C  
ATOM   1085  CE1 HIS A  65      -1.327  49.221   8.536  1.00  0.00           C  
ATOM   1086  NE2 HIS A  65      -2.246  50.169   8.563  1.00  0.00           N  
ATOM   1087  H   HIS A  65       0.185  52.972   8.001  1.00  0.00           H  
ATOM   1088  HA  HIS A  65       2.103  53.127  10.238  1.00  0.00           H  
ATOM   1089  HB2 HIS A  65       1.051  51.007  11.065  1.00  0.00           H  
ATOM   1090  HB3 HIS A  65      -0.025  52.396  11.076  1.00  0.00           H  
ATOM   1091  HD1 HIS A  65       0.570  49.140   9.308  1.00  0.00           H  
ATOM   1092  HD2 HIS A  65      -2.265  52.168   9.466  1.00  0.00           H  
ATOM   1093  HE1 HIS A  65      -1.428  48.259   8.057  1.00  0.00           H  
ATOM   1094  HE2 HIS A  65      -3.002  50.219   7.943  1.00  0.00           H  
ATOM   1095  N   HIS A  66       3.759  51.686   9.176  1.00  0.00           N  
ATOM   1096  CA  HIS A  66       4.813  50.862   8.583  1.00  0.00           C  
ATOM   1097  C   HIS A  66       4.911  51.111   7.077  1.00  0.00           C  
ATOM   1098  O   HIS A  66       5.355  50.253   6.316  1.00  0.00           O  
ATOM   1099  CB  HIS A  66       4.572  49.374   8.884  1.00  0.00           C  
ATOM   1100  CG  HIS A  66       5.770  48.502   8.656  1.00  0.00           C  
ATOM   1101  ND1 HIS A  66       6.859  48.485   9.500  1.00  0.00           N  
ATOM   1102  CD2 HIS A  66       6.048  47.618   7.670  1.00  0.00           C  
ATOM   1103  CE1 HIS A  66       7.750  47.624   9.048  1.00  0.00           C  
ATOM   1104  NE2 HIS A  66       7.282  47.086   7.940  1.00  0.00           N  
ATOM   1105  H   HIS A  66       4.013  52.371   9.830  1.00  0.00           H  
ATOM   1106  HA  HIS A  66       5.747  51.158   9.036  1.00  0.00           H  
ATOM   1107  HB2 HIS A  66       4.280  49.266   9.918  1.00  0.00           H  
ATOM   1108  HB3 HIS A  66       3.773  49.011   8.252  1.00  0.00           H  
ATOM   1109  HD1 HIS A  66       6.958  49.018  10.325  1.00  0.00           H  
ATOM   1110  HD2 HIS A  66       5.417  47.379   6.827  1.00  0.00           H  
ATOM   1111  HE1 HIS A  66       8.704  47.403   9.503  1.00  0.00           H  
ATOM   1112  HE2 HIS A  66       7.799  46.497   7.334  1.00  0.00           H  
ATOM   1113  N   HIS A  67       4.519  52.307   6.653  1.00  0.00           N  
ATOM   1114  CA  HIS A  67       4.640  52.686   5.249  1.00  0.00           C  
ATOM   1115  C   HIS A  67       6.055  53.193   4.995  1.00  0.00           C  
ATOM   1116  O   HIS A  67       6.533  53.223   3.861  1.00  0.00           O  
ATOM   1117  CB  HIS A  67       3.609  53.761   4.885  1.00  0.00           C  
ATOM   1118  CG  HIS A  67       3.304  53.844   3.414  1.00  0.00           C  
ATOM   1119  ND1 HIS A  67       3.901  54.749   2.561  1.00  0.00           N  
ATOM   1120  CD2 HIS A  67       2.435  53.135   2.652  1.00  0.00           C  
ATOM   1121  CE1 HIS A  67       3.412  54.593   1.343  1.00  0.00           C  
ATOM   1122  NE2 HIS A  67       2.522  53.622   1.370  1.00  0.00           N  
ATOM   1123  H   HIS A  67       4.147  52.944   7.297  1.00  0.00           H  
ATOM   1124  HA  HIS A  67       4.468  51.804   4.648  1.00  0.00           H  
ATOM   1125  HB2 HIS A  67       2.687  53.550   5.403  1.00  0.00           H  
ATOM   1126  HB3 HIS A  67       3.980  54.726   5.201  1.00  0.00           H  
ATOM   1127  HD1 HIS A  67       4.589  55.417   2.810  1.00  0.00           H  
ATOM   1128  HD2 HIS A  67       1.790  52.337   2.992  1.00  0.00           H  
ATOM   1129  HE1 HIS A  67       3.692  55.169   0.472  1.00  0.00           H  
ATOM   1130  HE2 HIS A  67       2.146  53.180   0.568  1.00  0.00           H  
ATOM   1131  N   HIS A  68       6.717  53.589   6.070  1.00  0.00           N  
ATOM   1132  CA  HIS A  68       8.113  53.981   6.014  1.00  0.00           C  
ATOM   1133  C   HIS A  68       8.872  53.298   7.149  1.00  0.00           C  
ATOM   1134  O   HIS A  68       8.401  53.363   8.306  1.00  0.00           O  
ATOM   1135  CB  HIS A  68       8.283  55.517   6.062  1.00  0.00           C  
ATOM   1136  CG  HIS A  68       7.931  56.174   7.369  1.00  0.00           C  
ATOM   1137  ND1 HIS A  68       6.702  56.745   7.623  1.00  0.00           N  
ATOM   1138  CD2 HIS A  68       8.673  56.378   8.487  1.00  0.00           C  
ATOM   1139  CE1 HIS A  68       6.707  57.271   8.835  1.00  0.00           C  
ATOM   1140  NE2 HIS A  68       7.888  57.061   9.380  1.00  0.00           N  
ATOM   1141  OXT HIS A  68       9.920  52.681   6.879  1.00  0.00           O  
ATOM   1142  H   HIS A  68       6.254  53.602   6.938  1.00  0.00           H  
ATOM   1143  HA  HIS A  68       8.510  53.617   5.077  1.00  0.00           H  
ATOM   1144  HB2 HIS A  68       9.314  55.756   5.848  1.00  0.00           H  
ATOM   1145  HB3 HIS A  68       7.661  55.957   5.297  1.00  0.00           H  
ATOM   1146  HD1 HIS A  68       5.938  56.770   7.004  1.00  0.00           H  
ATOM   1147  HD2 HIS A  68       9.692  56.056   8.645  1.00  0.00           H  
ATOM   1148  HE1 HIS A  68       5.881  57.786   9.301  1.00  0.00           H  
ATOM   1149  HE2 HIS A  68       8.089  57.174  10.341  1.00  0.00           H  
TER    1150      HIS A  68                                                      
END
MOLECULE T0480.pdb
ATOM     43  N   PHE    20      -9.421  47.124  -2.332  1.00  0.00
ATOM     44  HN  PHE    20      -9.663  47.024  -3.278  1.00  0.00
ATOM     45  CA  PHE    20     -10.050  48.188  -1.549  1.00  0.00
ATOM     46  HA  PHE    20      -9.287  48.642  -0.932  1.00  0.00
ATOM     47  CB  PHE    20     -10.641  49.260  -2.478  1.00  0.00
ATOM     48  HB1 PHE    20     -11.197  49.974  -1.885  1.00  0.00
ATOM     49  HB2 PHE    20     -11.316  48.788  -3.178  1.00  0.00
ATOM     50  CG  PHE    20      -9.613  50.019  -3.274  1.00  0.00
ATOM     51  CD1 PHE    20      -9.119  49.504  -4.460  1.00  0.00
ATOM     52  HD1 PHE    20      -9.476  48.547  -4.813  1.00  0.00
ATOM     53  CD2 PHE    20      -9.145  51.251  -2.836  1.00  0.00
ATOM     54  HD2 PHE    20      -9.523  51.664  -1.912  1.00  0.00
ATOM     55  CE1 PHE    20      -8.180  50.199  -5.195  1.00  0.00
ATOM     56  HE1 PHE    20      -7.803  49.783  -6.119  1.00  0.00
ATOM     57  CE2 PHE    20      -8.206  51.949  -3.568  1.00  0.00
ATOM     58  HE2 PHE    20      -7.850  52.908  -3.217  1.00  0.00
ATOM     59  CZ  PHE    20      -7.722  51.422  -4.750  1.00  0.00
ATOM     60  HZ  PHE    20      -6.988  51.966  -5.326  1.00  0.00
ATOM     61  C   PHE    20     -11.149  47.641  -0.643  1.00  0.00
ATOM     62  O   PHE    20     -11.503  46.465  -0.706  1.00  0.00
ATOM     63  N   CYS    21     -11.685  48.510   0.204  1.00  0.00
ATOM     64  HN  CYS    21     -11.329  49.425   0.240  1.00  0.00
ATOM     65  CA  CYS    21     -12.801  48.155   1.067  1.00  0.00
ATOM     66  HA  CYS    21     -12.726  47.105   1.318  1.00  0.00
ATOM     67  HB1 CYS    21     -12.914  50.028   2.087  1.00  0.00
ATOM     68  HB2 CYS    21     -11.760  48.898   2.773  1.00  0.00
ATOM     69  C   CYS    21     -14.100  48.414   0.312  1.00  0.00
ATOM     70  O   CYS    21     -14.384  49.557  -0.023  1.00  0.00
ATOM     71  CB  CYS    21     -12.742  48.991   2.341  1.00  0.00
ATOM     72  SG  CYS    21     -13.954  48.528   3.619  1.00  0.00
ATOM     73  N   PRO    22     -14.916  47.367   0.073  1.00  0.00
ATOM     74  CA  PRO    22     -16.026  47.404  -0.893  1.00  0.00
ATOM     75  HA  PRO    22     -15.680  47.160  -1.889  1.00  0.00
ATOM     76  CB  PRO    22     -16.958  46.298  -0.401  1.00  0.00
ATOM     77  HB1 PRO    22     -17.462  45.846  -1.245  1.00  0.00
ATOM     78  HB2 PRO    22     -17.694  46.716   0.276  1.00  0.00
ATOM     79  CG  PRO    22     -16.074  45.316   0.294  1.00  0.00
ATOM     80  HG1 PRO    22     -15.795  44.526  -0.389  1.00  0.00
ATOM     81  HG2 PRO    22     -16.602  44.907   1.141  1.00  0.00
ATOM     82  CD  PRO    22     -14.843  46.065   0.763  1.00  0.00
ATOM     83  HD1 PRO    22     -13.945  45.532   0.486  1.00  0.00
ATOM     84  HD2 PRO    22     -14.875  46.204   1.835  1.00  0.00
ATOM     85  C   PRO    22     -16.770  48.741  -0.939  1.00  0.00
ATOM     86  O   PRO    22     -16.834  49.390  -1.988  1.00  0.00
ATOM     87  N   ARG    23     -17.316  49.158   0.201  1.00  0.00
ATOM     88  HN  ARG    23     -17.154  48.653   1.025  1.00  0.00
ATOM     89  CA  ARG    23     -18.164  50.344   0.238  1.00  0.00
ATOM     90  HA  ARG    23     -18.672  50.391  -0.712  1.00  0.00
ATOM     91  CB  ARG    23     -19.223  50.223   1.341  1.00  0.00
ATOM     92  HB1 ARG    23     -19.804  51.135   1.369  1.00  0.00
ATOM     93  HB2 ARG    23     -18.724  50.096   2.291  1.00  0.00
ATOM     94  CG  ARG    23     -20.180  49.050   1.141  1.00  0.00
ATOM     95  HG1 ARG    23     -19.642  48.129   1.321  1.00  0.00
ATOM     96  HG2 ARG    23     -20.538  49.061   0.121  1.00  0.00
ATOM     97  CD  ARG    23     -21.381  49.113   2.081  1.00  0.00
ATOM     98  HD1 ARG    23     -21.999  48.242   1.910  1.00  0.00
ATOM     99  HD2 ARG    23     -21.951  50.003   1.854  1.00  0.00
ATOM    100  NE  ARG    23     -20.991  49.150   3.495  1.00  0.00
ATOM    101  HE  ARG    23     -20.100  49.512   3.706  1.00  0.00
ATOM    102  CZ  ARG    23     -21.777  48.752   4.498  1.00  0.00
ATOM    103  NH1 ARG    23     -22.967  48.220   4.250  1.00  0.00
ATOM    104 HH11 ARG    23     -23.285  48.110   3.303  1.00  0.00
ATOM    105 HH12 ARG    23     -23.556  47.929   5.009  1.00  0.00
ATOM    106  NH2 ARG    23     -21.364  48.866   5.751  1.00  0.00
ATOM    107 HH21 ARG    23     -20.460  49.252   5.953  1.00  0.00
ATOM    108 HH22 ARG    23     -21.954  48.569   6.504  1.00  0.00
ATOM    109  C   ARG    23     -17.352  51.633   0.415  1.00  0.00
ATOM    110  O   ARG    23     -17.758  52.692  -0.062  1.00  0.00
ATOM    111  N   CYS    24     -16.206  51.549   1.092  1.00  0.00
ATOM    112  HN  CYS    24     -15.914  50.681   1.429  1.00  0.00
ATOM    113  CA  CYS    24     -15.370  52.739   1.328  1.00  0.00
ATOM    114  HA  CYS    24     -16.018  53.602   1.381  1.00  0.00
ATOM    115  HB1 CYS    24     -14.192  53.616   2.885  1.00  0.00
ATOM    116  HB2 CYS    24     -13.735  51.970   2.480  1.00  0.00
ATOM    117  C   CYS    24     -14.366  52.941   0.194  1.00  0.00
ATOM    118  O   CYS    24     -13.660  53.947   0.171  1.00  0.00
ATOM    119  CB  CYS    24     -14.572  52.634   2.635  1.00  0.00
ATOM    120  SG  CYS    24     -15.473  52.014   4.084  1.00  0.00
ATOM    121  N   GLY    25     -14.311  51.975  -0.727  1.00  0.00
ATOM    122  HN  GLY    25     -15.009  51.286  -0.729  1.00  0.00
ATOM    123  CA  GLY    25     -13.256  51.919  -1.735  1.00  0.00
ATOM    124  HA1 GLY    25     -13.576  51.268  -2.533  1.00  0.00
ATOM    125  HA2 GLY    25     -12.373  51.493  -1.282  1.00  0.00
ATOM    126  C   GLY    25     -12.895  53.274  -2.316  1.00  0.00
ATOM    127  O   GLY    25     -11.779  53.757  -2.106  1.00  0.00
ATOM    128  N   PRO    26     -13.818  53.919  -3.049  1.00  0.00
ATOM    129  CA  PRO    26     -13.599  55.269  -3.570  1.00  0.00
ATOM    130  HA  PRO    26     -12.703  55.315  -4.175  1.00  0.00
ATOM    131  CB  PRO    26     -14.836  55.536  -4.453  1.00  0.00
ATOM    132  HB1 PRO    26     -14.526  55.974  -5.391  1.00  0.00
ATOM    133  HB2 PRO    26     -15.511  56.212  -3.944  1.00  0.00
ATOM    134  CG  PRO    26     -15.466  54.197  -4.662  1.00  0.00
ATOM    135  HG1 PRO    26     -15.052  53.729  -5.546  1.00  0.00
ATOM    136  HG2 PRO    26     -16.537  54.305  -4.764  1.00  0.00
ATOM    137  CD  PRO    26     -15.135  53.389  -3.440  1.00  0.00
ATOM    138  HD1 PRO    26     -15.075  52.339  -3.684  1.00  0.00
ATOM    139  HD2 PRO    26     -15.868  53.560  -2.664  1.00  0.00
ATOM    140  C   PRO    26     -13.496  56.293  -2.437  1.00  0.00
ATOM    141  O   PRO    26     -14.508  56.823  -1.967  1.00  0.00
ATOM    142  N   GLY    27     -12.275  56.524  -1.966  1.00  0.00
ATOM    143  HN  GLY    27     -11.520  56.002  -2.319  1.00  0.00
ATOM    144  CA  GLY    27     -12.036  57.519  -0.932  1.00  0.00
ATOM    145  HA1 GLY    27     -12.982  57.935  -0.612  1.00  0.00
ATOM    146  HA2 GLY    27     -11.430  58.310  -1.348  1.00  0.00
ATOM    147  C   GLY    27     -11.325  56.943   0.273  1.00  0.00
ATOM    148  O   GLY    27     -10.653  57.668   1.009  1.00  0.00
ATOM    149  N   VAL    28     -11.468  55.634   0.479  1.00  0.00
ATOM    150  HN  VAL    28     -12.031  55.114  -0.136  1.00  0.00
ATOM    151  CA  VAL    28     -10.810  54.948   1.591  1.00  0.00
ATOM    152  HA  VAL    28     -10.018  55.586   1.960  1.00  0.00
ATOM    153  CB  VAL    28     -11.782  54.646   2.763  1.00  0.00
ATOM    154  HB  VAL    28     -12.477  53.886   2.424  1.00  0.00
ATOM    155  CG1 VAL    28     -11.028  54.082   3.968  1.00  0.00
ATOM    156 HG11 VAL    28     -10.300  54.803   4.309  1.00  0.00
ATOM    157 HG12 VAL    28     -10.525  53.168   3.687  1.00  0.00
ATOM    158 HG13 VAL    28     -11.728  53.875   4.766  1.00  0.00
ATOM    159  CG2 VAL    28     -12.588  55.883   3.159  1.00  0.00
ATOM    160 HG21 VAL    28     -11.917  56.666   3.482  1.00  0.00
ATOM    161 HG22 VAL    28     -13.260  55.632   3.967  1.00  0.00
ATOM    162 HG23 VAL    28     -13.162  56.229   2.311  1.00  0.00
ATOM    163  C   VAL    28     -10.205  53.631   1.123  1.00  0.00
ATOM    164  O   VAL    28     -10.910  52.621   0.993  1.00  0.00
ATOM    165  N   PHE    29      -8.907  53.645   0.861  1.00  0.00
ATOM    166  HN  PHE    29      -8.420  54.495   0.903  1.00  0.00
ATOM    167  CA  PHE    29      -8.190  52.430   0.504  1.00  0.00
ATOM    168  HA  PHE    29      -8.697  51.979  -0.339  1.00  0.00
ATOM    169  CB  PHE    29      -6.738  52.749   0.109  1.00  0.00
ATOM    170  HB1 PHE    29      -6.738  53.555  -0.613  1.00  0.00
ATOM    171  HB2 PHE    29      -6.296  51.872  -0.342  1.00  0.00
ATOM    172  CG  PHE    29      -5.864  53.166   1.270  1.00  0.00
ATOM    173  CD1 PHE    29      -4.909  52.298   1.788  1.00  0.00
ATOM    174  HD1 PHE    29      -4.786  51.319   1.348  1.00  0.00
ATOM    175  CD2 PHE    29      -6.003  54.418   1.850  1.00  0.00
ATOM    176  HD2 PHE    29      -6.739  55.104   1.458  1.00  0.00
ATOM    177  CE1 PHE    29      -4.116  52.673   2.857  1.00  0.00
ATOM    178  HE1 PHE    29      -3.377  51.988   3.249  1.00  0.00
ATOM    179  CE2 PHE    29      -5.211  54.796   2.917  1.00  0.00
ATOM    180  HE2 PHE    29      -5.331  55.775   3.358  1.00  0.00
ATOM    181  CZ  PHE    29      -4.268  53.924   3.421  1.00  0.00
ATOM    182  HZ  PHE    29      -3.650  54.219   4.258  1.00  0.00
ATOM    183  C   PHE    29      -8.210  51.449   1.679  1.00  0.00
ATOM    184  O   PHE    29      -8.458  51.838   2.825  1.00  0.00
ATOM    185  N   LEU    30      -7.958  50.182   1.396  1.00  0.00
ATOM    186  HN  LEU    30      -7.805  49.919   0.464  1.00  0.00
ATOM    187  CA  LEU    30      -7.868  49.176   2.441  1.00  0.00
ATOM    188  HA  LEU    30      -8.446  49.515   3.292  1.00  0.00
ATOM    189  CB  LEU    30      -8.437  47.841   1.939  1.00  0.00
ATOM    190  HB1 LEU    30      -7.762  47.449   1.190  1.00  0.00
ATOM    191  HB2 LEU    30      -9.389  48.040   1.467  1.00  0.00
ATOM    192  CG  LEU    30      -8.649  46.756   3.010  1.00  0.00
ATOM    193  HG  LEU    30      -7.705  46.559   3.499  1.00  0.00
ATOM    194  CD1 LEU    30      -9.637  47.226   4.075  1.00  0.00
ATOM    195 HD11 LEU    30     -10.591  47.443   3.615  1.00  0.00
ATOM    196 HD12 LEU    30      -9.257  48.119   4.550  1.00  0.00
ATOM    197 HD13 LEU    30      -9.765  46.452   4.819  1.00  0.00
ATOM    198  CD2 LEU    30      -9.129  45.452   2.368  1.00  0.00
ATOM    199 HD21 LEU    30     -10.068  45.622   1.859  1.00  0.00
ATOM    200 HD22 LEU    30      -9.268  44.701   3.133  1.00  0.00
ATOM    201 HD23 LEU    30      -8.392  45.106   1.657  1.00  0.00
ATOM    202  C   LEU    30      -6.405  49.037   2.850  1.00  0.00
ATOM    203  O   LEU    30      -5.581  48.585   2.055  1.00  0.00
ATOM    204  N   ALA    31      -6.089  49.469   4.074  1.00  0.00
ATOM    205  HN  ALA    31      -6.808  49.759   4.671  1.00  0.00
ATOM    206  CA  ALA    31      -4.708  49.517   4.560  1.00  0.00
ATOM    207  HA  ALA    31      -4.182  50.263   3.979  1.00  0.00
ATOM    208  CB  ALA    31      -4.674  49.953   6.023  1.00  0.00
ATOM    209  HB1 ALA    31      -3.648  50.043   6.352  1.00  0.00
ATOM    210  HB2 ALA    31      -5.182  49.219   6.631  1.00  0.00
ATOM    211  HB3 ALA    31      -5.167  50.908   6.126  1.00  0.00
ATOM    212  C   ALA    31      -4.007  48.174   4.380  1.00  0.00
ATOM    213  O   ALA    31      -4.101  47.290   5.237  1.00  0.00
ATOM    214  N   GLU    32      -3.331  48.023   3.246  1.00  0.00
ATOM    215  HN  GLU    32      -3.321  48.760   2.599  1.00  0.00
ATOM    216  CA  GLU    32      -2.625  46.794   2.922  1.00  0.00
ATOM    217  HA  GLU    32      -3.248  45.965   3.234  1.00  0.00
ATOM    218  CB  GLU    32      -2.386  46.686   1.408  1.00  0.00
ATOM    219  HB1 GLU    32      -1.814  47.543   1.083  1.00  0.00
ATOM    220  HB2 GLU    32      -3.342  46.691   0.903  1.00  0.00
ATOM    221  CG  GLU    32      -1.632  45.422   0.999  1.00  0.00
ATOM    222  HG1 GLU    32      -2.172  44.560   1.369  1.00  0.00
ATOM    223  HG2 GLU    32      -0.650  45.445   1.449  1.00  0.00
ATOM    224  CD  GLU    32      -1.467  45.287  -0.506  1.00  0.00
ATOM    225  OE1 GLU    32      -0.618  46.002  -1.079  1.00  0.00
ATOM    226  OE2 GLU    32      -2.171  44.448  -1.114  1.00  0.00
ATOM    227  C   GLU    32      -1.300  46.719   3.673  1.00  0.00
ATOM    228  O   GLU    32      -0.357  47.459   3.381  1.00  0.00
ATOM    229  N   HIS    33      -1.263  45.852   4.668  1.00  0.00
ATOM    230  HN  HIS    33      -2.089  45.388   4.911  1.00  0.00
ATOM    231  CA  HIS    33      -0.045  45.545   5.406  1.00  0.00
ATOM    232  HA  HIS    33       0.685  46.317   5.196  1.00  0.00
ATOM    233  CB  HIS    33      -0.317  45.503   6.914  1.00  0.00
ATOM    234  HB1 HIS    33       0.590  45.218   7.429  1.00  0.00
ATOM    235  HB2 HIS    33      -1.084  44.767   7.119  1.00  0.00
ATOM    236  CG  HIS    33      -0.772  46.815   7.476  1.00  0.00
ATOM    237  ND1 HIS    33       0.097  47.768   7.958  1.00  0.00
ATOM    238  HD1 HIS    33       1.077  47.689   7.991  1.00  0.00
ATOM    239  CD2 HIS    33      -2.014  47.330   7.633  1.00  0.00
ATOM    240  HD2 HIS    33      -2.944  46.851   7.362  1.00  0.00
ATOM    241  CE1 HIS    33      -0.589  48.809   8.385  1.00  0.00
ATOM    242  HE1 HIS    33      -0.169  49.705   8.818  1.00  0.00
ATOM    243  NE2 HIS    33      -1.873  48.572   8.199  1.00  0.00
ATOM    244  HE2 HIS    33      -2.599  49.075   8.631  1.00  0.00
ATOM    245  C   HIS    33       0.506  44.203   4.940  1.00  0.00
ATOM    246  O   HIS    33      -0.225  43.393   4.365  1.00  0.00
ATOM    247  N   ALA    34       1.782  43.964   5.214  1.00  0.00
ATOM    248  HN  ALA    34       2.282  44.621   5.746  1.00  0.00
ATOM    249  CA  ALA    34       2.468  42.759   4.751  1.00  0.00
ATOM    250  HA  ALA    34       2.479  42.779   3.670  1.00  0.00
ATOM    251  CB  ALA    34       3.914  42.763   5.235  1.00  0.00
ATOM    252  HB1 ALA    34       4.434  41.909   4.826  1.00  0.00
ATOM    253  HB2 ALA    34       3.936  42.714   6.315  1.00  0.00
ATOM    254  HB3 ALA    34       4.401  43.670   4.907  1.00  0.00
ATOM    255  C   ALA    34       1.761  41.481   5.206  1.00  0.00
ATOM    256  O   ALA    34       1.850  40.444   4.543  1.00  0.00
ATOM    257  N   ASP    35       1.049  41.561   6.329  1.00  0.00
ATOM    258  HN  ASP    35       0.954  42.428   6.773  1.00  0.00
ATOM    259  CA  ASP    35       0.416  40.383   6.923  1.00  0.00
ATOM    260  HA  ASP    35       0.770  39.510   6.392  1.00  0.00
ATOM    261  CB  ASP    35       0.816  40.251   8.399  1.00  0.00
ATOM    262  HB1 ASP    35       1.883  40.394   8.487  1.00  0.00
ATOM    263  HB2 ASP    35       0.565  39.258   8.747  1.00  0.00
ATOM    264  CG  ASP    35       0.122  41.266   9.293  1.00  0.00
ATOM    265  OD1 ASP    35       0.449  42.468   9.202  1.00  0.00
ATOM    266  OD2 ASP    35      -0.746  40.867  10.097  1.00  0.00
ATOM    267  C   ASP    35      -1.111  40.429   6.812  1.00  0.00
ATOM    268  O   ASP    35      -1.773  39.400   6.966  1.00  0.00
ATOM    269  N   ARG    36      -1.682  41.598   6.521  1.00  0.00
ATOM    270  HN  ARG    36      -1.122  42.366   6.270  1.00  0.00
ATOM    271  CA  ARG    36      -3.142  41.736   6.533  1.00  0.00
ATOM    272  HA  ARG    36      -3.550  40.949   5.917  1.00  0.00
ATOM    273  CB  ARG    36      -3.678  41.570   7.966  1.00  0.00
ATOM    274  HB1 ARG    36      -3.315  40.633   8.368  1.00  0.00
ATOM    275  HB2 ARG    36      -4.759  41.538   7.933  1.00  0.00
ATOM    276  CG  ARG    36      -3.264  42.690   8.914  1.00  0.00
ATOM    277  HG1 ARG    36      -3.731  43.611   8.594  1.00  0.00
ATOM    278  HG2 ARG    36      -2.190  42.797   8.873  1.00  0.00
ATOM    279  CD  ARG    36      -3.677  42.398  10.353  1.00  0.00
ATOM    280  HD1 ARG    36      -3.114  41.546  10.712  1.00  0.00
ATOM    281  HD2 ARG    36      -4.732  42.162  10.370  1.00  0.00
ATOM    282  NE  ARG    36      -3.436  43.539  11.239  1.00  0.00
ATOM    283  HE  ARG    36      -4.165  44.194  11.330  1.00  0.00
ATOM    284  CZ  ARG    36      -2.321  43.724  11.948  1.00  0.00
ATOM    285  NH1 ARG    36      -1.289  42.903  11.808  1.00  0.00
ATOM    286 HH11 ARG    36      -1.337  42.131  11.163  1.00  0.00
ATOM    287 HH12 ARG    36      -0.455  43.046  12.347  1.00  0.00
ATOM    288  NH2 ARG    36      -2.225  44.752  12.777  1.00  0.00
ATOM    289 HH21 ARG    36      -2.992  45.396  12.878  1.00  0.00
ATOM    290 HH22 ARG    36      -1.390  44.887  13.317  1.00  0.00
ATOM    291  C   ARG    36      -3.592  43.080   5.962  1.00  0.00
ATOM    292  O   ARG    36      -2.805  43.816   5.384  1.00  0.00
ATOM    293  N   TYR    37      -4.876  43.366   6.135  1.00  0.00
ATOM    294  HN  TYR    37      -5.429  42.719   6.609  1.00  0.00
ATOM    295  CA  TYR    37      -5.508  44.603   5.686  1.00  0.00
ATOM    296  HA  TYR    37      -4.743  45.306   5.387  1.00  0.00
ATOM    297  CB  TYR    37      -6.477  44.347   4.519  1.00  0.00
ATOM    298  HB1 TYR    37      -6.833  45.302   4.155  1.00  0.00
ATOM    299  HB2 TYR    37      -7.322  43.784   4.887  1.00  0.00
ATOM    300  CG  TYR    37      -5.912  43.586   3.333  1.00  0.00
ATOM    301  CD1 TYR    37      -5.992  42.198   3.273  1.00  0.00
ATOM    302  HD1 TYR    37      -6.438  41.661   4.097  1.00  0.00
ATOM    303  CD2 TYR    37      -5.335  44.256   2.258  1.00  0.00
ATOM    304  HD2 TYR    37      -5.265  45.334   2.286  1.00  0.00
ATOM    305  CE1 TYR    37      -5.512  41.502   2.183  1.00  0.00
ATOM    306  HE1 TYR    37      -5.586  40.425   2.155  1.00  0.00
ATOM    307  CE2 TYR    37      -4.849  43.564   1.166  1.00  0.00
ATOM    308  HE2 TYR    37      -4.402  44.101   0.342  1.00  0.00
ATOM    309  CZ  TYR    37      -4.942  42.190   1.133  1.00  0.00
ATOM    310  OH  TYR    37      -4.459  41.497   0.046  1.00  0.00
ATOM    311  HH  TYR    37      -5.120  40.864  -0.251  1.00  0.00
ATOM    312  C   TYR    37      -6.322  45.182   6.841  1.00  0.00
ATOM    313  O   TYR    37      -6.679  44.453   7.767  1.00  0.00
ATOM    314  N   SER    38      -6.636  46.471   6.777  1.00  0.00
ATOM    315  HN  SER    38      -6.247  47.026   6.068  1.00  0.00
ATOM    316  CA  SER    38      -7.535  47.084   7.751  1.00  0.00
ATOM    317  HA  SER    38      -8.327  46.375   7.956  1.00  0.00
ATOM    318  CB  SER    38      -6.797  47.393   9.060  1.00  0.00
ATOM    319  HB1 SER    38      -6.130  48.229   8.911  1.00  0.00
ATOM    320  HB2 SER    38      -6.225  46.527   9.362  1.00  0.00
ATOM    321  OG  SER    38      -7.714  47.715  10.094  1.00  0.00
ATOM    322  HG  SER    38      -8.082  46.897  10.459  1.00  0.00
ATOM    323  C   SER    38      -8.166  48.351   7.170  1.00  0.00
ATOM    324  O   SER    38      -7.687  48.894   6.172  1.00  0.00
ATOM    325  N   CYS    39      -9.256  48.806   7.780  1.00  0.00
ATOM    326  HN  CYS    39      -9.589  48.331   8.573  1.00  0.00
ATOM    327  CA  CYS    39      -9.980  49.978   7.296  1.00  0.00
ATOM    328  HA  CYS    39      -9.347  50.504   6.596  1.00  0.00
ATOM    329  HB1 CYS    39     -11.825  48.903   7.229  1.00  0.00
ATOM    330  HB2 CYS    39     -10.986  48.989   5.693  1.00  0.00
ATOM    331  C   CYS    39     -10.341  50.922   8.431  1.00  0.00
ATOM    332  O   CYS    39     -11.402  50.776   9.049  1.00  0.00
ATOM    333  CB  CYS    39     -11.253  49.545   6.574  1.00  0.00
ATOM    334  SG  CYS    39     -12.344  50.914   6.050  1.00  0.00
ATOM    335  N   GLY    40      -9.454  51.877   8.706  1.00  0.00
ATOM    336  HN  GLY    40      -8.584  51.868   8.253  1.00  0.00
ATOM    337  CA  GLY    40      -9.742  52.916   9.678  1.00  0.00
ATOM    338  HA1 GLY    40      -8.854  53.512   9.830  1.00  0.00
ATOM    339  HA2 GLY    40     -10.020  52.456  10.616  1.00  0.00
ATOM    340  C   GLY    40     -10.870  53.818   9.213  1.00  0.00
ATOM    341  O   GLY    40     -10.634  54.923   8.718  1.00  0.00
ATOM    342  N   ARG    41     -12.095  53.327   9.360  1.00  0.00
ATOM    343  HN  ARG    41     -12.200  52.466   9.822  1.00  0.00
ATOM    344  CA  ARG    41     -13.289  54.031   8.907  1.00  0.00
ATOM    345  HA  ARG    41     -13.318  54.990   9.406  1.00  0.00
ATOM    346  CB  ARG    41     -13.252  54.250   7.384  1.00  0.00
ATOM    347  HB1 ARG    41     -13.317  53.288   6.892  1.00  0.00
ATOM    348  HB2 ARG    41     -12.308  54.710   7.123  1.00  0.00
ATOM    349  CG  ARG    41     -14.378  55.137   6.858  1.00  0.00
ATOM    350  HG1 ARG    41     -15.326  54.721   7.169  1.00  0.00
ATOM    351  HG2 ARG    41     -14.332  55.156   5.778  1.00  0.00
ATOM    352  CD  ARG    41     -14.270  56.568   7.379  1.00  0.00
ATOM    353  HD1 ARG    41     -13.379  57.024   6.966  1.00  0.00
ATOM    354  HD2 ARG    41     -14.193  56.542   8.456  1.00  0.00
ATOM    355  NE  ARG    41     -15.434  57.375   7.008  1.00  0.00
ATOM    356  HE  ARG    41     -16.316  57.040   7.290  1.00  0.00
ATOM    357  CZ  ARG    41     -15.372  58.529   6.339  1.00  0.00
ATOM    358  NH1 ARG    41     -14.206  59.004   5.921  1.00  0.00
ATOM    359 HH11 ARG    41     -13.359  58.498   6.105  1.00  0.00
ATOM    360 HH12 ARG    41     -14.164  59.872   5.417  1.00  0.00
ATOM    361  NH2 ARG    41     -16.485  59.200   6.077  1.00  0.00
ATOM    362 HH21 ARG    41     -17.372  58.843   6.382  1.00  0.00
ATOM    363 HH22 ARG    41     -16.447  60.068   5.571  1.00  0.00
ATOM    364  C   ARG    41     -14.536  53.232   9.294  1.00  0.00
ATOM    365  O   ARG    41     -15.460  53.767   9.905  1.00  0.00
ATOM    366  N   CYS    42     -14.550  51.941   8.946  1.00  0.00
ATOM    367  HN  CYS    42     -13.788  51.572   8.462  1.00  0.00
ATOM    368  CA  CYS    42     -15.680  51.066   9.290  1.00  0.00
ATOM    369  HA  CYS    42     -16.324  51.612   9.967  1.00  0.00
ATOM    370  HB1 CYS    42     -16.667  51.558   7.443  1.00  0.00
ATOM    371  HB2 CYS    42     -17.452  50.281   8.357  1.00  0.00
ATOM    372  C   CYS    42     -15.190  49.810  10.010  1.00  0.00
ATOM    373  O   CYS    42     -15.972  48.902  10.291  1.00  0.00
ATOM    374  CB  CYS    42     -16.497  50.676   8.042  1.00  0.00
ATOM    375  SG  CYS    42     -15.721  49.422   6.967  1.00  0.00
ATOM    376  N   GLY    43     -13.886  49.755  10.293  1.00  0.00
ATOM    377  HN  GLY    43     -13.292  50.472   9.984  1.00  0.00
ATOM    378  CA  GLY    43     -13.333  48.655  11.068  1.00  0.00
ATOM    379  HA1 GLY    43     -13.985  48.453  11.906  1.00  0.00
ATOM    380  HA2 GLY    43     -12.365  48.951  11.446  1.00  0.00
ATOM    381  C   GLY    43     -13.167  47.383  10.264  1.00  0.00
ATOM    382  O   GLY    43     -12.919  46.319  10.828  1.00  0.00
ATOM    383  N   TYR    44     -13.292  47.490   8.943  1.00  0.00
ATOM    384  HN  TYR    44     -13.474  48.365   8.552  1.00  0.00
ATOM    385  CA  TYR    44     -13.151  46.329   8.071  1.00  0.00
ATOM    386  HA  TYR    44     -13.761  45.533   8.480  1.00  0.00
ATOM    387  CB  TYR    44     -13.634  46.650   6.644  1.00  0.00
ATOM    388  HB1 TYR    44     -12.949  47.348   6.181  1.00  0.00
ATOM    389  HB2 TYR    44     -14.613  47.103   6.698  1.00  0.00
ATOM    390  CG  TYR    44     -13.736  45.430   5.742  1.00  0.00
ATOM    391  CD1 TYR    44     -14.898  44.664   5.711  1.00  0.00
ATOM    392  HD1 TYR    44     -15.731  44.949   6.336  1.00  0.00
ATOM    393  CD2 TYR    44     -12.675  45.043   4.926  1.00  0.00
ATOM    394  HD2 TYR    44     -11.765  45.625   4.936  1.00  0.00
ATOM    395  CE1 TYR    44     -14.999  43.553   4.896  1.00  0.00
ATOM    396  HE1 TYR    44     -15.910  42.972   4.888  1.00  0.00
ATOM    397  CE2 TYR    44     -12.772  43.932   4.110  1.00  0.00
ATOM    398  HE2 TYR    44     -11.937  43.647   3.485  1.00  0.00
ATOM    399  CZ  TYR    44     -13.935  43.191   4.098  1.00  0.00
ATOM    400  OH  TYR    44     -14.035  42.084   3.285  1.00  0.00
ATOM    401  HH  TYR    44     -13.267  41.512   3.421  1.00  0.00
ATOM    402  C   TYR    44     -11.692  45.874   8.052  1.00  0.00
ATOM    403  O   TYR    44     -10.820  46.586   7.541  1.00  0.00
ATOM    404  N   THR    45     -11.440  44.710   8.635  1.00  0.00
ATOM    405  HN  THR    45     -12.181  44.224   9.056  1.00  0.00
ATOM    406  CA  THR    45     -10.111  44.123   8.690  1.00  0.00
ATOM    407  HA  THR    45      -9.436  44.742   8.108  1.00  0.00
ATOM    408  CB  THR    45      -9.598  44.072  10.151  1.00  0.00
ATOM    409  HB  THR    45     -10.307  43.509  10.743  1.00  0.00
ATOM    410  OG1 THR    45      -9.513  45.405  10.682  1.00  0.00
ATOM    411  HG1 THR    45     -10.178  45.513  11.373  1.00  0.00
ATOM    412  CG2 THR    45      -8.233  43.392  10.251  1.00  0.00
ATOM    413 HG21 THR    45      -7.903  43.395  11.280  1.00  0.00
ATOM    414 HG22 THR    45      -7.517  43.926   9.643  1.00  0.00
ATOM    415 HG23 THR    45      -8.311  42.372   9.903  1.00  0.00
ATOM    416  C   THR    45     -10.144  42.717   8.091  1.00  0.00
ATOM    417  O   THR    45     -11.064  41.940   8.359  1.00  0.00
ATOM    418  N   GLU    46      -9.150  42.411   7.270  1.00  0.00
ATOM    419  HN  GLU    46      -8.432  43.068   7.132  1.00  0.00
ATOM    420  CA  GLU    46      -9.061  41.127   6.581  1.00  0.00
ATOM    421  HA  GLU    46      -9.638  40.397   7.131  1.00  0.00
ATOM    422  CB  GLU    46      -9.617  41.256   5.152  1.00  0.00
ATOM    423  HB1 GLU    46      -9.027  41.987   4.614  1.00  0.00
ATOM    424  HB2 GLU    46     -10.638  41.607   5.206  1.00  0.00
ATOM    425  CG  GLU    46      -9.603  39.953   4.359  1.00  0.00
ATOM    426  HG1 GLU    46      -8.586  39.589   4.310  1.00  0.00
ATOM    427  HG2 GLU    46      -9.958  40.150   3.356  1.00  0.00
ATOM    428  CD  GLU    46     -10.477  38.876   4.981  1.00  0.00
ATOM    429  OE1 GLU    46      -9.978  38.115   5.835  1.00  0.00
ATOM    430  OE2 GLU    46     -11.665  38.779   4.610  1.00  0.00
ATOM    431  C   GLU    46      -7.603  40.695   6.546  1.00  0.00
ATOM    432  O   GLU    46      -6.725  41.538   6.470  1.00  0.00
ATOM    433  N   PHE    47      -7.333  39.399   6.601  1.00  0.00
ATOM    434  HN  PHE    47      -8.072  38.749   6.586  1.00  0.00
ATOM    435  CA  PHE    47      -5.950  38.917   6.656  1.00  0.00
ATOM    436  HA  PHE    47      -5.338  39.722   7.041  1.00  0.00
ATOM    437  CB  PHE    47      -5.833  37.719   7.606  1.00  0.00
ATOM    438  HB1 PHE    47      -4.848  37.284   7.507  1.00  0.00
ATOM    439  HB2 PHE    47      -6.574  36.980   7.337  1.00  0.00
ATOM    440  CG  PHE    47      -6.037  38.084   9.055  1.00  0.00
ATOM    441  CD1 PHE    47      -7.275  37.931   9.663  1.00  0.00
ATOM    442  HD1 PHE    47      -8.103  37.536   9.090  1.00  0.00
ATOM    443  CD2 PHE    47      -4.984  38.591   9.806  1.00  0.00
ATOM    444  HD2 PHE    47      -4.014  38.715   9.342  1.00  0.00
ATOM    445  CE1 PHE    47      -7.457  38.275  10.989  1.00  0.00
ATOM    446  HE1 PHE    47      -8.426  38.151  11.451  1.00  0.00
ATOM    447  CE2 PHE    47      -5.163  38.934  11.133  1.00  0.00
ATOM    448  HE2 PHE    47      -4.336  39.325  11.707  1.00  0.00
ATOM    449  CZ  PHE    47      -6.400  38.776  11.724  1.00  0.00
ATOM    450  HZ  PHE    47      -6.542  39.045  12.761  1.00  0.00
ATOM    451  C   PHE    47      -5.431  38.540   5.273  1.00  0.00
ATOM    452  O   PHE    47      -6.207  38.197   4.380  1.00  0.00
ATOM    453  N   LYS    48      -4.109  38.631   5.098  1.00  0.00
ATOM    454  HN  LYS    48      -3.558  39.035   5.806  1.00  0.00
ATOM    455  CA  LYS    48      -3.461  38.123   3.891  1.00  0.00
ATOM    456  HA  LYS    48      -3.984  38.527   3.032  1.00  0.00
ATOM    457  CB  LYS    48      -1.979  38.548   3.833  1.00  0.00
ATOM    458  HB1 LYS    48      -1.467  37.928   3.110  1.00  0.00
ATOM    459  HB2 LYS    48      -1.536  38.381   4.805  1.00  0.00
ATOM    460  CG  LYS    48      -1.748  40.015   3.454  1.00  0.00
ATOM    461  HG1 LYS    48      -0.734  40.287   3.714  1.00  0.00
ATOM    462  HG2 LYS    48      -2.437  40.634   4.012  1.00  0.00
ATOM    463  CD  LYS    48      -1.962  40.267   1.960  1.00  0.00
ATOM    464  HD1 LYS    48      -3.004  40.099   1.722  1.00  0.00
ATOM    465  HD2 LYS    48      -1.349  39.578   1.398  1.00  0.00
ATOM    466  CE  LYS    48      -1.588  41.694   1.562  1.00  0.00
ATOM    467  HE1 LYS    48      -0.547  41.862   1.800  1.00  0.00
ATOM    468  HE2 LYS    48      -2.200  42.386   2.122  1.00  0.00
ATOM    469  NZ  LYS    48      -1.795  41.935   0.107  1.00  0.00
ATOM    470  HZ1 LYS    48      -1.136  41.354  -0.450  1.00  0.00
ATOM    471  HZ2 LYS    48      -1.634  42.936  -0.124  1.00  0.00
ATOM    472  HZ3 LYS    48      -2.767  41.683  -0.163  1.00  0.00
ATOM    473  C   LYS    48      -3.585  36.600   3.875  1.00  0.00
ATOM    474  O   LYS    48      -2.753  35.890   4.447  1.00  0.00
END
