
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   81 ( 1243),  selected   81 , name 2jrp_A
# Molecule2: number of CA atoms   29 (  432),  selected   29 , name T0480.pdb
# PARAMETERS: 2jrp_A.T0480.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    E     2_A      -       -           -
LGA    I     3_A      -       -           -
LGA    T     4_A      F      20          1.145
LGA    C     5_A      C      21          0.290
LGA    P     6_A      P      22          0.682
LGA    V     7_A      R      23          1.437
LGA    C     8_A      C      24          0.882
LGA    H     9_A      G      25          1.116
LGA    -       -      P      26           -
LGA    -       -      G      27           -
LGA    H    10_A      V      28          1.494
LGA    A    11_A      F      29          0.904
LGA    L    12_A      L      30          1.389
LGA    E    13_A      A      31          1.465
LGA    R    14_A      E      32          1.652
LGA    N    15_A      H      33          1.838
LGA    G    16_A      A      34          1.322
LGA    D    17_A      D      35          1.726
LGA    T    18_A      R      36          0.617
LGA    A    19_A      Y      37          0.785
LGA    H    20_A      S      38          0.884
LGA    C    21_A      C      39          1.175
LGA    E    22_A      G      40          1.980
LGA    T    23_A      R      41          1.139
LGA    C    24_A      C      42          0.967
LGA    A    25_A      G      43          0.902
LGA    K    26_A      Y      44          1.818
LGA    D    27_A      T      45          0.987
LGA    F    28_A      E      46          1.006
LGA    S    29_A      F      47          0.660
LGA    L    30_A      K      48          1.992
LGA    Q    31_A      -       -           -
LGA    A    32_A      -       -           -
LGA    L    33_A      -       -           -
LGA    C    34_A      -       -           -
LGA    P    35_A      -       -           -
LGA    D    36_A      -       -           -
LGA    C    37_A      -       -           -
LGA    R    38_A      -       -           -
LGA    Q    39_A      -       -           -
LGA    P    40_A      -       -           -
LGA    L    41_A      -       -           -
LGA    Q    42_A      -       -           -
LGA    V    43_A      -       -           -
LGA    L    44_A      -       -           -
LGA    K    45_A      -       -           -
LGA    A    46_A      -       -           -
LGA    C    47_A      -       -           -
LGA    G    48_A      -       -           -
LGA    A    49_A      -       -           -
LGA    V    50_A      -       -           -
LGA    D    51_A      -       -           -
LGA    Y    52_A      -       -           -
LGA    F    53_A      -       -           -
LGA    C    54_A      -       -           -
LGA    Q    55_A      -       -           -
LGA    N    56_A      -       -           -
LGA    G    57_A      -       -           -
LGA    H    58_A      -       -           -
LGA    G    59_A      -       -           -
LGA    L    60_A      -       -           -
LGA    I    61_A      -       -           -
LGA    S    62_A      -       -           -
LGA    K    63_A      -       -           -
LGA    K    64_A      -       -           -
LGA    R    65_A      -       -           -
LGA    V    66_A      -       -           -
LGA    N    67_A      -       -           -
LGA    F    68_A      -       -           -
LGA    V    69_A      -       -           -
LGA    I    70_A      -       -           -
LGA    S    71_A      -       -           -
LGA    D    72_A      -       -           -
LGA    Q    73_A      -       -           -
LGA    L    74_A      -       -           -
LGA    E    75_A      -       -           -
LGA    H    76_A      -       -           -
LGA    H    77_A      -       -           -
LGA    H    78_A      -       -           -
LGA    H    79_A      -       -           -
LGA    H    80_A      -       -           -
LGA    H    81_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   81   29    5.0     27    1.27    25.93     88.536     1.967

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.445152 * X  +   0.036020 * Y  +   0.894730 * Z  +  -4.496398
  Y_new =   0.567478 * X  +   0.784275 * Y  +   0.250763 * Z  +  36.345406
  Z_new =  -0.692682 * X  +   0.619367 * Y  +  -0.369562 * Z  +   1.450245 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.108769   -1.032824  [ DEG:   120.8236    -59.1764 ]
  Theta =   0.765201    2.376392  [ DEG:    43.8428    136.1572 ]
  Phi   =   2.235977   -0.905615  [ DEG:   128.1121    -51.8879 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jrp_A                                        
REMARK     2: T0480.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jrp_A.T0480.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   81   29   5.0   27   1.27   25.93  88.536
REMARK  ---------------------------------------------------------- 
MOLECULE 2jrp_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-JUN-07   2JRP              
TITLE     SOLUTION NMR STRUCTURE OF YFGJ FROM SALMONELLA TYPHIMURIUM            
TITLE    2 MODELED WITH TWO ZN+2 BOUND, NORTHEAST STRUCTURAL GENOMICS           
TITLE    3 CONSORTIUM TARGET STR86                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE CYTOPLASMIC PROTEIN;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SALMONELLA TYPHIMURIUM;                         
SOURCE   3 STRAIN: LT2, SGSC1412;                                               
SOURCE   4 ATCC: 700720;                                                        
SOURCE   5 GENE: YFGJ, STM2518;                                                 
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    TWO-ZINC BINDING PROTEIN, STRUCTURAL GENOMICS, PSI-2,                 
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS          
KEYWDS   3 CONSORTIUM, NESG, STRUCTURAL GENOMICS, UNKNOWN FUNCTION              
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.DING,T.A.RAMELOT,J.R.CORT,H.WANG,C.NWOSU,K.CUNNINGHAM,              
AUTHOR   2 L.OWENS,L.MA,R.XIAO,J.LIU,M.C.BARAN,G.V.T.SWAPNA,T.B.ACTON,          
AUTHOR   3 B.ROST,G.T.MONTELIONE,M.A.KENNEDY,NORTHEAST STRUCTURAL               
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   3   06-MAY-08 2JRP    1       SOURCE                                   
REVDAT   2   14-AUG-07 2JRP    1       TITLE                                    
REVDAT   1   10-JUL-07 2JRP    0                                                
JRNL        AUTH   K.DING,T.A.RAMELOT,J.R.CORT,H.WANG,C.NWOSU,                  
JRNL        AUTH 2 K.CUNNINGHAM,L.OWENS,L.MA,R.XIAO,J.LIU,M.C.BARAN,            
JRNL        AUTH 3 G.V.T.SWAPNA,T.B.ACTON,B.ROST,G.T.MONTELIONE,                
JRNL        AUTH 4 M.A.KENNEDY                                                  
JRNL        TITL   SOLUTION NMR STRUCTURE OF YFGJ FROM SALMONELLA               
JRNL        TITL 2 TYPHIMURIUM MODELED WITH TWO ZN+2 BOUND.                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JRP A    1    73  UNP    Q8ZN54   Q8ZN54_SALTY     1     73             
SEQRES   1 A   81  MET GLU ILE THR CYS PRO VAL CYS HIS HIS ALA LEU GLU          
SEQRES   2 A   81  ARG ASN GLY ASP THR ALA HIS CYS GLU THR CYS ALA LYS          
SEQRES   3 A   81  ASP PHE SER LEU GLN ALA LEU CYS PRO ASP CYS ARG GLN          
SEQRES   4 A   81  PRO LEU GLN VAL LEU LYS ALA CYS GLY ALA VAL ASP TYR          
SEQRES   5 A   81  PHE CYS GLN ASN GLY HIS GLY LEU ILE SER LYS LYS ARG          
SEQRES   6 A   81  VAL ASN PHE VAL ILE SER ASP GLN LEU GLU HIS HIS HIS          
SEQRES   7 A   81  HIS HIS HIS                                                  
HET     ZN  A 150       1                                                       
HET     ZN  A 200       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   2   ZN    2(ZN 2+)                                                     
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -5.644  49.012  -9.856  1.00  0.00           N  
ATOM      2  CA  MET A   1      -6.315  47.989  -9.025  1.00  0.00           C  
ATOM      3  C   MET A   1      -6.463  48.477  -7.586  1.00  0.00           C  
ATOM      4  O   MET A   1      -7.583  48.657  -7.103  1.00  0.00           O  
ATOM      5  CB  MET A   1      -5.520  46.681  -9.071  1.00  0.00           C  
ATOM      6  CG  MET A   1      -6.128  45.555  -8.250  1.00  0.00           C  
ATOM      7  SD  MET A   1      -5.314  43.972  -8.550  1.00  0.00           S  
ATOM      8  CE  MET A   1      -5.720  43.720 -10.279  1.00  0.00           C  
ATOM      9  H1  MET A   1      -4.683  49.193  -9.497  1.00  0.00           H  
ATOM     10  H2  MET A   1      -6.188  49.904  -9.827  1.00  0.00           H  
ATOM     11  H3  MET A   1      -5.586  48.689 -10.844  1.00  0.00           H  
ATOM     12  HA  MET A   1      -7.300  47.817  -9.434  1.00  0.00           H  
ATOM     13  HB2 MET A   1      -5.455  46.351 -10.098  1.00  0.00           H  
ATOM     14  HB3 MET A   1      -4.521  46.869  -8.702  1.00  0.00           H  
ATOM     15  HG2 MET A   1      -6.038  45.799  -7.202  1.00  0.00           H  
ATOM     16  HG3 MET A   1      -7.173  45.462  -8.509  1.00  0.00           H  
ATOM     17  HE1 MET A   1      -6.794  43.657 -10.391  1.00  0.00           H  
ATOM     18  HE2 MET A   1      -5.267  42.805 -10.627  1.00  0.00           H  
ATOM     19  HE3 MET A   1      -5.347  44.550 -10.861  1.00  0.00           H  
ATOM     20  N   GLU A   2      -5.328  48.700  -6.914  1.00  0.00           N  
ATOM     21  CA  GLU A   2      -5.307  49.167  -5.522  1.00  0.00           C  
ATOM     22  C   GLU A   2      -6.006  48.184  -4.579  1.00  0.00           C  
ATOM     23  O   GLU A   2      -6.387  47.081  -4.972  1.00  0.00           O  
ATOM     24  CB  GLU A   2      -5.951  50.555  -5.381  1.00  0.00           C  
ATOM     25  CG  GLU A   2      -5.082  51.709  -5.867  1.00  0.00           C  
ATOM     26  CD  GLU A   2      -4.908  51.736  -7.368  1.00  0.00           C  
ATOM     27  OE1 GLU A   2      -5.810  52.248  -8.063  1.00  0.00           O  
ATOM     28  OE2 GLU A   2      -3.865  51.261  -7.861  1.00  0.00           O  
ATOM     29  H   GLU A   2      -4.472  48.551  -7.370  1.00  0.00           H  
ATOM     30  HA  GLU A   2      -4.271  49.238  -5.224  1.00  0.00           H  
ATOM     31  HB2 GLU A   2      -6.871  50.569  -5.947  1.00  0.00           H  
ATOM     32  HB3 GLU A   2      -6.182  50.722  -4.339  1.00  0.00           H  
ATOM     33  HG2 GLU A   2      -5.537  52.637  -5.558  1.00  0.00           H  
ATOM     34  HG3 GLU A   2      -4.106  51.621  -5.409  1.00  0.00           H  
ATOM     35  N   ILE A   3      -6.143  48.594  -3.323  1.00  0.00           N  
ATOM     36  CA  ILE A   3      -6.846  47.809  -2.321  1.00  0.00           C  
ATOM     37  C   ILE A   3      -7.831  48.705  -1.580  1.00  0.00           C  
ATOM     38  O   ILE A   3      -7.428  49.642  -0.887  1.00  0.00           O  
ATOM     39  CB  ILE A   3      -5.880  47.165  -1.295  1.00  0.00           C  
ATOM     40  CG1 ILE A   3      -4.832  46.303  -2.009  1.00  0.00           C  
ATOM     41  CG2 ILE A   3      -6.659  46.324  -0.287  1.00  0.00           C  
ATOM     42  CD1 ILE A   3      -3.811  45.687  -1.079  1.00  0.00           C  
ATOM     43  H   ILE A   3      -5.768  49.461  -3.064  1.00  0.00           H  
ATOM     44  HA  ILE A   3      -7.390  47.022  -2.826  1.00  0.00           H  
ATOM     45  HB  ILE A   3      -5.381  47.957  -0.756  1.00  0.00           H  
ATOM     46 HG12 ILE A   3      -5.331  45.499  -2.528  1.00  0.00           H  
ATOM     47 HG13 ILE A   3      -4.303  46.914  -2.726  1.00  0.00           H  
ATOM     48 HG21 ILE A   3      -7.203  45.549  -0.808  1.00  0.00           H  
ATOM     49 HG22 ILE A   3      -7.356  46.956   0.245  1.00  0.00           H  
ATOM     50 HG23 ILE A   3      -5.973  45.874   0.416  1.00  0.00           H  
ATOM     51 HD11 ILE A   3      -4.316  45.066  -0.353  1.00  0.00           H  
ATOM     52 HD12 ILE A   3      -3.272  46.472  -0.568  1.00  0.00           H  
ATOM     53 HD13 ILE A   3      -3.121  45.086  -1.651  1.00  0.00           H  
ATOM     54  N   THR A   4      -9.116  48.437  -1.748  1.00  0.00           N  
ATOM     55  CA  THR A   4     -10.147  49.242  -1.114  1.00  0.00           C  
ATOM     56  C   THR A   4     -11.259  48.364  -0.562  1.00  0.00           C  
ATOM     57  O   THR A   4     -11.476  47.252  -1.044  1.00  0.00           O  
ATOM     58  CB  THR A   4     -10.756  50.263  -2.097  1.00  0.00           C  
ATOM     59  OG1 THR A   4     -11.164  49.604  -3.301  1.00  0.00           O  
ATOM     60  CG2 THR A   4      -9.765  51.371  -2.426  1.00  0.00           C  
ATOM     61  H   THR A   4      -9.380  47.675  -2.306  1.00  0.00           H  
ATOM     62  HA  THR A   4      -9.692  49.785  -0.297  1.00  0.00           H  
ATOM     63  HB  THR A   4     -11.625  50.709  -1.633  1.00  0.00           H  
ATOM     64  HG1 THR A   4     -11.327  48.672  -3.116  1.00  0.00           H  
ATOM     65 HG21 THR A   4      -9.512  51.907  -1.522  1.00  0.00           H  
ATOM     66 HG22 THR A   4     -10.210  52.053  -3.136  1.00  0.00           H  
ATOM     67 HG23 THR A   4      -8.872  50.939  -2.851  1.00  0.00           H  
ATOM     68  N   CYS A   5     -11.950  48.874   0.448  1.00  0.00           N  
ATOM     69  CA  CYS A   5     -13.088  48.186   1.034  1.00  0.00           C  
ATOM     70  C   CYS A   5     -14.218  48.096   0.015  1.00  0.00           C  
ATOM     71  O   CYS A   5     -14.493  49.066  -0.697  1.00  0.00           O  
ATOM     72  CB  CYS A   5     -13.560  48.934   2.292  1.00  0.00           C  
ATOM     73  SG  CYS A   5     -15.071  48.282   3.049  1.00  0.00           S  
ATOM     74  H   CYS A   5     -11.689  49.743   0.810  1.00  0.00           H  
ATOM     75  HA  CYS A   5     -12.773  47.189   1.309  1.00  0.00           H  
ATOM     76  HB2 CYS A   5     -12.781  48.891   3.040  1.00  0.00           H  
ATOM     77  HB3 CYS A   5     -13.742  49.968   2.035  1.00  0.00           H  
ATOM     78  N   PRO A   6     -14.878  46.930  -0.080  1.00  0.00           N  
ATOM     79  CA  PRO A   6     -16.019  46.728  -0.983  1.00  0.00           C  
ATOM     80  C   PRO A   6     -17.229  47.572  -0.580  1.00  0.00           C  
ATOM     81  O   PRO A   6     -18.250  47.586  -1.266  1.00  0.00           O  
ATOM     82  CB  PRO A   6     -16.338  45.231  -0.847  1.00  0.00           C  
ATOM     83  CG  PRO A   6     -15.132  44.631  -0.208  1.00  0.00           C  
ATOM     84  CD  PRO A   6     -14.552  45.704   0.664  1.00  0.00           C  
ATOM     85  HA  PRO A   6     -15.756  46.951  -2.007  1.00  0.00           H  
ATOM     86  HB2 PRO A   6     -17.216  45.104  -0.231  1.00  0.00           H  
ATOM     87  HB3 PRO A   6     -16.516  44.810  -1.825  1.00  0.00           H  
ATOM     88  HG2 PRO A   6     -15.419  43.776   0.388  1.00  0.00           H  
ATOM     89  HG3 PRO A   6     -14.423  44.340  -0.967  1.00  0.00           H  
ATOM     90  HD2 PRO A   6     -15.024  45.704   1.637  1.00  0.00           H  
ATOM     91  HD3 PRO A   6     -13.484  45.583   0.758  1.00  0.00           H  
ATOM     92  N   VAL A   7     -17.100  48.276   0.536  1.00  0.00           N  
ATOM     93  CA  VAL A   7     -18.153  49.142   1.026  1.00  0.00           C  
ATOM     94  C   VAL A   7     -17.724  50.591   0.875  1.00  0.00           C  
ATOM     95  O   VAL A   7     -18.348  51.365   0.148  1.00  0.00           O  
ATOM     96  CB  VAL A   7     -18.489  48.861   2.508  1.00  0.00           C  
ATOM     97  CG1 VAL A   7     -19.662  49.714   2.969  1.00  0.00           C  
ATOM     98  CG2 VAL A   7     -18.781  47.386   2.725  1.00  0.00           C  
ATOM     99  H   VAL A   7     -16.255  48.229   1.033  1.00  0.00           H  
ATOM    100  HA  VAL A   7     -19.038  48.969   0.431  1.00  0.00           H  
ATOM    101  HB  VAL A   7     -17.629  49.126   3.104  1.00  0.00           H  
ATOM    102 HG11 VAL A   7     -19.909  49.465   3.990  1.00  0.00           H  
ATOM    103 HG12 VAL A   7     -20.516  49.525   2.334  1.00  0.00           H  
ATOM    104 HG13 VAL A   7     -19.393  50.759   2.908  1.00  0.00           H  
ATOM    105 HG21 VAL A   7     -19.024  47.216   3.763  1.00  0.00           H  
ATOM    106 HG22 VAL A   7     -17.911  46.804   2.459  1.00  0.00           H  
ATOM    107 HG23 VAL A   7     -19.616  47.089   2.108  1.00  0.00           H  
ATOM    108  N   CYS A   8     -16.639  50.947   1.547  1.00  0.00           N  
ATOM    109  CA  CYS A   8     -16.118  52.299   1.486  1.00  0.00           C  
ATOM    110  C   CYS A   8     -14.838  52.353   0.655  1.00  0.00           C  
ATOM    111  O   CYS A   8     -13.740  52.074   1.145  1.00  0.00           O  
ATOM    112  CB  CYS A   8     -15.872  52.837   2.898  1.00  0.00           C  
ATOM    113  SG  CYS A   8     -14.780  51.808   3.910  1.00  0.00           S  
ATOM    114  H   CYS A   8     -16.178  50.281   2.103  1.00  0.00           H  
ATOM    115  HA  CYS A   8     -16.864  52.913   1.006  1.00  0.00           H  
ATOM    116  HB2 CYS A   8     -15.424  53.817   2.828  1.00  0.00           H  
ATOM    117  HB3 CYS A   8     -16.819  52.916   3.412  1.00  0.00           H  
ATOM    118  N   HIS A   9     -14.992  52.682  -0.617  1.00  0.00           N  
ATOM    119  CA  HIS A   9     -13.850  52.837  -1.511  1.00  0.00           C  
ATOM    120  C   HIS A   9     -13.048  54.088  -1.142  1.00  0.00           C  
ATOM    121  O   HIS A   9     -13.286  55.172  -1.670  1.00  0.00           O  
ATOM    122  CB  HIS A   9     -14.317  52.908  -2.978  1.00  0.00           C  
ATOM    123  CG  HIS A   9     -13.203  52.937  -3.994  1.00  0.00           C  
ATOM    124  ND1 HIS A   9     -12.837  51.840  -4.749  1.00  0.00           N  
ATOM    125  CD2 HIS A   9     -12.383  53.945  -4.388  1.00  0.00           C  
ATOM    126  CE1 HIS A   9     -11.845  52.173  -5.555  1.00  0.00           C  
ATOM    127  NE2 HIS A   9     -11.552  53.443  -5.355  1.00  0.00           N  
ATOM    128  H   HIS A   9     -15.902  52.809  -0.970  1.00  0.00           H  
ATOM    129  HA  HIS A   9     -13.217  51.970  -1.387  1.00  0.00           H  
ATOM    130  HB2 HIS A   9     -14.930  52.046  -3.192  1.00  0.00           H  
ATOM    131  HB3 HIS A   9     -14.909  53.802  -3.112  1.00  0.00           H  
ATOM    132  HD1 HIS A   9     -13.248  50.950  -4.709  1.00  0.00           H  
ATOM    133  HD2 HIS A   9     -12.389  54.956  -4.012  1.00  0.00           H  
ATOM    134  HE1 HIS A   9     -11.360  51.518  -6.263  1.00  0.00           H  
ATOM    135  HE2 HIS A   9     -10.943  53.981  -5.920  1.00  0.00           H  
ATOM    136  N   HIS A  10     -12.143  53.941  -0.186  1.00  0.00           N  
ATOM    137  CA  HIS A  10     -11.204  55.004   0.151  1.00  0.00           C  
ATOM    138  C   HIS A  10      -9.784  54.531  -0.131  1.00  0.00           C  
ATOM    139  O   HIS A  10      -9.235  54.787  -1.204  1.00  0.00           O  
ATOM    140  CB  HIS A  10     -11.324  55.426   1.626  1.00  0.00           C  
ATOM    141  CG  HIS A  10     -12.624  56.080   2.010  1.00  0.00           C  
ATOM    142  ND1 HIS A  10     -13.471  56.705   1.117  1.00  0.00           N  
ATOM    143  CD2 HIS A  10     -13.212  56.204   3.223  1.00  0.00           C  
ATOM    144  CE1 HIS A  10     -14.518  57.180   1.770  1.00  0.00           C  
ATOM    145  NE2 HIS A  10     -14.384  56.890   3.047  1.00  0.00           N  
ATOM    146  H   HIS A  10     -12.115  53.097   0.316  1.00  0.00           H  
ATOM    147  HA  HIS A  10     -11.421  55.851  -0.480  1.00  0.00           H  
ATOM    148  HB2 HIS A  10     -11.210  54.551   2.245  1.00  0.00           H  
ATOM    149  HB3 HIS A  10     -10.527  56.120   1.853  1.00  0.00           H  
ATOM    150  HD1 HIS A  10     -13.319  56.809   0.148  1.00  0.00           H  
ATOM    151  HD2 HIS A  10     -12.825  55.828   4.160  1.00  0.00           H  
ATOM    152  HE1 HIS A  10     -15.347  57.713   1.330  1.00  0.00           H  
ATOM    153  HE2 HIS A  10     -14.903  57.314   3.775  1.00  0.00           H  
ATOM    154  N   ALA A  11      -9.215  53.816   0.836  1.00  0.00           N  
ATOM    155  CA  ALA A  11      -7.877  53.250   0.718  1.00  0.00           C  
ATOM    156  C   ALA A  11      -7.594  52.331   1.901  1.00  0.00           C  
ATOM    157  O   ALA A  11      -7.733  52.737   3.054  1.00  0.00           O  
ATOM    158  CB  ALA A  11      -6.829  54.353   0.653  1.00  0.00           C  
ATOM    159  H   ALA A  11      -9.710  53.669   1.666  1.00  0.00           H  
ATOM    160  HA  ALA A  11      -7.830  52.678  -0.196  1.00  0.00           H  
ATOM    161  HB1 ALA A  11      -6.857  54.931   1.565  1.00  0.00           H  
ATOM    162  HB2 ALA A  11      -7.038  54.998  -0.188  1.00  0.00           H  
ATOM    163  HB3 ALA A  11      -5.850  53.913   0.535  1.00  0.00           H  
ATOM    164  N   LEU A  12      -7.233  51.090   1.613  1.00  0.00           N  
ATOM    165  CA  LEU A  12      -6.883  50.132   2.654  1.00  0.00           C  
ATOM    166  C   LEU A  12      -5.371  49.988   2.742  1.00  0.00           C  
ATOM    167  O   LEU A  12      -4.700  49.792   1.727  1.00  0.00           O  
ATOM    168  CB  LEU A  12      -7.524  48.768   2.374  1.00  0.00           C  
ATOM    169  CG  LEU A  12      -8.903  48.532   3.001  1.00  0.00           C  
ATOM    170  CD1 LEU A  12      -9.853  49.678   2.698  1.00  0.00           C  
ATOM    171  CD2 LEU A  12      -9.482  47.219   2.500  1.00  0.00           C  
ATOM    172  H   LEU A  12      -7.186  50.808   0.673  1.00  0.00           H  
ATOM    173  HA  LEU A  12      -7.254  50.511   3.595  1.00  0.00           H  
ATOM    174  HB2 LEU A  12      -7.618  48.655   1.304  1.00  0.00           H  
ATOM    175  HB3 LEU A  12      -6.855  48.002   2.740  1.00  0.00           H  
ATOM    176  HG  LEU A  12      -8.800  48.461   4.072  1.00  0.00           H  
ATOM    177 HD11 LEU A  12      -9.974  49.775   1.628  1.00  0.00           H  
ATOM    178 HD12 LEU A  12      -9.450  50.596   3.099  1.00  0.00           H  
ATOM    179 HD13 LEU A  12     -10.814  49.478   3.152  1.00  0.00           H  
ATOM    180 HD21 LEU A  12     -10.454  47.062   2.943  1.00  0.00           H  
ATOM    181 HD22 LEU A  12      -8.826  46.408   2.778  1.00  0.00           H  
ATOM    182 HD23 LEU A  12      -9.577  47.254   1.424  1.00  0.00           H  
ATOM    183  N   GLU A  13      -4.839  50.086   3.949  1.00  0.00           N  
ATOM    184  CA  GLU A  13      -3.400  50.028   4.142  1.00  0.00           C  
ATOM    185  C   GLU A  13      -2.963  48.611   4.493  1.00  0.00           C  
ATOM    186  O   GLU A  13      -3.575  47.945   5.330  1.00  0.00           O  
ATOM    187  CB  GLU A  13      -2.966  51.011   5.232  1.00  0.00           C  
ATOM    188  CG  GLU A  13      -1.460  51.139   5.370  1.00  0.00           C  
ATOM    189  CD  GLU A  13      -1.056  52.233   6.333  1.00  0.00           C  
ATOM    190  OE1 GLU A  13      -0.978  51.966   7.549  1.00  0.00           O  
ATOM    191  OE2 GLU A  13      -0.807  53.371   5.877  1.00  0.00           O  
ATOM    192  H   GLU A  13      -5.426  50.186   4.729  1.00  0.00           H  
ATOM    193  HA  GLU A  13      -2.933  50.313   3.210  1.00  0.00           H  
ATOM    194  HB2 GLU A  13      -3.368  51.986   5.001  1.00  0.00           H  
ATOM    195  HB3 GLU A  13      -3.366  50.681   6.178  1.00  0.00           H  
ATOM    196  HG2 GLU A  13      -1.062  50.200   5.726  1.00  0.00           H  
ATOM    197  HG3 GLU A  13      -1.040  51.360   4.399  1.00  0.00           H  
ATOM    198  N   ARG A  14      -1.904  48.156   3.841  1.00  0.00           N  
ATOM    199  CA  ARG A  14      -1.402  46.806   4.033  1.00  0.00           C  
ATOM    200  C   ARG A  14      -0.217  46.815   4.996  1.00  0.00           C  
ATOM    201  O   ARG A  14       0.731  47.574   4.804  1.00  0.00           O  
ATOM    202  CB  ARG A  14      -0.972  46.225   2.682  1.00  0.00           C  
ATOM    203  CG  ARG A  14      -0.742  44.725   2.697  1.00  0.00           C  
ATOM    204  CD  ARG A  14      -2.053  43.962   2.772  1.00  0.00           C  
ATOM    205  NE  ARG A  14      -1.853  42.516   2.899  1.00  0.00           N  
ATOM    206  CZ  ARG A  14      -1.545  41.705   1.882  1.00  0.00           C  
ATOM    207  NH1 ARG A  14      -1.302  42.202   0.670  1.00  0.00           N  
ATOM    208  NH2 ARG A  14      -1.458  40.394   2.085  1.00  0.00           N  
ATOM    209  H   ARG A  14      -1.439  48.753   3.217  1.00  0.00           H  
ATOM    210  HA  ARG A  14      -2.197  46.202   4.445  1.00  0.00           H  
ATOM    211  HB2 ARG A  14      -1.737  46.442   1.951  1.00  0.00           H  
ATOM    212  HB3 ARG A  14      -0.052  46.703   2.376  1.00  0.00           H  
ATOM    213  HG2 ARG A  14      -0.224  44.441   1.793  1.00  0.00           H  
ATOM    214  HG3 ARG A  14      -0.138  44.470   3.552  1.00  0.00           H  
ATOM    215  HD2 ARG A  14      -2.608  44.313   3.628  1.00  0.00           H  
ATOM    216  HD3 ARG A  14      -2.619  44.159   1.874  1.00  0.00           H  
ATOM    217  HE  ARG A  14      -1.988  42.125   3.790  1.00  0.00           H  
ATOM    218 HH11 ARG A  14      -1.346  43.197   0.509  1.00  0.00           H  
ATOM    219 HH12 ARG A  14      -1.073  41.592  -0.090  1.00  0.00           H  
ATOM    220 HH21 ARG A  14      -1.625  40.011   2.999  1.00  0.00           H  
ATOM    221 HH22 ARG A  14      -1.227  39.781   1.329  1.00  0.00           H  
ATOM    222  N   ASN A  15      -0.268  45.979   6.028  1.00  0.00           N  
ATOM    223  CA  ASN A  15       0.836  45.881   6.984  1.00  0.00           C  
ATOM    224  C   ASN A  15       1.568  44.558   6.782  1.00  0.00           C  
ATOM    225  O   ASN A  15       2.555  44.254   7.447  1.00  0.00           O  
ATOM    226  CB  ASN A  15       0.298  45.972   8.421  1.00  0.00           C  
ATOM    227  CG  ASN A  15       1.396  45.968   9.478  1.00  0.00           C  
ATOM    228  OD1 ASN A  15       2.494  46.487   9.265  1.00  0.00           O  
ATOM    229  ND2 ASN A  15       1.108  45.371  10.625  1.00  0.00           N  
ATOM    230  H   ASN A  15      -1.065  45.412   6.156  1.00  0.00           H  
ATOM    231  HA  ASN A  15       1.518  46.698   6.800  1.00  0.00           H  
ATOM    232  HB2 ASN A  15      -0.268  46.885   8.528  1.00  0.00           H  
ATOM    233  HB3 ASN A  15      -0.352  45.130   8.605  1.00  0.00           H  
ATOM    234 HD21 ASN A  15       0.212  44.971  10.730  1.00  0.00           H  
ATOM    235 HD22 ASN A  15       1.798  45.338  11.321  1.00  0.00           H  
ATOM    236  N   GLY A  16       1.085  43.792   5.826  1.00  0.00           N  
ATOM    237  CA  GLY A  16       1.558  42.440   5.655  1.00  0.00           C  
ATOM    238  C   GLY A  16       0.593  41.482   6.303  1.00  0.00           C  
ATOM    239  O   GLY A  16       0.128  41.752   7.412  1.00  0.00           O  
ATOM    240  H   GLY A  16       0.396  44.144   5.237  1.00  0.00           H  
ATOM    241  HA2 GLY A  16       1.634  42.218   4.600  1.00  0.00           H  
ATOM    242  HA3 GLY A  16       2.526  42.337   6.118  1.00  0.00           H  
ATOM    243  N   ASP A  17       0.266  40.392   5.610  1.00  0.00           N  
ATOM    244  CA  ASP A  17      -0.757  39.444   6.074  1.00  0.00           C  
ATOM    245  C   ASP A  17      -2.156  40.070   6.015  1.00  0.00           C  
ATOM    246  O   ASP A  17      -3.019  39.604   5.272  1.00  0.00           O  
ATOM    247  CB  ASP A  17      -0.436  38.939   7.493  1.00  0.00           C  
ATOM    248  CG  ASP A  17      -1.615  38.272   8.180  1.00  0.00           C  
ATOM    249  OD1 ASP A  17      -1.926  37.108   7.861  1.00  0.00           O  
ATOM    250  OD2 ASP A  17      -2.227  38.917   9.062  1.00  0.00           O  
ATOM    251  H   ASP A  17       0.734  40.207   4.771  1.00  0.00           H  
ATOM    252  HA  ASP A  17      -0.739  38.599   5.398  1.00  0.00           H  
ATOM    253  HB2 ASP A  17       0.369  38.223   7.436  1.00  0.00           H  
ATOM    254  HB3 ASP A  17      -0.121  39.776   8.099  1.00  0.00           H  
ATOM    255  N   THR A  18      -2.360  41.160   6.740  1.00  0.00           N  
ATOM    256  CA  THR A  18      -3.671  41.774   6.847  1.00  0.00           C  
ATOM    257  C   THR A  18      -3.650  43.220   6.345  1.00  0.00           C  
ATOM    258  O   THR A  18      -2.643  43.924   6.474  1.00  0.00           O  
ATOM    259  CB  THR A  18      -4.165  41.725   8.314  1.00  0.00           C  
ATOM    260  OG1 THR A  18      -4.340  40.362   8.720  1.00  0.00           O  
ATOM    261  CG2 THR A  18      -5.475  42.479   8.500  1.00  0.00           C  
ATOM    262  H   THR A  18      -1.597  41.577   7.208  1.00  0.00           H  
ATOM    263  HA  THR A  18      -4.359  41.203   6.240  1.00  0.00           H  
ATOM    264  HB  THR A  18      -3.414  42.182   8.942  1.00  0.00           H  
ATOM    265  HG1 THR A  18      -3.483  39.898   8.686  1.00  0.00           H  
ATOM    266 HG21 THR A  18      -6.230  42.059   7.851  1.00  0.00           H  
ATOM    267 HG22 THR A  18      -5.328  43.521   8.256  1.00  0.00           H  
ATOM    268 HG23 THR A  18      -5.796  42.394   9.528  1.00  0.00           H  
ATOM    269  N   ALA A  19      -4.750  43.632   5.728  1.00  0.00           N  
ATOM    270  CA  ALA A  19      -4.946  45.013   5.323  1.00  0.00           C  
ATOM    271  C   ALA A  19      -6.044  45.634   6.176  1.00  0.00           C  
ATOM    272  O   ALA A  19      -7.097  45.027   6.373  1.00  0.00           O  
ATOM    273  CB  ALA A  19      -5.309  45.090   3.848  1.00  0.00           C  
ATOM    274  H   ALA A  19      -5.469  42.980   5.552  1.00  0.00           H  
ATOM    275  HA  ALA A  19      -4.021  45.550   5.482  1.00  0.00           H  
ATOM    276  HB1 ALA A  19      -4.526  44.629   3.262  1.00  0.00           H  
ATOM    277  HB2 ALA A  19      -5.416  46.125   3.556  1.00  0.00           H  
ATOM    278  HB3 ALA A  19      -6.238  44.569   3.679  1.00  0.00           H  
ATOM    279  N   HIS A  20      -5.803  46.828   6.688  1.00  0.00           N  
ATOM    280  CA  HIS A  20      -6.743  47.449   7.606  1.00  0.00           C  
ATOM    281  C   HIS A  20      -7.713  48.356   6.866  1.00  0.00           C  
ATOM    282  O   HIS A  20      -7.312  49.186   6.050  1.00  0.00           O  
ATOM    283  CB  HIS A  20      -6.001  48.240   8.686  1.00  0.00           C  
ATOM    284  CG  HIS A  20      -6.894  48.748   9.777  1.00  0.00           C  
ATOM    285  ND1 HIS A  20      -7.319  47.963  10.825  1.00  0.00           N  
ATOM    286  CD2 HIS A  20      -7.439  49.970   9.982  1.00  0.00           C  
ATOM    287  CE1 HIS A  20      -8.084  48.675  11.627  1.00  0.00           C  
ATOM    288  NE2 HIS A  20      -8.174  49.897  11.139  1.00  0.00           N  
ATOM    289  H   HIS A  20      -4.984  47.309   6.430  1.00  0.00           H  
ATOM    290  HA  HIS A  20      -7.306  46.658   8.081  1.00  0.00           H  
ATOM    291  HB2 HIS A  20      -5.252  47.607   9.135  1.00  0.00           H  
ATOM    292  HB3 HIS A  20      -5.517  49.093   8.229  1.00  0.00           H  
ATOM    293  HD1 HIS A  20      -7.101  46.998  10.956  1.00  0.00           H  
ATOM    294  HD2 HIS A  20      -7.322  50.838   9.346  1.00  0.00           H  
ATOM    295  HE1 HIS A  20      -8.556  48.318  12.531  1.00  0.00           H  
ATOM    296  HE2 HIS A  20      -8.538  50.674  11.632  1.00  0.00           H  
ATOM    297  N   CYS A  21      -8.990  48.176   7.157  1.00  0.00           N  
ATOM    298  CA  CYS A  21     -10.033  49.021   6.615  1.00  0.00           C  
ATOM    299  C   CYS A  21     -10.262  50.202   7.552  1.00  0.00           C  
ATOM    300  O   CYS A  21     -10.614  50.018   8.718  1.00  0.00           O  
ATOM    301  CB  CYS A  21     -11.317  48.205   6.441  1.00  0.00           C  
ATOM    302  SG  CYS A  21     -12.685  49.085   5.655  1.00  0.00           S  
ATOM    303  H   CYS A  21      -9.244  47.441   7.762  1.00  0.00           H  
ATOM    304  HA  CYS A  21      -9.705  49.386   5.654  1.00  0.00           H  
ATOM    305  HB2 CYS A  21     -11.099  47.339   5.835  1.00  0.00           H  
ATOM    306  HB3 CYS A  21     -11.655  47.875   7.414  1.00  0.00           H  
ATOM    307  N   GLU A  22     -10.019  51.402   7.029  1.00  0.00           N  
ATOM    308  CA  GLU A  22     -10.179  52.662   7.763  1.00  0.00           C  
ATOM    309  C   GLU A  22     -11.561  52.773   8.433  1.00  0.00           C  
ATOM    310  O   GLU A  22     -11.765  52.280   9.545  1.00  0.00           O  
ATOM    311  CB  GLU A  22      -9.937  53.840   6.801  1.00  0.00           C  
ATOM    312  CG  GLU A  22     -10.213  53.517   5.325  1.00  0.00           C  
ATOM    313  CD  GLU A  22     -11.634  53.042   5.054  1.00  0.00           C  
ATOM    314  OE1 GLU A  22     -12.536  53.860   4.909  1.00  0.00           O  
ATOM    315  OE2 GLU A  22     -11.891  51.842   5.025  1.00  0.00           O  
ATOM    316  H   GLU A  22      -9.722  51.445   6.097  1.00  0.00           H  
ATOM    317  HA  GLU A  22      -9.422  52.688   8.534  1.00  0.00           H  
ATOM    318  HB2 GLU A  22     -10.569  54.664   7.092  1.00  0.00           H  
ATOM    319  HB3 GLU A  22      -8.905  54.149   6.886  1.00  0.00           H  
ATOM    320  HG2 GLU A  22     -10.034  54.404   4.737  1.00  0.00           H  
ATOM    321  HG3 GLU A  22      -9.529  52.742   5.015  1.00  0.00           H  
ATOM    322  N   THR A  23     -12.500  53.444   7.773  1.00  0.00           N  
ATOM    323  CA  THR A  23     -13.891  53.390   8.182  1.00  0.00           C  
ATOM    324  C   THR A  23     -14.359  51.957   8.047  1.00  0.00           C  
ATOM    325  O   THR A  23     -13.962  51.313   7.073  1.00  0.00           O  
ATOM    326  CB  THR A  23     -14.769  54.268   7.281  1.00  0.00           C  
ATOM    327  OG1 THR A  23     -14.798  53.706   5.959  1.00  0.00           O  
ATOM    328  CG2 THR A  23     -14.244  55.694   7.215  1.00  0.00           C  
ATOM    329  H   THR A  23     -12.244  54.004   7.008  1.00  0.00           H  
ATOM    330  HA  THR A  23     -13.978  53.718   9.209  1.00  0.00           H  
ATOM    331  HB  THR A  23     -15.774  54.284   7.682  1.00  0.00           H  
ATOM    332  HG1 THR A  23     -15.507  54.155   5.448  1.00  0.00           H  
ATOM    333 HG21 THR A  23     -14.286  56.143   8.197  1.00  0.00           H  
ATOM    334 HG22 THR A  23     -14.850  56.269   6.530  1.00  0.00           H  
ATOM    335 HG23 THR A  23     -13.220  55.685   6.867  1.00  0.00           H  
ATOM    336  N   CYS A  24     -15.205  51.512   8.984  1.00  0.00           N  
ATOM    337  CA  CYS A  24     -15.676  50.116   9.110  1.00  0.00           C  
ATOM    338  C   CYS A  24     -14.929  49.411  10.239  1.00  0.00           C  
ATOM    339  O   CYS A  24     -15.484  48.527  10.894  1.00  0.00           O  
ATOM    340  CB  CYS A  24     -15.558  49.284   7.813  1.00  0.00           C  
ATOM    341  SG  CYS A  24     -16.533  49.898   6.415  1.00  0.00           S  
ATOM    342  H   CYS A  24     -15.535  52.161   9.642  1.00  0.00           H  
ATOM    343  HA  CYS A  24     -16.721  50.167   9.390  1.00  0.00           H  
ATOM    344  HB2 CYS A  24     -14.525  49.268   7.500  1.00  0.00           H  
ATOM    345  HB3 CYS A  24     -15.878  48.272   8.017  1.00  0.00           H  
ATOM    346  N   ALA A  25     -13.674  49.822  10.468  1.00  0.00           N  
ATOM    347  CA  ALA A  25     -12.842  49.252  11.532  1.00  0.00           C  
ATOM    348  C   ALA A  25     -12.643  47.749  11.331  1.00  0.00           C  
ATOM    349  O   ALA A  25     -12.490  46.989  12.289  1.00  0.00           O  
ATOM    350  CB  ALA A  25     -13.456  49.544  12.898  1.00  0.00           C  
ATOM    351  H   ALA A  25     -13.299  50.533   9.904  1.00  0.00           H  
ATOM    352  HA  ALA A  25     -11.876  49.737  11.489  1.00  0.00           H  
ATOM    353  HB1 ALA A  25     -14.426  49.075  12.964  1.00  0.00           H  
ATOM    354  HB2 ALA A  25     -13.561  50.611  13.024  1.00  0.00           H  
ATOM    355  HB3 ALA A  25     -12.814  49.151  13.671  1.00  0.00           H  
ATOM    356  N   LYS A  26     -12.622  47.339  10.074  1.00  0.00           N  
ATOM    357  CA  LYS A  26     -12.492  45.934   9.719  1.00  0.00           C  
ATOM    358  C   LYS A  26     -11.061  45.624   9.293  1.00  0.00           C  
ATOM    359  O   LYS A  26     -10.397  46.450   8.674  1.00  0.00           O  
ATOM    360  CB  LYS A  26     -13.476  45.601   8.587  1.00  0.00           C  
ATOM    361  CG  LYS A  26     -13.279  44.234   7.941  1.00  0.00           C  
ATOM    362  CD  LYS A  26     -13.645  43.089   8.874  1.00  0.00           C  
ATOM    363  CE  LYS A  26     -13.521  41.750   8.162  1.00  0.00           C  
ATOM    364  NZ  LYS A  26     -13.941  40.611   9.022  1.00  0.00           N  
ATOM    365  H   LYS A  26     -12.679  48.004   9.358  1.00  0.00           H  
ATOM    366  HA  LYS A  26     -12.739  45.343  10.587  1.00  0.00           H  
ATOM    367  HB2 LYS A  26     -14.479  45.638   8.984  1.00  0.00           H  
ATOM    368  HB3 LYS A  26     -13.380  46.353   7.817  1.00  0.00           H  
ATOM    369  HG2 LYS A  26     -13.898  44.173   7.059  1.00  0.00           H  
ATOM    370  HG3 LYS A  26     -12.242  44.135   7.658  1.00  0.00           H  
ATOM    371  HD2 LYS A  26     -12.976  43.098   9.722  1.00  0.00           H  
ATOM    372  HD3 LYS A  26     -14.662  43.219   9.211  1.00  0.00           H  
ATOM    373  HE2 LYS A  26     -14.142  41.768   7.278  1.00  0.00           H  
ATOM    374  HE3 LYS A  26     -12.490  41.609   7.873  1.00  0.00           H  
ATOM    375  HZ1 LYS A  26     -13.941  39.726   8.467  1.00  0.00           H  
ATOM    376  HZ2 LYS A  26     -14.901  40.773   9.394  1.00  0.00           H  
ATOM    377  HZ3 LYS A  26     -13.279  40.505   9.822  1.00  0.00           H  
ATOM    378  N   ASP A  27     -10.578  44.448   9.651  1.00  0.00           N  
ATOM    379  CA  ASP A  27      -9.273  43.998   9.197  1.00  0.00           C  
ATOM    380  C   ASP A  27      -9.440  42.843   8.227  1.00  0.00           C  
ATOM    381  O   ASP A  27     -10.100  41.850   8.535  1.00  0.00           O  
ATOM    382  CB  ASP A  27      -8.391  43.573  10.373  1.00  0.00           C  
ATOM    383  CG  ASP A  27      -7.966  44.745  11.235  1.00  0.00           C  
ATOM    384  OD1 ASP A  27      -6.960  45.403  10.899  1.00  0.00           O  
ATOM    385  OD2 ASP A  27      -8.641  45.016  12.250  1.00  0.00           O  
ATOM    386  H   ASP A  27     -11.105  43.870  10.241  1.00  0.00           H  
ATOM    387  HA  ASP A  27      -8.802  44.822   8.679  1.00  0.00           H  
ATOM    388  HB2 ASP A  27      -8.939  42.880  10.991  1.00  0.00           H  
ATOM    389  HB3 ASP A  27      -7.504  43.089   9.992  1.00  0.00           H  
ATOM    390  N   PHE A  28      -8.869  42.988   7.046  1.00  0.00           N  
ATOM    391  CA  PHE A  28      -8.962  41.958   6.024  1.00  0.00           C  
ATOM    392  C   PHE A  28      -7.666  41.167   5.955  1.00  0.00           C  
ATOM    393  O   PHE A  28      -6.653  41.669   5.471  1.00  0.00           O  
ATOM    394  CB  PHE A  28      -9.247  42.578   4.655  1.00  0.00           C  
ATOM    395  CG  PHE A  28     -10.549  43.324   4.566  1.00  0.00           C  
ATOM    396  CD1 PHE A  28     -11.742  42.645   4.368  1.00  0.00           C  
ATOM    397  CD2 PHE A  28     -10.579  44.704   4.662  1.00  0.00           C  
ATOM    398  CE1 PHE A  28     -12.937  43.331   4.265  1.00  0.00           C  
ATOM    399  CE2 PHE A  28     -11.770  45.394   4.564  1.00  0.00           C  
ATOM    400  CZ  PHE A  28     -12.949  44.708   4.364  1.00  0.00           C  
ATOM    401  H   PHE A  28      -8.360  43.810   6.855  1.00  0.00           H  
ATOM    402  HA  PHE A  28      -9.769  41.291   6.288  1.00  0.00           H  
ATOM    403  HB2 PHE A  28      -8.456  43.271   4.413  1.00  0.00           H  
ATOM    404  HB3 PHE A  28      -9.265  41.792   3.914  1.00  0.00           H  
ATOM    405  HD1 PHE A  28     -11.732  41.567   4.291  1.00  0.00           H  
ATOM    406  HD2 PHE A  28      -9.656  45.244   4.819  1.00  0.00           H  
ATOM    407  HE1 PHE A  28     -13.859  42.792   4.111  1.00  0.00           H  
ATOM    408  HE2 PHE A  28     -11.778  46.472   4.642  1.00  0.00           H  
ATOM    409  HZ  PHE A  28     -13.878  45.248   4.282  1.00  0.00           H  
ATOM    410  N   SER A  29      -7.687  39.947   6.460  1.00  0.00           N  
ATOM    411  CA  SER A  29      -6.525  39.082   6.376  1.00  0.00           C  
ATOM    412  C   SER A  29      -6.490  38.378   5.024  1.00  0.00           C  
ATOM    413  O   SER A  29      -7.464  37.738   4.617  1.00  0.00           O  
ATOM    414  CB  SER A  29      -6.546  38.067   7.516  1.00  0.00           C  
ATOM    415  OG  SER A  29      -6.568  38.726   8.774  1.00  0.00           O  
ATOM    416  H   SER A  29      -8.499  39.619   6.902  1.00  0.00           H  
ATOM    417  HA  SER A  29      -5.644  39.701   6.470  1.00  0.00           H  
ATOM    418  HB2 SER A  29      -7.429  37.450   7.429  1.00  0.00           H  
ATOM    419  HB3 SER A  29      -5.664  37.447   7.460  1.00  0.00           H  
ATOM    420  HG  SER A  29      -5.860  39.391   8.795  1.00  0.00           H  
ATOM    421  N   LEU A  30      -5.378  38.516   4.322  1.00  0.00           N  
ATOM    422  CA  LEU A  30      -5.235  37.921   3.008  1.00  0.00           C  
ATOM    423  C   LEU A  30      -4.353  36.689   3.089  1.00  0.00           C  
ATOM    424  O   LEU A  30      -3.323  36.696   3.762  1.00  0.00           O  
ATOM    425  CB  LEU A  30      -4.634  38.916   2.004  1.00  0.00           C  
ATOM    426  CG  LEU A  30      -5.429  40.209   1.787  1.00  0.00           C  
ATOM    427  CD1 LEU A  30      -5.082  41.251   2.837  1.00  0.00           C  
ATOM    428  CD2 LEU A  30      -5.177  40.756   0.389  1.00  0.00           C  
ATOM    429  H   LEU A  30      -4.620  39.009   4.711  1.00  0.00           H  
ATOM    430  HA  LEU A  30      -6.217  37.626   2.668  1.00  0.00           H  
ATOM    431  HB2 LEU A  30      -3.645  39.182   2.344  1.00  0.00           H  
ATOM    432  HB3 LEU A  30      -4.543  38.414   1.050  1.00  0.00           H  
ATOM    433  HG  LEU A  30      -6.483  39.992   1.874  1.00  0.00           H  
ATOM    434 HD11 LEU A  30      -5.275  40.850   3.821  1.00  0.00           H  
ATOM    435 HD12 LEU A  30      -5.686  42.133   2.684  1.00  0.00           H  
ATOM    436 HD13 LEU A  30      -4.036  41.512   2.752  1.00  0.00           H  
ATOM    437 HD21 LEU A  30      -5.753  41.658   0.247  1.00  0.00           H  
ATOM    438 HD22 LEU A  30      -5.474  40.020  -0.345  1.00  0.00           H  
ATOM    439 HD23 LEU A  30      -4.126  40.977   0.273  1.00  0.00           H  
ATOM    440  N   GLN A  31      -4.746  35.636   2.398  1.00  0.00           N  
ATOM    441  CA  GLN A  31      -3.983  34.404   2.406  1.00  0.00           C  
ATOM    442  C   GLN A  31      -3.355  34.174   1.045  1.00  0.00           C  
ATOM    443  O   GLN A  31      -3.955  34.485   0.014  1.00  0.00           O  
ATOM    444  CB  GLN A  31      -4.869  33.220   2.796  1.00  0.00           C  
ATOM    445  CG  GLN A  31      -5.544  33.383   4.147  1.00  0.00           C  
ATOM    446  CD  GLN A  31      -6.279  32.131   4.585  1.00  0.00           C  
ATOM    447  OE1 GLN A  31      -5.874  31.016   4.268  1.00  0.00           O  
ATOM    448  NE2 GLN A  31      -7.375  32.307   5.304  1.00  0.00           N  
ATOM    449  H   GLN A  31      -5.572  35.690   1.860  1.00  0.00           H  
ATOM    450  HA  GLN A  31      -3.196  34.512   3.141  1.00  0.00           H  
ATOM    451  HB2 GLN A  31      -5.636  33.099   2.046  1.00  0.00           H  
ATOM    452  HB3 GLN A  31      -4.262  32.328   2.825  1.00  0.00           H  
ATOM    453  HG2 GLN A  31      -4.791  33.617   4.887  1.00  0.00           H  
ATOM    454  HG3 GLN A  31      -6.251  34.195   4.086  1.00  0.00           H  
ATOM    455 HE21 GLN A  31      -7.654  33.227   5.514  1.00  0.00           H  
ATOM    456 HE22 GLN A  31      -7.865  31.512   5.603  1.00  0.00           H  
ATOM    457  N   ALA A  32      -2.141  33.654   1.051  1.00  0.00           N  
ATOM    458  CA  ALA A  32      -1.400  33.420  -0.176  1.00  0.00           C  
ATOM    459  C   ALA A  32      -1.764  32.065  -0.771  1.00  0.00           C  
ATOM    460  O   ALA A  32      -1.406  31.020  -0.231  1.00  0.00           O  
ATOM    461  CB  ALA A  32       0.095  33.517   0.099  1.00  0.00           C  
ATOM    462  H   ALA A  32      -1.731  33.408   1.905  1.00  0.00           H  
ATOM    463  HA  ALA A  32      -1.666  34.196  -0.881  1.00  0.00           H  
ATOM    464  HB1 ALA A  32       0.637  33.008  -0.681  1.00  0.00           H  
ATOM    465  HB2 ALA A  32       0.319  33.064   1.051  1.00  0.00           H  
ATOM    466  HB3 ALA A  32       0.389  34.555   0.120  1.00  0.00           H  
ATOM    467  N   LEU A  33      -2.504  32.097  -1.871  1.00  0.00           N  
ATOM    468  CA  LEU A  33      -2.941  30.886  -2.556  1.00  0.00           C  
ATOM    469  C   LEU A  33      -2.270  30.759  -3.921  1.00  0.00           C  
ATOM    470  O   LEU A  33      -1.800  31.752  -4.490  1.00  0.00           O  
ATOM    471  CB  LEU A  33      -4.468  30.902  -2.751  1.00  0.00           C  
ATOM    472  CG  LEU A  33      -5.317  30.322  -1.607  1.00  0.00           C  
ATOM    473  CD1 LEU A  33      -4.993  30.985  -0.276  1.00  0.00           C  
ATOM    474  CD2 LEU A  33      -6.795  30.486  -1.924  1.00  0.00           C  
ATOM    475  H   LEU A  33      -2.772  32.969  -2.236  1.00  0.00           H  
ATOM    476  HA  LEU A  33      -2.670  30.034  -1.949  1.00  0.00           H  
ATOM    477  HB2 LEU A  33      -4.772  31.927  -2.903  1.00  0.00           H  
ATOM    478  HB3 LEU A  33      -4.694  30.347  -3.648  1.00  0.00           H  
ATOM    479  HG  LEU A  33      -5.116  29.266  -1.518  1.00  0.00           H  
ATOM    480 HD11 LEU A  33      -5.215  32.042  -0.333  1.00  0.00           H  
ATOM    481 HD12 LEU A  33      -3.946  30.850  -0.049  1.00  0.00           H  
ATOM    482 HD13 LEU A  33      -5.590  30.534   0.504  1.00  0.00           H  
ATOM    483 HD21 LEU A  33      -7.026  29.971  -2.844  1.00  0.00           H  
ATOM    484 HD22 LEU A  33      -7.023  31.536  -2.032  1.00  0.00           H  
ATOM    485 HD23 LEU A  33      -7.386  30.071  -1.120  1.00  0.00           H  
ATOM    486  N   CYS A  34      -2.224  29.543  -4.443  1.00  0.00           N  
ATOM    487  CA  CYS A  34      -1.780  29.309  -5.807  1.00  0.00           C  
ATOM    488  C   CYS A  34      -2.985  29.203  -6.730  1.00  0.00           C  
ATOM    489  O   CYS A  34      -4.069  28.805  -6.298  1.00  0.00           O  
ATOM    490  CB  CYS A  34      -0.940  28.033  -5.912  1.00  0.00           C  
ATOM    491  SG  CYS A  34       0.733  28.160  -5.235  1.00  0.00           S  
ATOM    492  H   CYS A  34      -2.504  28.778  -3.897  1.00  0.00           H  
ATOM    493  HA  CYS A  34      -1.179  30.156  -6.110  1.00  0.00           H  
ATOM    494  HB2 CYS A  34      -1.444  27.238  -5.381  1.00  0.00           H  
ATOM    495  HB3 CYS A  34      -0.851  27.759  -6.954  1.00  0.00           H  
ATOM    496  N   PRO A  35      -2.820  29.565  -8.009  1.00  0.00           N  
ATOM    497  CA  PRO A  35      -3.893  29.470  -8.997  1.00  0.00           C  
ATOM    498  C   PRO A  35      -4.191  28.023  -9.387  1.00  0.00           C  
ATOM    499  O   PRO A  35      -5.261  27.724  -9.919  1.00  0.00           O  
ATOM    500  CB  PRO A  35      -3.354  30.252 -10.207  1.00  0.00           C  
ATOM    501  CG  PRO A  35      -2.121  30.946  -9.727  1.00  0.00           C  
ATOM    502  CD  PRO A  35      -1.594  30.119  -8.594  1.00  0.00           C  
ATOM    503  HA  PRO A  35      -4.798  29.939  -8.639  1.00  0.00           H  
ATOM    504  HB2 PRO A  35      -3.129  29.562 -11.007  1.00  0.00           H  
ATOM    505  HB3 PRO A  35      -4.100  30.960 -10.539  1.00  0.00           H  
ATOM    506  HG2 PRO A  35      -1.394  30.994 -10.523  1.00  0.00           H  
ATOM    507  HG3 PRO A  35      -2.368  31.937  -9.383  1.00  0.00           H  
ATOM    508  HD2 PRO A  35      -0.951  29.334  -8.963  1.00  0.00           H  
ATOM    509  HD3 PRO A  35      -1.071  30.739  -7.881  1.00  0.00           H  
ATOM    510  N   ASP A  36      -3.246  27.128  -9.119  1.00  0.00           N  
ATOM    511  CA  ASP A  36      -3.412  25.728  -9.478  1.00  0.00           C  
ATOM    512  C   ASP A  36      -3.696  24.874  -8.243  1.00  0.00           C  
ATOM    513  O   ASP A  36      -4.567  24.004  -8.277  1.00  0.00           O  
ATOM    514  CB  ASP A  36      -2.188  25.213 -10.245  1.00  0.00           C  
ATOM    515  CG  ASP A  36      -0.966  24.994  -9.379  1.00  0.00           C  
ATOM    516  OD1 ASP A  36      -0.602  25.904  -8.601  1.00  0.00           O  
ATOM    517  OD2 ASP A  36      -0.352  23.909  -9.491  1.00  0.00           O  
ATOM    518  H   ASP A  36      -2.422  27.414  -8.674  1.00  0.00           H  
ATOM    519  HA  ASP A  36      -4.272  25.669 -10.129  1.00  0.00           H  
ATOM    520  HB2 ASP A  36      -2.440  24.273 -10.710  1.00  0.00           H  
ATOM    521  HB3 ASP A  36      -1.934  25.928 -11.013  1.00  0.00           H  
ATOM    522  N   CYS A  37      -2.972  25.110  -7.154  1.00  0.00           N  
ATOM    523  CA  CYS A  37      -3.277  24.444  -5.896  1.00  0.00           C  
ATOM    524  C   CYS A  37      -3.885  25.439  -4.910  1.00  0.00           C  
ATOM    525  O   CYS A  37      -3.177  26.208  -4.256  1.00  0.00           O  
ATOM    526  CB  CYS A  37      -2.037  23.753  -5.301  1.00  0.00           C  
ATOM    527  SG  CYS A  37      -0.608  24.830  -5.007  1.00  0.00           S  
ATOM    528  H   CYS A  37      -2.216  25.735  -7.201  1.00  0.00           H  
ATOM    529  HA  CYS A  37      -4.022  23.688  -6.111  1.00  0.00           H  
ATOM    530  HB2 CYS A  37      -2.305  23.310  -4.354  1.00  0.00           H  
ATOM    531  HB3 CYS A  37      -1.721  22.969  -5.975  1.00  0.00           H  
ATOM    532  N   ARG A  38      -5.207  25.434  -4.822  1.00  0.00           N  
ATOM    533  CA  ARG A  38      -5.915  26.389  -3.989  1.00  0.00           C  
ATOM    534  C   ARG A  38      -5.966  25.908  -2.548  1.00  0.00           C  
ATOM    535  O   ARG A  38      -6.942  25.294  -2.111  1.00  0.00           O  
ATOM    536  CB  ARG A  38      -7.324  26.613  -4.523  1.00  0.00           C  
ATOM    537  CG  ARG A  38      -7.976  27.880  -4.007  1.00  0.00           C  
ATOM    538  CD  ARG A  38      -9.324  28.103  -4.663  1.00  0.00           C  
ATOM    539  NE  ARG A  38      -9.246  27.967  -6.119  1.00  0.00           N  
ATOM    540  CZ  ARG A  38     -10.016  28.625  -6.980  1.00  0.00           C  
ATOM    541  NH1 ARG A  38     -10.974  29.438  -6.545  1.00  0.00           N  
ATOM    542  NH2 ARG A  38      -9.843  28.445  -8.283  1.00  0.00           N  
ATOM    543  H   ARG A  38      -5.721  24.769  -5.336  1.00  0.00           H  
ATOM    544  HA  ARG A  38      -5.375  27.321  -4.024  1.00  0.00           H  
ATOM    545  HB2 ARG A  38      -7.283  26.670  -5.600  1.00  0.00           H  
ATOM    546  HB3 ARG A  38      -7.941  25.774  -4.238  1.00  0.00           H  
ATOM    547  HG2 ARG A  38      -8.112  27.796  -2.939  1.00  0.00           H  
ATOM    548  HG3 ARG A  38      -7.333  28.721  -4.226  1.00  0.00           H  
ATOM    549  HD2 ARG A  38     -10.022  27.377  -4.276  1.00  0.00           H  
ATOM    550  HD3 ARG A  38      -9.664  29.098  -4.419  1.00  0.00           H  
ATOM    551  HE  ARG A  38      -8.566  27.343  -6.477  1.00  0.00           H  
ATOM    552 HH11 ARG A  38     -11.132  29.558  -5.555  1.00  0.00           H  
ATOM    553 HH12 ARG A  38     -11.545  29.945  -7.203  1.00  0.00           H  
ATOM    554 HH21 ARG A  38      -9.133  27.816  -8.615  1.00  0.00           H  
ATOM    555 HH22 ARG A  38     -10.425  28.932  -8.945  1.00  0.00           H  
ATOM    556  N   GLN A  39      -4.889  26.162  -1.831  1.00  0.00           N  
ATOM    557  CA  GLN A  39      -4.768  25.786  -0.433  1.00  0.00           C  
ATOM    558  C   GLN A  39      -3.985  26.864   0.300  1.00  0.00           C  
ATOM    559  O   GLN A  39      -3.498  27.799  -0.330  1.00  0.00           O  
ATOM    560  CB  GLN A  39      -4.027  24.446  -0.302  1.00  0.00           C  
ATOM    561  CG  GLN A  39      -4.774  23.247  -0.860  1.00  0.00           C  
ATOM    562  CD  GLN A  39      -4.028  21.943  -0.634  1.00  0.00           C  
ATOM    563  OE1 GLN A  39      -4.634  20.881  -0.498  1.00  0.00           O  
ATOM    564  NE2 GLN A  39      -2.704  22.010  -0.593  1.00  0.00           N  
ATOM    565  H   GLN A  39      -4.137  26.631  -2.259  1.00  0.00           H  
ATOM    566  HA  GLN A  39      -5.757  25.702  -0.010  1.00  0.00           H  
ATOM    567  HB2 GLN A  39      -3.086  24.523  -0.822  1.00  0.00           H  
ATOM    568  HB3 GLN A  39      -3.832  24.263   0.745  1.00  0.00           H  
ATOM    569  HG2 GLN A  39      -5.737  23.181  -0.377  1.00  0.00           H  
ATOM    570  HG3 GLN A  39      -4.912  23.386  -1.923  1.00  0.00           H  
ATOM    571 HE21 GLN A  39      -2.280  22.885  -0.712  1.00  0.00           H  
ATOM    572 HE22 GLN A  39      -2.205  21.181  -0.437  1.00  0.00           H  
ATOM    573  N   PRO A  40      -3.841  26.756   1.634  1.00  0.00           N  
ATOM    574  CA  PRO A  40      -2.906  27.601   2.393  1.00  0.00           C  
ATOM    575  C   PRO A  40      -1.449  27.292   2.032  1.00  0.00           C  
ATOM    576  O   PRO A  40      -0.523  27.813   2.649  1.00  0.00           O  
ATOM    577  CB  PRO A  40      -3.182  27.238   3.858  1.00  0.00           C  
ATOM    578  CG  PRO A  40      -4.504  26.548   3.852  1.00  0.00           C  
ATOM    579  CD  PRO A  40      -4.602  25.860   2.521  1.00  0.00           C  
ATOM    580  HA  PRO A  40      -3.102  28.652   2.232  1.00  0.00           H  
ATOM    581  HB2 PRO A  40      -2.400  26.588   4.221  1.00  0.00           H  
ATOM    582  HB3 PRO A  40      -3.212  28.137   4.454  1.00  0.00           H  
ATOM    583  HG2 PRO A  40      -4.545  25.824   4.652  1.00  0.00           H  
ATOM    584  HG3 PRO A  40      -5.299  27.272   3.958  1.00  0.00           H  
ATOM    585  HD2 PRO A  40      -4.149  24.882   2.566  1.00  0.00           H  
ATOM    586  HD3 PRO A  40      -5.633  25.789   2.206  1.00  0.00           H  
ATOM    587  N   LEU A  41      -1.278  26.417   1.038  1.00  0.00           N  
ATOM    588  CA  LEU A  41       0.027  26.045   0.496  1.00  0.00           C  
ATOM    589  C   LEU A  41       0.887  25.346   1.543  1.00  0.00           C  
ATOM    590  O   LEU A  41       0.917  24.117   1.615  1.00  0.00           O  
ATOM    591  CB  LEU A  41       0.748  27.275  -0.073  1.00  0.00           C  
ATOM    592  CG  LEU A  41      -0.010  28.022  -1.171  1.00  0.00           C  
ATOM    593  CD1 LEU A  41       0.861  29.115  -1.769  1.00  0.00           C  
ATOM    594  CD2 LEU A  41      -0.486  27.058  -2.247  1.00  0.00           C  
ATOM    595  H   LEU A  41      -2.074  26.009   0.649  1.00  0.00           H  
ATOM    596  HA  LEU A  41      -0.150  25.349  -0.311  1.00  0.00           H  
ATOM    597  HB2 LEU A  41       0.931  27.967   0.736  1.00  0.00           H  
ATOM    598  HB3 LEU A  41       1.699  26.957  -0.474  1.00  0.00           H  
ATOM    599  HG  LEU A  41      -0.879  28.494  -0.737  1.00  0.00           H  
ATOM    600 HD11 LEU A  41       1.155  29.805  -0.993  1.00  0.00           H  
ATOM    601 HD12 LEU A  41       0.306  29.643  -2.530  1.00  0.00           H  
ATOM    602 HD13 LEU A  41       1.743  28.672  -2.209  1.00  0.00           H  
ATOM    603 HD21 LEU A  41      -1.147  26.327  -1.807  1.00  0.00           H  
ATOM    604 HD22 LEU A  41       0.366  26.557  -2.685  1.00  0.00           H  
ATOM    605 HD23 LEU A  41      -1.014  27.606  -3.013  1.00  0.00           H  
ATOM    606  N   GLN A  42       1.567  26.133   2.352  1.00  0.00           N  
ATOM    607  CA  GLN A  42       2.381  25.622   3.433  1.00  0.00           C  
ATOM    608  C   GLN A  42       2.640  26.763   4.402  1.00  0.00           C  
ATOM    609  O   GLN A  42       3.061  27.847   3.997  1.00  0.00           O  
ATOM    610  CB  GLN A  42       3.697  25.044   2.903  1.00  0.00           C  
ATOM    611  CG  GLN A  42       4.188  23.821   3.668  1.00  0.00           C  
ATOM    612  CD  GLN A  42       4.434  24.099   5.137  1.00  0.00           C  
ATOM    613  OE1 GLN A  42       3.542  23.938   5.971  1.00  0.00           O  
ATOM    614  NE2 GLN A  42       5.644  24.521   5.460  1.00  0.00           N  
ATOM    615  H   GLN A  42       1.504  27.104   2.233  1.00  0.00           H  
ATOM    616  HA  GLN A  42       1.822  24.848   3.937  1.00  0.00           H  
ATOM    617  HB2 GLN A  42       3.562  24.762   1.869  1.00  0.00           H  
ATOM    618  HB3 GLN A  42       4.460  25.806   2.961  1.00  0.00           H  
ATOM    619  HG2 GLN A  42       3.447  23.041   3.587  1.00  0.00           H  
ATOM    620  HG3 GLN A  42       5.112  23.484   3.223  1.00  0.00           H  
ATOM    621 HE21 GLN A  42       6.305  24.628   4.739  1.00  0.00           H  
ATOM    622 HE22 GLN A  42       5.839  24.704   6.406  1.00  0.00           H  
ATOM    623  N   VAL A  43       2.374  26.524   5.671  1.00  0.00           N  
ATOM    624  CA  VAL A  43       2.406  27.578   6.665  1.00  0.00           C  
ATOM    625  C   VAL A  43       3.823  27.826   7.167  1.00  0.00           C  
ATOM    626  O   VAL A  43       4.361  27.058   7.972  1.00  0.00           O  
ATOM    627  CB  VAL A  43       1.487  27.241   7.857  1.00  0.00           C  
ATOM    628  CG1 VAL A  43       1.475  28.369   8.871  1.00  0.00           C  
ATOM    629  CG2 VAL A  43       0.077  26.930   7.374  1.00  0.00           C  
ATOM    630  H   VAL A  43       2.170  25.608   5.952  1.00  0.00           H  
ATOM    631  HA  VAL A  43       2.039  28.481   6.197  1.00  0.00           H  
ATOM    632  HB  VAL A  43       1.877  26.358   8.343  1.00  0.00           H  
ATOM    633 HG11 VAL A  43       0.847  28.096   9.706  1.00  0.00           H  
ATOM    634 HG12 VAL A  43       1.090  29.266   8.410  1.00  0.00           H  
ATOM    635 HG13 VAL A  43       2.481  28.547   9.222  1.00  0.00           H  
ATOM    636 HG21 VAL A  43      -0.317  27.780   6.836  1.00  0.00           H  
ATOM    637 HG22 VAL A  43      -0.555  26.717   8.223  1.00  0.00           H  
ATOM    638 HG23 VAL A  43       0.100  26.071   6.720  1.00  0.00           H  
ATOM    639  N   LEU A  44       4.431  28.892   6.671  1.00  0.00           N  
ATOM    640  CA  LEU A  44       5.746  29.306   7.130  1.00  0.00           C  
ATOM    641  C   LEU A  44       5.585  30.341   8.231  1.00  0.00           C  
ATOM    642  O   LEU A  44       4.989  31.395   8.013  1.00  0.00           O  
ATOM    643  CB  LEU A  44       6.570  29.900   5.981  1.00  0.00           C  
ATOM    644  CG  LEU A  44       6.643  29.054   4.705  1.00  0.00           C  
ATOM    645  CD1 LEU A  44       7.593  29.692   3.707  1.00  0.00           C  
ATOM    646  CD2 LEU A  44       7.080  27.634   5.018  1.00  0.00           C  
ATOM    647  H   LEU A  44       3.978  29.425   5.977  1.00  0.00           H  
ATOM    648  HA  LEU A  44       6.255  28.441   7.530  1.00  0.00           H  
ATOM    649  HB2 LEU A  44       6.149  30.861   5.725  1.00  0.00           H  
ATOM    650  HB3 LEU A  44       7.578  30.055   6.338  1.00  0.00           H  
ATOM    651  HG  LEU A  44       5.662  29.012   4.250  1.00  0.00           H  
ATOM    652 HD11 LEU A  44       8.570  29.794   4.157  1.00  0.00           H  
ATOM    653 HD12 LEU A  44       7.221  30.667   3.429  1.00  0.00           H  
ATOM    654 HD13 LEU A  44       7.664  29.069   2.829  1.00  0.00           H  
ATOM    655 HD21 LEU A  44       8.066  27.650   5.457  1.00  0.00           H  
ATOM    656 HD22 LEU A  44       7.101  27.056   4.106  1.00  0.00           H  
ATOM    657 HD23 LEU A  44       6.383  27.188   5.712  1.00  0.00           H  
ATOM    658  N   LYS A  45       6.087  30.040   9.417  1.00  0.00           N  
ATOM    659  CA  LYS A  45       5.959  30.957  10.536  1.00  0.00           C  
ATOM    660  C   LYS A  45       7.326  31.360  11.067  1.00  0.00           C  
ATOM    661  O   LYS A  45       8.229  30.531  11.189  1.00  0.00           O  
ATOM    662  CB  LYS A  45       5.118  30.341  11.655  1.00  0.00           C  
ATOM    663  CG  LYS A  45       3.677  30.065  11.254  1.00  0.00           C  
ATOM    664  CD  LYS A  45       2.883  29.444  12.391  1.00  0.00           C  
ATOM    665  CE  LYS A  45       2.651  30.425  13.531  1.00  0.00           C  
ATOM    666  NZ  LYS A  45       1.753  31.545  13.134  1.00  0.00           N  
ATOM    667  H   LYS A  45       6.561  29.190   9.543  1.00  0.00           H  
ATOM    668  HA  LYS A  45       5.457  31.843  10.173  1.00  0.00           H  
ATOM    669  HB2 LYS A  45       5.570  29.408  11.959  1.00  0.00           H  
ATOM    670  HB3 LYS A  45       5.111  31.017  12.498  1.00  0.00           H  
ATOM    671  HG2 LYS A  45       3.208  30.996  10.971  1.00  0.00           H  
ATOM    672  HG3 LYS A  45       3.672  29.389  10.412  1.00  0.00           H  
ATOM    673  HD2 LYS A  45       1.924  29.122  12.013  1.00  0.00           H  
ATOM    674  HD3 LYS A  45       3.426  28.590  12.769  1.00  0.00           H  
ATOM    675  HE2 LYS A  45       2.205  29.895  14.358  1.00  0.00           H  
ATOM    676  HE3 LYS A  45       3.604  30.831  13.838  1.00  0.00           H  
ATOM    677  HZ1 LYS A  45       2.239  32.183  12.475  1.00  0.00           H  
ATOM    678  HZ2 LYS A  45       1.460  32.088  13.976  1.00  0.00           H  
ATOM    679  HZ3 LYS A  45       0.896  31.167  12.668  1.00  0.00           H  
ATOM    680  N   ALA A  46       7.469  32.641  11.361  1.00  0.00           N  
ATOM    681  CA  ALA A  46       8.702  33.178  11.911  1.00  0.00           C  
ATOM    682  C   ALA A  46       8.383  34.247  12.944  1.00  0.00           C  
ATOM    683  O   ALA A  46       7.811  35.284  12.610  1.00  0.00           O  
ATOM    684  CB  ALA A  46       9.579  33.745  10.804  1.00  0.00           C  
ATOM    685  H   ALA A  46       6.713  33.250  11.206  1.00  0.00           H  
ATOM    686  HA  ALA A  46       9.236  32.370  12.390  1.00  0.00           H  
ATOM    687  HB1 ALA A  46      10.501  34.114  11.229  1.00  0.00           H  
ATOM    688  HB2 ALA A  46       9.058  34.554  10.314  1.00  0.00           H  
ATOM    689  HB3 ALA A  46       9.798  32.969  10.085  1.00  0.00           H  
ATOM    690  N   CYS A  47       8.727  33.971  14.200  1.00  0.00           N  
ATOM    691  CA  CYS A  47       8.443  34.879  15.312  1.00  0.00           C  
ATOM    692  C   CYS A  47       6.941  35.149  15.431  1.00  0.00           C  
ATOM    693  O   CYS A  47       6.522  36.201  15.914  1.00  0.00           O  
ATOM    694  CB  CYS A  47       9.210  36.195  15.135  1.00  0.00           C  
ATOM    695  SG  CYS A  47      11.004  35.988  15.015  1.00  0.00           S  
ATOM    696  H   CYS A  47       9.202  33.132  14.383  1.00  0.00           H  
ATOM    697  HA  CYS A  47       8.779  34.400  16.219  1.00  0.00           H  
ATOM    698  HB2 CYS A  47       8.874  36.681  14.231  1.00  0.00           H  
ATOM    699  HB3 CYS A  47       9.006  36.838  15.980  1.00  0.00           H  
ATOM    700  HG  CYS A  47      11.481  37.025  14.335  1.00  0.00           H  
ATOM    701  N   GLY A  48       6.137  34.183  15.006  1.00  0.00           N  
ATOM    702  CA  GLY A  48       4.696  34.346  15.043  1.00  0.00           C  
ATOM    703  C   GLY A  48       4.121  34.687  13.684  1.00  0.00           C  
ATOM    704  O   GLY A  48       3.055  34.191  13.314  1.00  0.00           O  
ATOM    705  H   GLY A  48       6.526  33.349  14.668  1.00  0.00           H  
ATOM    706  HA2 GLY A  48       4.250  33.427  15.392  1.00  0.00           H  
ATOM    707  HA3 GLY A  48       4.451  35.139  15.736  1.00  0.00           H  
ATOM    708  N   ALA A  49       4.839  35.522  12.932  1.00  0.00           N  
ATOM    709  CA  ALA A  49       4.399  35.943  11.603  1.00  0.00           C  
ATOM    710  C   ALA A  49       4.236  34.739  10.686  1.00  0.00           C  
ATOM    711  O   ALA A  49       4.949  33.746  10.823  1.00  0.00           O  
ATOM    712  CB  ALA A  49       5.387  36.935  11.006  1.00  0.00           C  
ATOM    713  H   ALA A  49       5.695  35.856  13.278  1.00  0.00           H  
ATOM    714  HA  ALA A  49       3.444  36.436  11.707  1.00  0.00           H  
ATOM    715  HB1 ALA A  49       5.472  37.793  11.657  1.00  0.00           H  
ATOM    716  HB2 ALA A  49       5.036  37.252  10.036  1.00  0.00           H  
ATOM    717  HB3 ALA A  49       6.353  36.463  10.904  1.00  0.00           H  
ATOM    718  N   VAL A  50       3.302  34.826   9.753  1.00  0.00           N  
ATOM    719  CA  VAL A  50       2.978  33.696   8.904  1.00  0.00           C  
ATOM    720  C   VAL A  50       2.931  34.097   7.432  1.00  0.00           C  
ATOM    721  O   VAL A  50       2.462  35.182   7.081  1.00  0.00           O  
ATOM    722  CB  VAL A  50       1.628  33.064   9.322  1.00  0.00           C  
ATOM    723  CG1 VAL A  50       0.507  34.090   9.256  1.00  0.00           C  
ATOM    724  CG2 VAL A  50       1.300  31.857   8.458  1.00  0.00           C  
ATOM    725  H   VAL A  50       2.828  35.673   9.623  1.00  0.00           H  
ATOM    726  HA  VAL A  50       3.750  32.952   9.037  1.00  0.00           H  
ATOM    727  HB  VAL A  50       1.715  32.732  10.347  1.00  0.00           H  
ATOM    728 HG11 VAL A  50       0.722  34.904   9.933  1.00  0.00           H  
ATOM    729 HG12 VAL A  50      -0.427  33.624   9.538  1.00  0.00           H  
ATOM    730 HG13 VAL A  50       0.428  34.472   8.249  1.00  0.00           H  
ATOM    731 HG21 VAL A  50       0.351  31.440   8.765  1.00  0.00           H  
ATOM    732 HG22 VAL A  50       2.075  31.113   8.571  1.00  0.00           H  
ATOM    733 HG23 VAL A  50       1.242  32.161   7.424  1.00  0.00           H  
ATOM    734  N   ASP A  51       3.459  33.225   6.589  1.00  0.00           N  
ATOM    735  CA  ASP A  51       3.360  33.374   5.148  1.00  0.00           C  
ATOM    736  C   ASP A  51       3.030  32.021   4.539  1.00  0.00           C  
ATOM    737  O   ASP A  51       3.533  30.993   4.997  1.00  0.00           O  
ATOM    738  CB  ASP A  51       4.667  33.920   4.565  1.00  0.00           C  
ATOM    739  CG  ASP A  51       4.560  34.244   3.087  1.00  0.00           C  
ATOM    740  OD1 ASP A  51       3.709  35.085   2.715  1.00  0.00           O  
ATOM    741  OD2 ASP A  51       5.334  33.677   2.288  1.00  0.00           O  
ATOM    742  H   ASP A  51       3.941  32.447   6.952  1.00  0.00           H  
ATOM    743  HA  ASP A  51       2.555  34.064   4.936  1.00  0.00           H  
ATOM    744  HB2 ASP A  51       4.938  34.823   5.090  1.00  0.00           H  
ATOM    745  HB3 ASP A  51       5.445  33.182   4.698  1.00  0.00           H  
ATOM    746  N   TYR A  52       2.166  32.009   3.540  1.00  0.00           N  
ATOM    747  CA  TYR A  52       1.743  30.759   2.928  1.00  0.00           C  
ATOM    748  C   TYR A  52       2.518  30.529   1.638  1.00  0.00           C  
ATOM    749  O   TYR A  52       2.326  31.229   0.645  1.00  0.00           O  
ATOM    750  CB  TYR A  52       0.234  30.764   2.679  1.00  0.00           C  
ATOM    751  CG  TYR A  52      -0.574  31.036   3.929  1.00  0.00           C  
ATOM    752  CD1 TYR A  52      -0.781  30.038   4.871  1.00  0.00           C  
ATOM    753  CD2 TYR A  52      -1.121  32.289   4.170  1.00  0.00           C  
ATOM    754  CE1 TYR A  52      -1.510  30.281   6.019  1.00  0.00           C  
ATOM    755  CE2 TYR A  52      -1.852  32.540   5.314  1.00  0.00           C  
ATOM    756  CZ  TYR A  52      -2.042  31.533   6.234  1.00  0.00           C  
ATOM    757  OH  TYR A  52      -2.766  31.778   7.377  1.00  0.00           O  
ATOM    758  H   TYR A  52       1.821  32.858   3.192  1.00  0.00           H  
ATOM    759  HA  TYR A  52       1.983  29.962   3.619  1.00  0.00           H  
ATOM    760  HB2 TYR A  52      -0.009  31.524   1.954  1.00  0.00           H  
ATOM    761  HB3 TYR A  52      -0.063  29.800   2.295  1.00  0.00           H  
ATOM    762  HD1 TYR A  52      -0.363  29.058   4.701  1.00  0.00           H  
ATOM    763  HD2 TYR A  52      -0.969  33.077   3.445  1.00  0.00           H  
ATOM    764  HE1 TYR A  52      -1.662  29.493   6.741  1.00  0.00           H  
ATOM    765  HE2 TYR A  52      -2.270  33.521   5.483  1.00  0.00           H  
ATOM    766  HH  TYR A  52      -3.568  32.256   7.151  1.00  0.00           H  
ATOM    767  N   PHE A  53       3.409  29.553   1.676  1.00  0.00           N  
ATOM    768  CA  PHE A  53       4.356  29.333   0.594  1.00  0.00           C  
ATOM    769  C   PHE A  53       4.637  27.840   0.438  1.00  0.00           C  
ATOM    770  O   PHE A  53       5.313  27.237   1.271  1.00  0.00           O  
ATOM    771  CB  PHE A  53       5.642  30.093   0.928  1.00  0.00           C  
ATOM    772  CG  PHE A  53       6.538  30.372  -0.240  1.00  0.00           C  
ATOM    773  CD1 PHE A  53       6.264  31.426  -1.096  1.00  0.00           C  
ATOM    774  CD2 PHE A  53       7.664  29.600  -0.466  1.00  0.00           C  
ATOM    775  CE1 PHE A  53       7.096  31.700  -2.161  1.00  0.00           C  
ATOM    776  CE2 PHE A  53       8.501  29.873  -1.527  1.00  0.00           C  
ATOM    777  CZ  PHE A  53       8.218  30.924  -2.375  1.00  0.00           C  
ATOM    778  H   PHE A  53       3.438  28.964   2.470  1.00  0.00           H  
ATOM    779  HA  PHE A  53       3.940  29.719  -0.329  1.00  0.00           H  
ATOM    780  HB2 PHE A  53       5.380  31.042   1.371  1.00  0.00           H  
ATOM    781  HB3 PHE A  53       6.207  29.516   1.646  1.00  0.00           H  
ATOM    782  HD1 PHE A  53       5.386  32.034  -0.929  1.00  0.00           H  
ATOM    783  HD2 PHE A  53       7.884  28.778   0.196  1.00  0.00           H  
ATOM    784  HE1 PHE A  53       6.874  32.523  -2.823  1.00  0.00           H  
ATOM    785  HE2 PHE A  53       9.377  29.264  -1.694  1.00  0.00           H  
ATOM    786  HZ  PHE A  53       8.872  31.140  -3.207  1.00  0.00           H  
ATOM    787  N   CYS A  54       4.104  27.239  -0.620  1.00  0.00           N  
ATOM    788  CA  CYS A  54       4.257  25.808  -0.837  1.00  0.00           C  
ATOM    789  C   CYS A  54       5.638  25.496  -1.398  1.00  0.00           C  
ATOM    790  O   CYS A  54       5.842  25.520  -2.610  1.00  0.00           O  
ATOM    791  CB  CYS A  54       3.160  25.281  -1.775  1.00  0.00           C  
ATOM    792  SG  CYS A  54       3.046  26.135  -3.379  1.00  0.00           S  
ATOM    793  H   CYS A  54       3.606  27.772  -1.271  1.00  0.00           H  
ATOM    794  HA  CYS A  54       4.160  25.321   0.123  1.00  0.00           H  
ATOM    795  HB2 CYS A  54       3.346  24.237  -1.977  1.00  0.00           H  
ATOM    796  HB3 CYS A  54       2.204  25.380  -1.284  1.00  0.00           H  
ATOM    797  N   GLN A  55       6.584  25.219  -0.513  1.00  0.00           N  
ATOM    798  CA  GLN A  55       7.963  24.976  -0.916  1.00  0.00           C  
ATOM    799  C   GLN A  55       8.100  23.656  -1.670  1.00  0.00           C  
ATOM    800  O   GLN A  55       8.048  23.625  -2.897  1.00  0.00           O  
ATOM    801  CB  GLN A  55       8.889  24.980   0.302  1.00  0.00           C  
ATOM    802  CG  GLN A  55       8.900  26.291   1.069  1.00  0.00           C  
ATOM    803  CD  GLN A  55       9.870  26.273   2.238  1.00  0.00           C  
ATOM    804  OE1 GLN A  55      10.422  27.306   2.620  1.00  0.00           O  
ATOM    805  NE2 GLN A  55      10.088  25.097   2.809  1.00  0.00           N  
ATOM    806  H   GLN A  55       6.349  25.178   0.439  1.00  0.00           H  
ATOM    807  HA  GLN A  55       8.255  25.781  -1.575  1.00  0.00           H  
ATOM    808  HB2 GLN A  55       8.577  24.197   0.978  1.00  0.00           H  
ATOM    809  HB3 GLN A  55       9.897  24.772  -0.030  1.00  0.00           H  
ATOM    810  HG2 GLN A  55       9.185  27.085   0.396  1.00  0.00           H  
ATOM    811  HG3 GLN A  55       7.906  26.479   1.447  1.00  0.00           H  
ATOM    812 HE21 GLN A  55       9.620  24.312   2.453  1.00  0.00           H  
ATOM    813 HE22 GLN A  55      10.711  25.057   3.571  1.00  0.00           H  
ATOM    814  N   ASN A  56       8.244  22.565  -0.928  1.00  0.00           N  
ATOM    815  CA  ASN A  56       8.471  21.259  -1.534  1.00  0.00           C  
ATOM    816  C   ASN A  56       7.147  20.534  -1.737  1.00  0.00           C  
ATOM    817  O   ASN A  56       7.049  19.599  -2.529  1.00  0.00           O  
ATOM    818  CB  ASN A  56       9.407  20.420  -0.655  1.00  0.00           C  
ATOM    819  CG  ASN A  56       9.920  19.182  -1.365  1.00  0.00           C  
ATOM    820  OD1 ASN A  56       9.319  18.108  -1.292  1.00  0.00           O  
ATOM    821  ND2 ASN A  56      11.047  19.322  -2.044  1.00  0.00           N  
ATOM    822  H   ASN A  56       8.193  22.638   0.049  1.00  0.00           H  
ATOM    823  HA  ASN A  56       8.937  21.413  -2.496  1.00  0.00           H  
ATOM    824  HB2 ASN A  56      10.255  21.022  -0.366  1.00  0.00           H  
ATOM    825  HB3 ASN A  56       8.874  20.109   0.231  1.00  0.00           H  
ATOM    826 HD21 ASN A  56      11.485  20.205  -2.042  1.00  0.00           H  
ATOM    827 HD22 ASN A  56      11.396  18.541  -2.536  1.00  0.00           H  
ATOM    828  N   GLY A  57       6.123  20.997  -1.033  1.00  0.00           N  
ATOM    829  CA  GLY A  57       4.812  20.384  -1.128  1.00  0.00           C  
ATOM    830  C   GLY A  57       4.112  20.686  -2.438  1.00  0.00           C  
ATOM    831  O   GLY A  57       3.035  20.157  -2.706  1.00  0.00           O  
ATOM    832  H   GLY A  57       6.260  21.761  -0.428  1.00  0.00           H  
ATOM    833  HA2 GLY A  57       4.921  19.315  -1.032  1.00  0.00           H  
ATOM    834  HA3 GLY A  57       4.200  20.745  -0.315  1.00  0.00           H  
ATOM    835  N   HIS A  58       4.723  21.533  -3.260  1.00  0.00           N  
ATOM    836  CA  HIS A  58       4.146  21.897  -4.546  1.00  0.00           C  
ATOM    837  C   HIS A  58       5.174  22.586  -5.431  1.00  0.00           C  
ATOM    838  O   HIS A  58       5.524  22.088  -6.498  1.00  0.00           O  
ATOM    839  CB  HIS A  58       2.934  22.817  -4.354  1.00  0.00           C  
ATOM    840  CG  HIS A  58       2.370  23.347  -5.641  1.00  0.00           C  
ATOM    841  ND1 HIS A  58       2.525  24.668  -6.056  1.00  0.00           N  
ATOM    842  CD2 HIS A  58       1.657  22.728  -6.612  1.00  0.00           C  
ATOM    843  CE1 HIS A  58       1.920  24.810  -7.234  1.00  0.00           C  
ATOM    844  NE2 HIS A  58       1.395  23.657  -7.584  1.00  0.00           N  
ATOM    845  H   HIS A  58       5.593  21.903  -3.002  1.00  0.00           H  
ATOM    846  HA  HIS A  58       3.821  20.989  -5.032  1.00  0.00           H  
ATOM    847  HB2 HIS A  58       2.152  22.269  -3.849  1.00  0.00           H  
ATOM    848  HB3 HIS A  58       3.225  23.661  -3.745  1.00  0.00           H  
ATOM    849  HD2 HIS A  58       1.351  21.690  -6.618  1.00  0.00           H  
ATOM    850  HE1 HIS A  58       1.870  25.723  -7.808  1.00  0.00           H  
ATOM    851  HE2 HIS A  58       0.707  23.555  -8.294  1.00  0.00           H  
ATOM    852  N   GLY A  59       5.651  23.735  -4.977  1.00  0.00           N  
ATOM    853  CA  GLY A  59       6.530  24.543  -5.789  1.00  0.00           C  
ATOM    854  C   GLY A  59       6.365  26.004  -5.461  1.00  0.00           C  
ATOM    855  O   GLY A  59       5.228  26.476  -5.272  1.00  0.00           O  
ATOM    856  H   GLY A  59       5.419  24.034  -4.068  1.00  0.00           H  
ATOM    857  HA2 GLY A  59       7.554  24.249  -5.602  1.00  0.00           H  
ATOM    858  HA3 GLY A  59       6.299  24.386  -6.831  1.00  0.00           H  
ATOM    859  N   LEU A  60       7.481  26.708  -5.386  1.00  0.00           N  
ATOM    860  CA  LEU A  60       7.507  28.098  -4.948  1.00  0.00           C  
ATOM    861  C   LEU A  60       6.955  29.034  -6.016  1.00  0.00           C  
ATOM    862  O   LEU A  60       6.927  28.700  -7.201  1.00  0.00           O  
ATOM    863  CB  LEU A  60       8.941  28.519  -4.587  1.00  0.00           C  
ATOM    864  CG  LEU A  60       9.932  28.623  -5.759  1.00  0.00           C  
ATOM    865  CD1 LEU A  60      11.149  29.438  -5.347  1.00  0.00           C  
ATOM    866  CD2 LEU A  60      10.373  27.243  -6.228  1.00  0.00           C  
ATOM    867  H   LEU A  60       8.327  26.280  -5.641  1.00  0.00           H  
ATOM    868  HA  LEU A  60       6.889  28.178  -4.065  1.00  0.00           H  
ATOM    869  HB2 LEU A  60       8.894  29.482  -4.101  1.00  0.00           H  
ATOM    870  HB3 LEU A  60       9.332  27.803  -3.880  1.00  0.00           H  
ATOM    871  HG  LEU A  60       9.456  29.126  -6.586  1.00  0.00           H  
ATOM    872 HD11 LEU A  60      11.626  28.971  -4.498  1.00  0.00           H  
ATOM    873 HD12 LEU A  60      10.839  30.438  -5.082  1.00  0.00           H  
ATOM    874 HD13 LEU A  60      11.845  29.483  -6.171  1.00  0.00           H  
ATOM    875 HD21 LEU A  60      11.066  27.347  -7.050  1.00  0.00           H  
ATOM    876 HD22 LEU A  60       9.510  26.681  -6.553  1.00  0.00           H  
ATOM    877 HD23 LEU A  60      10.856  26.722  -5.414  1.00  0.00           H  
ATOM    878  N   ILE A  61       6.493  30.199  -5.582  1.00  0.00           N  
ATOM    879  CA  ILE A  61       6.046  31.240  -6.497  1.00  0.00           C  
ATOM    880  C   ILE A  61       6.743  32.539  -6.148  1.00  0.00           C  
ATOM    881  O   ILE A  61       7.110  32.753  -4.996  1.00  0.00           O  
ATOM    882  CB  ILE A  61       4.519  31.514  -6.422  1.00  0.00           C  
ATOM    883  CG1 ILE A  61       3.725  30.261  -6.050  1.00  0.00           C  
ATOM    884  CG2 ILE A  61       4.012  32.084  -7.744  1.00  0.00           C  
ATOM    885  CD1 ILE A  61       3.630  30.020  -4.555  1.00  0.00           C  
ATOM    886  H   ILE A  61       6.456  30.370  -4.613  1.00  0.00           H  
ATOM    887  HA  ILE A  61       6.303  30.949  -7.506  1.00  0.00           H  
ATOM    888  HB  ILE A  61       4.360  32.265  -5.662  1.00  0.00           H  
ATOM    889 HG12 ILE A  61       2.719  30.354  -6.435  1.00  0.00           H  
ATOM    890 HG13 ILE A  61       4.198  29.399  -6.497  1.00  0.00           H  
ATOM    891 HG21 ILE A  61       4.496  33.032  -7.940  1.00  0.00           H  
ATOM    892 HG22 ILE A  61       2.944  32.233  -7.688  1.00  0.00           H  
ATOM    893 HG23 ILE A  61       4.237  31.394  -8.544  1.00  0.00           H  
ATOM    894 HD11 ILE A  61       3.134  30.857  -4.087  1.00  0.00           H  
ATOM    895 HD12 ILE A  61       4.622  29.913  -4.143  1.00  0.00           H  
ATOM    896 HD13 ILE A  61       3.063  29.119  -4.372  1.00  0.00           H  
ATOM    897  N   SER A  62       6.938  33.397  -7.130  1.00  0.00           N  
ATOM    898  CA  SER A  62       7.321  34.761  -6.842  1.00  0.00           C  
ATOM    899  C   SER A  62       6.150  35.426  -6.134  1.00  0.00           C  
ATOM    900  O   SER A  62       5.008  35.291  -6.575  1.00  0.00           O  
ATOM    901  CB  SER A  62       7.672  35.512  -8.131  1.00  0.00           C  
ATOM    902  OG  SER A  62       8.066  36.847  -7.858  1.00  0.00           O  
ATOM    903  H   SER A  62       6.817  33.110  -8.057  1.00  0.00           H  
ATOM    904  HA  SER A  62       8.178  34.742  -6.182  1.00  0.00           H  
ATOM    905  HB2 SER A  62       8.484  35.005  -8.631  1.00  0.00           H  
ATOM    906  HB3 SER A  62       6.806  35.530  -8.777  1.00  0.00           H  
ATOM    907  HG  SER A  62       9.027  36.912  -7.899  1.00  0.00           H  
ATOM    908  N   LYS A  63       6.414  36.132  -5.039  1.00  0.00           N  
ATOM    909  CA  LYS A  63       5.342  36.717  -4.235  1.00  0.00           C  
ATOM    910  C   LYS A  63       4.614  37.812  -5.013  1.00  0.00           C  
ATOM    911  O   LYS A  63       3.579  38.317  -4.585  1.00  0.00           O  
ATOM    912  CB  LYS A  63       5.895  37.255  -2.912  1.00  0.00           C  
ATOM    913  CG  LYS A  63       6.597  36.188  -2.082  1.00  0.00           C  
ATOM    914  CD  LYS A  63       6.990  36.696  -0.701  1.00  0.00           C  
ATOM    915  CE  LYS A  63       5.777  36.877   0.202  1.00  0.00           C  
ATOM    916  NZ  LYS A  63       5.088  35.587   0.473  1.00  0.00           N  
ATOM    917  H   LYS A  63       7.347  36.271  -4.771  1.00  0.00           H  
ATOM    918  HA  LYS A  63       4.636  35.930  -4.017  1.00  0.00           H  
ATOM    919  HB2 LYS A  63       6.602  38.045  -3.123  1.00  0.00           H  
ATOM    920  HB3 LYS A  63       5.081  37.657  -2.328  1.00  0.00           H  
ATOM    921  HG2 LYS A  63       5.932  35.343  -1.966  1.00  0.00           H  
ATOM    922  HG3 LYS A  63       7.488  35.873  -2.606  1.00  0.00           H  
ATOM    923  HD2 LYS A  63       7.658  35.983  -0.245  1.00  0.00           H  
ATOM    924  HD3 LYS A  63       7.493  37.647  -0.808  1.00  0.00           H  
ATOM    925  HE2 LYS A  63       6.101  37.304   1.140  1.00  0.00           H  
ATOM    926  HE3 LYS A  63       5.086  37.552  -0.279  1.00  0.00           H  
ATOM    927  HZ1 LYS A  63       4.737  35.170  -0.408  1.00  0.00           H  
ATOM    928  HZ2 LYS A  63       4.282  35.735   1.123  1.00  0.00           H  
ATOM    929  HZ3 LYS A  63       5.743  34.913   0.927  1.00  0.00           H  
ATOM    930  N   LYS A  64       5.166  38.145  -6.171  1.00  0.00           N  
ATOM    931  CA  LYS A  64       4.567  39.101  -7.088  1.00  0.00           C  
ATOM    932  C   LYS A  64       3.432  38.441  -7.878  1.00  0.00           C  
ATOM    933  O   LYS A  64       2.600  39.119  -8.482  1.00  0.00           O  
ATOM    934  CB  LYS A  64       5.649  39.603  -8.047  1.00  0.00           C  
ATOM    935  CG  LYS A  64       5.248  40.809  -8.881  1.00  0.00           C  
ATOM    936  CD  LYS A  64       6.295  41.100  -9.943  1.00  0.00           C  
ATOM    937  CE  LYS A  64       6.091  42.462 -10.582  1.00  0.00           C  
ATOM    938  NZ  LYS A  64       6.299  43.566  -9.610  1.00  0.00           N  
ATOM    939  H   LYS A  64       6.024  37.734  -6.413  1.00  0.00           H  
ATOM    940  HA  LYS A  64       4.178  39.929  -6.517  1.00  0.00           H  
ATOM    941  HB2 LYS A  64       6.523  39.870  -7.473  1.00  0.00           H  
ATOM    942  HB3 LYS A  64       5.908  38.801  -8.721  1.00  0.00           H  
ATOM    943  HG2 LYS A  64       4.304  40.606  -9.364  1.00  0.00           H  
ATOM    944  HG3 LYS A  64       5.151  41.668  -8.234  1.00  0.00           H  
ATOM    945  HD2 LYS A  64       7.273  41.071  -9.486  1.00  0.00           H  
ATOM    946  HD3 LYS A  64       6.234  40.341 -10.709  1.00  0.00           H  
ATOM    947  HE2 LYS A  64       6.794  42.573 -11.393  1.00  0.00           H  
ATOM    948  HE3 LYS A  64       5.083  42.518 -10.969  1.00  0.00           H  
ATOM    949  HZ1 LYS A  64       5.447  43.701  -9.024  1.00  0.00           H  
ATOM    950  HZ2 LYS A  64       6.501  44.457 -10.114  1.00  0.00           H  
ATOM    951  HZ3 LYS A  64       7.104  43.348  -8.981  1.00  0.00           H  
ATOM    952  N   ARG A  65       3.409  37.110  -7.873  1.00  0.00           N  
ATOM    953  CA  ARG A  65       2.423  36.357  -8.639  1.00  0.00           C  
ATOM    954  C   ARG A  65       1.584  35.444  -7.756  1.00  0.00           C  
ATOM    955  O   ARG A  65       0.838  34.603  -8.257  1.00  0.00           O  
ATOM    956  CB  ARG A  65       3.100  35.520  -9.723  1.00  0.00           C  
ATOM    957  CG  ARG A  65       3.567  36.331 -10.917  1.00  0.00           C  
ATOM    958  CD  ARG A  65       2.462  37.244 -11.424  1.00  0.00           C  
ATOM    959  NE  ARG A  65       1.188  36.542 -11.576  1.00  0.00           N  
ATOM    960  CZ  ARG A  65       0.034  37.143 -11.852  1.00  0.00           C  
ATOM    961  NH1 ARG A  65      -0.010  38.453 -12.066  1.00  0.00           N  
ATOM    962  NH2 ARG A  65      -1.082  36.431 -11.902  1.00  0.00           N  
ATOM    963  H   ARG A  65       4.075  36.620  -7.337  1.00  0.00           H  
ATOM    964  HA  ARG A  65       1.768  37.069  -9.117  1.00  0.00           H  
ATOM    965  HB2 ARG A  65       3.960  35.024  -9.293  1.00  0.00           H  
ATOM    966  HB3 ARG A  65       2.402  34.773 -10.071  1.00  0.00           H  
ATOM    967  HG2 ARG A  65       4.413  36.933 -10.624  1.00  0.00           H  
ATOM    968  HG3 ARG A  65       3.857  35.657 -11.710  1.00  0.00           H  
ATOM    969  HD2 ARG A  65       2.332  38.047 -10.717  1.00  0.00           H  
ATOM    970  HD3 ARG A  65       2.756  37.646 -12.379  1.00  0.00           H  
ATOM    971  HE  ARG A  65       1.193  35.568 -11.440  1.00  0.00           H  
ATOM    972 HH11 ARG A  65       0.830  39.004 -12.020  1.00  0.00           H  
ATOM    973 HH12 ARG A  65      -0.889  38.901 -12.278  1.00  0.00           H  
ATOM    974 HH21 ARG A  65      -1.056  35.437 -11.727  1.00  0.00           H  
ATOM    975 HH22 ARG A  65      -1.958  36.876 -12.108  1.00  0.00           H  
ATOM    976  N   VAL A  66       1.703  35.606  -6.453  1.00  0.00           N  
ATOM    977  CA  VAL A  66       0.924  34.801  -5.526  1.00  0.00           C  
ATOM    978  C   VAL A  66      -0.453  35.427  -5.334  1.00  0.00           C  
ATOM    979  O   VAL A  66      -0.578  36.651  -5.261  1.00  0.00           O  
ATOM    980  CB  VAL A  66       1.635  34.660  -4.165  1.00  0.00           C  
ATOM    981  CG1 VAL A  66       0.824  33.796  -3.220  1.00  0.00           C  
ATOM    982  CG2 VAL A  66       3.026  34.078  -4.345  1.00  0.00           C  
ATOM    983  H   VAL A  66       2.313  36.287  -6.104  1.00  0.00           H  
ATOM    984  HA  VAL A  66       0.805  33.817  -5.957  1.00  0.00           H  
ATOM    985  HB  VAL A  66       1.734  35.643  -3.728  1.00  0.00           H  
ATOM    986 HG11 VAL A  66       1.344  33.714  -2.279  1.00  0.00           H  
ATOM    987 HG12 VAL A  66       0.696  32.814  -3.647  1.00  0.00           H  
ATOM    988 HG13 VAL A  66      -0.143  34.249  -3.057  1.00  0.00           H  
ATOM    989 HG21 VAL A  66       2.949  33.086  -4.764  1.00  0.00           H  
ATOM    990 HG22 VAL A  66       3.523  34.026  -3.388  1.00  0.00           H  
ATOM    991 HG23 VAL A  66       3.595  34.707  -5.014  1.00  0.00           H  
ATOM    992  N   ASN A  67      -1.481  34.594  -5.272  1.00  0.00           N  
ATOM    993  CA  ASN A  67      -2.846  35.086  -5.164  1.00  0.00           C  
ATOM    994  C   ASN A  67      -3.205  35.350  -3.708  1.00  0.00           C  
ATOM    995  O   ASN A  67      -3.581  34.435  -2.977  1.00  0.00           O  
ATOM    996  CB  ASN A  67      -3.833  34.082  -5.770  1.00  0.00           C  
ATOM    997  CG  ASN A  67      -5.249  34.625  -5.847  1.00  0.00           C  
ATOM    998  OD1 ASN A  67      -5.459  35.823  -6.053  1.00  0.00           O  
ATOM    999  ND2 ASN A  67      -6.231  33.748  -5.684  1.00  0.00           N  
ATOM   1000  H   ASN A  67      -1.319  33.625  -5.279  1.00  0.00           H  
ATOM   1001  HA  ASN A  67      -2.907  36.015  -5.710  1.00  0.00           H  
ATOM   1002  HB2 ASN A  67      -3.511  33.829  -6.768  1.00  0.00           H  
ATOM   1003  HB3 ASN A  67      -3.843  33.189  -5.163  1.00  0.00           H  
ATOM   1004 HD21 ASN A  67      -5.994  32.811  -5.521  1.00  0.00           H  
ATOM   1005 HD22 ASN A  67      -7.156  34.072  -5.736  1.00  0.00           H  
ATOM   1006  N   PHE A  68      -3.052  36.595  -3.281  1.00  0.00           N  
ATOM   1007  CA  PHE A  68      -3.427  36.986  -1.931  1.00  0.00           C  
ATOM   1008  C   PHE A  68      -4.913  37.326  -1.880  1.00  0.00           C  
ATOM   1009  O   PHE A  68      -5.325  38.411  -2.285  1.00  0.00           O  
ATOM   1010  CB  PHE A  68      -2.598  38.185  -1.459  1.00  0.00           C  
ATOM   1011  CG  PHE A  68      -1.132  37.894  -1.303  1.00  0.00           C  
ATOM   1012  CD1 PHE A  68      -0.637  37.384  -0.114  1.00  0.00           C  
ATOM   1013  CD2 PHE A  68      -0.248  38.132  -2.344  1.00  0.00           C  
ATOM   1014  CE1 PHE A  68       0.711  37.120   0.036  1.00  0.00           C  
ATOM   1015  CE2 PHE A  68       1.101  37.870  -2.200  1.00  0.00           C  
ATOM   1016  CZ  PHE A  68       1.581  37.361  -1.010  1.00  0.00           C  
ATOM   1017  H   PHE A  68      -2.683  37.267  -3.891  1.00  0.00           H  
ATOM   1018  HA  PHE A  68      -3.239  36.147  -1.279  1.00  0.00           H  
ATOM   1019  HB2 PHE A  68      -2.699  38.986  -2.176  1.00  0.00           H  
ATOM   1020  HB3 PHE A  68      -2.975  38.517  -0.503  1.00  0.00           H  
ATOM   1021  HD1 PHE A  68      -1.316  37.194   0.704  1.00  0.00           H  
ATOM   1022  HD2 PHE A  68      -0.623  38.530  -3.276  1.00  0.00           H  
ATOM   1023  HE1 PHE A  68       1.084  36.724   0.971  1.00  0.00           H  
ATOM   1024  HE2 PHE A  68       1.779  38.059  -3.019  1.00  0.00           H  
ATOM   1025  HZ  PHE A  68       2.636  37.155  -0.897  1.00  0.00           H  
ATOM   1026  N   VAL A  69      -5.710  36.386  -1.405  1.00  0.00           N  
ATOM   1027  CA  VAL A  69      -7.153  36.565  -1.356  1.00  0.00           C  
ATOM   1028  C   VAL A  69      -7.620  36.835   0.074  1.00  0.00           C  
ATOM   1029  O   VAL A  69      -7.077  36.278   1.029  1.00  0.00           O  
ATOM   1030  CB  VAL A  69      -7.884  35.326  -1.930  1.00  0.00           C  
ATOM   1031  CG1 VAL A  69      -7.566  34.075  -1.120  1.00  0.00           C  
ATOM   1032  CG2 VAL A  69      -9.387  35.559  -1.997  1.00  0.00           C  
ATOM   1033  H   VAL A  69      -5.318  35.547  -1.077  1.00  0.00           H  
ATOM   1034  HA  VAL A  69      -7.401  37.419  -1.970  1.00  0.00           H  
ATOM   1035  HB  VAL A  69      -7.526  35.168  -2.938  1.00  0.00           H  
ATOM   1036 HG11 VAL A  69      -7.908  34.208  -0.105  1.00  0.00           H  
ATOM   1037 HG12 VAL A  69      -6.499  33.906  -1.119  1.00  0.00           H  
ATOM   1038 HG13 VAL A  69      -8.065  33.224  -1.560  1.00  0.00           H  
ATOM   1039 HG21 VAL A  69      -9.759  35.773  -1.006  1.00  0.00           H  
ATOM   1040 HG22 VAL A  69      -9.872  34.673  -2.379  1.00  0.00           H  
ATOM   1041 HG23 VAL A  69      -9.594  36.395  -2.649  1.00  0.00           H  
ATOM   1042  N   ILE A  70      -8.607  37.713   0.219  1.00  0.00           N  
ATOM   1043  CA  ILE A  70      -9.175  38.011   1.525  1.00  0.00           C  
ATOM   1044  C   ILE A  70     -10.171  36.931   1.927  1.00  0.00           C  
ATOM   1045  O   ILE A  70     -11.330  36.948   1.502  1.00  0.00           O  
ATOM   1046  CB  ILE A  70      -9.891  39.378   1.542  1.00  0.00           C  
ATOM   1047  CG1 ILE A  70      -8.945  40.489   1.081  1.00  0.00           C  
ATOM   1048  CG2 ILE A  70     -10.417  39.678   2.938  1.00  0.00           C  
ATOM   1049  CD1 ILE A  70      -9.598  41.857   1.015  1.00  0.00           C  
ATOM   1050  H   ILE A  70      -8.962  38.170  -0.571  1.00  0.00           H  
ATOM   1051  HA  ILE A  70      -8.369  38.036   2.245  1.00  0.00           H  
ATOM   1052  HB  ILE A  70     -10.733  39.327   0.869  1.00  0.00           H  
ATOM   1053 HG12 ILE A  70      -8.114  40.553   1.767  1.00  0.00           H  
ATOM   1054 HG13 ILE A  70      -8.574  40.249   0.096  1.00  0.00           H  
ATOM   1055 HG21 ILE A  70      -9.596  39.677   3.639  1.00  0.00           H  
ATOM   1056 HG22 ILE A  70     -11.133  38.923   3.223  1.00  0.00           H  
ATOM   1057 HG23 ILE A  70     -10.893  40.646   2.943  1.00  0.00           H  
ATOM   1058 HD11 ILE A  70      -9.980  42.123   1.991  1.00  0.00           H  
ATOM   1059 HD12 ILE A  70     -10.413  41.834   0.305  1.00  0.00           H  
ATOM   1060 HD13 ILE A  70      -8.868  42.589   0.702  1.00  0.00           H  
ATOM   1061  N   SER A  71      -9.715  35.980   2.722  1.00  0.00           N  
ATOM   1062  CA  SER A  71     -10.570  34.904   3.180  1.00  0.00           C  
ATOM   1063  C   SER A  71     -10.719  34.934   4.699  1.00  0.00           C  
ATOM   1064  O   SER A  71      -9.926  34.340   5.431  1.00  0.00           O  
ATOM   1065  CB  SER A  71     -10.019  33.557   2.702  1.00  0.00           C  
ATOM   1066  OG  SER A  71      -8.608  33.504   2.845  1.00  0.00           O  
ATOM   1067  H   SER A  71      -8.775  35.998   3.006  1.00  0.00           H  
ATOM   1068  HA  SER A  71     -11.546  35.054   2.741  1.00  0.00           H  
ATOM   1069  HB2 SER A  71     -10.459  32.761   3.286  1.00  0.00           H  
ATOM   1070  HB3 SER A  71     -10.266  33.419   1.660  1.00  0.00           H  
ATOM   1071  HG  SER A  71      -8.372  32.752   3.394  1.00  0.00           H  
ATOM   1072  N   ASP A  72     -11.724  35.665   5.164  1.00  0.00           N  
ATOM   1073  CA  ASP A  72     -12.015  35.758   6.588  1.00  0.00           C  
ATOM   1074  C   ASP A  72     -13.310  35.016   6.897  1.00  0.00           C  
ATOM   1075  O   ASP A  72     -13.822  35.063   8.016  1.00  0.00           O  
ATOM   1076  CB  ASP A  72     -12.129  37.227   7.018  1.00  0.00           C  
ATOM   1077  CG  ASP A  72     -13.421  37.885   6.565  1.00  0.00           C  
ATOM   1078  OD1 ASP A  72     -13.682  37.927   5.340  1.00  0.00           O  
ATOM   1079  OD2 ASP A  72     -14.182  38.369   7.437  1.00  0.00           O  
ATOM   1080  H   ASP A  72     -12.283  36.166   4.532  1.00  0.00           H  
ATOM   1081  HA  ASP A  72     -11.204  35.290   7.127  1.00  0.00           H  
ATOM   1082  HB2 ASP A  72     -12.084  37.282   8.096  1.00  0.00           H  
ATOM   1083  HB3 ASP A  72     -11.301  37.780   6.602  1.00  0.00           H  
ATOM   1084  N   GLN A  73     -13.820  34.321   5.888  1.00  0.00           N  
ATOM   1085  CA  GLN A  73     -15.066  33.576   6.007  1.00  0.00           C  
ATOM   1086  C   GLN A  73     -14.855  32.247   6.727  1.00  0.00           C  
ATOM   1087  O   GLN A  73     -13.736  31.735   6.800  1.00  0.00           O  
ATOM   1088  CB  GLN A  73     -15.685  33.355   4.616  1.00  0.00           C  
ATOM   1089  CG  GLN A  73     -14.671  33.106   3.500  1.00  0.00           C  
ATOM   1090  CD  GLN A  73     -14.011  31.736   3.557  1.00  0.00           C  
ATOM   1091  OE1 GLN A  73     -12.844  31.584   3.200  1.00  0.00           O  
ATOM   1092  NE2 GLN A  73     -14.763  30.718   3.948  1.00  0.00           N  
ATOM   1093  H   GLN A  73     -13.338  34.302   5.037  1.00  0.00           H  
ATOM   1094  HA  GLN A  73     -15.744  34.177   6.593  1.00  0.00           H  
ATOM   1095  HB2 GLN A  73     -16.345  32.501   4.664  1.00  0.00           H  
ATOM   1096  HB3 GLN A  73     -16.264  34.228   4.354  1.00  0.00           H  
ATOM   1097  HG2 GLN A  73     -15.175  33.197   2.550  1.00  0.00           H  
ATOM   1098  HG3 GLN A  73     -13.899  33.859   3.563  1.00  0.00           H  
ATOM   1099 HE21 GLN A  73     -15.709  30.893   4.171  1.00  0.00           H  
ATOM   1100 HE22 GLN A  73     -14.347  29.836   4.013  1.00  0.00           H  
ATOM   1101  N   LEU A  74     -15.937  31.702   7.269  1.00  0.00           N  
ATOM   1102  CA  LEU A  74     -15.889  30.434   7.982  1.00  0.00           C  
ATOM   1103  C   LEU A  74     -15.738  29.281   6.991  1.00  0.00           C  
ATOM   1104  O   LEU A  74     -16.675  28.933   6.269  1.00  0.00           O  
ATOM   1105  CB  LEU A  74     -17.161  30.275   8.834  1.00  0.00           C  
ATOM   1106  CG  LEU A  74     -17.159  29.143   9.878  1.00  0.00           C  
ATOM   1107  CD1 LEU A  74     -17.361  27.784   9.226  1.00  0.00           C  
ATOM   1108  CD2 LEU A  74     -15.866  29.161  10.682  1.00  0.00           C  
ATOM   1109  H   LEU A  74     -16.796  32.170   7.189  1.00  0.00           H  
ATOM   1110  HA  LEU A  74     -15.025  30.450   8.635  1.00  0.00           H  
ATOM   1111  HB2 LEU A  74     -17.332  31.206   9.354  1.00  0.00           H  
ATOM   1112  HB3 LEU A  74     -17.992  30.105   8.162  1.00  0.00           H  
ATOM   1113  HG  LEU A  74     -17.976  29.303  10.565  1.00  0.00           H  
ATOM   1114 HD11 LEU A  74     -18.306  27.773   8.702  1.00  0.00           H  
ATOM   1115 HD12 LEU A  74     -17.363  27.016   9.986  1.00  0.00           H  
ATOM   1116 HD13 LEU A  74     -16.559  27.597   8.528  1.00  0.00           H  
ATOM   1117 HD21 LEU A  74     -15.760  30.117  11.173  1.00  0.00           H  
ATOM   1118 HD22 LEU A  74     -15.029  29.002  10.020  1.00  0.00           H  
ATOM   1119 HD23 LEU A  74     -15.893  28.377  11.423  1.00  0.00           H  
ATOM   1120  N   GLU A  75     -14.548  28.703   6.955  1.00  0.00           N  
ATOM   1121  CA  GLU A  75     -14.249  27.601   6.050  1.00  0.00           C  
ATOM   1122  C   GLU A  75     -14.222  26.263   6.784  1.00  0.00           C  
ATOM   1123  O   GLU A  75     -14.067  25.212   6.164  1.00  0.00           O  
ATOM   1124  CB  GLU A  75     -12.910  27.841   5.336  1.00  0.00           C  
ATOM   1125  CG  GLU A  75     -11.870  28.603   6.162  1.00  0.00           C  
ATOM   1126  CD  GLU A  75     -11.587  27.973   7.512  1.00  0.00           C  
ATOM   1127  OE1 GLU A  75     -10.682  27.117   7.605  1.00  0.00           O  
ATOM   1128  OE2 GLU A  75     -12.281  28.332   8.490  1.00  0.00           O  
ATOM   1129  H   GLU A  75     -13.836  29.032   7.556  1.00  0.00           H  
ATOM   1130  HA  GLU A  75     -15.033  27.568   5.311  1.00  0.00           H  
ATOM   1131  HB2 GLU A  75     -12.487  26.885   5.070  1.00  0.00           H  
ATOM   1132  HB3 GLU A  75     -13.098  28.403   4.434  1.00  0.00           H  
ATOM   1133  HG2 GLU A  75     -10.946  28.638   5.604  1.00  0.00           H  
ATOM   1134  HG3 GLU A  75     -12.229  29.610   6.320  1.00  0.00           H  
ATOM   1135  N   HIS A  76     -14.385  26.307   8.100  1.00  0.00           N  
ATOM   1136  CA  HIS A  76     -14.289  25.106   8.921  1.00  0.00           C  
ATOM   1137  C   HIS A  76     -15.460  24.150   8.692  1.00  0.00           C  
ATOM   1138  O   HIS A  76     -15.334  23.185   7.941  1.00  0.00           O  
ATOM   1139  CB  HIS A  76     -14.171  25.473  10.403  1.00  0.00           C  
ATOM   1140  CG  HIS A  76     -12.754  25.654  10.869  1.00  0.00           C  
ATOM   1141  ND1 HIS A  76     -11.921  26.648  10.405  1.00  0.00           N  
ATOM   1142  CD2 HIS A  76     -12.021  24.945  11.759  1.00  0.00           C  
ATOM   1143  CE1 HIS A  76     -10.743  26.541  10.987  1.00  0.00           C  
ATOM   1144  NE2 HIS A  76     -10.775  25.517  11.813  1.00  0.00           N  
ATOM   1145  H   HIS A  76     -14.560  27.171   8.528  1.00  0.00           H  
ATOM   1146  HA  HIS A  76     -13.384  24.596   8.628  1.00  0.00           H  
ATOM   1147  HB2 HIS A  76     -14.697  26.400  10.580  1.00  0.00           H  
ATOM   1148  HB3 HIS A  76     -14.621  24.691  10.997  1.00  0.00           H  
ATOM   1149  HD1 HIS A  76     -12.151  27.331   9.719  1.00  0.00           H  
ATOM   1150  HD2 HIS A  76     -12.353  24.086  12.324  1.00  0.00           H  
ATOM   1151  HE1 HIS A  76      -9.892  27.183  10.812  1.00  0.00           H  
ATOM   1152  HE2 HIS A  76      -9.979  25.105  12.229  1.00  0.00           H  
ATOM   1153  N   HIS A  77     -16.600  24.407   9.318  1.00  0.00           N  
ATOM   1154  CA  HIS A  77     -17.713  23.468   9.232  1.00  0.00           C  
ATOM   1155  C   HIS A  77     -18.896  24.055   8.465  1.00  0.00           C  
ATOM   1156  O   HIS A  77     -19.859  24.526   9.068  1.00  0.00           O  
ATOM   1157  CB  HIS A  77     -18.157  23.017  10.629  1.00  0.00           C  
ATOM   1158  CG  HIS A  77     -19.105  21.852  10.615  1.00  0.00           C  
ATOM   1159  ND1 HIS A  77     -20.458  21.972  10.852  1.00  0.00           N  
ATOM   1160  CD2 HIS A  77     -18.881  20.536  10.391  1.00  0.00           C  
ATOM   1161  CE1 HIS A  77     -21.025  20.781  10.774  1.00  0.00           C  
ATOM   1162  NE2 HIS A  77     -20.089  19.894  10.495  1.00  0.00           N  
ATOM   1163  H   HIS A  77     -16.698  25.232   9.841  1.00  0.00           H  
ATOM   1164  HA  HIS A  77     -17.357  22.603   8.692  1.00  0.00           H  
ATOM   1165  HB2 HIS A  77     -17.287  22.728  11.201  1.00  0.00           H  
ATOM   1166  HB3 HIS A  77     -18.648  23.841  11.126  1.00  0.00           H  
ATOM   1167  HD1 HIS A  77     -20.937  22.815  11.057  1.00  0.00           H  
ATOM   1168  HD2 HIS A  77     -17.927  20.076  10.172  1.00  0.00           H  
ATOM   1169  HE1 HIS A  77     -22.075  20.569  10.915  1.00  0.00           H  
ATOM   1170  HE2 HIS A  77     -20.252  18.941  10.276  1.00  0.00           H  
ATOM   1171  N   HIS A  78     -18.786  24.047   7.137  1.00  0.00           N  
ATOM   1172  CA  HIS A  78     -19.894  24.390   6.237  1.00  0.00           C  
ATOM   1173  C   HIS A  78     -19.371  24.436   4.813  1.00  0.00           C  
ATOM   1174  O   HIS A  78     -19.990  23.903   3.891  1.00  0.00           O  
ATOM   1175  CB  HIS A  78     -20.551  25.732   6.586  1.00  0.00           C  
ATOM   1176  CG  HIS A  78     -21.987  25.807   6.163  1.00  0.00           C  
ATOM   1177  ND1 HIS A  78     -23.031  25.514   7.012  1.00  0.00           N  
ATOM   1178  CD2 HIS A  78     -22.551  26.117   4.973  1.00  0.00           C  
ATOM   1179  CE1 HIS A  78     -24.172  25.638   6.365  1.00  0.00           C  
ATOM   1180  NE2 HIS A  78     -23.913  26.003   5.124  1.00  0.00           N  
ATOM   1181  H   HIS A  78     -17.926  23.790   6.740  1.00  0.00           H  
ATOM   1182  HA  HIS A  78     -20.632  23.603   6.309  1.00  0.00           H  
ATOM   1183  HB2 HIS A  78     -20.507  25.881   7.654  1.00  0.00           H  
ATOM   1184  HB3 HIS A  78     -20.016  26.528   6.091  1.00  0.00           H  
ATOM   1185  HD1 HIS A  78     -22.946  25.243   7.962  1.00  0.00           H  
ATOM   1186  HD2 HIS A  78     -22.028  26.402   4.071  1.00  0.00           H  
ATOM   1187  HE1 HIS A  78     -25.155  25.472   6.781  1.00  0.00           H  
ATOM   1188  HE2 HIS A  78     -24.560  25.939   4.383  1.00  0.00           H  
ATOM   1189  N   HIS A  79     -18.222  25.083   4.651  1.00  0.00           N  
ATOM   1190  CA  HIS A  79     -17.508  25.093   3.383  1.00  0.00           C  
ATOM   1191  C   HIS A  79     -16.910  23.708   3.151  1.00  0.00           C  
ATOM   1192  O   HIS A  79     -15.759  23.450   3.492  1.00  0.00           O  
ATOM   1193  CB  HIS A  79     -16.413  26.173   3.414  1.00  0.00           C  
ATOM   1194  CG  HIS A  79     -15.618  26.310   2.148  1.00  0.00           C  
ATOM   1195  ND1 HIS A  79     -14.403  25.693   1.956  1.00  0.00           N  
ATOM   1196  CD2 HIS A  79     -15.848  27.038   1.030  1.00  0.00           C  
ATOM   1197  CE1 HIS A  79     -13.919  26.036   0.779  1.00  0.00           C  
ATOM   1198  NE2 HIS A  79     -14.773  26.853   0.192  1.00  0.00           N  
ATOM   1199  H   HIS A  79     -17.841  25.569   5.411  1.00  0.00           H  
ATOM   1200  HA  HIS A  79     -18.213  25.314   2.596  1.00  0.00           H  
ATOM   1201  HB2 HIS A  79     -16.873  27.128   3.611  1.00  0.00           H  
ATOM   1202  HB3 HIS A  79     -15.723  25.945   4.214  1.00  0.00           H  
ATOM   1203  HD1 HIS A  79     -13.951  25.088   2.600  1.00  0.00           H  
ATOM   1204  HD2 HIS A  79     -16.716  27.650   0.833  1.00  0.00           H  
ATOM   1205  HE1 HIS A  79     -12.979  25.704   0.364  1.00  0.00           H  
ATOM   1206  HE2 HIS A  79     -14.535  27.460  -0.553  1.00  0.00           H  
ATOM   1207  N   HIS A  80     -17.720  22.806   2.621  1.00  0.00           N  
ATOM   1208  CA  HIS A  80     -17.329  21.407   2.516  1.00  0.00           C  
ATOM   1209  C   HIS A  80     -16.811  21.069   1.125  1.00  0.00           C  
ATOM   1210  O   HIS A  80     -17.189  21.695   0.131  1.00  0.00           O  
ATOM   1211  CB  HIS A  80     -18.496  20.487   2.905  1.00  0.00           C  
ATOM   1212  CG  HIS A  80     -19.716  20.604   2.037  1.00  0.00           C  
ATOM   1213  ND1 HIS A  80     -20.732  21.507   2.274  1.00  0.00           N  
ATOM   1214  CD2 HIS A  80     -20.091  19.903   0.941  1.00  0.00           C  
ATOM   1215  CE1 HIS A  80     -21.677  21.352   1.361  1.00  0.00           C  
ATOM   1216  NE2 HIS A  80     -21.312  20.383   0.540  1.00  0.00           N  
ATOM   1217  H   HIS A  80     -18.601  23.087   2.296  1.00  0.00           H  
ATOM   1218  HA  HIS A  80     -16.523  21.249   3.218  1.00  0.00           H  
ATOM   1219  HB2 HIS A  80     -18.160  19.462   2.855  1.00  0.00           H  
ATOM   1220  HB3 HIS A  80     -18.789  20.709   3.921  1.00  0.00           H  
ATOM   1221  HD1 HIS A  80     -20.764  22.159   3.010  1.00  0.00           H  
ATOM   1222  HD2 HIS A  80     -19.531  19.107   0.470  1.00  0.00           H  
ATOM   1223  HE1 HIS A  80     -22.592  21.922   1.298  1.00  0.00           H  
ATOM   1224  HE2 HIS A  80     -21.926  19.906  -0.066  1.00  0.00           H  
ATOM   1225  N   HIS A  81     -15.948  20.070   1.072  1.00  0.00           N  
ATOM   1226  CA  HIS A  81     -15.301  19.663  -0.164  1.00  0.00           C  
ATOM   1227  C   HIS A  81     -15.296  18.145  -0.279  1.00  0.00           C  
ATOM   1228  O   HIS A  81     -14.606  17.485   0.525  1.00  0.00           O  
ATOM   1229  CB  HIS A  81     -13.869  20.226  -0.244  1.00  0.00           C  
ATOM   1230  CG  HIS A  81     -13.078  20.099   1.030  1.00  0.00           C  
ATOM   1231  ND1 HIS A  81     -12.208  19.062   1.282  1.00  0.00           N  
ATOM   1232  CD2 HIS A  81     -13.035  20.895   2.127  1.00  0.00           C  
ATOM   1233  CE1 HIS A  81     -11.668  19.223   2.476  1.00  0.00           C  
ATOM   1234  NE2 HIS A  81     -12.151  20.327   3.009  1.00  0.00           N  
ATOM   1235  OXT HIS A  81     -15.996  17.617  -1.164  1.00  0.00           O  
ATOM   1236  H   HIS A  81     -15.745  19.570   1.900  1.00  0.00           H  
ATOM   1237  HA  HIS A  81     -15.879  20.068  -0.983  1.00  0.00           H  
ATOM   1238  HB2 HIS A  81     -13.328  19.700  -1.016  1.00  0.00           H  
ATOM   1239  HB3 HIS A  81     -13.918  21.274  -0.501  1.00  0.00           H  
ATOM   1240  HD1 HIS A  81     -12.014  18.309   0.676  1.00  0.00           H  
ATOM   1241  HD2 HIS A  81     -13.594  21.807   2.278  1.00  0.00           H  
ATOM   1242  HE1 HIS A  81     -10.949  18.560   2.937  1.00  0.00           H  
ATOM   1243  HE2 HIS A  81     -12.050  20.589   3.958  1.00  0.00           H  
TER    1244      HIS A  81                                                      
END
MOLECULE T0480.pdb
ATOM     43  N   PHE    20      -9.421  47.124  -2.332  1.00  0.00
ATOM     44  HN  PHE    20      -9.663  47.024  -3.278  1.00  0.00
ATOM     45  CA  PHE    20     -10.050  48.188  -1.549  1.00  0.00
ATOM     46  HA  PHE    20      -9.287  48.642  -0.932  1.00  0.00
ATOM     47  CB  PHE    20     -10.641  49.260  -2.478  1.00  0.00
ATOM     48  HB1 PHE    20     -11.197  49.974  -1.885  1.00  0.00
ATOM     49  HB2 PHE    20     -11.316  48.788  -3.178  1.00  0.00
ATOM     50  CG  PHE    20      -9.613  50.019  -3.274  1.00  0.00
ATOM     51  CD1 PHE    20      -9.119  49.504  -4.460  1.00  0.00
ATOM     52  HD1 PHE    20      -9.476  48.547  -4.813  1.00  0.00
ATOM     53  CD2 PHE    20      -9.145  51.251  -2.836  1.00  0.00
ATOM     54  HD2 PHE    20      -9.523  51.664  -1.912  1.00  0.00
ATOM     55  CE1 PHE    20      -8.180  50.199  -5.195  1.00  0.00
ATOM     56  HE1 PHE    20      -7.803  49.783  -6.119  1.00  0.00
ATOM     57  CE2 PHE    20      -8.206  51.949  -3.568  1.00  0.00
ATOM     58  HE2 PHE    20      -7.850  52.908  -3.217  1.00  0.00
ATOM     59  CZ  PHE    20      -7.722  51.422  -4.750  1.00  0.00
ATOM     60  HZ  PHE    20      -6.988  51.966  -5.326  1.00  0.00
ATOM     61  C   PHE    20     -11.149  47.641  -0.643  1.00  0.00
ATOM     62  O   PHE    20     -11.503  46.465  -0.706  1.00  0.00
ATOM     63  N   CYS    21     -11.685  48.510   0.204  1.00  0.00
ATOM     64  HN  CYS    21     -11.329  49.425   0.240  1.00  0.00
ATOM     65  CA  CYS    21     -12.801  48.155   1.067  1.00  0.00
ATOM     66  HA  CYS    21     -12.726  47.105   1.318  1.00  0.00
ATOM     67  HB1 CYS    21     -12.914  50.028   2.087  1.00  0.00
ATOM     68  HB2 CYS    21     -11.760  48.898   2.773  1.00  0.00
ATOM     69  C   CYS    21     -14.100  48.414   0.312  1.00  0.00
ATOM     70  O   CYS    21     -14.384  49.557  -0.023  1.00  0.00
ATOM     71  CB  CYS    21     -12.742  48.991   2.341  1.00  0.00
ATOM     72  SG  CYS    21     -13.954  48.528   3.619  1.00  0.00
ATOM     73  N   PRO    22     -14.916  47.367   0.073  1.00  0.00
ATOM     74  CA  PRO    22     -16.026  47.404  -0.893  1.00  0.00
ATOM     75  HA  PRO    22     -15.680  47.160  -1.889  1.00  0.00
ATOM     76  CB  PRO    22     -16.958  46.298  -0.401  1.00  0.00
ATOM     77  HB1 PRO    22     -17.462  45.846  -1.245  1.00  0.00
ATOM     78  HB2 PRO    22     -17.694  46.716   0.276  1.00  0.00
ATOM     79  CG  PRO    22     -16.074  45.316   0.294  1.00  0.00
ATOM     80  HG1 PRO    22     -15.795  44.526  -0.389  1.00  0.00
ATOM     81  HG2 PRO    22     -16.602  44.907   1.141  1.00  0.00
ATOM     82  CD  PRO    22     -14.843  46.065   0.763  1.00  0.00
ATOM     83  HD1 PRO    22     -13.945  45.532   0.486  1.00  0.00
ATOM     84  HD2 PRO    22     -14.875  46.204   1.835  1.00  0.00
ATOM     85  C   PRO    22     -16.770  48.741  -0.939  1.00  0.00
ATOM     86  O   PRO    22     -16.834  49.390  -1.988  1.00  0.00
ATOM     87  N   ARG    23     -17.316  49.158   0.201  1.00  0.00
ATOM     88  HN  ARG    23     -17.154  48.653   1.025  1.00  0.00
ATOM     89  CA  ARG    23     -18.164  50.344   0.238  1.00  0.00
ATOM     90  HA  ARG    23     -18.672  50.391  -0.712  1.00  0.00
ATOM     91  CB  ARG    23     -19.223  50.223   1.341  1.00  0.00
ATOM     92  HB1 ARG    23     -19.804  51.135   1.369  1.00  0.00
ATOM     93  HB2 ARG    23     -18.724  50.096   2.291  1.00  0.00
ATOM     94  CG  ARG    23     -20.180  49.050   1.141  1.00  0.00
ATOM     95  HG1 ARG    23     -19.642  48.129   1.321  1.00  0.00
ATOM     96  HG2 ARG    23     -20.538  49.061   0.121  1.00  0.00
ATOM     97  CD  ARG    23     -21.381  49.113   2.081  1.00  0.00
ATOM     98  HD1 ARG    23     -21.999  48.242   1.910  1.00  0.00
ATOM     99  HD2 ARG    23     -21.951  50.003   1.854  1.00  0.00
ATOM    100  NE  ARG    23     -20.991  49.150   3.495  1.00  0.00
ATOM    101  HE  ARG    23     -20.100  49.512   3.706  1.00  0.00
ATOM    102  CZ  ARG    23     -21.777  48.752   4.498  1.00  0.00
ATOM    103  NH1 ARG    23     -22.967  48.220   4.250  1.00  0.00
ATOM    104 HH11 ARG    23     -23.285  48.110   3.303  1.00  0.00
ATOM    105 HH12 ARG    23     -23.556  47.929   5.009  1.00  0.00
ATOM    106  NH2 ARG    23     -21.364  48.866   5.751  1.00  0.00
ATOM    107 HH21 ARG    23     -20.460  49.252   5.953  1.00  0.00
ATOM    108 HH22 ARG    23     -21.954  48.569   6.504  1.00  0.00
ATOM    109  C   ARG    23     -17.352  51.633   0.415  1.00  0.00
ATOM    110  O   ARG    23     -17.758  52.692  -0.062  1.00  0.00
ATOM    111  N   CYS    24     -16.206  51.549   1.092  1.00  0.00
ATOM    112  HN  CYS    24     -15.914  50.681   1.429  1.00  0.00
ATOM    113  CA  CYS    24     -15.370  52.739   1.328  1.00  0.00
ATOM    114  HA  CYS    24     -16.018  53.602   1.381  1.00  0.00
ATOM    115  HB1 CYS    24     -14.192  53.616   2.885  1.00  0.00
ATOM    116  HB2 CYS    24     -13.735  51.970   2.480  1.00  0.00
ATOM    117  C   CYS    24     -14.366  52.941   0.194  1.00  0.00
ATOM    118  O   CYS    24     -13.660  53.947   0.171  1.00  0.00
ATOM    119  CB  CYS    24     -14.572  52.634   2.635  1.00  0.00
ATOM    120  SG  CYS    24     -15.473  52.014   4.084  1.00  0.00
ATOM    121  N   GLY    25     -14.311  51.975  -0.727  1.00  0.00
ATOM    122  HN  GLY    25     -15.009  51.286  -0.729  1.00  0.00
ATOM    123  CA  GLY    25     -13.256  51.919  -1.735  1.00  0.00
ATOM    124  HA1 GLY    25     -13.576  51.268  -2.533  1.00  0.00
ATOM    125  HA2 GLY    25     -12.373  51.493  -1.282  1.00  0.00
ATOM    126  C   GLY    25     -12.895  53.274  -2.316  1.00  0.00
ATOM    127  O   GLY    25     -11.779  53.757  -2.106  1.00  0.00
ATOM    128  N   PRO    26     -13.818  53.919  -3.049  1.00  0.00
ATOM    129  CA  PRO    26     -13.599  55.269  -3.570  1.00  0.00
ATOM    130  HA  PRO    26     -12.703  55.315  -4.175  1.00  0.00
ATOM    131  CB  PRO    26     -14.836  55.536  -4.453  1.00  0.00
ATOM    132  HB1 PRO    26     -14.526  55.974  -5.391  1.00  0.00
ATOM    133  HB2 PRO    26     -15.511  56.212  -3.944  1.00  0.00
ATOM    134  CG  PRO    26     -15.466  54.197  -4.662  1.00  0.00
ATOM    135  HG1 PRO    26     -15.052  53.729  -5.546  1.00  0.00
ATOM    136  HG2 PRO    26     -16.537  54.305  -4.764  1.00  0.00
ATOM    137  CD  PRO    26     -15.135  53.389  -3.440  1.00  0.00
ATOM    138  HD1 PRO    26     -15.075  52.339  -3.684  1.00  0.00
ATOM    139  HD2 PRO    26     -15.868  53.560  -2.664  1.00  0.00
ATOM    140  C   PRO    26     -13.496  56.293  -2.437  1.00  0.00
ATOM    141  O   PRO    26     -14.508  56.823  -1.967  1.00  0.00
ATOM    142  N   GLY    27     -12.275  56.524  -1.966  1.00  0.00
ATOM    143  HN  GLY    27     -11.520  56.002  -2.319  1.00  0.00
ATOM    144  CA  GLY    27     -12.036  57.519  -0.932  1.00  0.00
ATOM    145  HA1 GLY    27     -12.982  57.935  -0.612  1.00  0.00
ATOM    146  HA2 GLY    27     -11.430  58.310  -1.348  1.00  0.00
ATOM    147  C   GLY    27     -11.325  56.943   0.273  1.00  0.00
ATOM    148  O   GLY    27     -10.653  57.668   1.009  1.00  0.00
ATOM    149  N   VAL    28     -11.468  55.634   0.479  1.00  0.00
ATOM    150  HN  VAL    28     -12.031  55.114  -0.136  1.00  0.00
ATOM    151  CA  VAL    28     -10.810  54.948   1.591  1.00  0.00
ATOM    152  HA  VAL    28     -10.018  55.586   1.960  1.00  0.00
ATOM    153  CB  VAL    28     -11.782  54.646   2.763  1.00  0.00
ATOM    154  HB  VAL    28     -12.477  53.886   2.424  1.00  0.00
ATOM    155  CG1 VAL    28     -11.028  54.082   3.968  1.00  0.00
ATOM    156 HG11 VAL    28     -10.300  54.803   4.309  1.00  0.00
ATOM    157 HG12 VAL    28     -10.525  53.168   3.687  1.00  0.00
ATOM    158 HG13 VAL    28     -11.728  53.875   4.766  1.00  0.00
ATOM    159  CG2 VAL    28     -12.588  55.883   3.159  1.00  0.00
ATOM    160 HG21 VAL    28     -11.917  56.666   3.482  1.00  0.00
ATOM    161 HG22 VAL    28     -13.260  55.632   3.967  1.00  0.00
ATOM    162 HG23 VAL    28     -13.162  56.229   2.311  1.00  0.00
ATOM    163  C   VAL    28     -10.205  53.631   1.123  1.00  0.00
ATOM    164  O   VAL    28     -10.910  52.621   0.993  1.00  0.00
ATOM    165  N   PHE    29      -8.907  53.645   0.861  1.00  0.00
ATOM    166  HN  PHE    29      -8.420  54.495   0.903  1.00  0.00
ATOM    167  CA  PHE    29      -8.190  52.430   0.504  1.00  0.00
ATOM    168  HA  PHE    29      -8.697  51.979  -0.339  1.00  0.00
ATOM    169  CB  PHE    29      -6.738  52.749   0.109  1.00  0.00
ATOM    170  HB1 PHE    29      -6.738  53.555  -0.613  1.00  0.00
ATOM    171  HB2 PHE    29      -6.296  51.872  -0.342  1.00  0.00
ATOM    172  CG  PHE    29      -5.864  53.166   1.270  1.00  0.00
ATOM    173  CD1 PHE    29      -4.909  52.298   1.788  1.00  0.00
ATOM    174  HD1 PHE    29      -4.786  51.319   1.348  1.00  0.00
ATOM    175  CD2 PHE    29      -6.003  54.418   1.850  1.00  0.00
ATOM    176  HD2 PHE    29      -6.739  55.104   1.458  1.00  0.00
ATOM    177  CE1 PHE    29      -4.116  52.673   2.857  1.00  0.00
ATOM    178  HE1 PHE    29      -3.377  51.988   3.249  1.00  0.00
ATOM    179  CE2 PHE    29      -5.211  54.796   2.917  1.00  0.00
ATOM    180  HE2 PHE    29      -5.331  55.775   3.358  1.00  0.00
ATOM    181  CZ  PHE    29      -4.268  53.924   3.421  1.00  0.00
ATOM    182  HZ  PHE    29      -3.650  54.219   4.258  1.00  0.00
ATOM    183  C   PHE    29      -8.210  51.449   1.679  1.00  0.00
ATOM    184  O   PHE    29      -8.458  51.838   2.825  1.00  0.00
ATOM    185  N   LEU    30      -7.958  50.182   1.396  1.00  0.00
ATOM    186  HN  LEU    30      -7.805  49.919   0.464  1.00  0.00
ATOM    187  CA  LEU    30      -7.868  49.176   2.441  1.00  0.00
ATOM    188  HA  LEU    30      -8.446  49.515   3.292  1.00  0.00
ATOM    189  CB  LEU    30      -8.437  47.841   1.939  1.00  0.00
ATOM    190  HB1 LEU    30      -7.762  47.449   1.190  1.00  0.00
ATOM    191  HB2 LEU    30      -9.389  48.040   1.467  1.00  0.00
ATOM    192  CG  LEU    30      -8.649  46.756   3.010  1.00  0.00
ATOM    193  HG  LEU    30      -7.705  46.559   3.499  1.00  0.00
ATOM    194  CD1 LEU    30      -9.637  47.226   4.075  1.00  0.00
ATOM    195 HD11 LEU    30     -10.591  47.443   3.615  1.00  0.00
ATOM    196 HD12 LEU    30      -9.257  48.119   4.550  1.00  0.00
ATOM    197 HD13 LEU    30      -9.765  46.452   4.819  1.00  0.00
ATOM    198  CD2 LEU    30      -9.129  45.452   2.368  1.00  0.00
ATOM    199 HD21 LEU    30     -10.068  45.622   1.859  1.00  0.00
ATOM    200 HD22 LEU    30      -9.268  44.701   3.133  1.00  0.00
ATOM    201 HD23 LEU    30      -8.392  45.106   1.657  1.00  0.00
ATOM    202  C   LEU    30      -6.405  49.037   2.850  1.00  0.00
ATOM    203  O   LEU    30      -5.581  48.585   2.055  1.00  0.00
ATOM    204  N   ALA    31      -6.089  49.469   4.074  1.00  0.00
ATOM    205  HN  ALA    31      -6.808  49.759   4.671  1.00  0.00
ATOM    206  CA  ALA    31      -4.708  49.517   4.560  1.00  0.00
ATOM    207  HA  ALA    31      -4.182  50.263   3.979  1.00  0.00
ATOM    208  CB  ALA    31      -4.674  49.953   6.023  1.00  0.00
ATOM    209  HB1 ALA    31      -3.648  50.043   6.352  1.00  0.00
ATOM    210  HB2 ALA    31      -5.182  49.219   6.631  1.00  0.00
ATOM    211  HB3 ALA    31      -5.167  50.908   6.126  1.00  0.00
ATOM    212  C   ALA    31      -4.007  48.174   4.380  1.00  0.00
ATOM    213  O   ALA    31      -4.101  47.290   5.237  1.00  0.00
ATOM    214  N   GLU    32      -3.331  48.023   3.246  1.00  0.00
ATOM    215  HN  GLU    32      -3.321  48.760   2.599  1.00  0.00
ATOM    216  CA  GLU    32      -2.625  46.794   2.922  1.00  0.00
ATOM    217  HA  GLU    32      -3.248  45.965   3.234  1.00  0.00
ATOM    218  CB  GLU    32      -2.386  46.686   1.408  1.00  0.00
ATOM    219  HB1 GLU    32      -1.814  47.543   1.083  1.00  0.00
ATOM    220  HB2 GLU    32      -3.342  46.691   0.903  1.00  0.00
ATOM    221  CG  GLU    32      -1.632  45.422   0.999  1.00  0.00
ATOM    222  HG1 GLU    32      -2.172  44.560   1.369  1.00  0.00
ATOM    223  HG2 GLU    32      -0.650  45.445   1.449  1.00  0.00
ATOM    224  CD  GLU    32      -1.467  45.287  -0.506  1.00  0.00
ATOM    225  OE1 GLU    32      -0.618  46.002  -1.079  1.00  0.00
ATOM    226  OE2 GLU    32      -2.171  44.448  -1.114  1.00  0.00
ATOM    227  C   GLU    32      -1.300  46.719   3.673  1.00  0.00
ATOM    228  O   GLU    32      -0.357  47.459   3.381  1.00  0.00
ATOM    229  N   HIS    33      -1.263  45.852   4.668  1.00  0.00
ATOM    230  HN  HIS    33      -2.089  45.388   4.911  1.00  0.00
ATOM    231  CA  HIS    33      -0.045  45.545   5.406  1.00  0.00
ATOM    232  HA  HIS    33       0.685  46.317   5.196  1.00  0.00
ATOM    233  CB  HIS    33      -0.317  45.503   6.914  1.00  0.00
ATOM    234  HB1 HIS    33       0.590  45.218   7.429  1.00  0.00
ATOM    235  HB2 HIS    33      -1.084  44.767   7.119  1.00  0.00
ATOM    236  CG  HIS    33      -0.772  46.815   7.476  1.00  0.00
ATOM    237  ND1 HIS    33       0.097  47.768   7.958  1.00  0.00
ATOM    238  HD1 HIS    33       1.077  47.689   7.991  1.00  0.00
ATOM    239  CD2 HIS    33      -2.014  47.330   7.633  1.00  0.00
ATOM    240  HD2 HIS    33      -2.944  46.851   7.362  1.00  0.00
ATOM    241  CE1 HIS    33      -0.589  48.809   8.385  1.00  0.00
ATOM    242  HE1 HIS    33      -0.169  49.705   8.818  1.00  0.00
ATOM    243  NE2 HIS    33      -1.873  48.572   8.199  1.00  0.00
ATOM    244  HE2 HIS    33      -2.599  49.075   8.631  1.00  0.00
ATOM    245  C   HIS    33       0.506  44.203   4.940  1.00  0.00
ATOM    246  O   HIS    33      -0.225  43.393   4.365  1.00  0.00
ATOM    247  N   ALA    34       1.782  43.964   5.214  1.00  0.00
ATOM    248  HN  ALA    34       2.282  44.621   5.746  1.00  0.00
ATOM    249  CA  ALA    34       2.468  42.759   4.751  1.00  0.00
ATOM    250  HA  ALA    34       2.479  42.779   3.670  1.00  0.00
ATOM    251  CB  ALA    34       3.914  42.763   5.235  1.00  0.00
ATOM    252  HB1 ALA    34       4.434  41.909   4.826  1.00  0.00
ATOM    253  HB2 ALA    34       3.936  42.714   6.315  1.00  0.00
ATOM    254  HB3 ALA    34       4.401  43.670   4.907  1.00  0.00
ATOM    255  C   ALA    34       1.761  41.481   5.206  1.00  0.00
ATOM    256  O   ALA    34       1.850  40.444   4.543  1.00  0.00
ATOM    257  N   ASP    35       1.049  41.561   6.329  1.00  0.00
ATOM    258  HN  ASP    35       0.954  42.428   6.773  1.00  0.00
ATOM    259  CA  ASP    35       0.416  40.383   6.923  1.00  0.00
ATOM    260  HA  ASP    35       0.770  39.510   6.392  1.00  0.00
ATOM    261  CB  ASP    35       0.816  40.251   8.399  1.00  0.00
ATOM    262  HB1 ASP    35       1.883  40.394   8.487  1.00  0.00
ATOM    263  HB2 ASP    35       0.565  39.258   8.747  1.00  0.00
ATOM    264  CG  ASP    35       0.122  41.266   9.293  1.00  0.00
ATOM    265  OD1 ASP    35       0.449  42.468   9.202  1.00  0.00
ATOM    266  OD2 ASP    35      -0.746  40.867  10.097  1.00  0.00
ATOM    267  C   ASP    35      -1.111  40.429   6.812  1.00  0.00
ATOM    268  O   ASP    35      -1.773  39.400   6.966  1.00  0.00
ATOM    269  N   ARG    36      -1.682  41.598   6.521  1.00  0.00
ATOM    270  HN  ARG    36      -1.122  42.366   6.270  1.00  0.00
ATOM    271  CA  ARG    36      -3.142  41.736   6.533  1.00  0.00
ATOM    272  HA  ARG    36      -3.550  40.949   5.917  1.00  0.00
ATOM    273  CB  ARG    36      -3.678  41.570   7.966  1.00  0.00
ATOM    274  HB1 ARG    36      -3.315  40.633   8.368  1.00  0.00
ATOM    275  HB2 ARG    36      -4.759  41.538   7.933  1.00  0.00
ATOM    276  CG  ARG    36      -3.264  42.690   8.914  1.00  0.00
ATOM    277  HG1 ARG    36      -3.731  43.611   8.594  1.00  0.00
ATOM    278  HG2 ARG    36      -2.190  42.797   8.873  1.00  0.00
ATOM    279  CD  ARG    36      -3.677  42.398  10.353  1.00  0.00
ATOM    280  HD1 ARG    36      -3.114  41.546  10.712  1.00  0.00
ATOM    281  HD2 ARG    36      -4.732  42.162  10.370  1.00  0.00
ATOM    282  NE  ARG    36      -3.436  43.539  11.239  1.00  0.00
ATOM    283  HE  ARG    36      -4.165  44.194  11.330  1.00  0.00
ATOM    284  CZ  ARG    36      -2.321  43.724  11.948  1.00  0.00
ATOM    285  NH1 ARG    36      -1.289  42.903  11.808  1.00  0.00
ATOM    286 HH11 ARG    36      -1.337  42.131  11.163  1.00  0.00
ATOM    287 HH12 ARG    36      -0.455  43.046  12.347  1.00  0.00
ATOM    288  NH2 ARG    36      -2.225  44.752  12.777  1.00  0.00
ATOM    289 HH21 ARG    36      -2.992  45.396  12.878  1.00  0.00
ATOM    290 HH22 ARG    36      -1.390  44.887  13.317  1.00  0.00
ATOM    291  C   ARG    36      -3.592  43.080   5.962  1.00  0.00
ATOM    292  O   ARG    36      -2.805  43.816   5.384  1.00  0.00
ATOM    293  N   TYR    37      -4.876  43.366   6.135  1.00  0.00
ATOM    294  HN  TYR    37      -5.429  42.719   6.609  1.00  0.00
ATOM    295  CA  TYR    37      -5.508  44.603   5.686  1.00  0.00
ATOM    296  HA  TYR    37      -4.743  45.306   5.387  1.00  0.00
ATOM    297  CB  TYR    37      -6.477  44.347   4.519  1.00  0.00
ATOM    298  HB1 TYR    37      -6.833  45.302   4.155  1.00  0.00
ATOM    299  HB2 TYR    37      -7.322  43.784   4.887  1.00  0.00
ATOM    300  CG  TYR    37      -5.912  43.586   3.333  1.00  0.00
ATOM    301  CD1 TYR    37      -5.992  42.198   3.273  1.00  0.00
ATOM    302  HD1 TYR    37      -6.438  41.661   4.097  1.00  0.00
ATOM    303  CD2 TYR    37      -5.335  44.256   2.258  1.00  0.00
ATOM    304  HD2 TYR    37      -5.265  45.334   2.286  1.00  0.00
ATOM    305  CE1 TYR    37      -5.512  41.502   2.183  1.00  0.00
ATOM    306  HE1 TYR    37      -5.586  40.425   2.155  1.00  0.00
ATOM    307  CE2 TYR    37      -4.849  43.564   1.166  1.00  0.00
ATOM    308  HE2 TYR    37      -4.402  44.101   0.342  1.00  0.00
ATOM    309  CZ  TYR    37      -4.942  42.190   1.133  1.00  0.00
ATOM    310  OH  TYR    37      -4.459  41.497   0.046  1.00  0.00
ATOM    311  HH  TYR    37      -5.120  40.864  -0.251  1.00  0.00
ATOM    312  C   TYR    37      -6.322  45.182   6.841  1.00  0.00
ATOM    313  O   TYR    37      -6.679  44.453   7.767  1.00  0.00
ATOM    314  N   SER    38      -6.636  46.471   6.777  1.00  0.00
ATOM    315  HN  SER    38      -6.247  47.026   6.068  1.00  0.00
ATOM    316  CA  SER    38      -7.535  47.084   7.751  1.00  0.00
ATOM    317  HA  SER    38      -8.327  46.375   7.956  1.00  0.00
ATOM    318  CB  SER    38      -6.797  47.393   9.060  1.00  0.00
ATOM    319  HB1 SER    38      -6.130  48.229   8.911  1.00  0.00
ATOM    320  HB2 SER    38      -6.225  46.527   9.362  1.00  0.00
ATOM    321  OG  SER    38      -7.714  47.715  10.094  1.00  0.00
ATOM    322  HG  SER    38      -8.082  46.897  10.459  1.00  0.00
ATOM    323  C   SER    38      -8.166  48.351   7.170  1.00  0.00
ATOM    324  O   SER    38      -7.687  48.894   6.172  1.00  0.00
ATOM    325  N   CYS    39      -9.256  48.806   7.780  1.00  0.00
ATOM    326  HN  CYS    39      -9.589  48.331   8.573  1.00  0.00
ATOM    327  CA  CYS    39      -9.980  49.978   7.296  1.00  0.00
ATOM    328  HA  CYS    39      -9.347  50.504   6.596  1.00  0.00
ATOM    329  HB1 CYS    39     -11.825  48.903   7.229  1.00  0.00
ATOM    330  HB2 CYS    39     -10.986  48.989   5.693  1.00  0.00
ATOM    331  C   CYS    39     -10.341  50.922   8.431  1.00  0.00
ATOM    332  O   CYS    39     -11.402  50.776   9.049  1.00  0.00
ATOM    333  CB  CYS    39     -11.253  49.545   6.574  1.00  0.00
ATOM    334  SG  CYS    39     -12.344  50.914   6.050  1.00  0.00
ATOM    335  N   GLY    40      -9.454  51.877   8.706  1.00  0.00
ATOM    336  HN  GLY    40      -8.584  51.868   8.253  1.00  0.00
ATOM    337  CA  GLY    40      -9.742  52.916   9.678  1.00  0.00
ATOM    338  HA1 GLY    40      -8.854  53.512   9.830  1.00  0.00
ATOM    339  HA2 GLY    40     -10.020  52.456  10.616  1.00  0.00
ATOM    340  C   GLY    40     -10.870  53.818   9.213  1.00  0.00
ATOM    341  O   GLY    40     -10.634  54.923   8.718  1.00  0.00
ATOM    342  N   ARG    41     -12.095  53.327   9.360  1.00  0.00
ATOM    343  HN  ARG    41     -12.200  52.466   9.822  1.00  0.00
ATOM    344  CA  ARG    41     -13.289  54.031   8.907  1.00  0.00
ATOM    345  HA  ARG    41     -13.318  54.990   9.406  1.00  0.00
ATOM    346  CB  ARG    41     -13.252  54.250   7.384  1.00  0.00
ATOM    347  HB1 ARG    41     -13.317  53.288   6.892  1.00  0.00
ATOM    348  HB2 ARG    41     -12.308  54.710   7.123  1.00  0.00
ATOM    349  CG  ARG    41     -14.378  55.137   6.858  1.00  0.00
ATOM    350  HG1 ARG    41     -15.326  54.721   7.169  1.00  0.00
ATOM    351  HG2 ARG    41     -14.332  55.156   5.778  1.00  0.00
ATOM    352  CD  ARG    41     -14.270  56.568   7.379  1.00  0.00
ATOM    353  HD1 ARG    41     -13.379  57.024   6.966  1.00  0.00
ATOM    354  HD2 ARG    41     -14.193  56.542   8.456  1.00  0.00
ATOM    355  NE  ARG    41     -15.434  57.375   7.008  1.00  0.00
ATOM    356  HE  ARG    41     -16.316  57.040   7.290  1.00  0.00
ATOM    357  CZ  ARG    41     -15.372  58.529   6.339  1.00  0.00
ATOM    358  NH1 ARG    41     -14.206  59.004   5.921  1.00  0.00
ATOM    359 HH11 ARG    41     -13.359  58.498   6.105  1.00  0.00
ATOM    360 HH12 ARG    41     -14.164  59.872   5.417  1.00  0.00
ATOM    361  NH2 ARG    41     -16.485  59.200   6.077  1.00  0.00
ATOM    362 HH21 ARG    41     -17.372  58.843   6.382  1.00  0.00
ATOM    363 HH22 ARG    41     -16.447  60.068   5.571  1.00  0.00
ATOM    364  C   ARG    41     -14.536  53.232   9.294  1.00  0.00
ATOM    365  O   ARG    41     -15.460  53.767   9.905  1.00  0.00
ATOM    366  N   CYS    42     -14.550  51.941   8.946  1.00  0.00
ATOM    367  HN  CYS    42     -13.788  51.572   8.462  1.00  0.00
ATOM    368  CA  CYS    42     -15.680  51.066   9.290  1.00  0.00
ATOM    369  HA  CYS    42     -16.324  51.612   9.967  1.00  0.00
ATOM    370  HB1 CYS    42     -16.667  51.558   7.443  1.00  0.00
ATOM    371  HB2 CYS    42     -17.452  50.281   8.357  1.00  0.00
ATOM    372  C   CYS    42     -15.190  49.810  10.010  1.00  0.00
ATOM    373  O   CYS    42     -15.972  48.902  10.291  1.00  0.00
ATOM    374  CB  CYS    42     -16.497  50.676   8.042  1.00  0.00
ATOM    375  SG  CYS    42     -15.721  49.422   6.967  1.00  0.00
ATOM    376  N   GLY    43     -13.886  49.755  10.293  1.00  0.00
ATOM    377  HN  GLY    43     -13.292  50.472   9.984  1.00  0.00
ATOM    378  CA  GLY    43     -13.333  48.655  11.068  1.00  0.00
ATOM    379  HA1 GLY    43     -13.985  48.453  11.906  1.00  0.00
ATOM    380  HA2 GLY    43     -12.365  48.951  11.446  1.00  0.00
ATOM    381  C   GLY    43     -13.167  47.383  10.264  1.00  0.00
ATOM    382  O   GLY    43     -12.919  46.319  10.828  1.00  0.00
ATOM    383  N   TYR    44     -13.292  47.490   8.943  1.00  0.00
ATOM    384  HN  TYR    44     -13.474  48.365   8.552  1.00  0.00
ATOM    385  CA  TYR    44     -13.151  46.329   8.071  1.00  0.00
ATOM    386  HA  TYR    44     -13.761  45.533   8.480  1.00  0.00
ATOM    387  CB  TYR    44     -13.634  46.650   6.644  1.00  0.00
ATOM    388  HB1 TYR    44     -12.949  47.348   6.181  1.00  0.00
ATOM    389  HB2 TYR    44     -14.613  47.103   6.698  1.00  0.00
ATOM    390  CG  TYR    44     -13.736  45.430   5.742  1.00  0.00
ATOM    391  CD1 TYR    44     -14.898  44.664   5.711  1.00  0.00
ATOM    392  HD1 TYR    44     -15.731  44.949   6.336  1.00  0.00
ATOM    393  CD2 TYR    44     -12.675  45.043   4.926  1.00  0.00
ATOM    394  HD2 TYR    44     -11.765  45.625   4.936  1.00  0.00
ATOM    395  CE1 TYR    44     -14.999  43.553   4.896  1.00  0.00
ATOM    396  HE1 TYR    44     -15.910  42.972   4.888  1.00  0.00
ATOM    397  CE2 TYR    44     -12.772  43.932   4.110  1.00  0.00
ATOM    398  HE2 TYR    44     -11.937  43.647   3.485  1.00  0.00
ATOM    399  CZ  TYR    44     -13.935  43.191   4.098  1.00  0.00
ATOM    400  OH  TYR    44     -14.035  42.084   3.285  1.00  0.00
ATOM    401  HH  TYR    44     -13.267  41.512   3.421  1.00  0.00
ATOM    402  C   TYR    44     -11.692  45.874   8.052  1.00  0.00
ATOM    403  O   TYR    44     -10.820  46.586   7.541  1.00  0.00
ATOM    404  N   THR    45     -11.440  44.710   8.635  1.00  0.00
ATOM    405  HN  THR    45     -12.181  44.224   9.056  1.00  0.00
ATOM    406  CA  THR    45     -10.111  44.123   8.690  1.00  0.00
ATOM    407  HA  THR    45      -9.436  44.742   8.108  1.00  0.00
ATOM    408  CB  THR    45      -9.598  44.072  10.151  1.00  0.00
ATOM    409  HB  THR    45     -10.307  43.509  10.743  1.00  0.00
ATOM    410  OG1 THR    45      -9.513  45.405  10.682  1.00  0.00
ATOM    411  HG1 THR    45     -10.178  45.513  11.373  1.00  0.00
ATOM    412  CG2 THR    45      -8.233  43.392  10.251  1.00  0.00
ATOM    413 HG21 THR    45      -7.903  43.395  11.280  1.00  0.00
ATOM    414 HG22 THR    45      -7.517  43.926   9.643  1.00  0.00
ATOM    415 HG23 THR    45      -8.311  42.372   9.903  1.00  0.00
ATOM    416  C   THR    45     -10.144  42.717   8.091  1.00  0.00
ATOM    417  O   THR    45     -11.064  41.940   8.359  1.00  0.00
ATOM    418  N   GLU    46      -9.150  42.411   7.270  1.00  0.00
ATOM    419  HN  GLU    46      -8.432  43.068   7.132  1.00  0.00
ATOM    420  CA  GLU    46      -9.061  41.127   6.581  1.00  0.00
ATOM    421  HA  GLU    46      -9.638  40.397   7.131  1.00  0.00
ATOM    422  CB  GLU    46      -9.617  41.256   5.152  1.00  0.00
ATOM    423  HB1 GLU    46      -9.027  41.987   4.614  1.00  0.00
ATOM    424  HB2 GLU    46     -10.638  41.607   5.206  1.00  0.00
ATOM    425  CG  GLU    46      -9.603  39.953   4.359  1.00  0.00
ATOM    426  HG1 GLU    46      -8.586  39.589   4.310  1.00  0.00
ATOM    427  HG2 GLU    46      -9.958  40.150   3.356  1.00  0.00
ATOM    428  CD  GLU    46     -10.477  38.876   4.981  1.00  0.00
ATOM    429  OE1 GLU    46      -9.978  38.115   5.835  1.00  0.00
ATOM    430  OE2 GLU    46     -11.665  38.779   4.610  1.00  0.00
ATOM    431  C   GLU    46      -7.603  40.695   6.546  1.00  0.00
ATOM    432  O   GLU    46      -6.725  41.538   6.470  1.00  0.00
ATOM    433  N   PHE    47      -7.333  39.399   6.601  1.00  0.00
ATOM    434  HN  PHE    47      -8.072  38.749   6.586  1.00  0.00
ATOM    435  CA  PHE    47      -5.950  38.917   6.656  1.00  0.00
ATOM    436  HA  PHE    47      -5.338  39.722   7.041  1.00  0.00
ATOM    437  CB  PHE    47      -5.833  37.719   7.606  1.00  0.00
ATOM    438  HB1 PHE    47      -4.848  37.284   7.507  1.00  0.00
ATOM    439  HB2 PHE    47      -6.574  36.980   7.337  1.00  0.00
ATOM    440  CG  PHE    47      -6.037  38.084   9.055  1.00  0.00
ATOM    441  CD1 PHE    47      -7.275  37.931   9.663  1.00  0.00
ATOM    442  HD1 PHE    47      -8.103  37.536   9.090  1.00  0.00
ATOM    443  CD2 PHE    47      -4.984  38.591   9.806  1.00  0.00
ATOM    444  HD2 PHE    47      -4.014  38.715   9.342  1.00  0.00
ATOM    445  CE1 PHE    47      -7.457  38.275  10.989  1.00  0.00
ATOM    446  HE1 PHE    47      -8.426  38.151  11.451  1.00  0.00
ATOM    447  CE2 PHE    47      -5.163  38.934  11.133  1.00  0.00
ATOM    448  HE2 PHE    47      -4.336  39.325  11.707  1.00  0.00
ATOM    449  CZ  PHE    47      -6.400  38.776  11.724  1.00  0.00
ATOM    450  HZ  PHE    47      -6.542  39.045  12.761  1.00  0.00
ATOM    451  C   PHE    47      -5.431  38.540   5.273  1.00  0.00
ATOM    452  O   PHE    47      -6.207  38.197   4.380  1.00  0.00
ATOM    453  N   LYS    48      -4.109  38.631   5.098  1.00  0.00
ATOM    454  HN  LYS    48      -3.558  39.035   5.806  1.00  0.00
ATOM    455  CA  LYS    48      -3.461  38.123   3.891  1.00  0.00
ATOM    456  HA  LYS    48      -3.984  38.527   3.032  1.00  0.00
ATOM    457  CB  LYS    48      -1.979  38.548   3.833  1.00  0.00
ATOM    458  HB1 LYS    48      -1.467  37.928   3.110  1.00  0.00
ATOM    459  HB2 LYS    48      -1.536  38.381   4.805  1.00  0.00
ATOM    460  CG  LYS    48      -1.748  40.015   3.454  1.00  0.00
ATOM    461  HG1 LYS    48      -0.734  40.287   3.714  1.00  0.00
ATOM    462  HG2 LYS    48      -2.437  40.634   4.012  1.00  0.00
ATOM    463  CD  LYS    48      -1.962  40.267   1.960  1.00  0.00
ATOM    464  HD1 LYS    48      -3.004  40.099   1.722  1.00  0.00
ATOM    465  HD2 LYS    48      -1.349  39.578   1.398  1.00  0.00
ATOM    466  CE  LYS    48      -1.588  41.694   1.562  1.00  0.00
ATOM    467  HE1 LYS    48      -0.547  41.862   1.800  1.00  0.00
ATOM    468  HE2 LYS    48      -2.200  42.386   2.122  1.00  0.00
ATOM    469  NZ  LYS    48      -1.795  41.935   0.107  1.00  0.00
ATOM    470  HZ1 LYS    48      -1.136  41.354  -0.450  1.00  0.00
ATOM    471  HZ2 LYS    48      -1.634  42.936  -0.124  1.00  0.00
ATOM    472  HZ3 LYS    48      -2.767  41.683  -0.163  1.00  0.00
ATOM    473  C   LYS    48      -3.585  36.600   3.875  1.00  0.00
ATOM    474  O   LYS    48      -2.753  35.890   4.447  1.00  0.00
END
