
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   70 ( 1098),  selected   70 , name 2js4_A
# Molecule2: number of CA atoms   29 (  432),  selected   29 , name T0480.pdb
# PARAMETERS: 2js4_A.T0480.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    E     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    R     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    I     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    V    10_A      F      20          1.835
LGA    C    11_A      C      21          0.876
LGA    P    12_A      P      22          0.591
LGA    V    13_A      R      23          1.681
LGA    C    14_A      C      24          1.739
LGA    K    15_A      G      25          1.741
LGA    -       -      P      26           -
LGA    -       -      G      27           -
LGA    G    16_A      V      28          1.613
LGA    R    17_A      F      29          0.230
LGA    L    18_A      L      30          0.912
LGA    E    19_A      A      31          0.647
LGA    F    20_A      E      32          1.468
LGA    Q    21_A      H      33          1.899
LGA    R    22_A      A      34          3.150
LGA    A    23_A      -       -           -
LGA    Q    24_A      -       -           -
LGA    A    25_A      D      35          1.447
LGA    E    26_A      R      36          1.152
LGA    L    27_A      Y      37          1.129
LGA    V    28_A      S      38          0.765
LGA    C    29_A      C      39          1.368
LGA    N    30_A      G      40          2.217
LGA    A    31_A      R      41          0.933
LGA    D    32_A      C      42          1.137
LGA    R    33_A      G      43          1.724
LGA    L    34_A      Y      44          1.974
LGA    A    35_A      T      45          1.197
LGA    F    36_A      E      46          1.396
LGA    P    37_A      F      47          1.008
LGA    V    38_A      K      48          1.034
LGA    R    39_A      -       -           -
LGA    D    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    V    42_A      -       -           -
LGA    P    43_A      -       -           -
LGA    I    44_A      -       -           -
LGA    M    45_A      -       -           -
LGA    L    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    A    48_A      -       -           -
LGA    E    49_A      -       -           -
LGA    A    50_A      -       -           -
LGA    R    51_A      -       -           -
LGA    S    52_A      -       -           -
LGA    L    53_A      -       -           -
LGA    D    54_A      -       -           -
LGA    A    55_A      -       -           -
LGA    E    56_A      -       -           -
LGA    A    57_A      -       -           -
LGA    P    58_A      -       -           -
LGA    A    59_A      -       -           -
LGA    Q    60_A      -       -           -
LGA    P    61_A      -       -           -
LGA    S    62_A      -       -           -
LGA    L    63_A      -       -           -
LGA    E    64_A      -       -           -
LGA    H    65_A      -       -           -
LGA    H    66_A      -       -           -
LGA    H    67_A      -       -           -
LGA    H    68_A      -       -           -
LGA    H    69_A      -       -           -
LGA    H    70_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   70   29    5.0     27    1.48    18.52     86.751     1.704

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.469743 * X  +  -0.473058 * Y  +  -0.745358 * Z  +  -7.662942
  Y_new =  -0.317283 * X  +   0.697425 * Y  +  -0.642596 * Z  +  40.528950
  Z_new =   0.823816 * X  +   0.538345 * Y  +   0.177517 * Z  +   6.523518 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.252277   -1.889315  [ DEG:    71.7502   -108.2498 ]
  Theta =  -0.968110   -2.173483  [ DEG:   -55.4686   -124.5314 ]
  Phi   =  -0.594052    2.547541  [ DEG:   -34.0367    145.9633 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2js4_A                                        
REMARK     2: T0480.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2js4_A.T0480.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   70   29   5.0   27   1.48   18.52  86.751
REMARK  ---------------------------------------------------------- 
MOLECULE 2js4_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   29-JUN-07   2JS4              
TITLE     SOLUTION NMR STRUCTURE OF BORDETELLA BRONCHISEPTICA PROTEIN           
TITLE    2 BB2007. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM TARGET              
TITLE    3 BOR54                                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0434 PROTEIN BB2007;                                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BORDETELLA BRONCHISEPTICA;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: RB50, NCTC 13252;                                            
SOURCE   5 ATCC: BAA-588;                                                       
SOURCE   6 GENE: BB2007;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: XL10;                                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    NESG, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, BETA, PSI-2,          
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE                                         
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.ELETSKY,D.SUKUMARAN,Y.WU,K.SINGARAPU,D.PARISH,D.XU,D.WANG,          
AUTHOR   2 C.NWOSU,K.CUNNINGHAM,R.XIAO,J.LIU,M.C.BARAN,G.V.T.SWAPNA,            
AUTHOR   3 T.B.ACTON,B.ROST,G.T.MONTELIONE,T.SZYPERSKI,NORTHEAST                
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   10-JUL-07 2JS4    0                                                
JRNL        AUTH   A.ELETSKY,T.SZYPERSKI                                        
JRNL        TITL   NMR SOLUTION STRUCTURE OF BORDETELLA                         
JRNL        TITL 2 BRONCHISEPTICA PROTEIN BB2007.                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JS4 A    1    62  UNP    Q7WKU6   Y2007_BORBR      1     62             
SEQRES   1 A   70  MET GLU SER ARG LEU LEU ASP ILE LEU VAL CYS PRO VAL          
SEQRES   2 A   70  CYS LYS GLY ARG LEU GLU PHE GLN ARG ALA GLN ALA GLU          
SEQRES   3 A   70  LEU VAL CYS ASN ALA ASP ARG LEU ALA PHE PRO VAL ARG          
SEQRES   4 A   70  ASP GLY VAL PRO ILE MET LEU GLU ALA GLU ALA ARG SER          
SEQRES   5 A   70  LEU ASP ALA GLU ALA PRO ALA GLN PRO SER LEU GLU HIS          
SEQRES   6 A   70  HIS HIS HIS HIS HIS                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -5.039  60.821 -21.575  1.00  0.00           N  
ATOM      2  CA  MET A   1      -4.451  61.034 -20.236  1.00  0.00           C  
ATOM      3  C   MET A   1      -3.783  59.760 -19.757  1.00  0.00           C  
ATOM      4  O   MET A   1      -4.259  58.659 -20.038  1.00  0.00           O  
ATOM      5  CB  MET A   1      -5.530  61.459 -19.235  1.00  0.00           C  
ATOM      6  CG  MET A   1      -6.144  62.816 -19.538  1.00  0.00           C  
ATOM      7  SD  MET A   1      -7.447  63.264 -18.373  1.00  0.00           S  
ATOM      8  CE  MET A   1      -7.904  64.882 -18.988  1.00  0.00           C  
ATOM      9  H2  MET A   1      -5.405  61.719 -21.954  1.00  0.00           H  
ATOM     10  HA  MET A   1      -3.706  61.813 -20.310  1.00  0.00           H  
ATOM     11  HB2 MET A   1      -6.319  60.720 -19.239  1.00  0.00           H  
ATOM     12  HB3 MET A   1      -5.093  61.500 -18.250  1.00  0.00           H  
ATOM     13  HG2 MET A   1      -5.367  63.567 -19.493  1.00  0.00           H  
ATOM     14  HG3 MET A   1      -6.564  62.793 -20.533  1.00  0.00           H  
ATOM     15  HE1 MET A   1      -8.253  64.795 -20.007  1.00  0.00           H  
ATOM     16  HE2 MET A   1      -7.044  65.535 -18.955  1.00  0.00           H  
ATOM     17  HE3 MET A   1      -8.694  65.288 -18.373  1.00  0.00           H  
ATOM     18  H1  MET A   1      -4.314  60.460 -22.228  1.00  0.00           H  
ATOM     19  H3  MET A   1      -5.816  60.128 -21.524  1.00  0.00           H  
ATOM     20  N   GLU A   2      -2.678  59.914 -19.046  1.00  0.00           N  
ATOM     21  CA  GLU A   2      -1.936  58.774 -18.534  1.00  0.00           C  
ATOM     22  C   GLU A   2      -2.137  58.658 -17.033  1.00  0.00           C  
ATOM     23  O   GLU A   2      -1.931  59.620 -16.291  1.00  0.00           O  
ATOM     24  CB  GLU A   2      -0.443  58.907 -18.850  1.00  0.00           C  
ATOM     25  CG  GLU A   2      -0.145  59.142 -20.322  1.00  0.00           C  
ATOM     26  CD  GLU A   2      -0.796  58.119 -21.228  1.00  0.00           C  
ATOM     27  OE1 GLU A   2      -0.402  56.937 -21.182  1.00  0.00           O  
ATOM     28  OE2 GLU A   2      -1.692  58.501 -22.007  1.00  0.00           O  
ATOM     29  H   GLU A   2      -2.359  60.826 -18.845  1.00  0.00           H  
ATOM     30  HA  GLU A   2      -2.321  57.885 -19.011  1.00  0.00           H  
ATOM     31  HB2 GLU A   2      -0.039  59.736 -18.287  1.00  0.00           H  
ATOM     32  HB3 GLU A   2       0.057  57.999 -18.547  1.00  0.00           H  
ATOM     33  HG2 GLU A   2      -0.506  60.121 -20.597  1.00  0.00           H  
ATOM     34  HG3 GLU A   2       0.926  59.102 -20.469  1.00  0.00           H  
ATOM     35  N   SER A   3      -2.544  57.482 -16.587  1.00  0.00           N  
ATOM     36  CA  SER A   3      -2.788  57.251 -15.175  1.00  0.00           C  
ATOM     37  C   SER A   3      -1.600  56.533 -14.546  1.00  0.00           C  
ATOM     38  O   SER A   3      -0.988  55.663 -15.171  1.00  0.00           O  
ATOM     39  CB  SER A   3      -4.070  56.433 -14.991  1.00  0.00           C  
ATOM     40  OG  SER A   3      -4.424  56.330 -13.622  1.00  0.00           O  
ATOM     41  H   SER A   3      -2.678  56.746 -17.223  1.00  0.00           H  
ATOM     42  HA  SER A   3      -2.908  58.212 -14.697  1.00  0.00           H  
ATOM     43  HB2 SER A   3      -4.880  56.913 -15.522  1.00  0.00           H  
ATOM     44  HB3 SER A   3      -3.920  55.440 -15.387  1.00  0.00           H  
ATOM     45  HG  SER A   3      -5.363  56.138 -13.546  1.00  0.00           H  
ATOM     46  N   ARG A   4      -1.260  56.921 -13.324  1.00  0.00           N  
ATOM     47  CA  ARG A   4      -0.182  56.279 -12.587  1.00  0.00           C  
ATOM     48  C   ARG A   4      -0.774  55.465 -11.438  1.00  0.00           C  
ATOM     49  O   ARG A   4      -1.145  54.303 -11.623  1.00  0.00           O  
ATOM     50  CB  ARG A   4       0.811  57.330 -12.065  1.00  0.00           C  
ATOM     51  CG  ARG A   4       1.278  58.296 -13.145  1.00  0.00           C  
ATOM     52  CD  ARG A   4       2.222  59.362 -12.609  1.00  0.00           C  
ATOM     53  NE  ARG A   4       2.454  60.412 -13.602  1.00  0.00           N  
ATOM     54  CZ  ARG A   4       3.360  61.386 -13.488  1.00  0.00           C  
ATOM     55  NH1 ARG A   4       4.145  61.464 -12.418  1.00  0.00           N  
ATOM     56  NH2 ARG A   4       3.470  62.294 -14.447  1.00  0.00           N  
ATOM     57  H   ARG A   4      -1.757  57.655 -12.901  1.00  0.00           H  
ATOM     58  HA  ARG A   4       0.330  55.608 -13.263  1.00  0.00           H  
ATOM     59  HB2 ARG A   4       0.337  57.900 -11.278  1.00  0.00           H  
ATOM     60  HB3 ARG A   4       1.678  56.825 -11.661  1.00  0.00           H  
ATOM     61  HG2 ARG A   4       1.792  57.737 -13.913  1.00  0.00           H  
ATOM     62  HG3 ARG A   4       0.412  58.780 -13.575  1.00  0.00           H  
ATOM     63  HD2 ARG A   4       1.785  59.803 -11.725  1.00  0.00           H  
ATOM     64  HD3 ARG A   4       3.163  58.901 -12.355  1.00  0.00           H  
ATOM     65  HE  ARG A   4       1.886  60.392 -14.410  1.00  0.00           H  
ATOM     66 HH11 ARG A   4       4.065  60.785 -11.677  1.00  0.00           H  
ATOM     67 HH12 ARG A   4       4.828  62.199 -12.345  1.00  0.00           H  
ATOM     68 HH21 ARG A   4       2.877  62.245 -15.260  1.00  0.00           H  
ATOM     69 HH22 ARG A   4       4.147  63.041 -14.370  1.00  0.00           H  
ATOM     70  N   LEU A   5      -0.882  56.103 -10.269  1.00  0.00           N  
ATOM     71  CA  LEU A   5      -1.590  55.550  -9.107  1.00  0.00           C  
ATOM     72  C   LEU A   5      -0.931  54.299  -8.520  1.00  0.00           C  
ATOM     73  O   LEU A   5      -0.316  53.497  -9.219  1.00  0.00           O  
ATOM     74  CB  LEU A   5      -3.057  55.243  -9.451  1.00  0.00           C  
ATOM     75  CG  LEU A   5      -4.012  56.445  -9.456  1.00  0.00           C  
ATOM     76  CD1 LEU A   5      -3.664  57.436 -10.558  1.00  0.00           C  
ATOM     77  CD2 LEU A   5      -5.452  55.977  -9.598  1.00  0.00           C  
ATOM     78  H   LEU A   5      -0.472  56.987 -10.181  1.00  0.00           H  
ATOM     79  HA  LEU A   5      -1.581  56.313  -8.345  1.00  0.00           H  
ATOM     80  HB2 LEU A   5      -3.084  54.789 -10.432  1.00  0.00           H  
ATOM     81  HB3 LEU A   5      -3.425  54.524  -8.734  1.00  0.00           H  
ATOM     82  HG  LEU A   5      -3.926  56.962  -8.510  1.00  0.00           H  
ATOM     83 HD11 LEU A   5      -3.739  56.949 -11.518  1.00  0.00           H  
ATOM     84 HD12 LEU A   5      -2.658  57.796 -10.414  1.00  0.00           H  
ATOM     85 HD13 LEU A   5      -4.352  58.268 -10.524  1.00  0.00           H  
ATOM     86 HD21 LEU A   5      -5.575  55.466 -10.543  1.00  0.00           H  
ATOM     87 HD22 LEU A   5      -6.115  56.831  -9.563  1.00  0.00           H  
ATOM     88 HD23 LEU A   5      -5.694  55.302  -8.791  1.00  0.00           H  
ATOM     89  N   LEU A   6      -1.056  54.166  -7.208  1.00  0.00           N  
ATOM     90  CA  LEU A   6      -0.697  52.938  -6.510  1.00  0.00           C  
ATOM     91  C   LEU A   6      -1.956  52.374  -5.861  1.00  0.00           C  
ATOM     92  O   LEU A   6      -1.902  51.557  -4.944  1.00  0.00           O  
ATOM     93  CB  LEU A   6       0.377  53.192  -5.437  1.00  0.00           C  
ATOM     94  CG  LEU A   6       1.806  53.446  -5.947  1.00  0.00           C  
ATOM     95  CD1 LEU A   6       2.223  52.364  -6.935  1.00  0.00           C  
ATOM     96  CD2 LEU A   6       1.933  54.831  -6.567  1.00  0.00           C  
ATOM     97  H   LEU A   6      -1.400  54.923  -6.684  1.00  0.00           H  
ATOM     98  HA  LEU A   6      -0.322  52.231  -7.237  1.00  0.00           H  
ATOM     99  HB2 LEU A   6       0.071  54.049  -4.852  1.00  0.00           H  
ATOM    100  HB3 LEU A   6       0.404  52.331  -4.785  1.00  0.00           H  
ATOM    101  HG  LEU A   6       2.486  53.399  -5.106  1.00  0.00           H  
ATOM    102 HD11 LEU A   6       2.220  51.405  -6.438  1.00  0.00           H  
ATOM    103 HD12 LEU A   6       3.216  52.573  -7.305  1.00  0.00           H  
ATOM    104 HD13 LEU A   6       1.526  52.341  -7.760  1.00  0.00           H  
ATOM    105 HD21 LEU A   6       1.684  55.578  -5.827  1.00  0.00           H  
ATOM    106 HD22 LEU A   6       1.255  54.914  -7.403  1.00  0.00           H  
ATOM    107 HD23 LEU A   6       2.947  54.984  -6.907  1.00  0.00           H  
ATOM    108  N   ASP A   7      -3.095  52.824  -6.370  1.00  0.00           N  
ATOM    109  CA  ASP A   7      -4.389  52.496  -5.796  1.00  0.00           C  
ATOM    110  C   ASP A   7      -5.016  51.319  -6.534  1.00  0.00           C  
ATOM    111  O   ASP A   7      -5.615  51.484  -7.599  1.00  0.00           O  
ATOM    112  CB  ASP A   7      -5.308  53.719  -5.861  1.00  0.00           C  
ATOM    113  CG  ASP A   7      -6.636  53.499  -5.170  1.00  0.00           C  
ATOM    114  OD1 ASP A   7      -6.631  53.096  -3.993  1.00  0.00           O  
ATOM    115  OD2 ASP A   7      -7.684  53.761  -5.796  1.00  0.00           O  
ATOM    116  H   ASP A   7      -3.064  53.379  -7.170  1.00  0.00           H  
ATOM    117  HA  ASP A   7      -4.237  52.223  -4.763  1.00  0.00           H  
ATOM    118  HB2 ASP A   7      -4.814  54.558  -5.387  1.00  0.00           H  
ATOM    119  HB3 ASP A   7      -5.497  53.962  -6.895  1.00  0.00           H  
ATOM    120  N   ILE A   8      -4.830  50.131  -5.986  1.00  0.00           N  
ATOM    121  CA  ILE A   8      -5.353  48.912  -6.598  1.00  0.00           C  
ATOM    122  C   ILE A   8      -6.628  48.414  -5.913  1.00  0.00           C  
ATOM    123  O   ILE A   8      -7.592  48.044  -6.585  1.00  0.00           O  
ATOM    124  CB  ILE A   8      -4.305  47.778  -6.600  1.00  0.00           C  
ATOM    125  CG1 ILE A   8      -3.658  47.629  -5.216  1.00  0.00           C  
ATOM    126  CG2 ILE A   8      -3.248  48.031  -7.665  1.00  0.00           C  
ATOM    127  CD1 ILE A   8      -2.689  46.470  -5.117  1.00  0.00           C  
ATOM    128  H   ILE A   8      -4.310  50.068  -5.160  1.00  0.00           H  
ATOM    129  HA  ILE A   8      -5.589  49.144  -7.626  1.00  0.00           H  
ATOM    130  HB  ILE A   8      -4.811  46.859  -6.849  1.00  0.00           H  
ATOM    131 HG12 ILE A   8      -3.116  48.532  -4.983  1.00  0.00           H  
ATOM    132 HG13 ILE A   8      -4.432  47.478  -4.479  1.00  0.00           H  
ATOM    133 HG21 ILE A   8      -3.720  48.075  -8.636  1.00  0.00           H  
ATOM    134 HG22 ILE A   8      -2.526  47.228  -7.653  1.00  0.00           H  
ATOM    135 HG23 ILE A   8      -2.748  48.968  -7.464  1.00  0.00           H  
ATOM    136 HD11 ILE A   8      -1.887  46.610  -5.828  1.00  0.00           H  
ATOM    137 HD12 ILE A   8      -3.207  45.547  -5.333  1.00  0.00           H  
ATOM    138 HD13 ILE A   8      -2.280  46.430  -4.118  1.00  0.00           H  
ATOM    139  N   LEU A   9      -6.637  48.406  -4.583  1.00  0.00           N  
ATOM    140  CA  LEU A   9      -7.744  47.819  -3.837  1.00  0.00           C  
ATOM    141  C   LEU A   9      -8.346  48.800  -2.840  1.00  0.00           C  
ATOM    142  O   LEU A   9      -7.675  49.259  -1.912  1.00  0.00           O  
ATOM    143  CB  LEU A   9      -7.295  46.552  -3.098  1.00  0.00           C  
ATOM    144  CG  LEU A   9      -7.658  45.223  -3.774  1.00  0.00           C  
ATOM    145  CD1 LEU A   9      -9.152  45.156  -4.060  1.00  0.00           C  
ATOM    146  CD2 LEU A   9      -6.856  45.015  -5.049  1.00  0.00           C  
ATOM    147  H   LEU A   9      -5.896  48.817  -4.096  1.00  0.00           H  
ATOM    148  HA  LEU A   9      -8.508  47.544  -4.550  1.00  0.00           H  
ATOM    149  HB2 LEU A   9      -6.220  46.593  -2.984  1.00  0.00           H  
ATOM    150  HB3 LEU A   9      -7.741  46.562  -2.113  1.00  0.00           H  
ATOM    151  HG  LEU A   9      -7.419  44.413  -3.099  1.00  0.00           H  
ATOM    152 HD11 LEU A   9      -9.385  44.220  -4.549  1.00  0.00           H  
ATOM    153 HD12 LEU A   9      -9.432  45.975  -4.704  1.00  0.00           H  
ATOM    154 HD13 LEU A   9      -9.702  45.223  -3.133  1.00  0.00           H  
ATOM    155 HD21 LEU A   9      -5.804  44.979  -4.811  1.00  0.00           H  
ATOM    156 HD22 LEU A   9      -7.044  45.833  -5.728  1.00  0.00           H  
ATOM    157 HD23 LEU A   9      -7.154  44.086  -5.511  1.00  0.00           H  
ATOM    158  N   VAL A  10      -9.613  49.113  -3.043  1.00  0.00           N  
ATOM    159  CA  VAL A  10     -10.370  49.911  -2.095  1.00  0.00           C  
ATOM    160  C   VAL A  10     -11.455  49.055  -1.452  1.00  0.00           C  
ATOM    161  O   VAL A  10     -11.876  48.048  -2.026  1.00  0.00           O  
ATOM    162  CB  VAL A  10     -11.022  51.146  -2.760  1.00  0.00           C  
ATOM    163  CG1 VAL A  10      -9.959  52.130  -3.225  1.00  0.00           C  
ATOM    164  CG2 VAL A  10     -11.920  50.733  -3.921  1.00  0.00           C  
ATOM    165  H   VAL A  10     -10.058  48.790  -3.854  1.00  0.00           H  
ATOM    166  HA  VAL A  10      -9.691  50.252  -1.327  1.00  0.00           H  
ATOM    167  HB  VAL A  10     -11.633  51.643  -2.019  1.00  0.00           H  
ATOM    168 HG11 VAL A  10      -9.326  51.656  -3.961  1.00  0.00           H  
ATOM    169 HG12 VAL A  10      -9.359  52.437  -2.380  1.00  0.00           H  
ATOM    170 HG13 VAL A  10     -10.435  52.994  -3.662  1.00  0.00           H  
ATOM    171 HG21 VAL A  10     -12.706  50.090  -3.556  1.00  0.00           H  
ATOM    172 HG22 VAL A  10     -11.336  50.203  -4.659  1.00  0.00           H  
ATOM    173 HG23 VAL A  10     -12.356  51.613  -4.373  1.00  0.00           H  
ATOM    174  N   CYS A  11     -11.892  49.448  -0.263  1.00  0.00           N  
ATOM    175  CA  CYS A  11     -12.959  48.744   0.439  1.00  0.00           C  
ATOM    176  C   CYS A  11     -14.213  48.674  -0.428  1.00  0.00           C  
ATOM    177  O   CYS A  11     -14.682  49.692  -0.933  1.00  0.00           O  
ATOM    178  CB  CYS A  11     -13.270  49.455   1.759  1.00  0.00           C  
ATOM    179  SG  CYS A  11     -14.653  48.745   2.686  1.00  0.00           S  
ATOM    180  H   CYS A  11     -11.482  50.239   0.160  1.00  0.00           H  
ATOM    181  HA  CYS A  11     -12.616  47.740   0.646  1.00  0.00           H  
ATOM    182  HB2 CYS A  11     -12.399  49.416   2.393  1.00  0.00           H  
ATOM    183  HB3 CYS A  11     -13.513  50.488   1.551  1.00  0.00           H  
ATOM    184  HG  CYS A  11     -14.305  48.683   3.967  1.00  0.00           H  
ATOM    185  N   PRO A  12     -14.769  47.471  -0.618  1.00  0.00           N  
ATOM    186  CA  PRO A  12     -15.954  47.269  -1.463  1.00  0.00           C  
ATOM    187  C   PRO A  12     -17.217  47.894  -0.868  1.00  0.00           C  
ATOM    188  O   PRO A  12     -18.246  47.998  -1.538  1.00  0.00           O  
ATOM    189  CB  PRO A  12     -16.089  45.745  -1.529  1.00  0.00           C  
ATOM    190  CG  PRO A  12     -15.403  45.245  -0.303  1.00  0.00           C  
ATOM    191  CD  PRO A  12     -14.283  46.207  -0.031  1.00  0.00           C  
ATOM    192  HA  PRO A  12     -15.801  47.660  -2.458  1.00  0.00           H  
ATOM    193  HB2 PRO A  12     -17.134  45.474  -1.537  1.00  0.00           H  
ATOM    194  HB3 PRO A  12     -15.610  45.379  -2.424  1.00  0.00           H  
ATOM    195  HG2 PRO A  12     -16.095  45.232   0.527  1.00  0.00           H  
ATOM    196  HG3 PRO A  12     -15.010  44.255  -0.480  1.00  0.00           H  
ATOM    197  HD3 PRO A  12     -14.128  46.313   1.031  1.00  0.00           H  
ATOM    198  HD2 PRO A  12     -13.376  45.877  -0.515  1.00  0.00           H  
ATOM    199  N   VAL A  13     -17.136  48.303   0.392  1.00  0.00           N  
ATOM    200  CA  VAL A  13     -18.283  48.889   1.071  1.00  0.00           C  
ATOM    201  C   VAL A  13     -18.109  50.396   1.265  1.00  0.00           C  
ATOM    202  O   VAL A  13     -18.966  51.184   0.863  1.00  0.00           O  
ATOM    203  CB  VAL A  13     -18.523  48.224   2.446  1.00  0.00           C  
ATOM    204  CG1 VAL A  13     -19.775  48.776   3.109  1.00  0.00           C  
ATOM    205  CG2 VAL A  13     -18.616  46.712   2.304  1.00  0.00           C  
ATOM    206  H   VAL A  13     -16.290  48.198   0.875  1.00  0.00           H  
ATOM    207  HA  VAL A  13     -19.154  48.717   0.456  1.00  0.00           H  
ATOM    208  HB  VAL A  13     -17.678  48.451   3.080  1.00  0.00           H  
ATOM    209 HG11 VAL A  13     -19.906  48.309   4.073  1.00  0.00           H  
ATOM    210 HG12 VAL A  13     -20.633  48.566   2.487  1.00  0.00           H  
ATOM    211 HG13 VAL A  13     -19.675  49.843   3.237  1.00  0.00           H  
ATOM    212 HG21 VAL A  13     -18.767  46.269   3.278  1.00  0.00           H  
ATOM    213 HG22 VAL A  13     -17.700  46.330   1.876  1.00  0.00           H  
ATOM    214 HG23 VAL A  13     -19.447  46.460   1.662  1.00  0.00           H  
ATOM    215  N   CYS A  14     -16.998  50.791   1.871  1.00  0.00           N  
ATOM    216  CA  CYS A  14     -16.767  52.190   2.208  1.00  0.00           C  
ATOM    217  C   CYS A  14     -15.983  52.907   1.108  1.00  0.00           C  
ATOM    218  O   CYS A  14     -15.891  54.134   1.102  1.00  0.00           O  
ATOM    219  CB  CYS A  14     -16.014  52.281   3.537  1.00  0.00           C  
ATOM    220  SG  CYS A  14     -16.027  53.924   4.296  1.00  0.00           S  
ATOM    221  H   CYS A  14     -16.323  50.123   2.116  1.00  0.00           H  
ATOM    222  HA  CYS A  14     -17.726  52.669   2.317  1.00  0.00           H  
ATOM    223  HB2 CYS A  14     -16.461  51.593   4.240  1.00  0.00           H  
ATOM    224  HB3 CYS A  14     -14.983  51.999   3.377  1.00  0.00           H  
ATOM    225  HG  CYS A  14     -16.548  53.793   5.513  1.00  0.00           H  
ATOM    226  N   LYS A  15     -15.433  52.129   0.172  1.00  0.00           N  
ATOM    227  CA  LYS A  15     -14.608  52.656  -0.922  1.00  0.00           C  
ATOM    228  C   LYS A  15     -13.370  53.396  -0.408  1.00  0.00           C  
ATOM    229  O   LYS A  15     -12.746  54.167  -1.136  1.00  0.00           O  
ATOM    230  CB  LYS A  15     -15.446  53.554  -1.833  1.00  0.00           C  
ATOM    231  CG  LYS A  15     -16.566  52.803  -2.530  1.00  0.00           C  
ATOM    232  CD  LYS A  15     -16.027  51.790  -3.526  1.00  0.00           C  
ATOM    233  CE  LYS A  15     -17.150  51.002  -4.181  1.00  0.00           C  
ATOM    234  NZ  LYS A  15     -16.648  50.084  -5.238  1.00  0.00           N  
ATOM    235  H   LYS A  15     -15.614  51.169   0.195  1.00  0.00           H  
ATOM    236  HA  LYS A  15     -14.269  51.809  -1.500  1.00  0.00           H  
ATOM    237  HB2 LYS A  15     -15.881  54.347  -1.244  1.00  0.00           H  
ATOM    238  HB3 LYS A  15     -14.804  53.983  -2.588  1.00  0.00           H  
ATOM    239  HG2 LYS A  15     -17.151  52.280  -1.787  1.00  0.00           H  
ATOM    240  HG3 LYS A  15     -17.191  53.508  -3.048  1.00  0.00           H  
ATOM    241  HD2 LYS A  15     -15.473  52.311  -4.291  1.00  0.00           H  
ATOM    242  HD3 LYS A  15     -15.374  51.104  -3.007  1.00  0.00           H  
ATOM    243  HE2 LYS A  15     -17.654  50.423  -3.421  1.00  0.00           H  
ATOM    244  HE3 LYS A  15     -17.850  51.700  -4.621  1.00  0.00           H  
ATOM    245  HZ1 LYS A  15     -15.913  49.453  -4.848  1.00  0.00           H  
ATOM    246  HZ2 LYS A  15     -16.239  50.630  -6.027  1.00  0.00           H  
ATOM    247  HZ3 LYS A  15     -17.429  49.502  -5.605  1.00  0.00           H  
ATOM    248  N   GLY A  16     -13.009  53.137   0.840  1.00  0.00           N  
ATOM    249  CA  GLY A  16     -11.785  53.680   1.383  1.00  0.00           C  
ATOM    250  C   GLY A  16     -10.612  52.793   1.043  1.00  0.00           C  
ATOM    251  O   GLY A  16     -10.762  51.571   0.969  1.00  0.00           O  
ATOM    252  H   GLY A  16     -13.578  52.568   1.393  1.00  0.00           H  
ATOM    253  HA2 GLY A  16     -11.618  54.663   0.966  1.00  0.00           H  
ATOM    254  HA3 GLY A  16     -11.871  53.756   2.456  1.00  0.00           H  
ATOM    255  N   ARG A  17      -9.455  53.393   0.815  1.00  0.00           N  
ATOM    256  CA  ARG A  17      -8.271  52.634   0.436  1.00  0.00           C  
ATOM    257  C   ARG A  17      -7.833  51.717   1.573  1.00  0.00           C  
ATOM    258  O   ARG A  17      -7.842  52.110   2.742  1.00  0.00           O  
ATOM    259  CB  ARG A  17      -7.139  53.585   0.041  1.00  0.00           C  
ATOM    260  CG  ARG A  17      -5.867  52.879  -0.403  1.00  0.00           C  
ATOM    261  CD  ARG A  17      -4.865  53.867  -0.972  1.00  0.00           C  
ATOM    262  NE  ARG A  17      -5.387  54.529  -2.167  1.00  0.00           N  
ATOM    263  CZ  ARG A  17      -5.285  55.835  -2.409  1.00  0.00           C  
ATOM    264  NH1 ARG A  17      -4.685  56.633  -1.533  1.00  0.00           N  
ATOM    265  NH2 ARG A  17      -5.799  56.340  -3.523  1.00  0.00           N  
ATOM    266  H   ARG A  17      -9.393  54.372   0.908  1.00  0.00           H  
ATOM    267  HA  ARG A  17      -8.533  52.026  -0.418  1.00  0.00           H  
ATOM    268  HB2 ARG A  17      -7.478  54.213  -0.771  1.00  0.00           H  
ATOM    269  HB3 ARG A  17      -6.900  54.211   0.889  1.00  0.00           H  
ATOM    270  HG2 ARG A  17      -5.426  52.382   0.449  1.00  0.00           H  
ATOM    271  HG3 ARG A  17      -6.114  52.149  -1.161  1.00  0.00           H  
ATOM    272  HD2 ARG A  17      -4.650  54.614  -0.223  1.00  0.00           H  
ATOM    273  HD3 ARG A  17      -3.959  53.339  -1.228  1.00  0.00           H  
ATOM    274  HE  ARG A  17      -5.857  53.954  -2.832  1.00  0.00           H  
ATOM    275 HH11 ARG A  17      -4.301  56.256  -0.689  1.00  0.00           H  
ATOM    276 HH12 ARG A  17      -4.631  57.624  -1.706  1.00  0.00           H  
ATOM    277 HH21 ARG A  17      -6.264  55.739  -4.178  1.00  0.00           H  
ATOM    278 HH22 ARG A  17      -5.734  57.330  -3.715  1.00  0.00           H  
ATOM    279  N   LEU A  18      -7.462  50.492   1.223  1.00  0.00           N  
ATOM    280  CA  LEU A  18      -7.051  49.507   2.208  1.00  0.00           C  
ATOM    281  C   LEU A  18      -5.638  49.798   2.701  1.00  0.00           C  
ATOM    282  O   LEU A  18      -4.808  50.335   1.965  1.00  0.00           O  
ATOM    283  CB  LEU A  18      -7.137  48.098   1.614  1.00  0.00           C  
ATOM    284  CG  LEU A  18      -8.535  47.680   1.154  1.00  0.00           C  
ATOM    285  CD1 LEU A  18      -8.500  46.301   0.519  1.00  0.00           C  
ATOM    286  CD2 LEU A  18      -9.511  47.705   2.322  1.00  0.00           C  
ATOM    287  H   LEU A  18      -7.457  50.248   0.272  1.00  0.00           H  
ATOM    288  HA  LEU A  18      -7.729  49.575   3.047  1.00  0.00           H  
ATOM    289  HB2 LEU A  18      -6.470  48.048   0.764  1.00  0.00           H  
ATOM    290  HB3 LEU A  18      -6.799  47.393   2.356  1.00  0.00           H  
ATOM    291  HG  LEU A  18      -8.885  48.380   0.408  1.00  0.00           H  
ATOM    292 HD11 LEU A  18      -7.813  46.306  -0.313  1.00  0.00           H  
ATOM    293 HD12 LEU A  18      -9.488  46.039   0.170  1.00  0.00           H  
ATOM    294 HD13 LEU A  18      -8.174  45.577   1.251  1.00  0.00           H  
ATOM    295 HD21 LEU A  18      -9.141  47.071   3.114  1.00  0.00           H  
ATOM    296 HD22 LEU A  18     -10.475  47.347   1.994  1.00  0.00           H  
ATOM    297 HD23 LEU A  18      -9.608  48.717   2.687  1.00  0.00           H  
ATOM    298  N   GLU A  19      -5.378  49.451   3.950  1.00  0.00           N  
ATOM    299  CA  GLU A  19      -4.094  49.720   4.574  1.00  0.00           C  
ATOM    300  C   GLU A  19      -3.389  48.402   4.849  1.00  0.00           C  
ATOM    301  O   GLU A  19      -3.774  47.645   5.741  1.00  0.00           O  
ATOM    302  CB  GLU A  19      -4.312  50.528   5.856  1.00  0.00           C  
ATOM    303  CG  GLU A  19      -3.125  51.375   6.292  1.00  0.00           C  
ATOM    304  CD  GLU A  19      -2.114  50.616   7.125  1.00  0.00           C  
ATOM    305  OE1 GLU A  19      -2.389  50.374   8.321  1.00  0.00           O  
ATOM    306  OE2 GLU A  19      -1.027  50.292   6.601  1.00  0.00           O  
ATOM    307  H   GLU A  19      -6.072  48.988   4.471  1.00  0.00           H  
ATOM    308  HA  GLU A  19      -3.501  50.302   3.884  1.00  0.00           H  
ATOM    309  HB2 GLU A  19      -5.148  51.185   5.702  1.00  0.00           H  
ATOM    310  HB3 GLU A  19      -4.549  49.844   6.657  1.00  0.00           H  
ATOM    311  HG2 GLU A  19      -2.627  51.748   5.410  1.00  0.00           H  
ATOM    312  HG3 GLU A  19      -3.492  52.209   6.873  1.00  0.00           H  
ATOM    313  N   PHE A  20      -2.375  48.129   4.053  1.00  0.00           N  
ATOM    314  CA  PHE A  20      -1.709  46.833   4.068  1.00  0.00           C  
ATOM    315  C   PHE A  20      -0.683  46.740   5.188  1.00  0.00           C  
ATOM    316  O   PHE A  20       0.378  47.362   5.132  1.00  0.00           O  
ATOM    317  CB  PHE A  20      -1.041  46.561   2.717  1.00  0.00           C  
ATOM    318  CG  PHE A  20      -0.241  45.283   2.679  1.00  0.00           C  
ATOM    319  CD1 PHE A  20      -0.868  44.052   2.776  1.00  0.00           C  
ATOM    320  CD2 PHE A  20       1.141  45.315   2.549  1.00  0.00           C  
ATOM    321  CE1 PHE A  20      -0.136  42.879   2.747  1.00  0.00           C  
ATOM    322  CE2 PHE A  20       1.877  44.145   2.521  1.00  0.00           C  
ATOM    323  CZ  PHE A  20       1.238  42.924   2.618  1.00  0.00           C  
ATOM    324  H   PHE A  20      -2.055  48.827   3.449  1.00  0.00           H  
ATOM    325  HA  PHE A  20      -2.466  46.081   4.236  1.00  0.00           H  
ATOM    326  HB2 PHE A  20      -1.804  46.499   1.957  1.00  0.00           H  
ATOM    327  HB3 PHE A  20      -0.376  47.380   2.484  1.00  0.00           H  
ATOM    328  HD1 PHE A  20      -1.941  44.012   2.878  1.00  0.00           H  
ATOM    329  HD2 PHE A  20       1.643  46.266   2.473  1.00  0.00           H  
ATOM    330  HE1 PHE A  20      -0.639  41.925   2.824  1.00  0.00           H  
ATOM    331  HE2 PHE A  20       2.952  44.184   2.420  1.00  0.00           H  
ATOM    332  HZ  PHE A  20       1.812  42.009   2.595  1.00  0.00           H  
ATOM    333  N   GLN A  21      -1.007  45.957   6.200  1.00  0.00           N  
ATOM    334  CA  GLN A  21      -0.099  45.714   7.297  1.00  0.00           C  
ATOM    335  C   GLN A  21       0.480  44.310   7.196  1.00  0.00           C  
ATOM    336  O   GLN A  21      -0.014  43.473   6.439  1.00  0.00           O  
ATOM    337  CB  GLN A  21      -0.814  45.910   8.631  1.00  0.00           C  
ATOM    338  CG  GLN A  21      -1.110  47.358   8.936  1.00  0.00           C  
ATOM    339  CD  GLN A  21      -1.756  47.541  10.284  1.00  0.00           C  
ATOM    340  OE1 GLN A  21      -1.536  46.763  11.214  1.00  0.00           O  
ATOM    341  NE2 GLN A  21      -2.544  48.584  10.401  1.00  0.00           N  
ATOM    342  H   GLN A  21      -1.889  45.521   6.210  1.00  0.00           H  
ATOM    343  HA  GLN A  21       0.707  46.428   7.220  1.00  0.00           H  
ATOM    344  HB2 GLN A  21      -1.746  45.369   8.610  1.00  0.00           H  
ATOM    345  HB3 GLN A  21      -0.199  45.521   9.422  1.00  0.00           H  
ATOM    346  HG2 GLN A  21      -0.188  47.917   8.919  1.00  0.00           H  
ATOM    347  HG3 GLN A  21      -1.778  47.743   8.178  1.00  0.00           H  
ATOM    348 HE21 GLN A  21      -2.654  49.170   9.613  1.00  0.00           H  
ATOM    349 HE22 GLN A  21      -2.998  48.729  11.255  1.00  0.00           H  
ATOM    350  N   ARG A  22       1.534  44.061   7.951  1.00  0.00           N  
ATOM    351  CA  ARG A  22       2.217  42.780   7.890  1.00  0.00           C  
ATOM    352  C   ARG A  22       2.226  42.113   9.256  1.00  0.00           C  
ATOM    353  O   ARG A  22       3.094  41.289   9.547  1.00  0.00           O  
ATOM    354  CB  ARG A  22       3.649  42.969   7.387  1.00  0.00           C  
ATOM    355  CG  ARG A  22       3.729  43.543   5.983  1.00  0.00           C  
ATOM    356  CD  ARG A  22       5.167  43.707   5.528  1.00  0.00           C  
ATOM    357  NE  ARG A  22       5.869  42.429   5.473  1.00  0.00           N  
ATOM    358  CZ  ARG A  22       7.189  42.298   5.575  1.00  0.00           C  
ATOM    359  NH1 ARG A  22       7.951  43.361   5.803  1.00  0.00           N  
ATOM    360  NH2 ARG A  22       7.742  41.098   5.471  1.00  0.00           N  
ATOM    361  H   ARG A  22       1.858  44.750   8.568  1.00  0.00           H  
ATOM    362  HA  ARG A  22       1.680  42.150   7.196  1.00  0.00           H  
ATOM    363  HB2 ARG A  22       4.167  43.639   8.058  1.00  0.00           H  
ATOM    364  HB3 ARG A  22       4.149  42.012   7.392  1.00  0.00           H  
ATOM    365  HG2 ARG A  22       3.222  42.876   5.304  1.00  0.00           H  
ATOM    366  HG3 ARG A  22       3.246  44.509   5.974  1.00  0.00           H  
ATOM    367  HD2 ARG A  22       5.170  44.151   4.543  1.00  0.00           H  
ATOM    368  HD3 ARG A  22       5.679  44.360   6.218  1.00  0.00           H  
ATOM    369  HE  ARG A  22       5.321  41.616   5.338  1.00  0.00           H  
ATOM    370 HH11 ARG A  22       7.534  44.277   5.902  1.00  0.00           H  
ATOM    371 HH12 ARG A  22       8.945  43.262   5.871  1.00  0.00           H  
ATOM    372 HH21 ARG A  22       7.167  40.291   5.315  1.00  0.00           H  
ATOM    373 HH22 ARG A  22       8.746  40.990   5.548  1.00  0.00           H  
ATOM    374  N   ALA A  23       1.245  42.452  10.082  1.00  0.00           N  
ATOM    375  CA  ALA A  23       1.133  41.859  11.408  1.00  0.00           C  
ATOM    376  C   ALA A  23       0.573  40.450  11.283  1.00  0.00           C  
ATOM    377  O   ALA A  23       1.264  39.464  11.546  1.00  0.00           O  
ATOM    378  CB  ALA A  23       0.259  42.720  12.311  1.00  0.00           C  
ATOM    379  H   ALA A  23       0.562  43.093   9.780  1.00  0.00           H  
ATOM    380  HA  ALA A  23       2.123  41.808  11.839  1.00  0.00           H  
ATOM    381  HB1 ALA A  23      -0.735  42.788  11.894  1.00  0.00           H  
ATOM    382  HB2 ALA A  23       0.684  43.709  12.388  1.00  0.00           H  
ATOM    383  HB3 ALA A  23       0.205  42.274  13.293  1.00  0.00           H  
ATOM    384  N   GLN A  24      -0.676  40.365  10.859  1.00  0.00           N  
ATOM    385  CA  GLN A  24      -1.286  39.091  10.517  1.00  0.00           C  
ATOM    386  C   GLN A  24      -1.512  39.043   9.013  1.00  0.00           C  
ATOM    387  O   GLN A  24      -2.251  38.195   8.509  1.00  0.00           O  
ATOM    388  CB  GLN A  24      -2.617  38.896  11.255  1.00  0.00           C  
ATOM    389  CG  GLN A  24      -2.496  38.355  12.678  1.00  0.00           C  
ATOM    390  CD  GLN A  24      -1.894  39.346  13.662  1.00  0.00           C  
ATOM    391  OE1 GLN A  24      -2.607  40.147  14.269  1.00  0.00           O  
ATOM    392  NE2 GLN A  24      -0.590  39.268  13.869  1.00  0.00           N  
ATOM    393  H   GLN A  24      -1.209  41.192  10.763  1.00  0.00           H  
ATOM    394  HA  GLN A  24      -0.602  38.303  10.799  1.00  0.00           H  
ATOM    395  HB2 GLN A  24      -3.123  39.849  11.302  1.00  0.00           H  
ATOM    396  HB3 GLN A  24      -3.226  38.210  10.686  1.00  0.00           H  
ATOM    397  HG2 GLN A  24      -3.482  38.090  13.028  1.00  0.00           H  
ATOM    398  HG3 GLN A  24      -1.879  37.471  12.658  1.00  0.00           H  
ATOM    399 HE21 GLN A  24      -0.082  38.586  13.382  1.00  0.00           H  
ATOM    400 HE22 GLN A  24      -0.180  39.903  14.503  1.00  0.00           H  
ATOM    401  N   ALA A  25      -0.849  39.968   8.315  1.00  0.00           N  
ATOM    402  CA  ALA A  25      -1.010  40.144   6.875  1.00  0.00           C  
ATOM    403  C   ALA A  25      -2.445  40.536   6.555  1.00  0.00           C  
ATOM    404  O   ALA A  25      -3.233  39.734   6.057  1.00  0.00           O  
ATOM    405  CB  ALA A  25      -0.599  38.892   6.106  1.00  0.00           C  
ATOM    406  H   ALA A  25      -0.241  40.566   8.795  1.00  0.00           H  
ATOM    407  HA  ALA A  25      -0.357  40.952   6.574  1.00  0.00           H  
ATOM    408  HB1 ALA A  25      -0.713  39.062   5.045  1.00  0.00           H  
ATOM    409  HB2 ALA A  25      -1.223  38.063   6.408  1.00  0.00           H  
ATOM    410  HB3 ALA A  25       0.433  38.662   6.326  1.00  0.00           H  
ATOM    411  N   GLU A  26      -2.783  41.772   6.873  1.00  0.00           N  
ATOM    412  CA  GLU A  26      -4.154  42.227   6.779  1.00  0.00           C  
ATOM    413  C   GLU A  26      -4.277  43.551   6.030  1.00  0.00           C  
ATOM    414  O   GLU A  26      -3.407  44.420   6.115  1.00  0.00           O  
ATOM    415  CB  GLU A  26      -4.752  42.365   8.184  1.00  0.00           C  
ATOM    416  CG  GLU A  26      -4.014  43.340   9.102  1.00  0.00           C  
ATOM    417  CD  GLU A  26      -2.786  42.739   9.771  1.00  0.00           C  
ATOM    418  OE1 GLU A  26      -1.675  42.829   9.205  1.00  0.00           O  
ATOM    419  OE2 GLU A  26      -2.924  42.194  10.888  1.00  0.00           O  
ATOM    420  H   GLU A  26      -2.092  42.393   7.194  1.00  0.00           H  
ATOM    421  HA  GLU A  26      -4.713  41.477   6.241  1.00  0.00           H  
ATOM    422  HB2 GLU A  26      -5.772  42.697   8.090  1.00  0.00           H  
ATOM    423  HB3 GLU A  26      -4.746  41.391   8.653  1.00  0.00           H  
ATOM    424  HG2 GLU A  26      -3.701  44.194   8.519  1.00  0.00           H  
ATOM    425  HG3 GLU A  26      -4.698  43.667   9.871  1.00  0.00           H  
ATOM    426  N   LEU A  27      -5.362  43.682   5.279  1.00  0.00           N  
ATOM    427  CA  LEU A  27      -5.706  44.935   4.626  1.00  0.00           C  
ATOM    428  C   LEU A  27      -6.717  45.684   5.484  1.00  0.00           C  
ATOM    429  O   LEU A  27      -7.915  45.390   5.453  1.00  0.00           O  
ATOM    430  CB  LEU A  27      -6.305  44.681   3.242  1.00  0.00           C  
ATOM    431  CG  LEU A  27      -5.478  43.783   2.318  1.00  0.00           C  
ATOM    432  CD1 LEU A  27      -6.284  43.402   1.085  1.00  0.00           C  
ATOM    433  CD2 LEU A  27      -4.199  44.489   1.907  1.00  0.00           C  
ATOM    434  H   LEU A  27      -5.952  42.903   5.155  1.00  0.00           H  
ATOM    435  HA  LEU A  27      -4.807  45.524   4.531  1.00  0.00           H  
ATOM    436  HB2 LEU A  27      -7.279  44.238   3.373  1.00  0.00           H  
ATOM    437  HB3 LEU A  27      -6.431  45.635   2.754  1.00  0.00           H  
ATOM    438  HG  LEU A  27      -5.213  42.877   2.844  1.00  0.00           H  
ATOM    439 HD11 LEU A  27      -7.192  42.905   1.390  1.00  0.00           H  
ATOM    440 HD12 LEU A  27      -5.701  42.737   0.464  1.00  0.00           H  
ATOM    441 HD13 LEU A  27      -6.530  44.293   0.527  1.00  0.00           H  
ATOM    442 HD21 LEU A  27      -4.442  45.387   1.361  1.00  0.00           H  
ATOM    443 HD22 LEU A  27      -3.610  43.834   1.281  1.00  0.00           H  
ATOM    444 HD23 LEU A  27      -3.632  44.747   2.790  1.00  0.00           H  
ATOM    445  N   VAL A  28      -6.233  46.626   6.268  1.00  0.00           N  
ATOM    446  CA  VAL A  28      -7.079  47.350   7.198  1.00  0.00           C  
ATOM    447  C   VAL A  28      -7.963  48.359   6.473  1.00  0.00           C  
ATOM    448  O   VAL A  28      -7.476  49.216   5.738  1.00  0.00           O  
ATOM    449  CB  VAL A  28      -6.235  48.080   8.267  1.00  0.00           C  
ATOM    450  CG1 VAL A  28      -7.125  48.829   9.246  1.00  0.00           C  
ATOM    451  CG2 VAL A  28      -5.346  47.090   9.014  1.00  0.00           C  
ATOM    452  H   VAL A  28      -5.274  46.842   6.222  1.00  0.00           H  
ATOM    453  HA  VAL A  28      -7.709  46.632   7.701  1.00  0.00           H  
ATOM    454  HB  VAL A  28      -5.602  48.798   7.768  1.00  0.00           H  
ATOM    455 HG11 VAL A  28      -7.777  48.127   9.748  1.00  0.00           H  
ATOM    456 HG12 VAL A  28      -7.722  49.558   8.714  1.00  0.00           H  
ATOM    457 HG13 VAL A  28      -6.511  49.331   9.975  1.00  0.00           H  
ATOM    458 HG21 VAL A  28      -4.688  46.595   8.316  1.00  0.00           H  
ATOM    459 HG22 VAL A  28      -5.964  46.354   9.506  1.00  0.00           H  
ATOM    460 HG23 VAL A  28      -4.760  47.616   9.751  1.00  0.00           H  
ATOM    461  N   CYS A  29      -9.263  48.234   6.667  1.00  0.00           N  
ATOM    462  CA  CYS A  29     -10.203  49.223   6.177  1.00  0.00           C  
ATOM    463  C   CYS A  29     -10.168  50.424   7.109  1.00  0.00           C  
ATOM    464  O   CYS A  29     -10.792  50.408   8.176  1.00  0.00           O  
ATOM    465  CB  CYS A  29     -11.612  48.640   6.119  1.00  0.00           C  
ATOM    466  SG  CYS A  29     -11.725  47.101   5.182  1.00  0.00           S  
ATOM    467  H   CYS A  29      -9.598  47.459   7.170  1.00  0.00           H  
ATOM    468  HA  CYS A  29      -9.894  49.527   5.189  1.00  0.00           H  
ATOM    469  HB2 CYS A  29     -11.949  48.435   7.123  1.00  0.00           H  
ATOM    470  HB3 CYS A  29     -12.275  49.357   5.660  1.00  0.00           H  
ATOM    471  HG  CYS A  29     -10.494  46.740   4.838  1.00  0.00           H  
ATOM    472  N   ASN A  30      -9.418  51.444   6.714  1.00  0.00           N  
ATOM    473  CA  ASN A  30      -9.109  52.570   7.581  1.00  0.00           C  
ATOM    474  C   ASN A  30     -10.291  53.531   7.696  1.00  0.00           C  
ATOM    475  O   ASN A  30     -10.167  54.734   7.464  1.00  0.00           O  
ATOM    476  CB  ASN A  30      -7.876  53.290   7.038  1.00  0.00           C  
ATOM    477  CG  ASN A  30      -7.024  53.892   8.131  1.00  0.00           C  
ATOM    478  OD1 ASN A  30      -7.523  54.317   9.171  1.00  0.00           O  
ATOM    479  ND2 ASN A  30      -5.722  53.916   7.907  1.00  0.00           N  
ATOM    480  H   ASN A  30      -9.047  51.439   5.807  1.00  0.00           H  
ATOM    481  HA  ASN A  30      -8.884  52.176   8.562  1.00  0.00           H  
ATOM    482  HB2 ASN A  30      -7.273  52.590   6.485  1.00  0.00           H  
ATOM    483  HB3 ASN A  30      -8.195  54.084   6.376  1.00  0.00           H  
ATOM    484 HD21 ASN A  30      -5.389  53.556   7.057  1.00  0.00           H  
ATOM    485 HD22 ASN A  30      -5.144  54.290   8.595  1.00  0.00           H  
ATOM    486  N   ALA A  31     -11.434  52.975   8.055  1.00  0.00           N  
ATOM    487  CA  ALA A  31     -12.647  53.738   8.297  1.00  0.00           C  
ATOM    488  C   ALA A  31     -13.651  52.875   9.042  1.00  0.00           C  
ATOM    489  O   ALA A  31     -14.350  53.338   9.943  1.00  0.00           O  
ATOM    490  CB  ALA A  31     -13.244  54.236   6.988  1.00  0.00           C  
ATOM    491  H   ALA A  31     -11.459  52.000   8.161  1.00  0.00           H  
ATOM    492  HA  ALA A  31     -12.390  54.594   8.905  1.00  0.00           H  
ATOM    493  HB1 ALA A  31     -12.531  54.875   6.490  1.00  0.00           H  
ATOM    494  HB2 ALA A  31     -14.148  54.796   7.191  1.00  0.00           H  
ATOM    495  HB3 ALA A  31     -13.477  53.393   6.354  1.00  0.00           H  
ATOM    496  N   ASP A  32     -13.703  51.605   8.659  1.00  0.00           N  
ATOM    497  CA  ASP A  32     -14.623  50.650   9.267  1.00  0.00           C  
ATOM    498  C   ASP A  32     -13.946  49.894  10.405  1.00  0.00           C  
ATOM    499  O   ASP A  32     -14.599  49.155  11.140  1.00  0.00           O  
ATOM    500  CB  ASP A  32     -15.115  49.647   8.220  1.00  0.00           C  
ATOM    501  CG  ASP A  32     -15.756  50.314   7.023  1.00  0.00           C  
ATOM    502  OD1 ASP A  32     -15.032  50.620   6.054  1.00  0.00           O  
ATOM    503  OD2 ASP A  32     -16.986  50.535   7.047  1.00  0.00           O  
ATOM    504  H   ASP A  32     -13.125  51.306   7.927  1.00  0.00           H  
ATOM    505  HA  ASP A  32     -15.467  51.197   9.659  1.00  0.00           H  
ATOM    506  HB2 ASP A  32     -14.278  49.060   7.871  1.00  0.00           H  
ATOM    507  HB3 ASP A  32     -15.843  48.990   8.673  1.00  0.00           H  
ATOM    508  N   ARG A  33     -12.631  50.080  10.531  1.00  0.00           N  
ATOM    509  CA  ARG A  33     -11.828  49.364  11.520  1.00  0.00           C  
ATOM    510  C   ARG A  33     -11.855  47.862  11.253  1.00  0.00           C  
ATOM    511  O   ARG A  33     -11.816  47.047  12.175  1.00  0.00           O  
ATOM    512  CB  ARG A  33     -12.288  49.665  12.951  1.00  0.00           C  
ATOM    513  CG  ARG A  33     -11.993  51.090  13.386  1.00  0.00           C  
ATOM    514  CD  ARG A  33     -12.025  51.213  14.896  1.00  0.00           C  
ATOM    515  NE  ARG A  33     -13.337  50.876  15.441  1.00  0.00           N  
ATOM    516  CZ  ARG A  33     -13.528  50.241  16.596  1.00  0.00           C  
ATOM    517  NH1 ARG A  33     -12.498  49.881  17.352  1.00  0.00           N  
ATOM    518  NH2 ARG A  33     -14.760  49.968  16.995  1.00  0.00           N  
ATOM    519  H   ARG A  33     -12.186  50.713   9.933  1.00  0.00           H  
ATOM    520  HA  ARG A  33     -10.811  49.709  11.416  1.00  0.00           H  
ATOM    521  HB2 ARG A  33     -13.353  49.502  13.023  1.00  0.00           H  
ATOM    522  HB3 ARG A  33     -11.782  48.995  13.628  1.00  0.00           H  
ATOM    523  HG2 ARG A  33     -11.012  51.369  13.029  1.00  0.00           H  
ATOM    524  HG3 ARG A  33     -12.736  51.750  12.962  1.00  0.00           H  
ATOM    525  HD2 ARG A  33     -11.288  50.539  15.307  1.00  0.00           H  
ATOM    526  HD3 ARG A  33     -11.778  52.228  15.166  1.00  0.00           H  
ATOM    527  HE  ARG A  33     -14.129  51.143  14.906  1.00  0.00           H  
ATOM    528 HH11 ARG A  33     -11.553  50.089  17.062  1.00  0.00           H  
ATOM    529 HH12 ARG A  33     -12.656  49.397  18.224  1.00  0.00           H  
ATOM    530 HH21 ARG A  33     -15.546  50.237  16.432  1.00  0.00           H  
ATOM    531 HH22 ARG A  33     -14.917  49.498  17.867  1.00  0.00           H  
ATOM    532  N   LEU A  34     -11.904  47.508   9.977  1.00  0.00           N  
ATOM    533  CA  LEU A  34     -11.887  46.111   9.571  1.00  0.00           C  
ATOM    534  C   LEU A  34     -10.529  45.768   8.987  1.00  0.00           C  
ATOM    535  O   LEU A  34      -9.707  46.654   8.766  1.00  0.00           O  
ATOM    536  CB  LEU A  34     -12.983  45.828   8.539  1.00  0.00           C  
ATOM    537  CG  LEU A  34     -14.415  45.970   9.051  1.00  0.00           C  
ATOM    538  CD1 LEU A  34     -15.407  45.784   7.914  1.00  0.00           C  
ATOM    539  CD2 LEU A  34     -14.684  44.964  10.157  1.00  0.00           C  
ATOM    540  H   LEU A  34     -11.929  48.207   9.288  1.00  0.00           H  
ATOM    541  HA  LEU A  34     -12.056  45.505  10.450  1.00  0.00           H  
ATOM    542  HB2 LEU A  34     -12.851  46.511   7.713  1.00  0.00           H  
ATOM    543  HB3 LEU A  34     -12.854  44.820   8.174  1.00  0.00           H  
ATOM    544  HG  LEU A  34     -14.548  46.959   9.458  1.00  0.00           H  
ATOM    545 HD11 LEU A  34     -15.220  46.520   7.146  1.00  0.00           H  
ATOM    546 HD12 LEU A  34     -16.412  45.907   8.289  1.00  0.00           H  
ATOM    547 HD13 LEU A  34     -15.298  44.793   7.498  1.00  0.00           H  
ATOM    548 HD21 LEU A  34     -14.600  43.963   9.759  1.00  0.00           H  
ATOM    549 HD22 LEU A  34     -15.679  45.114  10.548  1.00  0.00           H  
ATOM    550 HD23 LEU A  34     -13.961  45.097  10.947  1.00  0.00           H  
ATOM    551  N   ALA A  35     -10.295  44.495   8.741  1.00  0.00           N  
ATOM    552  CA  ALA A  35      -9.032  44.054   8.176  1.00  0.00           C  
ATOM    553  C   ALA A  35      -9.198  42.739   7.425  1.00  0.00           C  
ATOM    554  O   ALA A  35      -9.480  41.700   8.024  1.00  0.00           O  
ATOM    555  CB  ALA A  35      -7.986  43.923   9.271  1.00  0.00           C  
ATOM    556  H   ALA A  35     -10.985  43.828   8.954  1.00  0.00           H  
ATOM    557  HA  ALA A  35      -8.697  44.812   7.482  1.00  0.00           H  
ATOM    558  HB1 ALA A  35      -7.901  44.858   9.804  1.00  0.00           H  
ATOM    559  HB2 ALA A  35      -7.034  43.674   8.831  1.00  0.00           H  
ATOM    560  HB3 ALA A  35      -8.279  43.144   9.956  1.00  0.00           H  
ATOM    561  N   PHE A  36      -9.043  42.797   6.108  1.00  0.00           N  
ATOM    562  CA  PHE A  36      -9.132  41.607   5.272  1.00  0.00           C  
ATOM    563  C   PHE A  36      -7.817  40.835   5.323  1.00  0.00           C  
ATOM    564  O   PHE A  36      -6.765  41.369   4.976  1.00  0.00           O  
ATOM    565  CB  PHE A  36      -9.464  41.984   3.825  1.00  0.00           C  
ATOM    566  CG  PHE A  36     -10.792  42.666   3.663  1.00  0.00           C  
ATOM    567  CD1 PHE A  36     -11.966  42.029   4.040  1.00  0.00           C  
ATOM    568  CD2 PHE A  36     -10.868  43.941   3.134  1.00  0.00           C  
ATOM    569  CE1 PHE A  36     -13.188  42.655   3.892  1.00  0.00           C  
ATOM    570  CE2 PHE A  36     -12.088  44.571   2.980  1.00  0.00           C  
ATOM    571  CZ  PHE A  36     -13.249  43.926   3.359  1.00  0.00           C  
ATOM    572  H   PHE A  36      -8.854  43.665   5.687  1.00  0.00           H  
ATOM    573  HA  PHE A  36      -9.921  40.982   5.665  1.00  0.00           H  
ATOM    574  HB2 PHE A  36      -8.705  42.655   3.452  1.00  0.00           H  
ATOM    575  HB3 PHE A  36      -9.474  41.088   3.220  1.00  0.00           H  
ATOM    576  HD1 PHE A  36     -11.917  41.036   4.458  1.00  0.00           H  
ATOM    577  HD2 PHE A  36      -9.960  44.443   2.837  1.00  0.00           H  
ATOM    578  HE1 PHE A  36     -14.093  42.148   4.188  1.00  0.00           H  
ATOM    579  HE2 PHE A  36     -12.133  45.567   2.567  1.00  0.00           H  
ATOM    580  HZ  PHE A  36     -14.204  44.416   3.240  1.00  0.00           H  
ATOM    581  N   PRO A  37      -7.855  39.577   5.765  1.00  0.00           N  
ATOM    582  CA  PRO A  37      -6.649  38.777   5.943  1.00  0.00           C  
ATOM    583  C   PRO A  37      -6.127  38.183   4.640  1.00  0.00           C  
ATOM    584  O   PRO A  37      -6.885  37.616   3.844  1.00  0.00           O  
ATOM    585  CB  PRO A  37      -7.105  37.674   6.895  1.00  0.00           C  
ATOM    586  CG  PRO A  37      -8.559  37.501   6.618  1.00  0.00           C  
ATOM    587  CD  PRO A  37      -9.074  38.834   6.129  1.00  0.00           C  
ATOM    588  HA  PRO A  37      -5.863  39.351   6.409  1.00  0.00           H  
ATOM    589  HB2 PRO A  37      -6.551  36.770   6.688  1.00  0.00           H  
ATOM    590  HB3 PRO A  37      -6.931  37.984   7.915  1.00  0.00           H  
ATOM    591  HG2 PRO A  37      -8.697  36.748   5.856  1.00  0.00           H  
ATOM    592  HG3 PRO A  37      -9.069  37.212   7.524  1.00  0.00           H  
ATOM    593  HD3 PRO A  37      -9.711  38.697   5.267  1.00  0.00           H  
ATOM    594  HD2 PRO A  37      -9.611  39.342   6.916  1.00  0.00           H  
ATOM    595  N   VAL A  38      -4.830  38.321   4.421  1.00  0.00           N  
ATOM    596  CA  VAL A  38      -4.183  37.712   3.276  1.00  0.00           C  
ATOM    597  C   VAL A  38      -3.630  36.350   3.678  1.00  0.00           C  
ATOM    598  O   VAL A  38      -2.597  36.258   4.340  1.00  0.00           O  
ATOM    599  CB  VAL A  38      -3.040  38.588   2.715  1.00  0.00           C  
ATOM    600  CG1 VAL A  38      -2.446  37.960   1.455  1.00  0.00           C  
ATOM    601  CG2 VAL A  38      -3.537  40.004   2.446  1.00  0.00           C  
ATOM    602  H   VAL A  38      -4.286  38.841   5.060  1.00  0.00           H  
ATOM    603  HA  VAL A  38      -4.928  37.580   2.504  1.00  0.00           H  
ATOM    604  HB  VAL A  38      -2.259  38.641   3.460  1.00  0.00           H  
ATOM    605 HG11 VAL A  38      -2.062  36.977   1.691  1.00  0.00           H  
ATOM    606 HG12 VAL A  38      -1.644  38.578   1.085  1.00  0.00           H  
ATOM    607 HG13 VAL A  38      -3.213  37.871   0.700  1.00  0.00           H  
ATOM    608 HG21 VAL A  38      -4.360  39.972   1.748  1.00  0.00           H  
ATOM    609 HG22 VAL A  38      -2.737  40.599   2.031  1.00  0.00           H  
ATOM    610 HG23 VAL A  38      -3.872  40.449   3.373  1.00  0.00           H  
ATOM    611  N   ARG A  39      -4.325  35.297   3.285  1.00  0.00           N  
ATOM    612  CA  ARG A  39      -3.951  33.947   3.671  1.00  0.00           C  
ATOM    613  C   ARG A  39      -2.894  33.415   2.716  1.00  0.00           C  
ATOM    614  O   ARG A  39      -3.185  32.602   1.839  1.00  0.00           O  
ATOM    615  CB  ARG A  39      -5.185  33.043   3.681  1.00  0.00           C  
ATOM    616  CG  ARG A  39      -4.946  31.661   4.266  1.00  0.00           C  
ATOM    617  CD  ARG A  39      -6.213  30.821   4.210  1.00  0.00           C  
ATOM    618  NE  ARG A  39      -6.022  29.489   4.779  1.00  0.00           N  
ATOM    619  CZ  ARG A  39      -6.655  28.404   4.344  1.00  0.00           C  
ATOM    620  NH1 ARG A  39      -7.505  28.496   3.326  1.00  0.00           N  
ATOM    621  NH2 ARG A  39      -6.435  27.231   4.924  1.00  0.00           N  
ATOM    622  H   ARG A  39      -5.103  35.427   2.696  1.00  0.00           H  
ATOM    623  HA  ARG A  39      -3.534  33.986   4.667  1.00  0.00           H  
ATOM    624  HB2 ARG A  39      -5.960  33.525   4.262  1.00  0.00           H  
ATOM    625  HB3 ARG A  39      -5.535  32.924   2.666  1.00  0.00           H  
ATOM    626  HG2 ARG A  39      -4.171  31.167   3.698  1.00  0.00           H  
ATOM    627  HG3 ARG A  39      -4.638  31.761   5.295  1.00  0.00           H  
ATOM    628  HD2 ARG A  39      -6.990  31.327   4.765  1.00  0.00           H  
ATOM    629  HD3 ARG A  39      -6.518  30.721   3.178  1.00  0.00           H  
ATOM    630  HE  ARG A  39      -5.394  29.405   5.534  1.00  0.00           H  
ATOM    631 HH11 ARG A  39      -7.673  29.380   2.890  1.00  0.00           H  
ATOM    632 HH12 ARG A  39      -7.974  27.672   2.979  1.00  0.00           H  
ATOM    633 HH21 ARG A  39      -5.784  27.161   5.692  1.00  0.00           H  
ATOM    634 HH22 ARG A  39      -6.925  26.409   4.610  1.00  0.00           H  
ATOM    635  N   ASP A  40      -1.678  33.935   2.883  1.00  0.00           N  
ATOM    636  CA  ASP A  40      -0.526  33.573   2.055  1.00  0.00           C  
ATOM    637  C   ASP A  40      -0.869  33.637   0.569  1.00  0.00           C  
ATOM    638  O   ASP A  40      -1.134  32.619  -0.070  1.00  0.00           O  
ATOM    639  CB  ASP A  40       0.017  32.188   2.429  1.00  0.00           C  
ATOM    640  CG  ASP A  40       1.296  31.840   1.685  1.00  0.00           C  
ATOM    641  OD1 ASP A  40       2.136  32.743   1.473  1.00  0.00           O  
ATOM    642  OD2 ASP A  40       1.479  30.657   1.329  1.00  0.00           O  
ATOM    643  H   ASP A  40      -1.553  34.602   3.592  1.00  0.00           H  
ATOM    644  HA  ASP A  40       0.245  34.305   2.247  1.00  0.00           H  
ATOM    645  HB2 ASP A  40       0.223  32.167   3.489  1.00  0.00           H  
ATOM    646  HB3 ASP A  40      -0.730  31.441   2.199  1.00  0.00           H  
ATOM    647  N   GLY A  41      -0.909  34.851   0.041  1.00  0.00           N  
ATOM    648  CA  GLY A  41      -1.205  35.043  -1.361  1.00  0.00           C  
ATOM    649  C   GLY A  41      -2.667  35.337  -1.618  1.00  0.00           C  
ATOM    650  O   GLY A  41      -2.992  36.233  -2.395  1.00  0.00           O  
ATOM    651  H   GLY A  41      -0.731  35.626   0.611  1.00  0.00           H  
ATOM    652  HA2 GLY A  41      -0.612  35.865  -1.733  1.00  0.00           H  
ATOM    653  HA3 GLY A  41      -0.931  34.146  -1.900  1.00  0.00           H  
ATOM    654  N   VAL A  42      -3.550  34.599  -0.953  1.00  0.00           N  
ATOM    655  CA  VAL A  42      -4.981  34.728  -1.190  1.00  0.00           C  
ATOM    656  C   VAL A  42      -5.634  35.631  -0.143  1.00  0.00           C  
ATOM    657  O   VAL A  42      -5.754  35.257   1.024  1.00  0.00           O  
ATOM    658  CB  VAL A  42      -5.677  33.350  -1.172  1.00  0.00           C  
ATOM    659  CG1 VAL A  42      -7.165  33.485  -1.466  1.00  0.00           C  
ATOM    660  CG2 VAL A  42      -5.019  32.405  -2.157  1.00  0.00           C  
ATOM    661  H   VAL A  42      -3.233  33.959  -0.276  1.00  0.00           H  
ATOM    662  HA  VAL A  42      -5.118  35.168  -2.167  1.00  0.00           H  
ATOM    663  HB  VAL A  42      -5.566  32.930  -0.183  1.00  0.00           H  
ATOM    664 HG11 VAL A  42      -7.301  33.926  -2.442  1.00  0.00           H  
ATOM    665 HG12 VAL A  42      -7.620  34.118  -0.718  1.00  0.00           H  
ATOM    666 HG13 VAL A  42      -7.629  32.510  -1.444  1.00  0.00           H  
ATOM    667 HG21 VAL A  42      -5.538  31.456  -2.143  1.00  0.00           H  
ATOM    668 HG22 VAL A  42      -3.988  32.258  -1.876  1.00  0.00           H  
ATOM    669 HG23 VAL A  42      -5.066  32.829  -3.149  1.00  0.00           H  
ATOM    670  N   PRO A  43      -6.051  36.837  -0.546  1.00  0.00           N  
ATOM    671  CA  PRO A  43      -6.709  37.791   0.338  1.00  0.00           C  
ATOM    672  C   PRO A  43      -8.203  37.511   0.469  1.00  0.00           C  
ATOM    673  O   PRO A  43      -8.916  37.397  -0.530  1.00  0.00           O  
ATOM    674  CB  PRO A  43      -6.476  39.148  -0.349  1.00  0.00           C  
ATOM    675  CG  PRO A  43      -5.774  38.855  -1.643  1.00  0.00           C  
ATOM    676  CD  PRO A  43      -5.925  37.379  -1.898  1.00  0.00           C  
ATOM    677  HA  PRO A  43      -6.256  37.800   1.319  1.00  0.00           H  
ATOM    678  HB2 PRO A  43      -7.426  39.631  -0.522  1.00  0.00           H  
ATOM    679  HB3 PRO A  43      -5.868  39.771   0.291  1.00  0.00           H  
ATOM    680  HG2 PRO A  43      -6.232  39.420  -2.442  1.00  0.00           H  
ATOM    681  HG3 PRO A  43      -4.729  39.115  -1.555  1.00  0.00           H  
ATOM    682  HD3 PRO A  43      -6.816  37.186  -2.477  1.00  0.00           H  
ATOM    683  HD2 PRO A  43      -5.053  36.984  -2.395  1.00  0.00           H  
ATOM    684  N   ILE A  44      -8.669  37.401   1.701  1.00  0.00           N  
ATOM    685  CA  ILE A  44     -10.078  37.149   1.963  1.00  0.00           C  
ATOM    686  C   ILE A  44     -10.837  38.468   2.050  1.00  0.00           C  
ATOM    687  O   ILE A  44     -10.821  39.139   3.081  1.00  0.00           O  
ATOM    688  CB  ILE A  44     -10.281  36.349   3.271  1.00  0.00           C  
ATOM    689  CG1 ILE A  44      -9.467  35.049   3.238  1.00  0.00           C  
ATOM    690  CG2 ILE A  44     -11.760  36.048   3.502  1.00  0.00           C  
ATOM    691  CD1 ILE A  44      -9.845  34.111   2.111  1.00  0.00           C  
ATOM    692  H   ILE A  44      -8.050  37.497   2.458  1.00  0.00           H  
ATOM    693  HA  ILE A  44     -10.472  36.568   1.141  1.00  0.00           H  
ATOM    694  HB  ILE A  44      -9.936  36.958   4.092  1.00  0.00           H  
ATOM    695 HG12 ILE A  44      -8.421  35.293   3.129  1.00  0.00           H  
ATOM    696 HG13 ILE A  44      -9.609  34.521   4.167  1.00  0.00           H  
ATOM    697 HG21 ILE A  44     -12.309  36.976   3.572  1.00  0.00           H  
ATOM    698 HG22 ILE A  44     -11.875  35.493   4.422  1.00  0.00           H  
ATOM    699 HG23 ILE A  44     -12.142  35.465   2.677  1.00  0.00           H  
ATOM    700 HD11 ILE A  44     -10.882  33.829   2.211  1.00  0.00           H  
ATOM    701 HD12 ILE A  44      -9.224  33.229   2.154  1.00  0.00           H  
ATOM    702 HD13 ILE A  44      -9.698  34.608   1.166  1.00  0.00           H  
ATOM    703  N   MET A  45     -11.494  38.836   0.956  1.00  0.00           N  
ATOM    704  CA  MET A  45     -12.219  40.102   0.872  1.00  0.00           C  
ATOM    705  C   MET A  45     -13.647  39.956   1.400  1.00  0.00           C  
ATOM    706  O   MET A  45     -14.528  40.748   1.068  1.00  0.00           O  
ATOM    707  CB  MET A  45     -12.240  40.600  -0.579  1.00  0.00           C  
ATOM    708  CG  MET A  45     -10.860  40.895  -1.147  1.00  0.00           C  
ATOM    709  SD  MET A  45     -10.054  42.295  -0.341  1.00  0.00           S  
ATOM    710  CE  MET A  45     -11.176  43.629  -0.763  1.00  0.00           C  
ATOM    711  H   MET A  45     -11.492  38.237   0.173  1.00  0.00           H  
ATOM    712  HA  MET A  45     -11.693  40.822   1.483  1.00  0.00           H  
ATOM    713  HB2 MET A  45     -12.708  39.851  -1.200  1.00  0.00           H  
ATOM    714  HB3 MET A  45     -12.824  41.508  -0.625  1.00  0.00           H  
ATOM    715  HG2 MET A  45     -10.238  40.022  -1.014  1.00  0.00           H  
ATOM    716  HG3 MET A  45     -10.955  41.110  -2.201  1.00  0.00           H  
ATOM    717  HE1 MET A  45     -12.155  43.417  -0.356  1.00  0.00           H  
ATOM    718  HE2 MET A  45     -11.241  43.717  -1.836  1.00  0.00           H  
ATOM    719  HE3 MET A  45     -10.804  44.556  -0.348  1.00  0.00           H  
ATOM    720  N   LEU A  46     -13.864  38.949   2.233  1.00  0.00           N  
ATOM    721  CA  LEU A  46     -15.172  38.696   2.816  1.00  0.00           C  
ATOM    722  C   LEU A  46     -15.205  39.206   4.251  1.00  0.00           C  
ATOM    723  O   LEU A  46     -14.475  38.706   5.105  1.00  0.00           O  
ATOM    724  CB  LEU A  46     -15.472  37.197   2.774  1.00  0.00           C  
ATOM    725  CG  LEU A  46     -15.420  36.571   1.382  1.00  0.00           C  
ATOM    726  CD1 LEU A  46     -15.554  35.064   1.477  1.00  0.00           C  
ATOM    727  CD2 LEU A  46     -16.515  37.148   0.496  1.00  0.00           C  
ATOM    728  H   LEU A  46     -13.116  38.364   2.472  1.00  0.00           H  
ATOM    729  HA  LEU A  46     -15.912  39.227   2.236  1.00  0.00           H  
ATOM    730  HB2 LEU A  46     -14.750  36.690   3.400  1.00  0.00           H  
ATOM    731  HB3 LEU A  46     -16.457  37.032   3.183  1.00  0.00           H  
ATOM    732  HG  LEU A  46     -14.466  36.795   0.926  1.00  0.00           H  
ATOM    733 HD11 LEU A  46     -15.526  34.636   0.488  1.00  0.00           H  
ATOM    734 HD12 LEU A  46     -16.494  34.817   1.949  1.00  0.00           H  
ATOM    735 HD13 LEU A  46     -14.741  34.667   2.066  1.00  0.00           H  
ATOM    736 HD21 LEU A  46     -16.384  38.217   0.413  1.00  0.00           H  
ATOM    737 HD22 LEU A  46     -17.478  36.937   0.935  1.00  0.00           H  
ATOM    738 HD23 LEU A  46     -16.460  36.700  -0.485  1.00  0.00           H  
ATOM    739  N   GLU A  47     -16.060  40.187   4.512  1.00  0.00           N  
ATOM    740  CA  GLU A  47     -16.084  40.876   5.801  1.00  0.00           C  
ATOM    741  C   GLU A  47     -16.401  39.922   6.957  1.00  0.00           C  
ATOM    742  O   GLU A  47     -15.801  40.007   8.027  1.00  0.00           O  
ATOM    743  CB  GLU A  47     -17.088  42.045   5.775  1.00  0.00           C  
ATOM    744  CG  GLU A  47     -18.563  41.643   5.802  1.00  0.00           C  
ATOM    745  CD  GLU A  47     -18.999  40.862   4.579  1.00  0.00           C  
ATOM    746  OE1 GLU A  47     -19.385  41.493   3.577  1.00  0.00           O  
ATOM    747  OE2 GLU A  47     -18.968  39.612   4.621  1.00  0.00           O  
ATOM    748  H   GLU A  47     -16.697  40.460   3.816  1.00  0.00           H  
ATOM    749  HA  GLU A  47     -15.097  41.282   5.963  1.00  0.00           H  
ATOM    750  HB2 GLU A  47     -16.902  42.677   6.630  1.00  0.00           H  
ATOM    751  HB3 GLU A  47     -16.916  42.620   4.876  1.00  0.00           H  
ATOM    752  HG2 GLU A  47     -18.741  41.036   6.677  1.00  0.00           H  
ATOM    753  HG3 GLU A  47     -19.161  42.542   5.866  1.00  0.00           H  
ATOM    754  N   ALA A  48     -17.333  39.008   6.728  1.00  0.00           N  
ATOM    755  CA  ALA A  48     -17.763  38.072   7.758  1.00  0.00           C  
ATOM    756  C   ALA A  48     -16.652  37.100   8.143  1.00  0.00           C  
ATOM    757  O   ALA A  48     -16.606  36.610   9.274  1.00  0.00           O  
ATOM    758  CB  ALA A  48     -18.990  37.309   7.291  1.00  0.00           C  
ATOM    759  H   ALA A  48     -17.761  38.977   5.843  1.00  0.00           H  
ATOM    760  HA  ALA A  48     -18.040  38.647   8.629  1.00  0.00           H  
ATOM    761  HB1 ALA A  48     -19.359  36.692   8.097  1.00  0.00           H  
ATOM    762  HB2 ALA A  48     -18.728  36.684   6.451  1.00  0.00           H  
ATOM    763  HB3 ALA A  48     -19.756  38.008   6.994  1.00  0.00           H  
ATOM    764  N   GLU A  49     -15.749  36.835   7.211  1.00  0.00           N  
ATOM    765  CA  GLU A  49     -14.695  35.860   7.439  1.00  0.00           C  
ATOM    766  C   GLU A  49     -13.353  36.553   7.642  1.00  0.00           C  
ATOM    767  O   GLU A  49     -12.306  35.908   7.701  1.00  0.00           O  
ATOM    768  CB  GLU A  49     -14.631  34.877   6.273  1.00  0.00           C  
ATOM    769  CG  GLU A  49     -15.980  34.260   5.951  1.00  0.00           C  
ATOM    770  CD  GLU A  49     -15.860  32.912   5.282  1.00  0.00           C  
ATOM    771  OE1 GLU A  49     -15.643  32.862   4.055  1.00  0.00           O  
ATOM    772  OE2 GLU A  49     -15.996  31.890   5.987  1.00  0.00           O  
ATOM    773  H   GLU A  49     -15.786  37.310   6.354  1.00  0.00           H  
ATOM    774  HA  GLU A  49     -14.940  35.317   8.339  1.00  0.00           H  
ATOM    775  HB2 GLU A  49     -14.275  35.397   5.397  1.00  0.00           H  
ATOM    776  HB3 GLU A  49     -13.943  34.083   6.519  1.00  0.00           H  
ATOM    777  HG2 GLU A  49     -16.535  34.139   6.871  1.00  0.00           H  
ATOM    778  HG3 GLU A  49     -16.517  34.927   5.293  1.00  0.00           H  
ATOM    779  N   ALA A  50     -13.401  37.870   7.771  1.00  0.00           N  
ATOM    780  CA  ALA A  50     -12.209  38.660   8.019  1.00  0.00           C  
ATOM    781  C   ALA A  50     -12.066  38.935   9.509  1.00  0.00           C  
ATOM    782  O   ALA A  50     -12.781  38.350  10.326  1.00  0.00           O  
ATOM    783  CB  ALA A  50     -12.269  39.968   7.239  1.00  0.00           C  
ATOM    784  H   ALA A  50     -14.266  38.323   7.706  1.00  0.00           H  
ATOM    785  HA  ALA A  50     -11.352  38.098   7.678  1.00  0.00           H  
ATOM    786  HB1 ALA A  50     -12.341  39.756   6.182  1.00  0.00           H  
ATOM    787  HB2 ALA A  50     -11.375  40.543   7.433  1.00  0.00           H  
ATOM    788  HB3 ALA A  50     -13.135  40.534   7.553  1.00  0.00           H  
ATOM    789  N   ARG A  51     -11.145  39.819   9.860  1.00  0.00           N  
ATOM    790  CA  ARG A  51     -10.958  40.207  11.249  1.00  0.00           C  
ATOM    791  C   ARG A  51     -11.257  41.691  11.411  1.00  0.00           C  
ATOM    792  O   ARG A  51     -11.162  42.460  10.456  1.00  0.00           O  
ATOM    793  CB  ARG A  51      -9.529  39.908  11.728  1.00  0.00           C  
ATOM    794  CG  ARG A  51      -8.461  40.737  11.029  1.00  0.00           C  
ATOM    795  CD  ARG A  51      -7.087  40.538  11.655  1.00  0.00           C  
ATOM    796  NE  ARG A  51      -7.049  40.963  13.057  1.00  0.00           N  
ATOM    797  CZ  ARG A  51      -5.986  41.516  13.647  1.00  0.00           C  
ATOM    798  NH1 ARG A  51      -4.878  41.757  12.952  1.00  0.00           N  
ATOM    799  NH2 ARG A  51      -6.034  41.836  14.934  1.00  0.00           N  
ATOM    800  H   ARG A  51     -10.592  40.238   9.167  1.00  0.00           H  
ATOM    801  HA  ARG A  51     -11.657  39.641  11.847  1.00  0.00           H  
ATOM    802  HB2 ARG A  51      -9.470  40.105  12.787  1.00  0.00           H  
ATOM    803  HB3 ARG A  51      -9.314  38.865  11.553  1.00  0.00           H  
ATOM    804  HG2 ARG A  51      -8.416  40.446   9.989  1.00  0.00           H  
ATOM    805  HG3 ARG A  51      -8.730  41.780  11.101  1.00  0.00           H  
ATOM    806  HD2 ARG A  51      -6.829  39.489  11.601  1.00  0.00           H  
ATOM    807  HD3 ARG A  51      -6.366  41.113  11.094  1.00  0.00           H  
ATOM    808  HE  ARG A  51      -7.860  40.819  13.595  1.00  0.00           H  
ATOM    809 HH11 ARG A  51      -4.828  41.533  11.975  1.00  0.00           H  
ATOM    810 HH12 ARG A  51      -4.077  42.164  13.402  1.00  0.00           H  
ATOM    811 HH21 ARG A  51      -6.875  41.660  15.475  1.00  0.00           H  
ATOM    812 HH22 ARG A  51      -5.235  42.265  15.379  1.00  0.00           H  
ATOM    813  N   SER A  52     -11.638  42.083  12.606  1.00  0.00           N  
ATOM    814  CA  SER A  52     -11.866  43.474  12.905  1.00  0.00           C  
ATOM    815  C   SER A  52     -10.859  43.944  13.938  1.00  0.00           C  
ATOM    816  O   SER A  52     -10.081  43.150  14.463  1.00  0.00           O  
ATOM    817  CB  SER A  52     -13.290  43.664  13.422  1.00  0.00           C  
ATOM    818  OG  SER A  52     -13.575  45.022  13.720  1.00  0.00           O  
ATOM    819  H   SER A  52     -11.781  41.418  13.312  1.00  0.00           H  
ATOM    820  HA  SER A  52     -11.741  44.041  11.999  1.00  0.00           H  
ATOM    821  HB2 SER A  52     -13.977  43.325  12.672  1.00  0.00           H  
ATOM    822  HB3 SER A  52     -13.417  43.079  14.315  1.00  0.00           H  
ATOM    823  HG  SER A  52     -13.728  45.506  12.900  1.00  0.00           H  
ATOM    824  N   LEU A  53     -10.874  45.233  14.210  1.00  0.00           N  
ATOM    825  CA  LEU A  53     -10.055  45.806  15.268  1.00  0.00           C  
ATOM    826  C   LEU A  53     -10.891  45.926  16.529  1.00  0.00           C  
ATOM    827  O   LEU A  53     -10.395  46.264  17.602  1.00  0.00           O  
ATOM    828  CB  LEU A  53      -9.509  47.173  14.853  1.00  0.00           C  
ATOM    829  CG  LEU A  53      -8.607  47.166  13.617  1.00  0.00           C  
ATOM    830  CD1 LEU A  53      -8.163  48.579  13.273  1.00  0.00           C  
ATOM    831  CD2 LEU A  53      -7.397  46.275  13.849  1.00  0.00           C  
ATOM    832  H   LEU A  53     -11.470  45.818  13.689  1.00  0.00           H  
ATOM    833  HA  LEU A  53      -9.231  45.133  15.458  1.00  0.00           H  
ATOM    834  HB2 LEU A  53     -10.347  47.827  14.660  1.00  0.00           H  
ATOM    835  HB3 LEU A  53      -8.943  47.575  15.681  1.00  0.00           H  
ATOM    836  HG  LEU A  53      -9.160  46.774  12.777  1.00  0.00           H  
ATOM    837 HD11 LEU A  53      -9.032  49.194  13.080  1.00  0.00           H  
ATOM    838 HD12 LEU A  53      -7.535  48.557  12.396  1.00  0.00           H  
ATOM    839 HD13 LEU A  53      -7.610  48.995  14.102  1.00  0.00           H  
ATOM    840 HD21 LEU A  53      -7.726  45.268  14.057  1.00  0.00           H  
ATOM    841 HD22 LEU A  53      -6.831  46.649  14.688  1.00  0.00           H  
ATOM    842 HD23 LEU A  53      -6.777  46.273  12.967  1.00  0.00           H  
ATOM    843  N   ASP A  54     -12.178  45.650  16.367  1.00  0.00           N  
ATOM    844  CA  ASP A  54     -13.128  45.652  17.472  1.00  0.00           C  
ATOM    845  C   ASP A  54     -13.454  44.220  17.887  1.00  0.00           C  
ATOM    846  O   ASP A  54     -13.715  43.936  19.058  1.00  0.00           O  
ATOM    847  CB  ASP A  54     -14.408  46.377  17.049  1.00  0.00           C  
ATOM    848  CG  ASP A  54     -15.513  46.289  18.084  1.00  0.00           C  
ATOM    849  OD1 ASP A  54     -15.524  47.115  19.022  1.00  0.00           O  
ATOM    850  OD2 ASP A  54     -16.394  45.413  17.948  1.00  0.00           O  
ATOM    851  H   ASP A  54     -12.502  45.439  15.466  1.00  0.00           H  
ATOM    852  HA  ASP A  54     -12.680  46.173  18.304  1.00  0.00           H  
ATOM    853  HB2 ASP A  54     -14.183  47.418  16.881  1.00  0.00           H  
ATOM    854  HB3 ASP A  54     -14.769  45.940  16.128  1.00  0.00           H  
ATOM    855  N   ALA A  55     -13.411  43.321  16.914  1.00  0.00           N  
ATOM    856  CA  ALA A  55     -13.745  41.927  17.135  1.00  0.00           C  
ATOM    857  C   ALA A  55     -12.633  41.031  16.619  1.00  0.00           C  
ATOM    858  O   ALA A  55     -12.460  40.866  15.410  1.00  0.00           O  
ATOM    859  CB  ALA A  55     -15.068  41.585  16.464  1.00  0.00           C  
ATOM    860  H   ALA A  55     -13.122  43.600  16.025  1.00  0.00           H  
ATOM    861  HA  ALA A  55     -13.856  41.773  18.198  1.00  0.00           H  
ATOM    862  HB1 ALA A  55     -15.841  42.242  16.833  1.00  0.00           H  
ATOM    863  HB2 ALA A  55     -15.329  40.562  16.689  1.00  0.00           H  
ATOM    864  HB3 ALA A  55     -14.973  41.706  15.396  1.00  0.00           H  
ATOM    865  N   GLU A  56     -11.858  40.492  17.544  1.00  0.00           N  
ATOM    866  CA  GLU A  56     -10.780  39.576  17.203  1.00  0.00           C  
ATOM    867  C   GLU A  56     -11.326  38.168  16.993  1.00  0.00           C  
ATOM    868  O   GLU A  56     -12.489  37.898  17.290  1.00  0.00           O  
ATOM    869  CB  GLU A  56      -9.728  39.558  18.310  1.00  0.00           C  
ATOM    870  CG  GLU A  56      -9.153  40.925  18.631  1.00  0.00           C  
ATOM    871  CD  GLU A  56      -8.567  41.615  17.416  1.00  0.00           C  
ATOM    872  OE1 GLU A  56      -7.848  40.951  16.640  1.00  0.00           O  
ATOM    873  OE2 GLU A  56      -8.821  42.819  17.238  1.00  0.00           O  
ATOM    874  H   GLU A  56     -12.013  40.717  18.482  1.00  0.00           H  
ATOM    875  HA  GLU A  56     -10.326  39.921  16.289  1.00  0.00           H  
ATOM    876  HB2 GLU A  56     -10.176  39.161  19.210  1.00  0.00           H  
ATOM    877  HB3 GLU A  56      -8.918  38.913  18.006  1.00  0.00           H  
ATOM    878  HG2 GLU A  56      -9.938  41.549  19.034  1.00  0.00           H  
ATOM    879  HG3 GLU A  56      -8.374  40.808  19.369  1.00  0.00           H  
ATOM    880  N   ALA A  57     -10.480  37.278  16.495  1.00  0.00           N  
ATOM    881  CA  ALA A  57     -10.872  35.895  16.264  1.00  0.00           C  
ATOM    882  C   ALA A  57     -10.420  34.999  17.411  1.00  0.00           C  
ATOM    883  O   ALA A  57      -9.221  34.791  17.616  1.00  0.00           O  
ATOM    884  CB  ALA A  57     -10.302  35.398  14.946  1.00  0.00           C  
ATOM    885  H   ALA A  57      -9.567  37.558  16.279  1.00  0.00           H  
ATOM    886  HA  ALA A  57     -11.950  35.860  16.198  1.00  0.00           H  
ATOM    887  HB1 ALA A  57      -9.223  35.440  14.981  1.00  0.00           H  
ATOM    888  HB2 ALA A  57     -10.660  36.021  14.140  1.00  0.00           H  
ATOM    889  HB3 ALA A  57     -10.616  34.378  14.780  1.00  0.00           H  
ATOM    890  N   PRO A  58     -11.370  34.483  18.198  1.00  0.00           N  
ATOM    891  CA  PRO A  58     -11.076  33.568  19.299  1.00  0.00           C  
ATOM    892  C   PRO A  58     -10.750  32.166  18.792  1.00  0.00           C  
ATOM    893  O   PRO A  58     -11.595  31.498  18.195  1.00  0.00           O  
ATOM    894  CB  PRO A  58     -12.370  33.553  20.129  1.00  0.00           C  
ATOM    895  CG  PRO A  58     -13.262  34.590  19.520  1.00  0.00           C  
ATOM    896  CD  PRO A  58     -12.806  34.757  18.101  1.00  0.00           C  
ATOM    897  HA  PRO A  58     -10.259  33.927  19.905  1.00  0.00           H  
ATOM    898  HB2 PRO A  58     -12.819  32.572  20.078  1.00  0.00           H  
ATOM    899  HB3 PRO A  58     -12.137  33.790  21.157  1.00  0.00           H  
ATOM    900  HG2 PRO A  58     -14.288  34.250  19.545  1.00  0.00           H  
ATOM    901  HG3 PRO A  58     -13.162  35.520  20.059  1.00  0.00           H  
ATOM    902  HD3 PRO A  58     -13.297  34.041  17.456  1.00  0.00           H  
ATOM    903  HD2 PRO A  58     -12.984  35.766  17.761  1.00  0.00           H  
ATOM    904  N   ALA A  59      -9.524  31.731  19.016  1.00  0.00           N  
ATOM    905  CA  ALA A  59      -9.083  30.430  18.543  1.00  0.00           C  
ATOM    906  C   ALA A  59      -8.335  29.679  19.634  1.00  0.00           C  
ATOM    907  O   ALA A  59      -7.172  29.975  19.924  1.00  0.00           O  
ATOM    908  CB  ALA A  59      -8.206  30.581  17.307  1.00  0.00           C  
ATOM    909  H   ALA A  59      -8.898  32.295  19.520  1.00  0.00           H  
ATOM    910  HA  ALA A  59      -9.961  29.861  18.269  1.00  0.00           H  
ATOM    911  HB1 ALA A  59      -7.922  29.603  16.945  1.00  0.00           H  
ATOM    912  HB2 ALA A  59      -7.320  31.141  17.564  1.00  0.00           H  
ATOM    913  HB3 ALA A  59      -8.755  31.105  16.539  1.00  0.00           H  
ATOM    914  N   GLN A  60      -9.017  28.731  20.262  1.00  0.00           N  
ATOM    915  CA  GLN A  60      -8.404  27.882  21.274  1.00  0.00           C  
ATOM    916  C   GLN A  60      -8.779  26.427  21.014  1.00  0.00           C  
ATOM    917  O   GLN A  60      -9.878  25.991  21.354  1.00  0.00           O  
ATOM    918  CB  GLN A  60      -8.844  28.310  22.677  1.00  0.00           C  
ATOM    919  CG  GLN A  60      -8.443  29.731  23.029  1.00  0.00           C  
ATOM    920  CD  GLN A  60      -8.867  30.136  24.426  1.00  0.00           C  
ATOM    921  OE1 GLN A  60      -9.871  29.658  24.953  1.00  0.00           O  
ATOM    922  NE2 GLN A  60      -8.097  31.020  25.038  1.00  0.00           N  
ATOM    923  H   GLN A  60      -9.962  28.593  20.037  1.00  0.00           H  
ATOM    924  HA  GLN A  60      -7.330  27.984  21.190  1.00  0.00           H  
ATOM    925  HB2 GLN A  60      -9.920  28.236  22.744  1.00  0.00           H  
ATOM    926  HB3 GLN A  60      -8.398  27.642  23.401  1.00  0.00           H  
ATOM    927  HG2 GLN A  60      -7.369  29.818  22.956  1.00  0.00           H  
ATOM    928  HG3 GLN A  60      -8.904  30.407  22.320  1.00  0.00           H  
ATOM    929 HE21 GLN A  60      -7.311  31.358  24.560  1.00  0.00           H  
ATOM    930 HE22 GLN A  60      -8.344  31.310  25.941  1.00  0.00           H  
ATOM    931  N   PRO A  61      -7.871  25.671  20.381  1.00  0.00           N  
ATOM    932  CA  PRO A  61      -8.138  24.298  19.936  1.00  0.00           C  
ATOM    933  C   PRO A  61      -8.324  23.314  21.089  1.00  0.00           C  
ATOM    934  O   PRO A  61      -7.350  22.894  21.715  1.00  0.00           O  
ATOM    935  CB  PRO A  61      -6.894  23.926  19.115  1.00  0.00           C  
ATOM    936  CG  PRO A  61      -6.168  25.210  18.878  1.00  0.00           C  
ATOM    937  CD  PRO A  61      -6.506  26.092  20.043  1.00  0.00           C  
ATOM    938  HA  PRO A  61      -9.009  24.260  19.300  1.00  0.00           H  
ATOM    939  HB2 PRO A  61      -6.288  23.235  19.680  1.00  0.00           H  
ATOM    940  HB3 PRO A  61      -7.198  23.468  18.185  1.00  0.00           H  
ATOM    941  HG2 PRO A  61      -5.104  25.026  18.843  1.00  0.00           H  
ATOM    942  HG3 PRO A  61      -6.503  25.661  17.955  1.00  0.00           H  
ATOM    943  HD3 PRO A  61      -5.826  25.908  20.865  1.00  0.00           H  
ATOM    944  HD2 PRO A  61      -6.482  27.129  19.753  1.00  0.00           H  
ATOM    945  N   SER A  62      -9.595  23.001  21.362  1.00  0.00           N  
ATOM    946  CA  SER A  62     -10.019  21.961  22.310  1.00  0.00           C  
ATOM    947  C   SER A  62      -9.110  21.822  23.534  1.00  0.00           C  
ATOM    948  O   SER A  62      -8.129  21.073  23.520  1.00  0.00           O  
ATOM    949  CB  SER A  62     -10.129  20.620  21.584  1.00  0.00           C  
ATOM    950  OG  SER A  62     -11.042  20.709  20.501  1.00  0.00           O  
ATOM    951  H   SER A  62     -10.296  23.498  20.886  1.00  0.00           H  
ATOM    952  HA  SER A  62     -11.004  22.233  22.656  1.00  0.00           H  
ATOM    953  HB2 SER A  62      -9.157  20.339  21.202  1.00  0.00           H  
ATOM    954  HB3 SER A  62     -10.480  19.863  22.272  1.00  0.00           H  
ATOM    955  HG  SER A  62     -11.819  21.205  20.782  1.00  0.00           H  
ATOM    956  N   LEU A  63      -9.438  22.541  24.596  1.00  0.00           N  
ATOM    957  CA  LEU A  63      -8.730  22.387  25.858  1.00  0.00           C  
ATOM    958  C   LEU A  63      -9.318  21.209  26.614  1.00  0.00           C  
ATOM    959  O   LEU A  63     -10.290  21.351  27.358  1.00  0.00           O  
ATOM    960  CB  LEU A  63      -8.802  23.663  26.711  1.00  0.00           C  
ATOM    961  CG  LEU A  63      -7.930  24.835  26.233  1.00  0.00           C  
ATOM    962  CD1 LEU A  63      -8.441  25.412  24.922  1.00  0.00           C  
ATOM    963  CD2 LEU A  63      -7.873  25.915  27.300  1.00  0.00           C  
ATOM    964  H   LEU A  63     -10.176  23.183  24.535  1.00  0.00           H  
ATOM    965  HA  LEU A  63      -7.695  22.172  25.633  1.00  0.00           H  
ATOM    966  HB2 LEU A  63      -9.828  23.995  26.733  1.00  0.00           H  
ATOM    967  HB3 LEU A  63      -8.502  23.412  27.718  1.00  0.00           H  
ATOM    968  HG  LEU A  63      -6.923  24.479  26.069  1.00  0.00           H  
ATOM    969 HD11 LEU A  63      -9.464  25.734  25.046  1.00  0.00           H  
ATOM    970 HD12 LEU A  63      -8.393  24.656  24.153  1.00  0.00           H  
ATOM    971 HD13 LEU A  63      -7.829  26.255  24.638  1.00  0.00           H  
ATOM    972 HD21 LEU A  63      -7.438  25.510  28.201  1.00  0.00           H  
ATOM    973 HD22 LEU A  63      -8.874  26.266  27.508  1.00  0.00           H  
ATOM    974 HD23 LEU A  63      -7.269  26.736  26.947  1.00  0.00           H  
ATOM    975  N   GLU A  64      -8.741  20.039  26.380  1.00  0.00           N  
ATOM    976  CA  GLU A  64      -9.272  18.794  26.910  1.00  0.00           C  
ATOM    977  C   GLU A  64      -8.168  17.751  27.033  1.00  0.00           C  
ATOM    978  O   GLU A  64      -7.238  17.727  26.226  1.00  0.00           O  
ATOM    979  CB  GLU A  64     -10.377  18.273  25.981  1.00  0.00           C  
ATOM    980  CG  GLU A  64     -10.900  16.891  26.346  1.00  0.00           C  
ATOM    981  CD  GLU A  64     -11.775  16.303  25.261  1.00  0.00           C  
ATOM    982  OE1 GLU A  64     -11.246  15.972  24.179  1.00  0.00           O  
ATOM    983  OE2 GLU A  64     -12.996  16.169  25.476  1.00  0.00           O  
ATOM    984  H   GLU A  64      -7.930  20.010  25.829  1.00  0.00           H  
ATOM    985  HA  GLU A  64      -9.689  18.989  27.886  1.00  0.00           H  
ATOM    986  HB2 GLU A  64     -11.206  18.964  26.009  1.00  0.00           H  
ATOM    987  HB3 GLU A  64      -9.991  18.232  24.972  1.00  0.00           H  
ATOM    988  HG2 GLU A  64     -10.060  16.233  26.509  1.00  0.00           H  
ATOM    989  HG3 GLU A  64     -11.478  16.968  27.255  1.00  0.00           H  
ATOM    990  N   HIS A  65      -8.266  16.903  28.049  1.00  0.00           N  
ATOM    991  CA  HIS A  65      -7.372  15.764  28.174  1.00  0.00           C  
ATOM    992  C   HIS A  65      -7.944  14.597  27.372  1.00  0.00           C  
ATOM    993  O   HIS A  65      -8.650  13.734  27.902  1.00  0.00           O  
ATOM    994  CB  HIS A  65      -7.178  15.382  29.644  1.00  0.00           C  
ATOM    995  CG  HIS A  65      -6.155  14.309  29.868  1.00  0.00           C  
ATOM    996  ND1 HIS A  65      -6.459  13.087  30.423  1.00  0.00           N  
ATOM    997  CD2 HIS A  65      -4.824  14.287  29.620  1.00  0.00           C  
ATOM    998  CE1 HIS A  65      -5.362  12.361  30.511  1.00  0.00           C  
ATOM    999  NE2 HIS A  65      -4.357  13.065  30.029  1.00  0.00           N  
ATOM   1000  H   HIS A  65      -8.960  17.046  28.728  1.00  0.00           H  
ATOM   1001  HA  HIS A  65      -6.419  16.043  27.747  1.00  0.00           H  
ATOM   1002  HB2 HIS A  65      -6.860  16.255  30.193  1.00  0.00           H  
ATOM   1003  HB3 HIS A  65      -8.118  15.036  30.046  1.00  0.00           H  
ATOM   1004  HD1 HIS A  65      -7.353  12.799  30.730  1.00  0.00           H  
ATOM   1005  HD2 HIS A  65      -4.241  15.082  29.177  1.00  0.00           H  
ATOM   1006  HE1 HIS A  65      -5.299  11.358  30.904  1.00  0.00           H  
ATOM   1007  HE2 HIS A  65      -3.408  12.800  30.077  1.00  0.00           H  
ATOM   1008  N   HIS A  66      -7.665  14.604  26.082  1.00  0.00           N  
ATOM   1009  CA  HIS A  66      -8.262  13.653  25.159  1.00  0.00           C  
ATOM   1010  C   HIS A  66      -7.359  12.442  24.972  1.00  0.00           C  
ATOM   1011  O   HIS A  66      -6.151  12.581  24.779  1.00  0.00           O  
ATOM   1012  CB  HIS A  66      -8.516  14.339  23.814  1.00  0.00           C  
ATOM   1013  CG  HIS A  66      -9.276  13.511  22.825  1.00  0.00           C  
ATOM   1014  ND1 HIS A  66      -8.671  12.825  21.796  1.00  0.00           N  
ATOM   1015  CD2 HIS A  66     -10.602  13.275  22.703  1.00  0.00           C  
ATOM   1016  CE1 HIS A  66      -9.592  12.208  21.081  1.00  0.00           C  
ATOM   1017  NE2 HIS A  66     -10.772  12.464  21.612  1.00  0.00           N  
ATOM   1018  H   HIS A  66      -7.026  15.265  25.734  1.00  0.00           H  
ATOM   1019  HA  HIS A  66      -9.203  13.330  25.575  1.00  0.00           H  
ATOM   1020  HB2 HIS A  66      -9.080  15.244  23.985  1.00  0.00           H  
ATOM   1021  HB3 HIS A  66      -7.567  14.596  23.368  1.00  0.00           H  
ATOM   1022  HD1 HIS A  66      -7.699  12.795  21.616  1.00  0.00           H  
ATOM   1023  HD2 HIS A  66     -11.382  13.655  23.348  1.00  0.00           H  
ATOM   1024  HE1 HIS A  66      -9.411  11.593  20.211  1.00  0.00           H  
ATOM   1025  HE2 HIS A  66     -11.641  12.235  21.204  1.00  0.00           H  
ATOM   1026  N   HIS A  67      -7.956  11.258  25.020  1.00  0.00           N  
ATOM   1027  CA  HIS A  67      -7.220  10.015  24.846  1.00  0.00           C  
ATOM   1028  C   HIS A  67      -6.713   9.892  23.410  1.00  0.00           C  
ATOM   1029  O   HIS A  67      -7.462  10.096  22.455  1.00  0.00           O  
ATOM   1030  CB  HIS A  67      -8.112   8.818  25.214  1.00  0.00           C  
ATOM   1031  CG  HIS A  67      -7.518   7.477  24.900  1.00  0.00           C  
ATOM   1032  ND1 HIS A  67      -6.799   6.730  25.809  1.00  0.00           N  
ATOM   1033  CD2 HIS A  67      -7.552   6.748  23.762  1.00  0.00           C  
ATOM   1034  CE1 HIS A  67      -6.419   5.601  25.241  1.00  0.00           C  
ATOM   1035  NE2 HIS A  67      -6.865   5.588  24.000  1.00  0.00           N  
ATOM   1036  H   HIS A  67      -8.930  11.217  25.158  1.00  0.00           H  
ATOM   1037  HA  HIS A  67      -6.371  10.040  25.513  1.00  0.00           H  
ATOM   1038  HB2 HIS A  67      -8.313   8.845  26.275  1.00  0.00           H  
ATOM   1039  HB3 HIS A  67      -9.047   8.901  24.678  1.00  0.00           H  
ATOM   1040  HD1 HIS A  67      -6.609   6.981  26.741  1.00  0.00           H  
ATOM   1041  HD2 HIS A  67      -8.032   7.028  22.834  1.00  0.00           H  
ATOM   1042  HE1 HIS A  67      -5.839   4.821  25.713  1.00  0.00           H  
ATOM   1043  HE2 HIS A  67      -6.864   4.800  23.402  1.00  0.00           H  
ATOM   1044  N   HIS A  68      -5.440   9.559  23.270  1.00  0.00           N  
ATOM   1045  CA  HIS A  68      -4.824   9.414  21.956  1.00  0.00           C  
ATOM   1046  C   HIS A  68      -3.999   8.135  21.881  1.00  0.00           C  
ATOM   1047  O   HIS A  68      -4.115   7.269  22.754  1.00  0.00           O  
ATOM   1048  CB  HIS A  68      -3.967  10.640  21.605  1.00  0.00           C  
ATOM   1049  CG  HIS A  68      -3.037  11.104  22.690  1.00  0.00           C  
ATOM   1050  ND1 HIS A  68      -1.716  10.719  22.776  1.00  0.00           N  
ATOM   1051  CD2 HIS A  68      -3.242  11.959  23.718  1.00  0.00           C  
ATOM   1052  CE1 HIS A  68      -1.155  11.318  23.810  1.00  0.00           C  
ATOM   1053  NE2 HIS A  68      -2.057  12.081  24.398  1.00  0.00           N  
ATOM   1054  H   HIS A  68      -4.898   9.393  24.077  1.00  0.00           H  
ATOM   1055  HA  HIS A  68      -5.627   9.339  21.235  1.00  0.00           H  
ATOM   1056  HB2 HIS A  68      -3.366  10.407  20.741  1.00  0.00           H  
ATOM   1057  HB3 HIS A  68      -4.624  11.464  21.360  1.00  0.00           H  
ATOM   1058  HD1 HIS A  68      -1.250  10.100  22.168  1.00  0.00           H  
ATOM   1059  HD2 HIS A  68      -4.167  12.464  23.954  1.00  0.00           H  
ATOM   1060  HE1 HIS A  68      -0.127  11.203  24.121  1.00  0.00           H  
ATOM   1061  HE2 HIS A  68      -1.838  12.826  25.011  1.00  0.00           H  
ATOM   1062  N   HIS A  69      -3.192   8.021  20.820  1.00  0.00           N  
ATOM   1063  CA  HIS A  69      -2.356   6.843  20.555  1.00  0.00           C  
ATOM   1064  C   HIS A  69      -3.197   5.667  20.058  1.00  0.00           C  
ATOM   1065  O   HIS A  69      -2.878   5.052  19.040  1.00  0.00           O  
ATOM   1066  CB  HIS A  69      -1.540   6.441  21.791  1.00  0.00           C  
ATOM   1067  CG  HIS A  69      -0.519   5.376  21.525  1.00  0.00           C  
ATOM   1068  ND1 HIS A  69       0.595   5.578  20.743  1.00  0.00           N  
ATOM   1069  CD2 HIS A  69      -0.449   4.091  21.948  1.00  0.00           C  
ATOM   1070  CE1 HIS A  69       1.307   4.469  20.698  1.00  0.00           C  
ATOM   1071  NE2 HIS A  69       0.698   3.550  21.423  1.00  0.00           N  
ATOM   1072  H   HIS A  69      -3.159   8.766  20.179  1.00  0.00           H  
ATOM   1073  HA  HIS A  69      -1.669   7.114  19.766  1.00  0.00           H  
ATOM   1074  HB2 HIS A  69      -1.019   7.310  22.166  1.00  0.00           H  
ATOM   1075  HB3 HIS A  69      -2.212   6.076  22.553  1.00  0.00           H  
ATOM   1076  HD1 HIS A  69       0.827   6.416  20.277  1.00  0.00           H  
ATOM   1077  HD2 HIS A  69      -1.167   3.584  22.579  1.00  0.00           H  
ATOM   1078  HE1 HIS A  69       2.231   4.335  20.155  1.00  0.00           H  
ATOM   1079  HE2 HIS A  69       1.121   2.710  21.735  1.00  0.00           H  
ATOM   1080  N   HIS A  70      -4.261   5.357  20.777  1.00  0.00           N  
ATOM   1081  CA  HIS A  70      -5.172   4.298  20.377  1.00  0.00           C  
ATOM   1082  C   HIS A  70      -6.580   4.640  20.842  1.00  0.00           C  
ATOM   1083  O   HIS A  70      -7.222   5.492  20.201  1.00  0.00           O  
ATOM   1084  CB  HIS A  70      -4.727   2.950  20.959  1.00  0.00           C  
ATOM   1085  CG  HIS A  70      -5.511   1.779  20.445  1.00  0.00           C  
ATOM   1086  ND1 HIS A  70      -6.657   1.312  21.052  1.00  0.00           N  
ATOM   1087  CD2 HIS A  70      -5.304   0.977  19.375  1.00  0.00           C  
ATOM   1088  CE1 HIS A  70      -7.119   0.277  20.379  1.00  0.00           C  
ATOM   1089  NE2 HIS A  70      -6.318   0.052  19.356  1.00  0.00           N  
ATOM   1090  OXT HIS A  70      -7.029   4.072  21.859  1.00  0.00           O  
ATOM   1091  H   HIS A  70      -4.453   5.867  21.598  1.00  0.00           H  
ATOM   1092  HA  HIS A  70      -5.161   4.238  19.296  1.00  0.00           H  
ATOM   1093  HB2 HIS A  70      -3.688   2.786  20.713  1.00  0.00           H  
ATOM   1094  HB3 HIS A  70      -4.837   2.977  22.033  1.00  0.00           H  
ATOM   1095  HD1 HIS A  70      -7.082   1.694  21.855  1.00  0.00           H  
ATOM   1096  HD2 HIS A  70      -4.493   1.051  18.665  1.00  0.00           H  
ATOM   1097  HE1 HIS A  70      -8.001  -0.294  20.626  1.00  0.00           H  
ATOM   1098  HE2 HIS A  70      -6.351  -0.751  18.776  1.00  0.00           H  
TER    1099      HIS A  70                                                      
END
MOLECULE T0480.pdb
ATOM     43  N   PHE    20      -9.421  47.124  -2.332  1.00  0.00
ATOM     44  HN  PHE    20      -9.663  47.024  -3.278  1.00  0.00
ATOM     45  CA  PHE    20     -10.050  48.188  -1.549  1.00  0.00
ATOM     46  HA  PHE    20      -9.287  48.642  -0.932  1.00  0.00
ATOM     47  CB  PHE    20     -10.641  49.260  -2.478  1.00  0.00
ATOM     48  HB1 PHE    20     -11.197  49.974  -1.885  1.00  0.00
ATOM     49  HB2 PHE    20     -11.316  48.788  -3.178  1.00  0.00
ATOM     50  CG  PHE    20      -9.613  50.019  -3.274  1.00  0.00
ATOM     51  CD1 PHE    20      -9.119  49.504  -4.460  1.00  0.00
ATOM     52  HD1 PHE    20      -9.476  48.547  -4.813  1.00  0.00
ATOM     53  CD2 PHE    20      -9.145  51.251  -2.836  1.00  0.00
ATOM     54  HD2 PHE    20      -9.523  51.664  -1.912  1.00  0.00
ATOM     55  CE1 PHE    20      -8.180  50.199  -5.195  1.00  0.00
ATOM     56  HE1 PHE    20      -7.803  49.783  -6.119  1.00  0.00
ATOM     57  CE2 PHE    20      -8.206  51.949  -3.568  1.00  0.00
ATOM     58  HE2 PHE    20      -7.850  52.908  -3.217  1.00  0.00
ATOM     59  CZ  PHE    20      -7.722  51.422  -4.750  1.00  0.00
ATOM     60  HZ  PHE    20      -6.988  51.966  -5.326  1.00  0.00
ATOM     61  C   PHE    20     -11.149  47.641  -0.643  1.00  0.00
ATOM     62  O   PHE    20     -11.503  46.465  -0.706  1.00  0.00
ATOM     63  N   CYS    21     -11.685  48.510   0.204  1.00  0.00
ATOM     64  HN  CYS    21     -11.329  49.425   0.240  1.00  0.00
ATOM     65  CA  CYS    21     -12.801  48.155   1.067  1.00  0.00
ATOM     66  HA  CYS    21     -12.726  47.105   1.318  1.00  0.00
ATOM     67  HB1 CYS    21     -12.914  50.028   2.087  1.00  0.00
ATOM     68  HB2 CYS    21     -11.760  48.898   2.773  1.00  0.00
ATOM     69  C   CYS    21     -14.100  48.414   0.312  1.00  0.00
ATOM     70  O   CYS    21     -14.384  49.557  -0.023  1.00  0.00
ATOM     71  CB  CYS    21     -12.742  48.991   2.341  1.00  0.00
ATOM     72  SG  CYS    21     -13.954  48.528   3.619  1.00  0.00
ATOM     73  N   PRO    22     -14.916  47.367   0.073  1.00  0.00
ATOM     74  CA  PRO    22     -16.026  47.404  -0.893  1.00  0.00
ATOM     75  HA  PRO    22     -15.680  47.160  -1.889  1.00  0.00
ATOM     76  CB  PRO    22     -16.958  46.298  -0.401  1.00  0.00
ATOM     77  HB1 PRO    22     -17.462  45.846  -1.245  1.00  0.00
ATOM     78  HB2 PRO    22     -17.694  46.716   0.276  1.00  0.00
ATOM     79  CG  PRO    22     -16.074  45.316   0.294  1.00  0.00
ATOM     80  HG1 PRO    22     -15.795  44.526  -0.389  1.00  0.00
ATOM     81  HG2 PRO    22     -16.602  44.907   1.141  1.00  0.00
ATOM     82  CD  PRO    22     -14.843  46.065   0.763  1.00  0.00
ATOM     83  HD1 PRO    22     -13.945  45.532   0.486  1.00  0.00
ATOM     84  HD2 PRO    22     -14.875  46.204   1.835  1.00  0.00
ATOM     85  C   PRO    22     -16.770  48.741  -0.939  1.00  0.00
ATOM     86  O   PRO    22     -16.834  49.390  -1.988  1.00  0.00
ATOM     87  N   ARG    23     -17.316  49.158   0.201  1.00  0.00
ATOM     88  HN  ARG    23     -17.154  48.653   1.025  1.00  0.00
ATOM     89  CA  ARG    23     -18.164  50.344   0.238  1.00  0.00
ATOM     90  HA  ARG    23     -18.672  50.391  -0.712  1.00  0.00
ATOM     91  CB  ARG    23     -19.223  50.223   1.341  1.00  0.00
ATOM     92  HB1 ARG    23     -19.804  51.135   1.369  1.00  0.00
ATOM     93  HB2 ARG    23     -18.724  50.096   2.291  1.00  0.00
ATOM     94  CG  ARG    23     -20.180  49.050   1.141  1.00  0.00
ATOM     95  HG1 ARG    23     -19.642  48.129   1.321  1.00  0.00
ATOM     96  HG2 ARG    23     -20.538  49.061   0.121  1.00  0.00
ATOM     97  CD  ARG    23     -21.381  49.113   2.081  1.00  0.00
ATOM     98  HD1 ARG    23     -21.999  48.242   1.910  1.00  0.00
ATOM     99  HD2 ARG    23     -21.951  50.003   1.854  1.00  0.00
ATOM    100  NE  ARG    23     -20.991  49.150   3.495  1.00  0.00
ATOM    101  HE  ARG    23     -20.100  49.512   3.706  1.00  0.00
ATOM    102  CZ  ARG    23     -21.777  48.752   4.498  1.00  0.00
ATOM    103  NH1 ARG    23     -22.967  48.220   4.250  1.00  0.00
ATOM    104 HH11 ARG    23     -23.285  48.110   3.303  1.00  0.00
ATOM    105 HH12 ARG    23     -23.556  47.929   5.009  1.00  0.00
ATOM    106  NH2 ARG    23     -21.364  48.866   5.751  1.00  0.00
ATOM    107 HH21 ARG    23     -20.460  49.252   5.953  1.00  0.00
ATOM    108 HH22 ARG    23     -21.954  48.569   6.504  1.00  0.00
ATOM    109  C   ARG    23     -17.352  51.633   0.415  1.00  0.00
ATOM    110  O   ARG    23     -17.758  52.692  -0.062  1.00  0.00
ATOM    111  N   CYS    24     -16.206  51.549   1.092  1.00  0.00
ATOM    112  HN  CYS    24     -15.914  50.681   1.429  1.00  0.00
ATOM    113  CA  CYS    24     -15.370  52.739   1.328  1.00  0.00
ATOM    114  HA  CYS    24     -16.018  53.602   1.381  1.00  0.00
ATOM    115  HB1 CYS    24     -14.192  53.616   2.885  1.00  0.00
ATOM    116  HB2 CYS    24     -13.735  51.970   2.480  1.00  0.00
ATOM    117  C   CYS    24     -14.366  52.941   0.194  1.00  0.00
ATOM    118  O   CYS    24     -13.660  53.947   0.171  1.00  0.00
ATOM    119  CB  CYS    24     -14.572  52.634   2.635  1.00  0.00
ATOM    120  SG  CYS    24     -15.473  52.014   4.084  1.00  0.00
ATOM    121  N   GLY    25     -14.311  51.975  -0.727  1.00  0.00
ATOM    122  HN  GLY    25     -15.009  51.286  -0.729  1.00  0.00
ATOM    123  CA  GLY    25     -13.256  51.919  -1.735  1.00  0.00
ATOM    124  HA1 GLY    25     -13.576  51.268  -2.533  1.00  0.00
ATOM    125  HA2 GLY    25     -12.373  51.493  -1.282  1.00  0.00
ATOM    126  C   GLY    25     -12.895  53.274  -2.316  1.00  0.00
ATOM    127  O   GLY    25     -11.779  53.757  -2.106  1.00  0.00
ATOM    128  N   PRO    26     -13.818  53.919  -3.049  1.00  0.00
ATOM    129  CA  PRO    26     -13.599  55.269  -3.570  1.00  0.00
ATOM    130  HA  PRO    26     -12.703  55.315  -4.175  1.00  0.00
ATOM    131  CB  PRO    26     -14.836  55.536  -4.453  1.00  0.00
ATOM    132  HB1 PRO    26     -14.526  55.974  -5.391  1.00  0.00
ATOM    133  HB2 PRO    26     -15.511  56.212  -3.944  1.00  0.00
ATOM    134  CG  PRO    26     -15.466  54.197  -4.662  1.00  0.00
ATOM    135  HG1 PRO    26     -15.052  53.729  -5.546  1.00  0.00
ATOM    136  HG2 PRO    26     -16.537  54.305  -4.764  1.00  0.00
ATOM    137  CD  PRO    26     -15.135  53.389  -3.440  1.00  0.00
ATOM    138  HD1 PRO    26     -15.075  52.339  -3.684  1.00  0.00
ATOM    139  HD2 PRO    26     -15.868  53.560  -2.664  1.00  0.00
ATOM    140  C   PRO    26     -13.496  56.293  -2.437  1.00  0.00
ATOM    141  O   PRO    26     -14.508  56.823  -1.967  1.00  0.00
ATOM    142  N   GLY    27     -12.275  56.524  -1.966  1.00  0.00
ATOM    143  HN  GLY    27     -11.520  56.002  -2.319  1.00  0.00
ATOM    144  CA  GLY    27     -12.036  57.519  -0.932  1.00  0.00
ATOM    145  HA1 GLY    27     -12.982  57.935  -0.612  1.00  0.00
ATOM    146  HA2 GLY    27     -11.430  58.310  -1.348  1.00  0.00
ATOM    147  C   GLY    27     -11.325  56.943   0.273  1.00  0.00
ATOM    148  O   GLY    27     -10.653  57.668   1.009  1.00  0.00
ATOM    149  N   VAL    28     -11.468  55.634   0.479  1.00  0.00
ATOM    150  HN  VAL    28     -12.031  55.114  -0.136  1.00  0.00
ATOM    151  CA  VAL    28     -10.810  54.948   1.591  1.00  0.00
ATOM    152  HA  VAL    28     -10.018  55.586   1.960  1.00  0.00
ATOM    153  CB  VAL    28     -11.782  54.646   2.763  1.00  0.00
ATOM    154  HB  VAL    28     -12.477  53.886   2.424  1.00  0.00
ATOM    155  CG1 VAL    28     -11.028  54.082   3.968  1.00  0.00
ATOM    156 HG11 VAL    28     -10.300  54.803   4.309  1.00  0.00
ATOM    157 HG12 VAL    28     -10.525  53.168   3.687  1.00  0.00
ATOM    158 HG13 VAL    28     -11.728  53.875   4.766  1.00  0.00
ATOM    159  CG2 VAL    28     -12.588  55.883   3.159  1.00  0.00
ATOM    160 HG21 VAL    28     -11.917  56.666   3.482  1.00  0.00
ATOM    161 HG22 VAL    28     -13.260  55.632   3.967  1.00  0.00
ATOM    162 HG23 VAL    28     -13.162  56.229   2.311  1.00  0.00
ATOM    163  C   VAL    28     -10.205  53.631   1.123  1.00  0.00
ATOM    164  O   VAL    28     -10.910  52.621   0.993  1.00  0.00
ATOM    165  N   PHE    29      -8.907  53.645   0.861  1.00  0.00
ATOM    166  HN  PHE    29      -8.420  54.495   0.903  1.00  0.00
ATOM    167  CA  PHE    29      -8.190  52.430   0.504  1.00  0.00
ATOM    168  HA  PHE    29      -8.697  51.979  -0.339  1.00  0.00
ATOM    169  CB  PHE    29      -6.738  52.749   0.109  1.00  0.00
ATOM    170  HB1 PHE    29      -6.738  53.555  -0.613  1.00  0.00
ATOM    171  HB2 PHE    29      -6.296  51.872  -0.342  1.00  0.00
ATOM    172  CG  PHE    29      -5.864  53.166   1.270  1.00  0.00
ATOM    173  CD1 PHE    29      -4.909  52.298   1.788  1.00  0.00
ATOM    174  HD1 PHE    29      -4.786  51.319   1.348  1.00  0.00
ATOM    175  CD2 PHE    29      -6.003  54.418   1.850  1.00  0.00
ATOM    176  HD2 PHE    29      -6.739  55.104   1.458  1.00  0.00
ATOM    177  CE1 PHE    29      -4.116  52.673   2.857  1.00  0.00
ATOM    178  HE1 PHE    29      -3.377  51.988   3.249  1.00  0.00
ATOM    179  CE2 PHE    29      -5.211  54.796   2.917  1.00  0.00
ATOM    180  HE2 PHE    29      -5.331  55.775   3.358  1.00  0.00
ATOM    181  CZ  PHE    29      -4.268  53.924   3.421  1.00  0.00
ATOM    182  HZ  PHE    29      -3.650  54.219   4.258  1.00  0.00
ATOM    183  C   PHE    29      -8.210  51.449   1.679  1.00  0.00
ATOM    184  O   PHE    29      -8.458  51.838   2.825  1.00  0.00
ATOM    185  N   LEU    30      -7.958  50.182   1.396  1.00  0.00
ATOM    186  HN  LEU    30      -7.805  49.919   0.464  1.00  0.00
ATOM    187  CA  LEU    30      -7.868  49.176   2.441  1.00  0.00
ATOM    188  HA  LEU    30      -8.446  49.515   3.292  1.00  0.00
ATOM    189  CB  LEU    30      -8.437  47.841   1.939  1.00  0.00
ATOM    190  HB1 LEU    30      -7.762  47.449   1.190  1.00  0.00
ATOM    191  HB2 LEU    30      -9.389  48.040   1.467  1.00  0.00
ATOM    192  CG  LEU    30      -8.649  46.756   3.010  1.00  0.00
ATOM    193  HG  LEU    30      -7.705  46.559   3.499  1.00  0.00
ATOM    194  CD1 LEU    30      -9.637  47.226   4.075  1.00  0.00
ATOM    195 HD11 LEU    30     -10.591  47.443   3.615  1.00  0.00
ATOM    196 HD12 LEU    30      -9.257  48.119   4.550  1.00  0.00
ATOM    197 HD13 LEU    30      -9.765  46.452   4.819  1.00  0.00
ATOM    198  CD2 LEU    30      -9.129  45.452   2.368  1.00  0.00
ATOM    199 HD21 LEU    30     -10.068  45.622   1.859  1.00  0.00
ATOM    200 HD22 LEU    30      -9.268  44.701   3.133  1.00  0.00
ATOM    201 HD23 LEU    30      -8.392  45.106   1.657  1.00  0.00
ATOM    202  C   LEU    30      -6.405  49.037   2.850  1.00  0.00
ATOM    203  O   LEU    30      -5.581  48.585   2.055  1.00  0.00
ATOM    204  N   ALA    31      -6.089  49.469   4.074  1.00  0.00
ATOM    205  HN  ALA    31      -6.808  49.759   4.671  1.00  0.00
ATOM    206  CA  ALA    31      -4.708  49.517   4.560  1.00  0.00
ATOM    207  HA  ALA    31      -4.182  50.263   3.979  1.00  0.00
ATOM    208  CB  ALA    31      -4.674  49.953   6.023  1.00  0.00
ATOM    209  HB1 ALA    31      -3.648  50.043   6.352  1.00  0.00
ATOM    210  HB2 ALA    31      -5.182  49.219   6.631  1.00  0.00
ATOM    211  HB3 ALA    31      -5.167  50.908   6.126  1.00  0.00
ATOM    212  C   ALA    31      -4.007  48.174   4.380  1.00  0.00
ATOM    213  O   ALA    31      -4.101  47.290   5.237  1.00  0.00
ATOM    214  N   GLU    32      -3.331  48.023   3.246  1.00  0.00
ATOM    215  HN  GLU    32      -3.321  48.760   2.599  1.00  0.00
ATOM    216  CA  GLU    32      -2.625  46.794   2.922  1.00  0.00
ATOM    217  HA  GLU    32      -3.248  45.965   3.234  1.00  0.00
ATOM    218  CB  GLU    32      -2.386  46.686   1.408  1.00  0.00
ATOM    219  HB1 GLU    32      -1.814  47.543   1.083  1.00  0.00
ATOM    220  HB2 GLU    32      -3.342  46.691   0.903  1.00  0.00
ATOM    221  CG  GLU    32      -1.632  45.422   0.999  1.00  0.00
ATOM    222  HG1 GLU    32      -2.172  44.560   1.369  1.00  0.00
ATOM    223  HG2 GLU    32      -0.650  45.445   1.449  1.00  0.00
ATOM    224  CD  GLU    32      -1.467  45.287  -0.506  1.00  0.00
ATOM    225  OE1 GLU    32      -0.618  46.002  -1.079  1.00  0.00
ATOM    226  OE2 GLU    32      -2.171  44.448  -1.114  1.00  0.00
ATOM    227  C   GLU    32      -1.300  46.719   3.673  1.00  0.00
ATOM    228  O   GLU    32      -0.357  47.459   3.381  1.00  0.00
ATOM    229  N   HIS    33      -1.263  45.852   4.668  1.00  0.00
ATOM    230  HN  HIS    33      -2.089  45.388   4.911  1.00  0.00
ATOM    231  CA  HIS    33      -0.045  45.545   5.406  1.00  0.00
ATOM    232  HA  HIS    33       0.685  46.317   5.196  1.00  0.00
ATOM    233  CB  HIS    33      -0.317  45.503   6.914  1.00  0.00
ATOM    234  HB1 HIS    33       0.590  45.218   7.429  1.00  0.00
ATOM    235  HB2 HIS    33      -1.084  44.767   7.119  1.00  0.00
ATOM    236  CG  HIS    33      -0.772  46.815   7.476  1.00  0.00
ATOM    237  ND1 HIS    33       0.097  47.768   7.958  1.00  0.00
ATOM    238  HD1 HIS    33       1.077  47.689   7.991  1.00  0.00
ATOM    239  CD2 HIS    33      -2.014  47.330   7.633  1.00  0.00
ATOM    240  HD2 HIS    33      -2.944  46.851   7.362  1.00  0.00
ATOM    241  CE1 HIS    33      -0.589  48.809   8.385  1.00  0.00
ATOM    242  HE1 HIS    33      -0.169  49.705   8.818  1.00  0.00
ATOM    243  NE2 HIS    33      -1.873  48.572   8.199  1.00  0.00
ATOM    244  HE2 HIS    33      -2.599  49.075   8.631  1.00  0.00
ATOM    245  C   HIS    33       0.506  44.203   4.940  1.00  0.00
ATOM    246  O   HIS    33      -0.225  43.393   4.365  1.00  0.00
ATOM    247  N   ALA    34       1.782  43.964   5.214  1.00  0.00
ATOM    248  HN  ALA    34       2.282  44.621   5.746  1.00  0.00
ATOM    249  CA  ALA    34       2.468  42.759   4.751  1.00  0.00
ATOM    250  HA  ALA    34       2.479  42.779   3.670  1.00  0.00
ATOM    251  CB  ALA    34       3.914  42.763   5.235  1.00  0.00
ATOM    252  HB1 ALA    34       4.434  41.909   4.826  1.00  0.00
ATOM    253  HB2 ALA    34       3.936  42.714   6.315  1.00  0.00
ATOM    254  HB3 ALA    34       4.401  43.670   4.907  1.00  0.00
ATOM    255  C   ALA    34       1.761  41.481   5.206  1.00  0.00
ATOM    256  O   ALA    34       1.850  40.444   4.543  1.00  0.00
ATOM    257  N   ASP    35       1.049  41.561   6.329  1.00  0.00
ATOM    258  HN  ASP    35       0.954  42.428   6.773  1.00  0.00
ATOM    259  CA  ASP    35       0.416  40.383   6.923  1.00  0.00
ATOM    260  HA  ASP    35       0.770  39.510   6.392  1.00  0.00
ATOM    261  CB  ASP    35       0.816  40.251   8.399  1.00  0.00
ATOM    262  HB1 ASP    35       1.883  40.394   8.487  1.00  0.00
ATOM    263  HB2 ASP    35       0.565  39.258   8.747  1.00  0.00
ATOM    264  CG  ASP    35       0.122  41.266   9.293  1.00  0.00
ATOM    265  OD1 ASP    35       0.449  42.468   9.202  1.00  0.00
ATOM    266  OD2 ASP    35      -0.746  40.867  10.097  1.00  0.00
ATOM    267  C   ASP    35      -1.111  40.429   6.812  1.00  0.00
ATOM    268  O   ASP    35      -1.773  39.400   6.966  1.00  0.00
ATOM    269  N   ARG    36      -1.682  41.598   6.521  1.00  0.00
ATOM    270  HN  ARG    36      -1.122  42.366   6.270  1.00  0.00
ATOM    271  CA  ARG    36      -3.142  41.736   6.533  1.00  0.00
ATOM    272  HA  ARG    36      -3.550  40.949   5.917  1.00  0.00
ATOM    273  CB  ARG    36      -3.678  41.570   7.966  1.00  0.00
ATOM    274  HB1 ARG    36      -3.315  40.633   8.368  1.00  0.00
ATOM    275  HB2 ARG    36      -4.759  41.538   7.933  1.00  0.00
ATOM    276  CG  ARG    36      -3.264  42.690   8.914  1.00  0.00
ATOM    277  HG1 ARG    36      -3.731  43.611   8.594  1.00  0.00
ATOM    278  HG2 ARG    36      -2.190  42.797   8.873  1.00  0.00
ATOM    279  CD  ARG    36      -3.677  42.398  10.353  1.00  0.00
ATOM    280  HD1 ARG    36      -3.114  41.546  10.712  1.00  0.00
ATOM    281  HD2 ARG    36      -4.732  42.162  10.370  1.00  0.00
ATOM    282  NE  ARG    36      -3.436  43.539  11.239  1.00  0.00
ATOM    283  HE  ARG    36      -4.165  44.194  11.330  1.00  0.00
ATOM    284  CZ  ARG    36      -2.321  43.724  11.948  1.00  0.00
ATOM    285  NH1 ARG    36      -1.289  42.903  11.808  1.00  0.00
ATOM    286 HH11 ARG    36      -1.337  42.131  11.163  1.00  0.00
ATOM    287 HH12 ARG    36      -0.455  43.046  12.347  1.00  0.00
ATOM    288  NH2 ARG    36      -2.225  44.752  12.777  1.00  0.00
ATOM    289 HH21 ARG    36      -2.992  45.396  12.878  1.00  0.00
ATOM    290 HH22 ARG    36      -1.390  44.887  13.317  1.00  0.00
ATOM    291  C   ARG    36      -3.592  43.080   5.962  1.00  0.00
ATOM    292  O   ARG    36      -2.805  43.816   5.384  1.00  0.00
ATOM    293  N   TYR    37      -4.876  43.366   6.135  1.00  0.00
ATOM    294  HN  TYR    37      -5.429  42.719   6.609  1.00  0.00
ATOM    295  CA  TYR    37      -5.508  44.603   5.686  1.00  0.00
ATOM    296  HA  TYR    37      -4.743  45.306   5.387  1.00  0.00
ATOM    297  CB  TYR    37      -6.477  44.347   4.519  1.00  0.00
ATOM    298  HB1 TYR    37      -6.833  45.302   4.155  1.00  0.00
ATOM    299  HB2 TYR    37      -7.322  43.784   4.887  1.00  0.00
ATOM    300  CG  TYR    37      -5.912  43.586   3.333  1.00  0.00
ATOM    301  CD1 TYR    37      -5.992  42.198   3.273  1.00  0.00
ATOM    302  HD1 TYR    37      -6.438  41.661   4.097  1.00  0.00
ATOM    303  CD2 TYR    37      -5.335  44.256   2.258  1.00  0.00
ATOM    304  HD2 TYR    37      -5.265  45.334   2.286  1.00  0.00
ATOM    305  CE1 TYR    37      -5.512  41.502   2.183  1.00  0.00
ATOM    306  HE1 TYR    37      -5.586  40.425   2.155  1.00  0.00
ATOM    307  CE2 TYR    37      -4.849  43.564   1.166  1.00  0.00
ATOM    308  HE2 TYR    37      -4.402  44.101   0.342  1.00  0.00
ATOM    309  CZ  TYR    37      -4.942  42.190   1.133  1.00  0.00
ATOM    310  OH  TYR    37      -4.459  41.497   0.046  1.00  0.00
ATOM    311  HH  TYR    37      -5.120  40.864  -0.251  1.00  0.00
ATOM    312  C   TYR    37      -6.322  45.182   6.841  1.00  0.00
ATOM    313  O   TYR    37      -6.679  44.453   7.767  1.00  0.00
ATOM    314  N   SER    38      -6.636  46.471   6.777  1.00  0.00
ATOM    315  HN  SER    38      -6.247  47.026   6.068  1.00  0.00
ATOM    316  CA  SER    38      -7.535  47.084   7.751  1.00  0.00
ATOM    317  HA  SER    38      -8.327  46.375   7.956  1.00  0.00
ATOM    318  CB  SER    38      -6.797  47.393   9.060  1.00  0.00
ATOM    319  HB1 SER    38      -6.130  48.229   8.911  1.00  0.00
ATOM    320  HB2 SER    38      -6.225  46.527   9.362  1.00  0.00
ATOM    321  OG  SER    38      -7.714  47.715  10.094  1.00  0.00
ATOM    322  HG  SER    38      -8.082  46.897  10.459  1.00  0.00
ATOM    323  C   SER    38      -8.166  48.351   7.170  1.00  0.00
ATOM    324  O   SER    38      -7.687  48.894   6.172  1.00  0.00
ATOM    325  N   CYS    39      -9.256  48.806   7.780  1.00  0.00
ATOM    326  HN  CYS    39      -9.589  48.331   8.573  1.00  0.00
ATOM    327  CA  CYS    39      -9.980  49.978   7.296  1.00  0.00
ATOM    328  HA  CYS    39      -9.347  50.504   6.596  1.00  0.00
ATOM    329  HB1 CYS    39     -11.825  48.903   7.229  1.00  0.00
ATOM    330  HB2 CYS    39     -10.986  48.989   5.693  1.00  0.00
ATOM    331  C   CYS    39     -10.341  50.922   8.431  1.00  0.00
ATOM    332  O   CYS    39     -11.402  50.776   9.049  1.00  0.00
ATOM    333  CB  CYS    39     -11.253  49.545   6.574  1.00  0.00
ATOM    334  SG  CYS    39     -12.344  50.914   6.050  1.00  0.00
ATOM    335  N   GLY    40      -9.454  51.877   8.706  1.00  0.00
ATOM    336  HN  GLY    40      -8.584  51.868   8.253  1.00  0.00
ATOM    337  CA  GLY    40      -9.742  52.916   9.678  1.00  0.00
ATOM    338  HA1 GLY    40      -8.854  53.512   9.830  1.00  0.00
ATOM    339  HA2 GLY    40     -10.020  52.456  10.616  1.00  0.00
ATOM    340  C   GLY    40     -10.870  53.818   9.213  1.00  0.00
ATOM    341  O   GLY    40     -10.634  54.923   8.718  1.00  0.00
ATOM    342  N   ARG    41     -12.095  53.327   9.360  1.00  0.00
ATOM    343  HN  ARG    41     -12.200  52.466   9.822  1.00  0.00
ATOM    344  CA  ARG    41     -13.289  54.031   8.907  1.00  0.00
ATOM    345  HA  ARG    41     -13.318  54.990   9.406  1.00  0.00
ATOM    346  CB  ARG    41     -13.252  54.250   7.384  1.00  0.00
ATOM    347  HB1 ARG    41     -13.317  53.288   6.892  1.00  0.00
ATOM    348  HB2 ARG    41     -12.308  54.710   7.123  1.00  0.00
ATOM    349  CG  ARG    41     -14.378  55.137   6.858  1.00  0.00
ATOM    350  HG1 ARG    41     -15.326  54.721   7.169  1.00  0.00
ATOM    351  HG2 ARG    41     -14.332  55.156   5.778  1.00  0.00
ATOM    352  CD  ARG    41     -14.270  56.568   7.379  1.00  0.00
ATOM    353  HD1 ARG    41     -13.379  57.024   6.966  1.00  0.00
ATOM    354  HD2 ARG    41     -14.193  56.542   8.456  1.00  0.00
ATOM    355  NE  ARG    41     -15.434  57.375   7.008  1.00  0.00
ATOM    356  HE  ARG    41     -16.316  57.040   7.290  1.00  0.00
ATOM    357  CZ  ARG    41     -15.372  58.529   6.339  1.00  0.00
ATOM    358  NH1 ARG    41     -14.206  59.004   5.921  1.00  0.00
ATOM    359 HH11 ARG    41     -13.359  58.498   6.105  1.00  0.00
ATOM    360 HH12 ARG    41     -14.164  59.872   5.417  1.00  0.00
ATOM    361  NH2 ARG    41     -16.485  59.200   6.077  1.00  0.00
ATOM    362 HH21 ARG    41     -17.372  58.843   6.382  1.00  0.00
ATOM    363 HH22 ARG    41     -16.447  60.068   5.571  1.00  0.00
ATOM    364  C   ARG    41     -14.536  53.232   9.294  1.00  0.00
ATOM    365  O   ARG    41     -15.460  53.767   9.905  1.00  0.00
ATOM    366  N   CYS    42     -14.550  51.941   8.946  1.00  0.00
ATOM    367  HN  CYS    42     -13.788  51.572   8.462  1.00  0.00
ATOM    368  CA  CYS    42     -15.680  51.066   9.290  1.00  0.00
ATOM    369  HA  CYS    42     -16.324  51.612   9.967  1.00  0.00
ATOM    370  HB1 CYS    42     -16.667  51.558   7.443  1.00  0.00
ATOM    371  HB2 CYS    42     -17.452  50.281   8.357  1.00  0.00
ATOM    372  C   CYS    42     -15.190  49.810  10.010  1.00  0.00
ATOM    373  O   CYS    42     -15.972  48.902  10.291  1.00  0.00
ATOM    374  CB  CYS    42     -16.497  50.676   8.042  1.00  0.00
ATOM    375  SG  CYS    42     -15.721  49.422   6.967  1.00  0.00
ATOM    376  N   GLY    43     -13.886  49.755  10.293  1.00  0.00
ATOM    377  HN  GLY    43     -13.292  50.472   9.984  1.00  0.00
ATOM    378  CA  GLY    43     -13.333  48.655  11.068  1.00  0.00
ATOM    379  HA1 GLY    43     -13.985  48.453  11.906  1.00  0.00
ATOM    380  HA2 GLY    43     -12.365  48.951  11.446  1.00  0.00
ATOM    381  C   GLY    43     -13.167  47.383  10.264  1.00  0.00
ATOM    382  O   GLY    43     -12.919  46.319  10.828  1.00  0.00
ATOM    383  N   TYR    44     -13.292  47.490   8.943  1.00  0.00
ATOM    384  HN  TYR    44     -13.474  48.365   8.552  1.00  0.00
ATOM    385  CA  TYR    44     -13.151  46.329   8.071  1.00  0.00
ATOM    386  HA  TYR    44     -13.761  45.533   8.480  1.00  0.00
ATOM    387  CB  TYR    44     -13.634  46.650   6.644  1.00  0.00
ATOM    388  HB1 TYR    44     -12.949  47.348   6.181  1.00  0.00
ATOM    389  HB2 TYR    44     -14.613  47.103   6.698  1.00  0.00
ATOM    390  CG  TYR    44     -13.736  45.430   5.742  1.00  0.00
ATOM    391  CD1 TYR    44     -14.898  44.664   5.711  1.00  0.00
ATOM    392  HD1 TYR    44     -15.731  44.949   6.336  1.00  0.00
ATOM    393  CD2 TYR    44     -12.675  45.043   4.926  1.00  0.00
ATOM    394  HD2 TYR    44     -11.765  45.625   4.936  1.00  0.00
ATOM    395  CE1 TYR    44     -14.999  43.553   4.896  1.00  0.00
ATOM    396  HE1 TYR    44     -15.910  42.972   4.888  1.00  0.00
ATOM    397  CE2 TYR    44     -12.772  43.932   4.110  1.00  0.00
ATOM    398  HE2 TYR    44     -11.937  43.647   3.485  1.00  0.00
ATOM    399  CZ  TYR    44     -13.935  43.191   4.098  1.00  0.00
ATOM    400  OH  TYR    44     -14.035  42.084   3.285  1.00  0.00
ATOM    401  HH  TYR    44     -13.267  41.512   3.421  1.00  0.00
ATOM    402  C   TYR    44     -11.692  45.874   8.052  1.00  0.00
ATOM    403  O   TYR    44     -10.820  46.586   7.541  1.00  0.00
ATOM    404  N   THR    45     -11.440  44.710   8.635  1.00  0.00
ATOM    405  HN  THR    45     -12.181  44.224   9.056  1.00  0.00
ATOM    406  CA  THR    45     -10.111  44.123   8.690  1.00  0.00
ATOM    407  HA  THR    45      -9.436  44.742   8.108  1.00  0.00
ATOM    408  CB  THR    45      -9.598  44.072  10.151  1.00  0.00
ATOM    409  HB  THR    45     -10.307  43.509  10.743  1.00  0.00
ATOM    410  OG1 THR    45      -9.513  45.405  10.682  1.00  0.00
ATOM    411  HG1 THR    45     -10.178  45.513  11.373  1.00  0.00
ATOM    412  CG2 THR    45      -8.233  43.392  10.251  1.00  0.00
ATOM    413 HG21 THR    45      -7.903  43.395  11.280  1.00  0.00
ATOM    414 HG22 THR    45      -7.517  43.926   9.643  1.00  0.00
ATOM    415 HG23 THR    45      -8.311  42.372   9.903  1.00  0.00
ATOM    416  C   THR    45     -10.144  42.717   8.091  1.00  0.00
ATOM    417  O   THR    45     -11.064  41.940   8.359  1.00  0.00
ATOM    418  N   GLU    46      -9.150  42.411   7.270  1.00  0.00
ATOM    419  HN  GLU    46      -8.432  43.068   7.132  1.00  0.00
ATOM    420  CA  GLU    46      -9.061  41.127   6.581  1.00  0.00
ATOM    421  HA  GLU    46      -9.638  40.397   7.131  1.00  0.00
ATOM    422  CB  GLU    46      -9.617  41.256   5.152  1.00  0.00
ATOM    423  HB1 GLU    46      -9.027  41.987   4.614  1.00  0.00
ATOM    424  HB2 GLU    46     -10.638  41.607   5.206  1.00  0.00
ATOM    425  CG  GLU    46      -9.603  39.953   4.359  1.00  0.00
ATOM    426  HG1 GLU    46      -8.586  39.589   4.310  1.00  0.00
ATOM    427  HG2 GLU    46      -9.958  40.150   3.356  1.00  0.00
ATOM    428  CD  GLU    46     -10.477  38.876   4.981  1.00  0.00
ATOM    429  OE1 GLU    46      -9.978  38.115   5.835  1.00  0.00
ATOM    430  OE2 GLU    46     -11.665  38.779   4.610  1.00  0.00
ATOM    431  C   GLU    46      -7.603  40.695   6.546  1.00  0.00
ATOM    432  O   GLU    46      -6.725  41.538   6.470  1.00  0.00
ATOM    433  N   PHE    47      -7.333  39.399   6.601  1.00  0.00
ATOM    434  HN  PHE    47      -8.072  38.749   6.586  1.00  0.00
ATOM    435  CA  PHE    47      -5.950  38.917   6.656  1.00  0.00
ATOM    436  HA  PHE    47      -5.338  39.722   7.041  1.00  0.00
ATOM    437  CB  PHE    47      -5.833  37.719   7.606  1.00  0.00
ATOM    438  HB1 PHE    47      -4.848  37.284   7.507  1.00  0.00
ATOM    439  HB2 PHE    47      -6.574  36.980   7.337  1.00  0.00
ATOM    440  CG  PHE    47      -6.037  38.084   9.055  1.00  0.00
ATOM    441  CD1 PHE    47      -7.275  37.931   9.663  1.00  0.00
ATOM    442  HD1 PHE    47      -8.103  37.536   9.090  1.00  0.00
ATOM    443  CD2 PHE    47      -4.984  38.591   9.806  1.00  0.00
ATOM    444  HD2 PHE    47      -4.014  38.715   9.342  1.00  0.00
ATOM    445  CE1 PHE    47      -7.457  38.275  10.989  1.00  0.00
ATOM    446  HE1 PHE    47      -8.426  38.151  11.451  1.00  0.00
ATOM    447  CE2 PHE    47      -5.163  38.934  11.133  1.00  0.00
ATOM    448  HE2 PHE    47      -4.336  39.325  11.707  1.00  0.00
ATOM    449  CZ  PHE    47      -6.400  38.776  11.724  1.00  0.00
ATOM    450  HZ  PHE    47      -6.542  39.045  12.761  1.00  0.00
ATOM    451  C   PHE    47      -5.431  38.540   5.273  1.00  0.00
ATOM    452  O   PHE    47      -6.207  38.197   4.380  1.00  0.00
ATOM    453  N   LYS    48      -4.109  38.631   5.098  1.00  0.00
ATOM    454  HN  LYS    48      -3.558  39.035   5.806  1.00  0.00
ATOM    455  CA  LYS    48      -3.461  38.123   3.891  1.00  0.00
ATOM    456  HA  LYS    48      -3.984  38.527   3.032  1.00  0.00
ATOM    457  CB  LYS    48      -1.979  38.548   3.833  1.00  0.00
ATOM    458  HB1 LYS    48      -1.467  37.928   3.110  1.00  0.00
ATOM    459  HB2 LYS    48      -1.536  38.381   4.805  1.00  0.00
ATOM    460  CG  LYS    48      -1.748  40.015   3.454  1.00  0.00
ATOM    461  HG1 LYS    48      -0.734  40.287   3.714  1.00  0.00
ATOM    462  HG2 LYS    48      -2.437  40.634   4.012  1.00  0.00
ATOM    463  CD  LYS    48      -1.962  40.267   1.960  1.00  0.00
ATOM    464  HD1 LYS    48      -3.004  40.099   1.722  1.00  0.00
ATOM    465  HD2 LYS    48      -1.349  39.578   1.398  1.00  0.00
ATOM    466  CE  LYS    48      -1.588  41.694   1.562  1.00  0.00
ATOM    467  HE1 LYS    48      -0.547  41.862   1.800  1.00  0.00
ATOM    468  HE2 LYS    48      -2.200  42.386   2.122  1.00  0.00
ATOM    469  NZ  LYS    48      -1.795  41.935   0.107  1.00  0.00
ATOM    470  HZ1 LYS    48      -1.136  41.354  -0.450  1.00  0.00
ATOM    471  HZ2 LYS    48      -1.634  42.936  -0.124  1.00  0.00
ATOM    472  HZ3 LYS    48      -2.767  41.683  -0.163  1.00  0.00
ATOM    473  C   LYS    48      -3.585  36.600   3.875  1.00  0.00
ATOM    474  O   LYS    48      -2.753  35.890   4.447  1.00  0.00
END
