
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   64 (  466),  selected   64 , name 2pk7_A
# Molecule2: number of CA atoms   29 (  432),  selected   29 , name T0480.pdb
# PARAMETERS: 2pk7_A.T0480.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     3_A      -       -           -
LGA    K     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    I     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    A    10_A      F      20          2.041
LGA    C    11_A      C      21          0.730
LGA    P    12_A      P      22          0.916
LGA    I    13_A      R      23          3.019
LGA    C    14_A      C      24          2.046
LGA    K    15_A      G      25          1.853
LGA    -       -      P      26           -
LGA    -       -      G      27           -
LGA    G    16_A      V      28          1.503
LGA    P    17_A      F      29          1.174
LGA    L    18_A      L      30          1.646
LGA    K    19_A      A      31          1.597
LGA    L    20_A      E      32          2.147
LGA    S    21_A      H      33          2.795
LGA    A    22_A      -       -           -
LGA    D    23_A      -       -           -
LGA    K    24_A      A      34          1.734
LGA    T    25_A      D      35          1.577
LGA    E    26_A      R      36          0.915
LGA    L    27_A      Y      37          1.307
LGA    I    28_A      S      38          1.093
LGA    S    29_A      C      39          1.253
LGA    K    30_A      G      40          1.148
LGA    G    31_A      R      41          2.101
LGA    A    32_A      C      42          1.879
LGA    G    33_A      G      43          1.029
LGA    L    34_A      Y      44          1.797
LGA    A    35_A      T      45          1.191
LGA    Y    36_A      E      46          1.210
LGA    P    37_A      F      47          1.210
LGA    I    38_A      K      48          1.256
LGA    R    39_A      -       -           -
LGA    D    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    I    42_A      -       -           -
LGA    P    43_A      -       -           -
LGA    V    44_A      -       -           -
LGA    X    45_A      -       -           -
LGA    L    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    S    48_A      -       -           -
LGA    E    49_A      -       -           -
LGA    A    50_A      -       -           -
LGA    R    51_A      -       -           -
LGA    T    52_A      -       -           -
LGA    L    53_A      -       -           -
LGA    T    54_A      -       -           -
LGA    T    55_A      -       -           -
LGA    E    56_A      -       -           -
LGA    E    57_A      -       -           -
LGA    R    58_A      -       -           -
LGA    L    59_A      -       -           -
LGA    D    60_A      -       -           -
LGA    K    61_A      -       -           -
LGA    L    62_A      -       -           -
LGA    E    63_A      -       -           -
LGA    H    64_A      -       -           -
LGA    H    65_A      -       -           -
LGA    H    66_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   64   29    5.0     27    1.65    18.52     85.980     1.539

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.892116 * X  +  -0.435896 * Y  +   0.118845 * Z  +  -9.460140
  Y_new =  -0.036628 * X  +  -0.331954 * Y  +  -0.942584 * Z  +  42.910450
  Z_new =   0.450320 * X  +   0.836541 * Y  +  -0.312108 * Z  +  -0.725319 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.927894   -1.213699  [ DEG:   110.4602    -69.5398 ]
  Theta =  -0.467124   -2.674469  [ DEG:   -26.7642   -153.2358 ]
  Phi   =  -0.041034    3.100558  [ DEG:    -2.3511    177.6489 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pk7_A                                        
REMARK     2: T0480.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pk7_A.T0480.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   64   29   5.0   27   1.65   18.52  85.980
REMARK  ---------------------------------------------------------- 
MOLECULE 2pk7_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   17-APR-07   2PK7              
TITLE     CRYSTAL STRUCTURE OF THE Q4KFT4_PSEF5 PROTEIN FROM                    
TITLE    2 PSEUDOMONAS FLUORESCENS. NESG TARGET PLR1                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PF-5;                                                        
SOURCE   5 ATCC: BAA-477;                                                       
SOURCE   6 GENE: PFL_1779;                                                      
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    NESG, PLR1, PUTATIVE TETRAACYLDISACCHARIDE-1-P 4-KINASE,              
KEYWDS   2 Q4KFT4, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE                
KEYWDS   3 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.M.VOROBIEV,H.NEELY,S.JAYARAMAN,C.X.CHEN,H.JANJUA,R.XIAO,            
AUTHOR   2 T.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL          
AUTHOR   3 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   01-MAY-07 2PK7    0                                                
JRNL        AUTH   S.M.VOROBIEV,H.NEELY,S.JAYARAMAN,C.X.CHEN,H.JANJUA,          
JRNL        AUTH 2 R.XIAO,T.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG                
JRNL        TITL   CRYSTAL STRUCTURE OF THE Q4KFT4_PSEF5 PROTEIN FROM           
JRNL        TITL 2 PSEUDOMONAS FLUORESCENS.                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2PK7 A    1    61  UNP    Q4KFT4   Q4KFT4_PSEF5     1     61             
DBREF  2PK7 B    1    61  UNP    Q4KFT4   Q4KFT4_PSEF5     1     61             
SEQRES   1 A   69  MSE ASP THR LYS LEU LEU ASP ILE LEU ALA CYS PRO ILE          
SEQRES   2 A   69  CYS LYS GLY PRO LEU LYS LEU SER ALA ASP LYS THR GLU          
SEQRES   3 A   69  LEU ILE SER LYS GLY ALA GLY LEU ALA TYR PRO ILE ARG          
SEQRES   4 A   69  ASP GLY ILE PRO VAL MSE LEU GLU SER GLU ALA ARG THR          
SEQRES   5 A   69  LEU THR THR GLU GLU ARG LEU ASP LYS LEU GLU HIS HIS          
SEQRES   6 A   69  HIS HIS HIS HIS                                              
SEQRES   1 B   69  MSE ASP THR LYS LEU LEU ASP ILE LEU ALA CYS PRO ILE          
SEQRES   2 B   69  CYS LYS GLY PRO LEU LYS LEU SER ALA ASP LYS THR GLU          
SEQRES   3 B   69  LEU ILE SER LYS GLY ALA GLY LEU ALA TYR PRO ILE ARG          
SEQRES   4 B   69  ASP GLY ILE PRO VAL MSE LEU GLU SER GLU ALA ARG THR          
SEQRES   5 B   69  LEU THR THR GLU GLU ARG LEU ASP LYS LEU GLU HIS HIS          
SEQRES   6 B   69  HIS HIS HIS HIS                                              
HET    MSE  A  45       8                                                       
HET    MSE  B  45       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *68(H2 O)                                                     
CRYST1   29.415   34.363   35.832  76.39  76.12  73.58 P 1           2          
ATOM      1  N   THR A   3       1.063  52.588 -11.558  1.00 65.69           N  
ATOM      2  CA  THR A   3       1.229  52.925 -10.115  1.00 67.11           C  
ATOM      3  C   THR A   3       0.881  51.711  -9.253  1.00 64.55           C  
ATOM      4  O   THR A   3       0.164  50.817  -9.699  1.00 64.62           O  
ATOM      5  CB  THR A   3       0.338  54.108  -9.756  1.00 68.52           C  
ATOM      6  N   LYS A   4       1.391  51.692  -8.021  1.00 55.45           N  
ATOM      7  CA  LYS A   4       1.174  50.591  -7.080  1.00 49.55           C  
ATOM      8  C   LYS A   4      -0.260  50.062  -7.008  1.00 44.09           C  
ATOM      9  O   LYS A   4      -1.217  50.758  -7.350  1.00 41.78           O  
ATOM     10  CB  LYS A   4       1.654  51.002  -5.685  1.00 48.00           C  
ATOM     11  N   LEU A   5      -0.390  48.821  -6.546  1.00 38.41           N  
ATOM     12  CA  LEU A   5      -1.680  48.141  -6.417  1.00 36.08           C  
ATOM     13  C   LEU A   5      -2.615  48.787  -5.384  1.00 37.03           C  
ATOM     14  O   LEU A   5      -3.817  48.943  -5.632  1.00 38.10           O  
ATOM     15  CB  LEU A   5      -1.426  46.668  -6.065  1.00 31.47           C  
ATOM     16  CG  LEU A   5      -2.583  45.685  -5.898  1.00 26.03           C  
ATOM     17  CD1 LEU A   5      -3.511  45.735  -7.105  1.00 23.62           C  
ATOM     18  CD2 LEU A   5      -2.004  44.283  -5.716  1.00 27.59           C  
ATOM     19  N   LEU A   6      -2.056  49.164  -4.237  1.00 35.00           N  
ATOM     20  CA  LEU A   6      -2.816  49.795  -3.160  1.00 37.38           C  
ATOM     21  C   LEU A   6      -3.519  51.082  -3.580  1.00 42.30           C  
ATOM     22  O   LEU A   6      -4.407  51.554  -2.870  1.00 42.66           O  
ATOM     23  CB  LEU A   6      -1.896  50.113  -1.984  1.00 36.65           C  
ATOM     24  CG  LEU A   6      -1.593  49.052  -0.935  1.00 37.46           C  
ATOM     25  CD1 LEU A   6      -0.817  49.719   0.198  1.00 32.33           C  
ATOM     26  CD2 LEU A   6      -2.885  48.459  -0.401  1.00 33.95           C  
ATOM     27  N   ASP A   7      -3.110  51.663  -4.706  1.00 42.21           N  
ATOM     28  CA  ASP A   7      -3.734  52.897  -5.179  1.00 38.88           C  
ATOM     29  C   ASP A   7      -5.016  52.567  -5.923  1.00 39.05           C  
ATOM     30  O   ASP A   7      -5.902  53.410  -6.066  1.00 43.08           O  
ATOM     31  CB  ASP A   7      -2.826  53.660  -6.162  1.00 40.82           C  
ATOM     32  CG  ASP A   7      -1.473  53.999  -5.589  1.00 43.96           C  
ATOM     33  OD1 ASP A   7      -1.396  54.312  -4.383  1.00 41.73           O  
ATOM     34  OD2 ASP A   7      -0.492  53.975  -6.360  1.00 59.14           O  
ATOM     35  N   ILE A   8      -5.096  51.334  -6.407  1.00 38.45           N  
ATOM     36  CA  ILE A   8      -6.237  50.880  -7.186  1.00 35.94           C  
ATOM     37  C   ILE A   8      -7.283  50.116  -6.396  1.00 33.14           C  
ATOM     38  O   ILE A   8      -8.459  50.099  -6.759  1.00 36.15           O  
ATOM     39  CB  ILE A   8      -5.754  49.990  -8.337  1.00 36.85           C  
ATOM     40  CG1 ILE A   8      -4.908  50.821  -9.293  1.00 40.01           C  
ATOM     41  CG2 ILE A   8      -6.939  49.365  -9.050  1.00 43.87           C  
ATOM     42  CD1 ILE A   8      -3.838  50.011  -9.978  1.00 48.68           C  
ATOM     43  N   LEU A   9      -6.854  49.476  -5.321  1.00 31.04           N  
ATOM     44  CA  LEU A   9      -7.768  48.697  -4.512  1.00 29.49           C  
ATOM     45  C   LEU A   9      -8.541  49.566  -3.521  1.00 31.70           C  
ATOM     46  O   LEU A   9      -8.010  50.536  -3.000  1.00 31.57           O  
ATOM     47  CB  LEU A   9      -6.977  47.597  -3.791  1.00 31.67           C  
ATOM     48  CG  LEU A   9      -6.202  46.634  -4.710  1.00 20.62           C  
ATOM     49  CD1 LEU A   9      -5.620  45.512  -3.882  1.00 28.56           C  
ATOM     50  CD2 LEU A   9      -7.134  46.060  -5.782  1.00 23.69           C  
ATOM     51  N   ALA A  10      -9.801  49.221  -3.278  1.00 32.73           N  
ATOM     52  CA  ALA A  10     -10.630  49.975  -2.346  1.00 32.72           C  
ATOM     53  C   ALA A  10     -11.371  49.028  -1.423  1.00 31.23           C  
ATOM     54  O   ALA A  10     -11.624  47.879  -1.773  1.00 32.19           O  
ATOM     55  CB  ALA A  10     -11.635  50.847  -3.108  1.00 30.24           C  
ATOM     56  N   CYS A  11     -11.708  49.507  -0.233  1.00 30.87           N  
ATOM     57  CA  CYS A  11     -12.439  48.686   0.722  1.00 31.23           C  
ATOM     58  C   CYS A  11     -13.795  48.376   0.090  1.00 36.25           C  
ATOM     59  O   CYS A  11     -14.475  49.273  -0.411  1.00 34.78           O  
ATOM     60  CB  CYS A  11     -12.617  49.451   2.034  1.00 30.06           C  
ATOM     61  SG  CYS A  11     -13.914  48.818   3.118  1.00 24.99           S  
ATOM     62  N   PRO A  12     -14.201  47.098   0.091  1.00 38.62           N  
ATOM     63  CA  PRO A  12     -15.494  46.762  -0.513  1.00 37.18           C  
ATOM     64  C   PRO A  12     -16.697  47.307   0.238  1.00 37.05           C  
ATOM     65  O   PRO A  12     -17.791  47.403  -0.312  1.00 44.84           O  
ATOM     66  CB  PRO A  12     -15.465  45.234  -0.564  1.00 39.15           C  
ATOM     67  CG  PRO A  12     -14.599  44.873   0.602  1.00 37.73           C  
ATOM     68  CD  PRO A  12     -13.494  45.890   0.553  1.00 31.56           C  
ATOM     69  N   ILE A  13     -16.495  47.682   1.492  1.00 40.48           N  
ATOM     70  CA  ILE A  13     -17.601  48.197   2.284  1.00 41.46           C  
ATOM     71  C   ILE A  13     -17.793  49.711   2.141  1.00 43.15           C  
ATOM     72  O   ILE A  13     -18.834  50.175   1.665  1.00 39.29           O  
ATOM     73  CB  ILE A  13     -17.404  47.872   3.788  1.00 42.00           C  
ATOM     74  CG1 ILE A  13     -17.171  46.364   3.987  1.00 42.16           C  
ATOM     75  CG2 ILE A  13     -18.611  48.358   4.584  1.00 37.46           C  
ATOM     76  CD1 ILE A  13     -18.388  45.465   3.778  1.00 34.41           C  
ATOM     77  N   CYS A  14     -16.776  50.471   2.545  1.00 38.21           N  
ATOM     78  CA  CYS A  14     -16.825  51.937   2.523  1.00 36.66           C  
ATOM     79  C   CYS A  14     -16.153  52.603   1.320  1.00 35.44           C  
ATOM     80  O   CYS A  14     -16.287  53.818   1.122  1.00 33.35           O  
ATOM     81  CB  CYS A  14     -16.164  52.471   3.788  1.00 30.61           C  
ATOM     82  SG  CYS A  14     -14.365  52.305   3.739  1.00 27.19           S  
ATOM     83  N   LYS A  15     -15.405  51.815   0.552  1.00 33.09           N  
ATOM     84  CA  LYS A  15     -14.705  52.286  -0.640  1.00 30.26           C  
ATOM     85  C   LYS A  15     -13.536  53.218  -0.333  1.00 32.15           C  
ATOM     86  O   LYS A  15     -13.048  53.934  -1.213  1.00 33.17           O  
ATOM     87  CB  LYS A  15     -15.693  52.969  -1.582  1.00 34.29           C  
ATOM     88  CG  LYS A  15     -16.981  52.160  -1.797  1.00 27.26           C  
ATOM     89  CD  LYS A  15     -16.695  50.723  -2.214  1.00 47.77           C  
ATOM     90  CE  LYS A  15     -15.839  50.663  -3.462  1.00 43.44           C  
ATOM     91  NZ  LYS A  15     -15.730  49.271  -3.973  1.00 48.25           N  
ATOM     92  N   GLY A  16     -13.087  53.198   0.917  1.00 27.35           N  
ATOM     93  CA  GLY A  16     -11.968  54.031   1.311  1.00 24.91           C  
ATOM     94  C   GLY A  16     -10.642  53.337   1.063  1.00 26.42           C  
ATOM     95  O   GLY A  16     -10.609  52.192   0.622  1.00 24.13           O  
ATOM     96  N   PRO A  17      -9.522  54.004   1.346  1.00 28.11           N  
ATOM     97  CA  PRO A  17      -8.193  53.417   1.139  1.00 29.10           C  
ATOM     98  C   PRO A  17      -7.941  52.176   2.000  1.00 29.45           C  
ATOM     99  O   PRO A  17      -8.645  51.933   2.980  1.00 27.02           O  
ATOM    100  CB  PRO A  17      -7.259  54.571   1.491  1.00 34.61           C  
ATOM    101  CG  PRO A  17      -8.032  55.305   2.551  1.00 28.15           C  
ATOM    102  CD  PRO A  17      -9.426  55.329   1.979  1.00 29.69           C  
ATOM    103  N   LEU A  18      -6.945  51.386   1.613  1.00 27.82           N  
ATOM    104  CA  LEU A  18      -6.571  50.187   2.353  1.00 26.25           C  
ATOM    105  C   LEU A  18      -5.074  50.291   2.615  1.00 27.93           C  
ATOM    106  O   LEU A  18      -4.337  50.807   1.777  1.00 28.06           O  
ATOM    107  CB  LEU A  18      -6.859  48.925   1.532  1.00 24.35           C  
ATOM    108  CG  LEU A  18      -8.317  48.590   1.204  1.00 16.59           C  
ATOM    109  CD1 LEU A  18      -8.351  47.515   0.136  1.00 20.77           C  
ATOM    110  CD2 LEU A  18      -9.027  48.138   2.453  1.00 16.07           C  
ATOM    111  N   LYS A  19      -4.631  49.820   3.775  1.00 23.62           N  
ATOM    112  CA  LYS A  19      -3.217  49.866   4.107  1.00 27.78           C  
ATOM    113  C   LYS A  19      -2.744  48.472   4.463  1.00 26.13           C  
ATOM    114  O   LYS A  19      -3.448  47.714   5.123  1.00 24.37           O  
ATOM    115  CB  LYS A  19      -2.952  50.800   5.302  1.00 29.22           C  
ATOM    116  CG  LYS A  19      -3.235  52.270   5.038  1.00 40.10           C  
ATOM    117  CD  LYS A  19      -2.788  53.165   6.202  1.00 40.02           C  
ATOM    118  CE  LYS A  19      -3.639  52.990   7.456  1.00 51.35           C  
ATOM    119  NZ  LYS A  19      -3.450  51.662   8.097  1.00 51.11           N  
ATOM    120  N   LEU A  20      -1.556  48.115   4.009  1.00 30.13           N  
ATOM    121  CA  LEU A  20      -1.021  46.808   4.350  1.00 30.42           C  
ATOM    122  C   LEU A  20      -0.678  46.896   5.837  1.00 32.42           C  
ATOM    123  O   LEU A  20      -0.051  47.859   6.266  1.00 34.02           O  
ATOM    124  CB  LEU A  20       0.220  46.529   3.502  1.00 29.52           C  
ATOM    125  CG  LEU A  20       0.867  45.140   3.516  1.00 29.11           C  
ATOM    126  CD1 LEU A  20      -0.187  44.051   3.376  1.00 23.90           C  
ATOM    127  CD2 LEU A  20       1.878  45.063   2.378  1.00 29.11           C  
ATOM    128  N   SER A  21      -1.112  45.911   6.624  1.00 30.46           N  
ATOM    129  CA  SER A  21      -0.847  45.912   8.058  1.00 27.77           C  
ATOM    130  C   SER A  21       0.645  45.779   8.335  1.00 33.85           C  
ATOM    131  O   SER A  21       1.414  45.417   7.449  1.00 32.75           O  
ATOM    132  CB  SER A  21      -1.577  44.758   8.734  1.00 25.13           C  
ATOM    133  OG  SER A  21      -1.084  43.518   8.256  1.00 27.09           O  
ATOM    134  N   ALA A  22       1.036  46.054   9.577  1.00 34.18           N  
ATOM    135  CA  ALA A  22       2.432  45.971   9.997  1.00 34.87           C  
ATOM    136  C   ALA A  22       3.056  44.599   9.718  1.00 34.46           C  
ATOM    137  O   ALA A  22       4.132  44.521   9.126  1.00 38.13           O  
ATOM    138  CB  ALA A  22       2.547  46.315  11.482  1.00 38.69           C  
ATOM    139  N   ASP A  23       2.394  43.523  10.143  1.00 36.18           N  
ATOM    140  CA  ASP A  23       2.918  42.175   9.908  1.00 32.22           C  
ATOM    141  C   ASP A  23       2.628  41.680   8.486  1.00 28.52           C  
ATOM    142  O   ASP A  23       2.902  40.526   8.151  1.00 31.11           O  
ATOM    143  CB  ASP A  23       2.350  41.178  10.933  1.00 35.01           C  
ATOM    144  CG  ASP A  23       0.839  41.055  10.867  1.00 42.78           C  
ATOM    145  OD1 ASP A  23       0.240  41.533   9.880  1.00 50.57           O  
ATOM    146  OD2 ASP A  23       0.250  40.463  11.801  1.00 51.03           O  
ATOM    147  N   LYS A  24       2.077  42.571   7.661  1.00 29.25           N  
ATOM    148  CA  LYS A  24       1.742  42.297   6.256  1.00 24.55           C  
ATOM    149  C   LYS A  24       0.738  41.179   5.987  1.00 23.71           C  
ATOM    150  O   LYS A  24       0.667  40.661   4.870  1.00 25.16           O  
ATOM    151  CB  LYS A  24       3.006  41.995   5.440  1.00 28.69           C  
ATOM    152  CG  LYS A  24       3.877  43.201   5.119  1.00 38.50           C  
ATOM    153  CD  LYS A  24       4.790  43.570   6.270  1.00 47.43           C  
ATOM    154  CE  LYS A  24       5.724  44.711   5.883  1.00 46.81           C  
ATOM    155  NZ  LYS A  24       4.983  45.916   5.423  1.00 43.27           N  
ATOM    156  N   THR A  25      -0.058  40.814   6.981  1.00 24.46           N  
ATOM    157  CA  THR A  25      -1.016  39.737   6.784  1.00 22.55           C  
ATOM    158  C   THR A  25      -2.447  40.222   6.609  1.00 19.45           C  
ATOM    159  O   THR A  25      -3.378  39.415   6.508  1.00 20.36           O  
ATOM    160  CB  THR A  25      -0.995  38.771   7.965  1.00 27.12           C  
ATOM    161  OG1 THR A  25      -1.551  39.419   9.118  1.00 35.66           O  
ATOM    162  CG2 THR A  25       0.437  38.360   8.271  1.00 27.39           C  
ATOM    163  N   GLU A  26      -2.642  41.533   6.576  1.00 23.48           N  
ATOM    164  CA  GLU A  26      -3.997  42.046   6.434  1.00 18.58           C  
ATOM    165  C   GLU A  26      -4.030  43.344   5.671  1.00 19.93           C  
ATOM    166  O   GLU A  26      -3.039  44.056   5.605  1.00 21.50           O  
ATOM    167  CB  GLU A  26      -4.623  42.313   7.819  1.00 15.86           C  
ATOM    168  CG  GLU A  26      -4.689  41.120   8.746  1.00 24.42           C  
ATOM    169  CD  GLU A  26      -5.135  41.521  10.149  1.00 26.64           C  
ATOM    170  OE1 GLU A  26      -4.464  42.374  10.770  1.00 39.32           O  
ATOM    171  OE2 GLU A  26      -6.158  40.988  10.631  1.00 28.08           O  
ATOM    172  N   LEU A  27      -5.191  43.642   5.100  1.00 19.50           N  
ATOM    173  CA  LEU A  27      -5.412  44.894   4.415  1.00 18.83           C  
ATOM    174  C   LEU A  27      -6.400  45.568   5.346  1.00 20.45           C  
ATOM    175  O   LEU A  27      -7.554  45.156   5.459  1.00 22.79           O  
ATOM    176  CB  LEU A  27      -6.029  44.692   3.030  1.00 16.46           C  
ATOM    177  CG  LEU A  27      -5.134  43.984   2.003  1.00 19.54           C  
ATOM    178  CD1 LEU A  27      -5.883  43.885   0.693  1.00 16.87           C  
ATOM    179  CD2 LEU A  27      -3.842  44.751   1.820  1.00 25.56           C  
ATOM    180  N   ILE A  28      -5.939  46.596   6.039  1.00 24.01           N  
ATOM    181  CA  ILE A  28      -6.813  47.290   6.957  1.00 23.17           C  
ATOM    182  C   ILE A  28      -7.588  48.418   6.296  1.00 23.13           C  
ATOM    183  O   ILE A  28      -7.074  49.168   5.448  1.00 19.01           O  
ATOM    184  CB  ILE A  28      -6.015  47.776   8.216  1.00 32.10           C  
ATOM    185  CG1 ILE A  28      -6.620  49.060   8.793  1.00 29.47           C  
ATOM    186  CG2 ILE A  28      -4.535  47.914   7.869  1.00 37.83           C  
ATOM    187  CD1 ILE A  28      -5.955  49.510  10.085  1.00 33.75           C  
ATOM    188  N   SER A  29      -8.860  48.489   6.669  1.00 19.56           N  
ATOM    189  CA  SER A  29      -9.768  49.501   6.157  1.00 24.52           C  
ATOM    190  C   SER A  29     -10.251  50.338   7.324  1.00 22.22           C  
ATOM    191  O   SER A  29     -11.254  50.018   7.952  1.00 28.50           O  
ATOM    192  CB  SER A  29     -10.974  48.854   5.494  1.00 17.30           C  
ATOM    193  OG  SER A  29     -11.884  49.857   5.081  1.00 24.34           O  
ATOM    194  N   LYS A  30      -9.522  51.405   7.621  1.00 24.17           N  
ATOM    195  CA  LYS A  30      -9.876  52.291   8.724  1.00 26.68           C  
ATOM    196  C   LYS A  30     -11.242  52.920   8.473  1.00 25.77           C  
ATOM    197  O   LYS A  30     -11.998  53.195   9.414  1.00 22.43           O  
ATOM    198  CB  LYS A  30      -8.813  53.378   8.892  1.00 31.28           C  
ATOM    199  N   GLY A  31     -11.559  53.150   7.203  1.00 20.85           N  
ATOM    200  CA  GLY A  31     -12.842  53.745   6.874  1.00 25.60           C  
ATOM    201  C   GLY A  31     -13.997  52.835   7.259  1.00 29.70           C  
ATOM    202  O   GLY A  31     -15.120  53.302   7.467  1.00 29.11           O  
ATOM    203  N   ALA A  32     -13.722  51.538   7.367  1.00 23.65           N  
ATOM    204  CA  ALA A  32     -14.752  50.572   7.733  1.00 25.63           C  
ATOM    205  C   ALA A  32     -14.507  49.934   9.091  1.00 24.24           C  
ATOM    206  O   ALA A  32     -15.369  49.233   9.625  1.00 25.53           O  
ATOM    207  CB  ALA A  32     -14.852  49.487   6.666  1.00 33.15           C  
ATOM    208  N   GLY A  33     -13.330  50.183   9.651  1.00 26.64           N  
ATOM    209  CA  GLY A  33     -13.004  49.623  10.947  1.00 26.58           C  
ATOM    210  C   GLY A  33     -12.803  48.123  10.868  1.00 25.37           C  
ATOM    211  O   GLY A  33     -13.073  47.399  11.825  1.00 24.59           O  
ATOM    212  N   LEU A  34     -12.324  47.653   9.722  1.00 28.49           N  
ATOM    213  CA  LEU A  34     -12.090  46.226   9.518  1.00 25.30           C  
ATOM    214  C   LEU A  34     -10.708  45.932   8.927  1.00 21.55           C  
ATOM    215  O   LEU A  34     -10.103  46.797   8.306  1.00 20.68           O  
ATOM    216  CB  LEU A  34     -13.131  45.662   8.545  1.00 25.46           C  
ATOM    217  CG  LEU A  34     -14.610  45.865   8.867  1.00 24.45           C  
ATOM    218  CD1 LEU A  34     -15.463  45.458   7.666  1.00 21.98           C  
ATOM    219  CD2 LEU A  34     -14.969  45.042  10.085  1.00 23.67           C  
ATOM    220  N   ALA A  35     -10.217  44.708   9.122  1.00 20.04           N  
ATOM    221  CA  ALA A  35      -8.940  44.289   8.547  1.00 20.35           C  
ATOM    222  C   ALA A  35      -9.255  43.029   7.759  1.00 21.61           C  
ATOM    223  O   ALA A  35      -9.775  42.067   8.310  1.00 22.18           O  
ATOM    224  CB  ALA A  35      -7.894  43.982   9.642  1.00 18.86           C  
ATOM    225  N   TYR A  36      -8.963  43.040   6.466  1.00 22.74           N  
ATOM    226  CA  TYR A  36      -9.220  41.871   5.641  1.00 19.41           C  
ATOM    227  C   TYR A  36      -7.960  41.004   5.643  1.00 15.69           C  
ATOM    228  O   TYR A  36      -6.863  41.489   5.366  1.00 14.80           O  
ATOM    229  CB  TYR A  36      -9.572  42.308   4.217  1.00 18.54           C  
ATOM    230  CG  TYR A  36     -10.759  43.240   4.147  1.00 14.61           C  
ATOM    231  CD1 TYR A  36     -12.048  42.785   4.438  1.00 12.80           C  
ATOM    232  CD2 TYR A  36     -10.593  44.584   3.810  1.00 19.42           C  
ATOM    233  CE1 TYR A  36     -13.155  43.658   4.380  1.00 18.79           C  
ATOM    234  CE2 TYR A  36     -11.681  45.464   3.752  1.00 27.48           C  
ATOM    235  CZ  TYR A  36     -12.959  44.994   4.037  1.00 28.39           C  
ATOM    236  OH  TYR A  36     -14.027  45.864   3.967  1.00 30.42           O  
ATOM    237  N   PRO A  37      -8.100  39.705   5.963  1.00 17.94           N  
ATOM    238  CA  PRO A  37      -6.957  38.796   5.997  1.00 15.58           C  
ATOM    239  C   PRO A  37      -6.437  38.417   4.621  1.00 23.82           C  
ATOM    240  O   PRO A  37      -7.177  38.369   3.641  1.00 24.21           O  
ATOM    241  CB  PRO A  37      -7.510  37.584   6.741  1.00 14.07           C  
ATOM    242  CG  PRO A  37      -8.945  37.535   6.224  1.00  8.03           C  
ATOM    243  CD  PRO A  37      -9.343  38.997   6.334  1.00 14.63           C  
ATOM    244  N   ILE A  38      -5.141  38.174   4.555  1.00 23.60           N  
ATOM    245  CA  ILE A  38      -4.515  37.748   3.320  1.00 23.44           C  
ATOM    246  C   ILE A  38      -4.193  36.309   3.640  1.00 28.19           C  
ATOM    247  O   ILE A  38      -3.402  36.022   4.536  1.00 25.55           O  
ATOM    248  CB  ILE A  38      -3.255  38.562   3.038  1.00 24.29           C  
ATOM    249  CG1 ILE A  38      -3.654  40.019   2.791  1.00 17.88           C  
ATOM    250  CG2 ILE A  38      -2.500  37.978   1.851  1.00 22.97           C  
ATOM    251  CD1 ILE A  38      -2.494  40.973   2.642  1.00 18.90           C  
ATOM    252  N   ARG A  39      -4.845  35.402   2.926  1.00 28.26           N  
ATOM    253  CA  ARG A  39      -4.661  33.980   3.166  1.00 32.57           C  
ATOM    254  C   ARG A  39      -4.036  33.238   1.997  1.00 30.47           C  
ATOM    255  O   ARG A  39      -4.641  33.117   0.932  1.00 34.90           O  
ATOM    256  CB  ARG A  39      -6.015  33.373   3.518  1.00 29.75           C  
ATOM    257  CG  ARG A  39      -6.572  33.913   4.828  1.00 19.33           C  
ATOM    258  CD  ARG A  39      -8.029  33.564   5.009  1.00 26.01           C  
ATOM    259  NE  ARG A  39      -8.489  33.908   6.349  1.00 23.18           N  
ATOM    260  CZ  ARG A  39      -9.764  33.916   6.722  1.00 19.39           C  
ATOM    261  NH1 ARG A  39     -10.713  33.599   5.850  1.00 17.02           N  
ATOM    262  NH2 ARG A  39     -10.090  34.262   7.961  1.00 17.98           N  
ATOM    263  N   ASP A  40      -2.828  32.730   2.210  1.00 32.26           N  
ATOM    264  CA  ASP A  40      -2.109  32.000   1.175  1.00 36.54           C  
ATOM    265  C   ASP A  40      -2.103  32.805  -0.123  1.00 33.65           C  
ATOM    266  O   ASP A  40      -2.482  32.316  -1.186  1.00 34.49           O  
ATOM    267  CB  ASP A  40      -2.751  30.628   0.962  1.00 39.52           C  
ATOM    268  CG  ASP A  40      -1.815  29.649   0.287  1.00 47.35           C  
ATOM    269  OD1 ASP A  40      -0.591  29.900   0.285  1.00 49.33           O  
ATOM    270  OD2 ASP A  40      -2.302  28.620  -0.225  1.00 58.70           O  
ATOM    271  N   GLY A  41      -1.679  34.059  -0.008  1.00 28.68           N  
ATOM    272  CA  GLY A  41      -1.596  34.946  -1.155  1.00 30.22           C  
ATOM    273  C   GLY A  41      -2.894  35.522  -1.689  1.00 24.00           C  
ATOM    274  O   GLY A  41      -2.890  36.168  -2.736  1.00 29.91           O  
ATOM    275  N   ILE A  42      -4.003  35.317  -0.987  1.00 24.54           N  
ATOM    276  CA  ILE A  42      -5.282  35.854  -1.450  1.00 23.40           C  
ATOM    277  C   ILE A  42      -5.887  36.802  -0.420  1.00 21.71           C  
ATOM    278  O   ILE A  42      -6.069  36.429   0.735  1.00 24.28           O  
ATOM    279  CB  ILE A  42      -6.296  34.716  -1.732  1.00 26.57           C  
ATOM    280  CG1 ILE A  42      -5.716  33.729  -2.752  1.00 23.38           C  
ATOM    281  CG2 ILE A  42      -7.604  35.300  -2.254  1.00 27.91           C  
ATOM    282  CD1 ILE A  42      -5.438  34.341  -4.103  1.00 27.84           C  
ATOM    283  N   PRO A  43      -6.188  38.052  -0.818  1.00 21.41           N  
ATOM    284  CA  PRO A  43      -6.783  38.986   0.140  1.00 21.65           C  
ATOM    285  C   PRO A  43      -8.282  38.695   0.220  1.00 25.92           C  
ATOM    286  O   PRO A  43      -9.029  39.042  -0.691  1.00 24.21           O  
ATOM    287  CB  PRO A  43      -6.477  40.351  -0.478  1.00 15.20           C  
ATOM    288  CG  PRO A  43      -6.553  40.066  -1.948  1.00 28.18           C  
ATOM    289  CD  PRO A  43      -5.852  38.728  -2.084  1.00 18.28           C  
ATOM    290  N   VAL A  44      -8.727  38.044   1.294  1.00 23.63           N  
ATOM    291  CA  VAL A  44     -10.146  37.721   1.435  1.00 22.09           C  
ATOM    292  C   VAL A  44     -10.870  38.932   1.989  1.00 25.41           C  
ATOM    293  O   VAL A  44     -10.932  39.160   3.201  1.00 22.79           O  
ATOM    294  CB  VAL A  44     -10.365  36.503   2.354  1.00 22.15           C  
ATOM    295  CG1 VAL A  44     -11.856  36.172   2.427  1.00 17.61           C  
ATOM    296  CG2 VAL A  44      -9.591  35.305   1.815  1.00 15.11           C  
HETATM  297  N   MSE A  45     -11.436  39.705   1.076  1.00 25.48           N  
HETATM  298  CA  MSE A  45     -12.117  40.920   1.460  1.00 27.54           C  
HETATM  299  C   MSE A  45     -13.635  40.895   1.570  1.00 24.96           C  
HETATM  300  O   MSE A  45     -14.374  41.504   0.788  1.00 24.99           O  
HETATM  301  CB  MSE A  45     -11.640  42.019   0.539  1.00 31.41           C  
HETATM  302  CG  MSE A  45     -10.152  42.238   0.739  1.00 26.83           C  
HETATM  303 SE   MSE A  45      -9.482  43.428  -0.530  1.00 65.11          SE  
HETATM  304  CE  MSE A  45     -10.116  45.015   0.329  1.00 43.67           C  
ATOM    305  N   LEU A  46     -14.083  40.178   2.585  1.00 22.46           N  
ATOM    306  CA  LEU A  46     -15.495  40.053   2.897  1.00 26.27           C  
ATOM    307  C   LEU A  46     -15.587  40.423   4.375  1.00 22.36           C  
ATOM    308  O   LEU A  46     -14.714  40.063   5.166  1.00 24.06           O  
ATOM    309  CB  LEU A  46     -15.960  38.613   2.680  1.00 27.49           C  
ATOM    310  CG  LEU A  46     -15.946  38.022   1.263  1.00 28.73           C  
ATOM    311  CD1 LEU A  46     -15.917  36.499   1.353  1.00 29.49           C  
ATOM    312  CD2 LEU A  46     -17.167  38.486   0.471  1.00 32.01           C  
ATOM    313  N   GLU A  47     -16.632  41.151   4.745  1.00 26.85           N  
ATOM    314  CA  GLU A  47     -16.804  41.562   6.130  1.00 30.25           C  
ATOM    315  C   GLU A  47     -16.911  40.333   7.021  1.00 28.63           C  
ATOM    316  O   GLU A  47     -16.381  40.302   8.134  1.00 31.28           O  
ATOM    317  CB  GLU A  47     -18.060  42.418   6.267  1.00 30.00           C  
ATOM    318  CG  GLU A  47     -18.226  43.048   7.635  1.00 35.46           C  
ATOM    319  CD  GLU A  47     -19.411  43.982   7.685  1.00 47.52           C  
ATOM    320  OE1 GLU A  47     -20.370  43.751   6.917  1.00 40.81           O  
ATOM    321  OE2 GLU A  47     -19.393  44.937   8.491  1.00 52.47           O  
ATOM    322  N   SER A  48     -17.596  39.317   6.516  1.00 31.06           N  
ATOM    323  CA  SER A  48     -17.777  38.082   7.261  1.00 32.71           C  
ATOM    324  C   SER A  48     -16.453  37.393   7.598  1.00 30.68           C  
ATOM    325  O   SER A  48     -16.410  36.559   8.502  1.00 31.86           O  
ATOM    326  CB  SER A  48     -18.656  37.121   6.456  1.00 35.70           C  
ATOM    327  OG  SER A  48     -18.072  36.888   5.188  1.00 36.29           O  
ATOM    328  N   GLU A  49     -15.383  37.731   6.883  1.00 30.83           N  
ATOM    329  CA  GLU A  49     -14.082  37.102   7.124  1.00 25.65           C  
ATOM    330  C   GLU A  49     -13.053  38.008   7.770  1.00 25.21           C  
ATOM    331  O   GLU A  49     -11.944  37.559   8.101  1.00 25.98           O  
ATOM    332  CB  GLU A  49     -13.486  36.592   5.803  1.00 24.71           C  
ATOM    333  CG  GLU A  49     -14.297  35.522   5.091  1.00 19.86           C  
ATOM    334  CD  GLU A  49     -14.436  34.247   5.889  1.00 22.72           C  
ATOM    335  OE1 GLU A  49     -13.413  33.738   6.401  1.00 26.58           O  
ATOM    336  OE2 GLU A  49     -15.575  33.741   5.996  1.00 40.50           O  
ATOM    337  N   ALA A  50     -13.424  39.272   7.938  1.00 24.70           N  
ATOM    338  CA  ALA A  50     -12.548  40.290   8.498  1.00 21.83           C  
ATOM    339  C   ALA A  50     -12.481  40.371  10.018  1.00 24.45           C  
ATOM    340  O   ALA A  50     -13.345  39.863  10.731  1.00 28.98           O  
ATOM    341  CB  ALA A  50     -12.956  41.655   7.955  1.00 17.66           C  
ATOM    342  N   ARG A  51     -11.430  41.033  10.493  1.00 21.58           N  
ATOM    343  CA  ARG A  51     -11.218  41.249  11.911  1.00 18.88           C  
ATOM    344  C   ARG A  51     -11.596  42.708  12.138  1.00 19.74           C  
ATOM    345  O   ARG A  51     -11.196  43.582  11.373  1.00 24.78           O  
ATOM    346  CB  ARG A  51      -9.744  41.048  12.279  1.00 14.32           C  
ATOM    347  CG  ARG A  51      -9.408  41.489  13.698  1.00 18.96           C  
ATOM    348  CD  ARG A  51      -7.954  41.195  14.021  1.00 30.01           C  
ATOM    349  NE  ARG A  51      -7.030  42.000  13.224  1.00 32.32           N  
ATOM    350  CZ  ARG A  51      -6.853  43.307  13.392  1.00 36.50           C  
ATOM    351  NH1 ARG A  51      -7.541  43.949  14.330  1.00 25.55           N  
ATOM    352  NH2 ARG A  51      -5.974  43.965  12.642  1.00 21.33           N  
ATOM    353  N   THR A  52     -12.388  42.980  13.164  1.00 25.51           N  
ATOM    354  CA  THR A  52     -12.765  44.360  13.432  1.00 27.03           C  
ATOM    355  C   THR A  52     -11.581  44.989  14.165  1.00 25.79           C  
ATOM    356  O   THR A  52     -10.988  44.370  15.055  1.00 28.61           O  
ATOM    357  CB  THR A  52     -14.087  44.447  14.258  1.00 28.10           C  
ATOM    358  OG1 THR A  52     -13.806  44.650  15.648  1.00 39.07           O  
ATOM    359  CG2 THR A  52     -14.895  43.161  14.082  1.00 20.24           C  
ATOM    360  N   LEU A  53     -11.225  46.203  13.751  1.00 24.72           N  
ATOM    361  CA  LEU A  53     -10.097  46.932  14.324  1.00 24.86           C  
ATOM    362  C   LEU A  53     -10.309  47.224  15.802  1.00 28.00           C  
ATOM    363  O   LEU A  53     -11.433  47.472  16.245  1.00 26.74           O  
ATOM    364  CB  LEU A  53      -9.878  48.237  13.553  1.00 20.92           C  
ATOM    365  CG  LEU A  53      -9.647  48.085  12.043  1.00 20.34           C  
ATOM    366  CD1 LEU A  53      -9.427  49.466  11.420  1.00 18.07           C  
ATOM    367  CD2 LEU A  53      -8.444  47.184  11.790  1.00 14.43           C  
ATOM    368  N   THR A  54      -9.228  47.175  16.573  1.00 27.92           N  
ATOM    369  CA  THR A  54      -9.332  47.449  17.999  1.00 26.55           C  
ATOM    370  C   THR A  54      -9.527  48.929  18.242  1.00 29.07           C  
ATOM    371  O   THR A  54      -9.481  49.747  17.317  1.00 24.67           O  
ATOM    372  CB  THR A  54      -8.076  47.011  18.786  1.00 24.01           C  
ATOM    373  OG1 THR A  54      -6.920  47.681  18.268  1.00 26.16           O  
ATOM    374  CG2 THR A  54      -7.893  45.503  18.698  1.00 26.69           C  
ATOM    375  N   THR A  55      -9.749  49.271  19.502  1.00 29.99           N  
ATOM    376  CA  THR A  55      -9.945  50.656  19.874  1.00 28.90           C  
ATOM    377  C   THR A  55      -8.701  51.449  19.519  1.00 25.32           C  
ATOM    378  O   THR A  55      -8.786  52.536  18.939  1.00 24.85           O  
ATOM    379  CB  THR A  55     -10.214  50.776  21.378  1.00 25.91           C  
ATOM    380  OG1 THR A  55     -11.374  50.005  21.701  1.00 31.04           O  
ATOM    381  CG2 THR A  55     -10.442  52.223  21.771  1.00 24.25           C  
ATOM    382  N   GLU A  56      -7.542  50.891  19.855  1.00 27.07           N  
ATOM    383  CA  GLU A  56      -6.273  51.555  19.589  1.00 26.49           C  
ATOM    384  C   GLU A  56      -6.005  51.739  18.096  1.00 31.62           C  
ATOM    385  O   GLU A  56      -5.479  52.770  17.680  1.00 36.46           O  
ATOM    386  CB  GLU A  56      -5.131  50.785  20.252  1.00 29.29           C  
ATOM    387  N   GLU A  57      -6.369  50.754  17.282  1.00 37.00           N  
ATOM    388  CA  GLU A  57      -6.146  50.879  15.844  1.00 32.70           C  
ATOM    389  C   GLU A  57      -7.029  51.966  15.221  1.00 31.43           C  
ATOM    390  O   GLU A  57      -6.609  52.659  14.295  1.00 28.80           O  
ATOM    391  CB  GLU A  57      -6.422  49.544  15.140  1.00 31.15           C  
ATOM    392  CG  GLU A  57      -5.542  48.399  15.606  1.00 30.38           C  
ATOM    393  CD  GLU A  57      -5.844  47.104  14.880  1.00 25.95           C  
ATOM    394  OE1 GLU A  57      -5.116  46.762  13.920  1.00 28.69           O  
ATOM    395  OE2 GLU A  57      -6.825  46.433  15.268  1.00 34.61           O  
ATOM    396  N   ARG A  58      -8.243  52.118  15.745  1.00 24.89           N  
ATOM    397  CA  ARG A  58      -9.210  53.088  15.223  1.00 26.99           C  
ATOM    398  C   ARG A  58      -8.945  54.539  15.602  1.00 29.80           C  
ATOM    399  O   ARG A  58      -9.450  55.466  14.959  1.00 28.10           O  
ATOM    400  CB  ARG A  58     -10.610  52.658  15.649  1.00 27.85           C  
ATOM    401  CG  ARG A  58     -10.903  51.250  15.174  1.00 21.13           C  
ATOM    402  CD  ARG A  58     -12.027  50.585  15.935  1.00 32.32           C  
ATOM    403  NE  ARG A  58     -13.322  51.093  15.515  1.00 39.65           N  
ATOM    404  CZ  ARG A  58     -14.356  50.315  15.225  1.00 28.33           C  
ATOM    405  NH1 ARG A  58     -14.241  48.995  15.314  1.00 28.22           N  
ATOM    406  NH2 ARG A  58     -15.492  50.852  14.822  1.00 23.29           N  
ATOM    407  N   LEU A  59      -8.147  54.733  16.643  1.00 33.08           N  
ATOM    408  CA  LEU A  59      -7.786  56.069  17.083  1.00 33.83           C  
ATOM    409  C   LEU A  59      -6.812  56.631  16.065  1.00 37.94           C  
ATOM    410  O   LEU A  59      -6.229  55.876  15.286  1.00 37.68           O  
ATOM    411  CB  LEU A  59      -7.107  56.007  18.451  1.00 33.60           C  
ATOM    412  CG  LEU A  59      -8.035  55.648  19.607  1.00 39.88           C  
ATOM    413  CD1 LEU A  59      -7.240  55.457  20.887  1.00 30.65           C  
ATOM    414  CD2 LEU A  59      -9.052  56.763  19.758  1.00 48.09           C  
ATOM    415  N   ASP A  60      -6.644  57.949  16.073  1.00 43.28           N  
ATOM    416  CA  ASP A  60      -5.729  58.618  15.161  1.00 46.08           C  
ATOM    417  C   ASP A  60      -4.307  58.425  15.646  1.00 49.32           C  
ATOM    418  O   ASP A  60      -4.035  58.544  16.837  1.00 52.37           O  
ATOM    419  CB  ASP A  60      -6.033  60.118  15.088  1.00 47.07           C  
ATOM    420  CG  ASP A  60      -6.840  60.495  13.867  1.00 49.90           C  
ATOM    421  OD1 ASP A  60      -6.459  60.081  12.753  1.00 56.59           O  
ATOM    422  OD2 ASP A  60      -7.842  61.223  14.023  1.00 52.59           O  
ATOM    423  N   LYS A  61      -3.404  58.120  14.721  1.00 52.14           N  
ATOM    424  CA  LYS A  61      -1.998  57.923  15.064  1.00 55.50           C  
ATOM    425  C   LYS A  61      -1.385  59.215  15.622  1.00 58.97           C  
ATOM    426  O   LYS A  61      -1.281  60.218  14.912  1.00 60.09           O  
ATOM    427  CB  LYS A  61      -1.223  57.464  13.834  1.00 54.93           C  
ATOM    428  N   LEU A  62      -0.972  59.178  16.887  1.00 60.73           N  
ATOM    429  CA  LEU A  62      -0.371  60.338  17.544  1.00 64.41           C  
ATOM    430  C   LEU A  62       1.152  60.366  17.365  1.00 67.78           C  
ATOM    431  O   LEU A  62       1.853  59.568  17.982  1.00 71.45           O  
ATOM    432  CB  LEU A  62      -0.720  60.313  19.028  1.00 62.85           C  
ATOM    433  N   GLU A  63       1.641  61.276  16.530  1.00 70.92           N  
ATOM    434  CA  GLU A  63       3.074  61.420  16.307  1.00 72.21           C  
ATOM    435  C   GLU A  63       3.764  62.024  17.525  1.00 71.68           C  
ATOM    436  O   GLU A  63       4.516  61.345  18.225  1.00 70.32           O  
ATOM    437  CB  GLU A  63       3.341  62.282  15.071  1.00 66.88           C  
ATOM    438  CG  GLU A  63       4.711  62.065  14.447  1.00 73.13           C  
ATOM    439  CD  GLU A  63       5.200  63.278  13.681  1.00 69.53           C  
ATOM    440  OE1 GLU A  63       5.346  64.355  14.297  1.00 48.18           O  
ATOM    441  OE2 GLU A  63       5.439  63.156  12.461  1.00 66.87           O  
ATOM    442  N   HIS A  64       3.503  63.303  17.774  1.00 72.67           N  
ATOM    443  CA  HIS A  64       4.158  64.022  18.860  1.00 66.28           C  
ATOM    444  C   HIS A  64       3.389  63.863  20.168  1.00 65.71           C  
ATOM    445  O   HIS A  64       2.352  63.200  20.214  1.00 72.18           O  
ATOM    446  CB  HIS A  64       4.301  65.505  18.512  1.00 66.90           C  
ATOM    447  CG  HIS A  64       3.428  65.947  17.380  1.00 59.66           C  
ATOM    448  ND1 HIS A  64       2.069  65.719  17.355  1.00 50.27           N  
ATOM    449  CD2 HIS A  64       3.720  66.604  16.233  1.00 59.04           C  
ATOM    450  CE1 HIS A  64       1.561  66.216  16.241  1.00 53.96           C  
ATOM    451  NE2 HIS A  64       2.541  66.760  15.543  1.00 49.38           N  
ATOM    452  N   HIS A  65       3.905  64.473  21.230  1.00 59.82           N  
ATOM    453  CA  HIS A  65       3.814  63.896  22.565  1.00 57.16           C  
ATOM    454  C   HIS A  65       2.369  63.843  23.047  1.00 58.94           C  
ATOM    455  O   HIS A  65       1.935  62.849  23.630  1.00 57.45           O  
ATOM    456  CB  HIS A  65       4.668  64.694  23.553  1.00 50.59           C  
ATOM    457  CG  HIS A  65       6.142  64.497  23.376  1.00 39.74           C  
ATOM    458  ND1 HIS A  65       7.071  64.986  24.268  1.00 37.26           N  
ATOM    459  CD2 HIS A  65       6.846  63.862  22.409  1.00 40.53           C  
ATOM    460  CE1 HIS A  65       8.284  64.662  23.859  1.00 37.94           C  
ATOM    461  NE2 HIS A  65       8.176  63.980  22.733  1.00 39.33           N  
ATOM    462  N   HIS A  66       1.626  64.917  22.797  1.00 64.30           N  
ATOM    463  CA  HIS A  66       0.282  65.062  23.343  1.00 62.77           C  
ATOM    464  C   HIS A  66      -0.755  65.167  22.231  1.00 63.60           C  
ATOM    465  O   HIS A  66      -1.365  66.219  22.034  1.00 65.12           O  
ATOM    466  CB  HIS A  66       0.210  66.277  24.255  1.00 59.45           C  
TER     467      HIS A  66                                                      
END
MOLECULE T0480.pdb
ATOM     43  N   PHE    20      -9.421  47.124  -2.332  1.00  0.00
ATOM     44  HN  PHE    20      -9.663  47.024  -3.278  1.00  0.00
ATOM     45  CA  PHE    20     -10.050  48.188  -1.549  1.00  0.00
ATOM     46  HA  PHE    20      -9.287  48.642  -0.932  1.00  0.00
ATOM     47  CB  PHE    20     -10.641  49.260  -2.478  1.00  0.00
ATOM     48  HB1 PHE    20     -11.197  49.974  -1.885  1.00  0.00
ATOM     49  HB2 PHE    20     -11.316  48.788  -3.178  1.00  0.00
ATOM     50  CG  PHE    20      -9.613  50.019  -3.274  1.00  0.00
ATOM     51  CD1 PHE    20      -9.119  49.504  -4.460  1.00  0.00
ATOM     52  HD1 PHE    20      -9.476  48.547  -4.813  1.00  0.00
ATOM     53  CD2 PHE    20      -9.145  51.251  -2.836  1.00  0.00
ATOM     54  HD2 PHE    20      -9.523  51.664  -1.912  1.00  0.00
ATOM     55  CE1 PHE    20      -8.180  50.199  -5.195  1.00  0.00
ATOM     56  HE1 PHE    20      -7.803  49.783  -6.119  1.00  0.00
ATOM     57  CE2 PHE    20      -8.206  51.949  -3.568  1.00  0.00
ATOM     58  HE2 PHE    20      -7.850  52.908  -3.217  1.00  0.00
ATOM     59  CZ  PHE    20      -7.722  51.422  -4.750  1.00  0.00
ATOM     60  HZ  PHE    20      -6.988  51.966  -5.326  1.00  0.00
ATOM     61  C   PHE    20     -11.149  47.641  -0.643  1.00  0.00
ATOM     62  O   PHE    20     -11.503  46.465  -0.706  1.00  0.00
ATOM     63  N   CYS    21     -11.685  48.510   0.204  1.00  0.00
ATOM     64  HN  CYS    21     -11.329  49.425   0.240  1.00  0.00
ATOM     65  CA  CYS    21     -12.801  48.155   1.067  1.00  0.00
ATOM     66  HA  CYS    21     -12.726  47.105   1.318  1.00  0.00
ATOM     67  HB1 CYS    21     -12.914  50.028   2.087  1.00  0.00
ATOM     68  HB2 CYS    21     -11.760  48.898   2.773  1.00  0.00
ATOM     69  C   CYS    21     -14.100  48.414   0.312  1.00  0.00
ATOM     70  O   CYS    21     -14.384  49.557  -0.023  1.00  0.00
ATOM     71  CB  CYS    21     -12.742  48.991   2.341  1.00  0.00
ATOM     72  SG  CYS    21     -13.954  48.528   3.619  1.00  0.00
ATOM     73  N   PRO    22     -14.916  47.367   0.073  1.00  0.00
ATOM     74  CA  PRO    22     -16.026  47.404  -0.893  1.00  0.00
ATOM     75  HA  PRO    22     -15.680  47.160  -1.889  1.00  0.00
ATOM     76  CB  PRO    22     -16.958  46.298  -0.401  1.00  0.00
ATOM     77  HB1 PRO    22     -17.462  45.846  -1.245  1.00  0.00
ATOM     78  HB2 PRO    22     -17.694  46.716   0.276  1.00  0.00
ATOM     79  CG  PRO    22     -16.074  45.316   0.294  1.00  0.00
ATOM     80  HG1 PRO    22     -15.795  44.526  -0.389  1.00  0.00
ATOM     81  HG2 PRO    22     -16.602  44.907   1.141  1.00  0.00
ATOM     82  CD  PRO    22     -14.843  46.065   0.763  1.00  0.00
ATOM     83  HD1 PRO    22     -13.945  45.532   0.486  1.00  0.00
ATOM     84  HD2 PRO    22     -14.875  46.204   1.835  1.00  0.00
ATOM     85  C   PRO    22     -16.770  48.741  -0.939  1.00  0.00
ATOM     86  O   PRO    22     -16.834  49.390  -1.988  1.00  0.00
ATOM     87  N   ARG    23     -17.316  49.158   0.201  1.00  0.00
ATOM     88  HN  ARG    23     -17.154  48.653   1.025  1.00  0.00
ATOM     89  CA  ARG    23     -18.164  50.344   0.238  1.00  0.00
ATOM     90  HA  ARG    23     -18.672  50.391  -0.712  1.00  0.00
ATOM     91  CB  ARG    23     -19.223  50.223   1.341  1.00  0.00
ATOM     92  HB1 ARG    23     -19.804  51.135   1.369  1.00  0.00
ATOM     93  HB2 ARG    23     -18.724  50.096   2.291  1.00  0.00
ATOM     94  CG  ARG    23     -20.180  49.050   1.141  1.00  0.00
ATOM     95  HG1 ARG    23     -19.642  48.129   1.321  1.00  0.00
ATOM     96  HG2 ARG    23     -20.538  49.061   0.121  1.00  0.00
ATOM     97  CD  ARG    23     -21.381  49.113   2.081  1.00  0.00
ATOM     98  HD1 ARG    23     -21.999  48.242   1.910  1.00  0.00
ATOM     99  HD2 ARG    23     -21.951  50.003   1.854  1.00  0.00
ATOM    100  NE  ARG    23     -20.991  49.150   3.495  1.00  0.00
ATOM    101  HE  ARG    23     -20.100  49.512   3.706  1.00  0.00
ATOM    102  CZ  ARG    23     -21.777  48.752   4.498  1.00  0.00
ATOM    103  NH1 ARG    23     -22.967  48.220   4.250  1.00  0.00
ATOM    104 HH11 ARG    23     -23.285  48.110   3.303  1.00  0.00
ATOM    105 HH12 ARG    23     -23.556  47.929   5.009  1.00  0.00
ATOM    106  NH2 ARG    23     -21.364  48.866   5.751  1.00  0.00
ATOM    107 HH21 ARG    23     -20.460  49.252   5.953  1.00  0.00
ATOM    108 HH22 ARG    23     -21.954  48.569   6.504  1.00  0.00
ATOM    109  C   ARG    23     -17.352  51.633   0.415  1.00  0.00
ATOM    110  O   ARG    23     -17.758  52.692  -0.062  1.00  0.00
ATOM    111  N   CYS    24     -16.206  51.549   1.092  1.00  0.00
ATOM    112  HN  CYS    24     -15.914  50.681   1.429  1.00  0.00
ATOM    113  CA  CYS    24     -15.370  52.739   1.328  1.00  0.00
ATOM    114  HA  CYS    24     -16.018  53.602   1.381  1.00  0.00
ATOM    115  HB1 CYS    24     -14.192  53.616   2.885  1.00  0.00
ATOM    116  HB2 CYS    24     -13.735  51.970   2.480  1.00  0.00
ATOM    117  C   CYS    24     -14.366  52.941   0.194  1.00  0.00
ATOM    118  O   CYS    24     -13.660  53.947   0.171  1.00  0.00
ATOM    119  CB  CYS    24     -14.572  52.634   2.635  1.00  0.00
ATOM    120  SG  CYS    24     -15.473  52.014   4.084  1.00  0.00
ATOM    121  N   GLY    25     -14.311  51.975  -0.727  1.00  0.00
ATOM    122  HN  GLY    25     -15.009  51.286  -0.729  1.00  0.00
ATOM    123  CA  GLY    25     -13.256  51.919  -1.735  1.00  0.00
ATOM    124  HA1 GLY    25     -13.576  51.268  -2.533  1.00  0.00
ATOM    125  HA2 GLY    25     -12.373  51.493  -1.282  1.00  0.00
ATOM    126  C   GLY    25     -12.895  53.274  -2.316  1.00  0.00
ATOM    127  O   GLY    25     -11.779  53.757  -2.106  1.00  0.00
ATOM    128  N   PRO    26     -13.818  53.919  -3.049  1.00  0.00
ATOM    129  CA  PRO    26     -13.599  55.269  -3.570  1.00  0.00
ATOM    130  HA  PRO    26     -12.703  55.315  -4.175  1.00  0.00
ATOM    131  CB  PRO    26     -14.836  55.536  -4.453  1.00  0.00
ATOM    132  HB1 PRO    26     -14.526  55.974  -5.391  1.00  0.00
ATOM    133  HB2 PRO    26     -15.511  56.212  -3.944  1.00  0.00
ATOM    134  CG  PRO    26     -15.466  54.197  -4.662  1.00  0.00
ATOM    135  HG1 PRO    26     -15.052  53.729  -5.546  1.00  0.00
ATOM    136  HG2 PRO    26     -16.537  54.305  -4.764  1.00  0.00
ATOM    137  CD  PRO    26     -15.135  53.389  -3.440  1.00  0.00
ATOM    138  HD1 PRO    26     -15.075  52.339  -3.684  1.00  0.00
ATOM    139  HD2 PRO    26     -15.868  53.560  -2.664  1.00  0.00
ATOM    140  C   PRO    26     -13.496  56.293  -2.437  1.00  0.00
ATOM    141  O   PRO    26     -14.508  56.823  -1.967  1.00  0.00
ATOM    142  N   GLY    27     -12.275  56.524  -1.966  1.00  0.00
ATOM    143  HN  GLY    27     -11.520  56.002  -2.319  1.00  0.00
ATOM    144  CA  GLY    27     -12.036  57.519  -0.932  1.00  0.00
ATOM    145  HA1 GLY    27     -12.982  57.935  -0.612  1.00  0.00
ATOM    146  HA2 GLY    27     -11.430  58.310  -1.348  1.00  0.00
ATOM    147  C   GLY    27     -11.325  56.943   0.273  1.00  0.00
ATOM    148  O   GLY    27     -10.653  57.668   1.009  1.00  0.00
ATOM    149  N   VAL    28     -11.468  55.634   0.479  1.00  0.00
ATOM    150  HN  VAL    28     -12.031  55.114  -0.136  1.00  0.00
ATOM    151  CA  VAL    28     -10.810  54.948   1.591  1.00  0.00
ATOM    152  HA  VAL    28     -10.018  55.586   1.960  1.00  0.00
ATOM    153  CB  VAL    28     -11.782  54.646   2.763  1.00  0.00
ATOM    154  HB  VAL    28     -12.477  53.886   2.424  1.00  0.00
ATOM    155  CG1 VAL    28     -11.028  54.082   3.968  1.00  0.00
ATOM    156 HG11 VAL    28     -10.300  54.803   4.309  1.00  0.00
ATOM    157 HG12 VAL    28     -10.525  53.168   3.687  1.00  0.00
ATOM    158 HG13 VAL    28     -11.728  53.875   4.766  1.00  0.00
ATOM    159  CG2 VAL    28     -12.588  55.883   3.159  1.00  0.00
ATOM    160 HG21 VAL    28     -11.917  56.666   3.482  1.00  0.00
ATOM    161 HG22 VAL    28     -13.260  55.632   3.967  1.00  0.00
ATOM    162 HG23 VAL    28     -13.162  56.229   2.311  1.00  0.00
ATOM    163  C   VAL    28     -10.205  53.631   1.123  1.00  0.00
ATOM    164  O   VAL    28     -10.910  52.621   0.993  1.00  0.00
ATOM    165  N   PHE    29      -8.907  53.645   0.861  1.00  0.00
ATOM    166  HN  PHE    29      -8.420  54.495   0.903  1.00  0.00
ATOM    167  CA  PHE    29      -8.190  52.430   0.504  1.00  0.00
ATOM    168  HA  PHE    29      -8.697  51.979  -0.339  1.00  0.00
ATOM    169  CB  PHE    29      -6.738  52.749   0.109  1.00  0.00
ATOM    170  HB1 PHE    29      -6.738  53.555  -0.613  1.00  0.00
ATOM    171  HB2 PHE    29      -6.296  51.872  -0.342  1.00  0.00
ATOM    172  CG  PHE    29      -5.864  53.166   1.270  1.00  0.00
ATOM    173  CD1 PHE    29      -4.909  52.298   1.788  1.00  0.00
ATOM    174  HD1 PHE    29      -4.786  51.319   1.348  1.00  0.00
ATOM    175  CD2 PHE    29      -6.003  54.418   1.850  1.00  0.00
ATOM    176  HD2 PHE    29      -6.739  55.104   1.458  1.00  0.00
ATOM    177  CE1 PHE    29      -4.116  52.673   2.857  1.00  0.00
ATOM    178  HE1 PHE    29      -3.377  51.988   3.249  1.00  0.00
ATOM    179  CE2 PHE    29      -5.211  54.796   2.917  1.00  0.00
ATOM    180  HE2 PHE    29      -5.331  55.775   3.358  1.00  0.00
ATOM    181  CZ  PHE    29      -4.268  53.924   3.421  1.00  0.00
ATOM    182  HZ  PHE    29      -3.650  54.219   4.258  1.00  0.00
ATOM    183  C   PHE    29      -8.210  51.449   1.679  1.00  0.00
ATOM    184  O   PHE    29      -8.458  51.838   2.825  1.00  0.00
ATOM    185  N   LEU    30      -7.958  50.182   1.396  1.00  0.00
ATOM    186  HN  LEU    30      -7.805  49.919   0.464  1.00  0.00
ATOM    187  CA  LEU    30      -7.868  49.176   2.441  1.00  0.00
ATOM    188  HA  LEU    30      -8.446  49.515   3.292  1.00  0.00
ATOM    189  CB  LEU    30      -8.437  47.841   1.939  1.00  0.00
ATOM    190  HB1 LEU    30      -7.762  47.449   1.190  1.00  0.00
ATOM    191  HB2 LEU    30      -9.389  48.040   1.467  1.00  0.00
ATOM    192  CG  LEU    30      -8.649  46.756   3.010  1.00  0.00
ATOM    193  HG  LEU    30      -7.705  46.559   3.499  1.00  0.00
ATOM    194  CD1 LEU    30      -9.637  47.226   4.075  1.00  0.00
ATOM    195 HD11 LEU    30     -10.591  47.443   3.615  1.00  0.00
ATOM    196 HD12 LEU    30      -9.257  48.119   4.550  1.00  0.00
ATOM    197 HD13 LEU    30      -9.765  46.452   4.819  1.00  0.00
ATOM    198  CD2 LEU    30      -9.129  45.452   2.368  1.00  0.00
ATOM    199 HD21 LEU    30     -10.068  45.622   1.859  1.00  0.00
ATOM    200 HD22 LEU    30      -9.268  44.701   3.133  1.00  0.00
ATOM    201 HD23 LEU    30      -8.392  45.106   1.657  1.00  0.00
ATOM    202  C   LEU    30      -6.405  49.037   2.850  1.00  0.00
ATOM    203  O   LEU    30      -5.581  48.585   2.055  1.00  0.00
ATOM    204  N   ALA    31      -6.089  49.469   4.074  1.00  0.00
ATOM    205  HN  ALA    31      -6.808  49.759   4.671  1.00  0.00
ATOM    206  CA  ALA    31      -4.708  49.517   4.560  1.00  0.00
ATOM    207  HA  ALA    31      -4.182  50.263   3.979  1.00  0.00
ATOM    208  CB  ALA    31      -4.674  49.953   6.023  1.00  0.00
ATOM    209  HB1 ALA    31      -3.648  50.043   6.352  1.00  0.00
ATOM    210  HB2 ALA    31      -5.182  49.219   6.631  1.00  0.00
ATOM    211  HB3 ALA    31      -5.167  50.908   6.126  1.00  0.00
ATOM    212  C   ALA    31      -4.007  48.174   4.380  1.00  0.00
ATOM    213  O   ALA    31      -4.101  47.290   5.237  1.00  0.00
ATOM    214  N   GLU    32      -3.331  48.023   3.246  1.00  0.00
ATOM    215  HN  GLU    32      -3.321  48.760   2.599  1.00  0.00
ATOM    216  CA  GLU    32      -2.625  46.794   2.922  1.00  0.00
ATOM    217  HA  GLU    32      -3.248  45.965   3.234  1.00  0.00
ATOM    218  CB  GLU    32      -2.386  46.686   1.408  1.00  0.00
ATOM    219  HB1 GLU    32      -1.814  47.543   1.083  1.00  0.00
ATOM    220  HB2 GLU    32      -3.342  46.691   0.903  1.00  0.00
ATOM    221  CG  GLU    32      -1.632  45.422   0.999  1.00  0.00
ATOM    222  HG1 GLU    32      -2.172  44.560   1.369  1.00  0.00
ATOM    223  HG2 GLU    32      -0.650  45.445   1.449  1.00  0.00
ATOM    224  CD  GLU    32      -1.467  45.287  -0.506  1.00  0.00
ATOM    225  OE1 GLU    32      -0.618  46.002  -1.079  1.00  0.00
ATOM    226  OE2 GLU    32      -2.171  44.448  -1.114  1.00  0.00
ATOM    227  C   GLU    32      -1.300  46.719   3.673  1.00  0.00
ATOM    228  O   GLU    32      -0.357  47.459   3.381  1.00  0.00
ATOM    229  N   HIS    33      -1.263  45.852   4.668  1.00  0.00
ATOM    230  HN  HIS    33      -2.089  45.388   4.911  1.00  0.00
ATOM    231  CA  HIS    33      -0.045  45.545   5.406  1.00  0.00
ATOM    232  HA  HIS    33       0.685  46.317   5.196  1.00  0.00
ATOM    233  CB  HIS    33      -0.317  45.503   6.914  1.00  0.00
ATOM    234  HB1 HIS    33       0.590  45.218   7.429  1.00  0.00
ATOM    235  HB2 HIS    33      -1.084  44.767   7.119  1.00  0.00
ATOM    236  CG  HIS    33      -0.772  46.815   7.476  1.00  0.00
ATOM    237  ND1 HIS    33       0.097  47.768   7.958  1.00  0.00
ATOM    238  HD1 HIS    33       1.077  47.689   7.991  1.00  0.00
ATOM    239  CD2 HIS    33      -2.014  47.330   7.633  1.00  0.00
ATOM    240  HD2 HIS    33      -2.944  46.851   7.362  1.00  0.00
ATOM    241  CE1 HIS    33      -0.589  48.809   8.385  1.00  0.00
ATOM    242  HE1 HIS    33      -0.169  49.705   8.818  1.00  0.00
ATOM    243  NE2 HIS    33      -1.873  48.572   8.199  1.00  0.00
ATOM    244  HE2 HIS    33      -2.599  49.075   8.631  1.00  0.00
ATOM    245  C   HIS    33       0.506  44.203   4.940  1.00  0.00
ATOM    246  O   HIS    33      -0.225  43.393   4.365  1.00  0.00
ATOM    247  N   ALA    34       1.782  43.964   5.214  1.00  0.00
ATOM    248  HN  ALA    34       2.282  44.621   5.746  1.00  0.00
ATOM    249  CA  ALA    34       2.468  42.759   4.751  1.00  0.00
ATOM    250  HA  ALA    34       2.479  42.779   3.670  1.00  0.00
ATOM    251  CB  ALA    34       3.914  42.763   5.235  1.00  0.00
ATOM    252  HB1 ALA    34       4.434  41.909   4.826  1.00  0.00
ATOM    253  HB2 ALA    34       3.936  42.714   6.315  1.00  0.00
ATOM    254  HB3 ALA    34       4.401  43.670   4.907  1.00  0.00
ATOM    255  C   ALA    34       1.761  41.481   5.206  1.00  0.00
ATOM    256  O   ALA    34       1.850  40.444   4.543  1.00  0.00
ATOM    257  N   ASP    35       1.049  41.561   6.329  1.00  0.00
ATOM    258  HN  ASP    35       0.954  42.428   6.773  1.00  0.00
ATOM    259  CA  ASP    35       0.416  40.383   6.923  1.00  0.00
ATOM    260  HA  ASP    35       0.770  39.510   6.392  1.00  0.00
ATOM    261  CB  ASP    35       0.816  40.251   8.399  1.00  0.00
ATOM    262  HB1 ASP    35       1.883  40.394   8.487  1.00  0.00
ATOM    263  HB2 ASP    35       0.565  39.258   8.747  1.00  0.00
ATOM    264  CG  ASP    35       0.122  41.266   9.293  1.00  0.00
ATOM    265  OD1 ASP    35       0.449  42.468   9.202  1.00  0.00
ATOM    266  OD2 ASP    35      -0.746  40.867  10.097  1.00  0.00
ATOM    267  C   ASP    35      -1.111  40.429   6.812  1.00  0.00
ATOM    268  O   ASP    35      -1.773  39.400   6.966  1.00  0.00
ATOM    269  N   ARG    36      -1.682  41.598   6.521  1.00  0.00
ATOM    270  HN  ARG    36      -1.122  42.366   6.270  1.00  0.00
ATOM    271  CA  ARG    36      -3.142  41.736   6.533  1.00  0.00
ATOM    272  HA  ARG    36      -3.550  40.949   5.917  1.00  0.00
ATOM    273  CB  ARG    36      -3.678  41.570   7.966  1.00  0.00
ATOM    274  HB1 ARG    36      -3.315  40.633   8.368  1.00  0.00
ATOM    275  HB2 ARG    36      -4.759  41.538   7.933  1.00  0.00
ATOM    276  CG  ARG    36      -3.264  42.690   8.914  1.00  0.00
ATOM    277  HG1 ARG    36      -3.731  43.611   8.594  1.00  0.00
ATOM    278  HG2 ARG    36      -2.190  42.797   8.873  1.00  0.00
ATOM    279  CD  ARG    36      -3.677  42.398  10.353  1.00  0.00
ATOM    280  HD1 ARG    36      -3.114  41.546  10.712  1.00  0.00
ATOM    281  HD2 ARG    36      -4.732  42.162  10.370  1.00  0.00
ATOM    282  NE  ARG    36      -3.436  43.539  11.239  1.00  0.00
ATOM    283  HE  ARG    36      -4.165  44.194  11.330  1.00  0.00
ATOM    284  CZ  ARG    36      -2.321  43.724  11.948  1.00  0.00
ATOM    285  NH1 ARG    36      -1.289  42.903  11.808  1.00  0.00
ATOM    286 HH11 ARG    36      -1.337  42.131  11.163  1.00  0.00
ATOM    287 HH12 ARG    36      -0.455  43.046  12.347  1.00  0.00
ATOM    288  NH2 ARG    36      -2.225  44.752  12.777  1.00  0.00
ATOM    289 HH21 ARG    36      -2.992  45.396  12.878  1.00  0.00
ATOM    290 HH22 ARG    36      -1.390  44.887  13.317  1.00  0.00
ATOM    291  C   ARG    36      -3.592  43.080   5.962  1.00  0.00
ATOM    292  O   ARG    36      -2.805  43.816   5.384  1.00  0.00
ATOM    293  N   TYR    37      -4.876  43.366   6.135  1.00  0.00
ATOM    294  HN  TYR    37      -5.429  42.719   6.609  1.00  0.00
ATOM    295  CA  TYR    37      -5.508  44.603   5.686  1.00  0.00
ATOM    296  HA  TYR    37      -4.743  45.306   5.387  1.00  0.00
ATOM    297  CB  TYR    37      -6.477  44.347   4.519  1.00  0.00
ATOM    298  HB1 TYR    37      -6.833  45.302   4.155  1.00  0.00
ATOM    299  HB2 TYR    37      -7.322  43.784   4.887  1.00  0.00
ATOM    300  CG  TYR    37      -5.912  43.586   3.333  1.00  0.00
ATOM    301  CD1 TYR    37      -5.992  42.198   3.273  1.00  0.00
ATOM    302  HD1 TYR    37      -6.438  41.661   4.097  1.00  0.00
ATOM    303  CD2 TYR    37      -5.335  44.256   2.258  1.00  0.00
ATOM    304  HD2 TYR    37      -5.265  45.334   2.286  1.00  0.00
ATOM    305  CE1 TYR    37      -5.512  41.502   2.183  1.00  0.00
ATOM    306  HE1 TYR    37      -5.586  40.425   2.155  1.00  0.00
ATOM    307  CE2 TYR    37      -4.849  43.564   1.166  1.00  0.00
ATOM    308  HE2 TYR    37      -4.402  44.101   0.342  1.00  0.00
ATOM    309  CZ  TYR    37      -4.942  42.190   1.133  1.00  0.00
ATOM    310  OH  TYR    37      -4.459  41.497   0.046  1.00  0.00
ATOM    311  HH  TYR    37      -5.120  40.864  -0.251  1.00  0.00
ATOM    312  C   TYR    37      -6.322  45.182   6.841  1.00  0.00
ATOM    313  O   TYR    37      -6.679  44.453   7.767  1.00  0.00
ATOM    314  N   SER    38      -6.636  46.471   6.777  1.00  0.00
ATOM    315  HN  SER    38      -6.247  47.026   6.068  1.00  0.00
ATOM    316  CA  SER    38      -7.535  47.084   7.751  1.00  0.00
ATOM    317  HA  SER    38      -8.327  46.375   7.956  1.00  0.00
ATOM    318  CB  SER    38      -6.797  47.393   9.060  1.00  0.00
ATOM    319  HB1 SER    38      -6.130  48.229   8.911  1.00  0.00
ATOM    320  HB2 SER    38      -6.225  46.527   9.362  1.00  0.00
ATOM    321  OG  SER    38      -7.714  47.715  10.094  1.00  0.00
ATOM    322  HG  SER    38      -8.082  46.897  10.459  1.00  0.00
ATOM    323  C   SER    38      -8.166  48.351   7.170  1.00  0.00
ATOM    324  O   SER    38      -7.687  48.894   6.172  1.00  0.00
ATOM    325  N   CYS    39      -9.256  48.806   7.780  1.00  0.00
ATOM    326  HN  CYS    39      -9.589  48.331   8.573  1.00  0.00
ATOM    327  CA  CYS    39      -9.980  49.978   7.296  1.00  0.00
ATOM    328  HA  CYS    39      -9.347  50.504   6.596  1.00  0.00
ATOM    329  HB1 CYS    39     -11.825  48.903   7.229  1.00  0.00
ATOM    330  HB2 CYS    39     -10.986  48.989   5.693  1.00  0.00
ATOM    331  C   CYS    39     -10.341  50.922   8.431  1.00  0.00
ATOM    332  O   CYS    39     -11.402  50.776   9.049  1.00  0.00
ATOM    333  CB  CYS    39     -11.253  49.545   6.574  1.00  0.00
ATOM    334  SG  CYS    39     -12.344  50.914   6.050  1.00  0.00
ATOM    335  N   GLY    40      -9.454  51.877   8.706  1.00  0.00
ATOM    336  HN  GLY    40      -8.584  51.868   8.253  1.00  0.00
ATOM    337  CA  GLY    40      -9.742  52.916   9.678  1.00  0.00
ATOM    338  HA1 GLY    40      -8.854  53.512   9.830  1.00  0.00
ATOM    339  HA2 GLY    40     -10.020  52.456  10.616  1.00  0.00
ATOM    340  C   GLY    40     -10.870  53.818   9.213  1.00  0.00
ATOM    341  O   GLY    40     -10.634  54.923   8.718  1.00  0.00
ATOM    342  N   ARG    41     -12.095  53.327   9.360  1.00  0.00
ATOM    343  HN  ARG    41     -12.200  52.466   9.822  1.00  0.00
ATOM    344  CA  ARG    41     -13.289  54.031   8.907  1.00  0.00
ATOM    345  HA  ARG    41     -13.318  54.990   9.406  1.00  0.00
ATOM    346  CB  ARG    41     -13.252  54.250   7.384  1.00  0.00
ATOM    347  HB1 ARG    41     -13.317  53.288   6.892  1.00  0.00
ATOM    348  HB2 ARG    41     -12.308  54.710   7.123  1.00  0.00
ATOM    349  CG  ARG    41     -14.378  55.137   6.858  1.00  0.00
ATOM    350  HG1 ARG    41     -15.326  54.721   7.169  1.00  0.00
ATOM    351  HG2 ARG    41     -14.332  55.156   5.778  1.00  0.00
ATOM    352  CD  ARG    41     -14.270  56.568   7.379  1.00  0.00
ATOM    353  HD1 ARG    41     -13.379  57.024   6.966  1.00  0.00
ATOM    354  HD2 ARG    41     -14.193  56.542   8.456  1.00  0.00
ATOM    355  NE  ARG    41     -15.434  57.375   7.008  1.00  0.00
ATOM    356  HE  ARG    41     -16.316  57.040   7.290  1.00  0.00
ATOM    357  CZ  ARG    41     -15.372  58.529   6.339  1.00  0.00
ATOM    358  NH1 ARG    41     -14.206  59.004   5.921  1.00  0.00
ATOM    359 HH11 ARG    41     -13.359  58.498   6.105  1.00  0.00
ATOM    360 HH12 ARG    41     -14.164  59.872   5.417  1.00  0.00
ATOM    361  NH2 ARG    41     -16.485  59.200   6.077  1.00  0.00
ATOM    362 HH21 ARG    41     -17.372  58.843   6.382  1.00  0.00
ATOM    363 HH22 ARG    41     -16.447  60.068   5.571  1.00  0.00
ATOM    364  C   ARG    41     -14.536  53.232   9.294  1.00  0.00
ATOM    365  O   ARG    41     -15.460  53.767   9.905  1.00  0.00
ATOM    366  N   CYS    42     -14.550  51.941   8.946  1.00  0.00
ATOM    367  HN  CYS    42     -13.788  51.572   8.462  1.00  0.00
ATOM    368  CA  CYS    42     -15.680  51.066   9.290  1.00  0.00
ATOM    369  HA  CYS    42     -16.324  51.612   9.967  1.00  0.00
ATOM    370  HB1 CYS    42     -16.667  51.558   7.443  1.00  0.00
ATOM    371  HB2 CYS    42     -17.452  50.281   8.357  1.00  0.00
ATOM    372  C   CYS    42     -15.190  49.810  10.010  1.00  0.00
ATOM    373  O   CYS    42     -15.972  48.902  10.291  1.00  0.00
ATOM    374  CB  CYS    42     -16.497  50.676   8.042  1.00  0.00
ATOM    375  SG  CYS    42     -15.721  49.422   6.967  1.00  0.00
ATOM    376  N   GLY    43     -13.886  49.755  10.293  1.00  0.00
ATOM    377  HN  GLY    43     -13.292  50.472   9.984  1.00  0.00
ATOM    378  CA  GLY    43     -13.333  48.655  11.068  1.00  0.00
ATOM    379  HA1 GLY    43     -13.985  48.453  11.906  1.00  0.00
ATOM    380  HA2 GLY    43     -12.365  48.951  11.446  1.00  0.00
ATOM    381  C   GLY    43     -13.167  47.383  10.264  1.00  0.00
ATOM    382  O   GLY    43     -12.919  46.319  10.828  1.00  0.00
ATOM    383  N   TYR    44     -13.292  47.490   8.943  1.00  0.00
ATOM    384  HN  TYR    44     -13.474  48.365   8.552  1.00  0.00
ATOM    385  CA  TYR    44     -13.151  46.329   8.071  1.00  0.00
ATOM    386  HA  TYR    44     -13.761  45.533   8.480  1.00  0.00
ATOM    387  CB  TYR    44     -13.634  46.650   6.644  1.00  0.00
ATOM    388  HB1 TYR    44     -12.949  47.348   6.181  1.00  0.00
ATOM    389  HB2 TYR    44     -14.613  47.103   6.698  1.00  0.00
ATOM    390  CG  TYR    44     -13.736  45.430   5.742  1.00  0.00
ATOM    391  CD1 TYR    44     -14.898  44.664   5.711  1.00  0.00
ATOM    392  HD1 TYR    44     -15.731  44.949   6.336  1.00  0.00
ATOM    393  CD2 TYR    44     -12.675  45.043   4.926  1.00  0.00
ATOM    394  HD2 TYR    44     -11.765  45.625   4.936  1.00  0.00
ATOM    395  CE1 TYR    44     -14.999  43.553   4.896  1.00  0.00
ATOM    396  HE1 TYR    44     -15.910  42.972   4.888  1.00  0.00
ATOM    397  CE2 TYR    44     -12.772  43.932   4.110  1.00  0.00
ATOM    398  HE2 TYR    44     -11.937  43.647   3.485  1.00  0.00
ATOM    399  CZ  TYR    44     -13.935  43.191   4.098  1.00  0.00
ATOM    400  OH  TYR    44     -14.035  42.084   3.285  1.00  0.00
ATOM    401  HH  TYR    44     -13.267  41.512   3.421  1.00  0.00
ATOM    402  C   TYR    44     -11.692  45.874   8.052  1.00  0.00
ATOM    403  O   TYR    44     -10.820  46.586   7.541  1.00  0.00
ATOM    404  N   THR    45     -11.440  44.710   8.635  1.00  0.00
ATOM    405  HN  THR    45     -12.181  44.224   9.056  1.00  0.00
ATOM    406  CA  THR    45     -10.111  44.123   8.690  1.00  0.00
ATOM    407  HA  THR    45      -9.436  44.742   8.108  1.00  0.00
ATOM    408  CB  THR    45      -9.598  44.072  10.151  1.00  0.00
ATOM    409  HB  THR    45     -10.307  43.509  10.743  1.00  0.00
ATOM    410  OG1 THR    45      -9.513  45.405  10.682  1.00  0.00
ATOM    411  HG1 THR    45     -10.178  45.513  11.373  1.00  0.00
ATOM    412  CG2 THR    45      -8.233  43.392  10.251  1.00  0.00
ATOM    413 HG21 THR    45      -7.903  43.395  11.280  1.00  0.00
ATOM    414 HG22 THR    45      -7.517  43.926   9.643  1.00  0.00
ATOM    415 HG23 THR    45      -8.311  42.372   9.903  1.00  0.00
ATOM    416  C   THR    45     -10.144  42.717   8.091  1.00  0.00
ATOM    417  O   THR    45     -11.064  41.940   8.359  1.00  0.00
ATOM    418  N   GLU    46      -9.150  42.411   7.270  1.00  0.00
ATOM    419  HN  GLU    46      -8.432  43.068   7.132  1.00  0.00
ATOM    420  CA  GLU    46      -9.061  41.127   6.581  1.00  0.00
ATOM    421  HA  GLU    46      -9.638  40.397   7.131  1.00  0.00
ATOM    422  CB  GLU    46      -9.617  41.256   5.152  1.00  0.00
ATOM    423  HB1 GLU    46      -9.027  41.987   4.614  1.00  0.00
ATOM    424  HB2 GLU    46     -10.638  41.607   5.206  1.00  0.00
ATOM    425  CG  GLU    46      -9.603  39.953   4.359  1.00  0.00
ATOM    426  HG1 GLU    46      -8.586  39.589   4.310  1.00  0.00
ATOM    427  HG2 GLU    46      -9.958  40.150   3.356  1.00  0.00
ATOM    428  CD  GLU    46     -10.477  38.876   4.981  1.00  0.00
ATOM    429  OE1 GLU    46      -9.978  38.115   5.835  1.00  0.00
ATOM    430  OE2 GLU    46     -11.665  38.779   4.610  1.00  0.00
ATOM    431  C   GLU    46      -7.603  40.695   6.546  1.00  0.00
ATOM    432  O   GLU    46      -6.725  41.538   6.470  1.00  0.00
ATOM    433  N   PHE    47      -7.333  39.399   6.601  1.00  0.00
ATOM    434  HN  PHE    47      -8.072  38.749   6.586  1.00  0.00
ATOM    435  CA  PHE    47      -5.950  38.917   6.656  1.00  0.00
ATOM    436  HA  PHE    47      -5.338  39.722   7.041  1.00  0.00
ATOM    437  CB  PHE    47      -5.833  37.719   7.606  1.00  0.00
ATOM    438  HB1 PHE    47      -4.848  37.284   7.507  1.00  0.00
ATOM    439  HB2 PHE    47      -6.574  36.980   7.337  1.00  0.00
ATOM    440  CG  PHE    47      -6.037  38.084   9.055  1.00  0.00
ATOM    441  CD1 PHE    47      -7.275  37.931   9.663  1.00  0.00
ATOM    442  HD1 PHE    47      -8.103  37.536   9.090  1.00  0.00
ATOM    443  CD2 PHE    47      -4.984  38.591   9.806  1.00  0.00
ATOM    444  HD2 PHE    47      -4.014  38.715   9.342  1.00  0.00
ATOM    445  CE1 PHE    47      -7.457  38.275  10.989  1.00  0.00
ATOM    446  HE1 PHE    47      -8.426  38.151  11.451  1.00  0.00
ATOM    447  CE2 PHE    47      -5.163  38.934  11.133  1.00  0.00
ATOM    448  HE2 PHE    47      -4.336  39.325  11.707  1.00  0.00
ATOM    449  CZ  PHE    47      -6.400  38.776  11.724  1.00  0.00
ATOM    450  HZ  PHE    47      -6.542  39.045  12.761  1.00  0.00
ATOM    451  C   PHE    47      -5.431  38.540   5.273  1.00  0.00
ATOM    452  O   PHE    47      -6.207  38.197   4.380  1.00  0.00
ATOM    453  N   LYS    48      -4.109  38.631   5.098  1.00  0.00
ATOM    454  HN  LYS    48      -3.558  39.035   5.806  1.00  0.00
ATOM    455  CA  LYS    48      -3.461  38.123   3.891  1.00  0.00
ATOM    456  HA  LYS    48      -3.984  38.527   3.032  1.00  0.00
ATOM    457  CB  LYS    48      -1.979  38.548   3.833  1.00  0.00
ATOM    458  HB1 LYS    48      -1.467  37.928   3.110  1.00  0.00
ATOM    459  HB2 LYS    48      -1.536  38.381   4.805  1.00  0.00
ATOM    460  CG  LYS    48      -1.748  40.015   3.454  1.00  0.00
ATOM    461  HG1 LYS    48      -0.734  40.287   3.714  1.00  0.00
ATOM    462  HG2 LYS    48      -2.437  40.634   4.012  1.00  0.00
ATOM    463  CD  LYS    48      -1.962  40.267   1.960  1.00  0.00
ATOM    464  HD1 LYS    48      -3.004  40.099   1.722  1.00  0.00
ATOM    465  HD2 LYS    48      -1.349  39.578   1.398  1.00  0.00
ATOM    466  CE  LYS    48      -1.588  41.694   1.562  1.00  0.00
ATOM    467  HE1 LYS    48      -0.547  41.862   1.800  1.00  0.00
ATOM    468  HE2 LYS    48      -2.200  42.386   2.122  1.00  0.00
ATOM    469  NZ  LYS    48      -1.795  41.935   0.107  1.00  0.00
ATOM    470  HZ1 LYS    48      -1.136  41.354  -0.450  1.00  0.00
ATOM    471  HZ2 LYS    48      -1.634  42.936  -0.124  1.00  0.00
ATOM    472  HZ3 LYS    48      -2.767  41.683  -0.163  1.00  0.00
ATOM    473  C   LYS    48      -3.585  36.600   3.875  1.00  0.00
ATOM    474  O   LYS    48      -2.753  35.890   4.447  1.00  0.00
END
