
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   58 (  870),  selected   58 , name 1dl6_A
# Molecule2: number of CA atoms   29 (  432),  selected   29 , name T0480.pdb
# PARAMETERS: 1dl6_A.T0480.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    T     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    R     6_A      -       -           -
LGA    L     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    L    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    R    12_A      -       -           -
LGA    V    13_A      -       -           -
LGA    T    14_A      F      20          1.588
LGA    C    15_A      C      21          1.229
LGA    P    16_A      P      22          1.172
LGA    N    17_A      R      23          1.419
LGA    H    18_A      C      24          0.360
LGA    P    19_A      G      25          2.514
LGA    -       -      P      26           -
LGA    D    20_A      G      27          0.667
LGA    A    21_A      V      28          0.499
LGA    I    22_A      F      29          0.732
LGA    L    23_A      L      30          0.522
LGA    V    24_A      A      31          0.736
LGA    E    25_A      E      32          1.452
LGA    D    26_A      H      33          1.503
LGA    Y    27_A      A      34          2.663
LGA    R    28_A      D      35          3.147
LGA    A    29_A      -       -           -
LGA    G    30_A      -       -           -
LGA    D    31_A      R      36          0.714
LGA    M    32_A      Y      37          0.519
LGA    I    33_A      S      38          0.578
LGA    C    34_A      C      39          1.016
LGA    P    35_A      G      40          1.889
LGA    E    36_A      R      41          1.090
LGA    C    37_A      C      42          0.883
LGA    G    38_A      G      43          1.402
LGA    L    39_A      Y      44          1.291
LGA    V    40_A      T      45          1.210
LGA    V    41_A      E      46          1.514
LGA    G    42_A      F      47          2.251
LGA    D    43_A      K      48          5.063
LGA    R    44_A      -       -           -
LGA    V    45_A      -       -           -
LGA    I    46_A      -       -           -
LGA    D    47_A      -       -           -
LGA    V    48_A      -       -           -
LGA    G    49_A      -       -           -
LGA    S    50_A      -       -           -
LGA    E    51_A      -       -           -
LGA    W    52_A      -       -           -
LGA    R    53_A      -       -           -
LGA    T    54_A      -       -           -
LGA    F    55_A      -       -           -
LGA    S    56_A      -       -           -
LGA    N    57_A      -       -           -
LGA    D    58_A      -       -           -
LGA    K    59_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   58   29    5.0     28    1.72    25.00     89.927     1.537

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.293726 * X  +   0.432290 * Y  +   0.852555 * Z  +  -3.530141
  Y_new =  -0.470330 * X  +  -0.841823 * Y  +   0.264808 * Z  +  39.185207
  Z_new =   0.832174 * X  +  -0.323202 * Y  +   0.450584 * Z  +  -0.593895 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.622239    2.519353  [ DEG:   -35.6517    144.3483 ]
  Theta =  -0.983018   -2.158575  [ DEG:   -56.3228   -123.6772 ]
  Phi   =  -2.129043    1.012550  [ DEG:  -121.9852     58.0148 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1dl6_A                                        
REMARK     2: T0480.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1dl6_A.T0480.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   58   29   5.0   28   1.72   25.00  89.927
REMARK  ---------------------------------------------------------- 
MOLECULE 1dl6_A
HEADER    GENE REGULATION                         08-DEC-99   1DL6              
TITLE     SOLUTION STRUCTURE OF HUMAN TFIIB N-TERMINAL DOMAIN                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTION FACTOR II B (TFIIB);                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN;                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET21B                                    
KEYWDS    ZINC RIBBON                                                           
EXPDTA    NMR, 25 STRUCTURES                                                    
AUTHOR    H.-T.CHEN,P.LEGAULT,J.GLUSHKA,J.G.OMICHINSKI,R.A.SCOTT                
REVDAT   2   01-APR-03 1DL6    1       JRNL                                     
REVDAT   1   18-OCT-00 1DL6    0                                                
JRNL        AUTH   H.T.CHEN,P.LEGAULT,J.GLUSHKA,J.G.OMICHINSKI,                 
JRNL        AUTH 2 R.A.SCOTT                                                    
JRNL        TITL   STRUCTURE OF A (CYS3HIS) ZINC RIBBON, A UBIQUITOUS           
JRNL        TITL 2 MOTIF IN ARCHAEAL AND EUCARYAL TRANSCRIPTION.                
JRNL        REF    PROTEIN SCI.                  V.   9  1743 2000              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1DL6 A    2    59  UNP    Q00403   TF2B_HUMAN       2     59             
SEQRES   1 A   58  ALA SER THR SER ARG LEU ASP ALA LEU PRO ARG VAL THR          
SEQRES   2 A   58  CYS PRO ASN HIS PRO ASP ALA ILE LEU VAL GLU ASP TYR          
SEQRES   3 A   58  ARG ALA GLY ASP MET ILE CYS PRO GLU CYS GLY LEU VAL          
SEQRES   4 A   58  VAL GLY ASP ARG VAL ILE ASP VAL GLY SER GLU TRP ARG          
SEQRES   5 A   58  THR PHE SER ASN ASP LYS                                      
HET     ZN  A  60       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   2   ZN    ZN 2+                                                        
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   2     -16.692  32.185 -18.652  1.00  0.00           N  
ATOM      2  CA  ALA A   2     -15.889  30.945 -18.491  1.00  0.00           C  
ATOM      3  C   ALA A   2     -16.308  30.180 -17.240  1.00  0.00           C  
ATOM      4  O   ALA A   2     -15.968  30.566 -16.122  1.00  0.00           O  
ATOM      5  CB  ALA A   2     -14.406  31.281 -18.432  1.00  0.00           C  
ATOM      6  HA  ALA A   2     -16.056  30.317 -19.354  1.00  0.00           H  
ATOM      7  HB1 ALA A   2     -14.034  31.448 -19.432  1.00  0.00           H  
ATOM      8  HB2 ALA A   2     -13.868  30.460 -17.980  1.00  0.00           H  
ATOM      9  HB3 ALA A   2     -14.263  32.174 -17.841  1.00  0.00           H  
ATOM     10  H1  ALA A   2     -17.668  31.969 -18.370  1.00  0.00           H  
ATOM     11  H2  ALA A   2     -16.643  32.465 -19.653  1.00  0.00           H  
ATOM     12  H3  ALA A   2     -16.277  32.913 -18.037  1.00  0.00           H  
ATOM     13  N   SER A   3     -17.048  29.094 -17.437  1.00  0.00           N  
ATOM     14  CA  SER A   3     -17.514  28.274 -16.324  1.00  0.00           C  
ATOM     15  C   SER A   3     -16.347  27.567 -15.642  1.00  0.00           C  
ATOM     16  O   SER A   3     -16.383  27.306 -14.440  1.00  0.00           O  
ATOM     17  CB  SER A   3     -18.534  27.245 -16.814  1.00  0.00           C  
ATOM     18  OG  SER A   3     -19.627  27.876 -17.457  1.00  0.00           O  
ATOM     19  H   SER A   3     -17.287  28.837 -18.352  1.00  0.00           H  
ATOM     20  HA  SER A   3     -17.990  28.927 -15.609  1.00  0.00           H  
ATOM     21  HB2 SER A   3     -18.058  26.575 -17.515  1.00  0.00           H  
ATOM     22  HB3 SER A   3     -18.905  26.680 -15.971  1.00  0.00           H  
ATOM     23  HG  SER A   3     -19.313  28.347 -18.233  1.00  0.00           H  
ATOM     24  N   THR A   4     -15.313  27.259 -16.419  1.00  0.00           N  
ATOM     25  CA  THR A   4     -14.135  26.581 -15.890  1.00  0.00           C  
ATOM     26  C   THR A   4     -13.486  27.402 -14.780  1.00  0.00           C  
ATOM     27  O   THR A   4     -12.896  26.851 -13.851  1.00  0.00           O  
ATOM     28  CB  THR A   4     -13.123  26.326 -17.009  1.00  0.00           C  
ATOM     29  OG1 THR A   4     -12.781  27.536 -17.662  1.00  0.00           O  
ATOM     30  CG2 THR A   4     -13.627  25.362 -18.062  1.00  0.00           C  
ATOM     31  H   THR A   4     -15.342  27.493 -17.370  1.00  0.00           H  
ATOM     32  HA  THR A   4     -14.453  25.634 -15.481  1.00  0.00           H  
ATOM     33  HB  THR A   4     -12.225  25.906 -16.579  1.00  0.00           H  
ATOM     34  HG1 THR A   4     -13.539  27.859 -18.153  1.00  0.00           H  
ATOM     35 HG21 THR A   4     -13.019  25.451 -18.951  1.00  0.00           H  
ATOM     36 HG22 THR A   4     -14.652  25.596 -18.302  1.00  0.00           H  
ATOM     37 HG23 THR A   4     -13.566  24.352 -17.684  1.00  0.00           H  
ATOM     38  N   SER A   5     -13.598  28.723 -14.884  1.00  0.00           N  
ATOM     39  CA  SER A   5     -13.023  29.619 -13.889  1.00  0.00           C  
ATOM     40  C   SER A   5     -14.039  29.944 -12.798  1.00  0.00           C  
ATOM     41  O   SER A   5     -15.041  30.613 -13.049  1.00  0.00           O  
ATOM     42  CB  SER A   5     -12.539  30.909 -14.553  1.00  0.00           C  
ATOM     43  OG  SER A   5     -11.504  31.516 -13.798  1.00  0.00           O  
ATOM     44  H   SER A   5     -14.080  29.102 -15.649  1.00  0.00           H  
ATOM     45  HA  SER A   5     -12.179  29.118 -13.440  1.00  0.00           H  
ATOM     46  HB2 SER A   5     -12.164  30.685 -15.540  1.00  0.00           H  
ATOM     47  HB3 SER A   5     -13.364  31.602 -14.631  1.00  0.00           H  
ATOM     48  HG  SER A   5     -11.877  32.197 -13.234  1.00  0.00           H  
ATOM     49  N   ARG A   6     -13.771  29.469 -11.587  1.00  0.00           N  
ATOM     50  CA  ARG A   6     -14.661  29.710 -10.457  1.00  0.00           C  
ATOM     51  C   ARG A   6     -14.582  31.165 -10.003  1.00  0.00           C  
ATOM     52  O   ARG A   6     -15.577  31.890 -10.032  1.00  0.00           O  
ATOM     53  CB  ARG A   6     -14.309  28.777  -9.294  1.00  0.00           C  
ATOM     54  CG  ARG A   6     -15.295  27.635  -9.113  1.00  0.00           C  
ATOM     55  CD  ARG A   6     -15.141  26.978  -7.750  1.00  0.00           C  
ATOM     56  NE  ARG A   6     -16.403  26.426  -7.264  1.00  0.00           N  
ATOM     57  CZ  ARG A   6     -16.910  25.263  -7.670  1.00  0.00           C  
ATOM     58  NH1 ARG A   6     -16.267  24.530  -8.571  1.00  0.00           N  
ATOM     59  NH2 ARG A   6     -18.062  24.833  -7.175  1.00  0.00           N  
ATOM     60  H   ARG A   6     -12.955  28.944 -11.448  1.00  0.00           H  
ATOM     61  HA  ARG A   6     -15.670  29.502 -10.781  1.00  0.00           H  
ATOM     62  HB2 ARG A   6     -13.331  28.356  -9.471  1.00  0.00           H  
ATOM     63  HB3 ARG A   6     -14.285  29.352  -8.379  1.00  0.00           H  
ATOM     64  HG2 ARG A   6     -16.299  28.020  -9.204  1.00  0.00           H  
ATOM     65  HG3 ARG A   6     -15.119  26.896  -9.880  1.00  0.00           H  
ATOM     66  HD2 ARG A   6     -14.417  26.181  -7.828  1.00  0.00           H  
ATOM     67  HD3 ARG A   6     -14.788  27.718  -7.047  1.00  0.00           H  
ATOM     68  HE  ARG A   6     -16.899  26.947  -6.598  1.00  0.00           H  
ATOM     69 HH11 ARG A   6     -15.397  24.849  -8.948  1.00  0.00           H  
ATOM     70 HH12 ARG A   6     -16.652  23.658  -8.872  1.00  0.00           H  
ATOM     71 HH21 ARG A   6     -18.551  25.382  -6.497  1.00  0.00           H  
ATOM     72 HH22 ARG A   6     -18.444  23.961  -7.481  1.00  0.00           H  
ATOM     73  N   LEU A   7     -13.393  31.586  -9.585  1.00  0.00           N  
ATOM     74  CA  LEU A   7     -13.183  32.954  -9.125  1.00  0.00           C  
ATOM     75  C   LEU A   7     -11.750  33.404  -9.392  1.00  0.00           C  
ATOM     76  O   LEU A   7     -10.795  32.751  -8.971  1.00  0.00           O  
ATOM     77  CB  LEU A   7     -13.500  33.066  -7.631  1.00  0.00           C  
ATOM     78  CG  LEU A   7     -14.431  34.218  -7.251  1.00  0.00           C  
ATOM     79  CD1 LEU A   7     -14.777  34.160  -5.772  1.00  0.00           C  
ATOM     80  CD2 LEU A   7     -13.794  35.554  -7.600  1.00  0.00           C  
ATOM     81  H   LEU A   7     -12.637  30.961  -9.585  1.00  0.00           H  
ATOM     82  HA  LEU A   7     -13.856  33.594  -9.675  1.00  0.00           H  
ATOM     83  HB2 LEU A   7     -13.958  32.141  -7.313  1.00  0.00           H  
ATOM     84  HB3 LEU A   7     -12.571  33.191  -7.093  1.00  0.00           H  
ATOM     85  HG  LEU A   7     -15.350  34.129  -7.813  1.00  0.00           H  
ATOM     86 HD11 LEU A   7     -15.374  35.019  -5.508  1.00  0.00           H  
ATOM     87 HD12 LEU A   7     -13.867  34.161  -5.189  1.00  0.00           H  
ATOM     88 HD13 LEU A   7     -15.334  33.258  -5.568  1.00  0.00           H  
ATOM     89 HD21 LEU A   7     -13.833  35.705  -8.669  1.00  0.00           H  
ATOM     90 HD22 LEU A   7     -12.764  35.558  -7.274  1.00  0.00           H  
ATOM     91 HD23 LEU A   7     -14.331  36.349  -7.105  1.00  0.00           H  
ATOM     92  N   ASP A   8     -11.607  34.523 -10.094  1.00  0.00           N  
ATOM     93  CA  ASP A   8     -10.290  35.060 -10.417  1.00  0.00           C  
ATOM     94  C   ASP A   8     -10.028  36.358  -9.659  1.00  0.00           C  
ATOM     95  O   ASP A   8      -8.883  36.681  -9.341  1.00  0.00           O  
ATOM     96  CB  ASP A   8     -10.170  35.303 -11.923  1.00  0.00           C  
ATOM     97  CG  ASP A   8     -11.315  36.137 -12.467  1.00  0.00           C  
ATOM     98  OD1 ASP A   8     -11.363  37.349 -12.165  1.00  0.00           O  
ATOM     99  OD2 ASP A   8     -12.162  35.579 -13.195  1.00  0.00           O  
ATOM    100  H   ASP A   8     -12.406  34.998 -10.403  1.00  0.00           H  
ATOM    101  HA  ASP A   8      -9.553  34.330 -10.121  1.00  0.00           H  
ATOM    102  HB2 ASP A   8      -9.245  35.821 -12.126  1.00  0.00           H  
ATOM    103  HB3 ASP A   8     -10.167  34.353 -12.435  1.00  0.00           H  
ATOM    104  N   ALA A   9     -11.093  37.100  -9.375  1.00  0.00           N  
ATOM    105  CA  ALA A   9     -10.977  38.362  -8.655  1.00  0.00           C  
ATOM    106  C   ALA A   9     -10.449  38.143  -7.242  1.00  0.00           C  
ATOM    107  O   ALA A   9     -11.216  38.110  -6.279  1.00  0.00           O  
ATOM    108  CB  ALA A   9     -12.322  39.072  -8.614  1.00  0.00           C  
ATOM    109  H   ALA A   9     -11.981  36.790  -9.656  1.00  0.00           H  
ATOM    110  HA  ALA A   9     -10.283  38.990  -9.195  1.00  0.00           H  
ATOM    111  HB1 ALA A   9     -12.172  40.113  -8.368  1.00  0.00           H  
ATOM    112  HB2 ALA A   9     -12.949  38.611  -7.865  1.00  0.00           H  
ATOM    113  HB3 ALA A   9     -12.800  38.995  -9.580  1.00  0.00           H  
ATOM    114  N   LEU A  10      -9.133  37.993  -7.123  1.00  0.00           N  
ATOM    115  CA  LEU A  10      -8.502  37.776  -5.827  1.00  0.00           C  
ATOM    116  C   LEU A  10      -8.399  39.083  -5.042  1.00  0.00           C  
ATOM    117  O   LEU A  10      -8.959  39.207  -3.953  1.00  0.00           O  
ATOM    118  CB  LEU A  10      -7.111  37.162  -6.012  1.00  0.00           C  
ATOM    119  CG  LEU A  10      -7.053  35.638  -5.878  1.00  0.00           C  
ATOM    120  CD1 LEU A  10      -6.184  35.037  -6.972  1.00  0.00           C  
ATOM    121  CD2 LEU A  10      -6.533  35.242  -4.505  1.00  0.00           C  
ATOM    122  H   LEU A  10      -8.575  38.028  -7.928  1.00  0.00           H  
ATOM    123  HA  LEU A  10      -9.117  37.086  -5.271  1.00  0.00           H  
ATOM    124  HB2 LEU A  10      -6.751  37.433  -6.993  1.00  0.00           H  
ATOM    125  HB3 LEU A  10      -6.450  37.591  -5.273  1.00  0.00           H  
ATOM    126  HG  LEU A  10      -8.051  35.236  -5.987  1.00  0.00           H  
ATOM    127 HD11 LEU A  10      -5.179  34.903  -6.600  1.00  0.00           H  
ATOM    128 HD12 LEU A  10      -6.168  35.701  -7.824  1.00  0.00           H  
ATOM    129 HD13 LEU A  10      -6.589  34.081  -7.268  1.00  0.00           H  
ATOM    130 HD21 LEU A  10      -7.070  34.375  -4.151  1.00  0.00           H  
ATOM    131 HD22 LEU A  10      -6.678  36.061  -3.814  1.00  0.00           H  
ATOM    132 HD23 LEU A  10      -5.480  35.011  -4.571  1.00  0.00           H  
ATOM    133  N   PRO A  11      -7.675  40.077  -5.584  1.00  0.00           N  
ATOM    134  CA  PRO A  11      -7.500  41.375  -4.927  1.00  0.00           C  
ATOM    135  C   PRO A  11      -8.759  42.233  -4.988  1.00  0.00           C  
ATOM    136  O   PRO A  11      -9.356  42.403  -6.050  1.00  0.00           O  
ATOM    137  CB  PRO A  11      -6.371  42.024  -5.729  1.00  0.00           C  
ATOM    138  CG  PRO A  11      -6.478  41.421  -7.086  1.00  0.00           C  
ATOM    139  CD  PRO A  11      -6.970  40.013  -6.880  1.00  0.00           C  
ATOM    140  HA  PRO A  11      -7.194  41.259  -3.898  1.00  0.00           H  
ATOM    141  HB2 PRO A  11      -6.516  43.094  -5.758  1.00  0.00           H  
ATOM    142  HB3 PRO A  11      -5.421  41.795  -5.270  1.00  0.00           H  
ATOM    143  HG2 PRO A  11      -7.185  41.980  -7.681  1.00  0.00           H  
ATOM    144  HG3 PRO A  11      -5.509  41.412  -7.562  1.00  0.00           H  
ATOM    145  HD2 PRO A  11      -7.648  39.731  -7.671  1.00  0.00           H  
ATOM    146  HD3 PRO A  11      -6.139  39.326  -6.831  1.00  0.00           H  
ATOM    147  N   ARG A  12      -9.157  42.774  -3.839  1.00  0.00           N  
ATOM    148  CA  ARG A  12     -10.344  43.616  -3.761  1.00  0.00           C  
ATOM    149  C   ARG A  12      -9.975  45.087  -3.921  1.00  0.00           C  
ATOM    150  O   ARG A  12      -9.221  45.640  -3.121  1.00  0.00           O  
ATOM    151  CB  ARG A  12     -11.061  43.401  -2.427  1.00  0.00           C  
ATOM    152  CG  ARG A  12     -11.610  41.994  -2.253  1.00  0.00           C  
ATOM    153  CD  ARG A  12     -12.681  41.941  -1.174  1.00  0.00           C  
ATOM    154  NE  ARG A  12     -14.014  41.736  -1.736  1.00  0.00           N  
ATOM    155  CZ  ARG A  12     -15.058  41.307  -1.030  1.00  0.00           C  
ATOM    156  NH1 ARG A  12     -14.928  41.039   0.263  1.00  0.00           N  
ATOM    157  NH2 ARG A  12     -16.236  41.148  -1.618  1.00  0.00           N  
ATOM    158  H   ARG A  12      -8.637  42.602  -3.026  1.00  0.00           H  
ATOM    159  HA  ARG A  12     -11.005  43.333  -4.565  1.00  0.00           H  
ATOM    160  HB2 ARG A  12     -10.366  43.595  -1.622  1.00  0.00           H  
ATOM    161  HB3 ARG A  12     -11.884  44.096  -2.357  1.00  0.00           H  
ATOM    162  HG2 ARG A  12     -12.039  41.667  -3.187  1.00  0.00           H  
ATOM    163  HG3 ARG A  12     -10.800  41.334  -1.976  1.00  0.00           H  
ATOM    164  HD2 ARG A  12     -12.457  41.126  -0.502  1.00  0.00           H  
ATOM    165  HD3 ARG A  12     -12.670  42.872  -0.626  1.00  0.00           H  
ATOM    166  HE  ARG A  12     -14.138  41.928  -2.690  1.00  0.00           H  
ATOM    167 HH11 ARG A  12     -14.043  41.157   0.713  1.00  0.00           H  
ATOM    168 HH12 ARG A  12     -15.717  40.718   0.788  1.00  0.00           H  
ATOM    169 HH21 ARG A  12     -16.339  41.349  -2.593  1.00  0.00           H  
ATOM    170 HH22 ARG A  12     -17.020  40.826  -1.088  1.00  0.00           H  
ATOM    171  N   VAL A  13     -10.508  45.714  -4.965  1.00  0.00           N  
ATOM    172  CA  VAL A  13     -10.235  47.116  -5.236  1.00  0.00           C  
ATOM    173  C   VAL A  13     -10.953  48.026  -4.245  1.00  0.00           C  
ATOM    174  O   VAL A  13     -12.150  48.277  -4.372  1.00  0.00           O  
ATOM    175  CB  VAL A  13     -10.662  47.495  -6.665  1.00  0.00           C  
ATOM    176  CG1 VAL A  13      -9.677  46.941  -7.685  1.00  0.00           C  
ATOM    177  CG2 VAL A  13     -12.073  47.004  -6.953  1.00  0.00           C  
ATOM    178  H   VAL A  13     -11.097  45.222  -5.570  1.00  0.00           H  
ATOM    179  HA  VAL A  13      -9.170  47.271  -5.149  1.00  0.00           H  
ATOM    180  HB  VAL A  13     -10.657  48.568  -6.742  1.00  0.00           H  
ATOM    181 HG11 VAL A  13     -10.208  46.667  -8.584  1.00  0.00           H  
ATOM    182 HG12 VAL A  13      -9.187  46.070  -7.275  1.00  0.00           H  
ATOM    183 HG13 VAL A  13      -8.939  47.694  -7.917  1.00  0.00           H  
ATOM    184 HG21 VAL A  13     -12.609  47.758  -7.511  1.00  0.00           H  
ATOM    185 HG22 VAL A  13     -12.585  46.813  -6.022  1.00  0.00           H  
ATOM    186 HG23 VAL A  13     -12.026  46.093  -7.532  1.00  0.00           H  
ATOM    187  N   THR A  14     -10.209  48.525  -3.262  1.00  0.00           N  
ATOM    188  CA  THR A  14     -10.772  49.416  -2.252  1.00  0.00           C  
ATOM    189  C   THR A  14     -11.871  48.721  -1.453  1.00  0.00           C  
ATOM    190  O   THR A  14     -12.212  47.567  -1.716  1.00  0.00           O  
ATOM    191  CB  THR A  14     -11.327  50.677  -2.914  1.00  0.00           C  
ATOM    192  OG1 THR A  14     -10.650  50.945  -4.129  1.00  0.00           O  
ATOM    193  CG2 THR A  14     -11.217  51.912  -2.047  1.00  0.00           C  
ATOM    194  H   THR A  14      -9.258  48.292  -3.216  1.00  0.00           H  
ATOM    195  HA  THR A  14      -9.977  49.695  -1.575  1.00  0.00           H  
ATOM    196  HB  THR A  14     -12.374  50.522  -3.137  1.00  0.00           H  
ATOM    197  HG1 THR A  14      -9.748  51.214  -3.941  1.00  0.00           H  
ATOM    198 HG21 THR A  14     -12.196  52.348  -1.914  1.00  0.00           H  
ATOM    199 HG22 THR A  14     -10.564  52.629  -2.523  1.00  0.00           H  
ATOM    200 HG23 THR A  14     -10.812  51.640  -1.084  1.00  0.00           H  
ATOM    201  N   CYS A  15     -12.419  49.436  -0.477  1.00  0.00           N  
ATOM    202  CA  CYS A  15     -13.481  48.904   0.369  1.00  0.00           C  
ATOM    203  C   CYS A  15     -14.844  49.076  -0.304  1.00  0.00           C  
ATOM    204  O   CYS A  15     -15.166  50.155  -0.800  1.00  0.00           O  
ATOM    205  CB  CYS A  15     -13.464  49.615   1.725  1.00  0.00           C  
ATOM    206  SG  CYS A  15     -14.871  49.239   2.800  1.00  0.00           S  
ATOM    207  H   CYS A  15     -12.101  50.350  -0.320  1.00  0.00           H  
ATOM    208  HA  CYS A  15     -13.289  47.854   0.520  1.00  0.00           H  
ATOM    209  HB2 CYS A  15     -12.567  49.334   2.255  1.00  0.00           H  
ATOM    210  HB3 CYS A  15     -13.453  50.681   1.557  1.00  0.00           H  
ATOM    211  N   PRO A  16     -15.667  48.011  -0.332  1.00  0.00           N  
ATOM    212  CA  PRO A  16     -16.997  48.058  -0.952  1.00  0.00           C  
ATOM    213  C   PRO A  16     -17.871  49.165  -0.376  1.00  0.00           C  
ATOM    214  O   PRO A  16     -18.641  49.801  -1.097  1.00  0.00           O  
ATOM    215  CB  PRO A  16     -17.596  46.686  -0.630  1.00  0.00           C  
ATOM    216  CG  PRO A  16     -16.423  45.803  -0.382  1.00  0.00           C  
ATOM    217  CD  PRO A  16     -15.369  46.680   0.231  1.00  0.00           C  
ATOM    218  HA  PRO A  16     -16.926  48.180  -2.021  1.00  0.00           H  
ATOM    219  HB2 PRO A  16     -18.225  46.762   0.245  1.00  0.00           H  
ATOM    220  HB3 PRO A  16     -18.180  46.339  -1.470  1.00  0.00           H  
ATOM    221  HG2 PRO A  16     -16.696  45.011   0.300  1.00  0.00           H  
ATOM    222  HG3 PRO A  16     -16.070  45.390  -1.316  1.00  0.00           H  
ATOM    223  HD2 PRO A  16     -15.462  46.686   1.308  1.00  0.00           H  
ATOM    224  HD3 PRO A  16     -14.384  46.349  -0.064  1.00  0.00           H  
ATOM    225  N   ASN A  17     -17.752  49.385   0.927  1.00  0.00           N  
ATOM    226  CA  ASN A  17     -18.539  50.411   1.604  1.00  0.00           C  
ATOM    227  C   ASN A  17     -17.713  51.668   1.876  1.00  0.00           C  
ATOM    228  O   ASN A  17     -18.144  52.552   2.616  1.00  0.00           O  
ATOM    229  CB  ASN A  17     -19.099  49.865   2.918  1.00  0.00           C  
ATOM    230  CG  ASN A  17     -20.288  48.948   2.705  1.00  0.00           C  
ATOM    231  OD1 ASN A  17     -20.756  48.773   1.579  1.00  0.00           O  
ATOM    232  ND2 ASN A  17     -20.782  48.358   3.786  1.00  0.00           N  
ATOM    233  H   ASN A  17     -17.126  48.841   1.445  1.00  0.00           H  
ATOM    234  HA  ASN A  17     -19.363  50.673   0.958  1.00  0.00           H  
ATOM    235  HB2 ASN A  17     -18.327  49.308   3.428  1.00  0.00           H  
ATOM    236  HB3 ASN A  17     -19.411  50.691   3.541  1.00  0.00           H  
ATOM    237 HD21 ASN A  17     -20.358  48.544   4.649  1.00  0.00           H  
ATOM    238 HD22 ASN A  17     -21.551  47.759   3.676  1.00  0.00           H  
ATOM    239  N   HIS A  18     -16.527  51.749   1.277  1.00  0.00           N  
ATOM    240  CA  HIS A  18     -15.659  52.907   1.463  1.00  0.00           C  
ATOM    241  C   HIS A  18     -14.745  53.104   0.256  1.00  0.00           C  
ATOM    242  O   HIS A  18     -13.631  52.581   0.219  1.00  0.00           O  
ATOM    243  CB  HIS A  18     -14.821  52.746   2.734  1.00  0.00           C  
ATOM    244  CG  HIS A  18     -15.622  52.835   3.993  1.00  0.00           C  
ATOM    245  ND1 HIS A  18     -15.557  51.856   4.960  1.00  0.00           N  
ATOM    246  CD2 HIS A  18     -16.478  53.805   4.396  1.00  0.00           C  
ATOM    247  CE1 HIS A  18     -16.371  52.260   5.924  1.00  0.00           C  
ATOM    248  NE2 HIS A  18     -16.950  53.431   5.624  1.00  0.00           N  
ATOM    249  H   HIS A  18     -16.231  51.019   0.695  1.00  0.00           H  
ATOM    250  HA  HIS A  18     -16.290  53.777   1.568  1.00  0.00           H  
ATOM    251  HB2 HIS A  18     -14.334  51.786   2.719  1.00  0.00           H  
ATOM    252  HB3 HIS A  18     -14.072  53.523   2.761  1.00  0.00           H  
ATOM    253  HD2 HIS A  18     -16.741  54.700   3.853  1.00  0.00           H  
ATOM    254  HE1 HIS A  18     -16.533  51.728   6.845  1.00  0.00           H  
ATOM    255  HE2 HIS A  18     -17.454  54.000   6.243  1.00  0.00           H  
ATOM    256  N   PRO A  19     -15.204  53.870  -0.749  1.00  0.00           N  
ATOM    257  CA  PRO A  19     -14.421  54.135  -1.959  1.00  0.00           C  
ATOM    258  C   PRO A  19     -13.226  55.043  -1.684  1.00  0.00           C  
ATOM    259  O   PRO A  19     -12.111  54.770  -2.130  1.00  0.00           O  
ATOM    260  CB  PRO A  19     -15.419  54.832  -2.885  1.00  0.00           C  
ATOM    261  CG  PRO A  19     -16.415  55.454  -1.970  1.00  0.00           C  
ATOM    262  CD  PRO A  19     -16.521  54.534  -0.785  1.00  0.00           C  
ATOM    263  HA  PRO A  19     -14.077  53.220  -2.418  1.00  0.00           H  
ATOM    264  HB2 PRO A  19     -14.907  55.577  -3.478  1.00  0.00           H  
ATOM    265  HB3 PRO A  19     -15.882  54.104  -3.535  1.00  0.00           H  
ATOM    266  HG2 PRO A  19     -16.070  56.429  -1.658  1.00  0.00           H  
ATOM    267  HG3 PRO A  19     -17.371  55.535  -2.466  1.00  0.00           H  
ATOM    268  HD2 PRO A  19     -16.692  55.099   0.119  1.00  0.00           H  
ATOM    269  HD3 PRO A  19     -17.311  53.813  -0.936  1.00  0.00           H  
ATOM    270  N   ASP A  20     -13.466  56.122  -0.948  1.00  0.00           N  
ATOM    271  CA  ASP A  20     -12.409  57.069  -0.611  1.00  0.00           C  
ATOM    272  C   ASP A  20     -11.349  56.409   0.262  1.00  0.00           C  
ATOM    273  O   ASP A  20     -10.155  56.670   0.112  1.00  0.00           O  
ATOM    274  CB  ASP A  20     -12.994  58.287   0.108  1.00  0.00           C  
ATOM    275  CG  ASP A  20     -13.778  59.189  -0.825  1.00  0.00           C  
ATOM    276  OD1 ASP A  20     -13.549  59.118  -2.051  1.00  0.00           O  
ATOM    277  OD2 ASP A  20     -14.619  59.968  -0.330  1.00  0.00           O  
ATOM    278  H   ASP A  20     -14.376  56.285  -0.620  1.00  0.00           H  
ATOM    279  HA  ASP A  20     -11.949  57.394  -1.533  1.00  0.00           H  
ATOM    280  HB2 ASP A  20     -13.656  57.950   0.892  1.00  0.00           H  
ATOM    281  HB3 ASP A  20     -12.189  58.861   0.543  1.00  0.00           H  
ATOM    282  N   ALA A  21     -11.793  55.553   1.176  1.00  0.00           N  
ATOM    283  CA  ALA A  21     -10.884  54.853   2.075  1.00  0.00           C  
ATOM    284  C   ALA A  21     -10.499  53.490   1.509  1.00  0.00           C  
ATOM    285  O   ALA A  21     -11.362  52.659   1.228  1.00  0.00           O  
ATOM    286  CB  ALA A  21     -11.516  54.698   3.450  1.00  0.00           C  
ATOM    287  H   ALA A  21     -12.756  55.387   1.247  1.00  0.00           H  
ATOM    288  HA  ALA A  21      -9.991  55.453   2.180  1.00  0.00           H  
ATOM    289  HB1 ALA A  21     -11.206  53.759   3.884  1.00  0.00           H  
ATOM    290  HB2 ALA A  21     -12.592  54.714   3.356  1.00  0.00           H  
ATOM    291  HB3 ALA A  21     -11.198  55.510   4.085  1.00  0.00           H  
ATOM    292  N   ILE A  22      -9.201  53.270   1.343  1.00  0.00           N  
ATOM    293  CA  ILE A  22      -8.705  52.008   0.809  1.00  0.00           C  
ATOM    294  C   ILE A  22      -8.104  51.140   1.907  1.00  0.00           C  
ATOM    295  O   ILE A  22      -7.339  51.620   2.744  1.00  0.00           O  
ATOM    296  CB  ILE A  22      -7.642  52.240  -0.284  1.00  0.00           C  
ATOM    297  CG1 ILE A  22      -8.144  53.262  -1.309  1.00  0.00           C  
ATOM    298  CG2 ILE A  22      -7.286  50.926  -0.964  1.00  0.00           C  
ATOM    299  CD1 ILE A  22      -7.158  54.376  -1.581  1.00  0.00           C  
ATOM    300  H   ILE A  22      -8.561  53.971   1.584  1.00  0.00           H  
ATOM    301  HA  ILE A  22      -9.538  51.484   0.365  1.00  0.00           H  
ATOM    302  HB  ILE A  22      -6.751  52.625   0.189  1.00  0.00           H  
ATOM    303 HG12 ILE A  22      -8.339  52.758  -2.245  1.00  0.00           H  
ATOM    304 HG13 ILE A  22      -9.059  53.708  -0.948  1.00  0.00           H  
ATOM    305 HG21 ILE A  22      -6.255  50.955  -1.283  1.00  0.00           H  
ATOM    306 HG22 ILE A  22      -7.925  50.780  -1.822  1.00  0.00           H  
ATOM    307 HG23 ILE A  22      -7.425  50.112  -0.269  1.00  0.00           H  
ATOM    308 HD11 ILE A  22      -6.159  53.969  -1.637  1.00  0.00           H  
ATOM    309 HD12 ILE A  22      -7.206  55.103  -0.783  1.00  0.00           H  
ATOM    310 HD13 ILE A  22      -7.404  54.854  -2.518  1.00  0.00           H  
ATOM    311  N   LEU A  23      -8.454  49.857   1.895  1.00  0.00           N  
ATOM    312  CA  LEU A  23      -7.944  48.918   2.889  1.00  0.00           C  
ATOM    313  C   LEU A  23      -6.419  48.859   2.838  1.00  0.00           C  
ATOM    314  O   LEU A  23      -5.841  48.388   1.858  1.00  0.00           O  
ATOM    315  CB  LEU A  23      -8.529  47.524   2.649  1.00  0.00           C  
ATOM    316  CG  LEU A  23      -9.756  47.182   3.499  1.00  0.00           C  
ATOM    317  CD1 LEU A  23     -11.034  47.414   2.706  1.00  0.00           C  
ATOM    318  CD2 LEU A  23      -9.683  45.743   3.991  1.00  0.00           C  
ATOM    319  H   LEU A  23      -9.064  49.534   1.199  1.00  0.00           H  
ATOM    320  HA  LEU A  23      -8.251  49.265   3.867  1.00  0.00           H  
ATOM    321  HB2 LEU A  23      -8.803  47.447   1.607  1.00  0.00           H  
ATOM    322  HB3 LEU A  23      -7.761  46.794   2.857  1.00  0.00           H  
ATOM    323  HG  LEU A  23      -9.778  47.832   4.361  1.00  0.00           H  
ATOM    324 HD11 LEU A  23     -10.902  48.262   2.050  1.00  0.00           H  
ATOM    325 HD12 LEU A  23     -11.849  47.611   3.387  1.00  0.00           H  
ATOM    326 HD13 LEU A  23     -11.259  46.537   2.120  1.00  0.00           H  
ATOM    327 HD21 LEU A  23     -10.624  45.249   3.803  1.00  0.00           H  
ATOM    328 HD22 LEU A  23      -9.479  45.736   5.051  1.00  0.00           H  
ATOM    329 HD23 LEU A  23      -8.893  45.222   3.470  1.00  0.00           H  
ATOM    330  N   VAL A  24      -5.772  49.338   3.896  1.00  0.00           N  
ATOM    331  CA  VAL A  24      -4.316  49.336   3.963  1.00  0.00           C  
ATOM    332  C   VAL A  24      -3.792  47.937   4.254  1.00  0.00           C  
ATOM    333  O   VAL A  24      -4.511  47.097   4.789  1.00  0.00           O  
ATOM    334  CB  VAL A  24      -3.795  50.300   5.046  1.00  0.00           C  
ATOM    335  CG1 VAL A  24      -2.302  50.535   4.876  1.00  0.00           C  
ATOM    336  CG2 VAL A  24      -4.557  51.616   5.007  1.00  0.00           C  
ATOM    337  H   VAL A  24      -6.286  49.699   4.648  1.00  0.00           H  
ATOM    338  HA  VAL A  24      -3.936  49.661   3.006  1.00  0.00           H  
ATOM    339  HB  VAL A  24      -3.956  49.843   6.012  1.00  0.00           H  
ATOM    340 HG11 VAL A  24      -2.055  50.530   3.825  1.00  0.00           H  
ATOM    341 HG12 VAL A  24      -1.755  49.752   5.379  1.00  0.00           H  
ATOM    342 HG13 VAL A  24      -2.038  51.491   5.303  1.00  0.00           H  
ATOM    343 HG21 VAL A  24      -4.550  52.007   4.001  1.00  0.00           H  
ATOM    344 HG22 VAL A  24      -4.085  52.325   5.672  1.00  0.00           H  
ATOM    345 HG23 VAL A  24      -5.577  51.451   5.323  1.00  0.00           H  
ATOM    346  N   GLU A  25      -2.535  47.691   3.899  1.00  0.00           N  
ATOM    347  CA  GLU A  25      -1.920  46.388   4.124  1.00  0.00           C  
ATOM    348  C   GLU A  25      -0.653  46.518   4.962  1.00  0.00           C  
ATOM    349  O   GLU A  25       0.083  47.498   4.846  1.00  0.00           O  
ATOM    350  CB  GLU A  25      -1.595  45.715   2.790  1.00  0.00           C  
ATOM    351  CG  GLU A  25      -1.279  44.233   2.917  1.00  0.00           C  
ATOM    352  CD  GLU A  25      -0.925  43.596   1.587  1.00  0.00           C  
ATOM    353  OE1 GLU A  25      -1.283  44.173   0.538  1.00  0.00           O  
ATOM    354  OE2 GLU A  25      -0.290  42.521   1.595  1.00  0.00           O  
ATOM    355  H   GLU A  25      -2.010  48.401   3.475  1.00  0.00           H  
ATOM    356  HA  GLU A  25      -2.630  45.776   4.660  1.00  0.00           H  
ATOM    357  HB2 GLU A  25      -2.441  45.826   2.128  1.00  0.00           H  
ATOM    358  HB3 GLU A  25      -0.740  46.207   2.350  1.00  0.00           H  
ATOM    359  HG2 GLU A  25      -0.444  44.113   3.589  1.00  0.00           H  
ATOM    360  HG3 GLU A  25      -2.143  43.729   3.323  1.00  0.00           H  
ATOM    361  N   ASP A  26      -0.404  45.522   5.807  1.00  0.00           N  
ATOM    362  CA  ASP A  26       0.774  45.523   6.666  1.00  0.00           C  
ATOM    363  C   ASP A  26       2.005  45.047   5.899  1.00  0.00           C  
ATOM    364  O   ASP A  26       2.002  45.002   4.669  1.00  0.00           O  
ATOM    365  CB  ASP A  26       0.536  44.634   7.890  1.00  0.00           C  
ATOM    366  CG  ASP A  26       0.721  45.384   9.194  1.00  0.00           C  
ATOM    367  OD1 ASP A  26      -0.225  46.084   9.615  1.00  0.00           O  
ATOM    368  OD2 ASP A  26       1.810  45.272   9.795  1.00  0.00           O  
ATOM    369  H   ASP A  26      -1.030  44.768   5.853  1.00  0.00           H  
ATOM    370  HA  ASP A  26       0.941  46.537   6.996  1.00  0.00           H  
ATOM    371  HB2 ASP A  26      -0.472  44.250   7.858  1.00  0.00           H  
ATOM    372  HB3 ASP A  26       1.232  43.808   7.870  1.00  0.00           H  
ATOM    373  N   TYR A  27       3.058  44.695   6.631  1.00  0.00           N  
ATOM    374  CA  TYR A  27       4.295  44.226   6.018  1.00  0.00           C  
ATOM    375  C   TYR A  27       4.313  42.704   5.916  1.00  0.00           C  
ATOM    376  O   TYR A  27       4.933  42.142   5.014  1.00  0.00           O  
ATOM    377  CB  TYR A  27       5.504  44.708   6.822  1.00  0.00           C  
ATOM    378  CG  TYR A  27       5.400  46.149   7.271  1.00  0.00           C  
ATOM    379  CD1 TYR A  27       4.657  46.494   8.394  1.00  0.00           C  
ATOM    380  CD2 TYR A  27       6.042  47.163   6.572  1.00  0.00           C  
ATOM    381  CE1 TYR A  27       4.558  47.808   8.807  1.00  0.00           C  
ATOM    382  CE2 TYR A  27       5.948  48.480   6.979  1.00  0.00           C  
ATOM    383  CZ  TYR A  27       5.206  48.797   8.096  1.00  0.00           C  
ATOM    384  OH  TYR A  27       5.109  50.108   8.505  1.00  0.00           O  
ATOM    385  H   TYR A  27       3.001  44.755   7.609  1.00  0.00           H  
ATOM    386  HA  TYR A  27       4.349  44.642   5.023  1.00  0.00           H  
ATOM    387  HB2 TYR A  27       5.609  44.094   7.704  1.00  0.00           H  
ATOM    388  HB3 TYR A  27       6.393  44.613   6.215  1.00  0.00           H  
ATOM    389  HD1 TYR A  27       4.153  45.717   8.948  1.00  0.00           H  
ATOM    390  HD2 TYR A  27       6.623  46.911   5.697  1.00  0.00           H  
ATOM    391  HE1 TYR A  27       3.977  48.057   9.682  1.00  0.00           H  
ATOM    392  HE2 TYR A  27       6.454  49.254   6.422  1.00  0.00           H  
ATOM    393  HH  TYR A  27       5.656  50.242   9.282  1.00  0.00           H  
ATOM    394  N   ARG A  28       3.627  42.042   6.847  1.00  0.00           N  
ATOM    395  CA  ARG A  28       3.556  40.588   6.869  1.00  0.00           C  
ATOM    396  C   ARG A  28       2.875  40.110   8.142  1.00  0.00           C  
ATOM    397  O   ARG A  28       3.318  40.406   9.252  1.00  0.00           O  
ATOM    398  CB  ARG A  28       4.948  39.963   6.764  1.00  0.00           C  
ATOM    399  CG  ARG A  28       5.066  38.912   5.671  1.00  0.00           C  
ATOM    400  CD  ARG A  28       4.808  39.503   4.294  1.00  0.00           C  
ATOM    401  NE  ARG A  28       4.431  38.480   3.322  1.00  0.00           N  
ATOM    402  CZ  ARG A  28       5.275  37.571   2.838  1.00  0.00           C  
ATOM    403  NH1 ARG A  28       6.544  37.557   3.229  1.00  0.00           N  
ATOM    404  NH2 ARG A  28       4.849  36.673   1.959  1.00  0.00           N  
ATOM    405  H   ARG A  28       3.150  42.546   7.536  1.00  0.00           H  
ATOM    406  HA  ARG A  28       2.965  40.274   6.021  1.00  0.00           H  
ATOM    407  HB2 ARG A  28       5.669  40.742   6.567  1.00  0.00           H  
ATOM    408  HB3 ARG A  28       5.187  39.495   7.707  1.00  0.00           H  
ATOM    409  HG2 ARG A  28       6.062  38.497   5.690  1.00  0.00           H  
ATOM    410  HG3 ARG A  28       4.344  38.131   5.858  1.00  0.00           H  
ATOM    411  HD2 ARG A  28       4.008  40.224   4.369  1.00  0.00           H  
ATOM    412  HD3 ARG A  28       5.705  39.997   3.954  1.00  0.00           H  
ATOM    413  HE  ARG A  28       3.501  38.468   3.014  1.00  0.00           H  
ATOM    414 HH11 ARG A  28       6.871  38.231   3.890  1.00  0.00           H  
ATOM    415 HH12 ARG A  28       7.172  36.872   2.861  1.00  0.00           H  
ATOM    416 HH21 ARG A  28       3.895  36.679   1.661  1.00  0.00           H  
ATOM    417 HH22 ARG A  28       5.482  35.990   1.596  1.00  0.00           H  
ATOM    418  N   ALA A  29       1.796  39.367   7.967  1.00  0.00           N  
ATOM    419  CA  ALA A  29       1.027  38.830   9.087  1.00  0.00           C  
ATOM    420  C   ALA A  29       0.181  39.914   9.746  1.00  0.00           C  
ATOM    421  O   ALA A  29      -0.126  39.838  10.936  1.00  0.00           O  
ATOM    422  CB  ALA A  29       1.951  38.184  10.110  1.00  0.00           C  
ATOM    423  H   ALA A  29       1.506  39.177   7.054  1.00  0.00           H  
ATOM    424  HA  ALA A  29       0.370  38.065   8.700  1.00  0.00           H  
ATOM    425  HB1 ALA A  29       1.493  37.282  10.491  1.00  0.00           H  
ATOM    426  HB2 ALA A  29       2.122  38.872  10.926  1.00  0.00           H  
ATOM    427  HB3 ALA A  29       2.892  37.939   9.642  1.00  0.00           H  
ATOM    428  N   GLY A  30      -0.195  40.922   8.965  1.00  0.00           N  
ATOM    429  CA  GLY A  30      -1.004  42.007   9.492  1.00  0.00           C  
ATOM    430  C   GLY A  30      -2.350  42.124   8.800  1.00  0.00           C  
ATOM    431  O   GLY A  30      -3.259  42.781   9.308  1.00  0.00           O  
ATOM    432  H   GLY A  30       0.080  40.930   8.025  1.00  0.00           H  
ATOM    433  HA2 GLY A  30      -1.168  41.839  10.546  1.00  0.00           H  
ATOM    434  HA3 GLY A  30      -0.466  42.934   9.367  1.00  0.00           H  
ATOM    435  N   ASP A  31      -2.483  41.486   7.639  1.00  0.00           N  
ATOM    436  CA  ASP A  31      -3.728  41.524   6.880  1.00  0.00           C  
ATOM    437  C   ASP A  31      -3.998  42.926   6.345  1.00  0.00           C  
ATOM    438  O   ASP A  31      -3.156  43.818   6.460  1.00  0.00           O  
ATOM    439  CB  ASP A  31      -4.903  41.067   7.751  1.00  0.00           C  
ATOM    440  CG  ASP A  31      -4.563  39.854   8.596  1.00  0.00           C  
ATOM    441  OD1 ASP A  31      -3.642  39.104   8.213  1.00  0.00           O  
ATOM    442  OD2 ASP A  31      -5.220  39.656   9.640  1.00  0.00           O  
ATOM    443  H   ASP A  31      -1.724  40.978   7.282  1.00  0.00           H  
ATOM    444  HA  ASP A  31      -3.628  40.847   6.045  1.00  0.00           H  
ATOM    445  HB2 ASP A  31      -5.187  41.873   8.412  1.00  0.00           H  
ATOM    446  HB3 ASP A  31      -5.740  40.818   7.115  1.00  0.00           H  
ATOM    447  N   MET A  32      -5.177  43.113   5.759  1.00  0.00           N  
ATOM    448  CA  MET A  32      -5.560  44.408   5.208  1.00  0.00           C  
ATOM    449  C   MET A  32      -6.781  44.963   5.934  1.00  0.00           C  
ATOM    450  O   MET A  32      -7.850  44.352   5.925  1.00  0.00           O  
ATOM    451  CB  MET A  32      -5.854  44.283   3.712  1.00  0.00           C  
ATOM    452  CG  MET A  32      -4.631  44.483   2.832  1.00  0.00           C  
ATOM    453  SD  MET A  32      -5.059  44.943   1.143  1.00  0.00           S  
ATOM    454  CE  MET A  32      -5.573  43.361   0.479  1.00  0.00           C  
ATOM    455  H   MET A  32      -5.805  42.363   5.700  1.00  0.00           H  
ATOM    456  HA  MET A  32      -4.732  45.084   5.350  1.00  0.00           H  
ATOM    457  HB2 MET A  32      -6.254  43.298   3.516  1.00  0.00           H  
ATOM    458  HB3 MET A  32      -6.592  45.021   3.438  1.00  0.00           H  
ATOM    459  HG2 MET A  32      -4.021  45.265   3.259  1.00  0.00           H  
ATOM    460  HG3 MET A  32      -4.067  43.562   2.808  1.00  0.00           H  
ATOM    461  HE1 MET A  32      -6.620  43.204   0.694  1.00  0.00           H  
ATOM    462  HE2 MET A  32      -4.990  42.574   0.934  1.00  0.00           H  
ATOM    463  HE3 MET A  32      -5.419  43.351  -0.589  1.00  0.00           H  
ATOM    464  N   ILE A  33      -6.615  46.117   6.575  1.00  0.00           N  
ATOM    465  CA  ILE A  33      -7.692  46.739   7.315  1.00  0.00           C  
ATOM    466  C   ILE A  33      -8.168  48.025   6.645  1.00  0.00           C  
ATOM    467  O   ILE A  33      -7.423  48.662   5.903  1.00  0.00           O  
ATOM    468  CB  ILE A  33      -7.242  47.060   8.746  1.00  0.00           C  
ATOM    469  CG1 ILE A  33      -6.033  48.000   8.733  1.00  0.00           C  
ATOM    470  CG2 ILE A  33      -6.921  45.780   9.503  1.00  0.00           C  
ATOM    471  CD1 ILE A  33      -6.372  49.420   9.129  1.00  0.00           C  
ATOM    472  H   ILE A  33      -5.744  46.554   6.564  1.00  0.00           H  
ATOM    473  HA  ILE A  33      -8.511  46.042   7.362  1.00  0.00           H  
ATOM    474  HB  ILE A  33      -8.053  47.546   9.241  1.00  0.00           H  
ATOM    475 HG12 ILE A  33      -5.290  47.632   9.426  1.00  0.00           H  
ATOM    476 HG13 ILE A  33      -5.612  48.025   7.740  1.00  0.00           H  
ATOM    477 HG21 ILE A  33      -5.856  45.602   9.475  1.00  0.00           H  
ATOM    478 HG22 ILE A  33      -7.437  44.950   9.042  1.00  0.00           H  
ATOM    479 HG23 ILE A  33      -7.243  45.879  10.529  1.00  0.00           H  
ATOM    480 HD11 ILE A  33      -5.482  50.030   9.081  1.00  0.00           H  
ATOM    481 HD12 ILE A  33      -6.761  49.430  10.136  1.00  0.00           H  
ATOM    482 HD13 ILE A  33      -7.115  49.814   8.451  1.00  0.00           H  
ATOM    483  N   CYS A  34      -9.414  48.405   6.919  1.00  0.00           N  
ATOM    484  CA  CYS A  34      -9.985  49.620   6.345  1.00  0.00           C  
ATOM    485  C   CYS A  34      -9.950  50.762   7.362  1.00  0.00           C  
ATOM    486  O   CYS A  34     -10.260  50.562   8.536  1.00  0.00           O  
ATOM    487  CB  CYS A  34     -11.422  49.355   5.897  1.00  0.00           C  
ATOM    488  SG  CYS A  34     -12.229  50.743   5.061  1.00  0.00           S  
ATOM    489  H   CYS A  34      -9.964  47.855   7.525  1.00  0.00           H  
ATOM    490  HA  CYS A  34      -9.392  49.893   5.487  1.00  0.00           H  
ATOM    491  HB2 CYS A  34     -11.427  48.520   5.214  1.00  0.00           H  
ATOM    492  HB3 CYS A  34     -12.018  49.104   6.763  1.00  0.00           H  
ATOM    493  N   PRO A  35      -9.563  51.976   6.930  1.00  0.00           N  
ATOM    494  CA  PRO A  35      -9.483  53.140   7.820  1.00  0.00           C  
ATOM    495  C   PRO A  35     -10.852  53.729   8.161  1.00  0.00           C  
ATOM    496  O   PRO A  35     -10.943  54.730   8.872  1.00  0.00           O  
ATOM    497  CB  PRO A  35      -8.660  54.140   7.009  1.00  0.00           C  
ATOM    498  CG  PRO A  35      -8.957  53.802   5.589  1.00  0.00           C  
ATOM    499  CD  PRO A  35      -9.163  52.311   5.548  1.00  0.00           C  
ATOM    500  HA  PRO A  35      -8.961  52.900   8.734  1.00  0.00           H  
ATOM    501  HB2 PRO A  35      -8.971  55.147   7.251  1.00  0.00           H  
ATOM    502  HB3 PRO A  35      -7.612  54.015   7.234  1.00  0.00           H  
ATOM    503  HG2 PRO A  35      -9.854  54.313   5.271  1.00  0.00           H  
ATOM    504  HG3 PRO A  35      -8.122  54.082   4.964  1.00  0.00           H  
ATOM    505  HD2 PRO A  35      -9.944  52.059   4.848  1.00  0.00           H  
ATOM    506  HD3 PRO A  35      -8.242  51.811   5.283  1.00  0.00           H  
ATOM    507  N   GLU A  36     -11.915  53.109   7.655  1.00  0.00           N  
ATOM    508  CA  GLU A  36     -13.269  53.583   7.914  1.00  0.00           C  
ATOM    509  C   GLU A  36     -14.063  52.559   8.726  1.00  0.00           C  
ATOM    510  O   GLU A  36     -14.238  52.721   9.933  1.00  0.00           O  
ATOM    511  CB  GLU A  36     -13.984  53.888   6.599  1.00  0.00           C  
ATOM    512  CG  GLU A  36     -13.411  55.085   5.857  1.00  0.00           C  
ATOM    513  CD  GLU A  36     -13.719  56.399   6.547  1.00  0.00           C  
ATOM    514  OE1 GLU A  36     -14.916  56.711   6.723  1.00  0.00           O  
ATOM    515  OE2 GLU A  36     -12.764  57.116   6.911  1.00  0.00           O  
ATOM    516  H   GLU A  36     -11.787  52.317   7.097  1.00  0.00           H  
ATOM    517  HA  GLU A  36     -13.193  54.494   8.489  1.00  0.00           H  
ATOM    518  HB2 GLU A  36     -13.911  53.025   5.956  1.00  0.00           H  
ATOM    519  HB3 GLU A  36     -15.025  54.086   6.807  1.00  0.00           H  
ATOM    520  HG2 GLU A  36     -12.339  54.972   5.793  1.00  0.00           H  
ATOM    521  HG3 GLU A  36     -13.831  55.108   4.862  1.00  0.00           H  
ATOM    522  N   CYS A  37     -14.540  51.502   8.066  1.00  0.00           N  
ATOM    523  CA  CYS A  37     -15.305  50.467   8.761  1.00  0.00           C  
ATOM    524  C   CYS A  37     -14.414  49.683   9.720  1.00  0.00           C  
ATOM    525  O   CYS A  37     -14.908  48.939  10.568  1.00  0.00           O  
ATOM    526  CB  CYS A  37     -15.975  49.498   7.776  1.00  0.00           C  
ATOM    527  SG  CYS A  37     -14.858  48.719   6.591  1.00  0.00           S  
ATOM    528  H   CYS A  37     -14.370  51.414   7.105  1.00  0.00           H  
ATOM    529  HA  CYS A  37     -16.073  50.963   9.336  1.00  0.00           H  
ATOM    530  HB2 CYS A  37     -16.439  48.704   8.339  1.00  0.00           H  
ATOM    531  HB3 CYS A  37     -16.734  50.020   7.219  1.00  0.00           H  
ATOM    532  N   GLY A  38     -13.101  49.850   9.583  1.00  0.00           N  
ATOM    533  CA  GLY A  38     -12.176  49.144  10.446  1.00  0.00           C  
ATOM    534  C   GLY A  38     -12.303  47.642  10.311  1.00  0.00           C  
ATOM    535  O   GLY A  38     -12.495  46.936  11.302  1.00  0.00           O  
ATOM    536  H   GLY A  38     -12.758  50.450   8.891  1.00  0.00           H  
ATOM    537  HA2 GLY A  38     -11.168  49.435  10.193  1.00  0.00           H  
ATOM    538  HA3 GLY A  38     -12.373  49.420  11.471  1.00  0.00           H  
ATOM    539  N   LEU A  39     -12.196  47.149   9.081  1.00  0.00           N  
ATOM    540  CA  LEU A  39     -12.302  45.719   8.828  1.00  0.00           C  
ATOM    541  C   LEU A  39     -10.917  45.091   8.723  1.00  0.00           C  
ATOM    542  O   LEU A  39      -9.907  45.784   8.830  1.00  0.00           O  
ATOM    543  CB  LEU A  39     -13.107  45.459   7.547  1.00  0.00           C  
ATOM    544  CG  LEU A  39     -12.313  45.550   6.241  1.00  0.00           C  
ATOM    545  CD1 LEU A  39     -11.892  44.164   5.774  1.00  0.00           C  
ATOM    546  CD2 LEU A  39     -13.131  46.252   5.167  1.00  0.00           C  
ATOM    547  H   LEU A  39     -12.040  47.761   8.328  1.00  0.00           H  
ATOM    548  HA  LEU A  39     -12.821  45.274   9.663  1.00  0.00           H  
ATOM    549  HB2 LEU A  39     -13.536  44.470   7.615  1.00  0.00           H  
ATOM    550  HB3 LEU A  39     -13.911  46.177   7.504  1.00  0.00           H  
ATOM    551  HG  LEU A  39     -11.417  46.129   6.412  1.00  0.00           H  
ATOM    552 HD11 LEU A  39     -11.987  44.101   4.700  1.00  0.00           H  
ATOM    553 HD12 LEU A  39     -12.526  43.421   6.235  1.00  0.00           H  
ATOM    554 HD13 LEU A  39     -10.866  43.986   6.057  1.00  0.00           H  
ATOM    555 HD21 LEU A  39     -13.005  47.320   5.258  1.00  0.00           H  
ATOM    556 HD22 LEU A  39     -14.174  46.000   5.287  1.00  0.00           H  
ATOM    557 HD23 LEU A  39     -12.794  45.932   4.192  1.00  0.00           H  
ATOM    558  N   VAL A  40     -10.882  43.778   8.518  1.00  0.00           N  
ATOM    559  CA  VAL A  40      -9.623  43.053   8.402  1.00  0.00           C  
ATOM    560  C   VAL A  40      -9.748  41.892   7.421  1.00  0.00           C  
ATOM    561  O   VAL A  40     -10.138  40.788   7.798  1.00  0.00           O  
ATOM    562  CB  VAL A  40      -9.169  42.506   9.768  1.00  0.00           C  
ATOM    563  CG1 VAL A  40      -7.778  41.899   9.667  1.00  0.00           C  
ATOM    564  CG2 VAL A  40      -9.206  43.603  10.821  1.00  0.00           C  
ATOM    565  H   VAL A  40     -11.724  43.284   8.445  1.00  0.00           H  
ATOM    566  HA  VAL A  40      -8.871  43.741   8.042  1.00  0.00           H  
ATOM    567  HB  VAL A  40      -9.857  41.729  10.065  1.00  0.00           H  
ATOM    568 HG11 VAL A  40      -7.830  40.970   9.118  1.00  0.00           H  
ATOM    569 HG12 VAL A  40      -7.395  41.711  10.659  1.00  0.00           H  
ATOM    570 HG13 VAL A  40      -7.122  42.585   9.153  1.00  0.00           H  
ATOM    571 HG21 VAL A  40      -8.888  44.536  10.382  1.00  0.00           H  
ATOM    572 HG22 VAL A  40      -8.544  43.343  11.634  1.00  0.00           H  
ATOM    573 HG23 VAL A  40     -10.214  43.706  11.197  1.00  0.00           H  
ATOM    574  N   VAL A  41      -9.413  42.148   6.160  1.00  0.00           N  
ATOM    575  CA  VAL A  41      -9.488  41.120   5.128  1.00  0.00           C  
ATOM    576  C   VAL A  41      -8.120  40.495   4.871  1.00  0.00           C  
ATOM    577  O   VAL A  41      -7.129  41.200   4.683  1.00  0.00           O  
ATOM    578  CB  VAL A  41     -10.043  41.689   3.806  1.00  0.00           C  
ATOM    579  CG1 VAL A  41      -9.107  42.746   3.236  1.00  0.00           C  
ATOM    580  CG2 VAL A  41     -10.273  40.571   2.799  1.00  0.00           C  
ATOM    581  H   VAL A  41      -9.109  43.047   5.919  1.00  0.00           H  
ATOM    582  HA  VAL A  41     -10.163  40.351   5.475  1.00  0.00           H  
ATOM    583  HB  VAL A  41     -10.994  42.157   4.012  1.00  0.00           H  
ATOM    584 HG11 VAL A  41      -8.504  43.159   4.031  1.00  0.00           H  
ATOM    585 HG12 VAL A  41      -9.689  43.533   2.780  1.00  0.00           H  
ATOM    586 HG13 VAL A  41      -8.466  42.296   2.494  1.00  0.00           H  
ATOM    587 HG21 VAL A  41      -9.366  40.402   2.237  1.00  0.00           H  
ATOM    588 HG22 VAL A  41     -11.068  40.853   2.124  1.00  0.00           H  
ATOM    589 HG23 VAL A  41     -10.547  39.667   3.321  1.00  0.00           H  
ATOM    590  N   GLY A  42      -8.075  39.166   4.865  1.00  0.00           N  
ATOM    591  CA  GLY A  42      -6.824  38.468   4.631  1.00  0.00           C  
ATOM    592  C   GLY A  42      -6.115  38.101   5.919  1.00  0.00           C  
ATOM    593  O   GLY A  42      -5.030  38.609   6.204  1.00  0.00           O  
ATOM    594  H   GLY A  42      -8.897  38.657   5.022  1.00  0.00           H  
ATOM    595  HA2 GLY A  42      -7.028  37.564   4.076  1.00  0.00           H  
ATOM    596  HA3 GLY A  42      -6.176  39.101   4.044  1.00  0.00           H  
ATOM    597  N   ASP A  43      -6.729  37.219   6.701  1.00  0.00           N  
ATOM    598  CA  ASP A  43      -6.150  36.784   7.967  1.00  0.00           C  
ATOM    599  C   ASP A  43      -5.226  35.587   7.762  1.00  0.00           C  
ATOM    600  O   ASP A  43      -4.243  35.419   8.484  1.00  0.00           O  
ATOM    601  CB  ASP A  43      -7.255  36.426   8.962  1.00  0.00           C  
ATOM    602  CG  ASP A  43      -8.212  37.578   9.199  1.00  0.00           C  
ATOM    603  OD1 ASP A  43      -7.777  38.607   9.757  1.00  0.00           O  
ATOM    604  OD2 ASP A  43      -9.399  37.449   8.829  1.00  0.00           O  
ATOM    605  H   ASP A  43      -7.593  36.850   6.419  1.00  0.00           H  
ATOM    606  HA  ASP A  43      -5.572  37.604   8.364  1.00  0.00           H  
ATOM    607  HB2 ASP A  43      -7.817  35.588   8.580  1.00  0.00           H  
ATOM    608  HB3 ASP A  43      -6.807  36.154   9.906  1.00  0.00           H  
ATOM    609  N   ARG A  44      -5.549  34.760   6.774  1.00  0.00           N  
ATOM    610  CA  ARG A  44      -4.748  33.578   6.475  1.00  0.00           C  
ATOM    611  C   ARG A  44      -3.443  33.967   5.786  1.00  0.00           C  
ATOM    612  O   ARG A  44      -3.260  35.116   5.385  1.00  0.00           O  
ATOM    613  CB  ARG A  44      -5.537  32.613   5.589  1.00  0.00           C  
ATOM    614  CG  ARG A  44      -6.150  33.274   4.364  1.00  0.00           C  
ATOM    615  CD  ARG A  44      -5.856  32.487   3.097  1.00  0.00           C  
ATOM    616  NE  ARG A  44      -6.767  31.359   2.929  1.00  0.00           N  
ATOM    617  CZ  ARG A  44      -8.041  31.483   2.560  1.00  0.00           C  
ATOM    618  NH1 ARG A  44      -8.555  32.683   2.319  1.00  0.00           N  
ATOM    619  NH2 ARG A  44      -8.801  30.405   2.431  1.00  0.00           N  
ATOM    620  H   ARG A  44      -6.344  34.948   6.233  1.00  0.00           H  
ATOM    621  HA  ARG A  44      -4.516  33.090   7.409  1.00  0.00           H  
ATOM    622  HB2 ARG A  44      -4.875  31.827   5.256  1.00  0.00           H  
ATOM    623  HB3 ARG A  44      -6.334  32.177   6.173  1.00  0.00           H  
ATOM    624  HG2 ARG A  44      -7.220  33.334   4.498  1.00  0.00           H  
ATOM    625  HG3 ARG A  44      -5.742  34.269   4.264  1.00  0.00           H  
ATOM    626  HD2 ARG A  44      -5.954  33.147   2.248  1.00  0.00           H  
ATOM    627  HD3 ARG A  44      -4.842  32.115   3.147  1.00  0.00           H  
ATOM    628  HE  ARG A  44      -6.413  30.461   3.100  1.00  0.00           H  
ATOM    629 HH11 ARG A  44      -7.986  33.500   2.414  1.00  0.00           H  
ATOM    630 HH12 ARG A  44      -9.512  32.770   2.042  1.00  0.00           H  
ATOM    631 HH21 ARG A  44      -8.419  29.499   2.610  1.00  0.00           H  
ATOM    632 HH22 ARG A  44      -9.758  30.498   2.153  1.00  0.00           H  
ATOM    633  N   VAL A  45      -2.540  33.001   5.653  1.00  0.00           N  
ATOM    634  CA  VAL A  45      -1.253  33.241   5.013  1.00  0.00           C  
ATOM    635  C   VAL A  45      -0.847  32.061   4.138  1.00  0.00           C  
ATOM    636  O   VAL A  45      -0.398  31.029   4.638  1.00  0.00           O  
ATOM    637  CB  VAL A  45      -0.146  33.498   6.054  1.00  0.00           C  
ATOM    638  CG1 VAL A  45       1.138  33.939   5.370  1.00  0.00           C  
ATOM    639  CG2 VAL A  45      -0.600  34.534   7.071  1.00  0.00           C  
ATOM    640  H   VAL A  45      -2.745  32.105   5.993  1.00  0.00           H  
ATOM    641  HA  VAL A  45      -1.347  34.121   4.393  1.00  0.00           H  
ATOM    642  HB  VAL A  45       0.050  32.574   6.576  1.00  0.00           H  
ATOM    643 HG11 VAL A  45       1.460  33.173   4.679  1.00  0.00           H  
ATOM    644 HG12 VAL A  45       1.906  34.096   6.114  1.00  0.00           H  
ATOM    645 HG13 VAL A  45       0.963  34.858   4.833  1.00  0.00           H  
ATOM    646 HG21 VAL A  45      -1.035  34.034   7.924  1.00  0.00           H  
ATOM    647 HG22 VAL A  45      -1.337  35.183   6.621  1.00  0.00           H  
ATOM    648 HG23 VAL A  45       0.249  35.120   7.391  1.00  0.00           H  
ATOM    649  N   ILE A  46      -1.006  32.219   2.828  1.00  0.00           N  
ATOM    650  CA  ILE A  46      -0.656  31.166   1.883  1.00  0.00           C  
ATOM    651  C   ILE A  46       0.823  30.803   1.990  1.00  0.00           C  
ATOM    652  O   ILE A  46       1.675  31.426   1.356  1.00  0.00           O  
ATOM    653  CB  ILE A  46      -0.979  31.583   0.433  1.00  0.00           C  
ATOM    654  CG1 ILE A  46      -0.642  30.450  -0.540  1.00  0.00           C  
ATOM    655  CG2 ILE A  46      -0.224  32.851   0.062  1.00  0.00           C  
ATOM    656  CD1 ILE A  46      -1.727  30.189  -1.564  1.00  0.00           C  
ATOM    657  H   ILE A  46      -1.368  33.064   2.489  1.00  0.00           H  
ATOM    658  HA  ILE A  46      -1.247  30.294   2.124  1.00  0.00           H  
ATOM    659  HB  ILE A  46      -2.036  31.795   0.372  1.00  0.00           H  
ATOM    660 HG12 ILE A  46       0.263  30.698  -1.076  1.00  0.00           H  
ATOM    661 HG13 ILE A  46      -0.486  29.538   0.017  1.00  0.00           H  
ATOM    662 HG21 ILE A  46      -0.806  33.422  -0.646  1.00  0.00           H  
ATOM    663 HG22 ILE A  46       0.725  32.589  -0.381  1.00  0.00           H  
ATOM    664 HG23 ILE A  46      -0.057  33.443   0.949  1.00  0.00           H  
ATOM    665 HD11 ILE A  46      -1.652  29.172  -1.917  1.00  0.00           H  
ATOM    666 HD12 ILE A  46      -1.608  30.869  -2.395  1.00  0.00           H  
ATOM    667 HD13 ILE A  46      -2.694  30.342  -1.109  1.00  0.00           H  
ATOM    668  N   ASP A  47       1.121  29.792   2.800  1.00  0.00           N  
ATOM    669  CA  ASP A  47       2.495  29.346   2.992  1.00  0.00           C  
ATOM    670  C   ASP A  47       2.775  28.084   2.183  1.00  0.00           C  
ATOM    671  O   ASP A  47       2.559  26.968   2.657  1.00  0.00           O  
ATOM    672  CB  ASP A  47       2.766  29.086   4.475  1.00  0.00           C  
ATOM    673  CG  ASP A  47       3.361  30.292   5.174  1.00  0.00           C  
ATOM    674  OD1 ASP A  47       4.574  30.537   5.007  1.00  0.00           O  
ATOM    675  OD2 ASP A  47       2.614  30.993   5.889  1.00  0.00           O  
ATOM    676  H   ASP A  47       0.398  29.336   3.279  1.00  0.00           H  
ATOM    677  HA  ASP A  47       3.150  30.132   2.649  1.00  0.00           H  
ATOM    678  HB2 ASP A  47       1.838  28.831   4.965  1.00  0.00           H  
ATOM    679  HB3 ASP A  47       3.457  28.261   4.570  1.00  0.00           H  
ATOM    680  N   VAL A  48       3.258  28.267   0.957  1.00  0.00           N  
ATOM    681  CA  VAL A  48       3.569  27.144   0.082  1.00  0.00           C  
ATOM    682  C   VAL A  48       5.067  27.054  -0.186  1.00  0.00           C  
ATOM    683  O   VAL A  48       5.553  27.519  -1.216  1.00  0.00           O  
ATOM    684  CB  VAL A  48       2.825  27.256  -1.262  1.00  0.00           C  
ATOM    685  CG1 VAL A  48       2.999  25.985  -2.077  1.00  0.00           C  
ATOM    686  CG2 VAL A  48       1.350  27.554  -1.033  1.00  0.00           C  
ATOM    687  H   VAL A  48       3.410  29.180   0.635  1.00  0.00           H  
ATOM    688  HA  VAL A  48       3.245  26.238   0.574  1.00  0.00           H  
ATOM    689  HB  VAL A  48       3.253  28.077  -1.820  1.00  0.00           H  
ATOM    690 HG11 VAL A  48       2.098  25.792  -2.641  1.00  0.00           H  
ATOM    691 HG12 VAL A  48       3.193  25.156  -1.414  1.00  0.00           H  
ATOM    692 HG13 VAL A  48       3.830  26.104  -2.758  1.00  0.00           H  
ATOM    693 HG21 VAL A  48       0.875  26.696  -0.583  1.00  0.00           H  
ATOM    694 HG22 VAL A  48       0.877  27.774  -1.979  1.00  0.00           H  
ATOM    695 HG23 VAL A  48       1.253  28.405  -0.375  1.00  0.00           H  
ATOM    696  N   GLY A  49       5.794  26.452   0.749  1.00  0.00           N  
ATOM    697  CA  GLY A  49       7.231  26.311   0.595  1.00  0.00           C  
ATOM    698  C   GLY A  49       7.609  25.094  -0.224  1.00  0.00           C  
ATOM    699  O   GLY A  49       7.749  23.995   0.313  1.00  0.00           O  
ATOM    700  H   GLY A  49       5.352  26.100   1.551  1.00  0.00           H  
ATOM    701  HA2 GLY A  49       7.617  27.194   0.109  1.00  0.00           H  
ATOM    702  HA3 GLY A  49       7.679  26.227   1.574  1.00  0.00           H  
ATOM    703  N   SER A  50       7.773  25.288  -1.528  1.00  0.00           N  
ATOM    704  CA  SER A  50       8.137  24.196  -2.423  1.00  0.00           C  
ATOM    705  C   SER A  50       8.676  24.731  -3.746  1.00  0.00           C  
ATOM    706  O   SER A  50       8.480  24.125  -4.798  1.00  0.00           O  
ATOM    707  CB  SER A  50       6.928  23.295  -2.680  1.00  0.00           C  
ATOM    708  OG  SER A  50       7.326  21.949  -2.868  1.00  0.00           O  
ATOM    709  H   SER A  50       7.647  26.186  -1.897  1.00  0.00           H  
ATOM    710  HA  SER A  50       8.911  23.616  -1.941  1.00  0.00           H  
ATOM    711  HB2 SER A  50       6.259  23.344  -1.834  1.00  0.00           H  
ATOM    712  HB3 SER A  50       6.413  23.633  -3.567  1.00  0.00           H  
ATOM    713  HG  SER A  50       8.021  21.908  -3.528  1.00  0.00           H  
ATOM    714  N   GLU A  51       9.357  25.871  -3.684  1.00  0.00           N  
ATOM    715  CA  GLU A  51       9.925  26.487  -4.879  1.00  0.00           C  
ATOM    716  C   GLU A  51      11.420  26.757  -4.708  1.00  0.00           C  
ATOM    717  O   GLU A  51      12.025  27.453  -5.523  1.00  0.00           O  
ATOM    718  CB  GLU A  51       9.193  27.792  -5.199  1.00  0.00           C  
ATOM    719  CG  GLU A  51       8.103  27.637  -6.246  1.00  0.00           C  
ATOM    720  CD  GLU A  51       8.655  27.576  -7.657  1.00  0.00           C  
ATOM    721  OE1 GLU A  51       9.193  28.600  -8.129  1.00  0.00           O  
ATOM    722  OE2 GLU A  51       8.548  26.506  -8.290  1.00  0.00           O  
ATOM    723  H   GLU A  51       9.481  26.308  -2.815  1.00  0.00           H  
ATOM    724  HA  GLU A  51       9.789  25.801  -5.701  1.00  0.00           H  
ATOM    725  HB2 GLU A  51       8.741  28.169  -4.293  1.00  0.00           H  
ATOM    726  HB3 GLU A  51       9.909  28.516  -5.561  1.00  0.00           H  
ATOM    727  HG2 GLU A  51       7.560  26.725  -6.050  1.00  0.00           H  
ATOM    728  HG3 GLU A  51       7.429  28.479  -6.174  1.00  0.00           H  
ATOM    729  N   TRP A  52      12.010  26.202  -3.650  1.00  0.00           N  
ATOM    730  CA  TRP A  52      13.433  26.383  -3.375  1.00  0.00           C  
ATOM    731  C   TRP A  52      13.746  27.834  -3.017  1.00  0.00           C  
ATOM    732  O   TRP A  52      14.131  28.134  -1.888  1.00  0.00           O  
ATOM    733  CB  TRP A  52      14.273  25.950  -4.581  1.00  0.00           C  
ATOM    734  CG  TRP A  52      14.021  24.534  -5.001  1.00  0.00           C  
ATOM    735  CD1 TRP A  52      14.538  23.407  -4.432  1.00  0.00           C  
ATOM    736  CD2 TRP A  52      13.190  24.095  -6.082  1.00  0.00           C  
ATOM    737  NE1 TRP A  52      14.079  22.292  -5.092  1.00  0.00           N  
ATOM    738  CE2 TRP A  52      13.251  22.689  -6.109  1.00  0.00           C  
ATOM    739  CE3 TRP A  52      12.401  24.753  -7.029  1.00  0.00           C  
ATOM    740  CZ2 TRP A  52      12.552  21.932  -7.046  1.00  0.00           C  
ATOM    741  CZ3 TRP A  52      11.708  24.000  -7.959  1.00  0.00           C  
ATOM    742  CH2 TRP A  52      11.787  22.602  -7.961  1.00  0.00           C  
ATOM    743  H   TRP A  52      11.475  25.656  -3.036  1.00  0.00           H  
ATOM    744  HA  TRP A  52      13.687  25.759  -2.532  1.00  0.00           H  
ATOM    745  HB2 TRP A  52      14.048  26.591  -5.419  1.00  0.00           H  
ATOM    746  HB3 TRP A  52      15.320  26.044  -4.333  1.00  0.00           H  
ATOM    747  HD1 TRP A  52      15.209  23.405  -3.586  1.00  0.00           H  
ATOM    748  HE1 TRP A  52      14.308  21.365  -4.871  1.00  0.00           H  
ATOM    749  HE3 TRP A  52      12.328  25.831  -7.043  1.00  0.00           H  
ATOM    750  HZ2 TRP A  52      12.602  20.852  -7.060  1.00  0.00           H  
ATOM    751  HZ3 TRP A  52      11.094  24.492  -8.698  1.00  0.00           H  
ATOM    752  HH2 TRP A  52      11.229  22.055  -8.706  1.00  0.00           H  
ATOM    753  N   ARG A  53      13.578  28.729  -3.986  1.00  0.00           N  
ATOM    754  CA  ARG A  53      13.842  30.149  -3.774  1.00  0.00           C  
ATOM    755  C   ARG A  53      15.334  30.399  -3.577  1.00  0.00           C  
ATOM    756  O   ARG A  53      15.825  30.429  -2.448  1.00  0.00           O  
ATOM    757  CB  ARG A  53      13.058  30.667  -2.565  1.00  0.00           C  
ATOM    758  CG  ARG A  53      12.364  31.995  -2.813  1.00  0.00           C  
ATOM    759  CD  ARG A  53      13.357  33.077  -3.207  1.00  0.00           C  
ATOM    760  NE  ARG A  53      12.784  34.415  -3.088  1.00  0.00           N  
ATOM    761  CZ  ARG A  53      13.477  35.537  -3.271  1.00  0.00           C  
ATOM    762  NH1 ARG A  53      14.765  35.487  -3.582  1.00  0.00           N  
ATOM    763  NH2 ARG A  53      12.878  36.714  -3.142  1.00  0.00           N  
ATOM    764  H   ARG A  53      13.269  28.429  -4.866  1.00  0.00           H  
ATOM    765  HA  ARG A  53      13.516  30.680  -4.656  1.00  0.00           H  
ATOM    766  HB2 ARG A  53      12.306  29.938  -2.300  1.00  0.00           H  
ATOM    767  HB3 ARG A  53      13.736  30.788  -1.733  1.00  0.00           H  
ATOM    768  HG2 ARG A  53      11.646  31.873  -3.610  1.00  0.00           H  
ATOM    769  HG3 ARG A  53      11.854  32.299  -1.910  1.00  0.00           H  
ATOM    770  HD2 ARG A  53      14.221  33.007  -2.563  1.00  0.00           H  
ATOM    771  HD3 ARG A  53      13.658  32.915  -4.232  1.00  0.00           H  
ATOM    772  HE  ARG A  53      11.834  34.482  -2.858  1.00  0.00           H  
ATOM    773 HH11 ARG A  53      15.223  34.604  -3.680  1.00  0.00           H  
ATOM    774 HH12 ARG A  53      15.280  36.334  -3.718  1.00  0.00           H  
ATOM    775 HH21 ARG A  53      11.907  36.757  -2.908  1.00  0.00           H  
ATOM    776 HH22 ARG A  53      13.397  37.556  -3.280  1.00  0.00           H  
ATOM    777  N   THR A  54      16.049  30.579  -4.682  1.00  0.00           N  
ATOM    778  CA  THR A  54      17.485  30.827  -4.632  1.00  0.00           C  
ATOM    779  C   THR A  54      17.961  31.523  -5.903  1.00  0.00           C  
ATOM    780  O   THR A  54      17.238  31.584  -6.898  1.00  0.00           O  
ATOM    781  CB  THR A  54      18.243  29.511  -4.442  1.00  0.00           C  
ATOM    782  OG1 THR A  54      17.605  28.702  -3.472  1.00  0.00           O  
ATOM    783  CG2 THR A  54      19.680  29.704  -4.008  1.00  0.00           C  
ATOM    784  H   THR A  54      15.600  30.544  -5.553  1.00  0.00           H  
ATOM    785  HA  THR A  54      17.682  31.470  -3.788  1.00  0.00           H  
ATOM    786  HB  THR A  54      18.251  28.974  -5.380  1.00  0.00           H  
ATOM    787  HG1 THR A  54      16.890  28.211  -3.883  1.00  0.00           H  
ATOM    788 HG21 THR A  54      19.966  28.901  -3.344  1.00  0.00           H  
ATOM    789 HG22 THR A  54      19.776  30.649  -3.493  1.00  0.00           H  
ATOM    790 HG23 THR A  54      20.321  29.701  -4.876  1.00  0.00           H  
ATOM    791  N   PHE A  55      19.183  32.044  -5.863  1.00  0.00           N  
ATOM    792  CA  PHE A  55      19.755  32.735  -7.015  1.00  0.00           C  
ATOM    793  C   PHE A  55      20.512  31.760  -7.911  1.00  0.00           C  
ATOM    794  O   PHE A  55      21.712  31.910  -8.141  1.00  0.00           O  
ATOM    795  CB  PHE A  55      20.687  33.863  -6.558  1.00  0.00           C  
ATOM    796  CG  PHE A  55      21.586  33.486  -5.413  1.00  0.00           C  
ATOM    797  CD1 PHE A  55      22.830  32.921  -5.648  1.00  0.00           C  
ATOM    798  CD2 PHE A  55      21.185  33.698  -4.103  1.00  0.00           C  
ATOM    799  CE1 PHE A  55      23.657  32.574  -4.597  1.00  0.00           C  
ATOM    800  CE2 PHE A  55      22.009  33.352  -3.049  1.00  0.00           C  
ATOM    801  CZ  PHE A  55      23.247  32.790  -3.296  1.00  0.00           C  
ATOM    802  H   PHE A  55      19.710  31.961  -5.043  1.00  0.00           H  
ATOM    803  HA  PHE A  55      18.941  33.162  -7.580  1.00  0.00           H  
ATOM    804  HB2 PHE A  55      21.314  34.158  -7.386  1.00  0.00           H  
ATOM    805  HB3 PHE A  55      20.090  34.708  -6.247  1.00  0.00           H  
ATOM    806  HD1 PHE A  55      23.152  32.752  -6.664  1.00  0.00           H  
ATOM    807  HD2 PHE A  55      20.219  34.137  -3.909  1.00  0.00           H  
ATOM    808  HE1 PHE A  55      24.624  32.134  -4.792  1.00  0.00           H  
ATOM    809  HE2 PHE A  55      21.686  33.523  -2.033  1.00  0.00           H  
ATOM    810  HZ  PHE A  55      23.892  32.521  -2.473  1.00  0.00           H  
ATOM    811  N   SER A  56      19.799  30.757  -8.415  1.00  0.00           N  
ATOM    812  CA  SER A  56      20.398  29.754  -9.288  1.00  0.00           C  
ATOM    813  C   SER A  56      21.483  28.973  -8.554  1.00  0.00           C  
ATOM    814  O   SER A  56      22.157  29.505  -7.672  1.00  0.00           O  
ATOM    815  CB  SER A  56      20.986  30.415 -10.536  1.00  0.00           C  
ATOM    816  OG  SER A  56      20.128  31.432 -11.026  1.00  0.00           O  
ATOM    817  H   SER A  56      18.847  30.691  -8.195  1.00  0.00           H  
ATOM    818  HA  SER A  56      19.619  29.069  -9.588  1.00  0.00           H  
ATOM    819  HB2 SER A  56      21.941  30.856 -10.292  1.00  0.00           H  
ATOM    820  HB3 SER A  56      21.119  29.670 -11.307  1.00  0.00           H  
ATOM    821  HG  SER A  56      20.334  32.262 -10.593  1.00  0.00           H  
ATOM    822  N   ASN A  57      21.646  27.707  -8.925  1.00  0.00           N  
ATOM    823  CA  ASN A  57      22.650  26.852  -8.302  1.00  0.00           C  
ATOM    824  C   ASN A  57      24.052  27.232  -8.768  1.00  0.00           C  
ATOM    825  O   ASN A  57      24.225  27.816  -9.838  1.00  0.00           O  
ATOM    826  CB  ASN A  57      22.368  25.382  -8.626  1.00  0.00           C  
ATOM    827  CG  ASN A  57      22.199  24.538  -7.377  1.00  0.00           C  
ATOM    828  OD1 ASN A  57      21.485  24.919  -6.449  1.00  0.00           O  
ATOM    829  ND2 ASN A  57      22.855  23.384  -7.349  1.00  0.00           N  
ATOM    830  H   ASN A  57      21.079  27.339  -9.634  1.00  0.00           H  
ATOM    831  HA  ASN A  57      22.589  26.995  -7.234  1.00  0.00           H  
ATOM    832  HB2 ASN A  57      21.461  25.316  -9.207  1.00  0.00           H  
ATOM    833  HB3 ASN A  57      23.190  24.980  -9.201  1.00  0.00           H  
ATOM    834 HD21 ASN A  57      23.406  23.146  -8.125  1.00  0.00           H  
ATOM    835 HD22 ASN A  57      22.763  22.818  -6.554  1.00  0.00           H  
ATOM    836  N   ASP A  58      25.051  26.897  -7.957  1.00  0.00           N  
ATOM    837  CA  ASP A  58      26.438  27.202  -8.287  1.00  0.00           C  
ATOM    838  C   ASP A  58      27.056  26.090  -9.127  1.00  0.00           C  
ATOM    839  O   ASP A  58      27.914  26.341  -9.974  1.00  0.00           O  
ATOM    840  CB  ASP A  58      27.254  27.406  -7.010  1.00  0.00           C  
ATOM    841  CG  ASP A  58      28.528  28.190  -7.256  1.00  0.00           C  
ATOM    842  OD1 ASP A  58      29.521  27.583  -7.707  1.00  0.00           O  
ATOM    843  OD2 ASP A  58      28.532  29.412  -6.998  1.00  0.00           O  
ATOM    844  H   ASP A  58      24.849  26.432  -7.118  1.00  0.00           H  
ATOM    845  HA  ASP A  58      26.448  28.117  -8.859  1.00  0.00           H  
ATOM    846  HB2 ASP A  58      26.656  27.944  -6.289  1.00  0.00           H  
ATOM    847  HB3 ASP A  58      27.520  26.442  -6.602  1.00  0.00           H  
ATOM    848  N   LYS A  59      26.615  24.859  -8.889  1.00  0.00           N  
ATOM    849  CA  LYS A  59      27.124  23.708  -9.624  1.00  0.00           C  
ATOM    850  C   LYS A  59      26.260  23.419 -10.847  1.00  0.00           C  
ATOM    851  O   LYS A  59      25.074  23.748 -10.873  1.00  0.00           O  
ATOM    852  CB  LYS A  59      27.174  22.478  -8.714  1.00  0.00           C  
ATOM    853  CG  LYS A  59      28.570  22.157  -8.202  1.00  0.00           C  
ATOM    854  CD  LYS A  59      28.680  22.372  -6.700  1.00  0.00           C  
ATOM    855  CE  LYS A  59      28.504  23.838  -6.332  1.00  0.00           C  
ATOM    856  NZ  LYS A  59      27.213  24.084  -5.633  1.00  0.00           N  
ATOM    857  OXT LYS A  59      26.834  22.758 -11.978  1.00  0.00           O  
ATOM    858  H   LYS A  59      25.930  24.722  -8.201  1.00  0.00           H  
ATOM    859  HA  LYS A  59      28.126  23.942  -9.953  1.00  0.00           H  
ATOM    860  HB2 LYS A  59      26.531  22.648  -7.863  1.00  0.00           H  
ATOM    861  HB3 LYS A  59      26.811  21.622  -9.263  1.00  0.00           H  
ATOM    862  HG2 LYS A  59      28.795  21.125  -8.423  1.00  0.00           H  
ATOM    863  HG3 LYS A  59      29.282  22.798  -8.702  1.00  0.00           H  
ATOM    864  HD2 LYS A  59      27.914  21.794  -6.206  1.00  0.00           H  
ATOM    865  HD3 LYS A  59      29.654  22.041  -6.369  1.00  0.00           H  
ATOM    866  HE2 LYS A  59      29.316  24.131  -5.681  1.00  0.00           H  
ATOM    867  HE3 LYS A  59      28.536  24.431  -7.234  1.00  0.00           H  
ATOM    868  HZ1 LYS A  59      27.339  24.802  -4.891  1.00  0.00           H  
ATOM    869  HZ2 LYS A  59      26.869  23.206  -5.196  1.00  0.00           H  
ATOM    870  HZ3 LYS A  59      26.500  24.423  -6.311  1.00  0.00           H  
TER     871      LYS A  59                                                      
END
MOLECULE T0480.pdb
ATOM     43  N   PHE    20      -9.421  47.124  -2.332  1.00  0.00
ATOM     44  HN  PHE    20      -9.663  47.024  -3.278  1.00  0.00
ATOM     45  CA  PHE    20     -10.050  48.188  -1.549  1.00  0.00
ATOM     46  HA  PHE    20      -9.287  48.642  -0.932  1.00  0.00
ATOM     47  CB  PHE    20     -10.641  49.260  -2.478  1.00  0.00
ATOM     48  HB1 PHE    20     -11.197  49.974  -1.885  1.00  0.00
ATOM     49  HB2 PHE    20     -11.316  48.788  -3.178  1.00  0.00
ATOM     50  CG  PHE    20      -9.613  50.019  -3.274  1.00  0.00
ATOM     51  CD1 PHE    20      -9.119  49.504  -4.460  1.00  0.00
ATOM     52  HD1 PHE    20      -9.476  48.547  -4.813  1.00  0.00
ATOM     53  CD2 PHE    20      -9.145  51.251  -2.836  1.00  0.00
ATOM     54  HD2 PHE    20      -9.523  51.664  -1.912  1.00  0.00
ATOM     55  CE1 PHE    20      -8.180  50.199  -5.195  1.00  0.00
ATOM     56  HE1 PHE    20      -7.803  49.783  -6.119  1.00  0.00
ATOM     57  CE2 PHE    20      -8.206  51.949  -3.568  1.00  0.00
ATOM     58  HE2 PHE    20      -7.850  52.908  -3.217  1.00  0.00
ATOM     59  CZ  PHE    20      -7.722  51.422  -4.750  1.00  0.00
ATOM     60  HZ  PHE    20      -6.988  51.966  -5.326  1.00  0.00
ATOM     61  C   PHE    20     -11.149  47.641  -0.643  1.00  0.00
ATOM     62  O   PHE    20     -11.503  46.465  -0.706  1.00  0.00
ATOM     63  N   CYS    21     -11.685  48.510   0.204  1.00  0.00
ATOM     64  HN  CYS    21     -11.329  49.425   0.240  1.00  0.00
ATOM     65  CA  CYS    21     -12.801  48.155   1.067  1.00  0.00
ATOM     66  HA  CYS    21     -12.726  47.105   1.318  1.00  0.00
ATOM     67  HB1 CYS    21     -12.914  50.028   2.087  1.00  0.00
ATOM     68  HB2 CYS    21     -11.760  48.898   2.773  1.00  0.00
ATOM     69  C   CYS    21     -14.100  48.414   0.312  1.00  0.00
ATOM     70  O   CYS    21     -14.384  49.557  -0.023  1.00  0.00
ATOM     71  CB  CYS    21     -12.742  48.991   2.341  1.00  0.00
ATOM     72  SG  CYS    21     -13.954  48.528   3.619  1.00  0.00
ATOM     73  N   PRO    22     -14.916  47.367   0.073  1.00  0.00
ATOM     74  CA  PRO    22     -16.026  47.404  -0.893  1.00  0.00
ATOM     75  HA  PRO    22     -15.680  47.160  -1.889  1.00  0.00
ATOM     76  CB  PRO    22     -16.958  46.298  -0.401  1.00  0.00
ATOM     77  HB1 PRO    22     -17.462  45.846  -1.245  1.00  0.00
ATOM     78  HB2 PRO    22     -17.694  46.716   0.276  1.00  0.00
ATOM     79  CG  PRO    22     -16.074  45.316   0.294  1.00  0.00
ATOM     80  HG1 PRO    22     -15.795  44.526  -0.389  1.00  0.00
ATOM     81  HG2 PRO    22     -16.602  44.907   1.141  1.00  0.00
ATOM     82  CD  PRO    22     -14.843  46.065   0.763  1.00  0.00
ATOM     83  HD1 PRO    22     -13.945  45.532   0.486  1.00  0.00
ATOM     84  HD2 PRO    22     -14.875  46.204   1.835  1.00  0.00
ATOM     85  C   PRO    22     -16.770  48.741  -0.939  1.00  0.00
ATOM     86  O   PRO    22     -16.834  49.390  -1.988  1.00  0.00
ATOM     87  N   ARG    23     -17.316  49.158   0.201  1.00  0.00
ATOM     88  HN  ARG    23     -17.154  48.653   1.025  1.00  0.00
ATOM     89  CA  ARG    23     -18.164  50.344   0.238  1.00  0.00
ATOM     90  HA  ARG    23     -18.672  50.391  -0.712  1.00  0.00
ATOM     91  CB  ARG    23     -19.223  50.223   1.341  1.00  0.00
ATOM     92  HB1 ARG    23     -19.804  51.135   1.369  1.00  0.00
ATOM     93  HB2 ARG    23     -18.724  50.096   2.291  1.00  0.00
ATOM     94  CG  ARG    23     -20.180  49.050   1.141  1.00  0.00
ATOM     95  HG1 ARG    23     -19.642  48.129   1.321  1.00  0.00
ATOM     96  HG2 ARG    23     -20.538  49.061   0.121  1.00  0.00
ATOM     97  CD  ARG    23     -21.381  49.113   2.081  1.00  0.00
ATOM     98  HD1 ARG    23     -21.999  48.242   1.910  1.00  0.00
ATOM     99  HD2 ARG    23     -21.951  50.003   1.854  1.00  0.00
ATOM    100  NE  ARG    23     -20.991  49.150   3.495  1.00  0.00
ATOM    101  HE  ARG    23     -20.100  49.512   3.706  1.00  0.00
ATOM    102  CZ  ARG    23     -21.777  48.752   4.498  1.00  0.00
ATOM    103  NH1 ARG    23     -22.967  48.220   4.250  1.00  0.00
ATOM    104 HH11 ARG    23     -23.285  48.110   3.303  1.00  0.00
ATOM    105 HH12 ARG    23     -23.556  47.929   5.009  1.00  0.00
ATOM    106  NH2 ARG    23     -21.364  48.866   5.751  1.00  0.00
ATOM    107 HH21 ARG    23     -20.460  49.252   5.953  1.00  0.00
ATOM    108 HH22 ARG    23     -21.954  48.569   6.504  1.00  0.00
ATOM    109  C   ARG    23     -17.352  51.633   0.415  1.00  0.00
ATOM    110  O   ARG    23     -17.758  52.692  -0.062  1.00  0.00
ATOM    111  N   CYS    24     -16.206  51.549   1.092  1.00  0.00
ATOM    112  HN  CYS    24     -15.914  50.681   1.429  1.00  0.00
ATOM    113  CA  CYS    24     -15.370  52.739   1.328  1.00  0.00
ATOM    114  HA  CYS    24     -16.018  53.602   1.381  1.00  0.00
ATOM    115  HB1 CYS    24     -14.192  53.616   2.885  1.00  0.00
ATOM    116  HB2 CYS    24     -13.735  51.970   2.480  1.00  0.00
ATOM    117  C   CYS    24     -14.366  52.941   0.194  1.00  0.00
ATOM    118  O   CYS    24     -13.660  53.947   0.171  1.00  0.00
ATOM    119  CB  CYS    24     -14.572  52.634   2.635  1.00  0.00
ATOM    120  SG  CYS    24     -15.473  52.014   4.084  1.00  0.00
ATOM    121  N   GLY    25     -14.311  51.975  -0.727  1.00  0.00
ATOM    122  HN  GLY    25     -15.009  51.286  -0.729  1.00  0.00
ATOM    123  CA  GLY    25     -13.256  51.919  -1.735  1.00  0.00
ATOM    124  HA1 GLY    25     -13.576  51.268  -2.533  1.00  0.00
ATOM    125  HA2 GLY    25     -12.373  51.493  -1.282  1.00  0.00
ATOM    126  C   GLY    25     -12.895  53.274  -2.316  1.00  0.00
ATOM    127  O   GLY    25     -11.779  53.757  -2.106  1.00  0.00
ATOM    128  N   PRO    26     -13.818  53.919  -3.049  1.00  0.00
ATOM    129  CA  PRO    26     -13.599  55.269  -3.570  1.00  0.00
ATOM    130  HA  PRO    26     -12.703  55.315  -4.175  1.00  0.00
ATOM    131  CB  PRO    26     -14.836  55.536  -4.453  1.00  0.00
ATOM    132  HB1 PRO    26     -14.526  55.974  -5.391  1.00  0.00
ATOM    133  HB2 PRO    26     -15.511  56.212  -3.944  1.00  0.00
ATOM    134  CG  PRO    26     -15.466  54.197  -4.662  1.00  0.00
ATOM    135  HG1 PRO    26     -15.052  53.729  -5.546  1.00  0.00
ATOM    136  HG2 PRO    26     -16.537  54.305  -4.764  1.00  0.00
ATOM    137  CD  PRO    26     -15.135  53.389  -3.440  1.00  0.00
ATOM    138  HD1 PRO    26     -15.075  52.339  -3.684  1.00  0.00
ATOM    139  HD2 PRO    26     -15.868  53.560  -2.664  1.00  0.00
ATOM    140  C   PRO    26     -13.496  56.293  -2.437  1.00  0.00
ATOM    141  O   PRO    26     -14.508  56.823  -1.967  1.00  0.00
ATOM    142  N   GLY    27     -12.275  56.524  -1.966  1.00  0.00
ATOM    143  HN  GLY    27     -11.520  56.002  -2.319  1.00  0.00
ATOM    144  CA  GLY    27     -12.036  57.519  -0.932  1.00  0.00
ATOM    145  HA1 GLY    27     -12.982  57.935  -0.612  1.00  0.00
ATOM    146  HA2 GLY    27     -11.430  58.310  -1.348  1.00  0.00
ATOM    147  C   GLY    27     -11.325  56.943   0.273  1.00  0.00
ATOM    148  O   GLY    27     -10.653  57.668   1.009  1.00  0.00
ATOM    149  N   VAL    28     -11.468  55.634   0.479  1.00  0.00
ATOM    150  HN  VAL    28     -12.031  55.114  -0.136  1.00  0.00
ATOM    151  CA  VAL    28     -10.810  54.948   1.591  1.00  0.00
ATOM    152  HA  VAL    28     -10.018  55.586   1.960  1.00  0.00
ATOM    153  CB  VAL    28     -11.782  54.646   2.763  1.00  0.00
ATOM    154  HB  VAL    28     -12.477  53.886   2.424  1.00  0.00
ATOM    155  CG1 VAL    28     -11.028  54.082   3.968  1.00  0.00
ATOM    156 HG11 VAL    28     -10.300  54.803   4.309  1.00  0.00
ATOM    157 HG12 VAL    28     -10.525  53.168   3.687  1.00  0.00
ATOM    158 HG13 VAL    28     -11.728  53.875   4.766  1.00  0.00
ATOM    159  CG2 VAL    28     -12.588  55.883   3.159  1.00  0.00
ATOM    160 HG21 VAL    28     -11.917  56.666   3.482  1.00  0.00
ATOM    161 HG22 VAL    28     -13.260  55.632   3.967  1.00  0.00
ATOM    162 HG23 VAL    28     -13.162  56.229   2.311  1.00  0.00
ATOM    163  C   VAL    28     -10.205  53.631   1.123  1.00  0.00
ATOM    164  O   VAL    28     -10.910  52.621   0.993  1.00  0.00
ATOM    165  N   PHE    29      -8.907  53.645   0.861  1.00  0.00
ATOM    166  HN  PHE    29      -8.420  54.495   0.903  1.00  0.00
ATOM    167  CA  PHE    29      -8.190  52.430   0.504  1.00  0.00
ATOM    168  HA  PHE    29      -8.697  51.979  -0.339  1.00  0.00
ATOM    169  CB  PHE    29      -6.738  52.749   0.109  1.00  0.00
ATOM    170  HB1 PHE    29      -6.738  53.555  -0.613  1.00  0.00
ATOM    171  HB2 PHE    29      -6.296  51.872  -0.342  1.00  0.00
ATOM    172  CG  PHE    29      -5.864  53.166   1.270  1.00  0.00
ATOM    173  CD1 PHE    29      -4.909  52.298   1.788  1.00  0.00
ATOM    174  HD1 PHE    29      -4.786  51.319   1.348  1.00  0.00
ATOM    175  CD2 PHE    29      -6.003  54.418   1.850  1.00  0.00
ATOM    176  HD2 PHE    29      -6.739  55.104   1.458  1.00  0.00
ATOM    177  CE1 PHE    29      -4.116  52.673   2.857  1.00  0.00
ATOM    178  HE1 PHE    29      -3.377  51.988   3.249  1.00  0.00
ATOM    179  CE2 PHE    29      -5.211  54.796   2.917  1.00  0.00
ATOM    180  HE2 PHE    29      -5.331  55.775   3.358  1.00  0.00
ATOM    181  CZ  PHE    29      -4.268  53.924   3.421  1.00  0.00
ATOM    182  HZ  PHE    29      -3.650  54.219   4.258  1.00  0.00
ATOM    183  C   PHE    29      -8.210  51.449   1.679  1.00  0.00
ATOM    184  O   PHE    29      -8.458  51.838   2.825  1.00  0.00
ATOM    185  N   LEU    30      -7.958  50.182   1.396  1.00  0.00
ATOM    186  HN  LEU    30      -7.805  49.919   0.464  1.00  0.00
ATOM    187  CA  LEU    30      -7.868  49.176   2.441  1.00  0.00
ATOM    188  HA  LEU    30      -8.446  49.515   3.292  1.00  0.00
ATOM    189  CB  LEU    30      -8.437  47.841   1.939  1.00  0.00
ATOM    190  HB1 LEU    30      -7.762  47.449   1.190  1.00  0.00
ATOM    191  HB2 LEU    30      -9.389  48.040   1.467  1.00  0.00
ATOM    192  CG  LEU    30      -8.649  46.756   3.010  1.00  0.00
ATOM    193  HG  LEU    30      -7.705  46.559   3.499  1.00  0.00
ATOM    194  CD1 LEU    30      -9.637  47.226   4.075  1.00  0.00
ATOM    195 HD11 LEU    30     -10.591  47.443   3.615  1.00  0.00
ATOM    196 HD12 LEU    30      -9.257  48.119   4.550  1.00  0.00
ATOM    197 HD13 LEU    30      -9.765  46.452   4.819  1.00  0.00
ATOM    198  CD2 LEU    30      -9.129  45.452   2.368  1.00  0.00
ATOM    199 HD21 LEU    30     -10.068  45.622   1.859  1.00  0.00
ATOM    200 HD22 LEU    30      -9.268  44.701   3.133  1.00  0.00
ATOM    201 HD23 LEU    30      -8.392  45.106   1.657  1.00  0.00
ATOM    202  C   LEU    30      -6.405  49.037   2.850  1.00  0.00
ATOM    203  O   LEU    30      -5.581  48.585   2.055  1.00  0.00
ATOM    204  N   ALA    31      -6.089  49.469   4.074  1.00  0.00
ATOM    205  HN  ALA    31      -6.808  49.759   4.671  1.00  0.00
ATOM    206  CA  ALA    31      -4.708  49.517   4.560  1.00  0.00
ATOM    207  HA  ALA    31      -4.182  50.263   3.979  1.00  0.00
ATOM    208  CB  ALA    31      -4.674  49.953   6.023  1.00  0.00
ATOM    209  HB1 ALA    31      -3.648  50.043   6.352  1.00  0.00
ATOM    210  HB2 ALA    31      -5.182  49.219   6.631  1.00  0.00
ATOM    211  HB3 ALA    31      -5.167  50.908   6.126  1.00  0.00
ATOM    212  C   ALA    31      -4.007  48.174   4.380  1.00  0.00
ATOM    213  O   ALA    31      -4.101  47.290   5.237  1.00  0.00
ATOM    214  N   GLU    32      -3.331  48.023   3.246  1.00  0.00
ATOM    215  HN  GLU    32      -3.321  48.760   2.599  1.00  0.00
ATOM    216  CA  GLU    32      -2.625  46.794   2.922  1.00  0.00
ATOM    217  HA  GLU    32      -3.248  45.965   3.234  1.00  0.00
ATOM    218  CB  GLU    32      -2.386  46.686   1.408  1.00  0.00
ATOM    219  HB1 GLU    32      -1.814  47.543   1.083  1.00  0.00
ATOM    220  HB2 GLU    32      -3.342  46.691   0.903  1.00  0.00
ATOM    221  CG  GLU    32      -1.632  45.422   0.999  1.00  0.00
ATOM    222  HG1 GLU    32      -2.172  44.560   1.369  1.00  0.00
ATOM    223  HG2 GLU    32      -0.650  45.445   1.449  1.00  0.00
ATOM    224  CD  GLU    32      -1.467  45.287  -0.506  1.00  0.00
ATOM    225  OE1 GLU    32      -0.618  46.002  -1.079  1.00  0.00
ATOM    226  OE2 GLU    32      -2.171  44.448  -1.114  1.00  0.00
ATOM    227  C   GLU    32      -1.300  46.719   3.673  1.00  0.00
ATOM    228  O   GLU    32      -0.357  47.459   3.381  1.00  0.00
ATOM    229  N   HIS    33      -1.263  45.852   4.668  1.00  0.00
ATOM    230  HN  HIS    33      -2.089  45.388   4.911  1.00  0.00
ATOM    231  CA  HIS    33      -0.045  45.545   5.406  1.00  0.00
ATOM    232  HA  HIS    33       0.685  46.317   5.196  1.00  0.00
ATOM    233  CB  HIS    33      -0.317  45.503   6.914  1.00  0.00
ATOM    234  HB1 HIS    33       0.590  45.218   7.429  1.00  0.00
ATOM    235  HB2 HIS    33      -1.084  44.767   7.119  1.00  0.00
ATOM    236  CG  HIS    33      -0.772  46.815   7.476  1.00  0.00
ATOM    237  ND1 HIS    33       0.097  47.768   7.958  1.00  0.00
ATOM    238  HD1 HIS    33       1.077  47.689   7.991  1.00  0.00
ATOM    239  CD2 HIS    33      -2.014  47.330   7.633  1.00  0.00
ATOM    240  HD2 HIS    33      -2.944  46.851   7.362  1.00  0.00
ATOM    241  CE1 HIS    33      -0.589  48.809   8.385  1.00  0.00
ATOM    242  HE1 HIS    33      -0.169  49.705   8.818  1.00  0.00
ATOM    243  NE2 HIS    33      -1.873  48.572   8.199  1.00  0.00
ATOM    244  HE2 HIS    33      -2.599  49.075   8.631  1.00  0.00
ATOM    245  C   HIS    33       0.506  44.203   4.940  1.00  0.00
ATOM    246  O   HIS    33      -0.225  43.393   4.365  1.00  0.00
ATOM    247  N   ALA    34       1.782  43.964   5.214  1.00  0.00
ATOM    248  HN  ALA    34       2.282  44.621   5.746  1.00  0.00
ATOM    249  CA  ALA    34       2.468  42.759   4.751  1.00  0.00
ATOM    250  HA  ALA    34       2.479  42.779   3.670  1.00  0.00
ATOM    251  CB  ALA    34       3.914  42.763   5.235  1.00  0.00
ATOM    252  HB1 ALA    34       4.434  41.909   4.826  1.00  0.00
ATOM    253  HB2 ALA    34       3.936  42.714   6.315  1.00  0.00
ATOM    254  HB3 ALA    34       4.401  43.670   4.907  1.00  0.00
ATOM    255  C   ALA    34       1.761  41.481   5.206  1.00  0.00
ATOM    256  O   ALA    34       1.850  40.444   4.543  1.00  0.00
ATOM    257  N   ASP    35       1.049  41.561   6.329  1.00  0.00
ATOM    258  HN  ASP    35       0.954  42.428   6.773  1.00  0.00
ATOM    259  CA  ASP    35       0.416  40.383   6.923  1.00  0.00
ATOM    260  HA  ASP    35       0.770  39.510   6.392  1.00  0.00
ATOM    261  CB  ASP    35       0.816  40.251   8.399  1.00  0.00
ATOM    262  HB1 ASP    35       1.883  40.394   8.487  1.00  0.00
ATOM    263  HB2 ASP    35       0.565  39.258   8.747  1.00  0.00
ATOM    264  CG  ASP    35       0.122  41.266   9.293  1.00  0.00
ATOM    265  OD1 ASP    35       0.449  42.468   9.202  1.00  0.00
ATOM    266  OD2 ASP    35      -0.746  40.867  10.097  1.00  0.00
ATOM    267  C   ASP    35      -1.111  40.429   6.812  1.00  0.00
ATOM    268  O   ASP    35      -1.773  39.400   6.966  1.00  0.00
ATOM    269  N   ARG    36      -1.682  41.598   6.521  1.00  0.00
ATOM    270  HN  ARG    36      -1.122  42.366   6.270  1.00  0.00
ATOM    271  CA  ARG    36      -3.142  41.736   6.533  1.00  0.00
ATOM    272  HA  ARG    36      -3.550  40.949   5.917  1.00  0.00
ATOM    273  CB  ARG    36      -3.678  41.570   7.966  1.00  0.00
ATOM    274  HB1 ARG    36      -3.315  40.633   8.368  1.00  0.00
ATOM    275  HB2 ARG    36      -4.759  41.538   7.933  1.00  0.00
ATOM    276  CG  ARG    36      -3.264  42.690   8.914  1.00  0.00
ATOM    277  HG1 ARG    36      -3.731  43.611   8.594  1.00  0.00
ATOM    278  HG2 ARG    36      -2.190  42.797   8.873  1.00  0.00
ATOM    279  CD  ARG    36      -3.677  42.398  10.353  1.00  0.00
ATOM    280  HD1 ARG    36      -3.114  41.546  10.712  1.00  0.00
ATOM    281  HD2 ARG    36      -4.732  42.162  10.370  1.00  0.00
ATOM    282  NE  ARG    36      -3.436  43.539  11.239  1.00  0.00
ATOM    283  HE  ARG    36      -4.165  44.194  11.330  1.00  0.00
ATOM    284  CZ  ARG    36      -2.321  43.724  11.948  1.00  0.00
ATOM    285  NH1 ARG    36      -1.289  42.903  11.808  1.00  0.00
ATOM    286 HH11 ARG    36      -1.337  42.131  11.163  1.00  0.00
ATOM    287 HH12 ARG    36      -0.455  43.046  12.347  1.00  0.00
ATOM    288  NH2 ARG    36      -2.225  44.752  12.777  1.00  0.00
ATOM    289 HH21 ARG    36      -2.992  45.396  12.878  1.00  0.00
ATOM    290 HH22 ARG    36      -1.390  44.887  13.317  1.00  0.00
ATOM    291  C   ARG    36      -3.592  43.080   5.962  1.00  0.00
ATOM    292  O   ARG    36      -2.805  43.816   5.384  1.00  0.00
ATOM    293  N   TYR    37      -4.876  43.366   6.135  1.00  0.00
ATOM    294  HN  TYR    37      -5.429  42.719   6.609  1.00  0.00
ATOM    295  CA  TYR    37      -5.508  44.603   5.686  1.00  0.00
ATOM    296  HA  TYR    37      -4.743  45.306   5.387  1.00  0.00
ATOM    297  CB  TYR    37      -6.477  44.347   4.519  1.00  0.00
ATOM    298  HB1 TYR    37      -6.833  45.302   4.155  1.00  0.00
ATOM    299  HB2 TYR    37      -7.322  43.784   4.887  1.00  0.00
ATOM    300  CG  TYR    37      -5.912  43.586   3.333  1.00  0.00
ATOM    301  CD1 TYR    37      -5.992  42.198   3.273  1.00  0.00
ATOM    302  HD1 TYR    37      -6.438  41.661   4.097  1.00  0.00
ATOM    303  CD2 TYR    37      -5.335  44.256   2.258  1.00  0.00
ATOM    304  HD2 TYR    37      -5.265  45.334   2.286  1.00  0.00
ATOM    305  CE1 TYR    37      -5.512  41.502   2.183  1.00  0.00
ATOM    306  HE1 TYR    37      -5.586  40.425   2.155  1.00  0.00
ATOM    307  CE2 TYR    37      -4.849  43.564   1.166  1.00  0.00
ATOM    308  HE2 TYR    37      -4.402  44.101   0.342  1.00  0.00
ATOM    309  CZ  TYR    37      -4.942  42.190   1.133  1.00  0.00
ATOM    310  OH  TYR    37      -4.459  41.497   0.046  1.00  0.00
ATOM    311  HH  TYR    37      -5.120  40.864  -0.251  1.00  0.00
ATOM    312  C   TYR    37      -6.322  45.182   6.841  1.00  0.00
ATOM    313  O   TYR    37      -6.679  44.453   7.767  1.00  0.00
ATOM    314  N   SER    38      -6.636  46.471   6.777  1.00  0.00
ATOM    315  HN  SER    38      -6.247  47.026   6.068  1.00  0.00
ATOM    316  CA  SER    38      -7.535  47.084   7.751  1.00  0.00
ATOM    317  HA  SER    38      -8.327  46.375   7.956  1.00  0.00
ATOM    318  CB  SER    38      -6.797  47.393   9.060  1.00  0.00
ATOM    319  HB1 SER    38      -6.130  48.229   8.911  1.00  0.00
ATOM    320  HB2 SER    38      -6.225  46.527   9.362  1.00  0.00
ATOM    321  OG  SER    38      -7.714  47.715  10.094  1.00  0.00
ATOM    322  HG  SER    38      -8.082  46.897  10.459  1.00  0.00
ATOM    323  C   SER    38      -8.166  48.351   7.170  1.00  0.00
ATOM    324  O   SER    38      -7.687  48.894   6.172  1.00  0.00
ATOM    325  N   CYS    39      -9.256  48.806   7.780  1.00  0.00
ATOM    326  HN  CYS    39      -9.589  48.331   8.573  1.00  0.00
ATOM    327  CA  CYS    39      -9.980  49.978   7.296  1.00  0.00
ATOM    328  HA  CYS    39      -9.347  50.504   6.596  1.00  0.00
ATOM    329  HB1 CYS    39     -11.825  48.903   7.229  1.00  0.00
ATOM    330  HB2 CYS    39     -10.986  48.989   5.693  1.00  0.00
ATOM    331  C   CYS    39     -10.341  50.922   8.431  1.00  0.00
ATOM    332  O   CYS    39     -11.402  50.776   9.049  1.00  0.00
ATOM    333  CB  CYS    39     -11.253  49.545   6.574  1.00  0.00
ATOM    334  SG  CYS    39     -12.344  50.914   6.050  1.00  0.00
ATOM    335  N   GLY    40      -9.454  51.877   8.706  1.00  0.00
ATOM    336  HN  GLY    40      -8.584  51.868   8.253  1.00  0.00
ATOM    337  CA  GLY    40      -9.742  52.916   9.678  1.00  0.00
ATOM    338  HA1 GLY    40      -8.854  53.512   9.830  1.00  0.00
ATOM    339  HA2 GLY    40     -10.020  52.456  10.616  1.00  0.00
ATOM    340  C   GLY    40     -10.870  53.818   9.213  1.00  0.00
ATOM    341  O   GLY    40     -10.634  54.923   8.718  1.00  0.00
ATOM    342  N   ARG    41     -12.095  53.327   9.360  1.00  0.00
ATOM    343  HN  ARG    41     -12.200  52.466   9.822  1.00  0.00
ATOM    344  CA  ARG    41     -13.289  54.031   8.907  1.00  0.00
ATOM    345  HA  ARG    41     -13.318  54.990   9.406  1.00  0.00
ATOM    346  CB  ARG    41     -13.252  54.250   7.384  1.00  0.00
ATOM    347  HB1 ARG    41     -13.317  53.288   6.892  1.00  0.00
ATOM    348  HB2 ARG    41     -12.308  54.710   7.123  1.00  0.00
ATOM    349  CG  ARG    41     -14.378  55.137   6.858  1.00  0.00
ATOM    350  HG1 ARG    41     -15.326  54.721   7.169  1.00  0.00
ATOM    351  HG2 ARG    41     -14.332  55.156   5.778  1.00  0.00
ATOM    352  CD  ARG    41     -14.270  56.568   7.379  1.00  0.00
ATOM    353  HD1 ARG    41     -13.379  57.024   6.966  1.00  0.00
ATOM    354  HD2 ARG    41     -14.193  56.542   8.456  1.00  0.00
ATOM    355  NE  ARG    41     -15.434  57.375   7.008  1.00  0.00
ATOM    356  HE  ARG    41     -16.316  57.040   7.290  1.00  0.00
ATOM    357  CZ  ARG    41     -15.372  58.529   6.339  1.00  0.00
ATOM    358  NH1 ARG    41     -14.206  59.004   5.921  1.00  0.00
ATOM    359 HH11 ARG    41     -13.359  58.498   6.105  1.00  0.00
ATOM    360 HH12 ARG    41     -14.164  59.872   5.417  1.00  0.00
ATOM    361  NH2 ARG    41     -16.485  59.200   6.077  1.00  0.00
ATOM    362 HH21 ARG    41     -17.372  58.843   6.382  1.00  0.00
ATOM    363 HH22 ARG    41     -16.447  60.068   5.571  1.00  0.00
ATOM    364  C   ARG    41     -14.536  53.232   9.294  1.00  0.00
ATOM    365  O   ARG    41     -15.460  53.767   9.905  1.00  0.00
ATOM    366  N   CYS    42     -14.550  51.941   8.946  1.00  0.00
ATOM    367  HN  CYS    42     -13.788  51.572   8.462  1.00  0.00
ATOM    368  CA  CYS    42     -15.680  51.066   9.290  1.00  0.00
ATOM    369  HA  CYS    42     -16.324  51.612   9.967  1.00  0.00
ATOM    370  HB1 CYS    42     -16.667  51.558   7.443  1.00  0.00
ATOM    371  HB2 CYS    42     -17.452  50.281   8.357  1.00  0.00
ATOM    372  C   CYS    42     -15.190  49.810  10.010  1.00  0.00
ATOM    373  O   CYS    42     -15.972  48.902  10.291  1.00  0.00
ATOM    374  CB  CYS    42     -16.497  50.676   8.042  1.00  0.00
ATOM    375  SG  CYS    42     -15.721  49.422   6.967  1.00  0.00
ATOM    376  N   GLY    43     -13.886  49.755  10.293  1.00  0.00
ATOM    377  HN  GLY    43     -13.292  50.472   9.984  1.00  0.00
ATOM    378  CA  GLY    43     -13.333  48.655  11.068  1.00  0.00
ATOM    379  HA1 GLY    43     -13.985  48.453  11.906  1.00  0.00
ATOM    380  HA2 GLY    43     -12.365  48.951  11.446  1.00  0.00
ATOM    381  C   GLY    43     -13.167  47.383  10.264  1.00  0.00
ATOM    382  O   GLY    43     -12.919  46.319  10.828  1.00  0.00
ATOM    383  N   TYR    44     -13.292  47.490   8.943  1.00  0.00
ATOM    384  HN  TYR    44     -13.474  48.365   8.552  1.00  0.00
ATOM    385  CA  TYR    44     -13.151  46.329   8.071  1.00  0.00
ATOM    386  HA  TYR    44     -13.761  45.533   8.480  1.00  0.00
ATOM    387  CB  TYR    44     -13.634  46.650   6.644  1.00  0.00
ATOM    388  HB1 TYR    44     -12.949  47.348   6.181  1.00  0.00
ATOM    389  HB2 TYR    44     -14.613  47.103   6.698  1.00  0.00
ATOM    390  CG  TYR    44     -13.736  45.430   5.742  1.00  0.00
ATOM    391  CD1 TYR    44     -14.898  44.664   5.711  1.00  0.00
ATOM    392  HD1 TYR    44     -15.731  44.949   6.336  1.00  0.00
ATOM    393  CD2 TYR    44     -12.675  45.043   4.926  1.00  0.00
ATOM    394  HD2 TYR    44     -11.765  45.625   4.936  1.00  0.00
ATOM    395  CE1 TYR    44     -14.999  43.553   4.896  1.00  0.00
ATOM    396  HE1 TYR    44     -15.910  42.972   4.888  1.00  0.00
ATOM    397  CE2 TYR    44     -12.772  43.932   4.110  1.00  0.00
ATOM    398  HE2 TYR    44     -11.937  43.647   3.485  1.00  0.00
ATOM    399  CZ  TYR    44     -13.935  43.191   4.098  1.00  0.00
ATOM    400  OH  TYR    44     -14.035  42.084   3.285  1.00  0.00
ATOM    401  HH  TYR    44     -13.267  41.512   3.421  1.00  0.00
ATOM    402  C   TYR    44     -11.692  45.874   8.052  1.00  0.00
ATOM    403  O   TYR    44     -10.820  46.586   7.541  1.00  0.00
ATOM    404  N   THR    45     -11.440  44.710   8.635  1.00  0.00
ATOM    405  HN  THR    45     -12.181  44.224   9.056  1.00  0.00
ATOM    406  CA  THR    45     -10.111  44.123   8.690  1.00  0.00
ATOM    407  HA  THR    45      -9.436  44.742   8.108  1.00  0.00
ATOM    408  CB  THR    45      -9.598  44.072  10.151  1.00  0.00
ATOM    409  HB  THR    45     -10.307  43.509  10.743  1.00  0.00
ATOM    410  OG1 THR    45      -9.513  45.405  10.682  1.00  0.00
ATOM    411  HG1 THR    45     -10.178  45.513  11.373  1.00  0.00
ATOM    412  CG2 THR    45      -8.233  43.392  10.251  1.00  0.00
ATOM    413 HG21 THR    45      -7.903  43.395  11.280  1.00  0.00
ATOM    414 HG22 THR    45      -7.517  43.926   9.643  1.00  0.00
ATOM    415 HG23 THR    45      -8.311  42.372   9.903  1.00  0.00
ATOM    416  C   THR    45     -10.144  42.717   8.091  1.00  0.00
ATOM    417  O   THR    45     -11.064  41.940   8.359  1.00  0.00
ATOM    418  N   GLU    46      -9.150  42.411   7.270  1.00  0.00
ATOM    419  HN  GLU    46      -8.432  43.068   7.132  1.00  0.00
ATOM    420  CA  GLU    46      -9.061  41.127   6.581  1.00  0.00
ATOM    421  HA  GLU    46      -9.638  40.397   7.131  1.00  0.00
ATOM    422  CB  GLU    46      -9.617  41.256   5.152  1.00  0.00
ATOM    423  HB1 GLU    46      -9.027  41.987   4.614  1.00  0.00
ATOM    424  HB2 GLU    46     -10.638  41.607   5.206  1.00  0.00
ATOM    425  CG  GLU    46      -9.603  39.953   4.359  1.00  0.00
ATOM    426  HG1 GLU    46      -8.586  39.589   4.310  1.00  0.00
ATOM    427  HG2 GLU    46      -9.958  40.150   3.356  1.00  0.00
ATOM    428  CD  GLU    46     -10.477  38.876   4.981  1.00  0.00
ATOM    429  OE1 GLU    46      -9.978  38.115   5.835  1.00  0.00
ATOM    430  OE2 GLU    46     -11.665  38.779   4.610  1.00  0.00
ATOM    431  C   GLU    46      -7.603  40.695   6.546  1.00  0.00
ATOM    432  O   GLU    46      -6.725  41.538   6.470  1.00  0.00
ATOM    433  N   PHE    47      -7.333  39.399   6.601  1.00  0.00
ATOM    434  HN  PHE    47      -8.072  38.749   6.586  1.00  0.00
ATOM    435  CA  PHE    47      -5.950  38.917   6.656  1.00  0.00
ATOM    436  HA  PHE    47      -5.338  39.722   7.041  1.00  0.00
ATOM    437  CB  PHE    47      -5.833  37.719   7.606  1.00  0.00
ATOM    438  HB1 PHE    47      -4.848  37.284   7.507  1.00  0.00
ATOM    439  HB2 PHE    47      -6.574  36.980   7.337  1.00  0.00
ATOM    440  CG  PHE    47      -6.037  38.084   9.055  1.00  0.00
ATOM    441  CD1 PHE    47      -7.275  37.931   9.663  1.00  0.00
ATOM    442  HD1 PHE    47      -8.103  37.536   9.090  1.00  0.00
ATOM    443  CD2 PHE    47      -4.984  38.591   9.806  1.00  0.00
ATOM    444  HD2 PHE    47      -4.014  38.715   9.342  1.00  0.00
ATOM    445  CE1 PHE    47      -7.457  38.275  10.989  1.00  0.00
ATOM    446  HE1 PHE    47      -8.426  38.151  11.451  1.00  0.00
ATOM    447  CE2 PHE    47      -5.163  38.934  11.133  1.00  0.00
ATOM    448  HE2 PHE    47      -4.336  39.325  11.707  1.00  0.00
ATOM    449  CZ  PHE    47      -6.400  38.776  11.724  1.00  0.00
ATOM    450  HZ  PHE    47      -6.542  39.045  12.761  1.00  0.00
ATOM    451  C   PHE    47      -5.431  38.540   5.273  1.00  0.00
ATOM    452  O   PHE    47      -6.207  38.197   4.380  1.00  0.00
ATOM    453  N   LYS    48      -4.109  38.631   5.098  1.00  0.00
ATOM    454  HN  LYS    48      -3.558  39.035   5.806  1.00  0.00
ATOM    455  CA  LYS    48      -3.461  38.123   3.891  1.00  0.00
ATOM    456  HA  LYS    48      -3.984  38.527   3.032  1.00  0.00
ATOM    457  CB  LYS    48      -1.979  38.548   3.833  1.00  0.00
ATOM    458  HB1 LYS    48      -1.467  37.928   3.110  1.00  0.00
ATOM    459  HB2 LYS    48      -1.536  38.381   4.805  1.00  0.00
ATOM    460  CG  LYS    48      -1.748  40.015   3.454  1.00  0.00
ATOM    461  HG1 LYS    48      -0.734  40.287   3.714  1.00  0.00
ATOM    462  HG2 LYS    48      -2.437  40.634   4.012  1.00  0.00
ATOM    463  CD  LYS    48      -1.962  40.267   1.960  1.00  0.00
ATOM    464  HD1 LYS    48      -3.004  40.099   1.722  1.00  0.00
ATOM    465  HD2 LYS    48      -1.349  39.578   1.398  1.00  0.00
ATOM    466  CE  LYS    48      -1.588  41.694   1.562  1.00  0.00
ATOM    467  HE1 LYS    48      -0.547  41.862   1.800  1.00  0.00
ATOM    468  HE2 LYS    48      -2.200  42.386   2.122  1.00  0.00
ATOM    469  NZ  LYS    48      -1.795  41.935   0.107  1.00  0.00
ATOM    470  HZ1 LYS    48      -1.136  41.354  -0.450  1.00  0.00
ATOM    471  HZ2 LYS    48      -1.634  42.936  -0.124  1.00  0.00
ATOM    472  HZ3 LYS    48      -2.767  41.683  -0.163  1.00  0.00
ATOM    473  C   LYS    48      -3.585  36.600   3.875  1.00  0.00
ATOM    474  O   LYS    48      -2.753  35.890   4.447  1.00  0.00
END
