
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  165 ( 1365),  selected  165 , name 2qe9_A
# Molecule2: number of CA atoms  144 ( 1145),  selected  144 , name T0481.pdb
# PARAMETERS: 2qe9_A.T0481.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H   -11_A      -       -           -
LGA    H   -10_A      -       -           -
LGA    H    -9_A      -       -           -
LGA    H    -8_A      -       -           -
LGA    H    -7_A      -       -           -
LGA    E    -6_A      -       -           -
LGA    N    -5_A      -       -           -
LGA    L    -4_A      -       -           -
LGA    Y    -3_A      -       -           -
LGA    F    -2_A      N       5           #
LGA    Q    -1_A      Q       6          3.530
LGA    G     0_A      -       -           -
LGA    X     1_A      I       7          5.234
LGA    X     2_A      V       8          5.076
LGA    K     3_A      S       9          4.752
LGA    F     4_A      H      10          3.029
LGA    F     5_A      F      11          1.294
LGA    E     6_A      L      12          2.987
LGA    Y     7_A      S      13          1.203
LGA    N     8_A      H      14          1.465
LGA    W     9_A      R      15          2.343
LGA    Q    10_A      N      16          2.029
LGA    V    11_A      V      17          1.398
LGA    R    12_A      T      18          2.100
LGA    D    13_A      N      19          2.561
LGA    Q    14_A      E      20          1.630
LGA    W    15_A      L      21          1.863
LGA    F    16_A      A      22          3.163
LGA    T    17_A      E      23          2.982
LGA    W    18_A      K      24          2.554
LGA    C    19_A      I      25          2.934
LGA    H    20_A      -       -           -
LGA    Q    21_A      -       -           -
LGA    L    22_A      -       -           -
LGA    T    23_A      S      26          2.842
LGA    T    24_A      K      27          1.303
LGA    E    25_A      D      28          1.924
LGA    E    26_A      H      29          0.704
LGA    L    27_A      Y      30          1.787
LGA    L    28_A      S      31          2.577
LGA    K    29_A      Y      32          2.643
LGA    N    30_A      K      33          3.370
LGA    R    31_A      P      34          3.434
LGA    L    32_A      A      35          2.658
LGA    -       -      E      36           -
LGA    G    33_A      T      37           #
LGA    G    34_A      S      38           #
LGA    V    35_A      -       -           -
LGA    E    36_A      M      39          1.129
LGA    N    37_A      S      40          1.594
LGA    I    38_A      A      41          1.701
LGA    L    39_A      E      42          1.843
LGA    Y    40_A      E      43          1.872
LGA    T    41_A      L      44          1.424
LGA    L    42_A      V      45          1.734
LGA    F    43_A      K      46          1.204
LGA    H    44_A      H      47          0.686
LGA    I    45_A      I      48          1.028
LGA    I    46_A      L      49          1.634
LGA    D    47_A      T      50          1.124
LGA    V    48_A      S      51          1.117
LGA    E    49_A      F      52          0.834
LGA    Y    50_A      H      53          1.212
LGA    S    51_A      L      54          1.013
LGA    W    52_A      F      55          1.182
LGA    I    53_A      A      56          1.399
LGA    R    54_A      N      57          0.936
LGA    A    55_A      V      58          1.006
LGA    I    56_A      I      59          0.996
LGA    Q    57_A      K      60          1.220
LGA    G    58_A      E      61          1.406
LGA    K    59_A      G      62           #
LGA    -       -      N      63           -
LGA    -       -      A      64           -
LGA    E    60_A      S      65          3.124
LGA    D    61_A      P      66          3.374
LGA    -       -      F      67           -
LGA    I    62_A      Q      68          4.735
LGA    A    63_A      N      69          4.918
LGA    V    64_A      K      70          5.228
LGA    Q    65_A      Q      71           #
LGA    F    66_A      E      72           #
LGA    A    67_A      E      73           #
LGA    D    68_A      T      74          2.870
LGA    Y    69_A      E      75          3.355
LGA    Q    70_A      T      76          2.401
LGA    T    71_A      D      77          1.988
LGA    L    72_A      L      78          1.766
LGA    N    73_A      N      79          3.816
LGA    K    74_A      V      80          3.775
LGA    V    75_A      L      81          1.321
LGA    K    76_A      A      82          2.414
LGA    S    77_A      K      83          4.074
LGA    L    78_A      T      84          3.115
LGA    S    79_A      Y      85          1.595
LGA    N    80_A      T      86          3.438
LGA    T    81_A      E      87          4.094
LGA    F    82_A      K      88          1.972
LGA    R    83_A      T      89          2.352
LGA    T    84_A      V      90          4.188
LGA    -       -      A      91           -
LGA    E    85_A      I      92          2.690
LGA    I    86_A      L      93          3.066
LGA    I    87_A      E      94          2.424
LGA    D    88_A      Q      95          2.349
LGA    V    89_A      L      96          2.745
LGA    L    90_A      -       -           -
LGA    Q    91_A      -       -           -
LGA    T    92_A      T      97          2.514
LGA    H    93_A      E      98          3.231
LGA    -       -      E      99           -
LGA    -       -      Q     100           -
LGA    -       -      L     101           -
LGA    -       -      D     102           -
LGA    E   100_A      R     103          1.071
LGA    L   101_A      E     104          0.280
LGA    V   102_A      I     105          0.837
LGA    S   103_A      D     106          2.453
LGA    V   104_A      L     107          3.575
LGA    P   105_A      -       -           -
LGA    W   106_A      -       -           -
LGA    E   107_A      -       -           -
LGA    T   108_A      -       -           -
LGA    G   109_A      -       -           -
LGA    V   110_A      T     108          4.835
LGA    L   111_A      K     114          0.922
LGA    Y   112_A      V     115          0.349
LGA    T   113_A      T     116          1.293
LGA    R   114_A      G     117          1.727
LGA    D   115_A      R     118          2.210
LGA    E   116_A      A     119          1.481
LGA    I   117_A      L     120          0.570
LGA    L   118_A      L     121          1.418
LGA    H   119_A      Q     122          1.380
LGA    H   120_A      L     123          0.521
LGA    I   121_A      A     124          0.587
LGA    I   122_A      M     125          0.749
LGA    A   123_A      E     126          0.542
LGA    H   124_A      H     127          0.259
LGA    E   125_A      E     128          0.479
LGA    I   126_A      I     129          0.666
LGA    H   127_A      H     130          0.421
LGA    H   128_A      H     131          0.392
LGA    I   129_A      K     132          0.534
LGA    G   130_A      G     133          0.647
LGA    Q   131_A      N     134          0.613
LGA    L   132_A      L     135          1.065
LGA    S   133_A      F     136          1.187
LGA    V   134_A      V     137          1.099
LGA    W   135_A      Y     138          1.441
LGA    A   136_A      V     139          1.830
LGA    R   137_A      R     140          2.141
LGA    E   138_A      E     141          1.663
LGA    L   139_A      M     142          1.770
LGA    K   140_A      G     143          2.414
LGA    L   141_A      H     144          1.162
LGA    S   142_A      T     145          2.118
LGA    -       -      E     146           -
LGA    P   143_A      L     147          3.179
LGA    V   144_A      P     148          2.952
LGA    S   145_A      F     149          1.909
LGA    A   146_A      Y     150          0.636
LGA    S   147_A      Q     151          4.148
LGA    F   148_A      -       -           -
LGA    I   149_A      -       -           -
LGA    G   150_A      -       -           -
LGA    R   151_A      Q     152          3.904
LGA    T   152_A      R     153          4.041
LGA    L   153_A      -       -           -
LGA    K   154_A      -       -           -
LGA    P   155_A      -       -           -
LGA    I   156_A      -       -           -
LGA    H   157_A      -       -           -
LGA    S   158_A      -       -           -
LGA    Y   159_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  165  144    5.0    127    2.42    16.54     62.412     5.042

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.915951 * X  +   0.118448 * Y  +  -0.383411 * Z  +  50.580162
  Y_new =   0.401096 * X  +  -0.299942 * Y  +   0.865538 * Z  +  38.030968
  Z_new =  -0.012480 * X  +  -0.946575 * Y  +  -0.322241 * Z  +  46.607182 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.898919    1.242674  [ DEG:  -108.8000     71.2000 ]
  Theta =   0.012480    3.129112  [ DEG:     0.7151    179.2849 ]
  Phi   =   0.412747   -2.728846  [ DEG:    23.6487   -156.3513 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qe9_A                                        
REMARK     2: T0481.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qe9_A.T0481.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  165  144   5.0  127   2.42   16.54  62.412
REMARK  ---------------------------------------------------------- 
MOLECULE 2qe9_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-JUN-07   2QE9              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN BSU10800                 
TITLE    2 (YP_054576.1) FROM BACILLUS SUBTILIS AT 1.90 A RESOLUTION            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN YIZA;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: YP_054576.1, YIZA, YUCC, BSU10800;                             
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_054576.1, UNCHARACTERIZED PROTEIN BSU10800, STRUCTURAL             
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   10-JUL-07 2QE9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN                 
JRNL        TITL 2 BSU10800 (YP_054576.1) FROM BACILLUS SUBTILIS AT             
JRNL        TITL 3 1.90 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2QE9 A    1   159  UNP    Q7WY73   YIZA_BACSU       1    159             
DBREF  2QE9 B    1   159  UNP    Q7WY73   YIZA_BACSU       1    159             
SEQRES   1 A  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  178  ASN LEU TYR PHE GLN GLY MSE MSE LYS PHE PHE GLU TYR          
SEQRES   3 A  178  ASN TRP GLN VAL ARG ASP GLN TRP PHE THR TRP CYS HIS          
SEQRES   4 A  178  GLN LEU THR THR GLU GLU LEU LEU LYS ASN ARG LEU GLY          
SEQRES   5 A  178  GLY VAL GLU ASN ILE LEU TYR THR LEU PHE HIS ILE ILE          
SEQRES   6 A  178  ASP VAL GLU TYR SER TRP ILE ARG ALA ILE GLN GLY LYS          
SEQRES   7 A  178  GLU ASP ILE ALA VAL GLN PHE ALA ASP TYR GLN THR LEU          
SEQRES   8 A  178  ASN LYS VAL LYS SER LEU SER ASN THR PHE ARG THR GLU          
SEQRES   9 A  178  ILE ILE ASP VAL LEU GLN THR HIS SER ASP GLN ILE LYS          
SEQRES  10 A  178  ASP GLU LEU VAL SER VAL PRO TRP GLU THR GLY VAL LEU          
SEQRES  11 A  178  TYR THR ARG ASP GLU ILE LEU HIS HIS ILE ILE ALA HIS          
SEQRES  12 A  178  GLU ILE HIS HIS ILE GLY GLN LEU SER VAL TRP ALA ARG          
SEQRES  13 A  178  GLU LEU LYS LEU SER PRO VAL SER ALA SER PHE ILE GLY          
SEQRES  14 A  178  ARG THR LEU LYS PRO ILE HIS SER TYR                          
SEQRES   1 B  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  178  ASN LEU TYR PHE GLN GLY MSE MSE LYS PHE PHE GLU TYR          
SEQRES   3 B  178  ASN TRP GLN VAL ARG ASP GLN TRP PHE THR TRP CYS HIS          
SEQRES   4 B  178  GLN LEU THR THR GLU GLU LEU LEU LYS ASN ARG LEU GLY          
SEQRES   5 B  178  GLY VAL GLU ASN ILE LEU TYR THR LEU PHE HIS ILE ILE          
SEQRES   6 B  178  ASP VAL GLU TYR SER TRP ILE ARG ALA ILE GLN GLY LYS          
SEQRES   7 B  178  GLU ASP ILE ALA VAL GLN PHE ALA ASP TYR GLN THR LEU          
SEQRES   8 B  178  ASN LYS VAL LYS SER LEU SER ASN THR PHE ARG THR GLU          
SEQRES   9 B  178  ILE ILE ASP VAL LEU GLN THR HIS SER ASP GLN ILE LYS          
SEQRES  10 B  178  ASP GLU LEU VAL SER VAL PRO TRP GLU THR GLY VAL LEU          
SEQRES  11 B  178  TYR THR ARG ASP GLU ILE LEU HIS HIS ILE ILE ALA HIS          
SEQRES  12 B  178  GLU ILE HIS HIS ILE GLY GLN LEU SER VAL TRP ALA ARG          
SEQRES  13 B  178  GLU LEU LYS LEU SER PRO VAL SER ALA SER PHE ILE GLY          
SEQRES  14 B  178  ARG THR LEU LYS PRO ILE HIS SER TYR                          
HET    MSE  A   1       8                                                       
HET    MSE  A   2       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   2       8                                                       
HET     NI  A 200       1                                                       
HET     NI  B 200       1                                                       
HET    CIT      1      13                                                       
HET    CIT      2      13                                                       
HET    EDO      3       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     CIT CITRIC ACID                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3   NI    2(NI 2+)                                                     
FORMUL   5  CIT    2(C6 H8 O7)                                                  
FORMUL   7  EDO    C2 H6 O2                                                     
FORMUL   8  HOH   *235(H2 O)                                                    
CRYST1   53.184   53.184  251.364  90.00  90.00  90.00 P 41 21 2    16          
ATOM      1  N   HIS A -11      57.963  48.581  -5.137  1.00 53.64           N  
ATOM      2  CA  HIS A -11      56.854  48.654  -4.131  1.00 54.69           C  
ATOM      3  C   HIS A -11      55.545  48.091  -4.690  1.00 54.19           C  
ATOM      4  O   HIS A -11      55.455  47.782  -5.879  1.00 54.50           O  
ATOM      5  CB  HIS A -11      56.647  50.104  -3.677  1.00 55.03           C  
ATOM      6  CG  HIS A -11      57.874  50.737  -3.097  1.00 53.91           C  
ATOM      7  ND1 HIS A -11      58.111  50.798  -1.741  1.00 50.29           N  
ATOM      8  CD2 HIS A -11      58.941  51.319  -3.694  1.00 50.13           C  
ATOM      9  CE1 HIS A -11      59.265  51.403  -1.526  1.00 50.46           C  
ATOM     10  NE2 HIS A -11      59.790  51.729  -2.694  1.00 49.30           N  
ATOM     11  N   HIS A -10      54.541  47.960  -3.822  1.00 54.78           N  
ATOM     12  CA  HIS A -10      53.218  47.421  -4.190  1.00 55.56           C  
ATOM     13  C   HIS A -10      52.087  48.208  -3.528  1.00 54.47           C  
ATOM     14  O   HIS A -10      52.256  48.720  -2.420  1.00 54.85           O  
ATOM     15  CB  HIS A -10      53.103  45.938  -3.795  1.00 56.36           C  
ATOM     16  CG  HIS A -10      54.177  45.069  -4.379  1.00 60.57           C  
ATOM     17  ND1 HIS A -10      54.270  44.802  -5.729  1.00 64.56           N  
ATOM     18  CD2 HIS A -10      55.207  44.410  -3.796  1.00 63.95           C  
ATOM     19  CE1 HIS A -10      55.313  44.023  -5.954  1.00 64.21           C  
ATOM     20  NE2 HIS A -10      55.898  43.769  -4.797  1.00 65.67           N  
ATOM     21  N   HIS A  -9      50.935  48.280  -4.198  1.00 53.34           N  
ATOM     22  CA  HIS A  -9      49.754  48.984  -3.655  1.00 52.55           C  
ATOM     23  C   HIS A  -9      49.185  48.104  -2.523  1.00 54.15           C  
ATOM     24  O   HIS A  -9      49.253  46.879  -2.609  1.00 54.81           O  
ATOM     25  CB  HIS A  -9      48.724  49.322  -4.753  1.00 50.61           C  
ATOM     26  CG  HIS A  -9      49.309  50.042  -5.937  1.00 47.05           C  
ATOM     27  ND1 HIS A  -9      49.940  51.262  -5.841  1.00 40.89           N  
ATOM     28  CD2 HIS A  -9      49.344  49.711  -7.248  1.00 42.79           C  
ATOM     29  CE1 HIS A  -9      50.342  51.646  -7.039  1.00 38.82           C  
ATOM     30  NE2 HIS A  -9      50.011  50.713  -7.909  1.00 36.70           N  
ATOM     31  N   HIS A  -8      48.642  48.723  -1.474  1.00 55.69           N  
ATOM     32  CA  HIS A  -8      48.224  48.004  -0.242  1.00 57.43           C  
ATOM     33  C   HIS A  -8      46.796  47.386  -0.170  1.00 58.72           C  
ATOM     34  O   HIS A  -8      46.657  46.153  -0.145  1.00 58.90           O  
ATOM     35  CB  HIS A  -8      48.441  48.933   0.969  1.00 57.77           C  
ATOM     36  N   HIS A  -7      45.777  48.250  -0.075  1.00 58.78           N  
ATOM     37  CA  HIS A  -7      44.332  47.900   0.080  1.00 57.63           C  
ATOM     38  C   HIS A  -7      43.923  47.293   1.458  1.00 55.80           C  
ATOM     39  O   HIS A  -7      44.463  46.258   1.887  1.00 54.48           O  
ATOM     40  CB  HIS A  -7      43.807  47.006  -1.060  1.00 59.04           C  
ATOM     41  CG  HIS A  -7      42.313  46.978  -1.148  1.00 65.09           C  
ATOM     42  ND1 HIS A  -7      41.590  47.929  -1.840  1.00 72.29           N  
ATOM     43  CD2 HIS A  -7      41.401  46.139  -0.602  1.00 69.90           C  
ATOM     44  CE1 HIS A  -7      40.299  47.669  -1.723  1.00 72.82           C  
ATOM     45  NE2 HIS A  -7      40.158  46.589  -0.974  1.00 72.57           N  
ATOM     46  N   GLU A  -6      42.933  47.928   2.102  1.00 52.22           N  
ATOM     47  CA  GLU A  -6      42.414  47.505   3.421  1.00 52.30           C  
ATOM     48  C   GLU A  -6      41.772  46.115   3.373  1.00 50.66           C  
ATOM     49  O   GLU A  -6      41.128  45.754   2.395  1.00 48.82           O  
ATOM     50  CB  GLU A  -6      41.397  48.511   3.978  1.00 51.71           C  
ATOM     51  N   ASN A  -5      41.995  45.338   4.427  1.00 50.00           N  
ATOM     52  CA  ASN A  -5      41.443  44.000   4.561  1.00 49.62           C  
ATOM     53  C   ASN A  -5      40.130  44.200   5.289  1.00 45.37           C  
ATOM     54  O   ASN A  -5      40.131  44.378   6.529  1.00 42.48           O  
ATOM     55  CB  ASN A  -5      42.419  43.086   5.320  1.00 50.90           C  
ATOM     56  CG  ASN A  -5      41.924  41.638   5.447  1.00 54.61           C  
ATOM     57  OD1 ASN A  -5      40.724  41.372   5.509  1.00 51.55           O  
ATOM     58  ND2 ASN A  -5      42.866  40.701   5.528  1.00 63.19           N  
ATOM     59  N   LEU A  -4      39.023  44.201   4.525  1.00 41.75           N  
ATOM     60  CA  LEU A  -4      37.698  44.417   5.127  1.00 38.51           C  
ATOM     61  C   LEU A  -4      37.364  43.330   6.116  1.00 32.77           C  
ATOM     62  O   LEU A  -4      36.855  43.648   7.168  1.00 30.35           O  
ATOM     63  CB  LEU A  -4      36.571  44.525   4.101  1.00 38.41           C  
ATOM     64  CG  LEU A  -4      36.593  45.715   3.143  1.00 43.44           C  
ATOM     65  CD1 LEU A  -4      35.303  45.699   2.339  1.00 54.28           C  
ATOM     66  CD2 LEU A  -4      36.757  47.040   3.867  1.00 45.69           C  
ATOM     67  N   TYR A  -3      37.598  42.063   5.754  1.00 32.72           N  
ATOM     68  CA  TYR A  -3      37.357  40.943   6.659  1.00 34.09           C  
ATOM     69  C   TYR A  -3      38.065  41.179   8.009  1.00 35.09           C  
ATOM     70  O   TYR A  -3      37.428  41.101   9.067  1.00 34.42           O  
ATOM     71  CB  TYR A  -3      37.795  39.589   6.046  1.00 36.05           C  
ATOM     72  CG  TYR A  -3      37.905  38.500   7.099  1.00 36.89           C  
ATOM     73  CD1 TYR A  -3      36.781  37.785   7.514  1.00 35.05           C  
ATOM     74  CD2 TYR A  -3      39.123  38.246   7.740  1.00 37.40           C  
ATOM     75  CE1 TYR A  -3      36.869  36.818   8.500  1.00 34.90           C  
ATOM     76  CE2 TYR A  -3      39.225  37.273   8.752  1.00 42.71           C  
ATOM     77  CZ  TYR A  -3      38.106  36.553   9.112  1.00 35.52           C  
ATOM     78  OH  TYR A  -3      38.212  35.615  10.105  1.00 37.86           O  
ATOM     79  N   PHE A  -2      39.366  41.473   7.943  1.00 35.05           N  
ATOM     80  CA  PHE A  -2      40.196  41.678   9.133  1.00 38.61           C  
ATOM     81  C   PHE A  -2      39.663  42.791  10.010  1.00 37.81           C  
ATOM     82  O   PHE A  -2      39.483  42.588  11.200  1.00 37.52           O  
ATOM     83  CB  PHE A  -2      41.647  41.978   8.772  1.00 42.60           C  
ATOM     84  CG  PHE A  -2      42.527  42.282   9.974  1.00 48.31           C  
ATOM     85  CD1 PHE A  -2      42.887  41.259  10.860  1.00 51.13           C  
ATOM     86  CD2 PHE A  -2      43.004  43.588  10.211  1.00 53.36           C  
ATOM     87  CE1 PHE A  -2      43.700  41.521  11.980  1.00 48.54           C  
ATOM     88  CE2 PHE A  -2      43.829  43.871  11.334  1.00 53.43           C  
ATOM     89  CZ  PHE A  -2      44.174  42.838  12.217  1.00 52.11           C  
ATOM     90  N   GLN A  -1      39.373  43.938   9.411  1.00 37.96           N  
ATOM     91  CA  GLN A  -1      38.837  45.084  10.169  1.00 38.92           C  
ATOM     92  C   GLN A  -1      37.461  44.765  10.788  1.00 38.02           C  
ATOM     93  O   GLN A  -1      37.211  45.130  11.941  1.00 38.77           O  
ATOM     94  CB  GLN A  -1      38.815  46.334   9.307  1.00 40.60           C  
ATOM     95  CG  GLN A  -1      40.212  46.832   8.930  1.00 44.88           C  
ATOM     96  N   GLY A   0      36.615  44.045  10.045  1.00 37.75           N  
ATOM     97  CA  GLY A   0      35.329  43.533  10.550  1.00 36.86           C  
ATOM     98  C   GLY A   0      35.457  42.678  11.806  1.00 35.05           C  
ATOM     99  O   GLY A   0      34.766  42.894  12.786  1.00 36.64           O  
HETATM  100  N   MSE A   1      36.388  41.741  11.812  1.00 36.21           N  
HETATM  101  CA  MSE A   1      36.619  40.907  12.996  1.00 36.53           C  
HETATM  102  C   MSE A   1      37.257  41.715  14.146  1.00 34.88           C  
HETATM  103  O   MSE A   1      36.905  41.511  15.318  1.00 34.23           O  
HETATM  104  CB  MSE A   1      37.479  39.673  12.635  1.00 35.39           C  
HETATM  105  CG  MSE A   1      36.861  38.796  11.562  1.00 33.96           C  
HETATM  106 SE   MSE A   1      35.113  38.076  12.030  0.75 34.56          SE  
HETATM  107  CE  MSE A   1      35.688  36.658  13.172  1.00 41.32           C  
HETATM  108  N   MSE A   2      38.155  42.647  13.819  1.00 35.98           N  
HETATM  109  CA  MSE A   2      38.835  43.441  14.853  1.00 35.55           C  
HETATM  110  C   MSE A   2      37.873  44.356  15.613  1.00 33.77           C  
HETATM  111  O   MSE A   2      38.063  44.522  16.812  1.00 37.48           O  
HETATM  112  CB  MSE A   2      40.008  44.253  14.301  1.00 32.89           C  
HETATM  113  CG  MSE A   2      41.220  43.467  13.851  1.00 39.19           C  
HETATM  114 SE   MSE A   2      41.805  42.136  15.118  0.75 38.22          SE  
HETATM  115  CE  MSE A   2      40.772  40.635  14.421  1.00 36.27           C  
ATOM    116  N   LYS A   3      36.858  44.905  14.944  1.00 35.02           N  
ATOM    117  CA  LYS A   3      35.823  45.735  15.627  1.00 33.89           C  
ATOM    118  C   LYS A   3      35.125  44.970  16.750  1.00 32.22           C  
ATOM    119  O   LYS A   3      34.807  45.566  17.762  1.00 32.06           O  
ATOM    120  CB  LYS A   3      34.794  46.345  14.660  1.00 34.84           C  
ATOM    121  CG  LYS A   3      35.421  47.294  13.626  1.00 35.26           C  
ATOM    122  CD  LYS A   3      34.461  48.322  13.097  1.00 42.10           C  
ATOM    123  CE  LYS A   3      34.996  49.057  11.856  1.00 48.85           C  
ATOM    124  NZ  LYS A   3      36.486  49.163  11.752  1.00 61.77           N  
ATOM    125  N   PHE A   4      34.936  43.652  16.603  1.00 33.27           N  
ATOM    126  CA  PHE A   4      34.408  42.833  17.714  1.00 34.06           C  
ATOM    127  C   PHE A   4      35.382  42.750  18.898  1.00 35.57           C  
ATOM    128  O   PHE A   4      34.947  42.768  20.055  1.00 35.08           O  
ATOM    129  CB  PHE A   4      34.048  41.426  17.286  1.00 34.78           C  
ATOM    130  CG  PHE A   4      32.780  41.334  16.504  1.00 34.39           C  
ATOM    131  CD1 PHE A   4      31.555  41.577  17.121  1.00 35.78           C  
ATOM    132  CD2 PHE A   4      32.784  40.922  15.172  1.00 37.77           C  
ATOM    133  CE1 PHE A   4      30.345  41.455  16.412  1.00 38.27           C  
ATOM    134  CE2 PHE A   4      31.590  40.774  14.471  1.00 37.09           C  
ATOM    135  CZ  PHE A   4      30.371  41.068  15.079  1.00 38.11           C  
ATOM    136  N   PHE A   5      36.674  42.576  18.610  1.00 33.82           N  
ATOM    137  CA  PHE A   5      37.707  42.569  19.662  1.00 32.39           C  
ATOM    138  C   PHE A   5      37.788  43.910  20.364  1.00 33.75           C  
ATOM    139  O   PHE A   5      37.896  43.966  21.575  1.00 34.14           O  
ATOM    140  CB  PHE A   5      39.092  42.193  19.122  1.00 33.04           C  
ATOM    141  CG  PHE A   5      39.265  40.706  18.929  1.00 32.55           C  
ATOM    142  CD1 PHE A   5      39.741  39.913  19.972  1.00 38.42           C  
ATOM    143  CD2 PHE A   5      38.898  40.101  17.736  1.00 39.14           C  
ATOM    144  CE1 PHE A   5      39.885  38.513  19.807  1.00 35.67           C  
ATOM    145  CE2 PHE A   5      39.041  38.696  17.553  1.00 38.09           C  
ATOM    146  CZ  PHE A   5      39.531  37.909  18.599  1.00 36.65           C  
ATOM    147  N   GLU A   6      37.745  44.987  19.577  1.00 33.74           N  
ATOM    148  CA  GLU A   6      37.786  46.341  20.128  1.00 32.85           C  
ATOM    149  C   GLU A   6      36.594  46.582  21.087  1.00 33.28           C  
ATOM    150  O   GLU A   6      36.770  47.012  22.240  1.00 32.68           O  
ATOM    151  CB  GLU A   6      37.803  47.346  18.983  1.00 30.91           C  
ATOM    152  CG  GLU A   6      39.108  47.302  18.188  1.00 32.05           C  
ATOM    153  CD  GLU A   6      39.034  48.031  16.854  1.00 36.06           C  
ATOM    154  OE1 GLU A   6      37.996  48.664  16.566  1.00 34.58           O  
ATOM    155  OE2 GLU A   6      40.033  47.939  16.085  1.00 39.13           O  
ATOM    156  N   TYR A   7      35.406  46.259  20.600  1.00 33.44           N  
ATOM    157  CA  TYR A   7      34.174  46.325  21.393  1.00 33.33           C  
ATOM    158  C   TYR A   7      34.299  45.518  22.687  1.00 34.97           C  
ATOM    159  O   TYR A   7      34.071  46.041  23.778  1.00 34.62           O  
ATOM    160  CB  TYR A   7      33.019  45.817  20.546  1.00 34.32           C  
ATOM    161  CG  TYR A   7      31.781  45.382  21.298  1.00 34.36           C  
ATOM    162  CD1 TYR A   7      30.874  46.312  21.784  1.00 35.60           C  
ATOM    163  CD2 TYR A   7      31.499  44.031  21.486  1.00 37.28           C  
ATOM    164  CE1 TYR A   7      29.704  45.913  22.478  1.00 32.19           C  
ATOM    165  CE2 TYR A   7      30.336  43.624  22.161  1.00 37.76           C  
ATOM    166  CZ  TYR A   7      29.443  44.560  22.643  1.00 37.25           C  
ATOM    167  OH  TYR A   7      28.336  44.138  23.334  1.00 36.47           O  
ATOM    168  N   ASN A   8      34.711  44.261  22.546  1.00 33.65           N  
ATOM    169  CA  ASN A   8      34.886  43.383  23.698  1.00 35.19           C  
ATOM    170  C   ASN A   8      35.872  43.909  24.723  1.00 35.76           C  
ATOM    171  O   ASN A   8      35.563  43.904  25.934  1.00 36.96           O  
ATOM    172  CB  ASN A   8      35.278  41.956  23.271  1.00 34.30           C  
ATOM    173  CG  ASN A   8      34.086  41.126  22.787  1.00 36.24           C  
ATOM    174  OD1 ASN A   8      32.936  41.436  23.057  1.00 39.87           O  
ATOM    175  ND2 ASN A   8      34.385  40.039  22.108  1.00 35.89           N  
ATOM    176  N   TRP A   9      37.025  44.386  24.252  1.00 36.89           N  
ATOM    177  CA  TRP A   9      38.040  44.909  25.179  1.00 35.64           C  
ATOM    178  C   TRP A   9      37.570  46.145  25.942  1.00 35.59           C  
ATOM    179  O   TRP A   9      37.822  46.268  27.137  1.00 34.48           O  
ATOM    180  CB  TRP A   9      39.377  45.177  24.463  1.00 36.72           C  
ATOM    181  CG  TRP A   9      39.980  43.928  23.848  1.00 35.51           C  
ATOM    182  CD1 TRP A   9      39.650  42.643  24.105  1.00 39.31           C  
ATOM    183  CD2 TRP A   9      41.083  43.886  22.949  1.00 35.08           C  
ATOM    184  NE1 TRP A   9      40.418  41.802  23.365  1.00 35.98           N  
ATOM    185  CE2 TRP A   9      41.332  42.540  22.661  1.00 37.97           C  
ATOM    186  CE3 TRP A   9      41.897  44.876  22.363  1.00 38.79           C  
ATOM    187  CZ2 TRP A   9      42.347  42.128  21.783  1.00 37.95           C  
ATOM    188  CZ3 TRP A   9      42.912  44.471  21.485  1.00 39.87           C  
ATOM    189  CH2 TRP A   9      43.114  43.103  21.198  1.00 39.34           C  
ATOM    190  N   GLN A  10      36.886  47.045  25.253  1.00 34.88           N  
ATOM    191  CA  GLN A  10      36.353  48.260  25.889  1.00 33.96           C  
ATOM    192  C   GLN A  10      35.262  47.923  26.906  1.00 36.60           C  
ATOM    193  O   GLN A  10      35.272  48.443  28.033  1.00 35.25           O  
ATOM    194  CB  GLN A  10      35.875  49.233  24.828  1.00 34.76           C  
ATOM    195  CG  GLN A  10      37.037  49.798  24.051  1.00 35.15           C  
ATOM    196  CD  GLN A  10      36.636  50.640  22.866  1.00 36.20           C  
ATOM    197  OE1 GLN A  10      37.277  50.548  21.793  1.00 38.69           O  
ATOM    198  NE2 GLN A  10      35.603  51.484  23.035  1.00 37.99           N  
ATOM    199  N   VAL A  11      34.378  47.002  26.535  1.00 35.86           N  
ATOM    200  CA  VAL A  11      33.310  46.537  27.447  1.00 37.64           C  
ATOM    201  C   VAL A  11      33.916  45.860  28.677  1.00 36.43           C  
ATOM    202  O   VAL A  11      33.519  46.165  29.817  1.00 34.51           O  
ATOM    203  CB  VAL A  11      32.295  45.639  26.729  1.00 37.86           C  
ATOM    204  CG1 VAL A  11      31.355  44.917  27.706  1.00 32.20           C  
ATOM    205  CG2 VAL A  11      31.460  46.486  25.725  1.00 32.44           C  
ATOM    206  N   ARG A  12      34.889  44.976  28.455  1.00 36.24           N  
ATOM    207  CA  ARG A  12      35.549  44.248  29.541  1.00 36.89           C  
ATOM    208  C   ARG A  12      36.196  45.193  30.533  1.00 37.19           C  
ATOM    209  O   ARG A  12      36.033  45.002  31.733  1.00 36.93           O  
ATOM    210  CB  ARG A  12      36.648  43.313  29.029  1.00 35.49           C  
ATOM    211  CG  ARG A  12      37.151  42.285  30.093  1.00 40.92           C  
ATOM    212  CD  ARG A  12      38.489  41.760  29.709  1.00 39.78           C  
ATOM    213  NE  ARG A  12      38.425  41.065  28.422  1.00 41.27           N  
ATOM    214  CZ  ARG A  12      39.485  40.707  27.697  1.00 37.19           C  
ATOM    215  NH1 ARG A  12      40.714  40.931  28.103  1.00 35.87           N  
ATOM    216  NH2 ARG A  12      39.318  40.070  26.565  1.00 36.83           N  
ATOM    217  N   ASP A  13      36.919  46.200  30.016  1.00 34.79           N  
ATOM    218  CA  ASP A  13      37.599  47.170  30.879  1.00 35.60           C  
ATOM    219  C   ASP A  13      36.618  47.973  31.731  1.00 35.73           C  
ATOM    220  O   ASP A  13      36.900  48.257  32.895  1.00 36.71           O  
ATOM    221  CB  ASP A  13      38.505  48.076  30.070  1.00 35.90           C  
ATOM    222  CG  ASP A  13      39.714  47.348  29.501  1.00 39.61           C  
ATOM    223  OD1 ASP A  13      39.963  46.148  29.780  1.00 37.25           O  
ATOM    224  OD2 ASP A  13      40.441  48.023  28.764  1.00 35.49           O  
ATOM    225  N   GLN A  14      35.469  48.295  31.156  1.00 33.73           N  
ATOM    226  CA  GLN A  14      34.357  48.927  31.921  1.00 35.41           C  
ATOM    227  C   GLN A  14      33.800  48.011  33.018  1.00 37.16           C  
ATOM    228  O   GLN A  14      33.510  48.493  34.127  1.00 36.37           O  
ATOM    229  CB  GLN A  14      33.244  49.425  30.974  1.00 34.99           C  
ATOM    230  CG  GLN A  14      33.582  50.759  30.394  1.00 38.84           C  
ATOM    231  CD  GLN A  14      33.359  51.855  31.424  1.00 37.92           C  
ATOM    232  OE1 GLN A  14      32.222  52.094  31.837  1.00 37.25           O  
ATOM    233  NE2 GLN A  14      34.441  52.493  31.870  1.00 34.83           N  
ATOM    234  N   TRP A  15      33.688  46.698  32.740  1.00 37.93           N  
ATOM    235  CA  TRP A  15      33.304  45.716  33.788  1.00 36.48           C  
ATOM    236  C   TRP A  15      34.358  45.637  34.891  1.00 37.30           C  
ATOM    237  O   TRP A  15      33.997  45.525  36.064  1.00 36.92           O  
ATOM    238  CB  TRP A  15      32.987  44.317  33.225  1.00 36.20           C  
ATOM    239  CG  TRP A  15      31.618  44.244  32.645  1.00 35.17           C  
ATOM    240  CD1 TRP A  15      31.278  44.251  31.326  1.00 37.02           C  
ATOM    241  CD2 TRP A  15      30.384  44.184  33.379  1.00 33.92           C  
ATOM    242  NE1 TRP A  15      29.908  44.178  31.187  1.00 36.71           N  
ATOM    243  CE2 TRP A  15      29.335  44.111  32.430  1.00 32.91           C  
ATOM    244  CE3 TRP A  15      30.064  44.154  34.748  1.00 38.05           C  
ATOM    245  CZ2 TRP A  15      27.977  44.062  32.806  1.00 34.32           C  
ATOM    246  CZ3 TRP A  15      28.715  44.085  35.127  1.00 38.52           C  
ATOM    247  CH2 TRP A  15      27.692  44.048  34.153  1.00 36.40           C  
ATOM    248  N   PHE A  16      35.650  45.702  34.529  1.00 35.87           N  
ATOM    249  CA  PHE A  16      36.719  45.777  35.543  1.00 35.56           C  
ATOM    250  C   PHE A  16      36.545  47.017  36.413  1.00 35.09           C  
ATOM    251  O   PHE A  16      36.672  46.938  37.617  1.00 35.13           O  
ATOM    252  CB  PHE A  16      38.136  45.771  34.934  1.00 35.72           C  
ATOM    253  CG  PHE A  16      38.641  44.395  34.545  1.00 37.03           C  
ATOM    254  CD1 PHE A  16      38.708  43.368  35.486  1.00 43.75           C  
ATOM    255  CD2 PHE A  16      39.124  44.155  33.267  1.00 37.92           C  
ATOM    256  CE1 PHE A  16      39.208  42.091  35.138  1.00 44.67           C  
ATOM    257  CE2 PHE A  16      39.623  42.901  32.915  1.00 38.19           C  
ATOM    258  CZ  PHE A  16      39.675  41.870  33.859  1.00 38.53           C  
ATOM    259  N   THR A  17      36.236  48.159  35.801  1.00 34.06           N  
ATOM    260  CA  THR A  17      35.945  49.384  36.571  1.00 34.93           C  
ATOM    261  C   THR A  17      34.701  49.198  37.468  1.00 33.76           C  
ATOM    262  O   THR A  17      34.751  49.525  38.637  1.00 31.86           O  
ATOM    263  CB  THR A  17      35.806  50.582  35.649  1.00 35.95           C  
ATOM    264  OG1 THR A  17      37.046  50.705  34.936  1.00 36.89           O  
ATOM    265  CG2 THR A  17      35.516  51.909  36.447  1.00 36.17           C  
ATOM    266  N   TRP A  18      33.634  48.628  36.910  1.00 35.09           N  
ATOM    267  CA  TRP A  18      32.373  48.323  37.636  1.00 36.59           C  
ATOM    268  C   TRP A  18      32.625  47.498  38.902  1.00 34.61           C  
ATOM    269  O   TRP A  18      32.016  47.759  39.939  1.00 33.39           O  
ATOM    270  CB  TRP A  18      31.397  47.612  36.700  1.00 34.64           C  
ATOM    271  CG  TRP A  18      30.056  47.233  37.247  1.00 34.43           C  
ATOM    272  CD1 TRP A  18      28.898  47.935  37.159  1.00 33.86           C  
ATOM    273  CD2 TRP A  18      29.733  46.002  37.909  1.00 33.80           C  
ATOM    274  NE1 TRP A  18      27.871  47.233  37.766  1.00 35.35           N  
ATOM    275  CE2 TRP A  18      28.361  46.048  38.238  1.00 34.90           C  
ATOM    276  CE3 TRP A  18      30.476  44.870  38.249  1.00 33.62           C  
ATOM    277  CZ2 TRP A  18      27.707  44.995  38.898  1.00 36.32           C  
ATOM    278  CZ3 TRP A  18      29.831  43.808  38.905  1.00 34.11           C  
ATOM    279  CH2 TRP A  18      28.459  43.890  39.223  1.00 35.83           C  
ATOM    280  N   CYS A  19      33.537  46.530  38.804  1.00 37.25           N  
ATOM    281  CA  CYS A  19      33.902  45.657  39.936  1.00 38.18           C  
ATOM    282  C   CYS A  19      34.508  46.396  41.136  1.00 39.42           C  
ATOM    283  O   CYS A  19      34.472  45.852  42.240  1.00 40.86           O  
ATOM    284  CB  CYS A  19      34.865  44.537  39.494  1.00 39.79           C  
ATOM    285  SG  CYS A  19      34.114  43.278  38.499  1.00 37.88           S  
ATOM    286  N   HIS A  20      35.088  47.587  40.928  1.00 40.41           N  
ATOM    287  CA  HIS A  20      35.644  48.386  42.056  1.00 43.66           C  
ATOM    288  C   HIS A  20      34.641  48.836  43.102  1.00 42.29           C  
ATOM    289  O   HIS A  20      35.043  49.122  44.233  1.00 42.31           O  
ATOM    290  CB  HIS A  20      36.415  49.609  41.561  1.00 44.03           C  
ATOM    291  CG  HIS A  20      37.756  49.259  41.024  1.00 58.15           C  
ATOM    292  ND1 HIS A  20      37.952  48.870  39.715  1.00 66.06           N  
ATOM    293  CD2 HIS A  20      38.963  49.170  41.636  1.00 57.93           C  
ATOM    294  CE1 HIS A  20      39.230  48.596  39.535  1.00 63.42           C  
ATOM    295  NE2 HIS A  20      39.866  48.767  40.684  1.00 64.96           N  
ATOM    296  N   GLN A  21      33.363  48.927  42.740  1.00 40.74           N  
ATOM    297  CA  GLN A  21      32.335  49.302  43.713  1.00 40.42           C  
ATOM    298  C   GLN A  21      31.952  48.139  44.633  1.00 42.20           C  
ATOM    299  O   GLN A  21      31.333  48.376  45.663  1.00 42.11           O  
ATOM    300  CB  GLN A  21      31.095  49.860  43.018  1.00 40.19           C  
ATOM    301  CG  GLN A  21      30.183  48.824  42.366  1.00 40.55           C  
ATOM    302  CD  GLN A  21      29.254  49.440  41.362  1.00 40.17           C  
ATOM    303  OE1 GLN A  21      28.392  50.238  41.714  1.00 44.45           O  
ATOM    304  NE2 GLN A  21      29.422  49.079  40.103  1.00 36.03           N  
ATOM    305  N   LEU A  22      32.291  46.907  44.245  1.00 41.62           N  
ATOM    306  CA  LEU A  22      31.961  45.711  45.017  1.00 44.67           C  
ATOM    307  C   LEU A  22      32.996  45.392  46.080  1.00 46.68           C  
ATOM    308  O   LEU A  22      34.176  45.737  45.944  1.00 48.03           O  
ATOM    309  CB  LEU A  22      31.857  44.492  44.100  1.00 43.35           C  
ATOM    310  CG  LEU A  22      30.903  44.519  42.910  1.00 43.19           C  
ATOM    311  CD1 LEU A  22      30.975  43.169  42.231  1.00 41.36           C  
ATOM    312  CD2 LEU A  22      29.487  44.824  43.337  1.00 45.64           C  
ATOM    313  N   THR A  23      32.549  44.672  47.110  1.00 49.61           N  
ATOM    314  CA  THR A  23      33.433  44.174  48.152  1.00 51.34           C  
ATOM    315  C   THR A  23      34.128  42.944  47.585  1.00 52.32           C  
ATOM    316  O   THR A  23      33.710  42.409  46.548  1.00 48.92           O  
ATOM    317  CB  THR A  23      32.669  43.785  49.437  1.00 51.26           C  
ATOM    318  OG1 THR A  23      31.719  42.757  49.145  1.00 57.60           O  
ATOM    319  CG2 THR A  23      31.928  44.981  50.012  1.00 52.52           C  
ATOM    320  N   THR A  24      35.177  42.479  48.259  1.00 53.32           N  
ATOM    321  CA  THR A  24      35.853  41.234  47.833  1.00 54.66           C  
ATOM    322  C   THR A  24      34.872  40.043  48.005  1.00 54.00           C  
ATOM    323  O   THR A  24      34.942  39.067  47.239  1.00 52.72           O  
ATOM    324  CB  THR A  24      37.180  40.973  48.596  1.00 56.54           C  
ATOM    325  OG1 THR A  24      37.914  42.197  48.731  1.00 58.11           O  
ATOM    326  CG2 THR A  24      38.037  39.923  47.848  1.00 56.01           C  
ATOM    327  N   GLU A  25      33.964  40.156  48.993  1.00 53.80           N  
ATOM    328  CA  GLU A  25      32.893  39.175  49.251  1.00 52.61           C  
ATOM    329  C   GLU A  25      31.964  39.076  48.048  1.00 51.02           C  
ATOM    330  O   GLU A  25      31.773  37.982  47.508  1.00 50.07           O  
ATOM    331  CB  GLU A  25      32.070  39.548  50.493  1.00 52.02           C  
ATOM    332  N   GLU A  26      31.407  40.223  47.642  1.00 49.55           N  
ATOM    333  CA  GLU A  26      30.533  40.320  46.451  1.00 49.71           C  
ATOM    334  C   GLU A  26      31.249  39.840  45.174  1.00 48.19           C  
ATOM    335  O   GLU A  26      30.633  39.150  44.364  1.00 47.20           O  
ATOM    336  CB  GLU A  26      29.989  41.748  46.267  1.00 49.94           C  
ATOM    337  CG  GLU A  26      28.947  42.205  47.333  1.00 51.98           C  
ATOM    338  CD  GLU A  26      28.486  43.672  47.162  1.00 51.90           C  
ATOM    339  OE1 GLU A  26      29.307  44.543  46.805  1.00 51.56           O  
ATOM    340  OE2 GLU A  26      27.294  43.970  47.403  1.00 52.39           O  
ATOM    341  N   LEU A  27      32.534  40.190  45.005  1.00 45.81           N  
ATOM    342  CA  LEU A  27      33.325  39.738  43.831  1.00 45.93           C  
ATOM    343  C   LEU A  27      33.490  38.224  43.697  1.00 44.71           C  
ATOM    344  O   LEU A  27      33.347  37.681  42.594  1.00 42.80           O  
ATOM    345  CB  LEU A  27      34.736  40.364  43.787  1.00 46.17           C  
ATOM    346  CG  LEU A  27      34.903  41.724  43.140  1.00 50.49           C  
ATOM    347  CD1 LEU A  27      36.355  42.177  43.304  1.00 50.43           C  
ATOM    348  CD2 LEU A  27      34.490  41.657  41.658  1.00 40.94           C  
ATOM    349  N   LEU A  28      33.818  37.568  44.810  1.00 43.61           N  
ATOM    350  CA  LEU A  28      34.046  36.110  44.845  1.00 44.00           C  
ATOM    351  C   LEU A  28      32.814  35.238  45.159  1.00 43.48           C  
ATOM    352  O   LEU A  28      32.914  34.014  45.018  1.00 44.46           O  
ATOM    353  CB  LEU A  28      35.177  35.778  45.847  1.00 44.86           C  
ATOM    354  CG  LEU A  28      36.584  36.270  45.471  1.00 47.04           C  
ATOM    355  CD1 LEU A  28      37.526  36.189  46.692  1.00 49.01           C  
ATOM    356  CD2 LEU A  28      37.149  35.484  44.283  1.00 48.01           C  
ATOM    357  N   LYS A  29      31.680  35.834  45.564  1.00 43.20           N  
ATOM    358  CA  LYS A  29      30.467  35.065  45.936  1.00 42.84           C  
ATOM    359  C   LYS A  29      29.990  34.148  44.807  1.00 42.15           C  
ATOM    360  O   LYS A  29      29.925  34.553  43.637  1.00 39.12           O  
ATOM    361  CB  LYS A  29      29.300  35.971  46.347  1.00 41.57           C  
ATOM    362  CG  LYS A  29      28.081  35.233  46.936  1.00 43.87           C  
ATOM    363  CD  LYS A  29      26.931  36.191  47.210  1.00 47.44           C  
ATOM    364  N   ASN A  30      29.648  32.922  45.187  1.00 41.66           N  
ATOM    365  CA  ASN A  30      29.154  31.929  44.266  1.00 44.75           C  
ATOM    366  C   ASN A  30      27.689  32.221  43.945  1.00 45.15           C  
ATOM    367  O   ASN A  30      26.868  32.337  44.855  1.00 44.96           O  
ATOM    368  CB  ASN A  30      29.265  30.534  44.854  1.00 45.30           C  
ATOM    369  CG  ASN A  30      28.975  29.459  43.835  1.00 51.80           C  
ATOM    370  OD1 ASN A  30      29.817  29.163  42.988  1.00 61.65           O  
ATOM    371  ND2 ASN A  30      27.791  28.852  43.919  1.00 60.74           N  
ATOM    372  N   ARG A  31      27.385  32.305  42.654  1.00 44.43           N  
ATOM    373  CA  ARG A  31      26.045  32.578  42.125  1.00 44.22           C  
ATOM    374  C   ARG A  31      25.707  31.481  41.118  1.00 46.67           C  
ATOM    375  O   ARG A  31      26.591  30.749  40.691  1.00 49.29           O  
ATOM    376  CB  ARG A  31      26.034  33.944  41.440  1.00 44.86           C  
ATOM    377  CG  ARG A  31      26.600  35.081  42.297  1.00 42.70           C  
ATOM    378  CD  ARG A  31      26.753  36.389  41.577  1.00 41.17           C  
ATOM    379  NE  ARG A  31      27.409  37.354  42.468  1.00 38.92           N  
ATOM    380  CZ  ARG A  31      26.810  37.986  43.476  1.00 34.63           C  
ATOM    381  NH1 ARG A  31      25.505  37.830  43.732  1.00 45.77           N  
ATOM    382  NH2 ARG A  31      27.526  38.801  44.247  1.00 34.92           N  
ATOM    383  N   LEU A  32      24.434  31.361  40.749  1.00 47.65           N  
ATOM    384  CA  LEU A  32      23.989  30.386  39.733  1.00 45.61           C  
ATOM    385  C   LEU A  32      24.212  30.934  38.322  1.00 46.12           C  
ATOM    386  O   LEU A  32      23.998  32.124  38.080  1.00 44.92           O  
ATOM    387  CB  LEU A  32      22.509  30.020  39.938  1.00 46.16           C  
ATOM    388  CG  LEU A  32      22.215  29.226  41.209  1.00 42.23           C  
ATOM    389  CD1 LEU A  32      20.727  29.210  41.528  1.00 42.34           C  
ATOM    390  CD2 LEU A  32      22.754  27.808  41.085  1.00 45.80           C  
ATOM    391  N   GLY A  33      24.656  30.064  37.408  1.00 44.90           N  
ATOM    392  CA  GLY A  33      24.900  30.410  36.004  1.00 45.35           C  
ATOM    393  C   GLY A  33      26.373  30.533  35.660  1.00 45.22           C  
ATOM    394  O   GLY A  33      27.163  30.999  36.481  1.00 44.59           O  
ATOM    395  N   GLY A  34      26.734  30.106  34.446  1.00 45.59           N  
ATOM    396  CA  GLY A  34      28.111  30.186  33.920  1.00 47.35           C  
ATOM    397  C   GLY A  34      29.152  29.571  34.835  1.00 46.18           C  
ATOM    398  O   GLY A  34      28.914  28.511  35.407  1.00 43.21           O  
ATOM    399  N   VAL A  35      30.277  30.278  35.011  1.00 47.19           N  
ATOM    400  CA  VAL A  35      31.345  29.846  35.945  1.00 46.87           C  
ATOM    401  C   VAL A  35      31.153  30.405  37.393  1.00 44.88           C  
ATOM    402  O   VAL A  35      32.085  30.435  38.199  1.00 42.00           O  
ATOM    403  CB  VAL A  35      32.760  30.084  35.358  1.00 48.88           C  
ATOM    404  CG1 VAL A  35      32.875  29.407  33.980  1.00 52.92           C  
ATOM    405  CG2 VAL A  35      33.098  31.566  35.262  1.00 46.52           C  
ATOM    406  N   GLU A  36      29.943  30.893  37.679  1.00 43.99           N  
ATOM    407  CA  GLU A  36      29.424  31.158  39.034  1.00 44.04           C  
ATOM    408  C   GLU A  36      29.921  32.314  39.908  1.00 45.42           C  
ATOM    409  O   GLU A  36      29.263  32.590  40.908  1.00 49.36           O  
ATOM    410  CB  GLU A  36      29.474  29.848  39.848  1.00 42.92           C  
ATOM    411  CG  GLU A  36      28.683  28.723  39.191  1.00 41.07           C  
ATOM    412  CD  GLU A  36      28.503  27.518  40.095  1.00 47.14           C  
ATOM    413  OE1 GLU A  36      29.429  27.188  40.864  1.00 44.64           O  
ATOM    414  OE2 GLU A  36      27.433  26.887  40.015  1.00 46.98           O  
ATOM    415  N   ASN A  37      31.060  32.943  39.629  1.00 43.22           N  
ATOM    416  CA  ASN A  37      31.410  34.167  40.386  1.00 40.49           C  
ATOM    417  C   ASN A  37      31.944  35.209  39.430  1.00 37.66           C  
ATOM    418  O   ASN A  37      32.456  34.863  38.369  1.00 35.59           O  
ATOM    419  CB  ASN A  37      32.302  33.913  41.625  1.00 39.83           C  
ATOM    420  CG  ASN A  37      33.746  33.620  41.291  1.00 43.80           C  
ATOM    421  OD1 ASN A  37      34.526  34.529  41.006  1.00 43.74           O  
ATOM    422  ND2 ASN A  37      34.133  32.354  41.410  1.00 45.11           N  
ATOM    423  N   ILE A  38      31.826  36.471  39.841  1.00 36.66           N  
ATOM    424  CA  ILE A  38      32.153  37.621  38.991  1.00 37.13           C  
ATOM    425  C   ILE A  38      33.630  37.646  38.606  1.00 36.81           C  
ATOM    426  O   ILE A  38      33.949  37.740  37.412  1.00 36.03           O  
ATOM    427  CB  ILE A  38      31.705  38.946  39.664  1.00 37.11           C  
ATOM    428  CG1 ILE A  38      30.174  38.994  39.718  1.00 37.48           C  
ATOM    429  CG2 ILE A  38      32.258  40.176  38.931  1.00 37.56           C  
ATOM    430  CD1 ILE A  38      29.629  40.017  40.660  1.00 35.07           C  
ATOM    431  N   LEU A  39      34.516  37.523  39.590  1.00 35.59           N  
ATOM    432  CA  LEU A  39      35.981  37.583  39.323  1.00 37.00           C  
ATOM    433  C   LEU A  39      36.450  36.430  38.436  1.00 36.90           C  
ATOM    434  O   LEU A  39      37.224  36.649  37.494  1.00 35.44           O  
ATOM    435  CB  LEU A  39      36.815  37.631  40.622  1.00 37.40           C  
ATOM    436  CG  LEU A  39      38.300  38.013  40.478  1.00 34.69           C  
ATOM    437  CD1 LEU A  39      38.422  39.401  39.832  1.00 36.46           C  
ATOM    438  CD2 LEU A  39      39.047  37.940  41.832  1.00 38.61           C  
ATOM    439  N   TYR A  40      35.973  35.216  38.728  1.00 38.93           N  
ATOM    440  CA  TYR A  40      36.315  34.040  37.925  1.00 39.79           C  
ATOM    441  C   TYR A  40      35.753  34.146  36.495  1.00 38.04           C  
ATOM    442  O   TYR A  40      36.391  33.699  35.542  1.00 35.45           O  
ATOM    443  CB  TYR A  40      35.878  32.727  38.593  1.00 43.95           C  
ATOM    444  CG  TYR A  40      36.410  31.508  37.858  1.00 48.02           C  
ATOM    445  CD1 TYR A  40      37.779  31.365  37.610  1.00 53.44           C  
ATOM    446  CD2 TYR A  40      35.562  30.524  37.380  1.00 51.56           C  
ATOM    447  CE1 TYR A  40      38.290  30.288  36.912  1.00 55.06           C  
ATOM    448  CE2 TYR A  40      36.063  29.425  36.665  1.00 56.16           C  
ATOM    449  CZ  TYR A  40      37.432  29.314  36.438  1.00 58.01           C  
ATOM    450  OH  TYR A  40      37.948  28.233  35.753  1.00 62.57           O  
ATOM    451  N   THR A  41      34.572  34.742  36.336  1.00 38.23           N  
ATOM    452  CA  THR A  41      34.039  34.980  34.990  1.00 37.14           C  
ATOM    453  C   THR A  41      35.017  35.839  34.157  1.00 37.81           C  
ATOM    454  O   THR A  41      35.282  35.526  33.004  1.00 38.56           O  
ATOM    455  CB  THR A  41      32.634  35.619  35.038  1.00 37.77           C  
ATOM    456  OG1 THR A  41      31.759  34.746  35.759  1.00 39.86           O  
ATOM    457  CG2 THR A  41      32.094  35.831  33.615  1.00 38.75           C  
ATOM    458  N   LEU A  42      35.529  36.921  34.744  1.00 39.06           N  
ATOM    459  CA  LEU A  42      36.499  37.802  34.062  1.00 36.76           C  
ATOM    460  C   LEU A  42      37.814  37.049  33.775  1.00 37.82           C  
ATOM    461  O   LEU A  42      38.337  37.125  32.662  1.00 38.60           O  
ATOM    462  CB  LEU A  42      36.716  39.093  34.863  1.00 37.35           C  
ATOM    463  CG  LEU A  42      35.503  40.048  34.884  1.00 37.76           C  
ATOM    464  CD1 LEU A  42      35.549  41.113  36.018  1.00 35.86           C  
ATOM    465  CD2 LEU A  42      35.327  40.725  33.542  1.00 39.74           C  
ATOM    466  N   PHE A  43      38.298  36.302  34.761  1.00 35.01           N  
ATOM    467  CA  PHE A  43      39.508  35.461  34.602  1.00 35.38           C  
ATOM    468  C   PHE A  43      39.338  34.422  33.490  1.00 34.35           C  
ATOM    469  O   PHE A  43      40.238  34.236  32.686  1.00 33.28           O  
ATOM    470  CB  PHE A  43      39.873  34.750  35.893  1.00 37.18           C  
ATOM    471  CG  PHE A  43      41.061  33.847  35.764  1.00 33.39           C  
ATOM    472  CD1 PHE A  43      42.350  34.346  35.934  1.00 37.53           C  
ATOM    473  CD2 PHE A  43      40.889  32.475  35.476  1.00 34.58           C  
ATOM    474  CE1 PHE A  43      43.486  33.466  35.856  1.00 31.70           C  
ATOM    475  CE2 PHE A  43      41.989  31.615  35.359  1.00 36.68           C  
ATOM    476  CZ  PHE A  43      43.287  32.104  35.545  1.00 35.09           C  
ATOM    477  N   HIS A  44      38.201  33.736  33.498  1.00 35.24           N  
ATOM    478  CA  HIS A  44      37.848  32.732  32.482  1.00 36.59           C  
ATOM    479  C   HIS A  44      37.792  33.354  31.071  1.00 35.72           C  
ATOM    480  O   HIS A  44      38.290  32.762  30.113  1.00 38.97           O  
ATOM    481  CB  HIS A  44      36.531  32.043  32.863  1.00 34.94           C  
ATOM    482  CG  HIS A  44      35.987  31.124  31.820  1.00 35.65           C  
ATOM    483  ND1 HIS A  44      36.564  29.913  31.504  1.00 34.09           N  
ATOM    484  CD2 HIS A  44      34.877  31.220  31.066  1.00 35.50           C  
ATOM    485  CE1 HIS A  44      35.853  29.318  30.570  1.00 32.22           C  
ATOM    486  NE2 HIS A  44      34.823  30.098  30.280  1.00 32.36           N  
ATOM    487  N   ILE A  45      37.209  34.538  30.956  1.00 35.94           N  
ATOM    488  CA  ILE A  45      37.155  35.224  29.668  1.00 35.35           C  
ATOM    489  C   ILE A  45      38.572  35.446  29.122  1.00 35.40           C  
ATOM    490  O   ILE A  45      38.848  35.061  27.993  1.00 35.72           O  
ATOM    491  CB  ILE A  45      36.398  36.571  29.751  1.00 36.13           C  
ATOM    492  CG1 ILE A  45      34.880  36.344  29.853  1.00 38.42           C  
ATOM    493  CG2 ILE A  45      36.679  37.417  28.551  1.00 33.53           C  
ATOM    494  CD1 ILE A  45      34.132  37.594  30.409  1.00 32.67           C  
ATOM    495  N   ILE A  46      39.464  36.001  29.947  1.00 36.22           N  
ATOM    496  CA  ILE A  46      40.828  36.329  29.489  1.00 38.26           C  
ATOM    497  C   ILE A  46      41.685  35.089  29.225  1.00 37.79           C  
ATOM    498  O   ILE A  46      42.486  35.087  28.294  1.00 36.32           O  
ATOM    499  CB  ILE A  46      41.559  37.367  30.409  1.00 39.69           C  
ATOM    500  CG1 ILE A  46      41.862  36.835  31.798  1.00 40.20           C  
ATOM    501  CG2 ILE A  46      40.733  38.617  30.543  1.00 38.00           C  
ATOM    502  CD1 ILE A  46      42.704  37.813  32.626  1.00 43.45           C  
ATOM    503  N   ASP A  47      41.487  34.051  30.041  1.00 35.55           N  
ATOM    504  CA  ASP A  47      42.180  32.784  29.911  1.00 36.29           C  
ATOM    505  C   ASP A  47      41.846  32.109  28.568  1.00 36.14           C  
ATOM    506  O   ASP A  47      42.749  31.711  27.817  1.00 38.83           O  
ATOM    507  CB  ASP A  47      41.786  31.879  31.103  1.00 35.60           C  
ATOM    508  CG  ASP A  47      42.521  30.560  31.140  1.00 42.60           C  
ATOM    509  OD1 ASP A  47      43.703  30.487  30.733  1.00 37.99           O  
ATOM    510  OD2 ASP A  47      41.902  29.606  31.645  1.00 42.01           O  
ATOM    511  N   VAL A  48      40.553  31.979  28.282  1.00 35.33           N  
ATOM    512  CA  VAL A  48      40.075  31.335  27.053  1.00 35.05           C  
ATOM    513  C   VAL A  48      40.541  32.130  25.833  1.00 35.61           C  
ATOM    514  O   VAL A  48      41.122  31.558  24.920  1.00 37.24           O  
ATOM    515  CB  VAL A  48      38.540  31.088  27.097  1.00 33.32           C  
ATOM    516  CG1 VAL A  48      38.004  30.584  25.769  1.00 33.92           C  
ATOM    517  CG2 VAL A  48      38.222  30.065  28.215  1.00 36.42           C  
ATOM    518  N   GLU A  49      40.386  33.449  25.871  1.00 34.92           N  
ATOM    519  CA  GLU A  49      40.828  34.285  24.753  1.00 36.11           C  
ATOM    520  C   GLU A  49      42.319  34.109  24.470  1.00 35.09           C  
ATOM    521  O   GLU A  49      42.706  33.926  23.322  1.00 33.55           O  
ATOM    522  CB  GLU A  49      40.576  35.760  25.018  1.00 34.51           C  
ATOM    523  CG  GLU A  49      41.050  36.690  23.871  1.00 37.25           C  
ATOM    524  CD  GLU A  49      40.896  38.145  24.203  1.00 37.35           C  
ATOM    525  OE1 GLU A  49      41.418  38.561  25.254  1.00 37.13           O  
ATOM    526  OE2 GLU A  49      40.306  38.892  23.391  1.00 35.72           O  
ATOM    527  N   TYR A  50      43.148  34.210  25.511  1.00 35.72           N  
ATOM    528  CA  TYR A  50      44.597  34.136  25.331  1.00 36.02           C  
ATOM    529  C   TYR A  50      45.044  32.752  24.827  1.00 37.58           C  
ATOM    530  O   TYR A  50      45.853  32.651  23.894  1.00 36.01           O  
ATOM    531  CB  TYR A  50      45.301  34.529  26.633  1.00 37.85           C  
ATOM    532  CG  TYR A  50      46.804  34.544  26.563  1.00 38.74           C  
ATOM    533  CD1 TYR A  50      47.481  35.559  25.870  1.00 42.31           C  
ATOM    534  CD2 TYR A  50      47.573  33.583  27.243  1.00 38.58           C  
ATOM    535  CE1 TYR A  50      48.886  35.588  25.826  1.00 41.79           C  
ATOM    536  CE2 TYR A  50      48.956  33.598  27.192  1.00 40.14           C  
ATOM    537  CZ  TYR A  50      49.612  34.615  26.486  1.00 44.56           C  
ATOM    538  OH  TYR A  50      50.991  34.642  26.432  1.00 48.12           O  
ATOM    539  N   SER A  51      44.499  31.698  25.429  1.00 37.91           N  
ATOM    540  CA  SER A  51      44.773  30.321  24.993  1.00 38.71           C  
ATOM    541  C   SER A  51      44.530  30.062  23.495  1.00 37.23           C  
ATOM    542  O   SER A  51      45.384  29.483  22.820  1.00 36.12           O  
ATOM    543  CB  SER A  51      43.936  29.336  25.806  1.00 40.72           C  
ATOM    544  OG  SER A  51      44.302  29.433  27.164  1.00 43.03           O  
ATOM    545  N   TRP A  52      43.390  30.512  22.984  1.00 38.03           N  
ATOM    546  CA  TRP A  52      43.090  30.339  21.570  1.00 37.40           C  
ATOM    547  C   TRP A  52      44.034  31.161  20.689  1.00 38.24           C  
ATOM    548  O   TRP A  52      44.553  30.643  19.708  1.00 37.67           O  
ATOM    549  CB  TRP A  52      41.625  30.639  21.265  1.00 37.48           C  
ATOM    550  CG  TRP A  52      40.691  29.557  21.703  1.00 37.70           C  
ATOM    551  CD1 TRP A  52      39.886  29.555  22.793  1.00 37.84           C  
ATOM    552  CD2 TRP A  52      40.473  28.304  21.037  1.00 40.16           C  
ATOM    553  NE1 TRP A  52      39.176  28.385  22.858  1.00 39.30           N  
ATOM    554  CE2 TRP A  52      39.509  27.594  21.791  1.00 39.18           C  
ATOM    555  CE3 TRP A  52      40.986  27.721  19.868  1.00 45.60           C  
ATOM    556  CZ2 TRP A  52      39.026  26.326  21.406  1.00 42.52           C  
ATOM    557  CZ3 TRP A  52      40.526  26.450  19.485  1.00 46.44           C  
ATOM    558  CH2 TRP A  52      39.548  25.763  20.260  1.00 45.85           C  
ATOM    559  N   ILE A  53      44.277  32.419  21.064  1.00 41.23           N  
ATOM    560  CA  ILE A  53      45.201  33.314  20.325  1.00 41.57           C  
ATOM    561  C   ILE A  53      46.602  32.697  20.296  1.00 40.77           C  
ATOM    562  O   ILE A  53      47.275  32.743  19.265  1.00 41.13           O  
ATOM    563  CB  ILE A  53      45.200  34.781  20.899  1.00 40.35           C  
ATOM    564  CG1 ILE A  53      43.851  35.471  20.661  1.00 41.61           C  
ATOM    565  CG2 ILE A  53      46.317  35.632  20.301  1.00 38.16           C  
ATOM    566  CD1 ILE A  53      43.530  35.810  19.202  1.00 45.14           C  
ATOM    567  N   ARG A  54      47.018  32.104  21.419  1.00 41.78           N  
ATOM    568  CA  ARG A  54      48.288  31.384  21.503  1.00 41.60           C  
ATOM    569  C   ARG A  54      48.308  30.151  20.585  1.00 42.20           C  
ATOM    570  O   ARG A  54      49.337  29.862  19.975  1.00 39.58           O  
ATOM    571  CB  ARG A  54      48.604  30.986  22.957  1.00 43.03           C  
ATOM    572  CG  ARG A  54      48.917  32.209  23.852  1.00 44.64           C  
ATOM    573  CD  ARG A  54      50.257  32.866  23.578  1.00 44.08           C  
ATOM    574  NE  ARG A  54      51.369  32.052  24.035  1.00 52.39           N  
ATOM    575  CZ  ARG A  54      52.643  32.436  24.042  1.00 51.90           C  
ATOM    576  NH1 ARG A  54      53.025  33.633  23.573  1.00 58.77           N  
ATOM    577  NH2 ARG A  54      53.550  31.585  24.506  1.00 39.79           N  
ATOM    578  N   ALA A  55      47.171  29.444  20.489  1.00 42.32           N  
ATOM    579  CA  ALA A  55      47.019  28.309  19.559  1.00 42.52           C  
ATOM    580  C   ALA A  55      47.195  28.805  18.118  1.00 42.19           C  
ATOM    581  O   ALA A  55      47.896  28.173  17.334  1.00 41.45           O  
ATOM    582  CB  ALA A  55      45.652  27.625  19.731  1.00 42.61           C  
ATOM    583  N   ILE A  56      46.602  29.959  17.803  1.00 41.92           N  
ATOM    584  CA  ILE A  56      46.737  30.596  16.471  1.00 44.33           C  
ATOM    585  C   ILE A  56      48.197  30.961  16.197  1.00 46.41           C  
ATOM    586  O   ILE A  56      48.717  30.686  15.119  1.00 45.53           O  
ATOM    587  CB  ILE A  56      45.850  31.834  16.327  1.00 42.26           C  
ATOM    588  CG1 ILE A  56      44.379  31.425  16.281  1.00 42.87           C  
ATOM    589  CG2 ILE A  56      46.198  32.630  15.069  1.00 47.32           C  
ATOM    590  CD1 ILE A  56      43.448  32.563  16.301  1.00 35.28           C  
ATOM    591  N   GLN A  57      48.846  31.540  17.205  1.00 47.96           N  
ATOM    592  CA  GLN A  57      50.269  31.912  17.151  1.00 48.56           C  
ATOM    593  C   GLN A  57      51.186  30.677  16.997  1.00 49.25           C  
ATOM    594  O   GLN A  57      52.302  30.811  16.508  1.00 50.46           O  
ATOM    595  CB  GLN A  57      50.638  32.729  18.409  1.00 47.76           C  
ATOM    596  CG  GLN A  57      51.916  33.549  18.337  1.00 49.06           C  
ATOM    597  CD  GLN A  57      52.281  34.225  19.669  1.00 49.32           C  
ATOM    598  OE1 GLN A  57      51.559  34.118  20.662  1.00 48.68           O  
ATOM    599  NE2 GLN A  57      53.415  34.920  19.686  1.00 50.64           N  
ATOM    600  N   GLY A  58      50.699  29.490  17.382  1.00 50.02           N  
ATOM    601  CA  GLY A  58      51.434  28.230  17.320  1.00 49.98           C  
ATOM    602  C   GLY A  58      52.143  27.875  18.621  1.00 52.65           C  
ATOM    603  O   GLY A  58      52.880  26.884  18.675  1.00 52.79           O  
ATOM    604  N   LYS A  59      51.896  28.663  19.672  1.00 55.46           N  
ATOM    605  CA  LYS A  59      52.539  28.513  20.974  1.00 57.74           C  
ATOM    606  C   LYS A  59      51.576  27.900  21.985  1.00 60.30           C  
ATOM    607  O   LYS A  59      50.363  28.112  21.906  1.00 62.27           O  
ATOM    608  CB  LYS A  59      53.027  29.878  21.457  1.00 57.97           C  
ATOM    609  CG  LYS A  59      53.877  30.599  20.419  1.00 60.07           C  
ATOM    610  CD  LYS A  59      54.663  31.756  21.001  1.00 65.15           C  
ATOM    611  CE  LYS A  59      55.631  32.334  19.966  1.00 66.83           C  
ATOM    612  NZ  LYS A  59      56.589  33.300  20.569  1.00 68.90           N  
ATOM    613  N   GLU A  60      52.124  27.128  22.921  1.00 62.40           N  
ATOM    614  CA  GLU A  60      51.370  26.462  23.984  1.00 64.32           C  
ATOM    615  C   GLU A  60      51.845  27.001  25.322  1.00 65.67           C  
ATOM    616  O   GLU A  60      53.038  27.300  25.476  1.00 67.60           O  
ATOM    617  CB  GLU A  60      51.604  24.960  23.903  1.00 64.10           C  
ATOM    618  CG  GLU A  60      50.751  24.128  24.860  1.00 65.88           C  
ATOM    619  CD  GLU A  60      50.910  22.618  24.671  1.00 66.72           C  
ATOM    620  OE1 GLU A  60      51.545  22.159  23.688  1.00 67.60           O  
ATOM    621  OE2 GLU A  60      50.375  21.876  25.524  1.00 76.12           O  
ATOM    622  N   ASP A  61      50.930  27.101  26.289  1.00 65.93           N  
ATOM    623  CA  ASP A  61      51.248  27.620  27.632  1.00 65.99           C  
ATOM    624  C   ASP A  61      50.790  26.714  28.748  1.00 65.19           C  
ATOM    625  O   ASP A  61      49.842  25.944  28.585  1.00 65.34           O  
ATOM    626  CB  ASP A  61      50.594  28.981  27.845  1.00 65.96           C  
ATOM    627  CG  ASP A  61      51.202  30.051  26.979  1.00 68.09           C  
ATOM    628  OD1 ASP A  61      52.368  30.419  27.226  1.00 69.53           O  
ATOM    629  OD2 ASP A  61      50.506  30.535  26.072  1.00 67.03           O  
ATOM    630  N   ILE A  62      51.479  26.836  29.887  1.00 64.74           N  
ATOM    631  CA  ILE A  62      51.115  26.141  31.114  1.00 63.65           C  
ATOM    632  C   ILE A  62      49.850  26.850  31.601  1.00 62.37           C  
ATOM    633  O   ILE A  62      49.747  28.085  31.493  1.00 61.76           O  
ATOM    634  CB  ILE A  62      52.223  26.202  32.197  1.00 63.01           C  
ATOM    635  N   ALA A  63      48.886  26.068  32.086  1.00 60.65           N  
ATOM    636  CA  ALA A  63      47.606  26.596  32.550  1.00 59.12           C  
ATOM    637  C   ALA A  63      47.810  27.660  33.620  1.00 56.41           C  
ATOM    638  O   ALA A  63      48.608  27.472  34.542  1.00 55.41           O  
ATOM    639  CB  ALA A  63      46.701  25.468  33.089  1.00 59.99           C  
ATOM    640  N   VAL A  64      47.133  28.792  33.443  1.00 53.97           N  
ATOM    641  CA  VAL A  64      47.137  29.869  34.408  1.00 52.44           C  
ATOM    642  C   VAL A  64      46.127  29.389  35.432  1.00 49.62           C  
ATOM    643  O   VAL A  64      45.044  28.938  35.065  1.00 50.23           O  
ATOM    644  CB  VAL A  64      46.738  31.215  33.769  1.00 54.93           C  
ATOM    645  CG1 VAL A  64      46.680  32.301  34.800  1.00 57.20           C  
ATOM    646  CG2 VAL A  64      47.737  31.586  32.682  1.00 59.37           C  
ATOM    647  N   GLN A  65      46.495  29.425  36.704  1.00 48.52           N  
ATOM    648  CA  GLN A  65      45.618  28.948  37.769  1.00 46.99           C  
ATOM    649  C   GLN A  65      44.987  30.137  38.451  1.00 42.36           C  
ATOM    650  O   GLN A  65      45.707  31.018  38.916  1.00 37.27           O  
ATOM    651  CB  GLN A  65      46.392  28.114  38.790  1.00 46.94           C  
ATOM    652  CG  GLN A  65      47.195  26.935  38.196  1.00 55.98           C  
ATOM    653  CD  GLN A  65      46.362  25.931  37.386  1.00 63.42           C  
ATOM    654  OE1 GLN A  65      45.135  25.844  37.520  1.00 70.21           O  
ATOM    655  NE2 GLN A  65      47.042  25.153  36.550  1.00 67.75           N  
ATOM    656  N   PHE A  66      43.649  30.129  38.522  1.00 42.06           N  
ATOM    657  CA  PHE A  66      42.865  31.188  39.161  1.00 42.77           C  
ATOM    658  C   PHE A  66      43.312  31.446  40.611  1.00 41.62           C  
ATOM    659  O   PHE A  66      43.313  32.594  41.062  1.00 43.07           O  
ATOM    660  CB  PHE A  66      41.360  30.880  39.068  1.00 42.89           C  
ATOM    661  CG  PHE A  66      40.466  31.958  39.640  1.00 45.62           C  
ATOM    662  CD1 PHE A  66      40.626  33.291  39.267  1.00 41.77           C  
ATOM    663  CD2 PHE A  66      39.409  31.628  40.497  1.00 49.00           C  
ATOM    664  CE1 PHE A  66      39.783  34.296  39.777  1.00 42.23           C  
ATOM    665  CE2 PHE A  66      38.553  32.623  41.001  1.00 46.78           C  
ATOM    666  CZ  PHE A  66      38.739  33.958  40.638  1.00 41.01           C  
ATOM    667  N   ALA A  67      43.753  30.400  41.315  1.00 42.39           N  
ATOM    668  CA  ALA A  67      44.317  30.536  42.681  1.00 40.46           C  
ATOM    669  C   ALA A  67      45.452  31.579  42.790  1.00 39.77           C  
ATOM    670  O   ALA A  67      45.573  32.262  43.815  1.00 39.87           O  
ATOM    671  CB  ALA A  67      44.795  29.175  43.210  1.00 42.23           C  
ATOM    672  N   ASP A  68      46.258  31.711  41.731  1.00 40.05           N  
ATOM    673  CA  ASP A  68      47.320  32.735  41.670  1.00 42.77           C  
ATOM    674  C   ASP A  68      46.813  34.177  41.325  1.00 41.62           C  
ATOM    675  O   ASP A  68      47.618  35.118  41.361  1.00 41.58           O  
ATOM    676  CB  ASP A  68      48.403  32.324  40.658  1.00 40.74           C  
ATOM    677  CG  ASP A  68      49.081  30.991  41.004  1.00 56.44           C  
ATOM    678  OD1 ASP A  68      49.269  30.639  42.203  1.00 31.12           O  
ATOM    679  OD2 ASP A  68      49.466  30.279  40.053  1.00 53.84           O  
ATOM    680  N   TYR A  69      45.522  34.340  40.977  1.00 43.31           N  
ATOM    681  CA  TYR A  69      44.916  35.643  40.614  1.00 41.69           C  
ATOM    682  C   TYR A  69      43.571  35.845  41.344  1.00 42.20           C  
ATOM    683  O   TYR A  69      42.529  36.007  40.708  1.00 42.97           O  
ATOM    684  CB  TYR A  69      44.741  35.746  39.082  1.00 42.39           C  
ATOM    685  CG  TYR A  69      46.030  35.545  38.331  1.00 42.03           C  
ATOM    686  CD1 TYR A  69      46.459  34.271  38.001  1.00 38.39           C  
ATOM    687  CD2 TYR A  69      46.834  36.630  37.957  1.00 46.22           C  
ATOM    688  CE1 TYR A  69      47.665  34.059  37.347  1.00 44.72           C  
ATOM    689  CE2 TYR A  69      48.059  36.422  37.289  1.00 42.70           C  
ATOM    690  CZ  TYR A  69      48.453  35.135  36.980  1.00 40.44           C  
ATOM    691  OH  TYR A  69      49.644  34.911  36.328  1.00 45.21           O  
ATOM    692  N   GLN A  70      43.610  35.893  42.677  1.00 41.45           N  
ATOM    693  CA  GLN A  70      42.375  35.986  43.505  1.00 43.05           C  
ATOM    694  C   GLN A  70      41.877  37.393  43.856  1.00 42.53           C  
ATOM    695  O   GLN A  70      41.025  37.534  44.738  1.00 42.18           O  
ATOM    696  CB  GLN A  70      42.548  35.154  44.797  1.00 44.09           C  
ATOM    697  CG  GLN A  70      42.604  33.673  44.555  1.00 50.34           C  
ATOM    698  CD  GLN A  70      41.274  33.128  44.087  1.00 53.00           C  
ATOM    699  OE1 GLN A  70      40.298  33.112  44.836  1.00 60.50           O  
ATOM    700  NE2 GLN A  70      41.234  32.665  42.847  1.00 53.38           N  
ATOM    701  N   THR A  71      42.373  38.421  43.155  1.00 41.26           N  
ATOM    702  CA  THR A  71      41.982  39.802  43.399  1.00 39.37           C  
ATOM    703  C   THR A  71      41.658  40.470  42.073  1.00 38.32           C  
ATOM    704  O   THR A  71      42.126  40.043  41.014  1.00 38.97           O  
ATOM    705  CB  THR A  71      43.097  40.603  44.096  1.00 40.11           C  
ATOM    706  OG1 THR A  71      44.197  40.804  43.199  1.00 37.95           O  
ATOM    707  CG2 THR A  71      43.587  39.889  45.398  1.00 35.87           C  
ATOM    708  N   LEU A  72      40.866  41.527  42.148  1.00 39.14           N  
ATOM    709  CA  LEU A  72      40.501  42.288  40.961  1.00 37.88           C  
ATOM    710  C   LEU A  72      41.751  42.871  40.263  1.00 37.08           C  
ATOM    711  O   LEU A  72      41.870  42.751  39.038  1.00 36.39           O  
ATOM    712  CB  LEU A  72      39.506  43.373  41.329  1.00 39.19           C  
ATOM    713  CG  LEU A  72      38.960  44.246  40.220  1.00 38.55           C  
ATOM    714  CD1 LEU A  72      38.147  43.403  39.211  1.00 38.38           C  
ATOM    715  CD2 LEU A  72      38.127  45.356  40.844  1.00 42.67           C  
ATOM    716  N   ASN A  73      42.664  43.473  41.032  1.00 33.60           N  
ATOM    717  CA  ASN A  73      43.902  44.042  40.473  1.00 35.44           C  
ATOM    718  C   ASN A  73      44.753  43.016  39.734  1.00 36.37           C  
ATOM    719  O   ASN A  73      45.266  43.317  38.655  1.00 37.54           O  
ATOM    720  CB  ASN A  73      44.756  44.731  41.550  1.00 39.14           C  
ATOM    721  CG  ASN A  73      44.106  45.984  42.118  1.00 44.21           C  
ATOM    722  OD1 ASN A  73      43.068  46.449  41.644  1.00 45.66           O  
ATOM    723  ND2 ASN A  73      44.729  46.539  43.156  1.00 51.48           N  
ATOM    724  N   LYS A  74      44.873  41.814  40.306  1.00 35.48           N  
ATOM    725  CA  LYS A  74      45.649  40.721  39.682  1.00 38.73           C  
ATOM    726  C   LYS A  74      45.040  40.254  38.361  1.00 37.39           C  
ATOM    727  O   LYS A  74      45.778  40.031  37.379  1.00 35.31           O  
ATOM    728  CB  LYS A  74      45.850  39.531  40.633  1.00 37.95           C  
ATOM    729  CG  LYS A  74      46.924  39.752  41.706  1.00 40.23           C  
ATOM    730  CD  LYS A  74      47.154  38.463  42.494  1.00 41.01           C  
ATOM    731  CE  LYS A  74      48.429  38.469  43.320  1.00 46.82           C  
ATOM    732  NZ  LYS A  74      48.794  37.055  43.697  1.00 54.03           N  
ATOM    733  N   VAL A  75      43.706  40.131  38.331  1.00 38.25           N  
ATOM    734  CA  VAL A  75      42.992  39.741  37.114  1.00 35.50           C  
ATOM    735  C   VAL A  75      43.090  40.880  36.058  1.00 36.23           C  
ATOM    736  O   VAL A  75      43.336  40.584  34.886  1.00 35.93           O  
ATOM    737  CB  VAL A  75      41.531  39.265  37.399  1.00 35.14           C  
ATOM    738  CG1 VAL A  75      40.807  38.915  36.096  1.00 33.14           C  
ATOM    739  CG2 VAL A  75      41.546  38.061  38.365  1.00 34.63           C  
ATOM    740  N   LYS A  76      42.942  42.145  36.471  1.00 37.17           N  
ATOM    741  CA  LYS A  76      43.120  43.286  35.552  1.00 37.25           C  
ATOM    742  C   LYS A  76      44.551  43.331  34.960  1.00 36.00           C  
ATOM    743  O   LYS A  76      44.717  43.559  33.770  1.00 34.43           O  
ATOM    744  CB  LYS A  76      42.770  44.614  36.247  1.00 36.99           C  
ATOM    745  CG  LYS A  76      43.000  45.889  35.447  1.00 42.57           C  
ATOM    746  CD  LYS A  76      42.140  45.959  34.173  1.00 51.36           C  
ATOM    747  CE  LYS A  76      42.398  47.256  33.430  1.00 49.12           C  
ATOM    748  NZ  LYS A  76      41.674  47.269  32.148  1.00 56.83           N  
ATOM    749  N   SER A  77      45.570  43.114  35.793  1.00 36.19           N  
ATOM    750  CA  SER A  77      46.960  43.088  35.320  1.00 37.77           C  
ATOM    751  C   SER A  77      47.205  41.949  34.327  1.00 37.98           C  
ATOM    752  O   SER A  77      47.882  42.153  33.305  1.00 39.58           O  
ATOM    753  CB  SER A  77      47.940  43.009  36.496  1.00 36.65           C  
ATOM    754  OG  SER A  77      47.823  44.198  37.255  1.00 44.69           O  
ATOM    755  N   LEU A  78      46.642  40.769  34.614  1.00 37.55           N  
ATOM    756  CA  LEU A  78      46.732  39.619  33.703  1.00 35.94           C  
ATOM    757  C   LEU A  78      46.055  39.966  32.373  1.00 32.69           C  
ATOM    758  O   LEU A  78      46.602  39.659  31.316  1.00 34.29           O  
ATOM    759  CB  LEU A  78      46.101  38.346  34.293  1.00 34.32           C  
ATOM    760  CG  LEU A  78      46.281  37.032  33.530  1.00 37.73           C  
ATOM    761  CD1 LEU A  78      47.719  36.563  33.627  1.00 33.97           C  
ATOM    762  CD2 LEU A  78      45.334  35.967  34.064  1.00 36.28           C  
ATOM    763  N   SER A  79      44.884  40.611  32.429  1.00 37.24           N  
ATOM    764  CA  SER A  79      44.158  41.027  31.226  1.00 36.63           C  
ATOM    765  C   SER A  79      45.048  41.876  30.312  1.00 37.53           C  
ATOM    766  O   SER A  79      45.173  41.592  29.125  1.00 39.43           O  
ATOM    767  CB  SER A  79      42.876  41.788  31.593  1.00 38.42           C  
ATOM    768  OG  SER A  79      42.152  42.142  30.437  1.00 36.49           O  
ATOM    769  N   ASN A  80      45.663  42.894  30.891  1.00 39.84           N  
ATOM    770  CA  ASN A  80      46.583  43.784  30.173  1.00 40.26           C  
ATOM    771  C   ASN A  80      47.830  43.083  29.622  1.00 38.59           C  
ATOM    772  O   ASN A  80      48.250  43.375  28.496  1.00 38.88           O  
ATOM    773  CB  ASN A  80      46.980  44.981  31.067  1.00 41.23           C  
ATOM    774  CG  ASN A  80      45.830  45.992  31.255  1.00 40.65           C  
ATOM    775  OD1 ASN A  80      44.875  46.057  30.457  1.00 45.06           O  
ATOM    776  ND2 ASN A  80      45.942  46.805  32.294  1.00 47.65           N  
ATOM    777  N   THR A  81      48.411  42.171  30.406  1.00 38.02           N  
ATOM    778  CA  THR A  81      49.580  41.392  29.975  1.00 38.60           C  
ATOM    779  C   THR A  81      49.254  40.529  28.758  1.00 37.82           C  
ATOM    780  O   THR A  81      49.975  40.586  27.759  1.00 37.80           O  
ATOM    781  CB  THR A  81      50.140  40.502  31.099  1.00 39.18           C  
ATOM    782  OG1 THR A  81      50.526  41.334  32.197  1.00 42.51           O  
ATOM    783  CG2 THR A  81      51.364  39.706  30.627  1.00 45.06           C  
ATOM    784  N   PHE A  82      48.160  39.761  28.844  1.00 36.97           N  
ATOM    785  CA  PHE A  82      47.710  38.951  27.709  1.00 37.14           C  
ATOM    786  C   PHE A  82      47.378  39.799  26.471  1.00 37.65           C  
ATOM    787  O   PHE A  82      47.731  39.417  25.353  1.00 37.78           O  
ATOM    788  CB  PHE A  82      46.481  38.110  28.046  1.00 37.98           C  
ATOM    789  CG  PHE A  82      46.723  36.963  29.021  1.00 35.76           C  
ATOM    790  CD1 PHE A  82      47.989  36.402  29.265  1.00 40.60           C  
ATOM    791  CD2 PHE A  82      45.605  36.346  29.594  1.00 42.76           C  
ATOM    792  CE1 PHE A  82      48.133  35.319  30.146  1.00 39.21           C  
ATOM    793  CE2 PHE A  82      45.740  35.251  30.458  1.00 35.47           C  
ATOM    794  CZ  PHE A  82      46.996  34.741  30.736  1.00 40.14           C  
ATOM    795  N   ARG A  83      46.743  40.948  26.691  1.00 36.79           N  
ATOM    796  CA  ARG A  83      46.350  41.852  25.602  1.00 36.72           C  
ATOM    797  C   ARG A  83      47.535  42.323  24.767  1.00 34.74           C  
ATOM    798  O   ARG A  83      47.439  42.359  23.546  1.00 34.25           O  
ATOM    799  CB  ARG A  83      45.556  43.049  26.132  1.00 35.90           C  
ATOM    800  CG  ARG A  83      44.969  43.906  25.007  1.00 39.74           C  
ATOM    801  CD  ARG A  83      44.053  44.946  25.542  1.00 40.14           C  
ATOM    802  NE  ARG A  83      42.840  44.343  26.105  1.00 38.90           N  
ATOM    803  CZ  ARG A  83      41.985  44.972  26.908  1.00 39.36           C  
ATOM    804  NH1 ARG A  83      42.156  46.247  27.217  1.00 38.44           N  
ATOM    805  NH2 ARG A  83      40.921  44.324  27.373  1.00 40.66           N  
ATOM    806  N   THR A  84      48.632  42.672  25.430  1.00 37.50           N  
ATOM    807  CA  THR A  84      49.870  43.092  24.754  1.00 38.91           C  
ATOM    808  C   THR A  84      50.322  42.061  23.702  1.00 38.91           C  
ATOM    809  O   THR A  84      50.632  42.424  22.567  1.00 40.74           O  
ATOM    810  CB  THR A  84      50.979  43.377  25.794  1.00 37.77           C  
ATOM    811  OG1 THR A  84      50.551  44.464  26.609  1.00 41.50           O  
ATOM    812  CG2 THR A  84      52.300  43.748  25.137  1.00 43.76           C  
ATOM    813  N   GLU A  85      50.301  40.789  24.084  1.00 39.93           N  
ATOM    814  CA  GLU A  85      50.654  39.690  23.182  1.00 41.12           C  
ATOM    815  C   GLU A  85      49.595  39.462  22.093  1.00 40.36           C  
ATOM    816  O   GLU A  85      49.946  39.232  20.925  1.00 39.69           O  
ATOM    817  CB  GLU A  85      50.923  38.384  23.962  1.00 42.15           C  
ATOM    818  CG  GLU A  85      52.359  38.258  24.451  1.00 52.27           C  
ATOM    819  CD  GLU A  85      53.335  38.112  23.285  1.00 54.87           C  
ATOM    820  OE1 GLU A  85      54.126  39.048  23.050  1.00 57.59           O  
ATOM    821  OE2 GLU A  85      53.242  37.101  22.556  1.00 65.71           O  
ATOM    822  N   ILE A  86      48.324  39.521  22.480  1.00 38.24           N  
ATOM    823  CA  ILE A  86      47.199  39.327  21.551  1.00 37.53           C  
ATOM    824  C   ILE A  86      47.229  40.358  20.405  1.00 38.10           C  
ATOM    825  O   ILE A  86      47.054  39.975  19.245  1.00 39.43           O  
ATOM    826  CB  ILE A  86      45.840  39.334  22.298  1.00 38.08           C  
ATOM    827  CG1 ILE A  86      45.693  38.072  23.166  1.00 36.04           C  
ATOM    828  CG2 ILE A  86      44.663  39.416  21.315  1.00 38.02           C  
ATOM    829  CD1 ILE A  86      44.655  38.201  24.291  1.00 38.14           C  
ATOM    830  N   ILE A  87      47.488  41.627  20.733  1.00 36.27           N  
ATOM    831  CA  ILE A  87      47.590  42.725  19.747  1.00 36.30           C  
ATOM    832  C   ILE A  87      48.670  42.407  18.707  1.00 37.93           C  
ATOM    833  O   ILE A  87      48.444  42.564  17.512  1.00 38.38           O  
ATOM    834  CB  ILE A  87      47.901  44.081  20.428  1.00 37.46           C  
ATOM    835  CG1 ILE A  87      46.685  44.582  21.213  1.00 44.23           C  
ATOM    836  CG2 ILE A  87      48.300  45.162  19.392  1.00 38.46           C  
ATOM    837  CD1 ILE A  87      47.024  45.638  22.232  1.00 48.22           C  
ATOM    838  N   ASP A  88      49.816  41.912  19.157  1.00 38.64           N  
ATOM    839  CA  ASP A  88      50.898  41.536  18.235  1.00 41.91           C  
ATOM    840  C   ASP A  88      50.479  40.404  17.291  1.00 42.52           C  
ATOM    841  O   ASP A  88      50.746  40.492  16.099  1.00 44.91           O  
ATOM    842  CB  ASP A  88      52.177  41.131  18.984  1.00 42.79           C  
ATOM    843  CG  ASP A  88      52.859  42.293  19.693  1.00 46.76           C  
ATOM    844  OD1 ASP A  88      52.536  43.479  19.431  1.00 47.80           O  
ATOM    845  OD2 ASP A  88      53.763  42.002  20.511  1.00 48.29           O  
ATOM    846  N   VAL A  89      49.808  39.377  17.824  1.00 40.95           N  
ATOM    847  CA  VAL A  89      49.351  38.232  17.031  1.00 41.34           C  
ATOM    848  C   VAL A  89      48.298  38.637  15.992  1.00 45.21           C  
ATOM    849  O   VAL A  89      48.350  38.177  14.852  1.00 44.89           O  
ATOM    850  CB  VAL A  89      48.809  37.093  17.937  1.00 40.36           C  
ATOM    851  CG1 VAL A  89      48.131  35.998  17.115  1.00 41.04           C  
ATOM    852  CG2 VAL A  89      49.947  36.497  18.764  1.00 36.62           C  
ATOM    853  N   LEU A  90      47.360  39.491  16.393  1.00 47.27           N  
ATOM    854  CA  LEU A  90      46.327  40.002  15.478  1.00 50.33           C  
ATOM    855  C   LEU A  90      46.928  40.949  14.414  1.00 54.79           C  
ATOM    856  O   LEU A  90      46.523  40.902  13.255  1.00 57.47           O  
ATOM    857  CB  LEU A  90      45.201  40.685  16.263  1.00 49.96           C  
ATOM    858  CG  LEU A  90      44.419  39.756  17.211  1.00 47.47           C  
ATOM    859  CD1 LEU A  90      43.414  40.579  17.979  1.00 38.89           C  
ATOM    860  CD2 LEU A  90      43.738  38.572  16.489  1.00 47.24           C  
ATOM    861  N   GLN A  91      47.900  41.776  14.798  1.00 57.96           N  
ATOM    862  CA  GLN A  91      48.596  42.667  13.847  1.00 61.96           C  
ATOM    863  C   GLN A  91      49.534  41.935  12.846  1.00 63.48           C  
ATOM    864  O   GLN A  91      50.080  42.602  11.965  1.00 64.97           O  
ATOM    865  CB  GLN A  91      49.391  43.759  14.594  1.00 61.60           C  
ATOM    866  CG  GLN A  91      48.563  44.781  15.398  1.00 62.72           C  
ATOM    867  CD  GLN A  91      47.922  45.865  14.555  1.00 70.15           C  
ATOM    868  OE1 GLN A  91      47.149  45.590  13.638  1.00 75.58           O  
ATOM    869  NE2 GLN A  91      48.207  47.114  14.898  1.00 72.70           N  
ATOM    870  N   THR A  92      49.747  40.613  12.981  1.00 65.05           N  
ATOM    871  CA  THR A  92      50.589  39.837  12.042  1.00 66.87           C  
ATOM    872  C   THR A  92      49.750  39.224  10.914  1.00 70.48           C  
ATOM    873  O   THR A  92      48.883  38.386  11.177  1.00 71.43           O  
ATOM    874  CB  THR A  92      51.410  38.696  12.736  1.00 67.09           C  
ATOM    875  OG1 THR A  92      50.539  37.710  13.306  1.00 66.97           O  
ATOM    876  CG2 THR A  92      52.313  39.256  13.808  1.00 64.90           C  
ATOM    877  N   HIS A  93      50.023  39.648   9.675  1.00 73.96           N  
ATOM    878  CA  HIS A  93      49.343  39.152   8.464  1.00 75.87           C  
ATOM    879  C   HIS A  93      50.201  39.278   7.202  1.00 76.20           C  
ATOM    880  O   HIS A  93      50.022  38.518   6.249  1.00 76.10           O  
ATOM    881  CB  HIS A  93      47.999  39.868   8.264  1.00 77.38           C  
ATOM    882  CG  HIS A  93      46.855  39.196   8.954  1.00 81.78           C  
ATOM    883  ND1 HIS A  93      46.343  37.993   8.517  1.00 86.50           N  
ATOM    884  CD2 HIS A  93      46.130  39.544  10.041  1.00 82.47           C  
ATOM    885  CE1 HIS A  93      45.354  37.627   9.306  1.00 85.26           C  
ATOM    886  NE2 HIS A  93      45.203  38.550  10.240  1.00 87.61           N  
ATOM    887  N   GLU A 100      47.061  29.704   8.119  1.00 54.26           N  
ATOM    888  CA  GLU A 100      47.062  28.233   8.063  1.00 54.07           C  
ATOM    889  C   GLU A 100      46.170  27.614   9.155  1.00 51.97           C  
ATOM    890  O   GLU A 100      45.758  28.310  10.089  1.00 51.77           O  
ATOM    891  CB  GLU A 100      48.496  27.694   8.179  1.00 54.77           C  
ATOM    892  CG  GLU A 100      49.217  28.052   9.478  1.00 57.77           C  
ATOM    893  N   LEU A 101      45.882  26.313   9.033  1.00 48.78           N  
ATOM    894  CA  LEU A 101      45.054  25.590  10.014  1.00 45.69           C  
ATOM    895  C   LEU A 101      45.716  25.560  11.378  1.00 44.03           C  
ATOM    896  O   LEU A 101      46.939  25.459  11.460  1.00 44.71           O  
ATOM    897  CB  LEU A 101      44.783  24.146   9.578  1.00 44.03           C  
ATOM    898  CG  LEU A 101      43.903  23.955   8.353  1.00 42.21           C  
ATOM    899  CD1 LEU A 101      43.844  22.479   8.016  1.00 39.37           C  
ATOM    900  CD2 LEU A 101      42.519  24.517   8.589  1.00 33.63           C  
ATOM    901  N   VAL A 102      44.893  25.594  12.424  1.00 42.15           N  
ATOM    902  CA  VAL A 102      45.353  25.662  13.801  1.00 42.54           C  
ATOM    903  C   VAL A 102      45.045  24.379  14.565  1.00 42.40           C  
ATOM    904  O   VAL A 102      43.894  23.958  14.648  1.00 40.07           O  
ATOM    905  CB  VAL A 102      44.689  26.846  14.543  1.00 43.77           C  
ATOM    906  CG1 VAL A 102      45.266  27.006  15.941  1.00 45.36           C  
ATOM    907  CG2 VAL A 102      44.856  28.146  13.758  1.00 42.80           C  
ATOM    908  N   SER A 103      46.090  23.764  15.113  1.00 42.73           N  
ATOM    909  CA  SER A 103      45.951  22.622  15.998  1.00 45.45           C  
ATOM    910  C   SER A 103      45.845  23.198  17.397  1.00 48.31           C  
ATOM    911  O   SER A 103      46.371  24.294  17.668  1.00 49.83           O  
ATOM    912  CB  SER A 103      47.156  21.698  15.914  1.00 43.26           C  
ATOM    913  OG  SER A 103      48.309  22.412  16.297  1.00 45.43           O  
ATOM    914  N   VAL A 104      45.181  22.461  18.279  1.00 51.35           N  
ATOM    915  CA  VAL A 104      45.047  22.847  19.691  1.00 53.15           C  
ATOM    916  C   VAL A 104      45.591  21.684  20.541  1.00 52.77           C  
ATOM    917  O   VAL A 104      45.321  20.524  20.207  1.00 51.51           O  
ATOM    918  CB  VAL A 104      43.603  23.243  20.041  1.00 51.83           C  
ATOM    919  CG1 VAL A 104      43.220  24.506  19.272  1.00 54.41           C  
ATOM    920  CG2 VAL A 104      42.610  22.116  19.758  1.00 53.43           C  
ATOM    921  N   PRO A 105      46.391  21.976  21.605  1.00 55.65           N  
ATOM    922  CA  PRO A 105      46.986  20.873  22.418  1.00 56.67           C  
ATOM    923  C   PRO A 105      45.958  19.970  23.096  1.00 58.10           C  
ATOM    924  O   PRO A 105      46.178  18.762  23.215  1.00 60.34           O  
ATOM    925  CB  PRO A 105      47.816  21.602  23.486  1.00 57.93           C  
ATOM    926  CG  PRO A 105      47.871  23.022  23.085  1.00 57.35           C  
ATOM    927  CD  PRO A 105      46.784  23.308  22.117  1.00 56.52           C  
ATOM    928  N   TRP A 106      44.861  20.583  23.539  1.00 59.41           N  
ATOM    929  CA  TRP A 106      43.752  19.865  24.177  1.00 60.34           C  
ATOM    930  C   TRP A 106      43.021  18.890  23.215  1.00 61.39           C  
ATOM    931  O   TRP A 106      42.927  17.692  23.513  1.00 63.51           O  
ATOM    932  CB  TRP A 106      42.775  20.849  24.878  1.00 59.95           C  
ATOM    933  CG  TRP A 106      42.220  22.006  24.054  1.00 57.89           C  
ATOM    934  CD1 TRP A 106      41.074  22.008  23.312  1.00 58.63           C  
ATOM    935  CD2 TRP A 106      42.776  23.338  23.935  1.00 61.40           C  
ATOM    936  NE1 TRP A 106      40.889  23.251  22.724  1.00 59.96           N  
ATOM    937  CE2 TRP A 106      41.911  24.085  23.097  1.00 58.85           C  
ATOM    938  CE3 TRP A 106      43.925  23.969  24.448  1.00 60.67           C  
ATOM    939  CZ2 TRP A 106      42.172  25.430  22.741  1.00 56.36           C  
ATOM    940  CZ3 TRP A 106      44.175  25.314  24.102  1.00 57.08           C  
ATOM    941  CH2 TRP A 106      43.295  26.025  23.260  1.00 56.79           C  
ATOM    942  N   GLU A 107      42.579  19.388  22.055  1.00 61.20           N  
ATOM    943  CA  GLU A 107      41.805  18.591  21.061  1.00 60.42           C  
ATOM    944  C   GLU A 107      42.644  17.912  19.946  1.00 59.18           C  
ATOM    945  O   GLU A 107      42.894  18.510  18.902  1.00 63.19           O  
ATOM    946  CB  GLU A 107      40.707  19.466  20.427  1.00 59.18           C  
ATOM    947  N   THR A 108      43.058  16.669  20.177  1.00 54.95           N  
ATOM    948  CA  THR A 108      43.792  15.844  19.177  1.00 51.43           C  
ATOM    949  C   THR A 108      42.838  15.444  18.006  1.00 47.13           C  
ATOM    950  O   THR A 108      41.605  15.371  18.207  1.00 44.67           O  
ATOM    951  CB  THR A 108      44.432  14.593  19.856  1.00 53.39           C  
ATOM    952  OG1 THR A 108      45.352  13.930  18.967  1.00 51.63           O  
ATOM    953  CG2 THR A 108      43.355  13.601  20.325  1.00 58.64           C  
ATOM    954  N   GLY A 109      43.379  15.243  16.794  1.00 40.24           N  
ATOM    955  CA  GLY A 109      42.551  14.880  15.611  1.00 37.78           C  
ATOM    956  C   GLY A 109      41.609  15.970  15.013  1.00 35.24           C  
ATOM    957  O   GLY A 109      40.801  15.722  14.112  1.00 35.72           O  
ATOM    958  N   VAL A 110      41.655  17.195  15.502  1.00 36.94           N  
ATOM    959  CA  VAL A 110      40.827  18.235  14.923  1.00 35.22           C  
ATOM    960  C   VAL A 110      41.691  19.473  14.694  1.00 38.09           C  
ATOM    961  O   VAL A 110      42.578  19.792  15.507  1.00 36.17           O  
ATOM    962  CB  VAL A 110      39.594  18.549  15.806  1.00 37.94           C  
ATOM    963  CG1 VAL A 110      39.998  19.128  17.153  1.00 38.44           C  
ATOM    964  CG2 VAL A 110      38.709  19.528  15.111  1.00 37.91           C  
ATOM    965  N   LEU A 111      41.448  20.152  13.578  1.00 33.63           N  
ATOM    966  CA  LEU A 111      42.145  21.392  13.264  1.00 33.76           C  
ATOM    967  C   LEU A 111      41.095  22.389  12.884  1.00 31.87           C  
ATOM    968  O   LEU A 111      40.091  22.031  12.258  1.00 31.36           O  
ATOM    969  CB  LEU A 111      43.180  21.248  12.146  1.00 33.61           C  
ATOM    970  CG  LEU A 111      44.434  20.443  12.508  1.00 35.43           C  
ATOM    971  CD1 LEU A 111      44.125  18.966  12.431  1.00 41.92           C  
ATOM    972  CD2 LEU A 111      45.581  20.786  11.576  1.00 37.15           C  
ATOM    973  N   TYR A 112      41.341  23.641  13.251  1.00 32.32           N  
ATOM    974  CA  TYR A 112      40.400  24.710  13.012  1.00 34.03           C  
ATOM    975  C   TYR A 112      41.010  25.794  12.155  1.00 34.36           C  
ATOM    976  O   TYR A 112      42.227  26.000  12.168  1.00 32.90           O  
ATOM    977  CB  TYR A 112      39.975  25.347  14.334  1.00 37.20           C  
ATOM    978  CG  TYR A 112      39.363  24.396  15.341  1.00 37.83           C  
ATOM    979  CD1 TYR A 112      38.059  23.914  15.170  1.00 41.15           C  
ATOM    980  CD2 TYR A 112      40.077  23.992  16.475  1.00 40.78           C  
ATOM    981  CE1 TYR A 112      37.481  23.037  16.094  1.00 42.04           C  
ATOM    982  CE2 TYR A 112      39.508  23.118  17.414  1.00 41.41           C  
ATOM    983  CZ  TYR A 112      38.204  22.663  17.223  1.00 31.77           C  
ATOM    984  OH  TYR A 112      37.645  21.821  18.135  1.00 45.48           O  
ATOM    985  N   THR A 113      40.155  26.525  11.440  1.00 32.62           N  
ATOM    986  CA  THR A 113      40.632  27.674  10.678  1.00 32.94           C  
ATOM    987  C   THR A 113      40.801  28.814  11.663  1.00 33.02           C  
ATOM    988  O   THR A 113      40.142  28.834  12.712  1.00 34.84           O  
ATOM    989  CB  THR A 113      39.659  28.125   9.566  1.00 30.35           C  
ATOM    990  OG1 THR A 113      38.380  28.432  10.145  1.00 30.20           O  
ATOM    991  CG2 THR A 113      39.525  27.069   8.481  1.00 30.84           C  
ATOM    992  N   ARG A 114      41.664  29.776  11.335  1.00 35.23           N  
ATOM    993  CA  ARG A 114      41.831  30.961  12.200  0.50 34.60           C  
ATOM    995  C   ARG A 114      40.474  31.626  12.319  1.00 33.28           C  
ATOM    996  O   ARG A 114      40.079  32.016  13.425  1.00 33.25           O  
ATOM    997  CB  ARG A 114      42.862  31.979  11.683  0.50 34.60           C  
ATOM    999  CG  ARG A 114      43.088  33.204  12.641  0.50 36.77           C  
ATOM   1001  CD  ARG A 114      43.920  34.342  11.999  0.50 38.42           C  
ATOM   1003  NE  ARG A 114      45.329  33.969  11.775  0.50 44.99           N  
ATOM   1005  CZ  ARG A 114      46.424  34.532  12.320  0.50 44.70           C  
ATOM   1007  NH1 ARG A 114      46.375  35.590  13.146  0.50 43.82           N  
ATOM   1009  NH2 ARG A 114      47.620  34.032  12.001  0.50 44.44           N  
ATOM   1011  N   ASP A 115      39.748  31.736  11.202  1.00 34.19           N  
ATOM   1012  CA  ASP A 115      38.409  32.362  11.193  1.00 35.14           C  
ATOM   1013  C   ASP A 115      37.447  31.711  12.198  1.00 35.37           C  
ATOM   1014  O   ASP A 115      36.748  32.404  12.947  1.00 34.57           O  
ATOM   1015  CB  ASP A 115      37.795  32.296   9.796  1.00 36.23           C  
ATOM   1016  CG  ASP A 115      36.398  32.867   9.756  1.00 38.49           C  
ATOM   1017  OD1 ASP A 115      36.245  34.078   9.989  1.00 42.69           O  
ATOM   1018  OD2 ASP A 115      35.459  32.108   9.527  1.00 40.82           O  
ATOM   1019  N   GLU A 116      37.388  30.383  12.183  1.00 34.59           N  
ATOM   1020  CA  GLU A 116      36.532  29.643  13.137  1.00 35.13           C  
ATOM   1021  C   GLU A 116      36.850  30.012  14.600  1.00 34.04           C  
ATOM   1022  O   GLU A 116      35.941  30.276  15.402  1.00 34.63           O  
ATOM   1023  CB  GLU A 116      36.692  28.142  12.963  1.00 36.54           C  
ATOM   1024  CG  GLU A 116      35.725  27.290  13.777  1.00 39.18           C  
ATOM   1025  CD  GLU A 116      34.275  27.302  13.274  1.00 47.36           C  
ATOM   1026  OE1 GLU A 116      33.920  28.012  12.291  1.00 40.41           O  
ATOM   1027  OE2 GLU A 116      33.488  26.520  13.857  1.00 47.21           O  
ATOM   1028  N   ILE A 117      38.144  30.062  14.911  1.00 34.90           N  
ATOM   1029  CA  ILE A 117      38.630  30.402  16.243  1.00 35.14           C  
ATOM   1030  C   ILE A 117      38.269  31.832  16.619  1.00 35.50           C  
ATOM   1031  O   ILE A 117      37.792  32.059  17.722  1.00 36.09           O  
ATOM   1032  CB  ILE A 117      40.156  30.157  16.364  1.00 34.85           C  
ATOM   1033  CG1 ILE A 117      40.468  28.660  16.279  1.00 37.23           C  
ATOM   1034  CG2 ILE A 117      40.718  30.729  17.686  1.00 34.54           C  
ATOM   1035  CD1 ILE A 117      41.956  28.346  16.269  1.00 35.13           C  
ATOM   1036  N   LEU A 118      38.467  32.790  15.698  1.00 36.33           N  
ATOM   1037  CA  LEU A 118      38.105  34.198  15.978  1.00 36.09           C  
ATOM   1038  C   LEU A 118      36.621  34.343  16.306  1.00 35.27           C  
ATOM   1039  O   LEU A 118      36.273  35.019  17.277  1.00 36.66           O  
ATOM   1040  CB  LEU A 118      38.484  35.130  14.826  1.00 37.70           C  
ATOM   1041  CG  LEU A 118      39.974  35.244  14.497  1.00 35.83           C  
ATOM   1042  CD1 LEU A 118      40.202  36.388  13.501  1.00 35.50           C  
ATOM   1043  CD2 LEU A 118      40.815  35.458  15.737  1.00 32.88           C  
ATOM   1044  N   HIS A 119      35.769  33.681  15.528  1.00 32.84           N  
ATOM   1045  CA  HIS A 119      34.320  33.632  15.807  1.00 33.45           C  
ATOM   1046  C   HIS A 119      34.012  33.104  17.233  1.00 36.01           C  
ATOM   1047  O   HIS A 119      33.212  33.684  17.957  1.00 36.25           O  
ATOM   1048  CB  HIS A 119      33.588  32.771  14.781  1.00 33.24           C  
ATOM   1049  CG  HIS A 119      33.259  33.502  13.510  1.00 32.95           C  
ATOM   1050  ND1 HIS A 119      34.157  33.668  12.481  1.00 37.35           N  
ATOM   1051  CD2 HIS A 119      32.117  34.103  13.112  1.00 37.10           C  
ATOM   1052  CE1 HIS A 119      33.576  34.344  11.504  1.00 34.55           C  
ATOM   1053  NE2 HIS A 119      32.341  34.627  11.870  1.00 34.04           N  
ATOM   1054  N   HIS A 120      34.677  32.007  17.589  1.00 35.89           N  
ATOM   1055  CA  HIS A 120      34.525  31.321  18.885  1.00 36.32           C  
ATOM   1056  C   HIS A 120      34.923  32.204  20.062  1.00 35.44           C  
ATOM   1057  O   HIS A 120      34.162  32.299  21.030  1.00 36.72           O  
ATOM   1058  CB  HIS A 120      35.322  30.011  18.853  1.00 35.66           C  
ATOM   1059  CG  HIS A 120      35.200  29.178  20.094  1.00 39.38           C  
ATOM   1060  ND1 HIS A 120      34.145  28.320  20.317  1.00 40.83           N  
ATOM   1061  CD2 HIS A 120      35.994  29.090  21.185  1.00 38.12           C  
ATOM   1062  CE1 HIS A 120      34.310  27.716  21.481  1.00 45.25           C  
ATOM   1063  NE2 HIS A 120      35.429  28.164  22.028  1.00 40.93           N  
ATOM   1064  N   ILE A 121      36.089  32.840  19.970  1.00 34.60           N  
ATOM   1065  CA  ILE A 121      36.578  33.810  20.981  1.00 37.09           C  
ATOM   1066  C   ILE A 121      35.609  34.967  21.194  1.00 35.70           C  
ATOM   1067  O   ILE A 121      35.281  35.339  22.328  1.00 36.65           O  
ATOM   1068  CB  ILE A 121      37.974  34.432  20.539  1.00 35.50           C  
ATOM   1069  CG1 ILE A 121      39.109  33.430  20.607  1.00 48.04           C  
ATOM   1070  CG2 ILE A 121      38.391  35.650  21.391  1.00 44.60           C  
ATOM   1071  CD1 ILE A 121      40.412  34.032  20.073  1.00 42.59           C  
ATOM   1072  N   ILE A 122      35.188  35.561  20.084  1.00 36.72           N  
ATOM   1073  CA  ILE A 122      34.308  36.721  20.103  1.00 35.97           C  
ATOM   1074  C   ILE A 122      32.976  36.401  20.798  1.00 36.83           C  
ATOM   1075  O   ILE A 122      32.568  37.113  21.711  1.00 36.22           O  
ATOM   1076  CB  ILE A 122      34.070  37.242  18.667  1.00 34.95           C  
ATOM   1077  CG1 ILE A 122      35.336  37.947  18.147  1.00 35.00           C  
ATOM   1078  CG2 ILE A 122      32.856  38.203  18.636  1.00 33.95           C  
ATOM   1079  CD1 ILE A 122      35.347  38.165  16.645  1.00 33.80           C  
ATOM   1080  N   ALA A 123      32.334  35.315  20.372  1.00 35.88           N  
ATOM   1081  CA  ALA A 123      31.059  34.910  20.942  1.00 36.45           C  
ATOM   1082  C   ALA A 123      31.208  34.504  22.427  1.00 36.69           C  
ATOM   1083  O   ALA A 123      30.346  34.808  23.251  1.00 37.13           O  
ATOM   1084  CB  ALA A 123      30.440  33.773  20.109  1.00 36.76           C  
ATOM   1085  N   HIS A 124      32.318  33.850  22.754  1.00 35.79           N  
ATOM   1086  CA  HIS A 124      32.598  33.405  24.123  1.00 35.69           C  
ATOM   1087  C   HIS A 124      32.607  34.551  25.131  1.00 36.68           C  
ATOM   1088  O   HIS A 124      32.007  34.419  26.194  1.00 37.13           O  
ATOM   1089  CB  HIS A 124      33.928  32.686  24.198  1.00 35.14           C  
ATOM   1090  CG  HIS A 124      34.202  32.092  25.531  1.00 34.54           C  
ATOM   1091  ND1 HIS A 124      35.098  32.638  26.421  1.00 35.84           N  
ATOM   1092  CD2 HIS A 124      33.692  30.991  26.127  1.00 40.27           C  
ATOM   1093  CE1 HIS A 124      35.149  31.881  27.501  1.00 37.55           C  
ATOM   1094  NE2 HIS A 124      34.313  30.869  27.344  1.00 37.02           N  
ATOM   1095  N   GLU A 125      33.265  35.657  24.793  1.00 35.88           N  
ATOM   1096  CA  GLU A 125      33.298  36.802  25.706  1.00 37.16           C  
ATOM   1097  C   GLU A 125      31.926  37.453  25.848  1.00 36.80           C  
ATOM   1098  O   GLU A 125      31.461  37.655  26.964  1.00 36.94           O  
ATOM   1099  CB  GLU A 125      34.357  37.845  25.310  1.00 37.15           C  
ATOM   1100  CG  GLU A 125      34.376  39.026  26.296  1.00 33.78           C  
ATOM   1101  CD  GLU A 125      35.688  39.750  26.429  1.00 41.35           C  
ATOM   1102  OE1 GLU A 125      36.639  39.505  25.635  1.00 37.11           O  
ATOM   1103  OE2 GLU A 125      35.756  40.588  27.371  1.00 36.54           O  
ATOM   1104  N   ILE A 126      31.271  37.744  24.723  1.00 35.99           N  
ATOM   1105  CA  ILE A 126      29.955  38.422  24.741  1.00 36.34           C  
ATOM   1106  C   ILE A 126      28.968  37.587  25.565  1.00 37.39           C  
ATOM   1107  O   ILE A 126      28.198  38.119  26.365  1.00 35.04           O  
ATOM   1108  CB  ILE A 126      29.409  38.711  23.317  1.00 35.13           C  
ATOM   1109  CG1 ILE A 126      30.365  39.598  22.498  1.00 37.28           C  
ATOM   1110  CG2 ILE A 126      28.057  39.418  23.393  1.00 34.37           C  
ATOM   1111  CD1 ILE A 126      29.928  39.813  21.038  1.00 35.36           C  
ATOM   1112  N   HIS A 127      29.018  36.261  25.385  1.00 33.81           N  
ATOM   1113  CA  HIS A 127      28.188  35.332  26.164  1.00 34.65           C  
ATOM   1114  C   HIS A 127      28.347  35.472  27.692  1.00 33.69           C  
ATOM   1115  O   HIS A 127      27.373  35.641  28.417  1.00 35.95           O  
ATOM   1116  CB  HIS A 127      28.522  33.889  25.723  1.00 35.66           C  
ATOM   1117  CG  HIS A 127      27.991  32.829  26.625  1.00 38.26           C  
ATOM   1118  ND1 HIS A 127      26.654  32.497  26.687  1.00 36.86           N  
ATOM   1119  CD2 HIS A 127      28.637  31.977  27.457  1.00 37.52           C  
ATOM   1120  CE1 HIS A 127      26.506  31.493  27.541  1.00 37.79           C  
ATOM   1121  NE2 HIS A 127      27.692  31.175  28.026  1.00 35.53           N  
ATOM   1122  N   HIS A 128      29.576  35.374  28.178  1.00 34.60           N  
ATOM   1123  CA  HIS A 128      29.845  35.501  29.623  1.00 33.37           C  
ATOM   1124  C   HIS A 128      29.561  36.890  30.182  1.00 34.92           C  
ATOM   1125  O   HIS A 128      29.091  37.028  31.320  1.00 34.43           O  
ATOM   1126  CB  HIS A 128      31.279  35.093  29.949  1.00 34.95           C  
ATOM   1127  CG  HIS A 128      31.473  33.622  29.936  1.00 33.35           C  
ATOM   1128  ND1 HIS A 128      30.750  32.797  30.764  1.00 34.56           N  
ATOM   1129  CD2 HIS A 128      32.266  32.818  29.192  1.00 40.40           C  
ATOM   1130  CE1 HIS A 128      31.109  31.543  30.547  1.00 41.03           C  
ATOM   1131  NE2 HIS A 128      32.025  31.532  29.597  1.00 38.41           N  
ATOM   1132  N   ILE A 129      29.848  37.903  29.381  1.00 33.89           N  
ATOM   1133  CA  ILE A 129      29.552  39.279  29.760  1.00 33.58           C  
ATOM   1134  C   ILE A 129      28.019  39.456  29.951  1.00 37.00           C  
ATOM   1135  O   ILE A 129      27.579  40.197  30.858  1.00 33.41           O  
ATOM   1136  CB  ILE A 129      30.175  40.265  28.744  1.00 36.51           C  
ATOM   1137  CG1 ILE A 129      31.718  40.252  28.850  1.00 35.61           C  
ATOM   1138  CG2 ILE A 129      29.643  41.679  28.941  1.00 34.09           C  
ATOM   1139  CD1 ILE A 129      32.305  40.739  30.171  1.00 38.72           C  
ATOM   1140  N   GLY A 130      27.219  38.793  29.096  1.00 35.69           N  
ATOM   1141  CA  GLY A 130      25.772  38.769  29.240  1.00 35.72           C  
ATOM   1142  C   GLY A 130      25.330  38.218  30.591  1.00 33.69           C  
ATOM   1143  O   GLY A 130      24.376  38.736  31.217  1.00 38.83           O  
ATOM   1144  N   GLN A 131      26.033  37.197  31.062  1.00 36.84           N  
ATOM   1145  CA  GLN A 131      25.783  36.608  32.388  1.00 35.90           C  
ATOM   1146  C   GLN A 131      26.029  37.633  33.504  1.00 36.13           C  
ATOM   1147  O   GLN A 131      25.220  37.747  34.414  1.00 34.63           O  
ATOM   1148  CB  GLN A 131      26.634  35.355  32.611  1.00 36.83           C  
ATOM   1149  CG  GLN A 131      26.325  34.199  31.642  1.00 35.43           C  
ATOM   1150  CD  GLN A 131      27.294  33.047  31.737  1.00 37.52           C  
ATOM   1151  OE1 GLN A 131      28.445  33.202  32.152  1.00 41.63           O  
ATOM   1152  NE2 GLN A 131      26.838  31.876  31.325  1.00 33.06           N  
ATOM   1153  N   LEU A 132      27.095  38.436  33.378  1.00 37.86           N  
ATOM   1154  CA  LEU A 132      27.406  39.465  34.391  1.00 35.85           C  
ATOM   1155  C   LEU A 132      26.307  40.481  34.554  1.00 35.07           C  
ATOM   1156  O   LEU A 132      26.045  40.909  35.669  1.00 35.40           O  
ATOM   1157  CB  LEU A 132      28.709  40.214  34.097  1.00 37.16           C  
ATOM   1158  CG  LEU A 132      30.015  39.443  34.069  1.00 38.19           C  
ATOM   1159  CD1 LEU A 132      31.141  40.395  33.754  1.00 35.26           C  
ATOM   1160  CD2 LEU A 132      30.238  38.741  35.386  1.00 42.24           C  
ATOM   1161  N   SER A 133      25.645  40.844  33.456  1.00 36.99           N  
ATOM   1162  CA  SER A 133      24.549  41.822  33.520  1.00 36.74           C  
ATOM   1163  C   SER A 133      23.363  41.352  34.355  1.00 36.21           C  
ATOM   1164  O   SER A 133      22.665  42.181  34.924  1.00 37.26           O  
ATOM   1165  CB  SER A 133      24.084  42.253  32.117  1.00 39.04           C  
ATOM   1166  OG  SER A 133      23.451  41.192  31.416  1.00 37.09           O  
ATOM   1167  N   VAL A 134      23.123  40.038  34.425  1.00 35.81           N  
ATOM   1168  CA  VAL A 134      22.045  39.503  35.266  1.00 35.40           C  
ATOM   1169  C   VAL A 134      22.448  39.678  36.730  1.00 35.70           C  
ATOM   1170  O   VAL A 134      21.676  40.215  37.525  1.00 34.80           O  
ATOM   1171  CB  VAL A 134      21.690  38.038  34.926  1.00 35.83           C  
ATOM   1172  CG1 VAL A 134      20.687  37.435  35.952  1.00 33.17           C  
ATOM   1173  CG2 VAL A 134      21.113  37.975  33.513  1.00 32.82           C  
ATOM   1174  N   TRP A 135      23.671  39.262  37.064  1.00 35.42           N  
ATOM   1175  CA  TRP A 135      24.190  39.405  38.435  1.00 33.84           C  
ATOM   1176  C   TRP A 135      24.215  40.861  38.906  1.00 34.72           C  
ATOM   1177  O   TRP A 135      23.875  41.150  40.049  1.00 35.36           O  
ATOM   1178  CB  TRP A 135      25.576  38.747  38.570  1.00 34.42           C  
ATOM   1179  CG  TRP A 135      25.553  37.265  38.315  1.00 35.30           C  
ATOM   1180  CD1 TRP A 135      24.502  36.416  38.520  1.00 39.16           C  
ATOM   1181  CD2 TRP A 135      26.644  36.443  37.883  1.00 38.30           C  
ATOM   1182  NE1 TRP A 135      24.851  35.138  38.197  1.00 33.61           N  
ATOM   1183  CE2 TRP A 135      26.157  35.112  37.809  1.00 34.34           C  
ATOM   1184  CE3 TRP A 135      27.977  36.700  37.525  1.00 38.75           C  
ATOM   1185  CZ2 TRP A 135      26.959  34.029  37.405  1.00 36.94           C  
ATOM   1186  CZ3 TRP A 135      28.779  35.634  37.126  1.00 42.97           C  
ATOM   1187  CH2 TRP A 135      28.264  34.302  37.071  1.00 41.66           C  
ATOM   1188  N   ALA A 136      24.580  41.768  38.009  1.00 32.44           N  
ATOM   1189  CA  ALA A 136      24.584  43.211  38.283  1.00 34.25           C  
ATOM   1190  C   ALA A 136      23.211  43.656  38.798  1.00 34.36           C  
ATOM   1191  O   ALA A 136      23.124  44.280  39.853  1.00 34.70           O  
ATOM   1192  CB  ALA A 136      24.967  43.986  37.026  1.00 30.67           C  
ATOM   1193  N   ARG A 137      22.152  43.273  38.081  1.00 35.58           N  
ATOM   1194  CA  ARG A 137      20.767  43.618  38.472  1.00 38.30           C  
ATOM   1195  C   ARG A 137      20.334  42.911  39.755  1.00 38.72           C  
ATOM   1196  O   ARG A 137      19.585  43.501  40.548  1.00 39.47           O  
ATOM   1197  CB  ARG A 137      19.756  43.340  37.348  1.00 40.51           C  
ATOM   1198  CG  ARG A 137      19.889  44.225  36.113  1.00 44.57           C  
ATOM   1199  CD  ARG A 137      19.679  45.706  36.415  1.00 53.46           C  
ATOM   1200  NE  ARG A 137      19.451  46.476  35.188  1.00 60.23           N  
ATOM   1201  CZ  ARG A 137      19.426  47.813  35.098  1.00 63.93           C  
ATOM   1202  NH1 ARG A 137      19.656  48.599  36.155  1.00 62.91           N  
ATOM   1203  NH2 ARG A 137      19.200  48.380  33.908  1.00 67.15           N  
ATOM   1204  N   GLU A 138      20.806  41.677  39.961  1.00 37.26           N  
ATOM   1205  CA  GLU A 138      20.580  40.947  41.227  1.00 37.60           C  
ATOM   1206  C   GLU A 138      21.264  41.620  42.426  1.00 36.22           C  
ATOM   1207  O   GLU A 138      20.779  41.524  43.547  1.00 35.00           O  
ATOM   1208  CB  GLU A 138      21.001  39.485  41.100  1.00 37.67           C  
ATOM   1209  CG  GLU A 138      20.053  38.734  40.174  1.00 39.09           C  
ATOM   1210  CD  GLU A 138      20.413  37.290  39.929  1.00 37.78           C  
ATOM   1211  OE1 GLU A 138      21.512  36.842  40.295  1.00 38.88           O  
ATOM   1212  OE2 GLU A 138      19.563  36.601  39.342  1.00 36.52           O  
ATOM   1213  N   LEU A 139      22.369  42.313  42.172  1.00 35.22           N  
ATOM   1214  CA  LEU A 139      23.054  43.125  43.184  1.00 36.34           C  
ATOM   1215  C   LEU A 139      22.444  44.549  43.343  1.00 37.54           C  
ATOM   1216  O   LEU A 139      22.953  45.334  44.158  1.00 36.59           O  
ATOM   1217  CB  LEU A 139      24.556  43.220  42.844  1.00 36.85           C  
ATOM   1218  CG  LEU A 139      25.437  41.995  43.113  1.00 35.21           C  
ATOM   1219  CD1 LEU A 139      26.766  42.147  42.412  1.00 38.43           C  
ATOM   1220  CD2 LEU A 139      25.641  41.788  44.615  1.00 35.55           C  
ATOM   1221  N   LYS A 140      21.374  44.861  42.590  1.00 36.58           N  
ATOM   1222  CA  LYS A 140      20.704  46.182  42.564  1.00 37.82           C  
ATOM   1223  C   LYS A 140      21.647  47.284  42.044  1.00 37.96           C  
ATOM   1224  O   LYS A 140      21.639  48.424  42.514  1.00 39.53           O  
ATOM   1225  CB  LYS A 140      20.069  46.535  43.925  1.00 38.50           C  
ATOM   1226  CG  LYS A 140      19.019  45.533  44.389  1.00 39.59           C  
ATOM   1227  N   LEU A 141      22.447  46.910  41.041  1.00 38.98           N  
ATOM   1228  CA  LEU A 141      23.388  47.805  40.372  1.00 38.10           C  
ATOM   1229  C   LEU A 141      23.058  47.859  38.890  1.00 38.55           C  
ATOM   1230  O   LEU A 141      22.468  46.928  38.347  1.00 40.83           O  
ATOM   1231  CB  LEU A 141      24.817  47.308  40.584  1.00 38.47           C  
ATOM   1232  CG  LEU A 141      25.266  47.244  42.046  1.00 35.71           C  
ATOM   1233  CD1 LEU A 141      26.619  46.532  42.172  1.00 36.10           C  
ATOM   1234  CD2 LEU A 141      25.290  48.667  42.660  1.00 33.38           C  
ATOM   1235  N   SER A 142      23.429  48.960  38.236  1.00 36.93           N  
ATOM   1236  CA  SER A 142      23.245  49.093  36.799  1.00 39.12           C  
ATOM   1237  C   SER A 142      24.411  48.371  36.130  1.00 37.84           C  
ATOM   1238  O   SER A 142      25.546  48.622  36.496  1.00 36.52           O  
ATOM   1239  CB  SER A 142      23.264  50.555  36.366  1.00 38.39           C  
ATOM   1240  OG  SER A 142      22.300  51.269  37.095  1.00 43.20           O  
ATOM   1241  N   PRO A 143      24.144  47.472  35.167  1.00 39.05           N  
ATOM   1242  CA  PRO A 143      25.260  46.886  34.451  1.00 39.65           C  
ATOM   1243  C   PRO A 143      25.909  47.890  33.492  1.00 38.63           C  
ATOM   1244  O   PRO A 143      25.364  48.956  33.213  1.00 39.34           O  
ATOM   1245  CB  PRO A 143      24.598  45.774  33.631  1.00 40.55           C  
ATOM   1246  CG  PRO A 143      23.257  46.270  33.387  1.00 44.52           C  
ATOM   1247  CD  PRO A 143      22.860  46.959  34.656  1.00 41.85           C  
ATOM   1248  N   VAL A 144      27.079  47.522  33.020  1.00 38.93           N  
ATOM   1249  CA  VAL A 144      27.812  48.253  32.001  1.00 39.12           C  
ATOM   1250  C   VAL A 144      27.094  48.041  30.660  1.00 38.51           C  
ATOM   1251  O   VAL A 144      26.608  46.948  30.380  1.00 38.92           O  
ATOM   1252  CB  VAL A 144      29.281  47.743  31.973  1.00 39.00           C  
ATOM   1253  CG1 VAL A 144      30.016  48.113  30.718  1.00 42.51           C  
ATOM   1254  CG2 VAL A 144      30.002  48.236  33.274  1.00 43.50           C  
ATOM   1255  N   SER A 145      27.041  49.079  29.838  1.00 38.34           N  
ATOM   1256  CA  SER A 145      26.406  48.985  28.519  1.00 38.30           C  
ATOM   1257  C   SER A 145      27.054  47.911  27.661  1.00 38.38           C  
ATOM   1258  O   SER A 145      28.277  47.730  27.697  1.00 38.54           O  
ATOM   1259  CB  SER A 145      26.483  50.308  27.765  1.00 39.29           C  
ATOM   1260  OG  SER A 145      25.904  50.183  26.474  1.00 37.08           O  
ATOM   1261  N   ALA A 146      26.217  47.176  26.942  1.00 38.18           N  
ATOM   1262  CA  ALA A 146      26.641  46.190  25.949  1.00 37.25           C  
ATOM   1263  C   ALA A 146      26.443  46.716  24.515  1.00 37.80           C  
ATOM   1264  O   ALA A 146      26.639  45.965  23.567  1.00 36.95           O  
ATOM   1265  CB  ALA A 146      25.852  44.884  26.115  1.00 39.86           C  
ATOM   1266  N   SER A 147      26.045  47.977  24.344  1.00 36.89           N  
ATOM   1267  CA  SER A 147      25.746  48.501  23.013  1.00 37.20           C  
ATOM   1268  C   SER A 147      27.009  48.577  22.175  1.00 39.23           C  
ATOM   1269  O   SER A 147      28.029  49.054  22.654  1.00 36.81           O  
ATOM   1270  CB  SER A 147      25.099  49.891  23.071  1.00 37.87           C  
ATOM   1271  OG  SER A 147      24.712  50.324  21.775  1.00 35.15           O  
ATOM   1272  N   PHE A 148      26.934  48.074  20.947  1.00 39.48           N  
ATOM   1273  CA  PHE A 148      28.023  48.250  19.964  1.00 39.29           C  
ATOM   1274  C   PHE A 148      27.855  49.628  19.363  1.00 39.25           C  
ATOM   1275  O   PHE A 148      28.811  50.410  19.288  1.00 43.24           O  
ATOM   1276  CB  PHE A 148      28.003  47.158  18.884  1.00 40.19           C  
ATOM   1277  CG  PHE A 148      29.151  47.263  17.904  1.00 34.54           C  
ATOM   1278  CD1 PHE A 148      29.057  48.122  16.818  1.00 36.81           C  
ATOM   1279  CD2 PHE A 148      30.326  46.551  18.092  1.00 42.13           C  
ATOM   1280  CE1 PHE A 148      30.093  48.267  15.919  1.00 38.60           C  
ATOM   1281  CE2 PHE A 148      31.382  46.693  17.187  1.00 34.17           C  
ATOM   1282  CZ  PHE A 148      31.255  47.543  16.103  1.00 33.71           C  
ATOM   1283  N   ILE A 149      26.632  49.909  18.898  1.00 37.85           N  
ATOM   1284  CA  ILE A 149      26.238  51.181  18.357  1.00 39.85           C  
ATOM   1285  C   ILE A 149      26.425  52.318  19.364  1.00 39.36           C  
ATOM   1286  O   ILE A 149      26.184  52.132  20.549  1.00 38.07           O  
ATOM   1287  CB  ILE A 149      24.713  51.163  17.881  1.00 38.68           C  
ATOM   1288  CG1 ILE A 149      24.599  50.585  16.472  1.00 44.50           C  
ATOM   1289  CG2 ILE A 149      24.110  52.531  17.846  1.00 51.31           C  
ATOM   1290  CD1 ILE A 149      25.290  51.362  15.418  1.00 53.58           C  
ATOM   1291  N   GLY A 150      26.862  53.474  18.869  1.00 37.34           N  
ATOM   1292  CA  GLY A 150      27.052  54.663  19.675  1.00 39.97           C  
ATOM   1293  C   GLY A 150      28.312  54.698  20.514  1.00 39.10           C  
ATOM   1294  O   GLY A 150      28.451  55.593  21.336  1.00 38.19           O  
ATOM   1295  N   ARG A 151      29.242  53.776  20.252  1.00 38.98           N  
ATOM   1296  CA  ARG A 151      30.493  53.629  20.984  1.00 40.18           C  
ATOM   1297  C   ARG A 151      31.675  53.914  20.060  1.00 41.36           C  
ATOM   1298  O   ARG A 151      31.761  53.336  18.966  1.00 40.05           O  
ATOM   1299  CB  ARG A 151      30.612  52.202  21.514  1.00 39.51           C  
ATOM   1300  CG  ARG A 151      31.836  51.902  22.396  1.00 36.91           C  
ATOM   1301  CD  ARG A 151      31.946  50.430  22.706  1.00 39.75           C  
ATOM   1302  NE  ARG A 151      30.742  49.958  23.386  1.00 35.70           N  
ATOM   1303  CZ  ARG A 151      30.538  49.936  24.705  1.00 38.31           C  
ATOM   1304  NH1 ARG A 151      31.503  50.266  25.566  1.00 38.75           N  
ATOM   1305  NH2 ARG A 151      29.365  49.494  25.167  1.00 37.05           N  
ATOM   1306  N   THR A 152      32.583  54.777  20.509  1.00 37.12           N  
ATOM   1307  CA  THR A 152      33.797  55.065  19.778  1.00 37.18           C  
ATOM   1308  C   THR A 152      34.750  53.916  20.030  1.00 37.58           C  
ATOM   1309  O   THR A 152      35.077  53.631  21.169  1.00 36.93           O  
ATOM   1310  CB  THR A 152      34.467  56.356  20.226  1.00 39.15           C  
ATOM   1311  OG1 THR A 152      33.594  57.440  19.907  1.00 38.90           O  
ATOM   1312  CG2 THR A 152      35.792  56.563  19.499  1.00 40.31           C  
ATOM   1313  N   LEU A 153      35.180  53.269  18.957  1.00 35.20           N  
ATOM   1314  CA  LEU A 153      36.103  52.136  19.043  1.00 34.64           C  
ATOM   1315  C   LEU A 153      37.545  52.586  18.870  1.00 38.15           C  
ATOM   1316  O   LEU A 153      37.860  53.339  17.927  1.00 41.51           O  
ATOM   1317  CB  LEU A 153      35.741  51.101  17.982  1.00 34.32           C  
ATOM   1318  CG  LEU A 153      34.355  50.450  18.188  1.00 35.93           C  
ATOM   1319  CD1 LEU A 153      34.143  49.401  17.125  1.00 39.12           C  
ATOM   1320  CD2 LEU A 153      34.151  49.834  19.547  1.00 35.13           C  
ATOM   1321  N   LYS A 154      38.399  52.178  19.801  1.00 36.89           N  
ATOM   1322  CA  LYS A 154      39.827  52.468  19.759  1.00 41.78           C  
ATOM   1323  C   LYS A 154      40.440  51.408  18.856  1.00 42.04           C  
ATOM   1324  O   LYS A 154      40.303  50.230  19.160  1.00 39.87           O  
ATOM   1325  CB  LYS A 154      40.412  52.384  21.170  1.00 43.85           C  
ATOM   1326  CG  LYS A 154      41.917  52.677  21.325  1.00 47.43           C  
ATOM   1327  CD  LYS A 154      42.244  52.608  22.818  1.00 49.46           C  
ATOM   1328  CE  LYS A 154      43.709  52.583  23.112  1.00 56.21           C  
ATOM   1329  NZ  LYS A 154      43.901  52.256  24.562  1.00 63.33           N  
ATOM   1330  N   PRO A 155      41.100  51.802  17.738  1.00 44.50           N  
ATOM   1331  CA  PRO A 155      41.687  50.757  16.876  1.00 43.59           C  
ATOM   1332  C   PRO A 155      42.782  49.917  17.554  1.00 44.05           C  
ATOM   1333  O   PRO A 155      43.492  50.423  18.423  1.00 44.02           O  
ATOM   1334  CB  PRO A 155      42.271  51.545  15.689  1.00 45.42           C  
ATOM   1335  CG  PRO A 155      41.678  52.879  15.754  1.00 45.54           C  
ATOM   1336  CD  PRO A 155      41.326  53.146  17.180  1.00 43.15           C  
ATOM   1337  N   ILE A 156      42.912  48.657  17.131  1.00 44.03           N  
ATOM   1338  CA  ILE A 156      43.931  47.732  17.650  1.00 46.23           C  
ATOM   1339  C   ILE A 156      45.323  48.398  17.578  1.00 47.31           C  
ATOM   1340  O   ILE A 156      46.058  48.341  18.564  1.00 47.53           O  
ATOM   1341  CB  ILE A 156      43.926  46.353  16.897  1.00 46.57           C  
ATOM   1342  CG1 ILE A 156      42.579  45.617  17.028  1.00 46.67           C  
ATOM   1343  CG2 ILE A 156      45.035  45.436  17.394  1.00 42.70           C  
ATOM   1344  CD1 ILE A 156      42.133  45.334  18.435  1.00 47.37           C  
ATOM   1345  N   HIS A 157      45.625  49.101  16.473  1.00 50.78           N  
ATOM   1346  CA  HIS A 157      46.930  49.818  16.314  1.00 52.27           C  
ATOM   1347  C   HIS A 157      47.166  50.960  17.337  1.00 53.49           C  
ATOM   1348  O   HIS A 157      48.327  51.271  17.643  1.00 54.44           O  
ATOM   1349  CB  HIS A 157      47.168  50.315  14.860  1.00 53.82           C  
ATOM   1350  CG  HIS A 157      46.264  51.430  14.415  1.00 58.63           C  
ATOM   1351  ND1 HIS A 157      46.374  52.720  14.898  1.00 64.32           N  
ATOM   1352  CD2 HIS A 157      45.284  51.467  13.479  1.00 61.30           C  
ATOM   1353  CE1 HIS A 157      45.469  53.488  14.316  1.00 63.37           C  
ATOM   1354  NE2 HIS A 157      44.799  52.754  13.445  1.00 65.65           N  
ATOM   1355  N   SER A 158      46.085  51.550  17.863  1.00 52.80           N  
ATOM   1356  CA  SER A 158      46.162  52.626  18.883  1.00 52.77           C  
ATOM   1357  C   SER A 158      46.473  52.163  20.322  1.00 51.75           C  
ATOM   1358  O   SER A 158      46.648  53.007  21.203  1.00 54.61           O  
ATOM   1359  CB  SER A 158      44.894  53.489  18.851  1.00 53.25           C  
ATOM   1360  OG  SER A 158      44.789  54.120  17.582  1.00 58.47           O  
ATOM   1361  N   TYR A 159      46.518  50.850  20.569  1.00 48.31           N  
ATOM   1362  CA  TYR A 159      46.975  50.300  21.870  1.00 47.10           C  
ATOM   1363  C   TYR A 159      48.518  50.327  21.928  1.00 47.49           C  
ATOM   1364  O   TYR A 159      49.143  49.879  22.897  1.00 44.98           O  
ATOM   1365  CB  TYR A 159      46.477  48.872  22.090  1.00 47.48           C  
ATOM   1366  CG  TYR A 159      44.997  48.794  22.392  1.00 44.50           C  
ATOM   1367  CD1 TYR A 159      44.053  48.851  21.365  1.00 42.22           C  
ATOM   1368  CD2 TYR A 159      44.541  48.678  23.709  1.00 45.21           C  
ATOM   1369  CE1 TYR A 159      42.675  48.777  21.645  1.00 43.72           C  
ATOM   1370  CE2 TYR A 159      43.168  48.604  23.999  1.00 46.85           C  
ATOM   1371  CZ  TYR A 159      42.252  48.671  22.961  1.00 43.25           C  
ATOM   1372  OH  TYR A 159      40.921  48.593  23.238  1.00 44.78           O  
ATOM   1373  OXT TYR A 159      49.174  50.804  20.993  1.00 44.35           O  
TER    1374      TYR A 159                                                      
END
MOLECULE T0481.pdb
ATOM   1157  N   ASN     5      43.757  48.627  12.993  1.00 48.55           N  
ATOM   1158  CA  ASN     5      43.707  47.221  13.486  1.00 48.66           C  
ATOM   1159  C   ASN     5      42.297  46.854  13.970  1.00 46.10           C  
ATOM   1160  O   ASN     5      41.931  47.131  15.124  1.00 45.32           O  
ATOM   1161  CB  ASN     5      44.739  47.032  14.610  1.00 49.92           C  
ATOM   1162  CG  ASN     5      45.105  45.561  14.854  1.00 51.98           C  
ATOM   1163  OD1 ASN     5      44.378  44.628  14.479  1.00 41.03           O  
ATOM   1164  ND2 ASN     5      46.252  45.360  15.496  1.00 51.86           N  
ATOM   1165  N   GLN     6      41.522  46.221  13.081  1.00 42.89           N  
ATOM   1166  CA  GLN     6      40.122  45.866  13.363  1.00 39.86           C  
ATOM   1167  C   GLN     6      39.972  44.674  14.322  1.00 37.64           C  
ATOM   1168  O   GLN     6      38.948  44.545  14.985  1.00 37.24           O  
ATOM   1169  CB  GLN     6      39.363  45.603  12.059  1.00 39.17           C  
ATOM   1170  N   ILE     7      40.983  43.809  14.403  1.00 34.88           N  
ATOM   1171  CA  ILE     7      40.937  42.694  15.353  1.00 34.40           C  
ATOM   1172  C   ILE     7      41.043  43.194  16.799  1.00 31.45           C  
ATOM   1173  O   ILE     7      40.216  42.843  17.643  1.00 29.10           O  
ATOM   1174  CB  ILE     7      42.038  41.634  15.082  1.00 34.24           C  
ATOM   1175  CG1 ILE     7      41.687  40.792  13.849  1.00 35.88           C  
ATOM   1176  CG2 ILE     7      42.186  40.712  16.271  1.00 34.37           C  
ATOM   1177  CD1 ILE     7      42.783  39.803  13.446  1.00 36.32           C  
ATOM   1178  N   VAL     8      42.071  44.003  17.067  1.00 31.23           N  
ATOM   1179  CA  VAL     8      42.289  44.610  18.384  1.00 29.82           C  
ATOM   1180  C   VAL     8      41.107  45.490  18.755  1.00 29.64           C  
ATOM   1181  O   VAL     8      40.544  45.353  19.832  1.00 30.66           O  
ATOM   1182  CB  VAL     8      43.589  45.453  18.418  1.00 29.55           C  
ATOM   1183  CG1 VAL     8      43.562  46.438  19.575  1.00 30.78           C  
ATOM   1184  CG2 VAL     8      44.817  44.553  18.513  1.00 26.78           C  
ATOM   1185  N   SER     9      40.726  46.377  17.846  1.00 30.09           N  
ATOM   1186  CA  SER     9      39.600  47.287  18.059  1.00 30.85           C  
ATOM   1187  C   SER     9      38.300  46.564  18.423  1.00 29.88           C  
ATOM   1188  O   SER     9      37.633  46.922  19.394  1.00 30.15           O  
ATOM   1189  CB  SER     9      39.382  48.137  16.796  1.00 31.43           C  
ATOM   1190  OG  SER     9      38.309  49.037  16.971  1.00 34.73           O  
ATOM   1191  N   HIS    10      37.946  45.552  17.640  1.00 29.62           N  
ATOM   1192  CA  HIS    10      36.728  44.774  17.872  1.00 29.21           C  
ATOM   1193  C   HIS    10      36.770  43.988  19.188  1.00 27.89           C  
ATOM   1194  O   HIS    10      35.747  43.834  19.863  1.00 27.83           O  
ATOM   1195  CB  HIS    10      36.453  43.833  16.696  1.00 29.11           C  
ATOM   1196  CG  HIS    10      35.127  43.131  16.782  1.00 30.96           C  
ATOM   1197  ND1 HIS    10      34.991  41.773  16.582  1.00 29.81           N  
ATOM   1198  CD2 HIS    10      33.882  43.596  17.055  1.00 32.11           C  
ATOM   1199  CE1 HIS    10      33.723  41.432  16.721  1.00 34.31           C  
ATOM   1200  NE2 HIS    10      33.025  42.520  17.004  1.00 31.48           N  
ATOM   1201  N   PHE    11      37.946  43.490  19.545  1.00 26.50           N  
ATOM   1202  CA  PHE    11      38.144  42.846  20.847  1.00 25.86           C  
ATOM   1203  C   PHE    11      37.899  43.833  22.005  1.00 25.41           C  
ATOM   1204  O   PHE    11      37.131  43.543  22.922  1.00 26.59           O  
ATOM   1205  CB  PHE    11      39.561  42.251  20.931  1.00 25.87           C  
ATOM   1206  CG  PHE    11      39.978  41.854  22.325  1.00 23.85           C  
ATOM   1207  CD1 PHE    11      39.402  40.765  22.948  1.00 23.40           C  
ATOM   1208  CD2 PHE    11      40.940  42.587  23.009  1.00 24.43           C  
ATOM   1209  CE1 PHE    11      39.769  40.403  24.233  1.00 24.62           C  
ATOM   1210  CE2 PHE    11      41.331  42.230  24.298  1.00 26.60           C  
ATOM   1211  CZ  PHE    11      40.751  41.136  24.910  1.00 25.39           C  
ATOM   1212  N   LEU    12      38.558  44.993  21.960  1.00 25.19           N  
ATOM   1213  CA  LEU    12      38.433  46.000  23.024  1.00 24.40           C  
ATOM   1214  C   LEU    12      37.013  46.571  23.154  1.00 24.37           C  
ATOM   1215  O   LEU    12      36.551  46.899  24.244  1.00 23.55           O  
ATOM   1216  CB  LEU    12      39.429  47.127  22.787  1.00 25.08           C  
ATOM   1217  CG  LEU    12      40.903  46.732  22.935  1.00 23.88           C  
ATOM   1218  CD1 LEU    12      41.772  47.927  22.675  1.00 19.99           C  
ATOM   1219  CD2 LEU    12      41.172  46.151  24.314  1.00 17.50           C  
ATOM   1220  N   SER    13      36.345  46.698  22.018  1.00 24.35           N  
ATOM   1221  CA  SER    13      34.937  47.074  21.945  1.00 24.92           C  
ATOM   1222  C   SER    13      34.094  46.327  22.991  1.00 25.13           C  
ATOM   1223  O   SER    13      33.214  46.894  23.629  1.00 27.77           O  
ATOM   1224  CB  SER    13      34.440  46.723  20.541  1.00 25.22           C  
ATOM   1225  OG  SER    13      33.092  47.020  20.376  1.00 26.42           O  
ATOM   1226  N   HIS    14      34.392  45.046  23.150  1.00 24.32           N  
ATOM   1227  CA  HIS    14      33.720  44.177  24.093  1.00 23.44           C  
ATOM   1228  C   HIS    14      34.479  44.063  25.424  1.00 22.45           C  
ATOM   1229  O   HIS    14      33.887  44.226  26.488  1.00 22.95           O  
ATOM   1230  CB  HIS    14      33.528  42.795  23.455  1.00 23.60           C  
ATOM   1231  CG  HIS    14      32.468  42.759  22.397  1.00 22.55           C  
ATOM   1232  ND1 HIS    14      31.123  42.736  22.695  1.00 22.51           N  
ATOM   1233  CD2 HIS    14      32.554  42.716  21.047  1.00 24.07           C  
ATOM   1234  CE1 HIS    14      30.425  42.689  21.575  1.00 22.12           C  
ATOM   1235  NE2 HIS    14      31.270  42.672  20.559  1.00 23.74           N  
ATOM   1236  N   ARG    15      35.782  43.819  25.364  1.00 23.33           N  
ATOM   1237  CA  ARG    15      36.609  43.694  26.581  1.00 23.65           C  
ATOM   1238  C   ARG    15      36.617  44.947  27.474  1.00 24.04           C  
ATOM   1239  O   ARG    15      36.658  44.830  28.696  1.00 25.31           O  
ATOM   1240  CB  ARG    15      38.040  43.267  26.216  1.00 22.98           C  
ATOM   1241  CG  ARG    15      39.061  43.250  27.369  1.00 25.04           C  
ATOM   1242  CD  ARG    15      38.654  42.372  28.575  1.00 23.51           C  
ATOM   1243  NE  ARG    15      38.553  40.961  28.233  1.00 25.26           N  
ATOM   1244  CZ  ARG    15      39.583  40.124  28.141  1.00 29.21           C  
ATOM   1245  NH1 ARG    15      40.828  40.529  28.388  1.00 30.40           N  
ATOM   1246  NH2 ARG    15      39.358  38.857  27.809  1.00 26.91           N  
ATOM   1247  N   ASN    16      36.571  46.142  26.889  1.00 24.45           N  
ATOM   1248  CA  ASN    16      36.470  47.356  27.702  1.00 24.31           C  
ATOM   1249  C   ASN    16      35.182  47.388  28.527  1.00 24.67           C  
ATOM   1250  O   ASN    16      35.152  47.967  29.618  1.00 24.35           O  
ATOM   1251  CB  ASN    16      36.580  48.634  26.848  1.00 23.87           C  
ATOM   1252  CG  ASN    16      37.991  48.873  26.313  1.00 25.17           C  
ATOM   1253  OD1 ASN    16      38.980  48.416  26.887  1.00 27.85           O  
ATOM   1254  ND2 ASN    16      38.085  49.616  25.218  1.00 24.54           N  
ATOM   1255  N   VAL    17      34.112  46.792  28.005  1.00 25.32           N  
ATOM   1256  CA  VAL    17      32.845  46.739  28.750  1.00 25.14           C  
ATOM   1257  C   VAL    17      32.951  45.686  29.871  1.00 25.47           C  
ATOM   1258  O   VAL    17      32.466  45.898  30.980  1.00 24.38           O  
ATOM   1259  CB  VAL    17      31.636  46.485  27.807  1.00 25.11           C  
ATOM   1260  CG1 VAL    17      30.329  46.424  28.590  1.00 23.93           C  
ATOM   1261  CG2 VAL    17      31.567  47.563  26.732  1.00 21.19           C  
ATOM   1262  N   THR    18      33.621  44.570  29.581  1.00 26.85           N  
ATOM   1263  CA  THR    18      33.871  43.517  30.570  1.00 27.43           C  
ATOM   1264  C   THR    18      34.686  44.040  31.750  1.00 28.37           C  
ATOM   1265  O   THR    18      34.401  43.716  32.908  1.00 27.86           O  
ATOM   1266  CB  THR    18      34.631  42.343  29.937  1.00 26.46           C  
ATOM   1267  OG1 THR    18      33.758  41.641  29.047  1.00 28.22           O  
ATOM   1268  CG2 THR    18      35.153  41.393  31.005  1.00 26.76           C  
ATOM   1269  N   ASN    19      35.712  44.830  31.436  1.00 29.46           N  
ATOM   1270  CA  ASN    19      36.583  45.415  32.444  1.00 29.44           C  
ATOM   1271  C   ASN    19      35.877  46.449  33.302  1.00 31.03           C  
ATOM   1272  O   ASN    19      36.120  46.544  34.505  1.00 32.27           O  
ATOM   1273  CB  ASN    19      37.800  46.053  31.781  1.00 28.63           C  
ATOM   1274  CG  ASN    19      38.752  45.038  31.224  1.00 27.67           C  
ATOM   1275  OD1 ASN    19      38.698  43.849  31.561  1.00 29.89           O  
ATOM   1276  ND2 ASN    19      39.631  45.490  30.362  1.00 16.24           N  
ATOM   1277  N   GLU    20      35.009  47.226  32.673  1.00 32.85           N  
ATOM   1278  CA  GLU    20      34.197  48.215  33.378  1.00 34.98           C  
ATOM   1279  C   GLU    20      33.218  47.533  34.338  1.00 32.92           C  
ATOM   1280  O   GLU    20      33.018  47.999  35.451  1.00 35.00           O  
ATOM   1281  CB  GLU    20      33.450  49.089  32.369  1.00 34.33           C  
ATOM   1282  CG  GLU    20      32.885  50.367  32.951  1.00 41.33           C  
ATOM   1283  CD  GLU    20      32.241  51.269  31.906  1.00 41.71           C  
ATOM   1284  OE1 GLU    20      32.529  51.102  30.688  1.00 48.89           O  
ATOM   1285  OE2 GLU    20      31.448  52.149  32.316  1.00 50.11           O  
ATOM   1286  N   LEU    21      32.624  46.426  33.905  1.00 31.28           N  
ATOM   1287  CA  LEU    21      31.700  45.645  34.734  1.00 30.29           C  
ATOM   1288  C   LEU    21      32.414  44.977  35.915  1.00 30.39           C  
ATOM   1289  O   LEU    21      31.860  44.873  37.015  1.00 30.47           O  
ATOM   1290  CB  LEU    21      30.993  44.561  33.892  1.00 29.76           C  
ATOM   1291  CG  LEU    21      29.893  44.963  32.899  1.00 27.66           C  
ATOM   1292  CD1 LEU    21      29.501  43.764  32.026  1.00 22.19           C  
ATOM   1293  CD2 LEU    21      28.660  45.529  33.614  1.00 25.56           C  
ATOM   1294  N   ALA    22      33.635  44.512  35.672  1.00 30.64           N  
ATOM   1295  CA  ALA    22      34.460  43.895  36.710  1.00 31.48           C  
ATOM   1296  C   ALA    22      34.780  44.861  37.856  1.00 32.45           C  
ATOM   1297  O   ALA    22      34.888  44.450  39.016  1.00 31.11           O  
ATOM   1298  CB  ALA    22      35.755  43.354  36.098  1.00 31.19           C  
ATOM   1299  N   GLU    23      34.934  46.138  37.510  1.00 34.47           N  
ATOM   1300  CA  GLU    23      35.214  47.208  38.475  1.00 36.19           C  
ATOM   1301  C   GLU    23      34.053  47.424  39.453  1.00 35.68           C  
ATOM   1302  O   GLU    23      34.267  47.870  40.573  1.00 36.37           O  
ATOM   1303  CB  GLU    23      35.582  48.500  37.711  1.00 36.80           C  
ATOM   1304  CG  GLU    23      34.996  49.826  38.232  1.00 44.97           C  
ATOM   1305  CD  GLU    23      35.795  50.464  39.365  1.00 54.10           C  
ATOM   1306  OE1 GLU    23      37.029  50.243  39.444  1.00 58.36           O  
ATOM   1307  OE2 GLU    23      35.181  51.215  40.160  1.00 55.37           O  
ATOM   1308  N   LYS    24      32.837  47.095  39.020  1.00 35.78           N  
ATOM   1309  CA  LYS    24      31.630  47.243  39.828  1.00 36.00           C  
ATOM   1310  C   LYS    24      31.403  46.089  40.811  1.00 36.32           C  
ATOM   1311  O   LYS    24      30.399  46.071  41.524  1.00 37.08           O  
ATOM   1312  CB  LYS    24      30.411  47.385  38.910  1.00 36.20           C  
ATOM   1313  CG  LYS    24      30.488  48.628  38.038  1.00 37.65           C  
ATOM   1314  CD  LYS    24      29.127  49.070  37.532  1.00 40.50           C  
ATOM   1315  CE  LYS    24      29.157  50.541  37.089  1.00 46.04           C  
ATOM   1316  NZ  LYS    24      30.023  50.741  35.879  1.00 47.21           N  
ATOM   1317  N   ILE    25      32.337  45.138  40.840  1.00 35.88           N  
ATOM   1318  CA  ILE    25      32.294  43.987  41.733  1.00 35.06           C  
ATOM   1319  C   ILE    25      33.129  44.260  42.988  1.00 36.05           C  
ATOM   1320  O   ILE    25      34.364  44.186  42.953  1.00 35.12           O  
ATOM   1321  CB  ILE    25      32.851  42.718  41.022  1.00 34.99           C  
ATOM   1322  CG1 ILE    25      32.047  42.405  39.750  1.00 36.68           C  
ATOM   1323  CG2 ILE    25      32.848  41.515  41.959  1.00 34.29           C  
ATOM   1324  CD1 ILE    25      32.637  41.292  38.907  1.00 33.67           C  
ATOM   1325  N   SER    26      32.457  44.580  44.092  1.00 37.22           N  
ATOM   1326  CA  SER    26      33.128  44.736  45.383  1.00 38.56           C  
ATOM   1327  C   SER    26      33.758  43.410  45.786  1.00 40.35           C  
ATOM   1328  O   SER    26      33.334  42.354  45.310  1.00 41.06           O  
ATOM   1329  CB  SER    26      32.125  45.138  46.459  1.00 38.56           C  
ATOM   1330  OG  SER    26      31.263  44.055  46.775  1.00 37.07           O  
ATOM   1331  N   LYS    27      34.756  43.461  46.666  1.00 41.84           N  
ATOM   1332  CA  LYS    27      35.441  42.247  47.124  1.00 43.21           C  
ATOM   1333  C   LYS    27      34.509  41.312  47.910  1.00 42.45           C  
ATOM   1334  O   LYS    27      34.734  40.103  47.968  1.00 41.33           O  
ATOM   1335  CB  LYS    27      36.707  42.600  47.918  1.00 43.47           C  
ATOM   1336  CG  LYS    27      37.740  43.358  47.071  1.00 45.04           C  
ATOM   1337  CD  LYS    27      39.142  43.329  47.664  1.00 45.26           C  
ATOM   1338  CE  LYS    27      39.954  42.132  47.180  1.00 47.98           C  
ATOM   1339  NZ  LYS    27      40.646  42.396  45.885  1.00 44.46           N  
ATOM   1340  N   ASP    28      33.448  41.865  48.491  1.00 43.17           N  
ATOM   1341  CA  ASP    28      32.423  41.038  49.143  1.00 43.66           C  
ATOM   1342  C   ASP    28      31.589  40.274  48.109  1.00 42.08           C  
ATOM   1343  O   ASP    28      30.981  39.250  48.419  1.00 41.99           O  
ATOM   1344  CB  ASP    28      31.504  41.876  50.056  1.00 44.61           C  
ATOM   1345  CG  ASP    28      32.015  41.950  51.499  1.00 50.08           C  
ATOM   1346  OD1 ASP    28      32.189  40.877  52.115  1.00 52.94           O  
ATOM   1347  OD2 ASP    28      32.229  43.067  52.026  1.00 53.70           O  
ATOM   1348  N   HIS    29      31.575  40.767  46.875  1.00 40.09           N  
ATOM   1349  CA  HIS    29      30.784  40.157  45.813  1.00 38.00           C  
ATOM   1350  C   HIS    29      31.591  39.254  44.869  1.00 35.48           C  
ATOM   1351  O   HIS    29      31.047  38.750  43.891  1.00 34.55           O  
ATOM   1352  CB  HIS    29      30.051  41.241  45.014  1.00 37.73           C  
ATOM   1353  CG  HIS    29      28.769  41.692  45.637  1.00 38.39           C  
ATOM   1354  ND1 HIS    29      28.368  43.010  45.641  1.00 39.31           N  
ATOM   1355  CD2 HIS    29      27.793  40.999  46.267  1.00 39.76           C  
ATOM   1356  CE1 HIS    29      27.201  43.109  46.251  1.00 41.37           C  
ATOM   1357  NE2 HIS    29      26.830  41.903  46.639  1.00 41.73           N  
ATOM   1358  N   TYR    30      32.873  39.052  45.163  1.00 33.70           N  
ATOM   1359  CA  TYR    30      33.706  38.095  44.423  1.00 32.36           C  
ATOM   1360  C   TYR    30      33.079  36.686  44.430  1.00 32.70           C  
ATOM   1361  O   TYR    30      33.074  35.983  43.416  1.00 32.96           O  
ATOM   1362  CB  TYR    30      35.106  38.029  45.044  1.00 31.66           C  
ATOM   1363  CG  TYR    30      36.109  39.075  44.583  1.00 30.06           C  
ATOM   1364  CD1 TYR    30      35.708  40.312  44.111  1.00 29.10           C  
ATOM   1365  CD2 TYR    30      37.483  38.822  44.672  1.00 30.44           C  
ATOM   1366  CE1 TYR    30      36.643  41.265  43.700  1.00 29.51           C  
ATOM   1367  CE2 TYR    30      38.421  39.763  44.272  1.00 29.19           C  
ATOM   1368  CZ  TYR    30      37.999  40.983  43.786  1.00 31.71           C  
ATOM   1369  OH  TYR    30      38.933  41.930  43.389  1.00 31.55           O  
ATOM   1370  N   SER    31      32.546  36.289  45.586  1.00 32.70           N  
ATOM   1371  CA  SER    31      31.925  34.974  45.767  1.00 31.27           C  
ATOM   1372  C   SER    31      30.485  34.902  45.255  1.00 29.76           C  
ATOM   1373  O   SER    31      29.886  33.828  45.261  1.00 29.74           O  
ATOM   1374  CB  SER    31      31.904  34.639  47.255  1.00 31.47           C  
ATOM   1375  OG  SER    31      31.001  35.510  47.929  1.00 31.56           O  
ATOM   1376  N   TYR    32      29.923  36.031  44.826  1.00 29.31           N  
ATOM   1377  CA  TYR    32      28.493  36.105  44.518  1.00 28.85           C  
ATOM   1378  C   TYR    32      28.089  35.149  43.394  1.00 30.14           C  
ATOM   1379  O   TYR    32      28.698  35.128  42.324  1.00 31.63           O  
ATOM   1380  CB  TYR    32      28.054  37.533  44.156  1.00 28.51           C  
ATOM   1381  CG  TYR    32      26.573  37.583  43.859  1.00 28.85           C  
ATOM   1382  CD1 TYR    32      25.640  37.573  44.892  1.00 30.87           C  
ATOM   1383  CD2 TYR    32      26.104  37.564  42.555  1.00 30.04           C  
ATOM   1384  CE1 TYR    32      24.285  37.577  44.632  1.00 31.57           C  
ATOM   1385  CE2 TYR    32      24.743  37.561  42.284  1.00 28.50           C  
ATOM   1386  CZ  TYR    32      23.840  37.567  43.328  1.00 30.20           C  
ATOM   1387  OH  TYR    32      22.491  37.566  43.071  1.00 27.86           O  
ATOM   1388  N   LYS    33      27.062  34.354  43.664  1.00 30.60           N  
ATOM   1389  CA  LYS    33      26.541  33.386  42.716  1.00 30.67           C  
ATOM   1390  C   LYS    33      25.036  33.621  42.611  1.00 29.00           C  
ATOM   1391  O   LYS    33      24.353  33.610  43.634  1.00 27.20           O  
ATOM   1392  CB  LYS    33      26.804  31.963  43.218  1.00 30.54           C  
ATOM   1393  CG  LYS    33      28.261  31.518  43.131  1.00 31.84           C  
ATOM   1394  CD  LYS    33      28.444  30.104  43.651  1.00 32.67           C  
ATOM   1395  CE  LYS    33      29.915  29.685  43.643  1.00 38.32           C  
ATOM   1396  NZ  LYS    33      30.093  28.233  43.927  1.00 35.17           N  
ATOM   1397  N   PRO    34      24.527  33.902  41.397  1.00 27.53           N  
ATOM   1398  CA  PRO    34      23.093  34.023  41.131  1.00 27.92           C  
ATOM   1399  C   PRO    34      22.258  32.808  41.526  1.00 27.42           C  
ATOM   1400  O   PRO    34      21.134  32.971  42.007  1.00 26.94           O  
ATOM   1401  CB  PRO    34      23.043  34.209  39.609  1.00 28.69           C  
ATOM   1402  CG  PRO    34      24.349  34.838  39.276  1.00 28.43           C  
ATOM   1403  CD  PRO    34      25.323  34.197  40.193  1.00 27.34           C  
ATOM   1404  N   ALA    35      22.800  31.615  41.282  1.00 28.20           N  
ATOM   1405  CA  ALA    35      22.192  30.348  41.691  1.00 29.19           C  
ATOM   1406  C   ALA    35      23.291  29.440  42.234  1.00 30.41           C  
ATOM   1407  O   ALA    35      24.477  29.688  41.984  1.00 29.92           O  
ATOM   1408  CB  ALA    35      21.486  29.688  40.515  1.00 27.66           C  
ATOM   1409  N   GLU    36      22.900  28.382  42.949  1.00 31.54           N  
ATOM   1410  CA  GLU    36      23.861  27.475  43.590  1.00 33.38           C  
ATOM   1411  C   GLU    36      24.823  26.807  42.625  1.00 32.55           C  
ATOM   1412  O   GLU    36      25.968  26.559  42.979  1.00 33.40           O  
ATOM   1413  CB  GLU    36      23.150  26.386  44.381  1.00 34.20           C  
ATOM   1414  CG  GLU    36      22.389  26.881  45.598  1.00 37.06           C  
ATOM   1415  CD  GLU    36      22.094  25.766  46.602  1.00 39.82           C  
ATOM   1416  OE1 GLU    36      22.175  24.569  46.227  1.00 44.32           O  
ATOM   1417  OE2 GLU    36      21.794  26.094  47.775  1.00 47.78           O  
ATOM   1418  N   THR    37      24.351  26.510  41.419  1.00 31.80           N  
ATOM   1419  CA  THR    37      25.157  25.853  40.393  1.00 31.56           C  
ATOM   1420  C   THR    37      25.885  26.843  39.474  1.00 32.32           C  
ATOM   1421  O   THR    37      26.457  26.434  38.474  1.00 33.55           O  
ATOM   1422  CB  THR    37      24.262  24.924  39.568  1.00 31.01           C  
ATOM   1423  OG1 THR    37      23.098  25.641  39.152  1.00 31.99           O  
ATOM   1424  CG2 THR    37      23.806  23.726  40.418  1.00 31.00           C  
ATOM   1425  N   SER    38      25.883  28.134  39.826  1.00 32.65           N  
ATOM   1426  CA  SER    38      26.541  29.182  39.021  1.00 31.97           C  
ATOM   1427  C   SER    38      28.004  29.341  39.378  1.00 30.83           C  
ATOM   1428  O   SER    38      28.405  28.993  40.476  1.00 31.30           O  
ATOM   1429  CB  SER    38      25.870  30.550  39.232  1.00 31.46           C  
ATOM   1430  OG  SER    38      24.536  30.548  38.778  1.00 32.46           O  
ATOM   1431  N   MET    39      28.791  29.880  38.446  1.00 30.71           N  
ATOM   1432  CA  MET    39      30.141  30.329  38.764  1.00 28.97           C  
ATOM   1433  C   MET    39      29.976  31.552  39.652  1.00 28.65           C  
ATOM   1434  O   MET    39      28.998  32.284  39.522  1.00 27.14           O  
ATOM   1435  CB  MET    39      30.933  30.734  37.516  1.00 28.74           C  
ATOM   1436  CG  MET    39      31.363  29.598  36.573  1.00 31.41           C  
ATOM   1437  SD  MET    39      32.514  30.228  35.067  0.75 25.74          SE  
ATOM   1438  CE  MET    39      34.264  29.826  35.772  1.00 37.14           C  
ATOM   1439  N   SER    40      30.928  31.768  40.550  1.00 28.71           N  
ATOM   1440  CA  SER    40      30.961  32.977  41.347  1.00 28.93           C  
ATOM   1441  C   SER    40      31.356  34.119  40.422  1.00 29.26           C  
ATOM   1442  O   SER    40      31.856  33.886  39.321  1.00 28.27           O  
ATOM   1443  CB  SER    40      31.977  32.857  42.485  1.00 28.55           C  
ATOM   1444  OG  SER    40      33.300  32.845  41.971  1.00 31.56           O  
ATOM   1445  N   ALA    41      31.141  35.346  40.883  1.00 29.32           N  
ATOM   1446  CA  ALA    41      31.479  36.531  40.109  1.00 28.43           C  
ATOM   1447  C   ALA    41      32.928  36.492  39.643  1.00 28.87           C  
ATOM   1448  O   ALA    41      33.208  36.745  38.475  1.00 29.06           O  
ATOM   1449  CB  ALA    41      31.216  37.789  40.924  1.00 28.00           C  
ATOM   1450  N   GLU    42      33.844  36.156  40.549  1.00 30.19           N  
ATOM   1451  CA  GLU    42      35.266  36.137  40.215  1.00 32.30           C  
ATOM   1452  C   GLU    42      35.669  34.956  39.338  1.00 31.49           C  
ATOM   1453  O   GLU    42      36.549  35.098  38.495  1.00 31.64           O  
ATOM   1454  CB  GLU    42      36.150  36.217  41.468  1.00 32.29           C  
ATOM   1455  CG  GLU    42      36.145  35.016  42.371  1.00 35.81           C  
ATOM   1456  CD  GLU    42      37.144  35.156  43.514  1.00 36.28           C  
ATOM   1457  OE1 GLU    42      38.328  35.484  43.242  1.00 35.57           O  
ATOM   1458  OE2 GLU    42      36.744  34.923  44.680  1.00 43.97           O  
ATOM   1459  N   GLU    43      35.044  33.797  39.532  1.00 30.87           N  
ATOM   1460  CA  GLU    43      35.260  32.661  38.625  1.00 30.39           C  
ATOM   1461  C   GLU    43      34.845  33.040  37.214  1.00 29.35           C  
ATOM   1462  O   GLU    43      35.531  32.703  36.238  1.00 29.22           O  
ATOM   1463  CB  GLU    43      34.467  31.425  39.060  1.00 30.93           C  
ATOM   1464  CG  GLU    43      35.062  30.666  40.239  1.00 32.30           C  
ATOM   1465  CD  GLU    43      34.153  29.551  40.752  1.00 32.16           C  
ATOM   1466  OE1 GLU    43      32.930  29.604  40.535  1.00 35.30           O  
ATOM   1467  OE2 GLU    43      34.667  28.617  41.401  1.00 38.93           O  
ATOM   1468  N   LEU    44      33.722  33.747  37.111  1.00 27.81           N  
ATOM   1469  CA  LEU    44      33.205  34.170  35.813  1.00 27.14           C  
ATOM   1470  C   LEU    44      34.204  35.093  35.145  1.00 26.11           C  
ATOM   1471  O   LEU    44      34.615  34.849  34.019  1.00 26.10           O  
ATOM   1472  CB  LEU    44      31.835  34.853  35.958  1.00 27.33           C  
ATOM   1473  CG  LEU    44      31.197  35.427  34.687  1.00 26.54           C  
ATOM   1474  CD1 LEU    44      31.341  34.484  33.494  1.00 26.87           C  
ATOM   1475  CD2 LEU    44      29.729  35.714  34.941  1.00 25.50           C  
ATOM   1476  N   VAL    45      34.619  36.132  35.865  1.00 26.48           N  
ATOM   1477  CA  VAL    45      35.510  37.144  35.325  1.00 26.04           C  
ATOM   1478  C   VAL    45      36.867  36.552  34.944  1.00 27.08           C  
ATOM   1479  O   VAL    45      37.346  36.802  33.850  1.00 27.54           O  
ATOM   1480  CB  VAL    45      35.683  38.334  36.309  1.00 27.04           C  
ATOM   1481  CG1 VAL    45      36.744  39.312  35.797  1.00 25.46           C  
ATOM   1482  CG2 VAL    45      34.352  39.042  36.521  1.00 23.13           C  
ATOM   1483  N   LYS    46      37.482  35.767  35.827  1.00 28.21           N  
ATOM   1484  CA  LYS    46      38.793  35.155  35.522  1.00 29.00           C  
ATOM   1485  C   LYS    46      38.708  34.265  34.287  1.00 28.55           C  
ATOM   1486  O   LYS    46      39.629  34.250  33.464  1.00 29.07           O  
ATOM   1487  CB  LYS    46      39.324  34.321  36.690  1.00 29.20           C  
ATOM   1488  CG  LYS    46      39.776  35.118  37.886  1.00 31.60           C  
ATOM   1489  CD  LYS    46      40.299  34.197  38.968  1.00 29.66           C  
ATOM   1490  CE  LYS    46      40.389  34.916  40.294  1.00 37.54           C  
ATOM   1491  NZ  LYS    46      40.795  33.997  41.394  1.00 35.65           N  
ATOM   1492  N   HIS    47      37.616  33.505  34.172  1.00 27.91           N  
ATOM   1493  CA  HIS    47      37.432  32.622  33.016  1.00 27.17           C  
ATOM   1494  C   HIS    47      37.379  33.401  31.699  1.00 25.59           C  
ATOM   1495  O   HIS    47      37.956  32.964  30.704  1.00 26.75           O  
ATOM   1496  CB  HIS    47      36.190  31.743  33.159  1.00 27.46           C  
ATOM   1497  CG  HIS    47      35.905  30.922  31.937  1.00 28.87           C  
ATOM   1498  ND1 HIS    47      36.734  29.908  31.515  1.00 32.09           N  
ATOM   1499  CD2 HIS    47      34.908  30.996  31.025  1.00 28.90           C  
ATOM   1500  CE1 HIS    47      36.257  29.387  30.399  1.00 27.52           C  
ATOM   1501  NE2 HIS    47      35.146  30.027  30.083  1.00 28.54           N  
ATOM   1502  N   ILE    48      36.699  34.545  31.701  1.00 25.40           N  
ATOM   1503  CA  ILE    48      36.648  35.436  30.536  1.00 24.70           C  
ATOM   1504  C   ILE    48      38.065  35.852  30.154  1.00 25.30           C  
ATOM   1505  O   ILE    48      38.456  35.765  28.997  1.00 26.11           O  
ATOM   1506  CB  ILE    48      35.781  36.700  30.805  1.00 25.39           C  
ATOM   1507  CG1 ILE    48      34.294  36.324  30.910  1.00 26.97           C  
ATOM   1508  CG2 ILE    48      35.972  37.754  29.707  1.00 21.47           C  
ATOM   1509  CD1 ILE    48      33.372  37.436  31.476  1.00 21.56           C  
ATOM   1510  N   LEU    49      38.837  36.259  31.148  1.00 25.60           N  
ATOM   1511  CA  LEU    49      40.199  36.717  30.947  1.00 24.97           C  
ATOM   1512  C   LEU    49      41.170  35.634  30.482  1.00 25.95           C  
ATOM   1513  O   LEU    49      41.891  35.831  29.502  1.00 27.25           O  
ATOM   1514  CB  LEU    49      40.725  37.337  32.231  1.00 24.59           C  
ATOM   1515  CG  LEU    49      40.077  38.643  32.687  1.00 26.07           C  
ATOM   1516  CD1 LEU    49      40.707  39.082  34.017  1.00 25.43           C  
ATOM   1517  CD2 LEU    49      40.202  39.746  31.632  1.00 21.72           C  
ATOM   1518  N   THR    50      41.206  34.501  31.184  1.00 26.62           N  
ATOM   1519  CA  THR    50      42.139  33.428  30.831  1.00 26.53           C  
ATOM   1520  C   THR    50      41.768  32.721  29.518  1.00 28.19           C  
ATOM   1521  O   THR    50      42.664  32.330  28.753  1.00 29.08           O  
ATOM   1522  CB  THR    50      42.279  32.370  31.958  1.00 26.75           C  
ATOM   1523  OG1 THR    50      41.018  31.734  32.195  1.00 29.27           O  
ATOM   1524  CG2 THR    50      42.785  33.010  33.255  1.00 20.35           C  
ATOM   1525  N   SER    51      40.469  32.568  29.242  1.00 28.56           N  
ATOM   1526  CA  SER    51      40.053  31.808  28.064  1.00 29.13           C  
ATOM   1527  C   SER    51      40.431  32.521  26.777  1.00 28.90           C  
ATOM   1528  O   SER    51      40.940  31.880  25.847  1.00 30.53           O  
ATOM   1529  CB  SER    51      38.557  31.446  28.084  1.00 28.88           C  
ATOM   1530  OG  SER    51      37.727  32.590  28.069  1.00 33.02           O  
ATOM   1531  N   PHE    52      40.194  33.830  26.703  1.00 27.66           N  
ATOM   1532  CA  PHE    52      40.530  34.557  25.483  1.00 27.14           C  
ATOM   1533  C   PHE    52      42.039  34.554  25.296  1.00 27.70           C  
ATOM   1534  O   PHE    52      42.530  34.421  24.178  1.00 28.71           O  
ATOM   1535  CB  PHE    52      40.001  35.993  25.481  1.00 27.08           C  
ATOM   1536  CG  PHE    52      39.811  36.560  24.089  1.00 25.86           C  
ATOM   1537  CD1 PHE    52      40.907  36.795  23.256  1.00 25.78           C  
ATOM   1538  CD2 PHE    52      38.542  36.839  23.608  1.00 23.07           C  
ATOM   1539  CE1 PHE    52      40.725  37.299  21.977  1.00 26.17           C  
ATOM   1540  CE2 PHE    52      38.359  37.351  22.333  1.00 23.04           C  
ATOM   1541  CZ  PHE    52      39.446  37.570  21.514  1.00 23.22           C  
ATOM   1542  N   HIS    53      42.772  34.683  26.394  1.00 28.75           N  
ATOM   1543  CA  HIS    53      44.234  34.689  26.347  1.00 29.87           C  
ATOM   1544  C   HIS    53      44.799  33.336  25.861  1.00 29.22           C  
ATOM   1545  O   HIS    53      45.774  33.303  25.101  1.00 28.96           O  
ATOM   1546  CB  HIS    53      44.812  35.081  27.710  1.00 29.38           C  
ATOM   1547  CG  HIS    53      46.297  35.259  27.699  1.00 32.09           C  
ATOM   1548  ND1 HIS    53      47.161  34.324  28.221  1.00 36.75           N  
ATOM   1549  CD2 HIS    53      47.071  36.250  27.200  1.00 34.27           C  
ATOM   1550  CE1 HIS    53      48.405  34.738  28.056  1.00 36.33           C  
ATOM   1551  NE2 HIS    53      48.377  35.904  27.439  1.00 35.25           N  
ATOM   1552  N   LEU    54      44.175  32.237  26.280  1.00 28.84           N  
ATOM   1553  CA  LEU    54      44.545  30.908  25.787  1.00 29.41           C  
ATOM   1554  C   LEU    54      44.344  30.820  24.271  1.00 29.89           C  
ATOM   1555  O   LEU    54      45.283  30.469  23.530  1.00 28.10           O  
ATOM   1556  CB  LEU    54      43.746  29.812  26.501  1.00 28.57           C  
ATOM   1557  CG  LEU    54      44.049  28.359  26.102  1.00 30.83           C  
ATOM   1558  CD1 LEU    54      45.538  28.026  26.269  1.00 28.39           C  
ATOM   1559  CD2 LEU    54      43.180  27.371  26.890  1.00 30.29           C  
ATOM   1560  N   PHE    55      43.134  31.159  23.817  1.00 30.20           N  
ATOM   1561  CA  PHE    55      42.819  31.153  22.382  1.00 32.29           C  
ATOM   1562  C   PHE    55      43.787  32.023  21.577  1.00 31.95           C  
ATOM   1563  O   PHE    55      44.243  31.620  20.510  1.00 32.57           O  
ATOM   1564  CB  PHE    55      41.398  31.652  22.119  1.00 34.13           C  
ATOM   1565  CG  PHE    55      40.317  30.681  22.505  1.00 36.99           C  
ATOM   1566  CD1 PHE    55      40.343  29.372  22.063  1.00 39.85           C  
ATOM   1567  CD2 PHE    55      39.236  31.104  23.275  1.00 45.14           C  
ATOM   1568  CE1 PHE    55      39.330  28.494  22.403  1.00 44.15           C  
ATOM   1569  CE2 PHE    55      38.220  30.231  23.620  1.00 45.62           C  
ATOM   1570  CZ  PHE    55      38.263  28.923  23.179  1.00 43.03           C  
ATOM   1571  N   ALA    56      44.077  33.221  22.089  1.00 31.31           N  
ATOM   1572  CA  ALA    56      45.030  34.131  21.448  1.00 30.70           C  
ATOM   1573  C   ALA    56      46.421  33.491  21.272  1.00 29.92           C  
ATOM   1574  O   ALA    56      47.059  33.654  20.231  1.00 30.50           O  
ATOM   1575  CB  ALA    56      45.132  35.443  22.241  1.00 30.35           C  
ATOM   1576  N   ASN    57      46.879  32.749  22.274  1.00 30.14           N  
ATOM   1577  CA  ASN    57      48.161  32.034  22.164  1.00 31.35           C  
ATOM   1578  C   ASN    57      48.100  30.807  21.225  1.00 32.06           C  
ATOM   1579  O   ASN    57      49.095  30.465  20.591  1.00 32.88           O  
ATOM   1580  CB  ASN    57      48.708  31.665  23.553  1.00 31.09           C  
ATOM   1581  CG  ASN    57      49.664  32.728  24.110  1.00 33.29           C  
ATOM   1582  OD1 ASN    57      50.701  33.008  23.514  1.00 36.72           O  
ATOM   1583  ND2 ASN    57      49.326  33.305  25.261  1.00 32.00           N  
ATOM   1584  N   VAL    58      46.936  30.166  21.120  1.00 32.60           N  
ATOM   1585  CA  VAL    58      46.760  29.045  20.194  1.00 32.08           C  
ATOM   1586  C   VAL    58      46.876  29.526  18.742  1.00 32.30           C  
ATOM   1587  O   VAL    58      47.545  28.890  17.934  1.00 32.10           O  
ATOM   1588  CB  VAL    58      45.419  28.287  20.433  1.00 31.98           C  
ATOM   1589  CG1 VAL    58      45.237  27.157  19.410  1.00 29.82           C  
ATOM   1590  CG2 VAL    58      45.366  27.727  21.861  1.00 28.52           C  
ATOM   1591  N   ILE    59      46.235  30.650  18.422  1.00 32.76           N  
ATOM   1592  CA  ILE    59      46.363  31.279  17.092  1.00 33.21           C  
ATOM   1593  C   ILE    59      47.797  31.770  16.842  1.00 33.87           C  
ATOM   1594  O   ILE    59      48.332  31.642  15.741  1.00 33.61           O  
ATOM   1595  CB  ILE    59      45.427  32.500  16.938  1.00 33.99           C  
ATOM   1596  CG1 ILE    59      43.950  32.095  17.083  1.00 33.69           C  
ATOM   1597  CG2 ILE    59      45.664  33.206  15.586  1.00 31.95           C  
ATOM   1598  CD1 ILE    59      43.006  33.284  17.176  1.00 32.20           C  
ATOM   1599  N   LYS    60      48.411  32.330  17.872  1.00 35.71           N  
ATOM   1600  CA  LYS    60      49.772  32.840  17.767  1.00 37.57           C  
ATOM   1601  C   LYS    60      50.764  31.721  17.441  1.00 38.24           C  
ATOM   1602  O   LYS    60      51.604  31.872  16.562  1.00 37.60           O  
ATOM   1603  CB  LYS    60      50.174  33.557  19.062  1.00 37.54           C  
ATOM   1604  CG  LYS    60      51.655  33.883  19.189  1.00 36.89           C  
ATOM   1605  CD  LYS    60      51.907  34.811  20.361  1.00 39.39           C  
ATOM   1606  CE  LYS    60      53.381  34.926  20.678  1.00 43.88           C  
ATOM   1607  NZ  LYS    60      53.698  36.138  21.480  1.00 45.53           N  
ATOM   1608  N   GLU    61      50.662  30.603  18.150  1.00 39.86           N  
ATOM   1609  CA  GLU    61      51.580  29.486  17.934  1.00 40.82           C  
ATOM   1610  C   GLU    61      51.197  28.632  16.722  1.00 41.21           C  
ATOM   1611  O   GLU    61      52.065  28.113  16.025  1.00 41.01           O  
ATOM   1612  CB  GLU    61      51.673  28.611  19.193  1.00 40.22           C  
ATOM   1613  CG  GLU    61      52.201  29.330  20.445  1.00 41.09           C  
ATOM   1614  CD  GLU    61      53.587  29.968  20.275  1.00 41.98           C  
ATOM   1615  OE1 GLU    61      54.314  29.626  19.319  1.00 43.56           O  
ATOM   1616  OE2 GLU    61      53.956  30.816  21.114  1.00 41.89           O  
ATOM   1617  N   GLY    62      49.896  28.506  16.472  1.00 42.51           N  
ATOM   1618  CA  GLY    62      49.378  27.596  15.455  1.00 43.05           C  
ATOM   1619  C   GLY    62      49.304  26.169  15.972  1.00 43.55           C  
ATOM   1620  O   GLY    62      48.994  25.252  15.216  1.00 44.20           O  
ATOM   1621  N   ASN    63      49.576  25.996  17.266  1.00 44.07           N  
ATOM   1622  CA  ASN    63      49.674  24.692  17.917  1.00 44.21           C  
ATOM   1623  C   ASN    63      48.667  24.579  19.044  1.00 44.05           C  
ATOM   1624  O   ASN    63      48.103  25.579  19.482  1.00 43.63           O  
ATOM   1625  CB  ASN    63      51.057  24.530  18.552  1.00 43.35           C  
ATOM   1626  CG  ASN    63      52.175  24.755  17.581  1.00 46.03           C  
ATOM   1627  OD1 ASN    63      52.015  24.563  16.380  1.00 56.39           O  
ATOM   1628  ND2 ASN    63      53.329  25.158  18.093  1.00 46.14           N  
ATOM   1629  N   ALA    64      48.497  23.354  19.541  1.00 44.06           N  
ATOM   1630  CA  ALA    64      47.735  23.100  20.759  1.00 43.65           C  
ATOM   1631  C   ALA    64      48.652  23.159  21.986  1.00 42.60           C  
ATOM   1632  O   ALA    64      48.215  22.878  23.100  1.00 42.66           O  
ATOM   1633  CB  ALA    64      47.047  21.750  20.674  1.00 44.16           C  
ATOM   1634  N   SER    65      49.913  23.548  21.778  1.00 41.62           N  
ATOM   1635  CA  SER    65      50.914  23.588  22.848  1.00 40.66           C  
ATOM   1636  C   SER    65      50.624  24.576  23.992  1.00 39.74           C  
ATOM   1637  O   SER    65      50.986  24.293  25.121  1.00 39.46           O  
ATOM   1638  CB  SER    65      52.332  23.802  22.273  1.00 39.86           C  
ATOM   1639  OG  SER    65      52.479  25.053  21.630  1.00 38.52           O  
ATOM   1640  N   PRO    66      49.983  25.731  23.718  1.00 39.50           N  
ATOM   1641  CA  PRO    66      49.632  26.610  24.848  1.00 39.62           C  
ATOM   1642  C   PRO    66      48.674  26.005  25.903  1.00 40.52           C  
ATOM   1643  O   PRO    66      48.529  26.577  26.989  1.00 40.07           O  
ATOM   1644  CB  PRO    66      48.999  27.830  24.163  1.00 39.89           C  
ATOM   1645  CG  PRO    66      49.525  27.792  22.756  1.00 39.12           C  
ATOM   1646  CD  PRO    66      49.599  26.337  22.428  1.00 39.03           C  
ATOM   1647  N   PHE    67      48.033  24.874  25.599  1.00 41.75           N  
ATOM   1648  CA  PHE    67      47.273  24.136  26.617  1.00 43.43           C  
ATOM   1649  C   PHE    67      48.212  23.489  27.643  1.00 44.65           C  
ATOM   1650  O   PHE    67      47.832  23.293  28.801  1.00 44.48           O  
ATOM   1651  CB  PHE    67      46.384  23.053  25.996  1.00 44.15           C  
ATOM   1652  CG  PHE    67      45.455  23.559  24.931  1.00 45.35           C  
ATOM   1653  CD1 PHE    67      44.694  24.703  25.134  1.00 48.97           C  
ATOM   1654  CD2 PHE    67      45.327  22.883  23.728  1.00 47.36           C  
ATOM   1655  CE1 PHE    67      43.834  25.171  24.148  1.00 47.77           C  
ATOM   1656  CE2 PHE    67      44.476  23.353  22.740  1.00 47.83           C  
ATOM   1657  CZ  PHE    67      43.728  24.495  22.955  1.00 44.88           C  
ATOM   1658  N   GLN    68      49.425  23.149  27.209  1.00 46.69           N  
ATOM   1659  CA  GLN    68      50.444  22.560  28.089  1.00 48.37           C  
ATOM   1660  C   GLN    68      50.999  23.583  29.073  1.00 50.08           C  
ATOM   1661  O   GLN    68      51.458  23.216  30.156  1.00 50.91           O  
ATOM   1662  CB  GLN    68      51.607  21.962  27.275  1.00 48.44           C  
ATOM   1663  CG  GLN    68      51.370  20.560  26.709  1.00 49.99           C  
ATOM   1664  CD  GLN    68      50.026  20.407  26.019  1.00 50.43           C  
ATOM   1665  OE1 GLN    68      48.982  20.371  26.673  1.00 50.63           O  
ATOM   1666  NE2 GLN    68      50.047  20.305  24.691  1.00 50.53           N  
ATOM   1667  N   ASN    69      50.974  24.859  28.688  1.00 51.88           N  
ATOM   1668  CA  ASN    69      51.449  25.938  29.552  1.00 53.28           C  
ATOM   1669  C   ASN    69      50.511  26.154  30.740  1.00 54.71           C  
ATOM   1670  O   ASN    69      49.505  26.850  30.618  1.00 54.91           O  
ATOM   1671  CB  ASN    69      51.588  27.240  28.752  1.00 53.14           C  
ATOM   1672  N   LYS    70      50.835  25.536  31.874  1.00 57.03           N  
ATOM   1673  CA  LYS    70      50.099  25.758  33.119  1.00 58.38           C  
ATOM   1674  C   LYS    70      50.589  27.059  33.750  1.00 59.82           C  
ATOM   1675  O   LYS    70      51.596  27.058  34.465  1.00 59.85           O  
ATOM   1676  CB  LYS    70      50.324  24.599  34.092  1.00 58.61           C  
ATOM   1677  N   GLN    71      49.889  28.161  33.473  1.00 61.09           N  
ATOM   1678  CA  GLN    71      50.291  29.486  33.963  1.00 62.37           C  
ATOM   1679  C   GLN    71      49.654  29.793  35.321  1.00 63.43           C  
ATOM   1680  O   GLN    71      48.464  30.126  35.397  1.00 64.18           O  
ATOM   1681  CB  GLN    71      49.910  30.572  32.952  1.00 62.69           C  
ATOM   1682  N   GLU    72      50.451  29.679  36.386  1.00 63.24           N  
ATOM   1683  CA  GLU    72      49.984  29.958  37.746  1.00 62.89           C  
ATOM   1684  C   GLU    72      49.973  31.469  38.008  1.00 62.36           C  
ATOM   1685  O   GLU    72      50.992  32.045  38.403  1.00 62.30           O  
ATOM   1686  CB  GLU    72      50.871  29.246  38.777  1.00 62.86           C  
ATOM   1687  N   GLU    73      48.824  32.106  37.772  1.00 60.95           N  
ATOM   1688  CA  GLU    73      48.670  33.540  38.035  1.00 59.65           C  
ATOM   1689  C   GLU    73      48.477  33.737  39.540  1.00 57.43           C  
ATOM   1690  O   GLU    73      47.552  33.173  40.130  1.00 57.80           O  
ATOM   1691  CB  GLU    73      47.484  34.123  37.250  1.00 60.09           C  
ATOM   1692  CG  GLU    73      47.401  35.662  37.243  1.00 60.77           C  
ATOM   1693  CD  GLU    73      48.532  36.354  36.463  1.00 62.91           C  
ATOM   1694  OE1 GLU    73      49.224  35.689  35.663  1.00 64.78           O  
ATOM   1695  OE2 GLU    73      48.720  37.577  36.645  1.00 61.24           O  
ATOM   1696  N   THR    74      49.361  34.526  40.149  1.00 54.02           N  
ATOM   1697  CA  THR    74      49.358  34.754  41.597  1.00 52.74           C  
ATOM   1698  C   THR    74      48.387  35.863  42.044  1.00 51.44           C  
ATOM   1699  O   THR    74      47.943  35.871  43.196  1.00 51.74           O  
ATOM   1700  CB  THR    74      50.775  35.105  42.101  1.00 52.41           C  
ATOM   1701  N   GLU    75      48.058  36.784  41.135  1.00 49.36           N  
ATOM   1702  CA  GLU    75      47.214  37.939  41.455  1.00 47.02           C  
ATOM   1703  C   GLU    75      45.759  37.533  41.711  1.00 45.84           C  
ATOM   1704  O   GLU    75      45.231  36.654  41.029  1.00 46.17           O  
ATOM   1705  CB  GLU    75      47.283  38.962  40.312  1.00 46.52           C  
ATOM   1706  CG  GLU    75      46.513  40.248  40.573  1.00 44.62           C  
ATOM   1707  CD  GLU    75      47.058  41.016  41.759  1.00 42.04           C  
ATOM   1708  OE1 GLU    75      48.292  41.233  41.800  1.00 33.54           O  
ATOM   1709  OE2 GLU    75      46.253  41.402  42.637  1.00 35.78           O  
ATOM   1710  N   THR    76      45.133  38.178  42.697  1.00 44.18           N  
ATOM   1711  CA  THR    76      43.737  37.915  43.069  1.00 42.84           C  
ATOM   1712  C   THR    76      42.803  39.105  42.845  1.00 41.12           C  
ATOM   1713  O   THR    76      41.591  38.923  42.736  1.00 41.75           O  
ATOM   1714  CB  THR    76      43.627  37.523  44.548  1.00 43.10           C  
ATOM   1715  OG1 THR    76      44.363  38.464  45.345  1.00 44.47           O  
ATOM   1716  CG2 THR    76      44.167  36.111  44.770  1.00 43.34           C  
ATOM   1717  N   ASP    77      43.351  40.318  42.805  1.00 38.64           N  
ATOM   1718  CA  ASP    77      42.547  41.494  42.522  1.00 36.40           C  
ATOM   1719  C   ASP    77      42.053  41.379  41.091  1.00 34.51           C  
ATOM   1720  O   ASP    77      42.855  41.330  40.155  1.00 32.72           O  
ATOM   1721  CB  ASP    77      43.351  42.785  42.726  1.00 36.29           C  
ATOM   1722  CG  ASP    77      42.471  44.032  42.705  1.00 36.98           C  
ATOM   1723  OD1 ASP    77      41.907  44.355  41.639  1.00 32.41           O  
ATOM   1724  OD2 ASP    77      42.349  44.695  43.757  1.00 42.30           O  
ATOM   1725  N   LEU    78      40.728  41.321  40.945  1.00 33.17           N  
ATOM   1726  CA  LEU    78      40.084  41.188  39.644  1.00 31.83           C  
ATOM   1727  C   LEU    78      40.447  42.312  38.690  1.00 30.92           C  
ATOM   1728  O   LEU    78      40.630  42.063  37.501  1.00 30.51           O  
ATOM   1729  CB  LEU    78      38.554  41.136  39.777  1.00 31.06           C  
ATOM   1730  CG  LEU    78      37.884  39.831  40.213  1.00 30.15           C  
ATOM   1731  CD1 LEU    78      36.382  39.991  40.079  1.00 28.75           C  
ATOM   1732  CD2 LEU    78      38.360  38.634  39.408  1.00 26.53           C  
ATOM   1733  N   ASN    79      40.528  43.540  39.205  1.00 31.00           N  
ATOM   1734  CA  ASN    79      40.795  44.709  38.361  1.00 31.40           C  
ATOM   1735  C   ASN    79      42.207  44.677  37.806  1.00 30.64           C  
ATOM   1736  O   ASN    79      42.430  45.047  36.659  1.00 32.32           O  
ATOM   1737  CB  ASN    79      40.519  46.014  39.113  1.00 30.97           C  
ATOM   1738  CG  ASN    79      39.047  46.191  39.445  1.00 32.77           C  
ATOM   1739  OD1 ASN    79      38.169  45.793  38.669  1.00 34.47           O  
ATOM   1740  ND2 ASN    79      38.767  46.792  40.597  1.00 31.40           N  
ATOM   1741  N   VAL    80      43.145  44.198  38.613  1.00 30.86           N  
ATOM   1742  CA  VAL    80      44.527  43.995  38.176  1.00 30.48           C  
ATOM   1743  C   VAL    80      44.626  42.802  37.208  1.00 30.68           C  
ATOM   1744  O   VAL    80      45.369  42.850  36.230  1.00 32.36           O  
ATOM   1745  CB  VAL    80      45.453  43.767  39.378  1.00 30.21           C  
ATOM   1746  CG1 VAL    80      46.886  43.546  38.914  1.00 28.13           C  
ATOM   1747  CG2 VAL    80      45.352  44.942  40.345  1.00 27.39           C  
ATOM   1748  N   LEU    81      43.884  41.731  37.480  1.00 30.58           N  
ATOM   1749  CA  LEU    81      43.817  40.603  36.546  1.00 30.81           C  
ATOM   1750  C   LEU    81      43.247  41.057  35.200  1.00 30.95           C  
ATOM   1751  O   LEU    81      43.794  40.737  34.148  1.00 31.51           O  
ATOM   1752  CB  LEU    81      42.979  39.451  37.110  1.00 30.49           C  
ATOM   1753  CG  LEU    81      43.664  38.568  38.154  1.00 32.45           C  
ATOM   1754  CD1 LEU    81      42.657  37.683  38.888  1.00 28.60           C  
ATOM   1755  CD2 LEU    81      44.748  37.729  37.503  1.00 32.31           C  
ATOM   1756  N   ALA    82      42.162  41.827  35.243  1.00 31.30           N  
ATOM   1757  CA  ALA    82      41.511  42.328  34.029  1.00 29.87           C  
ATOM   1758  C   ALA    82      42.455  43.178  33.184  1.00 29.55           C  
ATOM   1759  O   ALA    82      42.555  42.976  31.975  1.00 29.00           O  
ATOM   1760  CB  ALA    82      40.252  43.108  34.382  1.00 27.98           C  
ATOM   1761  N   LYS    83      43.145  44.114  33.827  1.00 30.62           N  
ATOM   1762  CA  LYS    83      44.095  45.003  33.147  1.00 32.82           C  
ATOM   1763  C   LYS    83      45.278  44.247  32.545  1.00 31.38           C  
ATOM   1764  O   LYS    83      45.603  44.429  31.383  1.00 31.61           O  
ATOM   1765  CB  LYS    83      44.612  46.060  34.122  1.00 33.23           C  
ATOM   1766  CG  LYS    83      45.524  47.089  33.488  1.00 35.47           C  
ATOM   1767  CD  LYS    83      45.840  48.216  34.451  1.00 36.43           C  
ATOM   1768  CE  LYS    83      46.837  49.196  33.841  1.00 42.15           C  
ATOM   1769  NZ  LYS    83      47.235  50.260  34.808  1.00 48.16           N  
ATOM   1770  N   THR    84      45.915  43.410  33.352  1.00 31.31           N  
ATOM   1771  CA  THR    84      47.066  42.615  32.918  1.00 31.31           C  
ATOM   1772  C   THR    84      46.767  41.681  31.742  1.00 30.31           C  
ATOM   1773  O   THR    84      47.511  41.650  30.762  1.00 29.48           O  
ATOM   1774  CB  THR    84      47.595  41.795  34.095  1.00 30.96           C  
ATOM   1775  OG1 THR    84      48.174  42.693  35.047  1.00 32.33           O  
ATOM   1776  CG2 THR    84      48.648  40.779  33.637  1.00 34.24           C  
ATOM   1777  N   TYR    85      45.676  40.927  31.847  1.00 30.38           N  
ATOM   1778  CA  TYR    85      45.284  39.982  30.797  1.00 30.35           C  
ATOM   1779  C   TYR    85      44.820  40.665  29.510  1.00 29.76           C  
ATOM   1780  O   TYR    85      44.976  40.115  28.423  1.00 29.50           O  
ATOM   1781  CB  TYR    85      44.195  39.038  31.306  1.00 31.62           C  
ATOM   1782  CG  TYR    85      44.726  37.797  31.993  1.00 31.20           C  
ATOM   1783  CD1 TYR    85      45.237  36.746  31.245  1.00 32.21           C  
ATOM   1784  CD2 TYR    85      44.680  37.656  33.381  1.00 32.86           C  
ATOM   1785  CE1 TYR    85      45.701  35.590  31.850  1.00 32.84           C  
ATOM   1786  CE2 TYR    85      45.147  36.493  34.003  1.00 32.36           C  
ATOM   1787  CZ  TYR    85      45.657  35.467  33.229  1.00 33.24           C  
ATOM   1788  OH  TYR    85      46.137  34.309  33.811  1.00 34.89           O  
ATOM   1789  N   THR    86      44.235  41.848  29.638  1.00 31.05           N  
ATOM   1790  CA  THR    86      43.815  42.641  28.486  1.00 31.05           C  
ATOM   1791  C   THR    86      45.045  43.122  27.733  1.00 32.15           C  
ATOM   1792  O   THR    86      45.109  42.994  26.512  1.00 32.75           O  
ATOM   1793  CB  THR    86      42.918  43.820  28.928  1.00 30.81           C  
ATOM   1794  OG1 THR    86      41.726  43.284  29.508  1.00 29.76           O  
ATOM   1795  CG2 THR    86      42.532  44.732  27.760  1.00 26.40           C  
ATOM   1796  N   GLU    87      46.025  43.652  28.471  1.00 32.42           N  
ATOM   1797  CA  GLU    87      47.300  44.084  27.899  1.00 33.13           C  
ATOM   1798  C   GLU    87      48.047  42.928  27.211  1.00 31.43           C  
ATOM   1799  O   GLU    87      48.576  43.091  26.114  1.00 30.84           O  
ATOM   1800  CB  GLU    87      48.193  44.737  28.977  1.00 33.57           C  
ATOM   1801  CG  GLU    87      47.674  46.098  29.487  1.00 36.24           C  
ATOM   1802  CD  GLU    87      48.430  46.649  30.705  1.00 36.39           C  
ATOM   1803  OE1 GLU    87      49.213  45.898  31.339  1.00 42.87           O  
ATOM   1804  OE2 GLU    87      48.224  47.844  31.039  1.00 41.68           O  
ATOM   1805  N   LYS    88      48.086  41.769  27.857  1.00 30.05           N  
ATOM   1806  CA  LYS    88      48.724  40.586  27.275  1.00 31.07           C  
ATOM   1807  C   LYS    88      48.015  40.085  26.007  1.00 29.92           C  
ATOM   1808  O   LYS    88      48.669  39.628  25.061  1.00 30.19           O  
ATOM   1809  CB  LYS    88      48.768  39.444  28.295  1.00 31.28           C  
ATOM   1810  CG  LYS    88      49.807  39.588  29.405  1.00 32.74           C  
ATOM   1811  CD  LYS    88      49.487  38.619  30.542  1.00 34.44           C  
ATOM   1812  CE  LYS    88      50.726  38.125  31.283  1.00 39.86           C  
ATOM   1813  NZ  LYS    88      51.268  39.116  32.264  1.00 38.26           N  
ATOM   1814  N   THR    89      46.686  40.150  26.003  1.00 28.30           N  
ATOM   1815  CA  THR    89      45.907  39.659  24.876  1.00 26.91           C  
ATOM   1816  C   THR    89      45.994  40.627  23.697  1.00 26.04           C  
ATOM   1817  O   THR    89      46.155  40.197  22.563  1.00 25.57           O  
ATOM   1818  CB  THR    89      44.432  39.370  25.276  1.00 26.83           C  
ATOM   1819  OG1 THR    89      44.402  38.387  26.321  1.00 26.62           O  
ATOM   1820  CG2 THR    89      43.649  38.837  24.091  1.00 21.94           C  
ATOM   1821  N   VAL    90      45.916  41.928  23.970  1.00 25.73           N  
ATOM   1822  CA  VAL    90      46.100  42.954  22.935  1.00 24.97           C  
ATOM   1823  C   VAL    90      47.491  42.846  22.274  1.00 25.21           C  
ATOM   1824  O   VAL    90      47.625  42.875  21.044  1.00 24.21           O  
ATOM   1825  CB  VAL    90      45.922  44.368  23.530  1.00 26.15           C  
ATOM   1826  CG1 VAL    90      46.342  45.465  22.513  1.00 25.78           C  
ATOM   1827  CG2 VAL    90      44.477  44.564  24.014  1.00 24.53           C  
ATOM   1828  N   ALA    91      48.522  42.690  23.092  1.00 24.60           N  
ATOM   1829  CA  ALA    91      49.883  42.534  22.583  1.00 25.64           C  
ATOM   1830  C   ALA    91      49.993  41.348  21.616  1.00 27.64           C  
ATOM   1831  O   ALA    91      50.684  41.436  20.600  1.00 29.22           O  
ATOM   1832  CB  ALA    91      50.884  42.412  23.746  1.00 24.73           C  
ATOM   1833  N   ILE    92      49.284  40.255  21.896  1.00 29.04           N  
ATOM   1834  CA  ILE    92      49.251  39.131  20.956  1.00 29.11           C  
ATOM   1835  C   ILE    92      48.443  39.481  19.694  1.00 30.76           C  
ATOM   1836  O   ILE    92      48.935  39.307  18.568  1.00 31.05           O  
ATOM   1837  CB  ILE    92      48.682  37.846  21.579  1.00 29.24           C  
ATOM   1838  CG1 ILE    92      49.595  37.340  22.711  1.00 30.86           C  
ATOM   1839  CG2 ILE    92      48.552  36.775  20.506  1.00 23.58           C  
ATOM   1840  CD1 ILE    92      49.028  36.148  23.491  1.00 28.37           C  
ATOM   1841  N   LEU    93      47.221  39.983  19.890  1.00 30.68           N  
ATOM   1842  CA  LEU    93      46.329  40.312  18.782  1.00 31.19           C  
ATOM   1843  C   LEU    93      46.942  41.317  17.798  1.00 33.19           C  
ATOM   1844  O   LEU    93      46.804  41.152  16.584  1.00 32.19           O  
ATOM   1845  CB  LEU    93      44.981  40.836  19.305  1.00 30.38           C  
ATOM   1846  CG  LEU    93      44.072  39.867  20.066  1.00 28.57           C  
ATOM   1847  CD1 LEU    93      42.719  40.515  20.315  1.00 27.89           C  
ATOM   1848  CD2 LEU    93      43.904  38.560  19.325  1.00 24.19           C  
ATOM   1849  N   GLU    94      47.626  42.337  18.330  1.00 35.21           N  
ATOM   1850  CA  GLU    94      48.307  43.369  17.523  1.00 37.43           C  
ATOM   1851  C   GLU    94      49.279  42.824  16.477  1.00 38.02           C  
ATOM   1852  O   GLU    94      49.540  43.469  15.471  1.00 39.24           O  
ATOM   1853  CB  GLU    94      49.157  44.276  18.417  1.00 37.45           C  
ATOM   1854  CG  GLU    94      48.437  45.346  19.215  1.00 39.62           C  
ATOM   1855  CD  GLU    94      49.393  46.060  20.179  1.00 40.91           C  
ATOM   1856  OE1 GLU    94      50.569  45.626  20.285  1.00 44.33           O  
ATOM   1857  OE2 GLU    94      48.981  47.052  20.823  1.00 44.87           O  
ATOM   1858  N   GLN    95      49.868  41.672  16.757  1.00 38.62           N  
ATOM   1859  CA  GLN    95      50.925  41.131  15.921  1.00 39.16           C  
ATOM   1860  C   GLN    95      50.427  40.055  14.970  1.00 39.45           C  
ATOM   1861  O   GLN    95      51.135  39.700  14.038  1.00 40.62           O  
ATOM   1862  CB  GLN    95      52.020  40.554  16.816  1.00 40.08           C  
ATOM   1863  CG  GLN    95      52.579  41.550  17.832  1.00 42.36           C  
ATOM   1864  CD  GLN    95      53.520  42.551  17.202  1.00 46.73           C  
ATOM   1865  OE1 GLN    95      53.167  43.716  16.994  1.00 45.61           O  
ATOM   1866  NE2 GLN    95      54.729  42.096  16.877  1.00 50.68           N  
ATOM   1867  N   LEU    96      49.215  39.540  15.194  1.00 39.81           N  
ATOM   1868  CA  LEU    96      48.690  38.454  14.376  1.00 39.64           C  
ATOM   1869  C   LEU    96      48.600  38.845  12.906  1.00 40.14           C  
ATOM   1870  O   LEU    96      47.997  39.860  12.560  1.00 41.09           O  
ATOM   1871  CB  LEU    96      47.323  37.991  14.884  1.00 40.07           C  
ATOM   1872  CG  LEU    96      47.325  37.192  16.188  1.00 36.48           C  
ATOM   1873  CD1 LEU    96      45.897  36.863  16.590  1.00 34.41           C  
ATOM   1874  CD2 LEU    96      48.160  35.932  16.053  1.00 34.32           C  
ATOM   1875  N   THR    97      49.214  38.020  12.060  1.00 40.77           N  
ATOM   1876  CA  THR    97      49.279  38.234  10.615  1.00 40.51           C  
ATOM   1877  C   THR    97      48.149  37.480   9.901  1.00 40.99           C  
ATOM   1878  O   THR    97      47.577  36.530  10.442  1.00 40.42           O  
ATOM   1879  CB  THR    97      50.644  37.755  10.051  1.00 40.10           C  
ATOM   1880  OG1 THR    97      50.761  36.336  10.198  1.00 40.62           O  
ATOM   1881  CG2 THR    97      51.796  38.419  10.788  1.00 38.60           C  
ATOM   1882  N   GLU    98      47.826  37.916   8.688  1.00 41.70           N  
ATOM   1883  CA  GLU    98      46.781  37.269   7.889  1.00 42.96           C  
ATOM   1884  C   GLU    98      47.103  35.792   7.645  1.00 42.45           C  
ATOM   1885  O   GLU    98      46.204  34.969   7.536  1.00 42.13           O  
ATOM   1886  CB  GLU    98      46.577  38.023   6.565  1.00 43.80           C  
ATOM   1887  CG  GLU    98      45.735  39.297   6.722  1.00 46.73           C  
ATOM   1888  CD  GLU    98      44.267  38.992   6.996  1.00 51.55           C  
ATOM   1889  OE1 GLU    98      43.648  38.291   6.166  1.00 53.83           O  
ATOM   1890  OE2 GLU    98      43.731  39.443   8.037  1.00 53.34           O  
ATOM   1891  N   GLU    99      48.396  35.478   7.588  1.00 42.79           N  
ATOM   1892  CA  GLU    99      48.895  34.105   7.480  1.00 43.72           C  
ATOM   1893  C   GLU    99      48.494  33.277   8.694  1.00 41.44           C  
ATOM   1894  O   GLU    99      48.041  32.136   8.555  1.00 40.91           O  
ATOM   1895  CB  GLU    99      50.427  34.128   7.368  1.00 44.27           C  
ATOM   1896  CG  GLU    99      51.118  32.763   7.344  1.00 47.94           C  
ATOM   1897  CD  GLU    99      52.606  32.854   7.693  1.00 48.92           C  
ATOM   1898  OE1 GLU    99      52.937  33.477   8.732  1.00 61.99           O  
ATOM   1899  OE2 GLU    99      53.440  32.296   6.939  1.00 52.94           O  
ATOM   1900  N   GLN   100      48.693  33.847   9.883  1.00 39.56           N  
ATOM   1901  CA  GLN   100      48.308  33.198  11.140  1.00 37.57           C  
ATOM   1902  C   GLN   100      46.789  33.034  11.271  1.00 35.88           C  
ATOM   1903  O   GLN   100      46.315  32.075  11.865  1.00 34.56           O  
ATOM   1904  CB  GLN   100      48.865  33.972  12.335  1.00 37.95           C  
ATOM   1905  CG  GLN   100      50.361  33.753  12.560  1.00 35.36           C  
ATOM   1906  CD  GLN   100      50.928  34.653  13.650  1.00 37.02           C  
ATOM   1907  OE1 GLN   100      50.688  35.861  13.655  1.00 35.51           O  
ATOM   1908  NE2 GLN   100      51.688  34.064  14.577  1.00 28.77           N  
ATOM   1909  N   LEU   101      46.041  33.973  10.700  1.00 36.17           N  
ATOM   1910  CA  LEU   101      44.583  33.911  10.672  1.00 36.04           C  
ATOM   1911  C   LEU   101      44.073  32.913   9.633  1.00 37.42           C  
ATOM   1912  O   LEU   101      43.082  32.221   9.870  1.00 38.35           O  
ATOM   1913  CB  LEU   101      44.009  35.305  10.394  1.00 35.43           C  
ATOM   1914  CG  LEU   101      44.231  36.320  11.524  1.00 34.17           C  
ATOM   1915  CD1 LEU   101      44.014  37.731  11.053  1.00 35.54           C  
ATOM   1916  CD2 LEU   101      43.314  36.006  12.707  1.00 29.97           C  
ATOM   1917  N   ASP   102      44.753  32.842   8.488  1.00 38.87           N  
ATOM   1918  CA  ASP   102      44.334  31.980   7.378  1.00 39.41           C  
ATOM   1919  C   ASP   102      44.687  30.510   7.582  1.00 39.52           C  
ATOM   1920  O   ASP   102      43.960  29.630   7.119  1.00 40.06           O  
ATOM   1921  CB  ASP   102      44.945  32.476   6.060  1.00 40.18           C  
ATOM   1922  CG  ASP   102      44.274  33.742   5.538  1.00 41.84           C  
ATOM   1923  OD1 ASP   102      43.098  33.969   5.877  1.00 44.15           O  
ATOM   1924  OD2 ASP   102      44.916  34.501   4.776  1.00 44.89           O  
ATOM   1925  N   ARG   103      45.780  30.242   8.288  1.00 39.77           N  
ATOM   1926  CA  ARG   103      46.285  28.875   8.425  1.00 40.80           C  
ATOM   1927  C   ARG   103      45.443  27.996   9.334  1.00 41.55           C  
ATOM   1928  O   ARG   103      44.794  28.468  10.260  1.00 41.57           O  
ATOM   1929  CB  ARG   103      47.731  28.872   8.931  1.00 40.90           C  
ATOM   1930  CG  ARG   103      47.888  29.243  10.392  1.00 42.29           C  
ATOM   1931  CD  ARG   103      49.339  29.471  10.724  1.00 44.86           C  
ATOM   1932  NE  ARG   103      49.550  29.752  12.139  1.00 45.75           N  
ATOM   1933  CZ  ARG   103      50.715  30.125  12.661  1.00 47.88           C  
ATOM   1934  NH1 ARG   103      51.797  30.276  11.895  1.00 46.92           N  
ATOM   1935  NH2 ARG   103      50.802  30.357  13.962  1.00 48.77           N  
ATOM   1936  N   GLU   104      45.500  26.700   9.059  1.00 42.30           N  
ATOM   1937  CA  GLU   104      44.841  25.683   9.859  1.00 42.85           C  
ATOM   1938  C   GLU   104      45.654  25.353  11.112  1.00 41.15           C  
ATOM   1939  O   GLU   104      46.859  25.119  11.035  1.00 40.82           O  
ATOM   1940  CB  GLU   104      44.662  24.412   9.025  1.00 43.55           C  
ATOM   1941  CG  GLU   104      43.506  23.559   9.459  1.00 48.29           C  
ATOM   1942  CD  GLU   104      42.933  22.766   8.320  1.00 54.58           C  
ATOM   1943  OE1 GLU   104      43.648  21.883   7.807  1.00 57.58           O  
ATOM   1944  OE2 GLU   104      41.772  23.036   7.941  1.00 58.33           O  
ATOM   1945  N   ILE   105      44.980  25.348  12.258  1.00 40.26           N  
ATOM   1946  CA  ILE   105      45.561  24.903  13.517  1.00 39.85           C  
ATOM   1947  C   ILE   105      45.102  23.459  13.741  1.00 40.87           C  
ATOM   1948  O   ILE   105      43.896  23.195  13.806  1.00 38.41           O  
ATOM   1949  CB  ILE   105      45.100  25.787  14.698  1.00 39.56           C  
ATOM   1950  CG1 ILE   105      45.389  27.263  14.410  1.00 41.36           C  
ATOM   1951  CG2 ILE   105      45.783  25.371  15.987  1.00 36.65           C  
ATOM   1952  CD1 ILE   105      44.838  28.207  15.451  1.00 38.91           C  
ATOM   1953  N   ASP   106      46.055  22.530  13.838  1.00 43.16           N  
ATOM   1954  CA  ASP   106      45.735  21.110  14.079  1.00 45.33           C  
ATOM   1955  C   ASP   106      45.508  20.819  15.575  1.00 46.30           C  
ATOM   1956  O   ASP   106      46.472  20.721  16.343  1.00 47.07           O  
ATOM   1957  CB  ASP   106      46.851  20.206  13.529  1.00 45.75           C  
ATOM   1958  CG  ASP   106      46.547  18.715  13.689  1.00 48.90           C  
ATOM   1959  OD1 ASP   106      45.436  18.361  14.159  1.00 54.25           O  
ATOM   1960  OD2 ASP   106      47.426  17.896  13.340  1.00 48.22           O  
ATOM   1961  N   LEU   107      44.242  20.665  15.974  1.00 47.64           N  
ATOM   1962  CA  LEU   107      43.881  20.387  17.375  1.00 48.79           C  
ATOM   1963  C   LEU   107      43.225  19.004  17.581  1.00 49.78           C  
ATOM   1964  O   LEU   107      42.345  18.605  16.814  1.00 51.17           O  
ATOM   1965  CB  LEU   107      42.946  21.482  17.904  1.00 48.93           C  
ATOM   1966  CG  LEU   107      43.479  22.915  17.843  1.00 48.72           C  
ATOM   1967  CD1 LEU   107      42.485  23.893  18.457  1.00 47.04           C  
ATOM   1968  CD2 LEU   107      44.823  23.024  18.539  1.00 50.50           C  
ATOM   1969  N   THR   108      43.654  18.293  18.630  1.00 49.87           N  
ATOM   1970  CA  THR   108      43.136  16.954  18.974  1.00 48.10           C  
ATOM   1971  C   THR   108      41.608  16.879  18.933  1.00 48.72           C  
ATOM   1972  O   THR   108      41.034  16.018  18.261  1.00 48.58           O  
ATOM   1973  CB  THR   108      43.602  16.500  20.395  1.00 48.19           C  
ATOM   1974  OG1 THR   108      43.218  17.476  21.378  1.00 40.35           O  
ATOM   1975  CG2 THR   108      45.114  16.291  20.439  1.00 45.16           C  
ATOM   1976  N   LYS   114      40.560  20.285  13.549  1.00 48.83           N  
ATOM   1977  CA  LYS   114      41.339  21.284  12.829  1.00 47.35           C  
ATOM   1978  C   LYS   114      40.493  22.541  12.660  1.00 45.69           C  
ATOM   1979  O   LYS   114      39.291  22.459  12.389  1.00 45.34           O  
ATOM   1980  CB  LYS   114      41.802  20.739  11.475  1.00 46.66           C  
ATOM   1981  N   VAL   115      41.122  23.699  12.841  1.00 42.98           N  
ATOM   1982  CA  VAL   115      40.424  24.983  12.796  1.00 40.69           C  
ATOM   1983  C   VAL   115      41.403  26.064  12.356  1.00 37.96           C  
ATOM   1984  O   VAL   115      42.580  26.010  12.700  1.00 37.13           O  
ATOM   1985  CB  VAL   115      39.827  25.330  14.188  1.00 41.29           C  
ATOM   1986  CG1 VAL   115      40.938  25.423  15.230  1.00 41.11           C  
ATOM   1987  CG2 VAL   115      39.014  26.625  14.141  1.00 41.31           C  
ATOM   1988  N   THR   116      40.924  27.018  11.565  1.00 35.83           N  
ATOM   1989  CA  THR   116      41.747  28.147  11.129  1.00 34.25           C  
ATOM   1990  C   THR   116      41.888  29.156  12.249  1.00 34.16           C  
ATOM   1991  O   THR   116      40.982  29.294  13.064  1.00 34.64           O  
ATOM   1992  CB  THR   116      41.095  28.887   9.978  1.00 34.35           C  
ATOM   1993  OG1 THR   116      39.768  29.268  10.376  1.00 33.55           O  
ATOM   1994  CG2 THR   116      41.045  28.007   8.736  1.00 26.14           C  
ATOM   1995  N   GLY   117      43.000  29.883  12.275  1.00 33.53           N  
ATOM   1996  CA  GLY   117      43.191  30.940  13.265  1.00 32.87           C  
ATOM   1997  C   GLY   117      41.993  31.880  13.316  1.00 32.75           C  
ATOM   1998  O   GLY   117      41.549  32.261  14.400  1.00 32.20           O  
ATOM   1999  N   ARG   118      41.468  32.232  12.139  1.00 33.22           N  
ATOM   2000  CA  ARG   118      40.315  33.129  12.006  1.00 34.94           C  
ATOM   2001  C   ARG   118      39.071  32.565  12.685  1.00 33.27           C  
ATOM   2002  O   ARG   118      38.391  33.268  13.432  1.00 34.97           O  
ATOM   2003  CB  ARG   118      40.008  33.398  10.528  1.00 34.63           C  
ATOM   2004  CG  ARG   118      39.075  34.578  10.287  1.00 38.04           C  
ATOM   2005  CD  ARG   118      38.912  34.917   8.796  1.00 41.22           C  
ATOM   2006  NE  ARG   118      40.200  35.077   8.112  1.00 48.85           N  
ATOM   2007  CZ  ARG   118      41.000  36.138   8.220  1.00 48.59           C  
ATOM   2008  NH1 ARG   118      40.677  37.176   8.988  1.00 49.41           N  
ATOM   2009  NH2 ARG   118      42.145  36.158   7.557  1.00 48.99           N  
ATOM   2010  N   ALA   119      38.770  31.298  12.427  1.00 30.92           N  
ATOM   2011  CA  ALA   119      37.577  30.682  12.994  1.00 29.20           C  
ATOM   2012  C   ALA   119      37.694  30.522  14.527  1.00 28.24           C  
ATOM   2013  O   ALA   119      36.694  30.620  15.245  1.00 27.02           O  
ATOM   2014  CB  ALA   119      37.300  29.361  12.328  1.00 29.59           C  
ATOM   2015  N   LEU   120      38.907  30.297  15.027  1.00 26.93           N  
ATOM   2016  CA  LEU   120      39.125  30.231  16.467  1.00 28.00           C  
ATOM   2017  C   LEU   120      39.018  31.640  17.102  1.00 27.86           C  
ATOM   2018  O   LEU   120      38.633  31.771  18.257  1.00 27.73           O  
ATOM   2019  CB  LEU   120      40.488  29.602  16.779  1.00 29.16           C  
ATOM   2020  CG  LEU   120      40.699  29.065  18.198  1.00 29.75           C  
ATOM   2021  CD1 LEU   120      39.857  27.808  18.433  1.00 35.18           C  
ATOM   2022  CD2 LEU   120      42.165  28.759  18.433  1.00 29.74           C  
ATOM   2023  N   LEU   121      39.359  32.683  16.346  1.00 28.09           N  
ATOM   2024  CA  LEU   121      39.228  34.057  16.832  1.00 27.44           C  
ATOM   2025  C   LEU   121      37.750  34.434  17.007  1.00 28.11           C  
ATOM   2026  O   LEU   121      37.378  35.044  18.004  1.00 28.73           O  
ATOM   2027  CB  LEU   121      39.920  35.041  15.889  1.00 26.16           C  
ATOM   2028  CG  LEU   121      39.829  36.523  16.266  1.00 27.90           C  
ATOM   2029  CD1 LEU   121      40.567  36.780  17.561  1.00 23.80           C  
ATOM   2030  CD2 LEU   121      40.358  37.411  15.134  1.00 27.70           C  
ATOM   2031  N   GLN   122      36.917  34.057  16.039  1.00 28.54           N  
ATOM   2032  CA  GLN   122      35.481  34.314  16.107  1.00 30.48           C  
ATOM   2033  C   GLN   122      34.866  33.560  17.293  1.00 30.29           C  
ATOM   2034  O   GLN   122      33.977  34.061  17.983  1.00 30.33           O  
ATOM   2035  CB  GLN   122      34.788  33.907  14.790  1.00 30.73           C  
ATOM   2036  CG  GLN   122      33.269  33.730  14.930  1.00 34.32           C  
ATOM   2037  CD  GLN   122      32.527  33.691  13.616  1.00 33.25           C  
ATOM   2038  OE1 GLN   122      32.635  34.605  12.807  1.00 42.39           O  
ATOM   2039  NE2 GLN   122      31.721  32.648  13.419  1.00 35.24           N  
ATOM   2040  N   LEU   123      35.343  32.341  17.495  1.00 29.79           N  
ATOM   2041  CA  LEU   123      34.918  31.500  18.594  1.00 30.76           C  
ATOM   2042  C   LEU   123      35.297  32.158  19.938  1.00 30.05           C  
ATOM   2043  O   LEU   123      34.511  32.159  20.881  1.00 28.56           O  
ATOM   2044  CB  LEU   123      35.581  30.124  18.426  1.00 32.64           C  
ATOM   2045  CG  LEU   123      35.088  28.918  19.208  1.00 36.41           C  
ATOM   2046  CD1 LEU   123      35.493  27.647  18.473  1.00 37.74           C  
ATOM   2047  CD2 LEU   123      35.638  28.950  20.633  1.00 37.75           C  
ATOM   2048  N   ALA   124      36.509  32.710  20.008  1.00 29.00           N  
ATOM   2049  CA  ALA   124      36.979  33.433  21.183  1.00 27.92           C  
ATOM   2050  C   ALA   124      36.140  34.689  21.458  1.00 27.85           C  
ATOM   2051  O   ALA   124      35.857  35.030  22.619  1.00 27.75           O  
ATOM   2052  CB  ALA   124      38.437  33.815  20.996  1.00 27.52           C  
ATOM   2053  N   MET   125      35.737  35.368  20.384  1.00 26.51           N  
ATOM   2054  CA  MET   125      34.935  36.579  20.487  1.00 24.50           C  
ATOM   2055  C   MET   125      33.523  36.293  20.949  1.00 23.15           C  
ATOM   2056  O   MET   125      32.950  37.063  21.705  1.00 23.24           O  
ATOM   2057  CB  MET   125      34.872  37.308  19.138  1.00 23.98           C  
ATOM   2058  CG  MET   125      36.151  38.017  18.740  1.00 24.55           C  
ATOM   2059  SD  MET   125      36.568  39.523  19.855  0.75 19.69          SE  
ATOM   2060  CE  MET   125      34.822  40.421  19.829  1.00 27.99           C  
ATOM   2061  N   GLU   126      32.949  35.198  20.472  1.00 22.92           N  
ATOM   2062  CA  GLU   126      31.589  34.833  20.863  1.00 22.67           C  
ATOM   2063  C   GLU   126      31.542  34.327  22.296  1.00 23.28           C  
ATOM   2064  O   GLU   126      30.535  34.500  22.995  1.00 24.32           O  
ATOM   2065  CB  GLU   126      31.017  33.797  19.905  1.00 22.12           C  
ATOM   2066  CG  GLU   126      30.912  34.295  18.466  1.00 19.97           C  
ATOM   2067  CD  GLU   126      30.242  33.303  17.552  1.00 21.02           C  
ATOM   2068  OE1 GLU   126      29.901  32.187  18.004  1.00 25.67           O  
ATOM   2069  OE2 GLU   126      30.029  33.658  16.382  1.00 23.17           O  
ATOM   2070  N   HIS   127      32.637  33.714  22.727  1.00 24.65           N  
ATOM   2071  CA  HIS   127      32.783  33.226  24.099  1.00 25.24           C  
ATOM   2072  C   HIS   127      32.844  34.408  25.069  1.00 24.32           C  
ATOM   2073  O   HIS   127      32.184  34.415  26.118  1.00 24.41           O  
ATOM   2074  CB  HIS   127      34.050  32.389  24.183  1.00 26.17           C  
ATOM   2075  CG  HIS   127      34.235  31.687  25.484  1.00 31.32           C  
ATOM   2076  ND1 HIS   127      33.450  30.626  25.876  1.00 38.61           N  
ATOM   2077  CD2 HIS   127      35.141  31.872  26.470  1.00 36.97           C  
ATOM   2078  CE1 HIS   127      33.861  30.195  27.054  1.00 39.40           C  
ATOM   2079  NE2 HIS   127      34.881  30.938  27.438  1.00 37.60           N  
ATOM   2080  N   GLU   128      33.625  35.417  24.699  1.00 23.98           N  
ATOM   2081  CA  GLU   128      33.678  36.673  25.445  1.00 22.90           C  
ATOM   2082  C   GLU   128      32.285  37.287  25.550  1.00 21.15           C  
ATOM   2083  O   GLU   128      31.845  37.655  26.629  1.00 19.73           O  
ATOM   2084  CB  GLU   128      34.610  37.659  24.747  1.00 22.49           C  
ATOM   2085  CG  GLU   128      34.708  39.049  25.408  1.00 27.83           C  
ATOM   2086  CD  GLU   128      35.846  39.181  26.415  1.00 28.43           C  
ATOM   2087  OE1 GLU   128      36.726  38.301  26.447  1.00 27.93           O  
ATOM   2088  OE2 GLU   128      35.860  40.190  27.156  1.00 30.92           O  
ATOM   2089  N   ILE   129      31.613  37.390  24.410  1.00 20.76           N  
ATOM   2090  CA  ILE   129      30.320  38.058  24.320  1.00 20.58           C  
ATOM   2091  C   ILE   129      29.281  37.312  25.140  1.00 21.24           C  
ATOM   2092  O   ILE   129      28.513  37.931  25.863  1.00 23.67           O  
ATOM   2093  CB  ILE   129      29.858  38.233  22.840  1.00 19.95           C  
ATOM   2094  CG1 ILE   129      30.767  39.241  22.133  1.00 20.52           C  
ATOM   2095  CG2 ILE   129      28.411  38.718  22.786  1.00 19.35           C  
ATOM   2096  CD1 ILE   129      30.746  39.177  20.613  1.00 19.09           C  
ATOM   2097  N   HIS   130      29.288  35.985  25.048  1.00 21.33           N  
ATOM   2098  CA  HIS   130      28.430  35.139  25.878  1.00 19.82           C  
ATOM   2099  C   HIS   130      28.572  35.420  27.373  1.00 20.82           C  
ATOM   2100  O   HIS   130      27.583  35.721  28.048  1.00 20.66           O  
ATOM   2101  CB  HIS   130      28.727  33.658  25.615  1.00 18.93           C  
ATOM   2102  CG  HIS   130      28.027  32.732  26.553  1.00 15.45           C  
ATOM   2103  ND1 HIS   130      26.658  32.550  26.535  1.00 14.36           N  
ATOM   2104  CD2 HIS   130      28.503  31.936  27.536  1.00 13.49           C  
ATOM   2105  CE1 HIS   130      26.323  31.696  27.484  1.00 15.06           C  
ATOM   2106  NE2 HIS   130      27.423  31.317  28.111  1.00 16.03           N  
ATOM   2107  N   HIS   131      29.799  35.303  27.882  1.00 21.96           N  
ATOM   2108  CA  HIS   131      30.080  35.424  29.318  1.00 21.31           C  
ATOM   2109  C   HIS   131      29.957  36.868  29.852  1.00 22.10           C  
ATOM   2110  O   HIS   131      29.656  37.088  31.034  1.00 20.92           O  
ATOM   2111  CB  HIS   131      31.461  34.839  29.643  1.00 21.24           C  
ATOM   2112  CG  HIS   131      31.522  33.343  29.551  1.00 22.99           C  
ATOM   2113  ND1 HIS   131      30.750  32.516  30.340  1.00 25.40           N  
ATOM   2114  CD2 HIS   131      32.274  32.525  28.776  1.00 23.84           C  
ATOM   2115  CE1 HIS   131      31.012  31.255  30.044  1.00 25.83           C  
ATOM   2116  NE2 HIS   131      31.936  31.233  29.101  1.00 26.08           N  
ATOM   2117  N   LYS   132      30.195  37.854  28.993  1.00 23.34           N  
ATOM   2118  CA  LYS   132      29.890  39.237  29.349  1.00 23.59           C  
ATOM   2119  C   LYS   132      28.368  39.353  29.502  1.00 24.59           C  
ATOM   2120  O   LYS   132      27.883  40.077  30.374  1.00 25.72           O  
ATOM   2121  CB  LYS   132      30.450  40.221  28.303  1.00 24.16           C  
ATOM   2122  CG  LYS   132      29.937  41.660  28.425  1.00 22.60           C  
ATOM   2123  CD  LYS   132      30.819  42.673  27.685  1.00 23.82           C  
ATOM   2124  CE  LYS   132      31.003  42.367  26.192  1.00 26.25           C  
ATOM   2125  NZ  LYS   132      29.783  42.581  25.373  1.00 19.16           N  
ATOM   2126  N   GLY   133      27.625  38.625  28.666  1.00 24.94           N  
ATOM   2127  CA  GLY   133      26.167  38.535  28.785  1.00 23.57           C  
ATOM   2128  C   GLY   133      25.738  37.992  30.140  1.00 24.46           C  
ATOM   2129  O   GLY   133      24.797  38.507  30.745  1.00 25.42           O  
ATOM   2130  N   ASN   134      26.421  36.946  30.616  1.00 24.53           N  
ATOM   2131  CA  ASN   134      26.212  36.447  31.981  1.00 23.49           C  
ATOM   2132  C   ASN   134      26.525  37.544  32.981  1.00 23.55           C  
ATOM   2133  O   ASN   134      25.752  37.789  33.899  1.00 23.87           O  
ATOM   2134  CB  ASN   134      27.137  35.279  32.349  1.00 24.25           C  
ATOM   2135  CG  ASN   134      27.000  34.066  31.443  1.00 22.64           C  
ATOM   2136  OD1 ASN   134      27.917  33.259  31.385  1.00 27.65           O  
ATOM   2137  ND2 ASN   134      25.884  33.927  30.755  1.00 22.69           N  
ATOM   2138  N   LEU   135      27.674  38.188  32.797  1.00 23.93           N  
ATOM   2139  CA  LEU   135      28.207  39.140  33.769  1.00 24.06           C  
ATOM   2140  C   LEU   135      27.286  40.331  34.014  1.00 24.23           C  
ATOM   2141  O   LEU   135      27.195  40.795  35.130  1.00 25.52           O  
ATOM   2142  CB  LEU   135      29.599  39.605  33.340  1.00 23.83           C  
ATOM   2143  CG  LEU   135      30.452  40.451  34.291  1.00 24.29           C  
ATOM   2144  CD1 LEU   135      30.640  39.807  35.676  1.00 20.22           C  
ATOM   2145  CD2 LEU   135      31.803  40.685  33.627  1.00 24.00           C  
ATOM   2146  N   PHE   136      26.617  40.814  32.967  1.00 24.58           N  
ATOM   2147  CA  PHE   136      25.647  41.896  33.073  1.00 24.76           C  
ATOM   2148  C   PHE   136      24.547  41.609  34.115  1.00 26.40           C  
ATOM   2149  O   PHE   136      24.153  42.502  34.871  1.00 24.96           O  
ATOM   2150  CB  PHE   136      24.994  42.160  31.714  1.00 25.02           C  
ATOM   2151  CG  PHE   136      25.603  43.297  30.961  1.00 25.69           C  
ATOM   2152  CD1 PHE   136      25.197  44.595  31.219  1.00 27.75           C  
ATOM   2153  CD2 PHE   136      26.590  43.077  29.998  1.00 23.95           C  
ATOM   2154  CE1 PHE   136      25.751  45.656  30.529  1.00 27.50           C  
ATOM   2155  CE2 PHE   136      27.150  44.126  29.303  1.00 22.33           C  
ATOM   2156  CZ  PHE   136      26.732  45.426  29.568  1.00 28.13           C  
ATOM   2157  N   VAL   137      24.049  40.374  34.143  1.00 26.43           N  
ATOM   2158  CA  VAL   137      23.008  40.004  35.098  1.00 25.49           C  
ATOM   2159  C   VAL   137      23.599  39.897  36.506  1.00 26.38           C  
ATOM   2160  O   VAL   137      22.977  40.346  37.462  1.00 27.33           O  
ATOM   2161  CB  VAL   137      22.254  38.714  34.667  1.00 26.90           C  
ATOM   2162  CG1 VAL   137      21.086  38.397  35.632  1.00 22.98           C  
ATOM   2163  CG2 VAL   137      21.726  38.861  33.238  1.00 21.37           C  
ATOM   2164  N   TYR   138      24.814  39.352  36.631  1.00 27.22           N  
ATOM   2165  CA  TYR   138      25.534  39.329  37.921  1.00 27.61           C  
ATOM   2166  C   TYR   138      25.601  40.731  38.527  1.00 28.62           C  
ATOM   2167  O   TYR   138      25.164  40.955  39.664  1.00 30.89           O  
ATOM   2168  CB  TYR   138      26.980  38.813  37.775  1.00 27.23           C  
ATOM   2169  CG  TYR   138      27.175  37.304  37.716  1.00 27.29           C  
ATOM   2170  CD1 TYR   138      26.675  36.558  36.664  1.00 26.10           C  
ATOM   2171  CD2 TYR   138      27.903  36.634  38.695  1.00 29.05           C  
ATOM   2172  CE1 TYR   138      26.872  35.177  36.590  1.00 24.62           C  
ATOM   2173  CE2 TYR   138      28.092  35.252  38.642  1.00 26.24           C  
ATOM   2174  CZ  TYR   138      27.577  34.534  37.582  1.00 26.62           C  
ATOM   2175  OH  TYR   138      27.771  33.174  37.491  1.00 27.21           O  
ATOM   2176  N   VAL   139      26.146  41.666  37.754  1.00 27.99           N  
ATOM   2177  CA  VAL   139      26.404  43.039  38.215  1.00 27.23           C  
ATOM   2178  C   VAL   139      25.129  43.810  38.552  1.00 27.92           C  
ATOM   2179  O   VAL   139      25.086  44.595  39.514  1.00 26.74           O  
ATOM   2180  CB  VAL   139      27.222  43.803  37.156  1.00 28.07           C  
ATOM   2181  CG1 VAL   139      27.307  45.289  37.484  1.00 28.06           C  
ATOM   2182  CG2 VAL   139      28.624  43.174  37.012  1.00 26.48           C  
ATOM   2183  N   ARG   140      24.099  43.592  37.744  1.00 29.05           N  
ATOM   2184  CA  ARG   140      22.773  44.168  37.964  1.00 31.02           C  
ATOM   2185  C   ARG   140      22.193  43.697  39.308  1.00 30.81           C  
ATOM   2186  O   ARG   140      21.591  44.480  40.046  1.00 30.77           O  
ATOM   2187  CB  ARG   140      21.863  43.745  36.804  1.00 32.60           C  
ATOM   2188  CG  ARG   140      20.404  44.195  36.878  1.00 40.15           C  
ATOM   2189  CD  ARG   140      20.154  45.498  36.168  1.00 42.74           C  
ATOM   2190  NE  ARG   140      20.623  45.454  34.785  1.00 44.57           N  
ATOM   2191  CZ  ARG   140      20.631  46.499  33.961  1.00 43.68           C  
ATOM   2192  NH1 ARG   140      20.180  47.690  34.364  1.00 42.68           N  
ATOM   2193  NH2 ARG   140      21.097  46.350  32.724  1.00 47.01           N  
ATOM   2194  N   GLU   141      22.378  42.412  39.606  1.00 31.43           N  
ATOM   2195  CA  GLU   141      21.960  41.809  40.885  1.00 30.94           C  
ATOM   2196  C   GLU   141      22.784  42.249  42.108  1.00 31.18           C  
ATOM   2197  O   GLU   141      22.380  42.019  43.250  1.00 30.01           O  
ATOM   2198  CB  GLU   141      21.989  40.281  40.789  1.00 31.38           C  
ATOM   2199  CG  GLU   141      20.789  39.711  40.078  1.00 29.43           C  
ATOM   2200  CD  GLU   141      20.871  38.218  39.838  1.00 29.00           C  
ATOM   2201  OE1 GLU   141      21.346  37.465  40.720  1.00 24.08           O  
ATOM   2202  OE2 GLU   141      20.434  37.798  38.751  1.00 24.21           O  
ATOM   2203  N   MET   142      23.935  42.872  41.866  1.00 31.32           N  
ATOM   2204  CA  MET   142      24.788  43.379  42.938  1.00 30.72           C  
ATOM   2205  C   MET   142      24.459  44.808  43.371  1.00 32.76           C  
ATOM   2206  O   MET   142      25.194  45.384  44.180  1.00 33.35           O  
ATOM   2207  CB  MET   142      26.247  43.366  42.498  1.00 30.80           C  
ATOM   2208  CG  MET   142      26.791  42.021  42.195  1.00 29.92           C  
ATOM   2209  SD  MET   142      28.615  42.104  41.579  0.75 23.20          SE  
ATOM   2210  CE  MET   142      28.655  43.665  40.756  1.00 18.45           C  
ATOM   2211  N   GLY   143      23.394  45.393  42.822  1.00 33.02           N  
ATOM   2212  CA  GLY   143      22.959  46.714  43.243  1.00 33.47           C  
ATOM   2213  C   GLY   143      23.214  47.819  42.232  1.00 34.81           C  
ATOM   2214  O   GLY   143      22.746  48.940  42.423  1.00 35.09           O  
ATOM   2215  N   HIS   144      23.943  47.516  41.159  1.00 35.68           N  
ATOM   2216  CA  HIS   144      24.277  48.516  40.138  1.00 36.43           C  
ATOM   2217  C   HIS   144      23.212  48.593  39.051  1.00 37.25           C  
ATOM   2218  O   HIS   144      22.838  47.584  38.459  1.00 36.10           O  
ATOM   2219  CB  HIS   144      25.643  48.218  39.538  1.00 36.53           C  
ATOM   2220  CG  HIS   144      26.725  48.147  40.564  1.00 36.63           C  
ATOM   2221  ND1 HIS   144      27.392  49.264  41.015  1.00 34.51           N  
ATOM   2222  CD2 HIS   144      27.217  47.101  41.267  1.00 41.34           C  
ATOM   2223  CE1 HIS   144      28.270  48.906  41.934  1.00 40.77           C  
ATOM   2224  NE2 HIS   144      28.181  47.599  42.111  1.00 42.86           N  
ATOM   2225  N   THR   145      22.720  49.802  38.808  1.00 39.71           N  
ATOM   2226  CA  THR   145      21.653  50.030  37.835  1.00 41.21           C  
ATOM   2227  C   THR   145      22.096  50.853  36.624  1.00 43.96           C  
ATOM   2228  O   THR   145      21.370  50.917  35.626  1.00 45.11           O  
ATOM   2229  CB  THR   145      20.451  50.766  38.477  1.00 40.95           C  
ATOM   2230  OG1 THR   145      20.784  52.148  38.677  1.00 36.83           O  
ATOM   2231  CG2 THR   145      20.050  50.122  39.813  1.00 38.96           C  
ATOM   2232  N   GLU   146      23.260  51.496  36.705  1.00 45.65           N  
ATOM   2233  CA  GLU   146      23.726  52.328  35.604  1.00 47.58           C  
ATOM   2234  C   GLU   146      24.886  51.616  34.924  1.00 46.33           C  
ATOM   2235  O   GLU   146      26.059  51.845  35.238  1.00 48.08           O  
ATOM   2236  CB  GLU   146      24.105  53.725  36.101  1.00 48.88           C  
ATOM   2237  CG  GLU   146      23.685  54.842  35.148  1.00 53.87           C  
ATOM   2238  CD  GLU   146      22.186  54.817  34.818  1.00 59.74           C  
ATOM   2239  OE1 GLU   146      21.360  54.933  35.753  1.00 62.56           O  
ATOM   2240  OE2 GLU   146      21.837  54.686  33.624  1.00 60.00           O  
ATOM   2241  N   LEU   147      24.535  50.731  33.998  1.00 43.13           N  
ATOM   2242  CA  LEU   147      25.511  49.860  33.355  1.00 40.71           C  
ATOM   2243  C   LEU   147      25.797  50.305  31.923  1.00 38.85           C  
ATOM   2244  O   LEU   147      24.917  50.848  31.242  1.00 37.87           O  
ATOM   2245  CB  LEU   147      25.016  48.411  33.365  1.00 40.10           C  
ATOM   2246  CG  LEU   147      24.740  47.799  34.743  1.00 39.60           C  
ATOM   2247  CD1 LEU   147      24.125  46.436  34.588  1.00 38.09           C  
ATOM   2248  CD2 LEU   147      26.011  47.720  35.575  1.00 37.18           C  
ATOM   2249  N   PRO   148      27.036  50.070  31.457  1.00 36.83           N  
ATOM   2250  CA  PRO   148      27.359  50.459  30.092  1.00 35.09           C  
ATOM   2251  C   PRO   148      26.522  49.694  29.079  1.00 32.85           C  
ATOM   2252  O   PRO   148      25.936  48.655  29.407  1.00 32.33           O  
ATOM   2253  CB  PRO   148      28.841  50.080  29.953  1.00 34.78           C  
ATOM   2254  CG  PRO   148      29.096  49.071  31.022  1.00 36.57           C  
ATOM   2255  CD  PRO   148      28.178  49.432  32.143  1.00 37.27           C  
ATOM   2256  N   PHE   149      26.440  50.234  27.871  1.00 30.90           N  
ATOM   2257  CA  PHE   149      25.923  49.487  26.742  1.00 29.22           C  
ATOM   2258  C   PHE   149      26.911  48.343  26.533  1.00 26.36           C  
ATOM   2259  O   PHE   149      28.108  48.498  26.802  1.00 26.92           O  
ATOM   2260  CB  PHE   149      25.825  50.378  25.500  1.00 29.54           C  
ATOM   2261  CG  PHE   149      25.075  49.745  24.365  1.00 31.48           C  
ATOM   2262  CD1 PHE   149      23.731  49.412  24.508  1.00 32.96           C  
ATOM   2263  CD2 PHE   149      25.708  49.468  23.162  1.00 31.91           C  
ATOM   2264  CE1 PHE   149      23.040  48.813  23.475  1.00 33.85           C  
ATOM   2265  CE2 PHE   149      25.017  48.876  22.123  1.00 34.43           C  
ATOM   2266  CZ  PHE   149      23.683  48.546  22.282  1.00 33.21           C  
ATOM   2267  N   TYR   150      26.428  47.209  26.045  1.00 25.14           N  
ATOM   2268  CA  TYR   150      27.236  45.986  26.041  1.00 26.48           C  
ATOM   2269  C   TYR   150      28.453  45.994  25.127  1.00 25.90           C  
ATOM   2270  O   TYR   150      29.319  45.125  25.246  1.00 26.81           O  
ATOM   2271  CB  TYR   150      26.372  44.766  25.751  1.00 27.38           C  
ATOM   2272  CG  TYR   150      25.858  44.654  24.346  1.00 27.41           C  
ATOM   2273  CD1 TYR   150      26.599  44.014  23.357  1.00 26.55           C  
ATOM   2274  CD2 TYR   150      24.599  45.154  24.011  1.00 33.30           C  
ATOM   2275  CE1 TYR   150      26.103  43.901  22.050  1.00 32.66           C  
ATOM   2276  CE2 TYR   150      24.090  45.035  22.725  1.00 34.22           C  
ATOM   2277  CZ  TYR   150      24.845  44.420  21.751  1.00 33.26           C  
ATOM   2278  OH  TYR   150      24.321  44.325  20.489  1.00 36.66           O  
ATOM   2279  N   GLN   151      28.514  46.963  24.224  1.00 25.97           N  
ATOM   2280  CA  GLN   151      29.643  47.114  23.323  1.00 28.02           C  
ATOM   2281  C   GLN   151      29.928  48.601  23.100  1.00 28.27           C  
ATOM   2282  O   GLN   151      29.011  49.379  22.893  1.00 26.65           O  
ATOM   2283  CB  GLN   151      29.326  46.447  21.977  1.00 28.59           C  
ATOM   2284  CG  GLN   151      30.572  46.158  21.157  1.00 31.58           C  
ATOM   2285  CD  GLN   151      30.308  45.843  19.693  1.00 29.46           C  
ATOM   2286  OE1 GLN   151      29.163  45.768  19.260  1.00 34.99           O  
ATOM   2287  NE2 GLN   151      31.381  45.675  18.920  1.00 28.17           N  
ATOM   2288  N   GLN   152      31.196  48.988  23.151  1.00 30.83           N  
ATOM   2289  CA  GLN   152      31.596  50.336  22.767  1.00 33.70           C  
ATOM   2290  C   GLN   152      31.634  50.422  21.243  1.00 36.95           C  
ATOM   2291  O   GLN   152      31.835  49.412  20.563  1.00 37.86           O  
ATOM   2292  CB  GLN   152      32.961  50.684  23.349  1.00 32.47           C  
ATOM   2293  CG  GLN   152      32.965  50.794  24.856  1.00 33.78           C  
ATOM   2294  CD  GLN   152      34.315  51.214  25.424  1.00 35.09           C  
ATOM   2295  OE1 GLN   152      35.319  51.317  24.704  1.00 32.29           O  
ATOM   2296  NE2 GLN   152      34.342  51.450  26.731  1.00 28.38           N  
ATOM   2297  N   ARG   153      31.444  51.622  20.707  1.00 38.84           N  
ATOM   2298  CA  ARG   153      31.447  51.820  19.252  1.00 40.64           C  
ATOM   2299  C   ARG   153      32.858  51.664  18.680  1.00 42.01           C  
ATOM   2300  O   ARG   153      33.351  50.543  18.488  1.00 44.29           O  
ATOM   2301  CB  ARG   153      30.889  53.206  18.903  1.00 39.42           C  
END
