
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  189 ( 1576),  selected  189 , name 2rd9_A
# Molecule2: number of CA atoms  144 ( 1145),  selected  144 , name T0481.pdb
# PARAMETERS: 2rd9_A.T0481.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K   -14_A      N       5           -
LGA    I   -13_A      -       -           -
LGA    H   -12_A      -       -           -
LGA    H   -11_A      -       -           -
LGA    H   -10_A      -       -           -
LGA    H    -9_A      -       -           -
LGA    H    -8_A      -       -           -
LGA    H    -7_A      -       -           -
LGA    E    -6_A      -       -           -
LGA    N    -5_A      -       -           -
LGA    L    -4_A      -       -           -
LGA    Y    -3_A      -       -           -
LGA    F    -2_A      -       -           -
LGA    Q    -1_A      -       -           -
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    N     2_A      -       -           -
LGA    F     3_A      -       -           -
LGA    Q     4_A      -       -           -
LGA    X     5_A      Q       6          4.802
LGA    N     6_A      I       7           #
LGA    E     7_A      -       -           -
LGA    A     8_A      -       -           -
LGA    I     9_A      V       8          3.353
LGA    Q    10_A      S       9          2.861
LGA    L    11_A      H      10          3.061
LGA    L    12_A      F      11          0.994
LGA    E    13_A      L      12          1.428
LGA    R    14_A      S      13          3.079
LGA    T    15_A      H      14          3.547
LGA    P    16_A      R      15          3.799
LGA    K    17_A      N      16          2.731
LGA    T    18_A      V      17          1.460
LGA    L    19_A      T      18          2.461
LGA    E    20_A      N      19          3.132
LGA    V    21_A      E      20          2.481
LGA    F    22_A      L      21          2.497
LGA    L    23_A      A      22          3.510
LGA    E    24_A      E      23          1.743
LGA    G    25_A      K      24          4.356
LGA    L    26_A      I      25          4.338
LGA    S    27_A      S      26          3.713
LGA    D    28_A      K      27          3.829
LGA    S    29_A      D      28          4.810
LGA    W    30_A      H      29          4.211
LGA    H    31_A      Y      30          3.691
LGA    Q    32_A      S      31          2.702
LGA    C    33_A      Y      32          2.082
LGA    N    34_A      K      33          2.171
LGA    E    35_A      P      34          3.806
LGA    G    36_A      A      35          2.350
LGA    Y    37_A      E      36          2.659
LGA    E    38_A      T      37          3.990
LGA    T    39_A      S      38          2.752
LGA    W    40_A      M      39          1.426
LGA    T    41_A      S      40          1.126
LGA    V    42_A      A      41          1.487
LGA    Y    43_A      E      42          1.284
LGA    E    44_A      E      43          1.533
LGA    V    45_A      L      44          1.780
LGA    V    46_A      V      45          1.757
LGA    V    47_A      K      46          1.815
LGA    H    48_A      H      47          2.107
LGA    L    49_A      I      48          2.752
LGA    I    50_A      L      49          2.979
LGA    E    51_A      T      50          2.233
LGA    A    52_A      S      51          2.711
LGA    E    53_A      F      52          4.957
LGA    K    54_A      H      53          4.611
LGA    T    55_A      -       -           -
LGA    N    56_A      L      54          1.084
LGA    W    57_A      F      55          1.791
LGA    I    58_A      A      56          2.430
LGA    P    59_A      N      57          1.847
LGA    R    60_A      V      58          0.629
LGA    L    61_A      I      59          0.921
LGA    R    62_A      K      60          2.250
LGA    F    63_A      E      61          2.454
LGA    I    64_A      G      62          1.717
LGA    L    65_A      -       -           -
LGA    Q    66_A      -       -           -
LGA    E    67_A      -       -           -
LGA    G    68_A      -       -           -
LGA    E    69_A      -       -           -
LGA    H    70_A      -       -           -
LGA    K    71_A      -       -           -
LGA    P    72_A      N      63           #
LGA    F    73_A      A      64          1.988
LGA    P    74_A      S      65          4.361
LGA    A    75_A      P      66           -
LGA    F    76_A      F      67          3.851
LGA    D    77_A      -       -           -
LGA    R    78_A      Q      68          5.760
LGA    F    79_A      N      69          5.597
LGA    S    80_A      K      70          4.662
LGA    H    81_A      Q      71          5.519
LGA    L    82_A      E      72          4.916
LGA    N    83_A      E      73           -
LGA    Q    84_A      T      74           #
LGA    S    85_A      E      75           -
LGA    N    86_A      -       -           -
LGA    A    87_A      -       -           -
LGA    V    88_A      T      76          2.975
LGA    P    89_A      D      77          3.030
LGA    I    90_A      L      78          2.797
LGA    S    91_A      N      79          2.838
LGA    E    92_A      V      80          2.215
LGA    R    93_A      L      81          2.359
LGA    F    94_A      A      82          2.837
LGA    K    95_A      K      83          2.614
LGA    E    96_A      -       -           -
LGA    F    97_A      -       -           -
LGA    Q    98_A      -       -           -
LGA    Q    99_A      T      84          3.666
LGA    L   100_A      Y      85          3.166
LGA    R   101_A      T      86          2.407
LGA    K   102_A      E      87          3.224
LGA    E   103_A      K      88          3.874
LGA    N   104_A      T      89          2.761
LGA    L   105_A      V      90          2.662
LGA    N   106_A      A      91          3.599
LGA    T   107_A      I      92          2.864
LGA    L   108_A      L      93          2.437
LGA    R   109_A      E      94          3.260
LGA    S   110_A      Q      95          2.105
LGA    L   111_A      L      96          2.610
LGA    V   112_A      T      97          1.665
LGA    Q   113_A      -       -           -
LGA    S   114_A      E      98          3.478
LGA    E   115_A      -       -           -
LGA    A   116_A      E      99           #
LGA    D   117_A      Q     100           #
LGA    L   118_A      L     101          3.011
LGA    E   119_A      D     102          2.551
LGA    R   120_A      R     103          1.521
LGA    T   121_A      E     104          1.114
LGA    G   122_A      I     105          1.776
LGA    A   123_A      D     106          1.241
LGA    H   124_A      L     107          1.707
LGA    P   125_A      T     108          0.920
LGA    A   126_A      -       -           -
LGA    F   127_A      -       -           -
LGA    G   128_A      -       -           -
LGA    V   129_A      K     114          2.104
LGA    V   130_A      V     115          0.774
LGA    K   131_A      T     116          1.026
LGA    V   132_A      G     117          1.483
LGA    R   133_A      R     118          1.182
LGA    E   134_A      A     119          0.483
LGA    L   135_A      L     120          1.043
LGA    L   136_A      L     121          0.914
LGA    S   137_A      Q     122          0.354
LGA    A   138_A      L     123          0.998
LGA    W   139_A      A     124          1.396
LGA    V   140_A      M     125          0.790
LGA    V   141_A      E     126          0.935
LGA    H   142_A      H     127          1.616
LGA    D   143_A      E     128          1.033
LGA    L   144_A      I     129          0.758
LGA    T   145_A      H     130          1.441
LGA    H   146_A      H     131          1.422
LGA    I   147_A      K     132          0.609
LGA    A   148_A      G     133          1.555
LGA    Q   149_A      N     134          2.087
LGA    I   150_A      L     135          1.633
LGA    V   151_A      F     136          2.398
LGA    R   152_A      V     137          3.534
LGA    S   153_A      Y     138          3.626
LGA    X   154_A      V     139          4.475
LGA    A   155_A      R     140           #
LGA    K   156_A      E     141           #
LGA    R   157_A      M     142           #
LGA    Y   158_A      G     143           -
LGA    D   159_A      H     144           -
LGA    T   160_A      T     145           -
LGA    D   161_A      E     146           -
LGA    V   162_A      L     147           -
LGA    G   163_A      P     148           -
LGA    P   164_A      F     149           -
LGA    W   165_A      Y     150           -
LGA    K   166_A      Q     151           -
LGA    E   167_A      Q     152           -
LGA    Y   168_A      R     153           -
LGA    L   169_A      -       -           -
LGA    G   170_A      -       -           -
LGA    I   171_A      -       -           -
LGA    L   172_A      -       -           -
LGA    N   173_A      -       -           -
LGA    D   174_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  189  144    5.0    121    2.79    14.05     54.499     4.182

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.670919 * X  +   0.464858 * Y  +   0.577733 * Z  + -107.532738
  Y_new =  -0.503204 * X  +  -0.286846 * Y  +   0.815172 * Z  + -15.003974
  Z_new =   0.544660 * X  +  -0.837631 * Y  +   0.041467 * Z  + -28.170910 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.521331    1.620262  [ DEG:   -87.1658     92.8342 ]
  Theta =  -0.575983   -2.565609  [ DEG:   -33.0014   -146.9986 ]
  Phi   =  -0.643515    2.498078  [ DEG:   -36.8707    143.1293 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rd9_A                                        
REMARK     2: T0481.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rd9_A.T0481.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  189  144   5.0  121   2.79   14.05  54.499
REMARK  ---------------------------------------------------------- 
MOLECULE 2rd9_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   21-SEP-07   2RD9              
TITLE     CRYSTAL STRUCTURE OF YFIT-LIKE PUTATIVE METAL-DEPENDENT               
TITLE    2 HYDROLASE (NP_241052.1) FROM BACILLUS HALODURANS AT 2.30 A           
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BH0186 PROTEIN;                                            
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS C-125;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C-125, DSM 18197, FERM 7344, JCM 9153;                       
SOURCE   5 ATCC: BAA-125;                                                       
SOURCE   6 GENE: NP_241052.1, BH0186;                                           
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_241052.1, YFIT-LIKE PUTATIVE METAL-DEPENDENT HYDROLASE,            
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2, STRUCTURAL                
KEYWDS   4 GENOMICS, UNKNOWN FUNCTION                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   09-OCT-07 2RD9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF YFIT-LIKE PUTATIVE                      
JRNL        TITL 2 METAL-DEPENDENT HYDROLASE (NP_241052.1) FROM                 
JRNL        TITL 3 BACILLUS HALODURANS AT 2.30 A RESOLUTION                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2RD9 A    1   174  UNP    Q9KGB8   Q9KGB8_BACHD     1    174             
DBREF  2RD9 B    1   174  UNP    Q9KGB8   Q9KGB8_BACHD     1    174             
DBREF  2RD9 C    1   174  UNP    Q9KGB8   Q9KGB8_BACHD     1    174             
DBREF  2RD9 D    1   174  UNP    Q9KGB8   Q9KGB8_BACHD     1    174             
SEQRES   1 A  193  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  193  ASN LEU TYR PHE GLN GLY MSE ASN PHE GLN MSE ASN GLU          
SEQRES   3 A  193  ALA ILE GLN LEU LEU GLU ARG THR PRO LYS THR LEU GLU          
SEQRES   4 A  193  VAL PHE LEU GLU GLY LEU SER ASP SER TRP HIS GLN CYS          
SEQRES   5 A  193  ASN GLU GLY TYR GLU THR TRP THR VAL TYR GLU VAL VAL          
SEQRES   6 A  193  VAL HIS LEU ILE GLU ALA GLU LYS THR ASN TRP ILE PRO          
SEQRES   7 A  193  ARG LEU ARG PHE ILE LEU GLN GLU GLY GLU HIS LYS PRO          
SEQRES   8 A  193  PHE PRO ALA PHE ASP ARG PHE SER HIS LEU ASN GLN SER          
SEQRES   9 A  193  ASN ALA VAL PRO ILE SER GLU ARG PHE LYS GLU PHE GLN          
SEQRES  10 A  193  GLN LEU ARG LYS GLU ASN LEU ASN THR LEU ARG SER LEU          
SEQRES  11 A  193  VAL GLN SER GLU ALA ASP LEU GLU ARG THR GLY ALA HIS          
SEQRES  12 A  193  PRO ALA PHE GLY VAL VAL LYS VAL ARG GLU LEU LEU SER          
SEQRES  13 A  193  ALA TRP VAL VAL HIS ASP LEU THR HIS ILE ALA GLN ILE          
SEQRES  14 A  193  VAL ARG SER MSE ALA LYS ARG TYR ASP THR ASP VAL GLY          
SEQRES  15 A  193  PRO TRP LYS GLU TYR LEU GLY ILE LEU ASN ASP                  
SEQRES   1 B  193  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  193  ASN LEU TYR PHE GLN GLY MSE ASN PHE GLN MSE ASN GLU          
SEQRES   3 B  193  ALA ILE GLN LEU LEU GLU ARG THR PRO LYS THR LEU GLU          
SEQRES   4 B  193  VAL PHE LEU GLU GLY LEU SER ASP SER TRP HIS GLN CYS          
SEQRES   5 B  193  ASN GLU GLY TYR GLU THR TRP THR VAL TYR GLU VAL VAL          
SEQRES   6 B  193  VAL HIS LEU ILE GLU ALA GLU LYS THR ASN TRP ILE PRO          
SEQRES   7 B  193  ARG LEU ARG PHE ILE LEU GLN GLU GLY GLU HIS LYS PRO          
SEQRES   8 B  193  PHE PRO ALA PHE ASP ARG PHE SER HIS LEU ASN GLN SER          
SEQRES   9 B  193  ASN ALA VAL PRO ILE SER GLU ARG PHE LYS GLU PHE GLN          
SEQRES  10 B  193  GLN LEU ARG LYS GLU ASN LEU ASN THR LEU ARG SER LEU          
SEQRES  11 B  193  VAL GLN SER GLU ALA ASP LEU GLU ARG THR GLY ALA HIS          
SEQRES  12 B  193  PRO ALA PHE GLY VAL VAL LYS VAL ARG GLU LEU LEU SER          
SEQRES  13 B  193  ALA TRP VAL VAL HIS ASP LEU THR HIS ILE ALA GLN ILE          
SEQRES  14 B  193  VAL ARG SER MSE ALA LYS ARG TYR ASP THR ASP VAL GLY          
SEQRES  15 B  193  PRO TRP LYS GLU TYR LEU GLY ILE LEU ASN ASP                  
SEQRES   1 C  193  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 C  193  ASN LEU TYR PHE GLN GLY MSE ASN PHE GLN MSE ASN GLU          
SEQRES   3 C  193  ALA ILE GLN LEU LEU GLU ARG THR PRO LYS THR LEU GLU          
SEQRES   4 C  193  VAL PHE LEU GLU GLY LEU SER ASP SER TRP HIS GLN CYS          
SEQRES   5 C  193  ASN GLU GLY TYR GLU THR TRP THR VAL TYR GLU VAL VAL          
SEQRES   6 C  193  VAL HIS LEU ILE GLU ALA GLU LYS THR ASN TRP ILE PRO          
SEQRES   7 C  193  ARG LEU ARG PHE ILE LEU GLN GLU GLY GLU HIS LYS PRO          
SEQRES   8 C  193  PHE PRO ALA PHE ASP ARG PHE SER HIS LEU ASN GLN SER          
SEQRES   9 C  193  ASN ALA VAL PRO ILE SER GLU ARG PHE LYS GLU PHE GLN          
SEQRES  10 C  193  GLN LEU ARG LYS GLU ASN LEU ASN THR LEU ARG SER LEU          
SEQRES  11 C  193  VAL GLN SER GLU ALA ASP LEU GLU ARG THR GLY ALA HIS          
SEQRES  12 C  193  PRO ALA PHE GLY VAL VAL LYS VAL ARG GLU LEU LEU SER          
SEQRES  13 C  193  ALA TRP VAL VAL HIS ASP LEU THR HIS ILE ALA GLN ILE          
SEQRES  14 C  193  VAL ARG SER MSE ALA LYS ARG TYR ASP THR ASP VAL GLY          
SEQRES  15 C  193  PRO TRP LYS GLU TYR LEU GLY ILE LEU ASN ASP                  
SEQRES   1 D  193  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 D  193  ASN LEU TYR PHE GLN GLY MSE ASN PHE GLN MSE ASN GLU          
SEQRES   3 D  193  ALA ILE GLN LEU LEU GLU ARG THR PRO LYS THR LEU GLU          
SEQRES   4 D  193  VAL PHE LEU GLU GLY LEU SER ASP SER TRP HIS GLN CYS          
SEQRES   5 D  193  ASN GLU GLY TYR GLU THR TRP THR VAL TYR GLU VAL VAL          
SEQRES   6 D  193  VAL HIS LEU ILE GLU ALA GLU LYS THR ASN TRP ILE PRO          
SEQRES   7 D  193  ARG LEU ARG PHE ILE LEU GLN GLU GLY GLU HIS LYS PRO          
SEQRES   8 D  193  PHE PRO ALA PHE ASP ARG PHE SER HIS LEU ASN GLN SER          
SEQRES   9 D  193  ASN ALA VAL PRO ILE SER GLU ARG PHE LYS GLU PHE GLN          
SEQRES  10 D  193  GLN LEU ARG LYS GLU ASN LEU ASN THR LEU ARG SER LEU          
SEQRES  11 D  193  VAL GLN SER GLU ALA ASP LEU GLU ARG THR GLY ALA HIS          
SEQRES  12 D  193  PRO ALA PHE GLY VAL VAL LYS VAL ARG GLU LEU LEU SER          
SEQRES  13 D  193  ALA TRP VAL VAL HIS ASP LEU THR HIS ILE ALA GLN ILE          
SEQRES  14 D  193  VAL ARG SER MSE ALA LYS ARG TYR ASP THR ASP VAL GLY          
SEQRES  15 D  193  PRO TRP LYS GLU TYR LEU GLY ILE LEU ASN ASP                  
HET    MSE  A   1      16                                                       
HET    MSE  A   5       8                                                       
HET    MSE  A 154       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   5       8                                                       
HET    MSE  B 154       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C   5       8                                                       
HET    MSE  C 154       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D   5       8                                                       
HET    MSE  D 154       8                                                       
HET     NI  A 300       1                                                       
HET     NI  C 300       1                                                       
HET     NI  B 300       1                                                       
HET     NI  D 300       1                                                       
HET    IMD  A 301       5                                                       
HET    IMD  C 301       5                                                       
HET    IMD  C 302       5                                                       
HET    IMD  A 302       5                                                       
HET    IMD  A 303       5                                                       
HET    GOL  A 304       6                                                       
HET    GOL  A 305       6                                                       
HET    GOL  D 301       6                                                       
HET    GOL  B 301       6                                                       
HET    GOL  D 302       6                                                       
HET    GOL  C 303       6                                                       
HET    GOL  A 306       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     IMD IMIDAZOLE                                                        
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   5   NI    4(NI 2+)                                                     
FORMUL   9  IMD    5(C3 H5 N2 1+)                                               
FORMUL  14  GOL    7(C3 H8 O3)                                                  
FORMUL  21  HOH   *555(H2 O)                                                    
CRYST1  147.330  147.330  147.330  90.00  90.00  90.00 P 21 3       48          
ATOM      1  N   LYS A -14      -8.800  31.215   3.861  1.00 56.67           N  
ATOM      2  CA  LYS A -14      -7.645  31.534   4.768  1.00 56.49           C  
ATOM      3  C   LYS A -14      -6.782  30.269   5.054  1.00 54.48           C  
ATOM      4  O   LYS A -14      -7.249  29.262   5.623  1.00 55.34           O  
ATOM      5  CB  LYS A -14      -8.148  32.237   6.052  1.00 56.11           C  
ATOM      6  CG  LYS A -14      -7.124  33.058   6.881  1.00 59.74           C  
ATOM      7  CD  LYS A -14      -5.829  33.479   6.146  1.00 65.41           C  
ATOM      8  CE  LYS A -14      -6.069  34.443   4.972  1.00 65.71           C  
ATOM      9  NZ  LYS A -14      -6.482  35.779   5.441  1.00 68.23           N  
ATOM     10  N   ILE A -13      -5.533  30.332   4.595  1.00 50.61           N  
ATOM     11  CA  ILE A -13      -4.599  29.207   4.652  1.00 47.51           C  
ATOM     12  C   ILE A -13      -3.391  29.588   5.496  1.00 45.17           C  
ATOM     13  O   ILE A -13      -3.076  30.775   5.639  1.00 44.29           O  
ATOM     14  CB  ILE A -13      -4.139  28.710   3.224  1.00 46.72           C  
ATOM     15  CG1 ILE A -13      -3.399  29.799   2.437  1.00 45.70           C  
ATOM     16  CG2 ILE A -13      -5.330  28.180   2.418  1.00 41.42           C  
ATOM     17  CD1 ILE A -13      -3.606  29.693   0.895  1.00 48.50           C  
ATOM     18  N   HIS A -12      -2.755  28.573   6.086  1.00 41.47           N  
ATOM     19  CA  HIS A -12      -1.472  28.744   6.756  1.00 38.56           C  
ATOM     20  C   HIS A -12      -0.332  28.005   6.040  1.00 35.21           C  
ATOM     21  O   HIS A -12      -0.556  27.040   5.294  1.00 31.11           O  
ATOM     22  CB  HIS A -12      -1.551  28.350   8.255  1.00 42.09           C  
ATOM     23  CG  HIS A -12      -2.055  26.962   8.526  1.00 41.39           C  
ATOM     24  ND1 HIS A -12      -3.391  26.676   8.691  1.00 46.52           N  
ATOM     25  CD2 HIS A -12      -1.398  25.796   8.731  1.00 46.94           C  
ATOM     26  CE1 HIS A -12      -3.539  25.385   8.949  1.00 46.58           C  
ATOM     27  NE2 HIS A -12      -2.345  24.828   8.977  1.00 47.42           N  
ATOM     28  N   HIS A -11       0.892  28.477   6.274  1.00 32.74           N  
ATOM     29  CA  HIS A -11       2.093  27.866   5.691  1.00 33.61           C  
ATOM     30  C   HIS A -11       2.746  26.800   6.601  1.00 31.28           C  
ATOM     31  O   HIS A -11       2.725  26.907   7.845  1.00 30.50           O  
ATOM     32  CB  HIS A -11       3.151  28.933   5.382  1.00 34.73           C  
ATOM     33  CG  HIS A -11       2.763  29.877   4.303  1.00 40.03           C  
ATOM     34  ND1 HIS A -11       1.823  30.867   4.489  1.00 43.91           N  
ATOM     35  CD2 HIS A -11       3.203  30.007   3.029  1.00 42.45           C  
ATOM     36  CE1 HIS A -11       1.687  31.556   3.368  1.00 43.26           C  
ATOM     37  NE2 HIS A -11       2.518  31.058   2.471  1.00 43.25           N  
ATOM     38  N   HIS A -10       3.357  25.806   5.955  1.00 27.24           N  
ATOM     39  CA  HIS A -10       4.187  24.829   6.632  1.00 27.02           C  
ATOM     40  C   HIS A -10       5.643  25.360   6.742  1.00 27.02           C  
ATOM     41  O   HIS A -10       6.239  25.773   5.754  1.00 26.78           O  
ATOM     42  CB  HIS A -10       4.114  23.499   5.874  1.00 26.77           C  
ATOM     43  CG  HIS A -10       4.778  22.356   6.577  1.00 25.96           C  
ATOM     44  ND1 HIS A -10       4.248  21.769   7.702  1.00 21.70           N  
ATOM     45  CD2 HIS A -10       5.908  21.665   6.290  1.00 26.33           C  
ATOM     46  CE1 HIS A -10       5.049  20.794   8.103  1.00 26.50           C  
ATOM     47  NE2 HIS A -10       6.052  20.697   7.252  1.00 23.33           N  
ATOM     48  N   HIS A  -9       6.185  25.381   7.957  1.00 25.23           N  
ATOM     49  CA  HIS A  -9       7.573  25.774   8.189  1.00 25.73           C  
ATOM     50  C   HIS A  -9       7.892  27.081   7.439  1.00 26.95           C  
ATOM     51  O   HIS A  -9       8.839  27.166   6.629  1.00 27.04           O  
ATOM     52  CB  HIS A  -9       8.540  24.612   7.830  1.00 24.26           C  
ATOM     53  CG  HIS A  -9       8.619  23.543   8.889  1.00 26.92           C  
ATOM     54  ND1 HIS A  -9       9.202  22.311   8.673  1.00 23.01           N  
ATOM     55  CD2 HIS A  -9       8.194  23.534  10.178  1.00 23.48           C  
ATOM     56  CE1 HIS A  -9       9.135  21.592   9.781  1.00 22.40           C  
ATOM     57  NE2 HIS A  -9       8.527  22.310  10.709  1.00 21.24           N  
ATOM     58  N   HIS A  -8       7.072  28.092   7.739  1.00 27.62           N  
ATOM     59  CA  HIS A  -8       6.969  29.333   6.949  1.00 26.57           C  
ATOM     60  C   HIS A  -8       8.357  29.995   6.701  1.00 26.27           C  
ATOM     61  O   HIS A  -8       8.697  30.343   5.582  1.00 25.32           O  
ATOM     62  CB  HIS A  -8       6.014  30.270   7.688  1.00 29.78           C  
ATOM     63  CG  HIS A  -8       5.454  31.394   6.870  1.00 30.92           C  
ATOM     64  ND1 HIS A  -8       5.968  31.780   5.654  1.00 38.37           N  
ATOM     65  CD2 HIS A  -8       4.454  32.261   7.145  1.00 35.85           C  
ATOM     66  CE1 HIS A  -8       5.277  32.802   5.189  1.00 36.55           C  
ATOM     67  NE2 HIS A  -8       4.359  33.119   6.080  1.00 35.31           N  
ATOM     68  N   HIS A  -7       9.192  30.078   7.728  1.00 25.30           N  
ATOM     69  CA  HIS A  -7      10.449  30.791   7.607  1.00 24.43           C  
ATOM     70  C   HIS A  -7      11.659  29.896   7.707  1.00 24.18           C  
ATOM     71  O   HIS A  -7      12.725  30.367   8.038  1.00 25.82           O  
ATOM     72  CB  HIS A  -7      10.514  31.894   8.673  1.00 24.64           C  
ATOM     73  CG  HIS A  -7       9.349  32.822   8.613  1.00 24.38           C  
ATOM     74  ND1 HIS A  -7       8.255  32.691   9.438  1.00 28.45           N  
ATOM     75  CD2 HIS A  -7       9.069  33.843   7.772  1.00 25.91           C  
ATOM     76  CE1 HIS A  -7       7.360  33.615   9.136  1.00 28.31           C  
ATOM     77  NE2 HIS A  -7       7.826  34.321   8.122  1.00 30.11           N  
ATOM     78  N   GLU A  -6      11.508  28.610   7.415  1.00 25.85           N  
ATOM     79  CA  GLU A  -6      12.664  27.709   7.308  1.00 24.73           C  
ATOM     80  C   GLU A  -6      13.866  28.347   6.593  1.00 25.13           C  
ATOM     81  O   GLU A  -6      15.002  28.285   7.094  1.00 24.07           O  
ATOM     82  CB  GLU A  -6      12.260  26.425   6.578  1.00 25.95           C  
ATOM     83  CG  GLU A  -6      13.367  25.395   6.487  1.00 22.32           C  
ATOM     84  CD  GLU A  -6      12.878  24.053   6.044  1.00 26.01           C  
ATOM     85  OE1 GLU A  -6      11.717  23.701   6.395  1.00 31.38           O  
ATOM     86  OE2 GLU A  -6      13.648  23.343   5.337  1.00 24.02           O  
ATOM     87  N   ASN A  -5      13.596  28.976   5.443  1.00 25.89           N  
ATOM     88  CA  ASN A  -5      14.648  29.483   4.550  1.00 26.75           C  
ATOM     89  C   ASN A  -5      15.401  30.701   5.103  1.00 28.43           C  
ATOM     90  O   ASN A  -5      16.441  31.091   4.559  1.00 29.53           O  
ATOM     91  CB  ASN A  -5      14.073  29.800   3.169  1.00 26.24           C  
ATOM     92  CG  ASN A  -5      13.525  28.558   2.440  1.00 28.59           C  
ATOM     93  OD1 ASN A  -5      13.785  27.415   2.832  1.00 24.03           O  
ATOM     94  ND2 ASN A  -5      12.758  28.790   1.363  1.00 21.72           N  
ATOM     95  N   LEU A  -4      14.903  31.274   6.205  1.00 27.93           N  
ATOM     96  CA  LEU A  -4      15.544  32.403   6.847  1.00 27.32           C  
ATOM     97  C   LEU A  -4      16.621  31.963   7.820  1.00 28.17           C  
ATOM     98  O   LEU A  -4      17.346  32.804   8.350  1.00 28.58           O  
ATOM     99  CB  LEU A  -4      14.516  33.281   7.583  1.00 27.84           C  
ATOM    100  CG  LEU A  -4      13.401  33.893   6.712  1.00 29.92           C  
ATOM    101  CD1 LEU A  -4      12.480  34.787   7.528  1.00 27.04           C  
ATOM    102  CD2 LEU A  -4      13.965  34.689   5.537  1.00 31.63           C  
ATOM    103  N   TYR A  -3      16.748  30.657   8.049  1.00 27.38           N  
ATOM    104  CA  TYR A  -3      17.594  30.173   9.108  1.00 27.52           C  
ATOM    105  C   TYR A  -3      18.834  29.450   8.612  1.00 29.39           C  
ATOM    106  O   TYR A  -3      19.077  28.315   8.978  1.00 32.31           O  
ATOM    107  CB  TYR A  -3      16.767  29.330  10.091  1.00 26.49           C  
ATOM    108  CG  TYR A  -3      15.803  30.193  10.880  1.00 25.84           C  
ATOM    109  CD1 TYR A  -3      16.214  30.884  12.011  1.00 25.02           C  
ATOM    110  CD2 TYR A  -3      14.498  30.379  10.435  1.00 25.35           C  
ATOM    111  CE1 TYR A  -3      15.310  31.704  12.727  1.00 29.75           C  
ATOM    112  CE2 TYR A  -3      13.609  31.165  11.113  1.00 29.09           C  
ATOM    113  CZ  TYR A  -3      14.006  31.832  12.262  1.00 26.55           C  
ATOM    114  OH  TYR A  -3      13.072  32.604  12.921  1.00 28.87           O  
ATOM    115  N   PHE A  -2      19.636  30.144   7.827  1.00 31.11           N  
ATOM    116  CA  PHE A  -2      20.875  29.610   7.290  1.00 34.18           C  
ATOM    117  C   PHE A  -2      21.919  30.727   7.207  1.00 36.19           C  
ATOM    118  O   PHE A  -2      22.057  31.404   6.170  1.00 40.81           O  
ATOM    119  CB  PHE A  -2      20.661  29.027   5.895  1.00 34.80           C  
ATOM    120  CG  PHE A  -2      21.870  28.256   5.364  1.00 38.81           C  
ATOM    121  CD1 PHE A  -2      22.269  27.067   5.959  1.00 36.49           C  
ATOM    122  CD2 PHE A  -2      22.597  28.731   4.269  1.00 44.27           C  
ATOM    123  CE1 PHE A  -2      23.355  26.360   5.486  1.00 42.54           C  
ATOM    124  CE2 PHE A  -2      23.703  28.028   3.782  1.00 43.63           C  
ATOM    125  CZ  PHE A  -2      24.078  26.829   4.395  1.00 40.73           C  
ATOM    126  N   GLN A  -1      22.658  30.888   8.286  1.00 36.86           N  
ATOM    127  CA  GLN A  -1      23.566  32.007   8.471  1.00 39.75           C  
ATOM    128  C   GLN A  -1      24.945  31.740   7.840  1.00 37.56           C  
ATOM    129  O   GLN A  -1      25.488  30.615   7.928  1.00 36.56           O  
ATOM    130  CB  GLN A  -1      23.720  32.273   9.981  1.00 42.40           C  
ATOM    131  CG  GLN A  -1      24.262  33.650  10.340  1.00 46.12           C  
ATOM    132  CD  GLN A  -1      24.172  33.921  11.822  1.00 40.01           C  
ATOM    133  OE1 GLN A  -1      23.085  34.080  12.376  1.00 46.81           O  
ATOM    134  NE2 GLN A  -1      25.305  34.001  12.461  1.00 34.58           N  
ATOM    135  N   GLY A   0      25.487  32.791   7.219  1.00 35.41           N  
ATOM    136  CA  GLY A   0      26.818  32.781   6.616  1.00 33.88           C  
ATOM    137  C   GLY A   0      27.868  33.328   7.566  1.00 32.71           C  
ATOM    138  O   GLY A   0      27.621  33.454   8.742  1.00 30.44           O  
HETATM  139  N   MSE A   1      29.038  33.641   7.009  0.50 33.16           N  
HETATM  141  CA  MSE A   1      30.196  34.159   7.744  0.50 33.05           C  
HETATM  143  C   MSE A   1      30.077  35.666   7.924  0.50 31.64           C  
HETATM  145  O   MSE A   1      29.846  36.368   6.951  0.50 30.58           O  
HETATM  147  CB  MSE A   1      31.479  33.896   6.943  0.50 33.58           C  
HETATM  149  CG  MSE A   1      31.723  32.452   6.582  0.50 36.29           C  
HETATM  151 SE   MSE A   1      31.957  31.383   8.166  0.37 37.12          SE  
HETATM  153  CE  MSE A   1      31.910  29.600   7.321  0.50 35.27           C  
ATOM    155  N   ASN A   2      30.231  36.169   9.147  1.00 31.62           N  
ATOM    156  CA  ASN A   2      30.197  37.623   9.376  1.00 30.73           C  
ATOM    157  C   ASN A   2      31.509  38.218   9.895  1.00 30.36           C  
ATOM    158  O   ASN A   2      31.585  39.438  10.089  1.00 30.23           O  
ATOM    159  CB  ASN A   2      29.052  37.974  10.344  1.00 31.11           C  
ATOM    160  CG  ASN A   2      27.677  37.714   9.752  1.00 30.30           C  
ATOM    161  OD1 ASN A   2      27.400  38.140   8.649  1.00 32.80           O  
ATOM    162  ND2 ASN A   2      26.802  37.026  10.505  1.00 26.73           N  
ATOM    163  N   PHE A   3      32.526  37.380  10.133  1.00 30.99           N  
ATOM    164  CA  PHE A   3      33.826  37.861  10.644  1.00 29.17           C  
ATOM    165  C   PHE A   3      34.459  38.887   9.732  1.00 29.31           C  
ATOM    166  O   PHE A   3      34.587  38.657   8.529  1.00 27.53           O  
ATOM    167  CB  PHE A   3      34.812  36.714  10.840  1.00 28.51           C  
ATOM    168  CG  PHE A   3      36.148  37.154  11.436  1.00 31.06           C  
ATOM    169  CD1 PHE A   3      36.321  37.241  12.799  1.00 27.06           C  
ATOM    170  CD2 PHE A   3      37.225  37.506  10.612  1.00 30.49           C  
ATOM    171  CE1 PHE A   3      37.559  37.651  13.328  1.00 30.15           C  
ATOM    172  CE2 PHE A   3      38.440  37.918  11.146  1.00 29.26           C  
ATOM    173  CZ  PHE A   3      38.611  37.969  12.482  1.00 24.95           C  
ATOM    174  N   GLN A   4      34.794  40.042  10.309  1.00 31.81           N  
ATOM    175  CA  GLN A   4      35.681  41.037   9.700  1.00 30.93           C  
ATOM    176  C   GLN A   4      36.714  41.334  10.771  1.00 31.25           C  
ATOM    177  O   GLN A   4      36.366  41.438  11.957  1.00 32.82           O  
ATOM    178  CB  GLN A   4      34.964  42.358   9.368  1.00 33.96           C  
ATOM    179  CG  GLN A   4      33.792  42.285   8.432  1.00 41.50           C  
ATOM    180  CD  GLN A   4      34.146  41.720   7.058  1.00 53.63           C  
ATOM    181  OE1 GLN A   4      35.243  41.957   6.539  1.00 60.90           O  
ATOM    182  NE2 GLN A   4      33.206  40.964   6.460  1.00 55.12           N  
HETATM  183  N   MSE A   5      37.968  41.510  10.362  1.00 30.43           N  
HETATM  184  CA  MSE A   5      39.096  41.661  11.282  1.00 29.88           C  
HETATM  185  C   MSE A   5      39.017  42.941  12.109  1.00 30.21           C  
HETATM  186  O   MSE A   5      39.186  42.906  13.321  1.00 30.96           O  
HETATM  187  CB  MSE A   5      40.397  41.641  10.494  1.00 29.61           C  
HETATM  188  CG  MSE A   5      41.631  41.757  11.312  1.00 33.22           C  
HETATM  189 SE   MSE A   5      42.036  40.253  12.474  0.75 24.92          SE  
HETATM  190  CE  MSE A   5      43.934  40.772  12.447  1.00 25.52           C  
ATOM    191  N   ASN A   6      38.746  44.060  11.456  1.00 30.45           N  
ATOM    192  CA  ASN A   6      38.555  45.332  12.143  1.00 30.93           C  
ATOM    193  C   ASN A   6      37.420  45.300  13.159  1.00 29.95           C  
ATOM    194  O   ASN A   6      37.566  45.832  14.260  1.00 31.39           O  
ATOM    195  CB  ASN A   6      38.349  46.492  11.125  1.00 32.04           C  
ATOM    196  CG  ASN A   6      36.945  46.498  10.476  1.00 39.92           C  
ATOM    197  OD1 ASN A   6      36.411  45.436  10.081  1.00 45.42           O  
ATOM    198  ND2 ASN A   6      36.339  47.708  10.362  1.00 40.98           N  
ATOM    199  N   GLU A   7      36.295  44.684  12.785  1.00 28.42           N  
ATOM    200  CA  GLU A   7      35.119  44.636  13.640  1.00 26.85           C  
ATOM    201  C   GLU A   7      35.382  43.722  14.841  1.00 28.45           C  
ATOM    202  O   GLU A   7      34.863  43.955  15.940  1.00 27.86           O  
ATOM    203  CB  GLU A   7      33.890  44.149  12.856  1.00 27.15           C  
ATOM    204  CG  GLU A   7      33.363  45.126  11.752  1.00 26.94           C  
ATOM    205  CD  GLU A   7      32.152  44.567  10.990  1.00 30.02           C  
ATOM    206  OE1 GLU A   7      31.758  43.402  11.247  1.00 34.20           O  
ATOM    207  OE2 GLU A   7      31.586  45.282  10.125  1.00 35.17           O  
ATOM    208  N   ALA A   8      36.159  42.660  14.612  1.00 27.85           N  
ATOM    209  CA  ALA A   8      36.515  41.710  15.668  1.00 26.77           C  
ATOM    210  C   ALA A   8      37.359  42.414  16.725  1.00 28.76           C  
ATOM    211  O   ALA A   8      37.115  42.278  17.928  1.00 29.71           O  
ATOM    212  CB  ALA A   8      37.282  40.540  15.086  1.00 26.43           C  
ATOM    213  N   ILE A   9      38.344  43.174  16.252  1.00 28.49           N  
ATOM    214  CA  ILE A   9      39.274  43.881  17.111  1.00 27.95           C  
ATOM    215  C   ILE A   9      38.635  44.993  17.899  1.00 27.77           C  
ATOM    216  O   ILE A   9      39.074  45.245  19.008  1.00 28.34           O  
ATOM    217  CB  ILE A   9      40.445  44.473  16.309  1.00 27.62           C  
ATOM    218  CG1 ILE A   9      41.337  43.353  15.789  1.00 27.78           C  
ATOM    219  CG2 ILE A   9      41.271  45.441  17.200  1.00 27.40           C  
ATOM    220  CD1 ILE A   9      42.412  43.830  14.752  1.00 29.15           C  
ATOM    221  N   GLN A  10      37.646  45.676  17.315  1.00 29.45           N  
ATOM    222  CA  GLN A  10      36.807  46.667  18.017  1.00 28.34           C  
ATOM    223  C   GLN A  10      36.227  46.104  19.298  1.00 28.24           C  
ATOM    224  O   GLN A  10      36.333  46.715  20.363  1.00 29.55           O  
ATOM    225  CB  GLN A  10      35.624  47.120  17.152  1.00 29.91           C  
ATOM    226  CG  GLN A  10      35.895  48.197  16.102  1.00 31.87           C  
ATOM    227  CD  GLN A  10      34.748  48.333  15.069  1.00 30.51           C  
ATOM    228  OE1 GLN A  10      33.693  47.679  15.148  1.00 32.81           O  
ATOM    229  NE2 GLN A  10      34.983  49.157  14.077  1.00 33.86           N  
ATOM    230  N   LEU A  11      35.616  44.932  19.207  1.00 29.56           N  
ATOM    231  CA  LEU A  11      35.074  44.288  20.401  1.00 30.41           C  
ATOM    232  C   LEU A  11      36.160  43.842  21.396  1.00 28.93           C  
ATOM    233  O   LEU A  11      36.065  44.116  22.602  1.00 29.35           O  
ATOM    234  CB  LEU A  11      34.213  43.079  20.025  1.00 31.45           C  
ATOM    235  CG  LEU A  11      32.781  43.280  19.561  1.00 41.73           C  
ATOM    236  CD1 LEU A  11      32.092  41.926  19.607  1.00 44.70           C  
ATOM    237  CD2 LEU A  11      32.015  44.274  20.419  1.00 48.81           C  
ATOM    238  N   LEU A  12      37.169  43.132  20.913  1.00 26.60           N  
ATOM    239  CA  LEU A  12      38.223  42.590  21.804  1.00 27.23           C  
ATOM    240  C   LEU A  12      38.946  43.700  22.544  1.00 26.62           C  
ATOM    241  O   LEU A  12      39.381  43.523  23.677  1.00 27.36           O  
ATOM    242  CB  LEU A  12      39.259  41.756  21.019  1.00 26.86           C  
ATOM    243  CG  LEU A  12      38.816  40.482  20.275  1.00 28.23           C  
ATOM    244  CD1 LEU A  12      39.916  39.985  19.333  1.00 21.11           C  
ATOM    245  CD2 LEU A  12      38.402  39.428  21.228  1.00 18.34           C  
ATOM    246  N   GLU A  13      39.085  44.859  21.911  1.00 28.10           N  
ATOM    247  CA  GLU A  13      39.778  45.987  22.544  1.00 29.19           C  
ATOM    248  C   GLU A  13      38.945  46.677  23.626  1.00 29.97           C  
ATOM    249  O   GLU A  13      39.497  47.325  24.499  1.00 30.46           O  
ATOM    250  CB  GLU A  13      40.292  46.974  21.488  1.00 27.93           C  
ATOM    251  CG  GLU A  13      39.281  47.878  20.847  1.00 34.20           C  
ATOM    252  CD  GLU A  13      39.857  48.643  19.635  1.00 32.98           C  
ATOM    253  OE1 GLU A  13      41.084  48.575  19.401  1.00 35.27           O  
ATOM    254  OE2 GLU A  13      39.077  49.296  18.906  1.00 37.30           O  
ATOM    255  N   ARG A  14      37.626  46.479  23.587  1.00 31.29           N  
ATOM    256  CA  ARG A  14      36.673  47.119  24.488  1.00 30.71           C  
ATOM    257  C   ARG A  14      36.348  46.299  25.723  1.00 29.03           C  
ATOM    258  O   ARG A  14      35.846  46.853  26.685  1.00 30.65           O  
ATOM    259  CB  ARG A  14      35.351  47.384  23.745  1.00 29.54           C  
ATOM    260  CG  ARG A  14      35.398  48.663  22.958  1.00 35.11           C  
ATOM    261  CD  ARG A  14      34.264  48.791  21.953  1.00 35.78           C  
ATOM    262  NE  ARG A  14      34.281  50.119  21.349  1.00 43.97           N  
ATOM    263  CZ  ARG A  14      35.235  50.581  20.535  1.00 48.97           C  
ATOM    264  NH1 ARG A  14      36.298  49.838  20.177  1.00 46.07           N  
ATOM    265  NH2 ARG A  14      35.131  51.816  20.070  1.00 50.18           N  
ATOM    266  N   THR A  15      36.572  44.988  25.693  1.00 27.89           N  
ATOM    267  CA  THR A  15      36.063  44.112  26.756  1.00 29.41           C  
ATOM    268  C   THR A  15      36.594  44.473  28.146  1.00 30.08           C  
ATOM    269  O   THR A  15      35.800  44.572  29.091  1.00 30.14           O  
ATOM    270  CB  THR A  15      36.285  42.620  26.431  1.00 28.26           C  
ATOM    271  OG1 THR A  15      35.623  42.335  25.190  1.00 29.56           O  
ATOM    272  CG2 THR A  15      35.749  41.681  27.583  1.00 25.01           C  
ATOM    273  N   PRO A  16      37.928  44.683  28.276  1.00 31.01           N  
ATOM    274  CA  PRO A  16      38.457  45.022  29.622  1.00 30.38           C  
ATOM    275  C   PRO A  16      37.860  46.305  30.233  1.00 28.83           C  
ATOM    276  O   PRO A  16      37.402  46.298  31.366  1.00 30.37           O  
ATOM    277  CB  PRO A  16      39.976  45.120  29.394  1.00 30.27           C  
ATOM    278  CG  PRO A  16      40.227  44.278  28.167  1.00 29.40           C  
ATOM    279  CD  PRO A  16      39.020  44.576  27.288  1.00 30.67           C  
ATOM    280  N   LYS A  17      37.829  47.379  29.481  1.00 29.72           N  
ATOM    281  CA  LYS A  17      37.296  48.629  29.973  1.00 30.66           C  
ATOM    282  C   LYS A  17      35.798  48.555  30.257  1.00 29.50           C  
ATOM    283  O   LYS A  17      35.344  49.148  31.232  1.00 27.06           O  
ATOM    284  CB  LYS A  17      37.584  49.761  28.981  1.00 34.26           C  
ATOM    285  CG  LYS A  17      37.219  51.178  29.497  1.00 40.55           C  
ATOM    286  CD  LYS A  17      37.730  51.476  30.960  1.00 53.63           C  
ATOM    287  CE  LYS A  17      38.019  52.976  31.181  1.00 56.94           C  
ATOM    288  NZ  LYS A  17      36.986  53.648  32.056  1.00 64.39           N  
ATOM    289  N   THR A  18      35.051  47.823  29.428  1.00 27.81           N  
ATOM    290  CA  THR A  18      33.614  47.548  29.692  1.00 28.32           C  
ATOM    291  C   THR A  18      33.409  46.806  31.029  1.00 29.10           C  
ATOM    292  O   THR A  18      32.540  47.165  31.827  1.00 27.15           O  
ATOM    293  CB  THR A  18      32.941  46.737  28.501  1.00 30.58           C  
ATOM    294  OG1 THR A  18      33.197  47.390  27.246  1.00 25.98           O  
ATOM    295  CG2 THR A  18      31.432  46.592  28.680  1.00 24.06           C  
ATOM    296  N   LEU A  19      34.205  45.770  31.283  1.00 28.96           N  
ATOM    297  CA  LEU A  19      34.040  45.007  32.522  1.00 30.29           C  
ATOM    298  C   LEU A  19      34.435  45.847  33.751  1.00 30.03           C  
ATOM    299  O   LEU A  19      33.764  45.832  34.802  1.00 30.30           O  
ATOM    300  CB  LEU A  19      34.799  43.657  32.459  1.00 32.10           C  
ATOM    301  CG  LEU A  19      34.195  42.482  31.625  1.00 29.87           C  
ATOM    302  CD1 LEU A  19      35.012  41.239  31.842  1.00 31.78           C  
ATOM    303  CD2 LEU A  19      32.743  42.172  31.934  1.00 24.56           C  
ATOM    304  N   GLU A  20      35.496  46.618  33.608  1.00 29.27           N  
ATOM    305  CA  GLU A  20      35.897  47.533  34.648  1.00 29.73           C  
ATOM    306  C   GLU A  20      34.860  48.664  34.957  1.00 29.45           C  
ATOM    307  O   GLU A  20      34.570  48.936  36.128  1.00 28.63           O  
ATOM    308  CB  GLU A  20      37.261  48.131  34.320  1.00 29.56           C  
ATOM    309  CG  GLU A  20      37.883  48.820  35.525  1.00 39.35           C  
ATOM    310  CD  GLU A  20      38.708  50.010  35.158  1.00 48.74           C  
ATOM    311  OE1 GLU A  20      39.574  49.860  34.245  1.00 53.64           O  
ATOM    312  OE2 GLU A  20      38.473  51.071  35.786  1.00 60.00           O  
ATOM    313  N   VAL A  21      34.294  49.316  33.951  1.00 29.18           N  
ATOM    314  CA  VAL A  21      33.336  50.381  34.230  1.00 31.27           C  
ATOM    315  C   VAL A  21      32.037  49.796  34.817  1.00 30.36           C  
ATOM    316  O   VAL A  21      31.373  50.416  35.617  1.00 31.02           O  
ATOM    317  CB  VAL A  21      33.074  51.256  32.975  1.00 33.79           C  
ATOM    318  CG1 VAL A  21      31.880  50.749  32.210  1.00 38.46           C  
ATOM    319  CG2 VAL A  21      32.861  52.698  33.374  1.00 40.25           C  
ATOM    320  N   PHE A  22      31.719  48.571  34.432  1.00 30.70           N  
ATOM    321  CA  PHE A  22      30.533  47.845  34.909  1.00 30.18           C  
ATOM    322  C   PHE A  22      30.675  47.367  36.357  1.00 29.12           C  
ATOM    323  O   PHE A  22      29.755  47.508  37.142  1.00 28.95           O  
ATOM    324  CB  PHE A  22      30.281  46.630  33.976  1.00 28.92           C  
ATOM    325  CG  PHE A  22      28.982  45.924  34.204  1.00 31.21           C  
ATOM    326  CD1 PHE A  22      27.806  46.629  34.378  1.00 35.99           C  
ATOM    327  CD2 PHE A  22      28.929  44.534  34.193  1.00 36.10           C  
ATOM    328  CE1 PHE A  22      26.598  45.968  34.566  1.00 34.67           C  
ATOM    329  CE2 PHE A  22      27.740  43.881  34.373  1.00 39.30           C  
ATOM    330  CZ  PHE A  22      26.567  44.610  34.563  1.00 36.69           C  
ATOM    331  N   LEU A  23      31.833  46.811  36.698  1.00 28.35           N  
ATOM    332  CA  LEU A  23      32.012  46.086  37.948  1.00 27.82           C  
ATOM    333  C   LEU A  23      32.860  46.762  39.023  1.00 29.89           C  
ATOM    334  O   LEU A  23      32.790  46.359  40.188  1.00 30.04           O  
ATOM    335  CB  LEU A  23      32.660  44.733  37.650  1.00 28.19           C  
ATOM    336  CG  LEU A  23      31.920  43.777  36.726  1.00 25.44           C  
ATOM    337  CD1 LEU A  23      32.813  42.552  36.453  1.00 23.49           C  
ATOM    338  CD2 LEU A  23      30.605  43.393  37.341  1.00 21.91           C  
ATOM    339  N   GLU A  24      33.680  47.735  38.635  1.00 33.56           N  
ATOM    340  CA  GLU A  24      34.595  48.421  39.563  1.00 36.73           C  
ATOM    341  C   GLU A  24      33.799  49.278  40.545  1.00 36.75           C  
ATOM    342  O   GLU A  24      32.983  50.111  40.136  1.00 35.45           O  
ATOM    343  CB  GLU A  24      35.602  49.311  38.806  1.00 36.50           C  
ATOM    344  CG  GLU A  24      36.651  50.053  39.682  1.00 41.75           C  
ATOM    345  CD  GLU A  24      37.970  49.280  39.836  1.00 56.42           C  
ATOM    346  OE1 GLU A  24      37.915  48.232  40.533  1.00 61.46           O  
ATOM    347  OE2 GLU A  24      39.034  49.713  39.281  1.00 57.56           O  
ATOM    348  N   GLY A  25      34.039  49.025  41.832  1.00 36.98           N  
ATOM    349  CA  GLY A  25      33.409  49.764  42.903  1.00 37.10           C  
ATOM    350  C   GLY A  25      32.017  49.292  43.259  1.00 36.75           C  
ATOM    351  O   GLY A  25      31.399  49.862  44.138  1.00 37.87           O  
ATOM    352  N   LEU A  26      31.498  48.268  42.579  1.00 36.19           N  
ATOM    353  CA  LEU A  26      30.285  47.597  43.055  1.00 34.07           C  
ATOM    354  C   LEU A  26      30.624  46.921  44.381  1.00 31.91           C  
ATOM    355  O   LEU A  26      31.777  46.623  44.647  1.00 32.64           O  
ATOM    356  CB  LEU A  26      29.817  46.523  42.066  1.00 33.98           C  
ATOM    357  CG  LEU A  26      29.285  46.911  40.691  1.00 30.77           C  
ATOM    358  CD1 LEU A  26      29.002  45.641  39.886  1.00 22.04           C  
ATOM    359  CD2 LEU A  26      28.044  47.769  40.811  1.00 26.18           C  
ATOM    360  N   SER A  27      29.606  46.682  45.202  0.50 32.26           N  
ATOM    362  CA  SER A  27      29.749  45.871  46.421  0.50 31.23           C  
ATOM    364  C   SER A  27      30.336  44.493  46.102  0.50 31.59           C  
ATOM    366  O   SER A  27      30.126  43.957  45.009  0.50 30.96           O  
ATOM    368  CB  SER A  27      28.393  45.701  47.108  0.50 30.35           C  
ATOM    370  OG  SER A  27      28.429  44.644  48.047  0.50 31.52           O  
ATOM    372  N   ASP A  28      31.061  43.919  47.062  1.00 31.32           N  
ATOM    373  CA  ASP A  28      31.635  42.589  46.890  1.00 32.77           C  
ATOM    374  C   ASP A  28      30.544  41.536  46.642  1.00 31.63           C  
ATOM    375  O   ASP A  28      30.803  40.512  46.017  1.00 33.04           O  
ATOM    376  CB  ASP A  28      32.507  42.192  48.105  1.00 34.22           C  
ATOM    377  CG  ASP A  28      33.183  40.846  47.908  1.00 37.82           C  
ATOM    378  OD1 ASP A  28      33.933  40.734  46.922  1.00 38.27           O  
ATOM    379  OD2 ASP A  28      32.923  39.884  48.681  1.00 45.06           O  
ATOM    380  N   SER A  29      29.336  41.799  47.134  1.00 31.09           N  
ATOM    381  CA  SER A  29      28.169  40.953  46.900  1.00 30.19           C  
ATOM    382  C   SER A  29      27.886  40.696  45.446  1.00 29.08           C  
ATOM    383  O   SER A  29      27.437  39.617  45.077  1.00 29.20           O  
ATOM    384  CB  SER A  29      26.933  41.640  47.433  1.00 29.47           C  
ATOM    385  OG  SER A  29      26.970  41.654  48.830  1.00 42.50           O  
ATOM    386  N   TRP A  30      28.037  41.734  44.639  1.00 28.64           N  
ATOM    387  CA  TRP A  30      27.808  41.607  43.210  1.00 29.27           C  
ATOM    388  C   TRP A  30      28.919  40.748  42.586  1.00 29.30           C  
ATOM    389  O   TRP A  30      28.650  39.963  41.679  1.00 31.79           O  
ATOM    390  CB  TRP A  30      27.765  42.969  42.526  1.00 29.25           C  
ATOM    391  CG  TRP A  30      26.551  43.762  42.783  1.00 27.17           C  
ATOM    392  CD1 TRP A  30      26.489  44.993  43.368  1.00 28.29           C  
ATOM    393  CD2 TRP A  30      25.209  43.403  42.460  1.00 30.73           C  
ATOM    394  NE1 TRP A  30      25.205  45.429  43.415  1.00 28.39           N  
ATOM    395  CE2 TRP A  30      24.387  44.474  42.871  1.00 34.48           C  
ATOM    396  CE3 TRP A  30      24.618  42.277  41.864  1.00 28.42           C  
ATOM    397  CZ2 TRP A  30      23.004  44.454  42.715  1.00 30.10           C  
ATOM    398  CZ3 TRP A  30      23.260  42.255  41.702  1.00 29.34           C  
ATOM    399  CH2 TRP A  30      22.458  43.339  42.125  1.00 32.41           C  
ATOM    400  N   HIS A  31      30.147  40.893  43.091  1.00 27.57           N  
ATOM    401  CA  HIS A  31      31.290  40.179  42.568  1.00 27.98           C  
ATOM    402  C   HIS A  31      31.245  38.676  42.944  1.00 28.08           C  
ATOM    403  O   HIS A  31      31.794  37.860  42.239  1.00 26.25           O  
ATOM    404  CB  HIS A  31      32.594  40.832  43.075  1.00 28.50           C  
ATOM    405  CG  HIS A  31      32.786  42.261  42.647  1.00 26.30           C  
ATOM    406  ND1 HIS A  31      33.577  43.145  43.352  1.00 28.20           N  
ATOM    407  CD2 HIS A  31      32.333  42.946  41.568  1.00 29.25           C  
ATOM    408  CE1 HIS A  31      33.586  44.318  42.737  1.00 29.52           C  
ATOM    409  NE2 HIS A  31      32.841  44.227  41.653  1.00 24.77           N  
ATOM    410  N   GLN A  32      30.605  38.324  44.069  1.00 29.86           N  
ATOM    411  CA  GLN A  32      30.523  36.923  44.527  1.00 30.74           C  
ATOM    412  C   GLN A  32      29.237  36.185  44.059  1.00 31.41           C  
ATOM    413  O   GLN A  32      28.981  35.051  44.434  1.00 31.45           O  
ATOM    414  CB  GLN A  32      30.629  36.849  46.065  1.00 32.24           C  
ATOM    415  CG  GLN A  32      31.835  37.547  46.691  1.00 30.48           C  
ATOM    416  CD  GLN A  32      33.136  37.156  46.053  1.00 35.62           C  
ATOM    417  OE1 GLN A  32      33.287  36.034  45.579  1.00 34.88           O  
ATOM    418  NE2 GLN A  32      34.079  38.098  45.990  1.00 32.97           N  
ATOM    419  N   CYS A  33      28.412  36.820  43.259  0.50 31.90           N  
ATOM    421  CA  CYS A  33      27.222  36.141  42.870  0.50 31.53           C  
ATOM    423  C   CYS A  33      27.531  35.244  41.676  0.50 32.61           C  
ATOM    425  O   CYS A  33      28.429  35.521  40.868  0.50 30.50           O  
ATOM    427  CB  CYS A  33      26.091  37.127  42.603  0.50 31.92           C  
ATOM    429  SG  CYS A  33      26.202  38.014  41.090  0.50 31.18           S  
ATOM    431  N   ASN A  34      26.772  34.150  41.609  1.00 32.52           N  
ATOM    432  CA  ASN A  34      26.885  33.157  40.584  1.00 31.15           C  
ATOM    433  C   ASN A  34      25.511  32.785  40.085  1.00 31.59           C  
ATOM    434  O   ASN A  34      24.537  33.436  40.438  1.00 32.44           O  
ATOM    435  CB  ASN A  34      27.706  31.982  41.095  1.00 31.76           C  
ATOM    436  CG  ASN A  34      27.029  31.181  42.181  1.00 35.43           C  
ATOM    437  OD1 ASN A  34      25.850  31.359  42.491  1.00 30.71           O  
ATOM    438  ND2 ASN A  34      27.781  30.222  42.730  1.00 34.86           N  
ATOM    439  N   GLU A  35      25.434  31.782  39.230  1.00 31.17           N  
ATOM    440  CA  GLU A  35      24.159  31.278  38.720  1.00 31.86           C  
ATOM    441  C   GLU A  35      23.703  30.014  39.473  1.00 32.32           C  
ATOM    442  O   GLU A  35      22.917  29.262  38.953  1.00 34.90           O  
ATOM    443  CB  GLU A  35      24.286  30.939  37.227  1.00 32.06           C  
ATOM    444  CG  GLU A  35      24.290  32.143  36.323  1.00 32.37           C  
ATOM    445  CD  GLU A  35      24.092  31.782  34.873  1.00 31.97           C  
ATOM    446  OE1 GLU A  35      25.113  31.486  34.211  1.00 30.68           O  
ATOM    447  OE2 GLU A  35      22.925  31.825  34.394  1.00 29.02           O  
ATOM    448  N   GLY A  36      24.221  29.788  40.683  1.00 32.01           N  
ATOM    449  CA  GLY A  36      23.835  28.676  41.528  1.00 29.65           C  
ATOM    450  C   GLY A  36      24.981  27.725  41.780  1.00 29.90           C  
ATOM    451  O   GLY A  36      26.098  27.957  41.361  1.00 31.92           O  
ATOM    452  N   TYR A  37      24.679  26.644  42.476  1.00 30.38           N  
ATOM    453  CA  TYR A  37      25.650  25.643  42.873  1.00 31.64           C  
ATOM    454  C   TYR A  37      26.540  25.197  41.754  1.00 32.89           C  
ATOM    455  O   TYR A  37      26.062  24.871  40.655  1.00 30.13           O  
ATOM    456  CB  TYR A  37      24.932  24.422  43.424  1.00 33.32           C  
ATOM    457  CG  TYR A  37      25.818  23.325  43.952  1.00 32.34           C  
ATOM    458  CD1 TYR A  37      26.597  23.530  45.068  1.00 36.66           C  
ATOM    459  CD2 TYR A  37      25.846  22.062  43.350  1.00 34.03           C  
ATOM    460  CE1 TYR A  37      27.386  22.516  45.579  1.00 34.81           C  
ATOM    461  CE2 TYR A  37      26.639  21.054  43.852  1.00 33.16           C  
ATOM    462  CZ  TYR A  37      27.400  21.288  44.970  1.00 37.00           C  
ATOM    463  OH  TYR A  37      28.189  20.290  45.509  1.00 40.77           O  
ATOM    464  N   GLU A  38      27.836  25.152  42.083  1.00 33.72           N  
ATOM    465  CA  GLU A  38      28.916  24.769  41.177  1.00 36.16           C  
ATOM    466  C   GLU A  38      29.060  25.603  39.915  1.00 34.37           C  
ATOM    467  O   GLU A  38      29.600  25.135  38.922  1.00 36.80           O  
ATOM    468  CB  GLU A  38      28.840  23.296  40.841  1.00 34.36           C  
ATOM    469  CG  GLU A  38      29.559  22.428  41.868  1.00 41.98           C  
ATOM    470  CD  GLU A  38      29.327  20.961  41.631  1.00 42.68           C  
ATOM    471  OE1 GLU A  38      28.574  20.604  40.683  1.00 49.22           O  
ATOM    472  OE2 GLU A  38      29.889  20.158  42.401  1.00 59.46           O  
ATOM    473  N   THR A  39      28.616  26.848  39.959  1.00 31.82           N  
ATOM    474  CA  THR A  39      28.894  27.764  38.868  1.00 29.87           C  
ATOM    475  C   THR A  39      29.796  28.839  39.420  1.00 28.74           C  
ATOM    476  O   THR A  39      29.834  29.062  40.622  1.00 27.74           O  
ATOM    477  CB  THR A  39      27.624  28.372  38.281  1.00 30.63           C  
ATOM    478  OG1 THR A  39      27.038  29.249  39.240  1.00 27.24           O  
ATOM    479  CG2 THR A  39      26.620  27.253  37.854  1.00 25.55           C  
ATOM    480  N   TRP A  40      30.522  29.506  38.532  1.00 28.86           N  
ATOM    481  CA  TRP A  40      31.552  30.470  38.913  1.00 26.35           C  
ATOM    482  C   TRP A  40      30.975  31.797  39.338  1.00 26.61           C  
ATOM    483  O   TRP A  40      29.951  32.232  38.799  1.00 25.41           O  
ATOM    484  CB  TRP A  40      32.510  30.715  37.758  1.00 25.89           C  
ATOM    485  CG  TRP A  40      33.315  29.518  37.335  1.00 28.99           C  
ATOM    486  CD1 TRP A  40      33.438  28.332  37.990  1.00 30.08           C  
ATOM    487  CD2 TRP A  40      34.151  29.421  36.183  1.00 28.23           C  
ATOM    488  NE1 TRP A  40      34.286  27.494  37.311  1.00 29.52           N  
ATOM    489  CE2 TRP A  40      34.739  28.139  36.195  1.00 27.28           C  
ATOM    490  CE3 TRP A  40      34.464  30.293  35.137  1.00 33.87           C  
ATOM    491  CZ2 TRP A  40      35.600  27.700  35.196  1.00 28.66           C  
ATOM    492  CZ3 TRP A  40      35.319  29.848  34.148  1.00 31.66           C  
ATOM    493  CH2 TRP A  40      35.868  28.570  34.179  1.00 29.71           C  
ATOM    494  N   THR A  41      31.668  32.452  40.282  1.00 26.24           N  
ATOM    495  CA  THR A  41      31.343  33.808  40.691  1.00 25.45           C  
ATOM    496  C   THR A  41      31.786  34.817  39.602  1.00 26.87           C  
ATOM    497  O   THR A  41      32.635  34.525  38.774  1.00 27.28           O  
ATOM    498  CB  THR A  41      32.059  34.201  41.969  1.00 25.48           C  
ATOM    499  OG1 THR A  41      33.486  34.270  41.716  1.00 25.23           O  
ATOM    500  CG2 THR A  41      31.735  33.208  43.117  1.00 22.52           C  
ATOM    501  N   VAL A  42      31.222  36.011  39.639  1.00 26.04           N  
ATOM    502  CA  VAL A  42      31.621  37.078  38.733  1.00 25.34           C  
ATOM    503  C   VAL A  42      33.149  37.249  38.761  1.00 25.65           C  
ATOM    504  O   VAL A  42      33.806  37.266  37.727  1.00 20.98           O  
ATOM    505  CB  VAL A  42      30.869  38.383  39.087  1.00 25.52           C  
ATOM    506  CG1 VAL A  42      31.520  39.587  38.449  1.00 25.38           C  
ATOM    507  CG2 VAL A  42      29.378  38.261  38.688  1.00 22.17           C  
ATOM    508  N   TYR A  43      33.696  37.307  39.971  1.00 26.53           N  
ATOM    509  CA  TYR A  43      35.132  37.414  40.212  1.00 24.55           C  
ATOM    510  C   TYR A  43      35.893  36.337  39.448  1.00 26.08           C  
ATOM    511  O   TYR A  43      36.854  36.648  38.702  1.00 28.00           O  
ATOM    512  CB  TYR A  43      35.397  37.303  41.720  1.00 24.97           C  
ATOM    513  CG  TYR A  43      36.823  37.519  42.114  1.00 26.11           C  
ATOM    514  CD1 TYR A  43      37.746  36.501  42.022  1.00 28.02           C  
ATOM    515  CD2 TYR A  43      37.252  38.746  42.586  1.00 27.33           C  
ATOM    516  CE1 TYR A  43      39.082  36.711  42.362  1.00 28.30           C  
ATOM    517  CE2 TYR A  43      38.567  38.958  42.928  1.00 30.05           C  
ATOM    518  CZ  TYR A  43      39.480  37.935  42.811  1.00 26.70           C  
ATOM    519  OH  TYR A  43      40.791  38.148  43.155  1.00 28.03           O  
ATOM    520  N   GLU A  44      35.460  35.079  39.636  1.00 25.76           N  
ATOM    521  CA  GLU A  44      36.082  33.901  38.993  1.00 25.42           C  
ATOM    522  C   GLU A  44      36.019  33.926  37.465  1.00 26.27           C  
ATOM    523  O   GLU A  44      36.912  33.410  36.794  1.00 29.01           O  
ATOM    524  CB  GLU A  44      35.475  32.610  39.529  1.00 26.42           C  
ATOM    525  CG  GLU A  44      35.988  32.251  40.944  1.00 26.37           C  
ATOM    526  CD  GLU A  44      35.204  31.119  41.651  1.00 30.02           C  
ATOM    527  OE1 GLU A  44      34.046  30.772  41.239  1.00 29.76           O  
ATOM    528  OE2 GLU A  44      35.747  30.615  42.681  1.00 37.90           O  
ATOM    529  N   VAL A  45      34.974  34.524  36.912  1.00 25.70           N  
ATOM    530  CA  VAL A  45      34.871  34.687  35.461  1.00 26.28           C  
ATOM    531  C   VAL A  45      35.933  35.684  34.960  1.00 26.40           C  
ATOM    532  O   VAL A  45      36.584  35.441  33.962  1.00 24.75           O  
ATOM    533  CB  VAL A  45      33.438  35.082  35.042  1.00 27.10           C  
ATOM    534  CG1 VAL A  45      33.364  35.378  33.554  1.00 23.73           C  
ATOM    535  CG2 VAL A  45      32.452  33.962  35.439  1.00 21.21           C  
ATOM    536  N   VAL A  46      36.110  36.784  35.683  1.00 25.48           N  
ATOM    537  CA  VAL A  46      37.166  37.730  35.386  1.00 26.58           C  
ATOM    538  C   VAL A  46      38.586  37.043  35.518  1.00 26.98           C  
ATOM    539  O   VAL A  46      39.422  37.177  34.637  1.00 26.69           O  
ATOM    540  CB  VAL A  46      37.031  38.994  36.264  1.00 25.78           C  
ATOM    541  CG1 VAL A  46      38.222  39.903  36.067  1.00 25.76           C  
ATOM    542  CG2 VAL A  46      35.707  39.746  35.969  1.00 22.75           C  
ATOM    543  N   VAL A  47      38.819  36.288  36.589  1.00 27.17           N  
ATOM    544  CA  VAL A  47      40.077  35.542  36.746  1.00 26.35           C  
ATOM    545  C   VAL A  47      40.295  34.616  35.523  1.00 26.55           C  
ATOM    546  O   VAL A  47      41.391  34.557  34.980  1.00 27.64           O  
ATOM    547  CB  VAL A  47      40.110  34.796  38.109  1.00 25.15           C  
ATOM    548  CG1 VAL A  47      41.300  33.799  38.237  1.00 23.16           C  
ATOM    549  CG2 VAL A  47      40.175  35.813  39.237  1.00 24.41           C  
ATOM    550  N   HIS A  48      39.240  33.943  35.074  1.00 27.23           N  
ATOM    551  CA  HIS A  48      39.294  33.010  33.923  1.00 26.79           C  
ATOM    552  C   HIS A  48      39.598  33.695  32.607  1.00 26.25           C  
ATOM    553  O   HIS A  48      40.371  33.164  31.801  1.00 27.24           O  
ATOM    554  CB  HIS A  48      37.969  32.254  33.812  1.00 28.64           C  
ATOM    555  CG  HIS A  48      37.756  31.539  32.512  1.00 25.85           C  
ATOM    556  ND1 HIS A  48      38.366  30.343  32.215  1.00 26.45           N  
ATOM    557  CD2 HIS A  48      36.949  31.824  31.460  1.00 24.62           C  
ATOM    558  CE1 HIS A  48      37.958  29.926  31.029  1.00 29.78           C  
ATOM    559  NE2 HIS A  48      37.103  30.811  30.545  1.00 26.74           N  
ATOM    560  N   LEU A  49      39.032  34.879  32.405  1.00 24.48           N  
ATOM    561  CA  LEU A  49      39.311  35.640  31.199  1.00 26.86           C  
ATOM    562  C   LEU A  49      40.785  36.052  31.153  1.00 26.67           C  
ATOM    563  O   LEU A  49      41.388  36.069  30.096  1.00 27.80           O  
ATOM    564  CB  LEU A  49      38.399  36.862  31.089  1.00 25.55           C  
ATOM    565  CG  LEU A  49      36.954  36.615  30.684  1.00 27.38           C  
ATOM    566  CD1 LEU A  49      36.189  37.930  30.877  1.00 24.07           C  
ATOM    567  CD2 LEU A  49      36.809  36.055  29.222  1.00 22.95           C  
ATOM    568  N   ILE A  50      41.359  36.359  32.309  1.00 27.44           N  
ATOM    569  CA  ILE A  50      42.786  36.621  32.422  1.00 27.50           C  
ATOM    570  C   ILE A  50      43.600  35.393  32.003  1.00 28.13           C  
ATOM    571  O   ILE A  50      44.518  35.510  31.195  1.00 29.89           O  
ATOM    572  CB  ILE A  50      43.167  37.086  33.838  1.00 28.05           C  
ATOM    573  CG1 ILE A  50      42.558  38.477  34.106  1.00 28.18           C  
ATOM    574  CG2 ILE A  50      44.699  37.133  34.006  1.00 24.85           C  
ATOM    575  CD1 ILE A  50      42.655  38.927  35.543  1.00 24.59           C  
ATOM    576  N   GLU A  51      43.220  34.228  32.502  1.00 26.47           N  
ATOM    577  CA  GLU A  51      43.879  32.975  32.155  1.00 26.83           C  
ATOM    578  C   GLU A  51      43.846  32.679  30.653  1.00 26.40           C  
ATOM    579  O   GLU A  51      44.847  32.247  30.094  1.00 27.75           O  
ATOM    580  CB  GLU A  51      43.194  31.827  32.900  1.00 26.31           C  
ATOM    581  CG  GLU A  51      43.951  30.515  32.847  1.00 28.89           C  
ATOM    582  CD  GLU A  51      43.326  29.467  33.732  1.00 27.76           C  
ATOM    583  OE1 GLU A  51      43.743  29.381  34.908  1.00 31.78           O  
ATOM    584  OE2 GLU A  51      42.401  28.745  33.268  1.00 32.31           O  
ATOM    585  N   ALA A  52      42.701  32.933  30.009  1.00 25.86           N  
ATOM    586  CA  ALA A  52      42.543  32.758  28.565  1.00 25.34           C  
ATOM    587  C   ALA A  52      43.510  33.624  27.802  1.00 26.85           C  
ATOM    588  O   ALA A  52      43.987  33.239  26.737  1.00 25.86           O  
ATOM    589  CB  ALA A  52      41.129  33.067  28.134  1.00 23.55           C  
ATOM    590  N   GLU A  53      43.798  34.809  28.353  1.00 27.83           N  
ATOM    591  CA  GLU A  53      44.783  35.716  27.750  1.00 27.30           C  
ATOM    592  C   GLU A  53      46.230  35.194  27.833  1.00 27.07           C  
ATOM    593  O   GLU A  53      47.046  35.530  26.992  1.00 26.98           O  
ATOM    594  CB  GLU A  53      44.679  37.130  28.363  1.00 25.89           C  
ATOM    595  CG  GLU A  53      43.358  37.808  28.111  1.00 26.41           C  
ATOM    596  CD  GLU A  53      43.071  38.006  26.637  1.00 27.07           C  
ATOM    597  OE1 GLU A  53      43.843  38.751  26.001  1.00 24.89           O  
ATOM    598  OE2 GLU A  53      42.079  37.428  26.112  1.00 25.13           O  
ATOM    599  N   LYS A  54      46.531  34.391  28.846  1.00 26.72           N  
ATOM    600  CA  LYS A  54      47.867  33.782  29.038  1.00 27.05           C  
ATOM    601  C   LYS A  54      48.039  32.438  28.314  1.00 26.28           C  
ATOM    602  O   LYS A  54      49.118  32.128  27.803  1.00 24.92           O  
ATOM    603  CB  LYS A  54      48.145  33.583  30.550  1.00 26.89           C  
ATOM    604  CG  LYS A  54      48.006  34.861  31.354  1.00 26.00           C  
ATOM    605  CD  LYS A  54      48.234  34.609  32.789  1.00 29.56           C  
ATOM    606  CE  LYS A  54      48.229  35.882  33.616  1.00 37.17           C  
ATOM    607  NZ  LYS A  54      48.377  35.578  35.049  1.00 33.89           N  
ATOM    608  N   THR A  55      46.953  31.673  28.238  1.00 28.22           N  
ATOM    609  CA  THR A  55      47.018  30.250  27.914  1.00 28.61           C  
ATOM    610  C   THR A  55      46.360  29.802  26.623  1.00 27.83           C  
ATOM    611  O   THR A  55      46.716  28.770  26.093  1.00 28.52           O  
ATOM    612  CB  THR A  55      46.427  29.412  29.072  1.00 31.00           C  
ATOM    613  OG1 THR A  55      47.024  28.099  29.059  1.00 36.44           O  
ATOM    614  CG2 THR A  55      44.912  29.340  28.976  1.00 26.55           C  
ATOM    615  N   ASN A  56      45.431  30.591  26.094  1.00 28.75           N  
ATOM    616  CA  ASN A  56      44.505  30.107  25.059  1.00 28.40           C  
ATOM    617  C   ASN A  56      44.713  30.744  23.663  1.00 26.32           C  
ATOM    618  O   ASN A  56      45.367  30.150  22.807  1.00 26.62           O  
ATOM    619  CB  ASN A  56      43.061  30.280  25.587  1.00 27.31           C  
ATOM    620  CG  ASN A  56      42.030  29.618  24.739  1.00 23.98           C  
ATOM    621  OD1 ASN A  56      42.210  29.428  23.522  1.00 27.41           O  
ATOM    622  ND2 ASN A  56      40.911  29.240  25.376  1.00 24.69           N  
ATOM    623  N   TRP A  57      44.189  31.945  23.450  1.00 26.00           N  
ATOM    624  CA  TRP A  57      43.980  32.482  22.078  1.00 27.59           C  
ATOM    625  C   TRP A  57      45.264  32.729  21.269  1.00 26.71           C  
ATOM    626  O   TRP A  57      45.437  32.217  20.162  1.00 28.40           O  
ATOM    627  CB  TRP A  57      43.130  33.750  22.140  1.00 28.58           C  
ATOM    628  CG  TRP A  57      41.877  33.516  22.910  1.00 24.29           C  
ATOM    629  CD1 TRP A  57      41.568  34.024  24.125  1.00 28.33           C  
ATOM    630  CD2 TRP A  57      40.799  32.633  22.553  1.00 27.50           C  
ATOM    631  NE1 TRP A  57      40.374  33.512  24.562  1.00 28.53           N  
ATOM    632  CE2 TRP A  57      39.872  32.670  23.605  1.00 24.21           C  
ATOM    633  CE3 TRP A  57      40.543  31.800  21.449  1.00 26.22           C  
ATOM    634  CZ2 TRP A  57      38.693  31.934  23.584  1.00 29.43           C  
ATOM    635  CZ3 TRP A  57      39.379  31.072  21.420  1.00 26.85           C  
ATOM    636  CH2 TRP A  57      38.458  31.145  22.476  1.00 28.28           C  
ATOM    637  N   ILE A  58      46.174  33.483  21.852  1.00 27.34           N  
ATOM    638  CA  ILE A  58      47.426  33.829  21.176  1.00 26.74           C  
ATOM    639  C   ILE A  58      48.402  32.644  21.080  1.00 25.81           C  
ATOM    640  O   ILE A  58      49.013  32.426  20.030  1.00 27.91           O  
ATOM    641  CB  ILE A  58      48.078  35.083  21.850  1.00 25.28           C  
ATOM    642  CG1 ILE A  58      47.309  36.343  21.430  1.00 27.60           C  
ATOM    643  CG2 ILE A  58      49.545  35.209  21.533  1.00 21.25           C  
ATOM    644  CD1 ILE A  58      47.196  36.585  19.924  1.00 24.44           C  
ATOM    645  N   PRO A  59      48.585  31.888  22.170  1.00 26.68           N  
ATOM    646  CA  PRO A  59      49.423  30.691  22.044  1.00 26.18           C  
ATOM    647  C   PRO A  59      48.934  29.694  20.987  1.00 27.29           C  
ATOM    648  O   PRO A  59      49.758  29.025  20.350  1.00 28.85           O  
ATOM    649  CB  PRO A  59      49.335  30.061  23.444  1.00 26.85           C  
ATOM    650  CG  PRO A  59      49.013  31.205  24.341  1.00 26.21           C  
ATOM    651  CD  PRO A  59      48.117  32.081  23.558  1.00 27.57           C  
ATOM    652  N   ARG A  60      47.615  29.568  20.816  1.00 26.62           N  
ATOM    653  CA  ARG A  60      47.067  28.723  19.750  1.00 26.02           C  
ATOM    654  C   ARG A  60      47.217  29.339  18.350  1.00 24.30           C  
ATOM    655  O   ARG A  60      47.528  28.644  17.372  1.00 22.95           O  
ATOM    656  CB  ARG A  60      45.628  28.341  20.037  1.00 25.32           C  
ATOM    657  CG  ARG A  60      45.541  27.281  21.080  1.00 25.14           C  
ATOM    658  CD  ARG A  60      44.116  26.868  21.359  1.00 27.78           C  
ATOM    659  NE  ARG A  60      44.091  25.557  21.999  1.00 29.32           N  
ATOM    660  CZ  ARG A  60      43.008  24.826  22.227  1.00 26.22           C  
ATOM    661  NH1 ARG A  60      41.802  25.270  21.919  1.00 27.61           N  
ATOM    662  NH2 ARG A  60      43.143  23.626  22.794  1.00 27.95           N  
ATOM    663  N   LEU A  61      47.009  30.636  18.262  1.00 24.79           N  
ATOM    664  CA  LEU A  61      47.278  31.354  17.022  1.00 25.91           C  
ATOM    665  C   LEU A  61      48.722  31.170  16.540  1.00 25.74           C  
ATOM    666  O   LEU A  61      48.951  30.836  15.386  1.00 28.68           O  
ATOM    667  CB  LEU A  61      46.965  32.840  17.215  1.00 26.01           C  
ATOM    668  CG  LEU A  61      47.186  33.787  16.046  1.00 26.95           C  
ATOM    669  CD1 LEU A  61      46.306  33.322  14.830  1.00 21.92           C  
ATOM    670  CD2 LEU A  61      46.941  35.261  16.503  1.00 24.72           C  
ATOM    671  N   ARG A  62      49.686  31.391  17.418  1.00 25.95           N  
ATOM    672  CA  ARG A  62      51.099  31.154  17.089  1.00 27.42           C  
ATOM    673  C   ARG A  62      51.373  29.742  16.576  1.00 27.15           C  
ATOM    674  O   ARG A  62      52.111  29.538  15.610  1.00 27.88           O  
ATOM    675  CB  ARG A  62      51.967  31.372  18.324  1.00 28.06           C  
ATOM    676  CG  ARG A  62      52.060  32.793  18.805  1.00 30.90           C  
ATOM    677  CD  ARG A  62      53.004  32.861  19.960  1.00 31.71           C  
ATOM    678  NE  ARG A  62      53.098  34.178  20.572  1.00 33.57           N  
ATOM    679  CZ  ARG A  62      53.825  35.186  20.096  1.00 37.52           C  
ATOM    680  NH1 ARG A  62      54.499  35.073  18.959  1.00 38.56           N  
ATOM    681  NH2 ARG A  62      53.853  36.326  20.750  1.00 43.29           N  
ATOM    682  N   PHE A  63      50.791  28.759  17.254  1.00 28.97           N  
ATOM    683  CA  PHE A  63      50.953  27.347  16.906  1.00 26.82           C  
ATOM    684  C   PHE A  63      50.379  27.065  15.532  1.00 26.81           C  
ATOM    685  O   PHE A  63      50.985  26.325  14.731  1.00 27.61           O  
ATOM    686  CB  PHE A  63      50.255  26.481  17.950  1.00 27.42           C  
ATOM    687  CG  PHE A  63      50.710  25.053  17.966  1.00 27.56           C  
ATOM    688  CD1 PHE A  63      50.262  24.157  17.005  1.00 24.71           C  
ATOM    689  CD2 PHE A  63      51.557  24.597  18.967  1.00 27.86           C  
ATOM    690  CE1 PHE A  63      50.662  22.844  17.029  1.00 26.94           C  
ATOM    691  CE2 PHE A  63      51.960  23.271  19.008  1.00 26.66           C  
ATOM    692  CZ  PHE A  63      51.522  22.388  18.037  1.00 27.07           C  
ATOM    693  N   ILE A  64      49.218  27.649  15.252  1.00 26.24           N  
ATOM    694  CA  ILE A  64      48.550  27.437  13.959  1.00 26.47           C  
ATOM    695  C   ILE A  64      49.437  27.984  12.844  1.00 27.86           C  
ATOM    696  O   ILE A  64      49.686  27.292  11.846  1.00 27.49           O  
ATOM    697  CB  ILE A  64      47.127  28.089  13.930  1.00 27.58           C  
ATOM    698  CG1 ILE A  64      46.123  27.233  14.717  1.00 25.07           C  
ATOM    699  CG2 ILE A  64      46.633  28.330  12.499  1.00 26.13           C  
ATOM    700  CD1 ILE A  64      44.795  28.019  15.118  1.00 26.69           C  
ATOM    701  N   LEU A  65      49.937  29.210  13.035  1.00 27.86           N  
ATOM    702  CA  LEU A  65      50.718  29.895  12.008  1.00 28.92           C  
ATOM    703  C   LEU A  65      52.091  29.247  11.788  1.00 28.10           C  
ATOM    704  O   LEU A  65      52.537  29.140  10.673  1.00 28.13           O  
ATOM    705  CB  LEU A  65      50.842  31.397  12.312  1.00 28.84           C  
ATOM    706  CG  LEU A  65      49.551  32.237  12.240  1.00 29.16           C  
ATOM    707  CD1 LEU A  65      49.780  33.600  12.868  1.00 25.45           C  
ATOM    708  CD2 LEU A  65      49.002  32.417  10.828  1.00 23.43           C  
ATOM    709  N   GLN A  66      52.707  28.760  12.850  1.00 30.58           N  
ATOM    710  CA  GLN A  66      53.986  28.081  12.778  1.00 32.23           C  
ATOM    711  C   GLN A  66      53.906  26.595  12.350  1.00 31.06           C  
ATOM    712  O   GLN A  66      54.679  26.152  11.521  1.00 28.54           O  
ATOM    713  CB  GLN A  66      54.685  28.200  14.133  1.00 30.80           C  
ATOM    714  CG  GLN A  66      56.163  27.838  14.097  1.00 40.29           C  
ATOM    715  CD  GLN A  66      56.799  27.908  15.471  1.00 40.59           C  
ATOM    716  OE1 GLN A  66      57.168  28.987  15.933  1.00 49.08           O  
ATOM    717  NE2 GLN A  66      56.934  26.741  16.136  1.00 48.33           N  
ATOM    718  N   GLU A  67      52.999  25.824  12.938  1.00 31.52           N  
ATOM    719  CA  GLU A  67      52.978  24.380  12.729  1.00 30.55           C  
ATOM    720  C   GLU A  67      51.994  23.942  11.630  1.00 30.74           C  
ATOM    721  O   GLU A  67      52.141  22.850  11.067  1.00 29.46           O  
ATOM    722  CB  GLU A  67      52.663  23.647  14.050  1.00 30.97           C  
ATOM    723  CG  GLU A  67      53.589  24.017  15.241  1.00 32.47           C  
ATOM    724  CD  GLU A  67      55.022  23.573  15.058  1.00 29.64           C  
ATOM    725  OE1 GLU A  67      55.241  22.579  14.358  1.00 35.59           O  
ATOM    726  OE2 GLU A  67      55.932  24.206  15.626  1.00 38.63           O  
ATOM    727  N   GLY A  68      50.997  24.777  11.324  1.00 31.39           N  
ATOM    728  CA  GLY A  68      49.926  24.373  10.404  1.00 30.84           C  
ATOM    729  C   GLY A  68      49.180  23.104  10.842  1.00 32.14           C  
ATOM    730  O   GLY A  68      49.052  22.839  12.039  1.00 32.67           O  
ATOM    731  N   GLU A  69      48.706  22.321   9.864  1.00 32.45           N  
ATOM    732  CA  GLU A  69      47.918  21.116  10.107  1.00 34.51           C  
ATOM    733  C   GLU A  69      48.751  19.869  10.373  1.00 37.04           C  
ATOM    734  O   GLU A  69      48.193  18.831  10.730  1.00 38.56           O  
ATOM    735  CB  GLU A  69      47.057  20.789   8.894  1.00 34.14           C  
ATOM    736  CG  GLU A  69      46.030  21.814   8.520  1.00 34.45           C  
ATOM    737  CD  GLU A  69      45.212  21.375   7.301  1.00 35.75           C  
ATOM    738  OE1 GLU A  69      45.078  20.148   7.058  1.00 38.62           O  
ATOM    739  OE2 GLU A  69      44.695  22.262   6.585  1.00 37.20           O  
ATOM    740  N   HIS A  70      50.065  19.954  10.165  1.00 38.35           N  
ATOM    741  CA  HIS A  70      50.981  18.845  10.438  1.00 41.30           C  
ATOM    742  C   HIS A  70      50.808  18.251  11.821  1.00 39.18           C  
ATOM    743  O   HIS A  70      51.005  17.071  12.008  1.00 40.19           O  
ATOM    744  CB  HIS A  70      52.445  19.314  10.351  1.00 43.03           C  
ATOM    745  CG  HIS A  70      52.828  19.876   9.019  1.00 51.17           C  
ATOM    746  ND1 HIS A  70      52.930  21.234   8.785  1.00 61.13           N  
ATOM    747  CD2 HIS A  70      53.113  19.269   7.843  1.00 56.08           C  
ATOM    748  CE1 HIS A  70      53.275  21.437   7.526  1.00 60.44           C  
ATOM    749  NE2 HIS A  70      53.391  20.261   6.933  1.00 60.58           N  
ATOM    750  N   LYS A  71      50.472  19.096  12.781  1.00 38.16           N  
ATOM    751  CA  LYS A  71      50.592  18.797  14.189  1.00 38.77           C  
ATOM    752  C   LYS A  71      49.427  19.507  14.880  1.00 36.38           C  
ATOM    753  O   LYS A  71      49.206  20.715  14.672  1.00 35.39           O  
ATOM    754  CB  LYS A  71      51.933  19.375  14.648  1.00 40.42           C  
ATOM    755  CG  LYS A  71      52.394  19.042  16.035  1.00 46.45           C  
ATOM    756  CD  LYS A  71      53.618  19.920  16.454  1.00 44.57           C  
ATOM    757  CE  LYS A  71      54.956  19.377  15.941  1.00 49.73           C  
ATOM    758  NZ  LYS A  71      56.128  20.170  16.453  1.00 52.60           N  
ATOM    759  N   PRO A  72      48.632  18.768  15.665  1.00 35.25           N  
ATOM    760  CA  PRO A  72      47.547  19.452  16.349  1.00 32.67           C  
ATOM    761  C   PRO A  72      48.070  20.223  17.543  1.00 30.55           C  
ATOM    762  O   PRO A  72      49.056  19.800  18.150  1.00 31.79           O  
ATOM    763  CB  PRO A  72      46.608  18.308  16.763  1.00 32.97           C  
ATOM    764  CG  PRO A  72      47.468  17.141  16.891  1.00 33.32           C  
ATOM    765  CD  PRO A  72      48.628  17.316  15.934  1.00 35.69           C  
ATOM    766  N   PHE A  73      47.463  21.373  17.839  1.00 28.42           N  
ATOM    767  CA  PHE A  73      47.844  22.118  19.034  1.00 29.22           C  
ATOM    768  C   PHE A  73      47.335  21.350  20.251  1.00 29.99           C  
ATOM    769  O   PHE A  73      46.372  20.604  20.165  1.00 30.45           O  
ATOM    770  CB  PHE A  73      47.396  23.589  19.040  1.00 27.91           C  
ATOM    771  CG  PHE A  73      45.970  23.829  18.582  1.00 31.42           C  
ATOM    772  CD1 PHE A  73      44.898  23.644  19.452  1.00 27.68           C  
ATOM    773  CD2 PHE A  73      45.705  24.297  17.299  1.00 27.64           C  
ATOM    774  CE1 PHE A  73      43.616  23.905  19.051  1.00 27.03           C  
ATOM    775  CE2 PHE A  73      44.411  24.540  16.895  1.00 30.19           C  
ATOM    776  CZ  PHE A  73      43.372  24.334  17.753  1.00 29.44           C  
ATOM    777  N   PRO A  74      48.015  21.482  21.373  1.00 29.70           N  
ATOM    778  CA  PRO A  74      47.637  20.724  22.566  1.00 30.32           C  
ATOM    779  C   PRO A  74      46.216  21.008  23.090  1.00 29.69           C  
ATOM    780  O   PRO A  74      45.723  22.132  23.000  1.00 30.10           O  
ATOM    781  CB  PRO A  74      48.677  21.164  23.609  1.00 31.53           C  
ATOM    782  CG  PRO A  74      49.732  21.861  22.873  1.00 30.79           C  
ATOM    783  CD  PRO A  74      49.171  22.356  21.596  1.00 31.45           C  
ATOM    784  N   ALA A  75      45.556  19.977  23.608  1.00 31.81           N  
ATOM    785  CA  ALA A  75      44.379  20.166  24.473  1.00 31.95           C  
ATOM    786  C   ALA A  75      44.842  20.791  25.774  1.00 31.78           C  
ATOM    787  O   ALA A  75      46.023  20.694  26.152  1.00 33.77           O  
ATOM    788  CB  ALA A  75      43.681  18.838  24.762  1.00 27.58           C  
ATOM    789  N   PHE A  76      43.903  21.364  26.501  1.00 29.48           N  
ATOM    790  CA  PHE A  76      44.243  22.048  27.750  1.00 29.49           C  
ATOM    791  C   PHE A  76      44.362  21.156  28.987  1.00 31.66           C  
ATOM    792  O   PHE A  76      44.840  21.588  30.046  1.00 31.56           O  
ATOM    793  CB  PHE A  76      43.200  23.095  28.030  1.00 27.53           C  
ATOM    794  CG  PHE A  76      43.176  24.214  27.050  1.00 26.28           C  
ATOM    795  CD1 PHE A  76      44.274  25.068  26.929  1.00 27.47           C  
ATOM    796  CD2 PHE A  76      42.028  24.466  26.293  1.00 20.18           C  
ATOM    797  CE1 PHE A  76      44.252  26.128  26.031  1.00 25.36           C  
ATOM    798  CE2 PHE A  76      41.986  25.528  25.426  1.00 25.05           C  
ATOM    799  CZ  PHE A  76      43.119  26.359  25.283  1.00 25.95           C  
ATOM    800  N   ASP A  77      43.931  19.910  28.853  1.00 34.51           N  
ATOM    801  CA  ASP A  77      43.777  19.028  29.995  1.00 35.63           C  
ATOM    802  C   ASP A  77      45.064  18.366  30.480  1.00 35.64           C  
ATOM    803  O   ASP A  77      45.025  17.536  31.349  1.00 37.99           O  
ATOM    804  CB  ASP A  77      42.695  17.994  29.701  1.00 35.72           C  
ATOM    805  CG  ASP A  77      43.030  17.098  28.517  1.00 38.75           C  
ATOM    806  OD1 ASP A  77      44.156  17.147  27.990  1.00 37.72           O  
ATOM    807  OD2 ASP A  77      42.133  16.333  28.117  1.00 53.43           O  
ATOM    808  N   ARG A  78      46.205  18.743  29.924  0.50 38.82           N  
ATOM    810  CA  ARG A  78      47.484  18.157  30.332  0.50 40.28           C  
ATOM    812  C   ARG A  78      48.436  19.186  30.947  0.50 38.88           C  
ATOM    814  O   ARG A  78      49.587  18.862  31.242  0.50 39.45           O  
ATOM    816  CB  ARG A  78      48.139  17.462  29.128  0.50 41.16           C  
ATOM    818  CG  ARG A  78      47.877  15.956  29.040  0.50 43.28           C  
ATOM    820  CD  ARG A  78      47.846  15.468  27.583  0.50 44.01           C  
ATOM    822  NE  ARG A  78      48.998  15.912  26.794  0.50 41.93           N  
ATOM    824  CZ  ARG A  78      50.214  15.379  26.857  0.50 44.90           C  
ATOM    826  NH1 ARG A  78      50.474  14.377  27.696  0.50 47.38           N  
ATOM    828  NH2 ARG A  78      51.183  15.860  26.082  0.50 41.45           N  
ATOM    830  N   PHE A  79      47.955  20.415  31.136  1.00 37.18           N  
ATOM    831  CA  PHE A  79      48.766  21.506  31.668  1.00 35.90           C  
ATOM    832  C   PHE A  79      47.959  22.227  32.747  1.00 33.94           C  
ATOM    833  O   PHE A  79      47.041  22.956  32.438  1.00 35.24           O  
ATOM    834  CB  PHE A  79      49.072  22.452  30.497  1.00 36.90           C  
ATOM    835  CG  PHE A  79      50.257  23.350  30.699  1.00 30.74           C  
ATOM    836  CD1 PHE A  79      50.108  24.558  31.321  1.00 26.26           C  
ATOM    837  CD2 PHE A  79      51.503  22.997  30.192  1.00 30.49           C  
ATOM    838  CE1 PHE A  79      51.184  25.405  31.481  1.00 33.38           C  
ATOM    839  CE2 PHE A  79      52.592  23.853  30.336  1.00 31.96           C  
ATOM    840  CZ  PHE A  79      52.427  25.058  30.976  1.00 27.11           C  
ATOM    841  N   SER A  80      48.276  21.996  34.006  1.00 33.02           N  
ATOM    842  CA  SER A  80      47.448  22.476  35.104  1.00 33.33           C  
ATOM    843  C   SER A  80      47.816  23.897  35.512  1.00 33.01           C  
ATOM    844  O   SER A  80      48.905  24.354  35.199  1.00 31.09           O  
ATOM    845  CB  SER A  80      47.631  21.569  36.309  1.00 34.16           C  
ATOM    846  OG  SER A  80      48.991  21.572  36.710  1.00 36.58           O  
ATOM    847  N   HIS A  81      46.920  24.573  36.242  1.00 31.29           N  
ATOM    848  CA  HIS A  81      47.224  25.881  36.801  1.00 31.17           C  
ATOM    849  C   HIS A  81      46.836  25.928  38.250  1.00 32.84           C  
ATOM    850  O   HIS A  81      45.848  25.304  38.644  1.00 36.30           O  
ATOM    851  CB  HIS A  81      46.473  27.006  36.060  1.00 29.20           C  
ATOM    852  CG  HIS A  81      46.579  26.925  34.575  1.00 30.44           C  
ATOM    853  ND1 HIS A  81      47.598  27.518  33.871  1.00 30.98           N  
ATOM    854  CD2 HIS A  81      45.824  26.264  33.664  1.00 41.60           C  
ATOM    855  CE1 HIS A  81      47.449  27.257  32.586  1.00 34.84           C  
ATOM    856  NE2 HIS A  81      46.385  26.490  32.433  1.00 31.63           N  
ATOM    857  N   LEU A  82      47.572  26.715  39.032  1.00 32.29           N  
ATOM    858  CA  LEU A  82      47.229  26.899  40.432  1.00 34.24           C  
ATOM    859  C   LEU A  82      45.925  27.654  40.525  1.00 34.38           C  
ATOM    860  O   LEU A  82      45.739  28.654  39.830  1.00 36.03           O  
ATOM    861  CB  LEU A  82      48.335  27.660  41.185  1.00 33.98           C  
ATOM    862  CG  LEU A  82      49.631  26.901  41.490  1.00 38.48           C  
ATOM    863  CD1 LEU A  82      50.714  27.836  42.053  1.00 36.36           C  
ATOM    864  CD2 LEU A  82      49.368  25.770  42.451  1.00 41.46           C  
ATOM    865  N   ASN A  83      45.020  27.166  41.371  1.00 34.91           N  
ATOM    866  CA  ASN A  83      43.825  27.924  41.741  1.00 37.31           C  
ATOM    867  C   ASN A  83      44.286  29.191  42.392  1.00 39.61           C  
ATOM    868  O   ASN A  83      45.207  29.146  43.191  1.00 44.14           O  
ATOM    869  CB  ASN A  83      42.967  27.168  42.750  1.00 36.92           C  
ATOM    870  CG  ASN A  83      42.301  25.970  42.148  1.00 36.04           C  
ATOM    871  OD1 ASN A  83      42.515  25.664  40.978  1.00 37.97           O  
ATOM    872  ND2 ASN A  83      41.500  25.275  42.938  1.00 41.14           N  
ATOM    873  N   GLN A  84      43.659  30.314  42.064  1.00 40.78           N  
ATOM    874  CA  GLN A  84      44.067  31.599  42.609  1.00 41.39           C  
ATOM    875  C   GLN A  84      43.163  32.074  43.703  1.00 41.62           C  
ATOM    876  O   GLN A  84      42.037  31.611  43.853  1.00 45.06           O  
ATOM    877  CB  GLN A  84      44.127  32.650  41.518  1.00 41.46           C  
ATOM    878  CG  GLN A  84      45.007  32.226  40.401  1.00 48.16           C  
ATOM    879  CD  GLN A  84      45.372  33.350  39.545  1.00 53.33           C  
ATOM    880  OE1 GLN A  84      44.941  33.424  38.391  1.00 61.82           O  
ATOM    881  NE2 GLN A  84      46.151  34.279  40.096  1.00 58.52           N  
ATOM    882  N   SER A  85      43.685  33.029  44.456  1.00 43.12           N  
ATOM    883  CA  SER A  85      43.034  33.578  45.630  1.00 43.34           C  
ATOM    884  C   SER A  85      41.964  34.540  45.161  1.00 39.63           C  
ATOM    885  O   SER A  85      42.260  35.401  44.352  1.00 38.44           O  
ATOM    886  CB  SER A  85      44.099  34.310  46.488  1.00 43.98           C  
ATOM    887  OG  SER A  85      43.581  34.768  47.732  1.00 48.95           O  
ATOM    888  N   ASN A  86      40.736  34.376  45.648  1.00 37.39           N  
ATOM    889  CA  ASN A  86      39.749  35.457  45.596  1.00 39.60           C  
ATOM    890  C   ASN A  86      40.108  36.700  46.425  1.00 40.83           C  
ATOM    891  O   ASN A  86      39.402  37.697  46.373  1.00 41.01           O  
ATOM    892  CB  ASN A  86      38.337  34.986  46.004  1.00 44.15           C  
ATOM    893  CG  ASN A  86      38.337  33.809  46.992  1.00 45.60           C  
ATOM    894  N   ALA A  87      41.189  36.646  47.198  1.00 42.48           N  
ATOM    895  CA  ALA A  87      41.545  37.755  48.083  1.00 41.83           C  
ATOM    896  C   ALA A  87      42.225  38.938  47.366  1.00 39.97           C  
ATOM    897  O   ALA A  87      42.224  40.044  47.904  1.00 38.96           O  
ATOM    898  CB  ALA A  87      42.427  37.255  49.244  1.00 42.50           C  
ATOM    899  N   VAL A  88      42.811  38.698  46.183  1.00 37.21           N  
ATOM    900  CA  VAL A  88      43.370  39.775  45.362  1.00 36.18           C  
ATOM    901  C   VAL A  88      42.241  40.735  44.968  1.00 34.33           C  
ATOM    902  O   VAL A  88      41.221  40.329  44.446  1.00 35.12           O  
ATOM    903  CB  VAL A  88      44.130  39.244  44.095  1.00 36.50           C  
ATOM    904  CG1 VAL A  88      44.606  40.408  43.192  1.00 29.26           C  
ATOM    905  CG2 VAL A  88      45.338  38.370  44.514  1.00 32.30           C  
ATOM    906  N   PRO A  89      42.413  42.022  45.239  1.00 32.78           N  
ATOM    907  CA  PRO A  89      41.325  42.915  44.903  1.00 32.24           C  
ATOM    908  C   PRO A  89      40.986  42.897  43.421  1.00 31.76           C  
ATOM    909  O   PRO A  89      41.895  42.901  42.565  1.00 29.66           O  
ATOM    910  CB  PRO A  89      41.862  44.305  45.309  1.00 33.20           C  
ATOM    911  CG  PRO A  89      42.954  44.040  46.291  1.00 32.70           C  
ATOM    912  CD  PRO A  89      43.548  42.727  45.864  1.00 33.73           C  
ATOM    913  N   ILE A  90      39.687  42.899  43.123  1.00 29.51           N  
ATOM    914  CA  ILE A  90      39.226  42.834  41.736  1.00 27.95           C  
ATOM    915  C   ILE A  90      39.825  43.981  40.891  1.00 28.52           C  
ATOM    916  O   ILE A  90      40.099  43.803  39.717  1.00 29.82           O  
ATOM    917  CB  ILE A  90      37.670  42.763  41.633  1.00 26.62           C  
ATOM    918  CG1 ILE A  90      37.245  42.135  40.302  1.00 27.96           C  
ATOM    919  CG2 ILE A  90      37.052  44.128  41.843  1.00 25.82           C  
ATOM    920  CD1 ILE A  90      35.793  41.923  40.139  1.00 25.32           C  
ATOM    921  N   SER A  91      40.081  45.132  41.484  1.00 29.00           N  
ATOM    922  CA  SER A  91      40.717  46.241  40.749  1.00 29.21           C  
ATOM    923  C   SER A  91      42.052  45.827  40.107  1.00 28.90           C  
ATOM    924  O   SER A  91      42.397  46.279  38.997  1.00 26.57           O  
ATOM    925  CB  SER A  91      40.932  47.442  41.696  1.00 30.11           C  
ATOM    926  OG  SER A  91      41.677  47.058  42.856  1.00 38.43           O  
ATOM    927  N   GLU A  92      42.793  44.962  40.807  1.00 28.09           N  
ATOM    928  CA  GLU A  92      44.053  44.435  40.295  1.00 30.51           C  
ATOM    929  C   GLU A  92      43.867  43.507  39.089  1.00 28.39           C  
ATOM    930  O   GLU A  92      44.656  43.537  38.143  1.00 27.89           O  
ATOM    931  CB  GLU A  92      44.831  43.719  41.398  1.00 29.37           C  
ATOM    932  CG  GLU A  92      45.365  44.663  42.453  1.00 35.10           C  
ATOM    933  CD  GLU A  92      46.321  43.976  43.424  1.00 38.17           C  
ATOM    934  OE1 GLU A  92      47.057  43.014  43.036  1.00 41.90           O  
ATOM    935  OE2 GLU A  92      46.340  44.423  44.595  1.00 56.07           O  
ATOM    936  N   ARG A  93      42.805  42.723  39.130  1.00 25.68           N  
ATOM    937  CA  ARG A  93      42.463  41.817  38.049  1.00 27.43           C  
ATOM    938  C   ARG A  93      42.139  42.574  36.797  1.00 26.03           C  
ATOM    939  O   ARG A  93      42.541  42.160  35.735  1.00 27.05           O  
ATOM    940  CB  ARG A  93      41.228  40.974  38.393  1.00 26.86           C  
ATOM    941  CG  ARG A  93      41.317  40.212  39.675  1.00 27.78           C  
ATOM    942  CD  ARG A  93      42.465  39.285  39.628  1.00 27.77           C  
ATOM    943  NE  ARG A  93      42.464  38.320  40.720  1.00 29.80           N  
ATOM    944  CZ  ARG A  93      43.435  37.420  40.880  1.00 31.50           C  
ATOM    945  NH1 ARG A  93      44.430  37.372  40.013  1.00 33.89           N  
ATOM    946  NH2 ARG A  93      43.393  36.534  41.863  1.00 33.56           N  
ATOM    947  N   PHE A  94      41.398  43.671  36.933  1.00 26.53           N  
ATOM    948  CA  PHE A  94      41.028  44.507  35.780  1.00 30.13           C  
ATOM    949  C   PHE A  94      42.241  45.148  35.126  1.00 30.58           C  
ATOM    950  O   PHE A  94      42.313  45.296  33.912  1.00 31.07           O  
ATOM    951  CB  PHE A  94      40.087  45.639  36.203  1.00 29.00           C  
ATOM    952  CG  PHE A  94      38.762  45.178  36.708  1.00 30.34           C  
ATOM    953  CD1 PHE A  94      38.052  44.204  36.045  1.00 34.34           C  
ATOM    954  CD2 PHE A  94      38.214  45.751  37.822  1.00 29.98           C  
ATOM    955  CE1 PHE A  94      36.828  43.801  36.506  1.00 34.14           C  
ATOM    956  CE2 PHE A  94      36.993  45.350  38.285  1.00 35.51           C  
ATOM    957  CZ  PHE A  94      36.297  44.375  37.632  1.00 28.02           C  
ATOM    958  N   LYS A  95      43.179  45.570  35.961  1.00 32.49           N  
ATOM    959  CA  LYS A  95      44.407  46.164  35.469  1.00 33.77           C  
ATOM    960  C   LYS A  95      45.199  45.103  34.679  1.00 31.26           C  
ATOM    961  O   LYS A  95      45.674  45.372  33.580  1.00 30.42           O  
ATOM    962  CB  LYS A  95      45.212  46.712  36.641  1.00 32.07           C  
ATOM    963  CG  LYS A  95      46.370  47.536  36.252  1.00 39.75           C  
ATOM    964  CD  LYS A  95      47.246  47.866  37.443  1.00 40.81           C  
ATOM    965  CE  LYS A  95      48.449  48.728  37.009  1.00 48.04           C  
ATOM    966  NZ  LYS A  95      49.485  48.810  38.100  1.00 56.62           N  
ATOM    967  N   GLU A  96      45.314  43.903  35.246  1.00 29.31           N  
ATOM    968  CA  GLU A  96      45.996  42.803  34.591  1.00 31.10           C  
ATOM    969  C   GLU A  96      45.328  42.412  33.269  1.00 29.97           C  
ATOM    970  O   GLU A  96      46.015  42.208  32.266  1.00 31.17           O  
ATOM    971  CB  GLU A  96      46.105  41.571  35.502  1.00 30.04           C  
ATOM    972  CG  GLU A  96      47.011  40.529  34.904  1.00 32.14           C  
ATOM    973  CD  GLU A  96      47.226  39.306  35.782  1.00 35.40           C  
ATOM    974  OE1 GLU A  96      46.359  38.994  36.628  1.00 35.11           O  
ATOM    975  OE2 GLU A  96      48.274  38.642  35.600  1.00 41.16           O  
ATOM    976  N   PHE A  97      44.003  42.313  33.267  1.00 28.58           N  
ATOM    977  CA  PHE A  97      43.250  41.915  32.059  1.00 28.46           C  
ATOM    978  C   PHE A  97      43.431  42.923  30.904  1.00 28.26           C  
ATOM    979  O   PHE A  97      43.597  42.545  29.732  1.00 27.88           O  
ATOM    980  CB  PHE A  97      41.755  41.702  32.416  1.00 26.31           C  
ATOM    981  CG  PHE A  97      40.887  41.256  31.245  1.00 26.44           C  
ATOM    982  CD1 PHE A  97      41.328  40.292  30.345  1.00 26.11           C  
ATOM    983  CD2 PHE A  97      39.610  41.778  31.078  1.00 26.93           C  
ATOM    984  CE1 PHE A  97      40.543  39.891  29.273  1.00 26.62           C  
ATOM    985  CE2 PHE A  97      38.796  41.382  29.989  1.00 31.32           C  
ATOM    986  CZ  PHE A  97      39.258  40.432  29.086  1.00 25.16           C  
ATOM    987  N   GLN A  98      43.403  44.207  31.246  1.00 29.04           N  
ATOM    988  CA  GLN A  98      43.569  45.266  30.260  1.00 28.94           C  
ATOM    989  C   GLN A  98      44.989  45.243  29.696  1.00 28.15           C  
ATOM    990  O   GLN A  98      45.199  45.418  28.491  1.00 28.60           O  
ATOM    991  CB  GLN A  98      43.238  46.648  30.889  1.00 28.76           C  
ATOM    992  CG  GLN A  98      43.538  47.866  29.988  1.00 33.58           C  
ATOM    993  CD  GLN A  98      42.709  47.882  28.656  1.00 52.55           C  
ATOM    994  OE1 GLN A  98      41.742  48.672  28.526  1.00 44.70           O  
ATOM    995  NE2 GLN A  98      43.097  47.010  27.662  1.00 35.28           N  
ATOM    996  N   GLN A  99      45.966  45.032  30.561  1.00 28.67           N  
ATOM    997  CA  GLN A  99      47.347  44.955  30.110  1.00 29.36           C  
ATOM    998  C   GLN A  99      47.567  43.776  29.173  1.00 28.20           C  
ATOM    999  O   GLN A  99      48.221  43.920  28.113  1.00 28.72           O  
ATOM   1000  CB  GLN A  99      48.326  44.903  31.299  1.00 29.90           C  
ATOM   1001  CG  GLN A  99      49.806  44.767  30.901  1.00 34.73           C  
ATOM   1002  CD  GLN A  99      50.305  45.929  29.981  1.00 51.74           C  
ATOM   1003  OE1 GLN A  99      49.925  47.089  30.169  1.00 55.21           O  
ATOM   1004  NE2 GLN A  99      51.146  45.600  28.985  1.00 50.15           N  
ATOM   1005  N   LEU A 100      47.055  42.608  29.559  1.00 25.94           N  
ATOM   1006  CA  LEU A 100      47.272  41.397  28.780  1.00 26.03           C  
ATOM   1007  C   LEU A 100      46.534  41.461  27.451  1.00 28.16           C  
ATOM   1008  O   LEU A 100      47.044  40.996  26.415  1.00 27.67           O  
ATOM   1009  CB  LEU A 100      46.818  40.170  29.550  1.00 27.64           C  
ATOM   1010  CG  LEU A 100      47.698  39.715  30.715  1.00 29.22           C  
ATOM   1011  CD1 LEU A 100      46.944  38.724  31.588  1.00 22.52           C  
ATOM   1012  CD2 LEU A 100      49.017  39.126  30.193  1.00 22.15           C  
ATOM   1013  N   ARG A 101      45.330  42.040  27.474  1.00 28.54           N  
ATOM   1014  CA  ARG A 101      44.555  42.186  26.241  1.00 28.48           C  
ATOM   1015  C   ARG A 101      45.255  43.161  25.271  1.00 27.89           C  
ATOM   1016  O   ARG A 101      45.322  42.929  24.062  1.00 26.38           O  
ATOM   1017  CB  ARG A 101      43.112  42.608  26.561  1.00 27.26           C  
ATOM   1018  CG  ARG A 101      42.232  42.799  25.341  1.00 26.30           C  
ATOM   1019  CD  ARG A 101      42.170  41.574  24.440  1.00 24.94           C  
ATOM   1020  NE  ARG A 101      41.583  40.436  25.125  1.00 23.02           N  
ATOM   1021  CZ  ARG A 101      40.280  40.183  25.209  1.00 27.06           C  
ATOM   1022  NH1 ARG A 101      39.385  40.992  24.668  1.00 23.68           N  
ATOM   1023  NH2 ARG A 101      39.860  39.091  25.845  1.00 29.54           N  
ATOM   1024  N   LYS A 102      45.775  44.251  25.810  1.00 27.35           N  
ATOM   1025  CA  LYS A 102      46.441  45.231  25.011  1.00 29.95           C  
ATOM   1026  C   LYS A 102      47.641  44.601  24.294  1.00 29.33           C  
ATOM   1027  O   LYS A 102      47.771  44.736  23.072  1.00 31.48           O  
ATOM   1028  CB  LYS A 102      46.853  46.418  25.900  1.00 31.28           C  
ATOM   1029  CG  LYS A 102      47.759  47.455  25.229  1.00 36.92           C  
ATOM   1030  CD  LYS A 102      48.009  48.689  26.130  1.00 35.40           C  
ATOM   1031  CE  LYS A 102      48.921  49.723  25.433  1.00 45.23           C  
ATOM   1032  NZ  LYS A 102      50.390  49.550  25.759  1.00 52.30           N  
ATOM   1033  N   GLU A 103      48.511  43.929  25.053  1.00 29.14           N  
ATOM   1034  CA  GLU A 103      49.629  43.139  24.505  1.00 30.31           C  
ATOM   1035  C   GLU A 103      49.208  42.125  23.439  1.00 28.68           C  
ATOM   1036  O   GLU A 103      49.795  42.052  22.367  1.00 27.31           O  
ATOM   1037  CB  GLU A 103      50.325  42.378  25.622  1.00 30.08           C  
ATOM   1038  CG  GLU A 103      51.201  43.225  26.544  1.00 39.16           C  
ATOM   1039  CD  GLU A 103      51.625  42.505  27.846  1.00 38.83           C  
ATOM   1040  OE1 GLU A 103      51.440  41.264  27.968  1.00 50.76           O  
ATOM   1041  OE2 GLU A 103      52.144  43.203  28.751  1.00 47.51           O  
ATOM   1042  N   ASN A 104      48.155  41.366  23.736  1.00 28.00           N  
ATOM   1043  CA  ASN A 104      47.663  40.318  22.849  1.00 26.48           C  
ATOM   1044  C   ASN A 104      47.103  40.812  21.511  1.00 26.40           C  
ATOM   1045  O   ASN A 104      47.205  40.122  20.467  1.00 25.30           O  
ATOM   1046  CB  ASN A 104      46.606  39.482  23.592  1.00 28.35           C  
ATOM   1047  CG  ASN A 104      47.217  38.474  24.517  1.00 27.83           C  
ATOM   1048  OD1 ASN A 104      48.394  38.166  24.398  1.00 27.00           O  
ATOM   1049  ND2 ASN A 104      46.422  37.936  25.434  1.00 26.86           N  
ATOM   1050  N   LEU A 105      46.512  41.999  21.532  1.00 25.22           N  
ATOM   1051  CA  LEU A 105      46.041  42.638  20.293  1.00 26.51           C  
ATOM   1052  C   LEU A 105      47.206  43.184  19.409  1.00 25.33           C  
ATOM   1053  O   LEU A 105      47.149  43.130  18.188  1.00 22.77           O  
ATOM   1054  CB  LEU A 105      45.002  43.720  20.629  1.00 27.22           C  
ATOM   1055  CG  LEU A 105      43.660  43.249  21.185  1.00 27.65           C  
ATOM   1056  CD1 LEU A 105      42.745  44.464  21.478  1.00 22.92           C  
ATOM   1057  CD2 LEU A 105      43.017  42.294  20.173  1.00 23.51           C  
ATOM   1058  N   ASN A 106      48.274  43.673  20.030  1.00 26.57           N  
ATOM   1059  CA  ASN A 106      49.515  43.945  19.292  1.00 26.43           C  
ATOM   1060  C   ASN A 106      50.089  42.702  18.624  1.00 27.02           C  
ATOM   1061  O   ASN A 106      50.326  42.704  17.430  1.00 27.40           O  
ATOM   1062  CB  ASN A 106      50.568  44.570  20.206  1.00 27.65           C  
ATOM   1063  CG  ASN A 106      50.240  46.006  20.582  1.00 28.18           C  
ATOM   1064  OD1 ASN A 106      49.428  46.672  19.937  1.00 36.22           O  
ATOM   1065  ND2 ASN A 106      50.870  46.486  21.626  1.00 27.77           N  
ATOM   1066  N   THR A 107      50.300  41.632  19.392  1.00 27.73           N  
ATOM   1067  CA  THR A 107      50.707  40.356  18.815  1.00 26.10           C  
ATOM   1068  C   THR A 107      49.794  39.900  17.660  1.00 27.56           C  
ATOM   1069  O   THR A 107      50.283  39.429  16.623  1.00 27.42           O  
ATOM   1070  CB  THR A 107      50.739  39.253  19.866  1.00 26.16           C  
ATOM   1071  OG1 THR A 107      51.512  39.695  20.980  1.00 21.34           O  
ATOM   1072  CG2 THR A 107      51.349  37.978  19.272  1.00 22.23           C  
ATOM   1073  N   LEU A 108      48.477  40.012  17.840  1.00 27.28           N  
ATOM   1074  CA  LEU A 108      47.531  39.571  16.796  1.00 27.27           C  
ATOM   1075  C   LEU A 108      47.824  40.295  15.490  1.00 28.31           C  
ATOM   1076  O   LEU A 108      47.888  39.674  14.418  1.00 27.67           O  
ATOM   1077  CB  LEU A 108      46.067  39.805  17.231  1.00 28.26           C  
ATOM   1078  CG  LEU A 108      44.919  39.755  16.220  1.00 25.38           C  
ATOM   1079  CD1 LEU A 108      44.909  38.392  15.560  1.00 24.87           C  
ATOM   1080  CD2 LEU A 108      43.601  40.027  16.985  1.00 20.44           C  
ATOM   1081  N   ARG A 109      48.013  41.609  15.585  1.00 29.56           N  
ATOM   1082  CA  ARG A 109      48.292  42.428  14.402  1.00 29.52           C  
ATOM   1083  C   ARG A 109      49.652  42.129  13.773  1.00 29.80           C  
ATOM   1084  O   ARG A 109      49.808  42.318  12.581  1.00 35.24           O  
ATOM   1085  CB  ARG A 109      48.227  43.900  14.746  1.00 28.13           C  
ATOM   1086  CG  ARG A 109      46.849  44.401  15.098  1.00 30.59           C  
ATOM   1087  CD  ARG A 109      46.954  45.872  15.591  1.00 32.22           C  
ATOM   1088  NE  ARG A 109      45.759  46.183  16.341  1.00 40.89           N  
ATOM   1089  CZ  ARG A 109      45.691  46.492  17.633  1.00 35.86           C  
ATOM   1090  NH1 ARG A 109      46.779  46.623  18.397  1.00 31.64           N  
ATOM   1091  NH2 ARG A 109      44.486  46.701  18.149  1.00 41.54           N  
ATOM   1092  N   SER A 110      50.626  41.696  14.570  1.00 28.18           N  
ATOM   1093  CA  SER A 110      51.928  41.261  14.075  1.00 29.38           C  
ATOM   1094  C   SER A 110      51.800  39.993  13.298  1.00 27.96           C  
ATOM   1095  O   SER A 110      52.382  39.866  12.229  1.00 29.40           O  
ATOM   1096  CB  SER A 110      52.922  41.016  15.229  1.00 29.67           C  
ATOM   1097  OG  SER A 110      53.254  42.248  15.859  1.00 39.46           O  
ATOM   1098  N   LEU A 111      51.029  39.052  13.839  1.00 29.41           N  
ATOM   1099  CA  LEU A 111      50.924  37.699  13.258  1.00 29.68           C  
ATOM   1100  C   LEU A 111      49.932  37.600  12.111  1.00 29.02           C  
ATOM   1101  O   LEU A 111      50.217  36.938  11.122  1.00 29.88           O  
ATOM   1102  CB  LEU A 111      50.557  36.664  14.316  1.00 28.42           C  
ATOM   1103  CG  LEU A 111      51.545  36.549  15.465  1.00 31.22           C  
ATOM   1104  CD1 LEU A 111      50.939  35.683  16.563  1.00 26.11           C  
ATOM   1105  CD2 LEU A 111      52.898  36.022  15.016  1.00 29.55           C  
ATOM   1106  N   VAL A 112      48.760  38.220  12.261  1.00 28.84           N  
ATOM   1107  CA  VAL A 112      47.735  38.184  11.236  1.00 27.53           C  
ATOM   1108  C   VAL A 112      47.667  39.528  10.516  1.00 28.75           C  
ATOM   1109  O   VAL A 112      47.068  40.479  11.007  1.00 29.24           O  
ATOM   1110  CB  VAL A 112      46.358  37.852  11.823  1.00 28.73           C  
ATOM   1111  CG1 VAL A 112      45.281  37.848  10.689  1.00 22.57           C  
ATOM   1112  CG2 VAL A 112      46.410  36.516  12.551  1.00 22.73           C  
ATOM   1113  N   GLN A 113      48.261  39.582   9.329  1.00 29.65           N  
ATOM   1114  CA  GLN A 113      48.460  40.850   8.611  1.00 31.39           C  
ATOM   1115  C   GLN A 113      47.661  40.979   7.329  1.00 32.17           C  
ATOM   1116  O   GLN A 113      47.446  42.090   6.849  1.00 32.79           O  
ATOM   1117  CB  GLN A 113      49.936  41.022   8.279  1.00 31.95           C  
ATOM   1118  CG  GLN A 113      50.868  41.017   9.500  1.00 34.18           C  
ATOM   1119  CD  GLN A 113      52.156  41.758   9.223  1.00 35.37           C  
ATOM   1120  OE1 GLN A 113      52.725  41.632   8.142  1.00 45.26           O  
ATOM   1121  NE2 GLN A 113      52.610  42.561  10.187  1.00 41.05           N  
ATOM   1122  N   SER A 114      47.212  39.845   6.784  1.00 33.82           N  
ATOM   1123  CA  SER A 114      46.421  39.819   5.552  1.00 32.83           C  
ATOM   1124  C   SER A 114      45.206  38.935   5.712  1.00 31.19           C  
ATOM   1125  O   SER A 114      45.168  38.079   6.580  1.00 30.60           O  
ATOM   1126  CB  SER A 114      47.258  39.275   4.393  1.00 33.17           C  
ATOM   1127  OG  SER A 114      47.527  37.890   4.571  1.00 37.72           O  
ATOM   1128  N   GLU A 115      44.224  39.157   4.853  1.00 29.64           N  
ATOM   1129  CA  GLU A 115      43.116  38.244   4.672  1.00 30.45           C  
ATOM   1130  C   GLU A 115      43.573  36.796   4.420  1.00 30.66           C  
ATOM   1131  O   GLU A 115      42.915  35.851   4.850  1.00 30.59           O  
ATOM   1132  CB  GLU A 115      42.340  38.684   3.440  1.00 32.11           C  
ATOM   1133  CG  GLU A 115      41.631  40.011   3.550  1.00 39.35           C  
ATOM   1134  CD  GLU A 115      40.147  39.829   3.723  1.00 46.57           C  
ATOM   1135  OE1 GLU A 115      39.760  39.163   4.727  1.00 43.24           O  
ATOM   1136  OE2 GLU A 115      39.396  40.348   2.848  1.00 51.26           O  
ATOM   1137  N   ALA A 116      44.659  36.613   3.665  1.00 29.43           N  
ATOM   1138  CA  ALA A 116      45.197  35.273   3.446  1.00 30.05           C  
ATOM   1139  C   ALA A 116      45.559  34.592   4.782  1.00 29.05           C  
ATOM   1140  O   ALA A 116      45.364  33.402   4.926  1.00 29.65           O  
ATOM   1141  CB  ALA A 116      46.398  35.303   2.502  1.00 29.08           C  
ATOM   1142  N   ASP A 117      46.046  35.352   5.759  1.00 29.49           N  
ATOM   1143  CA  ASP A 117      46.453  34.773   7.066  1.00 30.82           C  
ATOM   1144  C   ASP A 117      45.268  34.215   7.886  1.00 30.70           C  
ATOM   1145  O   ASP A 117      45.426  33.296   8.696  1.00 28.48           O  
ATOM   1146  CB  ASP A 117      47.243  35.795   7.909  1.00 30.99           C  
ATOM   1147  CG  ASP A 117      48.600  36.170   7.290  1.00 34.71           C  
ATOM   1148  OD1 ASP A 117      49.222  35.334   6.571  1.00 39.61           O  
ATOM   1149  OD2 ASP A 117      49.058  37.299   7.557  1.00 38.97           O  
ATOM   1150  N   LEU A 118      44.092  34.792   7.649  1.00 29.95           N  
ATOM   1151  CA  LEU A 118      42.857  34.337   8.242  1.00 29.65           C  
ATOM   1152  C   LEU A 118      42.416  32.931   7.744  1.00 30.15           C  
ATOM   1153  O   LEU A 118      41.739  32.188   8.470  1.00 28.68           O  
ATOM   1154  CB  LEU A 118      41.763  35.380   7.960  1.00 29.17           C  
ATOM   1155  CG  LEU A 118      41.925  36.742   8.650  1.00 29.52           C  
ATOM   1156  CD1 LEU A 118      40.904  37.706   8.116  1.00 25.25           C  
ATOM   1157  CD2 LEU A 118      41.749  36.622  10.170  1.00 30.13           C  
ATOM   1158  N   GLU A 119      42.787  32.583   6.509  1.00 29.68           N  
ATOM   1159  CA  GLU A 119      42.381  31.312   5.879  1.00 29.60           C  
ATOM   1160  C   GLU A 119      43.374  30.183   6.178  1.00 29.77           C  
ATOM   1161  O   GLU A 119      43.203  29.038   5.723  1.00 30.49           O  
ATOM   1162  CB  GLU A 119      42.235  31.500   4.354  1.00 29.98           C  
ATOM   1163  CG  GLU A 119      41.120  32.503   3.929  1.00 32.79           C  
ATOM   1164  CD  GLU A 119      39.750  32.218   4.578  1.00 35.95           C  
ATOM   1165  OE1 GLU A 119      39.250  31.066   4.499  1.00 36.16           O  
ATOM   1166  OE2 GLU A 119      39.173  33.173   5.164  1.00 46.69           O  
ATOM   1167  N   ARG A 120      44.395  30.517   6.956  1.00 29.05           N  
ATOM   1168  CA  ARG A 120      45.373  29.556   7.416  1.00 28.72           C  
ATOM   1169  C   ARG A 120      44.808  28.587   8.424  1.00 28.84           C  
ATOM   1170  O   ARG A 120      44.036  28.955   9.319  1.00 28.99           O  
ATOM   1171  CB  ARG A 120      46.620  30.265   7.917  1.00 29.20           C  
ATOM   1172  CG  ARG A 120      47.267  30.915   6.680  1.00 35.82           C  
ATOM   1173  CD  ARG A 120      48.504  31.627   6.941  1.00 40.50           C  
ATOM   1174  NE  ARG A 120      49.504  30.757   7.510  1.00 42.20           N  
ATOM   1175  CZ  ARG A 120      50.734  31.160   7.778  1.00 41.58           C  
ATOM   1176  NH1 ARG A 120      51.109  32.404   7.493  1.00 42.95           N  
ATOM   1177  NH2 ARG A 120      51.580  30.309   8.329  1.00 43.22           N  
ATOM   1178  N   THR A 121      45.185  27.332   8.220  1.00 27.42           N  
ATOM   1179  CA  THR A 121      44.613  26.219   8.909  1.00 28.22           C  
ATOM   1180  C   THR A 121      45.644  25.537   9.812  1.00 27.84           C  
ATOM   1181  O   THR A 121      46.834  25.412   9.480  1.00 24.28           O  
ATOM   1182  CB  THR A 121      44.071  25.177   7.911  1.00 31.07           C  
ATOM   1183  OG1 THR A 121      45.149  24.717   7.080  1.00 33.98           O  
ATOM   1184  CG2 THR A 121      42.958  25.769   7.030  1.00 26.51           C  
ATOM   1185  N   GLY A 122      45.138  25.142  10.976  1.00 27.91           N  
ATOM   1186  CA  GLY A 122      45.793  24.244  11.884  1.00 27.93           C  
ATOM   1187  C   GLY A 122      44.849  23.117  12.254  1.00 27.24           C  
ATOM   1188  O   GLY A 122      43.837  22.898  11.572  1.00 25.35           O  
ATOM   1189  N   ALA A 123      45.192  22.422  13.343  1.00 26.70           N  
ATOM   1190  CA  ALA A 123      44.544  21.167  13.734  1.00 26.74           C  
ATOM   1191  C   ALA A 123      44.207  21.177  15.213  1.00 27.97           C  
ATOM   1192  O   ALA A 123      45.095  21.155  16.076  1.00 29.70           O  
ATOM   1193  CB  ALA A 123      45.435  19.971  13.407  1.00 23.94           C  
ATOM   1194  N   HIS A 124      42.909  21.229  15.499  1.00 28.07           N  
ATOM   1195  CA  HIS A 124      42.396  21.045  16.849  1.00 27.75           C  
ATOM   1196  C   HIS A 124      42.507  19.570  17.210  1.00 27.36           C  
ATOM   1197  O   HIS A 124      42.188  18.715  16.402  1.00 27.54           O  
ATOM   1198  CB  HIS A 124      40.951  21.504  16.935  1.00 27.67           C  
ATOM   1199  CG  HIS A 124      40.418  21.587  18.333  1.00 26.63           C  
ATOM   1200  ND1 HIS A 124      40.082  20.473  19.071  1.00 24.48           N  
ATOM   1201  CD2 HIS A 124      40.160  22.658  19.123  1.00 26.51           C  
ATOM   1202  CE1 HIS A 124      39.645  20.856  20.258  1.00 30.56           C  
ATOM   1203  NE2 HIS A 124      39.673  22.178  20.310  1.00 27.69           N  
ATOM   1204  N   PRO A 125      42.984  19.264  18.435  1.00 29.28           N  
ATOM   1205  CA  PRO A 125      43.234  17.848  18.780  1.00 27.92           C  
ATOM   1206  C   PRO A 125      41.978  16.943  18.768  1.00 27.42           C  
ATOM   1207  O   PRO A 125      42.111  15.744  18.682  1.00 31.88           O  
ATOM   1208  CB  PRO A 125      43.865  17.934  20.173  1.00 28.52           C  
ATOM   1209  CG  PRO A 125      43.373  19.286  20.737  1.00 26.63           C  
ATOM   1210  CD  PRO A 125      43.315  20.184  19.544  1.00 26.06           C  
ATOM   1211  N   ALA A 126      40.782  17.514  18.808  1.00 28.55           N  
ATOM   1212  CA  ALA A 126      39.538  16.752  18.704  1.00 27.91           C  
ATOM   1213  C   ALA A 126      38.675  17.165  17.487  1.00 27.80           C  
ATOM   1214  O   ALA A 126      38.104  16.320  16.806  1.00 28.40           O  
ATOM   1215  CB  ALA A 126      38.745  16.920  20.008  1.00 26.75           C  
ATOM   1216  N   PHE A 127      38.594  18.458  17.201  1.00 27.14           N  
ATOM   1217  CA  PHE A 127      37.704  18.945  16.153  1.00 26.99           C  
ATOM   1218  C   PHE A 127      38.268  18.845  14.737  1.00 27.47           C  
ATOM   1219  O   PHE A 127      37.524  19.007  13.786  1.00 31.35           O  
ATOM   1220  CB  PHE A 127      37.339  20.416  16.367  1.00 28.40           C  
ATOM   1221  CG  PHE A 127      36.866  20.756  17.759  1.00 29.55           C  
ATOM   1222  CD1 PHE A 127      36.411  19.772  18.635  1.00 24.00           C  
ATOM   1223  CD2 PHE A 127      36.842  22.093  18.168  1.00 25.64           C  
ATOM   1224  CE1 PHE A 127      35.980  20.098  19.899  1.00 27.72           C  
ATOM   1225  CE2 PHE A 127      36.403  22.420  19.411  1.00 27.30           C  
ATOM   1226  CZ  PHE A 127      35.969  21.413  20.294  1.00 26.09           C  
ATOM   1227  N   GLY A 128      39.564  18.636  14.573  1.00 27.91           N  
ATOM   1228  CA  GLY A 128      40.145  18.566  13.223  1.00 27.96           C  
ATOM   1229  C   GLY A 128      40.544  19.938  12.699  1.00 27.46           C  
ATOM   1230  O   GLY A 128      40.871  20.812  13.483  1.00 27.86           O  
ATOM   1231  N   VAL A 129      40.542  20.114  11.378  1.00 27.31           N  
ATOM   1232  CA  VAL A 129      41.022  21.363  10.751  1.00 29.32           C  
ATOM   1233  C   VAL A 129      40.233  22.590  11.231  1.00 29.58           C  
ATOM   1234  O   VAL A 129      39.004  22.591  11.264  1.00 31.26           O  
ATOM   1235  CB  VAL A 129      41.013  21.322   9.190  1.00 30.16           C  
ATOM   1236  CG1 VAL A 129      41.738  22.553   8.613  1.00 26.45           C  
ATOM   1237  CG2 VAL A 129      41.686  20.031   8.674  1.00 29.74           C  
ATOM   1238  N   VAL A 130      40.966  23.615  11.645  1.00 28.49           N  
ATOM   1239  CA  VAL A 130      40.392  24.879  12.030  1.00 27.24           C  
ATOM   1240  C   VAL A 130      41.166  25.978  11.306  1.00 28.42           C  
ATOM   1241  O   VAL A 130      42.377  25.838  11.039  1.00 25.80           O  
ATOM   1242  CB  VAL A 130      40.432  25.091  13.579  1.00 27.88           C  
ATOM   1243  CG1 VAL A 130      39.535  24.056  14.299  1.00 24.99           C  
ATOM   1244  CG2 VAL A 130      41.861  25.029  14.118  1.00 22.79           C  
ATOM   1245  N   LYS A 131      40.451  27.064  11.001  1.00 28.51           N  
ATOM   1246  CA  LYS A 131      41.016  28.259  10.418  1.00 27.95           C  
ATOM   1247  C   LYS A 131      41.303  29.316  11.469  1.00 29.07           C  
ATOM   1248  O   LYS A 131      40.691  29.328  12.544  1.00 27.76           O  
ATOM   1249  CB  LYS A 131      40.052  28.852   9.402  1.00 30.37           C  
ATOM   1250  CG  LYS A 131      40.015  28.074   8.116  1.00 33.35           C  
ATOM   1251  CD  LYS A 131      38.793  28.387   7.314  1.00 40.39           C  
ATOM   1252  CE  LYS A 131      38.482  27.219   6.346  1.00 52.62           C  
ATOM   1253  NZ  LYS A 131      38.279  25.874   7.062  1.00 53.88           N  
ATOM   1254  N   VAL A 132      42.230  30.209  11.132  1.00 27.89           N  
ATOM   1255  CA  VAL A 132      42.574  31.335  11.976  1.00 26.47           C  
ATOM   1256  C   VAL A 132      41.333  32.172  12.288  1.00 27.51           C  
ATOM   1257  O   VAL A 132      41.110  32.523  13.462  1.00 27.77           O  
ATOM   1258  CB  VAL A 132      43.759  32.171  11.366  1.00 27.91           C  
ATOM   1259  CG1 VAL A 132      43.902  33.535  12.031  1.00 21.90           C  
ATOM   1260  CG2 VAL A 132      45.080  31.366  11.463  1.00 20.11           C  
ATOM   1261  N   ARG A 133      40.513  32.450  11.269  0.50 25.38           N  
ATOM   1263  CA  ARG A 133      39.274  33.235  11.457  0.50 24.95           C  
ATOM   1265  C   ARG A 133      38.311  32.575  12.450  0.50 25.29           C  
ATOM   1267  O   ARG A 133      37.587  33.264  13.170  0.50 24.37           O  
ATOM   1269  CB  ARG A 133      38.553  33.553  10.120  0.50 24.24           C  
ATOM   1271  CG  ARG A 133      38.237  32.373   9.167  0.50 22.98           C  
ATOM   1273  CD  ARG A 133      37.378  32.837   7.970  0.50 22.65           C  
ATOM   1275  NE  ARG A 133      37.201  31.840   6.904  0.50 24.78           N  
ATOM   1277  CZ  ARG A 133      36.521  30.689   6.991  0.50 23.96           C  
ATOM   1279  NH1 ARG A 133      35.911  30.302   8.109  0.50 26.61           N  
ATOM   1281  NH2 ARG A 133      36.455  29.899   5.931  0.50 22.87           N  
ATOM   1283  N   GLU A 134      38.324  31.246  12.495  1.00 26.15           N  
ATOM   1284  CA  GLU A 134      37.502  30.498  13.434  1.00 26.18           C  
ATOM   1285  C   GLU A 134      38.017  30.615  14.878  1.00 26.85           C  
ATOM   1286  O   GLU A 134      37.202  30.764  15.793  1.00 31.58           O  
ATOM   1287  CB  GLU A 134      37.359  29.046  12.995  1.00 23.99           C  
ATOM   1288  CG  GLU A 134      36.556  28.874  11.749  1.00 28.50           C  
ATOM   1289  CD  GLU A 134      36.497  27.439  11.227  1.00 29.56           C  
ATOM   1290  OE1 GLU A 134      37.510  26.735  11.316  1.00 28.20           O  
ATOM   1291  OE2 GLU A 134      35.431  27.031  10.703  1.00 33.88           O  
ATOM   1292  N   LEU A 135      39.337  30.593  15.087  1.00 27.35           N  
ATOM   1293  CA  LEU A 135      39.931  30.891  16.423  1.00 27.49           C  
ATOM   1294  C   LEU A 135      39.649  32.315  16.868  1.00 27.39           C  
ATOM   1295  O   LEU A 135      39.323  32.545  18.033  1.00 28.48           O  
ATOM   1296  CB  LEU A 135      41.463  30.701  16.441  1.00 26.94           C  
ATOM   1297  CG  LEU A 135      42.212  30.785  17.809  1.00 27.68           C  
ATOM   1298  CD1 LEU A 135      41.813  29.697  18.738  1.00 24.37           C  
ATOM   1299  CD2 LEU A 135      43.715  30.740  17.664  1.00 27.16           C  
ATOM   1300  N   LEU A 136      39.799  33.270  15.944  1.00 26.17           N  
ATOM   1301  CA  LEU A 136      39.584  34.684  16.271  1.00 25.55           C  
ATOM   1302  C   LEU A 136      38.124  34.932  16.555  1.00 25.10           C  
ATOM   1303  O   LEU A 136      37.807  35.681  17.464  1.00 24.13           O  
ATOM   1304  CB  LEU A 136      40.125  35.630  15.187  1.00 24.05           C  
ATOM   1305  CG  LEU A 136      41.639  35.489  14.915  1.00 26.18           C  
ATOM   1306  CD1 LEU A 136      42.149  36.525  13.852  1.00 21.12           C  
ATOM   1307  CD2 LEU A 136      42.430  35.589  16.212  1.00 20.03           C  
ATOM   1308  N   SER A 137      37.246  34.269  15.804  1.00 24.02           N  
ATOM   1309  CA  SER A 137      35.812  34.402  16.018  1.00 23.81           C  
ATOM   1310  C   SER A 137      35.422  33.779  17.369  1.00 25.18           C  
ATOM   1311  O   SER A 137      34.643  34.361  18.114  1.00 25.97           O  
ATOM   1312  CB  SER A 137      35.024  33.741  14.877  1.00 24.76           C  
ATOM   1313  OG  SER A 137      35.253  34.383  13.637  1.00 23.17           O  
ATOM   1314  N   ALA A 138      35.980  32.609  17.678  1.00 22.11           N  
ATOM   1315  CA  ALA A 138      35.727  31.967  18.947  1.00 23.44           C  
ATOM   1316  C   ALA A 138      36.164  32.856  20.145  1.00 24.50           C  
ATOM   1317  O   ALA A 138      35.507  32.895  21.186  1.00 27.84           O  
ATOM   1318  CB  ALA A 138      36.412  30.553  18.972  1.00 19.56           C  
ATOM   1319  N   TRP A 139      37.267  33.574  19.966  1.00 25.54           N  
ATOM   1320  CA  TRP A 139      37.818  34.521  20.940  1.00 24.70           C  
ATOM   1321  C   TRP A 139      36.812  35.621  21.268  1.00 26.06           C  
ATOM   1322  O   TRP A 139      36.567  35.905  22.437  1.00 25.45           O  
ATOM   1323  CB  TRP A 139      39.106  35.161  20.347  1.00 25.36           C  
ATOM   1324  CG  TRP A 139      39.965  35.955  21.304  1.00 24.72           C  
ATOM   1325  CD1 TRP A 139      39.693  36.241  22.603  1.00 27.56           C  
ATOM   1326  CD2 TRP A 139      41.211  36.583  21.018  1.00 26.30           C  
ATOM   1327  NE1 TRP A 139      40.690  36.968  23.146  1.00 27.38           N  
ATOM   1328  CE2 TRP A 139      41.638  37.207  22.199  1.00 26.67           C  
ATOM   1329  CE3 TRP A 139      42.002  36.695  19.876  1.00 28.50           C  
ATOM   1330  CZ2 TRP A 139      42.813  37.931  22.280  1.00 26.73           C  
ATOM   1331  CZ3 TRP A 139      43.183  37.402  19.959  1.00 27.48           C  
ATOM   1332  CH2 TRP A 139      43.581  38.000  21.152  1.00 26.48           C  
ATOM   1333  N   VAL A 140      36.248  36.242  20.224  1.00 25.93           N  
ATOM   1334  CA  VAL A 140      35.246  37.298  20.389  1.00 24.73           C  
ATOM   1335  C   VAL A 140      34.017  36.814  21.133  1.00 25.46           C  
ATOM   1336  O   VAL A 140      33.566  37.448  22.073  1.00 26.32           O  
ATOM   1337  CB  VAL A 140      34.837  37.901  19.024  1.00 25.34           C  
ATOM   1338  CG1 VAL A 140      33.608  38.811  19.171  1.00 22.00           C  
ATOM   1339  CG2 VAL A 140      36.017  38.681  18.426  1.00 21.73           C  
ATOM   1340  N   VAL A 141      33.511  35.663  20.716  1.00 26.68           N  
ATOM   1341  CA  VAL A 141      32.383  35.023  21.318  1.00 26.32           C  
ATOM   1342  C   VAL A 141      32.656  34.592  22.728  1.00 26.44           C  
ATOM   1343  O   VAL A 141      31.760  34.631  23.558  1.00 28.33           O  
ATOM   1344  CB  VAL A 141      31.927  33.763  20.482  1.00 28.39           C  
ATOM   1345  CG1 VAL A 141      30.743  33.058  21.164  1.00 23.70           C  
ATOM   1346  CG2 VAL A 141      31.549  34.164  19.056  1.00 26.42           C  
ATOM   1347  N   HIS A 142      33.864  34.107  22.999  1.00 27.90           N  
ATOM   1348  CA  HIS A 142      34.266  33.804  24.379  1.00 27.69           C  
ATOM   1349  C   HIS A 142      34.038  35.003  25.307  1.00 27.64           C  
ATOM   1350  O   HIS A 142      33.441  34.885  26.372  1.00 27.28           O  
ATOM   1351  CB  HIS A 142      35.757  33.407  24.438  1.00 27.62           C  
ATOM   1352  CG  HIS A 142      36.141  32.735  25.716  1.00 27.05           C  
ATOM   1353  ND1 HIS A 142      37.056  33.269  26.597  1.00 22.98           N  
ATOM   1354  CD2 HIS A 142      35.720  31.565  26.261  1.00 25.52           C  
ATOM   1355  CE1 HIS A 142      37.157  32.467  27.645  1.00 24.32           C  
ATOM   1356  NE2 HIS A 142      36.358  31.427  27.466  1.00 22.76           N  
ATOM   1357  N   ASP A 143      34.575  36.159  24.906  1.00 28.36           N  
ATOM   1358  CA  ASP A 143      34.385  37.398  25.648  1.00 27.28           C  
ATOM   1359  C   ASP A 143      32.910  37.614  25.910  1.00 26.73           C  
ATOM   1360  O   ASP A 143      32.490  37.803  27.022  1.00 29.16           O  
ATOM   1361  CB  ASP A 143      34.945  38.587  24.834  1.00 27.18           C  
ATOM   1362  CG  ASP A 143      36.389  38.859  25.132  1.00 30.20           C  
ATOM   1363  OD1 ASP A 143      37.091  37.945  25.666  1.00 30.82           O  
ATOM   1364  OD2 ASP A 143      36.828  39.987  24.799  1.00 30.03           O  
ATOM   1365  N   LEU A 144      32.119  37.592  24.854  1.00 28.92           N  
ATOM   1366  CA  LEU A 144      30.713  37.935  24.957  1.00 27.72           C  
ATOM   1367  C   LEU A 144      29.947  36.926  25.835  1.00 27.04           C  
ATOM   1368  O   LEU A 144      29.070  37.294  26.633  1.00 29.08           O  
ATOM   1369  CB  LEU A 144      30.123  38.042  23.543  1.00 26.88           C  
ATOM   1370  CG  LEU A 144      30.569  39.215  22.639  1.00 29.12           C  
ATOM   1371  CD1 LEU A 144      30.129  39.002  21.175  1.00 24.82           C  
ATOM   1372  CD2 LEU A 144      30.014  40.541  23.146  1.00 26.71           C  
ATOM   1373  N   THR A 145      30.273  35.655  25.678  1.00 27.14           N  
ATOM   1374  CA  THR A 145      29.631  34.561  26.426  1.00 26.08           C  
ATOM   1375  C   THR A 145      29.891  34.708  27.932  1.00 27.43           C  
ATOM   1376  O   THR A 145      29.002  34.504  28.763  1.00 27.56           O  
ATOM   1377  CB  THR A 145      30.199  33.236  25.945  1.00 25.25           C  
ATOM   1378  OG1 THR A 145      29.959  33.106  24.525  1.00 27.06           O  
ATOM   1379  CG2 THR A 145      29.621  32.058  26.719  1.00 25.48           C  
ATOM   1380  N   HIS A 146      31.112  35.078  28.273  1.00 27.31           N  
ATOM   1381  CA  HIS A 146      31.455  35.317  29.663  1.00 28.06           C  
ATOM   1382  C   HIS A 146      30.904  36.629  30.254  1.00 26.13           C  
ATOM   1383  O   HIS A 146      30.526  36.639  31.409  1.00 25.60           O  
ATOM   1384  CB  HIS A 146      32.957  35.163  29.870  1.00 28.68           C  
ATOM   1385  CG  HIS A 146      33.392  33.728  29.927  1.00 26.90           C  
ATOM   1386  ND1 HIS A 146      32.918  32.844  30.872  1.00 29.15           N  
ATOM   1387  CD2 HIS A 146      34.267  33.029  29.170  1.00 26.81           C  
ATOM   1388  CE1 HIS A 146      33.464  31.656  30.675  1.00 27.14           C  
ATOM   1389  NE2 HIS A 146      34.297  31.746  29.659  1.00 25.28           N  
ATOM   1390  N   ILE A 147      30.829  37.695  29.463  1.00 26.32           N  
ATOM   1391  CA  ILE A 147      30.065  38.902  29.826  1.00 26.66           C  
ATOM   1392  C   ILE A 147      28.632  38.526  30.213  1.00 27.70           C  
ATOM   1393  O   ILE A 147      28.129  38.964  31.262  1.00 29.08           O  
ATOM   1394  CB  ILE A 147      30.055  39.991  28.680  1.00 26.70           C  
ATOM   1395  CG1 ILE A 147      31.432  40.627  28.508  1.00 26.68           C  
ATOM   1396  CG2 ILE A 147      29.015  41.141  28.949  1.00 24.13           C  
ATOM   1397  CD1 ILE A 147      31.642  41.308  27.177  1.00 25.89           C  
ATOM   1398  N   ALA A 148      27.993  37.700  29.381  1.00 27.95           N  
ATOM   1399  CA  ALA A 148      26.600  37.279  29.594  1.00 26.84           C  
ATOM   1400  C   ALA A 148      26.472  36.450  30.850  1.00 26.72           C  
ATOM   1401  O   ALA A 148      25.465  36.527  31.549  1.00 23.76           O  
ATOM   1402  CB  ALA A 148      26.073  36.490  28.366  1.00 25.88           C  
ATOM   1403  N   GLN A 149      27.489  35.622  31.122  1.00 25.04           N  
ATOM   1404  CA  GLN A 149      27.500  34.845  32.339  1.00 24.97           C  
ATOM   1405  C   GLN A 149      27.554  35.763  33.566  1.00 26.49           C  
ATOM   1406  O   GLN A 149      26.877  35.522  34.560  1.00 29.10           O  
ATOM   1407  CB  GLN A 149      28.674  33.842  32.322  1.00 26.33           C  
ATOM   1408  CG  GLN A 149      28.737  32.909  33.508  1.00 25.91           C  
ATOM   1409  CD  GLN A 149      29.995  32.009  33.537  1.00 26.59           C  
ATOM   1410  OE1 GLN A 149      30.927  32.178  32.738  1.00 24.30           O  
ATOM   1411  NE2 GLN A 149      30.001  31.050  34.460  1.00 18.60           N  
ATOM   1412  N   ILE A 150      28.377  36.804  33.507  1.00 26.75           N  
ATOM   1413  CA  ILE A 150      28.507  37.770  34.605  1.00 26.25           C  
ATOM   1414  C   ILE A 150      27.152  38.454  34.833  1.00 25.78           C  
ATOM   1415  O   ILE A 150      26.650  38.456  35.935  1.00 26.04           O  
ATOM   1416  CB  ILE A 150      29.661  38.830  34.323  1.00 26.33           C  
ATOM   1417  CG1 ILE A 150      31.040  38.177  34.557  1.00 26.99           C  
ATOM   1418  CG2 ILE A 150      29.505  40.016  35.180  1.00 19.31           C  
ATOM   1419  CD1 ILE A 150      32.219  38.967  34.083  1.00 24.60           C  
ATOM   1420  N   VAL A 151      26.555  38.982  33.765  1.00 27.96           N  
ATOM   1421  CA  VAL A 151      25.240  39.653  33.820  1.00 26.36           C  
ATOM   1422  C   VAL A 151      24.125  38.750  34.370  1.00 27.30           C  
ATOM   1423  O   VAL A 151      23.338  39.190  35.209  1.00 28.75           O  
ATOM   1424  CB  VAL A 151      24.881  40.199  32.419  1.00 27.74           C  
ATOM   1425  CG1 VAL A 151      23.488  40.801  32.384  1.00 25.16           C  
ATOM   1426  CG2 VAL A 151      25.947  41.239  31.972  1.00 28.84           C  
ATOM   1427  N   ARG A 152      24.064  37.499  33.915  1.00 23.83           N  
ATOM   1428  CA  ARG A 152      23.065  36.541  34.395  1.00 26.29           C  
ATOM   1429  C   ARG A 152      23.213  36.190  35.877  1.00 26.44           C  
ATOM   1430  O   ARG A 152      22.208  35.999  36.586  1.00 26.88           O  
ATOM   1431  CB  ARG A 152      23.100  35.238  33.577  1.00 26.72           C  
ATOM   1432  CG  ARG A 152      22.330  35.281  32.217  1.00 28.51           C  
ATOM   1433  CD  ARG A 152      21.965  33.851  31.789  1.00 28.84           C  
ATOM   1434  NE  ARG A 152      23.134  32.956  31.938  1.00 28.58           N  
ATOM   1435  CZ  ARG A 152      24.172  32.938  31.103  1.00 28.56           C  
ATOM   1436  NH1 ARG A 152      24.203  33.701  30.001  1.00 29.81           N  
ATOM   1437  NH2 ARG A 152      25.183  32.122  31.361  1.00 30.95           N  
ATOM   1438  N   SER A 153      24.459  36.073  36.329  1.00 24.14           N  
ATOM   1439  CA  SER A 153      24.749  35.795  37.724  1.00 24.85           C  
ATOM   1440  C   SER A 153      24.250  36.929  38.641  1.00 27.09           C  
ATOM   1441  O   SER A 153      23.651  36.709  39.708  1.00 27.56           O  
ATOM   1442  CB  SER A 153      26.251  35.637  37.899  1.00 26.58           C  
ATOM   1443  OG  SER A 153      26.774  34.576  37.099  1.00 26.58           O  
HETATM 1444  N   MSE A 154      24.497  38.160  38.206  1.00 27.86           N  
HETATM 1445  CA  MSE A 154      24.005  39.327  38.920  1.00 26.41           C  
HETATM 1446  C   MSE A 154      22.469  39.391  38.927  1.00 25.34           C  
HETATM 1447  O   MSE A 154      21.881  39.566  39.978  1.00 25.45           O  
HETATM 1448  CB  MSE A 154      24.634  40.589  38.344  1.00 25.80           C  
HETATM 1449  CG  MSE A 154      26.139  40.632  38.576  1.00 30.84           C  
HETATM 1450 SE   MSE A 154      27.052  42.003  37.594  0.75 24.58          SE  
HETATM 1451  CE  MSE A 154      26.330  43.545  38.352  1.00 21.03           C  
ATOM   1452  N   ALA A 155      21.831  39.198  37.775  1.00 25.00           N  
ATOM   1453  CA  ALA A 155      20.364  39.156  37.697  1.00 24.63           C  
ATOM   1454  C   ALA A 155      19.740  38.135  38.660  1.00 26.46           C  
ATOM   1455  O   ALA A 155      18.694  38.393  39.281  1.00 26.58           O  
ATOM   1456  CB  ALA A 155      19.900  38.894  36.240  1.00 21.45           C  
ATOM   1457  N   LYS A 156      20.389  36.981  38.768  1.00 28.44           N  
ATOM   1458  CA  LYS A 156      19.874  35.835  39.509  1.00 28.56           C  
ATOM   1459  C   LYS A 156      19.726  36.158  40.996  1.00 27.95           C  
ATOM   1460  O   LYS A 156      18.804  35.734  41.678  1.00 27.40           O  
ATOM   1461  CB  LYS A 156      20.796  34.617  39.286  1.00 29.57           C  
ATOM   1462  CG  LYS A 156      20.368  33.394  40.056  1.00 30.48           C  
ATOM   1463  CD  LYS A 156      20.635  32.078  39.362  1.00 35.35           C  
ATOM   1464  CE  LYS A 156      19.504  31.043  39.665  1.00 39.16           C  
ATOM   1465  NZ  LYS A 156      19.305  30.892  41.128  1.00 38.31           N  
ATOM   1466  N   ARG A 157      20.608  36.989  41.485  1.00 27.75           N  
ATOM   1467  CA  ARG A 157      20.502  37.477  42.853  1.00 26.19           C  
ATOM   1468  C   ARG A 157      19.095  37.970  43.283  1.00 25.66           C  
ATOM   1469  O   ARG A 157      18.751  37.900  44.479  1.00 24.66           O  
ATOM   1470  CB  ARG A 157      21.491  38.598  42.949  1.00 27.20           C  
ATOM   1471  CG  ARG A 157      21.706  39.146  44.264  1.00 37.07           C  
ATOM   1472  CD  ARG A 157      23.175  39.484  44.475  1.00 39.98           C  
ATOM   1473  NE  ARG A 157      23.295  39.744  45.895  1.00 43.57           N  
ATOM   1474  CZ  ARG A 157      23.510  40.917  46.447  1.00 41.10           C  
ATOM   1475  NH1 ARG A 157      23.740  41.988  45.694  1.00 51.92           N  
ATOM   1476  NH2 ARG A 157      23.542  40.990  47.769  1.00 43.40           N  
ATOM   1477  N   TYR A 158      18.302  38.488  42.327  1.00 24.49           N  
ATOM   1478  CA  TYR A 158      17.003  39.090  42.616  1.00 23.09           C  
ATOM   1479  C   TYR A 158      15.842  38.237  42.137  1.00 23.72           C  
ATOM   1480  O   TYR A 158      14.727  38.739  42.053  1.00 25.13           O  
ATOM   1481  CB  TYR A 158      16.895  40.536  42.039  1.00 24.67           C  
ATOM   1482  CG  TYR A 158      17.692  41.663  42.738  1.00 19.70           C  
ATOM   1483  CD1 TYR A 158      18.580  41.400  43.770  1.00 24.37           C  
ATOM   1484  CD2 TYR A 158      17.582  42.981  42.306  1.00 22.85           C  
ATOM   1485  CE1 TYR A 158      19.306  42.415  44.389  1.00 26.10           C  
ATOM   1486  CE2 TYR A 158      18.328  44.006  42.886  1.00 23.87           C  
ATOM   1487  CZ  TYR A 158      19.192  43.725  43.939  1.00 24.19           C  
ATOM   1488  OH  TYR A 158      19.947  44.731  44.558  1.00 20.13           O  
ATOM   1489  N   ASP A 159      16.079  36.943  41.896  1.00 25.02           N  
ATOM   1490  CA  ASP A 159      15.023  36.006  41.477  1.00 26.32           C  
ATOM   1491  C   ASP A 159      13.781  36.092  42.345  1.00 24.26           C  
ATOM   1492  O   ASP A 159      12.669  36.185  41.822  1.00 26.72           O  
ATOM   1493  CB  ASP A 159      15.492  34.527  41.480  1.00 27.44           C  
ATOM   1494  CG  ASP A 159      16.316  34.137  40.246  1.00 30.90           C  
ATOM   1495  OD1 ASP A 159      16.556  34.979  39.356  1.00 30.66           O  
ATOM   1496  OD2 ASP A 159      16.721  32.954  40.187  1.00 37.43           O  
ATOM   1497  N   THR A 160      13.963  36.044  43.658  1.00 24.85           N  
ATOM   1498  CA  THR A 160      12.830  36.124  44.599  1.00 23.36           C  
ATOM   1499  C   THR A 160      12.381  37.572  44.748  1.00 24.31           C  
ATOM   1500  O   THR A 160      11.182  37.864  44.784  1.00 26.43           O  
ATOM   1501  CB  THR A 160      13.207  35.541  45.980  1.00 25.46           C  
ATOM   1502  OG1 THR A 160      13.648  34.183  45.814  1.00 29.25           O  
ATOM   1503  CG2 THR A 160      12.010  35.591  46.987  1.00 21.05           C  
ATOM   1504  N   ASP A 161      13.346  38.486  44.805  1.00 24.25           N  
ATOM   1505  CA  ASP A 161      13.074  39.926  44.945  1.00 24.54           C  
ATOM   1506  C   ASP A 161      12.115  40.542  43.906  1.00 23.36           C  
ATOM   1507  O   ASP A 161      11.329  41.405  44.259  1.00 26.58           O  
ATOM   1508  CB  ASP A 161      14.384  40.724  44.913  1.00 24.89           C  
ATOM   1509  CG  ASP A 161      15.330  40.333  46.010  1.00 21.05           C  
ATOM   1510  OD1 ASP A 161      15.229  40.909  47.108  1.00 23.94           O  
ATOM   1511  OD2 ASP A 161      16.198  39.462  45.766  1.00 25.93           O  
ATOM   1512  N   VAL A 162      12.179  40.108  42.652  1.00 22.04           N  
ATOM   1513  CA  VAL A 162      11.355  40.677  41.602  1.00 22.64           C  
ATOM   1514  C   VAL A 162       9.883  40.276  41.757  1.00 23.43           C  
ATOM   1515  O   VAL A 162       9.005  40.855  41.109  1.00 25.19           O  
ATOM   1516  CB  VAL A 162      11.863  40.321  40.183  1.00 24.06           C  
ATOM   1517  CG1 VAL A 162      13.300  40.798  39.985  1.00 20.97           C  
ATOM   1518  CG2 VAL A 162      11.726  38.774  39.878  1.00 25.48           C  
ATOM   1519  N   GLY A 163       9.612  39.298  42.615  1.00 24.24           N  
ATOM   1520  CA  GLY A 163       8.240  38.861  42.894  1.00 23.21           C  
ATOM   1521  C   GLY A 163       7.477  38.498  41.620  1.00 23.28           C  
ATOM   1522  O   GLY A 163       7.954  37.678  40.860  1.00 25.90           O  
ATOM   1523  N   PRO A 164       6.283  39.090  41.382  1.00 22.03           N  
ATOM   1524  CA  PRO A 164       5.460  38.669  40.239  1.00 22.58           C  
ATOM   1525  C   PRO A 164       6.008  39.025  38.830  1.00 24.39           C  
ATOM   1526  O   PRO A 164       5.487  38.516  37.799  1.00 22.46           O  
ATOM   1527  CB  PRO A 164       4.117  39.344  40.506  1.00 24.57           C  
ATOM   1528  CG  PRO A 164       4.400  40.532  41.379  1.00 23.78           C  
ATOM   1529  CD  PRO A 164       5.626  40.138  42.187  1.00 23.87           C  
ATOM   1530  N   TRP A 165       7.071  39.830  38.797  1.00 25.56           N  
ATOM   1531  CA  TRP A 165       7.741  40.174  37.547  1.00 26.21           C  
ATOM   1532  C   TRP A 165       8.626  39.054  36.977  1.00 27.02           C  
ATOM   1533  O   TRP A 165       9.053  39.121  35.805  1.00 27.82           O  
ATOM   1534  CB  TRP A 165       8.549  41.477  37.678  1.00 25.33           C  
ATOM   1535  CG  TRP A 165       7.748  42.746  37.417  1.00 25.58           C  
ATOM   1536  CD1 TRP A 165       7.361  43.230  36.198  1.00 22.11           C  
ATOM   1537  CD2 TRP A 165       7.234  43.665  38.398  1.00 23.40           C  
ATOM   1538  NE1 TRP A 165       6.634  44.388  36.357  1.00 25.11           N  
ATOM   1539  CE2 TRP A 165       6.543  44.684  37.693  1.00 23.35           C  
ATOM   1540  CE3 TRP A 165       7.284  43.725  39.798  1.00 24.66           C  
ATOM   1541  CZ2 TRP A 165       5.925  45.761  38.338  1.00 19.29           C  
ATOM   1542  CZ3 TRP A 165       6.675  44.820  40.448  1.00 22.32           C  
ATOM   1543  CH2 TRP A 165       6.004  45.810  39.715  1.00 21.41           C  
ATOM   1544  N   LYS A 166       8.900  38.034  37.785  1.00 27.89           N  
ATOM   1545  CA  LYS A 166       9.822  36.972  37.389  1.00 26.27           C  
ATOM   1546  C   LYS A 166       9.500  36.374  36.005  1.00 27.38           C  
ATOM   1547  O   LYS A 166      10.366  36.268  35.124  1.00 27.03           O  
ATOM   1548  CB  LYS A 166       9.780  35.863  38.450  1.00 27.66           C  
ATOM   1549  CG  LYS A 166      10.693  34.618  38.166  1.00 27.39           C  
ATOM   1550  CD  LYS A 166      12.178  34.957  38.390  1.00 35.29           C  
ATOM   1551  CE  LYS A 166      13.075  33.736  38.315  1.00 34.22           C  
ATOM   1552  NZ  LYS A 166      13.195  33.255  36.909  1.00 36.82           N  
ATOM   1553  N   GLU A 167       8.262  35.936  35.809  1.00 29.04           N  
ATOM   1554  CA  GLU A 167       7.912  35.311  34.523  1.00 28.85           C  
ATOM   1555  C   GLU A 167       8.113  36.271  33.348  1.00 26.28           C  
ATOM   1556  O   GLU A 167       8.767  35.925  32.361  1.00 26.71           O  
ATOM   1557  CB  GLU A 167       6.477  34.738  34.516  1.00 27.75           C  
ATOM   1558  CG  GLU A 167       6.292  33.756  33.365  1.00 33.97           C  
ATOM   1559  CD  GLU A 167       4.852  33.371  33.059  1.00 35.25           C  
ATOM   1560  OE1 GLU A 167       3.902  33.728  33.833  1.00 37.84           O  
ATOM   1561  OE2 GLU A 167       4.706  32.667  32.010  1.00 47.77           O  
ATOM   1562  N   TYR A 168       7.555  37.475  33.430  1.00 26.85           N  
ATOM   1563  CA  TYR A 168       7.664  38.391  32.287  1.00 26.26           C  
ATOM   1564  C   TYR A 168       9.121  38.817  31.967  1.00 28.09           C  
ATOM   1565  O   TYR A 168       9.439  39.107  30.826  1.00 28.55           O  
ATOM   1566  CB  TYR A 168       6.748  39.596  32.477  1.00 27.67           C  
ATOM   1567  CG  TYR A 168       6.711  40.465  31.250  1.00 26.48           C  
ATOM   1568  CD1 TYR A 168       6.202  39.955  30.049  1.00 21.15           C  
ATOM   1569  CD2 TYR A 168       7.232  41.768  31.265  1.00 23.05           C  
ATOM   1570  CE1 TYR A 168       6.196  40.713  28.891  1.00 25.81           C  
ATOM   1571  CE2 TYR A 168       7.224  42.544  30.117  1.00 26.31           C  
ATOM   1572  CZ  TYR A 168       6.690  42.010  28.930  1.00 29.88           C  
ATOM   1573  OH  TYR A 168       6.669  42.736  27.763  1.00 30.19           O  
ATOM   1574  N   LEU A 169      10.014  38.803  32.961  1.00 28.16           N  
ATOM   1575  CA  LEU A 169      11.418  39.206  32.764  1.00 26.77           C  
ATOM   1576  C   LEU A 169      12.184  38.159  31.982  1.00 28.84           C  
ATOM   1577  O   LEU A 169      13.291  38.407  31.493  1.00 28.97           O  
ATOM   1578  CB  LEU A 169      12.101  39.485  34.117  1.00 25.44           C  
ATOM   1579  CG  LEU A 169      11.760  40.849  34.742  1.00 25.03           C  
ATOM   1580  CD1 LEU A 169      12.198  40.883  36.210  1.00 21.11           C  
ATOM   1581  CD2 LEU A 169      12.371  42.002  33.941  1.00 21.59           C  
ATOM   1582  N   GLY A 170      11.595  36.973  31.868  1.00 30.80           N  
ATOM   1583  CA  GLY A 170      12.067  35.970  30.908  1.00 30.52           C  
ATOM   1584  C   GLY A 170      11.534  36.115  29.484  1.00 29.62           C  
ATOM   1585  O   GLY A 170      11.909  35.350  28.651  1.00 31.53           O  
ATOM   1586  N   ILE A 171      10.664  37.084  29.212  1.00 30.83           N  
ATOM   1587  CA  ILE A 171      10.019  37.257  27.889  1.00 29.53           C  
ATOM   1588  C   ILE A 171      10.579  38.474  27.179  1.00 28.97           C  
ATOM   1589  O   ILE A 171      10.366  39.601  27.616  1.00 30.78           O  
ATOM   1590  CB  ILE A 171       8.479  37.469  28.040  1.00 28.00           C  
ATOM   1591  CG1 ILE A 171       7.833  36.248  28.674  1.00 29.48           C  
ATOM   1592  CG2 ILE A 171       7.826  37.775  26.707  1.00 25.94           C  
ATOM   1593  CD1 ILE A 171       8.025  34.964  27.912  1.00 23.40           C  
ATOM   1594  N   LEU A 172      11.260  38.267  26.062  1.00 29.83           N  
ATOM   1595  CA  LEU A 172      11.899  39.358  25.335  1.00 28.11           C  
ATOM   1596  C   LEU A 172      11.141  39.758  24.071  1.00 30.11           C  
ATOM   1597  O   LEU A 172      10.180  39.109  23.657  1.00 28.79           O  
ATOM   1598  CB  LEU A 172      13.321  38.975  24.976  1.00 31.37           C  
ATOM   1599  CG  LEU A 172      14.240  38.532  26.115  1.00 29.48           C  
ATOM   1600  CD1 LEU A 172      15.498  37.954  25.466  1.00 29.37           C  
ATOM   1601  CD2 LEU A 172      14.569  39.702  27.000  1.00 26.37           C  
ATOM   1602  N   ASN A 173      11.568  40.873  23.488  1.00 31.32           N  
ATOM   1603  CA  ASN A 173      11.054  41.340  22.195  1.00 31.64           C  
ATOM   1604  C   ASN A 173       9.563  41.589  22.233  1.00 32.11           C  
ATOM   1605  O   ASN A 173       8.842  41.182  21.328  1.00 33.05           O  
ATOM   1606  CB  ASN A 173      11.412  40.351  21.075  1.00 31.03           C  
ATOM   1607  CG  ASN A 173      12.880  40.072  21.024  1.00 29.86           C  
ATOM   1608  OD1 ASN A 173      13.667  40.988  20.829  1.00 32.25           O  
ATOM   1609  ND2 ASN A 173      13.270  38.813  21.256  1.00 28.39           N  
ATOM   1610  N   ASP A 174       9.120  42.250  23.304  1.00 34.75           N  
ATOM   1611  CA  ASP A 174       7.691  42.504  23.582  1.00 33.21           C  
ATOM   1612  C   ASP A 174       7.486  43.820  24.316  1.00 34.35           C  
ATOM   1613  O   ASP A 174       6.457  44.489  24.136  1.00 36.29           O  
ATOM   1614  CB  ASP A 174       7.065  41.373  24.412  1.00 31.44           C  
ATOM   1615  CG  ASP A 174       5.576  41.573  24.590  1.00 33.55           C  
ATOM   1616  OD1 ASP A 174       4.848  41.401  23.585  1.00 33.55           O  
ATOM   1617  OD2 ASP A 174       5.135  41.943  25.705  1.00 30.30           O  
ATOM   1618  OXT ASP A 174       8.341  44.235  25.095  1.00 34.34           O  
TER    1619      ASP A 174                                                      
END
MOLECULE T0481.pdb
ATOM   1157  N   ASN     5      43.757  48.627  12.993  1.00 48.55           N  
ATOM   1158  CA  ASN     5      43.707  47.221  13.486  1.00 48.66           C  
ATOM   1159  C   ASN     5      42.297  46.854  13.970  1.00 46.10           C  
ATOM   1160  O   ASN     5      41.931  47.131  15.124  1.00 45.32           O  
ATOM   1161  CB  ASN     5      44.739  47.032  14.610  1.00 49.92           C  
ATOM   1162  CG  ASN     5      45.105  45.561  14.854  1.00 51.98           C  
ATOM   1163  OD1 ASN     5      44.378  44.628  14.479  1.00 41.03           O  
ATOM   1164  ND2 ASN     5      46.252  45.360  15.496  1.00 51.86           N  
ATOM   1165  N   GLN     6      41.522  46.221  13.081  1.00 42.89           N  
ATOM   1166  CA  GLN     6      40.122  45.866  13.363  1.00 39.86           C  
ATOM   1167  C   GLN     6      39.972  44.674  14.322  1.00 37.64           C  
ATOM   1168  O   GLN     6      38.948  44.545  14.985  1.00 37.24           O  
ATOM   1169  CB  GLN     6      39.363  45.603  12.059  1.00 39.17           C  
ATOM   1170  N   ILE     7      40.983  43.809  14.403  1.00 34.88           N  
ATOM   1171  CA  ILE     7      40.937  42.694  15.353  1.00 34.40           C  
ATOM   1172  C   ILE     7      41.043  43.194  16.799  1.00 31.45           C  
ATOM   1173  O   ILE     7      40.216  42.843  17.643  1.00 29.10           O  
ATOM   1174  CB  ILE     7      42.038  41.634  15.082  1.00 34.24           C  
ATOM   1175  CG1 ILE     7      41.687  40.792  13.849  1.00 35.88           C  
ATOM   1176  CG2 ILE     7      42.186  40.712  16.271  1.00 34.37           C  
ATOM   1177  CD1 ILE     7      42.783  39.803  13.446  1.00 36.32           C  
ATOM   1178  N   VAL     8      42.071  44.003  17.067  1.00 31.23           N  
ATOM   1179  CA  VAL     8      42.289  44.610  18.384  1.00 29.82           C  
ATOM   1180  C   VAL     8      41.107  45.490  18.755  1.00 29.64           C  
ATOM   1181  O   VAL     8      40.544  45.353  19.832  1.00 30.66           O  
ATOM   1182  CB  VAL     8      43.589  45.453  18.418  1.00 29.55           C  
ATOM   1183  CG1 VAL     8      43.562  46.438  19.575  1.00 30.78           C  
ATOM   1184  CG2 VAL     8      44.817  44.553  18.513  1.00 26.78           C  
ATOM   1185  N   SER     9      40.726  46.377  17.846  1.00 30.09           N  
ATOM   1186  CA  SER     9      39.600  47.287  18.059  1.00 30.85           C  
ATOM   1187  C   SER     9      38.300  46.564  18.423  1.00 29.88           C  
ATOM   1188  O   SER     9      37.633  46.922  19.394  1.00 30.15           O  
ATOM   1189  CB  SER     9      39.382  48.137  16.796  1.00 31.43           C  
ATOM   1190  OG  SER     9      38.309  49.037  16.971  1.00 34.73           O  
ATOM   1191  N   HIS    10      37.946  45.552  17.640  1.00 29.62           N  
ATOM   1192  CA  HIS    10      36.728  44.774  17.872  1.00 29.21           C  
ATOM   1193  C   HIS    10      36.770  43.988  19.188  1.00 27.89           C  
ATOM   1194  O   HIS    10      35.747  43.834  19.863  1.00 27.83           O  
ATOM   1195  CB  HIS    10      36.453  43.833  16.696  1.00 29.11           C  
ATOM   1196  CG  HIS    10      35.127  43.131  16.782  1.00 30.96           C  
ATOM   1197  ND1 HIS    10      34.991  41.773  16.582  1.00 29.81           N  
ATOM   1198  CD2 HIS    10      33.882  43.596  17.055  1.00 32.11           C  
ATOM   1199  CE1 HIS    10      33.723  41.432  16.721  1.00 34.31           C  
ATOM   1200  NE2 HIS    10      33.025  42.520  17.004  1.00 31.48           N  
ATOM   1201  N   PHE    11      37.946  43.490  19.545  1.00 26.50           N  
ATOM   1202  CA  PHE    11      38.144  42.846  20.847  1.00 25.86           C  
ATOM   1203  C   PHE    11      37.899  43.833  22.005  1.00 25.41           C  
ATOM   1204  O   PHE    11      37.131  43.543  22.922  1.00 26.59           O  
ATOM   1205  CB  PHE    11      39.561  42.251  20.931  1.00 25.87           C  
ATOM   1206  CG  PHE    11      39.978  41.854  22.325  1.00 23.85           C  
ATOM   1207  CD1 PHE    11      39.402  40.765  22.948  1.00 23.40           C  
ATOM   1208  CD2 PHE    11      40.940  42.587  23.009  1.00 24.43           C  
ATOM   1209  CE1 PHE    11      39.769  40.403  24.233  1.00 24.62           C  
ATOM   1210  CE2 PHE    11      41.331  42.230  24.298  1.00 26.60           C  
ATOM   1211  CZ  PHE    11      40.751  41.136  24.910  1.00 25.39           C  
ATOM   1212  N   LEU    12      38.558  44.993  21.960  1.00 25.19           N  
ATOM   1213  CA  LEU    12      38.433  46.000  23.024  1.00 24.40           C  
ATOM   1214  C   LEU    12      37.013  46.571  23.154  1.00 24.37           C  
ATOM   1215  O   LEU    12      36.551  46.899  24.244  1.00 23.55           O  
ATOM   1216  CB  LEU    12      39.429  47.127  22.787  1.00 25.08           C  
ATOM   1217  CG  LEU    12      40.903  46.732  22.935  1.00 23.88           C  
ATOM   1218  CD1 LEU    12      41.772  47.927  22.675  1.00 19.99           C  
ATOM   1219  CD2 LEU    12      41.172  46.151  24.314  1.00 17.50           C  
ATOM   1220  N   SER    13      36.345  46.698  22.018  1.00 24.35           N  
ATOM   1221  CA  SER    13      34.937  47.074  21.945  1.00 24.92           C  
ATOM   1222  C   SER    13      34.094  46.327  22.991  1.00 25.13           C  
ATOM   1223  O   SER    13      33.214  46.894  23.629  1.00 27.77           O  
ATOM   1224  CB  SER    13      34.440  46.723  20.541  1.00 25.22           C  
ATOM   1225  OG  SER    13      33.092  47.020  20.376  1.00 26.42           O  
ATOM   1226  N   HIS    14      34.392  45.046  23.150  1.00 24.32           N  
ATOM   1227  CA  HIS    14      33.720  44.177  24.093  1.00 23.44           C  
ATOM   1228  C   HIS    14      34.479  44.063  25.424  1.00 22.45           C  
ATOM   1229  O   HIS    14      33.887  44.226  26.488  1.00 22.95           O  
ATOM   1230  CB  HIS    14      33.528  42.795  23.455  1.00 23.60           C  
ATOM   1231  CG  HIS    14      32.468  42.759  22.397  1.00 22.55           C  
ATOM   1232  ND1 HIS    14      31.123  42.736  22.695  1.00 22.51           N  
ATOM   1233  CD2 HIS    14      32.554  42.716  21.047  1.00 24.07           C  
ATOM   1234  CE1 HIS    14      30.425  42.689  21.575  1.00 22.12           C  
ATOM   1235  NE2 HIS    14      31.270  42.672  20.559  1.00 23.74           N  
ATOM   1236  N   ARG    15      35.782  43.819  25.364  1.00 23.33           N  
ATOM   1237  CA  ARG    15      36.609  43.694  26.581  1.00 23.65           C  
ATOM   1238  C   ARG    15      36.617  44.947  27.474  1.00 24.04           C  
ATOM   1239  O   ARG    15      36.658  44.830  28.696  1.00 25.31           O  
ATOM   1240  CB  ARG    15      38.040  43.267  26.216  1.00 22.98           C  
ATOM   1241  CG  ARG    15      39.061  43.250  27.369  1.00 25.04           C  
ATOM   1242  CD  ARG    15      38.654  42.372  28.575  1.00 23.51           C  
ATOM   1243  NE  ARG    15      38.553  40.961  28.233  1.00 25.26           N  
ATOM   1244  CZ  ARG    15      39.583  40.124  28.141  1.00 29.21           C  
ATOM   1245  NH1 ARG    15      40.828  40.529  28.388  1.00 30.40           N  
ATOM   1246  NH2 ARG    15      39.358  38.857  27.809  1.00 26.91           N  
ATOM   1247  N   ASN    16      36.571  46.142  26.889  1.00 24.45           N  
ATOM   1248  CA  ASN    16      36.470  47.356  27.702  1.00 24.31           C  
ATOM   1249  C   ASN    16      35.182  47.388  28.527  1.00 24.67           C  
ATOM   1250  O   ASN    16      35.152  47.967  29.618  1.00 24.35           O  
ATOM   1251  CB  ASN    16      36.580  48.634  26.848  1.00 23.87           C  
ATOM   1252  CG  ASN    16      37.991  48.873  26.313  1.00 25.17           C  
ATOM   1253  OD1 ASN    16      38.980  48.416  26.887  1.00 27.85           O  
ATOM   1254  ND2 ASN    16      38.085  49.616  25.218  1.00 24.54           N  
ATOM   1255  N   VAL    17      34.112  46.792  28.005  1.00 25.32           N  
ATOM   1256  CA  VAL    17      32.845  46.739  28.750  1.00 25.14           C  
ATOM   1257  C   VAL    17      32.951  45.686  29.871  1.00 25.47           C  
ATOM   1258  O   VAL    17      32.466  45.898  30.980  1.00 24.38           O  
ATOM   1259  CB  VAL    17      31.636  46.485  27.807  1.00 25.11           C  
ATOM   1260  CG1 VAL    17      30.329  46.424  28.590  1.00 23.93           C  
ATOM   1261  CG2 VAL    17      31.567  47.563  26.732  1.00 21.19           C  
ATOM   1262  N   THR    18      33.621  44.570  29.581  1.00 26.85           N  
ATOM   1263  CA  THR    18      33.871  43.517  30.570  1.00 27.43           C  
ATOM   1264  C   THR    18      34.686  44.040  31.750  1.00 28.37           C  
ATOM   1265  O   THR    18      34.401  43.716  32.908  1.00 27.86           O  
ATOM   1266  CB  THR    18      34.631  42.343  29.937  1.00 26.46           C  
ATOM   1267  OG1 THR    18      33.758  41.641  29.047  1.00 28.22           O  
ATOM   1268  CG2 THR    18      35.153  41.393  31.005  1.00 26.76           C  
ATOM   1269  N   ASN    19      35.712  44.830  31.436  1.00 29.46           N  
ATOM   1270  CA  ASN    19      36.583  45.415  32.444  1.00 29.44           C  
ATOM   1271  C   ASN    19      35.877  46.449  33.302  1.00 31.03           C  
ATOM   1272  O   ASN    19      36.120  46.544  34.505  1.00 32.27           O  
ATOM   1273  CB  ASN    19      37.800  46.053  31.781  1.00 28.63           C  
ATOM   1274  CG  ASN    19      38.752  45.038  31.224  1.00 27.67           C  
ATOM   1275  OD1 ASN    19      38.698  43.849  31.561  1.00 29.89           O  
ATOM   1276  ND2 ASN    19      39.631  45.490  30.362  1.00 16.24           N  
ATOM   1277  N   GLU    20      35.009  47.226  32.673  1.00 32.85           N  
ATOM   1278  CA  GLU    20      34.197  48.215  33.378  1.00 34.98           C  
ATOM   1279  C   GLU    20      33.218  47.533  34.338  1.00 32.92           C  
ATOM   1280  O   GLU    20      33.018  47.999  35.451  1.00 35.00           O  
ATOM   1281  CB  GLU    20      33.450  49.089  32.369  1.00 34.33           C  
ATOM   1282  CG  GLU    20      32.885  50.367  32.951  1.00 41.33           C  
ATOM   1283  CD  GLU    20      32.241  51.269  31.906  1.00 41.71           C  
ATOM   1284  OE1 GLU    20      32.529  51.102  30.688  1.00 48.89           O  
ATOM   1285  OE2 GLU    20      31.448  52.149  32.316  1.00 50.11           O  
ATOM   1286  N   LEU    21      32.624  46.426  33.905  1.00 31.28           N  
ATOM   1287  CA  LEU    21      31.700  45.645  34.734  1.00 30.29           C  
ATOM   1288  C   LEU    21      32.414  44.977  35.915  1.00 30.39           C  
ATOM   1289  O   LEU    21      31.860  44.873  37.015  1.00 30.47           O  
ATOM   1290  CB  LEU    21      30.993  44.561  33.892  1.00 29.76           C  
ATOM   1291  CG  LEU    21      29.893  44.963  32.899  1.00 27.66           C  
ATOM   1292  CD1 LEU    21      29.501  43.764  32.026  1.00 22.19           C  
ATOM   1293  CD2 LEU    21      28.660  45.529  33.614  1.00 25.56           C  
ATOM   1294  N   ALA    22      33.635  44.512  35.672  1.00 30.64           N  
ATOM   1295  CA  ALA    22      34.460  43.895  36.710  1.00 31.48           C  
ATOM   1296  C   ALA    22      34.780  44.861  37.856  1.00 32.45           C  
ATOM   1297  O   ALA    22      34.888  44.450  39.016  1.00 31.11           O  
ATOM   1298  CB  ALA    22      35.755  43.354  36.098  1.00 31.19           C  
ATOM   1299  N   GLU    23      34.934  46.138  37.510  1.00 34.47           N  
ATOM   1300  CA  GLU    23      35.214  47.208  38.475  1.00 36.19           C  
ATOM   1301  C   GLU    23      34.053  47.424  39.453  1.00 35.68           C  
ATOM   1302  O   GLU    23      34.267  47.870  40.573  1.00 36.37           O  
ATOM   1303  CB  GLU    23      35.582  48.500  37.711  1.00 36.80           C  
ATOM   1304  CG  GLU    23      34.996  49.826  38.232  1.00 44.97           C  
ATOM   1305  CD  GLU    23      35.795  50.464  39.365  1.00 54.10           C  
ATOM   1306  OE1 GLU    23      37.029  50.243  39.444  1.00 58.36           O  
ATOM   1307  OE2 GLU    23      35.181  51.215  40.160  1.00 55.37           O  
ATOM   1308  N   LYS    24      32.837  47.095  39.020  1.00 35.78           N  
ATOM   1309  CA  LYS    24      31.630  47.243  39.828  1.00 36.00           C  
ATOM   1310  C   LYS    24      31.403  46.089  40.811  1.00 36.32           C  
ATOM   1311  O   LYS    24      30.399  46.071  41.524  1.00 37.08           O  
ATOM   1312  CB  LYS    24      30.411  47.385  38.910  1.00 36.20           C  
ATOM   1313  CG  LYS    24      30.488  48.628  38.038  1.00 37.65           C  
ATOM   1314  CD  LYS    24      29.127  49.070  37.532  1.00 40.50           C  
ATOM   1315  CE  LYS    24      29.157  50.541  37.089  1.00 46.04           C  
ATOM   1316  NZ  LYS    24      30.023  50.741  35.879  1.00 47.21           N  
ATOM   1317  N   ILE    25      32.337  45.138  40.840  1.00 35.88           N  
ATOM   1318  CA  ILE    25      32.294  43.987  41.733  1.00 35.06           C  
ATOM   1319  C   ILE    25      33.129  44.260  42.988  1.00 36.05           C  
ATOM   1320  O   ILE    25      34.364  44.186  42.953  1.00 35.12           O  
ATOM   1321  CB  ILE    25      32.851  42.718  41.022  1.00 34.99           C  
ATOM   1322  CG1 ILE    25      32.047  42.405  39.750  1.00 36.68           C  
ATOM   1323  CG2 ILE    25      32.848  41.515  41.959  1.00 34.29           C  
ATOM   1324  CD1 ILE    25      32.637  41.292  38.907  1.00 33.67           C  
ATOM   1325  N   SER    26      32.457  44.580  44.092  1.00 37.22           N  
ATOM   1326  CA  SER    26      33.128  44.736  45.383  1.00 38.56           C  
ATOM   1327  C   SER    26      33.758  43.410  45.786  1.00 40.35           C  
ATOM   1328  O   SER    26      33.334  42.354  45.310  1.00 41.06           O  
ATOM   1329  CB  SER    26      32.125  45.138  46.459  1.00 38.56           C  
ATOM   1330  OG  SER    26      31.263  44.055  46.775  1.00 37.07           O  
ATOM   1331  N   LYS    27      34.756  43.461  46.666  1.00 41.84           N  
ATOM   1332  CA  LYS    27      35.441  42.247  47.124  1.00 43.21           C  
ATOM   1333  C   LYS    27      34.509  41.312  47.910  1.00 42.45           C  
ATOM   1334  O   LYS    27      34.734  40.103  47.968  1.00 41.33           O  
ATOM   1335  CB  LYS    27      36.707  42.600  47.918  1.00 43.47           C  
ATOM   1336  CG  LYS    27      37.740  43.358  47.071  1.00 45.04           C  
ATOM   1337  CD  LYS    27      39.142  43.329  47.664  1.00 45.26           C  
ATOM   1338  CE  LYS    27      39.954  42.132  47.180  1.00 47.98           C  
ATOM   1339  NZ  LYS    27      40.646  42.396  45.885  1.00 44.46           N  
ATOM   1340  N   ASP    28      33.448  41.865  48.491  1.00 43.17           N  
ATOM   1341  CA  ASP    28      32.423  41.038  49.143  1.00 43.66           C  
ATOM   1342  C   ASP    28      31.589  40.274  48.109  1.00 42.08           C  
ATOM   1343  O   ASP    28      30.981  39.250  48.419  1.00 41.99           O  
ATOM   1344  CB  ASP    28      31.504  41.876  50.056  1.00 44.61           C  
ATOM   1345  CG  ASP    28      32.015  41.950  51.499  1.00 50.08           C  
ATOM   1346  OD1 ASP    28      32.189  40.877  52.115  1.00 52.94           O  
ATOM   1347  OD2 ASP    28      32.229  43.067  52.026  1.00 53.70           O  
ATOM   1348  N   HIS    29      31.575  40.767  46.875  1.00 40.09           N  
ATOM   1349  CA  HIS    29      30.784  40.157  45.813  1.00 38.00           C  
ATOM   1350  C   HIS    29      31.591  39.254  44.869  1.00 35.48           C  
ATOM   1351  O   HIS    29      31.047  38.750  43.891  1.00 34.55           O  
ATOM   1352  CB  HIS    29      30.051  41.241  45.014  1.00 37.73           C  
ATOM   1353  CG  HIS    29      28.769  41.692  45.637  1.00 38.39           C  
ATOM   1354  ND1 HIS    29      28.368  43.010  45.641  1.00 39.31           N  
ATOM   1355  CD2 HIS    29      27.793  40.999  46.267  1.00 39.76           C  
ATOM   1356  CE1 HIS    29      27.201  43.109  46.251  1.00 41.37           C  
ATOM   1357  NE2 HIS    29      26.830  41.903  46.639  1.00 41.73           N  
ATOM   1358  N   TYR    30      32.873  39.052  45.163  1.00 33.70           N  
ATOM   1359  CA  TYR    30      33.706  38.095  44.423  1.00 32.36           C  
ATOM   1360  C   TYR    30      33.079  36.686  44.430  1.00 32.70           C  
ATOM   1361  O   TYR    30      33.074  35.983  43.416  1.00 32.96           O  
ATOM   1362  CB  TYR    30      35.106  38.029  45.044  1.00 31.66           C  
ATOM   1363  CG  TYR    30      36.109  39.075  44.583  1.00 30.06           C  
ATOM   1364  CD1 TYR    30      35.708  40.312  44.111  1.00 29.10           C  
ATOM   1365  CD2 TYR    30      37.483  38.822  44.672  1.00 30.44           C  
ATOM   1366  CE1 TYR    30      36.643  41.265  43.700  1.00 29.51           C  
ATOM   1367  CE2 TYR    30      38.421  39.763  44.272  1.00 29.19           C  
ATOM   1368  CZ  TYR    30      37.999  40.983  43.786  1.00 31.71           C  
ATOM   1369  OH  TYR    30      38.933  41.930  43.389  1.00 31.55           O  
ATOM   1370  N   SER    31      32.546  36.289  45.586  1.00 32.70           N  
ATOM   1371  CA  SER    31      31.925  34.974  45.767  1.00 31.27           C  
ATOM   1372  C   SER    31      30.485  34.902  45.255  1.00 29.76           C  
ATOM   1373  O   SER    31      29.886  33.828  45.261  1.00 29.74           O  
ATOM   1374  CB  SER    31      31.904  34.639  47.255  1.00 31.47           C  
ATOM   1375  OG  SER    31      31.001  35.510  47.929  1.00 31.56           O  
ATOM   1376  N   TYR    32      29.923  36.031  44.826  1.00 29.31           N  
ATOM   1377  CA  TYR    32      28.493  36.105  44.518  1.00 28.85           C  
ATOM   1378  C   TYR    32      28.089  35.149  43.394  1.00 30.14           C  
ATOM   1379  O   TYR    32      28.698  35.128  42.324  1.00 31.63           O  
ATOM   1380  CB  TYR    32      28.054  37.533  44.156  1.00 28.51           C  
ATOM   1381  CG  TYR    32      26.573  37.583  43.859  1.00 28.85           C  
ATOM   1382  CD1 TYR    32      25.640  37.573  44.892  1.00 30.87           C  
ATOM   1383  CD2 TYR    32      26.104  37.564  42.555  1.00 30.04           C  
ATOM   1384  CE1 TYR    32      24.285  37.577  44.632  1.00 31.57           C  
ATOM   1385  CE2 TYR    32      24.743  37.561  42.284  1.00 28.50           C  
ATOM   1386  CZ  TYR    32      23.840  37.567  43.328  1.00 30.20           C  
ATOM   1387  OH  TYR    32      22.491  37.566  43.071  1.00 27.86           O  
ATOM   1388  N   LYS    33      27.062  34.354  43.664  1.00 30.60           N  
ATOM   1389  CA  LYS    33      26.541  33.386  42.716  1.00 30.67           C  
ATOM   1390  C   LYS    33      25.036  33.621  42.611  1.00 29.00           C  
ATOM   1391  O   LYS    33      24.353  33.610  43.634  1.00 27.20           O  
ATOM   1392  CB  LYS    33      26.804  31.963  43.218  1.00 30.54           C  
ATOM   1393  CG  LYS    33      28.261  31.518  43.131  1.00 31.84           C  
ATOM   1394  CD  LYS    33      28.444  30.104  43.651  1.00 32.67           C  
ATOM   1395  CE  LYS    33      29.915  29.685  43.643  1.00 38.32           C  
ATOM   1396  NZ  LYS    33      30.093  28.233  43.927  1.00 35.17           N  
ATOM   1397  N   PRO    34      24.527  33.902  41.397  1.00 27.53           N  
ATOM   1398  CA  PRO    34      23.093  34.023  41.131  1.00 27.92           C  
ATOM   1399  C   PRO    34      22.258  32.808  41.526  1.00 27.42           C  
ATOM   1400  O   PRO    34      21.134  32.971  42.007  1.00 26.94           O  
ATOM   1401  CB  PRO    34      23.043  34.209  39.609  1.00 28.69           C  
ATOM   1402  CG  PRO    34      24.349  34.838  39.276  1.00 28.43           C  
ATOM   1403  CD  PRO    34      25.323  34.197  40.193  1.00 27.34           C  
ATOM   1404  N   ALA    35      22.800  31.615  41.282  1.00 28.20           N  
ATOM   1405  CA  ALA    35      22.192  30.348  41.691  1.00 29.19           C  
ATOM   1406  C   ALA    35      23.291  29.440  42.234  1.00 30.41           C  
ATOM   1407  O   ALA    35      24.477  29.688  41.984  1.00 29.92           O  
ATOM   1408  CB  ALA    35      21.486  29.688  40.515  1.00 27.66           C  
ATOM   1409  N   GLU    36      22.900  28.382  42.949  1.00 31.54           N  
ATOM   1410  CA  GLU    36      23.861  27.475  43.590  1.00 33.38           C  
ATOM   1411  C   GLU    36      24.823  26.807  42.625  1.00 32.55           C  
ATOM   1412  O   GLU    36      25.968  26.559  42.979  1.00 33.40           O  
ATOM   1413  CB  GLU    36      23.150  26.386  44.381  1.00 34.20           C  
ATOM   1414  CG  GLU    36      22.389  26.881  45.598  1.00 37.06           C  
ATOM   1415  CD  GLU    36      22.094  25.766  46.602  1.00 39.82           C  
ATOM   1416  OE1 GLU    36      22.175  24.569  46.227  1.00 44.32           O  
ATOM   1417  OE2 GLU    36      21.794  26.094  47.775  1.00 47.78           O  
ATOM   1418  N   THR    37      24.351  26.510  41.419  1.00 31.80           N  
ATOM   1419  CA  THR    37      25.157  25.853  40.393  1.00 31.56           C  
ATOM   1420  C   THR    37      25.885  26.843  39.474  1.00 32.32           C  
ATOM   1421  O   THR    37      26.457  26.434  38.474  1.00 33.55           O  
ATOM   1422  CB  THR    37      24.262  24.924  39.568  1.00 31.01           C  
ATOM   1423  OG1 THR    37      23.098  25.641  39.152  1.00 31.99           O  
ATOM   1424  CG2 THR    37      23.806  23.726  40.418  1.00 31.00           C  
ATOM   1425  N   SER    38      25.883  28.134  39.826  1.00 32.65           N  
ATOM   1426  CA  SER    38      26.541  29.182  39.021  1.00 31.97           C  
ATOM   1427  C   SER    38      28.004  29.341  39.378  1.00 30.83           C  
ATOM   1428  O   SER    38      28.405  28.993  40.476  1.00 31.30           O  
ATOM   1429  CB  SER    38      25.870  30.550  39.232  1.00 31.46           C  
ATOM   1430  OG  SER    38      24.536  30.548  38.778  1.00 32.46           O  
ATOM   1431  N   MET    39      28.791  29.880  38.446  1.00 30.71           N  
ATOM   1432  CA  MET    39      30.141  30.329  38.764  1.00 28.97           C  
ATOM   1433  C   MET    39      29.976  31.552  39.652  1.00 28.65           C  
ATOM   1434  O   MET    39      28.998  32.284  39.522  1.00 27.14           O  
ATOM   1435  CB  MET    39      30.933  30.734  37.516  1.00 28.74           C  
ATOM   1436  CG  MET    39      31.363  29.598  36.573  1.00 31.41           C  
ATOM   1437  SD  MET    39      32.514  30.228  35.067  0.75 25.74          SE  
ATOM   1438  CE  MET    39      34.264  29.826  35.772  1.00 37.14           C  
ATOM   1439  N   SER    40      30.928  31.768  40.550  1.00 28.71           N  
ATOM   1440  CA  SER    40      30.961  32.977  41.347  1.00 28.93           C  
ATOM   1441  C   SER    40      31.356  34.119  40.422  1.00 29.26           C  
ATOM   1442  O   SER    40      31.856  33.886  39.321  1.00 28.27           O  
ATOM   1443  CB  SER    40      31.977  32.857  42.485  1.00 28.55           C  
ATOM   1444  OG  SER    40      33.300  32.845  41.971  1.00 31.56           O  
ATOM   1445  N   ALA    41      31.141  35.346  40.883  1.00 29.32           N  
ATOM   1446  CA  ALA    41      31.479  36.531  40.109  1.00 28.43           C  
ATOM   1447  C   ALA    41      32.928  36.492  39.643  1.00 28.87           C  
ATOM   1448  O   ALA    41      33.208  36.745  38.475  1.00 29.06           O  
ATOM   1449  CB  ALA    41      31.216  37.789  40.924  1.00 28.00           C  
ATOM   1450  N   GLU    42      33.844  36.156  40.549  1.00 30.19           N  
ATOM   1451  CA  GLU    42      35.266  36.137  40.215  1.00 32.30           C  
ATOM   1452  C   GLU    42      35.669  34.956  39.338  1.00 31.49           C  
ATOM   1453  O   GLU    42      36.549  35.098  38.495  1.00 31.64           O  
ATOM   1454  CB  GLU    42      36.150  36.217  41.468  1.00 32.29           C  
ATOM   1455  CG  GLU    42      36.145  35.016  42.371  1.00 35.81           C  
ATOM   1456  CD  GLU    42      37.144  35.156  43.514  1.00 36.28           C  
ATOM   1457  OE1 GLU    42      38.328  35.484  43.242  1.00 35.57           O  
ATOM   1458  OE2 GLU    42      36.744  34.923  44.680  1.00 43.97           O  
ATOM   1459  N   GLU    43      35.044  33.797  39.532  1.00 30.87           N  
ATOM   1460  CA  GLU    43      35.260  32.661  38.625  1.00 30.39           C  
ATOM   1461  C   GLU    43      34.845  33.040  37.214  1.00 29.35           C  
ATOM   1462  O   GLU    43      35.531  32.703  36.238  1.00 29.22           O  
ATOM   1463  CB  GLU    43      34.467  31.425  39.060  1.00 30.93           C  
ATOM   1464  CG  GLU    43      35.062  30.666  40.239  1.00 32.30           C  
ATOM   1465  CD  GLU    43      34.153  29.551  40.752  1.00 32.16           C  
ATOM   1466  OE1 GLU    43      32.930  29.604  40.535  1.00 35.30           O  
ATOM   1467  OE2 GLU    43      34.667  28.617  41.401  1.00 38.93           O  
ATOM   1468  N   LEU    44      33.722  33.747  37.111  1.00 27.81           N  
ATOM   1469  CA  LEU    44      33.205  34.170  35.813  1.00 27.14           C  
ATOM   1470  C   LEU    44      34.204  35.093  35.145  1.00 26.11           C  
ATOM   1471  O   LEU    44      34.615  34.849  34.019  1.00 26.10           O  
ATOM   1472  CB  LEU    44      31.835  34.853  35.958  1.00 27.33           C  
ATOM   1473  CG  LEU    44      31.197  35.427  34.687  1.00 26.54           C  
ATOM   1474  CD1 LEU    44      31.341  34.484  33.494  1.00 26.87           C  
ATOM   1475  CD2 LEU    44      29.729  35.714  34.941  1.00 25.50           C  
ATOM   1476  N   VAL    45      34.619  36.132  35.865  1.00 26.48           N  
ATOM   1477  CA  VAL    45      35.510  37.144  35.325  1.00 26.04           C  
ATOM   1478  C   VAL    45      36.867  36.552  34.944  1.00 27.08           C  
ATOM   1479  O   VAL    45      37.346  36.802  33.850  1.00 27.54           O  
ATOM   1480  CB  VAL    45      35.683  38.334  36.309  1.00 27.04           C  
ATOM   1481  CG1 VAL    45      36.744  39.312  35.797  1.00 25.46           C  
ATOM   1482  CG2 VAL    45      34.352  39.042  36.521  1.00 23.13           C  
ATOM   1483  N   LYS    46      37.482  35.767  35.827  1.00 28.21           N  
ATOM   1484  CA  LYS    46      38.793  35.155  35.522  1.00 29.00           C  
ATOM   1485  C   LYS    46      38.708  34.265  34.287  1.00 28.55           C  
ATOM   1486  O   LYS    46      39.629  34.250  33.464  1.00 29.07           O  
ATOM   1487  CB  LYS    46      39.324  34.321  36.690  1.00 29.20           C  
ATOM   1488  CG  LYS    46      39.776  35.118  37.886  1.00 31.60           C  
ATOM   1489  CD  LYS    46      40.299  34.197  38.968  1.00 29.66           C  
ATOM   1490  CE  LYS    46      40.389  34.916  40.294  1.00 37.54           C  
ATOM   1491  NZ  LYS    46      40.795  33.997  41.394  1.00 35.65           N  
ATOM   1492  N   HIS    47      37.616  33.505  34.172  1.00 27.91           N  
ATOM   1493  CA  HIS    47      37.432  32.622  33.016  1.00 27.17           C  
ATOM   1494  C   HIS    47      37.379  33.401  31.699  1.00 25.59           C  
ATOM   1495  O   HIS    47      37.956  32.964  30.704  1.00 26.75           O  
ATOM   1496  CB  HIS    47      36.190  31.743  33.159  1.00 27.46           C  
ATOM   1497  CG  HIS    47      35.905  30.922  31.937  1.00 28.87           C  
ATOM   1498  ND1 HIS    47      36.734  29.908  31.515  1.00 32.09           N  
ATOM   1499  CD2 HIS    47      34.908  30.996  31.025  1.00 28.90           C  
ATOM   1500  CE1 HIS    47      36.257  29.387  30.399  1.00 27.52           C  
ATOM   1501  NE2 HIS    47      35.146  30.027  30.083  1.00 28.54           N  
ATOM   1502  N   ILE    48      36.699  34.545  31.701  1.00 25.40           N  
ATOM   1503  CA  ILE    48      36.648  35.436  30.536  1.00 24.70           C  
ATOM   1504  C   ILE    48      38.065  35.852  30.154  1.00 25.30           C  
ATOM   1505  O   ILE    48      38.456  35.765  28.997  1.00 26.11           O  
ATOM   1506  CB  ILE    48      35.781  36.700  30.805  1.00 25.39           C  
ATOM   1507  CG1 ILE    48      34.294  36.324  30.910  1.00 26.97           C  
ATOM   1508  CG2 ILE    48      35.972  37.754  29.707  1.00 21.47           C  
ATOM   1509  CD1 ILE    48      33.372  37.436  31.476  1.00 21.56           C  
ATOM   1510  N   LEU    49      38.837  36.259  31.148  1.00 25.60           N  
ATOM   1511  CA  LEU    49      40.199  36.717  30.947  1.00 24.97           C  
ATOM   1512  C   LEU    49      41.170  35.634  30.482  1.00 25.95           C  
ATOM   1513  O   LEU    49      41.891  35.831  29.502  1.00 27.25           O  
ATOM   1514  CB  LEU    49      40.725  37.337  32.231  1.00 24.59           C  
ATOM   1515  CG  LEU    49      40.077  38.643  32.687  1.00 26.07           C  
ATOM   1516  CD1 LEU    49      40.707  39.082  34.017  1.00 25.43           C  
ATOM   1517  CD2 LEU    49      40.202  39.746  31.632  1.00 21.72           C  
ATOM   1518  N   THR    50      41.206  34.501  31.184  1.00 26.62           N  
ATOM   1519  CA  THR    50      42.139  33.428  30.831  1.00 26.53           C  
ATOM   1520  C   THR    50      41.768  32.721  29.518  1.00 28.19           C  
ATOM   1521  O   THR    50      42.664  32.330  28.753  1.00 29.08           O  
ATOM   1522  CB  THR    50      42.279  32.370  31.958  1.00 26.75           C  
ATOM   1523  OG1 THR    50      41.018  31.734  32.195  1.00 29.27           O  
ATOM   1524  CG2 THR    50      42.785  33.010  33.255  1.00 20.35           C  
ATOM   1525  N   SER    51      40.469  32.568  29.242  1.00 28.56           N  
ATOM   1526  CA  SER    51      40.053  31.808  28.064  1.00 29.13           C  
ATOM   1527  C   SER    51      40.431  32.521  26.777  1.00 28.90           C  
ATOM   1528  O   SER    51      40.940  31.880  25.847  1.00 30.53           O  
ATOM   1529  CB  SER    51      38.557  31.446  28.084  1.00 28.88           C  
ATOM   1530  OG  SER    51      37.727  32.590  28.069  1.00 33.02           O  
ATOM   1531  N   PHE    52      40.194  33.830  26.703  1.00 27.66           N  
ATOM   1532  CA  PHE    52      40.530  34.557  25.483  1.00 27.14           C  
ATOM   1533  C   PHE    52      42.039  34.554  25.296  1.00 27.70           C  
ATOM   1534  O   PHE    52      42.530  34.421  24.178  1.00 28.71           O  
ATOM   1535  CB  PHE    52      40.001  35.993  25.481  1.00 27.08           C  
ATOM   1536  CG  PHE    52      39.811  36.560  24.089  1.00 25.86           C  
ATOM   1537  CD1 PHE    52      40.907  36.795  23.256  1.00 25.78           C  
ATOM   1538  CD2 PHE    52      38.542  36.839  23.608  1.00 23.07           C  
ATOM   1539  CE1 PHE    52      40.725  37.299  21.977  1.00 26.17           C  
ATOM   1540  CE2 PHE    52      38.359  37.351  22.333  1.00 23.04           C  
ATOM   1541  CZ  PHE    52      39.446  37.570  21.514  1.00 23.22           C  
ATOM   1542  N   HIS    53      42.772  34.683  26.394  1.00 28.75           N  
ATOM   1543  CA  HIS    53      44.234  34.689  26.347  1.00 29.87           C  
ATOM   1544  C   HIS    53      44.799  33.336  25.861  1.00 29.22           C  
ATOM   1545  O   HIS    53      45.774  33.303  25.101  1.00 28.96           O  
ATOM   1546  CB  HIS    53      44.812  35.081  27.710  1.00 29.38           C  
ATOM   1547  CG  HIS    53      46.297  35.259  27.699  1.00 32.09           C  
ATOM   1548  ND1 HIS    53      47.161  34.324  28.221  1.00 36.75           N  
ATOM   1549  CD2 HIS    53      47.071  36.250  27.200  1.00 34.27           C  
ATOM   1550  CE1 HIS    53      48.405  34.738  28.056  1.00 36.33           C  
ATOM   1551  NE2 HIS    53      48.377  35.904  27.439  1.00 35.25           N  
ATOM   1552  N   LEU    54      44.175  32.237  26.280  1.00 28.84           N  
ATOM   1553  CA  LEU    54      44.545  30.908  25.787  1.00 29.41           C  
ATOM   1554  C   LEU    54      44.344  30.820  24.271  1.00 29.89           C  
ATOM   1555  O   LEU    54      45.283  30.469  23.530  1.00 28.10           O  
ATOM   1556  CB  LEU    54      43.746  29.812  26.501  1.00 28.57           C  
ATOM   1557  CG  LEU    54      44.049  28.359  26.102  1.00 30.83           C  
ATOM   1558  CD1 LEU    54      45.538  28.026  26.269  1.00 28.39           C  
ATOM   1559  CD2 LEU    54      43.180  27.371  26.890  1.00 30.29           C  
ATOM   1560  N   PHE    55      43.134  31.159  23.817  1.00 30.20           N  
ATOM   1561  CA  PHE    55      42.819  31.153  22.382  1.00 32.29           C  
ATOM   1562  C   PHE    55      43.787  32.023  21.577  1.00 31.95           C  
ATOM   1563  O   PHE    55      44.243  31.620  20.510  1.00 32.57           O  
ATOM   1564  CB  PHE    55      41.398  31.652  22.119  1.00 34.13           C  
ATOM   1565  CG  PHE    55      40.317  30.681  22.505  1.00 36.99           C  
ATOM   1566  CD1 PHE    55      40.343  29.372  22.063  1.00 39.85           C  
ATOM   1567  CD2 PHE    55      39.236  31.104  23.275  1.00 45.14           C  
ATOM   1568  CE1 PHE    55      39.330  28.494  22.403  1.00 44.15           C  
ATOM   1569  CE2 PHE    55      38.220  30.231  23.620  1.00 45.62           C  
ATOM   1570  CZ  PHE    55      38.263  28.923  23.179  1.00 43.03           C  
ATOM   1571  N   ALA    56      44.077  33.221  22.089  1.00 31.31           N  
ATOM   1572  CA  ALA    56      45.030  34.131  21.448  1.00 30.70           C  
ATOM   1573  C   ALA    56      46.421  33.491  21.272  1.00 29.92           C  
ATOM   1574  O   ALA    56      47.059  33.654  20.231  1.00 30.50           O  
ATOM   1575  CB  ALA    56      45.132  35.443  22.241  1.00 30.35           C  
ATOM   1576  N   ASN    57      46.879  32.749  22.274  1.00 30.14           N  
ATOM   1577  CA  ASN    57      48.161  32.034  22.164  1.00 31.35           C  
ATOM   1578  C   ASN    57      48.100  30.807  21.225  1.00 32.06           C  
ATOM   1579  O   ASN    57      49.095  30.465  20.591  1.00 32.88           O  
ATOM   1580  CB  ASN    57      48.708  31.665  23.553  1.00 31.09           C  
ATOM   1581  CG  ASN    57      49.664  32.728  24.110  1.00 33.29           C  
ATOM   1582  OD1 ASN    57      50.701  33.008  23.514  1.00 36.72           O  
ATOM   1583  ND2 ASN    57      49.326  33.305  25.261  1.00 32.00           N  
ATOM   1584  N   VAL    58      46.936  30.166  21.120  1.00 32.60           N  
ATOM   1585  CA  VAL    58      46.760  29.045  20.194  1.00 32.08           C  
ATOM   1586  C   VAL    58      46.876  29.526  18.742  1.00 32.30           C  
ATOM   1587  O   VAL    58      47.545  28.890  17.934  1.00 32.10           O  
ATOM   1588  CB  VAL    58      45.419  28.287  20.433  1.00 31.98           C  
ATOM   1589  CG1 VAL    58      45.237  27.157  19.410  1.00 29.82           C  
ATOM   1590  CG2 VAL    58      45.366  27.727  21.861  1.00 28.52           C  
ATOM   1591  N   ILE    59      46.235  30.650  18.422  1.00 32.76           N  
ATOM   1592  CA  ILE    59      46.363  31.279  17.092  1.00 33.21           C  
ATOM   1593  C   ILE    59      47.797  31.770  16.842  1.00 33.87           C  
ATOM   1594  O   ILE    59      48.332  31.642  15.741  1.00 33.61           O  
ATOM   1595  CB  ILE    59      45.427  32.500  16.938  1.00 33.99           C  
ATOM   1596  CG1 ILE    59      43.950  32.095  17.083  1.00 33.69           C  
ATOM   1597  CG2 ILE    59      45.664  33.206  15.586  1.00 31.95           C  
ATOM   1598  CD1 ILE    59      43.006  33.284  17.176  1.00 32.20           C  
ATOM   1599  N   LYS    60      48.411  32.330  17.872  1.00 35.71           N  
ATOM   1600  CA  LYS    60      49.772  32.840  17.767  1.00 37.57           C  
ATOM   1601  C   LYS    60      50.764  31.721  17.441  1.00 38.24           C  
ATOM   1602  O   LYS    60      51.604  31.872  16.562  1.00 37.60           O  
ATOM   1603  CB  LYS    60      50.174  33.557  19.062  1.00 37.54           C  
ATOM   1604  CG  LYS    60      51.655  33.883  19.189  1.00 36.89           C  
ATOM   1605  CD  LYS    60      51.907  34.811  20.361  1.00 39.39           C  
ATOM   1606  CE  LYS    60      53.381  34.926  20.678  1.00 43.88           C  
ATOM   1607  NZ  LYS    60      53.698  36.138  21.480  1.00 45.53           N  
ATOM   1608  N   GLU    61      50.662  30.603  18.150  1.00 39.86           N  
ATOM   1609  CA  GLU    61      51.580  29.486  17.934  1.00 40.82           C  
ATOM   1610  C   GLU    61      51.197  28.632  16.722  1.00 41.21           C  
ATOM   1611  O   GLU    61      52.065  28.113  16.025  1.00 41.01           O  
ATOM   1612  CB  GLU    61      51.673  28.611  19.193  1.00 40.22           C  
ATOM   1613  CG  GLU    61      52.201  29.330  20.445  1.00 41.09           C  
ATOM   1614  CD  GLU    61      53.587  29.968  20.275  1.00 41.98           C  
ATOM   1615  OE1 GLU    61      54.314  29.626  19.319  1.00 43.56           O  
ATOM   1616  OE2 GLU    61      53.956  30.816  21.114  1.00 41.89           O  
ATOM   1617  N   GLY    62      49.896  28.506  16.472  1.00 42.51           N  
ATOM   1618  CA  GLY    62      49.378  27.596  15.455  1.00 43.05           C  
ATOM   1619  C   GLY    62      49.304  26.169  15.972  1.00 43.55           C  
ATOM   1620  O   GLY    62      48.994  25.252  15.216  1.00 44.20           O  
ATOM   1621  N   ASN    63      49.576  25.996  17.266  1.00 44.07           N  
ATOM   1622  CA  ASN    63      49.674  24.692  17.917  1.00 44.21           C  
ATOM   1623  C   ASN    63      48.667  24.579  19.044  1.00 44.05           C  
ATOM   1624  O   ASN    63      48.103  25.579  19.482  1.00 43.63           O  
ATOM   1625  CB  ASN    63      51.057  24.530  18.552  1.00 43.35           C  
ATOM   1626  CG  ASN    63      52.175  24.755  17.581  1.00 46.03           C  
ATOM   1627  OD1 ASN    63      52.015  24.563  16.380  1.00 56.39           O  
ATOM   1628  ND2 ASN    63      53.329  25.158  18.093  1.00 46.14           N  
ATOM   1629  N   ALA    64      48.497  23.354  19.541  1.00 44.06           N  
ATOM   1630  CA  ALA    64      47.735  23.100  20.759  1.00 43.65           C  
ATOM   1631  C   ALA    64      48.652  23.159  21.986  1.00 42.60           C  
ATOM   1632  O   ALA    64      48.215  22.878  23.100  1.00 42.66           O  
ATOM   1633  CB  ALA    64      47.047  21.750  20.674  1.00 44.16           C  
ATOM   1634  N   SER    65      49.913  23.548  21.778  1.00 41.62           N  
ATOM   1635  CA  SER    65      50.914  23.588  22.848  1.00 40.66           C  
ATOM   1636  C   SER    65      50.624  24.576  23.992  1.00 39.74           C  
ATOM   1637  O   SER    65      50.986  24.293  25.121  1.00 39.46           O  
ATOM   1638  CB  SER    65      52.332  23.802  22.273  1.00 39.86           C  
ATOM   1639  OG  SER    65      52.479  25.053  21.630  1.00 38.52           O  
ATOM   1640  N   PRO    66      49.983  25.731  23.718  1.00 39.50           N  
ATOM   1641  CA  PRO    66      49.632  26.610  24.848  1.00 39.62           C  
ATOM   1642  C   PRO    66      48.674  26.005  25.903  1.00 40.52           C  
ATOM   1643  O   PRO    66      48.529  26.577  26.989  1.00 40.07           O  
ATOM   1644  CB  PRO    66      48.999  27.830  24.163  1.00 39.89           C  
ATOM   1645  CG  PRO    66      49.525  27.792  22.756  1.00 39.12           C  
ATOM   1646  CD  PRO    66      49.599  26.337  22.428  1.00 39.03           C  
ATOM   1647  N   PHE    67      48.033  24.874  25.599  1.00 41.75           N  
ATOM   1648  CA  PHE    67      47.273  24.136  26.617  1.00 43.43           C  
ATOM   1649  C   PHE    67      48.212  23.489  27.643  1.00 44.65           C  
ATOM   1650  O   PHE    67      47.832  23.293  28.801  1.00 44.48           O  
ATOM   1651  CB  PHE    67      46.384  23.053  25.996  1.00 44.15           C  
ATOM   1652  CG  PHE    67      45.455  23.559  24.931  1.00 45.35           C  
ATOM   1653  CD1 PHE    67      44.694  24.703  25.134  1.00 48.97           C  
ATOM   1654  CD2 PHE    67      45.327  22.883  23.728  1.00 47.36           C  
ATOM   1655  CE1 PHE    67      43.834  25.171  24.148  1.00 47.77           C  
ATOM   1656  CE2 PHE    67      44.476  23.353  22.740  1.00 47.83           C  
ATOM   1657  CZ  PHE    67      43.728  24.495  22.955  1.00 44.88           C  
ATOM   1658  N   GLN    68      49.425  23.149  27.209  1.00 46.69           N  
ATOM   1659  CA  GLN    68      50.444  22.560  28.089  1.00 48.37           C  
ATOM   1660  C   GLN    68      50.999  23.583  29.073  1.00 50.08           C  
ATOM   1661  O   GLN    68      51.458  23.216  30.156  1.00 50.91           O  
ATOM   1662  CB  GLN    68      51.607  21.962  27.275  1.00 48.44           C  
ATOM   1663  CG  GLN    68      51.370  20.560  26.709  1.00 49.99           C  
ATOM   1664  CD  GLN    68      50.026  20.407  26.019  1.00 50.43           C  
ATOM   1665  OE1 GLN    68      48.982  20.371  26.673  1.00 50.63           O  
ATOM   1666  NE2 GLN    68      50.047  20.305  24.691  1.00 50.53           N  
ATOM   1667  N   ASN    69      50.974  24.859  28.688  1.00 51.88           N  
ATOM   1668  CA  ASN    69      51.449  25.938  29.552  1.00 53.28           C  
ATOM   1669  C   ASN    69      50.511  26.154  30.740  1.00 54.71           C  
ATOM   1670  O   ASN    69      49.505  26.850  30.618  1.00 54.91           O  
ATOM   1671  CB  ASN    69      51.588  27.240  28.752  1.00 53.14           C  
ATOM   1672  N   LYS    70      50.835  25.536  31.874  1.00 57.03           N  
ATOM   1673  CA  LYS    70      50.099  25.758  33.119  1.00 58.38           C  
ATOM   1674  C   LYS    70      50.589  27.059  33.750  1.00 59.82           C  
ATOM   1675  O   LYS    70      51.596  27.058  34.465  1.00 59.85           O  
ATOM   1676  CB  LYS    70      50.324  24.599  34.092  1.00 58.61           C  
ATOM   1677  N   GLN    71      49.889  28.161  33.473  1.00 61.09           N  
ATOM   1678  CA  GLN    71      50.291  29.486  33.963  1.00 62.37           C  
ATOM   1679  C   GLN    71      49.654  29.793  35.321  1.00 63.43           C  
ATOM   1680  O   GLN    71      48.464  30.126  35.397  1.00 64.18           O  
ATOM   1681  CB  GLN    71      49.910  30.572  32.952  1.00 62.69           C  
ATOM   1682  N   GLU    72      50.451  29.679  36.386  1.00 63.24           N  
ATOM   1683  CA  GLU    72      49.984  29.958  37.746  1.00 62.89           C  
ATOM   1684  C   GLU    72      49.973  31.469  38.008  1.00 62.36           C  
ATOM   1685  O   GLU    72      50.992  32.045  38.403  1.00 62.30           O  
ATOM   1686  CB  GLU    72      50.871  29.246  38.777  1.00 62.86           C  
ATOM   1687  N   GLU    73      48.824  32.106  37.772  1.00 60.95           N  
ATOM   1688  CA  GLU    73      48.670  33.540  38.035  1.00 59.65           C  
ATOM   1689  C   GLU    73      48.477  33.737  39.540  1.00 57.43           C  
ATOM   1690  O   GLU    73      47.552  33.173  40.130  1.00 57.80           O  
ATOM   1691  CB  GLU    73      47.484  34.123  37.250  1.00 60.09           C  
ATOM   1692  CG  GLU    73      47.401  35.662  37.243  1.00 60.77           C  
ATOM   1693  CD  GLU    73      48.532  36.354  36.463  1.00 62.91           C  
ATOM   1694  OE1 GLU    73      49.224  35.689  35.663  1.00 64.78           O  
ATOM   1695  OE2 GLU    73      48.720  37.577  36.645  1.00 61.24           O  
ATOM   1696  N   THR    74      49.361  34.526  40.149  1.00 54.02           N  
ATOM   1697  CA  THR    74      49.358  34.754  41.597  1.00 52.74           C  
ATOM   1698  C   THR    74      48.387  35.863  42.044  1.00 51.44           C  
ATOM   1699  O   THR    74      47.943  35.871  43.196  1.00 51.74           O  
ATOM   1700  CB  THR    74      50.775  35.105  42.101  1.00 52.41           C  
ATOM   1701  N   GLU    75      48.058  36.784  41.135  1.00 49.36           N  
ATOM   1702  CA  GLU    75      47.214  37.939  41.455  1.00 47.02           C  
ATOM   1703  C   GLU    75      45.759  37.533  41.711  1.00 45.84           C  
ATOM   1704  O   GLU    75      45.231  36.654  41.029  1.00 46.17           O  
ATOM   1705  CB  GLU    75      47.283  38.962  40.312  1.00 46.52           C  
ATOM   1706  CG  GLU    75      46.513  40.248  40.573  1.00 44.62           C  
ATOM   1707  CD  GLU    75      47.058  41.016  41.759  1.00 42.04           C  
ATOM   1708  OE1 GLU    75      48.292  41.233  41.800  1.00 33.54           O  
ATOM   1709  OE2 GLU    75      46.253  41.402  42.637  1.00 35.78           O  
ATOM   1710  N   THR    76      45.133  38.178  42.697  1.00 44.18           N  
ATOM   1711  CA  THR    76      43.737  37.915  43.069  1.00 42.84           C  
ATOM   1712  C   THR    76      42.803  39.105  42.845  1.00 41.12           C  
ATOM   1713  O   THR    76      41.591  38.923  42.736  1.00 41.75           O  
ATOM   1714  CB  THR    76      43.627  37.523  44.548  1.00 43.10           C  
ATOM   1715  OG1 THR    76      44.363  38.464  45.345  1.00 44.47           O  
ATOM   1716  CG2 THR    76      44.167  36.111  44.770  1.00 43.34           C  
ATOM   1717  N   ASP    77      43.351  40.318  42.805  1.00 38.64           N  
ATOM   1718  CA  ASP    77      42.547  41.494  42.522  1.00 36.40           C  
ATOM   1719  C   ASP    77      42.053  41.379  41.091  1.00 34.51           C  
ATOM   1720  O   ASP    77      42.855  41.330  40.155  1.00 32.72           O  
ATOM   1721  CB  ASP    77      43.351  42.785  42.726  1.00 36.29           C  
ATOM   1722  CG  ASP    77      42.471  44.032  42.705  1.00 36.98           C  
ATOM   1723  OD1 ASP    77      41.907  44.355  41.639  1.00 32.41           O  
ATOM   1724  OD2 ASP    77      42.349  44.695  43.757  1.00 42.30           O  
ATOM   1725  N   LEU    78      40.728  41.321  40.945  1.00 33.17           N  
ATOM   1726  CA  LEU    78      40.084  41.188  39.644  1.00 31.83           C  
ATOM   1727  C   LEU    78      40.447  42.312  38.690  1.00 30.92           C  
ATOM   1728  O   LEU    78      40.630  42.063  37.501  1.00 30.51           O  
ATOM   1729  CB  LEU    78      38.554  41.136  39.777  1.00 31.06           C  
ATOM   1730  CG  LEU    78      37.884  39.831  40.213  1.00 30.15           C  
ATOM   1731  CD1 LEU    78      36.382  39.991  40.079  1.00 28.75           C  
ATOM   1732  CD2 LEU    78      38.360  38.634  39.408  1.00 26.53           C  
ATOM   1733  N   ASN    79      40.528  43.540  39.205  1.00 31.00           N  
ATOM   1734  CA  ASN    79      40.795  44.709  38.361  1.00 31.40           C  
ATOM   1735  C   ASN    79      42.207  44.677  37.806  1.00 30.64           C  
ATOM   1736  O   ASN    79      42.430  45.047  36.659  1.00 32.32           O  
ATOM   1737  CB  ASN    79      40.519  46.014  39.113  1.00 30.97           C  
ATOM   1738  CG  ASN    79      39.047  46.191  39.445  1.00 32.77           C  
ATOM   1739  OD1 ASN    79      38.169  45.793  38.669  1.00 34.47           O  
ATOM   1740  ND2 ASN    79      38.767  46.792  40.597  1.00 31.40           N  
ATOM   1741  N   VAL    80      43.145  44.198  38.613  1.00 30.86           N  
ATOM   1742  CA  VAL    80      44.527  43.995  38.176  1.00 30.48           C  
ATOM   1743  C   VAL    80      44.626  42.802  37.208  1.00 30.68           C  
ATOM   1744  O   VAL    80      45.369  42.850  36.230  1.00 32.36           O  
ATOM   1745  CB  VAL    80      45.453  43.767  39.378  1.00 30.21           C  
ATOM   1746  CG1 VAL    80      46.886  43.546  38.914  1.00 28.13           C  
ATOM   1747  CG2 VAL    80      45.352  44.942  40.345  1.00 27.39           C  
ATOM   1748  N   LEU    81      43.884  41.731  37.480  1.00 30.58           N  
ATOM   1749  CA  LEU    81      43.817  40.603  36.546  1.00 30.81           C  
ATOM   1750  C   LEU    81      43.247  41.057  35.200  1.00 30.95           C  
ATOM   1751  O   LEU    81      43.794  40.737  34.148  1.00 31.51           O  
ATOM   1752  CB  LEU    81      42.979  39.451  37.110  1.00 30.49           C  
ATOM   1753  CG  LEU    81      43.664  38.568  38.154  1.00 32.45           C  
ATOM   1754  CD1 LEU    81      42.657  37.683  38.888  1.00 28.60           C  
ATOM   1755  CD2 LEU    81      44.748  37.729  37.503  1.00 32.31           C  
ATOM   1756  N   ALA    82      42.162  41.827  35.243  1.00 31.30           N  
ATOM   1757  CA  ALA    82      41.511  42.328  34.029  1.00 29.87           C  
ATOM   1758  C   ALA    82      42.455  43.178  33.184  1.00 29.55           C  
ATOM   1759  O   ALA    82      42.555  42.976  31.975  1.00 29.00           O  
ATOM   1760  CB  ALA    82      40.252  43.108  34.382  1.00 27.98           C  
ATOM   1761  N   LYS    83      43.145  44.114  33.827  1.00 30.62           N  
ATOM   1762  CA  LYS    83      44.095  45.003  33.147  1.00 32.82           C  
ATOM   1763  C   LYS    83      45.278  44.247  32.545  1.00 31.38           C  
ATOM   1764  O   LYS    83      45.603  44.429  31.383  1.00 31.61           O  
ATOM   1765  CB  LYS    83      44.612  46.060  34.122  1.00 33.23           C  
ATOM   1766  CG  LYS    83      45.524  47.089  33.488  1.00 35.47           C  
ATOM   1767  CD  LYS    83      45.840  48.216  34.451  1.00 36.43           C  
ATOM   1768  CE  LYS    83      46.837  49.196  33.841  1.00 42.15           C  
ATOM   1769  NZ  LYS    83      47.235  50.260  34.808  1.00 48.16           N  
ATOM   1770  N   THR    84      45.915  43.410  33.352  1.00 31.31           N  
ATOM   1771  CA  THR    84      47.066  42.615  32.918  1.00 31.31           C  
ATOM   1772  C   THR    84      46.767  41.681  31.742  1.00 30.31           C  
ATOM   1773  O   THR    84      47.511  41.650  30.762  1.00 29.48           O  
ATOM   1774  CB  THR    84      47.595  41.795  34.095  1.00 30.96           C  
ATOM   1775  OG1 THR    84      48.174  42.693  35.047  1.00 32.33           O  
ATOM   1776  CG2 THR    84      48.648  40.779  33.637  1.00 34.24           C  
ATOM   1777  N   TYR    85      45.676  40.927  31.847  1.00 30.38           N  
ATOM   1778  CA  TYR    85      45.284  39.982  30.797  1.00 30.35           C  
ATOM   1779  C   TYR    85      44.820  40.665  29.510  1.00 29.76           C  
ATOM   1780  O   TYR    85      44.976  40.115  28.423  1.00 29.50           O  
ATOM   1781  CB  TYR    85      44.195  39.038  31.306  1.00 31.62           C  
ATOM   1782  CG  TYR    85      44.726  37.797  31.993  1.00 31.20           C  
ATOM   1783  CD1 TYR    85      45.237  36.746  31.245  1.00 32.21           C  
ATOM   1784  CD2 TYR    85      44.680  37.656  33.381  1.00 32.86           C  
ATOM   1785  CE1 TYR    85      45.701  35.590  31.850  1.00 32.84           C  
ATOM   1786  CE2 TYR    85      45.147  36.493  34.003  1.00 32.36           C  
ATOM   1787  CZ  TYR    85      45.657  35.467  33.229  1.00 33.24           C  
ATOM   1788  OH  TYR    85      46.137  34.309  33.811  1.00 34.89           O  
ATOM   1789  N   THR    86      44.235  41.848  29.638  1.00 31.05           N  
ATOM   1790  CA  THR    86      43.815  42.641  28.486  1.00 31.05           C  
ATOM   1791  C   THR    86      45.045  43.122  27.733  1.00 32.15           C  
ATOM   1792  O   THR    86      45.109  42.994  26.512  1.00 32.75           O  
ATOM   1793  CB  THR    86      42.918  43.820  28.928  1.00 30.81           C  
ATOM   1794  OG1 THR    86      41.726  43.284  29.508  1.00 29.76           O  
ATOM   1795  CG2 THR    86      42.532  44.732  27.760  1.00 26.40           C  
ATOM   1796  N   GLU    87      46.025  43.652  28.471  1.00 32.42           N  
ATOM   1797  CA  GLU    87      47.300  44.084  27.899  1.00 33.13           C  
ATOM   1798  C   GLU    87      48.047  42.928  27.211  1.00 31.43           C  
ATOM   1799  O   GLU    87      48.576  43.091  26.114  1.00 30.84           O  
ATOM   1800  CB  GLU    87      48.193  44.737  28.977  1.00 33.57           C  
ATOM   1801  CG  GLU    87      47.674  46.098  29.487  1.00 36.24           C  
ATOM   1802  CD  GLU    87      48.430  46.649  30.705  1.00 36.39           C  
ATOM   1803  OE1 GLU    87      49.213  45.898  31.339  1.00 42.87           O  
ATOM   1804  OE2 GLU    87      48.224  47.844  31.039  1.00 41.68           O  
ATOM   1805  N   LYS    88      48.086  41.769  27.857  1.00 30.05           N  
ATOM   1806  CA  LYS    88      48.724  40.586  27.275  1.00 31.07           C  
ATOM   1807  C   LYS    88      48.015  40.085  26.007  1.00 29.92           C  
ATOM   1808  O   LYS    88      48.669  39.628  25.061  1.00 30.19           O  
ATOM   1809  CB  LYS    88      48.768  39.444  28.295  1.00 31.28           C  
ATOM   1810  CG  LYS    88      49.807  39.588  29.405  1.00 32.74           C  
ATOM   1811  CD  LYS    88      49.487  38.619  30.542  1.00 34.44           C  
ATOM   1812  CE  LYS    88      50.726  38.125  31.283  1.00 39.86           C  
ATOM   1813  NZ  LYS    88      51.268  39.116  32.264  1.00 38.26           N  
ATOM   1814  N   THR    89      46.686  40.150  26.003  1.00 28.30           N  
ATOM   1815  CA  THR    89      45.907  39.659  24.876  1.00 26.91           C  
ATOM   1816  C   THR    89      45.994  40.627  23.697  1.00 26.04           C  
ATOM   1817  O   THR    89      46.155  40.197  22.563  1.00 25.57           O  
ATOM   1818  CB  THR    89      44.432  39.370  25.276  1.00 26.83           C  
ATOM   1819  OG1 THR    89      44.402  38.387  26.321  1.00 26.62           O  
ATOM   1820  CG2 THR    89      43.649  38.837  24.091  1.00 21.94           C  
ATOM   1821  N   VAL    90      45.916  41.928  23.970  1.00 25.73           N  
ATOM   1822  CA  VAL    90      46.100  42.954  22.935  1.00 24.97           C  
ATOM   1823  C   VAL    90      47.491  42.846  22.274  1.00 25.21           C  
ATOM   1824  O   VAL    90      47.625  42.875  21.044  1.00 24.21           O  
ATOM   1825  CB  VAL    90      45.922  44.368  23.530  1.00 26.15           C  
ATOM   1826  CG1 VAL    90      46.342  45.465  22.513  1.00 25.78           C  
ATOM   1827  CG2 VAL    90      44.477  44.564  24.014  1.00 24.53           C  
ATOM   1828  N   ALA    91      48.522  42.690  23.092  1.00 24.60           N  
ATOM   1829  CA  ALA    91      49.883  42.534  22.583  1.00 25.64           C  
ATOM   1830  C   ALA    91      49.993  41.348  21.616  1.00 27.64           C  
ATOM   1831  O   ALA    91      50.684  41.436  20.600  1.00 29.22           O  
ATOM   1832  CB  ALA    91      50.884  42.412  23.746  1.00 24.73           C  
ATOM   1833  N   ILE    92      49.284  40.255  21.896  1.00 29.04           N  
ATOM   1834  CA  ILE    92      49.251  39.131  20.956  1.00 29.11           C  
ATOM   1835  C   ILE    92      48.443  39.481  19.694  1.00 30.76           C  
ATOM   1836  O   ILE    92      48.935  39.307  18.568  1.00 31.05           O  
ATOM   1837  CB  ILE    92      48.682  37.846  21.579  1.00 29.24           C  
ATOM   1838  CG1 ILE    92      49.595  37.340  22.711  1.00 30.86           C  
ATOM   1839  CG2 ILE    92      48.552  36.775  20.506  1.00 23.58           C  
ATOM   1840  CD1 ILE    92      49.028  36.148  23.491  1.00 28.37           C  
ATOM   1841  N   LEU    93      47.221  39.983  19.890  1.00 30.68           N  
ATOM   1842  CA  LEU    93      46.329  40.312  18.782  1.00 31.19           C  
ATOM   1843  C   LEU    93      46.942  41.317  17.798  1.00 33.19           C  
ATOM   1844  O   LEU    93      46.804  41.152  16.584  1.00 32.19           O  
ATOM   1845  CB  LEU    93      44.981  40.836  19.305  1.00 30.38           C  
ATOM   1846  CG  LEU    93      44.072  39.867  20.066  1.00 28.57           C  
ATOM   1847  CD1 LEU    93      42.719  40.515  20.315  1.00 27.89           C  
ATOM   1848  CD2 LEU    93      43.904  38.560  19.325  1.00 24.19           C  
ATOM   1849  N   GLU    94      47.626  42.337  18.330  1.00 35.21           N  
ATOM   1850  CA  GLU    94      48.307  43.369  17.523  1.00 37.43           C  
ATOM   1851  C   GLU    94      49.279  42.824  16.477  1.00 38.02           C  
ATOM   1852  O   GLU    94      49.540  43.469  15.471  1.00 39.24           O  
ATOM   1853  CB  GLU    94      49.157  44.276  18.417  1.00 37.45           C  
ATOM   1854  CG  GLU    94      48.437  45.346  19.215  1.00 39.62           C  
ATOM   1855  CD  GLU    94      49.393  46.060  20.179  1.00 40.91           C  
ATOM   1856  OE1 GLU    94      50.569  45.626  20.285  1.00 44.33           O  
ATOM   1857  OE2 GLU    94      48.981  47.052  20.823  1.00 44.87           O  
ATOM   1858  N   GLN    95      49.868  41.672  16.757  1.00 38.62           N  
ATOM   1859  CA  GLN    95      50.925  41.131  15.921  1.00 39.16           C  
ATOM   1860  C   GLN    95      50.427  40.055  14.970  1.00 39.45           C  
ATOM   1861  O   GLN    95      51.135  39.700  14.038  1.00 40.62           O  
ATOM   1862  CB  GLN    95      52.020  40.554  16.816  1.00 40.08           C  
ATOM   1863  CG  GLN    95      52.579  41.550  17.832  1.00 42.36           C  
ATOM   1864  CD  GLN    95      53.520  42.551  17.202  1.00 46.73           C  
ATOM   1865  OE1 GLN    95      53.167  43.716  16.994  1.00 45.61           O  
ATOM   1866  NE2 GLN    95      54.729  42.096  16.877  1.00 50.68           N  
ATOM   1867  N   LEU    96      49.215  39.540  15.194  1.00 39.81           N  
ATOM   1868  CA  LEU    96      48.690  38.454  14.376  1.00 39.64           C  
ATOM   1869  C   LEU    96      48.600  38.845  12.906  1.00 40.14           C  
ATOM   1870  O   LEU    96      47.997  39.860  12.560  1.00 41.09           O  
ATOM   1871  CB  LEU    96      47.323  37.991  14.884  1.00 40.07           C  
ATOM   1872  CG  LEU    96      47.325  37.192  16.188  1.00 36.48           C  
ATOM   1873  CD1 LEU    96      45.897  36.863  16.590  1.00 34.41           C  
ATOM   1874  CD2 LEU    96      48.160  35.932  16.053  1.00 34.32           C  
ATOM   1875  N   THR    97      49.214  38.020  12.060  1.00 40.77           N  
ATOM   1876  CA  THR    97      49.279  38.234  10.615  1.00 40.51           C  
ATOM   1877  C   THR    97      48.149  37.480   9.901  1.00 40.99           C  
ATOM   1878  O   THR    97      47.577  36.530  10.442  1.00 40.42           O  
ATOM   1879  CB  THR    97      50.644  37.755  10.051  1.00 40.10           C  
ATOM   1880  OG1 THR    97      50.761  36.336  10.198  1.00 40.62           O  
ATOM   1881  CG2 THR    97      51.796  38.419  10.788  1.00 38.60           C  
ATOM   1882  N   GLU    98      47.826  37.916   8.688  1.00 41.70           N  
ATOM   1883  CA  GLU    98      46.781  37.269   7.889  1.00 42.96           C  
ATOM   1884  C   GLU    98      47.103  35.792   7.645  1.00 42.45           C  
ATOM   1885  O   GLU    98      46.204  34.969   7.536  1.00 42.13           O  
ATOM   1886  CB  GLU    98      46.577  38.023   6.565  1.00 43.80           C  
ATOM   1887  CG  GLU    98      45.735  39.297   6.722  1.00 46.73           C  
ATOM   1888  CD  GLU    98      44.267  38.992   6.996  1.00 51.55           C  
ATOM   1889  OE1 GLU    98      43.648  38.291   6.166  1.00 53.83           O  
ATOM   1890  OE2 GLU    98      43.731  39.443   8.037  1.00 53.34           O  
ATOM   1891  N   GLU    99      48.396  35.478   7.588  1.00 42.79           N  
ATOM   1892  CA  GLU    99      48.895  34.105   7.480  1.00 43.72           C  
ATOM   1893  C   GLU    99      48.494  33.277   8.694  1.00 41.44           C  
ATOM   1894  O   GLU    99      48.041  32.136   8.555  1.00 40.91           O  
ATOM   1895  CB  GLU    99      50.427  34.128   7.368  1.00 44.27           C  
ATOM   1896  CG  GLU    99      51.118  32.763   7.344  1.00 47.94           C  
ATOM   1897  CD  GLU    99      52.606  32.854   7.693  1.00 48.92           C  
ATOM   1898  OE1 GLU    99      52.937  33.477   8.732  1.00 61.99           O  
ATOM   1899  OE2 GLU    99      53.440  32.296   6.939  1.00 52.94           O  
ATOM   1900  N   GLN   100      48.693  33.847   9.883  1.00 39.56           N  
ATOM   1901  CA  GLN   100      48.308  33.198  11.140  1.00 37.57           C  
ATOM   1902  C   GLN   100      46.789  33.034  11.271  1.00 35.88           C  
ATOM   1903  O   GLN   100      46.315  32.075  11.865  1.00 34.56           O  
ATOM   1904  CB  GLN   100      48.865  33.972  12.335  1.00 37.95           C  
ATOM   1905  CG  GLN   100      50.361  33.753  12.560  1.00 35.36           C  
ATOM   1906  CD  GLN   100      50.928  34.653  13.650  1.00 37.02           C  
ATOM   1907  OE1 GLN   100      50.688  35.861  13.655  1.00 35.51           O  
ATOM   1908  NE2 GLN   100      51.688  34.064  14.577  1.00 28.77           N  
ATOM   1909  N   LEU   101      46.041  33.973  10.700  1.00 36.17           N  
ATOM   1910  CA  LEU   101      44.583  33.911  10.672  1.00 36.04           C  
ATOM   1911  C   LEU   101      44.073  32.913   9.633  1.00 37.42           C  
ATOM   1912  O   LEU   101      43.082  32.221   9.870  1.00 38.35           O  
ATOM   1913  CB  LEU   101      44.009  35.305  10.394  1.00 35.43           C  
ATOM   1914  CG  LEU   101      44.231  36.320  11.524  1.00 34.17           C  
ATOM   1915  CD1 LEU   101      44.014  37.731  11.053  1.00 35.54           C  
ATOM   1916  CD2 LEU   101      43.314  36.006  12.707  1.00 29.97           C  
ATOM   1917  N   ASP   102      44.753  32.842   8.488  1.00 38.87           N  
ATOM   1918  CA  ASP   102      44.334  31.980   7.378  1.00 39.41           C  
ATOM   1919  C   ASP   102      44.687  30.510   7.582  1.00 39.52           C  
ATOM   1920  O   ASP   102      43.960  29.630   7.119  1.00 40.06           O  
ATOM   1921  CB  ASP   102      44.945  32.476   6.060  1.00 40.18           C  
ATOM   1922  CG  ASP   102      44.274  33.742   5.538  1.00 41.84           C  
ATOM   1923  OD1 ASP   102      43.098  33.969   5.877  1.00 44.15           O  
ATOM   1924  OD2 ASP   102      44.916  34.501   4.776  1.00 44.89           O  
ATOM   1925  N   ARG   103      45.780  30.242   8.288  1.00 39.77           N  
ATOM   1926  CA  ARG   103      46.285  28.875   8.425  1.00 40.80           C  
ATOM   1927  C   ARG   103      45.443  27.996   9.334  1.00 41.55           C  
ATOM   1928  O   ARG   103      44.794  28.468  10.260  1.00 41.57           O  
ATOM   1929  CB  ARG   103      47.731  28.872   8.931  1.00 40.90           C  
ATOM   1930  CG  ARG   103      47.888  29.243  10.392  1.00 42.29           C  
ATOM   1931  CD  ARG   103      49.339  29.471  10.724  1.00 44.86           C  
ATOM   1932  NE  ARG   103      49.550  29.752  12.139  1.00 45.75           N  
ATOM   1933  CZ  ARG   103      50.715  30.125  12.661  1.00 47.88           C  
ATOM   1934  NH1 ARG   103      51.797  30.276  11.895  1.00 46.92           N  
ATOM   1935  NH2 ARG   103      50.802  30.357  13.962  1.00 48.77           N  
ATOM   1936  N   GLU   104      45.500  26.700   9.059  1.00 42.30           N  
ATOM   1937  CA  GLU   104      44.841  25.683   9.859  1.00 42.85           C  
ATOM   1938  C   GLU   104      45.654  25.353  11.112  1.00 41.15           C  
ATOM   1939  O   GLU   104      46.859  25.119  11.035  1.00 40.82           O  
ATOM   1940  CB  GLU   104      44.662  24.412   9.025  1.00 43.55           C  
ATOM   1941  CG  GLU   104      43.506  23.559   9.459  1.00 48.29           C  
ATOM   1942  CD  GLU   104      42.933  22.766   8.320  1.00 54.58           C  
ATOM   1943  OE1 GLU   104      43.648  21.883   7.807  1.00 57.58           O  
ATOM   1944  OE2 GLU   104      41.772  23.036   7.941  1.00 58.33           O  
ATOM   1945  N   ILE   105      44.980  25.348  12.258  1.00 40.26           N  
ATOM   1946  CA  ILE   105      45.561  24.903  13.517  1.00 39.85           C  
ATOM   1947  C   ILE   105      45.102  23.459  13.741  1.00 40.87           C  
ATOM   1948  O   ILE   105      43.896  23.195  13.806  1.00 38.41           O  
ATOM   1949  CB  ILE   105      45.100  25.787  14.698  1.00 39.56           C  
ATOM   1950  CG1 ILE   105      45.389  27.263  14.410  1.00 41.36           C  
ATOM   1951  CG2 ILE   105      45.783  25.371  15.987  1.00 36.65           C  
ATOM   1952  CD1 ILE   105      44.838  28.207  15.451  1.00 38.91           C  
ATOM   1953  N   ASP   106      46.055  22.530  13.838  1.00 43.16           N  
ATOM   1954  CA  ASP   106      45.735  21.110  14.079  1.00 45.33           C  
ATOM   1955  C   ASP   106      45.508  20.819  15.575  1.00 46.30           C  
ATOM   1956  O   ASP   106      46.472  20.721  16.343  1.00 47.07           O  
ATOM   1957  CB  ASP   106      46.851  20.206  13.529  1.00 45.75           C  
ATOM   1958  CG  ASP   106      46.547  18.715  13.689  1.00 48.90           C  
ATOM   1959  OD1 ASP   106      45.436  18.361  14.159  1.00 54.25           O  
ATOM   1960  OD2 ASP   106      47.426  17.896  13.340  1.00 48.22           O  
ATOM   1961  N   LEU   107      44.242  20.665  15.974  1.00 47.64           N  
ATOM   1962  CA  LEU   107      43.881  20.387  17.375  1.00 48.79           C  
ATOM   1963  C   LEU   107      43.225  19.004  17.581  1.00 49.78           C  
ATOM   1964  O   LEU   107      42.345  18.605  16.814  1.00 51.17           O  
ATOM   1965  CB  LEU   107      42.946  21.482  17.904  1.00 48.93           C  
ATOM   1966  CG  LEU   107      43.479  22.915  17.843  1.00 48.72           C  
ATOM   1967  CD1 LEU   107      42.485  23.893  18.457  1.00 47.04           C  
ATOM   1968  CD2 LEU   107      44.823  23.024  18.539  1.00 50.50           C  
ATOM   1969  N   THR   108      43.654  18.293  18.630  1.00 49.87           N  
ATOM   1970  CA  THR   108      43.136  16.954  18.974  1.00 48.10           C  
ATOM   1971  C   THR   108      41.608  16.879  18.933  1.00 48.72           C  
ATOM   1972  O   THR   108      41.034  16.018  18.261  1.00 48.58           O  
ATOM   1973  CB  THR   108      43.602  16.500  20.395  1.00 48.19           C  
ATOM   1974  OG1 THR   108      43.218  17.476  21.378  1.00 40.35           O  
ATOM   1975  CG2 THR   108      45.114  16.291  20.439  1.00 45.16           C  
ATOM   1976  N   LYS   114      40.560  20.285  13.549  1.00 48.83           N  
ATOM   1977  CA  LYS   114      41.339  21.284  12.829  1.00 47.35           C  
ATOM   1978  C   LYS   114      40.493  22.541  12.660  1.00 45.69           C  
ATOM   1979  O   LYS   114      39.291  22.459  12.389  1.00 45.34           O  
ATOM   1980  CB  LYS   114      41.802  20.739  11.475  1.00 46.66           C  
ATOM   1981  N   VAL   115      41.122  23.699  12.841  1.00 42.98           N  
ATOM   1982  CA  VAL   115      40.424  24.983  12.796  1.00 40.69           C  
ATOM   1983  C   VAL   115      41.403  26.064  12.356  1.00 37.96           C  
ATOM   1984  O   VAL   115      42.580  26.010  12.700  1.00 37.13           O  
ATOM   1985  CB  VAL   115      39.827  25.330  14.188  1.00 41.29           C  
ATOM   1986  CG1 VAL   115      40.938  25.423  15.230  1.00 41.11           C  
ATOM   1987  CG2 VAL   115      39.014  26.625  14.141  1.00 41.31           C  
ATOM   1988  N   THR   116      40.924  27.018  11.565  1.00 35.83           N  
ATOM   1989  CA  THR   116      41.747  28.147  11.129  1.00 34.25           C  
ATOM   1990  C   THR   116      41.888  29.156  12.249  1.00 34.16           C  
ATOM   1991  O   THR   116      40.982  29.294  13.064  1.00 34.64           O  
ATOM   1992  CB  THR   116      41.095  28.887   9.978  1.00 34.35           C  
ATOM   1993  OG1 THR   116      39.768  29.268  10.376  1.00 33.55           O  
ATOM   1994  CG2 THR   116      41.045  28.007   8.736  1.00 26.14           C  
ATOM   1995  N   GLY   117      43.000  29.883  12.275  1.00 33.53           N  
ATOM   1996  CA  GLY   117      43.191  30.940  13.265  1.00 32.87           C  
ATOM   1997  C   GLY   117      41.993  31.880  13.316  1.00 32.75           C  
ATOM   1998  O   GLY   117      41.549  32.261  14.400  1.00 32.20           O  
ATOM   1999  N   ARG   118      41.468  32.232  12.139  1.00 33.22           N  
ATOM   2000  CA  ARG   118      40.315  33.129  12.006  1.00 34.94           C  
ATOM   2001  C   ARG   118      39.071  32.565  12.685  1.00 33.27           C  
ATOM   2002  O   ARG   118      38.391  33.268  13.432  1.00 34.97           O  
ATOM   2003  CB  ARG   118      40.008  33.398  10.528  1.00 34.63           C  
ATOM   2004  CG  ARG   118      39.075  34.578  10.287  1.00 38.04           C  
ATOM   2005  CD  ARG   118      38.912  34.917   8.796  1.00 41.22           C  
ATOM   2006  NE  ARG   118      40.200  35.077   8.112  1.00 48.85           N  
ATOM   2007  CZ  ARG   118      41.000  36.138   8.220  1.00 48.59           C  
ATOM   2008  NH1 ARG   118      40.677  37.176   8.988  1.00 49.41           N  
ATOM   2009  NH2 ARG   118      42.145  36.158   7.557  1.00 48.99           N  
ATOM   2010  N   ALA   119      38.770  31.298  12.427  1.00 30.92           N  
ATOM   2011  CA  ALA   119      37.577  30.682  12.994  1.00 29.20           C  
ATOM   2012  C   ALA   119      37.694  30.522  14.527  1.00 28.24           C  
ATOM   2013  O   ALA   119      36.694  30.620  15.245  1.00 27.02           O  
ATOM   2014  CB  ALA   119      37.300  29.361  12.328  1.00 29.59           C  
ATOM   2015  N   LEU   120      38.907  30.297  15.027  1.00 26.93           N  
ATOM   2016  CA  LEU   120      39.125  30.231  16.467  1.00 28.00           C  
ATOM   2017  C   LEU   120      39.018  31.640  17.102  1.00 27.86           C  
ATOM   2018  O   LEU   120      38.633  31.771  18.257  1.00 27.73           O  
ATOM   2019  CB  LEU   120      40.488  29.602  16.779  1.00 29.16           C  
ATOM   2020  CG  LEU   120      40.699  29.065  18.198  1.00 29.75           C  
ATOM   2021  CD1 LEU   120      39.857  27.808  18.433  1.00 35.18           C  
ATOM   2022  CD2 LEU   120      42.165  28.759  18.433  1.00 29.74           C  
ATOM   2023  N   LEU   121      39.359  32.683  16.346  1.00 28.09           N  
ATOM   2024  CA  LEU   121      39.228  34.057  16.832  1.00 27.44           C  
ATOM   2025  C   LEU   121      37.750  34.434  17.007  1.00 28.11           C  
ATOM   2026  O   LEU   121      37.378  35.044  18.004  1.00 28.73           O  
ATOM   2027  CB  LEU   121      39.920  35.041  15.889  1.00 26.16           C  
ATOM   2028  CG  LEU   121      39.829  36.523  16.266  1.00 27.90           C  
ATOM   2029  CD1 LEU   121      40.567  36.780  17.561  1.00 23.80           C  
ATOM   2030  CD2 LEU   121      40.358  37.411  15.134  1.00 27.70           C  
ATOM   2031  N   GLN   122      36.917  34.057  16.039  1.00 28.54           N  
ATOM   2032  CA  GLN   122      35.481  34.314  16.107  1.00 30.48           C  
ATOM   2033  C   GLN   122      34.866  33.560  17.293  1.00 30.29           C  
ATOM   2034  O   GLN   122      33.977  34.061  17.983  1.00 30.33           O  
ATOM   2035  CB  GLN   122      34.788  33.907  14.790  1.00 30.73           C  
ATOM   2036  CG  GLN   122      33.269  33.730  14.930  1.00 34.32           C  
ATOM   2037  CD  GLN   122      32.527  33.691  13.616  1.00 33.25           C  
ATOM   2038  OE1 GLN   122      32.635  34.605  12.807  1.00 42.39           O  
ATOM   2039  NE2 GLN   122      31.721  32.648  13.419  1.00 35.24           N  
ATOM   2040  N   LEU   123      35.343  32.341  17.495  1.00 29.79           N  
ATOM   2041  CA  LEU   123      34.918  31.500  18.594  1.00 30.76           C  
ATOM   2042  C   LEU   123      35.297  32.158  19.938  1.00 30.05           C  
ATOM   2043  O   LEU   123      34.511  32.159  20.881  1.00 28.56           O  
ATOM   2044  CB  LEU   123      35.581  30.124  18.426  1.00 32.64           C  
ATOM   2045  CG  LEU   123      35.088  28.918  19.208  1.00 36.41           C  
ATOM   2046  CD1 LEU   123      35.493  27.647  18.473  1.00 37.74           C  
ATOM   2047  CD2 LEU   123      35.638  28.950  20.633  1.00 37.75           C  
ATOM   2048  N   ALA   124      36.509  32.710  20.008  1.00 29.00           N  
ATOM   2049  CA  ALA   124      36.979  33.433  21.183  1.00 27.92           C  
ATOM   2050  C   ALA   124      36.140  34.689  21.458  1.00 27.85           C  
ATOM   2051  O   ALA   124      35.857  35.030  22.619  1.00 27.75           O  
ATOM   2052  CB  ALA   124      38.437  33.815  20.996  1.00 27.52           C  
ATOM   2053  N   MET   125      35.737  35.368  20.384  1.00 26.51           N  
ATOM   2054  CA  MET   125      34.935  36.579  20.487  1.00 24.50           C  
ATOM   2055  C   MET   125      33.523  36.293  20.949  1.00 23.15           C  
ATOM   2056  O   MET   125      32.950  37.063  21.705  1.00 23.24           O  
ATOM   2057  CB  MET   125      34.872  37.308  19.138  1.00 23.98           C  
ATOM   2058  CG  MET   125      36.151  38.017  18.740  1.00 24.55           C  
ATOM   2059  SD  MET   125      36.568  39.523  19.855  0.75 19.69          SE  
ATOM   2060  CE  MET   125      34.822  40.421  19.829  1.00 27.99           C  
ATOM   2061  N   GLU   126      32.949  35.198  20.472  1.00 22.92           N  
ATOM   2062  CA  GLU   126      31.589  34.833  20.863  1.00 22.67           C  
ATOM   2063  C   GLU   126      31.542  34.327  22.296  1.00 23.28           C  
ATOM   2064  O   GLU   126      30.535  34.500  22.995  1.00 24.32           O  
ATOM   2065  CB  GLU   126      31.017  33.797  19.905  1.00 22.12           C  
ATOM   2066  CG  GLU   126      30.912  34.295  18.466  1.00 19.97           C  
ATOM   2067  CD  GLU   126      30.242  33.303  17.552  1.00 21.02           C  
ATOM   2068  OE1 GLU   126      29.901  32.187  18.004  1.00 25.67           O  
ATOM   2069  OE2 GLU   126      30.029  33.658  16.382  1.00 23.17           O  
ATOM   2070  N   HIS   127      32.637  33.714  22.727  1.00 24.65           N  
ATOM   2071  CA  HIS   127      32.783  33.226  24.099  1.00 25.24           C  
ATOM   2072  C   HIS   127      32.844  34.408  25.069  1.00 24.32           C  
ATOM   2073  O   HIS   127      32.184  34.415  26.118  1.00 24.41           O  
ATOM   2074  CB  HIS   127      34.050  32.389  24.183  1.00 26.17           C  
ATOM   2075  CG  HIS   127      34.235  31.687  25.484  1.00 31.32           C  
ATOM   2076  ND1 HIS   127      33.450  30.626  25.876  1.00 38.61           N  
ATOM   2077  CD2 HIS   127      35.141  31.872  26.470  1.00 36.97           C  
ATOM   2078  CE1 HIS   127      33.861  30.195  27.054  1.00 39.40           C  
ATOM   2079  NE2 HIS   127      34.881  30.938  27.438  1.00 37.60           N  
ATOM   2080  N   GLU   128      33.625  35.417  24.699  1.00 23.98           N  
ATOM   2081  CA  GLU   128      33.678  36.673  25.445  1.00 22.90           C  
ATOM   2082  C   GLU   128      32.285  37.287  25.550  1.00 21.15           C  
ATOM   2083  O   GLU   128      31.845  37.655  26.629  1.00 19.73           O  
ATOM   2084  CB  GLU   128      34.610  37.659  24.747  1.00 22.49           C  
ATOM   2085  CG  GLU   128      34.708  39.049  25.408  1.00 27.83           C  
ATOM   2086  CD  GLU   128      35.846  39.181  26.415  1.00 28.43           C  
ATOM   2087  OE1 GLU   128      36.726  38.301  26.447  1.00 27.93           O  
ATOM   2088  OE2 GLU   128      35.860  40.190  27.156  1.00 30.92           O  
ATOM   2089  N   ILE   129      31.613  37.390  24.410  1.00 20.76           N  
ATOM   2090  CA  ILE   129      30.320  38.058  24.320  1.00 20.58           C  
ATOM   2091  C   ILE   129      29.281  37.312  25.140  1.00 21.24           C  
ATOM   2092  O   ILE   129      28.513  37.931  25.863  1.00 23.67           O  
ATOM   2093  CB  ILE   129      29.858  38.233  22.840  1.00 19.95           C  
ATOM   2094  CG1 ILE   129      30.767  39.241  22.133  1.00 20.52           C  
ATOM   2095  CG2 ILE   129      28.411  38.718  22.786  1.00 19.35           C  
ATOM   2096  CD1 ILE   129      30.746  39.177  20.613  1.00 19.09           C  
ATOM   2097  N   HIS   130      29.288  35.985  25.048  1.00 21.33           N  
ATOM   2098  CA  HIS   130      28.430  35.139  25.878  1.00 19.82           C  
ATOM   2099  C   HIS   130      28.572  35.420  27.373  1.00 20.82           C  
ATOM   2100  O   HIS   130      27.583  35.721  28.048  1.00 20.66           O  
ATOM   2101  CB  HIS   130      28.727  33.658  25.615  1.00 18.93           C  
ATOM   2102  CG  HIS   130      28.027  32.732  26.553  1.00 15.45           C  
ATOM   2103  ND1 HIS   130      26.658  32.550  26.535  1.00 14.36           N  
ATOM   2104  CD2 HIS   130      28.503  31.936  27.536  1.00 13.49           C  
ATOM   2105  CE1 HIS   130      26.323  31.696  27.484  1.00 15.06           C  
ATOM   2106  NE2 HIS   130      27.423  31.317  28.111  1.00 16.03           N  
ATOM   2107  N   HIS   131      29.799  35.303  27.882  1.00 21.96           N  
ATOM   2108  CA  HIS   131      30.080  35.424  29.318  1.00 21.31           C  
ATOM   2109  C   HIS   131      29.957  36.868  29.852  1.00 22.10           C  
ATOM   2110  O   HIS   131      29.656  37.088  31.034  1.00 20.92           O  
ATOM   2111  CB  HIS   131      31.461  34.839  29.643  1.00 21.24           C  
ATOM   2112  CG  HIS   131      31.522  33.343  29.551  1.00 22.99           C  
ATOM   2113  ND1 HIS   131      30.750  32.516  30.340  1.00 25.40           N  
ATOM   2114  CD2 HIS   131      32.274  32.525  28.776  1.00 23.84           C  
ATOM   2115  CE1 HIS   131      31.012  31.255  30.044  1.00 25.83           C  
ATOM   2116  NE2 HIS   131      31.936  31.233  29.101  1.00 26.08           N  
ATOM   2117  N   LYS   132      30.195  37.854  28.993  1.00 23.34           N  
ATOM   2118  CA  LYS   132      29.890  39.237  29.349  1.00 23.59           C  
ATOM   2119  C   LYS   132      28.368  39.353  29.502  1.00 24.59           C  
ATOM   2120  O   LYS   132      27.883  40.077  30.374  1.00 25.72           O  
ATOM   2121  CB  LYS   132      30.450  40.221  28.303  1.00 24.16           C  
ATOM   2122  CG  LYS   132      29.937  41.660  28.425  1.00 22.60           C  
ATOM   2123  CD  LYS   132      30.819  42.673  27.685  1.00 23.82           C  
ATOM   2124  CE  LYS   132      31.003  42.367  26.192  1.00 26.25           C  
ATOM   2125  NZ  LYS   132      29.783  42.581  25.373  1.00 19.16           N  
ATOM   2126  N   GLY   133      27.625  38.625  28.666  1.00 24.94           N  
ATOM   2127  CA  GLY   133      26.167  38.535  28.785  1.00 23.57           C  
ATOM   2128  C   GLY   133      25.738  37.992  30.140  1.00 24.46           C  
ATOM   2129  O   GLY   133      24.797  38.507  30.745  1.00 25.42           O  
ATOM   2130  N   ASN   134      26.421  36.946  30.616  1.00 24.53           N  
ATOM   2131  CA  ASN   134      26.212  36.447  31.981  1.00 23.49           C  
ATOM   2132  C   ASN   134      26.525  37.544  32.981  1.00 23.55           C  
ATOM   2133  O   ASN   134      25.752  37.789  33.899  1.00 23.87           O  
ATOM   2134  CB  ASN   134      27.137  35.279  32.349  1.00 24.25           C  
ATOM   2135  CG  ASN   134      27.000  34.066  31.443  1.00 22.64           C  
ATOM   2136  OD1 ASN   134      27.917  33.259  31.385  1.00 27.65           O  
ATOM   2137  ND2 ASN   134      25.884  33.927  30.755  1.00 22.69           N  
ATOM   2138  N   LEU   135      27.674  38.188  32.797  1.00 23.93           N  
ATOM   2139  CA  LEU   135      28.207  39.140  33.769  1.00 24.06           C  
ATOM   2140  C   LEU   135      27.286  40.331  34.014  1.00 24.23           C  
ATOM   2141  O   LEU   135      27.195  40.795  35.130  1.00 25.52           O  
ATOM   2142  CB  LEU   135      29.599  39.605  33.340  1.00 23.83           C  
ATOM   2143  CG  LEU   135      30.452  40.451  34.291  1.00 24.29           C  
ATOM   2144  CD1 LEU   135      30.640  39.807  35.676  1.00 20.22           C  
ATOM   2145  CD2 LEU   135      31.803  40.685  33.627  1.00 24.00           C  
ATOM   2146  N   PHE   136      26.617  40.814  32.967  1.00 24.58           N  
ATOM   2147  CA  PHE   136      25.647  41.896  33.073  1.00 24.76           C  
ATOM   2148  C   PHE   136      24.547  41.609  34.115  1.00 26.40           C  
ATOM   2149  O   PHE   136      24.153  42.502  34.871  1.00 24.96           O  
ATOM   2150  CB  PHE   136      24.994  42.160  31.714  1.00 25.02           C  
ATOM   2151  CG  PHE   136      25.603  43.297  30.961  1.00 25.69           C  
ATOM   2152  CD1 PHE   136      25.197  44.595  31.219  1.00 27.75           C  
ATOM   2153  CD2 PHE   136      26.590  43.077  29.998  1.00 23.95           C  
ATOM   2154  CE1 PHE   136      25.751  45.656  30.529  1.00 27.50           C  
ATOM   2155  CE2 PHE   136      27.150  44.126  29.303  1.00 22.33           C  
ATOM   2156  CZ  PHE   136      26.732  45.426  29.568  1.00 28.13           C  
ATOM   2157  N   VAL   137      24.049  40.374  34.143  1.00 26.43           N  
ATOM   2158  CA  VAL   137      23.008  40.004  35.098  1.00 25.49           C  
ATOM   2159  C   VAL   137      23.599  39.897  36.506  1.00 26.38           C  
ATOM   2160  O   VAL   137      22.977  40.346  37.462  1.00 27.33           O  
ATOM   2161  CB  VAL   137      22.254  38.714  34.667  1.00 26.90           C  
ATOM   2162  CG1 VAL   137      21.086  38.397  35.632  1.00 22.98           C  
ATOM   2163  CG2 VAL   137      21.726  38.861  33.238  1.00 21.37           C  
ATOM   2164  N   TYR   138      24.814  39.352  36.631  1.00 27.22           N  
ATOM   2165  CA  TYR   138      25.534  39.329  37.921  1.00 27.61           C  
ATOM   2166  C   TYR   138      25.601  40.731  38.527  1.00 28.62           C  
ATOM   2167  O   TYR   138      25.164  40.955  39.664  1.00 30.89           O  
ATOM   2168  CB  TYR   138      26.980  38.813  37.775  1.00 27.23           C  
ATOM   2169  CG  TYR   138      27.175  37.304  37.716  1.00 27.29           C  
ATOM   2170  CD1 TYR   138      26.675  36.558  36.664  1.00 26.10           C  
ATOM   2171  CD2 TYR   138      27.903  36.634  38.695  1.00 29.05           C  
ATOM   2172  CE1 TYR   138      26.872  35.177  36.590  1.00 24.62           C  
ATOM   2173  CE2 TYR   138      28.092  35.252  38.642  1.00 26.24           C  
ATOM   2174  CZ  TYR   138      27.577  34.534  37.582  1.00 26.62           C  
ATOM   2175  OH  TYR   138      27.771  33.174  37.491  1.00 27.21           O  
ATOM   2176  N   VAL   139      26.146  41.666  37.754  1.00 27.99           N  
ATOM   2177  CA  VAL   139      26.404  43.039  38.215  1.00 27.23           C  
ATOM   2178  C   VAL   139      25.129  43.810  38.552  1.00 27.92           C  
ATOM   2179  O   VAL   139      25.086  44.595  39.514  1.00 26.74           O  
ATOM   2180  CB  VAL   139      27.222  43.803  37.156  1.00 28.07           C  
ATOM   2181  CG1 VAL   139      27.307  45.289  37.484  1.00 28.06           C  
ATOM   2182  CG2 VAL   139      28.624  43.174  37.012  1.00 26.48           C  
ATOM   2183  N   ARG   140      24.099  43.592  37.744  1.00 29.05           N  
ATOM   2184  CA  ARG   140      22.773  44.168  37.964  1.00 31.02           C  
ATOM   2185  C   ARG   140      22.193  43.697  39.308  1.00 30.81           C  
ATOM   2186  O   ARG   140      21.591  44.480  40.046  1.00 30.77           O  
ATOM   2187  CB  ARG   140      21.863  43.745  36.804  1.00 32.60           C  
ATOM   2188  CG  ARG   140      20.404  44.195  36.878  1.00 40.15           C  
ATOM   2189  CD  ARG   140      20.154  45.498  36.168  1.00 42.74           C  
ATOM   2190  NE  ARG   140      20.623  45.454  34.785  1.00 44.57           N  
ATOM   2191  CZ  ARG   140      20.631  46.499  33.961  1.00 43.68           C  
ATOM   2192  NH1 ARG   140      20.180  47.690  34.364  1.00 42.68           N  
ATOM   2193  NH2 ARG   140      21.097  46.350  32.724  1.00 47.01           N  
ATOM   2194  N   GLU   141      22.378  42.412  39.606  1.00 31.43           N  
ATOM   2195  CA  GLU   141      21.960  41.809  40.885  1.00 30.94           C  
ATOM   2196  C   GLU   141      22.784  42.249  42.108  1.00 31.18           C  
ATOM   2197  O   GLU   141      22.380  42.019  43.250  1.00 30.01           O  
ATOM   2198  CB  GLU   141      21.989  40.281  40.789  1.00 31.38           C  
ATOM   2199  CG  GLU   141      20.789  39.711  40.078  1.00 29.43           C  
ATOM   2200  CD  GLU   141      20.871  38.218  39.838  1.00 29.00           C  
ATOM   2201  OE1 GLU   141      21.346  37.465  40.720  1.00 24.08           O  
ATOM   2202  OE2 GLU   141      20.434  37.798  38.751  1.00 24.21           O  
ATOM   2203  N   MET   142      23.935  42.872  41.866  1.00 31.32           N  
ATOM   2204  CA  MET   142      24.788  43.379  42.938  1.00 30.72           C  
ATOM   2205  C   MET   142      24.459  44.808  43.371  1.00 32.76           C  
ATOM   2206  O   MET   142      25.194  45.384  44.180  1.00 33.35           O  
ATOM   2207  CB  MET   142      26.247  43.366  42.498  1.00 30.80           C  
ATOM   2208  CG  MET   142      26.791  42.021  42.195  1.00 29.92           C  
ATOM   2209  SD  MET   142      28.615  42.104  41.579  0.75 23.20          SE  
ATOM   2210  CE  MET   142      28.655  43.665  40.756  1.00 18.45           C  
ATOM   2211  N   GLY   143      23.394  45.393  42.822  1.00 33.02           N  
ATOM   2212  CA  GLY   143      22.959  46.714  43.243  1.00 33.47           C  
ATOM   2213  C   GLY   143      23.214  47.819  42.232  1.00 34.81           C  
ATOM   2214  O   GLY   143      22.746  48.940  42.423  1.00 35.09           O  
ATOM   2215  N   HIS   144      23.943  47.516  41.159  1.00 35.68           N  
ATOM   2216  CA  HIS   144      24.277  48.516  40.138  1.00 36.43           C  
ATOM   2217  C   HIS   144      23.212  48.593  39.051  1.00 37.25           C  
ATOM   2218  O   HIS   144      22.838  47.584  38.459  1.00 36.10           O  
ATOM   2219  CB  HIS   144      25.643  48.218  39.538  1.00 36.53           C  
ATOM   2220  CG  HIS   144      26.725  48.147  40.564  1.00 36.63           C  
ATOM   2221  ND1 HIS   144      27.392  49.264  41.015  1.00 34.51           N  
ATOM   2222  CD2 HIS   144      27.217  47.101  41.267  1.00 41.34           C  
ATOM   2223  CE1 HIS   144      28.270  48.906  41.934  1.00 40.77           C  
ATOM   2224  NE2 HIS   144      28.181  47.599  42.111  1.00 42.86           N  
ATOM   2225  N   THR   145      22.720  49.802  38.808  1.00 39.71           N  
ATOM   2226  CA  THR   145      21.653  50.030  37.835  1.00 41.21           C  
ATOM   2227  C   THR   145      22.096  50.853  36.624  1.00 43.96           C  
ATOM   2228  O   THR   145      21.370  50.917  35.626  1.00 45.11           O  
ATOM   2229  CB  THR   145      20.451  50.766  38.477  1.00 40.95           C  
ATOM   2230  OG1 THR   145      20.784  52.148  38.677  1.00 36.83           O  
ATOM   2231  CG2 THR   145      20.050  50.122  39.813  1.00 38.96           C  
ATOM   2232  N   GLU   146      23.260  51.496  36.705  1.00 45.65           N  
ATOM   2233  CA  GLU   146      23.726  52.328  35.604  1.00 47.58           C  
ATOM   2234  C   GLU   146      24.886  51.616  34.924  1.00 46.33           C  
ATOM   2235  O   GLU   146      26.059  51.845  35.238  1.00 48.08           O  
ATOM   2236  CB  GLU   146      24.105  53.725  36.101  1.00 48.88           C  
ATOM   2237  CG  GLU   146      23.685  54.842  35.148  1.00 53.87           C  
ATOM   2238  CD  GLU   146      22.186  54.817  34.818  1.00 59.74           C  
ATOM   2239  OE1 GLU   146      21.360  54.933  35.753  1.00 62.56           O  
ATOM   2240  OE2 GLU   146      21.837  54.686  33.624  1.00 60.00           O  
ATOM   2241  N   LEU   147      24.535  50.731  33.998  1.00 43.13           N  
ATOM   2242  CA  LEU   147      25.511  49.860  33.355  1.00 40.71           C  
ATOM   2243  C   LEU   147      25.797  50.305  31.923  1.00 38.85           C  
ATOM   2244  O   LEU   147      24.917  50.848  31.242  1.00 37.87           O  
ATOM   2245  CB  LEU   147      25.016  48.411  33.365  1.00 40.10           C  
ATOM   2246  CG  LEU   147      24.740  47.799  34.743  1.00 39.60           C  
ATOM   2247  CD1 LEU   147      24.125  46.436  34.588  1.00 38.09           C  
ATOM   2248  CD2 LEU   147      26.011  47.720  35.575  1.00 37.18           C  
ATOM   2249  N   PRO   148      27.036  50.070  31.457  1.00 36.83           N  
ATOM   2250  CA  PRO   148      27.359  50.459  30.092  1.00 35.09           C  
ATOM   2251  C   PRO   148      26.522  49.694  29.079  1.00 32.85           C  
ATOM   2252  O   PRO   148      25.936  48.655  29.407  1.00 32.33           O  
ATOM   2253  CB  PRO   148      28.841  50.080  29.953  1.00 34.78           C  
ATOM   2254  CG  PRO   148      29.096  49.071  31.022  1.00 36.57           C  
ATOM   2255  CD  PRO   148      28.178  49.432  32.143  1.00 37.27           C  
ATOM   2256  N   PHE   149      26.440  50.234  27.871  1.00 30.90           N  
ATOM   2257  CA  PHE   149      25.923  49.487  26.742  1.00 29.22           C  
ATOM   2258  C   PHE   149      26.911  48.343  26.533  1.00 26.36           C  
ATOM   2259  O   PHE   149      28.108  48.498  26.802  1.00 26.92           O  
ATOM   2260  CB  PHE   149      25.825  50.378  25.500  1.00 29.54           C  
ATOM   2261  CG  PHE   149      25.075  49.745  24.365  1.00 31.48           C  
ATOM   2262  CD1 PHE   149      23.731  49.412  24.508  1.00 32.96           C  
ATOM   2263  CD2 PHE   149      25.708  49.468  23.162  1.00 31.91           C  
ATOM   2264  CE1 PHE   149      23.040  48.813  23.475  1.00 33.85           C  
ATOM   2265  CE2 PHE   149      25.017  48.876  22.123  1.00 34.43           C  
ATOM   2266  CZ  PHE   149      23.683  48.546  22.282  1.00 33.21           C  
ATOM   2267  N   TYR   150      26.428  47.209  26.045  1.00 25.14           N  
ATOM   2268  CA  TYR   150      27.236  45.986  26.041  1.00 26.48           C  
ATOM   2269  C   TYR   150      28.453  45.994  25.127  1.00 25.90           C  
ATOM   2270  O   TYR   150      29.319  45.125  25.246  1.00 26.81           O  
ATOM   2271  CB  TYR   150      26.372  44.766  25.751  1.00 27.38           C  
ATOM   2272  CG  TYR   150      25.858  44.654  24.346  1.00 27.41           C  
ATOM   2273  CD1 TYR   150      26.599  44.014  23.357  1.00 26.55           C  
ATOM   2274  CD2 TYR   150      24.599  45.154  24.011  1.00 33.30           C  
ATOM   2275  CE1 TYR   150      26.103  43.901  22.050  1.00 32.66           C  
ATOM   2276  CE2 TYR   150      24.090  45.035  22.725  1.00 34.22           C  
ATOM   2277  CZ  TYR   150      24.845  44.420  21.751  1.00 33.26           C  
ATOM   2278  OH  TYR   150      24.321  44.325  20.489  1.00 36.66           O  
ATOM   2279  N   GLN   151      28.514  46.963  24.224  1.00 25.97           N  
ATOM   2280  CA  GLN   151      29.643  47.114  23.323  1.00 28.02           C  
ATOM   2281  C   GLN   151      29.928  48.601  23.100  1.00 28.27           C  
ATOM   2282  O   GLN   151      29.011  49.379  22.893  1.00 26.65           O  
ATOM   2283  CB  GLN   151      29.326  46.447  21.977  1.00 28.59           C  
ATOM   2284  CG  GLN   151      30.572  46.158  21.157  1.00 31.58           C  
ATOM   2285  CD  GLN   151      30.308  45.843  19.693  1.00 29.46           C  
ATOM   2286  OE1 GLN   151      29.163  45.768  19.260  1.00 34.99           O  
ATOM   2287  NE2 GLN   151      31.381  45.675  18.920  1.00 28.17           N  
ATOM   2288  N   GLN   152      31.196  48.988  23.151  1.00 30.83           N  
ATOM   2289  CA  GLN   152      31.596  50.336  22.767  1.00 33.70           C  
ATOM   2290  C   GLN   152      31.634  50.422  21.243  1.00 36.95           C  
ATOM   2291  O   GLN   152      31.835  49.412  20.563  1.00 37.86           O  
ATOM   2292  CB  GLN   152      32.961  50.684  23.349  1.00 32.47           C  
ATOM   2293  CG  GLN   152      32.965  50.794  24.856  1.00 33.78           C  
ATOM   2294  CD  GLN   152      34.315  51.214  25.424  1.00 35.09           C  
ATOM   2295  OE1 GLN   152      35.319  51.317  24.704  1.00 32.29           O  
ATOM   2296  NE2 GLN   152      34.342  51.450  26.731  1.00 28.38           N  
ATOM   2297  N   ARG   153      31.444  51.622  20.707  1.00 38.84           N  
ATOM   2298  CA  ARG   153      31.447  51.820  19.252  1.00 40.64           C  
ATOM   2299  C   ARG   153      32.858  51.664  18.680  1.00 42.01           C  
ATOM   2300  O   ARG   153      33.351  50.543  18.488  1.00 44.29           O  
ATOM   2301  CB  ARG   153      30.889  53.206  18.903  1.00 39.42           C  
END
