
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  148 ( 1197),  selected  148 , name 2hkv_A
# Molecule2: number of CA atoms  144 ( 1145),  selected  144 , name T0481.pdb
# PARAMETERS: 2hkv_A.T0481.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_A      N       5           #
LGA    X     1_A      -       -           -
LGA    T     2_A      -       -           -
LGA    D     3_A      -       -           -
LGA    W     4_A      -       -           -
LGA    Q     5_A      -       -           -
LGA    Q     6_A      -       -           -
LGA    A     7_A      Q       6          4.466
LGA    L     8_A      I       7          3.456
LGA    D     9_A      V       8          3.470
LGA    R    10_A      S       9          3.393
LGA    H    11_A      H      10          2.542
LGA    V    12_A      F      11          1.630
LGA    G    13_A      L      12          1.736
LGA    V    14_A      S      13          0.797
LGA    G    15_A      H      14          0.542
LGA    V    16_A      R      15          1.426
LGA    R    17_A      N      16          1.174
LGA    T    18_A      V      17          1.004
LGA    T    19_A      T      18          1.283
LGA    R    20_A      N      19          1.563
LGA    D    21_A      E      20          1.008
LGA    L    22_A      L      21          1.062
LGA    I    23_A      A      22          1.380
LGA    R    24_A      E      23          1.485
LGA    L    25_A      K      24          1.497
LGA    I    26_A      I      25          1.387
LGA    Q    27_A      S      26          1.054
LGA    P    28_A      K      27          1.537
LGA    E    29_A      D      28          0.881
LGA    D    30_A      H      29          0.455
LGA    W    31_A      Y      30          0.588
LGA    D    32_A      S      31          1.316
LGA    K    33_A      Y      32          1.399
LGA    R    34_A      K      33          1.439
LGA    P    35_A      P      34          1.685
LGA    I    36_A      A      35          2.765
LGA    S    37_A      E      36          1.860
LGA    G    38_A      T      37          1.127
LGA    K    39_A      S      38          2.230
LGA    R    40_A      M      39          1.442
LGA    S    41_A      S      40          0.898
LGA    V    42_A      A      41          0.609
LGA    Y    43_A      E      42          0.642
LGA    E    44_A      E      43          1.006
LGA    V    45_A      L      44          1.067
LGA    A    46_A      V      45          1.043
LGA    V    47_A      K      46          0.985
LGA    H    48_A      H      47          1.430
LGA    L    49_A      I      48          1.630
LGA    A    50_A      L      49          1.901
LGA    V    51_A      T      50          2.328
LGA    L    52_A      S      51          2.425
LGA    L    53_A      F      52          2.310
LGA    E    54_A      H      53          1.881
LGA    A    55_A      L      54          0.594
LGA    D    56_A      F      55          1.066
LGA    L    57_A      A      56          2.606
LGA    R    58_A      N      57          2.603
LGA    I    59_A      V      58          3.561
LGA    A    60_A      I      59          4.274
LGA    T    61_A      K      60          5.594
LGA    -       -      E      61           -
LGA    -       -      G      62           -
LGA    G    62_A      N      63          1.748
LGA    A    63_A      A      64          2.966
LGA    -       -      S      65           -
LGA    T    64_A      P      66          5.524
LGA    A    65_A      F      67          4.175
LGA    D    66_A      Q      68          2.957
LGA    E    67_A      N      69          2.395
LGA    X    68_A      -       -           -
LGA    A    69_A      -       -           -
LGA    Q    70_A      K      70          0.345
LGA    F    71_A      Q      71          2.890
LGA    Y    72_A      -       -           -
LGA    A    73_A      E      72          3.653
LGA    V    74_A      E      73          2.623
LGA    P    75_A      T      74          3.517
LGA    V    76_A      E      75          3.763
LGA    L    77_A      T      76          1.557
LGA    P    78_A      D      77          1.469
LGA    -       -      L      78           -
LGA    E    79_A      N      79          4.602
LGA    Q    80_A      V      80          1.984
LGA    L    81_A      L      81          1.610
LGA    V    82_A      A      82          2.665
LGA    D    83_A      K      83          2.328
LGA    -       -      T      84           -
LGA    R    84_A      Y      85          2.193
LGA    L    85_A      T      86          2.290
LGA    D    86_A      E      87          2.399
LGA    Q    87_A      K      88          1.839
LGA    S    88_A      T      89          1.817
LGA    W    89_A      V      90          2.622
LGA    Q    90_A      A      91          2.427
LGA    Y    91_A      I      92          1.788
LGA    Y    92_A      L      93          2.297
LGA    Q    93_A      E      94          2.759
LGA    D    94_A      Q      95          2.306
LGA    R    95_A      L      96          2.098
LGA    L    96_A      -       -           -
LGA    X    97_A      T      97          4.288
LGA    A    98_A      E      98           #
LGA    D    99_A      E      99          2.892
LGA    F   100_A      Q     100          1.897
LGA    -       -      L     101           -
LGA    -       -      D     102           -
LGA    S   101_A      R     103          4.656
LGA    T   102_A      E     104          4.322
LGA    E   103_A      I     105          1.992
LGA    T   104_A      D     106          1.834
LGA    T   105_A      L     107          1.945
LGA    Y   106_A      T     108          3.557
LGA    W   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    V   109_A      -       -           -
LGA    T   110_A      K     114          1.796
LGA    D   111_A      V     115          1.432
LGA    S   112_A      T     116          1.175
LGA    T   113_A      G     117          1.770
LGA    T   114_A      R     118          1.428
LGA    G   115_A      A     119          0.935
LGA    W   116_A      L     120          1.511
LGA    L   117_A      L     121          1.653
LGA    L   118_A      Q     122          1.320
LGA    E   119_A      L     123          1.355
LGA    A   120_A      A     124          1.245
LGA    A   121_A      M     125          1.183
LGA    V   122_A      E     126          1.094
LGA    H   123_A      H     127          1.203
LGA    L   124_A      E     128          1.065
LGA    Y   125_A      I     129          0.729
LGA    H   126_A      H     130          1.044
LGA    H   127_A      H     131          1.232
LGA    R   128_A      K     132          1.089
LGA    S   129_A      G     133          1.063
LGA    Q   130_A      N     134          1.249
LGA    L   131_A      L     135          1.186
LGA    L   132_A      F     136          1.155
LGA    D   133_A      V     137          1.421
LGA    Y   134_A      Y     138          0.990
LGA    L   135_A      V     139          0.995
LGA    N   136_A      R     140          1.361
LGA    L   137_A      E     141          2.305
LGA    L   138_A      M     142          2.262
LGA    G   139_A      G     143          2.577
LGA    Y   140_A      H     144          1.652
LGA    D   141_A      T     145          2.026
LGA    I   142_A      E     146          3.868
LGA    K   143_A      L     147          2.500
LGA    L   144_A      P     148          0.800
LGA    D   145_A      F     149          1.880
LGA    L   146_A      Y     150          1.753
LGA    F   147_A      Q     151          3.134
LGA    -       -      Q     152           -
LGA    -       -      R     153           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  148  144    5.0    133    2.24    13.53     67.686     5.683

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.648271 * X  +   0.172929 * Y  +  -0.741512 * Z  +  27.344999
  Y_new =   0.750164 * X  +  -0.311819 * Y  +   0.583115 * Z  +  36.703152
  Z_new =  -0.130380 * X  +  -0.934272 * Y  +  -0.331868 * Z  +  25.110601 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.912110    1.229483  [ DEG:  -109.5558     70.4442 ]
  Theta =   0.130752    3.010840  [ DEG:     7.4916    172.5084 ]
  Phi   =   0.858132   -2.283461  [ DEG:    49.1673   -130.8327 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hkv_A                                        
REMARK     2: T0481.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hkv_A.T0481.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  148  144   5.0  133   2.24   13.53  67.686
REMARK  ---------------------------------------------------------- 
MOLECULE 2hkv_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   05-JUL-06   2HKV              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE MEMBER OF THE DINB FAMILY             
TITLE    2 (ZP_00537729.1) FROM EXIGUOBACTERIUM SP. 255-15 AT 1.70 A            
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: EXIGUOBACTERIUM SIBIRICUM 255-15;               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ZP_00537729.1;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ZP_00537729.1, CONSERVED HYPOTHETICAL PROTEIN RBL00553,               
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   15-AUG-06 2HKV    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF CONSERVED HYPOTHETICAL                  
JRNL        TITL 2 PROTEIN RBL00553 (ZP_00537729.1) FROM                        
JRNL        TITL 3 EXIGUOBACTERIUM SP. 255-15 AT 1.70 A RESOLUTION              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2HKV A    1   148  UNP    Q41IB9   Q41IB9_9BACI     1    148             
SEQRES   1 A  149  GLY MSE THR ASP TRP GLN GLN ALA LEU ASP ARG HIS VAL          
SEQRES   2 A  149  GLY VAL GLY VAL ARG THR THR ARG ASP LEU ILE ARG LEU          
SEQRES   3 A  149  ILE GLN PRO GLU ASP TRP ASP LYS ARG PRO ILE SER GLY          
SEQRES   4 A  149  LYS ARG SER VAL TYR GLU VAL ALA VAL HIS LEU ALA VAL          
SEQRES   5 A  149  LEU LEU GLU ALA ASP LEU ARG ILE ALA THR GLY ALA THR          
SEQRES   6 A  149  ALA ASP GLU MSE ALA GLN PHE TYR ALA VAL PRO VAL LEU          
SEQRES   7 A  149  PRO GLU GLN LEU VAL ASP ARG LEU ASP GLN SER TRP GLN          
SEQRES   8 A  149  TYR TYR GLN ASP ARG LEU MSE ALA ASP PHE SER THR GLU          
SEQRES   9 A  149  THR THR TYR TRP GLY VAL THR ASP SER THR THR GLY TRP          
SEQRES  10 A  149  LEU LEU GLU ALA ALA VAL HIS LEU TYR HIS HIS ARG SER          
SEQRES  11 A  149  GLN LEU LEU ASP TYR LEU ASN LEU LEU GLY TYR ASP ILE          
SEQRES  12 A  149  LYS LEU ASP LEU PHE GLU                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  68       8                                                       
HET    MSE  A  97       8                                                       
HET     NI      1       1                                                       
HET     CL      2       1                                                       
HET     CL      3       1                                                       
HET     CL      4       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2   NI    NI 2+                                                        
FORMUL   3   CL    3(CL 1-)                                                     
FORMUL   6  HOH   *65(H2 O)                                                     
CRYST1   45.020   45.020  131.180  90.00  90.00 120.00 P 32 2 1      6          
ATOM      1  N   GLY A   0      48.603  48.575   7.466  1.00 40.17           N  
ATOM      2  CA  GLY A   0      47.160  48.606   7.089  1.00 38.96           C  
ATOM      3  C   GLY A   0      46.495  47.333   7.559  1.00 40.22           C  
ATOM      4  O   GLY A   0      47.132  46.507   8.173  1.00 46.78           O  
HETATM    5  N   MSE A   1      45.211  47.173   7.316  1.00 39.61           N  
HETATM    6  CA  MSE A   1      44.561  45.950   7.707  1.00 40.29           C  
HETATM    7  C   MSE A   1      43.350  45.757   6.834  1.00 36.26           C  
HETATM    8  O   MSE A   1      42.825  46.692   6.255  1.00 35.25           O  
HETATM    9  CB  MSE A   1      44.112  46.026   9.175  1.00 48.06           C  
HETATM   10  CG  MSE A   1      43.380  47.271   9.436  1.00 39.96           C  
HETATM   11 SE   MSE A   1      42.811  47.533  11.322  0.70 63.74          SE  
HETATM   12  CE  MSE A   1      41.521  49.077  10.984  1.00 64.64           C  
ATOM     13  N   THR A   2      42.887  44.532   6.730  1.00 32.54           N  
ATOM     14  CA  THR A   2      41.707  44.245   5.932  1.00 31.34           C  
ATOM     15  C   THR A   2      40.429  44.684   6.609  1.00 34.81           C  
ATOM     16  O   THR A   2      40.403  45.012   7.815  1.00 34.11           O  
ATOM     17  CB  THR A   2      41.606  42.712   5.724  1.00 37.26           C  
ATOM     18  OG1 THR A   2      41.413  42.107   6.988  1.00 34.85           O  
ATOM     19  CG2 THR A   2      42.895  42.129   5.056  1.00 35.40           C  
ATOM     20  N   ASP A   3      39.342  44.650   5.852  1.00 33.33           N  
ATOM     21  CA  ASP A   3      38.057  45.025   6.413  1.00 34.86           C  
ATOM     22  C   ASP A   3      37.634  44.111   7.587  1.00 33.28           C  
ATOM     23  O   ASP A   3      37.096  44.603   8.596  1.00 35.54           O  
ATOM     24  CB  ASP A   3      37.003  45.092   5.306  1.00 38.42           C  
ATOM     25  CG  ASP A   3      36.942  46.486   4.649  1.00 53.19           C  
ATOM     26  OD1 ASP A   3      38.009  47.129   4.548  1.00 63.52           O  
ATOM     27  OD2 ASP A   3      35.826  46.950   4.285  1.00 52.19           O  
ATOM     28  N   TRP A   4      37.936  42.816   7.512  1.00 32.68           N  
ATOM     29  CA  TRP A   4      37.636  41.929   8.651  0.50 30.19           C  
ATOM     31  C   TRP A   4      38.544  42.217   9.842  1.00 28.81           C  
ATOM     32  O   TRP A   4      38.096  42.169  10.980  1.00 32.18           O  
ATOM     33  CB  TRP A   4      37.683  40.437   8.262  0.50 34.02           C  
ATOM     35  CG  TRP A   4      39.048  39.868   7.940  0.50 32.40           C  
ATOM     37  CD1 TRP A   4      39.639  39.775   6.718  0.50 31.06           C  
ATOM     39  CD2 TRP A   4      39.953  39.274   8.860  0.50 33.13           C  
ATOM     41  NE1 TRP A   4      40.899  39.204   6.815  0.50 24.58           N  
ATOM     43  CE2 TRP A   4      41.090  38.856   8.131  0.50 33.95           C  
ATOM     45  CE3 TRP A   4      39.916  39.048  10.245  0.50 32.43           C  
ATOM     47  CZ2 TRP A   4      42.190  38.216   8.749  0.50 37.69           C  
ATOM     49  CZ3 TRP A   4      40.993  38.438  10.850  0.50 32.05           C  
ATOM     51  CH2 TRP A   4      42.117  38.015  10.099  0.50 33.79           C  
ATOM     53  N   GLN A   5      39.840  42.520   9.617  1.00 30.70           N  
ATOM     54  CA  GLN A   5      40.718  42.874  10.733  1.00 29.58           C  
ATOM     55  C   GLN A   5      40.259  44.152  11.411  1.00 34.64           C  
ATOM     56  O   GLN A   5      40.299  44.265  12.654  1.00 33.12           O  
ATOM     57  CB  GLN A   5      42.153  43.055  10.284  1.00 31.27           C  
ATOM     58  CG  GLN A   5      42.835  41.718   9.879  1.00 32.00           C  
ATOM     59  CD  GLN A   5      44.078  41.841   9.015  1.00 30.23           C  
ATOM     60  OE1 GLN A   5      44.270  42.768   8.251  1.00 37.94           O  
ATOM     61  NE2 GLN A   5      44.904  40.820   9.115  1.00 36.35           N  
ATOM     62  N   GLN A   6      39.835  45.127  10.593  1.00 31.34           N  
ATOM     63  CA  GLN A   6      39.270  46.380  11.110  1.00 32.31           C  
ATOM     64  C   GLN A   6      38.044  46.123  11.976  1.00 32.75           C  
ATOM     65  O   GLN A   6      37.892  46.709  13.055  1.00 32.08           O  
ATOM     66  CB  GLN A   6      38.879  47.273   9.942  1.00 33.79           C  
ATOM     67  CG  GLN A   6      38.196  48.524  10.349  1.00 36.51           C  
ATOM     68  CD  GLN A   6      37.819  49.452   9.142  1.00 43.76           C  
ATOM     69  OE1 GLN A   6      37.261  49.027   8.096  1.00 50.45           O  
ATOM     70  NE2 GLN A   6      38.154  50.731   9.293  1.00 59.20           N  
ATOM     71  N   ALA A   7      37.181  45.231  11.512  1.00 31.92           N  
ATOM     72  CA  ALA A   7      35.923  44.881  12.201  1.00 29.64           C  
ATOM     73  C   ALA A   7      36.217  44.219  13.539  1.00 32.12           C  
ATOM     74  O   ALA A   7      35.643  44.555  14.580  1.00 31.34           O  
ATOM     75  CB  ALA A   7      35.169  43.963  11.378  1.00 32.93           C  
ATOM     76  N   LEU A   8      37.150  43.268  13.514  1.00 32.98           N  
ATOM     77  CA  LEU A   8      37.535  42.618  14.752  1.00 32.90           C  
ATOM     78  C   LEU A   8      38.172  43.595  15.740  1.00 32.49           C  
ATOM     79  O   LEU A   8      37.844  43.532  16.910  1.00 33.64           O  
ATOM     80  CB  LEU A   8      38.406  41.387  14.529  1.00 33.01           C  
ATOM     81  CG  LEU A   8      37.729  40.101  14.059  1.00 39.60           C  
ATOM     82  CD1 LEU A   8      38.771  39.044  13.589  1.00 35.21           C  
ATOM     83  CD2 LEU A   8      36.757  39.579  15.130  1.00 35.15           C  
ATOM     84  N   ASP A   9      39.106  44.432  15.283  1.00 33.22           N  
ATOM     85  CA  ASP A   9      39.749  45.410  16.159  1.00 33.65           C  
ATOM     86  C   ASP A   9      38.664  46.312  16.806  1.00 35.13           C  
ATOM     87  O   ASP A   9      38.689  46.601  18.011  1.00 36.73           O  
ATOM     88  CB  ASP A   9      40.776  46.208  15.384  1.00 33.01           C  
ATOM     89  CG  ASP A   9      41.574  47.142  16.255  1.00 46.35           C  
ATOM     90  OD1 ASP A   9      42.250  46.648  17.162  1.00 55.15           O  
ATOM     91  OD2 ASP A   9      41.512  48.376  16.045  1.00 63.53           O  
ATOM     92  N   ARG A  10      37.693  46.715  16.014  1.00 33.40           N  
ATOM     93  CA  ARG A  10      36.591  47.586  16.520  1.00 33.60           C  
ATOM     94  C   ARG A  10      35.746  46.888  17.599  1.00 35.63           C  
ATOM     95  O   ARG A  10      35.595  47.385  18.717  1.00 34.35           O  
ATOM     96  CB  ARG A  10      35.727  48.044  15.353  1.00 33.78           C  
ATOM     97  CG  ARG A  10      34.492  48.847  15.738  1.00 36.41           C  
ATOM     98  CD  ARG A  10      33.832  49.485  14.557  1.00 39.18           C  
ATOM     99  NE  ARG A  10      32.575  50.153  14.936  1.00 37.43           N  
ATOM    100  CZ  ARG A  10      31.951  51.055  14.173  1.00 44.07           C  
ATOM    101  NH1 ARG A  10      32.433  51.394  13.015  1.00 41.79           N  
ATOM    102  NH2 ARG A  10      30.825  51.628  14.614  1.00 40.35           N  
ATOM    103  N   HIS A  11      35.185  45.743  17.234  1.00 32.90           N  
ATOM    104  CA  HIS A  11      34.208  45.049  18.054  1.00 32.20           C  
ATOM    105  C   HIS A  11      34.839  44.310  19.201  1.00 34.13           C  
ATOM    106  O   HIS A  11      34.293  44.304  20.325  1.00 34.57           O  
ATOM    107  CB  HIS A  11      33.280  44.178  17.163  1.00 33.62           C  
ATOM    108  CG  HIS A  11      32.389  44.997  16.282  1.00 36.66           C  
ATOM    109  ND1 HIS A  11      31.210  45.574  16.750  1.00 36.36           N  
ATOM    110  CD2 HIS A  11      32.522  45.407  15.000  1.00 37.73           C  
ATOM    111  CE1 HIS A  11      30.686  46.315  15.788  1.00 36.24           C  
ATOM    112  NE2 HIS A  11      31.462  46.253  14.725  1.00 37.97           N  
ATOM    113  N   VAL A  12      36.010  43.712  19.004  1.00 33.31           N  
ATOM    114  CA  VAL A  12      36.697  43.126  20.150  1.00 34.55           C  
ATOM    115  C   VAL A  12      37.210  44.234  21.095  1.00 35.42           C  
ATOM    116  O   VAL A  12      37.154  44.110  22.315  1.00 34.85           O  
ATOM    117  CB  VAL A  12      37.845  42.131  19.784  1.00 37.49           C  
ATOM    118  CG1 VAL A  12      38.440  41.583  21.073  1.00 36.70           C  
ATOM    119  CG2 VAL A  12      37.354  40.973  18.932  1.00 35.41           C  
ATOM    120  N   GLY A  13      37.660  45.354  20.549  1.00 32.95           N  
ATOM    121  CA  GLY A  13      38.049  46.499  21.407  1.00 33.20           C  
ATOM    122  C   GLY A  13      36.887  47.014  22.270  1.00 34.20           C  
ATOM    123  O   GLY A  13      37.073  47.389  23.445  1.00 35.67           O  
ATOM    124  N   VAL A  14      35.679  47.068  21.708  1.00 36.48           N  
ATOM    125  CA  VAL A  14      34.512  47.455  22.502  1.00 37.31           C  
ATOM    126  C   VAL A  14      34.316  46.465  23.613  1.00 38.53           C  
ATOM    127  O   VAL A  14      34.065  46.841  24.759  1.00 38.53           O  
ATOM    128  CB  VAL A  14      33.152  47.476  21.695  1.00 40.48           C  
ATOM    129  CG1 VAL A  14      31.957  47.616  22.632  1.00 40.73           C  
ATOM    130  CG2 VAL A  14      33.112  48.579  20.581  1.00 41.90           C  
ATOM    131  N   GLY A  15      34.324  45.185  23.241  1.00 37.94           N  
ATOM    132  CA  GLY A  15      34.244  44.093  24.206  1.00 36.64           C  
ATOM    133  C   GLY A  15      35.222  44.243  25.342  1.00 35.13           C  
ATOM    134  O   GLY A  15      34.870  44.081  26.509  1.00 36.67           O  
ATOM    135  N   VAL A  16      36.455  44.567  25.024  1.00 34.06           N  
ATOM    136  CA  VAL A  16      37.486  44.675  26.030  1.00 35.61           C  
ATOM    137  C   VAL A  16      37.299  45.926  26.880  1.00 34.60           C  
ATOM    138  O   VAL A  16      37.379  45.858  28.094  1.00 35.18           O  
ATOM    139  CB  VAL A  16      38.882  44.684  25.381  1.00 35.79           C  
ATOM    140  CG1 VAL A  16      39.979  45.101  26.407  1.00 42.02           C  
ATOM    141  CG2 VAL A  16      39.179  43.306  24.765  1.00 37.37           C  
ATOM    142  N   ARG A  17      37.022  47.069  26.257  1.00 33.92           N  
ATOM    143  CA  ARG A  17      36.864  48.268  27.076  1.00 36.58           C  
ATOM    144  C   ARG A  17      35.657  48.230  28.015  1.00 36.87           C  
ATOM    145  O   ARG A  17      35.745  48.673  29.179  1.00 37.42           O  
ATOM    146  CB  ARG A  17      36.815  49.505  26.234  1.00 38.89           C  
ATOM    147  CG  ARG A  17      38.150  49.726  25.547  1.00 48.09           C  
ATOM    148  CD  ARG A  17      38.219  51.033  24.837  1.00 58.01           C  
ATOM    149  NE  ARG A  17      37.127  51.147  23.891  1.00 58.74           N  
ATOM    150  CZ  ARG A  17      37.185  50.845  22.594  1.00 62.82           C  
ATOM    151  NH1 ARG A  17      38.315  50.385  22.012  1.00 52.67           N  
ATOM    152  NH2 ARG A  17      36.068  51.007  21.874  1.00 59.04           N  
ATOM    153  N   THR A  18      34.536  47.705  27.525  1.00 37.24           N  
ATOM    154  CA  THR A  18      33.366  47.514  28.384  1.00 36.23           C  
ATOM    155  C   THR A  18      33.610  46.495  29.466  1.00 37.44           C  
ATOM    156  O   THR A  18      33.201  46.711  30.592  1.00 36.37           O  
ATOM    157  CB  THR A  18      32.106  47.187  27.595  1.00 35.05           C  
ATOM    158  OG1 THR A  18      32.313  46.020  26.779  1.00 37.84           O  
ATOM    159  CG2 THR A  18      31.671  48.431  26.700  1.00 38.23           C  
ATOM    160  N   THR A  19      34.322  45.407  29.192  1.00 36.64           N  
ATOM    161  CA  THR A  19      34.673  44.461  30.236  1.00 37.31           C  
ATOM    162  C   THR A  19      35.532  45.087  31.318  1.00 39.30           C  
ATOM    163  O   THR A  19      35.290  44.839  32.524  1.00 35.39           O  
ATOM    164  CB  THR A  19      35.346  43.198  29.674  1.00 36.97           C  
ATOM    165  OG1 THR A  19      34.437  42.573  28.767  1.00 36.38           O  
ATOM    166  CG2 THR A  19      35.724  42.183  30.783  1.00 34.98           C  
ATOM    167  N   ARG A  20      36.495  45.908  30.899  1.00 38.51           N  
ATOM    168  CA  ARG A  20      37.377  46.610  31.824  1.00 38.91           C  
ATOM    169  C   ARG A  20      36.513  47.469  32.760  1.00 38.44           C  
ATOM    170  O   ARG A  20      36.710  47.476  33.970  1.00 38.68           O  
ATOM    171  CB  ARG A  20      38.416  47.450  31.059  1.00 39.55           C  
ATOM    172  CG  ARG A  20      39.586  47.853  31.860  1.00 48.36           C  
ATOM    173  CD  ARG A  20      40.431  48.907  31.119  1.00 50.49           C  
ATOM    174  NE  ARG A  20      40.972  48.354  29.875  1.00 58.73           N  
ATOM    175  CZ  ARG A  20      40.947  48.949  28.684  1.00 68.19           C  
ATOM    176  NH1 ARG A  20      40.414  50.159  28.515  1.00 73.94           N  
ATOM    177  NH2 ARG A  20      41.485  48.329  27.639  1.00 67.12           N  
ATOM    178  N   ASP A  21      35.522  48.169  32.199  1.00 34.87           N  
ATOM    179  CA  ASP A  21      34.664  49.028  33.008  1.00 40.04           C  
ATOM    180  C   ASP A  21      33.864  48.203  33.997  1.00 41.40           C  
ATOM    181  O   ASP A  21      33.735  48.585  35.175  1.00 40.69           O  
ATOM    182  CB  ASP A  21      33.712  49.831  32.137  1.00 42.37           C  
ATOM    183  CG  ASP A  21      34.432  50.874  31.285  1.00 55.83           C  
ATOM    184  OD1 ASP A  21      35.525  51.360  31.716  1.00 59.00           O  
ATOM    185  OD2 ASP A  21      33.891  51.213  30.192  1.00 62.91           O  
ATOM    186  N   LEU A  22      33.358  47.050  33.540  1.00 39.71           N  
ATOM    187  CA  LEU A  22      32.554  46.201  34.433  1.00 38.50           C  
ATOM    188  C   LEU A  22      33.385  45.701  35.607  1.00 37.91           C  
ATOM    189  O   LEU A  22      32.918  45.746  36.733  1.00 37.86           O  
ATOM    190  CB  LEU A  22      31.924  44.996  33.696  1.00 39.64           C  
ATOM    191  CG  LEU A  22      30.742  45.255  32.743  1.00 43.07           C  
ATOM    192  CD1 LEU A  22      30.371  43.943  32.004  1.00 45.96           C  
ATOM    193  CD2 LEU A  22      29.513  45.778  33.501  1.00 44.73           C  
ATOM    194  N   ILE A  23      34.605  45.253  35.328  1.00 34.90           N  
ATOM    195  CA  ILE A  23      35.495  44.733  36.351  1.00 38.80           C  
ATOM    196  C   ILE A  23      35.730  45.828  37.373  1.00 39.30           C  
ATOM    197  O   ILE A  23      35.625  45.567  38.564  1.00 38.78           O  
ATOM    198  CB  ILE A  23      36.829  44.156  35.736  1.00 39.66           C  
ATOM    199  CG1 ILE A  23      36.526  42.861  34.968  1.00 46.12           C  
ATOM    200  CG2 ILE A  23      37.911  43.926  36.821  1.00 35.47           C  
ATOM    201  CD1 ILE A  23      37.687  42.335  34.117  1.00 42.23           C  
ATOM    202  N   ARG A  24      35.945  47.074  36.917  1.00 41.71           N  
ATOM    203  CA  ARG A  24      36.141  48.194  37.863  1.00 40.91           C  
ATOM    204  C   ARG A  24      34.909  48.541  38.728  1.00 42.16           C  
ATOM    205  O   ARG A  24      35.031  49.259  39.726  1.00 41.28           O  
ATOM    206  CB  ARG A  24      36.634  49.424  37.121  1.00 44.46           C  
ATOM    207  CG  ARG A  24      38.028  49.275  36.538  1.00 42.29           C  
ATOM    208  CD  ARG A  24      38.225  50.346  35.475  1.00 47.95           C  
ATOM    209  NE  ARG A  24      39.611  50.468  35.051  1.00 53.32           N  
ATOM    210  CZ  ARG A  24      40.008  50.962  33.874  1.00 60.01           C  
ATOM    211  NH1 ARG A  24      39.121  51.376  32.963  1.00 64.14           N  
ATOM    212  NH2 ARG A  24      41.306  51.031  33.595  1.00 59.53           N  
ATOM    213  N   LEU A  25      33.738  48.021  38.388  1.00 39.51           N  
ATOM    214  CA  LEU A  25      32.543  48.247  39.197  1.00 41.09           C  
ATOM    215  C   LEU A  25      32.485  47.303  40.373  1.00 39.10           C  
ATOM    216  O   LEU A  25      31.881  47.603  41.388  1.00 40.95           O  
ATOM    217  CB  LEU A  25      31.265  48.124  38.346  1.00 41.66           C  
ATOM    218  CG  LEU A  25      31.125  49.111  37.179  1.00 48.24           C  
ATOM    219  CD1 LEU A  25      29.730  48.992  36.566  1.00 50.64           C  
ATOM    220  CD2 LEU A  25      31.376  50.524  37.645  1.00 52.35           C  
ATOM    221  N   ILE A  26      33.143  46.153  40.253  1.00 38.54           N  
ATOM    222  CA  ILE A  26      32.930  45.091  41.185  1.00 37.64           C  
ATOM    223  C   ILE A  26      33.431  45.504  42.587  1.00 37.65           C  
ATOM    224  O   ILE A  26      34.543  46.013  42.729  1.00 37.14           O  
ATOM    225  CB  ILE A  26      33.597  43.789  40.728  1.00 35.80           C  
ATOM    226  CG1 ILE A  26      33.042  43.335  39.355  1.00 34.62           C  
ATOM    227  CG2 ILE A  26      33.430  42.712  41.872  1.00 33.38           C  
ATOM    228  CD1 ILE A  26      33.727  42.084  38.765  1.00 36.15           C  
ATOM    229  N   GLN A  27      32.592  45.316  43.599  1.00 39.58           N  
ATOM    230  CA  GLN A  27      32.917  45.681  44.968  1.00 43.84           C  
ATOM    231  C   GLN A  27      33.624  44.520  45.640  1.00 42.08           C  
ATOM    232  O   GLN A  27      33.311  43.380  45.353  1.00 40.39           O  
ATOM    233  CB  GLN A  27      31.632  46.030  45.727  1.00 44.79           C  
ATOM    234  CG  GLN A  27      30.721  47.075  45.042  1.00 45.24           C  
ATOM    235  CD  GLN A  27      29.256  46.913  45.446  1.00 52.02           C  
ATOM    236  N   PRO A  28      34.508  44.804  46.619  1.00 46.50           N  
ATOM    237  CA  PRO A  28      35.259  43.758  47.335  1.00 47.09           C  
ATOM    238  C   PRO A  28      34.412  42.616  47.823  1.00 45.85           C  
ATOM    239  O   PRO A  28      34.808  41.470  47.704  1.00 49.42           O  
ATOM    240  CB  PRO A  28      35.782  44.485  48.588  1.00 48.67           C  
ATOM    241  CG  PRO A  28      35.024  45.824  48.624  1.00 50.34           C  
ATOM    242  CD  PRO A  28      34.800  46.136  47.192  1.00 48.11           C  
ATOM    243  N   GLU A  29      33.261  42.929  48.399  1.00 44.45           N  
ATOM    244  CA  GLU A  29      32.427  41.910  49.017  1.00 45.08           C  
ATOM    245  C   GLU A  29      31.931  40.860  48.027  1.00 44.21           C  
ATOM    246  O   GLU A  29      31.596  39.772  48.428  1.00 43.89           O  
ATOM    247  CB  GLU A  29      31.224  42.545  49.766  1.00 47.66           C  
ATOM    248  CG  GLU A  29      30.306  43.509  48.924  1.00 51.35           C  
ATOM    249  CD  GLU A  29      30.504  45.028  49.193  1.00 49.69           C  
ATOM    250  OE1 GLU A  29      31.063  45.405  50.241  1.00 64.28           O  
ATOM    251  OE2 GLU A  29      30.068  45.848  48.349  1.00 72.30           O  
ATOM    252  N   ASP A  30      31.922  41.181  46.733  1.00 44.06           N  
ATOM    253  CA  ASP A  30      31.167  40.394  45.749  1.00 44.22           C  
ATOM    254  C   ASP A  30      31.957  39.328  44.976  1.00 43.70           C  
ATOM    255  O   ASP A  30      31.363  38.523  44.229  1.00 37.85           O  
ATOM    256  CB  ASP A  30      30.494  41.360  44.754  1.00 43.09           C  
ATOM    257  CG  ASP A  30      29.362  42.165  45.404  1.00 43.52           C  
ATOM    258  OD1 ASP A  30      28.749  41.671  46.392  1.00 45.13           O  
ATOM    259  OD2 ASP A  30      29.069  43.275  44.923  1.00 48.53           O  
ATOM    260  N   TRP A  31      33.277  39.331  45.128  1.00 42.89           N  
ATOM    261  CA  TRP A  31      34.131  38.483  44.303  1.00 43.37           C  
ATOM    262  C   TRP A  31      33.830  36.997  44.452  1.00 40.89           C  
ATOM    263  O   TRP A  31      33.880  36.255  43.485  1.00 38.94           O  
ATOM    264  CB  TRP A  31      35.601  38.737  44.604  1.00 42.63           C  
ATOM    265  CG  TRP A  31      36.108  40.062  44.132  1.00 42.49           C  
ATOM    266  CD1 TRP A  31      36.459  41.138  44.914  1.00 39.48           C  
ATOM    267  CD2 TRP A  31      36.371  40.444  42.795  1.00 31.47           C  
ATOM    268  NE1 TRP A  31      36.912  42.160  44.137  1.00 43.04           N  
ATOM    269  CE2 TRP A  31      36.846  41.780  42.825  1.00 37.01           C  
ATOM    270  CE3 TRP A  31      36.242  39.810  41.567  1.00 38.29           C  
ATOM    271  CZ2 TRP A  31      37.223  42.464  41.676  1.00 40.44           C  
ATOM    272  CZ3 TRP A  31      36.593  40.508  40.419  1.00 44.43           C  
ATOM    273  CH2 TRP A  31      37.084  41.819  40.485  1.00 42.41           C  
ATOM    274  N   ASP A  32      33.534  36.533  45.650  1.00 39.92           N  
ATOM    275  CA  ASP A  32      33.234  35.108  45.815  1.00 42.05           C  
ATOM    276  C   ASP A  32      31.764  34.740  45.690  1.00 42.29           C  
ATOM    277  O   ASP A  32      31.408  33.564  45.826  1.00 44.02           O  
ATOM    278  CB  ASP A  32      33.758  34.605  47.178  1.00 43.69           C  
ATOM    279  CG  ASP A  32      35.268  34.542  47.208  1.00 51.79           C  
ATOM    280  OD1 ASP A  32      35.850  34.060  46.194  1.00 60.05           O  
ATOM    281  OD2 ASP A  32      35.867  35.003  48.212  1.00 57.80           O  
ATOM    282  N   LYS A  33      30.912  35.730  45.470  1.00 40.64           N  
ATOM    283  CA  LYS A  33      29.497  35.475  45.261  1.00 39.26           C  
ATOM    284  C   LYS A  33      29.279  34.625  43.992  1.00 38.82           C  
ATOM    285  O   LYS A  33      29.980  34.788  42.964  1.00 37.41           O  
ATOM    286  CB  LYS A  33      28.707  36.802  45.177  1.00 41.52           C  
ATOM    287  CG  LYS A  33      28.539  37.543  46.512  1.00 41.43           C  
ATOM    288  CD  LYS A  33      27.038  37.891  46.769  1.00 45.10           C  
ATOM    289  CE  LYS A  33      26.758  38.774  48.021  1.00 43.13           C  
ATOM    290  NZ  LYS A  33      27.851  39.752  48.476  1.00 26.44           N  
ATOM    291  N   ARG A  34      28.307  33.718  44.080  1.00 38.07           N  
ATOM    292  CA  ARG A  34      27.873  32.889  42.941  1.00 39.93           C  
ATOM    293  C   ARG A  34      26.382  33.098  42.746  1.00 41.31           C  
ATOM    294  O   ARG A  34      25.585  32.362  43.319  1.00 38.83           O  
ATOM    295  CB  ARG A  34      28.130  31.388  43.208  1.00 39.89           C  
ATOM    296  CG  ARG A  34      29.566  31.095  43.584  1.00 43.75           C  
ATOM    297  CD  ARG A  34      29.819  29.591  43.890  1.00 46.05           C  
ATOM    298  NE  ARG A  34      31.149  29.210  43.409  1.00 55.59           N  
ATOM    299  CZ  ARG A  34      32.297  29.565  43.994  1.00 58.64           C  
ATOM    300  NH1 ARG A  34      32.309  30.315  45.105  1.00 60.76           N  
ATOM    301  NH2 ARG A  34      33.453  29.179  43.454  1.00 55.14           N  
ATOM    302  N   PRO A  35      25.999  34.119  41.969  1.00 41.57           N  
ATOM    303  CA  PRO A  35      24.596  34.452  41.762  1.00 41.05           C  
ATOM    304  C   PRO A  35      23.800  33.339  41.062  1.00 39.01           C  
ATOM    305  O   PRO A  35      22.601  33.307  41.197  1.00 43.09           O  
ATOM    306  CB  PRO A  35      24.654  35.707  40.858  1.00 43.94           C  
ATOM    307  CG  PRO A  35      26.050  36.220  40.949  1.00 40.09           C  
ATOM    308  CD  PRO A  35      26.901  35.019  41.229  1.00 40.52           C  
ATOM    309  N   ILE A  36      24.451  32.490  40.274  1.00 40.03           N  
ATOM    310  CA  ILE A  36      23.792  31.333  39.662  1.00 44.93           C  
ATOM    311  C   ILE A  36      24.372  30.050  40.267  1.00 47.90           C  
ATOM    312  O   ILE A  36      25.475  29.635  39.916  1.00 44.83           O  
ATOM    313  CB  ILE A  36      23.999  31.304  38.127  1.00 43.47           C  
ATOM    314  CG1 ILE A  36      23.679  32.674  37.522  1.00 41.38           C  
ATOM    315  CG2 ILE A  36      23.166  30.206  37.486  1.00 45.55           C  
ATOM    316  CD1 ILE A  36      23.496  32.649  36.021  1.00 42.92           C  
ATOM    317  N   SER A  37      23.627  29.441  41.186  1.00 54.63           N  
ATOM    318  CA  SER A  37      24.110  28.259  41.921  1.00 58.16           C  
ATOM    319  C   SER A  37      24.500  27.202  40.914  1.00 58.11           C  
ATOM    320  O   SER A  37      23.772  26.976  39.956  1.00 58.02           O  
ATOM    321  CB  SER A  37      23.047  27.727  42.901  1.00 60.49           C  
ATOM    322  OG  SER A  37      22.080  26.924  42.236  1.00 68.13           O  
ATOM    323  N   GLY A  38      25.677  26.614  41.104  1.00 59.27           N  
ATOM    324  CA  GLY A  38      26.241  25.656  40.160  1.00 59.41           C  
ATOM    325  C   GLY A  38      27.310  26.193  39.231  1.00 59.68           C  
ATOM    326  O   GLY A  38      28.068  25.418  38.634  1.00 60.00           O  
ATOM    327  N   LYS A  39      27.386  27.512  39.093  1.00 56.76           N  
ATOM    328  CA  LYS A  39      28.275  28.112  38.115  1.00 55.55           C  
ATOM    329  C   LYS A  39      29.419  28.908  38.741  1.00 49.28           C  
ATOM    330  O   LYS A  39      29.478  29.058  39.956  1.00 48.38           O  
ATOM    331  CB  LYS A  39      27.446  28.970  37.150  1.00 56.34           C  
ATOM    332  CG  LYS A  39      26.303  28.190  36.474  1.00 62.81           C  
ATOM    333  CD  LYS A  39      26.809  26.871  35.842  1.00 64.11           C  
ATOM    334  CE  LYS A  39      25.959  26.392  34.666  1.00 64.39           C  
ATOM    335  NZ  LYS A  39      26.232  24.965  34.304  1.00 62.07           N  
ATOM    336  N   ARG A  40      30.324  29.397  37.889  1.00 46.94           N  
ATOM    337  CA  ARG A  40      31.498  30.158  38.307  1.00 43.43           C  
ATOM    338  C   ARG A  40      31.081  31.319  39.238  1.00 42.78           C  
ATOM    339  O   ARG A  40      30.004  31.887  39.098  1.00 42.61           O  
ATOM    340  CB  ARG A  40      32.218  30.714  37.098  1.00 45.32           C  
ATOM    341  CG  ARG A  40      33.271  29.840  36.423  1.00 45.99           C  
ATOM    342  CD  ARG A  40      33.602  30.395  35.098  1.00 48.27           C  
ATOM    343  NE  ARG A  40      34.850  29.874  34.559  1.00 45.05           N  
ATOM    344  CZ  ARG A  40      34.903  29.016  33.545  1.00 53.50           C  
ATOM    345  NH1 ARG A  40      33.788  28.627  32.940  1.00 54.26           N  
ATOM    346  NH2 ARG A  40      36.071  28.538  33.126  1.00 55.98           N  
ATOM    347  N   SER A  41      31.933  31.649  40.194  1.00 39.70           N  
ATOM    348  CA  SER A  41      31.766  32.867  40.963  1.00 37.81           C  
ATOM    349  C   SER A  41      32.064  34.128  40.102  1.00 35.53           C  
ATOM    350  O   SER A  41      32.550  34.005  38.989  1.00 32.60           O  
ATOM    351  CB  SER A  41      32.687  32.853  42.175  1.00 34.70           C  
ATOM    352  OG  SER A  41      34.026  33.052  41.763  1.00 36.74           O  
ATOM    353  N   VAL A  42      31.728  35.329  40.610  1.00 34.03           N  
ATOM    354  CA  VAL A  42      32.070  36.583  39.972  1.00 35.39           C  
ATOM    355  C   VAL A  42      33.557  36.635  39.660  1.00 34.16           C  
ATOM    356  O   VAL A  42      33.971  36.972  38.533  1.00 32.26           O  
ATOM    357  CB  VAL A  42      31.733  37.792  40.913  1.00 37.44           C  
ATOM    358  CG1 VAL A  42      32.306  39.045  40.380  1.00 30.06           C  
ATOM    359  CG2 VAL A  42      30.255  37.926  41.088  1.00 37.62           C  
ATOM    360  N   TYR A  43      34.380  36.294  40.659  1.00 36.00           N  
ATOM    361  CA  TYR A  43      35.807  36.398  40.441  1.00 36.48           C  
ATOM    362  C   TYR A  43      36.237  35.389  39.363  1.00 32.78           C  
ATOM    363  O   TYR A  43      37.062  35.705  38.529  1.00 30.66           O  
ATOM    364  CB  TYR A  43      36.591  36.177  41.731  1.00 36.18           C  
ATOM    365  CG  TYR A  43      38.065  35.892  41.538  1.00 38.71           C  
ATOM    366  CD1 TYR A  43      38.959  36.894  41.234  1.00 37.65           C  
ATOM    367  CD2 TYR A  43      38.559  34.594  41.682  1.00 49.86           C  
ATOM    368  CE1 TYR A  43      40.300  36.626  41.065  1.00 46.95           C  
ATOM    369  CE2 TYR A  43      39.900  34.308  41.523  1.00 46.64           C  
ATOM    370  CZ  TYR A  43      40.772  35.320  41.225  1.00 49.03           C  
ATOM    371  OH  TYR A  43      42.114  35.020  41.079  1.00 45.93           O  
ATOM    372  N   GLU A  44      35.704  34.180  39.404  1.00 32.87           N  
ATOM    373  CA  GLU A  44      36.110  33.163  38.433  1.00 33.51           C  
ATOM    374  C   GLU A  44      35.688  33.504  36.979  1.00 32.75           C  
ATOM    375  O   GLU A  44      36.438  33.252  36.058  1.00 33.75           O  
ATOM    376  CB  GLU A  44      35.589  31.782  38.838  1.00 27.67           C  
ATOM    377  CG  GLU A  44      36.243  31.191  40.083  1.00 35.11           C  
ATOM    378  CD  GLU A  44      35.470  29.980  40.659  1.00 41.71           C  
ATOM    379  OE1 GLU A  44      34.360  29.648  40.188  1.00 46.74           O  
ATOM    380  OE2 GLU A  44      35.967  29.358  41.641  1.00 50.06           O  
ATOM    381  N   VAL A  45      34.503  34.100  36.799  1.00 33.64           N  
ATOM    382  CA  VAL A  45      34.105  34.645  35.490  1.00 33.09           C  
ATOM    383  C   VAL A  45      35.081  35.705  35.026  1.00 33.54           C  
ATOM    384  O   VAL A  45      35.519  35.701  33.881  1.00 34.56           O  
ATOM    385  CB  VAL A  45      32.699  35.213  35.500  1.00 34.21           C  
ATOM    386  CG1 VAL A  45      32.269  35.644  34.065  1.00 38.79           C  
ATOM    387  CG2 VAL A  45      31.724  34.145  35.915  1.00 35.18           C  
ATOM    388  N   ALA A  46      35.386  36.650  35.924  1.00 32.90           N  
ATOM    389  CA  ALA A  46      36.324  37.715  35.640  1.00 34.56           C  
ATOM    390  C   ALA A  46      37.698  37.249  35.220  1.00 34.28           C  
ATOM    391  O   ALA A  46      38.240  37.792  34.278  1.00 35.51           O  
ATOM    392  CB  ALA A  46      36.423  38.724  36.815  1.00 34.70           C  
ATOM    393  N   VAL A  47      38.275  36.261  35.903  1.00 32.47           N  
ATOM    394  CA  VAL A  47      39.580  35.748  35.511  1.00 37.23           C  
ATOM    395  C   VAL A  47      39.537  35.087  34.100  1.00 37.24           C  
ATOM    396  O   VAL A  47      40.468  35.250  33.303  1.00 36.74           O  
ATOM    397  CB  VAL A  47      40.130  34.725  36.552  1.00 40.95           C  
ATOM    398  CG1 VAL A  47      41.450  34.100  36.077  1.00 47.86           C  
ATOM    399  CG2 VAL A  47      40.293  35.390  37.933  1.00 39.89           C  
ATOM    400  N   HIS A  48      38.490  34.314  33.831  1.00 35.16           N  
ATOM    401  CA  HIS A  48      38.338  33.614  32.527  1.00 34.17           C  
ATOM    402  C   HIS A  48      38.265  34.690  31.439  1.00 35.17           C  
ATOM    403  O   HIS A  48      38.954  34.601  30.425  1.00 37.32           O  
ATOM    404  CB  HIS A  48      37.094  32.707  32.580  1.00 33.57           C  
ATOM    405  CG  HIS A  48      36.776  31.934  31.314  1.00 35.20           C  
ATOM    406  ND1 HIS A  48      37.671  31.108  30.690  1.00 41.43           N  
ATOM    407  CD2 HIS A  48      35.603  31.787  30.635  1.00 42.38           C  
ATOM    408  CE1 HIS A  48      37.082  30.504  29.665  1.00 45.92           C  
ATOM    409  NE2 HIS A  48      35.832  30.936  29.566  1.00 35.03           N  
ATOM    410  N   LEU A  49      37.453  35.729  31.664  1.00 34.56           N  
ATOM    411  CA  LEU A  49      37.388  36.876  30.727  1.00 35.13           C  
ATOM    412  C   LEU A  49      38.762  37.568  30.495  1.00 36.19           C  
ATOM    413  O   LEU A  49      39.151  37.907  29.353  1.00 34.24           O  
ATOM    414  CB  LEU A  49      36.395  37.895  31.245  1.00 37.72           C  
ATOM    415  CG  LEU A  49      34.929  37.790  30.858  1.00 41.51           C  
ATOM    416  CD1 LEU A  49      34.065  38.623  31.882  1.00 39.13           C  
ATOM    417  CD2 LEU A  49      34.729  38.250  29.383  1.00 36.44           C  
ATOM    418  N   ALA A  50      39.485  37.770  31.585  1.00 36.43           N  
ATOM    419  CA  ALA A  50      40.791  38.422  31.544  1.00 35.28           C  
ATOM    420  C   ALA A  50      41.802  37.653  30.677  1.00 37.49           C  
ATOM    421  O   ALA A  50      42.647  38.280  30.037  1.00 40.14           O  
ATOM    422  CB  ALA A  50      41.354  38.596  32.981  1.00 34.13           C  
ATOM    423  N   VAL A  51      41.750  36.311  30.682  1.00 38.26           N  
ATOM    424  CA  VAL A  51      42.741  35.504  29.967  1.00 35.77           C  
ATOM    425  C   VAL A  51      42.260  34.918  28.632  1.00 35.69           C  
ATOM    426  O   VAL A  51      43.094  34.495  27.803  1.00 32.58           O  
ATOM    427  CB  VAL A  51      43.309  34.354  30.829  1.00 36.63           C  
ATOM    428  CG1 VAL A  51      43.797  34.867  32.161  1.00 37.26           C  
ATOM    429  CG2 VAL A  51      42.247  33.270  31.019  1.00 36.74           C  
ATOM    430  N   LEU A  52      40.961  34.923  28.346  1.00 34.47           N  
ATOM    431  CA  LEU A  52      40.544  34.047  27.272  1.00 34.73           C  
ATOM    432  C   LEU A  52      41.026  34.459  25.867  1.00 36.27           C  
ATOM    433  O   LEU A  52      41.122  33.607  24.969  1.00 34.86           O  
ATOM    434  CB  LEU A  52      39.032  33.790  27.295  1.00 40.40           C  
ATOM    435  CG  LEU A  52      38.022  34.896  26.963  1.00 35.56           C  
ATOM    436  CD1 LEU A  52      37.878  35.259  25.409  1.00 34.19           C  
ATOM    437  CD2 LEU A  52      36.659  34.422  27.534  1.00 35.30           C  
ATOM    438  N   LEU A  53      41.259  35.754  25.642  1.00 34.97           N  
ATOM    439  CA  LEU A  53      41.648  36.181  24.280  1.00 35.40           C  
ATOM    440  C   LEU A  53      42.999  35.578  23.938  1.00 35.59           C  
ATOM    441  O   LEU A  53      43.242  35.254  22.782  1.00 38.47           O  
ATOM    442  CB  LEU A  53      41.661  37.700  24.115  1.00 31.78           C  
ATOM    443  CG  LEU A  53      40.334  38.459  24.056  1.00 38.54           C  
ATOM    444  CD1 LEU A  53      40.633  39.967  23.934  1.00 35.18           C  
ATOM    445  CD2 LEU A  53      39.455  37.974  22.895  1.00 32.61           C  
ATOM    446  N   GLU A  54      43.857  35.380  24.940  1.00 33.84           N  
ATOM    447  CA  GLU A  54      45.183  34.771  24.725  1.00 34.22           C  
ATOM    448  C   GLU A  54      45.077  33.253  24.774  1.00 32.62           C  
ATOM    449  O   GLU A  54      45.615  32.565  23.910  1.00 35.61           O  
ATOM    450  CB  GLU A  54      46.165  35.342  25.746  1.00 32.77           C  
ATOM    451  CG  GLU A  54      47.507  34.703  25.794  1.00 36.51           C  
ATOM    452  CD  GLU A  54      48.505  35.435  26.678  1.00 39.65           C  
ATOM    453  OE1 GLU A  54      48.241  36.580  27.136  1.00 40.14           O  
ATOM    454  OE2 GLU A  54      49.585  34.846  26.930  1.00 33.74           O  
ATOM    455  N   ALA A  55      44.343  32.733  25.762  1.00 32.25           N  
ATOM    456  CA  ALA A  55      44.128  31.301  25.941  1.00 35.38           C  
ATOM    457  C   ALA A  55      43.625  30.700  24.652  1.00 34.59           C  
ATOM    458  O   ALA A  55      44.188  29.731  24.144  1.00 34.91           O  
ATOM    459  CB  ALA A  55      43.133  30.988  27.162  1.00 31.08           C  
ATOM    460  N   ASP A  56      42.581  31.289  24.073  1.00 35.03           N  
ATOM    461  CA  ASP A  56      42.014  30.677  22.893  1.00 34.36           C  
ATOM    462  C   ASP A  56      43.002  30.654  21.752  1.00 33.54           C  
ATOM    463  O   ASP A  56      43.000  29.717  20.968  1.00 34.42           O  
ATOM    464  CB  ASP A  56      40.720  31.380  22.451  1.00 35.61           C  
ATOM    465  CG  ASP A  56      39.529  31.116  23.396  1.00 38.12           C  
ATOM    466  OD1 ASP A  56      39.679  30.580  24.551  1.00 36.41           O  
ATOM    467  OD2 ASP A  56      38.382  31.484  23.009  1.00 43.11           O  
ATOM    468  N   LEU A  57      43.821  31.680  21.614  1.00 34.46           N  
ATOM    469  CA  LEU A  57      44.738  31.726  20.487  1.00 34.72           C  
ATOM    470  C   LEU A  57      45.913  30.792  20.695  1.00 36.13           C  
ATOM    471  O   LEU A  57      46.423  30.258  19.725  1.00 31.56           O  
ATOM    472  CB  LEU A  57      45.196  33.167  20.194  1.00 35.74           C  
ATOM    473  CG  LEU A  57      44.098  34.090  19.606  1.00 39.62           C  
ATOM    474  CD1 LEU A  57      44.704  35.403  19.226  1.00 33.66           C  
ATOM    475  CD2 LEU A  57      43.425  33.478  18.423  1.00 43.97           C  
ATOM    476  N   ARG A  58      46.312  30.582  21.945  1.00 36.06           N  
ATOM    477  CA  ARG A  58      47.317  29.575  22.284  1.00 34.34           C  
ATOM    478  C   ARG A  58      46.813  28.169  21.986  1.00 34.08           C  
ATOM    479  O   ARG A  58      47.548  27.336  21.395  1.00 34.68           O  
ATOM    480  CB  ARG A  58      47.693  29.703  23.768  1.00 35.34           C  
ATOM    481  CG  ARG A  58      48.542  30.925  24.074  1.00 39.71           C  
ATOM    482  CD  ARG A  58      49.161  30.973  25.485  1.00 39.67           C  
ATOM    483  NE  ARG A  58      49.991  32.173  25.590  1.00 40.80           N  
ATOM    484  CZ  ARG A  58      51.297  32.228  25.354  1.00 49.45           C  
ATOM    485  NH1 ARG A  58      51.984  31.140  25.061  1.00 44.79           N  
ATOM    486  NH2 ARG A  58      51.926  33.393  25.427  1.00 53.60           N  
ATOM    487  N   ILE A  59      45.602  27.866  22.447  1.00 36.28           N  
ATOM    488  CA  ILE A  59      44.924  26.635  22.066  1.00 37.77           C  
ATOM    489  C   ILE A  59      44.953  26.450  20.539  1.00 35.72           C  
ATOM    490  O   ILE A  59      45.188  25.325  20.075  1.00 36.03           O  
ATOM    491  CB  ILE A  59      43.474  26.593  22.625  1.00 41.66           C  
ATOM    492  CG1 ILE A  59      43.514  26.319  24.139  1.00 44.43           C  
ATOM    493  CG2 ILE A  59      42.598  25.570  21.864  1.00 42.61           C  
ATOM    494  CD1 ILE A  59      42.307  26.920  24.909  1.00 42.17           C  
ATOM    495  N   ALA A  60      44.690  27.536  19.806  1.00 37.85           N  
ATOM    496  CA  ALA A  60      44.616  27.576  18.318  1.00 35.36           C  
ATOM    497  C   ALA A  60      45.950  27.238  17.625  1.00 40.87           C  
ATOM    498  O   ALA A  60      45.987  26.628  16.542  1.00 38.69           O  
ATOM    499  CB  ALA A  60      44.112  28.972  17.833  1.00 34.98           C  
ATOM    500  N   THR A  61      47.047  27.599  18.283  1.00 41.18           N  
ATOM    501  CA  THR A  61      48.368  27.426  17.693  1.00 40.26           C  
ATOM    502  C   THR A  61      49.029  26.159  18.137  1.00 42.50           C  
ATOM    503  O   THR A  61      50.140  25.916  17.733  1.00 42.84           O  
ATOM    504  CB  THR A  61      49.230  28.692  17.891  1.00 40.57           C  
ATOM    505  OG1 THR A  61      49.313  29.033  19.263  1.00 45.92           O  
ATOM    506  CG2 THR A  61      48.591  29.889  17.152  1.00 38.62           C  
ATOM    507  N   GLY A  62      48.317  25.318  18.905  1.00 40.58           N  
ATOM    508  CA  GLY A  62      48.760  23.963  19.216  1.00 39.32           C  
ATOM    509  C   GLY A  62      49.185  23.738  20.654  1.00 37.62           C  
ATOM    510  O   GLY A  62      49.948  22.814  20.914  1.00 42.88           O  
ATOM    511  N   ALA A  63      48.725  24.548  21.608  1.00 37.04           N  
ATOM    512  CA  ALA A  63      49.227  24.389  22.975  1.00 37.99           C  
ATOM    513  C   ALA A  63      48.735  23.053  23.461  1.00 36.20           C  
ATOM    514  O   ALA A  63      47.633  22.629  23.108  1.00 39.22           O  
ATOM    515  CB  ALA A  63      48.778  25.504  23.925  1.00 34.11           C  
ATOM    516  N   THR A  64      49.563  22.383  24.252  1.00 40.22           N  
ATOM    517  CA  THR A  64      49.189  21.104  24.781  1.00 37.09           C  
ATOM    518  C   THR A  64      48.299  21.270  25.996  1.00 36.98           C  
ATOM    519  O   THR A  64      48.152  22.372  26.558  1.00 33.32           O  
ATOM    520  CB  THR A  64      50.422  20.226  25.109  1.00 39.63           C  
ATOM    521  OG1 THR A  64      51.175  20.809  26.188  1.00 35.43           O  
ATOM    522  CG2 THR A  64      51.289  20.086  23.868  1.00 37.38           C  
ATOM    523  N   ALA A  65      47.687  20.154  26.372  1.00 36.13           N  
ATOM    524  CA  ALA A  65      46.865  20.089  27.557  1.00 34.08           C  
ATOM    525  C   ALA A  65      47.658  20.538  28.781  1.00 31.85           C  
ATOM    526  O   ALA A  65      47.163  21.386  29.526  1.00 34.56           O  
ATOM    527  CB  ALA A  65      46.304  18.710  27.728  1.00 31.03           C  
ATOM    528  N   ASP A  66      48.899  20.064  28.942  1.00 29.87           N  
ATOM    529  CA  ASP A  66      49.695  20.496  30.070  1.00 29.28           C  
ATOM    530  C   ASP A  66      50.086  21.925  30.015  1.00 28.43           C  
ATOM    531  O   ASP A  66      50.180  22.555  31.051  1.00 31.21           O  
ATOM    532  CB  ASP A  66      50.975  19.709  30.277  1.00 21.43           C  
ATOM    533  CG  ASP A  66      51.597  19.957  31.681  1.00 34.01           C  
ATOM    534  OD1 ASP A  66      50.889  19.787  32.727  1.00 36.66           O  
ATOM    535  OD2 ASP A  66      52.807  20.280  31.721  1.00 41.49           O  
ATOM    536  N   GLU A  67      50.347  22.444  28.821  1.00 34.27           N  
ATOM    537  CA  GLU A  67      50.746  23.830  28.661  1.00 34.45           C  
ATOM    538  C   GLU A  67      49.604  24.711  29.081  1.00 32.20           C  
ATOM    539  O   GLU A  67      49.795  25.737  29.734  1.00 31.83           O  
ATOM    540  CB  GLU A  67      51.150  24.105  27.197  1.00 36.53           C  
ATOM    541  CG  GLU A  67      52.584  23.616  26.902  1.00 43.42           C  
ATOM    542  CD  GLU A  67      53.062  23.730  25.441  1.00 40.53           C  
ATOM    543  OE1 GLU A  67      52.257  23.912  24.526  1.00 40.12           O  
ATOM    544  OE2 GLU A  67      54.291  23.567  25.232  1.00 58.40           O  
HETATM  545  N   MSE A  68      48.393  24.298  28.726  1.00 32.58           N  
HETATM  546  CA  MSE A  68      47.219  25.063  29.073  1.00 31.63           C  
HETATM  547  C   MSE A  68      46.930  24.974  30.556  1.00 30.51           C  
HETATM  548  O   MSE A  68      46.495  25.962  31.153  1.00 32.70           O  
HETATM  549  CB  MSE A  68      45.981  24.615  28.262  1.00 34.80           C  
HETATM  550  CG  MSE A  68      45.985  24.968  26.802  1.00 40.82           C  
HETATM  551 SE   MSE A  68      46.665  26.808  26.405  0.70 43.65          SE  
HETATM  552  CE  MSE A  68      45.324  27.867  27.396  1.00 36.79           C  
ATOM    553  N   ALA A  69      47.214  23.818  31.167  1.00 29.17           N  
ATOM    554  CA  ALA A  69      46.989  23.669  32.573  1.00 29.09           C  
ATOM    555  C   ALA A  69      47.926  24.601  33.292  1.00 29.41           C  
ATOM    556  O   ALA A  69      47.589  25.159  34.325  1.00 35.14           O  
ATOM    557  CB  ALA A  69      47.275  22.240  33.026  1.00 30.99           C  
ATOM    558  N   GLN A  70      49.140  24.700  32.781  1.00 29.12           N  
ATOM    559  CA  GLN A  70      50.146  25.548  33.389  1.00 30.47           C  
ATOM    560  C   GLN A  70      49.717  27.007  33.230  1.00 31.93           C  
ATOM    561  O   GLN A  70      49.960  27.780  34.147  1.00 34.11           O  
ATOM    562  CB  GLN A  70      51.485  25.312  32.724  1.00 26.32           C  
ATOM    563  CG  GLN A  70      52.553  26.261  33.182  1.00 28.44           C  
ATOM    564  CD  GLN A  70      53.915  25.873  32.694  1.00 32.82           C  
ATOM    565  OE1 GLN A  70      54.153  24.714  32.249  1.00 35.76           O  
ATOM    566  NE2 GLN A  70      54.853  26.824  32.797  1.00 30.54           N  
ATOM    567  N   PHE A  71      49.034  27.331  32.111  1.00 32.84           N  
ATOM    568  CA  PHE A  71      48.588  28.674  31.775  1.00 31.52           C  
ATOM    569  C   PHE A  71      47.462  29.072  32.690  1.00 34.32           C  
ATOM    570  O   PHE A  71      47.479  30.146  33.252  1.00 37.68           O  
ATOM    571  CB  PHE A  71      48.090  28.750  30.298  1.00 33.16           C  
ATOM    572  CG  PHE A  71      47.530  30.102  29.893  1.00 35.14           C  
ATOM    573  CD1 PHE A  71      48.351  31.098  29.369  1.00 38.15           C  
ATOM    574  CD2 PHE A  71      46.204  30.343  29.993  1.00 30.46           C  
ATOM    575  CE1 PHE A  71      47.836  32.347  28.990  1.00 32.11           C  
ATOM    576  CE2 PHE A  71      45.658  31.603  29.626  1.00 41.92           C  
ATOM    577  CZ  PHE A  71      46.475  32.593  29.124  1.00 33.69           C  
ATOM    578  N   TYR A  72      46.475  28.192  32.830  1.00 32.89           N  
ATOM    579  CA  TYR A  72      45.336  28.468  33.661  1.00 35.71           C  
ATOM    580  C   TYR A  72      45.684  28.518  35.115  1.00 35.76           C  
ATOM    581  O   TYR A  72      44.995  29.181  35.868  1.00 39.30           O  
ATOM    582  CB  TYR A  72      44.231  27.437  33.430  1.00 39.50           C  
ATOM    583  CG  TYR A  72      43.592  27.496  32.071  1.00 40.07           C  
ATOM    584  CD1 TYR A  72      43.126  28.698  31.549  1.00 39.71           C  
ATOM    585  CD2 TYR A  72      43.445  26.355  31.297  1.00 43.77           C  
ATOM    586  CE1 TYR A  72      42.520  28.760  30.315  1.00 57.79           C  
ATOM    587  CE2 TYR A  72      42.851  26.418  30.038  1.00 50.90           C  
ATOM    588  CZ  TYR A  72      42.395  27.618  29.562  1.00 50.47           C  
ATOM    589  OH  TYR A  72      41.780  27.710  28.338  1.00 56.06           O  
ATOM    590  N   ALA A  73      46.743  27.823  35.518  1.00 35.43           N  
ATOM    591  CA  ALA A  73      47.152  27.807  36.911  1.00 38.38           C  
ATOM    592  C   ALA A  73      47.869  29.070  37.378  1.00 39.36           C  
ATOM    593  O   ALA A  73      48.053  29.229  38.570  1.00 40.21           O  
ATOM    594  CB  ALA A  73      48.022  26.543  37.227  1.00 34.73           C  
ATOM    595  N   VAL A  74      48.295  29.955  36.484  1.00 42.12           N  
ATOM    596  CA  VAL A  74      48.970  31.168  36.958  1.00 41.98           C  
ATOM    597  C   VAL A  74      47.897  32.073  37.595  1.00 39.16           C  
ATOM    598  O   VAL A  74      46.900  32.396  36.967  1.00 37.04           O  
ATOM    599  CB  VAL A  74      49.831  31.861  35.862  1.00 43.50           C  
ATOM    600  CG1 VAL A  74      50.293  33.233  36.332  1.00 43.48           C  
ATOM    601  CG2 VAL A  74      51.076  31.012  35.571  1.00 37.93           C  
ATOM    602  N   PRO A  75      48.052  32.395  38.886  1.00 38.58           N  
ATOM    603  CA  PRO A  75      46.989  33.118  39.577  1.00 38.99           C  
ATOM    604  C   PRO A  75      46.820  34.571  39.107  1.00 38.98           C  
ATOM    605  O   PRO A  75      47.790  35.277  38.916  1.00 38.80           O  
ATOM    606  CB  PRO A  75      47.421  33.077  41.045  1.00 39.17           C  
ATOM    607  CG  PRO A  75      48.870  32.806  41.025  1.00 42.36           C  
ATOM    608  CD  PRO A  75      49.192  32.092  39.767  1.00 37.34           C  
ATOM    609  N   VAL A  76      45.581  34.988  38.913  1.00 39.85           N  
ATOM    610  CA  VAL A  76      45.296  36.385  38.615  1.00 40.36           C  
ATOM    611  C   VAL A  76      44.512  36.929  39.779  1.00 41.95           C  
ATOM    612  O   VAL A  76      43.341  36.633  39.937  1.00 42.30           O  
ATOM    613  CB  VAL A  76      44.534  36.571  37.321  1.00 38.82           C  
ATOM    614  CG1 VAL A  76      44.414  38.050  37.023  1.00 35.15           C  
ATOM    615  CG2 VAL A  76      45.251  35.900  36.180  1.00 32.25           C  
ATOM    616  N   LEU A  77      45.187  37.699  40.622  1.00 42.09           N  
ATOM    617  CA  LEU A  77      44.545  38.276  41.789  1.00 43.72           C  
ATOM    618  C   LEU A  77      43.617  39.422  41.372  1.00 42.89           C  
ATOM    619  O   LEU A  77      43.841  40.049  40.331  1.00 41.15           O  
ATOM    620  CB  LEU A  77      45.605  38.753  42.781  1.00 45.22           C  
ATOM    621  CG  LEU A  77      46.531  37.666  43.328  1.00 46.54           C  
ATOM    622  CD1 LEU A  77      47.641  38.322  44.159  1.00 47.95           C  
ATOM    623  CD2 LEU A  77      45.740  36.636  44.152  1.00 41.30           C  
ATOM    624  N   PRO A  78      42.559  39.685  42.158  1.00 41.56           N  
ATOM    625  CA  PRO A  78      41.573  40.691  41.771  1.00 43.80           C  
ATOM    626  C   PRO A  78      42.154  42.042  41.331  1.00 44.80           C  
ATOM    627  O   PRO A  78      41.635  42.666  40.399  1.00 44.65           O  
ATOM    628  CB  PRO A  78      40.740  40.844  43.034  1.00 44.23           C  
ATOM    629  CG  PRO A  78      40.821  39.514  43.678  1.00 43.02           C  
ATOM    630  CD  PRO A  78      42.206  39.049  43.433  1.00 43.26           C  
ATOM    631  N   GLU A  79      43.234  42.470  41.967  1.00 43.26           N  
ATOM    632  CA  GLU A  79      43.869  43.753  41.650  1.00 44.69           C  
ATOM    633  C   GLU A  79      44.691  43.735  40.355  1.00 43.46           C  
ATOM    634  O   GLU A  79      45.053  44.784  39.843  1.00 42.56           O  
ATOM    635  CB  GLU A  79      44.727  44.237  42.838  1.00 46.03           C  
ATOM    636  CG  GLU A  79      45.884  43.305  43.229  1.00 51.76           C  
ATOM    637  CD  GLU A  79      45.552  42.313  44.371  1.00 61.71           C  
ATOM    638  OE1 GLU A  79      44.409  41.773  44.438  1.00 60.84           O  
ATOM    639  OE2 GLU A  79      46.470  42.063  45.195  1.00 58.62           O  
ATOM    640  N   GLN A  80      44.991  42.553  39.820  1.00 44.66           N  
ATOM    641  CA  GLN A  80      45.723  42.455  38.546  1.00 44.68           C  
ATOM    642  C   GLN A  80      44.821  42.174  37.334  1.00 43.79           C  
ATOM    643  O   GLN A  80      45.304  42.063  36.218  1.00 43.00           O  
ATOM    644  CB  GLN A  80      46.759  41.354  38.629  1.00 43.82           C  
ATOM    645  CG  GLN A  80      47.755  41.527  39.754  1.00 47.56           C  
ATOM    646  CD  GLN A  80      48.335  40.201  40.240  1.00 49.86           C  
ATOM    647  OE1 GLN A  80      47.729  39.126  40.085  1.00 47.77           O  
ATOM    648  NE2 GLN A  80      49.517  40.278  40.854  1.00 59.13           N  
ATOM    649  N   LEU A  81      43.518  42.065  37.564  1.00 43.24           N  
ATOM    650  CA  LEU A  81      42.581  41.634  36.518  1.00 41.15           C  
ATOM    651  C   LEU A  81      42.597  42.543  35.327  1.00 38.96           C  
ATOM    652  O   LEU A  81      42.671  42.064  34.194  1.00 39.63           O  
ATOM    653  CB  LEU A  81      41.155  41.476  37.064  1.00 36.03           C  
ATOM    654  CG  LEU A  81      40.911  40.140  37.755  1.00 39.04           C  
ATOM    655  CD1 LEU A  81      39.558  40.141  38.403  1.00 37.69           C  
ATOM    656  CD2 LEU A  81      41.010  39.015  36.727  1.00 40.37           C  
ATOM    657  N   VAL A  82      42.522  43.851  35.541  1.00 42.19           N  
ATOM    658  CA  VAL A  82      42.529  44.764  34.394  1.00 39.77           C  
ATOM    659  C   VAL A  82      43.846  44.645  33.649  1.00 40.15           C  
ATOM    660  O   VAL A  82      43.860  44.568  32.417  1.00 41.14           O  
ATOM    661  CB  VAL A  82      42.237  46.224  34.778  1.00 41.70           C  
ATOM    662  CG1 VAL A  82      42.492  47.154  33.572  1.00 41.26           C  
ATOM    663  CG2 VAL A  82      40.808  46.348  35.253  1.00 46.44           C  
ATOM    664  N   ASP A  83      44.951  44.649  34.384  1.00 41.05           N  
ATOM    665  CA  ASP A  83      46.279  44.518  33.791  1.00 40.96           C  
ATOM    666  C   ASP A  83      46.351  43.274  32.943  1.00 37.58           C  
ATOM    667  O   ASP A  83      46.942  43.292  31.869  1.00 33.78           O  
ATOM    668  CB  ASP A  83      47.364  44.441  34.865  1.00 42.60           C  
ATOM    669  CG  ASP A  83      47.666  45.795  35.508  1.00 56.71           C  
ATOM    670  OD1 ASP A  83      47.151  46.835  35.007  1.00 72.04           O  
ATOM    671  OD2 ASP A  83      48.428  45.817  36.513  1.00 64.36           O  
ATOM    672  N   ARG A  84      45.736  42.199  33.432  1.00 36.15           N  
ATOM    673  CA  ARG A  84      45.720  40.921  32.730  1.00 37.48           C  
ATOM    674  C   ARG A  84      44.887  40.929  31.459  1.00 35.35           C  
ATOM    675  O   ARG A  84      45.324  40.445  30.443  1.00 37.81           O  
ATOM    676  CB  ARG A  84      45.253  39.780  33.678  1.00 38.47           C  
ATOM    677  CG  ARG A  84      45.534  38.379  33.134  1.00 36.94           C  
ATOM    678  CD  ARG A  84      46.979  38.346  32.654  1.00 46.88           C  
ATOM    679  NE  ARG A  84      47.448  37.067  32.175  1.00 45.20           N  
ATOM    680  CZ  ARG A  84      47.500  36.689  30.901  1.00 57.24           C  
ATOM    681  NH1 ARG A  84      47.111  37.498  29.886  1.00 41.14           N  
ATOM    682  NH2 ARG A  84      47.960  35.457  30.647  1.00 56.31           N  
ATOM    683  N   LEU A  85      43.688  41.480  31.529  1.00 33.44           N  
ATOM    684  CA  LEU A  85      42.864  41.718  30.353  1.00 36.00           C  
ATOM    685  C   LEU A  85      43.646  42.521  29.255  1.00 34.73           C  
ATOM    686  O   LEU A  85      43.617  42.209  28.029  1.00 33.71           O  
ATOM    687  CB  LEU A  85      41.600  42.462  30.801  1.00 34.72           C  
ATOM    688  CG  LEU A  85      40.578  42.903  29.738  1.00 37.85           C  
ATOM    689  CD1 LEU A  85      40.112  41.719  28.861  1.00 38.40           C  
ATOM    690  CD2 LEU A  85      39.409  43.612  30.467  1.00 36.98           C  
ATOM    691  N   ASP A  86      44.342  43.557  29.690  1.00 36.50           N  
ATOM    692  CA  ASP A  86      45.090  44.396  28.777  1.00 37.49           C  
ATOM    693  C   ASP A  86      46.177  43.621  28.048  1.00 36.33           C  
ATOM    694  O   ASP A  86      46.417  43.824  26.842  1.00 36.19           O  
ATOM    695  CB  ASP A  86      45.707  45.584  29.527  1.00 39.90           C  
ATOM    696  CG  ASP A  86      44.659  46.634  29.984  1.00 51.15           C  
ATOM    697  OD1 ASP A  86      43.437  46.442  29.782  1.00 53.43           O  
ATOM    698  OD2 ASP A  86      45.068  47.673  30.570  1.00 67.22           O  
ATOM    699  N   GLN A  87      46.870  42.777  28.801  1.00 35.59           N  
ATOM    700  CA  GLN A  87      47.874  41.894  28.250  1.00 35.58           C  
ATOM    701  C   GLN A  87      47.305  40.933  27.220  1.00 34.02           C  
ATOM    702  O   GLN A  87      47.883  40.757  26.147  1.00 31.65           O  
ATOM    703  CB  GLN A  87      48.483  41.105  29.389  1.00 36.20           C  
ATOM    704  CG  GLN A  87      49.519  40.111  29.012  1.00 43.33           C  
ATOM    705  CD  GLN A  87      50.170  39.470  30.261  1.00 41.25           C  
ATOM    706  OE1 GLN A  87      50.365  40.131  31.309  1.00 40.64           O  
ATOM    707  NE2 GLN A  87      50.492  38.175  30.154  1.00 43.73           N  
ATOM    708  N   SER A  88      46.161  40.313  27.549  1.00 35.68           N  
ATOM    709  CA  SER A  88      45.456  39.420  26.620  1.00 34.25           C  
ATOM    710  C   SER A  88      45.013  40.158  25.348  1.00 32.96           C  
ATOM    711  O   SER A  88      45.140  39.650  24.249  1.00 35.68           O  
ATOM    712  CB  SER A  88      44.247  38.760  27.309  1.00 32.47           C  
ATOM    713  OG  SER A  88      44.701  38.046  28.442  1.00 39.49           O  
ATOM    714  N   TRP A  89      44.513  41.365  25.518  1.00 31.58           N  
ATOM    715  CA  TRP A  89      44.052  42.173  24.374  1.00 33.96           C  
ATOM    716  C   TRP A  89      45.244  42.516  23.448  1.00 33.22           C  
ATOM    717  O   TRP A  89      45.115  42.522  22.231  1.00 34.31           O  
ATOM    718  CB  TRP A  89      43.333  43.414  24.914  1.00 33.77           C  
ATOM    719  CG  TRP A  89      43.007  44.476  23.989  1.00 32.97           C  
ATOM    720  CD1 TRP A  89      43.213  45.788  24.222  1.00 37.93           C  
ATOM    721  CD2 TRP A  89      42.375  44.386  22.702  1.00 32.61           C  
ATOM    722  NE1 TRP A  89      42.770  46.533  23.177  1.00 43.18           N  
ATOM    723  CE2 TRP A  89      42.264  45.701  22.215  1.00 41.44           C  
ATOM    724  CE3 TRP A  89      41.922  43.332  21.892  1.00 37.48           C  
ATOM    725  CZ2 TRP A  89      41.705  46.001  20.973  1.00 38.48           C  
ATOM    726  CZ3 TRP A  89      41.358  43.639  20.637  1.00 32.82           C  
ATOM    727  CH2 TRP A  89      41.274  44.970  20.197  1.00 38.05           C  
ATOM    728  N   GLN A  90      46.405  42.787  24.038  1.00 33.74           N  
ATOM    729  CA  GLN A  90      47.612  43.072  23.249  1.00 36.59           C  
ATOM    730  C   GLN A  90      48.050  41.843  22.459  1.00 35.78           C  
ATOM    731  O   GLN A  90      48.462  41.934  21.301  1.00 34.34           O  
ATOM    732  CB  GLN A  90      48.753  43.536  24.162  1.00 37.84           C  
ATOM    733  CG  GLN A  90      49.948  44.055  23.389  1.00 47.26           C  
ATOM    734  CD  GLN A  90      49.561  45.233  22.505  1.00 53.35           C  
ATOM    735  OE1 GLN A  90      49.040  46.245  22.995  1.00 54.28           O  
ATOM    736  NE2 GLN A  90      49.775  45.089  21.194  1.00 38.31           N  
ATOM    737  N   TYR A  91      47.954  40.678  23.092  1.00 35.29           N  
ATOM    738  CA  TYR A  91      48.347  39.439  22.468  1.00 36.69           C  
ATOM    739  C   TYR A  91      47.452  39.206  21.255  1.00 35.73           C  
ATOM    740  O   TYR A  91      47.943  38.851  20.151  1.00 35.81           O  
ATOM    741  CB  TYR A  91      48.174  38.291  23.461  1.00 36.85           C  
ATOM    742  CG  TYR A  91      48.700  36.965  22.991  1.00 38.77           C  
ATOM    743  CD1 TYR A  91      47.938  36.163  22.158  1.00 40.83           C  
ATOM    744  CD2 TYR A  91      49.963  36.519  23.365  1.00 39.74           C  
ATOM    745  CE1 TYR A  91      48.392  34.941  21.711  1.00 43.96           C  
ATOM    746  CE2 TYR A  91      50.429  35.273  22.939  1.00 42.44           C  
ATOM    747  CZ  TYR A  91      49.631  34.496  22.101  1.00 42.15           C  
ATOM    748  OH  TYR A  91      50.067  33.281  21.650  1.00 49.25           O  
ATOM    749  N   TYR A  92      46.157  39.388  21.487  1.00 36.32           N  
ATOM    750  CA  TYR A  92      45.158  39.233  20.438  1.00 34.80           C  
ATOM    751  C   TYR A  92      45.441  40.210  19.273  1.00 35.32           C  
ATOM    752  O   TYR A  92      45.393  39.830  18.110  1.00 36.14           O  
ATOM    753  CB  TYR A  92      43.758  39.427  21.006  1.00 34.65           C  
ATOM    754  CG  TYR A  92      42.598  39.203  19.999  1.00 33.61           C  
ATOM    755  CD1 TYR A  92      42.096  40.253  19.227  1.00 32.06           C  
ATOM    756  CD2 TYR A  92      42.013  37.945  19.844  1.00 33.63           C  
ATOM    757  CE1 TYR A  92      41.045  40.057  18.348  1.00 34.29           C  
ATOM    758  CE2 TYR A  92      40.956  37.738  18.953  1.00 34.71           C  
ATOM    759  CZ  TYR A  92      40.489  38.798  18.197  1.00 33.08           C  
ATOM    760  OH  TYR A  92      39.469  38.598  17.302  1.00 35.72           O  
ATOM    761  N   GLN A  93      45.694  41.461  19.599  1.00 33.87           N  
ATOM    762  CA  GLN A  93      45.913  42.457  18.547  1.00 37.67           C  
ATOM    763  C   GLN A  93      47.113  42.095  17.708  1.00 34.48           C  
ATOM    764  O   GLN A  93      47.122  42.283  16.486  1.00 37.32           O  
ATOM    765  CB  GLN A  93      46.118  43.843  19.128  1.00 39.73           C  
ATOM    766  CG  GLN A  93      44.875  44.456  19.684  1.00 43.17           C  
ATOM    767  CD  GLN A  93      45.166  45.815  20.257  1.00 45.52           C  
ATOM    768  OE1 GLN A  93      45.281  45.989  21.482  1.00 60.54           O  
ATOM    769  NE2 GLN A  93      45.348  46.781  19.378  1.00 43.21           N  
ATOM    770  N   ASP A  94      48.147  41.558  18.341  1.00 34.02           N  
ATOM    771  CA  ASP A  94      49.328  41.197  17.583  1.00 36.10           C  
ATOM    772  C   ASP A  94      49.061  40.030  16.630  1.00 34.49           C  
ATOM    773  O   ASP A  94      49.539  40.024  15.502  1.00 33.44           O  
ATOM    774  CB  ASP A  94      50.434  40.802  18.545  1.00 38.78           C  
ATOM    775  CG  ASP A  94      50.917  41.971  19.413  1.00 47.40           C  
ATOM    776  OD1 ASP A  94      50.523  43.151  19.156  1.00 53.69           O  
ATOM    777  OD2 ASP A  94      51.711  41.694  20.353  1.00 53.98           O  
ATOM    778  N   ARG A  95      48.299  39.038  17.094  1.00 33.75           N  
ATOM    779  CA  ARG A  95      47.915  37.899  16.245  1.00 36.77           C  
ATOM    780  C   ARG A  95      46.943  38.351  15.132  1.00 39.74           C  
ATOM    781  O   ARG A  95      46.950  37.847  13.988  1.00 40.99           O  
ATOM    782  CB  ARG A  95      47.317  36.767  17.083  1.00 39.35           C  
ATOM    783  CG  ARG A  95      48.301  36.105  18.080  1.00 39.93           C  
ATOM    784  CD  ARG A  95      49.742  36.280  17.672  1.00 53.30           C  
ATOM    785  NE  ARG A  95      50.713  35.767  18.637  1.00 58.46           N  
ATOM    786  CZ  ARG A  95      51.083  36.352  19.781  1.00 60.80           C  
ATOM    787  NH1 ARG A  95      50.538  37.481  20.207  1.00 58.82           N  
ATOM    788  NH2 ARG A  95      52.018  35.766  20.523  1.00 72.00           N  
ATOM    789  N   LEU A  96      46.124  39.316  15.485  1.00 40.06           N  
ATOM    790  CA  LEU A  96      45.111  39.821  14.575  1.00 41.18           C  
ATOM    791  C   LEU A  96      45.762  40.338  13.329  1.00 37.54           C  
ATOM    792  O   LEU A  96      45.312  40.055  12.244  1.00 41.25           O  
ATOM    793  CB  LEU A  96      44.282  40.905  15.252  1.00 41.06           C  
ATOM    794  CG  LEU A  96      43.167  41.606  14.451  1.00 40.83           C  
ATOM    795  CD1 LEU A  96      42.166  40.572  13.915  1.00 37.37           C  
ATOM    796  CD2 LEU A  96      42.473  42.658  15.294  1.00 38.70           C  
HETATM  797  N   MSE A  97      46.865  41.046  13.498  1.00 40.92           N  
HETATM  798  CA  MSE A  97      47.514  41.713  12.396  1.00 43.66           C  
HETATM  799  C   MSE A  97      48.531  40.836  11.681  1.00 44.49           C  
HETATM  800  O   MSE A  97      48.750  40.994  10.501  1.00 45.46           O  
HETATM  801  CB  MSE A  97      48.169  42.985  12.906  1.00 46.03           C  
HETATM  802  CG  MSE A  97      47.173  43.887  13.618  1.00 48.94           C  
HETATM  803 SE   MSE A  97      45.662  44.491  12.459  0.70 59.58          SE  
HETATM  804  CE  MSE A  97      44.427  45.300  13.880  1.00 49.81           C  
ATOM    805  N   ALA A  98      49.110  39.879  12.378  1.00 47.94           N  
ATOM    806  CA  ALA A  98      50.126  39.002  11.805  1.00 53.19           C  
ATOM    807  C   ALA A  98      49.545  37.653  11.337  1.00 56.87           C  
ATOM    808  O   ALA A  98      48.771  37.007  12.054  1.00 56.13           O  
ATOM    809  CB  ALA A  98      51.169  38.764  12.839  1.00 54.01           C  
ATOM    810  N   ASP A  99      49.927  37.214  10.141  1.00 60.75           N  
ATOM    811  CA  ASP A  99      49.578  35.853   9.680  1.00 63.60           C  
ATOM    812  C   ASP A  99      50.167  34.824  10.653  1.00 64.14           C  
ATOM    813  O   ASP A  99      51.391  34.575  10.619  1.00 67.62           O  
ATOM    814  CB  ASP A  99      50.112  35.580   8.248  1.00 64.57           C  
ATOM    815  CG  ASP A  99      50.015  34.099   7.845  1.00 61.66           C  
ATOM    816  N   PHE A 100      49.330  34.243  11.522  1.00 60.96           N  
ATOM    817  CA  PHE A 100      49.784  33.106  12.327  1.00 59.99           C  
ATOM    818  C   PHE A 100      49.287  31.753  11.762  1.00 56.95           C  
ATOM    819  O   PHE A 100      48.409  31.716  10.909  1.00 57.47           O  
ATOM    820  CB  PHE A 100      49.498  33.317  13.825  1.00 60.27           C  
ATOM    821  CG  PHE A 100      48.055  33.227  14.213  1.00 62.27           C  
ATOM    822  CD1 PHE A 100      47.238  34.345  14.163  1.00 61.70           C  
ATOM    823  CD2 PHE A 100      47.527  32.036  14.680  1.00 60.84           C  
ATOM    824  CE1 PHE A 100      45.902  34.263  14.560  1.00 63.85           C  
ATOM    825  CE2 PHE A 100      46.203  31.946  15.067  1.00 65.67           C  
ATOM    826  CZ  PHE A 100      45.387  33.063  15.002  1.00 63.41           C  
ATOM    827  N   SER A 101      49.910  30.662  12.189  1.00 55.63           N  
ATOM    828  CA  SER A 101      49.525  29.324  11.738  1.00 55.27           C  
ATOM    829  C   SER A 101      48.699  28.654  12.831  1.00 52.95           C  
ATOM    830  O   SER A 101      49.089  28.642  13.998  1.00 53.51           O  
ATOM    831  CB  SER A 101      50.759  28.455  11.407  1.00 53.73           C  
ATOM    832  N   THR A 102      47.561  28.094  12.449  1.00 52.34           N  
ATOM    833  CA  THR A 102      46.750  27.304  13.381  1.00 50.83           C  
ATOM    834  C   THR A 102      47.056  25.836  13.183  1.00 47.78           C  
ATOM    835  O   THR A 102      47.556  25.411  12.140  1.00 50.35           O  
ATOM    836  CB  THR A 102      45.219  27.541  13.224  1.00 52.28           C  
ATOM    837  OG1 THR A 102      44.807  27.281  11.874  1.00 55.75           O  
ATOM    838  CG2 THR A 102      44.862  28.963  13.589  1.00 53.55           C  
ATOM    839  N   GLU A 103      46.781  25.080  14.223  1.00 45.77           N  
ATOM    840  CA  GLU A 103      46.930  23.646  14.236  1.00 46.97           C  
ATOM    841  C   GLU A 103      45.670  23.047  14.867  1.00 45.75           C  
ATOM    842  O   GLU A 103      44.932  23.719  15.609  1.00 43.87           O  
ATOM    843  CB  GLU A 103      48.155  23.265  15.064  1.00 45.57           C  
ATOM    844  CG  GLU A 103      49.464  23.943  14.602  1.00 56.67           C  
ATOM    845  N   THR A 104      45.425  21.776  14.587  1.00 47.54           N  
ATOM    846  CA  THR A 104      44.315  21.072  15.238  1.00 48.84           C  
ATOM    847  C   THR A 104      44.567  21.078  16.737  1.00 49.42           C  
ATOM    848  O   THR A 104      45.691  20.828  17.179  1.00 47.88           O  
ATOM    849  CB  THR A 104      44.204  19.637  14.708  1.00 50.24           C  
ATOM    850  OG1 THR A 104      43.934  19.689  13.291  1.00 50.58           O  
ATOM    851  CG2 THR A 104      43.124  18.844  15.460  1.00 45.01           C  
ATOM    852  N   THR A 105      43.544  21.387  17.522  1.00 50.76           N  
ATOM    853  CA  THR A 105      43.720  21.500  18.962  1.00 52.42           C  
ATOM    854  C   THR A 105      44.021  20.114  19.557  1.00 54.09           C  
ATOM    855  O   THR A 105      43.916  19.067  18.874  1.00 49.72           O  
ATOM    856  CB  THR A 105      42.506  22.160  19.689  1.00 54.52           C  
ATOM    857  OG1 THR A 105      41.433  21.213  19.878  1.00 59.30           O  
ATOM    858  CG2 THR A 105      42.017  23.369  18.926  1.00 44.65           C  
ATOM    859  N   TYR A 106      44.399  20.110  20.825  1.00 58.65           N  
ATOM    860  CA  TYR A 106      44.830  18.852  21.460  1.00 63.25           C  
ATOM    861  C   TYR A 106      43.630  17.917  21.691  1.00 66.48           C  
ATOM    862  O   TYR A 106      43.743  16.687  21.570  1.00 67.42           O  
ATOM    863  CB  TYR A 106      45.628  19.112  22.746  1.00 64.46           C  
ATOM    864  CG  TYR A 106      44.856  19.770  23.854  1.00 62.80           C  
ATOM    865  CD1 TYR A 106      44.763  21.162  23.945  1.00 65.12           C  
ATOM    866  CD2 TYR A 106      44.237  19.007  24.826  1.00 66.21           C  
ATOM    867  CE1 TYR A 106      44.057  21.776  24.966  1.00 63.07           C  
ATOM    868  CE2 TYR A 106      43.542  19.603  25.846  1.00 67.09           C  
ATOM    869  CZ  TYR A 106      43.453  20.985  25.918  1.00 66.45           C  
ATOM    870  OH  TYR A 106      42.762  21.574  26.946  1.00 68.92           O  
ATOM    871  N   TRP A 107      42.479  18.513  21.989  1.00 68.68           N  
ATOM    872  CA  TRP A 107      41.220  17.771  22.010  1.00 69.80           C  
ATOM    873  C   TRP A 107      40.554  17.666  20.605  1.00 70.04           C  
ATOM    874  O   TRP A 107      39.519  17.015  20.468  1.00 71.45           O  
ATOM    875  CB  TRP A 107      40.269  18.380  23.053  1.00 71.89           C  
ATOM    876  CG  TRP A 107      39.515  19.559  22.572  1.00 75.06           C  
ATOM    877  CD1 TRP A 107      38.405  19.550  21.780  1.00 75.69           C  
ATOM    878  CD2 TRP A 107      39.800  20.928  22.853  1.00 77.13           C  
ATOM    879  NE1 TRP A 107      37.982  20.826  21.553  1.00 73.88           N  
ATOM    880  CE2 TRP A 107      38.815  21.698  22.204  1.00 74.27           C  
ATOM    881  CE3 TRP A 107      40.792  21.580  23.589  1.00 76.69           C  
ATOM    882  CZ2 TRP A 107      38.787  23.099  22.266  1.00 75.01           C  
ATOM    883  CZ3 TRP A 107      40.772  22.966  23.647  1.00 76.46           C  
ATOM    884  CH2 TRP A 107      39.770  23.715  22.982  1.00 76.98           C  
ATOM    885  N   GLY A 108      41.131  18.319  19.583  1.00 67.52           N  
ATOM    886  CA  GLY A 108      40.861  17.979  18.171  1.00 63.50           C  
ATOM    887  C   GLY A 108      39.981  18.932  17.351  1.00 61.88           C  
ATOM    888  O   GLY A 108      39.523  18.556  16.260  1.00 62.65           O  
ATOM    889  N   VAL A 109      39.752  20.159  17.820  1.00 55.97           N  
ATOM    890  CA  VAL A 109      38.991  21.124  16.986  1.00 55.25           C  
ATOM    891  C   VAL A 109      39.922  21.753  15.976  1.00 48.99           C  
ATOM    892  O   VAL A 109      41.064  22.107  16.321  1.00 47.06           O  
ATOM    893  CB  VAL A 109      38.313  22.196  17.773  1.00 54.69           C  
ATOM    894  CG1 VAL A 109      37.767  23.279  16.820  1.00 55.98           C  
ATOM    895  CG2 VAL A 109      37.186  21.596  18.561  1.00 61.93           C  
ATOM    896  N   THR A 110      39.457  21.791  14.722  1.00 43.91           N  
ATOM    897  CA  THR A 110      40.186  22.410  13.621  1.00 42.07           C  
ATOM    898  C   THR A 110      39.423  23.652  13.120  1.00 40.08           C  
ATOM    899  O   THR A 110      38.205  23.618  13.004  1.00 40.36           O  
ATOM    900  CB  THR A 110      40.370  21.420  12.466  1.00 43.88           C  
ATOM    901  OG1 THR A 110      40.882  20.167  12.985  1.00 54.66           O  
ATOM    902  CG2 THR A 110      41.345  21.981  11.444  1.00 42.57           C  
ATOM    903  N   ASP A 111      40.133  24.750  12.872  1.00 38.70           N  
ATOM    904  CA  ASP A 111      39.517  25.985  12.323  1.00 35.78           C  
ATOM    905  C   ASP A 111      40.641  26.794  11.726  1.00 36.83           C  
ATOM    906  O   ASP A 111      41.817  26.578  12.047  1.00 38.42           O  
ATOM    907  CB  ASP A 111      38.774  26.764  13.425  1.00 32.76           C  
ATOM    908  CG  ASP A 111      37.729  27.782  12.883  1.00 38.47           C  
ATOM    909  OD1 ASP A 111      37.639  27.987  11.631  1.00 41.63           O  
ATOM    910  OD2 ASP A 111      37.019  28.334  13.779  1.00 39.34           O  
ATOM    911  N   SER A 112      40.277  27.691  10.812  1.00 36.91           N  
ATOM    912  CA  SER A 112      41.211  28.624  10.199  1.00 33.84           C  
ATOM    913  C   SER A 112      41.674  29.685  11.184  1.00 36.48           C  
ATOM    914  O   SER A 112      41.100  29.820  12.250  1.00 35.36           O  
ATOM    915  CB  SER A 112      40.536  29.311   9.028  1.00 37.53           C  
ATOM    916  OG  SER A 112      39.472  30.123   9.461  1.00 36.11           O  
ATOM    917  N   THR A 113      42.734  30.415  10.841  1.00 37.50           N  
ATOM    918  CA  THR A 113      43.184  31.582  11.615  0.50 36.96           C  
ATOM    920  C   THR A 113      42.031  32.578  11.793  1.00 35.51           C  
ATOM    921  O   THR A 113      41.764  33.091  12.888  1.00 35.60           O  
ATOM    922  CB  THR A 113      44.389  32.284  10.896  0.50 40.13           C  
ATOM    924  OG1 THR A 113      45.409  31.322  10.586  0.50 43.35           O  
ATOM    926  CG2 THR A 113      44.997  33.370  11.754  0.50 39.10           C  
ATOM    928  N   THR A 114      41.331  32.843  10.696  1.00 33.89           N  
ATOM    929  CA  THR A 114      40.210  33.802  10.751  1.00 33.92           C  
ATOM    930  C   THR A 114      39.066  33.287  11.629  1.00 34.70           C  
ATOM    931  O   THR A 114      38.469  34.027  12.418  1.00 35.07           O  
ATOM    932  CB  THR A 114      39.718  34.138   9.320  1.00 38.78           C  
ATOM    933  OG1 THR A 114      40.866  34.532   8.561  1.00 41.31           O  
ATOM    934  CG2 THR A 114      38.851  35.201   9.362  1.00 39.85           C  
ATOM    935  N   GLY A 115      38.761  32.000  11.529  1.00 35.28           N  
ATOM    936  CA  GLY A 115      37.789  31.390  12.420  1.00 32.28           C  
ATOM    937  C   GLY A 115      38.150  31.422  13.891  1.00 33.48           C  
ATOM    938  O   GLY A 115      37.313  31.758  14.712  1.00 33.17           O  
ATOM    939  N   TRP A 116      39.393  31.161  14.235  1.00 30.75           N  
ATOM    940  CA  TRP A 116      39.823  31.269  15.620  1.00 32.56           C  
ATOM    941  C   TRP A 116      39.767  32.685  16.176  1.00 30.91           C  
ATOM    942  O   TRP A 116      39.394  32.899  17.319  1.00 32.06           O  
ATOM    943  CB  TRP A 116      41.240  30.681  15.810  1.00 33.18           C  
ATOM    944  CG  TRP A 116      41.253  29.170  15.908  1.00 40.47           C  
ATOM    945  CD1 TRP A 116      41.777  28.278  15.003  1.00 39.25           C  
ATOM    946  CD2 TRP A 116      40.703  28.382  16.982  1.00 35.30           C  
ATOM    947  NE1 TRP A 116      41.576  26.983  15.458  1.00 36.98           N  
ATOM    948  CE2 TRP A 116      40.916  27.021  16.654  1.00 37.68           C  
ATOM    949  CE3 TRP A 116      40.048  28.700  18.172  1.00 39.24           C  
ATOM    950  CZ2 TRP A 116      40.509  25.991  17.480  1.00 41.72           C  
ATOM    951  CZ3 TRP A 116      39.651  27.654  19.008  1.00 45.01           C  
ATOM    952  CH2 TRP A 116      39.905  26.319  18.643  1.00 38.37           C  
ATOM    953  N   LEU A 117      40.168  33.658  15.379  1.00 34.68           N  
ATOM    954  CA  LEU A 117      40.029  35.041  15.771  1.00 32.09           C  
ATOM    955  C   LEU A 117      38.567  35.435  16.015  1.00 34.96           C  
ATOM    956  O   LEU A 117      38.258  36.140  16.981  1.00 35.19           O  
ATOM    957  CB  LEU A 117      40.684  35.916  14.734  1.00 32.39           C  
ATOM    958  CG  LEU A 117      42.204  35.921  14.651  1.00 33.43           C  
ATOM    959  CD1 LEU A 117      42.786  36.515  13.340  1.00 36.90           C  
ATOM    960  CD2 LEU A 117      42.864  36.508  15.906  1.00 32.69           C  
ATOM    961  N   LEU A 118      37.667  34.944  15.174  1.00 33.57           N  
ATOM    962  CA  LEU A 118      36.238  35.164  15.439  1.00 34.91           C  
ATOM    963  C   LEU A 118      35.758  34.374  16.675  1.00 36.95           C  
ATOM    964  O   LEU A 118      34.949  34.900  17.479  1.00 34.00           O  
ATOM    965  CB  LEU A 118      35.379  34.821  14.219  1.00 33.01           C  
ATOM    966  CG  LEU A 118      33.843  34.872  14.368  1.00 33.22           C  
ATOM    967  CD1 LEU A 118      33.372  36.250  14.855  1.00 36.76           C  
ATOM    968  CD2 LEU A 118      33.215  34.489  13.013  1.00 35.22           C  
ATOM    969  N   GLU A 119      36.236  33.136  16.876  1.00 33.10           N  
ATOM    970  CA  GLU A 119      35.814  32.334  18.014  1.00 33.92           C  
ATOM    971  C   GLU A 119      36.148  33.034  19.312  1.00 35.75           C  
ATOM    972  O   GLU A 119      35.339  33.036  20.230  1.00 33.61           O  
ATOM    973  CB  GLU A 119      36.470  30.953  17.967  1.00 37.08           C  
ATOM    974  CG  GLU A 119      36.003  29.928  19.024  1.00 36.76           C  
ATOM    975  CD  GLU A 119      36.530  30.215  20.442  1.00 44.10           C  
ATOM    976  OE1 GLU A 119      37.633  30.785  20.555  1.00 44.28           O  
ATOM    977  OE2 GLU A 119      35.875  29.869  21.454  1.00 47.05           O  
ATOM    978  N   ALA A 120      37.295  33.693  19.380  1.00 33.20           N  
ATOM    979  CA  ALA A 120      37.728  34.267  20.640  1.00 34.23           C  
ATOM    980  C   ALA A 120      36.826  35.486  20.857  1.00 36.03           C  
ATOM    981  O   ALA A 120      36.467  35.777  21.988  1.00 32.49           O  
ATOM    982  CB  ALA A 120      39.184  34.672  20.566  1.00 33.33           C  
ATOM    983  N   ALA A 121      36.490  36.208  19.788  1.00 34.98           N  
ATOM    984  CA  ALA A 121      35.575  37.361  19.872  1.00 34.71           C  
ATOM    985  C   ALA A 121      34.183  36.995  20.485  1.00 33.27           C  
ATOM    986  O   ALA A 121      33.712  37.598  21.461  1.00 35.78           O  
ATOM    987  CB  ALA A 121      35.410  38.062  18.485  1.00 36.57           C  
ATOM    988  N   VAL A 122      33.527  36.005  19.906  1.00 32.49           N  
ATOM    989  CA  VAL A 122      32.224  35.591  20.394  1.00 33.88           C  
ATOM    990  C   VAL A 122      32.308  34.950  21.765  1.00 33.73           C  
ATOM    991  O   VAL A 122      31.385  35.076  22.546  1.00 33.80           O  
ATOM    992  CB  VAL A 122      31.447  34.667  19.376  1.00 36.37           C  
ATOM    993  CG1 VAL A 122      31.210  35.429  18.073  1.00 34.99           C  
ATOM    994  CG2 VAL A 122      32.155  33.341  19.099  1.00 32.77           C  
ATOM    995  N   HIS A 123      33.411  34.267  22.080  1.00 32.74           N  
ATOM    996  CA  HIS A 123      33.631  33.774  23.444  1.00 33.46           C  
ATOM    997  C   HIS A 123      33.734  34.911  24.487  1.00 30.95           C  
ATOM    998  O   HIS A 123      33.099  34.881  25.553  1.00 32.48           O  
ATOM    999  CB  HIS A 123      34.887  32.873  23.407  1.00 32.47           C  
ATOM   1000  CG  HIS A 123      35.120  32.108  24.641  1.00 32.80           C  
ATOM   1001  ND1 HIS A 123      36.324  31.517  24.912  1.00 32.62           N  
ATOM   1002  CD2 HIS A 123      34.313  31.840  25.686  1.00 31.93           C  
ATOM   1003  CE1 HIS A 123      36.249  30.911  26.075  1.00 35.88           C  
ATOM   1004  NE2 HIS A 123      35.034  31.088  26.542  1.00 24.97           N  
ATOM   1005  N   LEU A 124      34.389  35.992  24.104  1.00 31.50           N  
ATOM   1006  CA  LEU A 124      34.449  37.188  24.920  1.00 33.25           C  
ATOM   1007  C   LEU A 124      33.058  37.807  25.209  1.00 31.12           C  
ATOM   1008  O   LEU A 124      32.708  38.077  26.390  1.00 32.56           O  
ATOM   1009  CB  LEU A 124      35.391  38.248  24.307  1.00 32.77           C  
ATOM   1010  CG  LEU A 124      35.620  39.493  25.177  1.00 33.84           C  
ATOM   1011  CD1 LEU A 124      36.587  39.203  26.315  1.00 39.47           C  
ATOM   1012  CD2 LEU A 124      36.130  40.668  24.269  1.00 36.64           C  
ATOM   1013  N   TYR A 125      32.251  37.952  24.192  1.00 31.35           N  
ATOM   1014  CA  TYR A 125      30.897  38.504  24.318  1.00 32.70           C  
ATOM   1015  C   TYR A 125      30.004  37.557  25.090  1.00 34.10           C  
ATOM   1016  O   TYR A 125      29.194  38.009  25.870  1.00 34.01           O  
ATOM   1017  CB  TYR A 125      30.324  38.861  22.925  1.00 33.34           C  
ATOM   1018  CG  TYR A 125      30.736  40.265  22.475  1.00 30.42           C  
ATOM   1019  CD1 TYR A 125      31.985  40.474  21.856  1.00 32.28           C  
ATOM   1020  CD2 TYR A 125      29.881  41.332  22.599  1.00 36.53           C  
ATOM   1021  CE1 TYR A 125      32.418  41.723  21.475  1.00 30.55           C  
ATOM   1022  CE2 TYR A 125      30.268  42.592  22.189  1.00 35.73           C  
ATOM   1023  CZ  TYR A 125      31.512  42.777  21.576  1.00 36.35           C  
ATOM   1024  OH  TYR A 125      31.873  44.039  21.176  1.00 37.53           O  
ATOM   1025  N   HIS A 126      30.181  36.245  24.945  1.00 34.38           N  
ATOM   1026  CA  HIS A 126      29.463  35.255  25.785  1.00 30.97           C  
ATOM   1027  C   HIS A 126      29.695  35.525  27.291  1.00 31.19           C  
ATOM   1028  O   HIS A 126      28.767  35.608  28.080  1.00 32.08           O  
ATOM   1029  CB  HIS A 126      29.907  33.836  25.392  1.00 32.85           C  
ATOM   1030  CG  HIS A 126      29.388  32.736  26.285  1.00 34.43           C  
ATOM   1031  ND1 HIS A 126      28.111  32.228  26.169  1.00 40.13           N  
ATOM   1032  CD2 HIS A 126      29.966  32.077  27.319  1.00 35.09           C  
ATOM   1033  CE1 HIS A 126      27.931  31.279  27.079  1.00 40.04           C  
ATOM   1034  NE2 HIS A 126      29.035  31.171  27.802  1.00 37.24           N  
ATOM   1035  N   HIS A 127      30.957  35.631  27.698  1.00 30.75           N  
ATOM   1036  CA  HIS A 127      31.225  35.813  29.084  1.00 31.00           C  
ATOM   1037  C   HIS A 127      31.060  37.228  29.580  1.00 32.97           C  
ATOM   1038  O   HIS A 127      30.772  37.391  30.777  1.00 33.99           O  
ATOM   1039  CB  HIS A 127      32.589  35.264  29.493  1.00 32.20           C  
ATOM   1040  CG  HIS A 127      32.699  33.785  29.380  1.00 28.93           C  
ATOM   1041  ND1 HIS A 127      31.979  32.922  30.181  1.00 31.32           N  
ATOM   1042  CD2 HIS A 127      33.490  33.020  28.606  1.00 30.59           C  
ATOM   1043  CE1 HIS A 127      32.344  31.677  29.885  1.00 33.03           C  
ATOM   1044  NE2 HIS A 127      33.206  31.707  28.879  1.00 28.78           N  
ATOM   1045  N   ARG A 128      31.210  38.250  28.736  1.00 32.88           N  
ATOM   1046  CA  ARG A 128      30.891  39.617  29.150  1.00 32.89           C  
ATOM   1047  C   ARG A 128      29.406  39.668  29.567  1.00 30.05           C  
ATOM   1048  O   ARG A 128      29.008  40.281  30.593  1.00 31.76           O  
ATOM   1049  CB  ARG A 128      31.114  40.583  28.023  1.00 33.52           C  
ATOM   1050  CG  ARG A 128      30.974  42.053  28.452  1.00 35.84           C  
ATOM   1051  CD  ARG A 128      31.015  43.044  27.295  1.00 37.57           C  
ATOM   1052  NE  ARG A 128      29.842  42.901  26.426  1.00 36.02           N  
ATOM   1053  CZ  ARG A 128      29.394  43.849  25.616  1.00 37.88           C  
ATOM   1054  NH1 ARG A 128      30.029  44.996  25.503  1.00 40.26           N  
ATOM   1055  NH2 ARG A 128      28.337  43.597  24.863  1.00 38.13           N  
ATOM   1056  N   SER A 129      28.551  39.014  28.770  1.00 32.40           N  
ATOM   1057  CA  SER A 129      27.113  38.916  29.084  1.00 32.63           C  
ATOM   1058  C   SER A 129      26.877  38.235  30.426  1.00 33.48           C  
ATOM   1059  O   SER A 129      26.045  38.712  31.273  1.00 32.13           O  
ATOM   1060  CB  SER A 129      26.376  38.155  27.984  1.00 32.30           C  
ATOM   1061  OG  SER A 129      24.970  38.264  28.148  1.00 35.61           O  
ATOM   1062  N   GLN A 130      27.579  37.126  30.658  1.00 31.79           N  
ATOM   1063  CA  GLN A 130      27.459  36.410  31.930  1.00 31.72           C  
ATOM   1064  C   GLN A 130      27.779  37.353  33.100  1.00 30.85           C  
ATOM   1065  O   GLN A 130      27.018  37.402  34.109  1.00 33.32           O  
ATOM   1066  CB  GLN A 130      28.435  35.264  31.959  1.00 33.54           C  
ATOM   1067  CG  GLN A 130      28.270  34.336  33.104  1.00 38.54           C  
ATOM   1068  CD  GLN A 130      29.115  33.085  32.953  1.00 40.83           C  
ATOM   1069  OE1 GLN A 130      29.854  32.930  31.983  1.00 35.87           O  
ATOM   1070  NE2 GLN A 130      28.983  32.149  33.924  1.00 40.98           N  
ATOM   1071  N   LEU A 131      28.898  38.075  32.980  1.00 30.88           N  
ATOM   1072  CA  LEU A 131      29.345  38.978  34.058  1.00 32.21           C  
ATOM   1073  C   LEU A 131      28.304  40.040  34.254  1.00 35.22           C  
ATOM   1074  O   LEU A 131      27.938  40.359  35.407  1.00 33.16           O  
ATOM   1075  CB  LEU A 131      30.733  39.603  33.779  1.00 31.52           C  
ATOM   1076  CG  LEU A 131      31.239  40.561  34.876  1.00 31.05           C  
ATOM   1077  CD1 LEU A 131      31.303  39.865  36.306  1.00 37.50           C  
ATOM   1078  CD2 LEU A 131      32.578  41.189  34.389  1.00 36.49           C  
ATOM   1079  N   LEU A 132      27.773  40.563  33.158  1.00 31.22           N  
ATOM   1080  CA  LEU A 132      26.742  41.587  33.271  1.00 35.58           C  
ATOM   1081  C   LEU A 132      25.482  41.045  34.027  1.00 34.71           C  
ATOM   1082  O   LEU A 132      24.907  41.727  34.936  1.00 35.33           O  
ATOM   1083  CB  LEU A 132      26.362  42.080  31.884  1.00 37.48           C  
ATOM   1084  CG  LEU A 132      25.280  43.155  31.771  1.00 42.26           C  
ATOM   1085  CD1 LEU A 132      25.889  44.511  32.046  1.00 55.37           C  
ATOM   1086  CD2 LEU A 132      24.690  43.096  30.324  1.00 44.52           C  
ATOM   1087  N   ASP A 133      25.059  39.839  33.668  1.00 34.91           N  
ATOM   1088  CA  ASP A 133      23.913  39.208  34.346  1.00 34.69           C  
ATOM   1089  C   ASP A 133      24.201  39.018  35.845  1.00 37.44           C  
ATOM   1090  O   ASP A 133      23.326  39.252  36.667  1.00 32.86           O  
ATOM   1091  CB  ASP A 133      23.577  37.851  33.764  1.00 37.99           C  
ATOM   1092  CG  ASP A 133      22.962  37.927  32.389  1.00 46.54           C  
ATOM   1093  OD1 ASP A 133      22.509  39.032  31.976  1.00 45.76           O  
ATOM   1094  OD2 ASP A 133      22.919  36.833  31.731  1.00 43.27           O  
ATOM   1095  N   TYR A 134      25.416  38.605  36.187  1.00 32.72           N  
ATOM   1096  CA  TYR A 134      25.771  38.432  37.577  1.00 32.80           C  
ATOM   1097  C   TYR A 134      25.659  39.754  38.342  1.00 34.67           C  
ATOM   1098  O   TYR A 134      25.116  39.779  39.448  1.00 34.94           O  
ATOM   1099  CB  TYR A 134      27.213  37.984  37.733  1.00 32.23           C  
ATOM   1100  CG  TYR A 134      27.499  36.516  37.528  1.00 30.85           C  
ATOM   1101  CD1 TYR A 134      26.598  35.679  36.892  1.00 36.03           C  
ATOM   1102  CD2 TYR A 134      28.698  35.976  37.967  1.00 42.98           C  
ATOM   1103  CE1 TYR A 134      26.900  34.338  36.666  1.00 33.89           C  
ATOM   1104  CE2 TYR A 134      28.992  34.641  37.782  1.00 38.75           C  
ATOM   1105  CZ  TYR A 134      28.089  33.822  37.138  1.00 39.16           C  
ATOM   1106  OH  TYR A 134      28.403  32.495  36.949  1.00 41.42           O  
ATOM   1107  N   LEU A 135      26.247  40.816  37.789  1.00 32.97           N  
ATOM   1108  CA  LEU A 135      26.265  42.094  38.497  1.00 33.06           C  
ATOM   1109  C   LEU A 135      24.834  42.615  38.618  1.00 30.63           C  
ATOM   1110  O   LEU A 135      24.444  43.071  39.660  1.00 33.19           O  
ATOM   1111  CB  LEU A 135      27.203  43.114  37.801  1.00 32.93           C  
ATOM   1112  CG  LEU A 135      28.704  42.777  37.861  1.00 35.57           C  
ATOM   1113  CD1 LEU A 135      29.540  43.967  37.278  1.00 37.77           C  
ATOM   1114  CD2 LEU A 135      29.240  42.329  39.196  1.00 34.36           C  
ATOM   1115  N   ASN A 136      24.029  42.463  37.572  1.00 30.76           N  
ATOM   1116  CA  ASN A 136      22.618  42.851  37.657  1.00 34.37           C  
ATOM   1117  C   ASN A 136      21.811  41.992  38.640  1.00 33.32           C  
ATOM   1118  O   ASN A 136      20.938  42.508  39.359  1.00 33.89           O  
ATOM   1119  CB  ASN A 136      21.979  42.814  36.279  1.00 33.48           C  
ATOM   1120  CG  ASN A 136      22.331  44.034  35.433  1.00 35.01           C  
ATOM   1121  OD1 ASN A 136      22.540  45.135  35.955  1.00 39.19           O  
ATOM   1122  ND2 ASN A 136      22.406  43.827  34.133  1.00 33.87           N  
ATOM   1123  N   LEU A 137      22.100  40.701  38.708  1.00 31.24           N  
ATOM   1124  CA  LEU A 137      21.546  39.832  39.775  1.00 30.61           C  
ATOM   1125  C   LEU A 137      21.901  40.356  41.177  1.00 31.06           C  
ATOM   1126  O   LEU A 137      21.130  40.215  42.121  1.00 31.73           O  
ATOM   1127  CB  LEU A 137      22.072  38.414  39.657  1.00 33.15           C  
ATOM   1128  CG  LEU A 137      21.349  37.525  38.617  1.00 33.48           C  
ATOM   1129  CD1 LEU A 137      22.134  36.246  38.287  1.00 36.00           C  
ATOM   1130  CD2 LEU A 137      20.007  37.174  39.080  1.00 31.94           C  
ATOM   1131  N   LEU A 138      23.064  41.002  41.289  1.00 28.62           N  
ATOM   1132  CA  LEU A 138      23.530  41.539  42.556  1.00 33.49           C  
ATOM   1133  C   LEU A 138      23.059  42.983  42.789  1.00 33.47           C  
ATOM   1134  O   LEU A 138      23.540  43.638  43.690  1.00 33.64           O  
ATOM   1135  CB  LEU A 138      25.058  41.415  42.642  1.00 31.48           C  
ATOM   1136  CG  LEU A 138      25.614  39.981  42.766  1.00 37.96           C  
ATOM   1137  CD1 LEU A 138      27.156  39.922  42.538  1.00 35.27           C  
ATOM   1138  CD2 LEU A 138      25.249  39.352  44.109  1.00 34.29           C  
ATOM   1139  N   GLY A 139      22.136  43.485  41.970  1.00 33.94           N  
ATOM   1140  CA  GLY A 139      21.561  44.820  42.194  1.00 34.17           C  
ATOM   1141  C   GLY A 139      22.366  45.990  41.672  1.00 32.99           C  
ATOM   1142  O   GLY A 139      22.090  47.120  42.022  1.00 33.45           O  
ATOM   1143  N   TYR A 140      23.323  45.773  40.785  1.00 33.29           N  
ATOM   1144  CA  TYR A 140      24.128  46.879  40.301  1.00 33.65           C  
ATOM   1145  C   TYR A 140      23.380  47.745  39.254  1.00 37.67           C  
ATOM   1146  O   TYR A 140      23.798  48.867  38.968  1.00 39.81           O  
ATOM   1147  CB  TYR A 140      25.408  46.370  39.641  1.00 35.76           C  
ATOM   1148  CG  TYR A 140      26.514  45.891  40.556  1.00 35.20           C  
ATOM   1149  CD1 TYR A 140      26.322  44.850  41.461  1.00 34.71           C  
ATOM   1150  CD2 TYR A 140      27.787  46.452  40.473  1.00 42.77           C  
ATOM   1151  CE1 TYR A 140      27.365  44.399  42.288  1.00 35.46           C  
ATOM   1152  CE2 TYR A 140      28.835  46.009  41.272  1.00 42.44           C  
ATOM   1153  CZ  TYR A 140      28.620  44.977  42.181  1.00 36.69           C  
ATOM   1154  OH  TYR A 140      29.662  44.541  42.964  1.00 40.28           O  
ATOM   1155  N   ASP A 141      22.336  47.216  38.615  1.00 39.31           N  
ATOM   1156  CA  ASP A 141      21.520  48.014  37.687  1.00 42.54           C  
ATOM   1157  C   ASP A 141      22.408  48.724  36.645  1.00 44.92           C  
ATOM   1158  O   ASP A 141      22.377  49.954  36.494  1.00 43.03           O  
ATOM   1159  CB  ASP A 141      20.682  49.031  38.507  1.00 49.00           C  
ATOM   1160  CG  ASP A 141      19.663  49.800  37.662  1.00 56.52           C  
ATOM   1161  OD1 ASP A 141      19.547  49.537  36.443  1.00 63.78           O  
ATOM   1162  OD2 ASP A 141      18.958  50.658  38.247  1.00 57.81           O  
ATOM   1163  N   ILE A 142      23.196  47.948  35.922  1.00 44.32           N  
ATOM   1164  CA  ILE A 142      24.229  48.535  35.034  1.00 46.18           C  
ATOM   1165  C   ILE A 142      23.670  49.335  33.853  1.00 54.72           C  
ATOM   1166  O   ILE A 142      22.802  48.866  33.114  1.00 54.55           O  
ATOM   1167  CB  ILE A 142      25.240  47.463  34.581  1.00 46.46           C  
ATOM   1168  CG1 ILE A 142      26.138  47.116  35.798  1.00 43.13           C  
ATOM   1169  CG2 ILE A 142      26.078  47.905  33.308  1.00 40.45           C  
ATOM   1170  CD1 ILE A 142      26.430  45.708  35.914  1.00 47.80           C  
ATOM   1171  N   LYS A 143      24.189  50.563  33.694  1.00 61.45           N  
ATOM   1172  CA  LYS A 143      23.753  51.494  32.656  1.00 68.16           C  
ATOM   1173  C   LYS A 143      24.927  51.841  31.700  1.00 71.60           C  
ATOM   1174  O   LYS A 143      25.071  52.990  31.268  1.00 74.22           O  
ATOM   1175  CB  LYS A 143      23.176  52.779  33.285  1.00 67.98           C  
ATOM   1176  CG  LYS A 143      22.128  52.589  34.428  1.00 70.46           C  
ATOM   1177  CD  LYS A 143      20.791  52.024  33.942  1.00 66.15           C  
ATOM   1178  N   LEU A 144      25.739  50.838  31.364  1.00 73.81           N  
ATOM   1179  CA  LEU A 144      26.918  50.995  30.489  1.00 74.94           C  
ATOM   1180  C   LEU A 144      26.508  50.679  29.044  1.00 78.22           C  
ATOM   1181  O   LEU A 144      25.904  49.631  28.792  1.00 79.43           O  
ATOM   1182  CB  LEU A 144      28.003  49.998  30.923  1.00 75.84           C  
ATOM   1183  CG  LEU A 144      29.478  50.369  31.043  1.00 74.51           C  
ATOM   1184  CD1 LEU A 144      29.883  50.499  32.526  1.00 65.06           C  
ATOM   1185  CD2 LEU A 144      30.254  49.264  30.394  1.00 69.73           C  
ATOM   1186  N   ASP A 145      26.826  51.556  28.096  1.00 80.25           N  
ATOM   1187  CA  ASP A 145      26.520  51.269  26.691  1.00 80.39           C  
ATOM   1188  C   ASP A 145      27.394  50.091  26.188  1.00 79.05           C  
ATOM   1189  O   ASP A 145      28.608  50.221  26.002  1.00 77.81           O  
ATOM   1190  CB  ASP A 145      26.699  52.526  25.809  1.00 82.69           C  
ATOM   1191  CG  ASP A 145      26.088  52.365  24.397  1.00 85.84           C  
ATOM   1192  OD1 ASP A 145      25.859  51.206  23.955  1.00 96.19           O  
ATOM   1193  OD2 ASP A 145      25.844  53.405  23.723  1.00 96.33           O  
ATOM   1194  N   LEU A 146      26.741  48.953  25.969  1.00 78.36           N  
ATOM   1195  CA  LEU A 146      27.411  47.683  25.635  1.00 78.67           C  
ATOM   1196  C   LEU A 146      27.649  47.482  24.130  1.00 76.64           C  
ATOM   1197  O   LEU A 146      28.415  46.609  23.720  1.00 69.83           O  
ATOM   1198  CB  LEU A 146      26.583  46.499  26.173  1.00 79.44           C  
ATOM   1199  CG  LEU A 146      26.219  46.471  27.666  1.00 74.20           C  
ATOM   1200  CD1 LEU A 146      25.312  45.282  27.878  1.00 70.75           C  
ATOM   1201  CD2 LEU A 146      27.441  46.410  28.578  1.00 61.63           C  
ATOM   1202  N   PHE A 147      26.949  48.272  23.322  1.00 79.22           N  
ATOM   1203  CA  PHE A 147      27.133  48.311  21.877  1.00 81.23           C  
ATOM   1204  C   PHE A 147      27.101  49.787  21.469  1.00 83.55           C  
ATOM   1205  O   PHE A 147      27.396  50.145  20.326  1.00 88.11           O  
ATOM   1206  CB  PHE A 147      26.021  47.520  21.160  1.00 79.73           C  
ATOM   1207  CG  PHE A 147      26.067  46.013  21.397  1.00 82.29           C  
ATOM   1208  CD1 PHE A 147      26.831  45.175  20.561  1.00 78.35           C  
ATOM   1209  CD2 PHE A 147      25.329  45.428  22.448  1.00 76.43           C  
ATOM   1210  CE1 PHE A 147      26.856  43.805  20.777  1.00 69.69           C  
ATOM   1211  CE2 PHE A 147      25.359  44.058  22.665  1.00 63.06           C  
ATOM   1212  CZ  PHE A 147      26.126  43.243  21.840  1.00 69.38           C  
TER    1213      PHE A 147                                                      
END
MOLECULE T0481.pdb
ATOM   1157  N   ASN     5      43.757  48.627  12.993  1.00 48.55           N  
ATOM   1158  CA  ASN     5      43.707  47.221  13.486  1.00 48.66           C  
ATOM   1159  C   ASN     5      42.297  46.854  13.970  1.00 46.10           C  
ATOM   1160  O   ASN     5      41.931  47.131  15.124  1.00 45.32           O  
ATOM   1161  CB  ASN     5      44.739  47.032  14.610  1.00 49.92           C  
ATOM   1162  CG  ASN     5      45.105  45.561  14.854  1.00 51.98           C  
ATOM   1163  OD1 ASN     5      44.378  44.628  14.479  1.00 41.03           O  
ATOM   1164  ND2 ASN     5      46.252  45.360  15.496  1.00 51.86           N  
ATOM   1165  N   GLN     6      41.522  46.221  13.081  1.00 42.89           N  
ATOM   1166  CA  GLN     6      40.122  45.866  13.363  1.00 39.86           C  
ATOM   1167  C   GLN     6      39.972  44.674  14.322  1.00 37.64           C  
ATOM   1168  O   GLN     6      38.948  44.545  14.985  1.00 37.24           O  
ATOM   1169  CB  GLN     6      39.363  45.603  12.059  1.00 39.17           C  
ATOM   1170  N   ILE     7      40.983  43.809  14.403  1.00 34.88           N  
ATOM   1171  CA  ILE     7      40.937  42.694  15.353  1.00 34.40           C  
ATOM   1172  C   ILE     7      41.043  43.194  16.799  1.00 31.45           C  
ATOM   1173  O   ILE     7      40.216  42.843  17.643  1.00 29.10           O  
ATOM   1174  CB  ILE     7      42.038  41.634  15.082  1.00 34.24           C  
ATOM   1175  CG1 ILE     7      41.687  40.792  13.849  1.00 35.88           C  
ATOM   1176  CG2 ILE     7      42.186  40.712  16.271  1.00 34.37           C  
ATOM   1177  CD1 ILE     7      42.783  39.803  13.446  1.00 36.32           C  
ATOM   1178  N   VAL     8      42.071  44.003  17.067  1.00 31.23           N  
ATOM   1179  CA  VAL     8      42.289  44.610  18.384  1.00 29.82           C  
ATOM   1180  C   VAL     8      41.107  45.490  18.755  1.00 29.64           C  
ATOM   1181  O   VAL     8      40.544  45.353  19.832  1.00 30.66           O  
ATOM   1182  CB  VAL     8      43.589  45.453  18.418  1.00 29.55           C  
ATOM   1183  CG1 VAL     8      43.562  46.438  19.575  1.00 30.78           C  
ATOM   1184  CG2 VAL     8      44.817  44.553  18.513  1.00 26.78           C  
ATOM   1185  N   SER     9      40.726  46.377  17.846  1.00 30.09           N  
ATOM   1186  CA  SER     9      39.600  47.287  18.059  1.00 30.85           C  
ATOM   1187  C   SER     9      38.300  46.564  18.423  1.00 29.88           C  
ATOM   1188  O   SER     9      37.633  46.922  19.394  1.00 30.15           O  
ATOM   1189  CB  SER     9      39.382  48.137  16.796  1.00 31.43           C  
ATOM   1190  OG  SER     9      38.309  49.037  16.971  1.00 34.73           O  
ATOM   1191  N   HIS    10      37.946  45.552  17.640  1.00 29.62           N  
ATOM   1192  CA  HIS    10      36.728  44.774  17.872  1.00 29.21           C  
ATOM   1193  C   HIS    10      36.770  43.988  19.188  1.00 27.89           C  
ATOM   1194  O   HIS    10      35.747  43.834  19.863  1.00 27.83           O  
ATOM   1195  CB  HIS    10      36.453  43.833  16.696  1.00 29.11           C  
ATOM   1196  CG  HIS    10      35.127  43.131  16.782  1.00 30.96           C  
ATOM   1197  ND1 HIS    10      34.991  41.773  16.582  1.00 29.81           N  
ATOM   1198  CD2 HIS    10      33.882  43.596  17.055  1.00 32.11           C  
ATOM   1199  CE1 HIS    10      33.723  41.432  16.721  1.00 34.31           C  
ATOM   1200  NE2 HIS    10      33.025  42.520  17.004  1.00 31.48           N  
ATOM   1201  N   PHE    11      37.946  43.490  19.545  1.00 26.50           N  
ATOM   1202  CA  PHE    11      38.144  42.846  20.847  1.00 25.86           C  
ATOM   1203  C   PHE    11      37.899  43.833  22.005  1.00 25.41           C  
ATOM   1204  O   PHE    11      37.131  43.543  22.922  1.00 26.59           O  
ATOM   1205  CB  PHE    11      39.561  42.251  20.931  1.00 25.87           C  
ATOM   1206  CG  PHE    11      39.978  41.854  22.325  1.00 23.85           C  
ATOM   1207  CD1 PHE    11      39.402  40.765  22.948  1.00 23.40           C  
ATOM   1208  CD2 PHE    11      40.940  42.587  23.009  1.00 24.43           C  
ATOM   1209  CE1 PHE    11      39.769  40.403  24.233  1.00 24.62           C  
ATOM   1210  CE2 PHE    11      41.331  42.230  24.298  1.00 26.60           C  
ATOM   1211  CZ  PHE    11      40.751  41.136  24.910  1.00 25.39           C  
ATOM   1212  N   LEU    12      38.558  44.993  21.960  1.00 25.19           N  
ATOM   1213  CA  LEU    12      38.433  46.000  23.024  1.00 24.40           C  
ATOM   1214  C   LEU    12      37.013  46.571  23.154  1.00 24.37           C  
ATOM   1215  O   LEU    12      36.551  46.899  24.244  1.00 23.55           O  
ATOM   1216  CB  LEU    12      39.429  47.127  22.787  1.00 25.08           C  
ATOM   1217  CG  LEU    12      40.903  46.732  22.935  1.00 23.88           C  
ATOM   1218  CD1 LEU    12      41.772  47.927  22.675  1.00 19.99           C  
ATOM   1219  CD2 LEU    12      41.172  46.151  24.314  1.00 17.50           C  
ATOM   1220  N   SER    13      36.345  46.698  22.018  1.00 24.35           N  
ATOM   1221  CA  SER    13      34.937  47.074  21.945  1.00 24.92           C  
ATOM   1222  C   SER    13      34.094  46.327  22.991  1.00 25.13           C  
ATOM   1223  O   SER    13      33.214  46.894  23.629  1.00 27.77           O  
ATOM   1224  CB  SER    13      34.440  46.723  20.541  1.00 25.22           C  
ATOM   1225  OG  SER    13      33.092  47.020  20.376  1.00 26.42           O  
ATOM   1226  N   HIS    14      34.392  45.046  23.150  1.00 24.32           N  
ATOM   1227  CA  HIS    14      33.720  44.177  24.093  1.00 23.44           C  
ATOM   1228  C   HIS    14      34.479  44.063  25.424  1.00 22.45           C  
ATOM   1229  O   HIS    14      33.887  44.226  26.488  1.00 22.95           O  
ATOM   1230  CB  HIS    14      33.528  42.795  23.455  1.00 23.60           C  
ATOM   1231  CG  HIS    14      32.468  42.759  22.397  1.00 22.55           C  
ATOM   1232  ND1 HIS    14      31.123  42.736  22.695  1.00 22.51           N  
ATOM   1233  CD2 HIS    14      32.554  42.716  21.047  1.00 24.07           C  
ATOM   1234  CE1 HIS    14      30.425  42.689  21.575  1.00 22.12           C  
ATOM   1235  NE2 HIS    14      31.270  42.672  20.559  1.00 23.74           N  
ATOM   1236  N   ARG    15      35.782  43.819  25.364  1.00 23.33           N  
ATOM   1237  CA  ARG    15      36.609  43.694  26.581  1.00 23.65           C  
ATOM   1238  C   ARG    15      36.617  44.947  27.474  1.00 24.04           C  
ATOM   1239  O   ARG    15      36.658  44.830  28.696  1.00 25.31           O  
ATOM   1240  CB  ARG    15      38.040  43.267  26.216  1.00 22.98           C  
ATOM   1241  CG  ARG    15      39.061  43.250  27.369  1.00 25.04           C  
ATOM   1242  CD  ARG    15      38.654  42.372  28.575  1.00 23.51           C  
ATOM   1243  NE  ARG    15      38.553  40.961  28.233  1.00 25.26           N  
ATOM   1244  CZ  ARG    15      39.583  40.124  28.141  1.00 29.21           C  
ATOM   1245  NH1 ARG    15      40.828  40.529  28.388  1.00 30.40           N  
ATOM   1246  NH2 ARG    15      39.358  38.857  27.809  1.00 26.91           N  
ATOM   1247  N   ASN    16      36.571  46.142  26.889  1.00 24.45           N  
ATOM   1248  CA  ASN    16      36.470  47.356  27.702  1.00 24.31           C  
ATOM   1249  C   ASN    16      35.182  47.388  28.527  1.00 24.67           C  
ATOM   1250  O   ASN    16      35.152  47.967  29.618  1.00 24.35           O  
ATOM   1251  CB  ASN    16      36.580  48.634  26.848  1.00 23.87           C  
ATOM   1252  CG  ASN    16      37.991  48.873  26.313  1.00 25.17           C  
ATOM   1253  OD1 ASN    16      38.980  48.416  26.887  1.00 27.85           O  
ATOM   1254  ND2 ASN    16      38.085  49.616  25.218  1.00 24.54           N  
ATOM   1255  N   VAL    17      34.112  46.792  28.005  1.00 25.32           N  
ATOM   1256  CA  VAL    17      32.845  46.739  28.750  1.00 25.14           C  
ATOM   1257  C   VAL    17      32.951  45.686  29.871  1.00 25.47           C  
ATOM   1258  O   VAL    17      32.466  45.898  30.980  1.00 24.38           O  
ATOM   1259  CB  VAL    17      31.636  46.485  27.807  1.00 25.11           C  
ATOM   1260  CG1 VAL    17      30.329  46.424  28.590  1.00 23.93           C  
ATOM   1261  CG2 VAL    17      31.567  47.563  26.732  1.00 21.19           C  
ATOM   1262  N   THR    18      33.621  44.570  29.581  1.00 26.85           N  
ATOM   1263  CA  THR    18      33.871  43.517  30.570  1.00 27.43           C  
ATOM   1264  C   THR    18      34.686  44.040  31.750  1.00 28.37           C  
ATOM   1265  O   THR    18      34.401  43.716  32.908  1.00 27.86           O  
ATOM   1266  CB  THR    18      34.631  42.343  29.937  1.00 26.46           C  
ATOM   1267  OG1 THR    18      33.758  41.641  29.047  1.00 28.22           O  
ATOM   1268  CG2 THR    18      35.153  41.393  31.005  1.00 26.76           C  
ATOM   1269  N   ASN    19      35.712  44.830  31.436  1.00 29.46           N  
ATOM   1270  CA  ASN    19      36.583  45.415  32.444  1.00 29.44           C  
ATOM   1271  C   ASN    19      35.877  46.449  33.302  1.00 31.03           C  
ATOM   1272  O   ASN    19      36.120  46.544  34.505  1.00 32.27           O  
ATOM   1273  CB  ASN    19      37.800  46.053  31.781  1.00 28.63           C  
ATOM   1274  CG  ASN    19      38.752  45.038  31.224  1.00 27.67           C  
ATOM   1275  OD1 ASN    19      38.698  43.849  31.561  1.00 29.89           O  
ATOM   1276  ND2 ASN    19      39.631  45.490  30.362  1.00 16.24           N  
ATOM   1277  N   GLU    20      35.009  47.226  32.673  1.00 32.85           N  
ATOM   1278  CA  GLU    20      34.197  48.215  33.378  1.00 34.98           C  
ATOM   1279  C   GLU    20      33.218  47.533  34.338  1.00 32.92           C  
ATOM   1280  O   GLU    20      33.018  47.999  35.451  1.00 35.00           O  
ATOM   1281  CB  GLU    20      33.450  49.089  32.369  1.00 34.33           C  
ATOM   1282  CG  GLU    20      32.885  50.367  32.951  1.00 41.33           C  
ATOM   1283  CD  GLU    20      32.241  51.269  31.906  1.00 41.71           C  
ATOM   1284  OE1 GLU    20      32.529  51.102  30.688  1.00 48.89           O  
ATOM   1285  OE2 GLU    20      31.448  52.149  32.316  1.00 50.11           O  
ATOM   1286  N   LEU    21      32.624  46.426  33.905  1.00 31.28           N  
ATOM   1287  CA  LEU    21      31.700  45.645  34.734  1.00 30.29           C  
ATOM   1288  C   LEU    21      32.414  44.977  35.915  1.00 30.39           C  
ATOM   1289  O   LEU    21      31.860  44.873  37.015  1.00 30.47           O  
ATOM   1290  CB  LEU    21      30.993  44.561  33.892  1.00 29.76           C  
ATOM   1291  CG  LEU    21      29.893  44.963  32.899  1.00 27.66           C  
ATOM   1292  CD1 LEU    21      29.501  43.764  32.026  1.00 22.19           C  
ATOM   1293  CD2 LEU    21      28.660  45.529  33.614  1.00 25.56           C  
ATOM   1294  N   ALA    22      33.635  44.512  35.672  1.00 30.64           N  
ATOM   1295  CA  ALA    22      34.460  43.895  36.710  1.00 31.48           C  
ATOM   1296  C   ALA    22      34.780  44.861  37.856  1.00 32.45           C  
ATOM   1297  O   ALA    22      34.888  44.450  39.016  1.00 31.11           O  
ATOM   1298  CB  ALA    22      35.755  43.354  36.098  1.00 31.19           C  
ATOM   1299  N   GLU    23      34.934  46.138  37.510  1.00 34.47           N  
ATOM   1300  CA  GLU    23      35.214  47.208  38.475  1.00 36.19           C  
ATOM   1301  C   GLU    23      34.053  47.424  39.453  1.00 35.68           C  
ATOM   1302  O   GLU    23      34.267  47.870  40.573  1.00 36.37           O  
ATOM   1303  CB  GLU    23      35.582  48.500  37.711  1.00 36.80           C  
ATOM   1304  CG  GLU    23      34.996  49.826  38.232  1.00 44.97           C  
ATOM   1305  CD  GLU    23      35.795  50.464  39.365  1.00 54.10           C  
ATOM   1306  OE1 GLU    23      37.029  50.243  39.444  1.00 58.36           O  
ATOM   1307  OE2 GLU    23      35.181  51.215  40.160  1.00 55.37           O  
ATOM   1308  N   LYS    24      32.837  47.095  39.020  1.00 35.78           N  
ATOM   1309  CA  LYS    24      31.630  47.243  39.828  1.00 36.00           C  
ATOM   1310  C   LYS    24      31.403  46.089  40.811  1.00 36.32           C  
ATOM   1311  O   LYS    24      30.399  46.071  41.524  1.00 37.08           O  
ATOM   1312  CB  LYS    24      30.411  47.385  38.910  1.00 36.20           C  
ATOM   1313  CG  LYS    24      30.488  48.628  38.038  1.00 37.65           C  
ATOM   1314  CD  LYS    24      29.127  49.070  37.532  1.00 40.50           C  
ATOM   1315  CE  LYS    24      29.157  50.541  37.089  1.00 46.04           C  
ATOM   1316  NZ  LYS    24      30.023  50.741  35.879  1.00 47.21           N  
ATOM   1317  N   ILE    25      32.337  45.138  40.840  1.00 35.88           N  
ATOM   1318  CA  ILE    25      32.294  43.987  41.733  1.00 35.06           C  
ATOM   1319  C   ILE    25      33.129  44.260  42.988  1.00 36.05           C  
ATOM   1320  O   ILE    25      34.364  44.186  42.953  1.00 35.12           O  
ATOM   1321  CB  ILE    25      32.851  42.718  41.022  1.00 34.99           C  
ATOM   1322  CG1 ILE    25      32.047  42.405  39.750  1.00 36.68           C  
ATOM   1323  CG2 ILE    25      32.848  41.515  41.959  1.00 34.29           C  
ATOM   1324  CD1 ILE    25      32.637  41.292  38.907  1.00 33.67           C  
ATOM   1325  N   SER    26      32.457  44.580  44.092  1.00 37.22           N  
ATOM   1326  CA  SER    26      33.128  44.736  45.383  1.00 38.56           C  
ATOM   1327  C   SER    26      33.758  43.410  45.786  1.00 40.35           C  
ATOM   1328  O   SER    26      33.334  42.354  45.310  1.00 41.06           O  
ATOM   1329  CB  SER    26      32.125  45.138  46.459  1.00 38.56           C  
ATOM   1330  OG  SER    26      31.263  44.055  46.775  1.00 37.07           O  
ATOM   1331  N   LYS    27      34.756  43.461  46.666  1.00 41.84           N  
ATOM   1332  CA  LYS    27      35.441  42.247  47.124  1.00 43.21           C  
ATOM   1333  C   LYS    27      34.509  41.312  47.910  1.00 42.45           C  
ATOM   1334  O   LYS    27      34.734  40.103  47.968  1.00 41.33           O  
ATOM   1335  CB  LYS    27      36.707  42.600  47.918  1.00 43.47           C  
ATOM   1336  CG  LYS    27      37.740  43.358  47.071  1.00 45.04           C  
ATOM   1337  CD  LYS    27      39.142  43.329  47.664  1.00 45.26           C  
ATOM   1338  CE  LYS    27      39.954  42.132  47.180  1.00 47.98           C  
ATOM   1339  NZ  LYS    27      40.646  42.396  45.885  1.00 44.46           N  
ATOM   1340  N   ASP    28      33.448  41.865  48.491  1.00 43.17           N  
ATOM   1341  CA  ASP    28      32.423  41.038  49.143  1.00 43.66           C  
ATOM   1342  C   ASP    28      31.589  40.274  48.109  1.00 42.08           C  
ATOM   1343  O   ASP    28      30.981  39.250  48.419  1.00 41.99           O  
ATOM   1344  CB  ASP    28      31.504  41.876  50.056  1.00 44.61           C  
ATOM   1345  CG  ASP    28      32.015  41.950  51.499  1.00 50.08           C  
ATOM   1346  OD1 ASP    28      32.189  40.877  52.115  1.00 52.94           O  
ATOM   1347  OD2 ASP    28      32.229  43.067  52.026  1.00 53.70           O  
ATOM   1348  N   HIS    29      31.575  40.767  46.875  1.00 40.09           N  
ATOM   1349  CA  HIS    29      30.784  40.157  45.813  1.00 38.00           C  
ATOM   1350  C   HIS    29      31.591  39.254  44.869  1.00 35.48           C  
ATOM   1351  O   HIS    29      31.047  38.750  43.891  1.00 34.55           O  
ATOM   1352  CB  HIS    29      30.051  41.241  45.014  1.00 37.73           C  
ATOM   1353  CG  HIS    29      28.769  41.692  45.637  1.00 38.39           C  
ATOM   1354  ND1 HIS    29      28.368  43.010  45.641  1.00 39.31           N  
ATOM   1355  CD2 HIS    29      27.793  40.999  46.267  1.00 39.76           C  
ATOM   1356  CE1 HIS    29      27.201  43.109  46.251  1.00 41.37           C  
ATOM   1357  NE2 HIS    29      26.830  41.903  46.639  1.00 41.73           N  
ATOM   1358  N   TYR    30      32.873  39.052  45.163  1.00 33.70           N  
ATOM   1359  CA  TYR    30      33.706  38.095  44.423  1.00 32.36           C  
ATOM   1360  C   TYR    30      33.079  36.686  44.430  1.00 32.70           C  
ATOM   1361  O   TYR    30      33.074  35.983  43.416  1.00 32.96           O  
ATOM   1362  CB  TYR    30      35.106  38.029  45.044  1.00 31.66           C  
ATOM   1363  CG  TYR    30      36.109  39.075  44.583  1.00 30.06           C  
ATOM   1364  CD1 TYR    30      35.708  40.312  44.111  1.00 29.10           C  
ATOM   1365  CD2 TYR    30      37.483  38.822  44.672  1.00 30.44           C  
ATOM   1366  CE1 TYR    30      36.643  41.265  43.700  1.00 29.51           C  
ATOM   1367  CE2 TYR    30      38.421  39.763  44.272  1.00 29.19           C  
ATOM   1368  CZ  TYR    30      37.999  40.983  43.786  1.00 31.71           C  
ATOM   1369  OH  TYR    30      38.933  41.930  43.389  1.00 31.55           O  
ATOM   1370  N   SER    31      32.546  36.289  45.586  1.00 32.70           N  
ATOM   1371  CA  SER    31      31.925  34.974  45.767  1.00 31.27           C  
ATOM   1372  C   SER    31      30.485  34.902  45.255  1.00 29.76           C  
ATOM   1373  O   SER    31      29.886  33.828  45.261  1.00 29.74           O  
ATOM   1374  CB  SER    31      31.904  34.639  47.255  1.00 31.47           C  
ATOM   1375  OG  SER    31      31.001  35.510  47.929  1.00 31.56           O  
ATOM   1376  N   TYR    32      29.923  36.031  44.826  1.00 29.31           N  
ATOM   1377  CA  TYR    32      28.493  36.105  44.518  1.00 28.85           C  
ATOM   1378  C   TYR    32      28.089  35.149  43.394  1.00 30.14           C  
ATOM   1379  O   TYR    32      28.698  35.128  42.324  1.00 31.63           O  
ATOM   1380  CB  TYR    32      28.054  37.533  44.156  1.00 28.51           C  
ATOM   1381  CG  TYR    32      26.573  37.583  43.859  1.00 28.85           C  
ATOM   1382  CD1 TYR    32      25.640  37.573  44.892  1.00 30.87           C  
ATOM   1383  CD2 TYR    32      26.104  37.564  42.555  1.00 30.04           C  
ATOM   1384  CE1 TYR    32      24.285  37.577  44.632  1.00 31.57           C  
ATOM   1385  CE2 TYR    32      24.743  37.561  42.284  1.00 28.50           C  
ATOM   1386  CZ  TYR    32      23.840  37.567  43.328  1.00 30.20           C  
ATOM   1387  OH  TYR    32      22.491  37.566  43.071  1.00 27.86           O  
ATOM   1388  N   LYS    33      27.062  34.354  43.664  1.00 30.60           N  
ATOM   1389  CA  LYS    33      26.541  33.386  42.716  1.00 30.67           C  
ATOM   1390  C   LYS    33      25.036  33.621  42.611  1.00 29.00           C  
ATOM   1391  O   LYS    33      24.353  33.610  43.634  1.00 27.20           O  
ATOM   1392  CB  LYS    33      26.804  31.963  43.218  1.00 30.54           C  
ATOM   1393  CG  LYS    33      28.261  31.518  43.131  1.00 31.84           C  
ATOM   1394  CD  LYS    33      28.444  30.104  43.651  1.00 32.67           C  
ATOM   1395  CE  LYS    33      29.915  29.685  43.643  1.00 38.32           C  
ATOM   1396  NZ  LYS    33      30.093  28.233  43.927  1.00 35.17           N  
ATOM   1397  N   PRO    34      24.527  33.902  41.397  1.00 27.53           N  
ATOM   1398  CA  PRO    34      23.093  34.023  41.131  1.00 27.92           C  
ATOM   1399  C   PRO    34      22.258  32.808  41.526  1.00 27.42           C  
ATOM   1400  O   PRO    34      21.134  32.971  42.007  1.00 26.94           O  
ATOM   1401  CB  PRO    34      23.043  34.209  39.609  1.00 28.69           C  
ATOM   1402  CG  PRO    34      24.349  34.838  39.276  1.00 28.43           C  
ATOM   1403  CD  PRO    34      25.323  34.197  40.193  1.00 27.34           C  
ATOM   1404  N   ALA    35      22.800  31.615  41.282  1.00 28.20           N  
ATOM   1405  CA  ALA    35      22.192  30.348  41.691  1.00 29.19           C  
ATOM   1406  C   ALA    35      23.291  29.440  42.234  1.00 30.41           C  
ATOM   1407  O   ALA    35      24.477  29.688  41.984  1.00 29.92           O  
ATOM   1408  CB  ALA    35      21.486  29.688  40.515  1.00 27.66           C  
ATOM   1409  N   GLU    36      22.900  28.382  42.949  1.00 31.54           N  
ATOM   1410  CA  GLU    36      23.861  27.475  43.590  1.00 33.38           C  
ATOM   1411  C   GLU    36      24.823  26.807  42.625  1.00 32.55           C  
ATOM   1412  O   GLU    36      25.968  26.559  42.979  1.00 33.40           O  
ATOM   1413  CB  GLU    36      23.150  26.386  44.381  1.00 34.20           C  
ATOM   1414  CG  GLU    36      22.389  26.881  45.598  1.00 37.06           C  
ATOM   1415  CD  GLU    36      22.094  25.766  46.602  1.00 39.82           C  
ATOM   1416  OE1 GLU    36      22.175  24.569  46.227  1.00 44.32           O  
ATOM   1417  OE2 GLU    36      21.794  26.094  47.775  1.00 47.78           O  
ATOM   1418  N   THR    37      24.351  26.510  41.419  1.00 31.80           N  
ATOM   1419  CA  THR    37      25.157  25.853  40.393  1.00 31.56           C  
ATOM   1420  C   THR    37      25.885  26.843  39.474  1.00 32.32           C  
ATOM   1421  O   THR    37      26.457  26.434  38.474  1.00 33.55           O  
ATOM   1422  CB  THR    37      24.262  24.924  39.568  1.00 31.01           C  
ATOM   1423  OG1 THR    37      23.098  25.641  39.152  1.00 31.99           O  
ATOM   1424  CG2 THR    37      23.806  23.726  40.418  1.00 31.00           C  
ATOM   1425  N   SER    38      25.883  28.134  39.826  1.00 32.65           N  
ATOM   1426  CA  SER    38      26.541  29.182  39.021  1.00 31.97           C  
ATOM   1427  C   SER    38      28.004  29.341  39.378  1.00 30.83           C  
ATOM   1428  O   SER    38      28.405  28.993  40.476  1.00 31.30           O  
ATOM   1429  CB  SER    38      25.870  30.550  39.232  1.00 31.46           C  
ATOM   1430  OG  SER    38      24.536  30.548  38.778  1.00 32.46           O  
ATOM   1431  N   MET    39      28.791  29.880  38.446  1.00 30.71           N  
ATOM   1432  CA  MET    39      30.141  30.329  38.764  1.00 28.97           C  
ATOM   1433  C   MET    39      29.976  31.552  39.652  1.00 28.65           C  
ATOM   1434  O   MET    39      28.998  32.284  39.522  1.00 27.14           O  
ATOM   1435  CB  MET    39      30.933  30.734  37.516  1.00 28.74           C  
ATOM   1436  CG  MET    39      31.363  29.598  36.573  1.00 31.41           C  
ATOM   1437  SD  MET    39      32.514  30.228  35.067  0.75 25.74          SE  
ATOM   1438  CE  MET    39      34.264  29.826  35.772  1.00 37.14           C  
ATOM   1439  N   SER    40      30.928  31.768  40.550  1.00 28.71           N  
ATOM   1440  CA  SER    40      30.961  32.977  41.347  1.00 28.93           C  
ATOM   1441  C   SER    40      31.356  34.119  40.422  1.00 29.26           C  
ATOM   1442  O   SER    40      31.856  33.886  39.321  1.00 28.27           O  
ATOM   1443  CB  SER    40      31.977  32.857  42.485  1.00 28.55           C  
ATOM   1444  OG  SER    40      33.300  32.845  41.971  1.00 31.56           O  
ATOM   1445  N   ALA    41      31.141  35.346  40.883  1.00 29.32           N  
ATOM   1446  CA  ALA    41      31.479  36.531  40.109  1.00 28.43           C  
ATOM   1447  C   ALA    41      32.928  36.492  39.643  1.00 28.87           C  
ATOM   1448  O   ALA    41      33.208  36.745  38.475  1.00 29.06           O  
ATOM   1449  CB  ALA    41      31.216  37.789  40.924  1.00 28.00           C  
ATOM   1450  N   GLU    42      33.844  36.156  40.549  1.00 30.19           N  
ATOM   1451  CA  GLU    42      35.266  36.137  40.215  1.00 32.30           C  
ATOM   1452  C   GLU    42      35.669  34.956  39.338  1.00 31.49           C  
ATOM   1453  O   GLU    42      36.549  35.098  38.495  1.00 31.64           O  
ATOM   1454  CB  GLU    42      36.150  36.217  41.468  1.00 32.29           C  
ATOM   1455  CG  GLU    42      36.145  35.016  42.371  1.00 35.81           C  
ATOM   1456  CD  GLU    42      37.144  35.156  43.514  1.00 36.28           C  
ATOM   1457  OE1 GLU    42      38.328  35.484  43.242  1.00 35.57           O  
ATOM   1458  OE2 GLU    42      36.744  34.923  44.680  1.00 43.97           O  
ATOM   1459  N   GLU    43      35.044  33.797  39.532  1.00 30.87           N  
ATOM   1460  CA  GLU    43      35.260  32.661  38.625  1.00 30.39           C  
ATOM   1461  C   GLU    43      34.845  33.040  37.214  1.00 29.35           C  
ATOM   1462  O   GLU    43      35.531  32.703  36.238  1.00 29.22           O  
ATOM   1463  CB  GLU    43      34.467  31.425  39.060  1.00 30.93           C  
ATOM   1464  CG  GLU    43      35.062  30.666  40.239  1.00 32.30           C  
ATOM   1465  CD  GLU    43      34.153  29.551  40.752  1.00 32.16           C  
ATOM   1466  OE1 GLU    43      32.930  29.604  40.535  1.00 35.30           O  
ATOM   1467  OE2 GLU    43      34.667  28.617  41.401  1.00 38.93           O  
ATOM   1468  N   LEU    44      33.722  33.747  37.111  1.00 27.81           N  
ATOM   1469  CA  LEU    44      33.205  34.170  35.813  1.00 27.14           C  
ATOM   1470  C   LEU    44      34.204  35.093  35.145  1.00 26.11           C  
ATOM   1471  O   LEU    44      34.615  34.849  34.019  1.00 26.10           O  
ATOM   1472  CB  LEU    44      31.835  34.853  35.958  1.00 27.33           C  
ATOM   1473  CG  LEU    44      31.197  35.427  34.687  1.00 26.54           C  
ATOM   1474  CD1 LEU    44      31.341  34.484  33.494  1.00 26.87           C  
ATOM   1475  CD2 LEU    44      29.729  35.714  34.941  1.00 25.50           C  
ATOM   1476  N   VAL    45      34.619  36.132  35.865  1.00 26.48           N  
ATOM   1477  CA  VAL    45      35.510  37.144  35.325  1.00 26.04           C  
ATOM   1478  C   VAL    45      36.867  36.552  34.944  1.00 27.08           C  
ATOM   1479  O   VAL    45      37.346  36.802  33.850  1.00 27.54           O  
ATOM   1480  CB  VAL    45      35.683  38.334  36.309  1.00 27.04           C  
ATOM   1481  CG1 VAL    45      36.744  39.312  35.797  1.00 25.46           C  
ATOM   1482  CG2 VAL    45      34.352  39.042  36.521  1.00 23.13           C  
ATOM   1483  N   LYS    46      37.482  35.767  35.827  1.00 28.21           N  
ATOM   1484  CA  LYS    46      38.793  35.155  35.522  1.00 29.00           C  
ATOM   1485  C   LYS    46      38.708  34.265  34.287  1.00 28.55           C  
ATOM   1486  O   LYS    46      39.629  34.250  33.464  1.00 29.07           O  
ATOM   1487  CB  LYS    46      39.324  34.321  36.690  1.00 29.20           C  
ATOM   1488  CG  LYS    46      39.776  35.118  37.886  1.00 31.60           C  
ATOM   1489  CD  LYS    46      40.299  34.197  38.968  1.00 29.66           C  
ATOM   1490  CE  LYS    46      40.389  34.916  40.294  1.00 37.54           C  
ATOM   1491  NZ  LYS    46      40.795  33.997  41.394  1.00 35.65           N  
ATOM   1492  N   HIS    47      37.616  33.505  34.172  1.00 27.91           N  
ATOM   1493  CA  HIS    47      37.432  32.622  33.016  1.00 27.17           C  
ATOM   1494  C   HIS    47      37.379  33.401  31.699  1.00 25.59           C  
ATOM   1495  O   HIS    47      37.956  32.964  30.704  1.00 26.75           O  
ATOM   1496  CB  HIS    47      36.190  31.743  33.159  1.00 27.46           C  
ATOM   1497  CG  HIS    47      35.905  30.922  31.937  1.00 28.87           C  
ATOM   1498  ND1 HIS    47      36.734  29.908  31.515  1.00 32.09           N  
ATOM   1499  CD2 HIS    47      34.908  30.996  31.025  1.00 28.90           C  
ATOM   1500  CE1 HIS    47      36.257  29.387  30.399  1.00 27.52           C  
ATOM   1501  NE2 HIS    47      35.146  30.027  30.083  1.00 28.54           N  
ATOM   1502  N   ILE    48      36.699  34.545  31.701  1.00 25.40           N  
ATOM   1503  CA  ILE    48      36.648  35.436  30.536  1.00 24.70           C  
ATOM   1504  C   ILE    48      38.065  35.852  30.154  1.00 25.30           C  
ATOM   1505  O   ILE    48      38.456  35.765  28.997  1.00 26.11           O  
ATOM   1506  CB  ILE    48      35.781  36.700  30.805  1.00 25.39           C  
ATOM   1507  CG1 ILE    48      34.294  36.324  30.910  1.00 26.97           C  
ATOM   1508  CG2 ILE    48      35.972  37.754  29.707  1.00 21.47           C  
ATOM   1509  CD1 ILE    48      33.372  37.436  31.476  1.00 21.56           C  
ATOM   1510  N   LEU    49      38.837  36.259  31.148  1.00 25.60           N  
ATOM   1511  CA  LEU    49      40.199  36.717  30.947  1.00 24.97           C  
ATOM   1512  C   LEU    49      41.170  35.634  30.482  1.00 25.95           C  
ATOM   1513  O   LEU    49      41.891  35.831  29.502  1.00 27.25           O  
ATOM   1514  CB  LEU    49      40.725  37.337  32.231  1.00 24.59           C  
ATOM   1515  CG  LEU    49      40.077  38.643  32.687  1.00 26.07           C  
ATOM   1516  CD1 LEU    49      40.707  39.082  34.017  1.00 25.43           C  
ATOM   1517  CD2 LEU    49      40.202  39.746  31.632  1.00 21.72           C  
ATOM   1518  N   THR    50      41.206  34.501  31.184  1.00 26.62           N  
ATOM   1519  CA  THR    50      42.139  33.428  30.831  1.00 26.53           C  
ATOM   1520  C   THR    50      41.768  32.721  29.518  1.00 28.19           C  
ATOM   1521  O   THR    50      42.664  32.330  28.753  1.00 29.08           O  
ATOM   1522  CB  THR    50      42.279  32.370  31.958  1.00 26.75           C  
ATOM   1523  OG1 THR    50      41.018  31.734  32.195  1.00 29.27           O  
ATOM   1524  CG2 THR    50      42.785  33.010  33.255  1.00 20.35           C  
ATOM   1525  N   SER    51      40.469  32.568  29.242  1.00 28.56           N  
ATOM   1526  CA  SER    51      40.053  31.808  28.064  1.00 29.13           C  
ATOM   1527  C   SER    51      40.431  32.521  26.777  1.00 28.90           C  
ATOM   1528  O   SER    51      40.940  31.880  25.847  1.00 30.53           O  
ATOM   1529  CB  SER    51      38.557  31.446  28.084  1.00 28.88           C  
ATOM   1530  OG  SER    51      37.727  32.590  28.069  1.00 33.02           O  
ATOM   1531  N   PHE    52      40.194  33.830  26.703  1.00 27.66           N  
ATOM   1532  CA  PHE    52      40.530  34.557  25.483  1.00 27.14           C  
ATOM   1533  C   PHE    52      42.039  34.554  25.296  1.00 27.70           C  
ATOM   1534  O   PHE    52      42.530  34.421  24.178  1.00 28.71           O  
ATOM   1535  CB  PHE    52      40.001  35.993  25.481  1.00 27.08           C  
ATOM   1536  CG  PHE    52      39.811  36.560  24.089  1.00 25.86           C  
ATOM   1537  CD1 PHE    52      40.907  36.795  23.256  1.00 25.78           C  
ATOM   1538  CD2 PHE    52      38.542  36.839  23.608  1.00 23.07           C  
ATOM   1539  CE1 PHE    52      40.725  37.299  21.977  1.00 26.17           C  
ATOM   1540  CE2 PHE    52      38.359  37.351  22.333  1.00 23.04           C  
ATOM   1541  CZ  PHE    52      39.446  37.570  21.514  1.00 23.22           C  
ATOM   1542  N   HIS    53      42.772  34.683  26.394  1.00 28.75           N  
ATOM   1543  CA  HIS    53      44.234  34.689  26.347  1.00 29.87           C  
ATOM   1544  C   HIS    53      44.799  33.336  25.861  1.00 29.22           C  
ATOM   1545  O   HIS    53      45.774  33.303  25.101  1.00 28.96           O  
ATOM   1546  CB  HIS    53      44.812  35.081  27.710  1.00 29.38           C  
ATOM   1547  CG  HIS    53      46.297  35.259  27.699  1.00 32.09           C  
ATOM   1548  ND1 HIS    53      47.161  34.324  28.221  1.00 36.75           N  
ATOM   1549  CD2 HIS    53      47.071  36.250  27.200  1.00 34.27           C  
ATOM   1550  CE1 HIS    53      48.405  34.738  28.056  1.00 36.33           C  
ATOM   1551  NE2 HIS    53      48.377  35.904  27.439  1.00 35.25           N  
ATOM   1552  N   LEU    54      44.175  32.237  26.280  1.00 28.84           N  
ATOM   1553  CA  LEU    54      44.545  30.908  25.787  1.00 29.41           C  
ATOM   1554  C   LEU    54      44.344  30.820  24.271  1.00 29.89           C  
ATOM   1555  O   LEU    54      45.283  30.469  23.530  1.00 28.10           O  
ATOM   1556  CB  LEU    54      43.746  29.812  26.501  1.00 28.57           C  
ATOM   1557  CG  LEU    54      44.049  28.359  26.102  1.00 30.83           C  
ATOM   1558  CD1 LEU    54      45.538  28.026  26.269  1.00 28.39           C  
ATOM   1559  CD2 LEU    54      43.180  27.371  26.890  1.00 30.29           C  
ATOM   1560  N   PHE    55      43.134  31.159  23.817  1.00 30.20           N  
ATOM   1561  CA  PHE    55      42.819  31.153  22.382  1.00 32.29           C  
ATOM   1562  C   PHE    55      43.787  32.023  21.577  1.00 31.95           C  
ATOM   1563  O   PHE    55      44.243  31.620  20.510  1.00 32.57           O  
ATOM   1564  CB  PHE    55      41.398  31.652  22.119  1.00 34.13           C  
ATOM   1565  CG  PHE    55      40.317  30.681  22.505  1.00 36.99           C  
ATOM   1566  CD1 PHE    55      40.343  29.372  22.063  1.00 39.85           C  
ATOM   1567  CD2 PHE    55      39.236  31.104  23.275  1.00 45.14           C  
ATOM   1568  CE1 PHE    55      39.330  28.494  22.403  1.00 44.15           C  
ATOM   1569  CE2 PHE    55      38.220  30.231  23.620  1.00 45.62           C  
ATOM   1570  CZ  PHE    55      38.263  28.923  23.179  1.00 43.03           C  
ATOM   1571  N   ALA    56      44.077  33.221  22.089  1.00 31.31           N  
ATOM   1572  CA  ALA    56      45.030  34.131  21.448  1.00 30.70           C  
ATOM   1573  C   ALA    56      46.421  33.491  21.272  1.00 29.92           C  
ATOM   1574  O   ALA    56      47.059  33.654  20.231  1.00 30.50           O  
ATOM   1575  CB  ALA    56      45.132  35.443  22.241  1.00 30.35           C  
ATOM   1576  N   ASN    57      46.879  32.749  22.274  1.00 30.14           N  
ATOM   1577  CA  ASN    57      48.161  32.034  22.164  1.00 31.35           C  
ATOM   1578  C   ASN    57      48.100  30.807  21.225  1.00 32.06           C  
ATOM   1579  O   ASN    57      49.095  30.465  20.591  1.00 32.88           O  
ATOM   1580  CB  ASN    57      48.708  31.665  23.553  1.00 31.09           C  
ATOM   1581  CG  ASN    57      49.664  32.728  24.110  1.00 33.29           C  
ATOM   1582  OD1 ASN    57      50.701  33.008  23.514  1.00 36.72           O  
ATOM   1583  ND2 ASN    57      49.326  33.305  25.261  1.00 32.00           N  
ATOM   1584  N   VAL    58      46.936  30.166  21.120  1.00 32.60           N  
ATOM   1585  CA  VAL    58      46.760  29.045  20.194  1.00 32.08           C  
ATOM   1586  C   VAL    58      46.876  29.526  18.742  1.00 32.30           C  
ATOM   1587  O   VAL    58      47.545  28.890  17.934  1.00 32.10           O  
ATOM   1588  CB  VAL    58      45.419  28.287  20.433  1.00 31.98           C  
ATOM   1589  CG1 VAL    58      45.237  27.157  19.410  1.00 29.82           C  
ATOM   1590  CG2 VAL    58      45.366  27.727  21.861  1.00 28.52           C  
ATOM   1591  N   ILE    59      46.235  30.650  18.422  1.00 32.76           N  
ATOM   1592  CA  ILE    59      46.363  31.279  17.092  1.00 33.21           C  
ATOM   1593  C   ILE    59      47.797  31.770  16.842  1.00 33.87           C  
ATOM   1594  O   ILE    59      48.332  31.642  15.741  1.00 33.61           O  
ATOM   1595  CB  ILE    59      45.427  32.500  16.938  1.00 33.99           C  
ATOM   1596  CG1 ILE    59      43.950  32.095  17.083  1.00 33.69           C  
ATOM   1597  CG2 ILE    59      45.664  33.206  15.586  1.00 31.95           C  
ATOM   1598  CD1 ILE    59      43.006  33.284  17.176  1.00 32.20           C  
ATOM   1599  N   LYS    60      48.411  32.330  17.872  1.00 35.71           N  
ATOM   1600  CA  LYS    60      49.772  32.840  17.767  1.00 37.57           C  
ATOM   1601  C   LYS    60      50.764  31.721  17.441  1.00 38.24           C  
ATOM   1602  O   LYS    60      51.604  31.872  16.562  1.00 37.60           O  
ATOM   1603  CB  LYS    60      50.174  33.557  19.062  1.00 37.54           C  
ATOM   1604  CG  LYS    60      51.655  33.883  19.189  1.00 36.89           C  
ATOM   1605  CD  LYS    60      51.907  34.811  20.361  1.00 39.39           C  
ATOM   1606  CE  LYS    60      53.381  34.926  20.678  1.00 43.88           C  
ATOM   1607  NZ  LYS    60      53.698  36.138  21.480  1.00 45.53           N  
ATOM   1608  N   GLU    61      50.662  30.603  18.150  1.00 39.86           N  
ATOM   1609  CA  GLU    61      51.580  29.486  17.934  1.00 40.82           C  
ATOM   1610  C   GLU    61      51.197  28.632  16.722  1.00 41.21           C  
ATOM   1611  O   GLU    61      52.065  28.113  16.025  1.00 41.01           O  
ATOM   1612  CB  GLU    61      51.673  28.611  19.193  1.00 40.22           C  
ATOM   1613  CG  GLU    61      52.201  29.330  20.445  1.00 41.09           C  
ATOM   1614  CD  GLU    61      53.587  29.968  20.275  1.00 41.98           C  
ATOM   1615  OE1 GLU    61      54.314  29.626  19.319  1.00 43.56           O  
ATOM   1616  OE2 GLU    61      53.956  30.816  21.114  1.00 41.89           O  
ATOM   1617  N   GLY    62      49.896  28.506  16.472  1.00 42.51           N  
ATOM   1618  CA  GLY    62      49.378  27.596  15.455  1.00 43.05           C  
ATOM   1619  C   GLY    62      49.304  26.169  15.972  1.00 43.55           C  
ATOM   1620  O   GLY    62      48.994  25.252  15.216  1.00 44.20           O  
ATOM   1621  N   ASN    63      49.576  25.996  17.266  1.00 44.07           N  
ATOM   1622  CA  ASN    63      49.674  24.692  17.917  1.00 44.21           C  
ATOM   1623  C   ASN    63      48.667  24.579  19.044  1.00 44.05           C  
ATOM   1624  O   ASN    63      48.103  25.579  19.482  1.00 43.63           O  
ATOM   1625  CB  ASN    63      51.057  24.530  18.552  1.00 43.35           C  
ATOM   1626  CG  ASN    63      52.175  24.755  17.581  1.00 46.03           C  
ATOM   1627  OD1 ASN    63      52.015  24.563  16.380  1.00 56.39           O  
ATOM   1628  ND2 ASN    63      53.329  25.158  18.093  1.00 46.14           N  
ATOM   1629  N   ALA    64      48.497  23.354  19.541  1.00 44.06           N  
ATOM   1630  CA  ALA    64      47.735  23.100  20.759  1.00 43.65           C  
ATOM   1631  C   ALA    64      48.652  23.159  21.986  1.00 42.60           C  
ATOM   1632  O   ALA    64      48.215  22.878  23.100  1.00 42.66           O  
ATOM   1633  CB  ALA    64      47.047  21.750  20.674  1.00 44.16           C  
ATOM   1634  N   SER    65      49.913  23.548  21.778  1.00 41.62           N  
ATOM   1635  CA  SER    65      50.914  23.588  22.848  1.00 40.66           C  
ATOM   1636  C   SER    65      50.624  24.576  23.992  1.00 39.74           C  
ATOM   1637  O   SER    65      50.986  24.293  25.121  1.00 39.46           O  
ATOM   1638  CB  SER    65      52.332  23.802  22.273  1.00 39.86           C  
ATOM   1639  OG  SER    65      52.479  25.053  21.630  1.00 38.52           O  
ATOM   1640  N   PRO    66      49.983  25.731  23.718  1.00 39.50           N  
ATOM   1641  CA  PRO    66      49.632  26.610  24.848  1.00 39.62           C  
ATOM   1642  C   PRO    66      48.674  26.005  25.903  1.00 40.52           C  
ATOM   1643  O   PRO    66      48.529  26.577  26.989  1.00 40.07           O  
ATOM   1644  CB  PRO    66      48.999  27.830  24.163  1.00 39.89           C  
ATOM   1645  CG  PRO    66      49.525  27.792  22.756  1.00 39.12           C  
ATOM   1646  CD  PRO    66      49.599  26.337  22.428  1.00 39.03           C  
ATOM   1647  N   PHE    67      48.033  24.874  25.599  1.00 41.75           N  
ATOM   1648  CA  PHE    67      47.273  24.136  26.617  1.00 43.43           C  
ATOM   1649  C   PHE    67      48.212  23.489  27.643  1.00 44.65           C  
ATOM   1650  O   PHE    67      47.832  23.293  28.801  1.00 44.48           O  
ATOM   1651  CB  PHE    67      46.384  23.053  25.996  1.00 44.15           C  
ATOM   1652  CG  PHE    67      45.455  23.559  24.931  1.00 45.35           C  
ATOM   1653  CD1 PHE    67      44.694  24.703  25.134  1.00 48.97           C  
ATOM   1654  CD2 PHE    67      45.327  22.883  23.728  1.00 47.36           C  
ATOM   1655  CE1 PHE    67      43.834  25.171  24.148  1.00 47.77           C  
ATOM   1656  CE2 PHE    67      44.476  23.353  22.740  1.00 47.83           C  
ATOM   1657  CZ  PHE    67      43.728  24.495  22.955  1.00 44.88           C  
ATOM   1658  N   GLN    68      49.425  23.149  27.209  1.00 46.69           N  
ATOM   1659  CA  GLN    68      50.444  22.560  28.089  1.00 48.37           C  
ATOM   1660  C   GLN    68      50.999  23.583  29.073  1.00 50.08           C  
ATOM   1661  O   GLN    68      51.458  23.216  30.156  1.00 50.91           O  
ATOM   1662  CB  GLN    68      51.607  21.962  27.275  1.00 48.44           C  
ATOM   1663  CG  GLN    68      51.370  20.560  26.709  1.00 49.99           C  
ATOM   1664  CD  GLN    68      50.026  20.407  26.019  1.00 50.43           C  
ATOM   1665  OE1 GLN    68      48.982  20.371  26.673  1.00 50.63           O  
ATOM   1666  NE2 GLN    68      50.047  20.305  24.691  1.00 50.53           N  
ATOM   1667  N   ASN    69      50.974  24.859  28.688  1.00 51.88           N  
ATOM   1668  CA  ASN    69      51.449  25.938  29.552  1.00 53.28           C  
ATOM   1669  C   ASN    69      50.511  26.154  30.740  1.00 54.71           C  
ATOM   1670  O   ASN    69      49.505  26.850  30.618  1.00 54.91           O  
ATOM   1671  CB  ASN    69      51.588  27.240  28.752  1.00 53.14           C  
ATOM   1672  N   LYS    70      50.835  25.536  31.874  1.00 57.03           N  
ATOM   1673  CA  LYS    70      50.099  25.758  33.119  1.00 58.38           C  
ATOM   1674  C   LYS    70      50.589  27.059  33.750  1.00 59.82           C  
ATOM   1675  O   LYS    70      51.596  27.058  34.465  1.00 59.85           O  
ATOM   1676  CB  LYS    70      50.324  24.599  34.092  1.00 58.61           C  
ATOM   1677  N   GLN    71      49.889  28.161  33.473  1.00 61.09           N  
ATOM   1678  CA  GLN    71      50.291  29.486  33.963  1.00 62.37           C  
ATOM   1679  C   GLN    71      49.654  29.793  35.321  1.00 63.43           C  
ATOM   1680  O   GLN    71      48.464  30.126  35.397  1.00 64.18           O  
ATOM   1681  CB  GLN    71      49.910  30.572  32.952  1.00 62.69           C  
ATOM   1682  N   GLU    72      50.451  29.679  36.386  1.00 63.24           N  
ATOM   1683  CA  GLU    72      49.984  29.958  37.746  1.00 62.89           C  
ATOM   1684  C   GLU    72      49.973  31.469  38.008  1.00 62.36           C  
ATOM   1685  O   GLU    72      50.992  32.045  38.403  1.00 62.30           O  
ATOM   1686  CB  GLU    72      50.871  29.246  38.777  1.00 62.86           C  
ATOM   1687  N   GLU    73      48.824  32.106  37.772  1.00 60.95           N  
ATOM   1688  CA  GLU    73      48.670  33.540  38.035  1.00 59.65           C  
ATOM   1689  C   GLU    73      48.477  33.737  39.540  1.00 57.43           C  
ATOM   1690  O   GLU    73      47.552  33.173  40.130  1.00 57.80           O  
ATOM   1691  CB  GLU    73      47.484  34.123  37.250  1.00 60.09           C  
ATOM   1692  CG  GLU    73      47.401  35.662  37.243  1.00 60.77           C  
ATOM   1693  CD  GLU    73      48.532  36.354  36.463  1.00 62.91           C  
ATOM   1694  OE1 GLU    73      49.224  35.689  35.663  1.00 64.78           O  
ATOM   1695  OE2 GLU    73      48.720  37.577  36.645  1.00 61.24           O  
ATOM   1696  N   THR    74      49.361  34.526  40.149  1.00 54.02           N  
ATOM   1697  CA  THR    74      49.358  34.754  41.597  1.00 52.74           C  
ATOM   1698  C   THR    74      48.387  35.863  42.044  1.00 51.44           C  
ATOM   1699  O   THR    74      47.943  35.871  43.196  1.00 51.74           O  
ATOM   1700  CB  THR    74      50.775  35.105  42.101  1.00 52.41           C  
ATOM   1701  N   GLU    75      48.058  36.784  41.135  1.00 49.36           N  
ATOM   1702  CA  GLU    75      47.214  37.939  41.455  1.00 47.02           C  
ATOM   1703  C   GLU    75      45.759  37.533  41.711  1.00 45.84           C  
ATOM   1704  O   GLU    75      45.231  36.654  41.029  1.00 46.17           O  
ATOM   1705  CB  GLU    75      47.283  38.962  40.312  1.00 46.52           C  
ATOM   1706  CG  GLU    75      46.513  40.248  40.573  1.00 44.62           C  
ATOM   1707  CD  GLU    75      47.058  41.016  41.759  1.00 42.04           C  
ATOM   1708  OE1 GLU    75      48.292  41.233  41.800  1.00 33.54           O  
ATOM   1709  OE2 GLU    75      46.253  41.402  42.637  1.00 35.78           O  
ATOM   1710  N   THR    76      45.133  38.178  42.697  1.00 44.18           N  
ATOM   1711  CA  THR    76      43.737  37.915  43.069  1.00 42.84           C  
ATOM   1712  C   THR    76      42.803  39.105  42.845  1.00 41.12           C  
ATOM   1713  O   THR    76      41.591  38.923  42.736  1.00 41.75           O  
ATOM   1714  CB  THR    76      43.627  37.523  44.548  1.00 43.10           C  
ATOM   1715  OG1 THR    76      44.363  38.464  45.345  1.00 44.47           O  
ATOM   1716  CG2 THR    76      44.167  36.111  44.770  1.00 43.34           C  
ATOM   1717  N   ASP    77      43.351  40.318  42.805  1.00 38.64           N  
ATOM   1718  CA  ASP    77      42.547  41.494  42.522  1.00 36.40           C  
ATOM   1719  C   ASP    77      42.053  41.379  41.091  1.00 34.51           C  
ATOM   1720  O   ASP    77      42.855  41.330  40.155  1.00 32.72           O  
ATOM   1721  CB  ASP    77      43.351  42.785  42.726  1.00 36.29           C  
ATOM   1722  CG  ASP    77      42.471  44.032  42.705  1.00 36.98           C  
ATOM   1723  OD1 ASP    77      41.907  44.355  41.639  1.00 32.41           O  
ATOM   1724  OD2 ASP    77      42.349  44.695  43.757  1.00 42.30           O  
ATOM   1725  N   LEU    78      40.728  41.321  40.945  1.00 33.17           N  
ATOM   1726  CA  LEU    78      40.084  41.188  39.644  1.00 31.83           C  
ATOM   1727  C   LEU    78      40.447  42.312  38.690  1.00 30.92           C  
ATOM   1728  O   LEU    78      40.630  42.063  37.501  1.00 30.51           O  
ATOM   1729  CB  LEU    78      38.554  41.136  39.777  1.00 31.06           C  
ATOM   1730  CG  LEU    78      37.884  39.831  40.213  1.00 30.15           C  
ATOM   1731  CD1 LEU    78      36.382  39.991  40.079  1.00 28.75           C  
ATOM   1732  CD2 LEU    78      38.360  38.634  39.408  1.00 26.53           C  
ATOM   1733  N   ASN    79      40.528  43.540  39.205  1.00 31.00           N  
ATOM   1734  CA  ASN    79      40.795  44.709  38.361  1.00 31.40           C  
ATOM   1735  C   ASN    79      42.207  44.677  37.806  1.00 30.64           C  
ATOM   1736  O   ASN    79      42.430  45.047  36.659  1.00 32.32           O  
ATOM   1737  CB  ASN    79      40.519  46.014  39.113  1.00 30.97           C  
ATOM   1738  CG  ASN    79      39.047  46.191  39.445  1.00 32.77           C  
ATOM   1739  OD1 ASN    79      38.169  45.793  38.669  1.00 34.47           O  
ATOM   1740  ND2 ASN    79      38.767  46.792  40.597  1.00 31.40           N  
ATOM   1741  N   VAL    80      43.145  44.198  38.613  1.00 30.86           N  
ATOM   1742  CA  VAL    80      44.527  43.995  38.176  1.00 30.48           C  
ATOM   1743  C   VAL    80      44.626  42.802  37.208  1.00 30.68           C  
ATOM   1744  O   VAL    80      45.369  42.850  36.230  1.00 32.36           O  
ATOM   1745  CB  VAL    80      45.453  43.767  39.378  1.00 30.21           C  
ATOM   1746  CG1 VAL    80      46.886  43.546  38.914  1.00 28.13           C  
ATOM   1747  CG2 VAL    80      45.352  44.942  40.345  1.00 27.39           C  
ATOM   1748  N   LEU    81      43.884  41.731  37.480  1.00 30.58           N  
ATOM   1749  CA  LEU    81      43.817  40.603  36.546  1.00 30.81           C  
ATOM   1750  C   LEU    81      43.247  41.057  35.200  1.00 30.95           C  
ATOM   1751  O   LEU    81      43.794  40.737  34.148  1.00 31.51           O  
ATOM   1752  CB  LEU    81      42.979  39.451  37.110  1.00 30.49           C  
ATOM   1753  CG  LEU    81      43.664  38.568  38.154  1.00 32.45           C  
ATOM   1754  CD1 LEU    81      42.657  37.683  38.888  1.00 28.60           C  
ATOM   1755  CD2 LEU    81      44.748  37.729  37.503  1.00 32.31           C  
ATOM   1756  N   ALA    82      42.162  41.827  35.243  1.00 31.30           N  
ATOM   1757  CA  ALA    82      41.511  42.328  34.029  1.00 29.87           C  
ATOM   1758  C   ALA    82      42.455  43.178  33.184  1.00 29.55           C  
ATOM   1759  O   ALA    82      42.555  42.976  31.975  1.00 29.00           O  
ATOM   1760  CB  ALA    82      40.252  43.108  34.382  1.00 27.98           C  
ATOM   1761  N   LYS    83      43.145  44.114  33.827  1.00 30.62           N  
ATOM   1762  CA  LYS    83      44.095  45.003  33.147  1.00 32.82           C  
ATOM   1763  C   LYS    83      45.278  44.247  32.545  1.00 31.38           C  
ATOM   1764  O   LYS    83      45.603  44.429  31.383  1.00 31.61           O  
ATOM   1765  CB  LYS    83      44.612  46.060  34.122  1.00 33.23           C  
ATOM   1766  CG  LYS    83      45.524  47.089  33.488  1.00 35.47           C  
ATOM   1767  CD  LYS    83      45.840  48.216  34.451  1.00 36.43           C  
ATOM   1768  CE  LYS    83      46.837  49.196  33.841  1.00 42.15           C  
ATOM   1769  NZ  LYS    83      47.235  50.260  34.808  1.00 48.16           N  
ATOM   1770  N   THR    84      45.915  43.410  33.352  1.00 31.31           N  
ATOM   1771  CA  THR    84      47.066  42.615  32.918  1.00 31.31           C  
ATOM   1772  C   THR    84      46.767  41.681  31.742  1.00 30.31           C  
ATOM   1773  O   THR    84      47.511  41.650  30.762  1.00 29.48           O  
ATOM   1774  CB  THR    84      47.595  41.795  34.095  1.00 30.96           C  
ATOM   1775  OG1 THR    84      48.174  42.693  35.047  1.00 32.33           O  
ATOM   1776  CG2 THR    84      48.648  40.779  33.637  1.00 34.24           C  
ATOM   1777  N   TYR    85      45.676  40.927  31.847  1.00 30.38           N  
ATOM   1778  CA  TYR    85      45.284  39.982  30.797  1.00 30.35           C  
ATOM   1779  C   TYR    85      44.820  40.665  29.510  1.00 29.76           C  
ATOM   1780  O   TYR    85      44.976  40.115  28.423  1.00 29.50           O  
ATOM   1781  CB  TYR    85      44.195  39.038  31.306  1.00 31.62           C  
ATOM   1782  CG  TYR    85      44.726  37.797  31.993  1.00 31.20           C  
ATOM   1783  CD1 TYR    85      45.237  36.746  31.245  1.00 32.21           C  
ATOM   1784  CD2 TYR    85      44.680  37.656  33.381  1.00 32.86           C  
ATOM   1785  CE1 TYR    85      45.701  35.590  31.850  1.00 32.84           C  
ATOM   1786  CE2 TYR    85      45.147  36.493  34.003  1.00 32.36           C  
ATOM   1787  CZ  TYR    85      45.657  35.467  33.229  1.00 33.24           C  
ATOM   1788  OH  TYR    85      46.137  34.309  33.811  1.00 34.89           O  
ATOM   1789  N   THR    86      44.235  41.848  29.638  1.00 31.05           N  
ATOM   1790  CA  THR    86      43.815  42.641  28.486  1.00 31.05           C  
ATOM   1791  C   THR    86      45.045  43.122  27.733  1.00 32.15           C  
ATOM   1792  O   THR    86      45.109  42.994  26.512  1.00 32.75           O  
ATOM   1793  CB  THR    86      42.918  43.820  28.928  1.00 30.81           C  
ATOM   1794  OG1 THR    86      41.726  43.284  29.508  1.00 29.76           O  
ATOM   1795  CG2 THR    86      42.532  44.732  27.760  1.00 26.40           C  
ATOM   1796  N   GLU    87      46.025  43.652  28.471  1.00 32.42           N  
ATOM   1797  CA  GLU    87      47.300  44.084  27.899  1.00 33.13           C  
ATOM   1798  C   GLU    87      48.047  42.928  27.211  1.00 31.43           C  
ATOM   1799  O   GLU    87      48.576  43.091  26.114  1.00 30.84           O  
ATOM   1800  CB  GLU    87      48.193  44.737  28.977  1.00 33.57           C  
ATOM   1801  CG  GLU    87      47.674  46.098  29.487  1.00 36.24           C  
ATOM   1802  CD  GLU    87      48.430  46.649  30.705  1.00 36.39           C  
ATOM   1803  OE1 GLU    87      49.213  45.898  31.339  1.00 42.87           O  
ATOM   1804  OE2 GLU    87      48.224  47.844  31.039  1.00 41.68           O  
ATOM   1805  N   LYS    88      48.086  41.769  27.857  1.00 30.05           N  
ATOM   1806  CA  LYS    88      48.724  40.586  27.275  1.00 31.07           C  
ATOM   1807  C   LYS    88      48.015  40.085  26.007  1.00 29.92           C  
ATOM   1808  O   LYS    88      48.669  39.628  25.061  1.00 30.19           O  
ATOM   1809  CB  LYS    88      48.768  39.444  28.295  1.00 31.28           C  
ATOM   1810  CG  LYS    88      49.807  39.588  29.405  1.00 32.74           C  
ATOM   1811  CD  LYS    88      49.487  38.619  30.542  1.00 34.44           C  
ATOM   1812  CE  LYS    88      50.726  38.125  31.283  1.00 39.86           C  
ATOM   1813  NZ  LYS    88      51.268  39.116  32.264  1.00 38.26           N  
ATOM   1814  N   THR    89      46.686  40.150  26.003  1.00 28.30           N  
ATOM   1815  CA  THR    89      45.907  39.659  24.876  1.00 26.91           C  
ATOM   1816  C   THR    89      45.994  40.627  23.697  1.00 26.04           C  
ATOM   1817  O   THR    89      46.155  40.197  22.563  1.00 25.57           O  
ATOM   1818  CB  THR    89      44.432  39.370  25.276  1.00 26.83           C  
ATOM   1819  OG1 THR    89      44.402  38.387  26.321  1.00 26.62           O  
ATOM   1820  CG2 THR    89      43.649  38.837  24.091  1.00 21.94           C  
ATOM   1821  N   VAL    90      45.916  41.928  23.970  1.00 25.73           N  
ATOM   1822  CA  VAL    90      46.100  42.954  22.935  1.00 24.97           C  
ATOM   1823  C   VAL    90      47.491  42.846  22.274  1.00 25.21           C  
ATOM   1824  O   VAL    90      47.625  42.875  21.044  1.00 24.21           O  
ATOM   1825  CB  VAL    90      45.922  44.368  23.530  1.00 26.15           C  
ATOM   1826  CG1 VAL    90      46.342  45.465  22.513  1.00 25.78           C  
ATOM   1827  CG2 VAL    90      44.477  44.564  24.014  1.00 24.53           C  
ATOM   1828  N   ALA    91      48.522  42.690  23.092  1.00 24.60           N  
ATOM   1829  CA  ALA    91      49.883  42.534  22.583  1.00 25.64           C  
ATOM   1830  C   ALA    91      49.993  41.348  21.616  1.00 27.64           C  
ATOM   1831  O   ALA    91      50.684  41.436  20.600  1.00 29.22           O  
ATOM   1832  CB  ALA    91      50.884  42.412  23.746  1.00 24.73           C  
ATOM   1833  N   ILE    92      49.284  40.255  21.896  1.00 29.04           N  
ATOM   1834  CA  ILE    92      49.251  39.131  20.956  1.00 29.11           C  
ATOM   1835  C   ILE    92      48.443  39.481  19.694  1.00 30.76           C  
ATOM   1836  O   ILE    92      48.935  39.307  18.568  1.00 31.05           O  
ATOM   1837  CB  ILE    92      48.682  37.846  21.579  1.00 29.24           C  
ATOM   1838  CG1 ILE    92      49.595  37.340  22.711  1.00 30.86           C  
ATOM   1839  CG2 ILE    92      48.552  36.775  20.506  1.00 23.58           C  
ATOM   1840  CD1 ILE    92      49.028  36.148  23.491  1.00 28.37           C  
ATOM   1841  N   LEU    93      47.221  39.983  19.890  1.00 30.68           N  
ATOM   1842  CA  LEU    93      46.329  40.312  18.782  1.00 31.19           C  
ATOM   1843  C   LEU    93      46.942  41.317  17.798  1.00 33.19           C  
ATOM   1844  O   LEU    93      46.804  41.152  16.584  1.00 32.19           O  
ATOM   1845  CB  LEU    93      44.981  40.836  19.305  1.00 30.38           C  
ATOM   1846  CG  LEU    93      44.072  39.867  20.066  1.00 28.57           C  
ATOM   1847  CD1 LEU    93      42.719  40.515  20.315  1.00 27.89           C  
ATOM   1848  CD2 LEU    93      43.904  38.560  19.325  1.00 24.19           C  
ATOM   1849  N   GLU    94      47.626  42.337  18.330  1.00 35.21           N  
ATOM   1850  CA  GLU    94      48.307  43.369  17.523  1.00 37.43           C  
ATOM   1851  C   GLU    94      49.279  42.824  16.477  1.00 38.02           C  
ATOM   1852  O   GLU    94      49.540  43.469  15.471  1.00 39.24           O  
ATOM   1853  CB  GLU    94      49.157  44.276  18.417  1.00 37.45           C  
ATOM   1854  CG  GLU    94      48.437  45.346  19.215  1.00 39.62           C  
ATOM   1855  CD  GLU    94      49.393  46.060  20.179  1.00 40.91           C  
ATOM   1856  OE1 GLU    94      50.569  45.626  20.285  1.00 44.33           O  
ATOM   1857  OE2 GLU    94      48.981  47.052  20.823  1.00 44.87           O  
ATOM   1858  N   GLN    95      49.868  41.672  16.757  1.00 38.62           N  
ATOM   1859  CA  GLN    95      50.925  41.131  15.921  1.00 39.16           C  
ATOM   1860  C   GLN    95      50.427  40.055  14.970  1.00 39.45           C  
ATOM   1861  O   GLN    95      51.135  39.700  14.038  1.00 40.62           O  
ATOM   1862  CB  GLN    95      52.020  40.554  16.816  1.00 40.08           C  
ATOM   1863  CG  GLN    95      52.579  41.550  17.832  1.00 42.36           C  
ATOM   1864  CD  GLN    95      53.520  42.551  17.202  1.00 46.73           C  
ATOM   1865  OE1 GLN    95      53.167  43.716  16.994  1.00 45.61           O  
ATOM   1866  NE2 GLN    95      54.729  42.096  16.877  1.00 50.68           N  
ATOM   1867  N   LEU    96      49.215  39.540  15.194  1.00 39.81           N  
ATOM   1868  CA  LEU    96      48.690  38.454  14.376  1.00 39.64           C  
ATOM   1869  C   LEU    96      48.600  38.845  12.906  1.00 40.14           C  
ATOM   1870  O   LEU    96      47.997  39.860  12.560  1.00 41.09           O  
ATOM   1871  CB  LEU    96      47.323  37.991  14.884  1.00 40.07           C  
ATOM   1872  CG  LEU    96      47.325  37.192  16.188  1.00 36.48           C  
ATOM   1873  CD1 LEU    96      45.897  36.863  16.590  1.00 34.41           C  
ATOM   1874  CD2 LEU    96      48.160  35.932  16.053  1.00 34.32           C  
ATOM   1875  N   THR    97      49.214  38.020  12.060  1.00 40.77           N  
ATOM   1876  CA  THR    97      49.279  38.234  10.615  1.00 40.51           C  
ATOM   1877  C   THR    97      48.149  37.480   9.901  1.00 40.99           C  
ATOM   1878  O   THR    97      47.577  36.530  10.442  1.00 40.42           O  
ATOM   1879  CB  THR    97      50.644  37.755  10.051  1.00 40.10           C  
ATOM   1880  OG1 THR    97      50.761  36.336  10.198  1.00 40.62           O  
ATOM   1881  CG2 THR    97      51.796  38.419  10.788  1.00 38.60           C  
ATOM   1882  N   GLU    98      47.826  37.916   8.688  1.00 41.70           N  
ATOM   1883  CA  GLU    98      46.781  37.269   7.889  1.00 42.96           C  
ATOM   1884  C   GLU    98      47.103  35.792   7.645  1.00 42.45           C  
ATOM   1885  O   GLU    98      46.204  34.969   7.536  1.00 42.13           O  
ATOM   1886  CB  GLU    98      46.577  38.023   6.565  1.00 43.80           C  
ATOM   1887  CG  GLU    98      45.735  39.297   6.722  1.00 46.73           C  
ATOM   1888  CD  GLU    98      44.267  38.992   6.996  1.00 51.55           C  
ATOM   1889  OE1 GLU    98      43.648  38.291   6.166  1.00 53.83           O  
ATOM   1890  OE2 GLU    98      43.731  39.443   8.037  1.00 53.34           O  
ATOM   1891  N   GLU    99      48.396  35.478   7.588  1.00 42.79           N  
ATOM   1892  CA  GLU    99      48.895  34.105   7.480  1.00 43.72           C  
ATOM   1893  C   GLU    99      48.494  33.277   8.694  1.00 41.44           C  
ATOM   1894  O   GLU    99      48.041  32.136   8.555  1.00 40.91           O  
ATOM   1895  CB  GLU    99      50.427  34.128   7.368  1.00 44.27           C  
ATOM   1896  CG  GLU    99      51.118  32.763   7.344  1.00 47.94           C  
ATOM   1897  CD  GLU    99      52.606  32.854   7.693  1.00 48.92           C  
ATOM   1898  OE1 GLU    99      52.937  33.477   8.732  1.00 61.99           O  
ATOM   1899  OE2 GLU    99      53.440  32.296   6.939  1.00 52.94           O  
ATOM   1900  N   GLN   100      48.693  33.847   9.883  1.00 39.56           N  
ATOM   1901  CA  GLN   100      48.308  33.198  11.140  1.00 37.57           C  
ATOM   1902  C   GLN   100      46.789  33.034  11.271  1.00 35.88           C  
ATOM   1903  O   GLN   100      46.315  32.075  11.865  1.00 34.56           O  
ATOM   1904  CB  GLN   100      48.865  33.972  12.335  1.00 37.95           C  
ATOM   1905  CG  GLN   100      50.361  33.753  12.560  1.00 35.36           C  
ATOM   1906  CD  GLN   100      50.928  34.653  13.650  1.00 37.02           C  
ATOM   1907  OE1 GLN   100      50.688  35.861  13.655  1.00 35.51           O  
ATOM   1908  NE2 GLN   100      51.688  34.064  14.577  1.00 28.77           N  
ATOM   1909  N   LEU   101      46.041  33.973  10.700  1.00 36.17           N  
ATOM   1910  CA  LEU   101      44.583  33.911  10.672  1.00 36.04           C  
ATOM   1911  C   LEU   101      44.073  32.913   9.633  1.00 37.42           C  
ATOM   1912  O   LEU   101      43.082  32.221   9.870  1.00 38.35           O  
ATOM   1913  CB  LEU   101      44.009  35.305  10.394  1.00 35.43           C  
ATOM   1914  CG  LEU   101      44.231  36.320  11.524  1.00 34.17           C  
ATOM   1915  CD1 LEU   101      44.014  37.731  11.053  1.00 35.54           C  
ATOM   1916  CD2 LEU   101      43.314  36.006  12.707  1.00 29.97           C  
ATOM   1917  N   ASP   102      44.753  32.842   8.488  1.00 38.87           N  
ATOM   1918  CA  ASP   102      44.334  31.980   7.378  1.00 39.41           C  
ATOM   1919  C   ASP   102      44.687  30.510   7.582  1.00 39.52           C  
ATOM   1920  O   ASP   102      43.960  29.630   7.119  1.00 40.06           O  
ATOM   1921  CB  ASP   102      44.945  32.476   6.060  1.00 40.18           C  
ATOM   1922  CG  ASP   102      44.274  33.742   5.538  1.00 41.84           C  
ATOM   1923  OD1 ASP   102      43.098  33.969   5.877  1.00 44.15           O  
ATOM   1924  OD2 ASP   102      44.916  34.501   4.776  1.00 44.89           O  
ATOM   1925  N   ARG   103      45.780  30.242   8.288  1.00 39.77           N  
ATOM   1926  CA  ARG   103      46.285  28.875   8.425  1.00 40.80           C  
ATOM   1927  C   ARG   103      45.443  27.996   9.334  1.00 41.55           C  
ATOM   1928  O   ARG   103      44.794  28.468  10.260  1.00 41.57           O  
ATOM   1929  CB  ARG   103      47.731  28.872   8.931  1.00 40.90           C  
ATOM   1930  CG  ARG   103      47.888  29.243  10.392  1.00 42.29           C  
ATOM   1931  CD  ARG   103      49.339  29.471  10.724  1.00 44.86           C  
ATOM   1932  NE  ARG   103      49.550  29.752  12.139  1.00 45.75           N  
ATOM   1933  CZ  ARG   103      50.715  30.125  12.661  1.00 47.88           C  
ATOM   1934  NH1 ARG   103      51.797  30.276  11.895  1.00 46.92           N  
ATOM   1935  NH2 ARG   103      50.802  30.357  13.962  1.00 48.77           N  
ATOM   1936  N   GLU   104      45.500  26.700   9.059  1.00 42.30           N  
ATOM   1937  CA  GLU   104      44.841  25.683   9.859  1.00 42.85           C  
ATOM   1938  C   GLU   104      45.654  25.353  11.112  1.00 41.15           C  
ATOM   1939  O   GLU   104      46.859  25.119  11.035  1.00 40.82           O  
ATOM   1940  CB  GLU   104      44.662  24.412   9.025  1.00 43.55           C  
ATOM   1941  CG  GLU   104      43.506  23.559   9.459  1.00 48.29           C  
ATOM   1942  CD  GLU   104      42.933  22.766   8.320  1.00 54.58           C  
ATOM   1943  OE1 GLU   104      43.648  21.883   7.807  1.00 57.58           O  
ATOM   1944  OE2 GLU   104      41.772  23.036   7.941  1.00 58.33           O  
ATOM   1945  N   ILE   105      44.980  25.348  12.258  1.00 40.26           N  
ATOM   1946  CA  ILE   105      45.561  24.903  13.517  1.00 39.85           C  
ATOM   1947  C   ILE   105      45.102  23.459  13.741  1.00 40.87           C  
ATOM   1948  O   ILE   105      43.896  23.195  13.806  1.00 38.41           O  
ATOM   1949  CB  ILE   105      45.100  25.787  14.698  1.00 39.56           C  
ATOM   1950  CG1 ILE   105      45.389  27.263  14.410  1.00 41.36           C  
ATOM   1951  CG2 ILE   105      45.783  25.371  15.987  1.00 36.65           C  
ATOM   1952  CD1 ILE   105      44.838  28.207  15.451  1.00 38.91           C  
ATOM   1953  N   ASP   106      46.055  22.530  13.838  1.00 43.16           N  
ATOM   1954  CA  ASP   106      45.735  21.110  14.079  1.00 45.33           C  
ATOM   1955  C   ASP   106      45.508  20.819  15.575  1.00 46.30           C  
ATOM   1956  O   ASP   106      46.472  20.721  16.343  1.00 47.07           O  
ATOM   1957  CB  ASP   106      46.851  20.206  13.529  1.00 45.75           C  
ATOM   1958  CG  ASP   106      46.547  18.715  13.689  1.00 48.90           C  
ATOM   1959  OD1 ASP   106      45.436  18.361  14.159  1.00 54.25           O  
ATOM   1960  OD2 ASP   106      47.426  17.896  13.340  1.00 48.22           O  
ATOM   1961  N   LEU   107      44.242  20.665  15.974  1.00 47.64           N  
ATOM   1962  CA  LEU   107      43.881  20.387  17.375  1.00 48.79           C  
ATOM   1963  C   LEU   107      43.225  19.004  17.581  1.00 49.78           C  
ATOM   1964  O   LEU   107      42.345  18.605  16.814  1.00 51.17           O  
ATOM   1965  CB  LEU   107      42.946  21.482  17.904  1.00 48.93           C  
ATOM   1966  CG  LEU   107      43.479  22.915  17.843  1.00 48.72           C  
ATOM   1967  CD1 LEU   107      42.485  23.893  18.457  1.00 47.04           C  
ATOM   1968  CD2 LEU   107      44.823  23.024  18.539  1.00 50.50           C  
ATOM   1969  N   THR   108      43.654  18.293  18.630  1.00 49.87           N  
ATOM   1970  CA  THR   108      43.136  16.954  18.974  1.00 48.10           C  
ATOM   1971  C   THR   108      41.608  16.879  18.933  1.00 48.72           C  
ATOM   1972  O   THR   108      41.034  16.018  18.261  1.00 48.58           O  
ATOM   1973  CB  THR   108      43.602  16.500  20.395  1.00 48.19           C  
ATOM   1974  OG1 THR   108      43.218  17.476  21.378  1.00 40.35           O  
ATOM   1975  CG2 THR   108      45.114  16.291  20.439  1.00 45.16           C  
ATOM   1976  N   LYS   114      40.560  20.285  13.549  1.00 48.83           N  
ATOM   1977  CA  LYS   114      41.339  21.284  12.829  1.00 47.35           C  
ATOM   1978  C   LYS   114      40.493  22.541  12.660  1.00 45.69           C  
ATOM   1979  O   LYS   114      39.291  22.459  12.389  1.00 45.34           O  
ATOM   1980  CB  LYS   114      41.802  20.739  11.475  1.00 46.66           C  
ATOM   1981  N   VAL   115      41.122  23.699  12.841  1.00 42.98           N  
ATOM   1982  CA  VAL   115      40.424  24.983  12.796  1.00 40.69           C  
ATOM   1983  C   VAL   115      41.403  26.064  12.356  1.00 37.96           C  
ATOM   1984  O   VAL   115      42.580  26.010  12.700  1.00 37.13           O  
ATOM   1985  CB  VAL   115      39.827  25.330  14.188  1.00 41.29           C  
ATOM   1986  CG1 VAL   115      40.938  25.423  15.230  1.00 41.11           C  
ATOM   1987  CG2 VAL   115      39.014  26.625  14.141  1.00 41.31           C  
ATOM   1988  N   THR   116      40.924  27.018  11.565  1.00 35.83           N  
ATOM   1989  CA  THR   116      41.747  28.147  11.129  1.00 34.25           C  
ATOM   1990  C   THR   116      41.888  29.156  12.249  1.00 34.16           C  
ATOM   1991  O   THR   116      40.982  29.294  13.064  1.00 34.64           O  
ATOM   1992  CB  THR   116      41.095  28.887   9.978  1.00 34.35           C  
ATOM   1993  OG1 THR   116      39.768  29.268  10.376  1.00 33.55           O  
ATOM   1994  CG2 THR   116      41.045  28.007   8.736  1.00 26.14           C  
ATOM   1995  N   GLY   117      43.000  29.883  12.275  1.00 33.53           N  
ATOM   1996  CA  GLY   117      43.191  30.940  13.265  1.00 32.87           C  
ATOM   1997  C   GLY   117      41.993  31.880  13.316  1.00 32.75           C  
ATOM   1998  O   GLY   117      41.549  32.261  14.400  1.00 32.20           O  
ATOM   1999  N   ARG   118      41.468  32.232  12.139  1.00 33.22           N  
ATOM   2000  CA  ARG   118      40.315  33.129  12.006  1.00 34.94           C  
ATOM   2001  C   ARG   118      39.071  32.565  12.685  1.00 33.27           C  
ATOM   2002  O   ARG   118      38.391  33.268  13.432  1.00 34.97           O  
ATOM   2003  CB  ARG   118      40.008  33.398  10.528  1.00 34.63           C  
ATOM   2004  CG  ARG   118      39.075  34.578  10.287  1.00 38.04           C  
ATOM   2005  CD  ARG   118      38.912  34.917   8.796  1.00 41.22           C  
ATOM   2006  NE  ARG   118      40.200  35.077   8.112  1.00 48.85           N  
ATOM   2007  CZ  ARG   118      41.000  36.138   8.220  1.00 48.59           C  
ATOM   2008  NH1 ARG   118      40.677  37.176   8.988  1.00 49.41           N  
ATOM   2009  NH2 ARG   118      42.145  36.158   7.557  1.00 48.99           N  
ATOM   2010  N   ALA   119      38.770  31.298  12.427  1.00 30.92           N  
ATOM   2011  CA  ALA   119      37.577  30.682  12.994  1.00 29.20           C  
ATOM   2012  C   ALA   119      37.694  30.522  14.527  1.00 28.24           C  
ATOM   2013  O   ALA   119      36.694  30.620  15.245  1.00 27.02           O  
ATOM   2014  CB  ALA   119      37.300  29.361  12.328  1.00 29.59           C  
ATOM   2015  N   LEU   120      38.907  30.297  15.027  1.00 26.93           N  
ATOM   2016  CA  LEU   120      39.125  30.231  16.467  1.00 28.00           C  
ATOM   2017  C   LEU   120      39.018  31.640  17.102  1.00 27.86           C  
ATOM   2018  O   LEU   120      38.633  31.771  18.257  1.00 27.73           O  
ATOM   2019  CB  LEU   120      40.488  29.602  16.779  1.00 29.16           C  
ATOM   2020  CG  LEU   120      40.699  29.065  18.198  1.00 29.75           C  
ATOM   2021  CD1 LEU   120      39.857  27.808  18.433  1.00 35.18           C  
ATOM   2022  CD2 LEU   120      42.165  28.759  18.433  1.00 29.74           C  
ATOM   2023  N   LEU   121      39.359  32.683  16.346  1.00 28.09           N  
ATOM   2024  CA  LEU   121      39.228  34.057  16.832  1.00 27.44           C  
ATOM   2025  C   LEU   121      37.750  34.434  17.007  1.00 28.11           C  
ATOM   2026  O   LEU   121      37.378  35.044  18.004  1.00 28.73           O  
ATOM   2027  CB  LEU   121      39.920  35.041  15.889  1.00 26.16           C  
ATOM   2028  CG  LEU   121      39.829  36.523  16.266  1.00 27.90           C  
ATOM   2029  CD1 LEU   121      40.567  36.780  17.561  1.00 23.80           C  
ATOM   2030  CD2 LEU   121      40.358  37.411  15.134  1.00 27.70           C  
ATOM   2031  N   GLN   122      36.917  34.057  16.039  1.00 28.54           N  
ATOM   2032  CA  GLN   122      35.481  34.314  16.107  1.00 30.48           C  
ATOM   2033  C   GLN   122      34.866  33.560  17.293  1.00 30.29           C  
ATOM   2034  O   GLN   122      33.977  34.061  17.983  1.00 30.33           O  
ATOM   2035  CB  GLN   122      34.788  33.907  14.790  1.00 30.73           C  
ATOM   2036  CG  GLN   122      33.269  33.730  14.930  1.00 34.32           C  
ATOM   2037  CD  GLN   122      32.527  33.691  13.616  1.00 33.25           C  
ATOM   2038  OE1 GLN   122      32.635  34.605  12.807  1.00 42.39           O  
ATOM   2039  NE2 GLN   122      31.721  32.648  13.419  1.00 35.24           N  
ATOM   2040  N   LEU   123      35.343  32.341  17.495  1.00 29.79           N  
ATOM   2041  CA  LEU   123      34.918  31.500  18.594  1.00 30.76           C  
ATOM   2042  C   LEU   123      35.297  32.158  19.938  1.00 30.05           C  
ATOM   2043  O   LEU   123      34.511  32.159  20.881  1.00 28.56           O  
ATOM   2044  CB  LEU   123      35.581  30.124  18.426  1.00 32.64           C  
ATOM   2045  CG  LEU   123      35.088  28.918  19.208  1.00 36.41           C  
ATOM   2046  CD1 LEU   123      35.493  27.647  18.473  1.00 37.74           C  
ATOM   2047  CD2 LEU   123      35.638  28.950  20.633  1.00 37.75           C  
ATOM   2048  N   ALA   124      36.509  32.710  20.008  1.00 29.00           N  
ATOM   2049  CA  ALA   124      36.979  33.433  21.183  1.00 27.92           C  
ATOM   2050  C   ALA   124      36.140  34.689  21.458  1.00 27.85           C  
ATOM   2051  O   ALA   124      35.857  35.030  22.619  1.00 27.75           O  
ATOM   2052  CB  ALA   124      38.437  33.815  20.996  1.00 27.52           C  
ATOM   2053  N   MET   125      35.737  35.368  20.384  1.00 26.51           N  
ATOM   2054  CA  MET   125      34.935  36.579  20.487  1.00 24.50           C  
ATOM   2055  C   MET   125      33.523  36.293  20.949  1.00 23.15           C  
ATOM   2056  O   MET   125      32.950  37.063  21.705  1.00 23.24           O  
ATOM   2057  CB  MET   125      34.872  37.308  19.138  1.00 23.98           C  
ATOM   2058  CG  MET   125      36.151  38.017  18.740  1.00 24.55           C  
ATOM   2059  SD  MET   125      36.568  39.523  19.855  0.75 19.69          SE  
ATOM   2060  CE  MET   125      34.822  40.421  19.829  1.00 27.99           C  
ATOM   2061  N   GLU   126      32.949  35.198  20.472  1.00 22.92           N  
ATOM   2062  CA  GLU   126      31.589  34.833  20.863  1.00 22.67           C  
ATOM   2063  C   GLU   126      31.542  34.327  22.296  1.00 23.28           C  
ATOM   2064  O   GLU   126      30.535  34.500  22.995  1.00 24.32           O  
ATOM   2065  CB  GLU   126      31.017  33.797  19.905  1.00 22.12           C  
ATOM   2066  CG  GLU   126      30.912  34.295  18.466  1.00 19.97           C  
ATOM   2067  CD  GLU   126      30.242  33.303  17.552  1.00 21.02           C  
ATOM   2068  OE1 GLU   126      29.901  32.187  18.004  1.00 25.67           O  
ATOM   2069  OE2 GLU   126      30.029  33.658  16.382  1.00 23.17           O  
ATOM   2070  N   HIS   127      32.637  33.714  22.727  1.00 24.65           N  
ATOM   2071  CA  HIS   127      32.783  33.226  24.099  1.00 25.24           C  
ATOM   2072  C   HIS   127      32.844  34.408  25.069  1.00 24.32           C  
ATOM   2073  O   HIS   127      32.184  34.415  26.118  1.00 24.41           O  
ATOM   2074  CB  HIS   127      34.050  32.389  24.183  1.00 26.17           C  
ATOM   2075  CG  HIS   127      34.235  31.687  25.484  1.00 31.32           C  
ATOM   2076  ND1 HIS   127      33.450  30.626  25.876  1.00 38.61           N  
ATOM   2077  CD2 HIS   127      35.141  31.872  26.470  1.00 36.97           C  
ATOM   2078  CE1 HIS   127      33.861  30.195  27.054  1.00 39.40           C  
ATOM   2079  NE2 HIS   127      34.881  30.938  27.438  1.00 37.60           N  
ATOM   2080  N   GLU   128      33.625  35.417  24.699  1.00 23.98           N  
ATOM   2081  CA  GLU   128      33.678  36.673  25.445  1.00 22.90           C  
ATOM   2082  C   GLU   128      32.285  37.287  25.550  1.00 21.15           C  
ATOM   2083  O   GLU   128      31.845  37.655  26.629  1.00 19.73           O  
ATOM   2084  CB  GLU   128      34.610  37.659  24.747  1.00 22.49           C  
ATOM   2085  CG  GLU   128      34.708  39.049  25.408  1.00 27.83           C  
ATOM   2086  CD  GLU   128      35.846  39.181  26.415  1.00 28.43           C  
ATOM   2087  OE1 GLU   128      36.726  38.301  26.447  1.00 27.93           O  
ATOM   2088  OE2 GLU   128      35.860  40.190  27.156  1.00 30.92           O  
ATOM   2089  N   ILE   129      31.613  37.390  24.410  1.00 20.76           N  
ATOM   2090  CA  ILE   129      30.320  38.058  24.320  1.00 20.58           C  
ATOM   2091  C   ILE   129      29.281  37.312  25.140  1.00 21.24           C  
ATOM   2092  O   ILE   129      28.513  37.931  25.863  1.00 23.67           O  
ATOM   2093  CB  ILE   129      29.858  38.233  22.840  1.00 19.95           C  
ATOM   2094  CG1 ILE   129      30.767  39.241  22.133  1.00 20.52           C  
ATOM   2095  CG2 ILE   129      28.411  38.718  22.786  1.00 19.35           C  
ATOM   2096  CD1 ILE   129      30.746  39.177  20.613  1.00 19.09           C  
ATOM   2097  N   HIS   130      29.288  35.985  25.048  1.00 21.33           N  
ATOM   2098  CA  HIS   130      28.430  35.139  25.878  1.00 19.82           C  
ATOM   2099  C   HIS   130      28.572  35.420  27.373  1.00 20.82           C  
ATOM   2100  O   HIS   130      27.583  35.721  28.048  1.00 20.66           O  
ATOM   2101  CB  HIS   130      28.727  33.658  25.615  1.00 18.93           C  
ATOM   2102  CG  HIS   130      28.027  32.732  26.553  1.00 15.45           C  
ATOM   2103  ND1 HIS   130      26.658  32.550  26.535  1.00 14.36           N  
ATOM   2104  CD2 HIS   130      28.503  31.936  27.536  1.00 13.49           C  
ATOM   2105  CE1 HIS   130      26.323  31.696  27.484  1.00 15.06           C  
ATOM   2106  NE2 HIS   130      27.423  31.317  28.111  1.00 16.03           N  
ATOM   2107  N   HIS   131      29.799  35.303  27.882  1.00 21.96           N  
ATOM   2108  CA  HIS   131      30.080  35.424  29.318  1.00 21.31           C  
ATOM   2109  C   HIS   131      29.957  36.868  29.852  1.00 22.10           C  
ATOM   2110  O   HIS   131      29.656  37.088  31.034  1.00 20.92           O  
ATOM   2111  CB  HIS   131      31.461  34.839  29.643  1.00 21.24           C  
ATOM   2112  CG  HIS   131      31.522  33.343  29.551  1.00 22.99           C  
ATOM   2113  ND1 HIS   131      30.750  32.516  30.340  1.00 25.40           N  
ATOM   2114  CD2 HIS   131      32.274  32.525  28.776  1.00 23.84           C  
ATOM   2115  CE1 HIS   131      31.012  31.255  30.044  1.00 25.83           C  
ATOM   2116  NE2 HIS   131      31.936  31.233  29.101  1.00 26.08           N  
ATOM   2117  N   LYS   132      30.195  37.854  28.993  1.00 23.34           N  
ATOM   2118  CA  LYS   132      29.890  39.237  29.349  1.00 23.59           C  
ATOM   2119  C   LYS   132      28.368  39.353  29.502  1.00 24.59           C  
ATOM   2120  O   LYS   132      27.883  40.077  30.374  1.00 25.72           O  
ATOM   2121  CB  LYS   132      30.450  40.221  28.303  1.00 24.16           C  
ATOM   2122  CG  LYS   132      29.937  41.660  28.425  1.00 22.60           C  
ATOM   2123  CD  LYS   132      30.819  42.673  27.685  1.00 23.82           C  
ATOM   2124  CE  LYS   132      31.003  42.367  26.192  1.00 26.25           C  
ATOM   2125  NZ  LYS   132      29.783  42.581  25.373  1.00 19.16           N  
ATOM   2126  N   GLY   133      27.625  38.625  28.666  1.00 24.94           N  
ATOM   2127  CA  GLY   133      26.167  38.535  28.785  1.00 23.57           C  
ATOM   2128  C   GLY   133      25.738  37.992  30.140  1.00 24.46           C  
ATOM   2129  O   GLY   133      24.797  38.507  30.745  1.00 25.42           O  
ATOM   2130  N   ASN   134      26.421  36.946  30.616  1.00 24.53           N  
ATOM   2131  CA  ASN   134      26.212  36.447  31.981  1.00 23.49           C  
ATOM   2132  C   ASN   134      26.525  37.544  32.981  1.00 23.55           C  
ATOM   2133  O   ASN   134      25.752  37.789  33.899  1.00 23.87           O  
ATOM   2134  CB  ASN   134      27.137  35.279  32.349  1.00 24.25           C  
ATOM   2135  CG  ASN   134      27.000  34.066  31.443  1.00 22.64           C  
ATOM   2136  OD1 ASN   134      27.917  33.259  31.385  1.00 27.65           O  
ATOM   2137  ND2 ASN   134      25.884  33.927  30.755  1.00 22.69           N  
ATOM   2138  N   LEU   135      27.674  38.188  32.797  1.00 23.93           N  
ATOM   2139  CA  LEU   135      28.207  39.140  33.769  1.00 24.06           C  
ATOM   2140  C   LEU   135      27.286  40.331  34.014  1.00 24.23           C  
ATOM   2141  O   LEU   135      27.195  40.795  35.130  1.00 25.52           O  
ATOM   2142  CB  LEU   135      29.599  39.605  33.340  1.00 23.83           C  
ATOM   2143  CG  LEU   135      30.452  40.451  34.291  1.00 24.29           C  
ATOM   2144  CD1 LEU   135      30.640  39.807  35.676  1.00 20.22           C  
ATOM   2145  CD2 LEU   135      31.803  40.685  33.627  1.00 24.00           C  
ATOM   2146  N   PHE   136      26.617  40.814  32.967  1.00 24.58           N  
ATOM   2147  CA  PHE   136      25.647  41.896  33.073  1.00 24.76           C  
ATOM   2148  C   PHE   136      24.547  41.609  34.115  1.00 26.40           C  
ATOM   2149  O   PHE   136      24.153  42.502  34.871  1.00 24.96           O  
ATOM   2150  CB  PHE   136      24.994  42.160  31.714  1.00 25.02           C  
ATOM   2151  CG  PHE   136      25.603  43.297  30.961  1.00 25.69           C  
ATOM   2152  CD1 PHE   136      25.197  44.595  31.219  1.00 27.75           C  
ATOM   2153  CD2 PHE   136      26.590  43.077  29.998  1.00 23.95           C  
ATOM   2154  CE1 PHE   136      25.751  45.656  30.529  1.00 27.50           C  
ATOM   2155  CE2 PHE   136      27.150  44.126  29.303  1.00 22.33           C  
ATOM   2156  CZ  PHE   136      26.732  45.426  29.568  1.00 28.13           C  
ATOM   2157  N   VAL   137      24.049  40.374  34.143  1.00 26.43           N  
ATOM   2158  CA  VAL   137      23.008  40.004  35.098  1.00 25.49           C  
ATOM   2159  C   VAL   137      23.599  39.897  36.506  1.00 26.38           C  
ATOM   2160  O   VAL   137      22.977  40.346  37.462  1.00 27.33           O  
ATOM   2161  CB  VAL   137      22.254  38.714  34.667  1.00 26.90           C  
ATOM   2162  CG1 VAL   137      21.086  38.397  35.632  1.00 22.98           C  
ATOM   2163  CG2 VAL   137      21.726  38.861  33.238  1.00 21.37           C  
ATOM   2164  N   TYR   138      24.814  39.352  36.631  1.00 27.22           N  
ATOM   2165  CA  TYR   138      25.534  39.329  37.921  1.00 27.61           C  
ATOM   2166  C   TYR   138      25.601  40.731  38.527  1.00 28.62           C  
ATOM   2167  O   TYR   138      25.164  40.955  39.664  1.00 30.89           O  
ATOM   2168  CB  TYR   138      26.980  38.813  37.775  1.00 27.23           C  
ATOM   2169  CG  TYR   138      27.175  37.304  37.716  1.00 27.29           C  
ATOM   2170  CD1 TYR   138      26.675  36.558  36.664  1.00 26.10           C  
ATOM   2171  CD2 TYR   138      27.903  36.634  38.695  1.00 29.05           C  
ATOM   2172  CE1 TYR   138      26.872  35.177  36.590  1.00 24.62           C  
ATOM   2173  CE2 TYR   138      28.092  35.252  38.642  1.00 26.24           C  
ATOM   2174  CZ  TYR   138      27.577  34.534  37.582  1.00 26.62           C  
ATOM   2175  OH  TYR   138      27.771  33.174  37.491  1.00 27.21           O  
ATOM   2176  N   VAL   139      26.146  41.666  37.754  1.00 27.99           N  
ATOM   2177  CA  VAL   139      26.404  43.039  38.215  1.00 27.23           C  
ATOM   2178  C   VAL   139      25.129  43.810  38.552  1.00 27.92           C  
ATOM   2179  O   VAL   139      25.086  44.595  39.514  1.00 26.74           O  
ATOM   2180  CB  VAL   139      27.222  43.803  37.156  1.00 28.07           C  
ATOM   2181  CG1 VAL   139      27.307  45.289  37.484  1.00 28.06           C  
ATOM   2182  CG2 VAL   139      28.624  43.174  37.012  1.00 26.48           C  
ATOM   2183  N   ARG   140      24.099  43.592  37.744  1.00 29.05           N  
ATOM   2184  CA  ARG   140      22.773  44.168  37.964  1.00 31.02           C  
ATOM   2185  C   ARG   140      22.193  43.697  39.308  1.00 30.81           C  
ATOM   2186  O   ARG   140      21.591  44.480  40.046  1.00 30.77           O  
ATOM   2187  CB  ARG   140      21.863  43.745  36.804  1.00 32.60           C  
ATOM   2188  CG  ARG   140      20.404  44.195  36.878  1.00 40.15           C  
ATOM   2189  CD  ARG   140      20.154  45.498  36.168  1.00 42.74           C  
ATOM   2190  NE  ARG   140      20.623  45.454  34.785  1.00 44.57           N  
ATOM   2191  CZ  ARG   140      20.631  46.499  33.961  1.00 43.68           C  
ATOM   2192  NH1 ARG   140      20.180  47.690  34.364  1.00 42.68           N  
ATOM   2193  NH2 ARG   140      21.097  46.350  32.724  1.00 47.01           N  
ATOM   2194  N   GLU   141      22.378  42.412  39.606  1.00 31.43           N  
ATOM   2195  CA  GLU   141      21.960  41.809  40.885  1.00 30.94           C  
ATOM   2196  C   GLU   141      22.784  42.249  42.108  1.00 31.18           C  
ATOM   2197  O   GLU   141      22.380  42.019  43.250  1.00 30.01           O  
ATOM   2198  CB  GLU   141      21.989  40.281  40.789  1.00 31.38           C  
ATOM   2199  CG  GLU   141      20.789  39.711  40.078  1.00 29.43           C  
ATOM   2200  CD  GLU   141      20.871  38.218  39.838  1.00 29.00           C  
ATOM   2201  OE1 GLU   141      21.346  37.465  40.720  1.00 24.08           O  
ATOM   2202  OE2 GLU   141      20.434  37.798  38.751  1.00 24.21           O  
ATOM   2203  N   MET   142      23.935  42.872  41.866  1.00 31.32           N  
ATOM   2204  CA  MET   142      24.788  43.379  42.938  1.00 30.72           C  
ATOM   2205  C   MET   142      24.459  44.808  43.371  1.00 32.76           C  
ATOM   2206  O   MET   142      25.194  45.384  44.180  1.00 33.35           O  
ATOM   2207  CB  MET   142      26.247  43.366  42.498  1.00 30.80           C  
ATOM   2208  CG  MET   142      26.791  42.021  42.195  1.00 29.92           C  
ATOM   2209  SD  MET   142      28.615  42.104  41.579  0.75 23.20          SE  
ATOM   2210  CE  MET   142      28.655  43.665  40.756  1.00 18.45           C  
ATOM   2211  N   GLY   143      23.394  45.393  42.822  1.00 33.02           N  
ATOM   2212  CA  GLY   143      22.959  46.714  43.243  1.00 33.47           C  
ATOM   2213  C   GLY   143      23.214  47.819  42.232  1.00 34.81           C  
ATOM   2214  O   GLY   143      22.746  48.940  42.423  1.00 35.09           O  
ATOM   2215  N   HIS   144      23.943  47.516  41.159  1.00 35.68           N  
ATOM   2216  CA  HIS   144      24.277  48.516  40.138  1.00 36.43           C  
ATOM   2217  C   HIS   144      23.212  48.593  39.051  1.00 37.25           C  
ATOM   2218  O   HIS   144      22.838  47.584  38.459  1.00 36.10           O  
ATOM   2219  CB  HIS   144      25.643  48.218  39.538  1.00 36.53           C  
ATOM   2220  CG  HIS   144      26.725  48.147  40.564  1.00 36.63           C  
ATOM   2221  ND1 HIS   144      27.392  49.264  41.015  1.00 34.51           N  
ATOM   2222  CD2 HIS   144      27.217  47.101  41.267  1.00 41.34           C  
ATOM   2223  CE1 HIS   144      28.270  48.906  41.934  1.00 40.77           C  
ATOM   2224  NE2 HIS   144      28.181  47.599  42.111  1.00 42.86           N  
ATOM   2225  N   THR   145      22.720  49.802  38.808  1.00 39.71           N  
ATOM   2226  CA  THR   145      21.653  50.030  37.835  1.00 41.21           C  
ATOM   2227  C   THR   145      22.096  50.853  36.624  1.00 43.96           C  
ATOM   2228  O   THR   145      21.370  50.917  35.626  1.00 45.11           O  
ATOM   2229  CB  THR   145      20.451  50.766  38.477  1.00 40.95           C  
ATOM   2230  OG1 THR   145      20.784  52.148  38.677  1.00 36.83           O  
ATOM   2231  CG2 THR   145      20.050  50.122  39.813  1.00 38.96           C  
ATOM   2232  N   GLU   146      23.260  51.496  36.705  1.00 45.65           N  
ATOM   2233  CA  GLU   146      23.726  52.328  35.604  1.00 47.58           C  
ATOM   2234  C   GLU   146      24.886  51.616  34.924  1.00 46.33           C  
ATOM   2235  O   GLU   146      26.059  51.845  35.238  1.00 48.08           O  
ATOM   2236  CB  GLU   146      24.105  53.725  36.101  1.00 48.88           C  
ATOM   2237  CG  GLU   146      23.685  54.842  35.148  1.00 53.87           C  
ATOM   2238  CD  GLU   146      22.186  54.817  34.818  1.00 59.74           C  
ATOM   2239  OE1 GLU   146      21.360  54.933  35.753  1.00 62.56           O  
ATOM   2240  OE2 GLU   146      21.837  54.686  33.624  1.00 60.00           O  
ATOM   2241  N   LEU   147      24.535  50.731  33.998  1.00 43.13           N  
ATOM   2242  CA  LEU   147      25.511  49.860  33.355  1.00 40.71           C  
ATOM   2243  C   LEU   147      25.797  50.305  31.923  1.00 38.85           C  
ATOM   2244  O   LEU   147      24.917  50.848  31.242  1.00 37.87           O  
ATOM   2245  CB  LEU   147      25.016  48.411  33.365  1.00 40.10           C  
ATOM   2246  CG  LEU   147      24.740  47.799  34.743  1.00 39.60           C  
ATOM   2247  CD1 LEU   147      24.125  46.436  34.588  1.00 38.09           C  
ATOM   2248  CD2 LEU   147      26.011  47.720  35.575  1.00 37.18           C  
ATOM   2249  N   PRO   148      27.036  50.070  31.457  1.00 36.83           N  
ATOM   2250  CA  PRO   148      27.359  50.459  30.092  1.00 35.09           C  
ATOM   2251  C   PRO   148      26.522  49.694  29.079  1.00 32.85           C  
ATOM   2252  O   PRO   148      25.936  48.655  29.407  1.00 32.33           O  
ATOM   2253  CB  PRO   148      28.841  50.080  29.953  1.00 34.78           C  
ATOM   2254  CG  PRO   148      29.096  49.071  31.022  1.00 36.57           C  
ATOM   2255  CD  PRO   148      28.178  49.432  32.143  1.00 37.27           C  
ATOM   2256  N   PHE   149      26.440  50.234  27.871  1.00 30.90           N  
ATOM   2257  CA  PHE   149      25.923  49.487  26.742  1.00 29.22           C  
ATOM   2258  C   PHE   149      26.911  48.343  26.533  1.00 26.36           C  
ATOM   2259  O   PHE   149      28.108  48.498  26.802  1.00 26.92           O  
ATOM   2260  CB  PHE   149      25.825  50.378  25.500  1.00 29.54           C  
ATOM   2261  CG  PHE   149      25.075  49.745  24.365  1.00 31.48           C  
ATOM   2262  CD1 PHE   149      23.731  49.412  24.508  1.00 32.96           C  
ATOM   2263  CD2 PHE   149      25.708  49.468  23.162  1.00 31.91           C  
ATOM   2264  CE1 PHE   149      23.040  48.813  23.475  1.00 33.85           C  
ATOM   2265  CE2 PHE   149      25.017  48.876  22.123  1.00 34.43           C  
ATOM   2266  CZ  PHE   149      23.683  48.546  22.282  1.00 33.21           C  
ATOM   2267  N   TYR   150      26.428  47.209  26.045  1.00 25.14           N  
ATOM   2268  CA  TYR   150      27.236  45.986  26.041  1.00 26.48           C  
ATOM   2269  C   TYR   150      28.453  45.994  25.127  1.00 25.90           C  
ATOM   2270  O   TYR   150      29.319  45.125  25.246  1.00 26.81           O  
ATOM   2271  CB  TYR   150      26.372  44.766  25.751  1.00 27.38           C  
ATOM   2272  CG  TYR   150      25.858  44.654  24.346  1.00 27.41           C  
ATOM   2273  CD1 TYR   150      26.599  44.014  23.357  1.00 26.55           C  
ATOM   2274  CD2 TYR   150      24.599  45.154  24.011  1.00 33.30           C  
ATOM   2275  CE1 TYR   150      26.103  43.901  22.050  1.00 32.66           C  
ATOM   2276  CE2 TYR   150      24.090  45.035  22.725  1.00 34.22           C  
ATOM   2277  CZ  TYR   150      24.845  44.420  21.751  1.00 33.26           C  
ATOM   2278  OH  TYR   150      24.321  44.325  20.489  1.00 36.66           O  
ATOM   2279  N   GLN   151      28.514  46.963  24.224  1.00 25.97           N  
ATOM   2280  CA  GLN   151      29.643  47.114  23.323  1.00 28.02           C  
ATOM   2281  C   GLN   151      29.928  48.601  23.100  1.00 28.27           C  
ATOM   2282  O   GLN   151      29.011  49.379  22.893  1.00 26.65           O  
ATOM   2283  CB  GLN   151      29.326  46.447  21.977  1.00 28.59           C  
ATOM   2284  CG  GLN   151      30.572  46.158  21.157  1.00 31.58           C  
ATOM   2285  CD  GLN   151      30.308  45.843  19.693  1.00 29.46           C  
ATOM   2286  OE1 GLN   151      29.163  45.768  19.260  1.00 34.99           O  
ATOM   2287  NE2 GLN   151      31.381  45.675  18.920  1.00 28.17           N  
ATOM   2288  N   GLN   152      31.196  48.988  23.151  1.00 30.83           N  
ATOM   2289  CA  GLN   152      31.596  50.336  22.767  1.00 33.70           C  
ATOM   2290  C   GLN   152      31.634  50.422  21.243  1.00 36.95           C  
ATOM   2291  O   GLN   152      31.835  49.412  20.563  1.00 37.86           O  
ATOM   2292  CB  GLN   152      32.961  50.684  23.349  1.00 32.47           C  
ATOM   2293  CG  GLN   152      32.965  50.794  24.856  1.00 33.78           C  
ATOM   2294  CD  GLN   152      34.315  51.214  25.424  1.00 35.09           C  
ATOM   2295  OE1 GLN   152      35.319  51.317  24.704  1.00 32.29           O  
ATOM   2296  NE2 GLN   152      34.342  51.450  26.731  1.00 28.38           N  
ATOM   2297  N   ARG   153      31.444  51.622  20.707  1.00 38.84           N  
ATOM   2298  CA  ARG   153      31.447  51.820  19.252  1.00 40.64           C  
ATOM   2299  C   ARG   153      32.858  51.664  18.680  1.00 42.01           C  
ATOM   2300  O   ARG   153      33.351  50.543  18.488  1.00 44.29           O  
ATOM   2301  CB  ARG   153      30.889  53.206  18.903  1.00 39.42           C  
END
