
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  162 ( 1351),  selected  162 , name 2qe9_B
# Molecule2: number of CA atoms  144 ( 1145),  selected  144 , name T0481.pdb
# PARAMETERS: 2qe9_B.T0481.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H   -10_B      -       -           -
LGA    H    -9_B      -       -           -
LGA    H    -8_B      -       -           -
LGA    H    -7_B      -       -           -
LGA    E    -6_B      -       -           -
LGA    N    -5_B      -       -           -
LGA    L    -4_B      -       -           -
LGA    Y    -3_B      -       -           -
LGA    F    -2_B      N       5           #
LGA    Q    -1_B      Q       6          1.631
LGA    G     0_B      -       -           -
LGA    X     1_B      I       7          2.973
LGA    X     2_B      V       8          2.682
LGA    K     3_B      S       9          2.470
LGA    F     4_B      H      10          1.792
LGA    F     5_B      F      11          0.750
LGA    E     6_B      L      12          1.489
LGA    Y     7_B      S      13          0.986
LGA    N     8_B      H      14          2.068
LGA    W     9_B      R      15          2.536
LGA    Q    10_B      N      16          1.348
LGA    V    11_B      V      17          0.908
LGA    R    12_B      T      18          2.161
LGA    D    13_B      N      19          2.257
LGA    Q    14_B      E      20          0.824
LGA    W    15_B      L      21          1.330
LGA    F    16_B      A      22          2.498
LGA    T    17_B      E      23          1.954
LGA    W    18_B      K      24          1.195
LGA    C    19_B      I      25          1.362
LGA    H    20_B      S      26          3.557
LGA    Q    21_B      -       -           -
LGA    L    22_B      -       -           -
LGA    T    23_B      K      27          3.537
LGA    T    24_B      D      28          2.951
LGA    E    25_B      -       -           -
LGA    E    26_B      H      29          2.307
LGA    L    27_B      Y      30          1.807
LGA    L    28_B      S      31          0.875
LGA    K    29_B      Y      32          2.749
LGA    N    30_B      K      33          2.771
LGA    R    31_B      P      34          2.660
LGA    L    32_B      A      35          2.915
LGA    -       -      E      36           -
LGA    G    33_B      T      37           #
LGA    G    34_B      S      38          5.782
LGA    V    35_B      -       -           -
LGA    E    36_B      M      39          2.016
LGA    N    37_B      S      40          1.355
LGA    I    38_B      A      41          0.985
LGA    L    39_B      E      42          0.838
LGA    Y    40_B      E      43          0.725
LGA    T    41_B      L      44          0.634
LGA    L    42_B      V      45          0.525
LGA    F    43_B      K      46          0.244
LGA    H    44_B      H      47          0.268
LGA    I    45_B      I      48          0.379
LGA    I    46_B      L      49          0.670
LGA    D    47_B      T      50          1.032
LGA    V    48_B      S      51          0.394
LGA    E    49_B      F      52          0.749
LGA    Y    50_B      H      53          1.016
LGA    S    51_B      L      54          0.951
LGA    W    52_B      F      55          0.955
LGA    I    53_B      A      56          1.379
LGA    R    54_B      N      57          1.709
LGA    A    55_B      V      58          1.412
LGA    I    56_B      I      59          1.794
LGA    Q    57_B      K      60          2.565
LGA    G    58_B      E      61          2.327
LGA    K    59_B      G      62           -
LGA    -       -      N      63           -
LGA    -       -      A      64           -
LGA    E    60_B      S      65          3.761
LGA    D    61_B      P      66          2.906
LGA    -       -      F      67           -
LGA    -       -      Q      68           -
LGA    I    62_B      N      69          2.088
LGA    A    63_B      K      70          3.572
LGA    V    64_B      Q      71          4.133
LGA    -       -      E      72           -
LGA    Q    65_B      E      73           #
LGA    F    66_B      -       -           -
LGA    A    67_B      -       -           -
LGA    D    68_B      -       -           -
LGA    Y    69_B      T      74           #
LGA    Q    70_B      -       -           -
LGA    T    71_B      -       -           -
LGA    L    72_B      -       -           -
LGA    N    73_B      E      75           #
LGA    K    74_B      T      76          2.316
LGA    V    75_B      D      77          4.434
LGA    -       -      L      78           -
LGA    K    76_B      N      79          2.600
LGA    S    77_B      V      80          2.340
LGA    L    78_B      L      81          2.733
LGA    S    79_B      A      82          3.033
LGA    N    80_B      K      83          3.076
LGA    T    81_B      T      84          3.063
LGA    F    82_B      Y      85          3.449
LGA    R    83_B      T      86          3.539
LGA    T    84_B      E      87          3.817
LGA    E    85_B      K      88          3.514
LGA    I    86_B      T      89          2.203
LGA    I    87_B      V      90          2.417
LGA    D    88_B      A      91          3.079
LGA    V    89_B      I      92          2.233
LGA    L    90_B      L      93          1.589
LGA    Q    91_B      E      94          2.518
LGA    T    92_B      Q      95          2.438
LGA    H    93_B      L      96          1.722
LGA    S    94_B      T      97          3.021
LGA    D    95_B      E      98          2.060
LGA    Q    96_B      E      99          5.849
LGA    I    97_B      Q     100           #
LGA    K    98_B      L     101          3.170
LGA    D    99_B      D     102          2.648
LGA    E   100_B      R     103          1.334
LGA    L   101_B      E     104          1.769
LGA    V   102_B      I     105          2.100
LGA    S   103_B      D     106          3.611
LGA    V   104_B      L     107          3.778
LGA    P   105_B      -       -           -
LGA    W   106_B      -       -           -
LGA    E   107_B      -       -           -
LGA    T   108_B      -       -           -
LGA    G   109_B      -       -           -
LGA    V   110_B      T     108          3.502
LGA    L   111_B      K     114          2.222
LGA    Y   112_B      V     115          1.610
LGA    T   113_B      T     116          0.978
LGA    R   114_B      G     117          0.828
LGA    D   115_B      R     118          0.767
LGA    E   116_B      A     119          1.009
LGA    I   117_B      L     120          1.266
LGA    L   118_B      L     121          0.983
LGA    H   119_B      Q     122          0.679
LGA    H   120_B      L     123          1.200
LGA    I   121_B      A     124          1.299
LGA    I   122_B      M     125          1.162
LGA    A   123_B      E     126          1.214
LGA    H   124_B      H     127          1.135
LGA    E   125_B      E     128          1.298
LGA    I   126_B      I     129          1.509
LGA    H   127_B      H     130          1.001
LGA    H   128_B      H     131          0.776
LGA    I   129_B      K     132          1.100
LGA    G   130_B      G     133          1.024
LGA    Q   131_B      N     134          0.996
LGA    L   132_B      L     135          1.623
LGA    S   133_B      F     136          1.571
LGA    V   134_B      V     137          1.573
LGA    W   135_B      Y     138          2.307
LGA    A   136_B      V     139          2.624
LGA    R   137_B      R     140          2.916
LGA    E   138_B      E     141          2.735
LGA    L   139_B      M     142          3.046
LGA    K   140_B      G     143          3.489
LGA    L   141_B      H     144          2.244
LGA    S   142_B      T     145          1.382
LGA    P   143_B      E     146           #
LGA    V   144_B      L     147          2.596
LGA    S   145_B      P     148          1.740
LGA    A   146_B      F     149          2.990
LGA    -       -      Y     150           -
LGA    S   147_B      Q     151          4.045
LGA    F   148_B      Q     152          3.287
LGA    I   149_B      R     153          3.579
LGA    G   150_B      -       -           -
LGA    R   151_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  162  144    5.0    128    2.35    17.19     60.593     5.233

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.462806 * X  +   0.675593 * Y  +   0.573920 * Z  +  -4.339516
  Y_new =  -0.200977 * X  +   0.550604 * Y  +  -0.810212 * Z  +  36.732769
  Z_new =  -0.863376 * X  +  -0.490316 * Y  +  -0.119044 * Z  +  16.660769 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.808978    1.332614  [ DEG:  -103.6468     76.3532 ]
  Theta =   1.041924    2.099669  [ DEG:    59.6978    120.3022 ]
  Phi   =  -2.731907    0.409685  [ DEG:  -156.5268     23.4732 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qe9_B                                        
REMARK     2: T0481.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qe9_B.T0481.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  162  144   5.0  128   2.35   17.19  60.593
REMARK  ---------------------------------------------------------- 
MOLECULE 2qe9_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-JUN-07   2QE9              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN BSU10800                 
TITLE    2 (YP_054576.1) FROM BACILLUS SUBTILIS AT 1.90 A RESOLUTION            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN YIZA;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: YP_054576.1, YIZA, YUCC, BSU10800;                             
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_054576.1, UNCHARACTERIZED PROTEIN BSU10800, STRUCTURAL             
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   10-JUL-07 2QE9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN                 
JRNL        TITL 2 BSU10800 (YP_054576.1) FROM BACILLUS SUBTILIS AT             
JRNL        TITL 3 1.90 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2QE9 A    1   159  UNP    Q7WY73   YIZA_BACSU       1    159             
DBREF  2QE9 B    1   159  UNP    Q7WY73   YIZA_BACSU       1    159             
SEQRES   1 A  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  178  ASN LEU TYR PHE GLN GLY MSE MSE LYS PHE PHE GLU TYR          
SEQRES   3 A  178  ASN TRP GLN VAL ARG ASP GLN TRP PHE THR TRP CYS HIS          
SEQRES   4 A  178  GLN LEU THR THR GLU GLU LEU LEU LYS ASN ARG LEU GLY          
SEQRES   5 A  178  GLY VAL GLU ASN ILE LEU TYR THR LEU PHE HIS ILE ILE          
SEQRES   6 A  178  ASP VAL GLU TYR SER TRP ILE ARG ALA ILE GLN GLY LYS          
SEQRES   7 A  178  GLU ASP ILE ALA VAL GLN PHE ALA ASP TYR GLN THR LEU          
SEQRES   8 A  178  ASN LYS VAL LYS SER LEU SER ASN THR PHE ARG THR GLU          
SEQRES   9 A  178  ILE ILE ASP VAL LEU GLN THR HIS SER ASP GLN ILE LYS          
SEQRES  10 A  178  ASP GLU LEU VAL SER VAL PRO TRP GLU THR GLY VAL LEU          
SEQRES  11 A  178  TYR THR ARG ASP GLU ILE LEU HIS HIS ILE ILE ALA HIS          
SEQRES  12 A  178  GLU ILE HIS HIS ILE GLY GLN LEU SER VAL TRP ALA ARG          
SEQRES  13 A  178  GLU LEU LYS LEU SER PRO VAL SER ALA SER PHE ILE GLY          
SEQRES  14 A  178  ARG THR LEU LYS PRO ILE HIS SER TYR                          
SEQRES   1 B  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  178  ASN LEU TYR PHE GLN GLY MSE MSE LYS PHE PHE GLU TYR          
SEQRES   3 B  178  ASN TRP GLN VAL ARG ASP GLN TRP PHE THR TRP CYS HIS          
SEQRES   4 B  178  GLN LEU THR THR GLU GLU LEU LEU LYS ASN ARG LEU GLY          
SEQRES   5 B  178  GLY VAL GLU ASN ILE LEU TYR THR LEU PHE HIS ILE ILE          
SEQRES   6 B  178  ASP VAL GLU TYR SER TRP ILE ARG ALA ILE GLN GLY LYS          
SEQRES   7 B  178  GLU ASP ILE ALA VAL GLN PHE ALA ASP TYR GLN THR LEU          
SEQRES   8 B  178  ASN LYS VAL LYS SER LEU SER ASN THR PHE ARG THR GLU          
SEQRES   9 B  178  ILE ILE ASP VAL LEU GLN THR HIS SER ASP GLN ILE LYS          
SEQRES  10 B  178  ASP GLU LEU VAL SER VAL PRO TRP GLU THR GLY VAL LEU          
SEQRES  11 B  178  TYR THR ARG ASP GLU ILE LEU HIS HIS ILE ILE ALA HIS          
SEQRES  12 B  178  GLU ILE HIS HIS ILE GLY GLN LEU SER VAL TRP ALA ARG          
SEQRES  13 B  178  GLU LEU LYS LEU SER PRO VAL SER ALA SER PHE ILE GLY          
SEQRES  14 B  178  ARG THR LEU LYS PRO ILE HIS SER TYR                          
HET    MSE  A   1       8                                                       
HET    MSE  A   2       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   2       8                                                       
HET     NI  A 200       1                                                       
HET     NI  B 200       1                                                       
HET    CIT      1      13                                                       
HET    CIT      2      13                                                       
HET    EDO      3       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     CIT CITRIC ACID                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3   NI    2(NI 2+)                                                     
FORMUL   5  CIT    2(C6 H8 O7)                                                  
FORMUL   7  EDO    C2 H6 O2                                                     
FORMUL   8  HOH   *235(H2 O)                                                    
CRYST1   53.184   53.184  251.364  90.00  90.00  90.00 P 41 21 2    16          
ATOM   1375  N   HIS B -10      59.334  46.548   4.387  1.00 57.05           N  
ATOM   1376  CA  HIS B -10      58.127  47.205   3.787  1.00 57.06           C  
ATOM   1377  C   HIS B -10      56.879  46.924   4.625  1.00 56.57           C  
ATOM   1378  O   HIS B -10      56.579  45.763   4.914  1.00 56.40           O  
ATOM   1379  CB  HIS B -10      57.891  46.741   2.335  1.00 56.71           C  
ATOM   1380  CG  HIS B -10      56.666  47.335   1.698  1.00 55.56           C  
ATOM   1381  ND1 HIS B -10      56.673  48.565   1.073  1.00 50.28           N  
ATOM   1382  CD2 HIS B -10      55.394  46.874   1.607  1.00 56.04           C  
ATOM   1383  CE1 HIS B -10      55.459  48.833   0.622  1.00 54.56           C  
ATOM   1384  NE2 HIS B -10      54.663  47.825   0.936  1.00 54.05           N  
ATOM   1385  N   HIS B  -9      56.148  47.991   4.965  1.00 56.65           N  
ATOM   1386  CA  HIS B  -9      54.910  47.918   5.758  1.00 57.88           C  
ATOM   1387  C   HIS B  -9      53.693  48.072   4.854  1.00 56.42           C  
ATOM   1388  O   HIS B  -9      53.720  48.865   3.903  1.00 55.48           O  
ATOM   1389  CB  HIS B  -9      54.869  49.019   6.828  1.00 58.51           C  
ATOM   1390  CG  HIS B  -9      56.049  49.013   7.749  1.00 61.87           C  
ATOM   1391  ND1 HIS B  -9      56.065  48.312   8.936  1.00 67.97           N  
ATOM   1392  CD2 HIS B  -9      57.260  49.611   7.649  1.00 66.61           C  
ATOM   1393  CE1 HIS B  -9      57.233  48.485   9.530  1.00 68.94           C  
ATOM   1394  NE2 HIS B  -9      57.977  49.269   8.770  1.00 68.02           N  
ATOM   1395  N   HIS B  -8      52.648  47.296   5.155  1.00 55.52           N  
ATOM   1396  CA  HIS B  -8      51.350  47.367   4.480  1.00 55.35           C  
ATOM   1397  C   HIS B  -8      50.334  48.034   5.396  1.00 52.97           C  
ATOM   1398  O   HIS B  -8      50.447  47.958   6.632  1.00 50.73           O  
ATOM   1399  CB  HIS B  -8      50.810  45.979   4.143  1.00 56.26           C  
ATOM   1400  CG  HIS B  -8      51.707  45.195   3.246  1.00 64.14           C  
ATOM   1401  ND1 HIS B  -8      52.739  44.427   3.736  1.00 71.18           N  
ATOM   1402  CD2 HIS B  -8      51.745  45.072   1.899  1.00 67.04           C  
ATOM   1403  CE1 HIS B  -8      53.372  43.857   2.731  1.00 71.47           C  
ATOM   1404  NE2 HIS B  -8      52.790  44.231   1.604  1.00 70.57           N  
ATOM   1405  N   HIS B  -7      49.329  48.652   4.776  1.00 50.11           N  
ATOM   1406  CA  HIS B  -7      48.221  49.270   5.496  1.00 49.28           C  
ATOM   1407  C   HIS B  -7      47.446  48.146   6.192  1.00 49.74           C  
ATOM   1408  O   HIS B  -7      47.353  47.043   5.635  1.00 45.31           O  
ATOM   1409  CB  HIS B  -7      47.301  50.017   4.520  1.00 49.32           C  
ATOM   1410  CG  HIS B  -7      46.347  50.965   5.174  1.00 50.36           C  
ATOM   1411  ND1 HIS B  -7      45.248  50.550   5.897  1.00 53.83           N  
ATOM   1412  CD2 HIS B  -7      46.304  52.318   5.167  1.00 52.45           C  
ATOM   1413  CE1 HIS B  -7      44.591  51.609   6.335  1.00 54.65           C  
ATOM   1414  NE2 HIS B  -7      45.210  52.696   5.904  1.00 51.72           N  
ATOM   1415  N   GLU B  -6      46.922  48.410   7.398  1.00 52.29           N  
ATOM   1416  CA  GLU B  -6      46.102  47.418   8.127  1.00 54.94           C  
ATOM   1417  C   GLU B  -6      44.913  47.025   7.263  1.00 52.67           C  
ATOM   1418  O   GLU B  -6      44.254  47.910   6.697  1.00 54.19           O  
ATOM   1419  CB  GLU B  -6      45.569  47.971   9.444  1.00 55.93           C  
ATOM   1420  CG  GLU B  -6      46.625  48.214  10.511  1.00 61.40           C  
ATOM   1421  CD  GLU B  -6      46.035  48.688  11.842  1.00 60.94           C  
ATOM   1422  OE1 GLU B  -6      44.894  49.218  11.859  1.00 68.67           O  
ATOM   1423  OE2 GLU B  -6      46.725  48.527  12.875  1.00 72.20           O  
ATOM   1424  N   ASN B  -5      44.677  45.718   7.124  1.00 49.13           N  
ATOM   1425  CA  ASN B  -5      43.568  45.236   6.300  1.00 47.57           C  
ATOM   1426  C   ASN B  -5      42.252  45.435   7.076  1.00 45.84           C  
ATOM   1427  O   ASN B  -5      42.239  45.414   8.316  1.00 42.57           O  
ATOM   1428  CB  ASN B  -5      43.804  43.798   5.727  1.00 47.42           C  
ATOM   1429  CG  ASN B  -5      43.924  42.711   6.798  1.00 50.66           C  
ATOM   1430  OD1 ASN B  -5      42.967  42.413   7.506  1.00 44.79           O  
ATOM   1431  ND2 ASN B  -5      45.099  42.079   6.876  1.00 48.36           N  
ATOM   1432  N   LEU B  -4      41.176  45.693   6.331  1.00 44.28           N  
ATOM   1433  CA  LEU B  -4      39.840  45.958   6.904  1.00 43.12           C  
ATOM   1434  C   LEU B  -4      39.334  44.843   7.811  1.00 41.97           C  
ATOM   1435  O   LEU B  -4      38.705  45.128   8.821  1.00 43.29           O  
ATOM   1436  CB  LEU B  -4      38.816  46.205   5.792  1.00 42.44           C  
ATOM   1437  CG  LEU B  -4      38.999  47.489   4.990  1.00 46.11           C  
ATOM   1438  CD1 LEU B  -4      38.100  47.455   3.766  1.00 47.60           C  
ATOM   1439  CD2 LEU B  -4      38.693  48.694   5.876  1.00 46.26           C  
ATOM   1440  N   TYR B  -3      39.607  43.593   7.433  1.00 43.02           N  
ATOM   1441  CA  TYR B  -3      39.226  42.422   8.234  1.00 43.71           C  
ATOM   1442  C   TYR B  -3      39.857  42.526   9.620  1.00 43.37           C  
ATOM   1443  O   TYR B  -3      39.155  42.439  10.643  1.00 39.73           O  
ATOM   1444  CB  TYR B  -3      39.595  41.090   7.532  1.00 45.98           C  
ATOM   1445  CG  TYR B  -3      39.616  39.862   8.442  1.00 45.42           C  
ATOM   1446  CD1 TYR B  -3      38.471  39.104   8.693  1.00 47.41           C  
ATOM   1447  CD2 TYR B  -3      40.821  39.463   9.062  1.00 56.61           C  
ATOM   1448  CE1 TYR B  -3      38.512  37.972   9.552  1.00 48.57           C  
ATOM   1449  CE2 TYR B  -3      40.885  38.360   9.915  1.00 53.84           C  
ATOM   1450  CZ  TYR B  -3      39.741  37.612  10.166  1.00 50.16           C  
ATOM   1451  OH  TYR B  -3      39.906  36.521  11.022  1.00 53.60           O  
ATOM   1452  N   PHE B  -2      41.165  42.761   9.648  1.00 41.55           N  
ATOM   1453  CA  PHE B  -2      41.880  42.878  10.919  1.00 42.69           C  
ATOM   1454  C   PHE B  -2      41.361  44.060  11.768  1.00 39.00           C  
ATOM   1455  O   PHE B  -2      41.114  43.876  12.951  1.00 42.64           O  
ATOM   1456  CB  PHE B  -2      43.389  42.966  10.723  1.00 45.68           C  
ATOM   1457  CG  PHE B  -2      44.149  42.978  12.015  1.00 45.97           C  
ATOM   1458  CD1 PHE B  -2      44.222  41.824  12.788  1.00 49.46           C  
ATOM   1459  CD2 PHE B  -2      44.761  44.140  12.474  1.00 48.49           C  
ATOM   1460  CE1 PHE B  -2      44.907  41.828  14.004  1.00 52.02           C  
ATOM   1461  CE2 PHE B  -2      45.461  44.145  13.678  1.00 47.54           C  
ATOM   1462  CZ  PHE B  -2      45.527  42.995  14.445  1.00 47.04           C  
ATOM   1463  N   GLN B  -1      41.157  45.229  11.170  1.00 39.27           N  
ATOM   1464  CA  GLN B  -1      40.580  46.385  11.886  1.00 39.51           C  
ATOM   1465  C   GLN B  -1      39.186  46.085  12.508  1.00 40.50           C  
ATOM   1466  O   GLN B  -1      38.903  46.483  13.654  1.00 36.21           O  
ATOM   1467  CB  GLN B  -1      40.504  47.615  10.984  1.00 41.01           C  
ATOM   1468  CG  GLN B  -1      41.900  48.131  10.593  1.00 46.81           C  
ATOM   1469  CD  GLN B  -1      41.908  49.496   9.927  1.00 47.44           C  
ATOM   1470  OE1 GLN B  -1      40.967  49.874   9.235  1.00 53.28           O  
ATOM   1471  NE2 GLN B  -1      43.005  50.234  10.116  1.00 58.42           N  
ATOM   1472  N   GLY B   0      38.340  45.377  11.757  1.00 40.41           N  
ATOM   1473  CA  GLY B   0      36.992  44.953  12.225  1.00 40.08           C  
ATOM   1474  C   GLY B   0      37.052  43.994  13.394  1.00 38.68           C  
ATOM   1475  O   GLY B   0      36.297  44.122  14.353  1.00 39.70           O  
HETATM 1476  N   MSE B   1      37.984  43.049  13.343  1.00 40.31           N  
HETATM 1477  CA  MSE B   1      38.171  42.093  14.446  1.00 40.11           C  
HETATM 1478  C   MSE B   1      38.711  42.823  15.671  1.00 39.54           C  
HETATM 1479  O   MSE B   1      38.193  42.639  16.773  1.00 38.55           O  
HETATM 1480  CB  MSE B   1      39.066  40.921  14.014  1.00 40.13           C  
HETATM 1481  CG  MSE B   1      38.465  40.106  12.874  1.00 41.57           C  
HETATM 1482 SE   MSE B   1      36.663  39.340  13.275  0.75 41.23          SE  
HETATM 1483  CE  MSE B   1      37.341  37.971  14.443  1.00 45.40           C  
HETATM 1484  N   MSE B   2      39.717  43.666  15.477  1.00 40.14           N  
HETATM 1485  CA  MSE B   2      40.310  44.447  16.580  1.00 39.80           C  
HETATM 1486  C   MSE B   2      39.329  45.376  17.297  1.00 39.44           C  
HETATM 1487  O   MSE B   2      39.447  45.548  18.510  1.00 38.58           O  
HETATM 1488  CB  MSE B   2      41.546  45.237  16.100  1.00 40.68           C  
HETATM 1489  CG  MSE B   2      42.760  44.333  15.742  1.00 44.98           C  
HETATM 1490 SE   MSE B   2      43.153  43.004  17.106  0.75 49.31          SE  
HETATM 1491  CE  MSE B   2      43.320  44.407  18.512  1.00 36.93           C  
ATOM   1492  N   LYS B   3      38.393  45.983  16.564  1.00 37.42           N  
ATOM   1493  CA  LYS B   3      37.345  46.819  17.168  1.00 39.02           C  
ATOM   1494  C   LYS B   3      36.535  46.064  18.236  1.00 35.96           C  
ATOM   1495  O   LYS B   3      36.142  46.650  19.243  1.00 33.85           O  
ATOM   1496  CB  LYS B   3      36.352  47.382  16.149  1.00 41.85           C  
ATOM   1497  CG  LYS B   3      36.868  48.464  15.218  1.00 50.67           C  
ATOM   1498  CD  LYS B   3      35.862  49.618  15.047  1.00 58.01           C  
ATOM   1499  CE  LYS B   3      36.136  50.516  13.814  1.00 58.74           C  
ATOM   1500  NZ  LYS B   3      37.554  50.672  13.379  1.00 56.08           N  
ATOM   1501  N   PHE B   4      36.272  44.779  17.996  1.00 35.15           N  
ATOM   1502  CA  PHE B   4      35.588  43.945  18.978  1.00 34.82           C  
ATOM   1503  C   PHE B   4      36.468  43.720  20.206  1.00 35.04           C  
ATOM   1504  O   PHE B   4      35.951  43.762  21.327  1.00 36.26           O  
ATOM   1505  CB  PHE B   4      35.173  42.591  18.419  1.00 35.52           C  
ATOM   1506  CG  PHE B   4      33.955  42.617  17.549  1.00 30.05           C  
ATOM   1507  CD1 PHE B   4      32.689  42.958  18.078  1.00 29.08           C  
ATOM   1508  CD2 PHE B   4      34.042  42.237  16.203  1.00 34.68           C  
ATOM   1509  CE1 PHE B   4      31.558  42.936  17.276  1.00 35.63           C  
ATOM   1510  CE2 PHE B   4      32.885  42.203  15.398  1.00 35.19           C  
ATOM   1511  CZ  PHE B   4      31.669  42.553  15.934  1.00 36.32           C  
ATOM   1512  N   PHE B   5      37.761  43.431  20.013  1.00 35.89           N  
ATOM   1513  CA  PHE B   5      38.669  43.286  21.153  1.00 34.59           C  
ATOM   1514  C   PHE B   5      38.730  44.543  22.018  1.00 36.91           C  
ATOM   1515  O   PHE B   5      38.615  44.463  23.251  1.00 37.54           O  
ATOM   1516  CB  PHE B   5      40.064  42.884  20.711  1.00 36.55           C  
ATOM   1517  CG  PHE B   5      40.178  41.435  20.431  1.00 34.69           C  
ATOM   1518  CD1 PHE B   5      40.439  40.552  21.464  1.00 36.46           C  
ATOM   1519  CD2 PHE B   5      39.975  40.938  19.145  1.00 38.20           C  
ATOM   1520  CE1 PHE B   5      40.515  39.179  21.242  1.00 40.22           C  
ATOM   1521  CE2 PHE B   5      40.053  39.560  18.890  1.00 37.26           C  
ATOM   1522  CZ  PHE B   5      40.339  38.672  19.938  1.00 43.00           C  
ATOM   1523  N   GLU B   6      38.896  45.680  21.366  1.00 35.47           N  
ATOM   1524  CA  GLU B   6      38.990  46.992  22.063  1.00 39.61           C  
ATOM   1525  C   GLU B   6      37.722  47.263  22.864  1.00 36.79           C  
ATOM   1526  O   GLU B   6      37.786  47.681  24.025  1.00 34.12           O  
ATOM   1527  CB  GLU B   6      39.232  48.101  21.064  1.00 37.61           C  
ATOM   1528  CG  GLU B   6      40.579  48.046  20.343  1.00 43.92           C  
ATOM   1529  CD  GLU B   6      40.573  48.805  18.990  1.00 48.16           C  
ATOM   1530  OE1 GLU B   6      39.714  49.708  18.773  1.00 60.70           O  
ATOM   1531  OE2 GLU B   6      41.424  48.480  18.132  1.00 60.62           O  
ATOM   1532  N   TYR B   7      36.567  47.020  22.223  1.00 35.54           N  
ATOM   1533  CA  TYR B   7      35.254  47.081  22.878  1.00 33.33           C  
ATOM   1534  C   TYR B   7      35.213  46.167  24.125  1.00 34.04           C  
ATOM   1535  O   TYR B   7      34.854  46.615  25.241  1.00 34.37           O  
ATOM   1536  CB  TYR B   7      34.126  46.726  21.874  1.00 31.90           C  
ATOM   1537  CG  TYR B   7      32.806  46.319  22.490  1.00 32.52           C  
ATOM   1538  CD1 TYR B   7      31.889  47.274  22.981  1.00 36.90           C  
ATOM   1539  CD2 TYR B   7      32.457  44.975  22.589  1.00 37.33           C  
ATOM   1540  CE1 TYR B   7      30.651  46.868  23.572  1.00 36.08           C  
ATOM   1541  CE2 TYR B   7      31.233  44.574  23.167  1.00 41.02           C  
ATOM   1542  CZ  TYR B   7      30.340  45.505  23.649  1.00 35.65           C  
ATOM   1543  OH  TYR B   7      29.158  45.024  24.207  1.00 35.22           O  
ATOM   1544  N   ASN B   8      35.574  44.897  23.933  1.00 33.90           N  
ATOM   1545  CA  ASN B   8      35.547  43.936  25.031  1.00 34.08           C  
ATOM   1546  C   ASN B   8      36.416  44.380  26.227  1.00 34.65           C  
ATOM   1547  O   ASN B   8      35.965  44.341  27.382  1.00 34.50           O  
ATOM   1548  CB  ASN B   8      35.935  42.512  24.568  1.00 36.21           C  
ATOM   1549  CG  ASN B   8      34.786  41.765  23.904  1.00 35.25           C  
ATOM   1550  OD1 ASN B   8      33.617  42.082  24.096  1.00 34.99           O  
ATOM   1551  ND2 ASN B   8      35.129  40.735  23.138  1.00 37.50           N  
ATOM   1552  N   TRP B   9      37.633  44.819  25.919  1.00 35.94           N  
ATOM   1553  CA  TRP B   9      38.597  45.225  26.949  1.00 36.02           C  
ATOM   1554  C   TRP B   9      38.100  46.442  27.709  1.00 36.52           C  
ATOM   1555  O   TRP B   9      38.198  46.478  28.929  1.00 35.71           O  
ATOM   1556  CB  TRP B   9      39.978  45.482  26.337  1.00 37.28           C  
ATOM   1557  CG  TRP B   9      40.571  44.279  25.708  1.00 33.71           C  
ATOM   1558  CD1 TRP B   9      40.278  42.973  26.014  1.00 38.25           C  
ATOM   1559  CD2 TRP B   9      41.619  44.221  24.729  1.00 37.72           C  
ATOM   1560  NE1 TRP B   9      41.052  42.139  25.286  1.00 35.78           N  
ATOM   1561  CE2 TRP B   9      41.876  42.856  24.481  1.00 33.53           C  
ATOM   1562  CE3 TRP B   9      42.351  45.180  24.027  1.00 38.02           C  
ATOM   1563  CZ2 TRP B   9      42.842  42.419  23.565  1.00 39.17           C  
ATOM   1564  CZ3 TRP B   9      43.309  44.748  23.106  1.00 39.51           C  
ATOM   1565  CH2 TRP B   9      43.546  43.383  22.889  1.00 38.80           C  
ATOM   1566  N   GLN B  10      37.537  47.417  26.989  1.00 33.84           N  
ATOM   1567  CA  GLN B  10      36.987  48.599  27.639  1.00 37.63           C  
ATOM   1568  C   GLN B  10      35.825  48.231  28.579  1.00 36.89           C  
ATOM   1569  O   GLN B  10      35.790  48.696  29.712  1.00 37.57           O  
ATOM   1570  CB  GLN B  10      36.545  49.625  26.595  1.00 34.46           C  
ATOM   1571  CG  GLN B  10      35.924  50.885  27.175  1.00 42.79           C  
ATOM   1572  CD  GLN B  10      35.505  51.876  26.104  1.00 44.77           C  
ATOM   1573  OE1 GLN B  10      36.188  52.043  25.086  1.00 66.34           O  
ATOM   1574  NE2 GLN B  10      34.382  52.552  26.336  1.00 55.39           N  
ATOM   1575  N   VAL B  11      34.878  47.430  28.086  1.00 37.75           N  
ATOM   1576  CA  VAL B  11      33.714  46.973  28.873  1.00 35.00           C  
ATOM   1577  C   VAL B  11      34.188  46.203  30.111  1.00 36.01           C  
ATOM   1578  O   VAL B  11      33.678  46.444  31.210  1.00 35.58           O  
ATOM   1579  CB  VAL B  11      32.736  46.125  27.995  1.00 37.96           C  
ATOM   1580  CG1 VAL B  11      31.678  45.377  28.825  1.00 34.75           C  
ATOM   1581  CG2 VAL B  11      32.066  47.026  26.951  1.00 34.27           C  
ATOM   1582  N   ARG B  12      35.180  45.320  29.929  1.00 32.96           N  
ATOM   1583  CA  ARG B  12      35.728  44.522  31.033  1.00 35.07           C  
ATOM   1584  C   ARG B  12      36.247  45.421  32.168  1.00 37.74           C  
ATOM   1585  O   ARG B  12      35.931  45.181  33.347  1.00 38.57           O  
ATOM   1586  CB  ARG B  12      36.834  43.587  30.552  1.00 35.96           C  
ATOM   1587  CG  ARG B  12      37.274  42.542  31.619  1.00 36.27           C  
ATOM   1588  CD  ARG B  12      38.584  41.920  31.283  1.00 33.78           C  
ATOM   1589  NE  ARG B  12      38.527  41.229  30.008  1.00 36.22           N  
ATOM   1590  CZ  ARG B  12      39.588  40.704  29.386  1.00 34.72           C  
ATOM   1591  NH1 ARG B  12      40.800  40.746  29.903  1.00 36.32           N  
ATOM   1592  NH2 ARG B  12      39.420  40.097  28.227  1.00 34.04           N  
ATOM   1593  N   ASP B  13      37.008  46.459  31.793  1.00 37.48           N  
ATOM   1594  CA  ASP B  13      37.559  47.426  32.755  1.00 37.58           C  
ATOM   1595  C   ASP B  13      36.450  48.108  33.548  1.00 36.18           C  
ATOM   1596  O   ASP B  13      36.589  48.278  34.758  1.00 35.19           O  
ATOM   1597  CB  ASP B  13      38.468  48.466  32.071  1.00 38.37           C  
ATOM   1598  CG  ASP B  13      39.852  47.899  31.665  1.00 43.15           C  
ATOM   1599  OD1 ASP B  13      40.303  46.860  32.190  1.00 45.65           O  
ATOM   1600  OD2 ASP B  13      40.513  48.525  30.823  1.00 47.05           O  
ATOM   1601  N   GLN B  14      35.351  48.441  32.861  1.00 35.14           N  
ATOM   1602  CA  GLN B  14      34.170  49.031  33.489  1.00 37.96           C  
ATOM   1603  C   GLN B  14      33.501  48.051  34.454  1.00 37.71           C  
ATOM   1604  O   GLN B  14      33.023  48.476  35.493  1.00 37.18           O  
ATOM   1605  CB  GLN B  14      33.212  49.579  32.437  1.00 37.11           C  
ATOM   1606  CG  GLN B  14      33.834  50.775  31.693  1.00 38.58           C  
ATOM   1607  CD  GLN B  14      33.011  51.318  30.537  1.00 42.79           C  
ATOM   1608  OE1 GLN B  14      32.041  50.712  30.092  1.00 57.46           O  
ATOM   1609  NE2 GLN B  14      33.444  52.458  30.008  1.00 50.70           N  
ATOM   1610  N   TRP B  15      33.484  46.760  34.129  1.00 35.69           N  
ATOM   1611  CA  TRP B  15      32.979  45.752  35.080  1.00 35.95           C  
ATOM   1612  C   TRP B  15      33.907  45.614  36.291  1.00 35.56           C  
ATOM   1613  O   TRP B  15      33.413  45.471  37.424  1.00 35.28           O  
ATOM   1614  CB  TRP B  15      32.711  44.393  34.417  1.00 37.34           C  
ATOM   1615  CG  TRP B  15      31.385  44.382  33.713  1.00 34.28           C  
ATOM   1616  CD1 TRP B  15      31.156  44.537  32.378  1.00 37.06           C  
ATOM   1617  CD2 TRP B  15      30.116  44.228  34.327  1.00 33.19           C  
ATOM   1618  NE1 TRP B  15      29.818  44.475  32.116  1.00 36.43           N  
ATOM   1619  CE2 TRP B  15      29.146  44.279  33.294  1.00 37.27           C  
ATOM   1620  CE3 TRP B  15      29.694  44.023  35.652  1.00 38.11           C  
ATOM   1621  CZ2 TRP B  15      27.772  44.176  33.549  1.00 37.66           C  
ATOM   1622  CZ3 TRP B  15      28.319  43.917  35.913  1.00 40.06           C  
ATOM   1623  CH2 TRP B  15      27.378  43.978  34.860  1.00 36.67           C  
ATOM   1624  N   PHE B  16      35.230  45.685  36.080  1.00 36.20           N  
ATOM   1625  CA  PHE B  16      36.167  45.648  37.214  1.00 35.63           C  
ATOM   1626  C   PHE B  16      35.857  46.796  38.185  1.00 34.57           C  
ATOM   1627  O   PHE B  16      35.804  46.569  39.398  1.00 31.81           O  
ATOM   1628  CB  PHE B  16      37.653  45.696  36.810  1.00 37.36           C  
ATOM   1629  CG  PHE B  16      38.181  44.426  36.177  1.00 39.64           C  
ATOM   1630  CD1 PHE B  16      38.036  43.185  36.807  1.00 47.05           C  
ATOM   1631  CD2 PHE B  16      38.925  44.476  34.996  1.00 42.90           C  
ATOM   1632  CE1 PHE B  16      38.557  42.011  36.217  1.00 45.70           C  
ATOM   1633  CE2 PHE B  16      39.450  43.313  34.419  1.00 39.56           C  
ATOM   1634  CZ  PHE B  16      39.254  42.083  35.036  1.00 41.00           C  
ATOM   1635  N   THR B  17      35.618  48.001  37.650  1.00 33.92           N  
ATOM   1636  CA  THR B  17      35.221  49.162  38.474  1.00 33.24           C  
ATOM   1637  C   THR B  17      33.891  48.943  39.206  1.00 33.74           C  
ATOM   1638  O   THR B  17      33.762  49.259  40.408  1.00 35.17           O  
ATOM   1639  CB  THR B  17      35.100  50.452  37.632  1.00 32.74           C  
ATOM   1640  OG1 THR B  17      36.352  50.714  37.004  1.00 32.82           O  
ATOM   1641  CG2 THR B  17      34.681  51.676  38.518  1.00 32.50           C  
ATOM   1642  N   TRP B  18      32.909  48.442  38.459  1.00 35.45           N  
ATOM   1643  CA  TRP B  18      31.594  48.088  38.984  1.00 35.69           C  
ATOM   1644  C   TRP B  18      31.732  47.096  40.147  1.00 36.78           C  
ATOM   1645  O   TRP B  18      31.125  47.300  41.192  1.00 37.40           O  
ATOM   1646  CB  TRP B  18      30.717  47.510  37.862  1.00 37.34           C  
ATOM   1647  CG  TRP B  18      29.338  47.122  38.271  1.00 36.42           C  
ATOM   1648  CD1 TRP B  18      28.209  47.899  38.214  1.00 35.87           C  
ATOM   1649  CD2 TRP B  18      28.937  45.864  38.824  1.00 36.34           C  
ATOM   1650  NE1 TRP B  18      27.133  47.181  38.668  1.00 40.18           N  
ATOM   1651  CE2 TRP B  18      27.549  45.932  39.048  1.00 35.81           C  
ATOM   1652  CE3 TRP B  18      29.618  44.673  39.133  1.00 37.33           C  
ATOM   1653  CZ2 TRP B  18      26.822  44.867  39.606  1.00 40.50           C  
ATOM   1654  CZ3 TRP B  18      28.894  43.599  39.673  1.00 40.27           C  
ATOM   1655  CH2 TRP B  18      27.504  43.708  39.898  1.00 38.21           C  
ATOM   1656  N   CYS B  19      32.559  46.063  39.983  1.00 36.94           N  
ATOM   1657  CA  CYS B  19      32.779  45.064  41.055  1.00 39.40           C  
ATOM   1658  C   CYS B  19      33.307  45.623  42.384  1.00 39.19           C  
ATOM   1659  O   CYS B  19      33.138  44.980  43.428  1.00 38.84           O  
ATOM   1660  CB  CYS B  19      33.729  43.951  40.591  1.00 40.32           C  
ATOM   1661  SG  CYS B  19      33.019  42.835  39.418  1.00 37.63           S  
ATOM   1662  N   HIS B  20      33.951  46.794  42.339  1.00 40.83           N  
ATOM   1663  CA  HIS B  20      34.521  47.437  43.534  1.00 42.15           C  
ATOM   1664  C   HIS B  20      33.487  47.740  44.633  1.00 43.73           C  
ATOM   1665  O   HIS B  20      33.853  47.812  45.811  1.00 45.23           O  
ATOM   1666  CB  HIS B  20      35.274  48.718  43.157  1.00 42.92           C  
ATOM   1667  CG  HIS B  20      36.256  49.150  44.188  1.00 45.76           C  
ATOM   1668  ND1 HIS B  20      35.929  50.013  45.216  1.00 49.47           N  
ATOM   1669  CD2 HIS B  20      37.552  48.810  44.375  1.00 50.16           C  
ATOM   1670  CE1 HIS B  20      36.990  50.201  45.981  1.00 45.79           C  
ATOM   1671  NE2 HIS B  20      37.988  49.484  45.494  1.00 50.80           N  
ATOM   1672  N   GLN B  21      32.217  47.910  44.248  1.00 43.19           N  
ATOM   1673  CA  GLN B  21      31.130  48.152  45.209  1.00 43.31           C  
ATOM   1674  C   GLN B  21      30.629  46.895  45.946  1.00 42.94           C  
ATOM   1675  O   GLN B  21      29.799  47.022  46.852  1.00 43.57           O  
ATOM   1676  CB  GLN B  21      29.968  48.878  44.526  1.00 42.81           C  
ATOM   1677  CG  GLN B  21      29.095  48.053  43.618  1.00 42.31           C  
ATOM   1678  CD  GLN B  21      28.271  48.920  42.672  1.00 43.57           C  
ATOM   1679  OE1 GLN B  21      27.615  49.874  43.099  1.00 43.03           O  
ATOM   1680  NE2 GLN B  21      28.288  48.582  41.388  1.00 44.02           N  
ATOM   1681  N   LEU B  22      31.132  45.712  45.575  1.00 41.95           N  
ATOM   1682  CA  LEU B  22      30.773  44.449  46.216  1.00 41.82           C  
ATOM   1683  C   LEU B  22      31.889  43.939  47.108  1.00 42.31           C  
ATOM   1684  O   LEU B  22      33.058  44.203  46.851  1.00 44.20           O  
ATOM   1685  CB  LEU B  22      30.496  43.376  45.156  1.00 41.32           C  
ATOM   1686  CG  LEU B  22      29.359  43.642  44.174  1.00 40.79           C  
ATOM   1687  CD1 LEU B  22      29.299  42.512  43.166  1.00 43.32           C  
ATOM   1688  CD2 LEU B  22      28.028  43.787  44.905  1.00 36.50           C  
ATOM   1689  N   THR B  23      31.512  43.160  48.120  1.00 41.59           N  
ATOM   1690  CA  THR B  23      32.463  42.499  49.016  1.00 40.74           C  
ATOM   1691  C   THR B  23      33.037  41.285  48.295  1.00 41.95           C  
ATOM   1692  O   THR B  23      32.437  40.803  47.333  1.00 40.65           O  
ATOM   1693  CB  THR B  23      31.791  42.019  50.313  1.00 41.46           C  
ATOM   1694  OG1 THR B  23      30.823  41.004  50.017  1.00 35.95           O  
ATOM   1695  CG2 THR B  23      31.104  43.168  51.025  1.00 36.66           C  
ATOM   1696  N   THR B  24      34.171  40.764  48.760  1.00 42.70           N  
ATOM   1697  CA  THR B  24      34.767  39.553  48.140  1.00 44.01           C  
ATOM   1698  C   THR B  24      33.805  38.354  48.252  1.00 44.00           C  
ATOM   1699  O   THR B  24      33.745  37.540  47.345  1.00 43.55           O  
ATOM   1700  CB  THR B  24      36.152  39.194  48.734  1.00 44.57           C  
ATOM   1701  OG1 THR B  24      37.016  40.331  48.659  1.00 47.11           O  
ATOM   1702  CG2 THR B  24      36.801  38.047  47.974  1.00 44.78           C  
ATOM   1703  N   GLU B  25      33.060  38.278  49.361  1.00 44.52           N  
ATOM   1704  CA  GLU B  25      32.028  37.248  49.571  1.00 45.44           C  
ATOM   1705  C   GLU B  25      30.933  37.340  48.495  1.00 44.65           C  
ATOM   1706  O   GLU B  25      30.548  36.313  47.924  1.00 43.67           O  
ATOM   1707  CB  GLU B  25      31.431  37.367  50.980  1.00 45.88           C  
ATOM   1708  CG  GLU B  25      30.442  36.280  51.352  1.00 49.40           C  
ATOM   1709  N   GLU B  26      30.446  38.561  48.234  1.00 44.01           N  
ATOM   1710  CA  GLU B  26      29.462  38.832  47.161  1.00 45.13           C  
ATOM   1711  C   GLU B  26      30.023  38.434  45.778  1.00 42.38           C  
ATOM   1712  O   GLU B  26      29.359  37.745  44.991  1.00 39.22           O  
ATOM   1713  CB  GLU B  26      29.003  40.310  47.173  1.00 44.72           C  
ATOM   1714  CG  GLU B  26      28.042  40.638  48.340  1.00 48.18           C  
ATOM   1715  CD  GLU B  26      27.684  42.134  48.513  1.00 51.26           C  
ATOM   1716  OE1 GLU B  26      28.493  43.035  48.185  1.00 51.19           O  
ATOM   1717  OE2 GLU B  26      26.580  42.406  49.040  1.00 60.60           O  
ATOM   1718  N   LEU B  27      31.260  38.847  45.510  1.00 40.86           N  
ATOM   1719  CA  LEU B  27      31.955  38.508  44.259  1.00 39.39           C  
ATOM   1720  C   LEU B  27      32.157  36.991  44.068  1.00 39.87           C  
ATOM   1721  O   LEU B  27      32.108  36.508  42.940  1.00 38.91           O  
ATOM   1722  CB  LEU B  27      33.294  39.263  44.180  1.00 40.08           C  
ATOM   1723  CG  LEU B  27      33.188  40.790  44.048  1.00 41.45           C  
ATOM   1724  CD1 LEU B  27      34.549  41.440  44.239  1.00 43.28           C  
ATOM   1725  CD2 LEU B  27      32.560  41.205  42.702  1.00 41.90           C  
ATOM   1726  N   LEU B  28      32.320  36.252  45.172  1.00 40.02           N  
ATOM   1727  CA  LEU B  28      32.511  34.782  45.147  1.00 40.91           C  
ATOM   1728  C   LEU B  28      31.243  33.933  45.358  1.00 40.47           C  
ATOM   1729  O   LEU B  28      31.300  32.722  45.133  1.00 41.82           O  
ATOM   1730  CB  LEU B  28      33.573  34.380  46.190  1.00 39.83           C  
ATOM   1731  CG  LEU B  28      34.999  34.754  45.780  1.00 39.75           C  
ATOM   1732  CD1 LEU B  28      35.923  34.797  46.975  1.00 37.69           C  
ATOM   1733  CD2 LEU B  28      35.513  33.780  44.708  1.00 36.46           C  
ATOM   1734  N   LYS B  29      30.133  34.550  45.775  1.00 40.32           N  
ATOM   1735  CA  LYS B  29      28.861  33.845  46.040  1.00 41.49           C  
ATOM   1736  C   LYS B  29      28.355  33.136  44.796  1.00 39.01           C  
ATOM   1737  O   LYS B  29      28.170  33.775  43.775  1.00 37.35           O  
ATOM   1738  CB  LYS B  29      27.783  34.829  46.525  1.00 42.30           C  
ATOM   1739  CG  LYS B  29      26.434  34.205  46.939  1.00 42.71           C  
ATOM   1740  CD  LYS B  29      25.439  35.293  47.330  1.00 45.24           C  
ATOM   1741  CE  LYS B  29      24.076  34.735  47.754  1.00 50.07           C  
ATOM   1742  NZ  LYS B  29      24.162  33.934  48.995  1.00 59.84           N  
ATOM   1743  N   ASN B  30      28.138  31.826  44.887  1.00 41.02           N  
ATOM   1744  CA  ASN B  30      27.640  31.058  43.741  1.00 43.18           C  
ATOM   1745  C   ASN B  30      26.154  31.341  43.489  1.00 43.77           C  
ATOM   1746  O   ASN B  30      25.353  31.427  44.409  1.00 41.99           O  
ATOM   1747  CB  ASN B  30      27.926  29.552  43.863  1.00 45.90           C  
ATOM   1748  CG  ASN B  30      29.409  29.206  43.628  1.00 50.12           C  
ATOM   1749  OD1 ASN B  30      30.061  29.712  42.698  1.00 43.02           O  
ATOM   1750  ND2 ASN B  30      29.931  28.316  44.459  1.00 59.17           N  
ATOM   1751  N   ARG B  31      25.849  31.532  42.209  1.00 44.68           N  
ATOM   1752  CA  ARG B  31      24.548  31.865  41.681  1.00 46.32           C  
ATOM   1753  C   ARG B  31      24.313  30.880  40.541  1.00 47.77           C  
ATOM   1754  O   ARG B  31      25.216  30.108  40.182  1.00 49.34           O  
ATOM   1755  CB  ARG B  31      24.558  33.313  41.159  1.00 45.97           C  
ATOM   1756  CG  ARG B  31      25.165  34.344  42.140  1.00 47.72           C  
ATOM   1757  CD  ARG B  31      25.268  35.761  41.560  1.00 44.10           C  
ATOM   1758  NE  ARG B  31      26.000  36.690  42.445  1.00 42.98           N  
ATOM   1759  CZ  ARG B  31      25.533  37.236  43.573  1.00 47.43           C  
ATOM   1760  NH1 ARG B  31      24.306  36.982  44.012  1.00 46.05           N  
ATOM   1761  NH2 ARG B  31      26.310  38.058  44.287  1.00 48.55           N  
ATOM   1762  N   LEU B  32      23.119  30.914  39.965  1.00 48.70           N  
ATOM   1763  CA  LEU B  32      22.761  30.022  38.851  1.00 47.93           C  
ATOM   1764  C   LEU B  32      23.076  30.733  37.545  1.00 46.41           C  
ATOM   1765  O   LEU B  32      22.744  31.897  37.398  1.00 46.93           O  
ATOM   1766  CB  LEU B  32      21.284  29.666  38.928  1.00 47.86           C  
ATOM   1767  CG  LEU B  32      20.855  28.972  40.221  1.00 49.07           C  
ATOM   1768  CD1 LEU B  32      19.341  28.965  40.343  1.00 49.11           C  
ATOM   1769  CD2 LEU B  32      21.435  27.555  40.280  1.00 47.20           C  
ATOM   1770  N   GLY B  33      23.702  30.035  36.604  1.00 44.79           N  
ATOM   1771  CA  GLY B  33      24.061  30.610  35.298  1.00 45.50           C  
ATOM   1772  C   GLY B  33      25.561  30.591  35.078  1.00 46.30           C  
ATOM   1773  O   GLY B  33      26.332  30.785  36.027  1.00 43.44           O  
ATOM   1774  N   GLY B  34      25.961  30.343  33.831  1.00 47.83           N  
ATOM   1775  CA  GLY B  34      27.369  30.304  33.410  1.00 47.53           C  
ATOM   1776  C   GLY B  34      28.288  29.579  34.376  1.00 47.26           C  
ATOM   1777  O   GLY B  34      27.971  28.473  34.814  1.00 46.06           O  
ATOM   1778  N   VAL B  35      29.390  30.231  34.751  1.00 47.42           N  
ATOM   1779  CA  VAL B  35      30.351  29.657  35.708  1.00 47.17           C  
ATOM   1780  C   VAL B  35      30.029  30.078  37.174  1.00 47.26           C  
ATOM   1781  O   VAL B  35      30.896  30.046  38.046  1.00 47.24           O  
ATOM   1782  CB  VAL B  35      31.829  29.917  35.274  1.00 47.96           C  
ATOM   1783  CG1 VAL B  35      32.039  29.444  33.831  1.00 51.00           C  
ATOM   1784  CG2 VAL B  35      32.226  31.373  35.432  1.00 46.78           C  
ATOM   1785  N   GLU B  36      28.776  30.486  37.410  1.00 46.25           N  
ATOM   1786  CA  GLU B  36      28.155  30.675  38.744  1.00 45.97           C  
ATOM   1787  C   GLU B  36      28.540  31.832  39.680  1.00 43.97           C  
ATOM   1788  O   GLU B  36      27.670  32.219  40.482  1.00 44.99           O  
ATOM   1789  CB  GLU B  36      28.190  29.351  39.521  1.00 46.94           C  
ATOM   1790  CG  GLU B  36      27.423  28.251  38.781  1.00 54.87           C  
ATOM   1791  CD  GLU B  36      27.036  27.095  39.678  1.00 63.56           C  
ATOM   1792  OE1 GLU B  36      27.846  26.721  40.557  1.00 68.18           O  
ATOM   1793  OE2 GLU B  36      25.917  26.564  39.491  1.00 72.57           O  
ATOM   1794  N   ASN B  37      29.770  32.343  39.673  1.00 38.53           N  
ATOM   1795  CA  ASN B  37      30.054  33.539  40.512  1.00 37.94           C  
ATOM   1796  C   ASN B  37      30.675  34.640  39.681  1.00 36.00           C  
ATOM   1797  O   ASN B  37      31.233  34.373  38.634  1.00 34.66           O  
ATOM   1798  CB  ASN B  37      30.798  33.217  41.841  1.00 37.17           C  
ATOM   1799  CG  ASN B  37      32.209  32.703  41.661  1.00 38.10           C  
ATOM   1800  OD1 ASN B  37      33.129  33.469  41.369  1.00 38.31           O  
ATOM   1801  ND2 ASN B  37      32.415  31.420  41.971  1.00 36.30           N  
ATOM   1802  N   ILE B  38      30.531  35.879  40.154  1.00 36.37           N  
ATOM   1803  CA  ILE B  38      31.012  37.066  39.426  1.00 36.74           C  
ATOM   1804  C   ILE B  38      32.524  37.055  39.203  1.00 37.31           C  
ATOM   1805  O   ILE B  38      32.995  37.304  38.099  1.00 38.31           O  
ATOM   1806  CB  ILE B  38      30.618  38.376  40.161  1.00 34.95           C  
ATOM   1807  CG1 ILE B  38      29.086  38.544  40.173  1.00 34.70           C  
ATOM   1808  CG2 ILE B  38      31.284  39.586  39.486  1.00 36.02           C  
ATOM   1809  CD1 ILE B  38      28.590  39.620  41.119  1.00 37.62           C  
ATOM   1810  N   LEU B  39      33.275  36.768  40.263  1.00 37.74           N  
ATOM   1811  CA  LEU B  39      34.731  36.781  40.183  1.00 36.43           C  
ATOM   1812  C   LEU B  39      35.279  35.673  39.265  1.00 36.23           C  
ATOM   1813  O   LEU B  39      36.183  35.935  38.483  1.00 35.91           O  
ATOM   1814  CB  LEU B  39      35.363  36.692  41.582  1.00 37.66           C  
ATOM   1815  CG  LEU B  39      36.841  37.071  41.670  1.00 38.20           C  
ATOM   1816  CD1 LEU B  39      37.064  38.549  41.296  1.00 38.69           C  
ATOM   1817  CD2 LEU B  39      37.332  36.778  43.076  1.00 36.54           C  
ATOM   1818  N   TYR B  40      34.719  34.464  39.351  1.00 35.60           N  
ATOM   1819  CA  TYR B  40      35.139  33.362  38.484  1.00 35.95           C  
ATOM   1820  C   TYR B  40      34.753  33.594  37.023  1.00 35.18           C  
ATOM   1821  O   TYR B  40      35.476  33.159  36.136  1.00 36.45           O  
ATOM   1822  CB  TYR B  40      34.614  32.002  38.964  1.00 38.63           C  
ATOM   1823  CG  TYR B  40      35.172  30.824  38.182  1.00 41.29           C  
ATOM   1824  CD1 TYR B  40      36.543  30.699  37.932  1.00 45.16           C  
ATOM   1825  CD2 TYR B  40      34.344  29.823  37.706  1.00 54.47           C  
ATOM   1826  CE1 TYR B  40      37.066  29.635  37.202  1.00 46.12           C  
ATOM   1827  CE2 TYR B  40      34.866  28.725  36.974  1.00 56.08           C  
ATOM   1828  CZ  TYR B  40      36.232  28.645  36.735  1.00 53.79           C  
ATOM   1829  OH  TYR B  40      36.767  27.591  36.023  1.00 56.64           O  
ATOM   1830  N   THR B  41      33.638  34.289  36.782  1.00 37.36           N  
ATOM   1831  CA  THR B  41      33.247  34.677  35.435  1.00 36.41           C  
ATOM   1832  C   THR B  41      34.320  35.561  34.803  1.00 36.29           C  
ATOM   1833  O   THR B  41      34.719  35.323  33.658  1.00 37.99           O  
ATOM   1834  CB  THR B  41      31.868  35.380  35.418  1.00 36.18           C  
ATOM   1835  OG1 THR B  41      30.887  34.473  35.923  1.00 38.12           O  
ATOM   1836  CG2 THR B  41      31.499  35.841  33.976  1.00 38.40           C  
ATOM   1837  N   LEU B  42      34.794  36.558  35.549  1.00 35.65           N  
ATOM   1838  CA  LEU B  42      35.843  37.449  35.059  1.00 35.88           C  
ATOM   1839  C   LEU B  42      37.154  36.676  34.836  1.00 37.01           C  
ATOM   1840  O   LEU B  42      37.768  36.817  33.773  1.00 36.13           O  
ATOM   1841  CB  LEU B  42      36.019  38.679  35.972  1.00 38.36           C  
ATOM   1842  CG  LEU B  42      34.848  39.688  35.890  1.00 36.73           C  
ATOM   1843  CD1 LEU B  42      34.922  40.758  36.989  1.00 41.04           C  
ATOM   1844  CD2 LEU B  42      34.815  40.346  34.537  1.00 36.25           C  
ATOM   1845  N   PHE B  43      37.541  35.838  35.805  1.00 36.30           N  
ATOM   1846  CA  PHE B  43      38.736  34.976  35.677  1.00 34.59           C  
ATOM   1847  C   PHE B  43      38.661  34.086  34.439  1.00 35.13           C  
ATOM   1848  O   PHE B  43      39.646  33.952  33.701  1.00 34.64           O  
ATOM   1849  CB  PHE B  43      38.908  34.078  36.911  1.00 34.32           C  
ATOM   1850  CG  PHE B  43      40.071  33.126  36.806  1.00 33.43           C  
ATOM   1851  CD1 PHE B  43      41.354  33.548  37.154  1.00 34.62           C  
ATOM   1852  CD2 PHE B  43      39.892  31.824  36.303  1.00 36.01           C  
ATOM   1853  CE1 PHE B  43      42.455  32.682  37.036  1.00 37.88           C  
ATOM   1854  CE2 PHE B  43      40.982  30.942  36.168  1.00 39.32           C  
ATOM   1855  CZ  PHE B  43      42.272  31.373  36.541  1.00 36.05           C  
ATOM   1856  N   HIS B  44      37.497  33.452  34.264  1.00 33.87           N  
ATOM   1857  CA  HIS B  44      37.216  32.542  33.152  1.00 34.68           C  
ATOM   1858  C   HIS B  44      37.370  33.233  31.804  1.00 35.70           C  
ATOM   1859  O   HIS B  44      37.972  32.682  30.906  1.00 33.92           O  
ATOM   1860  CB  HIS B  44      35.818  31.943  33.331  1.00 34.00           C  
ATOM   1861  CG  HIS B  44      35.353  31.115  32.193  1.00 36.12           C  
ATOM   1862  ND1 HIS B  44      35.925  29.907  31.859  1.00 33.19           N  
ATOM   1863  CD2 HIS B  44      34.340  31.312  31.325  1.00 39.86           C  
ATOM   1864  CE1 HIS B  44      35.289  29.404  30.814  1.00 39.92           C  
ATOM   1865  NE2 HIS B  44      34.319  30.234  30.474  1.00 33.32           N  
ATOM   1866  N   ILE B  45      36.806  34.428  31.678  1.00 33.47           N  
ATOM   1867  CA  ILE B  45      36.958  35.231  30.463  1.00 34.43           C  
ATOM   1868  C   ILE B  45      38.438  35.460  30.147  1.00 33.94           C  
ATOM   1869  O   ILE B  45      38.889  35.201  29.030  1.00 34.46           O  
ATOM   1870  CB  ILE B  45      36.249  36.596  30.599  1.00 32.25           C  
ATOM   1871  CG1 ILE B  45      34.728  36.428  30.572  1.00 37.27           C  
ATOM   1872  CG2 ILE B  45      36.679  37.561  29.464  1.00 34.26           C  
ATOM   1873  CD1 ILE B  45      34.015  37.674  31.126  1.00 36.50           C  
ATOM   1874  N   ILE B  46      39.180  35.930  31.153  1.00 34.14           N  
ATOM   1875  CA  ILE B  46      40.623  36.208  31.047  1.00 35.80           C  
ATOM   1876  C   ILE B  46      41.389  34.945  30.663  1.00 34.90           C  
ATOM   1877  O   ILE B  46      42.223  34.957  29.744  1.00 35.98           O  
ATOM   1878  CB  ILE B  46      41.163  36.813  32.393  1.00 36.62           C  
ATOM   1879  CG1 ILE B  46      40.544  38.194  32.669  1.00 36.80           C  
ATOM   1880  CG2 ILE B  46      42.698  36.922  32.432  1.00 32.88           C  
ATOM   1881  CD1 ILE B  46      40.745  38.630  34.101  1.00 38.55           C  
ATOM   1882  N   ASP B  47      41.077  33.855  31.365  1.00 36.05           N  
ATOM   1883  CA  ASP B  47      41.719  32.547  31.166  1.00 36.94           C  
ATOM   1884  C   ASP B  47      41.545  32.011  29.738  1.00 35.87           C  
ATOM   1885  O   ASP B  47      42.535  31.683  29.068  1.00 37.18           O  
ATOM   1886  CB  ASP B  47      41.152  31.548  32.204  1.00 36.90           C  
ATOM   1887  CG  ASP B  47      41.799  30.161  32.136  1.00 38.49           C  
ATOM   1888  OD1 ASP B  47      42.982  30.043  31.765  1.00 44.68           O  
ATOM   1889  OD2 ASP B  47      41.116  29.183  32.499  1.00 39.19           O  
ATOM   1890  N   VAL B  48      40.292  31.937  29.291  1.00 36.04           N  
ATOM   1891  CA  VAL B  48      39.949  31.445  27.951  1.00 33.42           C  
ATOM   1892  C   VAL B  48      40.561  32.325  26.857  1.00 35.23           C  
ATOM   1893  O   VAL B  48      41.130  31.814  25.907  1.00 34.52           O  
ATOM   1894  CB  VAL B  48      38.415  31.315  27.775  1.00 35.93           C  
ATOM   1895  CG1 VAL B  48      38.023  31.046  26.281  1.00 35.10           C  
ATOM   1896  CG2 VAL B  48      37.884  30.231  28.721  1.00 37.33           C  
ATOM   1897  N   GLU B  49      40.485  33.639  27.011  1.00 35.81           N  
ATOM   1898  CA  GLU B  49      41.072  34.529  26.000  1.00 37.05           C  
ATOM   1899  C   GLU B  49      42.570  34.260  25.823  1.00 37.19           C  
ATOM   1900  O   GLU B  49      43.047  34.081  24.707  1.00 38.57           O  
ATOM   1901  CB  GLU B  49      40.878  35.986  26.375  1.00 36.27           C  
ATOM   1902  CG  GLU B  49      41.400  36.947  25.324  1.00 34.76           C  
ATOM   1903  CD  GLU B  49      41.292  38.380  25.782  1.00 40.34           C  
ATOM   1904  OE1 GLU B  49      41.770  38.672  26.892  1.00 35.34           O  
ATOM   1905  OE2 GLU B  49      40.742  39.211  25.039  1.00 39.92           O  
ATOM   1906  N   TYR B  50      43.297  34.240  26.938  1.00 38.00           N  
ATOM   1907  CA  TYR B  50      44.749  34.024  26.918  1.00 35.43           C  
ATOM   1908  C   TYR B  50      45.155  32.627  26.457  1.00 38.43           C  
ATOM   1909  O   TYR B  50      46.149  32.492  25.742  1.00 38.19           O  
ATOM   1910  CB  TYR B  50      45.342  34.341  28.288  1.00 36.95           C  
ATOM   1911  CG  TYR B  50      46.852  34.256  28.352  1.00 36.87           C  
ATOM   1912  CD1 TYR B  50      47.645  35.150  27.632  1.00 42.97           C  
ATOM   1913  CD2 TYR B  50      47.480  33.316  29.148  1.00 33.95           C  
ATOM   1914  CE1 TYR B  50      49.039  35.095  27.683  1.00 45.65           C  
ATOM   1915  CE2 TYR B  50      48.905  33.245  29.210  1.00 39.27           C  
ATOM   1916  CZ  TYR B  50      49.659  34.147  28.489  1.00 41.61           C  
ATOM   1917  OH  TYR B  50      51.031  34.111  28.542  1.00 44.98           O  
ATOM   1918  N   SER B  51      44.392  31.599  26.847  1.00 38.16           N  
ATOM   1919  CA  SER B  51      44.681  30.222  26.431  1.00 38.79           C  
ATOM   1920  C   SER B  51      44.623  30.073  24.921  1.00 38.10           C  
ATOM   1921  O   SER B  51      45.490  29.444  24.353  1.00 33.77           O  
ATOM   1922  CB  SER B  51      43.727  29.213  27.068  1.00 39.94           C  
ATOM   1923  OG  SER B  51      43.661  29.430  28.461  1.00 48.11           O  
ATOM   1924  N   TRP B  52      43.606  30.660  24.287  1.00 38.12           N  
ATOM   1925  CA  TRP B  52      43.492  30.629  22.811  1.00 37.80           C  
ATOM   1926  C   TRP B  52      44.568  31.443  22.101  1.00 38.24           C  
ATOM   1927  O   TRP B  52      45.087  31.016  21.057  1.00 38.55           O  
ATOM   1928  CB  TRP B  52      42.103  31.073  22.367  1.00 37.90           C  
ATOM   1929  CG  TRP B  52      41.074  30.023  22.550  1.00 36.27           C  
ATOM   1930  CD1 TRP B  52      40.072  30.024  23.444  1.00 38.43           C  
ATOM   1931  CD2 TRP B  52      40.964  28.795  21.817  1.00 35.63           C  
ATOM   1932  NE1 TRP B  52      39.327  28.886  23.323  1.00 37.56           N  
ATOM   1933  CE2 TRP B  52      39.847  28.111  22.326  1.00 38.54           C  
ATOM   1934  CE3 TRP B  52      41.700  28.212  20.769  1.00 40.20           C  
ATOM   1935  CZ2 TRP B  52      39.439  26.868  21.837  1.00 42.03           C  
ATOM   1936  CZ3 TRP B  52      41.307  26.970  20.293  1.00 42.34           C  
ATOM   1937  CH2 TRP B  52      40.173  26.319  20.817  1.00 37.25           C  
ATOM   1938  N   ILE B  53      44.910  32.604  22.657  1.00 40.94           N  
ATOM   1939  CA  ILE B  53      46.009  33.430  22.120  1.00 42.89           C  
ATOM   1940  C   ILE B  53      47.349  32.683  22.210  1.00 42.38           C  
ATOM   1941  O   ILE B  53      48.144  32.746  21.276  1.00 43.33           O  
ATOM   1942  CB  ILE B  53      46.020  34.853  22.765  1.00 45.21           C  
ATOM   1943  CG1 ILE B  53      44.763  35.634  22.322  1.00 44.03           C  
ATOM   1944  CG2 ILE B  53      47.274  35.631  22.408  1.00 47.83           C  
ATOM   1945  CD1 ILE B  53      44.734  36.039  20.879  1.00 53.56           C  
ATOM   1946  N   ARG B  54      47.578  31.958  23.304  1.00 40.67           N  
ATOM   1947  CA  ARG B  54      48.770  31.101  23.460  1.00 40.88           C  
ATOM   1948  C   ARG B  54      48.802  29.945  22.450  1.00 40.86           C  
ATOM   1949  O   ARG B  54      49.885  29.555  21.985  1.00 38.66           O  
ATOM   1950  CB  ARG B  54      48.838  30.524  24.878  1.00 41.58           C  
ATOM   1951  CG  ARG B  54      49.155  31.571  25.930  1.00 48.42           C  
ATOM   1952  CD  ARG B  54      50.630  31.831  26.032  1.00 52.32           C  
ATOM   1953  NE  ARG B  54      51.294  30.764  26.770  1.00 53.82           N  
ATOM   1954  CZ  ARG B  54      52.554  30.789  27.194  1.00 52.34           C  
ATOM   1955  NH1 ARG B  54      53.341  31.854  26.990  1.00 54.20           N  
ATOM   1956  NH2 ARG B  54      53.027  29.737  27.851  1.00 49.63           N  
ATOM   1957  N   ALA B  55      47.629  29.376  22.158  1.00 40.65           N  
ATOM   1958  CA  ALA B  55      47.485  28.303  21.152  1.00 40.41           C  
ATOM   1959  C   ALA B  55      47.830  28.858  19.755  1.00 40.23           C  
ATOM   1960  O   ALA B  55      48.524  28.188  18.986  1.00 41.53           O  
ATOM   1961  CB  ALA B  55      46.084  27.708  21.168  1.00 39.41           C  
ATOM   1962  N   ILE B  56      47.355  30.067  19.453  1.00 39.68           N  
ATOM   1963  CA  ILE B  56      47.682  30.793  18.206  1.00 41.79           C  
ATOM   1964  C   ILE B  56      49.215  30.963  18.080  1.00 44.72           C  
ATOM   1965  O   ILE B  56      49.767  30.678  17.010  1.00 46.11           O  
ATOM   1966  CB  ILE B  56      46.917  32.139  18.105  1.00 39.73           C  
ATOM   1967  CG1 ILE B  56      45.435  31.880  17.824  1.00 40.47           C  
ATOM   1968  CG2 ILE B  56      47.522  33.052  17.005  1.00 42.93           C  
ATOM   1969  CD1 ILE B  56      44.521  33.104  17.914  1.00 40.35           C  
ATOM   1970  N   GLN B  57      49.898  31.358  19.172  1.00 46.69           N  
ATOM   1971  CA  GLN B  57      51.381  31.469  19.221  0.50 45.87           C  
ATOM   1973  C   GLN B  57      52.059  30.126  19.118  1.00 47.43           C  
ATOM   1974  O   GLN B  57      53.245  30.028  18.795  1.00 48.85           O  
ATOM   1975  CB  GLN B  57      51.886  32.065  20.541  0.50 46.95           C  
ATOM   1977  CG  GLN B  57      51.738  33.531  20.704  0.50 46.66           C  
ATOM   1979  CD  GLN B  57      52.243  33.980  22.062  0.50 47.23           C  
ATOM   1981  OE1 GLN B  57      53.305  34.590  22.175  0.50 44.19           O  
ATOM   1983  NE2 GLN B  57      51.494  33.650  23.104  0.50 50.17           N  
ATOM   1985  N   GLY B  58      51.328  29.067  19.447  1.00 47.19           N  
ATOM   1986  CA  GLY B  58      51.842  27.723  19.430  1.00 45.48           C  
ATOM   1987  C   GLY B  58      52.651  27.422  20.664  1.00 47.58           C  
ATOM   1988  O   GLY B  58      53.467  26.525  20.634  1.00 45.43           O  
ATOM   1989  N   LYS B  59      52.406  28.147  21.760  1.00 48.27           N  
ATOM   1990  CA  LYS B  59      53.135  27.920  23.011  1.00 49.64           C  
ATOM   1991  C   LYS B  59      52.471  26.824  23.821  1.00 50.41           C  
ATOM   1992  O   LYS B  59      51.303  26.481  23.581  1.00 50.46           O  
ATOM   1993  CB  LYS B  59      53.244  29.204  23.819  1.00 49.15           C  
ATOM   1994  CG  LYS B  59      54.103  30.216  23.117  1.00 54.13           C  
ATOM   1995  CD  LYS B  59      54.275  31.456  23.929  1.00 60.54           C  
ATOM   1996  CE  LYS B  59      55.317  32.367  23.324  1.00 62.67           C  
ATOM   1997  NZ  LYS B  59      55.340  33.672  24.031  1.00 63.74           N  
ATOM   1998  N   GLU B  60      53.232  26.276  24.777  1.00 50.71           N  
ATOM   1999  CA  GLU B  60      52.758  25.232  25.684  1.00 51.25           C  
ATOM   2000  C   GLU B  60      51.574  25.786  26.447  1.00 52.72           C  
ATOM   2001  O   GLU B  60      51.503  26.999  26.702  1.00 51.99           O  
ATOM   2002  CB  GLU B  60      53.846  24.771  26.666  1.00 50.21           C  
ATOM   2003  N   ASP B  61      50.651  24.896  26.795  1.00 56.00           N  
ATOM   2004  CA  ASP B  61      49.396  25.299  27.431  1.00 58.85           C  
ATOM   2005  C   ASP B  61      49.612  26.122  28.743  1.00 60.62           C  
ATOM   2006  O   ASP B  61      49.497  27.356  28.691  1.00 64.54           O  
ATOM   2007  CB  ASP B  61      48.467  24.078  27.606  1.00 59.15           C  
ATOM   2008  CG  ASP B  61      47.044  24.459  27.969  1.00 54.27           C  
ATOM   2009  OD1 ASP B  61      46.740  25.670  28.022  1.00 46.96           O  
ATOM   2010  OD2 ASP B  61      46.230  23.536  28.185  1.00 48.40           O  
ATOM   2011  N   ILE B  62      49.933  25.477  29.864  1.00 60.23           N  
ATOM   2012  CA  ILE B  62      50.144  26.172  31.166  1.00 59.87           C  
ATOM   2013  C   ILE B  62      48.891  26.971  31.619  1.00 57.57           C  
ATOM   2014  O   ILE B  62      48.769  28.172  31.360  1.00 57.43           O  
ATOM   2015  CB  ILE B  62      51.404  27.084  31.146  1.00 60.24           C  
ATOM   2016  N   ALA B  63      47.979  26.270  32.298  1.00 54.54           N  
ATOM   2017  CA  ALA B  63      46.706  26.819  32.772  1.00 49.84           C  
ATOM   2018  C   ALA B  63      46.797  27.410  34.179  1.00 48.85           C  
ATOM   2019  O   ALA B  63      47.072  26.686  35.142  1.00 43.79           O  
ATOM   2020  CB  ALA B  63      45.641  25.736  32.759  1.00 49.02           C  
ATOM   2021  N   VAL B  64      46.570  28.723  34.275  1.00 47.11           N  
ATOM   2022  CA  VAL B  64      46.475  29.445  35.549  1.00 46.68           C  
ATOM   2023  C   VAL B  64      45.252  28.906  36.324  1.00 43.28           C  
ATOM   2024  O   VAL B  64      44.225  28.585  35.713  1.00 43.30           O  
ATOM   2025  CB  VAL B  64      46.390  30.987  35.284  1.00 48.73           C  
ATOM   2026  CG1 VAL B  64      45.821  31.732  36.450  1.00 54.00           C  
ATOM   2027  CG2 VAL B  64      47.767  31.526  34.918  1.00 50.60           C  
ATOM   2028  N   GLN B  65      45.377  28.803  37.649  1.00 41.87           N  
ATOM   2029  CA  GLN B  65      44.351  28.221  38.523  1.00 41.19           C  
ATOM   2030  C   GLN B  65      43.575  29.298  39.281  1.00 40.59           C  
ATOM   2031  O   GLN B  65      44.192  30.148  39.922  1.00 38.39           O  
ATOM   2032  CB  GLN B  65      45.013  27.258  39.520  1.00 42.38           C  
ATOM   2033  CG  GLN B  65      45.857  26.139  38.866  1.00 43.78           C  
ATOM   2034  CD  GLN B  65      45.014  25.206  38.016  1.00 48.50           C  
ATOM   2035  OE1 GLN B  65      44.272  24.376  38.547  1.00 49.34           O  
ATOM   2036  NE2 GLN B  65      45.118  25.336  36.687  1.00 42.49           N  
ATOM   2037  N   PHE B  66      42.237  29.244  39.233  1.00 39.82           N  
ATOM   2038  CA  PHE B  66      41.382  30.230  39.929  1.00 40.42           C  
ATOM   2039  C   PHE B  66      41.685  30.368  41.444  1.00 41.00           C  
ATOM   2040  O   PHE B  66      41.593  31.475  41.995  1.00 40.53           O  
ATOM   2041  CB  PHE B  66      39.898  29.947  39.656  1.00 38.00           C  
ATOM   2042  CG  PHE B  66      38.943  30.922  40.313  1.00 39.02           C  
ATOM   2043  CD1 PHE B  66      39.109  32.308  40.165  1.00 33.55           C  
ATOM   2044  CD2 PHE B  66      37.833  30.460  41.024  1.00 40.63           C  
ATOM   2045  CE1 PHE B  66      38.213  33.213  40.741  1.00 36.65           C  
ATOM   2046  CE2 PHE B  66      36.934  31.360  41.592  1.00 39.28           C  
ATOM   2047  CZ  PHE B  66      37.132  32.747  41.452  1.00 34.96           C  
ATOM   2048  N   ALA B  67      42.091  29.262  42.087  1.00 42.65           N  
ATOM   2049  CA  ALA B  67      42.497  29.247  43.514  1.00 40.66           C  
ATOM   2050  C   ALA B  67      43.557  30.307  43.875  1.00 40.69           C  
ATOM   2051  O   ALA B  67      43.551  30.827  44.991  1.00 38.61           O  
ATOM   2052  CB  ALA B  67      42.995  27.847  43.928  1.00 40.78           C  
ATOM   2053  N   ASP B  68      44.440  30.641  42.925  1.00 39.39           N  
ATOM   2054  CA  ASP B  68      45.470  31.678  43.140  1.00 39.59           C  
ATOM   2055  C   ASP B  68      44.997  33.128  42.869  1.00 39.40           C  
ATOM   2056  O   ASP B  68      45.795  34.054  42.993  1.00 40.68           O  
ATOM   2057  CB  ASP B  68      46.704  31.349  42.281  1.00 39.01           C  
ATOM   2058  CG  ASP B  68      47.320  29.987  42.628  1.00 42.70           C  
ATOM   2059  OD1 ASP B  68      47.360  29.639  43.829  1.00 48.72           O  
ATOM   2060  OD2 ASP B  68      47.777  29.272  41.703  1.00 44.16           O  
ATOM   2061  N   TYR B  69      43.724  33.319  42.506  1.00 39.45           N  
ATOM   2062  CA  TYR B  69      43.163  34.634  42.109  1.00 39.39           C  
ATOM   2063  C   TYR B  69      41.763  34.776  42.704  1.00 39.28           C  
ATOM   2064  O   TYR B  69      40.766  34.863  41.985  1.00 42.51           O  
ATOM   2065  CB  TYR B  69      43.169  34.773  40.561  1.00 38.76           C  
ATOM   2066  CG  TYR B  69      44.556  34.666  39.958  1.00 37.82           C  
ATOM   2067  CD1 TYR B  69      45.113  33.418  39.654  1.00 41.93           C  
ATOM   2068  CD2 TYR B  69      45.332  35.806  39.714  1.00 34.58           C  
ATOM   2069  CE1 TYR B  69      46.423  33.300  39.135  1.00 41.82           C  
ATOM   2070  CE2 TYR B  69      46.638  35.705  39.193  1.00 39.37           C  
ATOM   2071  CZ  TYR B  69      47.171  34.444  38.895  1.00 43.52           C  
ATOM   2072  OH  TYR B  69      48.444  34.336  38.388  1.00 44.68           O  
ATOM   2073  N   GLN B  70      41.717  34.818  44.037  1.00 38.30           N  
ATOM   2074  CA  GLN B  70      40.449  34.872  44.809  1.00 39.39           C  
ATOM   2075  C   GLN B  70      39.965  36.273  45.219  1.00 37.90           C  
ATOM   2076  O   GLN B  70      39.085  36.388  46.087  1.00 37.21           O  
ATOM   2077  CB  GLN B  70      40.584  33.961  46.049  1.00 41.32           C  
ATOM   2078  CG  GLN B  70      40.749  32.502  45.687  1.00 44.85           C  
ATOM   2079  CD  GLN B  70      39.503  31.932  45.072  1.00 37.81           C  
ATOM   2080  OE1 GLN B  70      38.488  31.799  45.741  1.00 43.30           O  
ATOM   2081  NE2 GLN B  70      39.570  31.590  43.794  1.00 43.85           N  
ATOM   2082  N   THR B  71      40.528  37.328  44.614  1.00 36.08           N  
ATOM   2083  CA  THR B  71      40.097  38.708  44.892  1.00 35.41           C  
ATOM   2084  C   THR B  71      39.969  39.500  43.586  1.00 34.68           C  
ATOM   2085  O   THR B  71      40.597  39.149  42.571  1.00 34.77           O  
ATOM   2086  CB  THR B  71      41.045  39.465  45.841  1.00 34.54           C  
ATOM   2087  OG1 THR B  71      42.276  39.771  45.172  1.00 32.89           O  
ATOM   2088  CG2 THR B  71      41.329  38.668  47.151  1.00 34.99           C  
ATOM   2089  N   LEU B  72      39.165  40.567  43.642  1.00 34.72           N  
ATOM   2090  CA  LEU B  72      38.965  41.488  42.512  1.00 35.33           C  
ATOM   2091  C   LEU B  72      40.309  42.045  42.039  1.00 34.20           C  
ATOM   2092  O   LEU B  72      40.605  42.012  40.849  1.00 33.27           O  
ATOM   2093  CB  LEU B  72      38.014  42.640  42.893  1.00 35.37           C  
ATOM   2094  CG  LEU B  72      37.684  43.707  41.825  1.00 34.44           C  
ATOM   2095  CD1 LEU B  72      37.030  43.060  40.602  1.00 33.81           C  
ATOM   2096  CD2 LEU B  72      36.805  44.811  42.371  1.00 36.07           C  
ATOM   2097  N   ASN B  73      41.123  42.520  42.985  1.00 34.09           N  
ATOM   2098  CA  ASN B  73      42.458  43.079  42.665  1.00 33.60           C  
ATOM   2099  C   ASN B  73      43.398  42.090  41.970  1.00 33.41           C  
ATOM   2100  O   ASN B  73      44.115  42.481  41.029  1.00 34.26           O  
ATOM   2101  CB  ASN B  73      43.123  43.665  43.920  1.00 33.73           C  
ATOM   2102  CG  ASN B  73      42.411  44.914  44.438  1.00 38.38           C  
ATOM   2103  OD1 ASN B  73      41.430  45.381  43.844  1.00 46.32           O  
ATOM   2104  ND2 ASN B  73      42.897  45.456  45.557  1.00 34.07           N  
ATOM   2105  N   LYS B  74      43.392  40.829  42.416  1.00 32.33           N  
ATOM   2106  CA  LYS B  74      44.229  39.779  41.785  1.00 34.24           C  
ATOM   2107  C   LYS B  74      43.733  39.424  40.385  1.00 34.41           C  
ATOM   2108  O   LYS B  74      44.544  39.247  39.475  1.00 34.44           O  
ATOM   2109  CB  LYS B  74      44.325  38.526  42.657  1.00 35.15           C  
ATOM   2110  CG  LYS B  74      45.143  38.785  43.916  1.00 34.60           C  
ATOM   2111  CD  LYS B  74      45.330  37.554  44.800  1.00 42.06           C  
ATOM   2112  CE  LYS B  74      46.624  36.796  44.458  1.00 50.24           C  
ATOM   2113  NZ  LYS B  74      46.871  35.650  45.385  1.00 48.85           N  
ATOM   2114  N   VAL B  75      42.411  39.348  40.210  1.00 35.23           N  
ATOM   2115  CA  VAL B  75      41.836  39.074  38.875  1.00 35.11           C  
ATOM   2116  C   VAL B  75      42.117  40.250  37.925  1.00 35.52           C  
ATOM   2117  O   VAL B  75      42.486  40.029  36.765  1.00 34.75           O  
ATOM   2118  CB  VAL B  75      40.330  38.731  38.928  1.00 36.44           C  
ATOM   2119  CG1 VAL B  75      39.762  38.555  37.507  1.00 35.38           C  
ATOM   2120  CG2 VAL B  75      40.117  37.463  39.763  1.00 34.75           C  
ATOM   2121  N   LYS B  76      41.958  41.479  38.423  1.00 34.76           N  
ATOM   2122  CA  LYS B  76      42.265  42.691  37.635  1.00 36.95           C  
ATOM   2123  C   LYS B  76      43.742  42.735  37.232  1.00 37.94           C  
ATOM   2124  O   LYS B  76      44.050  43.092  36.091  1.00 39.40           O  
ATOM   2125  CB  LYS B  76      41.853  43.963  38.387  1.00 36.87           C  
ATOM   2126  CG  LYS B  76      42.131  45.266  37.619  1.00 44.18           C  
ATOM   2127  N   SER B  77      44.645  42.359  38.147  1.00 37.18           N  
ATOM   2128  CA  SER B  77      46.092  42.289  37.838  1.00 37.96           C  
ATOM   2129  C   SER B  77      46.415  41.230  36.772  1.00 36.95           C  
ATOM   2130  O   SER B  77      47.234  41.484  35.900  1.00 34.03           O  
ATOM   2131  CB  SER B  77      46.924  42.036  39.098  1.00 39.54           C  
ATOM   2132  OG  SER B  77      46.763  43.130  39.980  1.00 42.95           O  
ATOM   2133  N   LEU B  78      45.746  40.074  36.842  1.00 36.80           N  
ATOM   2134  CA  LEU B  78      45.911  38.984  35.865  1.00 36.40           C  
ATOM   2135  C   LEU B  78      45.535  39.438  34.461  1.00 36.39           C  
ATOM   2136  O   LEU B  78      46.238  39.133  33.503  1.00 33.67           O  
ATOM   2137  CB  LEU B  78      45.059  37.768  36.248  1.00 36.77           C  
ATOM   2138  CG  LEU B  78      45.250  36.480  35.454  1.00 34.90           C  
ATOM   2139  CD1 LEU B  78      46.673  35.966  35.615  1.00 39.20           C  
ATOM   2140  CD2 LEU B  78      44.237  35.446  35.926  1.00 37.85           C  
ATOM   2141  N   SER B  79      44.404  40.150  34.360  1.00 36.76           N  
ATOM   2142  CA  SER B  79      43.932  40.750  33.107  1.00 36.43           C  
ATOM   2143  C   SER B  79      45.024  41.629  32.515  1.00 37.84           C  
ATOM   2144  O   SER B  79      45.357  41.501  31.330  1.00 36.35           O  
ATOM   2145  CB  SER B  79      42.674  41.594  33.347  1.00 33.96           C  
ATOM   2146  OG  SER B  79      42.142  42.089  32.127  1.00 36.01           O  
ATOM   2147  N   ASN B  80      45.606  42.489  33.357  1.00 37.25           N  
ATOM   2148  CA  ASN B  80      46.695  43.374  32.926  1.00 39.71           C  
ATOM   2149  C   ASN B  80      47.973  42.639  32.516  1.00 39.93           C  
ATOM   2150  O   ASN B  80      48.622  43.042  31.566  1.00 39.59           O  
ATOM   2151  CB  ASN B  80      47.053  44.403  34.019  1.00 40.89           C  
ATOM   2152  CG  ASN B  80      45.939  45.401  34.298  1.00 46.41           C  
ATOM   2153  OD1 ASN B  80      44.997  45.558  33.519  1.00 50.58           O  
ATOM   2154  ND2 ASN B  80      46.061  46.100  35.428  1.00 50.41           N  
ATOM   2155  N   THR B  81      48.319  41.569  33.230  1.00 39.50           N  
ATOM   2156  CA  THR B  81      49.530  40.795  32.950  1.00 39.70           C  
ATOM   2157  C   THR B  81      49.604  40.263  31.515  1.00 39.76           C  
ATOM   2158  O   THR B  81      50.657  40.345  30.880  1.00 40.48           O  
ATOM   2159  CB  THR B  81      49.683  39.624  33.949  1.00 40.49           C  
ATOM   2160  OG1 THR B  81      49.742  40.154  35.274  1.00 44.32           O  
ATOM   2161  CG2 THR B  81      50.964  38.838  33.696  1.00 42.65           C  
ATOM   2162  N   PHE B  82      48.482  39.766  31.002  1.00 40.60           N  
ATOM   2163  CA  PHE B  82      48.437  39.165  29.663  1.00 40.87           C  
ATOM   2164  C   PHE B  82      48.169  40.105  28.483  1.00 42.30           C  
ATOM   2165  O   PHE B  82      48.449  39.723  27.352  1.00 40.78           O  
ATOM   2166  CB  PHE B  82      47.357  38.082  29.616  1.00 40.01           C  
ATOM   2167  CG  PHE B  82      47.515  36.967  30.635  1.00 39.50           C  
ATOM   2168  CD1 PHE B  82      48.776  36.450  30.990  1.00 41.43           C  
ATOM   2169  CD2 PHE B  82      46.381  36.338  31.142  1.00 41.60           C  
ATOM   2170  CE1 PHE B  82      48.881  35.381  31.886  1.00 40.64           C  
ATOM   2171  CE2 PHE B  82      46.484  35.261  32.034  1.00 42.08           C  
ATOM   2172  CZ  PHE B  82      47.733  34.784  32.401  1.00 39.22           C  
ATOM   2173  N   ARG B  83      47.633  41.303  28.739  1.00 42.66           N  
ATOM   2174  CA  ARG B  83      47.239  42.255  27.682  1.00 41.28           C  
ATOM   2175  C   ARG B  83      48.266  42.535  26.597  1.00 41.07           C  
ATOM   2176  O   ARG B  83      47.954  42.449  25.404  1.00 40.85           O  
ATOM   2177  CB  ARG B  83      46.861  43.612  28.306  1.00 43.33           C  
ATOM   2178  CG  ARG B  83      46.360  44.700  27.334  1.00 42.18           C  
ATOM   2179  CD  ARG B  83      45.229  44.247  26.448  1.00 39.92           C  
ATOM   2180  NE  ARG B  83      44.150  43.713  27.251  1.00 45.99           N  
ATOM   2181  CZ  ARG B  83      43.274  44.427  27.953  1.00 33.90           C  
ATOM   2182  NH1 ARG B  83      43.308  45.756  28.014  1.00 38.07           N  
ATOM   2183  NH2 ARG B  83      42.352  43.786  28.645  1.00 35.43           N  
ATOM   2184  N   THR B  84      49.473  42.923  27.007  1.00 40.99           N  
ATOM   2185  CA  THR B  84      50.527  43.273  26.030  1.00 41.67           C  
ATOM   2186  C   THR B  84      50.910  42.064  25.174  1.00 38.80           C  
ATOM   2187  O   THR B  84      51.056  42.202  23.965  1.00 40.41           O  
ATOM   2188  CB  THR B  84      51.748  43.928  26.695  1.00 42.46           C  
ATOM   2189  OG1 THR B  84      52.202  43.094  27.759  1.00 54.66           O  
ATOM   2190  CG2 THR B  84      51.358  45.281  27.260  1.00 40.26           C  
ATOM   2191  N   GLU B  85      50.976  40.876  25.774  1.00 40.48           N  
ATOM   2192  CA  GLU B  85      51.237  39.650  25.004  1.00 40.38           C  
ATOM   2193  C   GLU B  85      50.121  39.406  24.005  1.00 40.74           C  
ATOM   2194  O   GLU B  85      50.404  39.137  22.843  1.00 40.42           O  
ATOM   2195  CB  GLU B  85      51.407  38.422  25.890  1.00 39.45           C  
ATOM   2196  CG  GLU B  85      51.876  37.176  25.103  1.00 41.53           C  
ATOM   2197  CD  GLU B  85      52.141  35.965  25.971  1.00 43.10           C  
ATOM   2198  OE1 GLU B  85      52.152  36.104  27.215  1.00 42.20           O  
ATOM   2199  OE2 GLU B  85      52.341  34.864  25.400  1.00 47.87           O  
ATOM   2200  N   ILE B  86      48.865  39.542  24.457  1.00 38.98           N  
ATOM   2201  CA  ILE B  86      47.683  39.356  23.608  1.00 36.78           C  
ATOM   2202  C   ILE B  86      47.705  40.334  22.416  1.00 38.41           C  
ATOM   2203  O   ILE B  86      47.487  39.907  21.278  1.00 37.47           O  
ATOM   2204  CB  ILE B  86      46.334  39.455  24.441  1.00 35.60           C  
ATOM   2205  CG1 ILE B  86      46.205  38.229  25.351  1.00 34.55           C  
ATOM   2206  CG2 ILE B  86      45.100  39.580  23.523  1.00 35.06           C  
ATOM   2207  CD1 ILE B  86      45.104  38.307  26.404  1.00 36.00           C  
ATOM   2208  N   ILE B  87      47.994  41.611  22.675  1.00 36.44           N  
ATOM   2209  CA  ILE B  87      48.087  42.616  21.601  1.00 38.08           C  
ATOM   2210  C   ILE B  87      49.183  42.244  20.571  1.00 39.79           C  
ATOM   2211  O   ILE B  87      48.938  42.299  19.364  1.00 42.40           O  
ATOM   2212  CB  ILE B  87      48.326  44.051  22.153  1.00 38.52           C  
ATOM   2213  CG1 ILE B  87      47.085  44.559  22.898  1.00 38.97           C  
ATOM   2214  CG2 ILE B  87      48.652  45.031  21.021  1.00 40.47           C  
ATOM   2215  CD1 ILE B  87      47.316  45.851  23.671  1.00 40.98           C  
ATOM   2216  N   ASP B  88      50.362  41.868  21.051  1.00 41.87           N  
ATOM   2217  CA  ASP B  88      51.490  41.483  20.176  1.00 43.45           C  
ATOM   2218  C   ASP B  88      51.132  40.288  19.285  1.00 43.69           C  
ATOM   2219  O   ASP B  88      51.397  40.314  18.066  1.00 41.96           O  
ATOM   2220  CB  ASP B  88      52.764  41.189  21.000  1.00 45.54           C  
ATOM   2221  CG  ASP B  88      53.383  42.454  21.639  1.00 51.21           C  
ATOM   2222  OD1 ASP B  88      52.933  43.598  21.358  1.00 56.98           O  
ATOM   2223  OD2 ASP B  88      54.347  42.293  22.429  1.00 58.79           O  
ATOM   2224  N   VAL B  89      50.486  39.280  19.884  1.00 42.12           N  
ATOM   2225  CA  VAL B  89      50.053  38.083  19.155  1.00 42.40           C  
ATOM   2226  C   VAL B  89      49.034  38.438  18.090  1.00 42.84           C  
ATOM   2227  O   VAL B  89      49.160  37.981  16.959  1.00 44.29           O  
ATOM   2228  CB  VAL B  89      49.463  36.982  20.081  1.00 41.79           C  
ATOM   2229  CG1 VAL B  89      48.960  35.780  19.255  1.00 44.61           C  
ATOM   2230  CG2 VAL B  89      50.512  36.546  21.057  1.00 38.65           C  
ATOM   2231  N   LEU B  90      48.044  39.251  18.448  1.00 42.23           N  
ATOM   2232  CA  LEU B  90      47.028  39.703  17.491  1.00 42.89           C  
ATOM   2233  C   LEU B  90      47.663  40.446  16.307  1.00 44.75           C  
ATOM   2234  O   LEU B  90      47.336  40.152  15.156  1.00 45.74           O  
ATOM   2235  CB  LEU B  90      45.957  40.565  18.180  1.00 41.90           C  
ATOM   2236  CG  LEU B  90      45.015  39.809  19.139  1.00 45.18           C  
ATOM   2237  CD1 LEU B  90      44.158  40.809  19.898  1.00 40.99           C  
ATOM   2238  CD2 LEU B  90      44.151  38.793  18.377  1.00 41.70           C  
ATOM   2239  N   GLN B  91      48.590  41.358  16.604  1.00 44.12           N  
ATOM   2240  CA  GLN B  91      49.322  42.122  15.586  1.00 46.55           C  
ATOM   2241  C   GLN B  91      50.163  41.209  14.676  1.00 46.47           C  
ATOM   2242  O   GLN B  91      50.187  41.398  13.470  1.00 48.19           O  
ATOM   2243  CB  GLN B  91      50.214  43.186  16.247  1.00 46.81           C  
ATOM   2244  CG  GLN B  91      49.439  44.347  16.890  1.00 48.92           C  
ATOM   2245  CD  GLN B  91      50.335  45.357  17.642  1.00 51.92           C  
ATOM   2246  OE1 GLN B  91      51.485  45.072  17.997  1.00 61.81           O  
ATOM   2247  NE2 GLN B  91      49.789  46.546  17.888  1.00 58.26           N  
ATOM   2248  N   THR B  92      50.824  40.219  15.280  1.00 45.16           N  
ATOM   2249  CA  THR B  92      51.638  39.219  14.586  1.00 45.18           C  
ATOM   2250  C   THR B  92      50.843  38.291  13.651  1.00 42.19           C  
ATOM   2251  O   THR B  92      51.418  37.740  12.715  1.00 41.14           O  
ATOM   2252  CB  THR B  92      52.410  38.351  15.632  1.00 44.08           C  
ATOM   2253  OG1 THR B  92      53.250  39.211  16.391  1.00 52.35           O  
ATOM   2254  CG2 THR B  92      53.279  37.264  14.991  1.00 50.93           C  
ATOM   2255  N   HIS B  93      49.544  38.126  13.906  1.00 39.00           N  
ATOM   2256  CA  HIS B  93      48.646  37.269  13.128  1.00 38.24           C  
ATOM   2257  C   HIS B  93      47.544  38.106  12.447  1.00 39.95           C  
ATOM   2258  O   HIS B  93      46.370  37.745  12.450  1.00 41.82           O  
ATOM   2259  CB  HIS B  93      48.094  36.197  14.064  1.00 38.83           C  
ATOM   2260  CG  HIS B  93      49.138  35.233  14.543  1.00 39.65           C  
ATOM   2261  ND1 HIS B  93      49.263  33.962  14.029  1.00 39.32           N  
ATOM   2262  CD2 HIS B  93      50.134  35.368  15.455  1.00 40.44           C  
ATOM   2263  CE1 HIS B  93      50.282  33.351  14.614  1.00 43.16           C  
ATOM   2264  NE2 HIS B  93      50.833  34.183  15.476  1.00 39.50           N  
ATOM   2265  N   SER B  94      47.968  39.200  11.821  1.00 42.16           N  
ATOM   2266  CA  SER B  94      47.066  40.196  11.232  1.00 43.43           C  
ATOM   2267  C   SER B  94      46.957  40.162   9.712  1.00 43.05           C  
ATOM   2268  O   SER B  94      46.292  41.024   9.127  1.00 43.79           O  
ATOM   2269  CB  SER B  94      47.561  41.580  11.661  1.00 41.63           C  
ATOM   2270  OG  SER B  94      48.867  41.799  11.178  1.00 43.74           O  
ATOM   2271  N   ASP B  95      47.553  39.154   9.065  1.00 39.22           N  
ATOM   2272  CA  ASP B  95      47.619  39.128   7.599  1.00 35.73           C  
ATOM   2273  C   ASP B  95      46.345  38.533   6.992  1.00 35.61           C  
ATOM   2274  O   ASP B  95      45.403  38.223   7.718  1.00 34.68           O  
ATOM   2275  CB  ASP B  95      48.950  38.480   7.124  1.00 34.91           C  
ATOM   2276  CG  ASP B  95      49.006  36.979   7.289  1.00 35.14           C  
ATOM   2277  OD1 ASP B  95      47.981  36.351   7.541  1.00 34.47           O  
ATOM   2278  OD2 ASP B  95      50.121  36.432   7.142  1.00 33.14           O  
ATOM   2279  N   GLN B  96      46.343  38.340   5.673  1.00 35.18           N  
ATOM   2280  CA  GLN B  96      45.160  37.838   4.965  0.50 36.03           C  
ATOM   2282  C   GLN B  96      45.011  36.307   5.003  1.00 36.93           C  
ATOM   2283  O   GLN B  96      44.008  35.776   4.520  1.00 35.87           O  
ATOM   2284  CB  GLN B  96      45.194  38.317   3.512  0.50 36.52           C  
ATOM   2286  CG  GLN B  96      45.245  39.848   3.349  0.50 37.18           C  
ATOM   2288  CD  GLN B  96      45.549  40.266   1.917  0.50 36.31           C  
ATOM   2290  OE1 GLN B  96      44.967  39.737   0.973  0.50 41.19           O  
ATOM   2292  NE2 GLN B  96      46.466  41.218   1.752  0.50 41.96           N  
ATOM   2294  N   ILE B  97      45.973  35.584   5.601  1.00 36.31           N  
ATOM   2295  CA  ILE B  97      45.901  34.112   5.630  1.00 36.71           C  
ATOM   2296  C   ILE B  97      45.076  33.718   6.877  1.00 38.05           C  
ATOM   2297  O   ILE B  97      45.558  33.082   7.827  1.00 36.91           O  
ATOM   2298  CB  ILE B  97      47.302  33.440   5.555  1.00 35.33           C  
ATOM   2299  CG1 ILE B  97      48.214  34.044   4.459  1.00 34.55           C  
ATOM   2300  CG2 ILE B  97      47.147  31.945   5.311  1.00 36.79           C  
ATOM   2301  CD1 ILE B  97      47.642  34.030   3.048  1.00 32.12           C  
ATOM   2302  N   LYS B  98      43.796  34.064   6.821  1.00 38.82           N  
ATOM   2303  CA  LYS B  98      42.896  33.926   7.988  1.00 41.30           C  
ATOM   2304  C   LYS B  98      42.521  32.488   8.341  1.00 39.13           C  
ATOM   2305  O   LYS B  98      42.093  32.240   9.473  1.00 37.23           O  
ATOM   2306  CB  LYS B  98      41.664  34.844   7.865  1.00 43.35           C  
ATOM   2307  CG  LYS B  98      40.720  34.703   6.677  1.00 49.81           C  
ATOM   2308  CD  LYS B  98      39.953  33.418   6.655  1.00 61.11           C  
ATOM   2309  CE  LYS B  98      38.671  33.523   5.853  1.00 64.98           C  
ATOM   2310  NZ  LYS B  98      37.932  32.227   5.826  1.00 74.10           N  
ATOM   2311  N   ASP B  99      42.689  31.556   7.396  1.00 36.41           N  
ATOM   2312  CA  ASP B  99      42.464  30.130   7.681  1.00 37.46           C  
ATOM   2313  C   ASP B  99      43.752  29.435   8.223  1.00 37.22           C  
ATOM   2314  O   ASP B  99      43.851  28.213   8.177  1.00 38.30           O  
ATOM   2315  CB  ASP B  99      41.848  29.376   6.485  1.00 38.69           C  
ATOM   2316  CG  ASP B  99      40.443  29.899   6.104  1.00 52.27           C  
ATOM   2317  OD1 ASP B  99      39.652  30.307   7.002  1.00 59.19           O  
ATOM   2318  OD2 ASP B  99      40.126  29.877   4.890  1.00 62.67           O  
ATOM   2319  N   GLU B 100      44.726  30.221   8.711  1.00 33.88           N  
ATOM   2320  CA  GLU B 100      45.912  29.708   9.398  1.00 35.47           C  
ATOM   2321  C   GLU B 100      45.454  28.662  10.427  1.00 32.62           C  
ATOM   2322  O   GLU B 100      44.597  28.962  11.248  1.00 35.62           O  
ATOM   2323  CB  GLU B 100      46.624  30.849  10.136  1.00 34.50           C  
ATOM   2324  CG  GLU B 100      47.813  30.409  10.997  1.00 39.41           C  
ATOM   2325  CD  GLU B 100      48.424  31.512  11.844  1.00 41.76           C  
ATOM   2326  OE1 GLU B 100      47.767  32.539  12.156  1.00 39.95           O  
ATOM   2327  OE2 GLU B 100      49.588  31.311  12.235  1.00 50.11           O  
ATOM   2328  N   LEU B 101      46.038  27.470  10.373  1.00 34.08           N  
ATOM   2329  CA  LEU B 101      45.688  26.371  11.251  1.00 31.46           C  
ATOM   2330  C   LEU B 101      46.374  26.499  12.592  1.00 32.56           C  
ATOM   2331  O   LEU B 101      47.559  26.829  12.642  1.00 31.31           O  
ATOM   2332  CB  LEU B 101      46.079  25.030  10.610  1.00 33.41           C  
ATOM   2333  CG  LEU B 101      45.370  24.743   9.292  1.00 30.66           C  
ATOM   2334  CD1 LEU B 101      45.779  23.418   8.684  1.00 33.84           C  
ATOM   2335  CD2 LEU B 101      43.824  24.824   9.518  1.00 29.55           C  
ATOM   2336  N   VAL B 102      45.609  26.219  13.657  1.00 32.46           N  
ATOM   2337  CA  VAL B 102      46.077  26.249  15.045  1.00 33.36           C  
ATOM   2338  C   VAL B 102      45.746  24.912  15.689  1.00 36.50           C  
ATOM   2339  O   VAL B 102      44.595  24.489  15.649  1.00 36.26           O  
ATOM   2340  CB  VAL B 102      45.402  27.391  15.828  1.00 34.68           C  
ATOM   2341  CG1 VAL B 102      45.900  27.444  17.293  1.00 32.77           C  
ATOM   2342  CG2 VAL B 102      45.603  28.727  15.088  1.00 30.28           C  
ATOM   2343  N   SER B 103      46.755  24.273  16.275  1.00 34.99           N  
ATOM   2344  CA  SER B 103      46.604  23.025  17.015  1.00 38.86           C  
ATOM   2345  C   SER B 103      46.107  23.362  18.425  1.00 40.67           C  
ATOM   2346  O   SER B 103      46.525  24.363  19.009  1.00 40.38           O  
ATOM   2347  CB  SER B 103      47.928  22.273  17.081  1.00 38.34           C  
ATOM   2348  OG  SER B 103      47.735  20.987  17.612  1.00 48.36           O  
ATOM   2349  N   VAL B 104      45.224  22.520  18.958  1.00 41.80           N  
ATOM   2350  CA  VAL B 104      44.568  22.734  20.254  1.00 43.29           C  
ATOM   2351  C   VAL B 104      45.223  21.761  21.235  1.00 42.80           C  
ATOM   2352  O   VAL B 104      45.008  20.556  21.119  1.00 42.22           O  
ATOM   2353  CB  VAL B 104      43.047  22.470  20.144  1.00 43.11           C  
ATOM   2354  CG1 VAL B 104      42.322  22.877  21.422  1.00 44.92           C  
ATOM   2355  CG2 VAL B 104      42.441  23.212  18.951  1.00 47.85           C  
ATOM   2356  N   PRO B 105      46.072  22.253  22.165  1.00 44.00           N  
ATOM   2357  CA  PRO B 105      46.754  21.348  23.129  1.00 44.58           C  
ATOM   2358  C   PRO B 105      45.859  20.435  23.994  1.00 43.96           C  
ATOM   2359  O   PRO B 105      46.280  19.332  24.353  1.00 43.99           O  
ATOM   2360  CB  PRO B 105      47.517  22.323  24.032  1.00 45.34           C  
ATOM   2361  CG  PRO B 105      47.727  23.488  23.216  1.00 45.76           C  
ATOM   2362  CD  PRO B 105      46.491  23.650  22.387  1.00 47.11           C  
ATOM   2363  N   TRP B 106      44.647  20.909  24.283  1.00 42.93           N  
ATOM   2364  CA  TRP B 106      43.622  20.216  25.096  1.00 43.24           C  
ATOM   2365  C   TRP B 106      42.606  19.391  24.275  1.00 45.48           C  
ATOM   2366  O   TRP B 106      41.631  18.888  24.838  1.00 47.01           O  
ATOM   2367  CB  TRP B 106      42.904  21.235  26.021  1.00 42.34           C  
ATOM   2368  CG  TRP B 106      42.325  22.416  25.321  1.00 42.28           C  
ATOM   2369  CD1 TRP B 106      41.108  22.505  24.725  1.00 40.54           C  
ATOM   2370  CD2 TRP B 106      42.974  23.676  25.110  1.00 41.01           C  
ATOM   2371  NE1 TRP B 106      40.957  23.750  24.155  1.00 46.04           N  
ATOM   2372  CE2 TRP B 106      42.083  24.490  24.382  1.00 41.46           C  
ATOM   2373  CE3 TRP B 106      44.228  24.194  25.463  1.00 39.08           C  
ATOM   2374  CZ2 TRP B 106      42.394  25.807  24.007  1.00 41.72           C  
ATOM   2375  CZ3 TRP B 106      44.544  25.500  25.091  1.00 42.81           C  
ATOM   2376  CH2 TRP B 106      43.630  26.293  24.367  1.00 43.90           C  
ATOM   2377  N   GLU B 107      42.815  19.270  22.959  1.00 48.65           N  
ATOM   2378  CA  GLU B 107      41.994  18.419  22.069  1.00 51.24           C  
ATOM   2379  C   GLU B 107      42.916  17.740  21.072  1.00 51.01           C  
ATOM   2380  O   GLU B 107      43.363  18.370  20.100  1.00 54.22           O  
ATOM   2381  CB  GLU B 107      40.929  19.192  21.276  1.00 50.94           C  
ATOM   2382  CG  GLU B 107      39.785  19.771  22.059  1.00 55.43           C  
ATOM   2383  CD  GLU B 107      38.639  20.209  21.144  1.00 53.92           C  
ATOM   2384  OE1 GLU B 107      38.036  19.328  20.492  1.00 57.19           O  
ATOM   2385  OE2 GLU B 107      38.325  21.421  21.089  1.00 59.97           O  
ATOM   2386  N   THR B 108      43.162  16.458  21.291  1.00 49.77           N  
ATOM   2387  CA  THR B 108      44.028  15.658  20.433  1.00 49.96           C  
ATOM   2388  C   THR B 108      43.487  15.587  19.007  1.00 47.48           C  
ATOM   2389  O   THR B 108      42.312  15.275  18.822  1.00 44.79           O  
ATOM   2390  CB  THR B 108      44.159  14.218  20.967  1.00 49.58           C  
ATOM   2391  OG1 THR B 108      44.254  14.246  22.400  1.00 54.57           O  
ATOM   2392  CG2 THR B 108      45.376  13.519  20.355  1.00 54.15           C  
ATOM   2393  N   GLY B 109      44.342  15.914  18.032  1.00 46.00           N  
ATOM   2394  CA  GLY B 109      44.018  15.871  16.601  1.00 44.27           C  
ATOM   2395  C   GLY B 109      42.995  16.848  16.057  1.00 43.60           C  
ATOM   2396  O   GLY B 109      42.475  16.650  14.956  1.00 44.76           O  
ATOM   2397  N   VAL B 110      42.705  17.894  16.814  1.00 40.48           N  
ATOM   2398  CA  VAL B 110      41.730  18.899  16.423  1.00 41.34           C  
ATOM   2399  C   VAL B 110      42.486  20.166  16.058  1.00 40.16           C  
ATOM   2400  O   VAL B 110      43.433  20.539  16.744  1.00 39.71           O  
ATOM   2401  CB  VAL B 110      40.720  19.185  17.540  1.00 43.37           C  
ATOM   2402  CG1 VAL B 110      39.748  20.276  17.118  1.00 36.89           C  
ATOM   2403  CG2 VAL B 110      39.953  17.908  17.886  1.00 41.55           C  
ATOM   2404  N   LEU B 111      42.044  20.799  14.973  1.00 37.87           N  
ATOM   2405  CA  LEU B 111      42.581  22.049  14.505  1.00 36.42           C  
ATOM   2406  C   LEU B 111      41.473  23.031  14.309  1.00 37.42           C  
ATOM   2407  O   LEU B 111      40.380  22.654  13.889  1.00 39.93           O  
ATOM   2408  CB  LEU B 111      43.256  21.861  13.156  1.00 34.60           C  
ATOM   2409  CG  LEU B 111      44.405  20.886  13.118  1.00 31.19           C  
ATOM   2410  CD1 LEU B 111      44.840  20.714  11.689  1.00 31.34           C  
ATOM   2411  CD2 LEU B 111      45.551  21.369  13.981  1.00 40.33           C  
ATOM   2412  N   TYR B 112      41.748  24.290  14.627  1.00 38.21           N  
ATOM   2413  CA  TYR B 112      40.845  25.375  14.300  1.00 39.34           C  
ATOM   2414  C   TYR B 112      41.652  26.399  13.536  1.00 38.30           C  
ATOM   2415  O   TYR B 112      42.884  26.388  13.604  1.00 35.69           O  
ATOM   2416  CB  TYR B 112      40.218  25.992  15.540  1.00 43.00           C  
ATOM   2417  CG  TYR B 112      39.376  25.001  16.314  1.00 47.30           C  
ATOM   2418  CD1 TYR B 112      38.235  24.431  15.746  1.00 49.99           C  
ATOM   2419  CD2 TYR B 112      39.708  24.636  17.624  1.00 48.96           C  
ATOM   2420  CE1 TYR B 112      37.453  23.503  16.454  1.00 51.51           C  
ATOM   2421  CE2 TYR B 112      38.915  23.717  18.352  1.00 45.38           C  
ATOM   2422  CZ  TYR B 112      37.800  23.150  17.753  1.00 48.71           C  
ATOM   2423  OH  TYR B 112      37.014  22.233  18.444  1.00 55.96           O  
ATOM   2424  N   THR B 113      40.950  27.260  12.803  1.00 36.10           N  
ATOM   2425  CA  THR B 113      41.602  28.335  12.077  1.00 35.57           C  
ATOM   2426  C   THR B 113      41.718  29.543  13.007  1.00 34.07           C  
ATOM   2427  O   THR B 113      40.966  29.680  13.992  1.00 33.01           O  
ATOM   2428  CB  THR B 113      40.848  28.746  10.811  1.00 37.19           C  
ATOM   2429  OG1 THR B 113      39.558  29.265  11.161  1.00 32.49           O  
ATOM   2430  CG2 THR B 113      40.676  27.571   9.894  1.00 33.15           C  
ATOM   2431  N   ARG B 114      42.690  30.399  12.710  1.00 35.23           N  
ATOM   2432  CA  ARG B 114      42.841  31.683  13.374  1.00 33.39           C  
ATOM   2433  C   ARG B 114      41.500  32.428  13.348  1.00 34.47           C  
ATOM   2434  O   ARG B 114      41.058  32.926  14.375  1.00 33.81           O  
ATOM   2435  CB  ARG B 114      43.869  32.542  12.637  1.00 35.86           C  
ATOM   2436  CG  ARG B 114      44.075  33.964  13.222  1.00 37.21           C  
ATOM   2437  CD  ARG B 114      44.453  34.938  12.102  1.00 44.82           C  
ATOM   2438  NE  ARG B 114      45.731  34.602  11.520  1.00 41.94           N  
ATOM   2439  CZ  ARG B 114      46.249  35.123  10.407  1.00 40.82           C  
ATOM   2440  NH1 ARG B 114      45.621  36.064   9.718  1.00 41.38           N  
ATOM   2441  NH2 ARG B 114      47.434  34.707   9.995  1.00 38.17           N  
ATOM   2442  N   ASP B 115      40.869  32.470  12.176  1.00 35.40           N  
ATOM   2443  CA  ASP B 115      39.548  33.150  11.991  1.00 35.18           C  
ATOM   2444  C   ASP B 115      38.465  32.615  12.965  1.00 35.03           C  
ATOM   2445  O   ASP B 115      37.789  33.384  13.641  1.00 34.64           O  
ATOM   2446  CB  ASP B 115      39.074  33.013  10.556  1.00 34.75           C  
ATOM   2447  CG  ASP B 115      37.812  33.823  10.273  1.00 39.83           C  
ATOM   2448  OD1 ASP B 115      37.838  35.018  10.529  1.00 47.02           O  
ATOM   2449  OD2 ASP B 115      36.863  33.282   9.722  1.00 46.94           O  
ATOM   2450  N   GLU B 116      38.342  31.301  13.062  1.00 36.28           N  
ATOM   2451  CA  GLU B 116      37.386  30.661  13.984  0.50 35.95           C  
ATOM   2453  C   GLU B 116      37.627  31.038  15.440  1.00 36.00           C  
ATOM   2454  O   GLU B 116      36.682  31.374  16.193  1.00 34.95           O  
ATOM   2455  CB  GLU B 116      37.452  29.132  13.836  0.50 37.94           C  
ATOM   2457  CG  GLU B 116      36.794  28.681  12.584  0.50 38.55           C  
ATOM   2459  CD  GLU B 116      37.026  27.223  12.220  0.50 37.56           C  
ATOM   2461  OE1 GLU B 116      38.022  26.538  12.649  0.50 24.84           O  
ATOM   2463  OE2 GLU B 116      36.159  26.788  11.441  0.50 32.27           O  
ATOM   2465  N   ILE B 117      38.894  30.954  15.830  1.00 34.38           N  
ATOM   2466  CA  ILE B 117      39.321  31.245  17.200  1.00 35.78           C  
ATOM   2467  C   ILE B 117      39.045  32.688  17.582  1.00 33.71           C  
ATOM   2468  O   ILE B 117      38.525  32.948  18.672  1.00 35.71           O  
ATOM   2469  CB  ILE B 117      40.809  30.873  17.419  1.00 33.93           C  
ATOM   2470  CG1 ILE B 117      40.998  29.350  17.292  1.00 33.30           C  
ATOM   2471  CG2 ILE B 117      41.272  31.333  18.806  1.00 34.92           C  
ATOM   2472  CD1 ILE B 117      42.490  28.945  17.108  1.00 35.69           C  
ATOM   2473  N   LEU B 118      39.339  33.618  16.680  1.00 35.06           N  
ATOM   2474  CA  LEU B 118      39.111  35.026  16.954  1.00 35.08           C  
ATOM   2475  C   LEU B 118      37.625  35.333  17.135  1.00 36.78           C  
ATOM   2476  O   LEU B 118      37.264  36.084  18.074  1.00 36.19           O  
ATOM   2477  CB  LEU B 118      39.727  35.945  15.897  1.00 34.87           C  
ATOM   2478  CG  LEU B 118      41.254  35.949  15.778  1.00 34.50           C  
ATOM   2479  CD1 LEU B 118      41.589  36.971  14.720  1.00 43.37           C  
ATOM   2480  CD2 LEU B 118      41.943  36.230  17.093  1.00 36.34           C  
ATOM   2481  N   HIS B 119      36.779  34.752  16.279  1.00 36.04           N  
ATOM   2482  CA  HIS B 119      35.322  34.893  16.422  1.00 34.64           C  
ATOM   2483  C   HIS B 119      34.852  34.309  17.759  1.00 34.86           C  
ATOM   2484  O   HIS B 119      34.031  34.889  18.455  1.00 33.36           O  
ATOM   2485  CB  HIS B 119      34.565  34.185  15.287  1.00 34.41           C  
ATOM   2486  CG  HIS B 119      34.539  34.945  13.993  1.00 34.18           C  
ATOM   2487  ND1 HIS B 119      35.576  34.907  13.079  1.00 33.06           N  
ATOM   2488  CD2 HIS B 119      33.595  35.747  13.456  1.00 36.65           C  
ATOM   2489  CE1 HIS B 119      35.262  35.656  12.036  1.00 36.01           C  
ATOM   2490  NE2 HIS B 119      34.057  36.162  12.227  1.00 35.30           N  
ATOM   2491  N   HIS B 120      35.369  33.139  18.089  1.00 35.08           N  
ATOM   2492  CA  HIS B 120      35.016  32.441  19.332  1.00 35.79           C  
ATOM   2493  C   HIS B 120      35.361  33.256  20.579  1.00 36.47           C  
ATOM   2494  O   HIS B 120      34.495  33.438  21.424  1.00 36.46           O  
ATOM   2495  CB  HIS B 120      35.698  31.076  19.385  1.00 37.49           C  
ATOM   2496  CG  HIS B 120      35.391  30.298  20.632  1.00 38.82           C  
ATOM   2497  ND1 HIS B 120      34.188  29.661  20.829  1.00 40.28           N  
ATOM   2498  CD2 HIS B 120      36.124  30.072  21.746  1.00 41.43           C  
ATOM   2499  CE1 HIS B 120      34.196  29.068  22.011  1.00 40.38           C  
ATOM   2500  NE2 HIS B 120      35.350  29.324  22.597  1.00 39.16           N  
ATOM   2501  N   ILE B 121      36.606  33.742  20.649  1.00 35.84           N  
ATOM   2502  CA  ILE B 121      37.120  34.609  21.717  1.00 38.27           C  
ATOM   2503  C   ILE B 121      36.233  35.832  21.896  1.00 36.03           C  
ATOM   2504  O   ILE B 121      35.827  36.181  23.031  1.00 36.36           O  
ATOM   2505  CB  ILE B 121      38.583  35.151  21.376  1.00 39.30           C  
ATOM   2506  CG1 ILE B 121      39.622  34.085  21.590  1.00 48.35           C  
ATOM   2507  CG2 ILE B 121      38.978  36.318  22.249  1.00 49.11           C  
ATOM   2508  CD1 ILE B 121      41.020  34.510  21.109  1.00 41.72           C  
ATOM   2509  N   ILE B 122      35.955  36.490  20.782  1.00 34.85           N  
ATOM   2510  CA  ILE B 122      35.071  37.685  20.818  1.00 33.14           C  
ATOM   2511  C   ILE B 122      33.685  37.372  21.392  1.00 34.15           C  
ATOM   2512  O   ILE B 122      33.218  38.068  22.318  1.00 33.86           O  
ATOM   2513  CB  ILE B 122      34.952  38.353  19.437  1.00 35.26           C  
ATOM   2514  CG1 ILE B 122      36.279  39.027  19.029  1.00 35.66           C  
ATOM   2515  CG2 ILE B 122      33.807  39.368  19.433  1.00 29.83           C  
ATOM   2516  CD1 ILE B 122      36.330  39.437  17.553  1.00 33.04           C  
ATOM   2517  N   ALA B 123      33.024  36.350  20.848  1.00 33.81           N  
ATOM   2518  CA  ALA B 123      31.684  35.956  21.315  1.00 36.07           C  
ATOM   2519  C   ALA B 123      31.712  35.511  22.790  1.00 35.13           C  
ATOM   2520  O   ALA B 123      30.784  35.797  23.544  1.00 35.48           O  
ATOM   2521  CB  ALA B 123      31.072  34.850  20.432  1.00 32.04           C  
ATOM   2522  N   HIS B 124      32.773  34.787  23.163  1.00 35.61           N  
ATOM   2523  CA  HIS B 124      32.929  34.265  24.532  1.00 34.98           C  
ATOM   2524  C   HIS B 124      32.814  35.326  25.609  1.00 35.69           C  
ATOM   2525  O   HIS B 124      32.008  35.191  26.563  1.00 34.81           O  
ATOM   2526  CB  HIS B 124      34.251  33.494  24.680  1.00 35.69           C  
ATOM   2527  CG  HIS B 124      34.325  32.703  25.938  1.00 36.06           C  
ATOM   2528  ND1 HIS B 124      35.144  33.061  26.986  1.00 35.36           N  
ATOM   2529  CD2 HIS B 124      33.662  31.592  26.332  1.00 36.35           C  
ATOM   2530  CE1 HIS B 124      34.998  32.188  27.967  1.00 38.62           C  
ATOM   2531  NE2 HIS B 124      34.104  31.285  27.594  1.00 35.65           N  
ATOM   2532  N   GLU B 125      33.563  36.403  25.451  1.00 36.28           N  
ATOM   2533  CA  GLU B 125      33.519  37.469  26.458  1.00 36.48           C  
ATOM   2534  C   GLU B 125      32.157  38.180  26.493  1.00 35.63           C  
ATOM   2535  O   GLU B 125      31.606  38.374  27.568  1.00 34.61           O  
ATOM   2536  CB  GLU B 125      34.656  38.445  26.264  1.00 37.22           C  
ATOM   2537  CG  GLU B 125      34.588  39.612  27.243  1.00 34.83           C  
ATOM   2538  CD  GLU B 125      35.925  40.211  27.563  1.00 37.29           C  
ATOM   2539  OE1 GLU B 125      36.905  39.992  26.825  1.00 38.52           O  
ATOM   2540  OE2 GLU B 125      35.999  40.911  28.590  1.00 37.48           O  
ATOM   2541  N   ILE B 126      31.609  38.534  25.329  1.00 35.07           N  
ATOM   2542  CA  ILE B 126      30.289  39.222  25.280  1.00 34.01           C  
ATOM   2543  C   ILE B 126      29.193  38.346  25.932  1.00 33.00           C  
ATOM   2544  O   ILE B 126      28.343  38.851  26.680  1.00 33.60           O  
ATOM   2545  CB  ILE B 126      29.872  39.657  23.829  1.00 32.28           C  
ATOM   2546  CG1 ILE B 126      30.958  40.565  23.205  1.00 35.10           C  
ATOM   2547  CG2 ILE B 126      28.517  40.347  23.857  1.00 32.04           C  
ATOM   2548  CD1 ILE B 126      30.843  40.741  21.668  1.00 33.54           C  
ATOM   2549  N   HIS B 127      29.237  37.042  25.663  1.00 33.81           N  
ATOM   2550  CA  HIS B 127      28.328  36.053  26.272  1.00 33.80           C  
ATOM   2551  C   HIS B 127      28.366  36.047  27.811  1.00 32.99           C  
ATOM   2552  O   HIS B 127      27.321  36.173  28.462  1.00 32.54           O  
ATOM   2553  CB  HIS B 127      28.652  34.650  25.720  1.00 35.66           C  
ATOM   2554  CG  HIS B 127      28.020  33.515  26.467  1.00 35.34           C  
ATOM   2555  ND1 HIS B 127      26.672  33.227  26.409  1.00 36.77           N  
ATOM   2556  CD2 HIS B 127      28.573  32.571  27.266  1.00 39.38           C  
ATOM   2557  CE1 HIS B 127      26.427  32.151  27.142  1.00 36.60           C  
ATOM   2558  NE2 HIS B 127      27.565  31.733  27.669  1.00 38.24           N  
ATOM   2559  N   HIS B 128      29.567  35.907  28.383  1.00 34.69           N  
ATOM   2560  CA  HIS B 128      29.720  35.873  29.838  1.00 34.00           C  
ATOM   2561  C   HIS B 128      29.415  37.224  30.472  1.00 34.17           C  
ATOM   2562  O   HIS B 128      28.802  37.293  31.533  1.00 36.48           O  
ATOM   2563  CB  HIS B 128      31.100  35.340  30.254  1.00 33.11           C  
ATOM   2564  CG  HIS B 128      31.224  33.865  30.079  1.00 31.27           C  
ATOM   2565  ND1 HIS B 128      30.397  32.979  30.728  1.00 32.25           N  
ATOM   2566  CD2 HIS B 128      32.065  33.122  29.334  1.00 36.33           C  
ATOM   2567  CE1 HIS B 128      30.726  31.747  30.387  1.00 36.57           C  
ATOM   2568  NE2 HIS B 128      31.741  31.808  29.544  1.00 35.42           N  
ATOM   2569  N   ILE B 129      29.819  38.292  29.809  1.00 34.84           N  
ATOM   2570  CA  ILE B 129      29.476  39.641  30.285  1.00 34.50           C  
ATOM   2571  C   ILE B 129      27.943  39.823  30.292  1.00 36.19           C  
ATOM   2572  O   ILE B 129      27.410  40.452  31.216  1.00 36.20           O  
ATOM   2573  CB  ILE B 129      30.192  40.727  29.484  1.00 35.76           C  
ATOM   2574  CG1 ILE B 129      31.712  40.675  29.771  1.00 33.44           C  
ATOM   2575  CG2 ILE B 129      29.648  42.118  29.813  1.00 37.02           C  
ATOM   2576  CD1 ILE B 129      32.171  41.044  31.184  1.00 37.66           C  
ATOM   2577  N   GLY B 130      27.229  39.261  29.304  1.00 36.61           N  
ATOM   2578  CA  GLY B 130      25.759  39.303  29.326  1.00 35.46           C  
ATOM   2579  C   GLY B 130      25.161  38.673  30.577  1.00 34.96           C  
ATOM   2580  O   GLY B 130      24.137  39.151  31.133  1.00 34.93           O  
ATOM   2581  N   GLN B 131      25.803  37.607  31.046  1.00 36.75           N  
ATOM   2582  CA  GLN B 131      25.375  36.906  32.266  1.00 36.84           C  
ATOM   2583  C   GLN B 131      25.553  37.806  33.485  1.00 37.36           C  
ATOM   2584  O   GLN B 131      24.658  37.880  34.313  1.00 38.11           O  
ATOM   2585  CB  GLN B 131      26.137  35.586  32.455  1.00 37.83           C  
ATOM   2586  CG  GLN B 131      25.929  34.548  31.329  1.00 31.94           C  
ATOM   2587  CD  GLN B 131      26.846  33.354  31.439  1.00 38.93           C  
ATOM   2588  OE1 GLN B 131      27.934  33.448  31.997  1.00 36.79           O  
ATOM   2589  NE2 GLN B 131      26.428  32.229  30.875  1.00 32.85           N  
ATOM   2590  N   LEU B 132      26.669  38.538  33.561  1.00 38.09           N  
ATOM   2591  CA  LEU B 132      26.906  39.478  34.677  1.00 38.43           C  
ATOM   2592  C   LEU B 132      25.805  40.519  34.814  1.00 37.34           C  
ATOM   2593  O   LEU B 132      25.439  40.867  35.929  1.00 37.90           O  
ATOM   2594  CB  LEU B 132      28.237  40.225  34.562  1.00 38.16           C  
ATOM   2595  CG  LEU B 132      29.528  39.407  34.575  1.00 39.22           C  
ATOM   2596  CD1 LEU B 132      30.698  40.386  34.559  1.00 41.67           C  
ATOM   2597  CD2 LEU B 132      29.603  38.427  35.784  1.00 40.23           C  
ATOM   2598  N   SER B 133      25.298  41.013  33.685  1.00 37.82           N  
ATOM   2599  CA  SER B 133      24.207  42.018  33.689  1.00 37.59           C  
ATOM   2600  C   SER B 133      22.918  41.537  34.368  1.00 37.56           C  
ATOM   2601  O   SER B 133      22.180  42.355  34.906  1.00 38.52           O  
ATOM   2602  CB  SER B 133      23.894  42.527  32.272  1.00 37.76           C  
ATOM   2603  OG  SER B 133      23.167  41.582  31.491  1.00 35.11           O  
ATOM   2604  N   VAL B 134      22.649  40.229  34.348  1.00 35.71           N  
ATOM   2605  CA  VAL B 134      21.471  39.673  35.049  1.00 35.70           C  
ATOM   2606  C   VAL B 134      21.738  39.661  36.565  1.00 35.36           C  
ATOM   2607  O   VAL B 134      20.920  40.144  37.354  1.00 35.04           O  
ATOM   2608  CB  VAL B 134      21.111  38.272  34.550  1.00 35.71           C  
ATOM   2609  CG1 VAL B 134      19.984  37.657  35.393  1.00 36.11           C  
ATOM   2610  CG2 VAL B 134      20.752  38.321  33.050  1.00 34.36           C  
ATOM   2611  N   TRP B 135      22.894  39.127  36.960  1.00 36.16           N  
ATOM   2612  CA  TRP B 135      23.283  39.105  38.376  1.00 37.07           C  
ATOM   2613  C   TRP B 135      23.369  40.516  38.973  1.00 36.33           C  
ATOM   2614  O   TRP B 135      23.080  40.685  40.159  1.00 37.60           O  
ATOM   2615  CB  TRP B 135      24.608  38.374  38.617  1.00 37.31           C  
ATOM   2616  CG  TRP B 135      24.602  36.949  38.202  1.00 37.26           C  
ATOM   2617  CD1 TRP B 135      23.535  36.107  38.199  1.00 38.86           C  
ATOM   2618  CD2 TRP B 135      25.728  36.167  37.814  1.00 36.12           C  
ATOM   2619  NE1 TRP B 135      23.909  34.866  37.785  1.00 38.92           N  
ATOM   2620  CE2 TRP B 135      25.254  34.866  37.543  1.00 38.38           C  
ATOM   2621  CE3 TRP B 135      27.090  36.443  37.635  1.00 38.83           C  
ATOM   2622  CZ2 TRP B 135      26.094  33.826  37.130  1.00 40.02           C  
ATOM   2623  CZ3 TRP B 135      27.929  35.412  37.221  1.00 37.12           C  
ATOM   2624  CH2 TRP B 135      27.424  34.121  36.966  1.00 39.95           C  
ATOM   2625  N   ALA B 136      23.752  41.501  38.153  1.00 35.09           N  
ATOM   2626  CA  ALA B 136      23.808  42.912  38.574  1.00 33.88           C  
ATOM   2627  C   ALA B 136      22.438  43.367  39.017  1.00 35.06           C  
ATOM   2628  O   ALA B 136      22.319  43.956  40.083  1.00 36.02           O  
ATOM   2629  CB  ALA B 136      24.288  43.804  37.456  1.00 31.94           C  
ATOM   2630  N   ARG B 137      21.406  43.087  38.205  1.00 35.85           N  
ATOM   2631  CA  ARG B 137      20.007  43.469  38.566  1.00 37.30           C  
ATOM   2632  C   ARG B 137      19.434  42.666  39.724  1.00 38.66           C  
ATOM   2633  O   ARG B 137      18.579  43.173  40.463  1.00 40.17           O  
ATOM   2634  CB  ARG B 137      19.060  43.433  37.345  1.00 39.21           C  
ATOM   2635  CG  ARG B 137      19.239  44.613  36.358  1.00 42.65           C  
ATOM   2636  CD  ARG B 137      18.967  45.960  37.048  1.00 47.62           C  
ATOM   2637  NE  ARG B 137      18.989  47.102  36.136  1.00 51.56           N  
ATOM   2638  CZ  ARG B 137      19.059  48.385  36.515  1.00 49.85           C  
ATOM   2639  NH1 ARG B 137      19.086  48.758  37.808  1.00 52.50           N  
ATOM   2640  NH2 ARG B 137      19.091  49.324  35.571  1.00 49.04           N  
ATOM   2641  N   GLU B 138      19.898  41.426  39.886  1.00 38.98           N  
ATOM   2642  CA  GLU B 138      19.518  40.586  41.026  1.00 38.68           C  
ATOM   2643  C   GLU B 138      20.100  41.139  42.327  1.00 39.18           C  
ATOM   2644  O   GLU B 138      19.488  40.995  43.375  1.00 38.97           O  
ATOM   2645  CB  GLU B 138      19.938  39.134  40.791  1.00 38.56           C  
ATOM   2646  CG  GLU B 138      19.123  38.527  39.664  1.00 41.50           C  
ATOM   2647  CD  GLU B 138      19.446  37.103  39.338  1.00 40.35           C  
ATOM   2648  OE1 GLU B 138      20.455  36.547  39.837  1.00 40.65           O  
ATOM   2649  OE2 GLU B 138      18.663  36.553  38.538  1.00 42.44           O  
ATOM   2650  N   LEU B 139      21.269  41.788  42.234  1.00 38.67           N  
ATOM   2651  CA  LEU B 139      21.905  42.491  43.360  1.00 38.80           C  
ATOM   2652  C   LEU B 139      21.356  43.923  43.554  1.00 37.43           C  
ATOM   2653  O   LEU B 139      21.867  44.648  44.398  1.00 37.73           O  
ATOM   2654  CB  LEU B 139      23.430  42.526  43.186  1.00 38.18           C  
ATOM   2655  CG  LEU B 139      24.157  41.189  43.402  1.00 40.68           C  
ATOM   2656  CD1 LEU B 139      25.495  41.152  42.672  1.00 40.79           C  
ATOM   2657  CD2 LEU B 139      24.319  40.921  44.907  1.00 43.46           C  
ATOM   2658  N   LYS B 140      20.330  44.308  42.783  1.00 37.84           N  
ATOM   2659  CA  LYS B 140      19.671  45.622  42.833  1.00 39.67           C  
ATOM   2660  C   LYS B 140      20.632  46.771  42.481  1.00 40.61           C  
ATOM   2661  O   LYS B 140      20.532  47.875  43.032  1.00 40.29           O  
ATOM   2662  CB  LYS B 140      18.976  45.828  44.192  1.00 40.57           C  
ATOM   2663  CG  LYS B 140      17.984  44.712  44.564  1.00 43.73           C  
ATOM   2664  CD  LYS B 140      17.369  44.955  45.953  1.00 37.49           C  
ATOM   2665  N   LEU B 141      21.553  46.484  41.557  1.00 40.16           N  
ATOM   2666  CA  LEU B 141      22.538  47.444  41.064  1.00 42.20           C  
ATOM   2667  C   LEU B 141      22.371  47.589  39.557  1.00 44.63           C  
ATOM   2668  O   LEU B 141      22.016  46.613  38.870  1.00 46.10           O  
ATOM   2669  CB  LEU B 141      23.961  46.957  41.345  1.00 41.32           C  
ATOM   2670  CG  LEU B 141      24.379  46.688  42.786  1.00 43.61           C  
ATOM   2671  CD1 LEU B 141      25.754  46.030  42.823  1.00 38.54           C  
ATOM   2672  CD2 LEU B 141      24.373  47.968  43.599  1.00 40.46           C  
ATOM   2673  N   SER B 142      22.634  48.793  39.046  1.00 43.55           N  
ATOM   2674  CA  SER B 142      22.596  49.045  37.613  1.00 44.82           C  
ATOM   2675  C   SER B 142      23.796  48.353  36.922  1.00 42.12           C  
ATOM   2676  O   SER B 142      24.919  48.515  37.385  1.00 43.28           O  
ATOM   2677  CB  SER B 142      22.640  50.551  37.338  1.00 46.00           C  
ATOM   2678  OG  SER B 142      22.713  50.781  35.943  1.00 56.29           O  
ATOM   2679  N   PRO B 143      23.578  47.605  35.814  1.00 40.18           N  
ATOM   2680  CA  PRO B 143      24.733  46.977  35.141  1.00 40.04           C  
ATOM   2681  C   PRO B 143      25.592  47.992  34.366  1.00 39.06           C  
ATOM   2682  O   PRO B 143      25.194  49.148  34.216  1.00 38.76           O  
ATOM   2683  CB  PRO B 143      24.068  46.000  34.160  1.00 38.73           C  
ATOM   2684  CG  PRO B 143      22.767  46.632  33.849  1.00 41.51           C  
ATOM   2685  CD  PRO B 143      22.320  47.297  35.108  1.00 40.06           C  
ATOM   2686  N   VAL B 144      26.785  47.571  33.946  1.00 38.17           N  
ATOM   2687  CA  VAL B 144      27.608  48.360  33.045  1.00 38.28           C  
ATOM   2688  C   VAL B 144      26.959  48.203  31.654  1.00 40.42           C  
ATOM   2689  O   VAL B 144      26.583  47.072  31.265  1.00 38.62           O  
ATOM   2690  CB  VAL B 144      29.066  47.843  33.005  1.00 39.21           C  
ATOM   2691  CG1 VAL B 144      29.869  48.488  31.887  1.00 37.33           C  
ATOM   2692  CG2 VAL B 144      29.750  48.023  34.380  1.00 40.55           C  
ATOM   2693  N   SER B 145      26.835  49.296  30.900  1.00 38.83           N  
ATOM   2694  CA  SER B 145      26.276  49.218  29.531  1.00 40.64           C  
ATOM   2695  C   SER B 145      27.090  48.293  28.575  1.00 40.71           C  
ATOM   2696  O   SER B 145      28.339  48.230  28.626  1.00 42.19           O  
ATOM   2697  CB  SER B 145      26.149  50.612  28.906  1.00 40.60           C  
ATOM   2698  OG  SER B 145      25.752  50.542  27.536  1.00 43.67           O  
ATOM   2699  N   ALA B 146      26.370  47.527  27.758  1.00 40.19           N  
ATOM   2700  CA  ALA B 146      26.982  46.691  26.731  1.00 40.47           C  
ATOM   2701  C   ALA B 146      26.911  47.343  25.340  1.00 41.03           C  
ATOM   2702  O   ALA B 146      27.311  46.708  24.353  1.00 39.82           O  
ATOM   2703  CB  ALA B 146      26.320  45.308  26.696  1.00 41.29           C  
ATOM   2704  N   SER B 147      26.410  48.585  25.248  1.00 41.16           N  
ATOM   2705  CA  SER B 147      26.269  49.255  23.956  1.00 41.46           C  
ATOM   2706  C   SER B 147      27.623  49.421  23.280  1.00 40.43           C  
ATOM   2707  O   SER B 147      28.556  49.918  23.893  1.00 43.27           O  
ATOM   2708  CB  SER B 147      25.621  50.622  24.101  1.00 41.30           C  
ATOM   2709  OG  SER B 147      25.502  51.270  22.835  1.00 45.56           O  
ATOM   2710  N   PHE B 148      27.715  48.991  22.031  1.00 39.20           N  
ATOM   2711  CA  PHE B 148      28.927  49.169  21.244  1.00 38.52           C  
ATOM   2712  C   PHE B 148      29.106  50.641  20.849  1.00 39.24           C  
ATOM   2713  O   PHE B 148      30.199  51.195  20.978  1.00 38.85           O  
ATOM   2714  CB  PHE B 148      28.897  48.306  19.991  1.00 40.37           C  
ATOM   2715  CG  PHE B 148      30.218  48.237  19.287  1.00 34.53           C  
ATOM   2716  CD1 PHE B 148      30.573  49.213  18.361  1.00 38.70           C  
ATOM   2717  CD2 PHE B 148      31.102  47.210  19.559  1.00 38.91           C  
ATOM   2718  CE1 PHE B 148      31.816  49.171  17.719  1.00 41.08           C  
ATOM   2719  CE2 PHE B 148      32.347  47.175  18.947  1.00 38.24           C  
ATOM   2720  CZ  PHE B 148      32.699  48.159  18.019  1.00 36.66           C  
ATOM   2721  N   ILE B 149      28.041  51.239  20.322  1.00 39.58           N  
ATOM   2722  CA  ILE B 149      28.026  52.636  19.916  1.00 42.90           C  
ATOM   2723  C   ILE B 149      28.164  53.552  21.155  1.00 48.49           C  
ATOM   2724  O   ILE B 149      27.604  53.255  22.221  1.00 45.84           O  
ATOM   2725  CB  ILE B 149      26.723  52.981  19.100  1.00 41.86           C  
ATOM   2726  CG1 ILE B 149      26.827  52.430  17.677  1.00 39.62           C  
ATOM   2727  CG2 ILE B 149      26.474  54.487  19.006  1.00 44.98           C  
ATOM   2728  CD1 ILE B 149      25.513  52.539  16.863  1.00 40.44           C  
ATOM   2729  N   GLY B 150      28.913  54.648  20.989  1.00 54.98           N  
ATOM   2730  CA  GLY B 150      29.128  55.655  22.045  1.00 60.90           C  
ATOM   2731  C   GLY B 150      30.294  55.304  22.957  1.00 65.81           C  
ATOM   2732  O   GLY B 150      30.122  55.211  24.184  1.00 67.51           O  
ATOM   2733  N   ARG B 151      31.468  55.081  22.346  1.00 68.85           N  
ATOM   2734  CA  ARG B 151      32.715  54.728  23.051  1.00 69.93           C  
ATOM   2735  C   ARG B 151      33.944  55.323  22.352  1.00 69.70           C  
ATOM   2736  O   ARG B 151      34.955  55.622  22.995  1.00 68.79           O  
ATOM   2737  CB  ARG B 151      32.848  53.198  23.169  1.00 70.09           C  
ATOM   2738  CG  ARG B 151      31.833  52.594  24.122  1.00 71.21           C  
ATOM   2739  CD  ARG B 151      31.814  51.086  24.242  1.00 72.35           C  
ATOM   2740  NE  ARG B 151      30.889  50.753  25.341  1.00 78.14           N  
ATOM   2741  CZ  ARG B 151      31.220  50.359  26.579  1.00 83.38           C  
ATOM   2742  NH1 ARG B 151      32.490  50.184  26.966  1.00 87.92           N  
ATOM   2743  NH2 ARG B 151      30.237  50.120  27.458  1.00 82.54           N  
TER    2744      ARG B 151                                                      
END
MOLECULE T0481.pdb
ATOM   1157  N   ASN     5      43.757  48.627  12.993  1.00 48.55           N  
ATOM   1158  CA  ASN     5      43.707  47.221  13.486  1.00 48.66           C  
ATOM   1159  C   ASN     5      42.297  46.854  13.970  1.00 46.10           C  
ATOM   1160  O   ASN     5      41.931  47.131  15.124  1.00 45.32           O  
ATOM   1161  CB  ASN     5      44.739  47.032  14.610  1.00 49.92           C  
ATOM   1162  CG  ASN     5      45.105  45.561  14.854  1.00 51.98           C  
ATOM   1163  OD1 ASN     5      44.378  44.628  14.479  1.00 41.03           O  
ATOM   1164  ND2 ASN     5      46.252  45.360  15.496  1.00 51.86           N  
ATOM   1165  N   GLN     6      41.522  46.221  13.081  1.00 42.89           N  
ATOM   1166  CA  GLN     6      40.122  45.866  13.363  1.00 39.86           C  
ATOM   1167  C   GLN     6      39.972  44.674  14.322  1.00 37.64           C  
ATOM   1168  O   GLN     6      38.948  44.545  14.985  1.00 37.24           O  
ATOM   1169  CB  GLN     6      39.363  45.603  12.059  1.00 39.17           C  
ATOM   1170  N   ILE     7      40.983  43.809  14.403  1.00 34.88           N  
ATOM   1171  CA  ILE     7      40.937  42.694  15.353  1.00 34.40           C  
ATOM   1172  C   ILE     7      41.043  43.194  16.799  1.00 31.45           C  
ATOM   1173  O   ILE     7      40.216  42.843  17.643  1.00 29.10           O  
ATOM   1174  CB  ILE     7      42.038  41.634  15.082  1.00 34.24           C  
ATOM   1175  CG1 ILE     7      41.687  40.792  13.849  1.00 35.88           C  
ATOM   1176  CG2 ILE     7      42.186  40.712  16.271  1.00 34.37           C  
ATOM   1177  CD1 ILE     7      42.783  39.803  13.446  1.00 36.32           C  
ATOM   1178  N   VAL     8      42.071  44.003  17.067  1.00 31.23           N  
ATOM   1179  CA  VAL     8      42.289  44.610  18.384  1.00 29.82           C  
ATOM   1180  C   VAL     8      41.107  45.490  18.755  1.00 29.64           C  
ATOM   1181  O   VAL     8      40.544  45.353  19.832  1.00 30.66           O  
ATOM   1182  CB  VAL     8      43.589  45.453  18.418  1.00 29.55           C  
ATOM   1183  CG1 VAL     8      43.562  46.438  19.575  1.00 30.78           C  
ATOM   1184  CG2 VAL     8      44.817  44.553  18.513  1.00 26.78           C  
ATOM   1185  N   SER     9      40.726  46.377  17.846  1.00 30.09           N  
ATOM   1186  CA  SER     9      39.600  47.287  18.059  1.00 30.85           C  
ATOM   1187  C   SER     9      38.300  46.564  18.423  1.00 29.88           C  
ATOM   1188  O   SER     9      37.633  46.922  19.394  1.00 30.15           O  
ATOM   1189  CB  SER     9      39.382  48.137  16.796  1.00 31.43           C  
ATOM   1190  OG  SER     9      38.309  49.037  16.971  1.00 34.73           O  
ATOM   1191  N   HIS    10      37.946  45.552  17.640  1.00 29.62           N  
ATOM   1192  CA  HIS    10      36.728  44.774  17.872  1.00 29.21           C  
ATOM   1193  C   HIS    10      36.770  43.988  19.188  1.00 27.89           C  
ATOM   1194  O   HIS    10      35.747  43.834  19.863  1.00 27.83           O  
ATOM   1195  CB  HIS    10      36.453  43.833  16.696  1.00 29.11           C  
ATOM   1196  CG  HIS    10      35.127  43.131  16.782  1.00 30.96           C  
ATOM   1197  ND1 HIS    10      34.991  41.773  16.582  1.00 29.81           N  
ATOM   1198  CD2 HIS    10      33.882  43.596  17.055  1.00 32.11           C  
ATOM   1199  CE1 HIS    10      33.723  41.432  16.721  1.00 34.31           C  
ATOM   1200  NE2 HIS    10      33.025  42.520  17.004  1.00 31.48           N  
ATOM   1201  N   PHE    11      37.946  43.490  19.545  1.00 26.50           N  
ATOM   1202  CA  PHE    11      38.144  42.846  20.847  1.00 25.86           C  
ATOM   1203  C   PHE    11      37.899  43.833  22.005  1.00 25.41           C  
ATOM   1204  O   PHE    11      37.131  43.543  22.922  1.00 26.59           O  
ATOM   1205  CB  PHE    11      39.561  42.251  20.931  1.00 25.87           C  
ATOM   1206  CG  PHE    11      39.978  41.854  22.325  1.00 23.85           C  
ATOM   1207  CD1 PHE    11      39.402  40.765  22.948  1.00 23.40           C  
ATOM   1208  CD2 PHE    11      40.940  42.587  23.009  1.00 24.43           C  
ATOM   1209  CE1 PHE    11      39.769  40.403  24.233  1.00 24.62           C  
ATOM   1210  CE2 PHE    11      41.331  42.230  24.298  1.00 26.60           C  
ATOM   1211  CZ  PHE    11      40.751  41.136  24.910  1.00 25.39           C  
ATOM   1212  N   LEU    12      38.558  44.993  21.960  1.00 25.19           N  
ATOM   1213  CA  LEU    12      38.433  46.000  23.024  1.00 24.40           C  
ATOM   1214  C   LEU    12      37.013  46.571  23.154  1.00 24.37           C  
ATOM   1215  O   LEU    12      36.551  46.899  24.244  1.00 23.55           O  
ATOM   1216  CB  LEU    12      39.429  47.127  22.787  1.00 25.08           C  
ATOM   1217  CG  LEU    12      40.903  46.732  22.935  1.00 23.88           C  
ATOM   1218  CD1 LEU    12      41.772  47.927  22.675  1.00 19.99           C  
ATOM   1219  CD2 LEU    12      41.172  46.151  24.314  1.00 17.50           C  
ATOM   1220  N   SER    13      36.345  46.698  22.018  1.00 24.35           N  
ATOM   1221  CA  SER    13      34.937  47.074  21.945  1.00 24.92           C  
ATOM   1222  C   SER    13      34.094  46.327  22.991  1.00 25.13           C  
ATOM   1223  O   SER    13      33.214  46.894  23.629  1.00 27.77           O  
ATOM   1224  CB  SER    13      34.440  46.723  20.541  1.00 25.22           C  
ATOM   1225  OG  SER    13      33.092  47.020  20.376  1.00 26.42           O  
ATOM   1226  N   HIS    14      34.392  45.046  23.150  1.00 24.32           N  
ATOM   1227  CA  HIS    14      33.720  44.177  24.093  1.00 23.44           C  
ATOM   1228  C   HIS    14      34.479  44.063  25.424  1.00 22.45           C  
ATOM   1229  O   HIS    14      33.887  44.226  26.488  1.00 22.95           O  
ATOM   1230  CB  HIS    14      33.528  42.795  23.455  1.00 23.60           C  
ATOM   1231  CG  HIS    14      32.468  42.759  22.397  1.00 22.55           C  
ATOM   1232  ND1 HIS    14      31.123  42.736  22.695  1.00 22.51           N  
ATOM   1233  CD2 HIS    14      32.554  42.716  21.047  1.00 24.07           C  
ATOM   1234  CE1 HIS    14      30.425  42.689  21.575  1.00 22.12           C  
ATOM   1235  NE2 HIS    14      31.270  42.672  20.559  1.00 23.74           N  
ATOM   1236  N   ARG    15      35.782  43.819  25.364  1.00 23.33           N  
ATOM   1237  CA  ARG    15      36.609  43.694  26.581  1.00 23.65           C  
ATOM   1238  C   ARG    15      36.617  44.947  27.474  1.00 24.04           C  
ATOM   1239  O   ARG    15      36.658  44.830  28.696  1.00 25.31           O  
ATOM   1240  CB  ARG    15      38.040  43.267  26.216  1.00 22.98           C  
ATOM   1241  CG  ARG    15      39.061  43.250  27.369  1.00 25.04           C  
ATOM   1242  CD  ARG    15      38.654  42.372  28.575  1.00 23.51           C  
ATOM   1243  NE  ARG    15      38.553  40.961  28.233  1.00 25.26           N  
ATOM   1244  CZ  ARG    15      39.583  40.124  28.141  1.00 29.21           C  
ATOM   1245  NH1 ARG    15      40.828  40.529  28.388  1.00 30.40           N  
ATOM   1246  NH2 ARG    15      39.358  38.857  27.809  1.00 26.91           N  
ATOM   1247  N   ASN    16      36.571  46.142  26.889  1.00 24.45           N  
ATOM   1248  CA  ASN    16      36.470  47.356  27.702  1.00 24.31           C  
ATOM   1249  C   ASN    16      35.182  47.388  28.527  1.00 24.67           C  
ATOM   1250  O   ASN    16      35.152  47.967  29.618  1.00 24.35           O  
ATOM   1251  CB  ASN    16      36.580  48.634  26.848  1.00 23.87           C  
ATOM   1252  CG  ASN    16      37.991  48.873  26.313  1.00 25.17           C  
ATOM   1253  OD1 ASN    16      38.980  48.416  26.887  1.00 27.85           O  
ATOM   1254  ND2 ASN    16      38.085  49.616  25.218  1.00 24.54           N  
ATOM   1255  N   VAL    17      34.112  46.792  28.005  1.00 25.32           N  
ATOM   1256  CA  VAL    17      32.845  46.739  28.750  1.00 25.14           C  
ATOM   1257  C   VAL    17      32.951  45.686  29.871  1.00 25.47           C  
ATOM   1258  O   VAL    17      32.466  45.898  30.980  1.00 24.38           O  
ATOM   1259  CB  VAL    17      31.636  46.485  27.807  1.00 25.11           C  
ATOM   1260  CG1 VAL    17      30.329  46.424  28.590  1.00 23.93           C  
ATOM   1261  CG2 VAL    17      31.567  47.563  26.732  1.00 21.19           C  
ATOM   1262  N   THR    18      33.621  44.570  29.581  1.00 26.85           N  
ATOM   1263  CA  THR    18      33.871  43.517  30.570  1.00 27.43           C  
ATOM   1264  C   THR    18      34.686  44.040  31.750  1.00 28.37           C  
ATOM   1265  O   THR    18      34.401  43.716  32.908  1.00 27.86           O  
ATOM   1266  CB  THR    18      34.631  42.343  29.937  1.00 26.46           C  
ATOM   1267  OG1 THR    18      33.758  41.641  29.047  1.00 28.22           O  
ATOM   1268  CG2 THR    18      35.153  41.393  31.005  1.00 26.76           C  
ATOM   1269  N   ASN    19      35.712  44.830  31.436  1.00 29.46           N  
ATOM   1270  CA  ASN    19      36.583  45.415  32.444  1.00 29.44           C  
ATOM   1271  C   ASN    19      35.877  46.449  33.302  1.00 31.03           C  
ATOM   1272  O   ASN    19      36.120  46.544  34.505  1.00 32.27           O  
ATOM   1273  CB  ASN    19      37.800  46.053  31.781  1.00 28.63           C  
ATOM   1274  CG  ASN    19      38.752  45.038  31.224  1.00 27.67           C  
ATOM   1275  OD1 ASN    19      38.698  43.849  31.561  1.00 29.89           O  
ATOM   1276  ND2 ASN    19      39.631  45.490  30.362  1.00 16.24           N  
ATOM   1277  N   GLU    20      35.009  47.226  32.673  1.00 32.85           N  
ATOM   1278  CA  GLU    20      34.197  48.215  33.378  1.00 34.98           C  
ATOM   1279  C   GLU    20      33.218  47.533  34.338  1.00 32.92           C  
ATOM   1280  O   GLU    20      33.018  47.999  35.451  1.00 35.00           O  
ATOM   1281  CB  GLU    20      33.450  49.089  32.369  1.00 34.33           C  
ATOM   1282  CG  GLU    20      32.885  50.367  32.951  1.00 41.33           C  
ATOM   1283  CD  GLU    20      32.241  51.269  31.906  1.00 41.71           C  
ATOM   1284  OE1 GLU    20      32.529  51.102  30.688  1.00 48.89           O  
ATOM   1285  OE2 GLU    20      31.448  52.149  32.316  1.00 50.11           O  
ATOM   1286  N   LEU    21      32.624  46.426  33.905  1.00 31.28           N  
ATOM   1287  CA  LEU    21      31.700  45.645  34.734  1.00 30.29           C  
ATOM   1288  C   LEU    21      32.414  44.977  35.915  1.00 30.39           C  
ATOM   1289  O   LEU    21      31.860  44.873  37.015  1.00 30.47           O  
ATOM   1290  CB  LEU    21      30.993  44.561  33.892  1.00 29.76           C  
ATOM   1291  CG  LEU    21      29.893  44.963  32.899  1.00 27.66           C  
ATOM   1292  CD1 LEU    21      29.501  43.764  32.026  1.00 22.19           C  
ATOM   1293  CD2 LEU    21      28.660  45.529  33.614  1.00 25.56           C  
ATOM   1294  N   ALA    22      33.635  44.512  35.672  1.00 30.64           N  
ATOM   1295  CA  ALA    22      34.460  43.895  36.710  1.00 31.48           C  
ATOM   1296  C   ALA    22      34.780  44.861  37.856  1.00 32.45           C  
ATOM   1297  O   ALA    22      34.888  44.450  39.016  1.00 31.11           O  
ATOM   1298  CB  ALA    22      35.755  43.354  36.098  1.00 31.19           C  
ATOM   1299  N   GLU    23      34.934  46.138  37.510  1.00 34.47           N  
ATOM   1300  CA  GLU    23      35.214  47.208  38.475  1.00 36.19           C  
ATOM   1301  C   GLU    23      34.053  47.424  39.453  1.00 35.68           C  
ATOM   1302  O   GLU    23      34.267  47.870  40.573  1.00 36.37           O  
ATOM   1303  CB  GLU    23      35.582  48.500  37.711  1.00 36.80           C  
ATOM   1304  CG  GLU    23      34.996  49.826  38.232  1.00 44.97           C  
ATOM   1305  CD  GLU    23      35.795  50.464  39.365  1.00 54.10           C  
ATOM   1306  OE1 GLU    23      37.029  50.243  39.444  1.00 58.36           O  
ATOM   1307  OE2 GLU    23      35.181  51.215  40.160  1.00 55.37           O  
ATOM   1308  N   LYS    24      32.837  47.095  39.020  1.00 35.78           N  
ATOM   1309  CA  LYS    24      31.630  47.243  39.828  1.00 36.00           C  
ATOM   1310  C   LYS    24      31.403  46.089  40.811  1.00 36.32           C  
ATOM   1311  O   LYS    24      30.399  46.071  41.524  1.00 37.08           O  
ATOM   1312  CB  LYS    24      30.411  47.385  38.910  1.00 36.20           C  
ATOM   1313  CG  LYS    24      30.488  48.628  38.038  1.00 37.65           C  
ATOM   1314  CD  LYS    24      29.127  49.070  37.532  1.00 40.50           C  
ATOM   1315  CE  LYS    24      29.157  50.541  37.089  1.00 46.04           C  
ATOM   1316  NZ  LYS    24      30.023  50.741  35.879  1.00 47.21           N  
ATOM   1317  N   ILE    25      32.337  45.138  40.840  1.00 35.88           N  
ATOM   1318  CA  ILE    25      32.294  43.987  41.733  1.00 35.06           C  
ATOM   1319  C   ILE    25      33.129  44.260  42.988  1.00 36.05           C  
ATOM   1320  O   ILE    25      34.364  44.186  42.953  1.00 35.12           O  
ATOM   1321  CB  ILE    25      32.851  42.718  41.022  1.00 34.99           C  
ATOM   1322  CG1 ILE    25      32.047  42.405  39.750  1.00 36.68           C  
ATOM   1323  CG2 ILE    25      32.848  41.515  41.959  1.00 34.29           C  
ATOM   1324  CD1 ILE    25      32.637  41.292  38.907  1.00 33.67           C  
ATOM   1325  N   SER    26      32.457  44.580  44.092  1.00 37.22           N  
ATOM   1326  CA  SER    26      33.128  44.736  45.383  1.00 38.56           C  
ATOM   1327  C   SER    26      33.758  43.410  45.786  1.00 40.35           C  
ATOM   1328  O   SER    26      33.334  42.354  45.310  1.00 41.06           O  
ATOM   1329  CB  SER    26      32.125  45.138  46.459  1.00 38.56           C  
ATOM   1330  OG  SER    26      31.263  44.055  46.775  1.00 37.07           O  
ATOM   1331  N   LYS    27      34.756  43.461  46.666  1.00 41.84           N  
ATOM   1332  CA  LYS    27      35.441  42.247  47.124  1.00 43.21           C  
ATOM   1333  C   LYS    27      34.509  41.312  47.910  1.00 42.45           C  
ATOM   1334  O   LYS    27      34.734  40.103  47.968  1.00 41.33           O  
ATOM   1335  CB  LYS    27      36.707  42.600  47.918  1.00 43.47           C  
ATOM   1336  CG  LYS    27      37.740  43.358  47.071  1.00 45.04           C  
ATOM   1337  CD  LYS    27      39.142  43.329  47.664  1.00 45.26           C  
ATOM   1338  CE  LYS    27      39.954  42.132  47.180  1.00 47.98           C  
ATOM   1339  NZ  LYS    27      40.646  42.396  45.885  1.00 44.46           N  
ATOM   1340  N   ASP    28      33.448  41.865  48.491  1.00 43.17           N  
ATOM   1341  CA  ASP    28      32.423  41.038  49.143  1.00 43.66           C  
ATOM   1342  C   ASP    28      31.589  40.274  48.109  1.00 42.08           C  
ATOM   1343  O   ASP    28      30.981  39.250  48.419  1.00 41.99           O  
ATOM   1344  CB  ASP    28      31.504  41.876  50.056  1.00 44.61           C  
ATOM   1345  CG  ASP    28      32.015  41.950  51.499  1.00 50.08           C  
ATOM   1346  OD1 ASP    28      32.189  40.877  52.115  1.00 52.94           O  
ATOM   1347  OD2 ASP    28      32.229  43.067  52.026  1.00 53.70           O  
ATOM   1348  N   HIS    29      31.575  40.767  46.875  1.00 40.09           N  
ATOM   1349  CA  HIS    29      30.784  40.157  45.813  1.00 38.00           C  
ATOM   1350  C   HIS    29      31.591  39.254  44.869  1.00 35.48           C  
ATOM   1351  O   HIS    29      31.047  38.750  43.891  1.00 34.55           O  
ATOM   1352  CB  HIS    29      30.051  41.241  45.014  1.00 37.73           C  
ATOM   1353  CG  HIS    29      28.769  41.692  45.637  1.00 38.39           C  
ATOM   1354  ND1 HIS    29      28.368  43.010  45.641  1.00 39.31           N  
ATOM   1355  CD2 HIS    29      27.793  40.999  46.267  1.00 39.76           C  
ATOM   1356  CE1 HIS    29      27.201  43.109  46.251  1.00 41.37           C  
ATOM   1357  NE2 HIS    29      26.830  41.903  46.639  1.00 41.73           N  
ATOM   1358  N   TYR    30      32.873  39.052  45.163  1.00 33.70           N  
ATOM   1359  CA  TYR    30      33.706  38.095  44.423  1.00 32.36           C  
ATOM   1360  C   TYR    30      33.079  36.686  44.430  1.00 32.70           C  
ATOM   1361  O   TYR    30      33.074  35.983  43.416  1.00 32.96           O  
ATOM   1362  CB  TYR    30      35.106  38.029  45.044  1.00 31.66           C  
ATOM   1363  CG  TYR    30      36.109  39.075  44.583  1.00 30.06           C  
ATOM   1364  CD1 TYR    30      35.708  40.312  44.111  1.00 29.10           C  
ATOM   1365  CD2 TYR    30      37.483  38.822  44.672  1.00 30.44           C  
ATOM   1366  CE1 TYR    30      36.643  41.265  43.700  1.00 29.51           C  
ATOM   1367  CE2 TYR    30      38.421  39.763  44.272  1.00 29.19           C  
ATOM   1368  CZ  TYR    30      37.999  40.983  43.786  1.00 31.71           C  
ATOM   1369  OH  TYR    30      38.933  41.930  43.389  1.00 31.55           O  
ATOM   1370  N   SER    31      32.546  36.289  45.586  1.00 32.70           N  
ATOM   1371  CA  SER    31      31.925  34.974  45.767  1.00 31.27           C  
ATOM   1372  C   SER    31      30.485  34.902  45.255  1.00 29.76           C  
ATOM   1373  O   SER    31      29.886  33.828  45.261  1.00 29.74           O  
ATOM   1374  CB  SER    31      31.904  34.639  47.255  1.00 31.47           C  
ATOM   1375  OG  SER    31      31.001  35.510  47.929  1.00 31.56           O  
ATOM   1376  N   TYR    32      29.923  36.031  44.826  1.00 29.31           N  
ATOM   1377  CA  TYR    32      28.493  36.105  44.518  1.00 28.85           C  
ATOM   1378  C   TYR    32      28.089  35.149  43.394  1.00 30.14           C  
ATOM   1379  O   TYR    32      28.698  35.128  42.324  1.00 31.63           O  
ATOM   1380  CB  TYR    32      28.054  37.533  44.156  1.00 28.51           C  
ATOM   1381  CG  TYR    32      26.573  37.583  43.859  1.00 28.85           C  
ATOM   1382  CD1 TYR    32      25.640  37.573  44.892  1.00 30.87           C  
ATOM   1383  CD2 TYR    32      26.104  37.564  42.555  1.00 30.04           C  
ATOM   1384  CE1 TYR    32      24.285  37.577  44.632  1.00 31.57           C  
ATOM   1385  CE2 TYR    32      24.743  37.561  42.284  1.00 28.50           C  
ATOM   1386  CZ  TYR    32      23.840  37.567  43.328  1.00 30.20           C  
ATOM   1387  OH  TYR    32      22.491  37.566  43.071  1.00 27.86           O  
ATOM   1388  N   LYS    33      27.062  34.354  43.664  1.00 30.60           N  
ATOM   1389  CA  LYS    33      26.541  33.386  42.716  1.00 30.67           C  
ATOM   1390  C   LYS    33      25.036  33.621  42.611  1.00 29.00           C  
ATOM   1391  O   LYS    33      24.353  33.610  43.634  1.00 27.20           O  
ATOM   1392  CB  LYS    33      26.804  31.963  43.218  1.00 30.54           C  
ATOM   1393  CG  LYS    33      28.261  31.518  43.131  1.00 31.84           C  
ATOM   1394  CD  LYS    33      28.444  30.104  43.651  1.00 32.67           C  
ATOM   1395  CE  LYS    33      29.915  29.685  43.643  1.00 38.32           C  
ATOM   1396  NZ  LYS    33      30.093  28.233  43.927  1.00 35.17           N  
ATOM   1397  N   PRO    34      24.527  33.902  41.397  1.00 27.53           N  
ATOM   1398  CA  PRO    34      23.093  34.023  41.131  1.00 27.92           C  
ATOM   1399  C   PRO    34      22.258  32.808  41.526  1.00 27.42           C  
ATOM   1400  O   PRO    34      21.134  32.971  42.007  1.00 26.94           O  
ATOM   1401  CB  PRO    34      23.043  34.209  39.609  1.00 28.69           C  
ATOM   1402  CG  PRO    34      24.349  34.838  39.276  1.00 28.43           C  
ATOM   1403  CD  PRO    34      25.323  34.197  40.193  1.00 27.34           C  
ATOM   1404  N   ALA    35      22.800  31.615  41.282  1.00 28.20           N  
ATOM   1405  CA  ALA    35      22.192  30.348  41.691  1.00 29.19           C  
ATOM   1406  C   ALA    35      23.291  29.440  42.234  1.00 30.41           C  
ATOM   1407  O   ALA    35      24.477  29.688  41.984  1.00 29.92           O  
ATOM   1408  CB  ALA    35      21.486  29.688  40.515  1.00 27.66           C  
ATOM   1409  N   GLU    36      22.900  28.382  42.949  1.00 31.54           N  
ATOM   1410  CA  GLU    36      23.861  27.475  43.590  1.00 33.38           C  
ATOM   1411  C   GLU    36      24.823  26.807  42.625  1.00 32.55           C  
ATOM   1412  O   GLU    36      25.968  26.559  42.979  1.00 33.40           O  
ATOM   1413  CB  GLU    36      23.150  26.386  44.381  1.00 34.20           C  
ATOM   1414  CG  GLU    36      22.389  26.881  45.598  1.00 37.06           C  
ATOM   1415  CD  GLU    36      22.094  25.766  46.602  1.00 39.82           C  
ATOM   1416  OE1 GLU    36      22.175  24.569  46.227  1.00 44.32           O  
ATOM   1417  OE2 GLU    36      21.794  26.094  47.775  1.00 47.78           O  
ATOM   1418  N   THR    37      24.351  26.510  41.419  1.00 31.80           N  
ATOM   1419  CA  THR    37      25.157  25.853  40.393  1.00 31.56           C  
ATOM   1420  C   THR    37      25.885  26.843  39.474  1.00 32.32           C  
ATOM   1421  O   THR    37      26.457  26.434  38.474  1.00 33.55           O  
ATOM   1422  CB  THR    37      24.262  24.924  39.568  1.00 31.01           C  
ATOM   1423  OG1 THR    37      23.098  25.641  39.152  1.00 31.99           O  
ATOM   1424  CG2 THR    37      23.806  23.726  40.418  1.00 31.00           C  
ATOM   1425  N   SER    38      25.883  28.134  39.826  1.00 32.65           N  
ATOM   1426  CA  SER    38      26.541  29.182  39.021  1.00 31.97           C  
ATOM   1427  C   SER    38      28.004  29.341  39.378  1.00 30.83           C  
ATOM   1428  O   SER    38      28.405  28.993  40.476  1.00 31.30           O  
ATOM   1429  CB  SER    38      25.870  30.550  39.232  1.00 31.46           C  
ATOM   1430  OG  SER    38      24.536  30.548  38.778  1.00 32.46           O  
ATOM   1431  N   MET    39      28.791  29.880  38.446  1.00 30.71           N  
ATOM   1432  CA  MET    39      30.141  30.329  38.764  1.00 28.97           C  
ATOM   1433  C   MET    39      29.976  31.552  39.652  1.00 28.65           C  
ATOM   1434  O   MET    39      28.998  32.284  39.522  1.00 27.14           O  
ATOM   1435  CB  MET    39      30.933  30.734  37.516  1.00 28.74           C  
ATOM   1436  CG  MET    39      31.363  29.598  36.573  1.00 31.41           C  
ATOM   1437  SD  MET    39      32.514  30.228  35.067  0.75 25.74          SE  
ATOM   1438  CE  MET    39      34.264  29.826  35.772  1.00 37.14           C  
ATOM   1439  N   SER    40      30.928  31.768  40.550  1.00 28.71           N  
ATOM   1440  CA  SER    40      30.961  32.977  41.347  1.00 28.93           C  
ATOM   1441  C   SER    40      31.356  34.119  40.422  1.00 29.26           C  
ATOM   1442  O   SER    40      31.856  33.886  39.321  1.00 28.27           O  
ATOM   1443  CB  SER    40      31.977  32.857  42.485  1.00 28.55           C  
ATOM   1444  OG  SER    40      33.300  32.845  41.971  1.00 31.56           O  
ATOM   1445  N   ALA    41      31.141  35.346  40.883  1.00 29.32           N  
ATOM   1446  CA  ALA    41      31.479  36.531  40.109  1.00 28.43           C  
ATOM   1447  C   ALA    41      32.928  36.492  39.643  1.00 28.87           C  
ATOM   1448  O   ALA    41      33.208  36.745  38.475  1.00 29.06           O  
ATOM   1449  CB  ALA    41      31.216  37.789  40.924  1.00 28.00           C  
ATOM   1450  N   GLU    42      33.844  36.156  40.549  1.00 30.19           N  
ATOM   1451  CA  GLU    42      35.266  36.137  40.215  1.00 32.30           C  
ATOM   1452  C   GLU    42      35.669  34.956  39.338  1.00 31.49           C  
ATOM   1453  O   GLU    42      36.549  35.098  38.495  1.00 31.64           O  
ATOM   1454  CB  GLU    42      36.150  36.217  41.468  1.00 32.29           C  
ATOM   1455  CG  GLU    42      36.145  35.016  42.371  1.00 35.81           C  
ATOM   1456  CD  GLU    42      37.144  35.156  43.514  1.00 36.28           C  
ATOM   1457  OE1 GLU    42      38.328  35.484  43.242  1.00 35.57           O  
ATOM   1458  OE2 GLU    42      36.744  34.923  44.680  1.00 43.97           O  
ATOM   1459  N   GLU    43      35.044  33.797  39.532  1.00 30.87           N  
ATOM   1460  CA  GLU    43      35.260  32.661  38.625  1.00 30.39           C  
ATOM   1461  C   GLU    43      34.845  33.040  37.214  1.00 29.35           C  
ATOM   1462  O   GLU    43      35.531  32.703  36.238  1.00 29.22           O  
ATOM   1463  CB  GLU    43      34.467  31.425  39.060  1.00 30.93           C  
ATOM   1464  CG  GLU    43      35.062  30.666  40.239  1.00 32.30           C  
ATOM   1465  CD  GLU    43      34.153  29.551  40.752  1.00 32.16           C  
ATOM   1466  OE1 GLU    43      32.930  29.604  40.535  1.00 35.30           O  
ATOM   1467  OE2 GLU    43      34.667  28.617  41.401  1.00 38.93           O  
ATOM   1468  N   LEU    44      33.722  33.747  37.111  1.00 27.81           N  
ATOM   1469  CA  LEU    44      33.205  34.170  35.813  1.00 27.14           C  
ATOM   1470  C   LEU    44      34.204  35.093  35.145  1.00 26.11           C  
ATOM   1471  O   LEU    44      34.615  34.849  34.019  1.00 26.10           O  
ATOM   1472  CB  LEU    44      31.835  34.853  35.958  1.00 27.33           C  
ATOM   1473  CG  LEU    44      31.197  35.427  34.687  1.00 26.54           C  
ATOM   1474  CD1 LEU    44      31.341  34.484  33.494  1.00 26.87           C  
ATOM   1475  CD2 LEU    44      29.729  35.714  34.941  1.00 25.50           C  
ATOM   1476  N   VAL    45      34.619  36.132  35.865  1.00 26.48           N  
ATOM   1477  CA  VAL    45      35.510  37.144  35.325  1.00 26.04           C  
ATOM   1478  C   VAL    45      36.867  36.552  34.944  1.00 27.08           C  
ATOM   1479  O   VAL    45      37.346  36.802  33.850  1.00 27.54           O  
ATOM   1480  CB  VAL    45      35.683  38.334  36.309  1.00 27.04           C  
ATOM   1481  CG1 VAL    45      36.744  39.312  35.797  1.00 25.46           C  
ATOM   1482  CG2 VAL    45      34.352  39.042  36.521  1.00 23.13           C  
ATOM   1483  N   LYS    46      37.482  35.767  35.827  1.00 28.21           N  
ATOM   1484  CA  LYS    46      38.793  35.155  35.522  1.00 29.00           C  
ATOM   1485  C   LYS    46      38.708  34.265  34.287  1.00 28.55           C  
ATOM   1486  O   LYS    46      39.629  34.250  33.464  1.00 29.07           O  
ATOM   1487  CB  LYS    46      39.324  34.321  36.690  1.00 29.20           C  
ATOM   1488  CG  LYS    46      39.776  35.118  37.886  1.00 31.60           C  
ATOM   1489  CD  LYS    46      40.299  34.197  38.968  1.00 29.66           C  
ATOM   1490  CE  LYS    46      40.389  34.916  40.294  1.00 37.54           C  
ATOM   1491  NZ  LYS    46      40.795  33.997  41.394  1.00 35.65           N  
ATOM   1492  N   HIS    47      37.616  33.505  34.172  1.00 27.91           N  
ATOM   1493  CA  HIS    47      37.432  32.622  33.016  1.00 27.17           C  
ATOM   1494  C   HIS    47      37.379  33.401  31.699  1.00 25.59           C  
ATOM   1495  O   HIS    47      37.956  32.964  30.704  1.00 26.75           O  
ATOM   1496  CB  HIS    47      36.190  31.743  33.159  1.00 27.46           C  
ATOM   1497  CG  HIS    47      35.905  30.922  31.937  1.00 28.87           C  
ATOM   1498  ND1 HIS    47      36.734  29.908  31.515  1.00 32.09           N  
ATOM   1499  CD2 HIS    47      34.908  30.996  31.025  1.00 28.90           C  
ATOM   1500  CE1 HIS    47      36.257  29.387  30.399  1.00 27.52           C  
ATOM   1501  NE2 HIS    47      35.146  30.027  30.083  1.00 28.54           N  
ATOM   1502  N   ILE    48      36.699  34.545  31.701  1.00 25.40           N  
ATOM   1503  CA  ILE    48      36.648  35.436  30.536  1.00 24.70           C  
ATOM   1504  C   ILE    48      38.065  35.852  30.154  1.00 25.30           C  
ATOM   1505  O   ILE    48      38.456  35.765  28.997  1.00 26.11           O  
ATOM   1506  CB  ILE    48      35.781  36.700  30.805  1.00 25.39           C  
ATOM   1507  CG1 ILE    48      34.294  36.324  30.910  1.00 26.97           C  
ATOM   1508  CG2 ILE    48      35.972  37.754  29.707  1.00 21.47           C  
ATOM   1509  CD1 ILE    48      33.372  37.436  31.476  1.00 21.56           C  
ATOM   1510  N   LEU    49      38.837  36.259  31.148  1.00 25.60           N  
ATOM   1511  CA  LEU    49      40.199  36.717  30.947  1.00 24.97           C  
ATOM   1512  C   LEU    49      41.170  35.634  30.482  1.00 25.95           C  
ATOM   1513  O   LEU    49      41.891  35.831  29.502  1.00 27.25           O  
ATOM   1514  CB  LEU    49      40.725  37.337  32.231  1.00 24.59           C  
ATOM   1515  CG  LEU    49      40.077  38.643  32.687  1.00 26.07           C  
ATOM   1516  CD1 LEU    49      40.707  39.082  34.017  1.00 25.43           C  
ATOM   1517  CD2 LEU    49      40.202  39.746  31.632  1.00 21.72           C  
ATOM   1518  N   THR    50      41.206  34.501  31.184  1.00 26.62           N  
ATOM   1519  CA  THR    50      42.139  33.428  30.831  1.00 26.53           C  
ATOM   1520  C   THR    50      41.768  32.721  29.518  1.00 28.19           C  
ATOM   1521  O   THR    50      42.664  32.330  28.753  1.00 29.08           O  
ATOM   1522  CB  THR    50      42.279  32.370  31.958  1.00 26.75           C  
ATOM   1523  OG1 THR    50      41.018  31.734  32.195  1.00 29.27           O  
ATOM   1524  CG2 THR    50      42.785  33.010  33.255  1.00 20.35           C  
ATOM   1525  N   SER    51      40.469  32.568  29.242  1.00 28.56           N  
ATOM   1526  CA  SER    51      40.053  31.808  28.064  1.00 29.13           C  
ATOM   1527  C   SER    51      40.431  32.521  26.777  1.00 28.90           C  
ATOM   1528  O   SER    51      40.940  31.880  25.847  1.00 30.53           O  
ATOM   1529  CB  SER    51      38.557  31.446  28.084  1.00 28.88           C  
ATOM   1530  OG  SER    51      37.727  32.590  28.069  1.00 33.02           O  
ATOM   1531  N   PHE    52      40.194  33.830  26.703  1.00 27.66           N  
ATOM   1532  CA  PHE    52      40.530  34.557  25.483  1.00 27.14           C  
ATOM   1533  C   PHE    52      42.039  34.554  25.296  1.00 27.70           C  
ATOM   1534  O   PHE    52      42.530  34.421  24.178  1.00 28.71           O  
ATOM   1535  CB  PHE    52      40.001  35.993  25.481  1.00 27.08           C  
ATOM   1536  CG  PHE    52      39.811  36.560  24.089  1.00 25.86           C  
ATOM   1537  CD1 PHE    52      40.907  36.795  23.256  1.00 25.78           C  
ATOM   1538  CD2 PHE    52      38.542  36.839  23.608  1.00 23.07           C  
ATOM   1539  CE1 PHE    52      40.725  37.299  21.977  1.00 26.17           C  
ATOM   1540  CE2 PHE    52      38.359  37.351  22.333  1.00 23.04           C  
ATOM   1541  CZ  PHE    52      39.446  37.570  21.514  1.00 23.22           C  
ATOM   1542  N   HIS    53      42.772  34.683  26.394  1.00 28.75           N  
ATOM   1543  CA  HIS    53      44.234  34.689  26.347  1.00 29.87           C  
ATOM   1544  C   HIS    53      44.799  33.336  25.861  1.00 29.22           C  
ATOM   1545  O   HIS    53      45.774  33.303  25.101  1.00 28.96           O  
ATOM   1546  CB  HIS    53      44.812  35.081  27.710  1.00 29.38           C  
ATOM   1547  CG  HIS    53      46.297  35.259  27.699  1.00 32.09           C  
ATOM   1548  ND1 HIS    53      47.161  34.324  28.221  1.00 36.75           N  
ATOM   1549  CD2 HIS    53      47.071  36.250  27.200  1.00 34.27           C  
ATOM   1550  CE1 HIS    53      48.405  34.738  28.056  1.00 36.33           C  
ATOM   1551  NE2 HIS    53      48.377  35.904  27.439  1.00 35.25           N  
ATOM   1552  N   LEU    54      44.175  32.237  26.280  1.00 28.84           N  
ATOM   1553  CA  LEU    54      44.545  30.908  25.787  1.00 29.41           C  
ATOM   1554  C   LEU    54      44.344  30.820  24.271  1.00 29.89           C  
ATOM   1555  O   LEU    54      45.283  30.469  23.530  1.00 28.10           O  
ATOM   1556  CB  LEU    54      43.746  29.812  26.501  1.00 28.57           C  
ATOM   1557  CG  LEU    54      44.049  28.359  26.102  1.00 30.83           C  
ATOM   1558  CD1 LEU    54      45.538  28.026  26.269  1.00 28.39           C  
ATOM   1559  CD2 LEU    54      43.180  27.371  26.890  1.00 30.29           C  
ATOM   1560  N   PHE    55      43.134  31.159  23.817  1.00 30.20           N  
ATOM   1561  CA  PHE    55      42.819  31.153  22.382  1.00 32.29           C  
ATOM   1562  C   PHE    55      43.787  32.023  21.577  1.00 31.95           C  
ATOM   1563  O   PHE    55      44.243  31.620  20.510  1.00 32.57           O  
ATOM   1564  CB  PHE    55      41.398  31.652  22.119  1.00 34.13           C  
ATOM   1565  CG  PHE    55      40.317  30.681  22.505  1.00 36.99           C  
ATOM   1566  CD1 PHE    55      40.343  29.372  22.063  1.00 39.85           C  
ATOM   1567  CD2 PHE    55      39.236  31.104  23.275  1.00 45.14           C  
ATOM   1568  CE1 PHE    55      39.330  28.494  22.403  1.00 44.15           C  
ATOM   1569  CE2 PHE    55      38.220  30.231  23.620  1.00 45.62           C  
ATOM   1570  CZ  PHE    55      38.263  28.923  23.179  1.00 43.03           C  
ATOM   1571  N   ALA    56      44.077  33.221  22.089  1.00 31.31           N  
ATOM   1572  CA  ALA    56      45.030  34.131  21.448  1.00 30.70           C  
ATOM   1573  C   ALA    56      46.421  33.491  21.272  1.00 29.92           C  
ATOM   1574  O   ALA    56      47.059  33.654  20.231  1.00 30.50           O  
ATOM   1575  CB  ALA    56      45.132  35.443  22.241  1.00 30.35           C  
ATOM   1576  N   ASN    57      46.879  32.749  22.274  1.00 30.14           N  
ATOM   1577  CA  ASN    57      48.161  32.034  22.164  1.00 31.35           C  
ATOM   1578  C   ASN    57      48.100  30.807  21.225  1.00 32.06           C  
ATOM   1579  O   ASN    57      49.095  30.465  20.591  1.00 32.88           O  
ATOM   1580  CB  ASN    57      48.708  31.665  23.553  1.00 31.09           C  
ATOM   1581  CG  ASN    57      49.664  32.728  24.110  1.00 33.29           C  
ATOM   1582  OD1 ASN    57      50.701  33.008  23.514  1.00 36.72           O  
ATOM   1583  ND2 ASN    57      49.326  33.305  25.261  1.00 32.00           N  
ATOM   1584  N   VAL    58      46.936  30.166  21.120  1.00 32.60           N  
ATOM   1585  CA  VAL    58      46.760  29.045  20.194  1.00 32.08           C  
ATOM   1586  C   VAL    58      46.876  29.526  18.742  1.00 32.30           C  
ATOM   1587  O   VAL    58      47.545  28.890  17.934  1.00 32.10           O  
ATOM   1588  CB  VAL    58      45.419  28.287  20.433  1.00 31.98           C  
ATOM   1589  CG1 VAL    58      45.237  27.157  19.410  1.00 29.82           C  
ATOM   1590  CG2 VAL    58      45.366  27.727  21.861  1.00 28.52           C  
ATOM   1591  N   ILE    59      46.235  30.650  18.422  1.00 32.76           N  
ATOM   1592  CA  ILE    59      46.363  31.279  17.092  1.00 33.21           C  
ATOM   1593  C   ILE    59      47.797  31.770  16.842  1.00 33.87           C  
ATOM   1594  O   ILE    59      48.332  31.642  15.741  1.00 33.61           O  
ATOM   1595  CB  ILE    59      45.427  32.500  16.938  1.00 33.99           C  
ATOM   1596  CG1 ILE    59      43.950  32.095  17.083  1.00 33.69           C  
ATOM   1597  CG2 ILE    59      45.664  33.206  15.586  1.00 31.95           C  
ATOM   1598  CD1 ILE    59      43.006  33.284  17.176  1.00 32.20           C  
ATOM   1599  N   LYS    60      48.411  32.330  17.872  1.00 35.71           N  
ATOM   1600  CA  LYS    60      49.772  32.840  17.767  1.00 37.57           C  
ATOM   1601  C   LYS    60      50.764  31.721  17.441  1.00 38.24           C  
ATOM   1602  O   LYS    60      51.604  31.872  16.562  1.00 37.60           O  
ATOM   1603  CB  LYS    60      50.174  33.557  19.062  1.00 37.54           C  
ATOM   1604  CG  LYS    60      51.655  33.883  19.189  1.00 36.89           C  
ATOM   1605  CD  LYS    60      51.907  34.811  20.361  1.00 39.39           C  
ATOM   1606  CE  LYS    60      53.381  34.926  20.678  1.00 43.88           C  
ATOM   1607  NZ  LYS    60      53.698  36.138  21.480  1.00 45.53           N  
ATOM   1608  N   GLU    61      50.662  30.603  18.150  1.00 39.86           N  
ATOM   1609  CA  GLU    61      51.580  29.486  17.934  1.00 40.82           C  
ATOM   1610  C   GLU    61      51.197  28.632  16.722  1.00 41.21           C  
ATOM   1611  O   GLU    61      52.065  28.113  16.025  1.00 41.01           O  
ATOM   1612  CB  GLU    61      51.673  28.611  19.193  1.00 40.22           C  
ATOM   1613  CG  GLU    61      52.201  29.330  20.445  1.00 41.09           C  
ATOM   1614  CD  GLU    61      53.587  29.968  20.275  1.00 41.98           C  
ATOM   1615  OE1 GLU    61      54.314  29.626  19.319  1.00 43.56           O  
ATOM   1616  OE2 GLU    61      53.956  30.816  21.114  1.00 41.89           O  
ATOM   1617  N   GLY    62      49.896  28.506  16.472  1.00 42.51           N  
ATOM   1618  CA  GLY    62      49.378  27.596  15.455  1.00 43.05           C  
ATOM   1619  C   GLY    62      49.304  26.169  15.972  1.00 43.55           C  
ATOM   1620  O   GLY    62      48.994  25.252  15.216  1.00 44.20           O  
ATOM   1621  N   ASN    63      49.576  25.996  17.266  1.00 44.07           N  
ATOM   1622  CA  ASN    63      49.674  24.692  17.917  1.00 44.21           C  
ATOM   1623  C   ASN    63      48.667  24.579  19.044  1.00 44.05           C  
ATOM   1624  O   ASN    63      48.103  25.579  19.482  1.00 43.63           O  
ATOM   1625  CB  ASN    63      51.057  24.530  18.552  1.00 43.35           C  
ATOM   1626  CG  ASN    63      52.175  24.755  17.581  1.00 46.03           C  
ATOM   1627  OD1 ASN    63      52.015  24.563  16.380  1.00 56.39           O  
ATOM   1628  ND2 ASN    63      53.329  25.158  18.093  1.00 46.14           N  
ATOM   1629  N   ALA    64      48.497  23.354  19.541  1.00 44.06           N  
ATOM   1630  CA  ALA    64      47.735  23.100  20.759  1.00 43.65           C  
ATOM   1631  C   ALA    64      48.652  23.159  21.986  1.00 42.60           C  
ATOM   1632  O   ALA    64      48.215  22.878  23.100  1.00 42.66           O  
ATOM   1633  CB  ALA    64      47.047  21.750  20.674  1.00 44.16           C  
ATOM   1634  N   SER    65      49.913  23.548  21.778  1.00 41.62           N  
ATOM   1635  CA  SER    65      50.914  23.588  22.848  1.00 40.66           C  
ATOM   1636  C   SER    65      50.624  24.576  23.992  1.00 39.74           C  
ATOM   1637  O   SER    65      50.986  24.293  25.121  1.00 39.46           O  
ATOM   1638  CB  SER    65      52.332  23.802  22.273  1.00 39.86           C  
ATOM   1639  OG  SER    65      52.479  25.053  21.630  1.00 38.52           O  
ATOM   1640  N   PRO    66      49.983  25.731  23.718  1.00 39.50           N  
ATOM   1641  CA  PRO    66      49.632  26.610  24.848  1.00 39.62           C  
ATOM   1642  C   PRO    66      48.674  26.005  25.903  1.00 40.52           C  
ATOM   1643  O   PRO    66      48.529  26.577  26.989  1.00 40.07           O  
ATOM   1644  CB  PRO    66      48.999  27.830  24.163  1.00 39.89           C  
ATOM   1645  CG  PRO    66      49.525  27.792  22.756  1.00 39.12           C  
ATOM   1646  CD  PRO    66      49.599  26.337  22.428  1.00 39.03           C  
ATOM   1647  N   PHE    67      48.033  24.874  25.599  1.00 41.75           N  
ATOM   1648  CA  PHE    67      47.273  24.136  26.617  1.00 43.43           C  
ATOM   1649  C   PHE    67      48.212  23.489  27.643  1.00 44.65           C  
ATOM   1650  O   PHE    67      47.832  23.293  28.801  1.00 44.48           O  
ATOM   1651  CB  PHE    67      46.384  23.053  25.996  1.00 44.15           C  
ATOM   1652  CG  PHE    67      45.455  23.559  24.931  1.00 45.35           C  
ATOM   1653  CD1 PHE    67      44.694  24.703  25.134  1.00 48.97           C  
ATOM   1654  CD2 PHE    67      45.327  22.883  23.728  1.00 47.36           C  
ATOM   1655  CE1 PHE    67      43.834  25.171  24.148  1.00 47.77           C  
ATOM   1656  CE2 PHE    67      44.476  23.353  22.740  1.00 47.83           C  
ATOM   1657  CZ  PHE    67      43.728  24.495  22.955  1.00 44.88           C  
ATOM   1658  N   GLN    68      49.425  23.149  27.209  1.00 46.69           N  
ATOM   1659  CA  GLN    68      50.444  22.560  28.089  1.00 48.37           C  
ATOM   1660  C   GLN    68      50.999  23.583  29.073  1.00 50.08           C  
ATOM   1661  O   GLN    68      51.458  23.216  30.156  1.00 50.91           O  
ATOM   1662  CB  GLN    68      51.607  21.962  27.275  1.00 48.44           C  
ATOM   1663  CG  GLN    68      51.370  20.560  26.709  1.00 49.99           C  
ATOM   1664  CD  GLN    68      50.026  20.407  26.019  1.00 50.43           C  
ATOM   1665  OE1 GLN    68      48.982  20.371  26.673  1.00 50.63           O  
ATOM   1666  NE2 GLN    68      50.047  20.305  24.691  1.00 50.53           N  
ATOM   1667  N   ASN    69      50.974  24.859  28.688  1.00 51.88           N  
ATOM   1668  CA  ASN    69      51.449  25.938  29.552  1.00 53.28           C  
ATOM   1669  C   ASN    69      50.511  26.154  30.740  1.00 54.71           C  
ATOM   1670  O   ASN    69      49.505  26.850  30.618  1.00 54.91           O  
ATOM   1671  CB  ASN    69      51.588  27.240  28.752  1.00 53.14           C  
ATOM   1672  N   LYS    70      50.835  25.536  31.874  1.00 57.03           N  
ATOM   1673  CA  LYS    70      50.099  25.758  33.119  1.00 58.38           C  
ATOM   1674  C   LYS    70      50.589  27.059  33.750  1.00 59.82           C  
ATOM   1675  O   LYS    70      51.596  27.058  34.465  1.00 59.85           O  
ATOM   1676  CB  LYS    70      50.324  24.599  34.092  1.00 58.61           C  
ATOM   1677  N   GLN    71      49.889  28.161  33.473  1.00 61.09           N  
ATOM   1678  CA  GLN    71      50.291  29.486  33.963  1.00 62.37           C  
ATOM   1679  C   GLN    71      49.654  29.793  35.321  1.00 63.43           C  
ATOM   1680  O   GLN    71      48.464  30.126  35.397  1.00 64.18           O  
ATOM   1681  CB  GLN    71      49.910  30.572  32.952  1.00 62.69           C  
ATOM   1682  N   GLU    72      50.451  29.679  36.386  1.00 63.24           N  
ATOM   1683  CA  GLU    72      49.984  29.958  37.746  1.00 62.89           C  
ATOM   1684  C   GLU    72      49.973  31.469  38.008  1.00 62.36           C  
ATOM   1685  O   GLU    72      50.992  32.045  38.403  1.00 62.30           O  
ATOM   1686  CB  GLU    72      50.871  29.246  38.777  1.00 62.86           C  
ATOM   1687  N   GLU    73      48.824  32.106  37.772  1.00 60.95           N  
ATOM   1688  CA  GLU    73      48.670  33.540  38.035  1.00 59.65           C  
ATOM   1689  C   GLU    73      48.477  33.737  39.540  1.00 57.43           C  
ATOM   1690  O   GLU    73      47.552  33.173  40.130  1.00 57.80           O  
ATOM   1691  CB  GLU    73      47.484  34.123  37.250  1.00 60.09           C  
ATOM   1692  CG  GLU    73      47.401  35.662  37.243  1.00 60.77           C  
ATOM   1693  CD  GLU    73      48.532  36.354  36.463  1.00 62.91           C  
ATOM   1694  OE1 GLU    73      49.224  35.689  35.663  1.00 64.78           O  
ATOM   1695  OE2 GLU    73      48.720  37.577  36.645  1.00 61.24           O  
ATOM   1696  N   THR    74      49.361  34.526  40.149  1.00 54.02           N  
ATOM   1697  CA  THR    74      49.358  34.754  41.597  1.00 52.74           C  
ATOM   1698  C   THR    74      48.387  35.863  42.044  1.00 51.44           C  
ATOM   1699  O   THR    74      47.943  35.871  43.196  1.00 51.74           O  
ATOM   1700  CB  THR    74      50.775  35.105  42.101  1.00 52.41           C  
ATOM   1701  N   GLU    75      48.058  36.784  41.135  1.00 49.36           N  
ATOM   1702  CA  GLU    75      47.214  37.939  41.455  1.00 47.02           C  
ATOM   1703  C   GLU    75      45.759  37.533  41.711  1.00 45.84           C  
ATOM   1704  O   GLU    75      45.231  36.654  41.029  1.00 46.17           O  
ATOM   1705  CB  GLU    75      47.283  38.962  40.312  1.00 46.52           C  
ATOM   1706  CG  GLU    75      46.513  40.248  40.573  1.00 44.62           C  
ATOM   1707  CD  GLU    75      47.058  41.016  41.759  1.00 42.04           C  
ATOM   1708  OE1 GLU    75      48.292  41.233  41.800  1.00 33.54           O  
ATOM   1709  OE2 GLU    75      46.253  41.402  42.637  1.00 35.78           O  
ATOM   1710  N   THR    76      45.133  38.178  42.697  1.00 44.18           N  
ATOM   1711  CA  THR    76      43.737  37.915  43.069  1.00 42.84           C  
ATOM   1712  C   THR    76      42.803  39.105  42.845  1.00 41.12           C  
ATOM   1713  O   THR    76      41.591  38.923  42.736  1.00 41.75           O  
ATOM   1714  CB  THR    76      43.627  37.523  44.548  1.00 43.10           C  
ATOM   1715  OG1 THR    76      44.363  38.464  45.345  1.00 44.47           O  
ATOM   1716  CG2 THR    76      44.167  36.111  44.770  1.00 43.34           C  
ATOM   1717  N   ASP    77      43.351  40.318  42.805  1.00 38.64           N  
ATOM   1718  CA  ASP    77      42.547  41.494  42.522  1.00 36.40           C  
ATOM   1719  C   ASP    77      42.053  41.379  41.091  1.00 34.51           C  
ATOM   1720  O   ASP    77      42.855  41.330  40.155  1.00 32.72           O  
ATOM   1721  CB  ASP    77      43.351  42.785  42.726  1.00 36.29           C  
ATOM   1722  CG  ASP    77      42.471  44.032  42.705  1.00 36.98           C  
ATOM   1723  OD1 ASP    77      41.907  44.355  41.639  1.00 32.41           O  
ATOM   1724  OD2 ASP    77      42.349  44.695  43.757  1.00 42.30           O  
ATOM   1725  N   LEU    78      40.728  41.321  40.945  1.00 33.17           N  
ATOM   1726  CA  LEU    78      40.084  41.188  39.644  1.00 31.83           C  
ATOM   1727  C   LEU    78      40.447  42.312  38.690  1.00 30.92           C  
ATOM   1728  O   LEU    78      40.630  42.063  37.501  1.00 30.51           O  
ATOM   1729  CB  LEU    78      38.554  41.136  39.777  1.00 31.06           C  
ATOM   1730  CG  LEU    78      37.884  39.831  40.213  1.00 30.15           C  
ATOM   1731  CD1 LEU    78      36.382  39.991  40.079  1.00 28.75           C  
ATOM   1732  CD2 LEU    78      38.360  38.634  39.408  1.00 26.53           C  
ATOM   1733  N   ASN    79      40.528  43.540  39.205  1.00 31.00           N  
ATOM   1734  CA  ASN    79      40.795  44.709  38.361  1.00 31.40           C  
ATOM   1735  C   ASN    79      42.207  44.677  37.806  1.00 30.64           C  
ATOM   1736  O   ASN    79      42.430  45.047  36.659  1.00 32.32           O  
ATOM   1737  CB  ASN    79      40.519  46.014  39.113  1.00 30.97           C  
ATOM   1738  CG  ASN    79      39.047  46.191  39.445  1.00 32.77           C  
ATOM   1739  OD1 ASN    79      38.169  45.793  38.669  1.00 34.47           O  
ATOM   1740  ND2 ASN    79      38.767  46.792  40.597  1.00 31.40           N  
ATOM   1741  N   VAL    80      43.145  44.198  38.613  1.00 30.86           N  
ATOM   1742  CA  VAL    80      44.527  43.995  38.176  1.00 30.48           C  
ATOM   1743  C   VAL    80      44.626  42.802  37.208  1.00 30.68           C  
ATOM   1744  O   VAL    80      45.369  42.850  36.230  1.00 32.36           O  
ATOM   1745  CB  VAL    80      45.453  43.767  39.378  1.00 30.21           C  
ATOM   1746  CG1 VAL    80      46.886  43.546  38.914  1.00 28.13           C  
ATOM   1747  CG2 VAL    80      45.352  44.942  40.345  1.00 27.39           C  
ATOM   1748  N   LEU    81      43.884  41.731  37.480  1.00 30.58           N  
ATOM   1749  CA  LEU    81      43.817  40.603  36.546  1.00 30.81           C  
ATOM   1750  C   LEU    81      43.247  41.057  35.200  1.00 30.95           C  
ATOM   1751  O   LEU    81      43.794  40.737  34.148  1.00 31.51           O  
ATOM   1752  CB  LEU    81      42.979  39.451  37.110  1.00 30.49           C  
ATOM   1753  CG  LEU    81      43.664  38.568  38.154  1.00 32.45           C  
ATOM   1754  CD1 LEU    81      42.657  37.683  38.888  1.00 28.60           C  
ATOM   1755  CD2 LEU    81      44.748  37.729  37.503  1.00 32.31           C  
ATOM   1756  N   ALA    82      42.162  41.827  35.243  1.00 31.30           N  
ATOM   1757  CA  ALA    82      41.511  42.328  34.029  1.00 29.87           C  
ATOM   1758  C   ALA    82      42.455  43.178  33.184  1.00 29.55           C  
ATOM   1759  O   ALA    82      42.555  42.976  31.975  1.00 29.00           O  
ATOM   1760  CB  ALA    82      40.252  43.108  34.382  1.00 27.98           C  
ATOM   1761  N   LYS    83      43.145  44.114  33.827  1.00 30.62           N  
ATOM   1762  CA  LYS    83      44.095  45.003  33.147  1.00 32.82           C  
ATOM   1763  C   LYS    83      45.278  44.247  32.545  1.00 31.38           C  
ATOM   1764  O   LYS    83      45.603  44.429  31.383  1.00 31.61           O  
ATOM   1765  CB  LYS    83      44.612  46.060  34.122  1.00 33.23           C  
ATOM   1766  CG  LYS    83      45.524  47.089  33.488  1.00 35.47           C  
ATOM   1767  CD  LYS    83      45.840  48.216  34.451  1.00 36.43           C  
ATOM   1768  CE  LYS    83      46.837  49.196  33.841  1.00 42.15           C  
ATOM   1769  NZ  LYS    83      47.235  50.260  34.808  1.00 48.16           N  
ATOM   1770  N   THR    84      45.915  43.410  33.352  1.00 31.31           N  
ATOM   1771  CA  THR    84      47.066  42.615  32.918  1.00 31.31           C  
ATOM   1772  C   THR    84      46.767  41.681  31.742  1.00 30.31           C  
ATOM   1773  O   THR    84      47.511  41.650  30.762  1.00 29.48           O  
ATOM   1774  CB  THR    84      47.595  41.795  34.095  1.00 30.96           C  
ATOM   1775  OG1 THR    84      48.174  42.693  35.047  1.00 32.33           O  
ATOM   1776  CG2 THR    84      48.648  40.779  33.637  1.00 34.24           C  
ATOM   1777  N   TYR    85      45.676  40.927  31.847  1.00 30.38           N  
ATOM   1778  CA  TYR    85      45.284  39.982  30.797  1.00 30.35           C  
ATOM   1779  C   TYR    85      44.820  40.665  29.510  1.00 29.76           C  
ATOM   1780  O   TYR    85      44.976  40.115  28.423  1.00 29.50           O  
ATOM   1781  CB  TYR    85      44.195  39.038  31.306  1.00 31.62           C  
ATOM   1782  CG  TYR    85      44.726  37.797  31.993  1.00 31.20           C  
ATOM   1783  CD1 TYR    85      45.237  36.746  31.245  1.00 32.21           C  
ATOM   1784  CD2 TYR    85      44.680  37.656  33.381  1.00 32.86           C  
ATOM   1785  CE1 TYR    85      45.701  35.590  31.850  1.00 32.84           C  
ATOM   1786  CE2 TYR    85      45.147  36.493  34.003  1.00 32.36           C  
ATOM   1787  CZ  TYR    85      45.657  35.467  33.229  1.00 33.24           C  
ATOM   1788  OH  TYR    85      46.137  34.309  33.811  1.00 34.89           O  
ATOM   1789  N   THR    86      44.235  41.848  29.638  1.00 31.05           N  
ATOM   1790  CA  THR    86      43.815  42.641  28.486  1.00 31.05           C  
ATOM   1791  C   THR    86      45.045  43.122  27.733  1.00 32.15           C  
ATOM   1792  O   THR    86      45.109  42.994  26.512  1.00 32.75           O  
ATOM   1793  CB  THR    86      42.918  43.820  28.928  1.00 30.81           C  
ATOM   1794  OG1 THR    86      41.726  43.284  29.508  1.00 29.76           O  
ATOM   1795  CG2 THR    86      42.532  44.732  27.760  1.00 26.40           C  
ATOM   1796  N   GLU    87      46.025  43.652  28.471  1.00 32.42           N  
ATOM   1797  CA  GLU    87      47.300  44.084  27.899  1.00 33.13           C  
ATOM   1798  C   GLU    87      48.047  42.928  27.211  1.00 31.43           C  
ATOM   1799  O   GLU    87      48.576  43.091  26.114  1.00 30.84           O  
ATOM   1800  CB  GLU    87      48.193  44.737  28.977  1.00 33.57           C  
ATOM   1801  CG  GLU    87      47.674  46.098  29.487  1.00 36.24           C  
ATOM   1802  CD  GLU    87      48.430  46.649  30.705  1.00 36.39           C  
ATOM   1803  OE1 GLU    87      49.213  45.898  31.339  1.00 42.87           O  
ATOM   1804  OE2 GLU    87      48.224  47.844  31.039  1.00 41.68           O  
ATOM   1805  N   LYS    88      48.086  41.769  27.857  1.00 30.05           N  
ATOM   1806  CA  LYS    88      48.724  40.586  27.275  1.00 31.07           C  
ATOM   1807  C   LYS    88      48.015  40.085  26.007  1.00 29.92           C  
ATOM   1808  O   LYS    88      48.669  39.628  25.061  1.00 30.19           O  
ATOM   1809  CB  LYS    88      48.768  39.444  28.295  1.00 31.28           C  
ATOM   1810  CG  LYS    88      49.807  39.588  29.405  1.00 32.74           C  
ATOM   1811  CD  LYS    88      49.487  38.619  30.542  1.00 34.44           C  
ATOM   1812  CE  LYS    88      50.726  38.125  31.283  1.00 39.86           C  
ATOM   1813  NZ  LYS    88      51.268  39.116  32.264  1.00 38.26           N  
ATOM   1814  N   THR    89      46.686  40.150  26.003  1.00 28.30           N  
ATOM   1815  CA  THR    89      45.907  39.659  24.876  1.00 26.91           C  
ATOM   1816  C   THR    89      45.994  40.627  23.697  1.00 26.04           C  
ATOM   1817  O   THR    89      46.155  40.197  22.563  1.00 25.57           O  
ATOM   1818  CB  THR    89      44.432  39.370  25.276  1.00 26.83           C  
ATOM   1819  OG1 THR    89      44.402  38.387  26.321  1.00 26.62           O  
ATOM   1820  CG2 THR    89      43.649  38.837  24.091  1.00 21.94           C  
ATOM   1821  N   VAL    90      45.916  41.928  23.970  1.00 25.73           N  
ATOM   1822  CA  VAL    90      46.100  42.954  22.935  1.00 24.97           C  
ATOM   1823  C   VAL    90      47.491  42.846  22.274  1.00 25.21           C  
ATOM   1824  O   VAL    90      47.625  42.875  21.044  1.00 24.21           O  
ATOM   1825  CB  VAL    90      45.922  44.368  23.530  1.00 26.15           C  
ATOM   1826  CG1 VAL    90      46.342  45.465  22.513  1.00 25.78           C  
ATOM   1827  CG2 VAL    90      44.477  44.564  24.014  1.00 24.53           C  
ATOM   1828  N   ALA    91      48.522  42.690  23.092  1.00 24.60           N  
ATOM   1829  CA  ALA    91      49.883  42.534  22.583  1.00 25.64           C  
ATOM   1830  C   ALA    91      49.993  41.348  21.616  1.00 27.64           C  
ATOM   1831  O   ALA    91      50.684  41.436  20.600  1.00 29.22           O  
ATOM   1832  CB  ALA    91      50.884  42.412  23.746  1.00 24.73           C  
ATOM   1833  N   ILE    92      49.284  40.255  21.896  1.00 29.04           N  
ATOM   1834  CA  ILE    92      49.251  39.131  20.956  1.00 29.11           C  
ATOM   1835  C   ILE    92      48.443  39.481  19.694  1.00 30.76           C  
ATOM   1836  O   ILE    92      48.935  39.307  18.568  1.00 31.05           O  
ATOM   1837  CB  ILE    92      48.682  37.846  21.579  1.00 29.24           C  
ATOM   1838  CG1 ILE    92      49.595  37.340  22.711  1.00 30.86           C  
ATOM   1839  CG2 ILE    92      48.552  36.775  20.506  1.00 23.58           C  
ATOM   1840  CD1 ILE    92      49.028  36.148  23.491  1.00 28.37           C  
ATOM   1841  N   LEU    93      47.221  39.983  19.890  1.00 30.68           N  
ATOM   1842  CA  LEU    93      46.329  40.312  18.782  1.00 31.19           C  
ATOM   1843  C   LEU    93      46.942  41.317  17.798  1.00 33.19           C  
ATOM   1844  O   LEU    93      46.804  41.152  16.584  1.00 32.19           O  
ATOM   1845  CB  LEU    93      44.981  40.836  19.305  1.00 30.38           C  
ATOM   1846  CG  LEU    93      44.072  39.867  20.066  1.00 28.57           C  
ATOM   1847  CD1 LEU    93      42.719  40.515  20.315  1.00 27.89           C  
ATOM   1848  CD2 LEU    93      43.904  38.560  19.325  1.00 24.19           C  
ATOM   1849  N   GLU    94      47.626  42.337  18.330  1.00 35.21           N  
ATOM   1850  CA  GLU    94      48.307  43.369  17.523  1.00 37.43           C  
ATOM   1851  C   GLU    94      49.279  42.824  16.477  1.00 38.02           C  
ATOM   1852  O   GLU    94      49.540  43.469  15.471  1.00 39.24           O  
ATOM   1853  CB  GLU    94      49.157  44.276  18.417  1.00 37.45           C  
ATOM   1854  CG  GLU    94      48.437  45.346  19.215  1.00 39.62           C  
ATOM   1855  CD  GLU    94      49.393  46.060  20.179  1.00 40.91           C  
ATOM   1856  OE1 GLU    94      50.569  45.626  20.285  1.00 44.33           O  
ATOM   1857  OE2 GLU    94      48.981  47.052  20.823  1.00 44.87           O  
ATOM   1858  N   GLN    95      49.868  41.672  16.757  1.00 38.62           N  
ATOM   1859  CA  GLN    95      50.925  41.131  15.921  1.00 39.16           C  
ATOM   1860  C   GLN    95      50.427  40.055  14.970  1.00 39.45           C  
ATOM   1861  O   GLN    95      51.135  39.700  14.038  1.00 40.62           O  
ATOM   1862  CB  GLN    95      52.020  40.554  16.816  1.00 40.08           C  
ATOM   1863  CG  GLN    95      52.579  41.550  17.832  1.00 42.36           C  
ATOM   1864  CD  GLN    95      53.520  42.551  17.202  1.00 46.73           C  
ATOM   1865  OE1 GLN    95      53.167  43.716  16.994  1.00 45.61           O  
ATOM   1866  NE2 GLN    95      54.729  42.096  16.877  1.00 50.68           N  
ATOM   1867  N   LEU    96      49.215  39.540  15.194  1.00 39.81           N  
ATOM   1868  CA  LEU    96      48.690  38.454  14.376  1.00 39.64           C  
ATOM   1869  C   LEU    96      48.600  38.845  12.906  1.00 40.14           C  
ATOM   1870  O   LEU    96      47.997  39.860  12.560  1.00 41.09           O  
ATOM   1871  CB  LEU    96      47.323  37.991  14.884  1.00 40.07           C  
ATOM   1872  CG  LEU    96      47.325  37.192  16.188  1.00 36.48           C  
ATOM   1873  CD1 LEU    96      45.897  36.863  16.590  1.00 34.41           C  
ATOM   1874  CD2 LEU    96      48.160  35.932  16.053  1.00 34.32           C  
ATOM   1875  N   THR    97      49.214  38.020  12.060  1.00 40.77           N  
ATOM   1876  CA  THR    97      49.279  38.234  10.615  1.00 40.51           C  
ATOM   1877  C   THR    97      48.149  37.480   9.901  1.00 40.99           C  
ATOM   1878  O   THR    97      47.577  36.530  10.442  1.00 40.42           O  
ATOM   1879  CB  THR    97      50.644  37.755  10.051  1.00 40.10           C  
ATOM   1880  OG1 THR    97      50.761  36.336  10.198  1.00 40.62           O  
ATOM   1881  CG2 THR    97      51.796  38.419  10.788  1.00 38.60           C  
ATOM   1882  N   GLU    98      47.826  37.916   8.688  1.00 41.70           N  
ATOM   1883  CA  GLU    98      46.781  37.269   7.889  1.00 42.96           C  
ATOM   1884  C   GLU    98      47.103  35.792   7.645  1.00 42.45           C  
ATOM   1885  O   GLU    98      46.204  34.969   7.536  1.00 42.13           O  
ATOM   1886  CB  GLU    98      46.577  38.023   6.565  1.00 43.80           C  
ATOM   1887  CG  GLU    98      45.735  39.297   6.722  1.00 46.73           C  
ATOM   1888  CD  GLU    98      44.267  38.992   6.996  1.00 51.55           C  
ATOM   1889  OE1 GLU    98      43.648  38.291   6.166  1.00 53.83           O  
ATOM   1890  OE2 GLU    98      43.731  39.443   8.037  1.00 53.34           O  
ATOM   1891  N   GLU    99      48.396  35.478   7.588  1.00 42.79           N  
ATOM   1892  CA  GLU    99      48.895  34.105   7.480  1.00 43.72           C  
ATOM   1893  C   GLU    99      48.494  33.277   8.694  1.00 41.44           C  
ATOM   1894  O   GLU    99      48.041  32.136   8.555  1.00 40.91           O  
ATOM   1895  CB  GLU    99      50.427  34.128   7.368  1.00 44.27           C  
ATOM   1896  CG  GLU    99      51.118  32.763   7.344  1.00 47.94           C  
ATOM   1897  CD  GLU    99      52.606  32.854   7.693  1.00 48.92           C  
ATOM   1898  OE1 GLU    99      52.937  33.477   8.732  1.00 61.99           O  
ATOM   1899  OE2 GLU    99      53.440  32.296   6.939  1.00 52.94           O  
ATOM   1900  N   GLN   100      48.693  33.847   9.883  1.00 39.56           N  
ATOM   1901  CA  GLN   100      48.308  33.198  11.140  1.00 37.57           C  
ATOM   1902  C   GLN   100      46.789  33.034  11.271  1.00 35.88           C  
ATOM   1903  O   GLN   100      46.315  32.075  11.865  1.00 34.56           O  
ATOM   1904  CB  GLN   100      48.865  33.972  12.335  1.00 37.95           C  
ATOM   1905  CG  GLN   100      50.361  33.753  12.560  1.00 35.36           C  
ATOM   1906  CD  GLN   100      50.928  34.653  13.650  1.00 37.02           C  
ATOM   1907  OE1 GLN   100      50.688  35.861  13.655  1.00 35.51           O  
ATOM   1908  NE2 GLN   100      51.688  34.064  14.577  1.00 28.77           N  
ATOM   1909  N   LEU   101      46.041  33.973  10.700  1.00 36.17           N  
ATOM   1910  CA  LEU   101      44.583  33.911  10.672  1.00 36.04           C  
ATOM   1911  C   LEU   101      44.073  32.913   9.633  1.00 37.42           C  
ATOM   1912  O   LEU   101      43.082  32.221   9.870  1.00 38.35           O  
ATOM   1913  CB  LEU   101      44.009  35.305  10.394  1.00 35.43           C  
ATOM   1914  CG  LEU   101      44.231  36.320  11.524  1.00 34.17           C  
ATOM   1915  CD1 LEU   101      44.014  37.731  11.053  1.00 35.54           C  
ATOM   1916  CD2 LEU   101      43.314  36.006  12.707  1.00 29.97           C  
ATOM   1917  N   ASP   102      44.753  32.842   8.488  1.00 38.87           N  
ATOM   1918  CA  ASP   102      44.334  31.980   7.378  1.00 39.41           C  
ATOM   1919  C   ASP   102      44.687  30.510   7.582  1.00 39.52           C  
ATOM   1920  O   ASP   102      43.960  29.630   7.119  1.00 40.06           O  
ATOM   1921  CB  ASP   102      44.945  32.476   6.060  1.00 40.18           C  
ATOM   1922  CG  ASP   102      44.274  33.742   5.538  1.00 41.84           C  
ATOM   1923  OD1 ASP   102      43.098  33.969   5.877  1.00 44.15           O  
ATOM   1924  OD2 ASP   102      44.916  34.501   4.776  1.00 44.89           O  
ATOM   1925  N   ARG   103      45.780  30.242   8.288  1.00 39.77           N  
ATOM   1926  CA  ARG   103      46.285  28.875   8.425  1.00 40.80           C  
ATOM   1927  C   ARG   103      45.443  27.996   9.334  1.00 41.55           C  
ATOM   1928  O   ARG   103      44.794  28.468  10.260  1.00 41.57           O  
ATOM   1929  CB  ARG   103      47.731  28.872   8.931  1.00 40.90           C  
ATOM   1930  CG  ARG   103      47.888  29.243  10.392  1.00 42.29           C  
ATOM   1931  CD  ARG   103      49.339  29.471  10.724  1.00 44.86           C  
ATOM   1932  NE  ARG   103      49.550  29.752  12.139  1.00 45.75           N  
ATOM   1933  CZ  ARG   103      50.715  30.125  12.661  1.00 47.88           C  
ATOM   1934  NH1 ARG   103      51.797  30.276  11.895  1.00 46.92           N  
ATOM   1935  NH2 ARG   103      50.802  30.357  13.962  1.00 48.77           N  
ATOM   1936  N   GLU   104      45.500  26.700   9.059  1.00 42.30           N  
ATOM   1937  CA  GLU   104      44.841  25.683   9.859  1.00 42.85           C  
ATOM   1938  C   GLU   104      45.654  25.353  11.112  1.00 41.15           C  
ATOM   1939  O   GLU   104      46.859  25.119  11.035  1.00 40.82           O  
ATOM   1940  CB  GLU   104      44.662  24.412   9.025  1.00 43.55           C  
ATOM   1941  CG  GLU   104      43.506  23.559   9.459  1.00 48.29           C  
ATOM   1942  CD  GLU   104      42.933  22.766   8.320  1.00 54.58           C  
ATOM   1943  OE1 GLU   104      43.648  21.883   7.807  1.00 57.58           O  
ATOM   1944  OE2 GLU   104      41.772  23.036   7.941  1.00 58.33           O  
ATOM   1945  N   ILE   105      44.980  25.348  12.258  1.00 40.26           N  
ATOM   1946  CA  ILE   105      45.561  24.903  13.517  1.00 39.85           C  
ATOM   1947  C   ILE   105      45.102  23.459  13.741  1.00 40.87           C  
ATOM   1948  O   ILE   105      43.896  23.195  13.806  1.00 38.41           O  
ATOM   1949  CB  ILE   105      45.100  25.787  14.698  1.00 39.56           C  
ATOM   1950  CG1 ILE   105      45.389  27.263  14.410  1.00 41.36           C  
ATOM   1951  CG2 ILE   105      45.783  25.371  15.987  1.00 36.65           C  
ATOM   1952  CD1 ILE   105      44.838  28.207  15.451  1.00 38.91           C  
ATOM   1953  N   ASP   106      46.055  22.530  13.838  1.00 43.16           N  
ATOM   1954  CA  ASP   106      45.735  21.110  14.079  1.00 45.33           C  
ATOM   1955  C   ASP   106      45.508  20.819  15.575  1.00 46.30           C  
ATOM   1956  O   ASP   106      46.472  20.721  16.343  1.00 47.07           O  
ATOM   1957  CB  ASP   106      46.851  20.206  13.529  1.00 45.75           C  
ATOM   1958  CG  ASP   106      46.547  18.715  13.689  1.00 48.90           C  
ATOM   1959  OD1 ASP   106      45.436  18.361  14.159  1.00 54.25           O  
ATOM   1960  OD2 ASP   106      47.426  17.896  13.340  1.00 48.22           O  
ATOM   1961  N   LEU   107      44.242  20.665  15.974  1.00 47.64           N  
ATOM   1962  CA  LEU   107      43.881  20.387  17.375  1.00 48.79           C  
ATOM   1963  C   LEU   107      43.225  19.004  17.581  1.00 49.78           C  
ATOM   1964  O   LEU   107      42.345  18.605  16.814  1.00 51.17           O  
ATOM   1965  CB  LEU   107      42.946  21.482  17.904  1.00 48.93           C  
ATOM   1966  CG  LEU   107      43.479  22.915  17.843  1.00 48.72           C  
ATOM   1967  CD1 LEU   107      42.485  23.893  18.457  1.00 47.04           C  
ATOM   1968  CD2 LEU   107      44.823  23.024  18.539  1.00 50.50           C  
ATOM   1969  N   THR   108      43.654  18.293  18.630  1.00 49.87           N  
ATOM   1970  CA  THR   108      43.136  16.954  18.974  1.00 48.10           C  
ATOM   1971  C   THR   108      41.608  16.879  18.933  1.00 48.72           C  
ATOM   1972  O   THR   108      41.034  16.018  18.261  1.00 48.58           O  
ATOM   1973  CB  THR   108      43.602  16.500  20.395  1.00 48.19           C  
ATOM   1974  OG1 THR   108      43.218  17.476  21.378  1.00 40.35           O  
ATOM   1975  CG2 THR   108      45.114  16.291  20.439  1.00 45.16           C  
ATOM   1976  N   LYS   114      40.560  20.285  13.549  1.00 48.83           N  
ATOM   1977  CA  LYS   114      41.339  21.284  12.829  1.00 47.35           C  
ATOM   1978  C   LYS   114      40.493  22.541  12.660  1.00 45.69           C  
ATOM   1979  O   LYS   114      39.291  22.459  12.389  1.00 45.34           O  
ATOM   1980  CB  LYS   114      41.802  20.739  11.475  1.00 46.66           C  
ATOM   1981  N   VAL   115      41.122  23.699  12.841  1.00 42.98           N  
ATOM   1982  CA  VAL   115      40.424  24.983  12.796  1.00 40.69           C  
ATOM   1983  C   VAL   115      41.403  26.064  12.356  1.00 37.96           C  
ATOM   1984  O   VAL   115      42.580  26.010  12.700  1.00 37.13           O  
ATOM   1985  CB  VAL   115      39.827  25.330  14.188  1.00 41.29           C  
ATOM   1986  CG1 VAL   115      40.938  25.423  15.230  1.00 41.11           C  
ATOM   1987  CG2 VAL   115      39.014  26.625  14.141  1.00 41.31           C  
ATOM   1988  N   THR   116      40.924  27.018  11.565  1.00 35.83           N  
ATOM   1989  CA  THR   116      41.747  28.147  11.129  1.00 34.25           C  
ATOM   1990  C   THR   116      41.888  29.156  12.249  1.00 34.16           C  
ATOM   1991  O   THR   116      40.982  29.294  13.064  1.00 34.64           O  
ATOM   1992  CB  THR   116      41.095  28.887   9.978  1.00 34.35           C  
ATOM   1993  OG1 THR   116      39.768  29.268  10.376  1.00 33.55           O  
ATOM   1994  CG2 THR   116      41.045  28.007   8.736  1.00 26.14           C  
ATOM   1995  N   GLY   117      43.000  29.883  12.275  1.00 33.53           N  
ATOM   1996  CA  GLY   117      43.191  30.940  13.265  1.00 32.87           C  
ATOM   1997  C   GLY   117      41.993  31.880  13.316  1.00 32.75           C  
ATOM   1998  O   GLY   117      41.549  32.261  14.400  1.00 32.20           O  
ATOM   1999  N   ARG   118      41.468  32.232  12.139  1.00 33.22           N  
ATOM   2000  CA  ARG   118      40.315  33.129  12.006  1.00 34.94           C  
ATOM   2001  C   ARG   118      39.071  32.565  12.685  1.00 33.27           C  
ATOM   2002  O   ARG   118      38.391  33.268  13.432  1.00 34.97           O  
ATOM   2003  CB  ARG   118      40.008  33.398  10.528  1.00 34.63           C  
ATOM   2004  CG  ARG   118      39.075  34.578  10.287  1.00 38.04           C  
ATOM   2005  CD  ARG   118      38.912  34.917   8.796  1.00 41.22           C  
ATOM   2006  NE  ARG   118      40.200  35.077   8.112  1.00 48.85           N  
ATOM   2007  CZ  ARG   118      41.000  36.138   8.220  1.00 48.59           C  
ATOM   2008  NH1 ARG   118      40.677  37.176   8.988  1.00 49.41           N  
ATOM   2009  NH2 ARG   118      42.145  36.158   7.557  1.00 48.99           N  
ATOM   2010  N   ALA   119      38.770  31.298  12.427  1.00 30.92           N  
ATOM   2011  CA  ALA   119      37.577  30.682  12.994  1.00 29.20           C  
ATOM   2012  C   ALA   119      37.694  30.522  14.527  1.00 28.24           C  
ATOM   2013  O   ALA   119      36.694  30.620  15.245  1.00 27.02           O  
ATOM   2014  CB  ALA   119      37.300  29.361  12.328  1.00 29.59           C  
ATOM   2015  N   LEU   120      38.907  30.297  15.027  1.00 26.93           N  
ATOM   2016  CA  LEU   120      39.125  30.231  16.467  1.00 28.00           C  
ATOM   2017  C   LEU   120      39.018  31.640  17.102  1.00 27.86           C  
ATOM   2018  O   LEU   120      38.633  31.771  18.257  1.00 27.73           O  
ATOM   2019  CB  LEU   120      40.488  29.602  16.779  1.00 29.16           C  
ATOM   2020  CG  LEU   120      40.699  29.065  18.198  1.00 29.75           C  
ATOM   2021  CD1 LEU   120      39.857  27.808  18.433  1.00 35.18           C  
ATOM   2022  CD2 LEU   120      42.165  28.759  18.433  1.00 29.74           C  
ATOM   2023  N   LEU   121      39.359  32.683  16.346  1.00 28.09           N  
ATOM   2024  CA  LEU   121      39.228  34.057  16.832  1.00 27.44           C  
ATOM   2025  C   LEU   121      37.750  34.434  17.007  1.00 28.11           C  
ATOM   2026  O   LEU   121      37.378  35.044  18.004  1.00 28.73           O  
ATOM   2027  CB  LEU   121      39.920  35.041  15.889  1.00 26.16           C  
ATOM   2028  CG  LEU   121      39.829  36.523  16.266  1.00 27.90           C  
ATOM   2029  CD1 LEU   121      40.567  36.780  17.561  1.00 23.80           C  
ATOM   2030  CD2 LEU   121      40.358  37.411  15.134  1.00 27.70           C  
ATOM   2031  N   GLN   122      36.917  34.057  16.039  1.00 28.54           N  
ATOM   2032  CA  GLN   122      35.481  34.314  16.107  1.00 30.48           C  
ATOM   2033  C   GLN   122      34.866  33.560  17.293  1.00 30.29           C  
ATOM   2034  O   GLN   122      33.977  34.061  17.983  1.00 30.33           O  
ATOM   2035  CB  GLN   122      34.788  33.907  14.790  1.00 30.73           C  
ATOM   2036  CG  GLN   122      33.269  33.730  14.930  1.00 34.32           C  
ATOM   2037  CD  GLN   122      32.527  33.691  13.616  1.00 33.25           C  
ATOM   2038  OE1 GLN   122      32.635  34.605  12.807  1.00 42.39           O  
ATOM   2039  NE2 GLN   122      31.721  32.648  13.419  1.00 35.24           N  
ATOM   2040  N   LEU   123      35.343  32.341  17.495  1.00 29.79           N  
ATOM   2041  CA  LEU   123      34.918  31.500  18.594  1.00 30.76           C  
ATOM   2042  C   LEU   123      35.297  32.158  19.938  1.00 30.05           C  
ATOM   2043  O   LEU   123      34.511  32.159  20.881  1.00 28.56           O  
ATOM   2044  CB  LEU   123      35.581  30.124  18.426  1.00 32.64           C  
ATOM   2045  CG  LEU   123      35.088  28.918  19.208  1.00 36.41           C  
ATOM   2046  CD1 LEU   123      35.493  27.647  18.473  1.00 37.74           C  
ATOM   2047  CD2 LEU   123      35.638  28.950  20.633  1.00 37.75           C  
ATOM   2048  N   ALA   124      36.509  32.710  20.008  1.00 29.00           N  
ATOM   2049  CA  ALA   124      36.979  33.433  21.183  1.00 27.92           C  
ATOM   2050  C   ALA   124      36.140  34.689  21.458  1.00 27.85           C  
ATOM   2051  O   ALA   124      35.857  35.030  22.619  1.00 27.75           O  
ATOM   2052  CB  ALA   124      38.437  33.815  20.996  1.00 27.52           C  
ATOM   2053  N   MET   125      35.737  35.368  20.384  1.00 26.51           N  
ATOM   2054  CA  MET   125      34.935  36.579  20.487  1.00 24.50           C  
ATOM   2055  C   MET   125      33.523  36.293  20.949  1.00 23.15           C  
ATOM   2056  O   MET   125      32.950  37.063  21.705  1.00 23.24           O  
ATOM   2057  CB  MET   125      34.872  37.308  19.138  1.00 23.98           C  
ATOM   2058  CG  MET   125      36.151  38.017  18.740  1.00 24.55           C  
ATOM   2059  SD  MET   125      36.568  39.523  19.855  0.75 19.69          SE  
ATOM   2060  CE  MET   125      34.822  40.421  19.829  1.00 27.99           C  
ATOM   2061  N   GLU   126      32.949  35.198  20.472  1.00 22.92           N  
ATOM   2062  CA  GLU   126      31.589  34.833  20.863  1.00 22.67           C  
ATOM   2063  C   GLU   126      31.542  34.327  22.296  1.00 23.28           C  
ATOM   2064  O   GLU   126      30.535  34.500  22.995  1.00 24.32           O  
ATOM   2065  CB  GLU   126      31.017  33.797  19.905  1.00 22.12           C  
ATOM   2066  CG  GLU   126      30.912  34.295  18.466  1.00 19.97           C  
ATOM   2067  CD  GLU   126      30.242  33.303  17.552  1.00 21.02           C  
ATOM   2068  OE1 GLU   126      29.901  32.187  18.004  1.00 25.67           O  
ATOM   2069  OE2 GLU   126      30.029  33.658  16.382  1.00 23.17           O  
ATOM   2070  N   HIS   127      32.637  33.714  22.727  1.00 24.65           N  
ATOM   2071  CA  HIS   127      32.783  33.226  24.099  1.00 25.24           C  
ATOM   2072  C   HIS   127      32.844  34.408  25.069  1.00 24.32           C  
ATOM   2073  O   HIS   127      32.184  34.415  26.118  1.00 24.41           O  
ATOM   2074  CB  HIS   127      34.050  32.389  24.183  1.00 26.17           C  
ATOM   2075  CG  HIS   127      34.235  31.687  25.484  1.00 31.32           C  
ATOM   2076  ND1 HIS   127      33.450  30.626  25.876  1.00 38.61           N  
ATOM   2077  CD2 HIS   127      35.141  31.872  26.470  1.00 36.97           C  
ATOM   2078  CE1 HIS   127      33.861  30.195  27.054  1.00 39.40           C  
ATOM   2079  NE2 HIS   127      34.881  30.938  27.438  1.00 37.60           N  
ATOM   2080  N   GLU   128      33.625  35.417  24.699  1.00 23.98           N  
ATOM   2081  CA  GLU   128      33.678  36.673  25.445  1.00 22.90           C  
ATOM   2082  C   GLU   128      32.285  37.287  25.550  1.00 21.15           C  
ATOM   2083  O   GLU   128      31.845  37.655  26.629  1.00 19.73           O  
ATOM   2084  CB  GLU   128      34.610  37.659  24.747  1.00 22.49           C  
ATOM   2085  CG  GLU   128      34.708  39.049  25.408  1.00 27.83           C  
ATOM   2086  CD  GLU   128      35.846  39.181  26.415  1.00 28.43           C  
ATOM   2087  OE1 GLU   128      36.726  38.301  26.447  1.00 27.93           O  
ATOM   2088  OE2 GLU   128      35.860  40.190  27.156  1.00 30.92           O  
ATOM   2089  N   ILE   129      31.613  37.390  24.410  1.00 20.76           N  
ATOM   2090  CA  ILE   129      30.320  38.058  24.320  1.00 20.58           C  
ATOM   2091  C   ILE   129      29.281  37.312  25.140  1.00 21.24           C  
ATOM   2092  O   ILE   129      28.513  37.931  25.863  1.00 23.67           O  
ATOM   2093  CB  ILE   129      29.858  38.233  22.840  1.00 19.95           C  
ATOM   2094  CG1 ILE   129      30.767  39.241  22.133  1.00 20.52           C  
ATOM   2095  CG2 ILE   129      28.411  38.718  22.786  1.00 19.35           C  
ATOM   2096  CD1 ILE   129      30.746  39.177  20.613  1.00 19.09           C  
ATOM   2097  N   HIS   130      29.288  35.985  25.048  1.00 21.33           N  
ATOM   2098  CA  HIS   130      28.430  35.139  25.878  1.00 19.82           C  
ATOM   2099  C   HIS   130      28.572  35.420  27.373  1.00 20.82           C  
ATOM   2100  O   HIS   130      27.583  35.721  28.048  1.00 20.66           O  
ATOM   2101  CB  HIS   130      28.727  33.658  25.615  1.00 18.93           C  
ATOM   2102  CG  HIS   130      28.027  32.732  26.553  1.00 15.45           C  
ATOM   2103  ND1 HIS   130      26.658  32.550  26.535  1.00 14.36           N  
ATOM   2104  CD2 HIS   130      28.503  31.936  27.536  1.00 13.49           C  
ATOM   2105  CE1 HIS   130      26.323  31.696  27.484  1.00 15.06           C  
ATOM   2106  NE2 HIS   130      27.423  31.317  28.111  1.00 16.03           N  
ATOM   2107  N   HIS   131      29.799  35.303  27.882  1.00 21.96           N  
ATOM   2108  CA  HIS   131      30.080  35.424  29.318  1.00 21.31           C  
ATOM   2109  C   HIS   131      29.957  36.868  29.852  1.00 22.10           C  
ATOM   2110  O   HIS   131      29.656  37.088  31.034  1.00 20.92           O  
ATOM   2111  CB  HIS   131      31.461  34.839  29.643  1.00 21.24           C  
ATOM   2112  CG  HIS   131      31.522  33.343  29.551  1.00 22.99           C  
ATOM   2113  ND1 HIS   131      30.750  32.516  30.340  1.00 25.40           N  
ATOM   2114  CD2 HIS   131      32.274  32.525  28.776  1.00 23.84           C  
ATOM   2115  CE1 HIS   131      31.012  31.255  30.044  1.00 25.83           C  
ATOM   2116  NE2 HIS   131      31.936  31.233  29.101  1.00 26.08           N  
ATOM   2117  N   LYS   132      30.195  37.854  28.993  1.00 23.34           N  
ATOM   2118  CA  LYS   132      29.890  39.237  29.349  1.00 23.59           C  
ATOM   2119  C   LYS   132      28.368  39.353  29.502  1.00 24.59           C  
ATOM   2120  O   LYS   132      27.883  40.077  30.374  1.00 25.72           O  
ATOM   2121  CB  LYS   132      30.450  40.221  28.303  1.00 24.16           C  
ATOM   2122  CG  LYS   132      29.937  41.660  28.425  1.00 22.60           C  
ATOM   2123  CD  LYS   132      30.819  42.673  27.685  1.00 23.82           C  
ATOM   2124  CE  LYS   132      31.003  42.367  26.192  1.00 26.25           C  
ATOM   2125  NZ  LYS   132      29.783  42.581  25.373  1.00 19.16           N  
ATOM   2126  N   GLY   133      27.625  38.625  28.666  1.00 24.94           N  
ATOM   2127  CA  GLY   133      26.167  38.535  28.785  1.00 23.57           C  
ATOM   2128  C   GLY   133      25.738  37.992  30.140  1.00 24.46           C  
ATOM   2129  O   GLY   133      24.797  38.507  30.745  1.00 25.42           O  
ATOM   2130  N   ASN   134      26.421  36.946  30.616  1.00 24.53           N  
ATOM   2131  CA  ASN   134      26.212  36.447  31.981  1.00 23.49           C  
ATOM   2132  C   ASN   134      26.525  37.544  32.981  1.00 23.55           C  
ATOM   2133  O   ASN   134      25.752  37.789  33.899  1.00 23.87           O  
ATOM   2134  CB  ASN   134      27.137  35.279  32.349  1.00 24.25           C  
ATOM   2135  CG  ASN   134      27.000  34.066  31.443  1.00 22.64           C  
ATOM   2136  OD1 ASN   134      27.917  33.259  31.385  1.00 27.65           O  
ATOM   2137  ND2 ASN   134      25.884  33.927  30.755  1.00 22.69           N  
ATOM   2138  N   LEU   135      27.674  38.188  32.797  1.00 23.93           N  
ATOM   2139  CA  LEU   135      28.207  39.140  33.769  1.00 24.06           C  
ATOM   2140  C   LEU   135      27.286  40.331  34.014  1.00 24.23           C  
ATOM   2141  O   LEU   135      27.195  40.795  35.130  1.00 25.52           O  
ATOM   2142  CB  LEU   135      29.599  39.605  33.340  1.00 23.83           C  
ATOM   2143  CG  LEU   135      30.452  40.451  34.291  1.00 24.29           C  
ATOM   2144  CD1 LEU   135      30.640  39.807  35.676  1.00 20.22           C  
ATOM   2145  CD2 LEU   135      31.803  40.685  33.627  1.00 24.00           C  
ATOM   2146  N   PHE   136      26.617  40.814  32.967  1.00 24.58           N  
ATOM   2147  CA  PHE   136      25.647  41.896  33.073  1.00 24.76           C  
ATOM   2148  C   PHE   136      24.547  41.609  34.115  1.00 26.40           C  
ATOM   2149  O   PHE   136      24.153  42.502  34.871  1.00 24.96           O  
ATOM   2150  CB  PHE   136      24.994  42.160  31.714  1.00 25.02           C  
ATOM   2151  CG  PHE   136      25.603  43.297  30.961  1.00 25.69           C  
ATOM   2152  CD1 PHE   136      25.197  44.595  31.219  1.00 27.75           C  
ATOM   2153  CD2 PHE   136      26.590  43.077  29.998  1.00 23.95           C  
ATOM   2154  CE1 PHE   136      25.751  45.656  30.529  1.00 27.50           C  
ATOM   2155  CE2 PHE   136      27.150  44.126  29.303  1.00 22.33           C  
ATOM   2156  CZ  PHE   136      26.732  45.426  29.568  1.00 28.13           C  
ATOM   2157  N   VAL   137      24.049  40.374  34.143  1.00 26.43           N  
ATOM   2158  CA  VAL   137      23.008  40.004  35.098  1.00 25.49           C  
ATOM   2159  C   VAL   137      23.599  39.897  36.506  1.00 26.38           C  
ATOM   2160  O   VAL   137      22.977  40.346  37.462  1.00 27.33           O  
ATOM   2161  CB  VAL   137      22.254  38.714  34.667  1.00 26.90           C  
ATOM   2162  CG1 VAL   137      21.086  38.397  35.632  1.00 22.98           C  
ATOM   2163  CG2 VAL   137      21.726  38.861  33.238  1.00 21.37           C  
ATOM   2164  N   TYR   138      24.814  39.352  36.631  1.00 27.22           N  
ATOM   2165  CA  TYR   138      25.534  39.329  37.921  1.00 27.61           C  
ATOM   2166  C   TYR   138      25.601  40.731  38.527  1.00 28.62           C  
ATOM   2167  O   TYR   138      25.164  40.955  39.664  1.00 30.89           O  
ATOM   2168  CB  TYR   138      26.980  38.813  37.775  1.00 27.23           C  
ATOM   2169  CG  TYR   138      27.175  37.304  37.716  1.00 27.29           C  
ATOM   2170  CD1 TYR   138      26.675  36.558  36.664  1.00 26.10           C  
ATOM   2171  CD2 TYR   138      27.903  36.634  38.695  1.00 29.05           C  
ATOM   2172  CE1 TYR   138      26.872  35.177  36.590  1.00 24.62           C  
ATOM   2173  CE2 TYR   138      28.092  35.252  38.642  1.00 26.24           C  
ATOM   2174  CZ  TYR   138      27.577  34.534  37.582  1.00 26.62           C  
ATOM   2175  OH  TYR   138      27.771  33.174  37.491  1.00 27.21           O  
ATOM   2176  N   VAL   139      26.146  41.666  37.754  1.00 27.99           N  
ATOM   2177  CA  VAL   139      26.404  43.039  38.215  1.00 27.23           C  
ATOM   2178  C   VAL   139      25.129  43.810  38.552  1.00 27.92           C  
ATOM   2179  O   VAL   139      25.086  44.595  39.514  1.00 26.74           O  
ATOM   2180  CB  VAL   139      27.222  43.803  37.156  1.00 28.07           C  
ATOM   2181  CG1 VAL   139      27.307  45.289  37.484  1.00 28.06           C  
ATOM   2182  CG2 VAL   139      28.624  43.174  37.012  1.00 26.48           C  
ATOM   2183  N   ARG   140      24.099  43.592  37.744  1.00 29.05           N  
ATOM   2184  CA  ARG   140      22.773  44.168  37.964  1.00 31.02           C  
ATOM   2185  C   ARG   140      22.193  43.697  39.308  1.00 30.81           C  
ATOM   2186  O   ARG   140      21.591  44.480  40.046  1.00 30.77           O  
ATOM   2187  CB  ARG   140      21.863  43.745  36.804  1.00 32.60           C  
ATOM   2188  CG  ARG   140      20.404  44.195  36.878  1.00 40.15           C  
ATOM   2189  CD  ARG   140      20.154  45.498  36.168  1.00 42.74           C  
ATOM   2190  NE  ARG   140      20.623  45.454  34.785  1.00 44.57           N  
ATOM   2191  CZ  ARG   140      20.631  46.499  33.961  1.00 43.68           C  
ATOM   2192  NH1 ARG   140      20.180  47.690  34.364  1.00 42.68           N  
ATOM   2193  NH2 ARG   140      21.097  46.350  32.724  1.00 47.01           N  
ATOM   2194  N   GLU   141      22.378  42.412  39.606  1.00 31.43           N  
ATOM   2195  CA  GLU   141      21.960  41.809  40.885  1.00 30.94           C  
ATOM   2196  C   GLU   141      22.784  42.249  42.108  1.00 31.18           C  
ATOM   2197  O   GLU   141      22.380  42.019  43.250  1.00 30.01           O  
ATOM   2198  CB  GLU   141      21.989  40.281  40.789  1.00 31.38           C  
ATOM   2199  CG  GLU   141      20.789  39.711  40.078  1.00 29.43           C  
ATOM   2200  CD  GLU   141      20.871  38.218  39.838  1.00 29.00           C  
ATOM   2201  OE1 GLU   141      21.346  37.465  40.720  1.00 24.08           O  
ATOM   2202  OE2 GLU   141      20.434  37.798  38.751  1.00 24.21           O  
ATOM   2203  N   MET   142      23.935  42.872  41.866  1.00 31.32           N  
ATOM   2204  CA  MET   142      24.788  43.379  42.938  1.00 30.72           C  
ATOM   2205  C   MET   142      24.459  44.808  43.371  1.00 32.76           C  
ATOM   2206  O   MET   142      25.194  45.384  44.180  1.00 33.35           O  
ATOM   2207  CB  MET   142      26.247  43.366  42.498  1.00 30.80           C  
ATOM   2208  CG  MET   142      26.791  42.021  42.195  1.00 29.92           C  
ATOM   2209  SD  MET   142      28.615  42.104  41.579  0.75 23.20          SE  
ATOM   2210  CE  MET   142      28.655  43.665  40.756  1.00 18.45           C  
ATOM   2211  N   GLY   143      23.394  45.393  42.822  1.00 33.02           N  
ATOM   2212  CA  GLY   143      22.959  46.714  43.243  1.00 33.47           C  
ATOM   2213  C   GLY   143      23.214  47.819  42.232  1.00 34.81           C  
ATOM   2214  O   GLY   143      22.746  48.940  42.423  1.00 35.09           O  
ATOM   2215  N   HIS   144      23.943  47.516  41.159  1.00 35.68           N  
ATOM   2216  CA  HIS   144      24.277  48.516  40.138  1.00 36.43           C  
ATOM   2217  C   HIS   144      23.212  48.593  39.051  1.00 37.25           C  
ATOM   2218  O   HIS   144      22.838  47.584  38.459  1.00 36.10           O  
ATOM   2219  CB  HIS   144      25.643  48.218  39.538  1.00 36.53           C  
ATOM   2220  CG  HIS   144      26.725  48.147  40.564  1.00 36.63           C  
ATOM   2221  ND1 HIS   144      27.392  49.264  41.015  1.00 34.51           N  
ATOM   2222  CD2 HIS   144      27.217  47.101  41.267  1.00 41.34           C  
ATOM   2223  CE1 HIS   144      28.270  48.906  41.934  1.00 40.77           C  
ATOM   2224  NE2 HIS   144      28.181  47.599  42.111  1.00 42.86           N  
ATOM   2225  N   THR   145      22.720  49.802  38.808  1.00 39.71           N  
ATOM   2226  CA  THR   145      21.653  50.030  37.835  1.00 41.21           C  
ATOM   2227  C   THR   145      22.096  50.853  36.624  1.00 43.96           C  
ATOM   2228  O   THR   145      21.370  50.917  35.626  1.00 45.11           O  
ATOM   2229  CB  THR   145      20.451  50.766  38.477  1.00 40.95           C  
ATOM   2230  OG1 THR   145      20.784  52.148  38.677  1.00 36.83           O  
ATOM   2231  CG2 THR   145      20.050  50.122  39.813  1.00 38.96           C  
ATOM   2232  N   GLU   146      23.260  51.496  36.705  1.00 45.65           N  
ATOM   2233  CA  GLU   146      23.726  52.328  35.604  1.00 47.58           C  
ATOM   2234  C   GLU   146      24.886  51.616  34.924  1.00 46.33           C  
ATOM   2235  O   GLU   146      26.059  51.845  35.238  1.00 48.08           O  
ATOM   2236  CB  GLU   146      24.105  53.725  36.101  1.00 48.88           C  
ATOM   2237  CG  GLU   146      23.685  54.842  35.148  1.00 53.87           C  
ATOM   2238  CD  GLU   146      22.186  54.817  34.818  1.00 59.74           C  
ATOM   2239  OE1 GLU   146      21.360  54.933  35.753  1.00 62.56           O  
ATOM   2240  OE2 GLU   146      21.837  54.686  33.624  1.00 60.00           O  
ATOM   2241  N   LEU   147      24.535  50.731  33.998  1.00 43.13           N  
ATOM   2242  CA  LEU   147      25.511  49.860  33.355  1.00 40.71           C  
ATOM   2243  C   LEU   147      25.797  50.305  31.923  1.00 38.85           C  
ATOM   2244  O   LEU   147      24.917  50.848  31.242  1.00 37.87           O  
ATOM   2245  CB  LEU   147      25.016  48.411  33.365  1.00 40.10           C  
ATOM   2246  CG  LEU   147      24.740  47.799  34.743  1.00 39.60           C  
ATOM   2247  CD1 LEU   147      24.125  46.436  34.588  1.00 38.09           C  
ATOM   2248  CD2 LEU   147      26.011  47.720  35.575  1.00 37.18           C  
ATOM   2249  N   PRO   148      27.036  50.070  31.457  1.00 36.83           N  
ATOM   2250  CA  PRO   148      27.359  50.459  30.092  1.00 35.09           C  
ATOM   2251  C   PRO   148      26.522  49.694  29.079  1.00 32.85           C  
ATOM   2252  O   PRO   148      25.936  48.655  29.407  1.00 32.33           O  
ATOM   2253  CB  PRO   148      28.841  50.080  29.953  1.00 34.78           C  
ATOM   2254  CG  PRO   148      29.096  49.071  31.022  1.00 36.57           C  
ATOM   2255  CD  PRO   148      28.178  49.432  32.143  1.00 37.27           C  
ATOM   2256  N   PHE   149      26.440  50.234  27.871  1.00 30.90           N  
ATOM   2257  CA  PHE   149      25.923  49.487  26.742  1.00 29.22           C  
ATOM   2258  C   PHE   149      26.911  48.343  26.533  1.00 26.36           C  
ATOM   2259  O   PHE   149      28.108  48.498  26.802  1.00 26.92           O  
ATOM   2260  CB  PHE   149      25.825  50.378  25.500  1.00 29.54           C  
ATOM   2261  CG  PHE   149      25.075  49.745  24.365  1.00 31.48           C  
ATOM   2262  CD1 PHE   149      23.731  49.412  24.508  1.00 32.96           C  
ATOM   2263  CD2 PHE   149      25.708  49.468  23.162  1.00 31.91           C  
ATOM   2264  CE1 PHE   149      23.040  48.813  23.475  1.00 33.85           C  
ATOM   2265  CE2 PHE   149      25.017  48.876  22.123  1.00 34.43           C  
ATOM   2266  CZ  PHE   149      23.683  48.546  22.282  1.00 33.21           C  
ATOM   2267  N   TYR   150      26.428  47.209  26.045  1.00 25.14           N  
ATOM   2268  CA  TYR   150      27.236  45.986  26.041  1.00 26.48           C  
ATOM   2269  C   TYR   150      28.453  45.994  25.127  1.00 25.90           C  
ATOM   2270  O   TYR   150      29.319  45.125  25.246  1.00 26.81           O  
ATOM   2271  CB  TYR   150      26.372  44.766  25.751  1.00 27.38           C  
ATOM   2272  CG  TYR   150      25.858  44.654  24.346  1.00 27.41           C  
ATOM   2273  CD1 TYR   150      26.599  44.014  23.357  1.00 26.55           C  
ATOM   2274  CD2 TYR   150      24.599  45.154  24.011  1.00 33.30           C  
ATOM   2275  CE1 TYR   150      26.103  43.901  22.050  1.00 32.66           C  
ATOM   2276  CE2 TYR   150      24.090  45.035  22.725  1.00 34.22           C  
ATOM   2277  CZ  TYR   150      24.845  44.420  21.751  1.00 33.26           C  
ATOM   2278  OH  TYR   150      24.321  44.325  20.489  1.00 36.66           O  
ATOM   2279  N   GLN   151      28.514  46.963  24.224  1.00 25.97           N  
ATOM   2280  CA  GLN   151      29.643  47.114  23.323  1.00 28.02           C  
ATOM   2281  C   GLN   151      29.928  48.601  23.100  1.00 28.27           C  
ATOM   2282  O   GLN   151      29.011  49.379  22.893  1.00 26.65           O  
ATOM   2283  CB  GLN   151      29.326  46.447  21.977  1.00 28.59           C  
ATOM   2284  CG  GLN   151      30.572  46.158  21.157  1.00 31.58           C  
ATOM   2285  CD  GLN   151      30.308  45.843  19.693  1.00 29.46           C  
ATOM   2286  OE1 GLN   151      29.163  45.768  19.260  1.00 34.99           O  
ATOM   2287  NE2 GLN   151      31.381  45.675  18.920  1.00 28.17           N  
ATOM   2288  N   GLN   152      31.196  48.988  23.151  1.00 30.83           N  
ATOM   2289  CA  GLN   152      31.596  50.336  22.767  1.00 33.70           C  
ATOM   2290  C   GLN   152      31.634  50.422  21.243  1.00 36.95           C  
ATOM   2291  O   GLN   152      31.835  49.412  20.563  1.00 37.86           O  
ATOM   2292  CB  GLN   152      32.961  50.684  23.349  1.00 32.47           C  
ATOM   2293  CG  GLN   152      32.965  50.794  24.856  1.00 33.78           C  
ATOM   2294  CD  GLN   152      34.315  51.214  25.424  1.00 35.09           C  
ATOM   2295  OE1 GLN   152      35.319  51.317  24.704  1.00 32.29           O  
ATOM   2296  NE2 GLN   152      34.342  51.450  26.731  1.00 28.38           N  
ATOM   2297  N   ARG   153      31.444  51.622  20.707  1.00 38.84           N  
ATOM   2298  CA  ARG   153      31.447  51.820  19.252  1.00 40.64           C  
ATOM   2299  C   ARG   153      32.858  51.664  18.680  1.00 42.01           C  
ATOM   2300  O   ARG   153      33.351  50.543  18.488  1.00 44.29           O  
ATOM   2301  CB  ARG   153      30.889  53.206  18.903  1.00 39.42           C  
END
