
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  180 ( 1415),  selected  180 , name 2oqm_A
# Molecule2: number of CA atoms  144 ( 1145),  selected  144 , name T0481.pdb
# PARAMETERS: 2oqm_A.T0481.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -8_A      -       -           -
LGA    H    -7_A      -       -           -
LGA    E    -6_A      -       -           -
LGA    N    -5_A      -       -           -
LGA    L    -4_A      -       -           -
LGA    Y    -3_A      -       -           -
LGA    F    -2_A      -       -           -
LGA    Q    -1_A      -       -           -
LGA    G     0_A      N       5           #
LGA    X     1_A      -       -           -
LGA    L     2_A      -       -           -
LGA    Y     3_A      Q       6           #
LGA    D     4_A      I       7          1.018
LGA    L     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    V     7_A      V       8          3.318
LGA    V     8_A      S       9          3.066
LGA    Q     9_A      H      10          2.518
LGA    F    10_A      F      11          2.426
LGA    S    11_A      L      12          3.005
LGA    K    12_A      S      13          3.561
LGA    X    13_A      H      14          2.453
LGA    L    14_A      R      15          2.478
LGA    K    15_A      N      16          2.287
LGA    N    16_A      V      17          1.845
LGA    L    17_A      T      18          2.045
LGA    N    18_A      N      19          2.445
LGA    A    19_A      E      20          1.891
LGA    I    20_A      L      21          2.061
LGA    F    21_A      A      22          3.666
LGA    D    22_A      E      23          4.024
LGA    K    23_A      K      24          4.180
LGA    A    24_A      I      25          4.530
LGA    E    25_A      -       -           -
LGA    A    26_A      -       -           -
LGA    F    27_A      -       -           -
LGA    A    28_A      -       -           -
LGA    E    29_A      -       -           -
LGA    L    30_A      -       -           -
LGA    K    31_A      -       -           -
LGA    K    32_A      -       -           -
LGA    V    33_A      -       -           -
LGA    D    34_A      -       -           -
LGA    X    35_A      S      26          2.485
LGA    D    36_A      K      27          3.401
LGA    V    37_A      D      28          3.493
LGA    L    38_A      H      29          1.865
LGA    L    39_A      Y      30          1.509
LGA    N    40_A      S      31          1.003
LGA    S    41_A      Y      32          1.149
LGA    R    42_A      K      33          1.818
LGA    L    43_A      P      34          2.571
LGA    A    44_A      A      35          2.369
LGA    A    45_A      E      36          1.306
LGA    D    46_A      T      37          1.602
LGA    Q    47_A      S      38          2.002
LGA    F    48_A      M      39          1.111
LGA    N    49_A      S      40          0.937
LGA    L    50_A      A      41          0.756
LGA    I    51_A      E      42          0.187
LGA    R    52_A      E      43          0.842
LGA    Q    53_A      L      44          0.935
LGA    V    54_A      V      45          0.797
LGA    Q    55_A      K      46          0.559
LGA    I    56_A      H      47          0.853
LGA    A    57_A      I      48          0.722
LGA    C    58_A      L      49          0.608
LGA    D    59_A      T      50          1.290
LGA    T    60_A      S      51          2.211
LGA    A    61_A      F      52          2.072
LGA    K    62_A      H      53          1.095
LGA    V    63_A      L      54          1.264
LGA    G    64_A      F      55          1.576
LGA    V    65_A      A      56          1.201
LGA    A    66_A      N      57          0.993
LGA    R    67_A      V      58          1.073
LGA    L    68_A      I      59          1.114
LGA    T    69_A      K      60          1.478
LGA    G    70_A      E      61          1.124
LGA    Q    71_A      G      62           #
LGA    L    72_A      N      63           #
LGA    -       -      A      64           -
LGA    -       -      S      65           -
LGA    E    73_A      P      66          4.610
LGA    T    74_A      F      67           -
LGA    A    75_A      Q      68           -
LGA    P    76_A      N      69           #
LGA    -       -      K      70           -
LGA    K    77_A      Q      71          2.586
LGA    H    78_A      E      72          4.046
LGA    D    79_A      E      73          3.619
LGA    D    80_A      T      74           #
LGA    S    81_A      E      75           #
LGA    E    82_A      T      76          2.220
LGA    T    83_A      -       -           -
LGA    T    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    A    86_A      -       -           -
LGA    E    87_A      D      77          1.086
LGA    L    88_A      L      78          0.927
LGA    R    89_A      N      79          1.003
LGA    Q    90_A      V      80          1.053
LGA    R    91_A      L      81          0.938
LGA    I    92_A      A      82          1.255
LGA    A    93_A      K      83          1.301
LGA    S    94_A      T      84          1.121
LGA    V    95_A      Y      85          1.440
LGA    L    96_A      T      86          2.154
LGA    T    97_A      E      87          1.931
LGA    Y    98_A      K      88          1.292
LGA    L    99_A      T      89          2.835
LGA    E   100_A      V      90          3.688
LGA    G   101_A      A      91          2.376
LGA    F   102_A      I      92          3.607
LGA    -       -      L      93           -
LGA    S   103_A      E      94          2.791
LGA    E   104_A      Q      95          4.774
LGA    A   105_A      -       -           -
LGA    D   106_A      L      96          2.451
LGA    F   107_A      T      97          2.727
LGA    A   108_A      E      98          2.992
LGA    N   109_A      E      99          2.478
LGA    A   110_A      Q     100          2.764
LGA    -       -      L     101           -
LGA    A   111_A      D     102          2.587
LGA    T   112_A      R     103          2.064
LGA    I   113_A      E     104          2.871
LGA    Q   114_A      I     105          1.118
LGA    I   115_A      D     106          4.803
LGA    S   116_A      L     107          1.938
LGA    Q   117_A      -       -           -
LGA    P   118_A      -       -           -
LGA    R   119_A      -       -           -
LGA    W   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    G   122_A      -       -           -
LGA    K   123_A      T     108          3.803
LGA    Y   124_A      K     114          2.519
LGA    L   125_A      V     115          2.219
LGA    T   126_A      T     116          2.298
LGA    G   127_A      G     117          2.118
LGA    Y   128_A      R     118          2.409
LGA    E   129_A      A     119          2.377
LGA    F   130_A      L     120          1.997
LGA    A   131_A      L     121          2.318
LGA    I   132_A      Q     122          2.485
LGA    E   133_A      L     123          3.676
LGA    H   134_A      -       -           -
LGA    A   135_A      A     124          1.390
LGA    I   136_A      M     125          1.826
LGA    P   137_A      E     126          1.798
LGA    N   138_A      H     127          1.095
LGA    L   139_A      E     128          0.995
LGA    Y   140_A      I     129          1.178
LGA    F   141_A      H     130          1.661
LGA    H   142_A      H     131          1.645
LGA    I   143_A      K     132          1.685
LGA    T   144_A      G     133          1.776
LGA    T   145_A      N     134          1.263
LGA    A   146_A      L     135          1.742
LGA    Y   147_A      F     136          1.839
LGA    G   148_A      V     137          1.268
LGA    I   149_A      Y     138          0.758
LGA    L   150_A      V     139          1.149
LGA    R   151_A      R     140          0.883
LGA    H   152_A      E     141          2.118
LGA    N   153_A      M     142          2.775
LGA    G   154_A      G     143          2.500
LGA    V   155_A      H     144          1.347
LGA    E   156_A      T     145          1.163
LGA    V   157_A      E     146          3.888
LGA    G   158_A      L     147          3.028
LGA    K   159_A      -       -           -
LGA    K   160_A      P     148          3.288
LGA    D   161_A      F     149          4.049
LGA    Y   162_A      Y     150          2.644
LGA    L   163_A      Q     151          1.524
LGA    G   164_A      Q     152          2.666
LGA    A   165_A      -       -           -
LGA    X   166_A      R     153          1.844
LGA    P   167_A      -       -           -
LGA    Y   168_A      -       -           -
LGA    K   169_A      -       -           -
LGA    A   170_A      -       -           -
LGA    P   171_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  180  144    5.0    130    2.32    10.77     61.117     5.378

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.926161 * X  +  -0.349832 * Y  +  -0.140868 * Z  +  52.140423
  Y_new =   0.376778 * X  +  -0.842191 * Y  +  -0.385686 * Z  +  32.552673
  Z_new =   0.016287 * X  +  -0.410283 * Y  +   0.911813 * Z  +  -5.599926 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.422824    2.718769  [ DEG:   -24.2260    155.7740 ]
  Theta =  -0.016288   -3.125304  [ DEG:    -0.9332   -179.0668 ]
  Phi   =   2.755224   -0.386369  [ DEG:   157.8627    -22.1373 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2oqm_A                                        
REMARK     2: T0481.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2oqm_A.T0481.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  180  144   5.0  130   2.32   10.77  61.117
REMARK  ---------------------------------------------------------- 
MOLECULE 2oqm_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   31-JAN-07   2OQM              
TITLE     CRYSTAL STRUCTURE OF A DNA DAMAGE-INDUCIBLE PROTEIN FROM              
TITLE    2 DINB FAMILY (YP_561575.1) FROM SHEWANELLA DENITRIFICANS OS-          
TITLE    3 217 AT 1.83 A RESOLUTION                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SHEWANELLA DENITRIFICANS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: OS217, DSM 15013;                                            
SOURCE   5 ATCC: BAA-1090;                                                      
SOURCE   6 GENE: YP_561575.1, SDEN_0562;                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_561575.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI-2                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   13-FEB-07 2OQM    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (YP_561575.1) FROM SHEWANELLA DENITRIFICANS OS-217           
JRNL        TITL 3 AT 1.83 A RESOLUTION                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.83 ANGSTROMS.                                          
DBREF  2OQM A    1   173  UNP    Q12RS4   Q12RS4_SHEDO     1    173             
DBREF  2OQM B    1   173  UNP    Q12RS4   Q12RS4_SHEDO     1    173             
DBREF  2OQM C    1   173  UNP    Q12RS4   Q12RS4_SHEDO     1    173             
DBREF  2OQM D    1   173  UNP    Q12RS4   Q12RS4_SHEDO     1    173             
SEQRES   1 A  192  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  192  ASN LEU TYR PHE GLN GLY MSE LEU TYR ASP LEU THR VAL          
SEQRES   3 A  192  VAL GLN PHE SER LYS MSE LEU LYS ASN LEU ASN ALA ILE          
SEQRES   4 A  192  PHE ASP LYS ALA GLU ALA PHE ALA GLU LEU LYS LYS VAL          
SEQRES   5 A  192  ASP MSE ASP VAL LEU LEU ASN SER ARG LEU ALA ALA ASP          
SEQRES   6 A  192  GLN PHE ASN LEU ILE ARG GLN VAL GLN ILE ALA CYS ASP          
SEQRES   7 A  192  THR ALA LYS VAL GLY VAL ALA ARG LEU THR GLY GLN LEU          
SEQRES   8 A  192  GLU THR ALA PRO LYS HIS ASP ASP SER GLU THR THR LEU          
SEQRES   9 A  192  ALA GLU LEU ARG GLN ARG ILE ALA SER VAL LEU THR TYR          
SEQRES  10 A  192  LEU GLU GLY PHE SER GLU ALA ASP PHE ALA ASN ALA ALA          
SEQRES  11 A  192  THR ILE GLN ILE SER GLN PRO ARG TRP GLN GLY LYS TYR          
SEQRES  12 A  192  LEU THR GLY TYR GLU PHE ALA ILE GLU HIS ALA ILE PRO          
SEQRES  13 A  192  ASN LEU TYR PHE HIS ILE THR THR ALA TYR GLY ILE LEU          
SEQRES  14 A  192  ARG HIS ASN GLY VAL GLU VAL GLY LYS LYS ASP TYR LEU          
SEQRES  15 A  192  GLY ALA MSE PRO TYR LYS ALA PRO ILE LEU                      
SEQRES   1 B  192  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  192  ASN LEU TYR PHE GLN GLY MSE LEU TYR ASP LEU THR VAL          
SEQRES   3 B  192  VAL GLN PHE SER LYS MSE LEU LYS ASN LEU ASN ALA ILE          
SEQRES   4 B  192  PHE ASP LYS ALA GLU ALA PHE ALA GLU LEU LYS LYS VAL          
SEQRES   5 B  192  ASP MSE ASP VAL LEU LEU ASN SER ARG LEU ALA ALA ASP          
SEQRES   6 B  192  GLN PHE ASN LEU ILE ARG GLN VAL GLN ILE ALA CYS ASP          
SEQRES   7 B  192  THR ALA LYS VAL GLY VAL ALA ARG LEU THR GLY GLN LEU          
SEQRES   8 B  192  GLU THR ALA PRO LYS HIS ASP ASP SER GLU THR THR LEU          
SEQRES   9 B  192  ALA GLU LEU ARG GLN ARG ILE ALA SER VAL LEU THR TYR          
SEQRES  10 B  192  LEU GLU GLY PHE SER GLU ALA ASP PHE ALA ASN ALA ALA          
SEQRES  11 B  192  THR ILE GLN ILE SER GLN PRO ARG TRP GLN GLY LYS TYR          
SEQRES  12 B  192  LEU THR GLY TYR GLU PHE ALA ILE GLU HIS ALA ILE PRO          
SEQRES  13 B  192  ASN LEU TYR PHE HIS ILE THR THR ALA TYR GLY ILE LEU          
SEQRES  14 B  192  ARG HIS ASN GLY VAL GLU VAL GLY LYS LYS ASP TYR LEU          
SEQRES  15 B  192  GLY ALA MSE PRO TYR LYS ALA PRO ILE LEU                      
SEQRES   1 C  192  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 C  192  ASN LEU TYR PHE GLN GLY MSE LEU TYR ASP LEU THR VAL          
SEQRES   3 C  192  VAL GLN PHE SER LYS MSE LEU LYS ASN LEU ASN ALA ILE          
SEQRES   4 C  192  PHE ASP LYS ALA GLU ALA PHE ALA GLU LEU LYS LYS VAL          
SEQRES   5 C  192  ASP MSE ASP VAL LEU LEU ASN SER ARG LEU ALA ALA ASP          
SEQRES   6 C  192  GLN PHE ASN LEU ILE ARG GLN VAL GLN ILE ALA CYS ASP          
SEQRES   7 C  192  THR ALA LYS VAL GLY VAL ALA ARG LEU THR GLY GLN LEU          
SEQRES   8 C  192  GLU THR ALA PRO LYS HIS ASP ASP SER GLU THR THR LEU          
SEQRES   9 C  192  ALA GLU LEU ARG GLN ARG ILE ALA SER VAL LEU THR TYR          
SEQRES  10 C  192  LEU GLU GLY PHE SER GLU ALA ASP PHE ALA ASN ALA ALA          
SEQRES  11 C  192  THR ILE GLN ILE SER GLN PRO ARG TRP GLN GLY LYS TYR          
SEQRES  12 C  192  LEU THR GLY TYR GLU PHE ALA ILE GLU HIS ALA ILE PRO          
SEQRES  13 C  192  ASN LEU TYR PHE HIS ILE THR THR ALA TYR GLY ILE LEU          
SEQRES  14 C  192  ARG HIS ASN GLY VAL GLU VAL GLY LYS LYS ASP TYR LEU          
SEQRES  15 C  192  GLY ALA MSE PRO TYR LYS ALA PRO ILE LEU                      
SEQRES   1 D  192  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 D  192  ASN LEU TYR PHE GLN GLY MSE LEU TYR ASP LEU THR VAL          
SEQRES   3 D  192  VAL GLN PHE SER LYS MSE LEU LYS ASN LEU ASN ALA ILE          
SEQRES   4 D  192  PHE ASP LYS ALA GLU ALA PHE ALA GLU LEU LYS LYS VAL          
SEQRES   5 D  192  ASP MSE ASP VAL LEU LEU ASN SER ARG LEU ALA ALA ASP          
SEQRES   6 D  192  GLN PHE ASN LEU ILE ARG GLN VAL GLN ILE ALA CYS ASP          
SEQRES   7 D  192  THR ALA LYS VAL GLY VAL ALA ARG LEU THR GLY GLN LEU          
SEQRES   8 D  192  GLU THR ALA PRO LYS HIS ASP ASP SER GLU THR THR LEU          
SEQRES   9 D  192  ALA GLU LEU ARG GLN ARG ILE ALA SER VAL LEU THR TYR          
SEQRES  10 D  192  LEU GLU GLY PHE SER GLU ALA ASP PHE ALA ASN ALA ALA          
SEQRES  11 D  192  THR ILE GLN ILE SER GLN PRO ARG TRP GLN GLY LYS TYR          
SEQRES  12 D  192  LEU THR GLY TYR GLU PHE ALA ILE GLU HIS ALA ILE PRO          
SEQRES  13 D  192  ASN LEU TYR PHE HIS ILE THR THR ALA TYR GLY ILE LEU          
SEQRES  14 D  192  ARG HIS ASN GLY VAL GLU VAL GLY LYS LYS ASP TYR LEU          
SEQRES  15 D  192  GLY ALA MSE PRO TYR LYS ALA PRO ILE LEU                      
HET    MSE  A   1       8                                                       
HET    MSE  A  13       8                                                       
HET    MSE  A  35       8                                                       
HET    MSE  A 166       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  13       8                                                       
HET    MSE  B  35       8                                                       
HET    MSE  B 166       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  13       8                                                       
HET    MSE  C  35       8                                                       
HET    MSE  C 166       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  13       8                                                       
HET    MSE  D  35       8                                                       
HET    MSE  D 166       8                                                       
HET     CL      1       1                                                       
HET    EDO      2       4                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HET    EDO      6       4                                                       
HET    EDO      7       4                                                       
HET    EDO      8       4                                                       
HET    EDO      9       4                                                       
HET    EDO     10       4                                                       
HET    EDO     11       4                                                       
HET    EDO     12       4                                                       
HET    EDO     13       4                                                       
HET    EDO     14       4                                                       
HET    EDO     15       4                                                       
HET    EDO     16       4                                                       
HET    EDO     17       4                                                       
HET    EDO     18       4                                                       
HET    FMT     19       3                                                       
HET    FMT     20       3                                                       
HET    FMT     21       3                                                       
HET    FMT     22       3                                                       
HET    FMT     23       3                                                       
HET    FMT     24       3                                                       
HET    FMT     25       3                                                       
HET    FMT     26       3                                                       
HET    FMT     27       3                                                       
HET    FMT     28       3                                                       
HET    FMT     29       3                                                       
HET    FMT     30       3                                                       
HET    FMT     31       3                                                       
HET    FMT     32       3                                                       
HET    FMT     33       3                                                       
HET    FMT     34       3                                                       
HET    FMT     35       3                                                       
HET    FMT     36       3                                                       
HET    FMT     37       3                                                       
HET    FMT     38       3                                                       
HET    FMT     39       3                                                       
HET    FMT     40       3                                                       
HET    FMT     41       3                                                       
HET    FMT     42       3                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     FMT FORMIC ACID                                                      
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   5   CL    CL 1-                                                        
FORMUL   6  EDO    17(C2 H6 O2)                                                 
FORMUL  23  FMT    24(C H2 O2)                                                  
FORMUL  47  HOH   *545(H2 O)                                                    
CRYST1   62.437   71.722   93.489  90.00 107.35  90.00 P 1 21 1      8          
ATOM      1  N   HIS A  -8      43.982  37.050  -4.100  1.00 40.01           N  
ATOM      2  CA  HIS A  -8      43.267  38.360  -4.010  1.00 39.29           C  
ATOM      3  C   HIS A  -8      43.610  39.032  -2.662  1.00 36.56           C  
ATOM      4  O   HIS A  -8      42.719  39.609  -1.997  1.00 42.08           O  
ATOM      5  N   HIS A  -7      44.890  38.943  -2.272  1.00 30.79           N  
ATOM      6  CA  HIS A  -7      45.402  39.526  -1.012  1.00 29.43           C  
ATOM      7  C   HIS A  -7      44.709  38.900   0.181  1.00 29.37           C  
ATOM      8  O   HIS A  -7      44.596  39.515   1.214  1.00 29.13           O  
ATOM      9  CB  HIS A  -7      45.202  41.036  -0.984  1.00 30.20           C  
ATOM     10  CG  HIS A  -7      45.862  41.738  -2.128  1.00 27.53           C  
ATOM     11  ND1 HIS A  -7      45.151  42.279  -3.179  1.00 36.49           N  
ATOM     12  CD2 HIS A  -7      47.165  41.979  -2.383  1.00 25.74           C  
ATOM     13  CE1 HIS A  -7      45.996  42.824  -4.036  1.00 32.23           C  
ATOM     14  NE2 HIS A  -7      47.225  42.664  -3.576  1.00 37.87           N  
ATOM     15  N   GLU A  -6      44.254  37.669   0.050  1.00 33.62           N  
ATOM     16  CA  GLU A  -6      43.405  37.112   1.124  1.00 38.50           C  
ATOM     17  C   GLU A  -6      44.115  37.096   2.496  1.00 35.42           C  
ATOM     18  O   GLU A  -6      43.470  37.354   3.504  1.00 32.35           O  
ATOM     19  CB  GLU A  -6      42.846  35.745   0.744  1.00 36.14           C  
ATOM     20  CG  GLU A  -6      43.882  34.676   0.442  1.00 47.72           C  
ATOM     21  CD  GLU A  -6      43.253  33.320   0.070  1.00 51.46           C  
ATOM     22  OE1 GLU A  -6      42.015  33.147   0.263  1.00 73.61           O  
ATOM     23  OE2 GLU A  -6      43.998  32.432  -0.426  1.00 72.40           O  
ATOM     24  N   ASN A  -5      45.427  36.830   2.520  1.00 32.92           N  
ATOM     25  CA  ASN A  -5      46.175  36.874   3.784  1.00 34.19           C  
ATOM     26  C   ASN A  -5      46.026  38.230   4.508  1.00 33.82           C  
ATOM     27  O   ASN A  -5      45.872  38.283   5.716  1.00 30.41           O  
ATOM     28  CB  ASN A  -5      47.654  36.548   3.581  1.00 34.68           C  
ATOM     29  N   LEU A  -4      46.059  39.323   3.762  1.00 30.43           N  
ATOM     30  CA  LEU A  -4      45.954  40.660   4.335  1.00 32.81           C  
ATOM     31  C   LEU A  -4      44.580  40.856   4.969  1.00 29.50           C  
ATOM     32  O   LEU A  -4      44.441  41.409   6.072  1.00 27.02           O  
ATOM     33  CB  LEU A  -4      46.170  41.672   3.211  1.00 32.98           C  
ATOM     34  CG  LEU A  -4      46.587  43.097   3.445  1.00 43.14           C  
ATOM     35  CD1 LEU A  -4      48.033  43.111   3.879  1.00 51.66           C  
ATOM     36  CD2 LEU A  -4      46.356  43.886   2.114  1.00 39.99           C  
ATOM     37  N   TYR A  -3      43.550  40.378   4.280  1.00 31.33           N  
ATOM     38  CA  TYR A  -3      42.184  40.527   4.810  1.00 30.53           C  
ATOM     39  C   TYR A  -3      41.925  39.622   5.997  1.00 29.32           C  
ATOM     40  O   TYR A  -3      41.353  40.062   6.991  1.00 30.08           O  
ATOM     41  CB  TYR A  -3      41.117  40.351   3.707  1.00 32.36           C  
ATOM     42  CG  TYR A  -3      41.135  41.486   2.734  1.00 29.18           C  
ATOM     43  CD1 TYR A  -3      42.002  41.491   1.649  1.00 29.82           C  
ATOM     44  CD2 TYR A  -3      40.290  42.586   2.906  1.00 31.78           C  
ATOM     45  CE1 TYR A  -3      42.023  42.545   0.759  1.00 35.12           C  
ATOM     46  CE2 TYR A  -3      40.318  43.633   2.043  1.00 33.71           C  
ATOM     47  CZ  TYR A  -3      41.179  43.616   0.965  1.00 29.80           C  
ATOM     48  OH  TYR A  -3      41.186  44.687   0.119  1.00 35.25           O  
ATOM     49  N   PHE A  -2      42.345  38.361   5.912  1.00 29.82           N  
ATOM     50  CA  PHE A  -2      42.084  37.448   6.970  1.00 30.40           C  
ATOM     51  C   PHE A  -2      42.811  37.914   8.197  1.00 28.88           C  
ATOM     52  O   PHE A  -2      42.255  37.900   9.289  1.00 26.96           O  
ATOM     53  CB  PHE A  -2      42.532  36.053   6.621  1.00 33.01           C  
ATOM     54  CG  PHE A  -2      41.514  35.275   5.892  1.00 38.65           C  
ATOM     55  CD1 PHE A  -2      40.352  34.879   6.522  1.00 35.54           C  
ATOM     56  CD2 PHE A  -2      41.714  34.910   4.578  1.00 40.80           C  
ATOM     57  CE1 PHE A  -2      39.410  34.143   5.848  1.00 38.53           C  
ATOM     58  CE2 PHE A  -2      40.765  34.193   3.908  1.00 39.82           C  
ATOM     59  CZ  PHE A  -2      39.609  33.804   4.557  1.00 42.77           C  
ATOM     60  N   GLN A  -1      44.051  38.350   8.035  1.00 27.72           N  
ATOM     61  CA  GLN A  -1      44.814  38.727   9.218  1.00 29.91           C  
ATOM     62  C   GLN A  -1      44.287  39.984   9.877  1.00 28.80           C  
ATOM     63  O   GLN A  -1      44.224  40.067  11.080  1.00 25.47           O  
ATOM     64  CB  GLN A  -1      46.331  38.826   8.912  1.00 32.33           C  
ATOM     65  CG  GLN A  -1      46.770  40.076   8.237  1.00 35.05           C  
ATOM     66  CD  GLN A  -1      48.283  40.103   7.885  1.00 31.72           C  
ATOM     67  OE1 GLN A  -1      48.955  39.072   7.796  1.00 31.54           O  
ATOM     68  NE2 GLN A  -1      48.789  41.295   7.675  1.00 31.58           N  
ATOM     69  N   GLY A   0      43.894  40.971   9.092  1.00 28.81           N  
ATOM     70  CA  GLY A   0      43.337  42.201   9.638  1.00 28.79           C  
ATOM     71  C   GLY A   0      42.031  41.980  10.396  1.00 28.17           C  
ATOM     72  O   GLY A   0      41.872  42.461  11.504  1.00 26.00           O  
HETATM   73  N   MSE A   1      41.094  41.255   9.778  1.00 27.70           N  
HETATM   74  CA  MSE A   1      39.837  40.881  10.419  1.00 28.12           C  
HETATM   75  C   MSE A   1      40.044  40.127  11.738  1.00 27.65           C  
HETATM   76  O   MSE A   1      39.436  40.467  12.755  1.00 28.06           O  
HETATM   77  CB  MSE A   1      38.990  40.037   9.444  1.00 30.12           C  
HETATM   78  CG  MSE A   1      37.699  39.456   9.999  1.00 31.05           C  
HETATM   79 SE   MSE A   1      36.437  40.874  10.492  0.75 30.16          SE  
HETATM   80  CE  MSE A   1      35.701  41.072   8.810  1.00 18.54           C  
ATOM     81  N   LEU A   2      40.873  39.098  11.718  1.00 26.53           N  
ATOM     82  CA  LEU A   2      41.086  38.260  12.913  1.00 25.38           C  
ATOM     83  C   LEU A   2      41.737  39.060  14.025  1.00 26.40           C  
ATOM     84  O   LEU A   2      41.374  38.916  15.175  1.00 25.66           O  
ATOM     85  CB  LEU A   2      41.847  36.974  12.557  1.00 28.13           C  
ATOM     86  CG  LEU A   2      41.071  35.880  11.797  1.00 27.32           C  
ATOM     87  CD1 LEU A   2      41.934  34.781  11.182  1.00 26.47           C  
ATOM     88  CD2 LEU A   2      39.913  35.273  12.639  1.00 26.56           C  
ATOM     89  N   TYR A   3      42.693  39.925  13.677  1.00 25.83           N  
ATOM     90  CA  TYR A   3      43.285  40.902  14.608  1.00 25.91           C  
ATOM     91  C   TYR A   3      42.214  41.852  15.237  1.00 23.12           C  
ATOM     92  O   TYR A   3      42.161  42.045  16.445  1.00 26.07           O  
ATOM     93  CB  TYR A   3      44.367  41.730  13.867  1.00 24.85           C  
ATOM     94  CG  TYR A   3      45.056  42.751  14.747  1.00 21.80           C  
ATOM     95  CD1 TYR A   3      46.058  42.381  15.637  1.00 27.16           C  
ATOM     96  CD2 TYR A   3      44.668  44.083  14.712  1.00 25.93           C  
ATOM     97  CE1 TYR A   3      46.654  43.328  16.455  1.00 29.02           C  
ATOM     98  CE2 TYR A   3      45.256  45.038  15.520  1.00 25.97           C  
ATOM     99  CZ  TYR A   3      46.246  44.659  16.386  1.00 25.93           C  
ATOM    100  OH  TYR A   3      46.808  45.593  17.200  1.00 30.84           O  
ATOM    101  N   ASP A   4      41.379  42.431  14.404  1.00 25.86           N  
ATOM    102  CA  ASP A   4      40.326  43.331  14.845  1.00 24.60           C  
ATOM    103  C   ASP A   4      39.276  42.642  15.701  1.00 24.61           C  
ATOM    104  O   ASP A   4      38.785  43.220  16.652  1.00 26.20           O  
ATOM    105  CB  ASP A   4      39.659  43.996  13.621  1.00 24.71           C  
ATOM    106  CG  ASP A   4      40.529  45.070  12.989  1.00 31.51           C  
ATOM    107  OD1 ASP A   4      41.491  45.533  13.648  1.00 27.13           O  
ATOM    108  OD2 ASP A   4      40.208  45.485  11.850  1.00 26.48           O  
ATOM    109  N   LEU A   5      38.942  41.396  15.385  1.00 26.42           N  
ATOM    110  CA  LEU A   5      37.908  40.673  16.127  1.00 24.93           C  
ATOM    111  C   LEU A   5      38.399  40.268  17.514  1.00 26.75           C  
ATOM    112  O   LEU A   5      37.602  40.089  18.425  1.00 26.91           O  
ATOM    113  CB  LEU A   5      37.524  39.418  15.370  1.00 27.41           C  
ATOM    114  CG  LEU A   5      36.681  39.537  14.119  1.00 28.15           C  
ATOM    115  CD1 LEU A   5      36.656  38.209  13.339  1.00 25.65           C  
ATOM    116  CD2 LEU A   5      35.288  40.017  14.515  1.00 29.08           C  
ATOM    117  N   THR A   6      39.709  40.059  17.641  1.00 25.76           N  
ATOM    118  CA  THR A   6      40.260  39.446  18.838  1.00 25.50           C  
ATOM    119  C   THR A   6      41.062  40.467  19.590  1.00 25.86           C  
ATOM    120  O   THR A   6      40.540  41.089  20.524  1.00 28.49           O  
ATOM    121  CB  THR A   6      41.040  38.147  18.522  1.00 25.60           C  
ATOM    122  OG1 THR A   6      42.189  38.398  17.685  1.00 24.81           O  
ATOM    123  CG2 THR A   6      40.097  37.067  17.866  1.00 26.18           C  
ATOM    124  N   VAL A   7      42.260  40.778  19.136  1.00 26.03           N  
ATOM    125  CA  VAL A   7      43.082  41.752  19.871  1.00 25.85           C  
ATOM    126  C   VAL A   7      42.339  43.055  20.155  1.00 26.68           C  
ATOM    127  O   VAL A   7      42.303  43.559  21.286  1.00 27.79           O  
ATOM    128  CB  VAL A   7      44.431  42.043  19.158  1.00 24.88           C  
ATOM    129  CG1 VAL A   7      45.201  43.216  19.878  1.00 25.85           C  
ATOM    130  CG2 VAL A   7      45.295  40.806  19.202  1.00 25.17           C  
ATOM    131  N   VAL A   8      41.766  43.636  19.116  1.00 25.43           N  
ATOM    132  CA  VAL A   8      41.219  44.971  19.249  1.00 25.40           C  
ATOM    133  C   VAL A   8      39.861  44.924  20.006  1.00 22.33           C  
ATOM    134  O   VAL A   8      39.695  45.564  21.047  1.00 23.58           O  
ATOM    135  CB  VAL A   8      41.108  45.626  17.905  1.00 25.95           C  
ATOM    136  CG1 VAL A   8      40.495  47.053  18.042  1.00 24.84           C  
ATOM    137  CG2 VAL A   8      42.535  45.666  17.234  1.00 24.66           C  
ATOM    138  N   GLN A   9      38.916  44.151  19.521  1.00 23.93           N  
ATOM    139  CA  GLN A   9      37.589  44.117  20.146  1.00 23.99           C  
ATOM    140  C   GLN A   9      37.575  43.455  21.495  1.00 24.45           C  
ATOM    141  O   GLN A   9      36.871  43.912  22.396  1.00 21.72           O  
ATOM    142  CB  GLN A   9      36.491  43.572  19.176  1.00 24.09           C  
ATOM    143  CG  GLN A   9      35.104  43.515  19.773  1.00 25.19           C  
ATOM    144  CD  GLN A   9      34.466  44.861  20.088  1.00 21.60           C  
ATOM    145  OE1 GLN A   9      34.951  45.955  19.696  1.00 24.41           O  
ATOM    146  NE2 GLN A   9      33.342  44.789  20.775  1.00 20.27           N  
ATOM    147  N   PHE A  10      38.403  42.429  21.706  1.00 23.11           N  
ATOM    148  CA  PHE A  10      38.482  41.837  23.028  1.00 23.00           C  
ATOM    149  C   PHE A  10      39.101  42.781  24.050  1.00 23.96           C  
ATOM    150  O   PHE A  10      38.712  42.745  25.236  1.00 22.07           O  
ATOM    151  CB  PHE A  10      39.344  40.585  23.049  1.00 21.56           C  
ATOM    152  CG  PHE A  10      38.757  39.360  22.354  1.00 25.41           C  
ATOM    153  CD1 PHE A  10      37.443  39.318  21.901  1.00 24.45           C  
ATOM    154  CD2 PHE A  10      39.537  38.215  22.241  1.00 28.60           C  
ATOM    155  CE1 PHE A  10      36.939  38.143  21.300  1.00 26.88           C  
ATOM    156  CE2 PHE A  10      39.041  37.069  21.665  1.00 26.25           C  
ATOM    157  CZ  PHE A  10      37.725  37.045  21.187  1.00 25.80           C  
ATOM    158  N   SER A  11      40.100  43.570  23.635  1.00 26.09           N  
ATOM    159  CA  SER A  11      40.648  44.620  24.514  1.00 23.38           C  
ATOM    160  C   SER A  11      39.587  45.670  24.899  1.00 23.45           C  
ATOM    161  O   SER A  11      39.513  46.097  26.021  1.00 24.14           O  
ATOM    162  CB  SER A  11      41.855  45.320  23.861  1.00 24.98           C  
ATOM    163  OG  SER A  11      42.966  44.417  23.680  1.00 23.48           O  
ATOM    164  N   LYS A  12      38.813  46.118  23.937  1.00 24.27           N  
ATOM    165  CA  LYS A  12      37.691  46.993  24.201  1.00 21.68           C  
ATOM    166  C   LYS A  12      36.723  46.425  25.195  1.00 23.83           C  
ATOM    167  O   LYS A  12      36.324  47.089  26.125  1.00 24.06           O  
ATOM    168  CB  LYS A  12      36.934  47.297  22.905  1.00 24.36           C  
ATOM    169  CG  LYS A  12      35.852  48.356  23.093  1.00 25.28           C  
ATOM    170  CD  LYS A  12      35.039  48.643  21.792  1.00 24.13           C  
ATOM    171  CE  LYS A  12      34.026  49.759  21.986  1.00 32.55           C  
ATOM    172  NZ  LYS A  12      33.075  49.810  20.862  1.00 23.38           N  
HETATM  173  N   MSE A  13      36.332  45.173  25.014  1.00 25.11           N  
HETATM  174  CA  MSE A  13      35.345  44.567  25.890  1.00 23.27           C  
HETATM  175  C   MSE A  13      35.925  44.360  27.289  1.00 22.13           C  
HETATM  176  O   MSE A  13      35.186  44.424  28.266  1.00 22.98           O  
HETATM  177  CB  MSE A  13      34.888  43.251  25.324  1.00 21.51           C  
HETATM  178  CG  MSE A  13      34.045  43.329  24.032  1.00 23.07           C  
HETATM  179 SE   MSE A  13      32.469  44.422  24.307  0.75 19.38          SE  
HETATM  180  CE  MSE A  13      31.709  43.395  25.786  1.00 21.42           C  
ATOM    181  N   LEU A  14      37.212  44.065  27.402  1.00 24.19           N  
ATOM    182  CA  LEU A  14      37.837  43.927  28.721  1.00 23.41           C  
ATOM    183  C   LEU A  14      37.899  45.268  29.431  1.00 24.23           C  
ATOM    184  O   LEU A  14      37.693  45.323  30.656  1.00 25.37           O  
ATOM    185  CB  LEU A  14      39.215  43.267  28.680  1.00 25.49           C  
ATOM    186  CG  LEU A  14      39.192  41.785  28.300  1.00 24.38           C  
ATOM    187  CD1 LEU A  14      40.589  41.239  27.952  1.00 29.52           C  
ATOM    188  CD2 LEU A  14      38.450  40.902  29.353  1.00 22.64           C  
ATOM    189  N   LYS A  15      38.211  46.331  28.696  1.00 22.46           N  
ATOM    190  CA  LYS A  15      38.120  47.679  29.253  1.00 24.11           C  
ATOM    191  C   LYS A  15      36.687  47.974  29.706  1.00 22.33           C  
ATOM    192  O   LYS A  15      36.433  48.595  30.746  1.00 22.62           O  
ATOM    193  CB  LYS A  15      38.590  48.694  28.231  1.00 25.36           C  
ATOM    194  CG  LYS A  15      40.097  48.627  27.960  1.00 27.99           C  
ATOM    195  CD  LYS A  15      40.546  49.746  27.059  1.00 29.93           C  
ATOM    196  CE  LYS A  15      41.874  49.420  26.368  1.00 45.46           C  
ATOM    197  NZ  LYS A  15      42.117  50.348  25.196  1.00 50.74           N  
ATOM    198  N   ASN A  16      35.738  47.547  28.913  1.00 24.17           N  
ATOM    199  CA  ASN A  16      34.327  47.700  29.282  1.00 23.44           C  
ATOM    200  C   ASN A  16      33.993  46.936  30.553  1.00 24.25           C  
ATOM    201  O   ASN A  16      33.269  47.437  31.436  1.00 25.08           O  
ATOM    202  CB  ASN A  16      33.425  47.261  28.135  1.00 22.88           C  
ATOM    203  CG  ASN A  16      33.482  48.164  26.951  1.00 27.53           C  
ATOM    204  OD1 ASN A  16      34.051  49.271  26.991  1.00 23.63           O  
ATOM    205  ND2 ASN A  16      32.929  47.680  25.831  1.00 24.49           N  
ATOM    206  N   LEU A  17      34.573  45.752  30.709  1.00 23.35           N  
ATOM    207  CA  LEU A  17      34.372  44.972  31.917  1.00 24.41           C  
ATOM    208  C   LEU A  17      34.918  45.739  33.145  1.00 26.36           C  
ATOM    209  O   LEU A  17      34.334  45.722  34.250  1.00 23.94           O  
ATOM    210  CB  LEU A  17      35.043  43.602  31.772  1.00 24.01           C  
ATOM    211  CG  LEU A  17      34.820  42.636  32.927  1.00 27.51           C  
ATOM    212  CD1 LEU A  17      33.339  42.349  33.194  1.00 24.73           C  
ATOM    213  CD2 LEU A  17      35.672  41.362  32.652  1.00 24.41           C  
ATOM    214  N   ASN A  18      36.032  46.425  32.948  1.00 26.07           N  
ATOM    215  CA  ASN A  18      36.578  47.302  33.998  0.70 28.28           C  
ATOM    217  C   ASN A  18      35.624  48.390  34.404  1.00 29.50           C  
ATOM    218  O   ASN A  18      35.464  48.684  35.614  1.00 28.19           O  
ATOM    219  CB  ASN A  18      37.878  47.976  33.534  0.70 32.52           C  
ATOM    221  CG  ASN A  18      39.098  47.360  34.132  0.70 30.81           C  
ATOM    223  OD1 ASN A  18      39.080  46.895  35.269  0.70 39.25           O  
ATOM    225  ND2 ASN A  18      40.202  47.427  33.403  0.70 29.21           N  
ATOM    227  N   ALA A  19      34.993  49.013  33.400  1.00 29.98           N  
ATOM    228  CA  ALA A  19      33.980  50.080  33.602  1.00 32.82           C  
ATOM    229  C   ALA A  19      32.728  49.588  34.332  1.00 32.21           C  
ATOM    230  O   ALA A  19      32.115  50.305  35.132  1.00 31.87           O  
ATOM    231  CB  ALA A  19      33.530  50.664  32.211  1.00 31.16           C  
ATOM    232  N   ILE A  20      32.316  48.376  33.990  1.00 29.62           N  
ATOM    233  CA  ILE A  20      31.263  47.660  34.713  1.00 29.23           C  
ATOM    234  C   ILE A  20      31.581  47.538  36.222  1.00 29.67           C  
ATOM    235  O   ILE A  20      30.700  47.733  37.062  1.00 28.61           O  
ATOM    236  CB  ILE A  20      31.015  46.314  34.050  1.00 28.99           C  
ATOM    237  CG1 ILE A  20      30.317  46.542  32.688  1.00 33.62           C  
ATOM    238  CG2 ILE A  20      30.110  45.377  34.899  1.00 31.20           C  
ATOM    239  CD1 ILE A  20      30.350  45.290  31.815  1.00 24.78           C  
ATOM    240  N   PHE A  21      32.847  47.270  36.561  1.00 27.93           N  
ATOM    241  CA  PHE A  21      33.248  47.125  37.950  1.00 26.05           C  
ATOM    242  C   PHE A  21      33.337  48.428  38.672  1.00 27.98           C  
ATOM    243  O   PHE A  21      33.184  48.479  39.914  1.00 28.32           O  
ATOM    244  CB  PHE A  21      34.524  46.300  38.050  1.00 30.07           C  
ATOM    245  CG  PHE A  21      34.242  44.795  38.105  1.00 28.90           C  
ATOM    246  CD1 PHE A  21      33.795  44.217  39.277  1.00 33.80           C  
ATOM    247  CD2 PHE A  21      34.283  44.006  36.974  1.00 29.72           C  
ATOM    248  CE1 PHE A  21      33.499  42.867  39.347  1.00 38.21           C  
ATOM    249  CE2 PHE A  21      33.994  42.652  37.045  1.00 36.12           C  
ATOM    250  CZ  PHE A  21      33.591  42.091  38.228  1.00 36.46           C  
ATOM    251  N   ASP A  22      33.574  49.507  37.932  1.00 27.00           N  
ATOM    252  CA  ASP A  22      33.452  50.825  38.528  1.00 27.43           C  
ATOM    253  C   ASP A  22      32.024  51.062  39.020  1.00 25.63           C  
ATOM    254  O   ASP A  22      31.822  51.623  40.088  1.00 24.95           O  
ATOM    255  CB  ASP A  22      33.834  51.951  37.556  1.00 28.22           C  
ATOM    256  CG  ASP A  22      35.277  51.896  37.079  1.00 34.69           C  
ATOM    257  OD1 ASP A  22      36.156  51.212  37.685  1.00 33.03           O  
ATOM    258  OD2 ASP A  22      35.508  52.563  36.039  1.00 35.01           O  
ATOM    259  N   LYS A  23      31.019  50.659  38.253  1.00 28.29           N  
ATOM    260  CA  LYS A  23      29.639  50.754  38.742  1.00 26.77           C  
ATOM    261  C   LYS A  23      29.387  49.854  39.935  1.00 27.35           C  
ATOM    262  O   LYS A  23      28.682  50.266  40.846  1.00 29.62           O  
ATOM    263  CB  LYS A  23      28.617  50.487  37.622  1.00 27.86           C  
ATOM    264  CG  LYS A  23      28.794  51.489  36.476  1.00 36.06           C  
ATOM    265  CD  LYS A  23      27.470  51.983  35.987  1.00 43.50           C  
ATOM    266  CE  LYS A  23      27.607  53.136  35.027  1.00 47.85           C  
ATOM    267  NZ  LYS A  23      26.321  53.326  34.288  1.00 55.49           N  
ATOM    268  N   ALA A  24      29.949  48.639  39.933  1.00 26.65           N  
ATOM    269  CA  ALA A  24      29.817  47.725  41.091  1.00 25.33           C  
ATOM    270  C   ALA A  24      30.408  48.347  42.372  1.00 25.28           C  
ATOM    271  O   ALA A  24      29.809  48.281  43.423  1.00 24.23           O  
ATOM    272  CB  ALA A  24      30.431  46.369  40.799  1.00 27.42           C  
ATOM    273  N   GLU A  25      31.562  48.998  42.275  1.00 27.39           N  
ATOM    274  CA  GLU A  25      32.087  49.737  43.433  1.00 26.50           C  
ATOM    275  C   GLU A  25      31.186  50.867  43.881  1.00 27.28           C  
ATOM    276  O   GLU A  25      31.002  51.091  45.102  1.00 29.31           O  
ATOM    277  CB  GLU A  25      33.457  50.351  43.124  1.00 31.01           C  
ATOM    278  CG  GLU A  25      34.535  49.384  42.851  1.00 34.04           C  
ATOM    279  CD  GLU A  25      35.900  50.044  42.906  1.00 42.55           C  
ATOM    280  OE1 GLU A  25      36.394  50.286  44.011  1.00 46.43           O  
ATOM    281  OE2 GLU A  25      36.484  50.293  41.844  1.00 42.52           O  
ATOM    282  N   ALA A  26      30.650  51.627  42.927  1.00 28.92           N  
ATOM    283  CA  ALA A  26      29.702  52.703  43.287  1.00 29.52           C  
ATOM    284  C   ALA A  26      28.503  52.127  44.029  1.00 27.44           C  
ATOM    285  O   ALA A  26      28.167  52.595  45.102  1.00 28.11           O  
ATOM    286  CB  ALA A  26      29.274  53.531  42.071  1.00 28.34           C  
ATOM    287  N   PHE A  27      27.910  51.064  43.508  1.00 26.49           N  
ATOM    288  CA  PHE A  27      26.791  50.391  44.157  1.00 24.88           C  
ATOM    289  C   PHE A  27      27.087  49.934  45.588  1.00 27.60           C  
ATOM    290  O   PHE A  27      26.279  50.079  46.492  1.00 28.53           O  
ATOM    291  CB  PHE A  27      26.437  49.160  43.337  1.00 25.10           C  
ATOM    292  CG  PHE A  27      25.434  48.274  43.964  1.00 27.24           C  
ATOM    293  CD1 PHE A  27      24.084  48.547  43.856  1.00 28.02           C  
ATOM    294  CD2 PHE A  27      25.820  47.114  44.615  1.00 29.03           C  
ATOM    295  CE1 PHE A  27      23.169  47.682  44.386  1.00 30.82           C  
ATOM    296  CE2 PHE A  27      24.885  46.278  45.173  1.00 28.42           C  
ATOM    297  CZ  PHE A  27      23.587  46.561  45.067  1.00 24.29           C  
ATOM    298  N   ALA A  28      28.239  49.314  45.741  1.00 27.14           N  
ATOM    299  CA  ALA A  28      28.664  48.729  47.002  1.00 25.87           C  
ATOM    300  C   ALA A  28      28.848  49.826  48.025  1.00 27.78           C  
ATOM    301  O   ALA A  28      28.483  49.664  49.187  1.00 27.33           O  
ATOM    302  CB  ALA A  28      29.967  47.992  46.803  1.00 25.91           C  
ATOM    303  N   GLU A  29      29.413  50.948  47.596  1.00 27.95           N  
ATOM    304  CA  GLU A  29      29.592  52.067  48.499  1.00 32.06           C  
ATOM    305  C   GLU A  29      28.247  52.661  48.886  1.00 31.00           C  
ATOM    306  O   GLU A  29      27.940  52.842  50.053  1.00 31.12           O  
ATOM    307  CB  GLU A  29      30.479  53.118  47.828  1.00 33.63           C  
ATOM    308  CG  GLU A  29      30.665  54.390  48.628  1.00 42.49           C  
ATOM    309  CD  GLU A  29      31.213  54.154  50.016  1.00 48.49           C  
ATOM    310  OE1 GLU A  29      32.059  53.239  50.199  1.00 57.97           O  
ATOM    311  OE2 GLU A  29      30.794  54.913  50.923  1.00 63.07           O  
ATOM    312  N   LEU A  30      27.431  52.941  47.886  1.00 31.36           N  
ATOM    313  CA  LEU A  30      26.120  53.546  48.080  1.00 34.59           C  
ATOM    314  C   LEU A  30      25.166  52.700  48.898  1.00 33.99           C  
ATOM    315  O   LEU A  30      24.455  53.215  49.749  1.00 34.89           O  
ATOM    316  CB  LEU A  30      25.482  53.812  46.721  1.00 36.31           C  
ATOM    317  CG  LEU A  30      24.119  54.493  46.721  1.00 43.79           C  
ATOM    318  CD1 LEU A  30      24.250  55.931  47.230  1.00 45.22           C  
ATOM    319  CD2 LEU A  30      23.580  54.480  45.338  1.00 46.24           C  
ATOM    320  N   LYS A  31      25.139  51.406  48.631  1.00 31.27           N  
ATOM    321  CA  LYS A  31      24.256  50.485  49.344  1.00 32.95           C  
ATOM    322  C   LYS A  31      24.911  49.847  50.574  1.00 30.97           C  
ATOM    323  O   LYS A  31      24.305  49.067  51.278  1.00 34.24           O  
ATOM    324  CB  LYS A  31      23.785  49.423  48.351  1.00 37.01           C  
ATOM    325  CG  LYS A  31      22.991  50.039  47.206  1.00 40.27           C  
ATOM    326  CD  LYS A  31      21.547  50.322  47.645  1.00 52.19           C  
ATOM    327  CE  LYS A  31      20.881  51.471  46.869  1.00 53.88           C  
ATOM    328  NZ  LYS A  31      19.512  51.832  47.393  1.00 56.77           N  
ATOM    329  N   LYS A  32      26.148  50.224  50.849  1.00 31.12           N  
ATOM    330  CA  LYS A  32      26.925  49.651  51.930  0.50 30.88           C  
ATOM    332  C   LYS A  32      26.861  48.123  51.861  1.00 30.97           C  
ATOM    333  O   LYS A  32      26.580  47.452  52.857  1.00 33.58           O  
ATOM    334  CB  LYS A  32      26.453  50.229  53.276  0.50 32.03           C  
ATOM    336  CG  LYS A  32      26.749  51.728  53.394  0.50 32.21           C  
ATOM    338  CD  LYS A  32      25.594  52.547  53.983  0.50 35.26           C  
ATOM    340  CE  LYS A  32      25.846  54.066  53.896  0.50 36.51           C  
ATOM    342  NZ  LYS A  32      26.038  54.581  52.479  0.50 39.94           N  
ATOM    344  N   VAL A  33      27.103  47.603  50.650  1.00 31.36           N  
ATOM    345  CA  VAL A  33      27.202  46.166  50.352  1.00 31.95           C  
ATOM    346  C   VAL A  33      28.696  45.857  50.306  1.00 33.35           C  
ATOM    347  O   VAL A  33      29.496  46.639  49.806  1.00 30.18           O  
ATOM    348  CB  VAL A  33      26.530  45.870  48.980  1.00 33.98           C  
ATOM    349  CG1 VAL A  33      26.791  44.434  48.468  1.00 30.75           C  
ATOM    350  CG2 VAL A  33      25.019  46.186  49.059  1.00 34.51           C  
ATOM    351  N   ASP A  34      29.068  44.718  50.847  1.00 32.03           N  
ATOM    352  CA  ASP A  34      30.434  44.267  50.861  1.00 29.93           C  
ATOM    353  C   ASP A  34      30.779  43.739  49.461  1.00 26.32           C  
ATOM    354  O   ASP A  34      30.055  42.917  48.909  1.00 24.38           O  
ATOM    355  CB  ASP A  34      30.505  43.166  51.900  1.00 35.91           C  
ATOM    356  CG  ASP A  34      31.821  42.510  51.962  1.00 38.12           C  
ATOM    357  OD1 ASP A  34      32.733  42.975  51.266  1.00 46.04           O  
ATOM    358  OD2 ASP A  34      31.925  41.513  52.729  1.00 60.46           O  
HETATM  359  N   MSE A  35      31.875  44.223  48.874  1.00 25.46           N  
HETATM  360  CA  MSE A  35      32.267  43.790  47.513  1.00 25.89           C  
HETATM  361  C   MSE A  35      32.477  42.258  47.420  1.00 25.19           C  
HETATM  362  O   MSE A  35      32.234  41.647  46.381  1.00 25.56           O  
HETATM  363  CB  MSE A  35      33.538  44.534  47.084  1.00 24.00           C  
HETATM  364  CG  MSE A  35      34.101  44.200  45.721  1.00 27.00           C  
HETATM  365 SE   MSE A  35      32.859  44.425  44.184  0.75 28.30          SE  
HETATM  366  CE  MSE A  35      32.503  46.246  44.255  1.00 20.82           C  
ATOM    367  N   ASP A  36      32.955  41.659  48.501  1.00 26.57           N  
ATOM    368  CA  ASP A  36      33.151  40.210  48.599  0.50 27.63           C  
ATOM    370  C   ASP A  36      31.882  39.427  48.256  1.00 26.73           C  
ATOM    371  O   ASP A  36      31.937  38.339  47.630  1.00 27.18           O  
ATOM    372  CB  ASP A  36      33.602  39.843  50.034  0.50 30.14           C  
ATOM    374  CG  ASP A  36      34.262  38.464  50.118  0.50 35.53           C  
ATOM    376  OD1 ASP A  36      35.196  38.181  49.335  0.50 42.89           O  
ATOM    378  OD2 ASP A  36      33.846  37.657  50.980  0.50 39.41           O  
ATOM    380  N   VAL A  37      30.746  39.964  48.686  1.00 24.55           N  
ATOM    381  CA  VAL A  37      29.444  39.339  48.479  1.00 24.43           C  
ATOM    382  C   VAL A  37      29.156  39.286  46.976  1.00 25.22           C  
ATOM    383  O   VAL A  37      28.842  38.241  46.461  1.00 24.78           O  
ATOM    384  CB  VAL A  37      28.288  40.091  49.237  1.00 23.32           C  
ATOM    385  CG1 VAL A  37      26.894  39.532  48.832  1.00 25.41           C  
ATOM    386  CG2 VAL A  37      28.457  39.983  50.772  1.00 28.10           C  
ATOM    387  N   LEU A  38      29.381  40.409  46.276  1.00 20.77           N  
ATOM    388  CA  LEU A  38      29.237  40.481  44.823  1.00 24.28           C  
ATOM    389  C   LEU A  38      30.195  39.552  44.089  1.00 24.82           C  
ATOM    390  O   LEU A  38      29.787  38.820  43.176  1.00 21.55           O  
ATOM    391  CB  LEU A  38      29.398  41.947  44.295  1.00 24.23           C  
ATOM    392  CG  LEU A  38      28.392  42.979  44.815  1.00 26.49           C  
ATOM    393  CD1 LEU A  38      28.755  44.383  44.345  1.00 26.03           C  
ATOM    394  CD2 LEU A  38      26.938  42.606  44.390  1.00 25.56           C  
ATOM    395  N   LEU A  39      31.466  39.589  44.465  1.00 23.60           N  
ATOM    396  CA  LEU A  39      32.484  38.747  43.825  1.00 21.69           C  
ATOM    397  C   LEU A  39      32.202  37.269  43.969  1.00 23.87           C  
ATOM    398  O   LEU A  39      32.593  36.508  43.108  1.00 23.78           O  
ATOM    399  CB  LEU A  39      33.867  39.041  44.429  1.00 20.20           C  
ATOM    400  CG  LEU A  39      34.487  40.419  44.096  1.00 29.38           C  
ATOM    401  CD1 LEU A  39      35.827  40.633  44.877  1.00 27.58           C  
ATOM    402  CD2 LEU A  39      34.694  40.585  42.603  1.00 30.24           C  
ATOM    403  N   ASN A  40      31.548  36.849  45.048  1.00 21.36           N  
ATOM    404  CA  ASN A  40      31.226  35.435  45.215  1.00 23.29           C  
ATOM    405  C   ASN A  40      29.822  35.051  44.782  1.00 23.47           C  
ATOM    406  O   ASN A  40      29.429  33.932  45.018  1.00 23.60           O  
ATOM    407  CB  ASN A  40      31.468  35.009  46.646  1.00 23.57           C  
ATOM    408  CG  ASN A  40      32.933  34.945  46.960  1.00 29.06           C  
ATOM    409  OD1 ASN A  40      33.583  33.924  46.669  1.00 30.68           O  
ATOM    410  ND2 ASN A  40      33.492  36.052  47.460  1.00 26.33           N  
ATOM    411  N   SER A  41      29.088  35.982  44.176  1.00 23.86           N  
ATOM    412  CA  SER A  41      27.723  35.734  43.751  0.70 21.98           C  
ATOM    414  C   SER A  41      27.756  35.013  42.412  1.00 22.70           C  
ATOM    415  O   SER A  41      28.781  34.951  41.763  1.00 20.11           O  
ATOM    416  CB  SER A  41      26.947  37.056  43.648  0.70 22.91           C  
ATOM    418  OG  SER A  41      25.539  36.869  43.491  0.70 28.56           O  
ATOM    420  N   ARG A  42      26.627  34.417  42.082  1.00 22.35           N  
ATOM    421  CA  ARG A  42      26.445  33.579  40.911  1.00 22.60           C  
ATOM    422  C   ARG A  42      24.963  33.493  40.541  1.00 22.59           C  
ATOM    423  O   ARG A  42      24.106  33.806  41.360  1.00 22.51           O  
ATOM    424  CB  ARG A  42      26.948  32.193  41.171  1.00 23.18           C  
ATOM    425  CG  ARG A  42      26.214  31.484  42.279  1.00 22.17           C  
ATOM    426  CD  ARG A  42      26.940  30.230  42.669  1.00 27.97           C  
ATOM    427  NE  ARG A  42      28.059  30.459  43.550  1.00 26.48           N  
ATOM    428  CZ  ARG A  42      29.260  29.934  43.402  1.00 28.57           C  
ATOM    429  NH1 ARG A  42      29.559  29.188  42.354  1.00 30.43           N  
ATOM    430  NH2 ARG A  42      30.155  30.184  44.312  1.00 28.43           N  
ATOM    431  N   LEU A  43      24.690  33.062  39.317  1.00 23.62           N  
ATOM    432  CA  LEU A  43      23.293  32.952  38.802  1.00 22.42           C  
ATOM    433  C   LEU A  43      22.650  31.596  39.067  1.00 24.18           C  
ATOM    434  O   LEU A  43      21.454  31.465  38.985  1.00 21.66           O  
ATOM    435  CB  LEU A  43      23.243  33.223  37.318  1.00 24.93           C  
ATOM    436  CG  LEU A  43      23.628  34.642  36.914  1.00 24.68           C  
ATOM    437  CD1 LEU A  43      23.500  34.737  35.394  1.00 21.25           C  
ATOM    438  CD2 LEU A  43      22.781  35.676  37.711  1.00 24.43           C  
ATOM    439  N   ALA A  44      23.458  30.603  39.417  1.00 22.52           N  
ATOM    440  CA  ALA A  44      22.971  29.259  39.737  1.00 24.22           C  
ATOM    441  C   ALA A  44      23.975  28.582  40.600  1.00 21.24           C  
ATOM    442  O   ALA A  44      25.193  28.839  40.479  1.00 21.40           O  
ATOM    443  CB  ALA A  44      22.693  28.416  38.485  1.00 24.08           C  
ATOM    444  N   ALA A  45      23.502  27.687  41.443  1.00 22.85           N  
ATOM    445  CA  ALA A  45      24.368  27.073  42.455  1.00 21.12           C  
ATOM    446  C   ALA A  45      25.559  26.275  41.883  1.00 23.07           C  
ATOM    447  O   ALA A  45      26.627  26.208  42.491  1.00 24.26           O  
ATOM    448  CB  ALA A  45      23.520  26.144  43.402  1.00 22.58           C  
ATOM    449  N   ASP A  46      25.362  25.691  40.699  1.00 24.08           N  
ATOM    450  CA  ASP A  46      26.413  24.944  39.994  1.00 24.35           C  
ATOM    451  C   ASP A  46      27.028  25.713  38.835  1.00 26.98           C  
ATOM    452  O   ASP A  46      27.578  25.089  37.930  1.00 26.63           O  
ATOM    453  CB  ASP A  46      25.878  23.571  39.526  1.00 28.38           C  
ATOM    454  CG  ASP A  46      24.793  23.691  38.502  1.00 30.56           C  
ATOM    455  OD1 ASP A  46      24.414  24.831  38.216  1.00 31.73           O  
ATOM    456  OD2 ASP A  46      24.352  22.646  37.956  1.00 34.75           O  
ATOM    457  N   GLN A  47      26.887  27.055  38.825  1.00 24.92           N  
ATOM    458  CA  GLN A  47      27.558  27.916  37.850  1.00 22.94           C  
ATOM    459  C   GLN A  47      28.670  28.725  38.527  1.00 24.59           C  
ATOM    460  O   GLN A  47      28.554  29.104  39.689  1.00 24.53           O  
ATOM    461  CB  GLN A  47      26.570  28.838  37.121  1.00 26.46           C  
ATOM    462  CG  GLN A  47      27.239  29.488  35.929  1.00 27.91           C  
ATOM    463  CD  GLN A  47      26.284  30.213  34.984  1.00 30.51           C  
ATOM    464  OE1 GLN A  47      26.168  29.857  33.819  1.00 34.73           O  
ATOM    465  NE2 GLN A  47      25.673  31.233  35.456  1.00 25.69           N  
ATOM    466  N   PHE A  48      29.779  28.918  37.816  1.00 24.18           N  
ATOM    467  CA  PHE A  48      30.945  29.700  38.325  1.00 24.73           C  
ATOM    468  C   PHE A  48      30.534  31.084  38.785  1.00 24.60           C  
ATOM    469  O   PHE A  48      29.701  31.704  38.181  1.00 23.34           O  
ATOM    470  CB  PHE A  48      31.973  29.867  37.224  1.00 26.28           C  
ATOM    471  CG  PHE A  48      32.724  28.627  36.877  1.00 29.55           C  
ATOM    472  CD1 PHE A  48      33.381  27.919  37.824  1.00 33.53           C  
ATOM    473  CD2 PHE A  48      32.820  28.221  35.550  1.00 35.91           C  
ATOM    474  CE1 PHE A  48      34.103  26.814  37.486  1.00 39.95           C  
ATOM    475  CE2 PHE A  48      33.584  27.100  35.211  1.00 35.44           C  
ATOM    476  CZ  PHE A  48      34.198  26.416  36.164  1.00 34.81           C  
ATOM    477  N   ASN A  49      31.137  31.553  39.873  1.00 23.31           N  
ATOM    478  CA  ASN A  49      30.814  32.839  40.432  1.00 22.79           C  
ATOM    479  C   ASN A  49      31.490  34.007  39.672  1.00 22.20           C  
ATOM    480  O   ASN A  49      32.119  33.802  38.632  1.00 24.42           O  
ATOM    481  CB  ASN A  49      31.121  32.874  41.913  1.00 21.00           C  
ATOM    482  CG  ASN A  49      32.621  32.809  42.201  1.00 24.87           C  
ATOM    483  OD1 ASN A  49      33.448  32.967  41.300  1.00 23.95           O  
ATOM    484  ND2 ASN A  49      32.964  32.619  43.472  1.00 25.12           N  
ATOM    485  N   LEU A  50      31.281  35.227  40.143  1.00 23.74           N  
ATOM    486  CA  LEU A  50      31.689  36.404  39.394  1.00 23.56           C  
ATOM    487  C   LEU A  50      33.208  36.452  39.188  1.00 24.52           C  
ATOM    488  O   LEU A  50      33.667  36.758  38.113  1.00 23.03           O  
ATOM    489  CB  LEU A  50      31.156  37.695  40.058  1.00 23.88           C  
ATOM    490  CG  LEU A  50      31.520  39.047  39.429  1.00 26.32           C  
ATOM    491  CD1 LEU A  50      31.002  39.115  37.956  1.00 25.43           C  
ATOM    492  CD2 LEU A  50      30.891  40.143  40.281  1.00 24.99           C  
ATOM    493  N   ILE A  51      33.970  36.131  40.231  1.00 21.77           N  
ATOM    494  CA  ILE A  51      35.434  36.097  40.145  1.00 22.80           C  
ATOM    495  C   ILE A  51      35.830  35.168  38.980  1.00 24.49           C  
ATOM    496  O   ILE A  51      36.646  35.506  38.119  1.00 23.69           O  
ATOM    497  CB  ILE A  51      36.034  35.577  41.428  1.00 24.82           C  
ATOM    498  CG1 ILE A  51      35.929  36.603  42.552  1.00 27.30           C  
ATOM    499  CG2 ILE A  51      37.531  35.217  41.182  1.00 26.00           C  
ATOM    500  CD1 ILE A  51      36.042  36.014  44.010  1.00 25.31           C  
ATOM    501  N   ARG A  52      35.183  34.015  38.922  1.00 25.08           N  
ATOM    502  CA  ARG A  52      35.501  33.028  37.906  1.00 23.18           C  
ATOM    503  C   ARG A  52      35.124  33.447  36.512  1.00 23.33           C  
ATOM    504  O   ARG A  52      35.861  33.244  35.564  1.00 23.56           O  
ATOM    505  CB  ARG A  52      34.848  31.668  38.232  1.00 27.39           C  
ATOM    506  CG  ARG A  52      35.404  30.969  39.415  1.00 32.91           C  
ATOM    507  CD  ARG A  52      36.779  30.373  39.150  1.00 44.77           C  
ATOM    508  NE  ARG A  52      36.810  29.241  38.232  1.00 53.33           N  
ATOM    509  CZ  ARG A  52      37.545  29.154  37.108  1.00 54.60           C  
ATOM    510  NH1 ARG A  52      38.334  30.159  36.707  1.00 53.21           N  
ATOM    511  NH2 ARG A  52      37.508  28.025  36.379  1.00 50.10           N  
ATOM    512  N   GLN A  53      33.974  34.083  36.359  1.00 24.21           N  
ATOM    513  CA  GLN A  53      33.581  34.598  35.071  1.00 25.16           C  
ATOM    514  C   GLN A  53      34.637  35.555  34.531  1.00 26.41           C  
ATOM    515  O   GLN A  53      34.898  35.532  33.323  1.00 26.54           O  
ATOM    516  CB  GLN A  53      32.237  35.343  35.140  1.00 24.23           C  
ATOM    517  CG  GLN A  53      31.003  34.549  35.559  1.00 27.57           C  
ATOM    518  CD  GLN A  53      30.750  33.394  34.613  1.00 27.46           C  
ATOM    519  OE1 GLN A  53      30.944  33.539  33.412  1.00 28.08           O  
ATOM    520  NE2 GLN A  53      30.311  32.248  35.143  1.00 27.60           N  
ATOM    521  N   VAL A  54      35.167  36.433  35.387  1.00 24.60           N  
ATOM    522  CA  VAL A  54      36.159  37.438  34.966  1.00 24.22           C  
ATOM    523  C   VAL A  54      37.427  36.711  34.549  1.00 24.47           C  
ATOM    524  O   VAL A  54      37.997  37.010  33.491  1.00 26.07           O  
ATOM    525  CB  VAL A  54      36.420  38.483  36.055  1.00 24.48           C  
ATOM    526  CG1 VAL A  54      37.607  39.395  35.725  1.00 21.44           C  
ATOM    527  CG2 VAL A  54      35.104  39.328  36.295  1.00 25.52           C  
ATOM    528  N   GLN A  55      37.839  35.741  35.345  1.00 24.80           N  
ATOM    529  CA  GLN A  55      39.030  34.980  35.047  1.00 25.33           C  
ATOM    530  C   GLN A  55      38.899  34.250  33.701  1.00 23.03           C  
ATOM    531  O   GLN A  55      39.836  34.254  32.882  1.00 25.13           O  
ATOM    532  CB  GLN A  55      39.315  33.968  36.178  1.00 22.47           C  
ATOM    533  CG  GLN A  55      39.642  34.586  37.552  1.00 22.30           C  
ATOM    534  CD  GLN A  55      39.722  33.581  38.673  1.00 26.12           C  
ATOM    535  OE1 GLN A  55      39.054  32.564  38.635  1.00 27.08           O  
ATOM    536  NE2 GLN A  55      40.567  33.856  39.674  1.00 26.84           N  
ATOM    537  N   ILE A  56      37.734  33.666  33.460  1.00 25.77           N  
ATOM    538  CA  ILE A  56      37.492  32.920  32.220  1.00 24.84           C  
ATOM    539  C   ILE A  56      37.394  33.862  31.039  1.00 27.61           C  
ATOM    540  O   ILE A  56      37.930  33.560  29.997  1.00 26.83           O  
ATOM    541  CB  ILE A  56      36.252  32.009  32.269  1.00 23.96           C  
ATOM    542  CG1 ILE A  56      36.396  30.989  33.396  1.00 28.34           C  
ATOM    543  CG2 ILE A  56      36.140  31.252  30.931  1.00 21.99           C  
ATOM    544  CD1 ILE A  56      35.112  30.328  33.912  1.00 26.54           C  
ATOM    545  N   ALA A  57      36.757  35.016  31.208  1.00 21.75           N  
ATOM    546  CA  ALA A  57      36.778  36.036  30.156  1.00 26.16           C  
ATOM    547  C   ALA A  57      38.184  36.437  29.809  1.00 23.29           C  
ATOM    548  O   ALA A  57      38.536  36.477  28.653  1.00 22.61           O  
ATOM    549  CB  ALA A  57      35.918  37.269  30.497  1.00 23.99           C  
ATOM    550  N   CYS A  58      39.027  36.692  30.796  1.00 24.43           N  
ATOM    551  CA  CYS A  58      40.380  37.103  30.513  1.00 24.69           C  
ATOM    552  C   CYS A  58      41.161  36.000  29.776  1.00 26.79           C  
ATOM    553  O   CYS A  58      41.892  36.270  28.822  1.00 26.97           O  
ATOM    554  CB  CYS A  58      41.095  37.471  31.805  1.00 26.86           C  
ATOM    555  SG  CYS A  58      40.573  39.029  32.610  1.00 25.09           S  
ATOM    556  N   ASP A  59      41.002  34.773  30.233  1.00 25.67           N  
ATOM    557  CA  ASP A  59      41.682  33.617  29.639  1.00 26.52           C  
ATOM    558  C   ASP A  59      41.198  33.367  28.230  1.00 24.11           C  
ATOM    559  O   ASP A  59      41.978  33.078  27.343  1.00 25.27           O  
ATOM    560  CB  ASP A  59      41.473  32.358  30.478  1.00 28.35           C  
ATOM    561  CG  ASP A  59      42.415  32.252  31.648  1.00 33.28           C  
ATOM    562  OD1 ASP A  59      43.389  33.023  31.759  1.00 38.74           O  
ATOM    563  OD2 ASP A  59      42.156  31.366  32.471  1.00 40.08           O  
ATOM    564  N   THR A  60      39.911  33.575  27.993  1.00 26.09           N  
ATOM    565  CA  THR A  60      39.404  33.384  26.655  1.00 24.05           C  
ATOM    566  C   THR A  60      40.133  34.287  25.649  1.00 25.21           C  
ATOM    567  O   THR A  60      40.509  33.838  24.549  1.00 23.51           O  
ATOM    568  CB  THR A  60      37.913  33.646  26.633  1.00 24.16           C  
ATOM    569  OG1 THR A  60      37.264  32.703  27.496  1.00 24.50           O  
ATOM    570  CG2 THR A  60      37.359  33.496  25.241  1.00 27.90           C  
ATOM    571  N   ALA A  61      40.248  35.571  25.999  1.00 25.69           N  
ATOM    572  CA  ALA A  61      40.961  36.564  25.196  1.00 22.70           C  
ATOM    573  C   ALA A  61      42.431  36.205  25.058  1.00 26.59           C  
ATOM    574  O   ALA A  61      42.957  36.141  23.940  1.00 27.55           O  
ATOM    575  CB  ALA A  61      40.818  37.951  25.783  1.00 25.27           C  
ATOM    576  N   LYS A  62      43.082  35.960  26.189  1.00 26.05           N  
ATOM    577  CA  LYS A  62      44.538  35.732  26.210  1.00 27.38           C  
ATOM    578  C   LYS A  62      44.909  34.456  25.439  1.00 26.77           C  
ATOM    579  O   LYS A  62      45.726  34.490  24.521  1.00 27.01           O  
ATOM    580  CB  LYS A  62      45.041  35.617  27.653  1.00 28.19           C  
ATOM    581  CG  LYS A  62      46.562  35.338  27.756  1.00 33.57           C  
ATOM    582  CD  LYS A  62      46.971  34.937  29.158  1.00 36.54           C  
ATOM    583  CE  LYS A  62      46.441  33.555  29.557  1.00 47.29           C  
ATOM    584  NZ  LYS A  62      46.897  33.141  30.913  1.00 47.66           N  
ATOM    585  N   VAL A  63      44.296  33.336  25.824  1.00 25.27           N  
ATOM    586  CA  VAL A  63      44.600  32.036  25.220  1.00 27.10           C  
ATOM    587  C   VAL A  63      44.094  31.966  23.789  1.00 27.99           C  
ATOM    588  O   VAL A  63      44.712  31.319  22.922  1.00 30.50           O  
ATOM    589  CB  VAL A  63      44.052  30.888  26.070  1.00 27.61           C  
ATOM    590  CG1 VAL A  63      44.197  29.508  25.308  1.00 31.62           C  
ATOM    591  CG2 VAL A  63      44.722  30.883  27.462  1.00 30.86           C  
ATOM    592  N   GLY A  64      42.960  32.589  23.537  1.00 24.67           N  
ATOM    593  CA  GLY A  64      42.395  32.656  22.173  1.00 23.65           C  
ATOM    594  C   GLY A  64      43.417  33.285  21.213  1.00 27.94           C  
ATOM    595  O   GLY A  64      43.754  32.721  20.173  1.00 29.95           O  
ATOM    596  N   VAL A  65      43.941  34.434  21.588  1.00 25.91           N  
ATOM    597  CA  VAL A  65      44.952  35.125  20.778  1.00 23.26           C  
ATOM    598  C   VAL A  65      46.248  34.308  20.667  1.00 25.84           C  
ATOM    599  O   VAL A  65      46.779  34.144  19.578  1.00 25.11           O  
ATOM    600  CB  VAL A  65      45.198  36.565  21.276  1.00 24.20           C  
ATOM    601  CG1 VAL A  65      46.461  37.215  20.633  1.00 24.85           C  
ATOM    602  CG2 VAL A  65      43.894  37.446  20.965  1.00 23.30           C  
ATOM    603  N   ALA A  66      46.729  33.783  21.793  1.00 25.03           N  
ATOM    604  CA  ALA A  66      47.918  32.930  21.810  1.00 26.39           C  
ATOM    605  C   ALA A  66      47.776  31.769  20.816  1.00 27.24           C  
ATOM    606  O   ALA A  66      48.673  31.495  20.045  1.00 27.89           O  
ATOM    607  CB  ALA A  66      48.163  32.404  23.219  1.00 24.10           C  
ATOM    608  N   ARG A  67      46.632  31.112  20.853  1.00 26.99           N  
ATOM    609  CA  ARG A  67      46.332  30.002  19.963  1.00 27.03           C  
ATOM    610  C   ARG A  67      46.275  30.373  18.495  1.00 28.92           C  
ATOM    611  O   ARG A  67      46.847  29.671  17.643  1.00 28.74           O  
ATOM    612  CB  ARG A  67      45.027  29.338  20.352  1.00 28.20           C  
ATOM    613  CG  ARG A  67      45.150  28.361  21.544  1.00 27.73           C  
ATOM    614  CD  ARG A  67      43.903  27.531  21.671  1.00 37.03           C  
ATOM    615  NE  ARG A  67      43.782  26.882  22.966  1.00 35.78           N  
ATOM    616  CZ  ARG A  67      44.462  25.788  23.321  1.00 41.83           C  
ATOM    617  NH1 ARG A  67      45.323  25.226  22.484  1.00 41.69           N  
ATOM    618  NH2 ARG A  67      44.288  25.254  24.521  1.00 43.98           N  
ATOM    619  N   LEU A  68      45.595  31.466  18.178  1.00 27.18           N  
ATOM    620  CA  LEU A  68      45.470  31.881  16.809  1.00 29.68           C  
ATOM    621  C   LEU A  68      46.802  32.253  16.202  1.00 28.02           C  
ATOM    622  O   LEU A  68      47.000  32.095  14.989  1.00 28.94           O  
ATOM    623  CB  LEU A  68      44.528  33.071  16.717  1.00 28.23           C  
ATOM    624  CG  LEU A  68      43.074  32.723  16.900  1.00 35.39           C  
ATOM    625  CD1 LEU A  68      42.300  34.012  17.142  1.00 31.00           C  
ATOM    626  CD2 LEU A  68      42.526  32.009  15.685  1.00 31.41           C  
ATOM    627  N   THR A  69      47.693  32.786  17.040  1.00 28.45           N  
ATOM    628  CA  THR A  69      48.999  33.269  16.583  1.00 28.22           C  
ATOM    629  C   THR A  69      50.099  32.241  16.745  1.00 28.56           C  
ATOM    630  O   THR A  69      51.253  32.547  16.514  1.00 30.69           O  
ATOM    631  CB  THR A  69      49.444  34.546  17.341  1.00 27.24           C  
ATOM    632  OG1 THR A  69      49.559  34.270  18.743  1.00 29.56           O  
ATOM    633  CG2 THR A  69      48.456  35.697  17.090  1.00 28.14           C  
ATOM    634  N   GLY A  70      49.740  31.024  17.124  1.00 31.60           N  
ATOM    635  CA  GLY A  70      50.727  29.970  17.384  1.00 32.23           C  
ATOM    636  C   GLY A  70      51.721  30.273  18.483  1.00 33.18           C  
ATOM    637  O   GLY A  70      52.845  29.770  18.469  1.00 33.85           O  
ATOM    638  N   GLN A  71      51.329  31.085  19.453  1.00 31.61           N  
ATOM    639  CA  GLN A  71      52.210  31.440  20.556  1.00 31.67           C  
ATOM    640  C   GLN A  71      51.758  30.953  21.917  1.00 33.27           C  
ATOM    641  O   GLN A  71      52.114  31.557  22.927  1.00 36.31           O  
ATOM    642  CB  GLN A  71      52.361  32.944  20.628  1.00 32.03           C  
ATOM    643  CG  GLN A  71      52.803  33.552  19.300  1.00 40.12           C  
ATOM    644  CD  GLN A  71      53.074  35.023  19.419  1.00 46.50           C  
ATOM    645  OE1 GLN A  71      53.243  35.543  20.531  1.00 48.49           O  
ATOM    646  NE2 GLN A  71      53.117  35.720  18.274  1.00 45.45           N  
ATOM    647  N   LEU A  72      51.025  29.847  21.982  1.00 36.06           N  
ATOM    648  CA  LEU A  72      50.509  29.399  23.271  1.00 39.59           C  
ATOM    649  C   LEU A  72      51.657  29.142  24.269  1.00 43.00           C  
ATOM    650  O   LEU A  72      51.551  29.453  25.464  1.00 42.31           O  
ATOM    651  CB  LEU A  72      49.600  28.166  23.097  1.00 42.01           C  
ATOM    652  CG  LEU A  72      48.821  27.698  24.350  1.00 43.54           C  
ATOM    653  CD1 LEU A  72      47.976  28.795  24.968  1.00 45.99           C  
ATOM    654  CD2 LEU A  72      47.948  26.524  24.051  1.00 43.54           C  
ATOM    655  N   GLU A  73      52.778  28.616  23.789  1.00 44.21           N  
ATOM    656  CA  GLU A  73      53.903  28.338  24.691  1.00 47.92           C  
ATOM    657  C   GLU A  73      54.555  29.596  25.306  1.00 49.03           C  
ATOM    658  O   GLU A  73      55.125  29.521  26.408  1.00 50.73           O  
ATOM    659  CB  GLU A  73      54.943  27.430  24.011  1.00 48.44           C  
ATOM    660  CG  GLU A  73      54.444  25.976  23.771  1.00 52.95           C  
ATOM    661  CD  GLU A  73      53.377  25.509  24.780  1.00 59.64           C  
ATOM    662  N   THR A  74      54.428  30.739  24.630  1.00 48.17           N  
ATOM    663  CA  THR A  74      54.902  32.029  25.159  1.00 46.85           C  
ATOM    664  C   THR A  74      53.868  32.793  26.037  1.00 48.37           C  
ATOM    665  O   THR A  74      54.201  33.861  26.587  1.00 48.92           O  
ATOM    666  CB  THR A  74      55.343  32.960  23.998  1.00 44.96           C  
ATOM    667  N   ALA A  75      52.622  32.293  26.140  1.00 46.03           N  
ATOM    668  CA  ALA A  75      51.551  32.994  26.866  1.00 45.40           C  
ATOM    669  C   ALA A  75      51.800  33.079  28.388  1.00 47.41           C  
ATOM    670  O   ALA A  75      52.178  32.063  29.006  1.00 46.57           O  
ATOM    671  CB  ALA A  75      50.187  32.307  26.627  1.00 41.85           C  
ATOM    672  N   PRO A  76      51.550  34.268  28.999  1.00 48.60           N  
ATOM    673  CA  PRO A  76      51.601  34.394  30.470  1.00 49.28           C  
ATOM    674  C   PRO A  76      50.624  33.470  31.221  1.00 49.78           C  
ATOM    675  O   PRO A  76      49.457  33.311  30.818  1.00 50.16           O  
ATOM    676  CB  PRO A  76      51.246  35.877  30.729  1.00 50.24           C  
ATOM    677  CG  PRO A  76      50.703  36.432  29.450  1.00 48.80           C  
ATOM    678  CD  PRO A  76      51.245  35.559  28.342  1.00 49.28           C  
ATOM    679  N   LYS A  77      51.103  32.887  32.324  1.00 50.66           N  
ATOM    680  CA  LYS A  77      50.311  31.928  33.115  1.00 53.32           C  
ATOM    681  C   LYS A  77      49.705  32.580  34.363  1.00 53.10           C  
ATOM    682  O   LYS A  77      50.366  33.369  35.040  1.00 53.82           O  
ATOM    683  CB  LYS A  77      51.184  30.727  33.529  1.00 54.67           C  
ATOM    684  CG  LYS A  77      50.447  29.643  34.321  1.00 64.59           C  
ATOM    685  CD  LYS A  77      49.295  29.019  33.537  1.00 71.04           C  
ATOM    686  CE  LYS A  77      48.495  28.112  34.453  1.00 77.66           C  
ATOM    687  NZ  LYS A  77      47.345  27.467  33.759  1.00 83.31           N  
ATOM    688  N   HIS A  78      48.455  32.229  34.660  1.00 54.66           N  
ATOM    689  CA  HIS A  78      47.745  32.736  35.839  1.00 54.06           C  
ATOM    690  C   HIS A  78      47.221  31.535  36.635  1.00 54.76           C  
ATOM    691  O   HIS A  78      46.560  30.660  36.073  1.00 56.49           O  
ATOM    692  CB  HIS A  78      46.586  33.638  35.402  1.00 52.93           C  
ATOM    693  CG  HIS A  78      47.006  34.870  34.654  1.00 51.89           C  
ATOM    694  ND1 HIS A  78      46.780  35.036  33.298  1.00 54.48           N  
ATOM    695  CD2 HIS A  78      47.590  36.018  35.078  1.00 48.42           C  
ATOM    696  CE1 HIS A  78      47.215  36.229  32.916  1.00 53.55           C  
ATOM    697  NE2 HIS A  78      47.714  36.844  33.978  1.00 51.64           N  
ATOM    698  N   ASP A  79      47.523  31.486  37.932  1.00 55.25           N  
ATOM    699  CA  ASP A  79      47.030  30.410  38.814  1.00 54.81           C  
ATOM    700  C   ASP A  79      45.571  30.568  39.320  1.00 53.14           C  
ATOM    701  O   ASP A  79      45.089  29.714  40.072  1.00 55.15           O  
ATOM    702  CB  ASP A  79      47.964  30.248  40.021  1.00 56.14           C  
ATOM    703  CG  ASP A  79      47.878  31.413  41.004  1.00 65.27           C  
ATOM    704  OD1 ASP A  79      47.222  32.443  40.691  1.00 69.98           O  
ATOM    705  OD2 ASP A  79      48.479  31.289  42.103  1.00 78.00           O  
ATOM    706  N   ASP A  80      44.889  31.647  38.939  1.00 46.89           N  
ATOM    707  CA  ASP A  80      43.493  31.868  39.346  1.00 43.32           C  
ATOM    708  C   ASP A  80      43.290  32.009  40.847  1.00 41.57           C  
ATOM    709  O   ASP A  80      42.277  31.598  41.397  1.00 39.88           O  
ATOM    710  CB  ASP A  80      42.583  30.784  38.794  1.00 43.60           C  
ATOM    711  CG  ASP A  80      42.327  30.946  37.296  1.00 46.79           C  
ATOM    712  OD1 ASP A  80      42.482  32.071  36.762  1.00 46.02           O  
ATOM    713  OD2 ASP A  80      41.940  29.953  36.659  1.00 51.47           O  
ATOM    714  N   SER A  81      44.251  32.642  41.494  1.00 41.74           N  
ATOM    715  CA  SER A  81      44.220  32.810  42.943  1.00 41.86           C  
ATOM    716  C   SER A  81      43.462  34.054  43.419  1.00 39.37           C  
ATOM    717  O   SER A  81      43.383  34.296  44.627  1.00 39.62           O  
ATOM    718  CB  SER A  81      45.666  32.917  43.436  1.00 42.62           C  
ATOM    719  OG  SER A  81      46.317  34.020  42.782  1.00 50.24           O  
ATOM    720  N   GLU A  82      42.949  34.868  42.487  1.00 35.16           N  
ATOM    721  CA  GLU A  82      42.384  36.171  42.838  1.00 33.91           C  
ATOM    722  C   GLU A  82      41.155  36.031  43.716  1.00 35.09           C  
ATOM    723  O   GLU A  82      40.289  35.187  43.463  1.00 36.16           O  
ATOM    724  CB  GLU A  82      41.958  36.942  41.584  1.00 32.10           C  
ATOM    725  CG  GLU A  82      43.079  37.383  40.662  1.00 34.79           C  
ATOM    726  CD  GLU A  82      43.447  36.404  39.567  1.00 36.91           C  
ATOM    727  OE1 GLU A  82      42.944  35.278  39.568  1.00 30.52           O  
ATOM    728  OE2 GLU A  82      44.299  36.759  38.722  1.00 32.16           O  
ATOM    729  N   THR A  83      41.068  36.865  44.738  1.00 33.97           N  
ATOM    730  CA  THR A  83      39.892  36.893  45.598  1.00 35.96           C  
ATOM    731  C   THR A  83      39.312  38.288  45.760  1.00 35.61           C  
ATOM    732  O   THR A  83      38.221  38.440  46.310  1.00 36.99           O  
ATOM    733  CB  THR A  83      40.212  36.295  46.999  1.00 35.86           C  
ATOM    734  OG1 THR A  83      41.292  37.008  47.612  1.00 37.18           O  
ATOM    735  CG2 THR A  83      40.623  34.842  46.883  1.00 35.82           C  
ATOM    736  N   THR A  84      40.023  39.309  45.283  1.00 32.47           N  
ATOM    737  CA  THR A  84      39.622  40.677  45.505  1.00 28.68           C  
ATOM    738  C   THR A  84      39.474  41.424  44.203  1.00 28.52           C  
ATOM    739  O   THR A  84      39.974  40.994  43.155  1.00 28.80           O  
ATOM    740  CB  THR A  84      40.625  41.414  46.363  1.00 30.20           C  
ATOM    741  OG1 THR A  84      41.827  41.666  45.598  1.00 28.92           O  
ATOM    742  CG2 THR A  84      40.923  40.603  47.660  1.00 33.71           C  
ATOM    743  N   LEU A  85      38.734  42.525  44.261  1.00 27.46           N  
ATOM    744  CA  LEU A  85      38.538  43.366  43.073  1.00 28.72           C  
ATOM    745  C   LEU A  85      39.901  43.877  42.566  1.00 26.98           C  
ATOM    746  O   LEU A  85      40.142  43.882  41.374  1.00 24.85           O  
ATOM    747  CB  LEU A  85      37.540  44.524  43.332  1.00 26.94           C  
ATOM    748  CG  LEU A  85      37.193  45.404  42.107  1.00 29.39           C  
ATOM    749  CD1 LEU A  85      36.860  44.592  40.895  1.00 29.91           C  
ATOM    750  CD2 LEU A  85      36.045  46.352  42.406  1.00 30.53           C  
ATOM    751  N   ALA A  86      40.819  44.228  43.477  1.00 27.36           N  
ATOM    752  CA  ALA A  86      42.106  44.755  43.040  1.00 27.88           C  
ATOM    753  C   ALA A  86      42.836  43.746  42.181  1.00 27.56           C  
ATOM    754  O   ALA A  86      43.422  44.062  41.133  1.00 27.32           O  
ATOM    755  CB  ALA A  86      42.978  45.159  44.256  1.00 22.98           C  
ATOM    756  N   GLU A  87      42.781  42.503  42.630  1.00 27.92           N  
ATOM    757  CA  GLU A  87      43.478  41.444  41.966  1.00 25.66           C  
ATOM    758  C   GLU A  87      42.894  41.173  40.594  1.00 27.07           C  
ATOM    759  O   GLU A  87      43.597  40.833  39.672  1.00 30.12           O  
ATOM    760  CB  GLU A  87      43.385  40.210  42.813  1.00 26.41           C  
ATOM    761  CG  GLU A  87      44.192  40.352  44.112  1.00 33.02           C  
ATOM    762  CD  GLU A  87      44.021  39.155  45.033  1.00 34.95           C  
ATOM    763  OE1 GLU A  87      42.931  38.545  45.043  1.00 37.93           O  
ATOM    764  OE2 GLU A  87      44.992  38.835  45.745  1.00 48.40           O  
ATOM    765  N   LEU A  88      41.578  41.255  40.486  1.00 27.60           N  
ATOM    766  CA  LEU A  88      40.899  41.092  39.213  1.00 25.78           C  
ATOM    767  C   LEU A  88      41.227  42.221  38.284  1.00 26.27           C  
ATOM    768  O   LEU A  88      41.464  41.985  37.116  1.00 23.87           O  
ATOM    769  CB  LEU A  88      39.383  40.993  39.407  1.00 27.75           C  
ATOM    770  CG  LEU A  88      38.852  39.716  40.045  1.00 32.66           C  
ATOM    771  CD1 LEU A  88      37.342  39.802  40.145  1.00 29.83           C  
ATOM    772  CD2 LEU A  88      39.293  38.423  39.264  1.00 28.65           C  
ATOM    773  N   ARG A  89      41.284  43.459  38.794  1.00 26.35           N  
ATOM    774  CA  ARG A  89      41.699  44.586  37.944  1.00 27.86           C  
ATOM    775  C   ARG A  89      43.119  44.385  37.419  1.00 27.37           C  
ATOM    776  O   ARG A  89      43.404  44.717  36.268  1.00 24.36           O  
ATOM    777  CB  ARG A  89      41.680  45.891  38.702  1.00 27.30           C  
ATOM    778  CG  ARG A  89      40.358  46.225  39.277  1.00 29.73           C  
ATOM    779  CD  ARG A  89      39.639  47.240  38.487  1.00 40.13           C  
ATOM    780  NE  ARG A  89      38.738  48.063  39.310  1.00 38.49           N  
ATOM    781  CZ  ARG A  89      37.660  48.650  38.820  1.00 36.58           C  
ATOM    782  NH1 ARG A  89      37.323  48.508  37.540  1.00 36.49           N  
ATOM    783  NH2 ARG A  89      36.899  49.354  39.621  1.00 36.45           N  
ATOM    784  N   GLN A  90      43.987  43.807  38.245  1.00 27.02           N  
ATOM    785  CA  GLN A  90      45.345  43.458  37.788  1.00 29.44           C  
ATOM    786  C   GLN A  90      45.325  42.403  36.680  1.00 27.66           C  
ATOM    787  O   GLN A  90      46.048  42.522  35.713  1.00 25.50           O  
ATOM    788  CB  GLN A  90      46.201  42.979  38.938  1.00 29.51           C  
ATOM    789  CG  GLN A  90      47.639  42.586  38.514  1.00 37.81           C  
ATOM    790  CD  GLN A  90      48.415  43.740  37.901  1.00 39.34           C  
ATOM    791  OE1 GLN A  90      48.864  43.670  36.744  1.00 47.64           O  
ATOM    792  NE2 GLN A  90      48.566  44.815  38.666  1.00 31.52           N  
ATOM    793  N   ARG A  91      44.462  41.407  36.815  1.00 28.07           N  
ATOM    794  CA  ARG A  91      44.332  40.329  35.812  1.00 27.14           C  
ATOM    795  C   ARG A  91      43.923  40.905  34.461  1.00 27.05           C  
ATOM    796  O   ARG A  91      44.542  40.597  33.425  1.00 26.19           O  
ATOM    797  CB  ARG A  91      43.327  39.302  36.298  1.00 28.00           C  
ATOM    798  CG  ARG A  91      43.014  38.136  35.347  1.00 32.68           C  
ATOM    799  CD  ARG A  91      44.110  37.189  35.252  1.00 40.51           C  
ATOM    800  NE  ARG A  91      43.689  35.920  34.651  1.00 37.67           N  
ATOM    801  CZ  ARG A  91      43.316  34.830  35.331  1.00 33.31           C  
ATOM    802  NH1 ARG A  91      43.232  34.819  36.653  1.00 31.82           N  
ATOM    803  NH2 ARG A  91      43.041  33.735  34.671  1.00 34.18           N  
ATOM    804  N   ILE A  92      42.916  41.783  34.481  1.00 27.12           N  
ATOM    805  CA  ILE A  92      42.486  42.471  33.253  1.00 25.32           C  
ATOM    806  C   ILE A  92      43.603  43.280  32.664  1.00 24.07           C  
ATOM    807  O   ILE A  92      43.861  43.198  31.500  1.00 24.74           O  
ATOM    808  CB  ILE A  92      41.232  43.377  33.506  1.00 26.78           C  
ATOM    809  CG1 ILE A  92      40.040  42.514  33.911  1.00 27.70           C  
ATOM    810  CG2 ILE A  92      40.889  44.220  32.291  1.00 24.70           C  
ATOM    811  CD1 ILE A  92      38.767  43.313  34.297  1.00 26.64           C  
ATOM    812  N   ALA A  93      44.309  44.043  33.507  1.00 23.17           N  
ATOM    813  CA  ALA A  93      45.386  44.889  33.041  1.00 24.33           C  
ATOM    814  C   ALA A  93      46.492  44.075  32.342  1.00 25.38           C  
ATOM    815  O   ALA A  93      47.053  44.507  31.341  1.00 24.22           O  
ATOM    816  CB  ALA A  93      45.965  45.667  34.227  1.00 21.12           C  
ATOM    817  N   SER A  94      46.812  42.913  32.899  1.00 27.36           N  
ATOM    818  CA  SER A  94      47.855  42.040  32.367  0.50 27.06           C  
ATOM    820  C   SER A  94      47.448  41.519  30.988  1.00 26.59           C  
ATOM    821  O   SER A  94      48.239  41.488  30.032  1.00 25.85           O  
ATOM    822  CB  SER A  94      48.036  40.855  33.299  0.50 27.43           C  
ATOM    824  OG  SER A  94      48.909  39.885  32.743  0.50 37.46           O  
ATOM    826  N   VAL A  95      46.211  41.077  30.875  1.00 25.33           N  
ATOM    827  CA  VAL A  95      45.751  40.596  29.581  1.00 24.47           C  
ATOM    828  C   VAL A  95      45.756  41.719  28.577  1.00 24.30           C  
ATOM    829  O   VAL A  95      46.135  41.522  27.440  1.00 23.64           O  
ATOM    830  CB  VAL A  95      44.362  39.932  29.664  1.00 29.18           C  
ATOM    831  CG1 VAL A  95      43.877  39.550  28.252  1.00 27.03           C  
ATOM    832  CG2 VAL A  95      44.502  38.693  30.602  1.00 23.43           C  
ATOM    833  N   LEU A  96      45.360  42.915  28.991  1.00 25.96           N  
ATOM    834  CA  LEU A  96      45.384  44.063  28.091  1.00 26.63           C  
ATOM    835  C   LEU A  96      46.779  44.376  27.621  1.00 26.06           C  
ATOM    836  O   LEU A  96      46.966  44.653  26.454  1.00 24.54           O  
ATOM    837  CB  LEU A  96      44.734  45.322  28.721  1.00 26.85           C  
ATOM    838  CG  LEU A  96      43.210  45.336  28.862  1.00 26.10           C  
ATOM    839  CD1 LEU A  96      42.715  46.524  29.745  1.00 27.40           C  
ATOM    840  CD2 LEU A  96      42.499  45.307  27.476  1.00 24.00           C  
ATOM    841  N   THR A  97      47.773  44.330  28.517  1.00 25.87           N  
ATOM    842  CA  THR A  97      49.160  44.543  28.144  1.00 26.54           C  
ATOM    843  C   THR A  97      49.662  43.470  27.187  1.00 27.67           C  
ATOM    844  O   THR A  97      50.340  43.781  26.207  1.00 28.15           O  
ATOM    845  CB  THR A  97      50.071  44.576  29.405  1.00 27.48           C  
ATOM    846  OG1 THR A  97      49.599  45.590  30.296  1.00 25.69           O  
ATOM    847  CG2 THR A  97      51.529  44.852  29.070  1.00 26.42           C  
ATOM    848  N   TYR A  98      49.320  42.214  27.462  1.00 27.44           N  
ATOM    849  CA  TYR A  98      49.668  41.123  26.574  1.00 27.16           C  
ATOM    850  C   TYR A  98      49.118  41.364  25.175  1.00 27.26           C  
ATOM    851  O   TYR A  98      49.846  41.308  24.195  1.00 24.38           O  
ATOM    852  CB  TYR A  98      49.137  39.833  27.140  1.00 27.20           C  
ATOM    853  CG  TYR A  98      49.356  38.602  26.273  1.00 29.74           C  
ATOM    854  CD1 TYR A  98      50.625  38.077  26.106  1.00 32.81           C  
ATOM    855  CD2 TYR A  98      48.305  37.952  25.658  1.00 30.32           C  
ATOM    856  CE1 TYR A  98      50.837  36.933  25.332  1.00 32.49           C  
ATOM    857  CE2 TYR A  98      48.509  36.804  24.914  1.00 30.91           C  
ATOM    858  CZ  TYR A  98      49.784  36.305  24.770  1.00 31.65           C  
ATOM    859  OH  TYR A  98      50.016  35.199  24.002  1.00 38.42           O  
ATOM    860  N   LEU A  99      47.850  41.731  25.079  1.00 27.45           N  
ATOM    861  CA  LEU A  99      47.232  41.917  23.790  1.00 25.25           C  
ATOM    862  C   LEU A  99      47.851  43.080  23.014  1.00 26.02           C  
ATOM    863  O   LEU A  99      47.942  43.032  21.799  1.00 25.82           O  
ATOM    864  CB  LEU A  99      45.700  42.102  23.944  1.00 27.91           C  
ATOM    865  CG  LEU A  99      44.849  40.882  24.347  1.00 30.27           C  
ATOM    866  CD1 LEU A  99      43.331  41.281  24.368  1.00 26.69           C  
ATOM    867  CD2 LEU A  99      45.089  39.688  23.442  1.00 30.42           C  
ATOM    868  N   GLU A 100      48.267  44.125  23.713  1.00 27.90           N  
ATOM    869  CA  GLU A 100      48.974  45.260  23.084  1.00 30.37           C  
ATOM    870  C   GLU A 100      50.229  44.886  22.326  1.00 30.22           C  
ATOM    871  O   GLU A 100      50.725  45.648  21.462  1.00 32.00           O  
ATOM    872  CB  GLU A 100      49.416  46.276  24.137  1.00 32.62           C  
ATOM    873  CG  GLU A 100      48.465  47.390  24.384  1.00 43.34           C  
ATOM    874  CD  GLU A 100      48.759  48.116  25.704  1.00 52.23           C  
ATOM    875  OE1 GLU A 100      49.929  48.141  26.157  1.00 55.58           O  
ATOM    876  OE2 GLU A 100      47.797  48.641  26.308  1.00 64.60           O  
ATOM    877  N   GLY A 101      50.802  43.753  22.688  1.00 30.23           N  
ATOM    878  CA  GLY A 101      52.067  43.338  22.106  1.00 32.36           C  
ATOM    879  C   GLY A 101      51.953  42.762  20.703  1.00 32.97           C  
ATOM    880  O   GLY A 101      52.958  42.565  20.053  1.00 31.12           O  
ATOM    881  N   PHE A 102      50.732  42.492  20.246  1.00 29.64           N  
ATOM    882  CA  PHE A 102      50.495  41.860  18.952  1.00 31.34           C  
ATOM    883  C   PHE A 102      50.237  42.884  17.866  1.00 32.34           C  
ATOM    884  O   PHE A 102      49.860  44.015  18.185  1.00 33.07           O  
ATOM    885  CB  PHE A 102      49.279  40.936  19.070  1.00 30.43           C  
ATOM    886  CG  PHE A 102      49.544  39.726  19.865  1.00 27.92           C  
ATOM    887  CD1 PHE A 102      49.429  39.754  21.235  1.00 30.35           C  
ATOM    888  CD2 PHE A 102      49.950  38.537  19.240  1.00 31.26           C  
ATOM    889  CE1 PHE A 102      49.691  38.627  22.000  1.00 27.92           C  
ATOM    890  CE2 PHE A 102      50.239  37.391  19.994  1.00 34.14           C  
ATOM    891  CZ  PHE A 102      50.113  37.437  21.387  1.00 32.39           C  
ATOM    892  N   SER A 103      50.465  42.479  16.607  1.00 32.79           N  
ATOM    893  CA  SER A 103      50.113  43.236  15.399  1.00 32.58           C  
ATOM    894  C   SER A 103      49.379  42.377  14.372  1.00 31.01           C  
ATOM    895  O   SER A 103      49.338  41.156  14.508  1.00 32.00           O  
ATOM    896  CB  SER A 103      51.393  43.743  14.728  1.00 34.69           C  
ATOM    897  OG  SER A 103      52.180  42.634  14.295  1.00 40.18           O  
ATOM    898  N   GLU A 104      48.861  43.002  13.310  1.00 32.16           N  
ATOM    899  CA  GLU A 104      48.155  42.266  12.202  1.00 32.84           C  
ATOM    900  C   GLU A 104      49.007  41.127  11.703  1.00 31.21           C  
ATOM    901  O   GLU A 104      48.501  40.049  11.436  1.00 30.55           O  
ATOM    902  CB  GLU A 104      47.864  43.146  10.971  1.00 35.54           C  
ATOM    903  CG  GLU A 104      46.788  44.171  11.128  1.00 41.34           C  
ATOM    904  CD  GLU A 104      47.340  45.530  11.514  1.00 52.23           C  
ATOM    905  OE1 GLU A 104      48.390  45.587  12.221  1.00 46.40           O  
ATOM    906  OE2 GLU A 104      46.701  46.538  11.121  1.00 57.91           O  
ATOM    907  N   ALA A 105      50.307  41.396  11.555  1.00 31.94           N  
ATOM    908  CA  ALA A 105      51.262  40.419  11.004  1.00 31.00           C  
ATOM    909  C   ALA A 105      51.349  39.152  11.828  1.00 32.09           C  
ATOM    910  O   ALA A 105      51.585  38.084  11.274  1.00 27.18           O  
ATOM    911  CB  ALA A 105      52.645  41.034  10.840  1.00 30.83           C  
ATOM    912  N   ASP A 106      51.131  39.247  13.141  1.00 31.69           N  
ATOM    913  CA  ASP A 106      51.072  38.045  13.965  1.00 30.28           C  
ATOM    914  C   ASP A 106      49.967  37.090  13.574  1.00 31.12           C  
ATOM    915  O   ASP A 106      50.012  35.932  13.962  1.00 29.20           O  
ATOM    916  CB  ASP A 106      50.962  38.400  15.446  1.00 32.83           C  
ATOM    917  CG  ASP A 106      52.201  39.138  15.961  1.00 37.50           C  
ATOM    918  OD1 ASP A 106      53.324  38.811  15.528  1.00 38.84           O  
ATOM    919  OD2 ASP A 106      52.063  40.060  16.779  1.00 40.02           O  
ATOM    920  N   PHE A 107      48.961  37.578  12.843  1.00 27.71           N  
ATOM    921  CA  PHE A 107      47.839  36.769  12.408  1.00 28.70           C  
ATOM    922  C   PHE A 107      47.924  36.265  10.964  1.00 29.79           C  
ATOM    923  O   PHE A 107      46.947  35.763  10.406  1.00 27.84           O  
ATOM    924  CB  PHE A 107      46.515  37.533  12.610  1.00 27.94           C  
ATOM    925  CG  PHE A 107      46.113  37.671  14.042  1.00 23.80           C  
ATOM    926  CD1 PHE A 107      46.785  38.546  14.879  1.00 21.87           C  
ATOM    927  CD2 PHE A 107      45.089  36.899  14.567  1.00 24.69           C  
ATOM    928  CE1 PHE A 107      46.437  38.687  16.214  1.00 30.72           C  
ATOM    929  CE2 PHE A 107      44.700  37.044  15.894  1.00 26.76           C  
ATOM    930  CZ  PHE A 107      45.387  37.943  16.735  1.00 29.84           C  
ATOM    931  N   ALA A 108      49.110  36.336  10.382  1.00 30.79           N  
ATOM    932  CA  ALA A 108      49.282  36.018   8.954  1.00 31.52           C  
ATOM    933  C   ALA A 108      48.728  34.677   8.557  1.00 31.58           C  
ATOM    934  O   ALA A 108      48.144  34.548   7.483  1.00 33.10           O  
ATOM    935  CB  ALA A 108      50.767  36.096   8.576  1.00 31.36           C  
ATOM    936  N   ASN A 109      48.928  33.686   9.413  1.00 30.92           N  
ATOM    937  CA  ASN A 109      48.426  32.355   9.170  1.00 34.09           C  
ATOM    938  C   ASN A 109      47.347  31.871  10.163  1.00 31.26           C  
ATOM    939  O   ASN A 109      47.012  30.692  10.189  1.00 31.00           O  
ATOM    940  CB  ASN A 109      49.588  31.399   9.211  1.00 37.28           C  
ATOM    941  CG  ASN A 109      50.631  31.736   8.173  1.00 41.63           C  
ATOM    942  OD1 ASN A 109      50.343  31.717   6.981  1.00 43.56           O  
ATOM    943  ND2 ASN A 109      51.841  32.062   8.627  1.00 42.74           N  
ATOM    944  N   ALA A 110      46.791  32.795  10.931  1.00 31.21           N  
ATOM    945  CA  ALA A 110      45.742  32.498  11.893  1.00 29.02           C  
ATOM    946  C   ALA A 110      44.531  31.824  11.276  1.00 30.17           C  
ATOM    947  O   ALA A 110      43.929  30.973  11.912  1.00 31.19           O  
ATOM    948  CB  ALA A 110      45.321  33.751  12.613  1.00 25.85           C  
ATOM    949  N   ALA A 111      44.133  32.205  10.060  1.00 31.71           N  
ATOM    950  CA  ALA A 111      42.883  31.691   9.500  1.00 29.96           C  
ATOM    951  C   ALA A 111      42.976  30.183   9.331  1.00 27.40           C  
ATOM    952  O   ALA A 111      41.998  29.476   9.505  1.00 27.19           O  
ATOM    953  CB  ALA A 111      42.558  32.370   8.146  1.00 30.84           C  
ATOM    954  N   THR A 112      44.166  29.702   8.990  1.00 29.91           N  
ATOM    955  CA  THR A 112      44.316  28.295   8.638  1.00 29.71           C  
ATOM    956  C   THR A 112      45.029  27.446   9.691  1.00 31.73           C  
ATOM    957  O   THR A 112      45.078  26.229   9.564  1.00 33.49           O  
ATOM    958  CB  THR A 112      45.020  28.118   7.281  1.00 32.01           C  
ATOM    959  OG1 THR A 112      46.318  28.695   7.359  1.00 34.60           O  
ATOM    960  CG2 THR A 112      44.211  28.763   6.164  1.00 36.17           C  
ATOM    961  N   ILE A 113      45.536  28.063  10.736  1.00 31.13           N  
ATOM    962  CA  ILE A 113      46.200  27.319  11.787  1.00 26.98           C  
ATOM    963  C   ILE A 113      45.232  26.254  12.337  1.00 29.91           C  
ATOM    964  O   ILE A 113      44.028  26.460  12.400  1.00 28.01           O  
ATOM    965  CB  ILE A 113      46.773  28.264  12.929  1.00 28.04           C  
ATOM    966  CG1 ILE A 113      47.687  27.460  13.889  1.00 30.79           C  
ATOM    967  CG2 ILE A 113      45.629  29.050  13.655  1.00 24.89           C  
ATOM    968  CD1 ILE A 113      48.603  28.320  14.823  1.00 28.06           C  
ATOM    969  N   GLN A 114      45.762  25.082  12.710  1.00 27.75           N  
ATOM    970  CA  GLN A 114      44.944  24.002  13.278  1.00 29.01           C  
ATOM    971  C   GLN A 114      44.955  24.081  14.787  1.00 29.50           C  
ATOM    972  O   GLN A 114      46.002  23.961  15.402  1.00 33.28           O  
ATOM    973  CB  GLN A 114      45.440  22.622  12.847  1.00 32.77           C  
ATOM    974  CG  GLN A 114      45.231  22.366  11.379  1.00 31.65           C  
ATOM    975  CD  GLN A 114      45.579  20.904  10.976  1.00 37.90           C  
ATOM    976  OE1 GLN A 114      46.016  20.086  11.798  1.00 46.44           O  
ATOM    977  NE2 GLN A 114      45.387  20.599   9.713  1.00 41.02           N  
ATOM    978  N   ILE A 115      43.784  24.324  15.362  1.00 29.51           N  
ATOM    979  CA  ILE A 115      43.635  24.457  16.811  1.00 29.74           C  
ATOM    980  C   ILE A 115      43.001  23.167  17.334  1.00 30.79           C  
ATOM    981  O   ILE A 115      41.890  22.789  16.916  1.00 28.90           O  
ATOM    982  CB  ILE A 115      42.725  25.655  17.178  1.00 32.24           C  
ATOM    983  CG1 ILE A 115      43.201  26.960  16.504  1.00 35.80           C  
ATOM    984  CG2 ILE A 115      42.605  25.840  18.724  1.00 32.35           C  
ATOM    985  CD1 ILE A 115      44.343  27.554  17.100  1.00 33.55           C  
ATOM    986  N   SER A 116      43.675  22.527  18.270  1.00 33.47           N  
ATOM    987  CA  SER A 116      43.149  21.326  18.903  1.00 37.66           C  
ATOM    988  C   SER A 116      43.392  21.425  20.394  1.00 39.54           C  
ATOM    989  O   SER A 116      44.524  21.380  20.831  1.00 40.64           O  
ATOM    990  CB  SER A 116      43.808  20.082  18.344  1.00 37.68           C  
ATOM    991  OG  SER A 116      43.208  18.897  18.859  1.00 39.21           O  
ATOM    992  N   GLN A 117      42.331  21.561  21.173  1.00 41.09           N  
ATOM    993  CA  GLN A 117      42.458  21.613  22.635  1.00 44.71           C  
ATOM    994  C   GLN A 117      42.675  20.221  23.222  1.00 44.96           C  
ATOM    995  O   GLN A 117      42.383  19.211  22.597  1.00 39.54           O  
ATOM    996  CB  GLN A 117      41.254  22.328  23.257  1.00 44.65           C  
ATOM    997  CG  GLN A 117      41.082  23.781  22.720  1.00 46.54           C  
ATOM    998  CD  GLN A 117      39.957  24.601  23.368  1.00 48.76           C  
ATOM    999  OE1 GLN A 117      39.116  24.092  24.106  1.00 55.25           O  
ATOM   1000  NE2 GLN A 117      39.936  25.880  23.062  1.00 52.24           N  
ATOM   1001  N   PRO A 118      43.204  20.159  24.446  1.00 49.93           N  
ATOM   1002  CA  PRO A 118      43.564  18.842  25.033  1.00 49.79           C  
ATOM   1003  C   PRO A 118      42.427  17.828  25.132  1.00 48.23           C  
ATOM   1004  O   PRO A 118      42.686  16.643  25.106  1.00 47.61           O  
ATOM   1005  CB  PRO A 118      44.044  19.201  26.455  1.00 51.68           C  
ATOM   1006  CG  PRO A 118      44.463  20.656  26.364  1.00 51.93           C  
ATOM   1007  CD  PRO A 118      43.519  21.282  25.358  1.00 50.72           C  
ATOM   1008  N   ARG A 119      41.188  18.286  25.232  1.00 46.52           N  
ATOM   1009  CA  ARG A 119      40.056  17.373  25.358  1.00 45.99           C  
ATOM   1010  C   ARG A 119      39.348  17.025  24.041  1.00 43.06           C  
ATOM   1011  O   ARG A 119      38.281  16.457  24.067  1.00 37.91           O  
ATOM   1012  CB  ARG A 119      39.044  17.994  26.309  1.00 47.91           C  
ATOM   1013  CG  ARG A 119      39.461  17.896  27.775  1.00 57.72           C  
ATOM   1014  CD  ARG A 119      38.692  18.889  28.636  1.00 70.94           C  
ATOM   1015  NE  ARG A 119      38.993  18.776  30.065  1.00 76.85           N  
ATOM   1016  CZ  ARG A 119      40.161  19.087  30.634  1.00 85.88           C  
ATOM   1017  NH1 ARG A 119      41.205  19.520  29.920  1.00 87.22           N  
ATOM   1018  NH2 ARG A 119      40.292  18.954  31.947  1.00 89.55           N  
ATOM   1019  N   TRP A 120      39.932  17.377  22.904  1.00 39.89           N  
ATOM   1020  CA  TRP A 120      39.307  17.144  21.603  1.00 38.99           C  
ATOM   1021  C   TRP A 120      39.811  15.916  20.872  1.00 38.81           C  
ATOM   1022  O   TRP A 120      39.464  15.723  19.708  1.00 35.84           O  
ATOM   1023  CB  TRP A 120      39.522  18.357  20.693  1.00 39.71           C  
ATOM   1024  CG  TRP A 120      38.834  19.602  21.138  1.00 38.67           C  
ATOM   1025  CD1 TRP A 120      38.029  19.765  22.243  1.00 40.12           C  
ATOM   1026  CD2 TRP A 120      38.859  20.852  20.475  1.00 34.24           C  
ATOM   1027  NE1 TRP A 120      37.565  21.046  22.306  1.00 40.79           N  
ATOM   1028  CE2 TRP A 120      38.068  21.748  21.242  1.00 41.23           C  
ATOM   1029  CE3 TRP A 120      39.503  21.330  19.324  1.00 37.11           C  
ATOM   1030  CZ2 TRP A 120      37.904  23.083  20.885  1.00 36.76           C  
ATOM   1031  CZ3 TRP A 120      39.335  22.651  18.963  1.00 38.24           C  
ATOM   1032  CH2 TRP A 120      38.538  23.523  19.751  1.00 39.01           C  
ATOM   1033  N   GLN A 121      40.630  15.098  21.547  1.00 37.21           N  
ATOM   1034  CA  GLN A 121      41.140  13.861  20.999  1.00 37.89           C  
ATOM   1035  C   GLN A 121      41.788  14.024  19.621  1.00 36.35           C  
ATOM   1036  O   GLN A 121      41.676  13.171  18.754  1.00 29.79           O  
ATOM   1037  CB  GLN A 121      40.047  12.779  21.006  1.00 38.68           C  
ATOM   1038  CG  GLN A 121      39.473  12.439  22.423  1.00 35.06           C  
ATOM   1039  CD  GLN A 121      38.281  13.357  22.862  1.00 47.09           C  
ATOM   1040  OE1 GLN A 121      37.602  13.980  22.031  1.00 33.75           O  
ATOM   1041  NE2 GLN A 121      38.044  13.437  24.180  1.00 46.38           N  
ATOM   1042  N   GLY A 122      42.524  15.114  19.444  1.00 37.91           N  
ATOM   1043  CA  GLY A 122      43.285  15.353  18.223  1.00 35.58           C  
ATOM   1044  C   GLY A 122      42.475  16.030  17.142  1.00 34.64           C  
ATOM   1045  O   GLY A 122      42.998  16.413  16.124  1.00 35.91           O  
ATOM   1046  N   LYS A 123      41.194  16.211  17.359  1.00 31.84           N  
ATOM   1047  CA  LYS A 123      40.387  16.860  16.348  1.00 32.64           C  
ATOM   1048  C   LYS A 123      40.692  18.363  16.379  1.00 31.87           C  
ATOM   1049  O   LYS A 123      41.110  18.887  17.412  1.00 31.26           O  
ATOM   1050  CB  LYS A 123      38.913  16.620  16.598  1.00 35.98           C  
ATOM   1051  CG  LYS A 123      38.499  15.157  16.606  1.00 36.38           C  
ATOM   1052  CD  LYS A 123      36.982  15.013  16.647  1.00 33.82           C  
ATOM   1053  CE  LYS A 123      36.411  15.419  18.002  1.00 36.37           C  
ATOM   1054  NZ  LYS A 123      36.934  14.600  19.133  1.00 26.92           N  
ATOM   1055  N   TYR A 124      40.513  19.037  15.251  1.00 30.97           N  
ATOM   1056  CA  TYR A 124      40.866  20.458  15.161  1.00 28.02           C  
ATOM   1057  C   TYR A 124      39.786  21.287  14.517  1.00 27.49           C  
ATOM   1058  O   TYR A 124      38.903  20.781  13.797  1.00 27.39           O  
ATOM   1059  CB  TYR A 124      42.202  20.646  14.443  1.00 32.11           C  
ATOM   1060  CG  TYR A 124      42.109  20.523  12.938  1.00 29.95           C  
ATOM   1061  CD1 TYR A 124      42.237  19.286  12.322  1.00 29.30           C  
ATOM   1062  CD2 TYR A 124      41.880  21.634  12.137  1.00 34.85           C  
ATOM   1063  CE1 TYR A 124      42.129  19.152  10.949  1.00 33.70           C  
ATOM   1064  CE2 TYR A 124      41.780  21.505  10.761  1.00 32.70           C  
ATOM   1065  CZ  TYR A 124      41.904  20.261  10.174  1.00 33.98           C  
ATOM   1066  OH  TYR A 124      41.789  20.110   8.820  1.00 32.71           O  
ATOM   1067  N   LEU A 125      39.886  22.596  14.775  1.00 26.00           N  
ATOM   1068  CA  LEU A 125      39.163  23.634  14.026  1.00 26.80           C  
ATOM   1069  C   LEU A 125      40.230  24.514  13.398  1.00 26.00           C  
ATOM   1070  O   LEU A 125      41.297  24.650  13.933  1.00 26.27           O  
ATOM   1071  CB  LEU A 125      38.351  24.509  14.991  1.00 27.16           C  
ATOM   1072  CG  LEU A 125      37.285  23.839  15.854  1.00 31.01           C  
ATOM   1073  CD1 LEU A 125      36.579  24.859  16.831  1.00 24.56           C  
ATOM   1074  CD2 LEU A 125      36.304  23.120  14.959  1.00 28.13           C  
ATOM   1075  N   THR A 126      39.938  25.152  12.283  1.00 26.72           N  
ATOM   1076  CA  THR A 126      40.865  26.128  11.782  1.00 24.63           C  
ATOM   1077  C   THR A 126      40.775  27.361  12.715  1.00 26.59           C  
ATOM   1078  O   THR A 126      39.806  27.518  13.472  1.00 24.78           O  
ATOM   1079  CB  THR A 126      40.464  26.601  10.400  1.00 26.94           C  
ATOM   1080  OG1 THR A 126      39.185  27.260  10.476  1.00 25.39           O  
ATOM   1081  CG2 THR A 126      40.404  25.416   9.392  1.00 26.07           C  
ATOM   1082  N   GLY A 127      41.766  28.234  12.642  1.00 26.34           N  
ATOM   1083  CA  GLY A 127      41.773  29.384  13.493  1.00 25.40           C  
ATOM   1084  C   GLY A 127      40.571  30.273  13.227  1.00 24.59           C  
ATOM   1085  O   GLY A 127      40.017  30.858  14.132  1.00 25.84           O  
ATOM   1086  N   TYR A 128      40.149  30.317  11.990  1.00 26.75           N  
ATOM   1087  CA  TYR A 128      39.033  31.140  11.557  1.00 26.72           C  
ATOM   1088  C   TYR A 128      37.738  30.612  12.180  1.00 28.05           C  
ATOM   1089  O   TYR A 128      36.974  31.359  12.792  1.00 26.79           O  
ATOM   1090  CB  TYR A 128      38.961  31.048  10.050  1.00 28.34           C  
ATOM   1091  CG  TYR A 128      37.861  31.798   9.418  1.00 26.87           C  
ATOM   1092  CD1 TYR A 128      37.939  33.183   9.306  1.00 28.82           C  
ATOM   1093  CD2 TYR A 128      36.760  31.151   8.876  1.00 30.24           C  
ATOM   1094  CE1 TYR A 128      36.934  33.904   8.712  1.00 25.27           C  
ATOM   1095  CE2 TYR A 128      35.779  31.863   8.252  1.00 26.87           C  
ATOM   1096  CZ  TYR A 128      35.878  33.250   8.174  1.00 27.00           C  
ATOM   1097  OH  TYR A 128      34.891  33.964   7.572  1.00 26.22           O  
ATOM   1098  N   GLU A 129      37.528  29.312  12.056  1.00 27.03           N  
ATOM   1099  CA  GLU A 129      36.417  28.623  12.742  1.00 27.19           C  
ATOM   1100  C   GLU A 129      36.455  28.789  14.264  1.00 25.07           C  
ATOM   1101  O   GLU A 129      35.433  28.987  14.889  1.00 24.45           O  
ATOM   1102  CB  GLU A 129      36.463  27.151  12.436  1.00 26.54           C  
ATOM   1103  CG  GLU A 129      36.114  26.831  11.005  1.00 30.45           C  
ATOM   1104  CD  GLU A 129      36.443  25.384  10.638  1.00 31.02           C  
ATOM   1105  OE1 GLU A 129      37.223  24.709  11.359  1.00 27.22           O  
ATOM   1106  OE2 GLU A 129      35.906  24.926   9.610  1.00 36.54           O  
ATOM   1107  N   PHE A 130      37.632  28.630  14.853  1.00 23.47           N  
ATOM   1108  CA  PHE A 130      37.792  28.755  16.283  1.00 23.13           C  
ATOM   1109  C   PHE A 130      37.407  30.141  16.770  1.00 26.22           C  
ATOM   1110  O   PHE A 130      36.672  30.281  17.736  1.00 27.57           O  
ATOM   1111  CB  PHE A 130      39.227  28.382  16.642  1.00 26.40           C  
ATOM   1112  CG  PHE A 130      39.581  28.582  18.104  1.00 26.28           C  
ATOM   1113  CD1 PHE A 130      39.141  27.678  19.059  1.00 28.19           C  
ATOM   1114  CD2 PHE A 130      40.307  29.688  18.506  1.00 30.07           C  
ATOM   1115  CE1 PHE A 130      39.427  27.860  20.393  1.00 33.46           C  
ATOM   1116  CE2 PHE A 130      40.609  29.870  19.835  1.00 30.59           C  
ATOM   1117  CZ  PHE A 130      40.157  28.954  20.776  1.00 31.17           C  
ATOM   1118  N   ALA A 131      37.861  31.175  16.061  1.00 23.33           N  
ATOM   1119  CA  ALA A 131      37.516  32.556  16.398  1.00 22.32           C  
ATOM   1120  C   ALA A 131      36.001  32.721  16.408  1.00 24.76           C  
ATOM   1121  O   ALA A 131      35.402  33.171  17.388  1.00 25.51           O  
ATOM   1122  CB  ALA A 131      38.168  33.548  15.400  1.00 22.03           C  
ATOM   1123  N   ILE A 132      35.389  32.315  15.305  1.00 24.02           N  
ATOM   1124  CA  ILE A 132      33.989  32.630  15.051  1.00 25.57           C  
ATOM   1125  C   ILE A 132      33.040  31.829  15.928  1.00 24.83           C  
ATOM   1126  O   ILE A 132      32.055  32.387  16.456  1.00 25.55           O  
ATOM   1127  CB  ILE A 132      33.674  32.457  13.574  1.00 24.88           C  
ATOM   1128  CG1 ILE A 132      34.470  33.505  12.762  1.00 30.01           C  
ATOM   1129  CG2 ILE A 132      32.156  32.539  13.318  1.00 28.35           C  
ATOM   1130  CD1 ILE A 132      34.078  33.566  11.223  1.00 27.53           C  
ATOM   1131  N   GLU A 133      33.349  30.537  16.081  1.00 25.65           N  
ATOM   1132  CA  GLU A 133      32.426  29.588  16.684  1.00 25.28           C  
ATOM   1133  C   GLU A 133      32.739  29.282  18.127  1.00 24.62           C  
ATOM   1134  O   GLU A 133      31.871  28.759  18.818  1.00 25.49           O  
ATOM   1135  CB  GLU A 133      32.326  28.277  15.843  1.00 27.02           C  
ATOM   1136  CG  GLU A 133      31.928  28.568  14.377  1.00 27.00           C  
ATOM   1137  CD  GLU A 133      31.554  27.313  13.584  1.00 31.27           C  
ATOM   1138  OE1 GLU A 133      30.839  26.454  14.115  1.00 28.89           O  
ATOM   1139  OE2 GLU A 133      32.008  27.223  12.439  1.00 32.39           O  
ATOM   1140  N   HIS A 134      33.956  29.582  18.570  1.00 23.85           N  
ATOM   1141  CA  HIS A 134      34.393  29.189  19.897  1.00 25.24           C  
ATOM   1142  C   HIS A 134      34.817  30.400  20.776  1.00 25.64           C  
ATOM   1143  O   HIS A 134      34.072  30.784  21.713  1.00 24.60           O  
ATOM   1144  CB  HIS A 134      35.518  28.163  19.811  1.00 27.81           C  
ATOM   1145  CG  HIS A 134      35.688  27.335  21.057  1.00 27.09           C  
ATOM   1146  ND1 HIS A 134      36.439  27.750  22.148  1.00 32.02           N  
ATOM   1147  CD2 HIS A 134      35.212  26.109  21.383  1.00 31.03           C  
ATOM   1148  CE1 HIS A 134      36.384  26.827  23.091  1.00 34.66           C  
ATOM   1149  NE2 HIS A 134      35.649  25.821  22.652  1.00 38.16           N  
ATOM   1150  N   ALA A 135      35.944  31.026  20.419  1.00 24.82           N  
ATOM   1151  CA  ALA A 135      36.511  32.124  21.179  1.00 26.38           C  
ATOM   1152  C   ALA A 135      35.573  33.319  21.275  1.00 21.11           C  
ATOM   1153  O   ALA A 135      35.349  33.849  22.368  1.00 22.93           O  
ATOM   1154  CB  ALA A 135      37.905  32.575  20.614  1.00 23.00           C  
ATOM   1155  N   ILE A 136      35.010  33.783  20.165  1.00 26.68           N  
ATOM   1156  CA  ILE A 136      34.147  34.949  20.252  1.00 24.09           C  
ATOM   1157  C   ILE A 136      32.886  34.696  21.109  1.00 23.65           C  
ATOM   1158  O   ILE A 136      32.573  35.441  22.027  1.00 24.15           O  
ATOM   1159  CB  ILE A 136      33.813  35.555  18.849  1.00 23.35           C  
ATOM   1160  CG1 ILE A 136      35.093  36.178  18.226  1.00 27.10           C  
ATOM   1161  CG2 ILE A 136      32.763  36.624  18.996  1.00 26.29           C  
ATOM   1162  CD1 ILE A 136      35.036  36.521  16.697  1.00 25.23           C  
ATOM   1163  N   PRO A 137      32.124  33.636  20.808  1.00 26.68           N  
ATOM   1164  CA  PRO A 137      30.948  33.368  21.686  1.00 23.73           C  
ATOM   1165  C   PRO A 137      31.275  33.238  23.129  1.00 25.35           C  
ATOM   1166  O   PRO A 137      30.511  33.696  23.952  1.00 24.40           O  
ATOM   1167  CB  PRO A 137      30.398  32.049  21.149  1.00 24.21           C  
ATOM   1168  CG  PRO A 137      30.820  32.064  19.669  1.00 26.35           C  
ATOM   1169  CD  PRO A 137      32.163  32.757  19.623  1.00 28.20           C  
ATOM   1170  N   ASN A 138      32.405  32.609  23.454  1.00 21.82           N  
ATOM   1171  CA  ASN A 138      32.774  32.407  24.826  1.00 23.85           C  
ATOM   1172  C   ASN A 138      33.137  33.710  25.557  1.00 24.75           C  
ATOM   1173  O   ASN A 138      32.790  33.918  26.738  1.00 24.70           O  
ATOM   1174  CB  ASN A 138      33.966  31.440  24.902  1.00 25.19           C  
ATOM   1175  CG  ASN A 138      33.545  29.955  25.034  1.00 24.29           C  
ATOM   1176  OD1 ASN A 138      32.509  29.653  25.577  1.00 30.42           O  
ATOM   1177  ND2 ASN A 138      34.380  29.045  24.515  1.00 26.39           N  
ATOM   1178  N   LEU A 139      33.860  34.573  24.890  1.00 24.49           N  
ATOM   1179  CA  LEU A 139      34.235  35.850  25.487  1.00 24.91           C  
ATOM   1180  C   LEU A 139      32.973  36.617  25.859  1.00 22.76           C  
ATOM   1181  O   LEU A 139      32.841  37.096  26.981  1.00 24.25           O  
ATOM   1182  CB  LEU A 139      35.063  36.680  24.495  1.00 26.54           C  
ATOM   1183  CG  LEU A 139      35.762  37.994  24.872  1.00 27.06           C  
ATOM   1184  CD1 LEU A 139      34.819  39.119  24.662  1.00 25.21           C  
ATOM   1185  CD2 LEU A 139      36.361  37.987  26.213  1.00 30.42           C  
ATOM   1186  N   TYR A 140      32.021  36.707  24.934  1.00 23.35           N  
ATOM   1187  CA  TYR A 140      30.774  37.444  25.218  1.00 23.00           C  
ATOM   1188  C   TYR A 140      29.880  36.743  26.270  1.00 24.50           C  
ATOM   1189  O   TYR A 140      29.190  37.408  27.036  1.00 25.12           O  
ATOM   1190  CB  TYR A 140      29.987  37.750  23.938  1.00 26.03           C  
ATOM   1191  CG  TYR A 140      30.675  38.838  23.124  1.00 22.67           C  
ATOM   1192  CD1 TYR A 140      30.836  40.106  23.625  1.00 24.00           C  
ATOM   1193  CD2 TYR A 140      31.287  38.554  21.901  1.00 25.41           C  
ATOM   1194  CE1 TYR A 140      31.516  41.090  22.924  1.00 25.25           C  
ATOM   1195  CE2 TYR A 140      31.958  39.558  21.187  1.00 24.43           C  
ATOM   1196  CZ  TYR A 140      32.090  40.812  21.708  1.00 25.11           C  
ATOM   1197  OH  TYR A 140      32.717  41.826  20.965  1.00 23.71           O  
ATOM   1198  N   PHE A 141      29.846  35.406  26.250  1.00 21.23           N  
ATOM   1199  CA  PHE A 141      29.172  34.626  27.272  1.00 24.21           C  
ATOM   1200  C   PHE A 141      29.645  35.001  28.682  1.00 21.01           C  
ATOM   1201  O   PHE A 141      28.828  35.273  29.572  1.00 23.68           O  
ATOM   1202  CB  PHE A 141      29.411  33.139  27.063  1.00 20.99           C  
ATOM   1203  CG  PHE A 141      28.665  32.273  28.065  1.00 22.98           C  
ATOM   1204  CD1 PHE A 141      29.245  31.967  29.304  1.00 24.16           C  
ATOM   1205  CD2 PHE A 141      27.415  31.770  27.809  1.00 21.77           C  
ATOM   1206  CE1 PHE A 141      28.579  31.200  30.273  1.00 25.59           C  
ATOM   1207  CE2 PHE A 141      26.742  30.992  28.783  1.00 24.67           C  
ATOM   1208  CZ  PHE A 141      27.368  30.717  30.032  1.00 28.91           C  
ATOM   1209  N   HIS A 142      30.956  34.982  28.906  1.00 24.38           N  
ATOM   1210  CA  HIS A 142      31.423  35.201  30.242  1.00 23.48           C  
ATOM   1211  C   HIS A 142      31.369  36.664  30.710  1.00 22.22           C  
ATOM   1212  O   HIS A 142      31.059  36.911  31.887  1.00 23.93           O  
ATOM   1213  CB  HIS A 142      32.773  34.559  30.422  1.00 22.82           C  
ATOM   1214  CG  HIS A 142      32.717  33.068  30.329  1.00 23.51           C  
ATOM   1215  ND1 HIS A 142      32.259  32.291  31.374  1.00 24.84           N  
ATOM   1216  CD2 HIS A 142      32.974  32.218  29.302  1.00 25.26           C  
ATOM   1217  CE1 HIS A 142      32.288  31.018  31.003  1.00 26.54           C  
ATOM   1218  NE2 HIS A 142      32.720  30.947  29.755  1.00 25.28           N  
ATOM   1219  N   ILE A 143      31.596  37.613  29.809  1.00 22.65           N  
ATOM   1220  CA  ILE A 143      31.370  39.015  30.122  1.00 23.13           C  
ATOM   1221  C   ILE A 143      29.873  39.317  30.389  1.00 22.74           C  
ATOM   1222  O   ILE A 143      29.514  39.982  31.369  1.00 22.84           O  
ATOM   1223  CB  ILE A 143      31.939  39.955  29.060  1.00 23.60           C  
ATOM   1224  CG1 ILE A 143      33.485  39.867  28.977  1.00 25.35           C  
ATOM   1225  CG2 ILE A 143      31.547  41.410  29.388  1.00 19.90           C  
ATOM   1226  CD1 ILE A 143      34.148  40.874  28.031  1.00 24.38           C  
ATOM   1227  N   THR A 144      28.983  38.795  29.564  1.00 21.11           N  
ATOM   1228  CA  THR A 144      27.554  38.941  29.818  1.00 22.27           C  
ATOM   1229  C   THR A 144      27.095  38.304  31.131  1.00 23.89           C  
ATOM   1230  O   THR A 144      26.230  38.840  31.788  1.00 23.34           O  
ATOM   1231  CB  THR A 144      26.689  38.489  28.613  1.00 24.03           C  
ATOM   1232  OG1 THR A 144      27.120  39.216  27.449  1.00 24.13           O  
ATOM   1233  CG2 THR A 144      25.184  38.797  28.814  1.00 21.38           C  
ATOM   1234  N   THR A 145      27.639  37.154  31.485  1.00 22.32           N  
ATOM   1235  CA  THR A 145      27.253  36.476  32.696  1.00 22.74           C  
ATOM   1236  C   THR A 145      27.776  37.267  33.879  1.00 22.86           C  
ATOM   1237  O   THR A 145      27.073  37.399  34.850  1.00 22.76           O  
ATOM   1238  CB  THR A 145      27.793  35.032  32.722  1.00 25.26           C  
ATOM   1239  OG1 THR A 145      27.265  34.320  31.601  1.00 23.83           O  
ATOM   1240  CG2 THR A 145      27.358  34.304  34.021  1.00 24.60           C  
ATOM   1241  N   ALA A 146      28.987  37.843  33.784  1.00 24.48           N  
ATOM   1242  CA  ALA A 146      29.518  38.724  34.837  1.00 22.19           C  
ATOM   1243  C   ALA A 146      28.579  39.917  35.015  1.00 22.58           C  
ATOM   1244  O   ALA A 146      28.222  40.278  36.128  1.00 22.03           O  
ATOM   1245  CB  ALA A 146      30.919  39.205  34.482  1.00 21.57           C  
ATOM   1246  N   TYR A 147      28.193  40.525  33.897  1.00 21.82           N  
ATOM   1247  CA  TYR A 147      27.257  41.608  33.914  1.00 20.46           C  
ATOM   1248  C   TYR A 147      25.944  41.222  34.585  1.00 23.00           C  
ATOM   1249  O   TYR A 147      25.433  41.944  35.419  1.00 21.20           O  
ATOM   1250  CB  TYR A 147      27.038  42.045  32.486  1.00 21.69           C  
ATOM   1251  CG  TYR A 147      26.017  43.107  32.207  1.00 24.43           C  
ATOM   1252  CD1 TYR A 147      24.646  42.817  32.241  1.00 25.86           C  
ATOM   1253  CD2 TYR A 147      26.414  44.425  31.803  1.00 24.13           C  
ATOM   1254  CE1 TYR A 147      23.715  43.810  31.994  1.00 21.73           C  
ATOM   1255  CE2 TYR A 147      25.484  45.370  31.486  1.00 26.74           C  
ATOM   1256  CZ  TYR A 147      24.141  45.066  31.565  1.00 26.07           C  
ATOM   1257  OH  TYR A 147      23.226  46.029  31.208  1.00 27.12           O  
ATOM   1258  N   GLY A 148      25.389  40.068  34.205  1.00 22.52           N  
ATOM   1259  CA  GLY A 148      24.150  39.558  34.775  1.00 19.50           C  
ATOM   1260  C   GLY A 148      24.181  39.337  36.282  1.00 19.66           C  
ATOM   1261  O   GLY A 148      23.240  39.638  37.000  1.00 20.44           O  
ATOM   1262  N   ILE A 149      25.295  38.795  36.768  1.00 22.51           N  
ATOM   1263  CA  ILE A 149      25.458  38.628  38.199  1.00 19.34           C  
ATOM   1264  C   ILE A 149      25.323  39.986  38.892  1.00 22.73           C  
ATOM   1265  O   ILE A 149      24.624  40.097  39.902  1.00 21.82           O  
ATOM   1266  CB  ILE A 149      26.797  37.918  38.586  1.00 22.21           C  
ATOM   1267  CG1 ILE A 149      26.789  36.470  38.088  1.00 23.99           C  
ATOM   1268  CG2 ILE A 149      26.966  37.898  40.113  1.00 17.77           C  
ATOM   1269  CD1 ILE A 149      28.150  35.778  38.127  1.00 19.57           C  
ATOM   1270  N   LEU A 150      26.004  41.009  38.373  1.00 21.44           N  
ATOM   1271  CA  LEU A 150      26.003  42.319  39.017  1.00 20.93           C  
ATOM   1272  C   LEU A 150      24.631  42.938  38.941  1.00 21.35           C  
ATOM   1273  O   LEU A 150      24.099  43.447  39.912  1.00 23.06           O  
ATOM   1274  CB  LEU A 150      27.027  43.223  38.379  1.00 21.74           C  
ATOM   1275  CG  LEU A 150      28.455  42.784  38.696  1.00 21.02           C  
ATOM   1276  CD1 LEU A 150      29.436  43.551  37.763  1.00 21.55           C  
ATOM   1277  CD2 LEU A 150      28.711  43.039  40.202  1.00 23.99           C  
ATOM   1278  N   ARG A 151      24.047  42.856  37.774  1.00 22.26           N  
ATOM   1279  CA  ARG A 151      22.712  43.395  37.542  0.50 21.21           C  
ATOM   1281  C   ARG A 151      21.668  42.757  38.467  1.00 21.87           C  
ATOM   1282  O   ARG A 151      20.841  43.437  39.088  1.00 21.49           O  
ATOM   1283  CB  ARG A 151      22.360  43.152  36.078  0.50 24.29           C  
ATOM   1285  CG  ARG A 151      21.138  43.849  35.584  0.50 26.99           C  
ATOM   1287  CD  ARG A 151      21.250  45.360  35.655  0.50 31.22           C  
ATOM   1289  NE  ARG A 151      19.978  45.978  35.315  0.50 29.59           N  
ATOM   1291  CZ  ARG A 151      19.594  46.288  34.078  0.50 29.01           C  
ATOM   1293  NH1 ARG A 151      20.378  46.079  33.032  0.50 31.34           N  
ATOM   1295  NH2 ARG A 151      18.404  46.838  33.881  0.50 38.57           N  
ATOM   1297  N   HIS A 152      21.740  41.448  38.607  1.00 23.67           N  
ATOM   1298  CA  HIS A 152      20.861  40.675  39.474  1.00 21.86           C  
ATOM   1299  C   HIS A 152      20.956  41.124  40.921  1.00 21.44           C  
ATOM   1300  O   HIS A 152      19.972  41.098  41.648  1.00 22.36           O  
ATOM   1301  CB  HIS A 152      21.219  39.177  39.299  1.00 22.37           C  
ATOM   1302  CG  HIS A 152      20.465  38.230  40.187  1.00 20.81           C  
ATOM   1303  ND1 HIS A 152      19.120  38.001  40.054  1.00 22.62           N  
ATOM   1304  CD2 HIS A 152      20.897  37.394  41.165  1.00 26.04           C  
ATOM   1305  CE1 HIS A 152      18.735  37.103  40.953  1.00 24.51           C  
ATOM   1306  NE2 HIS A 152      19.795  36.723  41.650  1.00 22.12           N  
ATOM   1307  N   ASN A 153      22.156  41.507  41.350  1.00 23.98           N  
ATOM   1308  CA  ASN A 153      22.414  41.959  42.709  1.00 24.79           C  
ATOM   1309  C   ASN A 153      22.031  43.411  42.962  1.00 26.04           C  
ATOM   1310  O   ASN A 153      22.026  43.838  44.109  1.00 25.06           O  
ATOM   1311  CB  ASN A 153      23.887  41.730  43.065  1.00 24.89           C  
ATOM   1312  CG  ASN A 153      24.125  40.364  43.627  1.00 31.79           C  
ATOM   1313  OD1 ASN A 153      24.013  40.191  44.837  1.00 27.29           O  
ATOM   1314  ND2 ASN A 153      24.443  39.367  42.744  1.00 26.19           N  
ATOM   1315  N   GLY A 154      21.703  44.141  41.896  1.00 23.69           N  
ATOM   1316  CA  GLY A 154      21.178  45.508  41.970  1.00 24.56           C  
ATOM   1317  C   GLY A 154      22.043  46.599  41.339  1.00 23.17           C  
ATOM   1318  O   GLY A 154      21.651  47.767  41.343  1.00 22.92           O  
ATOM   1319  N   VAL A 155      23.218  46.227  40.815  1.00 21.81           N  
ATOM   1320  CA  VAL A 155      24.105  47.182  40.201  1.00 21.15           C  
ATOM   1321  C   VAL A 155      23.468  47.756  38.953  1.00 23.14           C  
ATOM   1322  O   VAL A 155      23.063  47.025  38.096  1.00 22.80           O  
ATOM   1323  CB  VAL A 155      25.450  46.548  39.859  1.00 22.17           C  
ATOM   1324  CG1 VAL A 155      26.420  47.596  39.196  1.00 21.23           C  
ATOM   1325  CG2 VAL A 155      26.044  45.998  41.087  1.00 21.43           C  
ATOM   1326  N   GLU A 156      23.429  49.083  38.858  1.00 23.89           N  
ATOM   1327  CA  GLU A 156      22.782  49.772  37.734  1.00 29.80           C  
ATOM   1328  C   GLU A 156      23.752  49.868  36.554  1.00 28.30           C  
ATOM   1329  O   GLU A 156      24.219  50.906  36.195  1.00 30.18           O  
ATOM   1330  CB  GLU A 156      22.234  51.122  38.197  1.00 32.06           C  
ATOM   1331  CG  GLU A 156      21.039  50.961  39.208  1.00 35.80           C  
ATOM   1332  CD  GLU A 156      20.335  52.297  39.605  1.00 42.71           C  
ATOM   1333  OE1 GLU A 156      20.861  53.393  39.256  1.00 54.24           O  
ATOM   1334  OE2 GLU A 156      19.258  52.229  40.266  1.00 52.97           O  
ATOM   1335  N   VAL A 157      24.091  48.730  35.987  1.00 24.31           N  
ATOM   1336  CA  VAL A 157      24.901  48.713  34.787  1.00 25.11           C  
ATOM   1337  C   VAL A 157      23.881  48.622  33.697  1.00 26.95           C  
ATOM   1338  O   VAL A 157      22.802  48.046  33.906  1.00 28.11           O  
ATOM   1339  CB  VAL A 157      25.873  47.474  34.681  1.00 25.39           C  
ATOM   1340  CG1 VAL A 157      27.158  47.735  35.425  1.00 32.89           C  
ATOM   1341  CG2 VAL A 157      25.195  46.127  35.116  1.00 26.76           C  
ATOM   1342  N   GLY A 158      24.214  49.180  32.533  1.00 25.70           N  
ATOM   1343  CA  GLY A 158      23.319  49.170  31.385  1.00 23.45           C  
ATOM   1344  C   GLY A 158      24.042  48.718  30.152  1.00 24.06           C  
ATOM   1345  O   GLY A 158      25.254  48.500  30.148  1.00 24.82           O  
ATOM   1346  N   LYS A 159      23.300  48.572  29.076  1.00 26.33           N  
ATOM   1347  CA  LYS A 159      23.894  48.127  27.804  1.00 25.19           C  
ATOM   1348  C   LYS A 159      25.059  49.012  27.318  1.00 24.59           C  
ATOM   1349  O   LYS A 159      26.021  48.510  26.773  1.00 26.38           O  
ATOM   1350  CB  LYS A 159      22.801  48.113  26.751  1.00 29.00           C  
ATOM   1351  CG  LYS A 159      23.282  47.739  25.346  1.00 36.39           C  
ATOM   1352  CD  LYS A 159      23.878  46.311  25.305  1.00 34.47           C  
ATOM   1353  CE  LYS A 159      22.766  45.290  25.359  1.00 30.04           C  
ATOM   1354  NZ  LYS A 159      21.864  45.467  24.189  1.00 24.58           N  
ATOM   1355  N   LYS A 160      24.985  50.321  27.538  1.00 25.04           N  
ATOM   1356  CA  LYS A 160      26.099  51.203  27.148  1.00 27.44           C  
ATOM   1357  C   LYS A 160      27.404  50.841  27.848  1.00 25.96           C  
ATOM   1358  O   LYS A 160      28.477  51.065  27.300  1.00 26.73           O  
ATOM   1359  CB  LYS A 160      25.770  52.696  27.380  1.00 30.43           C  
ATOM   1360  CG  LYS A 160      24.651  53.196  26.499  1.00 42.57           C  
ATOM   1361  N   ASP A 161      27.306  50.303  29.063  1.00 26.17           N  
ATOM   1362  CA  ASP A 161      28.473  49.936  29.854  1.00 23.60           C  
ATOM   1363  C   ASP A 161      29.124  48.716  29.280  1.00 22.89           C  
ATOM   1364  O   ASP A 161      30.351  48.605  29.276  1.00 24.70           O  
ATOM   1365  CB  ASP A 161      28.068  49.675  31.304  1.00 26.16           C  
ATOM   1366  CG  ASP A 161      27.530  50.919  31.993  1.00 29.19           C  
ATOM   1367  OD1 ASP A 161      28.136  52.014  31.851  1.00 30.10           O  
ATOM   1368  OD2 ASP A 161      26.468  50.799  32.638  1.00 22.02           O  
ATOM   1369  N   TYR A 162      28.291  47.787  28.789  1.00 24.79           N  
ATOM   1370  CA  TYR A 162      28.774  46.566  28.112  1.00 23.21           C  
ATOM   1371  C   TYR A 162      29.376  46.817  26.733  1.00 24.44           C  
ATOM   1372  O   TYR A 162      30.382  46.243  26.392  1.00 22.58           O  
ATOM   1373  CB  TYR A 162      27.608  45.582  28.014  1.00 22.48           C  
ATOM   1374  CG  TYR A 162      27.757  44.370  27.137  1.00 23.59           C  
ATOM   1375  CD1 TYR A 162      28.341  43.208  27.618  1.00 24.08           C  
ATOM   1376  CD2 TYR A 162      27.254  44.362  25.838  1.00 26.43           C  
ATOM   1377  CE1 TYR A 162      28.469  42.099  26.834  1.00 22.54           C  
ATOM   1378  CE2 TYR A 162      27.348  43.245  25.067  1.00 21.84           C  
ATOM   1379  CZ  TYR A 162      27.958  42.113  25.557  1.00 26.08           C  
ATOM   1380  OH  TYR A 162      28.023  41.011  24.757  1.00 24.74           O  
ATOM   1381  N   LEU A 163      28.735  47.638  25.931  1.00 23.15           N  
ATOM   1382  CA  LEU A 163      29.197  47.906  24.546  1.00 23.44           C  
ATOM   1383  C   LEU A 163      30.380  48.885  24.509  1.00 26.62           C  
ATOM   1384  O   LEU A 163      31.321  48.718  23.766  1.00 22.34           O  
ATOM   1385  CB  LEU A 163      28.027  48.503  23.721  1.00 23.69           C  
ATOM   1386  CG  LEU A 163      26.909  47.508  23.404  1.00 26.06           C  
ATOM   1387  CD1 LEU A 163      25.806  48.267  22.693  1.00 22.96           C  
ATOM   1388  CD2 LEU A 163      27.358  46.250  22.595  1.00 21.25           C  
ATOM   1389  N   GLY A 164      30.305  49.912  25.343  1.00 25.83           N  
ATOM   1390  CA  GLY A 164      31.316  50.964  25.342  1.00 28.42           C  
ATOM   1391  C   GLY A 164      31.057  51.978  24.273  1.00 27.21           C  
ATOM   1392  O   GLY A 164      30.038  51.925  23.582  1.00 30.82           O  
ATOM   1393  N   ALA A 165      31.967  52.934  24.141  1.00 31.25           N  
ATOM   1394  CA  ALA A 165      31.817  53.990  23.132  1.00 31.23           C  
ATOM   1395  C   ALA A 165      31.943  53.415  21.714  1.00 29.61           C  
ATOM   1396  O   ALA A 165      32.669  52.430  21.471  1.00 30.90           O  
ATOM   1397  CB  ALA A 165      32.836  55.102  23.343  1.00 30.28           C  
HETATM 1398  N   MSE A 166      31.196  54.006  20.793  1.00 30.20           N  
HETATM 1399  CA  MSE A 166      31.238  53.647  19.386  1.00 30.27           C  
HETATM 1400  C   MSE A 166      32.049  54.697  18.653  1.00 31.12           C  
HETATM 1401  O   MSE A 166      32.009  55.866  19.026  1.00 29.62           O  
HETATM 1402  CB  MSE A 166      29.852  53.666  18.758  1.00 30.71           C  
HETATM 1403  CG  MSE A 166      28.876  52.618  19.165  1.00 35.06           C  
HETATM 1404 SE   MSE A 166      29.499  50.812  19.000  0.75 31.18          SE  
HETATM 1405  CE  MSE A 166      29.651  50.524  20.858  1.00 26.21           C  
ATOM   1406  N   PRO A 167      32.728  54.295  17.575  1.00 30.47           N  
ATOM   1407  CA  PRO A 167      33.518  55.211  16.766  1.00 31.87           C  
ATOM   1408  C   PRO A 167      32.660  56.011  15.744  1.00 31.80           C  
ATOM   1409  O   PRO A 167      32.936  56.001  14.533  1.00 32.36           O  
ATOM   1410  CB  PRO A 167      34.496  54.288  16.077  1.00 31.34           C  
ATOM   1411  CG  PRO A 167      33.698  53.034  15.850  1.00 31.07           C  
ATOM   1412  CD  PRO A 167      32.795  52.920  17.052  1.00 29.91           C  
ATOM   1413  N   TYR A 168      31.648  56.706  16.252  1.00 30.16           N  
ATOM   1414  CA  TYR A 168      30.697  57.393  15.388  1.00 33.29           C  
ATOM   1415  C   TYR A 168      31.423  58.474  14.590  1.00 36.33           C  
ATOM   1416  O   TYR A 168      32.371  59.120  15.096  1.00 36.35           O  
ATOM   1417  CB  TYR A 168      29.595  58.066  16.187  1.00 33.81           C  
ATOM   1418  CG  TYR A 168      28.640  57.141  16.873  1.00 34.78           C  
ATOM   1419  CD1 TYR A 168      27.893  56.227  16.148  1.00 35.84           C  
ATOM   1420  CD2 TYR A 168      28.453  57.205  18.247  1.00 32.65           C  
ATOM   1421  CE1 TYR A 168      27.003  55.362  16.772  1.00 36.94           C  
ATOM   1422  CE2 TYR A 168      27.557  56.357  18.885  1.00 37.55           C  
ATOM   1423  CZ  TYR A 168      26.839  55.434  18.137  1.00 38.04           C  
ATOM   1424  OH  TYR A 168      25.949  54.583  18.749  1.00 45.00           O  
ATOM   1425  N   LYS A 169      30.985  58.655  13.344  1.00 38.72           N  
ATOM   1426  CA  LYS A 169      31.505  59.718  12.486  1.00 41.32           C  
ATOM   1427  C   LYS A 169      30.370  60.633  12.094  1.00 44.85           C  
ATOM   1428  O   LYS A 169      29.238  60.189  11.866  1.00 43.06           O  
ATOM   1429  CB  LYS A 169      32.162  59.110  11.251  1.00 40.92           C  
ATOM   1430  CG  LYS A 169      33.478  58.390  11.568  1.00 42.57           C  
ATOM   1431  CD  LYS A 169      33.824  57.339  10.553  1.00 36.92           C  
ATOM   1432  CE  LYS A 169      33.210  56.021  10.877  1.00 42.43           C  
ATOM   1433  NZ  LYS A 169      33.784  55.415  12.118  1.00 32.44           N  
ATOM   1434  N   ALA A 170      30.679  61.927  12.054  1.00 50.90           N  
ATOM   1435  CA  ALA A 170      29.761  62.922  11.531  1.00 54.93           C  
ATOM   1436  C   ALA A 170      29.599  62.697  10.029  1.00 58.02           C  
ATOM   1437  O   ALA A 170      30.570  62.366   9.334  1.00 59.27           O  
ATOM   1438  CB  ALA A 170      30.293  64.314  11.787  1.00 54.72           C  
ATOM   1439  N   PRO A 171      28.374  62.868   9.525  1.00 61.72           N  
ATOM   1440  CA  PRO A 171      28.095  62.717   8.077  1.00 64.01           C  
ATOM   1441  C   PRO A 171      28.705  63.830   7.208  1.00 64.03           C  
ATOM   1442  O   PRO A 171      28.947  64.934   7.711  1.00 63.54           O  
ATOM   1443  CB  PRO A 171      26.565  62.769   8.008  1.00 65.17           C  
ATOM   1444  CG  PRO A 171      26.141  63.506   9.268  1.00 65.16           C  
ATOM   1445  CD  PRO A 171      27.172  63.211  10.312  1.00 61.41           C  
TER    1446      PRO A 171                                                      
END
MOLECULE T0481.pdb
ATOM   1157  N   ASN     5      43.757  48.627  12.993  1.00 48.55           N  
ATOM   1158  CA  ASN     5      43.707  47.221  13.486  1.00 48.66           C  
ATOM   1159  C   ASN     5      42.297  46.854  13.970  1.00 46.10           C  
ATOM   1160  O   ASN     5      41.931  47.131  15.124  1.00 45.32           O  
ATOM   1161  CB  ASN     5      44.739  47.032  14.610  1.00 49.92           C  
ATOM   1162  CG  ASN     5      45.105  45.561  14.854  1.00 51.98           C  
ATOM   1163  OD1 ASN     5      44.378  44.628  14.479  1.00 41.03           O  
ATOM   1164  ND2 ASN     5      46.252  45.360  15.496  1.00 51.86           N  
ATOM   1165  N   GLN     6      41.522  46.221  13.081  1.00 42.89           N  
ATOM   1166  CA  GLN     6      40.122  45.866  13.363  1.00 39.86           C  
ATOM   1167  C   GLN     6      39.972  44.674  14.322  1.00 37.64           C  
ATOM   1168  O   GLN     6      38.948  44.545  14.985  1.00 37.24           O  
ATOM   1169  CB  GLN     6      39.363  45.603  12.059  1.00 39.17           C  
ATOM   1170  N   ILE     7      40.983  43.809  14.403  1.00 34.88           N  
ATOM   1171  CA  ILE     7      40.937  42.694  15.353  1.00 34.40           C  
ATOM   1172  C   ILE     7      41.043  43.194  16.799  1.00 31.45           C  
ATOM   1173  O   ILE     7      40.216  42.843  17.643  1.00 29.10           O  
ATOM   1174  CB  ILE     7      42.038  41.634  15.082  1.00 34.24           C  
ATOM   1175  CG1 ILE     7      41.687  40.792  13.849  1.00 35.88           C  
ATOM   1176  CG2 ILE     7      42.186  40.712  16.271  1.00 34.37           C  
ATOM   1177  CD1 ILE     7      42.783  39.803  13.446  1.00 36.32           C  
ATOM   1178  N   VAL     8      42.071  44.003  17.067  1.00 31.23           N  
ATOM   1179  CA  VAL     8      42.289  44.610  18.384  1.00 29.82           C  
ATOM   1180  C   VAL     8      41.107  45.490  18.755  1.00 29.64           C  
ATOM   1181  O   VAL     8      40.544  45.353  19.832  1.00 30.66           O  
ATOM   1182  CB  VAL     8      43.589  45.453  18.418  1.00 29.55           C  
ATOM   1183  CG1 VAL     8      43.562  46.438  19.575  1.00 30.78           C  
ATOM   1184  CG2 VAL     8      44.817  44.553  18.513  1.00 26.78           C  
ATOM   1185  N   SER     9      40.726  46.377  17.846  1.00 30.09           N  
ATOM   1186  CA  SER     9      39.600  47.287  18.059  1.00 30.85           C  
ATOM   1187  C   SER     9      38.300  46.564  18.423  1.00 29.88           C  
ATOM   1188  O   SER     9      37.633  46.922  19.394  1.00 30.15           O  
ATOM   1189  CB  SER     9      39.382  48.137  16.796  1.00 31.43           C  
ATOM   1190  OG  SER     9      38.309  49.037  16.971  1.00 34.73           O  
ATOM   1191  N   HIS    10      37.946  45.552  17.640  1.00 29.62           N  
ATOM   1192  CA  HIS    10      36.728  44.774  17.872  1.00 29.21           C  
ATOM   1193  C   HIS    10      36.770  43.988  19.188  1.00 27.89           C  
ATOM   1194  O   HIS    10      35.747  43.834  19.863  1.00 27.83           O  
ATOM   1195  CB  HIS    10      36.453  43.833  16.696  1.00 29.11           C  
ATOM   1196  CG  HIS    10      35.127  43.131  16.782  1.00 30.96           C  
ATOM   1197  ND1 HIS    10      34.991  41.773  16.582  1.00 29.81           N  
ATOM   1198  CD2 HIS    10      33.882  43.596  17.055  1.00 32.11           C  
ATOM   1199  CE1 HIS    10      33.723  41.432  16.721  1.00 34.31           C  
ATOM   1200  NE2 HIS    10      33.025  42.520  17.004  1.00 31.48           N  
ATOM   1201  N   PHE    11      37.946  43.490  19.545  1.00 26.50           N  
ATOM   1202  CA  PHE    11      38.144  42.846  20.847  1.00 25.86           C  
ATOM   1203  C   PHE    11      37.899  43.833  22.005  1.00 25.41           C  
ATOM   1204  O   PHE    11      37.131  43.543  22.922  1.00 26.59           O  
ATOM   1205  CB  PHE    11      39.561  42.251  20.931  1.00 25.87           C  
ATOM   1206  CG  PHE    11      39.978  41.854  22.325  1.00 23.85           C  
ATOM   1207  CD1 PHE    11      39.402  40.765  22.948  1.00 23.40           C  
ATOM   1208  CD2 PHE    11      40.940  42.587  23.009  1.00 24.43           C  
ATOM   1209  CE1 PHE    11      39.769  40.403  24.233  1.00 24.62           C  
ATOM   1210  CE2 PHE    11      41.331  42.230  24.298  1.00 26.60           C  
ATOM   1211  CZ  PHE    11      40.751  41.136  24.910  1.00 25.39           C  
ATOM   1212  N   LEU    12      38.558  44.993  21.960  1.00 25.19           N  
ATOM   1213  CA  LEU    12      38.433  46.000  23.024  1.00 24.40           C  
ATOM   1214  C   LEU    12      37.013  46.571  23.154  1.00 24.37           C  
ATOM   1215  O   LEU    12      36.551  46.899  24.244  1.00 23.55           O  
ATOM   1216  CB  LEU    12      39.429  47.127  22.787  1.00 25.08           C  
ATOM   1217  CG  LEU    12      40.903  46.732  22.935  1.00 23.88           C  
ATOM   1218  CD1 LEU    12      41.772  47.927  22.675  1.00 19.99           C  
ATOM   1219  CD2 LEU    12      41.172  46.151  24.314  1.00 17.50           C  
ATOM   1220  N   SER    13      36.345  46.698  22.018  1.00 24.35           N  
ATOM   1221  CA  SER    13      34.937  47.074  21.945  1.00 24.92           C  
ATOM   1222  C   SER    13      34.094  46.327  22.991  1.00 25.13           C  
ATOM   1223  O   SER    13      33.214  46.894  23.629  1.00 27.77           O  
ATOM   1224  CB  SER    13      34.440  46.723  20.541  1.00 25.22           C  
ATOM   1225  OG  SER    13      33.092  47.020  20.376  1.00 26.42           O  
ATOM   1226  N   HIS    14      34.392  45.046  23.150  1.00 24.32           N  
ATOM   1227  CA  HIS    14      33.720  44.177  24.093  1.00 23.44           C  
ATOM   1228  C   HIS    14      34.479  44.063  25.424  1.00 22.45           C  
ATOM   1229  O   HIS    14      33.887  44.226  26.488  1.00 22.95           O  
ATOM   1230  CB  HIS    14      33.528  42.795  23.455  1.00 23.60           C  
ATOM   1231  CG  HIS    14      32.468  42.759  22.397  1.00 22.55           C  
ATOM   1232  ND1 HIS    14      31.123  42.736  22.695  1.00 22.51           N  
ATOM   1233  CD2 HIS    14      32.554  42.716  21.047  1.00 24.07           C  
ATOM   1234  CE1 HIS    14      30.425  42.689  21.575  1.00 22.12           C  
ATOM   1235  NE2 HIS    14      31.270  42.672  20.559  1.00 23.74           N  
ATOM   1236  N   ARG    15      35.782  43.819  25.364  1.00 23.33           N  
ATOM   1237  CA  ARG    15      36.609  43.694  26.581  1.00 23.65           C  
ATOM   1238  C   ARG    15      36.617  44.947  27.474  1.00 24.04           C  
ATOM   1239  O   ARG    15      36.658  44.830  28.696  1.00 25.31           O  
ATOM   1240  CB  ARG    15      38.040  43.267  26.216  1.00 22.98           C  
ATOM   1241  CG  ARG    15      39.061  43.250  27.369  1.00 25.04           C  
ATOM   1242  CD  ARG    15      38.654  42.372  28.575  1.00 23.51           C  
ATOM   1243  NE  ARG    15      38.553  40.961  28.233  1.00 25.26           N  
ATOM   1244  CZ  ARG    15      39.583  40.124  28.141  1.00 29.21           C  
ATOM   1245  NH1 ARG    15      40.828  40.529  28.388  1.00 30.40           N  
ATOM   1246  NH2 ARG    15      39.358  38.857  27.809  1.00 26.91           N  
ATOM   1247  N   ASN    16      36.571  46.142  26.889  1.00 24.45           N  
ATOM   1248  CA  ASN    16      36.470  47.356  27.702  1.00 24.31           C  
ATOM   1249  C   ASN    16      35.182  47.388  28.527  1.00 24.67           C  
ATOM   1250  O   ASN    16      35.152  47.967  29.618  1.00 24.35           O  
ATOM   1251  CB  ASN    16      36.580  48.634  26.848  1.00 23.87           C  
ATOM   1252  CG  ASN    16      37.991  48.873  26.313  1.00 25.17           C  
ATOM   1253  OD1 ASN    16      38.980  48.416  26.887  1.00 27.85           O  
ATOM   1254  ND2 ASN    16      38.085  49.616  25.218  1.00 24.54           N  
ATOM   1255  N   VAL    17      34.112  46.792  28.005  1.00 25.32           N  
ATOM   1256  CA  VAL    17      32.845  46.739  28.750  1.00 25.14           C  
ATOM   1257  C   VAL    17      32.951  45.686  29.871  1.00 25.47           C  
ATOM   1258  O   VAL    17      32.466  45.898  30.980  1.00 24.38           O  
ATOM   1259  CB  VAL    17      31.636  46.485  27.807  1.00 25.11           C  
ATOM   1260  CG1 VAL    17      30.329  46.424  28.590  1.00 23.93           C  
ATOM   1261  CG2 VAL    17      31.567  47.563  26.732  1.00 21.19           C  
ATOM   1262  N   THR    18      33.621  44.570  29.581  1.00 26.85           N  
ATOM   1263  CA  THR    18      33.871  43.517  30.570  1.00 27.43           C  
ATOM   1264  C   THR    18      34.686  44.040  31.750  1.00 28.37           C  
ATOM   1265  O   THR    18      34.401  43.716  32.908  1.00 27.86           O  
ATOM   1266  CB  THR    18      34.631  42.343  29.937  1.00 26.46           C  
ATOM   1267  OG1 THR    18      33.758  41.641  29.047  1.00 28.22           O  
ATOM   1268  CG2 THR    18      35.153  41.393  31.005  1.00 26.76           C  
ATOM   1269  N   ASN    19      35.712  44.830  31.436  1.00 29.46           N  
ATOM   1270  CA  ASN    19      36.583  45.415  32.444  1.00 29.44           C  
ATOM   1271  C   ASN    19      35.877  46.449  33.302  1.00 31.03           C  
ATOM   1272  O   ASN    19      36.120  46.544  34.505  1.00 32.27           O  
ATOM   1273  CB  ASN    19      37.800  46.053  31.781  1.00 28.63           C  
ATOM   1274  CG  ASN    19      38.752  45.038  31.224  1.00 27.67           C  
ATOM   1275  OD1 ASN    19      38.698  43.849  31.561  1.00 29.89           O  
ATOM   1276  ND2 ASN    19      39.631  45.490  30.362  1.00 16.24           N  
ATOM   1277  N   GLU    20      35.009  47.226  32.673  1.00 32.85           N  
ATOM   1278  CA  GLU    20      34.197  48.215  33.378  1.00 34.98           C  
ATOM   1279  C   GLU    20      33.218  47.533  34.338  1.00 32.92           C  
ATOM   1280  O   GLU    20      33.018  47.999  35.451  1.00 35.00           O  
ATOM   1281  CB  GLU    20      33.450  49.089  32.369  1.00 34.33           C  
ATOM   1282  CG  GLU    20      32.885  50.367  32.951  1.00 41.33           C  
ATOM   1283  CD  GLU    20      32.241  51.269  31.906  1.00 41.71           C  
ATOM   1284  OE1 GLU    20      32.529  51.102  30.688  1.00 48.89           O  
ATOM   1285  OE2 GLU    20      31.448  52.149  32.316  1.00 50.11           O  
ATOM   1286  N   LEU    21      32.624  46.426  33.905  1.00 31.28           N  
ATOM   1287  CA  LEU    21      31.700  45.645  34.734  1.00 30.29           C  
ATOM   1288  C   LEU    21      32.414  44.977  35.915  1.00 30.39           C  
ATOM   1289  O   LEU    21      31.860  44.873  37.015  1.00 30.47           O  
ATOM   1290  CB  LEU    21      30.993  44.561  33.892  1.00 29.76           C  
ATOM   1291  CG  LEU    21      29.893  44.963  32.899  1.00 27.66           C  
ATOM   1292  CD1 LEU    21      29.501  43.764  32.026  1.00 22.19           C  
ATOM   1293  CD2 LEU    21      28.660  45.529  33.614  1.00 25.56           C  
ATOM   1294  N   ALA    22      33.635  44.512  35.672  1.00 30.64           N  
ATOM   1295  CA  ALA    22      34.460  43.895  36.710  1.00 31.48           C  
ATOM   1296  C   ALA    22      34.780  44.861  37.856  1.00 32.45           C  
ATOM   1297  O   ALA    22      34.888  44.450  39.016  1.00 31.11           O  
ATOM   1298  CB  ALA    22      35.755  43.354  36.098  1.00 31.19           C  
ATOM   1299  N   GLU    23      34.934  46.138  37.510  1.00 34.47           N  
ATOM   1300  CA  GLU    23      35.214  47.208  38.475  1.00 36.19           C  
ATOM   1301  C   GLU    23      34.053  47.424  39.453  1.00 35.68           C  
ATOM   1302  O   GLU    23      34.267  47.870  40.573  1.00 36.37           O  
ATOM   1303  CB  GLU    23      35.582  48.500  37.711  1.00 36.80           C  
ATOM   1304  CG  GLU    23      34.996  49.826  38.232  1.00 44.97           C  
ATOM   1305  CD  GLU    23      35.795  50.464  39.365  1.00 54.10           C  
ATOM   1306  OE1 GLU    23      37.029  50.243  39.444  1.00 58.36           O  
ATOM   1307  OE2 GLU    23      35.181  51.215  40.160  1.00 55.37           O  
ATOM   1308  N   LYS    24      32.837  47.095  39.020  1.00 35.78           N  
ATOM   1309  CA  LYS    24      31.630  47.243  39.828  1.00 36.00           C  
ATOM   1310  C   LYS    24      31.403  46.089  40.811  1.00 36.32           C  
ATOM   1311  O   LYS    24      30.399  46.071  41.524  1.00 37.08           O  
ATOM   1312  CB  LYS    24      30.411  47.385  38.910  1.00 36.20           C  
ATOM   1313  CG  LYS    24      30.488  48.628  38.038  1.00 37.65           C  
ATOM   1314  CD  LYS    24      29.127  49.070  37.532  1.00 40.50           C  
ATOM   1315  CE  LYS    24      29.157  50.541  37.089  1.00 46.04           C  
ATOM   1316  NZ  LYS    24      30.023  50.741  35.879  1.00 47.21           N  
ATOM   1317  N   ILE    25      32.337  45.138  40.840  1.00 35.88           N  
ATOM   1318  CA  ILE    25      32.294  43.987  41.733  1.00 35.06           C  
ATOM   1319  C   ILE    25      33.129  44.260  42.988  1.00 36.05           C  
ATOM   1320  O   ILE    25      34.364  44.186  42.953  1.00 35.12           O  
ATOM   1321  CB  ILE    25      32.851  42.718  41.022  1.00 34.99           C  
ATOM   1322  CG1 ILE    25      32.047  42.405  39.750  1.00 36.68           C  
ATOM   1323  CG2 ILE    25      32.848  41.515  41.959  1.00 34.29           C  
ATOM   1324  CD1 ILE    25      32.637  41.292  38.907  1.00 33.67           C  
ATOM   1325  N   SER    26      32.457  44.580  44.092  1.00 37.22           N  
ATOM   1326  CA  SER    26      33.128  44.736  45.383  1.00 38.56           C  
ATOM   1327  C   SER    26      33.758  43.410  45.786  1.00 40.35           C  
ATOM   1328  O   SER    26      33.334  42.354  45.310  1.00 41.06           O  
ATOM   1329  CB  SER    26      32.125  45.138  46.459  1.00 38.56           C  
ATOM   1330  OG  SER    26      31.263  44.055  46.775  1.00 37.07           O  
ATOM   1331  N   LYS    27      34.756  43.461  46.666  1.00 41.84           N  
ATOM   1332  CA  LYS    27      35.441  42.247  47.124  1.00 43.21           C  
ATOM   1333  C   LYS    27      34.509  41.312  47.910  1.00 42.45           C  
ATOM   1334  O   LYS    27      34.734  40.103  47.968  1.00 41.33           O  
ATOM   1335  CB  LYS    27      36.707  42.600  47.918  1.00 43.47           C  
ATOM   1336  CG  LYS    27      37.740  43.358  47.071  1.00 45.04           C  
ATOM   1337  CD  LYS    27      39.142  43.329  47.664  1.00 45.26           C  
ATOM   1338  CE  LYS    27      39.954  42.132  47.180  1.00 47.98           C  
ATOM   1339  NZ  LYS    27      40.646  42.396  45.885  1.00 44.46           N  
ATOM   1340  N   ASP    28      33.448  41.865  48.491  1.00 43.17           N  
ATOM   1341  CA  ASP    28      32.423  41.038  49.143  1.00 43.66           C  
ATOM   1342  C   ASP    28      31.589  40.274  48.109  1.00 42.08           C  
ATOM   1343  O   ASP    28      30.981  39.250  48.419  1.00 41.99           O  
ATOM   1344  CB  ASP    28      31.504  41.876  50.056  1.00 44.61           C  
ATOM   1345  CG  ASP    28      32.015  41.950  51.499  1.00 50.08           C  
ATOM   1346  OD1 ASP    28      32.189  40.877  52.115  1.00 52.94           O  
ATOM   1347  OD2 ASP    28      32.229  43.067  52.026  1.00 53.70           O  
ATOM   1348  N   HIS    29      31.575  40.767  46.875  1.00 40.09           N  
ATOM   1349  CA  HIS    29      30.784  40.157  45.813  1.00 38.00           C  
ATOM   1350  C   HIS    29      31.591  39.254  44.869  1.00 35.48           C  
ATOM   1351  O   HIS    29      31.047  38.750  43.891  1.00 34.55           O  
ATOM   1352  CB  HIS    29      30.051  41.241  45.014  1.00 37.73           C  
ATOM   1353  CG  HIS    29      28.769  41.692  45.637  1.00 38.39           C  
ATOM   1354  ND1 HIS    29      28.368  43.010  45.641  1.00 39.31           N  
ATOM   1355  CD2 HIS    29      27.793  40.999  46.267  1.00 39.76           C  
ATOM   1356  CE1 HIS    29      27.201  43.109  46.251  1.00 41.37           C  
ATOM   1357  NE2 HIS    29      26.830  41.903  46.639  1.00 41.73           N  
ATOM   1358  N   TYR    30      32.873  39.052  45.163  1.00 33.70           N  
ATOM   1359  CA  TYR    30      33.706  38.095  44.423  1.00 32.36           C  
ATOM   1360  C   TYR    30      33.079  36.686  44.430  1.00 32.70           C  
ATOM   1361  O   TYR    30      33.074  35.983  43.416  1.00 32.96           O  
ATOM   1362  CB  TYR    30      35.106  38.029  45.044  1.00 31.66           C  
ATOM   1363  CG  TYR    30      36.109  39.075  44.583  1.00 30.06           C  
ATOM   1364  CD1 TYR    30      35.708  40.312  44.111  1.00 29.10           C  
ATOM   1365  CD2 TYR    30      37.483  38.822  44.672  1.00 30.44           C  
ATOM   1366  CE1 TYR    30      36.643  41.265  43.700  1.00 29.51           C  
ATOM   1367  CE2 TYR    30      38.421  39.763  44.272  1.00 29.19           C  
ATOM   1368  CZ  TYR    30      37.999  40.983  43.786  1.00 31.71           C  
ATOM   1369  OH  TYR    30      38.933  41.930  43.389  1.00 31.55           O  
ATOM   1370  N   SER    31      32.546  36.289  45.586  1.00 32.70           N  
ATOM   1371  CA  SER    31      31.925  34.974  45.767  1.00 31.27           C  
ATOM   1372  C   SER    31      30.485  34.902  45.255  1.00 29.76           C  
ATOM   1373  O   SER    31      29.886  33.828  45.261  1.00 29.74           O  
ATOM   1374  CB  SER    31      31.904  34.639  47.255  1.00 31.47           C  
ATOM   1375  OG  SER    31      31.001  35.510  47.929  1.00 31.56           O  
ATOM   1376  N   TYR    32      29.923  36.031  44.826  1.00 29.31           N  
ATOM   1377  CA  TYR    32      28.493  36.105  44.518  1.00 28.85           C  
ATOM   1378  C   TYR    32      28.089  35.149  43.394  1.00 30.14           C  
ATOM   1379  O   TYR    32      28.698  35.128  42.324  1.00 31.63           O  
ATOM   1380  CB  TYR    32      28.054  37.533  44.156  1.00 28.51           C  
ATOM   1381  CG  TYR    32      26.573  37.583  43.859  1.00 28.85           C  
ATOM   1382  CD1 TYR    32      25.640  37.573  44.892  1.00 30.87           C  
ATOM   1383  CD2 TYR    32      26.104  37.564  42.555  1.00 30.04           C  
ATOM   1384  CE1 TYR    32      24.285  37.577  44.632  1.00 31.57           C  
ATOM   1385  CE2 TYR    32      24.743  37.561  42.284  1.00 28.50           C  
ATOM   1386  CZ  TYR    32      23.840  37.567  43.328  1.00 30.20           C  
ATOM   1387  OH  TYR    32      22.491  37.566  43.071  1.00 27.86           O  
ATOM   1388  N   LYS    33      27.062  34.354  43.664  1.00 30.60           N  
ATOM   1389  CA  LYS    33      26.541  33.386  42.716  1.00 30.67           C  
ATOM   1390  C   LYS    33      25.036  33.621  42.611  1.00 29.00           C  
ATOM   1391  O   LYS    33      24.353  33.610  43.634  1.00 27.20           O  
ATOM   1392  CB  LYS    33      26.804  31.963  43.218  1.00 30.54           C  
ATOM   1393  CG  LYS    33      28.261  31.518  43.131  1.00 31.84           C  
ATOM   1394  CD  LYS    33      28.444  30.104  43.651  1.00 32.67           C  
ATOM   1395  CE  LYS    33      29.915  29.685  43.643  1.00 38.32           C  
ATOM   1396  NZ  LYS    33      30.093  28.233  43.927  1.00 35.17           N  
ATOM   1397  N   PRO    34      24.527  33.902  41.397  1.00 27.53           N  
ATOM   1398  CA  PRO    34      23.093  34.023  41.131  1.00 27.92           C  
ATOM   1399  C   PRO    34      22.258  32.808  41.526  1.00 27.42           C  
ATOM   1400  O   PRO    34      21.134  32.971  42.007  1.00 26.94           O  
ATOM   1401  CB  PRO    34      23.043  34.209  39.609  1.00 28.69           C  
ATOM   1402  CG  PRO    34      24.349  34.838  39.276  1.00 28.43           C  
ATOM   1403  CD  PRO    34      25.323  34.197  40.193  1.00 27.34           C  
ATOM   1404  N   ALA    35      22.800  31.615  41.282  1.00 28.20           N  
ATOM   1405  CA  ALA    35      22.192  30.348  41.691  1.00 29.19           C  
ATOM   1406  C   ALA    35      23.291  29.440  42.234  1.00 30.41           C  
ATOM   1407  O   ALA    35      24.477  29.688  41.984  1.00 29.92           O  
ATOM   1408  CB  ALA    35      21.486  29.688  40.515  1.00 27.66           C  
ATOM   1409  N   GLU    36      22.900  28.382  42.949  1.00 31.54           N  
ATOM   1410  CA  GLU    36      23.861  27.475  43.590  1.00 33.38           C  
ATOM   1411  C   GLU    36      24.823  26.807  42.625  1.00 32.55           C  
ATOM   1412  O   GLU    36      25.968  26.559  42.979  1.00 33.40           O  
ATOM   1413  CB  GLU    36      23.150  26.386  44.381  1.00 34.20           C  
ATOM   1414  CG  GLU    36      22.389  26.881  45.598  1.00 37.06           C  
ATOM   1415  CD  GLU    36      22.094  25.766  46.602  1.00 39.82           C  
ATOM   1416  OE1 GLU    36      22.175  24.569  46.227  1.00 44.32           O  
ATOM   1417  OE2 GLU    36      21.794  26.094  47.775  1.00 47.78           O  
ATOM   1418  N   THR    37      24.351  26.510  41.419  1.00 31.80           N  
ATOM   1419  CA  THR    37      25.157  25.853  40.393  1.00 31.56           C  
ATOM   1420  C   THR    37      25.885  26.843  39.474  1.00 32.32           C  
ATOM   1421  O   THR    37      26.457  26.434  38.474  1.00 33.55           O  
ATOM   1422  CB  THR    37      24.262  24.924  39.568  1.00 31.01           C  
ATOM   1423  OG1 THR    37      23.098  25.641  39.152  1.00 31.99           O  
ATOM   1424  CG2 THR    37      23.806  23.726  40.418  1.00 31.00           C  
ATOM   1425  N   SER    38      25.883  28.134  39.826  1.00 32.65           N  
ATOM   1426  CA  SER    38      26.541  29.182  39.021  1.00 31.97           C  
ATOM   1427  C   SER    38      28.004  29.341  39.378  1.00 30.83           C  
ATOM   1428  O   SER    38      28.405  28.993  40.476  1.00 31.30           O  
ATOM   1429  CB  SER    38      25.870  30.550  39.232  1.00 31.46           C  
ATOM   1430  OG  SER    38      24.536  30.548  38.778  1.00 32.46           O  
ATOM   1431  N   MET    39      28.791  29.880  38.446  1.00 30.71           N  
ATOM   1432  CA  MET    39      30.141  30.329  38.764  1.00 28.97           C  
ATOM   1433  C   MET    39      29.976  31.552  39.652  1.00 28.65           C  
ATOM   1434  O   MET    39      28.998  32.284  39.522  1.00 27.14           O  
ATOM   1435  CB  MET    39      30.933  30.734  37.516  1.00 28.74           C  
ATOM   1436  CG  MET    39      31.363  29.598  36.573  1.00 31.41           C  
ATOM   1437  SD  MET    39      32.514  30.228  35.067  0.75 25.74          SE  
ATOM   1438  CE  MET    39      34.264  29.826  35.772  1.00 37.14           C  
ATOM   1439  N   SER    40      30.928  31.768  40.550  1.00 28.71           N  
ATOM   1440  CA  SER    40      30.961  32.977  41.347  1.00 28.93           C  
ATOM   1441  C   SER    40      31.356  34.119  40.422  1.00 29.26           C  
ATOM   1442  O   SER    40      31.856  33.886  39.321  1.00 28.27           O  
ATOM   1443  CB  SER    40      31.977  32.857  42.485  1.00 28.55           C  
ATOM   1444  OG  SER    40      33.300  32.845  41.971  1.00 31.56           O  
ATOM   1445  N   ALA    41      31.141  35.346  40.883  1.00 29.32           N  
ATOM   1446  CA  ALA    41      31.479  36.531  40.109  1.00 28.43           C  
ATOM   1447  C   ALA    41      32.928  36.492  39.643  1.00 28.87           C  
ATOM   1448  O   ALA    41      33.208  36.745  38.475  1.00 29.06           O  
ATOM   1449  CB  ALA    41      31.216  37.789  40.924  1.00 28.00           C  
ATOM   1450  N   GLU    42      33.844  36.156  40.549  1.00 30.19           N  
ATOM   1451  CA  GLU    42      35.266  36.137  40.215  1.00 32.30           C  
ATOM   1452  C   GLU    42      35.669  34.956  39.338  1.00 31.49           C  
ATOM   1453  O   GLU    42      36.549  35.098  38.495  1.00 31.64           O  
ATOM   1454  CB  GLU    42      36.150  36.217  41.468  1.00 32.29           C  
ATOM   1455  CG  GLU    42      36.145  35.016  42.371  1.00 35.81           C  
ATOM   1456  CD  GLU    42      37.144  35.156  43.514  1.00 36.28           C  
ATOM   1457  OE1 GLU    42      38.328  35.484  43.242  1.00 35.57           O  
ATOM   1458  OE2 GLU    42      36.744  34.923  44.680  1.00 43.97           O  
ATOM   1459  N   GLU    43      35.044  33.797  39.532  1.00 30.87           N  
ATOM   1460  CA  GLU    43      35.260  32.661  38.625  1.00 30.39           C  
ATOM   1461  C   GLU    43      34.845  33.040  37.214  1.00 29.35           C  
ATOM   1462  O   GLU    43      35.531  32.703  36.238  1.00 29.22           O  
ATOM   1463  CB  GLU    43      34.467  31.425  39.060  1.00 30.93           C  
ATOM   1464  CG  GLU    43      35.062  30.666  40.239  1.00 32.30           C  
ATOM   1465  CD  GLU    43      34.153  29.551  40.752  1.00 32.16           C  
ATOM   1466  OE1 GLU    43      32.930  29.604  40.535  1.00 35.30           O  
ATOM   1467  OE2 GLU    43      34.667  28.617  41.401  1.00 38.93           O  
ATOM   1468  N   LEU    44      33.722  33.747  37.111  1.00 27.81           N  
ATOM   1469  CA  LEU    44      33.205  34.170  35.813  1.00 27.14           C  
ATOM   1470  C   LEU    44      34.204  35.093  35.145  1.00 26.11           C  
ATOM   1471  O   LEU    44      34.615  34.849  34.019  1.00 26.10           O  
ATOM   1472  CB  LEU    44      31.835  34.853  35.958  1.00 27.33           C  
ATOM   1473  CG  LEU    44      31.197  35.427  34.687  1.00 26.54           C  
ATOM   1474  CD1 LEU    44      31.341  34.484  33.494  1.00 26.87           C  
ATOM   1475  CD2 LEU    44      29.729  35.714  34.941  1.00 25.50           C  
ATOM   1476  N   VAL    45      34.619  36.132  35.865  1.00 26.48           N  
ATOM   1477  CA  VAL    45      35.510  37.144  35.325  1.00 26.04           C  
ATOM   1478  C   VAL    45      36.867  36.552  34.944  1.00 27.08           C  
ATOM   1479  O   VAL    45      37.346  36.802  33.850  1.00 27.54           O  
ATOM   1480  CB  VAL    45      35.683  38.334  36.309  1.00 27.04           C  
ATOM   1481  CG1 VAL    45      36.744  39.312  35.797  1.00 25.46           C  
ATOM   1482  CG2 VAL    45      34.352  39.042  36.521  1.00 23.13           C  
ATOM   1483  N   LYS    46      37.482  35.767  35.827  1.00 28.21           N  
ATOM   1484  CA  LYS    46      38.793  35.155  35.522  1.00 29.00           C  
ATOM   1485  C   LYS    46      38.708  34.265  34.287  1.00 28.55           C  
ATOM   1486  O   LYS    46      39.629  34.250  33.464  1.00 29.07           O  
ATOM   1487  CB  LYS    46      39.324  34.321  36.690  1.00 29.20           C  
ATOM   1488  CG  LYS    46      39.776  35.118  37.886  1.00 31.60           C  
ATOM   1489  CD  LYS    46      40.299  34.197  38.968  1.00 29.66           C  
ATOM   1490  CE  LYS    46      40.389  34.916  40.294  1.00 37.54           C  
ATOM   1491  NZ  LYS    46      40.795  33.997  41.394  1.00 35.65           N  
ATOM   1492  N   HIS    47      37.616  33.505  34.172  1.00 27.91           N  
ATOM   1493  CA  HIS    47      37.432  32.622  33.016  1.00 27.17           C  
ATOM   1494  C   HIS    47      37.379  33.401  31.699  1.00 25.59           C  
ATOM   1495  O   HIS    47      37.956  32.964  30.704  1.00 26.75           O  
ATOM   1496  CB  HIS    47      36.190  31.743  33.159  1.00 27.46           C  
ATOM   1497  CG  HIS    47      35.905  30.922  31.937  1.00 28.87           C  
ATOM   1498  ND1 HIS    47      36.734  29.908  31.515  1.00 32.09           N  
ATOM   1499  CD2 HIS    47      34.908  30.996  31.025  1.00 28.90           C  
ATOM   1500  CE1 HIS    47      36.257  29.387  30.399  1.00 27.52           C  
ATOM   1501  NE2 HIS    47      35.146  30.027  30.083  1.00 28.54           N  
ATOM   1502  N   ILE    48      36.699  34.545  31.701  1.00 25.40           N  
ATOM   1503  CA  ILE    48      36.648  35.436  30.536  1.00 24.70           C  
ATOM   1504  C   ILE    48      38.065  35.852  30.154  1.00 25.30           C  
ATOM   1505  O   ILE    48      38.456  35.765  28.997  1.00 26.11           O  
ATOM   1506  CB  ILE    48      35.781  36.700  30.805  1.00 25.39           C  
ATOM   1507  CG1 ILE    48      34.294  36.324  30.910  1.00 26.97           C  
ATOM   1508  CG2 ILE    48      35.972  37.754  29.707  1.00 21.47           C  
ATOM   1509  CD1 ILE    48      33.372  37.436  31.476  1.00 21.56           C  
ATOM   1510  N   LEU    49      38.837  36.259  31.148  1.00 25.60           N  
ATOM   1511  CA  LEU    49      40.199  36.717  30.947  1.00 24.97           C  
ATOM   1512  C   LEU    49      41.170  35.634  30.482  1.00 25.95           C  
ATOM   1513  O   LEU    49      41.891  35.831  29.502  1.00 27.25           O  
ATOM   1514  CB  LEU    49      40.725  37.337  32.231  1.00 24.59           C  
ATOM   1515  CG  LEU    49      40.077  38.643  32.687  1.00 26.07           C  
ATOM   1516  CD1 LEU    49      40.707  39.082  34.017  1.00 25.43           C  
ATOM   1517  CD2 LEU    49      40.202  39.746  31.632  1.00 21.72           C  
ATOM   1518  N   THR    50      41.206  34.501  31.184  1.00 26.62           N  
ATOM   1519  CA  THR    50      42.139  33.428  30.831  1.00 26.53           C  
ATOM   1520  C   THR    50      41.768  32.721  29.518  1.00 28.19           C  
ATOM   1521  O   THR    50      42.664  32.330  28.753  1.00 29.08           O  
ATOM   1522  CB  THR    50      42.279  32.370  31.958  1.00 26.75           C  
ATOM   1523  OG1 THR    50      41.018  31.734  32.195  1.00 29.27           O  
ATOM   1524  CG2 THR    50      42.785  33.010  33.255  1.00 20.35           C  
ATOM   1525  N   SER    51      40.469  32.568  29.242  1.00 28.56           N  
ATOM   1526  CA  SER    51      40.053  31.808  28.064  1.00 29.13           C  
ATOM   1527  C   SER    51      40.431  32.521  26.777  1.00 28.90           C  
ATOM   1528  O   SER    51      40.940  31.880  25.847  1.00 30.53           O  
ATOM   1529  CB  SER    51      38.557  31.446  28.084  1.00 28.88           C  
ATOM   1530  OG  SER    51      37.727  32.590  28.069  1.00 33.02           O  
ATOM   1531  N   PHE    52      40.194  33.830  26.703  1.00 27.66           N  
ATOM   1532  CA  PHE    52      40.530  34.557  25.483  1.00 27.14           C  
ATOM   1533  C   PHE    52      42.039  34.554  25.296  1.00 27.70           C  
ATOM   1534  O   PHE    52      42.530  34.421  24.178  1.00 28.71           O  
ATOM   1535  CB  PHE    52      40.001  35.993  25.481  1.00 27.08           C  
ATOM   1536  CG  PHE    52      39.811  36.560  24.089  1.00 25.86           C  
ATOM   1537  CD1 PHE    52      40.907  36.795  23.256  1.00 25.78           C  
ATOM   1538  CD2 PHE    52      38.542  36.839  23.608  1.00 23.07           C  
ATOM   1539  CE1 PHE    52      40.725  37.299  21.977  1.00 26.17           C  
ATOM   1540  CE2 PHE    52      38.359  37.351  22.333  1.00 23.04           C  
ATOM   1541  CZ  PHE    52      39.446  37.570  21.514  1.00 23.22           C  
ATOM   1542  N   HIS    53      42.772  34.683  26.394  1.00 28.75           N  
ATOM   1543  CA  HIS    53      44.234  34.689  26.347  1.00 29.87           C  
ATOM   1544  C   HIS    53      44.799  33.336  25.861  1.00 29.22           C  
ATOM   1545  O   HIS    53      45.774  33.303  25.101  1.00 28.96           O  
ATOM   1546  CB  HIS    53      44.812  35.081  27.710  1.00 29.38           C  
ATOM   1547  CG  HIS    53      46.297  35.259  27.699  1.00 32.09           C  
ATOM   1548  ND1 HIS    53      47.161  34.324  28.221  1.00 36.75           N  
ATOM   1549  CD2 HIS    53      47.071  36.250  27.200  1.00 34.27           C  
ATOM   1550  CE1 HIS    53      48.405  34.738  28.056  1.00 36.33           C  
ATOM   1551  NE2 HIS    53      48.377  35.904  27.439  1.00 35.25           N  
ATOM   1552  N   LEU    54      44.175  32.237  26.280  1.00 28.84           N  
ATOM   1553  CA  LEU    54      44.545  30.908  25.787  1.00 29.41           C  
ATOM   1554  C   LEU    54      44.344  30.820  24.271  1.00 29.89           C  
ATOM   1555  O   LEU    54      45.283  30.469  23.530  1.00 28.10           O  
ATOM   1556  CB  LEU    54      43.746  29.812  26.501  1.00 28.57           C  
ATOM   1557  CG  LEU    54      44.049  28.359  26.102  1.00 30.83           C  
ATOM   1558  CD1 LEU    54      45.538  28.026  26.269  1.00 28.39           C  
ATOM   1559  CD2 LEU    54      43.180  27.371  26.890  1.00 30.29           C  
ATOM   1560  N   PHE    55      43.134  31.159  23.817  1.00 30.20           N  
ATOM   1561  CA  PHE    55      42.819  31.153  22.382  1.00 32.29           C  
ATOM   1562  C   PHE    55      43.787  32.023  21.577  1.00 31.95           C  
ATOM   1563  O   PHE    55      44.243  31.620  20.510  1.00 32.57           O  
ATOM   1564  CB  PHE    55      41.398  31.652  22.119  1.00 34.13           C  
ATOM   1565  CG  PHE    55      40.317  30.681  22.505  1.00 36.99           C  
ATOM   1566  CD1 PHE    55      40.343  29.372  22.063  1.00 39.85           C  
ATOM   1567  CD2 PHE    55      39.236  31.104  23.275  1.00 45.14           C  
ATOM   1568  CE1 PHE    55      39.330  28.494  22.403  1.00 44.15           C  
ATOM   1569  CE2 PHE    55      38.220  30.231  23.620  1.00 45.62           C  
ATOM   1570  CZ  PHE    55      38.263  28.923  23.179  1.00 43.03           C  
ATOM   1571  N   ALA    56      44.077  33.221  22.089  1.00 31.31           N  
ATOM   1572  CA  ALA    56      45.030  34.131  21.448  1.00 30.70           C  
ATOM   1573  C   ALA    56      46.421  33.491  21.272  1.00 29.92           C  
ATOM   1574  O   ALA    56      47.059  33.654  20.231  1.00 30.50           O  
ATOM   1575  CB  ALA    56      45.132  35.443  22.241  1.00 30.35           C  
ATOM   1576  N   ASN    57      46.879  32.749  22.274  1.00 30.14           N  
ATOM   1577  CA  ASN    57      48.161  32.034  22.164  1.00 31.35           C  
ATOM   1578  C   ASN    57      48.100  30.807  21.225  1.00 32.06           C  
ATOM   1579  O   ASN    57      49.095  30.465  20.591  1.00 32.88           O  
ATOM   1580  CB  ASN    57      48.708  31.665  23.553  1.00 31.09           C  
ATOM   1581  CG  ASN    57      49.664  32.728  24.110  1.00 33.29           C  
ATOM   1582  OD1 ASN    57      50.701  33.008  23.514  1.00 36.72           O  
ATOM   1583  ND2 ASN    57      49.326  33.305  25.261  1.00 32.00           N  
ATOM   1584  N   VAL    58      46.936  30.166  21.120  1.00 32.60           N  
ATOM   1585  CA  VAL    58      46.760  29.045  20.194  1.00 32.08           C  
ATOM   1586  C   VAL    58      46.876  29.526  18.742  1.00 32.30           C  
ATOM   1587  O   VAL    58      47.545  28.890  17.934  1.00 32.10           O  
ATOM   1588  CB  VAL    58      45.419  28.287  20.433  1.00 31.98           C  
ATOM   1589  CG1 VAL    58      45.237  27.157  19.410  1.00 29.82           C  
ATOM   1590  CG2 VAL    58      45.366  27.727  21.861  1.00 28.52           C  
ATOM   1591  N   ILE    59      46.235  30.650  18.422  1.00 32.76           N  
ATOM   1592  CA  ILE    59      46.363  31.279  17.092  1.00 33.21           C  
ATOM   1593  C   ILE    59      47.797  31.770  16.842  1.00 33.87           C  
ATOM   1594  O   ILE    59      48.332  31.642  15.741  1.00 33.61           O  
ATOM   1595  CB  ILE    59      45.427  32.500  16.938  1.00 33.99           C  
ATOM   1596  CG1 ILE    59      43.950  32.095  17.083  1.00 33.69           C  
ATOM   1597  CG2 ILE    59      45.664  33.206  15.586  1.00 31.95           C  
ATOM   1598  CD1 ILE    59      43.006  33.284  17.176  1.00 32.20           C  
ATOM   1599  N   LYS    60      48.411  32.330  17.872  1.00 35.71           N  
ATOM   1600  CA  LYS    60      49.772  32.840  17.767  1.00 37.57           C  
ATOM   1601  C   LYS    60      50.764  31.721  17.441  1.00 38.24           C  
ATOM   1602  O   LYS    60      51.604  31.872  16.562  1.00 37.60           O  
ATOM   1603  CB  LYS    60      50.174  33.557  19.062  1.00 37.54           C  
ATOM   1604  CG  LYS    60      51.655  33.883  19.189  1.00 36.89           C  
ATOM   1605  CD  LYS    60      51.907  34.811  20.361  1.00 39.39           C  
ATOM   1606  CE  LYS    60      53.381  34.926  20.678  1.00 43.88           C  
ATOM   1607  NZ  LYS    60      53.698  36.138  21.480  1.00 45.53           N  
ATOM   1608  N   GLU    61      50.662  30.603  18.150  1.00 39.86           N  
ATOM   1609  CA  GLU    61      51.580  29.486  17.934  1.00 40.82           C  
ATOM   1610  C   GLU    61      51.197  28.632  16.722  1.00 41.21           C  
ATOM   1611  O   GLU    61      52.065  28.113  16.025  1.00 41.01           O  
ATOM   1612  CB  GLU    61      51.673  28.611  19.193  1.00 40.22           C  
ATOM   1613  CG  GLU    61      52.201  29.330  20.445  1.00 41.09           C  
ATOM   1614  CD  GLU    61      53.587  29.968  20.275  1.00 41.98           C  
ATOM   1615  OE1 GLU    61      54.314  29.626  19.319  1.00 43.56           O  
ATOM   1616  OE2 GLU    61      53.956  30.816  21.114  1.00 41.89           O  
ATOM   1617  N   GLY    62      49.896  28.506  16.472  1.00 42.51           N  
ATOM   1618  CA  GLY    62      49.378  27.596  15.455  1.00 43.05           C  
ATOM   1619  C   GLY    62      49.304  26.169  15.972  1.00 43.55           C  
ATOM   1620  O   GLY    62      48.994  25.252  15.216  1.00 44.20           O  
ATOM   1621  N   ASN    63      49.576  25.996  17.266  1.00 44.07           N  
ATOM   1622  CA  ASN    63      49.674  24.692  17.917  1.00 44.21           C  
ATOM   1623  C   ASN    63      48.667  24.579  19.044  1.00 44.05           C  
ATOM   1624  O   ASN    63      48.103  25.579  19.482  1.00 43.63           O  
ATOM   1625  CB  ASN    63      51.057  24.530  18.552  1.00 43.35           C  
ATOM   1626  CG  ASN    63      52.175  24.755  17.581  1.00 46.03           C  
ATOM   1627  OD1 ASN    63      52.015  24.563  16.380  1.00 56.39           O  
ATOM   1628  ND2 ASN    63      53.329  25.158  18.093  1.00 46.14           N  
ATOM   1629  N   ALA    64      48.497  23.354  19.541  1.00 44.06           N  
ATOM   1630  CA  ALA    64      47.735  23.100  20.759  1.00 43.65           C  
ATOM   1631  C   ALA    64      48.652  23.159  21.986  1.00 42.60           C  
ATOM   1632  O   ALA    64      48.215  22.878  23.100  1.00 42.66           O  
ATOM   1633  CB  ALA    64      47.047  21.750  20.674  1.00 44.16           C  
ATOM   1634  N   SER    65      49.913  23.548  21.778  1.00 41.62           N  
ATOM   1635  CA  SER    65      50.914  23.588  22.848  1.00 40.66           C  
ATOM   1636  C   SER    65      50.624  24.576  23.992  1.00 39.74           C  
ATOM   1637  O   SER    65      50.986  24.293  25.121  1.00 39.46           O  
ATOM   1638  CB  SER    65      52.332  23.802  22.273  1.00 39.86           C  
ATOM   1639  OG  SER    65      52.479  25.053  21.630  1.00 38.52           O  
ATOM   1640  N   PRO    66      49.983  25.731  23.718  1.00 39.50           N  
ATOM   1641  CA  PRO    66      49.632  26.610  24.848  1.00 39.62           C  
ATOM   1642  C   PRO    66      48.674  26.005  25.903  1.00 40.52           C  
ATOM   1643  O   PRO    66      48.529  26.577  26.989  1.00 40.07           O  
ATOM   1644  CB  PRO    66      48.999  27.830  24.163  1.00 39.89           C  
ATOM   1645  CG  PRO    66      49.525  27.792  22.756  1.00 39.12           C  
ATOM   1646  CD  PRO    66      49.599  26.337  22.428  1.00 39.03           C  
ATOM   1647  N   PHE    67      48.033  24.874  25.599  1.00 41.75           N  
ATOM   1648  CA  PHE    67      47.273  24.136  26.617  1.00 43.43           C  
ATOM   1649  C   PHE    67      48.212  23.489  27.643  1.00 44.65           C  
ATOM   1650  O   PHE    67      47.832  23.293  28.801  1.00 44.48           O  
ATOM   1651  CB  PHE    67      46.384  23.053  25.996  1.00 44.15           C  
ATOM   1652  CG  PHE    67      45.455  23.559  24.931  1.00 45.35           C  
ATOM   1653  CD1 PHE    67      44.694  24.703  25.134  1.00 48.97           C  
ATOM   1654  CD2 PHE    67      45.327  22.883  23.728  1.00 47.36           C  
ATOM   1655  CE1 PHE    67      43.834  25.171  24.148  1.00 47.77           C  
ATOM   1656  CE2 PHE    67      44.476  23.353  22.740  1.00 47.83           C  
ATOM   1657  CZ  PHE    67      43.728  24.495  22.955  1.00 44.88           C  
ATOM   1658  N   GLN    68      49.425  23.149  27.209  1.00 46.69           N  
ATOM   1659  CA  GLN    68      50.444  22.560  28.089  1.00 48.37           C  
ATOM   1660  C   GLN    68      50.999  23.583  29.073  1.00 50.08           C  
ATOM   1661  O   GLN    68      51.458  23.216  30.156  1.00 50.91           O  
ATOM   1662  CB  GLN    68      51.607  21.962  27.275  1.00 48.44           C  
ATOM   1663  CG  GLN    68      51.370  20.560  26.709  1.00 49.99           C  
ATOM   1664  CD  GLN    68      50.026  20.407  26.019  1.00 50.43           C  
ATOM   1665  OE1 GLN    68      48.982  20.371  26.673  1.00 50.63           O  
ATOM   1666  NE2 GLN    68      50.047  20.305  24.691  1.00 50.53           N  
ATOM   1667  N   ASN    69      50.974  24.859  28.688  1.00 51.88           N  
ATOM   1668  CA  ASN    69      51.449  25.938  29.552  1.00 53.28           C  
ATOM   1669  C   ASN    69      50.511  26.154  30.740  1.00 54.71           C  
ATOM   1670  O   ASN    69      49.505  26.850  30.618  1.00 54.91           O  
ATOM   1671  CB  ASN    69      51.588  27.240  28.752  1.00 53.14           C  
ATOM   1672  N   LYS    70      50.835  25.536  31.874  1.00 57.03           N  
ATOM   1673  CA  LYS    70      50.099  25.758  33.119  1.00 58.38           C  
ATOM   1674  C   LYS    70      50.589  27.059  33.750  1.00 59.82           C  
ATOM   1675  O   LYS    70      51.596  27.058  34.465  1.00 59.85           O  
ATOM   1676  CB  LYS    70      50.324  24.599  34.092  1.00 58.61           C  
ATOM   1677  N   GLN    71      49.889  28.161  33.473  1.00 61.09           N  
ATOM   1678  CA  GLN    71      50.291  29.486  33.963  1.00 62.37           C  
ATOM   1679  C   GLN    71      49.654  29.793  35.321  1.00 63.43           C  
ATOM   1680  O   GLN    71      48.464  30.126  35.397  1.00 64.18           O  
ATOM   1681  CB  GLN    71      49.910  30.572  32.952  1.00 62.69           C  
ATOM   1682  N   GLU    72      50.451  29.679  36.386  1.00 63.24           N  
ATOM   1683  CA  GLU    72      49.984  29.958  37.746  1.00 62.89           C  
ATOM   1684  C   GLU    72      49.973  31.469  38.008  1.00 62.36           C  
ATOM   1685  O   GLU    72      50.992  32.045  38.403  1.00 62.30           O  
ATOM   1686  CB  GLU    72      50.871  29.246  38.777  1.00 62.86           C  
ATOM   1687  N   GLU    73      48.824  32.106  37.772  1.00 60.95           N  
ATOM   1688  CA  GLU    73      48.670  33.540  38.035  1.00 59.65           C  
ATOM   1689  C   GLU    73      48.477  33.737  39.540  1.00 57.43           C  
ATOM   1690  O   GLU    73      47.552  33.173  40.130  1.00 57.80           O  
ATOM   1691  CB  GLU    73      47.484  34.123  37.250  1.00 60.09           C  
ATOM   1692  CG  GLU    73      47.401  35.662  37.243  1.00 60.77           C  
ATOM   1693  CD  GLU    73      48.532  36.354  36.463  1.00 62.91           C  
ATOM   1694  OE1 GLU    73      49.224  35.689  35.663  1.00 64.78           O  
ATOM   1695  OE2 GLU    73      48.720  37.577  36.645  1.00 61.24           O  
ATOM   1696  N   THR    74      49.361  34.526  40.149  1.00 54.02           N  
ATOM   1697  CA  THR    74      49.358  34.754  41.597  1.00 52.74           C  
ATOM   1698  C   THR    74      48.387  35.863  42.044  1.00 51.44           C  
ATOM   1699  O   THR    74      47.943  35.871  43.196  1.00 51.74           O  
ATOM   1700  CB  THR    74      50.775  35.105  42.101  1.00 52.41           C  
ATOM   1701  N   GLU    75      48.058  36.784  41.135  1.00 49.36           N  
ATOM   1702  CA  GLU    75      47.214  37.939  41.455  1.00 47.02           C  
ATOM   1703  C   GLU    75      45.759  37.533  41.711  1.00 45.84           C  
ATOM   1704  O   GLU    75      45.231  36.654  41.029  1.00 46.17           O  
ATOM   1705  CB  GLU    75      47.283  38.962  40.312  1.00 46.52           C  
ATOM   1706  CG  GLU    75      46.513  40.248  40.573  1.00 44.62           C  
ATOM   1707  CD  GLU    75      47.058  41.016  41.759  1.00 42.04           C  
ATOM   1708  OE1 GLU    75      48.292  41.233  41.800  1.00 33.54           O  
ATOM   1709  OE2 GLU    75      46.253  41.402  42.637  1.00 35.78           O  
ATOM   1710  N   THR    76      45.133  38.178  42.697  1.00 44.18           N  
ATOM   1711  CA  THR    76      43.737  37.915  43.069  1.00 42.84           C  
ATOM   1712  C   THR    76      42.803  39.105  42.845  1.00 41.12           C  
ATOM   1713  O   THR    76      41.591  38.923  42.736  1.00 41.75           O  
ATOM   1714  CB  THR    76      43.627  37.523  44.548  1.00 43.10           C  
ATOM   1715  OG1 THR    76      44.363  38.464  45.345  1.00 44.47           O  
ATOM   1716  CG2 THR    76      44.167  36.111  44.770  1.00 43.34           C  
ATOM   1717  N   ASP    77      43.351  40.318  42.805  1.00 38.64           N  
ATOM   1718  CA  ASP    77      42.547  41.494  42.522  1.00 36.40           C  
ATOM   1719  C   ASP    77      42.053  41.379  41.091  1.00 34.51           C  
ATOM   1720  O   ASP    77      42.855  41.330  40.155  1.00 32.72           O  
ATOM   1721  CB  ASP    77      43.351  42.785  42.726  1.00 36.29           C  
ATOM   1722  CG  ASP    77      42.471  44.032  42.705  1.00 36.98           C  
ATOM   1723  OD1 ASP    77      41.907  44.355  41.639  1.00 32.41           O  
ATOM   1724  OD2 ASP    77      42.349  44.695  43.757  1.00 42.30           O  
ATOM   1725  N   LEU    78      40.728  41.321  40.945  1.00 33.17           N  
ATOM   1726  CA  LEU    78      40.084  41.188  39.644  1.00 31.83           C  
ATOM   1727  C   LEU    78      40.447  42.312  38.690  1.00 30.92           C  
ATOM   1728  O   LEU    78      40.630  42.063  37.501  1.00 30.51           O  
ATOM   1729  CB  LEU    78      38.554  41.136  39.777  1.00 31.06           C  
ATOM   1730  CG  LEU    78      37.884  39.831  40.213  1.00 30.15           C  
ATOM   1731  CD1 LEU    78      36.382  39.991  40.079  1.00 28.75           C  
ATOM   1732  CD2 LEU    78      38.360  38.634  39.408  1.00 26.53           C  
ATOM   1733  N   ASN    79      40.528  43.540  39.205  1.00 31.00           N  
ATOM   1734  CA  ASN    79      40.795  44.709  38.361  1.00 31.40           C  
ATOM   1735  C   ASN    79      42.207  44.677  37.806  1.00 30.64           C  
ATOM   1736  O   ASN    79      42.430  45.047  36.659  1.00 32.32           O  
ATOM   1737  CB  ASN    79      40.519  46.014  39.113  1.00 30.97           C  
ATOM   1738  CG  ASN    79      39.047  46.191  39.445  1.00 32.77           C  
ATOM   1739  OD1 ASN    79      38.169  45.793  38.669  1.00 34.47           O  
ATOM   1740  ND2 ASN    79      38.767  46.792  40.597  1.00 31.40           N  
ATOM   1741  N   VAL    80      43.145  44.198  38.613  1.00 30.86           N  
ATOM   1742  CA  VAL    80      44.527  43.995  38.176  1.00 30.48           C  
ATOM   1743  C   VAL    80      44.626  42.802  37.208  1.00 30.68           C  
ATOM   1744  O   VAL    80      45.369  42.850  36.230  1.00 32.36           O  
ATOM   1745  CB  VAL    80      45.453  43.767  39.378  1.00 30.21           C  
ATOM   1746  CG1 VAL    80      46.886  43.546  38.914  1.00 28.13           C  
ATOM   1747  CG2 VAL    80      45.352  44.942  40.345  1.00 27.39           C  
ATOM   1748  N   LEU    81      43.884  41.731  37.480  1.00 30.58           N  
ATOM   1749  CA  LEU    81      43.817  40.603  36.546  1.00 30.81           C  
ATOM   1750  C   LEU    81      43.247  41.057  35.200  1.00 30.95           C  
ATOM   1751  O   LEU    81      43.794  40.737  34.148  1.00 31.51           O  
ATOM   1752  CB  LEU    81      42.979  39.451  37.110  1.00 30.49           C  
ATOM   1753  CG  LEU    81      43.664  38.568  38.154  1.00 32.45           C  
ATOM   1754  CD1 LEU    81      42.657  37.683  38.888  1.00 28.60           C  
ATOM   1755  CD2 LEU    81      44.748  37.729  37.503  1.00 32.31           C  
ATOM   1756  N   ALA    82      42.162  41.827  35.243  1.00 31.30           N  
ATOM   1757  CA  ALA    82      41.511  42.328  34.029  1.00 29.87           C  
ATOM   1758  C   ALA    82      42.455  43.178  33.184  1.00 29.55           C  
ATOM   1759  O   ALA    82      42.555  42.976  31.975  1.00 29.00           O  
ATOM   1760  CB  ALA    82      40.252  43.108  34.382  1.00 27.98           C  
ATOM   1761  N   LYS    83      43.145  44.114  33.827  1.00 30.62           N  
ATOM   1762  CA  LYS    83      44.095  45.003  33.147  1.00 32.82           C  
ATOM   1763  C   LYS    83      45.278  44.247  32.545  1.00 31.38           C  
ATOM   1764  O   LYS    83      45.603  44.429  31.383  1.00 31.61           O  
ATOM   1765  CB  LYS    83      44.612  46.060  34.122  1.00 33.23           C  
ATOM   1766  CG  LYS    83      45.524  47.089  33.488  1.00 35.47           C  
ATOM   1767  CD  LYS    83      45.840  48.216  34.451  1.00 36.43           C  
ATOM   1768  CE  LYS    83      46.837  49.196  33.841  1.00 42.15           C  
ATOM   1769  NZ  LYS    83      47.235  50.260  34.808  1.00 48.16           N  
ATOM   1770  N   THR    84      45.915  43.410  33.352  1.00 31.31           N  
ATOM   1771  CA  THR    84      47.066  42.615  32.918  1.00 31.31           C  
ATOM   1772  C   THR    84      46.767  41.681  31.742  1.00 30.31           C  
ATOM   1773  O   THR    84      47.511  41.650  30.762  1.00 29.48           O  
ATOM   1774  CB  THR    84      47.595  41.795  34.095  1.00 30.96           C  
ATOM   1775  OG1 THR    84      48.174  42.693  35.047  1.00 32.33           O  
ATOM   1776  CG2 THR    84      48.648  40.779  33.637  1.00 34.24           C  
ATOM   1777  N   TYR    85      45.676  40.927  31.847  1.00 30.38           N  
ATOM   1778  CA  TYR    85      45.284  39.982  30.797  1.00 30.35           C  
ATOM   1779  C   TYR    85      44.820  40.665  29.510  1.00 29.76           C  
ATOM   1780  O   TYR    85      44.976  40.115  28.423  1.00 29.50           O  
ATOM   1781  CB  TYR    85      44.195  39.038  31.306  1.00 31.62           C  
ATOM   1782  CG  TYR    85      44.726  37.797  31.993  1.00 31.20           C  
ATOM   1783  CD1 TYR    85      45.237  36.746  31.245  1.00 32.21           C  
ATOM   1784  CD2 TYR    85      44.680  37.656  33.381  1.00 32.86           C  
ATOM   1785  CE1 TYR    85      45.701  35.590  31.850  1.00 32.84           C  
ATOM   1786  CE2 TYR    85      45.147  36.493  34.003  1.00 32.36           C  
ATOM   1787  CZ  TYR    85      45.657  35.467  33.229  1.00 33.24           C  
ATOM   1788  OH  TYR    85      46.137  34.309  33.811  1.00 34.89           O  
ATOM   1789  N   THR    86      44.235  41.848  29.638  1.00 31.05           N  
ATOM   1790  CA  THR    86      43.815  42.641  28.486  1.00 31.05           C  
ATOM   1791  C   THR    86      45.045  43.122  27.733  1.00 32.15           C  
ATOM   1792  O   THR    86      45.109  42.994  26.512  1.00 32.75           O  
ATOM   1793  CB  THR    86      42.918  43.820  28.928  1.00 30.81           C  
ATOM   1794  OG1 THR    86      41.726  43.284  29.508  1.00 29.76           O  
ATOM   1795  CG2 THR    86      42.532  44.732  27.760  1.00 26.40           C  
ATOM   1796  N   GLU    87      46.025  43.652  28.471  1.00 32.42           N  
ATOM   1797  CA  GLU    87      47.300  44.084  27.899  1.00 33.13           C  
ATOM   1798  C   GLU    87      48.047  42.928  27.211  1.00 31.43           C  
ATOM   1799  O   GLU    87      48.576  43.091  26.114  1.00 30.84           O  
ATOM   1800  CB  GLU    87      48.193  44.737  28.977  1.00 33.57           C  
ATOM   1801  CG  GLU    87      47.674  46.098  29.487  1.00 36.24           C  
ATOM   1802  CD  GLU    87      48.430  46.649  30.705  1.00 36.39           C  
ATOM   1803  OE1 GLU    87      49.213  45.898  31.339  1.00 42.87           O  
ATOM   1804  OE2 GLU    87      48.224  47.844  31.039  1.00 41.68           O  
ATOM   1805  N   LYS    88      48.086  41.769  27.857  1.00 30.05           N  
ATOM   1806  CA  LYS    88      48.724  40.586  27.275  1.00 31.07           C  
ATOM   1807  C   LYS    88      48.015  40.085  26.007  1.00 29.92           C  
ATOM   1808  O   LYS    88      48.669  39.628  25.061  1.00 30.19           O  
ATOM   1809  CB  LYS    88      48.768  39.444  28.295  1.00 31.28           C  
ATOM   1810  CG  LYS    88      49.807  39.588  29.405  1.00 32.74           C  
ATOM   1811  CD  LYS    88      49.487  38.619  30.542  1.00 34.44           C  
ATOM   1812  CE  LYS    88      50.726  38.125  31.283  1.00 39.86           C  
ATOM   1813  NZ  LYS    88      51.268  39.116  32.264  1.00 38.26           N  
ATOM   1814  N   THR    89      46.686  40.150  26.003  1.00 28.30           N  
ATOM   1815  CA  THR    89      45.907  39.659  24.876  1.00 26.91           C  
ATOM   1816  C   THR    89      45.994  40.627  23.697  1.00 26.04           C  
ATOM   1817  O   THR    89      46.155  40.197  22.563  1.00 25.57           O  
ATOM   1818  CB  THR    89      44.432  39.370  25.276  1.00 26.83           C  
ATOM   1819  OG1 THR    89      44.402  38.387  26.321  1.00 26.62           O  
ATOM   1820  CG2 THR    89      43.649  38.837  24.091  1.00 21.94           C  
ATOM   1821  N   VAL    90      45.916  41.928  23.970  1.00 25.73           N  
ATOM   1822  CA  VAL    90      46.100  42.954  22.935  1.00 24.97           C  
ATOM   1823  C   VAL    90      47.491  42.846  22.274  1.00 25.21           C  
ATOM   1824  O   VAL    90      47.625  42.875  21.044  1.00 24.21           O  
ATOM   1825  CB  VAL    90      45.922  44.368  23.530  1.00 26.15           C  
ATOM   1826  CG1 VAL    90      46.342  45.465  22.513  1.00 25.78           C  
ATOM   1827  CG2 VAL    90      44.477  44.564  24.014  1.00 24.53           C  
ATOM   1828  N   ALA    91      48.522  42.690  23.092  1.00 24.60           N  
ATOM   1829  CA  ALA    91      49.883  42.534  22.583  1.00 25.64           C  
ATOM   1830  C   ALA    91      49.993  41.348  21.616  1.00 27.64           C  
ATOM   1831  O   ALA    91      50.684  41.436  20.600  1.00 29.22           O  
ATOM   1832  CB  ALA    91      50.884  42.412  23.746  1.00 24.73           C  
ATOM   1833  N   ILE    92      49.284  40.255  21.896  1.00 29.04           N  
ATOM   1834  CA  ILE    92      49.251  39.131  20.956  1.00 29.11           C  
ATOM   1835  C   ILE    92      48.443  39.481  19.694  1.00 30.76           C  
ATOM   1836  O   ILE    92      48.935  39.307  18.568  1.00 31.05           O  
ATOM   1837  CB  ILE    92      48.682  37.846  21.579  1.00 29.24           C  
ATOM   1838  CG1 ILE    92      49.595  37.340  22.711  1.00 30.86           C  
ATOM   1839  CG2 ILE    92      48.552  36.775  20.506  1.00 23.58           C  
ATOM   1840  CD1 ILE    92      49.028  36.148  23.491  1.00 28.37           C  
ATOM   1841  N   LEU    93      47.221  39.983  19.890  1.00 30.68           N  
ATOM   1842  CA  LEU    93      46.329  40.312  18.782  1.00 31.19           C  
ATOM   1843  C   LEU    93      46.942  41.317  17.798  1.00 33.19           C  
ATOM   1844  O   LEU    93      46.804  41.152  16.584  1.00 32.19           O  
ATOM   1845  CB  LEU    93      44.981  40.836  19.305  1.00 30.38           C  
ATOM   1846  CG  LEU    93      44.072  39.867  20.066  1.00 28.57           C  
ATOM   1847  CD1 LEU    93      42.719  40.515  20.315  1.00 27.89           C  
ATOM   1848  CD2 LEU    93      43.904  38.560  19.325  1.00 24.19           C  
ATOM   1849  N   GLU    94      47.626  42.337  18.330  1.00 35.21           N  
ATOM   1850  CA  GLU    94      48.307  43.369  17.523  1.00 37.43           C  
ATOM   1851  C   GLU    94      49.279  42.824  16.477  1.00 38.02           C  
ATOM   1852  O   GLU    94      49.540  43.469  15.471  1.00 39.24           O  
ATOM   1853  CB  GLU    94      49.157  44.276  18.417  1.00 37.45           C  
ATOM   1854  CG  GLU    94      48.437  45.346  19.215  1.00 39.62           C  
ATOM   1855  CD  GLU    94      49.393  46.060  20.179  1.00 40.91           C  
ATOM   1856  OE1 GLU    94      50.569  45.626  20.285  1.00 44.33           O  
ATOM   1857  OE2 GLU    94      48.981  47.052  20.823  1.00 44.87           O  
ATOM   1858  N   GLN    95      49.868  41.672  16.757  1.00 38.62           N  
ATOM   1859  CA  GLN    95      50.925  41.131  15.921  1.00 39.16           C  
ATOM   1860  C   GLN    95      50.427  40.055  14.970  1.00 39.45           C  
ATOM   1861  O   GLN    95      51.135  39.700  14.038  1.00 40.62           O  
ATOM   1862  CB  GLN    95      52.020  40.554  16.816  1.00 40.08           C  
ATOM   1863  CG  GLN    95      52.579  41.550  17.832  1.00 42.36           C  
ATOM   1864  CD  GLN    95      53.520  42.551  17.202  1.00 46.73           C  
ATOM   1865  OE1 GLN    95      53.167  43.716  16.994  1.00 45.61           O  
ATOM   1866  NE2 GLN    95      54.729  42.096  16.877  1.00 50.68           N  
ATOM   1867  N   LEU    96      49.215  39.540  15.194  1.00 39.81           N  
ATOM   1868  CA  LEU    96      48.690  38.454  14.376  1.00 39.64           C  
ATOM   1869  C   LEU    96      48.600  38.845  12.906  1.00 40.14           C  
ATOM   1870  O   LEU    96      47.997  39.860  12.560  1.00 41.09           O  
ATOM   1871  CB  LEU    96      47.323  37.991  14.884  1.00 40.07           C  
ATOM   1872  CG  LEU    96      47.325  37.192  16.188  1.00 36.48           C  
ATOM   1873  CD1 LEU    96      45.897  36.863  16.590  1.00 34.41           C  
ATOM   1874  CD2 LEU    96      48.160  35.932  16.053  1.00 34.32           C  
ATOM   1875  N   THR    97      49.214  38.020  12.060  1.00 40.77           N  
ATOM   1876  CA  THR    97      49.279  38.234  10.615  1.00 40.51           C  
ATOM   1877  C   THR    97      48.149  37.480   9.901  1.00 40.99           C  
ATOM   1878  O   THR    97      47.577  36.530  10.442  1.00 40.42           O  
ATOM   1879  CB  THR    97      50.644  37.755  10.051  1.00 40.10           C  
ATOM   1880  OG1 THR    97      50.761  36.336  10.198  1.00 40.62           O  
ATOM   1881  CG2 THR    97      51.796  38.419  10.788  1.00 38.60           C  
ATOM   1882  N   GLU    98      47.826  37.916   8.688  1.00 41.70           N  
ATOM   1883  CA  GLU    98      46.781  37.269   7.889  1.00 42.96           C  
ATOM   1884  C   GLU    98      47.103  35.792   7.645  1.00 42.45           C  
ATOM   1885  O   GLU    98      46.204  34.969   7.536  1.00 42.13           O  
ATOM   1886  CB  GLU    98      46.577  38.023   6.565  1.00 43.80           C  
ATOM   1887  CG  GLU    98      45.735  39.297   6.722  1.00 46.73           C  
ATOM   1888  CD  GLU    98      44.267  38.992   6.996  1.00 51.55           C  
ATOM   1889  OE1 GLU    98      43.648  38.291   6.166  1.00 53.83           O  
ATOM   1890  OE2 GLU    98      43.731  39.443   8.037  1.00 53.34           O  
ATOM   1891  N   GLU    99      48.396  35.478   7.588  1.00 42.79           N  
ATOM   1892  CA  GLU    99      48.895  34.105   7.480  1.00 43.72           C  
ATOM   1893  C   GLU    99      48.494  33.277   8.694  1.00 41.44           C  
ATOM   1894  O   GLU    99      48.041  32.136   8.555  1.00 40.91           O  
ATOM   1895  CB  GLU    99      50.427  34.128   7.368  1.00 44.27           C  
ATOM   1896  CG  GLU    99      51.118  32.763   7.344  1.00 47.94           C  
ATOM   1897  CD  GLU    99      52.606  32.854   7.693  1.00 48.92           C  
ATOM   1898  OE1 GLU    99      52.937  33.477   8.732  1.00 61.99           O  
ATOM   1899  OE2 GLU    99      53.440  32.296   6.939  1.00 52.94           O  
ATOM   1900  N   GLN   100      48.693  33.847   9.883  1.00 39.56           N  
ATOM   1901  CA  GLN   100      48.308  33.198  11.140  1.00 37.57           C  
ATOM   1902  C   GLN   100      46.789  33.034  11.271  1.00 35.88           C  
ATOM   1903  O   GLN   100      46.315  32.075  11.865  1.00 34.56           O  
ATOM   1904  CB  GLN   100      48.865  33.972  12.335  1.00 37.95           C  
ATOM   1905  CG  GLN   100      50.361  33.753  12.560  1.00 35.36           C  
ATOM   1906  CD  GLN   100      50.928  34.653  13.650  1.00 37.02           C  
ATOM   1907  OE1 GLN   100      50.688  35.861  13.655  1.00 35.51           O  
ATOM   1908  NE2 GLN   100      51.688  34.064  14.577  1.00 28.77           N  
ATOM   1909  N   LEU   101      46.041  33.973  10.700  1.00 36.17           N  
ATOM   1910  CA  LEU   101      44.583  33.911  10.672  1.00 36.04           C  
ATOM   1911  C   LEU   101      44.073  32.913   9.633  1.00 37.42           C  
ATOM   1912  O   LEU   101      43.082  32.221   9.870  1.00 38.35           O  
ATOM   1913  CB  LEU   101      44.009  35.305  10.394  1.00 35.43           C  
ATOM   1914  CG  LEU   101      44.231  36.320  11.524  1.00 34.17           C  
ATOM   1915  CD1 LEU   101      44.014  37.731  11.053  1.00 35.54           C  
ATOM   1916  CD2 LEU   101      43.314  36.006  12.707  1.00 29.97           C  
ATOM   1917  N   ASP   102      44.753  32.842   8.488  1.00 38.87           N  
ATOM   1918  CA  ASP   102      44.334  31.980   7.378  1.00 39.41           C  
ATOM   1919  C   ASP   102      44.687  30.510   7.582  1.00 39.52           C  
ATOM   1920  O   ASP   102      43.960  29.630   7.119  1.00 40.06           O  
ATOM   1921  CB  ASP   102      44.945  32.476   6.060  1.00 40.18           C  
ATOM   1922  CG  ASP   102      44.274  33.742   5.538  1.00 41.84           C  
ATOM   1923  OD1 ASP   102      43.098  33.969   5.877  1.00 44.15           O  
ATOM   1924  OD2 ASP   102      44.916  34.501   4.776  1.00 44.89           O  
ATOM   1925  N   ARG   103      45.780  30.242   8.288  1.00 39.77           N  
ATOM   1926  CA  ARG   103      46.285  28.875   8.425  1.00 40.80           C  
ATOM   1927  C   ARG   103      45.443  27.996   9.334  1.00 41.55           C  
ATOM   1928  O   ARG   103      44.794  28.468  10.260  1.00 41.57           O  
ATOM   1929  CB  ARG   103      47.731  28.872   8.931  1.00 40.90           C  
ATOM   1930  CG  ARG   103      47.888  29.243  10.392  1.00 42.29           C  
ATOM   1931  CD  ARG   103      49.339  29.471  10.724  1.00 44.86           C  
ATOM   1932  NE  ARG   103      49.550  29.752  12.139  1.00 45.75           N  
ATOM   1933  CZ  ARG   103      50.715  30.125  12.661  1.00 47.88           C  
ATOM   1934  NH1 ARG   103      51.797  30.276  11.895  1.00 46.92           N  
ATOM   1935  NH2 ARG   103      50.802  30.357  13.962  1.00 48.77           N  
ATOM   1936  N   GLU   104      45.500  26.700   9.059  1.00 42.30           N  
ATOM   1937  CA  GLU   104      44.841  25.683   9.859  1.00 42.85           C  
ATOM   1938  C   GLU   104      45.654  25.353  11.112  1.00 41.15           C  
ATOM   1939  O   GLU   104      46.859  25.119  11.035  1.00 40.82           O  
ATOM   1940  CB  GLU   104      44.662  24.412   9.025  1.00 43.55           C  
ATOM   1941  CG  GLU   104      43.506  23.559   9.459  1.00 48.29           C  
ATOM   1942  CD  GLU   104      42.933  22.766   8.320  1.00 54.58           C  
ATOM   1943  OE1 GLU   104      43.648  21.883   7.807  1.00 57.58           O  
ATOM   1944  OE2 GLU   104      41.772  23.036   7.941  1.00 58.33           O  
ATOM   1945  N   ILE   105      44.980  25.348  12.258  1.00 40.26           N  
ATOM   1946  CA  ILE   105      45.561  24.903  13.517  1.00 39.85           C  
ATOM   1947  C   ILE   105      45.102  23.459  13.741  1.00 40.87           C  
ATOM   1948  O   ILE   105      43.896  23.195  13.806  1.00 38.41           O  
ATOM   1949  CB  ILE   105      45.100  25.787  14.698  1.00 39.56           C  
ATOM   1950  CG1 ILE   105      45.389  27.263  14.410  1.00 41.36           C  
ATOM   1951  CG2 ILE   105      45.783  25.371  15.987  1.00 36.65           C  
ATOM   1952  CD1 ILE   105      44.838  28.207  15.451  1.00 38.91           C  
ATOM   1953  N   ASP   106      46.055  22.530  13.838  1.00 43.16           N  
ATOM   1954  CA  ASP   106      45.735  21.110  14.079  1.00 45.33           C  
ATOM   1955  C   ASP   106      45.508  20.819  15.575  1.00 46.30           C  
ATOM   1956  O   ASP   106      46.472  20.721  16.343  1.00 47.07           O  
ATOM   1957  CB  ASP   106      46.851  20.206  13.529  1.00 45.75           C  
ATOM   1958  CG  ASP   106      46.547  18.715  13.689  1.00 48.90           C  
ATOM   1959  OD1 ASP   106      45.436  18.361  14.159  1.00 54.25           O  
ATOM   1960  OD2 ASP   106      47.426  17.896  13.340  1.00 48.22           O  
ATOM   1961  N   LEU   107      44.242  20.665  15.974  1.00 47.64           N  
ATOM   1962  CA  LEU   107      43.881  20.387  17.375  1.00 48.79           C  
ATOM   1963  C   LEU   107      43.225  19.004  17.581  1.00 49.78           C  
ATOM   1964  O   LEU   107      42.345  18.605  16.814  1.00 51.17           O  
ATOM   1965  CB  LEU   107      42.946  21.482  17.904  1.00 48.93           C  
ATOM   1966  CG  LEU   107      43.479  22.915  17.843  1.00 48.72           C  
ATOM   1967  CD1 LEU   107      42.485  23.893  18.457  1.00 47.04           C  
ATOM   1968  CD2 LEU   107      44.823  23.024  18.539  1.00 50.50           C  
ATOM   1969  N   THR   108      43.654  18.293  18.630  1.00 49.87           N  
ATOM   1970  CA  THR   108      43.136  16.954  18.974  1.00 48.10           C  
ATOM   1971  C   THR   108      41.608  16.879  18.933  1.00 48.72           C  
ATOM   1972  O   THR   108      41.034  16.018  18.261  1.00 48.58           O  
ATOM   1973  CB  THR   108      43.602  16.500  20.395  1.00 48.19           C  
ATOM   1974  OG1 THR   108      43.218  17.476  21.378  1.00 40.35           O  
ATOM   1975  CG2 THR   108      45.114  16.291  20.439  1.00 45.16           C  
ATOM   1976  N   LYS   114      40.560  20.285  13.549  1.00 48.83           N  
ATOM   1977  CA  LYS   114      41.339  21.284  12.829  1.00 47.35           C  
ATOM   1978  C   LYS   114      40.493  22.541  12.660  1.00 45.69           C  
ATOM   1979  O   LYS   114      39.291  22.459  12.389  1.00 45.34           O  
ATOM   1980  CB  LYS   114      41.802  20.739  11.475  1.00 46.66           C  
ATOM   1981  N   VAL   115      41.122  23.699  12.841  1.00 42.98           N  
ATOM   1982  CA  VAL   115      40.424  24.983  12.796  1.00 40.69           C  
ATOM   1983  C   VAL   115      41.403  26.064  12.356  1.00 37.96           C  
ATOM   1984  O   VAL   115      42.580  26.010  12.700  1.00 37.13           O  
ATOM   1985  CB  VAL   115      39.827  25.330  14.188  1.00 41.29           C  
ATOM   1986  CG1 VAL   115      40.938  25.423  15.230  1.00 41.11           C  
ATOM   1987  CG2 VAL   115      39.014  26.625  14.141  1.00 41.31           C  
ATOM   1988  N   THR   116      40.924  27.018  11.565  1.00 35.83           N  
ATOM   1989  CA  THR   116      41.747  28.147  11.129  1.00 34.25           C  
ATOM   1990  C   THR   116      41.888  29.156  12.249  1.00 34.16           C  
ATOM   1991  O   THR   116      40.982  29.294  13.064  1.00 34.64           O  
ATOM   1992  CB  THR   116      41.095  28.887   9.978  1.00 34.35           C  
ATOM   1993  OG1 THR   116      39.768  29.268  10.376  1.00 33.55           O  
ATOM   1994  CG2 THR   116      41.045  28.007   8.736  1.00 26.14           C  
ATOM   1995  N   GLY   117      43.000  29.883  12.275  1.00 33.53           N  
ATOM   1996  CA  GLY   117      43.191  30.940  13.265  1.00 32.87           C  
ATOM   1997  C   GLY   117      41.993  31.880  13.316  1.00 32.75           C  
ATOM   1998  O   GLY   117      41.549  32.261  14.400  1.00 32.20           O  
ATOM   1999  N   ARG   118      41.468  32.232  12.139  1.00 33.22           N  
ATOM   2000  CA  ARG   118      40.315  33.129  12.006  1.00 34.94           C  
ATOM   2001  C   ARG   118      39.071  32.565  12.685  1.00 33.27           C  
ATOM   2002  O   ARG   118      38.391  33.268  13.432  1.00 34.97           O  
ATOM   2003  CB  ARG   118      40.008  33.398  10.528  1.00 34.63           C  
ATOM   2004  CG  ARG   118      39.075  34.578  10.287  1.00 38.04           C  
ATOM   2005  CD  ARG   118      38.912  34.917   8.796  1.00 41.22           C  
ATOM   2006  NE  ARG   118      40.200  35.077   8.112  1.00 48.85           N  
ATOM   2007  CZ  ARG   118      41.000  36.138   8.220  1.00 48.59           C  
ATOM   2008  NH1 ARG   118      40.677  37.176   8.988  1.00 49.41           N  
ATOM   2009  NH2 ARG   118      42.145  36.158   7.557  1.00 48.99           N  
ATOM   2010  N   ALA   119      38.770  31.298  12.427  1.00 30.92           N  
ATOM   2011  CA  ALA   119      37.577  30.682  12.994  1.00 29.20           C  
ATOM   2012  C   ALA   119      37.694  30.522  14.527  1.00 28.24           C  
ATOM   2013  O   ALA   119      36.694  30.620  15.245  1.00 27.02           O  
ATOM   2014  CB  ALA   119      37.300  29.361  12.328  1.00 29.59           C  
ATOM   2015  N   LEU   120      38.907  30.297  15.027  1.00 26.93           N  
ATOM   2016  CA  LEU   120      39.125  30.231  16.467  1.00 28.00           C  
ATOM   2017  C   LEU   120      39.018  31.640  17.102  1.00 27.86           C  
ATOM   2018  O   LEU   120      38.633  31.771  18.257  1.00 27.73           O  
ATOM   2019  CB  LEU   120      40.488  29.602  16.779  1.00 29.16           C  
ATOM   2020  CG  LEU   120      40.699  29.065  18.198  1.00 29.75           C  
ATOM   2021  CD1 LEU   120      39.857  27.808  18.433  1.00 35.18           C  
ATOM   2022  CD2 LEU   120      42.165  28.759  18.433  1.00 29.74           C  
ATOM   2023  N   LEU   121      39.359  32.683  16.346  1.00 28.09           N  
ATOM   2024  CA  LEU   121      39.228  34.057  16.832  1.00 27.44           C  
ATOM   2025  C   LEU   121      37.750  34.434  17.007  1.00 28.11           C  
ATOM   2026  O   LEU   121      37.378  35.044  18.004  1.00 28.73           O  
ATOM   2027  CB  LEU   121      39.920  35.041  15.889  1.00 26.16           C  
ATOM   2028  CG  LEU   121      39.829  36.523  16.266  1.00 27.90           C  
ATOM   2029  CD1 LEU   121      40.567  36.780  17.561  1.00 23.80           C  
ATOM   2030  CD2 LEU   121      40.358  37.411  15.134  1.00 27.70           C  
ATOM   2031  N   GLN   122      36.917  34.057  16.039  1.00 28.54           N  
ATOM   2032  CA  GLN   122      35.481  34.314  16.107  1.00 30.48           C  
ATOM   2033  C   GLN   122      34.866  33.560  17.293  1.00 30.29           C  
ATOM   2034  O   GLN   122      33.977  34.061  17.983  1.00 30.33           O  
ATOM   2035  CB  GLN   122      34.788  33.907  14.790  1.00 30.73           C  
ATOM   2036  CG  GLN   122      33.269  33.730  14.930  1.00 34.32           C  
ATOM   2037  CD  GLN   122      32.527  33.691  13.616  1.00 33.25           C  
ATOM   2038  OE1 GLN   122      32.635  34.605  12.807  1.00 42.39           O  
ATOM   2039  NE2 GLN   122      31.721  32.648  13.419  1.00 35.24           N  
ATOM   2040  N   LEU   123      35.343  32.341  17.495  1.00 29.79           N  
ATOM   2041  CA  LEU   123      34.918  31.500  18.594  1.00 30.76           C  
ATOM   2042  C   LEU   123      35.297  32.158  19.938  1.00 30.05           C  
ATOM   2043  O   LEU   123      34.511  32.159  20.881  1.00 28.56           O  
ATOM   2044  CB  LEU   123      35.581  30.124  18.426  1.00 32.64           C  
ATOM   2045  CG  LEU   123      35.088  28.918  19.208  1.00 36.41           C  
ATOM   2046  CD1 LEU   123      35.493  27.647  18.473  1.00 37.74           C  
ATOM   2047  CD2 LEU   123      35.638  28.950  20.633  1.00 37.75           C  
ATOM   2048  N   ALA   124      36.509  32.710  20.008  1.00 29.00           N  
ATOM   2049  CA  ALA   124      36.979  33.433  21.183  1.00 27.92           C  
ATOM   2050  C   ALA   124      36.140  34.689  21.458  1.00 27.85           C  
ATOM   2051  O   ALA   124      35.857  35.030  22.619  1.00 27.75           O  
ATOM   2052  CB  ALA   124      38.437  33.815  20.996  1.00 27.52           C  
ATOM   2053  N   MET   125      35.737  35.368  20.384  1.00 26.51           N  
ATOM   2054  CA  MET   125      34.935  36.579  20.487  1.00 24.50           C  
ATOM   2055  C   MET   125      33.523  36.293  20.949  1.00 23.15           C  
ATOM   2056  O   MET   125      32.950  37.063  21.705  1.00 23.24           O  
ATOM   2057  CB  MET   125      34.872  37.308  19.138  1.00 23.98           C  
ATOM   2058  CG  MET   125      36.151  38.017  18.740  1.00 24.55           C  
ATOM   2059  SD  MET   125      36.568  39.523  19.855  0.75 19.69          SE  
ATOM   2060  CE  MET   125      34.822  40.421  19.829  1.00 27.99           C  
ATOM   2061  N   GLU   126      32.949  35.198  20.472  1.00 22.92           N  
ATOM   2062  CA  GLU   126      31.589  34.833  20.863  1.00 22.67           C  
ATOM   2063  C   GLU   126      31.542  34.327  22.296  1.00 23.28           C  
ATOM   2064  O   GLU   126      30.535  34.500  22.995  1.00 24.32           O  
ATOM   2065  CB  GLU   126      31.017  33.797  19.905  1.00 22.12           C  
ATOM   2066  CG  GLU   126      30.912  34.295  18.466  1.00 19.97           C  
ATOM   2067  CD  GLU   126      30.242  33.303  17.552  1.00 21.02           C  
ATOM   2068  OE1 GLU   126      29.901  32.187  18.004  1.00 25.67           O  
ATOM   2069  OE2 GLU   126      30.029  33.658  16.382  1.00 23.17           O  
ATOM   2070  N   HIS   127      32.637  33.714  22.727  1.00 24.65           N  
ATOM   2071  CA  HIS   127      32.783  33.226  24.099  1.00 25.24           C  
ATOM   2072  C   HIS   127      32.844  34.408  25.069  1.00 24.32           C  
ATOM   2073  O   HIS   127      32.184  34.415  26.118  1.00 24.41           O  
ATOM   2074  CB  HIS   127      34.050  32.389  24.183  1.00 26.17           C  
ATOM   2075  CG  HIS   127      34.235  31.687  25.484  1.00 31.32           C  
ATOM   2076  ND1 HIS   127      33.450  30.626  25.876  1.00 38.61           N  
ATOM   2077  CD2 HIS   127      35.141  31.872  26.470  1.00 36.97           C  
ATOM   2078  CE1 HIS   127      33.861  30.195  27.054  1.00 39.40           C  
ATOM   2079  NE2 HIS   127      34.881  30.938  27.438  1.00 37.60           N  
ATOM   2080  N   GLU   128      33.625  35.417  24.699  1.00 23.98           N  
ATOM   2081  CA  GLU   128      33.678  36.673  25.445  1.00 22.90           C  
ATOM   2082  C   GLU   128      32.285  37.287  25.550  1.00 21.15           C  
ATOM   2083  O   GLU   128      31.845  37.655  26.629  1.00 19.73           O  
ATOM   2084  CB  GLU   128      34.610  37.659  24.747  1.00 22.49           C  
ATOM   2085  CG  GLU   128      34.708  39.049  25.408  1.00 27.83           C  
ATOM   2086  CD  GLU   128      35.846  39.181  26.415  1.00 28.43           C  
ATOM   2087  OE1 GLU   128      36.726  38.301  26.447  1.00 27.93           O  
ATOM   2088  OE2 GLU   128      35.860  40.190  27.156  1.00 30.92           O  
ATOM   2089  N   ILE   129      31.613  37.390  24.410  1.00 20.76           N  
ATOM   2090  CA  ILE   129      30.320  38.058  24.320  1.00 20.58           C  
ATOM   2091  C   ILE   129      29.281  37.312  25.140  1.00 21.24           C  
ATOM   2092  O   ILE   129      28.513  37.931  25.863  1.00 23.67           O  
ATOM   2093  CB  ILE   129      29.858  38.233  22.840  1.00 19.95           C  
ATOM   2094  CG1 ILE   129      30.767  39.241  22.133  1.00 20.52           C  
ATOM   2095  CG2 ILE   129      28.411  38.718  22.786  1.00 19.35           C  
ATOM   2096  CD1 ILE   129      30.746  39.177  20.613  1.00 19.09           C  
ATOM   2097  N   HIS   130      29.288  35.985  25.048  1.00 21.33           N  
ATOM   2098  CA  HIS   130      28.430  35.139  25.878  1.00 19.82           C  
ATOM   2099  C   HIS   130      28.572  35.420  27.373  1.00 20.82           C  
ATOM   2100  O   HIS   130      27.583  35.721  28.048  1.00 20.66           O  
ATOM   2101  CB  HIS   130      28.727  33.658  25.615  1.00 18.93           C  
ATOM   2102  CG  HIS   130      28.027  32.732  26.553  1.00 15.45           C  
ATOM   2103  ND1 HIS   130      26.658  32.550  26.535  1.00 14.36           N  
ATOM   2104  CD2 HIS   130      28.503  31.936  27.536  1.00 13.49           C  
ATOM   2105  CE1 HIS   130      26.323  31.696  27.484  1.00 15.06           C  
ATOM   2106  NE2 HIS   130      27.423  31.317  28.111  1.00 16.03           N  
ATOM   2107  N   HIS   131      29.799  35.303  27.882  1.00 21.96           N  
ATOM   2108  CA  HIS   131      30.080  35.424  29.318  1.00 21.31           C  
ATOM   2109  C   HIS   131      29.957  36.868  29.852  1.00 22.10           C  
ATOM   2110  O   HIS   131      29.656  37.088  31.034  1.00 20.92           O  
ATOM   2111  CB  HIS   131      31.461  34.839  29.643  1.00 21.24           C  
ATOM   2112  CG  HIS   131      31.522  33.343  29.551  1.00 22.99           C  
ATOM   2113  ND1 HIS   131      30.750  32.516  30.340  1.00 25.40           N  
ATOM   2114  CD2 HIS   131      32.274  32.525  28.776  1.00 23.84           C  
ATOM   2115  CE1 HIS   131      31.012  31.255  30.044  1.00 25.83           C  
ATOM   2116  NE2 HIS   131      31.936  31.233  29.101  1.00 26.08           N  
ATOM   2117  N   LYS   132      30.195  37.854  28.993  1.00 23.34           N  
ATOM   2118  CA  LYS   132      29.890  39.237  29.349  1.00 23.59           C  
ATOM   2119  C   LYS   132      28.368  39.353  29.502  1.00 24.59           C  
ATOM   2120  O   LYS   132      27.883  40.077  30.374  1.00 25.72           O  
ATOM   2121  CB  LYS   132      30.450  40.221  28.303  1.00 24.16           C  
ATOM   2122  CG  LYS   132      29.937  41.660  28.425  1.00 22.60           C  
ATOM   2123  CD  LYS   132      30.819  42.673  27.685  1.00 23.82           C  
ATOM   2124  CE  LYS   132      31.003  42.367  26.192  1.00 26.25           C  
ATOM   2125  NZ  LYS   132      29.783  42.581  25.373  1.00 19.16           N  
ATOM   2126  N   GLY   133      27.625  38.625  28.666  1.00 24.94           N  
ATOM   2127  CA  GLY   133      26.167  38.535  28.785  1.00 23.57           C  
ATOM   2128  C   GLY   133      25.738  37.992  30.140  1.00 24.46           C  
ATOM   2129  O   GLY   133      24.797  38.507  30.745  1.00 25.42           O  
ATOM   2130  N   ASN   134      26.421  36.946  30.616  1.00 24.53           N  
ATOM   2131  CA  ASN   134      26.212  36.447  31.981  1.00 23.49           C  
ATOM   2132  C   ASN   134      26.525  37.544  32.981  1.00 23.55           C  
ATOM   2133  O   ASN   134      25.752  37.789  33.899  1.00 23.87           O  
ATOM   2134  CB  ASN   134      27.137  35.279  32.349  1.00 24.25           C  
ATOM   2135  CG  ASN   134      27.000  34.066  31.443  1.00 22.64           C  
ATOM   2136  OD1 ASN   134      27.917  33.259  31.385  1.00 27.65           O  
ATOM   2137  ND2 ASN   134      25.884  33.927  30.755  1.00 22.69           N  
ATOM   2138  N   LEU   135      27.674  38.188  32.797  1.00 23.93           N  
ATOM   2139  CA  LEU   135      28.207  39.140  33.769  1.00 24.06           C  
ATOM   2140  C   LEU   135      27.286  40.331  34.014  1.00 24.23           C  
ATOM   2141  O   LEU   135      27.195  40.795  35.130  1.00 25.52           O  
ATOM   2142  CB  LEU   135      29.599  39.605  33.340  1.00 23.83           C  
ATOM   2143  CG  LEU   135      30.452  40.451  34.291  1.00 24.29           C  
ATOM   2144  CD1 LEU   135      30.640  39.807  35.676  1.00 20.22           C  
ATOM   2145  CD2 LEU   135      31.803  40.685  33.627  1.00 24.00           C  
ATOM   2146  N   PHE   136      26.617  40.814  32.967  1.00 24.58           N  
ATOM   2147  CA  PHE   136      25.647  41.896  33.073  1.00 24.76           C  
ATOM   2148  C   PHE   136      24.547  41.609  34.115  1.00 26.40           C  
ATOM   2149  O   PHE   136      24.153  42.502  34.871  1.00 24.96           O  
ATOM   2150  CB  PHE   136      24.994  42.160  31.714  1.00 25.02           C  
ATOM   2151  CG  PHE   136      25.603  43.297  30.961  1.00 25.69           C  
ATOM   2152  CD1 PHE   136      25.197  44.595  31.219  1.00 27.75           C  
ATOM   2153  CD2 PHE   136      26.590  43.077  29.998  1.00 23.95           C  
ATOM   2154  CE1 PHE   136      25.751  45.656  30.529  1.00 27.50           C  
ATOM   2155  CE2 PHE   136      27.150  44.126  29.303  1.00 22.33           C  
ATOM   2156  CZ  PHE   136      26.732  45.426  29.568  1.00 28.13           C  
ATOM   2157  N   VAL   137      24.049  40.374  34.143  1.00 26.43           N  
ATOM   2158  CA  VAL   137      23.008  40.004  35.098  1.00 25.49           C  
ATOM   2159  C   VAL   137      23.599  39.897  36.506  1.00 26.38           C  
ATOM   2160  O   VAL   137      22.977  40.346  37.462  1.00 27.33           O  
ATOM   2161  CB  VAL   137      22.254  38.714  34.667  1.00 26.90           C  
ATOM   2162  CG1 VAL   137      21.086  38.397  35.632  1.00 22.98           C  
ATOM   2163  CG2 VAL   137      21.726  38.861  33.238  1.00 21.37           C  
ATOM   2164  N   TYR   138      24.814  39.352  36.631  1.00 27.22           N  
ATOM   2165  CA  TYR   138      25.534  39.329  37.921  1.00 27.61           C  
ATOM   2166  C   TYR   138      25.601  40.731  38.527  1.00 28.62           C  
ATOM   2167  O   TYR   138      25.164  40.955  39.664  1.00 30.89           O  
ATOM   2168  CB  TYR   138      26.980  38.813  37.775  1.00 27.23           C  
ATOM   2169  CG  TYR   138      27.175  37.304  37.716  1.00 27.29           C  
ATOM   2170  CD1 TYR   138      26.675  36.558  36.664  1.00 26.10           C  
ATOM   2171  CD2 TYR   138      27.903  36.634  38.695  1.00 29.05           C  
ATOM   2172  CE1 TYR   138      26.872  35.177  36.590  1.00 24.62           C  
ATOM   2173  CE2 TYR   138      28.092  35.252  38.642  1.00 26.24           C  
ATOM   2174  CZ  TYR   138      27.577  34.534  37.582  1.00 26.62           C  
ATOM   2175  OH  TYR   138      27.771  33.174  37.491  1.00 27.21           O  
ATOM   2176  N   VAL   139      26.146  41.666  37.754  1.00 27.99           N  
ATOM   2177  CA  VAL   139      26.404  43.039  38.215  1.00 27.23           C  
ATOM   2178  C   VAL   139      25.129  43.810  38.552  1.00 27.92           C  
ATOM   2179  O   VAL   139      25.086  44.595  39.514  1.00 26.74           O  
ATOM   2180  CB  VAL   139      27.222  43.803  37.156  1.00 28.07           C  
ATOM   2181  CG1 VAL   139      27.307  45.289  37.484  1.00 28.06           C  
ATOM   2182  CG2 VAL   139      28.624  43.174  37.012  1.00 26.48           C  
ATOM   2183  N   ARG   140      24.099  43.592  37.744  1.00 29.05           N  
ATOM   2184  CA  ARG   140      22.773  44.168  37.964  1.00 31.02           C  
ATOM   2185  C   ARG   140      22.193  43.697  39.308  1.00 30.81           C  
ATOM   2186  O   ARG   140      21.591  44.480  40.046  1.00 30.77           O  
ATOM   2187  CB  ARG   140      21.863  43.745  36.804  1.00 32.60           C  
ATOM   2188  CG  ARG   140      20.404  44.195  36.878  1.00 40.15           C  
ATOM   2189  CD  ARG   140      20.154  45.498  36.168  1.00 42.74           C  
ATOM   2190  NE  ARG   140      20.623  45.454  34.785  1.00 44.57           N  
ATOM   2191  CZ  ARG   140      20.631  46.499  33.961  1.00 43.68           C  
ATOM   2192  NH1 ARG   140      20.180  47.690  34.364  1.00 42.68           N  
ATOM   2193  NH2 ARG   140      21.097  46.350  32.724  1.00 47.01           N  
ATOM   2194  N   GLU   141      22.378  42.412  39.606  1.00 31.43           N  
ATOM   2195  CA  GLU   141      21.960  41.809  40.885  1.00 30.94           C  
ATOM   2196  C   GLU   141      22.784  42.249  42.108  1.00 31.18           C  
ATOM   2197  O   GLU   141      22.380  42.019  43.250  1.00 30.01           O  
ATOM   2198  CB  GLU   141      21.989  40.281  40.789  1.00 31.38           C  
ATOM   2199  CG  GLU   141      20.789  39.711  40.078  1.00 29.43           C  
ATOM   2200  CD  GLU   141      20.871  38.218  39.838  1.00 29.00           C  
ATOM   2201  OE1 GLU   141      21.346  37.465  40.720  1.00 24.08           O  
ATOM   2202  OE2 GLU   141      20.434  37.798  38.751  1.00 24.21           O  
ATOM   2203  N   MET   142      23.935  42.872  41.866  1.00 31.32           N  
ATOM   2204  CA  MET   142      24.788  43.379  42.938  1.00 30.72           C  
ATOM   2205  C   MET   142      24.459  44.808  43.371  1.00 32.76           C  
ATOM   2206  O   MET   142      25.194  45.384  44.180  1.00 33.35           O  
ATOM   2207  CB  MET   142      26.247  43.366  42.498  1.00 30.80           C  
ATOM   2208  CG  MET   142      26.791  42.021  42.195  1.00 29.92           C  
ATOM   2209  SD  MET   142      28.615  42.104  41.579  0.75 23.20          SE  
ATOM   2210  CE  MET   142      28.655  43.665  40.756  1.00 18.45           C  
ATOM   2211  N   GLY   143      23.394  45.393  42.822  1.00 33.02           N  
ATOM   2212  CA  GLY   143      22.959  46.714  43.243  1.00 33.47           C  
ATOM   2213  C   GLY   143      23.214  47.819  42.232  1.00 34.81           C  
ATOM   2214  O   GLY   143      22.746  48.940  42.423  1.00 35.09           O  
ATOM   2215  N   HIS   144      23.943  47.516  41.159  1.00 35.68           N  
ATOM   2216  CA  HIS   144      24.277  48.516  40.138  1.00 36.43           C  
ATOM   2217  C   HIS   144      23.212  48.593  39.051  1.00 37.25           C  
ATOM   2218  O   HIS   144      22.838  47.584  38.459  1.00 36.10           O  
ATOM   2219  CB  HIS   144      25.643  48.218  39.538  1.00 36.53           C  
ATOM   2220  CG  HIS   144      26.725  48.147  40.564  1.00 36.63           C  
ATOM   2221  ND1 HIS   144      27.392  49.264  41.015  1.00 34.51           N  
ATOM   2222  CD2 HIS   144      27.217  47.101  41.267  1.00 41.34           C  
ATOM   2223  CE1 HIS   144      28.270  48.906  41.934  1.00 40.77           C  
ATOM   2224  NE2 HIS   144      28.181  47.599  42.111  1.00 42.86           N  
ATOM   2225  N   THR   145      22.720  49.802  38.808  1.00 39.71           N  
ATOM   2226  CA  THR   145      21.653  50.030  37.835  1.00 41.21           C  
ATOM   2227  C   THR   145      22.096  50.853  36.624  1.00 43.96           C  
ATOM   2228  O   THR   145      21.370  50.917  35.626  1.00 45.11           O  
ATOM   2229  CB  THR   145      20.451  50.766  38.477  1.00 40.95           C  
ATOM   2230  OG1 THR   145      20.784  52.148  38.677  1.00 36.83           O  
ATOM   2231  CG2 THR   145      20.050  50.122  39.813  1.00 38.96           C  
ATOM   2232  N   GLU   146      23.260  51.496  36.705  1.00 45.65           N  
ATOM   2233  CA  GLU   146      23.726  52.328  35.604  1.00 47.58           C  
ATOM   2234  C   GLU   146      24.886  51.616  34.924  1.00 46.33           C  
ATOM   2235  O   GLU   146      26.059  51.845  35.238  1.00 48.08           O  
ATOM   2236  CB  GLU   146      24.105  53.725  36.101  1.00 48.88           C  
ATOM   2237  CG  GLU   146      23.685  54.842  35.148  1.00 53.87           C  
ATOM   2238  CD  GLU   146      22.186  54.817  34.818  1.00 59.74           C  
ATOM   2239  OE1 GLU   146      21.360  54.933  35.753  1.00 62.56           O  
ATOM   2240  OE2 GLU   146      21.837  54.686  33.624  1.00 60.00           O  
ATOM   2241  N   LEU   147      24.535  50.731  33.998  1.00 43.13           N  
ATOM   2242  CA  LEU   147      25.511  49.860  33.355  1.00 40.71           C  
ATOM   2243  C   LEU   147      25.797  50.305  31.923  1.00 38.85           C  
ATOM   2244  O   LEU   147      24.917  50.848  31.242  1.00 37.87           O  
ATOM   2245  CB  LEU   147      25.016  48.411  33.365  1.00 40.10           C  
ATOM   2246  CG  LEU   147      24.740  47.799  34.743  1.00 39.60           C  
ATOM   2247  CD1 LEU   147      24.125  46.436  34.588  1.00 38.09           C  
ATOM   2248  CD2 LEU   147      26.011  47.720  35.575  1.00 37.18           C  
ATOM   2249  N   PRO   148      27.036  50.070  31.457  1.00 36.83           N  
ATOM   2250  CA  PRO   148      27.359  50.459  30.092  1.00 35.09           C  
ATOM   2251  C   PRO   148      26.522  49.694  29.079  1.00 32.85           C  
ATOM   2252  O   PRO   148      25.936  48.655  29.407  1.00 32.33           O  
ATOM   2253  CB  PRO   148      28.841  50.080  29.953  1.00 34.78           C  
ATOM   2254  CG  PRO   148      29.096  49.071  31.022  1.00 36.57           C  
ATOM   2255  CD  PRO   148      28.178  49.432  32.143  1.00 37.27           C  
ATOM   2256  N   PHE   149      26.440  50.234  27.871  1.00 30.90           N  
ATOM   2257  CA  PHE   149      25.923  49.487  26.742  1.00 29.22           C  
ATOM   2258  C   PHE   149      26.911  48.343  26.533  1.00 26.36           C  
ATOM   2259  O   PHE   149      28.108  48.498  26.802  1.00 26.92           O  
ATOM   2260  CB  PHE   149      25.825  50.378  25.500  1.00 29.54           C  
ATOM   2261  CG  PHE   149      25.075  49.745  24.365  1.00 31.48           C  
ATOM   2262  CD1 PHE   149      23.731  49.412  24.508  1.00 32.96           C  
ATOM   2263  CD2 PHE   149      25.708  49.468  23.162  1.00 31.91           C  
ATOM   2264  CE1 PHE   149      23.040  48.813  23.475  1.00 33.85           C  
ATOM   2265  CE2 PHE   149      25.017  48.876  22.123  1.00 34.43           C  
ATOM   2266  CZ  PHE   149      23.683  48.546  22.282  1.00 33.21           C  
ATOM   2267  N   TYR   150      26.428  47.209  26.045  1.00 25.14           N  
ATOM   2268  CA  TYR   150      27.236  45.986  26.041  1.00 26.48           C  
ATOM   2269  C   TYR   150      28.453  45.994  25.127  1.00 25.90           C  
ATOM   2270  O   TYR   150      29.319  45.125  25.246  1.00 26.81           O  
ATOM   2271  CB  TYR   150      26.372  44.766  25.751  1.00 27.38           C  
ATOM   2272  CG  TYR   150      25.858  44.654  24.346  1.00 27.41           C  
ATOM   2273  CD1 TYR   150      26.599  44.014  23.357  1.00 26.55           C  
ATOM   2274  CD2 TYR   150      24.599  45.154  24.011  1.00 33.30           C  
ATOM   2275  CE1 TYR   150      26.103  43.901  22.050  1.00 32.66           C  
ATOM   2276  CE2 TYR   150      24.090  45.035  22.725  1.00 34.22           C  
ATOM   2277  CZ  TYR   150      24.845  44.420  21.751  1.00 33.26           C  
ATOM   2278  OH  TYR   150      24.321  44.325  20.489  1.00 36.66           O  
ATOM   2279  N   GLN   151      28.514  46.963  24.224  1.00 25.97           N  
ATOM   2280  CA  GLN   151      29.643  47.114  23.323  1.00 28.02           C  
ATOM   2281  C   GLN   151      29.928  48.601  23.100  1.00 28.27           C  
ATOM   2282  O   GLN   151      29.011  49.379  22.893  1.00 26.65           O  
ATOM   2283  CB  GLN   151      29.326  46.447  21.977  1.00 28.59           C  
ATOM   2284  CG  GLN   151      30.572  46.158  21.157  1.00 31.58           C  
ATOM   2285  CD  GLN   151      30.308  45.843  19.693  1.00 29.46           C  
ATOM   2286  OE1 GLN   151      29.163  45.768  19.260  1.00 34.99           O  
ATOM   2287  NE2 GLN   151      31.381  45.675  18.920  1.00 28.17           N  
ATOM   2288  N   GLN   152      31.196  48.988  23.151  1.00 30.83           N  
ATOM   2289  CA  GLN   152      31.596  50.336  22.767  1.00 33.70           C  
ATOM   2290  C   GLN   152      31.634  50.422  21.243  1.00 36.95           C  
ATOM   2291  O   GLN   152      31.835  49.412  20.563  1.00 37.86           O  
ATOM   2292  CB  GLN   152      32.961  50.684  23.349  1.00 32.47           C  
ATOM   2293  CG  GLN   152      32.965  50.794  24.856  1.00 33.78           C  
ATOM   2294  CD  GLN   152      34.315  51.214  25.424  1.00 35.09           C  
ATOM   2295  OE1 GLN   152      35.319  51.317  24.704  1.00 32.29           O  
ATOM   2296  NE2 GLN   152      34.342  51.450  26.731  1.00 28.38           N  
ATOM   2297  N   ARG   153      31.444  51.622  20.707  1.00 38.84           N  
ATOM   2298  CA  ARG   153      31.447  51.820  19.252  1.00 40.64           C  
ATOM   2299  C   ARG   153      32.858  51.664  18.680  1.00 42.01           C  
ATOM   2300  O   ARG   153      33.351  50.543  18.488  1.00 44.29           O  
ATOM   2301  CB  ARG   153      30.889  53.206  18.903  1.00 39.42           C  
END
