
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  244 ( 2033),  selected  244 , name 1wzn_A
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 1wzn_A.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      E       3           -
LGA    -       -      N       4           -
LGA    M     1_A      K       5           #
LGA    Y     2_A      K       6          4.071
LGA    E     3_A      K       7          3.111
LGA    L     4_A      F       8           #
LGA    Y     5_A      D       9          4.165
LGA    T     6_A      K      10          2.596
LGA    L     7_A      K      11          1.706
LGA    L     8_A      G      12          2.650
LGA    A     9_A      A      13          1.506
LGA    E    10_A      K      14          1.940
LGA    Y    11_A      N      15          2.681
LGA    Y    12_A      M      16          1.627
LGA    D    13_A      D      17          2.739
LGA    T    14_A      E      18          2.212
LGA    I    15_A      I      19          2.888
LGA    Y    16_A      S      20          4.172
LGA    -       -      K      21           -
LGA    R    17_A      T      22          2.470
LGA    R    18_A      L      23          2.576
LGA    R    19_A      F      24          2.027
LGA    I    20_A      A      25          1.548
LGA    E    21_A      P      26          1.548
LGA    R    22_A      I      27          2.045
LGA    V    23_A      Y      28          1.311
LGA    K    24_A      P      29          1.205
LGA    A    25_A      I      30          1.205
LGA    E    26_A      I      31          1.004
LGA    I    27_A      A      32          0.915
LGA    D    28_A      E      33          0.966
LGA    F    29_A      N      34          0.833
LGA    V    30_A      I      35          0.802
LGA    E    31_A      I      36          0.918
LGA    E    32_A      N      37          2.008
LGA    I    33_A      R      38          2.595
LGA    F    34_A      F      39          2.200
LGA    K    35_A      G      40          1.830
LGA    E    36_A      -       -           -
LGA    D    37_A      -       -           -
LGA    A    38_A      -       -           -
LGA    K    39_A      -       -           -
LGA    R    40_A      -       -           -
LGA    E    41_A      I      41          4.950
LGA    V    42_A      T      42          5.220
LGA    -       -      A      43           -
LGA    R    43_A      G      44          1.850
LGA    R    44_A      N      45          0.579
LGA    V    45_A      C      46          0.470
LGA    L    46_A      I      47          0.811
LGA    D    47_A      D      48          0.795
LGA    L    48_A      I      49          0.808
LGA    A    49_A      G      50          0.817
LGA    C    50_A      S      51          0.520
LGA    G    51_A      G      52          0.268
LGA    T    52_A      P      53          0.323
LGA    G    53_A      G      54          0.660
LGA    I    54_A      A      55          0.985
LGA    P    55_A      L      56          0.446
LGA    T    56_A      S      57          0.850
LGA    L    57_A      I      58          0.734
LGA    E    58_A      A      59          0.804
LGA    L    59_A      L      60          1.037
LGA    A    60_A      A      61          1.525
LGA    E    61_A      K      62          1.728
LGA    R    62_A      Q      63          2.307
LGA    G    63_A      S      64          3.213
LGA    -       -      D      65           -
LGA    Y    64_A      F      66          1.267
LGA    E    65_A      S      67          0.625
LGA    V    66_A      I      68          0.259
LGA    V    67_A      R      69          0.265
LGA    G    68_A      A      70          0.614
LGA    L    69_A      L      71          0.858
LGA    D    70_A      D      72          0.658
LGA    L    71_A      F      73          1.011
LGA    H    72_A      S      74          0.861
LGA    E    73_A      K      75          1.327
LGA    E    74_A      H      76          1.083
LGA    M    75_A      M      77          0.955
LGA    L    76_A      N      78          1.198
LGA    R    77_A      E      79          1.402
LGA    V    78_A      I      80          1.477
LGA    A    79_A      A      81          1.159
LGA    R    80_A      L      82          1.136
LGA    R    81_A      K      83          0.962
LGA    K    82_A      N      84          1.369
LGA    A    83_A      I      85          0.922
LGA    K    84_A      A      86          0.719
LGA    E    85_A      D      87          1.240
LGA    R    86_A      A      88          1.314
LGA    N    87_A      D      89          1.053
LGA    L    88_A      L      90          0.705
LGA    K    89_A      N      91          2.723
LGA    -       -      D      92           -
LGA    -       -      R      93           -
LGA    I    90_A      I      94          1.056
LGA    E    91_A      Q      95          0.668
LGA    F    92_A      I      96          0.125
LGA    L    93_A      V      97          1.226
LGA    Q    94_A      Q      98          1.152
LGA    G    95_A      G      99          1.445
LGA    D    96_A      D     100          1.499
LGA    V    97_A      V     101          1.325
LGA    L    98_A      H     102          0.662
LGA    E    99_A      N     103          1.128
LGA    I   100_A      I     104          0.931
LGA    A   101_A      P     105          4.245
LGA    -       -      I     106           -
LGA    F   102_A      E     107          2.725
LGA    K   103_A      D     108          0.901
LGA    N   104_A      N     109          0.728
LGA    E   105_A      Y     110          0.773
LGA    F   106_A      A     111          0.865
LGA    D   107_A      D     112          0.543
LGA    A   108_A      L     113          1.170
LGA    V   109_A      I     114          1.164
LGA    T   110_A      V     115          1.359
LGA    M   111_A      S     116          1.355
LGA    F   112_A      R     117          0.974
LGA    F   113_A      G     118          2.161
LGA    S   114_A      -       -           -
LGA    T   115_A      S     119          1.763
LGA    I   116_A      V     120          1.442
LGA    M   117_A      F     121          1.453
LGA    Y   118_A      F     122          1.140
LGA    F   119_A      W     123          2.558
LGA    D   120_A      E     124           #
LGA    E   121_A      -       -           -
LGA    E   122_A      -       -           -
LGA    D   123_A      D     125          1.016
LGA    L   124_A      V     126          0.782
LGA    R   125_A      T     127          0.933
LGA    K   126_A      T     128          0.641
LGA    L   127_A      A     129          0.784
LGA    F   128_A      F     130          0.781
LGA    S   129_A      R     131          0.473
LGA    K   130_A      E     132          0.481
LGA    V   131_A      I     133          0.626
LGA    A   132_A      Y     134          0.651
LGA    E   133_A      R     135          0.548
LGA    A   134_A      I     136          0.074
LGA    L   135_A      L     137          0.941
LGA    K   136_A      K     138          0.920
LGA    P   137_A      S     139          0.599
LGA    G   138_A      G     140          0.592
LGA    G   139_A      G     141          0.398
LGA    V   140_A      K     142          1.024
LGA    F   141_A      T     143          1.605
LGA    I   142_A      Y     144          1.227
LGA    T   143_A      I     145          0.892
LGA    D   144_A      G     146          1.718
LGA    F   145_A      G     147          3.727
LGA    P   146_A      G     148           #
LGA    C   147_A      F     149           -
LGA    G   155_A      G     150           -
LGA    P   156_A      N     151           -
LGA    -       -      K     152           -
LGA    -       -      E     153           -
LGA    -       -      L     154           -
LGA    -       -      R     155           -
LGA    -       -      D     156           -
LGA    -       -      S     157           -
LGA    -       -      I     158           -
LGA    -       -      S     159           -
LGA    -       -      A     160           -
LGA    -       -      E     161           -
LGA    -       -      M     162           -
LGA    V   157_A      I     163          4.633
LGA    V   158_A      R     164          3.486
LGA    W   159_A      K     165          2.116
LGA    N   160_A      -       -           -
LGA    E   161_A      -       -           -
LGA    Q   162_A      -       -           -
LGA    K   163_A      -       -           -
LGA    G   164_A      -       -           -
LGA    E   165_A      -       -           -
LGA    E   166_A      -       -           -
LGA    K   167_A      -       -           -
LGA    L   168_A      -       -           -
LGA    V   169_A      -       -           -
LGA    I   170_A      N     166          4.519
LGA    M   171_A      P     167          5.053
LGA    D   172_A      D     168          3.308
LGA    W   173_A      W     169           #
LGA    -       -      K     170           -
LGA    R   174_A      E     171          5.958
LGA    E   175_A      -       -           -
LGA    V   176_A      -       -           -
LGA    E   177_A      -       -           -
LGA    P   178_A      -       -           -
LGA    A   179_A      -       -           -
LGA    V   180_A      -       -           -
LGA    Q   181_A      -       -           -
LGA    K   182_A      -       -           -
LGA    L   183_A      -       -           -
LGA    R   184_A      -       -           -
LGA    F   185_A      F     172          6.086
LGA    K   186_A      N     173           -
LGA    R   187_A      R     174           -
LGA    L   188_A      -       -           -
LGA    V   189_A      -       -           -
LGA    Q   190_A      -       -           -
LGA    I   191_A      -       -           -
LGA    L   192_A      -       -           -
LGA    R   193_A      -       -           -
LGA    P   194_A      -       -           -
LGA    N   195_A      -       -           -
LGA    G   196_A      -       -           -
LGA    E   197_A      -       -           -
LGA    V   198_A      -       -           -
LGA    K   199_A      -       -           -
LGA    A   200_A      -       -           -
LGA    F   201_A      -       -           -
LGA    L   202_A      -       -           -
LGA    V   203_A      -       -           -
LGA    D   204_A      -       -           -
LGA    D   205_A      -       -           -
LGA    E   206_A      -       -           -
LGA    L   207_A      -       -           -
LGA    N   208_A      -       -           -
LGA    I   209_A      K     175          5.790
LGA    -       -      N     176           -
LGA    -       -      I     177           -
LGA    -       -      S     178           -
LGA    -       -      Q     179           -
LGA    Y   210_A      E     180          3.724
LGA    T   211_A      N     181          2.760
LGA    P   212_A      V     182          0.943
LGA    R   213_A      E     183          2.823
LGA    E   214_A      R     184          2.637
LGA    V   215_A      F     185          1.221
LGA    R   216_A      Q     186          2.127
LGA    L   217_A      N     187          2.955
LGA    L   218_A      V     188          1.706
LGA    A   219_A      L     189          1.873
LGA    E   220_A      D     190          4.014
LGA    -       -      E     191           -
LGA    K   221_A      I     192          2.987
LGA    Y   222_A      G     193          4.746
LGA    F   223_A      V     194          3.197
LGA    E   224_A      S     195          2.536
LGA    K   225_A      S     196          0.802
LGA    V   226_A      Y     197          0.824
LGA    K   227_A      E     198          0.696
LGA    I   228_A      I     199          2.240
LGA    Y   229_A      I     200          2.434
LGA    G   230_A      L     201          3.158
LGA    N   231_A      E     202          3.273
LGA    L   232_A      D     203           #
LGA    K   233_A      E     204           #
LGA    R   234_A      -       -           -
LGA    E   235_A      -       -           -
LGA    L   236_A      -       -           -
LGA    S   237_A      -       -           -
LGA    P   238_A      -       -           -
LGA    N   239_A      -       -           -
LGA    D   240_A      -       -           -
LGA    M   241_A      -       -           -
LGA    R   242_A      G     205          2.672
LGA    Y   243_A      F     206          1.578
LGA    W   244_A      W     207          1.336
LGA    I   245_A      I     208          1.371
LGA    V   246_A      I     209          0.313
LGA    G   247_A      I     210          0.350
LGA    I   248_A      S     211          0.310
LGA    A   249_A      K     212          0.267
LGA    K   250_A      T     213          0.681
LGA    S   251_A      D     214           #
LGA    -       -      Q     215           -
LGA    -       -      E     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  244  218    5.0    174    2.09    18.97     65.212     7.955

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.504607 * X  +   0.726875 * Y  +   0.465859 * Z  + -70.631363
  Y_new =  -0.493465 * X  +  -0.199940 * Y  +   0.846473 * Z  + -16.868301
  Z_new =   0.708424 * X  +  -0.657021 * Y  +   0.257796 * Z  +  28.500713 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.196884    1.944709  [ DEG:   -68.5764    111.4236 ]
  Theta =  -0.787262   -2.354331  [ DEG:   -45.1068   -134.8932 ]
  Phi   =  -0.774235    2.367358  [ DEG:   -44.3604    135.6396 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wzn_A                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wzn_A.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  244  218   5.0  174   2.09   18.97  65.212
REMARK  ---------------------------------------------------------- 
MOLECULE 1wzn_A
HEADER    TRANSFERASE                             08-MAR-05   1WZN              
TITLE     CRYSTAL STRUCTURE OF THE SAM-DEPENDENT METHYLTRANSFERASE              
TITLE    2 FROM PYROCOCCUS HORIKOSHII OT3                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SAM-DEPENDENT METHYLTRANSFERASE;                           
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: 252AA LONG HYPOTHETICAL PROTEIN;                            
COMPND   5 EC: 2.1.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: OT3;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS (DE3)-RIL;                  
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    SAM-DEPENDENT METHYLTRANSFERASE, STRUCTURAL GENOMICS, RIKEN           
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.MIZUTANI,N.KUNISHIMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS           
AUTHOR   2 INITIATIVE (RSGI)                                                    
REVDAT   1   14-MAR-06 1WZN    0                                                
JRNL        AUTH   H.MIZUTANI,N.KUNISHIMA                                       
JRNL        TITL   CRYSTAL STRUCTURE OF THE SAM-DEPENDENT                       
JRNL        TITL 2 METHYLTRANSFERASE FROM PYROCOCCUS HORIKOSHII OT3             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1WZN A    1   252  GB     3257726  BAA30409         1    252             
DBREF  1WZN B    1   252  GB     3257726  BAA30409         1    252             
DBREF  1WZN C    1   252  GB     3257726  BAA30409         1    252             
SEQRES   1 A  252  MET TYR GLU LEU TYR THR LEU LEU ALA GLU TYR TYR ASP          
SEQRES   2 A  252  THR ILE TYR ARG ARG ARG ILE GLU ARG VAL LYS ALA GLU          
SEQRES   3 A  252  ILE ASP PHE VAL GLU GLU ILE PHE LYS GLU ASP ALA LYS          
SEQRES   4 A  252  ARG GLU VAL ARG ARG VAL LEU ASP LEU ALA CYS GLY THR          
SEQRES   5 A  252  GLY ILE PRO THR LEU GLU LEU ALA GLU ARG GLY TYR GLU          
SEQRES   6 A  252  VAL VAL GLY LEU ASP LEU HIS GLU GLU MET LEU ARG VAL          
SEQRES   7 A  252  ALA ARG ARG LYS ALA LYS GLU ARG ASN LEU LYS ILE GLU          
SEQRES   8 A  252  PHE LEU GLN GLY ASP VAL LEU GLU ILE ALA PHE LYS ASN          
SEQRES   9 A  252  GLU PHE ASP ALA VAL THR MET PHE PHE SER THR ILE MET          
SEQRES  10 A  252  TYR PHE ASP GLU GLU ASP LEU ARG LYS LEU PHE SER LYS          
SEQRES  11 A  252  VAL ALA GLU ALA LEU LYS PRO GLY GLY VAL PHE ILE THR          
SEQRES  12 A  252  ASP PHE PRO CYS TRP PHE TYR GLY GLY ARG ASP GLY PRO          
SEQRES  13 A  252  VAL VAL TRP ASN GLU GLN LYS GLY GLU GLU LYS LEU VAL          
SEQRES  14 A  252  ILE MET ASP TRP ARG GLU VAL GLU PRO ALA VAL GLN LYS          
SEQRES  15 A  252  LEU ARG PHE LYS ARG LEU VAL GLN ILE LEU ARG PRO ASN          
SEQRES  16 A  252  GLY GLU VAL LYS ALA PHE LEU VAL ASP ASP GLU LEU ASN          
SEQRES  17 A  252  ILE TYR THR PRO ARG GLU VAL ARG LEU LEU ALA GLU LYS          
SEQRES  18 A  252  TYR PHE GLU LYS VAL LYS ILE TYR GLY ASN LEU LYS ARG          
SEQRES  19 A  252  GLU LEU SER PRO ASN ASP MET ARG TYR TRP ILE VAL GLY          
SEQRES  20 A  252  ILE ALA LYS SER PHE                                          
SEQRES   1 B  252  MET TYR GLU LEU TYR THR LEU LEU ALA GLU TYR TYR ASP          
SEQRES   2 B  252  THR ILE TYR ARG ARG ARG ILE GLU ARG VAL LYS ALA GLU          
SEQRES   3 B  252  ILE ASP PHE VAL GLU GLU ILE PHE LYS GLU ASP ALA LYS          
SEQRES   4 B  252  ARG GLU VAL ARG ARG VAL LEU ASP LEU ALA CYS GLY THR          
SEQRES   5 B  252  GLY ILE PRO THR LEU GLU LEU ALA GLU ARG GLY TYR GLU          
SEQRES   6 B  252  VAL VAL GLY LEU ASP LEU HIS GLU GLU MET LEU ARG VAL          
SEQRES   7 B  252  ALA ARG ARG LYS ALA LYS GLU ARG ASN LEU LYS ILE GLU          
SEQRES   8 B  252  PHE LEU GLN GLY ASP VAL LEU GLU ILE ALA PHE LYS ASN          
SEQRES   9 B  252  GLU PHE ASP ALA VAL THR MET PHE PHE SER THR ILE MET          
SEQRES  10 B  252  TYR PHE ASP GLU GLU ASP LEU ARG LYS LEU PHE SER LYS          
SEQRES  11 B  252  VAL ALA GLU ALA LEU LYS PRO GLY GLY VAL PHE ILE THR          
SEQRES  12 B  252  ASP PHE PRO CYS TRP PHE TYR GLY GLY ARG ASP GLY PRO          
SEQRES  13 B  252  VAL VAL TRP ASN GLU GLN LYS GLY GLU GLU LYS LEU VAL          
SEQRES  14 B  252  ILE MET ASP TRP ARG GLU VAL GLU PRO ALA VAL GLN LYS          
SEQRES  15 B  252  LEU ARG PHE LYS ARG LEU VAL GLN ILE LEU ARG PRO ASN          
SEQRES  16 B  252  GLY GLU VAL LYS ALA PHE LEU VAL ASP ASP GLU LEU ASN          
SEQRES  17 B  252  ILE TYR THR PRO ARG GLU VAL ARG LEU LEU ALA GLU LYS          
SEQRES  18 B  252  TYR PHE GLU LYS VAL LYS ILE TYR GLY ASN LEU LYS ARG          
SEQRES  19 B  252  GLU LEU SER PRO ASN ASP MET ARG TYR TRP ILE VAL GLY          
SEQRES  20 B  252  ILE ALA LYS SER PHE                                          
SEQRES   1 C  252  MET TYR GLU LEU TYR THR LEU LEU ALA GLU TYR TYR ASP          
SEQRES   2 C  252  THR ILE TYR ARG ARG ARG ILE GLU ARG VAL LYS ALA GLU          
SEQRES   3 C  252  ILE ASP PHE VAL GLU GLU ILE PHE LYS GLU ASP ALA LYS          
SEQRES   4 C  252  ARG GLU VAL ARG ARG VAL LEU ASP LEU ALA CYS GLY THR          
SEQRES   5 C  252  GLY ILE PRO THR LEU GLU LEU ALA GLU ARG GLY TYR GLU          
SEQRES   6 C  252  VAL VAL GLY LEU ASP LEU HIS GLU GLU MET LEU ARG VAL          
SEQRES   7 C  252  ALA ARG ARG LYS ALA LYS GLU ARG ASN LEU LYS ILE GLU          
SEQRES   8 C  252  PHE LEU GLN GLY ASP VAL LEU GLU ILE ALA PHE LYS ASN          
SEQRES   9 C  252  GLU PHE ASP ALA VAL THR MET PHE PHE SER THR ILE MET          
SEQRES  10 C  252  TYR PHE ASP GLU GLU ASP LEU ARG LYS LEU PHE SER LYS          
SEQRES  11 C  252  VAL ALA GLU ALA LEU LYS PRO GLY GLY VAL PHE ILE THR          
SEQRES  12 C  252  ASP PHE PRO CYS TRP PHE TYR GLY GLY ARG ASP GLY PRO          
SEQRES  13 C  252  VAL VAL TRP ASN GLU GLN LYS GLY GLU GLU LYS LEU VAL          
SEQRES  14 C  252  ILE MET ASP TRP ARG GLU VAL GLU PRO ALA VAL GLN LYS          
SEQRES  15 C  252  LEU ARG PHE LYS ARG LEU VAL GLN ILE LEU ARG PRO ASN          
SEQRES  16 C  252  GLY GLU VAL LYS ALA PHE LEU VAL ASP ASP GLU LEU ASN          
SEQRES  17 C  252  ILE TYR THR PRO ARG GLU VAL ARG LEU LEU ALA GLU LYS          
SEQRES  18 C  252  TYR PHE GLU LYS VAL LYS ILE TYR GLY ASN LEU LYS ARG          
SEQRES  19 C  252  GLU LEU SER PRO ASN ASP MET ARG TYR TRP ILE VAL GLY          
SEQRES  20 C  252  ILE ALA LYS SER PHE                                          
HET    SO4   1004       5                                                       
HET    SO4   1005       5                                                       
HET    SO4   1006       5                                                       
HET     MG   1007       1                                                       
HET    SAH   1001      26                                                       
HET    SAH   1002      26                                                       
HET    SAH   1003      26                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     SAH S-ADENOSYL-L-HOMOCYSTEINE                                        
FORMUL   4  SO4    3(O4 S 2-)                                                   
FORMUL   7   MG    MG 2+                                                        
FORMUL   8  SAH    3(C14 H20 N6 O5 S)                                           
FORMUL  11  HOH   *615(H2 O)                                                    
CRYST1  108.357  132.011  145.991  90.00  90.00  90.00 C 2 2 21     24          
ATOM      1  N   MET A   1       6.041  -5.668  29.035  1.00 32.65           N  
ATOM      2  CA  MET A   1       6.120  -4.744  27.865  1.00 32.46           C  
ATOM      3  C   MET A   1       4.773  -4.069  27.614  1.00 28.20           C  
ATOM      4  O   MET A   1       3.738  -4.532  28.087  1.00 28.01           O  
ATOM      5  CB  MET A   1       6.541  -5.514  26.610  1.00 37.53           C  
ATOM      6  CG  MET A   1       5.487  -6.486  26.096  1.00 42.96           C  
ATOM      7  SD  MET A   1       5.948  -7.309  24.547  1.00 48.57           S  
ATOM      8  CE  MET A   1       6.395  -8.950  25.167  1.00 48.98           C  
ATOM      9  N   TYR A   2       4.804  -2.976  26.859  1.00 25.39           N  
ATOM     10  CA  TYR A   2       3.612  -2.208  26.512  1.00 22.49           C  
ATOM     11  C   TYR A   2       2.926  -1.500  27.681  1.00 22.30           C  
ATOM     12  O   TYR A   2       1.812  -0.999  27.521  1.00 21.08           O  
ATOM     13  CB  TYR A   2       2.584  -3.095  25.804  1.00 21.51           C  
ATOM     14  CG  TYR A   2       3.117  -3.852  24.605  1.00 19.58           C  
ATOM     15  CD1 TYR A   2       3.900  -3.216  23.639  1.00 20.48           C  
ATOM     16  CD2 TYR A   2       2.797  -5.196  24.416  1.00 23.53           C  
ATOM     17  CE1 TYR A   2       4.346  -3.902  22.508  1.00 21.65           C  
ATOM     18  CE2 TYR A   2       3.237  -5.894  23.291  1.00 24.91           C  
ATOM     19  CZ  TYR A   2       4.007  -5.240  22.341  1.00 24.64           C  
ATOM     20  OH  TYR A   2       4.421  -5.923  21.220  1.00 25.97           O  
ATOM     21  N   GLU A   3       3.575  -1.447  28.844  1.00 21.46           N  
ATOM     22  CA  GLU A   3       2.985  -0.771  30.005  1.00 22.42           C  
ATOM     23  C   GLU A   3       2.587   0.664  29.668  1.00 20.85           C  
ATOM     24  O   GLU A   3       1.615   1.196  30.205  1.00 20.78           O  
ATOM     25  CB  GLU A   3       3.974  -0.712  31.175  1.00 25.10           C  
ATOM     26  CG  GLU A   3       4.387  -2.040  31.763  1.00 29.31           C  
ATOM     27  CD  GLU A   3       5.260  -2.860  30.832  1.00 31.01           C  
ATOM     28  OE1 GLU A   3       5.987  -2.278  29.983  1.00 30.77           O  
ATOM     29  OE2 GLU A   3       5.227  -4.097  30.973  1.00 33.43           O  
ATOM     30  N   LEU A   4       3.363   1.292  28.794  1.00 20.95           N  
ATOM     31  CA  LEU A   4       3.116   2.673  28.393  1.00 21.97           C  
ATOM     32  C   LEU A   4       1.837   2.842  27.575  1.00 22.38           C  
ATOM     33  O   LEU A   4       1.234   3.917  27.569  1.00 22.81           O  
ATOM     34  CB  LEU A   4       4.310   3.183  27.584  1.00 23.95           C  
ATOM     35  CG  LEU A   4       4.336   4.642  27.129  1.00 23.77           C  
ATOM     36  CD1 LEU A   4       4.355   5.565  28.344  1.00 25.67           C  
ATOM     37  CD2 LEU A   4       5.571   4.872  26.266  1.00 24.54           C  
ATOM     38  N   TYR A   5       1.415   1.771  26.906  1.00 20.80           N  
ATOM     39  CA  TYR A   5       0.240   1.810  26.039  1.00 20.06           C  
ATOM     40  C   TYR A   5      -1.025   1.208  26.624  1.00 20.73           C  
ATOM     41  O   TYR A   5      -2.081   1.206  25.983  1.00 21.17           O  
ATOM     42  CB  TYR A   5       0.587   1.115  24.726  1.00 19.88           C  
ATOM     43  CG  TYR A   5       1.929   1.567  24.212  1.00 20.54           C  
ATOM     44  CD1 TYR A   5       2.224   2.923  24.115  1.00 19.73           C  
ATOM     45  CD2 TYR A   5       2.915   0.649  23.855  1.00 19.10           C  
ATOM     46  CE1 TYR A   5       3.460   3.361  23.681  1.00 20.36           C  
ATOM     47  CE2 TYR A   5       4.163   1.079  23.416  1.00 19.55           C  
ATOM     48  CZ  TYR A   5       4.426   2.437  23.335  1.00 19.70           C  
ATOM     49  OH  TYR A   5       5.654   2.893  22.930  1.00 22.20           O  
ATOM     50  N   THR A   6      -0.919   0.698  27.842  1.00 19.80           N  
ATOM     51  CA  THR A   6      -2.068   0.120  28.518  1.00 21.15           C  
ATOM     52  C   THR A   6      -2.361   0.865  29.819  1.00 21.52           C  
ATOM     53  O   THR A   6      -3.227   1.726  29.895  1.00 20.11           O  
ATOM     54  CB  THR A   6      -1.789  -1.364  28.782  1.00 21.56           C  
ATOM     55  OG1 THR A   6      -0.524  -1.508  29.440  1.00 22.45           O  
ATOM     56  CG2 THR A   6      -1.747  -2.130  27.459  1.00 23.16           C  
ATOM     57  N   LEU A   7      -1.619   0.504  30.878  1.00 21.98           N  
ATOM     58  CA  LEU A   7      -1.872   1.149  32.160  1.00 21.50           C  
ATOM     59  C   LEU A   7      -1.566   2.657  32.138  1.00 20.17           C  
ATOM     60  O   LEU A   7      -2.161   3.439  32.868  1.00 21.17           O  
ATOM     61  CB  LEU A   7      -1.070   0.430  33.249  1.00 24.97           C  
ATOM     62  CG  LEU A   7      -1.576  -0.998  33.487  1.00 28.88           C  
ATOM     63  CD1 LEU A   7      -0.443  -1.999  33.720  1.00 32.29           C  
ATOM     64  CD2 LEU A   7      -2.511  -1.116  34.694  1.00 32.23           C  
ATOM     65  N   LEU A   8      -0.591   3.068  31.284  1.00 19.78           N  
ATOM     66  CA  LEU A   8      -0.207   4.489  31.244  1.00 17.57           C  
ATOM     67  C   LEU A   8      -0.822   5.212  30.041  1.00 17.19           C  
ATOM     68  O   LEU A   8      -0.534   6.367  29.748  1.00 16.69           O  
ATOM     69  CB  LEU A   8       1.327   4.604  31.171  1.00 17.85           C  
ATOM     70  CG  LEU A   8       2.018   4.278  32.500  1.00 18.02           C  
ATOM     71  CD1 LEU A   8       3.534   4.164  32.348  1.00 17.95           C  
ATOM     72  CD2 LEU A   8       1.774   5.344  33.574  1.00 19.77           C  
ATOM     73  N   ALA A   9      -1.709   4.562  29.294  1.00 16.98           N  
ATOM     74  CA  ALA A   9      -2.291   5.187  28.105  1.00 16.64           C  
ATOM     75  C   ALA A   9      -2.870   6.586  28.328  1.00 15.81           C  
ATOM     76  O   ALA A   9      -2.608   7.493  27.546  1.00 16.31           O  
ATOM     77  CB  ALA A   9      -3.360   4.267  27.496  1.00 16.08           C  
ATOM     78  N   GLU A  10      -3.658   6.761  29.384  1.00 17.78           N  
ATOM     79  CA  GLU A  10      -4.257   8.064  29.663  1.00 18.05           C  
ATOM     80  C   GLU A  10      -3.222   9.143  30.008  1.00 20.73           C  
ATOM     81  O   GLU A  10      -3.559  10.327  30.079  1.00 21.21           O  
ATOM     82  CB  GLU A  10      -5.280   7.958  30.806  1.00 20.13           C  
ATOM     83  CG  GLU A  10      -6.526   7.126  30.508  1.00 19.34           C  
ATOM     84  CD  GLU A  10      -7.353   7.665  29.347  1.00 19.49           C  
ATOM     85  OE1 GLU A  10      -7.265   8.875  29.048  1.00 21.21           O  
ATOM     86  OE2 GLU A  10      -8.102   6.873  28.742  1.00 22.53           O  
ATOM     87  N   TYR A  11      -1.968   8.742  30.214  1.00 19.43           N  
ATOM     88  CA  TYR A  11      -0.904   9.691  30.539  1.00 18.86           C  
ATOM     89  C   TYR A  11       0.053   9.889  29.370  1.00 19.26           C  
ATOM     90  O   TYR A  11       0.955  10.723  29.431  1.00 20.02           O  
ATOM     91  CB  TYR A  11      -0.105   9.206  31.758  1.00 20.17           C  
ATOM     92  CG  TYR A  11      -0.914   9.120  33.031  1.00 20.71           C  
ATOM     93  CD1 TYR A  11      -1.206  10.263  33.777  1.00 20.52           C  
ATOM     94  CD2 TYR A  11      -1.419   7.898  33.471  1.00 18.93           C  
ATOM     95  CE1 TYR A  11      -1.986  10.188  34.934  1.00 21.16           C  
ATOM     96  CE2 TYR A  11      -2.198   7.814  34.626  1.00 22.41           C  
ATOM     97  CZ  TYR A  11      -2.477   8.962  35.348  1.00 20.84           C  
ATOM     98  OH  TYR A  11      -3.249   8.871  36.482  1.00 24.73           O  
ATOM     99  N   TYR A  12      -0.140   9.123  28.301  1.00 18.12           N  
ATOM    100  CA  TYR A  12       0.736   9.221  27.135  1.00 16.77           C  
ATOM    101  C   TYR A  12       0.880  10.646  26.579  1.00 16.22           C  
ATOM    102  O   TYR A  12       1.992  11.115  26.333  1.00 16.56           O  
ATOM    103  CB  TYR A  12       0.235   8.292  26.017  1.00 16.74           C  
ATOM    104  CG  TYR A  12       1.214   8.154  24.866  1.00 17.21           C  
ATOM    105  CD1 TYR A  12       2.263   7.227  24.920  1.00 15.89           C  
ATOM    106  CD2 TYR A  12       1.113   8.967  23.742  1.00 17.10           C  
ATOM    107  CE1 TYR A  12       3.182   7.122  23.879  1.00 16.25           C  
ATOM    108  CE2 TYR A  12       2.029   8.871  22.697  1.00 16.83           C  
ATOM    109  CZ  TYR A  12       3.061   7.946  22.774  1.00 17.14           C  
ATOM    110  OH  TYR A  12       3.976   7.869  21.754  1.00 18.92           O  
ATOM    111  N   ASP A  13      -0.238  11.334  26.367  1.00 16.62           N  
ATOM    112  CA  ASP A  13      -0.189  12.688  25.826  1.00 15.70           C  
ATOM    113  C   ASP A  13       0.487  13.666  26.791  1.00 16.77           C  
ATOM    114  O   ASP A  13       1.062  14.668  26.366  1.00 17.30           O  
ATOM    115  CB  ASP A  13      -1.601  13.179  25.466  1.00 16.86           C  
ATOM    116  CG  ASP A  13      -2.156  12.492  24.221  1.00 16.96           C  
ATOM    117  OD1 ASP A  13      -1.441  11.640  23.649  1.00 14.35           O  
ATOM    118  OD2 ASP A  13      -3.298  12.801  23.813  1.00 17.55           O  
ATOM    119  N   THR A  14       0.417  13.368  28.082  1.00 16.14           N  
ATOM    120  CA  THR A  14       1.039  14.220  29.099  1.00 18.13           C  
ATOM    121  C   THR A  14       2.545  14.013  29.029  1.00 18.28           C  
ATOM    122  O   THR A  14       3.325  14.968  28.952  1.00 20.67           O  
ATOM    123  CB  THR A  14       0.533  13.849  30.498  1.00 18.49           C  
ATOM    124  OG1 THR A  14      -0.851  14.209  30.603  1.00 19.00           O  
ATOM    125  CG2 THR A  14       1.346  14.564  31.589  1.00 19.12           C  
ATOM    126  N   ILE A  15       2.945  12.748  29.034  1.00 18.69           N  
ATOM    127  CA  ILE A  15       4.351  12.380  28.957  1.00 18.85           C  
ATOM    128  C   ILE A  15       4.962  12.956  27.677  1.00 19.91           C  
ATOM    129  O   ILE A  15       6.097  13.438  27.681  1.00 20.81           O  
ATOM    130  CB  ILE A  15       4.499  10.838  28.969  1.00 19.77           C  
ATOM    131  CG1 ILE A  15       4.072  10.293  30.335  1.00 18.33           C  
ATOM    132  CG2 ILE A  15       5.932  10.434  28.627  1.00 19.25           C  
ATOM    133  CD1 ILE A  15       3.892   8.788  30.379  1.00 19.59           C  
ATOM    134  N   TYR A  16       4.202  12.934  26.584  1.00 19.22           N  
ATOM    135  CA  TYR A  16       4.774  13.415  25.330  1.00 21.36           C  
ATOM    136  C   TYR A  16       4.188  14.764  24.896  1.00 22.75           C  
ATOM    137  O   TYR A  16       3.811  14.971  23.751  1.00 22.45           O  
ATOM    138  CB  TYR A  16       4.517  12.364  24.250  1.00 21.34           C  
ATOM    139  CG  TYR A  16       5.402  11.189  24.468  1.00 22.52           C  
ATOM    140  CD1 TYR A  16       6.772  11.296  24.240  1.00 23.07           C  
ATOM    141  CD2 TYR A  16       4.868   9.980  24.920  1.00 21.48           C  
ATOM    142  CE1 TYR A  16       7.603  10.209  24.473  1.00 24.54           C  
ATOM    143  CE2 TYR A  16       5.701   8.892  25.145  1.00 21.91           C  
ATOM    144  CZ  TYR A  16       7.062   9.001  24.924  1.00 23.92           C  
ATOM    145  OH  TYR A  16       7.904   7.929  25.171  1.00 26.27           O  
ATOM    146  N   ARG A  17       4.088  15.687  25.874  1.00 25.01           N  
ATOM    147  CA  ARG A  17       3.583  17.026  25.575  1.00 27.77           C  
ATOM    148  C   ARG A  17       4.404  17.701  24.471  1.00 28.48           C  
ATOM    149  O   ARG A  17       3.895  18.424  23.625  1.00 27.53           O  
ATOM    150  CB  ARG A  17       3.659  17.850  26.862  1.00 29.21           C  
ATOM    151  CG  ARG A  17       3.360  19.331  26.637  1.00 31.25           C  
ATOM    152  CD  ARG A  17       3.484  20.143  27.933  1.00 34.51           C  
ATOM    153  NE  ARG A  17       4.751  19.850  28.610  1.00 35.34           N  
ATOM    154  CZ  ARG A  17       5.878  20.302  28.031  1.00 39.06           C  
ATOM    155  NH1 ARG A  17       5.816  20.988  26.903  1.00 39.75           N  
ATOM    156  NH2 ARG A  17       7.061  20.055  28.603  1.00 40.13           N  
ATOM    157  N   ARG A  18       5.730  17.466  24.525  1.00 31.16           N  
ATOM    158  CA  ARG A  18       6.616  18.094  23.551  1.00 34.22           C  
ATOM    159  C   ARG A  18       6.359  17.581  22.134  1.00 34.68           C  
ATOM    160  O   ARG A  18       6.317  18.330  21.165  1.00 34.84           O  
ATOM    161  CB  ARG A  18       8.058  17.796  23.962  1.00 37.80           C  
ATOM    162  CG  ARG A  18       8.413  18.415  25.314  1.00 42.16           C  
ATOM    163  CD  ARG A  18       9.897  18.248  25.654  1.00 46.97           C  
ATOM    164  NE  ARG A  18      10.179  18.774  26.992  1.00 51.93           N  
ATOM    165  CZ  ARG A  18       9.851  17.996  28.041  1.00 52.43           C  
ATOM    166  NH1 ARG A  18       9.320  16.803  27.842  1.00 53.35           N  
ATOM    167  NH2 ARG A  18      10.047  18.447  29.284  1.00 54.00           N  
ATOM    168  N   ARG A  19       6.226  16.248  22.025  1.00 35.43           N  
ATOM    169  CA  ARG A  19       5.949  15.668  20.718  1.00 36.23           C  
ATOM    170  C   ARG A  19       4.709  16.294  20.079  1.00 34.74           C  
ATOM    171  O   ARG A  19       4.617  16.460  18.870  1.00 36.73           O  
ATOM    172  CB  ARG A  19       5.740  14.164  20.899  1.00 36.74           C  
ATOM    173  CG  ARG A  19       5.784  13.407  19.572  1.00 39.82           C  
ATOM    174  CD  ARG A  19       4.419  12.817  19.200  1.00 39.76           C  
ATOM    175  NE  ARG A  19       4.551  11.877  18.084  1.00 39.61           N  
ATOM    176  CZ  ARG A  19       4.536  12.390  16.839  1.00 41.69           C  
ATOM    177  NH1 ARG A  19       4.414  13.694  16.660  1.00 40.67           N  
ATOM    178  NH2 ARG A  19       4.645  11.574  15.787  1.00 42.06           N  
ATOM    179  N   ILE A  20       3.724  16.610  20.941  1.00 34.27           N  
ATOM    180  CA  ILE A  20       2.485  17.193  20.437  1.00 32.67           C  
ATOM    181  C   ILE A  20       2.674  18.647  20.000  1.00 34.38           C  
ATOM    182  O   ILE A  20       2.077  19.126  19.044  1.00 31.54           O  
ATOM    183  CB  ILE A  20       1.435  17.127  21.545  1.00 32.24           C  
ATOM    184  CG1 ILE A  20       1.002  15.678  21.786  1.00 30.06           C  
ATOM    185  CG2 ILE A  20       0.187  17.927  21.129  1.00 33.26           C  
ATOM    186  CD1 ILE A  20      -0.113  15.574  22.829  1.00 27.47           C  
ATOM    187  N   GLU A  21       3.510  19.371  20.766  1.00 34.40           N  
ATOM    188  CA  GLU A  21       3.679  20.791  20.490  1.00 36.69           C  
ATOM    189  C   GLU A  21       4.289  21.052  19.108  1.00 36.74           C  
ATOM    190  O   GLU A  21       4.210  22.144  18.561  1.00 38.45           O  
ATOM    191  CB  GLU A  21       4.566  21.394  21.586  1.00 37.67           C  
ATOM    192  CG  GLU A  21       3.763  22.220  22.594  1.00 41.06           C  
ATOM    193  CD  GLU A  21       4.516  22.292  23.903  1.00 42.60           C  
ATOM    194  OE1 GLU A  21       5.723  22.488  23.875  1.00 44.53           O  
ATOM    195  OE2 GLU A  21       3.881  22.159  24.949  1.00 43.20           O  
ATOM    196  N   ARG A  22       4.945  20.012  18.553  1.00 35.37           N  
ATOM    197  CA  ARG A  22       5.592  20.195  17.255  1.00 35.78           C  
ATOM    198  C   ARG A  22       5.033  19.264  16.174  1.00 33.74           C  
ATOM    199  O   ARG A  22       5.636  19.043  15.133  1.00 31.90           O  
ATOM    200  CB  ARG A  22       7.104  19.993  17.427  1.00 39.38           C  
ATOM    201  CG  ARG A  22       7.480  18.609  17.956  1.00 43.80           C  
ATOM    202  CD  ARG A  22       9.002  18.395  17.954  1.00 46.70           C  
ATOM    203  NE  ARG A  22       9.369  17.221  18.750  1.00 49.12           N  
ATOM    204  CZ  ARG A  22       8.998  16.020  18.272  1.00 50.47           C  
ATOM    205  NH1 ARG A  22       8.309  15.943  17.147  1.00 50.16           N  
ATOM    206  NH2 ARG A  22       9.443  14.909  18.864  1.00 49.29           N  
ATOM    207  N   VAL A  23       3.850  18.704  16.396  1.00 30.48           N  
ATOM    208  CA  VAL A  23       3.261  17.816  15.402  1.00 27.84           C  
ATOM    209  C   VAL A  23       2.963  18.560  14.102  1.00 24.42           C  
ATOM    210  O   VAL A  23       3.022  17.980  13.016  1.00 24.89           O  
ATOM    211  CB  VAL A  23       1.952  17.162  15.932  1.00 26.66           C  
ATOM    212  CG1 VAL A  23       0.877  18.220  16.150  1.00 26.40           C  
ATOM    213  CG2 VAL A  23       1.475  16.102  14.957  1.00 25.73           C  
ATOM    214  N   LYS A  24       2.652  19.847  14.205  1.00 23.94           N  
ATOM    215  CA  LYS A  24       2.337  20.628  13.012  1.00 24.41           C  
ATOM    216  C   LYS A  24       3.536  20.766  12.084  1.00 22.50           C  
ATOM    217  O   LYS A  24       3.393  20.696  10.868  1.00 22.18           O  
ATOM    218  CB  LYS A  24       1.782  22.002  13.405  1.00 26.07           C  
ATOM    219  CG  LYS A  24       0.455  21.900  14.155  1.00 28.73           C  
ATOM    220  CD  LYS A  24      -0.210  23.252  14.359  1.00 30.41           C  
ATOM    221  CE  LYS A  24      -1.508  23.104  15.154  1.00 31.20           C  
ATOM    222  NZ  LYS A  24      -2.498  22.203  14.492  1.00 28.93           N  
ATOM    223  N   ALA A  25       4.722  20.948  12.654  1.00 22.27           N  
ATOM    224  CA  ALA A  25       5.928  21.060  11.841  1.00 22.19           C  
ATOM    225  C   ALA A  25       6.213  19.714  11.182  1.00 21.33           C  
ATOM    226  O   ALA A  25       6.666  19.656  10.040  1.00 20.50           O  
ATOM    227  CB  ALA A  25       7.122  21.481  12.713  1.00 24.37           C  
ATOM    228  N   GLU A  26       5.948  18.629  11.905  1.00 20.70           N  
ATOM    229  CA  GLU A  26       6.192  17.302  11.358  1.00 21.58           C  
ATOM    230  C   GLU A  26       5.248  16.973  10.213  1.00 19.66           C  
ATOM    231  O   GLU A  26       5.667  16.411   9.209  1.00 19.07           O  
ATOM    232  CB  GLU A  26       6.083  16.234  12.453  1.00 26.59           C  
ATOM    233  CG  GLU A  26       7.341  16.120  13.301  1.00 33.57           C  
ATOM    234  CD  GLU A  26       7.349  14.901  14.194  1.00 37.13           C  
ATOM    235  OE1 GLU A  26       8.368  14.687  14.883  1.00 39.97           O  
ATOM    236  OE2 GLU A  26       6.344  14.155  14.213  1.00 39.74           O  
ATOM    237  N   ILE A  27       3.975  17.331  10.340  1.00 17.63           N  
ATOM    238  CA  ILE A  27       3.051  17.027   9.255  1.00 18.48           C  
ATOM    239  C   ILE A  27       3.301  17.942   8.054  1.00 17.58           C  
ATOM    240  O   ILE A  27       2.991  17.582   6.920  1.00 18.80           O  
ATOM    241  CB  ILE A  27       1.589  17.083   9.748  1.00 18.48           C  
ATOM    242  CG1 ILE A  27       1.388  15.987  10.803  1.00 16.01           C  
ATOM    243  CG2 ILE A  27       0.621  16.862   8.591  1.00 19.31           C  
ATOM    244  CD1 ILE A  27       1.872  14.596  10.366  1.00 17.91           C  
ATOM    245  N   ASP A  28       3.880  19.116   8.295  1.00 19.51           N  
ATOM    246  CA  ASP A  28       4.223  20.016   7.189  1.00 19.99           C  
ATOM    247  C   ASP A  28       5.241  19.262   6.334  1.00 20.72           C  
ATOM    248  O   ASP A  28       5.173  19.275   5.108  1.00 20.14           O  
ATOM    249  CB  ASP A  28       4.896  21.305   7.685  1.00 21.31           C  
ATOM    250  CG  ASP A  28       3.914  22.317   8.238  1.00 23.82           C  
ATOM    251  OD1 ASP A  28       2.692  22.122   8.082  1.00 23.24           O  
ATOM    252  OD2 ASP A  28       4.382  23.323   8.819  1.00 21.90           O  
ATOM    253  N   PHE A  29       6.200  18.620   7.000  1.00 20.16           N  
ATOM    254  CA  PHE A  29       7.236  17.853   6.309  1.00 18.99           C  
ATOM    255  C   PHE A  29       6.613  16.662   5.592  1.00 18.48           C  
ATOM    256  O   PHE A  29       6.964  16.361   4.452  1.00 18.84           O  
ATOM    257  CB  PHE A  29       8.300  17.365   7.303  1.00 18.30           C  
ATOM    258  CG  PHE A  29       9.392  16.539   6.669  1.00 18.97           C  
ATOM    259  CD1 PHE A  29      10.087  17.013   5.560  1.00 20.29           C  
ATOM    260  CD2 PHE A  29       9.726  15.289   7.184  1.00 17.78           C  
ATOM    261  CE1 PHE A  29      11.105  16.249   4.968  1.00 21.74           C  
ATOM    262  CE2 PHE A  29      10.741  14.517   6.601  1.00 19.98           C  
ATOM    263  CZ  PHE A  29      11.428  14.998   5.492  1.00 20.06           C  
ATOM    264  N   VAL A  30       5.692  15.983   6.266  1.00 18.01           N  
ATOM    265  CA  VAL A  30       5.015  14.841   5.668  1.00 17.44           C  
ATOM    266  C   VAL A  30       4.291  15.260   4.387  1.00 17.72           C  
ATOM    267  O   VAL A  30       4.353  14.557   3.380  1.00 17.76           O  
ATOM    268  CB  VAL A  30       4.005  14.209   6.657  1.00 18.52           C  
ATOM    269  CG1 VAL A  30       3.138  13.163   5.942  1.00 18.21           C  
ATOM    270  CG2 VAL A  30       4.765  13.553   7.810  1.00 15.79           C  
ATOM    271  N   GLU A  31       3.620  16.410   4.409  1.00 17.46           N  
ATOM    272  CA  GLU A  31       2.913  16.860   3.211  1.00 20.06           C  
ATOM    273  C   GLU A  31       3.885  17.200   2.087  1.00 20.32           C  
ATOM    274  O   GLU A  31       3.550  17.059   0.911  1.00 21.37           O  
ATOM    275  CB  GLU A  31       2.026  18.074   3.499  1.00 20.94           C  
ATOM    276  CG  GLU A  31       0.856  17.790   4.420  1.00 21.56           C  
ATOM    277  CD  GLU A  31      -0.243  18.825   4.276  1.00 21.36           C  
ATOM    278  OE1 GLU A  31      -1.157  18.608   3.451  1.00 22.78           O  
ATOM    279  OE2 GLU A  31      -0.183  19.856   4.974  1.00 20.61           O  
ATOM    280  N   GLU A  32       5.084  17.660   2.437  1.00 21.68           N  
ATOM    281  CA  GLU A  32       6.064  17.963   1.401  1.00 22.90           C  
ATOM    282  C   GLU A  32       6.465  16.640   0.750  1.00 22.30           C  
ATOM    283  O   GLU A  32       6.674  16.571  -0.461  1.00 22.72           O  
ATOM    284  CB  GLU A  32       7.298  18.663   1.975  1.00 27.06           C  
ATOM    285  CG  GLU A  32       8.386  18.856   0.927  1.00 33.02           C  
ATOM    286  CD  GLU A  32       9.475  19.813   1.360  1.00 39.59           C  
ATOM    287  OE1 GLU A  32      10.088  19.584   2.425  1.00 41.06           O  
ATOM    288  OE2 GLU A  32       9.720  20.797   0.626  1.00 43.06           O  
ATOM    289  N   ILE A  33       6.562  15.581   1.551  1.00 21.69           N  
ATOM    290  CA  ILE A  33       6.909  14.274   1.005  1.00 19.48           C  
ATOM    291  C   ILE A  33       5.787  13.815   0.069  1.00 20.79           C  
ATOM    292  O   ILE A  33       6.052  13.312  -1.025  1.00 22.77           O  
ATOM    293  CB  ILE A  33       7.126  13.225   2.128  1.00 19.57           C  
ATOM    294  CG1 ILE A  33       8.353  13.600   2.971  1.00 17.10           C  
ATOM    295  CG2 ILE A  33       7.343  11.847   1.522  1.00 18.24           C  
ATOM    296  CD1 ILE A  33       8.590  12.660   4.147  1.00 18.83           C  
ATOM    297  N   PHE A  34       4.534  13.988   0.492  1.00 19.15           N  
ATOM    298  CA  PHE A  34       3.392  13.603  -0.346  1.00 21.45           C  
ATOM    299  C   PHE A  34       3.465  14.322  -1.694  1.00 21.64           C  
ATOM    300  O   PHE A  34       3.267  13.723  -2.750  1.00 21.45           O  
ATOM    301  CB  PHE A  34       2.054  13.987   0.310  1.00 18.80           C  
ATOM    302  CG  PHE A  34       1.696  13.179   1.533  1.00 18.73           C  
ATOM    303  CD1 PHE A  34       2.311  11.958   1.800  1.00 18.80           C  
ATOM    304  CD2 PHE A  34       0.692  13.628   2.393  1.00 19.37           C  
ATOM    305  CE1 PHE A  34       1.924  11.192   2.910  1.00 19.97           C  
ATOM    306  CE2 PHE A  34       0.301  12.873   3.499  1.00 19.87           C  
ATOM    307  CZ  PHE A  34       0.918  11.651   3.759  1.00 19.08           C  
ATOM    308  N   LYS A  35       3.761  15.614  -1.641  1.00 24.25           N  
ATOM    309  CA  LYS A  35       3.834  16.439  -2.840  1.00 27.35           C  
ATOM    310  C   LYS A  35       5.008  16.154  -3.766  1.00 28.45           C  
ATOM    311  O   LYS A  35       4.841  16.098  -4.984  1.00 27.21           O  
ATOM    312  CB  LYS A  35       3.851  17.917  -2.441  1.00 30.55           C  
ATOM    313  CG  LYS A  35       4.138  18.882  -3.585  1.00 34.79           C  
ATOM    314  CD  LYS A  35       4.240  20.306  -3.067  1.00 38.22           C  
ATOM    315  CE  LYS A  35       4.702  21.267  -4.148  1.00 40.83           C  
ATOM    316  NZ  LYS A  35       4.919  22.637  -3.600  1.00 43.16           N  
ATOM    317  N   GLU A  36       6.191  15.963  -3.192  1.00 27.86           N  
ATOM    318  CA  GLU A  36       7.389  15.744  -3.992  1.00 27.93           C  
ATOM    319  C   GLU A  36       7.809  14.295  -4.237  1.00 28.45           C  
ATOM    320  O   GLU A  36       8.370  13.985  -5.288  1.00 28.08           O  
ATOM    321  CB  GLU A  36       8.567  16.497  -3.367  1.00 27.66           C  
ATOM    322  CG  GLU A  36       8.362  17.992  -3.201  1.00 30.69           C  
ATOM    323  CD  GLU A  36       8.101  18.704  -4.515  1.00 33.11           C  
ATOM    324  OE1 GLU A  36       8.676  18.293  -5.542  1.00 34.46           O  
ATOM    325  OE2 GLU A  36       7.330  19.686  -4.519  1.00 34.79           O  
ATOM    326  N   ASP A  37       7.547  13.404  -3.287  1.00 26.06           N  
ATOM    327  CA  ASP A  37       7.954  12.014  -3.463  1.00 25.34           C  
ATOM    328  C   ASP A  37       6.898  11.055  -3.991  1.00 24.26           C  
ATOM    329  O   ASP A  37       7.215  10.145  -4.756  1.00 24.09           O  
ATOM    330  CB  ASP A  37       8.540  11.484  -2.156  1.00 26.54           C  
ATOM    331  CG  ASP A  37       9.840  12.177  -1.795  1.00 27.72           C  
ATOM    332  OD1 ASP A  37      10.797  12.071  -2.589  1.00 30.24           O  
ATOM    333  OD2 ASP A  37       9.901  12.836  -0.738  1.00 28.34           O  
ATOM    334  N   ALA A  38       5.649  11.244  -3.584  1.00 21.73           N  
ATOM    335  CA  ALA A  38       4.585  10.372  -4.057  1.00 22.10           C  
ATOM    336  C   ALA A  38       4.383  10.577  -5.556  1.00 22.76           C  
ATOM    337  O   ALA A  38       4.664  11.653  -6.085  1.00 24.05           O  
ATOM    338  CB  ALA A  38       3.289  10.668  -3.308  1.00 20.61           C  
ATOM    339  N   LYS A  39       3.900   9.546  -6.237  1.00 23.40           N  
ATOM    340  CA  LYS A  39       3.655   9.639  -7.674  1.00 25.76           C  
ATOM    341  C   LYS A  39       2.157   9.555  -7.945  1.00 25.87           C  
ATOM    342  O   LYS A  39       1.724   9.078  -8.996  1.00 26.18           O  
ATOM    343  CB  LYS A  39       4.386   8.523  -8.421  1.00 26.69           C  
ATOM    344  CG  LYS A  39       5.905   8.615  -8.341  1.00 32.12           C  
ATOM    345  CD  LYS A  39       6.403   9.941  -8.889  1.00 36.15           C  
ATOM    346  CE  LYS A  39       7.922   9.996  -8.904  1.00 40.91           C  
ATOM    347  NZ  LYS A  39       8.423  11.315  -9.384  1.00 42.79           N  
ATOM    348  N   ARG A  40       1.376  10.014  -6.974  1.00 23.37           N  
ATOM    349  CA  ARG A  40      -0.075  10.027  -7.086  1.00 22.72           C  
ATOM    350  C   ARG A  40      -0.570  11.031  -6.071  1.00 23.38           C  
ATOM    351  O   ARG A  40       0.167  11.395  -5.150  1.00 22.79           O  
ATOM    352  CB  ARG A  40      -0.670   8.641  -6.782  1.00 21.75           C  
ATOM    353  CG  ARG A  40      -0.472   8.140  -5.349  1.00 21.79           C  
ATOM    354  CD  ARG A  40      -1.156   6.790  -5.119  1.00 21.41           C  
ATOM    355  NE  ARG A  40      -2.575   6.837  -5.478  1.00 19.95           N  
ATOM    356  CZ  ARG A  40      -3.086   6.359  -6.614  1.00 21.87           C  
ATOM    357  NH1 ARG A  40      -2.303   5.778  -7.514  1.00 21.10           N  
ATOM    358  NH2 ARG A  40      -4.384   6.485  -6.860  1.00 17.45           N  
ATOM    359  N   GLU A  41      -1.805  11.494  -6.242  1.00 22.49           N  
ATOM    360  CA  GLU A  41      -2.380  12.441  -5.301  1.00 24.58           C  
ATOM    361  C   GLU A  41      -2.635  11.663  -4.017  1.00 22.98           C  
ATOM    362  O   GLU A  41      -3.127  10.535  -4.057  1.00 22.40           O  
ATOM    363  CB  GLU A  41      -3.694  13.011  -5.842  1.00 29.31           C  
ATOM    364  CG  GLU A  41      -4.422  13.907  -4.847  1.00 36.50           C  
ATOM    365  CD  GLU A  41      -5.648  14.578  -5.441  1.00 41.33           C  
ATOM    366  OE1 GLU A  41      -6.440  13.887  -6.121  1.00 44.85           O  
ATOM    367  OE2 GLU A  41      -5.827  15.793  -5.216  1.00 43.92           O  
ATOM    368  N   VAL A  42      -2.288  12.253  -2.879  1.00 21.94           N  
ATOM    369  CA  VAL A  42      -2.485  11.569  -1.608  1.00 21.13           C  
ATOM    370  C   VAL A  42      -3.726  12.091  -0.903  1.00 19.82           C  
ATOM    371  O   VAL A  42      -3.807  13.271  -0.567  1.00 18.91           O  
ATOM    372  CB  VAL A  42      -1.254  11.741  -0.683  1.00 20.53           C  
ATOM    373  CG1 VAL A  42      -1.549  11.155   0.695  1.00 20.73           C  
ATOM    374  CG2 VAL A  42      -0.048  11.048  -1.301  1.00 20.69           C  
ATOM    375  N   ARG A  43      -4.686  11.196  -0.688  1.00 21.10           N  
ATOM    376  CA  ARG A  43      -5.940  11.531  -0.024  1.00 20.82           C  
ATOM    377  C   ARG A  43      -6.241  10.606   1.151  1.00 19.07           C  
ATOM    378  O   ARG A  43      -6.605  11.070   2.228  1.00 20.59           O  
ATOM    379  CB  ARG A  43      -7.103  11.446  -1.019  1.00 24.22           C  
ATOM    380  CG  ARG A  43      -7.057  12.467  -2.148  1.00 32.66           C  
ATOM    381  CD  ARG A  43      -8.127  12.153  -3.186  1.00 38.95           C  
ATOM    382  NE  ARG A  43      -8.167  13.129  -4.270  1.00 44.88           N  
ATOM    383  CZ  ARG A  43      -8.580  14.387  -4.131  1.00 47.89           C  
ATOM    384  NH1 ARG A  43      -8.992  14.827  -2.949  1.00 48.68           N  
ATOM    385  NH2 ARG A  43      -8.591  15.203  -5.178  1.00 48.92           N  
ATOM    386  N   ARG A  44      -6.093   9.301   0.934  1.00 17.55           N  
ATOM    387  CA  ARG A  44      -6.376   8.299   1.959  1.00 17.41           C  
ATOM    388  C   ARG A  44      -5.074   7.752   2.549  1.00 17.57           C  
ATOM    389  O   ARG A  44      -4.219   7.223   1.831  1.00 16.57           O  
ATOM    390  CB  ARG A  44      -7.220   7.170   1.350  1.00 18.19           C  
ATOM    391  CG  ARG A  44      -7.794   6.153   2.346  1.00 19.68           C  
ATOM    392  CD  ARG A  44      -8.835   5.283   1.633  1.00 25.98           C  
ATOM    393  NE  ARG A  44      -9.073   3.976   2.254  1.00 32.60           N  
ATOM    394  CZ  ARG A  44      -9.841   3.759   3.319  1.00 35.57           C  
ATOM    395  NH1 ARG A  44     -10.465   4.765   3.918  1.00 36.83           N  
ATOM    396  NH2 ARG A  44     -10.012   2.519   3.770  1.00 34.05           N  
ATOM    397  N   VAL A  45      -4.945   7.883   3.866  1.00 17.58           N  
ATOM    398  CA  VAL A  45      -3.739   7.469   4.585  1.00 16.43           C  
ATOM    399  C   VAL A  45      -4.022   6.439   5.668  1.00 15.46           C  
ATOM    400  O   VAL A  45      -5.000   6.553   6.393  1.00 13.75           O  
ATOM    401  CB  VAL A  45      -3.086   8.688   5.273  1.00 17.44           C  
ATOM    402  CG1 VAL A  45      -1.793   8.282   5.964  1.00 16.18           C  
ATOM    403  CG2 VAL A  45      -2.827   9.788   4.250  1.00 19.08           C  
ATOM    404  N   LEU A  46      -3.153   5.437   5.767  1.00 14.10           N  
ATOM    405  CA  LEU A  46      -3.265   4.403   6.790  1.00 13.40           C  
ATOM    406  C   LEU A  46      -2.151   4.729   7.780  1.00 13.39           C  
ATOM    407  O   LEU A  46      -0.979   4.715   7.407  1.00 13.85           O  
ATOM    408  CB  LEU A  46      -3.015   3.009   6.198  1.00 12.86           C  
ATOM    409  CG  LEU A  46      -2.876   1.856   7.205  1.00 12.90           C  
ATOM    410  CD1 LEU A  46      -4.160   1.692   7.992  1.00 16.77           C  
ATOM    411  CD2 LEU A  46      -2.543   0.559   6.471  1.00 16.95           C  
ATOM    412  N   ASP A  47      -2.508   5.041   9.022  1.00 13.12           N  
ATOM    413  CA  ASP A  47      -1.498   5.360  10.027  1.00 12.89           C  
ATOM    414  C   ASP A  47      -1.360   4.162  10.971  1.00 13.10           C  
ATOM    415  O   ASP A  47      -2.210   3.934  11.828  1.00 12.68           O  
ATOM    416  CB  ASP A  47      -1.899   6.628  10.799  1.00 12.35           C  
ATOM    417  CG  ASP A  47      -0.820   7.083  11.766  1.00 13.68           C  
ATOM    418  OD1 ASP A  47       0.372   6.881  11.445  1.00 13.23           O  
ATOM    419  OD2 ASP A  47      -1.158   7.642  12.833  1.00 14.37           O  
ATOM    420  N   LEU A  48      -0.281   3.399  10.792  1.00 13.12           N  
ATOM    421  CA  LEU A  48      -0.008   2.191  11.575  1.00 12.47           C  
ATOM    422  C   LEU A  48       0.576   2.481  12.960  1.00 13.85           C  
ATOM    423  O   LEU A  48       1.447   3.333  13.098  1.00 14.46           O  
ATOM    424  CB  LEU A  48       0.951   1.287  10.785  1.00 13.80           C  
ATOM    425  CG  LEU A  48       0.481   0.852   9.379  1.00 13.79           C  
ATOM    426  CD1 LEU A  48       1.631   0.164   8.641  1.00 16.24           C  
ATOM    427  CD2 LEU A  48      -0.699  -0.098   9.489  1.00 15.05           C  
ATOM    428  N   ALA A  49       0.115   1.731  13.961  1.00 14.78           N  
ATOM    429  CA  ALA A  49       0.533   1.905  15.357  1.00 14.24           C  
ATOM    430  C   ALA A  49       0.306   3.373  15.690  1.00 14.83           C  
ATOM    431  O   ALA A  49       1.203   4.073  16.161  1.00 14.18           O  
ATOM    432  CB  ALA A  49       2.007   1.520  15.537  1.00 12.18           C  
ATOM    433  N   CYS A  50      -0.926   3.822  15.451  1.00 14.08           N  
ATOM    434  CA  CYS A  50      -1.314   5.217  15.647  1.00 13.98           C  
ATOM    435  C   CYS A  50      -1.367   5.757  17.067  1.00 13.47           C  
ATOM    436  O   CYS A  50      -1.461   6.969  17.250  1.00 13.12           O  
ATOM    437  CB  CYS A  50      -2.673   5.476  14.982  1.00 15.07           C  
ATOM    438  SG  CYS A  50      -4.029   4.565  15.738  1.00 14.62           S  
ATOM    439  N   GLY A  51      -1.321   4.877  18.063  1.00 14.53           N  
ATOM    440  CA  GLY A  51      -1.362   5.325  19.449  1.00 14.53           C  
ATOM    441  C   GLY A  51      -2.560   6.210  19.754  1.00 15.65           C  
ATOM    442  O   GLY A  51      -3.679   5.893  19.349  1.00 14.56           O  
ATOM    443  N   THR A  52      -2.327   7.308  20.472  1.00 15.37           N  
ATOM    444  CA  THR A  52      -3.382   8.260  20.823  1.00 14.06           C  
ATOM    445  C   THR A  52      -3.737   9.157  19.637  1.00 14.60           C  
ATOM    446  O   THR A  52      -4.511  10.111  19.769  1.00 14.83           O  
ATOM    447  CB  THR A  52      -2.969   9.159  21.991  1.00 12.74           C  
ATOM    448  OG1 THR A  52      -1.851   9.965  21.594  1.00 14.28           O  
ATOM    449  CG2 THR A  52      -2.600   8.313  23.216  1.00 14.16           C  
ATOM    450  N   GLY A  53      -3.155   8.852  18.482  1.00 14.56           N  
ATOM    451  CA  GLY A  53      -3.451   9.595  17.269  1.00 16.25           C  
ATOM    452  C   GLY A  53      -2.933  11.010  17.122  1.00 16.43           C  
ATOM    453  O   GLY A  53      -3.534  11.812  16.398  1.00 15.72           O  
ATOM    454  N   ILE A  54      -1.818  11.320  17.782  1.00 16.32           N  
ATOM    455  CA  ILE A  54      -1.237  12.657  17.709  1.00 16.49           C  
ATOM    456  C   ILE A  54      -1.069  13.120  16.255  1.00 17.43           C  
ATOM    457  O   ILE A  54      -1.662  14.121  15.853  1.00 16.61           O  
ATOM    458  CB  ILE A  54       0.100  12.706  18.497  1.00 16.06           C  
ATOM    459  CG1 ILE A  54      -0.212  12.621  19.997  1.00 18.21           C  
ATOM    460  CG2 ILE A  54       0.858  13.993  18.195  1.00 17.66           C  
ATOM    461  CD1 ILE A  54       0.990  12.404  20.892  1.00 19.30           C  
ATOM    462  N   PRO A  55      -0.270  12.403  15.440  1.00 16.69           N  
ATOM    463  CA  PRO A  55      -0.156  12.882  14.057  1.00 15.82           C  
ATOM    464  C   PRO A  55      -1.396  12.524  13.219  1.00 14.90           C  
ATOM    465  O   PRO A  55      -1.689  13.174  12.215  1.00 16.36           O  
ATOM    466  CB  PRO A  55       1.118  12.197  13.555  1.00 18.96           C  
ATOM    467  CG  PRO A  55       1.128  10.907  14.331  1.00 18.19           C  
ATOM    468  CD  PRO A  55       0.718  11.344  15.721  1.00 17.93           C  
ATOM    469  N   THR A  56      -2.116  11.487  13.645  1.00 14.69           N  
ATOM    470  CA  THR A  56      -3.325  11.021  12.961  1.00 15.56           C  
ATOM    471  C   THR A  56      -4.362  12.147  12.859  1.00 14.61           C  
ATOM    472  O   THR A  56      -4.899  12.421  11.787  1.00 15.00           O  
ATOM    473  CB  THR A  56      -3.970   9.841  13.732  1.00 14.27           C  
ATOM    474  OG1 THR A  56      -2.941   8.949  14.185  1.00 14.19           O  
ATOM    475  CG2 THR A  56      -4.929   9.069  12.829  1.00 13.54           C  
ATOM    476  N   LEU A  57      -4.649  12.781  13.989  1.00 15.65           N  
ATOM    477  CA  LEU A  57      -5.614  13.874  14.028  1.00 16.87           C  
ATOM    478  C   LEU A  57      -5.121  15.098  13.259  1.00 16.99           C  
ATOM    479  O   LEU A  57      -5.909  15.793  12.613  1.00 16.87           O  
ATOM    480  CB  LEU A  57      -5.936  14.248  15.480  1.00 18.91           C  
ATOM    481  CG  LEU A  57      -7.070  13.438  16.135  1.00 21.39           C  
ATOM    482  CD1 LEU A  57      -6.656  11.979  16.289  1.00 23.79           C  
ATOM    483  CD2 LEU A  57      -7.409  14.035  17.490  1.00 25.30           C  
ATOM    484  N   GLU A  58      -3.817  15.360  13.311  1.00 17.35           N  
ATOM    485  CA  GLU A  58      -3.264  16.503  12.589  1.00 18.38           C  
ATOM    486  C   GLU A  58      -3.478  16.302  11.082  1.00 18.83           C  
ATOM    487  O   GLU A  58      -3.858  17.235  10.364  1.00 15.95           O  
ATOM    488  CB  GLU A  58      -1.773  16.660  12.919  1.00 18.42           C  
ATOM    489  CG  GLU A  58      -1.073  17.831  12.231  1.00 18.43           C  
ATOM    490  CD  GLU A  58      -1.745  19.177  12.475  1.00 21.54           C  
ATOM    491  OE1 GLU A  58      -2.295  19.392  13.575  1.00 20.56           O  
ATOM    492  OE2 GLU A  58      -1.703  20.031  11.561  1.00 22.39           O  
ATOM    493  N   LEU A  59      -3.243  15.081  10.605  1.00 16.54           N  
ATOM    494  CA  LEU A  59      -3.451  14.763   9.192  1.00 16.37           C  
ATOM    495  C   LEU A  59      -4.940  14.894   8.851  1.00 17.55           C  
ATOM    496  O   LEU A  59      -5.303  15.433   7.805  1.00 17.47           O  
ATOM    497  CB  LEU A  59      -2.969  13.333   8.890  1.00 15.46           C  
ATOM    498  CG  LEU A  59      -1.454  13.170   8.688  1.00 16.06           C  
ATOM    499  CD1 LEU A  59      -1.023  11.715   8.848  1.00 15.41           C  
ATOM    500  CD2 LEU A  59      -1.102  13.683   7.294  1.00 14.73           C  
ATOM    501  N   ALA A  60      -5.802  14.400   9.734  1.00 16.62           N  
ATOM    502  CA  ALA A  60      -7.246  14.480   9.499  1.00 17.67           C  
ATOM    503  C   ALA A  60      -7.697  15.932   9.416  1.00 19.82           C  
ATOM    504  O   ALA A  60      -8.500  16.303   8.557  1.00 22.32           O  
ATOM    505  CB  ALA A  60      -8.004  13.770  10.617  1.00 18.17           C  
ATOM    506  N   GLU A  61      -7.184  16.748  10.325  1.00 20.71           N  
ATOM    507  CA  GLU A  61      -7.538  18.158  10.364  1.00 23.26           C  
ATOM    508  C   GLU A  61      -7.257  18.844   9.028  1.00 24.34           C  
ATOM    509  O   GLU A  61      -7.861  19.848   8.672  1.00 22.50           O  
ATOM    510  CB  GLU A  61      -6.720  18.827  11.475  1.00 24.75           C  
ATOM    511  CG  GLU A  61      -7.182  20.259  11.765  1.00 30.36           C  
ATOM    512  CD  GLU A  61      -6.408  20.823  12.940  1.00 31.62           C  
ATOM    513  OE1 GLU A  61      -6.515  20.276  14.032  1.00 30.53           O  
ATOM    514  OE2 GLU A  61      -5.735  21.835  12.761  1.00 33.67           O  
ATOM    515  N   ARG A  62      -6.268  18.286   8.295  1.00 21.83           N  
ATOM    516  CA  ARG A  62      -5.843  18.922   7.051  1.00 22.07           C  
ATOM    517  C   ARG A  62      -6.589  18.377   5.819  1.00 20.63           C  
ATOM    518  O   ARG A  62      -6.326  18.753   4.684  1.00 22.26           O  
ATOM    519  CB  ARG A  62      -4.333  18.713   6.894  1.00 21.87           C  
ATOM    520  CG  ARG A  62      -3.520  19.481   7.943  1.00 22.15           C  
ATOM    521  CD  ARG A  62      -2.010  19.342   7.706  1.00 22.09           C  
ATOM    522  NE  ARG A  62      -1.253  19.777   8.886  1.00 22.05           N  
ATOM    523  CZ  ARG A  62      -0.026  20.297   8.683  1.00 20.67           C  
ATOM    524  NH1 ARG A  62       0.459  20.405   7.458  1.00 20.73           N  
ATOM    525  NH2 ARG A  62       0.697  20.712   9.728  1.00 19.95           N  
ATOM    526  N   GLY A  63      -7.521  17.431   6.063  1.00 20.13           N  
ATOM    527  CA  GLY A  63      -8.415  17.003   4.981  1.00 19.66           C  
ATOM    528  C   GLY A  63      -8.139  15.571   4.502  1.00 19.81           C  
ATOM    529  O   GLY A  63      -8.831  15.015   3.661  1.00 18.31           O  
ATOM    530  N   TYR A  64      -7.125  14.909   5.038  1.00 17.86           N  
ATOM    531  CA  TYR A  64      -6.853  13.539   4.634  1.00 18.01           C  
ATOM    532  C   TYR A  64      -7.893  12.589   5.219  1.00 17.38           C  
ATOM    533  O   TYR A  64      -8.435  12.841   6.296  1.00 16.83           O  
ATOM    534  CB  TYR A  64      -5.446  13.144   5.095  1.00 17.00           C  
ATOM    535  CG  TYR A  64      -4.372  13.934   4.386  1.00 17.48           C  
ATOM    536  CD1 TYR A  64      -4.021  13.630   3.073  1.00 19.02           C  
ATOM    537  CD2 TYR A  64      -3.767  15.035   4.992  1.00 17.52           C  
ATOM    538  CE1 TYR A  64      -3.102  14.400   2.376  1.00 18.90           C  
ATOM    539  CE2 TYR A  64      -2.843  15.820   4.297  1.00 19.69           C  
ATOM    540  CZ  TYR A  64      -2.520  15.490   2.987  1.00 17.80           C  
ATOM    541  OH  TYR A  64      -1.625  16.253   2.274  1.00 20.39           O  
ATOM    542  N   GLU A  65      -8.189  11.519   4.483  1.00 17.37           N  
ATOM    543  CA  GLU A  65      -9.124  10.491   4.937  1.00 19.07           C  
ATOM    544  C   GLU A  65      -8.181   9.506   5.609  1.00 17.61           C  
ATOM    545  O   GLU A  65      -7.450   8.790   4.929  1.00 16.39           O  
ATOM    546  CB  GLU A  65      -9.810   9.813   3.749  1.00 21.71           C  
ATOM    547  CG  GLU A  65     -10.832   8.753   4.147  1.00 29.27           C  
ATOM    548  CD  GLU A  65     -11.353   7.965   2.953  1.00 32.67           C  
ATOM    549  OE1 GLU A  65     -11.583   8.575   1.893  1.00 37.96           O  
ATOM    550  OE2 GLU A  65     -11.542   6.740   3.076  1.00 35.93           O  
ATOM    551  N   VAL A  66      -8.203   9.462   6.934  1.00 17.17           N  
ATOM    552  CA  VAL A  66      -7.270   8.612   7.666  1.00 14.47           C  
ATOM    553  C   VAL A  66      -7.865   7.423   8.395  1.00 16.13           C  
ATOM    554  O   VAL A  66      -8.958   7.500   8.960  1.00 15.39           O  
ATOM    555  CB  VAL A  66      -6.493   9.466   8.697  1.00 14.18           C  
ATOM    556  CG1 VAL A  66      -5.325   8.674   9.286  1.00 14.80           C  
ATOM    557  CG2 VAL A  66      -6.008  10.745   8.031  1.00 15.26           C  
ATOM    558  N   VAL A  67      -7.135   6.313   8.349  1.00 13.14           N  
ATOM    559  CA  VAL A  67      -7.510   5.089   9.051  1.00 13.75           C  
ATOM    560  C   VAL A  67      -6.349   4.841  10.017  1.00 14.21           C  
ATOM    561  O   VAL A  67      -5.202   4.765   9.587  1.00 13.56           O  
ATOM    562  CB  VAL A  67      -7.617   3.889   8.088  1.00 15.42           C  
ATOM    563  CG1 VAL A  67      -7.845   2.600   8.878  1.00 16.80           C  
ATOM    564  CG2 VAL A  67      -8.764   4.117   7.098  1.00 14.73           C  
ATOM    565  N   GLY A  68      -6.637   4.744  11.313  1.00 15.08           N  
ATOM    566  CA  GLY A  68      -5.575   4.509  12.283  1.00 15.38           C  
ATOM    567  C   GLY A  68      -5.696   3.116  12.865  1.00 15.26           C  
ATOM    568  O   GLY A  68      -6.796   2.680  13.190  1.00 16.95           O  
ATOM    569  N   LEU A  69      -4.573   2.414  12.991  1.00 13.34           N  
ATOM    570  CA  LEU A  69      -4.575   1.059  13.531  1.00 13.66           C  
ATOM    571  C   LEU A  69      -3.612   0.943  14.708  1.00 13.86           C  
ATOM    572  O   LEU A  69      -2.479   1.412  14.640  1.00 15.03           O  
ATOM    573  CB  LEU A  69      -4.149   0.063  12.444  1.00 13.54           C  
ATOM    574  CG  LEU A  69      -3.950  -1.392  12.876  1.00 16.38           C  
ATOM    575  CD1 LEU A  69      -5.299  -2.070  13.064  1.00 17.55           C  
ATOM    576  CD2 LEU A  69      -3.145  -2.122  11.819  1.00 18.45           C  
ATOM    577  N   ASP A  70      -4.063   0.328  15.795  1.00 14.29           N  
ATOM    578  CA  ASP A  70      -3.182   0.138  16.936  1.00 15.28           C  
ATOM    579  C   ASP A  70      -3.515  -1.158  17.655  1.00 14.41           C  
ATOM    580  O   ASP A  70      -4.665  -1.603  17.683  1.00 13.92           O  
ATOM    581  CB  ASP A  70      -3.248   1.335  17.902  1.00 15.10           C  
ATOM    582  CG  ASP A  70      -2.027   1.413  18.814  1.00 14.42           C  
ATOM    583  OD1 ASP A  70      -2.009   0.720  19.849  1.00 13.56           O  
ATOM    584  OD2 ASP A  70      -1.072   2.153  18.482  1.00 13.60           O  
ATOM    585  N   LEU A  71      -2.485  -1.774  18.216  1.00 15.04           N  
ATOM    586  CA  LEU A  71      -2.637  -3.025  18.933  1.00 15.81           C  
ATOM    587  C   LEU A  71      -3.413  -2.852  20.235  1.00 17.26           C  
ATOM    588  O   LEU A  71      -4.138  -3.752  20.657  1.00 17.86           O  
ATOM    589  CB  LEU A  71      -1.251  -3.609  19.245  1.00 17.44           C  
ATOM    590  CG  LEU A  71      -1.188  -4.971  19.941  1.00 19.10           C  
ATOM    591  CD1 LEU A  71      -1.847  -6.030  19.063  1.00 21.73           C  
ATOM    592  CD2 LEU A  71       0.274  -5.336  20.202  1.00 21.11           C  
ATOM    593  N   HIS A  72      -3.273  -1.690  20.866  1.00 16.41           N  
ATOM    594  CA  HIS A  72      -3.923  -1.461  22.145  1.00 16.10           C  
ATOM    595  C   HIS A  72      -5.149  -0.559  22.166  1.00 16.90           C  
ATOM    596  O   HIS A  72      -5.089   0.621  21.817  1.00 15.36           O  
ATOM    597  CB  HIS A  72      -2.885  -0.949  23.148  1.00 16.87           C  
ATOM    598  CG  HIS A  72      -1.767  -1.915  23.391  1.00 17.52           C  
ATOM    599  ND1 HIS A  72      -0.547  -1.818  22.759  1.00 19.61           N  
ATOM    600  CD2 HIS A  72      -1.709  -3.031  24.156  1.00 16.78           C  
ATOM    601  CE1 HIS A  72       0.217  -2.835  23.123  1.00 18.93           C  
ATOM    602  NE2 HIS A  72      -0.465  -3.585  23.970  1.00 17.47           N  
ATOM    603  N   GLU A  73      -6.258  -1.139  22.608  1.00 17.21           N  
ATOM    604  CA  GLU A  73      -7.531  -0.442  22.715  1.00 18.48           C  
ATOM    605  C   GLU A  73      -7.419   0.738  23.678  1.00 17.54           C  
ATOM    606  O   GLU A  73      -8.102   1.750  23.516  1.00 15.12           O  
ATOM    607  CB  GLU A  73      -8.602  -1.418  23.212  1.00 21.91           C  
ATOM    608  CG  GLU A  73     -10.016  -0.880  23.159  1.00 27.54           C  
ATOM    609  CD  GLU A  73     -10.404  -0.435  21.763  1.00 28.58           C  
ATOM    610  OE1 GLU A  73     -10.183  -1.206  20.806  1.00 30.43           O  
ATOM    611  OE2 GLU A  73     -10.928   0.687  21.627  1.00 32.51           O  
ATOM    612  N   GLU A  74      -6.556   0.612  24.685  1.00 16.52           N  
ATOM    613  CA  GLU A  74      -6.390   1.697  25.650  1.00 16.89           C  
ATOM    614  C   GLU A  74      -5.883   2.973  24.972  1.00 17.51           C  
ATOM    615  O   GLU A  74      -6.242   4.087  25.372  1.00 15.51           O  
ATOM    616  CB  GLU A  74      -5.431   1.281  26.773  1.00 17.71           C  
ATOM    617  CG  GLU A  74      -5.929   0.103  27.611  1.00 19.79           C  
ATOM    618  CD  GLU A  74      -5.404  -1.236  27.123  1.00 22.06           C  
ATOM    619  OE1 GLU A  74      -5.228  -1.405  25.894  1.00 20.30           O  
ATOM    620  OE2 GLU A  74      -5.175  -2.126  27.970  1.00 23.34           O  
ATOM    621  N   MET A  75      -5.042   2.812  23.953  1.00 15.70           N  
ATOM    622  CA  MET A  75      -4.522   3.967  23.220  1.00 16.09           C  
ATOM    623  C   MET A  75      -5.600   4.515  22.287  1.00 15.60           C  
ATOM    624  O   MET A  75      -5.806   5.731  22.206  1.00 16.67           O  
ATOM    625  CB  MET A  75      -3.283   3.576  22.405  1.00 15.56           C  
ATOM    626  CG  MET A  75      -2.081   3.153  23.251  1.00 16.76           C  
ATOM    627  SD  MET A  75      -1.375   4.527  24.196  1.00 16.20           S  
ATOM    628  CE  MET A  75      -0.474   5.365  22.934  1.00 12.97           C  
ATOM    629  N   LEU A  76      -6.282   3.619  21.576  1.00 15.79           N  
ATOM    630  CA  LEU A  76      -7.346   4.014  20.655  1.00 16.38           C  
ATOM    631  C   LEU A  76      -8.464   4.761  21.386  1.00 17.85           C  
ATOM    632  O   LEU A  76      -9.100   5.658  20.824  1.00 16.27           O  
ATOM    633  CB  LEU A  76      -7.931   2.781  19.954  1.00 16.84           C  
ATOM    634  CG  LEU A  76      -6.986   1.950  19.077  1.00 15.37           C  
ATOM    635  CD1 LEU A  76      -7.719   0.742  18.518  1.00 16.62           C  
ATOM    636  CD2 LEU A  76      -6.444   2.817  17.949  1.00 15.77           C  
ATOM    637  N   ARG A  77      -8.705   4.387  22.640  1.00 18.89           N  
ATOM    638  CA  ARG A  77      -9.745   5.040  23.424  1.00 19.49           C  
ATOM    639  C   ARG A  77      -9.467   6.537  23.488  1.00 18.74           C  
ATOM    640  O   ARG A  77     -10.378   7.356  23.339  1.00 16.06           O  
ATOM    641  CB  ARG A  77      -9.792   4.452  24.837  1.00 21.84           C  
ATOM    642  CG  ARG A  77     -10.869   5.061  25.715  1.00 24.78           C  
ATOM    643  CD  ARG A  77     -10.921   4.398  27.084  1.00 26.53           C  
ATOM    644  NE  ARG A  77     -11.974   4.986  27.909  1.00 31.94           N  
ATOM    645  CZ  ARG A  77     -12.285   4.576  29.136  1.00 34.41           C  
ATOM    646  NH1 ARG A  77     -11.622   3.567  29.690  1.00 33.75           N  
ATOM    647  NH2 ARG A  77     -13.259   5.175  29.808  1.00 34.08           N  
ATOM    648  N   VAL A  78      -8.200   6.886  23.712  1.00 16.73           N  
ATOM    649  CA  VAL A  78      -7.776   8.279  23.787  1.00 16.89           C  
ATOM    650  C   VAL A  78      -7.900   8.948  22.425  1.00 15.52           C  
ATOM    651  O   VAL A  78      -8.391  10.068  22.313  1.00 15.22           O  
ATOM    652  CB  VAL A  78      -6.297   8.390  24.263  1.00 16.58           C  
ATOM    653  CG1 VAL A  78      -5.865   9.860  24.311  1.00 16.27           C  
ATOM    654  CG2 VAL A  78      -6.144   7.736  25.629  1.00 17.25           C  
ATOM    655  N   ALA A  79      -7.441   8.261  21.385  1.00 15.38           N  
ATOM    656  CA  ALA A  79      -7.517   8.807  20.034  1.00 15.75           C  
ATOM    657  C   ALA A  79      -8.963   9.135  19.634  1.00 17.16           C  
ATOM    658  O   ALA A  79      -9.242  10.216  19.106  1.00 14.77           O  
ATOM    659  CB  ALA A  79      -6.906   7.819  19.039  1.00 14.64           C  
ATOM    660  N   ARG A  80      -9.879   8.207  19.888  1.00 17.28           N  
ATOM    661  CA  ARG A  80     -11.280   8.425  19.529  1.00 18.33           C  
ATOM    662  C   ARG A  80     -11.896   9.584  20.301  1.00 17.61           C  
ATOM    663  O   ARG A  80     -12.701  10.347  19.758  1.00 17.74           O  
ATOM    664  CB  ARG A  80     -12.105   7.155  19.769  1.00 20.21           C  
ATOM    665  CG  ARG A  80     -11.734   5.987  18.865  1.00 22.94           C  
ATOM    666  CD  ARG A  80     -12.788   4.899  18.939  1.00 25.93           C  
ATOM    667  NE  ARG A  80     -12.432   3.713  18.166  1.00 26.77           N  
ATOM    668  CZ  ARG A  80     -11.902   2.609  18.682  1.00 24.39           C  
ATOM    669  NH1 ARG A  80     -11.657   2.531  19.981  1.00 25.29           N  
ATOM    670  NH2 ARG A  80     -11.634   1.574  17.898  1.00 24.73           N  
ATOM    671  N   ARG A  81     -11.519   9.711  21.569  1.00 17.82           N  
ATOM    672  CA  ARG A  81     -12.033  10.783  22.414  1.00 17.80           C  
ATOM    673  C   ARG A  81     -11.629  12.135  21.834  1.00 19.16           C  
ATOM    674  O   ARG A  81     -12.456  13.043  21.705  1.00 16.85           O  
ATOM    675  CB  ARG A  81     -11.480  10.639  23.835  1.00 19.34           C  
ATOM    676  CG  ARG A  81     -11.960  11.703  24.819  1.00 20.46           C  
ATOM    677  CD  ARG A  81     -11.213  11.598  26.144  1.00 18.78           C  
ATOM    678  NE  ARG A  81     -11.294  10.254  26.705  1.00 21.35           N  
ATOM    679  CZ  ARG A  81     -10.243   9.568  27.150  1.00 22.06           C  
ATOM    680  NH1 ARG A  81      -9.030  10.105  27.098  1.00 22.64           N  
ATOM    681  NH2 ARG A  81     -10.402   8.347  27.637  1.00 21.04           N  
ATOM    682  N   LYS A  82     -10.351  12.267  21.481  1.00 17.58           N  
ATOM    683  CA  LYS A  82      -9.851  13.511  20.918  1.00 17.64           C  
ATOM    684  C   LYS A  82     -10.452  13.799  19.547  1.00 17.63           C  
ATOM    685  O   LYS A  82     -10.768  14.949  19.237  1.00 17.93           O  
ATOM    686  CB  LYS A  82      -8.319  13.482  20.827  1.00 17.44           C  
ATOM    687  CG  LYS A  82      -7.638  13.451  22.191  1.00 20.50           C  
ATOM    688  CD  LYS A  82      -6.117  13.611  22.087  1.00 22.30           C  
ATOM    689  CE  LYS A  82      -5.490  12.488  21.285  1.00 22.69           C  
ATOM    690  NZ  LYS A  82      -3.998  12.610  21.194  1.00 18.16           N  
ATOM    691  N   ALA A  83     -10.613  12.763  18.727  1.00 16.29           N  
ATOM    692  CA  ALA A  83     -11.191  12.946  17.396  1.00 17.68           C  
ATOM    693  C   ALA A  83     -12.626  13.464  17.525  1.00 18.76           C  
ATOM    694  O   ALA A  83     -13.033  14.393  16.827  1.00 19.06           O  
ATOM    695  CB  ALA A  83     -11.172  11.621  16.625  1.00 15.46           C  
ATOM    696  N   LYS A  84     -13.387  12.854  18.426  1.00 20.59           N  
ATOM    697  CA  LYS A  84     -14.770  13.263  18.653  1.00 23.22           C  
ATOM    698  C   LYS A  84     -14.824  14.721  19.125  1.00 23.11           C  
ATOM    699  O   LYS A  84     -15.608  15.517  18.606  1.00 23.58           O  
ATOM    700  CB  LYS A  84     -15.415  12.343  19.691  1.00 23.12           C  
ATOM    701  CG  LYS A  84     -16.896  12.596  19.926  1.00 27.74           C  
ATOM    702  CD  LYS A  84     -17.444  11.634  20.971  1.00 29.39           C  
ATOM    703  CE  LYS A  84     -18.930  11.863  21.220  1.00 34.16           C  
ATOM    704  NZ  LYS A  84     -19.491  10.838  22.152  1.00 37.22           N  
ATOM    705  N   GLU A  85     -13.978  15.075  20.091  1.00 23.44           N  
ATOM    706  CA  GLU A  85     -13.944  16.442  20.618  1.00 24.98           C  
ATOM    707  C   GLU A  85     -13.607  17.470  19.545  1.00 24.89           C  
ATOM    708  O   GLU A  85     -14.076  18.610  19.595  1.00 23.87           O  
ATOM    709  CB  GLU A  85     -12.904  16.576  21.738  1.00 28.66           C  
ATOM    710  CG  GLU A  85     -13.068  15.609  22.895  1.00 34.72           C  
ATOM    711  CD  GLU A  85     -11.938  15.706  23.913  1.00 36.87           C  
ATOM    712  OE1 GLU A  85     -10.767  15.895  23.505  1.00 36.41           O  
ATOM    713  OE2 GLU A  85     -12.220  15.577  25.125  1.00 38.52           O  
ATOM    714  N   ARG A  86     -12.785  17.072  18.578  1.00 20.69           N  
ATOM    715  CA  ARG A  86     -12.372  17.984  17.521  1.00 19.63           C  
ATOM    716  C   ARG A  86     -13.195  17.850  16.242  1.00 19.26           C  
ATOM    717  O   ARG A  86     -12.907  18.504  15.244  1.00 19.23           O  
ATOM    718  CB  ARG A  86     -10.876  17.786  17.244  1.00 20.68           C  
ATOM    719  CG  ARG A  86     -10.011  18.138  18.460  1.00 19.69           C  
ATOM    720  CD  ARG A  86      -8.578  17.593  18.362  1.00 22.03           C  
ATOM    721  NE  ARG A  86      -7.867  18.048  17.171  1.00 20.18           N  
ATOM    722  CZ  ARG A  86      -6.584  17.789  16.923  1.00 19.99           C  
ATOM    723  NH1 ARG A  86      -5.866  17.079  17.788  1.00 17.15           N  
ATOM    724  NH2 ARG A  86      -6.021  18.227  15.808  1.00 19.66           N  
ATOM    725  N   ASN A  87     -14.236  17.021  16.293  1.00 19.57           N  
ATOM    726  CA  ASN A  87     -15.120  16.804  15.147  1.00 20.61           C  
ATOM    727  C   ASN A  87     -14.378  16.266  13.926  1.00 21.54           C  
ATOM    728  O   ASN A  87     -14.706  16.602  12.784  1.00 20.30           O  
ATOM    729  CB  ASN A  87     -15.834  18.104  14.765  1.00 20.76           C  
ATOM    730  CG  ASN A  87     -16.660  18.669  15.903  1.00 22.61           C  
ATOM    731  OD1 ASN A  87     -17.497  17.978  16.481  1.00 25.35           O  
ATOM    732  ND2 ASN A  87     -16.430  19.934  16.227  1.00 22.98           N  
ATOM    733  N   LEU A  88     -13.380  15.429  14.172  1.00 20.40           N  
ATOM    734  CA  LEU A  88     -12.605  14.846  13.091  1.00 19.64           C  
ATOM    735  C   LEU A  88     -13.106  13.430  12.871  1.00 20.77           C  
ATOM    736  O   LEU A  88     -13.333  12.685  13.824  1.00 20.07           O  
ATOM    737  CB  LEU A  88     -11.115  14.853  13.447  1.00 18.93           C  
ATOM    738  CG  LEU A  88     -10.535  16.269  13.563  1.00 19.90           C  
ATOM    739  CD1 LEU A  88      -9.106  16.225  14.104  1.00 18.43           C  
ATOM    740  CD2 LEU A  88     -10.579  16.942  12.192  1.00 20.67           C  
ATOM    741  N   LYS A  89     -13.305  13.077  11.608  1.00 20.54           N  
ATOM    742  CA  LYS A  89     -13.795  11.756  11.256  1.00 22.06           C  
ATOM    743  C   LYS A  89     -12.623  10.863  10.862  1.00 20.81           C  
ATOM    744  O   LYS A  89     -12.030  11.030   9.795  1.00 19.91           O  
ATOM    745  CB  LYS A  89     -14.800  11.866  10.106  1.00 24.79           C  
ATOM    746  CG  LYS A  89     -16.035  12.692  10.450  1.00 30.35           C  
ATOM    747  CD  LYS A  89     -17.080  12.644   9.338  1.00 34.84           C  
ATOM    748  CE  LYS A  89     -18.339  13.407   9.741  1.00 38.44           C  
ATOM    749  NZ  LYS A  89     -19.395  13.361   8.690  1.00 41.06           N  
ATOM    750  N   ILE A  90     -12.288   9.932  11.746  1.00 18.87           N  
ATOM    751  CA  ILE A  90     -11.182   9.007  11.516  1.00 18.19           C  
ATOM    752  C   ILE A  90     -11.643   7.609  11.883  1.00 17.53           C  
ATOM    753  O   ILE A  90     -12.343   7.422  12.875  1.00 18.20           O  
ATOM    754  CB  ILE A  90      -9.957   9.348  12.410  1.00 18.79           C  
ATOM    755  CG1 ILE A  90      -9.441  10.752  12.079  1.00 19.18           C  
ATOM    756  CG2 ILE A  90      -8.860   8.297  12.219  1.00 16.72           C  
ATOM    757  CD1 ILE A  90      -8.414  11.295  13.075  1.00 17.22           C  
ATOM    758  N   GLU A  91     -11.265   6.630  11.076  1.00 15.59           N  
ATOM    759  CA  GLU A  91     -11.626   5.255  11.363  1.00 17.53           C  
ATOM    760  C   GLU A  91     -10.479   4.636  12.168  1.00 18.11           C  
ATOM    761  O   GLU A  91      -9.389   4.411  11.635  1.00 17.20           O  
ATOM    762  CB  GLU A  91     -11.844   4.473  10.059  1.00 19.05           C  
ATOM    763  CG  GLU A  91     -11.986   2.966  10.255  1.00 23.43           C  
ATOM    764  CD  GLU A  91     -12.322   2.228   8.971  1.00 26.96           C  
ATOM    765  OE1 GLU A  91     -11.877   2.666   7.886  1.00 28.68           O  
ATOM    766  OE2 GLU A  91     -13.022   1.197   9.050  1.00 28.61           O  
ATOM    767  N   PHE A  92     -10.718   4.391  13.452  1.00 17.81           N  
ATOM    768  CA  PHE A  92      -9.707   3.783  14.313  1.00 17.60           C  
ATOM    769  C   PHE A  92     -10.005   2.290  14.453  1.00 19.17           C  
ATOM    770  O   PHE A  92     -11.133   1.895  14.762  1.00 18.89           O  
ATOM    771  CB  PHE A  92      -9.696   4.469  15.684  1.00 17.34           C  
ATOM    772  CG  PHE A  92      -9.010   5.809  15.681  1.00 17.65           C  
ATOM    773  CD1 PHE A  92      -7.630   5.896  15.490  1.00 17.91           C  
ATOM    774  CD2 PHE A  92      -9.737   6.984  15.846  1.00 17.79           C  
ATOM    775  CE1 PHE A  92      -6.982   7.141  15.466  1.00 18.19           C  
ATOM    776  CE2 PHE A  92      -9.105   8.226  15.824  1.00 17.18           C  
ATOM    777  CZ  PHE A  92      -7.724   8.308  15.635  1.00 16.52           C  
ATOM    778  N   LEU A  93      -8.984   1.470  14.218  1.00 17.27           N  
ATOM    779  CA  LEU A  93      -9.113   0.016  14.275  1.00 17.42           C  
ATOM    780  C   LEU A  93      -8.081  -0.609  15.202  1.00 18.39           C  
ATOM    781  O   LEU A  93      -6.948  -0.139  15.282  1.00 16.69           O  
ATOM    782  CB  LEU A  93      -8.893  -0.577  12.881  1.00 17.18           C  
ATOM    783  CG  LEU A  93      -9.692   0.001  11.713  1.00 18.72           C  
ATOM    784  CD1 LEU A  93      -9.115  -0.496  10.390  1.00 19.72           C  
ATOM    785  CD2 LEU A  93     -11.141  -0.401  11.859  1.00 22.60           C  
ATOM    786  N   GLN A  94      -8.471  -1.688  15.873  1.00 17.33           N  
ATOM    787  CA  GLN A  94      -7.549  -2.400  16.750  1.00 18.82           C  
ATOM    788  C   GLN A  94      -7.008  -3.576  15.960  1.00 19.28           C  
ATOM    789  O   GLN A  94      -7.747  -4.226  15.214  1.00 16.95           O  
ATOM    790  CB  GLN A  94      -8.264  -2.911  18.003  1.00 20.07           C  
ATOM    791  CG  GLN A  94      -7.344  -3.599  19.034  1.00 21.38           C  
ATOM    792  CD  GLN A  94      -6.881  -4.985  18.604  1.00 25.30           C  
ATOM    793  OE1 GLN A  94      -7.664  -5.772  18.066  1.00 24.22           O  
ATOM    794  NE2 GLN A  94      -5.608  -5.298  18.858  1.00 24.80           N  
ATOM    795  N   GLY A  95      -5.718  -3.843  16.112  1.00 17.21           N  
ATOM    796  CA  GLY A  95      -5.113  -4.951  15.402  1.00 17.77           C  
ATOM    797  C   GLY A  95      -3.604  -4.833  15.376  1.00 18.40           C  
ATOM    798  O   GLY A  95      -3.043  -3.786  15.707  1.00 17.70           O  
ATOM    799  N   ASP A  96      -2.957  -5.920  14.976  1.00 18.04           N  
ATOM    800  CA  ASP A  96      -1.504  -5.996  14.877  1.00 17.80           C  
ATOM    801  C   ASP A  96      -1.117  -5.530  13.471  1.00 18.00           C  
ATOM    802  O   ASP A  96      -1.701  -5.991  12.480  1.00 17.06           O  
ATOM    803  CB  ASP A  96      -1.079  -7.455  15.077  1.00 19.68           C  
ATOM    804  CG  ASP A  96       0.422  -7.628  15.222  1.00 22.59           C  
ATOM    805  OD1 ASP A  96       1.191  -6.827  14.656  1.00 19.88           O  
ATOM    806  OD2 ASP A  96       0.829  -8.597  15.894  1.00 27.87           O  
ATOM    807  N   VAL A  97      -0.150  -4.621  13.374  1.00 15.91           N  
ATOM    808  CA  VAL A  97       0.287  -4.132  12.069  1.00 16.48           C  
ATOM    809  C   VAL A  97       0.850  -5.258  11.202  1.00 18.56           C  
ATOM    810  O   VAL A  97       0.811  -5.174   9.973  1.00 18.66           O  
ATOM    811  CB  VAL A  97       1.383  -3.029  12.178  1.00 16.01           C  
ATOM    812  CG1 VAL A  97       0.828  -1.799  12.883  1.00 16.95           C  
ATOM    813  CG2 VAL A  97       2.610  -3.564  12.904  1.00 14.58           C  
ATOM    814  N   LEU A  98       1.371  -6.307  11.835  1.00 17.78           N  
ATOM    815  CA  LEU A  98       1.940  -7.424  11.082  1.00 19.97           C  
ATOM    816  C   LEU A  98       0.871  -8.312  10.464  1.00 20.42           C  
ATOM    817  O   LEU A  98       1.180  -9.232   9.705  1.00 22.97           O  
ATOM    818  CB  LEU A  98       2.844  -8.268  11.982  1.00 18.44           C  
ATOM    819  CG  LEU A  98       4.040  -7.535  12.594  1.00 18.39           C  
ATOM    820  CD1 LEU A  98       4.824  -8.491  13.481  1.00 18.92           C  
ATOM    821  CD2 LEU A  98       4.932  -6.978  11.491  1.00 18.75           C  
ATOM    822  N   GLU A  99      -0.385  -8.036  10.786  1.00 21.22           N  
ATOM    823  CA  GLU A  99      -1.486  -8.833  10.270  1.00 22.13           C  
ATOM    824  C   GLU A  99      -2.440  -8.064   9.366  1.00 22.01           C  
ATOM    825  O   GLU A  99      -3.531  -8.549   9.068  1.00 21.16           O  
ATOM    826  CB  GLU A  99      -2.270  -9.442  11.435  1.00 25.05           C  
ATOM    827  CG  GLU A  99      -1.523 -10.535  12.187  1.00 29.81           C  
ATOM    828  CD  GLU A  99      -2.180 -10.890  13.512  1.00 35.24           C  
ATOM    829  OE1 GLU A  99      -3.414 -10.735  13.630  1.00 36.54           O  
ATOM    830  OE2 GLU A  99      -1.462 -11.337  14.433  1.00 38.38           O  
ATOM    831  N   ILE A 100      -2.052  -6.868   8.932  1.00 20.67           N  
ATOM    832  CA  ILE A 100      -2.943  -6.114   8.062  1.00 18.81           C  
ATOM    833  C   ILE A 100      -3.110  -6.873   6.753  1.00 20.69           C  
ATOM    834  O   ILE A 100      -2.223  -7.629   6.347  1.00 18.73           O  
ATOM    835  CB  ILE A 100      -2.419  -4.688   7.761  1.00 18.47           C  
ATOM    836  CG1 ILE A 100      -1.056  -4.750   7.061  1.00 18.46           C  
ATOM    837  CG2 ILE A 100      -2.350  -3.879   9.055  1.00 18.43           C  
ATOM    838  CD1 ILE A 100      -0.535  -3.383   6.628  1.00 16.70           C  
ATOM    839  N   ALA A 101      -4.248  -6.675   6.097  1.00 19.23           N  
ATOM    840  CA  ALA A 101      -4.517  -7.364   4.840  1.00 21.79           C  
ATOM    841  C   ALA A 101      -5.090  -6.431   3.779  1.00 21.95           C  
ATOM    842  O   ALA A 101      -5.786  -6.871   2.860  1.00 24.20           O  
ATOM    843  CB  ALA A 101      -5.471  -8.530   5.085  1.00 22.65           C  
ATOM    844  N   PHE A 102      -4.793  -5.143   3.905  1.00 20.45           N  
ATOM    845  CA  PHE A 102      -5.277  -4.163   2.944  1.00 20.41           C  
ATOM    846  C   PHE A 102      -4.606  -4.429   1.607  1.00 21.37           C  
ATOM    847  O   PHE A 102      -3.427  -4.783   1.553  1.00 20.16           O  
ATOM    848  CB  PHE A 102      -4.955  -2.754   3.433  1.00 20.85           C  
ATOM    849  CG  PHE A 102      -5.580  -2.429   4.755  1.00 21.03           C  
ATOM    850  CD1 PHE A 102      -6.964  -2.312   4.872  1.00 21.69           C  
ATOM    851  CD2 PHE A 102      -4.794  -2.263   5.886  1.00 20.02           C  
ATOM    852  CE1 PHE A 102      -7.555  -2.033   6.102  1.00 22.79           C  
ATOM    853  CE2 PHE A 102      -5.369  -1.987   7.118  1.00 21.28           C  
ATOM    854  CZ  PHE A 102      -6.757  -1.870   7.229  1.00 23.45           C  
ATOM    855  N   LYS A 103      -5.353  -4.252   0.524  1.00 19.68           N  
ATOM    856  CA  LYS A 103      -4.804  -4.508  -0.797  1.00 21.22           C  
ATOM    857  C   LYS A 103      -4.880  -3.306  -1.723  1.00 22.18           C  
ATOM    858  O   LYS A 103      -5.960  -2.956  -2.216  1.00 19.55           O  
ATOM    859  CB  LYS A 103      -5.531  -5.693  -1.443  1.00 25.02           C  
ATOM    860  CG  LYS A 103      -5.545  -6.945  -0.584  1.00 28.90           C  
ATOM    861  CD  LYS A 103      -4.142  -7.509  -0.398  1.00 31.88           C  
ATOM    862  CE  LYS A 103      -4.128  -8.587   0.679  1.00 35.31           C  
ATOM    863  NZ  LYS A 103      -5.234  -9.571   0.485  1.00 38.67           N  
ATOM    864  N   ASN A 104      -3.726  -2.684  -1.946  1.00 18.35           N  
ATOM    865  CA  ASN A 104      -3.608  -1.536  -2.836  1.00 19.95           C  
ATOM    866  C   ASN A 104      -4.776  -0.566  -2.682  1.00 20.98           C  
ATOM    867  O   ASN A 104      -5.470  -0.247  -3.651  1.00 19.25           O  
ATOM    868  CB  ASN A 104      -3.510  -2.052  -4.274  1.00 22.46           C  
ATOM    869  CG  ASN A 104      -2.629  -3.294  -4.377  1.00 25.82           C  
ATOM    870  OD1 ASN A 104      -3.120  -4.429  -4.417  1.00 24.91           O  
ATOM    871  ND2 ASN A 104      -1.312  -3.083  -4.385  1.00 26.91           N  
ATOM    872  N   GLU A 105      -4.984  -0.079  -1.462  1.00 21.01           N  
ATOM    873  CA  GLU A 105      -6.096   0.829  -1.232  1.00 21.68           C  
ATOM    874  C   GLU A 105      -5.771   2.123  -0.494  1.00 20.21           C  
ATOM    875  O   GLU A 105      -6.670   2.902  -0.188  1.00 16.97           O  
ATOM    876  CB  GLU A 105      -7.222   0.079  -0.521  1.00 26.50           C  
ATOM    877  CG  GLU A 105      -6.883  -0.423   0.867  1.00 26.13           C  
ATOM    878  CD  GLU A 105      -7.992  -1.296   1.428  1.00 31.28           C  
ATOM    879  OE1 GLU A 105      -8.009  -2.517   1.136  1.00 33.97           O  
ATOM    880  OE2 GLU A 105      -8.859  -0.756   2.144  1.00 30.62           O  
ATOM    881  N   PHE A 106      -4.492   2.358  -0.212  1.00 16.73           N  
ATOM    882  CA  PHE A 106      -4.082   3.586   0.466  1.00 16.55           C  
ATOM    883  C   PHE A 106      -3.075   4.346  -0.382  1.00 15.93           C  
ATOM    884  O   PHE A 106      -2.211   3.740  -1.025  1.00 16.42           O  
ATOM    885  CB  PHE A 106      -3.475   3.263   1.835  1.00 15.81           C  
ATOM    886  CG  PHE A 106      -4.488   2.852   2.856  1.00 15.69           C  
ATOM    887  CD1 PHE A 106      -5.315   3.801   3.456  1.00 15.88           C  
ATOM    888  CD2 PHE A 106      -4.649   1.515   3.194  1.00 14.27           C  
ATOM    889  CE1 PHE A 106      -6.290   3.421   4.375  1.00 14.88           C  
ATOM    890  CE2 PHE A 106      -5.624   1.122   4.115  1.00 14.29           C  
ATOM    891  CZ  PHE A 106      -6.446   2.081   4.706  1.00 14.87           C  
ATOM    892  N   ASP A 107      -3.200   5.670  -0.402  1.00 14.63           N  
ATOM    893  CA  ASP A 107      -2.278   6.506  -1.164  1.00 14.03           C  
ATOM    894  C   ASP A 107      -0.969   6.628  -0.404  1.00 15.25           C  
ATOM    895  O   ASP A 107       0.088   6.857  -0.992  1.00 14.40           O  
ATOM    896  CB  ASP A 107      -2.855   7.904  -1.376  1.00 15.78           C  
ATOM    897  CG  ASP A 107      -4.171   7.882  -2.119  1.00 15.20           C  
ATOM    898  OD1 ASP A 107      -4.244   7.204  -3.163  1.00 15.23           O  
ATOM    899  OD2 ASP A 107      -5.116   8.548  -1.660  1.00 15.82           O  
ATOM    900  N   ALA A 108      -1.052   6.497   0.915  1.00 14.41           N  
ATOM    901  CA  ALA A 108       0.134   6.573   1.759  1.00 16.35           C  
ATOM    902  C   ALA A 108      -0.081   5.774   3.032  1.00 15.97           C  
ATOM    903  O   ALA A 108      -1.211   5.603   3.495  1.00 14.60           O  
ATOM    904  CB  ALA A 108       0.451   8.025   2.104  1.00 14.83           C  
ATOM    905  N   VAL A 109       1.018   5.279   3.585  1.00 15.60           N  
ATOM    906  CA  VAL A 109       0.980   4.522   4.825  1.00 13.84           C  
ATOM    907  C   VAL A 109       2.051   5.164   5.691  1.00 15.57           C  
ATOM    908  O   VAL A 109       3.157   5.423   5.215  1.00 15.08           O  
ATOM    909  CB  VAL A 109       1.344   3.041   4.604  1.00 14.45           C  
ATOM    910  CG1 VAL A 109       1.386   2.310   5.946  1.00 12.37           C  
ATOM    911  CG2 VAL A 109       0.317   2.378   3.676  1.00 15.48           C  
ATOM    912  N   THR A 110       1.718   5.437   6.947  1.00 15.03           N  
ATOM    913  CA  THR A 110       2.669   6.057   7.858  1.00 15.72           C  
ATOM    914  C   THR A 110       2.825   5.260   9.147  1.00 14.80           C  
ATOM    915  O   THR A 110       1.947   4.494   9.541  1.00 13.42           O  
ATOM    916  CB  THR A 110       2.225   7.494   8.253  1.00 13.92           C  
ATOM    917  OG1 THR A 110       0.920   7.443   8.850  1.00 16.13           O  
ATOM    918  CG2 THR A 110       2.177   8.407   7.035  1.00 15.53           C  
ATOM    919  N   MET A 111       3.974   5.435   9.787  1.00 16.62           N  
ATOM    920  CA  MET A 111       4.254   4.808  11.070  1.00 15.96           C  
ATOM    921  C   MET A 111       5.123   5.843  11.742  1.00 15.75           C  
ATOM    922  O   MET A 111       6.305   5.972  11.422  1.00 17.02           O  
ATOM    923  CB  MET A 111       5.010   3.493  10.924  1.00 16.74           C  
ATOM    924  CG  MET A 111       5.335   2.881  12.281  1.00 17.33           C  
ATOM    925  SD  MET A 111       5.874   1.170  12.191  1.00 20.07           S  
ATOM    926  CE  MET A 111       4.293   0.358  12.167  1.00 17.13           C  
ATOM    927  N   PHE A 112       4.525   6.579  12.671  1.00 14.42           N  
ATOM    928  CA  PHE A 112       5.208   7.669  13.352  1.00 15.24           C  
ATOM    929  C   PHE A 112       5.785   7.394  14.728  1.00 15.83           C  
ATOM    930  O   PHE A 112       5.248   6.609  15.514  1.00 16.10           O  
ATOM    931  CB  PHE A 112       4.261   8.871  13.478  1.00 17.00           C  
ATOM    932  CG  PHE A 112       3.866   9.490  12.164  1.00 17.88           C  
ATOM    933  CD1 PHE A 112       4.789  10.217  11.414  1.00 18.93           C  
ATOM    934  CD2 PHE A 112       2.568   9.358  11.684  1.00 16.03           C  
ATOM    935  CE1 PHE A 112       4.421  10.807  10.202  1.00 20.82           C  
ATOM    936  CE2 PHE A 112       2.190   9.942  10.476  1.00 16.14           C  
ATOM    937  CZ  PHE A 112       3.115  10.668   9.733  1.00 17.15           C  
ATOM    938  N   PHE A 113       6.894   8.073  14.994  1.00 16.29           N  
ATOM    939  CA  PHE A 113       7.579   8.036  16.277  1.00 16.49           C  
ATOM    940  C   PHE A 113       8.336   6.780  16.699  1.00 18.29           C  
ATOM    941  O   PHE A 113       8.033   6.163  17.727  1.00 16.68           O  
ATOM    942  CB  PHE A 113       6.599   8.466  17.382  1.00 17.30           C  
ATOM    943  CG  PHE A 113       7.273   8.971  18.639  1.00 20.40           C  
ATOM    944  CD1 PHE A 113       8.394   9.796  18.564  1.00 22.33           C  
ATOM    945  CD2 PHE A 113       6.782   8.629  19.894  1.00 23.67           C  
ATOM    946  CE1 PHE A 113       9.016  10.271  19.724  1.00 23.86           C  
ATOM    947  CE2 PHE A 113       7.397   9.100  21.061  1.00 26.70           C  
ATOM    948  CZ  PHE A 113       8.517   9.921  20.971  1.00 24.68           C  
ATOM    949  N   SER A 114       9.319   6.407  15.884  1.00 19.10           N  
ATOM    950  CA  SER A 114      10.213   5.288  16.180  1.00 19.22           C  
ATOM    951  C   SER A 114       9.638   3.902  16.367  1.00 19.49           C  
ATOM    952  O   SER A 114      10.327   3.024  16.886  1.00 18.78           O  
ATOM    953  CB  SER A 114      11.022   5.630  17.432  1.00 21.26           C  
ATOM    954  OG  SER A 114      11.435   6.983  17.394  1.00 25.18           O  
ATOM    955  N   THR A 115       8.404   3.673  15.940  1.00 18.16           N  
ATOM    956  CA  THR A 115       7.814   2.361  16.141  1.00 18.82           C  
ATOM    957  C   THR A 115       8.460   1.186  15.413  1.00 17.67           C  
ATOM    958  O   THR A 115       8.267   0.042  15.818  1.00 19.43           O  
ATOM    959  CB  THR A 115       6.300   2.402  15.853  1.00 20.61           C  
ATOM    960  OG1 THR A 115       5.699   3.360  16.730  1.00 21.27           O  
ATOM    961  CG2 THR A 115       5.653   1.038  16.107  1.00 20.93           C  
ATOM    962  N   ILE A 116       9.244   1.424  14.363  1.00 18.60           N  
ATOM    963  CA  ILE A 116       9.866   0.271  13.711  1.00 19.03           C  
ATOM    964  C   ILE A 116      10.800  -0.446  14.674  1.00 18.88           C  
ATOM    965  O   ILE A 116      11.118  -1.619  14.474  1.00 18.64           O  
ATOM    966  CB  ILE A 116      10.689   0.633  12.441  1.00 19.44           C  
ATOM    967  CG1 ILE A 116      11.787   1.636  12.782  1.00 20.46           C  
ATOM    968  CG2 ILE A 116       9.765   1.138  11.346  1.00 19.40           C  
ATOM    969  CD1 ILE A 116      12.749   1.877  11.631  1.00 23.92           C  
ATOM    970  N   MET A 117      11.224   0.249  15.728  1.00 18.89           N  
ATOM    971  CA  MET A 117      12.136  -0.344  16.706  1.00 19.56           C  
ATOM    972  C   MET A 117      11.527  -1.497  17.497  1.00 19.73           C  
ATOM    973  O   MET A 117      12.250  -2.277  18.114  1.00 18.56           O  
ATOM    974  CB  MET A 117      12.657   0.731  17.666  1.00 21.13           C  
ATOM    975  CG  MET A 117      13.590   1.733  16.999  1.00 24.08           C  
ATOM    976  SD  MET A 117      14.255   2.976  18.129  1.00 28.74           S  
ATOM    977  CE  MET A 117      15.454   2.003  19.050  1.00 29.73           C  
ATOM    978  N   TYR A 118      10.201  -1.614  17.484  1.00 18.54           N  
ATOM    979  CA  TYR A 118       9.551  -2.705  18.201  1.00 18.97           C  
ATOM    980  C   TYR A 118       9.674  -4.019  17.438  1.00 20.43           C  
ATOM    981  O   TYR A 118       9.390  -5.082  17.984  1.00 20.31           O  
ATOM    982  CB  TYR A 118       8.063  -2.396  18.433  1.00 19.52           C  
ATOM    983  CG  TYR A 118       7.803  -1.564  19.662  1.00 21.94           C  
ATOM    984  CD1 TYR A 118       7.740  -2.151  20.927  1.00 24.34           C  
ATOM    985  CD2 TYR A 118       7.698  -0.179  19.575  1.00 23.53           C  
ATOM    986  CE1 TYR A 118       7.586  -1.372  22.075  1.00 23.76           C  
ATOM    987  CE2 TYR A 118       7.549   0.606  20.715  1.00 25.19           C  
ATOM    988  CZ  TYR A 118       7.498   0.003  21.959  1.00 26.00           C  
ATOM    989  OH  TYR A 118       7.385   0.785  23.087  1.00 28.87           O  
ATOM    990  N   PHE A 119      10.127  -3.948  16.189  1.00 19.12           N  
ATOM    991  CA  PHE A 119      10.224  -5.140  15.348  1.00 20.51           C  
ATOM    992  C   PHE A 119      11.637  -5.584  15.006  1.00 21.18           C  
ATOM    993  O   PHE A 119      12.475  -4.755  14.650  1.00 20.68           O  
ATOM    994  CB  PHE A 119       9.454  -4.882  14.050  1.00 19.86           C  
ATOM    995  CG  PHE A 119       8.058  -4.393  14.276  1.00 20.38           C  
ATOM    996  CD1 PHE A 119       7.070  -5.262  14.710  1.00 20.34           C  
ATOM    997  CD2 PHE A 119       7.742  -3.046  14.107  1.00 20.76           C  
ATOM    998  CE1 PHE A 119       5.778  -4.799  14.976  1.00 23.16           C  
ATOM    999  CE2 PHE A 119       6.456  -2.574  14.371  1.00 20.44           C  
ATOM   1000  CZ  PHE A 119       5.475  -3.451  14.806  1.00 20.93           C  
ATOM   1001  N   ASP A 120      11.902  -6.889  15.109  1.00 21.35           N  
ATOM   1002  CA  ASP A 120      13.228  -7.396  14.759  1.00 22.13           C  
ATOM   1003  C   ASP A 120      13.310  -7.481  13.238  1.00 23.54           C  
ATOM   1004  O   ASP A 120      12.339  -7.160  12.550  1.00 20.96           O  
ATOM   1005  CB  ASP A 120      13.529  -8.769  15.406  1.00 22.38           C  
ATOM   1006  CG  ASP A 120      12.500  -9.849  15.068  1.00 25.67           C  
ATOM   1007  OD1 ASP A 120      11.847  -9.802  14.001  1.00 21.62           O  
ATOM   1008  OD2 ASP A 120      12.369 -10.783  15.888  1.00 28.47           O  
ATOM   1009  N   GLU A 121      14.453  -7.910  12.712  1.00 23.09           N  
ATOM   1010  CA  GLU A 121      14.632  -7.969  11.263  1.00 24.56           C  
ATOM   1011  C   GLU A 121      13.538  -8.717  10.504  1.00 23.45           C  
ATOM   1012  O   GLU A 121      13.004  -8.204   9.520  1.00 23.10           O  
ATOM   1013  CB  GLU A 121      15.993  -8.581  10.913  1.00 27.69           C  
ATOM   1014  CG  GLU A 121      16.367  -8.397   9.452  1.00 28.52           C  
ATOM   1015  CD  GLU A 121      17.708  -9.014   9.096  1.00 32.36           C  
ATOM   1016  OE1 GLU A 121      17.832 -10.256   9.147  1.00 33.56           O  
ATOM   1017  OE2 GLU A 121      18.640  -8.254   8.765  1.00 33.36           O  
ATOM   1018  N   GLU A 122      13.213  -9.923  10.953  1.00 21.89           N  
ATOM   1019  CA  GLU A 122      12.196 -10.734  10.292  1.00 24.16           C  
ATOM   1020  C   GLU A 122      10.822 -10.053  10.286  1.00 23.65           C  
ATOM   1021  O   GLU A 122      10.139 -10.020   9.261  1.00 21.38           O  
ATOM   1022  CB  GLU A 122      12.101 -12.101  10.976  1.00 27.75           C  
ATOM   1023  CG  GLU A 122      13.391 -12.945  10.927  1.00 34.22           C  
ATOM   1024  CD  GLU A 122      14.604 -12.264  11.571  1.00 38.19           C  
ATOM   1025  OE1 GLU A 122      14.470 -11.708  12.688  1.00 34.98           O  
ATOM   1026  OE2 GLU A 122      15.702 -12.301  10.963  1.00 40.08           O  
ATOM   1027  N   ASP A 123      10.414  -9.517  11.432  1.00 22.01           N  
ATOM   1028  CA  ASP A 123       9.123  -8.845  11.524  1.00 22.73           C  
ATOM   1029  C   ASP A 123       9.111  -7.540  10.741  1.00 20.22           C  
ATOM   1030  O   ASP A 123       8.075  -7.138  10.217  1.00 19.09           O  
ATOM   1031  CB  ASP A 123       8.748  -8.580  12.988  1.00 22.58           C  
ATOM   1032  CG  ASP A 123       8.265  -9.830  13.700  1.00 26.07           C  
ATOM   1033  OD1 ASP A 123       7.930 -10.815  13.010  1.00 27.75           O  
ATOM   1034  OD2 ASP A 123       8.199  -9.828  14.945  1.00 28.59           O  
ATOM   1035  N   LEU A 124      10.259  -6.874  10.656  1.00 20.65           N  
ATOM   1036  CA  LEU A 124      10.326  -5.621   9.918  1.00 21.18           C  
ATOM   1037  C   LEU A 124      10.147  -5.910   8.426  1.00 23.13           C  
ATOM   1038  O   LEU A 124       9.472  -5.157   7.717  1.00 21.01           O  
ATOM   1039  CB  LEU A 124      11.662  -4.906  10.182  1.00 21.24           C  
ATOM   1040  CG  LEU A 124      11.746  -3.427   9.793  1.00 22.90           C  
ATOM   1041  CD1 LEU A 124      10.595  -2.643  10.435  1.00 22.21           C  
ATOM   1042  CD2 LEU A 124      13.090  -2.859  10.233  1.00 20.94           C  
ATOM   1043  N   ARG A 125      10.734  -7.004   7.944  1.00 21.70           N  
ATOM   1044  CA  ARG A 125      10.578  -7.356   6.532  1.00 23.03           C  
ATOM   1045  C   ARG A 125       9.114  -7.682   6.267  1.00 22.70           C  
ATOM   1046  O   ARG A 125       8.566  -7.319   5.223  1.00 22.38           O  
ATOM   1047  CB  ARG A 125      11.430  -8.572   6.157  1.00 26.01           C  
ATOM   1048  CG  ARG A 125      12.933  -8.340   6.161  1.00 31.70           C  
ATOM   1049  CD  ARG A 125      13.645  -9.495   5.471  1.00 36.33           C  
ATOM   1050  NE  ARG A 125      15.084  -9.274   5.362  1.00 42.78           N  
ATOM   1051  CZ  ARG A 125      15.882  -9.943   4.533  1.00 44.15           C  
ATOM   1052  NH1 ARG A 125      15.381 -10.875   3.736  1.00 45.09           N  
ATOM   1053  NH2 ARG A 125      17.182  -9.684   4.504  1.00 45.13           N  
ATOM   1054  N   LYS A 126       8.486  -8.370   7.215  1.00 21.90           N  
ATOM   1055  CA  LYS A 126       7.081  -8.741   7.077  1.00 24.41           C  
ATOM   1056  C   LYS A 126       6.225  -7.482   7.023  1.00 21.85           C  
ATOM   1057  O   LYS A 126       5.276  -7.396   6.244  1.00 19.41           O  
ATOM   1058  CB  LYS A 126       6.635  -9.613   8.252  1.00 24.65           C  
ATOM   1059  CG  LYS A 126       5.172 -10.041   8.168  1.00 30.94           C  
ATOM   1060  CD  LYS A 126       4.782 -10.974   9.307  1.00 36.18           C  
ATOM   1061  CE  LYS A 126       3.363 -11.496   9.123  1.00 39.73           C  
ATOM   1062  NZ  LYS A 126       2.948 -12.420  10.223  1.00 42.58           N  
ATOM   1063  N   LEU A 127       6.561  -6.513   7.869  1.00 19.85           N  
ATOM   1064  CA  LEU A 127       5.834  -5.247   7.910  1.00 18.49           C  
ATOM   1065  C   LEU A 127       5.935  -4.506   6.579  1.00 18.28           C  
ATOM   1066  O   LEU A 127       4.925  -4.081   6.019  1.00 18.38           O  
ATOM   1067  CB  LEU A 127       6.387  -4.347   9.025  1.00 18.61           C  
ATOM   1068  CG  LEU A 127       5.802  -2.926   9.093  1.00 18.51           C  
ATOM   1069  CD1 LEU A 127       4.300  -2.997   9.356  1.00 18.79           C  
ATOM   1070  CD2 LEU A 127       6.499  -2.135  10.195  1.00 20.25           C  
ATOM   1071  N   PHE A 128       7.157  -4.338   6.083  1.00 16.11           N  
ATOM   1072  CA  PHE A 128       7.375  -3.636   4.826  1.00 17.18           C  
ATOM   1073  C   PHE A 128       6.639  -4.329   3.686  1.00 19.65           C  
ATOM   1074  O   PHE A 128       6.122  -3.673   2.781  1.00 19.15           O  
ATOM   1075  CB  PHE A 128       8.870  -3.555   4.486  1.00 18.50           C  
ATOM   1076  CG  PHE A 128       9.674  -2.670   5.412  1.00 19.90           C  
ATOM   1077  CD1 PHE A 128       9.062  -1.698   6.194  1.00 19.22           C  
ATOM   1078  CD2 PHE A 128      11.059  -2.791   5.468  1.00 21.28           C  
ATOM   1079  CE1 PHE A 128       9.817  -0.859   7.017  1.00 21.28           C  
ATOM   1080  CE2 PHE A 128      11.818  -1.960   6.284  1.00 21.74           C  
ATOM   1081  CZ  PHE A 128      11.197  -0.992   7.060  1.00 19.90           C  
ATOM   1082  N   SER A 129       6.608  -5.657   3.725  1.00 20.04           N  
ATOM   1083  CA  SER A 129       5.925  -6.424   2.690  1.00 22.65           C  
ATOM   1084  C   SER A 129       4.421  -6.134   2.724  1.00 21.71           C  
ATOM   1085  O   SER A 129       3.796  -5.936   1.678  1.00 22.34           O  
ATOM   1086  CB  SER A 129       6.165  -7.920   2.894  1.00 24.35           C  
ATOM   1087  OG  SER A 129       5.638  -8.656   1.804  1.00 29.75           O  
ATOM   1088  N   LYS A 130       3.845  -6.113   3.924  1.00 19.38           N  
ATOM   1089  CA  LYS A 130       2.417  -5.837   4.082  1.00 21.10           C  
ATOM   1090  C   LYS A 130       2.085  -4.396   3.697  1.00 20.42           C  
ATOM   1091  O   LYS A 130       1.011  -4.124   3.154  1.00 19.91           O  
ATOM   1092  CB  LYS A 130       1.969  -6.093   5.526  1.00 21.89           C  
ATOM   1093  CG  LYS A 130       2.239  -7.498   6.041  1.00 29.11           C  
ATOM   1094  CD  LYS A 130       1.398  -8.530   5.316  1.00 31.85           C  
ATOM   1095  CE  LYS A 130       0.855  -9.576   6.278  1.00 34.99           C  
ATOM   1096  NZ  LYS A 130      -0.478 -10.076   5.846  1.00 39.44           N  
ATOM   1097  N   VAL A 131       3.001  -3.476   3.986  1.00 16.10           N  
ATOM   1098  CA  VAL A 131       2.804  -2.068   3.656  1.00 18.73           C  
ATOM   1099  C   VAL A 131       2.791  -1.898   2.137  1.00 20.46           C  
ATOM   1100  O   VAL A 131       1.934  -1.201   1.586  1.00 17.92           O  
ATOM   1101  CB  VAL A 131       3.924  -1.178   4.270  1.00 17.30           C  
ATOM   1102  CG1 VAL A 131       3.879   0.215   3.665  1.00 16.32           C  
ATOM   1103  CG2 VAL A 131       3.740  -1.093   5.789  1.00 17.73           C  
ATOM   1104  N   ALA A 132       3.738  -2.541   1.460  1.00 19.29           N  
ATOM   1105  CA  ALA A 132       3.797  -2.464   0.005  1.00 22.12           C  
ATOM   1106  C   ALA A 132       2.480  -2.976  -0.591  1.00 21.80           C  
ATOM   1107  O   ALA A 132       1.954  -2.390  -1.537  1.00 23.98           O  
ATOM   1108  CB  ALA A 132       4.963  -3.286  -0.521  1.00 21.00           C  
ATOM   1109  N   GLU A 133       1.946  -4.057  -0.029  1.00 20.74           N  
ATOM   1110  CA  GLU A 133       0.695  -4.626  -0.525  1.00 22.24           C  
ATOM   1111  C   GLU A 133      -0.504  -3.709  -0.271  1.00 20.84           C  
ATOM   1112  O   GLU A 133      -1.502  -3.774  -0.987  1.00 18.83           O  
ATOM   1113  CB  GLU A 133       0.438  -5.997   0.109  1.00 24.96           C  
ATOM   1114  CG  GLU A 133       1.530  -7.020  -0.168  1.00 29.15           C  
ATOM   1115  CD  GLU A 133       1.158  -8.423   0.274  1.00 32.19           C  
ATOM   1116  OE1 GLU A 133       0.693  -8.593   1.423  1.00 34.22           O  
ATOM   1117  OE2 GLU A 133       1.340  -9.362  -0.531  1.00 35.78           O  
ATOM   1118  N   ALA A 134      -0.406  -2.853   0.742  1.00 17.13           N  
ATOM   1119  CA  ALA A 134      -1.501  -1.934   1.065  1.00 16.44           C  
ATOM   1120  C   ALA A 134      -1.523  -0.670   0.203  1.00 16.76           C  
ATOM   1121  O   ALA A 134      -2.546   0.011   0.114  1.00 17.39           O  
ATOM   1122  CB  ALA A 134      -1.430  -1.546   2.543  1.00 16.59           C  
ATOM   1123  N   LEU A 135      -0.403  -0.365  -0.444  1.00 16.66           N  
ATOM   1124  CA  LEU A 135      -0.285   0.846  -1.251  1.00 17.58           C  
ATOM   1125  C   LEU A 135      -0.780   0.823  -2.692  1.00 19.41           C  
ATOM   1126  O   LEU A 135      -0.648  -0.178  -3.397  1.00 19.91           O  
ATOM   1127  CB  LEU A 135       1.176   1.302  -1.281  1.00 17.92           C  
ATOM   1128  CG  LEU A 135       1.772   1.909  -0.012  1.00 18.31           C  
ATOM   1129  CD1 LEU A 135       3.289   2.039  -0.184  1.00 18.86           C  
ATOM   1130  CD2 LEU A 135       1.148   3.268   0.253  1.00 16.15           C  
ATOM   1131  N   LYS A 136      -1.339   1.954  -3.117  1.00 19.85           N  
ATOM   1132  CA  LYS A 136      -1.789   2.123  -4.496  1.00 20.66           C  
ATOM   1133  C   LYS A 136      -0.512   2.446  -5.266  1.00 20.85           C  
ATOM   1134  O   LYS A 136       0.468   2.910  -4.677  1.00 20.28           O  
ATOM   1135  CB  LYS A 136      -2.751   3.306  -4.619  1.00 18.44           C  
ATOM   1136  CG  LYS A 136      -4.094   3.115  -3.942  1.00 19.96           C  
ATOM   1137  CD  LYS A 136      -5.009   4.280  -4.283  1.00 21.67           C  
ATOM   1138  CE  LYS A 136      -6.334   4.191  -3.560  1.00 23.02           C  
ATOM   1139  NZ  LYS A 136      -7.152   5.380  -3.900  1.00 26.28           N  
ATOM   1140  N   PRO A 137      -0.497   2.207  -6.588  1.00 22.11           N  
ATOM   1141  CA  PRO A 137       0.699   2.496  -7.383  1.00 21.79           C  
ATOM   1142  C   PRO A 137       1.159   3.934  -7.193  1.00 21.25           C  
ATOM   1143  O   PRO A 137       0.354   4.863  -7.241  1.00 22.85           O  
ATOM   1144  CB  PRO A 137       0.237   2.224  -8.815  1.00 24.19           C  
ATOM   1145  CG  PRO A 137      -0.793   1.157  -8.635  1.00 24.22           C  
ATOM   1146  CD  PRO A 137      -1.570   1.660  -7.439  1.00 22.22           C  
ATOM   1147  N   GLY A 138       2.454   4.120  -6.976  1.00 19.55           N  
ATOM   1148  CA  GLY A 138       2.967   5.466  -6.785  1.00 19.80           C  
ATOM   1149  C   GLY A 138       2.756   6.004  -5.378  1.00 18.62           C  
ATOM   1150  O   GLY A 138       3.162   7.123  -5.077  1.00 19.72           O  
ATOM   1151  N   GLY A 139       2.118   5.214  -4.519  1.00 18.67           N  
ATOM   1152  CA  GLY A 139       1.883   5.647  -3.151  1.00 17.72           C  
ATOM   1153  C   GLY A 139       3.163   5.612  -2.332  1.00 18.59           C  
ATOM   1154  O   GLY A 139       4.166   5.042  -2.774  1.00 18.17           O  
ATOM   1155  N   VAL A 140       3.136   6.192  -1.133  1.00 16.94           N  
ATOM   1156  CA  VAL A 140       4.336   6.224  -0.300  1.00 16.39           C  
ATOM   1157  C   VAL A 140       4.189   5.725   1.134  1.00 17.81           C  
ATOM   1158  O   VAL A 140       3.123   5.832   1.746  1.00 15.91           O  
ATOM   1159  CB  VAL A 140       4.933   7.659  -0.227  1.00 17.16           C  
ATOM   1160  CG1 VAL A 140       5.319   8.137  -1.621  1.00 20.06           C  
ATOM   1161  CG2 VAL A 140       3.929   8.628   0.403  1.00 18.15           C  
ATOM   1162  N   PHE A 141       5.283   5.172   1.656  1.00 15.89           N  
ATOM   1163  CA  PHE A 141       5.354   4.701   3.039  1.00 16.06           C  
ATOM   1164  C   PHE A 141       6.343   5.660   3.699  1.00 16.33           C  
ATOM   1165  O   PHE A 141       7.414   5.930   3.140  1.00 16.99           O  
ATOM   1166  CB  PHE A 141       5.888   3.262   3.109  1.00 15.83           C  
ATOM   1167  CG  PHE A 141       6.282   2.827   4.501  1.00 14.97           C  
ATOM   1168  CD1 PHE A 141       5.364   2.869   5.548  1.00 18.05           C  
ATOM   1169  CD2 PHE A 141       7.574   2.380   4.761  1.00 18.09           C  
ATOM   1170  CE1 PHE A 141       5.729   2.471   6.839  1.00 17.84           C  
ATOM   1171  CE2 PHE A 141       7.949   1.980   6.049  1.00 20.30           C  
ATOM   1172  CZ  PHE A 141       7.029   2.026   7.085  1.00 18.38           C  
ATOM   1173  N   ILE A 142       5.977   6.195   4.862  1.00 15.29           N  
ATOM   1174  CA  ILE A 142       6.828   7.143   5.587  1.00 14.10           C  
ATOM   1175  C   ILE A 142       6.935   6.729   7.051  1.00 14.98           C  
ATOM   1176  O   ILE A 142       5.924   6.499   7.713  1.00 13.15           O  
ATOM   1177  CB  ILE A 142       6.232   8.579   5.549  1.00 15.72           C  
ATOM   1178  CG1 ILE A 142       6.062   9.052   4.104  1.00 17.37           C  
ATOM   1179  CG2 ILE A 142       7.137   9.551   6.300  1.00 14.25           C  
ATOM   1180  CD1 ILE A 142       5.222  10.320   3.979  1.00 16.75           C  
ATOM   1181  N   THR A 143       8.158   6.628   7.563  1.00 15.51           N  
ATOM   1182  CA  THR A 143       8.339   6.264   8.962  1.00 14.55           C  
ATOM   1183  C   THR A 143       9.607   6.925   9.490  1.00 14.72           C  
ATOM   1184  O   THR A 143      10.593   7.037   8.766  1.00 14.50           O  
ATOM   1185  CB  THR A 143       8.424   4.721   9.142  1.00 14.83           C  
ATOM   1186  OG1 THR A 143       8.273   4.397  10.528  1.00 16.76           O  
ATOM   1187  CG2 THR A 143       9.763   4.178   8.637  1.00 15.80           C  
ATOM   1188  N   ASP A 144       9.574   7.368  10.744  1.00 14.41           N  
ATOM   1189  CA  ASP A 144      10.730   8.027  11.345  1.00 15.67           C  
ATOM   1190  C   ASP A 144      11.302   7.249  12.519  1.00 15.94           C  
ATOM   1191  O   ASP A 144      10.581   6.566  13.239  1.00 17.73           O  
ATOM   1192  CB  ASP A 144      10.359   9.440  11.823  1.00 16.96           C  
ATOM   1193  CG  ASP A 144       9.321   9.428  12.935  1.00 18.36           C  
ATOM   1194  OD1 ASP A 144       8.201   8.941  12.692  1.00 19.51           O  
ATOM   1195  OD2 ASP A 144       9.620   9.903  14.056  1.00 18.14           O  
ATOM   1196  N   PHE A 145      12.610   7.359  12.710  1.00 17.86           N  
ATOM   1197  CA  PHE A 145      13.264   6.684  13.819  1.00 19.85           C  
ATOM   1198  C   PHE A 145      14.502   7.484  14.197  1.00 20.88           C  
ATOM   1199  O   PHE A 145      15.042   8.232  13.382  1.00 18.73           O  
ATOM   1200  CB  PHE A 145      13.594   5.229  13.458  1.00 22.79           C  
ATOM   1201  CG  PHE A 145      14.462   5.079  12.250  1.00 25.43           C  
ATOM   1202  CD1 PHE A 145      15.805   4.746  12.382  1.00 30.13           C  
ATOM   1203  CD2 PHE A 145      13.939   5.264  10.979  1.00 28.33           C  
ATOM   1204  CE1 PHE A 145      16.615   4.599  11.260  1.00 29.57           C  
ATOM   1205  CE2 PHE A 145      14.736   5.121   9.853  1.00 30.08           C  
ATOM   1206  CZ  PHE A 145      16.079   4.786   9.993  1.00 31.26           C  
ATOM   1207  N   PRO A 146      14.951   7.358  15.454  1.00 24.20           N  
ATOM   1208  CA  PRO A 146      16.121   8.100  15.923  1.00 24.95           C  
ATOM   1209  C   PRO A 146      17.475   7.439  15.730  1.00 26.70           C  
ATOM   1210  O   PRO A 146      17.573   6.252  15.420  1.00 25.66           O  
ATOM   1211  CB  PRO A 146      15.803   8.317  17.395  1.00 25.14           C  
ATOM   1212  CG  PRO A 146      15.185   7.013  17.766  1.00 26.74           C  
ATOM   1213  CD  PRO A 146      14.267   6.699  16.582  1.00 25.89           C  
ATOM   1214  N   CYS A 147      18.521   8.232  15.929  1.00 29.01           N  
ATOM   1215  CA  CYS A 147      19.884   7.748  15.797  1.00 32.17           C  
ATOM   1216  C   CYS A 147      20.143   6.674  16.840  1.00 31.88           C  
ATOM   1217  O   CYS A 147      19.918   6.896  18.027  1.00 33.92           O  
ATOM   1218  CB  CYS A 147      20.867   8.899  15.991  1.00 33.34           C  
ATOM   1219  SG  CYS A 147      22.567   8.350  16.184  1.00 41.25           S  
ATOM   1220  N   GLY A 155      23.681   7.339  32.546  1.00 36.53           N  
ATOM   1221  CA  GLY A 155      22.851   6.769  33.591  1.00 35.15           C  
ATOM   1222  C   GLY A 155      21.389   7.159  33.465  1.00 33.41           C  
ATOM   1223  O   GLY A 155      20.898   7.376  32.355  1.00 35.98           O  
ATOM   1224  N   PRO A 156      20.658   7.255  34.586  1.00 30.52           N  
ATOM   1225  CA  PRO A 156      19.243   7.628  34.534  1.00 28.22           C  
ATOM   1226  C   PRO A 156      19.022   9.119  34.294  1.00 27.52           C  
ATOM   1227  O   PRO A 156      19.789   9.954  34.770  1.00 26.93           O  
ATOM   1228  CB  PRO A 156      18.726   7.183  35.895  1.00 27.68           C  
ATOM   1229  CG  PRO A 156      19.903   7.430  36.782  1.00 29.27           C  
ATOM   1230  CD  PRO A 156      21.052   6.887  35.958  1.00 29.29           C  
ATOM   1231  N   VAL A 157      17.974   9.435  33.543  1.00 25.68           N  
ATOM   1232  CA  VAL A 157      17.599  10.815  33.244  1.00 27.42           C  
ATOM   1233  C   VAL A 157      16.233  11.030  33.881  1.00 26.43           C  
ATOM   1234  O   VAL A 157      15.326  10.221  33.692  1.00 24.62           O  
ATOM   1235  CB  VAL A 157      17.466  11.061  31.725  1.00 27.36           C  
ATOM   1236  CG1 VAL A 157      16.994  12.488  31.473  1.00 30.88           C  
ATOM   1237  CG2 VAL A 157      18.800  10.816  31.037  1.00 30.15           C  
ATOM   1238  N   VAL A 158      16.082  12.112  34.637  1.00 26.38           N  
ATOM   1239  CA  VAL A 158      14.809  12.378  35.295  1.00 26.97           C  
ATOM   1240  C   VAL A 158      14.165  13.660  34.804  1.00 26.28           C  
ATOM   1241  O   VAL A 158      14.848  14.653  34.561  1.00 26.28           O  
ATOM   1242  CB  VAL A 158      14.984  12.475  36.824  1.00 27.85           C  
ATOM   1243  CG1 VAL A 158      13.633  12.662  37.493  1.00 29.66           C  
ATOM   1244  CG2 VAL A 158      15.664  11.220  37.348  1.00 30.57           C  
ATOM   1245  N   TRP A 159      12.845  13.624  34.652  1.00 24.45           N  
ATOM   1246  CA  TRP A 159      12.079  14.784  34.217  1.00 23.39           C  
ATOM   1247  C   TRP A 159      10.653  14.694  34.746  1.00 22.69           C  
ATOM   1248  O   TRP A 159      10.271  13.692  35.353  1.00 18.76           O  
ATOM   1249  CB  TRP A 159      12.084  14.903  32.692  1.00 27.33           C  
ATOM   1250  CG  TRP A 159      11.675  13.673  31.954  1.00 28.55           C  
ATOM   1251  CD1 TRP A 159      12.320  12.463  31.938  1.00 30.65           C  
ATOM   1252  CD2 TRP A 159      10.561  13.547  31.071  1.00 28.99           C  
ATOM   1253  NE1 TRP A 159      11.672  11.594  31.092  1.00 29.97           N  
ATOM   1254  CE2 TRP A 159      10.589  12.234  30.546  1.00 30.49           C  
ATOM   1255  CE3 TRP A 159       9.538  14.416  30.667  1.00 29.79           C  
ATOM   1256  CZ2 TRP A 159       9.633  11.771  29.636  1.00 30.43           C  
ATOM   1257  CZ3 TRP A 159       8.587  13.956  29.762  1.00 29.62           C  
ATOM   1258  CH2 TRP A 159       8.644  12.645  29.257  1.00 30.86           C  
ATOM   1259  N   ASN A 160       9.858  15.739  34.524  1.00 20.36           N  
ATOM   1260  CA  ASN A 160       8.500  15.739  35.048  1.00 19.23           C  
ATOM   1261  C   ASN A 160       7.479  16.424  34.157  1.00 18.02           C  
ATOM   1262  O   ASN A 160       7.818  17.287  33.351  1.00 17.93           O  
ATOM   1263  CB  ASN A 160       8.480  16.412  36.423  1.00 20.18           C  
ATOM   1264  CG  ASN A 160       8.872  17.884  36.359  1.00 21.01           C  
ATOM   1265  OD1 ASN A 160       9.999  18.227  36.008  1.00 24.70           O  
ATOM   1266  ND2 ASN A 160       7.936  18.758  36.699  1.00 21.83           N  
ATOM   1267  N   GLU A 161       6.226  16.016  34.316  1.00 17.92           N  
ATOM   1268  CA  GLU A 161       5.104  16.580  33.578  1.00 18.30           C  
ATOM   1269  C   GLU A 161       3.926  16.618  34.545  1.00 18.70           C  
ATOM   1270  O   GLU A 161       4.059  16.232  35.709  1.00 20.19           O  
ATOM   1271  CB  GLU A 161       4.751  15.719  32.357  1.00 19.59           C  
ATOM   1272  CG  GLU A 161       5.776  15.733  31.230  1.00 21.78           C  
ATOM   1273  CD  GLU A 161       5.986  17.108  30.610  1.00 24.83           C  
ATOM   1274  OE1 GLU A 161       5.062  17.946  30.646  1.00 23.64           O  
ATOM   1275  OE2 GLU A 161       7.083  17.345  30.063  1.00 28.10           O  
ATOM   1276  N   GLN A 162       2.772  17.075  34.073  1.00 18.94           N  
ATOM   1277  CA  GLN A 162       1.605  17.165  34.939  1.00 20.03           C  
ATOM   1278  C   GLN A 162       0.292  17.020  34.188  1.00 19.31           C  
ATOM   1279  O   GLN A 162       0.096  17.627  33.136  1.00 22.30           O  
ATOM   1280  CB  GLN A 162       1.607  18.508  35.690  1.00 21.56           C  
ATOM   1281  CG  GLN A 162       0.515  18.611  36.754  1.00 25.18           C  
ATOM   1282  CD  GLN A 162       0.597  19.891  37.583  1.00 26.11           C  
ATOM   1283  OE1 GLN A 162       1.646  20.523  37.666  1.00 27.91           O  
ATOM   1284  NE2 GLN A 162      -0.512  20.258  38.214  1.00 27.34           N  
ATOM   1285  N   LYS A 163      -0.603  16.210  34.736  1.00 20.43           N  
ATOM   1286  CA  LYS A 163      -1.916  16.008  34.142  1.00 22.37           C  
ATOM   1287  C   LYS A 163      -2.941  16.360  35.213  1.00 22.74           C  
ATOM   1288  O   LYS A 163      -3.142  15.606  36.161  1.00 22.42           O  
ATOM   1289  CB  LYS A 163      -2.094  14.555  33.697  1.00 23.58           C  
ATOM   1290  CG  LYS A 163      -3.442  14.279  33.047  1.00 27.26           C  
ATOM   1291  CD  LYS A 163      -3.586  12.821  32.648  1.00 30.53           C  
ATOM   1292  CE  LYS A 163      -5.011  12.512  32.204  1.00 34.84           C  
ATOM   1293  NZ  LYS A 163      -5.429  13.404  31.089  1.00 35.66           N  
ATOM   1294  N   GLY A 164      -3.583  17.514  35.065  1.00 23.82           N  
ATOM   1295  CA  GLY A 164      -4.557  17.924  36.058  1.00 25.58           C  
ATOM   1296  C   GLY A 164      -3.855  18.164  37.382  1.00 24.21           C  
ATOM   1297  O   GLY A 164      -2.879  18.914  37.444  1.00 26.14           O  
ATOM   1298  N   GLU A 165      -4.332  17.514  38.436  1.00 26.07           N  
ATOM   1299  CA  GLU A 165      -3.741  17.668  39.761  1.00 28.63           C  
ATOM   1300  C   GLU A 165      -2.620  16.663  40.018  1.00 28.38           C  
ATOM   1301  O   GLU A 165      -1.971  16.700  41.071  1.00 28.61           O  
ATOM   1302  CB  GLU A 165      -4.812  17.495  40.834  1.00 32.28           C  
ATOM   1303  CG  GLU A 165      -5.946  18.496  40.742  1.00 39.26           C  
ATOM   1304  CD  GLU A 165      -6.926  18.356  41.890  1.00 43.54           C  
ATOM   1305  OE1 GLU A 165      -6.503  18.527  43.056  1.00 45.46           O  
ATOM   1306  OE2 GLU A 165      -8.116  18.075  41.629  1.00 46.48           O  
ATOM   1307  N   GLU A 166      -2.396  15.765  39.065  1.00 24.63           N  
ATOM   1308  CA  GLU A 166      -1.360  14.756  39.228  1.00 22.08           C  
ATOM   1309  C   GLU A 166      -0.034  15.163  38.606  1.00 20.92           C  
ATOM   1310  O   GLU A 166       0.021  15.670  37.485  1.00 21.83           O  
ATOM   1311  CB  GLU A 166      -1.832  13.426  38.638  1.00 21.51           C  
ATOM   1312  CG  GLU A 166      -3.100  12.889  39.294  1.00 26.09           C  
ATOM   1313  CD  GLU A 166      -3.418  11.460  38.891  1.00 27.54           C  
ATOM   1314  OE1 GLU A 166      -3.394  11.164  37.681  1.00 26.94           O  
ATOM   1315  OE2 GLU A 166      -3.704  10.633  39.785  1.00 29.35           O  
ATOM   1316  N   LYS A 167       1.045  14.942  39.347  1.00 18.16           N  
ATOM   1317  CA  LYS A 167       2.365  15.277  38.855  1.00 17.22           C  
ATOM   1318  C   LYS A 167       3.096  13.987  38.527  1.00 18.84           C  
ATOM   1319  O   LYS A 167       3.049  13.014  39.287  1.00 18.21           O  
ATOM   1320  CB  LYS A 167       3.125  16.097  39.900  1.00 20.10           C  
ATOM   1321  CG  LYS A 167       2.476  17.462  40.113  1.00 22.24           C  
ATOM   1322  CD  LYS A 167       3.133  18.273  41.202  1.00 25.49           C  
ATOM   1323  CE  LYS A 167       2.351  19.567  41.427  1.00 28.84           C  
ATOM   1324  NZ  LYS A 167       2.875  20.347  42.588  1.00 30.57           N  
ATOM   1325  N   LEU A 168       3.747  13.972  37.374  1.00 17.25           N  
ATOM   1326  CA  LEU A 168       4.471  12.783  36.961  1.00 16.84           C  
ATOM   1327  C   LEU A 168       5.970  13.006  37.014  1.00 15.92           C  
ATOM   1328  O   LEU A 168       6.473  13.975  36.452  1.00 15.39           O  
ATOM   1329  CB  LEU A 168       4.068  12.384  35.536  1.00 17.22           C  
ATOM   1330  CG  LEU A 168       2.769  11.595  35.344  1.00 22.03           C  
ATOM   1331  CD1 LEU A 168       1.573  12.397  35.834  1.00 22.86           C  
ATOM   1332  CD2 LEU A 168       2.613  11.259  33.864  1.00 22.41           C  
ATOM   1333  N   VAL A 169       6.677  12.127  37.720  1.00 13.69           N  
ATOM   1334  CA  VAL A 169       8.131  12.203  37.779  1.00 14.52           C  
ATOM   1335  C   VAL A 169       8.563  10.964  37.021  1.00 16.28           C  
ATOM   1336  O   VAL A 169       8.213   9.838  37.393  1.00 15.99           O  
ATOM   1337  CB  VAL A 169       8.669  12.159  39.215  1.00 15.26           C  
ATOM   1338  CG1 VAL A 169      10.193  12.071  39.195  1.00 17.04           C  
ATOM   1339  CG2 VAL A 169       8.237  13.416  39.955  1.00 18.57           C  
ATOM   1340  N   ILE A 170       9.316  11.185  35.951  1.00 16.27           N  
ATOM   1341  CA  ILE A 170       9.740  10.107  35.071  1.00 18.82           C  
ATOM   1342  C   ILE A 170      11.241   9.903  35.063  1.00 19.55           C  
ATOM   1343  O   ILE A 170      12.006  10.854  34.906  1.00 19.73           O  
ATOM   1344  CB  ILE A 170       9.269  10.411  33.636  1.00 18.66           C  
ATOM   1345  CG1 ILE A 170       7.786  10.780  33.664  1.00 20.09           C  
ATOM   1346  CG2 ILE A 170       9.508   9.206  32.726  1.00 20.21           C  
ATOM   1347  CD1 ILE A 170       7.355  11.695  32.545  1.00 21.58           C  
ATOM   1348  N   MET A 171      11.659   8.653  35.227  1.00 18.73           N  
ATOM   1349  CA  MET A 171      13.074   8.326  35.233  1.00 20.06           C  
ATOM   1350  C   MET A 171      13.343   7.291  34.151  1.00 19.12           C  
ATOM   1351  O   MET A 171      12.781   6.195  34.184  1.00 17.99           O  
ATOM   1352  CB  MET A 171      13.465   7.782  36.601  1.00 20.88           C  
ATOM   1353  CG  MET A 171      14.929   7.439  36.738  1.00 25.74           C  
ATOM   1354  SD  MET A 171      15.343   7.188  38.467  1.00 30.88           S  
ATOM   1355  CE  MET A 171      14.653   5.556  38.741  1.00 28.89           C  
ATOM   1356  N   ASP A 172      14.200   7.651  33.201  1.00 17.52           N  
ATOM   1357  CA  ASP A 172      14.533   6.777  32.083  1.00 20.14           C  
ATOM   1358  C   ASP A 172      15.966   6.277  32.098  1.00 20.35           C  
ATOM   1359  O   ASP A 172      16.892   7.014  32.440  1.00 20.11           O  
ATOM   1360  CB  ASP A 172      14.336   7.501  30.750  1.00 21.87           C  
ATOM   1361  CG  ASP A 172      12.935   8.040  30.571  1.00 24.35           C  
ATOM   1362  OD1 ASP A 172      11.972   7.370  30.989  1.00 23.80           O  
ATOM   1363  OD2 ASP A 172      12.804   9.137  29.991  1.00 27.14           O  
ATOM   1364  N   TRP A 173      16.145   5.019  31.716  1.00 20.96           N  
ATOM   1365  CA  TRP A 173      17.480   4.452  31.625  1.00 21.95           C  
ATOM   1366  C   TRP A 173      17.434   3.326  30.607  1.00 22.57           C  
ATOM   1367  O   TRP A 173      16.367   2.769  30.328  1.00 21.83           O  
ATOM   1368  CB  TRP A 173      17.982   3.973  32.997  1.00 20.69           C  
ATOM   1369  CG  TRP A 173      17.427   2.681  33.515  1.00 19.03           C  
ATOM   1370  CD1 TRP A 173      18.004   1.445  33.419  1.00 19.48           C  
ATOM   1371  CD2 TRP A 173      16.232   2.505  34.285  1.00 19.47           C  
ATOM   1372  NE1 TRP A 173      17.249   0.516  34.087  1.00 18.88           N  
ATOM   1373  CE2 TRP A 173      16.154   1.137  34.627  1.00 20.51           C  
ATOM   1374  CE3 TRP A 173      15.222   3.370  34.721  1.00 19.18           C  
ATOM   1375  CZ2 TRP A 173      15.103   0.611  35.387  1.00 20.05           C  
ATOM   1376  CZ3 TRP A 173      14.173   2.847  35.481  1.00 20.77           C  
ATOM   1377  CH2 TRP A 173      14.124   1.478  35.804  1.00 20.83           C  
ATOM   1378  N   ARG A 174      18.584   3.014  30.025  1.00 22.96           N  
ATOM   1379  CA  ARG A 174      18.639   1.969  29.018  1.00 26.36           C  
ATOM   1380  C   ARG A 174      19.778   0.987  29.233  1.00 26.82           C  
ATOM   1381  O   ARG A 174      20.796   1.306  29.857  1.00 26.93           O  
ATOM   1382  CB  ARG A 174      18.776   2.584  27.625  1.00 28.49           C  
ATOM   1383  CG  ARG A 174      20.023   3.424  27.453  1.00 33.83           C  
ATOM   1384  CD  ARG A 174      20.346   3.651  25.985  1.00 39.89           C  
ATOM   1385  NE  ARG A 174      21.470   4.567  25.797  1.00 44.19           N  
ATOM   1386  CZ  ARG A 174      22.680   4.405  26.327  1.00 46.52           C  
ATOM   1387  NH1 ARG A 174      22.949   3.353  27.093  1.00 46.61           N  
ATOM   1388  NH2 ARG A 174      23.630   5.301  26.085  1.00 48.18           N  
ATOM   1389  N   GLU A 175      19.581  -0.213  28.707  1.00 25.57           N  
ATOM   1390  CA  GLU A 175      20.561  -1.283  28.778  1.00 28.00           C  
ATOM   1391  C   GLU A 175      20.686  -1.779  27.343  1.00 28.32           C  
ATOM   1392  O   GLU A 175      19.729  -2.307  26.773  1.00 26.47           O  
ATOM   1393  CB  GLU A 175      20.061  -2.382  29.719  1.00 30.69           C  
ATOM   1394  CG  GLU A 175      20.220  -2.010  31.196  1.00 35.12           C  
ATOM   1395  CD  GLU A 175      19.266  -2.752  32.116  1.00 38.63           C  
ATOM   1396  OE1 GLU A 175      19.027  -3.957  31.891  1.00 37.65           O  
ATOM   1397  OE2 GLU A 175      18.765  -2.125  33.082  1.00 39.14           O  
ATOM   1398  N   VAL A 176      21.861  -1.581  26.756  1.00 26.95           N  
ATOM   1399  CA  VAL A 176      22.104  -1.965  25.372  1.00 28.62           C  
ATOM   1400  C   VAL A 176      22.945  -3.224  25.194  1.00 29.50           C  
ATOM   1401  O   VAL A 176      23.886  -3.469  25.949  1.00 27.79           O  
ATOM   1402  CB  VAL A 176      22.797  -0.817  24.609  1.00 29.65           C  
ATOM   1403  CG1 VAL A 176      22.983  -1.187  23.141  1.00 30.48           C  
ATOM   1404  CG2 VAL A 176      21.983   0.455  24.744  1.00 29.56           C  
ATOM   1405  N   GLU A 177      22.578  -4.017  24.191  1.00 28.57           N  
ATOM   1406  CA  GLU A 177      23.291  -5.240  23.833  1.00 30.05           C  
ATOM   1407  C   GLU A 177      23.635  -5.021  22.360  1.00 29.79           C  
ATOM   1408  O   GLU A 177      22.890  -5.426  21.465  1.00 27.30           O  
ATOM   1409  CB  GLU A 177      22.387  -6.463  23.992  1.00 31.00           C  
ATOM   1410  CG  GLU A 177      21.843  -6.644  25.400  1.00 33.99           C  
ATOM   1411  CD  GLU A 177      20.944  -7.855  25.526  1.00 36.74           C  
ATOM   1412  OE1 GLU A 177      20.001  -7.989  24.716  1.00 37.31           O  
ATOM   1413  OE2 GLU A 177      21.175  -8.673  26.442  1.00 39.84           O  
ATOM   1414  N   PRO A 178      24.775  -4.364  22.097  1.00 30.38           N  
ATOM   1415  CA  PRO A 178      25.270  -4.041  20.754  1.00 29.45           C  
ATOM   1416  C   PRO A 178      25.379  -5.195  19.766  1.00 29.18           C  
ATOM   1417  O   PRO A 178      24.964  -5.067  18.609  1.00 26.34           O  
ATOM   1418  CB  PRO A 178      26.623  -3.390  21.036  1.00 32.23           C  
ATOM   1419  CG  PRO A 178      27.112  -3.787  22.391  1.00 33.24           C  
ATOM   1420  CD  PRO A 178      25.819  -4.103  23.105  1.00 31.90           C  
ATOM   1421  N   ALA A 179      25.939  -6.312  20.221  1.00 27.62           N  
ATOM   1422  CA  ALA A 179      26.131  -7.481  19.367  1.00 27.93           C  
ATOM   1423  C   ALA A 179      24.868  -7.891  18.627  1.00 27.06           C  
ATOM   1424  O   ALA A 179      24.895  -8.115  17.413  1.00 27.01           O  
ATOM   1425  CB  ALA A 179      26.643  -8.650  20.197  1.00 28.38           C  
ATOM   1426  N   VAL A 180      23.765  -7.993  19.362  1.00 25.40           N  
ATOM   1427  CA  VAL A 180      22.494  -8.390  18.772  1.00 24.59           C  
ATOM   1428  C   VAL A 180      21.594  -7.204  18.436  1.00 24.25           C  
ATOM   1429  O   VAL A 180      20.429  -7.380  18.079  1.00 24.33           O  
ATOM   1430  CB  VAL A 180      21.742  -9.366  19.705  1.00 25.09           C  
ATOM   1431  CG1 VAL A 180      22.538 -10.668  19.833  1.00 26.63           C  
ATOM   1432  CG2 VAL A 180      21.541  -8.735  21.076  1.00 27.15           C  
ATOM   1433  N   GLN A 181      22.146  -5.998  18.544  1.00 23.40           N  
ATOM   1434  CA  GLN A 181      21.407  -4.782  18.226  1.00 24.54           C  
ATOM   1435  C   GLN A 181      20.069  -4.689  18.967  1.00 25.48           C  
ATOM   1436  O   GLN A 181      19.018  -4.427  18.369  1.00 22.93           O  
ATOM   1437  CB  GLN A 181      21.192  -4.704  16.711  1.00 26.05           C  
ATOM   1438  CG  GLN A 181      22.478  -4.418  15.932  1.00 26.57           C  
ATOM   1439  CD  GLN A 181      22.326  -4.623  14.439  1.00 30.00           C  
ATOM   1440  OE1 GLN A 181      22.847  -5.591  13.876  1.00 30.88           O  
ATOM   1441  NE2 GLN A 181      21.600  -3.722  13.788  1.00 29.27           N  
ATOM   1442  N   LYS A 182      20.123  -4.908  20.274  1.00 23.34           N  
ATOM   1443  CA  LYS A 182      18.936  -4.853  21.113  1.00 24.79           C  
ATOM   1444  C   LYS A 182      19.127  -3.766  22.153  1.00 25.93           C  
ATOM   1445  O   LYS A 182      20.250  -3.482  22.575  1.00 25.26           O  
ATOM   1446  CB  LYS A 182      18.710  -6.189  21.826  1.00 25.32           C  
ATOM   1447  CG  LYS A 182      18.312  -7.352  20.924  1.00 28.03           C  
ATOM   1448  CD  LYS A 182      16.877  -7.237  20.435  1.00 25.79           C  
ATOM   1449  CE  LYS A 182      16.433  -8.523  19.739  1.00 26.01           C  
ATOM   1450  NZ  LYS A 182      15.017  -8.456  19.275  1.00 25.09           N  
ATOM   1451  N   LEU A 183      18.022  -3.154  22.553  1.00 25.50           N  
ATOM   1452  CA  LEU A 183      18.049  -2.106  23.559  1.00 27.87           C  
ATOM   1453  C   LEU A 183      16.883  -2.369  24.499  1.00 27.79           C  
ATOM   1454  O   LEU A 183      15.788  -2.713  24.058  1.00 26.92           O  
ATOM   1455  CB  LEU A 183      17.898  -0.731  22.891  1.00 30.50           C  
ATOM   1456  CG  LEU A 183      17.901   0.536  23.757  1.00 34.28           C  
ATOM   1457  CD1 LEU A 183      18.246   1.738  22.893  1.00 36.65           C  
ATOM   1458  CD2 LEU A 183      16.551   0.724  24.422  1.00 34.32           C  
ATOM   1459  N   ARG A 184      17.128  -2.249  25.798  1.00 26.40           N  
ATOM   1460  CA  ARG A 184      16.069  -2.433  26.778  1.00 27.04           C  
ATOM   1461  C   ARG A 184      15.736  -1.032  27.257  1.00 25.74           C  
ATOM   1462  O   ARG A 184      16.558  -0.385  27.906  1.00 24.20           O  
ATOM   1463  CB  ARG A 184      16.554  -3.286  27.952  1.00 31.43           C  
ATOM   1464  CG  ARG A 184      16.887  -4.717  27.577  1.00 37.10           C  
ATOM   1465  CD  ARG A 184      15.651  -5.459  27.108  1.00 40.49           C  
ATOM   1466  NE  ARG A 184      14.588  -5.445  28.111  1.00 44.73           N  
ATOM   1467  CZ  ARG A 184      13.458  -6.141  28.012  1.00 45.78           C  
ATOM   1468  NH1 ARG A 184      13.240  -6.912  26.955  1.00 47.26           N  
ATOM   1469  NH2 ARG A 184      12.544  -6.067  28.969  1.00 47.73           N  
ATOM   1470  N   PHE A 185      14.547  -0.555  26.908  1.00 24.00           N  
ATOM   1471  CA  PHE A 185      14.119   0.777  27.302  1.00 24.61           C  
ATOM   1472  C   PHE A 185      13.304   0.703  28.580  1.00 22.28           C  
ATOM   1473  O   PHE A 185      12.227   0.101  28.616  1.00 21.10           O  
ATOM   1474  CB  PHE A 185      13.285   1.422  26.199  1.00 27.92           C  
ATOM   1475  CG  PHE A 185      12.769   2.782  26.566  1.00 34.84           C  
ATOM   1476  CD1 PHE A 185      13.651   3.800  26.906  1.00 36.57           C  
ATOM   1477  CD2 PHE A 185      11.403   3.033  26.606  1.00 37.06           C  
ATOM   1478  CE1 PHE A 185      13.182   5.056  27.285  1.00 40.73           C  
ATOM   1479  CE2 PHE A 185      10.919   4.283  26.983  1.00 38.53           C  
ATOM   1480  CZ  PHE A 185      11.812   5.298  27.324  1.00 39.94           C  
ATOM   1481  N   LYS A 186      13.814   1.331  29.627  1.00 21.25           N  
ATOM   1482  CA  LYS A 186      13.144   1.303  30.913  1.00 21.00           C  
ATOM   1483  C   LYS A 186      12.757   2.700  31.359  1.00 20.39           C  
ATOM   1484  O   LYS A 186      13.524   3.647  31.221  1.00 20.33           O  
ATOM   1485  CB  LYS A 186      14.057   0.622  31.937  1.00 24.25           C  
ATOM   1486  CG  LYS A 186      14.443  -0.800  31.509  1.00 27.12           C  
ATOM   1487  CD  LYS A 186      15.592  -1.359  32.320  1.00 31.43           C  
ATOM   1488  CE  LYS A 186      16.009  -2.735  31.819  1.00 30.50           C  
ATOM   1489  NZ  LYS A 186      14.950  -3.768  32.004  1.00 30.15           N  
ATOM   1490  N   ARG A 187      11.546   2.815  31.884  1.00 20.30           N  
ATOM   1491  CA  ARG A 187      11.038   4.093  32.343  1.00 19.63           C  
ATOM   1492  C   ARG A 187      10.138   3.906  33.554  1.00 19.20           C  
ATOM   1493  O   ARG A 187       9.130   3.204  33.493  1.00 20.00           O  
ATOM   1494  CB  ARG A 187      10.272   4.777  31.205  1.00 21.13           C  
ATOM   1495  CG  ARG A 187       9.353   5.913  31.636  1.00 22.43           C  
ATOM   1496  CD  ARG A 187       8.731   6.584  30.419  1.00 24.17           C  
ATOM   1497  NE  ARG A 187       9.725   7.338  29.658  1.00 23.22           N  
ATOM   1498  CZ  ARG A 187       9.524   7.820  28.435  1.00 28.48           C  
ATOM   1499  NH1 ARG A 187       8.366   7.620  27.821  1.00 29.10           N  
ATOM   1500  NH2 ARG A 187      10.475   8.519  27.831  1.00 28.23           N  
ATOM   1501  N   LEU A 188      10.527   4.514  34.667  1.00 17.98           N  
ATOM   1502  CA  LEU A 188       9.729   4.444  35.878  1.00 16.91           C  
ATOM   1503  C   LEU A 188       8.873   5.700  35.904  1.00 18.50           C  
ATOM   1504  O   LEU A 188       9.400   6.812  35.870  1.00 17.95           O  
ATOM   1505  CB  LEU A 188      10.626   4.421  37.116  1.00 17.90           C  
ATOM   1506  CG  LEU A 188       9.878   4.506  38.452  1.00 19.65           C  
ATOM   1507  CD1 LEU A 188       9.042   3.237  38.665  1.00 17.96           C  
ATOM   1508  CD2 LEU A 188      10.880   4.681  39.580  1.00 18.27           C  
ATOM   1509  N   VAL A 189       7.556   5.531  35.937  1.00 15.63           N  
ATOM   1510  CA  VAL A 189       6.665   6.684  35.989  1.00 15.35           C  
ATOM   1511  C   VAL A 189       5.994   6.713  37.357  1.00 16.14           C  
ATOM   1512  O   VAL A 189       5.283   5.783  37.737  1.00 16.62           O  
ATOM   1513  CB  VAL A 189       5.585   6.622  34.884  1.00 16.98           C  
ATOM   1514  CG1 VAL A 189       4.644   7.826  34.997  1.00 16.89           C  
ATOM   1515  CG2 VAL A 189       6.255   6.604  33.512  1.00 16.68           C  
ATOM   1516  N   GLN A 190       6.259   7.769  38.115  1.00 16.55           N  
ATOM   1517  CA  GLN A 190       5.656   7.909  39.431  1.00 16.40           C  
ATOM   1518  C   GLN A 190       4.590   8.993  39.310  1.00 16.80           C  
ATOM   1519  O   GLN A 190       4.865  10.089  38.824  1.00 16.19           O  
ATOM   1520  CB  GLN A 190       6.723   8.295  40.462  1.00 17.20           C  
ATOM   1521  CG  GLN A 190       7.741   7.186  40.711  1.00 20.33           C  
ATOM   1522  CD  GLN A 190       8.898   7.634  41.572  1.00 25.35           C  
ATOM   1523  OE1 GLN A 190       9.829   8.286  41.093  1.00 27.84           O  
ATOM   1524  NE2 GLN A 190       8.842   7.298  42.853  1.00 24.84           N  
ATOM   1525  N   ILE A 191       3.373   8.667  39.734  1.00 15.86           N  
ATOM   1526  CA  ILE A 191       2.243   9.592  39.658  1.00 16.65           C  
ATOM   1527  C   ILE A 191       1.919  10.075  41.064  1.00 16.75           C  
ATOM   1528  O   ILE A 191       1.435   9.310  41.899  1.00 16.31           O  
ATOM   1529  CB  ILE A 191       1.017   8.885  39.041  1.00 17.37           C  
ATOM   1530  CG1 ILE A 191       1.412   8.304  37.680  1.00 19.18           C  
ATOM   1531  CG2 ILE A 191      -0.141   9.868  38.858  1.00 17.81           C  
ATOM   1532  CD1 ILE A 191       0.298   7.542  36.990  1.00 22.62           C  
ATOM   1533  N   LEU A 192       2.196  11.349  41.314  1.00 16.88           N  
ATOM   1534  CA  LEU A 192       1.988  11.961  42.621  1.00 18.90           C  
ATOM   1535  C   LEU A 192       0.703  12.760  42.760  1.00 19.88           C  
ATOM   1536  O   LEU A 192       0.431  13.654  41.961  1.00 18.17           O  
ATOM   1537  CB  LEU A 192       3.158  12.897  42.956  1.00 18.21           C  
ATOM   1538  CG  LEU A 192       4.498  12.303  43.392  1.00 21.64           C  
ATOM   1539  CD1 LEU A 192       4.969  11.267  42.385  1.00 21.51           C  
ATOM   1540  CD2 LEU A 192       5.517  13.436  43.542  1.00 20.61           C  
ATOM   1541  N   ARG A 193      -0.075  12.431  43.786  1.00 20.73           N  
ATOM   1542  CA  ARG A 193      -1.310  13.147  44.077  1.00 22.59           C  
ATOM   1543  C   ARG A 193      -0.962  14.262  45.068  1.00 22.72           C  
ATOM   1544  O   ARG A 193       0.074  14.204  45.736  1.00 20.91           O  
ATOM   1545  CB  ARG A 193      -2.354  12.199  44.675  1.00 24.24           C  
ATOM   1546  CG  ARG A 193      -2.801  11.113  43.699  1.00 32.60           C  
ATOM   1547  CD  ARG A 193      -4.109  10.479  44.123  1.00 35.64           C  
ATOM   1548  NE  ARG A 193      -5.192  11.460  44.161  1.00 41.74           N  
ATOM   1549  CZ  ARG A 193      -5.676  12.089  43.093  1.00 43.94           C  
ATOM   1550  NH1 ARG A 193      -5.182  11.843  41.886  1.00 43.59           N  
ATOM   1551  NH2 ARG A 193      -6.658  12.972  43.233  1.00 44.52           N  
ATOM   1552  N   PRO A 194      -1.812  15.296  45.161  1.00 22.71           N  
ATOM   1553  CA  PRO A 194      -1.615  16.439  46.059  1.00 24.73           C  
ATOM   1554  C   PRO A 194      -1.261  16.090  47.504  1.00 25.14           C  
ATOM   1555  O   PRO A 194      -0.411  16.742  48.108  1.00 24.78           O  
ATOM   1556  CB  PRO A 194      -2.941  17.188  45.953  1.00 25.54           C  
ATOM   1557  CG  PRO A 194      -3.324  16.954  44.523  1.00 24.08           C  
ATOM   1558  CD  PRO A 194      -3.038  15.471  44.359  1.00 23.47           C  
ATOM   1559  N   ASN A 195      -1.906  15.063  48.052  1.00 26.11           N  
ATOM   1560  CA  ASN A 195      -1.650  14.666  49.434  1.00 27.20           C  
ATOM   1561  C   ASN A 195      -0.391  13.812  49.605  1.00 26.98           C  
ATOM   1562  O   ASN A 195      -0.093  13.351  50.708  1.00 25.20           O  
ATOM   1563  CB  ASN A 195      -2.856  13.914  50.001  1.00 28.84           C  
ATOM   1564  CG  ASN A 195      -3.113  12.600  49.291  1.00 32.03           C  
ATOM   1565  OD1 ASN A 195      -2.360  12.200  48.402  1.00 30.05           O  
ATOM   1566  ND2 ASN A 195      -4.182  11.916  49.686  1.00 33.76           N  
ATOM   1567  N   GLY A 196       0.341  13.590  48.517  1.00 24.46           N  
ATOM   1568  CA  GLY A 196       1.560  12.802  48.613  1.00 22.37           C  
ATOM   1569  C   GLY A 196       1.438  11.334  48.245  1.00 21.95           C  
ATOM   1570  O   GLY A 196       2.452  10.649  48.100  1.00 21.70           O  
ATOM   1571  N   GLU A 197       0.216  10.826  48.109  1.00 21.64           N  
ATOM   1572  CA  GLU A 197       0.065   9.426  47.742  1.00 22.60           C  
ATOM   1573  C   GLU A 197       0.664   9.229  46.354  1.00 20.71           C  
ATOM   1574  O   GLU A 197       0.563  10.101  45.496  1.00 19.06           O  
ATOM   1575  CB  GLU A 197      -1.410   9.013  47.759  1.00 28.04           C  
ATOM   1576  CG  GLU A 197      -1.968   8.865  49.165  1.00 34.53           C  
ATOM   1577  CD  GLU A 197      -1.132   7.917  50.010  1.00 39.14           C  
ATOM   1578  OE1 GLU A 197      -1.001   6.732  49.622  1.00 41.72           O  
ATOM   1579  OE2 GLU A 197      -0.600   8.357  51.056  1.00 41.16           O  
ATOM   1580  N   VAL A 198       1.295   8.084  46.138  1.00 20.92           N  
ATOM   1581  CA  VAL A 198       1.924   7.820  44.852  1.00 22.16           C  
ATOM   1582  C   VAL A 198       1.588   6.466  44.258  1.00 22.02           C  
ATOM   1583  O   VAL A 198       1.294   5.509  44.973  1.00 21.15           O  
ATOM   1584  CB  VAL A 198       3.474   7.942  44.974  1.00 25.00           C  
ATOM   1585  CG1 VAL A 198       3.957   7.176  46.184  1.00 25.97           C  
ATOM   1586  CG2 VAL A 198       4.165   7.398  43.722  1.00 25.82           C  
ATOM   1587  N   LYS A 199       1.598   6.419  42.931  1.00 21.55           N  
ATOM   1588  CA  LYS A 199       1.381   5.188  42.182  1.00 24.33           C  
ATOM   1589  C   LYS A 199       2.562   5.146  41.223  1.00 24.07           C  
ATOM   1590  O   LYS A 199       2.979   6.186  40.706  1.00 22.66           O  
ATOM   1591  CB  LYS A 199       0.063   5.224  41.405  1.00 26.36           C  
ATOM   1592  CG  LYS A 199      -1.139   4.850  42.257  1.00 30.14           C  
ATOM   1593  CD  LYS A 199      -2.399   4.698  41.430  1.00 32.60           C  
ATOM   1594  CE  LYS A 199      -3.541   4.182  42.297  1.00 34.20           C  
ATOM   1595  NZ  LYS A 199      -3.187   2.873  42.921  1.00 36.31           N  
ATOM   1596  N   ALA A 200       3.120   3.962  41.006  1.00 21.18           N  
ATOM   1597  CA  ALA A 200       4.270   3.839  40.120  1.00 20.23           C  
ATOM   1598  C   ALA A 200       4.118   2.678  39.155  1.00 20.01           C  
ATOM   1599  O   ALA A 200       3.630   1.608  39.521  1.00 20.61           O  
ATOM   1600  CB  ALA A 200       5.540   3.668  40.934  1.00 19.76           C  
ATOM   1601  N   PHE A 201       4.555   2.907  37.923  1.00 19.31           N  
ATOM   1602  CA  PHE A 201       4.485   1.912  36.861  1.00 19.52           C  
ATOM   1603  C   PHE A 201       5.825   1.864  36.149  1.00 19.75           C  
ATOM   1604  O   PHE A 201       6.457   2.898  35.924  1.00 20.51           O  
ATOM   1605  CB  PHE A 201       3.388   2.290  35.867  1.00 19.94           C  
ATOM   1606  CG  PHE A 201       2.011   2.266  36.451  1.00 21.09           C  
ATOM   1607  CD1 PHE A 201       1.353   1.059  36.662  1.00 23.31           C  
ATOM   1608  CD2 PHE A 201       1.375   3.448  36.809  1.00 25.22           C  
ATOM   1609  CE1 PHE A 201       0.078   1.031  37.220  1.00 23.88           C  
ATOM   1610  CE2 PHE A 201       0.099   3.428  37.369  1.00 27.08           C  
ATOM   1611  CZ  PHE A 201      -0.547   2.219  37.574  1.00 23.43           C  
ATOM   1612  N   LEU A 202       6.256   0.663  35.788  1.00 17.44           N  
ATOM   1613  CA  LEU A 202       7.533   0.501  35.112  1.00 17.67           C  
ATOM   1614  C   LEU A 202       7.380   0.065  33.663  1.00 16.09           C  
ATOM   1615  O   LEU A 202       6.829  -0.998  33.383  1.00 17.92           O  
ATOM   1616  CB  LEU A 202       8.395  -0.535  35.850  1.00 19.27           C  
ATOM   1617  CG  LEU A 202       9.711  -0.926  35.161  1.00 20.52           C  
ATOM   1618  CD1 LEU A 202      10.684   0.239  35.202  1.00 20.54           C  
ATOM   1619  CD2 LEU A 202      10.314  -2.146  35.854  1.00 22.13           C  
ATOM   1620  N   VAL A 203       7.857   0.894  32.747  1.00 17.00           N  
ATOM   1621  CA  VAL A 203       7.823   0.553  31.332  1.00 18.92           C  
ATOM   1622  C   VAL A 203       9.117  -0.215  31.122  1.00 20.57           C  
ATOM   1623  O   VAL A 203      10.162   0.183  31.631  1.00 18.91           O  
ATOM   1624  CB  VAL A 203       7.846   1.807  30.426  1.00 19.83           C  
ATOM   1625  CG1 VAL A 203       7.923   1.382  28.962  1.00 22.55           C  
ATOM   1626  CG2 VAL A 203       6.609   2.657  30.663  1.00 19.28           C  
ATOM   1627  N   ASP A 204       9.046  -1.325  30.400  1.00 21.47           N  
ATOM   1628  CA  ASP A 204      10.225  -2.132  30.132  1.00 23.25           C  
ATOM   1629  C   ASP A 204      10.000  -2.861  28.812  1.00 22.87           C  
ATOM   1630  O   ASP A 204       9.438  -3.954  28.780  1.00 23.36           O  
ATOM   1631  CB  ASP A 204      10.448  -3.124  31.277  1.00 25.58           C  
ATOM   1632  CG  ASP A 204      11.695  -3.965  31.088  1.00 30.18           C  
ATOM   1633  OD1 ASP A 204      12.678  -3.459  30.512  1.00 32.25           O  
ATOM   1634  OD2 ASP A 204      11.695  -5.129  31.534  1.00 34.97           O  
ATOM   1635  N   ASP A 205      10.434  -2.237  27.723  1.00 21.75           N  
ATOM   1636  CA  ASP A 205      10.259  -2.809  26.394  1.00 22.31           C  
ATOM   1637  C   ASP A 205      11.571  -3.145  25.717  1.00 21.25           C  
ATOM   1638  O   ASP A 205      12.553  -2.421  25.857  1.00 22.34           O  
ATOM   1639  CB  ASP A 205       9.507  -1.842  25.484  1.00 25.00           C  
ATOM   1640  CG  ASP A 205       8.131  -1.495  26.002  1.00 27.83           C  
ATOM   1641  OD1 ASP A 205       7.444  -2.399  26.519  1.00 31.47           O  
ATOM   1642  OD2 ASP A 205       7.740  -0.318  25.873  1.00 29.96           O  
ATOM   1643  N   GLU A 206      11.571  -4.239  24.966  1.00 21.14           N  
ATOM   1644  CA  GLU A 206      12.754  -4.645  24.228  1.00 22.87           C  
ATOM   1645  C   GLU A 206      12.663  -3.987  22.857  1.00 21.34           C  
ATOM   1646  O   GLU A 206      11.686  -4.188  22.131  1.00 22.75           O  
ATOM   1647  CB  GLU A 206      12.795  -6.163  24.059  1.00 26.70           C  
ATOM   1648  CG  GLU A 206      14.014  -6.634  23.280  1.00 33.06           C  
ATOM   1649  CD  GLU A 206      14.028  -8.133  23.056  1.00 36.66           C  
ATOM   1650  OE1 GLU A 206      13.192  -8.627  22.273  1.00 38.56           O  
ATOM   1651  OE2 GLU A 206      14.880  -8.815  23.665  1.00 39.61           O  
ATOM   1652  N   LEU A 207      13.667  -3.196  22.505  1.00 20.37           N  
ATOM   1653  CA  LEU A 207      13.666  -2.513  21.219  1.00 20.71           C  
ATOM   1654  C   LEU A 207      14.830  -2.969  20.358  1.00 21.79           C  
ATOM   1655  O   LEU A 207      15.806  -3.527  20.859  1.00 21.15           O  
ATOM   1656  CB  LEU A 207      13.728  -0.997  21.428  1.00 20.25           C  
ATOM   1657  CG  LEU A 207      12.555  -0.430  22.235  1.00 21.49           C  
ATOM   1658  CD1 LEU A 207      12.755   1.061  22.446  1.00 24.44           C  
ATOM   1659  CD2 LEU A 207      11.243  -0.699  21.503  1.00 21.17           C  
ATOM   1660  N   ASN A 208      14.719  -2.715  19.060  1.00 20.26           N  
ATOM   1661  CA  ASN A 208      15.736  -3.110  18.094  1.00 21.20           C  
ATOM   1662  C   ASN A 208      16.444  -1.889  17.525  1.00 21.98           C  
ATOM   1663  O   ASN A 208      15.805  -0.891  17.191  1.00 23.37           O  
ATOM   1664  CB  ASN A 208      15.066  -3.908  16.978  1.00 20.82           C  
ATOM   1665  CG  ASN A 208      14.438  -5.187  17.487  1.00 20.24           C  
ATOM   1666  OD1 ASN A 208      15.106  -6.213  17.605  1.00 20.70           O  
ATOM   1667  ND2 ASN A 208      13.152  -5.126  17.816  1.00 21.01           N  
ATOM   1668  N   ILE A 209      17.765  -1.979  17.417  1.00 21.70           N  
ATOM   1669  CA  ILE A 209      18.585  -0.885  16.910  1.00 21.07           C  
ATOM   1670  C   ILE A 209      18.922  -1.064  15.432  1.00 21.63           C  
ATOM   1671  O   ILE A 209      19.464  -2.098  15.030  1.00 20.33           O  
ATOM   1672  CB  ILE A 209      19.905  -0.790  17.699  1.00 24.01           C  
ATOM   1673  CG1 ILE A 209      19.605  -0.688  19.196  1.00 25.66           C  
ATOM   1674  CG2 ILE A 209      20.710   0.416  17.222  1.00 24.08           C  
ATOM   1675  CD1 ILE A 209      20.841  -0.821  20.080  1.00 27.74           C  
ATOM   1676  N   TYR A 210      18.616  -0.039  14.640  1.00 21.97           N  
ATOM   1677  CA  TYR A 210      18.860  -0.052  13.201  1.00 23.42           C  
ATOM   1678  C   TYR A 210      19.555   1.225  12.746  1.00 24.08           C  
ATOM   1679  O   TYR A 210      19.322   2.296  13.306  1.00 25.11           O  
ATOM   1680  CB  TYR A 210      17.537  -0.138  12.438  1.00 23.03           C  
ATOM   1681  CG  TYR A 210      16.751  -1.412  12.619  1.00 20.84           C  
ATOM   1682  CD1 TYR A 210      17.145  -2.592  11.994  1.00 21.69           C  
ATOM   1683  CD2 TYR A 210      15.584  -1.427  13.384  1.00 22.30           C  
ATOM   1684  CE1 TYR A 210      16.392  -3.756  12.116  1.00 19.28           C  
ATOM   1685  CE2 TYR A 210      14.827  -2.583  13.517  1.00 19.60           C  
ATOM   1686  CZ  TYR A 210      15.238  -3.744  12.879  1.00 20.88           C  
ATOM   1687  OH  TYR A 210      14.496  -4.890  13.018  1.00 20.50           O  
ATOM   1688  N   THR A 211      20.393   1.111  11.721  1.00 23.42           N  
ATOM   1689  CA  THR A 211      21.062   2.279  11.163  1.00 23.32           C  
ATOM   1690  C   THR A 211      20.219   2.679   9.961  1.00 22.01           C  
ATOM   1691  O   THR A 211      19.387   1.898   9.498  1.00 21.48           O  
ATOM   1692  CB  THR A 211      22.470   1.953  10.657  1.00 24.33           C  
ATOM   1693  OG1 THR A 211      22.383   0.967   9.620  1.00 24.68           O  
ATOM   1694  CG2 THR A 211      23.342   1.436  11.804  1.00 23.53           C  
ATOM   1695  N   PRO A 212      20.411   3.898   9.447  1.00 22.34           N  
ATOM   1696  CA  PRO A 212      19.630   4.337   8.286  1.00 24.24           C  
ATOM   1697  C   PRO A 212      19.857   3.420   7.086  1.00 25.55           C  
ATOM   1698  O   PRO A 212      18.919   3.068   6.373  1.00 25.61           O  
ATOM   1699  CB  PRO A 212      20.148   5.749   8.041  1.00 23.30           C  
ATOM   1700  CG  PRO A 212      20.464   6.218   9.426  1.00 24.52           C  
ATOM   1701  CD  PRO A 212      21.168   5.024  10.022  1.00 21.04           C  
ATOM   1702  N   ARG A 213      21.109   3.030   6.874  1.00 25.75           N  
ATOM   1703  CA  ARG A 213      21.437   2.158   5.754  1.00 26.65           C  
ATOM   1704  C   ARG A 213      20.762   0.796   5.890  1.00 24.12           C  
ATOM   1705  O   ARG A 213      20.327   0.215   4.897  1.00 24.71           O  
ATOM   1706  CB  ARG A 213      22.953   1.992   5.643  1.00 29.79           C  
ATOM   1707  CG  ARG A 213      23.403   1.175   4.438  1.00 33.21           C  
ATOM   1708  CD  ARG A 213      24.909   1.270   4.289  1.00 35.95           C  
ATOM   1709  NE  ARG A 213      25.319   2.657   4.101  1.00 36.32           N  
ATOM   1710  CZ  ARG A 213      26.478   3.160   4.512  1.00 35.52           C  
ATOM   1711  NH1 ARG A 213      27.356   2.391   5.142  1.00 33.25           N  
ATOM   1712  NH2 ARG A 213      26.753   4.438   4.298  1.00 35.38           N  
ATOM   1713  N   GLU A 214      20.672   0.292   7.118  1.00 23.44           N  
ATOM   1714  CA  GLU A 214      20.026  -0.995   7.369  1.00 23.99           C  
ATOM   1715  C   GLU A 214      18.566  -0.950   6.951  1.00 24.57           C  
ATOM   1716  O   GLU A 214      18.074  -1.839   6.258  1.00 22.88           O  
ATOM   1717  CB  GLU A 214      20.065  -1.349   8.851  1.00 25.65           C  
ATOM   1718  CG  GLU A 214      21.343  -1.947   9.354  1.00 30.18           C  
ATOM   1719  CD  GLU A 214      21.269  -2.194  10.843  1.00 28.97           C  
ATOM   1720  OE1 GLU A 214      22.110  -2.928  11.372  1.00 34.60           O  
ATOM   1721  OE2 GLU A 214      20.359  -1.646  11.489  1.00 32.78           O  
ATOM   1722  N   VAL A 215      17.864   0.082   7.401  1.00 24.07           N  
ATOM   1723  CA  VAL A 215      16.456   0.214   7.061  1.00 25.37           C  
ATOM   1724  C   VAL A 215      16.280   0.326   5.550  1.00 24.92           C  
ATOM   1725  O   VAL A 215      15.378  -0.293   4.986  1.00 27.69           O  
ATOM   1726  CB  VAL A 215      15.827   1.434   7.752  1.00 24.25           C  
ATOM   1727  CG1 VAL A 215      14.328   1.487   7.445  1.00 26.16           C  
ATOM   1728  CG2 VAL A 215      16.040   1.335   9.262  1.00 22.35           C  
ATOM   1729  N   ARG A 216      17.139   1.100   4.892  1.00 25.62           N  
ATOM   1730  CA  ARG A 216      17.046   1.248   3.442  1.00 26.97           C  
ATOM   1731  C   ARG A 216      17.236  -0.095   2.741  1.00 27.04           C  
ATOM   1732  O   ARG A 216      16.477  -0.441   1.831  1.00 26.77           O  
ATOM   1733  CB  ARG A 216      18.074   2.259   2.919  1.00 29.17           C  
ATOM   1734  CG  ARG A 216      18.130   2.310   1.394  1.00 34.25           C  
ATOM   1735  CD  ARG A 216      18.956   3.472   0.854  1.00 38.03           C  
ATOM   1736  NE  ARG A 216      20.359   3.409   1.248  1.00 42.73           N  
ATOM   1737  CZ  ARG A 216      21.180   2.402   0.965  1.00 44.49           C  
ATOM   1738  NH1 ARG A 216      20.746   1.353   0.278  1.00 46.67           N  
ATOM   1739  NH2 ARG A 216      22.439   2.448   1.368  1.00 45.28           N  
ATOM   1740  N   LEU A 217      18.242  -0.857   3.167  1.00 25.69           N  
ATOM   1741  CA  LEU A 217      18.514  -2.167   2.578  1.00 24.30           C  
ATOM   1742  C   LEU A 217      17.336  -3.113   2.772  1.00 24.90           C  
ATOM   1743  O   LEU A 217      17.024  -3.924   1.898  1.00 24.37           O  
ATOM   1744  CB  LEU A 217      19.763  -2.795   3.210  1.00 25.01           C  
ATOM   1745  CG  LEU A 217      21.115  -2.144   2.924  1.00 25.52           C  
ATOM   1746  CD1 LEU A 217      22.180  -2.808   3.789  1.00 24.70           C  
ATOM   1747  CD2 LEU A 217      21.457  -2.280   1.441  1.00 29.05           C  
ATOM   1748  N   LEU A 218      16.683  -3.022   3.925  1.00 22.53           N  
ATOM   1749  CA  LEU A 218      15.542  -3.884   4.193  1.00 24.23           C  
ATOM   1750  C   LEU A 218      14.312  -3.416   3.416  1.00 22.96           C  
ATOM   1751  O   LEU A 218      13.504  -4.230   2.981  1.00 26.59           O  
ATOM   1752  CB  LEU A 218      15.243  -3.909   5.695  1.00 22.52           C  
ATOM   1753  CG  LEU A 218      16.318  -4.584   6.555  1.00 24.23           C  
ATOM   1754  CD1 LEU A 218      16.106  -4.245   8.022  1.00 24.94           C  
ATOM   1755  CD2 LEU A 218      16.275  -6.086   6.332  1.00 24.84           C  
ATOM   1756  N   ALA A 219      14.191  -2.105   3.230  1.00 23.80           N  
ATOM   1757  CA  ALA A 219      13.051  -1.516   2.522  1.00 24.91           C  
ATOM   1758  C   ALA A 219      13.128  -1.595   0.996  1.00 26.24           C  
ATOM   1759  O   ALA A 219      12.104  -1.768   0.331  1.00 24.41           O  
ATOM   1760  CB  ALA A 219      12.883  -0.067   2.944  1.00 22.92           C  
ATOM   1761  N   GLU A 220      14.329  -1.456   0.438  1.00 27.42           N  
ATOM   1762  CA  GLU A 220      14.492  -1.501  -1.017  1.00 29.46           C  
ATOM   1763  C   GLU A 220      13.997  -2.815  -1.604  1.00 29.18           C  
ATOM   1764  O   GLU A 220      13.754  -2.917  -2.803  1.00 31.40           O  
ATOM   1765  CB  GLU A 220      15.958  -1.279  -1.408  1.00 30.30           C  
ATOM   1766  CG  GLU A 220      16.489   0.096  -1.032  1.00 33.89           C  
ATOM   1767  CD  GLU A 220      17.909   0.337  -1.516  1.00 35.94           C  
ATOM   1768  OE1 GLU A 220      18.726  -0.609  -1.457  1.00 35.39           O  
ATOM   1769  OE2 GLU A 220      18.205   1.476  -1.939  1.00 35.50           O  
ATOM   1770  N   LYS A 221      13.842  -3.818  -0.753  1.00 29.59           N  
ATOM   1771  CA  LYS A 221      13.372  -5.119  -1.196  1.00 30.24           C  
ATOM   1772  C   LYS A 221      11.860  -5.109  -1.453  1.00 30.80           C  
ATOM   1773  O   LYS A 221      11.331  -6.030  -2.075  1.00 32.32           O  
ATOM   1774  CB  LYS A 221      13.701  -6.168  -0.131  1.00 34.07           C  
ATOM   1775  CG  LYS A 221      15.161  -6.165   0.337  1.00 33.91           C  
ATOM   1776  CD  LYS A 221      15.389  -7.196   1.441  1.00 36.99           C  
ATOM   1777  CE  LYS A 221      16.860  -7.282   1.839  1.00 39.15           C  
ATOM   1778  NZ  LYS A 221      17.734  -7.675   0.693  1.00 41.46           N  
ATOM   1779  N   TYR A 222      11.173  -4.060  -1.003  1.00 28.09           N  
ATOM   1780  CA  TYR A 222       9.715  -3.990  -1.140  1.00 26.75           C  
ATOM   1781  C   TYR A 222       9.146  -2.765  -1.852  1.00 26.16           C  
ATOM   1782  O   TYR A 222       7.971  -2.749  -2.218  1.00 26.09           O  
ATOM   1783  CB  TYR A 222       9.089  -4.108   0.251  1.00 24.42           C  
ATOM   1784  CG  TYR A 222       9.511  -5.363   0.972  1.00 24.81           C  
ATOM   1785  CD1 TYR A 222       8.957  -6.597   0.641  1.00 24.62           C  
ATOM   1786  CD2 TYR A 222      10.515  -5.330   1.945  1.00 25.55           C  
ATOM   1787  CE1 TYR A 222       9.389  -7.764   1.251  1.00 26.50           C  
ATOM   1788  CE2 TYR A 222      10.956  -6.497   2.564  1.00 26.01           C  
ATOM   1789  CZ  TYR A 222      10.389  -7.710   2.211  1.00 27.78           C  
ATOM   1790  OH  TYR A 222      10.815  -8.873   2.811  1.00 28.85           O  
ATOM   1791  N   PHE A 223       9.967  -1.738  -2.034  1.00 25.56           N  
ATOM   1792  CA  PHE A 223       9.537  -0.518  -2.710  1.00 26.40           C  
ATOM   1793  C   PHE A 223      10.475  -0.270  -3.880  1.00 28.84           C  
ATOM   1794  O   PHE A 223      11.666  -0.573  -3.795  1.00 30.57           O  
ATOM   1795  CB  PHE A 223       9.603   0.665  -1.746  1.00 24.18           C  
ATOM   1796  CG  PHE A 223       8.799   0.465  -0.500  1.00 24.81           C  
ATOM   1797  CD1 PHE A 223       7.438   0.753  -0.481  1.00 21.77           C  
ATOM   1798  CD2 PHE A 223       9.395  -0.048   0.651  1.00 22.69           C  
ATOM   1799  CE1 PHE A 223       6.679   0.534   0.664  1.00 20.59           C  
ATOM   1800  CE2 PHE A 223       8.641  -0.275   1.808  1.00 20.82           C  
ATOM   1801  CZ  PHE A 223       7.281   0.017   1.812  1.00 23.38           C  
ATOM   1802  N   GLU A 224       9.951   0.286  -4.966  1.00 28.53           N  
ATOM   1803  CA  GLU A 224      10.794   0.551  -6.123  1.00 30.61           C  
ATOM   1804  C   GLU A 224      11.933   1.487  -5.763  1.00 30.01           C  
ATOM   1805  O   GLU A 224      13.075   1.283  -6.177  1.00 28.88           O  
ATOM   1806  CB  GLU A 224       9.999   1.178  -7.259  1.00 33.52           C  
ATOM   1807  CG  GLU A 224      10.843   1.336  -8.512  1.00 38.65           C  
ATOM   1808  CD  GLU A 224      10.088   1.957  -9.654  1.00 40.82           C  
ATOM   1809  OE1 GLU A 224       9.613   3.101  -9.496  1.00 42.77           O  
ATOM   1810  OE2 GLU A 224       9.972   1.299 -10.709  1.00 45.19           O  
ATOM   1811  N   LYS A 225      11.615   2.525  -4.998  1.00 27.83           N  
ATOM   1812  CA  LYS A 225      12.624   3.483  -4.586  1.00 29.20           C  
ATOM   1813  C   LYS A 225      12.488   3.819  -3.112  1.00 28.27           C  
ATOM   1814  O   LYS A 225      11.378   3.948  -2.589  1.00 25.91           O  
ATOM   1815  CB  LYS A 225      12.518   4.762  -5.415  1.00 31.95           C  
ATOM   1816  CG  LYS A 225      13.610   5.767  -5.098  1.00 38.02           C  
ATOM   1817  CD  LYS A 225      13.702   6.859  -6.142  1.00 41.17           C  
ATOM   1818  CE  LYS A 225      14.925   7.722  -5.889  1.00 43.79           C  
ATOM   1819  NZ  LYS A 225      16.165   6.894  -5.811  1.00 46.49           N  
ATOM   1820  N   VAL A 226      13.628   3.955  -2.443  1.00 25.16           N  
ATOM   1821  CA  VAL A 226      13.638   4.286  -1.026  1.00 25.26           C  
ATOM   1822  C   VAL A 226      14.537   5.488  -0.820  1.00 26.32           C  
ATOM   1823  O   VAL A 226      15.609   5.589  -1.423  1.00 27.49           O  
ATOM   1824  CB  VAL A 226      14.170   3.115  -0.169  1.00 24.98           C  
ATOM   1825  CG1 VAL A 226      14.295   3.549   1.286  1.00 24.66           C  
ATOM   1826  CG2 VAL A 226      13.233   1.931  -0.266  1.00 24.25           C  
ATOM   1827  N   LYS A 227      14.086   6.417   0.010  1.00 22.52           N  
ATOM   1828  CA  LYS A 227      14.866   7.599   0.300  1.00 23.94           C  
ATOM   1829  C   LYS A 227      15.069   7.702   1.803  1.00 23.81           C  
ATOM   1830  O   LYS A 227      14.244   7.228   2.585  1.00 21.30           O  
ATOM   1831  CB  LYS A 227      14.152   8.844  -0.224  1.00 28.59           C  
ATOM   1832  CG  LYS A 227      14.016   8.858  -1.742  1.00 32.98           C  
ATOM   1833  CD  LYS A 227      13.386  10.143  -2.228  1.00 39.56           C  
ATOM   1834  CE  LYS A 227      13.569  10.309  -3.728  1.00 42.03           C  
ATOM   1835  NZ  LYS A 227      14.937   9.917  -4.181  1.00 45.41           N  
ATOM   1836  N   ILE A 228      16.190   8.293   2.195  1.00 22.76           N  
ATOM   1837  CA  ILE A 228      16.499   8.489   3.604  1.00 20.24           C  
ATOM   1838  C   ILE A 228      16.672   9.986   3.781  1.00 21.28           C  
ATOM   1839  O   ILE A 228      17.522  10.597   3.130  1.00 19.63           O  
ATOM   1840  CB  ILE A 228      17.816   7.779   4.004  1.00 22.49           C  
ATOM   1841  CG1 ILE A 228      17.711   6.283   3.708  1.00 22.58           C  
ATOM   1842  CG2 ILE A 228      18.097   7.995   5.493  1.00 20.03           C  
ATOM   1843  CD1 ILE A 228      18.987   5.509   3.998  1.00 28.66           C  
ATOM   1844  N   TYR A 229      15.847  10.582   4.637  1.00 18.81           N  
ATOM   1845  CA  TYR A 229      15.919  12.016   4.893  1.00 19.23           C  
ATOM   1846  C   TYR A 229      16.206  12.232   6.369  1.00 18.92           C  
ATOM   1847  O   TYR A 229      16.107  11.305   7.170  1.00 19.47           O  
ATOM   1848  CB  TYR A 229      14.591  12.713   4.555  1.00 20.25           C  
ATOM   1849  CG  TYR A 229      14.162  12.641   3.104  1.00 22.45           C  
ATOM   1850  CD1 TYR A 229      15.075  12.852   2.071  1.00 22.76           C  
ATOM   1851  CD2 TYR A 229      12.828  12.408   2.767  1.00 23.52           C  
ATOM   1852  CE1 TYR A 229      14.670  12.833   0.738  1.00 25.21           C  
ATOM   1853  CE2 TYR A 229      12.408  12.389   1.438  1.00 24.42           C  
ATOM   1854  CZ  TYR A 229      13.333  12.602   0.428  1.00 26.29           C  
ATOM   1855  OH  TYR A 229      12.925  12.580  -0.885  1.00 26.40           O  
ATOM   1856  N   GLY A 230      16.558  13.460   6.723  1.00 22.10           N  
ATOM   1857  CA  GLY A 230      16.832  13.765   8.112  1.00 23.66           C  
ATOM   1858  C   GLY A 230      16.394  15.157   8.519  1.00 25.48           C  
ATOM   1859  O   GLY A 230      16.309  16.062   7.690  1.00 27.18           O  
ATOM   1860  N   ASN A 231      16.095  15.321   9.802  1.00 28.02           N  
ATOM   1861  CA  ASN A 231      15.704  16.618  10.357  1.00 31.15           C  
ATOM   1862  C   ASN A 231      14.695  17.465   9.570  1.00 31.73           C  
ATOM   1863  O   ASN A 231      14.950  18.636   9.270  1.00 34.28           O  
ATOM   1864  CB  ASN A 231      16.967  17.443  10.614  1.00 33.51           C  
ATOM   1865  CG  ASN A 231      17.800  16.890  11.758  1.00 35.17           C  
ATOM   1866  OD1 ASN A 231      17.752  15.696  12.061  1.00 35.80           O  
ATOM   1867  ND2 ASN A 231      18.579  17.759  12.391  1.00 39.35           N  
ATOM   1868  N   LEU A 232      13.552  16.871   9.247  1.00 30.69           N  
ATOM   1869  CA  LEU A 232      12.475  17.558   8.534  1.00 26.83           C  
ATOM   1870  C   LEU A 232      12.837  18.247   7.223  1.00 27.08           C  
ATOM   1871  O   LEU A 232      12.288  19.299   6.897  1.00 24.78           O  
ATOM   1872  CB  LEU A 232      11.804  18.568   9.468  1.00 27.15           C  
ATOM   1873  CG  LEU A 232      11.306  17.990  10.794  1.00 25.24           C  
ATOM   1874  CD1 LEU A 232      10.588  19.074  11.584  1.00 26.65           C  
ATOM   1875  CD2 LEU A 232      10.374  16.812  10.529  1.00 25.70           C  
ATOM   1876  N   LYS A 233      13.750  17.647   6.467  1.00 25.97           N  
ATOM   1877  CA  LYS A 233      14.149  18.192   5.177  1.00 27.44           C  
ATOM   1878  C   LYS A 233      14.289  17.025   4.221  1.00 26.00           C  
ATOM   1879  O   LYS A 233      14.690  15.938   4.632  1.00 24.38           O  
ATOM   1880  CB  LYS A 233      15.490  18.928   5.281  1.00 30.87           C  
ATOM   1881  CG  LYS A 233      15.460  20.176   6.149  1.00 36.07           C  
ATOM   1882  CD  LYS A 233      16.822  20.860   6.166  1.00 39.74           C  
ATOM   1883  CE  LYS A 233      16.791  22.127   7.009  1.00 44.38           C  
ATOM   1884  NZ  LYS A 233      15.790  23.116   6.506  1.00 46.11           N  
ATOM   1885  N   ARG A 234      13.945  17.238   2.954  1.00 25.16           N  
ATOM   1886  CA  ARG A 234      14.067  16.173   1.973  1.00 27.79           C  
ATOM   1887  C   ARG A 234      15.520  16.061   1.515  1.00 30.45           C  
ATOM   1888  O   ARG A 234      15.835  16.123   0.323  1.00 30.06           O  
ATOM   1889  CB  ARG A 234      13.128  16.419   0.786  1.00 27.56           C  
ATOM   1890  CG  ARG A 234      11.661  16.242   1.158  1.00 28.49           C  
ATOM   1891  CD  ARG A 234      10.721  16.407  -0.033  1.00 26.79           C  
ATOM   1892  NE  ARG A 234      10.973  15.428  -1.085  1.00 26.76           N  
ATOM   1893  CZ  ARG A 234      11.583  15.708  -2.232  1.00 28.51           C  
ATOM   1894  NH1 ARG A 234      12.008  16.941  -2.473  1.00 30.17           N  
ATOM   1895  NH2 ARG A 234      11.762  14.761  -3.140  1.00 29.79           N  
ATOM   1896  N   GLU A 235      16.396  15.900   2.499  1.00 31.11           N  
ATOM   1897  CA  GLU A 235      17.827  15.746   2.275  1.00 32.78           C  
ATOM   1898  C   GLU A 235      18.390  15.089   3.530  1.00 31.91           C  
ATOM   1899  O   GLU A 235      17.698  14.989   4.546  1.00 29.87           O  
ATOM   1900  CB  GLU A 235      18.489  17.111   2.038  1.00 34.37           C  
ATOM   1901  CG  GLU A 235      18.283  18.120   3.157  1.00 40.18           C  
ATOM   1902  CD  GLU A 235      18.901  19.480   2.849  1.00 44.01           C  
ATOM   1903  OE1 GLU A 235      18.531  20.089   1.822  1.00 45.97           O  
ATOM   1904  OE2 GLU A 235      19.755  19.942   3.636  1.00 46.19           O  
ATOM   1905  N   LEU A 236      19.632  14.626   3.459  1.00 31.03           N  
ATOM   1906  CA  LEU A 236      20.263  13.992   4.608  1.00 30.80           C  
ATOM   1907  C   LEU A 236      21.605  14.664   4.854  1.00 31.85           C  
ATOM   1908  O   LEU A 236      22.457  14.691   3.973  1.00 32.65           O  
ATOM   1909  CB  LEU A 236      20.474  12.498   4.351  1.00 29.03           C  
ATOM   1910  CG  LEU A 236      21.061  11.670   5.500  1.00 28.82           C  
ATOM   1911  CD1 LEU A 236      20.061  11.597   6.650  1.00 28.59           C  
ATOM   1912  CD2 LEU A 236      21.393  10.267   5.006  1.00 27.15           C  
ATOM   1913  N   SER A 237      21.779  15.225   6.045  1.00 31.93           N  
ATOM   1914  CA  SER A 237      23.028  15.884   6.394  1.00 31.93           C  
ATOM   1915  C   SER A 237      23.805  14.990   7.353  1.00 30.11           C  
ATOM   1916  O   SER A 237      23.218  14.274   8.165  1.00 28.10           O  
ATOM   1917  CB  SER A 237      22.753  17.245   7.038  1.00 33.86           C  
ATOM   1918  OG  SER A 237      22.075  18.098   6.130  1.00 39.83           O  
ATOM   1919  N   PRO A 238      25.143  15.027   7.270  1.00 31.39           N  
ATOM   1920  CA  PRO A 238      26.054  14.233   8.102  1.00 30.81           C  
ATOM   1921  C   PRO A 238      25.695  14.100   9.577  1.00 31.10           C  
ATOM   1922  O   PRO A 238      25.754  13.005  10.137  1.00 32.10           O  
ATOM   1923  CB  PRO A 238      27.396  14.933   7.899  1.00 31.26           C  
ATOM   1924  CG  PRO A 238      27.320  15.344   6.467  1.00 32.92           C  
ATOM   1925  CD  PRO A 238      25.907  15.908   6.363  1.00 30.70           C  
ATOM   1926  N   ASN A 239      25.310  15.206  10.204  1.00 30.97           N  
ATOM   1927  CA  ASN A 239      24.998  15.177  11.624  1.00 32.41           C  
ATOM   1928  C   ASN A 239      23.530  15.067  12.039  1.00 32.72           C  
ATOM   1929  O   ASN A 239      23.218  15.222  13.220  1.00 33.58           O  
ATOM   1930  CB  ASN A 239      25.648  16.386  12.301  1.00 35.10           C  
ATOM   1931  CG  ASN A 239      27.158  16.422  12.091  1.00 37.17           C  
ATOM   1932  OD1 ASN A 239      27.868  15.479  12.444  1.00 38.59           O  
ATOM   1933  ND2 ASN A 239      27.649  17.508  11.506  1.00 37.28           N  
ATOM   1934  N   ASP A 240      22.632  14.789  11.095  1.00 30.18           N  
ATOM   1935  CA  ASP A 240      21.216  14.648  11.445  1.00 29.33           C  
ATOM   1936  C   ASP A 240      21.074  13.539  12.484  1.00 28.30           C  
ATOM   1937  O   ASP A 240      21.802  12.545  12.435  1.00 27.76           O  
ATOM   1938  CB  ASP A 240      20.368  14.296  10.216  1.00 29.24           C  
ATOM   1939  CG  ASP A 240      20.313  15.420   9.193  1.00 30.58           C  
ATOM   1940  OD1 ASP A 240      20.488  16.598   9.575  1.00 29.98           O  
ATOM   1941  OD2 ASP A 240      20.074  15.124   8.002  1.00 30.33           O  
ATOM   1942  N   MET A 241      20.135  13.702  13.414  1.00 27.47           N  
ATOM   1943  CA  MET A 241      19.929  12.710  14.466  1.00 29.46           C  
ATOM   1944  C   MET A 241      18.592  11.973  14.435  1.00 27.46           C  
ATOM   1945  O   MET A 241      18.390  11.020  15.185  1.00 27.22           O  
ATOM   1946  CB  MET A 241      20.144  13.348  15.844  1.00 33.36           C  
ATOM   1947  CG  MET A 241      21.615  13.556  16.199  1.00 38.15           C  
ATOM   1948  SD  MET A 241      22.564  11.999  16.217  1.00 42.25           S  
ATOM   1949  CE  MET A 241      22.204  11.397  17.872  1.00 41.53           C  
ATOM   1950  N   ARG A 242      17.664  12.423  13.596  1.00 26.06           N  
ATOM   1951  CA  ARG A 242      16.391  11.720  13.459  1.00 25.36           C  
ATOM   1952  C   ARG A 242      16.247  11.454  11.968  1.00 22.81           C  
ATOM   1953  O   ARG A 242      16.495  12.331  11.145  1.00 23.15           O  
ATOM   1954  CB  ARG A 242      15.211  12.540  13.982  1.00 28.90           C  
ATOM   1955  CG  ARG A 242      13.888  11.767  13.897  1.00 32.16           C  
ATOM   1956  CD  ARG A 242      12.886  12.240  14.937  1.00 36.54           C  
ATOM   1957  NE  ARG A 242      12.464  13.618  14.717  1.00 38.36           N  
ATOM   1958  CZ  ARG A 242      11.302  13.968  14.175  1.00 38.60           C  
ATOM   1959  NH1 ARG A 242      10.435  13.036  13.798  1.00 37.90           N  
ATOM   1960  NH2 ARG A 242      11.005  15.251  14.019  1.00 35.60           N  
ATOM   1961  N   TYR A 243      15.860  10.236  11.620  1.00 21.41           N  
ATOM   1962  CA  TYR A 243      15.758   9.868  10.220  1.00 19.70           C  
ATOM   1963  C   TYR A 243      14.360   9.520   9.761  1.00 20.68           C  
ATOM   1964  O   TYR A 243      13.506   9.130  10.558  1.00 21.08           O  
ATOM   1965  CB  TYR A 243      16.681   8.680   9.952  1.00 19.54           C  
ATOM   1966  CG  TYR A 243      18.040   8.882  10.575  1.00 21.01           C  
ATOM   1967  CD1 TYR A 243      18.881   9.892  10.127  1.00 21.29           C  
ATOM   1968  CD2 TYR A 243      18.442   8.121  11.673  1.00 21.87           C  
ATOM   1969  CE1 TYR A 243      20.097  10.156  10.761  1.00 24.65           C  
ATOM   1970  CE2 TYR A 243      19.656   8.375  12.318  1.00 24.51           C  
ATOM   1971  CZ  TYR A 243      20.473   9.398  11.857  1.00 24.44           C  
ATOM   1972  OH  TYR A 243      21.647   9.692  12.512  1.00 25.33           O  
ATOM   1973  N   TRP A 244      14.148   9.676   8.462  1.00 19.15           N  
ATOM   1974  CA  TRP A 244      12.880   9.345   7.839  1.00 19.98           C  
ATOM   1975  C   TRP A 244      13.170   8.445   6.659  1.00 19.48           C  
ATOM   1976  O   TRP A 244      14.029   8.758   5.834  1.00 23.34           O  
ATOM   1977  CB  TRP A 244      12.169  10.593   7.325  1.00 19.01           C  
ATOM   1978  CG  TRP A 244      11.758  11.531   8.390  1.00 21.66           C  
ATOM   1979  CD1 TRP A 244      12.541  12.458   9.017  1.00 20.66           C  
ATOM   1980  CD2 TRP A 244      10.462  11.632   8.977  1.00 22.52           C  
ATOM   1981  NE1 TRP A 244      11.805  13.135   9.961  1.00 22.52           N  
ATOM   1982  CE2 TRP A 244      10.525  12.647   9.959  1.00 22.58           C  
ATOM   1983  CE3 TRP A 244       9.249  10.962   8.773  1.00 23.22           C  
ATOM   1984  CZ2 TRP A 244       9.420  13.009  10.734  1.00 24.41           C  
ATOM   1985  CZ3 TRP A 244       8.150  11.323   9.547  1.00 24.19           C  
ATOM   1986  CH2 TRP A 244       8.246  12.337  10.514  1.00 23.25           C  
ATOM   1987  N   ILE A 245      12.474   7.317   6.596  1.00 19.09           N  
ATOM   1988  CA  ILE A 245      12.616   6.407   5.477  1.00 20.56           C  
ATOM   1989  C   ILE A 245      11.339   6.589   4.664  1.00 20.14           C  
ATOM   1990  O   ILE A 245      10.237   6.546   5.212  1.00 17.36           O  
ATOM   1991  CB  ILE A 245      12.723   4.938   5.930  1.00 23.27           C  
ATOM   1992  CG1 ILE A 245      14.042   4.716   6.679  1.00 27.28           C  
ATOM   1993  CG2 ILE A 245      12.643   4.015   4.722  1.00 27.46           C  
ATOM   1994  CD1 ILE A 245      15.281   4.948   5.840  1.00 29.23           C  
ATOM   1995  N   VAL A 246      11.495   6.830   3.371  1.00 19.22           N  
ATOM   1996  CA  VAL A 246      10.353   7.013   2.491  1.00 18.82           C  
ATOM   1997  C   VAL A 246      10.411   5.960   1.399  1.00 20.34           C  
ATOM   1998  O   VAL A 246      11.373   5.898   0.629  1.00 21.43           O  
ATOM   1999  CB  VAL A 246      10.357   8.417   1.849  1.00 19.32           C  
ATOM   2000  CG1 VAL A 246       9.209   8.539   0.843  1.00 18.65           C  
ATOM   2001  CG2 VAL A 246      10.243   9.479   2.933  1.00 18.00           C  
ATOM   2002  N   GLY A 247       9.392   5.112   1.359  1.00 18.23           N  
ATOM   2003  CA  GLY A 247       9.334   4.074   0.348  1.00 19.90           C  
ATOM   2004  C   GLY A 247       8.303   4.465  -0.690  1.00 21.69           C  
ATOM   2005  O   GLY A 247       7.169   4.799  -0.340  1.00 18.69           O  
ATOM   2006  N   ILE A 248       8.688   4.426  -1.963  1.00 20.67           N  
ATOM   2007  CA  ILE A 248       7.775   4.793  -3.044  1.00 21.93           C  
ATOM   2008  C   ILE A 248       7.417   3.559  -3.871  1.00 23.70           C  
ATOM   2009  O   ILE A 248       8.293   2.890  -4.431  1.00 24.09           O  
ATOM   2010  CB  ILE A 248       8.411   5.845  -3.974  1.00 23.69           C  
ATOM   2011  CG1 ILE A 248       8.968   6.998  -3.140  1.00 24.56           C  
ATOM   2012  CG2 ILE A 248       7.366   6.365  -4.963  1.00 22.48           C  
ATOM   2013  CD1 ILE A 248       9.918   7.903  -3.896  1.00 29.99           C  
ATOM   2014  N   ALA A 249       6.127   3.253  -3.939  1.00 22.15           N  
ATOM   2015  CA  ALA A 249       5.667   2.096  -4.693  1.00 24.22           C  
ATOM   2016  C   ALA A 249       5.768   2.353  -6.196  1.00 25.27           C  
ATOM   2017  O   ALA A 249       5.586   3.482  -6.650  1.00 24.20           O  
ATOM   2018  CB  ALA A 249       4.231   1.769  -4.310  1.00 23.33           C  
ATOM   2019  N   LYS A 250       6.068   1.307  -6.961  1.00 29.67           N  
ATOM   2020  CA  LYS A 250       6.173   1.417  -8.417  1.00 32.44           C  
ATOM   2021  C   LYS A 250       4.855   1.946  -8.975  1.00 33.40           C  
ATOM   2022  O   LYS A 250       3.786   1.577  -8.493  1.00 33.10           O  
ATOM   2023  CB  LYS A 250       6.454   0.045  -9.040  1.00 35.55           C  
ATOM   2024  CG  LYS A 250       7.863  -0.479  -8.832  1.00 40.23           C  
ATOM   2025  CD  LYS A 250       8.071  -1.843  -9.494  1.00 43.68           C  
ATOM   2026  CE  LYS A 250       7.453  -2.970  -8.676  1.00 45.70           C  
ATOM   2027  NZ  LYS A 250       8.108  -3.100  -7.338  1.00 45.93           N  
ATOM   2028  N   SER A 251       4.923   2.807  -9.985  1.00 35.01           N  
ATOM   2029  CA  SER A 251       3.701   3.343 -10.575  1.00 39.01           C  
ATOM   2030  C   SER A 251       3.585   3.030 -12.066  1.00 40.95           C  
ATOM   2031  O   SER A 251       4.628   2.760 -12.703  1.00 41.39           O  
ATOM   2032  CB  SER A 251       3.618   4.857 -10.347  1.00 39.50           C  
ATOM   2033  OG  SER A 251       4.760   5.529 -10.845  1.00 42.43           O  
TER    2034      SER A 251                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
