
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  212 ( 1769),  selected  212 , name 1ve3_A
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 1ve3_A.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     2_A      M       1           -
LGA    -       -      S       2           -
LGA    -       -      E       3           -
LGA    -       -      N       4           -
LGA    -       -      K       5           -
LGA    F     3_A      K       6          4.349
LGA    K     4_A      K       7          3.525
LGA    E     5_A      F       8           #
LGA    -       -      D       9           -
LGA    -       -      K      10           -
LGA    -       -      K      11           -
LGA    Y     6_A      G      12          4.854
LGA    Y     7_A      A      13          4.655
LGA    R     8_A      K      14          3.879
LGA    V     9_A      N      15          3.850
LGA    -       -      M      16           -
LGA    -       -      D      17           -
LGA    F    10_A      E      18          6.057
LGA    P    11_A      I      19          1.779
LGA    T    12_A      -       -           -
LGA    Y    13_A      -       -           -
LGA    T    14_A      -       -           -
LGA    D    15_A      -       -           -
LGA    I    16_A      S      20           #
LGA    N    17_A      K      21          2.567
LGA    S    18_A      T      22          1.470
LGA    Q    19_A      L      23          3.057
LGA    E    20_A      F      24          2.210
LGA    Y    21_A      -       -           -
LGA    R    22_A      A      25          1.172
LGA    S    23_A      P      26          2.808
LGA    R    24_A      I      27          2.278
LGA    I    25_A      Y      28          1.022
LGA    E    26_A      P      29          3.694
LGA    T    27_A      I      30          3.680
LGA    L    28_A      I      31          1.500
LGA    E    29_A      A      32          2.825
LGA    P    30_A      E      33          2.831
LGA    L    31_A      N      34          1.386
LGA    L    32_A      I      35          1.057
LGA    X    33_A      I      36          1.506
LGA    K    34_A      N      37          1.515
LGA    Y    35_A      R      38          2.277
LGA    X    36_A      F      39          3.641
LGA    K    37_A      G      40          1.618
LGA    K    38_A      I      41          2.635
LGA    R    39_A      T      42          2.388
LGA    G    40_A      A      43          2.986
LGA    -       -      G      44           -
LGA    K    41_A      N      45          0.567
LGA    V    42_A      C      46          0.369
LGA    L    43_A      I      47          0.507
LGA    D    44_A      D      48          0.688
LGA    L    45_A      I      49          0.910
LGA    A    46_A      G      50          0.913
LGA    C    47_A      S      51          0.605
LGA    G    48_A      G      52          0.540
LGA    V    49_A      P      53          1.066
LGA    G    50_A      G      54          1.049
LGA    G    51_A      A      55          0.930
LGA    F    52_A      L      56          1.113
LGA    S    53_A      S      57          0.973
LGA    F    54_A      I      58          1.474
LGA    L    55_A      A      59          1.572
LGA    L    56_A      L      60          1.607
LGA    E    57_A      A      61          1.609
LGA    D    58_A      K      62          1.995
LGA    Y    59_A      Q      63          2.384
LGA    G    60_A      S      64          2.771
LGA    -       -      D      65           -
LGA    F    61_A      F      66          0.981
LGA    E    62_A      S      67          0.935
LGA    V    63_A      I      68          0.616
LGA    V    64_A      R      69          0.733
LGA    G    65_A      A      70          0.742
LGA    V    66_A      L      71          0.672
LGA    D    67_A      D      72          0.269
LGA    I    68_A      F      73          0.302
LGA    S    69_A      S      74          0.435
LGA    E    70_A      K      75          0.394
LGA    D    71_A      H      76          0.815
LGA    X    72_A      M      77          0.673
LGA    I    73_A      N      78          0.584
LGA    R    74_A      E      79          0.619
LGA    K    75_A      I      80          0.781
LGA    A    76_A      A      81          0.809
LGA    R    77_A      L      82          0.802
LGA    E    78_A      K      83          0.753
LGA    Y    79_A      N      84          1.073
LGA    A    80_A      I      85          1.348
LGA    K    81_A      A      86          1.162
LGA    S    82_A      D      87          1.144
LGA    R    83_A      A      88          1.264
LGA    E    84_A      D      89          1.320
LGA    S    85_A      L      90          0.872
LGA    N    86_A      N      91          2.976
LGA    -       -      D      92           -
LGA    -       -      R      93           -
LGA    V    87_A      I      94          0.945
LGA    E    88_A      Q      95          0.636
LGA    F    89_A      I      96          0.361
LGA    I    90_A      V      97          1.108
LGA    V    91_A      Q      98          0.624
LGA    G    92_A      G      99          0.556
LGA    D    93_A      D     100          0.755
LGA    A    94_A      V     101          0.824
LGA    R    95_A      H     102          0.699
LGA    K    96_A      N     103          0.541
LGA    L    97_A      I     104          0.833
LGA    S    98_A      P     105          1.882
LGA    F    99_A      I     106          1.181
LGA    E   100_A      E     107          1.115
LGA    D   101_A      D     108          0.566
LGA    K   102_A      N     109          0.385
LGA    T   103_A      Y     110          0.710
LGA    F   104_A      A     111          0.794
LGA    D   105_A      D     112          0.443
LGA    Y   106_A      L     113          0.629
LGA    V   107_A      I     114          0.663
LGA    I   108_A      V     115          0.494
LGA    F   109_A      S     116          1.376
LGA    I   110_A      R     117          1.068
LGA    D   111_A      G     118          1.130
LGA    S   112_A      S     119          0.991
LGA    I   113_A      V     120          1.956
LGA    V   114_A      F     121          2.490
LGA    H   115_A      F     122          1.370
LGA    F   116_A      W     123          1.441
LGA    E   117_A      E     124          3.277
LGA    P   118_A      -       -           -
LGA    L   119_A      -       -           -
LGA    E   120_A      D     125          1.534
LGA    L   121_A      V     126          1.398
LGA    N   122_A      T     127          1.203
LGA    Q   123_A      T     128          1.101
LGA    V   124_A      A     129          1.151
LGA    F   125_A      F     130          0.673
LGA    K   126_A      R     131          0.397
LGA    E   127_A      E     132          0.398
LGA    V   128_A      I     133          0.668
LGA    R   129_A      Y     134          0.491
LGA    R   130_A      R     135          0.433
LGA    V   131_A      I     136          0.580
LGA    L   132_A      L     137          0.622
LGA    K   133_A      K     138          0.638
LGA    P   134_A      S     139          1.049
LGA    S   135_A      G     140          0.937
LGA    G   136_A      G     141          0.625
LGA    K   137_A      K     142          0.653
LGA    F   138_A      T     143          1.228
LGA    I   139_A      Y     144          1.162
LGA    X   140_A      I     145          1.252
LGA    Y   141_A      G     146          2.268
LGA    F   142_A      G     147          2.969
LGA    T   143_A      G     148          6.187
LGA    D   144_A      F     149           -
LGA    L   145_A      G     150           -
LGA    R   146_A      N     151           -
LGA    E   147_A      K     152           -
LGA    -       -      E     153           -
LGA    -       -      L     154           -
LGA    -       -      R     155           -
LGA    -       -      D     156           -
LGA    -       -      S     157           -
LGA    -       -      I     158           -
LGA    -       -      S     159           -
LGA    -       -      A     160           -
LGA    -       -      E     161           -
LGA    -       -      M     162           -
LGA    -       -      I     163           -
LGA    -       -      R     164           -
LGA    -       -      K     165           -
LGA    -       -      N     166           -
LGA    -       -      P     167           -
LGA    -       -      D     168           -
LGA    -       -      W     169           -
LGA    -       -      K     170           -
LGA    -       -      E     171           -
LGA    -       -      F     172           -
LGA    L   148_A      N     173          5.582
LGA    L   149_A      R     174          4.876
LGA    P   150_A      -       -           -
LGA    R   151_A      -       -           -
LGA    L   152_A      -       -           -
LGA    K   153_A      -       -           -
LGA    E   154_A      -       -           -
LGA    I   164_A      -       -           -
LGA    S   165_A      -       -           -
LGA    K   166_A      -       -           -
LGA    V   167_A      -       -           -
LGA    I   168_A      -       -           -
LGA    P   169_A      -       -           -
LGA    D   170_A      -       -           -
LGA    Q   171_A      -       -           -
LGA    E   172_A      -       -           -
LGA    E   173_A      -       -           -
LGA    R   174_A      -       -           -
LGA    T   175_A      -       -           -
LGA    V   176_A      -       -           -
LGA    V   177_A      -       -           -
LGA    I   178_A      -       -           -
LGA    E   179_A      -       -           -
LGA    F   180_A      -       -           -
LGA    S   186_A      -       -           -
LGA    F   187_A      -       -           -
LGA    R   188_A      -       -           -
LGA    V   189_A      -       -           -
LGA    R   190_A      -       -           -
LGA    F   191_A      -       -           -
LGA    N   192_A      -       -           -
LGA    V   193_A      K     175          6.133
LGA    -       -      N     176           -
LGA    -       -      I     177           -
LGA    -       -      S     178           -
LGA    -       -      Q     179           -
LGA    W   194_A      E     180           #
LGA    G   195_A      N     181          2.272
LGA    K   196_A      V     182          1.758
LGA    T   197_A      E     183          0.825
LGA    G   198_A      R     184          0.385
LGA    V   199_A      F     185          1.637
LGA    E   200_A      Q     186          2.085
LGA    L   201_A      N     187          1.680
LGA    L   202_A      V     188          0.974
LGA    A   203_A      L     189          2.405
LGA    K   204_A      D     190          3.087
LGA    L   205_A      E     191          3.951
LGA    -       -      I     192           -
LGA    -       -      G     193           -
LGA    Y   206_A      V     194          3.096
LGA    F   207_A      S     195           #
LGA    T   208_A      S     196          1.731
LGA    K   209_A      Y     197          1.692
LGA    E   210_A      E     198           #
LGA    A   211_A      I     199           #
LGA    E   212_A      I     200          3.405
LGA    E   213_A      L     201           #
LGA    K   214_A      E     202          1.288
LGA    V   215_A      D     203          2.260
LGA    G   216_A      E     204          5.582
LGA    N   217_A      -       -           -
LGA    Y   218_A      -       -           -
LGA    S   219_A      G     205          2.922
LGA    Y   220_A      F     206          1.659
LGA    L   221_A      W     207          2.867
LGA    T   222_A      I     208          3.518
LGA    V   223_A      I     209          2.232
LGA    Y   224_A      I     210          1.565
LGA    N   225_A      S     211          0.474
LGA    P   226_A      K     212          2.210
LGA    K   227_A      T     213          4.735
LGA    -       -      D     214           -
LGA    -       -      Q     215           -
LGA    -       -      E     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  212  218    5.0    162    2.13    15.43     63.779     7.267

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.787468 * X  +  -0.467773 * Y  +   0.401351 * Z  +  -6.481673
  Y_new =  -0.519055 * X  +   0.854443 * Y  +  -0.022558 * Z  +  11.457892
  Z_new =  -0.332380 * X  +  -0.226087 * Y  +  -0.915646 * Z  + 109.908745 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.899519    0.242073  [ DEG:  -166.1302     13.8698 ]
  Theta =   0.338826    2.802767  [ DEG:    19.4133    160.5867 ]
  Phi   =  -2.558816    0.582777  [ DEG:  -146.6094     33.3906 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ve3_A                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ve3_A.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  212  218   5.0  162   2.13   15.43  63.779
REMARK  ---------------------------------------------------------- 
MOLECULE 1ve3_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   26-MAR-04   1VE3              
TITLE     CRYSTAL STRUCTURE OF PH0226 PROTEIN FROM PYROCOCCUS                   
TITLE    2 HORIKOSHII OT3                                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PH0226;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: METHYL TRANSFERASE, SAM DEPENDENT                           
COMPND   5 METHYLTRANSFERASE;                                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    DIMER, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,               
KEYWDS   2 RSGI, STRUCTURAL GENOMICS, UNKNOWN FUNCTION, NPPSFA,                 
KEYWDS   3 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   4 ANALYSES                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.K.LOKANATH,H.YAMAMOTO,N.KUNISHIMA,RIKEN STRUCTURAL                  
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   13-MAY-08 1VE3    1       REMARK VERSN                             
REVDAT   1   24-MAY-05 1VE3    0                                                
JRNL        AUTH   N.K.LOKANATH,H.YAMAMOTO,N.KUNISHIMA                          
JRNL        TITL   CRYSTAL STRUCTURE OF PH0226 PROTEIN FROM                     
JRNL        TITL 2 PYROCOCCUS HORIKOSHII OT3                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  1VE3 A    1   227  UNP    O57965   O57965_PYRHO     1    227             
DBREF  1VE3 B    1   227  UNP    O57965   O57965_PYRHO     1    227             
SEQRES   1 A  227  MSE GLY PHE LYS GLU TYR TYR ARG VAL PHE PRO THR TYR          
SEQRES   2 A  227  THR ASP ILE ASN SER GLN GLU TYR ARG SER ARG ILE GLU          
SEQRES   3 A  227  THR LEU GLU PRO LEU LEU MSE LYS TYR MSE LYS LYS ARG          
SEQRES   4 A  227  GLY LYS VAL LEU ASP LEU ALA CYS GLY VAL GLY GLY PHE          
SEQRES   5 A  227  SER PHE LEU LEU GLU ASP TYR GLY PHE GLU VAL VAL GLY          
SEQRES   6 A  227  VAL ASP ILE SER GLU ASP MSE ILE ARG LYS ALA ARG GLU          
SEQRES   7 A  227  TYR ALA LYS SER ARG GLU SER ASN VAL GLU PHE ILE VAL          
SEQRES   8 A  227  GLY ASP ALA ARG LYS LEU SER PHE GLU ASP LYS THR PHE          
SEQRES   9 A  227  ASP TYR VAL ILE PHE ILE ASP SER ILE VAL HIS PHE GLU          
SEQRES  10 A  227  PRO LEU GLU LEU ASN GLN VAL PHE LYS GLU VAL ARG ARG          
SEQRES  11 A  227  VAL LEU LYS PRO SER GLY LYS PHE ILE MSE TYR PHE THR          
SEQRES  12 A  227  ASP LEU ARG GLU LEU LEU PRO ARG LEU LYS GLU SER LEU          
SEQRES  13 A  227  VAL VAL GLY GLN LYS TYR TRP ILE SER LYS VAL ILE PRO          
SEQRES  14 A  227  ASP GLN GLU GLU ARG THR VAL VAL ILE GLU PHE LYS SER          
SEQRES  15 A  227  GLU GLN ASP SER PHE ARG VAL ARG PHE ASN VAL TRP GLY          
SEQRES  16 A  227  LYS THR GLY VAL GLU LEU LEU ALA LYS LEU TYR PHE THR          
SEQRES  17 A  227  LYS GLU ALA GLU GLU LYS VAL GLY ASN TYR SER TYR LEU          
SEQRES  18 A  227  THR VAL TYR ASN PRO LYS                                      
SEQRES   1 B  227  MSE GLY PHE LYS GLU TYR TYR ARG VAL PHE PRO THR TYR          
SEQRES   2 B  227  THR ASP ILE ASN SER GLN GLU TYR ARG SER ARG ILE GLU          
SEQRES   3 B  227  THR LEU GLU PRO LEU LEU MSE LYS TYR MSE LYS LYS ARG          
SEQRES   4 B  227  GLY LYS VAL LEU ASP LEU ALA CYS GLY VAL GLY GLY PHE          
SEQRES   5 B  227  SER PHE LEU LEU GLU ASP TYR GLY PHE GLU VAL VAL GLY          
SEQRES   6 B  227  VAL ASP ILE SER GLU ASP MSE ILE ARG LYS ALA ARG GLU          
SEQRES   7 B  227  TYR ALA LYS SER ARG GLU SER ASN VAL GLU PHE ILE VAL          
SEQRES   8 B  227  GLY ASP ALA ARG LYS LEU SER PHE GLU ASP LYS THR PHE          
SEQRES   9 B  227  ASP TYR VAL ILE PHE ILE ASP SER ILE VAL HIS PHE GLU          
SEQRES  10 B  227  PRO LEU GLU LEU ASN GLN VAL PHE LYS GLU VAL ARG ARG          
SEQRES  11 B  227  VAL LEU LYS PRO SER GLY LYS PHE ILE MSE TYR PHE THR          
SEQRES  12 B  227  ASP LEU ARG GLU LEU LEU PRO ARG LEU LYS GLU SER LEU          
SEQRES  13 B  227  VAL VAL GLY GLN LYS TYR TRP ILE SER LYS VAL ILE PRO          
SEQRES  14 B  227  ASP GLN GLU GLU ARG THR VAL VAL ILE GLU PHE LYS SER          
SEQRES  15 B  227  GLU GLN ASP SER PHE ARG VAL ARG PHE ASN VAL TRP GLY          
SEQRES  16 B  227  LYS THR GLY VAL GLU LEU LEU ALA LYS LEU TYR PHE THR          
SEQRES  17 B  227  LYS GLU ALA GLU GLU LYS VAL GLY ASN TYR SER TYR LEU          
SEQRES  18 B  227  THR VAL TYR ASN PRO LYS                                      
HET    MSE  A  33       8                                                       
HET    MSE  A  36       8                                                       
HET    MSE  A  72       8                                                       
HET    MSE  A 140       8                                                       
HET    MSE  B  33       8                                                       
HET    MSE  B  36       8                                                       
HET    MSE  B  72       8                                                       
HET    MSE  B 140       8                                                       
HET    SAM  A 302      27                                                       
HET    SAM  B 301      27                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  SAM    2(C15 H22 N6 O5 S)                                           
FORMUL   5  HOH   *178(H2 O)                                                    
CRYST1   58.167   58.167  252.463  90.00  90.00 120.00 P 32 2 1     12          
ATOM      1  N   GLY A   2       8.243  -0.791  23.841  1.00 46.66           N  
ATOM      2  CA  GLY A   2       7.504   0.026  24.845  1.00 46.93           C  
ATOM      3  C   GLY A   2       6.391  -0.784  25.474  1.00 47.57           C  
ATOM      4  O   GLY A   2       6.115  -1.894  25.022  1.00 48.03           O  
ATOM      5  N   PHE A   3       5.755  -0.247  26.515  1.00 48.47           N  
ATOM      6  CA  PHE A   3       4.666  -0.963  27.169  1.00 47.16           C  
ATOM      7  C   PHE A   3       3.680  -0.106  27.982  1.00 45.64           C  
ATOM      8  O   PHE A   3       3.829   1.114  28.086  1.00 40.92           O  
ATOM      9  CB  PHE A   3       5.235  -2.103  28.031  1.00 49.54           C  
ATOM     10  CG  PHE A   3       5.865  -1.662  29.331  1.00 51.63           C  
ATOM     11  CD1 PHE A   3       6.049  -0.320  29.634  1.00 52.05           C  
ATOM     12  CD2 PHE A   3       6.274  -2.619  30.260  1.00 53.06           C  
ATOM     13  CE1 PHE A   3       6.626   0.062  30.839  1.00 53.99           C  
ATOM     14  CE2 PHE A   3       6.854  -2.249  31.466  1.00 52.80           C  
ATOM     15  CZ  PHE A   3       7.030  -0.906  31.758  1.00 55.28           C  
ATOM     16  N   LYS A   4       2.679  -0.776  28.551  1.00 44.56           N  
ATOM     17  CA  LYS A   4       1.621  -0.139  29.339  1.00 44.34           C  
ATOM     18  C   LYS A   4       2.042   0.973  30.306  1.00 42.41           C  
ATOM     19  O   LYS A   4       1.562   2.098  30.202  1.00 40.84           O  
ATOM     20  CB  LYS A   4       0.835  -1.215  30.100  1.00 47.01           C  
ATOM     21  CG  LYS A   4      -0.371  -0.697  30.879  1.00 48.54           C  
ATOM     22  CD  LYS A   4      -1.114  -1.840  31.560  1.00 49.88           C  
ATOM     23  CE  LYS A   4      -2.143  -1.329  32.565  1.00 50.32           C  
ATOM     24  NZ  LYS A   4      -3.223  -0.521  31.931  1.00 50.32           N  
ATOM     25  N   GLU A   5       2.926   0.670  31.249  1.00 42.61           N  
ATOM     26  CA  GLU A   5       3.357   1.684  32.213  1.00 41.85           C  
ATOM     27  C   GLU A   5       4.083   2.847  31.553  1.00 39.90           C  
ATOM     28  O   GLU A   5       3.856   4.011  31.878  1.00 37.35           O  
ATOM     29  CB  GLU A   5       4.254   1.056  33.278  1.00 44.98           C  
ATOM     30  CG  GLU A   5       4.876   2.060  34.226  1.00 49.93           C  
ATOM     31  CD  GLU A   5       5.075   1.493  35.618  1.00 52.50           C  
ATOM     32  OE1 GLU A   5       5.604   0.366  35.735  1.00 53.32           O  
ATOM     33  OE2 GLU A   5       4.705   2.183  36.595  1.00 53.79           O  
ATOM     34  N   TYR A   6       4.971   2.527  30.628  1.00 37.65           N  
ATOM     35  CA  TYR A   6       5.724   3.540  29.910  1.00 39.04           C  
ATOM     36  C   TYR A   6       4.806   4.571  29.272  1.00 37.73           C  
ATOM     37  O   TYR A   6       5.095   5.762  29.298  1.00 39.31           O  
ATOM     38  CB  TYR A   6       6.556   2.857  28.827  1.00 38.74           C  
ATOM     39  CG  TYR A   6       7.288   3.781  27.893  1.00 39.06           C  
ATOM     40  CD1 TYR A   6       8.409   4.492  28.318  1.00 38.33           C  
ATOM     41  CD2 TYR A   6       6.896   3.898  26.556  1.00 39.66           C  
ATOM     42  CE1 TYR A   6       9.128   5.291  27.431  1.00 39.22           C  
ATOM     43  CE2 TYR A   6       7.606   4.695  25.670  1.00 39.40           C  
ATOM     44  CZ  TYR A   6       8.721   5.380  26.104  1.00 39.16           C  
ATOM     45  OH  TYR A   6       9.469   6.107  25.205  1.00 36.86           O  
ATOM     46  N   TYR A   7       3.716   4.099  28.680  1.00 36.20           N  
ATOM     47  CA  TYR A   7       2.776   4.995  28.022  1.00 36.83           C  
ATOM     48  C   TYR A   7       1.850   5.710  29.005  1.00 39.19           C  
ATOM     49  O   TYR A   7       1.473   6.858  28.778  1.00 40.74           O  
ATOM     50  CB  TYR A   7       1.961   4.232  26.969  1.00 32.75           C  
ATOM     51  CG  TYR A   7       2.776   3.859  25.746  1.00 32.29           C  
ATOM     52  CD1 TYR A   7       3.443   4.836  25.010  1.00 30.67           C  
ATOM     53  CD2 TYR A   7       2.898   2.531  25.339  1.00 30.82           C  
ATOM     54  CE1 TYR A   7       4.219   4.497  23.894  1.00 33.77           C  
ATOM     55  CE2 TYR A   7       3.668   2.184  24.226  1.00 31.86           C  
ATOM     56  CZ  TYR A   7       4.326   3.173  23.510  1.00 30.92           C  
ATOM     57  OH  TYR A   7       5.093   2.842  22.420  1.00 31.19           O  
ATOM     58  N   ARG A   8       1.496   5.044  30.098  1.00 41.20           N  
ATOM     59  CA  ARG A   8       0.631   5.651  31.110  1.00 42.82           C  
ATOM     60  C   ARG A   8       1.363   6.801  31.803  1.00 42.97           C  
ATOM     61  O   ARG A   8       0.777   7.845  32.089  1.00 43.85           O  
ATOM     62  CB  ARG A   8       0.210   4.603  32.149  1.00 43.29           C  
ATOM     63  CG  ARG A   8      -0.616   5.164  33.302  1.00 46.69           C  
ATOM     64  CD  ARG A   8      -1.161   4.063  34.216  1.00 49.28           C  
ATOM     65  NE  ARG A   8      -0.107   3.226  34.787  1.00 50.38           N  
ATOM     66  CZ  ARG A   8       0.833   3.658  35.621  1.00 52.30           C  
ATOM     67  NH1 ARG A   8       0.859   4.930  35.996  1.00 53.38           N  
ATOM     68  NH2 ARG A   8       1.761   2.818  36.068  1.00 52.81           N  
ATOM     69  N   VAL A   9       2.652   6.599  32.055  1.00 43.90           N  
ATOM     70  CA  VAL A   9       3.485   7.595  32.715  1.00 45.04           C  
ATOM     71  C   VAL A   9       3.814   8.841  31.883  1.00 45.22           C  
ATOM     72  O   VAL A   9       3.753   9.959  32.397  1.00 44.40           O  
ATOM     73  CB  VAL A   9       4.805   6.958  33.201  1.00 46.16           C  
ATOM     74  CG1 VAL A   9       5.836   8.035  33.497  1.00 46.94           C  
ATOM     75  CG2 VAL A   9       4.544   6.128  34.451  1.00 47.41           C  
ATOM     76  N   PHE A  10       4.172   8.655  30.613  1.00 44.50           N  
ATOM     77  CA  PHE A  10       4.515   9.794  29.755  1.00 43.14           C  
ATOM     78  C   PHE A  10       3.385  10.197  28.809  1.00 39.94           C  
ATOM     79  O   PHE A  10       2.678   9.348  28.274  1.00 40.85           O  
ATOM     80  CB  PHE A  10       5.778   9.494  28.946  1.00 44.65           C  
ATOM     81  CG  PHE A  10       6.951   9.104  29.789  1.00 47.32           C  
ATOM     82  CD1 PHE A  10       7.232   7.761  30.035  1.00 48.88           C  
ATOM     83  CD2 PHE A  10       7.759  10.076  30.369  1.00 48.64           C  
ATOM     84  CE1 PHE A  10       8.301   7.391  30.846  1.00 48.53           C  
ATOM     85  CE2 PHE A  10       8.831   9.720  31.184  1.00 50.16           C  
ATOM     86  CZ  PHE A  10       9.102   8.372  31.424  1.00 50.92           C  
ATOM     87  N   PRO A  11       3.207  11.513  28.595  1.00 36.54           N  
ATOM     88  CA  PRO A  11       2.165  12.051  27.721  1.00 33.97           C  
ATOM     89  C   PRO A  11       2.541  12.118  26.246  1.00 32.95           C  
ATOM     90  O   PRO A  11       1.666  12.221  25.382  1.00 33.28           O  
ATOM     91  CB  PRO A  11       1.931  13.436  28.305  1.00 35.38           C  
ATOM     92  CG  PRO A  11       3.322  13.852  28.665  1.00 35.63           C  
ATOM     93  CD  PRO A  11       3.871  12.601  29.337  1.00 36.09           C  
ATOM     94  N   THR A  12       3.840  12.059  25.968  1.00 30.88           N  
ATOM     95  CA  THR A  12       4.370  12.146  24.607  1.00 31.97           C  
ATOM     96  C   THR A  12       3.592  11.406  23.519  1.00 30.07           C  
ATOM     97  O   THR A  12       3.445  11.905  22.409  1.00 30.63           O  
ATOM     98  CB  THR A  12       5.827  11.646  24.554  1.00 31.84           C  
ATOM     99  OG1 THR A  12       6.554  12.192  25.660  1.00 36.10           O  
ATOM    100  CG2 THR A  12       6.491  12.092  23.263  1.00 31.93           C  
ATOM    101  N   TYR A  13       3.079  10.225  23.828  1.00 29.02           N  
ATOM    102  CA  TYR A  13       2.363   9.468  22.817  1.00 29.25           C  
ATOM    103  C   TYR A  13       0.908   9.183  23.175  1.00 30.89           C  
ATOM    104  O   TYR A  13       0.202   8.501  22.424  1.00 29.48           O  
ATOM    105  CB  TYR A  13       3.108   8.157  22.561  1.00 30.09           C  
ATOM    106  CG  TYR A  13       4.589   8.351  22.289  1.00 29.63           C  
ATOM    107  CD1 TYR A  13       5.038   8.850  21.060  1.00 31.91           C  
ATOM    108  CD2 TYR A  13       5.538   8.019  23.253  1.00 29.49           C  
ATOM    109  CE1 TYR A  13       6.404   9.006  20.799  1.00 32.91           C  
ATOM    110  CE2 TYR A  13       6.902   8.173  23.007  1.00 31.49           C  
ATOM    111  CZ  TYR A  13       7.326   8.664  21.782  1.00 33.76           C  
ATOM    112  OH  TYR A  13       8.669   8.808  21.544  1.00 35.67           O  
ATOM    113  N   THR A  14       0.449   9.720  24.303  1.00 29.94           N  
ATOM    114  CA  THR A  14      -0.920   9.464  24.728  1.00 32.29           C  
ATOM    115  C   THR A  14      -1.782  10.682  25.019  1.00 30.76           C  
ATOM    116  O   THR A  14      -3.000  10.570  25.034  1.00 30.36           O  
ATOM    117  CB  THR A  14      -0.941   8.540  25.960  1.00 32.74           C  
ATOM    118  OG1 THR A  14      -0.120   9.101  26.994  1.00 35.08           O  
ATOM    119  CG2 THR A  14      -0.406   7.165  25.589  1.00 33.26           C  
ATOM    120  N   ASP A  15      -1.162  11.840  25.227  1.00 32.05           N  
ATOM    121  CA  ASP A  15      -1.913  13.060  25.519  1.00 32.15           C  
ATOM    122  C   ASP A  15      -1.752  14.085  24.402  1.00 32.50           C  
ATOM    123  O   ASP A  15      -0.860  14.934  24.440  1.00 31.15           O  
ATOM    124  CB  ASP A  15      -1.446  13.658  26.850  1.00 33.29           C  
ATOM    125  CG  ASP A  15      -2.256  14.875  27.260  1.00 32.50           C  
ATOM    126  OD1 ASP A  15      -3.108  15.332  26.470  1.00 31.68           O  
ATOM    127  OD2 ASP A  15      -2.032  15.373  28.378  1.00 37.01           O  
ATOM    128  N   ILE A  16      -2.643  14.002  23.417  1.00 34.08           N  
ATOM    129  CA  ILE A  16      -2.625  14.877  22.248  1.00 35.16           C  
ATOM    130  C   ILE A  16      -2.552  16.364  22.558  1.00 34.00           C  
ATOM    131  O   ILE A  16      -2.094  17.139  21.725  1.00 35.16           O  
ATOM    132  CB  ILE A  16      -3.858  14.614  21.335  1.00 36.52           C  
ATOM    133  CG1 ILE A  16      -3.802  13.182  20.789  1.00 38.39           C  
ATOM    134  CG2 ILE A  16      -3.871  15.591  20.167  1.00 36.20           C  
ATOM    135  CD1 ILE A  16      -4.992  12.807  19.914  1.00 41.48           C  
ATOM    136  N   ASN A  17      -2.991  16.774  23.742  1.00 34.99           N  
ATOM    137  CA  ASN A  17      -2.935  18.196  24.088  1.00 36.06           C  
ATOM    138  C   ASN A  17      -1.729  18.592  24.943  1.00 35.82           C  
ATOM    139  O   ASN A  17      -1.568  19.764  25.288  1.00 35.48           O  
ATOM    140  CB  ASN A  17      -4.227  18.628  24.781  1.00 39.12           C  
ATOM    141  CG  ASN A  17      -5.410  18.646  23.835  1.00 41.73           C  
ATOM    142  OD1 ASN A  17      -5.374  19.300  22.791  1.00 43.71           O  
ATOM    143  ND2 ASN A  17      -6.468  17.927  24.195  1.00 41.44           N  
ATOM    144  N   SER A  18      -0.876  17.626  25.277  1.00 34.35           N  
ATOM    145  CA  SER A  18       0.310  17.929  26.069  1.00 32.43           C  
ATOM    146  C   SER A  18       1.317  18.674  25.205  1.00 32.70           C  
ATOM    147  O   SER A  18       1.264  18.606  23.971  1.00 31.00           O  
ATOM    148  CB  SER A  18       0.962  16.647  26.589  1.00 33.26           C  
ATOM    149  OG  SER A  18       1.555  15.901  25.536  1.00 33.78           O  
ATOM    150  N   GLN A  19       2.233  19.387  25.855  1.00 32.36           N  
ATOM    151  CA  GLN A  19       3.261  20.123  25.135  1.00 30.97           C  
ATOM    152  C   GLN A  19       4.186  19.119  24.440  1.00 30.49           C  
ATOM    153  O   GLN A  19       4.682  19.379  23.345  1.00 29.70           O  
ATOM    154  CB  GLN A  19       4.069  21.011  26.094  1.00 31.23           C  
ATOM    155  CG  GLN A  19       3.253  22.097  26.804  1.00 31.99           C  
ATOM    156  CD  GLN A  19       4.104  23.023  27.676  1.00 35.07           C  
ATOM    157  OE1 GLN A  19       5.270  22.742  27.961  1.00 34.74           O  
ATOM    158  NE2 GLN A  19       3.511  24.126  28.111  1.00 33.91           N  
ATOM    159  N   GLU A  20       4.404  17.969  25.076  1.00 29.34           N  
ATOM    160  CA  GLU A  20       5.274  16.935  24.509  1.00 31.71           C  
ATOM    161  C   GLU A  20       4.761  16.456  23.152  1.00 32.71           C  
ATOM    162  O   GLU A  20       5.507  16.428  22.170  1.00 31.55           O  
ATOM    163  CB  GLU A  20       5.383  15.727  25.451  1.00 31.27           C  
ATOM    164  CG  GLU A  20       6.229  15.941  26.708  1.00 33.47           C  
ATOM    165  CD  GLU A  20       5.552  16.829  27.746  1.00 35.42           C  
ATOM    166  OE1 GLU A  20       4.335  17.079  27.615  1.00 30.06           O  
ATOM    167  OE2 GLU A  20       6.239  17.262  28.703  1.00 35.17           O  
ATOM    168  N   TYR A  21       3.482  16.089  23.108  1.00 30.54           N  
ATOM    169  CA  TYR A  21       2.842  15.598  21.893  1.00 29.99           C  
ATOM    170  C   TYR A  21       2.773  16.678  20.807  1.00 31.08           C  
ATOM    171  O   TYR A  21       3.052  16.410  19.633  1.00 28.76           O  
ATOM    172  CB  TYR A  21       1.433  15.101  22.239  1.00 30.31           C  
ATOM    173  CG  TYR A  21       0.876  14.002  21.351  1.00 30.11           C  
ATOM    174  CD1 TYR A  21       0.636  14.218  19.995  1.00 30.52           C  
ATOM    175  CD2 TYR A  21       0.535  12.761  21.889  1.00 31.13           C  
ATOM    176  CE1 TYR A  21       0.058  13.220  19.192  1.00 31.03           C  
ATOM    177  CE2 TYR A  21      -0.038  11.759  21.102  1.00 31.54           C  
ATOM    178  CZ  TYR A  21      -0.275  11.995  19.757  1.00 31.94           C  
ATOM    179  OH  TYR A  21      -0.855  11.010  18.985  1.00 32.16           O  
ATOM    180  N   ARG A  22       2.401  17.897  21.197  1.00 31.70           N  
ATOM    181  CA  ARG A  22       2.295  18.999  20.244  1.00 33.24           C  
ATOM    182  C   ARG A  22       3.640  19.282  19.595  1.00 32.14           C  
ATOM    183  O   ARG A  22       3.714  19.578  18.404  1.00 30.66           O  
ATOM    184  CB  ARG A  22       1.776  20.261  20.933  1.00 36.34           C  
ATOM    185  CG  ARG A  22       0.321  20.168  21.363  1.00 43.29           C  
ATOM    186  CD  ARG A  22      -0.171  21.482  21.968  1.00 48.77           C  
ATOM    187  NE  ARG A  22      -1.620  21.468  22.155  1.00 53.43           N  
ATOM    188  CZ  ARG A  22      -2.340  22.516  22.544  1.00 55.84           C  
ATOM    189  NH1 ARG A  22      -1.748  23.676  22.796  1.00 55.96           N  
ATOM    190  NH2 ARG A  22      -3.656  22.402  22.678  1.00 56.37           N  
ATOM    191  N   SER A  23       4.698  19.188  20.392  1.00 32.55           N  
ATOM    192  CA  SER A  23       6.054  19.407  19.911  1.00 35.33           C  
ATOM    193  C   SER A  23       6.371  18.454  18.760  1.00 35.34           C  
ATOM    194  O   SER A  23       6.965  18.852  17.759  1.00 36.03           O  
ATOM    195  CB  SER A  23       7.055  19.185  21.046  1.00 37.50           C  
ATOM    196  OG  SER A  23       8.384  19.237  20.555  1.00 45.28           O  
ATOM    197  N   ARG A  24       5.972  17.193  18.913  1.00 35.15           N  
ATOM    198  CA  ARG A  24       6.208  16.180  17.892  1.00 35.82           C  
ATOM    199  C   ARG A  24       5.424  16.506  16.623  1.00 37.18           C  
ATOM    200  O   ARG A  24       5.950  16.409  15.513  1.00 36.33           O  
ATOM    201  CB  ARG A  24       5.803  14.807  18.422  1.00 35.58           C  
ATOM    202  CG  ARG A  24       6.614  14.352  19.634  1.00 35.84           C  
ATOM    203  CD  ARG A  24       5.978  13.138  20.276  1.00 37.55           C  
ATOM    204  NE  ARG A  24       5.827  12.070  19.307  1.00 38.57           N  
ATOM    205  CZ  ARG A  24       4.685  11.452  19.033  1.00 37.36           C  
ATOM    206  NH1 ARG A  24       3.560  11.777  19.658  1.00 36.53           N  
ATOM    207  NH2 ARG A  24       4.673  10.513  18.105  1.00 37.30           N  
ATOM    208  N   ILE A  25       4.166  16.900  16.791  1.00 37.52           N  
ATOM    209  CA  ILE A  25       3.329  17.246  15.653  1.00 40.35           C  
ATOM    210  C   ILE A  25       3.901  18.430  14.875  1.00 42.07           C  
ATOM    211  O   ILE A  25       4.136  18.342  13.670  1.00 42.30           O  
ATOM    212  CB  ILE A  25       1.885  17.586  16.108  1.00 41.63           C  
ATOM    213  CG1 ILE A  25       1.173  16.309  16.553  1.00 41.40           C  
ATOM    214  CG2 ILE A  25       1.118  18.265  14.984  1.00 40.75           C  
ATOM    215  CD1 ILE A  25      -0.242  16.525  17.049  1.00 42.25           C  
ATOM    216  N   GLU A  26       4.152  19.531  15.570  1.00 43.62           N  
ATOM    217  CA  GLU A  26       4.662  20.727  14.915  1.00 46.37           C  
ATOM    218  C   GLU A  26       6.051  20.558  14.305  1.00 46.50           C  
ATOM    219  O   GLU A  26       6.447  21.318  13.419  1.00 45.20           O  
ATOM    220  CB  GLU A  26       4.630  21.899  15.899  1.00 49.01           C  
ATOM    221  CG  GLU A  26       3.252  22.090  16.529  1.00 53.87           C  
ATOM    222  CD  GLU A  26       3.146  23.327  17.399  1.00 58.08           C  
ATOM    223  OE1 GLU A  26       4.076  23.587  18.197  1.00 60.27           O  
ATOM    224  OE2 GLU A  26       2.121  24.034  17.292  1.00 58.61           O  
ATOM    225  N   THR A  27       6.798  19.565  14.768  1.00 46.43           N  
ATOM    226  CA  THR A  27       8.121  19.341  14.209  1.00 46.71           C  
ATOM    227  C   THR A  27       7.985  18.603  12.876  1.00 45.91           C  
ATOM    228  O   THR A  27       8.640  18.948  11.895  1.00 45.53           O  
ATOM    229  CB  THR A  27       9.013  18.520  15.173  1.00 47.52           C  
ATOM    230  OG1 THR A  27       9.371  19.332  16.300  1.00 47.72           O  
ATOM    231  CG2 THR A  27      10.283  18.056  14.472  1.00 48.10           C  
ATOM    232  N   LEU A  28       7.111  17.604  12.840  1.00 45.89           N  
ATOM    233  CA  LEU A  28       6.902  16.814  11.629  1.00 46.41           C  
ATOM    234  C   LEU A  28       5.939  17.432  10.619  1.00 46.49           C  
ATOM    235  O   LEU A  28       6.103  17.243   9.417  1.00 45.30           O  
ATOM    236  CB  LEU A  28       6.416  15.406  11.996  1.00 44.30           C  
ATOM    237  CG  LEU A  28       7.424  14.557  12.771  1.00 44.90           C  
ATOM    238  CD1 LEU A  28       6.844  13.181  13.060  1.00 44.10           C  
ATOM    239  CD2 LEU A  28       8.702  14.431  11.952  1.00 44.98           C  
ATOM    240  N   GLU A  29       4.944  18.166  11.108  1.00 47.78           N  
ATOM    241  CA  GLU A  29       3.939  18.797  10.254  1.00 50.00           C  
ATOM    242  C   GLU A  29       4.461  19.392   8.940  1.00 49.51           C  
ATOM    243  O   GLU A  29       3.999  19.024   7.860  1.00 48.71           O  
ATOM    244  CB  GLU A  29       3.200  19.886  11.034  1.00 52.51           C  
ATOM    245  CG  GLU A  29       2.033  20.485  10.276  1.00 56.74           C  
ATOM    246  CD  GLU A  29       1.411  21.657  11.002  1.00 60.23           C  
ATOM    247  OE1 GLU A  29       1.164  21.538  12.224  1.00 60.57           O  
ATOM    248  OE2 GLU A  29       1.164  22.696  10.350  1.00 62.21           O  
ATOM    249  N   PRO A  30       5.428  20.320   9.013  1.00 49.36           N  
ATOM    250  CA  PRO A  30       5.974  20.934   7.799  1.00 49.96           C  
ATOM    251  C   PRO A  30       6.652  19.938   6.855  1.00 50.59           C  
ATOM    252  O   PRO A  30       6.595  20.081   5.634  1.00 49.87           O  
ATOM    253  CB  PRO A  30       6.947  21.970   8.351  1.00 49.70           C  
ATOM    254  CG  PRO A  30       7.429  21.326   9.613  1.00 50.56           C  
ATOM    255  CD  PRO A  30       6.145  20.799  10.207  1.00 49.28           C  
ATOM    256  N   LEU A  31       7.292  18.924   7.425  1.00 50.96           N  
ATOM    257  CA  LEU A  31       7.969  17.916   6.624  1.00 50.44           C  
ATOM    258  C   LEU A  31       6.960  17.005   5.928  1.00 50.67           C  
ATOM    259  O   LEU A  31       7.174  16.581   4.793  1.00 49.99           O  
ATOM    260  CB  LEU A  31       8.898  17.092   7.516  1.00 51.20           C  
ATOM    261  CG  LEU A  31       9.896  17.907   8.343  1.00 51.69           C  
ATOM    262  CD1 LEU A  31      10.795  16.970   9.123  1.00 51.45           C  
ATOM    263  CD2 LEU A  31      10.728  18.794   7.421  1.00 53.31           C  
ATOM    264  N   LEU A  32       5.855  16.713   6.609  1.00 50.84           N  
ATOM    265  CA  LEU A  32       4.823  15.851   6.050  1.00 51.63           C  
ATOM    266  C   LEU A  32       4.100  16.519   4.888  1.00 53.73           C  
ATOM    267  O   LEU A  32       3.666  15.853   3.947  1.00 53.54           O  
ATOM    268  CB  LEU A  32       3.815  15.456   7.133  1.00 49.74           C  
ATOM    269  CG  LEU A  32       4.327  14.502   8.219  1.00 49.03           C  
ATOM    270  CD1 LEU A  32       3.214  14.204   9.215  1.00 47.83           C  
ATOM    271  CD2 LEU A  32       4.823  13.214   7.583  1.00 46.38           C  
HETATM  272  N   MSE A  33       3.975  17.838   4.947  1.00 55.45           N  
HETATM  273  CA  MSE A  33       3.303  18.560   3.879  1.00 57.23           C  
HETATM  274  C   MSE A  33       4.215  18.750   2.678  1.00 54.77           C  
HETATM  275  O   MSE A  33       3.750  18.947   1.559  1.00 54.40           O  
HETATM  276  CB  MSE A  33       2.796  19.906   4.393  1.00 61.85           C  
HETATM  277  CG  MSE A  33       1.706  19.750   5.440  1.00 69.65           C  
HETATM  278 SE   MSE A  33       0.424  18.371   4.931  1.00 80.47          SE  
HETATM  279  CE  MSE A  33       1.029  16.943   6.074  1.00 76.52           C  
ATOM    280  N   LYS A  34       5.518  18.673   2.916  1.00 52.52           N  
ATOM    281  CA  LYS A  34       6.491  18.833   1.851  1.00 52.47           C  
ATOM    282  C   LYS A  34       6.442  17.641   0.904  1.00 52.18           C  
ATOM    283  O   LYS A  34       6.891  17.729  -0.239  1.00 54.09           O  
ATOM    284  CB  LYS A  34       7.896  18.968   2.445  1.00 52.60           C  
ATOM    285  CG  LYS A  34       9.013  19.115   1.424  1.00 52.18           C  
ATOM    286  CD  LYS A  34      10.335  19.391   2.123  1.00 52.90           C  
ATOM    287  CE  LYS A  34      11.479  19.512   1.136  1.00 53.17           C  
ATOM    288  NZ  LYS A  34      12.758  19.886   1.810  1.00 52.45           N  
ATOM    289  N   TYR A  35       5.882  16.531   1.375  1.00 49.47           N  
ATOM    290  CA  TYR A  35       5.803  15.325   0.561  1.00 47.85           C  
ATOM    291  C   TYR A  35       4.389  14.776   0.420  1.00 47.23           C  
ATOM    292  O   TYR A  35       4.186  13.694  -0.125  1.00 47.15           O  
ATOM    293  CB  TYR A  35       6.727  14.256   1.144  1.00 46.05           C  
ATOM    294  CG  TYR A  35       8.181  14.673   1.172  1.00 45.37           C  
ATOM    295  CD1 TYR A  35       8.878  14.908  -0.010  1.00 44.39           C  
ATOM    296  CD2 TYR A  35       8.858  14.835   2.377  1.00 44.91           C  
ATOM    297  CE1 TYR A  35      10.215  15.294   0.008  1.00 44.46           C  
ATOM    298  CE2 TYR A  35      10.194  15.221   2.405  1.00 45.26           C  
ATOM    299  CZ  TYR A  35      10.865  15.448   1.216  1.00 45.01           C  
ATOM    300  OH  TYR A  35      12.190  15.822   1.239  1.00 45.90           O  
HETATM  301  N   MSE A  36       3.412  15.526   0.911  1.00 47.32           N  
HETATM  302  CA  MSE A  36       2.021  15.100   0.826  1.00 48.40           C  
HETATM  303  C   MSE A  36       1.175  16.209   0.219  1.00 49.88           C  
HETATM  304  O   MSE A  36       0.099  16.539   0.721  1.00 50.21           O  
HETATM  305  CB  MSE A  36       1.491  14.735   2.215  1.00 46.50           C  
HETATM  306  CG  MSE A  36       2.167  13.517   2.834  1.00 45.92           C  
HETATM  307 SE   MSE A  36       1.530  13.090   4.620  1.00 44.22          SE  
HETATM  308  CE  MSE A  36      -0.133  12.233   4.169  1.00 39.25           C  
ATOM    309  N   LYS A  37       1.677  16.787  -0.866  1.00 51.71           N  
ATOM    310  CA  LYS A  37       0.973  17.864  -1.546  1.00 52.73           C  
ATOM    311  C   LYS A  37      -0.362  17.381  -2.101  1.00 52.22           C  
ATOM    312  O   LYS A  37      -1.383  18.046  -1.932  1.00 53.61           O  
ATOM    313  CB  LYS A  37       1.850  18.435  -2.661  1.00 54.58           C  
ATOM    314  CG  LYS A  37       3.100  19.144  -2.146  1.00 55.75           C  
ATOM    315  CD  LYS A  37       3.936  19.703  -3.289  1.00 58.55           C  
ATOM    316  CE  LYS A  37       5.080  20.572  -2.779  1.00 60.56           C  
ATOM    317  NZ  LYS A  37       6.020  19.834  -1.886  1.00 60.30           N  
ATOM    318  N   LYS A  38      -0.363  16.221  -2.750  1.00 51.83           N  
ATOM    319  CA  LYS A  38      -1.601  15.677  -3.299  1.00 51.31           C  
ATOM    320  C   LYS A  38      -2.394  14.941  -2.224  1.00 50.94           C  
ATOM    321  O   LYS A  38      -1.899  13.990  -1.617  1.00 51.12           O  
ATOM    322  CB  LYS A  38      -1.308  14.717  -4.454  1.00 52.86           C  
ATOM    323  CG  LYS A  38      -2.564  14.161  -5.114  1.00 52.88           C  
ATOM    324  CD  LYS A  38      -2.242  13.350  -6.359  1.00 54.75           C  
ATOM    325  CE  LYS A  38      -3.510  13.040  -7.151  1.00 55.58           C  
ATOM    326  NZ  LYS A  38      -3.248  12.300  -8.421  1.00 55.26           N  
ATOM    327  N   ARG A  39      -3.627  15.379  -1.991  1.00 49.25           N  
ATOM    328  CA  ARG A  39      -4.471  14.748  -0.987  1.00 49.18           C  
ATOM    329  C   ARG A  39      -4.849  13.358  -1.460  1.00 48.33           C  
ATOM    330  O   ARG A  39      -4.782  13.067  -2.655  1.00 49.21           O  
ATOM    331  CB  ARG A  39      -5.743  15.572  -0.746  1.00 48.48           C  
ATOM    332  CG  ARG A  39      -5.489  17.055  -0.506  1.00 50.70           C  
ATOM    333  CD  ARG A  39      -4.470  17.284   0.591  1.00 51.11           C  
ATOM    334  NE  ARG A  39      -4.099  18.690   0.708  1.00 54.17           N  
ATOM    335  CZ  ARG A  39      -3.098  19.143   1.457  1.00 54.24           C  
ATOM    336  NH1 ARG A  39      -2.360  18.299   2.164  1.00 56.46           N  
ATOM    337  NH2 ARG A  39      -2.828  20.438   1.495  1.00 55.05           N  
ATOM    338  N   GLY A  40      -5.247  12.505  -0.521  1.00 46.38           N  
ATOM    339  CA  GLY A  40      -5.633  11.152  -0.865  1.00 45.45           C  
ATOM    340  C   GLY A  40      -6.035  10.335   0.346  1.00 44.58           C  
ATOM    341  O   GLY A  40      -6.354  10.883   1.401  1.00 46.25           O  
ATOM    342  N   LYS A  41      -6.017   9.016   0.198  1.00 44.05           N  
ATOM    343  CA  LYS A  41      -6.386   8.112   1.284  1.00 43.08           C  
ATOM    344  C   LYS A  41      -5.133   7.761   2.095  1.00 42.80           C  
ATOM    345  O   LYS A  41      -4.173   7.195   1.563  1.00 41.70           O  
ATOM    346  CB  LYS A  41      -7.015   6.853   0.694  1.00 43.68           C  
ATOM    347  CG  LYS A  41      -7.870   6.063   1.652  1.00 46.85           C  
ATOM    348  CD  LYS A  41      -8.797   5.138   0.878  1.00 48.95           C  
ATOM    349  CE  LYS A  41      -9.790   4.440   1.792  1.00 49.87           C  
ATOM    350  NZ  LYS A  41     -10.845   3.746   1.002  1.00 50.54           N  
ATOM    351  N   VAL A  42      -5.146   8.096   3.383  1.00 41.42           N  
ATOM    352  CA  VAL A  42      -3.997   7.839   4.243  1.00 39.81           C  
ATOM    353  C   VAL A  42      -4.233   6.790   5.328  1.00 38.33           C  
ATOM    354  O   VAL A  42      -5.310   6.722   5.919  1.00 36.41           O  
ATOM    355  CB  VAL A  42      -3.532   9.137   4.942  1.00 41.09           C  
ATOM    356  CG1 VAL A  42      -2.240   8.887   5.700  1.00 42.44           C  
ATOM    357  CG2 VAL A  42      -3.348  10.245   3.916  1.00 41.25           C  
ATOM    358  N   LEU A  43      -3.213   5.972   5.578  1.00 36.23           N  
ATOM    359  CA  LEU A  43      -3.284   4.954   6.620  1.00 35.67           C  
ATOM    360  C   LEU A  43      -2.272   5.303   7.715  1.00 35.94           C  
ATOM    361  O   LEU A  43      -1.066   5.377   7.461  1.00 35.18           O  
ATOM    362  CB  LEU A  43      -2.964   3.565   6.062  1.00 32.26           C  
ATOM    363  CG  LEU A  43      -2.792   2.490   7.150  1.00 34.37           C  
ATOM    364  CD1 LEU A  43      -4.119   2.261   7.844  1.00 34.09           C  
ATOM    365  CD2 LEU A  43      -2.278   1.184   6.540  1.00 33.62           C  
ATOM    366  N   ASP A  44      -2.769   5.534   8.926  1.00 35.80           N  
ATOM    367  CA  ASP A  44      -1.907   5.860  10.060  1.00 36.01           C  
ATOM    368  C   ASP A  44      -1.627   4.541  10.787  1.00 34.22           C  
ATOM    369  O   ASP A  44      -2.369   4.143  11.686  1.00 34.80           O  
ATOM    370  CB  ASP A  44      -2.615   6.845  11.006  1.00 35.32           C  
ATOM    371  CG  ASP A  44      -1.674   7.447  12.035  1.00 36.74           C  
ATOM    372  OD1 ASP A  44      -0.530   6.961  12.153  1.00 34.52           O  
ATOM    373  OD2 ASP A  44      -2.077   8.405  12.733  1.00 38.19           O  
ATOM    374  N   LEU A  45      -0.558   3.865  10.383  1.00 32.63           N  
ATOM    375  CA  LEU A  45      -0.199   2.579  10.966  1.00 31.13           C  
ATOM    376  C   LEU A  45       0.434   2.764  12.348  1.00 29.89           C  
ATOM    377  O   LEU A  45       1.439   3.477  12.498  1.00 30.45           O  
ATOM    378  CB  LEU A  45       0.747   1.836  10.016  1.00 29.93           C  
ATOM    379  CG  LEU A  45       0.881   0.324  10.213  1.00 28.82           C  
ATOM    380  CD1 LEU A  45      -0.498  -0.316  10.292  1.00 29.56           C  
ATOM    381  CD2 LEU A  45       1.676  -0.261   9.061  1.00 30.58           C  
ATOM    382  N   ALA A  46      -0.150   2.101  13.346  1.00 27.34           N  
ATOM    383  CA  ALA A  46       0.300   2.226  14.734  1.00 27.19           C  
ATOM    384  C   ALA A  46       0.058   3.701  15.087  1.00 26.80           C  
ATOM    385  O   ALA A  46       0.983   4.424  15.455  1.00 22.88           O  
ATOM    386  CB  ALA A  46       1.799   1.869  14.855  1.00 23.68           C  
ATOM    387  N   CYS A  47      -1.203   4.126  14.959  1.00 26.92           N  
ATOM    388  CA  CYS A  47      -1.604   5.518  15.198  1.00 28.72           C  
ATOM    389  C   CYS A  47      -1.607   6.040  16.635  1.00 28.00           C  
ATOM    390  O   CYS A  47      -1.708   7.251  16.852  1.00 26.10           O  
ATOM    391  CB  CYS A  47      -2.994   5.764  14.602  1.00 28.67           C  
ATOM    392  SG  CYS A  47      -4.294   4.732  15.323  1.00 31.67           S  
ATOM    393  N   GLY A  48      -1.505   5.150  17.614  1.00 27.55           N  
ATOM    394  CA  GLY A  48      -1.518   5.609  18.990  1.00 28.10           C  
ATOM    395  C   GLY A  48      -2.862   6.244  19.297  1.00 29.84           C  
ATOM    396  O   GLY A  48      -3.908   5.652  19.015  1.00 31.43           O  
ATOM    397  N   VAL A  49      -2.853   7.453  19.849  1.00 29.60           N  
ATOM    398  CA  VAL A  49      -4.104   8.125  20.175  1.00 31.68           C  
ATOM    399  C   VAL A  49      -4.694   8.946  19.021  1.00 31.70           C  
ATOM    400  O   VAL A  49      -5.668   9.679  19.201  1.00 29.74           O  
ATOM    401  CB  VAL A  49      -3.957   8.999  21.468  1.00 31.02           C  
ATOM    402  CG1 VAL A  49      -3.692   8.087  22.666  1.00 31.56           C  
ATOM    403  CG2 VAL A  49      -2.831   9.992  21.323  1.00 32.18           C  
ATOM    404  N   GLY A  50      -4.098   8.810  17.837  1.00 33.01           N  
ATOM    405  CA  GLY A  50      -4.604   9.491  16.653  1.00 32.11           C  
ATOM    406  C   GLY A  50      -4.204  10.933  16.383  1.00 33.17           C  
ATOM    407  O   GLY A  50      -4.768  11.575  15.490  1.00 34.23           O  
ATOM    408  N   GLY A  51      -3.232  11.449  17.125  1.00 30.62           N  
ATOM    409  CA  GLY A  51      -2.810  12.818  16.912  1.00 31.96           C  
ATOM    410  C   GLY A  51      -2.463  13.192  15.475  1.00 34.04           C  
ATOM    411  O   GLY A  51      -2.914  14.223  14.968  1.00 32.08           O  
ATOM    412  N   PHE A  52      -1.659  12.372  14.803  1.00 31.49           N  
ATOM    413  CA  PHE A  52      -1.276  12.700  13.434  1.00 33.14           C  
ATOM    414  C   PHE A  52      -2.411  12.470  12.446  1.00 33.28           C  
ATOM    415  O   PHE A  52      -2.387  12.986  11.336  1.00 32.04           O  
ATOM    416  CB  PHE A  52      -0.018  11.917  13.037  1.00 30.76           C  
ATOM    417  CG  PHE A  52       1.233  12.459  13.655  1.00 30.13           C  
ATOM    418  CD1 PHE A  52       1.894  13.537  13.082  1.00 29.83           C  
ATOM    419  CD2 PHE A  52       1.711  11.945  14.854  1.00 30.65           C  
ATOM    420  CE1 PHE A  52       3.012  14.100  13.693  1.00 30.10           C  
ATOM    421  CE2 PHE A  52       2.834  12.502  15.475  1.00 30.80           C  
ATOM    422  CZ  PHE A  52       3.481  13.580  14.892  1.00 28.67           C  
ATOM    423  N   SER A  53      -3.410  11.702  12.858  1.00 35.06           N  
ATOM    424  CA  SER A  53      -4.554  11.456  11.998  1.00 37.94           C  
ATOM    425  C   SER A  53      -5.356  12.756  11.902  1.00 38.69           C  
ATOM    426  O   SER A  53      -5.603  13.263  10.811  1.00 39.08           O  
ATOM    427  CB  SER A  53      -5.420  10.335  12.575  1.00 37.88           C  
ATOM    428  OG  SER A  53      -4.741   9.093  12.514  1.00 35.99           O  
ATOM    429  N   PHE A  54      -5.740  13.301  13.054  1.00 38.80           N  
ATOM    430  CA  PHE A  54      -6.500  14.544  13.093  1.00 37.80           C  
ATOM    431  C   PHE A  54      -5.764  15.632  12.322  1.00 39.38           C  
ATOM    432  O   PHE A  54      -6.377  16.421  11.607  1.00 38.71           O  
ATOM    433  CB  PHE A  54      -6.728  14.977  14.544  1.00 35.13           C  
ATOM    434  CG  PHE A  54      -7.404  13.931  15.380  1.00 33.45           C  
ATOM    435  CD1 PHE A  54      -8.558  13.301  14.920  1.00 32.89           C  
ATOM    436  CD2 PHE A  54      -6.869  13.538  16.603  1.00 34.22           C  
ATOM    437  CE1 PHE A  54      -9.165  12.294  15.657  1.00 30.78           C  
ATOM    438  CE2 PHE A  54      -7.470  12.527  17.352  1.00 33.33           C  
ATOM    439  CZ  PHE A  54      -8.622  11.903  16.876  1.00 33.40           C  
ATOM    440  N   LEU A  55      -4.446  15.673  12.460  1.00 40.59           N  
ATOM    441  CA  LEU A  55      -3.661  16.673  11.743  1.00 43.39           C  
ATOM    442  C   LEU A  55      -3.861  16.545  10.230  1.00 44.97           C  
ATOM    443  O   LEU A  55      -4.113  17.538   9.545  1.00 45.00           O  
ATOM    444  CB  LEU A  55      -2.177  16.525  12.066  1.00 45.05           C  
ATOM    445  CG  LEU A  55      -1.264  17.445  11.261  1.00 46.28           C  
ATOM    446  CD1 LEU A  55      -1.558  18.888  11.632  1.00 45.81           C  
ATOM    447  CD2 LEU A  55       0.194  17.099  11.536  1.00 46.85           C  
ATOM    448  N   LEU A  56      -3.743  15.325   9.710  1.00 44.21           N  
ATOM    449  CA  LEU A  56      -3.911  15.100   8.276  1.00 46.18           C  
ATOM    450  C   LEU A  56      -5.347  15.347   7.842  1.00 46.52           C  
ATOM    451  O   LEU A  56      -5.592  15.907   6.774  1.00 45.90           O  
ATOM    452  CB  LEU A  56      -3.498  13.674   7.890  1.00 46.31           C  
ATOM    453  CG  LEU A  56      -2.003  13.327   7.910  1.00 47.09           C  
ATOM    454  CD1 LEU A  56      -1.796  11.949   7.280  1.00 47.85           C  
ATOM    455  CD2 LEU A  56      -1.215  14.377   7.138  1.00 45.85           C  
ATOM    456  N   GLU A  57      -6.293  14.920   8.670  1.00 47.12           N  
ATOM    457  CA  GLU A  57      -7.706  15.111   8.371  1.00 49.62           C  
ATOM    458  C   GLU A  57      -8.037  16.590   8.182  1.00 50.62           C  
ATOM    459  O   GLU A  57      -8.874  16.939   7.352  1.00 52.09           O  
ATOM    460  CB  GLU A  57      -8.573  14.547   9.494  1.00 49.88           C  
ATOM    461  CG  GLU A  57     -10.057  14.818   9.298  1.00 51.42           C  
ATOM    462  CD  GLU A  57     -10.861  14.589  10.558  1.00 51.92           C  
ATOM    463  OE1 GLU A  57     -10.551  15.235  11.582  1.00 52.40           O  
ATOM    464  OE2 GLU A  57     -11.804  13.771  10.527  1.00 53.66           O  
ATOM    465  N   ASP A  58      -7.384  17.459   8.948  1.00 51.43           N  
ATOM    466  CA  ASP A  58      -7.637  18.895   8.840  1.00 52.23           C  
ATOM    467  C   ASP A  58      -6.995  19.485   7.592  1.00 52.34           C  
ATOM    468  O   ASP A  58      -7.362  20.573   7.149  1.00 52.31           O  
ATOM    469  CB  ASP A  58      -7.116  19.633  10.075  1.00 52.55           C  
ATOM    470  CG  ASP A  58      -7.710  19.104  11.364  1.00 53.78           C  
ATOM    471  OD1 ASP A  58      -8.858  18.607  11.333  1.00 53.39           O  
ATOM    472  OD2 ASP A  58      -7.032  19.198  12.410  1.00 55.50           O  
ATOM    473  N   TYR A  59      -6.026  18.768   7.033  1.00 52.68           N  
ATOM    474  CA  TYR A  59      -5.345  19.221   5.830  1.00 52.68           C  
ATOM    475  C   TYR A  59      -6.058  18.705   4.585  1.00 51.47           C  
ATOM    476  O   TYR A  59      -5.571  18.858   3.463  1.00 50.60           O  
ATOM    477  CB  TYR A  59      -3.891  18.752   5.840  1.00 54.72           C  
ATOM    478  CG  TYR A  59      -2.941  19.734   6.483  1.00 57.85           C  
ATOM    479  CD1 TYR A  59      -2.585  20.914   5.830  1.00 58.79           C  
ATOM    480  CD2 TYR A  59      -2.393  19.486   7.736  1.00 58.94           C  
ATOM    481  CE1 TYR A  59      -1.703  21.819   6.407  1.00 61.11           C  
ATOM    482  CE2 TYR A  59      -1.510  20.383   8.326  1.00 61.44           C  
ATOM    483  CZ  TYR A  59      -1.166  21.548   7.656  1.00 62.61           C  
ATOM    484  OH  TYR A  59      -0.273  22.431   8.227  1.00 62.91           O  
ATOM    485  N   GLY A  60      -7.214  18.088   4.797  1.00 49.56           N  
ATOM    486  CA  GLY A  60      -7.989  17.575   3.684  1.00 50.44           C  
ATOM    487  C   GLY A  60      -7.617  16.183   3.209  1.00 50.13           C  
ATOM    488  O   GLY A  60      -7.550  15.940   2.007  1.00 51.16           O  
ATOM    489  N   PHE A  61      -7.369  15.272   4.145  1.00 48.87           N  
ATOM    490  CA  PHE A  61      -7.027  13.895   3.805  1.00 47.16           C  
ATOM    491  C   PHE A  61      -8.081  12.949   4.361  1.00 47.67           C  
ATOM    492  O   PHE A  61      -8.699  13.229   5.387  1.00 48.18           O  
ATOM    493  CB  PHE A  61      -5.667  13.516   4.395  1.00 45.80           C  
ATOM    494  CG  PHE A  61      -4.497  14.057   3.634  1.00 44.87           C  
ATOM    495  CD1 PHE A  61      -4.010  13.388   2.517  1.00 43.85           C  
ATOM    496  CD2 PHE A  61      -3.876  15.234   4.033  1.00 44.73           C  
ATOM    497  CE1 PHE A  61      -2.922  13.880   1.810  1.00 43.16           C  
ATOM    498  CE2 PHE A  61      -2.788  15.737   3.335  1.00 44.50           C  
ATOM    499  CZ  PHE A  61      -2.307  15.058   2.218  1.00 44.99           C  
ATOM    500  N   GLU A  62      -8.291  11.833   3.670  1.00 47.97           N  
ATOM    501  CA  GLU A  62      -9.243  10.818   4.110  1.00 47.82           C  
ATOM    502  C   GLU A  62      -8.382   9.890   4.964  1.00 47.44           C  
ATOM    503  O   GLU A  62      -7.542   9.153   4.435  1.00 47.23           O  
ATOM    504  CB  GLU A  62      -9.814  10.077   2.900  1.00 47.16           C  
ATOM    505  CG  GLU A  62     -10.861   9.035   3.245  1.00 49.98           C  
ATOM    506  CD  GLU A  62     -11.398   8.323   2.022  1.00 50.63           C  
ATOM    507  OE1 GLU A  62     -12.227   7.402   2.186  1.00 50.68           O  
ATOM    508  OE2 GLU A  62     -10.991   8.684   0.897  1.00 50.58           O  
ATOM    509  N   VAL A  63      -8.596   9.918   6.277  1.00 45.55           N  
ATOM    510  CA  VAL A  63      -7.765   9.136   7.190  1.00 43.30           C  
ATOM    511  C   VAL A  63      -8.326   7.906   7.890  1.00 42.45           C  
ATOM    512  O   VAL A  63      -9.467   7.887   8.352  1.00 43.49           O  
ATOM    513  CB  VAL A  63      -7.180  10.058   8.286  1.00 41.86           C  
ATOM    514  CG1 VAL A  63      -6.174   9.295   9.131  1.00 41.40           C  
ATOM    515  CG2 VAL A  63      -6.541  11.272   7.645  1.00 40.44           C  
ATOM    516  N   VAL A  64      -7.484   6.883   7.976  1.00 40.39           N  
ATOM    517  CA  VAL A  64      -7.819   5.641   8.655  1.00 40.94           C  
ATOM    518  C   VAL A  64      -6.682   5.342   9.630  1.00 39.84           C  
ATOM    519  O   VAL A  64      -5.518   5.252   9.232  1.00 40.58           O  
ATOM    520  CB  VAL A  64      -7.935   4.466   7.678  1.00 41.53           C  
ATOM    521  CG1 VAL A  64      -8.345   3.218   8.430  1.00 43.17           C  
ATOM    522  CG2 VAL A  64      -8.946   4.796   6.586  1.00 46.03           C  
ATOM    523  N   GLY A  65      -7.021   5.200  10.907  1.00 38.21           N  
ATOM    524  CA  GLY A  65      -6.009   4.922  11.910  1.00 36.55           C  
ATOM    525  C   GLY A  65      -6.095   3.510  12.454  1.00 34.64           C  
ATOM    526  O   GLY A  65      -7.167   3.058  12.860  1.00 33.48           O  
ATOM    527  N   VAL A  66      -4.958   2.818  12.478  1.00 32.09           N  
ATOM    528  CA  VAL A  66      -4.897   1.442  12.964  1.00 32.28           C  
ATOM    529  C   VAL A  66      -3.850   1.249  14.070  1.00 30.98           C  
ATOM    530  O   VAL A  66      -2.713   1.674  13.930  1.00 30.59           O  
ATOM    531  CB  VAL A  66      -4.560   0.470  11.798  1.00 32.35           C  
ATOM    532  CG1 VAL A  66      -4.440  -0.963  12.315  1.00 30.48           C  
ATOM    533  CG2 VAL A  66      -5.633   0.565  10.718  1.00 32.81           C  
ATOM    534  N   ASP A  67      -4.239   0.599  15.163  1.00 30.62           N  
ATOM    535  CA  ASP A  67      -3.317   0.335  16.271  1.00 30.09           C  
ATOM    536  C   ASP A  67      -3.740  -0.973  16.929  1.00 29.64           C  
ATOM    537  O   ASP A  67      -4.921  -1.325  16.920  1.00 29.02           O  
ATOM    538  CB  ASP A  67      -3.338   1.478  17.293  1.00 27.37           C  
ATOM    539  CG  ASP A  67      -2.120   1.459  18.224  1.00 30.00           C  
ATOM    540  OD1 ASP A  67      -2.003   0.546  19.069  1.00 26.88           O  
ATOM    541  OD2 ASP A  67      -1.270   2.369  18.108  1.00 30.84           O  
ATOM    542  N   ILE A  68      -2.767  -1.691  17.483  1.00 29.09           N  
ATOM    543  CA  ILE A  68      -3.010  -2.981  18.117  1.00 31.43           C  
ATOM    544  C   ILE A  68      -3.545  -2.862  19.545  1.00 32.71           C  
ATOM    545  O   ILE A  68      -4.074  -3.820  20.099  1.00 33.57           O  
ATOM    546  CB  ILE A  68      -1.712  -3.825  18.151  1.00 32.07           C  
ATOM    547  CG1 ILE A  68      -2.047  -5.292  18.426  1.00 32.86           C  
ATOM    548  CG2 ILE A  68      -0.773  -3.299  19.245  1.00 33.05           C  
ATOM    549  CD1 ILE A  68      -0.841  -6.186  18.568  1.00 36.97           C  
ATOM    550  N   SER A  69      -3.404  -1.687  20.141  1.00 33.53           N  
ATOM    551  CA  SER A  69      -3.863  -1.491  21.507  1.00 37.54           C  
ATOM    552  C   SER A  69      -5.311  -1.038  21.622  1.00 37.83           C  
ATOM    553  O   SER A  69      -5.713  -0.033  21.035  1.00 37.60           O  
ATOM    554  CB  SER A  69      -2.975  -0.477  22.226  1.00 37.05           C  
ATOM    555  OG  SER A  69      -3.629   0.020  23.382  1.00 36.69           O  
ATOM    556  N   GLU A  70      -6.089  -1.788  22.392  1.00 38.95           N  
ATOM    557  CA  GLU A  70      -7.484  -1.446  22.614  1.00 40.72           C  
ATOM    558  C   GLU A  70      -7.566  -0.091  23.323  1.00 40.12           C  
ATOM    559  O   GLU A  70      -8.452   0.718  23.034  1.00 39.85           O  
ATOM    560  CB  GLU A  70      -8.148  -2.527  23.461  1.00 43.74           C  
ATOM    561  CG  GLU A  70      -8.447  -3.803  22.698  1.00 49.77           C  
ATOM    562  CD  GLU A  70      -9.888  -3.879  22.231  1.00 52.26           C  
ATOM    563  OE1 GLU A  70     -10.375  -2.909  21.607  1.00 53.94           O  
ATOM    564  OE2 GLU A  70     -10.535  -4.915  22.489  1.00 55.10           O  
ATOM    565  N   ASP A  71      -6.625   0.157  24.233  1.00 39.37           N  
ATOM    566  CA  ASP A  71      -6.591   1.406  24.990  1.00 39.96           C  
ATOM    567  C   ASP A  71      -6.272   2.611  24.110  1.00 40.09           C  
ATOM    568  O   ASP A  71      -6.896   3.666  24.241  1.00 37.98           O  
ATOM    569  CB  ASP A  71      -5.558   1.323  26.117  1.00 42.88           C  
ATOM    570  CG  ASP A  71      -5.752   0.112  27.003  1.00 47.34           C  
ATOM    571  OD1 ASP A  71      -6.893  -0.120  27.462  1.00 48.18           O  
ATOM    572  OD2 ASP A  71      -4.757  -0.609  27.245  1.00 51.61           O  
HETATM  573  N   MSE A  72      -5.288   2.459  23.227  1.00 38.88           N  
HETATM  574  CA  MSE A  72      -4.910   3.544  22.326  1.00 38.77           C  
HETATM  575  C   MSE A  72      -6.105   3.915  21.458  1.00 36.60           C  
HETATM  576  O   MSE A  72      -6.443   5.085  21.314  1.00 35.42           O  
HETATM  577  CB  MSE A  72      -3.742   3.112  21.431  1.00 40.16           C  
HETATM  578  CG  MSE A  72      -2.420   2.937  22.171  1.00 42.20           C  
HETATM  579 SE   MSE A  72      -1.780   4.601  22.918  1.00 44.21          SE  
HETATM  580  CE  MSE A  72      -1.945   4.140  24.791  1.00 46.19           C  
ATOM    581  N   ILE A  73      -6.737   2.896  20.885  1.00 34.46           N  
ATOM    582  CA  ILE A  73      -7.891   3.087  20.023  1.00 35.48           C  
ATOM    583  C   ILE A  73      -9.071   3.704  20.774  1.00 36.79           C  
ATOM    584  O   ILE A  73      -9.763   4.572  20.240  1.00 36.53           O  
ATOM    585  CB  ILE A  73      -8.316   1.744  19.384  1.00 34.39           C  
ATOM    586  CG1 ILE A  73      -7.184   1.227  18.487  1.00 33.62           C  
ATOM    587  CG2 ILE A  73      -9.588   1.924  18.562  1.00 34.97           C  
ATOM    588  CD1 ILE A  73      -6.812   2.176  17.355  1.00 31.22           C  
ATOM    589  N   ARG A  74      -9.292   3.268  22.010  1.00 39.10           N  
ATOM    590  CA  ARG A  74     -10.386   3.813  22.808  1.00 43.00           C  
ATOM    591  C   ARG A  74     -10.200   5.318  23.014  1.00 43.37           C  
ATOM    592  O   ARG A  74     -11.135   6.093  22.826  1.00 44.05           O  
ATOM    593  CB  ARG A  74     -10.471   3.107  24.167  1.00 44.98           C  
ATOM    594  CG  ARG A  74     -11.719   3.483  24.973  1.00 47.82           C  
ATOM    595  CD  ARG A  74     -11.830   2.695  26.273  1.00 50.98           C  
ATOM    596  NE  ARG A  74     -10.645   2.850  27.115  1.00 55.07           N  
ATOM    597  CZ  ARG A  74      -9.703   1.922  27.264  1.00 56.86           C  
ATOM    598  NH1 ARG A  74      -9.801   0.756  26.635  1.00 57.60           N  
ATOM    599  NH2 ARG A  74      -8.651   2.168  28.034  1.00 58.01           N  
ATOM    600  N   LYS A  75      -8.995   5.732  23.396  1.00 43.46           N  
ATOM    601  CA  LYS A  75      -8.729   7.155  23.598  1.00 43.94           C  
ATOM    602  C   LYS A  75      -8.846   7.914  22.280  1.00 42.58           C  
ATOM    603  O   LYS A  75      -9.331   9.045  22.243  1.00 41.86           O  
ATOM    604  CB  LYS A  75      -7.325   7.382  24.172  1.00 45.55           C  
ATOM    605  CG  LYS A  75      -7.187   7.293  25.680  1.00 48.90           C  
ATOM    606  CD  LYS A  75      -5.784   7.754  26.099  1.00 50.18           C  
ATOM    607  CE  LYS A  75      -5.510   7.486  27.571  1.00 52.75           C  
ATOM    608  NZ  LYS A  75      -4.122   7.868  27.962  1.00 52.48           N  
ATOM    609  N   ALA A  76      -8.393   7.289  21.200  1.00 42.03           N  
ATOM    610  CA  ALA A  76      -8.433   7.913  19.885  1.00 41.60           C  
ATOM    611  C   ALA A  76      -9.860   8.329  19.555  1.00 42.15           C  
ATOM    612  O   ALA A  76     -10.103   9.458  19.133  1.00 40.13           O  
ATOM    613  CB  ALA A  76      -7.906   6.946  18.825  1.00 38.77           C  
ATOM    614  N   ARG A  77     -10.796   7.410  19.758  1.00 42.56           N  
ATOM    615  CA  ARG A  77     -12.200   7.670  19.480  1.00 45.19           C  
ATOM    616  C   ARG A  77     -12.757   8.834  20.291  1.00 46.24           C  
ATOM    617  O   ARG A  77     -13.487   9.669  19.757  1.00 47.50           O  
ATOM    618  CB  ARG A  77     -13.008   6.394  19.712  1.00 45.06           C  
ATOM    619  CG  ARG A  77     -12.789   5.389  18.591  1.00 47.75           C  
ATOM    620  CD  ARG A  77     -13.227   3.983  18.933  1.00 47.59           C  
ATOM    621  NE  ARG A  77     -13.013   3.108  17.786  1.00 46.98           N  
ATOM    622  CZ  ARG A  77     -12.988   1.780  17.842  1.00 46.95           C  
ATOM    623  NH1 ARG A  77     -13.161   1.155  18.998  1.00 45.19           N  
ATOM    624  NH2 ARG A  77     -12.782   1.078  16.734  1.00 46.71           N  
ATOM    625  N   GLU A  78     -12.410   8.903  21.572  1.00 47.04           N  
ATOM    626  CA  GLU A  78     -12.881  10.002  22.409  1.00 47.97           C  
ATOM    627  C   GLU A  78     -12.319  11.327  21.901  1.00 47.75           C  
ATOM    628  O   GLU A  78     -13.003  12.349  21.939  1.00 47.61           O  
ATOM    629  CB  GLU A  78     -12.468   9.781  23.860  1.00 49.34           C  
ATOM    630  CG  GLU A  78     -13.076   8.532  24.462  1.00 53.10           C  
ATOM    631  CD  GLU A  78     -12.604   8.281  25.873  1.00 54.90           C  
ATOM    632  OE1 GLU A  78     -12.830   9.153  26.740  1.00 56.79           O  
ATOM    633  OE2 GLU A  78     -12.008   7.211  26.115  1.00 56.05           O  
ATOM    634  N   TYR A  79     -11.072  11.312  21.430  1.00 46.89           N  
ATOM    635  CA  TYR A  79     -10.466  12.530  20.898  1.00 47.39           C  
ATOM    636  C   TYR A  79     -11.182  12.929  19.620  1.00 48.08           C  
ATOM    637  O   TYR A  79     -11.412  14.110  19.367  1.00 47.73           O  
ATOM    638  CB  TYR A  79      -8.975  12.330  20.601  1.00 45.83           C  
ATOM    639  CG  TYR A  79      -8.083  12.481  21.812  1.00 45.86           C  
ATOM    640  CD1 TYR A  79      -8.095  13.656  22.568  1.00 44.79           C  
ATOM    641  CD2 TYR A  79      -7.221  11.458  22.202  1.00 44.42           C  
ATOM    642  CE1 TYR A  79      -7.269  13.809  23.682  1.00 44.33           C  
ATOM    643  CE2 TYR A  79      -6.391  11.599  23.315  1.00 44.74           C  
ATOM    644  CZ  TYR A  79      -6.420  12.777  24.050  1.00 44.77           C  
ATOM    645  OH  TYR A  79      -5.593  12.930  25.145  1.00 42.50           O  
ATOM    646  N   ALA A  80     -11.529  11.931  18.814  1.00 49.49           N  
ATOM    647  CA  ALA A  80     -12.225  12.166  17.557  1.00 50.35           C  
ATOM    648  C   ALA A  80     -13.612  12.721  17.851  1.00 51.55           C  
ATOM    649  O   ALA A  80     -14.120  13.577  17.125  1.00 50.50           O  
ATOM    650  CB  ALA A  80     -12.333  10.867  16.770  1.00 49.82           C  
ATOM    651  N   LYS A  81     -14.219  12.229  18.925  1.00 52.78           N  
ATOM    652  CA  LYS A  81     -15.547  12.680  19.318  1.00 55.07           C  
ATOM    653  C   LYS A  81     -15.479  14.149  19.729  1.00 55.37           C  
ATOM    654  O   LYS A  81     -16.205  14.988  19.195  1.00 55.71           O  
ATOM    655  CB  LYS A  81     -16.066  11.830  20.481  1.00 56.59           C  
ATOM    656  CG  LYS A  81     -17.563  11.928  20.718  1.00 58.13           C  
ATOM    657  CD  LYS A  81     -17.992  11.012  21.858  1.00 59.12           C  
ATOM    658  CE  LYS A  81     -19.510  10.937  21.996  1.00 60.10           C  
ATOM    659  NZ  LYS A  81     -20.131  12.266  22.249  1.00 60.47           N  
ATOM    660  N   SER A  82     -14.587  14.455  20.668  1.00 55.10           N  
ATOM    661  CA  SER A  82     -14.431  15.822  21.152  1.00 55.59           C  
ATOM    662  C   SER A  82     -14.022  16.792  20.049  1.00 56.06           C  
ATOM    663  O   SER A  82     -14.374  17.969  20.093  1.00 56.31           O  
ATOM    664  CB  SER A  82     -13.404  15.872  22.287  1.00 55.35           C  
ATOM    665  OG  SER A  82     -12.129  15.454  21.843  1.00 56.93           O  
ATOM    666  N   ARG A  83     -13.279  16.304  19.061  1.00 56.84           N  
ATOM    667  CA  ARG A  83     -12.856  17.163  17.961  1.00 58.03           C  
ATOM    668  C   ARG A  83     -13.799  17.046  16.775  1.00 57.74           C  
ATOM    669  O   ARG A  83     -13.591  17.690  15.748  1.00 57.40           O  
ATOM    670  CB  ARG A  83     -11.430  16.822  17.515  1.00 59.27           C  
ATOM    671  CG  ARG A  83     -10.358  17.205  18.520  1.00 60.79           C  
ATOM    672  CD  ARG A  83      -8.988  17.219  17.878  1.00 61.04           C  
ATOM    673  NE  ARG A  83      -7.959  17.682  18.801  1.00 61.11           N  
ATOM    674  CZ  ARG A  83      -6.685  17.857  18.467  1.00 61.24           C  
ATOM    675  NH1 ARG A  83      -6.286  17.608  17.228  1.00 59.84           N  
ATOM    676  NH2 ARG A  83      -5.809  18.268  19.375  1.00 60.20           N  
ATOM    677  N   GLU A  84     -14.840  16.230  16.922  1.00 57.65           N  
ATOM    678  CA  GLU A  84     -15.803  16.027  15.846  1.00 57.86           C  
ATOM    679  C   GLU A  84     -15.058  15.673  14.563  1.00 57.07           C  
ATOM    680  O   GLU A  84     -15.133  16.380  13.561  1.00 56.70           O  
ATOM    681  CB  GLU A  84     -16.652  17.291  15.662  1.00 58.28           C  
ATOM    682  CG  GLU A  84     -17.716  17.449  16.744  1.00 59.00           C  
ATOM    683  CD  GLU A  84     -18.394  18.809  16.729  1.00 61.13           C  
ATOM    684  OE1 GLU A  84     -19.461  18.941  17.372  1.00 60.30           O  
ATOM    685  OE2 GLU A  84     -17.859  19.742  16.089  1.00 59.73           O  
ATOM    686  N   SER A  85     -14.338  14.559  14.623  1.00 56.91           N  
ATOM    687  CA  SER A  85     -13.540  14.065  13.510  1.00 56.61           C  
ATOM    688  C   SER A  85     -14.192  12.859  12.846  1.00 56.84           C  
ATOM    689  O   SER A  85     -14.885  12.075  13.499  1.00 56.65           O  
ATOM    690  CB  SER A  85     -12.148  13.676  14.017  1.00 56.67           C  
ATOM    691  OG  SER A  85     -11.336  13.174  12.972  1.00 55.60           O  
ATOM    692  N   ASN A  86     -13.957  12.716  11.545  1.00 56.71           N  
ATOM    693  CA  ASN A  86     -14.506  11.605  10.776  1.00 56.38           C  
ATOM    694  C   ASN A  86     -13.464  10.517  10.531  1.00 56.02           C  
ATOM    695  O   ASN A  86     -13.680   9.608   9.727  1.00 56.20           O  
ATOM    696  CB  ASN A  86     -15.048  12.105   9.436  1.00 56.98           C  
ATOM    697  CG  ASN A  86     -16.256  13.001   9.597  1.00 58.20           C  
ATOM    698  OD1 ASN A  86     -17.275  12.593  10.158  1.00 59.12           O  
ATOM    699  ND2 ASN A  86     -16.151  14.230   9.106  1.00 58.05           N  
ATOM    700  N   VAL A  87     -12.332  10.615  11.219  1.00 54.95           N  
ATOM    701  CA  VAL A  87     -11.273   9.622  11.083  1.00 53.41           C  
ATOM    702  C   VAL A  87     -11.739   8.317  11.717  1.00 53.13           C  
ATOM    703  O   VAL A  87     -12.197   8.305  12.860  1.00 52.73           O  
ATOM    704  CB  VAL A  87      -9.975  10.073  11.788  1.00 53.23           C  
ATOM    705  CG1 VAL A  87      -8.920   8.983  11.681  1.00 51.77           C  
ATOM    706  CG2 VAL A  87      -9.468  11.362  11.173  1.00 52.31           C  
ATOM    707  N   GLU A  88     -11.630   7.223  10.968  1.00 53.55           N  
ATOM    708  CA  GLU A  88     -12.035   5.918  11.470  1.00 53.36           C  
ATOM    709  C   GLU A  88     -10.862   5.169  12.081  1.00 51.77           C  
ATOM    710  O   GLU A  88      -9.858   4.914  11.415  1.00 52.91           O  
ATOM    711  CB  GLU A  88     -12.635   5.057  10.360  1.00 54.57           C  
ATOM    712  CG  GLU A  88     -12.836   3.610  10.800  1.00 57.60           C  
ATOM    713  CD  GLU A  88     -13.554   2.759   9.774  1.00 60.59           C  
ATOM    714  OE1 GLU A  88     -13.085   2.688   8.616  1.00 60.97           O  
ATOM    715  OE2 GLU A  88     -14.586   2.155  10.136  1.00 60.74           O  
ATOM    716  N   PHE A  89     -11.007   4.807  13.349  1.00 48.35           N  
ATOM    717  CA  PHE A  89      -9.972   4.076  14.057  1.00 45.35           C  
ATOM    718  C   PHE A  89     -10.345   2.609  14.152  1.00 44.37           C  
ATOM    719  O   PHE A  89     -11.476   2.262  14.498  1.00 43.21           O  
ATOM    720  CB  PHE A  89      -9.773   4.667  15.450  1.00 42.55           C  
ATOM    721  CG  PHE A  89      -9.214   6.051  15.429  1.00 39.76           C  
ATOM    722  CD1 PHE A  89      -7.907   6.276  15.016  1.00 37.76           C  
ATOM    723  CD2 PHE A  89     -10.003   7.139  15.789  1.00 37.42           C  
ATOM    724  CE1 PHE A  89      -7.390   7.568  14.962  1.00 36.47           C  
ATOM    725  CE2 PHE A  89      -9.496   8.435  15.738  1.00 34.87           C  
ATOM    726  CZ  PHE A  89      -8.191   8.651  15.323  1.00 33.84           C  
ATOM    727  N   ILE A  90      -9.382   1.752  13.834  1.00 43.50           N  
ATOM    728  CA  ILE A  90      -9.602   0.316  13.872  1.00 43.08           C  
ATOM    729  C   ILE A  90      -8.491  -0.367  14.647  1.00 41.46           C  
ATOM    730  O   ILE A  90      -7.325  -0.004  14.519  1.00 41.00           O  
ATOM    731  CB  ILE A  90      -9.626  -0.283  12.451  1.00 44.17           C  
ATOM    732  CG1 ILE A  90     -10.665   0.439  11.596  1.00 45.38           C  
ATOM    733  CG2 ILE A  90      -9.950  -1.765  12.519  1.00 44.69           C  
ATOM    734  CD1 ILE A  90     -10.684  -0.020  10.148  1.00 46.68           C  
ATOM    735  N   VAL A  91      -8.861  -1.354  15.453  1.00 40.59           N  
ATOM    736  CA  VAL A  91      -7.892  -2.106  16.232  1.00 40.65           C  
ATOM    737  C   VAL A  91      -7.345  -3.205  15.329  1.00 41.41           C  
ATOM    738  O   VAL A  91      -8.039  -4.187  15.046  1.00 41.36           O  
ATOM    739  CB  VAL A  91      -8.546  -2.744  17.471  1.00 40.81           C  
ATOM    740  CG1 VAL A  91      -7.531  -3.577  18.223  1.00 42.19           C  
ATOM    741  CG2 VAL A  91      -9.101  -1.659  18.382  1.00 40.93           C  
ATOM    742  N   GLY A  92      -6.107  -3.034  14.868  1.00 39.70           N  
ATOM    743  CA  GLY A  92      -5.506  -4.022  13.990  1.00 38.79           C  
ATOM    744  C   GLY A  92      -4.015  -4.219  14.190  1.00 37.75           C  
ATOM    745  O   GLY A  92      -3.368  -3.484  14.941  1.00 37.38           O  
ATOM    746  N   ASP A  93      -3.467  -5.218  13.504  1.00 36.50           N  
ATOM    747  CA  ASP A  93      -2.049  -5.548  13.601  1.00 34.06           C  
ATOM    748  C   ASP A  93      -1.310  -5.109  12.342  1.00 32.98           C  
ATOM    749  O   ASP A  93      -1.617  -5.571  11.242  1.00 34.79           O  
ATOM    750  CB  ASP A  93      -1.887  -7.053  13.788  1.00 32.85           C  
ATOM    751  CG  ASP A  93      -0.461  -7.452  14.140  1.00 31.91           C  
ATOM    752  OD1 ASP A  93       0.484  -6.689  13.844  1.00 31.46           O  
ATOM    753  OD2 ASP A  93      -0.289  -8.547  14.705  1.00 32.43           O  
ATOM    754  N   ALA A  94      -0.328  -4.228  12.515  1.00 30.35           N  
ATOM    755  CA  ALA A  94       0.454  -3.705  11.402  1.00 30.24           C  
ATOM    756  C   ALA A  94       1.167  -4.811  10.643  1.00 29.95           C  
ATOM    757  O   ALA A  94       1.482  -4.649   9.464  1.00 29.46           O  
ATOM    758  CB  ALA A  94       1.479  -2.684  11.911  1.00 27.35           C  
ATOM    759  N   ARG A  95       1.423  -5.925  11.326  1.00 30.82           N  
ATOM    760  CA  ARG A  95       2.110  -7.065  10.723  1.00 34.16           C  
ATOM    761  C   ARG A  95       1.205  -7.838   9.763  1.00 36.61           C  
ATOM    762  O   ARG A  95       1.690  -8.576   8.908  1.00 37.00           O  
ATOM    763  CB  ARG A  95       2.635  -8.000  11.815  1.00 33.45           C  
ATOM    764  CG  ARG A  95       3.690  -7.364  12.717  1.00 32.85           C  
ATOM    765  CD  ARG A  95       3.991  -8.237  13.925  1.00 32.96           C  
ATOM    766  NE  ARG A  95       2.776  -8.555  14.667  1.00 32.82           N  
ATOM    767  CZ  ARG A  95       2.709  -9.390  15.701  1.00 34.65           C  
ATOM    768  NH1 ARG A  95       3.796 -10.017  16.147  1.00 33.74           N  
ATOM    769  NH2 ARG A  95       1.540  -9.604  16.287  1.00 32.28           N  
ATOM    770  N   LYS A  96      -0.106  -7.659   9.901  1.00 38.18           N  
ATOM    771  CA  LYS A  96      -1.064  -8.337   9.032  1.00 39.67           C  
ATOM    772  C   LYS A  96      -2.391  -7.584   8.957  1.00 39.10           C  
ATOM    773  O   LYS A  96      -3.320  -7.861   9.716  1.00 37.68           O  
ATOM    774  CB  LYS A  96      -1.316  -9.768   9.515  1.00 43.04           C  
ATOM    775  CG  LYS A  96      -2.219 -10.563   8.572  1.00 47.84           C  
ATOM    776  CD  LYS A  96      -1.653 -10.551   7.149  1.00 52.26           C  
ATOM    777  CE  LYS A  96      -2.638 -11.119   6.126  1.00 55.30           C  
ATOM    778  NZ  LYS A  96      -3.876 -10.296   6.018  1.00 56.26           N  
ATOM    779  N   LEU A  97      -2.468  -6.641   8.022  1.00 39.48           N  
ATOM    780  CA  LEU A  97      -3.655  -5.818   7.826  1.00 40.33           C  
ATOM    781  C   LEU A  97      -4.690  -6.529   6.970  1.00 42.29           C  
ATOM    782  O   LEU A  97      -4.344  -7.330   6.102  1.00 42.56           O  
ATOM    783  CB  LEU A  97      -3.263  -4.505   7.155  1.00 38.71           C  
ATOM    784  CG  LEU A  97      -2.167  -3.707   7.863  1.00 38.08           C  
ATOM    785  CD1 LEU A  97      -1.637  -2.636   6.917  1.00 35.31           C  
ATOM    786  CD2 LEU A  97      -2.716  -3.093   9.146  1.00 35.31           C  
ATOM    787  N   SER A  98      -5.961  -6.215   7.207  1.00 43.91           N  
ATOM    788  CA  SER A  98      -7.057  -6.833   6.469  1.00 46.06           C  
ATOM    789  C   SER A  98      -7.495  -6.041   5.241  1.00 45.91           C  
ATOM    790  O   SER A  98      -8.399  -6.469   4.525  1.00 47.95           O  
ATOM    791  CB  SER A  98      -8.269  -7.014   7.383  1.00 46.95           C  
ATOM    792  OG  SER A  98      -8.851  -5.758   7.688  1.00 47.64           O  
ATOM    793  N   PHE A  99      -6.872  -4.891   4.999  1.00 44.42           N  
ATOM    794  CA  PHE A  99      -7.237  -4.071   3.846  1.00 44.56           C  
ATOM    795  C   PHE A  99      -6.898  -4.784   2.543  1.00 45.05           C  
ATOM    796  O   PHE A  99      -6.026  -5.657   2.510  1.00 44.86           O  
ATOM    797  CB  PHE A  99      -6.506  -2.722   3.875  1.00 43.01           C  
ATOM    798  CG  PHE A  99      -6.797  -1.895   5.093  1.00 43.66           C  
ATOM    799  CD1 PHE A  99      -8.094  -1.475   5.371  1.00 42.97           C  
ATOM    800  CD2 PHE A  99      -5.776  -1.549   5.972  1.00 42.93           C  
ATOM    801  CE1 PHE A  99      -8.371  -0.724   6.511  1.00 44.43           C  
ATOM    802  CE2 PHE A  99      -6.040  -0.799   7.115  1.00 43.58           C  
ATOM    803  CZ  PHE A  99      -7.338  -0.386   7.387  1.00 43.73           C  
ATOM    804  N   GLU A 100      -7.593  -4.406   1.476  1.00 44.92           N  
ATOM    805  CA  GLU A 100      -7.354  -4.989   0.162  1.00 45.81           C  
ATOM    806  C   GLU A 100      -6.046  -4.416  -0.359  1.00 45.00           C  
ATOM    807  O   GLU A 100      -5.521  -3.443   0.190  1.00 43.80           O  
ATOM    808  CB  GLU A 100      -8.486  -4.622  -0.803  1.00 47.75           C  
ATOM    809  CG  GLU A 100      -9.866  -5.014  -0.311  1.00 52.07           C  
ATOM    810  CD  GLU A 100     -10.023  -6.513  -0.186  1.00 54.79           C  
ATOM    811  OE1 GLU A 100     -10.116  -7.190  -1.235  1.00 56.49           O  
ATOM    812  OE2 GLU A 100     -10.041  -7.018   0.958  1.00 56.12           O  
ATOM    813  N   ASP A 101      -5.528  -5.017  -1.420  1.00 45.36           N  
ATOM    814  CA  ASP A 101      -4.285  -4.566  -2.023  1.00 45.60           C  
ATOM    815  C   ASP A 101      -4.483  -3.209  -2.690  1.00 44.81           C  
ATOM    816  O   ASP A 101      -5.577  -2.894  -3.159  1.00 44.18           O  
ATOM    817  CB  ASP A 101      -3.807  -5.589  -3.056  1.00 48.14           C  
ATOM    818  CG  ASP A 101      -3.803  -7.004  -2.510  1.00 50.65           C  
ATOM    819  OD1 ASP A 101      -3.295  -7.200  -1.392  1.00 53.02           O  
ATOM    820  OD2 ASP A 101      -4.305  -7.922  -3.191  1.00 53.05           O  
ATOM    821  N   LYS A 102      -3.428  -2.403  -2.715  1.00 43.85           N  
ATOM    822  CA  LYS A 102      -3.486  -1.088  -3.341  1.00 45.09           C  
ATOM    823  C   LYS A 102      -4.676  -0.261  -2.862  1.00 44.57           C  
ATOM    824  O   LYS A 102      -5.444   0.263  -3.663  1.00 45.46           O  
ATOM    825  CB  LYS A 102      -3.557  -1.253  -4.860  1.00 46.00           C  
ATOM    826  CG  LYS A 102      -2.356  -1.964  -5.458  1.00 47.85           C  
ATOM    827  CD  LYS A 102      -2.576  -2.269  -6.932  1.00 49.30           C  
ATOM    828  CE  LYS A 102      -1.299  -2.772  -7.574  1.00 50.81           C  
ATOM    829  NZ  LYS A 102      -0.704  -3.888  -6.797  1.00 53.15           N  
ATOM    830  N   THR A 103      -4.827  -0.135  -1.553  1.00 44.64           N  
ATOM    831  CA  THR A 103      -5.933   0.630  -0.997  1.00 43.56           C  
ATOM    832  C   THR A 103      -5.563   2.069  -0.646  1.00 42.52           C  
ATOM    833  O   THR A 103      -6.410   2.957  -0.707  1.00 43.28           O  
ATOM    834  CB  THR A 103      -6.488  -0.050   0.273  1.00 44.65           C  
ATOM    835  OG1 THR A 103      -7.174  -1.255  -0.091  1.00 47.06           O  
ATOM    836  CG2 THR A 103      -7.441   0.879   1.014  1.00 45.87           C  
ATOM    837  N   PHE A 104      -4.302   2.314  -0.309  1.00 40.27           N  
ATOM    838  CA  PHE A 104      -3.899   3.659   0.102  1.00 38.68           C  
ATOM    839  C   PHE A 104      -2.963   4.448  -0.800  1.00 36.87           C  
ATOM    840  O   PHE A 104      -2.204   3.887  -1.589  1.00 37.20           O  
ATOM    841  CB  PHE A 104      -3.291   3.581   1.506  1.00 37.84           C  
ATOM    842  CG  PHE A 104      -4.222   2.997   2.529  1.00 37.17           C  
ATOM    843  CD1 PHE A 104      -5.160   3.799   3.177  1.00 35.06           C  
ATOM    844  CD2 PHE A 104      -4.190   1.633   2.814  1.00 37.08           C  
ATOM    845  CE1 PHE A 104      -6.059   3.249   4.097  1.00 35.25           C  
ATOM    846  CE2 PHE A 104      -5.087   1.072   3.734  1.00 37.28           C  
ATOM    847  CZ  PHE A 104      -6.022   1.886   4.375  1.00 35.25           C  
ATOM    848  N   ASP A 105      -3.041   5.769  -0.671  1.00 36.60           N  
ATOM    849  CA  ASP A 105      -2.188   6.689  -1.417  1.00 37.36           C  
ATOM    850  C   ASP A 105      -0.998   7.018  -0.520  1.00 36.50           C  
ATOM    851  O   ASP A 105       0.081   7.362  -1.001  1.00 37.68           O  
ATOM    852  CB  ASP A 105      -2.934   7.984  -1.737  1.00 37.41           C  
ATOM    853  CG  ASP A 105      -4.060   7.783  -2.726  1.00 41.16           C  
ATOM    854  OD1 ASP A 105      -3.773   7.416  -3.894  1.00 36.53           O  
ATOM    855  OD2 ASP A 105      -5.231   7.997  -2.326  1.00 42.29           O  
ATOM    856  N   TYR A 106      -1.226   6.919   0.789  1.00 35.94           N  
ATOM    857  CA  TYR A 106      -0.201   7.193   1.794  1.00 34.97           C  
ATOM    858  C   TYR A 106      -0.366   6.281   2.997  1.00 33.41           C  
ATOM    859  O   TYR A 106      -1.468   5.858   3.338  1.00 32.16           O  
ATOM    860  CB  TYR A 106      -0.280   8.629   2.326  1.00 35.13           C  
ATOM    861  CG  TYR A 106      -0.071   9.732   1.327  1.00 36.42           C  
ATOM    862  CD1 TYR A 106      -1.153  10.324   0.685  1.00 38.03           C  
ATOM    863  CD2 TYR A 106       1.207  10.215   1.052  1.00 37.32           C  
ATOM    864  CE1 TYR A 106      -0.971  11.374  -0.205  1.00 38.90           C  
ATOM    865  CE2 TYR A 106       1.403  11.264   0.164  1.00 38.91           C  
ATOM    866  CZ  TYR A 106       0.306  11.841  -0.462  1.00 40.84           C  
ATOM    867  OH  TYR A 106       0.482  12.886  -1.343  1.00 42.31           O  
ATOM    868  N   VAL A 107       0.757   6.001   3.639  1.00 32.67           N  
ATOM    869  CA  VAL A 107       0.806   5.191   4.837  1.00 31.85           C  
ATOM    870  C   VAL A 107       1.884   5.849   5.675  1.00 31.43           C  
ATOM    871  O   VAL A 107       3.037   5.907   5.258  1.00 33.10           O  
ATOM    872  CB  VAL A 107       1.226   3.739   4.530  1.00 32.15           C  
ATOM    873  CG1 VAL A 107       1.515   3.001   5.822  1.00 30.18           C  
ATOM    874  CG2 VAL A 107       0.125   3.035   3.754  1.00 31.29           C  
ATOM    875  N   ILE A 108       1.508   6.379   6.835  1.00 31.96           N  
ATOM    876  CA  ILE A 108       2.484   7.016   7.713  1.00 31.14           C  
ATOM    877  C   ILE A 108       2.742   6.086   8.883  1.00 29.16           C  
ATOM    878  O   ILE A 108       1.831   5.408   9.371  1.00 28.34           O  
ATOM    879  CB  ILE A 108       2.001   8.400   8.211  1.00 31.35           C  
ATOM    880  CG1 ILE A 108       0.748   8.252   9.079  1.00 32.36           C  
ATOM    881  CG2 ILE A 108       1.711   9.288   7.013  1.00 32.62           C  
ATOM    882  CD1 ILE A 108       0.241   9.570   9.660  1.00 32.36           C  
ATOM    883  N   PHE A 109       3.996   6.059   9.320  1.00 29.40           N  
ATOM    884  CA  PHE A 109       4.458   5.174  10.385  1.00 29.30           C  
ATOM    885  C   PHE A 109       5.437   6.006  11.221  1.00 30.24           C  
ATOM    886  O   PHE A 109       6.606   6.197  10.847  1.00 28.35           O  
ATOM    887  CB  PHE A 109       5.138   3.970   9.709  1.00 29.13           C  
ATOM    888  CG  PHE A 109       5.521   2.859  10.636  1.00 27.89           C  
ATOM    889  CD1 PHE A 109       4.607   2.333  11.540  1.00 27.66           C  
ATOM    890  CD2 PHE A 109       6.784   2.285  10.549  1.00 29.37           C  
ATOM    891  CE1 PHE A 109       4.944   1.251  12.345  1.00 28.64           C  
ATOM    892  CE2 PHE A 109       7.135   1.198  11.349  1.00 27.69           C  
ATOM    893  CZ  PHE A 109       6.211   0.679  12.247  1.00 30.08           C  
ATOM    894  N   ILE A 110       4.950   6.498  12.357  1.00 29.51           N  
ATOM    895  CA  ILE A 110       5.741   7.373  13.210  1.00 30.74           C  
ATOM    896  C   ILE A 110       6.117   6.858  14.601  1.00 30.38           C  
ATOM    897  O   ILE A 110       5.284   6.314  15.314  1.00 30.68           O  
ATOM    898  CB  ILE A 110       5.002   8.733  13.363  1.00 29.05           C  
ATOM    899  CG1 ILE A 110       4.824   9.371  11.977  1.00 30.97           C  
ATOM    900  CG2 ILE A 110       5.763   9.650  14.310  1.00 28.52           C  
ATOM    901  CD1 ILE A 110       4.052  10.682  11.979  1.00 36.18           C  
ATOM    902  N   ASP A 111       7.382   7.054  14.975  1.00 32.12           N  
ATOM    903  CA  ASP A 111       7.895   6.653  16.289  1.00 31.92           C  
ATOM    904  C   ASP A 111       7.362   5.310  16.783  1.00 31.00           C  
ATOM    905  O   ASP A 111       6.864   5.234  17.902  1.00 29.72           O  
ATOM    906  CB  ASP A 111       7.534   7.710  17.349  1.00 34.94           C  
ATOM    907  CG  ASP A 111       8.306   9.010  17.197  1.00 39.31           C  
ATOM    908  OD1 ASP A 111       9.552   8.957  17.100  1.00 42.64           O  
ATOM    909  OD2 ASP A 111       7.667  10.096  17.199  1.00 40.19           O  
ATOM    910  N   SER A 112       7.471   4.249  15.992  1.00 28.38           N  
ATOM    911  CA  SER A 112       6.933   2.968  16.448  1.00 28.98           C  
ATOM    912  C   SER A 112       7.811   1.733  16.311  1.00 27.85           C  
ATOM    913  O   SER A 112       7.450   0.676  16.827  1.00 28.09           O  
ATOM    914  CB  SER A 112       5.600   2.677  15.746  1.00 28.61           C  
ATOM    915  OG  SER A 112       4.653   3.695  15.998  1.00 30.20           O  
ATOM    916  N   ILE A 113       8.951   1.851  15.636  1.00 27.35           N  
ATOM    917  CA  ILE A 113       9.809   0.698  15.424  1.00 26.93           C  
ATOM    918  C   ILE A 113      10.341  -0.007  16.668  1.00 27.96           C  
ATOM    919  O   ILE A 113      10.678  -1.190  16.587  1.00 26.44           O  
ATOM    920  CB  ILE A 113      11.010   1.032  14.502  1.00 29.93           C  
ATOM    921  CG1 ILE A 113      11.849   2.154  15.106  1.00 30.20           C  
ATOM    922  CG2 ILE A 113      10.511   1.397  13.109  1.00 27.98           C  
ATOM    923  CD1 ILE A 113      13.137   2.416  14.328  1.00 36.69           C  
ATOM    924  N   VAL A 114      10.415   0.682  17.811  1.00 26.32           N  
ATOM    925  CA  VAL A 114      10.916   0.023  19.020  1.00 27.03           C  
ATOM    926  C   VAL A 114      10.057  -1.179  19.365  1.00 25.98           C  
ATOM    927  O   VAL A 114      10.475  -2.046  20.120  1.00 26.79           O  
ATOM    928  CB  VAL A 114      10.961   0.970  20.272  1.00 27.05           C  
ATOM    929  CG1 VAL A 114      11.952   2.098  20.036  1.00 28.97           C  
ATOM    930  CG2 VAL A 114       9.571   1.528  20.589  1.00 26.64           C  
ATOM    931  N   HIS A 115       8.858  -1.231  18.792  1.00 28.78           N  
ATOM    932  CA  HIS A 115       7.919  -2.322  19.040  1.00 29.00           C  
ATOM    933  C   HIS A 115       8.124  -3.539  18.146  1.00 29.20           C  
ATOM    934  O   HIS A 115       7.506  -4.576  18.362  1.00 28.36           O  
ATOM    935  CB  HIS A 115       6.481  -1.833  18.844  1.00 31.12           C  
ATOM    936  CG  HIS A 115       5.940  -1.044  19.993  1.00 32.68           C  
ATOM    937  ND1 HIS A 115       5.408  -1.639  21.117  1.00 33.07           N  
ATOM    938  CD2 HIS A 115       5.857   0.291  20.198  1.00 32.47           C  
ATOM    939  CE1 HIS A 115       5.020  -0.704  21.966  1.00 34.00           C  
ATOM    940  NE2 HIS A 115       5.281   0.476  21.433  1.00 34.65           N  
ATOM    941  N   PHE A 116       8.994  -3.429  17.151  1.00 28.61           N  
ATOM    942  CA  PHE A 116       9.178  -4.541  16.236  1.00 28.72           C  
ATOM    943  C   PHE A 116      10.593  -5.111  16.143  1.00 28.34           C  
ATOM    944  O   PHE A 116      11.565  -4.375  15.970  1.00 27.69           O  
ATOM    945  CB  PHE A 116       8.727  -4.114  14.833  1.00 27.36           C  
ATOM    946  CG  PHE A 116       7.310  -3.593  14.774  1.00 28.88           C  
ATOM    947  CD1 PHE A 116       6.259  -4.421  14.377  1.00 29.25           C  
ATOM    948  CD2 PHE A 116       7.026  -2.277  15.124  1.00 27.65           C  
ATOM    949  CE1 PHE A 116       4.943  -3.938  14.331  1.00 28.08           C  
ATOM    950  CE2 PHE A 116       5.717  -1.788  15.081  1.00 27.08           C  
ATOM    951  CZ  PHE A 116       4.674  -2.620  14.683  1.00 25.71           C  
ATOM    952  N   GLU A 117      10.705  -6.429  16.264  1.00 27.53           N  
ATOM    953  CA  GLU A 117      12.005  -7.061  16.105  1.00 27.59           C  
ATOM    954  C   GLU A 117      12.152  -7.202  14.577  1.00 26.94           C  
ATOM    955  O   GLU A 117      11.186  -6.988  13.838  1.00 25.43           O  
ATOM    956  CB  GLU A 117      12.046  -8.420  16.809  1.00 30.32           C  
ATOM    957  CG  GLU A 117      11.179  -9.505  16.211  1.00 34.64           C  
ATOM    958  CD  GLU A 117      11.316 -10.823  16.962  1.00 36.18           C  
ATOM    959  OE1 GLU A 117      12.448 -11.159  17.374  1.00 39.81           O  
ATOM    960  OE2 GLU A 117      10.305 -11.529  17.130  1.00 35.45           O  
ATOM    961  N   PRO A 118      13.351  -7.549  14.084  1.00 27.44           N  
ATOM    962  CA  PRO A 118      13.564  -7.689  12.637  1.00 27.27           C  
ATOM    963  C   PRO A 118      12.511  -8.434  11.815  1.00 27.45           C  
ATOM    964  O   PRO A 118      11.998  -7.896  10.825  1.00 27.00           O  
ATOM    965  CB  PRO A 118      14.947  -8.334  12.556  1.00 25.03           C  
ATOM    966  CG  PRO A 118      15.656  -7.680  13.722  1.00 29.32           C  
ATOM    967  CD  PRO A 118      14.606  -7.780  14.825  1.00 24.83           C  
ATOM    968  N   LEU A 119      12.167  -9.653  12.202  1.00 28.65           N  
ATOM    969  CA  LEU A 119      11.186 -10.387  11.411  1.00 31.46           C  
ATOM    970  C   LEU A 119       9.792  -9.768  11.434  1.00 30.59           C  
ATOM    971  O   LEU A 119       9.002  -9.986  10.520  1.00 31.44           O  
ATOM    972  CB  LEU A 119      11.122 -11.859  11.843  1.00 35.19           C  
ATOM    973  CG  LEU A 119      10.677 -12.230  13.256  1.00 38.34           C  
ATOM    974  CD1 LEU A 119       9.195 -11.913  13.452  1.00 39.54           C  
ATOM    975  CD2 LEU A 119      10.922 -13.715  13.462  1.00 41.62           C  
ATOM    976  N   GLU A 120       9.491  -8.993  12.470  1.00 27.66           N  
ATOM    977  CA  GLU A 120       8.178  -8.358  12.575  1.00 28.79           C  
ATOM    978  C   GLU A 120       8.151  -7.098  11.716  1.00 27.16           C  
ATOM    979  O   GLU A 120       7.159  -6.817  11.037  1.00 26.74           O  
ATOM    980  CB  GLU A 120       7.862  -7.987  14.035  1.00 28.76           C  
ATOM    981  CG  GLU A 120       7.938  -9.167  15.006  1.00 31.23           C  
ATOM    982  CD  GLU A 120       7.644  -8.773  16.448  1.00 33.72           C  
ATOM    983  OE1 GLU A 120       8.108  -7.689  16.869  1.00 31.41           O  
ATOM    984  OE2 GLU A 120       6.964  -9.557  17.159  1.00 31.72           O  
ATOM    985  N   LEU A 121       9.238  -6.335  11.751  1.00 25.24           N  
ATOM    986  CA  LEU A 121       9.289  -5.122  10.948  1.00 27.09           C  
ATOM    987  C   LEU A 121       9.299  -5.534   9.477  1.00 26.79           C  
ATOM    988  O   LEU A 121       8.801  -4.807   8.628  1.00 25.11           O  
ATOM    989  CB  LEU A 121      10.528  -4.289  11.275  1.00 25.16           C  
ATOM    990  CG  LEU A 121      10.548  -2.916  10.593  1.00 26.11           C  
ATOM    991  CD1 LEU A 121       9.284  -2.140  10.957  1.00 24.84           C  
ATOM    992  CD2 LEU A 121      11.785  -2.149  11.014  1.00 25.25           C  
ATOM    993  N   ASN A 122       9.862  -6.708   9.188  1.00 27.76           N  
ATOM    994  CA  ASN A 122       9.898  -7.210   7.820  1.00 29.15           C  
ATOM    995  C   ASN A 122       8.466  -7.433   7.338  1.00 29.23           C  
ATOM    996  O   ASN A 122       8.129  -7.083   6.210  1.00 30.53           O  
ATOM    997  CB  ASN A 122      10.675  -8.530   7.741  1.00 29.36           C  
ATOM    998  CG  ASN A 122      10.593  -9.173   6.361  1.00 29.89           C  
ATOM    999  OD1 ASN A 122      10.263 -10.355   6.230  1.00 30.46           O  
ATOM   1000  ND2 ASN A 122      10.895  -8.396   5.329  1.00 25.65           N  
ATOM   1001  N   GLN A 123       7.629  -8.005   8.203  1.00 30.12           N  
ATOM   1002  CA  GLN A 123       6.228  -8.277   7.873  1.00 29.94           C  
ATOM   1003  C   GLN A 123       5.454  -6.976   7.668  1.00 28.71           C  
ATOM   1004  O   GLN A 123       4.621  -6.879   6.773  1.00 25.58           O  
ATOM   1005  CB  GLN A 123       5.562  -9.095   8.988  1.00 33.07           C  
ATOM   1006  CG  GLN A 123       6.372 -10.304   9.439  1.00 38.98           C  
ATOM   1007  CD  GLN A 123       5.884 -10.897  10.759  1.00 42.51           C  
ATOM   1008  OE1 GLN A 123       5.629 -10.174  11.725  1.00 43.54           O  
ATOM   1009  NE2 GLN A 123       5.770 -12.220  10.807  1.00 43.89           N  
ATOM   1010  N   VAL A 124       5.723  -5.978   8.505  1.00 27.00           N  
ATOM   1011  CA  VAL A 124       5.043  -4.695   8.378  1.00 26.50           C  
ATOM   1012  C   VAL A 124       5.353  -4.041   7.030  1.00 26.45           C  
ATOM   1013  O   VAL A 124       4.444  -3.605   6.324  1.00 23.89           O  
ATOM   1014  CB  VAL A 124       5.457  -3.729   9.500  1.00 26.77           C  
ATOM   1015  CG1 VAL A 124       4.870  -2.349   9.248  1.00 26.98           C  
ATOM   1016  CG2 VAL A 124       4.982  -4.263  10.844  1.00 27.33           C  
ATOM   1017  N   PHE A 125       6.636  -3.976   6.675  1.00 27.12           N  
ATOM   1018  CA  PHE A 125       7.027  -3.377   5.403  1.00 28.14           C  
ATOM   1019  C   PHE A 125       6.361  -4.099   4.238  1.00 30.98           C  
ATOM   1020  O   PHE A 125       5.914  -3.463   3.282  1.00 29.53           O  
ATOM   1021  CB  PHE A 125       8.546  -3.413   5.211  1.00 28.29           C  
ATOM   1022  CG  PHE A 125       9.301  -2.381   6.013  1.00 26.68           C  
ATOM   1023  CD1 PHE A 125       8.632  -1.408   6.749  1.00 25.96           C  
ATOM   1024  CD2 PHE A 125      10.692  -2.386   6.022  1.00 26.80           C  
ATOM   1025  CE1 PHE A 125       9.342  -0.455   7.489  1.00 27.04           C  
ATOM   1026  CE2 PHE A 125      11.412  -1.443   6.753  1.00 25.19           C  
ATOM   1027  CZ  PHE A 125      10.734  -0.472   7.490  1.00 27.56           C  
ATOM   1028  N   LYS A 126       6.295  -5.427   4.323  1.00 32.36           N  
ATOM   1029  CA  LYS A 126       5.676  -6.220   3.273  1.00 35.97           C  
ATOM   1030  C   LYS A 126       4.202  -5.840   3.155  1.00 36.14           C  
ATOM   1031  O   LYS A 126       3.699  -5.610   2.053  1.00 36.54           O  
ATOM   1032  CB  LYS A 126       5.817  -7.714   3.578  1.00 38.32           C  
ATOM   1033  CG  LYS A 126       5.550  -8.613   2.383  1.00 43.42           C  
ATOM   1034  CD  LYS A 126       5.867 -10.066   2.701  1.00 47.15           C  
ATOM   1035  CE  LYS A 126       7.318 -10.236   3.108  1.00 48.85           C  
ATOM   1036  NZ  LYS A 126       7.635 -11.650   3.450  1.00 52.18           N  
ATOM   1037  N   GLU A 127       3.520  -5.760   4.294  1.00 34.17           N  
ATOM   1038  CA  GLU A 127       2.107  -5.388   4.316  1.00 34.21           C  
ATOM   1039  C   GLU A 127       1.875  -3.963   3.815  1.00 34.41           C  
ATOM   1040  O   GLU A 127       0.892  -3.698   3.118  1.00 32.51           O  
ATOM   1041  CB  GLU A 127       1.537  -5.530   5.732  1.00 35.86           C  
ATOM   1042  CG  GLU A 127       1.068  -6.927   6.052  1.00 37.62           C  
ATOM   1043  CD  GLU A 127      -0.089  -7.342   5.166  1.00 40.30           C  
ATOM   1044  OE1 GLU A 127      -1.236  -6.967   5.477  1.00 42.00           O  
ATOM   1045  OE2 GLU A 127       0.153  -8.026   4.151  1.00 40.74           O  
ATOM   1046  N   VAL A 128       2.780  -3.051   4.170  1.00 32.50           N  
ATOM   1047  CA  VAL A 128       2.659  -1.661   3.748  1.00 31.73           C  
ATOM   1048  C   VAL A 128       2.727  -1.575   2.228  1.00 34.30           C  
ATOM   1049  O   VAL A 128       1.913  -0.902   1.595  1.00 30.48           O  
ATOM   1050  CB  VAL A 128       3.791  -0.791   4.336  1.00 32.36           C  
ATOM   1051  CG1 VAL A 128       3.743   0.602   3.727  1.00 28.56           C  
ATOM   1052  CG2 VAL A 128       3.655  -0.722   5.867  1.00 32.83           C  
ATOM   1053  N   ARG A 129       3.715  -2.244   1.645  1.00 34.97           N  
ATOM   1054  CA  ARG A 129       3.854  -2.221   0.201  1.00 38.08           C  
ATOM   1055  C   ARG A 129       2.588  -2.744  -0.465  1.00 37.19           C  
ATOM   1056  O   ARG A 129       2.124  -2.179  -1.448  1.00 37.39           O  
ATOM   1057  CB  ARG A 129       5.049  -3.064  -0.244  1.00 40.12           C  
ATOM   1058  CG  ARG A 129       5.109  -3.243  -1.749  1.00 43.63           C  
ATOM   1059  CD  ARG A 129       6.269  -4.115  -2.174  1.00 48.11           C  
ATOM   1060  NE  ARG A 129       6.147  -4.507  -3.572  1.00 51.54           N  
ATOM   1061  CZ  ARG A 129       5.164  -5.265  -4.047  1.00 53.61           C  
ATOM   1062  NH1 ARG A 129       4.216  -5.716  -3.234  1.00 53.82           N  
ATOM   1063  NH2 ARG A 129       5.127  -5.572  -5.335  1.00 56.67           N  
ATOM   1064  N   ARG A 130       2.023  -3.812   0.096  1.00 36.69           N  
ATOM   1065  CA  ARG A 130       0.825  -4.434  -0.455  1.00 36.98           C  
ATOM   1066  C   ARG A 130      -0.426  -3.558  -0.479  1.00 38.16           C  
ATOM   1067  O   ARG A 130      -1.118  -3.496  -1.497  1.00 36.79           O  
ATOM   1068  CB  ARG A 130       0.510  -5.730   0.302  1.00 38.84           C  
ATOM   1069  CG  ARG A 130      -0.740  -6.442  -0.200  1.00 39.43           C  
ATOM   1070  CD  ARG A 130      -1.003  -7.737   0.550  1.00 41.23           C  
ATOM   1071  NE  ARG A 130      -1.568  -7.521   1.880  1.00 40.14           N  
ATOM   1072  CZ  ARG A 130      -2.731  -6.923   2.111  1.00 37.46           C  
ATOM   1073  NH1 ARG A 130      -3.461  -6.475   1.099  1.00 37.75           N  
ATOM   1074  NH2 ARG A 130      -3.168  -6.774   3.353  1.00 35.42           N  
ATOM   1075  N   VAL A 131      -0.721  -2.895   0.639  1.00 37.41           N  
ATOM   1076  CA  VAL A 131      -1.909  -2.043   0.744  1.00 37.68           C  
ATOM   1077  C   VAL A 131      -1.701  -0.657   0.126  1.00 37.50           C  
ATOM   1078  O   VAL A 131      -2.628   0.144   0.026  1.00 37.97           O  
ATOM   1079  CB  VAL A 131      -2.325  -1.869   2.216  1.00 36.60           C  
ATOM   1080  CG1 VAL A 131      -2.577  -3.230   2.845  1.00 34.82           C  
ATOM   1081  CG2 VAL A 131      -1.233  -1.119   2.980  1.00 36.79           C  
ATOM   1082  N   LEU A 132      -0.477  -0.386  -0.299  1.00 38.38           N  
ATOM   1083  CA  LEU A 132      -0.156   0.899  -0.900  1.00 39.61           C  
ATOM   1084  C   LEU A 132      -0.335   0.845  -2.419  1.00 41.87           C  
ATOM   1085  O   LEU A 132       0.025  -0.147  -3.063  1.00 42.43           O  
ATOM   1086  CB  LEU A 132       1.291   1.252  -0.560  1.00 39.69           C  
ATOM   1087  CG  LEU A 132       1.736   2.707  -0.525  1.00 41.15           C  
ATOM   1088  CD1 LEU A 132       0.855   3.498   0.419  1.00 39.09           C  
ATOM   1089  CD2 LEU A 132       3.187   2.766  -0.076  1.00 41.04           C  
ATOM   1090  N   LYS A 133      -0.906   1.900  -2.994  1.00 40.39           N  
ATOM   1091  CA  LYS A 133      -1.074   1.954  -4.437  1.00 40.12           C  
ATOM   1092  C   LYS A 133       0.318   2.147  -5.027  1.00 41.01           C  
ATOM   1093  O   LYS A 133       1.156   2.826  -4.438  1.00 39.32           O  
ATOM   1094  CB  LYS A 133      -1.947   3.140  -4.844  1.00 39.04           C  
ATOM   1095  CG  LYS A 133      -3.410   3.052  -4.437  1.00 40.27           C  
ATOM   1096  CD  LYS A 133      -4.173   4.262  -4.975  1.00 40.54           C  
ATOM   1097  CE  LYS A 133      -5.610   4.274  -4.493  1.00 42.85           C  
ATOM   1098  NZ  LYS A 133      -6.291   5.552  -4.851  1.00 45.49           N  
ATOM   1099  N   PRO A 134       0.585   1.554  -6.203  1.00 41.72           N  
ATOM   1100  CA  PRO A 134       1.916   1.723  -6.798  1.00 41.02           C  
ATOM   1101  C   PRO A 134       2.340   3.194  -6.883  1.00 39.88           C  
ATOM   1102  O   PRO A 134       3.526   3.512  -6.841  1.00 38.17           O  
ATOM   1103  CB  PRO A 134       1.776   1.052  -8.173  1.00 41.63           C  
ATOM   1104  CG  PRO A 134       0.280   1.113  -8.453  1.00 43.09           C  
ATOM   1105  CD  PRO A 134      -0.314   0.808  -7.102  1.00 41.74           C  
ATOM   1106  N   SER A 135       1.369   4.095  -6.983  1.00 40.94           N  
ATOM   1107  CA  SER A 135       1.678   5.525  -7.062  1.00 41.42           C  
ATOM   1108  C   SER A 135       1.699   6.162  -5.675  1.00 41.15           C  
ATOM   1109  O   SER A 135       1.928   7.365  -5.540  1.00 39.73           O  
ATOM   1110  CB  SER A 135       0.638   6.241  -7.922  1.00 41.51           C  
ATOM   1111  OG  SER A 135      -0.655   6.073  -7.370  1.00 42.84           O  
ATOM   1112  N   GLY A 136       1.460   5.341  -4.652  1.00 40.84           N  
ATOM   1113  CA  GLY A 136       1.420   5.826  -3.283  1.00 38.98           C  
ATOM   1114  C   GLY A 136       2.767   6.081  -2.639  1.00 38.35           C  
ATOM   1115  O   GLY A 136       3.810   5.857  -3.252  1.00 37.80           O  
ATOM   1116  N   LYS A 137       2.741   6.555  -1.395  1.00 36.42           N  
ATOM   1117  CA  LYS A 137       3.970   6.842  -0.671  1.00 35.48           C  
ATOM   1118  C   LYS A 137       3.963   6.346   0.773  1.00 33.87           C  
ATOM   1119  O   LYS A 137       2.985   6.512   1.492  1.00 32.89           O  
ATOM   1120  CB  LYS A 137       4.250   8.349  -0.714  1.00 34.65           C  
ATOM   1121  CG  LYS A 137       4.572   8.828  -2.122  1.00 37.31           C  
ATOM   1122  CD  LYS A 137       4.245  10.285  -2.356  1.00 36.96           C  
ATOM   1123  CE  LYS A 137       5.388  11.199  -1.970  1.00 40.12           C  
ATOM   1124  NZ  LYS A 137       5.120  12.594  -2.421  1.00 34.09           N  
ATOM   1125  N   PHE A 138       5.062   5.710   1.168  1.00 33.17           N  
ATOM   1126  CA  PHE A 138       5.243   5.205   2.524  1.00 32.20           C  
ATOM   1127  C   PHE A 138       6.126   6.237   3.213  1.00 30.69           C  
ATOM   1128  O   PHE A 138       7.248   6.468   2.782  1.00 31.74           O  
ATOM   1129  CB  PHE A 138       5.975   3.858   2.504  1.00 32.34           C  
ATOM   1130  CG  PHE A 138       6.279   3.295   3.877  1.00 29.83           C  
ATOM   1131  CD1 PHE A 138       7.452   2.582   4.101  1.00 29.51           C  
ATOM   1132  CD2 PHE A 138       5.384   3.455   4.933  1.00 27.40           C  
ATOM   1133  CE1 PHE A 138       7.733   2.035   5.361  1.00 30.15           C  
ATOM   1134  CE2 PHE A 138       5.653   2.913   6.190  1.00 27.01           C  
ATOM   1135  CZ  PHE A 138       6.830   2.201   6.404  1.00 28.29           C  
ATOM   1136  N   ILE A 139       5.625   6.860   4.273  1.00 29.53           N  
ATOM   1137  CA  ILE A 139       6.403   7.868   4.984  1.00 29.88           C  
ATOM   1138  C   ILE A 139       6.604   7.494   6.448  1.00 29.56           C  
ATOM   1139  O   ILE A 139       5.641   7.461   7.219  1.00 27.97           O  
ATOM   1140  CB  ILE A 139       5.703   9.244   4.914  1.00 30.21           C  
ATOM   1141  CG1 ILE A 139       5.632   9.710   3.459  1.00 30.42           C  
ATOM   1142  CG2 ILE A 139       6.449  10.259   5.777  1.00 31.19           C  
ATOM   1143  CD1 ILE A 139       4.846  10.991   3.263  1.00 32.75           C  
HETATM 1144  N   MSE A 140       7.845   7.211   6.838  1.00 30.34           N  
HETATM 1145  CA  MSE A 140       8.096   6.858   8.227  1.00 31.42           C  
HETATM 1146  C   MSE A 140       9.137   7.738   8.917  1.00 30.47           C  
HETATM 1147  O   MSE A 140      10.038   8.298   8.291  1.00 28.54           O  
HETATM 1148  CB  MSE A 140       8.453   5.356   8.367  1.00 34.61           C  
HETATM 1149  CG  MSE A 140       9.906   4.932   8.175  1.00 40.73           C  
HETATM 1150 SE   MSE A 140      10.228   3.071   8.821  1.00 45.06          SE  
HETATM 1151  CE  MSE A 140      10.902   3.485  10.567  1.00 44.54           C  
ATOM   1152  N   TYR A 141       8.966   7.885  10.222  1.00 30.93           N  
ATOM   1153  CA  TYR A 141       9.869   8.678  11.033  1.00 31.74           C  
ATOM   1154  C   TYR A 141      10.334   7.764  12.144  1.00 32.24           C  
ATOM   1155  O   TYR A 141       9.521   7.125  12.816  1.00 31.43           O  
ATOM   1156  CB  TYR A 141       9.145   9.888  11.627  1.00 31.62           C  
ATOM   1157  CG  TYR A 141       9.971  10.620  12.661  1.00 31.38           C  
ATOM   1158  CD1 TYR A 141      11.009  11.475  12.284  1.00 31.73           C  
ATOM   1159  CD2 TYR A 141       9.728  10.440  14.018  1.00 32.12           C  
ATOM   1160  CE1 TYR A 141      11.781  12.129  13.246  1.00 35.09           C  
ATOM   1161  CE2 TYR A 141      10.491  11.087  14.982  1.00 34.01           C  
ATOM   1162  CZ  TYR A 141      11.513  11.927  14.594  1.00 33.68           C  
ATOM   1163  OH  TYR A 141      12.273  12.548  15.564  1.00 36.92           O  
ATOM   1164  N   PHE A 142      11.643   7.679  12.326  1.00 34.52           N  
ATOM   1165  CA  PHE A 142      12.182   6.819  13.364  1.00 36.88           C  
ATOM   1166  C   PHE A 142      13.456   7.407  13.921  1.00 38.24           C  
ATOM   1167  O   PHE A 142      14.052   8.319  13.339  1.00 38.61           O  
ATOM   1168  CB  PHE A 142      12.463   5.404  12.826  1.00 37.42           C  
ATOM   1169  CG  PHE A 142      13.565   5.346  11.797  1.00 40.60           C  
ATOM   1170  CD1 PHE A 142      13.341   5.764  10.485  1.00 42.04           C  
ATOM   1171  CD2 PHE A 142      14.833   4.898  12.147  1.00 38.94           C  
ATOM   1172  CE1 PHE A 142      14.368   5.740   9.537  1.00 42.77           C  
ATOM   1173  CE2 PHE A 142      15.864   4.871  11.210  1.00 42.33           C  
ATOM   1174  CZ  PHE A 142      15.632   5.294   9.902  1.00 42.30           C  
ATOM   1175  N   THR A 143      13.873   6.869  15.056  1.00 36.09           N  
ATOM   1176  CA  THR A 143      15.078   7.335  15.705  1.00 36.14           C  
ATOM   1177  C   THR A 143      16.116   6.225  15.668  1.00 36.24           C  
ATOM   1178  O   THR A 143      15.806   5.068  15.948  1.00 34.87           O  
ATOM   1179  CB  THR A 143      14.778   7.735  17.167  1.00 33.71           C  
ATOM   1180  OG1 THR A 143      13.833   8.811  17.164  1.00 36.70           O  
ATOM   1181  CG2 THR A 143      16.046   8.180  17.890  1.00 33.27           C  
ATOM   1182  N   ASP A 144      17.339   6.581  15.291  1.00 36.09           N  
ATOM   1183  CA  ASP A 144      18.419   5.613  15.250  1.00 37.52           C  
ATOM   1184  C   ASP A 144      18.802   5.397  16.711  1.00 37.79           C  
ATOM   1185  O   ASP A 144      19.702   6.057  17.243  1.00 35.73           O  
ATOM   1186  CB  ASP A 144      19.608   6.170  14.464  1.00 37.87           C  
ATOM   1187  CG  ASP A 144      20.717   5.145  14.273  1.00 39.57           C  
ATOM   1188  OD1 ASP A 144      21.044   4.433  15.245  1.00 39.28           O  
ATOM   1189  OD2 ASP A 144      21.273   5.061  13.155  1.00 39.22           O  
ATOM   1190  N   LEU A 145      18.091   4.484  17.363  1.00 38.96           N  
ATOM   1191  CA  LEU A 145      18.442   4.407  18.771  1.00 41.48           C  
ATOM   1192  C   LEU A 145      19.759   3.662  18.962  1.00 42.61           C  
ATOM   1193  O   LEU A 145      20.436   3.796  19.973  1.00 41.93           O  
ATOM   1194  CB  LEU A 145      17.317   3.674  19.503  1.00 42.06           C  
ATOM   1195  CG  LEU A 145      17.445   3.772  21.025  1.00 42.86           C  
ATOM   1196  CD1 LEU A 145      18.635   4.633  21.455  1.00 45.60           C  
ATOM   1197  CD2 LEU A 145      16.212   4.386  21.686  1.00 46.44           C  
ATOM   1198  N   ARG A 146      20.293   2.986  17.954  1.00 43.78           N  
ATOM   1199  CA  ARG A 146      21.635   2.428  18.060  1.00 47.97           C  
ATOM   1200  C   ARG A 146      22.703   3.509  18.206  1.00 48.55           C  
ATOM   1201  O   ARG A 146      23.645   3.356  18.978  1.00 48.64           O  
ATOM   1202  CB  ARG A 146      21.933   1.544  16.848  1.00 48.98           C  
ATOM   1203  CG  ARG A 146      23.250   0.792  16.938  1.00 52.60           C  
ATOM   1204  CD  ARG A 146      23.199  -0.446  16.073  1.00 56.02           C  
ATOM   1205  NE  ARG A 146      22.099  -1.318  16.480  1.00 58.34           N  
ATOM   1206  CZ  ARG A 146      21.705  -2.394  15.804  1.00 60.28           C  
ATOM   1207  NH1 ARG A 146      22.325  -2.737  14.682  1.00 60.44           N  
ATOM   1208  NH2 ARG A 146      20.687  -3.122  16.246  1.00 59.47           N  
ATOM   1209  N   GLU A 147      22.552   4.601  17.466  1.00 51.16           N  
ATOM   1210  CA  GLU A 147      23.511   5.698  17.532  1.00 54.27           C  
ATOM   1211  C   GLU A 147      23.298   6.528  18.796  1.00 54.90           C  
ATOM   1212  O   GLU A 147      24.247   7.067  19.366  1.00 54.87           O  
ATOM   1213  CB  GLU A 147      23.371   6.594  16.301  1.00 56.42           C  
ATOM   1214  CG  GLU A 147      23.808   5.956  14.992  1.00 60.89           C  
ATOM   1215  CD  GLU A 147      25.255   5.492  15.020  1.00 63.79           C  
ATOM   1216  OE1 GLU A 147      25.515   4.378  15.525  1.00 63.99           O  
ATOM   1217  OE2 GLU A 147      26.135   6.247  14.546  1.00 65.39           O  
ATOM   1218  N   LEU A 148      22.046   6.622  19.229  1.00 55.41           N  
ATOM   1219  CA  LEU A 148      21.688   7.386  20.420  1.00 56.52           C  
ATOM   1220  C   LEU A 148      22.055   6.660  21.715  1.00 57.28           C  
ATOM   1221  O   LEU A 148      22.302   7.291  22.742  1.00 57.97           O  
ATOM   1222  CB  LEU A 148      20.185   7.674  20.407  1.00 56.82           C  
ATOM   1223  CG  LEU A 148      19.563   8.367  21.619  1.00 57.21           C  
ATOM   1224  CD1 LEU A 148      20.125   9.770  21.753  1.00 55.19           C  
ATOM   1225  CD2 LEU A 148      18.047   8.406  21.454  1.00 57.09           C  
ATOM   1226  N   LEU A 149      22.088   5.333  21.655  1.00 57.08           N  
ATOM   1227  CA  LEU A 149      22.398   4.491  22.816  1.00 58.06           C  
ATOM   1228  C   LEU A 149      23.546   5.054  23.673  1.00 58.63           C  
ATOM   1229  O   LEU A 149      23.409   5.290  24.866  1.00 57.98           O  
ATOM   1230  CB  LEU A 149      22.762   3.095  22.309  1.00 58.39           C  
ATOM   1231  CG  LEU A 149      21.659   2.068  22.575  1.00 59.30           C  
ATOM   1232  CD1 LEU A 149      22.219   0.690  22.931  1.00 59.55           C  
ATOM   1233  CD2 LEU A 149      20.739   2.468  23.728  1.00 59.16           C  
ATOM   1234  N   PRO A 150      24.730   5.284  23.072  1.00 59.98           N  
ATOM   1235  CA  PRO A 150      25.891   5.807  23.805  1.00 61.41           C  
ATOM   1236  C   PRO A 150      25.577   6.948  24.772  1.00 62.81           C  
ATOM   1237  O   PRO A 150      25.917   6.879  25.952  1.00 62.99           O  
ATOM   1238  CB  PRO A 150      26.832   6.238  22.686  1.00 60.94           C  
ATOM   1239  CG  PRO A 150      26.565   5.209  21.640  1.00 61.48           C  
ATOM   1240  CD  PRO A 150      25.054   5.128  21.641  1.00 60.08           C  
ATOM   1241  N   ARG A 151      24.937   8.000  24.271  1.00 64.34           N  
ATOM   1242  CA  ARG A 151      24.587   9.137  25.112  1.00 66.50           C  
ATOM   1243  C   ARG A 151      23.079   9.311  25.251  1.00 67.72           C  
ATOM   1244  O   ARG A 151      22.536  10.382  24.991  1.00 67.71           O  
ATOM   1245  CB  ARG A 151      25.237  10.420  24.569  1.00 67.03           C  
ATOM   1246  CG  ARG A 151      25.399  10.490  23.048  1.00 68.22           C  
ATOM   1247  CD  ARG A 151      24.109  10.854  22.328  1.00 68.52           C  
ATOM   1248  NE  ARG A 151      24.337  11.057  20.897  1.00 69.03           N  
ATOM   1249  CZ  ARG A 151      23.412  11.477  20.038  1.00 69.56           C  
ATOM   1250  NH1 ARG A 151      23.716  11.632  18.757  1.00 69.21           N  
ATOM   1251  NH2 ARG A 151      22.182  11.748  20.456  1.00 69.62           N  
ATOM   1252  N   LEU A 152      22.412   8.243  25.683  1.00 69.59           N  
ATOM   1253  CA  LEU A 152      20.964   8.250  25.856  1.00 72.15           C  
ATOM   1254  C   LEU A 152      20.552   8.695  27.262  1.00 73.72           C  
ATOM   1255  O   LEU A 152      19.554   9.399  27.430  1.00 73.52           O  
ATOM   1256  CB  LEU A 152      20.405   6.849  25.568  1.00 72.47           C  
ATOM   1257  CG  LEU A 152      18.888   6.653  25.438  1.00 72.44           C  
ATOM   1258  CD1 LEU A 152      18.613   5.267  24.883  1.00 72.94           C  
ATOM   1259  CD2 LEU A 152      18.204   6.828  26.778  1.00 72.76           C  
ATOM   1260  N   LYS A 153      21.329   8.288  28.262  1.00 75.46           N  
ATOM   1261  CA  LYS A 153      21.046   8.623  29.657  1.00 77.34           C  
ATOM   1262  C   LYS A 153      20.784  10.114  29.898  1.00 78.26           C  
ATOM   1263  O   LYS A 153      20.359  10.504  30.985  1.00 78.60           O  
ATOM   1264  CB  LYS A 153      22.196   8.143  30.549  1.00 78.02           C  
ATOM   1265  CG  LYS A 153      21.939   8.295  32.044  1.00 78.87           C  
ATOM   1266  CD  LYS A 153      23.110   7.778  32.870  1.00 80.23           C  
ATOM   1267  CE  LYS A 153      23.284   6.275  32.710  1.00 80.89           C  
ATOM   1268  NZ  LYS A 153      22.089   5.524  33.192  1.00 81.20           N  
ATOM   1269  N   GLU A 154      21.033  10.943  28.888  1.00 79.61           N  
ATOM   1270  CA  GLU A 154      20.804  12.382  29.004  1.00 80.66           C  
ATOM   1271  C   GLU A 154      20.987  13.098  27.669  1.00 80.59           C  
ATOM   1272  O   GLU A 154      22.034  12.990  27.032  1.00 80.85           O  
ATOM   1273  CB  GLU A 154      21.743  12.993  30.050  1.00 81.62           C  
ATOM   1274  CG  GLU A 154      23.229  12.817  29.759  1.00 82.94           C  
ATOM   1275  CD  GLU A 154      24.111  13.467  30.815  1.00 84.13           C  
ATOM   1276  OE1 GLU A 154      25.353  13.383  30.689  1.00 85.03           O  
ATOM   1277  OE2 GLU A 154      23.564  14.061  31.771  1.00 83.98           O  
ATOM   1278  N   ILE A 164      15.966   8.777  34.245  1.00 55.21           N  
ATOM   1279  CA  ILE A 164      16.548   7.523  33.779  1.00 56.91           C  
ATOM   1280  C   ILE A 164      17.669   7.060  34.710  1.00 57.64           C  
ATOM   1281  O   ILE A 164      18.673   7.751  34.884  1.00 57.94           O  
ATOM   1282  CB  ILE A 164      17.113   7.663  32.346  1.00 56.56           C  
ATOM   1283  CG1 ILE A 164      17.886   6.395  31.968  1.00 56.86           C  
ATOM   1284  CG2 ILE A 164      18.001   8.899  32.251  1.00 57.14           C  
ATOM   1285  CD1 ILE A 164      18.537   6.450  30.607  1.00 57.20           C  
ATOM   1286  N   SER A 165      17.495   5.881  35.297  1.00 58.45           N  
ATOM   1287  CA  SER A 165      18.483   5.347  36.218  1.00 58.76           C  
ATOM   1288  C   SER A 165      19.491   4.395  35.583  1.00 59.43           C  
ATOM   1289  O   SER A 165      20.668   4.418  35.937  1.00 60.27           O  
ATOM   1290  CB  SER A 165      17.783   4.646  37.388  1.00 59.13           C  
ATOM   1291  OG  SER A 165      16.947   3.590  36.943  1.00 59.03           O  
ATOM   1292  N   LYS A 166      19.046   3.566  34.643  1.00 59.28           N  
ATOM   1293  CA  LYS A 166      19.960   2.613  34.023  1.00 58.98           C  
ATOM   1294  C   LYS A 166      19.657   2.303  32.555  1.00 57.52           C  
ATOM   1295  O   LYS A 166      18.523   2.444  32.096  1.00 57.76           O  
ATOM   1296  CB  LYS A 166      19.955   1.319  34.842  1.00 60.72           C  
ATOM   1297  CG  LYS A 166      21.149   0.406  34.608  1.00 63.44           C  
ATOM   1298  CD  LYS A 166      21.128  -0.767  35.580  1.00 65.31           C  
ATOM   1299  CE  LYS A 166      22.373  -1.631  35.447  1.00 66.74           C  
ATOM   1300  NZ  LYS A 166      22.371  -2.760  36.425  1.00 67.49           N  
ATOM   1301  N   VAL A 167      20.690   1.884  31.828  1.00 55.35           N  
ATOM   1302  CA  VAL A 167      20.571   1.526  30.416  1.00 53.45           C  
ATOM   1303  C   VAL A 167      21.336   0.227  30.172  1.00 53.02           C  
ATOM   1304  O   VAL A 167      22.567   0.223  30.096  1.00 51.69           O  
ATOM   1305  CB  VAL A 167      21.154   2.622  29.499  1.00 52.56           C  
ATOM   1306  CG1 VAL A 167      21.033   2.201  28.047  1.00 51.95           C  
ATOM   1307  CG2 VAL A 167      20.424   3.927  29.720  1.00 52.42           C  
ATOM   1308  N   ILE A 168      20.599  -0.872  30.044  1.00 52.89           N  
ATOM   1309  CA  ILE A 168      21.203  -2.176  29.829  1.00 52.31           C  
ATOM   1310  C   ILE A 168      20.982  -2.666  28.410  1.00 52.55           C  
ATOM   1311  O   ILE A 168      19.921  -3.198  28.069  1.00 52.34           O  
ATOM   1312  CB  ILE A 168      20.631  -3.205  30.806  1.00 51.57           C  
ATOM   1313  CG1 ILE A 168      20.806  -2.694  32.232  1.00 50.90           C  
ATOM   1314  CG2 ILE A 168      21.329  -4.543  30.626  1.00 52.05           C  
ATOM   1315  CD1 ILE A 168      20.141  -3.562  33.271  1.00 51.23           C  
ATOM   1316  N   PRO A 169      21.992  -2.491  27.563  1.00 53.48           N  
ATOM   1317  CA  PRO A 169      21.858  -2.933  26.182  1.00 54.90           C  
ATOM   1318  C   PRO A 169      22.093  -4.435  26.004  1.00 56.27           C  
ATOM   1319  O   PRO A 169      22.269  -5.180  26.959  1.00 55.04           O  
ATOM   1320  CB  PRO A 169      22.956  -2.161  25.473  1.00 54.43           C  
ATOM   1321  CG  PRO A 169      24.044  -2.174  26.492  1.00 54.56           C  
ATOM   1322  CD  PRO A 169      23.308  -1.861  27.785  1.00 54.04           C  
ATOM   1323  N   ASP A 170      22.051  -4.824  24.718  1.00 59.03           N  
ATOM   1324  CA  ASP A 170      22.292  -6.225  24.431  1.00 61.15           C  
ATOM   1325  C   ASP A 170      22.203  -6.351  22.922  1.00 61.84           C  
ATOM   1326  O   ASP A 170      21.221  -6.829  22.370  1.00 60.65           O  
ATOM   1327  CB  ASP A 170      21.201  -7.071  25.088  1.00 62.38           C  
ATOM   1328  CG  ASP A 170      21.173  -8.449  24.444  1.00 65.31           C  
ATOM   1329  OD1 ASP A 170      22.030  -8.703  23.597  1.00 67.26           O  
ATOM   1330  OD2 ASP A 170      20.310  -9.249  24.796  1.00 65.85           O  
ATOM   1331  N   GLN A 171      23.243  -5.931  22.213  1.00 62.97           N  
ATOM   1332  CA  GLN A 171      23.264  -5.968  20.782  1.00 62.90           C  
ATOM   1333  C   GLN A 171      23.343  -7.359  20.223  1.00 63.02           C  
ATOM   1334  O   GLN A 171      23.203  -7.548  19.028  1.00 62.58           O  
ATOM   1335  CB  GLN A 171      24.413  -5.124  20.265  1.00 63.24           C  
ATOM   1336  CG  GLN A 171      23.971  -3.931  19.462  1.00 62.60           C  
ATOM   1337  CD  GLN A 171      22.701  -3.307  20.008  1.00 62.20           C  
ATOM   1338  OE1 GLN A 171      21.599  -3.807  19.774  1.00 59.00           O  
ATOM   1339  NE2 GLN A 171      22.846  -2.195  20.724  1.00 62.12           N  
ATOM   1340  N   GLU A 172      23.568  -8.343  21.081  1.00 63.42           N  
ATOM   1341  CA  GLU A 172      23.652  -9.735  20.695  1.00 64.73           C  
ATOM   1342  C   GLU A 172      22.198 -10.175  20.546  1.00 64.71           C  
ATOM   1343  O   GLU A 172      21.894 -11.355  20.366  1.00 65.56           O  
ATOM   1344  CB  GLU A 172      24.325 -10.559  21.807  1.00 65.52           C  
ATOM   1345  CG  GLU A 172      25.633  -9.939  22.327  1.00 67.62           C  
ATOM   1346  CD  GLU A 172      25.436  -8.630  23.085  1.00 68.25           C  
ATOM   1347  OE1 GLU A 172      24.804  -8.650  24.164  1.00 69.18           O  
ATOM   1348  OE2 GLU A 172      25.917  -7.580  22.602  1.00 66.76           O  
ATOM   1349  N   GLU A 173      21.304  -9.189  20.618  1.00 63.60           N  
ATOM   1350  CA  GLU A 173      19.865  -9.405  20.529  1.00 60.92           C  
ATOM   1351  C   GLU A 173      19.186  -8.192  19.891  1.00 58.29           C  
ATOM   1352  O   GLU A 173      18.029  -8.264  19.466  1.00 58.75           O  
ATOM   1353  CB  GLU A 173      19.306  -9.627  21.940  1.00 63.49           C  
ATOM   1354  CG  GLU A 173      17.910 -10.221  22.000  1.00 66.21           C  
ATOM   1355  CD  GLU A 173      17.501 -10.591  23.418  1.00 67.44           C  
ATOM   1356  OE1 GLU A 173      17.257  -9.675  24.236  1.00 67.42           O  
ATOM   1357  OE2 GLU A 173      17.435 -11.803  23.715  1.00 68.80           O  
ATOM   1358  N   ARG A 174      19.912  -7.078  19.831  1.00 53.00           N  
ATOM   1359  CA  ARG A 174      19.387  -5.850  19.250  1.00 46.69           C  
ATOM   1360  C   ARG A 174      18.255  -5.274  20.108  1.00 42.43           C  
ATOM   1361  O   ARG A 174      17.240  -4.813  19.585  1.00 39.53           O  
ATOM   1362  CB  ARG A 174      18.870  -6.122  17.835  1.00 47.84           C  
ATOM   1363  CG  ARG A 174      19.877  -6.780  16.909  1.00 48.47           C  
ATOM   1364  CD  ARG A 174      19.224  -7.116  15.580  1.00 48.38           C  
ATOM   1365  NE  ARG A 174      18.731  -5.917  14.908  1.00 49.98           N  
ATOM   1366  CZ  ARG A 174      19.455  -5.162  14.086  1.00 50.54           C  
ATOM   1367  NH1 ARG A 174      20.715  -5.479  13.815  1.00 50.86           N  
ATOM   1368  NH2 ARG A 174      18.919  -4.079  13.542  1.00 51.81           N  
ATOM   1369  N   THR A 175      18.423  -5.318  21.425  1.00 38.42           N  
ATOM   1370  CA  THR A 175      17.416  -4.786  22.339  1.00 37.90           C  
ATOM   1371  C   THR A 175      18.107  -4.058  23.476  1.00 38.10           C  
ATOM   1372  O   THR A 175      19.322  -4.162  23.644  1.00 37.64           O  
ATOM   1373  CB  THR A 175      16.539  -5.896  22.965  1.00 37.18           C  
ATOM   1374  OG1 THR A 175      17.341  -6.697  23.841  1.00 37.47           O  
ATOM   1375  CG2 THR A 175      15.922  -6.785  21.883  1.00 34.73           C  
ATOM   1376  N   VAL A 176      17.330  -3.328  24.265  1.00 38.21           N  
ATOM   1377  CA  VAL A 176      17.891  -2.591  25.387  1.00 38.06           C  
ATOM   1378  C   VAL A 176      16.840  -2.364  26.465  1.00 38.74           C  
ATOM   1379  O   VAL A 176      15.661  -2.147  26.171  1.00 37.66           O  
ATOM   1380  CB  VAL A 176      18.445  -1.216  24.935  1.00 36.33           C  
ATOM   1381  CG1 VAL A 176      17.314  -0.336  24.447  1.00 37.48           C  
ATOM   1382  CG2 VAL A 176      19.177  -0.546  26.083  1.00 36.28           C  
ATOM   1383  N   VAL A 177      17.286  -2.427  27.715  1.00 38.61           N  
ATOM   1384  CA  VAL A 177      16.423  -2.213  28.861  1.00 40.29           C  
ATOM   1385  C   VAL A 177      16.759  -0.859  29.464  1.00 41.64           C  
ATOM   1386  O   VAL A 177      17.911  -0.597  29.806  1.00 41.97           O  
ATOM   1387  CB  VAL A 177      16.644  -3.287  29.947  1.00 41.48           C  
ATOM   1388  CG1 VAL A 177      15.722  -3.029  31.125  1.00 40.31           C  
ATOM   1389  CG2 VAL A 177      16.396  -4.668  29.373  1.00 40.67           C  
ATOM   1390  N   ILE A 178      15.756   0.006  29.569  1.00 43.41           N  
ATOM   1391  CA  ILE A 178      15.946   1.323  30.161  1.00 45.22           C  
ATOM   1392  C   ILE A 178      15.088   1.404  31.417  1.00 46.44           C  
ATOM   1393  O   ILE A 178      13.884   1.159  31.373  1.00 44.96           O  
ATOM   1394  CB  ILE A 178      15.522   2.459  29.201  1.00 47.25           C  
ATOM   1395  CG1 ILE A 178      16.461   2.503  27.996  1.00 46.44           C  
ATOM   1396  CG2 ILE A 178      15.550   3.800  29.936  1.00 45.65           C  
ATOM   1397  CD1 ILE A 178      16.102   3.575  26.991  1.00 50.65           C  
ATOM   1398  N   GLU A 179      15.721   1.727  32.538  1.00 49.00           N  
ATOM   1399  CA  GLU A 179      15.013   1.842  33.806  1.00 51.64           C  
ATOM   1400  C   GLU A 179      14.768   3.312  34.118  1.00 51.96           C  
ATOM   1401  O   GLU A 179      15.665   4.142  33.964  1.00 51.66           O  
ATOM   1402  CB  GLU A 179      15.837   1.206  34.926  1.00 53.34           C  
ATOM   1403  CG  GLU A 179      15.210   1.322  36.302  1.00 56.16           C  
ATOM   1404  CD  GLU A 179      16.133   0.832  37.402  1.00 57.02           C  
ATOM   1405  OE1 GLU A 179      15.739   0.915  38.581  1.00 58.11           O  
ATOM   1406  OE2 GLU A 179      17.250   0.365  37.088  1.00 58.25           O  
ATOM   1407  N   PHE A 180      13.553   3.630  34.548  1.00 53.37           N  
ATOM   1408  CA  PHE A 180      13.200   5.007  34.883  1.00 54.73           C  
ATOM   1409  C   PHE A 180      13.107   5.216  36.390  1.00 54.41           C  
ATOM   1410  O   PHE A 180      12.586   4.364  37.109  1.00 55.71           O  
ATOM   1411  CB  PHE A 180      11.867   5.393  34.229  1.00 54.67           C  
ATOM   1412  CG  PHE A 180      11.922   5.444  32.728  1.00 55.00           C  
ATOM   1413  CD1 PHE A 180      11.890   4.275  31.975  1.00 54.04           C  
ATOM   1414  CD2 PHE A 180      12.030   6.661  32.067  1.00 55.14           C  
ATOM   1415  CE1 PHE A 180      11.966   4.317  30.589  1.00 53.90           C  
ATOM   1416  CE2 PHE A 180      12.107   6.714  30.678  1.00 55.55           C  
ATOM   1417  CZ  PHE A 180      12.074   5.538  29.939  1.00 54.12           C  
ATOM   1418  N   SER A 186       9.979   1.952  40.766  1.00 58.86           N  
ATOM   1419  CA  SER A 186      10.268   2.351  39.389  1.00 57.94           C  
ATOM   1420  C   SER A 186       9.745   1.304  38.413  1.00 56.18           C  
ATOM   1421  O   SER A 186       8.897   0.487  38.768  1.00 55.57           O  
ATOM   1422  CB  SER A 186      11.775   2.513  39.201  1.00 59.47           C  
ATOM   1423  OG  SER A 186      12.432   1.273  39.423  1.00 62.65           O  
ATOM   1424  N   PHE A 187      10.246   1.341  37.180  1.00 53.59           N  
ATOM   1425  CA  PHE A 187       9.828   0.384  36.161  1.00 51.78           C  
ATOM   1426  C   PHE A 187      10.832   0.288  35.025  1.00 50.72           C  
ATOM   1427  O   PHE A 187      11.604   1.215  34.783  1.00 50.55           O  
ATOM   1428  CB  PHE A 187       8.455   0.755  35.594  1.00 49.93           C  
ATOM   1429  CG  PHE A 187       8.440   2.032  34.797  1.00 49.27           C  
ATOM   1430  CD1 PHE A 187       8.577   3.266  35.427  1.00 47.98           C  
ATOM   1431  CD2 PHE A 187       8.254   2.001  33.416  1.00 47.62           C  
ATOM   1432  CE1 PHE A 187       8.527   4.451  34.697  1.00 47.63           C  
ATOM   1433  CE2 PHE A 187       8.203   3.180  32.676  1.00 47.98           C  
ATOM   1434  CZ  PHE A 187       8.338   4.409  33.318  1.00 47.58           C  
ATOM   1435  N   ARG A 188      10.813  -0.846  34.331  1.00 50.08           N  
ATOM   1436  CA  ARG A 188      11.725  -1.089  33.220  1.00 48.41           C  
ATOM   1437  C   ARG A 188      10.989  -1.356  31.917  1.00 45.92           C  
ATOM   1438  O   ARG A 188       9.881  -1.888  31.909  1.00 45.06           O  
ATOM   1439  CB  ARG A 188      12.631  -2.284  33.533  1.00 49.18           C  
ATOM   1440  CG  ARG A 188      13.588  -2.050  34.681  1.00 53.27           C  
ATOM   1441  CD  ARG A 188      14.337  -3.320  35.070  1.00 57.97           C  
ATOM   1442  NE  ARG A 188      13.432  -4.396  35.475  1.00 62.48           N  
ATOM   1443  CZ  ARG A 188      12.904  -5.298  34.648  1.00 64.67           C  
ATOM   1444  NH1 ARG A 188      13.191  -5.275  33.352  1.00 65.63           N  
ATOM   1445  NH2 ARG A 188      12.077  -6.223  35.118  1.00 64.88           N  
ATOM   1446  N   VAL A 189      11.622  -0.983  30.811  1.00 43.42           N  
ATOM   1447  CA  VAL A 189      11.047  -1.195  29.492  1.00 41.57           C  
ATOM   1448  C   VAL A 189      12.136  -1.719  28.567  1.00 39.70           C  
ATOM   1449  O   VAL A 189      13.274  -1.254  28.621  1.00 39.43           O  
ATOM   1450  CB  VAL A 189      10.501   0.121  28.885  1.00 40.83           C  
ATOM   1451  CG1 VAL A 189       9.751  -0.172  27.593  1.00 41.33           C  
ATOM   1452  CG2 VAL A 189       9.595   0.824  29.882  1.00 41.17           C  
ATOM   1453  N   ARG A 190      11.794  -2.700  27.739  1.00 38.52           N  
ATOM   1454  CA  ARG A 190      12.743  -3.244  26.775  1.00 37.36           C  
ATOM   1455  C   ARG A 190      12.324  -2.763  25.385  1.00 34.84           C  
ATOM   1456  O   ARG A 190      11.183  -2.942  24.976  1.00 35.68           O  
ATOM   1457  CB  ARG A 190      12.766  -4.778  26.825  1.00 38.65           C  
ATOM   1458  CG  ARG A 190      13.570  -5.405  25.688  1.00 40.55           C  
ATOM   1459  CD  ARG A 190      13.812  -6.901  25.875  1.00 43.15           C  
ATOM   1460  NE  ARG A 190      14.890  -7.160  26.821  1.00 43.56           N  
ATOM   1461  CZ  ARG A 190      14.717  -7.504  28.091  1.00 46.37           C  
ATOM   1462  NH1 ARG A 190      15.776  -7.709  28.864  1.00 45.62           N  
ATOM   1463  NH2 ARG A 190      13.489  -7.661  28.584  1.00 47.40           N  
ATOM   1464  N   PHE A 191      13.250  -2.131  24.675  1.00 33.19           N  
ATOM   1465  CA  PHE A 191      12.983  -1.614  23.336  1.00 33.27           C  
ATOM   1466  C   PHE A 191      13.791  -2.378  22.301  1.00 31.59           C  
ATOM   1467  O   PHE A 191      14.908  -2.805  22.588  1.00 29.22           O  
ATOM   1468  CB  PHE A 191      13.421  -0.147  23.219  1.00 34.41           C  
ATOM   1469  CG  PHE A 191      12.676   0.805  24.104  1.00 36.96           C  
ATOM   1470  CD1 PHE A 191      11.383   1.202  23.792  1.00 37.72           C  
ATOM   1471  CD2 PHE A 191      13.288   1.336  25.235  1.00 38.44           C  
ATOM   1472  CE1 PHE A 191      10.707   2.123  24.597  1.00 39.21           C  
ATOM   1473  CE2 PHE A 191      12.621   2.255  26.047  1.00 39.28           C  
ATOM   1474  CZ  PHE A 191      11.329   2.650  25.727  1.00 37.35           C  
ATOM   1475  N   ASN A 192      13.236  -2.541  21.101  1.00 30.53           N  
ATOM   1476  CA  ASN A 192      13.984  -3.175  20.016  1.00 30.88           C  
ATOM   1477  C   ASN A 192      14.869  -2.027  19.543  1.00 30.91           C  
ATOM   1478  O   ASN A 192      14.378  -0.916  19.342  1.00 31.42           O  
ATOM   1479  CB  ASN A 192      13.060  -3.612  18.877  1.00 29.33           C  
ATOM   1480  CG  ASN A 192      12.378  -4.931  19.153  1.00 28.57           C  
ATOM   1481  OD1 ASN A 192      13.026  -5.974  19.197  1.00 27.50           O  
ATOM   1482  ND2 ASN A 192      11.063  -4.897  19.335  1.00 24.59           N  
ATOM   1483  N   VAL A 193      16.164  -2.280  19.380  1.00 30.64           N  
ATOM   1484  CA  VAL A 193      17.078  -1.227  18.954  1.00 29.42           C  
ATOM   1485  C   VAL A 193      17.338  -1.255  17.449  1.00 29.56           C  
ATOM   1486  O   VAL A 193      17.771  -2.270  16.903  1.00 28.55           O  
ATOM   1487  CB  VAL A 193      18.439  -1.336  19.679  1.00 30.98           C  
ATOM   1488  CG1 VAL A 193      19.268  -0.086  19.406  1.00 32.07           C  
ATOM   1489  CG2 VAL A 193      18.228  -1.535  21.179  1.00 30.27           C  
ATOM   1490  N   TRP A 194      17.073  -0.135  16.788  1.00 27.53           N  
ATOM   1491  CA  TRP A 194      17.291  -0.025  15.348  1.00 29.07           C  
ATOM   1492  C   TRP A 194      18.274   1.082  14.973  1.00 30.53           C  
ATOM   1493  O   TRP A 194      18.331   2.130  15.619  1.00 30.31           O  
ATOM   1494  CB  TRP A 194      15.974   0.243  14.618  1.00 24.80           C  
ATOM   1495  CG  TRP A 194      15.057  -0.929  14.578  1.00 26.95           C  
ATOM   1496  CD1 TRP A 194      14.030  -1.204  15.439  1.00 24.76           C  
ATOM   1497  CD2 TRP A 194      15.082  -1.994  13.623  1.00 23.77           C  
ATOM   1498  NE1 TRP A 194      13.408  -2.378  15.071  1.00 27.88           N  
ATOM   1499  CE2 TRP A 194      14.037  -2.883  13.959  1.00 24.49           C  
ATOM   1500  CE3 TRP A 194      15.891  -2.284  12.511  1.00 25.38           C  
ATOM   1501  CZ2 TRP A 194      13.773  -4.047  13.222  1.00 24.94           C  
ATOM   1502  CZ3 TRP A 194      15.634  -3.444  11.776  1.00 25.52           C  
ATOM   1503  CH2 TRP A 194      14.578  -4.310  12.137  1.00 25.80           C  
ATOM   1504  N   GLY A 195      19.052   0.826  13.928  1.00 31.35           N  
ATOM   1505  CA  GLY A 195      19.993   1.808  13.434  1.00 33.54           C  
ATOM   1506  C   GLY A 195      19.516   2.135  12.031  1.00 35.32           C  
ATOM   1507  O   GLY A 195      18.875   1.296  11.389  1.00 35.87           O  
ATOM   1508  N   LYS A 196      19.795   3.344  11.553  1.00 34.70           N  
ATOM   1509  CA  LYS A 196      19.376   3.742  10.215  1.00 35.50           C  
ATOM   1510  C   LYS A 196      19.756   2.697   9.153  1.00 33.97           C  
ATOM   1511  O   LYS A 196      18.991   2.453   8.221  1.00 33.04           O  
ATOM   1512  CB  LYS A 196      19.993   5.097   9.858  1.00 37.67           C  
ATOM   1513  CG  LYS A 196      19.471   5.702   8.567  1.00 41.42           C  
ATOM   1514  CD  LYS A 196      20.121   7.061   8.297  1.00 43.79           C  
ATOM   1515  CE  LYS A 196      19.566   7.722   7.036  1.00 45.18           C  
ATOM   1516  NZ  LYS A 196      19.855   6.934   5.796  1.00 45.86           N  
ATOM   1517  N   THR A 197      20.924   2.075   9.299  1.00 31.64           N  
ATOM   1518  CA  THR A 197      21.377   1.072   8.330  1.00 32.70           C  
ATOM   1519  C   THR A 197      20.531  -0.202   8.345  1.00 31.86           C  
ATOM   1520  O   THR A 197      20.339  -0.833   7.308  1.00 33.30           O  
ATOM   1521  CB  THR A 197      22.855   0.659   8.567  1.00 34.04           C  
ATOM   1522  OG1 THR A 197      23.713   1.788   8.363  1.00 35.52           O  
ATOM   1523  CG2 THR A 197      23.259  -0.446   7.598  1.00 35.82           C  
ATOM   1524  N   GLY A 198      20.028  -0.580   9.518  1.00 29.67           N  
ATOM   1525  CA  GLY A 198      19.213  -1.778   9.605  1.00 28.27           C  
ATOM   1526  C   GLY A 198      17.820  -1.551   9.045  1.00 27.60           C  
ATOM   1527  O   GLY A 198      17.267  -2.401   8.342  1.00 25.09           O  
ATOM   1528  N   VAL A 199      17.246  -0.394   9.361  1.00 26.80           N  
ATOM   1529  CA  VAL A 199      15.917  -0.051   8.889  1.00 27.51           C  
ATOM   1530  C   VAL A 199      15.894   0.001   7.365  1.00 28.62           C  
ATOM   1531  O   VAL A 199      15.057  -0.629   6.721  1.00 28.23           O  
ATOM   1532  CB  VAL A 199      15.462   1.320   9.446  1.00 26.52           C  
ATOM   1533  CG1 VAL A 199      14.118   1.720   8.832  1.00 24.34           C  
ATOM   1534  CG2 VAL A 199      15.357   1.245  10.977  1.00 28.14           C  
ATOM   1535  N   GLU A 200      16.835   0.747   6.796  1.00 30.01           N  
ATOM   1536  CA  GLU A 200      16.922   0.909   5.351  1.00 32.20           C  
ATOM   1537  C   GLU A 200      17.174  -0.393   4.603  1.00 31.06           C  
ATOM   1538  O   GLU A 200      16.651  -0.581   3.508  1.00 29.58           O  
ATOM   1539  CB  GLU A 200      18.010   1.917   5.000  1.00 34.19           C  
ATOM   1540  CG  GLU A 200      17.443   3.239   4.482  1.00 43.59           C  
ATOM   1541  CD  GLU A 200      18.223   4.452   4.964  1.00 46.76           C  
ATOM   1542  OE1 GLU A 200      19.460   4.482   4.758  1.00 48.17           O  
ATOM   1543  OE2 GLU A 200      17.577   5.364   5.534  1.00 49.62           O  
ATOM   1544  N   LEU A 201      18.050  -1.241   4.980  1.00 28.29           N  
ATOM   1545  CA  LEU A 201      18.212  -2.634   4.479  1.00 28.67           C  
ATOM   1546  C   LEU A 201      16.890  -3.438   4.262  1.00 28.65           C  
ATOM   1547  O   LEU A 201      16.688  -4.089   3.246  1.00 29.01           O  
ATOM   1548  CB  LEU A 201      19.123  -3.386   5.450  1.00 30.54           C  
ATOM   1549  CG  LEU A 201      19.522  -4.770   4.927  1.00 32.41           C  
ATOM   1550  CD1 LEU A 201      20.118  -4.712   3.520  1.00 30.54           C  
ATOM   1551  CD2 LEU A 201      20.566  -5.458   5.806  1.00 31.15           C  
ATOM   1552  N   LEU A 202      16.013  -3.352   5.279  1.00 28.49           N  
ATOM   1553  CA  LEU A 202      14.790  -4.124   5.177  1.00 26.30           C  
ATOM   1554  C   LEU A 202      13.938  -3.329   4.221  1.00 26.09           C  
ATOM   1555  O   LEU A 202      13.174  -3.922   3.458  1.00 27.32           O  
ATOM   1556  CB  LEU A 202      14.158  -4.279   6.526  1.00 26.33           C  
ATOM   1557  CG  LEU A 202      14.822  -5.271   7.492  1.00 29.51           C  
ATOM   1558  CD1 LEU A 202      14.008  -5.371   8.781  1.00 28.67           C  
ATOM   1559  CD2 LEU A 202      14.913  -6.642   6.836  1.00 27.08           C  
ATOM   1560  N   ALA A 203      14.029  -2.005   4.266  1.00 26.68           N  
ATOM   1561  CA  ALA A 203      13.223  -1.172   3.385  1.00 29.22           C  
ATOM   1562  C   ALA A 203      13.572  -1.443   1.918  1.00 29.11           C  
ATOM   1563  O   ALA A 203      12.684  -1.485   1.064  1.00 27.42           O  
ATOM   1564  CB  ALA A 203      13.438   0.312   3.713  1.00 30.01           C  
ATOM   1565  N   LYS A 204      14.859  -1.647   1.638  1.00 31.21           N  
ATOM   1566  CA  LYS A 204      15.325  -1.905   0.270  1.00 32.93           C  
ATOM   1567  C   LYS A 204      14.715  -3.147  -0.381  1.00 34.27           C  
ATOM   1568  O   LYS A 204      14.809  -3.317  -1.601  1.00 34.23           O  
ATOM   1569  CB  LYS A 204      16.851  -2.027   0.237  1.00 34.16           C  
ATOM   1570  CG  LYS A 204      17.603  -0.733   0.511  1.00 36.43           C  
ATOM   1571  CD  LYS A 204      19.102  -0.955   0.427  1.00 39.26           C  
ATOM   1572  CE  LYS A 204      19.889   0.332   0.687  1.00 42.12           C  
ATOM   1573  NZ  LYS A 204      19.650   1.388  -0.341  1.00 44.83           N  
ATOM   1574  N   LEU A 205      14.100  -4.015   0.419  1.00 33.16           N  
ATOM   1575  CA  LEU A 205      13.484  -5.220  -0.128  1.00 34.97           C  
ATOM   1576  C   LEU A 205      12.112  -4.913  -0.720  1.00 35.07           C  
ATOM   1577  O   LEU A 205      11.616  -5.653  -1.574  1.00 36.41           O  
ATOM   1578  CB  LEU A 205      13.309  -6.299   0.952  1.00 33.55           C  
ATOM   1579  CG  LEU A 205      14.498  -6.720   1.819  1.00 35.79           C  
ATOM   1580  CD1 LEU A 205      14.112  -7.957   2.636  1.00 33.51           C  
ATOM   1581  CD2 LEU A 205      15.714  -7.016   0.951  1.00 35.78           C  
ATOM   1582  N   TYR A 206      11.509  -3.814  -0.280  1.00 34.67           N  
ATOM   1583  CA  TYR A 206      10.170  -3.457  -0.735  1.00 34.56           C  
ATOM   1584  C   TYR A 206      10.006  -2.071  -1.337  1.00 33.85           C  
ATOM   1585  O   TYR A 206       9.042  -1.828  -2.058  1.00 34.74           O  
ATOM   1586  CB  TYR A 206       9.189  -3.601   0.435  1.00 34.41           C  
ATOM   1587  CG  TYR A 206       9.310  -4.927   1.155  1.00 33.42           C  
ATOM   1588  CD1 TYR A 206       8.895  -6.108   0.546  1.00 34.52           C  
ATOM   1589  CD2 TYR A 206       9.904  -5.007   2.417  1.00 35.26           C  
ATOM   1590  CE1 TYR A 206       9.069  -7.339   1.167  1.00 34.30           C  
ATOM   1591  CE2 TYR A 206      10.089  -6.231   3.051  1.00 31.83           C  
ATOM   1592  CZ  TYR A 206       9.670  -7.395   2.419  1.00 34.99           C  
ATOM   1593  OH  TYR A 206       9.866  -8.613   3.022  1.00 33.24           O  
ATOM   1594  N   PHE A 207      10.920  -1.154  -1.043  1.00 33.66           N  
ATOM   1595  CA  PHE A 207      10.769   0.203  -1.563  1.00 34.58           C  
ATOM   1596  C   PHE A 207      12.036   0.838  -2.107  1.00 33.93           C  
ATOM   1597  O   PHE A 207      13.144   0.358  -1.864  1.00 34.19           O  
ATOM   1598  CB  PHE A 207      10.262   1.160  -0.477  1.00 32.45           C  
ATOM   1599  CG  PHE A 207       9.197   0.597   0.415  1.00 35.25           C  
ATOM   1600  CD1 PHE A 207       9.538  -0.079   1.583  1.00 35.29           C  
ATOM   1601  CD2 PHE A 207       7.851   0.799   0.124  1.00 32.13           C  
ATOM   1602  CE1 PHE A 207       8.549  -0.541   2.454  1.00 35.04           C  
ATOM   1603  CE2 PHE A 207       6.861   0.343   0.979  1.00 31.59           C  
ATOM   1604  CZ  PHE A 207       7.203  -0.328   2.144  1.00 32.23           C  
ATOM   1605  N   THR A 208      11.855   1.927  -2.846  1.00 32.01           N  
ATOM   1606  CA  THR A 208      12.949   2.725  -3.363  1.00 35.40           C  
ATOM   1607  C   THR A 208      12.713   4.042  -2.621  1.00 36.06           C  
ATOM   1608  O   THR A 208      11.563   4.429  -2.400  1.00 37.10           O  
ATOM   1609  CB  THR A 208      12.825   2.945  -4.881  1.00 35.38           C  
ATOM   1610  OG1 THR A 208      11.569   3.579  -5.196  1.00 36.27           O  
ATOM   1611  CG2 THR A 208      12.880   1.611  -5.597  1.00 37.01           C  
ATOM   1612  N   LYS A 209      13.769   4.723  -2.195  1.00 38.47           N  
ATOM   1613  CA  LYS A 209      13.521   5.962  -1.470  1.00 40.35           C  
ATOM   1614  C   LYS A 209      13.399   7.204  -2.337  1.00 41.44           C  
ATOM   1615  O   LYS A 209      14.231   7.480  -3.211  1.00 41.41           O  
ATOM   1616  CB  LYS A 209      14.575   6.191  -0.377  1.00 43.27           C  
ATOM   1617  CG  LYS A 209      15.971   6.436  -0.853  1.00 47.12           C  
ATOM   1618  CD  LYS A 209      16.793   7.111   0.244  1.00 49.41           C  
ATOM   1619  CE  LYS A 209      16.810   6.295   1.533  1.00 51.11           C  
ATOM   1620  NZ  LYS A 209      17.743   6.874   2.545  1.00 51.22           N  
ATOM   1621  N   GLU A 210      12.319   7.934  -2.080  1.00 39.93           N  
ATOM   1622  CA  GLU A 210      12.002   9.177  -2.774  1.00 40.32           C  
ATOM   1623  C   GLU A 210      12.808  10.328  -2.167  1.00 39.40           C  
ATOM   1624  O   GLU A 210      13.456  11.082  -2.883  1.00 36.70           O  
ATOM   1625  CB  GLU A 210      10.500   9.481  -2.651  1.00 40.14           C  
ATOM   1626  CG  GLU A 210      10.026  10.691  -3.450  1.00 43.25           C  
ATOM   1627  CD  GLU A 210       8.527  10.935  -3.320  1.00 44.73           C  
ATOM   1628  OE1 GLU A 210       7.755   9.966  -3.436  1.00 43.90           O  
ATOM   1629  OE2 GLU A 210       8.114  12.097  -3.111  1.00 47.01           O  
ATOM   1630  N   ALA A 211      12.773  10.449  -0.840  1.00 38.40           N  
ATOM   1631  CA  ALA A 211      13.491  11.515  -0.149  1.00 39.12           C  
ATOM   1632  C   ALA A 211      13.833  11.123   1.288  1.00 40.20           C  
ATOM   1633  O   ALA A 211      13.370  10.099   1.788  1.00 39.59           O  
ATOM   1634  CB  ALA A 211      12.652  12.783  -0.150  1.00 34.83           C  
ATOM   1635  N   GLU A 212      14.636  11.953   1.949  1.00 41.15           N  
ATOM   1636  CA  GLU A 212      15.030  11.695   3.326  1.00 43.18           C  
ATOM   1637  C   GLU A 212      15.420  12.991   4.024  1.00 44.24           C  
ATOM   1638  O   GLU A 212      16.226  13.765   3.508  1.00 44.29           O  
ATOM   1639  CB  GLU A 212      16.196  10.714   3.357  1.00 44.02           C  
ATOM   1640  CG  GLU A 212      16.481  10.151   4.731  1.00 48.84           C  
ATOM   1641  CD  GLU A 212      17.211   8.826   4.662  1.00 51.28           C  
ATOM   1642  OE1 GLU A 212      18.409   8.811   4.302  1.00 51.68           O  
ATOM   1643  OE2 GLU A 212      16.573   7.791   4.960  1.00 52.63           O  
ATOM   1644  N   GLU A 213      14.837  13.226   5.195  1.00 44.36           N  
ATOM   1645  CA  GLU A 213      15.114  14.431   5.967  1.00 45.03           C  
ATOM   1646  C   GLU A 213      15.705  14.053   7.320  1.00 46.07           C  
ATOM   1647  O   GLU A 213      15.157  13.201   8.025  1.00 45.81           O  
ATOM   1648  CB  GLU A 213      13.825  15.216   6.214  1.00 45.84           C  
ATOM   1649  CG  GLU A 213      13.028  15.619   4.978  1.00 48.18           C  
ATOM   1650  CD  GLU A 213      13.534  16.896   4.316  1.00 47.87           C  
ATOM   1651  OE1 GLU A 213      14.208  17.704   4.993  1.00 47.22           O  
ATOM   1652  OE2 GLU A 213      13.234  17.098   3.121  1.00 45.83           O  
ATOM   1653  N   LYS A 214      16.814  14.686   7.690  1.00 45.33           N  
ATOM   1654  CA  LYS A 214      17.425  14.412   8.983  1.00 45.39           C  
ATOM   1655  C   LYS A 214      16.760  15.320  10.013  1.00 44.82           C  
ATOM   1656  O   LYS A 214      16.678  16.528   9.823  1.00 45.35           O  
ATOM   1657  CB  LYS A 214      18.928  14.672   8.940  1.00 46.61           C  
ATOM   1658  CG  LYS A 214      19.662  14.159  10.172  1.00 50.70           C  
ATOM   1659  CD  LYS A 214      21.152  13.997   9.909  1.00 54.92           C  
ATOM   1660  CE  LYS A 214      21.826  13.227  11.035  1.00 57.10           C  
ATOM   1661  NZ  LYS A 214      23.268  12.982  10.757  1.00 57.42           N  
ATOM   1662  N   VAL A 215      16.276  14.726  11.098  1.00 44.41           N  
ATOM   1663  CA  VAL A 215      15.594  15.469  12.153  1.00 44.34           C  
ATOM   1664  C   VAL A 215      16.351  15.330  13.467  1.00 44.76           C  
ATOM   1665  O   VAL A 215      16.618  14.222  13.929  1.00 43.09           O  
ATOM   1666  CB  VAL A 215      14.149  14.948  12.349  1.00 45.60           C  
ATOM   1667  CG1 VAL A 215      13.429  15.776  13.410  1.00 45.01           C  
ATOM   1668  CG2 VAL A 215      13.396  14.998  11.024  1.00 43.69           C  
ATOM   1669  N   GLY A 216      16.699  16.460  14.065  1.00 45.26           N  
ATOM   1670  CA  GLY A 216      17.427  16.421  15.315  1.00 46.90           C  
ATOM   1671  C   GLY A 216      18.813  15.846  15.113  1.00 48.29           C  
ATOM   1672  O   GLY A 216      19.374  15.928  14.020  1.00 47.29           O  
ATOM   1673  N   ASN A 217      19.361  15.249  16.164  1.00 50.02           N  
ATOM   1674  CA  ASN A 217      20.697  14.675  16.096  1.00 52.93           C  
ATOM   1675  C   ASN A 217      20.758  13.292  15.469  1.00 53.21           C  
ATOM   1676  O   ASN A 217      21.754  12.947  14.835  1.00 54.48           O  
ATOM   1677  CB  ASN A 217      21.321  14.640  17.490  1.00 54.99           C  
ATOM   1678  CG  ASN A 217      21.795  16.006  17.946  1.00 57.26           C  
ATOM   1679  OD1 ASN A 217      22.096  16.210  19.123  1.00 60.41           O  
ATOM   1680  ND2 ASN A 217      21.875  16.950  17.012  1.00 57.03           N  
ATOM   1681  N   TYR A 218      19.703  12.501  15.630  1.00 52.67           N  
ATOM   1682  CA  TYR A 218      19.710  11.166  15.050  1.00 52.24           C  
ATOM   1683  C   TYR A 218      18.364  10.595  14.631  1.00 48.01           C  
ATOM   1684  O   TYR A 218      18.148   9.391  14.711  1.00 48.69           O  
ATOM   1685  CB  TYR A 218      20.418  10.196  16.000  1.00 57.40           C  
ATOM   1686  CG  TYR A 218      21.882   9.999  15.661  1.00 63.81           C  
ATOM   1687  CD1 TYR A 218      22.835   9.826  16.666  1.00 65.85           C  
ATOM   1688  CD2 TYR A 218      22.311   9.972  14.330  1.00 65.04           C  
ATOM   1689  CE1 TYR A 218      24.186   9.633  16.353  1.00 68.34           C  
ATOM   1690  CE2 TYR A 218      23.653   9.777  14.008  1.00 67.79           C  
ATOM   1691  CZ  TYR A 218      24.585   9.609  15.022  1.00 68.55           C  
ATOM   1692  OH  TYR A 218      25.911   9.414  14.706  1.00 70.17           O  
ATOM   1693  N   SER A 219      17.465  11.455  14.169  1.00 43.61           N  
ATOM   1694  CA  SER A 219      16.155  11.000  13.721  1.00 42.19           C  
ATOM   1695  C   SER A 219      15.993  11.259  12.233  1.00 40.30           C  
ATOM   1696  O   SER A 219      16.609  12.176  11.679  1.00 40.38           O  
ATOM   1697  CB  SER A 219      15.050  11.698  14.514  1.00 40.60           C  
ATOM   1698  OG  SER A 219      15.063  11.252  15.854  1.00 42.03           O  
ATOM   1699  N   TYR A 220      15.164  10.446  11.584  1.00 38.92           N  
ATOM   1700  CA  TYR A 220      14.960  10.569  10.142  1.00 37.01           C  
ATOM   1701  C   TYR A 220      13.535  10.435   9.660  1.00 34.95           C  
ATOM   1702  O   TYR A 220      12.772   9.604  10.154  1.00 34.08           O  
ATOM   1703  CB  TYR A 220      15.782   9.512   9.410  1.00 38.27           C  
ATOM   1704  CG  TYR A 220      17.249   9.588   9.703  1.00 39.71           C  
ATOM   1705  CD1 TYR A 220      18.088  10.418   8.960  1.00 40.10           C  
ATOM   1706  CD2 TYR A 220      17.792   8.874  10.762  1.00 39.98           C  
ATOM   1707  CE1 TYR A 220      19.430  10.533   9.273  1.00 41.83           C  
ATOM   1708  CE2 TYR A 220      19.125   8.982  11.085  1.00 42.71           C  
ATOM   1709  CZ  TYR A 220      19.941   9.812  10.341  1.00 42.28           C  
ATOM   1710  OH  TYR A 220      21.265   9.921  10.682  1.00 47.03           O  
ATOM   1711  N   LEU A 221      13.178  11.266   8.685  1.00 34.49           N  
ATOM   1712  CA  LEU A 221      11.871  11.207   8.058  1.00 34.85           C  
ATOM   1713  C   LEU A 221      12.212  10.694   6.671  1.00 32.98           C  
ATOM   1714  O   LEU A 221      12.946  11.351   5.937  1.00 34.67           O  
ATOM   1715  CB  LEU A 221      11.232  12.588   7.936  1.00 35.50           C  
ATOM   1716  CG  LEU A 221       9.904  12.527   7.188  1.00 38.26           C  
ATOM   1717  CD1 LEU A 221       8.826  11.998   8.113  1.00 34.37           C  
ATOM   1718  CD2 LEU A 221       9.538  13.901   6.674  1.00 39.66           C  
ATOM   1719  N   THR A 222      11.701   9.519   6.319  1.00 32.36           N  
ATOM   1720  CA  THR A 222      11.992   8.943   5.009  1.00 30.55           C  
ATOM   1721  C   THR A 222      10.749   8.760   4.150  1.00 30.82           C  
ATOM   1722  O   THR A 222       9.702   8.349   4.642  1.00 30.21           O  
ATOM   1723  CB  THR A 222      12.682   7.574   5.148  1.00 32.20           C  
ATOM   1724  OG1 THR A 222      13.876   7.716   5.925  1.00 34.49           O  
ATOM   1725  CG2 THR A 222      13.047   7.034   3.772  1.00 34.86           C  
ATOM   1726  N   VAL A 223      10.870   9.068   2.862  1.00 30.55           N  
ATOM   1727  CA  VAL A 223       9.758   8.916   1.933  1.00 31.32           C  
ATOM   1728  C   VAL A 223      10.073   7.765   0.974  1.00 30.79           C  
ATOM   1729  O   VAL A 223      11.065   7.799   0.252  1.00 30.38           O  
ATOM   1730  CB  VAL A 223       9.513  10.223   1.140  1.00 32.34           C  
ATOM   1731  CG1 VAL A 223       8.342  10.045   0.185  1.00 32.32           C  
ATOM   1732  CG2 VAL A 223       9.211  11.364   2.116  1.00 35.20           C  
ATOM   1733  N   TYR A 224       9.219   6.747   0.976  1.00 31.10           N  
ATOM   1734  CA  TYR A 224       9.419   5.568   0.138  1.00 31.74           C  
ATOM   1735  C   TYR A 224       8.321   5.341  -0.898  1.00 31.89           C  
ATOM   1736  O   TYR A 224       7.167   5.699  -0.686  1.00 32.76           O  
ATOM   1737  CB  TYR A 224       9.514   4.310   1.019  1.00 30.18           C  
ATOM   1738  CG  TYR A 224      10.815   4.152   1.778  1.00 29.81           C  
ATOM   1739  CD1 TYR A 224      12.010   3.911   1.105  1.00 31.39           C  
ATOM   1740  CD2 TYR A 224      10.848   4.226   3.168  1.00 29.57           C  
ATOM   1741  CE1 TYR A 224      13.203   3.744   1.793  1.00 30.41           C  
ATOM   1742  CE2 TYR A 224      12.038   4.056   3.872  1.00 28.49           C  
ATOM   1743  CZ  TYR A 224      13.210   3.816   3.177  1.00 31.40           C  
ATOM   1744  OH  TYR A 224      14.392   3.644   3.859  1.00 34.81           O  
ATOM   1745  N   ASN A 225       8.699   4.730  -2.017  1.00 32.08           N  
ATOM   1746  CA  ASN A 225       7.756   4.399  -3.079  1.00 32.48           C  
ATOM   1747  C   ASN A 225       7.803   2.878  -3.200  1.00 34.06           C  
ATOM   1748  O   ASN A 225       8.882   2.288  -3.226  1.00 32.33           O  
ATOM   1749  CB  ASN A 225       8.185   5.040  -4.398  1.00 33.63           C  
ATOM   1750  CG  ASN A 225       8.196   6.556  -4.335  1.00 33.37           C  
ATOM   1751  OD1 ASN A 225       8.954   7.208  -5.046  1.00 32.11           O  
ATOM   1752  ND2 ASN A 225       7.343   7.124  -3.485  1.00 34.59           N  
ATOM   1753  N   PRO A 226       6.633   2.226  -3.271  1.00 35.30           N  
ATOM   1754  CA  PRO A 226       6.530   0.770  -3.385  1.00 38.84           C  
ATOM   1755  C   PRO A 226       7.016   0.213  -4.717  1.00 42.01           C  
ATOM   1756  O   PRO A 226       6.953   0.888  -5.742  1.00 42.42           O  
ATOM   1757  CB  PRO A 226       5.041   0.520  -3.171  1.00 38.38           C  
ATOM   1758  CG  PRO A 226       4.423   1.725  -3.790  1.00 36.46           C  
ATOM   1759  CD  PRO A 226       5.292   2.842  -3.267  1.00 36.64           C  
ATOM   1760  N   LYS A 227       7.509  -1.022  -4.687  1.00 45.34           N  
ATOM   1761  CA  LYS A 227       7.988  -1.688  -5.890  1.00 49.31           C  
ATOM   1762  C   LYS A 227       6.908  -2.637  -6.402  1.00 51.44           C  
ATOM   1763  O   LYS A 227       5.918  -2.854  -5.668  1.00 50.73           O  
ATOM   1764  CB  LYS A 227       9.255  -2.489  -5.598  1.00 50.19           C  
ATOM   1765  CG  LYS A 227      10.425  -1.664  -5.111  1.00 51.39           C  
ATOM   1766  CD  LYS A 227      11.683  -2.510  -5.092  1.00 53.44           C  
ATOM   1767  CE  LYS A 227      12.873  -1.721  -4.589  1.00 53.54           C  
ATOM   1768  NZ  LYS A 227      14.131  -2.462  -4.838  1.00 53.39           N  
ATOM   1769  OXT LYS A 227       7.079  -3.159  -7.526  1.00 55.05           O  
TER    1770      LYS A 227                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
