
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  247 ( 2000),  selected  247 , name 2avn_A
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 2avn_A.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     0_A      M       1           -
LGA    -       -      S       2           -
LGA    -       -      E       3           -
LGA    -       -      N       4           -
LGA    X     1_A      K       5          6.244
LGA    K     2_A      -       -           -
LGA    L     3_A      K       6          3.750
LGA    R     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    W     6_A      -       -           -
LGA    E     7_A      -       -           -
LGA    F     8_A      K       7          1.882
LGA    Y     9_A      F       8          1.644
LGA    D    10_A      D       9          2.180
LGA    R    11_A      K      10          2.460
LGA    I    12_A      K      11          2.997
LGA    -       -      G      12           -
LGA    A    13_A      A      13          1.681
LGA    R    14_A      K      14          2.612
LGA    A    15_A      N      15          3.341
LGA    Y    16_A      M      16          1.959
LGA    D    17_A      D      17          2.546
LGA    S    18_A      E      18          1.890
LGA    X    19_A      I      19          1.775
LGA    Y    20_A      S      20          3.963
LGA    -       -      K      21           -
LGA    E    21_A      T      22          2.209
LGA    T    22_A      L      23          2.397
LGA    P    23_A      -       -           -
LGA    K    24_A      -       -           -
LGA    W    25_A      F      24          3.306
LGA    K    26_A      A      25          4.760
LGA    L    27_A      P      26           #
LGA    Y    28_A      I      27          3.925
LGA    H    29_A      Y      28          3.499
LGA    R    30_A      P      29          4.906
LGA    L    31_A      I      30          3.918
LGA    I    32_A      I      31          1.645
LGA    G    33_A      A      32          2.660
LGA    S    34_A      E      33          2.854
LGA    F    35_A      N      34          1.443
LGA    L    36_A      I      35          1.309
LGA    E    37_A      I      36          1.717
LGA    E    38_A      N      37          1.452
LGA    Y    39_A      R      38          2.811
LGA    L    40_A      F      39          4.097
LGA    K    41_A      G      40          1.654
LGA    N    42_A      I      41          3.223
LGA    P    43_A      T      42          2.747
LGA    -       -      A      43           -
LGA    C    44_A      G      44          1.667
LGA    R    45_A      N      45          0.563
LGA    V    46_A      C      46          0.701
LGA    L    47_A      I      47          0.785
LGA    D    48_A      D      48          0.928
LGA    L    49_A      I      49          0.872
LGA    G    50_A      G      50          0.759
LGA    G    51_A      S      51          0.677
LGA    G    52_A      G      52          0.846
LGA    T    53_A      P      53          1.047
LGA    G    54_A      G      54          1.077
LGA    K    55_A      A      55          0.923
LGA    W    56_A      L      56          1.609
LGA    S    57_A      S      57          1.447
LGA    L    58_A      I      58          1.611
LGA    F    59_A      A      59          2.028
LGA    L    60_A      L      60          2.467
LGA    Q    61_A      A      61          2.493
LGA    E    62_A      K      62          2.821
LGA    R    63_A      Q      63          3.533
LGA    -       -      S      64           -
LGA    G    64_A      D      65          1.484
LGA    F    65_A      F      66          0.510
LGA    E    66_A      S      67          0.764
LGA    V    67_A      I      68          0.692
LGA    V    68_A      R      69          0.731
LGA    L    69_A      A      70          0.881
LGA    V    70_A      L      71          0.789
LGA    D    71_A      D      72          0.552
LGA    P    72_A      F      73          0.726
LGA    S    73_A      S      74          0.764
LGA    K    74_A      K      75          0.711
LGA    E    75_A      H      76          1.377
LGA    X    76_A      M      77          1.024
LGA    L    77_A      N      78          0.792
LGA    E    78_A      E      79          1.170
LGA    V    79_A      I      80          1.235
LGA    A    80_A      A      81          1.273
LGA    R    81_A      L      82          1.165
LGA    E    82_A      K      83          1.225
LGA    K    83_A      N      84          1.638
LGA    G    84_A      I      85          1.981
LGA    V    85_A      A      86           #
LGA    -       -      D      87           -
LGA    -       -      A      88           -
LGA    -       -      D      89           -
LGA    -       -      L      90           -
LGA    -       -      N      91           -
LGA    -       -      D      92           -
LGA    -       -      R      93           -
LGA    K    86_A      I      94          3.646
LGA    N    87_A      Q      95          0.976
LGA    V    88_A      I      96          1.095
LGA    V    89_A      V      97          1.153
LGA    E    90_A      Q      98          0.721
LGA    A    91_A      G      99          0.445
LGA    K    92_A      D     100          0.566
LGA    A    93_A      V     101          0.308
LGA    E    94_A      H     102          0.489
LGA    D    95_A      N     103          0.573
LGA    L    96_A      I     104          0.593
LGA    P    97_A      P     105          1.175
LGA    F    98_A      I     106          1.029
LGA    P    99_A      E     107          1.042
LGA    S   100_A      D     108          0.520
LGA    G   101_A      N     109          0.307
LGA    A   102_A      Y     110          0.654
LGA    F   103_A      A     111          0.607
LGA    E   104_A      D     112          0.921
LGA    A   105_A      L     113          1.175
LGA    V   106_A      I     114          0.976
LGA    L   107_A      V     115          0.975
LGA    A   108_A      S     116          1.382
LGA    L   109_A      R     117          1.183
LGA    G   110_A      G     118          2.017
LGA    D   111_A      -       -           -
LGA    V   112_A      S     119          0.829
LGA    L   113_A      V     120          1.028
LGA    S   114_A      F     121          0.878
LGA    Y   115_A      F     122          0.877
LGA    V   116_A      W     123          1.242
LGA    E   117_A      E     124          1.294
LGA    N   118_A      D     125          1.328
LGA    K   119_A      V     126          0.518
LGA    D   120_A      T     127          0.923
LGA    K   121_A      T     128          0.849
LGA    A   122_A      A     129          0.404
LGA    F   123_A      F     130          0.234
LGA    S   124_A      R     131          0.515
LGA    E   125_A      E     132          0.197
LGA    I   126_A      I     133          0.203
LGA    R   127_A      Y     134          0.193
LGA    R   128_A      R     135          0.221
LGA    V   129_A      I     136          0.273
LGA    L   130_A      L     137          0.465
LGA    V   131_A      K     138          1.095
LGA    P   132_A      S     139          1.631
LGA    D   133_A      G     140          2.448
LGA    G   134_A      G     141          1.361
LGA    L   135_A      K     142          1.266
LGA    L   136_A      T     143          1.524
LGA    I   137_A      Y     144          0.582
LGA    A   138_A      I     145          1.325
LGA    T   139_A      G     146          1.461
LGA    -       -      G     147           -
LGA    V   140_A      G     148           #
LGA    D   141_A      F     149           -
LGA    N   142_A      G     150           -
LGA    F   143_A      N     151           -
LGA    Y   144_A      K     152           -
LGA    -       -      E     153           -
LGA    -       -      L     154           -
LGA    -       -      R     155           -
LGA    -       -      D     156           -
LGA    -       -      S     157           -
LGA    -       -      I     158           -
LGA    -       -      S     159           -
LGA    -       -      A     160           -
LGA    -       -      E     161           -
LGA    -       -      M     162           -
LGA    -       -      I     163           -
LGA    -       -      R     164           -
LGA    -       -      K     165           -
LGA    -       -      N     166           -
LGA    -       -      P     167           -
LGA    -       -      D     168           -
LGA    -       -      W     169           -
LGA    -       -      K     170           -
LGA    -       -      E     171           -
LGA    -       -      F     172           -
LGA    T   145_A      N     173          5.204
LGA    F   146_A      R     174          3.987
LGA    L   147_A      K     175           #
LGA    Q   148_A      -       -           -
LGA    Q   149_A      -       -           -
LGA    X   150_A      -       -           -
LGA    I   151_A      -       -           -
LGA    E   152_A      -       -           -
LGA    K   153_A      -       -           -
LGA    D   154_A      -       -           -
LGA    A   155_A      -       -           -
LGA    W   156_A      -       -           -
LGA    D   157_A      -       -           -
LGA    Q   158_A      -       -           -
LGA    I   159_A      -       -           -
LGA    T   160_A      -       -           -
LGA    R   161_A      -       -           -
LGA    F   162_A      -       -           -
LGA    L   163_A      -       -           -
LGA    K   164_A      -       -           -
LGA    T   165_A      -       -           -
LGA    Q   166_A      -       -           -
LGA    T   167_A      -       -           -
LGA    T   168_A      -       -           -
LGA    S   169_A      -       -           -
LGA    V   170_A      -       -           -
LGA    G   171_A      -       -           -
LGA    T   172_A      -       -           -
LGA    T   173_A      -       -           -
LGA    L   174_A      -       -           -
LGA    F   175_A      -       -           -
LGA    S   176_A      -       -           -
LGA    F   177_A      -       -           -
LGA    N   178_A      -       -           -
LGA    S   179_A      -       -           -
LGA    Y   180_A      -       -           -
LGA    A   181_A      N     176          4.216
LGA    F   182_A      I     177           #
LGA    -       -      S     178           -
LGA    -       -      Q     179           -
LGA    -       -      E     180           -
LGA    K   183_A      N     181          2.652
LGA    P   184_A      V     182          2.446
LGA    E   185_A      E     183          1.566
LGA    D   186_A      R     184          1.749
LGA    L   187_A      F     185          3.068
LGA    D   188_A      Q     186          2.119
LGA    S   189_A      N     187          5.489
LGA    -       -      V     188           -
LGA    L   190_A      L     189          1.234
LGA    -       -      D     190           -
LGA    -       -      E     191           -
LGA    E   191_A      I     192          2.454
LGA    G   192_A      G     193          4.007
LGA    F   193_A      V     194          3.059
LGA    -       -      S     195           -
LGA    E   194_A      S     196          2.144
LGA    T   195_A      Y     197          2.100
LGA    V   196_A      E     198          2.758
LGA    D   197_A      I     199          4.817
LGA    I   198_A      I     200          0.648
LGA    R   199_A      L     201          2.934
LGA    G   200_A      E     202          2.183
LGA    I   201_A      D     203          3.980
LGA    G   202_A      E     204           #
LGA    V   203_A      -       -           -
LGA    X   204_A      -       -           -
LGA    E   205_A      -       -           -
LGA    Y   206_A      -       -           -
LGA    P   207_A      -       -           -
LGA    D   208_A      -       -           -
LGA    E   209_A      -       -           -
LGA    R   210_A      -       -           -
LGA    I   211_A      -       -           -
LGA    S   212_A      -       -           -
LGA    E   213_A      -       -           -
LGA    R   214_A      -       -           -
LGA    E   215_A      -       -           -
LGA    E   216_A      -       -           -
LGA    T   217_A      -       -           -
LGA    I   218_A      -       -           -
LGA    F   219_A      -       -           -
LGA    R   220_A      -       -           -
LGA    L   221_A      -       -           -
LGA    E   222_A      -       -           -
LGA    Q   223_A      -       -           -
LGA    E   224_A      -       -           -
LGA    L   225_A      -       -           -
LGA    S   226_A      -       -           -
LGA    R   227_A      -       -           -
LGA    D   228_A      -       -           -
LGA    R   229_A      -       -           -
LGA    N   230_A      -       -           -
LGA    I   231_A      -       -           -
LGA    I   232_A      -       -           -
LGA    W   233_A      -       -           -
LGA    K   234_A      -       -           -
LGA    A   235_A      -       -           -
LGA    D   236_A      -       -           -
LGA    H   237_A      G     205          4.566
LGA    I   238_A      F     206          1.553
LGA    F   239_A      W     207          2.451
LGA    F   240_A      I     208          3.047
LGA    V   241_A      I     209          1.552
LGA    L   242_A      I     210          1.674
LGA    K   243_A      S     211          1.214
LGA    K   244_A      K     212          2.004
LGA    K   245_A      T     213          3.225
LGA    R   246_A      D     214          1.812
LGA    -       -      Q     215           -
LGA    -       -      E     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  247  218    5.0    161    2.16    19.88     60.241     7.127

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.282282 * X  +   0.123272 * Y  +  -0.951378 * Z  +  18.489149
  Y_new =  -0.422153 * X  +   0.874568 * Y  +   0.238576 * Z  +  -0.453464
  Z_new =   0.861455 * X  +   0.468972 * Y  +  -0.194835 * Z  + -31.172066 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.964551   -1.177042  [ DEG:   112.5605    -67.4395 ]
  Theta =  -1.038127   -2.103466  [ DEG:   -59.4803   -120.5197 ]
  Phi   =  -2.160186    0.981406  [ DEG:  -123.7696     56.2304 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2avn_A                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2avn_A.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  247  218   5.0  161   2.16   19.88  60.241
REMARK  ---------------------------------------------------------- 
MOLECULE 2avn_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   30-AUG-05   2AVN              
TITLE     CRYSTAL STRUCTURE OF UBIQUINONE/MENAQUINONE BIOSYNTHESIS              
TITLE    2 METHYLTRANSFERASE-RELATED PROTEIN (TM1389) FROM THERMOTOGA           
TITLE    3 MARITIMA AT 2.35 A RESOLUTION                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UBIQUINONE/MENAQUINONE BIOSYNTHESIS                        
COMPND   3 METHYLTRANSFERASE-RELATED PROTEIN;                                   
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA MSB8;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: TM1389;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: HK100                                     
KEYWDS    TM1389, UBIQUINONE/MENAQUINONE BIOSYNTHESIS                           
KEYWDS   2 METHYLTRANSFERASE-RELATED PROTEIN, STRUCTURAL GENOMICS,              
KEYWDS   3 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   4 STRUCTURE INITIATIVE, PSI                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   18-OCT-05 2AVN    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UBIQUINONE/MENAQUINONE                  
JRNL        TITL 2 BIOSYNTHESIS METHYLTRANSFERASE-RELATED PROTEIN               
JRNL        TITL 3 (TM1389) FROM THERMOTOGA MARITIMA AT 2.35 A                  
JRNL        TITL 4 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.35 ANGSTROMS.                                          
DBREF  2AVN A    1   248  UNP    Q9X1A9   Q9X1A9_THEMA     1    248             
DBREF  2AVN B    1   248  UNP    Q9X1A9   Q9X1A9_THEMA     1    248             
SEQRES   1 A  260  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 A  260  LYS LEU ARG SER TRP GLU PHE TYR ASP ARG ILE ALA ARG          
SEQRES   3 A  260  ALA TYR ASP SER MSE TYR GLU THR PRO LYS TRP LYS LEU          
SEQRES   4 A  260  TYR HIS ARG LEU ILE GLY SER PHE LEU GLU GLU TYR LEU          
SEQRES   5 A  260  LYS ASN PRO CYS ARG VAL LEU ASP LEU GLY GLY GLY THR          
SEQRES   6 A  260  GLY LYS TRP SER LEU PHE LEU GLN GLU ARG GLY PHE GLU          
SEQRES   7 A  260  VAL VAL LEU VAL ASP PRO SER LYS GLU MSE LEU GLU VAL          
SEQRES   8 A  260  ALA ARG GLU LYS GLY VAL LYS ASN VAL VAL GLU ALA LYS          
SEQRES   9 A  260  ALA GLU ASP LEU PRO PHE PRO SER GLY ALA PHE GLU ALA          
SEQRES  10 A  260  VAL LEU ALA LEU GLY ASP VAL LEU SER TYR VAL GLU ASN          
SEQRES  11 A  260  LYS ASP LYS ALA PHE SER GLU ILE ARG ARG VAL LEU VAL          
SEQRES  12 A  260  PRO ASP GLY LEU LEU ILE ALA THR VAL ASP ASN PHE TYR          
SEQRES  13 A  260  THR PHE LEU GLN GLN MSE ILE GLU LYS ASP ALA TRP ASP          
SEQRES  14 A  260  GLN ILE THR ARG PHE LEU LYS THR GLN THR THR SER VAL          
SEQRES  15 A  260  GLY THR THR LEU PHE SER PHE ASN SER TYR ALA PHE LYS          
SEQRES  16 A  260  PRO GLU ASP LEU ASP SER LEU GLU GLY PHE GLU THR VAL          
SEQRES  17 A  260  ASP ILE ARG GLY ILE GLY VAL MSE GLU TYR PRO ASP GLU          
SEQRES  18 A  260  ARG ILE SER GLU ARG GLU GLU THR ILE PHE ARG LEU GLU          
SEQRES  19 A  260  GLN GLU LEU SER ARG ASP ARG ASN ILE ILE TRP LYS ALA          
SEQRES  20 A  260  ASP HIS ILE PHE PHE VAL LEU LYS LYS LYS ARG GLY ALA          
SEQRES   1 B  260  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 B  260  LYS LEU ARG SER TRP GLU PHE TYR ASP ARG ILE ALA ARG          
SEQRES   3 B  260  ALA TYR ASP SER MSE TYR GLU THR PRO LYS TRP LYS LEU          
SEQRES   4 B  260  TYR HIS ARG LEU ILE GLY SER PHE LEU GLU GLU TYR LEU          
SEQRES   5 B  260  LYS ASN PRO CYS ARG VAL LEU ASP LEU GLY GLY GLY THR          
SEQRES   6 B  260  GLY LYS TRP SER LEU PHE LEU GLN GLU ARG GLY PHE GLU          
SEQRES   7 B  260  VAL VAL LEU VAL ASP PRO SER LYS GLU MSE LEU GLU VAL          
SEQRES   8 B  260  ALA ARG GLU LYS GLY VAL LYS ASN VAL VAL GLU ALA LYS          
SEQRES   9 B  260  ALA GLU ASP LEU PRO PHE PRO SER GLY ALA PHE GLU ALA          
SEQRES  10 B  260  VAL LEU ALA LEU GLY ASP VAL LEU SER TYR VAL GLU ASN          
SEQRES  11 B  260  LYS ASP LYS ALA PHE SER GLU ILE ARG ARG VAL LEU VAL          
SEQRES  12 B  260  PRO ASP GLY LEU LEU ILE ALA THR VAL ASP ASN PHE TYR          
SEQRES  13 B  260  THR PHE LEU GLN GLN MSE ILE GLU LYS ASP ALA TRP ASP          
SEQRES  14 B  260  GLN ILE THR ARG PHE LEU LYS THR GLN THR THR SER VAL          
SEQRES  15 B  260  GLY THR THR LEU PHE SER PHE ASN SER TYR ALA PHE LYS          
SEQRES  16 B  260  PRO GLU ASP LEU ASP SER LEU GLU GLY PHE GLU THR VAL          
SEQRES  17 B  260  ASP ILE ARG GLY ILE GLY VAL MSE GLU TYR PRO ASP GLU          
SEQRES  18 B  260  ARG ILE SER GLU ARG GLU GLU THR ILE PHE ARG LEU GLU          
SEQRES  19 B  260  GLN GLU LEU SER ARG ASP ARG ASN ILE ILE TRP LYS ALA          
SEQRES  20 B  260  ASP HIS ILE PHE PHE VAL LEU LYS LYS LYS ARG GLY ALA          
HET    MSE  A   1       8                                                       
HET    MSE  A  19       8                                                       
HET    MSE  A  76       8                                                       
HET    MSE  A 150       8                                                       
HET    MSE  A 204       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  19       8                                                       
HET    MSE  B  76       8                                                       
HET    MSE  B 150       8                                                       
HET    MSE  B 204       8                                                       
HET    PO4      1       5                                                       
HET    SAI   1300      26                                                       
HET    SAI   2300      26                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     SAI S-ADENOSYL-L-HOMOSELENOCYSTEINE                                  
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   3  PO4    O4 P 3-                                                      
FORMUL   4  SAI    2(C14 H20 N6 O5 SE)                                          
FORMUL   6  HOH   *210(H2 O)                                                    
CRYST1  130.475  130.475  192.926  90.00  90.00 120.00 P 64 2 2     24          
ATOM      1  N   HIS A   0      11.629  -5.182  36.499  1.00 79.64           N  
ATOM      2  CA  HIS A   0      10.695  -4.733  35.408  1.00 80.42           C  
ATOM      3  C   HIS A   0       9.762  -5.852  34.994  1.00 79.81           C  
ATOM      4  O   HIS A   0      10.187  -7.000  34.885  1.00 80.46           O  
ATOM      5  CB  HIS A   0      11.450  -4.297  34.146  1.00 81.11           C  
ATOM      6  CG  HIS A   0      12.188  -3.005  34.286  1.00 82.52           C  
ATOM      7  ND1 HIS A   0      13.563  -2.945  34.376  1.00 84.04           N  
ATOM      8  CD2 HIS A   0      11.746  -1.725  34.349  1.00 80.47           C  
ATOM      9  CE1 HIS A   0      13.937  -1.684  34.493  1.00 86.89           C  
ATOM     10  NE2 HIS A   0      12.854  -0.923  34.479  1.00 87.27           N  
HETATM   11  N   MSE A   1       8.501  -5.520  34.739  1.00 79.02           N  
HETATM   12  CA  MSE A   1       7.594  -6.481  34.130  1.00 78.31           C  
HETATM   13  C   MSE A   1       7.687  -6.322  32.630  1.00 72.24           C  
HETATM   14  O   MSE A   1       7.503  -5.230  32.113  1.00 70.95           O  
HETATM   15  CB  MSE A   1       6.155  -6.254  34.562  1.00 81.44           C  
HETATM   16  CG  MSE A   1       5.411  -7.540  34.831  1.00 89.05           C  
HETATM   17 SE   MSE A   1       5.311  -7.809  36.772  1.00117.27          SE  
HETATM   18  CE  MSE A   1       3.670  -8.863  36.961  1.00 99.88           C  
ATOM     19  N   LYS A   2       7.965  -7.417  31.942  1.00 66.47           N  
ATOM     20  CA  LYS A   2       8.158  -7.392  30.511  1.00 63.44           C  
ATOM     21  C   LYS A   2       6.817  -7.565  29.788  1.00 60.56           C  
ATOM     22  O   LYS A   2       6.198  -8.618  29.867  1.00 59.60           O  
ATOM     23  CB  LYS A   2       9.140  -8.490  30.102  1.00 62.75           C  
ATOM     24  N   LEU A   3       6.386  -6.530  29.073  1.00 55.53           N  
ATOM     25  CA  LEU A   3       5.110  -6.545  28.389  1.00 52.12           C  
ATOM     26  C   LEU A   3       5.274  -6.565  26.886  1.00 50.33           C  
ATOM     27  O   LEU A   3       6.287  -6.143  26.348  1.00 48.48           O  
ATOM     28  CB  LEU A   3       4.314  -5.293  28.747  1.00 51.85           C  
ATOM     29  CG  LEU A   3       3.884  -5.144  30.207  1.00 52.56           C  
ATOM     30  CD1 LEU A   3       3.227  -3.790  30.431  1.00 51.89           C  
ATOM     31  CD2 LEU A   3       2.955  -6.272  30.611  1.00 51.07           C  
ATOM     32  N   ARG A   4       4.244  -7.017  26.195  1.00 50.49           N  
ATOM     33  CA  ARG A   4       4.163  -6.747  24.766  1.00 51.62           C  
ATOM     34  C   ARG A   4       3.908  -5.242  24.590  1.00 49.60           C  
ATOM     35  O   ARG A   4       3.472  -4.568  25.526  1.00 47.87           O  
ATOM     36  CB  ARG A   4       3.126  -7.651  24.104  1.00 51.65           C  
ATOM     37  CG  ARG A   4       3.502  -9.101  24.342  1.00 56.96           C  
ATOM     38  CD  ARG A   4       2.762 -10.052  23.459  1.00 74.82           C  
ATOM     39  NE  ARG A   4       3.616 -10.631  22.426  1.00 81.32           N  
ATOM     40  CZ  ARG A   4       3.186 -11.481  21.494  1.00 86.98           C  
ATOM     41  NH1 ARG A   4       1.915 -11.861  21.453  1.00 92.64           N  
ATOM     42  NH2 ARG A   4       4.032 -11.961  20.597  1.00 87.54           N  
ATOM     43  N   SER A   5       4.260  -4.698  23.433  1.00 49.35           N  
ATOM     44  CA  SER A   5       4.200  -3.251  23.256  1.00 49.12           C  
ATOM     45  C   SER A   5       2.808  -2.678  23.528  1.00 48.78           C  
ATOM     46  O   SER A   5       2.646  -1.689  24.250  1.00 48.65           O  
ATOM     47  CB  SER A   5       4.597  -2.858  21.849  1.00 48.25           C  
ATOM     48  OG  SER A   5       4.748  -1.449  21.821  1.00 50.19           O  
ATOM     49  N   TRP A   6       1.805  -3.303  22.932  1.00 47.50           N  
ATOM     50  CA  TRP A   6       0.435  -2.787  23.014  1.00 47.13           C  
ATOM     51  C   TRP A   6      -0.147  -2.920  24.414  1.00 44.70           C  
ATOM     52  O   TRP A   6      -1.023  -2.150  24.787  1.00 43.26           O  
ATOM     53  CB  TRP A   6      -0.468  -3.467  21.982  1.00 48.58           C  
ATOM     54  CG  TRP A   6      -0.492  -4.966  22.087  1.00 50.19           C  
ATOM     55  CD1 TRP A   6      -1.283  -5.721  22.900  1.00 49.66           C  
ATOM     56  CD2 TRP A   6       0.330  -5.879  21.356  1.00 53.29           C  
ATOM     57  NE1 TRP A   6      -1.004  -7.048  22.719  1.00 48.09           N  
ATOM     58  CE2 TRP A   6      -0.017  -7.177  21.779  1.00 52.01           C  
ATOM     59  CE3 TRP A   6       1.343  -5.723  20.392  1.00 56.12           C  
ATOM     60  CZ2 TRP A   6       0.599  -8.322  21.262  1.00 55.74           C  
ATOM     61  CZ3 TRP A   6       1.958  -6.867  19.879  1.00 54.20           C  
ATOM     62  CH2 TRP A   6       1.584  -8.145  20.318  1.00 54.98           C  
ATOM     63  N   GLU A   7       0.344  -3.890  25.182  1.00 44.79           N  
ATOM     64  CA  GLU A   7      -0.073  -4.077  26.576  1.00 44.62           C  
ATOM     65  C   GLU A   7       0.447  -2.903  27.436  1.00 43.38           C  
ATOM     66  O   GLU A   7      -0.178  -2.496  28.423  1.00 43.03           O  
ATOM     67  CB  GLU A   7       0.478  -5.398  27.132  1.00 44.11           C  
ATOM     68  CG  GLU A   7       0.058  -6.675  26.395  1.00 46.30           C  
ATOM     69  CD  GLU A   7       0.596  -7.964  27.077  1.00 48.41           C  
ATOM     70  OE1 GLU A   7       1.611  -7.910  27.819  1.00 52.44           O  
ATOM     71  OE2 GLU A   7      -0.002  -9.043  26.875  1.00 59.12           O  
ATOM     72  N   PHE A   8       1.603  -2.376  27.053  1.00 41.63           N  
ATOM     73  CA  PHE A   8       2.222  -1.251  27.773  1.00 42.62           C  
ATOM     74  C   PHE A   8       1.395  -0.007  27.486  1.00 42.37           C  
ATOM     75  O   PHE A   8       0.987   0.720  28.414  1.00 40.09           O  
ATOM     76  CB  PHE A   8       3.686  -1.057  27.339  1.00 41.01           C  
ATOM     77  CG  PHE A   8       4.261   0.284  27.703  1.00 43.50           C  
ATOM     78  CD1 PHE A   8       4.904   0.474  28.919  1.00 38.42           C  
ATOM     79  CD2 PHE A   8       4.155   1.359  26.819  1.00 44.32           C  
ATOM     80  CE1 PHE A   8       5.411   1.692  29.257  1.00 42.92           C  
ATOM     81  CE2 PHE A   8       4.663   2.595  27.148  1.00 41.33           C  
ATOM     82  CZ  PHE A   8       5.301   2.765  28.369  1.00 45.40           C  
ATOM     83  N   TYR A   9       1.135   0.199  26.187  1.00 41.86           N  
ATOM     84  CA  TYR A   9       0.311   1.312  25.715  1.00 40.82           C  
ATOM     85  C   TYR A   9      -1.127   1.269  26.254  1.00 42.23           C  
ATOM     86  O   TYR A   9      -1.707   2.320  26.524  1.00 43.66           O  
ATOM     87  CB  TYR A   9       0.413   1.448  24.180  1.00 42.04           C  
ATOM     88  CG  TYR A   9       1.742   2.100  23.784  1.00 36.52           C  
ATOM     89  CD1 TYR A   9       2.010   3.442  24.086  1.00 41.97           C  
ATOM     90  CD2 TYR A   9       2.748   1.356  23.211  1.00 37.45           C  
ATOM     91  CE1 TYR A   9       3.231   4.027  23.774  1.00 41.58           C  
ATOM     92  CE2 TYR A   9       3.964   1.929  22.878  1.00 43.98           C  
ATOM     93  CZ  TYR A   9       4.211   3.258  23.175  1.00 45.81           C  
ATOM     94  OH  TYR A   9       5.427   3.809  22.857  1.00 45.41           O  
ATOM     95  N   ASP A  10      -1.666   0.070  26.501  1.00 42.25           N  
ATOM     96  CA  ASP A  10      -2.972  -0.067  27.164  1.00 41.47           C  
ATOM     97  C   ASP A  10      -2.961   0.529  28.569  1.00 42.80           C  
ATOM     98  O   ASP A  10      -3.974   1.075  29.018  1.00 45.82           O  
ATOM     99  CB  ASP A  10      -3.448  -1.545  27.229  1.00 39.87           C  
ATOM    100  CG  ASP A  10      -4.170  -2.016  25.948  1.00 43.77           C  
ATOM    101  OD1 ASP A  10      -4.402  -1.209  25.010  1.00 43.91           O  
ATOM    102  OD2 ASP A  10      -4.504  -3.216  25.869  1.00 44.64           O  
ATOM    103  N   ARG A  11      -1.838   0.416  29.276  1.00 42.25           N  
ATOM    104  CA  ARG A  11      -1.746   0.932  30.652  1.00 42.01           C  
ATOM    105  C   ARG A  11      -1.655   2.470  30.693  1.00 39.64           C  
ATOM    106  O   ARG A  11      -2.253   3.117  31.558  1.00 38.18           O  
ATOM    107  CB  ARG A  11      -0.564   0.291  31.416  1.00 41.10           C  
ATOM    108  CG  ARG A  11      -0.787  -1.180  31.801  1.00 46.31           C  
ATOM    109  CD  ARG A  11       0.074  -1.613  32.992  1.00 47.54           C  
ATOM    110  N   ILE A  12      -0.933   3.051  29.746  1.00 39.69           N  
ATOM    111  CA  ILE A  12      -0.688   4.498  29.754  1.00 40.54           C  
ATOM    112  C   ILE A  12      -1.530   5.347  28.780  1.00 41.92           C  
ATOM    113  O   ILE A  12      -1.425   6.564  28.814  1.00 44.09           O  
ATOM    114  CB  ILE A  12       0.797   4.792  29.471  1.00 41.07           C  
ATOM    115  CG1 ILE A  12       1.177   4.386  28.051  1.00 41.65           C  
ATOM    116  CG2 ILE A  12       1.666   4.058  30.469  1.00 41.70           C  
ATOM    117  CD1 ILE A  12       2.408   5.113  27.525  1.00 49.38           C  
ATOM    118  N   ALA A  13      -2.342   4.724  27.918  1.00 41.06           N  
ATOM    119  CA  ALA A  13      -3.099   5.445  26.871  1.00 39.58           C  
ATOM    120  C   ALA A  13      -3.645   6.811  27.293  1.00 40.81           C  
ATOM    121  O   ALA A  13      -3.512   7.800  26.559  1.00 43.17           O  
ATOM    122  CB  ALA A  13      -4.232   4.560  26.342  1.00 40.21           C  
ATOM    123  N   ARG A  14      -4.220   6.871  28.490  1.00 39.15           N  
ATOM    124  CA  ARG A  14      -4.944   8.056  28.949  1.00 39.83           C  
ATOM    125  C   ARG A  14      -4.042   9.162  29.476  1.00 40.85           C  
ATOM    126  O   ARG A  14      -4.514  10.253  29.738  1.00 43.79           O  
ATOM    127  CB  ARG A  14      -5.959   7.647  30.026  1.00 38.80           C  
ATOM    128  CG  ARG A  14      -6.847   6.495  29.529  1.00 45.19           C  
ATOM    129  CD  ARG A  14      -8.215   6.456  30.170  1.00 54.85           C  
ATOM    130  NE  ARG A  14      -9.208   7.253  29.444  1.00 62.88           N  
ATOM    131  CZ  ARG A  14      -9.744   6.935  28.263  1.00 63.77           C  
ATOM    132  NH1 ARG A  14      -9.382   5.834  27.598  1.00 68.26           N  
ATOM    133  NH2 ARG A  14     -10.644   7.736  27.723  1.00 56.91           N  
ATOM    134  N   ALA A  15      -2.765   8.854  29.665  1.00 39.42           N  
ATOM    135  CA  ALA A  15      -1.747   9.812  30.057  1.00 38.67           C  
ATOM    136  C   ALA A  15      -0.779  10.065  28.910  1.00 39.95           C  
ATOM    137  O   ALA A  15       0.151  10.859  29.039  1.00 41.09           O  
ATOM    138  CB  ALA A  15      -0.980   9.253  31.224  1.00 39.03           C  
ATOM    139  N   TYR A  16      -0.992   9.373  27.793  1.00 41.07           N  
ATOM    140  CA  TYR A  16      -0.040   9.363  26.708  1.00 41.25           C  
ATOM    141  C   TYR A  16       0.181  10.775  26.182  1.00 42.55           C  
ATOM    142  O   TYR A  16       1.311  11.259  26.136  1.00 41.23           O  
ATOM    143  CB  TYR A  16      -0.537   8.460  25.576  1.00 40.96           C  
ATOM    144  CG  TYR A  16       0.405   8.469  24.414  1.00 40.11           C  
ATOM    145  CD1 TYR A  16       1.560   7.725  24.439  1.00 40.74           C  
ATOM    146  CD2 TYR A  16       0.163   9.270  23.307  1.00 45.52           C  
ATOM    147  CE1 TYR A  16       2.453   7.748  23.378  1.00 43.48           C  
ATOM    148  CE2 TYR A  16       1.033   9.292  22.234  1.00 42.30           C  
ATOM    149  CZ  TYR A  16       2.179   8.523  22.279  1.00 43.54           C  
ATOM    150  OH  TYR A  16       3.047   8.550  21.231  1.00 46.86           O  
ATOM    151  N   ASP A  17      -0.914  11.428  25.801  1.00 44.35           N  
ATOM    152  CA  ASP A  17      -0.850  12.750  25.182  1.00 46.80           C  
ATOM    153  C   ASP A  17      -0.145  13.742  26.104  1.00 47.39           C  
ATOM    154  O   ASP A  17       0.717  14.500  25.643  1.00 47.64           O  
ATOM    155  CB  ASP A  17      -2.250  13.251  24.779  1.00 47.20           C  
ATOM    156  CG  ASP A  17      -2.846  12.461  23.591  1.00 49.15           C  
ATOM    157  OD1 ASP A  17      -2.087  11.802  22.850  1.00 49.74           O  
ATOM    158  OD2 ASP A  17      -4.074  12.491  23.397  1.00 50.94           O  
ATOM    159  N   SER A  18      -0.454  13.678  27.403  1.00 47.61           N  
ATOM    160  CA  SER A  18       0.147  14.590  28.384  0.50 48.73           C  
ATOM    162  C   SER A  18       1.668  14.414  28.521  1.00 49.55           C  
ATOM    163  O   SER A  18       2.346  15.332  28.925  1.00 50.38           O  
ATOM    164  CB  SER A  18      -0.532  14.477  29.762  0.50 48.18           C  
ATOM    166  OG  SER A  18       0.135  13.558  30.614  0.50 45.68           O  
HETATM  168  N   MSE A  19       2.198  13.245  28.177  1.00 53.84           N  
HETATM  169  CA  MSE A  19       3.654  13.014  28.249  1.00 61.63           C  
HETATM  170  C   MSE A  19       4.515  13.641  27.153  1.00 58.99           C  
HETATM  171  O   MSE A  19       5.735  13.673  27.269  1.00 59.27           O  
HETATM  172  CB  MSE A  19       3.947  11.526  28.228  1.00 60.58           C  
HETATM  173  CG  MSE A  19       3.552  10.816  29.494  1.00 69.02           C  
HETATM  174 SE   MSE A  19       3.232   8.928  29.115  1.00 82.86          SE  
HETATM  175  CE  MSE A  19       4.821   8.482  27.906  1.00 81.13           C  
ATOM    176  N   TYR A  20       3.896  14.088  26.070  1.00 58.85           N  
ATOM    177  CA  TYR A  20       4.642  14.589  24.916  1.00 57.53           C  
ATOM    178  C   TYR A  20       4.299  16.058  24.652  1.00 56.49           C  
ATOM    179  O   TYR A  20       4.241  16.500  23.510  1.00 55.71           O  
ATOM    180  CB  TYR A  20       4.380  13.679  23.705  1.00 57.64           C  
ATOM    181  CG  TYR A  20       4.936  12.296  23.942  1.00 59.93           C  
ATOM    182  CD1 TYR A  20       6.286  12.034  23.741  1.00 63.55           C  
ATOM    183  CD2 TYR A  20       4.134  11.261  24.410  1.00 63.41           C  
ATOM    184  CE1 TYR A  20       6.824  10.782  23.980  1.00 64.52           C  
ATOM    185  CE2 TYR A  20       4.662   9.992  24.653  1.00 63.37           C  
ATOM    186  CZ  TYR A  20       6.013   9.766  24.436  1.00 66.02           C  
ATOM    187  OH  TYR A  20       6.572   8.540  24.670  1.00 63.32           O  
ATOM    188  N   GLU A  21       4.074  16.794  25.740  1.00 56.63           N  
ATOM    189  CA  GLU A  21       3.741  18.211  25.696  1.00 57.35           C  
ATOM    190  C   GLU A  21       4.902  19.062  26.247  1.00 55.03           C  
ATOM    191  O   GLU A  21       4.711  20.165  26.734  1.00 55.93           O  
ATOM    192  CB  GLU A  21       2.457  18.473  26.492  1.00 56.81           C  
ATOM    193  CG  GLU A  21       1.187  17.939  25.864  1.00 59.91           C  
ATOM    194  CD  GLU A  21      -0.065  18.356  26.645  1.00 61.03           C  
ATOM    195  N   THR A  22       6.113  18.550  26.154  1.00 53.66           N  
ATOM    196  CA  THR A  22       7.302  19.317  26.504  1.00 53.19           C  
ATOM    197  C   THR A  22       7.751  20.173  25.313  1.00 50.90           C  
ATOM    198  O   THR A  22       7.374  19.886  24.161  1.00 49.39           O  
ATOM    199  CB  THR A  22       8.459  18.369  26.848  1.00 54.31           C  
ATOM    200  OG1 THR A  22       8.748  17.536  25.713  1.00 54.58           O  
ATOM    201  CG2 THR A  22       8.086  17.506  28.028  1.00 56.13           C  
ATOM    202  N   PRO A  23       8.588  21.197  25.574  1.00 47.90           N  
ATOM    203  CA  PRO A  23       9.124  22.027  24.486  1.00 46.64           C  
ATOM    204  C   PRO A  23       9.821  21.212  23.384  1.00 45.10           C  
ATOM    205  O   PRO A  23       9.579  21.453  22.199  1.00 43.18           O  
ATOM    206  CB  PRO A  23      10.110  22.965  25.206  1.00 47.87           C  
ATOM    207  CG  PRO A  23       9.591  23.054  26.610  1.00 46.83           C  
ATOM    208  CD  PRO A  23       9.071  21.654  26.889  1.00 49.78           C  
ATOM    209  N   LYS A  24      10.642  20.238  23.771  1.00 43.51           N  
ATOM    210  CA  LYS A  24      11.243  19.347  22.808  1.00 44.36           C  
ATOM    211  C   LYS A  24      10.229  18.607  21.941  1.00 44.22           C  
ATOM    212  O   LYS A  24      10.423  18.454  20.723  1.00 41.53           O  
ATOM    213  CB  LYS A  24      12.132  18.315  23.484  1.00 46.00           C  
ATOM    214  CG  LYS A  24      12.972  17.526  22.446  1.00 50.27           C  
ATOM    215  CD  LYS A  24      13.865  16.480  23.070  1.00 52.06           C  
ATOM    216  CE  LYS A  24      13.110  15.204  23.363  1.00 55.33           C  
ATOM    217  NZ  LYS A  24      14.033  14.208  23.962  1.00 61.79           N  
ATOM    218  N   TRP A  25       9.165  18.108  22.555  1.00 45.23           N  
ATOM    219  CA  TRP A  25       8.212  17.301  21.786  1.00 47.08           C  
ATOM    220  C   TRP A  25       7.299  18.177  20.935  1.00 45.98           C  
ATOM    221  O   TRP A  25       6.919  17.791  19.843  1.00 45.52           O  
ATOM    222  CB  TRP A  25       7.451  16.339  22.701  1.00 48.65           C  
ATOM    223  CG  TRP A  25       8.296  15.163  22.975  1.00 50.35           C  
ATOM    224  CD1 TRP A  25       8.943  14.848  24.140  1.00 51.97           C  
ATOM    225  CD2 TRP A  25       8.664  14.172  22.025  1.00 47.62           C  
ATOM    226  NE1 TRP A  25       9.677  13.697  23.965  1.00 52.38           N  
ATOM    227  CE2 TRP A  25       9.523  13.266  22.676  1.00 43.93           C  
ATOM    228  CE3 TRP A  25       8.334  13.952  20.676  1.00 55.29           C  
ATOM    229  CZ2 TRP A  25      10.048  12.148  22.034  1.00 54.13           C  
ATOM    230  CZ3 TRP A  25       8.852  12.845  20.036  1.00 51.95           C  
ATOM    231  CH2 TRP A  25       9.702  11.949  20.716  1.00 52.56           C  
ATOM    232  N   LYS A  26       6.996  19.376  21.420  1.00 45.53           N  
ATOM    233  CA  LYS A  26       6.324  20.352  20.588  1.00 47.06           C  
ATOM    234  C   LYS A  26       7.170  20.665  19.358  1.00 44.80           C  
ATOM    235  O   LYS A  26       6.684  20.662  18.245  1.00 42.38           O  
ATOM    236  CB  LYS A  26       5.998  21.602  21.384  1.00 46.66           C  
ATOM    237  CG  LYS A  26       4.875  21.335  22.376  1.00 57.59           C  
ATOM    238  CD  LYS A  26       4.622  22.502  23.349  1.00 64.71           C  
ATOM    239  CE  LYS A  26       3.313  22.297  24.115  1.00 67.41           C  
ATOM    240  NZ  LYS A  26       2.931  23.529  24.860  1.00 71.17           N  
ATOM    241  N   LEU A  27       8.454  20.891  19.567  1.00 44.44           N  
ATOM    242  CA  LEU A  27       9.353  21.161  18.466  1.00 44.00           C  
ATOM    243  C   LEU A  27       9.324  20.032  17.442  1.00 42.24           C  
ATOM    244  O   LEU A  27       9.157  20.274  16.244  1.00 42.13           O  
ATOM    245  CB  LEU A  27      10.778  21.354  18.999  1.00 44.70           C  
ATOM    246  CG  LEU A  27      11.887  21.495  17.964  1.00 45.74           C  
ATOM    247  CD1 LEU A  27      11.631  22.728  17.116  1.00 46.45           C  
ATOM    248  CD2 LEU A  27      13.215  21.558  18.685  1.00 52.06           C  
ATOM    249  N   TYR A  28       9.488  18.807  17.926  1.00 41.12           N  
ATOM    250  CA  TYR A  28       9.496  17.632  17.067  1.00 43.07           C  
ATOM    251  C   TYR A  28       8.202  17.444  16.292  1.00 44.38           C  
ATOM    252  O   TYR A  28       8.250  17.045  15.129  1.00 44.23           O  
ATOM    253  CB  TYR A  28       9.770  16.371  17.882  1.00 42.81           C  
ATOM    254  CG  TYR A  28      11.194  16.201  18.383  1.00 46.44           C  
ATOM    255  CD1 TYR A  28      12.173  17.199  18.199  1.00 47.77           C  
ATOM    256  CD2 TYR A  28      11.558  15.047  19.080  1.00 45.79           C  
ATOM    257  CE1 TYR A  28      13.464  17.030  18.683  1.00 47.05           C  
ATOM    258  CE2 TYR A  28      12.845  14.869  19.552  1.00 44.55           C  
ATOM    259  CZ  TYR A  28      13.799  15.852  19.355  1.00 46.97           C  
ATOM    260  OH  TYR A  28      15.076  15.665  19.846  1.00 44.06           O  
ATOM    261  N   HIS A  29       7.054  17.717  16.925  1.00 46.33           N  
ATOM    262  CA  HIS A  29       5.751  17.614  16.245  1.00 48.18           C  
ATOM    263  C   HIS A  29       5.600  18.643  15.129  1.00 46.27           C  
ATOM    264  O   HIS A  29       5.066  18.366  14.058  1.00 47.07           O  
ATOM    265  CB  HIS A  29       4.598  17.763  17.244  1.00 50.14           C  
ATOM    266  CG  HIS A  29       4.493  16.622  18.200  1.00 57.29           C  
ATOM    267  ND1 HIS A  29       3.945  16.754  19.458  1.00 60.44           N  
ATOM    268  CD2 HIS A  29       4.897  15.331  18.091  1.00 59.91           C  
ATOM    269  CE1 HIS A  29       3.999  15.585  20.075  1.00 62.06           C  
ATOM    270  NE2 HIS A  29       4.574  14.708  19.270  1.00 59.78           N  
ATOM    271  N   ARG A  30       6.083  19.838  15.398  1.00 45.29           N  
ATOM    272  CA  ARG A  30       6.138  20.881  14.400  1.00 44.72           C  
ATOM    273  C   ARG A  30       6.979  20.458  13.183  1.00 43.96           C  
ATOM    274  O   ARG A  30       6.600  20.716  12.037  1.00 44.25           O  
ATOM    275  CB  ARG A  30       6.682  22.168  15.017  1.00 41.79           C  
ATOM    276  CG  ARG A  30       6.094  23.362  14.369  1.00 41.72           C  
ATOM    277  CD  ARG A  30       6.750  24.626  14.810  1.00 46.06           C  
ATOM    278  NE  ARG A  30       6.588  25.652  13.784  1.00 48.34           N  
ATOM    279  CZ  ARG A  30       7.093  26.874  13.842  1.00 50.61           C  
ATOM    280  NH1 ARG A  30       7.811  27.268  14.896  1.00 50.36           N  
ATOM    281  NH2 ARG A  30       6.887  27.689  12.823  1.00 53.36           N  
ATOM    282  N   LEU A  31       8.102  19.799  13.437  1.00 42.61           N  
ATOM    283  CA  LEU A  31       8.946  19.299  12.346  1.00 44.93           C  
ATOM    284  C   LEU A  31       8.253  18.213  11.529  1.00 45.74           C  
ATOM    285  O   LEU A  31       8.223  18.289  10.282  1.00 42.35           O  
ATOM    286  CB  LEU A  31      10.271  18.761  12.877  1.00 45.33           C  
ATOM    287  CG  LEU A  31      11.205  19.901  13.280  1.00 49.21           C  
ATOM    288  CD1 LEU A  31      12.232  19.416  14.268  1.00 50.18           C  
ATOM    289  CD2 LEU A  31      11.863  20.540  12.043  1.00 50.23           C  
ATOM    290  N   ILE A  32       7.700  17.222  12.240  1.00 45.07           N  
ATOM    291  CA  ILE A  32       6.999  16.124  11.606  1.00 45.55           C  
ATOM    292  C   ILE A  32       5.838  16.659  10.768  1.00 45.36           C  
ATOM    293  O   ILE A  32       5.652  16.245   9.632  1.00 45.23           O  
ATOM    294  CB  ILE A  32       6.455  15.135  12.630  1.00 46.88           C  
ATOM    295  CG1 ILE A  32       7.597  14.425  13.368  1.00 50.11           C  
ATOM    296  CG2 ILE A  32       5.545  14.108  11.947  1.00 49.90           C  
ATOM    297  CD1 ILE A  32       8.542  13.688  12.486  1.00 58.11           C  
ATOM    298  N   GLY A  33       5.071  17.577  11.338  1.00 44.10           N  
ATOM    299  CA  GLY A  33       3.996  18.229  10.614  1.00 44.58           C  
ATOM    300  C   GLY A  33       4.446  18.947   9.350  1.00 45.79           C  
ATOM    301  O   GLY A  33       3.773  18.895   8.348  1.00 47.72           O  
ATOM    302  N   SER A  34       5.581  19.637   9.395  1.00 47.42           N  
ATOM    303  CA  SER A  34       6.081  20.331   8.214  1.00 46.57           C  
ATOM    304  C   SER A  34       6.520  19.305   7.164  1.00 45.61           C  
ATOM    305  O   SER A  34       6.282  19.502   5.975  1.00 46.45           O  
ATOM    306  CB  SER A  34       7.209  21.311   8.581  1.00 46.12           C  
ATOM    307  OG  SER A  34       8.441  20.646   8.818  1.00 53.60           O  
ATOM    308  N   PHE A  35       7.095  18.188   7.600  1.00 46.36           N  
ATOM    309  CA  PHE A  35       7.498  17.134   6.666  1.00 47.36           C  
ATOM    310  C   PHE A  35       6.302  16.447   5.999  1.00 48.55           C  
ATOM    311  O   PHE A  35       6.365  16.097   4.805  1.00 47.34           O  
ATOM    312  CB  PHE A  35       8.341  16.061   7.343  1.00 47.44           C  
ATOM    313  CG  PHE A  35       9.639  16.554   7.959  1.00 45.84           C  
ATOM    314  CD1 PHE A  35      10.120  17.825   7.747  1.00 48.80           C  
ATOM    315  CD2 PHE A  35      10.380  15.702   8.763  1.00 46.79           C  
ATOM    316  CE1 PHE A  35      11.308  18.238   8.338  1.00 50.61           C  
ATOM    317  CE2 PHE A  35      11.564  16.104   9.327  1.00 47.79           C  
ATOM    318  CZ  PHE A  35      12.023  17.363   9.124  1.00 46.77           C  
ATOM    319  N   LEU A  36       5.219  16.243   6.750  1.00 49.33           N  
ATOM    320  CA  LEU A  36       4.028  15.608   6.181  1.00 49.73           C  
ATOM    321  C   LEU A  36       3.418  16.472   5.093  1.00 52.85           C  
ATOM    322  O   LEU A  36       2.996  15.960   4.067  1.00 51.66           O  
ATOM    323  CB  LEU A  36       2.978  15.333   7.238  1.00 50.64           C  
ATOM    324  CG  LEU A  36       3.310  14.242   8.245  1.00 51.84           C  
ATOM    325  CD1 LEU A  36       2.137  14.110   9.196  1.00 51.89           C  
ATOM    326  CD2 LEU A  36       3.648  12.920   7.563  1.00 56.23           C  
ATOM    327  N   GLU A  37       3.397  17.783   5.320  1.00 55.22           N  
ATOM    328  CA  GLU A  37       2.893  18.733   4.339  1.00 58.28           C  
ATOM    329  C   GLU A  37       3.790  18.835   3.097  1.00 56.39           C  
ATOM    330  O   GLU A  37       3.347  19.199   2.014  1.00 59.14           O  
ATOM    331  CB  GLU A  37       2.725  20.104   4.997  1.00 58.66           C  
ATOM    332  CG  GLU A  37       1.662  20.129   6.097  1.00 61.44           C  
ATOM    333  CD  GLU A  37       1.432  21.525   6.691  1.00 65.54           C  
ATOM    334  OE1 GLU A  37       2.425  22.254   6.985  1.00 74.99           O  
ATOM    335  OE2 GLU A  37       0.239  21.885   6.867  1.00 77.47           O  
ATOM    336  N   GLU A  38       5.056  18.506   3.258  1.00 54.80           N  
ATOM    337  CA  GLU A  38       5.990  18.493   2.146  1.00 53.23           C  
ATOM    338  C   GLU A  38       5.778  17.276   1.240  1.00 52.78           C  
ATOM    339  O   GLU A  38       5.820  17.393   0.019  1.00 51.07           O  
ATOM    340  CB  GLU A  38       7.412  18.513   2.703  1.00 52.95           C  
ATOM    341  CG  GLU A  38       8.484  18.469   1.664  1.00 57.58           C  
ATOM    342  CD  GLU A  38       9.885  18.588   2.249  1.00 63.76           C  
ATOM    343  OE1 GLU A  38      10.035  18.820   3.480  1.00 55.64           O  
ATOM    344  OE2 GLU A  38      10.844  18.443   1.454  1.00 65.81           O  
ATOM    345  N   TYR A  39       5.544  16.112   1.846  1.00 53.43           N  
ATOM    346  CA  TYR A  39       5.456  14.853   1.099  1.00 53.53           C  
ATOM    347  C   TYR A  39       4.033  14.502   0.679  1.00 54.42           C  
ATOM    348  O   TYR A  39       3.827  13.822  -0.318  1.00 55.00           O  
ATOM    349  CB  TYR A  39       6.089  13.710   1.903  1.00 54.83           C  
ATOM    350  CG  TYR A  39       7.593  13.782   1.915  1.00 52.66           C  
ATOM    351  CD1 TYR A  39       8.324  13.367   0.817  1.00 55.39           C  
ATOM    352  CD2 TYR A  39       8.286  14.303   3.009  1.00 59.67           C  
ATOM    353  CE1 TYR A  39       9.701  13.469   0.794  1.00 57.50           C  
ATOM    354  CE2 TYR A  39       9.667  14.409   3.004  1.00 58.04           C  
ATOM    355  CZ  TYR A  39      10.366  13.984   1.890  1.00 58.51           C  
ATOM    356  OH  TYR A  39      11.733  14.050   1.862  1.00 62.48           O  
ATOM    357  N   LEU A  40       3.055  14.967   1.444  1.00 55.69           N  
ATOM    358  CA  LEU A  40       1.655  14.749   1.125  1.00 55.93           C  
ATOM    359  C   LEU A  40       1.075  16.051   0.611  1.00 58.57           C  
ATOM    360  O   LEU A  40       0.389  16.785   1.332  1.00 57.18           O  
ATOM    361  CB  LEU A  40       0.882  14.247   2.348  1.00 55.01           C  
ATOM    362  CG  LEU A  40       1.374  12.936   2.949  1.00 52.04           C  
ATOM    363  CD1 LEU A  40       0.640  12.623   4.246  1.00 51.51           C  
ATOM    364  CD2 LEU A  40       1.200  11.805   1.965  1.00 53.22           C  
ATOM    365  N   LYS A  41       1.351  16.311  -0.664  1.00 62.96           N  
ATOM    366  CA  LYS A  41       0.923  17.545  -1.321  1.00 66.12           C  
ATOM    367  C   LYS A  41      -0.591  17.668  -1.325  1.00 65.28           C  
ATOM    368  O   LYS A  41      -1.139  18.712  -0.978  1.00 67.19           O  
ATOM    369  CB  LYS A  41       1.437  17.597  -2.774  1.00 68.46           C  
ATOM    370  CG  LYS A  41       2.975  17.425  -2.953  1.00 73.50           C  
ATOM    371  CD  LYS A  41       3.807  18.293  -2.009  1.00 76.63           C  
ATOM    372  CE  LYS A  41       3.546  19.795  -2.156  1.00 76.34           C  
ATOM    373  NZ  LYS A  41       4.378  20.568  -1.173  1.00 71.32           N  
ATOM    374  N   ASN A  42      -1.262  16.592  -1.713  1.00 62.91           N  
ATOM    375  CA  ASN A  42      -2.695  16.625  -1.917  1.00 61.63           C  
ATOM    376  C   ASN A  42      -3.404  15.534  -1.107  1.00 59.06           C  
ATOM    377  O   ASN A  42      -2.775  14.527  -0.761  1.00 59.28           O  
ATOM    378  CB  ASN A  42      -3.004  16.517  -3.410  1.00 61.66           C  
ATOM    379  CG  ASN A  42      -2.760  17.831  -4.142  1.00 66.56           C  
ATOM    380  OD1 ASN A  42      -1.619  18.161  -4.485  1.00 70.44           O  
ATOM    381  ND2 ASN A  42      -3.832  18.598  -4.370  1.00 64.71           N  
ATOM    382  N   PRO A  43      -4.673  15.782  -0.722  1.00 54.69           N  
ATOM    383  CA  PRO A  43      -5.523  14.823  -0.047  1.00 54.68           C  
ATOM    384  C   PRO A  43      -5.690  13.502  -0.802  1.00 53.83           C  
ATOM    385  O   PRO A  43      -5.924  13.488  -2.006  1.00 52.81           O  
ATOM    386  CB  PRO A  43      -6.868  15.547   0.045  1.00 54.62           C  
ATOM    387  CG  PRO A  43      -6.521  16.952   0.081  1.00 55.14           C  
ATOM    388  CD  PRO A  43      -5.353  17.081  -0.849  1.00 55.59           C  
ATOM    389  N   CYS A  44      -5.581  12.407  -0.064  1.00 51.98           N  
ATOM    390  CA  CYS A  44      -5.603  11.070  -0.629  1.00 51.29           C  
ATOM    391  C   CYS A  44      -5.888  10.104   0.510  1.00 48.08           C  
ATOM    392  O   CYS A  44      -6.238  10.528   1.600  1.00 48.67           O  
ATOM    393  CB  CYS A  44      -4.255  10.768  -1.262  1.00 50.51           C  
ATOM    394  SG  CYS A  44      -2.933  10.812  -0.027  1.00 57.06           S  
ATOM    395  N   ARG A  45      -5.731   8.815   0.257  1.00 46.35           N  
ATOM    396  CA  ARG A  45      -6.103   7.792   1.219  1.00 44.31           C  
ATOM    397  C   ARG A  45      -4.879   7.423   2.037  1.00 42.97           C  
ATOM    398  O   ARG A  45      -3.850   7.100   1.474  1.00 41.59           O  
ATOM    399  CB  ARG A  45      -6.675   6.585   0.493  1.00 43.07           C  
ATOM    400  CG  ARG A  45      -7.919   6.941  -0.330  1.00 48.42           C  
ATOM    401  CD  ARG A  45      -8.347   5.851  -1.311  1.00 44.12           C  
ATOM    402  NE  ARG A  45      -7.250   5.448  -2.189  1.00 48.64           N  
ATOM    403  CZ  ARG A  45      -7.246   4.352  -2.953  1.00 56.01           C  
ATOM    404  NH1 ARG A  45      -8.287   3.523  -2.975  1.00 58.32           N  
ATOM    405  NH2 ARG A  45      -6.173   4.071  -3.692  1.00 52.75           N  
ATOM    406  N   VAL A  46      -4.991   7.505   3.361  1.00 42.37           N  
ATOM    407  CA  VAL A  46      -3.847   7.296   4.252  1.00 41.69           C  
ATOM    408  C   VAL A  46      -4.188   6.311   5.361  1.00 41.72           C  
ATOM    409  O   VAL A  46      -5.258   6.388   5.941  1.00 41.40           O  
ATOM    410  CB  VAL A  46      -3.392   8.630   4.869  1.00 41.25           C  
ATOM    411  CG1 VAL A  46      -2.199   8.432   5.778  1.00 41.59           C  
ATOM    412  CG2 VAL A  46      -3.030   9.621   3.747  1.00 43.25           C  
ATOM    413  N   LEU A  47      -3.278   5.370   5.614  1.00 43.17           N  
ATOM    414  CA  LEU A  47      -3.346   4.476   6.776  1.00 42.11           C  
ATOM    415  C   LEU A  47      -2.428   5.021   7.852  1.00 43.35           C  
ATOM    416  O   LEU A  47      -1.226   5.149   7.628  1.00 41.11           O  
ATOM    417  CB  LEU A  47      -2.843   3.091   6.405  1.00 42.05           C  
ATOM    418  CG  LEU A  47      -2.887   2.033   7.513  1.00 46.16           C  
ATOM    419  CD1 LEU A  47      -4.296   1.897   8.004  1.00 51.17           C  
ATOM    420  CD2 LEU A  47      -2.440   0.692   7.004  1.00 44.83           C  
ATOM    421  N   ASP A  48      -2.981   5.369   9.009  1.00 43.38           N  
ATOM    422  CA  ASP A  48      -2.165   5.771  10.160  1.00 42.02           C  
ATOM    423  C   ASP A  48      -1.890   4.532  11.036  1.00 45.19           C  
ATOM    424  O   ASP A  48      -2.687   4.182  11.913  1.00 41.87           O  
ATOM    425  CB  ASP A  48      -2.893   6.867  10.917  1.00 44.46           C  
ATOM    426  CG  ASP A  48      -2.083   7.465  12.052  1.00 50.25           C  
ATOM    427  OD1 ASP A  48      -0.823   7.384  12.054  1.00 54.98           O  
ATOM    428  OD2 ASP A  48      -2.740   8.040  12.949  1.00 54.18           O  
ATOM    429  N   LEU A  49      -0.764   3.859  10.744  1.00 45.47           N  
ATOM    430  CA  LEU A  49      -0.400   2.575  11.342  1.00 45.71           C  
ATOM    431  C   LEU A  49       0.298   2.735  12.696  1.00 45.02           C  
ATOM    432  O   LEU A  49       1.272   3.465  12.825  1.00 43.20           O  
ATOM    433  CB  LEU A  49       0.501   1.798  10.364  1.00 46.80           C  
ATOM    434  CG  LEU A  49       1.087   0.431  10.727  1.00 48.60           C  
ATOM    435  CD1 LEU A  49       0.010  -0.619  10.866  1.00 50.74           C  
ATOM    436  CD2 LEU A  49       2.025  -0.005   9.663  1.00 50.88           C  
ATOM    437  N   GLY A  50      -0.192   2.024  13.704  1.00 45.03           N  
ATOM    438  CA  GLY A  50       0.214   2.274  15.084  1.00 44.25           C  
ATOM    439  C   GLY A  50      -0.091   3.723  15.413  1.00 44.71           C  
ATOM    440  O   GLY A  50       0.719   4.417  16.016  1.00 45.89           O  
ATOM    441  N   GLY A  51      -1.267   4.179  15.008  1.00 44.30           N  
ATOM    442  CA  GLY A  51      -1.610   5.588  15.100  1.00 45.75           C  
ATOM    443  C   GLY A  51      -1.932   6.108  16.486  1.00 45.24           C  
ATOM    444  O   GLY A  51      -2.193   7.319  16.652  1.00 45.01           O  
ATOM    445  N   GLY A  52      -1.946   5.205  17.469  1.00 44.13           N  
ATOM    446  CA  GLY A  52      -2.054   5.594  18.879  1.00 44.44           C  
ATOM    447  C   GLY A  52      -3.304   6.377  19.200  1.00 43.86           C  
ATOM    448  O   GLY A  52      -4.403   5.979  18.825  1.00 43.43           O  
ATOM    449  N   THR A  53      -3.129   7.513  19.875  1.00 45.70           N  
ATOM    450  CA  THR A  53      -4.247   8.382  20.268  1.00 45.59           C  
ATOM    451  C   THR A  53      -4.773   9.277  19.129  1.00 45.53           C  
ATOM    452  O   THR A  53      -5.673  10.073  19.365  1.00 47.32           O  
ATOM    453  CB  THR A  53      -3.859   9.283  21.449  1.00 45.91           C  
ATOM    454  OG1 THR A  53      -2.760  10.114  21.066  1.00 46.26           O  
ATOM    455  CG2 THR A  53      -3.467   8.449  22.643  1.00 45.40           C  
ATOM    456  N   GLY A  54      -4.206   9.162  17.925  1.00 42.84           N  
ATOM    457  CA  GLY A  54      -4.791   9.772  16.740  1.00 45.24           C  
ATOM    458  C   GLY A  54      -4.329  11.170  16.376  1.00 46.51           C  
ATOM    459  O   GLY A  54      -4.933  11.827  15.535  1.00 46.44           O  
ATOM    460  N   LYS A  55      -3.253  11.609  17.014  1.00 48.94           N  
ATOM    461  CA  LYS A  55      -2.604  12.893  16.751  1.00 49.90           C  
ATOM    462  C   LYS A  55      -2.511  13.210  15.251  1.00 46.00           C  
ATOM    463  O   LYS A  55      -3.076  14.210  14.773  1.00 44.21           O  
ATOM    464  CB  LYS A  55      -1.226  12.852  17.415  1.00 51.48           C  
ATOM    465  CG  LYS A  55      -0.187  13.880  16.952  1.00 61.38           C  
ATOM    466  CD  LYS A  55      -0.447  15.250  17.495  1.00 68.79           C  
ATOM    467  CE  LYS A  55       0.831  16.053  17.549  1.00 65.97           C  
ATOM    468  NZ  LYS A  55       0.497  17.407  18.003  1.00 63.39           N  
ATOM    469  N   TRP A  56      -1.849  12.331  14.512  1.00 43.27           N  
ATOM    470  CA  TRP A  56      -1.624  12.544  13.067  1.00 44.56           C  
ATOM    471  C   TRP A  56      -2.847  12.220  12.189  1.00 45.83           C  
ATOM    472  O   TRP A  56      -3.026  12.818  11.122  1.00 46.35           O  
ATOM    473  CB  TRP A  56      -0.332  11.820  12.617  1.00 45.80           C  
ATOM    474  CG  TRP A  56       0.843  12.380  13.382  1.00 49.63           C  
ATOM    475  CD1 TRP A  56       1.600  11.740  14.330  1.00 49.53           C  
ATOM    476  CD2 TRP A  56       1.307  13.737  13.350  1.00 43.94           C  
ATOM    477  NE1 TRP A  56       2.517  12.604  14.851  1.00 46.78           N  
ATOM    478  CE2 TRP A  56       2.356  13.838  14.271  1.00 44.70           C  
ATOM    479  CE3 TRP A  56       0.942  14.866  12.613  1.00 46.90           C  
ATOM    480  CZ2 TRP A  56       3.054  15.030  14.480  1.00 47.22           C  
ATOM    481  CZ3 TRP A  56       1.632  16.046  12.815  1.00 49.34           C  
ATOM    482  CH2 TRP A  56       2.675  16.122  13.748  1.00 48.73           C  
ATOM    483  N   SER A  57      -3.711  11.317  12.653  1.00 45.46           N  
ATOM    484  CA  SER A  57      -4.992  11.101  11.988  1.00 44.68           C  
ATOM    485  C   SER A  57      -5.866  12.354  11.989  1.00 45.32           C  
ATOM    486  O   SER A  57      -6.390  12.756  10.948  1.00 46.26           O  
ATOM    487  CB  SER A  57      -5.730   9.926  12.619  1.00 44.54           C  
ATOM    488  OG  SER A  57      -5.070   8.708  12.302  1.00 44.20           O  
ATOM    489  N   LEU A  58      -6.013  12.975  13.150  1.00 45.23           N  
ATOM    490  CA  LEU A  58      -6.774  14.238  13.262  1.00 46.89           C  
ATOM    491  C   LEU A  58      -6.195  15.341  12.389  1.00 45.06           C  
ATOM    492  O   LEU A  58      -6.930  16.027  11.684  1.00 45.40           O  
ATOM    493  CB  LEU A  58      -6.812  14.737  14.711  1.00 46.15           C  
ATOM    494  CG  LEU A  58      -7.658  13.894  15.665  1.00 49.70           C  
ATOM    495  CD1 LEU A  58      -7.372  14.271  17.122  1.00 52.51           C  
ATOM    496  CD2 LEU A  58      -9.111  14.051  15.347  1.00 47.90           C  
ATOM    497  N   PHE A  59      -4.876  15.497  12.460  1.00 45.16           N  
ATOM    498  CA  PHE A  59      -4.112  16.402  11.602  1.00 44.96           C  
ATOM    499  C   PHE A  59      -4.502  16.220  10.130  1.00 44.87           C  
ATOM    500  O   PHE A  59      -4.817  17.189   9.433  1.00 44.44           O  
ATOM    501  CB  PHE A  59      -2.612  16.135  11.816  1.00 46.80           C  
ATOM    502  CG  PHE A  59      -1.682  17.118  11.120  1.00 48.41           C  
ATOM    503  CD1 PHE A  59      -1.410  18.356  11.681  1.00 50.33           C  
ATOM    504  CD2 PHE A  59      -1.051  16.779   9.924  1.00 48.03           C  
ATOM    505  CE1 PHE A  59      -0.526  19.259  11.050  1.00 50.24           C  
ATOM    506  CE2 PHE A  59      -0.184  17.671   9.285  1.00 49.54           C  
ATOM    507  CZ  PHE A  59       0.082  18.912   9.852  1.00 46.13           C  
ATOM    508  N   LEU A  60      -4.508  14.981   9.653  1.00 46.24           N  
ATOM    509  CA  LEU A  60      -4.893  14.723   8.262  1.00 47.83           C  
ATOM    510  C   LEU A  60      -6.403  14.836   7.996  1.00 47.74           C  
ATOM    511  O   LEU A  60      -6.802  15.398   6.974  1.00 47.25           O  
ATOM    512  CB  LEU A  60      -4.328  13.375   7.784  1.00 48.72           C  
ATOM    513  CG  LEU A  60      -2.791  13.363   7.666  1.00 49.25           C  
ATOM    514  CD1 LEU A  60      -2.290  12.047   7.167  1.00 54.86           C  
ATOM    515  CD2 LEU A  60      -2.264  14.477   6.772  1.00 50.68           C  
ATOM    516  N   GLN A  61      -7.235  14.316   8.900  1.00 48.39           N  
ATOM    517  CA  GLN A  61      -8.688  14.499   8.788  1.00 48.18           C  
ATOM    518  C   GLN A  61      -9.053  15.969   8.611  1.00 50.71           C  
ATOM    519  O   GLN A  61      -9.883  16.305   7.757  1.00 51.38           O  
ATOM    520  CB  GLN A  61      -9.433  13.992  10.022  1.00 46.71           C  
ATOM    521  CG  GLN A  61      -9.569  12.507  10.097  1.00 48.31           C  
ATOM    522  CD  GLN A  61     -10.517  12.027  11.188  1.00 47.67           C  
ATOM    523  OE1 GLN A  61     -10.774  10.835  11.285  1.00 47.34           O  
ATOM    524  NE2 GLN A  61     -11.036  12.943  12.006  1.00 43.16           N  
ATOM    525  N   GLU A  62      -8.454  16.838   9.421  1.00 51.82           N  
ATOM    526  CA  GLU A  62      -8.816  18.243   9.381  1.00 57.05           C  
ATOM    527  C   GLU A  62      -8.271  18.957   8.124  1.00 54.46           C  
ATOM    528  O   GLU A  62      -8.673  20.083   7.819  1.00 55.50           O  
ATOM    529  CB  GLU A  62      -8.455  18.949  10.701  1.00 55.65           C  
ATOM    530  CG  GLU A  62      -6.983  19.110  10.987  1.00 66.90           C  
ATOM    531  CD  GLU A  62      -6.695  19.366  12.477  1.00 67.64           C  
ATOM    532  OE1 GLU A  62      -7.651  19.198  13.285  1.00 81.05           O  
ATOM    533  OE2 GLU A  62      -5.525  19.720  12.826  1.00 75.41           O  
ATOM    534  N   ARG A  63      -7.401  18.272   7.384  1.00 53.06           N  
ATOM    535  CA  ARG A  63      -6.904  18.743   6.089  1.00 50.37           C  
ATOM    536  C   ARG A  63      -7.534  17.999   4.911  1.00 49.71           C  
ATOM    537  O   ARG A  63      -7.053  18.084   3.790  1.00 50.58           O  
ATOM    538  CB  ARG A  63      -5.386  18.613   6.040  1.00 49.77           C  
ATOM    539  CG  ARG A  63      -4.693  19.669   6.868  1.00 50.58           C  
ATOM    540  CD  ARG A  63      -3.265  19.290   7.219  1.00 56.98           C  
ATOM    541  NE  ARG A  63      -2.612  20.358   7.978  1.00 59.71           N  
ATOM    542  CZ  ARG A  63      -2.922  20.716   9.232  1.00 61.36           C  
ATOM    543  NH1 ARG A  63      -3.890  20.107   9.930  1.00 56.40           N  
ATOM    544  NH2 ARG A  63      -2.260  21.715   9.800  1.00 60.21           N  
ATOM    545  N   GLY A  64      -8.602  17.258   5.168  1.00 48.79           N  
ATOM    546  CA  GLY A  64      -9.425  16.704   4.099  1.00 48.61           C  
ATOM    547  C   GLY A  64      -8.965  15.386   3.516  1.00 48.58           C  
ATOM    548  O   GLY A  64      -9.423  15.008   2.463  1.00 47.88           O  
ATOM    549  N   PHE A  65      -8.065  14.691   4.202  1.00 48.84           N  
ATOM    550  CA  PHE A  65      -7.636  13.358   3.797  1.00 47.37           C  
ATOM    551  C   PHE A  65      -8.671  12.298   4.218  1.00 46.56           C  
ATOM    552  O   PHE A  65      -9.466  12.494   5.145  1.00 46.40           O  
ATOM    553  CB  PHE A  65      -6.286  13.028   4.448  1.00 47.65           C  
ATOM    554  CG  PHE A  65      -5.113  13.763   3.850  1.00 44.28           C  
ATOM    555  CD1 PHE A  65      -4.936  15.121   4.069  1.00 45.36           C  
ATOM    556  CD2 PHE A  65      -4.164  13.083   3.093  1.00 42.54           C  
ATOM    557  CE1 PHE A  65      -3.849  15.795   3.525  1.00 42.60           C  
ATOM    558  CE2 PHE A  65      -3.088  13.752   2.542  1.00 43.13           C  
ATOM    559  CZ  PHE A  65      -2.928  15.110   2.759  1.00 44.41           C  
ATOM    560  N   GLU A  66      -8.652  11.174   3.527  1.00 46.19           N  
ATOM    561  CA  GLU A  66      -9.411  10.012   3.938  1.00 46.18           C  
ATOM    562  C   GLU A  66      -8.452   9.153   4.744  1.00 46.18           C  
ATOM    563  O   GLU A  66      -7.441   8.689   4.217  1.00 47.72           O  
ATOM    564  CB  GLU A  66      -9.916   9.264   2.725  1.00 46.27           C  
ATOM    565  CG  GLU A  66     -10.816   8.091   3.079  1.00 53.12           C  
ATOM    566  CD  GLU A  66     -11.600   7.576   1.900  1.00 53.77           C  
ATOM    567  OE1 GLU A  66     -10.980   7.037   0.964  1.00 55.53           O  
ATOM    568  OE2 GLU A  66     -12.837   7.700   1.920  1.00 60.00           O  
ATOM    569  N   VAL A  67      -8.734   8.984   6.029  1.00 44.18           N  
ATOM    570  CA  VAL A  67      -7.759   8.412   6.965  1.00 46.17           C  
ATOM    571  C   VAL A  67      -8.363   7.267   7.743  1.00 41.89           C  
ATOM    572  O   VAL A  67      -9.448   7.401   8.258  1.00 41.38           O  
ATOM    573  CB  VAL A  67      -7.286   9.444   8.066  1.00 46.80           C  
ATOM    574  CG1 VAL A  67      -6.201   8.836   8.904  1.00 53.24           C  
ATOM    575  CG2 VAL A  67      -6.795  10.701   7.469  1.00 50.54           C  
ATOM    576  N   VAL A  68      -7.624   6.172   7.864  1.00 42.92           N  
ATOM    577  CA  VAL A  68      -7.968   5.077   8.775  1.00 43.24           C  
ATOM    578  C   VAL A  68      -6.815   4.927   9.763  1.00 43.01           C  
ATOM    579  O   VAL A  68      -5.643   4.869   9.358  1.00 41.99           O  
ATOM    580  CB  VAL A  68      -8.140   3.753   8.049  1.00 43.79           C  
ATOM    581  CG1 VAL A  68      -8.617   2.679   9.030  1.00 48.87           C  
ATOM    582  CG2 VAL A  68      -9.148   3.893   6.898  1.00 53.58           C  
ATOM    583  N   LEU A  69      -7.150   4.873  11.049  1.00 42.61           N  
ATOM    584  CA  LEU A  69      -6.178   4.641  12.103  1.00 43.13           C  
ATOM    585  C   LEU A  69      -6.222   3.187  12.483  1.00 42.54           C  
ATOM    586  O   LEU A  69      -7.299   2.634  12.755  1.00 44.68           O  
ATOM    587  CB  LEU A  69      -6.463   5.517  13.337  1.00 45.01           C  
ATOM    588  CG  LEU A  69      -5.445   5.449  14.500  1.00 47.94           C  
ATOM    589  CD1 LEU A  69      -5.462   6.735  15.275  1.00 55.38           C  
ATOM    590  CD2 LEU A  69      -5.706   4.293  15.465  1.00 52.48           C  
ATOM    591  N   VAL A  70      -5.052   2.563  12.516  1.00 43.28           N  
ATOM    592  CA  VAL A  70      -4.925   1.176  12.941  1.00 44.31           C  
ATOM    593  C   VAL A  70      -4.023   1.102  14.144  1.00 43.41           C  
ATOM    594  O   VAL A  70      -3.004   1.783  14.205  1.00 42.95           O  
ATOM    595  CB  VAL A  70      -4.339   0.306  11.828  1.00 46.15           C  
ATOM    596  CG1 VAL A  70      -4.281  -1.172  12.244  1.00 48.80           C  
ATOM    597  CG2 VAL A  70      -5.215   0.410  10.656  1.00 55.07           C  
ATOM    598  N   ASP A  71      -4.391   0.274  15.114  1.00 41.80           N  
ATOM    599  CA  ASP A  71      -3.546   0.118  16.276  1.00 41.79           C  
ATOM    600  C   ASP A  71      -3.973  -1.109  17.026  1.00 38.18           C  
ATOM    601  O   ASP A  71      -5.145  -1.372  17.088  1.00 39.27           O  
ATOM    602  CB  ASP A  71      -3.627   1.370  17.163  1.00 42.95           C  
ATOM    603  CG  ASP A  71      -2.460   1.467  18.145  1.00 45.70           C  
ATOM    604  OD1 ASP A  71      -2.481   0.713  19.146  1.00 50.33           O  
ATOM    605  OD2 ASP A  71      -1.545   2.297  17.920  1.00 41.26           O  
ATOM    606  N   PRO A  72      -3.015  -1.890  17.560  1.00 39.55           N  
ATOM    607  CA  PRO A  72      -3.352  -3.055  18.386  1.00 40.22           C  
ATOM    608  C   PRO A  72      -3.759  -2.762  19.829  1.00 40.65           C  
ATOM    609  O   PRO A  72      -4.219  -3.667  20.532  1.00 40.22           O  
ATOM    610  CB  PRO A  72      -2.063  -3.890  18.362  1.00 39.90           C  
ATOM    611  CG  PRO A  72      -0.994  -2.952  18.076  1.00 37.63           C  
ATOM    612  CD  PRO A  72      -1.558  -1.783  17.336  1.00 39.37           C  
ATOM    613  N   SER A  73      -3.582  -1.524  20.274  1.00 42.56           N  
ATOM    614  CA  SER A  73      -3.943  -1.175  21.650  1.00 43.54           C  
ATOM    615  C   SER A  73      -5.386  -0.708  21.716  1.00 42.66           C  
ATOM    616  O   SER A  73      -5.705   0.374  21.264  1.00 41.02           O  
ATOM    617  CB  SER A  73      -3.027  -0.081  22.218  1.00 43.66           C  
ATOM    618  OG  SER A  73      -3.545   0.388  23.465  1.00 43.24           O  
ATOM    619  N   LYS A  74      -6.242  -1.505  22.331  1.00 45.19           N  
ATOM    620  CA  LYS A  74      -7.650  -1.128  22.486  1.00 48.60           C  
ATOM    621  C   LYS A  74      -7.849   0.198  23.234  1.00 45.41           C  
ATOM    622  O   LYS A  74      -8.781   0.933  22.973  1.00 44.91           O  
ATOM    623  CB  LYS A  74      -8.397  -2.227  23.218  1.00 48.49           C  
ATOM    624  CG  LYS A  74      -8.506  -3.551  22.461  1.00 56.56           C  
ATOM    625  CD  LYS A  74      -9.124  -4.636  23.376  1.00 55.83           C  
ATOM    626  CE  LYS A  74      -8.902  -6.059  22.879  1.00 60.34           C  
ATOM    627  NZ  LYS A  74      -9.941  -6.464  21.934  1.00 61.03           N  
ATOM    628  N   GLU A  75      -6.960   0.515  24.160  1.00 45.26           N  
ATOM    629  CA  GLU A  75      -7.107   1.737  24.949  1.00 43.38           C  
ATOM    630  C   GLU A  75      -6.694   2.962  24.130  1.00 41.90           C  
ATOM    631  O   GLU A  75      -7.325   4.007  24.205  1.00 42.55           O  
ATOM    632  CB  GLU A  75      -6.290   1.644  26.227  1.00 42.27           C  
ATOM    633  CG  GLU A  75      -6.603   0.420  27.064  1.00 48.18           C  
ATOM    634  CD  GLU A  75      -8.008   0.442  27.660  1.00 57.50           C  
ATOM    635  OE1 GLU A  75      -8.535   1.552  27.945  1.00 54.08           O  
ATOM    636  OE2 GLU A  75      -8.569  -0.666  27.848  1.00 60.19           O  
HETATM  637  N   MSE A  76      -5.629   2.832  23.354  1.00 42.00           N  
HETATM  638  CA  MSE A  76      -5.211   3.906  22.445  1.00 43.40           C  
HETATM  639  C   MSE A  76      -6.361   4.217  21.474  1.00 41.29           C  
HETATM  640  O   MSE A  76      -6.717   5.377  21.273  1.00 38.85           O  
HETATM  641  CB  MSE A  76      -3.958   3.488  21.669  1.00 43.85           C  
HETATM  642  CG  MSE A  76      -2.735   3.311  22.536  1.00 50.84           C  
HETATM  643 SE   MSE A  76      -1.980   5.038  23.163  1.00 68.91          SE  
HETATM  644  CE  MSE A  76      -1.052   4.492  24.566  1.00 64.63           C  
ATOM    645  N   LEU A  77      -6.944   3.162  20.908  1.00 41.96           N  
ATOM    646  CA  LEU A  77      -8.062   3.278  19.962  1.00 42.72           C  
ATOM    647  C   LEU A  77      -9.241   3.977  20.593  1.00 42.35           C  
ATOM    648  O   LEU A  77      -9.841   4.826  19.972  1.00 44.91           O  
ATOM    649  CB  LEU A  77      -8.523   1.901  19.454  1.00 42.33           C  
ATOM    650  CG  LEU A  77      -7.586   1.124  18.521  1.00 45.47           C  
ATOM    651  CD1 LEU A  77      -8.232  -0.170  18.085  1.00 52.61           C  
ATOM    652  CD2 LEU A  77      -7.196   1.917  17.303  1.00 51.30           C  
ATOM    653  N   GLU A  78      -9.576   3.626  21.824  1.00 43.08           N  
ATOM    654  CA  GLU A  78     -10.672   4.294  22.524  1.00 42.90           C  
ATOM    655  C   GLU A  78     -10.378   5.784  22.736  1.00 42.79           C  
ATOM    656  O   GLU A  78     -11.266   6.610  22.617  1.00 44.03           O  
ATOM    657  CB  GLU A  78     -10.959   3.600  23.863  1.00 42.47           C  
ATOM    658  CG  GLU A  78     -12.092   4.219  24.714  1.00 48.96           C  
ATOM    659  CD  GLU A  78     -13.476   4.308  24.012  1.00 59.24           C  
ATOM    660  OE1 GLU A  78     -13.731   3.617  22.997  1.00 63.84           O  
ATOM    661  OE2 GLU A  78     -14.331   5.082  24.502  1.00 64.46           O  
ATOM    662  N   VAL A  79      -9.134   6.126  23.043  1.00 43.69           N  
ATOM    663  CA  VAL A  79      -8.757   7.541  23.207  1.00 44.58           C  
ATOM    664  C   VAL A  79      -8.871   8.271  21.859  1.00 44.11           C  
ATOM    665  O   VAL A  79      -9.406   9.382  21.806  1.00 44.17           O  
ATOM    666  CB  VAL A  79      -7.343   7.701  23.860  1.00 43.96           C  
ATOM    667  CG1 VAL A  79      -6.825   9.124  23.767  1.00 43.61           C  
ATOM    668  CG2 VAL A  79      -7.400   7.282  25.320  1.00 44.37           C  
ATOM    669  N   ALA A  80      -8.413   7.628  20.783  1.00 43.32           N  
ATOM    670  CA  ALA A  80      -8.528   8.207  19.427  1.00 46.01           C  
ATOM    671  C   ALA A  80      -9.981   8.502  19.008  1.00 47.47           C  
ATOM    672  O   ALA A  80     -10.279   9.550  18.444  1.00 48.57           O  
ATOM    673  CB  ALA A  80      -7.858   7.285  18.388  1.00 46.47           C  
ATOM    674  N   ARG A  81     -10.859   7.557  19.298  1.00 48.57           N  
ATOM    675  CA  ARG A  81     -12.268   7.632  18.976  1.00 53.15           C  
ATOM    676  C   ARG A  81     -12.895   8.842  19.716  1.00 50.76           C  
ATOM    677  O   ARG A  81     -13.573   9.665  19.106  1.00 52.26           O  
ATOM    678  CB  ARG A  81     -12.924   6.288  19.365  1.00 52.32           C  
ATOM    679  CG  ARG A  81     -14.016   5.761  18.424  1.00 63.55           C  
ATOM    680  CD  ARG A  81     -14.186   4.185  18.428  1.00 65.25           C  
ATOM    681  NE  ARG A  81     -13.616   3.480  19.602  1.00 80.53           N  
ATOM    682  CZ  ARG A  81     -13.091   2.240  19.600  1.00 78.02           C  
ATOM    683  NH1 ARG A  81     -13.030   1.505  18.484  1.00 74.82           N  
ATOM    684  NH2 ARG A  81     -12.601   1.721  20.732  1.00 72.44           N  
ATOM    685  N   GLU A  82     -12.632   8.953  21.016  1.00 48.53           N  
ATOM    686  CA  GLU A  82     -13.063  10.086  21.838  1.00 46.53           C  
ATOM    687  C   GLU A  82     -12.534  11.424  21.363  1.00 46.76           C  
ATOM    688  O   GLU A  82     -13.209  12.441  21.479  1.00 45.89           O  
ATOM    689  CB  GLU A  82     -12.599   9.881  23.269  1.00 45.99           C  
ATOM    690  CG  GLU A  82     -13.415   8.829  24.013  1.00 48.89           C  
ATOM    691  CD  GLU A  82     -12.831   8.455  25.366  1.00 52.00           C  
ATOM    692  OE1 GLU A  82     -12.009   9.221  25.924  1.00 54.13           O  
ATOM    693  OE2 GLU A  82     -13.192   7.382  25.878  1.00 52.11           O  
ATOM    694  N   LYS A  83     -11.314  11.433  20.847  1.00 47.15           N  
ATOM    695  CA  LYS A  83     -10.739  12.656  20.302  1.00 46.42           C  
ATOM    696  C   LYS A  83     -11.322  13.033  18.947  1.00 47.07           C  
ATOM    697  O   LYS A  83     -11.100  14.139  18.473  1.00 48.53           O  
ATOM    698  CB  LYS A  83      -9.228  12.536  20.209  1.00 46.98           C  
ATOM    699  CG  LYS A  83      -8.542  12.547  21.578  1.00 45.95           C  
ATOM    700  CD  LYS A  83      -7.068  12.141  21.478  1.00 49.99           C  
ATOM    701  CE  LYS A  83      -6.199  13.216  20.796  1.00 47.75           C  
ATOM    702  NZ  LYS A  83      -4.787  12.777  20.580  1.00 45.65           N  
ATOM    703  N   GLY A  84     -12.048  12.118  18.312  1.00 46.34           N  
ATOM    704  CA  GLY A  84     -12.723  12.419  17.055  1.00 45.86           C  
ATOM    705  C   GLY A  84     -12.163  11.780  15.797  1.00 45.03           C  
ATOM    706  O   GLY A  84     -12.518  12.179  14.701  1.00 45.56           O  
ATOM    707  N   VAL A  85     -11.304  10.783  15.932  1.00 44.76           N  
ATOM    708  CA  VAL A  85     -10.864  10.032  14.758  1.00 43.81           C  
ATOM    709  C   VAL A  85     -12.041   9.179  14.332  1.00 45.20           C  
ATOM    710  O   VAL A  85     -12.605   8.447  15.142  1.00 45.30           O  
ATOM    711  CB  VAL A  85      -9.633   9.161  15.029  1.00 42.84           C  
ATOM    712  CG1 VAL A  85      -9.226   8.392  13.777  1.00 43.76           C  
ATOM    713  CG2 VAL A  85      -8.479  10.027  15.499  1.00 43.11           C  
ATOM    714  N   LYS A  86     -12.404   9.294  13.053  1.00 46.16           N  
ATOM    715  CA  LYS A  86     -13.605   8.683  12.508  1.00 46.43           C  
ATOM    716  C   LYS A  86     -13.500   7.205  12.190  1.00 43.90           C  
ATOM    717  O   LYS A  86     -14.459   6.496  12.360  1.00 45.04           O  
ATOM    718  CB  LYS A  86     -14.049   9.456  11.261  1.00 48.33           C  
ATOM    719  CG  LYS A  86     -14.415  10.915  11.580  1.00 53.24           C  
ATOM    720  CD  LYS A  86     -15.389  11.508  10.564  1.00 60.94           C  
ATOM    721  CE  LYS A  86     -15.333  13.048  10.535  1.00 65.53           C  
ATOM    722  NZ  LYS A  86     -14.111  13.551   9.820  1.00 67.50           N  
ATOM    723  N   ASN A  87     -12.356   6.733  11.724  1.00 43.73           N  
ATOM    724  CA  ASN A  87     -12.194   5.326  11.325  1.00 41.61           C  
ATOM    725  C   ASN A  87     -11.061   4.690  12.074  1.00 42.40           C  
ATOM    726  O   ASN A  87      -9.909   5.094  11.899  1.00 43.88           O  
ATOM    727  CB  ASN A  87     -11.932   5.225   9.837  1.00 42.70           C  
ATOM    728  CG  ASN A  87     -13.010   5.925   9.018  1.00 46.79           C  
ATOM    729  OD1 ASN A  87     -12.784   7.029   8.564  1.00 48.31           O  
ATOM    730  ND2 ASN A  87     -14.193   5.305   8.866  1.00 46.33           N  
ATOM    731  N   VAL A  88     -11.385   3.766  12.980  1.00 41.85           N  
ATOM    732  CA  VAL A  88     -10.362   3.119  13.794  1.00 43.66           C  
ATOM    733  C   VAL A  88     -10.503   1.608  13.662  1.00 41.66           C  
ATOM    734  O   VAL A  88     -11.585   1.110  13.541  1.00 42.04           O  
ATOM    735  CB  VAL A  88     -10.379   3.586  15.297  1.00 43.39           C  
ATOM    736  CG1 VAL A  88     -10.359   5.083  15.402  1.00 45.38           C  
ATOM    737  CG2 VAL A  88     -11.575   3.064  15.992  1.00 50.32           C  
ATOM    738  N   VAL A  89      -9.383   0.897  13.671  1.00 41.96           N  
ATOM    739  CA  VAL A  89      -9.368  -0.535  13.454  1.00 39.98           C  
ATOM    740  C   VAL A  89      -8.305  -1.151  14.345  1.00 39.57           C  
ATOM    741  O   VAL A  89      -7.199  -0.611  14.451  1.00 37.94           O  
ATOM    742  CB  VAL A  89      -9.056  -0.847  11.972  1.00 40.40           C  
ATOM    743  CG1 VAL A  89      -8.793  -2.369  11.733  1.00 38.50           C  
ATOM    744  CG2 VAL A  89     -10.179  -0.343  11.101  1.00 39.82           C  
ATOM    745  N   GLU A  90      -8.636  -2.281  14.972  1.00 38.13           N  
ATOM    746  CA  GLU A  90      -7.694  -2.996  15.810  1.00 40.16           C  
ATOM    747  C   GLU A  90      -6.898  -3.979  14.971  1.00 40.05           C  
ATOM    748  O   GLU A  90      -7.433  -4.954  14.471  1.00 41.11           O  
ATOM    749  CB  GLU A  90      -8.421  -3.728  16.923  1.00 39.48           C  
ATOM    750  CG  GLU A  90      -7.509  -4.151  18.068  1.00 45.89           C  
ATOM    751  CD  GLU A  90      -8.213  -5.008  19.123  1.00 46.72           C  
ATOM    752  OE1 GLU A  90      -9.468  -5.107  19.121  1.00 56.46           O  
ATOM    753  OE2 GLU A  90      -7.498  -5.585  19.960  1.00 53.98           O  
ATOM    754  N   ALA A  91      -5.615  -3.718  14.782  1.00 42.00           N  
ATOM    755  CA  ALA A  91      -4.765  -4.671  14.075  1.00 43.23           C  
ATOM    756  C   ALA A  91      -3.294  -4.347  14.311  1.00 43.43           C  
ATOM    757  O   ALA A  91      -2.965  -3.258  14.754  1.00 42.50           O  
ATOM    758  CB  ALA A  91      -5.087  -4.656  12.567  1.00 41.33           C  
ATOM    759  N   LYS A  92      -2.443  -5.330  14.038  1.00 44.83           N  
ATOM    760  CA  LYS A  92      -1.007  -5.198  14.039  1.00 46.57           C  
ATOM    761  C   LYS A  92      -0.509  -5.007  12.610  1.00 46.12           C  
ATOM    762  O   LYS A  92      -1.119  -5.474  11.642  1.00 46.19           O  
ATOM    763  CB  LYS A  92      -0.346  -6.469  14.581  1.00 46.47           C  
ATOM    764  CG  LYS A  92      -0.666  -6.869  16.009  1.00 50.78           C  
ATOM    765  CD  LYS A  92       0.028  -8.208  16.328  1.00 53.01           C  
ATOM    766  CE  LYS A  92      -0.338  -8.766  17.707  1.00 64.47           C  
ATOM    767  N   ALA A  93       0.655  -4.368  12.506  1.00 45.04           N  
ATOM    768  CA  ALA A  93       1.325  -4.163  11.251  1.00 45.99           C  
ATOM    769  C   ALA A  93       1.656  -5.474  10.546  1.00 45.73           C  
ATOM    770  O   ALA A  93       1.668  -5.534   9.325  1.00 43.84           O  
ATOM    771  CB  ALA A  93       2.601  -3.352  11.474  1.00 47.44           C  
ATOM    772  N   GLU A  94       1.917  -6.515  11.328  1.00 47.60           N  
ATOM    773  CA  GLU A  94       2.300  -7.823  10.801  1.00 47.06           C  
ATOM    774  C   GLU A  94       1.209  -8.487   9.990  1.00 47.59           C  
ATOM    775  O   GLU A  94       1.508  -9.340   9.160  1.00 48.11           O  
ATOM    776  CB  GLU A  94       2.727  -8.748  11.939  1.00 46.37           C  
ATOM    777  CG  GLU A  94       4.070  -8.331  12.561  1.00 52.85           C  
ATOM    778  CD  GLU A  94       3.949  -7.324  13.692  1.00 43.66           C  
ATOM    779  OE1 GLU A  94       2.950  -6.594  13.775  1.00 50.63           O  
ATOM    780  OE2 GLU A  94       4.851  -7.298  14.526  1.00 52.43           O  
ATOM    781  N   ASP A  95      -0.046  -8.082  10.212  1.00 47.03           N  
ATOM    782  CA  ASP A  95      -1.192  -8.714   9.558  1.00 46.82           C  
ATOM    783  C   ASP A  95      -2.346  -7.693   9.433  1.00 44.62           C  
ATOM    784  O   ASP A  95      -3.204  -7.584  10.299  1.00 46.79           O  
ATOM    785  CB  ASP A  95      -1.576  -9.973  10.358  1.00 46.29           C  
ATOM    786  CG  ASP A  95      -2.523 -10.905   9.599  1.00 58.75           C  
ATOM    787  OD1 ASP A  95      -2.855 -10.655   8.406  1.00 64.66           O  
ATOM    788  OD2 ASP A  95      -2.965 -11.901  10.226  1.00 67.19           O  
ATOM    789  N   LEU A  96      -2.325  -6.918   8.352  1.00 43.78           N  
ATOM    790  CA  LEU A  96      -3.260  -5.801   8.131  1.00 44.02           C  
ATOM    791  C   LEU A  96      -4.478  -6.268   7.350  1.00 43.94           C  
ATOM    792  O   LEU A  96      -4.336  -6.918   6.320  1.00 44.85           O  
ATOM    793  CB  LEU A  96      -2.600  -4.684   7.331  1.00 43.11           C  
ATOM    794  CG  LEU A  96      -1.516  -3.884   8.001  1.00 45.95           C  
ATOM    795  CD1 LEU A  96      -0.824  -2.954   7.000  1.00 44.06           C  
ATOM    796  CD2 LEU A  96      -2.127  -3.106   9.178  1.00 48.89           C  
ATOM    797  N   PRO A  97      -5.684  -5.974   7.862  1.00 43.73           N  
ATOM    798  CA  PRO A  97      -6.878  -6.469   7.219  1.00 44.48           C  
ATOM    799  C   PRO A  97      -7.446  -5.483   6.177  1.00 44.41           C  
ATOM    800  O   PRO A  97      -8.610  -5.110   6.231  1.00 46.80           O  
ATOM    801  CB  PRO A  97      -7.815  -6.658   8.407  1.00 42.69           C  
ATOM    802  CG  PRO A  97      -7.496  -5.469   9.252  1.00 41.94           C  
ATOM    803  CD  PRO A  97      -6.015  -5.256   9.107  1.00 42.06           C  
ATOM    804  N   PHE A  98      -6.613  -5.058   5.250  1.00 44.47           N  
ATOM    805  CA  PHE A  98      -7.019  -4.160   4.186  1.00 43.46           C  
ATOM    806  C   PHE A  98      -6.588  -4.817   2.903  1.00 43.32           C  
ATOM    807  O   PHE A  98      -5.608  -5.549   2.906  1.00 41.20           O  
ATOM    808  CB  PHE A  98      -6.322  -2.823   4.329  1.00 44.16           C  
ATOM    809  CG  PHE A  98      -6.718  -2.097   5.555  1.00 47.97           C  
ATOM    810  CD1 PHE A  98      -7.872  -1.341   5.576  1.00 48.45           C  
ATOM    811  CD2 PHE A  98      -5.967  -2.202   6.712  1.00 50.68           C  
ATOM    812  CE1 PHE A  98      -8.260  -0.687   6.725  1.00 46.97           C  
ATOM    813  CE2 PHE A  98      -6.365  -1.552   7.875  1.00 54.20           C  
ATOM    814  CZ  PHE A  98      -7.510  -0.802   7.880  1.00 45.76           C  
ATOM    815  N   PRO A  99      -7.300  -4.539   1.798  1.00 43.63           N  
ATOM    816  CA  PRO A  99      -6.925  -5.166   0.539  1.00 42.25           C  
ATOM    817  C   PRO A  99      -5.693  -4.488   0.011  1.00 42.08           C  
ATOM    818  O   PRO A  99      -5.340  -3.394   0.468  1.00 43.44           O  
ATOM    819  CB  PRO A  99      -8.122  -4.891  -0.370  1.00 42.98           C  
ATOM    820  CG  PRO A  99      -8.722  -3.607   0.170  1.00 44.80           C  
ATOM    821  CD  PRO A  99      -8.443  -3.607   1.654  1.00 43.60           C  
ATOM    822  N   SER A 100      -5.050  -5.143  -0.940  1.00 41.02           N  
ATOM    823  CA  SER A 100      -3.885  -4.631  -1.611  1.00 41.56           C  
ATOM    824  C   SER A 100      -4.206  -3.326  -2.351  1.00 43.33           C  
ATOM    825  O   SER A 100      -5.307  -3.146  -2.862  1.00 44.68           O  
ATOM    826  CB  SER A 100      -3.412  -5.658  -2.637  1.00 40.47           C  
ATOM    827  OG  SER A 100      -3.079  -6.885  -2.020  1.00 45.67           O  
ATOM    828  N   GLY A 101      -3.237  -2.432  -2.431  1.00 43.09           N  
ATOM    829  CA  GLY A 101      -3.390  -1.227  -3.237  1.00 43.37           C  
ATOM    830  C   GLY A 101      -4.428  -0.233  -2.740  1.00 42.38           C  
ATOM    831  O   GLY A 101      -4.937   0.539  -3.524  1.00 43.62           O  
ATOM    832  N   ALA A 102      -4.711  -0.207  -1.441  1.00 42.18           N  
ATOM    833  CA  ALA A 102      -5.819   0.605  -0.930  1.00 43.17           C  
ATOM    834  C   ALA A 102      -5.446   2.028  -0.537  1.00 44.33           C  
ATOM    835  O   ALA A 102      -6.352   2.857  -0.367  1.00 45.48           O  
ATOM    836  CB  ALA A 102      -6.467  -0.074   0.242  1.00 44.28           C  
ATOM    837  N   PHE A 103      -4.141   2.293  -0.367  1.00 41.68           N  
ATOM    838  CA  PHE A 103      -3.654   3.549   0.173  1.00 40.98           C  
ATOM    839  C   PHE A 103      -2.558   4.168  -0.669  1.00 40.15           C  
ATOM    840  O   PHE A 103      -1.739   3.467  -1.240  1.00 40.43           O  
ATOM    841  CB  PHE A 103      -3.115   3.348   1.582  1.00 40.64           C  
ATOM    842  CG  PHE A 103      -4.119   2.786   2.544  1.00 39.14           C  
ATOM    843  CD1 PHE A 103      -5.066   3.608   3.139  1.00 42.15           C  
ATOM    844  CD2 PHE A 103      -4.108   1.440   2.870  1.00 43.78           C  
ATOM    845  CE1 PHE A 103      -5.993   3.097   4.057  1.00 40.51           C  
ATOM    846  CE2 PHE A 103      -5.027   0.928   3.772  1.00 42.33           C  
ATOM    847  CZ  PHE A 103      -5.966   1.764   4.368  1.00 37.79           C  
ATOM    848  N   GLU A 104      -2.567   5.496  -0.734  1.00 39.88           N  
ATOM    849  CA  GLU A 104      -1.485   6.252  -1.323  1.00 41.12           C  
ATOM    850  C   GLU A 104      -0.354   6.471  -0.352  1.00 39.54           C  
ATOM    851  O   GLU A 104       0.767   6.703  -0.767  1.00 40.27           O  
ATOM    852  CB  GLU A 104      -1.981   7.619  -1.819  1.00 44.18           C  
ATOM    853  CG  GLU A 104      -2.667   7.569  -3.181  1.00 43.99           C  
ATOM    854  CD  GLU A 104      -4.090   7.069  -3.128  1.00 48.95           C  
ATOM    855  OE1 GLU A 104      -4.774   7.296  -2.108  1.00 50.65           O  
ATOM    856  OE2 GLU A 104      -4.526   6.467  -4.129  1.00 55.90           O  
ATOM    857  N   ALA A 105      -0.644   6.423   0.939  1.00 40.39           N  
ATOM    858  CA  ALA A 105       0.377   6.587   1.952  1.00 41.86           C  
ATOM    859  C   ALA A 105       0.040   5.845   3.219  1.00 42.37           C  
ATOM    860  O   ALA A 105      -1.125   5.749   3.592  1.00 43.34           O  
ATOM    861  CB  ALA A 105       0.604   8.064   2.262  1.00 43.64           C  
ATOM    862  N   VAL A 106       1.089   5.339   3.872  1.00 43.47           N  
ATOM    863  CA  VAL A 106       1.041   4.763   5.212  1.00 43.25           C  
ATOM    864  C   VAL A 106       1.939   5.611   6.115  1.00 45.30           C  
ATOM    865  O   VAL A 106       3.070   5.960   5.751  1.00 45.31           O  
ATOM    866  CB  VAL A 106       1.563   3.315   5.211  1.00 44.20           C  
ATOM    867  CG1 VAL A 106       1.599   2.734   6.618  1.00 43.19           C  
ATOM    868  CG2 VAL A 106       0.709   2.440   4.289  1.00 45.29           C  
ATOM    869  N   LEU A 107       1.429   5.963   7.283  1.00 45.88           N  
ATOM    870  CA  LEU A 107       2.221   6.655   8.291  1.00 46.50           C  
ATOM    871  C   LEU A 107       2.618   5.622   9.316  1.00 46.32           C  
ATOM    872  O   LEU A 107       1.799   4.802   9.705  1.00 47.32           O  
ATOM    873  CB  LEU A 107       1.402   7.739   8.988  1.00 44.99           C  
ATOM    874  CG  LEU A 107       0.789   8.820   8.115  1.00 48.05           C  
ATOM    875  CD1 LEU A 107       0.139   9.866   8.983  1.00 53.92           C  
ATOM    876  CD2 LEU A 107       1.817   9.460   7.209  1.00 54.05           C  
ATOM    877  N   ALA A 108       3.871   5.649   9.750  1.00 46.02           N  
ATOM    878  CA  ALA A 108       4.283   4.826  10.881  1.00 46.36           C  
ATOM    879  C   ALA A 108       5.167   5.681  11.777  1.00 45.72           C  
ATOM    880  O   ALA A 108       6.365   5.444  11.944  1.00 44.16           O  
ATOM    881  CB  ALA A 108       5.004   3.557  10.408  1.00 48.10           C  
ATOM    882  N   LEU A 109       4.516   6.684  12.347  1.00 44.91           N  
ATOM    883  CA  LEU A 109       5.134   7.702  13.150  1.00 43.62           C  
ATOM    884  C   LEU A 109       5.176   7.283  14.632  1.00 43.79           C  
ATOM    885  O   LEU A 109       4.508   6.325  15.024  1.00 45.57           O  
ATOM    886  CB  LEU A 109       4.339   8.992  12.971  1.00 42.71           C  
ATOM    887  CG  LEU A 109       4.292   9.522  11.523  1.00 47.67           C  
ATOM    888  CD1 LEU A 109       3.476  10.776  11.436  1.00 50.91           C  
ATOM    889  CD2 LEU A 109       5.658   9.797  10.955  1.00 45.37           C  
ATOM    890  N   GLY A 110       5.970   7.990  15.434  1.00 43.74           N  
ATOM    891  CA  GLY A 110       6.172   7.665  16.871  1.00 44.18           C  
ATOM    892  C   GLY A 110       6.880   6.343  17.131  1.00 44.21           C  
ATOM    893  O   GLY A 110       6.562   5.631  18.091  1.00 45.93           O  
ATOM    894  N   ASP A 111       7.805   5.998  16.237  1.00 45.99           N  
ATOM    895  CA  ASP A 111       8.704   4.833  16.372  1.00 47.61           C  
ATOM    896  C   ASP A 111       8.031   3.476  16.325  1.00 46.70           C  
ATOM    897  O   ASP A 111       8.545   2.523  16.889  1.00 48.55           O  
ATOM    898  CB  ASP A 111       9.585   4.974  17.631  1.00 50.31           C  
ATOM    899  CG  ASP A 111      10.204   6.378  17.759  1.00 54.61           C  
ATOM    900  OD1 ASP A 111      10.800   6.902  16.771  1.00 58.58           O  
ATOM    901  OD2 ASP A 111      10.048   6.968  18.847  1.00 71.58           O  
ATOM    902  N   VAL A 112       6.913   3.371  15.598  1.00 46.70           N  
ATOM    903  CA  VAL A 112       6.141   2.126  15.519  1.00 44.79           C  
ATOM    904  C   VAL A 112       6.952   0.951  15.003  1.00 41.89           C  
ATOM    905  O   VAL A 112       6.869  -0.160  15.528  1.00 42.32           O  
ATOM    906  CB  VAL A 112       4.891   2.303  14.633  1.00 47.94           C  
ATOM    907  CG1 VAL A 112       4.220   0.934  14.311  1.00 49.32           C  
ATOM    908  CG2 VAL A 112       3.882   3.244  15.335  1.00 49.75           C  
ATOM    909  N   LEU A 113       7.737   1.185  13.972  1.00 41.48           N  
ATOM    910  CA  LEU A 113       8.515   0.106  13.367  1.00 40.76           C  
ATOM    911  C   LEU A 113       9.686  -0.313  14.220  1.00 39.90           C  
ATOM    912  O   LEU A 113      10.233  -1.394  14.012  1.00 41.05           O  
ATOM    913  CB  LEU A 113       8.977   0.492  11.969  1.00 43.11           C  
ATOM    914  CG  LEU A 113       7.853   0.582  10.933  1.00 44.99           C  
ATOM    915  CD1 LEU A 113       8.285   1.322   9.720  1.00 45.45           C  
ATOM    916  CD2 LEU A 113       7.376  -0.810  10.564  1.00 47.29           C  
ATOM    917  N   SER A 114      10.077   0.519  15.183  1.00 40.28           N  
ATOM    918  CA  SER A 114      11.008   0.065  16.227  1.00 40.95           C  
ATOM    919  C   SER A 114      10.303  -0.884  17.222  1.00 41.08           C  
ATOM    920  O   SER A 114      10.947  -1.693  17.860  1.00 39.37           O  
ATOM    921  CB  SER A 114      11.673   1.254  16.938  1.00 42.42           C  
ATOM    922  OG  SER A 114      12.639   1.874  16.071  1.00 45.74           O  
ATOM    923  N   TYR A 115       8.974  -0.817  17.308  1.00 42.37           N  
ATOM    924  CA  TYR A 115       8.203  -1.661  18.245  1.00 43.25           C  
ATOM    925  C   TYR A 115       7.590  -2.939  17.694  1.00 42.99           C  
ATOM    926  O   TYR A 115       7.328  -3.850  18.476  1.00 42.97           O  
ATOM    927  CB  TYR A 115       7.075  -0.855  18.881  1.00 44.36           C  
ATOM    928  CG  TYR A 115       7.516   0.460  19.498  1.00 46.44           C  
ATOM    929  CD1 TYR A 115       8.824   0.653  19.963  1.00 48.63           C  
ATOM    930  CD2 TYR A 115       6.608   1.500  19.645  1.00 45.21           C  
ATOM    931  CE1 TYR A 115       9.204   1.861  20.539  1.00 49.76           C  
ATOM    932  CE2 TYR A 115       6.962   2.681  20.229  1.00 45.99           C  
ATOM    933  CZ  TYR A 115       8.257   2.868  20.672  1.00 50.09           C  
ATOM    934  OH  TYR A 115       8.579   4.072  21.244  1.00 52.42           O  
ATOM    935  N   VAL A 116       7.348  -3.018  16.386  1.00 43.62           N  
ATOM    936  CA  VAL A 116       6.706  -4.206  15.815  1.00 44.57           C  
ATOM    937  C   VAL A 116       7.615  -5.410  16.028  1.00 45.58           C  
ATOM    938  O   VAL A 116       8.821  -5.299  15.964  1.00 44.50           O  
ATOM    939  CB  VAL A 116       6.359  -4.068  14.302  1.00 43.57           C  
ATOM    940  CG1 VAL A 116       5.620  -2.763  14.038  1.00 45.18           C  
ATOM    941  CG2 VAL A 116       7.604  -4.125  13.436  1.00 46.16           C  
ATOM    942  N   GLU A 117       7.020  -6.564  16.270  1.00 47.47           N  
ATOM    943  CA  GLU A 117       7.769  -7.748  16.648  1.00 48.56           C  
ATOM    944  C   GLU A 117       8.362  -8.452  15.440  1.00 48.03           C  
ATOM    945  O   GLU A 117       9.351  -9.172  15.579  1.00 48.98           O  
ATOM    946  CB  GLU A 117       6.868  -8.694  17.431  1.00 47.28           C  
ATOM    947  CG  GLU A 117       6.390  -8.077  18.746  1.00 54.73           C  
ATOM    948  CD  GLU A 117       5.602  -9.050  19.643  1.00 54.52           C  
ATOM    949  OE1 GLU A 117       4.779  -9.854  19.122  1.00 50.04           O  
ATOM    950  OE2 GLU A 117       5.814  -8.986  20.879  1.00 60.95           O  
ATOM    951  N   ASN A 118       7.760  -8.270  14.265  1.00 47.50           N  
ATOM    952  CA  ASN A 118       8.298  -8.855  13.034  1.00 47.35           C  
ATOM    953  C   ASN A 118       8.333  -7.802  11.941  1.00 48.27           C  
ATOM    954  O   ASN A 118       7.338  -7.566  11.270  1.00 49.18           O  
ATOM    955  CB  ASN A 118       7.483 -10.073  12.600  1.00 45.83           C  
ATOM    956  CG  ASN A 118       8.138 -10.846  11.474  1.00 44.05           C  
ATOM    957  OD1 ASN A 118       8.885 -10.299  10.680  1.00 52.73           O  
ATOM    958  ND2 ASN A 118       7.840 -12.122  11.392  1.00 40.60           N  
ATOM    959  N   LYS A 119       9.490  -7.162  11.797  1.00 49.46           N  
ATOM    960  CA  LYS A 119       9.707  -6.126  10.793  1.00 50.82           C  
ATOM    961  C   LYS A 119       9.489  -6.620   9.362  1.00 51.79           C  
ATOM    962  O   LYS A 119       8.937  -5.909   8.525  1.00 54.22           O  
ATOM    963  CB  LYS A 119      11.114  -5.568  10.930  1.00 50.44           C  
ATOM    964  CG  LYS A 119      11.313  -4.628  12.134  1.00 53.75           C  
ATOM    965  CD  LYS A 119      12.808  -4.259  12.335  1.00 52.79           C  
ATOM    966  CE  LYS A 119      13.601  -5.361  13.065  1.00 54.23           C  
ATOM    967  NZ  LYS A 119      12.982  -5.710  14.391  1.00 55.14           N  
ATOM    968  N   ASP A 120       9.915  -7.834   9.075  1.00 50.97           N  
ATOM    969  CA  ASP A 120       9.739  -8.365   7.734  1.00 52.95           C  
ATOM    970  C   ASP A 120       8.282  -8.442   7.322  1.00 50.88           C  
ATOM    971  O   ASP A 120       7.929  -7.928   6.273  1.00 52.20           O  
ATOM    972  CB  ASP A 120      10.389  -9.732   7.612  1.00 54.10           C  
ATOM    973  CG  ASP A 120      11.902  -9.664   7.771  1.00 62.00           C  
ATOM    974  OD1 ASP A 120      12.429  -8.560   8.068  1.00 65.41           O  
ATOM    975  OD2 ASP A 120      12.553 -10.720   7.598  1.00 74.81           O  
ATOM    976  N   LYS A 121       7.437  -9.044   8.155  1.00 48.80           N  
ATOM    977  CA  LYS A 121       5.999  -9.070   7.867  1.00 48.96           C  
ATOM    978  C   LYS A 121       5.450  -7.651   7.803  1.00 46.49           C  
ATOM    979  O   LYS A 121       4.620  -7.352   6.952  1.00 46.07           O  
ATOM    980  CB  LYS A 121       5.219  -9.877   8.899  1.00 48.19           C  
ATOM    981  CG  LYS A 121       5.525 -11.345   8.926  1.00 48.75           C  
ATOM    982  CD  LYS A 121       4.712 -12.075  10.025  1.00 52.61           C  
ATOM    983  CE  LYS A 121       4.422 -13.569   9.669  1.00 53.82           C  
ATOM    984  N   ALA A 122       5.932  -6.774   8.682  1.00 44.55           N  
ATOM    985  CA  ALA A 122       5.392  -5.434   8.755  1.00 44.34           C  
ATOM    986  C   ALA A 122       5.678  -4.643   7.470  1.00 43.73           C  
ATOM    987  O   ALA A 122       4.776  -4.019   6.913  1.00 40.59           O  
ATOM    988  CB  ALA A 122       5.927  -4.694   9.993  1.00 46.38           C  
ATOM    989  N   PHE A 123       6.916  -4.687   6.986  1.00 44.25           N  
ATOM    990  CA  PHE A 123       7.262  -4.015   5.716  1.00 45.40           C  
ATOM    991  C   PHE A 123       6.597  -4.687   4.518  1.00 45.82           C  
ATOM    992  O   PHE A 123       6.258  -4.060   3.523  1.00 46.61           O  
ATOM    993  CB  PHE A 123       8.777  -3.990   5.486  1.00 44.50           C  
ATOM    994  CG  PHE A 123       9.492  -2.964   6.281  1.00 47.57           C  
ATOM    995  CD1 PHE A 123       9.372  -1.618   5.963  1.00 48.21           C  
ATOM    996  CD2 PHE A 123      10.299  -3.331   7.355  1.00 51.88           C  
ATOM    997  CE1 PHE A 123      10.053  -0.659   6.693  1.00 51.19           C  
ATOM    998  CE2 PHE A 123      10.967  -2.374   8.096  1.00 52.11           C  
ATOM    999  CZ  PHE A 123      10.851  -1.032   7.763  1.00 51.82           C  
ATOM   1000  N   SER A 124       6.418  -5.986   4.620  1.00 44.67           N  
ATOM   1001  CA  SER A 124       5.706  -6.695   3.592  1.00 45.67           C  
ATOM   1002  C   SER A 124       4.227  -6.228   3.494  1.00 46.08           C  
ATOM   1003  O   SER A 124       3.693  -6.046   2.389  1.00 47.50           O  
ATOM   1004  CB  SER A 124       5.803  -8.193   3.865  1.00 41.25           C  
ATOM   1005  OG  SER A 124       5.137  -8.874   2.839  1.00 55.88           O  
ATOM   1006  N   GLU A 125       3.585  -6.029   4.641  1.00 43.61           N  
ATOM   1007  CA  GLU A 125       2.174  -5.669   4.661  1.00 45.35           C  
ATOM   1008  C   GLU A 125       1.955  -4.237   4.228  1.00 44.92           C  
ATOM   1009  O   GLU A 125       0.945  -3.916   3.615  1.00 45.63           O  
ATOM   1010  CB  GLU A 125       1.584  -5.871   6.059  1.00 45.29           C  
ATOM   1011  CG  GLU A 125       1.287  -7.327   6.395  1.00 47.37           C  
ATOM   1012  CD  GLU A 125       0.191  -7.918   5.529  1.00 49.24           C  
ATOM   1013  OE1 GLU A 125      -0.993  -7.725   5.844  1.00 40.89           O  
ATOM   1014  OE2 GLU A 125       0.513  -8.588   4.535  1.00 50.74           O  
ATOM   1015  N   ILE A 126       2.895  -3.376   4.583  1.00 45.11           N  
ATOM   1016  CA  ILE A 126       2.838  -1.972   4.221  1.00 46.19           C  
ATOM   1017  C   ILE A 126       2.946  -1.864   2.711  1.00 45.60           C  
ATOM   1018  O   ILE A 126       2.198  -1.126   2.087  1.00 47.22           O  
ATOM   1019  CB  ILE A 126       3.969  -1.175   4.903  1.00 46.41           C  
ATOM   1020  CG1 ILE A 126       3.678  -1.068   6.411  1.00 45.45           C  
ATOM   1021  CG2 ILE A 126       4.157   0.220   4.251  1.00 45.32           C  
ATOM   1022  CD1 ILE A 126       4.939  -0.771   7.249  1.00 44.53           C  
ATOM   1023  N   ARG A 127       3.866  -2.627   2.142  1.00 44.33           N  
ATOM   1024  CA  ARG A 127       4.101  -2.583   0.701  0.50 44.10           C  
ATOM   1026  C   ARG A 127       2.869  -3.116  -0.002  1.00 43.20           C  
ATOM   1027  O   ARG A 127       2.453  -2.577  -1.006  1.00 43.16           O  
ATOM   1028  CB  ARG A 127       5.340  -3.389   0.299  0.50 43.47           C  
ATOM   1030  CG  ARG A 127       5.666  -3.302  -1.195  0.50 45.98           C  
ATOM   1032  CD  ARG A 127       6.685  -4.346  -1.652  0.50 44.73           C  
ATOM   1034  NE  ARG A 127       6.261  -5.021  -2.880  0.50 42.63           N  
ATOM   1036  CZ  ARG A 127       6.417  -4.565  -4.132  0.50 41.95           C  
ATOM   1038  NH1 ARG A 127       6.997  -3.389  -4.405  0.50 29.40           N  
ATOM   1040  NH2 ARG A 127       5.960  -5.303  -5.132  0.50 37.93           N  
ATOM   1042  N   ARG A 128       2.281  -4.162   0.551  1.00 43.24           N  
ATOM   1043  CA  ARG A 128       1.078  -4.724  -0.003  1.00 42.52           C  
ATOM   1044  C   ARG A 128      -0.088  -3.723  -0.077  1.00 41.44           C  
ATOM   1045  O   ARG A 128      -0.774  -3.651  -1.084  1.00 42.35           O  
ATOM   1046  CB  ARG A 128       0.652  -5.976   0.787  1.00 42.56           C  
ATOM   1047  CG  ARG A 128      -0.431  -6.807   0.056  1.00 39.87           C  
ATOM   1048  CD  ARG A 128      -0.960  -8.027   0.863  1.00 40.50           C  
ATOM   1049  NE  ARG A 128      -1.435  -7.663   2.197  1.00 38.02           N  
ATOM   1050  CZ  ARG A 128      -2.593  -7.070   2.453  1.00 38.85           C  
ATOM   1051  NH1 ARG A 128      -3.442  -6.783   1.475  1.00 43.43           N  
ATOM   1052  NH2 ARG A 128      -2.904  -6.761   3.704  1.00 45.09           N  
ATOM   1053  N   VAL A 129      -0.313  -2.959   0.977  1.00 42.24           N  
ATOM   1054  CA  VAL A 129      -1.524  -2.137   1.063  1.00 42.63           C  
ATOM   1055  C   VAL A 129      -1.397  -0.814   0.332  1.00 42.93           C  
ATOM   1056  O   VAL A 129      -2.385  -0.106   0.151  1.00 44.87           O  
ATOM   1057  CB  VAL A 129      -1.988  -1.900   2.526  1.00 42.44           C  
ATOM   1058  CG1 VAL A 129      -2.292  -3.224   3.189  1.00 45.64           C  
ATOM   1059  CG2 VAL A 129      -0.979  -1.087   3.345  1.00 44.01           C  
ATOM   1060  N   LEU A 130      -0.184  -0.493  -0.097  1.00 43.92           N  
ATOM   1061  CA  LEU A 130       0.081   0.742  -0.832  1.00 43.49           C  
ATOM   1062  C   LEU A 130      -0.118   0.515  -2.329  1.00 42.11           C  
ATOM   1063  O   LEU A 130       0.145  -0.570  -2.838  1.00 40.44           O  
ATOM   1064  CB  LEU A 130       1.518   1.198  -0.614  1.00 42.93           C  
ATOM   1065  CG  LEU A 130       1.854   1.879   0.703  1.00 46.27           C  
ATOM   1066  CD1 LEU A 130       3.394   1.943   0.827  1.00 45.70           C  
ATOM   1067  CD2 LEU A 130       1.217   3.275   0.801  1.00 42.22           C  
ATOM   1068  N   VAL A 131      -0.567   1.552  -3.021  1.00 41.01           N  
ATOM   1069  CA  VAL A 131      -0.534   1.557  -4.485  1.00 41.91           C  
ATOM   1070  C   VAL A 131       0.904   1.666  -4.985  1.00 42.00           C  
ATOM   1071  O   VAL A 131       1.770   2.201  -4.297  1.00 41.29           O  
ATOM   1072  CB  VAL A 131      -1.362   2.734  -5.090  1.00 42.28           C  
ATOM   1073  CG1 VAL A 131      -2.807   2.603  -4.702  1.00 45.01           C  
ATOM   1074  CG2 VAL A 131      -0.836   4.107  -4.634  1.00 39.01           C  
ATOM   1075  N   PRO A 132       1.155   1.195  -6.210  1.00 42.96           N  
ATOM   1076  CA  PRO A 132       2.461   1.487  -6.783  1.00 44.85           C  
ATOM   1077  C   PRO A 132       2.781   2.991  -6.698  1.00 45.03           C  
ATOM   1078  O   PRO A 132       1.925   3.825  -6.991  1.00 43.81           O  
ATOM   1079  CB  PRO A 132       2.322   1.025  -8.244  1.00 44.42           C  
ATOM   1080  CG  PRO A 132       1.226   0.026  -8.221  1.00 44.10           C  
ATOM   1081  CD  PRO A 132       0.290   0.446  -7.130  1.00 41.12           C  
ATOM   1082  N   ASP A 133       4.005   3.301  -6.275  1.00 46.06           N  
ATOM   1083  CA  ASP A 133       4.471   4.665  -5.990  1.00 47.05           C  
ATOM   1084  C   ASP A 133       3.888   5.299  -4.739  1.00 47.14           C  
ATOM   1085  O   ASP A 133       4.078   6.488  -4.526  1.00 49.04           O  
ATOM   1086  CB  ASP A 133       4.254   5.601  -7.171  1.00 48.58           C  
ATOM   1087  CG  ASP A 133       4.981   5.140  -8.416  1.00 56.49           C  
ATOM   1088  OD1 ASP A 133       6.202   4.831  -8.344  1.00 60.97           O  
ATOM   1089  OD2 ASP A 133       4.307   5.091  -9.464  1.00 62.60           O  
ATOM   1090  N   GLY A 134       3.200   4.529  -3.900  1.00 46.05           N  
ATOM   1091  CA  GLY A 134       2.765   5.044  -2.609  1.00 44.47           C  
ATOM   1092  C   GLY A 134       3.934   5.191  -1.642  1.00 43.14           C  
ATOM   1093  O   GLY A 134       4.961   4.533  -1.785  1.00 39.83           O  
ATOM   1094  N   LEU A 135       3.760   6.033  -0.632  1.00 43.84           N  
ATOM   1095  CA  LEU A 135       4.827   6.319   0.309  1.00 44.33           C  
ATOM   1096  C   LEU A 135       4.595   5.700   1.674  1.00 43.72           C  
ATOM   1097  O   LEU A 135       3.488   5.687   2.161  1.00 43.97           O  
ATOM   1098  CB  LEU A 135       4.996   7.828   0.494  1.00 45.03           C  
ATOM   1099  CG  LEU A 135       5.079   8.676  -0.774  1.00 45.01           C  
ATOM   1100  CD1 LEU A 135       5.020  10.102  -0.360  1.00 43.82           C  
ATOM   1101  CD2 LEU A 135       6.341   8.370  -1.608  1.00 41.69           C  
ATOM   1102  N   LEU A 136       5.670   5.202   2.277  1.00 45.16           N  
ATOM   1103  CA  LEU A 136       5.737   4.973   3.723  1.00 44.62           C  
ATOM   1104  C   LEU A 136       6.524   6.151   4.301  1.00 44.49           C  
ATOM   1105  O   LEU A 136       7.598   6.497   3.815  1.00 43.50           O  
ATOM   1106  CB  LEU A 136       6.436   3.659   4.039  1.00 43.29           C  
ATOM   1107  CG  LEU A 136       6.816   3.428   5.503  1.00 42.19           C  
ATOM   1108  CD1 LEU A 136       5.632   3.258   6.485  1.00 42.31           C  
ATOM   1109  CD2 LEU A 136       7.697   2.194   5.521  1.00 45.50           C  
ATOM   1110  N   ILE A 137       5.941   6.774   5.312  1.00 43.61           N  
ATOM   1111  CA  ILE A 137       6.499   7.908   6.012  1.00 43.07           C  
ATOM   1112  C   ILE A 137       6.557   7.501   7.479  1.00 44.73           C  
ATOM   1113  O   ILE A 137       5.521   7.213   8.086  1.00 46.04           O  
ATOM   1114  CB  ILE A 137       5.585   9.092   5.855  1.00 42.53           C  
ATOM   1115  CG1 ILE A 137       5.365   9.348   4.357  1.00 46.28           C  
ATOM   1116  CG2 ILE A 137       6.161  10.298   6.597  1.00 48.21           C  
ATOM   1117  CD1 ILE A 137       4.664  10.646   4.020  1.00 49.80           C  
ATOM   1118  N   ALA A 138       7.757   7.442   8.040  1.00 43.90           N  
ATOM   1119  CA  ALA A 138       7.930   6.866   9.351  1.00 43.23           C  
ATOM   1120  C   ALA A 138       9.030   7.530  10.161  1.00 42.82           C  
ATOM   1121  O   ALA A 138       9.873   8.206   9.621  1.00 46.84           O  
ATOM   1122  CB  ALA A 138       8.231   5.415   9.193  1.00 44.11           C  
ATOM   1123  N   THR A 139       8.994   7.312  11.471  1.00 43.85           N  
ATOM   1124  CA  THR A 139      10.083   7.636  12.382  1.00 44.44           C  
ATOM   1125  C   THR A 139      10.430   6.422  13.241  1.00 44.60           C  
ATOM   1126  O   THR A 139       9.564   5.631  13.603  1.00 42.96           O  
ATOM   1127  CB  THR A 139       9.722   8.790  13.346  1.00 46.81           C  
ATOM   1128  OG1 THR A 139       8.664   8.384  14.239  1.00 50.07           O  
ATOM   1129  CG2 THR A 139       9.325  10.047  12.577  1.00 46.82           C  
ATOM   1130  N   VAL A 140      11.702   6.285  13.590  1.00 45.52           N  
ATOM   1131  CA  VAL A 140      12.174   5.113  14.324  1.00 44.43           C  
ATOM   1132  C   VAL A 140      13.245   5.529  15.311  1.00 44.34           C  
ATOM   1133  O   VAL A 140      13.787   6.630  15.217  1.00 42.70           O  
ATOM   1134  CB  VAL A 140      12.742   4.039  13.354  1.00 46.20           C  
ATOM   1135  CG1 VAL A 140      11.628   3.404  12.539  1.00 43.62           C  
ATOM   1136  CG2 VAL A 140      13.827   4.659  12.424  1.00 45.21           C  
ATOM   1137  N   ASP A 141      13.545   4.653  16.262  1.00 43.43           N  
ATOM   1138  CA  ASP A 141      14.618   4.940  17.180  1.00 44.03           C  
ATOM   1139  C   ASP A 141      15.959   4.768  16.452  1.00 44.29           C  
ATOM   1140  O   ASP A 141      16.098   3.921  15.556  1.00 40.34           O  
ATOM   1141  CB  ASP A 141      14.562   4.051  18.429  1.00 43.46           C  
ATOM   1142  CG  ASP A 141      13.381   4.373  19.329  1.00 48.56           C  
ATOM   1143  OD1 ASP A 141      13.063   5.584  19.513  1.00 50.13           O  
ATOM   1144  OD2 ASP A 141      12.761   3.398  19.851  1.00 48.84           O  
ATOM   1145  N   ASN A 142      16.929   5.593  16.870  1.00 43.66           N  
ATOM   1146  CA  ASN A 142      18.253   5.638  16.299  1.00 40.98           C  
ATOM   1147  C   ASN A 142      19.202   4.826  17.173  1.00 41.66           C  
ATOM   1148  O   ASN A 142      19.332   5.069  18.381  1.00 42.43           O  
ATOM   1149  CB  ASN A 142      18.726   7.094  16.220  1.00 42.79           C  
ATOM   1150  CG  ASN A 142      20.100   7.234  15.582  1.00 45.14           C  
ATOM   1151  OD1 ASN A 142      20.756   6.236  15.224  1.00 42.28           O  
ATOM   1152  ND2 ASN A 142      20.530   8.461  15.417  1.00 36.31           N  
ATOM   1153  N   PHE A 143      19.863   3.861  16.545  1.00 41.94           N  
ATOM   1154  CA  PHE A 143      20.813   2.987  17.197  1.00 41.58           C  
ATOM   1155  C   PHE A 143      21.912   3.746  17.982  1.00 41.93           C  
ATOM   1156  O   PHE A 143      22.295   3.372  19.090  1.00 43.18           O  
ATOM   1157  CB  PHE A 143      21.419   2.087  16.125  1.00 41.99           C  
ATOM   1158  CG  PHE A 143      22.607   1.304  16.600  1.00 45.08           C  
ATOM   1159  CD1 PHE A 143      22.440   0.048  17.161  1.00 38.52           C  
ATOM   1160  CD2 PHE A 143      23.899   1.834  16.487  1.00 45.17           C  
ATOM   1161  CE1 PHE A 143      23.521  -0.684  17.610  1.00 43.91           C  
ATOM   1162  CE2 PHE A 143      24.994   1.114  16.946  1.00 46.89           C  
ATOM   1163  CZ  PHE A 143      24.802  -0.158  17.508  1.00 41.92           C  
ATOM   1164  N   TYR A 144      22.397   4.838  17.421  1.00 42.23           N  
ATOM   1165  CA  TYR A 144      23.536   5.517  17.998  1.00 42.48           C  
ATOM   1166  C   TYR A 144      23.120   6.363  19.216  1.00 42.38           C  
ATOM   1167  O   TYR A 144      23.902   6.561  20.162  1.00 42.65           O  
ATOM   1168  CB  TYR A 144      24.201   6.372  16.943  1.00 43.01           C  
ATOM   1169  CG  TYR A 144      24.667   5.619  15.702  1.00 46.38           C  
ATOM   1170  CD1 TYR A 144      25.814   4.807  15.720  1.00 44.62           C  
ATOM   1171  CD2 TYR A 144      23.984   5.754  14.495  1.00 50.14           C  
ATOM   1172  CE1 TYR A 144      26.249   4.161  14.568  1.00 50.20           C  
ATOM   1173  CE2 TYR A 144      24.397   5.086  13.340  1.00 50.26           C  
ATOM   1174  CZ  TYR A 144      25.527   4.311  13.374  1.00 51.66           C  
ATOM   1175  OH  TYR A 144      25.897   3.683  12.218  1.00 51.19           O  
ATOM   1176  N   THR A 145      21.882   6.837  19.193  1.00 42.19           N  
ATOM   1177  CA  THR A 145      21.291   7.545  20.326  1.00 43.00           C  
ATOM   1178  C   THR A 145      21.066   6.608  21.495  1.00 41.30           C  
ATOM   1179  O   THR A 145      21.442   6.918  22.601  1.00 40.36           O  
ATOM   1180  CB  THR A 145      19.973   8.194  19.923  1.00 44.88           C  
ATOM   1181  OG1 THR A 145      20.238   9.103  18.849  1.00 51.06           O  
ATOM   1182  CG2 THR A 145      19.344   8.935  21.079  1.00 42.17           C  
ATOM   1183  N   PHE A 146      20.473   5.456  21.239  1.00 40.68           N  
ATOM   1184  CA  PHE A 146      20.366   4.421  22.260  1.00 43.49           C  
ATOM   1185  C   PHE A 146      21.716   4.067  22.849  1.00 41.43           C  
ATOM   1186  O   PHE A 146      21.890   4.008  24.068  1.00 42.95           O  
ATOM   1187  CB  PHE A 146      19.737   3.147  21.669  1.00 46.93           C  
ATOM   1188  CG  PHE A 146      18.235   3.113  21.743  1.00 49.92           C  
ATOM   1189  CD1 PHE A 146      17.485   4.284  21.743  1.00 50.02           C  
ATOM   1190  CD2 PHE A 146      17.569   1.888  21.811  1.00 54.96           C  
ATOM   1191  CE1 PHE A 146      16.110   4.247  21.837  1.00 53.51           C  
ATOM   1192  CE2 PHE A 146      16.186   1.847  21.886  1.00 54.73           C  
ATOM   1193  CZ  PHE A 146      15.456   3.035  21.900  1.00 50.60           C  
ATOM   1194  N   LEU A 147      22.692   3.849  21.983  1.00 39.47           N  
ATOM   1195  CA  LEU A 147      24.010   3.479  22.457  1.00 36.64           C  
ATOM   1196  C   LEU A 147      24.597   4.561  23.353  1.00 35.43           C  
ATOM   1197  O   LEU A 147      25.121   4.256  24.419  1.00 37.86           O  
ATOM   1198  CB  LEU A 147      24.914   3.198  21.272  1.00 37.31           C  
ATOM   1199  CG  LEU A 147      26.345   2.811  21.601  1.00 38.92           C  
ATOM   1200  CD1 LEU A 147      26.378   1.557  22.495  1.00 38.84           C  
ATOM   1201  CD2 LEU A 147      27.085   2.591  20.313  1.00 43.97           C  
ATOM   1202  N   GLN A 148      24.512   5.823  22.950  1.00 33.75           N  
ATOM   1203  CA  GLN A 148      24.979   6.896  23.830  1.00 36.84           C  
ATOM   1204  C   GLN A 148      24.294   6.870  25.211  1.00 39.14           C  
ATOM   1205  O   GLN A 148      24.954   7.077  26.252  1.00 39.17           O  
ATOM   1206  CB  GLN A 148      24.773   8.268  23.178  1.00 37.18           C  
ATOM   1207  CG  GLN A 148      25.306   9.425  23.988  1.00 33.37           C  
ATOM   1208  CD  GLN A 148      26.794   9.365  24.184  1.00 36.29           C  
ATOM   1209  OE1 GLN A 148      27.561   9.911  23.380  1.00 41.92           O  
ATOM   1210  NE2 GLN A 148      27.222   8.733  25.271  1.00 31.96           N  
ATOM   1211  N   GLN A 149      22.983   6.609  25.211  1.00 39.93           N  
ATOM   1212  CA  GLN A 149      22.179   6.614  26.438  1.00 43.36           C  
ATOM   1213  C   GLN A 149      22.599   5.493  27.357  1.00 40.59           C  
ATOM   1214  O   GLN A 149      22.832   5.722  28.541  1.00 42.57           O  
ATOM   1215  CB  GLN A 149      20.689   6.534  26.103  1.00 44.14           C  
ATOM   1216  CG  GLN A 149      20.139   7.852  25.545  1.00 49.82           C  
ATOM   1217  CD  GLN A 149      18.735   7.753  24.898  1.00 52.28           C  
ATOM   1218  OE1 GLN A 149      18.121   6.686  24.822  1.00 63.06           O  
ATOM   1219  NE2 GLN A 149      18.246   8.895  24.407  1.00 60.71           N  
HETATM 1220  N   MSE A 150      22.783   4.309  26.785  1.00 39.58           N  
HETATM 1221  CA  MSE A 150      23.285   3.150  27.529  1.00 43.51           C  
HETATM 1222  C   MSE A 150      24.633   3.375  28.177  1.00 40.32           C  
HETATM 1223  O   MSE A 150      24.850   2.940  29.311  1.00 39.82           O  
HETATM 1224  CB  MSE A 150      23.357   1.944  26.614  1.00 41.07           C  
HETATM 1225  CG  MSE A 150      21.981   1.521  26.173  1.00 46.44           C  
HETATM 1226 SE   MSE A 150      21.924   0.039  24.924  1.00 69.38          SE  
HETATM 1227  CE  MSE A 150      22.503  -1.417  26.224  1.00 59.42           C  
ATOM   1228  N   ILE A 151      25.530   4.048  27.454  1.00 38.25           N  
ATOM   1229  CA  ILE A 151      26.838   4.446  27.977  1.00 38.25           C  
ATOM   1230  C   ILE A 151      26.715   5.414  29.160  1.00 38.46           C  
ATOM   1231  O   ILE A 151      27.514   5.370  30.091  1.00 35.25           O  
ATOM   1232  CB  ILE A 151      27.731   5.122  26.846  1.00 38.46           C  
ATOM   1233  CG1 ILE A 151      28.162   4.072  25.810  1.00 41.81           C  
ATOM   1234  CG2 ILE A 151      28.970   5.821  27.435  1.00 35.69           C  
ATOM   1235  CD1 ILE A 151      28.711   4.639  24.511  1.00 41.29           C  
ATOM   1236  N   GLU A 152      25.751   6.328  29.075  1.00 42.13           N  
ATOM   1237  CA  GLU A 152      25.465   7.276  30.154  1.00 44.81           C  
ATOM   1238  C   GLU A 152      24.873   6.586  31.377  1.00 45.09           C  
ATOM   1239  O   GLU A 152      25.341   6.783  32.505  1.00 42.84           O  
ATOM   1240  CB  GLU A 152      24.536   8.379  29.644  1.00 46.53           C  
ATOM   1241  CG  GLU A 152      25.314   9.660  29.363  1.00 58.04           C  
ATOM   1242  CD  GLU A 152      24.763  10.503  28.220  1.00 73.27           C  
ATOM   1243  OE1 GLU A 152      23.581  10.299  27.800  1.00 74.48           O  
ATOM   1244  OE2 GLU A 152      25.545  11.381  27.751  1.00 80.30           O  
ATOM   1245  N   LYS A 153      23.882   5.730  31.149  1.00 46.60           N  
ATOM   1246  CA  LYS A 153      23.377   4.891  32.240  1.00 48.54           C  
ATOM   1247  C   LYS A 153      24.235   3.623  32.477  1.00 47.01           C  
ATOM   1248  O   LYS A 153      23.770   2.652  33.064  1.00 47.22           O  
ATOM   1249  CB  LYS A 153      21.884   4.576  32.054  1.00 48.59           C  
ATOM   1250  CG  LYS A 153      21.566   3.553  31.018  1.00 55.78           C  
ATOM   1251  CD  LYS A 153      20.041   3.403  30.766  1.00 53.60           C  
ATOM   1252  CE  LYS A 153      19.472   4.510  29.857  1.00 54.44           C  
ATOM   1253  NZ  LYS A 153      18.545   3.963  28.794  1.00 54.27           N  
ATOM   1254  N   ASP A 154      25.492   3.639  32.025  1.00 44.80           N  
ATOM   1255  CA  ASP A 154      26.488   2.665  32.471  1.00 43.51           C  
ATOM   1256  C   ASP A 154      26.115   1.174  32.281  1.00 42.07           C  
ATOM   1257  O   ASP A 154      26.530   0.317  33.037  1.00 43.40           O  
ATOM   1258  CB  ASP A 154      26.789   2.944  33.942  1.00 44.22           C  
ATOM   1259  CG  ASP A 154      28.245   3.125  34.196  1.00 48.21           C  
ATOM   1260  OD1 ASP A 154      28.837   4.064  33.613  1.00 62.11           O  
ATOM   1261  OD2 ASP A 154      28.812   2.328  34.972  1.00 59.16           O  
ATOM   1262  N   ALA A 155      25.381   0.870  31.230  1.00 41.87           N  
ATOM   1263  CA  ALA A 155      24.870  -0.466  31.007  1.00 42.52           C  
ATOM   1264  C   ALA A 155      25.833  -1.372  30.213  1.00 43.47           C  
ATOM   1265  O   ALA A 155      25.482  -1.846  29.117  1.00 44.90           O  
ATOM   1266  CB  ALA A 155      23.535  -0.351  30.276  1.00 41.30           C  
ATOM   1267  N   TRP A 156      27.017  -1.642  30.760  1.00 42.38           N  
ATOM   1268  CA  TRP A 156      28.083  -2.273  29.971  1.00 42.96           C  
ATOM   1269  C   TRP A 156      27.843  -3.733  29.625  1.00 43.72           C  
ATOM   1270  O   TRP A 156      28.140  -4.156  28.511  1.00 44.78           O  
ATOM   1271  CB  TRP A 156      29.428  -2.056  30.636  1.00 44.34           C  
ATOM   1272  CG  TRP A 156      29.815  -0.598  30.537  1.00 50.63           C  
ATOM   1273  CD1 TRP A 156      29.684   0.365  31.508  1.00 51.85           C  
ATOM   1274  CD2 TRP A 156      30.324   0.075  29.374  1.00 50.52           C  
ATOM   1275  NE1 TRP A 156      30.113   1.582  31.027  1.00 53.64           N  
ATOM   1276  CE2 TRP A 156      30.510   1.432  29.723  1.00 53.65           C  
ATOM   1277  CE3 TRP A 156      30.653  -0.341  28.078  1.00 50.03           C  
ATOM   1278  CZ2 TRP A 156      31.016   2.368  28.822  1.00 51.41           C  
ATOM   1279  CZ3 TRP A 156      31.141   0.594  27.181  1.00 49.30           C  
ATOM   1280  CH2 TRP A 156      31.320   1.927  27.556  1.00 51.30           C  
ATOM   1281  N   ASP A 157      27.260  -4.492  30.546  1.00 43.78           N  
ATOM   1282  CA  ASP A 157      26.875  -5.870  30.233  1.00 44.63           C  
ATOM   1283  C   ASP A 157      25.868  -5.912  29.113  1.00 43.42           C  
ATOM   1284  O   ASP A 157      25.810  -6.877  28.369  1.00 45.51           O  
ATOM   1285  CB  ASP A 157      26.282  -6.581  31.448  1.00 45.14           C  
ATOM   1286  CG  ASP A 157      27.336  -7.012  32.445  1.00 50.55           C  
ATOM   1287  OD1 ASP A 157      28.421  -6.387  32.526  1.00 53.41           O  
ATOM   1288  OD2 ASP A 157      27.068  -7.996  33.164  1.00 62.74           O  
ATOM   1289  N   GLN A 158      25.076  -4.862  28.999  1.00 42.50           N  
ATOM   1290  CA  GLN A 158      23.997  -4.813  28.027  1.00 42.95           C  
ATOM   1291  C   GLN A 158      24.418  -4.287  26.667  1.00 43.73           C  
ATOM   1292  O   GLN A 158      23.810  -4.643  25.653  1.00 43.52           O  
ATOM   1293  CB  GLN A 158      22.900  -3.904  28.552  1.00 44.24           C  
ATOM   1294  CG  GLN A 158      22.352  -4.375  29.879  1.00 51.97           C  
ATOM   1295  CD  GLN A 158      21.325  -3.424  30.437  1.00 58.56           C  
ATOM   1296  OE1 GLN A 158      20.257  -3.224  29.842  1.00 52.52           O  
ATOM   1297  NE2 GLN A 158      21.646  -2.814  31.589  1.00 58.11           N  
ATOM   1298  N   ILE A 159      25.425  -3.414  26.652  1.00 42.92           N  
ATOM   1299  CA  ILE A 159      25.910  -2.820  25.419  1.00 42.94           C  
ATOM   1300  C   ILE A 159      26.373  -3.910  24.456  1.00 42.17           C  
ATOM   1301  O   ILE A 159      26.051  -3.889  23.272  1.00 41.35           O  
ATOM   1302  CB  ILE A 159      27.015  -1.778  25.716  1.00 43.91           C  
ATOM   1303  CG1 ILE A 159      26.361  -0.489  26.233  1.00 45.68           C  
ATOM   1304  CG2 ILE A 159      27.859  -1.450  24.465  1.00 46.06           C  
ATOM   1305  CD1 ILE A 159      27.307   0.463  26.928  1.00 42.57           C  
ATOM   1306  N   THR A 160      27.103  -4.870  24.983  1.00 43.32           N  
ATOM   1307  CA  THR A 160      27.619  -5.984  24.190  1.00 45.30           C  
ATOM   1308  C   THR A 160      26.540  -6.718  23.414  1.00 46.59           C  
ATOM   1309  O   THR A 160      26.703  -6.934  22.215  1.00 49.76           O  
ATOM   1310  CB  THR A 160      28.324  -6.987  25.101  1.00 45.82           C  
ATOM   1311  OG1 THR A 160      29.273  -6.279  25.900  1.00 42.28           O  
ATOM   1312  CG2 THR A 160      29.030  -8.082  24.293  1.00 45.94           C  
ATOM   1313  N   ARG A 161      25.458  -7.110  24.092  1.00 46.53           N  
ATOM   1314  CA  ARG A 161      24.295  -7.696  23.421  1.00 47.18           C  
ATOM   1315  C   ARG A 161      23.675  -6.728  22.383  1.00 47.91           C  
ATOM   1316  O   ARG A 161      23.357  -7.106  21.241  1.00 50.06           O  
ATOM   1317  CB  ARG A 161      23.203  -8.052  24.450  1.00 50.01           C  
ATOM   1318  CG  ARG A 161      23.542  -9.205  25.428  1.00 53.47           C  
ATOM   1319  N   PHE A 162      23.492  -5.484  22.808  1.00 44.69           N  
ATOM   1320  CA  PHE A 162      22.817  -4.487  22.022  1.00 43.37           C  
ATOM   1321  C   PHE A 162      23.543  -4.207  20.720  1.00 44.54           C  
ATOM   1322  O   PHE A 162      22.907  -4.013  19.682  1.00 45.09           O  
ATOM   1323  CB  PHE A 162      22.688  -3.192  22.819  1.00 41.73           C  
ATOM   1324  CG  PHE A 162      22.057  -2.082  22.050  1.00 40.45           C  
ATOM   1325  CD1 PHE A 162      20.688  -2.055  21.860  1.00 43.45           C  
ATOM   1326  CD2 PHE A 162      22.829  -1.063  21.509  1.00 45.15           C  
ATOM   1327  CE1 PHE A 162      20.095  -1.024  21.150  1.00 41.54           C  
ATOM   1328  CE2 PHE A 162      22.236  -0.023  20.793  1.00 46.41           C  
ATOM   1329  CZ  PHE A 162      20.863  -0.018  20.612  1.00 44.79           C  
ATOM   1330  N   LEU A 163      24.870  -4.176  20.765  1.00 44.50           N  
ATOM   1331  CA  LEU A 163      25.628  -3.944  19.546  1.00 45.65           C  
ATOM   1332  C   LEU A 163      25.276  -4.980  18.489  1.00 47.07           C  
ATOM   1333  O   LEU A 163      25.209  -4.643  17.314  1.00 49.38           O  
ATOM   1334  CB  LEU A 163      27.124  -3.936  19.813  1.00 46.71           C  
ATOM   1335  CG  LEU A 163      27.621  -2.777  20.689  1.00 44.07           C  
ATOM   1336  CD1 LEU A 163      29.006  -3.099  21.238  1.00 40.01           C  
ATOM   1337  CD2 LEU A 163      27.622  -1.482  19.928  1.00 44.58           C  
ATOM   1338  N   LYS A 164      24.980  -6.207  18.924  1.00 48.01           N  
ATOM   1339  CA  LYS A 164      24.610  -7.309  18.023  1.00 48.00           C  
ATOM   1340  C   LYS A 164      23.136  -7.285  17.602  1.00 47.91           C  
ATOM   1341  O   LYS A 164      22.821  -7.378  16.410  1.00 47.06           O  
ATOM   1342  CB  LYS A 164      24.943  -8.668  18.680  1.00 47.98           C  
ATOM   1343  N   THR A 165      22.242  -7.156  18.584  1.00 47.85           N  
ATOM   1344  CA  THR A 165      20.782  -7.230  18.363  1.00 45.44           C  
ATOM   1345  C   THR A 165      20.125  -5.928  17.941  1.00 45.28           C  
ATOM   1346  O   THR A 165      19.073  -5.944  17.314  1.00 47.02           O  
ATOM   1347  CB  THR A 165      20.066  -7.654  19.646  1.00 45.07           C  
ATOM   1348  OG1 THR A 165      20.250  -6.658  20.655  1.00 48.06           O  
ATOM   1349  CG2 THR A 165      20.622  -8.970  20.153  1.00 44.48           C  
ATOM   1350  N   GLN A 166      20.717  -4.804  18.323  1.00 43.78           N  
ATOM   1351  CA  GLN A 166      20.082  -3.487  18.180  1.00 44.38           C  
ATOM   1352  C   GLN A 166      18.784  -3.368  19.005  1.00 43.31           C  
ATOM   1353  O   GLN A 166      17.968  -2.470  18.794  1.00 43.42           O  
ATOM   1354  CB  GLN A 166      19.846  -3.127  16.698  1.00 44.05           C  
ATOM   1355  CG  GLN A 166      21.081  -3.269  15.822  1.00 42.48           C  
ATOM   1356  CD  GLN A 166      20.842  -2.888  14.371  1.00 45.23           C  
ATOM   1357  OE1 GLN A 166      21.493  -3.422  13.493  1.00 45.52           O  
ATOM   1358  NE2 GLN A 166      19.911  -1.971  14.116  1.00 40.31           N  
ATOM   1359  N   THR A 167      18.626  -4.260  19.967  1.00 44.11           N  
ATOM   1360  CA  THR A 167      17.400  -4.365  20.721  1.00 44.27           C  
ATOM   1361  C   THR A 167      17.667  -4.142  22.207  1.00 43.62           C  
ATOM   1362  O   THR A 167      18.573  -4.747  22.788  1.00 43.62           O  
ATOM   1363  CB  THR A 167      16.731  -5.735  20.476  1.00 44.94           C  
ATOM   1364  OG1 THR A 167      16.406  -5.859  19.080  1.00 46.26           O  
ATOM   1365  CG2 THR A 167      15.442  -5.871  21.287  1.00 49.22           C  
ATOM   1366  N   THR A 168      16.895  -3.243  22.804  1.00 43.85           N  
ATOM   1367  CA  THR A 168      16.952  -3.011  24.228  1.00 43.92           C  
ATOM   1368  C   THR A 168      15.542  -2.764  24.754  1.00 43.20           C  
ATOM   1369  O   THR A 168      14.618  -2.631  23.976  1.00 41.44           O  
ATOM   1370  CB  THR A 168      17.902  -1.840  24.564  1.00 43.99           C  
ATOM   1371  OG1 THR A 168      18.204  -1.862  25.959  1.00 48.72           O  
ATOM   1372  CG2 THR A 168      17.294  -0.513  24.218  1.00 45.78           C  
ATOM   1373  N   SER A 169      15.400  -2.727  26.078  1.00 44.11           N  
ATOM   1374  CA  SER A 169      14.133  -2.474  26.744  1.00 47.11           C  
ATOM   1375  C   SER A 169      13.834  -1.013  26.736  1.00 47.51           C  
ATOM   1376  O   SER A 169      14.745  -0.204  26.734  1.00 52.36           O  
ATOM   1377  CB  SER A 169      14.204  -2.908  28.208  1.00 48.29           C  
ATOM   1378  OG  SER A 169      14.372  -4.300  28.315  1.00 56.23           O  
ATOM   1379  N   VAL A 170      12.556  -0.663  26.718  1.00 49.03           N  
ATOM   1380  CA  VAL A 170      12.119   0.721  26.917  1.00 49.60           C  
ATOM   1381  C   VAL A 170      10.837   0.697  27.744  1.00 52.43           C  
ATOM   1382  O   VAL A 170      10.257  -0.375  27.969  1.00 53.63           O  
ATOM   1383  CB  VAL A 170      11.902   1.493  25.576  1.00 48.75           C  
ATOM   1384  CG1 VAL A 170      13.168   1.524  24.754  1.00 46.17           C  
ATOM   1385  CG2 VAL A 170      10.757   0.900  24.742  1.00 48.22           C  
ATOM   1386  N   GLY A 171      10.406   1.867  28.210  1.00 53.64           N  
ATOM   1387  CA  GLY A 171       9.199   1.969  29.027  1.00 55.21           C  
ATOM   1388  C   GLY A 171       9.381   2.812  30.272  1.00 56.54           C  
ATOM   1389  O   GLY A 171       9.934   3.896  30.201  1.00 57.80           O  
ATOM   1390  N   THR A 172       8.909   2.306  31.411  1.00 57.89           N  
ATOM   1391  CA  THR A 172       8.895   3.051  32.672  1.00 59.22           C  
ATOM   1392  C   THR A 172       9.611   2.270  33.777  1.00 59.59           C  
ATOM   1393  O   THR A 172      10.113   1.166  33.551  1.00 59.68           O  
ATOM   1394  CB  THR A 172       7.422   3.384  33.114  1.00 60.52           C  
ATOM   1395  OG1 THR A 172       6.700   2.175  33.450  1.00 60.62           O  
ATOM   1396  CG2 THR A 172       6.681   4.153  32.006  1.00 59.79           C  
ATOM   1397  N   THR A 173       9.641   2.845  34.974  1.00 60.51           N  
ATOM   1398  CA  THR A 173      10.301   2.217  36.115  1.00 61.05           C  
ATOM   1399  C   THR A 173       9.790   0.792  36.406  1.00 61.78           C  
ATOM   1400  O   THR A 173      10.573  -0.057  36.815  1.00 63.00           O  
ATOM   1401  CB  THR A 173      10.177   3.091  37.378  1.00 60.31           C  
ATOM   1402  N   LEU A 174       8.500   0.524  36.171  1.00 61.79           N  
ATOM   1403  CA  LEU A 174       7.898  -0.781  36.512  1.00 60.65           C  
ATOM   1404  C   LEU A 174       7.543  -1.679  35.320  1.00 59.34           C  
ATOM   1405  O   LEU A 174       7.519  -2.908  35.469  1.00 57.62           O  
ATOM   1406  CB  LEU A 174       6.649  -0.583  37.382  1.00 61.87           C  
ATOM   1407  N   PHE A 175       7.252  -1.075  34.162  1.00 58.70           N  
ATOM   1408  CA  PHE A 175       6.903  -1.828  32.952  1.00 58.70           C  
ATOM   1409  C   PHE A 175       7.814  -1.502  31.765  1.00 56.16           C  
ATOM   1410  O   PHE A 175       8.079  -0.339  31.481  1.00 53.38           O  
ATOM   1411  CB  PHE A 175       5.453  -1.541  32.547  1.00 61.92           C  
ATOM   1412  CG  PHE A 175       4.454  -1.873  33.609  1.00 66.09           C  
ATOM   1413  CD1 PHE A 175       4.295  -3.188  34.035  1.00 72.27           C  
ATOM   1414  CD2 PHE A 175       3.682  -0.876  34.198  1.00 69.91           C  
ATOM   1415  CE1 PHE A 175       3.385  -3.514  35.036  1.00 70.64           C  
ATOM   1416  CE2 PHE A 175       2.770  -1.188  35.201  1.00 72.78           C  
ATOM   1417  CZ  PHE A 175       2.621  -2.513  35.622  1.00 68.86           C  
ATOM   1418  N   SER A 176       8.248  -2.542  31.056  1.00 53.88           N  
ATOM   1419  CA  SER A 176       9.060  -2.393  29.858  1.00 52.11           C  
ATOM   1420  C   SER A 176       8.567  -3.257  28.693  1.00 49.69           C  
ATOM   1421  O   SER A 176       7.869  -4.260  28.876  1.00 47.64           O  
ATOM   1422  CB  SER A 176      10.499  -2.794  30.165  1.00 53.04           C  
ATOM   1423  OG  SER A 176      10.639  -4.209  30.130  1.00 53.43           O  
ATOM   1424  N   PHE A 177       8.950  -2.845  27.492  1.00 48.07           N  
ATOM   1425  CA  PHE A 177       8.850  -3.673  26.274  1.00 47.24           C  
ATOM   1426  C   PHE A 177      10.094  -3.415  25.416  1.00 46.81           C  
ATOM   1427  O   PHE A 177      10.859  -2.473  25.679  1.00 46.06           O  
ATOM   1428  CB  PHE A 177       7.563  -3.384  25.473  1.00 45.82           C  
ATOM   1429  CG  PHE A 177       7.439  -1.959  25.002  1.00 45.99           C  
ATOM   1430  CD1 PHE A 177       7.046  -0.960  25.870  1.00 50.34           C  
ATOM   1431  CD2 PHE A 177       7.702  -1.623  23.687  1.00 44.54           C  
ATOM   1432  CE1 PHE A 177       6.932   0.346  25.434  1.00 48.67           C  
ATOM   1433  CE2 PHE A 177       7.592  -0.311  23.244  1.00 52.10           C  
ATOM   1434  CZ  PHE A 177       7.201   0.671  24.110  1.00 47.29           C  
ATOM   1435  N   ASN A 178      10.288  -4.244  24.397  1.00 46.46           N  
ATOM   1436  CA  ASN A 178      11.476  -4.157  23.535  1.00 46.40           C  
ATOM   1437  C   ASN A 178      11.339  -3.209  22.367  1.00 44.28           C  
ATOM   1438  O   ASN A 178      10.272  -3.081  21.794  1.00 41.92           O  
ATOM   1439  CB  ASN A 178      11.842  -5.539  23.007  1.00 47.83           C  
ATOM   1440  CG  ASN A 178      12.421  -6.398  24.061  1.00 49.37           C  
ATOM   1441  OD1 ASN A 178      13.077  -5.902  24.976  1.00 60.87           O  
ATOM   1442  ND2 ASN A 178      12.195  -7.694  23.960  1.00 59.05           N  
ATOM   1443  N   SER A 179      12.442  -2.535  22.058  1.00 44.89           N  
ATOM   1444  CA  SER A 179      12.570  -1.667  20.907  1.00 44.25           C  
ATOM   1445  C   SER A 179      13.784  -2.097  20.089  1.00 45.69           C  
ATOM   1446  O   SER A 179      14.834  -2.431  20.641  1.00 46.97           O  
ATOM   1447  CB  SER A 179      12.763  -0.214  21.333  1.00 45.28           C  
ATOM   1448  OG  SER A 179      12.829   0.650  20.190  1.00 46.25           O  
ATOM   1449  N   TYR A 180      13.633  -2.065  18.770  1.00 44.38           N  
ATOM   1450  CA  TYR A 180      14.729  -2.277  17.851  1.00 43.02           C  
ATOM   1451  C   TYR A 180      15.115  -0.909  17.309  1.00 42.48           C  
ATOM   1452  O   TYR A 180      14.301  -0.251  16.681  1.00 42.14           O  
ATOM   1453  CB  TYR A 180      14.279  -3.188  16.730  1.00 41.78           C  
ATOM   1454  CG  TYR A 180      15.320  -3.451  15.669  1.00 45.34           C  
ATOM   1455  CD1 TYR A 180      15.442  -2.619  14.566  1.00 42.69           C  
ATOM   1456  CD2 TYR A 180      16.142  -4.560  15.738  1.00 43.99           C  
ATOM   1457  CE1 TYR A 180      16.364  -2.881  13.572  1.00 42.57           C  
ATOM   1458  CE2 TYR A 180      17.073  -4.821  14.747  1.00 40.26           C  
ATOM   1459  CZ  TYR A 180      17.170  -3.977  13.671  1.00 41.86           C  
ATOM   1460  OH  TYR A 180      18.101  -4.225  12.695  1.00 47.55           O  
ATOM   1461  N   ALA A 181      16.350  -0.492  17.578  1.00 41.86           N  
ATOM   1462  CA  ALA A 181      16.885   0.778  17.099  1.00 41.85           C  
ATOM   1463  C   ALA A 181      17.587   0.595  15.763  1.00 41.18           C  
ATOM   1464  O   ALA A 181      18.474  -0.267  15.631  1.00 40.44           O  
ATOM   1465  CB  ALA A 181      17.856   1.384  18.121  1.00 41.68           C  
ATOM   1466  N   PHE A 182      17.207   1.439  14.803  1.00 40.67           N  
ATOM   1467  CA  PHE A 182      17.638   1.311  13.416  1.00 40.14           C  
ATOM   1468  C   PHE A 182      19.043   1.882  13.163  1.00 41.11           C  
ATOM   1469  O   PHE A 182      19.466   2.878  13.766  1.00 42.38           O  
ATOM   1470  CB  PHE A 182      16.645   2.011  12.484  1.00 40.23           C  
ATOM   1471  CG  PHE A 182      15.418   1.205  12.164  1.00 43.76           C  
ATOM   1472  CD1 PHE A 182      14.520   0.832  13.169  1.00 45.65           C  
ATOM   1473  CD2 PHE A 182      15.142   0.830  10.850  1.00 45.51           C  
ATOM   1474  CE1 PHE A 182      13.384   0.106  12.864  1.00 41.10           C  
ATOM   1475  CE2 PHE A 182      14.007   0.107  10.543  1.00 44.53           C  
ATOM   1476  CZ  PHE A 182      13.127  -0.254  11.544  1.00 42.07           C  
ATOM   1477  N   LYS A 183      19.732   1.228  12.239  1.00 42.11           N  
ATOM   1478  CA  LYS A 183      21.011   1.648  11.708  1.00 44.26           C  
ATOM   1479  C   LYS A 183      20.800   1.958  10.238  1.00 43.12           C  
ATOM   1480  O   LYS A 183      19.838   1.521   9.634  1.00 44.41           O  
ATOM   1481  CB  LYS A 183      22.053   0.517  11.851  1.00 44.50           C  
ATOM   1482  CG  LYS A 183      22.671   0.432  13.239  1.00 46.51           C  
ATOM   1483  CD  LYS A 183      23.579  -0.789  13.397  1.00 47.98           C  
ATOM   1484  CE  LYS A 183      25.047  -0.424  13.368  1.00 53.31           C  
ATOM   1485  NZ  LYS A 183      25.882  -1.626  13.708  1.00 58.88           N  
ATOM   1486  N   PRO A 184      21.715   2.705   9.649  1.00 43.02           N  
ATOM   1487  CA  PRO A 184      21.650   2.983   8.207  1.00 45.47           C  
ATOM   1488  C   PRO A 184      21.414   1.753   7.305  1.00 46.18           C  
ATOM   1489  O   PRO A 184      20.624   1.813   6.359  1.00 46.60           O  
ATOM   1490  CB  PRO A 184      23.022   3.633   7.930  1.00 45.48           C  
ATOM   1491  CG  PRO A 184      23.374   4.286   9.239  1.00 40.09           C  
ATOM   1492  CD  PRO A 184      22.876   3.340  10.290  1.00 40.09           C  
ATOM   1493  N   GLU A 185      22.075   0.644   7.601  1.00 46.72           N  
ATOM   1494  CA  GLU A 185      21.935  -0.542   6.770  1.00 47.46           C  
ATOM   1495  C   GLU A 185      20.521  -1.147   6.881  1.00 48.27           C  
ATOM   1496  O   GLU A 185      20.097  -1.881   5.988  1.00 46.90           O  
ATOM   1497  CB  GLU A 185      23.036  -1.578   7.098  1.00 49.19           C  
ATOM   1498  CG  GLU A 185      22.752  -2.508   8.280  1.00 57.62           C  
ATOM   1499  OE1 GLU A 185      24.765   0.450   9.281  1.00 42.43           O  
ATOM   1500  OE2 GLU A 185      24.684  -2.235  10.367  1.00 74.92           O  
ATOM   1501  N   ASP A 186      19.786  -0.826   7.952  1.00 49.73           N  
ATOM   1502  CA  ASP A 186      18.374  -1.233   8.070  1.00 50.70           C  
ATOM   1503  C   ASP A 186      17.478  -0.533   7.044  1.00 51.00           C  
ATOM   1504  O   ASP A 186      16.414  -1.043   6.708  1.00 48.12           O  
ATOM   1505  CB  ASP A 186      17.803  -0.961   9.475  1.00 51.76           C  
ATOM   1506  CG  ASP A 186      18.463  -1.795  10.556  1.00 51.77           C  
ATOM   1507  OD1 ASP A 186      18.382  -3.017  10.449  1.00 53.95           O  
ATOM   1508  OD2 ASP A 186      19.036  -1.236  11.521  1.00 45.48           O  
ATOM   1509  N   LEU A 187      17.884   0.641   6.563  1.00 53.44           N  
ATOM   1510  CA  LEU A 187      17.053   1.354   5.598  1.00 56.15           C  
ATOM   1511  C   LEU A 187      17.575   1.244   4.176  1.00 60.22           C  
ATOM   1512  O   LEU A 187      17.120   1.960   3.291  1.00 60.44           O  
ATOM   1513  CB  LEU A 187      16.935   2.813   6.000  1.00 56.48           C  
ATOM   1514  CG  LEU A 187      16.243   3.042   7.333  1.00 55.76           C  
ATOM   1515  CD1 LEU A 187      16.260   4.531   7.635  1.00 59.22           C  
ATOM   1516  CD2 LEU A 187      14.816   2.480   7.303  1.00 53.71           C  
ATOM   1517  N   ASP A 188      18.507   0.317   3.966  1.00 64.48           N  
ATOM   1518  CA  ASP A 188      19.243   0.180   2.725  1.00 66.82           C  
ATOM   1519  C   ASP A 188      18.735  -1.054   1.975  1.00 68.63           C  
ATOM   1520  O   ASP A 188      18.540  -2.139   2.565  1.00 67.87           O  
ATOM   1521  CB  ASP A 188      20.729   0.070   3.061  1.00 68.67           C  
ATOM   1522  CG  ASP A 188      21.596  -0.209   1.855  1.00 75.12           C  
ATOM   1523  OD1 ASP A 188      21.435  -1.277   1.213  1.00 85.86           O  
ATOM   1524  OD2 ASP A 188      22.473   0.629   1.578  1.00 87.28           O  
ATOM   1525  N   SER A 189      18.532  -0.871   0.667  1.00 70.46           N  
ATOM   1526  CA  SER A 189      17.919  -1.876  -0.210  1.00 71.12           C  
ATOM   1527  C   SER A 189      16.818  -2.666   0.501  1.00 69.51           C  
ATOM   1528  O   SER A 189      16.941  -3.871   0.710  1.00 70.30           O  
ATOM   1529  CB  SER A 189      18.995  -2.819  -0.784  1.00 72.76           C  
ATOM   1530  N   LEU A 190      15.755  -1.982   0.908  1.00 67.08           N  
ATOM   1531  CA  LEU A 190      14.591  -2.688   1.444  1.00 64.68           C  
ATOM   1532  C   LEU A 190      13.827  -3.287   0.261  1.00 63.69           C  
ATOM   1533  O   LEU A 190      13.604  -2.610  -0.742  1.00 63.90           O  
ATOM   1534  CB  LEU A 190      13.683  -1.761   2.260  1.00 63.10           C  
ATOM   1535  CG  LEU A 190      14.057  -1.608   3.731  1.00 62.46           C  
ATOM   1536  CD1 LEU A 190      13.401  -0.384   4.366  1.00 59.83           C  
ATOM   1537  CD2 LEU A 190      13.670  -2.863   4.497  1.00 62.30           C  
ATOM   1538  N   GLU A 191      13.439  -4.555   0.377  1.00 61.71           N  
ATOM   1539  CA  GLU A 191      12.780  -5.277  -0.717  1.00 60.28           C  
ATOM   1540  C   GLU A 191      11.484  -4.583  -1.166  1.00 57.48           C  
ATOM   1541  O   GLU A 191      10.526  -4.418  -0.367  1.00 53.92           O  
ATOM   1542  CB  GLU A 191      12.475  -6.715  -0.286  1.00 61.34           C  
ATOM   1543  OE1 GLU A 191      11.488  -8.326  -1.481  1.00 53.13           O  
ATOM   1544  OE2 GLU A 191       9.130  -7.563  -5.773  1.00 70.92           O  
ATOM   1545  N   GLY A 192      11.497  -4.169  -2.437  1.00 54.30           N  
ATOM   1546  CA  GLY A 192      10.357  -3.533  -3.095  1.00 52.70           C  
ATOM   1547  C   GLY A 192      10.156  -2.047  -2.810  1.00 51.19           C  
ATOM   1548  O   GLY A 192       9.148  -1.464  -3.225  1.00 49.34           O  
ATOM   1549  N   PHE A 193      11.113  -1.433  -2.115  1.00 48.99           N  
ATOM   1550  CA  PHE A 193      11.029  -0.021  -1.778  1.00 49.01           C  
ATOM   1551  C   PHE A 193      12.245   0.729  -2.257  1.00 50.29           C  
ATOM   1552  O   PHE A 193      13.356   0.226  -2.213  1.00 48.46           O  
ATOM   1553  CB  PHE A 193      10.975   0.161  -0.269  1.00 49.19           C  
ATOM   1554  CG  PHE A 193       9.636  -0.069   0.329  1.00 49.67           C  
ATOM   1555  CD1 PHE A 193       8.601   0.831   0.108  1.00 48.95           C  
ATOM   1556  CD2 PHE A 193       9.406  -1.181   1.149  1.00 51.30           C  
ATOM   1557  CE1 PHE A 193       7.354   0.620   0.694  1.00 49.25           C  
ATOM   1558  CE2 PHE A 193       8.164  -1.391   1.742  1.00 49.50           C  
ATOM   1559  CZ  PHE A 193       7.142  -0.492   1.517  1.00 47.63           C  
ATOM   1560  N   GLU A 194      12.013   1.967  -2.664  1.00 52.39           N  
ATOM   1561  CA  GLU A 194      13.056   2.907  -2.962  1.00 53.03           C  
ATOM   1562  C   GLU A 194      13.097   3.909  -1.813  1.00 50.58           C  
ATOM   1563  O   GLU A 194      12.100   4.528  -1.480  1.00 50.09           O  
ATOM   1564  CB  GLU A 194      12.735   3.606  -4.282  1.00 52.91           C  
ATOM   1565  CG  GLU A 194      13.302   5.026  -4.414  1.00 63.09           C  
ATOM   1566  CD  GLU A 194      12.904   5.719  -5.723  1.00 62.68           C  
ATOM   1567  OE1 GLU A 194      11.906   5.290  -6.363  1.00 71.80           O  
ATOM   1568  OE2 GLU A 194      13.599   6.700  -6.098  1.00 73.67           O  
ATOM   1569  N   THR A 195      14.253   4.083  -1.206  1.00 50.10           N  
ATOM   1570  CA  THR A 195      14.417   5.128  -0.213  1.00 50.33           C  
ATOM   1571  C   THR A 195      14.411   6.508  -0.869  1.00 49.90           C  
ATOM   1572  O   THR A 195      15.227   6.804  -1.724  1.00 51.09           O  
ATOM   1573  CB  THR A 195      15.693   4.929   0.601  1.00 49.60           C  
ATOM   1574  OG1 THR A 195      15.609   3.660   1.264  1.00 48.30           O  
ATOM   1575  CG2 THR A 195      15.818   6.021   1.648  1.00 51.71           C  
ATOM   1576  N   VAL A 196      13.457   7.330  -0.467  1.00 48.76           N  
ATOM   1577  CA  VAL A 196      13.253   8.632  -1.053  1.00 47.55           C  
ATOM   1578  C   VAL A 196      14.029   9.685  -0.270  1.00 46.61           C  
ATOM   1579  O   VAL A 196      14.678  10.530  -0.862  1.00 46.49           O  
ATOM   1580  CB  VAL A 196      11.761   8.983  -1.053  1.00 48.14           C  
ATOM   1581  CG1 VAL A 196      11.521  10.425  -1.453  1.00 50.70           C  
ATOM   1582  CG2 VAL A 196      11.038   8.073  -1.978  1.00 51.44           C  
ATOM   1583  N   ASP A 197      13.926   9.645   1.050  1.00 45.99           N  
ATOM   1584  CA  ASP A 197      14.615  10.564   1.911  1.00 48.07           C  
ATOM   1585  C   ASP A 197      14.768   9.957   3.286  1.00 46.94           C  
ATOM   1586  O   ASP A 197      13.967   9.108   3.685  1.00 48.23           O  
ATOM   1587  CB  ASP A 197      13.844  11.890   2.026  1.00 50.36           C  
ATOM   1588  CG  ASP A 197      14.749  13.073   2.425  1.00 60.76           C  
ATOM   1589  OD1 ASP A 197      15.967  12.868   2.671  1.00 66.51           O  
ATOM   1590  OD2 ASP A 197      14.249  14.222   2.476  1.00 71.66           O  
ATOM   1591  N   ILE A 198      15.821  10.380   3.982  1.00 44.89           N  
ATOM   1592  CA  ILE A 198      16.046  10.065   5.388  1.00 44.07           C  
ATOM   1593  C   ILE A 198      16.422  11.375   6.053  1.00 41.72           C  
ATOM   1594  O   ILE A 198      17.185  12.094   5.482  1.00 40.68           O  
ATOM   1595  CB  ILE A 198      17.211   9.038   5.603  1.00 42.82           C  
ATOM   1596  CG1 ILE A 198      16.976   7.740   4.842  1.00 45.36           C  
ATOM   1597  CG2 ILE A 198      17.373   8.690   7.109  1.00 45.64           C  
ATOM   1598  CD1 ILE A 198      18.191   6.846   4.778  1.00 45.40           C  
ATOM   1599  N   ARG A 199      15.887  11.665   7.241  1.00 42.91           N  
ATOM   1600  CA  ARG A 199      16.129  12.930   7.962  1.00 44.62           C  
ATOM   1601  C   ARG A 199      16.272  12.755   9.455  1.00 45.71           C  
ATOM   1602  O   ARG A 199      15.662  11.879  10.048  1.00 46.63           O  
ATOM   1603  CB  ARG A 199      14.978  13.881   7.780  1.00 44.83           C  
ATOM   1604  CG  ARG A 199      14.736  14.201   6.370  1.00 50.18           C  
ATOM   1605  CD  ARG A 199      14.279  15.604   6.243  1.00 52.56           C  
ATOM   1606  NE  ARG A 199      13.556  15.754   5.005  1.00 60.83           N  
ATOM   1607  CZ  ARG A 199      12.834  16.807   4.686  1.00 64.07           C  
ATOM   1608  NH1 ARG A 199      12.745  17.852   5.501  1.00 68.18           N  
ATOM   1609  NH2 ARG A 199      12.213  16.803   3.528  1.00 65.01           N  
ATOM   1610  N   GLY A 200      17.038  13.632  10.076  1.00 44.48           N  
ATOM   1611  CA  GLY A 200      17.198  13.554  11.512  1.00 45.85           C  
ATOM   1612  C   GLY A 200      16.174  14.415  12.211  1.00 44.73           C  
ATOM   1613  O   GLY A 200      16.000  15.549  11.833  1.00 45.39           O  
ATOM   1614  N   ILE A 201      15.495  13.866  13.214  1.00 45.32           N  
ATOM   1615  CA  ILE A 201      14.653  14.657  14.119  1.00 46.02           C  
ATOM   1616  C   ILE A 201      15.423  14.910  15.411  1.00 45.26           C  
ATOM   1617  O   ILE A 201      15.733  13.960  16.148  1.00 44.14           O  
ATOM   1618  CB  ILE A 201      13.355  13.930  14.499  1.00 47.13           C  
ATOM   1619  CG1 ILE A 201      12.669  13.313  13.265  1.00 55.16           C  
ATOM   1620  CG2 ILE A 201      12.426  14.874  15.243  1.00 48.97           C  
ATOM   1621  CD1 ILE A 201      12.331  14.309  12.157  1.00 63.57           C  
ATOM   1622  N   GLY A 202      15.734  16.175  15.674  1.00 44.19           N  
ATOM   1623  CA  GLY A 202      16.578  16.538  16.810  1.00 45.05           C  
ATOM   1624  C   GLY A 202      18.047  16.264  16.549  1.00 44.17           C  
ATOM   1625  O   GLY A 202      18.669  15.437  17.218  1.00 45.80           O  
ATOM   1626  N   VAL A 203      18.599  16.926  15.547  1.00 42.97           N  
ATOM   1627  CA  VAL A 203      20.017  16.756  15.212  1.00 44.18           C  
ATOM   1628  C   VAL A 203      20.901  17.343  16.330  1.00 43.02           C  
ATOM   1629  O   VAL A 203      21.890  16.740  16.718  1.00 42.96           O  
ATOM   1630  CB  VAL A 203      20.349  17.393  13.847  1.00 45.31           C  
ATOM   1631  CG1 VAL A 203      21.818  17.269  13.537  1.00 45.46           C  
ATOM   1632  CG2 VAL A 203      19.526  16.718  12.742  1.00 43.22           C  
HETATM 1633  N   MSE A 204      20.503  18.485  16.882  1.00 40.63           N  
HETATM 1634  CA  MSE A 204      21.151  19.038  18.075  1.00 40.24           C  
HETATM 1635  C   MSE A 204      20.276  18.817  19.320  1.00 40.37           C  
HETATM 1636  O   MSE A 204      19.070  18.639  19.193  1.00 40.67           O  
HETATM 1637  CB  MSE A 204      21.386  20.522  17.859  1.00 41.49           C  
HETATM 1638  CG  MSE A 204      22.102  20.840  16.548  1.00 49.99           C  
HETATM 1639 SE   MSE A 204      23.984  20.143  16.510  1.00 63.43          SE  
HETATM 1640  CE  MSE A 204      24.025  19.537  14.837  1.00 57.65           C  
ATOM   1641  N   GLU A 205      20.885  18.775  20.504  1.00 39.55           N  
ATOM   1642  CA  GLU A 205      20.130  18.851  21.758  1.00 42.71           C  
ATOM   1643  C   GLU A 205      20.035  20.321  22.148  1.00 41.59           C  
ATOM   1644  O   GLU A 205      21.050  21.042  22.113  1.00 39.75           O  
ATOM   1645  CB  GLU A 205      20.827  18.108  22.913  1.00 44.28           C  
ATOM   1646  CG  GLU A 205      21.050  16.583  22.752  1.00 55.30           C  
ATOM   1647  CD  GLU A 205      21.963  15.981  23.871  1.00 50.23           C  
ATOM   1648  N   TYR A 206      18.843  20.766  22.540  1.00 41.13           N  
ATOM   1649  CA  TYR A 206      18.659  22.117  23.050  1.00 42.93           C  
ATOM   1650  C   TYR A 206      18.150  22.059  24.465  1.00 42.66           C  
ATOM   1651  O   TYR A 206      17.298  21.243  24.752  1.00 43.94           O  
ATOM   1652  CB  TYR A 206      17.636  22.869  22.200  1.00 43.40           C  
ATOM   1653  CG  TYR A 206      17.965  22.855  20.732  1.00 45.06           C  
ATOM   1654  CD1 TYR A 206      17.519  21.822  19.912  1.00 44.71           C  
ATOM   1655  CD2 TYR A 206      18.740  23.869  20.159  1.00 44.12           C  
ATOM   1656  CE1 TYR A 206      17.820  21.791  18.555  1.00 49.75           C  
ATOM   1657  CE2 TYR A 206      19.058  23.836  18.787  1.00 47.32           C  
ATOM   1658  CZ  TYR A 206      18.594  22.792  17.999  1.00 44.18           C  
ATOM   1659  OH  TYR A 206      18.888  22.755  16.647  1.00 43.29           O  
ATOM   1660  N   PRO A 207      18.618  22.957  25.341  1.00 43.42           N  
ATOM   1661  CA  PRO A 207      17.947  23.048  26.642  1.00 45.93           C  
ATOM   1662  C   PRO A 207      16.469  23.425  26.477  1.00 47.77           C  
ATOM   1663  O   PRO A 207      16.150  24.239  25.614  1.00 45.88           O  
ATOM   1664  CB  PRO A 207      18.721  24.150  27.362  1.00 44.83           C  
ATOM   1665  CG  PRO A 207      20.036  24.230  26.659  1.00 41.10           C  
ATOM   1666  CD  PRO A 207      19.732  23.907  25.232  1.00 43.16           C  
ATOM   1667  N   ASP A 208      15.569  22.820  27.258  1.00 50.38           N  
ATOM   1668  CA  ASP A 208      14.134  23.108  27.092  1.00 52.65           C  
ATOM   1669  C   ASP A 208      13.868  24.599  27.223  1.00 50.86           C  
ATOM   1670  O   ASP A 208      13.075  25.165  26.471  1.00 49.73           O  
ATOM   1671  CB  ASP A 208      13.272  22.338  28.094  1.00 54.53           C  
ATOM   1672  CG  ASP A 208      13.068  20.870  27.711  1.00 63.67           C  
ATOM   1673  OD1 ASP A 208      12.480  20.523  26.641  1.00 66.64           O  
ATOM   1674  OD2 ASP A 208      13.489  20.047  28.545  1.00 73.04           O  
ATOM   1675  N   GLU A 209      14.559  25.224  28.169  1.00 50.49           N  
ATOM   1676  CA  GLU A 209      14.471  26.658  28.377  1.00 52.10           C  
ATOM   1677  C   GLU A 209      14.713  27.492  27.117  1.00 50.36           C  
ATOM   1678  O   GLU A 209      14.000  28.452  26.877  1.00 50.11           O  
ATOM   1679  CB  GLU A 209      15.424  27.101  29.481  1.00 52.96           C  
ATOM   1680  CG  GLU A 209      15.000  28.416  30.096  1.00 61.37           C  
ATOM   1681  CD  GLU A 209      15.567  28.640  31.499  1.00 66.63           C  
ATOM   1682  OE1 GLU A 209      16.735  28.248  31.761  1.00 71.42           O  
ATOM   1683  OE2 GLU A 209      14.833  29.219  32.336  1.00 75.02           O  
ATOM   1684  N   ARG A 210      15.704  27.126  26.309  1.00 48.87           N  
ATOM   1685  CA  ARG A 210      15.977  27.860  25.084  1.00 46.43           C  
ATOM   1686  C   ARG A 210      14.981  27.588  23.984  1.00 46.12           C  
ATOM   1687  O   ARG A 210      14.760  28.457  23.151  1.00 44.78           O  
ATOM   1688  CB  ARG A 210      17.354  27.544  24.578  1.00 45.87           C  
ATOM   1689  CG  ARG A 210      18.426  27.964  25.533  1.00 49.13           C  
ATOM   1690  CD  ARG A 210      19.754  28.111  24.818  1.00 42.63           C  
ATOM   1691  NE  ARG A 210      20.018  29.473  24.382  1.00 32.49           N  
ATOM   1692  CZ  ARG A 210      21.168  29.832  23.801  1.00 38.01           C  
ATOM   1693  NH1 ARG A 210      22.118  28.935  23.599  1.00 40.20           N  
ATOM   1694  NH2 ARG A 210      21.395  31.094  23.458  1.00 31.85           N  
ATOM   1695  N   ILE A 211      14.398  26.385  23.957  1.00 46.71           N  
ATOM   1696  CA  ILE A 211      13.390  26.066  22.956  1.00 46.90           C  
ATOM   1697  C   ILE A 211      12.188  26.958  23.207  1.00 48.30           C  
ATOM   1698  O   ILE A 211      11.631  27.513  22.269  1.00 49.65           O  
ATOM   1699  CB  ILE A 211      12.917  24.586  22.943  1.00 46.65           C  
ATOM   1700  CG1 ILE A 211      14.089  23.614  22.850  1.00 46.62           C  
ATOM   1701  CG2 ILE A 211      11.959  24.353  21.745  1.00 45.83           C  
ATOM   1702  CD1 ILE A 211      13.696  22.116  22.805  1.00 44.67           C  
ATOM   1703  N   SER A 212      11.800  27.094  24.470  1.00 49.70           N  
ATOM   1704  CA  SER A 212      10.693  27.988  24.869  1.00 50.40           C  
ATOM   1705  C   SER A 212      10.957  29.448  24.478  1.00 49.60           C  
ATOM   1706  O   SER A 212      10.083  30.142  23.979  1.00 49.60           O  
ATOM   1707  CB  SER A 212      10.478  27.925  26.389  1.00 50.94           C  
ATOM   1708  OG  SER A 212      10.100  26.634  26.826  1.00 50.28           O  
ATOM   1709  N   GLU A 213      12.181  29.897  24.711  1.00 48.69           N  
ATOM   1710  CA  GLU A 213      12.588  31.258  24.412  1.00 46.74           C  
ATOM   1711  C   GLU A 213      12.663  31.514  22.911  1.00 46.57           C  
ATOM   1712  O   GLU A 213      12.323  32.586  22.466  1.00 44.96           O  
ATOM   1713  CB  GLU A 213      13.951  31.527  25.049  1.00 45.30           C  
ATOM   1714  CG  GLU A 213      13.938  31.464  26.581  1.00 47.57           C  
ATOM   1715  CD  GLU A 213      15.344  31.478  27.244  1.00 48.06           C  
ATOM   1716  OE1 GLU A 213      16.379  31.089  26.630  1.00 40.38           O  
ATOM   1717  OE2 GLU A 213      15.396  31.907  28.415  1.00 58.75           O  
ATOM   1718  N   ARG A 214      13.082  30.520  22.124  1.00 48.08           N  
ATOM   1719  CA  ARG A 214      13.434  30.741  20.713  1.00 48.39           C  
ATOM   1720  C   ARG A 214      12.894  29.673  19.791  1.00 46.39           C  
ATOM   1721  O   ARG A 214      13.614  29.198  18.922  1.00 48.28           O  
ATOM   1722  CB  ARG A 214      14.966  30.753  20.561  1.00 49.10           C  
ATOM   1723  CG  ARG A 214      15.658  31.680  21.495  1.00 56.98           C  
ATOM   1724  CD  ARG A 214      16.958  32.193  20.919  1.00 64.29           C  
ATOM   1725  NE  ARG A 214      16.737  33.207  19.881  1.00 64.09           N  
ATOM   1726  CZ  ARG A 214      17.134  34.481  19.914  1.00 62.42           C  
ATOM   1727  NH1 ARG A 214      17.792  35.009  20.938  1.00 63.15           N  
ATOM   1728  NH2 ARG A 214      16.873  35.246  18.875  1.00 66.40           N  
ATOM   1729  N   GLU A 215      11.645  29.288  19.962  1.00 45.02           N  
ATOM   1730  CA  GLU A 215      11.072  28.189  19.167  1.00 45.36           C  
ATOM   1731  C   GLU A 215      11.222  28.361  17.653  1.00 45.13           C  
ATOM   1732  O   GLU A 215      11.491  27.383  16.942  1.00 46.86           O  
ATOM   1733  CB  GLU A 215       9.569  27.958  19.497  1.00 42.03           C  
ATOM   1734  OE1 GLU A 215       8.493  23.953  21.269  1.00 58.61           O  
ATOM   1735  OE2 GLU A 215       8.517  26.249  17.919  1.00 65.63           O  
ATOM   1736  N   GLU A 216      11.015  29.573  17.151  1.00 43.63           N  
ATOM   1737  CA  GLU A 216      11.012  29.794  15.708  1.00 43.55           C  
ATOM   1738  C   GLU A 216      12.426  29.641  15.158  1.00 43.69           C  
ATOM   1739  O   GLU A 216      12.655  28.969  14.142  1.00 45.99           O  
ATOM   1740  CB  GLU A 216      10.474  31.184  15.366  1.00 42.35           C  
ATOM   1741  CG  GLU A 216      10.224  31.383  13.864  1.00 46.84           C  
ATOM   1742  CD  GLU A 216       9.252  30.353  13.253  1.00 50.24           C  
ATOM   1743  OE1 GLU A 216       8.223  30.025  13.888  1.00 55.63           O  
ATOM   1744  OE2 GLU A 216       9.509  29.876  12.128  1.00 52.79           O  
ATOM   1745  N   THR A 217      13.364  30.267  15.847  1.00 40.06           N  
ATOM   1746  CA  THR A 217      14.756  30.194  15.486  1.00 40.88           C  
ATOM   1747  C   THR A 217      15.270  28.751  15.433  1.00 40.87           C  
ATOM   1748  O   THR A 217      15.995  28.377  14.511  1.00 44.38           O  
ATOM   1749  CB  THR A 217      15.571  30.974  16.504  1.00 39.58           C  
ATOM   1750  OG1 THR A 217      15.135  32.335  16.515  1.00 43.79           O  
ATOM   1751  CG2 THR A 217      17.059  30.926  16.190  1.00 43.69           C  
ATOM   1752  N   ILE A 218      14.913  27.965  16.443  1.00 38.48           N  
ATOM   1753  CA  ILE A 218      15.416  26.603  16.592  1.00 36.78           C  
ATOM   1754  C   ILE A 218      14.685  25.675  15.581  1.00 38.77           C  
ATOM   1755  O   ILE A 218      15.253  24.708  15.051  1.00 40.58           O  
ATOM   1756  CB  ILE A 218      15.250  26.146  18.066  1.00 34.31           C  
ATOM   1757  CG1 ILE A 218      16.330  26.770  18.938  1.00 38.61           C  
ATOM   1758  CG2 ILE A 218      15.303  24.628  18.209  1.00 37.25           C  
ATOM   1759  CD1 ILE A 218      16.000  26.803  20.417  1.00 38.80           C  
ATOM   1760  N   PHE A 219      13.422  25.973  15.304  1.00 38.33           N  
ATOM   1761  CA  PHE A 219      12.693  25.203  14.307  1.00 40.44           C  
ATOM   1762  C   PHE A 219      13.316  25.381  12.905  1.00 40.33           C  
ATOM   1763  O   PHE A 219      13.498  24.411  12.188  1.00 40.28           O  
ATOM   1764  CB  PHE A 219      11.207  25.552  14.344  1.00 39.85           C  
ATOM   1765  CG  PHE A 219      10.427  25.050  13.169  1.00 36.62           C  
ATOM   1766  CD1 PHE A 219      10.058  23.742  13.088  1.00 38.12           C  
ATOM   1767  CD2 PHE A 219      10.040  25.919  12.151  1.00 41.21           C  
ATOM   1768  CE1 PHE A 219       9.305  23.279  12.026  1.00 41.65           C  
ATOM   1769  CE2 PHE A 219       9.312  25.469  11.077  1.00 42.54           C  
ATOM   1770  CZ  PHE A 219       8.939  24.130  11.017  1.00 43.08           C  
ATOM   1771  N   ARG A 220      13.664  26.604  12.545  1.00 39.14           N  
ATOM   1772  CA  ARG A 220      14.371  26.871  11.284  1.00 40.82           C  
ATOM   1773  C   ARG A 220      15.728  26.221  11.159  1.00 41.31           C  
ATOM   1774  O   ARG A 220      16.040  25.661  10.112  1.00 41.37           O  
ATOM   1775  CB  ARG A 220      14.485  28.375  11.047  1.00 40.87           C  
ATOM   1776  CG  ARG A 220      13.134  28.848  10.593  1.00 45.88           C  
ATOM   1777  CD  ARG A 220      13.008  30.346  10.464  1.00 51.75           C  
ATOM   1778  NE  ARG A 220      11.586  30.655  10.273  1.00 51.99           N  
ATOM   1779  CZ  ARG A 220      11.109  31.856   9.978  1.00 52.99           C  
ATOM   1780  NH1 ARG A 220      11.938  32.875   9.810  1.00 53.52           N  
ATOM   1781  NH2 ARG A 220       9.794  32.029   9.828  1.00 55.68           N  
ATOM   1782  N   LEU A 221      16.526  26.279  12.222  1.00 40.67           N  
ATOM   1783  CA  LEU A 221      17.781  25.540  12.257  1.00 41.21           C  
ATOM   1784  C   LEU A 221      17.603  24.034  12.061  1.00 41.05           C  
ATOM   1785  O   LEU A 221      18.256  23.435  11.212  1.00 40.91           O  
ATOM   1786  CB  LEU A 221      18.499  25.801  13.577  1.00 42.36           C  
ATOM   1787  CG  LEU A 221      19.869  25.155  13.751  1.00 41.87           C  
ATOM   1788  CD1 LEU A 221      20.806  25.526  12.596  1.00 46.27           C  
ATOM   1789  CD2 LEU A 221      20.421  25.634  15.094  1.00 44.52           C  
ATOM   1790  N   GLU A 222      16.724  23.425  12.843  1.00 40.97           N  
ATOM   1791  CA  GLU A 222      16.475  21.987  12.721  1.00 43.55           C  
ATOM   1792  C   GLU A 222      15.894  21.587  11.358  1.00 44.01           C  
ATOM   1793  O   GLU A 222      16.214  20.525  10.832  1.00 44.30           O  
ATOM   1794  CB  GLU A 222      15.554  21.481  13.854  1.00 44.11           C  
ATOM   1795  CG  GLU A 222      16.292  21.202  15.161  1.00 46.11           C  
ATOM   1796  CD  GLU A 222      17.386  20.131  15.014  1.00 45.85           C  
ATOM   1797  OE1 GLU A 222      17.130  19.067  14.423  1.00 42.86           O  
ATOM   1798  OE2 GLU A 222      18.503  20.339  15.517  1.00 42.93           O  
ATOM   1799  N   GLN A 223      15.061  22.439  10.780  1.00 45.16           N  
ATOM   1800  CA  GLN A 223      14.637  22.271   9.397  1.00 45.94           C  
ATOM   1801  C   GLN A 223      15.820  22.087   8.457  1.00 45.87           C  
ATOM   1802  O   GLN A 223      15.810  21.166   7.637  1.00 45.47           O  
ATOM   1803  CB  GLN A 223      13.835  23.476   8.926  1.00 47.21           C  
ATOM   1804  CG  GLN A 223      12.356  23.227   8.803  1.00 53.66           C  
ATOM   1805  CD  GLN A 223      11.634  24.425   8.187  1.00 62.30           C  
ATOM   1806  OE1 GLN A 223      12.078  25.580   8.294  1.00 63.23           O  
ATOM   1807  NE2 GLN A 223      10.529  24.151   7.526  1.00 62.16           N  
ATOM   1808  N   GLU A 224      16.843  22.928   8.596  1.00 43.45           N  
ATOM   1809  CA  GLU A 224      18.014  22.842   7.718  1.00 47.09           C  
ATOM   1810  C   GLU A 224      18.871  21.627   8.026  1.00 43.08           C  
ATOM   1811  O   GLU A 224      19.227  20.884   7.128  1.00 43.75           O  
ATOM   1812  CB  GLU A 224      18.881  24.091   7.810  1.00 45.66           C  
ATOM   1813  CG  GLU A 224      18.167  25.399   7.470  1.00 55.70           C  
ATOM   1814  CD  GLU A 224      19.042  26.646   7.803  1.00 59.07           C  
ATOM   1815  OE1 GLU A 224      20.290  26.539   7.663  1.00 78.81           O  
ATOM   1816  OE2 GLU A 224      18.493  27.715   8.209  1.00 71.79           O  
ATOM   1817  N   LEU A 225      19.193  21.439   9.299  1.00 41.20           N  
ATOM   1818  CA  LEU A 225      19.984  20.302   9.757  1.00 39.83           C  
ATOM   1819  C   LEU A 225      19.381  18.933   9.431  1.00 41.18           C  
ATOM   1820  O   LEU A 225      20.125  18.010   9.095  1.00 43.50           O  
ATOM   1821  CB  LEU A 225      20.232  20.400  11.259  1.00 38.86           C  
ATOM   1822  CG  LEU A 225      21.081  21.617  11.683  1.00 43.81           C  
ATOM   1823  CD1 LEU A 225      21.240  21.668  13.201  1.00 39.89           C  
ATOM   1824  CD2 LEU A 225      22.449  21.602  11.029  1.00 41.19           C  
ATOM   1825  N   SER A 226      18.054  18.809   9.495  1.00 39.59           N  
ATOM   1826  CA  SER A 226      17.381  17.558   9.163  1.00 41.71           C  
ATOM   1827  C   SER A 226      17.605  17.127   7.714  1.00 43.11           C  
ATOM   1828  O   SER A 226      17.524  15.957   7.402  1.00 44.02           O  
ATOM   1829  CB  SER A 226      15.873  17.652   9.440  1.00 41.80           C  
ATOM   1830  OG  SER A 226      15.274  18.526   8.526  1.00 39.31           O  
ATOM   1831  N   ARG A 227      17.904  18.073   6.838  1.00 45.62           N  
ATOM   1832  CA  ARG A 227      18.126  17.766   5.432  1.00 48.22           C  
ATOM   1833  C   ARG A 227      19.570  17.398   5.118  1.00 49.49           C  
ATOM   1834  O   ARG A 227      19.862  16.991   4.011  1.00 50.85           O  
ATOM   1835  CB  ARG A 227      17.750  18.979   4.585  1.00 49.89           C  
ATOM   1836  CG  ARG A 227      16.286  19.330   4.666  1.00 54.76           C  
ATOM   1837  CD  ARG A 227      16.018  20.741   4.146  1.00 64.01           C  
ATOM   1838  NE  ARG A 227      14.685  21.153   4.576  1.00 73.09           N  
ATOM   1839  CZ  ARG A 227      13.549  20.711   4.042  1.00 77.01           C  
ATOM   1840  NH1 ARG A 227      13.570  19.864   3.014  1.00 77.29           N  
ATOM   1841  NH2 ARG A 227      12.384  21.120   4.535  1.00 78.14           N  
ATOM   1842  N   ASP A 228      20.484  17.573   6.071  1.00 50.19           N  
ATOM   1843  CA  ASP A 228      21.895  17.277   5.837  1.00 48.97           C  
ATOM   1844  C   ASP A 228      22.247  15.789   6.079  1.00 47.79           C  
ATOM   1845  O   ASP A 228      22.362  15.352   7.228  1.00 43.73           O  
ATOM   1846  CB  ASP A 228      22.746  18.204   6.724  1.00 50.28           C  
ATOM   1847  CG  ASP A 228      24.231  18.136   6.395  1.00 50.26           C  
ATOM   1848  OD1 ASP A 228      24.712  17.040   6.013  1.00 44.76           O  
ATOM   1849  OD2 ASP A 228      24.912  19.189   6.506  1.00 52.02           O  
ATOM   1850  N   ARG A 229      22.476  15.048   4.992  1.00 47.65           N  
ATOM   1851  CA  ARG A 229      22.758  13.600   5.051  1.00 49.46           C  
ATOM   1852  C   ARG A 229      23.995  13.210   5.847  1.00 48.49           C  
ATOM   1853  O   ARG A 229      24.039  12.139   6.482  1.00 48.12           O  
ATOM   1854  CB  ARG A 229      22.906  13.021   3.656  1.00 50.70           C  
ATOM   1855  CG  ARG A 229      21.599  13.016   2.920  1.00 62.59           C  
ATOM   1856  CD  ARG A 229      21.631  12.117   1.691  1.00 81.01           C  
ATOM   1857  NE  ARG A 229      20.290  11.611   1.367  1.00 90.65           N  
ATOM   1858  CZ  ARG A 229      19.614  10.691   2.071  1.00 87.98           C  
ATOM   1859  NH1 ARG A 229      20.122  10.144   3.186  1.00 83.55           N  
ATOM   1860  NH2 ARG A 229      18.413  10.316   1.643  1.00 87.63           N  
ATOM   1861  N   ASN A 230      24.996  14.083   5.817  1.00 47.04           N  
ATOM   1862  CA  ASN A 230      26.252  13.849   6.535  1.00 45.33           C  
ATOM   1863  C   ASN A 230      26.101  13.756   8.041  1.00 44.65           C  
ATOM   1864  O   ASN A 230      26.958  13.185   8.698  1.00 47.43           O  
ATOM   1865  CB  ASN A 230      27.227  14.948   6.234  1.00 44.84           C  
ATOM   1866  CG  ASN A 230      27.430  15.139   4.767  1.00 53.71           C  
ATOM   1867  OD1 ASN A 230      27.871  14.208   4.064  1.00 48.23           O  
ATOM   1868  ND2 ASN A 230      27.091  16.355   4.270  1.00 52.30           N  
ATOM   1869  N   ILE A 231      25.011  14.281   8.587  1.00 44.58           N  
ATOM   1870  CA  ILE A 231      24.855  14.361  10.021  1.00 45.25           C  
ATOM   1871  C   ILE A 231      23.584  13.767  10.620  1.00 46.64           C  
ATOM   1872  O   ILE A 231      23.345  13.894  11.816  1.00 47.37           O  
ATOM   1873  CB  ILE A 231      24.890  15.818  10.438  1.00 47.02           C  
ATOM   1874  CG1 ILE A 231      23.627  16.547  10.037  1.00 45.08           C  
ATOM   1875  CG2 ILE A 231      26.118  16.527   9.834  1.00 56.00           C  
ATOM   1876  CD1 ILE A 231      23.678  17.966  10.458  1.00 53.87           C  
ATOM   1877  N   ILE A 232      22.730  13.150   9.831  1.00 47.03           N  
ATOM   1878  CA  ILE A 232      21.459  12.796  10.414  1.00 49.16           C  
ATOM   1879  C   ILE A 232      21.487  11.707  11.469  1.00 46.32           C  
ATOM   1880  O   ILE A 232      20.625  11.718  12.338  1.00 47.62           O  
ATOM   1881  CB  ILE A 232      20.341  12.541   9.364  1.00 52.50           C  
ATOM   1882  CG1 ILE A 232      20.663  11.315   8.521  1.00 49.62           C  
ATOM   1883  CG2 ILE A 232      19.989  13.948   8.632  1.00 56.04           C  
ATOM   1884  CD1 ILE A 232      20.456  11.515   7.066  1.00 53.16           C  
ATOM   1885  N   TRP A 233      22.463  10.804  11.429  1.00 44.76           N  
ATOM   1886  CA  TRP A 233      22.532   9.731  12.436  1.00 44.14           C  
ATOM   1887  C   TRP A 233      23.006  10.227  13.814  1.00 43.61           C  
ATOM   1888  O   TRP A 233      23.009   9.477  14.764  1.00 42.88           O  
ATOM   1889  CB  TRP A 233      23.307   8.521  11.904  1.00 43.08           C  
ATOM   1890  CG  TRP A 233      22.556   7.926  10.775  1.00 42.08           C  
ATOM   1891  CD1 TRP A 233      22.719   8.187   9.460  1.00 41.51           C  
ATOM   1892  CD2 TRP A 233      21.456   7.013  10.869  1.00 43.22           C  
ATOM   1893  NE1 TRP A 233      21.809   7.477   8.711  1.00 41.61           N  
ATOM   1894  CE2 TRP A 233      21.018   6.749   9.555  1.00 45.81           C  
ATOM   1895  CE3 TRP A 233      20.819   6.376  11.931  1.00 43.42           C  
ATOM   1896  CZ2 TRP A 233      19.974   5.873   9.276  1.00 45.20           C  
ATOM   1897  CZ3 TRP A 233      19.770   5.515  11.653  1.00 43.50           C  
ATOM   1898  CH2 TRP A 233      19.358   5.275  10.335  1.00 42.84           C  
ATOM   1899  N   LYS A 234      23.338  11.513  13.895  1.00 44.80           N  
ATOM   1900  CA  LYS A 234      23.539  12.193  15.188  0.50 45.33           C  
ATOM   1902  C   LYS A 234      22.205  12.400  15.883  1.00 44.84           C  
ATOM   1903  O   LYS A 234      22.172  12.581  17.085  1.00 47.63           O  
ATOM   1904  CB  LYS A 234      24.231  13.578  15.026  0.50 46.37           C  
ATOM   1906  CG  LYS A 234      24.438  14.380  16.387  0.50 49.42           C  
ATOM   1908  CD  LYS A 234      25.228  15.706  16.218  0.50 46.38           C  
ATOM   1910  CE  LYS A 234      25.456  16.455  17.537  0.50 44.86           C  
ATOM   1912  NZ  LYS A 234      24.190  16.778  18.271  0.50 36.93           N  
ATOM   1914  N   ALA A 235      21.101  12.369  15.141  1.00 42.22           N  
ATOM   1915  CA  ALA A 235      19.823  12.816  15.676  1.00 42.31           C  
ATOM   1916  C   ALA A 235      19.147  11.897  16.678  1.00 44.16           C  
ATOM   1917  O   ALA A 235      19.299  10.683  16.651  1.00 42.55           O  
ATOM   1918  CB  ALA A 235      18.859  13.127  14.537  1.00 43.00           C  
ATOM   1919  N   ASP A 236      18.346  12.523  17.536  1.00 46.48           N  
ATOM   1920  CA  ASP A 236      17.526  11.844  18.527  1.00 48.00           C  
ATOM   1921  C   ASP A 236      16.717  10.722  17.898  1.00 49.93           C  
ATOM   1922  O   ASP A 236      16.829   9.573  18.340  1.00 52.97           O  
ATOM   1923  CB  ASP A 236      16.585  12.855  19.232  1.00 49.56           C  
ATOM   1924  CG  ASP A 236      16.027  12.328  20.537  1.00 50.99           C  
ATOM   1925  OD1 ASP A 236      16.477  11.281  21.011  1.00 60.20           O  
ATOM   1926  OD2 ASP A 236      15.140  12.969  21.113  1.00 65.05           O  
ATOM   1927  N   HIS A 237      15.913  11.048  16.875  1.00 49.88           N  
ATOM   1928  CA  HIS A 237      15.138  10.030  16.120  1.00 48.50           C  
ATOM   1929  C   HIS A 237      15.390  10.147  14.630  1.00 46.78           C  
ATOM   1930  O   HIS A 237      15.859  11.153  14.156  1.00 48.09           O  
ATOM   1931  CB  HIS A 237      13.643  10.189  16.364  1.00 48.87           C  
ATOM   1932  CG  HIS A 237      13.217   9.862  17.756  1.00 55.37           C  
ATOM   1933  ND1 HIS A 237      13.234  10.790  18.778  1.00 63.92           N  
ATOM   1934  CD2 HIS A 237      12.750   8.711  18.297  1.00 58.88           C  
ATOM   1935  CE1 HIS A 237      12.810  10.214  19.892  1.00 65.43           C  
ATOM   1936  NE2 HIS A 237      12.504   8.954  19.624  1.00 58.50           N  
ATOM   1937  N   ILE A 238      15.040   9.117  13.880  1.00 46.76           N  
ATOM   1938  CA  ILE A 238      15.210   9.133  12.425  1.00 46.09           C  
ATOM   1939  C   ILE A 238      13.838   9.102  11.719  1.00 44.62           C  
ATOM   1940  O   ILE A 238      12.998   8.280  12.039  1.00 44.98           O  
ATOM   1941  CB  ILE A 238      16.090   7.910  11.945  1.00 47.12           C  
ATOM   1942  CG1 ILE A 238      17.500   7.973  12.540  1.00 49.44           C  
ATOM   1943  CG2 ILE A 238      16.180   7.840  10.423  1.00 46.09           C  
ATOM   1944  CD1 ILE A 238      18.361   9.173  12.033  1.00 50.16           C  
ATOM   1945  N   PHE A 239      13.646  10.007  10.761  1.00 43.78           N  
ATOM   1946  CA  PHE A 239      12.459  10.099   9.908  1.00 41.99           C  
ATOM   1947  C   PHE A 239      12.854   9.590   8.542  1.00 41.96           C  
ATOM   1948  O   PHE A 239      13.939   9.933   8.059  1.00 39.48           O  
ATOM   1949  CB  PHE A 239      12.042  11.577   9.803  1.00 44.04           C  
ATOM   1950  CG  PHE A 239      11.008  11.888   8.726  1.00 45.01           C  
ATOM   1951  CD1 PHE A 239      11.398  12.196   7.432  1.00 45.95           C  
ATOM   1952  CD2 PHE A 239       9.654  11.916   9.026  1.00 45.69           C  
ATOM   1953  CE1 PHE A 239      10.446  12.513   6.459  1.00 42.66           C  
ATOM   1954  CE2 PHE A 239       8.721  12.228   8.062  1.00 43.47           C  
ATOM   1955  CZ  PHE A 239       9.123  12.519   6.778  1.00 44.89           C  
ATOM   1956  N   PHE A 240      12.001   8.795   7.902  1.00 40.11           N  
ATOM   1957  CA  PHE A 240      12.314   8.376   6.539  1.00 42.89           C  
ATOM   1958  C   PHE A 240      11.080   8.187   5.672  1.00 43.74           C  
ATOM   1959  O   PHE A 240       9.968   8.040   6.182  1.00 44.57           O  
ATOM   1960  CB  PHE A 240      13.208   7.120   6.529  1.00 44.42           C  
ATOM   1961  CG  PHE A 240      12.538   5.890   7.042  1.00 40.86           C  
ATOM   1962  CD1 PHE A 240      11.787   5.101   6.197  1.00 43.58           C  
ATOM   1963  CD2 PHE A 240      12.668   5.516   8.368  1.00 45.38           C  
ATOM   1964  CE1 PHE A 240      11.167   3.967   6.652  1.00 42.98           C  
ATOM   1965  CE2 PHE A 240      12.065   4.369   8.852  1.00 49.24           C  
ATOM   1966  CZ  PHE A 240      11.286   3.599   8.000  1.00 50.59           C  
ATOM   1967  N   VAL A 241      11.303   8.206   4.360  1.00 42.81           N  
ATOM   1968  CA  VAL A 241      10.247   8.048   3.362  1.00 42.44           C  
ATOM   1969  C   VAL A 241      10.686   7.006   2.344  1.00 41.33           C  
ATOM   1970  O   VAL A 241      11.766   7.135   1.773  1.00 41.07           O  
ATOM   1971  CB  VAL A 241       9.982   9.383   2.596  1.00 44.17           C  
ATOM   1972  CG1 VAL A 241       8.894   9.209   1.519  1.00 44.37           C  
ATOM   1973  CG2 VAL A 241       9.603  10.485   3.558  1.00 42.28           C  
ATOM   1974  N   LEU A 242       9.850   6.004   2.122  1.00 40.69           N  
ATOM   1975  CA  LEU A 242      10.037   5.020   1.069  1.00 42.77           C  
ATOM   1976  C   LEU A 242       8.929   5.123   0.044  1.00 43.46           C  
ATOM   1977  O   LEU A 242       7.815   5.491   0.371  1.00 44.17           O  
ATOM   1978  CB  LEU A 242       9.989   3.599   1.640  1.00 43.19           C  
ATOM   1979  CG  LEU A 242      10.816   3.324   2.892  1.00 44.29           C  
ATOM   1980  CD1 LEU A 242      10.791   1.852   3.141  1.00 44.45           C  
ATOM   1981  CD2 LEU A 242      12.260   3.779   2.729  1.00 45.75           C  
ATOM   1982  N   LYS A 243       9.234   4.737  -1.185  1.00 43.17           N  
ATOM   1983  CA  LYS A 243       8.290   4.762  -2.283  1.00 45.38           C  
ATOM   1984  C   LYS A 243       8.204   3.342  -2.784  1.00 44.60           C  
ATOM   1985  O   LYS A 243       9.235   2.716  -3.024  1.00 43.26           O  
ATOM   1986  CB  LYS A 243       8.811   5.677  -3.387  1.00 44.72           C  
ATOM   1987  CG  LYS A 243       7.838   6.059  -4.481  1.00 46.75           C  
ATOM   1988  CD  LYS A 243       8.609   6.563  -5.728  1.00 52.28           C  
ATOM   1989  CE  LYS A 243       8.079   7.897  -6.283  1.00 61.30           C  
ATOM   1990  N   LYS A 244       6.982   2.825  -2.900  1.00 46.76           N  
ATOM   1991  CA  LYS A 244       6.763   1.468  -3.390  1.00 47.11           C  
ATOM   1992  C   LYS A 244       7.173   1.444  -4.840  1.00 49.74           C  
ATOM   1993  O   LYS A 244       6.683   2.234  -5.626  1.00 48.27           O  
ATOM   1994  CB  LYS A 244       5.298   1.068  -3.231  1.00 46.21           C  
ATOM   1995  CG  LYS A 244       4.963  -0.310  -3.802  1.00 44.63           C  
ATOM   1996  CD  LYS A 244       3.555  -0.714  -3.506  1.00 42.66           C  
ATOM   1997  CE  LYS A 244       3.200  -2.030  -4.172  1.00 40.50           C  
ATOM   1998  NZ  LYS A 244       1.886  -2.501  -3.702  1.00 39.58           N  
ATOM   1999  N   LYS A 245       8.110   0.565  -5.182  1.00 56.45           N  
ATOM   2000  CA  LYS A 245       8.590   0.438  -6.560  1.00 61.68           C  
ATOM   2001  C   LYS A 245       7.510  -0.183  -7.448  1.00 65.56           C  
ATOM   2002  O   LYS A 245       6.625  -0.904  -6.971  1.00 66.37           O  
ATOM   2003  CB  LYS A 245       9.886  -0.376  -6.597  1.00 61.51           C  
ATOM   2004  CG  LYS A 245      11.107   0.437  -6.153  1.00 65.76           C  
ATOM   2005  CD  LYS A 245      12.272  -0.420  -5.591  1.00 66.13           C  
ATOM   2006  CE  LYS A 245      13.179  -1.035  -6.657  1.00 65.16           C  
ATOM   2007  N   ARG A 246       7.573   0.103  -8.742  1.00 69.95           N  
ATOM   2008  CA  ARG A 246       6.495  -0.279  -9.654  1.00 74.23           C  
ATOM   2009  C   ARG A 246       6.705  -1.638 -10.353  1.00 75.03           C  
ATOM   2010  O   ARG A 246       7.813  -2.176 -10.384  1.00 75.91           O  
ATOM   2011  CB  ARG A 246       6.291   0.818 -10.692  1.00 75.08           C  
ATOM   2012  CG  ARG A 246       4.848   0.912 -11.204  1.00 81.46           C  
ATOM   2013  CD  ARG A 246       4.722   1.977 -12.279  1.00 87.68           C  
ATOM   2014  NE  ARG A 246       5.265   3.262 -11.820  1.00 90.07           N  
ATOM   2015  CZ  ARG A 246       5.890   4.160 -12.587  1.00 91.44           C  
ATOM   2016  NH1 ARG A 246       6.086   3.945 -13.890  1.00 94.37           N  
ATOM   2017  NH2 ARG A 246       6.337   5.286 -12.040  1.00 89.18           N  
TER    2018      ARG A 246                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
