
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  213 ( 1657),  selected  213 , name 2pxx_A
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 2pxx_A.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    17_A      M       1           -
LGA    S    18_A      S       2           -
LGA    G    19_A      E       3           -
LGA    Y    20_A      N       4           -
LGA    R    21_A      -       -           -
LGA    E    22_A      -       -           -
LGA    V    23_A      -       -           -
LGA    E    24_A      K       5           #
LGA    Y    25_A      K       6          2.453
LGA    -       -      K       7           -
LGA    W    26_A      F       8          0.311
LGA    D    27_A      D       9          1.660
LGA    Q    28_A      K      10          3.045
LGA    -       -      K      11           -
LGA    R    29_A      G      12          0.651
LGA    Y    30_A      A      13          1.299
LGA    Q    31_A      -       -           -
LGA    G    32_A      -       -           -
LGA    A    33_A      K      14          3.945
LGA    A    34_A      N      15           -
LGA    D    35_A      M      16           -
LGA    S    36_A      D      17          4.925
LGA    A    37_A      E      18          3.601
LGA    P    38_A      I      19           #
LGA    Y    39_A      S      20          1.678
LGA    -       -      K      21           -
LGA    -       -      T      22           -
LGA    -       -      L      23           -
LGA    D    40_A      F      24          4.986
LGA    W    41_A      A      25           -
LGA    F    42_A      P      26           -
LGA    G    43_A      I      27          4.955
LGA    D    44_A      Y      28          3.365
LGA    F    45_A      P      29          3.871
LGA    S    46_A      I      30          1.367
LGA    S    47_A      I      31          4.903
LGA    F    48_A      A      32           #
LGA    R    49_A      E      33          3.018
LGA    A    50_A      N      34          2.808
LGA    L    51_A      I      35          5.096
LGA    L    52_A      I      36          4.798
LGA    E    53_A      N      37          3.040
LGA    P    54_A      R      38          2.678
LGA    E    55_A      F      39          0.950
LGA    L    56_A      G      40          3.937
LGA    R    57_A      I      41          1.869
LGA    P    58_A      T      42          1.990
LGA    E    59_A      A      43          1.736
LGA    D    60_A      G      44          2.587
LGA    R    61_A      N      45          0.449
LGA    I    62_A      C      46          0.316
LGA    L    63_A      I      47          0.331
LGA    V    64_A      D      48          0.564
LGA    L    65_A      I      49          0.433
LGA    G    66_A      G      50          0.586
LGA    C    67_A      S      51          0.643
LGA    G    68_A      G      52          0.766
LGA    N    69_A      P      53          1.608
LGA    S    70_A      G      54          4.350
LGA    A    71_A      A      55          1.296
LGA    L    72_A      L      56          0.756
LGA    S    73_A      S      57          0.449
LGA    Y    74_A      I      58          0.565
LGA    E    75_A      A      59          0.600
LGA    L    76_A      L      60          0.388
LGA    F    77_A      A      61          0.711
LGA    L    78_A      K      62          0.733
LGA    G    79_A      Q      63          0.612
LGA    G    80_A      S      64          1.482
LGA    F    81_A      D      65          3.376
LGA    P    82_A      F      66          3.136
LGA    N    83_A      S      67          1.144
LGA    V    84_A      I      68          0.869
LGA    T    85_A      R      69          0.618
LGA    S    86_A      A      70          0.443
LGA    V    87_A      L      71          0.746
LGA    D    88_A      D      72          0.585
LGA    Y    89_A      F      73          0.616
LGA    S    90_A      S      74          0.533
LGA    S    91_A      K      75          0.703
LGA    V    92_A      H      76          1.256
LGA    V    93_A      M      77          1.158
LGA    V    94_A      N      78          0.742
LGA    A    95_A      E      79          1.731
LGA    A    96_A      I      80          1.523
LGA    M    97_A      A      81          0.944
LGA    Q    98_A      L      82          1.097
LGA    A    99_A      K      83          1.666
LGA    C   100_A      N      84          1.606
LGA    Y   101_A      I      85          0.868
LGA    A   102_A      A      86          1.493
LGA    -       -      D      87           -
LGA    -       -      A      88           -
LGA    H   103_A      D      89          1.530
LGA    V   104_A      L      90          0.741
LGA    P   105_A      N      91          2.112
LGA    Q   106_A      D      92          2.751
LGA    -       -      R      93           -
LGA    L   107_A      I      94          0.773
LGA    R   108_A      Q      95          0.694
LGA    W   109_A      I      96          0.538
LGA    E   110_A      V      97          1.282
LGA    T   111_A      Q      98          0.982
LGA    M   112_A      G      99          0.423
LGA    D   113_A      D     100          1.096
LGA    V   114_A      V     101          1.045
LGA    R   115_A      H     102          0.478
LGA    K   116_A      N     103          0.230
LGA    L   117_A      I     104          0.309
LGA    D   118_A      P     105          0.901
LGA    F   119_A      I     106          1.260
LGA    P   120_A      E     107          1.432
LGA    S   121_A      D     108          0.901
LGA    A   122_A      N     109          1.323
LGA    S   123_A      Y     110          1.531
LGA    F   124_A      A     111          1.153
LGA    D   125_A      D     112          1.072
LGA    V   126_A      L     113          1.118
LGA    V   127_A      I     114          0.947
LGA    L   128_A      V     115          1.015
LGA    E   129_A      S     116          1.397
LGA    K   130_A      R     117          1.338
LGA    G   131_A      G     118          1.679
LGA    T   132_A      S     119          1.247
LGA    L   133_A      V     120          1.502
LGA    D   134_A      F     121          0.242
LGA    A   135_A      F     122          1.002
LGA    L   136_A      W     123          1.760
LGA    L   137_A      -       -           -
LGA    A   138_A      -       -           -
LGA    G   139_A      -       -           -
LGA    E   140_A      -       -           -
LGA    R   141_A      -       -           -
LGA    D   142_A      -       -           -
LGA    P   143_A      -       -           -
LGA    W   144_A      -       -           -
LGA    T   145_A      -       -           -
LGA    V   146_A      -       -           -
LGA    S   147_A      -       -           -
LGA    S   148_A      -       -           -
LGA    E   149_A      -       -           -
LGA    G   150_A      E     124          4.705
LGA    V   151_A      -       -           -
LGA    H   152_A      -       -           -
LGA    T   153_A      D     125          1.164
LGA    V   154_A      V     126          0.532
LGA    D   155_A      T     127          0.866
LGA    Q   156_A      T     128          0.997
LGA    V   157_A      A     129          0.871
LGA    L   158_A      F     130          0.574
LGA    S   159_A      R     131          0.576
LGA    E   160_A      E     132          0.627
LGA    V   161_A      I     133          0.744
LGA    S   162_A      Y     134          0.789
LGA    R   163_A      R     135          0.731
LGA    V   164_A      I     136          0.814
LGA    L   165_A      L     137          1.143
LGA    V   166_A      K     138          1.461
LGA    P   167_A      S     139          1.489
LGA    G   168_A      G     140          1.675
LGA    G   169_A      G     141          1.504
LGA    R   170_A      K     142          1.340
LGA    F   171_A      T     143          1.692
LGA    I   172_A      Y     144          1.512
LGA    S   173_A      I     145          1.227
LGA    M   174_A      G     146          1.774
LGA    T   175_A      G     147          3.085
LGA    -       -      G     148           -
LGA    -       -      F     149           -
LGA    -       -      G     150           -
LGA    -       -      N     151           -
LGA    -       -      K     152           -
LGA    -       -      E     153           -
LGA    -       -      L     154           -
LGA    -       -      R     155           -
LGA    -       -      D     156           -
LGA    -       -      S     157           -
LGA    -       -      I     158           -
LGA    -       -      S     159           -
LGA    -       -      A     160           -
LGA    -       -      E     161           -
LGA    -       -      M     162           -
LGA    -       -      I     163           -
LGA    -       -      R     164           -
LGA    -       -      K     165           -
LGA    -       -      N     166           -
LGA    -       -      P     167           -
LGA    -       -      D     168           -
LGA    -       -      W     169           -
LGA    -       -      K     170           -
LGA    -       -      E     171           -
LGA    -       -      F     172           -
LGA    -       -      N     173           -
LGA    -       -      R     174           -
LGA    -       -      K     175           -
LGA    S   176_A      N     176          2.992
LGA    A   177_A      I     177          4.025
LGA    A   178_A      S     178          2.955
LGA    -       -      Q     179           -
LGA    -       -      E     180           -
LGA    -       -      N     181           -
LGA    P   179_A      V     182          1.596
LGA    H   180_A      E     183          2.774
LGA    F   181_A      R     184          3.230
LGA    R   182_A      F     185          2.782
LGA    T   183_A      Q     186          1.772
LGA    R   184_A      N     187          1.404
LGA    H   185_A      V     188          1.948
LGA    Y   186_A      L     189          2.555
LGA    A   187_A      D     190          2.696
LGA    Q   188_A      E     191          3.387
LGA    A   189_A      I     192          4.528
LGA    Y   190_A      G     193          3.575
LGA    Y   191_A      V     194          4.163
LGA    G   192_A      S     195          4.881
LGA    W   193_A      -       -           -
LGA    S   194_A      S     196          1.019
LGA    L   195_A      Y     197          1.405
LGA    R   196_A      E     198          1.254
LGA    H   197_A      I     199          3.116
LGA    A   198_A      I     200          3.030
LGA    T   199_A      L     201          3.111
LGA    Y   200_A      E     202          3.909
LGA    G   201_A      D     203          3.893
LGA    S   202_A      E     204           #
LGA    G   203_A      -       -           -
LGA    F   204_A      -       -           -
LGA    H   205_A      -       -           -
LGA    F   206_A      G     205          2.293
LGA    H   207_A      F     206          1.188
LGA    L   208_A      W     207          1.889
LGA    Y   209_A      I     208          2.177
LGA    L   210_A      I     209          1.256
LGA    M   211_A      I     210          0.978
LGA    H   212_A      S     211          0.438
LGA    K   213_A      K     212          0.688
LGA    G   214_A      T     213          0.914
LGA    -       -      D     214           -
LGA    G   215_A      Q     215           #
LGA    K   216_A      E     216           #
LGA    L   217_A      V     217           -
LGA    S   218_A      I     218           -
LGA    V   219_A      -       -           -
LGA    A   220_A      -       -           -
LGA    Q   221_A      -       -           -
LGA    L   222_A      -       -           -
LGA    A   223_A      -       -           -
LGA    L   224_A      -       -           -
LGA    G   225_A      -       -           -
LGA    A   226_A      -       -           -
LGA    Q   227_A      -       -           -
LGA    I   228_A      -       -           -
LGA    L   229_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  213  218    5.0    162    2.13    13.58     62.572     7.262

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.212064 * X  +   0.796023 * Y  +  -0.566900 * Z  +   7.006346
  Y_new =  -0.834087 * X  +  -0.449714 * Y  +  -0.319462 * Z  +  15.992143
  Z_new =  -0.509242 * X  +   0.405098 * Y  +   0.759321 * Z  +  -1.749482 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.490088   -2.651505  [ DEG:    28.0799   -151.9201 ]
  Theta =   0.534304    2.607289  [ DEG:    30.6133    149.3867 ]
  Phi   =  -1.819767    1.321825  [ DEG:  -104.2650     75.7350 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pxx_A                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pxx_A.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  213  218   5.0  162   2.13   13.58  62.572
REMARK  ---------------------------------------------------------- 
MOLECULE 2pxx_A
HEADER    TRANSFERASE                             14-MAY-07   2PXX              
TITLE     HUMAN PUTATIVE METHYLTRANSFERASE MGC2408                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN MGC2408;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 19-231;                                           
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MGC2408;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) CODON PLUS RIL;                  
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28A-LIC                                
KEYWDS    STRUCTURAL GENOMICS CONSORTIUM, SGC, METHYLTRANSFERASE,               
KEYWDS   2 MGC2408, LOC84291                                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    W.TEMPEL,H.WU,L.DOMBROVSKI,H.ZENG,H.ZHU,P.LOPPNAU,J.WEIGELT,          
AUTHOR   2 M.SUNDSTROM,C.H.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,                  
AUTHOR   3 A.N.PLOTNIKOV,STRUCTURAL GENOMICS CONSORTIUM (SGC)                   
REVDAT   1   22-MAY-07 2PXX    0                                                
JRNL        AUTH   H.WU,W.TEMPEL,L.DOMBROVSKI,H.ZENG,H.ZHU,P.LOPPNAU,           
JRNL        AUTH 2 J.WEIGELT,M.SUNDSTROM,C.H.ARROWSMITH,A.M.EDWARDS,            
JRNL        AUTH 3 A.BOCHKAREV,A.N.PLOTNIKOV                                    
JRNL        TITL   HUMAN PUTATIVE METHYLTRANSFERASE MGC2408.                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.30 ANGSTROMS.                                          
DBREF  2PXX A   19   231  UNP    Q9BRZ8   Q9BRZ8_HUMAN    19    231             
SEQRES   1 A  215  GLY SER GLY TYR ARG GLU VAL GLU TYR TRP ASP GLN ARG          
SEQRES   2 A  215  TYR GLN GLY ALA ALA ASP SER ALA PRO TYR ASP TRP PHE          
SEQRES   3 A  215  GLY ASP PHE SER SER PHE ARG ALA LEU LEU GLU PRO GLU          
SEQRES   4 A  215  LEU ARG PRO GLU ASP ARG ILE LEU VAL LEU GLY CYS GLY          
SEQRES   5 A  215  ASN SER ALA LEU SER TYR GLU LEU PHE LEU GLY GLY PHE          
SEQRES   6 A  215  PRO ASN VAL THR SER VAL ASP TYR SER SER VAL VAL VAL          
SEQRES   7 A  215  ALA ALA MET GLN ALA CYS TYR ALA HIS VAL PRO GLN LEU          
SEQRES   8 A  215  ARG TRP GLU THR MET ASP VAL ARG LYS LEU ASP PHE PRO          
SEQRES   9 A  215  SER ALA SER PHE ASP VAL VAL LEU GLU LYS GLY THR LEU          
SEQRES  10 A  215  ASP ALA LEU LEU ALA GLY GLU ARG ASP PRO TRP THR VAL          
SEQRES  11 A  215  SER SER GLU GLY VAL HIS THR VAL ASP GLN VAL LEU SER          
SEQRES  12 A  215  GLU VAL SER ARG VAL LEU VAL PRO GLY GLY ARG PHE ILE          
SEQRES  13 A  215  SER MET THR SER ALA ALA PRO HIS PHE ARG THR ARG HIS          
SEQRES  14 A  215  TYR ALA GLN ALA TYR TYR GLY TRP SER LEU ARG HIS ALA          
SEQRES  15 A  215  THR TYR GLY SER GLY PHE HIS PHE HIS LEU TYR LEU MET          
SEQRES  16 A  215  HIS LYS GLY GLY LYS LEU SER VAL ALA GLN LEU ALA LEU          
SEQRES  17 A  215  GLY ALA GLN ILE LEU SER PRO                                  
HET    UNX  A 300       1                                                       
HET    SAH  A 301      26                                                       
HETNAM     UNX UNKNOWN ATOM OR ION                                              
HETNAM     SAH S-ADENOSYL-L-HOMOCYSTEINE                                        
FORMUL   2  UNX    X1                                                           
FORMUL   3  SAH    C14 H20 N6 O5 S                                              
FORMUL   4  HOH   *135(H2 O)                                                    
CRYST1   35.883   45.560   55.102  90.00 105.87  90.00 P 1 21 1      2          
ATOM      1  N   GLY A  17      13.224  -0.686  26.599  1.00 13.29           N  
ATOM      2  CA  GLY A  17      13.666  -2.094  26.554  1.00 12.16           C  
ATOM      3  C   GLY A  17      12.700  -2.987  25.821  1.00 11.87           C  
ATOM      4  O   GLY A  17      11.765  -2.504  25.163  1.00  9.35           O  
ATOM      5  N   SER A  18      12.902  -4.307  25.943  1.00 10.54           N  
ATOM      6  CA  SER A  18      12.124  -5.265  25.164  1.00 10.92           C  
ATOM      7  C   SER A  18      10.644  -5.318  25.578  1.00  9.64           C  
ATOM      8  O   SER A  18       9.806  -5.849  24.828  1.00 10.44           O  
ATOM      9  CB  SER A  18      12.781  -6.653  25.186  1.00 13.53           C  
ATOM     10  OG  SER A  18      12.704  -7.248  26.446  1.00 16.42           O  
ATOM     11  N   GLY A  19      10.303  -4.739  26.735  1.00 10.29           N  
ATOM     12  CA  GLY A  19       8.909  -4.656  27.157  1.00  7.12           C  
ATOM     13  C   GLY A  19       8.027  -3.846  26.181  1.00  7.17           C  
ATOM     14  O   GLY A  19       6.809  -4.028  26.122  1.00  9.17           O  
ATOM     15  N   TYR A  20       8.642  -2.990  25.376  1.00  6.80           N  
ATOM     16  CA  TYR A  20       7.887  -2.217  24.380  1.00  6.39           C  
ATOM     17  C   TYR A  20       7.316  -3.055  23.247  1.00  4.95           C  
ATOM     18  O   TYR A  20       6.535  -2.575  22.440  1.00  6.63           O  
ATOM     19  CB  TYR A  20       8.735  -1.119  23.741  1.00  7.55           C  
ATOM     20  CG  TYR A  20       9.082   0.077  24.603  1.00  8.08           C  
ATOM     21  CD1 TYR A  20       8.115   0.755  25.330  1.00 10.02           C  
ATOM     22  CD2 TYR A  20      10.404   0.577  24.635  1.00  7.75           C  
ATOM     23  CE1 TYR A  20       8.461   1.890  26.098  1.00  8.78           C  
ATOM     24  CE2 TYR A  20      10.752   1.671  25.396  1.00 10.48           C  
ATOM     25  CZ  TYR A  20       9.787   2.327  26.115  1.00  9.20           C  
ATOM     26  OH  TYR A  20      10.095   3.419  26.889  1.00 10.43           O  
ATOM     27  N   ARG A  21       7.714  -4.308  23.157  1.00  5.95           N  
ATOM     28  CA  ARG A  21       7.184  -5.192  22.137  1.00  6.16           C  
ATOM     29  C   ARG A  21       5.764  -5.692  22.455  1.00  6.27           C  
ATOM     30  O   ARG A  21       5.035  -6.078  21.548  1.00  5.80           O  
ATOM     31  CB  ARG A  21       8.087  -6.434  21.926  1.00  7.40           C  
ATOM     32  CG  ARG A  21       9.446  -6.139  21.279  1.00  6.67           C  
ATOM     33  CD  ARG A  21      10.035  -7.352  20.612  1.00 12.15           C  
ATOM     34  N   GLU A  22       5.374  -5.685  23.745  1.00  6.16           N  
ATOM     35  CA  GLU A  22       4.186  -6.382  24.207  1.00  7.42           C  
ATOM     36  C   GLU A  22       2.993  -5.444  24.358  1.00  5.01           C  
ATOM     37  O   GLU A  22       3.087  -4.357  24.980  1.00  6.74           O  
ATOM     38  CB  GLU A  22       4.465  -7.087  25.553  1.00  7.92           C  
ATOM     39  CG  GLU A  22       5.822  -7.896  25.641  1.00 10.72           C  
ATOM     40  CD  GLU A  22       5.949  -9.002  24.641  1.00 11.28           C  
ATOM     41  OE1 GLU A  22       4.918  -9.485  24.160  1.00 12.25           O  
ATOM     42  OE2 GLU A  22       7.143  -9.417  24.329  1.00 13.53           O  
ATOM     43  N   VAL A  23       1.855  -5.875  23.833  1.00  5.47           N  
ATOM     44  CA  VAL A  23       0.629  -5.084  23.907  1.00  4.63           C  
ATOM     45  C   VAL A  23       0.234  -4.784  25.351  1.00  4.05           C  
ATOM     46  O   VAL A  23      -0.356  -3.730  25.613  1.00  5.06           O  
ATOM     47  CB  VAL A  23      -0.556  -5.763  23.080  1.00  5.86           C  
ATOM     48  CG1 VAL A  23      -0.986  -7.093  23.709  1.00  8.17           C  
ATOM     49  CG2 VAL A  23      -1.708  -4.848  22.972  1.00  6.18           C  
ATOM     50  N   GLU A  24       0.546  -5.660  26.288  1.00  6.01           N  
ATOM     51  CA  GLU A  24       0.127  -5.420  27.682  1.00  5.68           C  
ATOM     52  C   GLU A  24       0.744  -4.129  28.226  1.00  5.01           C  
ATOM     53  O   GLU A  24       0.103  -3.433  29.004  1.00  4.94           O  
ATOM     54  CB  GLU A  24       0.523  -6.582  28.602  1.00  6.78           C  
ATOM     55  CG  GLU A  24      -0.293  -7.870  28.366  1.00  6.69           C  
ATOM     56  CD  GLU A  24       0.264  -8.764  27.291  1.00  6.29           C  
ATOM     57  OE1 GLU A  24       1.190  -8.371  26.552  1.00  6.54           O  
ATOM     58  OE2 GLU A  24      -0.253  -9.903  27.206  1.00  8.80           O  
ATOM     59  N   TYR A  25       1.968  -3.837  27.827  1.00  4.74           N  
ATOM     60  CA  TYR A  25       2.639  -2.618  28.261  1.00  5.03           C  
ATOM     61  C   TYR A  25       1.884  -1.391  27.732  1.00  4.57           C  
ATOM     62  O   TYR A  25       1.629  -0.453  28.480  1.00  4.65           O  
ATOM     63  CB  TYR A  25       4.118  -2.560  27.762  1.00  5.57           C  
ATOM     64  CG  TYR A  25       4.637  -1.161  27.878  1.00  7.27           C  
ATOM     65  CD1 TYR A  25       5.084  -0.662  29.100  1.00  5.50           C  
ATOM     66  CD2 TYR A  25       4.583  -0.306  26.798  1.00  5.51           C  
ATOM     67  CE1 TYR A  25       5.465   0.629  29.231  1.00  6.67           C  
ATOM     68  CE2 TYR A  25       4.974   0.998  26.905  1.00  5.22           C  
ATOM     69  CZ  TYR A  25       5.416   1.471  28.124  1.00  5.86           C  
ATOM     70  OH  TYR A  25       5.770   2.794  28.208  1.00  6.16           O  
ATOM     71  N   TRP A  26       1.511  -1.407  26.439  1.00  4.15           N  
ATOM     72  CA  TRP A  26       0.829  -0.300  25.819  1.00  5.01           C  
ATOM     73  C   TRP A  26      -0.579  -0.131  26.350  1.00  3.64           C  
ATOM     74  O   TRP A  26      -0.977   0.982  26.642  1.00  5.28           O  
ATOM     75  CB  TRP A  26       0.863  -0.455  24.316  1.00  4.22           C  
ATOM     76  CG  TRP A  26       2.262  -0.436  23.771  1.00  5.40           C  
ATOM     77  CD1 TRP A  26       3.012  -1.508  23.364  1.00  5.43           C  
ATOM     78  CD2 TRP A  26       3.120   0.722  23.646  1.00  2.69           C  
ATOM     79  NE1 TRP A  26       4.274  -1.081  22.979  1.00  6.57           N  
ATOM     80  CE2 TRP A  26       4.371   0.280  23.146  1.00  4.97           C  
ATOM     81  CE3 TRP A  26       2.949   2.075  23.905  1.00  4.75           C  
ATOM     82  CZ2 TRP A  26       5.448   1.187  22.893  1.00  5.71           C  
ATOM     83  CZ3 TRP A  26       4.016   2.943  23.659  1.00  6.85           C  
ATOM     84  CH2 TRP A  26       5.234   2.482  23.157  1.00  4.66           C  
ATOM     85  N   ASP A  27      -1.322  -1.228  26.528  1.00  4.60           N  
ATOM     86  CA  ASP A  27      -2.674  -1.136  27.100  1.00  5.02           C  
ATOM     87  C   ASP A  27      -2.629  -0.505  28.508  1.00  6.82           C  
ATOM     88  O   ASP A  27      -3.514   0.297  28.843  1.00  5.16           O  
ATOM     89  CB  ASP A  27      -3.359  -2.512  27.152  1.00  5.10           C  
ATOM     90  CG  ASP A  27      -4.089  -2.881  25.853  1.00  7.60           C  
ATOM     91  OD1 ASP A  27      -4.333  -2.007  25.012  1.00  6.66           O  
ATOM     92  OD2 ASP A  27      -4.460  -4.086  25.719  1.00  7.78           O  
ATOM     93  N   GLN A  28      -1.609  -0.856  29.307  1.00  5.16           N  
ATOM     94  CA  GLN A  28      -1.410  -0.242  30.604  1.00  6.45           C  
ATOM     95  C   GLN A  28      -1.061   1.280  30.471  1.00  5.66           C  
ATOM     96  O   GLN A  28      -1.634   2.142  31.167  1.00  6.02           O  
ATOM     97  CB  GLN A  28      -0.282  -0.983  31.325  1.00  9.08           C  
ATOM     98  CG  GLN A  28       0.122  -0.470  32.711  1.00 11.29           C  
ATOM     99  CD  GLN A  28       1.353  -1.204  33.238  1.00 12.20           C  
ATOM    100  OE1 GLN A  28       2.493  -0.941  32.817  1.00 16.63           O  
ATOM    101  NE2 GLN A  28       1.134  -2.085  34.163  1.00 16.09           N  
ATOM    102  N   ARG A  29      -0.118   1.592  29.589  1.00  4.65           N  
ATOM    103  CA  ARG A  29       0.304   2.986  29.348  1.00  4.79           C  
ATOM    104  C   ARG A  29      -0.867   3.872  28.931  1.00  5.29           C  
ATOM    105  O   ARG A  29      -0.958   5.071  29.315  1.00  6.35           O  
ATOM    106  CB  ARG A  29       1.384   3.031  28.284  1.00  5.12           C  
ATOM    107  CG  ARG A  29       1.893   4.421  27.939  1.00  4.69           C  
ATOM    108  CD  ARG A  29       2.878   4.295  26.870  1.00  6.95           C  
ATOM    109  NE  ARG A  29       3.315   5.558  26.301  1.00  6.55           N  
ATOM    110  CZ  ARG A  29       4.575   5.998  26.316  1.00  5.25           C  
ATOM    111  NH1 ARG A  29       5.555   5.266  26.836  1.00  6.44           N  
ATOM    112  NH2 ARG A  29       4.864   7.144  25.728  1.00  5.46           N  
ATOM    113  N   TYR A  30      -1.767   3.326  28.139  1.00  6.05           N  
ATOM    114  CA  TYR A  30      -2.799   4.124  27.511  1.00  6.18           C  
ATOM    115  C   TYR A  30      -4.117   4.190  28.285  1.00  5.07           C  
ATOM    116  O   TYR A  30      -5.066   4.786  27.807  1.00  6.45           O  
ATOM    117  CB  TYR A  30      -3.057   3.635  26.082  1.00  4.18           C  
ATOM    118  CG  TYR A  30      -1.907   3.871  25.088  1.00  4.29           C  
ATOM    119  CD1 TYR A  30      -1.258   5.082  25.038  1.00  4.38           C  
ATOM    120  CD2 TYR A  30      -1.534   2.885  24.166  1.00  4.21           C  
ATOM    121  CE1 TYR A  30      -0.260   5.343  24.106  1.00  5.04           C  
ATOM    122  CE2 TYR A  30      -0.534   3.090  23.235  1.00  4.30           C  
ATOM    123  CZ  TYR A  30       0.121   4.337  23.208  1.00  4.12           C  
ATOM    124  OH  TYR A  30       1.126   4.608  22.284  1.00  4.29           O  
ATOM    125  N   GLN A  31      -4.160   3.646  29.499  1.00  6.53           N  
ATOM    126  CA  GLN A  31      -5.346   3.873  30.343  1.00  7.50           C  
ATOM    127  C   GLN A  31      -5.498   5.395  30.539  1.00  9.09           C  
ATOM    128  O   GLN A  31      -4.526   6.062  30.826  1.00 11.57           O  
ATOM    129  CB  GLN A  31      -5.169   3.215  31.708  1.00  8.86           C  
ATOM    130  CG  GLN A  31      -5.077   1.703  31.684  1.00 11.69           C  
ATOM    131  CD  GLN A  31      -6.323   1.032  31.144  1.00 13.93           C  
ATOM    132  OE1 GLN A  31      -7.445   1.464  31.415  1.00 17.45           O  
ATOM    133  NE2 GLN A  31      -6.126  -0.037  30.376  1.00 11.30           N  
ATOM    134  N   GLY A  32      -6.698   5.926  30.347  1.00 13.51           N  
ATOM    135  CA  GLY A  32      -6.947   7.366  30.497  1.00 11.51           C  
ATOM    136  C   GLY A  32      -6.472   8.267  29.346  1.00 10.14           C  
ATOM    137  O   GLY A  32      -6.491   9.514  29.472  1.00 12.68           O  
ATOM    138  N   ALA A  33      -6.047   7.663  28.222  1.00 11.12           N  
ATOM    139  CA  ALA A  33      -5.442   8.447  27.128  1.00  9.50           C  
ATOM    140  C   ALA A  33      -6.458   9.430  26.483  1.00 10.67           C  
ATOM    141  O   ALA A  33      -6.048  10.397  25.874  1.00  9.92           O  
ATOM    142  CB  ALA A  33      -4.822   7.511  26.072  1.00  9.35           C  
ATOM    143  N   ALA A  34      -7.768   9.210  26.626  1.00  8.93           N  
ATOM    144  CA  ALA A  34      -8.729  10.124  26.024  1.00  9.25           C  
ATOM    145  C   ALA A  34      -8.666  11.522  26.677  1.00 13.09           C  
ATOM    146  O   ALA A  34      -8.858  12.558  25.993  1.00 16.24           O  
ATOM    147  CB  ALA A  34     -10.148   9.566  26.085  1.00 14.51           C  
ATOM    148  N   ASP A  35      -8.328  11.548  27.975  1.00 13.56           N  
ATOM    149  CA  ASP A  35      -8.281  12.785  28.769  1.00 14.89           C  
ATOM    150  C   ASP A  35      -6.877  13.403  28.906  1.00 16.62           C  
ATOM    151  O   ASP A  35      -6.761  14.575  29.208  1.00 16.95           O  
ATOM    152  CB  ASP A  35      -8.826  12.517  30.171  1.00 18.19           C  
ATOM    153  CG  ASP A  35     -10.200  11.891  30.154  1.00 21.50           C  
ATOM    154  OD1 ASP A  35     -11.035  12.296  29.304  1.00 23.51           O  
ATOM    155  OD2 ASP A  35     -10.445  10.989  30.997  1.00 25.48           O  
ATOM    156  N   SER A  36      -5.832  12.607  28.714  1.00 13.14           N  
ATOM    157  CA  SER A  36      -4.451  13.065  28.855  0.50 14.45           C  
ATOM    159  C   SER A  36      -4.028  13.829  27.604  1.00 12.76           C  
ATOM    160  O   SER A  36      -4.667  13.710  26.554  1.00 13.49           O  
ATOM    161  CB  SER A  36      -3.505  11.866  29.068  0.50 16.00           C  
ATOM    163  OG  SER A  36      -3.978  10.997  30.087  0.50 18.72           O  
ATOM    165  N   ALA A  37      -2.950  14.586  27.710  1.00 11.57           N  
ATOM    166  CA  ALA A  37      -2.386  15.303  26.555  1.00 10.84           C  
ATOM    167  C   ALA A  37      -1.937  14.287  25.492  1.00 11.07           C  
ATOM    168  O   ALA A  37      -1.508  13.201  25.834  1.00  9.57           O  
ATOM    169  CB  ALA A  37      -1.204  16.131  26.989  1.00 10.50           C  
ATOM    170  N   PRO A  38      -2.051  14.638  24.193  1.00  8.99           N  
ATOM    171  CA  PRO A  38      -1.399  13.809  23.145  1.00  9.28           C  
ATOM    172  C   PRO A  38       0.061  13.637  23.453  1.00  9.56           C  
ATOM    173  O   PRO A  38       0.622  14.461  24.145  1.00  8.35           O  
ATOM    174  CB  PRO A  38      -1.568  14.650  21.869  1.00  7.34           C  
ATOM    175  CG  PRO A  38      -2.781  15.503  22.146  1.00  8.92           C  
ATOM    176  CD  PRO A  38      -2.766  15.793  23.611  1.00  9.25           C  
ATOM    177  N   TYR A  39       0.665  12.547  22.981  1.00  6.18           N  
ATOM    178  CA  TYR A  39       2.086  12.313  23.143  1.00  5.46           C  
ATOM    179  C   TYR A  39       2.640  11.832  21.822  1.00  4.00           C  
ATOM    180  O   TYR A  39       2.036  10.968  21.180  1.00  5.04           O  
ATOM    181  CB  TYR A  39       2.395  11.255  24.222  1.00  6.90           C  
ATOM    182  CG  TYR A  39       3.867  11.129  24.401  1.00  7.06           C  
ATOM    183  CD1 TYR A  39       4.571  12.104  25.101  1.00  7.31           C  
ATOM    184  CD2 TYR A  39       4.579  10.104  23.797  1.00  6.61           C  
ATOM    185  CE1 TYR A  39       5.963  12.040  25.226  1.00  7.99           C  
ATOM    186  CE2 TYR A  39       5.968  10.020  23.919  1.00  7.75           C  
ATOM    187  CZ  TYR A  39       6.650  10.994  24.637  1.00  9.92           C  
ATOM    188  OH  TYR A  39       8.029  10.937  24.770  1.00  9.80           O  
ATOM    189  N   ASP A  40       3.783  12.393  21.412  1.00  5.65           N  
ATOM    190  CA  ASP A  40       4.422  12.030  20.165  1.00  5.72           C  
ATOM    191  C   ASP A  40       5.877  11.592  20.364  1.00  6.43           C  
ATOM    192  O   ASP A  40       6.688  12.327  20.935  1.00  7.60           O  
ATOM    193  CB  ASP A  40       4.371  13.222  19.213  1.00  5.01           C  
ATOM    194  CG  ASP A  40       3.115  13.248  18.409  1.00  4.67           C  
ATOM    195  OD1 ASP A  40       3.114  12.684  17.302  1.00  6.31           O  
ATOM    196  OD2 ASP A  40       2.106  13.776  18.908  1.00  6.13           O  
ATOM    197  N   TRP A  41       6.180  10.381  19.901  1.00  4.86           N  
ATOM    198  CA  TRP A  41       7.567   9.871  19.813  1.00  5.16           C  
ATOM    199  C   TRP A  41       8.311  10.428  18.622  1.00  4.83           C  
ATOM    200  O   TRP A  41       7.750  10.577  17.566  1.00  5.04           O  
ATOM    201  CB  TRP A  41       7.567   8.352  19.663  1.00  6.14           C  
ATOM    202  CG  TRP A  41       7.118   7.597  20.850  1.00  6.09           C  
ATOM    203  CD1 TRP A  41       5.842   7.458  21.321  1.00  5.97           C  
ATOM    204  CD2 TRP A  41       7.958   6.851  21.748  1.00  7.43           C  
ATOM    205  NE1 TRP A  41       5.840   6.680  22.449  1.00  6.09           N  
ATOM    206  CE2 TRP A  41       7.116   6.284  22.729  1.00  6.11           C  
ATOM    207  CE3 TRP A  41       9.335   6.592  21.810  1.00  8.57           C  
ATOM    208  CZ2 TRP A  41       7.614   5.472  23.783  1.00  7.05           C  
ATOM    209  CZ3 TRP A  41       9.824   5.790  22.850  1.00  8.55           C  
ATOM    210  CH2 TRP A  41       8.968   5.249  23.822  1.00  7.00           C  
ATOM    211  N   PHE A  42       9.579  10.765  18.819  1.00  6.41           N  
ATOM    212  CA  PHE A  42      10.472  11.148  17.712  1.00  7.14           C  
ATOM    213  C   PHE A  42       9.915  12.331  16.955  1.00  7.64           C  
ATOM    214  O   PHE A  42       9.921  12.382  15.695  1.00 10.24           O  
ATOM    215  CB  PHE A  42      10.731   9.959  16.780  1.00  9.16           C  
ATOM    216  CG  PHE A  42      11.142   8.710  17.503  1.00  7.98           C  
ATOM    217  CD1 PHE A  42      12.137   8.746  18.492  1.00  8.61           C  
ATOM    218  CD2 PHE A  42      10.537   7.500  17.229  1.00  8.62           C  
ATOM    219  CE1 PHE A  42      12.510   7.573  19.164  1.00  8.56           C  
ATOM    220  CE2 PHE A  42      10.915   6.334  17.912  1.00 10.82           C  
ATOM    221  CZ  PHE A  42      11.873   6.376  18.869  1.00  9.39           C  
ATOM    222  N   GLY A  43       9.452  13.284  17.720  1.00  8.05           N  
ATOM    223  CA  GLY A  43       8.959  14.527  17.173  1.00  8.92           C  
ATOM    224  C   GLY A  43       7.465  14.539  16.913  1.00  9.39           C  
ATOM    225  O   GLY A  43       6.877  13.525  16.612  1.00  8.06           O  
ATOM    226  N   ASP A  44       6.856  15.704  17.073  1.00  9.74           N  
ATOM    227  CA  ASP A  44       5.499  15.946  16.579  1.00 12.17           C  
ATOM    228  C   ASP A  44       5.522  16.437  15.114  1.00  8.83           C  
ATOM    229  O   ASP A  44       6.616  16.748  14.529  1.00  9.95           O  
ATOM    230  CB  ASP A  44       4.789  16.985  17.443  1.00 15.72           C  
ATOM    231  CG  ASP A  44       5.432  18.311  17.353  1.00 19.19           C  
ATOM    232  OD1 ASP A  44       6.439  18.531  18.071  1.00 24.02           O  
ATOM    233  OD2 ASP A  44       4.949  19.140  16.560  1.00 22.24           O  
ATOM    234  N   PHE A  45       4.317  16.552  14.542  1.00 11.45           N  
ATOM    235  CA  PHE A  45       4.121  16.981  13.147  1.00 10.68           C  
ATOM    236  C   PHE A  45       4.972  18.212  12.760  1.00 10.91           C  
ATOM    237  O   PHE A  45       5.483  18.281  11.653  1.00 11.19           O  
ATOM    238  CB  PHE A  45       2.627  17.273  12.902  1.00 12.61           C  
ATOM    239  CG  PHE A  45       2.246  17.464  11.441  1.00 14.31           C  
ATOM    240  CD1 PHE A  45       2.475  16.459  10.504  1.00 15.69           C  
ATOM    241  CD2 PHE A  45       1.585  18.628  11.020  1.00 14.86           C  
ATOM    242  CE1 PHE A  45       2.088  16.625   9.156  1.00 16.08           C  
ATOM    243  CE2 PHE A  45       1.210  18.795   9.698  1.00 15.46           C  
ATOM    244  CZ  PHE A  45       1.451  17.772   8.765  1.00 15.54           C  
ATOM    245  N   SER A  46       5.107  19.184  13.670  1.00  8.75           N  
ATOM    246  CA  SER A  46       5.877  20.414  13.382  1.00 11.75           C  
ATOM    247  C   SER A  46       7.332  20.133  12.971  1.00 10.10           C  
ATOM    248  O   SER A  46       7.898  20.856  12.138  1.00 12.18           O  
ATOM    249  CB  SER A  46       5.831  21.368  14.593  1.00 12.13           C  
ATOM    250  OG  SER A  46       6.539  20.856  15.711  1.00 13.60           O  
ATOM    251  N   SER A  47       7.918  19.071  13.532  1.00  9.01           N  
ATOM    252  CA  SER A  47       9.329  18.730  13.357  0.50 11.17           C  
ATOM    254  C   SER A  47       9.633  18.187  11.975  1.00  8.99           C  
ATOM    255  O   SER A  47      10.777  18.257  11.523  1.00 10.96           O  
ATOM    256  CB  SER A  47       9.758  17.657  14.382  0.50 12.66           C  
ATOM    258  OG  SER A  47       9.582  18.101  15.706  0.50 16.53           O  
ATOM    260  N   PHE A  48       8.627  17.591  11.311  1.00  6.77           N  
ATOM    261  CA  PHE A  48       8.888  16.933   9.998  1.00  7.23           C  
ATOM    262  C   PHE A  48       7.866  17.259   8.919  1.00  9.94           C  
ATOM    263  O   PHE A  48       7.948  16.702   7.826  1.00  9.10           O  
ATOM    264  CB  PHE A  48       9.007  15.402  10.164  1.00  7.68           C  
ATOM    265  CG  PHE A  48       7.816  14.763  10.858  1.00  7.44           C  
ATOM    266  CD1 PHE A  48       7.857  14.470  12.236  1.00  6.34           C  
ATOM    267  CD2 PHE A  48       6.661  14.464  10.162  1.00  8.71           C  
ATOM    268  CE1 PHE A  48       6.772  13.912  12.875  1.00  7.68           C  
ATOM    269  CE2 PHE A  48       5.570  13.883  10.810  1.00  8.65           C  
ATOM    270  CZ  PHE A  48       5.646  13.605  12.183  1.00  8.98           C  
ATOM    271  N   ARG A  49       6.929  18.172   9.185  1.00  9.85           N  
ATOM    272  CA  ARG A  49       5.889  18.481   8.175  1.00 10.09           C  
ATOM    273  C   ARG A  49       6.478  19.121   6.893  1.00 12.41           C  
ATOM    274  O   ARG A  49       5.934  18.952   5.823  1.00 11.14           O  
ATOM    275  CB  ARG A  49       4.777  19.354   8.760  1.00 13.72           C  
ATOM    276  CG  ARG A  49       5.211  20.709   9.204  1.00 11.82           C  
ATOM    277  N   ALA A  50       7.584  19.852   7.018  1.00 10.07           N  
ATOM    278  CA  ALA A  50       8.289  20.387   5.815  1.00 10.48           C  
ATOM    279  C   ALA A  50       8.766  19.272   4.881  1.00 10.64           C  
ATOM    280  O   ALA A  50       8.759  19.439   3.656  1.00  9.18           O  
ATOM    281  CB  ALA A  50       9.470  21.245   6.230  1.00 12.37           C  
ATOM    282  N   LEU A  51       9.194  18.154   5.459  1.00  9.89           N  
ATOM    283  CA  LEU A  51       9.567  16.966   4.683  1.00  9.27           C  
ATOM    284  C   LEU A  51       8.355  16.180   4.210  1.00  9.88           C  
ATOM    285  O   LEU A  51       8.353  15.662   3.093  1.00 11.20           O  
ATOM    286  CB  LEU A  51      10.475  16.024   5.506  1.00  9.98           C  
ATOM    287  CG  LEU A  51      11.844  16.543   5.866  1.00 11.46           C  
ATOM    288  CD1 LEU A  51      12.515  15.639   6.866  1.00 13.24           C  
ATOM    289  CD2 LEU A  51      12.680  16.676   4.593  1.00 13.33           C  
ATOM    290  N   LEU A  52       7.335  16.065   5.071  1.00  8.52           N  
ATOM    291  CA  LEU A  52       6.205  15.211   4.789  1.00  8.22           C  
ATOM    292  C   LEU A  52       5.186  15.820   3.852  1.00  8.38           C  
ATOM    293  O   LEU A  52       4.736  15.170   2.933  1.00  9.84           O  
ATOM    294  CB  LEU A  52       5.533  14.791   6.117  1.00 10.10           C  
ATOM    295  CG  LEU A  52       4.288  13.899   5.994  1.00  9.49           C  
ATOM    296  CD1 LEU A  52       4.565  12.673   5.166  1.00 10.87           C  
ATOM    297  CD2 LEU A  52       3.800  13.466   7.379  1.00 10.27           C  
ATOM    298  N   GLU A  53       4.781  17.068   4.096  1.00  7.80           N  
ATOM    299  CA  GLU A  53       3.648  17.592   3.332  1.00 11.13           C  
ATOM    300  C   GLU A  53       3.878  17.642   1.807  1.00  7.03           C  
ATOM    301  O   GLU A  53       2.925  17.368   1.052  1.00  8.97           O  
ATOM    302  CB  GLU A  53       3.137  18.925   3.893  1.00 13.70           C  
ATOM    303  CG  GLU A  53       2.398  18.738   5.243  1.00 17.38           C  
ATOM    304  CD  GLU A  53       1.534  19.929   5.650  1.00 18.41           C  
ATOM    305  OE1 GLU A  53       0.901  20.551   4.776  1.00 19.44           O  
ATOM    306  OE2 GLU A  53       1.481  20.227   6.864  1.00 23.64           O  
ATOM    307  N   PRO A  54       5.113  17.954   1.339  1.00 10.32           N  
ATOM    308  CA  PRO A  54       5.323  17.931  -0.129  1.00  9.47           C  
ATOM    309  C   PRO A  54       5.176  16.551  -0.760  1.00 11.14           C  
ATOM    310  O   PRO A  54       5.145  16.450  -1.989  1.00  9.85           O  
ATOM    311  CB  PRO A  54       6.769  18.456  -0.294  1.00  9.39           C  
ATOM    312  CG  PRO A  54       7.062  19.168   0.940  1.00 10.82           C  
ATOM    313  CD  PRO A  54       6.324  18.430   2.031  1.00  9.19           C  
ATOM    314  N   GLU A  55       5.056  15.508   0.058  1.00  9.31           N  
ATOM    315  CA  GLU A  55       4.885  14.144  -0.469  1.00  9.77           C  
ATOM    316  C   GLU A  55       3.414  13.700  -0.457  1.00 10.23           C  
ATOM    317  O   GLU A  55       3.107  12.602  -0.904  1.00 11.77           O  
ATOM    318  CB  GLU A  55       5.765  13.168   0.309  1.00  9.86           C  
ATOM    319  CG  GLU A  55       7.233  13.644   0.437  1.00 11.16           C  
ATOM    320  CD  GLU A  55       7.998  13.704  -0.904  1.00 12.50           C  
ATOM    321  OE1 GLU A  55       7.661  12.952  -1.838  1.00 13.16           O  
ATOM    322  OE2 GLU A  55       8.966  14.485  -0.997  1.00 12.99           O  
ATOM    323  N   LEU A  56       2.520  14.563   0.020  1.00  7.35           N  
ATOM    324  CA  LEU A  56       1.119  14.242   0.203  1.00  9.39           C  
ATOM    325  C   LEU A  56       0.220  15.071  -0.720  1.00 11.69           C  
ATOM    326  O   LEU A  56       0.590  16.181  -1.143  1.00 12.96           O  
ATOM    327  CB  LEU A  56       0.702  14.502   1.659  1.00 10.90           C  
ATOM    328  CG  LEU A  56       1.457  13.817   2.788  1.00  8.80           C  
ATOM    329  CD1 LEU A  56       0.912  14.301   4.141  1.00 11.89           C  
ATOM    330  CD2 LEU A  56       1.343  12.272   2.678  1.00 13.37           C  
ATOM    331  N   ARG A  57      -0.956  14.524  -1.022  1.00 10.29           N  
ATOM    332  CA  ARG A  57      -2.004  15.213  -1.777  1.00 13.73           C  
ATOM    333  C   ARG A  57      -3.240  15.247  -0.906  1.00 10.39           C  
ATOM    334  O   ARG A  57      -3.492  14.273  -0.154  1.00  7.38           O  
ATOM    335  CB  ARG A  57      -2.338  14.452  -3.051  1.00 15.47           C  
ATOM    336  CG  ARG A  57      -1.129  14.072  -3.910  1.00 17.97           C  
ATOM    337  CD  ARG A  57      -1.544  13.230  -5.112  1.00 20.98           C  
ATOM    338  NE  ARG A  57      -2.280  12.029  -4.701  1.00 23.68           N  
ATOM    339  CZ  ARG A  57      -3.471  11.644  -5.182  1.00 24.96           C  
ATOM    340  NH1 ARG A  57      -4.086  12.325  -6.157  1.00 28.04           N  
ATOM    341  NH2 ARG A  57      -4.048  10.538  -4.703  1.00 25.23           N  
ATOM    342  N   PRO A  58      -4.049  16.313  -0.990  1.00 10.21           N  
ATOM    343  CA  PRO A  58      -5.217  16.413  -0.125  1.00 10.15           C  
ATOM    344  C   PRO A  58      -6.161  15.195  -0.246  1.00  7.31           C  
ATOM    345  O   PRO A  58      -6.821  14.828   0.731  1.00  8.94           O  
ATOM    346  CB  PRO A  58      -5.932  17.705  -0.610  1.00 10.63           C  
ATOM    347  CG  PRO A  58      -4.997  18.413  -1.481  1.00 14.60           C  
ATOM    348  CD  PRO A  58      -3.895  17.482  -1.891  1.00 12.08           C  
ATOM    349  N   GLU A  59      -6.231  14.599  -1.440  1.00  9.29           N  
ATOM    350  CA  GLU A  59      -7.120  13.459  -1.684  1.00  8.84           C  
ATOM    351  C   GLU A  59      -6.516  12.112  -1.278  1.00  9.20           C  
ATOM    352  O   GLU A  59      -7.191  11.098  -1.367  1.00 10.13           O  
ATOM    353  CB  GLU A  59      -7.553  13.380  -3.155  1.00 11.84           C  
ATOM    354  CG  GLU A  59      -6.447  13.141  -4.121  1.00 14.70           C  
ATOM    355  CD  GLU A  59      -5.986  14.411  -4.783  1.00 17.71           C  
ATOM    356  OE1 GLU A  59      -5.561  15.360  -4.066  1.00 15.77           O  
ATOM    357  OE2 GLU A  59      -6.045  14.464  -6.032  1.00 21.24           O  
ATOM    358  N   ASP A  60      -5.253  12.106  -0.828  1.00  7.08           N  
ATOM    359  CA  ASP A  60      -4.585  10.832  -0.477  1.00  8.14           C  
ATOM    360  C   ASP A  60      -5.339  10.089   0.637  1.00  7.19           C  
ATOM    361  O   ASP A  60      -5.739  10.676   1.638  1.00  6.73           O  
ATOM    362  CB  ASP A  60      -3.152  11.065  -0.011  1.00  7.19           C  
ATOM    363  CG  ASP A  60      -2.164  11.202  -1.131  1.00  8.57           C  
ATOM    364  OD1 ASP A  60      -2.456  10.756  -2.252  1.00  9.78           O  
ATOM    365  OD2 ASP A  60      -1.061  11.696  -0.838  1.00  8.49           O  
ATOM    366  N   ARG A  61      -5.532   8.789   0.429  1.00  6.43           N  
ATOM    367  CA  ARG A  61      -5.990   7.880   1.468  1.00  7.94           C  
ATOM    368  C   ARG A  61      -4.787   7.457   2.281  1.00  5.94           C  
ATOM    369  O   ARG A  61      -3.900   6.800   1.763  1.00  5.26           O  
ATOM    370  CB  ARG A  61      -6.690   6.691   0.849  1.00  6.05           C  
ATOM    371  CG  ARG A  61      -7.972   7.050   0.116  1.00  8.75           C  
ATOM    372  CD  ARG A  61      -8.434   5.920  -0.758  1.00  9.82           C  
ATOM    373  NE  ARG A  61      -7.437   5.598  -1.775  1.00 10.06           N  
ATOM    374  CZ  ARG A  61      -7.526   4.535  -2.597  1.00 13.03           C  
ATOM    375  NH1 ARG A  61      -8.563   3.712  -2.531  1.00 14.21           N  
ATOM    376  NH2 ARG A  61      -6.584   4.310  -3.489  1.00 15.97           N  
ATOM    377  N   ILE A  62      -4.753   7.873   3.551  1.00  6.23           N  
ATOM    378  CA  ILE A  62      -3.576   7.746   4.409  1.00  5.91           C  
ATOM    379  C   ILE A  62      -3.878   6.754   5.552  1.00  4.85           C  
ATOM    380  O   ILE A  62      -4.936   6.841   6.198  1.00  6.32           O  
ATOM    381  CB  ILE A  62      -3.200   9.119   5.035  1.00  5.52           C  
ATOM    382  CG1 ILE A  62      -2.852  10.144   3.957  1.00  7.31           C  
ATOM    383  CG2 ILE A  62      -2.012   8.967   5.997  1.00  5.97           C  
ATOM    384  CD1 ILE A  62      -2.756  11.636   4.491  1.00  5.58           C  
ATOM    385  N   LEU A  63      -2.952   5.813   5.765  1.00  4.22           N  
ATOM    386  CA  LEU A  63      -3.014   4.833   6.849  1.00  4.22           C  
ATOM    387  C   LEU A  63      -1.841   5.116   7.794  1.00  3.97           C  
ATOM    388  O   LEU A  63      -0.687   5.150   7.350  1.00  5.63           O  
ATOM    389  CB  LEU A  63      -2.891   3.406   6.317  1.00  4.49           C  
ATOM    390  CG  LEU A  63      -2.802   2.332   7.391  1.00  4.30           C  
ATOM    391  CD1 LEU A  63      -4.081   2.282   8.271  1.00  5.91           C  
ATOM    392  CD2 LEU A  63      -2.514   0.993   6.758  1.00  5.27           C  
ATOM    393  N   VAL A  64      -2.139   5.316   9.086  1.00  5.13           N  
ATOM    394  CA  VAL A  64      -1.124   5.590  10.087  1.00  4.07           C  
ATOM    395  C   VAL A  64      -0.993   4.343  10.989  1.00  4.21           C  
ATOM    396  O   VAL A  64      -1.976   3.896  11.611  1.00  4.36           O  
ATOM    397  CB  VAL A  64      -1.485   6.789  10.935  1.00  3.32           C  
ATOM    398  CG1 VAL A  64      -0.434   6.997  12.065  1.00  4.93           C  
ATOM    399  CG2 VAL A  64      -1.552   7.993  10.101  1.00  4.11           C  
ATOM    400  N   LEU A  65       0.195   3.743  10.979  1.00  4.38           N  
ATOM    401  CA  LEU A  65       0.470   2.503  11.710  1.00  3.75           C  
ATOM    402  C   LEU A  65       0.932   2.773  13.135  1.00  4.82           C  
ATOM    403  O   LEU A  65       1.803   3.613  13.358  1.00  6.12           O  
ATOM    404  CB  LEU A  65       1.572   1.675  11.018  1.00  4.89           C  
ATOM    405  CG  LEU A  65       1.456   1.374   9.542  1.00  4.29           C  
ATOM    406  CD1 LEU A  65       2.665   0.570   9.113  1.00  6.81           C  
ATOM    407  CD2 LEU A  65       0.152   0.609   9.273  1.00  5.71           C  
ATOM    408  N   GLY A  66       0.386   1.996  14.100  1.00  3.83           N  
ATOM    409  CA  GLY A  66       0.745   2.111  15.493  1.00  3.23           C  
ATOM    410  C   GLY A  66       0.623   3.534  15.986  1.00  3.54           C  
ATOM    411  O   GLY A  66       1.525   4.076  16.596  1.00  4.13           O  
ATOM    412  N   CYS A  67      -0.574   4.082  15.791  1.00  4.53           N  
ATOM    413  CA  CYS A  67      -0.870   5.481  15.995  1.00  3.55           C  
ATOM    414  C   CYS A  67      -0.659   5.945  17.462  1.00  5.44           C  
ATOM    415  O   CYS A  67      -0.366   7.114  17.696  1.00  3.36           O  
ATOM    416  CB  CYS A  67      -2.280   5.764  15.516  1.00  5.69           C  
ATOM    417  SG  CYS A  67      -3.610   4.946  16.410  1.00  4.61           S  
ATOM    418  N   GLY A  68      -0.834   5.051  18.429  1.00  3.30           N  
ATOM    419  CA  GLY A  68      -0.813   5.450  19.830  1.00  4.47           C  
ATOM    420  C   GLY A  68      -1.722   6.635  20.094  1.00  3.80           C  
ATOM    421  O   GLY A  68      -2.784   6.767  19.448  1.00  4.87           O  
ATOM    422  N   ASN A  69      -1.309   7.500  21.037  1.00  4.62           N  
ATOM    423  CA  ASN A  69      -2.026   8.733  21.325  1.00  4.71           C  
ATOM    424  C   ASN A  69      -1.314   9.938  20.747  1.00  4.75           C  
ATOM    425  O   ASN A  69      -1.431  11.062  21.263  1.00  4.55           O  
ATOM    426  CB  ASN A  69      -2.308   8.907  22.833  1.00  3.78           C  
ATOM    427  CG  ASN A  69      -1.053   9.110  23.648  1.00  5.15           C  
ATOM    428  OD1 ASN A  69       0.026   8.695  23.270  1.00  5.18           O  
ATOM    429  ND2 ASN A  69      -1.204   9.736  24.805  1.00  5.99           N  
ATOM    430  N   SER A  70      -0.646   9.741  19.611  1.00  4.64           N  
ATOM    431  CA  SER A  70      -0.048  10.805  18.816  1.00  3.80           C  
ATOM    432  C   SER A  70      -1.098  11.789  18.263  1.00  5.23           C  
ATOM    433  O   SER A  70      -2.279  11.445  17.985  1.00  4.38           O  
ATOM    434  CB  SER A  70       0.744  10.169  17.673  1.00  4.07           C  
ATOM    435  OG  SER A  70       1.201  11.091  16.690  1.00  4.03           O  
ATOM    436  N   ALA A  71      -0.657  13.036  18.113  1.00  5.81           N  
ATOM    437  CA  ALA A  71      -1.481  14.080  17.500  1.00  5.49           C  
ATOM    438  C   ALA A  71      -1.315  14.106  15.962  1.00  7.49           C  
ATOM    439  O   ALA A  71      -1.951  14.916  15.308  1.00  6.38           O  
ATOM    440  CB  ALA A  71      -1.118  15.443  18.073  1.00  7.44           C  
ATOM    441  N   LEU A  72      -0.476  13.214  15.398  1.00  5.26           N  
ATOM    442  CA  LEU A  72      -0.177  13.231  13.945  1.00  5.37           C  
ATOM    443  C   LEU A  72      -1.424  13.112  13.112  1.00  6.32           C  
ATOM    444  O   LEU A  72      -1.620  13.903  12.162  1.00  6.31           O  
ATOM    445  CB  LEU A  72       0.858  12.147  13.566  1.00  6.86           C  
ATOM    446  CG  LEU A  72       1.133  11.960  12.078  1.00  6.22           C  
ATOM    447  CD1 LEU A  72       1.682  13.230  11.462  1.00  8.87           C  
ATOM    448  CD2 LEU A  72       2.111  10.803  11.854  1.00  7.49           C  
ATOM    449  N   SER A  73      -2.291  12.167  13.439  1.00  4.93           N  
ATOM    450  CA  SER A  73      -3.517  11.979  12.633  1.00  5.14           C  
ATOM    451  C   SER A  73      -4.417  13.225  12.587  1.00  6.19           C  
ATOM    452  O   SER A  73      -4.881  13.636  11.527  1.00  6.24           O  
ATOM    453  CB  SER A  73      -4.265  10.753  13.107  1.00  4.93           C  
ATOM    454  OG  SER A  73      -3.395   9.635  12.965  1.00  5.06           O  
ATOM    455  N   TYR A  74      -4.627  13.823  13.753  1.00  4.59           N  
ATOM    456  CA  TYR A  74      -5.371  15.053  13.860  1.00  5.68           C  
ATOM    457  C   TYR A  74      -4.686  16.215  13.122  1.00  5.76           C  
ATOM    458  O   TYR A  74      -5.379  17.030  12.480  1.00  6.93           O  
ATOM    459  CB  TYR A  74      -5.597  15.403  15.341  1.00  5.34           C  
ATOM    460  CG  TYR A  74      -6.510  16.595  15.615  1.00  6.86           C  
ATOM    461  CD1 TYR A  74      -7.726  16.743  14.970  1.00  9.67           C  
ATOM    462  CD2 TYR A  74      -6.160  17.539  16.578  1.00  8.24           C  
ATOM    463  CE1 TYR A  74      -8.571  17.782  15.263  1.00  9.78           C  
ATOM    464  CE2 TYR A  74      -7.022  18.583  16.883  1.00 10.80           C  
ATOM    465  CZ  TYR A  74      -8.215  18.696  16.198  1.00  8.46           C  
ATOM    466  OH  TYR A  74      -9.100  19.723  16.482  1.00  9.33           O  
ATOM    467  N   GLU A  75      -3.359  16.328  13.245  1.00  5.40           N  
ATOM    468  CA  GLU A  75      -2.596  17.368  12.557  1.00  4.78           C  
ATOM    469  C   GLU A  75      -2.693  17.239  11.046  1.00  6.47           C  
ATOM    470  O   GLU A  75      -2.769  18.262  10.325  1.00  7.36           O  
ATOM    471  CB  GLU A  75      -1.140  17.347  12.990  1.00  7.82           C  
ATOM    472  CG  GLU A  75      -0.927  17.743  14.430  1.00 11.25           C  
ATOM    473  CD  GLU A  75      -0.653  19.198  14.596  1.00 18.39           C  
ATOM    474  OE1 GLU A  75      -1.093  20.005  13.731  1.00 17.07           O  
ATOM    475  OE2 GLU A  75       0.001  19.552  15.597  1.00 19.90           O  
ATOM    476  N   LEU A  76      -2.698  16.013  10.540  1.00  5.04           N  
ATOM    477  CA  LEU A  76      -2.894  15.830   9.095  1.00  5.01           C  
ATOM    478  C   LEU A  76      -4.266  16.388   8.687  1.00  5.84           C  
ATOM    479  O   LEU A  76      -4.375  17.112   7.673  1.00  6.74           O  
ATOM    480  CB  LEU A  76      -2.759  14.340   8.736  1.00  6.71           C  
ATOM    481  CG  LEU A  76      -1.302  13.842   8.773  1.00  7.19           C  
ATOM    482  CD1 LEU A  76      -1.281  12.359   8.758  1.00  8.13           C  
ATOM    483  CD2 LEU A  76      -0.517  14.386   7.572  1.00  8.43           C  
ATOM    484  N   PHE A  77      -5.304  16.081   9.478  1.00  5.11           N  
ATOM    485  CA  PHE A  77      -6.649  16.588   9.198  1.00  6.77           C  
ATOM    486  C   PHE A  77      -6.667  18.112   9.201  1.00  6.88           C  
ATOM    487  O   PHE A  77      -7.202  18.722   8.277  1.00  8.28           O  
ATOM    488  CB  PHE A  77      -7.675  16.039  10.192  1.00  7.74           C  
ATOM    489  CG  PHE A  77      -8.976  16.758  10.156  1.00  7.49           C  
ATOM    490  CD1 PHE A  77      -9.941  16.414   9.212  1.00 10.92           C  
ATOM    491  CD2 PHE A  77      -9.255  17.794  11.050  1.00 10.14           C  
ATOM    492  CE1 PHE A  77     -11.132  17.078   9.147  1.00 11.03           C  
ATOM    493  CE2 PHE A  77     -10.482  18.471  10.984  1.00 12.54           C  
ATOM    494  CZ  PHE A  77     -11.414  18.091  10.035  1.00 11.72           C  
ATOM    495  N   LEU A  78      -6.104  18.720  10.235  1.00  6.79           N  
ATOM    496  CA  LEU A  78      -6.119  20.167  10.330  1.00  5.99           C  
ATOM    497  C   LEU A  78      -5.350  20.771   9.196  1.00  7.09           C  
ATOM    498  O   LEU A  78      -5.645  21.886   8.783  1.00  8.84           O  
ATOM    499  CB  LEU A  78      -5.523  20.633  11.662  1.00  7.93           C  
ATOM    500  CG  LEU A  78      -6.320  20.270  12.941  1.00  7.36           C  
ATOM    501  CD1 LEU A  78      -5.477  20.637  14.129  1.00 10.42           C  
ATOM    502  CD2 LEU A  78      -7.645  21.010  12.987  1.00  9.40           C  
ATOM    503  N   GLY A  79      -4.343  20.060   8.685  1.00  6.64           N  
ATOM    504  CA  GLY A  79      -3.527  20.532   7.581  1.00  6.37           C  
ATOM    505  C   GLY A  79      -4.101  20.304   6.192  1.00  7.96           C  
ATOM    506  O   GLY A  79      -3.430  20.593   5.198  1.00 10.72           O  
ATOM    507  N   GLY A  80      -5.304  19.793   6.094  1.00  8.19           N  
ATOM    508  CA  GLY A  80      -5.977  19.648   4.789  1.00  8.82           C  
ATOM    509  C   GLY A  80      -5.988  18.233   4.198  1.00 10.19           C  
ATOM    510  O   GLY A  80      -6.329  18.034   3.021  1.00  9.23           O  
ATOM    511  N   PHE A  81      -5.641  17.252   5.026  1.00  9.53           N  
ATOM    512  CA  PHE A  81      -5.563  15.836   4.606  1.00  9.82           C  
ATOM    513  C   PHE A  81      -6.559  15.021   5.456  1.00  9.26           C  
ATOM    514  O   PHE A  81      -6.172  14.388   6.455  1.00 10.67           O  
ATOM    515  CB  PHE A  81      -4.156  15.319   4.785  1.00  8.34           C  
ATOM    516  CG  PHE A  81      -3.113  16.161   4.139  1.00  8.75           C  
ATOM    517  CD1 PHE A  81      -2.856  16.049   2.783  1.00  6.95           C  
ATOM    518  CD2 PHE A  81      -2.356  17.060   4.891  1.00  9.00           C  
ATOM    519  CE1 PHE A  81      -1.904  16.832   2.186  1.00  9.92           C  
ATOM    520  CE2 PHE A  81      -1.387  17.832   4.298  1.00 10.72           C  
ATOM    521  CZ  PHE A  81      -1.173  17.736   2.931  1.00  9.60           C  
ATOM    522  N   PRO A  82      -7.852  15.057   5.091  1.00  8.53           N  
ATOM    523  CA  PRO A  82      -8.914  14.430   5.903  1.00  9.35           C  
ATOM    524  C   PRO A  82      -9.018  12.901   5.856  1.00  9.92           C  
ATOM    525  O   PRO A  82      -9.673  12.304   6.734  1.00  8.30           O  
ATOM    526  CB  PRO A  82     -10.203  15.008   5.295  1.00  9.86           C  
ATOM    527  CG  PRO A  82      -9.833  15.314   3.871  1.00 11.74           C  
ATOM    528  CD  PRO A  82      -8.406  15.758   3.907  1.00 10.15           C  
ATOM    529  N   ASN A  83      -8.441  12.262   4.833  1.00  7.98           N  
ATOM    530  CA  ASN A  83      -8.668  10.843   4.625  1.00  7.56           C  
ATOM    531  C   ASN A  83      -7.700  10.011   5.426  1.00  4.78           C  
ATOM    532  O   ASN A  83      -6.860   9.303   4.851  1.00  6.69           O  
ATOM    533  CB  ASN A  83      -8.528  10.470   3.150  1.00  7.89           C  
ATOM    534  CG  ASN A  83      -9.594  11.084   2.257  1.00 10.03           C  
ATOM    535  OD1 ASN A  83     -10.768  11.294   2.654  1.00 12.38           O  
ATOM    536  ND2 ASN A  83      -9.210  11.333   1.007  1.00  9.14           N  
ATOM    537  N   VAL A  84      -7.840  10.026   6.749  1.00  5.29           N  
ATOM    538  CA  VAL A  84      -6.857   9.353   7.625  1.00  5.59           C  
ATOM    539  C   VAL A  84      -7.498   8.212   8.386  1.00  5.32           C  
ATOM    540  O   VAL A  84      -8.571   8.353   9.000  1.00  5.74           O  
ATOM    541  CB  VAL A  84      -6.209  10.324   8.609  1.00  6.67           C  
ATOM    542  CG1 VAL A  84      -5.157   9.601   9.507  1.00  7.75           C  
ATOM    543  CG2 VAL A  84      -5.533  11.444   7.873  1.00  7.95           C  
ATOM    544  N   THR A  85      -6.849   7.060   8.313  1.00  5.11           N  
ATOM    545  CA  THR A  85      -7.156   5.880   9.113  1.00  5.24           C  
ATOM    546  C   THR A  85      -5.948   5.550   9.960  1.00  3.72           C  
ATOM    547  O   THR A  85      -4.834   5.465   9.439  1.00  4.40           O  
ATOM    548  CB  THR A  85      -7.534   4.671   8.209  1.00  5.66           C  
ATOM    549  OG1 THR A  85      -8.614   5.047   7.337  1.00  4.87           O  
ATOM    550  CG2 THR A  85      -7.970   3.456   9.048  1.00  6.10           C  
ATOM    551  N   SER A  86      -6.189   5.258  11.228  1.00  4.64           N  
ATOM    552  CA  SER A  86      -5.119   5.040  12.191  1.00  3.98           C  
ATOM    553  C   SER A  86      -5.354   3.747  12.928  1.00  3.91           C  
ATOM    554  O   SER A  86      -6.486   3.484  13.379  1.00  5.69           O  
ATOM    555  CB  SER A  86      -5.055   6.216  13.165  1.00  5.52           C  
ATOM    556  OG  SER A  86      -4.895   7.438  12.465  1.00  5.47           O  
ATOM    557  N   VAL A  87      -4.313   2.916  13.007  1.00  4.45           N  
ATOM    558  CA  VAL A  87      -4.404   1.637  13.644  1.00  2.61           C  
ATOM    559  C   VAL A  87      -3.351   1.408  14.743  1.00  5.18           C  
ATOM    560  O   VAL A  87      -2.266   1.988  14.710  1.00  4.13           O  
ATOM    561  CB  VAL A  87      -4.424   0.439  12.628  1.00  5.66           C  
ATOM    562  CG1 VAL A  87      -5.551   0.667  11.615  1.00  5.53           C  
ATOM    563  CG2 VAL A  87      -3.130   0.310  11.925  1.00  6.60           C  
ATOM    564  N   ASP A  88      -3.688   0.543  15.690  1.00  3.96           N  
ATOM    565  CA  ASP A  88      -2.791   0.187  16.821  1.00  4.25           C  
ATOM    566  C   ASP A  88      -3.281  -1.123  17.411  1.00  5.51           C  
ATOM    567  O   ASP A  88      -4.498  -1.400  17.356  1.00  4.28           O  
ATOM    568  CB  ASP A  88      -2.821   1.302  17.885  1.00  4.77           C  
ATOM    569  CG  ASP A  88      -1.593   1.298  18.743  1.00  3.84           C  
ATOM    570  OD1 ASP A  88      -1.481   0.355  19.559  1.00  4.74           O  
ATOM    571  OD2 ASP A  88      -0.750   2.211  18.594  1.00  4.17           O  
ATOM    572  N   TYR A  89      -2.382  -1.959  17.950  1.00  3.07           N  
ATOM    573  CA  TYR A  89      -2.816  -3.206  18.531  1.00  5.41           C  
ATOM    574  C   TYR A  89      -3.317  -3.028  19.977  1.00  4.29           C  
ATOM    575  O   TYR A  89      -3.908  -3.907  20.539  1.00  5.71           O  
ATOM    576  CB  TYR A  89      -1.769  -4.325  18.347  1.00  3.94           C  
ATOM    577  CG  TYR A  89      -0.469  -4.259  19.181  1.00  3.39           C  
ATOM    578  CD1 TYR A  89      -0.097  -3.120  19.952  1.00  4.03           C  
ATOM    579  CD2 TYR A  89       0.395  -5.338  19.188  1.00  5.28           C  
ATOM    580  CE1 TYR A  89       1.088  -3.103  20.677  1.00  3.09           C  
ATOM    581  CE2 TYR A  89       1.553  -5.314  19.920  1.00  5.95           C  
ATOM    582  CZ  TYR A  89       1.911  -4.209  20.647  1.00  2.59           C  
ATOM    583  OH  TYR A  89       3.088  -4.187  21.404  1.00  5.71           O  
ATOM    584  N   SER A  90      -3.107  -1.836  20.556  1.00  3.02           N  
ATOM    585  CA  SER A  90      -3.708  -1.487  21.840  1.00  2.94           C  
ATOM    586  C   SER A  90      -5.188  -1.067  21.606  1.00  3.52           C  
ATOM    587  O   SER A  90      -5.490   0.069  21.192  1.00  4.12           O  
ATOM    588  CB  SER A  90      -2.948  -0.342  22.466  1.00  4.09           C  
ATOM    589  OG  SER A  90      -3.659   0.133  23.592  1.00  4.67           O  
ATOM    590  N   SER A  91      -6.117  -1.957  21.958  1.00  3.33           N  
ATOM    591  CA  SER A  91      -7.535  -1.653  21.809  1.00  4.82           C  
ATOM    592  C   SER A  91      -7.917  -0.505  22.764  1.00  4.55           C  
ATOM    593  O   SER A  91      -8.815   0.306  22.485  1.00  5.75           O  
ATOM    594  CB  SER A  91      -8.413  -2.876  22.034  1.00  4.73           C  
ATOM    595  OG  SER A  91      -9.680  -2.695  21.410  1.00  5.75           O  
ATOM    596  N   VAL A  92      -7.222  -0.446  23.885  1.00  4.22           N  
ATOM    597  CA  VAL A  92      -7.415   0.620  24.829  1.00  5.49           C  
ATOM    598  C   VAL A  92      -7.168   1.955  24.189  1.00  5.27           C  
ATOM    599  O   VAL A  92      -8.007   2.840  24.285  1.00  4.02           O  
ATOM    600  CB  VAL A  92      -6.489   0.432  26.087  1.00  5.73           C  
ATOM    601  CG1 VAL A  92      -6.510   1.684  26.965  1.00  6.89           C  
ATOM    602  CG2 VAL A  92      -6.904  -0.823  26.910  1.00  6.26           C  
ATOM    603  N   VAL A  93      -6.032   2.125  23.492  1.00  4.47           N  
ATOM    604  CA  VAL A  93      -5.746   3.427  22.872  1.00  4.62           C  
ATOM    605  C   VAL A  93      -6.672   3.686  21.689  1.00  3.48           C  
ATOM    606  O   VAL A  93      -7.019   4.826  21.442  1.00  3.95           O  
ATOM    607  CB  VAL A  93      -4.242   3.622  22.493  1.00  4.82           C  
ATOM    608  CG1 VAL A  93      -3.914   3.022  21.121  1.00  5.15           C  
ATOM    609  CG2 VAL A  93      -3.841   5.130  22.558  1.00  5.35           C  
ATOM    610  N   VAL A  94      -7.107   2.652  21.007  1.00  3.80           N  
ATOM    611  CA  VAL A  94      -8.025   2.870  19.866  1.00  3.88           C  
ATOM    612  C   VAL A  94      -9.372   3.424  20.362  1.00  3.64           C  
ATOM    613  O   VAL A  94      -9.849   4.438  19.848  1.00  4.36           O  
ATOM    614  CB  VAL A  94      -8.186   1.612  19.021  1.00  3.10           C  
ATOM    615  CG1 VAL A  94      -9.354   1.735  18.033  1.00  4.41           C  
ATOM    616  CG2 VAL A  94      -6.873   1.295  18.267  1.00  3.64           C  
ATOM    617  N   ALA A  95      -9.934   2.818  21.406  1.00  4.78           N  
ATOM    618  CA  ALA A  95     -11.142   3.323  22.009  1.00  3.44           C  
ATOM    619  C   ALA A  95     -10.962   4.753  22.526  1.00  4.66           C  
ATOM    620  O   ALA A  95     -11.841   5.597  22.365  1.00  4.71           O  
ATOM    621  CB  ALA A  95     -11.566   2.435  23.125  1.00  3.18           C  
ATOM    622  N   ALA A  96      -9.827   5.031  23.137  1.00  4.15           N  
ATOM    623  CA  ALA A  96      -9.540   6.361  23.661  1.00  5.97           C  
ATOM    624  C   ALA A  96      -9.464   7.388  22.549  1.00  5.74           C  
ATOM    625  O   ALA A  96      -9.991   8.501  22.702  1.00  5.07           O  
ATOM    626  CB  ALA A  96      -8.210   6.353  24.444  1.00  5.47           C  
ATOM    627  N   MET A  97      -8.794   7.058  21.434  1.00  5.13           N  
ATOM    628  CA  MET A  97      -8.709   7.998  20.282  1.00  6.37           C  
ATOM    629  C   MET A  97     -10.059   8.174  19.579  1.00  4.38           C  
ATOM    630  O   MET A  97     -10.403   9.276  19.175  1.00  4.99           O  
ATOM    631  CB  MET A  97      -7.640   7.556  19.289  1.00  4.69           C  
ATOM    632  CG  MET A  97      -6.161   7.618  19.881  1.00  4.10           C  
ATOM    633  SD  MET A  97      -5.690   9.263  20.541  1.00  5.30           S  
ATOM    634  CE  MET A  97      -6.049   9.045  22.319  1.00  7.13           C  
ATOM    635  N   GLN A  98     -10.870   7.118  19.537  1.00  4.59           N  
ATOM    636  CA  GLN A  98     -12.234   7.235  19.013  1.00  4.39           C  
ATOM    637  C   GLN A  98     -13.043   8.270  19.820  1.00  5.19           C  
ATOM    638  O   GLN A  98     -13.811   9.083  19.241  1.00  7.47           O  
ATOM    639  CB  GLN A  98     -12.956   5.868  19.003  1.00  3.24           C  
ATOM    640  CG  GLN A  98     -12.445   4.965  17.862  1.00  4.29           C  
ATOM    641  CD  GLN A  98     -12.932   3.548  17.958  1.00  5.64           C  
ATOM    642  OE1 GLN A  98     -13.340   3.118  19.028  1.00  6.94           O  
ATOM    643  NE2 GLN A  98     -12.927   2.815  16.841  1.00  6.06           N  
ATOM    644  N   ALA A  99     -12.895   8.238  21.141  1.00  4.92           N  
ATOM    645  CA  ALA A  99     -13.568   9.179  22.036  1.00  5.10           C  
ATOM    646  C   ALA A  99     -12.994  10.600  21.935  1.00  6.19           C  
ATOM    647  O   ALA A  99     -13.749  11.577  21.780  1.00  7.08           O  
ATOM    648  CB  ALA A  99     -13.488   8.679  23.480  1.00  6.49           C  
ATOM    649  N   CYS A 100     -11.683  10.724  22.002  1.00  4.71           N  
ATOM    650  CA  CYS A 100     -10.987  12.045  21.930  1.00  6.35           C  
ATOM    651  C   CYS A 100     -11.261  12.793  20.617  1.00  5.15           C  
ATOM    652  O   CYS A 100     -11.377  14.057  20.610  1.00  5.52           O  
ATOM    653  CB  CYS A 100      -9.474  11.831  22.090  1.00  6.58           C  
ATOM    654  SG  CYS A 100      -8.532  13.376  22.137  1.00 10.96           S  
ATOM    655  N   TYR A 101     -11.376  12.028  19.515  1.00  5.42           N  
ATOM    656  CA  TYR A 101     -11.531  12.589  18.174  1.00  5.41           C  
ATOM    657  C   TYR A 101     -12.924  12.356  17.582  1.00  4.12           C  
ATOM    658  O   TYR A 101     -13.128  12.410  16.369  1.00  5.91           O  
ATOM    659  CB  TYR A 101     -10.373  12.111  17.254  1.00  5.13           C  
ATOM    660  CG  TYR A 101      -9.060  12.653  17.714  1.00  5.17           C  
ATOM    661  CD1 TYR A 101      -8.799  14.004  17.575  1.00  6.31           C  
ATOM    662  CD2 TYR A 101      -8.107  11.840  18.365  1.00  5.59           C  
ATOM    663  CE1 TYR A 101      -7.612  14.543  18.005  1.00  5.26           C  
ATOM    664  CE2 TYR A 101      -6.917  12.381  18.821  1.00  6.21           C  
ATOM    665  CZ  TYR A 101      -6.694  13.752  18.645  1.00  5.20           C  
ATOM    666  OH  TYR A 101      -5.505  14.295  19.083  1.00  6.22           O  
ATOM    667  N   ALA A 102     -13.903  12.200  18.476  1.00  5.33           N  
ATOM    668  CA  ALA A 102     -15.288  12.013  18.070  1.00  6.16           C  
ATOM    669  C   ALA A 102     -15.813  13.230  17.289  1.00  6.26           C  
ATOM    670  O   ALA A 102     -16.765  13.113  16.521  1.00  8.09           O  
ATOM    671  CB  ALA A 102     -16.160  11.776  19.312  1.00  7.79           C  
ATOM    672  N   HIS A 103     -15.180  14.374  17.486  1.00  5.38           N  
ATOM    673  CA  HIS A 103     -15.510  15.601  16.726  1.00  7.21           C  
ATOM    674  C   HIS A 103     -14.962  15.639  15.320  1.00  5.93           C  
ATOM    675  O   HIS A 103     -15.251  16.590  14.573  1.00  7.91           O  
ATOM    676  CB  HIS A 103     -15.059  16.852  17.489  1.00  6.99           C  
ATOM    677  CG  HIS A 103     -13.581  16.980  17.628  1.00  7.73           C  
ATOM    678  ND1 HIS A 103     -12.817  16.060  18.326  1.00  8.09           N  
ATOM    679  CD2 HIS A 103     -12.717  17.915  17.164  1.00  6.26           C  
ATOM    680  CE1 HIS A 103     -11.550  16.446  18.286  1.00  8.14           C  
ATOM    681  NE2 HIS A 103     -11.471  17.576  17.599  1.00  7.80           N  
ATOM    682  N   VAL A 104     -14.215  14.596  14.930  1.00  6.52           N  
ATOM    683  CA  VAL A 104     -13.623  14.524  13.590  1.00  6.40           C  
ATOM    684  C   VAL A 104     -13.980  13.169  12.957  1.00  8.24           C  
ATOM    685  O   VAL A 104     -13.168  12.261  12.936  1.00  7.57           O  
ATOM    686  CB  VAL A 104     -12.083  14.691  13.611  1.00  8.77           C  
ATOM    687  CG1 VAL A 104     -11.567  15.006  12.206  1.00  9.54           C  
ATOM    688  CG2 VAL A 104     -11.661  15.764  14.568  1.00  9.03           C  
ATOM    689  N   PRO A 105     -15.213  13.041  12.428  1.00  7.66           N  
ATOM    690  CA  PRO A 105     -15.699  11.788  11.808  1.00  9.87           C  
ATOM    691  C   PRO A 105     -14.841  11.279  10.644  1.00  9.03           C  
ATOM    692  O   PRO A 105     -14.837  10.081  10.383  1.00 11.44           O  
ATOM    693  CB  PRO A 105     -17.100  12.159  11.315  1.00 11.09           C  
ATOM    694  CG  PRO A 105     -17.171  13.672  11.350  1.00 12.55           C  
ATOM    695  CD  PRO A 105     -16.249  14.101  12.406  1.00 10.84           C  
ATOM    696  N   GLN A 106     -14.140  12.185   9.962  1.00  8.02           N  
ATOM    697  CA  GLN A 106     -13.255  11.852   8.838  1.00  8.66           C  
ATOM    698  C   GLN A 106     -12.160  10.892   9.268  1.00  7.87           C  
ATOM    699  O   GLN A 106     -11.745  10.046   8.498  1.00  8.55           O  
ATOM    700  CB  GLN A 106     -12.612  13.119   8.267  1.00  9.27           C  
ATOM    701  CG  GLN A 106     -13.592  14.094   7.553  1.00 10.66           C  
ATOM    702  CD  GLN A 106     -14.138  15.151   8.463  1.00 11.00           C  
ATOM    703  OE1 GLN A 106     -14.310  14.938   9.636  1.00  9.58           O  
ATOM    704  NE2 GLN A 106     -14.440  16.325   7.897  1.00 14.23           N  
ATOM    705  N   LEU A 107     -11.700  11.044  10.506  1.00  6.06           N  
ATOM    706  CA  LEU A 107     -10.685  10.183  11.088  1.00  7.73           C  
ATOM    707  C   LEU A 107     -11.265   8.875  11.544  1.00  7.31           C  
ATOM    708  O   LEU A 107     -12.229   8.834  12.341  1.00  6.43           O  
ATOM    709  CB  LEU A 107     -10.001  10.863  12.276  1.00  8.94           C  
ATOM    710  CG  LEU A 107      -9.242  12.179  11.991  1.00 11.01           C  
ATOM    711  CD1 LEU A 107      -8.697  12.851  13.267  1.00 14.30           C  
ATOM    712  CD2 LEU A 107      -8.157  11.942  11.046  1.00 11.50           C  
ATOM    713  N   ARG A 108     -10.642   7.797  11.073  1.00  6.14           N  
ATOM    714  CA  ARG A 108     -11.019   6.449  11.427  1.00  6.02           C  
ATOM    715  C   ARG A 108      -9.924   5.802  12.309  1.00  5.41           C  
ATOM    716  O   ARG A 108      -8.725   6.056  12.144  1.00  4.94           O  
ATOM    717  CB  ARG A 108     -11.224   5.614  10.145  1.00  6.32           C  
ATOM    718  CG  ARG A 108     -12.338   6.130   9.283  1.00  9.10           C  
ATOM    719  CD  ARG A 108     -12.312   5.507   7.930  1.00 10.35           C  
ATOM    720  NE  ARG A 108     -13.349   6.047   7.043  1.00 11.31           N  
ATOM    721  CZ  ARG A 108     -13.503   5.707   5.773  1.00 11.14           C  
ATOM    722  NH1 ARG A 108     -12.698   4.833   5.216  1.00 11.47           N  
ATOM    723  NH2 ARG A 108     -14.499   6.255   5.037  1.00 13.06           N  
ATOM    724  N   TRP A 109     -10.346   4.961  13.250  1.00  5.43           N  
ATOM    725  CA  TRP A 109      -9.437   4.318  14.207  1.00  4.89           C  
ATOM    726  C   TRP A 109      -9.790   2.850  14.337  1.00  5.05           C  
ATOM    727  O   TRP A 109     -10.962   2.531  14.583  1.00  6.77           O  
ATOM    728  CB  TRP A 109      -9.589   4.970  15.568  1.00  4.35           C  
ATOM    729  CG  TRP A 109      -9.489   6.484  15.556  1.00  4.48           C  
ATOM    730  CD1 TRP A 109     -10.515   7.371  15.351  1.00  6.50           C  
ATOM    731  CD2 TRP A 109      -8.328   7.261  15.755  1.00  4.37           C  
ATOM    732  NE1 TRP A 109     -10.061   8.625  15.390  1.00  6.83           N  
ATOM    733  CE2 TRP A 109      -8.711   8.612  15.647  1.00  5.09           C  
ATOM    734  CE3 TRP A 109      -6.999   6.956  16.001  1.00  5.99           C  
ATOM    735  CZ2 TRP A 109      -7.817   9.650  15.791  1.00  6.19           C  
ATOM    736  CZ3 TRP A 109      -6.099   7.992  16.126  1.00  6.75           C  
ATOM    737  CH2 TRP A 109      -6.511   9.331  16.016  1.00  5.69           C  
ATOM    738  N   GLU A 110      -8.832   1.941  14.217  1.00  5.61           N  
ATOM    739  CA  GLU A 110      -9.135   0.500  14.385  1.00  5.99           C  
ATOM    740  C   GLU A 110      -8.036  -0.256  15.074  1.00  6.02           C  
ATOM    741  O   GLU A 110      -6.845   0.033  14.898  1.00  5.72           O  
ATOM    742  CB  GLU A 110      -9.417  -0.174  13.043  1.00  6.75           C  
ATOM    743  CG  GLU A 110     -10.765   0.227  12.401  1.00  8.71           C  
ATOM    744  CD  GLU A 110     -11.939  -0.098  13.240  1.00 11.35           C  
ATOM    745  OE1 GLU A 110     -11.800  -0.925  14.173  1.00  9.51           O  
ATOM    746  OE2 GLU A 110     -13.021   0.473  12.961  1.00 12.98           O  
ATOM    747  N   THR A 111      -8.456  -1.253  15.868  1.00  4.59           N  
ATOM    748  CA  THR A 111      -7.507  -2.150  16.546  1.00  4.88           C  
ATOM    749  C   THR A 111      -7.022  -3.161  15.578  1.00  5.63           C  
ATOM    750  O   THR A 111      -7.827  -3.847  14.961  1.00  5.60           O  
ATOM    751  CB  THR A 111      -8.178  -2.879  17.741  1.00  4.84           C  
ATOM    752  OG1 THR A 111      -8.741  -1.921  18.627  1.00  5.71           O  
ATOM    753  CG2 THR A 111      -7.170  -3.734  18.502  1.00  6.83           C  
ATOM    754  N   MET A 112      -5.702  -3.259  15.453  1.00  4.98           N  
ATOM    755  CA  MET A 112      -5.079  -4.086  14.433  1.00  8.19           C  
ATOM    756  C   MET A 112      -3.632  -4.313  14.760  1.00  5.69           C  
ATOM    757  O   MET A 112      -2.960  -3.408  15.240  1.00  5.53           O  
ATOM    758  CB  MET A 112      -5.145  -3.329  13.094  1.00  8.39           C  
ATOM    759  CG  MET A 112      -5.020  -4.156  11.902  1.00  8.82           C  
ATOM    760  SD  MET A 112      -5.416  -3.238  10.383  1.00  7.13           S  
ATOM    761  CE  MET A 112      -7.163  -2.851  10.630  1.00  8.83           C  
ATOM    762  N   ASP A 113      -3.127  -5.513  14.452  1.00  5.52           N  
ATOM    763  CA  ASP A 113      -1.696  -5.757  14.508  1.00  5.23           C  
ATOM    764  C   ASP A 113      -1.142  -5.403  13.118  1.00  6.40           C  
ATOM    765  O   ASP A 113      -1.622  -5.896  12.111  1.00  6.54           O  
ATOM    766  CB  ASP A 113      -1.395  -7.219  14.864  1.00  6.11           C  
ATOM    767  CG  ASP A 113       0.062  -7.428  15.266  1.00  6.32           C  
ATOM    768  OD1 ASP A 113       0.967  -7.019  14.530  1.00  5.91           O  
ATOM    769  OD2 ASP A 113       0.293  -8.000  16.350  1.00 10.45           O  
ATOM    770  N   VAL A 114      -0.157  -4.567  13.055  1.00  5.22           N  
ATOM    771  CA  VAL A 114       0.378  -4.099  11.773  1.00  6.02           C  
ATOM    772  C   VAL A 114       1.150  -5.165  10.989  1.00  5.04           C  
ATOM    773  O   VAL A 114       1.486  -4.932   9.836  1.00  5.54           O  
ATOM    774  CB  VAL A 114       1.247  -2.836  11.945  1.00  8.91           C  
ATOM    775  CG1 VAL A 114       0.386  -1.637  12.517  1.00  9.92           C  
ATOM    776  CG2 VAL A 114       2.462  -3.133  12.806  1.00 10.43           C  
ATOM    777  N   ARG A 115       1.367  -6.338  11.604  1.00  4.53           N  
ATOM    778  CA  ARG A 115       1.936  -7.479  10.904  1.00  5.87           C  
ATOM    779  C   ARG A 115       0.885  -8.171  10.031  1.00  6.79           C  
ATOM    780  O   ARG A 115       1.245  -8.985   9.174  1.00  9.48           O  
ATOM    781  CB  ARG A 115       2.512  -8.470  11.895  1.00  6.77           C  
ATOM    782  CG  ARG A 115       3.755  -7.957  12.621  1.00  6.97           C  
ATOM    783  CD  ARG A 115       4.071  -8.707  13.872  1.00 10.23           C  
ATOM    784  NE  ARG A 115       4.207 -10.130  13.604  1.00 11.83           N  
ATOM    785  CZ  ARG A 115       4.211 -11.068  14.533  1.00 14.41           C  
ATOM    786  NH1 ARG A 115       4.094 -10.749  15.819  1.00 15.57           N  
ATOM    787  NH2 ARG A 115       4.349 -12.343  14.177  1.00 15.01           N  
ATOM    788  N   LYS A 116      -0.399  -7.844  10.239  1.00  6.66           N  
ATOM    789  CA  LYS A 116      -1.488  -8.340   9.405  1.00  8.80           C  
ATOM    790  C   LYS A 116      -2.536  -7.242   9.253  1.00  7.14           C  
ATOM    791  O   LYS A 116      -3.421  -7.091  10.126  1.00  8.31           O  
ATOM    792  CB  LYS A 116      -2.085  -9.587  10.063  1.00 10.42           C  
ATOM    793  CG  LYS A 116      -3.188 -10.292   9.283  1.00 16.87           C  
ATOM    794  CD  LYS A 116      -3.949 -11.297  10.155  1.00 17.12           C  
ATOM    795  CE  LYS A 116      -4.678 -10.606  11.286  1.00 19.18           C  
ATOM    796  NZ  LYS A 116      -5.931 -11.305  11.703  1.00 21.58           N  
ATOM    797  N   LEU A 117      -2.443  -6.479   8.173  1.00  5.88           N  
ATOM    798  CA  LEU A 117      -3.385  -5.352   7.960  1.00  7.28           C  
ATOM    799  C   LEU A 117      -4.661  -5.915   7.367  1.00  9.18           C  
ATOM    800  O   LEU A 117      -4.637  -6.541   6.289  1.00 12.40           O  
ATOM    801  CB  LEU A 117      -2.782  -4.282   7.049  1.00  5.69           C  
ATOM    802  CG  LEU A 117      -1.520  -3.625   7.615  1.00  4.75           C  
ATOM    803  CD1 LEU A 117      -0.907  -2.648   6.638  1.00  7.77           C  
ATOM    804  CD2 LEU A 117      -1.804  -2.887   8.955  1.00  5.90           C  
ATOM    805  N   ASP A 118      -5.783  -5.720   8.063  1.00  9.33           N  
ATOM    806  CA  ASP A 118      -7.062  -6.290   7.634  1.00  9.17           C  
ATOM    807  C   ASP A 118      -7.786  -5.319   6.716  1.00  8.73           C  
ATOM    808  O   ASP A 118      -8.936  -4.895   6.990  1.00 12.90           O  
ATOM    809  CB  ASP A 118      -7.927  -6.668   8.850  1.00 14.31           C  
ATOM    810  N   PHE A 119      -7.125  -4.974   5.634  1.00  8.45           N  
ATOM    811  CA  PHE A 119      -7.692  -4.187   4.546  1.00  7.17           C  
ATOM    812  C   PHE A 119      -7.437  -4.925   3.265  1.00  7.96           C  
ATOM    813  O   PHE A 119      -6.444  -5.661   3.161  1.00  9.79           O  
ATOM    814  CB  PHE A 119      -6.996  -2.839   4.427  1.00  8.29           C  
ATOM    815  CG  PHE A 119      -7.149  -1.966   5.647  1.00  7.38           C  
ATOM    816  CD1 PHE A 119      -8.349  -1.274   5.905  1.00  8.56           C  
ATOM    817  CD2 PHE A 119      -6.081  -1.809   6.543  1.00  6.70           C  
ATOM    818  CE1 PHE A 119      -8.484  -0.458   7.023  1.00  8.61           C  
ATOM    819  CE2 PHE A 119      -6.208  -0.996   7.669  1.00  7.48           C  
ATOM    820  CZ  PHE A 119      -7.410  -0.305   7.911  1.00  7.27           C  
ATOM    821  N   PRO A 120      -8.312  -4.766   2.265  1.00 10.29           N  
ATOM    822  CA  PRO A 120      -8.022  -5.344   0.947  1.00  7.28           C  
ATOM    823  C   PRO A 120      -6.762  -4.714   0.381  1.00  9.43           C  
ATOM    824  O   PRO A 120      -6.376  -3.586   0.787  1.00 10.07           O  
ATOM    825  CB  PRO A 120      -9.261  -4.966   0.103  1.00  9.69           C  
ATOM    826  CG  PRO A 120     -10.330  -4.647   1.107  1.00  9.62           C  
ATOM    827  CD  PRO A 120      -9.608  -4.057   2.289  1.00  7.93           C  
ATOM    828  N   SER A 121      -6.094  -5.429  -0.528  1.00  7.26           N  
ATOM    829  CA  SER A 121      -4.917  -4.881  -1.189  1.00  8.67           C  
ATOM    830  C   SER A 121      -5.239  -3.585  -1.978  1.00  9.42           C  
ATOM    831  O   SER A 121      -6.349  -3.387  -2.449  1.00  9.24           O  
ATOM    832  CB  SER A 121      -4.304  -5.934  -2.100  1.00  9.20           C  
ATOM    833  OG  SER A 121      -4.191  -7.176  -1.424  1.00 11.40           O  
ATOM    834  N   ALA A 122      -4.253  -2.710  -2.114  1.00  7.94           N  
ATOM    835  CA  ALA A 122      -4.391  -1.438  -2.851  1.00  7.29           C  
ATOM    836  C   ALA A 122      -5.549  -0.592  -2.359  1.00  8.71           C  
ATOM    837  O   ALA A 122      -6.371  -0.171  -3.129  1.00  9.55           O  
ATOM    838  CB  ALA A 122      -4.498  -1.686  -4.347  1.00  9.66           C  
ATOM    839  N   SER A 123      -5.591  -0.358  -1.044  1.00  6.69           N  
ATOM    840  CA  SER A 123      -6.643   0.447  -0.398  1.00  7.83           C  
ATOM    841  C   SER A 123      -6.153   1.834  -0.004  1.00  7.82           C  
ATOM    842  O   SER A 123      -6.977   2.678   0.361  1.00  8.32           O  
ATOM    843  CB  SER A 123      -7.150  -0.255   0.871  1.00 10.29           C  
ATOM    844  OG  SER A 123      -7.964  -1.356   0.541  1.00 11.22           O  
ATOM    845  N   PHE A 124      -4.840   2.053   0.008  1.00  5.96           N  
ATOM    846  CA  PHE A 124      -4.278   3.301   0.474  1.00  6.86           C  
ATOM    847  C   PHE A 124      -3.272   3.892  -0.492  1.00  5.94           C  
ATOM    848  O   PHE A 124      -2.613   3.181  -1.221  1.00  6.81           O  
ATOM    849  CB  PHE A 124      -3.636   3.105   1.874  1.00  6.97           C  
ATOM    850  CG  PHE A 124      -4.629   2.824   2.935  1.00  6.23           C  
ATOM    851  CD1 PHE A 124      -5.349   3.861   3.500  1.00  6.02           C  
ATOM    852  CD2 PHE A 124      -4.912   1.499   3.330  1.00  6.20           C  
ATOM    853  CE1 PHE A 124      -6.306   3.607   4.459  1.00  7.93           C  
ATOM    854  CE2 PHE A 124      -5.859   1.258   4.286  1.00  7.63           C  
ATOM    855  CZ  PHE A 124      -6.559   2.289   4.847  1.00  5.53           C  
ATOM    856  N   ASP A 125      -3.177   5.221  -0.493  1.00  5.67           N  
ATOM    857  CA  ASP A 125      -2.185   5.932  -1.277  1.00  7.08           C  
ATOM    858  C   ASP A 125      -0.901   6.207  -0.513  1.00  6.60           C  
ATOM    859  O   ASP A 125       0.148   6.344  -1.114  1.00  6.65           O  
ATOM    860  CB  ASP A 125      -2.787   7.255  -1.738  1.00  5.68           C  
ATOM    861  CG  ASP A 125      -4.105   7.059  -2.522  1.00  7.62           C  
ATOM    862  OD1 ASP A 125      -4.060   6.362  -3.573  1.00 10.66           O  
ATOM    863  OD2 ASP A 125      -5.162   7.547  -2.072  1.00  7.65           O  
ATOM    864  N   VAL A 126      -1.009   6.362   0.809  1.00  6.14           N  
ATOM    865  CA  VAL A 126       0.126   6.650   1.641  1.00  6.90           C  
ATOM    866  C   VAL A 126      -0.011   5.876   2.935  1.00  5.34           C  
ATOM    867  O   VAL A 126      -1.104   5.790   3.495  1.00  5.36           O  
ATOM    868  CB  VAL A 126       0.197   8.135   1.993  1.00  5.87           C  
ATOM    869  CG1 VAL A 126       1.366   8.432   2.977  1.00  8.65           C  
ATOM    870  CG2 VAL A 126       0.306   8.976   0.708  1.00  8.56           C  
ATOM    871  N   VAL A 127       1.097   5.322   3.419  1.00  4.88           N  
ATOM    872  CA  VAL A 127       1.165   4.712   4.751  1.00  4.45           C  
ATOM    873  C   VAL A 127       2.271   5.423   5.502  1.00  5.66           C  
ATOM    874  O   VAL A 127       3.360   5.651   4.956  1.00  4.28           O  
ATOM    875  CB  VAL A 127       1.466   3.211   4.689  1.00  4.80           C  
ATOM    876  CG1 VAL A 127       1.627   2.650   6.101  1.00  3.92           C  
ATOM    877  CG2 VAL A 127       0.358   2.475   3.931  1.00  5.21           C  
ATOM    878  N   LEU A 128       1.976   5.850   6.738  1.00  4.35           N  
ATOM    879  CA  LEU A 128       2.940   6.478   7.606  1.00  4.45           C  
ATOM    880  C   LEU A 128       3.162   5.605   8.847  1.00  3.53           C  
ATOM    881  O   LEU A 128       2.227   4.996   9.361  1.00  4.49           O  
ATOM    882  CB  LEU A 128       2.432   7.850   8.077  1.00  4.84           C  
ATOM    883  CG  LEU A 128       1.952   8.836   7.024  1.00  4.54           C  
ATOM    884  CD1 LEU A 128       1.518  10.179   7.667  1.00  6.66           C  
ATOM    885  CD2 LEU A 128       2.991   9.072   5.988  1.00  5.61           C  
ATOM    886  N   GLU A 129       4.371   5.633   9.387  1.00  4.09           N  
ATOM    887  CA  GLU A 129       4.616   5.027  10.679  1.00  3.65           C  
ATOM    888  C   GLU A 129       5.682   5.836  11.405  1.00  3.50           C  
ATOM    889  O   GLU A 129       6.685   6.229  10.800  1.00  5.59           O  
ATOM    890  CB  GLU A 129       5.004   3.555  10.585  1.00  5.59           C  
ATOM    891  CG  GLU A 129       6.471   3.223  10.220  1.00  5.93           C  
ATOM    892  CD  GLU A 129       7.442   3.176  11.376  1.00  5.99           C  
ATOM    893  OE1 GLU A 129       7.002   2.916  12.503  1.00  5.27           O  
ATOM    894  OE2 GLU A 129       8.658   3.401  11.133  1.00  7.48           O  
ATOM    895  N   LYS A 130       5.449   6.122  12.686  1.00  5.18           N  
ATOM    896  CA  LYS A 130       6.387   6.872  13.515  1.00  5.35           C  
ATOM    897  C   LYS A 130       6.554   6.089  14.811  1.00  5.09           C  
ATOM    898  O   LYS A 130       5.662   6.048  15.622  1.00  5.58           O  
ATOM    899  CB  LYS A 130       5.903   8.324  13.763  1.00  4.32           C  
ATOM    900  CG  LYS A 130       6.868   9.110  14.612  1.00  4.43           C  
ATOM    901  CD  LYS A 130       6.732  10.629  14.413  1.00  5.32           C  
ATOM    902  CE  LYS A 130       5.389  11.134  14.867  1.00  7.56           C  
ATOM    903  NZ  LYS A 130       5.305  11.101  16.388  1.00  6.09           N  
ATOM    904  N   GLY A 131       7.708   5.456  14.970  1.00  6.04           N  
ATOM    905  CA  GLY A 131       8.057   4.782  16.198  1.00  7.62           C  
ATOM    906  C   GLY A 131       7.466   3.403  16.356  1.00  6.49           C  
ATOM    907  O   GLY A 131       7.653   2.781  17.414  1.00  7.40           O  
ATOM    908  N   THR A 132       6.767   2.898  15.336  1.00  4.15           N  
ATOM    909  CA  THR A 132       6.124   1.573  15.451  1.00  5.03           C  
ATOM    910  C   THR A 132       7.072   0.430  15.173  1.00  4.54           C  
ATOM    911  O   THR A 132       7.084  -0.542  15.927  1.00  6.52           O  
ATOM    912  CB  THR A 132       4.887   1.512  14.582  1.00  7.45           C  
ATOM    913  OG1 THR A 132       4.037   2.581  14.992  1.00  8.14           O  
ATOM    914  CG2 THR A 132       4.148   0.184  14.734  1.00  9.81           C  
ATOM    915  N   LEU A 133       7.865   0.531  14.104  1.00  3.41           N  
ATOM    916  CA  LEU A 133       8.881  -0.498  13.868  1.00  4.33           C  
ATOM    917  C   LEU A 133       9.941  -0.452  14.962  1.00  6.63           C  
ATOM    918  O   LEU A 133      10.538  -1.504  15.280  1.00  5.40           O  
ATOM    919  CB  LEU A 133       9.481  -0.388  12.473  1.00  5.06           C  
ATOM    920  CG  LEU A 133       8.512  -0.524  11.309  1.00  5.65           C  
ATOM    921  CD1 LEU A 133       9.279  -0.253   9.994  1.00  7.27           C  
ATOM    922  CD2 LEU A 133       7.833  -1.905  11.296  1.00  8.13           C  
ATOM    923  N   ASP A 134      10.134   0.723  15.593  1.00  6.09           N  
ATOM    924  CA  ASP A 134      10.994   0.818  16.730  1.00  4.20           C  
ATOM    925  C   ASP A 134      10.503  -0.056  17.895  1.00  5.41           C  
ATOM    926  O   ASP A 134      11.312  -0.711  18.562  1.00  7.77           O  
ATOM    927  CB  ASP A 134      11.126   2.291  17.156  1.00  5.79           C  
ATOM    928  CG  ASP A 134      11.722   3.138  16.075  1.00  6.43           C  
ATOM    929  OD1 ASP A 134      12.891   2.832  15.704  1.00  8.52           O  
ATOM    930  OD2 ASP A 134      11.055   4.099  15.601  1.00  7.78           O  
ATOM    931  N   ALA A 135       9.186  -0.112  18.125  1.00  4.83           N  
ATOM    932  CA  ALA A 135       8.637  -1.034  19.101  1.00  5.29           C  
ATOM    933  C   ALA A 135       8.936  -2.490  18.758  1.00  6.42           C  
ATOM    934  O   ALA A 135       9.358  -3.265  19.630  1.00  5.96           O  
ATOM    935  CB  ALA A 135       7.136  -0.811  19.293  1.00  5.83           C  
ATOM    936  N   LEU A 136       8.740  -2.874  17.491  1.00  5.45           N  
ATOM    937  CA  LEU A 136       9.031  -4.237  17.058  1.00  5.98           C  
ATOM    938  C   LEU A 136      10.483  -4.632  17.268  1.00  5.78           C  
ATOM    939  O   LEU A 136      10.786  -5.822  17.464  1.00  6.50           O  
ATOM    940  CB  LEU A 136       8.701  -4.441  15.566  1.00  6.05           C  
ATOM    941  CG  LEU A 136       7.285  -4.905  15.254  1.00  6.61           C  
ATOM    942  CD1 LEU A 136       6.312  -3.821  15.593  1.00  9.31           C  
ATOM    943  CD2 LEU A 136       7.146  -5.336  13.785  1.00  7.40           C  
ATOM    944  N   LEU A 137      11.382  -3.652  17.157  1.00  5.94           N  
ATOM    945  CA  LEU A 137      12.846  -3.874  17.269  1.00  3.58           C  
ATOM    946  C   LEU A 137      13.393  -3.480  18.652  1.00  6.33           C  
ATOM    947  O   LEU A 137      14.611  -3.449  18.873  1.00  7.58           O  
ATOM    948  CB  LEU A 137      13.576  -3.096  16.152  1.00  6.17           C  
ATOM    949  CG  LEU A 137      13.342  -3.652  14.735  1.00  5.93           C  
ATOM    950  CD1 LEU A 137      13.839  -2.720  13.747  1.00  8.06           C  
ATOM    951  CD2 LEU A 137      14.014  -5.010  14.556  1.00  9.00           C  
ATOM    952  N   ALA A 138      12.508  -3.223  19.601  1.00  6.63           N  
ATOM    953  CA  ALA A 138      12.933  -2.778  20.946  1.00  9.00           C  
ATOM    954  C   ALA A 138      13.619  -3.893  21.687  1.00 11.56           C  
ATOM    955  O   ALA A 138      13.181  -5.017  21.618  1.00 12.07           O  
ATOM    956  CB  ALA A 138      11.723  -2.293  21.774  1.00  8.53           C  
ATOM    957  N   GLY A 139      14.711  -3.553  22.383  1.00 15.72           N  
ATOM    958  CA  GLY A 139      15.418  -4.479  23.255  1.00 15.07           C  
ATOM    959  C   GLY A 139      16.376  -5.447  22.569  1.00 15.56           C  
ATOM    960  O   GLY A 139      16.929  -6.314  23.242  1.00 18.10           O  
ATOM    961  N   GLU A 140      16.562  -5.323  21.238  1.00 12.78           N  
ATOM    962  CA  GLU A 140      17.557  -6.147  20.487  1.00 10.93           C  
ATOM    963  C   GLU A 140      18.885  -6.113  21.227  1.00 11.37           C  
ATOM    964  O   GLU A 140      19.350  -5.056  21.604  1.00 12.09           O  
ATOM    965  CB  GLU A 140      17.740  -5.589  19.064  1.00  9.69           C  
ATOM    966  CG  GLU A 140      16.566  -5.896  18.093  1.00  9.08           C  
ATOM    967  CD  GLU A 140      16.619  -7.343  17.509  1.00 11.64           C  
ATOM    968  OE1 GLU A 140      17.739  -7.852  17.222  1.00  8.82           O  
ATOM    969  OE2 GLU A 140      15.545  -7.951  17.340  1.00 10.95           O  
ATOM    970  N   ARG A 141      19.480  -7.280  21.450  1.00 10.82           N  
ATOM    971  CA  ARG A 141      20.758  -7.375  22.196  1.00 10.43           C  
ATOM    972  C   ARG A 141      21.900  -6.638  21.507  1.00 11.59           C  
ATOM    973  O   ARG A 141      22.700  -5.989  22.163  1.00 10.28           O  
ATOM    974  CB  ARG A 141      21.149  -8.846  22.368  1.00 10.55           C  
ATOM    975  CG  ARG A 141      22.428  -9.085  23.165  1.00 10.57           C  
ATOM    976  CD  ARG A 141      22.639 -10.590  23.309  1.00 10.61           C  
ATOM    977  NE  ARG A 141      23.741 -10.973  24.219  1.00 10.95           N  
ATOM    978  CZ  ARG A 141      24.696 -11.848  23.914  1.00 10.17           C  
ATOM    979  NH1 ARG A 141      24.756 -12.413  22.717  1.00 11.33           N  
ATOM    980  NH2 ARG A 141      25.612 -12.154  24.828  1.00  9.86           N  
ATOM    981  N   ASP A 142      21.974  -6.766  20.179  1.00  9.64           N  
ATOM    982  CA  ASP A 142      23.059  -6.196  19.376  1.00 10.57           C  
ATOM    983  C   ASP A 142      22.473  -5.306  18.299  1.00  9.55           C  
ATOM    984  O   ASP A 142      21.851  -5.790  17.369  1.00  9.08           O  
ATOM    985  CB  ASP A 142      23.872  -7.334  18.745  1.00  9.54           C  
ATOM    986  CG  ASP A 142      25.017  -6.843  17.854  1.00 10.04           C  
ATOM    987  OD1 ASP A 142      25.236  -5.618  17.720  1.00 11.74           O  
ATOM    988  OD2 ASP A 142      25.698  -7.733  17.282  1.00 11.51           O  
ATOM    989  N   PRO A 143      22.698  -4.002  18.390  1.00  9.67           N  
ATOM    990  CA  PRO A 143      22.111  -3.177  17.321  1.00  9.76           C  
ATOM    991  C   PRO A 143      22.637  -3.510  15.912  1.00  9.31           C  
ATOM    992  O   PRO A 143      22.009  -3.154  14.941  1.00  8.80           O  
ATOM    993  CB  PRO A 143      22.494  -1.747  17.731  1.00 12.74           C  
ATOM    994  CG  PRO A 143      23.662  -1.907  18.651  1.00 15.58           C  
ATOM    995  CD  PRO A 143      23.458  -3.196  19.368  1.00 14.15           C  
ATOM    996  N   TRP A 144      23.800  -4.169  15.815  1.00  9.62           N  
ATOM    997  CA  TRP A 144      24.394  -4.479  14.517  1.00  9.97           C  
ATOM    998  C   TRP A 144      23.928  -5.823  13.931  1.00 10.67           C  
ATOM    999  O   TRP A 144      24.095  -6.057  12.747  1.00 11.96           O  
ATOM   1000  CB  TRP A 144      25.925  -4.443  14.610  1.00 12.37           C  
ATOM   1001  CG  TRP A 144      26.479  -3.069  14.878  1.00 11.88           C  
ATOM   1002  CD1 TRP A 144      27.017  -2.610  16.043  1.00 12.33           C  
ATOM   1003  CD2 TRP A 144      26.529  -1.980  13.955  1.00 13.57           C  
ATOM   1004  NE1 TRP A 144      27.405  -1.299  15.906  1.00 13.51           N  
ATOM   1005  CE2 TRP A 144      27.124  -0.888  14.628  1.00 12.37           C  
ATOM   1006  CE3 TRP A 144      26.127  -1.819  12.623  1.00 13.16           C  
ATOM   1007  CZ2 TRP A 144      27.325   0.359  14.010  1.00 13.95           C  
ATOM   1008  CZ3 TRP A 144      26.330  -0.588  12.005  1.00 13.08           C  
ATOM   1009  CH2 TRP A 144      26.931   0.487  12.699  1.00 13.75           C  
ATOM   1010  N   THR A 145      23.351  -6.695  14.764  1.00  8.60           N  
ATOM   1011  CA  THR A 145      22.977  -8.053  14.347  1.00  9.96           C  
ATOM   1012  C   THR A 145      21.550  -8.334  14.749  1.00  8.72           C  
ATOM   1013  O   THR A 145      21.247  -8.518  15.910  1.00  9.12           O  
ATOM   1014  CB  THR A 145      23.908  -9.075  14.981  1.00 10.90           C  
ATOM   1015  OG1 THR A 145      25.259  -8.679  14.740  1.00 13.75           O  
ATOM   1016  CG2 THR A 145      23.686 -10.470  14.430  1.00 12.64           C  
ATOM   1017  N   VAL A 146      20.654  -8.336  13.763  1.00  6.91           N  
ATOM   1018  CA  VAL A 146      19.199  -8.400  14.046  1.00  7.42           C  
ATOM   1019  C   VAL A 146      18.777  -9.849  14.329  1.00  7.41           C  
ATOM   1020  O   VAL A 146      19.116 -10.768  13.557  1.00  8.44           O  
ATOM   1021  CB  VAL A 146      18.378  -7.810  12.896  1.00  6.29           C  
ATOM   1022  CG1 VAL A 146      16.887  -7.778  13.286  1.00  6.89           C  
ATOM   1023  CG2 VAL A 146      18.871  -6.387  12.507  1.00  8.22           C  
ATOM   1024  N   SER A 147      18.057 -10.061  15.449  1.00  5.92           N  
ATOM   1025  CA  SER A 147      17.483 -11.392  15.791  1.00  7.36           C  
ATOM   1026  C   SER A 147      16.574 -11.892  14.676  1.00  6.55           C  
ATOM   1027  O   SER A 147      16.026 -11.113  13.903  1.00  6.56           O  
ATOM   1028  CB  SER A 147      16.670 -11.324  17.098  1.00  8.77           C  
ATOM   1029  OG  SER A 147      15.502 -10.514  16.955  1.00  6.58           O  
ATOM   1030  N   SER A 148      16.415 -13.187  14.592  1.00  5.00           N  
ATOM   1031  CA  SER A 148      15.527 -13.800  13.641  1.00  6.23           C  
ATOM   1032  C   SER A 148      14.126 -13.236  13.747  1.00  4.86           C  
ATOM   1033  O   SER A 148      13.493 -12.954  12.735  1.00  5.80           O  
ATOM   1034  CB  SER A 148      15.495 -15.308  13.863  1.00 10.19           C  
ATOM   1035  OG  SER A 148      16.781 -15.867  13.617  1.00 13.66           O  
ATOM   1036  N   GLU A 149      13.591 -13.138  14.963  1.00  5.05           N  
ATOM   1037  CA  GLU A 149      12.248 -12.576  15.114  1.00  4.42           C  
ATOM   1038  C   GLU A 149      12.165 -11.125  14.628  1.00  6.18           C  
ATOM   1039  O   GLU A 149      11.223 -10.782  13.960  1.00  5.14           O  
ATOM   1040  CB  GLU A 149      11.735 -12.663  16.548  1.00  5.47           C  
ATOM   1041  CG  GLU A 149      10.267 -12.245  16.643  1.00  6.02           C  
ATOM   1042  CD  GLU A 149       9.780 -11.932  18.022  1.00  5.28           C  
ATOM   1043  OE1 GLU A 149      10.392 -12.302  19.042  1.00  5.86           O  
ATOM   1044  OE2 GLU A 149       8.693 -11.257  18.092  1.00  6.27           O  
ATOM   1045  N   GLY A 150      13.157 -10.304  14.960  1.00  4.13           N  
ATOM   1046  CA  GLY A 150      13.165  -8.878  14.539  1.00  4.66           C  
ATOM   1047  C   GLY A 150      13.140  -8.731  13.047  1.00  5.11           C  
ATOM   1048  O   GLY A 150      12.403  -7.903  12.514  1.00  5.97           O  
ATOM   1049  N   VAL A 151      13.910  -9.573  12.345  1.00  4.51           N  
ATOM   1050  CA  VAL A 151      13.911  -9.561  10.910  1.00  4.15           C  
ATOM   1051  C   VAL A 151      12.518  -9.960  10.378  1.00  6.89           C  
ATOM   1052  O   VAL A 151      11.969  -9.267   9.498  1.00  5.26           O  
ATOM   1053  CB  VAL A 151      14.982 -10.493  10.336  1.00  5.96           C  
ATOM   1054  CG1 VAL A 151      14.832 -10.636   8.793  1.00  6.87           C  
ATOM   1055  CG2 VAL A 151      16.408 -10.000  10.700  1.00  7.01           C  
ATOM   1056  N   HIS A 152      11.962 -11.064  10.888  1.00  5.36           N  
ATOM   1057  CA  HIS A 152      10.696 -11.593  10.382  1.00  6.92           C  
ATOM   1058  C   HIS A 152       9.511 -10.673  10.635  1.00  7.69           C  
ATOM   1059  O   HIS A 152       8.656 -10.499   9.747  1.00  6.37           O  
ATOM   1060  CB  HIS A 152      10.399 -12.934  11.005  1.00  9.84           C  
ATOM   1061  CG  HIS A 152       9.042 -13.462  10.658  1.00 11.42           C  
ATOM   1062  ND1 HIS A 152       8.685 -13.794   9.371  1.00 13.99           N  
ATOM   1063  CD2 HIS A 152       7.955 -13.700  11.427  1.00 12.85           C  
ATOM   1064  CE1 HIS A 152       7.435 -14.224   9.365  1.00 13.44           C  
ATOM   1065  NE2 HIS A 152       6.971 -14.173  10.600  1.00 10.46           N  
ATOM   1066  N   THR A 153       9.392 -10.140  11.847  1.00  7.81           N  
ATOM   1067  CA  THR A 153       8.234  -9.322  12.174  1.00  6.29           C  
ATOM   1068  C   THR A 153       8.235  -8.020  11.383  1.00  7.18           C  
ATOM   1069  O   THR A 153       7.198  -7.600  10.860  1.00  6.09           O  
ATOM   1070  CB  THR A 153       8.136  -9.021  13.689  1.00  7.14           C  
ATOM   1071  OG1 THR A 153       9.335  -8.389  14.153  1.00  6.93           O  
ATOM   1072  CG2 THR A 153       7.844 -10.286  14.456  1.00  7.34           C  
ATOM   1073  N   VAL A 154       9.407  -7.390  11.246  1.00  4.29           N  
ATOM   1074  CA  VAL A 154       9.504  -6.173  10.468  1.00  5.00           C  
ATOM   1075  C   VAL A 154       9.217  -6.469   8.994  1.00  5.89           C  
ATOM   1076  O   VAL A 154       8.485  -5.719   8.347  1.00  6.08           O  
ATOM   1077  CB  VAL A 154      10.895  -5.504  10.665  1.00  4.95           C  
ATOM   1078  CG1 VAL A 154      11.123  -4.312   9.716  1.00  4.63           C  
ATOM   1079  CG2 VAL A 154      11.026  -5.021  12.110  1.00  6.44           C  
ATOM   1080  N   ASP A 155       9.742  -7.590   8.475  1.00  4.76           N  
ATOM   1081  CA  ASP A 155       9.458  -7.975   7.076  1.00  6.69           C  
ATOM   1082  C   ASP A 155       7.937  -8.173   6.854  1.00  5.02           C  
ATOM   1083  O   ASP A 155       7.396  -7.782   5.815  1.00  5.27           O  
ATOM   1084  CB  ASP A 155      10.252  -9.229   6.725  1.00  5.45           C  
ATOM   1085  CG  ASP A 155       9.951  -9.768   5.327  1.00  8.23           C  
ATOM   1086  OD1 ASP A 155       9.962  -8.991   4.355  1.00  5.87           O  
ATOM   1087  OD2 ASP A 155       9.757 -11.003   5.214  1.00 12.52           O  
ATOM   1088  N   GLN A 156       7.255  -8.784   7.817  1.00  7.74           N  
ATOM   1089  CA  GLN A 156       5.790  -8.952   7.756  1.00  6.05           C  
ATOM   1090  C   GLN A 156       5.105  -7.617   7.602  1.00  7.44           C  
ATOM   1091  O   GLN A 156       4.225  -7.466   6.751  1.00  7.07           O  
ATOM   1092  CB  GLN A 156       5.266  -9.607   9.018  1.00  7.99           C  
ATOM   1093  CG  GLN A 156       5.460 -11.059   9.145  1.00 11.56           C  
ATOM   1094  CD  GLN A 156       4.620 -11.603  10.301  1.00 12.25           C  
ATOM   1095  OE1 GLN A 156       5.093 -11.689  11.416  1.00 11.73           O  
ATOM   1096  NE2 GLN A 156       3.337 -11.876  10.037  1.00 15.44           N  
ATOM   1097  N   VAL A 157       5.472  -6.643   8.432  1.00  6.04           N  
ATOM   1098  CA  VAL A 157       4.839  -5.341   8.372  1.00  5.75           C  
ATOM   1099  C   VAL A 157       5.069  -4.692   7.039  1.00  5.72           C  
ATOM   1100  O   VAL A 157       4.135  -4.180   6.409  1.00  6.59           O  
ATOM   1101  CB  VAL A 157       5.308  -4.394   9.467  1.00  4.66           C  
ATOM   1102  CG1 VAL A 157       4.624  -3.054   9.326  1.00  7.03           C  
ATOM   1103  CG2 VAL A 157       5.002  -4.982  10.834  1.00  4.69           C  
ATOM   1104  N   LEU A 158       6.315  -4.707   6.576  1.00  4.75           N  
ATOM   1105  CA  LEU A 158       6.665  -4.073   5.324  1.00  6.04           C  
ATOM   1106  C   LEU A 158       6.011  -4.741   4.139  1.00  3.61           C  
ATOM   1107  O   LEU A 158       5.541  -4.044   3.227  1.00  6.24           O  
ATOM   1108  CB  LEU A 158       8.199  -4.028   5.161  1.00  3.98           C  
ATOM   1109  CG  LEU A 158       8.919  -3.153   6.217  1.00  5.35           C  
ATOM   1110  CD1 LEU A 158      10.427  -3.237   6.042  1.00  4.13           C  
ATOM   1111  CD2 LEU A 158       8.478  -1.722   6.178  1.00  6.68           C  
ATOM   1112  N   SER A 159       5.922  -6.047   4.138  1.00  4.04           N  
ATOM   1113  CA  SER A 159       5.171  -6.724   3.099  1.00  5.91           C  
ATOM   1114  C   SER A 159       3.724  -6.243   3.058  1.00  4.46           C  
ATOM   1115  O   SER A 159       3.161  -6.012   1.972  1.00  5.42           O  
ATOM   1116  CB  SER A 159       5.238  -8.211   3.304  1.00  6.09           C  
ATOM   1117  OG  SER A 159       4.556  -8.884   2.258  1.00  9.54           O  
ATOM   1118  N   GLU A 160       3.100  -6.103   4.220  1.00  4.91           N  
ATOM   1119  CA  GLU A 160       1.720  -5.644   4.303  1.00  4.55           C  
ATOM   1120  C   GLU A 160       1.564  -4.209   3.858  1.00  6.30           C  
ATOM   1121  O   GLU A 160       0.584  -3.872   3.201  1.00  4.81           O  
ATOM   1122  CB  GLU A 160       1.176  -5.834   5.725  1.00  6.64           C  
ATOM   1123  CG  GLU A 160       0.865  -7.246   6.020  1.00  6.87           C  
ATOM   1124  CD  GLU A 160      -0.352  -7.740   5.258  1.00  7.20           C  
ATOM   1125  OE1 GLU A 160      -1.489  -7.565   5.760  1.00  6.30           O  
ATOM   1126  OE2 GLU A 160      -0.186  -8.311   4.164  1.00  8.27           O  
ATOM   1127  N   VAL A 161       2.512  -3.358   4.221  1.00  4.49           N  
ATOM   1128  CA  VAL A 161       2.468  -2.001   3.749  1.00  4.75           C  
ATOM   1129  C   VAL A 161       2.482  -1.974   2.221  1.00  5.15           C  
ATOM   1130  O   VAL A 161       1.662  -1.289   1.591  1.00  5.61           O  
ATOM   1131  CB  VAL A 161       3.621  -1.182   4.299  1.00  5.75           C  
ATOM   1132  CG1 VAL A 161       3.672   0.196   3.594  1.00  3.97           C  
ATOM   1133  CG2 VAL A 161       3.497  -1.031   5.813  1.00  5.81           C  
ATOM   1134  N   SER A 162       3.416  -2.702   1.616  1.00  5.28           N  
ATOM   1135  CA  SER A 162       3.475  -2.747   0.163  1.00  5.90           C  
ATOM   1136  C   SER A 162       2.186  -3.278  -0.449  1.00  6.73           C  
ATOM   1137  O   SER A 162       1.719  -2.779  -1.485  1.00  7.35           O  
ATOM   1138  CB  SER A 162       4.647  -3.599  -0.282  1.00  5.99           C  
ATOM   1139  OG  SER A 162       4.740  -3.631  -1.715  1.00  8.40           O  
ATOM   1140  N   ARG A 163       1.614  -4.289   0.183  1.00  4.95           N  
ATOM   1141  CA  ARG A 163       0.365  -4.872  -0.285  1.00  6.94           C  
ATOM   1142  C   ARG A 163      -0.820  -3.882  -0.229  1.00  5.64           C  
ATOM   1143  O   ARG A 163      -1.615  -3.797  -1.194  1.00  6.26           O  
ATOM   1144  CB  ARG A 163      -0.011  -6.113   0.510  1.00  5.72           C  
ATOM   1145  CG  ARG A 163      -1.240  -6.832  -0.053  1.00  5.40           C  
ATOM   1146  CD  ARG A 163      -1.695  -7.985   0.795  1.00  7.90           C  
ATOM   1147  NE  ARG A 163      -2.075  -7.620   2.155  1.00  8.12           N  
ATOM   1148  CZ  ARG A 163      -3.257  -7.106   2.514  1.00  9.78           C  
ATOM   1149  NH1 ARG A 163      -4.183  -6.845   1.607  1.00  9.61           N  
ATOM   1150  NH2 ARG A 163      -3.506  -6.834   3.798  1.00  8.44           N  
ATOM   1151  N   VAL A 164      -0.992  -3.152   0.875  1.00  5.82           N  
ATOM   1152  CA  VAL A 164      -2.170  -2.292   0.995  1.00  7.60           C  
ATOM   1153  C   VAL A 164      -2.003  -1.002   0.212  1.00  6.56           C  
ATOM   1154  O   VAL A 164      -3.006  -0.340  -0.062  1.00  7.68           O  
ATOM   1155  CB  VAL A 164      -2.558  -1.955   2.476  1.00  6.06           C  
ATOM   1156  CG1 VAL A 164      -2.857  -3.191   3.226  1.00  7.17           C  
ATOM   1157  CG2 VAL A 164      -1.471  -1.087   3.166  1.00  7.19           C  
ATOM   1158  N   LEU A 165      -0.772  -0.621  -0.155  1.00  7.47           N  
ATOM   1159  CA  LEU A 165      -0.566   0.540  -1.036  1.00  7.35           C  
ATOM   1160  C   LEU A 165      -0.973   0.220  -2.454  1.00  8.37           C  
ATOM   1161  O   LEU A 165      -0.712  -0.864  -2.960  1.00  9.28           O  
ATOM   1162  CB  LEU A 165       0.887   1.007  -1.051  1.00  6.34           C  
ATOM   1163  CG  LEU A 165       1.396   1.713   0.188  1.00  5.75           C  
ATOM   1164  CD1 LEU A 165       2.911   1.890   0.146  1.00  7.56           C  
ATOM   1165  CD2 LEU A 165       0.668   3.044   0.344  1.00  4.75           C  
ATOM   1166  N   VAL A 166      -1.581   1.204  -3.105  1.00  8.34           N  
ATOM   1167  CA  VAL A 166      -1.809   1.135  -4.530  1.00  8.48           C  
ATOM   1168  C   VAL A 166      -0.485   1.143  -5.277  1.00 12.53           C  
ATOM   1169  O   VAL A 166       0.560   1.455  -4.704  1.00 12.49           O  
ATOM   1170  CB  VAL A 166      -2.675   2.331  -5.032  1.00 10.49           C  
ATOM   1171  CG1 VAL A 166      -4.014   2.256  -4.434  1.00  8.57           C  
ATOM   1172  CG2 VAL A 166      -1.981   3.688  -4.728  1.00 10.32           C  
ATOM   1173  N   PRO A 167      -0.510   0.762  -6.565  1.00 13.62           N  
ATOM   1174  CA  PRO A 167       0.659   0.974  -7.356  1.00 13.79           C  
ATOM   1175  C   PRO A 167       0.923   2.468  -7.392  1.00 13.67           C  
ATOM   1176  O   PRO A 167      -0.015   3.274  -7.533  1.00 15.77           O  
ATOM   1177  CB  PRO A 167       0.255   0.413  -8.746  1.00 14.03           C  
ATOM   1178  CG  PRO A 167      -0.843  -0.468  -8.477  1.00 14.48           C  
ATOM   1179  CD  PRO A 167      -1.579   0.131  -7.350  1.00 13.65           C  
ATOM   1180  N   GLY A 168       2.168   2.833  -7.234  1.00 14.03           N  
ATOM   1181  CA  GLY A 168       2.541   4.203  -7.173  1.00 11.51           C  
ATOM   1182  C   GLY A 168       2.459   4.808  -5.783  1.00 11.43           C  
ATOM   1183  O   GLY A 168       2.774   5.962  -5.634  1.00 11.67           O  
ATOM   1184  N   GLY A 169       2.034   4.025  -4.771  1.00 10.17           N  
ATOM   1185  CA  GLY A 169       1.824   4.553  -3.383  1.00 10.22           C  
ATOM   1186  C   GLY A 169       3.144   4.827  -2.679  1.00 11.32           C  
ATOM   1187  O   GLY A 169       4.188   4.401  -3.137  1.00 10.36           O  
ATOM   1188  N   ARG A 170       3.070   5.512  -1.533  1.00  8.03           N  
ATOM   1189  CA  ARG A 170       4.232   5.920  -0.772  1.00  7.74           C  
ATOM   1190  C   ARG A 170       4.156   5.445   0.675  1.00  6.31           C  
ATOM   1191  O   ARG A 170       3.102   5.539   1.306  1.00  7.46           O  
ATOM   1192  CB  ARG A 170       4.321   7.442  -0.791  1.00 10.42           C  
ATOM   1193  CG  ARG A 170       4.605   8.005  -2.205  1.00 11.70           C  
ATOM   1194  CD  ARG A 170       4.440   9.509  -2.242  1.00 16.04           C  
ATOM   1195  NE  ARG A 170       5.012  10.097  -3.466  1.00 19.37           N  
ATOM   1196  CZ  ARG A 170       4.464  10.019  -4.681  1.00 21.97           C  
ATOM   1197  NH1 ARG A 170       3.311   9.375  -4.868  1.00 24.81           N  
ATOM   1198  NH2 ARG A 170       5.075  10.596  -5.727  1.00 22.00           N  
ATOM   1199  N   PHE A 171       5.279   4.996   1.207  1.00  5.66           N  
ATOM   1200  CA  PHE A 171       5.412   4.662   2.624  1.00  4.43           C  
ATOM   1201  C   PHE A 171       6.480   5.529   3.213  1.00  4.62           C  
ATOM   1202  O   PHE A 171       7.588   5.617   2.652  1.00  5.95           O  
ATOM   1203  CB  PHE A 171       5.770   3.171   2.763  1.00  5.71           C  
ATOM   1204  CG  PHE A 171       6.217   2.772   4.141  1.00  4.66           C  
ATOM   1205  CD1 PHE A 171       5.452   3.113   5.285  1.00  5.56           C  
ATOM   1206  CD2 PHE A 171       7.360   2.014   4.309  1.00  5.22           C  
ATOM   1207  CE1 PHE A 171       5.869   2.724   6.560  1.00  7.10           C  
ATOM   1208  CE2 PHE A 171       7.788   1.615   5.575  1.00  4.42           C  
ATOM   1209  CZ  PHE A 171       7.031   1.964   6.694  1.00  6.99           C  
ATOM   1210  N   ILE A 172       6.154   6.213   4.323  1.00  6.04           N  
ATOM   1211  CA  ILE A 172       7.061   7.149   4.985  1.00  6.92           C  
ATOM   1212  C   ILE A 172       7.181   6.771   6.462  1.00  4.17           C  
ATOM   1213  O   ILE A 172       6.137   6.602   7.165  1.00  5.32           O  
ATOM   1214  CB  ILE A 172       6.585   8.630   4.788  1.00  7.45           C  
ATOM   1215  CG1 ILE A 172       6.556   8.970   3.296  1.00  9.43           C  
ATOM   1216  CG2 ILE A 172       7.502   9.616   5.544  1.00  7.85           C  
ATOM   1217  CD1 ILE A 172       5.682  10.134   2.944  1.00 11.87           C  
ATOM   1218  N   SER A 173       8.426   6.567   6.897  1.00  5.18           N  
ATOM   1219  CA  SER A 173       8.770   6.039   8.208  1.00  4.13           C  
ATOM   1220  C   SER A 173       9.609   7.043   8.966  1.00  6.06           C  
ATOM   1221  O   SER A 173      10.574   7.585   8.414  1.00  5.46           O  
ATOM   1222  CB  SER A 173       9.541   4.733   8.055  1.00  5.45           C  
ATOM   1223  OG  SER A 173      10.148   4.338   9.258  1.00  5.45           O  
ATOM   1224  N   MET A 174       9.296   7.209  10.244  1.00  4.75           N  
ATOM   1225  CA  MET A 174       9.957   8.191  11.101  0.50  7.30           C  
ATOM   1227  C   MET A 174      10.445   7.462  12.330  1.00  6.90           C  
ATOM   1228  O   MET A 174       9.674   6.736  12.997  1.00  5.94           O  
ATOM   1229  CB  MET A 174       8.994   9.325  11.446  0.50  7.88           C  
ATOM   1231  CG  MET A 174       8.796  10.300  10.295  0.50  9.03           C  
ATOM   1233  SD  MET A 174       7.171  11.059  10.256  0.50  9.52           S  
ATOM   1235  CE  MET A 174       6.145   9.652   9.782  0.50 11.21           C  
ATOM   1237  N   THR A 175      11.742   7.603  12.614  1.00  6.65           N  
ATOM   1238  CA  THR A 175      12.392   6.750  13.591  1.00  5.86           C  
ATOM   1239  C   THR A 175      13.674   7.371  14.107  1.00  5.73           C  
ATOM   1240  O   THR A 175      14.254   8.244  13.453  1.00  7.61           O  
ATOM   1241  CB  THR A 175      12.772   5.348  12.936  1.00  7.89           C  
ATOM   1242  OG1 THR A 175      13.601   4.584  13.815  1.00  7.81           O  
ATOM   1243  CG2 THR A 175      13.500   5.532  11.647  1.00  7.04           C  
ATOM   1244  N   SER A 176      14.119   6.920  15.252  1.00  4.38           N  
ATOM   1245  CA  SER A 176      15.452   7.298  15.770  1.00  7.56           C  
ATOM   1246  C   SER A 176      16.585   6.443  15.125  1.00  8.90           C  
ATOM   1247  O   SER A 176      17.760   6.715  15.356  1.00  8.88           O  
ATOM   1248  CB  SER A 176      15.493   7.102  17.293  1.00  8.77           C  
ATOM   1249  OG  SER A 176      15.130   5.787  17.638  1.00 10.40           O  
ATOM   1250  N   ALA A 177      16.224   5.427  14.328  1.00  6.26           N  
ATOM   1251  CA  ALA A 177      17.234   4.505  13.722  1.00  6.10           C  
ATOM   1252  C   ALA A 177      17.891   5.125  12.479  1.00  7.02           C  
ATOM   1253  O   ALA A 177      17.201   5.437  11.507  1.00  8.22           O  
ATOM   1254  CB  ALA A 177      16.586   3.174  13.372  1.00  6.84           C  
ATOM   1255  N   ALA A 178      19.230   5.291  12.527  1.00  7.25           N  
ATOM   1256  CA  ALA A 178      19.975   5.861  11.412  1.00  7.23           C  
ATOM   1257  C   ALA A 178      20.078   4.835  10.276  1.00  7.98           C  
ATOM   1258  O   ALA A 178      19.857   3.629  10.491  1.00  6.87           O  
ATOM   1259  CB  ALA A 178      21.406   6.299  11.873  1.00  8.73           C  
ATOM   1260  N   PRO A 179      20.386   5.306   9.050  1.00  7.66           N  
ATOM   1261  CA  PRO A 179      20.431   4.407   7.886  1.00  7.28           C  
ATOM   1262  C   PRO A 179      21.351   3.167   8.026  1.00  7.16           C  
ATOM   1263  O   PRO A 179      21.012   2.122   7.480  1.00  7.13           O  
ATOM   1264  CB  PRO A 179      20.908   5.321   6.753  1.00  8.19           C  
ATOM   1265  CG  PRO A 179      20.440   6.677   7.161  1.00  8.55           C  
ATOM   1266  CD  PRO A 179      20.602   6.715   8.640  1.00  7.73           C  
ATOM   1267  N   HIS A 180      22.489   3.256   8.739  1.00  8.16           N  
ATOM   1268  CA  HIS A 180      23.352   2.043   8.883  1.00  6.90           C  
ATOM   1269  C   HIS A 180      22.715   0.931   9.707  1.00  7.70           C  
ATOM   1270  O   HIS A 180      23.250  -0.200   9.754  1.00  8.64           O  
ATOM   1271  CB  HIS A 180      24.763   2.345   9.401  1.00  8.81           C  
ATOM   1272  CG  HIS A 180      24.807   3.128  10.673  1.00 10.36           C  
ATOM   1273  ND1 HIS A 180      25.537   4.286  10.797  1.00 13.75           N  
ATOM   1274  CD2 HIS A 180      24.233   2.916  11.880  1.00 10.40           C  
ATOM   1275  CE1 HIS A 180      25.407   4.757  12.026  1.00 13.15           C  
ATOM   1276  NE2 HIS A 180      24.617   3.948  12.700  1.00 11.87           N  
ATOM   1277  N   PHE A 181      21.600   1.250  10.366  1.00  7.11           N  
ATOM   1278  CA  PHE A 181      20.767   0.209  10.970  1.00  8.39           C  
ATOM   1279  C   PHE A 181      19.485  -0.083  10.212  1.00  8.27           C  
ATOM   1280  O   PHE A 181      19.073  -1.237  10.134  1.00  8.06           O  
ATOM   1281  CB  PHE A 181      20.353   0.581  12.392  1.00  8.69           C  
ATOM   1282  CG  PHE A 181      21.484   0.800  13.342  1.00  9.42           C  
ATOM   1283  CD1 PHE A 181      22.514  -0.131  13.479  1.00  9.75           C  
ATOM   1284  CD2 PHE A 181      21.487   1.901  14.156  1.00  9.41           C  
ATOM   1285  CE1 PHE A 181      23.536   0.094  14.409  1.00  9.49           C  
ATOM   1286  CE2 PHE A 181      22.525   2.126  15.084  1.00 10.84           C  
ATOM   1287  CZ  PHE A 181      23.524   1.238  15.202  1.00 10.90           C  
ATOM   1288  N   ARG A 182      18.807   0.934   9.709  1.00  8.96           N  
ATOM   1289  CA  ARG A 182      17.456   0.734   9.216  1.00  7.98           C  
ATOM   1290  C   ARG A 182      17.343   0.437   7.715  1.00  7.12           C  
ATOM   1291  O   ARG A 182      16.407  -0.194   7.290  1.00  7.38           O  
ATOM   1292  CB  ARG A 182      16.576   1.932   9.609  1.00  7.37           C  
ATOM   1293  CG  ARG A 182      15.085   1.781   9.334  1.00  6.68           C  
ATOM   1294  CD  ARG A 182      14.459   0.574  10.006  1.00  7.99           C  
ATOM   1295  NE  ARG A 182      14.525   0.564  11.468  1.00  6.73           N  
ATOM   1296  CZ  ARG A 182      13.619   1.133  12.276  1.00  6.88           C  
ATOM   1297  NH1 ARG A 182      12.608   1.867  11.793  1.00  4.63           N  
ATOM   1298  NH2 ARG A 182      13.769   1.023  13.595  1.00  6.58           N  
ATOM   1299  N   THR A 183      18.314   0.872   6.918  1.00  7.61           N  
ATOM   1300  CA  THR A 183      18.216   0.691   5.465  1.00  8.84           C  
ATOM   1301  C   THR A 183      18.092  -0.776   5.109  1.00  8.30           C  
ATOM   1302  O   THR A 183      17.318  -1.120   4.240  1.00  7.62           O  
ATOM   1303  CB  THR A 183      19.414   1.362   4.707  1.00  9.33           C  
ATOM   1304  OG1 THR A 183      19.285   2.788   4.814  1.00 11.26           O  
ATOM   1305  CG2 THR A 183      19.452   0.962   3.243  1.00  9.35           C  
ATOM   1306  N   ARG A 184      18.833  -1.632   5.786  1.00  8.93           N  
ATOM   1307  CA  ARG A 184      18.763  -3.086   5.506  1.00  8.69           C  
ATOM   1308  C   ARG A 184      17.358  -3.636   5.587  1.00  8.49           C  
ATOM   1309  O   ARG A 184      17.008  -4.522   4.804  1.00  7.56           O  
ATOM   1310  CB  ARG A 184      19.716  -3.852   6.424  1.00  9.35           C  
ATOM   1311  CG  ARG A 184      19.408  -3.714   7.895  1.00 10.73           C  
ATOM   1312  CD  ARG A 184      20.556  -4.115   8.795  1.00 10.08           C  
ATOM   1313  NE  ARG A 184      20.305  -3.673  10.162  1.00  9.85           N  
ATOM   1314  CZ  ARG A 184      21.066  -3.970  11.211  1.00  8.95           C  
ATOM   1315  NH1 ARG A 184      22.140  -4.761  11.090  1.00 10.73           N  
ATOM   1316  NH2 ARG A 184      20.756  -3.487  12.393  1.00 10.93           N  
ATOM   1317  N   HIS A 185      16.532  -3.125   6.506  1.00  7.51           N  
ATOM   1318  CA  HIS A 185      15.129  -3.569   6.600  1.00  6.60           C  
ATOM   1319  C   HIS A 185      14.280  -3.100   5.423  1.00  7.86           C  
ATOM   1320  O   HIS A 185      13.518  -3.859   4.866  1.00  5.63           O  
ATOM   1321  CB  HIS A 185      14.485  -3.092   7.903  1.00  7.40           C  
ATOM   1322  CG  HIS A 185      15.112  -3.662   9.134  1.00  5.10           C  
ATOM   1323  ND1 HIS A 185      14.823  -4.932   9.594  1.00  6.24           N  
ATOM   1324  CD2 HIS A 185      16.038  -3.161   9.982  1.00  7.15           C  
ATOM   1325  CE1 HIS A 185      15.513  -5.169  10.686  1.00  6.55           C  
ATOM   1326  NE2 HIS A 185      16.261  -4.110  10.949  1.00  6.60           N  
ATOM   1327  N   TYR A 186      14.443  -1.846   5.029  1.00  5.83           N  
ATOM   1328  CA  TYR A 186      13.593  -1.310   3.945  1.00  4.90           C  
ATOM   1329  C   TYR A 186      14.012  -1.683   2.515  1.00  5.58           C  
ATOM   1330  O   TYR A 186      13.208  -1.629   1.600  1.00  5.85           O  
ATOM   1331  CB  TYR A 186      13.500   0.207   4.034  1.00  5.95           C  
ATOM   1332  CG  TYR A 186      12.986   0.744   5.344  1.00  6.25           C  
ATOM   1333  CD1 TYR A 186      12.191  -0.012   6.149  1.00  6.02           C  
ATOM   1334  CD2 TYR A 186      13.298   2.042   5.765  1.00  7.58           C  
ATOM   1335  CE1 TYR A 186      11.697   0.475   7.374  1.00  8.04           C  
ATOM   1336  CE2 TYR A 186      12.795   2.543   6.986  1.00  9.44           C  
ATOM   1337  CZ  TYR A 186      12.017   1.739   7.780  1.00  6.65           C  
ATOM   1338  OH  TYR A 186      11.538   2.151   9.008  1.00  8.21           O  
ATOM   1339  N   ALA A 187      15.271  -2.047   2.352  1.00  6.86           N  
ATOM   1340  CA  ALA A 187      15.852  -2.285   1.046  1.00  8.78           C  
ATOM   1341  C   ALA A 187      15.710  -3.749   0.616  1.00  8.60           C  
ATOM   1342  O   ALA A 187      16.727  -4.465   0.384  1.00  8.43           O  
ATOM   1343  CB  ALA A 187      17.308  -1.895   1.079  1.00  8.96           C  
ATOM   1344  N   GLN A 188      14.472  -4.208   0.534  1.00  6.55           N  
ATOM   1345  CA  GLN A 188      14.161  -5.491  -0.084  1.00  9.26           C  
ATOM   1346  C   GLN A 188      13.474  -5.241  -1.419  1.00  9.61           C  
ATOM   1347  O   GLN A 188      12.489  -4.513  -1.492  1.00  7.88           O  
ATOM   1348  CB  GLN A 188      13.268  -6.335   0.814  1.00  8.81           C  
ATOM   1349  CG  GLN A 188      13.787  -6.544   2.227  1.00  7.27           C  
ATOM   1350  CD  GLN A 188      15.185  -7.223   2.274  1.00  8.45           C  
ATOM   1351  OE1 GLN A 188      15.477  -8.094   1.467  1.00  8.31           O  
ATOM   1352  NE2 GLN A 188      16.029  -6.826   3.244  1.00  8.62           N  
ATOM   1353  N   ALA A 189      14.004  -5.830  -2.497  1.00  9.21           N  
ATOM   1354  CA  ALA A 189      13.450  -5.615  -3.841  1.00  9.18           C  
ATOM   1355  C   ALA A 189      11.974  -5.962  -3.948  1.00  7.16           C  
ATOM   1356  O   ALA A 189      11.233  -5.279  -4.634  1.00  8.11           O  
ATOM   1357  CB  ALA A 189      14.248  -6.429  -4.888  1.00  8.95           C  
ATOM   1358  N   TYR A 190      11.520  -7.013  -3.263  1.00  6.57           N  
ATOM   1359  CA  TYR A 190      10.152  -7.464  -3.497  1.00  5.94           C  
ATOM   1360  C   TYR A 190       9.090  -6.507  -2.949  1.00  8.34           C  
ATOM   1361  O   TYR A 190       7.933  -6.647  -3.304  1.00  7.55           O  
ATOM   1362  CB  TYR A 190       9.934  -8.861  -2.990  1.00  8.14           C  
ATOM   1363  CG  TYR A 190       9.525  -9.025  -1.511  1.00  7.81           C  
ATOM   1364  CD1 TYR A 190       8.216  -9.290  -1.178  1.00  8.63           C  
ATOM   1365  CD2 TYR A 190      10.470  -8.962  -0.466  1.00  7.89           C  
ATOM   1366  CE1 TYR A 190       7.827  -9.478   0.158  1.00  7.35           C  
ATOM   1367  CE2 TYR A 190      10.081  -9.155   0.882  1.00  6.54           C  
ATOM   1368  CZ  TYR A 190       8.757  -9.424   1.169  1.00  7.36           C  
ATOM   1369  OH  TYR A 190       8.328  -9.652   2.457  1.00  6.67           O  
ATOM   1370  N   TYR A 191       9.483  -5.545  -2.105  1.00  5.76           N  
ATOM   1371  CA  TYR A 191       8.517  -4.499  -1.662  1.00  6.68           C  
ATOM   1372  C   TYR A 191       8.126  -3.565  -2.827  1.00  6.75           C  
ATOM   1373  O   TYR A 191       7.097  -2.894  -2.780  1.00  6.73           O  
ATOM   1374  CB  TYR A 191       9.067  -3.679  -0.496  1.00  6.37           C  
ATOM   1375  CG  TYR A 191       9.446  -4.467   0.742  1.00  6.12           C  
ATOM   1376  CD1 TYR A 191       8.705  -5.565   1.176  1.00  6.18           C  
ATOM   1377  CD2 TYR A 191      10.506  -4.090   1.482  1.00  5.06           C  
ATOM   1378  CE1 TYR A 191       9.067  -6.263   2.349  1.00  3.97           C  
ATOM   1379  CE2 TYR A 191      10.882  -4.756   2.647  1.00  3.72           C  
ATOM   1380  CZ  TYR A 191      10.190  -5.841   3.067  1.00  4.70           C  
ATOM   1381  OH  TYR A 191      10.606  -6.478   4.223  1.00  5.39           O  
ATOM   1382  N   GLY A 192       8.992  -3.489  -3.834  1.00  6.90           N  
ATOM   1383  CA  GLY A 192       8.692  -2.749  -5.083  1.00  6.99           C  
ATOM   1384  C   GLY A 192       8.780  -1.242  -4.963  1.00  8.61           C  
ATOM   1385  O   GLY A 192       8.029  -0.520  -5.629  1.00  8.61           O  
ATOM   1386  N   TRP A 193       9.712  -0.756  -4.152  1.00  7.59           N  
ATOM   1387  CA  TRP A 193       9.858   0.670  -3.946  1.00  8.68           C  
ATOM   1388  C   TRP A 193      11.312   1.154  -3.968  1.00  9.23           C  
ATOM   1389  O   TRP A 193      12.220   0.393  -3.715  1.00  9.16           O  
ATOM   1390  CB  TRP A 193       9.125   1.099  -2.627  1.00  7.13           C  
ATOM   1391  CG  TRP A 193       9.539   0.419  -1.329  1.00  8.18           C  
ATOM   1392  CD1 TRP A 193      10.808   0.198  -0.847  1.00  7.44           C  
ATOM   1393  CD2 TRP A 193       8.642  -0.037  -0.300  1.00  5.05           C  
ATOM   1394  NE1 TRP A 193      10.746  -0.415   0.419  1.00  6.60           N  
ATOM   1395  CE2 TRP A 193       9.431  -0.541   0.773  1.00  5.39           C  
ATOM   1396  CE3 TRP A 193       7.248  -0.054  -0.175  1.00  6.15           C  
ATOM   1397  CZ2 TRP A 193       8.855  -1.085   1.936  1.00  5.71           C  
ATOM   1398  CZ3 TRP A 193       6.674  -0.612   0.974  1.00  6.36           C  
ATOM   1399  CH2 TRP A 193       7.479  -1.101   2.020  1.00  6.65           C  
ATOM   1400  N   SER A 194      11.498   2.448  -4.305  1.00  9.20           N  
ATOM   1401  CA  SER A 194      12.753   3.141  -4.096  1.00 10.95           C  
ATOM   1402  C   SER A 194      12.829   3.551  -2.629  1.00 10.37           C  
ATOM   1403  O   SER A 194      11.833   3.424  -1.876  1.00 10.31           O  
ATOM   1404  CB  SER A 194      12.846   4.400  -4.981  1.00 10.37           C  
ATOM   1405  OG  SER A 194      11.724   5.251  -4.751  1.00 12.90           O  
ATOM   1406  N   LEU A 195      13.991   4.060  -2.220  1.00 10.15           N  
ATOM   1407  CA  LEU A 195      14.236   4.457  -0.852  1.00 10.48           C  
ATOM   1408  C   LEU A 195      15.092   5.730  -0.803  1.00 11.45           C  
ATOM   1409  O   LEU A 195      16.191   5.771  -1.392  1.00 10.25           O  
ATOM   1410  CB  LEU A 195      14.930   3.314  -0.106  1.00 10.26           C  
ATOM   1411  CG  LEU A 195      15.365   3.580   1.344  1.00  9.30           C  
ATOM   1412  CD1 LEU A 195      14.169   3.878   2.253  1.00  7.59           C  
ATOM   1413  CD2 LEU A 195      16.160   2.452   1.904  1.00 10.61           C  
ATOM   1414  N   ARG A 196      14.559   6.764  -0.131  1.00  8.35           N  
ATOM   1415  CA  ARG A 196      15.259   8.039   0.124  1.00 13.45           C  
ATOM   1416  C   ARG A 196      15.264   8.300   1.620  1.00 10.31           C  
ATOM   1417  O   ARG A 196      14.427   7.776   2.341  1.00  9.35           O  
ATOM   1418  CB  ARG A 196      14.506   9.205  -0.531  1.00 17.05           C  
ATOM   1419  CG  ARG A 196      14.723   9.410  -1.972  1.00 21.17           C  
ATOM   1420  CD  ARG A 196      14.779  10.930  -2.288  1.00 22.99           C  
ATOM   1421  NE  ARG A 196      13.504  11.643  -2.066  1.00 24.53           N  
ATOM   1422  CZ  ARG A 196      13.236  12.512  -1.071  1.00 24.70           C  
ATOM   1423  NH1 ARG A 196      14.128  12.805  -0.128  1.00 25.18           N  
ATOM   1424  NH2 ARG A 196      12.039  13.085  -1.014  1.00 24.19           N  
ATOM   1425  N   HIS A 197      16.154   9.169   2.083  1.00 11.30           N  
ATOM   1426  CA  HIS A 197      16.277   9.458   3.521  1.00 11.84           C  
ATOM   1427  C   HIS A 197      16.586  10.927   3.779  1.00 10.70           C  
ATOM   1428  O   HIS A 197      17.335  11.562   3.005  1.00 12.07           O  
ATOM   1429  CB  HIS A 197      17.349   8.546   4.146  1.00 12.61           C  
ATOM   1430  CG  HIS A 197      17.918   9.040   5.449  1.00 10.06           C  
ATOM   1431  ND1 HIS A 197      19.129   9.705   5.534  1.00 11.83           N  
ATOM   1432  CD2 HIS A 197      17.465   8.929   6.718  1.00  8.34           C  
ATOM   1433  CE1 HIS A 197      19.391   9.984   6.794  1.00 13.47           C  
ATOM   1434  NE2 HIS A 197      18.402   9.521   7.539  1.00 10.57           N  
ATOM   1435  N   ALA A 198      16.017  11.463   4.860  1.00 11.02           N  
ATOM   1436  CA  ALA A 198      16.336  12.813   5.335  1.00 10.33           C  
ATOM   1437  C   ALA A 198      16.404  12.791   6.858  1.00 10.64           C  
ATOM   1438  O   ALA A 198      15.862  11.874   7.499  1.00 10.32           O  
ATOM   1439  CB  ALA A 198      15.276  13.815   4.841  1.00 11.48           C  
ATOM   1440  N   THR A 199      17.061  13.773   7.467  1.00 13.60           N  
ATOM   1441  CA  THR A 199      17.022  13.914   8.926  1.00 12.65           C  
ATOM   1442  C   THR A 199      16.175  15.129   9.338  1.00 14.28           C  
ATOM   1443  O   THR A 199      15.938  16.058   8.534  1.00 12.33           O  
ATOM   1444  CB  THR A 199      18.421  14.051   9.542  1.00 12.40           C  
ATOM   1445  OG1 THR A 199      19.087  15.134   8.929  1.00 13.78           O  
ATOM   1446  CG2 THR A 199      19.233  12.765   9.339  1.00 15.13           C  
ATOM   1447  N   TYR A 200      15.707  15.091  10.580  1.00 11.34           N  
ATOM   1448  CA  TYR A 200      14.860  16.127  11.129  1.00 12.02           C  
ATOM   1449  C   TYR A 200      14.903  16.100  12.628  1.00 14.53           C  
ATOM   1450  O   TYR A 200      15.555  15.225  13.240  1.00 12.94           O  
ATOM   1451  CB  TYR A 200      13.396  15.946  10.656  1.00  9.29           C  
ATOM   1452  CG  TYR A 200      12.654  14.788  11.336  1.00  9.20           C  
ATOM   1453  CD1 TYR A 200      11.910  14.987  12.484  1.00  9.78           C  
ATOM   1454  CD2 TYR A 200      12.743  13.503  10.838  1.00  8.92           C  
ATOM   1455  CE1 TYR A 200      11.291  13.955  13.107  1.00  8.55           C  
ATOM   1456  CE2 TYR A 200      12.092  12.456  11.448  1.00  7.09           C  
ATOM   1457  CZ  TYR A 200      11.364  12.689  12.582  1.00  9.03           C  
ATOM   1458  OH  TYR A 200      10.737  11.687  13.231  1.00  7.60           O  
ATOM   1459  N   GLY A 201      14.211  17.071  13.214  1.00 15.19           N  
ATOM   1460  CA  GLY A 201      13.877  17.061  14.620  1.00 16.33           C  
ATOM   1461  C   GLY A 201      15.065  17.267  15.534  1.00 15.36           C  
ATOM   1462  O   GLY A 201      16.067  17.888  15.153  1.00 16.29           O  
ATOM   1463  N   SER A 202      14.947  16.721  16.744  1.00 15.93           N  
ATOM   1464  CA  SER A 202      15.898  16.991  17.829  1.00 16.11           C  
ATOM   1465  C   SER A 202      17.351  16.731  17.414  1.00 18.33           C  
ATOM   1466  O   SER A 202      17.723  15.608  17.117  1.00 16.55           O  
ATOM   1467  CB  SER A 202      15.543  16.159  19.059  1.00 18.50           C  
ATOM   1468  OG  SER A 202      16.303  16.560  20.169  1.00 20.36           O  
ATOM   1469  N   GLY A 203      18.165  17.790  17.393  1.00 18.04           N  
ATOM   1470  CA  GLY A 203      19.587  17.710  16.953  1.00 18.04           C  
ATOM   1471  C   GLY A 203      19.803  17.086  15.567  1.00 19.50           C  
ATOM   1472  O   GLY A 203      20.882  16.560  15.265  1.00 19.09           O  
ATOM   1473  N   PHE A 204      18.768  17.160  14.719  1.00 18.23           N  
ATOM   1474  CA  PHE A 204      18.754  16.468  13.411  1.00 19.18           C  
ATOM   1475  C   PHE A 204      19.162  14.990  13.563  1.00 20.19           C  
ATOM   1476  O   PHE A 204      19.875  14.436  12.741  1.00 19.95           O  
ATOM   1477  CB  PHE A 204      19.629  17.229  12.389  1.00 20.20           C  
ATOM   1478  CG  PHE A 204      19.074  18.575  12.023  1.00 21.85           C  
ATOM   1479  CD1 PHE A 204      17.801  18.677  11.468  1.00 22.85           C  
ATOM   1480  CD2 PHE A 204      19.806  19.740  12.236  1.00 19.62           C  
ATOM   1481  CE1 PHE A 204      17.256  19.910  11.126  1.00 22.29           C  
ATOM   1482  CE2 PHE A 204      19.254  21.005  11.894  1.00 21.50           C  
ATOM   1483  CZ  PHE A 204      17.975  21.073  11.339  1.00 20.95           C  
ATOM   1484  N   HIS A 205      18.680  14.376  14.641  1.00 19.16           N  
ATOM   1485  CA  HIS A 205      19.055  13.026  15.007  1.00 18.65           C  
ATOM   1486  C   HIS A 205      17.894  12.053  14.790  1.00 15.70           C  
ATOM   1487  O   HIS A 205      18.029  10.858  15.040  1.00 15.45           O  
ATOM   1488  CB  HIS A 205      19.509  12.988  16.471  1.00 20.81           C  
ATOM   1489  CG  HIS A 205      20.422  11.848  16.787  1.00 23.13           C  
ATOM   1490  N   PHE A 206      16.754  12.565  14.312  1.00 12.45           N  
ATOM   1491  CA  PHE A 206      15.654  11.674  13.873  1.00  9.04           C  
ATOM   1492  C   PHE A 206      15.692  11.523  12.363  1.00  9.39           C  
ATOM   1493  O   PHE A 206      16.214  12.386  11.642  1.00 11.48           O  
ATOM   1494  CB  PHE A 206      14.297  12.180  14.314  1.00 11.29           C  
ATOM   1495  CG  PHE A 206      14.138  12.323  15.808  1.00 11.96           C  
ATOM   1496  CD1 PHE A 206      14.828  11.495  16.711  1.00 12.94           C  
ATOM   1497  CD2 PHE A 206      13.271  13.272  16.320  1.00 11.33           C  
ATOM   1498  CE1 PHE A 206      14.663  11.646  18.091  1.00 13.32           C  
ATOM   1499  CE2 PHE A 206      13.103  13.425  17.710  1.00 13.54           C  
ATOM   1500  CZ  PHE A 206      13.793  12.610  18.584  1.00 13.12           C  
ATOM   1501  N   HIS A 207      15.120  10.424  11.882  1.00  7.87           N  
ATOM   1502  CA  HIS A 207      15.323   9.978  10.515  1.00  8.04           C  
ATOM   1503  C   HIS A 207      14.012   9.751   9.830  1.00  5.81           C  
ATOM   1504  O   HIS A 207      13.123   9.072  10.401  1.00  7.80           O  
ATOM   1505  CB  HIS A 207      16.156   8.682  10.548  1.00  8.98           C  
ATOM   1506  CG  HIS A 207      17.536   8.896  11.054  1.00  7.56           C  
ATOM   1507  ND1 HIS A 207      18.541   9.398  10.249  1.00  8.71           N  
ATOM   1508  CD2 HIS A 207      18.063   8.758  12.290  1.00  9.82           C  
ATOM   1509  CE1 HIS A 207      19.641   9.528  10.971  1.00 10.35           C  
ATOM   1510  NE2 HIS A 207      19.378   9.152  12.212  1.00  9.39           N  
ATOM   1511  N   LEU A 208      13.847  10.311   8.627  1.00  5.67           N  
ATOM   1512  CA  LEU A 208      12.642  10.115   7.855  1.00  6.64           C  
ATOM   1513  C   LEU A 208      13.017   9.336   6.591  1.00  7.43           C  
ATOM   1514  O   LEU A 208      13.958   9.712   5.878  1.00  7.31           O  
ATOM   1515  CB  LEU A 208      11.998  11.465   7.538  1.00  6.32           C  
ATOM   1516  CG  LEU A 208      10.661  11.398   6.790  1.00  9.05           C  
ATOM   1517  CD1 LEU A 208       9.696  12.464   7.311  1.00 11.81           C  
ATOM   1518  CD2 LEU A 208      10.871  11.539   5.300  1.00 11.49           C  
ATOM   1519  N   TYR A 209      12.320   8.237   6.339  1.00  6.86           N  
ATOM   1520  CA  TYR A 209      12.562   7.384   5.146  1.00  5.71           C  
ATOM   1521  C   TYR A 209      11.366   7.444   4.225  1.00  6.22           C  
ATOM   1522  O   TYR A 209      10.237   7.237   4.683  1.00  5.82           O  
ATOM   1523  CB  TYR A 209      12.889   5.927   5.520  1.00  4.96           C  
ATOM   1524  CG  TYR A 209      14.118   5.805   6.388  1.00  5.61           C  
ATOM   1525  CD1 TYR A 209      15.383   5.533   5.829  1.00  6.69           C  
ATOM   1526  CD2 TYR A 209      14.022   5.927   7.787  1.00  5.09           C  
ATOM   1527  CE1 TYR A 209      16.498   5.414   6.606  1.00  6.83           C  
ATOM   1528  CE2 TYR A 209      15.138   5.829   8.595  1.00  5.41           C  
ATOM   1529  CZ  TYR A 209      16.391   5.549   7.996  1.00  5.22           C  
ATOM   1530  OH  TYR A 209      17.516   5.417   8.774  1.00  5.79           O  
ATOM   1531  N   LEU A 210      11.616   7.709   2.935  1.00  7.69           N  
ATOM   1532  CA  LEU A 210      10.583   7.833   1.937  1.00  8.89           C  
ATOM   1533  C   LEU A 210      10.721   6.728   0.911  1.00 10.12           C  
ATOM   1534  O   LEU A 210      11.760   6.609   0.272  1.00  7.55           O  
ATOM   1535  CB  LEU A 210      10.679   9.223   1.270  1.00  9.64           C  
ATOM   1536  CG  LEU A 210       9.812   9.517   0.052  1.00 14.23           C  
ATOM   1537  CD1 LEU A 210       8.374   9.188   0.315  1.00 14.83           C  
ATOM   1538  CD2 LEU A 210       9.946  10.975  -0.354  1.00 16.19           C  
ATOM   1539  N   MET A 211       9.664   5.946   0.758  1.00  7.56           N  
ATOM   1540  CA  MET A 211       9.621   4.827  -0.157  1.00  8.86           C  
ATOM   1541  C   MET A 211       8.493   4.997  -1.150  1.00 10.01           C  
ATOM   1542  O   MET A 211       7.342   5.229  -0.765  1.00 10.53           O  
ATOM   1543  CB  MET A 211       9.492   3.535   0.647  1.00  7.81           C  
ATOM   1544  CG  MET A 211      10.805   3.095   1.245  1.00  9.21           C  
ATOM   1545  SD  MET A 211      10.707   2.215   2.800  1.00  7.28           S  
ATOM   1546  CE  MET A 211      10.396   3.612   3.954  1.00  8.17           C  
ATOM   1547  N   HIS A 212       8.823   4.925  -2.441  1.00  9.02           N  
ATOM   1548  CA  HIS A 212       7.853   5.177  -3.479  1.00 10.49           C  
ATOM   1549  C   HIS A 212       7.706   3.949  -4.333  1.00  8.15           C  
ATOM   1550  O   HIS A 212       8.666   3.519  -5.009  1.00 10.05           O  
ATOM   1551  CB  HIS A 212       8.255   6.368  -4.350  1.00 11.87           C  
ATOM   1552  CG  HIS A 212       7.169   6.808  -5.297  1.00 12.30           C  
ATOM   1553  ND1 HIS A 212       7.393   7.684  -6.338  1.00 17.44           N  
ATOM   1554  CD2 HIS A 212       5.856   6.472  -5.368  1.00 14.94           C  
ATOM   1555  CE1 HIS A 212       6.261   7.878  -6.999  1.00 16.42           C  
ATOM   1556  NE2 HIS A 212       5.317   7.150  -6.436  1.00 17.26           N  
ATOM   1557  N   LYS A 213       6.547   3.341  -4.287  1.00  8.82           N  
ATOM   1558  CA  LYS A 213       6.341   2.142  -5.059  1.00 10.83           C  
ATOM   1559  C   LYS A 213       6.460   2.439  -6.533  1.00 10.75           C  
ATOM   1560  O   LYS A 213       5.933   3.453  -7.019  1.00 12.35           O  
ATOM   1561  CB  LYS A 213       5.010   1.515  -4.765  1.00 11.52           C  
ATOM   1562  CG  LYS A 213       5.056   0.666  -3.492  1.00 12.55           C  
ATOM   1563  CD  LYS A 213       3.729   0.055  -3.148  1.00 13.09           C  
ATOM   1564  CE  LYS A 213       3.288  -0.908  -4.192  1.00 14.86           C  
ATOM   1565  NZ  LYS A 213       2.032  -1.595  -3.819  1.00 14.48           N  
ATOM   1566  N   GLY A 214       7.151   1.553  -7.238  1.00 12.76           N  
ATOM   1567  CA  GLY A 214       7.450   1.725  -8.667  1.00 13.30           C  
ATOM   1568  C   GLY A 214       8.912   2.074  -8.889  1.00 15.88           C  
ATOM   1569  O   GLY A 214       9.443   1.864  -9.974  1.00 15.40           O  
ATOM   1570  N   GLY A 215       9.560   2.616  -7.856  1.00 14.07           N  
ATOM   1571  CA  GLY A 215      10.975   2.885  -7.876  1.00 17.10           C  
ATOM   1572  C   GLY A 215      11.819   1.651  -7.588  1.00 15.78           C  
ATOM   1573  O   GLY A 215      11.294   0.564  -7.273  1.00 14.04           O  
ATOM   1574  N   LYS A 216      13.129   1.841  -7.688  1.00 14.86           N  
ATOM   1575  CA  LYS A 216      14.118   0.798  -7.499  1.00 14.50           C  
ATOM   1576  C   LYS A 216      15.124   1.167  -6.432  1.00 12.47           C  
ATOM   1577  O   LYS A 216      15.426   2.345  -6.233  1.00 14.00           O  
ATOM   1578  CB  LYS A 216      14.867   0.573  -8.819  1.00 16.90           C  
ATOM   1579  CG  LYS A 216      14.021  -0.061  -9.909  1.00 18.59           C  
ATOM   1580  CD  LYS A 216      14.042  -1.573  -9.789  1.00 20.59           C  
ATOM   1581  CE  LYS A 216      13.380  -2.274 -10.988  1.00 22.03           C  
ATOM   1582  NZ  LYS A 216      12.020  -2.812 -10.655  1.00 24.69           N  
ATOM   1583  N   LEU A 217      15.689   0.151  -5.772  1.00 12.41           N  
ATOM   1584  CA  LEU A 217      16.761   0.359  -4.821  1.00 13.00           C  
ATOM   1585  C   LEU A 217      18.113   0.455  -5.530  1.00 14.40           C  
ATOM   1586  O   LEU A 217      18.302  -0.107  -6.618  1.00 19.25           O  
ATOM   1587  CB  LEU A 217      16.802  -0.778  -3.809  1.00 10.05           C  
ATOM   1588  CG  LEU A 217      15.512  -0.932  -3.008  1.00 11.14           C  
ATOM   1589  CD1 LEU A 217      15.452  -2.289  -2.350  1.00 10.06           C  
ATOM   1590  CD2 LEU A 217      15.409   0.181  -1.956  1.00  9.55           C  
ATOM   1591  N   SER A 218      19.046   1.160  -4.901  1.00 12.92           N  
ATOM   1592  CA  SER A 218      20.423   1.217  -5.391  1.00 14.77           C  
ATOM   1593  C   SER A 218      21.134  -0.089  -5.049  1.00 14.36           C  
ATOM   1594  O   SER A 218      20.697  -0.826  -4.167  1.00 15.33           O  
ATOM   1595  CB  SER A 218      21.162   2.390  -4.740  1.00 13.35           C  
ATOM   1596  OG  SER A 218      21.443   2.136  -3.386  1.00 14.34           O  
ATOM   1597  N   VAL A 219      22.253  -0.361  -5.724  1.00 16.80           N  
ATOM   1598  CA  VAL A 219      23.058  -1.544  -5.398  1.00 14.54           C  
ATOM   1599  C   VAL A 219      23.541  -1.482  -3.958  1.00 15.31           C  
ATOM   1600  O   VAL A 219      23.546  -2.488  -3.268  1.00 14.14           O  
ATOM   1601  CB  VAL A 219      24.281  -1.720  -6.371  1.00 16.21           C  
ATOM   1602  CG1 VAL A 219      25.176  -2.856  -5.913  1.00 16.05           C  
ATOM   1603  CG2 VAL A 219      23.805  -1.980  -7.775  1.00 13.87           C  
ATOM   1604  N   ALA A 220      23.933  -0.280  -3.490  1.00 13.96           N  
ATOM   1605  CA  ALA A 220      24.294  -0.112  -2.101  1.00 14.35           C  
ATOM   1606  C   ALA A 220      23.135  -0.564  -1.165  1.00 13.03           C  
ATOM   1607  O   ALA A 220      23.352  -1.301  -0.221  1.00 13.29           O  
ATOM   1608  CB  ALA A 220      24.699   1.347  -1.823  1.00 14.95           C  
ATOM   1609  N   GLN A 221      21.918  -0.087  -1.448  1.00 13.43           N  
ATOM   1610  CA  GLN A 221      20.758  -0.421  -0.607  1.00 12.67           C  
ATOM   1611  C   GLN A 221      20.494  -1.941  -0.626  1.00 11.12           C  
ATOM   1612  O   GLN A 221      20.356  -2.568   0.431  1.00 13.17           O  
ATOM   1613  CB  GLN A 221      19.505   0.388  -1.028  1.00 11.86           C  
ATOM   1614  CG  GLN A 221      19.593   1.895  -0.667  1.00 11.39           C  
ATOM   1615  CD  GLN A 221      18.588   2.788  -1.447  1.00 13.18           C  
ATOM   1616  OE1 GLN A 221      18.092   2.413  -2.475  1.00 11.81           O  
ATOM   1617  NE2 GLN A 221      18.300   3.985  -0.908  1.00 14.15           N  
ATOM   1618  N   LEU A 222      20.491  -2.517  -1.831  1.00 12.40           N  
ATOM   1619  CA  LEU A 222      20.284  -3.972  -2.002  1.00 11.09           C  
ATOM   1620  C   LEU A 222      21.307  -4.852  -1.266  1.00 11.45           C  
ATOM   1621  O   LEU A 222      20.963  -5.876  -0.675  1.00 10.61           O  
ATOM   1622  CB  LEU A 222      20.298  -4.313  -3.474  1.00 11.49           C  
ATOM   1623  CG  LEU A 222      19.074  -3.900  -4.263  1.00 12.21           C  
ATOM   1624  CD1 LEU A 222      19.336  -4.070  -5.696  1.00 13.76           C  
ATOM   1625  CD2 LEU A 222      17.857  -4.708  -3.837  1.00 10.09           C  
ATOM   1626  N   ALA A 223      22.568  -4.431  -1.298  1.00 12.72           N  
ATOM   1627  CA  ALA A 223      23.638  -5.087  -0.534  1.00 13.33           C  
ATOM   1628  C   ALA A 223      23.385  -5.089   0.985  1.00 11.57           C  
ATOM   1629  O   ALA A 223      23.655  -6.059   1.656  1.00 14.04           O  
ATOM   1630  CB  ALA A 223      24.985  -4.432  -0.842  1.00 14.37           C  
ATOM   1631  N   LEU A 224      22.889  -3.960   1.518  1.00 13.04           N  
ATOM   1632  CA  LEU A 224      22.502  -3.892   2.924  1.00 14.53           C  
ATOM   1633  C   LEU A 224      21.277  -4.806   3.192  1.00 11.03           C  
ATOM   1634  O   LEU A 224      21.257  -5.540   4.169  1.00 13.05           O  
ATOM   1635  CB  LEU A 224      22.191  -2.433   3.338  1.00 19.04           C  
ATOM   1636  CG  LEU A 224      23.291  -1.360   3.133  1.00 21.22           C  
ATOM   1637  CD1 LEU A 224      22.745  -0.143   2.396  1.00 21.44           C  
ATOM   1638  CD2 LEU A 224      23.902  -0.943   4.452  1.00 25.32           C  
ATOM   1639  N   GLY A 225      20.288  -4.778   2.291  1.00 11.22           N  
ATOM   1640  CA  GLY A 225      19.086  -5.657   2.454  1.00 10.65           C  
ATOM   1641  C   GLY A 225      19.431  -7.140   2.458  1.00  9.89           C  
ATOM   1642  O   GLY A 225      18.886  -7.930   3.229  1.00 10.06           O  
ATOM   1643  N   ALA A 226      20.416  -7.493   1.624  1.00 11.88           N  
ATOM   1644  CA  ALA A 226      20.927  -8.864   1.543  1.00 12.74           C  
ATOM   1645  C   ALA A 226      21.591  -9.361   2.841  1.00 13.93           C  
ATOM   1646  O   ALA A 226      21.790 -10.570   3.022  1.00 15.23           O  
ATOM   1647  CB  ALA A 226      21.911  -8.986   0.358  1.00 14.86           C  
ATOM   1648  N   GLN A 227      21.917  -8.436   3.749  1.00 14.33           N  
ATOM   1649  CA  GLN A 227      22.533  -8.795   5.033  1.00 14.87           C  
ATOM   1650  C   GLN A 227      21.569  -9.497   5.997  1.00 15.40           C  
ATOM   1651  O   GLN A 227      22.004 -10.252   6.889  1.00 17.67           O  
ATOM   1652  CB  GLN A 227      23.119  -7.546   5.705  1.00 18.76           C  
ATOM   1653  N   ILE A 228      20.267  -9.258   5.830  1.00 12.21           N  
ATOM   1654  CA  ILE A 228      19.262  -9.852   6.720  1.00 11.23           C  
ATOM   1655  C   ILE A 228      18.299 -10.845   6.074  1.00  9.93           C  
ATOM   1656  O   ILE A 228      17.738 -11.709   6.771  1.00 11.94           O  
ATOM   1657  CB  ILE A 228      18.437  -8.767   7.462  1.00 10.57           C  
ATOM   1658  CG1 ILE A 228      17.631  -7.878   6.492  1.00  9.37           C  
ATOM   1659  CG2 ILE A 228      19.339  -7.938   8.332  1.00 13.02           C  
ATOM   1660  CD1 ILE A 228      16.539  -7.034   7.221  1.00 12.66           C  
ATOM   1661  N   LEU A 229      18.096 -10.706   4.758  1.00  9.97           N  
ATOM   1662  CA  LEU A 229      17.248 -11.607   3.974  1.00 11.00           C  
ATOM   1663  C   LEU A 229      17.916 -11.936   2.644  1.00 12.49           C  
ATOM   1664  O   LEU A 229      18.484 -11.058   1.986  1.00 12.26           O  
ATOM   1665  CB  LEU A 229      15.873 -10.974   3.703  1.00 10.75           C  
ATOM   1666  CG  LEU A 229      14.960 -10.767   4.924  1.00 10.80           C  
ATOM   1667  CD1 LEU A 229      13.913  -9.700   4.628  1.00 10.13           C  
ATOM   1668  CD2 LEU A 229      14.309 -12.083   5.380  1.00  9.80           C  
TER    1669      LEU A 229                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
