
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  251 ( 1886),  selected  251 , name 3bus_A
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 3bus_A.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      E       3           -
LGA    -       -      N       4           -
LGA    -       -      K       5           -
LGA    -       -      K       6           -
LGA    -       -      K       7           -
LGA    -       -      F       8           -
LGA    -       -      D       9           -
LGA    -       -      K      10           -
LGA    -       -      K      11           -
LGA    I    23_A      G      12          4.995
LGA    W    24_A      -       -           -
LGA    G    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    N    27_A      A      13           #
LGA    L    28_A      K      14           -
LGA    -       -      N      15           -
LGA    -       -      M      16           -
LGA    -       -      D      17           -
LGA    -       -      E      18           -
LGA    -       -      I      19           -
LGA    H    29_A      S      20           #
LGA    F    30_A      K      21           -
LGA    G    31_A      -       -           -
LGA    Y    32_A      -       -           -
LGA    W    33_A      -       -           -
LGA    E    34_A      -       -           -
LGA    D    35_A      -       -           -
LGA    A    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    A    38_A      -       -           -
LGA    D    39_A      -       -           -
LGA    V    40_A      -       -           -
LGA    S    41_A      -       -           -
LGA    V    42_A      T      22           #
LGA    -       -      L      23           -
LGA    -       -      F      24           -
LGA    D    43_A      A      25          2.876
LGA    D    44_A      P      26          2.559
LGA    A    45_A      I      27          3.981
LGA    T    46_A      Y      28          4.703
LGA    D    47_A      P      29          3.414
LGA    R    48_A      I      30          2.046
LGA    L    49_A      I      31          3.174
LGA    T    50_A      A      32          3.753
LGA    D    51_A      E      33          2.642
LGA    E    52_A      N      34          2.007
LGA    X    53_A      I      35          3.184
LGA    I    54_A      I      36          3.598
LGA    A    55_A      N      37          3.101
LGA    L    56_A      R      38          3.681
LGA    L    57_A      F      39          4.637
LGA    D    58_A      G      40          3.983
LGA    V    59_A      I      41          1.316
LGA    R    60_A      T      42          3.089
LGA    S    61_A      A      43          3.039
LGA    G    62_A      -       -           -
LGA    D    63_A      G      44          0.453
LGA    R    64_A      N      45          0.662
LGA    V    65_A      C      46          0.942
LGA    L    66_A      I      47          1.013
LGA    D    67_A      D      48          0.999
LGA    V    68_A      I      49          0.568
LGA    G    69_A      G      50          0.140
LGA    C    70_A      S      51          0.295
LGA    G    71_A      G      52          0.692
LGA    I    72_A      P      53          0.306
LGA    G    73_A      G      54          0.533
LGA    K    74_A      A      55          0.756
LGA    P    75_A      L      56          0.511
LGA    A    76_A      S      57          0.220
LGA    V    77_A      I      58          0.863
LGA    R    78_A      A      59          0.769
LGA    L    79_A      L      60          0.574
LGA    A    80_A      A      61          0.863
LGA    T    81_A      K      62          0.879
LGA    A    82_A      Q      63          0.867
LGA    R    83_A      S      64          0.995
LGA    D    84_A      D      65          0.347
LGA    V    85_A      F      66          0.974
LGA    R    86_A      S      67          0.472
LGA    V    87_A      I      68          0.313
LGA    T    88_A      R      69          0.392
LGA    G    89_A      A      70          0.704
LGA    I    90_A      L      71          0.875
LGA    S    91_A      D      72          0.893
LGA    I    92_A      F      73          1.544
LGA    S    93_A      S      74          1.328
LGA    R    94_A      K      75          1.027
LGA    P    95_A      H      76          1.972
LGA    Q    96_A      M      77          1.343
LGA    V    97_A      N      78          0.728
LGA    N    98_A      E      79          1.644
LGA    Q    99_A      I      80          1.583
LGA    A   100_A      A      81          1.181
LGA    N   101_A      L      82          1.650
LGA    A   102_A      K      83          1.908
LGA    R   103_A      N      84          1.729
LGA    A   104_A      I      85          1.625
LGA    T   105_A      A      86          1.980
LGA    A   106_A      D      87          2.116
LGA    A   107_A      A      88          2.096
LGA    G   108_A      D      89          2.003
LGA    L   109_A      L      90          1.938
LGA    A   110_A      N      91          1.423
LGA    N   111_A      D      92          1.852
LGA    R   112_A      R      93          2.685
LGA    V   113_A      I      94          0.966
LGA    T   114_A      Q      95          0.967
LGA    F   115_A      I      96          0.346
LGA    S   116_A      V      97          1.903
LGA    Y   117_A      Q      98          1.113
LGA    A   118_A      G      99          0.408
LGA    D   119_A      D     100          0.926
LGA    A   120_A      V     101          0.879
LGA    X   121_A      H     102          1.121
LGA    D   122_A      N     103          1.214
LGA    L   123_A      I     104          1.240
LGA    P   124_A      P     105          1.805
LGA    F   125_A      I     106          1.730
LGA    E   126_A      E     107          1.433
LGA    D   127_A      D     108          1.223
LGA    A   128_A      N     109          1.397
LGA    S   129_A      Y     110          1.736
LGA    F   130_A      A     111          1.602
LGA    D   131_A      D     112          1.716
LGA    A   132_A      L     113          1.780
LGA    V   133_A      I     114          1.131
LGA    W   134_A      V     115          1.446
LGA    A   135_A      S     116          1.589
LGA    L   136_A      R     117          1.323
LGA    E   137_A      G     118          1.514
LGA    S   138_A      S     119          0.751
LGA    L   139_A      V     120          0.898
LGA    H   140_A      F     121          1.039
LGA    H   141_A      F     122          0.906
LGA    X   142_A      W     123          0.729
LGA    P   143_A      E     124          1.044
LGA    D   144_A      D     125          1.831
LGA    R   145_A      V     126          1.541
LGA    G   146_A      T     127          1.404
LGA    R   147_A      T     128          1.086
LGA    A   148_A      A     129          0.704
LGA    L   149_A      F     130          0.911
LGA    R   150_A      R     131          0.599
LGA    E   151_A      E     132          0.325
LGA    X   152_A      I     133          0.564
LGA    A   153_A      Y     134          0.478
LGA    R   154_A      R     135          0.701
LGA    V   155_A      I     136          1.054
LGA    L   156_A      L     137          1.234
LGA    R   157_A      K     138          1.756
LGA    P   158_A      S     139          1.297
LGA    G   159_A      G     140          1.367
LGA    G   160_A      G     141          1.333
LGA    T   161_A      K     142          1.146
LGA    V   162_A      T     143          0.989
LGA    A   163_A      Y     144          0.981
LGA    I   164_A      I     145          1.530
LGA    A   165_A      G     146          1.933
LGA    D   166_A      G     147          3.024
LGA    -       -      G     148           -
LGA    -       -      F     149           -
LGA    -       -      G     150           -
LGA    -       -      N     151           -
LGA    -       -      K     152           -
LGA    -       -      E     153           -
LGA    -       -      L     154           -
LGA    -       -      R     155           -
LGA    -       -      D     156           -
LGA    -       -      S     157           -
LGA    -       -      I     158           -
LGA    -       -      S     159           -
LGA    -       -      A     160           -
LGA    -       -      E     161           -
LGA    -       -      M     162           -
LGA    -       -      I     163           -
LGA    -       -      R     164           -
LGA    -       -      K     165           -
LGA    -       -      N     166           -
LGA    -       -      P     167           -
LGA    -       -      D     168           -
LGA    -       -      W     169           -
LGA    -       -      K     170           -
LGA    -       -      E     171           -
LGA    -       -      F     172           -
LGA    -       -      N     173           -
LGA    -       -      R     174           -
LGA    -       -      K     175           -
LGA    F   167_A      N     176          2.378
LGA    V   168_A      I     177          3.736
LGA    L   169_A      S     178          4.232
LGA    L   170_A      Q     179          3.071
LGA    A   171_A      E     180           #
LGA    P   172_A      -       -           -
LGA    V   173_A      -       -           -
LGA    E   174_A      -       -           -
LGA    G   175_A      -       -           -
LGA    A   176_A      -       -           -
LGA    K   177_A      -       -           -
LGA    K   178_A      -       -           -
LGA    E   179_A      -       -           -
LGA    A   180_A      -       -           -
LGA    V   181_A      -       -           -
LGA    D   182_A      -       -           -
LGA    A   183_A      -       -           -
LGA    F   184_A      -       -           -
LGA    R   185_A      -       -           -
LGA    A   186_A      -       -           -
LGA    G   187_A      -       -           -
LGA    G   188_A      -       -           -
LGA    G   189_A      -       -           -
LGA    V   190_A      -       -           -
LGA    L   191_A      -       -           -
LGA    S   192_A      -       -           -
LGA    L   193_A      -       -           -
LGA    G   194_A      -       -           -
LGA    G   195_A      N     181          2.807
LGA    I   196_A      V     182          0.594
LGA    D   197_A      E     183          2.091
LGA    E   198_A      R     184          2.007
LGA    Y   199_A      F     185          1.292
LGA    E   200_A      Q     186          2.030
LGA    S   201_A      N     187          2.994
LGA    D   202_A      V     188          1.875
LGA    V   203_A      L     189          2.746
LGA    R   204_A      D     190          3.666
LGA    Q   205_A      E     191          3.632
LGA    A   206_A      I     192          3.714
LGA    E   207_A      G     193          4.203
LGA    L   208_A      V     194          3.467
LGA    V   209_A      S     195          3.987
LGA    V   210_A      S     196          3.905
LGA    T   211_A      Y     197          4.150
LGA    S   212_A      E     198          3.188
LGA    T   213_A      I     199          3.043
LGA    V   214_A      I     200          2.614
LGA    D   215_A      L     201          1.664
LGA    I   216_A      E     202          1.675
LGA    S   217_A      D     203          5.303
LGA    A   218_A      -       -           -
LGA    Q   219_A      E     204          5.768
LGA    A   220_A      -       -           -
LGA    R   221_A      -       -           -
LGA    P   222_A      -       -           -
LGA    S   223_A      -       -           -
LGA    L   224_A      -       -           -
LGA    V   225_A      -       -           -
LGA    K   226_A      -       -           -
LGA    T   227_A      -       -           -
LGA    A   228_A      -       -           -
LGA    E   229_A      -       -           -
LGA    A   230_A      -       -           -
LGA    F   231_A      -       -           -
LGA    E   232_A      -       -           -
LGA    N   233_A      -       -           -
LGA    A   234_A      -       -           -
LGA    R   235_A      -       -           -
LGA    S   236_A      -       -           -
LGA    Q   237_A      -       -           -
LGA    V   238_A      -       -           -
LGA    E   239_A      -       -           -
LGA    P   240_A      -       -           -
LGA    F   241_A      -       -           -
LGA    X   242_A      -       -           -
LGA    G   243_A      -       -           -
LGA    A   244_A      -       -           -
LGA    E   245_A      -       -           -
LGA    G   246_A      -       -           -
LGA    L   247_A      -       -           -
LGA    D   248_A      -       -           -
LGA    R   249_A      -       -           -
LGA    X   250_A      -       -           -
LGA    I   251_A      -       -           -
LGA    A   252_A      -       -           -
LGA    T   253_A      -       -           -
LGA    F   254_A      -       -           -
LGA    R   255_A      -       -           -
LGA    G   256_A      -       -           -
LGA    L   257_A      -       -           -
LGA    A   258_A      -       -           -
LGA    E   259_A      -       -           -
LGA    V   260_A      -       -           -
LGA    P   261_A      -       -           -
LGA    E   262_A      -       -           -
LGA    A   263_A      -       -           -
LGA    G   264_A      -       -           -
LGA    Y   265_A      G     205          4.384
LGA    V   266_A      F     206          1.444
LGA    L   267_A      W     207          2.335
LGA    I   268_A      I     208          2.896
LGA    G   269_A      I     209          1.919
LGA    A   270_A      I     210          1.800
LGA    R   271_A      S     211          0.450
LGA    K   272_A      K     212          0.299
LGA    P   273_A      T     213          0.845
LGA    -       -      D     214           -
LGA    -       -      Q     215           -
LGA    -       -      E     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  251  218    5.0    161    2.15    18.63     63.781     7.143

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.819668 * X  +   0.569495 * Y  +   0.061803 * Z  + -28.280710
  Y_new =  -0.571672 * X  +   0.820106 * Y  +   0.024837 * Z  + -13.938193
  Z_new =  -0.036540 * X  +  -0.055689 * Y  +   0.997779 * Z  +  -8.894849 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.055755    3.085838  [ DEG:    -3.1945    176.8055 ]
  Theta =   0.036549    3.105044  [ DEG:     2.0941    177.9059 ]
  Phi   =  -0.609008    2.532584  [ DEG:   -34.8936    145.1064 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bus_A                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bus_A.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  251  218   5.0  161   2.15   18.63  63.781
REMARK  ---------------------------------------------------------- 
MOLECULE 3bus_A
HEADER    TRANSFERASE                             03-JAN-08   3BUS              
TITLE     CRYSTAL STRUCTURE OF REBM                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: METHYLTRANSFERASE;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: REBM;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NOCARDIA AEROCOLONIGENES;                       
SOURCE   3 ORGANISM_COMMON: LECHEVALIERIA AEROCOLONIGENES;                      
SOURCE   4 GENE: RBMF, REBM;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28A                                    
KEYWDS    REBECCAMYCIN SYNTHESIS, METHYLTRANSFERASE, TRANSFERASE                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.G.MCCOY,S.SINGH,C.A.BINGMAN,J.S.THORSON,G.N.PHILLIPS                
REVDAT   1   25-MAR-08 3BUS    0                                                
JRNL        AUTH   J.G.MCCOY,S.SINGH,C.A.BINGMAN,J.S.THORSON,                   
JRNL        AUTH 2 G.N.PHILLIPS                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF REBM                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.65 ANGSTROMS.                                          
DBREF  3BUS A    1   273  UNP    Q8KI52   Q8KI52_NOCAE     1    273             
DBREF  3BUS B    1   273  UNP    Q8KI52   Q8KI52_NOCAE     1    273             
SEQRES   1 A  273  MSE ALA ALA PRO THR PRO GLU GLU VAL ARG GLN MSE TYR          
SEQRES   2 A  273  ASP ASP PHE THR ASP PRO PHE ALA ARG ILE TRP GLY GLU          
SEQRES   3 A  273  ASN LEU HIS PHE GLY TYR TRP GLU ASP ALA GLY ALA ASP          
SEQRES   4 A  273  VAL SER VAL ASP ASP ALA THR ASP ARG LEU THR ASP GLU          
SEQRES   5 A  273  MSE ILE ALA LEU LEU ASP VAL ARG SER GLY ASP ARG VAL          
SEQRES   6 A  273  LEU ASP VAL GLY CYS GLY ILE GLY LYS PRO ALA VAL ARG          
SEQRES   7 A  273  LEU ALA THR ALA ARG ASP VAL ARG VAL THR GLY ILE SER          
SEQRES   8 A  273  ILE SER ARG PRO GLN VAL ASN GLN ALA ASN ALA ARG ALA          
SEQRES   9 A  273  THR ALA ALA GLY LEU ALA ASN ARG VAL THR PHE SER TYR          
SEQRES  10 A  273  ALA ASP ALA MSE ASP LEU PRO PHE GLU ASP ALA SER PHE          
SEQRES  11 A  273  ASP ALA VAL TRP ALA LEU GLU SER LEU HIS HIS MSE PRO          
SEQRES  12 A  273  ASP ARG GLY ARG ALA LEU ARG GLU MSE ALA ARG VAL LEU          
SEQRES  13 A  273  ARG PRO GLY GLY THR VAL ALA ILE ALA ASP PHE VAL LEU          
SEQRES  14 A  273  LEU ALA PRO VAL GLU GLY ALA LYS LYS GLU ALA VAL ASP          
SEQRES  15 A  273  ALA PHE ARG ALA GLY GLY GLY VAL LEU SER LEU GLY GLY          
SEQRES  16 A  273  ILE ASP GLU TYR GLU SER ASP VAL ARG GLN ALA GLU LEU          
SEQRES  17 A  273  VAL VAL THR SER THR VAL ASP ILE SER ALA GLN ALA ARG          
SEQRES  18 A  273  PRO SER LEU VAL LYS THR ALA GLU ALA PHE GLU ASN ALA          
SEQRES  19 A  273  ARG SER GLN VAL GLU PRO PHE MSE GLY ALA GLU GLY LEU          
SEQRES  20 A  273  ASP ARG MSE ILE ALA THR PHE ARG GLY LEU ALA GLU VAL          
SEQRES  21 A  273  PRO GLU ALA GLY TYR VAL LEU ILE GLY ALA ARG LYS PRO          
SEQRES   1 B  273  MSE ALA ALA PRO THR PRO GLU GLU VAL ARG GLN MSE TYR          
SEQRES   2 B  273  ASP ASP PHE THR ASP PRO PHE ALA ARG ILE TRP GLY GLU          
SEQRES   3 B  273  ASN LEU HIS PHE GLY TYR TRP GLU ASP ALA GLY ALA ASP          
SEQRES   4 B  273  VAL SER VAL ASP ASP ALA THR ASP ARG LEU THR ASP GLU          
SEQRES   5 B  273  MSE ILE ALA LEU LEU ASP VAL ARG SER GLY ASP ARG VAL          
SEQRES   6 B  273  LEU ASP VAL GLY CYS GLY ILE GLY LYS PRO ALA VAL ARG          
SEQRES   7 B  273  LEU ALA THR ALA ARG ASP VAL ARG VAL THR GLY ILE SER          
SEQRES   8 B  273  ILE SER ARG PRO GLN VAL ASN GLN ALA ASN ALA ARG ALA          
SEQRES   9 B  273  THR ALA ALA GLY LEU ALA ASN ARG VAL THR PHE SER TYR          
SEQRES  10 B  273  ALA ASP ALA MSE ASP LEU PRO PHE GLU ASP ALA SER PHE          
SEQRES  11 B  273  ASP ALA VAL TRP ALA LEU GLU SER LEU HIS HIS MSE PRO          
SEQRES  12 B  273  ASP ARG GLY ARG ALA LEU ARG GLU MSE ALA ARG VAL LEU          
SEQRES  13 B  273  ARG PRO GLY GLY THR VAL ALA ILE ALA ASP PHE VAL LEU          
SEQRES  14 B  273  LEU ALA PRO VAL GLU GLY ALA LYS LYS GLU ALA VAL ASP          
SEQRES  15 B  273  ALA PHE ARG ALA GLY GLY GLY VAL LEU SER LEU GLY GLY          
SEQRES  16 B  273  ILE ASP GLU TYR GLU SER ASP VAL ARG GLN ALA GLU LEU          
SEQRES  17 B  273  VAL VAL THR SER THR VAL ASP ILE SER ALA GLN ALA ARG          
SEQRES  18 B  273  PRO SER LEU VAL LYS THR ALA GLU ALA PHE GLU ASN ALA          
SEQRES  19 B  273  ARG SER GLN VAL GLU PRO PHE MSE GLY ALA GLU GLY LEU          
SEQRES  20 B  273  ASP ARG MSE ILE ALA THR PHE ARG GLY LEU ALA GLU VAL          
SEQRES  21 B  273  PRO GLU ALA GLY TYR VAL LEU ILE GLY ALA ARG LYS PRO          
HET    MSE  A  53       8                                                       
HET    MSE  A 121       8                                                       
HET    MSE  A 142       8                                                       
HET    MSE  A 152       8                                                       
HET    MSE  A 242       8                                                       
HET    MSE  A 250       8                                                       
HET    MSE  B  53       8                                                       
HET    MSE  B 121       8                                                       
HET    MSE  B 142       8                                                       
HET    MSE  B 152       8                                                       
HET    MSE  B 242       8                                                       
HET    MSE  B 250       8                                                       
HET    SAH  A 274      26                                                       
HET    SAH  B 275      26                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SAH S-ADENOSYL-L-HOMOCYSTEINE                                        
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   3  SAH    2(C14 H20 N6 O5 S)                                           
FORMUL   5  HOH   *6(H2 O)                                                      
CRYST1  119.153  119.153   84.412  90.00  90.00  90.00 P 41 21 2    16          
ATOM      1  N   ILE A  23       6.428   1.261  29.382  1.00 75.84           N  
ATOM      2  CA  ILE A  23       5.821   2.472  30.032  1.00 76.05           C  
ATOM      3  C   ILE A  23       6.431   3.795  29.546  1.00 75.66           C  
ATOM      4  O   ILE A  23       5.840   4.853  29.738  1.00 76.09           O  
ATOM      5  CB  ILE A  23       5.758   2.368  31.643  1.00 76.45           C  
ATOM      6  CG1 ILE A  23       4.661   3.284  32.251  1.00 76.19           C  
ATOM      7  CG2 ILE A  23       7.140   2.566  32.305  1.00 76.50           C  
ATOM      8  CD1 ILE A  23       4.301   2.994  33.744  1.00 75.85           C  
ATOM      9  N   TRP A  24       7.595   3.750  28.906  1.00 75.15           N  
ATOM     10  CA  TRP A  24       8.172   4.981  28.342  1.00 74.51           C  
ATOM     11  C   TRP A  24       7.845   5.070  26.845  1.00 73.86           C  
ATOM     12  O   TRP A  24       8.323   5.962  26.140  1.00 73.43           O  
ATOM     13  CB  TRP A  24       9.689   5.100  28.625  1.00 74.71           C  
ATOM     14  CG  TRP A  24      10.114   4.698  30.045  1.00 75.20           C  
ATOM     15  CD1 TRP A  24       9.349   4.751  31.186  1.00 75.55           C  
ATOM     16  CD2 TRP A  24      11.400   4.203  30.459  1.00 75.43           C  
ATOM     17  NE1 TRP A  24      10.070   4.302  32.270  1.00 75.32           N  
ATOM     18  CE2 TRP A  24      11.330   3.963  31.856  1.00 75.41           C  
ATOM     19  CE3 TRP A  24      12.600   3.931  29.786  1.00 75.42           C  
ATOM     20  CZ2 TRP A  24      12.418   3.469  32.591  1.00 75.23           C  
ATOM     21  CZ3 TRP A  24      13.681   3.429  30.520  1.00 75.31           C  
ATOM     22  CH2 TRP A  24      13.580   3.209  31.908  1.00 75.35           C  
ATOM     23  N   GLY A  25       7.005   4.141  26.384  1.00 73.18           N  
ATOM     24  CA  GLY A  25       6.613   4.053  24.978  1.00 72.36           C  
ATOM     25  C   GLY A  25       5.753   5.221  24.551  1.00 71.62           C  
ATOM     26  O   GLY A  25       6.245   6.193  23.971  1.00 71.60           O  
ATOM     27  N   GLU A  26       4.463   5.124  24.852  1.00 70.97           N  
ATOM     28  CA  GLU A  26       3.523   6.217  24.612  1.00 69.94           C  
ATOM     29  C   GLU A  26       3.706   7.364  25.644  1.00 68.55           C  
ATOM     30  O   GLU A  26       2.742   7.842  26.251  1.00 68.58           O  
ATOM     31  CB  GLU A  26       2.077   5.662  24.559  1.00 70.36           C  
ATOM     32  CG  GLU A  26       0.912   6.687  24.463  1.00 71.53           C  
ATOM     33  CD  GLU A  26       1.153   7.844  23.479  1.00 74.71           C  
ATOM     34  OE1 GLU A  26       1.505   7.601  22.288  1.00 75.48           O  
ATOM     35  OE2 GLU A  26       0.975   9.008  23.919  1.00 75.33           O  
ATOM     36  N   ASN A  27       4.950   7.807  25.829  1.00 66.56           N  
ATOM     37  CA  ASN A  27       5.235   8.924  26.739  1.00 64.61           C  
ATOM     38  C   ASN A  27       6.284   9.907  26.230  1.00 63.12           C  
ATOM     39  O   ASN A  27       6.330  11.054  26.661  1.00 62.75           O  
ATOM     40  CB  ASN A  27       5.602   8.408  28.127  1.00 64.66           C  
ATOM     41  CG  ASN A  27       4.387   8.207  29.010  1.00 64.82           C  
ATOM     42  OD1 ASN A  27       4.320   7.256  29.788  1.00 65.34           O  
ATOM     43  ND2 ASN A  27       3.417   9.108  28.897  1.00 64.78           N  
ATOM     44  N   LEU A  28       7.123   9.431  25.317  1.00 61.40           N  
ATOM     45  CA  LEU A  28       8.080  10.252  24.606  1.00 59.61           C  
ATOM     46  C   LEU A  28       7.681  10.301  23.138  1.00 58.61           C  
ATOM     47  O   LEU A  28       7.479   9.270  22.500  1.00 58.30           O  
ATOM     48  CB  LEU A  28       9.490   9.674  24.753  1.00 59.64           C  
ATOM     49  CG  LEU A  28      10.660  10.281  23.965  1.00 59.52           C  
ATOM     50  CD1 LEU A  28      11.129  11.600  24.563  1.00 57.90           C  
ATOM     51  CD2 LEU A  28      11.805   9.283  23.894  1.00 59.31           C  
ATOM     52  N   HIS A  29       7.549  11.517  22.624  1.00 57.63           N  
ATOM     53  CA  HIS A  29       7.333  11.768  21.204  1.00 56.60           C  
ATOM     54  C   HIS A  29       8.411  12.730  20.798  1.00 55.03           C  
ATOM     55  O   HIS A  29       8.446  13.848  21.295  1.00 55.25           O  
ATOM     56  CB  HIS A  29       5.963  12.401  20.977  1.00 56.93           C  
ATOM     57  CG  HIS A  29       4.865  11.686  21.686  1.00 58.91           C  
ATOM     58  ND1 HIS A  29       4.343  10.495  21.227  1.00 61.01           N  
ATOM     59  CD2 HIS A  29       4.230  11.959  22.851  1.00 60.06           C  
ATOM     60  CE1 HIS A  29       3.418  10.071  22.074  1.00 61.57           C  
ATOM     61  NE2 HIS A  29       3.332  10.941  23.067  1.00 61.61           N  
ATOM     62  N   PHE A  30       9.307  12.291  19.924  1.00 53.31           N  
ATOM     63  CA  PHE A  30      10.396  13.143  19.468  1.00 51.88           C  
ATOM     64  C   PHE A  30       9.863  14.351  18.705  1.00 51.45           C  
ATOM     65  O   PHE A  30       8.782  14.305  18.143  1.00 51.30           O  
ATOM     66  CB  PHE A  30      11.367  12.349  18.605  1.00 51.44           C  
ATOM     67  CG  PHE A  30      12.409  11.605  19.387  1.00 50.09           C  
ATOM     68  CD1 PHE A  30      12.185  10.304  19.802  1.00 50.40           C  
ATOM     69  CD2 PHE A  30      13.625  12.200  19.687  1.00 49.05           C  
ATOM     70  CE1 PHE A  30      13.160   9.607  20.520  1.00 50.84           C  
ATOM     71  CE2 PHE A  30      14.604  11.516  20.401  1.00 49.19           C  
ATOM     72  CZ  PHE A  30      14.374  10.225  20.822  1.00 50.09           C  
ATOM     73  N   GLY A  31      10.605  15.446  18.712  1.00 51.31           N  
ATOM     74  CA  GLY A  31      10.222  16.597  17.913  1.00 51.08           C  
ATOM     75  C   GLY A  31      11.347  17.105  17.042  1.00 51.00           C  
ATOM     76  O   GLY A  31      12.483  16.645  17.147  1.00 50.32           O  
ATOM     77  N   TYR A  32      11.016  18.073  16.191  1.00 51.70           N  
ATOM     78  CA  TYR A  32      11.978  18.728  15.309  1.00 52.03           C  
ATOM     79  C   TYR A  32      12.359  20.059  15.914  1.00 52.51           C  
ATOM     80  O   TYR A  32      11.516  20.933  16.048  1.00 52.31           O  
ATOM     81  CB  TYR A  32      11.352  18.954  13.930  1.00 52.09           C  
ATOM     82  CG  TYR A  32      12.347  19.268  12.837  1.00 51.67           C  
ATOM     83  CD1 TYR A  32      12.750  20.565  12.595  1.00 51.46           C  
ATOM     84  CD2 TYR A  32      12.878  18.255  12.037  1.00 52.01           C  
ATOM     85  CE1 TYR A  32      13.674  20.851  11.604  1.00 52.57           C  
ATOM     86  CE2 TYR A  32      13.800  18.528  11.034  1.00 51.22           C  
ATOM     87  CZ  TYR A  32      14.193  19.828  10.826  1.00 52.11           C  
ATOM     88  OH  TYR A  32      15.108  20.124   9.839  1.00 52.68           O  
ATOM     89  N   TRP A  33      13.628  20.210  16.282  1.00 53.69           N  
ATOM     90  CA  TRP A  33      14.138  21.452  16.895  1.00 55.14           C  
ATOM     91  C   TRP A  33      15.221  22.062  16.004  1.00 56.61           C  
ATOM     92  O   TRP A  33      16.088  21.340  15.511  1.00 57.18           O  
ATOM     93  CB  TRP A  33      14.722  21.173  18.282  1.00 54.30           C  
ATOM     94  CG  TRP A  33      13.792  20.443  19.207  1.00 53.68           C  
ATOM     95  CD1 TRP A  33      13.504  19.108  19.204  1.00 52.24           C  
ATOM     96  CD2 TRP A  33      13.032  21.012  20.278  1.00 53.64           C  
ATOM     97  NE1 TRP A  33      12.609  18.813  20.194  1.00 51.27           N  
ATOM     98  CE2 TRP A  33      12.305  19.959  20.877  1.00 52.29           C  
ATOM     99  CE3 TRP A  33      12.895  22.312  20.791  1.00 52.21           C  
ATOM    100  CZ2 TRP A  33      11.449  20.164  21.963  1.00 52.50           C  
ATOM    101  CZ3 TRP A  33      12.044  22.512  21.867  1.00 52.33           C  
ATOM    102  CH2 TRP A  33      11.327  21.443  22.439  1.00 52.60           C  
ATOM    103  N   GLU A  34      15.189  23.377  15.802  1.00 57.99           N  
ATOM    104  CA  GLU A  34      16.041  23.989  14.785  1.00 59.55           C  
ATOM    105  C   GLU A  34      16.925  25.107  15.307  1.00 60.36           C  
ATOM    106  O   GLU A  34      18.036  25.317  14.810  1.00 60.64           O  
ATOM    107  CB  GLU A  34      15.183  24.520  13.636  1.00 59.68           C  
ATOM    108  CG  GLU A  34      15.945  24.739  12.332  1.00 60.24           C  
ATOM    109  CD  GLU A  34      15.041  25.190  11.199  1.00 60.27           C  
ATOM    110  OE1 GLU A  34      14.001  24.533  10.956  1.00 60.41           O  
ATOM    111  OE2 GLU A  34      15.383  26.207  10.554  1.00 61.09           O  
ATOM    112  N   ASP A  35      16.438  25.816  16.317  1.00 61.34           N  
ATOM    113  CA  ASP A  35      17.069  27.061  16.732  1.00 62.33           C  
ATOM    114  C   ASP A  35      18.362  26.922  17.532  1.00 62.71           C  
ATOM    115  O   ASP A  35      19.338  27.633  17.255  1.00 62.72           O  
ATOM    116  CB  ASP A  35      16.068  27.931  17.499  1.00 62.58           C  
ATOM    117  CG  ASP A  35      15.289  28.859  16.588  1.00 63.04           C  
ATOM    118  OD1 ASP A  35      15.841  29.916  16.214  1.00 62.98           O  
ATOM    119  OD2 ASP A  35      14.123  28.535  16.262  1.00 63.56           O  
ATOM    120  N   ALA A  36      18.360  26.004  18.505  1.00 63.05           N  
ATOM    121  CA  ALA A  36      19.323  26.009  19.631  1.00 63.21           C  
ATOM    122  C   ALA A  36      19.044  27.157  20.617  1.00 63.22           C  
ATOM    123  O   ALA A  36      19.637  27.210  21.699  1.00 63.29           O  
ATOM    124  CB  ALA A  36      20.801  26.044  19.143  1.00 63.17           C  
ATOM    125  N   GLY A  37      18.128  28.054  20.243  1.00 63.26           N  
ATOM    126  CA  GLY A  37      17.853  29.281  21.005  1.00 63.20           C  
ATOM    127  C   GLY A  37      16.510  29.950  20.735  1.00 62.96           C  
ATOM    128  O   GLY A  37      16.454  31.163  20.500  1.00 62.76           O  
ATOM    129  N   ALA A  38      15.436  29.152  20.752  1.00 62.63           N  
ATOM    130  CA  ALA A  38      14.058  29.665  20.795  1.00 62.20           C  
ATOM    131  C   ALA A  38      13.212  28.828  21.752  1.00 61.81           C  
ATOM    132  O   ALA A  38      13.168  27.593  21.650  1.00 61.87           O  
ATOM    133  CB  ALA A  38      13.426  29.703  19.406  1.00 62.20           C  
ATOM    134  N   ASP A  39      12.546  29.513  22.680  1.00 61.12           N  
ATOM    135  CA  ASP A  39      11.695  28.858  23.666  1.00 60.55           C  
ATOM    136  C   ASP A  39      10.368  28.396  23.072  1.00 60.17           C  
ATOM    137  O   ASP A  39       9.328  29.034  23.264  1.00 60.25           O  
ATOM    138  CB  ASP A  39      11.471  29.760  24.885  1.00 60.40           C  
ATOM    139  CG  ASP A  39      12.590  29.647  25.911  1.00 60.24           C  
ATOM    140  OD1 ASP A  39      13.143  28.536  26.082  1.00 58.58           O  
ATOM    141  OD2 ASP A  39      12.911  30.674  26.553  1.00 60.18           O  
ATOM    142  N   VAL A  40      10.427  27.284  22.343  1.00 59.54           N  
ATOM    143  CA  VAL A  40       9.229  26.630  21.815  1.00 59.04           C  
ATOM    144  C   VAL A  40       8.879  25.409  22.678  1.00 58.32           C  
ATOM    145  O   VAL A  40       9.766  24.779  23.261  1.00 58.03           O  
ATOM    146  CB  VAL A  40       9.357  26.291  20.286  1.00 59.27           C  
ATOM    147  CG1 VAL A  40       9.542  27.585  19.481  1.00 59.39           C  
ATOM    148  CG2 VAL A  40      10.511  25.343  20.003  1.00 58.84           C  
ATOM    149  N   SER A  41       7.587  25.103  22.786  1.00 57.55           N  
ATOM    150  CA  SER A  41       7.130  24.037  23.677  1.00 56.90           C  
ATOM    151  C   SER A  41       7.447  22.657  23.110  1.00 56.64           C  
ATOM    152  O   SER A  41       7.822  22.527  21.949  1.00 56.81           O  
ATOM    153  CB  SER A  41       5.632  24.170  23.981  1.00 56.77           C  
ATOM    154  OG  SER A  41       4.846  23.924  22.832  1.00 56.30           O  
ATOM    155  N   VAL A  42       7.304  21.629  23.943  1.00 56.26           N  
ATOM    156  CA  VAL A  42       7.494  20.245  23.512  1.00 55.68           C  
ATOM    157  C   VAL A  42       6.418  19.871  22.490  1.00 55.55           C  
ATOM    158  O   VAL A  42       6.645  19.052  21.599  1.00 55.75           O  
ATOM    159  CB  VAL A  42       7.619  19.264  24.741  1.00 55.55           C  
ATOM    160  CG1 VAL A  42       6.606  18.128  24.721  1.00 55.21           C  
ATOM    161  CG2 VAL A  42       9.026  18.719  24.833  1.00 55.12           C  
ATOM    162  N   ASP A  43       5.268  20.525  22.606  1.00 55.30           N  
ATOM    163  CA  ASP A  43       4.143  20.310  21.711  1.00 55.22           C  
ATOM    164  C   ASP A  43       4.359  21.001  20.366  1.00 55.24           C  
ATOM    165  O   ASP A  43       3.896  20.515  19.323  1.00 55.15           O  
ATOM    166  CB  ASP A  43       2.862  20.784  22.395  1.00 55.11           C  
ATOM    167  CG  ASP A  43       2.533  19.953  23.627  1.00 55.20           C  
ATOM    168  OD1 ASP A  43       2.316  18.726  23.457  1.00 54.92           O  
ATOM    169  OD2 ASP A  43       2.507  20.509  24.756  1.00 53.69           O  
ATOM    170  N   ASP A  44       5.086  22.120  20.407  1.00 55.12           N  
ATOM    171  CA  ASP A  44       5.517  22.826  19.206  1.00 55.09           C  
ATOM    172  C   ASP A  44       6.465  21.975  18.364  1.00 54.91           C  
ATOM    173  O   ASP A  44       6.257  21.833  17.160  1.00 55.33           O  
ATOM    174  CB  ASP A  44       6.194  24.147  19.571  1.00 55.45           C  
ATOM    175  CG  ASP A  44       5.206  25.222  19.997  1.00 56.21           C  
ATOM    176  OD1 ASP A  44       3.977  25.012  19.817  1.00 56.44           O  
ATOM    177  OD2 ASP A  44       5.669  26.277  20.506  1.00 55.86           O  
ATOM    178  N   ALA A  45       7.490  21.401  18.995  1.00 54.36           N  
ATOM    179  CA  ALA A  45       8.481  20.596  18.277  1.00 54.02           C  
ATOM    180  C   ALA A  45       7.911  19.298  17.712  1.00 54.19           C  
ATOM    181  O   ALA A  45       8.321  18.858  16.628  1.00 53.84           O  
ATOM    182  CB  ALA A  45       9.655  20.305  19.143  1.00 53.57           C  
ATOM    183  N   THR A  46       6.988  18.685  18.453  1.00 54.30           N  
ATOM    184  CA  THR A  46       6.312  17.478  17.987  1.00 54.81           C  
ATOM    185  C   THR A  46       5.463  17.784  16.738  1.00 54.96           C  
ATOM    186  O   THR A  46       5.466  17.002  15.790  1.00 54.73           O  
ATOM    187  CB  THR A  46       5.442  16.799  19.098  1.00 54.92           C  
ATOM    188  OG1 THR A  46       6.205  16.641  20.299  1.00 55.75           O  
ATOM    189  CG2 THR A  46       4.956  15.428  18.658  1.00 53.40           C  
ATOM    190  N   ASP A  47       4.754  18.916  16.746  1.00 55.35           N  
ATOM    191  CA  ASP A  47       3.922  19.320  15.603  1.00 55.95           C  
ATOM    192  C   ASP A  47       4.762  19.593  14.344  1.00 56.35           C  
ATOM    193  O   ASP A  47       4.378  19.236  13.219  1.00 56.99           O  
ATOM    194  CB  ASP A  47       3.089  20.563  15.941  1.00 55.89           C  
ATOM    195  CG  ASP A  47       1.900  20.261  16.855  1.00 56.33           C  
ATOM    196  OD1 ASP A  47       1.415  19.110  16.877  1.00 56.39           O  
ATOM    197  OD2 ASP A  47       1.432  21.199  17.544  1.00 56.81           O  
ATOM    198  N   ARG A  48       5.910  20.227  14.531  1.00 56.07           N  
ATOM    199  CA  ARG A  48       6.801  20.472  13.417  1.00 56.14           C  
ATOM    200  C   ARG A  48       7.241  19.158  12.750  1.00 55.96           C  
ATOM    201  O   ARG A  48       7.305  19.075  11.517  1.00 56.11           O  
ATOM    202  CB  ARG A  48       8.014  21.273  13.885  1.00 56.13           C  
ATOM    203  CG  ARG A  48       8.459  22.290  12.890  1.00 56.92           C  
ATOM    204  CD  ARG A  48       9.407  21.702  11.853  1.00 59.71           C  
ATOM    205  NE  ARG A  48       9.662  22.628  10.746  1.00 60.80           N  
ATOM    206  CZ  ARG A  48      10.185  23.846  10.883  1.00 61.70           C  
ATOM    207  NH1 ARG A  48      10.506  24.326  12.082  1.00 62.39           N  
ATOM    208  NH2 ARG A  48      10.376  24.602   9.815  1.00 63.30           N  
ATOM    209  N   LEU A  49       7.540  18.142  13.563  1.00 55.29           N  
ATOM    210  CA  LEU A  49       8.030  16.880  13.046  1.00 54.96           C  
ATOM    211  C   LEU A  49       6.953  16.253  12.189  1.00 54.91           C  
ATOM    212  O   LEU A  49       7.224  15.820  11.058  1.00 54.82           O  
ATOM    213  CB  LEU A  49       8.419  15.926  14.173  1.00 55.05           C  
ATOM    214  CG  LEU A  49       8.839  14.502  13.761  1.00 54.59           C  
ATOM    215  CD1 LEU A  49       9.937  14.461  12.690  1.00 54.91           C  
ATOM    216  CD2 LEU A  49       9.301  13.767  14.971  1.00 54.49           C  
ATOM    217  N   THR A  50       5.736  16.231  12.739  1.00 54.39           N  
ATOM    218  CA  THR A  50       4.536  15.805  12.030  1.00 53.89           C  
ATOM    219  C   THR A  50       4.422  16.540  10.688  1.00 53.75           C  
ATOM    220  O   THR A  50       4.240  15.899   9.660  1.00 53.66           O  
ATOM    221  CB  THR A  50       3.269  15.974  12.923  1.00 53.83           C  
ATOM    222  OG1 THR A  50       3.423  15.184  14.110  1.00 53.64           O  
ATOM    223  CG2 THR A  50       1.984  15.534  12.199  1.00 52.55           C  
ATOM    224  N   ASP A  51       4.574  17.865  10.699  1.00 53.60           N  
ATOM    225  CA  ASP A  51       4.625  18.664   9.461  1.00 53.88           C  
ATOM    226  C   ASP A  51       5.640  18.188   8.394  1.00 53.90           C  
ATOM    227  O   ASP A  51       5.338  18.215   7.204  1.00 53.46           O  
ATOM    228  CB  ASP A  51       4.840  20.150   9.770  1.00 53.68           C  
ATOM    229  CG  ASP A  51       3.607  20.817  10.370  1.00 54.10           C  
ATOM    230  OD1 ASP A  51       2.484  20.308  10.158  1.00 54.19           O  
ATOM    231  OD2 ASP A  51       3.761  21.862  11.051  1.00 54.50           O  
ATOM    232  N   GLU A  52       6.837  17.773   8.808  1.00 54.24           N  
ATOM    233  CA  GLU A  52       7.775  17.134   7.866  1.00 54.45           C  
ATOM    234  C   GLU A  52       7.206  15.814   7.299  1.00 54.37           C  
ATOM    235  O   GLU A  52       7.381  15.512   6.104  1.00 55.28           O  
ATOM    236  CB  GLU A  52       9.145  16.881   8.503  1.00 54.42           C  
ATOM    237  CG  GLU A  52       9.857  18.127   8.993  1.00 55.77           C  
ATOM    238  CD  GLU A  52      10.172  19.120   7.876  1.00 57.83           C  
ATOM    239  OE1 GLU A  52      10.790  18.716   6.849  1.00 56.34           O  
ATOM    240  OE2 GLU A  52       9.810  20.315   8.045  1.00 59.59           O  
HETATM  241  N   MSE A  53       6.514  15.040   8.129  1.00 53.03           N  
HETATM  242  CA  MSE A  53       5.925  13.810   7.639  1.00 52.61           C  
HETATM  243  C   MSE A  53       4.776  14.064   6.661  1.00 52.57           C  
HETATM  244  O   MSE A  53       4.570  13.274   5.724  1.00 52.80           O  
HETATM  245  CB  MSE A  53       5.506  12.888   8.790  1.00 52.03           C  
HETATM  246  CG  MSE A  53       6.706  12.330   9.536  1.00 50.30           C  
HETATM  247 SE   MSE A  53       7.629  10.922   8.584  1.00 46.09          SE  
HETATM  248  CE  MSE A  53       6.275   9.583   9.010  1.00 44.19           C  
ATOM    249  N   ILE A  54       4.041  15.158   6.869  1.00 52.34           N  
ATOM    250  CA  ILE A  54       2.900  15.500   6.000  1.00 51.94           C  
ATOM    251  C   ILE A  54       3.422  15.840   4.613  1.00 52.35           C  
ATOM    252  O   ILE A  54       2.893  15.372   3.599  1.00 52.43           O  
ATOM    253  CB  ILE A  54       2.035  16.640   6.578  1.00 51.87           C  
ATOM    254  CG1 ILE A  54       1.323  16.168   7.860  1.00 51.55           C  
ATOM    255  CG2 ILE A  54       1.013  17.124   5.559  1.00 50.59           C  
ATOM    256  CD1 ILE A  54       0.699  17.306   8.672  1.00 51.23           C  
ATOM    257  N   ALA A  55       4.498  16.619   4.591  1.00 52.67           N  
ATOM    258  CA  ALA A  55       5.177  16.994   3.364  1.00 53.00           C  
ATOM    259  C   ALA A  55       5.818  15.792   2.669  1.00 53.45           C  
ATOM    260  O   ALA A  55       6.001  15.803   1.458  1.00 53.22           O  
ATOM    261  CB  ALA A  55       6.225  18.048   3.659  1.00 52.56           C  
ATOM    262  N   LEU A  56       6.169  14.763   3.434  1.00 54.00           N  
ATOM    263  CA  LEU A  56       6.968  13.678   2.874  1.00 54.25           C  
ATOM    264  C   LEU A  56       6.101  12.592   2.244  1.00 54.51           C  
ATOM    265  O   LEU A  56       6.495  12.018   1.219  1.00 54.62           O  
ATOM    266  CB  LEU A  56       7.961  13.131   3.900  1.00 54.32           C  
ATOM    267  CG  LEU A  56       8.919  12.038   3.429  1.00 54.15           C  
ATOM    268  CD1 LEU A  56      10.001  12.602   2.511  1.00 51.96           C  
ATOM    269  CD2 LEU A  56       9.518  11.319   4.655  1.00 54.00           C  
ATOM    270  N   LEU A  57       4.933  12.315   2.850  1.00 55.00           N  
ATOM    271  CA  LEU A  57       3.780  11.747   2.111  1.00 55.12           C  
ATOM    272  C   LEU A  57       3.531  12.744   0.999  1.00 55.86           C  
ATOM    273  O   LEU A  57       3.988  13.897   1.093  1.00 56.76           O  
ATOM    274  CB  LEU A  57       2.535  11.669   2.980  1.00 54.55           C  
ATOM    275  CG  LEU A  57       2.317  10.458   3.894  1.00 54.60           C  
ATOM    276  CD1 LEU A  57       0.866  10.414   4.404  1.00 52.11           C  
ATOM    277  CD2 LEU A  57       2.677   9.155   3.197  1.00 54.02           C  
ATOM    278  N   ASP A  58       2.848  12.358  -0.065  1.00 55.68           N  
ATOM    279  CA  ASP A  58       2.685  13.336  -1.141  1.00 55.76           C  
ATOM    280  C   ASP A  58       1.253  13.329  -1.617  1.00 55.42           C  
ATOM    281  O   ASP A  58       0.934  12.906  -2.730  1.00 55.54           O  
ATOM    282  CB  ASP A  58       3.690  13.108  -2.280  1.00 56.05           C  
ATOM    283  CG  ASP A  58       3.677  14.233  -3.304  1.00 56.88           C  
ATOM    284  OD1 ASP A  58       3.174  15.332  -2.982  1.00 57.70           O  
ATOM    285  OD2 ASP A  58       4.165  14.018  -4.433  1.00 57.21           O  
ATOM    286  N   VAL A  59       0.401  13.854  -0.757  1.00 54.88           N  
ATOM    287  CA  VAL A  59      -0.999  13.508  -0.779  1.00 54.38           C  
ATOM    288  C   VAL A  59      -1.921  14.651  -1.285  1.00 54.17           C  
ATOM    289  O   VAL A  59      -1.654  15.845  -1.062  1.00 53.90           O  
ATOM    290  CB  VAL A  59      -1.367  12.921   0.624  1.00 54.26           C  
ATOM    291  CG1 VAL A  59      -1.817  14.007   1.610  1.00 53.84           C  
ATOM    292  CG2 VAL A  59      -2.363  11.831   0.488  1.00 54.80           C  
ATOM    293  N   ARG A  60      -2.988  14.285  -1.996  1.00 53.80           N  
ATOM    294  CA  ARG A  60      -3.907  15.300  -2.524  1.00 53.44           C  
ATOM    295  C   ARG A  60      -5.393  15.011  -2.269  1.00 53.15           C  
ATOM    296  O   ARG A  60      -5.776  13.875  -1.976  1.00 53.06           O  
ATOM    297  CB  ARG A  60      -3.636  15.594  -4.007  1.00 53.24           C  
ATOM    298  CG  ARG A  60      -3.989  14.485  -4.964  1.00 53.32           C  
ATOM    299  CD  ARG A  60      -4.349  15.085  -6.317  1.00 54.57           C  
ATOM    300  NE  ARG A  60      -4.504  14.093  -7.375  1.00 54.11           N  
ATOM    301  CZ  ARG A  60      -5.461  14.133  -8.294  1.00 55.08           C  
ATOM    302  NH1 ARG A  60      -6.357  15.113  -8.281  1.00 55.48           N  
ATOM    303  NH2 ARG A  60      -5.534  13.189  -9.225  1.00 55.32           N  
ATOM    304  N   SER A  61      -6.203  16.064  -2.385  1.00 52.72           N  
ATOM    305  CA  SER A  61      -7.638  16.026  -2.110  1.00 52.55           C  
ATOM    306  C   SER A  61      -8.276  14.721  -2.579  1.00 52.53           C  
ATOM    307  O   SER A  61      -8.299  14.429  -3.780  1.00 52.56           O  
ATOM    308  CB  SER A  61      -8.326  17.231  -2.767  1.00 52.47           C  
ATOM    309  OG  SER A  61      -9.700  17.305  -2.432  1.00 52.19           O  
ATOM    310  N   GLY A  62      -8.754  13.926  -1.620  1.00 52.29           N  
ATOM    311  CA  GLY A  62      -9.493  12.700  -1.919  1.00 51.97           C  
ATOM    312  C   GLY A  62      -8.776  11.378  -1.706  1.00 51.85           C  
ATOM    313  O   GLY A  62      -9.375  10.321  -1.890  1.00 51.90           O  
ATOM    314  N   ASP A  63      -7.504  11.421  -1.319  1.00 51.90           N  
ATOM    315  CA  ASP A  63      -6.731  10.191  -1.082  1.00 52.20           C  
ATOM    316  C   ASP A  63      -7.108   9.476   0.230  1.00 52.34           C  
ATOM    317  O   ASP A  63      -7.769  10.045   1.099  1.00 52.58           O  
ATOM    318  CB  ASP A  63      -5.220  10.478  -1.094  1.00 52.19           C  
ATOM    319  CG  ASP A  63      -4.708  10.956  -2.449  1.00 52.23           C  
ATOM    320  OD1 ASP A  63      -5.481  11.018  -3.432  1.00 52.74           O  
ATOM    321  OD2 ASP A  63      -3.506  11.285  -2.522  1.00 52.40           O  
ATOM    322  N   ARG A  64      -6.685   8.221   0.363  1.00 52.26           N  
ATOM    323  CA  ARG A  64      -6.901   7.457   1.588  1.00 52.11           C  
ATOM    324  C   ARG A  64      -5.548   7.155   2.204  1.00 51.62           C  
ATOM    325  O   ARG A  64      -4.616   6.785   1.487  1.00 52.20           O  
ATOM    326  CB  ARG A  64      -7.650   6.164   1.280  1.00 52.23           C  
ATOM    327  CG  ARG A  64      -8.937   6.375   0.480  1.00 53.83           C  
ATOM    328  CD  ARG A  64      -9.364   5.098  -0.251  1.00 56.02           C  
ATOM    329  NE  ARG A  64     -10.447   5.308  -1.218  1.00 57.26           N  
ATOM    330  CZ  ARG A  64     -11.734   5.453  -0.904  1.00 58.41           C  
ATOM    331  NH1 ARG A  64     -12.124   5.441   0.370  1.00 59.20           N  
ATOM    332  NH2 ARG A  64     -12.637   5.623  -1.868  1.00 58.68           N  
ATOM    333  N   VAL A  65      -5.434   7.325   3.521  1.00 50.69           N  
ATOM    334  CA  VAL A  65      -4.169   7.128   4.225  1.00 49.85           C  
ATOM    335  C   VAL A  65      -4.284   6.137   5.396  1.00 49.92           C  
ATOM    336  O   VAL A  65      -5.150   6.282   6.271  1.00 50.24           O  
ATOM    337  CB  VAL A  65      -3.625   8.451   4.793  1.00 49.84           C  
ATOM    338  CG1 VAL A  65      -2.218   8.244   5.349  1.00 49.49           C  
ATOM    339  CG2 VAL A  65      -3.643   9.569   3.741  1.00 49.11           C  
ATOM    340  N   LEU A  66      -3.401   5.139   5.406  1.00 49.28           N  
ATOM    341  CA  LEU A  66      -3.215   4.250   6.548  1.00 48.12           C  
ATOM    342  C   LEU A  66      -2.087   4.779   7.441  1.00 48.13           C  
ATOM    343  O   LEU A  66      -1.033   5.189   6.954  1.00 47.73           O  
ATOM    344  CB  LEU A  66      -2.895   2.835   6.073  1.00 47.97           C  
ATOM    345  CG  LEU A  66      -2.625   1.747   7.116  1.00 47.51           C  
ATOM    346  CD1 LEU A  66      -3.874   1.477   7.940  1.00 46.22           C  
ATOM    347  CD2 LEU A  66      -2.131   0.467   6.462  1.00 47.11           C  
ATOM    348  N   ASP A  67      -2.340   4.766   8.750  1.00 48.32           N  
ATOM    349  CA  ASP A  67      -1.414   5.236   9.779  1.00 48.23           C  
ATOM    350  C   ASP A  67      -1.197   4.075  10.726  1.00 48.09           C  
ATOM    351  O   ASP A  67      -2.131   3.609  11.349  1.00 48.62           O  
ATOM    352  CB  ASP A  67      -2.060   6.404  10.508  1.00 48.36           C  
ATOM    353  CG  ASP A  67      -1.346   6.792  11.796  1.00 49.28           C  
ATOM    354  OD1 ASP A  67      -0.087   6.731  11.908  1.00 50.77           O  
ATOM    355  OD2 ASP A  67      -2.076   7.229  12.702  1.00 50.29           O  
ATOM    356  N   VAL A  68       0.033   3.590  10.815  1.00 48.08           N  
ATOM    357  CA  VAL A  68       0.324   2.346  11.533  1.00 47.78           C  
ATOM    358  C   VAL A  68       0.961   2.691  12.880  1.00 48.05           C  
ATOM    359  O   VAL A  68       2.024   3.309  12.923  1.00 48.25           O  
ATOM    360  CB  VAL A  68       1.266   1.438  10.695  1.00 47.71           C  
ATOM    361  CG1 VAL A  68       1.549   0.134  11.403  1.00 47.30           C  
ATOM    362  CG2 VAL A  68       0.683   1.185   9.321  1.00 46.91           C  
ATOM    363  N   GLY A  69       0.314   2.300  13.975  1.00 48.10           N  
ATOM    364  CA  GLY A  69       0.716   2.774  15.295  1.00 48.31           C  
ATOM    365  C   GLY A  69       0.291   4.223  15.525  1.00 48.80           C  
ATOM    366  O   GLY A  69       1.139   5.114  15.759  1.00 48.06           O  
ATOM    367  N   CYS A  70      -1.031   4.437  15.467  1.00 48.81           N  
ATOM    368  CA  CYS A  70      -1.694   5.739  15.670  1.00 48.83           C  
ATOM    369  C   CYS A  70      -1.562   6.366  17.082  1.00 49.11           C  
ATOM    370  O   CYS A  70      -1.829   7.566  17.260  1.00 49.22           O  
ATOM    371  CB  CYS A  70      -3.178   5.609  15.333  1.00 48.27           C  
ATOM    372  SG  CYS A  70      -4.017   4.396  16.384  1.00 48.99           S  
ATOM    373  N   GLY A  71      -1.176   5.572  18.078  1.00 48.93           N  
ATOM    374  CA  GLY A  71      -1.093   6.081  19.445  1.00 48.96           C  
ATOM    375  C   GLY A  71      -2.452   6.573  19.908  1.00 48.63           C  
ATOM    376  O   GLY A  71      -3.431   5.854  19.770  1.00 48.75           O  
ATOM    377  N   ILE A  72      -2.514   7.796  20.438  1.00 48.55           N  
ATOM    378  CA  ILE A  72      -3.795   8.394  20.862  1.00 48.42           C  
ATOM    379  C   ILE A  72      -4.407   9.370  19.840  1.00 49.14           C  
ATOM    380  O   ILE A  72      -5.403  10.041  20.143  1.00 49.19           O  
ATOM    381  CB  ILE A  72      -3.761   9.013  22.308  1.00 47.98           C  
ATOM    382  CG1 ILE A  72      -2.753  10.157  22.403  1.00 47.39           C  
ATOM    383  CG2 ILE A  72      -3.481   7.937  23.343  1.00 47.36           C  
ATOM    384  CD1 ILE A  72      -2.896  11.018  23.621  1.00 47.86           C  
ATOM    385  N   GLY A  73      -3.806   9.449  18.648  1.00 49.71           N  
ATOM    386  CA  GLY A  73      -4.460  10.041  17.476  1.00 50.40           C  
ATOM    387  C   GLY A  73      -4.044  11.438  17.045  1.00 51.16           C  
ATOM    388  O   GLY A  73      -4.546  11.958  16.043  1.00 51.20           O  
ATOM    389  N   LYS A  74      -3.121  12.052  17.776  1.00 51.78           N  
ATOM    390  CA  LYS A  74      -2.745  13.445  17.495  1.00 52.35           C  
ATOM    391  C   LYS A  74      -2.212  13.654  16.064  1.00 52.12           C  
ATOM    392  O   LYS A  74      -2.717  14.523  15.341  1.00 52.72           O  
ATOM    393  CB  LYS A  74      -1.778  13.998  18.554  1.00 51.65           C  
ATOM    394  CG  LYS A  74      -2.420  14.219  19.907  1.00 52.93           C  
ATOM    395  CD  LYS A  74      -1.392  14.567  20.987  1.00 53.96           C  
ATOM    396  CE  LYS A  74      -0.966  16.029  20.906  1.00 56.92           C  
ATOM    397  NZ  LYS A  74      -1.676  16.851  21.945  1.00 60.47           N  
ATOM    398  N   PRO A  75      -1.181  12.889  15.660  1.00 51.93           N  
ATOM    399  CA  PRO A  75      -0.636  13.014  14.299  1.00 52.05           C  
ATOM    400  C   PRO A  75      -1.652  12.861  13.170  1.00 52.12           C  
ATOM    401  O   PRO A  75      -1.579  13.590  12.183  1.00 52.40           O  
ATOM    402  CB  PRO A  75       0.400  11.899  14.248  1.00 52.00           C  
ATOM    403  CG  PRO A  75       0.875  11.836  15.698  1.00 51.71           C  
ATOM    404  CD  PRO A  75      -0.404  11.922  16.452  1.00 51.67           C  
ATOM    405  N   ALA A  76      -2.599  11.941  13.333  1.00 52.22           N  
ATOM    406  CA  ALA A  76      -3.635  11.675  12.332  1.00 52.05           C  
ATOM    407  C   ALA A  76      -4.667  12.810  12.244  1.00 52.05           C  
ATOM    408  O   ALA A  76      -5.164  13.134  11.158  1.00 52.21           O  
ATOM    409  CB  ALA A  76      -4.318  10.333  12.626  1.00 51.92           C  
ATOM    410  N   VAL A  77      -4.988  13.412  13.384  1.00 51.66           N  
ATOM    411  CA  VAL A  77      -5.869  14.573  13.385  1.00 51.74           C  
ATOM    412  C   VAL A  77      -5.180  15.779  12.728  1.00 51.69           C  
ATOM    413  O   VAL A  77      -5.834  16.555  12.023  1.00 51.84           O  
ATOM    414  CB  VAL A  77      -6.366  14.922  14.814  1.00 51.71           C  
ATOM    415  CG1 VAL A  77      -7.043  16.291  14.851  1.00 51.37           C  
ATOM    416  CG2 VAL A  77      -7.321  13.861  15.299  1.00 51.86           C  
ATOM    417  N   ARG A  78      -3.870  15.932  12.945  1.00 51.47           N  
ATOM    418  CA  ARG A  78      -3.136  17.034  12.326  1.00 51.25           C  
ATOM    419  C   ARG A  78      -3.089  16.882  10.803  1.00 51.41           C  
ATOM    420  O   ARG A  78      -3.165  17.877  10.072  1.00 51.51           O  
ATOM    421  CB  ARG A  78      -1.724  17.194  12.886  1.00 50.86           C  
ATOM    422  CG  ARG A  78      -1.180  18.590  12.609  1.00 51.18           C  
ATOM    423  CD  ARG A  78       0.223  18.868  13.129  1.00 51.23           C  
ATOM    424  NE  ARG A  78       0.245  20.175  13.799  1.00 53.82           N  
ATOM    425  CZ  ARG A  78       0.464  21.349  13.213  1.00 54.02           C  
ATOM    426  NH1 ARG A  78       0.447  22.458  13.930  1.00 54.17           N  
ATOM    427  NH2 ARG A  78       0.705  21.425  11.915  1.00 56.91           N  
ATOM    428  N   LEU A  79      -2.977  15.639  10.335  1.00 51.21           N  
ATOM    429  CA  LEU A  79      -2.944  15.356   8.907  1.00 50.89           C  
ATOM    430  C   LEU A  79      -4.290  15.730   8.293  1.00 50.93           C  
ATOM    431  O   LEU A  79      -4.357  16.307   7.199  1.00 51.09           O  
ATOM    432  CB  LEU A  79      -2.611  13.880   8.666  1.00 50.90           C  
ATOM    433  CG  LEU A  79      -2.707  13.300   7.246  1.00 51.24           C  
ATOM    434  CD1 LEU A  79      -1.866  14.086   6.223  1.00 51.70           C  
ATOM    435  CD2 LEU A  79      -2.341  11.823   7.229  1.00 50.31           C  
ATOM    436  N   ALA A  80      -5.357  15.424   9.018  1.00 50.54           N  
ATOM    437  CA  ALA A  80      -6.702  15.658   8.525  1.00 50.26           C  
ATOM    438  C   ALA A  80      -7.057  17.148   8.513  1.00 50.21           C  
ATOM    439  O   ALA A  80      -7.881  17.599   7.703  1.00 50.29           O  
ATOM    440  CB  ALA A  80      -7.688  14.875   9.353  1.00 50.27           C  
ATOM    441  N   THR A  81      -6.432  17.903   9.417  1.00 49.82           N  
ATOM    442  CA  THR A  81      -6.624  19.348   9.503  1.00 49.35           C  
ATOM    443  C   THR A  81      -5.878  20.055   8.371  1.00 49.32           C  
ATOM    444  O   THR A  81      -6.157  21.209   8.063  1.00 49.84           O  
ATOM    445  CB  THR A  81      -6.135  19.877  10.880  1.00 49.45           C  
ATOM    446  OG1 THR A  81      -6.806  19.168  11.926  1.00 48.87           O  
ATOM    447  CG2 THR A  81      -6.396  21.381  11.047  1.00 49.22           C  
ATOM    448  N   ALA A  82      -4.939  19.350   7.747  1.00 49.11           N  
ATOM    449  CA  ALA A  82      -4.032  19.935   6.773  1.00 48.91           C  
ATOM    450  C   ALA A  82      -4.415  19.564   5.333  1.00 49.05           C  
ATOM    451  O   ALA A  82      -4.385  20.412   4.443  1.00 48.82           O  
ATOM    452  CB  ALA A  82      -2.593  19.519   7.086  1.00 48.55           C  
ATOM    453  N   ARG A  83      -4.781  18.296   5.123  1.00 49.28           N  
ATOM    454  CA  ARG A  83      -5.185  17.782   3.815  1.00 48.97           C  
ATOM    455  C   ARG A  83      -6.546  17.125   3.904  1.00 49.08           C  
ATOM    456  O   ARG A  83      -6.958  16.662   4.976  1.00 49.01           O  
ATOM    457  CB  ARG A  83      -4.175  16.763   3.318  1.00 48.85           C  
ATOM    458  CG  ARG A  83      -2.745  17.242   3.379  1.00 50.11           C  
ATOM    459  CD  ARG A  83      -2.358  18.012   2.136  1.00 52.29           C  
ATOM    460  NE  ARG A  83      -1.727  19.287   2.463  1.00 54.65           N  
ATOM    461  CZ  ARG A  83      -0.416  19.516   2.468  1.00 56.28           C  
ATOM    462  NH1 ARG A  83       0.441  18.547   2.168  1.00 57.00           N  
ATOM    463  NH2 ARG A  83       0.043  20.728   2.773  1.00 57.46           N  
ATOM    464  N   ASP A  84      -7.235  17.082   2.768  1.00 49.30           N  
ATOM    465  CA  ASP A  84      -8.586  16.531   2.684  1.00 49.71           C  
ATOM    466  C   ASP A  84      -8.520  15.067   2.262  1.00 49.75           C  
ATOM    467  O   ASP A  84      -8.731  14.732   1.090  1.00 49.98           O  
ATOM    468  CB  ASP A  84      -9.454  17.350   1.706  1.00 49.74           C  
ATOM    469  CG  ASP A  84     -10.953  17.290   2.041  1.00 50.23           C  
ATOM    470  OD1 ASP A  84     -11.315  17.006   3.209  1.00 49.91           O  
ATOM    471  OD2 ASP A  84     -11.776  17.545   1.131  1.00 50.44           O  
ATOM    472  N   VAL A  85      -8.217  14.205   3.229  1.00 49.85           N  
ATOM    473  CA  VAL A  85      -8.059  12.778   2.978  1.00 50.07           C  
ATOM    474  C   VAL A  85      -8.820  11.940   3.994  1.00 50.55           C  
ATOM    475  O   VAL A  85      -9.312  12.471   4.981  1.00 50.72           O  
ATOM    476  CB  VAL A  85      -6.576  12.361   3.010  1.00 50.13           C  
ATOM    477  CG1 VAL A  85      -5.826  12.957   1.822  1.00 49.33           C  
ATOM    478  CG2 VAL A  85      -5.922  12.744   4.342  1.00 49.70           C  
ATOM    479  N   ARG A  86      -8.919  10.637   3.743  1.00 51.18           N  
ATOM    480  CA  ARG A  86      -9.456   9.695   4.720  1.00 51.97           C  
ATOM    481  C   ARG A  86      -8.293   9.027   5.436  1.00 52.22           C  
ATOM    482  O   ARG A  86      -7.442   8.411   4.799  1.00 52.75           O  
ATOM    483  CB  ARG A  86     -10.335   8.622   4.059  1.00 51.85           C  
ATOM    484  CG  ARG A  86     -11.549   9.158   3.288  1.00 52.78           C  
ATOM    485  CD  ARG A  86     -12.612   8.077   3.054  1.00 52.72           C  
ATOM    486  NE  ARG A  86     -13.961   8.656   3.033  1.00 55.14           N  
ATOM    487  CZ  ARG A  86     -14.763   8.805   4.096  1.00 55.77           C  
ATOM    488  NH1 ARG A  86     -14.394   8.410   5.310  1.00 55.21           N  
ATOM    489  NH2 ARG A  86     -15.962   9.353   3.943  1.00 57.14           N  
ATOM    490  N   VAL A  87      -8.249   9.163   6.756  1.00 52.42           N  
ATOM    491  CA  VAL A  87      -7.263   8.464   7.564  1.00 52.78           C  
ATOM    492  C   VAL A  87      -7.957   7.279   8.241  1.00 53.15           C  
ATOM    493  O   VAL A  87      -9.079   7.420   8.731  1.00 53.33           O  
ATOM    494  CB  VAL A  87      -6.629   9.392   8.662  1.00 52.85           C  
ATOM    495  CG1 VAL A  87      -5.375   8.756   9.248  1.00 53.35           C  
ATOM    496  CG2 VAL A  87      -6.282  10.783   8.116  1.00 52.22           C  
ATOM    497  N   THR A  88      -7.320   6.107   8.229  1.00 53.48           N  
ATOM    498  CA  THR A  88      -7.638   5.053   9.203  1.00 53.64           C  
ATOM    499  C   THR A  88      -6.373   4.702  10.012  1.00 53.89           C  
ATOM    500  O   THR A  88      -5.272   4.554   9.441  1.00 54.13           O  
ATOM    501  CB  THR A  88      -8.345   3.783   8.611  1.00 53.90           C  
ATOM    502  OG1 THR A  88      -7.389   2.753   8.326  1.00 55.14           O  
ATOM    503  CG2 THR A  88      -9.213   4.099   7.363  1.00 53.68           C  
ATOM    504  N   GLY A  89      -6.523   4.629  11.341  1.00 53.60           N  
ATOM    505  CA  GLY A  89      -5.391   4.428  12.246  1.00 53.08           C  
ATOM    506  C   GLY A  89      -5.467   3.073  12.911  1.00 53.20           C  
ATOM    507  O   GLY A  89      -6.550   2.547  13.132  1.00 53.02           O  
ATOM    508  N   ILE A  90      -4.307   2.534  13.265  1.00 53.48           N  
ATOM    509  CA  ILE A  90      -4.169   1.141  13.686  1.00 53.99           C  
ATOM    510  C   ILE A  90      -3.247   1.026  14.903  1.00 54.26           C  
ATOM    511  O   ILE A  90      -2.199   1.678  14.942  1.00 54.37           O  
ATOM    512  CB  ILE A  90      -3.631   0.300  12.482  1.00 54.14           C  
ATOM    513  CG1 ILE A  90      -4.779  -0.168  11.594  1.00 53.49           C  
ATOM    514  CG2 ILE A  90      -2.681  -0.844  12.897  1.00 53.92           C  
ATOM    515  CD1 ILE A  90      -5.988  -0.607  12.326  1.00 55.96           C  
ATOM    516  N   SER A  91      -3.646   0.204  15.880  1.00 54.55           N  
ATOM    517  CA  SER A  91      -2.862  -0.046  17.100  1.00 55.03           C  
ATOM    518  C   SER A  91      -3.229  -1.356  17.826  1.00 55.44           C  
ATOM    519  O   SER A  91      -4.312  -1.926  17.631  1.00 55.26           O  
ATOM    520  CB  SER A  91      -2.979   1.138  18.066  1.00 55.11           C  
ATOM    521  OG  SER A  91      -2.392   0.852  19.328  1.00 55.80           O  
ATOM    522  N   ILE A  92      -2.308  -1.817  18.666  1.00 56.02           N  
ATOM    523  CA  ILE A  92      -2.504  -3.030  19.451  1.00 56.86           C  
ATOM    524  C   ILE A  92      -2.838  -2.755  20.926  1.00 57.46           C  
ATOM    525  O   ILE A  92      -2.742  -3.651  21.766  1.00 57.07           O  
ATOM    526  CB  ILE A  92      -1.287  -4.009  19.350  1.00 57.05           C  
ATOM    527  CG1 ILE A  92       0.027  -3.330  19.785  1.00 56.64           C  
ATOM    528  CG2 ILE A  92      -1.205  -4.627  17.949  1.00 56.82           C  
ATOM    529  CD1 ILE A  92       1.086  -4.306  20.326  1.00 56.57           C  
ATOM    530  N   SER A  93      -3.220  -1.515  21.227  1.00 58.38           N  
ATOM    531  CA  SER A  93      -3.621  -1.121  22.572  1.00 59.13           C  
ATOM    532  C   SER A  93      -5.047  -0.557  22.559  1.00 59.67           C  
ATOM    533  O   SER A  93      -5.302   0.528  22.029  1.00 59.49           O  
ATOM    534  CB  SER A  93      -2.622  -0.105  23.141  1.00 59.24           C  
ATOM    535  OG  SER A  93      -3.009   0.367  24.429  1.00 60.00           O  
ATOM    536  N   ARG A  94      -5.971  -1.302  23.162  1.00 60.72           N  
ATOM    537  CA  ARG A  94      -7.404  -0.963  23.133  1.00 61.40           C  
ATOM    538  C   ARG A  94      -7.804   0.422  23.687  1.00 61.69           C  
ATOM    539  O   ARG A  94      -8.494   1.169  22.988  1.00 61.89           O  
ATOM    540  CB  ARG A  94      -8.240  -2.095  23.724  1.00 61.36           C  
ATOM    541  CG  ARG A  94      -8.251  -3.319  22.817  1.00 62.61           C  
ATOM    542  CD  ARG A  94      -9.141  -3.113  21.586  1.00 63.74           C  
ATOM    543  NE  ARG A  94     -10.431  -3.791  21.731  1.00 65.23           N  
ATOM    544  CZ  ARG A  94     -10.746  -4.953  21.161  1.00 65.03           C  
ATOM    545  NH1 ARG A  94      -9.874  -5.589  20.387  1.00 65.66           N  
ATOM    546  NH2 ARG A  94     -11.942  -5.478  21.358  1.00 65.06           N  
ATOM    547  N   PRO A  95      -7.389   0.768  24.932  1.00 61.94           N  
ATOM    548  CA  PRO A  95      -7.567   2.149  25.422  1.00 61.69           C  
ATOM    549  C   PRO A  95      -7.206   3.232  24.397  1.00 61.50           C  
ATOM    550  O   PRO A  95      -8.001   4.152  24.171  1.00 61.35           O  
ATOM    551  CB  PRO A  95      -6.623   2.228  26.638  1.00 61.64           C  
ATOM    552  CG  PRO A  95      -5.944   0.866  26.742  1.00 61.88           C  
ATOM    553  CD  PRO A  95      -6.795  -0.093  25.976  1.00 61.86           C  
ATOM    554  N   GLN A  96      -6.029   3.117  23.782  1.00 61.57           N  
ATOM    555  CA  GLN A  96      -5.564   4.095  22.772  1.00 61.86           C  
ATOM    556  C   GLN A  96      -6.504   4.272  21.567  1.00 60.85           C  
ATOM    557  O   GLN A  96      -6.697   5.393  21.102  1.00 60.76           O  
ATOM    558  CB  GLN A  96      -4.185   3.719  22.250  1.00 61.62           C  
ATOM    559  CG  GLN A  96      -3.037   3.905  23.219  1.00 63.01           C  
ATOM    560  CD  GLN A  96      -1.688   3.709  22.529  1.00 64.06           C  
ATOM    561  OE1 GLN A  96      -1.618   3.258  21.371  1.00 67.13           O  
ATOM    562  NE2 GLN A  96      -0.613   4.037  23.233  1.00 66.37           N  
ATOM    563  N   VAL A  97      -7.064   3.166  21.067  1.00 59.94           N  
ATOM    564  CA  VAL A  97      -8.048   3.186  19.980  1.00 59.23           C  
ATOM    565  C   VAL A  97      -9.305   3.994  20.400  1.00 59.22           C  
ATOM    566  O   VAL A  97      -9.769   4.878  19.670  1.00 59.15           O  
ATOM    567  CB  VAL A  97      -8.406   1.726  19.538  1.00 59.35           C  
ATOM    568  CG1 VAL A  97      -9.462   1.685  18.417  1.00 58.12           C  
ATOM    569  CG2 VAL A  97      -7.148   0.963  19.135  1.00 59.29           C  
ATOM    570  N   ASN A  98      -9.830   3.702  21.588  1.00 58.68           N  
ATOM    571  CA  ASN A  98     -10.935   4.462  22.159  1.00 58.38           C  
ATOM    572  C   ASN A  98     -10.639   5.957  22.376  1.00 57.86           C  
ATOM    573  O   ASN A  98     -11.478   6.810  22.068  1.00 57.67           O  
ATOM    574  CB  ASN A  98     -11.405   3.795  23.453  1.00 58.58           C  
ATOM    575  CG  ASN A  98     -11.768   2.331  23.246  1.00 59.55           C  
ATOM    576  OD1 ASN A  98     -12.002   1.892  22.117  1.00 61.18           O  
ATOM    577  ND2 ASN A  98     -11.810   1.568  24.333  1.00 60.11           N  
ATOM    578  N   GLN A  99      -9.458   6.279  22.898  1.00 57.13           N  
ATOM    579  CA  GLN A  99      -9.056   7.679  23.028  1.00 56.83           C  
ATOM    580  C   GLN A  99      -8.962   8.374  21.659  1.00 56.51           C  
ATOM    581  O   GLN A  99      -9.480   9.479  21.475  1.00 56.31           O  
ATOM    582  CB  GLN A  99      -7.714   7.799  23.733  1.00 56.78           C  
ATOM    583  CG  GLN A  99      -7.749   7.569  25.204  1.00 57.56           C  
ATOM    584  CD  GLN A  99      -6.385   7.777  25.837  1.00 58.86           C  
ATOM    585  OE1 GLN A  99      -5.861   6.876  26.484  1.00 59.74           O  
ATOM    586  NE2 GLN A  99      -5.799   8.967  25.650  1.00 58.62           N  
ATOM    587  N   ALA A 100      -8.291   7.725  20.710  1.00 55.97           N  
ATOM    588  CA  ALA A 100      -8.143   8.269  19.367  1.00 55.78           C  
ATOM    589  C   ALA A 100      -9.499   8.547  18.708  1.00 55.65           C  
ATOM    590  O   ALA A 100      -9.699   9.608  18.102  1.00 55.70           O  
ATOM    591  CB  ALA A 100      -7.311   7.347  18.508  1.00 55.84           C  
ATOM    592  N   ASN A 101     -10.435   7.612  18.849  1.00 55.03           N  
ATOM    593  CA  ASN A 101     -11.758   7.810  18.287  1.00 54.69           C  
ATOM    594  C   ASN A 101     -12.535   8.950  18.938  1.00 54.70           C  
ATOM    595  O   ASN A 101     -13.234   9.694  18.253  1.00 54.56           O  
ATOM    596  CB  ASN A 101     -12.548   6.502  18.268  1.00 54.65           C  
ATOM    597  CG  ASN A 101     -12.186   5.634  17.075  1.00 53.95           C  
ATOM    598  OD1 ASN A 101     -12.123   6.121  15.942  1.00 52.76           O  
ATOM    599  ND2 ASN A 101     -11.935   4.350  17.321  1.00 52.22           N  
ATOM    600  N   ALA A 102     -12.393   9.096  20.254  1.00 54.98           N  
ATOM    601  CA  ALA A 102     -13.036  10.189  20.986  1.00 55.28           C  
ATOM    602  C   ALA A 102     -12.453  11.534  20.565  1.00 55.69           C  
ATOM    603  O   ALA A 102     -13.195  12.495  20.377  1.00 55.86           O  
ATOM    604  CB  ALA A 102     -12.901   9.988  22.481  1.00 54.96           C  
ATOM    605  N   ARG A 103     -11.129  11.582  20.404  1.00 56.17           N  
ATOM    606  CA  ARG A 103     -10.423  12.775  19.939  1.00 56.87           C  
ATOM    607  C   ARG A 103     -10.858  13.166  18.519  1.00 57.07           C  
ATOM    608  O   ARG A 103     -10.976  14.358  18.205  1.00 57.06           O  
ATOM    609  CB  ARG A 103      -8.894  12.579  20.017  1.00 56.62           C  
ATOM    610  CG  ARG A 103      -8.089  13.553  19.144  1.00 57.50           C  
ATOM    611  CD  ARG A 103      -6.592  13.529  19.415  1.00 57.58           C  
ATOM    612  NE  ARG A 103      -6.217  14.518  20.425  1.00 59.50           N  
ATOM    613  CZ  ARG A 103      -5.994  14.236  21.703  1.00 60.50           C  
ATOM    614  NH1 ARG A 103      -6.097  12.990  22.138  1.00 60.90           N  
ATOM    615  NH2 ARG A 103      -5.666  15.201  22.551  1.00 61.65           N  
ATOM    616  N   ALA A 104     -11.093  12.156  17.679  1.00 57.33           N  
ATOM    617  CA  ALA A 104     -11.613  12.360  16.328  1.00 57.49           C  
ATOM    618  C   ALA A 104     -13.031  12.915  16.376  1.00 57.80           C  
ATOM    619  O   ALA A 104     -13.328  13.925  15.735  1.00 58.06           O  
ATOM    620  CB  ALA A 104     -11.579  11.065  15.537  1.00 57.30           C  
ATOM    621  N   THR A 105     -13.897  12.263  17.148  1.00 57.95           N  
ATOM    622  CA  THR A 105     -15.284  12.680  17.250  1.00 58.28           C  
ATOM    623  C   THR A 105     -15.349  14.082  17.872  1.00 58.47           C  
ATOM    624  O   THR A 105     -16.247  14.870  17.555  1.00 58.61           O  
ATOM    625  CB  THR A 105     -16.148  11.616  18.014  1.00 58.35           C  
ATOM    626  OG1 THR A 105     -17.239  11.191  17.189  1.00 58.93           O  
ATOM    627  CG2 THR A 105     -16.690  12.134  19.350  1.00 58.24           C  
ATOM    628  N   ALA A 106     -14.367  14.391  18.722  1.00 58.49           N  
ATOM    629  CA  ALA A 106     -14.313  15.669  19.438  1.00 58.55           C  
ATOM    630  C   ALA A 106     -13.921  16.852  18.546  1.00 58.59           C  
ATOM    631  O   ALA A 106     -14.318  17.990  18.795  1.00 58.23           O  
ATOM    632  CB  ALA A 106     -13.381  15.566  20.633  1.00 58.45           C  
ATOM    633  N   ALA A 107     -13.133  16.578  17.514  1.00 58.81           N  
ATOM    634  CA  ALA A 107     -12.761  17.603  16.553  1.00 59.19           C  
ATOM    635  C   ALA A 107     -13.705  17.575  15.343  1.00 59.56           C  
ATOM    636  O   ALA A 107     -13.461  18.239  14.334  1.00 59.89           O  
ATOM    637  CB  ALA A 107     -11.307  17.432  16.131  1.00 58.95           C  
ATOM    638  N   GLY A 108     -14.783  16.798  15.459  1.00 59.89           N  
ATOM    639  CA  GLY A 108     -15.820  16.720  14.429  1.00 60.02           C  
ATOM    640  C   GLY A 108     -15.432  16.006  13.150  1.00 60.23           C  
ATOM    641  O   GLY A 108     -16.155  16.081  12.160  1.00 60.45           O  
ATOM    642  N   LEU A 109     -14.302  15.302  13.168  1.00 60.53           N  
ATOM    643  CA  LEU A 109     -13.774  14.635  11.966  1.00 60.83           C  
ATOM    644  C   LEU A 109     -14.159  13.151  11.854  1.00 60.87           C  
ATOM    645  O   LEU A 109     -13.437  12.362  11.226  1.00 61.08           O  
ATOM    646  CB  LEU A 109     -12.243  14.777  11.898  1.00 60.70           C  
ATOM    647  CG  LEU A 109     -11.581  16.159  11.960  1.00 61.23           C  
ATOM    648  CD1 LEU A 109     -10.070  16.020  12.059  1.00 61.31           C  
ATOM    649  CD2 LEU A 109     -11.951  17.036  10.764  1.00 61.79           C  
ATOM    650  N   ALA A 110     -15.289  12.779  12.449  1.00 60.85           N  
ATOM    651  CA  ALA A 110     -15.696  11.377  12.540  1.00 60.99           C  
ATOM    652  C   ALA A 110     -16.129  10.808  11.189  1.00 61.12           C  
ATOM    653  O   ALA A 110     -16.041   9.597  10.963  1.00 61.04           O  
ATOM    654  CB  ALA A 110     -16.807  11.204  13.583  1.00 60.96           C  
ATOM    655  N   ASN A 111     -16.595  11.685  10.301  1.00 61.25           N  
ATOM    656  CA  ASN A 111     -16.969  11.308   8.943  1.00 61.70           C  
ATOM    657  C   ASN A 111     -15.813  10.654   8.187  1.00 61.79           C  
ATOM    658  O   ASN A 111     -16.012   9.706   7.431  1.00 61.91           O  
ATOM    659  CB  ASN A 111     -17.446  12.535   8.162  1.00 61.96           C  
ATOM    660  CG  ASN A 111     -18.707  13.181   8.757  1.00 63.32           C  
ATOM    661  OD1 ASN A 111     -19.195  14.185   8.232  1.00 63.97           O  
ATOM    662  ND2 ASN A 111     -19.235  12.613   9.848  1.00 64.68           N  
ATOM    663  N   ARG A 112     -14.602  11.154   8.402  1.00 61.79           N  
ATOM    664  CA  ARG A 112     -13.451  10.646   7.671  1.00 62.13           C  
ATOM    665  C   ARG A 112     -12.295  10.032   8.479  1.00 62.38           C  
ATOM    666  O   ARG A 112     -11.602   9.141   7.965  1.00 62.68           O  
ATOM    667  CB  ARG A 112     -12.930  11.674   6.645  1.00 62.04           C  
ATOM    668  CG  ARG A 112     -13.010  13.126   7.054  1.00 61.28           C  
ATOM    669  CD  ARG A 112     -12.162  13.972   6.131  1.00 59.72           C  
ATOM    670  NE  ARG A 112     -12.038  15.337   6.635  1.00 60.20           N  
ATOM    671  CZ  ARG A 112     -10.927  16.071   6.585  1.00 60.13           C  
ATOM    672  NH1 ARG A 112      -9.809  15.579   6.059  1.00 59.99           N  
ATOM    673  NH2 ARG A 112     -10.932  17.304   7.080  1.00 60.09           N  
ATOM    674  N   VAL A 113     -12.070  10.494   9.712  1.00 62.37           N  
ATOM    675  CA  VAL A 113     -10.967   9.951  10.534  1.00 62.32           C  
ATOM    676  C   VAL A 113     -11.505   8.895  11.494  1.00 62.41           C  
ATOM    677  O   VAL A 113     -12.440   9.162  12.245  1.00 62.82           O  
ATOM    678  CB  VAL A 113     -10.177  11.041  11.327  1.00 62.24           C  
ATOM    679  CG1 VAL A 113      -8.811  10.521  11.740  1.00 61.82           C  
ATOM    680  CG2 VAL A 113      -9.994  12.295  10.513  1.00 61.85           C  
ATOM    681  N   THR A 114     -10.911   7.703  11.463  1.00 62.39           N  
ATOM    682  CA  THR A 114     -11.435   6.532  12.187  1.00 62.28           C  
ATOM    683  C   THR A 114     -10.322   5.543  12.593  1.00 62.47           C  
ATOM    684  O   THR A 114      -9.312   5.427  11.914  1.00 62.81           O  
ATOM    685  CB  THR A 114     -12.504   5.818  11.356  1.00 61.86           C  
ATOM    686  OG1 THR A 114     -12.656   4.480  11.832  1.00 61.45           O  
ATOM    687  CG2 THR A 114     -12.089   5.774   9.885  1.00 62.72           C  
ATOM    688  N   PHE A 115     -10.506   4.840  13.705  1.00 62.60           N  
ATOM    689  CA  PHE A 115      -9.438   4.023  14.289  1.00 62.72           C  
ATOM    690  C   PHE A 115      -9.956   2.653  14.680  1.00 63.53           C  
ATOM    691  O   PHE A 115     -11.110   2.505  15.103  1.00 63.60           O  
ATOM    692  CB  PHE A 115      -8.826   4.730  15.516  1.00 62.33           C  
ATOM    693  CG  PHE A 115      -8.255   6.092  15.209  1.00 61.25           C  
ATOM    694  CD1 PHE A 115      -9.064   7.228  15.219  1.00 61.34           C  
ATOM    695  CD2 PHE A 115      -6.912   6.235  14.882  1.00 59.84           C  
ATOM    696  CE1 PHE A 115      -8.541   8.492  14.910  1.00 61.15           C  
ATOM    697  CE2 PHE A 115      -6.382   7.477  14.565  1.00 59.68           C  
ATOM    698  CZ  PHE A 115      -7.196   8.614  14.586  1.00 60.94           C  
ATOM    699  N   SER A 116      -9.107   1.644  14.529  1.00 64.57           N  
ATOM    700  CA  SER A 116      -9.471   0.276  14.924  1.00 65.69           C  
ATOM    701  C   SER A 116      -8.263  -0.506  15.448  1.00 66.39           C  
ATOM    702  O   SER A 116      -7.123  -0.031  15.387  1.00 66.53           O  
ATOM    703  CB  SER A 116     -10.197  -0.467  13.791  1.00 65.36           C  
ATOM    704  OG  SER A 116      -9.599  -0.190  12.541  1.00 65.79           O  
ATOM    705  N   TYR A 117      -8.529  -1.691  15.989  1.00 67.19           N  
ATOM    706  CA  TYR A 117      -7.523  -2.463  16.695  1.00 67.82           C  
ATOM    707  C   TYR A 117      -6.970  -3.546  15.793  1.00 67.67           C  
ATOM    708  O   TYR A 117      -7.670  -4.518  15.499  1.00 67.96           O  
ATOM    709  CB  TYR A 117      -8.155  -3.106  17.933  1.00 68.75           C  
ATOM    710  CG  TYR A 117      -7.277  -4.141  18.594  1.00 69.98           C  
ATOM    711  CD1 TYR A 117      -6.388  -3.781  19.604  1.00 71.84           C  
ATOM    712  CD2 TYR A 117      -7.316  -5.475  18.195  1.00 70.21           C  
ATOM    713  CE1 TYR A 117      -5.573  -4.730  20.215  1.00 72.07           C  
ATOM    714  CE2 TYR A 117      -6.496  -6.424  18.787  1.00 71.00           C  
ATOM    715  CZ  TYR A 117      -5.629  -6.045  19.797  1.00 70.94           C  
ATOM    716  OH  TYR A 117      -4.819  -6.981  20.395  1.00 71.31           O  
ATOM    717  N   ALA A 118      -5.719  -3.404  15.366  1.00 67.22           N  
ATOM    718  CA  ALA A 118      -5.109  -4.414  14.492  1.00 66.53           C  
ATOM    719  C   ALA A 118      -3.578  -4.423  14.531  1.00 66.15           C  
ATOM    720  O   ALA A 118      -2.945  -3.414  14.843  1.00 65.79           O  
ATOM    721  CB  ALA A 118      -5.617  -4.262  13.061  1.00 66.47           C  
ATOM    722  N   ASP A 119      -3.007  -5.585  14.218  1.00 65.80           N  
ATOM    723  CA  ASP A 119      -1.564  -5.821  14.263  1.00 65.28           C  
ATOM    724  C   ASP A 119      -0.920  -5.732  12.878  1.00 65.08           C  
ATOM    725  O   ASP A 119      -1.323  -6.442  11.938  1.00 65.50           O  
ATOM    726  CB  ASP A 119      -1.291  -7.203  14.867  1.00 65.11           C  
ATOM    727  CG  ASP A 119       0.193  -7.465  15.124  1.00 64.92           C  
ATOM    728  OD1 ASP A 119       1.064  -6.753  14.572  1.00 63.98           O  
ATOM    729  OD2 ASP A 119       0.490  -8.414  15.885  1.00 64.98           O  
ATOM    730  N   ALA A 120       0.112  -4.899  12.783  1.00 64.30           N  
ATOM    731  CA  ALA A 120       0.858  -4.689  11.550  1.00 63.82           C  
ATOM    732  C   ALA A 120       1.654  -5.897  11.060  1.00 63.50           C  
ATOM    733  O   ALA A 120       2.182  -5.859   9.957  1.00 63.94           O  
ATOM    734  CB  ALA A 120       1.789  -3.501  11.704  1.00 63.73           C  
HETATM  735  N   MSE A 121       1.788  -6.941  11.869  1.00 63.09           N  
HETATM  736  CA  MSE A 121       2.424  -8.172  11.381  1.00 63.03           C  
HETATM  737  C   MSE A 121       1.439  -9.027  10.524  1.00 63.31           C  
HETATM  738  O   MSE A 121       1.831 -10.033   9.925  1.00 63.23           O  
HETATM  739  CB  MSE A 121       3.024  -8.996  12.534  1.00 62.42           C  
HETATM  740  CG  MSE A 121       3.986  -8.256  13.450  1.00 60.97           C  
HETATM  741 SE   MSE A 121       5.788  -8.055  12.780  1.00 57.01          SE  
HETATM  742  CE  MSE A 121       6.520  -9.610  13.270  1.00 55.87           C  
ATOM    743  N   ASP A 122       0.170  -8.605  10.473  1.00 63.38           N  
ATOM    744  CA  ASP A 122      -0.894  -9.305   9.749  1.00 63.29           C  
ATOM    745  C   ASP A 122      -2.087  -8.341   9.612  1.00 63.15           C  
ATOM    746  O   ASP A 122      -3.022  -8.399  10.402  1.00 63.59           O  
ATOM    747  CB  ASP A 122      -1.281 -10.590  10.513  1.00 63.29           C  
ATOM    748  CG  ASP A 122      -2.188 -11.530   9.716  1.00 63.91           C  
ATOM    749  OD1 ASP A 122      -2.130 -12.754   9.961  1.00 64.42           O  
ATOM    750  OD2 ASP A 122      -2.975 -11.077   8.866  1.00 65.07           O  
ATOM    751  N   LEU A 123      -2.038  -7.443   8.624  1.00 62.81           N  
ATOM    752  CA  LEU A 123      -3.076  -6.413   8.442  1.00 62.55           C  
ATOM    753  C   LEU A 123      -4.308  -6.971   7.761  1.00 62.43           C  
ATOM    754  O   LEU A 123      -4.178  -7.680   6.780  1.00 62.57           O  
ATOM    755  CB  LEU A 123      -2.573  -5.251   7.586  1.00 62.70           C  
ATOM    756  CG  LEU A 123      -1.361  -4.392   7.960  1.00 62.02           C  
ATOM    757  CD1 LEU A 123      -0.907  -3.646   6.719  1.00 61.10           C  
ATOM    758  CD2 LEU A 123      -1.678  -3.439   9.084  1.00 60.69           C  
ATOM    759  N   PRO A 124      -5.513  -6.615   8.251  1.00 62.29           N  
ATOM    760  CA  PRO A 124      -6.749  -7.182   7.728  1.00 62.03           C  
ATOM    761  C   PRO A 124      -7.373  -6.417   6.543  1.00 61.81           C  
ATOM    762  O   PRO A 124      -8.585  -6.477   6.343  1.00 61.99           O  
ATOM    763  CB  PRO A 124      -7.673  -7.117   8.941  1.00 62.01           C  
ATOM    764  CG  PRO A 124      -7.250  -5.851   9.629  1.00 62.04           C  
ATOM    765  CD  PRO A 124      -5.782  -5.655   9.342  1.00 62.24           C  
ATOM    766  N   PHE A 125      -6.567  -5.726   5.749  1.00 61.49           N  
ATOM    767  CA  PHE A 125      -7.128  -4.934   4.652  1.00 61.30           C  
ATOM    768  C   PHE A 125      -6.988  -5.560   3.259  1.00 60.99           C  
ATOM    769  O   PHE A 125      -6.064  -6.345   2.993  1.00 60.39           O  
ATOM    770  CB  PHE A 125      -6.540  -3.519   4.639  1.00 61.47           C  
ATOM    771  CG  PHE A 125      -6.687  -2.783   5.935  1.00 61.57           C  
ATOM    772  CD1 PHE A 125      -7.946  -2.393   6.396  1.00 61.83           C  
ATOM    773  CD2 PHE A 125      -5.559  -2.459   6.689  1.00 60.74           C  
ATOM    774  CE1 PHE A 125      -8.082  -1.703   7.604  1.00 61.98           C  
ATOM    775  CE2 PHE A 125      -5.676  -1.769   7.892  1.00 61.11           C  
ATOM    776  CZ  PHE A 125      -6.940  -1.382   8.354  1.00 61.77           C  
ATOM    777  N   GLU A 126      -7.910  -5.176   2.376  1.00 60.90           N  
ATOM    778  CA  GLU A 126      -7.820  -5.481   0.948  1.00 61.22           C  
ATOM    779  C   GLU A 126      -6.463  -5.054   0.373  1.00 60.83           C  
ATOM    780  O   GLU A 126      -5.862  -4.084   0.837  1.00 61.07           O  
ATOM    781  CB  GLU A 126      -8.934  -4.745   0.198  1.00 61.46           C  
ATOM    782  CG  GLU A 126      -9.330  -5.360  -1.117  1.00 62.22           C  
ATOM    783  CD  GLU A 126     -10.271  -6.522  -0.930  1.00 64.35           C  
ATOM    784  OE1 GLU A 126     -10.463  -7.315  -1.890  1.00 64.80           O  
ATOM    785  OE2 GLU A 126     -10.821  -6.638   0.189  1.00 64.92           O  
ATOM    786  N   ASP A 127      -5.994  -5.787  -0.632  1.00 60.45           N  
ATOM    787  CA  ASP A 127      -4.798  -5.424  -1.381  1.00 60.08           C  
ATOM    788  C   ASP A 127      -5.072  -4.144  -2.148  1.00 59.68           C  
ATOM    789  O   ASP A 127      -6.182  -3.951  -2.668  1.00 59.50           O  
ATOM    790  CB  ASP A 127      -4.428  -6.538  -2.357  1.00 60.28           C  
ATOM    791  CG  ASP A 127      -4.348  -7.895  -1.683  1.00 61.48           C  
ATOM    792  OD1 ASP A 127      -3.360  -8.124  -0.951  1.00 62.07           O  
ATOM    793  OD2 ASP A 127      -5.275  -8.725  -1.875  1.00 61.94           O  
ATOM    794  N   ALA A 128      -4.062  -3.272  -2.198  1.00 58.91           N  
ATOM    795  CA  ALA A 128      -4.156  -1.996  -2.891  1.00 58.57           C  
ATOM    796  C   ALA A 128      -5.374  -1.190  -2.447  1.00 58.28           C  
ATOM    797  O   ALA A 128      -6.207  -0.816  -3.264  1.00 58.84           O  
ATOM    798  CB  ALA A 128      -4.171  -2.209  -4.409  1.00 58.45           C  
ATOM    799  N   SER A 129      -5.477  -0.934  -1.150  1.00 57.99           N  
ATOM    800  CA  SER A 129      -6.566  -0.122  -0.613  1.00 57.76           C  
ATOM    801  C   SER A 129      -6.211   1.365  -0.494  1.00 57.82           C  
ATOM    802  O   SER A 129      -7.034   2.233  -0.815  1.00 58.01           O  
ATOM    803  CB  SER A 129      -6.979  -0.647   0.753  1.00 57.72           C  
ATOM    804  OG  SER A 129      -7.103  -2.050   0.714  1.00 57.67           O  
ATOM    805  N   PHE A 130      -4.992   1.654  -0.041  1.00 57.16           N  
ATOM    806  CA  PHE A 130      -4.614   3.020   0.287  1.00 56.78           C  
ATOM    807  C   PHE A 130      -3.763   3.708  -0.777  1.00 56.71           C  
ATOM    808  O   PHE A 130      -2.970   3.070  -1.477  1.00 56.43           O  
ATOM    809  CB  PHE A 130      -3.917   3.061   1.654  1.00 56.94           C  
ATOM    810  CG  PHE A 130      -4.741   2.472   2.768  1.00 56.36           C  
ATOM    811  CD1 PHE A 130      -4.449   1.214   3.270  1.00 55.35           C  
ATOM    812  CD2 PHE A 130      -5.824   3.171   3.293  1.00 56.24           C  
ATOM    813  CE1 PHE A 130      -5.228   0.651   4.281  1.00 55.90           C  
ATOM    814  CE2 PHE A 130      -6.611   2.618   4.306  1.00 57.03           C  
ATOM    815  CZ  PHE A 130      -6.312   1.352   4.800  1.00 56.23           C  
ATOM    816  N   ASP A 131      -3.948   5.019  -0.893  1.00 56.50           N  
ATOM    817  CA  ASP A 131      -3.132   5.839  -1.765  1.00 56.35           C  
ATOM    818  C   ASP A 131      -1.804   6.130  -1.047  1.00 56.29           C  
ATOM    819  O   ASP A 131      -0.772   6.344  -1.691  1.00 56.19           O  
ATOM    820  CB  ASP A 131      -3.860   7.138  -2.134  1.00 56.37           C  
ATOM    821  CG  ASP A 131      -5.296   6.907  -2.599  1.00 57.29           C  
ATOM    822  OD1 ASP A 131      -5.554   7.003  -3.810  1.00 59.12           O  
ATOM    823  OD2 ASP A 131      -6.185   6.627  -1.765  1.00 59.05           O  
ATOM    824  N   ALA A 132      -1.828   6.113   0.284  1.00 56.03           N  
ATOM    825  CA  ALA A 132      -0.616   6.346   1.066  1.00 56.31           C  
ATOM    826  C   ALA A 132      -0.611   5.648   2.427  1.00 56.66           C  
ATOM    827  O   ALA A 132      -1.672   5.293   2.974  1.00 56.16           O  
ATOM    828  CB  ALA A 132      -0.349   7.853   1.231  1.00 56.16           C  
ATOM    829  N   VAL A 133       0.596   5.456   2.962  1.00 56.90           N  
ATOM    830  CA  VAL A 133       0.766   4.839   4.272  1.00 57.37           C  
ATOM    831  C   VAL A 133       1.873   5.556   5.038  1.00 57.21           C  
ATOM    832  O   VAL A 133       2.849   5.991   4.435  1.00 56.71           O  
ATOM    833  CB  VAL A 133       1.079   3.329   4.159  1.00 57.66           C  
ATOM    834  CG1 VAL A 133       2.516   3.112   3.745  1.00 58.07           C  
ATOM    835  CG2 VAL A 133       0.836   2.638   5.471  1.00 58.29           C  
ATOM    836  N   TRP A 134       1.702   5.709   6.355  1.00 57.03           N  
ATOM    837  CA  TRP A 134       2.810   6.168   7.187  1.00 56.69           C  
ATOM    838  C   TRP A 134       3.011   5.514   8.562  1.00 56.61           C  
ATOM    839  O   TRP A 134       2.065   4.956   9.154  1.00 56.58           O  
ATOM    840  CB  TRP A 134       2.827   7.697   7.292  1.00 57.59           C  
ATOM    841  CG  TRP A 134       2.006   8.360   8.382  1.00 57.02           C  
ATOM    842  CD1 TRP A 134       1.312   7.765   9.398  1.00 56.96           C  
ATOM    843  CD2 TRP A 134       1.850   9.771   8.562  1.00 56.78           C  
ATOM    844  NE1 TRP A 134       0.703   8.724  10.182  1.00 57.47           N  
ATOM    845  CE2 TRP A 134       1.030   9.965   9.692  1.00 57.71           C  
ATOM    846  CE3 TRP A 134       2.309  10.890   7.862  1.00 56.56           C  
ATOM    847  CZ2 TRP A 134       0.667  11.241  10.148  1.00 57.20           C  
ATOM    848  CZ3 TRP A 134       1.953  12.153   8.322  1.00 57.47           C  
ATOM    849  CH2 TRP A 134       1.132  12.314   9.458  1.00 56.27           C  
ATOM    850  N   ALA A 135       4.256   5.576   9.043  1.00 56.05           N  
ATOM    851  CA  ALA A 135       4.637   5.013  10.335  1.00 55.74           C  
ATOM    852  C   ALA A 135       5.486   5.972  11.145  1.00 55.63           C  
ATOM    853  O   ALA A 135       6.698   6.071  10.954  1.00 55.69           O  
ATOM    854  CB  ALA A 135       5.361   3.699  10.143  1.00 55.59           C  
ATOM    855  N   LEU A 136       4.848   6.690  12.060  1.00 55.74           N  
ATOM    856  CA  LEU A 136       5.578   7.650  12.880  1.00 55.08           C  
ATOM    857  C   LEU A 136       5.959   7.041  14.247  1.00 54.89           C  
ATOM    858  O   LEU A 136       5.105   6.844  15.113  1.00 54.58           O  
ATOM    859  CB  LEU A 136       4.783   8.959  12.953  1.00 54.93           C  
ATOM    860  CG  LEU A 136       5.053  10.143  13.902  1.00 56.50           C  
ATOM    861  CD1 LEU A 136       6.518  10.524  14.037  1.00 58.56           C  
ATOM    862  CD2 LEU A 136       4.269  11.370  13.415  1.00 58.15           C  
ATOM    863  N   GLU A 137       7.240   6.690  14.392  1.00 54.86           N  
ATOM    864  CA  GLU A 137       7.818   6.128  15.624  1.00 55.55           C  
ATOM    865  C   GLU A 137       7.139   4.825  16.074  1.00 56.82           C  
ATOM    866  O   GLU A 137       6.913   4.637  17.278  1.00 57.54           O  
ATOM    867  CB  GLU A 137       7.789   7.144  16.781  1.00 55.26           C  
ATOM    868  CG  GLU A 137       8.901   8.201  16.816  1.00 54.81           C  
ATOM    869  CD  GLU A 137       8.681   9.290  17.902  1.00 55.96           C  
ATOM    870  OE1 GLU A 137       8.294   8.981  19.064  1.00 56.35           O  
ATOM    871  OE2 GLU A 137       8.893  10.485  17.595  1.00 57.75           O  
ATOM    872  N   SER A 138       6.825   3.923  15.137  1.00 57.11           N  
ATOM    873  CA  SER A 138       6.114   2.706  15.498  1.00 57.87           C  
ATOM    874  C   SER A 138       6.831   1.386  15.150  1.00 58.29           C  
ATOM    875  O   SER A 138       6.604   0.359  15.813  1.00 58.18           O  
ATOM    876  CB  SER A 138       4.674   2.714  14.946  1.00 58.12           C  
ATOM    877  OG  SER A 138       4.643   2.767  13.528  1.00 58.85           O  
ATOM    878  N   LEU A 139       7.700   1.411  14.139  1.00 58.13           N  
ATOM    879  CA  LEU A 139       8.313   0.175  13.651  1.00 57.67           C  
ATOM    880  C   LEU A 139       9.320  -0.471  14.608  1.00 57.57           C  
ATOM    881  O   LEU A 139       9.539  -1.680  14.548  1.00 57.55           O  
ATOM    882  CB  LEU A 139       8.961   0.396  12.284  1.00 57.69           C  
ATOM    883  CG  LEU A 139       8.109   0.765  11.068  1.00 57.24           C  
ATOM    884  CD1 LEU A 139       9.013   0.967   9.825  1.00 57.56           C  
ATOM    885  CD2 LEU A 139       7.084  -0.289  10.789  1.00 56.09           C  
ATOM    886  N   HIS A 140       9.931   0.327  15.480  1.00 57.63           N  
ATOM    887  CA  HIS A 140      10.901  -0.175  16.460  1.00 57.73           C  
ATOM    888  C   HIS A 140      10.267  -1.080  17.503  1.00 58.11           C  
ATOM    889  O   HIS A 140      10.973  -1.723  18.283  1.00 58.20           O  
ATOM    890  CB  HIS A 140      11.656   0.975  17.145  1.00 57.75           C  
ATOM    891  CG  HIS A 140      10.788   1.879  17.974  1.00 57.01           C  
ATOM    892  ND1 HIS A 140      10.606   3.212  17.675  1.00 54.86           N  
ATOM    893  CD2 HIS A 140      10.070   1.646  19.101  1.00 55.64           C  
ATOM    894  CE1 HIS A 140       9.804   3.756  18.573  1.00 55.36           C  
ATOM    895  NE2 HIS A 140       9.470   2.830  19.452  1.00 54.32           N  
ATOM    896  N   HIS A 141       8.938  -1.113  17.513  1.00 58.57           N  
ATOM    897  CA  HIS A 141       8.192  -2.028  18.356  1.00 59.19           C  
ATOM    898  C   HIS A 141       8.092  -3.397  17.732  1.00 59.62           C  
ATOM    899  O   HIS A 141       8.247  -4.402  18.423  1.00 60.33           O  
ATOM    900  CB  HIS A 141       6.786  -1.507  18.621  1.00 59.23           C  
ATOM    901  CG  HIS A 141       6.753  -0.246  19.419  1.00 59.60           C  
ATOM    902  ND1 HIS A 141       7.087  -0.202  20.756  1.00 60.51           N  
ATOM    903  CD2 HIS A 141       6.428   1.019  19.070  1.00 59.89           C  
ATOM    904  CE1 HIS A 141       6.958   1.035  21.201  1.00 59.29           C  
ATOM    905  NE2 HIS A 141       6.556   1.796  20.198  1.00 60.38           N  
HETATM  906  N   MSE A 142       7.804  -3.448  16.434  1.00 59.98           N  
HETATM  907  CA  MSE A 142       7.647  -4.727  15.712  1.00 59.95           C  
HETATM  908  C   MSE A 142       8.802  -5.677  16.018  1.00 59.99           C  
HETATM  909  O   MSE A 142       9.961  -5.270  15.980  1.00 60.15           O  
HETATM  910  CB  MSE A 142       7.605  -4.487  14.195  1.00 60.23           C  
HETATM  911  CG  MSE A 142       6.786  -3.292  13.741  1.00 59.06           C  
HETATM  912 SE   MSE A 142       4.964  -3.631  14.118  1.00 61.03          SE  
HETATM  913  CE  MSE A 142       4.292  -1.810  14.104  1.00 59.76           C  
ATOM    914  N   PRO A 143       8.502  -6.945  16.334  1.00 60.21           N  
ATOM    915  CA  PRO A 143       9.628  -7.874  16.494  1.00 60.48           C  
ATOM    916  C   PRO A 143      10.401  -8.183  15.193  1.00 60.88           C  
ATOM    917  O   PRO A 143      11.442  -8.842  15.252  1.00 60.73           O  
ATOM    918  CB  PRO A 143       8.972  -9.133  17.077  1.00 60.18           C  
ATOM    919  CG  PRO A 143       7.525  -9.017  16.752  1.00 59.64           C  
ATOM    920  CD  PRO A 143       7.193  -7.583  16.585  1.00 60.23           C  
ATOM    921  N   ASP A 144       9.909  -7.688  14.052  1.00 61.60           N  
ATOM    922  CA  ASP A 144      10.529  -7.914  12.725  1.00 62.32           C  
ATOM    923  C   ASP A 144      10.055  -6.878  11.693  1.00 62.51           C  
ATOM    924  O   ASP A 144       8.997  -7.040  11.076  1.00 62.44           O  
ATOM    925  CB  ASP A 144      10.260  -9.357  12.238  1.00 62.34           C  
ATOM    926  CG  ASP A 144      10.609  -9.585  10.755  1.00 63.24           C  
ATOM    927  OD1 ASP A 144      11.597  -9.014  10.236  1.00 63.27           O  
ATOM    928  OD2 ASP A 144       9.886 -10.377  10.104  1.00 64.83           O  
ATOM    929  N   ARG A 145      10.860  -5.832  11.505  1.00 63.02           N  
ATOM    930  CA  ARG A 145      10.545  -4.728  10.577  1.00 63.56           C  
ATOM    931  C   ARG A 145      10.123  -5.193   9.182  1.00 63.56           C  
ATOM    932  O   ARG A 145       9.144  -4.684   8.631  1.00 63.89           O  
ATOM    933  CB  ARG A 145      11.728  -3.768  10.446  1.00 63.21           C  
ATOM    934  CG  ARG A 145      11.714  -2.595  11.387  1.00 64.03           C  
ATOM    935  CD  ARG A 145      12.966  -1.730  11.186  1.00 64.56           C  
ATOM    936  NE  ARG A 145      14.128  -2.346  11.825  1.00 67.47           N  
ATOM    937  CZ  ARG A 145      15.374  -2.297  11.362  1.00 68.42           C  
ATOM    938  NH1 ARG A 145      15.652  -1.657  10.236  1.00 68.23           N  
ATOM    939  NH2 ARG A 145      16.348  -2.901  12.031  1.00 68.96           N  
ATOM    940  N   GLY A 146      10.869  -6.144   8.618  1.00 63.54           N  
ATOM    941  CA  GLY A 146      10.582  -6.699   7.289  1.00 63.69           C  
ATOM    942  C   GLY A 146       9.136  -7.109   7.051  1.00 63.62           C  
ATOM    943  O   GLY A 146       8.509  -6.661   6.090  1.00 64.10           O  
ATOM    944  N   ARG A 147       8.609  -7.963   7.923  1.00 63.19           N  
ATOM    945  CA  ARG A 147       7.197  -8.334   7.901  1.00 62.87           C  
ATOM    946  C   ARG A 147       6.285  -7.115   7.738  1.00 62.32           C  
ATOM    947  O   ARG A 147       5.538  -7.004   6.767  1.00 62.39           O  
ATOM    948  CB  ARG A 147       6.841  -9.083   9.189  1.00 63.21           C  
ATOM    949  CG  ARG A 147       5.521  -9.856   9.158  1.00 63.96           C  
ATOM    950  CD  ARG A 147       5.482 -10.821   8.008  1.00 64.40           C  
ATOM    951  NE  ARG A 147       4.335 -11.724   8.041  1.00 66.63           N  
ATOM    952  CZ  ARG A 147       3.135 -11.470   7.519  1.00 67.62           C  
ATOM    953  NH1 ARG A 147       2.894 -10.308   6.941  1.00 68.24           N  
ATOM    954  NH2 ARG A 147       2.167 -12.383   7.581  1.00 68.70           N  
ATOM    955  N   ALA A 148       6.369  -6.200   8.694  1.00 61.67           N  
ATOM    956  CA  ALA A 148       5.548  -5.001   8.716  1.00 61.10           C  
ATOM    957  C   ALA A 148       5.594  -4.205   7.405  1.00 60.86           C  
ATOM    958  O   ALA A 148       4.557  -3.979   6.774  1.00 61.17           O  
ATOM    959  CB  ALA A 148       5.968  -4.143   9.862  1.00 61.38           C  
ATOM    960  N   LEU A 149       6.792  -3.793   6.992  1.00 59.96           N  
ATOM    961  CA  LEU A 149       6.978  -3.163   5.694  1.00 58.88           C  
ATOM    962  C   LEU A 149       6.420  -3.971   4.504  1.00 58.87           C  
ATOM    963  O   LEU A 149       5.902  -3.378   3.560  1.00 59.06           O  
ATOM    964  CB  LEU A 149       8.444  -2.804   5.477  1.00 58.87           C  
ATOM    965  CG  LEU A 149       9.035  -1.599   6.236  1.00 57.61           C  
ATOM    966  CD1 LEU A 149      10.545  -1.633   6.175  1.00 54.46           C  
ATOM    967  CD2 LEU A 149       8.510  -0.266   5.731  1.00 56.17           C  
ATOM    968  N   ARG A 150       6.503  -5.302   4.540  1.00 58.43           N  
ATOM    969  CA  ARG A 150       5.899  -6.134   3.465  1.00 58.28           C  
ATOM    970  C   ARG A 150       4.381  -6.025   3.440  1.00 57.95           C  
ATOM    971  O   ARG A 150       3.773  -5.943   2.374  1.00 58.04           O  
ATOM    972  CB  ARG A 150       6.320  -7.615   3.539  1.00 57.85           C  
ATOM    973  CG  ARG A 150       7.731  -7.874   3.027  1.00 57.89           C  
ATOM    974  CD  ARG A 150       8.023  -9.333   2.773  1.00 58.21           C  
ATOM    975  NE  ARG A 150       7.958 -10.127   3.996  1.00 60.60           N  
ATOM    976  CZ  ARG A 150       8.977 -10.327   4.831  1.00 61.18           C  
ATOM    977  NH1 ARG A 150      10.163  -9.793   4.581  1.00 61.00           N  
ATOM    978  NH2 ARG A 150       8.804 -11.070   5.926  1.00 61.79           N  
ATOM    979  N   GLU A 151       3.785  -6.023   4.628  1.00 57.46           N  
ATOM    980  CA  GLU A 151       2.346  -5.851   4.782  1.00 56.80           C  
ATOM    981  C   GLU A 151       1.912  -4.474   4.314  1.00 55.88           C  
ATOM    982  O   GLU A 151       0.880  -4.329   3.650  1.00 56.03           O  
ATOM    983  CB  GLU A 151       1.939  -6.067   6.246  1.00 57.14           C  
ATOM    984  CG  GLU A 151       1.631  -7.510   6.560  1.00 57.33           C  
ATOM    985  CD  GLU A 151       0.434  -8.035   5.765  1.00 59.41           C  
ATOM    986  OE1 GLU A 151       0.629  -8.721   4.729  1.00 59.39           O  
ATOM    987  OE2 GLU A 151      -0.712  -7.744   6.177  1.00 60.75           O  
HETATM  988  N   MSE A 152       2.713  -3.471   4.671  1.00 54.38           N  
HETATM  989  CA  MSE A 152       2.501  -2.108   4.211  1.00 52.89           C  
HETATM  990  C   MSE A 152       2.573  -1.965   2.661  1.00 52.26           C  
HETATM  991  O   MSE A 152       1.768  -1.248   2.068  1.00 52.17           O  
HETATM  992  CB  MSE A 152       3.453  -1.144   4.935  1.00 52.96           C  
HETATM  993  CG  MSE A 152       3.210  -1.034   6.469  1.00 52.32           C  
HETATM  994 SE   MSE A 152       4.637  -0.077   7.446  1.00 51.66          SE  
HETATM  995  CE  MSE A 152       4.599   1.568   6.574  1.00 49.78           C  
ATOM    996  N   ALA A 153       3.498  -2.659   1.997  1.00 51.08           N  
ATOM    997  CA  ALA A 153       3.590  -2.554   0.523  1.00 49.95           C  
ATOM    998  C   ALA A 153       2.400  -3.246  -0.140  1.00 49.17           C  
ATOM    999  O   ALA A 153       1.862  -2.793  -1.157  1.00 48.58           O  
ATOM   1000  CB  ALA A 153       4.914  -3.116   0.007  1.00 49.21           C  
ATOM   1001  N   ARG A 154       1.977  -4.324   0.500  1.00 48.75           N  
ATOM   1002  CA  ARG A 154       0.958  -5.236  -0.000  1.00 48.39           C  
ATOM   1003  C   ARG A 154      -0.424  -4.571  -0.123  1.00 48.69           C  
ATOM   1004  O   ARG A 154      -1.321  -5.103  -0.769  1.00 48.89           O  
ATOM   1005  CB  ARG A 154       0.909  -6.422   0.964  1.00 47.86           C  
ATOM   1006  CG  ARG A 154       0.533  -7.739   0.379  1.00 46.36           C  
ATOM   1007  CD  ARG A 154      -0.907  -8.070   0.676  1.00 43.89           C  
ATOM   1008  NE  ARG A 154      -1.220  -7.966   2.099  1.00 42.06           N  
ATOM   1009  CZ  ARG A 154      -2.448  -7.831   2.584  1.00 40.79           C  
ATOM   1010  NH1 ARG A 154      -3.495  -7.784   1.766  1.00 40.66           N  
ATOM   1011  NH2 ARG A 154      -2.632  -7.726   3.888  1.00 39.60           N  
ATOM   1012  N   VAL A 155      -0.575  -3.399   0.489  1.00 48.88           N  
ATOM   1013  CA  VAL A 155      -1.877  -2.752   0.676  1.00 49.05           C  
ATOM   1014  C   VAL A 155      -1.920  -1.329   0.102  1.00 48.87           C  
ATOM   1015  O   VAL A 155      -2.987  -0.712  -0.020  1.00 48.80           O  
ATOM   1016  CB  VAL A 155      -2.219  -2.693   2.154  1.00 49.28           C  
ATOM   1017  CG1 VAL A 155      -3.483  -1.922   2.345  1.00 50.76           C  
ATOM   1018  CG2 VAL A 155      -2.394  -4.111   2.706  1.00 49.72           C  
ATOM   1019  N   LEU A 156      -0.739  -0.813  -0.210  1.00 48.36           N  
ATOM   1020  CA  LEU A 156      -0.583   0.367  -1.022  1.00 48.30           C  
ATOM   1021  C   LEU A 156      -0.878   0.030  -2.504  1.00 48.54           C  
ATOM   1022  O   LEU A 156      -0.577  -1.079  -2.984  1.00 48.27           O  
ATOM   1023  CB  LEU A 156       0.855   0.853  -0.876  1.00 47.96           C  
ATOM   1024  CG  LEU A 156       1.178   2.324  -1.064  1.00 47.99           C  
ATOM   1025  CD1 LEU A 156       0.475   3.194  -0.014  1.00 48.42           C  
ATOM   1026  CD2 LEU A 156       2.686   2.499  -0.987  1.00 48.30           C  
ATOM   1027  N   ARG A 157      -1.470   0.979  -3.226  1.00 48.55           N  
ATOM   1028  CA  ARG A 157      -1.711   0.783  -4.650  1.00 48.66           C  
ATOM   1029  C   ARG A 157      -0.471   1.253  -5.434  1.00 48.78           C  
ATOM   1030  O   ARG A 157       0.263   2.129  -4.954  1.00 48.73           O  
ATOM   1031  CB  ARG A 157      -3.019   1.470  -5.092  1.00 48.55           C  
ATOM   1032  CG  ARG A 157      -2.902   2.785  -5.851  1.00 49.16           C  
ATOM   1033  CD  ARG A 157      -3.025   3.993  -4.959  1.00 51.57           C  
ATOM   1034  NE  ARG A 157      -3.450   5.195  -5.684  1.00 55.06           N  
ATOM   1035  CZ  ARG A 157      -2.630   6.123  -6.190  1.00 58.34           C  
ATOM   1036  NH1 ARG A 157      -3.134   7.179  -6.817  1.00 59.75           N  
ATOM   1037  NH2 ARG A 157      -1.305   6.015  -6.084  1.00 59.34           N  
ATOM   1038  N   PRO A 158      -0.204   0.654  -6.620  1.00 48.73           N  
ATOM   1039  CA  PRO A 158       0.953   1.129  -7.387  1.00 48.39           C  
ATOM   1040  C   PRO A 158       0.834   2.637  -7.616  1.00 48.19           C  
ATOM   1041  O   PRO A 158      -0.272   3.144  -7.823  1.00 48.01           O  
ATOM   1042  CB  PRO A 158       0.867   0.335  -8.706  1.00 48.18           C  
ATOM   1043  CG  PRO A 158      -0.480  -0.249  -8.744  1.00 48.02           C  
ATOM   1044  CD  PRO A 158      -0.901  -0.443  -7.318  1.00 48.66           C  
ATOM   1045  N   GLY A 159       1.957   3.344  -7.543  1.00 48.10           N  
ATOM   1046  CA  GLY A 159       1.929   4.798  -7.521  1.00 48.36           C  
ATOM   1047  C   GLY A 159       1.908   5.381  -6.117  1.00 48.80           C  
ATOM   1048  O   GLY A 159       2.260   6.547  -5.927  1.00 48.86           O  
ATOM   1049  N   GLY A 160       1.499   4.573  -5.132  1.00 49.32           N  
ATOM   1050  CA  GLY A 160       1.375   5.000  -3.724  1.00 49.60           C  
ATOM   1051  C   GLY A 160       2.694   5.304  -3.023  1.00 49.77           C  
ATOM   1052  O   GLY A 160       3.743   4.794  -3.439  1.00 49.80           O  
ATOM   1053  N   THR A 161       2.633   6.116  -1.958  1.00 49.68           N  
ATOM   1054  CA  THR A 161       3.838   6.612  -1.252  1.00 49.68           C  
ATOM   1055  C   THR A 161       3.886   6.176   0.218  1.00 49.66           C  
ATOM   1056  O   THR A 161       2.854   5.811   0.808  1.00 49.81           O  
ATOM   1057  CB  THR A 161       3.960   8.160  -1.296  1.00 49.59           C  
ATOM   1058  OG1 THR A 161       2.880   8.739  -0.562  1.00 51.15           O  
ATOM   1059  CG2 THR A 161       3.921   8.697  -2.718  1.00 49.13           C  
ATOM   1060  N   VAL A 162       5.083   6.223   0.803  1.00 49.31           N  
ATOM   1061  CA  VAL A 162       5.292   5.819   2.188  1.00 49.10           C  
ATOM   1062  C   VAL A 162       6.146   6.853   2.929  1.00 49.06           C  
ATOM   1063  O   VAL A 162       7.022   7.488   2.340  1.00 48.93           O  
ATOM   1064  CB  VAL A 162       5.958   4.418   2.274  1.00 49.52           C  
ATOM   1065  CG1 VAL A 162       6.228   3.998   3.731  1.00 50.07           C  
ATOM   1066  CG2 VAL A 162       5.104   3.360   1.589  1.00 49.00           C  
ATOM   1067  N   ALA A 163       5.877   7.019   4.220  1.00 49.06           N  
ATOM   1068  CA  ALA A 163       6.697   7.865   5.086  1.00 49.13           C  
ATOM   1069  C   ALA A 163       7.047   7.163   6.403  1.00 49.29           C  
ATOM   1070  O   ALA A 163       6.164   6.680   7.133  1.00 48.51           O  
ATOM   1071  CB  ALA A 163       6.012   9.175   5.349  1.00 48.90           C  
ATOM   1072  N   ILE A 164       8.341   7.097   6.696  1.00 49.63           N  
ATOM   1073  CA  ILE A 164       8.793   6.533   7.973  1.00 50.15           C  
ATOM   1074  C   ILE A 164       9.519   7.582   8.820  1.00 50.43           C  
ATOM   1075  O   ILE A 164      10.277   8.394   8.286  1.00 50.17           O  
ATOM   1076  CB  ILE A 164       9.685   5.300   7.760  1.00 49.93           C  
ATOM   1077  CG1 ILE A 164       8.889   4.200   7.069  1.00 49.69           C  
ATOM   1078  CG2 ILE A 164      10.225   4.791   9.085  1.00 49.64           C  
ATOM   1079  CD1 ILE A 164       9.736   3.326   6.180  1.00 50.14           C  
ATOM   1080  N   ALA A 165       9.257   7.571  10.129  1.00 50.90           N  
ATOM   1081  CA  ALA A 165      10.036   8.356  11.102  1.00 51.58           C  
ATOM   1082  C   ALA A 165      10.357   7.456  12.280  1.00 52.58           C  
ATOM   1083  O   ALA A 165       9.457   6.859  12.864  1.00 53.21           O  
ATOM   1084  CB  ALA A 165       9.255   9.556  11.560  1.00 51.20           C  
ATOM   1085  N   ASP A 166      11.633   7.326  12.623  1.00 53.52           N  
ATOM   1086  CA  ASP A 166      12.005   6.458  13.741  1.00 54.18           C  
ATOM   1087  C   ASP A 166      13.405   6.738  14.272  1.00 54.92           C  
ATOM   1088  O   ASP A 166      14.199   7.422  13.600  1.00 54.86           O  
ATOM   1089  CB  ASP A 166      11.892   4.995  13.323  1.00 54.06           C  
ATOM   1090  CG  ASP A 166      11.331   4.134  14.430  1.00 54.10           C  
ATOM   1091  OD1 ASP A 166      11.251   4.677  15.545  1.00 54.77           O  
ATOM   1092  OD2 ASP A 166      10.967   2.949  14.202  1.00 52.86           O  
ATOM   1093  N   PHE A 167      13.721   6.230  15.470  1.00 55.14           N  
ATOM   1094  CA  PHE A 167      15.099   6.369  15.955  1.00 55.57           C  
ATOM   1095  C   PHE A 167      16.004   5.185  15.654  1.00 55.42           C  
ATOM   1096  O   PHE A 167      15.559   4.035  15.625  1.00 55.87           O  
ATOM   1097  CB  PHE A 167      15.205   6.801  17.426  1.00 56.89           C  
ATOM   1098  CG  PHE A 167      14.247   6.122  18.346  1.00 56.91           C  
ATOM   1099  CD1 PHE A 167      14.558   4.895  18.901  1.00 57.90           C  
ATOM   1100  CD2 PHE A 167      13.043   6.744  18.692  1.00 58.37           C  
ATOM   1101  CE1 PHE A 167      13.649   4.253  19.793  1.00 61.13           C  
ATOM   1102  CE2 PHE A 167      12.118   6.124  19.566  1.00 61.16           C  
ATOM   1103  CZ  PHE A 167      12.427   4.869  20.128  1.00 59.88           C  
ATOM   1104  N   VAL A 168      17.286   5.491  15.451  1.00 55.00           N  
ATOM   1105  CA  VAL A 168      18.269   4.557  14.887  1.00 54.30           C  
ATOM   1106  C   VAL A 168      19.571   4.544  15.674  1.00 53.98           C  
ATOM   1107  O   VAL A 168      19.850   5.464  16.441  1.00 54.20           O  
ATOM   1108  CB  VAL A 168      18.633   4.946  13.429  1.00 54.32           C  
ATOM   1109  CG1 VAL A 168      17.529   4.564  12.470  1.00 53.98           C  
ATOM   1110  CG2 VAL A 168      18.934   6.435  13.332  1.00 53.66           C  
ATOM   1111  N   LEU A 169      20.380   3.513  15.453  1.00 53.54           N  
ATOM   1112  CA  LEU A 169      21.706   3.437  16.040  1.00 53.09           C  
ATOM   1113  C   LEU A 169      22.739   3.570  14.928  1.00 53.26           C  
ATOM   1114  O   LEU A 169      23.015   2.611  14.217  1.00 53.38           O  
ATOM   1115  CB  LEU A 169      21.862   2.109  16.777  1.00 53.14           C  
ATOM   1116  CG  LEU A 169      23.074   1.844  17.673  1.00 53.05           C  
ATOM   1117  CD1 LEU A 169      22.942   2.553  19.023  1.00 52.28           C  
ATOM   1118  CD2 LEU A 169      23.259   0.339  17.868  1.00 52.66           C  
ATOM   1119  N   LEU A 170      23.299   4.767  14.779  1.00 53.34           N  
ATOM   1120  CA  LEU A 170      24.280   5.067  13.735  1.00 53.31           C  
ATOM   1121  C   LEU A 170      25.585   4.254  13.802  1.00 53.49           C  
ATOM   1122  O   LEU A 170      26.266   4.097  12.772  1.00 53.67           O  
ATOM   1123  CB  LEU A 170      24.622   6.557  13.744  1.00 53.23           C  
ATOM   1124  CG  LEU A 170      23.458   7.523  13.958  1.00 53.67           C  
ATOM   1125  CD1 LEU A 170      23.955   8.878  14.485  1.00 53.34           C  
ATOM   1126  CD2 LEU A 170      22.645   7.681  12.688  1.00 52.80           C  
ATOM   1127  N   ALA A 171      25.949   3.769  14.992  1.00 53.29           N  
ATOM   1128  CA  ALA A 171      27.152   2.933  15.162  1.00 53.22           C  
ATOM   1129  C   ALA A 171      27.039   1.988  16.368  1.00 53.27           C  
ATOM   1130  O   ALA A 171      26.327   2.302  17.323  1.00 53.31           O  
ATOM   1131  CB  ALA A 171      28.392   3.808  15.284  1.00 52.99           C  
ATOM   1132  N   PRO A 172      27.727   0.822  16.326  1.00 53.29           N  
ATOM   1133  CA  PRO A 172      27.777  -0.064  17.503  1.00 53.30           C  
ATOM   1134  C   PRO A 172      28.392   0.621  18.741  1.00 53.21           C  
ATOM   1135  O   PRO A 172      29.231   1.519  18.600  1.00 53.14           O  
ATOM   1136  CB  PRO A 172      28.655  -1.236  17.028  1.00 53.29           C  
ATOM   1137  CG  PRO A 172      29.418  -0.711  15.858  1.00 53.13           C  
ATOM   1138  CD  PRO A 172      28.479   0.252  15.191  1.00 53.38           C  
ATOM   1139  N   VAL A 173      27.974   0.197  19.935  1.00 52.97           N  
ATOM   1140  CA  VAL A 173      28.383   0.850  21.193  1.00 52.71           C  
ATOM   1141  C   VAL A 173      28.926  -0.118  22.251  1.00 52.40           C  
ATOM   1142  O   VAL A 173      28.775  -1.334  22.120  1.00 52.45           O  
ATOM   1143  CB  VAL A 173      27.224   1.677  21.811  1.00 52.80           C  
ATOM   1144  CG1 VAL A 173      26.954   2.920  20.975  1.00 53.05           C  
ATOM   1145  CG2 VAL A 173      25.959   0.825  21.967  1.00 52.70           C  
ATOM   1146  N   GLU A 174      29.545   0.432  23.297  1.00 52.00           N  
ATOM   1147  CA  GLU A 174      30.119  -0.368  24.386  1.00 51.68           C  
ATOM   1148  C   GLU A 174      30.043   0.316  25.749  1.00 51.36           C  
ATOM   1149  O   GLU A 174      29.635   1.474  25.843  1.00 51.42           O  
ATOM   1150  CB  GLU A 174      31.574  -0.708  24.079  1.00 51.73           C  
ATOM   1151  CG  GLU A 174      31.747  -1.873  23.139  1.00 52.07           C  
ATOM   1152  CD  GLU A 174      33.185  -2.309  23.023  1.00 52.57           C  
ATOM   1153  OE1 GLU A 174      33.505  -2.996  22.033  1.00 52.92           O  
ATOM   1154  OE2 GLU A 174      33.992  -1.968  23.917  1.00 52.40           O  
ATOM   1155  N   GLY A 175      30.438  -0.411  26.797  1.00 50.90           N  
ATOM   1156  CA  GLY A 175      30.546   0.130  28.157  1.00 50.44           C  
ATOM   1157  C   GLY A 175      29.304   0.840  28.665  1.00 50.16           C  
ATOM   1158  O   GLY A 175      28.209   0.285  28.619  1.00 50.18           O  
ATOM   1159  N   ALA A 176      29.482   2.071  29.140  1.00 49.81           N  
ATOM   1160  CA  ALA A 176      28.372   2.897  29.627  1.00 49.38           C  
ATOM   1161  C   ALA A 176      27.483   3.450  28.499  1.00 49.16           C  
ATOM   1162  O   ALA A 176      26.327   3.817  28.729  1.00 49.03           O  
ATOM   1163  CB  ALA A 176      28.896   4.026  30.500  1.00 49.30           C  
ATOM   1164  N   LYS A 177      28.015   3.514  27.283  1.00 48.74           N  
ATOM   1165  CA  LYS A 177      27.191   3.905  26.135  1.00 48.53           C  
ATOM   1166  C   LYS A 177      26.165   2.831  25.785  1.00 48.38           C  
ATOM   1167  O   LYS A 177      24.997   3.134  25.538  1.00 48.28           O  
ATOM   1168  CB  LYS A 177      28.051   4.267  24.924  1.00 48.42           C  
ATOM   1169  CG  LYS A 177      28.476   5.720  24.918  1.00 48.01           C  
ATOM   1170  CD  LYS A 177      29.358   6.024  23.741  1.00 48.23           C  
ATOM   1171  CE  LYS A 177      29.696   7.491  23.684  1.00 48.50           C  
ATOM   1172  NZ  LYS A 177      30.554   7.784  22.506  1.00 49.74           N  
ATOM   1173  N   LYS A 178      26.610   1.578  25.778  1.00 48.34           N  
ATOM   1174  CA  LYS A 178      25.720   0.438  25.614  1.00 48.34           C  
ATOM   1175  C   LYS A 178      24.750   0.330  26.793  1.00 48.47           C  
ATOM   1176  O   LYS A 178      23.606  -0.083  26.620  1.00 48.29           O  
ATOM   1177  CB  LYS A 178      26.530  -0.855  25.473  1.00 48.50           C  
ATOM   1178  CG  LYS A 178      25.697  -2.099  25.165  1.00 48.41           C  
ATOM   1179  CD  LYS A 178      26.567  -3.267  24.740  1.00 48.03           C  
ATOM   1180  CE  LYS A 178      25.719  -4.494  24.457  1.00 47.77           C  
ATOM   1181  NZ  LYS A 178      24.770  -4.316  23.326  1.00 47.13           N  
ATOM   1182  N   GLU A 179      25.208   0.716  27.981  1.00 48.79           N  
ATOM   1183  CA  GLU A 179      24.398   0.602  29.200  1.00 49.25           C  
ATOM   1184  C   GLU A 179      23.220   1.582  29.176  1.00 49.09           C  
ATOM   1185  O   GLU A 179      22.124   1.263  29.633  1.00 48.86           O  
ATOM   1186  CB  GLU A 179      25.271   0.817  30.442  1.00 49.18           C  
ATOM   1187  CG  GLU A 179      25.007  -0.159  31.580  1.00 49.63           C  
ATOM   1188  CD  GLU A 179      26.120  -0.164  32.630  1.00 49.68           C  
ATOM   1189  OE1 GLU A 179      26.108   0.699  33.537  1.00 50.16           O  
ATOM   1190  OE2 GLU A 179      27.006  -1.043  32.554  1.00 50.36           O  
ATOM   1191  N   ALA A 180      23.458   2.765  28.619  1.00 49.34           N  
ATOM   1192  CA  ALA A 180      22.447   3.810  28.567  1.00 49.67           C  
ATOM   1193  C   ALA A 180      21.441   3.546  27.459  1.00 49.97           C  
ATOM   1194  O   ALA A 180      20.276   3.915  27.580  1.00 49.74           O  
ATOM   1195  CB  ALA A 180      23.096   5.170  28.410  1.00 49.45           C  
ATOM   1196  N   VAL A 181      21.901   2.900  26.389  1.00 50.70           N  
ATOM   1197  CA  VAL A 181      21.042   2.487  25.275  1.00 51.68           C  
ATOM   1198  C   VAL A 181      20.101   1.325  25.658  1.00 52.30           C  
ATOM   1199  O   VAL A 181      18.898   1.385  25.415  1.00 52.46           O  
ATOM   1200  CB  VAL A 181      21.886   2.135  24.017  1.00 51.66           C  
ATOM   1201  CG1 VAL A 181      21.046   1.441  22.952  1.00 51.34           C  
ATOM   1202  CG2 VAL A 181      22.517   3.390  23.439  1.00 51.92           C  
ATOM   1203  N   ASP A 182      20.651   0.275  26.255  1.00 53.24           N  
ATOM   1204  CA  ASP A 182      19.840  -0.842  26.742  1.00 54.18           C  
ATOM   1205  C   ASP A 182      18.694  -0.394  27.665  1.00 54.53           C  
ATOM   1206  O   ASP A 182      17.530  -0.702  27.397  1.00 54.56           O  
ATOM   1207  CB  ASP A 182      20.725  -1.915  27.390  1.00 54.38           C  
ATOM   1208  CG  ASP A 182      21.534  -2.719  26.352  1.00 55.34           C  
ATOM   1209  OD1 ASP A 182      20.982  -3.050  25.272  1.00 56.00           O  
ATOM   1210  OD2 ASP A 182      22.723  -3.026  26.613  1.00 56.52           O  
ATOM   1211  N   ALA A 183      19.025   0.361  28.713  1.00 55.17           N  
ATOM   1212  CA  ALA A 183      18.027   0.996  29.605  1.00 55.99           C  
ATOM   1213  C   ALA A 183      16.831   1.613  28.862  1.00 56.57           C  
ATOM   1214  O   ALA A 183      15.672   1.380  29.216  1.00 56.51           O  
ATOM   1215  CB  ALA A 183      18.698   2.054  30.495  1.00 55.49           C  
ATOM   1216  N   PHE A 184      17.128   2.389  27.823  1.00 57.61           N  
ATOM   1217  CA  PHE A 184      16.102   3.057  27.018  1.00 58.61           C  
ATOM   1218  C   PHE A 184      15.164   2.074  26.326  1.00 59.03           C  
ATOM   1219  O   PHE A 184      13.955   2.319  26.262  1.00 59.18           O  
ATOM   1220  CB  PHE A 184      16.756   3.952  25.978  1.00 58.78           C  
ATOM   1221  CG  PHE A 184      15.790   4.764  25.190  1.00 59.53           C  
ATOM   1222  CD1 PHE A 184      15.209   5.909  25.742  1.00 61.12           C  
ATOM   1223  CD2 PHE A 184      15.476   4.416  23.889  1.00 60.43           C  
ATOM   1224  CE1 PHE A 184      14.315   6.685  25.017  1.00 60.42           C  
ATOM   1225  CE2 PHE A 184      14.585   5.181  23.138  1.00 60.89           C  
ATOM   1226  CZ  PHE A 184      13.998   6.319  23.711  1.00 61.73           C  
ATOM   1227  N   ARG A 185      15.733   0.979  25.816  1.00 59.28           N  
ATOM   1228  CA  ARG A 185      14.992  -0.018  25.055  1.00 59.69           C  
ATOM   1229  C   ARG A 185      14.056  -0.800  25.964  1.00 60.04           C  
ATOM   1230  O   ARG A 185      12.923  -1.118  25.587  1.00 60.09           O  
ATOM   1231  CB  ARG A 185      15.951  -0.975  24.357  1.00 59.76           C  
ATOM   1232  CG  ARG A 185      16.897  -0.299  23.373  1.00 60.40           C  
ATOM   1233  CD  ARG A 185      17.815  -1.298  22.697  1.00 60.41           C  
ATOM   1234  NE  ARG A 185      17.129  -2.043  21.642  1.00 61.30           N  
ATOM   1235  CZ  ARG A 185      17.633  -3.104  21.015  1.00 61.97           C  
ATOM   1236  NH1 ARG A 185      18.838  -3.572  21.339  1.00 62.87           N  
ATOM   1237  NH2 ARG A 185      16.928  -3.708  20.064  1.00 61.40           N  
ATOM   1238  N   ALA A 186      14.546  -1.109  27.162  1.00 60.30           N  
ATOM   1239  CA  ALA A 186      13.753  -1.788  28.178  1.00 60.48           C  
ATOM   1240  C   ALA A 186      12.455  -1.025  28.419  1.00 60.73           C  
ATOM   1241  O   ALA A 186      11.370  -1.555  28.202  1.00 60.90           O  
ATOM   1242  CB  ALA A 186      14.543  -1.919  29.471  1.00 60.19           C  
ATOM   1243  N   GLY A 187      12.574   0.234  28.822  1.00 61.07           N  
ATOM   1244  CA  GLY A 187      11.409   1.013  29.232  1.00 61.34           C  
ATOM   1245  C   GLY A 187      10.510   1.497  28.115  1.00 61.63           C  
ATOM   1246  O   GLY A 187       9.345   1.802  28.350  1.00 61.39           O  
ATOM   1247  N   GLY A 188      11.057   1.579  26.901  1.00 62.18           N  
ATOM   1248  CA  GLY A 188      10.273   1.936  25.719  1.00 62.54           C  
ATOM   1249  C   GLY A 188       9.828   0.764  24.842  1.00 62.95           C  
ATOM   1250  O   GLY A 188       9.167   0.984  23.819  1.00 63.39           O  
ATOM   1251  N   GLY A 189      10.183  -0.467  25.222  1.00 62.57           N  
ATOM   1252  CA  GLY A 189       9.829  -1.648  24.443  1.00 62.58           C  
ATOM   1253  C   GLY A 189      10.338  -1.590  23.015  1.00 62.91           C  
ATOM   1254  O   GLY A 189       9.587  -1.823  22.070  1.00 63.31           O  
ATOM   1255  N   VAL A 190      11.618  -1.270  22.858  1.00 62.95           N  
ATOM   1256  CA  VAL A 190      12.230  -1.139  21.546  1.00 63.00           C  
ATOM   1257  C   VAL A 190      12.785  -2.483  21.112  1.00 63.02           C  
ATOM   1258  O   VAL A 190      13.971  -2.774  21.310  1.00 63.17           O  
ATOM   1259  CB  VAL A 190      13.361  -0.109  21.556  1.00 63.16           C  
ATOM   1260  CG1 VAL A 190      13.892   0.107  20.134  1.00 64.30           C  
ATOM   1261  CG2 VAL A 190      12.878   1.208  22.141  1.00 63.31           C  
ATOM   1262  N   LEU A 191      11.919  -3.299  20.515  1.00 62.85           N  
ATOM   1263  CA  LEU A 191      12.257  -4.686  20.200  1.00 62.45           C  
ATOM   1264  C   LEU A 191      13.282  -4.800  19.072  1.00 62.41           C  
ATOM   1265  O   LEU A 191      14.092  -5.723  19.079  1.00 62.60           O  
ATOM   1266  CB  LEU A 191      11.003  -5.519  19.903  1.00 62.26           C  
ATOM   1267  CG  LEU A 191       9.786  -5.428  20.851  1.00 62.59           C  
ATOM   1268  CD1 LEU A 191       8.836  -6.603  20.642  1.00 61.19           C  
ATOM   1269  CD2 LEU A 191      10.148  -5.305  22.341  1.00 62.90           C  
ATOM   1270  N   SER A 192      13.262  -3.871  18.115  1.00 62.04           N  
ATOM   1271  CA  SER A 192      14.280  -3.865  17.054  1.00 61.98           C  
ATOM   1272  C   SER A 192      14.789  -2.464  16.641  1.00 61.60           C  
ATOM   1273  O   SER A 192      14.094  -1.697  15.980  1.00 61.26           O  
ATOM   1274  CB  SER A 192      13.851  -4.713  15.838  1.00 62.14           C  
ATOM   1275  OG  SER A 192      12.733  -4.152  15.179  1.00 62.60           O  
ATOM   1276  N   LEU A 193      16.015  -2.166  17.064  1.00 61.23           N  
ATOM   1277  CA  LEU A 193      16.699  -0.919  16.777  1.00 61.04           C  
ATOM   1278  C   LEU A 193      17.815  -1.215  15.776  1.00 61.19           C  
ATOM   1279  O   LEU A 193      18.556  -2.193  15.937  1.00 60.90           O  
ATOM   1280  CB  LEU A 193      17.280  -0.365  18.071  1.00 60.79           C  
ATOM   1281  CG  LEU A 193      18.239   0.821  18.032  1.00 60.99           C  
ATOM   1282  CD1 LEU A 193      17.504   2.164  18.018  1.00 60.34           C  
ATOM   1283  CD2 LEU A 193      19.174   0.732  19.229  1.00 60.58           C  
ATOM   1284  N   GLY A 194      17.934  -0.381  14.741  1.00 61.22           N  
ATOM   1285  CA  GLY A 194      18.898  -0.655  13.674  1.00 61.41           C  
ATOM   1286  C   GLY A 194      19.466   0.576  13.010  1.00 61.40           C  
ATOM   1287  O   GLY A 194      18.979   1.676  13.249  1.00 61.73           O  
ATOM   1288  N   GLY A 195      20.501   0.388  12.186  1.00 61.06           N  
ATOM   1289  CA  GLY A 195      21.112   1.488  11.429  1.00 60.42           C  
ATOM   1290  C   GLY A 195      20.244   1.940  10.270  1.00 60.23           C  
ATOM   1291  O   GLY A 195      19.257   1.273   9.939  1.00 60.19           O  
ATOM   1292  N   ILE A 196      20.600   3.074   9.655  1.00 60.18           N  
ATOM   1293  CA  ILE A 196      19.855   3.599   8.494  1.00 59.97           C  
ATOM   1294  C   ILE A 196      19.968   2.629   7.330  1.00 60.16           C  
ATOM   1295  O   ILE A 196      18.973   2.306   6.683  1.00 60.23           O  
ATOM   1296  CB  ILE A 196      20.331   5.007   8.055  1.00 59.77           C  
ATOM   1297  CG1 ILE A 196      19.832   6.072   9.019  1.00 59.62           C  
ATOM   1298  CG2 ILE A 196      19.827   5.368   6.661  1.00 59.32           C  
ATOM   1299  CD1 ILE A 196      20.840   6.479  10.016  1.00 58.91           C  
ATOM   1300  N   ASP A 197      21.181   2.151   7.085  1.00 60.38           N  
ATOM   1301  CA  ASP A 197      21.428   1.193   6.009  1.00 60.94           C  
ATOM   1302  C   ASP A 197      20.516  -0.032   6.122  1.00 60.84           C  
ATOM   1303  O   ASP A 197      19.973  -0.501   5.119  1.00 61.00           O  
ATOM   1304  CB  ASP A 197      22.915   0.798   5.940  1.00 61.05           C  
ATOM   1305  CG  ASP A 197      23.540   0.555   7.323  1.00 61.89           C  
ATOM   1306  OD1 ASP A 197      22.883   0.796   8.367  1.00 61.87           O  
ATOM   1307  OD2 ASP A 197      24.712   0.121   7.356  1.00 62.44           O  
ATOM   1308  N   GLU A 198      20.328  -0.515   7.348  1.00 60.86           N  
ATOM   1309  CA  GLU A 198      19.383  -1.595   7.627  1.00 60.83           C  
ATOM   1310  C   GLU A 198      17.921  -1.223   7.285  1.00 60.79           C  
ATOM   1311  O   GLU A 198      17.221  -2.011   6.632  1.00 60.77           O  
ATOM   1312  CB  GLU A 198      19.471  -2.010   9.089  1.00 60.80           C  
ATOM   1313  CG  GLU A 198      20.813  -2.549   9.548  1.00 60.73           C  
ATOM   1314  CD  GLU A 198      20.732  -3.139  10.955  1.00 61.36           C  
ATOM   1315  OE1 GLU A 198      19.939  -2.625  11.785  1.00 62.22           O  
ATOM   1316  OE2 GLU A 198      21.451  -4.119  11.233  1.00 61.38           O  
ATOM   1317  N   TYR A 199      17.464  -0.044   7.727  1.00 60.34           N  
ATOM   1318  CA  TYR A 199      16.115   0.442   7.389  1.00 60.09           C  
ATOM   1319  C   TYR A 199      15.884   0.496   5.879  1.00 60.03           C  
ATOM   1320  O   TYR A 199      14.831   0.098   5.382  1.00 59.94           O  
ATOM   1321  CB  TYR A 199      15.858   1.826   7.993  1.00 60.25           C  
ATOM   1322  CG  TYR A 199      15.113   1.798   9.298  1.00 60.27           C  
ATOM   1323  CD1 TYR A 199      15.793   1.577  10.499  1.00 60.37           C  
ATOM   1324  CD2 TYR A 199      13.729   1.992   9.343  1.00 60.35           C  
ATOM   1325  CE1 TYR A 199      15.123   1.541  11.715  1.00 60.15           C  
ATOM   1326  CE2 TYR A 199      13.035   1.965  10.576  1.00 60.62           C  
ATOM   1327  CZ  TYR A 199      13.754   1.733  11.751  1.00 60.89           C  
ATOM   1328  OH  TYR A 199      13.122   1.677  12.974  1.00 62.01           O  
ATOM   1329  N   GLU A 200      16.882   0.988   5.156  1.00 59.85           N  
ATOM   1330  CA  GLU A 200      16.810   1.094   3.709  1.00 59.86           C  
ATOM   1331  C   GLU A 200      16.567  -0.267   3.028  1.00 59.49           C  
ATOM   1332  O   GLU A 200      15.610  -0.411   2.258  1.00 59.75           O  
ATOM   1333  CB  GLU A 200      18.057   1.809   3.164  1.00 59.87           C  
ATOM   1334  CG  GLU A 200      18.151   3.275   3.609  1.00 59.87           C  
ATOM   1335  CD  GLU A 200      19.375   3.991   3.077  1.00 60.61           C  
ATOM   1336  OE1 GLU A 200      20.503   3.665   3.514  1.00 62.22           O  
ATOM   1337  OE2 GLU A 200      19.209   4.891   2.221  1.00 61.91           O  
ATOM   1338  N   SER A 201      17.393  -1.268   3.329  1.00 58.80           N  
ATOM   1339  CA  SER A 201      17.247  -2.569   2.665  1.00 58.18           C  
ATOM   1340  C   SER A 201      16.016  -3.343   3.120  1.00 58.04           C  
ATOM   1341  O   SER A 201      15.550  -4.232   2.405  1.00 58.09           O  
ATOM   1342  CB  SER A 201      18.499  -3.418   2.815  1.00 57.97           C  
ATOM   1343  OG  SER A 201      18.847  -3.537   4.163  1.00 57.14           O  
ATOM   1344  N   ASP A 202      15.495  -2.996   4.301  1.00 57.78           N  
ATOM   1345  CA  ASP A 202      14.194  -3.479   4.766  1.00 57.34           C  
ATOM   1346  C   ASP A 202      13.091  -2.948   3.854  1.00 57.19           C  
ATOM   1347  O   ASP A 202      12.254  -3.722   3.366  1.00 57.27           O  
ATOM   1348  CB  ASP A 202      13.926  -3.041   6.206  1.00 57.53           C  
ATOM   1349  CG  ASP A 202      14.704  -3.852   7.238  1.00 57.89           C  
ATOM   1350  OD1 ASP A 202      15.368  -4.842   6.875  1.00 58.63           O  
ATOM   1351  OD2 ASP A 202      14.647  -3.490   8.432  1.00 58.67           O  
ATOM   1352  N   VAL A 203      13.108  -1.635   3.614  1.00 56.91           N  
ATOM   1353  CA  VAL A 203      12.224  -0.997   2.621  1.00 56.72           C  
ATOM   1354  C   VAL A 203      12.392  -1.594   1.211  1.00 56.59           C  
ATOM   1355  O   VAL A 203      11.394  -1.898   0.544  1.00 56.51           O  
ATOM   1356  CB  VAL A 203      12.387   0.554   2.574  1.00 56.73           C  
ATOM   1357  CG1 VAL A 203      11.461   1.171   1.521  1.00 56.84           C  
ATOM   1358  CG2 VAL A 203      12.083   1.166   3.929  1.00 56.14           C  
ATOM   1359  N   ARG A 204      13.640  -1.780   0.776  1.00 56.31           N  
ATOM   1360  CA  ARG A 204      13.900  -2.338  -0.562  1.00 56.27           C  
ATOM   1361  C   ARG A 204      13.442  -3.787  -0.709  1.00 56.14           C  
ATOM   1362  O   ARG A 204      13.061  -4.206  -1.798  1.00 56.01           O  
ATOM   1363  CB  ARG A 204      15.371  -2.179  -0.988  1.00 56.23           C  
ATOM   1364  CG  ARG A 204      15.748  -0.733  -1.253  1.00 56.13           C  
ATOM   1365  CD  ARG A 204      17.053  -0.552  -2.019  1.00 56.10           C  
ATOM   1366  NE  ARG A 204      17.489   0.847  -1.930  1.00 55.43           N  
ATOM   1367  CZ  ARG A 204      18.416   1.308  -1.086  1.00 54.93           C  
ATOM   1368  NH1 ARG A 204      19.062   0.479  -0.260  1.00 54.22           N  
ATOM   1369  NH2 ARG A 204      18.713   2.607  -1.082  1.00 52.96           N  
ATOM   1370  N   GLN A 205      13.471  -4.547   0.381  1.00 56.12           N  
ATOM   1371  CA  GLN A 205      12.991  -5.920   0.342  1.00 56.01           C  
ATOM   1372  C   GLN A 205      11.497  -6.007   0.078  1.00 56.02           C  
ATOM   1373  O   GLN A 205      11.041  -6.977  -0.507  1.00 56.25           O  
ATOM   1374  CB  GLN A 205      13.314  -6.657   1.632  1.00 56.19           C  
ATOM   1375  CG  GLN A 205      14.574  -7.488   1.562  1.00 56.88           C  
ATOM   1376  CD  GLN A 205      14.563  -8.659   2.539  1.00 57.86           C  
ATOM   1377  OE1 GLN A 205      14.868  -9.802   2.165  1.00 57.68           O  
ATOM   1378  NE2 GLN A 205      14.195  -8.384   3.792  1.00 57.65           N  
ATOM   1379  N   ALA A 206      10.732  -5.003   0.506  1.00 55.98           N  
ATOM   1380  CA  ALA A 206       9.281  -5.029   0.312  1.00 55.87           C  
ATOM   1381  C   ALA A 206       8.905  -4.627  -1.114  1.00 55.86           C  
ATOM   1382  O   ALA A 206       7.719  -4.510  -1.450  1.00 55.87           O  
ATOM   1383  CB  ALA A 206       8.589  -4.137   1.327  1.00 55.93           C  
ATOM   1384  N   GLU A 207       9.933  -4.456  -1.949  1.00 55.74           N  
ATOM   1385  CA  GLU A 207       9.819  -3.959  -3.329  1.00 55.44           C  
ATOM   1386  C   GLU A 207       9.241  -2.533  -3.389  1.00 54.96           C  
ATOM   1387  O   GLU A 207       8.407  -2.211  -4.244  1.00 55.44           O  
ATOM   1388  CB  GLU A 207       9.056  -4.931  -4.235  1.00 55.31           C  
ATOM   1389  CG  GLU A 207       9.707  -6.300  -4.373  1.00 55.84           C  
ATOM   1390  CD  GLU A 207       9.024  -7.166  -5.425  1.00 56.17           C  
ATOM   1391  OE1 GLU A 207       8.147  -7.983  -5.047  1.00 56.13           O  
ATOM   1392  OE2 GLU A 207       9.353  -7.017  -6.629  1.00 56.94           O  
ATOM   1393  N   LEU A 208       9.686  -1.693  -2.464  1.00 53.78           N  
ATOM   1394  CA  LEU A 208       9.424  -0.273  -2.548  1.00 53.12           C  
ATOM   1395  C   LEU A 208      10.703   0.427  -2.965  1.00 52.92           C  
ATOM   1396  O   LEU A 208      11.802  -0.009  -2.613  1.00 53.02           O  
ATOM   1397  CB  LEU A 208       8.947   0.280  -1.204  1.00 52.96           C  
ATOM   1398  CG  LEU A 208       7.664  -0.337  -0.638  1.00 51.92           C  
ATOM   1399  CD1 LEU A 208       7.516  -0.023   0.854  1.00 48.67           C  
ATOM   1400  CD2 LEU A 208       6.440   0.105  -1.452  1.00 51.09           C  
ATOM   1401  N   VAL A 209      10.551   1.508  -3.722  1.00 52.42           N  
ATOM   1402  CA  VAL A 209      11.672   2.330  -4.134  1.00 51.98           C  
ATOM   1403  C   VAL A 209      11.830   3.417  -3.098  1.00 51.93           C  
ATOM   1404  O   VAL A 209      10.844   3.984  -2.633  1.00 51.93           O  
ATOM   1405  CB  VAL A 209      11.425   2.962  -5.522  1.00 52.19           C  
ATOM   1406  CG1 VAL A 209      12.552   3.897  -5.898  1.00 51.73           C  
ATOM   1407  CG2 VAL A 209      11.222   1.877  -6.591  1.00 51.24           C  
ATOM   1408  N   VAL A 210      13.074   3.688  -2.728  1.00 51.93           N  
ATOM   1409  CA  VAL A 210      13.383   4.671  -1.699  1.00 51.78           C  
ATOM   1410  C   VAL A 210      13.655   6.009  -2.376  1.00 51.75           C  
ATOM   1411  O   VAL A 210      14.587   6.125  -3.169  1.00 51.52           O  
ATOM   1412  CB  VAL A 210      14.609   4.223  -0.847  1.00 51.51           C  
ATOM   1413  CG1 VAL A 210      15.038   5.302   0.107  1.00 51.04           C  
ATOM   1414  CG2 VAL A 210      14.278   2.985  -0.092  1.00 51.65           C  
ATOM   1415  N   THR A 211      12.852   7.017  -2.037  1.00 51.97           N  
ATOM   1416  CA  THR A 211      12.960   8.354  -2.661  1.00 52.11           C  
ATOM   1417  C   THR A 211      13.806   9.393  -1.880  1.00 52.08           C  
ATOM   1418  O   THR A 211      14.385  10.290  -2.488  1.00 51.82           O  
ATOM   1419  CB  THR A 211      11.561   8.941  -2.965  1.00 52.11           C  
ATOM   1420  OG1 THR A 211      10.847   9.114  -1.737  1.00 52.84           O  
ATOM   1421  CG2 THR A 211      10.756   8.024  -3.895  1.00 51.11           C  
ATOM   1422  N   SER A 212      13.834   9.292  -0.545  1.00 52.00           N  
ATOM   1423  CA  SER A 212      14.736  10.113   0.308  1.00 51.77           C  
ATOM   1424  C   SER A 212      14.961   9.504   1.689  1.00 51.71           C  
ATOM   1425  O   SER A 212      14.079   8.806   2.231  1.00 51.64           O  
ATOM   1426  CB  SER A 212      14.239  11.552   0.485  1.00 51.47           C  
ATOM   1427  OG  SER A 212      12.955  11.571   1.049  1.00 50.51           O  
ATOM   1428  N   THR A 213      16.151   9.750   2.232  1.00 50.95           N  
ATOM   1429  CA  THR A 213      16.480   9.352   3.593  1.00 50.95           C  
ATOM   1430  C   THR A 213      17.306  10.495   4.181  1.00 50.95           C  
ATOM   1431  O   THR A 213      18.318  10.879   3.611  1.00 50.57           O  
ATOM   1432  CB  THR A 213      17.266   8.021   3.657  1.00 50.56           C  
ATOM   1433  OG1 THR A 213      18.650   8.273   3.411  1.00 52.52           O  
ATOM   1434  CG2 THR A 213      16.787   7.048   2.626  1.00 49.12           C  
ATOM   1435  N   VAL A 214      16.846  11.062   5.294  1.00 51.44           N  
ATOM   1436  CA  VAL A 214      17.490  12.243   5.897  1.00 51.61           C  
ATOM   1437  C   VAL A 214      17.739  12.028   7.384  1.00 51.92           C  
ATOM   1438  O   VAL A 214      16.809  11.728   8.152  1.00 52.34           O  
ATOM   1439  CB  VAL A 214      16.645  13.532   5.677  1.00 51.90           C  
ATOM   1440  CG1 VAL A 214      17.220  14.704   6.444  1.00 51.49           C  
ATOM   1441  CG2 VAL A 214      16.556  13.886   4.182  1.00 51.27           C  
ATOM   1442  N   ASP A 215      18.999  12.156   7.780  1.00 52.00           N  
ATOM   1443  CA  ASP A 215      19.403  12.017   9.168  1.00 52.23           C  
ATOM   1444  C   ASP A 215      19.110  13.317   9.897  1.00 52.20           C  
ATOM   1445  O   ASP A 215      19.786  14.308   9.691  1.00 52.21           O  
ATOM   1446  CB  ASP A 215      20.897  11.700   9.234  1.00 52.67           C  
ATOM   1447  CG  ASP A 215      21.401  11.484  10.665  1.00 53.97           C  
ATOM   1448  OD1 ASP A 215      22.395  10.731  10.835  1.00 53.81           O  
ATOM   1449  OD2 ASP A 215      20.819  12.077  11.605  1.00 54.91           O  
ATOM   1450  N   ILE A 216      18.103  13.310  10.756  1.00 52.44           N  
ATOM   1451  CA  ILE A 216      17.751  14.504  11.525  1.00 52.61           C  
ATOM   1452  C   ILE A 216      18.123  14.400  13.033  1.00 53.05           C  
ATOM   1453  O   ILE A 216      17.429  14.922  13.914  1.00 53.04           O  
ATOM   1454  CB  ILE A 216      16.270  14.879  11.321  1.00 52.38           C  
ATOM   1455  CG1 ILE A 216      15.338  13.732  11.740  1.00 51.27           C  
ATOM   1456  CG2 ILE A 216      16.038  15.263   9.875  1.00 52.68           C  
ATOM   1457  CD1 ILE A 216      13.894  14.166  11.967  1.00 48.34           C  
ATOM   1458  N   SER A 217      19.234  13.729  13.309  1.00 52.91           N  
ATOM   1459  CA  SER A 217      19.655  13.510  14.664  1.00 52.90           C  
ATOM   1460  C   SER A 217      19.791  14.837  15.353  1.00 52.95           C  
ATOM   1461  O   SER A 217      19.182  15.056  16.394  1.00 53.54           O  
ATOM   1462  CB  SER A 217      20.978  12.756  14.693  1.00 52.92           C  
ATOM   1463  OG  SER A 217      20.773  11.429  14.239  1.00 54.05           O  
ATOM   1464  N   ALA A 218      20.572  15.732  14.751  1.00 53.03           N  
ATOM   1465  CA  ALA A 218      20.891  17.030  15.339  1.00 52.49           C  
ATOM   1466  C   ALA A 218      19.636  17.832  15.708  1.00 52.54           C  
ATOM   1467  O   ALA A 218      19.649  18.564  16.688  1.00 52.65           O  
ATOM   1468  CB  ALA A 218      21.796  17.821  14.411  1.00 52.08           C  
ATOM   1469  N   GLN A 219      18.557  17.659  14.941  1.00 52.68           N  
ATOM   1470  CA  GLN A 219      17.274  18.322  15.186  1.00 52.67           C  
ATOM   1471  C   GLN A 219      16.363  17.570  16.183  1.00 52.82           C  
ATOM   1472  O   GLN A 219      15.526  18.173  16.843  1.00 52.77           O  
ATOM   1473  CB  GLN A 219      16.512  18.489  13.863  1.00 53.00           C  
ATOM   1474  CG  GLN A 219      17.108  19.462  12.872  1.00 53.25           C  
ATOM   1475  CD  GLN A 219      18.328  18.918  12.152  1.00 53.73           C  
ATOM   1476  OE1 GLN A 219      19.440  19.368  12.389  1.00 55.99           O  
ATOM   1477  NE2 GLN A 219      18.128  17.954  11.281  1.00 53.13           N  
ATOM   1478  N   ALA A 220      16.510  16.255  16.262  1.00 52.89           N  
ATOM   1479  CA  ALA A 220      15.659  15.426  17.106  1.00 53.33           C  
ATOM   1480  C   ALA A 220      16.173  15.289  18.548  1.00 53.77           C  
ATOM   1481  O   ALA A 220      15.391  15.103  19.485  1.00 53.15           O  
ATOM   1482  CB  ALA A 220      15.487  14.061  16.476  1.00 52.71           C  
ATOM   1483  N   ARG A 221      17.490  15.391  18.705  1.00 54.29           N  
ATOM   1484  CA  ARG A 221      18.159  15.122  19.978  1.00 55.16           C  
ATOM   1485  C   ARG A 221      17.578  15.909  21.171  1.00 54.64           C  
ATOM   1486  O   ARG A 221      17.235  15.293  22.178  1.00 54.80           O  
ATOM   1487  CB  ARG A 221      19.686  15.300  19.840  1.00 55.25           C  
ATOM   1488  CG  ARG A 221      20.520  14.843  21.051  1.00 57.04           C  
ATOM   1489  CD  ARG A 221      22.010  14.582  20.706  1.00 56.82           C  
ATOM   1490  NE  ARG A 221      22.169  13.391  19.858  1.00 60.19           N  
ATOM   1491  CZ  ARG A 221      22.632  13.397  18.606  1.00 61.96           C  
ATOM   1492  NH1 ARG A 221      23.026  14.535  18.024  1.00 61.66           N  
ATOM   1493  NH2 ARG A 221      22.717  12.253  17.931  1.00 62.31           N  
ATOM   1494  N   PRO A 222      17.438  17.254  21.054  1.00 54.37           N  
ATOM   1495  CA  PRO A 222      16.979  18.081  22.183  1.00 54.03           C  
ATOM   1496  C   PRO A 222      15.733  17.568  22.889  1.00 54.09           C  
ATOM   1497  O   PRO A 222      15.492  17.954  24.037  1.00 54.20           O  
ATOM   1498  CB  PRO A 222      16.643  19.419  21.524  1.00 53.59           C  
ATOM   1499  CG  PRO A 222      17.498  19.476  20.358  1.00 53.69           C  
ATOM   1500  CD  PRO A 222      17.694  18.083  19.860  1.00 54.24           C  
ATOM   1501  N   SER A 223      14.953  16.726  22.204  1.00 53.81           N  
ATOM   1502  CA  SER A 223      13.688  16.207  22.723  1.00 53.99           C  
ATOM   1503  C   SER A 223      13.894  15.478  24.030  1.00 54.26           C  
ATOM   1504  O   SER A 223      13.002  15.432  24.881  1.00 54.48           O  
ATOM   1505  CB  SER A 223      13.050  15.224  21.737  1.00 53.76           C  
ATOM   1506  OG  SER A 223      12.981  15.769  20.434  1.00 54.79           O  
ATOM   1507  N   LEU A 224      15.067  14.879  24.172  1.00 54.34           N  
ATOM   1508  CA  LEU A 224      15.339  14.012  25.305  1.00 54.34           C  
ATOM   1509  C   LEU A 224      15.460  14.781  26.631  1.00 54.98           C  
ATOM   1510  O   LEU A 224      14.703  14.524  27.564  1.00 55.21           O  
ATOM   1511  CB  LEU A 224      16.563  13.142  25.016  1.00 53.97           C  
ATOM   1512  CG  LEU A 224      16.267  11.929  24.132  1.00 52.52           C  
ATOM   1513  CD1 LEU A 224      17.483  11.581  23.313  1.00 52.06           C  
ATOM   1514  CD2 LEU A 224      15.799  10.722  24.943  1.00 49.69           C  
ATOM   1515  N   VAL A 225      16.387  15.734  26.712  1.00 55.38           N  
ATOM   1516  CA  VAL A 225      16.504  16.566  27.899  1.00 55.74           C  
ATOM   1517  C   VAL A 225      15.235  17.396  28.102  1.00 56.78           C  
ATOM   1518  O   VAL A 225      14.769  17.569  29.229  1.00 57.36           O  
ATOM   1519  CB  VAL A 225      17.758  17.468  27.834  1.00 55.52           C  
ATOM   1520  CG1 VAL A 225      17.609  18.702  28.712  1.00 54.91           C  
ATOM   1521  CG2 VAL A 225      18.990  16.679  28.240  1.00 54.95           C  
ATOM   1522  N   LYS A 226      14.661  17.875  27.007  1.00 57.70           N  
ATOM   1523  CA  LYS A 226      13.544  18.814  27.076  1.00 58.36           C  
ATOM   1524  C   LYS A 226      12.298  18.142  27.640  1.00 58.70           C  
ATOM   1525  O   LYS A 226      11.496  18.791  28.305  1.00 58.86           O  
ATOM   1526  CB  LYS A 226      13.265  19.413  25.690  1.00 58.67           C  
ATOM   1527  CG  LYS A 226      12.555  20.769  25.680  1.00 59.50           C  
ATOM   1528  CD  LYS A 226      13.490  21.976  25.891  1.00 59.95           C  
ATOM   1529  CE  LYS A 226      12.723  23.310  25.705  1.00 60.49           C  
ATOM   1530  NZ  LYS A 226      13.306  24.513  26.429  1.00 59.76           N  
ATOM   1531  N   THR A 227      12.131  16.846  27.390  1.00 58.82           N  
ATOM   1532  CA  THR A 227      10.960  16.169  27.922  1.00 59.27           C  
ATOM   1533  C   THR A 227      11.220  15.645  29.333  1.00 59.17           C  
ATOM   1534  O   THR A 227      10.289  15.512  30.136  1.00 59.20           O  
ATOM   1535  CB  THR A 227      10.403  15.026  27.016  1.00 59.49           C  
ATOM   1536  OG1 THR A 227      11.237  13.874  27.113  1.00 60.92           O  
ATOM   1537  CG2 THR A 227      10.275  15.441  25.557  1.00 59.76           C  
ATOM   1538  N   ALA A 228      12.480  15.340  29.636  1.00 59.02           N  
ATOM   1539  CA  ALA A 228      12.867  15.059  31.021  1.00 58.74           C  
ATOM   1540  C   ALA A 228      12.453  16.252  31.891  1.00 58.40           C  
ATOM   1541  O   ALA A 228      11.882  16.077  32.963  1.00 58.47           O  
ATOM   1542  CB  ALA A 228      14.365  14.794  31.130  1.00 58.61           C  
ATOM   1543  N   GLU A 229      12.705  17.461  31.395  1.00 57.85           N  
ATOM   1544  CA  GLU A 229      12.303  18.680  32.089  1.00 57.63           C  
ATOM   1545  C   GLU A 229      10.786  18.824  32.293  1.00 57.49           C  
ATOM   1546  O   GLU A 229      10.327  19.150  33.393  1.00 57.07           O  
ATOM   1547  CB  GLU A 229      12.917  19.904  31.405  1.00 57.31           C  
ATOM   1548  CG  GLU A 229      14.431  19.946  31.598  1.00 57.49           C  
ATOM   1549  CD  GLU A 229      15.093  21.168  30.993  1.00 58.14           C  
ATOM   1550  OE1 GLU A 229      14.642  21.630  29.924  1.00 57.85           O  
ATOM   1551  OE2 GLU A 229      16.082  21.663  31.585  1.00 58.57           O  
ATOM   1552  N   ALA A 230      10.021  18.542  31.242  1.00 57.54           N  
ATOM   1553  CA  ALA A 230       8.557  18.640  31.271  1.00 57.59           C  
ATOM   1554  C   ALA A 230       7.903  17.803  32.378  1.00 57.65           C  
ATOM   1555  O   ALA A 230       6.989  18.278  33.080  1.00 57.58           O  
ATOM   1556  CB  ALA A 230       7.989  18.246  29.924  1.00 57.29           C  
ATOM   1557  N   PHE A 231       8.371  16.561  32.504  1.00 57.34           N  
ATOM   1558  CA  PHE A 231       7.863  15.628  33.489  1.00 57.40           C  
ATOM   1559  C   PHE A 231       8.216  16.086  34.890  1.00 57.74           C  
ATOM   1560  O   PHE A 231       7.427  15.929  35.812  1.00 58.11           O  
ATOM   1561  CB  PHE A 231       8.415  14.222  33.235  1.00 57.16           C  
ATOM   1562  CG  PHE A 231       7.633  13.437  32.213  1.00 57.00           C  
ATOM   1563  CD1 PHE A 231       7.999  13.451  30.868  1.00 56.35           C  
ATOM   1564  CD2 PHE A 231       6.519  12.684  32.591  1.00 57.38           C  
ATOM   1565  CE1 PHE A 231       7.279  12.724  29.919  1.00 55.71           C  
ATOM   1566  CE2 PHE A 231       5.794  11.951  31.642  1.00 56.61           C  
ATOM   1567  CZ  PHE A 231       6.182  11.980  30.301  1.00 56.00           C  
ATOM   1568  N   GLU A 232       9.407  16.657  35.039  1.00 57.99           N  
ATOM   1569  CA  GLU A 232       9.866  17.200  36.311  1.00 57.76           C  
ATOM   1570  C   GLU A 232       8.876  18.243  36.788  1.00 57.14           C  
ATOM   1571  O   GLU A 232       8.427  18.197  37.919  1.00 57.18           O  
ATOM   1572  CB  GLU A 232      11.238  17.835  36.136  1.00 58.13           C  
ATOM   1573  CG  GLU A 232      12.074  17.861  37.389  1.00 59.94           C  
ATOM   1574  CD  GLU A 232      12.938  16.623  37.530  1.00 62.57           C  
ATOM   1575  OE1 GLU A 232      13.495  16.157  36.499  1.00 63.89           O  
ATOM   1576  OE2 GLU A 232      13.064  16.129  38.675  1.00 62.38           O  
ATOM   1577  N   ASN A 233       8.531  19.171  35.900  1.00 56.68           N  
ATOM   1578  CA  ASN A 233       7.562  20.221  36.202  1.00 56.19           C  
ATOM   1579  C   ASN A 233       6.209  19.654  36.585  1.00 55.70           C  
ATOM   1580  O   ASN A 233       5.402  20.331  37.209  1.00 55.67           O  
ATOM   1581  CB  ASN A 233       7.394  21.164  35.005  1.00 56.22           C  
ATOM   1582  CG  ASN A 233       8.607  22.056  34.780  1.00 56.53           C  
ATOM   1583  OD1 ASN A 233       9.598  21.992  35.511  1.00 56.78           O  
ATOM   1584  ND2 ASN A 233       8.531  22.896  33.759  1.00 57.05           N  
ATOM   1585  N   ALA A 234       5.968  18.404  36.208  1.00 55.07           N  
ATOM   1586  CA  ALA A 234       4.668  17.801  36.411  1.00 54.57           C  
ATOM   1587  C   ALA A 234       4.776  16.670  37.408  1.00 54.38           C  
ATOM   1588  O   ALA A 234       3.856  15.865  37.541  1.00 54.39           O  
ATOM   1589  CB  ALA A 234       4.124  17.304  35.090  1.00 54.41           C  
ATOM   1590  N   ARG A 235       5.904  16.617  38.112  1.00 54.39           N  
ATOM   1591  CA  ARG A 235       6.204  15.511  39.019  1.00 54.50           C  
ATOM   1592  C   ARG A 235       5.055  15.162  39.972  1.00 54.42           C  
ATOM   1593  O   ARG A 235       4.757  13.993  40.173  1.00 54.22           O  
ATOM   1594  CB  ARG A 235       7.490  15.777  39.809  1.00 54.54           C  
ATOM   1595  CG  ARG A 235       7.535  15.046  41.132  1.00 55.34           C  
ATOM   1596  CD  ARG A 235       8.891  15.080  41.772  1.00 57.06           C  
ATOM   1597  NE  ARG A 235       9.643  13.907  41.370  1.00 59.23           N  
ATOM   1598  CZ  ARG A 235      10.686  13.940  40.554  1.00 59.78           C  
ATOM   1599  NH1 ARG A 235      11.113  15.109  40.079  1.00 60.58           N  
ATOM   1600  NH2 ARG A 235      11.309  12.810  40.237  1.00 57.98           N  
ATOM   1601  N   SER A 236       4.407  16.162  40.557  1.00 54.40           N  
ATOM   1602  CA  SER A 236       3.364  15.850  41.528  1.00 54.74           C  
ATOM   1603  C   SER A 236       2.046  15.429  40.880  1.00 54.72           C  
ATOM   1604  O   SER A 236       1.196  14.848  41.543  1.00 55.44           O  
ATOM   1605  CB  SER A 236       3.175  16.969  42.566  1.00 54.59           C  
ATOM   1606  OG  SER A 236       2.502  18.081  42.015  1.00 55.12           O  
ATOM   1607  N   GLN A 237       1.875  15.684  39.589  1.00 54.47           N  
ATOM   1608  CA  GLN A 237       0.647  15.251  38.916  1.00 54.46           C  
ATOM   1609  C   GLN A 237       0.782  13.941  38.125  1.00 54.28           C  
ATOM   1610  O   GLN A 237      -0.205  13.226  37.943  1.00 54.38           O  
ATOM   1611  CB  GLN A 237       0.015  16.363  38.063  1.00 54.56           C  
ATOM   1612  CG  GLN A 237       0.953  17.459  37.653  1.00 54.74           C  
ATOM   1613  CD  GLN A 237       1.189  18.441  38.768  1.00 55.85           C  
ATOM   1614  OE1 GLN A 237       0.253  19.030  39.304  1.00 56.22           O  
ATOM   1615  NE2 GLN A 237       2.448  18.618  39.136  1.00 57.68           N  
ATOM   1616  N   VAL A 238       1.992  13.619  37.672  1.00 53.79           N  
ATOM   1617  CA  VAL A 238       2.215  12.304  37.070  1.00 53.65           C  
ATOM   1618  C   VAL A 238       2.634  11.227  38.087  1.00 53.60           C  
ATOM   1619  O   VAL A 238       2.256  10.064  37.942  1.00 53.69           O  
ATOM   1620  CB  VAL A 238       3.139  12.332  35.794  1.00 53.49           C  
ATOM   1621  CG1 VAL A 238       2.719  13.443  34.844  1.00 53.26           C  
ATOM   1622  CG2 VAL A 238       4.603  12.448  36.146  1.00 53.50           C  
ATOM   1623  N   GLU A 239       3.368  11.625  39.127  1.00 53.56           N  
ATOM   1624  CA  GLU A 239       3.871  10.694  40.153  1.00 53.79           C  
ATOM   1625  C   GLU A 239       2.857   9.656  40.639  1.00 53.22           C  
ATOM   1626  O   GLU A 239       3.228   8.501  40.830  1.00 53.14           O  
ATOM   1627  CB  GLU A 239       4.451  11.449  41.354  1.00 53.78           C  
ATOM   1628  CG  GLU A 239       5.445  10.650  42.168  1.00 54.48           C  
ATOM   1629  CD  GLU A 239       5.855  11.365  43.451  1.00 54.98           C  
ATOM   1630  OE1 GLU A 239       5.183  11.182  44.504  1.00 54.44           O  
ATOM   1631  OE2 GLU A 239       6.867  12.102  43.398  1.00 57.14           O  
ATOM   1632  N   PRO A 240       1.584  10.055  40.850  1.00 53.08           N  
ATOM   1633  CA  PRO A 240       0.655   9.032  41.350  1.00 52.86           C  
ATOM   1634  C   PRO A 240       0.265   7.970  40.318  1.00 52.50           C  
ATOM   1635  O   PRO A 240      -0.230   6.914  40.689  1.00 52.16           O  
ATOM   1636  CB  PRO A 240      -0.565   9.844  41.818  1.00 52.71           C  
ATOM   1637  CG  PRO A 240      -0.501  11.122  41.078  1.00 53.29           C  
ATOM   1638  CD  PRO A 240       0.936  11.378  40.707  1.00 53.18           C  
ATOM   1639  N   PHE A 241       0.497   8.245  39.039  1.00 52.54           N  
ATOM   1640  CA  PHE A 241       0.178   7.286  37.970  1.00 52.38           C  
ATOM   1641  C   PHE A 241       1.302   6.281  37.767  1.00 52.01           C  
ATOM   1642  O   PHE A 241       1.047   5.124  37.476  1.00 51.97           O  
ATOM   1643  CB  PHE A 241      -0.116   8.006  36.643  1.00 52.47           C  
ATOM   1644  CG  PHE A 241      -1.387   8.821  36.661  1.00 53.15           C  
ATOM   1645  CD1 PHE A 241      -2.633   8.204  36.514  1.00 52.66           C  
ATOM   1646  CD2 PHE A 241      -1.343  10.212  36.837  1.00 52.81           C  
ATOM   1647  CE1 PHE A 241      -3.816   8.964  36.537  1.00 52.89           C  
ATOM   1648  CE2 PHE A 241      -2.519  10.976  36.870  1.00 51.81           C  
ATOM   1649  CZ  PHE A 241      -3.753  10.353  36.719  1.00 52.09           C  
HETATM 1650  N   MSE A 242       2.540   6.733  37.933  1.00 51.85           N  
HETATM 1651  CA  MSE A 242       3.721   5.932  37.611  1.00 51.21           C  
HETATM 1652  C   MSE A 242       4.424   5.390  38.853  1.00 52.13           C  
HETATM 1653  O   MSE A 242       5.152   4.399  38.767  1.00 52.18           O  
HETATM 1654  CB  MSE A 242       4.724   6.771  36.809  1.00 51.26           C  
HETATM 1655  CG  MSE A 242       4.284   7.181  35.404  1.00 49.83           C  
HETATM 1656 SE   MSE A 242       5.738   8.048  34.437  1.00 48.76          SE  
HETATM 1657  CE  MSE A 242       6.898   6.561  34.346  1.00 48.01           C  
ATOM   1658  N   GLY A 243       4.210   6.039  40.000  1.00 52.57           N  
ATOM   1659  CA  GLY A 243       5.037   5.810  41.184  1.00 53.19           C  
ATOM   1660  C   GLY A 243       6.312   6.646  41.102  1.00 53.85           C  
ATOM   1661  O   GLY A 243       6.766   6.998  40.000  1.00 53.73           O  
ATOM   1662  N   ALA A 244       6.895   6.959  42.260  1.00 54.30           N  
ATOM   1663  CA  ALA A 244       8.094   7.801  42.316  1.00 54.75           C  
ATOM   1664  C   ALA A 244       9.285   7.210  41.548  1.00 55.23           C  
ATOM   1665  O   ALA A 244       9.845   7.873  40.667  1.00 54.56           O  
ATOM   1666  CB  ALA A 244       8.471   8.094  43.756  1.00 54.68           C  
ATOM   1667  N   GLU A 245       9.650   5.961  41.862  1.00 55.92           N  
ATOM   1668  CA  GLU A 245      10.881   5.368  41.320  1.00 56.80           C  
ATOM   1669  C   GLU A 245      10.830   5.099  39.810  1.00 56.97           C  
ATOM   1670  O   GLU A 245      11.843   5.262  39.114  1.00 57.18           O  
ATOM   1671  CB  GLU A 245      11.312   4.126  42.106  1.00 56.57           C  
ATOM   1672  CG  GLU A 245      10.636   2.829  41.704  1.00 57.58           C  
ATOM   1673  CD  GLU A 245      11.313   1.594  42.308  1.00 57.88           C  
ATOM   1674  OE1 GLU A 245      11.269   1.419  43.547  1.00 58.51           O  
ATOM   1675  OE2 GLU A 245      11.882   0.788  41.536  1.00 59.35           O  
ATOM   1676  N   GLY A 246       9.657   4.691  39.320  1.00 57.06           N  
ATOM   1677  CA  GLY A 246       9.409   4.553  37.880  1.00 56.97           C  
ATOM   1678  C   GLY A 246       9.618   5.864  37.125  1.00 57.16           C  
ATOM   1679  O   GLY A 246      10.300   5.889  36.082  1.00 57.10           O  
ATOM   1680  N   LEU A 247       9.044   6.949  37.668  1.00 56.94           N  
ATOM   1681  CA  LEU A 247       9.181   8.300  37.117  1.00 56.50           C  
ATOM   1682  C   LEU A 247      10.643   8.720  37.107  1.00 56.71           C  
ATOM   1683  O   LEU A 247      11.097   9.362  36.167  1.00 57.08           O  
ATOM   1684  CB  LEU A 247       8.381   9.317  37.939  1.00 56.30           C  
ATOM   1685  CG  LEU A 247       7.780  10.600  37.322  1.00 55.84           C  
ATOM   1686  CD1 LEU A 247       7.876  11.788  38.287  1.00 52.55           C  
ATOM   1687  CD2 LEU A 247       8.344  10.991  35.943  1.00 54.14           C  
ATOM   1688  N   ASP A 248      11.380   8.347  38.148  1.00 56.77           N  
ATOM   1689  CA  ASP A 248      12.791   8.702  38.244  1.00 56.88           C  
ATOM   1690  C   ASP A 248      13.665   7.977  37.234  1.00 56.81           C  
ATOM   1691  O   ASP A 248      14.597   8.567  36.683  1.00 56.76           O  
ATOM   1692  CB  ASP A 248      13.320   8.439  39.647  1.00 57.11           C  
ATOM   1693  CG  ASP A 248      12.896   9.501  40.635  1.00 57.62           C  
ATOM   1694  OD1 ASP A 248      12.410  10.564  40.193  1.00 57.96           O  
ATOM   1695  OD2 ASP A 248      13.048   9.268  41.857  1.00 58.72           O  
ATOM   1696  N   ARG A 249      13.374   6.701  37.001  1.00 56.73           N  
ATOM   1697  CA  ARG A 249      14.174   5.908  36.080  1.00 56.79           C  
ATOM   1698  C   ARG A 249      13.994   6.392  34.643  1.00 56.22           C  
ATOM   1699  O   ARG A 249      14.945   6.388  33.856  1.00 56.26           O  
ATOM   1700  CB  ARG A 249      13.879   4.415  36.237  1.00 56.73           C  
ATOM   1701  CG  ARG A 249      14.734   3.770  37.321  1.00 57.92           C  
ATOM   1702  CD  ARG A 249      14.598   2.249  37.395  1.00 58.11           C  
ATOM   1703  NE  ARG A 249      13.642   1.822  38.427  1.00 60.93           N  
ATOM   1704  CZ  ARG A 249      12.580   1.043  38.209  1.00 61.58           C  
ATOM   1705  NH1 ARG A 249      12.320   0.570  36.988  1.00 62.01           N  
ATOM   1706  NH2 ARG A 249      11.775   0.728  39.218  1.00 60.75           N  
HETATM 1707  N   MSE A 250      12.780   6.837  34.332  1.00 55.55           N  
HETATM 1708  CA  MSE A 250      12.447   7.339  33.014  1.00 54.88           C  
HETATM 1709  C   MSE A 250      13.147   8.674  32.712  1.00 55.25           C  
HETATM 1710  O   MSE A 250      13.656   8.885  31.602  1.00 55.28           O  
HETATM 1711  CB  MSE A 250      10.926   7.460  32.866  1.00 55.11           C  
HETATM 1712  CG  MSE A 250      10.469   8.030  31.527  1.00 54.62           C  
HETATM 1713 SE   MSE A 250       8.580   8.299  31.474  1.00 53.68          SE  
HETATM 1714  CE  MSE A 250       8.507   9.511  30.223  1.00 56.87           C  
ATOM   1715  N   ILE A 251      13.164   9.571  33.694  1.00 55.16           N  
ATOM   1716  CA  ILE A 251      13.885  10.837  33.567  1.00 55.00           C  
ATOM   1717  C   ILE A 251      15.396  10.600  33.433  1.00 55.23           C  
ATOM   1718  O   ILE A 251      16.061  11.229  32.620  1.00 55.62           O  
ATOM   1719  CB  ILE A 251      13.589  11.774  34.760  1.00 54.82           C  
ATOM   1720  CG1 ILE A 251      12.106  12.142  34.789  1.00 54.14           C  
ATOM   1721  CG2 ILE A 251      14.466  13.039  34.712  1.00 54.85           C  
ATOM   1722  CD1 ILE A 251      11.678  12.813  36.074  1.00 53.86           C  
ATOM   1723  N   ALA A 252      15.928   9.677  34.224  1.00 55.52           N  
ATOM   1724  CA  ALA A 252      17.354   9.384  34.203  1.00 55.73           C  
ATOM   1725  C   ALA A 252      17.759   8.757  32.876  1.00 55.91           C  
ATOM   1726  O   ALA A 252      18.808   9.087  32.323  1.00 55.88           O  
ATOM   1727  CB  ALA A 252      17.732   8.463  35.375  1.00 55.40           C  
ATOM   1728  N   THR A 253      16.920   7.861  32.367  1.00 56.20           N  
ATOM   1729  CA  THR A 253      17.268   7.116  31.168  1.00 57.01           C  
ATOM   1730  C   THR A 253      17.354   8.009  29.921  1.00 56.64           C  
ATOM   1731  O   THR A 253      18.192   7.764  29.058  1.00 56.58           O  
ATOM   1732  CB  THR A 253      16.336   5.897  30.930  1.00 57.34           C  
ATOM   1733  OG1 THR A 253      16.795   5.174  29.783  1.00 59.31           O  
ATOM   1734  CG2 THR A 253      14.919   6.345  30.659  1.00 58.13           C  
ATOM   1735  N   PHE A 254      16.497   9.032  29.843  1.00 56.29           N  
ATOM   1736  CA  PHE A 254      16.537   9.994  28.742  1.00 55.92           C  
ATOM   1737  C   PHE A 254      17.803  10.828  28.814  1.00 55.77           C  
ATOM   1738  O   PHE A 254      18.441  11.072  27.793  1.00 55.72           O  
ATOM   1739  CB  PHE A 254      15.336  10.946  28.756  1.00 56.03           C  
ATOM   1740  CG  PHE A 254      13.994  10.277  28.608  1.00 56.32           C  
ATOM   1741  CD1 PHE A 254      13.878   8.942  28.179  1.00 56.20           C  
ATOM   1742  CD2 PHE A 254      12.827  11.005  28.865  1.00 56.17           C  
ATOM   1743  CE1 PHE A 254      12.619   8.337  28.033  1.00 55.17           C  
ATOM   1744  CE2 PHE A 254      11.558  10.411  28.724  1.00 56.46           C  
ATOM   1745  CZ  PHE A 254      11.454   9.068  28.299  1.00 55.38           C  
ATOM   1746  N   ARG A 255      18.158  11.271  30.018  1.00 55.45           N  
ATOM   1747  CA  ARG A 255      19.330  12.127  30.194  1.00 55.22           C  
ATOM   1748  C   ARG A 255      20.621  11.401  29.819  1.00 55.12           C  
ATOM   1749  O   ARG A 255      21.548  12.021  29.284  1.00 55.18           O  
ATOM   1750  CB  ARG A 255      19.403  12.714  31.606  1.00 55.02           C  
ATOM   1751  CG  ARG A 255      18.358  13.795  31.857  1.00 54.94           C  
ATOM   1752  CD  ARG A 255      18.723  14.656  33.056  1.00 55.91           C  
ATOM   1753  NE  ARG A 255      17.549  15.243  33.714  1.00 55.37           N  
ATOM   1754  CZ  ARG A 255      17.161  16.512  33.596  1.00 53.92           C  
ATOM   1755  NH1 ARG A 255      17.846  17.365  32.831  1.00 52.43           N  
ATOM   1756  NH2 ARG A 255      16.075  16.922  34.244  1.00 53.05           N  
ATOM   1757  N   GLY A 256      20.662  10.093  30.078  1.00 54.66           N  
ATOM   1758  CA  GLY A 256      21.771   9.253  29.638  1.00 54.13           C  
ATOM   1759  C   GLY A 256      21.809   9.110  28.123  1.00 53.88           C  
ATOM   1760  O   GLY A 256      22.875   9.191  27.512  1.00 53.60           O  
ATOM   1761  N   LEU A 257      20.645   8.906  27.510  1.00 53.70           N  
ATOM   1762  CA  LEU A 257      20.593   8.668  26.065  1.00 53.67           C  
ATOM   1763  C   LEU A 257      21.022   9.914  25.296  1.00 53.48           C  
ATOM   1764  O   LEU A 257      21.792   9.830  24.336  1.00 53.06           O  
ATOM   1765  CB  LEU A 257      19.218   8.160  25.600  1.00 53.57           C  
ATOM   1766  CG  LEU A 257      19.166   7.653  24.140  1.00 54.04           C  
ATOM   1767  CD1 LEU A 257      19.693   6.218  24.000  1.00 52.61           C  
ATOM   1768  CD2 LEU A 257      17.772   7.800  23.506  1.00 53.75           C  
ATOM   1769  N   ALA A 258      20.538  11.067  25.746  1.00 53.81           N  
ATOM   1770  CA  ALA A 258      20.948  12.358  25.189  1.00 53.99           C  
ATOM   1771  C   ALA A 258      22.469  12.462  25.004  1.00 54.09           C  
ATOM   1772  O   ALA A 258      22.942  12.974  23.984  1.00 54.26           O  
ATOM   1773  CB  ALA A 258      20.431  13.501  26.060  1.00 53.82           C  
ATOM   1774  N   GLU A 259      23.227  11.951  25.970  1.00 54.02           N  
ATOM   1775  CA  GLU A 259      24.682  12.019  25.898  1.00 54.19           C  
ATOM   1776  C   GLU A 259      25.393  10.872  25.126  1.00 54.11           C  
ATOM   1777  O   GLU A 259      26.628  10.811  25.101  1.00 54.10           O  
ATOM   1778  CB  GLU A 259      25.282  12.245  27.291  1.00 54.28           C  
ATOM   1779  CG  GLU A 259      24.977  13.635  27.893  1.00 55.73           C  
ATOM   1780  CD  GLU A 259      25.582  14.823  27.101  1.00 57.58           C  
ATOM   1781  OE1 GLU A 259      26.786  14.774  26.740  1.00 57.47           O  
ATOM   1782  OE2 GLU A 259      24.852  15.822  26.865  1.00 57.15           O  
ATOM   1783  N   VAL A 260      24.636   9.986  24.476  1.00 54.04           N  
ATOM   1784  CA  VAL A 260      25.255   9.051  23.517  1.00 53.97           C  
ATOM   1785  C   VAL A 260      24.984   9.458  22.049  1.00 54.00           C  
ATOM   1786  O   VAL A 260      23.876   9.270  21.544  1.00 54.14           O  
ATOM   1787  CB  VAL A 260      24.979   7.533  23.818  1.00 53.93           C  
ATOM   1788  CG1 VAL A 260      23.746   7.326  24.664  1.00 54.00           C  
ATOM   1789  CG2 VAL A 260      24.935   6.695  22.524  1.00 53.71           C  
ATOM   1790  N   PRO A 261      26.003  10.021  21.369  1.00 53.86           N  
ATOM   1791  CA  PRO A 261      25.785  10.591  20.041  1.00 53.98           C  
ATOM   1792  C   PRO A 261      25.610   9.540  18.928  1.00 54.09           C  
ATOM   1793  O   PRO A 261      25.334   9.899  17.777  1.00 54.42           O  
ATOM   1794  CB  PRO A 261      27.038  11.444  19.818  1.00 54.05           C  
ATOM   1795  CG  PRO A 261      28.102  10.775  20.629  1.00 53.86           C  
ATOM   1796  CD  PRO A 261      27.405  10.163  21.813  1.00 53.97           C  
ATOM   1797  N   GLU A 262      25.759   8.263  19.271  1.00 53.89           N  
ATOM   1798  CA  GLU A 262      25.433   7.171  18.356  1.00 53.57           C  
ATOM   1799  C   GLU A 262      23.920   6.927  18.310  1.00 53.37           C  
ATOM   1800  O   GLU A 262      23.443   6.034  17.604  1.00 53.18           O  
ATOM   1801  CB  GLU A 262      26.170   5.897  18.768  1.00 53.58           C  
ATOM   1802  CG  GLU A 262      27.695   5.960  18.575  1.00 54.60           C  
ATOM   1803  CD  GLU A 262      28.471   6.473  19.803  1.00 55.49           C  
ATOM   1804  OE1 GLU A 262      27.884   7.125  20.703  1.00 56.20           O  
ATOM   1805  OE2 GLU A 262      29.691   6.219  19.863  1.00 55.01           O  
ATOM   1806  N   ALA A 263      23.174   7.731  19.070  1.00 53.32           N  
ATOM   1807  CA  ALA A 263      21.711   7.630  19.151  1.00 53.47           C  
ATOM   1808  C   ALA A 263      21.066   8.632  18.198  1.00 53.23           C  
ATOM   1809  O   ALA A 263      21.148   9.849  18.400  1.00 53.32           O  
ATOM   1810  CB  ALA A 263      21.233   7.859  20.589  1.00 53.55           C  
ATOM   1811  N   GLY A 264      20.436   8.122  17.148  1.00 52.86           N  
ATOM   1812  CA  GLY A 264      20.045   8.977  16.041  1.00 52.57           C  
ATOM   1813  C   GLY A 264      18.595   8.832  15.670  1.00 52.64           C  
ATOM   1814  O   GLY A 264      17.869   8.046  16.281  1.00 52.09           O  
ATOM   1815  N   TYR A 265      18.197   9.588  14.645  1.00 52.84           N  
ATOM   1816  CA  TYR A 265      16.819   9.671  14.169  1.00 52.56           C  
ATOM   1817  C   TYR A 265      16.825   9.965  12.667  1.00 52.20           C  
ATOM   1818  O   TYR A 265      17.639  10.768  12.176  1.00 51.95           O  
ATOM   1819  CB  TYR A 265      16.103  10.799  14.908  1.00 53.47           C  
ATOM   1820  CG  TYR A 265      14.609  10.668  14.919  1.00 55.11           C  
ATOM   1821  CD1 TYR A 265      13.960   9.971  15.942  1.00 56.61           C  
ATOM   1822  CD2 TYR A 265      13.838  11.227  13.904  1.00 55.50           C  
ATOM   1823  CE1 TYR A 265      12.574   9.843  15.947  1.00 58.49           C  
ATOM   1824  CE2 TYR A 265      12.456  11.106  13.890  1.00 56.28           C  
ATOM   1825  CZ  TYR A 265      11.825  10.423  14.912  1.00 57.44           C  
ATOM   1826  OH  TYR A 265      10.450  10.303  14.899  1.00 57.31           O  
ATOM   1827  N   VAL A 266      15.905   9.333  11.940  1.00 51.51           N  
ATOM   1828  CA  VAL A 266      15.888   9.419  10.484  1.00 50.67           C  
ATOM   1829  C   VAL A 266      14.490   9.574   9.918  1.00 50.25           C  
ATOM   1830  O   VAL A 266      13.537   8.998  10.447  1.00 50.28           O  
ATOM   1831  CB  VAL A 266      16.593   8.182   9.831  1.00 50.93           C  
ATOM   1832  CG1 VAL A 266      15.662   6.936   9.806  1.00 50.33           C  
ATOM   1833  CG2 VAL A 266      17.072   8.517   8.456  1.00 49.90           C  
ATOM   1834  N   LEU A 267      14.388  10.335   8.827  1.00 49.57           N  
ATOM   1835  CA  LEU A 267      13.166  10.407   8.029  1.00 49.03           C  
ATOM   1836  C   LEU A 267      13.373   9.730   6.667  1.00 49.15           C  
ATOM   1837  O   LEU A 267      14.373  10.003   5.971  1.00 49.69           O  
ATOM   1838  CB  LEU A 267      12.757  11.860   7.808  1.00 48.42           C  
ATOM   1839  CG  LEU A 267      12.321  12.722   8.986  1.00 47.85           C  
ATOM   1840  CD1 LEU A 267      11.866  14.104   8.466  1.00 45.07           C  
ATOM   1841  CD2 LEU A 267      11.233  12.060   9.778  1.00 45.93           C  
ATOM   1842  N   ILE A 268      12.438   8.865   6.271  1.00 48.60           N  
ATOM   1843  CA  ILE A 268      12.548   8.154   4.984  1.00 48.21           C  
ATOM   1844  C   ILE A 268      11.258   8.191   4.161  1.00 48.08           C  
ATOM   1845  O   ILE A 268      10.196   7.770   4.651  1.00 47.92           O  
ATOM   1846  CB  ILE A 268      12.930   6.678   5.182  1.00 48.12           C  
ATOM   1847  CG1 ILE A 268      14.278   6.544   5.898  1.00 48.39           C  
ATOM   1848  CG2 ILE A 268      12.936   5.939   3.847  1.00 48.45           C  
ATOM   1849  CD1 ILE A 268      14.680   5.090   6.150  1.00 48.53           C  
ATOM   1850  N   GLY A 269      11.363   8.677   2.919  1.00 47.66           N  
ATOM   1851  CA  GLY A 269      10.269   8.630   1.959  1.00 47.71           C  
ATOM   1852  C   GLY A 269      10.472   7.483   0.989  1.00 48.47           C  
ATOM   1853  O   GLY A 269      11.607   7.162   0.635  1.00 49.17           O  
ATOM   1854  N   ALA A 270       9.386   6.857   0.544  1.00 48.96           N  
ATOM   1855  CA  ALA A 270       9.484   5.729  -0.386  1.00 49.06           C  
ATOM   1856  C   ALA A 270       8.227   5.612  -1.220  1.00 49.50           C  
ATOM   1857  O   ALA A 270       7.192   6.159  -0.853  1.00 49.89           O  
ATOM   1858  CB  ALA A 270       9.727   4.448   0.369  1.00 49.07           C  
ATOM   1859  N   ARG A 271       8.302   4.849  -2.303  1.00 49.80           N  
ATOM   1860  CA  ARG A 271       7.257   4.836  -3.319  1.00 50.57           C  
ATOM   1861  C   ARG A 271       7.030   3.425  -3.867  1.00 50.85           C  
ATOM   1862  O   ARG A 271       7.957   2.607  -3.876  1.00 51.38           O  
ATOM   1863  CB  ARG A 271       7.719   5.737  -4.450  1.00 50.76           C  
ATOM   1864  CG  ARG A 271       6.650   6.425  -5.232  1.00 52.00           C  
ATOM   1865  CD  ARG A 271       7.328   7.132  -6.377  1.00 55.19           C  
ATOM   1866  NE  ARG A 271       7.943   6.149  -7.268  1.00 58.03           N  
ATOM   1867  CZ  ARG A 271       9.020   6.362  -8.022  1.00 58.65           C  
ATOM   1868  NH1 ARG A 271       9.639   7.538  -7.999  1.00 59.72           N  
ATOM   1869  NH2 ARG A 271       9.476   5.389  -8.800  1.00 58.06           N  
ATOM   1870  N   LYS A 272       5.814   3.136  -4.334  1.00 50.61           N  
ATOM   1871  CA  LYS A 272       5.514   1.815  -4.879  1.00 50.70           C  
ATOM   1872  C   LYS A 272       5.382   1.821  -6.416  1.00 50.92           C  
ATOM   1873  O   LYS A 272       4.452   2.431  -6.964  1.00 50.71           O  
ATOM   1874  CB  LYS A 272       4.262   1.219  -4.228  1.00 50.71           C  
ATOM   1875  CG  LYS A 272       3.896  -0.153  -4.790  1.00 50.32           C  
ATOM   1876  CD  LYS A 272       2.535  -0.634  -4.348  1.00 49.68           C  
ATOM   1877  CE  LYS A 272       2.372  -2.122  -4.648  1.00 49.07           C  
ATOM   1878  NZ  LYS A 272       0.994  -2.608  -4.354  1.00 48.76           N  
ATOM   1879  N   PRO A 273       6.294   1.109  -7.109  1.00 51.02           N  
ATOM   1880  CA  PRO A 273       6.373   1.128  -8.573  1.00 51.55           C  
ATOM   1881  C   PRO A 273       5.001   1.050  -9.245  1.00 51.80           C  
ATOM   1882  O   PRO A 273       4.666   1.892 -10.083  1.00 51.85           O  
ATOM   1883  CB  PRO A 273       7.200  -0.126  -8.892  1.00 51.43           C  
ATOM   1884  CG  PRO A 273       8.124  -0.239  -7.727  1.00 51.19           C  
ATOM   1885  CD  PRO A 273       7.297   0.198  -6.528  1.00 51.03           C  
ATOM   1886  OXT PRO A 273       4.195   0.158  -8.948  1.00 52.14           O  
TER    1887      PRO A 273                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
