
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  251 ( 1928),  selected  251 , name 2vsu_C
# Molecule2: number of CA atoms  201 ( 1504),  selected  201 , name T0486_32_232.pdb
# PARAMETERS: 2vsu_C.T0486_32_232.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     6_C      -       -           -
LGA    R     7_C      -       -           -
LGA    W     8_C      P      32          5.497
LGA    K     9_C      R      33          0.877
LGA    T    10_C      P      34          0.340
LGA    V    11_C      T      35          0.226
LGA    K    12_C      S      36          0.539
LGA    V    13_C      A      37          0.721
LGA    E    14_C      R      38          1.842
LGA    I    15_C      Q      39          1.697
LGA    E    16_C      L      40          2.466
LGA    D    17_C      D      41          1.904
LGA    G    18_C      G      42          1.521
LGA    I    19_C      I      43          0.991
LGA    A    20_C      R      44          0.737
LGA    F    21_C      N      45          0.747
LGA    V    22_C      I      46          0.644
LGA    I    23_C      V      47          0.204
LGA    L    24_C      L      48          0.633
LGA    N    25_C      S      49          0.760
LGA    R    26_C      N      50          0.535
LGA    P    27_C      P      51          0.852
LGA    E    28_C      K      52          0.576
LGA    K    29_C      K      53          1.044
LGA    R    30_C      R      54          1.204
LGA    N    31_C      N      55          0.658
LGA    A    32_C      T      56          0.776
LGA    M    33_C      L      57          0.505
LGA    S    34_C      S      58          0.539
LGA    P    35_C      L      59          0.574
LGA    T    36_C      A      60          0.473
LGA    L    37_C      M      61          0.660
LGA    N    38_C      L      62          1.072
LGA    R    39_C      K      63          1.391
LGA    E    40_C      S      64          1.337
LGA    M    41_C      L      65          1.471
LGA    I    42_C      Q      66          1.699
LGA    D    43_C      S      67          1.360
LGA    V    44_C      D      68          1.217
LGA    L    45_C      I      69          1.348
LGA    E    46_C      L      70          1.323
LGA    T    47_C      X      71          0.534
LGA    L    48_C      D      72          4.338
LGA    E    49_C      A      73          0.974
LGA    Q    50_C      D      74          3.864
LGA    D    51_C      S      75          4.227
LGA    P    52_C      N      76          3.596
LGA    A    53_C      D      77          2.961
LGA    A    54_C      L      78          2.370
LGA    G    55_C      K      79          1.117
LGA    V    56_C      V      80          0.541
LGA    L    57_C      I      81          0.257
LGA    V    58_C      I      82          0.259
LGA    L    59_C      I      83          0.517
LGA    T    60_C      S      84          0.566
LGA    G    61_C      A      85          0.551
LGA    A    62_C      E      86          0.850
LGA    G    63_C      G      87          1.238
LGA    E    64_C      P      88          1.351
LGA    A    65_C      V      89          1.790
LGA    W    66_C      F      90          1.376
LGA    T    67_C      S      91          0.989
LGA    A    68_C      S      92          1.403
LGA    G    69_C      G      93          1.214
LGA    M    70_C      X      94          1.122
LGA    D    71_C      D      95          1.661
LGA    L    72_C      L      96          1.391
LGA    K    73_C      K      97          2.157
LGA    E    74_C      -       -           -
LGA    Y    75_C      E      98          1.607
LGA    F    76_C      L      99          3.355
LGA    R    77_C      T     100           #
LGA    E    78_C      E     101           -
LGA    V    79_C      E     102          5.900
LGA    D    80_C      Q     103          1.655
LGA    A    81_C      -       -           -
LGA    G    82_C      -       -           -
LGA    P    83_C      G     104          4.312
LGA    E    84_C      R     105          3.178
LGA    I    85_C      D     106          2.656
LGA    L    86_C      Y     107          3.109
LGA    Q    87_C      X     108          2.823
LGA    E    88_C      A     109          2.739
LGA    K    89_C      E     110          2.666
LGA    I    90_C      V     111          2.865
LGA    R    91_C      F     112          2.302
LGA    R    92_C      Q     113          1.667
LGA    E    93_C      T     114          1.477
LGA    A    94_C      C     115          1.721
LGA    S    95_C      S     116          1.451
LGA    Q    96_C      K     117          1.468
LGA    W    97_C      V     118          1.286
LGA    Q    98_C      M     119          2.837
LGA    W    99_C      -       -           -
LGA    K   100_C      M     120          1.885
LGA    L   101_C      X     121          0.859
LGA    L   102_C      I     122          1.232
LGA    R   103_C      R     123          1.688
LGA    M   104_C      N     124          1.909
LGA    Y   105_C      X     125          1.335
LGA    A   106_C      P     126          1.269
LGA    K   107_C      V     127          0.937
LGA    P   108_C      P     128          0.709
LGA    T   109_C      V     129          0.707
LGA    I   110_C      I     130          0.384
LGA    A   111_C      A     131          0.443
LGA    M   112_C      M     132          0.394
LGA    V   113_C      V     133          0.749
LGA    N   114_C      N     134          1.424
LGA    G   115_C      G     135          1.352
LGA    W   116_C      L     136          1.291
LGA    C   117_C      A     137          0.258
LGA    F   118_C      T     138          0.265
LGA    G   119_C      A     139          0.544
LGA    G   120_C      A     140          1.007
LGA    G   121_C      G     141          1.332
LGA    F   122_C      C     142          2.290
LGA    A   123_C      Q     143          2.147
LGA    P   124_C      L     144          1.889
LGA    L   125_C      V     145          1.368
LGA    V   126_C      A     146          1.955
LGA    A   127_C      S     147          1.795
LGA    C   128_C      C     148          0.798
LGA    D   129_C      D     149          0.365
LGA    L   130_C      I     150          0.586
LGA    A   131_C      A     151          0.445
LGA    I   132_C      V     152          0.496
LGA    C   133_C      A     153          0.473
LGA    A   134_C      S     154          0.634
LGA    D   135_C      D     155          0.290
LGA    E   136_C      K     156          0.712
LGA    A   137_C      S     157          0.744
LGA    T   138_C      S     158          1.761
LGA    F   139_C      F     159          1.257
LGA    G   140_C      A     160          1.079
LGA    L   141_C      T     161          1.312
LGA    S   142_C      P     162          1.125
LGA    E   143_C      G     163          1.145
LGA    I   144_C      V     164          1.754
LGA    N   145_C      N     165          1.654
LGA    W   146_C      V     166          1.838
LGA    G   147_C      G     167          1.794
LGA    I   148_C      L     168          1.938
LGA    P   149_C      F     169          1.380
LGA    P   150_C      C     170          0.991
LGA    G   151_C      S     171          3.410
LGA    N   152_C      T     172          2.213
LGA    L   153_C      -       -           -
LGA    V   154_C      P     173          1.045
LGA    S   155_C      G     174          0.873
LGA    K   156_C      V     175          1.647
LGA    A   157_C      A     176          0.949
LGA    M   158_C      L     177          1.271
LGA    A   159_C      A     178          1.142
LGA    D   160_C      R     179          0.806
LGA    T   161_C      A     180          1.210
LGA    V   162_C      V     181          0.407
LGA    G   163_C      P     182          0.917
LGA    H   164_C      R     183          1.440
LGA    R   165_C      K     184          1.093
LGA    Q   166_C      V     185          1.217
LGA    S   167_C      A     186          1.216
LGA    L   168_C      L     187          1.194
LGA    Y   169_C      E     188          1.293
LGA    Y   170_C      M     189          1.319
LGA    I   171_C      L     190          1.262
LGA    M   172_C      F     191          1.522
LGA    T   173_C      T     192          1.494
LGA    G   174_C      G     193          1.080
LGA    K   175_C      E     194          1.095
LGA    T   176_C      P     195          1.206
LGA    F   177_C      I     196          1.946
LGA    G   178_C      S     197          1.654
LGA    G   179_C      A     198          1.207
LGA    Q   180_C      Q     199          1.302
LGA    K   181_C      E     200          1.460
LGA    A   182_C      A     201          1.215
LGA    A   183_C      L     202          0.536
LGA    E   184_C      L     203          1.208
LGA    M   185_C      X     204          1.352
LGA    G   186_C      G     205          0.879
LGA    L   187_C      L     206          0.521
LGA    V   188_C      L     207          0.574
LGA    N   189_C      S     208          0.646
LGA    E   190_C      K     209          1.151
LGA    S   191_C      V     210          0.753
LGA    V   192_C      V     211          0.573
LGA    P   193_C      P     212          0.631
LGA    L   194_C      E     213          0.793
LGA    A   195_C      A     214          0.894
LGA    Q   196_C      E     215          0.624
LGA    L   197_C      L     216          0.521
LGA    R   198_C      Q     217          0.512
LGA    E   199_C      E     218          0.208
LGA    V   200_C      E     219          0.255
LGA    T   201_C      T     220          0.334
LGA    I   202_C      M     221          0.308
LGA    E   203_C      R     222          0.329
LGA    L   204_C      I     223          0.634
LGA    A   205_C      A     224          0.707
LGA    R   206_C      R     225          1.116
LGA    N   207_C      K     226          1.257
LGA    L   208_C      I     227          1.165
LGA    L   209_C      A     228          1.374
LGA    E   210_C      S     229          2.219
LGA    K   211_C      L     230          2.305
LGA    N   212_C      S     231          1.929
LGA    P   213_C      R     232          1.742
LGA    V   214_C      -       -           -
LGA    V   215_C      -       -           -
LGA    L   216_C      -       -           -
LGA    R   217_C      -       -           -
LGA    A   218_C      -       -           -
LGA    A   219_C      -       -           -
LGA    K   220_C      -       -           -
LGA    H   221_C      -       -           -
LGA    G   222_C      -       -           -
LGA    F   223_C      -       -           -
LGA    K   224_C      -       -           -
LGA    R   225_C      -       -           -
LGA    C   226_C      -       -           -
LGA    R   227_C      -       -           -
LGA    E   228_C      -       -           -
LGA    L   229_C      -       -           -
LGA    T   230_C      -       -           -
LGA    W   231_C      -       -           -
LGA    E   232_C      -       -           -
LGA    Q   233_C      -       -           -
LGA    N   234_C      -       -           -
LGA    E   235_C      -       -           -
LGA    D   236_C      -       -           -
LGA    Y   237_C      -       -           -
LGA    L   238_C      -       -           -
LGA    Y   239_C      -       -           -
LGA    A   240_C      -       -           -
LGA    K   241_C      -       -           -
LGA    L   242_C      -       -           -
LGA    D   243_C      -       -           -
LGA    Q   244_C      -       -           -
LGA    S   245_C      -       -           -
LGA    R   246_C      -       -           -
LGA    L   247_C      -       -           -
LGA    L   248_C      -       -           -
LGA    D   249_C      -       -           -
LGA    T   250_C      -       -           -
LGA    G   251_C      -       -           -
LGA    G   252_C      -       -           -
LGA    R   253_C      -       -           -
LGA    E   254_C      -       -           -
LGA    Q   255_C      -       -           -
LGA    G   256_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  251  201    5.0    199    1.61    25.13     91.887    11.614

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.361077 * X  +  -0.929006 * Y  +  -0.081066 * Z  + -25.772358
  Y_new =   0.830074 * X  +   0.359803 * Y  +  -0.426050 * Z  +  73.062256
  Z_new =   0.424971 * X  +   0.086546 * Y  +   0.901060 * Z  +  64.256042 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.095756   -3.045837  [ DEG:     5.4864   -174.5136 ]
  Theta =  -0.438930   -2.702663  [ DEG:   -25.1488   -154.8512 ]
  Phi   =   1.160491   -1.981102  [ DEG:    66.4912   -113.5088 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vsu_C                                        
REMARK     2: T0486_32_232.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vsu_C.T0486_32_232.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  251  201   5.0  199   1.61   25.13  91.887
REMARK  ---------------------------------------------------------- 
MOLECULE 2vsu_C
HEADER    LYASE                                   29-APR-08   2VSU              
TITLE     A TERNARY COMPLEX OF HYDROXYCINNAMOYL-COA HYDRATASE-LYASE (           
TITLE    2 HCHL) WITH ACETYL-COENZYME A AND VANILLIN GIVES INSIGHTS             
TITLE    3 INTO SUBSTRATE SPECIFICITY AND MECHANISM.                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND   3 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE S123A MUTANT;          
COMPND   4 CHAIN: A, B, D;                                                      
COMPND   5 EC: 4.2.1.101;                                                       
COMPND   6 MUTATION: YES;                                                       
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND  10 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE S123A MUTANT;          
COMPND  11 CHAIN: E;                                                            
COMPND  12 EC: 4.2.1.101;                                                       
COMPND  13 MUTATION: YES;                                                       
COMPND  14 ENGINEERED: YES;                                                     
COMPND  15 MOL_ID: 3;                                                           
COMPND  16 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND  17 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE S123A MUTANT;          
COMPND  18 CHAIN: C;                                                            
COMPND  19 FRAGMENT: RESIDUES 1-250, 252-276;                                   
COMPND  20 EC: 4.2.1.101;                                                       
COMPND  21 MUTATION: YES;                                                       
COMPND  22 ENGINEERED: YES;                                                     
COMPND  23 MOL_ID: 4;                                                           
COMPND  24 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND  25 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE S123A MUTANT;          
COMPND  26 CHAIN: F;                                                            
COMPND  27 EC: 4.2.1.101;                                                       
COMPND  28 MUTATION: YES;                                                       
COMPND  29 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE   5 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   6 STRAIN: AN103;                                                       
SOURCE   7 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH UK;               
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  12 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  13 STRAIN: AN103;                                                       
SOURCE  14 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH UK;               
SOURCE  15 MOL_ID: 3;                                                           
SOURCE  16 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  17 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  19 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  20 STRAIN: AN103;                                                       
SOURCE  21 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH UK;               
SOURCE  22 MOL_ID: 4;                                                           
SOURCE  23 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  24 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE  25 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  26 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  27 STRAIN: AN103;                                                       
SOURCE  28 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH UK                
KEYWDS    LYASE, ALDOLASE, CROTONASE, HYDRATASE                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.P.BENNETT,L.M.BERTIN,A.M.BRZOZOWSKI,N.J.WALTON,G.GROGAN             
REVDAT   1   27-MAY-08 2VSU    0                                                
JRNL        AUTH   J.P.BENNETT,L.M.BERTIN,B.MOULTON,I.J.S.FAIRLAMB,             
JRNL        AUTH 2 A.M.BRZOZOWSKI,N.J.WALTON,G.GROGAN                           
JRNL        TITL   A TERNARY COMPLEX OF HYDROXYCINNAMOYL-COA                    
JRNL        TITL 2 HYDRATASE-LYASE (HCHL) WITH ACETYL-COENZYME A AND            
JRNL        TITL 3 VANILLIN GIVES INSIGHTS INTO SUBSTRATE SPECIFICITY           
JRNL        TITL 4 AND MECHANISM.                                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.9  ANGSTROMS.                                          
DBREF  2VSU A    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSU B    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSU C    1   250  UNP    O69762   O69762_PSEFL     1    250             
DBREF  2VSU C  251   275  UNP    O69762   O69762_PSEFL   252    276             
DBREF  2VSU D    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSU E    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSU F    1   276  UNP    O69762   O69762_PSEFL     1    276             
SEQRES   1 A  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 A  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 A  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 A  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 A  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 A  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 A  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 A  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 A  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 A  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 A  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 A  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 A  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 A  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 A  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 A  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 A  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 A  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 A  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 A  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 A  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 A  276  TYR LYS ARG                                                  
SEQRES   1 B  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 B  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 B  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 B  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 B  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 B  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 B  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 B  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 B  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 B  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 B  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 B  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 B  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 B  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 B  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 B  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 B  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 B  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 B  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 B  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 B  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 B  276  TYR LYS ARG                                                  
SEQRES   1 C  275  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 C  275  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 C  275  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 C  275  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 C  275  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 C  275  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 C  275  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 C  275  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 C  275  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 C  275  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 C  275  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 C  275  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 C  275  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 C  275  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 C  275  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 C  275  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 C  275  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 C  275  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 C  275  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 C  275  LEU ASP THR GLY GLY ARG GLU GLN GLY MET LYS GLN PHE          
SEQRES  21 C  275  LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA TYR          
SEQRES  22 C  275  LYS ARG                                                      
SEQRES   1 D  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 D  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 D  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 D  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 D  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 D  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 D  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 D  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 D  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 D  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 D  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 D  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 D  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 D  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 D  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 D  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 D  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 D  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 D  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 D  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 D  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 D  276  TYR LYS ARG                                                  
SEQRES   1 E  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 E  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 E  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 E  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 E  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 E  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 E  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 E  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 E  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 E  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 E  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 E  276  ILE ASN TYR GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 E  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 E  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 E  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 E  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 E  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 E  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 E  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 E  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 E  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 E  276  TYR LYS ARG                                                  
SEQRES   1 F  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 F  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 F  276  PRO GLU ARG ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 F  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 F  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 F  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 F  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 F  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 F  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 F  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 F  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 F  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 F  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 F  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 F  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 F  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 F  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 F  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 F  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 F  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 F  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 F  276  TYR LYS ARG                                                  
HET    ACO  A1250      51                                                       
HET    ACO  B1251      51                                                       
HET    ACO  D1250      51                                                       
HET    ACO  E1250      51                                                       
HET    ACO  F1249      51                                                       
HET    V55  D1251      11                                                       
HETNAM     ACO ACETYL COENZYME *A                                               
HETNAM     V55 4-HYDROXY-3-METHOXYBENZALDEHYDE                                  
FORMUL   7  ACO    5(C23 H38 N7 O17 P3 S1)                                      
FORMUL   8  V55    C8 H8 O3                                                     
FORMUL   9  HOH   *488(H2 O1)                                                   
CRYST1   90.081  130.122  144.743  90.00  90.00  90.00 P 21 21 21   12          
ATOM   3823  N   GLY C   6     -36.336 111.299  19.006  1.00 32.75           N  
ATOM   3824  CA  GLY C   6     -36.061 112.652  19.561  1.00 33.79           C  
ATOM   3825  C   GLY C   6     -35.880 112.721  21.070  1.00 33.92           C  
ATOM   3826  O   GLY C   6     -36.196 113.742  21.688  1.00 33.90           O  
ATOM   3827  N   ARG C   7     -35.344 111.656  21.682  1.00 34.13           N  
ATOM   3828  CA  ARG C   7     -35.085 111.647  23.126  1.00 33.38           C  
ATOM   3829  C   ARG C   7     -33.895 112.529  23.561  1.00 32.77           C  
ATOM   3830  O   ARG C   7     -33.923 113.140  24.648  1.00 32.27           O  
ATOM   3831  CB  ARG C   7     -34.890 110.204  23.649  1.00 33.88           C  
ATOM   3832  CG  ARG C   7     -34.489 110.149  25.118  1.00 34.72           C  
ATOM   3833  CD  ARG C   7     -34.716 108.801  25.758  1.00 37.47           C  
ATOM   3834  NE  ARG C   7     -34.439 108.850  27.190  1.00 37.92           N  
ATOM   3835  CZ  ARG C   7     -34.622 107.834  28.029  1.00 38.92           C  
ATOM   3836  NH1 ARG C   7     -35.093 106.678  27.575  1.00 40.16           N  
ATOM   3837  NH2 ARG C   7     -34.334 107.970  29.318  1.00 37.49           N  
ATOM   3838  N   TRP C   8     -32.838 112.566  22.758  1.00 31.64           N  
ATOM   3839  CA  TRP C   8     -31.632 113.326  23.140  1.00 31.26           C  
ATOM   3840  C   TRP C   8     -31.330 114.385  22.127  1.00 30.88           C  
ATOM   3841  O   TRP C   8     -31.523 114.171  20.934  1.00 31.05           O  
ATOM   3842  CB  TRP C   8     -30.376 112.427  23.309  1.00 30.37           C  
ATOM   3843  CG  TRP C   8     -30.522 111.493  24.421  1.00 29.54           C  
ATOM   3844  CD1 TRP C   8     -30.409 111.783  25.755  1.00 29.81           C  
ATOM   3845  CD2 TRP C   8     -30.851 110.100  24.339  1.00 28.76           C  
ATOM   3846  NE1 TRP C   8     -30.657 110.661  26.503  1.00 29.73           N  
ATOM   3847  CE2 TRP C   8     -30.911 109.608  25.663  1.00 29.74           C  
ATOM   3848  CE3 TRP C   8     -31.102 109.226  23.283  1.00 29.12           C  
ATOM   3849  CZ2 TRP C   8     -31.220 108.269  25.956  1.00 30.20           C  
ATOM   3850  CZ3 TRP C   8     -31.400 107.901  23.572  1.00 29.77           C  
ATOM   3851  CH2 TRP C   8     -31.468 107.439  24.896  1.00 28.70           C  
ATOM   3852  N   LYS C   9     -30.778 115.483  22.626  1.00 31.01           N  
ATOM   3853  CA  LYS C   9     -30.445 116.670  21.845  1.00 31.34           C  
ATOM   3854  C   LYS C   9     -29.269 116.404  20.931  1.00 30.38           C  
ATOM   3855  O   LYS C   9     -29.307 116.737  19.749  1.00 29.91           O  
ATOM   3856  CB  LYS C   9     -30.110 117.810  22.834  1.00 32.71           C  
ATOM   3857  CG  LYS C   9     -29.423 119.060  22.259  1.00 35.17           C  
ATOM   3858  CD  LYS C   9     -30.414 120.068  21.749  1.00 39.41           C  
ATOM   3859  CE  LYS C   9     -29.813 120.831  20.593  1.00 41.22           C  
ATOM   3860  NZ  LYS C   9     -30.897 121.441  19.786  1.00 42.14           N  
ATOM   3861  N   THR C  10     -28.242 115.765  21.486  1.00 29.38           N  
ATOM   3862  CA  THR C  10     -26.919 115.647  20.856  1.00 28.53           C  
ATOM   3863  C   THR C  10     -26.560 114.221  20.425  1.00 28.07           C  
ATOM   3864  O   THR C  10     -25.418 113.969  20.013  1.00 27.68           O  
ATOM   3865  CB  THR C  10     -25.819 116.097  21.841  1.00 29.22           C  
ATOM   3866  OG1 THR C  10     -25.684 115.100  22.865  1.00 27.14           O  
ATOM   3867  CG2 THR C  10     -26.161 117.436  22.505  1.00 28.32           C  
ATOM   3868  N   VAL C  11     -27.503 113.280  20.551  1.00 28.09           N  
ATOM   3869  CA  VAL C  11     -27.248 111.840  20.210  1.00 28.47           C  
ATOM   3870  C   VAL C  11     -28.529 111.184  19.690  1.00 28.97           C  
ATOM   3871  O   VAL C  11     -29.602 111.427  20.250  1.00 28.84           O  
ATOM   3872  CB  VAL C  11     -26.770 110.942  21.445  1.00 28.82           C  
ATOM   3873  CG1 VAL C  11     -26.428 109.539  20.995  1.00 26.10           C  
ATOM   3874  CG2 VAL C  11     -25.587 111.550  22.258  1.00 29.12           C  
ATOM   3875  N   LYS C  12     -28.409 110.372  18.633  1.00 30.08           N  
ATOM   3876  CA  LYS C  12     -29.513 109.553  18.082  1.00 30.84           C  
ATOM   3877  C   LYS C  12     -29.262 108.062  18.289  1.00 30.53           C  
ATOM   3878  O   LYS C  12     -28.142 107.595  18.110  1.00 31.10           O  
ATOM   3879  CB  LYS C  12     -29.646 109.760  16.573  1.00 30.64           C  
ATOM   3880  CG  LYS C  12     -30.364 110.992  16.160  1.00 33.88           C  
ATOM   3881  CD  LYS C  12     -30.948 110.745  14.781  1.00 34.54           C  
ATOM   3882  CE  LYS C  12     -30.559 111.851  13.845  1.00 36.81           C  
ATOM   3883  NZ  LYS C  12     -31.236 111.665  12.529  1.00 36.76           N  
ATOM   3884  N   VAL C  13     -30.300 107.304  18.629  1.00 30.54           N  
ATOM   3885  CA  VAL C  13     -30.149 105.836  18.753  1.00 31.13           C  
ATOM   3886  C   VAL C  13     -31.155 105.157  17.828  1.00 31.99           C  
ATOM   3887  O   VAL C  13     -32.337 105.544  17.796  1.00 30.79           O  
ATOM   3888  CB  VAL C  13     -30.379 105.317  20.208  1.00 31.13           C  
ATOM   3889  CG1 VAL C  13     -30.283 103.804  20.263  1.00 29.84           C  
ATOM   3890  CG2 VAL C  13     -29.461 105.999  21.235  1.00 31.55           C  
ATOM   3891  N   GLU C  14     -30.679 104.183  17.053  1.00 32.38           N  
ATOM   3892  CA  GLU C  14     -31.526 103.371  16.175  1.00 33.65           C  
ATOM   3893  C   GLU C  14     -31.249 101.895  16.427  1.00 32.42           C  
ATOM   3894  O   GLU C  14     -30.106 101.475  16.387  1.00 32.97           O  
ATOM   3895  CB  GLU C  14     -31.302 103.720  14.686  1.00 33.57           C  
ATOM   3896  CG  GLU C  14     -30.899 105.197  14.438  1.00 36.29           C  
ATOM   3897  CD  GLU C  14     -31.133 105.683  13.013  1.00 37.43           C  
ATOM   3898  OE1 GLU C  14     -30.748 104.987  12.036  1.00 40.77           O  
ATOM   3899  OE2 GLU C  14     -31.710 106.785  12.869  1.00 42.15           O  
ATOM   3900  N   ILE C  15     -32.294 101.119  16.712  1.00 32.01           N  
ATOM   3901  CA  ILE C  15     -32.153  99.675  16.931  1.00 31.84           C  
ATOM   3902  C   ILE C  15     -32.810  98.881  15.816  1.00 31.43           C  
ATOM   3903  O   ILE C  15     -34.035  98.991  15.596  1.00 30.87           O  
ATOM   3904  CB  ILE C  15     -32.737  99.193  18.281  1.00 32.28           C  
ATOM   3905  CG1 ILE C  15     -32.026  99.897  19.456  1.00 32.55           C  
ATOM   3906  CG2 ILE C  15     -32.646  97.644  18.346  1.00 31.88           C  
ATOM   3907  CD1 ILE C  15     -32.727  99.865  20.806  1.00 32.01           C  
ATOM   3908  N   GLU C  16     -31.977  98.109  15.115  1.00 31.13           N  
ATOM   3909  CA  GLU C  16     -32.398  97.237  14.019  1.00 30.27           C  
ATOM   3910  C   GLU C  16     -31.837  95.837  14.233  1.00 29.57           C  
ATOM   3911  O   GLU C  16     -30.619  95.672  14.390  1.00 29.80           O  
ATOM   3912  CB  GLU C  16     -31.917  97.791  12.679  1.00 30.49           C  
ATOM   3913  N   ASP C  17     -32.734  94.844  14.250  1.00 29.12           N  
ATOM   3914  CA  ASP C  17     -32.395  93.422  14.493  1.00 28.82           C  
ATOM   3915  C   ASP C  17     -31.399  93.209  15.683  1.00 28.16           C  
ATOM   3916  O   ASP C  17     -30.463  92.395  15.631  1.00 27.42           O  
ATOM   3917  CB  ASP C  17     -31.907  92.748  13.204  1.00 29.01           C  
ATOM   3918  CG  ASP C  17     -32.942  92.809  12.090  1.00 30.62           C  
ATOM   3919  OD1 ASP C  17     -34.135  92.563  12.363  1.00 30.28           O  
ATOM   3920  OD2 ASP C  17     -32.577  93.093  10.926  1.00 35.80           O  
ATOM   3921  N   GLY C  18     -31.600  93.967  16.748  1.00 28.09           N  
ATOM   3922  CA  GLY C  18     -30.829  93.761  17.962  1.00 28.22           C  
ATOM   3923  C   GLY C  18     -29.559  94.600  18.062  1.00 28.55           C  
ATOM   3924  O   GLY C  18     -28.871  94.580  19.104  1.00 28.06           O  
ATOM   3925  N   ILE C  19     -29.253  95.327  16.983  1.00 28.59           N  
ATOM   3926  CA  ILE C  19     -28.113  96.248  16.931  1.00 28.65           C  
ATOM   3927  C   ILE C  19     -28.540  97.684  17.208  1.00 29.26           C  
ATOM   3928  O   ILE C  19     -29.348  98.279  16.454  1.00 28.92           O  
ATOM   3929  CB  ILE C  19     -27.422  96.223  15.562  1.00 28.05           C  
ATOM   3930  CG1 ILE C  19     -26.940  94.813  15.226  1.00 29.10           C  
ATOM   3931  CG2 ILE C  19     -26.292  97.242  15.508  1.00 27.59           C  
ATOM   3932  CD1 ILE C  19     -26.720  94.572  13.732  1.00 27.02           C  
ATOM   3933  N   ALA C  20     -27.999  98.244  18.286  1.00 29.39           N  
ATOM   3934  CA  ALA C  20     -28.233  99.654  18.639  1.00 30.22           C  
ATOM   3935  C   ALA C  20     -27.114 100.565  18.120  1.00 30.20           C  
ATOM   3936  O   ALA C  20     -26.032 100.607  18.696  1.00 30.06           O  
ATOM   3937  CB  ALA C  20     -28.403  99.812  20.144  1.00 29.61           C  
ATOM   3938  N   PHE C  21     -27.400 101.285  17.041  1.00 30.70           N  
ATOM   3939  CA  PHE C  21     -26.531 102.335  16.514  1.00 30.93           C  
ATOM   3940  C   PHE C  21     -26.672 103.568  17.374  1.00 31.11           C  
ATOM   3941  O   PHE C  21     -27.753 104.199  17.411  1.00 31.62           O  
ATOM   3942  CB  PHE C  21     -26.897 102.656  15.046  1.00 31.91           C  
ATOM   3943  CG  PHE C  21     -26.487 101.590  14.082  1.00 33.50           C  
ATOM   3944  CD1 PHE C  21     -27.323 100.498  13.832  1.00 34.51           C  
ATOM   3945  CD2 PHE C  21     -25.252 101.659  13.432  1.00 34.52           C  
ATOM   3946  CE1 PHE C  21     -26.928  99.495  12.944  1.00 35.22           C  
ATOM   3947  CE2 PHE C  21     -24.850 100.667  12.542  1.00 34.14           C  
ATOM   3948  CZ  PHE C  21     -25.679  99.580  12.301  1.00 33.34           C  
ATOM   3949  N   VAL C  22     -25.601 103.884  18.103  1.00 30.55           N  
ATOM   3950  CA  VAL C  22     -25.525 105.079  18.928  1.00 29.70           C  
ATOM   3951  C   VAL C  22     -24.764 106.121  18.106  1.00 29.05           C  
ATOM   3952  O   VAL C  22     -23.552 105.988  17.872  1.00 28.16           O  
ATOM   3953  CB  VAL C  22     -24.814 104.823  20.278  1.00 29.60           C  
ATOM   3954  CG1 VAL C  22     -24.672 106.110  21.059  1.00 30.57           C  
ATOM   3955  CG2 VAL C  22     -25.555 103.780  21.082  1.00 29.11           C  
ATOM   3956  N   ILE C  23     -25.498 107.145  17.671  1.00 27.91           N  
ATOM   3957  CA  ILE C  23     -24.988 108.087  16.705  1.00 27.88           C  
ATOM   3958  C   ILE C  23     -24.814 109.422  17.342  1.00 27.91           C  
ATOM   3959  O   ILE C  23     -25.824 110.139  17.595  1.00 27.80           O  
ATOM   3960  CB  ILE C  23     -25.961 108.257  15.509  1.00 28.85           C  
ATOM   3961  CG1 ILE C  23     -26.343 106.887  14.916  1.00 28.98           C  
ATOM   3962  CG2 ILE C  23     -25.384 109.236  14.437  1.00 27.85           C  
ATOM   3963  CD1 ILE C  23     -27.714 106.888  14.269  1.00 29.52           C  
ATOM   3964  N   LEU C  24     -23.551 109.763  17.576  1.00 28.07           N  
ATOM   3965  CA  LEU C  24     -23.178 111.085  18.059  1.00 28.74           C  
ATOM   3966  C   LEU C  24     -23.704 112.030  17.036  1.00 29.18           C  
ATOM   3967  O   LEU C  24     -23.462 111.854  15.851  1.00 29.38           O  
ATOM   3968  CB  LEU C  24     -21.672 111.273  18.147  1.00 28.59           C  
ATOM   3969  CG  LEU C  24     -20.851 110.425  19.118  1.00 27.63           C  
ATOM   3970  CD1 LEU C  24     -19.371 110.759  18.966  1.00 25.89           C  
ATOM   3971  CD2 LEU C  24     -21.306 110.604  20.576  1.00 28.77           C  
ATOM   3972  N   ASN C  25     -24.437 113.028  17.507  1.00 30.62           N  
ATOM   3973  CA  ASN C  25     -25.278 113.823  16.631  1.00 31.34           C  
ATOM   3974  C   ASN C  25     -25.130 115.322  16.858  1.00 31.57           C  
ATOM   3975  O   ASN C  25     -26.099 116.006  17.159  1.00 31.74           O  
ATOM   3976  CB  ASN C  25     -26.731 113.352  16.775  1.00 31.35           C  
ATOM   3977  CG  ASN C  25     -27.645 113.910  15.694  1.00 32.58           C  
ATOM   3978  OD1 ASN C  25     -28.823 114.174  15.949  1.00 33.11           O  
ATOM   3979  ND2 ASN C  25     -27.109 114.099  14.491  1.00 30.84           N  
ATOM   3980  N   ARG C  26     -23.906 115.824  16.699  1.00 32.25           N  
ATOM   3981  CA  ARG C  26     -23.643 117.276  16.589  1.00 32.86           C  
ATOM   3982  C   ARG C  26     -22.855 117.572  15.289  1.00 32.96           C  
ATOM   3983  O   ARG C  26     -21.786 118.204  15.344  1.00 33.00           O  
ATOM   3984  CB  ARG C  26     -22.868 117.806  17.806  1.00 32.80           C  
ATOM   3985  CG  ARG C  26     -23.621 117.704  19.141  1.00 33.19           C  
ATOM   3986  CD  ARG C  26     -22.821 118.274  20.303  1.00 33.52           C  
ATOM   3987  NE  ARG C  26     -22.800 119.738  20.318  1.00 33.47           N  
ATOM   3988  CZ  ARG C  26     -21.710 120.492  20.453  1.00 32.75           C  
ATOM   3989  NH1 ARG C  26     -20.513 119.948  20.572  1.00 29.17           N  
ATOM   3990  NH2 ARG C  26     -21.825 121.809  20.475  1.00 32.73           N  
ATOM   3991  N   PRO C  27     -23.389 117.134  14.117  1.00 32.79           N  
ATOM   3992  CA  PRO C  27     -22.586 117.196  12.900  1.00 33.05           C  
ATOM   3993  C   PRO C  27     -22.008 118.571  12.601  1.00 33.34           C  
ATOM   3994  O   PRO C  27     -20.865 118.653  12.162  1.00 33.24           O  
ATOM   3995  CB  PRO C  27     -23.559 116.742  11.801  1.00 33.29           C  
ATOM   3996  CG  PRO C  27     -24.926 116.911  12.389  1.00 33.60           C  
ATOM   3997  CD  PRO C  27     -24.730 116.582  13.842  1.00 32.38           C  
ATOM   3998  N   GLU C  28     -22.781 119.633  12.864  1.00 34.03           N  
ATOM   3999  CA  GLU C  28     -22.368 121.036  12.608  1.00 34.52           C  
ATOM   4000  C   GLU C  28     -21.081 121.384  13.356  1.00 34.15           C  
ATOM   4001  O   GLU C  28     -20.377 122.323  12.990  1.00 34.02           O  
ATOM   4002  CB  GLU C  28     -23.474 122.058  12.965  1.00 34.67           C  
ATOM   4003  CG  GLU C  28     -24.916 121.498  13.076  1.00 36.17           C  
ATOM   4004  CD  GLU C  28     -25.096 120.545  14.285  1.00 38.48           C  
ATOM   4005  OE1 GLU C  28     -24.482 120.785  15.350  1.00 34.88           O  
ATOM   4006  OE2 GLU C  28     -25.850 119.550  14.157  1.00 40.99           O  
ATOM   4007  N   LYS C  29     -20.771 120.593  14.379  1.00 34.33           N  
ATOM   4008  CA  LYS C  29     -19.586 120.799  15.198  1.00 33.96           C  
ATOM   4009  C   LYS C  29     -18.609 119.622  15.061  1.00 33.83           C  
ATOM   4010  O   LYS C  29     -17.689 119.453  15.885  1.00 34.18           O  
ATOM   4011  CB  LYS C  29     -19.993 120.993  16.669  1.00 33.67           C  
ATOM   4012  N   ARG C  30     -18.817 118.806  14.029  1.00 33.13           N  
ATOM   4013  CA  ARG C  30     -18.044 117.566  13.832  1.00 32.63           C  
ATOM   4014  C   ARG C  30     -18.150 116.629  15.062  1.00 31.25           C  
ATOM   4015  O   ARG C  30     -17.176 115.984  15.441  1.00 31.41           O  
ATOM   4016  CB  ARG C  30     -16.571 117.867  13.490  1.00 32.44           C  
ATOM   4017  CG  ARG C  30     -16.348 118.661  12.188  1.00 33.79           C  
ATOM   4018  CD  ARG C  30     -14.913 118.430  11.597  1.00 35.30           C  
ATOM   4019  NE  ARG C  30     -14.725 119.179  10.342  1.00 39.99           N  
ATOM   4020  CZ  ARG C  30     -13.577 119.362   9.671  1.00 40.08           C  
ATOM   4021  NH1 ARG C  30     -13.585 120.107   8.530  1.00 38.10           N  
ATOM   4022  NH2 ARG C  30     -12.438 118.846  10.128  1.00 40.32           N  
ATOM   4023  N   ASN C  31     -19.341 116.568  15.668  1.00 29.63           N  
ATOM   4024  CA  ASN C  31     -19.628 115.699  16.827  1.00 28.63           C  
ATOM   4025  C   ASN C  31     -18.692 115.914  18.023  1.00 28.36           C  
ATOM   4026  O   ASN C  31     -18.427 114.988  18.794  1.00 27.82           O  
ATOM   4027  CB  ASN C  31     -19.739 114.191  16.414  1.00 27.40           C  
ATOM   4028  CG  ASN C  31     -20.798 113.954  15.300  1.00 27.77           C  
ATOM   4029  OD1 ASN C  31     -21.926 114.476  15.362  1.00 27.95           O  
ATOM   4030  ND2 ASN C  31     -20.422 113.199  14.269  1.00 25.46           N  
ATOM   4031  N   ALA C  32     -18.206 117.141  18.204  1.00 28.25           N  
ATOM   4032  CA  ALA C  32     -17.353 117.430  19.359  1.00 28.48           C  
ATOM   4033  C   ALA C  32     -18.070 117.130  20.671  1.00 28.71           C  
ATOM   4034  O   ALA C  32     -19.300 117.287  20.764  1.00 29.26           O  
ATOM   4035  CB  ALA C  32     -16.857 118.856  19.341  1.00 27.96           C  
ATOM   4036  N   MET C  33     -17.303 116.721  21.688  1.00 27.80           N  
ATOM   4037  CA  MET C  33     -17.887 116.318  22.956  1.00 28.41           C  
ATOM   4038  C   MET C  33     -18.022 117.470  23.943  1.00 28.11           C  
ATOM   4039  O   MET C  33     -17.045 117.892  24.594  1.00 28.06           O  
ATOM   4040  CB  MET C  33     -17.130 115.117  23.556  1.00 27.17           C  
ATOM   4041  CG  MET C  33     -17.240 113.882  22.672  1.00 26.62           C  
ATOM   4042  SD  MET C  33     -16.136 112.533  23.152  1.00 31.26           S  
ATOM   4043  CE  MET C  33     -14.577 113.221  22.447  1.00 22.40           C  
ATOM   4044  N   SER C  34     -19.254 117.961  24.043  1.00 26.74           N  
ATOM   4045  CA  SER C  34     -19.588 118.955  25.026  1.00 27.04           C  
ATOM   4046  C   SER C  34     -20.061 118.329  26.344  1.00 27.26           C  
ATOM   4047  O   SER C  34     -20.342 117.118  26.424  1.00 27.53           O  
ATOM   4048  CB  SER C  34     -20.669 119.890  24.457  1.00 26.32           C  
ATOM   4049  OG  SER C  34     -21.810 119.133  24.102  1.00 24.08           O  
ATOM   4050  N   PRO C  35     -20.108 119.138  27.412  1.00 27.77           N  
ATOM   4051  CA  PRO C  35     -20.717 118.624  28.639  1.00 27.71           C  
ATOM   4052  C   PRO C  35     -22.155 118.080  28.460  1.00 28.15           C  
ATOM   4053  O   PRO C  35     -22.479 117.014  29.005  1.00 28.61           O  
ATOM   4054  CB  PRO C  35     -20.637 119.830  29.588  1.00 28.64           C  
ATOM   4055  CG  PRO C  35     -19.400 120.575  29.117  1.00 27.33           C  
ATOM   4056  CD  PRO C  35     -19.499 120.469  27.605  1.00 27.62           C  
ATOM   4057  N   THR C  36     -22.989 118.781  27.684  1.00 28.72           N  
ATOM   4058  CA  THR C  36     -24.303 118.254  27.290  1.00 28.39           C  
ATOM   4059  C   THR C  36     -24.193 116.868  26.659  1.00 27.73           C  
ATOM   4060  O   THR C  36     -24.870 115.909  27.083  1.00 27.13           O  
ATOM   4061  CB  THR C  36     -25.033 119.201  26.332  1.00 28.85           C  
ATOM   4062  OG1 THR C  36     -25.250 120.438  27.001  1.00 27.31           O  
ATOM   4063  CG2 THR C  36     -26.397 118.639  25.897  1.00 30.75           C  
ATOM   4064  N   LEU C  37     -23.347 116.756  25.647  1.00 27.01           N  
ATOM   4065  CA  LEU C  37     -23.162 115.446  25.010  1.00 26.87           C  
ATOM   4066  C   LEU C  37     -22.730 114.380  26.020  1.00 26.49           C  
ATOM   4067  O   LEU C  37     -23.284 113.262  26.018  1.00 26.04           O  
ATOM   4068  CB  LEU C  37     -22.226 115.529  23.788  1.00 26.12           C  
ATOM   4069  CG  LEU C  37     -22.070 114.214  23.026  1.00 25.66           C  
ATOM   4070  CD1 LEU C  37     -21.895 114.482  21.531  1.00 25.83           C  
ATOM   4071  CD2 LEU C  37     -20.894 113.430  23.607  1.00 24.34           C  
ATOM   4072  N   ASN C  38     -21.789 114.741  26.896  1.00 26.93           N  
ATOM   4073  CA  ASN C  38     -21.288 113.833  27.920  1.00 27.18           C  
ATOM   4074  C   ASN C  38     -22.384 113.309  28.820  1.00 28.32           C  
ATOM   4075  O   ASN C  38     -22.504 112.076  29.026  1.00 28.45           O  
ATOM   4076  CB  ASN C  38     -20.189 114.488  28.761  1.00 27.52           C  
ATOM   4077  CG  ASN C  38     -18.928 114.765  27.962  1.00 27.77           C  
ATOM   4078  OD1 ASN C  38     -18.653 114.108  26.957  1.00 26.88           O  
ATOM   4079  ND2 ASN C  38     -18.161 115.744  28.407  1.00 28.04           N  
ATOM   4080  N   ARG C  39     -23.164 114.264  29.349  1.00 28.09           N  
ATOM   4081  CA  ARG C  39     -24.284 113.980  30.220  1.00 28.62           C  
ATOM   4082  C   ARG C  39     -25.312 113.123  29.527  1.00 28.38           C  
ATOM   4083  O   ARG C  39     -25.864 112.207  30.142  1.00 28.51           O  
ATOM   4084  CB  ARG C  39     -24.936 115.286  30.711  1.00 28.66           C  
ATOM   4085  CG  ARG C  39     -24.132 115.933  31.810  1.00 30.07           C  
ATOM   4086  CD  ARG C  39     -24.884 117.049  32.484  1.00 32.85           C  
ATOM   4087  NE  ARG C  39     -24.884 118.248  31.651  1.00 36.02           N  
ATOM   4088  CZ  ARG C  39     -23.909 119.157  31.619  1.00 36.29           C  
ATOM   4089  NH1 ARG C  39     -22.820 119.028  32.387  1.00 32.91           N  
ATOM   4090  NH2 ARG C  39     -24.033 120.202  30.805  1.00 37.50           N  
ATOM   4091  N   GLU C  40     -25.584 113.425  28.255  1.00 27.51           N  
ATOM   4092  CA  GLU C  40     -26.578 112.665  27.512  1.00 27.05           C  
ATOM   4093  C   GLU C  40     -26.098 111.228  27.159  1.00 26.77           C  
ATOM   4094  O   GLU C  40     -26.886 110.282  27.207  1.00 26.59           O  
ATOM   4095  CB  GLU C  40     -27.030 113.431  26.267  1.00 27.74           C  
ATOM   4096  CG  GLU C  40     -27.952 114.608  26.573  1.00 25.75           C  
ATOM   4097  CD  GLU C  40     -28.624 115.149  25.326  1.00 27.39           C  
ATOM   4098  OE1 GLU C  40     -27.967 115.151  24.258  1.00 27.04           O  
ATOM   4099  OE2 GLU C  40     -29.811 115.573  25.413  1.00 24.32           O  
ATOM   4100  N   MET C  41     -24.813 111.078  26.838  1.00 25.04           N  
ATOM   4101  CA  MET C  41     -24.207 109.778  26.598  1.00 24.93           C  
ATOM   4102  C   MET C  41     -24.254 108.839  27.814  1.00 25.34           C  
ATOM   4103  O   MET C  41     -24.425 107.624  27.657  1.00 26.31           O  
ATOM   4104  CB  MET C  41     -22.771 109.950  26.107  1.00 24.73           C  
ATOM   4105  CG  MET C  41     -22.660 110.100  24.550  1.00 24.25           C  
ATOM   4106  SD  MET C  41     -23.570 108.801  23.630  1.00 24.52           S  
ATOM   4107  CE  MET C  41     -22.853 107.269  24.253  1.00 23.66           C  
ATOM   4108  N   ILE C  42     -24.141 109.406  29.015  1.00 24.78           N  
ATOM   4109  CA  ILE C  42     -24.344 108.635  30.237  1.00 24.48           C  
ATOM   4110  C   ILE C  42     -25.755 108.043  30.215  1.00 24.50           C  
ATOM   4111  O   ILE C  42     -25.948 106.829  30.415  1.00 23.89           O  
ATOM   4112  CB  ILE C  42     -24.110 109.472  31.518  1.00 25.03           C  
ATOM   4113  CG1 ILE C  42     -22.626 109.867  31.630  1.00 24.51           C  
ATOM   4114  CG2 ILE C  42     -24.548 108.683  32.799  1.00 26.82           C  
ATOM   4115  CD1 ILE C  42     -22.313 110.951  32.632  1.00 23.93           C  
ATOM   4116  N   ASP C  43     -26.742 108.916  30.006  1.00 24.13           N  
ATOM   4117  CA  ASP C  43     -28.118 108.498  29.968  1.00 24.80           C  
ATOM   4118  C   ASP C  43     -28.321 107.443  28.857  1.00 24.13           C  
ATOM   4119  O   ASP C  43     -29.021 106.452  29.062  1.00 24.34           O  
ATOM   4120  CB  ASP C  43     -29.027 109.720  29.768  1.00 24.43           C  
ATOM   4121  CG  ASP C  43     -30.481 109.410  30.024  1.00 27.48           C  
ATOM   4122  OD1 ASP C  43     -30.797 108.630  30.947  1.00 32.33           O  
ATOM   4123  OD2 ASP C  43     -31.323 109.952  29.291  1.00 29.39           O  
ATOM   4124  N   VAL C  44     -27.677 107.639  27.714  1.00 23.27           N  
ATOM   4125  CA  VAL C  44     -27.814 106.701  26.595  1.00 25.57           C  
ATOM   4126  C   VAL C  44     -27.296 105.296  26.974  1.00 25.57           C  
ATOM   4127  O   VAL C  44     -28.001 104.261  26.798  1.00 25.06           O  
ATOM   4128  CB  VAL C  44     -27.078 107.239  25.353  1.00 25.30           C  
ATOM   4129  CG1 VAL C  44     -27.094 106.196  24.170  1.00 27.32           C  
ATOM   4130  CG2 VAL C  44     -27.704 108.553  24.908  1.00 26.50           C  
ATOM   4131  N   LEU C  45     -26.068 105.263  27.497  1.00 26.14           N  
ATOM   4132  CA  LEU C  45     -25.460 104.020  27.924  1.00 26.48           C  
ATOM   4133  C   LEU C  45     -26.299 103.364  29.020  1.00 27.24           C  
ATOM   4134  O   LEU C  45     -26.542 102.155  28.977  1.00 28.43           O  
ATOM   4135  CB  LEU C  45     -24.010 104.242  28.367  1.00 26.66           C  
ATOM   4136  CG  LEU C  45     -23.012 104.701  27.288  1.00 26.45           C  
ATOM   4137  CD1 LEU C  45     -21.544 104.826  27.835  1.00 24.22           C  
ATOM   4138  CD2 LEU C  45     -23.034 103.763  26.070  1.00 25.56           C  
ATOM   4139  N   GLU C  46     -26.784 104.160  29.972  1.00 28.10           N  
ATOM   4140  CA  GLU C  46     -27.606 103.637  31.044  1.00 28.90           C  
ATOM   4141  C   GLU C  46     -28.935 103.101  30.512  1.00 28.49           C  
ATOM   4142  O   GLU C  46     -29.397 102.037  30.925  1.00 29.09           O  
ATOM   4143  CB  GLU C  46     -27.844 104.711  32.094  1.00 28.75           C  
ATOM   4144  CG  GLU C  46     -26.708 104.871  33.088  1.00 29.35           C  
ATOM   4145  CD  GLU C  46     -26.931 106.059  34.037  1.00 31.92           C  
ATOM   4146  OE1 GLU C  46     -27.966 106.791  33.924  1.00 33.88           O  
ATOM   4147  OE2 GLU C  46     -26.047 106.266  34.882  1.00 36.92           O  
ATOM   4148  N   THR C  47     -29.536 103.824  29.572  1.00 28.53           N  
ATOM   4149  CA  THR C  47     -30.801 103.399  28.965  1.00 28.08           C  
ATOM   4150  C   THR C  47     -30.692 102.096  28.181  1.00 28.08           C  
ATOM   4151  O   THR C  47     -31.443 101.130  28.436  1.00 27.54           O  
ATOM   4152  CB  THR C  47     -31.378 104.532  28.087  1.00 28.02           C  
ATOM   4153  OG1 THR C  47     -31.639 105.658  28.934  1.00 25.90           O  
ATOM   4154  CG2 THR C  47     -32.672 104.098  27.399  1.00 27.63           C  
ATOM   4155  N   LEU C  48     -29.771 102.083  27.226  1.00 28.15           N  
ATOM   4156  CA  LEU C  48     -29.531 100.927  26.362  1.00 28.60           C  
ATOM   4157  C   LEU C  48     -29.120  99.644  27.124  1.00 28.74           C  
ATOM   4158  O   LEU C  48     -29.391  98.533  26.668  1.00 28.38           O  
ATOM   4159  CB  LEU C  48     -28.469 101.285  25.326  1.00 28.85           C  
ATOM   4160  CG  LEU C  48     -28.985 102.247  24.238  1.00 29.48           C  
ATOM   4161  CD1 LEU C  48     -27.883 102.615  23.272  1.00 28.35           C  
ATOM   4162  CD2 LEU C  48     -30.132 101.613  23.470  1.00 33.44           C  
ATOM   4163  N   GLU C  49     -28.479  99.825  28.278  1.00 28.55           N  
ATOM   4164  CA  GLU C  49     -28.095  98.716  29.137  1.00 29.74           C  
ATOM   4165  C   GLU C  49     -29.334  97.888  29.562  1.00 30.03           C  
ATOM   4166  O   GLU C  49     -29.271  96.646  29.645  1.00 28.48           O  
ATOM   4167  CB  GLU C  49     -27.359  99.263  30.358  1.00 30.81           C  
ATOM   4168  CG  GLU C  49     -26.625  98.233  31.120  1.00 33.10           C  
ATOM   4169  CD  GLU C  49     -26.070  98.780  32.409  1.00 36.82           C  
ATOM   4170  OE1 GLU C  49     -26.625  99.740  32.979  1.00 39.06           O  
ATOM   4171  OE2 GLU C  49     -25.074  98.219  32.857  1.00 35.31           O  
ATOM   4172  N   GLN C  50     -30.454  98.591  29.796  1.00 29.28           N  
ATOM   4173  CA  GLN C  50     -31.685  97.983  30.282  1.00 29.71           C  
ATOM   4174  C   GLN C  50     -32.634  97.587  29.138  1.00 29.59           C  
ATOM   4175  O   GLN C  50     -33.737  97.046  29.373  1.00 29.58           O  
ATOM   4176  CB  GLN C  50     -32.394  98.956  31.179  1.00 30.35           C  
ATOM   4177  CG  GLN C  50     -31.847  99.035  32.605  1.00 32.73           C  
ATOM   4178  CD  GLN C  50     -32.899  99.617  33.530  1.00 39.90           C  
ATOM   4179  OE1 GLN C  50     -32.731 100.716  34.042  1.00 44.40           O  
ATOM   4180  NE2 GLN C  50     -34.029  98.908  33.700  1.00 42.52           N  
ATOM   4181  N   ASP C  51     -32.219  97.876  27.915  1.00 28.18           N  
ATOM   4182  CA  ASP C  51     -33.101  97.647  26.762  1.00 29.29           C  
ATOM   4183  C   ASP C  51     -32.944  96.216  26.160  1.00 28.84           C  
ATOM   4184  O   ASP C  51     -31.957  95.936  25.489  1.00 28.00           O  
ATOM   4185  CB  ASP C  51     -32.873  98.740  25.718  1.00 28.29           C  
ATOM   4186  CG  ASP C  51     -33.914  98.724  24.662  1.00 30.95           C  
ATOM   4187  OD1 ASP C  51     -34.614  97.691  24.591  1.00 29.68           O  
ATOM   4188  OD2 ASP C  51     -34.036  99.718  23.912  1.00 29.65           O  
ATOM   4189  N   PRO C  52     -33.915  95.298  26.413  1.00 29.69           N  
ATOM   4190  CA  PRO C  52     -33.716  93.878  26.013  1.00 30.00           C  
ATOM   4191  C   PRO C  52     -33.677  93.742  24.515  1.00 30.24           C  
ATOM   4192  O   PRO C  52     -33.289  92.685  23.994  1.00 30.80           O  
ATOM   4193  CB  PRO C  52     -34.993  93.183  26.500  1.00 30.21           C  
ATOM   4194  CG  PRO C  52     -36.037  94.302  26.505  1.00 30.93           C  
ATOM   4195  CD  PRO C  52     -35.237  95.491  27.040  1.00 30.19           C  
ATOM   4196  N   ALA C  53     -34.070  94.804  23.823  1.00 29.35           N  
ATOM   4197  CA  ALA C  53     -34.064  94.764  22.359  1.00 30.15           C  
ATOM   4198  C   ALA C  53     -32.662  95.021  21.846  1.00 30.58           C  
ATOM   4199  O   ALA C  53     -32.362  94.712  20.716  1.00 31.50           O  
ATOM   4200  CB  ALA C  53     -35.031  95.769  21.782  1.00 29.80           C  
ATOM   4201  N   ALA C  54     -31.804  95.604  22.678  1.00 31.15           N  
ATOM   4202  CA  ALA C  54     -30.470  95.956  22.198  1.00 31.04           C  
ATOM   4203  C   ALA C  54     -29.440  94.929  22.684  1.00 30.89           C  
ATOM   4204  O   ALA C  54     -29.289  94.702  23.893  1.00 30.43           O  
ATOM   4205  CB  ALA C  54     -30.106  97.379  22.644  1.00 31.32           C  
ATOM   4206  N   GLY C  55     -28.746  94.293  21.754  1.00 29.67           N  
ATOM   4207  CA  GLY C  55     -27.780  93.293  22.146  1.00 29.95           C  
ATOM   4208  C   GLY C  55     -26.330  93.659  21.854  1.00 29.59           C  
ATOM   4209  O   GLY C  55     -25.434  93.019  22.378  1.00 28.74           O  
ATOM   4210  N   VAL C  56     -26.118  94.627  20.955  1.00 29.53           N  
ATOM   4211  CA  VAL C  56     -24.781  95.127  20.592  1.00 29.48           C  
ATOM   4212  C   VAL C  56     -24.916  96.620  20.357  1.00 29.06           C  
ATOM   4213  O   VAL C  56     -25.937  97.060  19.825  1.00 29.21           O  
ATOM   4214  CB  VAL C  56     -24.170  94.459  19.286  1.00 29.59           C  
ATOM   4215  CG1 VAL C  56     -22.852  95.124  18.876  1.00 28.36           C  
ATOM   4216  CG2 VAL C  56     -23.888  92.983  19.459  1.00 32.37           C  
ATOM   4217  N   LEU C  57     -23.927  97.405  20.796  1.00 28.63           N  
ATOM   4218  CA  LEU C  57     -23.914  98.843  20.552  1.00 29.17           C  
ATOM   4219  C   LEU C  57     -22.885  99.183  19.517  1.00 28.74           C  
ATOM   4220  O   LEU C  57     -21.784  98.713  19.589  1.00 30.92           O  
ATOM   4221  CB  LEU C  57     -23.626  99.640  21.845  1.00 29.96           C  
ATOM   4222  CG  LEU C  57     -24.835 100.045  22.686  1.00 30.17           C  
ATOM   4223  CD1 LEU C  57     -25.509  98.817  23.338  1.00 31.02           C  
ATOM   4224  CD2 LEU C  57     -24.433 101.087  23.753  1.00 33.00           C  
ATOM   4225  N   VAL C  58     -23.238 100.011  18.557  1.00 28.62           N  
ATOM   4226  CA  VAL C  58     -22.277 100.490  17.549  1.00 27.98           C  
ATOM   4227  C   VAL C  58     -22.193 101.994  17.684  1.00 27.91           C  
ATOM   4228  O   VAL C  58     -23.196 102.723  17.455  1.00 28.36           O  
ATOM   4229  CB  VAL C  58     -22.662 100.099  16.086  1.00 27.75           C  
ATOM   4230  CG1 VAL C  58     -21.713 100.753  15.093  1.00 25.34           C  
ATOM   4231  CG2 VAL C  58     -22.683  98.578  15.918  1.00 27.76           C  
ATOM   4232  N   LEU C  59     -21.017 102.463  18.077  1.00 27.69           N  
ATOM   4233  CA  LEU C  59     -20.832 103.883  18.384  1.00 27.33           C  
ATOM   4234  C   LEU C  59     -20.226 104.520  17.144  1.00 28.12           C  
ATOM   4235  O   LEU C  59     -19.141 104.126  16.698  1.00 27.03           O  
ATOM   4236  CB  LEU C  59     -19.968 104.092  19.643  1.00 26.04           C  
ATOM   4237  CG  LEU C  59     -19.476 105.496  20.053  1.00 27.39           C  
ATOM   4238  CD1 LEU C  59     -20.632 106.496  20.175  1.00 26.15           C  
ATOM   4239  CD2 LEU C  59     -18.678 105.518  21.349  1.00 25.76           C  
ATOM   4240  N   THR C  60     -20.973 105.470  16.571  1.00 28.38           N  
ATOM   4241  CA  THR C  60     -20.599 106.140  15.331  1.00 29.07           C  
ATOM   4242  C   THR C  60     -20.947 107.643  15.384  1.00 29.54           C  
ATOM   4243  O   THR C  60     -21.588 108.113  16.362  1.00 29.80           O  
ATOM   4244  CB  THR C  60     -21.247 105.411  14.109  1.00 29.38           C  
ATOM   4245  OG1 THR C  60     -20.547 105.738  12.889  1.00 29.52           O  
ATOM   4246  CG2 THR C  60     -22.769 105.741  13.969  1.00 30.58           C  
ATOM   4247  N   GLY C  61     -20.533 108.388  14.356  1.00 29.55           N  
ATOM   4248  CA  GLY C  61     -20.849 109.816  14.243  1.00 29.29           C  
ATOM   4249  C   GLY C  61     -21.765 110.222  13.089  1.00 29.77           C  
ATOM   4250  O   GLY C  61     -21.789 109.577  12.047  1.00 29.47           O  
ATOM   4251  N   ALA C  62     -22.521 111.303  13.294  1.00 29.85           N  
ATOM   4252  CA  ALA C  62     -23.349 111.906  12.269  1.00 30.95           C  
ATOM   4253  C   ALA C  62     -22.477 112.766  11.360  1.00 30.95           C  
ATOM   4254  O   ALA C  62     -21.525 113.407  11.831  1.00 31.39           O  
ATOM   4255  CB  ALA C  62     -24.445 112.748  12.905  1.00 30.59           C  
ATOM   4256  N   GLY C  63     -22.810 112.800  10.068  1.00 31.37           N  
ATOM   4257  CA  GLY C  63     -21.997 113.526   9.107  1.00 30.47           C  
ATOM   4258  C   GLY C  63     -20.616 112.940   8.896  1.00 29.90           C  
ATOM   4259  O   GLY C  63     -20.421 111.715   8.949  1.00 30.09           O  
ATOM   4260  N   GLU C  64     -19.643 113.809   8.646  1.00 30.05           N  
ATOM   4261  CA  GLU C  64     -18.331 113.316   8.198  1.00 30.41           C  
ATOM   4262  C   GLU C  64     -17.459 112.839   9.336  1.00 30.02           C  
ATOM   4263  O   GLU C  64     -16.593 111.992   9.129  1.00 30.19           O  
ATOM   4264  CB  GLU C  64     -17.582 114.339   7.318  1.00 31.11           C  
ATOM   4265  CG  GLU C  64     -17.261 115.683   7.977  1.00 32.84           C  
ATOM   4266  N   ALA C  65     -17.702 113.350  10.542  1.00 29.53           N  
ATOM   4267  CA  ALA C  65     -16.843 113.029  11.688  1.00 28.85           C  
ATOM   4268  C   ALA C  65     -17.347 111.851  12.504  1.00 28.84           C  
ATOM   4269  O   ALA C  65     -18.560 111.585  12.575  1.00 28.19           O  
ATOM   4270  CB  ALA C  65     -16.707 114.226  12.583  1.00 29.20           C  
ATOM   4271  N   TRP C  66     -16.408 111.149  13.135  1.00 28.37           N  
ATOM   4272  CA  TRP C  66     -16.769 110.247  14.203  1.00 28.76           C  
ATOM   4273  C   TRP C  66     -16.916 111.152  15.437  1.00 29.67           C  
ATOM   4274  O   TRP C  66     -18.039 111.430  15.861  1.00 30.67           O  
ATOM   4275  CB  TRP C  66     -15.722 109.116  14.362  1.00 27.61           C  
ATOM   4276  CG  TRP C  66     -16.159 108.039  15.299  1.00 27.55           C  
ATOM   4277  CD1 TRP C  66     -17.182 107.144  15.107  1.00 29.16           C  
ATOM   4278  CD2 TRP C  66     -15.628 107.767  16.587  1.00 27.07           C  
ATOM   4279  NE1 TRP C  66     -17.294 106.309  16.192  1.00 26.07           N  
ATOM   4280  CE2 TRP C  66     -16.359 106.679  17.123  1.00 28.49           C  
ATOM   4281  CE3 TRP C  66     -14.589 108.323  17.345  1.00 23.60           C  
ATOM   4282  CZ2 TRP C  66     -16.076 106.133  18.381  1.00 27.80           C  
ATOM   4283  CZ3 TRP C  66     -14.317 107.796  18.605  1.00 26.28           C  
ATOM   4284  CH2 TRP C  66     -15.066 106.715  19.117  1.00 28.75           C  
ATOM   4285  N   THR C  67     -15.798 111.645  15.987  1.00 30.13           N  
ATOM   4286  CA  THR C  67     -15.801 112.851  16.842  1.00 29.26           C  
ATOM   4287  C   THR C  67     -14.489 113.601  16.627  1.00 30.25           C  
ATOM   4288  O   THR C  67     -13.427 112.989  16.540  1.00 29.42           O  
ATOM   4289  CB  THR C  67     -16.003 112.583  18.374  1.00 30.64           C  
ATOM   4290  OG1 THR C  67     -15.843 113.809  19.099  1.00 28.15           O  
ATOM   4291  CG2 THR C  67     -14.986 111.532  18.932  1.00 26.90           C  
ATOM   4292  N   ALA C  68     -14.579 114.924  16.542  1.00 30.10           N  
ATOM   4293  CA  ALA C  68     -13.417 115.801  16.428  1.00 31.08           C  
ATOM   4294  C   ALA C  68     -12.786 116.025  17.811  1.00 32.63           C  
ATOM   4295  O   ALA C  68     -11.750 116.700  17.948  1.00 32.42           O  
ATOM   4296  CB  ALA C  68     -13.821 117.142  15.762  1.00 31.78           C  
ATOM   4297  N   GLY C  69     -13.393 115.405  18.828  1.00 33.23           N  
ATOM   4298  CA  GLY C  69     -12.829 115.389  20.183  1.00 35.42           C  
ATOM   4299  C   GLY C  69     -13.609 116.258  21.156  1.00 36.68           C  
ATOM   4300  O   GLY C  69     -14.809 116.483  20.984  1.00 37.02           O  
ATOM   4301  N   MET C  70     -12.922 116.766  22.166  1.00 37.85           N  
ATOM   4302  CA  MET C  70     -13.572 117.573  23.190  1.00 40.27           C  
ATOM   4303  C   MET C  70     -14.015 118.897  22.565  1.00 38.76           C  
ATOM   4304  O   MET C  70     -13.277 119.483  21.771  1.00 37.61           O  
ATOM   4305  CB  MET C  70     -12.633 117.814  24.372  1.00 40.31           C  
ATOM   4306  CG  MET C  70     -11.621 118.959  24.188  1.00 43.11           C  
ATOM   4307  SD  MET C  70     -11.032 119.732  25.754  1.00 47.25           S  
ATOM   4308  CE  MET C  70     -12.525 119.830  26.743  1.00 46.49           C  
ATOM   4309  N   ASP C  71     -15.221 119.346  22.902  1.00 38.13           N  
ATOM   4310  CA  ASP C  71     -15.701 120.656  22.432  1.00 37.91           C  
ATOM   4311  C   ASP C  71     -15.094 121.680  23.376  1.00 38.79           C  
ATOM   4312  O   ASP C  71     -15.568 121.836  24.510  1.00 38.01           O  
ATOM   4313  CB  ASP C  71     -17.231 120.713  22.496  1.00 37.07           C  
ATOM   4314  CG  ASP C  71     -17.816 121.995  21.877  1.00 35.29           C  
ATOM   4315  OD1 ASP C  71     -17.191 123.076  21.963  1.00 28.60           O  
ATOM   4316  OD2 ASP C  71     -18.910 121.908  21.290  1.00 33.34           O  
ATOM   4317  N   LEU C  72     -14.025 122.347  22.941  1.00 39.99           N  
ATOM   4318  CA  LEU C  72     -13.281 123.219  23.870  1.00 41.62           C  
ATOM   4319  C   LEU C  72     -13.967 124.551  24.216  1.00 42.96           C  
ATOM   4320  O   LEU C  72     -13.765 125.087  25.320  1.00 43.61           O  
ATOM   4321  CB  LEU C  72     -11.835 123.438  23.408  1.00 41.85           C  
ATOM   4322  CG  LEU C  72     -10.846 123.999  24.440  0.50 41.89           C  
ATOM   4323  CD1 LEU C  72     -10.800 123.137  25.699  0.50 42.75           C  
ATOM   4324  CD2 LEU C  72      -9.449 124.144  23.842  0.50 42.62           C  
ATOM   4325  N   LYS C  73     -14.783 125.079  23.305  1.00 44.13           N  
ATOM   4326  CA  LYS C  73     -15.583 126.260  23.638  1.00 45.43           C  
ATOM   4327  C   LYS C  73     -16.658 125.895  24.670  1.00 46.35           C  
ATOM   4328  O   LYS C  73     -16.770 126.526  25.721  1.00 46.18           O  
ATOM   4329  CB  LYS C  73     -16.190 126.893  22.390  0.50 45.32           C  
ATOM   4330  CG  LYS C  73     -15.169 127.625  21.527  0.50 45.83           C  
ATOM   4331  CD  LYS C  73     -15.790 128.847  20.854  0.50 46.43           C  
ATOM   4332  CE  LYS C  73     -14.809 129.514  19.895  0.50 46.36           C  
ATOM   4333  NZ  LYS C  73     -15.364 130.773  19.320  0.50 46.34           N  
ATOM   4334  N   GLU C  74     -17.414 124.846  24.366  1.00 47.85           N  
ATOM   4335  CA  GLU C  74     -18.501 124.352  25.213  1.00 49.78           C  
ATOM   4336  C   GLU C  74     -18.035 123.901  26.622  1.00 51.10           C  
ATOM   4337  O   GLU C  74     -18.793 124.006  27.600  1.00 51.08           O  
ATOM   4338  CB  GLU C  74     -19.206 123.218  24.474  1.00 49.77           C  
ATOM   4339  CG  GLU C  74     -20.718 123.268  24.455  1.00 51.06           C  
ATOM   4340  CD  GLU C  74     -21.274 124.606  24.073  1.00 52.69           C  
ATOM   4341  OE1 GLU C  74     -20.806 125.202  23.082  1.00 53.69           O  
ATOM   4342  OE2 GLU C  74     -22.196 125.064  24.773  1.00 53.74           O  
ATOM   4343  N   TYR C  75     -16.792 123.414  26.713  1.00 52.63           N  
ATOM   4344  CA  TYR C  75     -16.123 123.116  27.995  1.00 54.22           C  
ATOM   4345  C   TYR C  75     -15.834 124.381  28.831  1.00 55.00           C  
ATOM   4346  O   TYR C  75     -16.238 124.457  29.988  1.00 55.15           O  
ATOM   4347  CB  TYR C  75     -14.821 122.348  27.744  1.00 54.76           C  
ATOM   4348  CG  TYR C  75     -13.952 122.113  28.966  1.00 55.74           C  
ATOM   4349  CD1 TYR C  75     -13.004 123.064  29.370  1.00 56.76           C  
ATOM   4350  CD2 TYR C  75     -14.055 120.926  29.706  1.00 56.77           C  
ATOM   4351  CE1 TYR C  75     -12.200 122.856  30.505  1.00 57.24           C  
ATOM   4352  CE2 TYR C  75     -13.244 120.695  30.838  1.00 56.80           C  
ATOM   4353  CZ  TYR C  75     -12.322 121.667  31.227  1.00 56.76           C  
ATOM   4354  OH  TYR C  75     -11.526 121.459  32.336  1.00 57.61           O  
ATOM   4355  N   PHE C  76     -15.116 125.347  28.247  1.00 55.91           N  
ATOM   4356  CA  PHE C  76     -14.790 126.613  28.918  1.00 56.75           C  
ATOM   4357  C   PHE C  76     -16.028 127.418  29.275  1.00 56.71           C  
ATOM   4358  O   PHE C  76     -16.040 128.106  30.297  1.00 57.09           O  
ATOM   4359  CB  PHE C  76     -13.856 127.489  28.064  1.00 57.30           C  
ATOM   4360  CG  PHE C  76     -12.438 126.993  28.003  1.00 58.62           C  
ATOM   4361  CD1 PHE C  76     -11.884 126.279  29.069  1.00 59.84           C  
ATOM   4362  CD2 PHE C  76     -11.645 127.258  26.889  1.00 60.15           C  
ATOM   4363  CE1 PHE C  76     -10.567 125.813  29.017  1.00 60.04           C  
ATOM   4364  CE2 PHE C  76     -10.319 126.805  26.829  1.00 60.08           C  
ATOM   4365  CZ  PHE C  76      -9.783 126.084  27.897  1.00 59.51           C  
ATOM   4366  N   ARG C  77     -17.053 127.344  28.424  1.00 56.55           N  
ATOM   4367  CA  ARG C  77     -18.330 128.010  28.670  1.00 55.98           C  
ATOM   4368  C   ARG C  77     -18.789 127.732  30.100  1.00 55.79           C  
ATOM   4369  O   ARG C  77     -19.131 128.658  30.836  1.00 55.95           O  
ATOM   4370  N   GLU C  78     -18.766 126.458  30.488  1.00 55.46           N  
ATOM   4371  CA  GLU C  78     -19.187 126.040  31.829  1.00 55.15           C  
ATOM   4372  C   GLU C  78     -18.110 126.242  32.915  1.00 54.98           C  
ATOM   4373  O   GLU C  78     -18.409 126.777  33.985  1.00 55.06           O  
ATOM   4374  CB  GLU C  78     -19.710 124.591  31.816  1.00 55.14           C  
ATOM   4375  CG  GLU C  78     -20.846 124.340  30.805  1.00 55.09           C  
ATOM   4376  CD  GLU C  78     -21.540 122.977  30.947  1.00 55.05           C  
ATOM   4377  OE1 GLU C  78     -21.413 122.328  32.014  1.00 54.72           O  
ATOM   4378  OE2 GLU C  78     -22.228 122.563  29.980  1.00 53.40           O  
ATOM   4379  N   VAL C  79     -16.868 125.842  32.622  1.00 54.87           N  
ATOM   4380  CA  VAL C  79     -15.756 125.850  33.600  1.00 54.70           C  
ATOM   4381  C   VAL C  79     -15.368 127.238  34.147  1.00 54.63           C  
ATOM   4382  O   VAL C  79     -14.950 127.361  35.309  1.00 54.96           O  
ATOM   4383  CB  VAL C  79     -14.485 125.157  33.040  1.00 54.52           C  
ATOM   4384  N   ASP C  80     -15.511 128.273  33.317  1.00 54.05           N  
ATOM   4385  CA  ASP C  80     -15.180 129.649  33.711  1.00 53.11           C  
ATOM   4386  C   ASP C  80     -16.375 130.409  34.305  1.00 52.32           C  
ATOM   4387  O   ASP C  80     -16.207 131.494  34.880  1.00 52.35           O  
ATOM   4388  CB  ASP C  80     -14.590 130.416  32.525  1.00 53.46           C  
ATOM   4389  CG  ASP C  80     -13.353 129.735  31.942  1.00 53.93           C  
ATOM   4390  N   ALA C  81     -17.576 129.842  34.172  1.00 50.98           N  
ATOM   4391  CA  ALA C  81     -18.784 130.430  34.773  1.00 49.48           C  
ATOM   4392  C   ALA C  81     -19.039 129.872  36.175  1.00 48.27           C  
ATOM   4393  O   ALA C  81     -19.925 130.343  36.892  1.00 48.33           O  
ATOM   4394  CB  ALA C  81     -20.008 130.217  33.874  1.00 49.55           C  
ATOM   4395  N   GLY C  82     -18.264 128.858  36.551  1.00 46.70           N  
ATOM   4396  CA  GLY C  82     -18.368 128.251  37.874  1.00 44.14           C  
ATOM   4397  C   GLY C  82     -17.036 128.207  38.595  1.00 42.12           C  
ATOM   4398  O   GLY C  82     -15.978 128.401  37.985  1.00 42.06           O  
ATOM   4399  N   PRO C  83     -17.072 127.920  39.898  1.00 40.69           N  
ATOM   4400  CA  PRO C  83     -15.861 127.859  40.717  1.00 39.41           C  
ATOM   4401  C   PRO C  83     -15.014 126.633  40.333  1.00 38.00           C  
ATOM   4402  O   PRO C  83     -15.489 125.781  39.568  1.00 37.14           O  
ATOM   4403  CB  PRO C  83     -16.420 127.736  42.136  1.00 39.97           C  
ATOM   4404  CG  PRO C  83     -17.724 127.026  41.949  1.00 40.58           C  
ATOM   4405  CD  PRO C  83     -18.280 127.581  40.668  1.00 40.68           C  
ATOM   4406  N   GLU C  84     -13.781 126.556  40.841  1.00 36.67           N  
ATOM   4407  CA  GLU C  84     -12.855 125.456  40.513  1.00 35.36           C  
ATOM   4408  C   GLU C  84     -13.533 124.083  40.555  1.00 34.54           C  
ATOM   4409  O   GLU C  84     -13.313 123.234  39.669  1.00 33.41           O  
ATOM   4410  CB  GLU C  84     -11.619 125.493  41.437  1.00 35.85           C  
ATOM   4411  CG  GLU C  84     -10.518 124.415  41.192  1.00 36.77           C  
ATOM   4412  CD  GLU C  84     -10.824 123.045  41.846  1.00 37.84           C  
ATOM   4413  OE1 GLU C  84     -11.455 123.012  42.928  1.00 38.48           O  
ATOM   4414  OE2 GLU C  84     -10.425 121.998  41.273  1.00 39.23           O  
ATOM   4415  N   ILE C  85     -14.352 123.865  41.584  1.00 33.54           N  
ATOM   4416  CA  ILE C  85     -14.909 122.541  41.832  1.00 33.28           C  
ATOM   4417  C   ILE C  85     -15.841 122.043  40.733  1.00 32.66           C  
ATOM   4418  O   ILE C  85     -16.046 120.834  40.593  1.00 32.02           O  
ATOM   4419  CB  ILE C  85     -15.558 122.427  43.227  1.00 33.67           C  
ATOM   4420  CG1 ILE C  85     -15.635 120.940  43.636  1.00 34.70           C  
ATOM   4421  CG2 ILE C  85     -16.902 123.170  43.268  1.00 33.35           C  
ATOM   4422  CD1 ILE C  85     -15.551 120.714  45.123  1.00 35.99           C  
ATOM   4423  N   LEU C  86     -16.379 122.968  39.938  1.00 32.38           N  
ATOM   4424  CA  LEU C  86     -17.184 122.594  38.774  1.00 32.37           C  
ATOM   4425  C   LEU C  86     -16.387 121.701  37.791  1.00 32.73           C  
ATOM   4426  O   LEU C  86     -16.938 120.776  37.175  1.00 32.44           O  
ATOM   4427  CB  LEU C  86     -17.725 123.839  38.058  1.00 32.14           C  
ATOM   4428  CG  LEU C  86     -18.766 123.609  36.957  1.00 32.29           C  
ATOM   4429  CD1 LEU C  86     -19.793 122.509  37.305  1.00 34.19           C  
ATOM   4430  CD2 LEU C  86     -19.461 124.921  36.569  1.00 33.30           C  
ATOM   4431  N   GLN C  87     -15.095 121.996  37.649  1.00 32.96           N  
ATOM   4432  CA  GLN C  87     -14.217 121.232  36.779  1.00 34.23           C  
ATOM   4433  C   GLN C  87     -14.203 119.732  37.155  1.00 33.77           C  
ATOM   4434  O   GLN C  87     -14.225 118.860  36.268  1.00 33.72           O  
ATOM   4435  CB  GLN C  87     -12.818 121.844  36.811  1.00 33.68           C  
ATOM   4436  CG  GLN C  87     -11.822 121.214  35.844  1.00 36.41           C  
ATOM   4437  CD  GLN C  87     -10.387 121.670  36.120  1.00 37.21           C  
ATOM   4438  OE1 GLN C  87      -9.857 121.469  37.222  1.00 42.35           O  
ATOM   4439  NE2 GLN C  87      -9.764 122.298  35.131  1.00 37.43           N  
ATOM   4440  N   GLU C  88     -14.191 119.445  38.462  1.00 33.33           N  
ATOM   4441  CA  GLU C  88     -14.237 118.063  38.968  1.00 33.11           C  
ATOM   4442  C   GLU C  88     -15.404 117.316  38.332  1.00 32.11           C  
ATOM   4443  O   GLU C  88     -15.216 116.250  37.713  1.00 30.66           O  
ATOM   4444  CB  GLU C  88     -14.364 118.009  40.506  1.00 33.35           C  
ATOM   4445  CG  GLU C  88     -13.190 118.582  41.289  1.00 37.61           C  
ATOM   4446  CD  GLU C  88     -11.979 117.665  41.289  1.00 44.46           C  
ATOM   4447  OE1 GLU C  88     -11.894 116.755  42.158  1.00 47.63           O  
ATOM   4448  OE2 GLU C  88     -11.104 117.863  40.414  1.00 46.20           O  
ATOM   4449  N   LYS C  89     -16.599 117.895  38.472  1.00 30.21           N  
ATOM   4450  CA  LYS C  89     -17.834 117.319  37.934  1.00 29.78           C  
ATOM   4451  C   LYS C  89     -17.812 117.143  36.406  1.00 28.70           C  
ATOM   4452  O   LYS C  89     -18.251 116.104  35.887  1.00 26.32           O  
ATOM   4453  CB  LYS C  89     -19.044 118.163  38.364  1.00 30.14           C  
ATOM   4454  CG  LYS C  89     -20.395 117.803  37.714  1.00 30.26           C  
ATOM   4455  CD  LYS C  89     -21.464 118.779  38.240  1.00 30.78           C  
ATOM   4456  CE  LYS C  89     -22.825 118.657  37.536  1.00 34.27           C  
ATOM   4457  NZ  LYS C  89     -22.815 119.058  36.050  1.00 35.84           N  
ATOM   4458  N   ILE C  90     -17.320 118.160  35.702  1.00 27.67           N  
ATOM   4459  CA  ILE C  90     -17.301 118.136  34.243  1.00 27.21           C  
ATOM   4460  C   ILE C  90     -16.359 117.024  33.738  1.00 27.78           C  
ATOM   4461  O   ILE C  90     -16.688 116.293  32.803  1.00 27.54           O  
ATOM   4462  CB  ILE C  90     -16.968 119.535  33.683  1.00 27.48           C  
ATOM   4463  CG1 ILE C  90     -18.186 120.467  33.854  1.00 28.43           C  
ATOM   4464  CG2 ILE C  90     -16.584 119.482  32.196  1.00 27.86           C  
ATOM   4465  CD1 ILE C  90     -17.798 121.912  34.054  1.00 31.85           C  
ATOM   4466  N   ARG C  91     -15.208 116.864  34.394  1.00 27.53           N  
ATOM   4467  CA  ARG C  91     -14.302 115.747  34.073  1.00 27.69           C  
ATOM   4468  C   ARG C  91     -14.871 114.381  34.431  1.00 27.82           C  
ATOM   4469  O   ARG C  91     -14.720 113.434  33.658  1.00 28.08           O  
ATOM   4470  CB  ARG C  91     -12.927 115.944  34.720  1.00 26.61           C  
ATOM   4471  CG  ARG C  91     -12.119 117.101  34.096  1.00 27.73           C  
ATOM   4472  CD  ARG C  91     -11.020 117.502  35.071  1.00 27.14           C  
ATOM   4473  NE  ARG C  91     -10.009 118.354  34.453  1.00 28.48           N  
ATOM   4474  CZ  ARG C  91      -8.854 118.693  35.026  1.00 28.89           C  
ATOM   4475  NH1 ARG C  91      -8.539 118.257  36.266  1.00 30.35           N  
ATOM   4476  NH2 ARG C  91      -8.010 119.478  34.378  1.00 22.68           N  
ATOM   4477  N   ARG C  92     -15.496 114.260  35.599  1.00 28.34           N  
ATOM   4478  CA  ARG C  92     -16.108 112.986  35.966  1.00 30.30           C  
ATOM   4479  C   ARG C  92     -17.131 112.549  34.887  1.00 29.58           C  
ATOM   4480  O   ARG C  92     -17.193 111.365  34.544  1.00 29.72           O  
ATOM   4481  CB  ARG C  92     -16.718 113.045  37.384  1.00 30.00           C  
ATOM   4482  CG  ARG C  92     -17.614 111.818  37.738  1.00 34.24           C  
ATOM   4483  CD  ARG C  92     -18.479 112.064  39.010  1.00 33.69           C  
ATOM   4484  NE  ARG C  92     -17.689 112.883  39.902  1.00 38.23           N  
ATOM   4485  CZ  ARG C  92     -18.016 114.072  40.402  1.00 37.48           C  
ATOM   4486  NH1 ARG C  92     -19.203 114.641  40.204  1.00 35.04           N  
ATOM   4487  NH2 ARG C  92     -17.117 114.659  41.162  1.00 39.66           N  
ATOM   4488  N   GLU C  93     -17.881 113.509  34.320  1.00 28.76           N  
ATOM   4489  CA  GLU C  93     -18.973 113.209  33.389  1.00 27.26           C  
ATOM   4490  C   GLU C  93     -18.466 112.691  32.056  1.00 26.14           C  
ATOM   4491  O   GLU C  93     -19.015 111.737  31.514  1.00 25.25           O  
ATOM   4492  CB  GLU C  93     -19.855 114.451  33.160  1.00 27.48           C  
ATOM   4493  CG  GLU C  93     -20.838 114.701  34.310  1.00 28.04           C  
ATOM   4494  CD  GLU C  93     -21.518 116.095  34.310  1.00 27.67           C  
ATOM   4495  OE1 GLU C  93     -21.299 116.941  33.397  1.00 27.91           O  
ATOM   4496  OE2 GLU C  93     -22.284 116.324  35.262  1.00 29.53           O  
ATOM   4497  N   ALA C  94     -17.408 113.326  31.560  1.00 24.43           N  
ATOM   4498  CA  ALA C  94     -16.707 112.882  30.357  1.00 24.66           C  
ATOM   4499  C   ALA C  94     -16.175 111.463  30.554  1.00 25.11           C  
ATOM   4500  O   ALA C  94     -16.447 110.583  29.741  1.00 25.45           O  
ATOM   4501  CB  ALA C  94     -15.590 113.861  30.012  1.00 23.66           C  
ATOM   4502  N   SER C  95     -15.500 111.229  31.676  1.00 24.56           N  
ATOM   4503  CA  SER C  95     -14.957 109.904  31.989  1.00 25.85           C  
ATOM   4504  C   SER C  95     -16.072 108.889  32.160  1.00 25.82           C  
ATOM   4505  O   SER C  95     -15.945 107.741  31.708  1.00 25.87           O  
ATOM   4506  CB  SER C  95     -14.135 109.971  33.267  1.00 25.88           C  
ATOM   4507  OG  SER C  95     -12.848 110.436  32.961  1.00 26.78           O  
ATOM   4508  N   GLN C  96     -17.177 109.324  32.766  1.00 25.22           N  
ATOM   4509  CA  GLN C  96     -18.249 108.414  33.093  1.00 25.91           C  
ATOM   4510  C   GLN C  96     -18.776 107.645  31.899  1.00 25.47           C  
ATOM   4511  O   GLN C  96     -18.852 106.424  31.952  1.00 24.46           O  
ATOM   4512  CB  GLN C  96     -19.375 109.101  33.856  1.00 27.20           C  
ATOM   4513  CG  GLN C  96     -20.496 108.129  34.238  1.00 30.43           C  
ATOM   4514  CD  GLN C  96     -20.116 107.192  35.386  1.00 29.23           C  
ATOM   4515  OE1 GLN C  96     -19.008 107.247  35.912  1.00 32.87           O  
ATOM   4516  NE2 GLN C  96     -21.035 106.309  35.753  1.00 28.88           N  
ATOM   4517  N   TRP C  97     -19.105 108.342  30.811  1.00 25.16           N  
ATOM   4518  CA  TRP C  97     -19.526 107.667  29.591  1.00 25.91           C  
ATOM   4519  C   TRP C  97     -18.390 107.182  28.689  1.00 26.12           C  
ATOM   4520  O   TRP C  97     -18.509 106.123  28.078  1.00 26.67           O  
ATOM   4521  CB  TRP C  97     -20.513 108.525  28.780  1.00 25.94           C  
ATOM   4522  CG  TRP C  97     -19.879 109.480  27.810  1.00 27.13           C  
ATOM   4523  CD1 TRP C  97     -19.620 110.813  28.019  1.00 27.23           C  
ATOM   4524  CD2 TRP C  97     -19.470 109.202  26.458  1.00 27.70           C  
ATOM   4525  NE1 TRP C  97     -19.062 111.366  26.900  1.00 25.98           N  
ATOM   4526  CE2 TRP C  97     -18.966 110.412  25.922  1.00 26.29           C  
ATOM   4527  CE3 TRP C  97     -19.456 108.039  25.656  1.00 26.84           C  
ATOM   4528  CZ2 TRP C  97     -18.464 110.508  24.609  1.00 26.67           C  
ATOM   4529  CZ3 TRP C  97     -18.953 108.135  24.334  1.00 27.86           C  
ATOM   4530  CH2 TRP C  97     -18.461 109.368  23.835  1.00 28.42           C  
ATOM   4531  N   GLN C  98     -17.324 107.966  28.553  1.00 25.36           N  
ATOM   4532  CA  GLN C  98     -16.207 107.555  27.723  1.00 24.39           C  
ATOM   4533  C   GLN C  98     -15.556 106.216  28.099  1.00 24.74           C  
ATOM   4534  O   GLN C  98     -15.170 105.459  27.225  1.00 23.18           O  
ATOM   4535  CB  GLN C  98     -15.148 108.628  27.688  1.00 24.49           C  
ATOM   4536  CG  GLN C  98     -15.697 109.919  27.078  1.00 25.57           C  
ATOM   4537  CD  GLN C  98     -14.663 111.018  26.946  1.00 27.40           C  
ATOM   4538  OE1 GLN C  98     -13.504 110.888  27.374  1.00 31.18           O  
ATOM   4539  NE2 GLN C  98     -15.082 112.118  26.363  1.00 30.33           N  
ATOM   4540  N   TRP C  99     -15.414 105.915  29.382  1.00 25.05           N  
ATOM   4541  CA  TRP C  99     -14.766 104.641  29.748  1.00 25.49           C  
ATOM   4542  C   TRP C  99     -15.257 104.014  31.056  1.00 26.70           C  
ATOM   4543  O   TRP C  99     -15.220 102.782  31.187  1.00 26.90           O  
ATOM   4544  CB  TRP C  99     -13.235 104.784  29.723  1.00 25.77           C  
ATOM   4545  CG  TRP C  99     -12.676 105.855  30.676  1.00 27.01           C  
ATOM   4546  CD1 TRP C  99     -12.425 107.157  30.354  1.00 27.34           C  
ATOM   4547  CD2 TRP C  99     -12.296 105.707  32.060  1.00 26.70           C  
ATOM   4548  NE1 TRP C  99     -11.928 107.834  31.431  1.00 25.59           N  
ATOM   4549  CE2 TRP C  99     -11.842 106.981  32.500  1.00 28.52           C  
ATOM   4550  CE3 TRP C  99     -12.304 104.642  32.971  1.00 25.86           C  
ATOM   4551  CZ2 TRP C  99     -11.404 107.222  33.802  1.00 26.71           C  
ATOM   4552  CZ3 TRP C  99     -11.856 104.875  34.309  1.00 26.09           C  
ATOM   4553  CH2 TRP C  99     -11.417 106.160  34.702  1.00 26.60           C  
ATOM   4554  N   LYS C 100     -15.705 104.816  32.028  1.00 26.54           N  
ATOM   4555  CA  LYS C 100     -16.076 104.213  33.296  1.00 27.47           C  
ATOM   4556  C   LYS C 100     -17.226 103.260  33.041  1.00 27.73           C  
ATOM   4557  O   LYS C 100     -17.187 102.127  33.511  1.00 28.77           O  
ATOM   4558  CB  LYS C 100     -16.410 105.222  34.414  1.00 27.99           C  
ATOM   4559  CG  LYS C 100     -15.233 106.071  34.889  1.00 27.91           C  
ATOM   4560  CD  LYS C 100     -15.587 106.894  36.102  1.00 30.37           C  
ATOM   4561  CE  LYS C 100     -14.465 107.846  36.570  1.00 29.44           C  
ATOM   4562  NZ  LYS C 100     -13.652 107.069  37.475  1.00 34.96           N  
ATOM   4563  N   LEU C 101     -18.252 103.704  32.308  1.00 26.33           N  
ATOM   4564  CA  LEU C 101     -19.312 102.782  31.919  1.00 25.87           C  
ATOM   4565  C   LEU C 101     -18.934 101.976  30.689  1.00 25.71           C  
ATOM   4566  O   LEU C 101     -19.281 100.794  30.604  1.00 25.12           O  
ATOM   4567  CB  LEU C 101     -20.609 103.521  31.584  1.00 26.62           C  
ATOM   4568  CG  LEU C 101     -21.352 104.278  32.657  1.00 25.29           C  
ATOM   4569  CD1 LEU C 101     -22.645 104.938  32.004  1.00 23.26           C  
ATOM   4570  CD2 LEU C 101     -21.678 103.370  33.829  1.00 27.39           C  
ATOM   4571  N   LEU C 102     -18.234 102.615  29.750  1.00 25.31           N  
ATOM   4572  CA  LEU C 102     -18.091 102.051  28.421  1.00 25.19           C  
ATOM   4573  C   LEU C 102     -17.076 100.904  28.391  1.00 25.64           C  
ATOM   4574  O   LEU C 102     -17.343  99.857  27.808  1.00 25.95           O  
ATOM   4575  CB  LEU C 102     -17.728 103.151  27.399  1.00 26.47           C  
ATOM   4576  CG  LEU C 102     -17.789 102.862  25.880  1.00 26.81           C  
ATOM   4577  CD1 LEU C 102     -19.043 102.089  25.397  1.00 28.07           C  
ATOM   4578  CD2 LEU C 102     -17.574 104.090  25.005  1.00 28.03           C  
ATOM   4579  N   ARG C 103     -15.937 101.074  29.063  1.00 24.65           N  
ATOM   4580  CA  ARG C 103     -14.827 100.124  28.864  1.00 24.13           C  
ATOM   4581  C   ARG C 103     -15.251  98.722  29.303  1.00 24.58           C  
ATOM   4582  O   ARG C 103     -15.001  97.719  28.589  1.00 24.97           O  
ATOM   4583  CB  ARG C 103     -13.562 100.610  29.565  1.00 22.07           C  
ATOM   4584  CG  ARG C 103     -12.387  99.584  29.547  1.00 23.01           C  
ATOM   4585  CD  ARG C 103     -11.113 100.274  29.930  1.00 23.38           C  
ATOM   4586  NE  ARG C 103     -10.059  99.300  30.253  1.00 26.08           N  
ATOM   4587  CZ  ARG C 103      -9.681  98.920  31.469  1.00 24.90           C  
ATOM   4588  NH1 ARG C 103     -10.284  99.391  32.578  1.00 22.80           N  
ATOM   4589  NH2 ARG C 103      -8.676  98.042  31.585  1.00 24.43           N  
ATOM   4590  N   MET C 104     -15.901  98.640  30.455  1.00 23.51           N  
ATOM   4591  CA  MET C 104     -16.416  97.377  30.942  1.00 24.21           C  
ATOM   4592  C   MET C 104     -17.963  97.347  30.773  1.00 24.64           C  
ATOM   4593  O   MET C 104     -18.689  96.962  31.700  1.00 24.73           O  
ATOM   4594  CB  MET C 104     -16.038  97.165  32.427  1.00 24.06           C  
ATOM   4595  CG  MET C 104     -14.536  97.121  32.701  1.00 24.87           C  
ATOM   4596  SD  MET C 104     -13.742  95.726  31.871  1.00 24.32           S  
ATOM   4597  CE  MET C 104     -12.116  95.727  32.640  1.00 25.26           C  
ATOM   4598  N   TYR C 105     -18.450  97.765  29.618  1.00 25.23           N  
ATOM   4599  CA  TYR C 105     -19.915  97.819  29.350  1.00 25.66           C  
ATOM   4600  C   TYR C 105     -20.575  96.431  29.386  1.00 25.44           C  
ATOM   4601  O   TYR C 105     -19.948  95.442  29.045  1.00 24.87           O  
ATOM   4602  CB  TYR C 105     -20.193  98.521  28.036  1.00 25.94           C  
ATOM   4603  CG  TYR C 105     -21.633  98.965  27.886  1.00 25.70           C  
ATOM   4604  CD1 TYR C 105     -22.401  98.533  26.800  1.00 26.09           C  
ATOM   4605  CD2 TYR C 105     -22.223  99.812  28.823  1.00 23.89           C  
ATOM   4606  CE1 TYR C 105     -23.755  98.962  26.632  1.00 23.88           C  
ATOM   4607  CE2 TYR C 105     -23.590 100.242  28.688  1.00 22.82           C  
ATOM   4608  CZ  TYR C 105     -24.337  99.809  27.569  1.00 26.29           C  
ATOM   4609  OH  TYR C 105     -25.669 100.211  27.419  1.00 28.14           O  
ATOM   4610  N   ALA C 106     -21.814  96.356  29.854  1.00 25.48           N  
ATOM   4611  CA  ALA C 106     -22.496  95.058  30.007  1.00 26.03           C  
ATOM   4612  C   ALA C 106     -22.621  94.360  28.659  1.00 26.67           C  
ATOM   4613  O   ALA C 106     -22.608  93.116  28.589  1.00 26.80           O  
ATOM   4614  CB  ALA C 106     -23.891  95.247  30.679  1.00 26.35           C  
ATOM   4615  N   LYS C 107     -22.675  95.160  27.586  1.00 26.05           N  
ATOM   4616  CA  LYS C 107     -22.982  94.671  26.255  1.00 27.69           C  
ATOM   4617  C   LYS C 107     -21.794  94.875  25.314  1.00 27.37           C  
ATOM   4618  O   LYS C 107     -20.948  95.759  25.548  1.00 28.50           O  
ATOM   4619  CB  LYS C 107     -24.272  95.328  25.678  1.00 26.86           C  
ATOM   4620  CG  LYS C 107     -25.517  94.928  26.479  1.00 29.03           C  
ATOM   4621  CD  LYS C 107     -26.802  95.657  26.045  1.00 27.73           C  
ATOM   4622  CE  LYS C 107     -28.008  95.129  26.873  1.00 27.08           C  
ATOM   4623  NZ  LYS C 107     -29.334  95.707  26.395  1.00 25.95           N  
ATOM   4624  N   PRO C 108     -21.699  94.040  24.271  1.00 28.10           N  
ATOM   4625  CA  PRO C 108     -20.580  94.194  23.347  1.00 27.78           C  
ATOM   4626  C   PRO C 108     -20.691  95.528  22.626  1.00 26.99           C  
ATOM   4627  O   PRO C 108     -21.808  95.988  22.322  1.00 27.05           O  
ATOM   4628  CB  PRO C 108     -20.750  93.032  22.367  1.00 27.64           C  
ATOM   4629  CG  PRO C 108     -22.158  92.625  22.485  1.00 28.81           C  
ATOM   4630  CD  PRO C 108     -22.563  92.901  23.902  1.00 28.50           C  
ATOM   4631  N   THR C 109     -19.544  96.143  22.371  1.00 25.90           N  
ATOM   4632  CA  THR C 109     -19.474  97.464  21.777  1.00 26.31           C  
ATOM   4633  C   THR C 109     -18.493  97.489  20.612  1.00 26.19           C  
ATOM   4634  O   THR C 109     -17.425  96.861  20.642  1.00 25.84           O  
ATOM   4635  CB  THR C 109     -19.062  98.566  22.814  1.00 27.08           C  
ATOM   4636  OG1 THR C 109     -17.830  98.215  23.451  1.00 27.23           O  
ATOM   4637  CG2 THR C 109     -20.144  98.760  23.912  1.00 25.97           C  
ATOM   4638  N   ILE C 110     -18.885  98.200  19.558  1.00 26.85           N  
ATOM   4639  CA  ILE C 110     -18.057  98.372  18.384  1.00 27.09           C  
ATOM   4640  C   ILE C 110     -18.034  99.858  18.080  1.00 27.53           C  
ATOM   4641  O   ILE C 110     -19.097 100.497  18.008  1.00 29.24           O  
ATOM   4642  CB  ILE C 110     -18.626  97.577  17.157  1.00 26.99           C  
ATOM   4643  CG1 ILE C 110     -18.908  96.108  17.561  1.00 28.11           C  
ATOM   4644  CG2 ILE C 110     -17.683  97.682  15.944  1.00 26.52           C  
ATOM   4645  CD1 ILE C 110     -19.884  95.380  16.616  1.00 26.65           C  
ATOM   4646  N   ALA C 111     -16.841 100.419  17.933  1.00 27.11           N  
ATOM   4647  CA  ALA C 111     -16.705 101.754  17.379  1.00 27.60           C  
ATOM   4648  C   ALA C 111     -16.705 101.648  15.865  1.00 27.99           C  
ATOM   4649  O   ALA C 111     -15.799 101.040  15.298  1.00 28.42           O  
ATOM   4650  CB  ALA C 111     -15.415 102.402  17.853  1.00 25.90           C  
ATOM   4651  N   MET C 112     -17.700 102.234  15.206  1.00 28.40           N  
ATOM   4652  CA  MET C 112     -17.699 102.322  13.735  1.00 28.83           C  
ATOM   4653  C   MET C 112     -17.256 103.728  13.339  1.00 29.18           C  
ATOM   4654  O   MET C 112     -18.093 104.651  13.216  1.00 28.35           O  
ATOM   4655  CB  MET C 112     -19.076 101.963  13.124  1.00 28.21           C  
ATOM   4656  CG  MET C 112     -19.174 102.000  11.565  1.00 29.20           C  
ATOM   4657  SD  MET C 112     -20.839 101.523  11.011  1.00 29.20           S  
ATOM   4658  CE  MET C 112     -21.815 103.022  11.314  1.00 27.81           C  
ATOM   4659  N   VAL C 113     -15.940 103.869  13.161  1.00 28.98           N  
ATOM   4660  CA  VAL C 113     -15.314 105.166  12.937  1.00 28.47           C  
ATOM   4661  C   VAL C 113     -15.462 105.559  11.487  1.00 29.05           C  
ATOM   4662  O   VAL C 113     -14.668 105.146  10.614  1.00 29.01           O  
ATOM   4663  CB  VAL C 113     -13.842 105.204  13.326  1.00 29.31           C  
ATOM   4664  CG1 VAL C 113     -13.360 106.669  13.316  1.00 28.64           C  
ATOM   4665  CG2 VAL C 113     -13.629 104.568  14.730  1.00 25.47           C  
ATOM   4666  N   ASN C 114     -16.490 106.360  11.242  1.00 27.84           N  
ATOM   4667  CA  ASN C 114     -16.859 106.763   9.891  1.00 28.54           C  
ATOM   4668  C   ASN C 114     -16.037 107.907   9.298  1.00 29.11           C  
ATOM   4669  O   ASN C 114     -16.154 108.197   8.100  1.00 28.82           O  
ATOM   4670  CB  ASN C 114     -18.337 107.127   9.861  1.00 28.15           C  
ATOM   4671  CG  ASN C 114     -18.691 108.139  10.907  1.00 27.53           C  
ATOM   4672  OD1 ASN C 114     -18.667 107.850  12.135  1.00 26.95           O  
ATOM   4673  ND2 ASN C 114     -19.005 109.339  10.454  1.00 26.24           N  
ATOM   4674  N   GLY C 115     -15.190 108.529  10.118  1.00 29.36           N  
ATOM   4675  CA  GLY C 115     -14.492 109.750   9.715  1.00 29.28           C  
ATOM   4676  C   GLY C 115     -13.696 110.327  10.861  1.00 29.46           C  
ATOM   4677  O   GLY C 115     -13.206 109.580  11.693  1.00 29.33           O  
ATOM   4678  N   TRP C 116     -13.564 111.655  10.898  1.00 29.97           N  
ATOM   4679  CA  TRP C 116     -12.692 112.350  11.870  1.00 31.05           C  
ATOM   4680  C   TRP C 116     -12.676 111.765  13.294  1.00 30.60           C  
ATOM   4681  O   TRP C 116     -13.722 111.618  13.941  1.00 30.76           O  
ATOM   4682  CB  TRP C 116     -13.065 113.834  11.945  1.00 32.60           C  
ATOM   4683  CG  TRP C 116     -13.110 114.554  10.576  1.00 33.72           C  
ATOM   4684  CD1 TRP C 116     -14.225 114.967   9.896  1.00 35.54           C  
ATOM   4685  CD2 TRP C 116     -11.985 114.963   9.786  1.00 34.79           C  
ATOM   4686  NE1 TRP C 116     -13.861 115.588   8.711  1.00 34.78           N  
ATOM   4687  CE2 TRP C 116     -12.494 115.608   8.626  1.00 35.69           C  
ATOM   4688  CE3 TRP C 116     -10.591 114.831   9.938  1.00 35.75           C  
ATOM   4689  CZ2 TRP C 116     -11.654 116.130   7.626  1.00 36.72           C  
ATOM   4690  CZ3 TRP C 116      -9.757 115.341   8.953  1.00 36.06           C  
ATOM   4691  CH2 TRP C 116     -10.287 115.980   7.806  1.00 35.82           C  
ATOM   4692  N   CYS C 117     -11.482 111.459  13.778  1.00 29.96           N  
ATOM   4693  CA  CYS C 117     -11.308 111.004  15.162  1.00 29.74           C  
ATOM   4694  C   CYS C 117     -10.075 111.672  15.759  1.00 29.19           C  
ATOM   4695  O   CYS C 117      -8.947 111.257  15.520  1.00 29.49           O  
ATOM   4696  CB  CYS C 117     -11.234 109.459  15.242  1.00 28.89           C  
ATOM   4697  SG  CYS C 117     -11.030 108.790  16.905  1.00 29.90           S  
ATOM   4698  N   PHE C 118     -10.296 112.717  16.535  1.00 29.23           N  
ATOM   4699  CA  PHE C 118      -9.185 113.417  17.162  1.00 30.27           C  
ATOM   4700  C   PHE C 118      -9.278 113.433  18.685  1.00 29.59           C  
ATOM   4701  O   PHE C 118     -10.366 113.308  19.285  1.00 29.25           O  
ATOM   4702  CB  PHE C 118      -9.061 114.859  16.629  1.00 31.66           C  
ATOM   4703  CG  PHE C 118      -8.665 114.959  15.179  1.00 34.74           C  
ATOM   4704  CD1 PHE C 118      -9.635 115.017  14.174  1.00 39.41           C  
ATOM   4705  CD2 PHE C 118      -7.337 115.073  14.819  1.00 36.57           C  
ATOM   4706  CE1 PHE C 118      -9.278 115.133  12.817  1.00 40.67           C  
ATOM   4707  CE2 PHE C 118      -6.957 115.190  13.488  1.00 37.47           C  
ATOM   4708  CZ  PHE C 118      -7.928 115.212  12.470  1.00 38.06           C  
ATOM   4709  N   GLY C 119      -8.108 113.564  19.303  1.00 29.78           N  
ATOM   4710  CA  GLY C 119      -7.961 113.868  20.725  1.00 29.45           C  
ATOM   4711  C   GLY C 119      -8.725 112.953  21.651  1.00 29.85           C  
ATOM   4712  O   GLY C 119      -8.559 111.722  21.648  1.00 30.74           O  
ATOM   4713  N   GLY C 120      -9.604 113.568  22.420  1.00 28.67           N  
ATOM   4714  CA  GLY C 120     -10.332 112.878  23.459  1.00 26.15           C  
ATOM   4715  C   GLY C 120     -11.193 111.781  22.898  1.00 26.03           C  
ATOM   4716  O   GLY C 120     -11.571 110.869  23.623  1.00 25.01           O  
ATOM   4717  N   GLY C 121     -11.487 111.857  21.598  1.00 24.40           N  
ATOM   4718  CA  GLY C 121     -12.174 110.771  20.909  1.00 24.60           C  
ATOM   4719  C   GLY C 121     -11.480 109.408  21.104  1.00 24.78           C  
ATOM   4720  O   GLY C 121     -12.129 108.363  21.009  1.00 24.42           O  
ATOM   4721  N   PHE C 122     -10.175 109.417  21.368  1.00 23.58           N  
ATOM   4722  CA  PHE C 122      -9.413 108.134  21.473  1.00 24.63           C  
ATOM   4723  C   PHE C 122      -9.836 107.316  22.674  1.00 24.33           C  
ATOM   4724  O   PHE C 122      -9.685 106.097  22.656  1.00 24.59           O  
ATOM   4725  CB  PHE C 122      -7.891 108.366  21.518  1.00 24.49           C  
ATOM   4726  CG  PHE C 122      -7.265 108.644  20.176  1.00 27.39           C  
ATOM   4727  CD1 PHE C 122      -6.220 107.846  19.707  1.00 26.08           C  
ATOM   4728  CD2 PHE C 122      -7.697 109.717  19.380  1.00 28.40           C  
ATOM   4729  CE1 PHE C 122      -5.638 108.088  18.467  1.00 26.44           C  
ATOM   4730  CE2 PHE C 122      -7.092 109.984  18.148  1.00 29.08           C  
ATOM   4731  CZ  PHE C 122      -6.064 109.164  17.689  1.00 26.77           C  
ATOM   4732  N   ALA C 123     -10.372 107.970  23.708  1.00 24.92           N  
ATOM   4733  CA  ALA C 123     -10.744 107.239  24.937  1.00 24.28           C  
ATOM   4734  C   ALA C 123     -12.006 106.367  24.712  1.00 24.36           C  
ATOM   4735  O   ALA C 123     -11.950 105.141  24.915  1.00 24.26           O  
ATOM   4736  CB  ALA C 123     -10.922 108.194  26.138  1.00 25.66           C  
ATOM   4737  N   PRO C 124     -13.125 106.962  24.235  1.00 25.48           N  
ATOM   4738  CA  PRO C 124     -14.250 106.060  23.945  1.00 25.49           C  
ATOM   4739  C   PRO C 124     -13.946 105.058  22.841  1.00 25.86           C  
ATOM   4740  O   PRO C 124     -14.423 103.931  22.919  1.00 26.56           O  
ATOM   4741  CB  PRO C 124     -15.405 107.017  23.572  1.00 25.00           C  
ATOM   4742  CG  PRO C 124     -14.753 108.258  23.201  1.00 26.30           C  
ATOM   4743  CD  PRO C 124     -13.481 108.369  23.945  1.00 23.85           C  
ATOM   4744  N   LEU C 125     -13.155 105.458  21.845  1.00 26.30           N  
ATOM   4745  CA  LEU C 125     -12.633 104.565  20.807  1.00 25.70           C  
ATOM   4746  C   LEU C 125     -12.053 103.257  21.345  1.00 25.89           C  
ATOM   4747  O   LEU C 125     -12.386 102.157  20.853  1.00 26.33           O  
ATOM   4748  CB  LEU C 125     -11.541 105.263  19.972  1.00 25.65           C  
ATOM   4749  CG  LEU C 125     -10.892 104.446  18.822  1.00 26.68           C  
ATOM   4750  CD1 LEU C 125     -11.953 103.856  17.861  1.00 25.73           C  
ATOM   4751  CD2 LEU C 125      -9.861 105.248  18.019  1.00 23.36           C  
ATOM   4752  N   VAL C 126     -11.209 103.384  22.359  1.00 25.12           N  
ATOM   4753  CA  VAL C 126     -10.495 102.234  22.881  1.00 24.31           C  
ATOM   4754  C   VAL C 126     -11.327 101.548  23.972  1.00 25.04           C  
ATOM   4755  O   VAL C 126     -11.233 100.338  24.189  1.00 24.98           O  
ATOM   4756  CB  VAL C 126      -9.037 102.621  23.250  1.00 24.56           C  
ATOM   4757  CG1 VAL C 126      -8.316 101.489  23.992  1.00 22.95           C  
ATOM   4758  CG2 VAL C 126      -8.272 103.010  21.971  1.00 25.33           C  
ATOM   4759  N   ALA C 127     -12.178 102.332  24.637  1.00 24.11           N  
ATOM   4760  CA  ALA C 127     -13.200 101.792  25.512  1.00 24.22           C  
ATOM   4761  C   ALA C 127     -14.103 100.811  24.766  1.00 24.38           C  
ATOM   4762  O   ALA C 127     -14.439  99.760  25.316  1.00 23.48           O  
ATOM   4763  CB  ALA C 127     -14.059 102.926  26.094  1.00 24.10           C  
ATOM   4764  N   CYS C 128     -14.561 101.187  23.564  1.00 22.47           N  
ATOM   4765  CA  CYS C 128     -15.301 100.264  22.716  1.00 23.87           C  
ATOM   4766  C   CYS C 128     -14.487  98.979  22.483  1.00 23.97           C  
ATOM   4767  O   CYS C 128     -13.289  99.035  22.186  1.00 21.72           O  
ATOM   4768  CB  CYS C 128     -15.639 100.916  21.377  1.00 24.10           C  
ATOM   4769  SG  CYS C 128     -16.978 102.117  21.568  1.00 25.93           S  
ATOM   4770  N   ASP C 129     -15.153  97.827  22.585  1.00 23.83           N  
ATOM   4771  CA  ASP C 129     -14.435  96.574  22.625  1.00 24.63           C  
ATOM   4772  C   ASP C 129     -13.643  96.397  21.337  1.00 24.96           C  
ATOM   4773  O   ASP C 129     -12.415  96.216  21.367  1.00 24.45           O  
ATOM   4774  CB  ASP C 129     -15.390  95.387  22.866  1.00 25.61           C  
ATOM   4775  CG  ASP C 129     -16.077  95.452  24.216  1.00 24.41           C  
ATOM   4776  OD1 ASP C 129     -15.439  95.781  25.248  1.00 26.73           O  
ATOM   4777  OD2 ASP C 129     -17.276  95.114  24.252  1.00 28.09           O  
ATOM   4778  N   LEU C 130     -14.356  96.500  20.212  1.00 23.84           N  
ATOM   4779  CA  LEU C 130     -13.776  96.367  18.855  1.00 24.97           C  
ATOM   4780  C   LEU C 130     -14.004  97.637  18.047  1.00 24.24           C  
ATOM   4781  O   LEU C 130     -14.816  98.492  18.423  1.00 22.98           O  
ATOM   4782  CB  LEU C 130     -14.386  95.174  18.118  1.00 25.20           C  
ATOM   4783  CG  LEU C 130     -14.299  93.877  18.921  1.00 25.62           C  
ATOM   4784  CD1 LEU C 130     -15.295  92.825  18.447  1.00 28.97           C  
ATOM   4785  CD2 LEU C 130     -12.878  93.344  18.885  1.00 28.49           C  
ATOM   4786  N   ALA C 131     -13.276  97.790  16.953  1.00 25.17           N  
ATOM   4787  CA  ALA C 131     -13.465  99.011  16.130  1.00 25.78           C  
ATOM   4788  C   ALA C 131     -13.113  98.761  14.664  1.00 26.29           C  
ATOM   4789  O   ALA C 131     -12.053  98.175  14.381  1.00 25.86           O  
ATOM   4790  CB  ALA C 131     -12.615 100.145  16.709  1.00 25.71           C  
ATOM   4791  N   ILE C 132     -14.025  99.171  13.766  1.00 25.30           N  
ATOM   4792  CA  ILE C 132     -13.828  99.159  12.311  1.00 26.96           C  
ATOM   4793  C   ILE C 132     -13.905 100.614  11.869  1.00 27.64           C  
ATOM   4794  O   ILE C 132     -14.872 101.351  12.224  1.00 26.37           O  
ATOM   4795  CB  ILE C 132     -14.994  98.424  11.534  1.00 26.64           C  
ATOM   4796  CG1 ILE C 132     -15.424  97.094  12.185  1.00 28.33           C  
ATOM   4797  CG2 ILE C 132     -14.605  98.174  10.069  1.00 26.85           C  
ATOM   4798  CD1 ILE C 132     -14.280  96.047  12.305  1.00 30.22           C  
ATOM   4799  N   CYS C 133     -12.905 101.043  11.104  1.00 28.16           N  
ATOM   4800  CA  CYS C 133     -12.920 102.411  10.574  1.00 28.95           C  
ATOM   4801  C   CYS C 133     -12.999 102.416   9.060  1.00 29.89           C  
ATOM   4802  O   CYS C 133     -12.750 101.397   8.413  1.00 29.03           O  
ATOM   4803  CB  CYS C 133     -11.703 103.208  11.037  1.00 28.55           C  
ATOM   4804  SG  CYS C 133     -10.138 102.570  10.449  1.00 27.67           S  
ATOM   4805  N   ALA C 134     -13.347 103.584   8.512  1.00 30.37           N  
ATOM   4806  CA  ALA C 134     -13.314 103.837   7.075  1.00 31.59           C  
ATOM   4807  C   ALA C 134     -11.858 104.085   6.714  1.00 31.47           C  
ATOM   4808  O   ALA C 134     -11.129 104.684   7.501  1.00 31.99           O  
ATOM   4809  CB  ALA C 134     -14.145 105.038   6.751  1.00 31.05           C  
ATOM   4810  N   ASP C 135     -11.430 103.567   5.565  1.00 31.49           N  
ATOM   4811  CA  ASP C 135     -10.095 103.845   5.023  1.00 31.36           C  
ATOM   4812  C   ASP C 135      -9.873 105.356   5.004  1.00 31.01           C  
ATOM   4813  O   ASP C 135      -8.773 105.841   5.254  1.00 29.61           O  
ATOM   4814  CB  ASP C 135      -9.996 103.340   3.587  1.00 31.28           C  
ATOM   4815  CG  ASP C 135      -9.958 101.831   3.482  1.00 33.20           C  
ATOM   4816  OD1 ASP C 135      -9.525 101.156   4.444  1.00 31.60           O  
ATOM   4817  OD2 ASP C 135     -10.351 101.316   2.391  1.00 30.06           O  
ATOM   4818  N   GLU C 136     -10.948 106.078   4.676  1.00 31.07           N  
ATOM   4819  CA  GLU C 136     -10.931 107.523   4.502  1.00 32.02           C  
ATOM   4820  C   GLU C 136     -10.899 108.310   5.834  1.00 32.31           C  
ATOM   4821  O   GLU C 136     -10.770 109.547   5.848  1.00 32.97           O  
ATOM   4822  CB  GLU C 136     -12.128 107.934   3.634  1.00 31.89           C  
ATOM   4823  CG  GLU C 136     -12.107 107.312   2.220  1.00 32.01           C  
ATOM   4824  CD  GLU C 136     -12.959 106.052   2.053  1.00 31.78           C  
ATOM   4825  OE1 GLU C 136     -13.021 105.179   2.943  1.00 33.05           O  
ATOM   4826  OE2 GLU C 136     -13.584 105.940   0.978  1.00 35.19           O  
ATOM   4827  N   ALA C 137     -11.038 107.612   6.952  1.00 32.37           N  
ATOM   4828  CA  ALA C 137     -11.040 108.299   8.252  1.00 32.49           C  
ATOM   4829  C   ALA C 137      -9.643 108.860   8.525  1.00 32.90           C  
ATOM   4830  O   ALA C 137      -8.635 108.244   8.124  1.00 33.35           O  
ATOM   4831  CB  ALA C 137     -11.468 107.344   9.379  1.00 32.28           C  
ATOM   4832  N   THR C 138      -9.585 110.021   9.189  1.00 32.03           N  
ATOM   4833  CA  THR C 138      -8.313 110.616   9.634  1.00 31.27           C  
ATOM   4834  C   THR C 138      -8.307 110.748  11.155  1.00 30.77           C  
ATOM   4835  O   THR C 138      -9.268 111.250  11.752  1.00 31.40           O  
ATOM   4836  CB  THR C 138      -7.999 111.986   8.898  1.00 31.51           C  
ATOM   4837  OG1 THR C 138      -7.684 111.725   7.525  1.00 30.76           O  
ATOM   4838  CG2 THR C 138      -6.788 112.713   9.527  1.00 30.85           C  
ATOM   4839  N   PHE C 139      -7.239 110.267  11.776  1.00 29.79           N  
ATOM   4840  CA  PHE C 139      -7.098 110.287  13.236  1.00 29.61           C  
ATOM   4841  C   PHE C 139      -5.974 111.241  13.590  1.00 29.50           C  
ATOM   4842  O   PHE C 139      -5.048 111.426  12.802  1.00 29.50           O  
ATOM   4843  CB  PHE C 139      -6.687 108.892  13.769  1.00 28.20           C  
ATOM   4844  CG  PHE C 139      -7.665 107.785  13.446  1.00 28.29           C  
ATOM   4845  CD1 PHE C 139      -7.744 107.236  12.151  1.00 27.82           C  
ATOM   4846  CD2 PHE C 139      -8.496 107.281  14.438  1.00 27.39           C  
ATOM   4847  CE1 PHE C 139      -8.659 106.207  11.860  1.00 27.74           C  
ATOM   4848  CE2 PHE C 139      -9.400 106.243  14.164  1.00 28.17           C  
ATOM   4849  CZ  PHE C 139      -9.497 105.713  12.896  1.00 26.43           C  
ATOM   4850  N   GLY C 140      -6.006 111.792  14.791  1.00 29.52           N  
ATOM   4851  CA  GLY C 140      -4.855 112.548  15.259  1.00 30.31           C  
ATOM   4852  C   GLY C 140      -4.914 112.897  16.720  1.00 30.99           C  
ATOM   4853  O   GLY C 140      -5.996 113.058  17.307  1.00 31.33           O  
ATOM   4854  N   LEU C 141      -3.734 112.998  17.307  1.00 31.98           N  
ATOM   4855  CA  LEU C 141      -3.589 113.393  18.710  1.00 32.81           C  
ATOM   4856  C   LEU C 141      -3.057 114.824  18.645  1.00 32.46           C  
ATOM   4857  O   LEU C 141      -1.880 115.102  18.872  1.00 31.46           O  
ATOM   4858  CB  LEU C 141      -2.645 112.439  19.446  1.00 33.03           C  
ATOM   4859  CG  LEU C 141      -3.203 111.042  19.720  1.00 35.12           C  
ATOM   4860  CD1 LEU C 141      -2.261 110.283  20.594  1.00 36.01           C  
ATOM   4861  CD2 LEU C 141      -4.567 111.138  20.416  1.00 36.41           C  
ATOM   4862  N   SER C 142      -3.962 115.718  18.264  1.00 32.80           N  
ATOM   4863  CA  SER C 142      -3.667 117.129  18.049  1.00 33.01           C  
ATOM   4864  C   SER C 142      -3.359 117.887  19.359  1.00 32.64           C  
ATOM   4865  O   SER C 142      -2.756 118.966  19.328  1.00 32.67           O  
ATOM   4866  CB  SER C 142      -4.870 117.770  17.344  1.00 32.87           C  
ATOM   4867  OG  SER C 142      -6.062 117.303  17.975  1.00 33.00           O  
ATOM   4868  N   GLU C 143      -3.714 117.299  20.507  1.00 32.71           N  
ATOM   4869  CA  GLU C 143      -3.482 117.923  21.815  1.00 32.41           C  
ATOM   4870  C   GLU C 143      -2.197 118.740  21.864  1.00 31.79           C  
ATOM   4871  O   GLU C 143      -2.230 119.915  22.219  1.00 32.15           O  
ATOM   4872  CB  GLU C 143      -3.487 116.862  22.928  1.00 31.96           C  
ATOM   4873  CG  GLU C 143      -4.887 116.447  23.315  1.00 34.04           C  
ATOM   4874  CD  GLU C 143      -5.344 115.157  22.647  1.00 36.99           C  
ATOM   4875  OE1 GLU C 143      -4.802 114.809  21.576  1.00 34.53           O  
ATOM   4876  OE2 GLU C 143      -6.263 114.486  23.206  1.00 40.40           O  
ATOM   4877  N   ILE C 144      -1.076 118.115  21.494  1.00 31.76           N  
ATOM   4878  CA  ILE C 144       0.256 118.742  21.591  1.00 31.54           C  
ATOM   4879  C   ILE C 144       0.340 120.091  20.830  1.00 32.44           C  
ATOM   4880  O   ILE C 144       0.955 121.041  21.316  1.00 32.69           O  
ATOM   4881  CB  ILE C 144       1.406 117.766  21.131  1.00 31.47           C  
ATOM   4882  CG1 ILE C 144       2.791 118.407  21.280  1.00 31.37           C  
ATOM   4883  CG2 ILE C 144       1.209 117.320  19.698  1.00 29.56           C  
ATOM   4884  CD1 ILE C 144       3.299 118.498  22.717  1.00 29.70           C  
ATOM   4885  N   ASN C 145      -0.285 120.160  19.659  1.00 32.78           N  
ATOM   4886  CA  ASN C 145      -0.244 121.375  18.833  1.00 34.07           C  
ATOM   4887  C   ASN C 145      -1.180 122.431  19.414  1.00 34.61           C  
ATOM   4888  O   ASN C 145      -1.063 123.630  19.102  1.00 34.69           O  
ATOM   4889  CB  ASN C 145      -0.592 121.060  17.371  1.00 34.15           C  
ATOM   4890  CG  ASN C 145       0.413 120.109  16.711  1.00 34.87           C  
ATOM   4891  OD1 ASN C 145       1.623 120.203  16.934  1.00 35.44           O  
ATOM   4892  ND2 ASN C 145      -0.088 119.199  15.877  1.00 36.25           N  
ATOM   4893  N   TRP C 146      -2.093 121.989  20.280  1.00 34.60           N  
ATOM   4894  CA  TRP C 146      -2.966 122.930  20.979  1.00 35.15           C  
ATOM   4895  C   TRP C 146      -2.380 123.376  22.339  1.00 35.27           C  
ATOM   4896  O   TRP C 146      -2.950 124.245  23.010  1.00 35.84           O  
ATOM   4897  CB  TRP C 146      -4.408 122.384  21.098  1.00 34.75           C  
ATOM   4898  CG  TRP C 146      -5.111 122.278  19.766  0.50 34.73           C  
ATOM   4899  CD1 TRP C 146      -5.686 121.167  19.234  0.50 34.37           C  
ATOM   4900  CD2 TRP C 146      -5.289 123.325  18.797  0.50 34.96           C  
ATOM   4901  NE1 TRP C 146      -6.216 121.450  17.997  0.50 35.06           N  
ATOM   4902  CE2 TRP C 146      -5.984 122.766  17.704  0.50 35.23           C  
ATOM   4903  CE3 TRP C 146      -4.929 124.682  18.750  0.50 35.46           C  
ATOM   4904  CZ2 TRP C 146      -6.337 123.520  16.570  0.50 35.54           C  
ATOM   4905  CZ3 TRP C 146      -5.273 125.431  17.616  0.50 35.33           C  
ATOM   4906  CH2 TRP C 146      -5.969 124.844  16.544  0.50 34.78           C  
ATOM   4907  N   GLY C 147      -1.243 122.794  22.727  1.00 35.14           N  
ATOM   4908  CA  GLY C 147      -0.528 123.190  23.952  1.00 34.03           C  
ATOM   4909  C   GLY C 147      -0.915 122.480  25.246  1.00 33.81           C  
ATOM   4910  O   GLY C 147      -0.684 123.002  26.347  1.00 33.90           O  
ATOM   4911  N   ILE C 148      -1.544 121.313  25.125  1.00 32.91           N  
ATOM   4912  CA  ILE C 148      -1.835 120.477  26.289  1.00 32.14           C  
ATOM   4913  C   ILE C 148      -1.381 119.052  25.981  1.00 31.31           C  
ATOM   4914  O   ILE C 148      -1.417 118.636  24.827  1.00 31.74           O  
ATOM   4915  CB  ILE C 148      -3.337 120.500  26.719  1.00 32.55           C  
ATOM   4916  CG1 ILE C 148      -4.271 120.080  25.571  1.00 34.40           C  
ATOM   4917  CG2 ILE C 148      -3.715 121.871  27.368  1.00 31.88           C  
ATOM   4918  CD1 ILE C 148      -5.504 119.317  26.067  1.00 39.33           C  
ATOM   4919  N   PRO C 149      -0.926 118.313  27.007  1.00 30.82           N  
ATOM   4920  CA  PRO C 149      -0.685 116.903  26.833  1.00 30.12           C  
ATOM   4921  C   PRO C 149      -2.069 116.248  26.648  1.00 30.02           C  
ATOM   4922  O   PRO C 149      -3.093 116.906  26.913  1.00 29.52           O  
ATOM   4923  CB  PRO C 149      -0.059 116.491  28.187  1.00 30.67           C  
ATOM   4924  CG  PRO C 149      -0.612 117.500  29.166  1.00 30.14           C  
ATOM   4925  CD  PRO C 149      -0.642 118.769  28.383  1.00 30.78           C  
ATOM   4926  N   PRO C 150      -2.122 114.990  26.190  1.00 28.81           N  
ATOM   4927  CA  PRO C 150      -3.434 114.347  26.108  1.00 29.12           C  
ATOM   4928  C   PRO C 150      -4.201 114.293  27.436  1.00 29.34           C  
ATOM   4929  O   PRO C 150      -3.638 113.914  28.479  1.00 29.87           O  
ATOM   4930  CB  PRO C 150      -3.100 112.938  25.580  1.00 30.44           C  
ATOM   4931  CG  PRO C 150      -1.805 113.136  24.785  1.00 27.67           C  
ATOM   4932  CD  PRO C 150      -1.046 114.145  25.618  1.00 29.55           C  
ATOM   4933  N   GLY C 151      -5.467 114.710  27.387  1.00 29.00           N  
ATOM   4934  CA  GLY C 151      -6.328 114.814  28.582  1.00 29.20           C  
ATOM   4935  C   GLY C 151      -7.119 113.541  28.778  1.00 28.52           C  
ATOM   4936  O   GLY C 151      -7.166 112.685  27.892  1.00 28.54           O  
ATOM   4937  N   ASN C 152      -7.756 113.423  29.936  1.00 28.58           N  
ATOM   4938  CA  ASN C 152      -8.520 112.231  30.278  1.00 28.57           C  
ATOM   4939  C   ASN C 152      -7.637 110.981  30.086  1.00 27.27           C  
ATOM   4940  O   ASN C 152      -6.466 110.987  30.497  1.00 26.07           O  
ATOM   4941  CB  ASN C 152      -9.836 112.170  29.486  1.00 28.38           C  
ATOM   4942  CG  ASN C 152     -10.946 111.424  30.239  1.00 30.66           C  
ATOM   4943  OD1 ASN C 152     -11.052 110.208  30.141  1.00 34.73           O  
ATOM   4944  ND2 ASN C 152     -11.761 112.151  31.007  1.00 34.05           N  
ATOM   4945  N   LEU C 153      -8.188 109.949  29.439  1.00 26.02           N  
ATOM   4946  CA  LEU C 153      -7.548 108.626  29.351  1.00 25.26           C  
ATOM   4947  C   LEU C 153      -6.928 108.363  27.999  1.00 26.19           C  
ATOM   4948  O   LEU C 153      -6.522 107.253  27.685  1.00 26.65           O  
ATOM   4949  CB  LEU C 153      -8.572 107.571  29.683  1.00 24.53           C  
ATOM   4950  CG  LEU C 153      -8.533 107.179  31.159  1.00 22.32           C  
ATOM   4951  CD1 LEU C 153      -7.295 106.327  31.430  1.00 20.61           C  
ATOM   4952  CD2 LEU C 153      -8.595 108.404  32.123  1.00 23.49           C  
ATOM   4953  N   VAL C 154      -6.812 109.429  27.225  1.00 26.12           N  
ATOM   4954  CA  VAL C 154      -6.294 109.358  25.869  1.00 26.60           C  
ATOM   4955  C   VAL C 154      -4.976 108.597  25.785  1.00 27.92           C  
ATOM   4956  O   VAL C 154      -4.841 107.717  24.913  1.00 27.42           O  
ATOM   4957  CB  VAL C 154      -6.204 110.741  25.241  1.00 27.06           C  
ATOM   4958  CG1 VAL C 154      -5.326 110.734  23.997  1.00 26.35           C  
ATOM   4959  CG2 VAL C 154      -7.626 111.267  24.922  1.00 25.90           C  
ATOM   4960  N   SER C 155      -4.029 108.911  26.678  1.00 27.16           N  
ATOM   4961  CA  SER C 155      -2.683 108.328  26.556  1.00 27.00           C  
ATOM   4962  C   SER C 155      -2.716 106.849  26.922  1.00 26.79           C  
ATOM   4963  O   SER C 155      -1.945 106.066  26.395  1.00 26.99           O  
ATOM   4964  CB  SER C 155      -1.661 109.060  27.424  1.00 27.21           C  
ATOM   4965  OG  SER C 155      -1.337 110.327  26.875  1.00 26.27           O  
ATOM   4966  N   LYS C 156      -3.636 106.480  27.816  1.00 26.26           N  
ATOM   4967  CA  LYS C 156      -3.794 105.077  28.239  1.00 25.34           C  
ATOM   4968  C   LYS C 156      -4.472 104.296  27.102  1.00 25.12           C  
ATOM   4969  O   LYS C 156      -4.125 103.145  26.846  1.00 24.77           O  
ATOM   4970  CB  LYS C 156      -4.576 105.020  29.562  1.00 25.12           C  
ATOM   4971  CG  LYS C 156      -4.684 103.667  30.221  1.00 23.96           C  
ATOM   4972  CD  LYS C 156      -3.338 102.900  30.279  1.00 20.36           C  
ATOM   4973  CE  LYS C 156      -3.508 101.503  30.904  1.00 20.32           C  
ATOM   4974  NZ  LYS C 156      -2.203 100.906  31.241  1.00 22.34           N  
ATOM   4975  N   ALA C 157      -5.390 104.954  26.390  1.00 24.16           N  
ATOM   4976  CA  ALA C 157      -6.096 104.365  25.272  1.00 23.92           C  
ATOM   4977  C   ALA C 157      -5.027 103.968  24.219  1.00 24.49           C  
ATOM   4978  O   ALA C 157      -5.058 102.864  23.722  1.00 25.08           O  
ATOM   4979  CB  ALA C 157      -7.201 105.326  24.704  1.00 22.11           C  
ATOM   4980  N   MET C 158      -4.039 104.832  23.982  1.00 25.07           N  
ATOM   4981  CA  MET C 158      -2.954 104.529  23.046  1.00 25.29           C  
ATOM   4982  C   MET C 158      -2.098 103.390  23.595  1.00 25.85           C  
ATOM   4983  O   MET C 158      -1.782 102.411  22.881  1.00 26.14           O  
ATOM   4984  CB  MET C 158      -2.083 105.770  22.809  1.00 24.90           C  
ATOM   4985  CG  MET C 158      -2.761 106.846  21.914  1.00 29.12           C  
ATOM   4986  SD  MET C 158      -3.032 106.253  20.222  1.00 30.86           S  
ATOM   4987  CE  MET C 158      -1.383 106.370  19.480  1.00 28.59           C  
ATOM   4988  N   ALA C 159      -1.723 103.520  24.863  1.00 25.81           N  
ATOM   4989  CA  ALA C 159      -0.881 102.514  25.506  1.00 24.70           C  
ATOM   4990  C   ALA C 159      -1.454 101.112  25.296  1.00 24.69           C  
ATOM   4991  O   ALA C 159      -0.705 100.159  25.080  1.00 23.88           O  
ATOM   4992  CB  ALA C 159      -0.691 102.829  26.976  1.00 25.31           C  
ATOM   4993  N   ASP C 160      -2.781 100.991  25.388  1.00 25.63           N  
ATOM   4994  CA  ASP C 160      -3.464  99.699  25.380  1.00 26.10           C  
ATOM   4995  C   ASP C 160      -3.424  99.054  23.983  1.00 26.49           C  
ATOM   4996  O   ASP C 160      -3.485  97.830  23.845  1.00 28.04           O  
ATOM   4997  CB  ASP C 160      -4.936  99.857  25.836  1.00 24.83           C  
ATOM   4998  CG  ASP C 160      -5.126  99.750  27.395  1.00 24.57           C  
ATOM   4999  OD1 ASP C 160      -4.148  99.523  28.165  1.00 24.00           O  
ATOM   5000  OD2 ASP C 160      -6.297  99.855  27.844  1.00 25.22           O  
ATOM   5001  N   THR C 161      -3.330  99.872  22.949  1.00 26.37           N  
ATOM   5002  CA  THR C 161      -3.628  99.402  21.589  1.00 26.11           C  
ATOM   5003  C   THR C 161      -2.510  99.622  20.585  1.00 26.90           C  
ATOM   5004  O   THR C 161      -2.487  98.962  19.510  1.00 26.64           O  
ATOM   5005  CB  THR C 161      -4.906 100.098  20.968  1.00 25.36           C  
ATOM   5006  OG1 THR C 161      -4.793 101.534  21.018  1.00 24.86           O  
ATOM   5007  CG2 THR C 161      -6.202  99.663  21.658  1.00 23.07           C  
ATOM   5008  N   VAL C 162      -1.625 100.573  20.886  1.00 26.21           N  
ATOM   5009  CA  VAL C 162      -0.613 100.999  19.923  1.00 25.58           C  
ATOM   5010  C   VAL C 162       0.786 100.899  20.560  1.00 25.05           C  
ATOM   5011  O   VAL C 162       0.985 101.325  21.711  1.00 25.13           O  
ATOM   5012  CB  VAL C 162      -0.884 102.435  19.432  1.00 26.27           C  
ATOM   5013  CG1 VAL C 162       0.268 102.908  18.606  1.00 25.12           C  
ATOM   5014  CG2 VAL C 162      -2.200 102.511  18.641  1.00 24.37           C  
ATOM   5015  N   GLY C 163       1.737 100.337  19.802  1.00 24.14           N  
ATOM   5016  CA  GLY C 163       3.105 100.115  20.279  1.00 24.94           C  
ATOM   5017  C   GLY C 163       3.694 101.355  20.894  1.00 24.94           C  
ATOM   5018  O   GLY C 163       3.310 102.471  20.532  1.00 24.80           O  
ATOM   5019  N   HIS C 164       4.665 101.153  21.781  1.00 24.92           N  
ATOM   5020  CA  HIS C 164       5.340 102.208  22.528  1.00 25.72           C  
ATOM   5021  C   HIS C 164       5.889 103.315  21.596  1.00 26.43           C  
ATOM   5022  O   HIS C 164       5.572 104.517  21.756  1.00 26.36           O  
ATOM   5023  CB  HIS C 164       6.449 101.543  23.327  1.00 23.99           C  
ATOM   5024  CG  HIS C 164       7.312 102.468  24.126  1.00 23.91           C  
ATOM   5025  ND1 HIS C 164       7.080 102.744  25.455  1.00 21.25           N  
ATOM   5026  CD2 HIS C 164       8.436 103.144  23.795  1.00 22.27           C  
ATOM   5027  CE1 HIS C 164       8.029 103.541  25.915  1.00 25.13           C  
ATOM   5028  NE2 HIS C 164       8.858 103.812  24.923  1.00 28.61           N  
ATOM   5029  N   ARG C 165       6.701 102.904  20.622  1.00 26.68           N  
ATOM   5030  CA  ARG C 165       7.349 103.855  19.723  1.00 26.59           C  
ATOM   5031  C   ARG C 165       6.365 104.672  18.912  1.00 27.48           C  
ATOM   5032  O   ARG C 165       6.499 105.911  18.839  1.00 27.54           O  
ATOM   5033  CB  ARG C 165       8.301 103.151  18.756  1.00 26.63           C  
ATOM   5034  CG  ARG C 165       9.519 102.570  19.407  1.00 25.85           C  
ATOM   5035  CD  ARG C 165      10.468 103.611  20.001  1.00 27.18           C  
ATOM   5036  NE  ARG C 165      11.792 103.037  20.213  1.00 28.27           N  
ATOM   5037  CZ  ARG C 165      12.797 103.619  20.860  1.00 28.22           C  
ATOM   5038  NH1 ARG C 165      12.647 104.837  21.392  1.00 28.22           N  
ATOM   5039  NH2 ARG C 165      13.957 102.981  20.985  1.00 25.39           N  
ATOM   5040  N   GLN C 166       5.390 103.993  18.310  1.00 26.68           N  
ATOM   5041  CA  GLN C 166       4.368 104.666  17.496  1.00 27.39           C  
ATOM   5042  C   GLN C 166       3.453 105.561  18.357  1.00 26.40           C  
ATOM   5043  O   GLN C 166       3.066 106.661  17.939  1.00 25.43           O  
ATOM   5044  CB  GLN C 166       3.542 103.639  16.729  1.00 27.14           C  
ATOM   5045  CG  GLN C 166       4.224 103.012  15.496  1.00 28.72           C  
ATOM   5046  CD  GLN C 166       3.430 101.828  14.945  1.00 30.16           C  
ATOM   5047  OE1 GLN C 166       3.120 100.853  15.667  1.00 34.69           O  
ATOM   5048  NE2 GLN C 166       3.117 101.893  13.669  1.00 34.50           N  
ATOM   5049  N   SER C 167       3.139 105.109  19.578  1.00 26.02           N  
ATOM   5050  CA  SER C 167       2.339 105.903  20.504  1.00 26.09           C  
ATOM   5051  C   SER C 167       3.029 107.241  20.802  1.00 26.98           C  
ATOM   5052  O   SER C 167       2.418 108.301  20.638  1.00 27.09           O  
ATOM   5053  CB  SER C 167       2.071 105.159  21.816  1.00 25.99           C  
ATOM   5054  OG  SER C 167       1.032 104.216  21.673  1.00 24.27           O  
ATOM   5055  N   LEU C 168       4.285 107.174  21.246  1.00 26.12           N  
ATOM   5056  CA  LEU C 168       5.108 108.345  21.473  1.00 25.76           C  
ATOM   5057  C   LEU C 168       5.215 109.240  20.249  1.00 26.31           C  
ATOM   5058  O   LEU C 168       5.034 110.462  20.332  1.00 26.62           O  
ATOM   5059  CB  LEU C 168       6.484 107.913  21.963  1.00 25.82           C  
ATOM   5060  CG  LEU C 168       6.417 107.631  23.478  1.00 22.87           C  
ATOM   5061  CD1 LEU C 168       7.611 106.769  23.908  1.00 23.73           C  
ATOM   5062  CD2 LEU C 168       6.329 108.917  24.351  1.00 25.68           C  
ATOM   5063  N   TYR C 169       5.495 108.640  19.107  1.00 26.59           N  
ATOM   5064  CA  TYR C 169       5.548 109.414  17.869  1.00 26.80           C  
ATOM   5065  C   TYR C 169       4.305 110.301  17.626  1.00 27.01           C  
ATOM   5066  O   TYR C 169       4.439 111.522  17.399  1.00 26.80           O  
ATOM   5067  CB  TYR C 169       5.814 108.500  16.675  1.00 28.25           C  
ATOM   5068  CG  TYR C 169       5.965 109.253  15.356  1.00 29.87           C  
ATOM   5069  CD1 TYR C 169       4.878 109.445  14.508  1.00 30.83           C  
ATOM   5070  CD2 TYR C 169       7.202 109.792  14.972  1.00 28.98           C  
ATOM   5071  CE1 TYR C 169       5.020 110.136  13.301  1.00 31.49           C  
ATOM   5072  CE2 TYR C 169       7.346 110.495  13.760  1.00 29.88           C  
ATOM   5073  CZ  TYR C 169       6.260 110.666  12.945  1.00 30.43           C  
ATOM   5074  OH  TYR C 169       6.418 111.360  11.745  1.00 34.01           O  
ATOM   5075  N   TYR C 170       3.119 109.694  17.637  1.00 26.92           N  
ATOM   5076  CA  TYR C 170       1.878 110.401  17.364  1.00 27.29           C  
ATOM   5077  C   TYR C 170       1.446 111.342  18.482  1.00 26.91           C  
ATOM   5078  O   TYR C 170       0.882 112.382  18.202  1.00 27.15           O  
ATOM   5079  CB  TYR C 170       0.740 109.429  16.964  1.00 28.28           C  
ATOM   5080  CG  TYR C 170       0.997 108.785  15.621  1.00 28.79           C  
ATOM   5081  CD1 TYR C 170       1.001 109.552  14.432  1.00 27.76           C  
ATOM   5082  CD2 TYR C 170       1.268 107.432  15.530  1.00 27.72           C  
ATOM   5083  CE1 TYR C 170       1.280 108.974  13.228  1.00 29.20           C  
ATOM   5084  CE2 TYR C 170       1.548 106.846  14.329  1.00 29.53           C  
ATOM   5085  CZ  TYR C 170       1.556 107.621  13.175  1.00 30.89           C  
ATOM   5086  OH  TYR C 170       1.820 106.994  11.980  1.00 31.82           O  
ATOM   5087  N   ILE C 171       1.723 110.984  19.745  1.00 27.34           N  
ATOM   5088  CA  ILE C 171       1.492 111.913  20.856  1.00 26.60           C  
ATOM   5089  C   ILE C 171       2.411 113.138  20.753  1.00 27.27           C  
ATOM   5090  O   ILE C 171       1.944 114.302  20.855  1.00 27.21           O  
ATOM   5091  CB  ILE C 171       1.702 111.210  22.210  1.00 25.81           C  
ATOM   5092  CG1 ILE C 171       0.551 110.232  22.451  1.00 26.85           C  
ATOM   5093  CG2 ILE C 171       1.730 112.217  23.345  1.00 26.52           C  
ATOM   5094  CD1 ILE C 171       0.736 109.311  23.647  1.00 26.34           C  
ATOM   5095  N   MET C 172       3.698 112.876  20.499  1.00 27.46           N  
ATOM   5096  CA  MET C 172       4.732 113.914  20.520  1.00 27.57           C  
ATOM   5097  C   MET C 172       4.661 114.885  19.333  1.00 27.64           C  
ATOM   5098  O   MET C 172       4.827 116.095  19.531  1.00 27.89           O  
ATOM   5099  CB  MET C 172       6.139 113.328  20.637  1.00 27.00           C  
ATOM   5100  CG  MET C 172       6.468 112.786  22.057  1.00 28.37           C  
ATOM   5101  SD  MET C 172       8.044 111.874  22.253  1.00 30.24           S  
ATOM   5102  CE  MET C 172       9.268 113.185  22.272  1.00 26.49           C  
ATOM   5103  N   THR C 173       4.421 114.350  18.134  1.00 27.46           N  
ATOM   5104  CA  THR C 173       4.385 115.153  16.897  1.00 26.63           C  
ATOM   5105  C   THR C 173       2.990 115.700  16.578  1.00 27.27           C  
ATOM   5106  O   THR C 173       2.856 116.734  15.907  1.00 27.04           O  
ATOM   5107  CB  THR C 173       4.869 114.346  15.654  1.00 26.43           C  
ATOM   5108  OG1 THR C 173       3.932 113.309  15.341  1.00 26.62           O  
ATOM   5109  CG2 THR C 173       6.210 113.769  15.842  1.00 26.23           C  
ATOM   5110  N   GLY C 174       1.952 115.009  17.042  1.00 27.25           N  
ATOM   5111  CA  GLY C 174       0.564 115.336  16.714  1.00 27.08           C  
ATOM   5112  C   GLY C 174       0.204 115.090  15.237  1.00 27.74           C  
ATOM   5113  O   GLY C 174      -0.791 115.618  14.755  1.00 28.18           O  
ATOM   5114  N   LYS C 175       0.977 114.276  14.521  1.00 28.62           N  
ATOM   5115  CA  LYS C 175       0.684 114.018  13.097  1.00 30.22           C  
ATOM   5116  C   LYS C 175      -0.536 113.118  12.950  1.00 29.77           C  
ATOM   5117  O   LYS C 175      -0.778 112.255  13.800  1.00 30.66           O  
ATOM   5118  CB  LYS C 175       1.890 113.397  12.394  1.00 30.80           C  
ATOM   5119  CG  LYS C 175       3.140 114.245  12.561  1.00 34.07           C  
ATOM   5120  CD  LYS C 175       4.269 113.848  11.616  1.00 40.71           C  
ATOM   5121  CE  LYS C 175       5.345 114.927  11.617  1.00 42.52           C  
ATOM   5122  NZ  LYS C 175       4.843 116.121  10.888  1.00 45.09           N  
ATOM   5123  N   THR C 176      -1.297 113.342  11.879  1.00 29.52           N  
ATOM   5124  CA  THR C 176      -2.529 112.615  11.590  1.00 27.74           C  
ATOM   5125  C   THR C 176      -2.164 111.335  10.851  1.00 27.97           C  
ATOM   5126  O   THR C 176      -1.046 111.201  10.365  1.00 26.70           O  
ATOM   5127  CB  THR C 176      -3.479 113.460  10.704  1.00 29.16           C  
ATOM   5128  OG1 THR C 176      -2.771 113.874   9.538  1.00 26.02           O  
ATOM   5129  CG2 THR C 176      -3.981 114.712  11.437  1.00 25.85           C  
ATOM   5130  N   PHE C 177      -3.088 110.375  10.826  1.00 27.70           N  
ATOM   5131  CA  PHE C 177      -2.912 109.117  10.094  1.00 27.64           C  
ATOM   5132  C   PHE C 177      -4.255 108.601   9.601  1.00 27.33           C  
ATOM   5133  O   PHE C 177      -5.292 108.978  10.144  1.00 27.60           O  
ATOM   5134  CB  PHE C 177      -2.167 108.044  10.942  1.00 27.22           C  
ATOM   5135  CG  PHE C 177      -2.689 107.862  12.361  1.00 27.95           C  
ATOM   5136  CD1 PHE C 177      -2.220 108.679  13.404  1.00 26.78           C  
ATOM   5137  CD2 PHE C 177      -3.624 106.857  12.659  1.00 26.51           C  
ATOM   5138  CE1 PHE C 177      -2.664 108.500  14.742  1.00 28.55           C  
ATOM   5139  CE2 PHE C 177      -4.069 106.663  13.996  1.00 29.04           C  
ATOM   5140  CZ  PHE C 177      -3.586 107.489  15.022  1.00 28.26           C  
ATOM   5141  N   GLY C 178      -4.244 107.742   8.584  1.00 27.38           N  
ATOM   5142  CA  GLY C 178      -5.483 107.269   7.970  1.00 28.06           C  
ATOM   5143  C   GLY C 178      -5.930 105.941   8.545  1.00 28.67           C  
ATOM   5144  O   GLY C 178      -5.212 105.338   9.357  1.00 29.37           O  
ATOM   5145  N   GLY C 179      -7.114 105.484   8.136  1.00 28.84           N  
ATOM   5146  CA  GLY C 179      -7.693 104.254   8.700  1.00 29.76           C  
ATOM   5147  C   GLY C 179      -6.814 103.017   8.505  1.00 30.22           C  
ATOM   5148  O   GLY C 179      -6.691 102.193   9.400  1.00 28.53           O  
ATOM   5149  N   GLN C 180      -6.232 102.870   7.313  1.00 30.61           N  
ATOM   5150  CA  GLN C 180      -5.314 101.746   7.036  1.00 31.23           C  
ATOM   5151  C   GLN C 180      -4.158 101.729   8.025  1.00 30.58           C  
ATOM   5152  O   GLN C 180      -3.846 100.678   8.592  1.00 30.29           O  
ATOM   5153  CB  GLN C 180      -4.766 101.791   5.593  1.00 31.75           C  
ATOM   5154  CG  GLN C 180      -5.755 101.257   4.521  1.00 35.30           C  
ATOM   5155  CD  GLN C 180      -6.147  99.785   4.745  1.00 39.04           C  
ATOM   5156  OE1 GLN C 180      -5.334  98.987   5.227  1.00 39.40           O  
ATOM   5157  NE2 GLN C 180      -7.398  99.432   4.407  1.00 37.84           N  
ATOM   5158  N   LYS C 181      -3.559 102.901   8.267  1.00 30.16           N  
ATOM   5159  CA  LYS C 181      -2.438 103.003   9.210  1.00 30.01           C  
ATOM   5160  C   LYS C 181      -2.912 102.817  10.664  1.00 29.88           C  
ATOM   5161  O   LYS C 181      -2.150 102.345  11.499  1.00 29.70           O  
ATOM   5162  CB  LYS C 181      -1.675 104.312   9.036  1.00 29.31           C  
ATOM   5163  N   ALA C 182      -4.173 103.164  10.947  1.00 30.08           N  
ATOM   5164  CA  ALA C 182      -4.780 102.903  12.266  1.00 29.57           C  
ATOM   5165  C   ALA C 182      -4.971 101.397  12.497  1.00 29.39           C  
ATOM   5166  O   ALA C 182      -4.788 100.909  13.617  1.00 30.24           O  
ATOM   5167  CB  ALA C 182      -6.118 103.616  12.390  1.00 29.64           C  
ATOM   5168  N   ALA C 183      -5.365 100.678  11.445  1.00 29.53           N  
ATOM   5169  CA  ALA C 183      -5.520  99.213  11.495  1.00 29.18           C  
ATOM   5170  C   ALA C 183      -4.166  98.596  11.707  1.00 29.57           C  
ATOM   5171  O   ALA C 183      -3.982  97.707  12.555  1.00 30.34           O  
ATOM   5172  CB  ALA C 183      -6.147  98.683  10.221  1.00 28.57           C  
ATOM   5173  N   GLU C 184      -3.201  99.136  10.984  1.00 28.63           N  
ATOM   5174  CA  GLU C 184      -1.845  98.636  10.983  1.00 29.41           C  
ATOM   5175  C   GLU C 184      -1.274  98.733  12.378  1.00 28.72           C  
ATOM   5176  O   GLU C 184      -0.696  97.773  12.901  1.00 28.86           O  
ATOM   5177  CB  GLU C 184      -1.022  99.478   9.991  1.00 28.89           C  
ATOM   5178  CG  GLU C 184       0.464  99.101   9.797  1.00 31.78           C  
ATOM   5179  CD  GLU C 184       1.188 100.124   8.916  0.50 31.06           C  
ATOM   5180  OE1 GLU C 184       0.536 100.713   8.015  0.50 31.49           O  
ATOM   5181  OE2 GLU C 184       2.405 100.333   9.116  0.50 32.61           O  
ATOM   5182  N   MET C 185      -1.456  99.881  13.014  1.00 28.45           N  
ATOM   5183  CA  MET C 185      -0.779 100.106  14.300  1.00 28.84           C  
ATOM   5184  C   MET C 185      -1.487  99.434  15.489  1.00 26.88           C  
ATOM   5185  O   MET C 185      -0.956  99.391  16.606  1.00 24.21           O  
ATOM   5186  CB  MET C 185      -0.519 101.596  14.528  1.00 28.85           C  
ATOM   5187  CG  MET C 185      -1.745 102.404  14.895  1.00 31.53           C  
ATOM   5188  SD  MET C 185      -1.464 104.212  15.020  1.00 35.51           S  
ATOM   5189  CE  MET C 185      -1.030 104.646  13.350  1.00 31.46           C  
ATOM   5190  N   GLY C 186      -2.682  98.910  15.248  1.00 26.03           N  
ATOM   5191  CA  GLY C 186      -3.426  98.194  16.284  1.00 25.42           C  
ATOM   5192  C   GLY C 186      -4.491  99.065  16.951  1.00 25.42           C  
ATOM   5193  O   GLY C 186      -5.253  98.580  17.782  1.00 24.35           O  
ATOM   5194  N   LEU C 187      -4.549 100.352  16.615  1.00 25.46           N  
ATOM   5195  CA  LEU C 187      -5.625 101.193  17.142  1.00 25.54           C  
ATOM   5196  C   LEU C 187      -7.042 100.664  16.903  1.00 26.67           C  
ATOM   5197  O   LEU C 187      -7.903 100.746  17.807  1.00 27.45           O  
ATOM   5198  CB  LEU C 187      -5.502 102.645  16.705  1.00 25.80           C  
ATOM   5199  CG  LEU C 187      -6.467 103.678  17.318  1.00 25.50           C  
ATOM   5200  CD1 LEU C 187      -6.270 103.813  18.868  1.00 27.17           C  
ATOM   5201  CD2 LEU C 187      -6.253 105.028  16.600  1.00 25.04           C  
ATOM   5202  N   VAL C 188      -7.304 100.156  15.699  1.00 25.80           N  
ATOM   5203  CA  VAL C 188      -8.623  99.570  15.383  1.00 26.05           C  
ATOM   5204  C   VAL C 188      -8.437  98.121  14.917  1.00 26.13           C  
ATOM   5205  O   VAL C 188      -7.308  97.710  14.672  1.00 25.77           O  
ATOM   5206  CB  VAL C 188      -9.405 100.400  14.311  1.00 26.72           C  
ATOM   5207  CG1 VAL C 188      -9.767 101.815  14.861  1.00 24.12           C  
ATOM   5208  CG2 VAL C 188      -8.618 100.492  13.002  1.00 27.27           C  
ATOM   5209  N   ASN C 189      -9.517  97.344  14.838  1.00 25.89           N  
ATOM   5210  CA  ASN C 189      -9.442  95.995  14.268  1.00 26.77           C  
ATOM   5211  C   ASN C 189      -9.209  95.967  12.768  1.00 27.09           C  
ATOM   5212  O   ASN C 189      -8.387  95.207  12.278  1.00 25.84           O  
ATOM   5213  CB  ASN C 189     -10.700  95.166  14.573  1.00 27.11           C  
ATOM   5214  CG  ASN C 189     -10.827  94.845  16.012  1.00 25.68           C  
ATOM   5215  OD1 ASN C 189     -11.371  95.645  16.788  1.00 24.97           O  
ATOM   5216  ND2 ASN C 189     -10.274  93.674  16.417  1.00 23.00           N  
ATOM   5217  N   GLU C 190      -9.930  96.800  12.028  1.00 27.96           N  
ATOM   5218  CA  GLU C 190      -9.913  96.759  10.557  1.00 29.39           C  
ATOM   5219  C   GLU C 190     -10.250  98.141  10.030  1.00 28.12           C  
ATOM   5220  O   GLU C 190     -10.954  98.938  10.693  1.00 27.52           O  
ATOM   5221  CB  GLU C 190     -11.047  95.897   9.986  1.00 29.60           C  
ATOM   5222  CG  GLU C 190     -11.164  94.429  10.337  1.00 33.99           C  
ATOM   5223  CD  GLU C 190     -12.364  93.842   9.598  1.00 34.80           C  
ATOM   5224  OE1 GLU C 190     -12.291  93.780   8.348  1.00 42.35           O  
ATOM   5225  OE2 GLU C 190     -13.399  93.525  10.243  1.00 40.83           O  
ATOM   5226  N   SER C 191      -9.819  98.380   8.802  1.00 26.71           N  
ATOM   5227  CA  SER C 191     -10.177  99.556   8.074  1.00 26.05           C  
ATOM   5228  C   SER C 191     -10.646  99.007   6.698  1.00 26.32           C  
ATOM   5229  O   SER C 191     -10.001  98.111   6.133  1.00 24.49           O  
ATOM   5230  CB  SER C 191      -8.949 100.442   7.926  1.00 25.07           C  
ATOM   5231  OG  SER C 191      -9.218 101.609   7.189  1.00 29.42           O  
ATOM   5232  N   VAL C 192     -11.783  99.522   6.229  1.00 27.14           N  
ATOM   5233  CA  VAL C 192     -12.431  99.129   4.953  1.00 27.08           C  
ATOM   5234  C   VAL C 192     -12.967 100.418   4.316  1.00 27.85           C  
ATOM   5235  O   VAL C 192     -13.144 101.413   5.022  1.00 28.15           O  
ATOM   5236  CB  VAL C 192     -13.595  98.091   5.208  1.00 27.69           C  
ATOM   5237  CG1 VAL C 192     -13.084  96.845   5.976  1.00 27.64           C  
ATOM   5238  CG2 VAL C 192     -14.760  98.723   5.981  1.00 25.71           C  
ATOM   5239  N   PRO C 193     -13.216 100.417   2.983  1.00 28.91           N  
ATOM   5240  CA  PRO C 193     -13.753 101.622   2.317  1.00 28.98           C  
ATOM   5241  C   PRO C 193     -15.047 102.105   2.984  1.00 29.44           C  
ATOM   5242  O   PRO C 193     -15.878 101.281   3.384  1.00 29.20           O  
ATOM   5243  CB  PRO C 193     -14.010 101.138   0.880  1.00 29.70           C  
ATOM   5244  CG  PRO C 193     -13.005  99.984   0.676  1.00 29.25           C  
ATOM   5245  CD  PRO C 193     -13.004  99.302   2.033  1.00 28.04           C  
ATOM   5246  N   LEU C 194     -15.209 103.420   3.122  1.00 29.43           N  
ATOM   5247  CA  LEU C 194     -16.397 103.962   3.777  1.00 30.09           C  
ATOM   5248  C   LEU C 194     -17.673 103.319   3.220  1.00 30.97           C  
ATOM   5249  O   LEU C 194     -18.614 103.036   3.982  1.00 33.05           O  
ATOM   5250  CB  LEU C 194     -16.459 105.496   3.666  1.00 29.19           C  
ATOM   5251  CG  LEU C 194     -17.638 106.242   4.330  1.00 28.86           C  
ATOM   5252  CD1 LEU C 194     -17.683 106.107   5.881  1.00 25.71           C  
ATOM   5253  CD2 LEU C 194     -17.659 107.699   3.936  1.00 25.09           C  
ATOM   5254  N   ALA C 195     -17.698 103.071   1.914  1.00 31.36           N  
ATOM   5255  CA  ALA C 195     -18.882 102.513   1.256  1.00 30.48           C  
ATOM   5256  C   ALA C 195     -19.262 101.141   1.835  1.00 30.23           C  
ATOM   5257  O   ALA C 195     -20.433 100.765   1.832  1.00 29.34           O  
ATOM   5258  CB  ALA C 195     -18.680 102.443  -0.259  1.00 30.79           C  
ATOM   5259  N   GLN C 196     -18.281 100.413   2.376  1.00 29.61           N  
ATOM   5260  CA  GLN C 196     -18.551  99.108   2.986  1.00 29.16           C  
ATOM   5261  C   GLN C 196     -18.503  99.096   4.542  1.00 29.68           C  
ATOM   5262  O   GLN C 196     -18.778  98.062   5.176  1.00 27.67           O  
ATOM   5263  CB  GLN C 196     -17.627  98.040   2.387  1.00 30.02           C  
ATOM   5264  N   LEU C 197     -18.227 100.261   5.133  1.00 28.80           N  
ATOM   5265  CA  LEU C 197     -18.050 100.366   6.577  1.00 29.23           C  
ATOM   5266  C   LEU C 197     -19.309  99.863   7.273  1.00 29.04           C  
ATOM   5267  O   LEU C 197     -19.204  99.010   8.124  1.00 28.66           O  
ATOM   5268  CB  LEU C 197     -17.705 101.802   7.005  1.00 28.93           C  
ATOM   5269  CG  LEU C 197     -17.384 102.006   8.499  1.00 29.70           C  
ATOM   5270  CD1 LEU C 197     -16.289 101.075   8.954  1.00 28.15           C  
ATOM   5271  CD2 LEU C 197     -16.969 103.433   8.775  1.00 30.03           C  
ATOM   5272  N   ARG C 198     -20.500 100.350   6.896  1.00 28.69           N  
ATOM   5273  CA  ARG C 198     -21.684  99.880   7.616  1.00 30.00           C  
ATOM   5274  C   ARG C 198     -21.939  98.355   7.516  1.00 29.87           C  
ATOM   5275  O   ARG C 198     -22.204  97.694   8.540  1.00 30.22           O  
ATOM   5276  CB  ARG C 198     -22.919 100.743   7.325  1.00 29.41           C  
ATOM   5277  CG  ARG C 198     -24.221 100.276   7.970  1.00 30.02           C  
ATOM   5278  CD  ARG C 198     -25.364 101.240   7.549  1.00 31.68           C  
ATOM   5279  NE  ARG C 198     -26.690 100.808   8.016  1.00 35.71           N  
ATOM   5280  CZ  ARG C 198     -27.294 101.253   9.118  1.00 37.10           C  
ATOM   5281  NH1 ARG C 198     -26.689 102.161   9.901  1.00 37.70           N  
ATOM   5282  NH2 ARG C 198     -28.508 100.789   9.447  1.00 36.64           N  
ATOM   5283  N   GLU C 199     -21.787  97.787   6.314  1.00 30.30           N  
ATOM   5284  CA  GLU C 199     -22.058  96.352   6.128  1.00 30.39           C  
ATOM   5285  C   GLU C 199     -21.043  95.483   6.869  1.00 29.00           C  
ATOM   5286  O   GLU C 199     -21.416  94.485   7.472  1.00 28.43           O  
ATOM   5287  CB  GLU C 199     -22.180  95.959   4.645  1.00 30.00           C  
ATOM   5288  CG  GLU C 199     -20.848  95.834   3.915  1.00 31.55           C  
ATOM   5289  CD  GLU C 199     -20.998  95.763   2.403  1.00 32.93           C  
ATOM   5290  OE1 GLU C 199     -21.983  96.334   1.876  1.00 34.53           O  
ATOM   5291  OE2 GLU C 199     -20.109  95.152   1.769  1.00 36.81           O  
ATOM   5292  N   VAL C 200     -19.778  95.886   6.841  1.00 28.35           N  
ATOM   5293  CA  VAL C 200     -18.718  95.163   7.552  1.00 27.96           C  
ATOM   5294  C   VAL C 200     -18.997  95.174   9.076  1.00 28.19           C  
ATOM   5295  O   VAL C 200     -18.883  94.141   9.747  1.00 28.87           O  
ATOM   5296  CB  VAL C 200     -17.304  95.740   7.227  1.00 27.34           C  
ATOM   5297  CG1 VAL C 200     -16.230  95.056   8.045  1.00 28.31           C  
ATOM   5298  CG2 VAL C 200     -16.969  95.631   5.701  1.00 27.39           C  
ATOM   5299  N   THR C 201     -19.395  96.337   9.617  1.00 27.78           N  
ATOM   5300  CA  THR C 201     -19.662  96.468  11.064  1.00 27.64           C  
ATOM   5301  C   THR C 201     -20.867  95.625  11.481  1.00 28.06           C  
ATOM   5302  O   THR C 201     -20.833  94.964  12.536  1.00 27.70           O  
ATOM   5303  CB  THR C 201     -19.874  97.944  11.458  1.00 27.55           C  
ATOM   5304  OG1 THR C 201     -18.718  98.704  11.060  1.00 27.95           O  
ATOM   5305  CG2 THR C 201     -20.133  98.107  13.008  1.00 27.11           C  
ATOM   5306  N   ILE C 202     -21.904  95.619  10.630  1.00 28.06           N  
ATOM   5307  CA  ILE C 202     -23.114  94.863  10.900  1.00 28.19           C  
ATOM   5308  C   ILE C 202     -22.919  93.337  10.872  1.00 27.97           C  
ATOM   5309  O   ILE C 202     -23.508  92.626  11.701  1.00 27.11           O  
ATOM   5310  CB  ILE C 202     -24.271  95.296   9.978  1.00 28.26           C  
ATOM   5311  CG1 ILE C 202     -24.727  96.704  10.364  1.00 28.58           C  
ATOM   5312  CG2 ILE C 202     -25.420  94.278  10.016  1.00 30.09           C  
ATOM   5313  CD1 ILE C 202     -25.953  97.245   9.595  1.00 28.83           C  
ATOM   5314  N   GLU C 203     -22.127  92.831   9.927  1.00 27.29           N  
ATOM   5315  CA  GLU C 203     -21.787  91.408   9.933  1.00 27.40           C  
ATOM   5316  C   GLU C 203     -21.051  91.034  11.226  1.00 27.40           C  
ATOM   5317  O   GLU C 203     -21.378  90.010  11.843  1.00 27.98           O  
ATOM   5318  CB  GLU C 203     -20.975  90.988   8.686  1.00 27.38           C  
ATOM   5319  N   LEU C 204     -20.074  91.848  11.639  1.00 26.89           N  
ATOM   5320  CA  LEU C 204     -19.426  91.648  12.962  1.00 26.86           C  
ATOM   5321  C   LEU C 204     -20.435  91.674  14.133  1.00 27.78           C  
ATOM   5322  O   LEU C 204     -20.441  90.781  15.009  1.00 27.04           O  
ATOM   5323  CB  LEU C 204     -18.323  92.678  13.186  1.00 26.06           C  
ATOM   5324  CG  LEU C 204     -17.621  92.618  14.549  1.00 24.56           C  
ATOM   5325  CD1 LEU C 204     -17.148  91.201  14.833  1.00 21.59           C  
ATOM   5326  CD2 LEU C 204     -16.462  93.574  14.631  1.00 26.21           C  
ATOM   5327  N   ALA C 205     -21.307  92.687  14.111  1.00 28.14           N  
ATOM   5328  CA  ALA C 205     -22.321  92.874  15.134  1.00 28.73           C  
ATOM   5329  C   ALA C 205     -23.261  91.671  15.228  1.00 29.19           C  
ATOM   5330  O   ALA C 205     -23.642  91.263  16.337  1.00 29.91           O  
ATOM   5331  CB  ALA C 205     -23.116  94.157  14.859  1.00 28.03           C  
ATOM   5332  N   ARG C 206     -23.633  91.125  14.067  1.00 29.43           N  
ATOM   5333  CA  ARG C 206     -24.538  89.972  13.990  1.00 31.43           C  
ATOM   5334  C   ARG C 206     -23.865  88.759  14.619  1.00 30.80           C  
ATOM   5335  O   ARG C 206     -24.504  88.005  15.381  1.00 30.87           O  
ATOM   5336  CB  ARG C 206     -24.931  89.644  12.535  1.00 30.94           C  
ATOM   5337  CG  ARG C 206     -26.038  90.522  11.952  1.00 34.10           C  
ATOM   5338  CD  ARG C 206     -26.664  89.890  10.709  1.00 35.14           C  
ATOM   5339  NE  ARG C 206     -25.674  89.764   9.633  1.00 42.59           N  
ATOM   5340  CZ  ARG C 206     -25.595  90.560   8.564  1.00 44.89           C  
ATOM   5341  NH1 ARG C 206     -24.631  90.364   7.666  1.00 43.12           N  
ATOM   5342  NH2 ARG C 206     -26.470  91.554   8.402  1.00 46.00           N  
ATOM   5343  N   ASN C 207     -22.577  88.580  14.292  1.00 29.91           N  
ATOM   5344  CA  ASN C 207     -21.787  87.519  14.899  1.00 29.33           C  
ATOM   5345  C   ASN C 207     -21.862  87.601  16.414  1.00 28.36           C  
ATOM   5346  O   ASN C 207     -22.161  86.602  17.059  1.00 28.84           O  
ATOM   5347  CB  ASN C 207     -20.327  87.505  14.432  1.00 29.71           C  
ATOM   5348  CG  ASN C 207     -19.549  86.316  15.009  1.00 31.55           C  
ATOM   5349  OD1 ASN C 207     -19.470  85.248  14.392  1.00 35.24           O  
ATOM   5350  ND2 ASN C 207     -19.036  86.475  16.217  1.00 30.47           N  
ATOM   5351  N   LEU C 208     -21.644  88.793  16.964  1.00 27.16           N  
ATOM   5352  CA  LEU C 208     -21.669  89.009  18.403  1.00 26.94           C  
ATOM   5353  C   LEU C 208     -23.045  88.822  19.085  1.00 27.23           C  
ATOM   5354  O   LEU C 208     -23.122  88.343  20.232  1.00 25.82           O  
ATOM   5355  CB  LEU C 208     -21.079  90.384  18.743  1.00 26.79           C  
ATOM   5356  CG  LEU C 208     -19.593  90.611  18.370  1.00 25.90           C  
ATOM   5357  CD1 LEU C 208     -19.220  92.065  18.653  1.00 24.48           C  
ATOM   5358  CD2 LEU C 208     -18.591  89.643  19.122  1.00 20.43           C  
ATOM   5359  N   LEU C 209     -24.128  89.179  18.380  1.00 28.08           N  
ATOM   5360  CA  LEU C 209     -25.491  88.953  18.898  1.00 28.84           C  
ATOM   5361  C   LEU C 209     -25.808  87.469  19.035  1.00 30.13           C  
ATOM   5362  O   LEU C 209     -26.670  87.085  19.810  1.00 31.66           O  
ATOM   5363  CB  LEU C 209     -26.532  89.561  17.966  1.00 28.82           C  
ATOM   5364  CG  LEU C 209     -26.680  91.067  17.939  1.00 28.18           C  
ATOM   5365  CD1 LEU C 209     -27.684  91.416  16.887  1.00 27.25           C  
ATOM   5366  CD2 LEU C 209     -27.149  91.532  19.292  1.00 26.70           C  
ATOM   5367  N   GLU C 210     -25.129  86.639  18.257  1.00 32.25           N  
ATOM   5368  CA  GLU C 210     -25.347  85.204  18.321  1.00 33.68           C  
ATOM   5369  C   GLU C 210     -24.824  84.633  19.645  1.00 33.24           C  
ATOM   5370  O   GLU C 210     -25.239  83.542  20.037  1.00 33.77           O  
ATOM   5371  CB  GLU C 210     -24.694  84.480  17.140  1.00 33.98           C  
ATOM   5372  CG  GLU C 210     -25.343  84.674  15.757  1.00 35.71           C  
ATOM   5373  CD  GLU C 210     -24.460  84.165  14.604  0.50 36.35           C  
ATOM   5374  OE1 GLU C 210     -23.415  83.532  14.852  1.00 40.17           O  
ATOM   5375  OE2 GLU C 210     -24.808  84.385  13.426  1.00 42.63           O  
ATOM   5376  N   LYS C 211     -23.940  85.364  20.346  1.00 32.54           N  
ATOM   5377  CA  LYS C 211     -23.279  84.800  21.529  1.00 31.13           C  
ATOM   5378  C   LYS C 211     -24.166  84.993  22.743  1.00 31.15           C  
ATOM   5379  O   LYS C 211     -24.987  85.889  22.757  1.00 30.46           O  
ATOM   5380  CB  LYS C 211     -21.913  85.452  21.800  1.00 31.39           C  
ATOM   5381  CG  LYS C 211     -21.041  85.672  20.573  1.00 28.16           C  
ATOM   5382  CD  LYS C 211     -20.761  84.390  19.818  1.00 26.38           C  
ATOM   5383  CE  LYS C 211     -19.693  84.694  18.781  1.00 26.08           C  
ATOM   5384  NZ  LYS C 211     -19.573  83.710  17.717  1.00 28.73           N  
ATOM   5385  N   ASN C 212     -24.007  84.135  23.746  1.00 30.40           N  
ATOM   5386  CA  ASN C 212     -24.664  84.340  25.028  1.00 30.82           C  
ATOM   5387  C   ASN C 212     -24.169  85.658  25.645  1.00 29.71           C  
ATOM   5388  O   ASN C 212     -22.972  85.846  25.795  1.00 30.32           O  
ATOM   5389  CB  ASN C 212     -24.413  83.134  25.934  1.00 30.88           C  
ATOM   5390  CG  ASN C 212     -25.166  83.224  27.236  1.00 32.88           C  
ATOM   5391  OD1 ASN C 212     -24.832  84.025  28.128  1.00 35.93           O  
ATOM   5392  ND2 ASN C 212     -26.194  82.393  27.370  1.00 35.61           N  
ATOM   5393  N   PRO C 213     -25.081  86.625  25.887  1.00 29.23           N  
ATOM   5394  CA  PRO C 213     -24.731  87.932  26.458  1.00 27.58           C  
ATOM   5395  C   PRO C 213     -23.880  87.931  27.714  1.00 26.40           C  
ATOM   5396  O   PRO C 213     -22.900  88.647  27.765  1.00 27.04           O  
ATOM   5397  CB  PRO C 213     -26.102  88.580  26.720  1.00 27.92           C  
ATOM   5398  CG  PRO C 213     -26.923  88.067  25.519  1.00 28.90           C  
ATOM   5399  CD  PRO C 213     -26.499  86.590  25.437  1.00 28.51           C  
ATOM   5400  N   VAL C 214     -24.256  87.147  28.713  1.00 24.89           N  
ATOM   5401  CA  VAL C 214     -23.560  87.124  29.988  1.00 24.28           C  
ATOM   5402  C   VAL C 214     -22.149  86.526  29.781  1.00 23.90           C  
ATOM   5403  O   VAL C 214     -21.171  86.944  30.426  1.00 23.46           O  
ATOM   5404  CB  VAL C 214     -24.415  86.377  31.049  1.00 24.63           C  
ATOM   5405  CG1 VAL C 214     -23.597  86.079  32.351  1.00 23.80           C  
ATOM   5406  CG2 VAL C 214     -25.704  87.197  31.384  1.00 24.51           C  
ATOM   5407  N   VAL C 215     -22.062  85.580  28.848  1.00 24.52           N  
ATOM   5408  CA  VAL C 215     -20.804  84.836  28.613  1.00 25.46           C  
ATOM   5409  C   VAL C 215     -19.849  85.734  27.834  1.00 25.35           C  
ATOM   5410  O   VAL C 215     -18.677  85.881  28.194  1.00 24.41           O  
ATOM   5411  CB  VAL C 215     -21.052  83.477  27.907  1.00 25.84           C  
ATOM   5412  CG1 VAL C 215     -19.763  82.796  27.554  1.00 23.77           C  
ATOM   5413  CG2 VAL C 215     -21.923  82.554  28.795  1.00 25.74           C  
ATOM   5414  N   LEU C 216     -20.351  86.356  26.774  1.00 24.44           N  
ATOM   5415  CA  LEU C 216     -19.568  87.375  26.074  1.00 24.35           C  
ATOM   5416  C   LEU C 216     -19.080  88.461  27.037  1.00 25.01           C  
ATOM   5417  O   LEU C 216     -17.927  88.872  26.995  1.00 24.93           O  
ATOM   5418  CB  LEU C 216     -20.385  87.999  24.936  1.00 23.90           C  
ATOM   5419  CG  LEU C 216     -19.604  88.898  23.988  1.00 24.29           C  
ATOM   5420  CD1 LEU C 216     -18.312  88.198  23.518  1.00 22.48           C  
ATOM   5421  CD2 LEU C 216     -20.488  89.277  22.779  1.00 22.54           C  
ATOM   5422  N   ARG C 217     -19.958  88.926  27.915  1.00 26.03           N  
ATOM   5423  CA  ARG C 217     -19.561  89.922  28.897  1.00 26.63           C  
ATOM   5424  C   ARG C 217     -18.377  89.428  29.740  1.00 25.60           C  
ATOM   5425  O   ARG C 217     -17.393  90.152  29.944  1.00 24.60           O  
ATOM   5426  CB  ARG C 217     -20.757  90.283  29.806  1.00 26.28           C  
ATOM   5427  CG  ARG C 217     -20.484  91.463  30.696  1.00 30.20           C  
ATOM   5428  CD  ARG C 217     -21.447  91.481  31.907  1.00 33.39           C  
ATOM   5429  NE  ARG C 217     -22.850  91.447  31.479  1.00 33.08           N  
ATOM   5430  CZ  ARG C 217     -23.906  91.407  32.289  1.00 36.48           C  
ATOM   5431  NH1 ARG C 217     -23.748  91.396  33.622  1.00 38.37           N  
ATOM   5432  NH2 ARG C 217     -25.134  91.371  31.764  1.00 34.01           N  
ATOM   5433  N   ALA C 218     -18.485  88.205  30.251  1.00 25.20           N  
ATOM   5434  CA  ALA C 218     -17.456  87.652  31.135  1.00 25.33           C  
ATOM   5435  C   ALA C 218     -16.126  87.522  30.373  1.00 25.75           C  
ATOM   5436  O   ALA C 218     -15.041  87.788  30.920  1.00 24.66           O  
ATOM   5437  CB  ALA C 218     -17.898  86.287  31.659  1.00 24.94           C  
ATOM   5438  N   ALA C 219     -16.236  87.132  29.103  1.00 25.08           N  
ATOM   5439  CA  ALA C 219     -15.072  86.920  28.247  1.00 25.52           C  
ATOM   5440  C   ALA C 219     -14.334  88.238  27.973  1.00 25.69           C  
ATOM   5441  O   ALA C 219     -13.111  88.337  28.186  1.00 24.97           O  
ATOM   5442  CB  ALA C 219     -15.477  86.243  26.951  1.00 25.34           C  
ATOM   5443  N   LYS C 220     -15.060  89.248  27.494  1.00 25.33           N  
ATOM   5444  CA  LYS C 220     -14.454  90.541  27.131  1.00 23.57           C  
ATOM   5445  C   LYS C 220     -13.926  91.331  28.368  1.00 24.36           C  
ATOM   5446  O   LYS C 220     -12.820  91.912  28.311  1.00 23.39           O  
ATOM   5447  CB  LYS C 220     -15.402  91.347  26.209  1.00 24.42           C  
ATOM   5448  CG  LYS C 220     -16.582  92.035  26.929  1.00 23.69           C  
ATOM   5449  CD  LYS C 220     -17.784  92.297  25.988  1.00 23.17           C  
ATOM   5450  CE  LYS C 220     -18.820  93.205  26.650  1.00 23.94           C  
ATOM   5451  NZ  LYS C 220     -18.418  94.687  26.512  1.00 19.28           N  
ATOM   5452  N   HIS C 221     -14.684  91.359  29.475  1.00 23.89           N  
ATOM   5453  CA  HIS C 221     -14.218  92.023  30.703  1.00 23.43           C  
ATOM   5454  C   HIS C 221     -12.943  91.337  31.227  1.00 24.06           C  
ATOM   5455  O   HIS C 221     -11.957  92.008  31.611  1.00 23.55           O  
ATOM   5456  CB  HIS C 221     -15.285  92.014  31.816  1.00 23.23           C  
ATOM   5457  CG  HIS C 221     -16.479  92.889  31.514  1.00 25.47           C  
ATOM   5458  ND1 HIS C 221     -17.502  93.106  32.416  1.00 25.22           N  
ATOM   5459  CD2 HIS C 221     -16.813  93.581  30.401  1.00 25.54           C  
ATOM   5460  CE1 HIS C 221     -18.414  93.895  31.868  1.00 24.74           C  
ATOM   5461  NE2 HIS C 221     -18.020  94.198  30.646  1.00 25.65           N  
ATOM   5462  N   GLY C 222     -12.990  89.998  31.232  1.00 23.07           N  
ATOM   5463  CA  GLY C 222     -11.930  89.177  31.779  1.00 22.57           C  
ATOM   5464  C   GLY C 222     -10.665  89.439  30.994  1.00 22.06           C  
ATOM   5465  O   GLY C 222      -9.578  89.587  31.556  1.00 21.64           O  
ATOM   5466  N   PHE C 223     -10.790  89.504  29.681  1.00 21.33           N  
ATOM   5467  CA  PHE C 223      -9.602  89.815  28.905  1.00 21.39           C  
ATOM   5468  C   PHE C 223      -8.989  91.187  29.329  1.00 22.18           C  
ATOM   5469  O   PHE C 223      -7.769  91.290  29.615  1.00 20.03           O  
ATOM   5470  CB  PHE C 223      -9.838  89.765  27.364  1.00 20.67           C  
ATOM   5471  CG  PHE C 223      -8.631  90.247  26.608  1.00 18.57           C  
ATOM   5472  CD1 PHE C 223      -8.491  91.603  26.272  1.00 19.55           C  
ATOM   5473  CD2 PHE C 223      -7.562  89.377  26.363  1.00 21.53           C  
ATOM   5474  CE1 PHE C 223      -7.331  92.060  25.700  1.00 19.60           C  
ATOM   5475  CE2 PHE C 223      -6.407  89.827  25.731  1.00 22.42           C  
ATOM   5476  CZ  PHE C 223      -6.277  91.160  25.400  1.00 22.71           C  
ATOM   5477  N   LYS C 224      -9.834  92.224  29.391  1.00 20.78           N  
ATOM   5478  CA  LYS C 224      -9.345  93.589  29.597  1.00 21.41           C  
ATOM   5479  C   LYS C 224      -8.675  93.692  30.969  1.00 22.94           C  
ATOM   5480  O   LYS C 224      -7.611  94.311  31.106  1.00 24.01           O  
ATOM   5481  CB  LYS C 224     -10.498  94.656  29.423  1.00 19.44           C  
ATOM   5482  CG  LYS C 224     -11.020  94.810  27.980  1.00 21.86           C  
ATOM   5483  CD  LYS C 224     -12.039  95.986  27.871  1.00 21.26           C  
ATOM   5484  CE  LYS C 224     -12.561  96.193  26.376  1.00 19.96           C  
ATOM   5485  NZ  LYS C 224     -13.130  97.632  26.179  1.00 20.24           N  
ATOM   5486  N   ARG C 225      -9.290  93.056  31.976  1.00 21.95           N  
ATOM   5487  CA  ARG C 225      -8.750  93.053  33.314  1.00 21.81           C  
ATOM   5488  C   ARG C 225      -7.502  92.184  33.412  1.00 22.44           C  
ATOM   5489  O   ARG C 225      -6.588  92.537  34.123  1.00 22.01           O  
ATOM   5490  CB  ARG C 225      -9.779  92.531  34.316  1.00 21.69           C  
ATOM   5491  CG  ARG C 225      -9.312  92.543  35.813  1.00 23.67           C  
ATOM   5492  CD  ARG C 225      -9.341  93.912  36.462  1.00 24.36           C  
ATOM   5493  NE  ARG C 225     -10.663  94.515  36.365  1.00 28.56           N  
ATOM   5494  CZ  ARG C 225     -10.903  95.815  36.209  1.00 28.86           C  
ATOM   5495  NH1 ARG C 225     -12.164  96.245  36.122  1.00 23.34           N  
ATOM   5496  NH2 ARG C 225      -9.892  96.679  36.117  1.00 26.83           N  
ATOM   5497  N   CYS C 226      -7.470  91.032  32.744  1.00 20.82           N  
ATOM   5498  CA  CYS C 226      -6.302  90.103  32.924  1.00 20.61           C  
ATOM   5499  C   CYS C 226      -4.992  90.720  32.478  1.00 20.79           C  
ATOM   5500  O   CYS C 226      -3.951  90.357  32.987  1.00 18.45           O  
ATOM   5501  CB  CYS C 226      -6.513  88.740  32.255  1.00 19.63           C  
ATOM   5502  SG  CYS C 226      -6.108  88.640  30.487  1.00 23.13           S  
ATOM   5503  N   ARG C 227      -5.062  91.695  31.566  1.00 21.03           N  
ATOM   5504  CA  ARG C 227      -3.824  92.437  31.168  1.00 21.93           C  
ATOM   5505  C   ARG C 227      -3.096  93.079  32.370  1.00 23.10           C  
ATOM   5506  O   ARG C 227      -1.883  93.215  32.374  1.00 23.04           O  
ATOM   5507  CB  ARG C 227      -4.160  93.500  30.125  1.00 23.93           C  
ATOM   5508  CG  ARG C 227      -4.760  92.913  28.864  1.00 23.38           C  
ATOM   5509  CD  ARG C 227      -4.801  93.993  27.747  1.00 20.82           C  
ATOM   5510  NE  ARG C 227      -3.417  94.367  27.384  1.00 22.92           N  
ATOM   5511  CZ  ARG C 227      -3.081  95.376  26.600  1.00 25.22           C  
ATOM   5512  NH1 ARG C 227      -4.024  96.139  26.046  1.00 26.33           N  
ATOM   5513  NH2 ARG C 227      -1.779  95.593  26.323  1.00 23.49           N  
ATOM   5514  N   GLU C 228      -3.854  93.484  33.384  1.00 22.78           N  
ATOM   5515  CA  GLU C 228      -3.327  94.135  34.611  1.00 22.04           C  
ATOM   5516  C   GLU C 228      -2.811  93.179  35.668  1.00 21.39           C  
ATOM   5517  O   GLU C 228      -2.164  93.613  36.655  1.00 21.97           O  
ATOM   5518  CB  GLU C 228      -4.489  94.921  35.259  1.00 22.56           C  
ATOM   5519  CG  GLU C 228      -5.206  95.785  34.280  1.00 20.13           C  
ATOM   5520  CD  GLU C 228      -6.367  96.544  34.826  1.00 24.39           C  
ATOM   5521  OE1 GLU C 228      -6.878  96.193  35.907  1.00 19.27           O  
ATOM   5522  OE2 GLU C 228      -6.819  97.483  34.114  1.00 25.47           O  
ATOM   5523  N   LEU C 229      -3.104  91.892  35.515  0.50 20.30           N  
ATOM   5524  CA  LEU C 229      -2.813  90.913  36.594  0.50 20.48           C  
ATOM   5525  C   LEU C 229      -1.657  89.984  36.244  0.50 20.31           C  
ATOM   5526  O   LEU C 229      -1.325  89.847  35.082  0.50 21.68           O  
ATOM   5527  CB  LEU C 229      -4.077  90.097  36.914  0.50 19.67           C  
ATOM   5528  CG  LEU C 229      -5.247  90.971  37.396  0.50 20.59           C  
ATOM   5529  CD1 LEU C 229      -6.551  90.195  37.426  0.50 15.96           C  
ATOM   5530  CD2 LEU C 229      -4.957  91.654  38.754  0.50 18.58           C  
ATOM   5539  N   THR C 230      -1.058  89.341  37.240  1.00 20.71           N  
ATOM   5540  CA  THR C 230      -0.001  88.350  36.989  1.00 20.07           C  
ATOM   5541  C   THR C 230      -0.711  87.047  36.497  1.00 20.64           C  
ATOM   5542  O   THR C 230      -1.949  86.979  36.515  1.00 19.17           O  
ATOM   5543  CB  THR C 230       0.826  88.012  38.247  1.00 20.55           C  
ATOM   5544  OG1 THR C 230      -0.070  87.473  39.192  1.00 19.02           O  
ATOM   5545  CG2 THR C 230       1.443  89.259  38.876  1.00 18.51           C  
ATOM   5546  N   TRP C 231       0.049  86.053  36.014  1.00 20.49           N  
ATOM   5547  CA  TRP C 231      -0.562  84.729  35.722  1.00 20.14           C  
ATOM   5548  C   TRP C 231      -1.238  84.135  36.961  1.00 21.06           C  
ATOM   5549  O   TRP C 231      -2.371  83.673  36.903  1.00 20.53           O  
ATOM   5550  CB  TRP C 231       0.506  83.757  35.184  1.00 20.79           C  
ATOM   5551  CG  TRP C 231       0.838  84.147  33.731  1.00 18.29           C  
ATOM   5552  CD1 TRP C 231       1.249  85.367  33.275  1.00 22.26           C  
ATOM   5553  CD2 TRP C 231       0.692  83.315  32.569  1.00 19.30           C  
ATOM   5554  NE1 TRP C 231       1.402  85.347  31.903  1.00 17.26           N  
ATOM   5555  CE2 TRP C 231       1.073  84.090  31.447  1.00 20.81           C  
ATOM   5556  CE3 TRP C 231       0.286  81.986  32.373  1.00 20.53           C  
ATOM   5557  CZ2 TRP C 231       1.066  83.574  30.128  1.00 21.03           C  
ATOM   5558  CZ3 TRP C 231       0.298  81.474  31.062  1.00 20.28           C  
ATOM   5559  CH2 TRP C 231       0.666  82.276  29.961  1.00 21.93           C  
ATOM   5560  N   GLU C 232      -0.532  84.140  38.087  1.00 19.76           N  
ATOM   5561  CA  GLU C 232      -1.094  83.557  39.302  1.00 20.71           C  
ATOM   5562  C   GLU C 232      -2.321  84.314  39.819  1.00 20.41           C  
ATOM   5563  O   GLU C 232      -3.301  83.678  40.273  1.00 22.57           O  
ATOM   5564  CB  GLU C 232       0.004  83.426  40.355  1.00 21.52           C  
ATOM   5565  CG  GLU C 232       1.150  82.471  39.869  1.00 26.66           C  
ATOM   5566  CD  GLU C 232       2.208  83.144  38.925  1.00 32.66           C  
ATOM   5567  OE1 GLU C 232       2.216  84.433  38.750  1.00 30.91           O  
ATOM   5568  OE2 GLU C 232       3.060  82.361  38.384  1.00 31.69           O  
ATOM   5569  N   GLN C 233      -2.307  85.651  39.738  1.00 20.14           N  
ATOM   5570  CA  GLN C 233      -3.538  86.444  40.013  1.00 20.37           C  
ATOM   5571  C   GLN C 233      -4.694  86.107  39.051  1.00 20.23           C  
ATOM   5572  O   GLN C 233      -5.848  86.023  39.464  1.00 21.26           O  
ATOM   5573  CB  GLN C 233      -3.282  87.941  39.944  1.00 20.12           C  
ATOM   5574  CG  GLN C 233      -2.401  88.481  41.127  1.00 21.78           C  
ATOM   5575  CD  GLN C 233      -2.025  89.932  40.951  1.00 21.74           C  
ATOM   5576  OE1 GLN C 233      -1.820  90.397  39.839  1.00 19.31           O  
ATOM   5577  NE2 GLN C 233      -1.903  90.659  42.070  1.00 21.54           N  
ATOM   5578  N   ASN C 234      -4.383  85.874  37.789  1.00 19.65           N  
ATOM   5579  CA  ASN C 234      -5.392  85.472  36.799  1.00 20.21           C  
ATOM   5580  C   ASN C 234      -5.944  84.074  37.000  1.00 20.68           C  
ATOM   5581  O   ASN C 234      -7.096  83.794  36.668  1.00 21.76           O  
ATOM   5582  CB  ASN C 234      -4.816  85.651  35.407  1.00 19.55           C  
ATOM   5583  CG  ASN C 234      -4.943  87.089  34.955  1.00 19.82           C  
ATOM   5584  OD1 ASN C 234      -6.016  87.645  35.063  1.00 19.95           O  
ATOM   5585  ND2 ASN C 234      -3.861  87.713  34.492  1.00 21.72           N  
ATOM   5586  N   GLU C 235      -5.121  83.178  37.505  1.00 20.00           N  
ATOM   5587  CA  GLU C 235      -5.632  81.830  37.761  1.00 19.76           C  
ATOM   5588  C   GLU C 235      -6.908  82.021  38.586  1.00 20.04           C  
ATOM   5589  O   GLU C 235      -7.936  81.447  38.305  1.00 20.61           O  
ATOM   5590  CB  GLU C 235      -4.621  80.963  38.507  1.00 21.16           C  
ATOM   5591  CG  GLU C 235      -5.210  79.558  38.681  1.00 21.98           C  
ATOM   5592  CD  GLU C 235      -4.396  78.592  39.484  1.00 26.11           C  
ATOM   5593  OE1 GLU C 235      -3.667  78.994  40.419  1.00 28.57           O  
ATOM   5594  OE2 GLU C 235      -4.526  77.381  39.196  1.00 25.39           O  
ATOM   5595  N   ASP C 236      -6.807  82.865  39.600  1.00 19.84           N  
ATOM   5596  CA  ASP C 236      -7.876  83.124  40.567  1.00 19.81           C  
ATOM   5597  C   ASP C 236      -8.964  83.940  39.882  1.00 18.32           C  
ATOM   5598  O   ASP C 236     -10.135  83.522  39.835  1.00 18.27           O  
ATOM   5599  CB  ASP C 236      -7.257  83.900  41.750  1.00 19.45           C  
ATOM   5600  CG  ASP C 236      -8.248  84.149  42.912  1.00 24.18           C  
ATOM   5601  OD1 ASP C 236      -9.432  83.781  42.811  1.00 25.24           O  
ATOM   5602  OD2 ASP C 236      -7.824  84.763  43.916  1.00 20.06           O  
ATOM   5603  N   TYR C 237      -8.587  85.083  39.315  1.00 18.23           N  
ATOM   5604  CA  TYR C 237      -9.558  86.002  38.717  1.00 18.87           C  
ATOM   5605  C   TYR C 237     -10.328  85.350  37.516  1.00 18.74           C  
ATOM   5606  O   TYR C 237     -11.554  85.424  37.457  1.00 18.45           O  
ATOM   5607  CB  TYR C 237      -8.912  87.359  38.309  1.00 19.09           C  
ATOM   5608  CG  TYR C 237      -9.779  88.218  37.382  1.00 21.51           C  
ATOM   5609  CD1 TYR C 237      -9.525  88.266  36.018  1.00 21.95           C  
ATOM   5610  CD2 TYR C 237     -10.852  88.987  37.885  1.00 21.96           C  
ATOM   5611  CE1 TYR C 237     -10.319  89.026  35.172  1.00 21.19           C  
ATOM   5612  CE2 TYR C 237     -11.679  89.738  37.029  1.00 18.95           C  
ATOM   5613  CZ  TYR C 237     -11.399  89.781  35.704  1.00 20.34           C  
ATOM   5614  OH  TYR C 237     -12.222  90.563  34.907  1.00 20.95           O  
ATOM   5615  N   LEU C 238      -9.620  84.764  36.549  1.00 18.30           N  
ATOM   5616  CA  LEU C 238     -10.284  84.228  35.381  1.00 19.28           C  
ATOM   5617  C   LEU C 238     -11.185  83.044  35.710  1.00 19.92           C  
ATOM   5618  O   LEU C 238     -12.227  82.859  35.054  1.00 20.78           O  
ATOM   5619  CB  LEU C 238      -9.300  83.869  34.207  1.00 19.55           C  
ATOM   5620  CG  LEU C 238      -8.540  85.104  33.700  1.00 19.86           C  
ATOM   5621  CD1 LEU C 238      -7.278  84.659  32.908  1.00 21.03           C  
ATOM   5622  CD2 LEU C 238      -9.442  86.114  32.912  1.00 17.04           C  
ATOM   5623  N   TYR C 239     -10.806  82.208  36.675  1.00 19.67           N  
ATOM   5624  CA  TYR C 239     -11.725  81.150  37.043  1.00 19.98           C  
ATOM   5625  C   TYR C 239     -12.917  81.746  37.733  1.00 20.44           C  
ATOM   5626  O   TYR C 239     -14.049  81.334  37.458  1.00 20.92           O  
ATOM   5627  CB  TYR C 239     -11.094  80.102  37.948  1.00 19.39           C  
ATOM   5628  CG  TYR C 239     -10.485  78.955  37.167  1.00 21.10           C  
ATOM   5629  CD1 TYR C 239      -9.112  78.698  37.232  1.00 24.25           C  
ATOM   5630  CD2 TYR C 239     -11.271  78.167  36.287  1.00 21.72           C  
ATOM   5631  CE1 TYR C 239      -8.543  77.623  36.505  1.00 20.58           C  
ATOM   5632  CE2 TYR C 239     -10.713  77.104  35.540  1.00 22.57           C  
ATOM   5633  CZ  TYR C 239      -9.343  76.833  35.675  1.00 22.43           C  
ATOM   5634  OH  TYR C 239      -8.729  75.802  34.972  1.00 18.99           O  
ATOM   5635  N   ALA C 240     -12.692  82.709  38.630  1.00 20.10           N  
ATOM   5636  CA  ALA C 240     -13.859  83.461  39.162  1.00 20.00           C  
ATOM   5637  C   ALA C 240     -14.797  84.032  38.106  1.00 19.57           C  
ATOM   5638  O   ALA C 240     -16.012  83.870  38.259  1.00 20.82           O  
ATOM   5639  CB  ALA C 240     -13.472  84.478  40.210  1.00 19.70           C  
ATOM   5640  N   LYS C 241     -14.290  84.689  37.059  1.00 19.66           N  
ATOM   5641  CA  LYS C 241     -15.185  85.151  35.988  1.00 20.39           C  
ATOM   5642  C   LYS C 241     -15.941  84.026  35.302  1.00 21.35           C  
ATOM   5643  O   LYS C 241     -17.090  84.212  34.903  1.00 20.61           O  
ATOM   5644  CB  LYS C 241     -14.470  85.962  34.899  1.00 20.78           C  
ATOM   5645  CG  LYS C 241     -13.727  87.219  35.400  1.00 20.67           C  
ATOM   5646  CD  LYS C 241     -14.611  88.180  36.118  1.00 20.51           C  
ATOM   5647  CE  LYS C 241     -15.511  88.989  35.194  1.00 18.56           C  
ATOM   5648  NZ  LYS C 241     -16.354  89.945  36.066  1.00 20.30           N  
ATOM   5649  N   LEU C 242     -15.280  82.878  35.115  1.00 22.23           N  
ATOM   5650  CA  LEU C 242     -15.926  81.707  34.515  1.00 22.47           C  
ATOM   5651  C   LEU C 242     -17.101  81.239  35.371  1.00 21.81           C  
ATOM   5652  O   LEU C 242     -18.197  81.015  34.838  1.00 21.87           O  
ATOM   5653  CB  LEU C 242     -14.896  80.539  34.358  1.00 23.53           C  
ATOM   5654  CG  LEU C 242     -15.171  79.243  33.565  1.00 24.88           C  
ATOM   5655  CD1 LEU C 242     -15.900  78.143  34.350  1.00 31.60           C  
ATOM   5656  CD2 LEU C 242     -15.892  79.511  32.249  1.00 27.81           C  
ATOM   5657  N   ASP C 243     -16.855  81.059  36.664  1.00 20.40           N  
ATOM   5658  CA  ASP C 243     -17.889  80.630  37.638  1.00 21.49           C  
ATOM   5659  C   ASP C 243     -19.017  81.626  37.852  1.00 20.86           C  
ATOM   5660  O   ASP C 243     -20.206  81.263  38.047  1.00 21.92           O  
ATOM   5661  CB  ASP C 243     -17.225  80.296  38.968  1.00 21.04           C  
ATOM   5662  CG  ASP C 243     -16.345  79.026  38.887  1.00 24.02           C  
ATOM   5663  OD1 ASP C 243     -16.520  78.231  37.955  1.00 24.27           O  
ATOM   5664  OD2 ASP C 243     -15.481  78.835  39.763  1.00 26.46           O  
ATOM   5665  N   GLN C 244     -18.657  82.900  37.788  1.00 21.44           N  
ATOM   5666  CA  GLN C 244     -19.642  83.980  37.826  1.00 21.98           C  
ATOM   5667  C   GLN C 244     -20.535  83.948  36.593  1.00 22.85           C  
ATOM   5668  O   GLN C 244     -21.761  84.096  36.714  1.00 22.58           O  
ATOM   5669  CB  GLN C 244     -18.908  85.311  37.945  1.00 22.54           C  
ATOM   5670  CG  GLN C 244     -19.788  86.554  37.693  1.00 22.18           C  
ATOM   5671  CD  GLN C 244     -19.001  87.811  37.901  1.00 24.52           C  
ATOM   5672  OE1 GLN C 244     -18.011  88.050  37.211  1.00 23.82           O  
ATOM   5673  NE2 GLN C 244     -19.424  88.626  38.871  1.00 23.05           N  
ATOM   5674  N   SER C 245     -19.923  83.745  35.427  0.50 23.73           N  
ATOM   5675  CA  SER C 245     -20.644  83.656  34.161  0.50 24.53           C  
ATOM   5676  C   SER C 245     -21.667  82.514  34.149  0.50 24.55           C  
ATOM   5677  O   SER C 245     -22.764  82.670  33.624  0.50 24.77           O  
ATOM   5678  CB  SER C 245     -19.676  83.494  32.988  0.50 24.89           C  
ATOM   5679  OG  SER C 245     -20.381  83.523  31.766  0.50 26.60           O  
ATOM   5686  N   ARG C 246     -21.290  81.375  34.712  1.00 24.25           N  
ATOM   5687  CA  ARG C 246     -22.192  80.234  34.883  1.00 26.80           C  
ATOM   5688  C   ARG C 246     -23.378  80.555  35.781  1.00 27.42           C  
ATOM   5689  O   ARG C 246     -24.513  80.251  35.429  1.00 26.68           O  
ATOM   5690  CB  ARG C 246     -21.444  79.005  35.390  1.00 27.04           C  
ATOM   5691  CG  ARG C 246     -20.552  78.430  34.327  1.00 32.59           C  
ATOM   5692  CD  ARG C 246     -19.487  77.501  34.868  1.00 40.29           C  
ATOM   5693  NE  ARG C 246     -20.022  76.292  35.499  1.00 45.78           N  
ATOM   5694  CZ  ARG C 246     -19.350  75.593  36.422  1.00 48.04           C  
ATOM   5695  NH1 ARG C 246     -18.145  76.008  36.833  1.00 45.50           N  
ATOM   5696  NH2 ARG C 246     -19.885  74.497  36.958  1.00 47.41           N  
ATOM   5697  N   LEU C 247     -23.133  81.221  36.902  1.00 27.38           N  
ATOM   5698  CA  LEU C 247     -24.254  81.673  37.759  1.00 28.54           C  
ATOM   5699  C   LEU C 247     -25.181  82.719  37.109  1.00 29.54           C  
ATOM   5700  O   LEU C 247     -26.387  82.566  37.129  1.00 30.08           O  
ATOM   5701  CB  LEU C 247     -23.724  82.210  39.088  1.00 27.36           C  
ATOM   5702  CG  LEU C 247     -24.798  82.775  40.033  1.00 28.37           C  
ATOM   5703  CD1 LEU C 247     -25.460  81.641  40.808  1.00 28.59           C  
ATOM   5704  CD2 LEU C 247     -24.229  83.830  40.976  1.00 26.80           C  
ATOM   5705  N   LEU C 248     -24.611  83.790  36.555  1.00 31.32           N  
ATOM   5706  CA  LEU C 248     -25.383  84.930  36.070  1.00 33.17           C  
ATOM   5707  C   LEU C 248     -26.098  84.642  34.775  1.00 34.82           C  
ATOM   5708  O   LEU C 248     -27.059  85.347  34.413  1.00 34.51           O  
ATOM   5709  CB  LEU C 248     -24.490  86.156  35.873  1.00 32.48           C  
ATOM   5710  CG  LEU C 248     -23.854  86.731  37.130  1.00 32.58           C  
ATOM   5711  CD1 LEU C 248     -23.064  87.998  36.764  1.00 27.22           C  
ATOM   5712  CD2 LEU C 248     -24.910  87.012  38.190  1.00 32.13           C  
ATOM   5713  N   ASP C 249     -25.636  83.612  34.071  1.00 36.26           N  
ATOM   5714  CA  ASP C 249     -26.253  83.270  32.790  1.00 38.30           C  
ATOM   5715  C   ASP C 249     -27.480  82.358  32.933  1.00 39.57           C  
ATOM   5716  O   ASP C 249     -27.366  81.160  33.217  1.00 40.00           O  
ATOM   5717  CB  ASP C 249     -25.241  82.689  31.814  1.00 37.50           C  
ATOM   5718  CG  ASP C 249     -25.901  81.972  30.689  1.00 38.75           C  
ATOM   5719  OD1 ASP C 249     -26.925  82.511  30.167  1.00 35.36           O  
ATOM   5720  OD2 ASP C 249     -25.407  80.868  30.356  1.00 36.81           O  
ATOM   5721  N   THR C 250     -28.647  82.933  32.785  1.00 41.75           N  
ATOM   5722  CA  THR C 250     -29.850  82.248  33.245  1.00 42.84           C  
ATOM   5723  C   THR C 250     -30.426  81.313  32.216  1.00 43.70           C  
ATOM   5724  O   THR C 250     -30.599  80.125  32.478  1.00 45.39           O  
ATOM   5725  CB  THR C 250     -30.882  83.182  33.842  1.00 42.89           C  
ATOM   5726  OG1 THR C 250     -30.365  83.694  35.080  1.00 42.32           O  
ATOM   5727  CG2 THR C 250     -31.230  84.302  32.897  1.00 42.48           C  
ATOM   5728  N   GLY C 251     -30.574  81.777  30.992  1.00 20.00           N  
ATOM   5729  CA  GLY C 251     -29.573  81.547  29.967  1.00 20.00           C  
ATOM   5730  C   GLY C 251     -29.183  80.134  29.580  1.00 20.00           C  
ATOM   5731  O   GLY C 251     -29.592  79.696  28.539  1.00 20.00           O  
ATOM   5732  N   GLY C 252     -28.333  79.455  30.372  1.00 20.00           N  
ATOM   5733  CA  GLY C 252     -27.565  78.271  29.961  1.00 20.00           C  
ATOM   5734  C   GLY C 252     -26.293  78.342  29.100  1.00 20.00           C  
ATOM   5735  O   GLY C 252     -26.192  79.117  28.191  1.00 20.00           O  
ATOM   5736  N   ARG C 253     -25.360  77.418  29.360  1.00 20.00           N  
ATOM   5737  CA  ARG C 253     -24.106  77.211  28.587  1.00 20.00           C  
ATOM   5738  C   ARG C 253     -23.930  75.786  28.059  1.00 20.00           C  
ATOM   5739  O   ARG C 253     -23.382  74.899  28.739  1.00 20.00           O  
ATOM   5740  CB  ARG C 253     -22.905  77.542  29.457  1.00 20.00           C  
ATOM   5741  CG  ARG C 253     -21.973  76.411  29.735  1.00 20.00           C  
ATOM   5742  CD  ARG C 253     -21.565  76.362  31.199  1.00 20.00           C  
ATOM   5743  NE  ARG C 253     -20.726  75.212  31.544  1.00 20.00           N  
ATOM   5744  CZ  ARG C 253     -19.741  75.233  32.449  1.00 20.00           C  
ATOM   5745  NH1 ARG C 253     -19.459  76.339  33.108  1.00 20.00           N  
ATOM   5746  NH2 ARG C 253     -19.042  74.149  32.712  1.00 20.00           N  
ATOM   5747  N   GLU C 254     -24.507  75.553  26.903  1.00 20.00           N  
ATOM   5748  CA  GLU C 254     -25.206  74.299  26.635  1.00 20.00           C  
ATOM   5749  C   GLU C 254     -24.560  73.732  25.395  1.00 20.00           C  
ATOM   5750  O   GLU C 254     -25.089  72.805  24.787  1.00 20.00           O  
ATOM   5751  CB  GLU C 254     -26.664  74.591  26.326  1.00 20.00           C  
ATOM   5752  CG  GLU C 254     -26.768  75.461  25.130  1.00 20.00           C  
ATOM   5753  CD  GLU C 254     -28.166  75.823  24.771  1.00 20.00           C  
ATOM   5754  OE1 GLU C 254     -29.069  75.486  25.572  1.00 20.00           O  
ATOM   5755  OE2 GLU C 254     -28.357  76.442  23.683  1.00 20.00           O  
ATOM   5756  N   GLN C 255     -23.332  74.125  25.096  1.00 20.00           N  
ATOM   5757  CA  GLN C 255     -22.371  73.129  24.622  1.00 20.00           C  
ATOM   5758  C   GLN C 255     -22.692  71.737  25.197  1.00 20.00           C  
ATOM   5759  O   GLN C 255     -23.299  70.893  24.537  1.00 20.00           O  
ATOM   5760  CB  GLN C 255     -20.954  73.542  24.987  1.00 20.00           C  
ATOM   5761  N   GLY C 256     -22.257  71.528  26.453  1.00 20.00           N  
ATOM   5762  CA  GLY C 256     -22.458  70.314  27.223  1.00 20.00           C  
ATOM   5763  C   GLY C 256     -23.549  69.436  26.643  1.00 20.00           C  
ATOM   5764  O   GLY C 256     -23.523  68.216  26.744  1.00 20.00           O  
TER    5765      GLY C 256                                                      
END
MOLECULE T0486_32_232.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37          
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38          
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70          
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10          
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93          
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74          
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85          
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52          
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98          
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20          
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12          
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44          
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76          
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22          
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88          
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19          
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16          
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96          
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90          
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60          
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42          
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04          
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80          
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60          
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72          
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90          
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12          
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50          
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34          
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08          
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98          
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83          
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38          
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75          
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55          
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93          
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57          
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02          
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96          
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11          
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60          
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34          
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07          
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41          
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20          
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68          
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69          
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47          
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71          
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50          
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89          
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00          
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56          
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50          
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27          
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41          
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43          
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76          
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82          
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67          
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57          
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80          
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33          
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93          
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93          
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82          
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78          
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15          
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38          
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92          
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12          
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46          
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32          
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91          
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72          
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36          
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80          
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87          
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53          
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42          
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29          
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56          
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21          
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49          
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12          
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15          
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41          
ATOM    177  CD  ILE    43     -27.448  94.223  14.517  1.00 10.50          
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46          
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28          
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83          
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01          
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37          
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76          
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54          
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79          
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47          
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91          
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61          
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62          
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83          
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07          
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00          
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31          
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09          
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78          
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25          
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97          
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17          
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97          
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93          
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48          
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23          
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43          
ATOM    234  CD  ILE    46     -25.395 104.142  22.715  1.00 16.72          
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84          
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86          
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65          
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12          
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92          
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43          
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15          
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51          
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23          
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54          
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26          
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61          
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28          
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00          
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01          
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34          
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02          
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61          
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00          
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54          
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42          
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18          
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35          
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03          
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55          
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37          
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55          
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36          
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36          
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58          
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76          
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99          
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55          
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89          
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83          
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67          
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65          
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99          
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27          
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59          
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04          
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46          
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43          
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83          
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90          
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95          
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04          
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00          
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27          
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34          
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68          
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09          
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62          
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41          
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15          
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39          
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49          
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24          
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47          
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32          
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47          
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75          
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96          
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60          
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42          
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25          
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54          
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50          
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41          
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53          
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60          
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75          
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70          
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45          
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17          
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76          
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81          
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14          
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32          
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51          
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32          
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23          
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89          
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28          
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00          
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16          
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91          
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44          
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04          
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02          
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07          
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63          
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85          
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18          
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08          
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91          
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31          
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05          
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20          
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29          
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34          
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50          
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33          
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25          
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30          
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56          
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09          
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39          
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42          
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30          
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87          
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95          
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26          
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67          
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86          
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50          
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05          
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43          
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64          
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44          
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71          
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89          
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69          
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86          
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70          
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18          
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85          
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45          
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19          
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09          
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16          
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99          
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16          
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71          
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48          
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11          
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90          
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94          
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77          
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75          
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13          
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27          
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28          
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72          
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12          
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44          
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60          
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61          
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10          
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81          
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04          
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45          
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57          
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02          
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66          
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55          
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80          
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36          
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20          
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85          
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35          
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94          
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79          
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43          
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76          
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98          
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92          
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43          
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46          
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12          
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47          
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25          
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17          
ATOM    620  CD  ILE    69     -21.812 104.999  25.889  1.00 15.75          
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24          
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01          
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70          
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44          
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51          
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02          
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56          
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10          
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31          
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99          
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34          
ATOM    650  N   HSD    71     -29.119 103.103  29.061  1.00 19.25          
ATOM    651  CA  HSD    71     -30.548 102.931  29.018  1.00 19.59          
ATOM    653  CB  HSD    71     -31.131 103.739  27.866  1.00 19.71          
ATOM    656  CG  HSD    71     -32.594 103.546  27.715  1.00 19.32          
ATOM    657  ND1 HSD    71     -33.145 102.695  26.782  1.00 19.54          
ATOM    659  CE1 HSD    71     -34.464 102.709  26.910  1.00 20.43          
ATOM    661  NE2 HSD    71     -34.779 103.515  27.909  1.00 19.47          
ATOM    663  CD2 HSD    71     -33.628 104.049  28.430  1.00 20.71          
ATOM    665  C   HSD    71     -30.896 101.469  28.799  1.00 20.07          
ATOM    666  O   HSD    71     -30.428 100.917  27.828  1.00 18.82          
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27          
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29          
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59          
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09          
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24          
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83          
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15          
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16          
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79          
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44          
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97          
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85          
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76          
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22          
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54          
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82          
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77          
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27          
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12          
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04          
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85          
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85          
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91          
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24          
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89          
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93          
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07          
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63          
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95          
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11          
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98          
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45          
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14          
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54          
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30          
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44          
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82          
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94          
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35          
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79          
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58          
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61          
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66          
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80          
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27          
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54          
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70          
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97          
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55          
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24          
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67          
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68          
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82          
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73          
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59          
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06          
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62          
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95          
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41          
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62          
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50          
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60          
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76          
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79          
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47          
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02          
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93          
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52          
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56          
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15          
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39          
ATOM    804  CD  ILE    81     -24.524  99.793  24.350  1.00 11.87          
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92          
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42          
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24          
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63          
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36          
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79          
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81          
ATOM    823  CD  ILE    82     -23.912  98.475  14.628  1.00 16.96          
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37          
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01          
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00          
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53          
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80          
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01          
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25          
ATOM    842  CD  ILE    83     -20.076 104.162  22.048  1.00 18.56          
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42          
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12          
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77          
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80          
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15          
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26          
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91          
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70          
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67          
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33          
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13          
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26          
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58          
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18          
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55          
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31          
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00          
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95          
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72          
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93          
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70          
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87          
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05          
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92          
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95          
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41          
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86          
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29          
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91          
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21          
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92          
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77          
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24          
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80          
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65          
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88          
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80          
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50          
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64          
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43          
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91          
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72          
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43          
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48          
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01          
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39          
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93          
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39          
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94          
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60          
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11          
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10          
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30          
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57          
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84          
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57          
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11          
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08          
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15          
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23          
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94          
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78          
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25          
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40          
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58          
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95          
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47          
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34          
ATOM    975  N   HSD    94     -13.252 117.343  23.149  1.00 19.02          
ATOM    976  CA  HSD    94     -13.913 118.258  24.010  1.00 18.65          
ATOM    978  CB  HSD    94     -13.212 118.340  25.388  1.00 18.04          
ATOM    981  CG  HSD    94     -13.222 117.059  26.144  1.00 17.83          
ATOM    982  ND1 HSD    94     -14.362 116.316  26.320  1.00 19.55          
ATOM    984  CE1 HSD    94     -14.074 115.230  27.024  1.00 19.25          
ATOM    986  NE2 HSD    94     -12.801 115.280  27.377  1.00 19.12          
ATOM    988  CD2 HSD    94     -12.241 116.403  26.821  1.00 20.68          
ATOM    990  C   HSD    94     -13.972 119.647  23.426  1.00 18.42          
ATOM    991  O   HSD    94     -13.158 120.042  22.633  1.00 17.03          
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61          
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31          
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16          
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32          
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64          
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08          
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37          
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35          
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38          
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46          
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82          
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57          
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98          
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21          
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43          
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95          
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91          
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00          
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56          
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92          
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08          
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41          
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52          
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48          
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64          
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13          
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89          
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08          
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54          
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91          
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23          
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69          
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39          
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44          
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57          
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88          
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81          
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91          
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10          
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60          
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08          
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98          
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61          
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62          
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09          
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66          
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75          
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40          
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75          
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54          
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95          
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65          
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16          
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26          
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97          
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85          
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24          
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48          
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28          
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28          
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17          
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37          
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64          
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75          
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36          
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79          
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97          
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27          
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37          
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59          
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51          
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69          
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46          
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92          
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77          
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10          
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66          
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90          
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12          
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60          
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31          
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56          
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52          
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52          
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48          
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75          
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33          
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71          
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38          
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17          
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80          
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17          
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03          
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77          
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59          
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31          
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79          
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16          
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38          
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07          
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22          
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26          
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97          
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44          
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92          
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19          
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10          
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19          
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43          
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44          
ATOM   1205  N   HSD   108     -14.322 122.108  34.838  1.00 16.53          
ATOM   1206  CA  HSD   108     -13.307 121.377  34.111  1.00 15.88          
ATOM   1208  CB  HSD   108     -11.916 121.949  34.329  1.00 16.59          
ATOM   1211  CG  HSD   108     -11.718 123.383  33.917  1.00 16.50          
ATOM   1212  ND1 HSD   108     -10.588 124.083  34.293  1.00 15.51          
ATOM   1214  CE1 HSD   108     -10.637 125.301  33.769  1.00 16.01          
ATOM   1216  NE2 HSD   108     -11.757 125.417  33.086  1.00 15.37          
ATOM   1218  CD2 HSD   108     -12.459 124.234  33.166  1.00 16.00          
ATOM   1220  C   HSD   108     -13.235 119.921  34.646  1.00 15.19          
ATOM   1221  O   HSD   108     -13.155 118.995  33.914  1.00 14.28          
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65          
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05          
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64          
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76          
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84          
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11          
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64          
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98          
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86          
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30          
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93          
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70          
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32          
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73          
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93          
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74          
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83          
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21          
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98          
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31          
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55          
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15          
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93          
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07          
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16          
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43          
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85          
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99          
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71          
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39          
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61          
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84          
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47          
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19          
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12          
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34          
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02          
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19          
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41          
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00          
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33          
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93          
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45          
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41          
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14          
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13          
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45          
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46          
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05          
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54          
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42          
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64          
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36          
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12          
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47          
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74          
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02          
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25          
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27          
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02          
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76          
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73          
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80          
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09          
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44          
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03          
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49          
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56          
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05          
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45          
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58          
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05          
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04          
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61          
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33          
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93          
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29          
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83          
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48          
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68          
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44          
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86          
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68          
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23          
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82          
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90          
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49          
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43          
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50          
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80          
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07          
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76          
ATOM   1409  N   HSD   121     -18.020 102.936  31.379  1.00 18.02          
ATOM   1410  CA  HSD   121     -19.310 102.326  31.191  1.00 16.84          
ATOM   1412  CB  HSD   121     -20.401 103.380  30.986  1.00 16.90          
ATOM   1415  CG  HSD   121     -20.886 104.029  32.249  1.00 15.18          
ATOM   1416  ND1 HSD   121     -21.278 103.309  33.350  1.00 17.39          
ATOM   1418  CE1 HSD   121     -21.695 104.137  34.298  1.00 19.88          
ATOM   1420  NE2 HSD   121     -21.639 105.370  33.820  1.00 19.45          
ATOM   1422  CD2 HSD   121     -21.103 105.327  32.553  1.00 15.34          
ATOM   1424  C   HSD   121     -19.233 101.442  29.958  1.00 17.12          
ATOM   1425  O   HSD   121     -19.898 100.408  29.892  1.00 17.67          
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86          
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65          
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30          
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20          
ATOM   1435  CD  ILE   122     -17.690 103.930  25.081  1.00 12.70          
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97          
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69          
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26          
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27          
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81          
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77          
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13          
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58          
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44          
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28          
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74          
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97          
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26          
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36          
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97          
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12          
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76          
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50          
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01          
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81          
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10          
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88          
ATOM   1504  N   HSD   125     -19.703  97.442  30.336  1.00 16.02          
ATOM   1505  CA  HSD   125     -21.006  97.198  29.804  1.00 15.87          
ATOM   1507  CB  HSD   125     -21.182  97.819  28.406  1.00 16.42          
ATOM   1510  CG  HSD   125     -22.595  98.294  28.145  1.00 17.72          
ATOM   1511  ND1 HSD   125     -23.591  97.471  27.649  1.00 20.32          
ATOM   1513  CE1 HSD   125     -24.728  98.144  27.578  1.00 20.03          
ATOM   1515  NE2 HSD   125     -24.512  99.385  27.985  1.00 17.52          
ATOM   1517  CD2 HSD   125     -23.184  99.504  28.354  1.00 18.22          
ATOM   1519  C   HSD   125     -21.288  95.703  29.677  1.00 17.08          
ATOM   1520  O   HSD   125     -20.352  94.926  29.505  1.00 17.32          
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94          
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53          
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78          
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31          
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45          
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77          
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83          
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26          
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48          
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44          
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02          
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24          
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76          
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29          
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02          
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57          
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89          
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79          
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73          
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69          
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31          
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44          
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97          
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20          
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24          
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88          
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07          
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83          
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20          
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93          
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69          
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43          
ATOM   1590  CD  ILE   130     -19.975  95.634  16.659  1.00 15.03          
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90          
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42          
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47          
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18          
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55          
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89          
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09          
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65          
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32          
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93          
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98          
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51          
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40          
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32          
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19          
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29          
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14          
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83          
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70          
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23          
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76          
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21          
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77          
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70          
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80          
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10          
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58          
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83          
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19          
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29          
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58          
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25          
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79          
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04          
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93          
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81          
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63          
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59          
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05          
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99          
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77          
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44          
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39          
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97          
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20          
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24          
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75          
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76          
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53          
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52          
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69          
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82          
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09          
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59          
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31          
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84          
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64          
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76          
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52          
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92          
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51          
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46          
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96          
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99          
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32          
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55          
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29          
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38          
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86          
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34          
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07          
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75          
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27          
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69          
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11          
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10          
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70          
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37          
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50          
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66          
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03          
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30          
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94          
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30          
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72          
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83          
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53          
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08          
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29          
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43          
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09          
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00          
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98          
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78          
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20          
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90          
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21          
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76          
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27          
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28          
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65          
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90          
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55          
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77          
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98          
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16          
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86          
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51          
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07          
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98          
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13          
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71          
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29          
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48          
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21          
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90          
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56          
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21          
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52          
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68          
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98          
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31          
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93          
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16          
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57          
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31          
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77          
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91          
ATOM   1850  CD  ILE   150     -16.059  93.224  18.301  1.00 13.77          
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56          
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95          
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22          
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47          
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55          
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16          
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59          
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67          
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17          
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54          
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14          
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83          
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37          
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05          
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86          
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38          
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80          
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60          
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53          
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86          
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43          
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76          
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71          
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86          
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98          
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86          
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20          
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53          
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70          
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16          
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18          
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33          
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69          
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26          
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70          
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36          
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32          
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72          
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34          
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53          
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70          
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12          
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94          
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93          
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77          
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82          
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81          
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72          
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23          
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89          
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21          
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57          
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65          
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60          
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35          
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31          
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16          
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50          
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84          
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81          
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96          
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89          
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53          
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37          
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23          
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55          
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91          
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63          
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32          
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81          
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16          
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40          
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46          
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70          
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82          
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62          
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93          
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89          
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68          
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50          
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91          
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72          
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02          
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71          
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59          
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57          
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24          
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04          
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72          
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79          
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89          
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65          
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97          
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86          
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61          
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93          
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04          
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55          
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16          
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81          
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41          
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60          
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76          
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72          
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92          
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58          
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92          
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18          
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71          
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26          
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86          
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52          
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88          
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87          
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70          
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15          
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27          
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54          
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01          
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44          
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90          
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66          
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16          
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84          
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52          
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49          
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77          
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12          
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77          
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20          
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08          
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90          
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86          
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35          
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41          
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88          
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34          
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15          
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88          
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10          
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47          
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97          
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81          
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21          
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85          
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57          
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91          
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21          
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99          
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90          
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58          
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24          
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96          
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79          
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93          
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71          
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71          
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35          
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61          
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27          
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70          
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44          
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28          
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27          
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76          
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71          
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70          
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32          
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63          
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93          
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71          
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13          
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80          
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01          
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04          
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17          
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93          
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60          
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99          
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86          
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70          
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41          
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61          
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97          
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02          
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58          
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50          
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24          
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17          
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68          
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53          
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34          
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74          
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81          
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74          
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14          
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19          
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79          
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40          
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16          
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66          
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32          
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90          
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18          
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33          
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22          
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85          
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98          
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73          
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22          
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16          
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82          
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19          
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75          
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53          
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09          
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60          
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83          
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62          
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44          
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38          
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77          
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09          
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29          
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27          
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69          
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43          
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30          
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18          
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34          
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19          
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56          
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75          
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21          
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47          
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16          
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42          
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21          
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28          
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20          
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76          
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98          
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73          
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89          
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72          
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67          
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27          
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47          
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23          
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39          
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13          
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68          
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98          
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33          
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86          
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26          
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79          
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07          
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86          
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26          
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66          
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77          
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44          
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65          
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68          
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00          
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10          
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11          
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67          
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76          
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05          
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41          
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18          
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20          
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16          
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74          
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46          
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26          
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76          
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20          
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62          
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41          
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41          
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31          
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82          
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38          
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20          
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67          
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51          
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34          
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42          
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47          
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04          
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04          
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78          
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16          
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89          
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82          
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98          
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48          
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50          
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91          
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16          
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21          
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47          
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68          
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01          
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76          
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80          
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11          
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74          
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22          
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60          
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67          
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15          
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69          
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86          
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80          
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58          
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77          
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58          
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63          
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84          
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45          
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39          
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65          
ATOM   2517  CD  ILE   196      -2.544 105.621  14.499  1.00 11.63          
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20          
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62          
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49          
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08          
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10          
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64          
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41          
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85          
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13          
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74          
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91          
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76          
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33          
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30          
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46          
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62          
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95          
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74          
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57          
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03          
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76          
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07          
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01          
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39          
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75          
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59          
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47          
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04          
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16          
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47          
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53          
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24          
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46          
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81          
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82          
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05          
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65          
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15          
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60          
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11          
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17          
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30          
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93          
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80          
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48          
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59          
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35          
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94          
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00          
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89          
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89          
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20          
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33          
ATOM   2629  N   HSD   204      -1.273  98.900  13.907  1.00 17.02          
ATOM   2630  CA  HSD   204      -0.728  99.131  15.234  1.00 17.25          
ATOM   2632  CB  HSD   204      -0.203 100.553  15.369  1.00 16.74          
ATOM   2635  CG  HSD   204       1.093 100.729  14.676  1.00 18.87          
ATOM   2636  ND1 HSD   204       2.157  99.882  14.902  1.00 22.98          
ATOM   2638  CE1 HSD   204       3.153 100.212  14.106  1.00 21.31          
ATOM   2640  NE2 HSD   204       2.756 101.220  13.350  1.00 20.85          
ATOM   2642  CD2 HSD   204       1.477 101.566  13.687  1.00 18.98          
ATOM   2644  C   HSD   204      -1.654  98.782  16.358  1.00 16.73          
ATOM   2645  O   HSD   204      -1.243  98.784  17.497  1.00 18.93          
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80          
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30          
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34          
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11          
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87          
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55          
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16          
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78          
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82          
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60          
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99          
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65          
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78          
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16          
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90          
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55          
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59          
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65          
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12          
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49          
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66          
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66          
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97          
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76          
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17          
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84          
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33          
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92          
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35          
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64          
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11          
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47          
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65          
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36          
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46          
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08          
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57          
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71          
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35          
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35          
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68          
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03          
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64          
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09          
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09          
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13          
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98          
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77          
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73          
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06          
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19          
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82          
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04          
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13          
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76          
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33          
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25          
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79          
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02          
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18          
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14          
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50          
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21          
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38          
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43          
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19          
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15          
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33          
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74          
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74          
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29          
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39          
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99          
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86          
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03          
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52          
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48          
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50          
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73          
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86          
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44          
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79          
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12          
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83          
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01          
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22          
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13          
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03          
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43          
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69          
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96          
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30          
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19          
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41          
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28          
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33          
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93          
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99          
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20          
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40          
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43          
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00          
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45          
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20          
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78          
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03          
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56          
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48          
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49          
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58          
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57          
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06          
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74          
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10          
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51          
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78          
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27          
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78          
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86          
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39          
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62          
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50          
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34          
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93          
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23          
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57          
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33          
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15          
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60          
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61          
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05          
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43          
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56          
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18          
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51          
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92          
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49          
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66          
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99          
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12          
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21          
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43          
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78          
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99          
ATOM   2940  CD  ILE   223     -16.388  93.920  13.040  1.00 15.84          
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85          
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64          
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90          
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31          
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78          
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62          
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91          
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13          
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23          
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23          
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86          
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23          
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65          
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44          
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85          
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04          
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54          
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34          
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15          
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65          
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61          
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11          
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61          
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54          
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02          
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57          
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66          
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10          
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72          
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33          
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82          
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84          
ATOM   3015  CD  ILE   227     -19.874  91.755  18.995  1.00  9.69          
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42          
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80          
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94          
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71          
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02          
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51          
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09          
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60          
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04          
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66          
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33          
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00          
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70          
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93          
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97          
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95          
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31          
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28          
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01          
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08          
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72          
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55          
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96          
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31          
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96          
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33          
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36          
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12          
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66          
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70          
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46          
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14          
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44          
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71          
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46          
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91          
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29          
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71          
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88          
END
