
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  253 ( 1974),  selected  253 , name 2iex_A
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2iex_A.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    W     5_A      -       -           -
LGA    V     6_A      -       -           -
LGA    K     7_A      -       -           -
LGA    Q     8_A      -       -           -
LGA    Y     9_A      -       -           -
LGA    D    10_A      -       -           -
LGA    Y    11_A      P      32           #
LGA    E    12_A      R      33          0.914
LGA    D    13_A      P      34          0.724
LGA    I    14_A      T      35          0.718
LGA    I    15_A      S      36          0.345
LGA    Y    16_A      A      37          0.597
LGA    E    17_A      R      38          0.697
LGA    T    18_A      Q      39          1.180
LGA    Y    19_A      L      40          1.518
LGA    N    20_A      D      41          0.813
LGA    G    21_A      G      42          0.796
LGA    I    22_A      I      43          0.354
LGA    A    23_A      R      44          0.241
LGA    K    24_A      N      45          0.394
LGA    I    25_A      I      46          0.381
LGA    T    26_A      V      47          0.664
LGA    I    27_A      L      48          0.831
LGA    N    28_A      S      49          0.783
LGA    R    29_A      N      50          1.076
LGA    P    30_A      P      51          0.767
LGA    E    31_A      K      52          0.854
LGA    V    32_A      K      53          1.798
LGA    H    33_A      R      54          1.325
LGA    N    34_A      N      55          1.117
LGA    A    35_A      T      56          1.002
LGA    F    36_A      L      57          1.684
LGA    R    37_A      S      58          0.869
LGA    P    38_A      L      59          0.523
LGA    K    39_A      A      60          0.757
LGA    T    40_A      M      61          1.144
LGA    V    41_A      L      62          0.741
LGA    N    42_A      K      63          0.563
LGA    E    43_A      S      64          0.834
LGA    M    44_A      L      65          0.820
LGA    I    45_A      Q      66          0.875
LGA    D    46_A      S      67          0.957
LGA    A    47_A      D      68          0.531
LGA    F    48_A      I      69          0.401
LGA    T    49_A      L      70          0.605
LGA    K    50_A      H      71          1.285
LGA    A    51_A      D      72           #
LGA    R    52_A      A      73          1.588
LGA    D    53_A      D      74          2.701
LGA    D    54_A      S      75          2.918
LGA    S    55_A      N      76          1.699
LGA    N    56_A      D      77          0.622
LGA    I    57_A      L      78          1.311
LGA    G    58_A      K      79          0.679
LGA    V    59_A      V      80          0.629
LGA    I    60_A      I      81          0.307
LGA    I    61_A      I      82          0.251
LGA    L    62_A      I      83          0.261
LGA    T    63_A      S      84          0.763
LGA    G    64_A      A      85          0.710
LGA    A    65_A      E      86          0.808
LGA    G    66_A      G      87          1.054
LGA    G    67_A      -       -           -
LGA    K    68_A      P      88          0.936
LGA    A    69_A      V      89          1.517
LGA    F    70_A      F      90          1.247
LGA    C    71_A      S      91          1.094
LGA    S    72_A      S      92          1.127
LGA    G    73_A      G      93          0.671
LGA    G    74_A      H      94          1.237
LGA    D    75_A      D      95          0.715
LGA    -       -      L      96           -
LGA    -       -      K      97           -
LGA    -       -      E      98           -
LGA    -       -      L      99           -
LGA    -       -      T     100           -
LGA    -       -      E     101           -
LGA    -       -      E     102           -
LGA    -       -      Q     103           -
LGA    -       -      G     104           -
LGA    -       -      R     105           -
LGA    -       -      D     106           -
LGA    -       -      Y     107           -
LGA    P    91_A      H     108          2.873
LGA    -       -      A     109           -
LGA    R    92_A      E     110          1.800
LGA    L    93_A      V     111          2.210
LGA    -       -      F     112           -
LGA    -       -      Q     113           -
LGA    N    94_A      T     114          1.210
LGA    V    95_A      C     115          0.857
LGA    L    96_A      S     116          0.997
LGA    D    97_A      K     117          1.044
LGA    L    98_A      V     118          0.409
LGA    Q    99_A      M     119          0.562
LGA    R   100_A      M     120          0.683
LGA    L   101_A      H     121          0.541
LGA    I   102_A      I     122          0.625
LGA    R   103_A      R     123          0.651
LGA    V   104_A      N     124          0.665
LGA    I   105_A      H     125          0.422
LGA    P   106_A      P     126          1.626
LGA    K   107_A      V     127          0.892
LGA    P   108_A      P     128          0.757
LGA    V   109_A      V     129          0.438
LGA    I   110_A      I     130          0.338
LGA    A   111_A      A     131          0.120
LGA    M   112_A      M     132          0.263
LGA    V   113_A      V     133          0.224
LGA    A   114_A      N     134          0.677
LGA    G   115_A      G     135          0.603
LGA    Y   116_A      L     136          1.128
LGA    A   117_A      A     137          0.855
LGA    I   118_A      T     138          0.633
LGA    G   119_A      A     139          0.746
LGA    G   120_A      A     140          0.319
LGA    G   121_A      G     141          0.364
LGA    H   122_A      C     142          0.233
LGA    V   123_A      Q     143          0.275
LGA    L   124_A      L     144          0.324
LGA    H   125_A      V     145          0.388
LGA    V   126_A      A     146          0.449
LGA    V   127_A      S     147          0.665
LGA    C   128_A      C     148          0.316
LGA    D   129_A      D     149          0.328
LGA    L   130_A      I     150          0.668
LGA    T   131_A      A     151          0.466
LGA    I   132_A      V     152          0.334
LGA    A   133_A      A     153          0.287
LGA    A   134_A      S     154          0.631
LGA    D   135_A      D     155          1.397
LGA    N   136_A      K     156          1.531
LGA    A   137_A      S     157          0.810
LGA    I   138_A      S     158          1.381
LGA    F   139_A      F     159          0.521
LGA    G   140_A      A     160          0.957
LGA    Q   141_A      T     161          0.775
LGA    T   142_A      P     162          1.697
LGA    G   143_A      G     163          1.623
LGA    P   144_A      V     164          1.802
LGA    K   145_A      N     165          1.881
LGA    V   146_A      V     166          1.857
LGA    G   147_A      G     167          2.778
LGA    S   148_A      L     168          2.603
LGA    F   149_A      F     169          3.849
LGA    -       -      C     170           -
LGA    D   150_A      S     171          2.737
LGA    G   151_A      T     172          4.235
LGA    G   152_A      -       -           -
LGA    Y   153_A      -       -           -
LGA    G   154_A      P     173          3.044
LGA    A   155_A      G     174          2.590
LGA    G   156_A      V     175          4.196
LGA    Y   157_A      A     176          3.884
LGA    L   158_A      L     177          2.278
LGA    A   159_A      A     178          2.454
LGA    R   160_A      R     179          2.873
LGA    I   161_A      A     180          2.365
LGA    V   162_A      V     181          1.494
LGA    G   163_A      P     182          1.643
LGA    H   164_A      R     183          1.397
LGA    K   165_A      K     184          1.228
LGA    K   166_A      V     185          1.129
LGA    A   167_A      A     186          1.390
LGA    R   168_A      L     187          1.370
LGA    E   169_A      E     188          1.548
LGA    I   170_A      M     189          1.581
LGA    W   171_A      L     190          1.091
LGA    Y   172_A      F     191          1.224
LGA    L   173_A      T     192          1.159
LGA    C   174_A      G     193          1.063
LGA    R   175_A      E     194          0.467
LGA    Q   176_A      P     195          0.754
LGA    Y   177_A      I     196          1.332
LGA    T   178_A      S     197          1.382
LGA    A   179_A      A     198          1.200
LGA    Q   180_A      Q     199          1.058
LGA    E   181_A      E     200          1.480
LGA    A   182_A      A     201          1.219
LGA    L   183_A      L     202          1.033
LGA    E   184_A      L     203          1.499
LGA    M   185_A      H     204          1.278
LGA    G   186_A      G     205          1.795
LGA    L   187_A      L     206          1.078
LGA    V   188_A      L     207          0.605
LGA    N   189_A      S     208          0.985
LGA    K   190_A      K     209          0.958
LGA    V   191_A      V     210          1.029
LGA    V   192_A      V     211          1.214
LGA    P   193_A      P     212          1.386
LGA    L   194_A      E     213          1.249
LGA    E   195_A      A     214          2.277
LGA    Q   196_A      E     215          2.206
LGA    L   197_A      L     216          1.261
LGA    E   198_A      Q     217          1.182
LGA    E   199_A      E     218          1.402
LGA    E   200_A      E     219          1.020
LGA    T   201_A      T     220          0.529
LGA    V   202_A      M     221          0.783
LGA    K   203_A      R     222          1.078
LGA    W   204_A      I     223          0.933
LGA    A   205_A      A     224          0.422
LGA    Q   206_A      R     225          0.795
LGA    E   207_A      K     226          1.201
LGA    I   208_A      I     227          1.320
LGA    L   209_A      A     228          1.708
LGA    E   210_A      S     229          2.481
LGA    K   211_A      L     230          2.582
LGA    S   212_A      S     231          3.048
LGA    P   213_A      R     232          2.387
LGA    T   214_A      P     233          2.686
LGA    A   215_A      V     234          2.869
LGA    I   216_A      V     235          1.993
LGA    R   217_A      S     236          1.896
LGA    F   218_A      L     237          2.555
LGA    L   219_A      G     238          2.667
LGA    K   220_A      K     239          1.821
LGA    A   221_A      A     240          1.906
LGA    A   222_A      T     241          2.943
LGA    F   223_A      F     242          3.105
LGA    N   224_A      Y     243          1.990
LGA    A   225_A      K     244          2.297
LGA    -       -      Q     245           -
LGA    D   226_A      L     246          1.780
LGA    S   227_A      P     247          3.666
LGA    D   228_A      Q     248           #
LGA    G   229_A      D     249           -
LGA    L   230_A      L     250           -
LGA    A   231_A      G     251           -
LGA    G   232_A      T     252           -
LGA    I   233_A      A     253           -
LGA    Q   234_A      Y     254           -
LGA    Q   235_A      Y     255           -
LGA    L   236_A      L     256           #
LGA    A   237_A      T     257           -
LGA    G   238_A      S     258           -
LGA    D   239_A      Q     259           -
LGA    A   240_A      A     260          6.762
LGA    T   241_A      M     261           -
LGA    L   242_A      V     262           -
LGA    L   243_A      D     263          6.652
LGA    F   244_A      N     264           -
LGA    Y   245_A      L     265           -
LGA    T   246_A      -       -           -
LGA    T   247_A      A     266          7.178
LGA    E   248_A      L     267           -
LGA    E   249_A      R     268           -
LGA    A   250_A      D     269           -
LGA    K   251_A      G     270           -
LGA    E   252_A      Q     271           -
LGA    G   253_A      E     272           -
LGA    M   254_A      G     273           -
LGA    R   255_A      I     274           -
LGA    A   256_A      T     275           -
LGA    F   257_A      A     276           -
LGA    K   258_A      F     277           -
LGA    E   259_A      L     278           -
LGA    K   260_A      Q     279           -
LGA    R   261_A      K     280           -
LGA    K   262_A      R     281           -
LGA    P   263_A      K     282           -
LGA    D   264_A      P     283           -
LGA    F   265_A      V     284           -
LGA    S   266_A      W     285           -
LGA    Q   267_A      S     286           -
LGA    F   268_A      H     287           -
LGA    P   269_A      -       -           -
LGA    R   270_A      -       -           -
LGA    F   271_A      -       -           -
LGA    P   272_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  253  256    5.0    200    1.72    32.50     72.646    10.997

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.431298 * X  +   0.902169 * Y  +  -0.008508 * Z  + -13.409641
  Y_new =  -0.886171 * X  +  -0.421842 * Y  +   0.191704 * Z  + 136.993271
  Z_new =   0.169361 * X  +   0.090221 * Y  +   0.981416 * Z  +  -3.054533 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.091672   -3.049921  [ DEG:     5.2524   -174.7476 ]
  Theta =  -0.170181   -2.971412  [ DEG:    -9.7506   -170.2494 ]
  Phi   =  -2.023746    1.117846  [ DEG:  -115.9521     64.0479 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2iex_A                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2iex_A.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  253  256   5.0  200   1.72   32.50  72.646
REMARK  ---------------------------------------------------------- 
MOLECULE 2iex_A
HEADER    LYASE                                   19-SEP-06   2IEX              
TITLE     CRYSTAL STRUCTURE OF DIHYDROXYNAPTHOIC ACID SYNTHETASE                
TITLE    2 (GK2873) FROM GEOBACILLUS KAUSTOPHILUS HTA426                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DIHYDROXYNAPTHOIC ACID SYNTHETASE;                         
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: NAPHTHOATE SYNTHASE;                                        
COMPND   5 EC: 4.1.3.36;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: GEOBACILLUS KAUSTOPHILUS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HTA426;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL-21 CODONPLUS(DE3)-RIL;                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    CROTONASE-LIKE FAMILY, BETA-BETA-ALPHA, COENZYME                      
KEYWDS   2 BIOSYNTHESES, NAPHTHOATE SYNTHASE, STRUCTURAL GENOMICS,              
KEYWDS   3 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   4 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   5 INITIATIVE, RSGI, LYASE                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.JEYAKANTHAN,S.P.KANAUJIA,C.VASUKI RANJANI,K.SEKAR,S.BABA,           
AUTHOR   2 A.EBIHARA,S.KURAMITSU,A.SHINKAI,Y.SHIRO,S.YOKOYAMA,RIKEN             
AUTHOR   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   02-OCT-07 2IEX    0                                                
JRNL        AUTH   J.JEYAKANTHAN,S.P.KANAUJIA,C.VASUKI RANJANI,                 
JRNL        AUTH 2 K.SEKAR,S.BABA,A.EBIHARA,S.KURAMITSU,A.SHINKAI,              
JRNL        AUTH 3 Y.SHIRO,S.YOKOYAMA                                           
JRNL        TITL   CRYSTAL STRUCTURE OF DIHYDROXYNAPTHOIC ACID                  
JRNL        TITL 2 SYNTHETASE (GK2873) FROM GEOBACILLUS KAUSTOPHILUS            
JRNL        TITL 3 HTA426                                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2IEX A    1   272  UNP    Q5KVX8   Q5KVX8_GEOKA     1    272             
DBREF  2IEX B    1   272  UNP    Q5KVX8   Q5KVX8_GEOKA     1    272             
DBREF  2IEX C    1   272  UNP    Q5KVX8   Q5KVX8_GEOKA     1    272             
SEQRES   1 A  272  MET PRO PHE GLU TRP VAL LYS GLN TYR ASP TYR GLU ASP          
SEQRES   2 A  272  ILE ILE TYR GLU THR TYR ASN GLY ILE ALA LYS ILE THR          
SEQRES   3 A  272  ILE ASN ARG PRO GLU VAL HIS ASN ALA PHE ARG PRO LYS          
SEQRES   4 A  272  THR VAL ASN GLU MET ILE ASP ALA PHE THR LYS ALA ARG          
SEQRES   5 A  272  ASP ASP SER ASN ILE GLY VAL ILE ILE LEU THR GLY ALA          
SEQRES   6 A  272  GLY GLY LYS ALA PHE CYS SER GLY GLY ASP GLN LYS VAL          
SEQRES   7 A  272  ARG GLY HIS GLY GLY TYR VAL GLY GLU ASP GLU ILE PRO          
SEQRES   8 A  272  ARG LEU ASN VAL LEU ASP LEU GLN ARG LEU ILE ARG VAL          
SEQRES   9 A  272  ILE PRO LYS PRO VAL ILE ALA MET VAL ALA GLY TYR ALA          
SEQRES  10 A  272  ILE GLY GLY GLY HIS VAL LEU HIS VAL VAL CYS ASP LEU          
SEQRES  11 A  272  THR ILE ALA ALA ASP ASN ALA ILE PHE GLY GLN THR GLY          
SEQRES  12 A  272  PRO LYS VAL GLY SER PHE ASP GLY GLY TYR GLY ALA GLY          
SEQRES  13 A  272  TYR LEU ALA ARG ILE VAL GLY HIS LYS LYS ALA ARG GLU          
SEQRES  14 A  272  ILE TRP TYR LEU CYS ARG GLN TYR THR ALA GLN GLU ALA          
SEQRES  15 A  272  LEU GLU MET GLY LEU VAL ASN LYS VAL VAL PRO LEU GLU          
SEQRES  16 A  272  GLN LEU GLU GLU GLU THR VAL LYS TRP ALA GLN GLU ILE          
SEQRES  17 A  272  LEU GLU LYS SER PRO THR ALA ILE ARG PHE LEU LYS ALA          
SEQRES  18 A  272  ALA PHE ASN ALA ASP SER ASP GLY LEU ALA GLY ILE GLN          
SEQRES  19 A  272  GLN LEU ALA GLY ASP ALA THR LEU LEU PHE TYR THR THR          
SEQRES  20 A  272  GLU GLU ALA LYS GLU GLY MET ARG ALA PHE LYS GLU LYS          
SEQRES  21 A  272  ARG LYS PRO ASP PHE SER GLN PHE PRO ARG PHE PRO              
SEQRES   1 B  272  MET PRO PHE GLU TRP VAL LYS GLN TYR ASP TYR GLU ASP          
SEQRES   2 B  272  ILE ILE TYR GLU THR TYR ASN GLY ILE ALA LYS ILE THR          
SEQRES   3 B  272  ILE ASN ARG PRO GLU VAL HIS ASN ALA PHE ARG PRO LYS          
SEQRES   4 B  272  THR VAL ASN GLU MET ILE ASP ALA PHE THR LYS ALA ARG          
SEQRES   5 B  272  ASP ASP SER ASN ILE GLY VAL ILE ILE LEU THR GLY ALA          
SEQRES   6 B  272  GLY GLY LYS ALA PHE CYS SER GLY GLY ASP GLN LYS VAL          
SEQRES   7 B  272  ARG GLY HIS GLY GLY TYR VAL GLY GLU ASP GLU ILE PRO          
SEQRES   8 B  272  ARG LEU ASN VAL LEU ASP LEU GLN ARG LEU ILE ARG VAL          
SEQRES   9 B  272  ILE PRO LYS PRO VAL ILE ALA MET VAL ALA GLY TYR ALA          
SEQRES  10 B  272  ILE GLY GLY GLY HIS VAL LEU HIS VAL VAL CYS ASP LEU          
SEQRES  11 B  272  THR ILE ALA ALA ASP ASN ALA ILE PHE GLY GLN THR GLY          
SEQRES  12 B  272  PRO LYS VAL GLY SER PHE ASP GLY GLY TYR GLY ALA GLY          
SEQRES  13 B  272  TYR LEU ALA ARG ILE VAL GLY HIS LYS LYS ALA ARG GLU          
SEQRES  14 B  272  ILE TRP TYR LEU CYS ARG GLN TYR THR ALA GLN GLU ALA          
SEQRES  15 B  272  LEU GLU MET GLY LEU VAL ASN LYS VAL VAL PRO LEU GLU          
SEQRES  16 B  272  GLN LEU GLU GLU GLU THR VAL LYS TRP ALA GLN GLU ILE          
SEQRES  17 B  272  LEU GLU LYS SER PRO THR ALA ILE ARG PHE LEU LYS ALA          
SEQRES  18 B  272  ALA PHE ASN ALA ASP SER ASP GLY LEU ALA GLY ILE GLN          
SEQRES  19 B  272  GLN LEU ALA GLY ASP ALA THR LEU LEU PHE TYR THR THR          
SEQRES  20 B  272  GLU GLU ALA LYS GLU GLY MET ARG ALA PHE LYS GLU LYS          
SEQRES  21 B  272  ARG LYS PRO ASP PHE SER GLN PHE PRO ARG PHE PRO              
SEQRES   1 C  272  MET PRO PHE GLU TRP VAL LYS GLN TYR ASP TYR GLU ASP          
SEQRES   2 C  272  ILE ILE TYR GLU THR TYR ASN GLY ILE ALA LYS ILE THR          
SEQRES   3 C  272  ILE ASN ARG PRO GLU VAL HIS ASN ALA PHE ARG PRO LYS          
SEQRES   4 C  272  THR VAL ASN GLU MET ILE ASP ALA PHE THR LYS ALA ARG          
SEQRES   5 C  272  ASP ASP SER ASN ILE GLY VAL ILE ILE LEU THR GLY ALA          
SEQRES   6 C  272  GLY GLY LYS ALA PHE CYS SER GLY GLY ASP GLN LYS VAL          
SEQRES   7 C  272  ARG GLY HIS GLY GLY TYR VAL GLY GLU ASP GLU ILE PRO          
SEQRES   8 C  272  ARG LEU ASN VAL LEU ASP LEU GLN ARG LEU ILE ARG VAL          
SEQRES   9 C  272  ILE PRO LYS PRO VAL ILE ALA MET VAL ALA GLY TYR ALA          
SEQRES  10 C  272  ILE GLY GLY GLY HIS VAL LEU HIS VAL VAL CYS ASP LEU          
SEQRES  11 C  272  THR ILE ALA ALA ASP ASN ALA ILE PHE GLY GLN THR GLY          
SEQRES  12 C  272  PRO LYS VAL GLY SER PHE ASP GLY GLY TYR GLY ALA GLY          
SEQRES  13 C  272  TYR LEU ALA ARG ILE VAL GLY HIS LYS LYS ALA ARG GLU          
SEQRES  14 C  272  ILE TRP TYR LEU CYS ARG GLN TYR THR ALA GLN GLU ALA          
SEQRES  15 C  272  LEU GLU MET GLY LEU VAL ASN LYS VAL VAL PRO LEU GLU          
SEQRES  16 C  272  GLN LEU GLU GLU GLU THR VAL LYS TRP ALA GLN GLU ILE          
SEQRES  17 C  272  LEU GLU LYS SER PRO THR ALA ILE ARG PHE LEU LYS ALA          
SEQRES  18 C  272  ALA PHE ASN ALA ASP SER ASP GLY LEU ALA GLY ILE GLN          
SEQRES  19 C  272  GLN LEU ALA GLY ASP ALA THR LEU LEU PHE TYR THR THR          
SEQRES  20 C  272  GLU GLU ALA LYS GLU GLY MET ARG ALA PHE LYS GLU LYS          
SEQRES  21 C  272  ARG LYS PRO ASP PHE SER GLN PHE PRO ARG PHE PRO              
FORMUL   4  HOH   *726(H2 O)                                                    
CRYST1   77.013  130.658  131.686  90.00  90.00  90.00 C 2 2 21     24          
ATOM      1  N   TRP A   5     -33.486 100.951  11.399  1.00 65.56           N  
ATOM      2  CA  TRP A   5     -33.286 101.500  12.771  1.00 69.88           C  
ATOM      3  C   TRP A   5     -34.562 102.156  13.277  1.00 72.45           C  
ATOM      4  O   TRP A   5     -35.219 102.898  12.548  1.00 74.52           O  
ATOM      5  CB  TRP A   5     -32.155 102.531  12.775  1.00 68.44           C  
ATOM      6  CG  TRP A   5     -30.852 102.008  12.249  1.00 69.48           C  
ATOM      7  CD1 TRP A   5     -30.319 102.230  11.014  1.00 64.05           C  
ATOM      8  CD2 TRP A   5     -29.921 101.167  12.944  1.00 67.87           C  
ATOM      9  NE1 TRP A   5     -29.113 101.583  10.895  1.00 63.16           N  
ATOM     10  CE2 TRP A   5     -28.845 100.922  12.063  1.00 65.51           C  
ATOM     11  CE3 TRP A   5     -29.894 100.596  14.224  1.00 62.21           C  
ATOM     12  CZ2 TRP A   5     -27.747 100.131  12.424  1.00 63.81           C  
ATOM     13  CZ3 TRP A   5     -28.803  99.810  14.581  1.00 64.34           C  
ATOM     14  CH2 TRP A   5     -27.744  99.585  13.682  1.00 63.11           C  
ATOM     15  N   VAL A   6     -34.902 101.890  14.533  1.00 71.46           N  
ATOM     16  CA  VAL A   6     -36.109 102.446  15.135  1.00 69.85           C  
ATOM     17  C   VAL A   6     -35.778 103.483  16.206  1.00 68.58           C  
ATOM     18  O   VAL A   6     -35.475 103.115  17.337  1.00 67.29           O  
ATOM     19  CB  VAL A   6     -36.949 101.329  15.793  1.00 72.01           C  
ATOM     20  CG1 VAL A   6     -38.258 101.893  16.308  1.00 73.89           C  
ATOM     21  CG2 VAL A   6     -37.194 100.207  14.800  1.00 75.87           C  
ATOM     22  N   LYS A   7     -35.831 104.771  15.864  1.00 69.33           N  
ATOM     23  CA  LYS A   7     -35.532 105.815  16.851  1.00 69.60           C  
ATOM     24  C   LYS A   7     -36.302 105.487  18.136  1.00 71.29           C  
ATOM     25  O   LYS A   7     -37.524 105.626  18.189  1.00 72.06           O  
ATOM     26  CB  LYS A   7     -35.939 107.191  16.319  1.00 64.52           C  
ATOM     27  CG  LYS A   7     -34.784 108.182  16.200  1.00 60.12           C  
ATOM     28  CD  LYS A   7     -35.074 109.470  16.962  1.00 59.50           C  
ATOM     29  CE  LYS A   7     -34.168 110.609  16.506  1.00 60.84           C  
ATOM     30  NZ  LYS A   7     -34.423 111.882  17.249  1.00 63.60           N  
ATOM     31  N   GLN A   8     -35.565 105.073  19.168  1.00 74.64           N  
ATOM     32  CA  GLN A   8     -36.134 104.632  20.450  1.00 74.53           C  
ATOM     33  C   GLN A   8     -36.555 105.613  21.538  1.00 71.33           C  
ATOM     34  O   GLN A   8     -37.506 105.344  22.274  1.00 70.28           O  
ATOM     35  CB  GLN A   8     -35.186 103.624  21.092  1.00 81.91           C  
ATOM     36  CG  GLN A   8     -35.899 102.545  21.865  1.00 90.15           C  
ATOM     37  CD  GLN A   8     -35.565 101.171  21.337  1.00 95.90           C  
ATOM     38  OE1 GLN A   8     -35.596 100.936  20.130  1.00 98.56           O  
ATOM     39  NE2 GLN A   8     -35.248 100.250  22.239  1.00 98.07           N  
ATOM     40  N   TYR A   9     -35.835 106.716  21.681  1.00 68.84           N  
ATOM     41  CA  TYR A   9     -36.156 107.706  22.705  1.00 66.58           C  
ATOM     42  C   TYR A   9     -35.922 109.077  22.092  1.00 68.64           C  
ATOM     43  O   TYR A   9     -35.583 109.173  20.915  1.00 70.98           O  
ATOM     44  CB  TYR A   9     -35.257 107.502  23.938  1.00 62.18           C  
ATOM     45  CG  TYR A   9     -35.590 106.274  24.769  1.00 59.16           C  
ATOM     46  CD1 TYR A   9     -36.734 106.238  25.565  1.00 64.53           C  
ATOM     47  CD2 TYR A   9     -34.776 105.136  24.742  1.00 61.06           C  
ATOM     48  CE1 TYR A   9     -37.066 105.102  26.311  1.00 62.21           C  
ATOM     49  CE2 TYR A   9     -35.101 103.991  25.486  1.00 59.09           C  
ATOM     50  CZ  TYR A   9     -36.249 103.985  26.266  1.00 61.07           C  
ATOM     51  OH  TYR A   9     -36.597 102.864  26.986  1.00 62.85           O  
ATOM     52  N   ASP A  10     -36.091 110.141  22.866  1.00 71.08           N  
ATOM     53  CA  ASP A  10     -35.882 111.463  22.299  1.00 73.19           C  
ATOM     54  C   ASP A  10     -34.702 112.200  22.916  1.00 71.67           C  
ATOM     55  O   ASP A  10     -34.778 112.688  24.043  1.00 75.04           O  
ATOM     56  CB  ASP A  10     -37.151 112.308  22.436  1.00 82.32           C  
ATOM     57  CG  ASP A  10     -37.157 113.502  21.501  1.00 86.51           C  
ATOM     58  OD1 ASP A  10     -37.121 113.296  20.268  1.00 87.07           O  
ATOM     59  OD2 ASP A  10     -37.195 114.646  21.999  1.00 90.61           O  
ATOM     60  N   TYR A  11     -33.606 112.273  22.167  1.00 65.53           N  
ATOM     61  CA  TYR A  11     -32.409 112.962  22.629  1.00 56.61           C  
ATOM     62  C   TYR A  11     -32.211 114.233  21.815  1.00 58.68           C  
ATOM     63  O   TYR A  11     -32.801 114.398  20.746  1.00 59.30           O  
ATOM     64  CB  TYR A  11     -31.183 112.053  22.501  1.00 48.88           C  
ATOM     65  CG  TYR A  11     -31.226 110.854  23.422  1.00 32.31           C  
ATOM     66  CD1 TYR A  11     -31.044 110.998  24.798  1.00 31.94           C  
ATOM     67  CD2 TYR A  11     -31.471 109.579  22.921  1.00 30.93           C  
ATOM     68  CE1 TYR A  11     -31.108 109.894  25.655  1.00 38.22           C  
ATOM     69  CE2 TYR A  11     -31.539 108.473  23.767  1.00 44.06           C  
ATOM     70  CZ  TYR A  11     -31.355 108.637  25.132  1.00 35.00           C  
ATOM     71  OH  TYR A  11     -31.418 107.541  25.960  1.00 43.68           O  
ATOM     72  N   GLU A  12     -31.367 115.122  22.320  1.00 58.75           N  
ATOM     73  CA  GLU A  12     -31.110 116.394  21.664  1.00 60.05           C  
ATOM     74  C   GLU A  12     -29.781 116.436  20.899  1.00 63.41           C  
ATOM     75  O   GLU A  12     -29.758 116.728  19.702  1.00 63.49           O  
ATOM     76  CB  GLU A  12     -31.148 117.494  22.721  1.00 62.83           C  
ATOM     77  CG  GLU A  12     -31.615 118.845  22.235  1.00 73.35           C  
ATOM     78  CD  GLU A  12     -31.885 119.787  23.389  1.00 78.52           C  
ATOM     79  OE1 GLU A  12     -32.809 119.505  24.183  1.00 78.26           O  
ATOM     80  OE2 GLU A  12     -31.168 120.802  23.509  1.00 83.53           O  
ATOM     81  N   ASP A  13     -28.682 116.136  21.589  1.00 59.16           N  
ATOM     82  CA  ASP A  13     -27.351 116.157  20.981  1.00 50.87           C  
ATOM     83  C   ASP A  13     -26.942 114.876  20.262  1.00 45.90           C  
ATOM     84  O   ASP A  13     -25.976 114.871  19.500  1.00 46.72           O  
ATOM     85  CB  ASP A  13     -26.297 116.489  22.041  1.00 53.08           C  
ATOM     86  CG  ASP A  13     -26.088 117.977  22.208  1.00 55.97           C  
ATOM     87  OD1 ASP A  13     -26.915 118.751  21.682  1.00 66.79           O  
ATOM     88  OD2 ASP A  13     -25.101 118.375  22.866  1.00 59.53           O  
ATOM     89  N   ILE A  14     -27.665 113.792  20.505  1.00 45.03           N  
ATOM     90  CA  ILE A  14     -27.348 112.520  19.869  1.00 38.25           C  
ATOM     91  C   ILE A  14     -28.609 111.858  19.341  1.00 44.36           C  
ATOM     92  O   ILE A  14     -29.702 112.415  19.425  1.00 48.20           O  
ATOM     93  CB  ILE A  14     -26.696 111.528  20.860  1.00 38.67           C  
ATOM     94  CG1 ILE A  14     -27.737 111.070  21.885  1.00 34.38           C  
ATOM     95  CG2 ILE A  14     -25.513 112.178  21.554  1.00 29.57           C  
ATOM     96  CD1 ILE A  14     -27.263 109.967  22.792  1.00 44.15           C  
ATOM     97  N   ILE A  15     -28.445 110.649  18.817  1.00 43.97           N  
ATOM     98  CA  ILE A  15     -29.547 109.872  18.280  1.00 45.20           C  
ATOM     99  C   ILE A  15     -29.412 108.428  18.760  1.00 45.82           C  
ATOM    100  O   ILE A  15     -28.318 107.862  18.749  1.00 49.33           O  
ATOM    101  CB  ILE A  15     -29.536 109.913  16.736  1.00 51.12           C  
ATOM    102  CG1 ILE A  15     -29.721 111.357  16.262  1.00 53.48           C  
ATOM    103  CG2 ILE A  15     -30.629 109.013  16.177  1.00 46.51           C  
ATOM    104  CD1 ILE A  15     -29.606 111.541  14.763  1.00 59.11           C  
ATOM    105  N   TYR A  16     -30.524 107.840  19.192  1.00 45.48           N  
ATOM    106  CA  TYR A  16     -30.527 106.465  19.679  1.00 43.19           C  
ATOM    107  C   TYR A  16     -31.541 105.620  18.921  1.00 45.46           C  
ATOM    108  O   TYR A  16     -32.745 105.854  18.997  1.00 50.20           O  
ATOM    109  CB  TYR A  16     -30.839 106.434  21.180  1.00 42.16           C  
ATOM    110  CG  TYR A  16     -30.848 105.044  21.781  1.00 39.53           C  
ATOM    111  CD1 TYR A  16     -32.038 104.450  22.198  1.00 36.12           C  
ATOM    112  CD2 TYR A  16     -29.663 104.318  21.930  1.00 39.59           C  
ATOM    113  CE1 TYR A  16     -32.052 103.174  22.760  1.00 38.47           C  
ATOM    114  CE2 TYR A  16     -29.665 103.038  22.490  1.00 35.49           C  
ATOM    115  CZ  TYR A  16     -30.861 102.474  22.900  1.00 34.82           C  
ATOM    116  OH  TYR A  16     -30.870 101.220  23.460  1.00 36.78           O  
ATOM    117  N   GLU A  17     -31.040 104.629  18.194  1.00 48.31           N  
ATOM    118  CA  GLU A  17     -31.887 103.748  17.400  1.00 48.71           C  
ATOM    119  C   GLU A  17     -31.498 102.302  17.653  1.00 48.88           C  
ATOM    120  O   GLU A  17     -30.414 102.025  18.166  1.00 46.01           O  
ATOM    121  CB  GLU A  17     -31.724 104.083  15.912  1.00 53.44           C  
ATOM    122  CG  GLU A  17     -32.229 105.473  15.526  1.00 59.35           C  
ATOM    123  CD  GLU A  17     -31.431 106.106  14.394  1.00 64.14           C  
ATOM    124  OE1 GLU A  17     -31.932 107.074  13.779  1.00 64.77           O  
ATOM    125  OE2 GLU A  17     -30.301 105.648  14.124  1.00 68.06           O  
ATOM    126  N   THR A  18     -32.386 101.380  17.300  1.00 48.83           N  
ATOM    127  CA  THR A  18     -32.119  99.962  17.497  1.00 48.78           C  
ATOM    128  C   THR A  18     -32.591  99.157  16.296  1.00 50.57           C  
ATOM    129  O   THR A  18     -33.377  99.644  15.480  1.00 56.21           O  
ATOM    130  CB  THR A  18     -32.831  99.424  18.760  1.00 49.16           C  
ATOM    131  OG1 THR A  18     -34.252  99.470  18.571  1.00 57.92           O  
ATOM    132  CG2 THR A  18     -32.462 100.262  19.975  1.00 49.89           C  
ATOM    133  N   TYR A  19     -32.098  97.925  16.194  1.00 49.87           N  
ATOM    134  CA  TYR A  19     -32.466  97.032  15.104  1.00 48.54           C  
ATOM    135  C   TYR A  19     -31.929  95.614  15.272  1.00 50.46           C  
ATOM    136  O   TYR A  19     -30.720  95.388  15.255  1.00 51.74           O  
ATOM    137  CB  TYR A  19     -31.985  97.581  13.757  1.00 55.96           C  
ATOM    138  CG  TYR A  19     -31.944  96.518  12.677  1.00 65.91           C  
ATOM    139  CD1 TYR A  19     -30.736  96.140  12.092  1.00 69.38           C  
ATOM    140  CD2 TYR A  19     -33.103  95.845  12.286  1.00 64.94           C  
ATOM    141  CE1 TYR A  19     -30.680  95.113  11.152  1.00 71.32           C  
ATOM    142  CE2 TYR A  19     -33.059  94.817  11.348  1.00 67.28           C  
ATOM    143  CZ  TYR A  19     -31.845  94.456  10.786  1.00 70.97           C  
ATOM    144  OH  TYR A  19     -31.788  93.429   9.872  1.00 70.76           O  
ATOM    145  N   ASN A  20     -32.852  94.671  15.433  1.00 53.11           N  
ATOM    146  CA  ASN A  20     -32.545  93.250  15.571  1.00 55.66           C  
ATOM    147  C   ASN A  20     -31.477  92.870  16.602  1.00 52.75           C  
ATOM    148  O   ASN A  20     -30.724  91.916  16.397  1.00 51.14           O  
ATOM    149  CB  ASN A  20     -32.160  92.684  14.201  1.00 63.22           C  
ATOM    150  CG  ASN A  20     -32.811  91.347  13.920  1.00 69.96           C  
ATOM    151  OD1 ASN A  20     -34.036  91.223  13.953  1.00 77.46           O  
ATOM    152  ND2 ASN A  20     -31.995  90.338  13.639  1.00 79.29           N  
ATOM    153  N   GLY A  21     -31.425  93.600  17.713  1.00 49.57           N  
ATOM    154  CA  GLY A  21     -30.450  93.297  18.748  1.00 49.91           C  
ATOM    155  C   GLY A  21     -29.261  94.239  18.766  1.00 49.29           C  
ATOM    156  O   GLY A  21     -28.393  94.149  19.637  1.00 50.46           O  
ATOM    157  N   ILE A  22     -29.223  95.151  17.803  1.00 44.89           N  
ATOM    158  CA  ILE A  22     -28.139  96.115  17.694  1.00 40.89           C  
ATOM    159  C   ILE A  22     -28.632  97.514  18.065  1.00 39.85           C  
ATOM    160  O   ILE A  22     -29.693  97.950  17.609  1.00 40.00           O  
ATOM    161  CB  ILE A  22     -27.586  96.158  16.251  1.00 32.71           C  
ATOM    162  CG1 ILE A  22     -27.235  94.745  15.782  1.00 38.00           C  
ATOM    163  CG2 ILE A  22     -26.370  97.059  16.184  1.00 32.34           C  
ATOM    164  CD1 ILE A  22     -26.892  94.660  14.303  1.00 34.90           C  
ATOM    165  N   ALA A  23     -27.866  98.209  18.897  1.00 30.68           N  
ATOM    166  CA  ALA A  23     -28.213  99.564  19.304  1.00 31.98           C  
ATOM    167  C   ALA A  23     -27.153 100.506  18.741  1.00 38.46           C  
ATOM    168  O   ALA A  23     -25.958 100.287  18.932  1.00 38.55           O  
ATOM    169  CB  ALA A  23     -28.255  99.664  20.823  1.00 34.01           C  
ATOM    170  N   LYS A  24     -27.589 101.548  18.042  1.00 38.67           N  
ATOM    171  CA  LYS A  24     -26.661 102.503  17.450  1.00 38.79           C  
ATOM    172  C   LYS A  24     -26.827 103.885  18.069  1.00 36.35           C  
ATOM    173  O   LYS A  24     -27.928 104.439  18.095  1.00 39.13           O  
ATOM    174  CB  LYS A  24     -26.880 102.567  15.930  1.00 40.39           C  
ATOM    175  CG  LYS A  24     -25.876 103.436  15.168  1.00 38.40           C  
ATOM    176  CD  LYS A  24     -25.859 103.091  13.676  1.00 37.37           C  
ATOM    177  CE  LYS A  24     -27.067 103.650  12.924  1.00 44.45           C  
ATOM    178  NZ  LYS A  24     -26.947 105.121  12.685  1.00 40.48           N  
ATOM    179  N   ILE A  25     -25.724 104.431  18.577  1.00 35.94           N  
ATOM    180  CA  ILE A  25     -25.722 105.749  19.201  1.00 30.55           C  
ATOM    181  C   ILE A  25     -24.943 106.714  18.317  1.00 37.29           C  
ATOM    182  O   ILE A  25     -23.757 106.505  18.047  1.00 38.06           O  
ATOM    183  CB  ILE A  25     -25.075 105.700  20.600  1.00 24.10           C  
ATOM    184  CG1 ILE A  25     -25.884 104.777  21.516  1.00 31.48           C  
ATOM    185  CG2 ILE A  25     -24.995 107.096  21.185  1.00 27.09           C  
ATOM    186  CD1 ILE A  25     -25.311 104.634  22.927  1.00 28.60           C  
ATOM    187  N   THR A  26     -25.604 107.784  17.883  1.00 36.55           N  
ATOM    188  CA  THR A  26     -24.972 108.750  16.999  1.00 36.52           C  
ATOM    189  C   THR A  26     -24.820 110.167  17.539  1.00 44.66           C  
ATOM    190  O   THR A  26     -25.805 110.840  17.848  1.00 46.55           O  
ATOM    191  CB  THR A  26     -25.747 108.844  15.677  1.00 38.92           C  
ATOM    192  OG1 THR A  26     -25.994 107.525  15.176  1.00 36.38           O  
ATOM    193  CG2 THR A  26     -24.956 109.644  14.648  1.00 35.61           C  
ATOM    194  N   ILE A  27     -23.578 110.622  17.645  1.00 45.21           N  
ATOM    195  CA  ILE A  27     -23.318 111.983  18.089  1.00 46.37           C  
ATOM    196  C   ILE A  27     -23.784 112.807  16.900  1.00 50.58           C  
ATOM    197  O   ILE A  27     -23.417 112.509  15.761  1.00 49.39           O  
ATOM    198  CB  ILE A  27     -21.817 112.233  18.304  1.00 42.63           C  
ATOM    199  CG1 ILE A  27     -21.289 111.302  19.399  1.00 41.86           C  
ATOM    200  CG2 ILE A  27     -21.581 113.700  18.650  1.00 41.06           C  
ATOM    201  CD1 ILE A  27     -19.799 111.386  19.612  1.00 36.45           C  
ATOM    202  N   ASN A  28     -24.589 113.834  17.150  1.00 53.09           N  
ATOM    203  CA  ASN A  28     -25.098 114.646  16.053  1.00 45.78           C  
ATOM    204  C   ASN A  28     -24.747 116.122  16.165  1.00 47.66           C  
ATOM    205  O   ASN A  28     -25.585 116.947  16.533  1.00 51.63           O  
ATOM    206  CB  ASN A  28     -26.612 114.472  15.955  1.00 41.98           C  
ATOM    207  CG  ASN A  28     -27.158 114.920  14.624  1.00 48.43           C  
ATOM    208  OD1 ASN A  28     -26.404 115.137  13.676  1.00 58.23           O  
ATOM    209  ND2 ASN A  28     -28.477 115.049  14.535  1.00 52.55           N  
ATOM    210  N   ARG A  29     -23.503 116.449  15.840  1.00 42.59           N  
ATOM    211  CA  ARG A  29     -23.038 117.826  15.894  1.00 41.25           C  
ATOM    212  C   ARG A  29     -22.052 118.116  14.760  1.00 42.51           C  
ATOM    213  O   ARG A  29     -21.004 118.731  14.976  1.00 42.35           O  
ATOM    214  CB  ARG A  29     -22.385 118.099  17.252  1.00 40.37           C  
ATOM    215  CG  ARG A  29     -23.303 117.809  18.430  1.00 43.26           C  
ATOM    216  CD  ARG A  29     -23.389 119.002  19.349  1.00 40.62           C  
ATOM    217  NE  ARG A  29     -22.102 119.290  19.961  1.00 46.02           N  
ATOM    218  CZ  ARG A  29     -21.706 120.502  20.330  1.00 53.54           C  
ATOM    219  NH1 ARG A  29     -22.497 121.552  20.151  1.00 56.91           N  
ATOM    220  NH2 ARG A  29     -20.511 120.662  20.872  1.00 48.42           N  
ATOM    221  N   PRO A  30     -22.389 117.690  13.528  1.00 46.65           N  
ATOM    222  CA  PRO A  30     -21.547 117.891  12.343  1.00 46.46           C  
ATOM    223  C   PRO A  30     -20.992 119.304  12.198  1.00 49.46           C  
ATOM    224  O   PRO A  30     -19.927 119.490  11.611  1.00 51.98           O  
ATOM    225  CB  PRO A  30     -22.478 117.523  11.196  1.00 40.86           C  
ATOM    226  CG  PRO A  30     -23.319 116.452  11.798  1.00 48.46           C  
ATOM    227  CD  PRO A  30     -23.652 117.030  13.150  1.00 45.38           C  
ATOM    228  N   GLU A  31     -21.709 120.294  12.723  1.00 47.91           N  
ATOM    229  CA  GLU A  31     -21.259 121.682  12.628  1.00 53.04           C  
ATOM    230  C   GLU A  31     -19.872 121.829  13.241  1.00 54.51           C  
ATOM    231  O   GLU A  31     -19.008 122.509  12.688  1.00 51.89           O  
ATOM    232  CB  GLU A  31     -22.236 122.630  13.335  1.00 58.26           C  
ATOM    233  CG  GLU A  31     -22.460 122.326  14.808  1.00 57.32           C  
ATOM    234  CD  GLU A  31     -23.606 121.365  15.038  1.00 57.17           C  
ATOM    235  OE1 GLU A  31     -24.024 120.684  14.076  1.00 54.13           O  
ATOM    236  OE2 GLU A  31     -24.086 121.287  16.188  1.00 61.30           O  
ATOM    237  N   VAL A  32     -19.669 121.186  14.388  1.00 55.29           N  
ATOM    238  CA  VAL A  32     -18.387 121.223  15.080  1.00 54.87           C  
ATOM    239  C   VAL A  32     -17.699 119.863  14.969  1.00 57.47           C  
ATOM    240  O   VAL A  32     -16.929 119.469  15.846  1.00 57.16           O  
ATOM    241  CB  VAL A  32     -18.568 121.582  16.573  1.00 52.36           C  
ATOM    242  CG1 VAL A  32     -18.866 123.066  16.721  1.00 45.96           C  
ATOM    243  CG2 VAL A  32     -19.700 120.763  17.167  1.00 51.47           C  
ATOM    244  N   HIS A  33     -17.986 119.156  13.877  1.00 57.10           N  
ATOM    245  CA  HIS A  33     -17.421 117.836  13.615  1.00 51.39           C  
ATOM    246  C   HIS A  33     -17.702 116.850  14.740  1.00 50.81           C  
ATOM    247  O   HIS A  33     -16.810 116.152  15.222  1.00 47.36           O  
ATOM    248  CB  HIS A  33     -15.915 117.940  13.356  1.00 50.09           C  
ATOM    249  CG  HIS A  33     -15.575 118.394  11.971  1.00 55.36           C  
ATOM    250  ND1 HIS A  33     -15.987 117.714  10.843  1.00 50.77           N  
ATOM    251  CD2 HIS A  33     -14.860 119.457  11.528  1.00 52.33           C  
ATOM    252  CE1 HIS A  33     -15.540 118.337   9.768  1.00 54.29           C  
ATOM    253  NE2 HIS A  33     -14.854 119.396  10.154  1.00 52.65           N  
ATOM    254  N   ASN A  34     -18.964 116.815  15.150  1.00 48.15           N  
ATOM    255  CA  ASN A  34     -19.434 115.924  16.197  1.00 44.01           C  
ATOM    256  C   ASN A  34     -18.679 116.012  17.514  1.00 42.76           C  
ATOM    257  O   ASN A  34     -18.532 115.020  18.226  1.00 44.22           O  
ATOM    258  CB  ASN A  34     -19.430 114.490  15.682  1.00 42.68           C  
ATOM    259  CG  ASN A  34     -20.313 114.318  14.464  1.00 41.46           C  
ATOM    260  OD1 ASN A  34     -21.495 114.650  14.491  1.00 49.03           O  
ATOM    261  ND2 ASN A  34     -19.742 113.800  13.387  1.00 49.70           N  
ATOM    262  N   ALA A  35     -18.200 117.208  17.839  1.00 41.66           N  
ATOM    263  CA  ALA A  35     -17.498 117.414  19.094  1.00 38.47           C  
ATOM    264  C   ALA A  35     -18.520 117.176  20.201  1.00 41.22           C  
ATOM    265  O   ALA A  35     -19.726 117.142  19.938  1.00 34.14           O  
ATOM    266  CB  ALA A  35     -16.962 118.832  19.169  1.00 34.37           C  
ATOM    267  N   PHE A  36     -18.050 116.994  21.431  1.00 40.72           N  
ATOM    268  CA  PHE A  36     -18.969 116.777  22.538  1.00 40.46           C  
ATOM    269  C   PHE A  36     -18.820 117.820  23.627  1.00 38.85           C  
ATOM    270  O   PHE A  36     -17.723 118.307  23.911  1.00 38.16           O  
ATOM    271  CB  PHE A  36     -18.820 115.358  23.130  1.00 39.28           C  
ATOM    272  CG  PHE A  36     -17.458 115.054  23.706  1.00 34.12           C  
ATOM    273  CD1 PHE A  36     -17.027 115.659  24.886  1.00 31.48           C  
ATOM    274  CD2 PHE A  36     -16.612 114.141  23.073  1.00 29.08           C  
ATOM    275  CE1 PHE A  36     -15.778 115.360  25.427  1.00 28.83           C  
ATOM    276  CE2 PHE A  36     -15.363 113.834  23.603  1.00 28.23           C  
ATOM    277  CZ  PHE A  36     -14.944 114.446  24.785  1.00 35.61           C  
ATOM    278  N   ARG A  37     -19.953 118.184  24.210  1.00 42.58           N  
ATOM    279  CA  ARG A  37     -19.999 119.151  25.291  1.00 41.52           C  
ATOM    280  C   ARG A  37     -20.678 118.422  26.438  1.00 40.90           C  
ATOM    281  O   ARG A  37     -21.389 117.437  26.220  1.00 43.14           O  
ATOM    282  CB  ARG A  37     -20.811 120.382  24.879  1.00 40.45           C  
ATOM    283  CG  ARG A  37     -22.240 120.080  24.459  1.00 39.89           C  
ATOM    284  CD  ARG A  37     -22.955 121.357  24.062  1.00 40.90           C  
ATOM    285  NE  ARG A  37     -24.344 121.122  23.685  1.00 45.79           N  
ATOM    286  CZ  ARG A  37     -25.212 122.091  23.409  1.00 47.22           C  
ATOM    287  NH1 ARG A  37     -24.831 123.360  23.468  1.00 50.83           N  
ATOM    288  NH2 ARG A  37     -26.461 121.795  23.082  1.00 43.71           N  
ATOM    289  N   PRO A  38     -20.479 118.896  27.673  1.00 36.11           N  
ATOM    290  CA  PRO A  38     -21.082 118.259  28.844  1.00 40.38           C  
ATOM    291  C   PRO A  38     -22.450 117.612  28.626  1.00 40.50           C  
ATOM    292  O   PRO A  38     -22.696 116.505  29.108  1.00 45.28           O  
ATOM    293  CB  PRO A  38     -21.109 119.393  29.860  1.00 41.19           C  
ATOM    294  CG  PRO A  38     -19.794 120.081  29.572  1.00 34.85           C  
ATOM    295  CD  PRO A  38     -19.786 120.143  28.049  1.00 38.05           C  
ATOM    296  N   LYS A  39     -23.335 118.277  27.888  1.00 42.71           N  
ATOM    297  CA  LYS A  39     -24.665 117.722  27.649  1.00 37.65           C  
ATOM    298  C   LYS A  39     -24.695 116.478  26.769  1.00 33.40           C  
ATOM    299  O   LYS A  39     -25.321 115.482  27.124  1.00 42.72           O  
ATOM    300  CB  LYS A  39     -25.600 118.778  27.047  1.00 33.84           C  
ATOM    301  CG  LYS A  39     -26.937 118.198  26.617  1.00 39.05           C  
ATOM    302  CD  LYS A  39     -28.084 119.172  26.815  1.00 52.45           C  
ATOM    303  CE  LYS A  39     -29.409 118.528  26.423  1.00 50.58           C  
ATOM    304  NZ  LYS A  39     -30.586 119.373  26.774  1.00 52.83           N  
ATOM    305  N   THR A  40     -24.039 116.532  25.615  1.00 33.17           N  
ATOM    306  CA  THR A  40     -24.035 115.387  24.713  1.00 28.59           C  
ATOM    307  C   THR A  40     -23.418 114.139  25.359  1.00 28.64           C  
ATOM    308  O   THR A  40     -23.752 113.014  24.989  1.00 23.48           O  
ATOM    309  CB  THR A  40     -23.309 115.724  23.385  1.00 31.68           C  
ATOM    310  OG1 THR A  40     -23.015 114.516  22.674  1.00 37.72           O  
ATOM    311  CG2 THR A  40     -22.042 116.481  23.649  1.00 33.78           C  
ATOM    312  N   VAL A  41     -22.536 114.337  26.333  1.00 28.81           N  
ATOM    313  CA  VAL A  41     -21.922 113.210  27.023  1.00 28.54           C  
ATOM    314  C   VAL A  41     -22.980 112.556  27.906  1.00 31.78           C  
ATOM    315  O   VAL A  41     -23.164 111.335  27.886  1.00 32.91           O  
ATOM    316  CB  VAL A  41     -20.752 113.658  27.922  1.00 31.77           C  
ATOM    317  CG1 VAL A  41     -20.178 112.452  28.663  1.00 26.42           C  
ATOM    318  CG2 VAL A  41     -19.677 114.327  27.088  1.00 35.68           C  
ATOM    319  N   ASN A  42     -23.681 113.378  28.681  1.00 37.70           N  
ATOM    320  CA  ASN A  42     -24.723 112.877  29.568  1.00 41.98           C  
ATOM    321  C   ASN A  42     -25.768 112.077  28.812  1.00 33.55           C  
ATOM    322  O   ASN A  42     -26.324 111.115  29.339  1.00 37.81           O  
ATOM    323  CB  ASN A  42     -25.389 114.037  30.312  1.00 56.13           C  
ATOM    324  CG  ASN A  42     -24.592 114.482  31.523  1.00 68.15           C  
ATOM    325  OD1 ASN A  42     -24.197 115.645  31.633  1.00 74.03           O  
ATOM    326  ND2 ASN A  42     -24.348 113.550  32.443  1.00 71.77           N  
ATOM    327  N   GLU A  43     -26.026 112.466  27.568  1.00 38.03           N  
ATOM    328  CA  GLU A  43     -27.012 111.766  26.754  1.00 38.39           C  
ATOM    329  C   GLU A  43     -26.471 110.407  26.325  1.00 35.90           C  
ATOM    330  O   GLU A  43     -27.211 109.420  26.278  1.00 39.27           O  
ATOM    331  CB  GLU A  43     -27.374 112.607  25.529  1.00 44.99           C  
ATOM    332  CG  GLU A  43     -27.781 114.032  25.877  1.00 53.09           C  
ATOM    333  CD  GLU A  43     -28.304 114.805  24.684  1.00 61.89           C  
ATOM    334  OE1 GLU A  43     -28.389 116.048  24.779  1.00 65.22           O  
ATOM    335  OE2 GLU A  43     -28.640 114.171  23.657  1.00 61.41           O  
ATOM    336  N   MET A  44     -25.179 110.354  26.014  1.00 36.52           N  
ATOM    337  CA  MET A  44     -24.555 109.098  25.613  1.00 32.56           C  
ATOM    338  C   MET A  44     -24.593 108.134  26.805  1.00 29.40           C  
ATOM    339  O   MET A  44     -24.792 106.929  26.638  1.00 29.92           O  
ATOM    340  CB  MET A  44     -23.112 109.343  25.163  1.00 33.96           C  
ATOM    341  CG  MET A  44     -22.984 110.314  23.990  1.00 35.48           C  
ATOM    342  SD  MET A  44     -21.308 110.392  23.302  1.00 34.90           S  
ATOM    343  CE  MET A  44     -21.361 108.953  22.342  1.00 23.22           C  
ATOM    344  N   ILE A  45     -24.411 108.674  28.008  1.00 29.77           N  
ATOM    345  CA  ILE A  45     -24.456 107.870  29.227  1.00 25.59           C  
ATOM    346  C   ILE A  45     -25.823 107.196  29.295  1.00 29.31           C  
ATOM    347  O   ILE A  45     -25.942 105.972  29.371  1.00 27.41           O  
ATOM    348  CB  ILE A  45     -24.314 108.751  30.488  1.00 31.45           C  
ATOM    349  CG1 ILE A  45     -23.000 109.531  30.449  1.00 35.51           C  
ATOM    350  CG2 ILE A  45     -24.403 107.889  31.740  1.00 27.38           C  
ATOM    351  CD1 ILE A  45     -21.772 108.668  30.486  1.00 35.12           C  
ATOM    352  N   ASP A  46     -26.861 108.026  29.261  1.00 37.96           N  
ATOM    353  CA  ASP A  46     -28.237 107.556  29.330  1.00 31.14           C  
ATOM    354  C   ASP A  46     -28.544 106.530  28.248  1.00 31.08           C  
ATOM    355  O   ASP A  46     -29.195 105.515  28.512  1.00 26.48           O  
ATOM    356  CB  ASP A  46     -29.193 108.746  29.197  1.00 45.00           C  
ATOM    357  CG  ASP A  46     -30.638 108.364  29.437  1.00 43.34           C  
ATOM    358  OD1 ASP A  46     -30.986 108.071  30.600  1.00 52.97           O  
ATOM    359  OD2 ASP A  46     -31.420 108.349  28.467  1.00 45.78           O  
ATOM    360  N   ALA A  47     -28.069 106.798  27.034  1.00 29.12           N  
ATOM    361  CA  ALA A  47     -28.301 105.909  25.897  1.00 28.02           C  
ATOM    362  C   ALA A  47     -27.651 104.547  26.093  1.00 30.25           C  
ATOM    363  O   ALA A  47     -28.294 103.509  25.917  1.00 31.49           O  
ATOM    364  CB  ALA A  47     -27.782 106.562  24.609  1.00 30.91           C  
ATOM    365  N   PHE A  48     -26.369 104.548  26.448  1.00 34.58           N  
ATOM    366  CA  PHE A  48     -25.656 103.300  26.680  1.00 29.86           C  
ATOM    367  C   PHE A  48     -26.331 102.535  27.795  1.00 25.87           C  
ATOM    368  O   PHE A  48     -26.462 101.314  27.728  1.00 29.64           O  
ATOM    369  CB  PHE A  48     -24.196 103.558  27.065  1.00 29.21           C  
ATOM    370  CG  PHE A  48     -23.271 103.658  25.892  1.00 21.35           C  
ATOM    371  CD1 PHE A  48     -22.840 104.900  25.428  1.00 23.81           C  
ATOM    372  CD2 PHE A  48     -22.838 102.509  25.241  1.00 18.49           C  
ATOM    373  CE1 PHE A  48     -21.987 104.990  24.329  1.00 25.49           C  
ATOM    374  CE2 PHE A  48     -21.989 102.588  24.147  1.00 22.08           C  
ATOM    375  CZ  PHE A  48     -21.561 103.832  23.689  1.00 21.19           C  
ATOM    376  N   THR A  49     -26.754 103.261  28.827  1.00 32.77           N  
ATOM    377  CA  THR A  49     -27.426 102.633  29.955  1.00 33.87           C  
ATOM    378  C   THR A  49     -28.683 101.960  29.427  1.00 36.81           C  
ATOM    379  O   THR A  49     -28.962 100.800  29.750  1.00 35.80           O  
ATOM    380  CB  THR A  49     -27.802 103.661  31.036  1.00 39.50           C  
ATOM    381  OG1 THR A  49     -26.610 104.284  31.540  1.00 28.37           O  
ATOM    382  CG2 THR A  49     -28.529 102.976  32.186  1.00 40.91           C  
ATOM    383  N   LYS A  50     -29.427 102.686  28.594  1.00 37.07           N  
ATOM    384  CA  LYS A  50     -30.647 102.151  28.001  1.00 39.34           C  
ATOM    385  C   LYS A  50     -30.326 100.850  27.286  1.00 32.99           C  
ATOM    386  O   LYS A  50     -30.995  99.839  27.496  1.00 39.49           O  
ATOM    387  CB  LYS A  50     -31.254 103.155  27.013  1.00 40.56           C  
ATOM    388  CG  LYS A  50     -31.893 104.362  27.682  1.00 43.01           C  
ATOM    389  CD  LYS A  50     -33.132 103.960  28.476  1.00 38.47           C  
ATOM    390  CE  LYS A  50     -33.577 105.078  29.415  1.00 47.07           C  
ATOM    391  NZ  LYS A  50     -33.868 106.360  28.712  1.00 43.42           N  
ATOM    392  N   ALA A  51     -29.293 100.873  26.447  1.00 32.67           N  
ATOM    393  CA  ALA A  51     -28.891  99.679  25.713  1.00 25.89           C  
ATOM    394  C   ALA A  51     -28.405  98.613  26.687  1.00 25.83           C  
ATOM    395  O   ALA A  51     -28.582  97.410  26.466  1.00 24.04           O  
ATOM    396  CB  ALA A  51     -27.793 100.025  24.718  1.00 31.66           C  
ATOM    397  N   ARG A  52     -27.791  99.061  27.777  1.00 30.16           N  
ATOM    398  CA  ARG A  52     -27.284  98.139  28.785  1.00 36.03           C  
ATOM    399  C   ARG A  52     -28.398  97.279  29.387  1.00 31.91           C  
ATOM    400  O   ARG A  52     -28.288  96.051  29.448  1.00 29.15           O  
ATOM    401  CB  ARG A  52     -26.574  98.909  29.905  1.00 25.44           C  
ATOM    402  CG  ARG A  52     -26.039  98.001  31.003  1.00 31.28           C  
ATOM    403  CD  ARG A  52     -25.339  98.766  32.117  1.00 30.21           C  
ATOM    404  NE  ARG A  52     -24.792  97.838  33.101  1.00 34.02           N  
ATOM    405  CZ  ARG A  52     -24.158  98.196  34.212  1.00 33.40           C  
ATOM    406  NH1 ARG A  52     -23.981  99.479  34.497  1.00 24.62           N  
ATOM    407  NH2 ARG A  52     -23.697  97.265  35.039  1.00 34.02           N  
ATOM    408  N   ASP A  53     -29.470  97.928  29.828  1.00 33.60           N  
ATOM    409  CA  ASP A  53     -30.583  97.214  30.446  1.00 44.44           C  
ATOM    410  C   ASP A  53     -31.513  96.520  29.451  1.00 45.38           C  
ATOM    411  O   ASP A  53     -32.247  95.609  29.827  1.00 50.68           O  
ATOM    412  CB  ASP A  53     -31.397  98.168  31.324  1.00 45.62           C  
ATOM    413  CG  ASP A  53     -30.525  98.977  32.260  1.00 46.23           C  
ATOM    414  OD1 ASP A  53     -29.587  98.395  32.846  1.00 48.26           O  
ATOM    415  OD2 ASP A  53     -30.782 100.190  32.413  1.00 46.43           O  
ATOM    416  N   ASP A  54     -31.485  96.951  28.192  1.00 43.78           N  
ATOM    417  CA  ASP A  54     -32.333  96.351  27.161  1.00 42.84           C  
ATOM    418  C   ASP A  54     -31.864  94.933  26.838  1.00 37.18           C  
ATOM    419  O   ASP A  54     -30.955  94.744  26.034  1.00 39.67           O  
ATOM    420  CB  ASP A  54     -32.302  97.197  25.886  1.00 40.70           C  
ATOM    421  CG  ASP A  54     -33.345  96.759  24.871  1.00 41.09           C  
ATOM    422  OD1 ASP A  54     -33.503  95.538  24.665  1.00 39.85           O  
ATOM    423  OD2 ASP A  54     -34.000  97.635  24.271  1.00 41.97           O  
ATOM    424  N   SER A  55     -32.500  93.941  27.456  1.00 36.36           N  
ATOM    425  CA  SER A  55     -32.144  92.539  27.258  1.00 34.14           C  
ATOM    426  C   SER A  55     -32.247  92.048  25.816  1.00 41.67           C  
ATOM    427  O   SER A  55     -31.826  90.929  25.507  1.00 36.23           O  
ATOM    428  CB  SER A  55     -33.009  91.645  28.153  1.00 44.96           C  
ATOM    429  OG  SER A  55     -34.385  91.759  27.827  1.00 43.55           O  
ATOM    430  N   ASN A  56     -32.809  92.874  24.936  1.00 40.09           N  
ATOM    431  CA  ASN A  56     -32.952  92.501  23.533  1.00 41.01           C  
ATOM    432  C   ASN A  56     -31.740  92.953  22.718  1.00 42.14           C  
ATOM    433  O   ASN A  56     -31.550  92.517  21.582  1.00 46.55           O  
ATOM    434  CB  ASN A  56     -34.232  93.114  22.952  1.00 42.21           C  
ATOM    435  CG  ASN A  56     -35.494  92.525  23.565  1.00 47.35           C  
ATOM    436  OD1 ASN A  56     -36.423  93.254  23.916  1.00 43.65           O  
ATOM    437  ND2 ASN A  56     -35.537  91.199  23.687  1.00 36.26           N  
ATOM    438  N   ILE A  57     -30.932  93.831  23.307  1.00 38.79           N  
ATOM    439  CA  ILE A  57     -29.725  94.343  22.657  1.00 39.61           C  
ATOM    440  C   ILE A  57     -28.506  93.542  23.128  1.00 39.40           C  
ATOM    441  O   ILE A  57     -28.284  93.386  24.332  1.00 38.62           O  
ATOM    442  CB  ILE A  57     -29.490  95.830  23.004  1.00 38.49           C  
ATOM    443  CG1 ILE A  57     -30.710  96.668  22.596  1.00 37.87           C  
ATOM    444  CG2 ILE A  57     -28.222  96.335  22.316  1.00 35.67           C  
ATOM    445  CD1 ILE A  57     -31.016  96.665  21.106  1.00 22.64           C  
ATOM    446  N   GLY A  58     -27.723  93.038  22.180  1.00 37.51           N  
ATOM    447  CA  GLY A  58     -26.545  92.259  22.526  1.00 32.11           C  
ATOM    448  C   GLY A  58     -25.245  92.863  22.020  1.00 33.93           C  
ATOM    449  O   GLY A  58     -24.159  92.369  22.335  1.00 26.99           O  
ATOM    450  N   VAL A  59     -25.359  93.928  21.228  1.00 32.25           N  
ATOM    451  CA  VAL A  59     -24.203  94.623  20.661  1.00 29.44           C  
ATOM    452  C   VAL A  59     -24.534  96.104  20.537  1.00 32.62           C  
ATOM    453  O   VAL A  59     -25.685  96.470  20.304  1.00 39.19           O  
ATOM    454  CB  VAL A  59     -23.855  94.100  19.248  1.00 27.10           C  
ATOM    455  CG1 VAL A  59     -22.546  94.713  18.777  1.00 35.36           C  
ATOM    456  CG2 VAL A  59     -23.757  92.592  19.249  1.00 35.20           C  
ATOM    457  N   ILE A  60     -23.527  96.960  20.681  1.00 29.37           N  
ATOM    458  CA  ILE A  60     -23.752  98.396  20.580  1.00 29.51           C  
ATOM    459  C   ILE A  60     -22.779  99.063  19.615  1.00 33.89           C  
ATOM    460  O   ILE A  60     -21.586  98.749  19.605  1.00 35.71           O  
ATOM    461  CB  ILE A  60     -23.614  99.076  21.952  1.00 27.37           C  
ATOM    462  CG1 ILE A  60     -24.576  98.433  22.950  1.00 26.53           C  
ATOM    463  CG2 ILE A  60     -23.894 100.562  21.822  1.00 28.84           C  
ATOM    464  CD1 ILE A  60     -24.411  98.929  24.366  1.00 29.27           C  
ATOM    465  N   ILE A  61     -23.299  99.983  18.807  1.00 27.59           N  
ATOM    466  CA  ILE A  61     -22.489 100.713  17.843  1.00 26.09           C  
ATOM    467  C   ILE A  61     -22.437 102.186  18.208  1.00 30.71           C  
ATOM    468  O   ILE A  61     -23.452 102.790  18.561  1.00 31.48           O  
ATOM    469  CB  ILE A  61     -23.057 100.602  16.406  1.00 34.73           C  
ATOM    470  CG1 ILE A  61     -23.037  99.145  15.945  1.00 33.55           C  
ATOM    471  CG2 ILE A  61     -22.241 101.472  15.451  1.00 30.71           C  
ATOM    472  CD1 ILE A  61     -23.638  98.936  14.571  1.00 37.26           C  
ATOM    473  N   LEU A  62     -21.247 102.760  18.119  1.00 28.01           N  
ATOM    474  CA  LEU A  62     -21.057 104.168  18.412  1.00 28.49           C  
ATOM    475  C   LEU A  62     -20.517 104.804  17.141  1.00 34.58           C  
ATOM    476  O   LEU A  62     -19.554 104.307  16.557  1.00 36.60           O  
ATOM    477  CB  LEU A  62     -20.056 104.340  19.552  1.00 29.78           C  
ATOM    478  CG  LEU A  62     -19.934 105.765  20.081  1.00 32.31           C  
ATOM    479  CD1 LEU A  62     -21.304 106.228  20.552  1.00 31.04           C  
ATOM    480  CD2 LEU A  62     -18.917 105.818  21.218  1.00 28.05           C  
ATOM    481  N   THR A  63     -21.135 105.894  16.702  1.00 36.81           N  
ATOM    482  CA  THR A  63     -20.683 106.551  15.485  1.00 37.40           C  
ATOM    483  C   THR A  63     -21.048 108.024  15.444  1.00 39.78           C  
ATOM    484  O   THR A  63     -21.772 108.519  16.304  1.00 45.04           O  
ATOM    485  CB  THR A  63     -21.274 105.861  14.237  1.00 40.94           C  
ATOM    486  OG1 THR A  63     -20.611 106.344  13.061  1.00 39.30           O  
ATOM    487  CG2 THR A  63     -22.772 106.147  14.129  1.00 41.53           C  
ATOM    488  N   GLY A  64     -20.523 108.716  14.439  1.00 38.97           N  
ATOM    489  CA  GLY A  64     -20.805 110.129  14.264  1.00 39.61           C  
ATOM    490  C   GLY A  64     -21.721 110.282  13.066  1.00 42.09           C  
ATOM    491  O   GLY A  64     -21.691 109.449  12.153  1.00 36.03           O  
ATOM    492  N   ALA A  65     -22.530 111.339  13.065  1.00 42.21           N  
ATOM    493  CA  ALA A  65     -23.480 111.591  11.979  1.00 41.19           C  
ATOM    494  C   ALA A  65     -22.847 112.233  10.746  1.00 36.39           C  
ATOM    495  O   ALA A  65     -23.145 111.851   9.615  1.00 36.33           O  
ATOM    496  CB  ALA A  65     -24.626 112.470  12.488  1.00 39.04           C  
ATOM    497  N   GLY A  66     -21.981 113.212  10.974  1.00 39.27           N  
ATOM    498  CA  GLY A  66     -21.325 113.909   9.881  1.00 51.34           C  
ATOM    499  C   GLY A  66     -21.072 113.147   8.587  1.00 55.58           C  
ATOM    500  O   GLY A  66     -21.538 113.551   7.518  1.00 56.98           O  
ATOM    501  N   GLY A  67     -20.341 112.041   8.679  1.00 53.33           N  
ATOM    502  CA  GLY A  67     -20.011 111.271   7.494  1.00 49.33           C  
ATOM    503  C   GLY A  67     -18.539 111.532   7.237  1.00 47.06           C  
ATOM    504  O   GLY A  67     -17.871 110.788   6.517  1.00 43.61           O  
ATOM    505  N   LYS A  68     -18.046 112.610   7.844  1.00 37.63           N  
ATOM    506  CA  LYS A  68     -16.657 113.015   7.743  1.00 41.02           C  
ATOM    507  C   LYS A  68     -16.093 113.281   9.136  1.00 35.11           C  
ATOM    508  O   LYS A  68     -15.034 113.885   9.287  1.00 31.92           O  
ATOM    509  CB  LYS A  68     -16.512 114.273   6.870  1.00 45.66           C  
ATOM    510  CG  LYS A  68     -17.531 115.384   7.106  1.00 53.05           C  
ATOM    511  CD  LYS A  68     -17.205 116.593   6.223  1.00 57.35           C  
ATOM    512  CE  LYS A  68     -18.434 117.444   5.896  1.00 63.06           C  
ATOM    513  NZ  LYS A  68     -19.183 117.921   7.094  1.00 52.32           N  
ATOM    514  N   ALA A  69     -16.808 112.820  10.150  1.00 32.11           N  
ATOM    515  CA  ALA A  69     -16.373 112.999  11.526  1.00 34.41           C  
ATOM    516  C   ALA A  69     -17.081 112.004  12.431  1.00 34.94           C  
ATOM    517  O   ALA A  69     -18.276 111.771  12.287  1.00 39.68           O  
ATOM    518  CB  ALA A  69     -16.659 114.418  11.982  1.00 32.76           C  
ATOM    519  N   PHE A  70     -16.326 111.410  13.347  1.00 36.92           N  
ATOM    520  CA  PHE A  70     -16.845 110.442  14.311  1.00 33.70           C  
ATOM    521  C   PHE A  70     -17.080 111.217  15.601  1.00 28.04           C  
ATOM    522  O   PHE A  70     -18.130 111.109  16.231  1.00 32.11           O  
ATOM    523  CB  PHE A  70     -15.793 109.353  14.539  1.00 31.95           C  
ATOM    524  CG  PHE A  70     -16.015 108.506  15.767  1.00 29.79           C  
ATOM    525  CD1 PHE A  70     -16.845 107.387  15.726  1.00 23.55           C  
ATOM    526  CD2 PHE A  70     -15.368 108.815  16.962  1.00 26.78           C  
ATOM    527  CE1 PHE A  70     -17.021 106.583  16.857  1.00 21.14           C  
ATOM    528  CE2 PHE A  70     -15.535 108.020  18.098  1.00 25.10           C  
ATOM    529  CZ  PHE A  70     -16.365 106.905  18.048  1.00 14.97           C  
ATOM    530  N   CYS A  71     -16.077 112.015  15.949  1.00 27.62           N  
ATOM    531  CA  CYS A  71     -16.071 112.833  17.140  1.00 32.67           C  
ATOM    532  C   CYS A  71     -14.744 113.570  16.958  1.00 36.09           C  
ATOM    533  O   CYS A  71     -13.824 113.061  16.321  1.00 40.97           O  
ATOM    534  CB  CYS A  71     -16.277 111.961  18.383  1.00 29.59           C  
ATOM    535  SG  CYS A  71     -16.196 112.912  19.915  1.00 34.09           S  
ATOM    536  N   SER A  72     -14.657 114.780  17.495  1.00 39.95           N  
ATOM    537  CA  SER A  72     -13.415 115.553  17.417  1.00 40.68           C  
ATOM    538  C   SER A  72     -13.145 115.907  18.903  1.00 41.23           C  
ATOM    539  O   SER A  72     -12.469 116.879  19.161  1.00 36.99           O  
ATOM    540  CB  SER A  72     -13.446 116.853  16.595  1.00 42.96           C  
ATOM    541  OG  SER A  72     -14.541 117.677  16.989  1.00 47.51           O  
ATOM    542  N   GLY A  73     -13.664 115.140  19.869  1.00 45.09           N  
ATOM    543  CA  GLY A  73     -13.436 115.475  21.277  1.00 48.97           C  
ATOM    544  C   GLY A  73     -14.369 116.606  21.749  1.00 53.79           C  
ATOM    545  O   GLY A  73     -15.459 116.707  21.211  1.00 52.18           O  
ATOM    546  N   GLY A  74     -13.956 117.461  22.697  1.00 60.93           N  
ATOM    547  CA  GLY A  74     -14.842 118.514  23.234  1.00 69.61           C  
ATOM    548  C   GLY A  74     -14.562 120.047  23.196  1.00 76.96           C  
ATOM    549  O   GLY A  74     -13.429 120.467  22.940  1.00 80.65           O  
ATOM    550  N   ASP A  75     -15.597 120.872  23.410  1.00 81.94           N  
ATOM    551  CA  ASP A  75     -15.594 122.344  23.336  1.00 83.78           C  
ATOM    552  C   ASP A  75     -14.988 123.073  24.538  1.00 84.76           C  
ATOM    553  O   ASP A  75     -14.765 122.372  25.544  1.00 82.68           O  
ATOM    554  CB  ASP A  75     -17.060 122.786  23.112  1.00 87.17           C  
ATOM    555  CG  ASP A  75     -17.823 121.785  22.294  1.00 87.24           C  
ATOM    556  OD1 ASP A  75     -19.049 121.717  22.332  1.00 91.01           O  
ATOM    557  OD2 ASP A  75     -17.128 121.029  21.590  1.00 86.47           O  
ATOM    558  N   PRO A  91     -16.473 121.773  31.169  1.00 99.97           N  
ATOM    559  CA  PRO A  91     -15.488 121.812  32.292  1.00 98.45           C  
ATOM    560  C   PRO A  91     -15.877 121.008  33.517  1.00 95.75           C  
ATOM    561  O   PRO A  91     -15.710 121.431  34.660  1.00 97.03           O  
ATOM    562  CB  PRO A  91     -15.256 123.283  32.645  1.00100.00           C  
ATOM    563  CG  PRO A  91     -16.453 123.962  31.934  1.00100.00           C  
ATOM    564  CD  PRO A  91     -16.680 123.135  30.654  1.00100.00           C  
ATOM    565  N   ARG A  92     -16.417 119.843  33.223  1.00 89.15           N  
ATOM    566  CA  ARG A  92     -16.774 118.818  34.183  1.00 79.30           C  
ATOM    567  C   ARG A  92     -16.166 117.774  33.262  1.00 72.72           C  
ATOM    568  O   ARG A  92     -16.274 117.920  32.055  1.00 74.20           O  
ATOM    569  CB  ARG A  92     -18.315 118.727  34.401  1.00 76.22           C  
ATOM    570  CG  ARG A  92     -19.218 118.747  33.169  1.00 78.19           C  
ATOM    571  CD  ARG A  92     -20.686 118.356  33.484  1.00 79.04           C  
ATOM    572  NE  ARG A  92     -21.218 118.916  34.729  1.00 79.70           N  
ATOM    573  CZ  ARG A  92     -21.127 118.332  35.923  1.00 84.64           C  
ATOM    574  NH1 ARG A  92     -20.532 117.152  36.061  1.00 86.15           N  
ATOM    575  NH2 ARG A  92     -21.604 118.949  36.991  1.00 85.20           N  
ATOM    576  N   LEU A  93     -15.452 116.786  33.778  1.00 58.87           N  
ATOM    577  CA  LEU A  93     -14.851 115.852  32.829  1.00 47.50           C  
ATOM    578  C   LEU A  93     -15.658 114.580  32.769  1.00 44.15           C  
ATOM    579  O   LEU A  93     -15.131 113.483  32.974  1.00 35.50           O  
ATOM    580  CB  LEU A  93     -13.402 115.553  33.212  1.00 45.76           C  
ATOM    581  CG  LEU A  93     -12.256 116.474  32.771  1.00 43.97           C  
ATOM    582  CD1 LEU A  93     -10.950 115.907  33.305  1.00 37.15           C  
ATOM    583  CD2 LEU A  93     -12.203 116.571  31.253  1.00 36.69           C  
ATOM    584  N   ASN A  94     -16.946 114.729  32.475  1.00 37.28           N  
ATOM    585  CA  ASN A  94     -17.836 113.583  32.445  1.00 33.52           C  
ATOM    586  C   ASN A  94     -17.614 112.539  31.351  1.00 28.28           C  
ATOM    587  O   ASN A  94     -18.283 111.504  31.340  1.00 31.56           O  
ATOM    588  CB  ASN A  94     -19.306 114.043  32.456  1.00 35.79           C  
ATOM    589  CG  ASN A  94     -19.655 114.946  31.291  1.00 39.00           C  
ATOM    590  OD1 ASN A  94     -18.783 115.584  30.700  1.00 39.02           O  
ATOM    591  ND2 ASN A  94     -20.945 115.028  30.973  1.00 37.73           N  
ATOM    592  N   VAL A  95     -16.681 112.766  30.434  1.00 30.01           N  
ATOM    593  CA  VAL A  95     -16.459 111.758  29.397  1.00 31.80           C  
ATOM    594  C   VAL A  95     -15.764 110.555  30.051  1.00 30.87           C  
ATOM    595  O   VAL A  95     -15.889 109.415  29.591  1.00 26.78           O  
ATOM    596  CB  VAL A  95     -15.613 112.324  28.220  1.00 27.85           C  
ATOM    597  CG1 VAL A  95     -14.170 112.530  28.643  1.00 31.03           C  
ATOM    598  CG2 VAL A  95     -15.708 111.393  27.022  1.00 24.63           C  
ATOM    599  N   LEU A  96     -15.055 110.822  31.146  1.00 32.76           N  
ATOM    600  CA  LEU A  96     -14.357 109.779  31.887  1.00 33.49           C  
ATOM    601  C   LEU A  96     -15.373 108.757  32.397  1.00 34.92           C  
ATOM    602  O   LEU A  96     -15.114 107.551  32.401  1.00 31.70           O  
ATOM    603  CB  LEU A  96     -13.585 110.390  33.057  1.00 27.42           C  
ATOM    604  CG  LEU A  96     -12.439 111.338  32.687  1.00 34.96           C  
ATOM    605  CD1 LEU A  96     -11.749 111.822  33.958  1.00 30.86           C  
ATOM    606  CD2 LEU A  96     -11.444 110.623  31.789  1.00 35.55           C  
ATOM    607  N   ASP A  97     -16.535 109.249  32.822  1.00 33.24           N  
ATOM    608  CA  ASP A  97     -17.606 108.391  33.315  1.00 28.35           C  
ATOM    609  C   ASP A  97     -18.124 107.521  32.176  1.00 26.59           C  
ATOM    610  O   ASP A  97     -18.474 106.357  32.379  1.00 29.02           O  
ATOM    611  CB  ASP A  97     -18.760 109.239  33.865  1.00 37.26           C  
ATOM    612  CG  ASP A  97     -18.465 109.820  35.237  1.00 46.84           C  
ATOM    613  OD1 ASP A  97     -18.731 109.131  36.247  1.00 45.69           O  
ATOM    614  OD2 ASP A  97     -17.960 110.962  35.307  1.00 49.81           O  
ATOM    615  N   LEU A  98     -18.183 108.097  30.978  1.00 22.57           N  
ATOM    616  CA  LEU A  98     -18.662 107.373  29.806  1.00 27.38           C  
ATOM    617  C   LEU A  98     -17.660 106.289  29.408  1.00 16.07           C  
ATOM    618  O   LEU A  98     -18.046 105.192  29.005  1.00 23.58           O  
ATOM    619  CB  LEU A  98     -18.896 108.344  28.636  1.00 22.46           C  
ATOM    620  CG  LEU A  98     -19.259 107.734  27.272  1.00 19.75           C  
ATOM    621  CD1 LEU A  98     -20.502 106.880  27.399  1.00 19.13           C  
ATOM    622  CD2 LEU A  98     -19.476 108.833  26.250  1.00 33.55           C  
ATOM    623  N   GLN A  99     -16.375 106.601  29.521  1.00 24.82           N  
ATOM    624  CA  GLN A  99     -15.333 105.633  29.184  1.00 23.11           C  
ATOM    625  C   GLN A  99     -15.492 104.394  30.063  1.00 22.15           C  
ATOM    626  O   GLN A  99     -15.474 103.266  29.573  1.00 23.65           O  
ATOM    627  CB  GLN A  99     -13.948 106.246  29.394  1.00 15.74           C  
ATOM    628  CG  GLN A  99     -13.582 107.327  28.394  1.00 21.08           C  
ATOM    629  CD  GLN A  99     -12.212 107.937  28.653  1.00 24.17           C  
ATOM    630  OE1 GLN A  99     -11.776 108.837  27.932  1.00 24.77           O  
ATOM    631  NE2 GLN A  99     -11.527 107.448  29.684  1.00 25.08           N  
ATOM    632  N   ARG A 100     -15.664 104.616  31.362  1.00 22.53           N  
ATOM    633  CA  ARG A 100     -15.834 103.518  32.302  1.00 20.74           C  
ATOM    634  C   ARG A 100     -17.097 102.733  31.982  1.00 21.69           C  
ATOM    635  O   ARG A 100     -17.097 101.502  32.004  1.00 22.41           O  
ATOM    636  CB  ARG A 100     -15.899 104.053  33.740  1.00 18.99           C  
ATOM    637  CG  ARG A 100     -14.631 104.780  34.177  1.00 32.24           C  
ATOM    638  CD  ARG A 100     -14.565 104.947  35.688  1.00 35.65           C  
ATOM    639  NE  ARG A 100     -15.610 105.824  36.224  1.00 43.77           N  
ATOM    640  CZ  ARG A 100     -15.615 107.150  36.122  1.00 37.59           C  
ATOM    641  NH1 ARG A 100     -14.631 107.781  35.499  1.00 37.32           N  
ATOM    642  NH2 ARG A 100     -16.602 107.851  36.661  1.00 40.72           N  
ATOM    643  N   LEU A 101     -18.170 103.453  31.668  1.00 24.51           N  
ATOM    644  CA  LEU A 101     -19.448 102.827  31.341  1.00 23.22           C  
ATOM    645  C   LEU A 101     -19.311 101.912  30.124  1.00 22.10           C  
ATOM    646  O   LEU A 101     -19.747 100.759  30.155  1.00 22.67           O  
ATOM    647  CB  LEU A 101     -20.506 103.902  31.052  1.00 29.36           C  
ATOM    648  CG  LEU A 101     -21.969 103.613  31.409  1.00 28.80           C  
ATOM    649  CD1 LEU A 101     -22.863 104.400  30.457  1.00 38.85           C  
ATOM    650  CD2 LEU A 101     -22.281 102.132  31.311  1.00 24.43           C  
ATOM    651  N   ILE A 102     -18.716 102.429  29.049  1.00 19.15           N  
ATOM    652  CA  ILE A 102     -18.524 101.638  27.830  1.00 17.97           C  
ATOM    653  C   ILE A 102     -17.772 100.336  28.126  1.00 19.10           C  
ATOM    654  O   ILE A 102     -18.015  99.303  27.492  1.00 16.28           O  
ATOM    655  CB  ILE A 102     -17.739 102.442  26.756  1.00 23.22           C  
ATOM    656  CG1 ILE A 102     -18.605 103.596  26.238  1.00 23.87           C  
ATOM    657  CG2 ILE A 102     -17.325 101.528  25.593  1.00 24.65           C  
ATOM    658  CD1 ILE A 102     -17.939 104.443  25.187  1.00 24.52           C  
ATOM    659  N   ARG A 103     -16.870 100.390  29.103  1.00 17.05           N  
ATOM    660  CA  ARG A 103     -16.086  99.223  29.478  1.00 19.33           C  
ATOM    661  C   ARG A 103     -16.839  98.256  30.389  1.00 22.19           C  
ATOM    662  O   ARG A 103     -16.625  97.049  30.321  1.00 24.33           O  
ATOM    663  CB  ARG A 103     -14.781  99.668  30.154  1.00 15.98           C  
ATOM    664  CG  ARG A 103     -13.767 100.268  29.197  1.00 16.69           C  
ATOM    665  CD  ARG A 103     -12.551 100.812  29.931  1.00 20.35           C  
ATOM    666  NE  ARG A 103     -11.776  99.788  30.640  1.00 18.58           N  
ATOM    667  CZ  ARG A 103     -10.879  98.978  30.078  1.00 22.01           C  
ATOM    668  NH1 ARG A 103     -10.625  99.046  28.777  1.00 16.33           N  
ATOM    669  NH2 ARG A 103     -10.199  98.120  30.835  1.00 20.68           N  
ATOM    670  N   VAL A 104     -17.721  98.779  31.235  1.00 27.25           N  
ATOM    671  CA  VAL A 104     -18.468  97.930  32.158  1.00 22.02           C  
ATOM    672  C   VAL A 104     -19.666  97.211  31.523  1.00 21.92           C  
ATOM    673  O   VAL A 104     -20.025  96.104  31.935  1.00 20.90           O  
ATOM    674  CB  VAL A 104     -18.947  98.739  33.387  1.00 23.21           C  
ATOM    675  CG1 VAL A 104     -20.160  99.575  33.031  1.00 27.69           C  
ATOM    676  CG2 VAL A 104     -19.254  97.797  34.534  1.00 26.91           C  
ATOM    677  N   ILE A 105     -20.284  97.829  30.522  1.00 29.46           N  
ATOM    678  CA  ILE A 105     -21.424  97.199  29.863  1.00 27.49           C  
ATOM    679  C   ILE A 105     -20.981  95.832  29.353  1.00 28.81           C  
ATOM    680  O   ILE A 105     -20.056  95.727  28.545  1.00 23.93           O  
ATOM    681  CB  ILE A 105     -21.940  98.054  28.696  1.00 30.07           C  
ATOM    682  CG1 ILE A 105     -22.551  99.344  29.246  1.00 34.06           C  
ATOM    683  CG2 ILE A 105     -22.962  97.268  27.877  1.00 28.78           C  
ATOM    684  CD1 ILE A 105     -23.138 100.255  28.185  1.00 40.28           C  
ATOM    685  N   PRO A 106     -21.641  94.762  29.826  1.00 23.66           N  
ATOM    686  CA  PRO A 106     -21.329  93.386  29.443  1.00 20.16           C  
ATOM    687  C   PRO A 106     -21.699  93.042  28.007  1.00 25.21           C  
ATOM    688  O   PRO A 106     -22.096  91.918  27.714  1.00 28.29           O  
ATOM    689  CB  PRO A 106     -22.119  92.570  30.457  1.00 26.93           C  
ATOM    690  CG  PRO A 106     -23.360  93.392  30.617  1.00 20.73           C  
ATOM    691  CD  PRO A 106     -22.797  94.798  30.743  1.00 23.41           C  
ATOM    692  N   LYS A 107     -21.559  94.014  27.113  1.00 27.09           N  
ATOM    693  CA  LYS A 107     -21.886  93.811  25.707  1.00 25.80           C  
ATOM    694  C   LYS A 107     -20.830  94.485  24.848  1.00 23.97           C  
ATOM    695  O   LYS A 107     -20.384  95.594  25.153  1.00 23.69           O  
ATOM    696  CB  LYS A 107     -23.259  94.417  25.393  1.00 22.99           C  
ATOM    697  CG  LYS A 107     -24.382  93.890  26.279  1.00 32.66           C  
ATOM    698  CD  LYS A 107     -25.683  94.631  26.040  1.00 30.68           C  
ATOM    699  CE  LYS A 107     -26.794  94.106  26.945  1.00 31.86           C  
ATOM    700  NZ  LYS A 107     -28.036  94.915  26.804  1.00 33.79           N  
ATOM    701  N   PRO A 108     -20.409  93.822  23.764  1.00 19.46           N  
ATOM    702  CA  PRO A 108     -19.398  94.394  22.872  1.00 24.94           C  
ATOM    703  C   PRO A 108     -19.857  95.732  22.309  1.00 25.36           C  
ATOM    704  O   PRO A 108     -21.010  95.875  21.899  1.00 24.34           O  
ATOM    705  CB  PRO A 108     -19.269  93.335  21.776  1.00 22.22           C  
ATOM    706  CG  PRO A 108     -19.548  92.069  22.503  1.00 19.24           C  
ATOM    707  CD  PRO A 108     -20.743  92.446  23.358  1.00 20.30           C  
ATOM    708  N   VAL A 109     -18.955  96.708  22.302  1.00 25.20           N  
ATOM    709  CA  VAL A 109     -19.253  98.032  21.761  1.00 23.08           C  
ATOM    710  C   VAL A 109     -18.313  98.280  20.576  1.00 32.44           C  
ATOM    711  O   VAL A 109     -17.088  98.266  20.731  1.00 29.05           O  
ATOM    712  CB  VAL A 109     -19.031  99.143  22.809  1.00 21.02           C  
ATOM    713  CG1 VAL A 109     -19.423 100.479  22.231  1.00 17.90           C  
ATOM    714  CG2 VAL A 109     -19.849  98.852  24.071  1.00 20.35           C  
ATOM    715  N   ILE A 110     -18.893  98.489  19.397  1.00 27.32           N  
ATOM    716  CA  ILE A 110     -18.117  98.726  18.183  1.00 23.31           C  
ATOM    717  C   ILE A 110     -18.152 100.183  17.764  1.00 26.70           C  
ATOM    718  O   ILE A 110     -19.226 100.753  17.559  1.00 31.53           O  
ATOM    719  CB  ILE A 110     -18.658  97.924  16.983  1.00 22.02           C  
ATOM    720  CG1 ILE A 110     -18.753  96.445  17.331  1.00 20.18           C  
ATOM    721  CG2 ILE A 110     -17.761  98.146  15.764  1.00 24.59           C  
ATOM    722  CD1 ILE A 110     -19.293  95.588  16.202  1.00 23.77           C  
ATOM    723  N   ALA A 111     -16.980 100.790  17.633  1.00 20.63           N  
ATOM    724  CA  ALA A 111     -16.912 102.172  17.189  1.00 20.36           C  
ATOM    725  C   ALA A 111     -16.915 102.114  15.653  1.00 21.80           C  
ATOM    726  O   ALA A 111     -16.091 101.426  15.054  1.00 22.21           O  
ATOM    727  CB  ALA A 111     -15.638 102.828  17.699  1.00 20.41           C  
ATOM    728  N   MET A 112     -17.866 102.802  15.029  1.00 24.80           N  
ATOM    729  CA  MET A 112     -17.978 102.842  13.572  1.00 28.94           C  
ATOM    730  C   MET A 112     -17.434 104.216  13.199  1.00 29.63           C  
ATOM    731  O   MET A 112     -18.129 105.221  13.303  1.00 31.99           O  
ATOM    732  CB  MET A 112     -19.447 102.699  13.157  1.00 35.08           C  
ATOM    733  CG  MET A 112     -19.678 102.454  11.670  1.00 40.35           C  
ATOM    734  SD  MET A 112     -21.410 102.036  11.279  1.00 40.34           S  
ATOM    735  CE  MET A 112     -22.147 103.652  11.329  1.00 31.76           C  
ATOM    736  N   VAL A 113     -16.180 104.250  12.764  1.00 27.80           N  
ATOM    737  CA  VAL A 113     -15.527 105.509  12.458  1.00 20.75           C  
ATOM    738  C   VAL A 113     -15.468 105.983  11.015  1.00 28.15           C  
ATOM    739  O   VAL A 113     -14.960 105.301  10.127  1.00 24.80           O  
ATOM    740  CB  VAL A 113     -14.096 105.501  13.023  1.00 28.05           C  
ATOM    741  CG1 VAL A 113     -13.384 106.798  12.670  1.00 29.58           C  
ATOM    742  CG2 VAL A 113     -14.144 105.307  14.533  1.00 22.98           C  
ATOM    743  N   ALA A 114     -15.987 107.186  10.804  1.00 29.55           N  
ATOM    744  CA  ALA A 114     -15.984 107.814   9.495  1.00 31.65           C  
ATOM    745  C   ALA A 114     -15.410 109.198   9.739  1.00 32.61           C  
ATOM    746  O   ALA A 114     -15.820 109.893  10.664  1.00 30.43           O  
ATOM    747  CB  ALA A 114     -17.394 107.914   8.951  1.00 30.12           C  
ATOM    748  N   GLY A 115     -14.440 109.590   8.929  1.00 34.69           N  
ATOM    749  CA  GLY A 115     -13.848 110.896   9.117  1.00 33.84           C  
ATOM    750  C   GLY A 115     -13.044 111.008  10.399  1.00 38.33           C  
ATOM    751  O   GLY A 115     -12.412 110.050  10.850  1.00 31.22           O  
ATOM    752  N   TYR A 116     -13.095 112.190  11.000  1.00 33.82           N  
ATOM    753  CA  TYR A 116     -12.347 112.486  12.209  1.00 31.59           C  
ATOM    754  C   TYR A 116     -12.718 111.786  13.512  1.00 33.07           C  
ATOM    755  O   TYR A 116     -13.879 111.764  13.920  1.00 30.67           O  
ATOM    756  CB  TYR A 116     -12.375 113.991  12.444  1.00 31.15           C  
ATOM    757  CG  TYR A 116     -11.665 114.769  11.368  1.00 44.58           C  
ATOM    758  CD1 TYR A 116     -10.273 114.834  11.334  1.00 48.10           C  
ATOM    759  CD2 TYR A 116     -12.383 115.441  10.377  1.00 49.36           C  
ATOM    760  CE1 TYR A 116      -9.610 115.554  10.339  1.00 50.46           C  
ATOM    761  CE2 TYR A 116     -11.732 116.162   9.378  1.00 46.45           C  
ATOM    762  CZ  TYR A 116     -10.346 116.217   9.367  1.00 45.67           C  
ATOM    763  OH  TYR A 116      -9.696 116.945   8.397  1.00 49.95           O  
ATOM    764  N   ALA A 117     -11.699 111.217  14.151  1.00 21.10           N  
ATOM    765  CA  ALA A 117     -11.826 110.568  15.455  1.00 24.57           C  
ATOM    766  C   ALA A 117     -10.635 111.192  16.170  1.00 26.10           C  
ATOM    767  O   ALA A 117      -9.564 110.589  16.274  1.00 30.03           O  
ATOM    768  CB  ALA A 117     -11.661 109.055  15.335  1.00 19.00           C  
ATOM    769  N   ILE A 118     -10.828 112.423  16.638  1.00 28.61           N  
ATOM    770  CA  ILE A 118      -9.761 113.191  17.272  1.00 31.27           C  
ATOM    771  C   ILE A 118      -9.969 113.586  18.729  1.00 24.37           C  
ATOM    772  O   ILE A 118     -11.099 113.727  19.192  1.00 22.96           O  
ATOM    773  CB  ILE A 118      -9.499 114.483  16.458  1.00 30.78           C  
ATOM    774  CG1 ILE A 118      -9.139 114.119  15.017  1.00 32.67           C  
ATOM    775  CG2 ILE A 118      -8.395 115.299  17.098  1.00 32.10           C  
ATOM    776  CD1 ILE A 118      -7.924 113.223  14.889  1.00 24.91           C  
ATOM    777  N   GLY A 119      -8.853 113.782  19.429  1.00 17.02           N  
ATOM    778  CA  GLY A 119      -8.875 114.177  20.827  1.00 22.17           C  
ATOM    779  C   GLY A 119      -9.681 113.228  21.684  1.00 27.97           C  
ATOM    780  O   GLY A 119      -9.483 112.008  21.634  1.00 30.65           O  
ATOM    781  N   GLY A 120     -10.596 113.785  22.471  1.00 26.17           N  
ATOM    782  CA  GLY A 120     -11.436 112.963  23.316  1.00 18.15           C  
ATOM    783  C   GLY A 120     -12.192 111.991  22.437  1.00 20.82           C  
ATOM    784  O   GLY A 120     -12.592 110.913  22.877  1.00 27.25           O  
ATOM    785  N   GLY A 121     -12.375 112.373  21.175  1.00 21.47           N  
ATOM    786  CA  GLY A 121     -13.080 111.522  20.230  1.00 19.90           C  
ATOM    787  C   GLY A 121     -12.267 110.290  19.877  1.00 22.33           C  
ATOM    788  O   GLY A 121     -12.823 109.221  19.628  1.00 25.24           O  
ATOM    789  N   HIS A 122     -10.946 110.434  19.841  1.00 23.42           N  
ATOM    790  CA  HIS A 122     -10.084 109.297  19.535  1.00 20.89           C  
ATOM    791  C   HIS A 122     -10.084 108.338  20.738  1.00 19.95           C  
ATOM    792  O   HIS A 122     -10.205 107.118  20.574  1.00 17.55           O  
ATOM    793  CB  HIS A 122      -8.653 109.764  19.236  1.00 17.16           C  
ATOM    794  CG  HIS A 122      -7.741 108.658  18.801  1.00 24.69           C  
ATOM    795  ND1 HIS A 122      -7.808 108.084  17.549  1.00 21.32           N  
ATOM    796  CD2 HIS A 122      -6.763 107.997  19.466  1.00 15.53           C  
ATOM    797  CE1 HIS A 122      -6.912 107.119  17.461  1.00 24.47           C  
ATOM    798  NE2 HIS A 122      -6.263 107.043  18.609  1.00 23.57           N  
ATOM    799  N   VAL A 123      -9.952 108.887  21.943  1.00 17.06           N  
ATOM    800  CA  VAL A 123      -9.961 108.059  23.148  1.00 18.87           C  
ATOM    801  C   VAL A 123     -11.256 107.236  23.203  1.00 21.44           C  
ATOM    802  O   VAL A 123     -11.246 106.069  23.622  1.00 20.26           O  
ATOM    803  CB  VAL A 123      -9.851 108.921  24.437  1.00 20.76           C  
ATOM    804  CG1 VAL A 123      -9.897 108.031  25.673  1.00 21.12           C  
ATOM    805  CG2 VAL A 123      -8.559 109.720  24.427  1.00 18.52           C  
ATOM    806  N   LEU A 124     -12.364 107.836  22.764  1.00 20.32           N  
ATOM    807  CA  LEU A 124     -13.654 107.149  22.771  1.00 18.75           C  
ATOM    808  C   LEU A 124     -13.679 105.912  21.882  1.00 19.39           C  
ATOM    809  O   LEU A 124     -14.211 104.874  22.277  1.00 19.61           O  
ATOM    810  CB  LEU A 124     -14.786 108.106  22.359  1.00 22.81           C  
ATOM    811  CG  LEU A 124     -15.308 109.066  23.435  1.00 24.84           C  
ATOM    812  CD1 LEU A 124     -16.318 110.038  22.823  1.00 29.32           C  
ATOM    813  CD2 LEU A 124     -15.959 108.265  24.563  1.00 12.01           C  
ATOM    814  N   HIS A 125     -13.127 106.013  20.677  1.00 17.81           N  
ATOM    815  CA  HIS A 125     -13.097 104.851  19.797  1.00 18.28           C  
ATOM    816  C   HIS A 125     -12.112 103.833  20.389  1.00 18.22           C  
ATOM    817  O   HIS A 125     -12.284 102.618  20.249  1.00 20.17           O  
ATOM    818  CB  HIS A 125     -12.674 105.254  18.372  1.00 16.33           C  
ATOM    819  CG  HIS A 125     -11.304 104.788  17.980  1.00 17.25           C  
ATOM    820  ND1 HIS A 125     -10.188 105.591  18.067  1.00 16.54           N  
ATOM    821  CD2 HIS A 125     -10.876 103.596  17.500  1.00 16.61           C  
ATOM    822  CE1 HIS A 125      -9.129 104.914  17.655  1.00 15.34           C  
ATOM    823  NE2 HIS A 125      -9.523 103.700  17.304  1.00 20.76           N  
ATOM    824  N   VAL A 126     -11.086 104.341  21.063  1.00 17.24           N  
ATOM    825  CA  VAL A 126     -10.090 103.478  21.681  1.00 20.47           C  
ATOM    826  C   VAL A 126     -10.710 102.571  22.750  1.00 14.69           C  
ATOM    827  O   VAL A 126     -10.477 101.368  22.740  1.00 17.71           O  
ATOM    828  CB  VAL A 126      -8.928 104.318  22.286  1.00 19.01           C  
ATOM    829  CG1 VAL A 126      -8.155 103.505  23.323  1.00 14.59           C  
ATOM    830  CG2 VAL A 126      -7.977 104.767  21.158  1.00 18.67           C  
ATOM    831  N   VAL A 127     -11.524 103.132  23.645  1.00 18.53           N  
ATOM    832  CA  VAL A 127     -12.127 102.314  24.699  1.00 18.81           C  
ATOM    833  C   VAL A 127     -13.234 101.372  24.225  1.00 18.06           C  
ATOM    834  O   VAL A 127     -13.634 100.465  24.955  1.00 16.37           O  
ATOM    835  CB  VAL A 127     -12.656 103.174  25.887  1.00 18.79           C  
ATOM    836  CG1 VAL A 127     -11.500 103.928  26.529  1.00 13.45           C  
ATOM    837  CG2 VAL A 127     -13.741 104.135  25.418  1.00 21.48           C  
ATOM    838  N   CYS A 128     -13.742 101.578  23.013  1.00 21.03           N  
ATOM    839  CA  CYS A 128     -14.760 100.669  22.491  1.00 20.25           C  
ATOM    840  C   CYS A 128     -14.032  99.356  22.239  1.00 17.28           C  
ATOM    841  O   CYS A 128     -12.849  99.361  21.921  1.00 18.63           O  
ATOM    842  CB  CYS A 128     -15.353 101.191  21.178  1.00 25.70           C  
ATOM    843  SG  CYS A 128     -16.501 102.579  21.365  1.00 22.08           S  
ATOM    844  N   ASP A 129     -14.731  98.238  22.389  1.00 13.33           N  
ATOM    845  CA  ASP A 129     -14.119  96.934  22.180  1.00 18.81           C  
ATOM    846  C   ASP A 129     -13.465  96.813  20.803  1.00 23.83           C  
ATOM    847  O   ASP A 129     -12.305  96.404  20.691  1.00 15.10           O  
ATOM    848  CB  ASP A 129     -15.167  95.831  22.361  1.00 25.06           C  
ATOM    849  CG  ASP A 129     -15.764  95.812  23.765  1.00 26.46           C  
ATOM    850  OD1 ASP A 129     -15.094  95.328  24.705  1.00 23.09           O  
ATOM    851  OD2 ASP A 129     -16.904  96.291  23.931  1.00 31.29           O  
ATOM    852  N   LEU A 130     -14.204  97.181  19.759  1.00 19.56           N  
ATOM    853  CA  LEU A 130     -13.696  97.088  18.393  1.00 17.54           C  
ATOM    854  C   LEU A 130     -13.921  98.384  17.632  1.00 19.94           C  
ATOM    855  O   LEU A 130     -14.693  99.240  18.057  1.00 16.24           O  
ATOM    856  CB  LEU A 130     -14.399  95.947  17.645  1.00 21.26           C  
ATOM    857  CG  LEU A 130     -14.501  94.586  18.340  1.00 20.99           C  
ATOM    858  CD1 LEU A 130     -15.370  93.661  17.502  1.00 25.57           C  
ATOM    859  CD2 LEU A 130     -13.109  93.982  18.535  1.00 19.21           C  
ATOM    860  N   THR A 131     -13.230  98.526  16.505  1.00 21.41           N  
ATOM    861  CA  THR A 131     -13.366  99.707  15.664  1.00 20.17           C  
ATOM    862  C   THR A 131     -13.354  99.332  14.184  1.00 25.22           C  
ATOM    863  O   THR A 131     -12.461  98.626  13.721  1.00 18.44           O  
ATOM    864  CB  THR A 131     -12.226 100.713  15.888  1.00 21.80           C  
ATOM    865  OG1 THR A 131     -12.303 101.240  17.215  1.00 15.02           O  
ATOM    866  CG2 THR A 131     -12.330 101.859  14.878  1.00 19.57           C  
ATOM    867  N   ILE A 132     -14.359  99.793  13.452  1.00 18.98           N  
ATOM    868  CA  ILE A 132     -14.423  99.539  12.024  1.00 20.04           C  
ATOM    869  C   ILE A 132     -14.338 100.932  11.428  1.00 24.97           C  
ATOM    870  O   ILE A 132     -15.098 101.823  11.802  1.00 27.23           O  
ATOM    871  CB  ILE A 132     -15.731  98.848  11.618  1.00 18.09           C  
ATOM    872  CG1 ILE A 132     -15.862  97.522  12.364  1.00 21.80           C  
ATOM    873  CG2 ILE A 132     -15.731  98.588  10.118  1.00 24.91           C  
ATOM    874  CD1 ILE A 132     -17.115  96.753  12.051  1.00 30.96           C  
ATOM    875  N   ALA A 133     -13.386 101.125  10.524  1.00 24.47           N  
ATOM    876  CA  ALA A 133     -13.181 102.430   9.921  1.00 28.22           C  
ATOM    877  C   ALA A 133     -13.386 102.485   8.413  1.00 28.87           C  
ATOM    878  O   ALA A 133     -13.181 101.499   7.697  1.00 26.91           O  
ATOM    879  CB  ALA A 133     -11.781 102.926  10.262  1.00 19.98           C  
ATOM    880  N   ALA A 134     -13.798 103.657   7.944  1.00 27.71           N  
ATOM    881  CA  ALA A 134     -13.985 103.889   6.522  1.00 29.47           C  
ATOM    882  C   ALA A 134     -12.612 104.353   6.053  1.00 25.72           C  
ATOM    883  O   ALA A 134     -11.834 104.886   6.852  1.00 24.09           O  
ATOM    884  CB  ALA A 134     -15.027 104.982   6.295  1.00 26.97           C  
ATOM    885  N   ASP A 135     -12.303 104.162   4.774  1.00 28.20           N  
ATOM    886  CA  ASP A 135     -10.996 104.573   4.265  1.00 28.45           C  
ATOM    887  C   ASP A 135     -10.731 106.070   4.396  1.00 27.79           C  
ATOM    888  O   ASP A 135      -9.599 106.525   4.201  1.00 31.24           O  
ATOM    889  CB  ASP A 135     -10.815 104.132   2.804  1.00 31.52           C  
ATOM    890  CG  ASP A 135     -11.971 104.539   1.919  1.00 37.51           C  
ATOM    891  OD1 ASP A 135     -12.871 105.265   2.392  1.00 40.19           O  
ATOM    892  OD2 ASP A 135     -11.975 104.128   0.741  1.00 41.44           O  
ATOM    893  N   ASN A 136     -11.756 106.838   4.744  1.00 23.02           N  
ATOM    894  CA  ASN A 136     -11.581 108.280   4.893  1.00 22.73           C  
ATOM    895  C   ASN A 136     -11.368 108.689   6.357  1.00 29.00           C  
ATOM    896  O   ASN A 136     -11.188 109.871   6.653  1.00 32.86           O  
ATOM    897  CB  ASN A 136     -12.803 109.015   4.339  1.00 26.78           C  
ATOM    898  CG  ASN A 136     -13.948 109.070   5.328  1.00 28.09           C  
ATOM    899  OD1 ASN A 136     -14.245 108.086   6.004  1.00 31.11           O  
ATOM    900  ND2 ASN A 136     -14.602 110.225   5.412  1.00 30.58           N  
ATOM    901  N   ALA A 137     -11.384 107.716   7.266  1.00 23.79           N  
ATOM    902  CA  ALA A 137     -11.210 108.003   8.693  1.00 26.23           C  
ATOM    903  C   ALA A 137      -9.834 108.567   9.043  1.00 25.92           C  
ATOM    904  O   ALA A 137      -8.814 108.125   8.508  1.00 22.12           O  
ATOM    905  CB  ALA A 137     -11.483 106.742   9.518  1.00 27.53           C  
ATOM    906  N   ILE A 138      -9.825 109.547   9.950  1.00 25.56           N  
ATOM    907  CA  ILE A 138      -8.604 110.211  10.413  1.00 21.96           C  
ATOM    908  C   ILE A 138      -8.487 110.034  11.928  1.00 26.27           C  
ATOM    909  O   ILE A 138      -9.420 110.355  12.660  1.00 25.00           O  
ATOM    910  CB  ILE A 138      -8.645 111.731  10.123  1.00 27.23           C  
ATOM    911  CG1 ILE A 138      -8.900 111.990   8.634  1.00 35.75           C  
ATOM    912  CG2 ILE A 138      -7.342 112.376  10.562  1.00 25.32           C  
ATOM    913  CD1 ILE A 138      -7.748 111.620   7.719  1.00 37.25           C  
ATOM    914  N   PHE A 139      -7.337 109.552  12.396  1.00 23.60           N  
ATOM    915  CA  PHE A 139      -7.116 109.315  13.825  1.00 20.87           C  
ATOM    916  C   PHE A 139      -5.987 110.159  14.401  1.00 21.09           C  
ATOM    917  O   PHE A 139      -5.056 110.531  13.688  1.00 21.16           O  
ATOM    918  CB  PHE A 139      -6.767 107.844  14.067  1.00 20.08           C  
ATOM    919  CG  PHE A 139      -7.810 106.885  13.590  1.00 17.68           C  
ATOM    920  CD1 PHE A 139      -8.773 106.390  14.465  1.00 21.45           C  
ATOM    921  CD2 PHE A 139      -7.845 106.486  12.259  1.00 20.73           C  
ATOM    922  CE1 PHE A 139      -9.758 105.512  14.015  1.00 26.41           C  
ATOM    923  CE2 PHE A 139      -8.822 105.614  11.801  1.00 14.59           C  
ATOM    924  CZ  PHE A 139      -9.781 105.124  12.679  1.00 15.43           C  
ATOM    925  N   GLY A 140      -6.066 110.431  15.703  1.00 22.87           N  
ATOM    926  CA  GLY A 140      -5.032 111.207  16.368  1.00 23.25           C  
ATOM    927  C   GLY A 140      -5.485 111.933  17.626  1.00 18.87           C  
ATOM    928  O   GLY A 140      -6.677 112.059  17.880  1.00 19.36           O  
ATOM    929  N   GLN A 141      -4.525 112.402  18.420  1.00 23.43           N  
ATOM    930  CA  GLN A 141      -4.818 113.152  19.644  1.00 26.83           C  
ATOM    931  C   GLN A 141      -4.495 114.628  19.377  1.00 26.51           C  
ATOM    932  O   GLN A 141      -3.861 114.948  18.374  1.00 28.09           O  
ATOM    933  CB  GLN A 141      -3.968 112.648  20.818  1.00 20.72           C  
ATOM    934  CG  GLN A 141      -4.176 111.183  21.219  1.00 20.47           C  
ATOM    935  CD  GLN A 141      -5.597 110.865  21.661  1.00 24.46           C  
ATOM    936  OE1 GLN A 141      -6.313 111.720  22.183  1.00 17.31           O  
ATOM    937  NE2 GLN A 141      -6.002 109.620  21.471  1.00 14.22           N  
ATOM    938  N   THR A 142      -4.918 115.516  20.276  1.00 21.18           N  
ATOM    939  CA  THR A 142      -4.682 116.952  20.113  1.00 28.15           C  
ATOM    940  C   THR A 142      -4.283 117.651  21.407  1.00 32.29           C  
ATOM    941  O   THR A 142      -3.772 118.773  21.382  1.00 32.76           O  
ATOM    942  CB  THR A 142      -5.940 117.663  19.563  1.00 25.52           C  
ATOM    943  OG1 THR A 142      -7.089 117.273  20.329  1.00 28.39           O  
ATOM    944  CG2 THR A 142      -6.160 117.301  18.110  1.00 25.41           C  
ATOM    945  N   GLY A 143      -4.521 116.978  22.528  1.00 34.38           N  
ATOM    946  CA  GLY A 143      -4.206 117.530  23.835  1.00 30.49           C  
ATOM    947  C   GLY A 143      -2.994 118.441  23.951  1.00 25.81           C  
ATOM    948  O   GLY A 143      -3.155 119.632  24.192  1.00 30.60           O  
ATOM    949  N   PRO A 144      -1.769 117.913  23.792  1.00 30.59           N  
ATOM    950  CA  PRO A 144      -0.550 118.725  23.896  1.00 30.26           C  
ATOM    951  C   PRO A 144      -0.557 120.000  23.047  1.00 35.46           C  
ATOM    952  O   PRO A 144       0.245 120.905  23.276  1.00 35.93           O  
ATOM    953  CB  PRO A 144       0.550 117.747  23.483  1.00 33.30           C  
ATOM    954  CG  PRO A 144       0.007 116.421  23.947  1.00 30.06           C  
ATOM    955  CD  PRO A 144      -1.437 116.501  23.518  1.00 26.83           C  
ATOM    956  N   LYS A 145      -1.454 120.064  22.066  1.00 36.85           N  
ATOM    957  CA  LYS A 145      -1.559 121.242  21.213  1.00 36.23           C  
ATOM    958  C   LYS A 145      -2.532 122.262  21.792  1.00 34.55           C  
ATOM    959  O   LYS A 145      -2.226 123.447  21.858  1.00 33.50           O  
ATOM    960  CB  LYS A 145      -2.043 120.874  19.807  1.00 40.93           C  
ATOM    961  CG  LYS A 145      -1.016 120.210  18.919  1.00 42.07           C  
ATOM    962  CD  LYS A 145      -1.481 120.204  17.467  1.00 47.63           C  
ATOM    963  CE  LYS A 145      -2.826 119.515  17.311  1.00 50.84           C  
ATOM    964  NZ  LYS A 145      -3.329 119.580  15.911  1.00 59.34           N  
ATOM    965  N   VAL A 146      -3.705 121.795  22.206  1.00 34.98           N  
ATOM    966  CA  VAL A 146      -4.722 122.686  22.750  1.00 33.40           C  
ATOM    967  C   VAL A 146      -4.782 122.721  24.277  1.00 32.90           C  
ATOM    968  O   VAL A 146      -5.794 123.105  24.862  1.00 32.14           O  
ATOM    969  CB  VAL A 146      -6.108 122.323  22.191  1.00 35.38           C  
ATOM    970  CG1 VAL A 146      -6.077 122.390  20.671  1.00 36.76           C  
ATOM    971  CG2 VAL A 146      -6.517 120.931  22.656  1.00 41.51           C  
ATOM    972  N   GLY A 147      -3.690 122.323  24.916  1.00 32.63           N  
ATOM    973  CA  GLY A 147      -3.628 122.343  26.367  1.00 31.55           C  
ATOM    974  C   GLY A 147      -4.559 121.373  27.065  1.00 38.62           C  
ATOM    975  O   GLY A 147      -5.476 121.787  27.774  1.00 42.09           O  
ATOM    976  N   SER A 148      -4.324 120.081  26.872  1.00 33.90           N  
ATOM    977  CA  SER A 148      -5.146 119.051  27.500  1.00 34.61           C  
ATOM    978  C   SER A 148      -4.459 117.695  27.375  1.00 27.58           C  
ATOM    979  O   SER A 148      -3.417 117.578  26.734  1.00 26.23           O  
ATOM    980  CB  SER A 148      -6.527 118.993  26.840  1.00 35.13           C  
ATOM    981  OG  SER A 148      -7.306 117.937  27.377  1.00 34.02           O  
ATOM    982  N   PHE A 149      -5.039 116.676  27.996  1.00 27.01           N  
ATOM    983  CA  PHE A 149      -4.463 115.339  27.929  1.00 27.98           C  
ATOM    984  C   PHE A 149      -5.333 114.329  28.655  1.00 28.28           C  
ATOM    985  O   PHE A 149      -6.049 114.667  29.596  1.00 28.06           O  
ATOM    986  CB  PHE A 149      -3.040 115.333  28.521  1.00 10.87           C  
ATOM    987  CG  PHE A 149      -2.987 115.630  30.005  1.00 23.62           C  
ATOM    988  CD1 PHE A 149      -3.272 114.638  30.942  1.00 19.75           C  
ATOM    989  CD2 PHE A 149      -2.659 116.906  30.464  1.00 20.10           C  
ATOM    990  CE1 PHE A 149      -3.233 114.914  32.310  1.00 19.84           C  
ATOM    991  CE2 PHE A 149      -2.616 117.190  31.826  1.00 21.10           C  
ATOM    992  CZ  PHE A 149      -2.905 116.189  32.753  1.00 24.13           C  
ATOM    993  N   ASP A 150      -5.281 113.089  28.184  1.00 24.73           N  
ATOM    994  CA  ASP A 150      -6.022 111.997  28.785  1.00 20.49           C  
ATOM    995  C   ASP A 150      -4.956 110.961  29.114  1.00 22.08           C  
ATOM    996  O   ASP A 150      -4.520 110.208  28.245  1.00 20.07           O  
ATOM    997  CB  ASP A 150      -7.032 111.412  27.798  1.00 17.81           C  
ATOM    998  CG  ASP A 150      -7.846 110.286  28.403  1.00 24.35           C  
ATOM    999  OD1 ASP A 150      -7.299 109.545  29.247  1.00 31.03           O  
ATOM   1000  OD2 ASP A 150      -9.026 110.126  28.031  1.00 28.41           O  
ATOM   1001  N   GLY A 151      -4.526 110.946  30.370  1.00 23.33           N  
ATOM   1002  CA  GLY A 151      -3.496 110.013  30.785  1.00 23.21           C  
ATOM   1003  C   GLY A 151      -4.048 108.721  31.346  1.00 23.45           C  
ATOM   1004  O   GLY A 151      -3.312 107.928  31.932  1.00 13.29           O  
ATOM   1005  N   GLY A 152      -5.347 108.508  31.169  1.00 22.04           N  
ATOM   1006  CA  GLY A 152      -5.964 107.294  31.664  1.00 21.17           C  
ATOM   1007  C   GLY A 152      -5.914 106.214  30.605  1.00 20.02           C  
ATOM   1008  O   GLY A 152      -4.843 105.713  30.249  1.00 19.93           O  
ATOM   1009  N   TYR A 153      -7.086 105.851  30.106  1.00 16.29           N  
ATOM   1010  CA  TYR A 153      -7.196 104.845  29.065  1.00 19.60           C  
ATOM   1011  C   TYR A 153      -6.602 105.435  27.800  1.00 24.42           C  
ATOM   1012  O   TYR A 153      -6.146 104.711  26.912  1.00 22.23           O  
ATOM   1013  CB  TYR A 153      -8.668 104.488  28.844  1.00 21.93           C  
ATOM   1014  CG  TYR A 153      -9.281 103.775  30.027  1.00 21.53           C  
ATOM   1015  CD1 TYR A 153      -8.849 102.501  30.390  1.00 19.06           C  
ATOM   1016  CD2 TYR A 153     -10.261 104.386  30.807  1.00 12.74           C  
ATOM   1017  CE1 TYR A 153      -9.377 101.850  31.495  1.00 17.38           C  
ATOM   1018  CE2 TYR A 153     -10.799 103.741  31.922  1.00 19.76           C  
ATOM   1019  CZ  TYR A 153     -10.347 102.475  32.259  1.00 19.15           C  
ATOM   1020  OH  TYR A 153     -10.861 101.824  33.357  1.00 22.67           O  
ATOM   1021  N   GLY A 154      -6.608 106.763  27.732  1.00 18.67           N  
ATOM   1022  CA  GLY A 154      -6.061 107.439  26.573  1.00 20.46           C  
ATOM   1023  C   GLY A 154      -4.591 107.138  26.347  1.00 19.22           C  
ATOM   1024  O   GLY A 154      -4.141 107.101  25.205  1.00 20.67           O  
ATOM   1025  N   ALA A 155      -3.840 106.922  27.428  1.00 19.06           N  
ATOM   1026  CA  ALA A 155      -2.408 106.647  27.320  1.00 18.33           C  
ATOM   1027  C   ALA A 155      -2.119 105.164  27.474  1.00 14.42           C  
ATOM   1028  O   ALA A 155      -1.818 104.465  26.499  1.00 17.31           O  
ATOM   1029  CB  ALA A 155      -1.642 107.435  28.384  1.00 18.51           C  
ATOM   1030  N   GLY A 156      -2.227 104.693  28.710  1.00 12.57           N  
ATOM   1031  CA  GLY A 156      -1.979 103.297  29.014  1.00 12.14           C  
ATOM   1032  C   GLY A 156      -2.747 102.286  28.186  1.00 14.38           C  
ATOM   1033  O   GLY A 156      -2.162 101.328  27.684  1.00 11.82           O  
ATOM   1034  N   TYR A 157      -4.052 102.473  28.028  1.00 12.55           N  
ATOM   1035  CA  TYR A 157      -4.816 101.504  27.257  1.00 12.04           C  
ATOM   1036  C   TYR A 157      -4.448 101.559  25.784  1.00 12.40           C  
ATOM   1037  O   TYR A 157      -4.407 100.531  25.098  1.00 15.61           O  
ATOM   1038  CB  TYR A 157      -6.314 101.720  27.433  1.00 13.58           C  
ATOM   1039  CG  TYR A 157      -7.139 100.610  26.827  1.00 18.94           C  
ATOM   1040  CD1 TYR A 157      -7.054  99.301  27.317  1.00 16.79           C  
ATOM   1041  CD2 TYR A 157      -8.007 100.862  25.763  1.00 19.05           C  
ATOM   1042  CE1 TYR A 157      -7.823  98.272  26.755  1.00 20.21           C  
ATOM   1043  CE2 TYR A 157      -8.775  99.840  25.197  1.00  9.85           C  
ATOM   1044  CZ  TYR A 157      -8.677  98.551  25.699  1.00 13.93           C  
ATOM   1045  OH  TYR A 157      -9.436  97.551  25.138  1.00 16.53           O  
ATOM   1046  N   LEU A 158      -4.176 102.756  25.289  1.00 12.26           N  
ATOM   1047  CA  LEU A 158      -3.778 102.900  23.899  1.00 10.52           C  
ATOM   1048  C   LEU A 158      -2.481 102.114  23.714  1.00 12.00           C  
ATOM   1049  O   LEU A 158      -2.309 101.410  22.723  1.00 11.71           O  
ATOM   1050  CB  LEU A 158      -3.549 104.375  23.565  1.00  9.10           C  
ATOM   1051  CG  LEU A 158      -2.929 104.666  22.198  1.00 15.77           C  
ATOM   1052  CD1 LEU A 158      -3.874 104.216  21.101  1.00 13.60           C  
ATOM   1053  CD2 LEU A 158      -2.621 106.138  22.076  1.00  8.52           C  
ATOM   1054  N   ALA A 159      -1.577 102.226  24.687  1.00 13.94           N  
ATOM   1055  CA  ALA A 159      -0.296 101.526  24.618  1.00 14.40           C  
ATOM   1056  C   ALA A 159      -0.500 100.016  24.650  1.00 15.37           C  
ATOM   1057  O   ALA A 159       0.348  99.259  24.165  1.00 13.71           O  
ATOM   1058  CB  ALA A 159       0.615 101.958  25.773  1.00  9.91           C  
ATOM   1059  N   ARG A 160      -1.623  99.578  25.221  1.00 10.05           N  
ATOM   1060  CA  ARG A 160      -1.918  98.152  25.280  1.00  9.27           C  
ATOM   1061  C   ARG A 160      -2.583  97.685  23.994  1.00 10.20           C  
ATOM   1062  O   ARG A 160      -3.002  96.532  23.876  1.00 13.68           O  
ATOM   1063  CB  ARG A 160      -2.795  97.832  26.492  1.00 12.07           C  
ATOM   1064  CG  ARG A 160      -2.062  98.083  27.794  1.00 15.53           C  
ATOM   1065  CD  ARG A 160      -2.852  97.648  28.987  1.00 14.57           C  
ATOM   1066  NE  ARG A 160      -2.177  98.019  30.228  1.00 13.95           N  
ATOM   1067  CZ  ARG A 160      -1.915  97.167  31.214  1.00 17.91           C  
ATOM   1068  NH1 ARG A 160      -2.268  95.890  31.098  1.00 15.53           N  
ATOM   1069  NH2 ARG A 160      -1.320  97.591  32.322  1.00 15.92           N  
ATOM   1070  N   ILE A 161      -2.672  98.593  23.026  1.00 12.54           N  
ATOM   1071  CA  ILE A 161      -3.250  98.261  21.732  1.00 11.35           C  
ATOM   1072  C   ILE A 161      -2.175  98.347  20.655  1.00 11.98           C  
ATOM   1073  O   ILE A 161      -1.951  97.396  19.910  1.00 16.89           O  
ATOM   1074  CB  ILE A 161      -4.408  99.220  21.350  1.00 11.12           C  
ATOM   1075  CG1 ILE A 161      -5.605  98.987  22.276  1.00  6.80           C  
ATOM   1076  CG2 ILE A 161      -4.813  98.991  19.883  1.00 10.89           C  
ATOM   1077  CD1 ILE A 161      -6.748  99.956  22.054  1.00 15.04           C  
ATOM   1078  N   VAL A 162      -1.492  99.487  20.599  1.00 13.56           N  
ATOM   1079  CA  VAL A 162      -0.462  99.709  19.594  1.00 14.61           C  
ATOM   1080  C   VAL A 162       0.988  99.596  20.089  1.00 17.71           C  
ATOM   1081  O   VAL A 162       1.919  99.677  19.288  1.00 14.36           O  
ATOM   1082  CB  VAL A 162      -0.654 101.096  18.914  1.00 10.56           C  
ATOM   1083  CG1 VAL A 162      -2.085 101.215  18.356  1.00 11.47           C  
ATOM   1084  CG2 VAL A 162      -0.375 102.220  19.916  1.00 10.02           C  
ATOM   1085  N   GLY A 163       1.186  99.398  21.390  1.00 12.83           N  
ATOM   1086  CA  GLY A 163       2.544  99.294  21.905  1.00 14.77           C  
ATOM   1087  C   GLY A 163       3.031 100.656  22.369  1.00 15.42           C  
ATOM   1088  O   GLY A 163       2.535 101.677  21.901  1.00 15.55           O  
ATOM   1089  N   HIS A 164       4.007 100.684  23.272  1.00 13.44           N  
ATOM   1090  CA  HIS A 164       4.504 101.953  23.807  1.00 18.01           C  
ATOM   1091  C   HIS A 164       5.188 102.943  22.865  1.00 13.68           C  
ATOM   1092  O   HIS A 164       5.007 104.146  23.027  1.00 17.35           O  
ATOM   1093  CB  HIS A 164       5.395 101.695  25.028  1.00 10.55           C  
ATOM   1094  CG  HIS A 164       4.633 101.640  26.317  1.00 12.54           C  
ATOM   1095  ND1 HIS A 164       4.446 102.747  27.119  1.00 12.91           N  
ATOM   1096  CD2 HIS A 164       3.956 100.626  26.911  1.00  9.38           C  
ATOM   1097  CE1 HIS A 164       3.689 102.418  28.150  1.00 13.32           C  
ATOM   1098  NE2 HIS A 164       3.376 101.137  28.049  1.00 13.33           N  
ATOM   1099  N   LYS A 165       5.972 102.471  21.898  1.00 13.48           N  
ATOM   1100  CA  LYS A 165       6.624 103.408  20.973  1.00 14.90           C  
ATOM   1101  C   LYS A 165       5.575 104.212  20.186  1.00 13.63           C  
ATOM   1102  O   LYS A 165       5.641 105.438  20.115  1.00 17.62           O  
ATOM   1103  CB  LYS A 165       7.530 102.665  19.989  1.00 14.01           C  
ATOM   1104  CG  LYS A 165       8.796 102.071  20.597  1.00 17.01           C  
ATOM   1105  CD  LYS A 165       9.791 103.155  20.989  1.00  8.17           C  
ATOM   1106  CE  LYS A 165      11.063 102.551  21.585  1.00 14.87           C  
ATOM   1107  NZ  LYS A 165      12.077 103.598  21.925  1.00 11.61           N  
ATOM   1108  N   LYS A 166       4.600 103.519  19.612  1.00  9.83           N  
ATOM   1109  CA  LYS A 166       3.560 104.182  18.827  1.00 13.16           C  
ATOM   1110  C   LYS A 166       2.608 105.043  19.643  1.00 15.95           C  
ATOM   1111  O   LYS A 166       2.215 106.117  19.195  1.00 19.87           O  
ATOM   1112  CB  LYS A 166       2.751 103.153  18.027  1.00 20.38           C  
ATOM   1113  CG  LYS A 166       3.152 103.052  16.556  1.00 32.26           C  
ATOM   1114  CD  LYS A 166       2.750 104.293  15.776  1.00 24.50           C  
ATOM   1115  CE  LYS A 166       3.285 104.271  14.348  1.00 29.53           C  
ATOM   1116  NZ  LYS A 166       4.766 104.475  14.266  1.00 26.13           N  
ATOM   1117  N   ALA A 167       2.244 104.578  20.835  1.00 13.39           N  
ATOM   1118  CA  ALA A 167       1.331 105.316  21.704  1.00 12.68           C  
ATOM   1119  C   ALA A 167       1.934 106.646  22.159  1.00 18.77           C  
ATOM   1120  O   ALA A 167       1.233 107.655  22.235  1.00 14.23           O  
ATOM   1121  CB  ALA A 167       0.960 104.466  22.923  1.00  6.74           C  
ATOM   1122  N   ARG A 168       3.226 106.644  22.472  1.00 17.03           N  
ATOM   1123  CA  ARG A 168       3.896 107.870  22.899  1.00 20.30           C  
ATOM   1124  C   ARG A 168       4.045 108.807  21.701  1.00 17.21           C  
ATOM   1125  O   ARG A 168       3.947 110.029  21.835  1.00 16.40           O  
ATOM   1126  CB  ARG A 168       5.261 107.539  23.514  1.00 23.77           C  
ATOM   1127  CG  ARG A 168       5.154 106.865  24.887  1.00 19.91           C  
ATOM   1128  CD  ARG A 168       6.464 106.217  25.313  1.00 10.11           C  
ATOM   1129  NE  ARG A 168       6.289 105.396  26.508  1.00 19.42           N  
ATOM   1130  CZ  ARG A 168       6.695 105.738  27.724  1.00 20.34           C  
ATOM   1131  NH1 ARG A 168       7.310 106.894  27.923  1.00 16.78           N  
ATOM   1132  NH2 ARG A 168       6.479 104.926  28.746  1.00 19.29           N  
ATOM   1133  N   GLU A 169       4.267 108.224  20.527  1.00 15.21           N  
ATOM   1134  CA  GLU A 169       4.396 109.000  19.300  1.00 19.07           C  
ATOM   1135  C   GLU A 169       3.100 109.771  19.064  1.00 21.22           C  
ATOM   1136  O   GLU A 169       3.098 110.985  18.835  1.00 16.11           O  
ATOM   1137  CB  GLU A 169       4.631 108.072  18.103  1.00 13.67           C  
ATOM   1138  CG  GLU A 169       4.636 108.790  16.770  1.00 18.79           C  
ATOM   1139  CD  GLU A 169       4.613 107.845  15.590  1.00 14.64           C  
ATOM   1140  OE1 GLU A 169       5.359 106.848  15.619  1.00 14.50           O  
ATOM   1141  OE2 GLU A 169       3.857 108.106  14.631  1.00 20.82           O  
ATOM   1142  N   ILE A 170       2.002 109.032  19.123  1.00 22.93           N  
ATOM   1143  CA  ILE A 170       0.670 109.566  18.907  1.00 21.90           C  
ATOM   1144  C   ILE A 170       0.344 110.754  19.798  1.00 18.09           C  
ATOM   1145  O   ILE A 170      -0.225 111.738  19.327  1.00 22.28           O  
ATOM   1146  CB  ILE A 170      -0.373 108.451  19.104  1.00 18.49           C  
ATOM   1147  CG1 ILE A 170      -0.266 107.469  17.942  1.00 10.61           C  
ATOM   1148  CG2 ILE A 170      -1.778 109.039  19.248  1.00 18.50           C  
ATOM   1149  CD1 ILE A 170      -1.109 106.225  18.114  1.00 22.03           C  
ATOM   1150  N   TRP A 171       0.716 110.667  21.073  1.00 16.22           N  
ATOM   1151  CA  TRP A 171       0.451 111.750  22.022  1.00 21.03           C  
ATOM   1152  C   TRP A 171       1.434 112.918  21.988  1.00 23.65           C  
ATOM   1153  O   TRP A 171       1.025 114.073  22.124  1.00 20.61           O  
ATOM   1154  CB  TRP A 171       0.388 111.214  23.457  1.00 18.28           C  
ATOM   1155  CG  TRP A 171      -0.948 110.653  23.833  1.00 20.10           C  
ATOM   1156  CD1 TRP A 171      -1.293 109.335  23.913  1.00 11.85           C  
ATOM   1157  CD2 TRP A 171      -2.128 111.398  24.146  1.00 16.50           C  
ATOM   1158  NE1 TRP A 171      -2.616 109.214  24.257  1.00 16.90           N  
ATOM   1159  CE2 TRP A 171      -3.152 110.463  24.405  1.00 20.54           C  
ATOM   1160  CE3 TRP A 171      -2.420 112.765  24.228  1.00 20.27           C  
ATOM   1161  CZ2 TRP A 171      -4.451 110.854  24.743  1.00 18.75           C  
ATOM   1162  CZ3 TRP A 171      -3.708 113.151  24.562  1.00 18.81           C  
ATOM   1163  CH2 TRP A 171      -4.709 112.199  24.816  1.00 20.32           C  
ATOM   1164  N   TYR A 172       2.724 112.634  21.827  1.00 22.64           N  
ATOM   1165  CA  TYR A 172       3.720 113.705  21.812  1.00 23.99           C  
ATOM   1166  C   TYR A 172       3.710 114.591  20.562  1.00 26.89           C  
ATOM   1167  O   TYR A 172       3.881 115.805  20.671  1.00 29.11           O  
ATOM   1168  CB  TYR A 172       5.136 113.148  22.002  1.00 23.81           C  
ATOM   1169  CG  TYR A 172       5.383 112.396  23.296  1.00 20.19           C  
ATOM   1170  CD1 TYR A 172       4.450 112.393  24.332  1.00 18.33           C  
ATOM   1171  CD2 TYR A 172       6.559 111.671  23.471  1.00 17.16           C  
ATOM   1172  CE1 TYR A 172       4.690 111.674  25.512  1.00 19.47           C  
ATOM   1173  CE2 TYR A 172       6.805 110.960  24.629  1.00 13.77           C  
ATOM   1174  CZ  TYR A 172       5.873 110.960  25.647  1.00 12.66           C  
ATOM   1175  OH  TYR A 172       6.145 110.239  26.780  1.00 18.78           O  
ATOM   1176  N   LEU A 173       3.522 114.004  19.381  1.00 20.52           N  
ATOM   1177  CA  LEU A 173       3.520 114.806  18.156  1.00 25.54           C  
ATOM   1178  C   LEU A 173       2.149 115.269  17.701  1.00 26.77           C  
ATOM   1179  O   LEU A 173       2.040 116.248  16.965  1.00 24.02           O  
ATOM   1180  CB  LEU A 173       4.203 114.057  17.004  1.00 16.86           C  
ATOM   1181  CG  LEU A 173       5.725 113.929  17.117  1.00 23.85           C  
ATOM   1182  CD1 LEU A 173       6.073 112.856  18.127  1.00 23.86           C  
ATOM   1183  CD2 LEU A 173       6.318 113.588  15.770  1.00 29.38           C  
ATOM   1184  N   CYS A 174       1.107 114.571  18.136  1.00 23.15           N  
ATOM   1185  CA  CYS A 174      -0.258 114.922  17.762  1.00 21.58           C  
ATOM   1186  C   CYS A 174      -0.474 114.989  16.252  1.00 21.35           C  
ATOM   1187  O   CYS A 174      -1.168 115.875  15.759  1.00 23.35           O  
ATOM   1188  CB  CYS A 174      -0.653 116.264  18.388  1.00 27.84           C  
ATOM   1189  SG  CYS A 174      -0.820 116.250  20.187  1.00 26.73           S  
ATOM   1190  N   ARG A 175       0.117 114.056  15.515  1.00 24.56           N  
ATOM   1191  CA  ARG A 175      -0.057 114.025  14.066  1.00 27.00           C  
ATOM   1192  C   ARG A 175      -1.362 113.305  13.745  1.00 21.43           C  
ATOM   1193  O   ARG A 175      -2.061 112.837  14.644  1.00 20.76           O  
ATOM   1194  CB  ARG A 175       1.130 113.311  13.403  1.00 25.50           C  
ATOM   1195  CG  ARG A 175       2.396 114.159  13.351  1.00 29.06           C  
ATOM   1196  CD  ARG A 175       3.633 113.375  13.753  1.00 38.21           C  
ATOM   1197  NE  ARG A 175       4.169 112.537  12.686  1.00 44.09           N  
ATOM   1198  CZ  ARG A 175       5.192 112.877  11.906  1.00 37.15           C  
ATOM   1199  NH1 ARG A 175       5.797 114.044  12.066  1.00 34.40           N  
ATOM   1200  NH2 ARG A 175       5.620 112.039  10.975  1.00 33.55           N  
ATOM   1201  N   GLN A 176      -1.712 113.236  12.469  1.00 26.53           N  
ATOM   1202  CA  GLN A 176      -2.935 112.552  12.081  1.00 25.31           C  
ATOM   1203  C   GLN A 176      -2.547 111.243  11.416  1.00 24.14           C  
ATOM   1204  O   GLN A 176      -1.490 111.148  10.801  1.00 23.68           O  
ATOM   1205  CB  GLN A 176      -3.763 113.427  11.131  1.00 27.01           C  
ATOM   1206  CG  GLN A 176      -4.101 114.793  11.719  1.00 31.19           C  
ATOM   1207  CD  GLN A 176      -5.128 115.569  10.907  1.00 29.65           C  
ATOM   1208  OE1 GLN A 176      -5.168 115.483   9.681  1.00 33.08           O  
ATOM   1209  NE2 GLN A 176      -5.947 116.347  11.593  1.00 26.07           N  
ATOM   1210  N   TYR A 177      -3.399 110.234  11.558  1.00 25.75           N  
ATOM   1211  CA  TYR A 177      -3.145 108.922  10.979  1.00 24.30           C  
ATOM   1212  C   TYR A 177      -4.342 108.481  10.154  1.00 22.08           C  
ATOM   1213  O   TYR A 177      -5.481 108.641  10.581  1.00 23.57           O  
ATOM   1214  CB  TYR A 177      -2.874 107.911  12.099  1.00 18.62           C  
ATOM   1215  CG  TYR A 177      -1.648 108.261  12.898  1.00 23.59           C  
ATOM   1216  CD1 TYR A 177      -0.391 107.778  12.529  1.00 12.32           C  
ATOM   1217  CD2 TYR A 177      -1.727 109.139  13.979  1.00 21.36           C  
ATOM   1218  CE1 TYR A 177       0.748 108.162  13.211  1.00 16.70           C  
ATOM   1219  CE2 TYR A 177      -0.587 109.525  14.670  1.00 24.12           C  
ATOM   1220  CZ  TYR A 177       0.647 109.035  14.275  1.00 16.91           C  
ATOM   1221  OH  TYR A 177       1.782 109.429  14.935  1.00 24.86           O  
ATOM   1222  N   THR A 178      -4.084 107.938   8.966  1.00 25.32           N  
ATOM   1223  CA  THR A 178      -5.164 107.482   8.100  1.00 29.57           C  
ATOM   1224  C   THR A 178      -5.583 106.079   8.506  1.00 30.76           C  
ATOM   1225  O   THR A 178      -4.902 105.421   9.294  1.00 34.51           O  
ATOM   1226  CB  THR A 178      -4.749 107.496   6.609  1.00 24.15           C  
ATOM   1227  OG1 THR A 178      -3.595 106.675   6.416  1.00 28.82           O  
ATOM   1228  CG2 THR A 178      -4.431 108.908   6.171  1.00 22.24           C  
ATOM   1229  N   ALA A 179      -6.707 105.622   7.971  1.00 26.36           N  
ATOM   1230  CA  ALA A 179      -7.221 104.304   8.306  1.00 22.36           C  
ATOM   1231  C   ALA A 179      -6.184 103.193   8.143  1.00 24.59           C  
ATOM   1232  O   ALA A 179      -6.035 102.350   9.025  1.00 29.20           O  
ATOM   1233  CB  ALA A 179      -8.457 104.003   7.460  1.00 30.79           C  
ATOM   1234  N   GLN A 180      -5.479 103.190   7.014  1.00 21.89           N  
ATOM   1235  CA  GLN A 180      -4.460 102.178   6.737  1.00 23.94           C  
ATOM   1236  C   GLN A 180      -3.356 102.206   7.788  1.00 21.32           C  
ATOM   1237  O   GLN A 180      -2.849 101.162   8.191  1.00 24.70           O  
ATOM   1238  CB  GLN A 180      -3.855 102.399   5.343  1.00 15.56           C  
ATOM   1239  CG  GLN A 180      -2.793 101.372   4.937  1.00 30.02           C  
ATOM   1240  CD  GLN A 180      -3.253  99.928   5.108  1.00 29.59           C  
ATOM   1241  OE1 GLN A 180      -4.335  99.550   4.667  1.00 35.75           O  
ATOM   1242  NE2 GLN A 180      -2.418  99.114   5.744  1.00 30.55           N  
ATOM   1243  N   GLU A 181      -2.975 103.404   8.220  1.00 19.03           N  
ATOM   1244  CA  GLU A 181      -1.951 103.532   9.243  1.00 19.29           C  
ATOM   1245  C   GLU A 181      -2.494 102.959  10.542  1.00 15.43           C  
ATOM   1246  O   GLU A 181      -1.807 102.234  11.247  1.00 16.49           O  
ATOM   1247  CB  GLU A 181      -1.584 104.993   9.457  1.00 14.17           C  
ATOM   1248  CG  GLU A 181      -0.642 105.564   8.437  1.00 21.54           C  
ATOM   1249  CD  GLU A 181      -0.386 107.036   8.683  1.00 25.20           C  
ATOM   1250  OE1 GLU A 181      -1.288 107.855   8.405  1.00 19.85           O  
ATOM   1251  OE2 GLU A 181       0.714 107.370   9.171  1.00 28.33           O  
ATOM   1252  N   ALA A 182      -3.738 103.302  10.855  1.00 21.13           N  
ATOM   1253  CA  ALA A 182      -4.384 102.818  12.065  1.00 20.58           C  
ATOM   1254  C   ALA A 182      -4.453 101.298  12.060  1.00 18.28           C  
ATOM   1255  O   ALA A 182      -4.153 100.652  13.059  1.00 18.75           O  
ATOM   1256  CB  ALA A 182      -5.781 103.395  12.165  1.00 11.05           C  
ATOM   1257  N   LEU A 183      -4.857 100.738  10.923  1.00 20.17           N  
ATOM   1258  CA  LEU A 183      -4.989  99.296  10.759  1.00 16.28           C  
ATOM   1259  C   LEU A 183      -3.649  98.600  10.991  1.00 21.73           C  
ATOM   1260  O   LEU A 183      -3.562  97.651  11.769  1.00 19.40           O  
ATOM   1261  CB  LEU A 183      -5.505  98.978   9.347  1.00 16.63           C  
ATOM   1262  CG  LEU A 183      -5.781  97.523   8.949  1.00 21.34           C  
ATOM   1263  CD1 LEU A 183      -7.003  96.993   9.681  1.00 19.81           C  
ATOM   1264  CD2 LEU A 183      -6.010  97.453   7.443  1.00 21.22           C  
ATOM   1265  N   GLU A 184      -2.608  99.081  10.316  1.00 19.99           N  
ATOM   1266  CA  GLU A 184      -1.278  98.498  10.444  1.00 26.30           C  
ATOM   1267  C   GLU A 184      -0.758  98.452  11.873  1.00 22.49           C  
ATOM   1268  O   GLU A 184      -0.127  97.470  12.270  1.00 22.45           O  
ATOM   1269  CB  GLU A 184      -0.274  99.251   9.562  1.00 25.18           C  
ATOM   1270  CG  GLU A 184      -0.449  98.971   8.085  1.00 37.50           C  
ATOM   1271  CD  GLU A 184       0.654  99.570   7.234  1.00 42.45           C  
ATOM   1272  OE1 GLU A 184       0.603  99.400   5.998  1.00 41.58           O  
ATOM   1273  OE2 GLU A 184       1.568 100.210   7.799  1.00 48.28           O  
ATOM   1274  N   MET A 185      -1.016  99.501  12.649  1.00 16.70           N  
ATOM   1275  CA  MET A 185      -0.543  99.530  14.034  1.00 19.44           C  
ATOM   1276  C   MET A 185      -1.489  98.828  15.017  1.00 20.14           C  
ATOM   1277  O   MET A 185      -1.278  98.868  16.230  1.00 19.96           O  
ATOM   1278  CB  MET A 185      -0.284 100.976  14.485  1.00 23.40           C  
ATOM   1279  CG  MET A 185      -1.520 101.827  14.738  1.00 24.12           C  
ATOM   1280  SD  MET A 185      -1.088 103.558  15.113  1.00 30.36           S  
ATOM   1281  CE  MET A 185      -0.370 103.423  16.698  1.00 40.87           C  
ATOM   1282  N   GLY A 186      -2.522  98.177  14.483  1.00 18.05           N  
ATOM   1283  CA  GLY A 186      -3.472  97.459  15.320  1.00 16.18           C  
ATOM   1284  C   GLY A 186      -4.476  98.307  16.084  1.00 17.37           C  
ATOM   1285  O   GLY A 186      -5.119  97.819  17.014  1.00 20.41           O  
ATOM   1286  N   LEU A 187      -4.615  99.568  15.685  1.00 18.91           N  
ATOM   1287  CA  LEU A 187      -5.528 100.506  16.332  1.00 12.64           C  
ATOM   1288  C   LEU A 187      -6.994 100.275  15.941  1.00 16.54           C  
ATOM   1289  O   LEU A 187      -7.901 100.527  16.732  1.00 17.47           O  
ATOM   1290  CB  LEU A 187      -5.099 101.936  15.983  1.00 14.53           C  
ATOM   1291  CG  LEU A 187      -5.780 103.132  16.654  1.00 19.11           C  
ATOM   1292  CD1 LEU A 187      -5.789 102.965  18.173  1.00 12.10           C  
ATOM   1293  CD2 LEU A 187      -5.036 104.405  16.253  1.00 19.48           C  
ATOM   1294  N   VAL A 188      -7.224  99.811  14.716  1.00 20.96           N  
ATOM   1295  CA  VAL A 188      -8.577  99.526  14.253  1.00 18.31           C  
ATOM   1296  C   VAL A 188      -8.595  98.094  13.735  1.00 19.98           C  
ATOM   1297  O   VAL A 188      -7.560  97.563  13.325  1.00 20.15           O  
ATOM   1298  CB  VAL A 188      -9.035 100.514  13.143  1.00 23.87           C  
ATOM   1299  CG1 VAL A 188      -8.923 101.945  13.656  1.00 21.28           C  
ATOM   1300  CG2 VAL A 188      -8.202 100.333  11.878  1.00 23.81           C  
ATOM   1301  N   ASN A 189      -9.769  97.476  13.763  1.00 16.61           N  
ATOM   1302  CA  ASN A 189      -9.933  96.091  13.347  1.00 21.16           C  
ATOM   1303  C   ASN A 189     -10.137  95.852  11.861  1.00 22.75           C  
ATOM   1304  O   ASN A 189      -9.827  94.775  11.356  1.00 19.65           O  
ATOM   1305  CB  ASN A 189     -11.099  95.475  14.119  1.00 23.72           C  
ATOM   1306  CG  ASN A 189     -10.850  95.454  15.608  1.00 21.99           C  
ATOM   1307  OD1 ASN A 189     -10.359  94.464  16.150  1.00 26.88           O  
ATOM   1308  ND2 ASN A 189     -11.157  96.559  16.276  1.00 14.57           N  
ATOM   1309  N   LYS A 190     -10.662  96.849  11.159  1.00 25.91           N  
ATOM   1310  CA  LYS A 190     -10.910  96.695   9.738  1.00 25.56           C  
ATOM   1311  C   LYS A 190     -11.163  98.035   9.069  1.00 22.79           C  
ATOM   1312  O   LYS A 190     -11.630  98.983   9.702  1.00 24.71           O  
ATOM   1313  CB  LYS A 190     -12.117  95.772   9.518  1.00 29.23           C  
ATOM   1314  CG  LYS A 190     -12.301  95.308   8.076  1.00 35.34           C  
ATOM   1315  CD  LYS A 190     -13.592  94.516   7.911  1.00 40.74           C  
ATOM   1316  CE  LYS A 190     -13.804  94.059   6.468  1.00 41.41           C  
ATOM   1317  NZ  LYS A 190     -12.766  93.087   6.016  1.00 33.53           N  
ATOM   1318  N   VAL A 191     -10.841  98.102   7.783  1.00 17.93           N  
ATOM   1319  CA  VAL A 191     -11.038  99.309   6.996  1.00 19.18           C  
ATOM   1320  C   VAL A 191     -11.833  98.954   5.741  1.00 25.05           C  
ATOM   1321  O   VAL A 191     -11.564  97.938   5.096  1.00 20.01           O  
ATOM   1322  CB  VAL A 191      -9.691  99.919   6.570  1.00 22.83           C  
ATOM   1323  CG1 VAL A 191      -9.926 101.153   5.702  1.00 25.96           C  
ATOM   1324  CG2 VAL A 191      -8.872 100.276   7.807  1.00 18.56           C  
ATOM   1325  N   VAL A 192     -12.821  99.784   5.410  1.00 27.47           N  
ATOM   1326  CA  VAL A 192     -13.654  99.568   4.226  1.00 30.44           C  
ATOM   1327  C   VAL A 192     -14.033 100.897   3.574  1.00 26.63           C  
ATOM   1328  O   VAL A 192     -13.880 101.962   4.179  1.00 24.44           O  
ATOM   1329  CB  VAL A 192     -14.965  98.816   4.575  1.00 30.19           C  
ATOM   1330  CG1 VAL A 192     -14.657  97.407   5.046  1.00 28.86           C  
ATOM   1331  CG2 VAL A 192     -15.736  99.579   5.640  1.00 29.60           C  
ATOM   1332  N   PRO A 193     -14.513 100.853   2.318  1.00 23.38           N  
ATOM   1333  CA  PRO A 193     -14.899 102.104   1.656  1.00 27.27           C  
ATOM   1334  C   PRO A 193     -16.015 102.752   2.467  1.00 32.38           C  
ATOM   1335  O   PRO A 193     -16.826 102.049   3.075  1.00 27.35           O  
ATOM   1336  CB  PRO A 193     -15.379 101.635   0.286  1.00 23.24           C  
ATOM   1337  CG  PRO A 193     -14.526 100.443   0.025  1.00 14.38           C  
ATOM   1338  CD  PRO A 193     -14.553  99.728   1.369  1.00 26.91           C  
ATOM   1339  N   LEU A 194     -16.053 104.081   2.474  1.00 33.79           N  
ATOM   1340  CA  LEU A 194     -17.060 104.828   3.223  1.00 36.74           C  
ATOM   1341  C   LEU A 194     -18.501 104.381   3.000  1.00 38.29           C  
ATOM   1342  O   LEU A 194     -19.307 104.392   3.927  1.00 38.56           O  
ATOM   1343  CB  LEU A 194     -16.953 106.318   2.892  1.00 40.94           C  
ATOM   1344  CG  LEU A 194     -17.966 107.240   3.573  1.00 44.68           C  
ATOM   1345  CD1 LEU A 194     -17.761 107.214   5.082  1.00 47.08           C  
ATOM   1346  CD2 LEU A 194     -17.799 108.651   3.039  1.00 49.47           C  
ATOM   1347  N   GLU A 195     -18.821 103.983   1.772  1.00 41.26           N  
ATOM   1348  CA  GLU A 195     -20.180 103.574   1.433  1.00 48.76           C  
ATOM   1349  C   GLU A 195     -20.599 102.219   1.987  1.00 43.73           C  
ATOM   1350  O   GLU A 195     -21.787 101.897   2.005  1.00 38.88           O  
ATOM   1351  CB  GLU A 195     -20.363 103.580  -0.093  1.00 56.10           C  
ATOM   1352  CG  GLU A 195     -19.873 102.327  -0.805  1.00 75.39           C  
ATOM   1353  CD  GLU A 195     -20.929 101.233  -0.862  1.00 85.85           C  
ATOM   1354  OE1 GLU A 195     -20.601 100.105  -1.288  1.00 92.27           O  
ATOM   1355  OE2 GLU A 195     -22.092 101.502  -0.492  1.00 90.94           O  
ATOM   1356  N   GLN A 196     -19.634 101.432   2.449  1.00 40.98           N  
ATOM   1357  CA  GLN A 196     -19.931 100.103   2.977  1.00 41.38           C  
ATOM   1358  C   GLN A 196     -19.709 100.015   4.484  1.00 39.20           C  
ATOM   1359  O   GLN A 196     -19.889  98.955   5.087  1.00 32.80           O  
ATOM   1360  CB  GLN A 196     -19.062  99.073   2.258  1.00 45.27           C  
ATOM   1361  CG  GLN A 196     -18.931  99.377   0.777  1.00 60.95           C  
ATOM   1362  CD  GLN A 196     -18.418  98.212  -0.036  1.00 65.86           C  
ATOM   1363  OE1 GLN A 196     -17.233  97.884  -0.002  1.00 72.02           O  
ATOM   1364  NE2 GLN A 196     -19.318  97.574  -0.772  1.00 73.79           N  
ATOM   1365  N   LEU A 197     -19.336 101.141   5.084  1.00 36.71           N  
ATOM   1366  CA  LEU A 197     -19.070 101.200   6.517  1.00 38.11           C  
ATOM   1367  C   LEU A 197     -20.144 100.546   7.379  1.00 36.08           C  
ATOM   1368  O   LEU A 197     -19.887  99.542   8.043  1.00 35.60           O  
ATOM   1369  CB  LEU A 197     -18.883 102.653   6.967  1.00 30.68           C  
ATOM   1370  CG  LEU A 197     -18.512 102.806   8.452  1.00 30.11           C  
ATOM   1371  CD1 LEU A 197     -17.184 102.099   8.718  1.00 37.46           C  
ATOM   1372  CD2 LEU A 197     -18.411 104.271   8.823  1.00 22.71           C  
ATOM   1373  N   GLU A 198     -21.349 101.105   7.369  1.00 37.23           N  
ATOM   1374  CA  GLU A 198     -22.420 100.557   8.192  1.00 35.86           C  
ATOM   1375  C   GLU A 198     -22.781  99.132   7.810  1.00 30.48           C  
ATOM   1376  O   GLU A 198     -23.218  98.347   8.646  1.00 32.69           O  
ATOM   1377  CB  GLU A 198     -23.665 101.441   8.127  1.00 41.90           C  
ATOM   1378  CG  GLU A 198     -24.638 101.181   9.271  1.00 44.43           C  
ATOM   1379  CD  GLU A 198     -25.831 102.106   9.251  1.00 44.19           C  
ATOM   1380  OE1 GLU A 198     -26.648 101.997   8.316  1.00 58.51           O  
ATOM   1381  OE2 GLU A 198     -25.951 102.945  10.168  1.00 53.85           O  
ATOM   1382  N   GLU A 199     -22.592  98.800   6.541  1.00 33.38           N  
ATOM   1383  CA  GLU A 199     -22.887  97.463   6.040  1.00 32.38           C  
ATOM   1384  C   GLU A 199     -21.981  96.426   6.715  1.00 35.42           C  
ATOM   1385  O   GLU A 199     -22.441  95.377   7.194  1.00 24.45           O  
ATOM   1386  CB  GLU A 199     -22.682  97.453   4.521  1.00 42.48           C  
ATOM   1387  CG  GLU A 199     -22.739  96.092   3.848  1.00 50.95           C  
ATOM   1388  CD  GLU A 199     -22.595  96.200   2.336  1.00 54.81           C  
ATOM   1389  OE1 GLU A 199     -23.562  96.628   1.671  1.00 51.87           O  
ATOM   1390  OE2 GLU A 199     -21.509  95.869   1.812  1.00 57.33           O  
ATOM   1391  N   GLU A 200     -20.686  96.727   6.750  1.00 27.02           N  
ATOM   1392  CA  GLU A 200     -19.712  95.833   7.362  1.00 32.31           C  
ATOM   1393  C   GLU A 200     -19.911  95.794   8.874  1.00 24.37           C  
ATOM   1394  O   GLU A 200     -19.930  94.722   9.478  1.00 25.01           O  
ATOM   1395  CB  GLU A 200     -18.297  96.312   7.040  1.00 37.45           C  
ATOM   1396  CG  GLU A 200     -17.178  95.396   7.515  1.00 42.39           C  
ATOM   1397  CD  GLU A 200     -17.091  94.109   6.720  1.00 43.21           C  
ATOM   1398  OE1 GLU A 200     -17.503  94.105   5.542  1.00 48.13           O  
ATOM   1399  OE2 GLU A 200     -16.590  93.105   7.267  1.00 44.55           O  
ATOM   1400  N   THR A 201     -20.064  96.969   9.477  1.00 27.13           N  
ATOM   1401  CA  THR A 201     -20.250  97.072  10.922  1.00 30.41           C  
ATOM   1402  C   THR A 201     -21.444  96.258  11.416  1.00 37.22           C  
ATOM   1403  O   THR A 201     -21.354  95.571  12.438  1.00 37.60           O  
ATOM   1404  CB  THR A 201     -20.417  98.539  11.347  1.00 25.71           C  
ATOM   1405  OG1 THR A 201     -19.280  99.286  10.910  1.00 27.77           O  
ATOM   1406  CG2 THR A 201     -20.528  98.657  12.872  1.00 29.03           C  
ATOM   1407  N   VAL A 202     -22.558  96.331  10.692  1.00 37.81           N  
ATOM   1408  CA  VAL A 202     -23.750  95.577  11.066  1.00 37.71           C  
ATOM   1409  C   VAL A 202     -23.458  94.098  10.885  1.00 38.76           C  
ATOM   1410  O   VAL A 202     -23.939  93.256  11.646  1.00 42.44           O  
ATOM   1411  CB  VAL A 202     -24.968  95.956  10.192  1.00 38.02           C  
ATOM   1412  CG1 VAL A 202     -26.105  94.963  10.425  1.00 37.30           C  
ATOM   1413  CG2 VAL A 202     -25.431  97.359  10.531  1.00 33.61           C  
ATOM   1414  N   LYS A 203     -22.662  93.789   9.869  1.00 37.56           N  
ATOM   1415  CA  LYS A 203     -22.286  92.410   9.595  1.00 41.72           C  
ATOM   1416  C   LYS A 203     -21.545  91.857  10.810  1.00 40.87           C  
ATOM   1417  O   LYS A 203     -21.830  90.754  11.271  1.00 38.72           O  
ATOM   1418  CB  LYS A 203     -21.390  92.355   8.357  1.00 44.54           C  
ATOM   1419  CG  LYS A 203     -20.914  90.966   7.989  1.00 47.15           C  
ATOM   1420  CD  LYS A 203     -20.001  91.023   6.779  1.00 53.65           C  
ATOM   1421  CE  LYS A 203     -19.370  89.673   6.491  1.00 58.94           C  
ATOM   1422  NZ  LYS A 203     -18.434  89.741   5.332  1.00 62.74           N  
ATOM   1423  N   TRP A 204     -20.593  92.634  11.323  1.00 38.75           N  
ATOM   1424  CA  TRP A 204     -19.816  92.238  12.496  1.00 30.06           C  
ATOM   1425  C   TRP A 204     -20.722  92.137  13.719  1.00 20.21           C  
ATOM   1426  O   TRP A 204     -20.598  91.210  14.514  1.00 24.64           O  
ATOM   1427  CB  TRP A 204     -18.699  93.255  12.759  1.00 28.90           C  
ATOM   1428  CG  TRP A 204     -17.492  93.074  11.889  1.00 36.09           C  
ATOM   1429  CD1 TRP A 204     -17.471  92.937  10.530  1.00 36.05           C  
ATOM   1430  CD2 TRP A 204     -16.125  93.030  12.318  1.00 37.22           C  
ATOM   1431  NE1 TRP A 204     -16.176  92.811  10.086  1.00 37.64           N  
ATOM   1432  CE2 TRP A 204     -15.330  92.865  11.161  1.00 37.95           C  
ATOM   1433  CE3 TRP A 204     -15.495  93.113  13.568  1.00 26.87           C  
ATOM   1434  CZ2 TRP A 204     -13.933  92.782  11.216  1.00 33.82           C  
ATOM   1435  CZ3 TRP A 204     -14.106  93.030  13.622  1.00 33.11           C  
ATOM   1436  CH2 TRP A 204     -13.342  92.869  12.452  1.00 37.12           C  
ATOM   1437  N   ALA A 205     -21.630  93.095  13.869  1.00 30.73           N  
ATOM   1438  CA  ALA A 205     -22.558  93.096  14.996  1.00 31.00           C  
ATOM   1439  C   ALA A 205     -23.400  91.821  15.019  1.00 35.21           C  
ATOM   1440  O   ALA A 205     -23.587  91.214  16.075  1.00 33.22           O  
ATOM   1441  CB  ALA A 205     -23.464  94.316  14.927  1.00 32.05           C  
ATOM   1442  N   GLN A 206     -23.896  91.413  13.851  1.00 35.11           N  
ATOM   1443  CA  GLN A 206     -24.725  90.213  13.754  1.00 39.51           C  
ATOM   1444  C   GLN A 206     -23.946  88.956  14.095  1.00 39.12           C  
ATOM   1445  O   GLN A 206     -24.480  88.047  14.727  1.00 39.83           O  
ATOM   1446  CB  GLN A 206     -25.339  90.095  12.356  1.00 46.04           C  
ATOM   1447  CG  GLN A 206     -26.229  91.278  11.994  1.00 63.09           C  
ATOM   1448  CD  GLN A 206     -26.829  91.174  10.605  1.00 70.20           C  
ATOM   1449  OE1 GLN A 206     -26.138  90.853   9.638  1.00 74.53           O  
ATOM   1450  NE2 GLN A 206     -28.121  91.462  10.496  1.00 72.67           N  
ATOM   1451  N   GLU A 207     -22.685  88.896  13.677  1.00 39.64           N  
ATOM   1452  CA  GLU A 207     -21.859  87.736  13.988  1.00 41.37           C  
ATOM   1453  C   GLU A 207     -21.746  87.615  15.512  1.00 38.29           C  
ATOM   1454  O   GLU A 207     -21.735  86.516  16.064  1.00 36.02           O  
ATOM   1455  CB  GLU A 207     -20.469  87.879  13.358  1.00 39.02           C  
ATOM   1456  CG  GLU A 207     -20.430  87.556  11.864  1.00 43.54           C  
ATOM   1457  CD  GLU A 207     -19.028  87.609  11.270  1.00 43.29           C  
ATOM   1458  OE1 GLU A 207     -18.094  87.036  11.875  1.00 43.89           O  
ATOM   1459  OE2 GLU A 207     -18.861  88.213  10.188  1.00 48.26           O  
ATOM   1460  N   ILE A 208     -21.674  88.757  16.188  1.00 37.92           N  
ATOM   1461  CA  ILE A 208     -21.576  88.760  17.640  1.00 38.25           C  
ATOM   1462  C   ILE A 208     -22.906  88.310  18.247  1.00 40.38           C  
ATOM   1463  O   ILE A 208     -22.928  87.572  19.237  1.00 37.50           O  
ATOM   1464  CB  ILE A 208     -21.196  90.169  18.173  1.00 32.53           C  
ATOM   1465  CG1 ILE A 208     -19.764  90.509  17.751  1.00 33.54           C  
ATOM   1466  CG2 ILE A 208     -21.315  90.215  19.687  1.00 36.80           C  
ATOM   1467  CD1 ILE A 208     -19.280  91.858  18.242  1.00 28.11           C  
ATOM   1468  N   LEU A 209     -24.011  88.738  17.641  1.00 37.33           N  
ATOM   1469  CA  LEU A 209     -25.339  88.372  18.127  1.00 39.24           C  
ATOM   1470  C   LEU A 209     -25.609  86.875  18.039  1.00 38.75           C  
ATOM   1471  O   LEU A 209     -26.619  86.399  18.549  1.00 49.29           O  
ATOM   1472  CB  LEU A 209     -26.422  89.114  17.344  1.00 36.96           C  
ATOM   1473  CG  LEU A 209     -26.492  90.634  17.486  1.00 38.88           C  
ATOM   1474  CD1 LEU A 209     -27.600  91.163  16.595  1.00 39.03           C  
ATOM   1475  CD2 LEU A 209     -26.744  91.022  18.944  1.00 41.45           C  
ATOM   1476  N   GLU A 210     -24.710  86.133  17.403  1.00 39.66           N  
ATOM   1477  CA  GLU A 210     -24.879  84.686  17.254  1.00 42.35           C  
ATOM   1478  C   GLU A 210     -24.095  83.863  18.273  1.00 39.17           C  
ATOM   1479  O   GLU A 210     -24.172  82.634  18.276  1.00 43.81           O  
ATOM   1480  CB  GLU A 210     -24.457  84.249  15.845  1.00 40.44           C  
ATOM   1481  CG  GLU A 210     -25.195  84.945  14.716  1.00 54.70           C  
ATOM   1482  CD  GLU A 210     -26.681  84.632  14.699  1.00 64.27           C  
ATOM   1483  OE1 GLU A 210     -27.041  83.446  14.533  1.00 62.67           O  
ATOM   1484  OE2 GLU A 210     -27.488  85.574  14.854  1.00 67.85           O  
ATOM   1485  N   LYS A 211     -23.335  84.532  19.133  1.00 38.26           N  
ATOM   1486  CA  LYS A 211     -22.527  83.830  20.126  1.00 33.74           C  
ATOM   1487  C   LYS A 211     -23.199  83.787  21.488  1.00 35.17           C  
ATOM   1488  O   LYS A 211     -24.192  84.474  21.729  1.00 28.47           O  
ATOM   1489  CB  LYS A 211     -21.169  84.517  20.290  1.00 34.15           C  
ATOM   1490  CG  LYS A 211     -20.465  84.873  19.000  1.00 31.71           C  
ATOM   1491  CD  LYS A 211     -20.033  83.647  18.226  1.00 35.69           C  
ATOM   1492  CE  LYS A 211     -19.286  84.063  16.970  1.00 49.37           C  
ATOM   1493  NZ  LYS A 211     -18.920  82.910  16.114  1.00 52.92           N  
ATOM   1494  N   SER A 212     -22.642  82.967  22.374  1.00 33.59           N  
ATOM   1495  CA  SER A 212     -23.136  82.848  23.737  1.00 35.94           C  
ATOM   1496  C   SER A 212     -22.903  84.206  24.384  1.00 35.59           C  
ATOM   1497  O   SER A 212     -21.761  84.635  24.540  1.00 40.27           O  
ATOM   1498  CB  SER A 212     -22.351  81.774  24.490  1.00 32.46           C  
ATOM   1499  OG  SER A 212     -22.449  81.961  25.888  1.00 30.82           O  
ATOM   1500  N   PRO A 213     -23.985  84.908  24.751  1.00 35.66           N  
ATOM   1501  CA  PRO A 213     -23.916  86.233  25.382  1.00 37.17           C  
ATOM   1502  C   PRO A 213     -23.165  86.229  26.710  1.00 35.85           C  
ATOM   1503  O   PRO A 213     -22.502  87.202  27.072  1.00 29.37           O  
ATOM   1504  CB  PRO A 213     -25.386  86.605  25.559  1.00 42.41           C  
ATOM   1505  CG  PRO A 213     -26.062  85.860  24.437  1.00 37.25           C  
ATOM   1506  CD  PRO A 213     -25.385  84.523  24.507  1.00 37.91           C  
ATOM   1507  N   THR A 214     -23.286  85.127  27.434  1.00 33.70           N  
ATOM   1508  CA  THR A 214     -22.629  84.987  28.721  1.00 37.13           C  
ATOM   1509  C   THR A 214     -21.130  84.777  28.539  1.00 32.48           C  
ATOM   1510  O   THR A 214     -20.325  85.283  29.322  1.00 28.36           O  
ATOM   1511  CB  THR A 214     -23.232  83.814  29.498  1.00 35.06           C  
ATOM   1512  OG1 THR A 214     -24.609  84.101  29.765  1.00 42.97           O  
ATOM   1513  CG2 THR A 214     -22.496  83.595  30.808  1.00 32.06           C  
ATOM   1514  N   ALA A 215     -20.765  84.040  27.493  1.00 24.90           N  
ATOM   1515  CA  ALA A 215     -19.369  83.773  27.200  1.00 25.86           C  
ATOM   1516  C   ALA A 215     -18.671  85.067  26.771  1.00 28.48           C  
ATOM   1517  O   ALA A 215     -17.472  85.243  26.997  1.00 25.29           O  
ATOM   1518  CB  ALA A 215     -19.258  82.730  26.101  1.00 23.73           C  
ATOM   1519  N   ILE A 216     -19.439  85.971  26.172  1.00 19.68           N  
ATOM   1520  CA  ILE A 216     -18.910  87.239  25.697  1.00 22.67           C  
ATOM   1521  C   ILE A 216     -18.711  88.224  26.839  1.00 27.01           C  
ATOM   1522  O   ILE A 216     -17.693  88.909  26.894  1.00 23.98           O  
ATOM   1523  CB  ILE A 216     -19.842  87.872  24.625  1.00 20.70           C  
ATOM   1524  CG1 ILE A 216     -19.871  86.999  23.366  1.00 19.84           C  
ATOM   1525  CG2 ILE A 216     -19.365  89.265  24.266  1.00 25.28           C  
ATOM   1526  CD1 ILE A 216     -18.536  86.864  22.671  1.00 30.46           C  
ATOM   1527  N   ARG A 217     -19.669  88.299  27.760  1.00 25.06           N  
ATOM   1528  CA  ARG A 217     -19.531  89.233  28.871  1.00 24.02           C  
ATOM   1529  C   ARG A 217     -18.382  88.842  29.789  1.00 18.05           C  
ATOM   1530  O   ARG A 217     -17.714  89.709  30.355  1.00 22.69           O  
ATOM   1531  CB  ARG A 217     -20.832  89.339  29.675  1.00 32.31           C  
ATOM   1532  CG  ARG A 217     -21.238  88.110  30.479  1.00 34.54           C  
ATOM   1533  CD  ARG A 217     -22.524  88.410  31.246  1.00 37.46           C  
ATOM   1534  NE  ARG A 217     -22.326  89.470  32.232  1.00 31.55           N  
ATOM   1535  CZ  ARG A 217     -23.261  90.335  32.607  1.00 31.85           C  
ATOM   1536  NH1 ARG A 217     -24.476  90.275  32.075  1.00 28.69           N  
ATOM   1537  NH2 ARG A 217     -22.980  91.264  33.514  1.00 22.17           N  
ATOM   1538  N   PHE A 218     -18.153  87.542  29.931  1.00  7.82           N  
ATOM   1539  CA  PHE A 218     -17.074  87.049  30.782  1.00 24.08           C  
ATOM   1540  C   PHE A 218     -15.704  87.382  30.192  1.00 23.70           C  
ATOM   1541  O   PHE A 218     -14.782  87.742  30.922  1.00 21.10           O  
ATOM   1542  CB  PHE A 218     -17.198  85.534  30.989  1.00 19.57           C  
ATOM   1543  CG  PHE A 218     -17.979  85.151  32.219  1.00 25.89           C  
ATOM   1544  CD1 PHE A 218     -17.497  85.461  33.486  1.00 28.87           C  
ATOM   1545  CD2 PHE A 218     -19.200  84.492  32.115  1.00 22.29           C  
ATOM   1546  CE1 PHE A 218     -18.218  85.120  34.633  1.00 28.38           C  
ATOM   1547  CE2 PHE A 218     -19.927  84.148  33.254  1.00 31.26           C  
ATOM   1548  CZ  PHE A 218     -19.434  84.464  34.516  1.00 27.30           C  
ATOM   1549  N   LEU A 219     -15.578  87.257  28.876  1.00 20.29           N  
ATOM   1550  CA  LEU A 219     -14.322  87.555  28.202  1.00 22.76           C  
ATOM   1551  C   LEU A 219     -14.048  89.050  28.257  1.00 22.36           C  
ATOM   1552  O   LEU A 219     -12.910  89.480  28.473  1.00 17.76           O  
ATOM   1553  CB  LEU A 219     -14.373  87.082  26.742  1.00 20.33           C  
ATOM   1554  CG  LEU A 219     -14.267  85.569  26.526  1.00 18.96           C  
ATOM   1555  CD1 LEU A 219     -14.828  85.192  25.165  1.00 19.56           C  
ATOM   1556  CD2 LEU A 219     -12.821  85.137  26.652  1.00 15.35           C  
ATOM   1557  N   LYS A 220     -15.093  89.849  28.063  1.00 21.84           N  
ATOM   1558  CA  LYS A 220     -14.915  91.289  28.098  1.00 17.37           C  
ATOM   1559  C   LYS A 220     -14.415  91.689  29.478  1.00 23.27           C  
ATOM   1560  O   LYS A 220     -13.521  92.524  29.600  1.00 18.94           O  
ATOM   1561  CB  LYS A 220     -16.222  92.012  27.769  1.00 23.75           C  
ATOM   1562  CG  LYS A 220     -16.093  93.531  27.807  1.00 20.16           C  
ATOM   1563  CD  LYS A 220     -17.241  94.214  27.092  1.00 15.76           C  
ATOM   1564  CE  LYS A 220     -17.124  95.719  27.203  1.00 12.05           C  
ATOM   1565  NZ  LYS A 220     -18.231  96.417  26.488  1.00 25.70           N  
ATOM   1566  N   ALA A 221     -14.990  91.083  30.516  1.00 21.15           N  
ATOM   1567  CA  ALA A 221     -14.582  91.379  31.884  1.00 19.25           C  
ATOM   1568  C   ALA A 221     -13.133  90.925  32.105  1.00 20.38           C  
ATOM   1569  O   ALA A 221     -12.338  91.637  32.714  1.00 18.59           O  
ATOM   1570  CB  ALA A 221     -15.508  90.684  32.870  1.00 11.27           C  
ATOM   1571  N   ALA A 222     -12.797  89.741  31.601  1.00 14.68           N  
ATOM   1572  CA  ALA A 222     -11.444  89.204  31.736  1.00 16.73           C  
ATOM   1573  C   ALA A 222     -10.434  90.127  31.065  1.00 21.13           C  
ATOM   1574  O   ALA A 222      -9.309  90.285  31.552  1.00 20.00           O  
ATOM   1575  CB  ALA A 222     -11.364  87.819  31.119  1.00 16.16           C  
ATOM   1576  N   PHE A 223     -10.838  90.722  29.944  1.00 16.38           N  
ATOM   1577  CA  PHE A 223      -9.977  91.650  29.213  1.00 15.37           C  
ATOM   1578  C   PHE A 223      -9.821  92.920  30.028  1.00 19.29           C  
ATOM   1579  O   PHE A 223      -8.761  93.539  30.025  1.00 21.91           O  
ATOM   1580  CB  PHE A 223     -10.572  92.006  27.846  1.00 12.06           C  
ATOM   1581  CG  PHE A 223     -10.236  91.026  26.750  1.00 10.82           C  
ATOM   1582  CD1 PHE A 223      -8.909  90.801  26.383  1.00 21.51           C  
ATOM   1583  CD2 PHE A 223     -11.243  90.358  26.061  1.00 14.27           C  
ATOM   1584  CE1 PHE A 223      -8.592  89.930  25.344  1.00 15.26           C  
ATOM   1585  CE2 PHE A 223     -10.938  89.487  25.025  1.00 18.91           C  
ATOM   1586  CZ  PHE A 223      -9.605  89.273  24.663  1.00 24.10           C  
ATOM   1587  N   ASN A 224     -10.880  93.314  30.730  1.00 13.82           N  
ATOM   1588  CA  ASN A 224     -10.802  94.520  31.544  1.00 17.52           C  
ATOM   1589  C   ASN A 224      -9.950  94.282  32.787  1.00 14.91           C  
ATOM   1590  O   ASN A 224      -9.219  95.171  33.231  1.00 17.99           O  
ATOM   1591  CB  ASN A 224     -12.206  95.008  31.919  1.00 13.45           C  
ATOM   1592  CG  ASN A 224     -12.921  95.668  30.742  1.00 21.75           C  
ATOM   1593  OD1 ASN A 224     -12.298  95.935  29.715  1.00 20.77           O  
ATOM   1594  ND2 ASN A 224     -14.216  95.942  30.888  1.00 14.69           N  
ATOM   1595  N   ALA A 225     -10.029  93.068  33.326  1.00 12.87           N  
ATOM   1596  CA  ALA A 225      -9.258  92.699  34.509  1.00 16.26           C  
ATOM   1597  C   ALA A 225      -7.761  92.696  34.180  1.00 15.27           C  
ATOM   1598  O   ALA A 225      -6.927  92.902  35.053  1.00 20.77           O  
ATOM   1599  CB  ALA A 225      -9.699  91.320  35.019  1.00 10.99           C  
ATOM   1600  N   ASP A 226      -7.436  92.474  32.909  1.00 21.36           N  
ATOM   1601  CA  ASP A 226      -6.050  92.452  32.454  1.00 19.62           C  
ATOM   1602  C   ASP A 226      -5.299  93.736  32.781  1.00 23.95           C  
ATOM   1603  O   ASP A 226      -4.090  93.706  33.006  1.00 21.96           O  
ATOM   1604  CB  ASP A 226      -5.988  92.217  30.939  1.00 18.52           C  
ATOM   1605  CG  ASP A 226      -4.562  92.285  30.387  1.00 26.55           C  
ATOM   1606  OD1 ASP A 226      -3.687  91.558  30.902  1.00 27.21           O  
ATOM   1607  OD2 ASP A 226      -4.317  93.056  29.432  1.00 24.60           O  
ATOM   1608  N   SER A 227      -6.009  94.860  32.829  1.00 13.37           N  
ATOM   1609  CA  SER A 227      -5.347  96.130  33.086  1.00 14.83           C  
ATOM   1610  C   SER A 227      -5.920  96.980  34.208  1.00 18.22           C  
ATOM   1611  O   SER A 227      -5.295  97.963  34.612  1.00 13.26           O  
ATOM   1612  CB  SER A 227      -5.345  96.967  31.807  1.00 22.60           C  
ATOM   1613  OG  SER A 227      -6.668  97.369  31.473  1.00 24.31           O  
ATOM   1614  N   ASP A 228      -7.093  96.613  34.718  1.00 17.77           N  
ATOM   1615  CA  ASP A 228      -7.728  97.419  35.752  1.00 13.51           C  
ATOM   1616  C   ASP A 228      -7.725  96.935  37.192  1.00 15.44           C  
ATOM   1617  O   ASP A 228      -8.569  97.351  37.981  1.00 16.53           O  
ATOM   1618  CB  ASP A 228      -9.156  97.740  35.321  1.00 15.13           C  
ATOM   1619  CG  ASP A 228      -9.199  98.664  34.129  1.00 23.08           C  
ATOM   1620  OD1 ASP A 228      -8.115  98.938  33.561  1.00 20.10           O  
ATOM   1621  OD2 ASP A 228     -10.306  99.116  33.758  1.00 22.54           O  
ATOM   1622  N   GLY A 229      -6.767  96.082  37.539  1.00 17.53           N  
ATOM   1623  CA  GLY A 229      -6.669  95.589  38.899  1.00 13.88           C  
ATOM   1624  C   GLY A 229      -7.986  95.194  39.535  1.00 17.83           C  
ATOM   1625  O   GLY A 229      -8.808  94.518  38.919  1.00 16.58           O  
ATOM   1626  N   LEU A 230      -8.190  95.625  40.776  1.00 19.54           N  
ATOM   1627  CA  LEU A 230      -9.408  95.294  41.509  1.00 14.19           C  
ATOM   1628  C   LEU A 230     -10.679  95.782  40.815  1.00 19.68           C  
ATOM   1629  O   LEU A 230     -11.727  95.144  40.919  1.00 16.74           O  
ATOM   1630  CB  LEU A 230      -9.317  95.851  42.936  1.00  9.79           C  
ATOM   1631  CG  LEU A 230      -9.018  94.848  44.061  1.00 24.21           C  
ATOM   1632  CD1 LEU A 230      -7.988  93.833  43.618  1.00 28.78           C  
ATOM   1633  CD2 LEU A 230      -8.551  95.592  45.303  1.00 21.13           C  
ATOM   1634  N   ALA A 231     -10.589  96.902  40.102  1.00 11.55           N  
ATOM   1635  CA  ALA A 231     -11.748  97.445  39.389  1.00 19.01           C  
ATOM   1636  C   ALA A 231     -12.178  96.450  38.312  1.00 22.37           C  
ATOM   1637  O   ALA A 231     -13.375  96.245  38.066  1.00 18.22           O  
ATOM   1638  CB  ALA A 231     -11.396  98.793  38.751  1.00 13.83           C  
ATOM   1639  N   GLY A 232     -11.190  95.831  37.676  1.00 12.59           N  
ATOM   1640  CA  GLY A 232     -11.469  94.853  36.644  1.00 10.49           C  
ATOM   1641  C   GLY A 232     -11.887  93.529  37.259  1.00 15.12           C  
ATOM   1642  O   GLY A 232     -12.710  92.818  36.704  1.00 14.50           O  
ATOM   1643  N   ILE A 233     -11.313  93.189  38.406  1.00 15.83           N  
ATOM   1644  CA  ILE A 233     -11.674  91.946  39.068  1.00 18.86           C  
ATOM   1645  C   ILE A 233     -13.098  92.055  39.615  1.00 18.60           C  
ATOM   1646  O   ILE A 233     -13.819  91.060  39.700  1.00 18.85           O  
ATOM   1647  CB  ILE A 233     -10.679  91.612  40.205  1.00 16.00           C  
ATOM   1648  CG1 ILE A 233      -9.294  91.341  39.599  1.00 23.51           C  
ATOM   1649  CG2 ILE A 233     -11.156  90.393  40.992  1.00  7.34           C  
ATOM   1650  CD1 ILE A 233      -8.201  91.081  40.621  1.00 22.42           C  
ATOM   1651  N   GLN A 234     -13.512  93.264  39.973  1.00 17.56           N  
ATOM   1652  CA  GLN A 234     -14.867  93.434  40.482  1.00 18.67           C  
ATOM   1653  C   GLN A 234     -15.856  93.069  39.379  1.00 18.26           C  
ATOM   1654  O   GLN A 234     -16.933  92.547  39.654  1.00 24.07           O  
ATOM   1655  CB  GLN A 234     -15.115  94.874  40.934  1.00 24.40           C  
ATOM   1656  CG  GLN A 234     -16.519  95.091  41.509  1.00 21.55           C  
ATOM   1657  CD  GLN A 234     -17.107  96.425  41.110  1.00 22.79           C  
ATOM   1658  OE1 GLN A 234     -17.071  96.800  39.940  1.00 24.22           O  
ATOM   1659  NE2 GLN A 234     -17.658  97.150  42.080  1.00 19.88           N  
ATOM   1660  N   GLN A 235     -15.477  93.334  38.131  1.00 24.87           N  
ATOM   1661  CA  GLN A 235     -16.324  93.039  36.978  1.00 16.82           C  
ATOM   1662  C   GLN A 235     -16.382  91.540  36.683  1.00 24.43           C  
ATOM   1663  O   GLN A 235     -17.462  90.979  36.508  1.00 23.95           O  
ATOM   1664  CB  GLN A 235     -15.813  93.778  35.731  1.00 22.10           C  
ATOM   1665  CG  GLN A 235     -16.900  94.022  34.662  1.00 20.48           C  
ATOM   1666  CD  GLN A 235     -16.343  94.538  33.345  1.00 24.53           C  
ATOM   1667  OE1 GLN A 235     -15.366  95.280  33.321  1.00 24.69           O  
ATOM   1668  NE2 GLN A 235     -16.977  94.155  32.240  1.00 18.32           N  
ATOM   1669  N   LEU A 236     -15.216  90.901  36.618  1.00 17.07           N  
ATOM   1670  CA  LEU A 236     -15.136  89.472  36.347  1.00 18.73           C  
ATOM   1671  C   LEU A 236     -15.740  88.656  37.491  1.00 25.93           C  
ATOM   1672  O   LEU A 236     -16.463  87.686  37.252  1.00 24.56           O  
ATOM   1673  CB  LEU A 236     -13.675  89.055  36.127  1.00 12.41           C  
ATOM   1674  CG  LEU A 236     -13.427  87.577  35.823  1.00 20.05           C  
ATOM   1675  CD1 LEU A 236     -14.209  87.160  34.577  1.00 18.88           C  
ATOM   1676  CD2 LEU A 236     -11.939  87.344  35.616  1.00 10.81           C  
ATOM   1677  N   ALA A 237     -15.435  89.043  38.727  1.00 21.38           N  
ATOM   1678  CA  ALA A 237     -15.970  88.347  39.892  1.00 19.60           C  
ATOM   1679  C   ALA A 237     -17.469  88.642  39.991  1.00 19.29           C  
ATOM   1680  O   ALA A 237     -18.259  87.783  40.384  1.00 17.29           O  
ATOM   1681  CB  ALA A 237     -15.254  88.806  41.163  1.00 15.62           C  
ATOM   1682  N   GLY A 238     -17.850  89.863  39.631  1.00 18.00           N  
ATOM   1683  CA  GLY A 238     -19.253  90.241  39.669  1.00 20.21           C  
ATOM   1684  C   GLY A 238     -20.086  89.358  38.751  1.00 24.55           C  
ATOM   1685  O   GLY A 238     -21.101  88.801  39.168  1.00 25.27           O  
ATOM   1686  N   ASP A 239     -19.658  89.224  37.499  1.00 21.53           N  
ATOM   1687  CA  ASP A 239     -20.374  88.392  36.532  1.00 25.30           C  
ATOM   1688  C   ASP A 239     -20.523  86.961  37.046  1.00 28.89           C  
ATOM   1689  O   ASP A 239     -21.561  86.329  36.852  1.00 32.16           O  
ATOM   1690  CB  ASP A 239     -19.642  88.391  35.189  1.00 23.24           C  
ATOM   1691  CG  ASP A 239     -19.929  89.634  34.366  1.00 29.74           C  
ATOM   1692  OD1 ASP A 239     -20.488  90.605  34.914  1.00 31.00           O  
ATOM   1693  OD2 ASP A 239     -19.589  89.641  33.168  1.00 41.54           O  
ATOM   1694  N   ALA A 240     -19.482  86.452  37.697  1.00 23.27           N  
ATOM   1695  CA  ALA A 240     -19.524  85.104  38.245  1.00 28.24           C  
ATOM   1696  C   ALA A 240     -20.606  85.022  39.329  1.00 27.90           C  
ATOM   1697  O   ALA A 240     -21.324  84.032  39.416  1.00 27.88           O  
ATOM   1698  CB  ALA A 240     -18.153  84.720  38.825  1.00 18.69           C  
ATOM   1699  N   THR A 241     -20.718  86.064  40.153  1.00 31.67           N  
ATOM   1700  CA  THR A 241     -21.727  86.084  41.210  1.00 36.48           C  
ATOM   1701  C   THR A 241     -23.105  86.007  40.561  1.00 37.06           C  
ATOM   1702  O   THR A 241     -24.003  85.314  41.043  1.00 34.28           O  
ATOM   1703  CB  THR A 241     -21.652  87.379  42.045  1.00 35.54           C  
ATOM   1704  OG1 THR A 241     -20.367  87.474  42.670  1.00 25.48           O  
ATOM   1705  CG2 THR A 241     -22.735  87.381  43.120  1.00 33.55           C  
ATOM   1706  N   LEU A 242     -23.253  86.730  39.457  1.00 37.72           N  
ATOM   1707  CA  LEU A 242     -24.500  86.764  38.701  1.00 34.88           C  
ATOM   1708  C   LEU A 242     -24.825  85.346  38.228  1.00 36.53           C  
ATOM   1709  O   LEU A 242     -25.921  84.838  38.447  1.00 38.33           O  
ATOM   1710  CB  LEU A 242     -24.334  87.682  37.492  1.00 35.05           C  
ATOM   1711  CG  LEU A 242     -25.527  88.505  37.022  1.00 37.60           C  
ATOM   1712  CD1 LEU A 242     -25.989  89.432  38.138  1.00 44.09           C  
ATOM   1713  CD2 LEU A 242     -25.115  89.308  35.801  1.00 42.68           C  
ATOM   1714  N   LEU A 243     -23.852  84.710  37.588  1.00 36.57           N  
ATOM   1715  CA  LEU A 243     -24.029  83.360  37.080  1.00 38.24           C  
ATOM   1716  C   LEU A 243     -24.284  82.357  38.211  1.00 40.18           C  
ATOM   1717  O   LEU A 243     -25.044  81.406  38.036  1.00 44.22           O  
ATOM   1718  CB  LEU A 243     -22.791  82.947  36.280  1.00 35.21           C  
ATOM   1719  CG  LEU A 243     -22.879  81.702  35.397  1.00 40.57           C  
ATOM   1720  CD1 LEU A 243     -23.943  81.902  34.332  1.00 42.41           C  
ATOM   1721  CD2 LEU A 243     -21.531  81.448  34.747  1.00 37.42           C  
ATOM   1722  N   PHE A 244     -23.658  82.570  39.367  1.00 35.25           N  
ATOM   1723  CA  PHE A 244     -23.829  81.665  40.504  1.00 33.30           C  
ATOM   1724  C   PHE A 244     -25.261  81.663  41.025  1.00 32.24           C  
ATOM   1725  O   PHE A 244     -25.803  80.605  41.332  1.00 40.67           O  
ATOM   1726  CB  PHE A 244     -22.870  82.034  41.641  1.00 30.70           C  
ATOM   1727  CG  PHE A 244     -22.881  81.060  42.793  1.00 26.66           C  
ATOM   1728  CD1 PHE A 244     -22.840  79.686  42.567  1.00 35.02           C  
ATOM   1729  CD2 PHE A 244     -22.887  81.517  44.107  1.00 32.19           C  
ATOM   1730  CE1 PHE A 244     -22.804  78.783  43.638  1.00 35.95           C  
ATOM   1731  CE2 PHE A 244     -22.850  80.625  45.182  1.00 27.05           C  
ATOM   1732  CZ  PHE A 244     -22.808  79.258  44.949  1.00 26.00           C  
ATOM   1733  N   TYR A 245     -25.871  82.842  41.123  1.00 33.35           N  
ATOM   1734  CA  TYR A 245     -27.245  82.940  41.600  1.00 41.12           C  
ATOM   1735  C   TYR A 245     -28.162  82.087  40.729  1.00 46.63           C  
ATOM   1736  O   TYR A 245     -29.294  81.795  41.107  1.00 47.93           O  
ATOM   1737  CB  TYR A 245     -27.741  84.390  41.569  1.00 40.58           C  
ATOM   1738  CG  TYR A 245     -27.105  85.321  42.580  1.00 42.63           C  
ATOM   1739  CD1 TYR A 245     -26.686  84.856  43.828  1.00 45.43           C  
ATOM   1740  CD2 TYR A 245     -26.978  86.683  42.311  1.00 42.67           C  
ATOM   1741  CE1 TYR A 245     -26.156  85.723  44.782  1.00 36.85           C  
ATOM   1742  CE2 TYR A 245     -26.451  87.560  43.258  1.00 45.12           C  
ATOM   1743  CZ  TYR A 245     -26.043  87.074  44.490  1.00 45.48           C  
ATOM   1744  OH  TYR A 245     -25.530  87.942  45.428  1.00 45.40           O  
ATOM   1745  N   THR A 246     -27.659  81.694  39.562  1.00 51.74           N  
ATOM   1746  CA  THR A 246     -28.412  80.876  38.618  1.00 51.03           C  
ATOM   1747  C   THR A 246     -28.465  79.406  39.017  1.00 47.14           C  
ATOM   1748  O   THR A 246     -29.475  78.737  38.807  1.00 50.77           O  
ATOM   1749  CB  THR A 246     -27.802  80.974  37.196  1.00 49.31           C  
ATOM   1750  OG1 THR A 246     -28.181  82.220  36.601  1.00 47.96           O  
ATOM   1751  CG2 THR A 246     -28.273  79.821  36.317  1.00 52.24           C  
ATOM   1752  N   THR A 247     -27.376  78.910  39.592  1.00 43.46           N  
ATOM   1753  CA  THR A 247     -27.284  77.511  39.999  1.00 42.23           C  
ATOM   1754  C   THR A 247     -28.204  77.108  41.147  1.00 44.11           C  
ATOM   1755  O   THR A 247     -28.665  77.946  41.927  1.00 39.82           O  
ATOM   1756  CB  THR A 247     -25.859  77.155  40.426  1.00 38.93           C  
ATOM   1757  OG1 THR A 247     -25.539  77.858  41.632  1.00 36.72           O  
ATOM   1758  CG2 THR A 247     -24.873  77.533  39.342  1.00 42.40           C  
ATOM   1759  N   GLU A 248     -28.453  75.807  41.247  1.00 42.09           N  
ATOM   1760  CA  GLU A 248     -29.293  75.271  42.306  1.00 49.92           C  
ATOM   1761  C   GLU A 248     -28.571  75.428  43.637  1.00 47.02           C  
ATOM   1762  O   GLU A 248     -29.183  75.815  44.633  1.00 40.28           O  
ATOM   1763  CB  GLU A 248     -29.599  73.791  42.056  1.00 51.59           C  
ATOM   1764  CG  GLU A 248     -30.605  73.534  40.946  1.00 62.58           C  
ATOM   1765  CD  GLU A 248     -31.925  74.246  41.185  1.00 72.60           C  
ATOM   1766  OE1 GLU A 248     -32.470  74.132  42.304  1.00 75.50           O  
ATOM   1767  OE2 GLU A 248     -32.421  74.914  40.253  1.00 78.71           O  
ATOM   1768  N   GLU A 249     -27.272  75.133  43.646  1.00 44.56           N  
ATOM   1769  CA  GLU A 249     -26.466  75.244  44.858  1.00 42.52           C  
ATOM   1770  C   GLU A 249     -26.722  76.593  45.518  1.00 37.31           C  
ATOM   1771  O   GLU A 249     -26.949  76.672  46.721  1.00 39.17           O  
ATOM   1772  CB  GLU A 249     -24.972  75.106  44.539  1.00 42.49           C  
ATOM   1773  CG  GLU A 249     -24.093  74.953  45.782  1.00 44.07           C  
ATOM   1774  CD  GLU A 249     -22.611  74.805  45.459  1.00 48.56           C  
ATOM   1775  OE1 GLU A 249     -22.274  74.042  44.527  1.00 44.89           O  
ATOM   1776  OE2 GLU A 249     -21.783  75.440  46.153  1.00 35.63           O  
ATOM   1777  N   ALA A 250     -26.692  77.652  44.719  1.00 40.93           N  
ATOM   1778  CA  ALA A 250     -26.928  78.993  45.231  1.00 43.76           C  
ATOM   1779  C   ALA A 250     -28.354  79.108  45.757  1.00 48.98           C  
ATOM   1780  O   ALA A 250     -28.590  79.724  46.799  1.00 50.74           O  
ATOM   1781  CB  ALA A 250     -26.692  80.018  44.135  1.00 47.58           C  
ATOM   1782  N   LYS A 251     -29.300  78.519  45.030  1.00 50.58           N  
ATOM   1783  CA  LYS A 251     -30.704  78.546  45.428  1.00 47.20           C  
ATOM   1784  C   LYS A 251     -30.875  77.975  46.832  1.00 43.09           C  
ATOM   1785  O   LYS A 251     -31.611  78.522  47.649  1.00 45.02           O  
ATOM   1786  CB  LYS A 251     -31.563  77.736  44.450  1.00 53.32           C  
ATOM   1787  CG  LYS A 251     -32.380  78.561  43.460  1.00 58.55           C  
ATOM   1788  CD  LYS A 251     -31.572  78.984  42.245  1.00 65.10           C  
ATOM   1789  CE  LYS A 251     -32.459  79.681  41.225  1.00 65.68           C  
ATOM   1790  NZ  LYS A 251     -31.724  80.020  39.977  1.00 68.76           N  
ATOM   1791  N   GLU A 252     -30.198  76.863  47.103  1.00 38.97           N  
ATOM   1792  CA  GLU A 252     -30.276  76.226  48.412  1.00 42.03           C  
ATOM   1793  C   GLU A 252     -29.928  77.228  49.502  1.00 46.34           C  
ATOM   1794  O   GLU A 252     -30.550  77.250  50.564  1.00 46.85           O  
ATOM   1795  CB  GLU A 252     -29.309  75.042  48.487  1.00 42.28           C  
ATOM   1796  CG  GLU A 252     -29.108  74.496  49.900  1.00 51.14           C  
ATOM   1797  CD  GLU A 252     -30.354  73.834  50.465  1.00 51.13           C  
ATOM   1798  OE1 GLU A 252     -31.433  74.462  50.438  1.00 51.41           O  
ATOM   1799  OE2 GLU A 252     -30.252  72.684  50.942  1.00 52.58           O  
ATOM   1800  N   GLY A 253     -28.927  78.055  49.220  1.00 47.65           N  
ATOM   1801  CA  GLY A 253     -28.479  79.049  50.171  1.00 41.61           C  
ATOM   1802  C   GLY A 253     -29.566  79.973  50.673  1.00 48.27           C  
ATOM   1803  O   GLY A 253     -29.802  80.050  51.877  1.00 51.86           O  
ATOM   1804  N   MET A 254     -30.232  80.681  49.766  1.00 52.81           N  
ATOM   1805  CA  MET A 254     -31.275  81.606  50.183  1.00 59.72           C  
ATOM   1806  C   MET A 254     -32.549  80.864  50.548  1.00 59.06           C  
ATOM   1807  O   MET A 254     -33.392  81.383  51.276  1.00 61.34           O  
ATOM   1808  CB  MET A 254     -31.555  82.640  49.088  1.00 69.06           C  
ATOM   1809  CG  MET A 254     -32.417  83.813  49.565  1.00 83.66           C  
ATOM   1810  SD  MET A 254     -32.216  85.339  48.603  1.00 94.38           S  
ATOM   1811  CE  MET A 254     -33.455  85.112  47.326  1.00 95.69           C  
ATOM   1812  N   ARG A 255     -32.683  79.639  50.052  1.00 55.87           N  
ATOM   1813  CA  ARG A 255     -33.861  78.846  50.357  1.00 57.10           C  
ATOM   1814  C   ARG A 255     -33.808  78.510  51.840  1.00 53.54           C  
ATOM   1815  O   ARG A 255     -34.774  78.723  52.573  1.00 54.70           O  
ATOM   1816  CB  ARG A 255     -33.873  77.557  49.535  1.00 59.91           C  
ATOM   1817  CG  ARG A 255     -35.262  77.138  49.096  1.00 70.41           C  
ATOM   1818  CD  ARG A 255     -35.794  78.094  48.039  1.00 80.99           C  
ATOM   1819  NE  ARG A 255     -37.251  78.069  47.942  1.00 89.67           N  
ATOM   1820  CZ  ARG A 255     -37.953  78.748  47.040  1.00 92.63           C  
ATOM   1821  NH1 ARG A 255     -37.329  79.504  46.146  1.00 93.31           N  
ATOM   1822  NH2 ARG A 255     -39.279  78.680  47.036  1.00 92.73           N  
ATOM   1823  N   ALA A 256     -32.661  77.995  52.273  1.00 51.17           N  
ATOM   1824  CA  ALA A 256     -32.459  77.624  53.666  1.00 46.72           C  
ATOM   1825  C   ALA A 256     -32.589  78.845  54.569  1.00 48.41           C  
ATOM   1826  O   ALA A 256     -33.186  78.775  55.644  1.00 45.89           O  
ATOM   1827  CB  ALA A 256     -31.091  76.988  53.840  1.00 47.82           C  
ATOM   1828  N   PHE A 257     -32.033  79.966  54.129  1.00 45.94           N  
ATOM   1829  CA  PHE A 257     -32.111  81.184  54.916  1.00 49.33           C  
ATOM   1830  C   PHE A 257     -33.570  81.531  55.191  1.00 53.37           C  
ATOM   1831  O   PHE A 257     -33.927  81.870  56.317  1.00 55.65           O  
ATOM   1832  CB  PHE A 257     -31.439  82.343  54.182  1.00 45.29           C  
ATOM   1833  CG  PHE A 257     -31.366  83.606  54.993  1.00 47.71           C  
ATOM   1834  CD1 PHE A 257     -30.592  83.659  56.149  1.00 44.12           C  
ATOM   1835  CD2 PHE A 257     -32.075  84.740  54.607  1.00 48.02           C  
ATOM   1836  CE1 PHE A 257     -30.524  84.825  56.911  1.00 49.44           C  
ATOM   1837  CE2 PHE A 257     -32.014  85.913  55.363  1.00 45.66           C  
ATOM   1838  CZ  PHE A 257     -31.237  85.954  56.516  1.00 48.10           C  
ATOM   1839  N   LYS A 258     -34.409  81.446  54.161  1.00 56.09           N  
ATOM   1840  CA  LYS A 258     -35.828  81.748  54.315  1.00 61.87           C  
ATOM   1841  C   LYS A 258     -36.520  80.685  55.160  1.00 62.48           C  
ATOM   1842  O   LYS A 258     -37.404  80.995  55.958  1.00 63.20           O  
ATOM   1843  CB  LYS A 258     -36.523  81.842  52.950  1.00 68.13           C  
ATOM   1844  CG  LYS A 258     -36.641  83.259  52.401  1.00 74.53           C  
ATOM   1845  CD  LYS A 258     -35.537  83.586  51.412  1.00 82.66           C  
ATOM   1846  CE  LYS A 258     -35.788  82.922  50.065  1.00 87.41           C  
ATOM   1847  NZ  LYS A 258     -37.018  83.449  49.402  1.00 88.96           N  
ATOM   1848  N   GLU A 259     -36.110  79.434  54.980  1.00 62.96           N  
ATOM   1849  CA  GLU A 259     -36.688  78.317  55.721  1.00 60.91           C  
ATOM   1850  C   GLU A 259     -36.171  78.245  57.156  1.00 58.47           C  
ATOM   1851  O   GLU A 259     -36.459  77.292  57.882  1.00 58.06           O  
ATOM   1852  CB  GLU A 259     -36.395  77.002  54.988  1.00 57.41           C  
ATOM   1853  CG  GLU A 259     -37.224  76.806  53.719  1.00 61.32           C  
ATOM   1854  CD  GLU A 259     -36.844  75.557  52.943  1.00 64.51           C  
ATOM   1855  OE1 GLU A 259     -36.629  74.501  53.576  1.00 68.82           O  
ATOM   1856  OE2 GLU A 259     -36.772  75.627  51.698  1.00 64.90           O  
ATOM   1857  N   LYS A 260     -35.419  79.263  57.561  1.00 57.94           N  
ATOM   1858  CA  LYS A 260     -34.850  79.330  58.904  1.00 56.80           C  
ATOM   1859  C   LYS A 260     -34.134  78.037  59.297  1.00 55.10           C  
ATOM   1860  O   LYS A 260     -34.240  77.573  60.435  1.00 57.69           O  
ATOM   1861  CB  LYS A 260     -35.944  79.666  59.930  1.00 59.42           C  
ATOM   1862  CG  LYS A 260     -36.563  81.047  59.731  1.00 69.57           C  
ATOM   1863  CD  LYS A 260     -37.360  81.532  60.946  1.00 77.85           C  
ATOM   1864  CE  LYS A 260     -38.687  80.801  61.125  1.00 84.45           C  
ATOM   1865  NZ  LYS A 260     -38.534  79.395  61.595  1.00 86.06           N  
ATOM   1866  N   ARG A 261     -33.399  77.463  58.350  1.00 49.69           N  
ATOM   1867  CA  ARG A 261     -32.658  76.228  58.590  1.00 49.23           C  
ATOM   1868  C   ARG A 261     -31.240  76.346  58.052  1.00 51.60           C  
ATOM   1869  O   ARG A 261     -30.909  77.299  57.350  1.00 53.22           O  
ATOM   1870  CB  ARG A 261     -33.349  75.049  57.903  1.00 47.30           C  
ATOM   1871  CG  ARG A 261     -33.333  75.124  56.380  1.00 50.99           C  
ATOM   1872  CD  ARG A 261     -34.057  73.944  55.763  1.00 51.99           C  
ATOM   1873  NE  ARG A 261     -34.161  74.052  54.310  1.00 59.24           N  
ATOM   1874  CZ  ARG A 261     -33.168  73.813  53.458  1.00 57.95           C  
ATOM   1875  NH1 ARG A 261     -31.975  73.442  53.904  1.00 58.89           N  
ATOM   1876  NH2 ARG A 261     -33.372  73.947  52.155  1.00 54.76           N  
ATOM   1877  N   LYS A 262     -30.402  75.372  58.385  1.00 57.25           N  
ATOM   1878  CA  LYS A 262     -29.029  75.364  57.906  1.00 58.12           C  
ATOM   1879  C   LYS A 262     -29.069  74.803  56.491  1.00 54.44           C  
ATOM   1880  O   LYS A 262     -29.721  73.794  56.237  1.00 55.42           O  
ATOM   1881  CB  LYS A 262     -28.152  74.475  58.798  1.00 64.61           C  
ATOM   1882  CG  LYS A 262     -28.569  73.007  58.818  1.00 80.41           C  
ATOM   1883  CD  LYS A 262     -27.697  72.170  59.750  1.00 90.04           C  
ATOM   1884  CE  LYS A 262     -26.248  72.121  59.284  1.00 97.64           C  
ATOM   1885  NZ  LYS A 262     -25.411  71.272  60.180  1.00 99.62           N  
ATOM   1886  N   PRO A 263     -28.388  75.457  55.545  1.00 54.05           N  
ATOM   1887  CA  PRO A 263     -28.402  74.950  54.171  1.00 51.91           C  
ATOM   1888  C   PRO A 263     -27.634  73.638  54.027  1.00 50.22           C  
ATOM   1889  O   PRO A 263     -26.745  73.334  54.821  1.00 47.44           O  
ATOM   1890  CB  PRO A 263     -27.769  76.091  53.382  1.00 54.05           C  
ATOM   1891  CG  PRO A 263     -26.800  76.668  54.363  1.00 55.53           C  
ATOM   1892  CD  PRO A 263     -27.611  76.706  55.637  1.00 53.54           C  
ATOM   1893  N   ASP A 264     -27.993  72.858  53.014  1.00 49.93           N  
ATOM   1894  CA  ASP A 264     -27.330  71.586  52.760  1.00 53.69           C  
ATOM   1895  C   ASP A 264     -26.695  71.616  51.375  1.00 54.66           C  
ATOM   1896  O   ASP A 264     -27.369  71.389  50.369  1.00 57.04           O  
ATOM   1897  CB  ASP A 264     -28.333  70.433  52.858  1.00 57.26           C  
ATOM   1898  CG  ASP A 264     -27.748  69.108  52.397  1.00 64.97           C  
ATOM   1899  OD1 ASP A 264     -26.618  68.774  52.813  1.00 66.48           O  
ATOM   1900  OD2 ASP A 264     -28.424  68.398  51.622  1.00 69.99           O  
ATOM   1901  N   PHE A 265     -25.395  71.897  51.331  1.00 48.78           N  
ATOM   1902  CA  PHE A 265     -24.673  71.976  50.068  1.00 47.20           C  
ATOM   1903  C   PHE A 265     -24.060  70.645  49.649  1.00 52.52           C  
ATOM   1904  O   PHE A 265     -23.746  70.448  48.471  1.00 50.02           O  
ATOM   1905  CB  PHE A 265     -23.588  73.054  50.160  1.00 37.61           C  
ATOM   1906  CG  PHE A 265     -24.129  74.428  50.431  1.00 28.87           C  
ATOM   1907  CD1 PHE A 265     -25.039  75.015  49.555  1.00 29.25           C  
ATOM   1908  CD2 PHE A 265     -23.756  75.125  51.574  1.00 24.20           C  
ATOM   1909  CE1 PHE A 265     -25.573  76.278  49.815  1.00 23.11           C  
ATOM   1910  CE2 PHE A 265     -24.283  76.386  51.845  1.00 23.18           C  
ATOM   1911  CZ  PHE A 265     -25.194  76.965  50.965  1.00 27.47           C  
ATOM   1912  N   SER A 266     -23.893  69.737  50.608  1.00 56.33           N  
ATOM   1913  CA  SER A 266     -23.327  68.420  50.329  1.00 59.05           C  
ATOM   1914  C   SER A 266     -24.138  67.774  49.220  1.00 61.84           C  
ATOM   1915  O   SER A 266     -23.633  66.960  48.441  1.00 58.98           O  
ATOM   1916  CB  SER A 266     -23.377  67.547  51.587  1.00 60.31           C  
ATOM   1917  OG  SER A 266     -22.854  66.257  51.324  1.00 66.60           O  
ATOM   1918  N   GLN A 267     -25.409  68.148  49.154  1.00 64.46           N  
ATOM   1919  CA  GLN A 267     -26.316  67.633  48.142  1.00 67.98           C  
ATOM   1920  C   GLN A 267     -25.774  67.906  46.733  1.00 70.40           C  
ATOM   1921  O   GLN A 267     -26.054  67.156  45.799  1.00 70.00           O  
ATOM   1922  CB  GLN A 267     -27.688  68.290  48.317  1.00 71.32           C  
ATOM   1923  CG  GLN A 267     -28.693  67.966  47.229  1.00 81.91           C  
ATOM   1924  CD  GLN A 267     -30.055  68.563  47.516  1.00 87.30           C  
ATOM   1925  OE1 GLN A 267     -30.202  69.388  48.418  1.00 86.11           O  
ATOM   1926  NE2 GLN A 267     -31.059  68.156  46.745  1.00 92.41           N  
ATOM   1927  N   PHE A 268     -24.977  68.970  46.606  1.00 70.10           N  
ATOM   1928  CA  PHE A 268     -24.392  69.395  45.339  1.00 69.18           C  
ATOM   1929  C   PHE A 268     -22.943  68.872  45.162  1.00 71.97           C  
ATOM   1930  O   PHE A 268     -22.358  68.336  46.112  1.00 70.73           O  
ATOM   1931  CB  PHE A 268     -24.470  70.915  45.267  1.00 63.56           C  
ATOM   1932  CG  PHE A 268     -25.881  71.432  45.403  1.00 56.76           C  
ATOM   1933  CD1 PHE A 268     -26.785  71.304  44.345  1.00 55.59           C  
ATOM   1934  CD2 PHE A 268     -26.338  71.979  46.599  1.00 54.80           C  
ATOM   1935  CE1 PHE A 268     -28.108  71.704  44.477  1.00 51.43           C  
ATOM   1936  CE2 PHE A 268     -27.659  72.383  46.747  1.00 50.19           C  
ATOM   1937  CZ  PHE A 268     -28.550  72.242  45.682  1.00 51.71           C  
ATOM   1938  N   PRO A 269     -22.346  69.026  43.957  1.00 77.77           N  
ATOM   1939  CA  PRO A 269     -20.973  68.571  43.669  1.00 79.46           C  
ATOM   1940  C   PRO A 269     -19.865  69.626  43.607  1.00 79.72           C  
ATOM   1941  O   PRO A 269     -20.108  70.840  43.467  1.00 80.38           O  
ATOM   1942  CB  PRO A 269     -21.145  67.871  42.326  1.00 80.01           C  
ATOM   1943  CG  PRO A 269     -22.066  68.834  41.628  1.00 78.05           C  
ATOM   1944  CD  PRO A 269     -23.068  69.291  42.704  1.00 78.48           C  
ATOM   1945  N   ARG A 270     -18.628  69.115  43.663  1.00 79.64           N  
ATOM   1946  CA  ARG A 270     -17.367  69.869  43.618  1.00 79.89           C  
ATOM   1947  C   ARG A 270     -16.707  69.568  42.273  1.00 81.89           C  
ATOM   1948  O   ARG A 270     -17.348  68.977  41.414  1.00 81.01           O  
ATOM   1949  CB  ARG A 270     -16.466  69.392  44.752  1.00 76.16           C  
ATOM   1950  CG  ARG A 270     -17.043  69.633  46.126  1.00 72.44           C  
ATOM   1951  CD  ARG A 270     -15.999  69.479  47.208  1.00 74.30           C  
ATOM   1952  NE  ARG A 270     -16.358  70.285  48.369  1.00 77.12           N  
ATOM   1953  CZ  ARG A 270     -16.666  69.789  49.562  1.00 81.41           C  
ATOM   1954  NH1 ARG A 270     -16.655  68.479  49.762  1.00 82.47           N  
ATOM   1955  NH2 ARG A 270     -16.999  70.606  50.552  1.00 79.47           N  
ATOM   1956  N   PHE A 271     -15.437  69.947  42.062  1.00 79.67           N  
ATOM   1957  CA  PHE A 271     -14.823  69.627  40.775  1.00 81.75           C  
ATOM   1958  C   PHE A 271     -13.298  69.762  40.633  1.00 82.70           C  
ATOM   1959  O   PHE A 271     -12.773  70.840  40.321  1.00 81.98           O  
ATOM   1960  CB  PHE A 271     -15.511  70.451  39.672  1.00 83.91           C  
ATOM   1961  CG  PHE A 271     -15.556  69.766  38.325  1.00 90.11           C  
ATOM   1962  CD1 PHE A 271     -14.696  70.152  37.302  1.00 94.14           C  
ATOM   1963  CD2 PHE A 271     -16.501  68.774  38.060  1.00 93.69           C  
ATOM   1964  CE1 PHE A 271     -14.776  69.570  36.013  1.00 94.97           C  
ATOM   1965  CE2 PHE A 271     -16.591  68.183  36.775  1.00 96.58           C  
ATOM   1966  CZ  PHE A 271     -15.724  68.589  35.756  1.00 96.10           C  
ATOM   1967  N   PRO A 272     -12.558  68.656  40.841  1.00 88.78           N  
ATOM   1968  CA  PRO A 272     -11.106  68.780  40.704  1.00 89.11           C  
ATOM   1969  C   PRO A 272     -10.666  68.922  39.254  1.00 93.09           C  
ATOM   1970  O   PRO A 272      -9.792  68.110  38.856  1.00 97.37           O  
ATOM   1971  CB  PRO A 272     -10.595  67.485  41.326  1.00 86.13           C  
ATOM   1972  CG  PRO A 272     -11.683  66.489  40.958  1.00 86.15           C  
ATOM   1973  CD  PRO A 272     -12.940  67.297  41.268  1.00 87.31           C  
ATOM   1974  OXT PRO A 272     -11.186  69.823  38.550  1.00 99.38           O  
TER    1975      PRO A 272                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
