
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  704 ( 5864),  selected  704 , name 2f8s_A
# Molecule2: number of CA atoms  164 ( 1308),  selected  164 , name T0487_13_176.pdb
# PARAMETERS: 2f8s_A.T0487_13_176.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     3_A      -       -           -
LGA    E     4_A      -       -           -
LGA    A     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    L     7_A      -       -           -
LGA    N     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    Y    10_A      R      13          1.547
LGA    R    11_A      F      14          5.554
LGA    I    12_A      A      15          5.105
LGA    E    13_A      L      16           #
LGA    Y    14_A      R      17           #
LGA    R    15_A      P      18          3.361
LGA    P    16_A      L      19          2.793
LGA    K    17_A      N      20          2.560
LGA    -       -      P      21           -
LGA    D    18_A      E      22          2.408
LGA    T    19_A      E      23          3.853
LGA    -       -      L      24           -
LGA    T    20_A      R      25          3.698
LGA    F    21_A      P      26          2.333
LGA    T    22_A      W      27          1.710
LGA    V    23_A      R      28          0.842
LGA    F    24_A      L      29          0.662
LGA    K    25_A      E      30          1.227
LGA    P    26_A      V      31          2.004
LGA    T    27_A      V      32          2.737
LGA    H    28_A      L      33           #
LGA    E    29_A      D      34           #
LGA    I    30_A      P      35           -
LGA    -       -      P      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    -       -      R      39           -
LGA    Q    31_A      E      40          4.586
LGA    -       -      E      41           -
LGA    -       -      V      42           -
LGA    K    32_A      Y      43          2.826
LGA    E    33_A      P      44          2.319
LGA    K    34_A      L      45          1.591
LGA    L    35_A      L      46          2.838
LGA    N    36_A      A      47          1.884
LGA    K    37_A      Q      48          1.224
LGA    V    38_A      V      49          1.634
LGA    R    39_A      A      50          1.774
LGA    W    40_A      R      51          1.805
LGA    R    41_A      R      52          1.857
LGA    V    42_A      A      53          2.501
LGA    F    43_A      G      54          2.647
LGA    L    44_A      -       -           -
LGA    Q    45_A      -       -           -
LGA    T    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    L    48_A      G      55          3.181
LGA    P    49_A      V      56          1.445
LGA    T    50_A      T      57          1.934
LGA    F    51_A      V      58          2.645
LGA    R    52_A      R      59          2.157
LGA    R    53_A      M      60          2.011
LGA    E    54_A      G      61          1.148
LGA    D    55_A      D      62          1.146
LGA    E    56_A      G      63          2.196
LGA    F    57_A      L      64          1.032
LGA    W    58_A      A      65          0.933
LGA    C    59_A      S      66          1.119
LGA    A    60_A      W      67          0.940
LGA    G    61_A      S      68          3.679
LGA    K    62_A      P      69          3.873
LGA    V    63_A      P      70          1.959
LGA    E    64_A      E      71           #
LGA    -       -      V      72           -
LGA    K    65_A      L      73           #
LGA    D    66_A      -       -           -
LGA    T    67_A      -       -           -
LGA    L    68_A      V      74           #
LGA    -       -      L      75           -
LGA    Y    69_A      E      76          1.443
LGA    L    70_A      G      77          2.709
LGA    T    71_A      T      78          1.128
LGA    L    72_A      L      79          1.253
LGA    S    73_A      A      80          3.473
LGA    N    74_A      R      81           #
LGA    -       -      M      82           -
LGA    -       -      G      83           -
LGA    -       -      Q      84           -
LGA    G    75_A      T      85          4.591
LGA    E    76_A      Y      86          1.782
LGA    I    77_A      A      87          0.819
LGA    V    78_A      Y      88          1.739
LGA    E    79_A      R      89          1.924
LGA    L    80_A      L      90          2.271
LGA    K    81_A      Y      91          1.728
LGA    R    82_A      P      92          1.821
LGA    V    83_A      K      93          1.695
LGA    G    84_A      G      94          1.519
LGA    E    85_A      R      95          1.777
LGA    E    86_A      R      96          1.839
LGA    E    87_A      P      97          3.156
LGA    F    88_A      L      98          4.047
LGA    R    89_A      D      99          3.879
LGA    G    90_A      P     100          3.396
LGA    -       -      K     101           -
LGA    -       -      D     102           -
LGA    -       -      P     103           -
LGA    F    91_A      G     104           #
LGA    Q    92_A      E     105          2.255
LGA    N    93_A      R     106          4.207
LGA    E    94_A      S     107          3.771
LGA    R    95_A      V     108           #
LGA    E    96_A      L     109          4.599
LGA    C    97_A      S     110          0.655
LGA    Q    98_A      A     111          3.553
LGA    E    99_A      -       -           -
LGA    L   100_A      L     112          1.438
LGA    F   101_A      A     113          1.960
LGA    R   102_A      R     114          2.805
LGA    D   103_A      R     115          2.263
LGA    F   104_A      L     116          1.560
LGA    L   105_A      L     117          2.185
LGA    T   106_A      Q     118          3.271
LGA    K   107_A      E     119          3.205
LGA    T   108_A      R     120          2.657
LGA    K   109_A      L     121          3.620
LGA    V   110_A      -       -           -
LGA    K   111_A      R     122           #
LGA    -       -      R     123           -
LGA    D   112_A      L     124          3.139
LGA    K   113_A      E     125          4.168
LGA    F   114_A      G     126           #
LGA    I   115_A      -       -           -
LGA    S   116_A      V     127          2.811
LGA    D   117_A      W     128           -
LGA    -       -      V     129           -
LGA    -       -      E     130           -
LGA    -       -      G     131           -
LGA    -       -      L     132           -
LGA    -       -      A     133           -
LGA    -       -      V     134           -
LGA    -       -      Y     135           -
LGA    F   118_A      R     136          3.043
LGA    Y   119_A      R     137          3.415
LGA    K   120_A      -       -           -
LGA    K   121_A      -       -           -
LGA    F   122_A      E     138          4.259
LGA    R   123_A      -       -           -
LGA    D   124_A      -       -           -
LGA    K   125_A      H     139          3.913
LGA    I   126_A      A     140          2.611
LGA    T   127_A      R     141          1.241
LGA    V   128_A      G     142          3.396
LGA    Q   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    K   131_A      -       -           -
LGA    N   132_A      -       -           -
LGA    R   133_A      P     143          4.871
LGA    K   134_A      G     144          4.570
LGA    I   135_A      W     145          2.610
LGA    A   136_A      R     146          0.756
LGA    L   137_A      V     147          1.029
LGA    I   138_A      L     148          2.772
LGA    P   139_A      G     149          3.470
LGA    E   140_A      G     150          5.369
LGA    V   141_A      A     151          3.587
LGA    N   142_A      V     152          2.275
LGA    E   143_A      L     153          3.027
LGA    K   144_A      -       -           -
LGA    V   145_A      -       -           -
LGA    L   146_A      -       -           -
LGA    K   147_A      -       -           -
LGA    S   148_A      -       -           -
LGA    E   149_A      -       -           -
LGA    E   150_A      -       -           -
LGA    G   151_A      -       -           -
LGA    Y   152_A      -       -           -
LGA    F   153_A      -       -           -
LGA    L   154_A      -       -           -
LGA    L   155_A      D     154          4.438
LGA    H   156_A      L     155           -
LGA    -       -      W     156           -
LGA    -       -      V     157           -
LGA    -       -      S     158           -
LGA    -       -      D     159           -
LGA    -       -      S     160           -
LGA    -       -      G     161           -
LGA    -       -      A     162           -
LGA    -       -      F     163           -
LGA    -       -      L     164           -
LGA    -       -      L     165           -
LGA    -       -      E     166           -
LGA    L   157_A      V     167          2.789
LGA    D   158_A      D     168          2.648
LGA    L   159_A      P     169          2.897
LGA    K   160_A      A     170          2.028
LGA    F   161_A      Y     171          1.960
LGA    R   162_A      R     172          2.338
LGA    I   163_A      I     173          1.914
LGA    Q   164_A      L     174          3.055
LGA    P   165_A      C     175          3.043
LGA    F   166_A      E     176          2.760
LGA    E   167_A      -       -           -
LGA    T   168_A      -       -           -
LGA    L   169_A      -       -           -
LGA    Q   170_A      -       -           -
LGA    T   171_A      -       -           -
LGA    L   172_A      -       -           -
LGA    L   173_A      -       -           -
LGA    E   174_A      -       -           -
LGA    R   175_A      -       -           -
LGA    N   176_A      -       -           -
LGA    D   177_A      -       -           -
LGA    F   178_A      -       -           -
LGA    N   179_A      -       -           -
LGA    P   180_A      -       -           -
LGA    K   181_A      -       -           -
LGA    R   182_A      -       -           -
LGA    I   183_A      -       -           -
LGA    R   184_A      -       -           -
LGA    V   185_A      -       -           -
LGA    K   186_A      -       -           -
LGA    P   187_A      -       -           -
LGA    I   188_A      -       -           -
LGA    G   189_A      -       -           -
LGA    I   190_A      -       -           -
LGA    D   191_A      -       -           -
LGA    F   192_A      -       -           -
LGA    V   193_A      -       -           -
LGA    G   194_A      -       -           -
LGA    R   195_A      -       -           -
LGA    V   196_A      -       -           -
LGA    Q   197_A      -       -           -
LGA    D   198_A      -       -           -
LGA    V   199_A      -       -           -
LGA    F   200_A      -       -           -
LGA    K   201_A      -       -           -
LGA    A   202_A      -       -           -
LGA    K   203_A      -       -           -
LGA    E   204_A      -       -           -
LGA    K   205_A      -       -           -
LGA    G   206_A      -       -           -
LGA    E   207_A      -       -           -
LGA    E   208_A      -       -           -
LGA    F   209_A      -       -           -
LGA    F   210_A      -       -           -
LGA    R   211_A      -       -           -
LGA    L   212_A      -       -           -
LGA    C   213_A      -       -           -
LGA    M   214_A      -       -           -
LGA    E   215_A      -       -           -
LGA    R   216_A      -       -           -
LGA    S   217_A      -       -           -
LGA    T   218_A      -       -           -
LGA    H   219_A      -       -           -
LGA    K   220_A      -       -           -
LGA    S   221_A      -       -           -
LGA    S   222_A      -       -           -
LGA    K   223_A      -       -           -
LGA    K   224_A      -       -           -
LGA    A   225_A      -       -           -
LGA    W   226_A      -       -           -
LGA    E   227_A      -       -           -
LGA    E   228_A      -       -           -
LGA    L   229_A      -       -           -
LGA    L   230_A      -       -           -
LGA    K   231_A      -       -           -
LGA    N   232_A      -       -           -
LGA    R   233_A      -       -           -
LGA    E   234_A      -       -           -
LGA    L   235_A      -       -           -
LGA    R   236_A      -       -           -
LGA    E   237_A      -       -           -
LGA    K   238_A      -       -           -
LGA    A   239_A      -       -           -
LGA    F   240_A      -       -           -
LGA    L   241_A      -       -           -
LGA    V   242_A      -       -           -
LGA    V   243_A      -       -           -
LGA    L   244_A      -       -           -
LGA    E   245_A      -       -           -
LGA    K   246_A      -       -           -
LGA    G   247_A      -       -           -
LGA    Y   248_A      -       -           -
LGA    T   249_A      -       -           -
LGA    Y   250_A      -       -           -
LGA    P   251_A      -       -           -
LGA    A   252_A      -       -           -
LGA    T   253_A      -       -           -
LGA    I   254_A      -       -           -
LGA    L   255_A      -       -           -
LGA    K   256_A      -       -           -
LGA    P   257_A      -       -           -
LGA    V   258_A      -       -           -
LGA    L   259_A      -       -           -
LGA    T   260_A      -       -           -
LGA    Y   261_A      -       -           -
LGA    E   262_A      -       -           -
LGA    N   263_A      -       -           -
LGA    L   264_A      -       -           -
LGA    E   265_A      -       -           -
LGA    D   266_A      -       -           -
LGA    E   267_A      -       -           -
LGA    E   268_A      -       -           -
LGA    R   269_A      -       -           -
LGA    N   270_A      -       -           -
LGA    E   271_A      -       -           -
LGA    V   272_A      -       -           -
LGA    A   273_A      -       -           -
LGA    D   274_A      -       -           -
LGA    I   275_A      -       -           -
LGA    V   276_A      -       -           -
LGA    R   277_A      -       -           -
LGA    M   278_A      -       -           -
LGA    E   279_A      -       -           -
LGA    P   280_A      -       -           -
LGA    G   281_A      -       -           -
LGA    K   282_A      -       -           -
LGA    R   283_A      -       -           -
LGA    L   284_A      -       -           -
LGA    N   285_A      -       -           -
LGA    L   286_A      -       -           -
LGA    I   287_A      -       -           -
LGA    R   288_A      -       -           -
LGA    Y   289_A      -       -           -
LGA    I   290_A      -       -           -
LGA    L   291_A      -       -           -
LGA    R   292_A      -       -           -
LGA    R   293_A      -       -           -
LGA    Y   294_A      -       -           -
LGA    V   295_A      -       -           -
LGA    K   296_A      -       -           -
LGA    A   297_A      -       -           -
LGA    L   298_A      -       -           -
LGA    R   299_A      -       -           -
LGA    D   300_A      -       -           -
LGA    Y   301_A      -       -           -
LGA    G   302_A      -       -           -
LGA    W   303_A      -       -           -
LGA    Y   304_A      -       -           -
LGA    I   305_A      -       -           -
LGA    S   306_A      -       -           -
LGA    P   307_A      -       -           -
LGA    E   308_A      -       -           -
LGA    E   309_A      -       -           -
LGA    E   310_A      -       -           -
LGA    R   311_A      -       -           -
LGA    A   312_A      -       -           -
LGA    K   313_A      -       -           -
LGA    G   314_A      -       -           -
LGA    K   315_A      -       -           -
LGA    L   316_A      -       -           -
LGA    N   317_A      -       -           -
LGA    F   318_A      -       -           -
LGA    K   319_A      -       -           -
LGA    D   320_A      -       -           -
LGA    T   321_A      -       -           -
LGA    V   322_A      -       -           -
LGA    L   323_A      -       -           -
LGA    D   324_A      -       -           -
LGA    A   325_A      -       -           -
LGA    K   326_A      -       -           -
LGA    G   327_A      -       -           -
LGA    K   328_A      -       -           -
LGA    N   329_A      -       -           -
LGA    T   330_A      -       -           -
LGA    K   331_A      -       -           -
LGA    V   332_A      -       -           -
LGA    I   333_A      -       -           -
LGA    T   334_A      -       -           -
LGA    N   335_A      -       -           -
LGA    L   336_A      -       -           -
LGA    R   337_A      -       -           -
LGA    K   338_A      -       -           -
LGA    F   339_A      -       -           -
LGA    L   340_A      -       -           -
LGA    E   341_A      -       -           -
LGA    L   342_A      -       -           -
LGA    C   343_A      -       -           -
LGA    R   344_A      -       -           -
LGA    P   345_A      -       -           -
LGA    F   346_A      -       -           -
LGA    V   347_A      -       -           -
LGA    K   348_A      -       -           -
LGA    K   349_A      -       -           -
LGA    D   350_A      -       -           -
LGA    V   351_A      -       -           -
LGA    L   352_A      -       -           -
LGA    S   353_A      -       -           -
LGA    V   354_A      -       -           -
LGA    E   355_A      -       -           -
LGA    I   356_A      -       -           -
LGA    I   357_A      -       -           -
LGA    S   358_A      -       -           -
LGA    V   359_A      -       -           -
LGA    S   360_A      -       -           -
LGA    V   361_A      -       -           -
LGA    Y   362_A      -       -           -
LGA    K   363_A      -       -           -
LGA    K   364_A      -       -           -
LGA    L   365_A      -       -           -
LGA    E   366_A      -       -           -
LGA    W   367_A      -       -           -
LGA    R   368_A      -       -           -
LGA    K   369_A      -       -           -
LGA    E   370_A      -       -           -
LGA    E   371_A      -       -           -
LGA    F   372_A      -       -           -
LGA    L   373_A      -       -           -
LGA    K   374_A      -       -           -
LGA    E   375_A      -       -           -
LGA    L   376_A      -       -           -
LGA    I   377_A      -       -           -
LGA    N   378_A      -       -           -
LGA    F   379_A      -       -           -
LGA    L   380_A      -       -           -
LGA    K   381_A      -       -           -
LGA    N   382_A      -       -           -
LGA    K   383_A      -       -           -
LGA    G   384_A      -       -           -
LGA    I   385_A      -       -           -
LGA    K   386_A      -       -           -
LGA    L   387_A      -       -           -
LGA    K   388_A      -       -           -
LGA    I   389_A      -       -           -
LGA    K   390_A      -       -           -
LGA    G   391_A      -       -           -
LGA    K   392_A      -       -           -
LGA    S   393_A      -       -           -
LGA    L   394_A      -       -           -
LGA    I   395_A      -       -           -
LGA    L   396_A      -       -           -
LGA    A   397_A      -       -           -
LGA    Q   398_A      -       -           -
LGA    T   399_A      -       -           -
LGA    R   400_A      -       -           -
LGA    E   401_A      -       -           -
LGA    E   402_A      -       -           -
LGA    A   403_A      -       -           -
LGA    K   404_A      -       -           -
LGA    E   405_A      -       -           -
LGA    K   406_A      -       -           -
LGA    L   407_A      -       -           -
LGA    I   408_A      -       -           -
LGA    P   409_A      -       -           -
LGA    V   410_A      -       -           -
LGA    I   411_A      -       -           -
LGA    N   412_A      -       -           -
LGA    K   413_A      -       -           -
LGA    I   414_A      -       -           -
LGA    K   415_A      -       -           -
LGA    D   416_A      -       -           -
LGA    V   417_A      -       -           -
LGA    D   418_A      -       -           -
LGA    L   419_A      -       -           -
LGA    V   420_A      -       -           -
LGA    I   421_A      -       -           -
LGA    V   422_A      -       -           -
LGA    F   423_A      -       -           -
LGA    L   424_A      -       -           -
LGA    E   425_A      -       -           -
LGA    E   426_A      -       -           -
LGA    Y   427_A      -       -           -
LGA    P   428_A      -       -           -
LGA    K   429_A      -       -           -
LGA    V   430_A      -       -           -
LGA    D   431_A      -       -           -
LGA    P   432_A      -       -           -
LGA    Y   433_A      -       -           -
LGA    K   434_A      -       -           -
LGA    S   435_A      -       -           -
LGA    F   436_A      -       -           -
LGA    L   437_A      -       -           -
LGA    L   438_A      -       -           -
LGA    Y   439_A      -       -           -
LGA    D   440_A      -       -           -
LGA    F   441_A      -       -           -
LGA    V   442_A      -       -           -
LGA    K   443_A      -       -           -
LGA    R   444_A      -       -           -
LGA    E   445_A      -       -           -
LGA    L   446_A      -       -           -
LGA    L   447_A      -       -           -
LGA    K   448_A      -       -           -
LGA    K   449_A      -       -           -
LGA    M   450_A      -       -           -
LGA    I   451_A      -       -           -
LGA    P   452_A      -       -           -
LGA    S   453_A      -       -           -
LGA    Q   454_A      -       -           -
LGA    V   455_A      -       -           -
LGA    I   456_A      -       -           -
LGA    L   457_A      -       -           -
LGA    N   458_A      -       -           -
LGA    R   459_A      -       -           -
LGA    T   460_A      -       -           -
LGA    L   461_A      -       -           -
LGA    K   462_A      -       -           -
LGA    N   463_A      -       -           -
LGA    E   464_A      -       -           -
LGA    N   465_A      -       -           -
LGA    L   466_A      -       -           -
LGA    K   467_A      -       -           -
LGA    F   468_A      -       -           -
LGA    V   469_A      -       -           -
LGA    L   470_A      -       -           -
LGA    L   471_A      -       -           -
LGA    N   472_A      -       -           -
LGA    V   473_A      -       -           -
LGA    A   474_A      -       -           -
LGA    E   475_A      -       -           -
LGA    Q   476_A      -       -           -
LGA    V   477_A      -       -           -
LGA    L   478_A      -       -           -
LGA    A   479_A      -       -           -
LGA    K   480_A      -       -           -
LGA    T   481_A      -       -           -
LGA    G   482_A      -       -           -
LGA    N   483_A      -       -           -
LGA    I   484_A      -       -           -
LGA    P   485_A      -       -           -
LGA    Y   486_A      -       -           -
LGA    K   487_A      -       -           -
LGA    L   488_A      -       -           -
LGA    K   489_A      -       -           -
LGA    E   490_A      -       -           -
LGA    I   491_A      -       -           -
LGA    E   492_A      -       -           -
LGA    G   493_A      -       -           -
LGA    K   494_A      -       -           -
LGA    V   495_A      -       -           -
LGA    D   496_A      -       -           -
LGA    A   497_A      -       -           -
LGA    F   498_A      -       -           -
LGA    V   499_A      -       -           -
LGA    G   500_A      -       -           -
LGA    I   501_A      -       -           -
LGA    D   502_A      -       -           -
LGA    I   503_A      -       -           -
LGA    S   504_A      -       -           -
LGA    R   505_A      -       -           -
LGA    I   506_A      -       -           -
LGA    T   507_A      -       -           -
LGA    R   508_A      -       -           -
LGA    D   509_A      -       -           -
LGA    G   510_A      -       -           -
LGA    K   511_A      -       -           -
LGA    T   512_A      -       -           -
LGA    V   513_A      -       -           -
LGA    N   514_A      -       -           -
LGA    A   515_A      -       -           -
LGA    V   516_A      -       -           -
LGA    A   517_A      -       -           -
LGA    F   518_A      -       -           -
LGA    T   519_A      -       -           -
LGA    K   520_A      -       -           -
LGA    I   521_A      -       -           -
LGA    F   522_A      -       -           -
LGA    N   523_A      -       -           -
LGA    S   524_A      -       -           -
LGA    K   525_A      -       -           -
LGA    G   526_A      -       -           -
LGA    E   527_A      -       -           -
LGA    L   528_A      -       -           -
LGA    V   529_A      -       -           -
LGA    R   530_A      -       -           -
LGA    Y   531_A      -       -           -
LGA    Y   532_A      -       -           -
LGA    L   533_A      -       -           -
LGA    T   534_A      -       -           -
LGA    S   535_A      -       -           -
LGA    Y   536_A      -       -           -
LGA    P   537_A      -       -           -
LGA    A   538_A      -       -           -
LGA    F   539_A      -       -           -
LGA    G   540_A      -       -           -
LGA    E   541_A      -       -           -
LGA    K   542_A      -       -           -
LGA    L   543_A      -       -           -
LGA    T   544_A      -       -           -
LGA    E   545_A      -       -           -
LGA    K   546_A      -       -           -
LGA    A   547_A      -       -           -
LGA    I   548_A      -       -           -
LGA    G   549_A      -       -           -
LGA    D   550_A      -       -           -
LGA    V   551_A      -       -           -
LGA    F   552_A      -       -           -
LGA    S   553_A      -       -           -
LGA    L   554_A      -       -           -
LGA    L   555_A      -       -           -
LGA    E   556_A      -       -           -
LGA    K   557_A      -       -           -
LGA    L   558_A      -       -           -
LGA    G   559_A      -       -           -
LGA    F   560_A      -       -           -
LGA    K   561_A      -       -           -
LGA    K   562_A      -       -           -
LGA    G   563_A      -       -           -
LGA    S   564_A      -       -           -
LGA    K   565_A      -       -           -
LGA    I   566_A      -       -           -
LGA    V   567_A      -       -           -
LGA    V   568_A      -       -           -
LGA    H   569_A      -       -           -
LGA    R   570_A      -       -           -
LGA    D   571_A      -       -           -
LGA    G   572_A      -       -           -
LGA    R   573_A      -       -           -
LGA    L   574_A      -       -           -
LGA    Y   575_A      -       -           -
LGA    R   576_A      -       -           -
LGA    D   577_A      -       -           -
LGA    E   578_A      -       -           -
LGA    V   579_A      -       -           -
LGA    A   580_A      -       -           -
LGA    A   581_A      -       -           -
LGA    F   582_A      -       -           -
LGA    K   583_A      -       -           -
LGA    K   584_A      -       -           -
LGA    Y   585_A      -       -           -
LGA    G   586_A      -       -           -
LGA    E   587_A      -       -           -
LGA    L   588_A      -       -           -
LGA    Y   589_A      -       -           -
LGA    G   590_A      -       -           -
LGA    Y   591_A      -       -           -
LGA    S   592_A      -       -           -
LGA    L   593_A      -       -           -
LGA    E   594_A      -       -           -
LGA    L   595_A      -       -           -
LGA    L   596_A      -       -           -
LGA    E   597_A      -       -           -
LGA    I   598_A      -       -           -
LGA    I   599_A      -       -           -
LGA    K   600_A      -       -           -
LGA    R   601_A      -       -           -
LGA    N   602_A      -       -           -
LGA    N   603_A      -       -           -
LGA    P   604_A      -       -           -
LGA    R   605_A      -       -           -
LGA    F   606_A      -       -           -
LGA    F   607_A      -       -           -
LGA    S   608_A      -       -           -
LGA    N   609_A      -       -           -
LGA    E   610_A      -       -           -
LGA    K   611_A      -       -           -
LGA    F   612_A      -       -           -
LGA    I   613_A      -       -           -
LGA    K   614_A      -       -           -
LGA    G   615_A      -       -           -
LGA    Y   616_A      -       -           -
LGA    F   617_A      -       -           -
LGA    Y   618_A      -       -           -
LGA    K   619_A      -       -           -
LGA    L   620_A      -       -           -
LGA    S   621_A      -       -           -
LGA    E   622_A      -       -           -
LGA    D   623_A      -       -           -
LGA    S   624_A      -       -           -
LGA    V   625_A      -       -           -
LGA    I   626_A      -       -           -
LGA    L   627_A      -       -           -
LGA    A   628_A      -       -           -
LGA    T   629_A      -       -           -
LGA    Y   630_A      -       -           -
LGA    N   631_A      -       -           -
LGA    Q   632_A      -       -           -
LGA    V   633_A      -       -           -
LGA    Y   634_A      -       -           -
LGA    E   635_A      -       -           -
LGA    G   636_A      -       -           -
LGA    T   637_A      -       -           -
LGA    H   638_A      -       -           -
LGA    Q   639_A      -       -           -
LGA    P   640_A      -       -           -
LGA    I   641_A      -       -           -
LGA    K   642_A      -       -           -
LGA    V   643_A      -       -           -
LGA    R   644_A      -       -           -
LGA    K   645_A      -       -           -
LGA    V   646_A      -       -           -
LGA    Y   647_A      -       -           -
LGA    G   648_A      -       -           -
LGA    E   649_A      -       -           -
LGA    L   650_A      -       -           -
LGA    P   651_A      -       -           -
LGA    V   652_A      -       -           -
LGA    E   653_A      -       -           -
LGA    V   654_A      -       -           -
LGA    L   655_A      -       -           -
LGA    C   656_A      -       -           -
LGA    S   657_A      -       -           -
LGA    Q   658_A      -       -           -
LGA    I   659_A      -       -           -
LGA    L   660_A      -       -           -
LGA    S   661_A      -       -           -
LGA    L   662_A      -       -           -
LGA    T   663_A      -       -           -
LGA    L   664_A      -       -           -
LGA    M   665_A      -       -           -
LGA    N   666_A      -       -           -
LGA    Y   667_A      -       -           -
LGA    S   668_A      -       -           -
LGA    S   669_A      -       -           -
LGA    F   670_A      -       -           -
LGA    Q   671_A      -       -           -
LGA    P   672_A      -       -           -
LGA    I   673_A      -       -           -
LGA    K   674_A      -       -           -
LGA    L   675_A      -       -           -
LGA    P   676_A      -       -           -
LGA    A   677_A      -       -           -
LGA    T   678_A      -       -           -
LGA    V   679_A      -       -           -
LGA    H   680_A      -       -           -
LGA    Y   681_A      -       -           -
LGA    S   682_A      -       -           -
LGA    D   683_A      -       -           -
LGA    K   684_A      -       -           -
LGA    I   685_A      -       -           -
LGA    T   686_A      -       -           -
LGA    K   687_A      -       -           -
LGA    L   688_A      -       -           -
LGA    M   689_A      -       -           -
LGA    L   690_A      -       -           -
LGA    R   691_A      -       -           -
LGA    G   692_A      -       -           -
LGA    I   693_A      -       -           -
LGA    E   694_A      -       -           -
LGA    P   695_A      -       -           -
LGA    I   696_A      -       -           -
LGA    K   697_A      -       -           -
LGA    K   698_A      -       -           -
LGA    E   699_A      -       -           -
LGA    G   700_A      -       -           -
LGA    D   701_A      -       -           -
LGA    I   702_A      -       -           -
LGA    M   703_A      -       -           -
LGA    Y   704_A      -       -           -
LGA    W   705_A      -       -           -
LGA    L   706_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  704  164    5.0    114    2.79    14.04     40.867     3.943

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.792759 * X  +   0.435293 * Y  +  -0.426677 * Z  +  28.835032
  Y_new =   0.599933 * X  +   0.680984 * Y  +  -0.419930 * Z  +  39.456947
  Z_new =   0.107767 * X  +  -0.588881 * Y  +  -0.801003 * Z  +  57.194378 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.507645    0.633948  [ DEG:  -143.6775     36.3225 ]
  Theta =  -0.107977   -3.033616  [ DEG:    -6.1866   -173.8134 ]
  Phi   =   2.493775   -0.647817  [ DEG:   142.8828    -37.1172 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f8s_A                                        
REMARK     2: T0487_13_176.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f8s_A.T0487_13_176.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  704  164   5.0  114   2.79   14.04  40.867
REMARK  ---------------------------------------------------------- 
MOLECULE 2f8s_A
HEADER    RNA BINDING PROTEIN/RNA                 03-DEC-05   2F8S              
TITLE     CRYSTAL STRUCTURE OF AA-AGO WITH EXTERNALLY-BOUND SIRNA               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ARGONAUTE PROTEIN;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: 5'-                                                        
COMPND   7 R(P*AP*GP*AP*CP*AP*GP*CP*AP*UP*AP*UP*AP*UP*GP*CP*UP*GP*UP*C          
COMPND   8 P*UP*UP*U)-3';                                                       
COMPND   9 CHAIN: C, D;                                                         
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B;                                   
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 SYNTHETIC: YES                                                       
KEYWDS    ARGONAUTE, SIRNA, RISC LOADING COMPLEX                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.R.YUAN,H.Y.CHEN,D.J.PATEL                                           
REVDAT   1   31-OCT-06 2F8S    0                                                
JRNL        AUTH   Y.R.YUAN,Y.PEI,H.Y.CHEN,T.TUSCHL,D.J.PATEL                   
JRNL        TITL   A POTENTIAL PROTEIN-RNA RECOGNITION EVENT ALONG              
JRNL        TITL 2 THE RISC-LOADING PATHWAY FROM THE STRUCTURE OF A.            
JRNL        TITL 3 AEOLICUS ARGONAUTE WITH EXTERNALLY BOUND SIRNA.              
JRNL        REF    STRUCTURE                     V.  14  1557 2006              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 3.00 ANGSTROMS.                                          
DBREF  2F8S A    1   706  UNP    O67434   O67434_AQUAE     1    706             
DBREF  2F8S B    1   706  UNP    O67434   O67434_AQUAE     1    706             
SEQRES   1 A  706  MET GLY LYS GLU ALA LEU LEU ASN LEU TYR ARG ILE GLU          
SEQRES   2 A  706  TYR ARG PRO LYS ASP THR THR PHE THR VAL PHE LYS PRO          
SEQRES   3 A  706  THR HIS GLU ILE GLN LYS GLU LYS LEU ASN LYS VAL ARG          
SEQRES   4 A  706  TRP ARG VAL PHE LEU GLN THR GLY LEU PRO THR PHE ARG          
SEQRES   5 A  706  ARG GLU ASP GLU PHE TRP CYS ALA GLY LYS VAL GLU LYS          
SEQRES   6 A  706  ASP THR LEU TYR LEU THR LEU SER ASN GLY GLU ILE VAL          
SEQRES   7 A  706  GLU LEU LYS ARG VAL GLY GLU GLU GLU PHE ARG GLY PHE          
SEQRES   8 A  706  GLN ASN GLU ARG GLU CYS GLN GLU LEU PHE ARG ASP PHE          
SEQRES   9 A  706  LEU THR LYS THR LYS VAL LYS ASP LYS PHE ILE SER ASP          
SEQRES  10 A  706  PHE TYR LYS LYS PHE ARG ASP LYS ILE THR VAL GLN GLY          
SEQRES  11 A  706  LYS ASN ARG LYS ILE ALA LEU ILE PRO GLU VAL ASN GLU          
SEQRES  12 A  706  LYS VAL LEU LYS SER GLU GLU GLY TYR PHE LEU LEU HIS          
SEQRES  13 A  706  LEU ASP LEU LYS PHE ARG ILE GLN PRO PHE GLU THR LEU          
SEQRES  14 A  706  GLN THR LEU LEU GLU ARG ASN ASP PHE ASN PRO LYS ARG          
SEQRES  15 A  706  ILE ARG VAL LYS PRO ILE GLY ILE ASP PHE VAL GLY ARG          
SEQRES  16 A  706  VAL GLN ASP VAL PHE LYS ALA LYS GLU LYS GLY GLU GLU          
SEQRES  17 A  706  PHE PHE ARG LEU CYS MET GLU ARG SER THR HIS LYS SER          
SEQRES  18 A  706  SER LYS LYS ALA TRP GLU GLU LEU LEU LYS ASN ARG GLU          
SEQRES  19 A  706  LEU ARG GLU LYS ALA PHE LEU VAL VAL LEU GLU LYS GLY          
SEQRES  20 A  706  TYR THR TYR PRO ALA THR ILE LEU LYS PRO VAL LEU THR          
SEQRES  21 A  706  TYR GLU ASN LEU GLU ASP GLU GLU ARG ASN GLU VAL ALA          
SEQRES  22 A  706  ASP ILE VAL ARG MET GLU PRO GLY LYS ARG LEU ASN LEU          
SEQRES  23 A  706  ILE ARG TYR ILE LEU ARG ARG TYR VAL LYS ALA LEU ARG          
SEQRES  24 A  706  ASP TYR GLY TRP TYR ILE SER PRO GLU GLU GLU ARG ALA          
SEQRES  25 A  706  LYS GLY LYS LEU ASN PHE LYS ASP THR VAL LEU ASP ALA          
SEQRES  26 A  706  LYS GLY LYS ASN THR LYS VAL ILE THR ASN LEU ARG LYS          
SEQRES  27 A  706  PHE LEU GLU LEU CYS ARG PRO PHE VAL LYS LYS ASP VAL          
SEQRES  28 A  706  LEU SER VAL GLU ILE ILE SER VAL SER VAL TYR LYS LYS          
SEQRES  29 A  706  LEU GLU TRP ARG LYS GLU GLU PHE LEU LYS GLU LEU ILE          
SEQRES  30 A  706  ASN PHE LEU LYS ASN LYS GLY ILE LYS LEU LYS ILE LYS          
SEQRES  31 A  706  GLY LYS SER LEU ILE LEU ALA GLN THR ARG GLU GLU ALA          
SEQRES  32 A  706  LYS GLU LYS LEU ILE PRO VAL ILE ASN LYS ILE LYS ASP          
SEQRES  33 A  706  VAL ASP LEU VAL ILE VAL PHE LEU GLU GLU TYR PRO LYS          
SEQRES  34 A  706  VAL ASP PRO TYR LYS SER PHE LEU LEU TYR ASP PHE VAL          
SEQRES  35 A  706  LYS ARG GLU LEU LEU LYS LYS MET ILE PRO SER GLN VAL          
SEQRES  36 A  706  ILE LEU ASN ARG THR LEU LYS ASN GLU ASN LEU LYS PHE          
SEQRES  37 A  706  VAL LEU LEU ASN VAL ALA GLU GLN VAL LEU ALA LYS THR          
SEQRES  38 A  706  GLY ASN ILE PRO TYR LYS LEU LYS GLU ILE GLU GLY LYS          
SEQRES  39 A  706  VAL ASP ALA PHE VAL GLY ILE ASP ILE SER ARG ILE THR          
SEQRES  40 A  706  ARG ASP GLY LYS THR VAL ASN ALA VAL ALA PHE THR LYS          
SEQRES  41 A  706  ILE PHE ASN SER LYS GLY GLU LEU VAL ARG TYR TYR LEU          
SEQRES  42 A  706  THR SER TYR PRO ALA PHE GLY GLU LYS LEU THR GLU LYS          
SEQRES  43 A  706  ALA ILE GLY ASP VAL PHE SER LEU LEU GLU LYS LEU GLY          
SEQRES  44 A  706  PHE LYS LYS GLY SER LYS ILE VAL VAL HIS ARG ASP GLY          
SEQRES  45 A  706  ARG LEU TYR ARG ASP GLU VAL ALA ALA PHE LYS LYS TYR          
SEQRES  46 A  706  GLY GLU LEU TYR GLY TYR SER LEU GLU LEU LEU GLU ILE          
SEQRES  47 A  706  ILE LYS ARG ASN ASN PRO ARG PHE PHE SER ASN GLU LYS          
SEQRES  48 A  706  PHE ILE LYS GLY TYR PHE TYR LYS LEU SER GLU ASP SER          
SEQRES  49 A  706  VAL ILE LEU ALA THR TYR ASN GLN VAL TYR GLU GLY THR          
SEQRES  50 A  706  HIS GLN PRO ILE LYS VAL ARG LYS VAL TYR GLY GLU LEU          
SEQRES  51 A  706  PRO VAL GLU VAL LEU CYS SER GLN ILE LEU SER LEU THR          
SEQRES  52 A  706  LEU MET ASN TYR SER SER PHE GLN PRO ILE LYS LEU PRO          
SEQRES  53 A  706  ALA THR VAL HIS TYR SER ASP LYS ILE THR LYS LEU MET          
SEQRES  54 A  706  LEU ARG GLY ILE GLU PRO ILE LYS LYS GLU GLY ASP ILE          
SEQRES  55 A  706  MET TYR TRP LEU                                              
SEQRES   1 B  706  MET GLY LYS GLU ALA LEU LEU ASN LEU TYR ARG ILE GLU          
SEQRES   2 B  706  TYR ARG PRO LYS ASP THR THR PHE THR VAL PHE LYS PRO          
SEQRES   3 B  706  THR HIS GLU ILE GLN LYS GLU LYS LEU ASN LYS VAL ARG          
SEQRES   4 B  706  TRP ARG VAL PHE LEU GLN THR GLY LEU PRO THR PHE ARG          
SEQRES   5 B  706  ARG GLU ASP GLU PHE TRP CYS ALA GLY LYS VAL GLU LYS          
SEQRES   6 B  706  ASP THR LEU TYR LEU THR LEU SER ASN GLY GLU ILE VAL          
SEQRES   7 B  706  GLU LEU LYS ARG VAL GLY GLU GLU GLU PHE ARG GLY PHE          
SEQRES   8 B  706  GLN ASN GLU ARG GLU CYS GLN GLU LEU PHE ARG ASP PHE          
SEQRES   9 B  706  LEU THR LYS THR LYS VAL LYS ASP LYS PHE ILE SER ASP          
SEQRES  10 B  706  PHE TYR LYS LYS PHE ARG ASP LYS ILE THR VAL GLN GLY          
SEQRES  11 B  706  LYS ASN ARG LYS ILE ALA LEU ILE PRO GLU VAL ASN GLU          
SEQRES  12 B  706  LYS VAL LEU LYS SER GLU GLU GLY TYR PHE LEU LEU HIS          
SEQRES  13 B  706  LEU ASP LEU LYS PHE ARG ILE GLN PRO PHE GLU THR LEU          
SEQRES  14 B  706  GLN THR LEU LEU GLU ARG ASN ASP PHE ASN PRO LYS ARG          
SEQRES  15 B  706  ILE ARG VAL LYS PRO ILE GLY ILE ASP PHE VAL GLY ARG          
SEQRES  16 B  706  VAL GLN ASP VAL PHE LYS ALA LYS GLU LYS GLY GLU GLU          
SEQRES  17 B  706  PHE PHE ARG LEU CYS MET GLU ARG SER THR HIS LYS SER          
SEQRES  18 B  706  SER LYS LYS ALA TRP GLU GLU LEU LEU LYS ASN ARG GLU          
SEQRES  19 B  706  LEU ARG GLU LYS ALA PHE LEU VAL VAL LEU GLU LYS GLY          
SEQRES  20 B  706  TYR THR TYR PRO ALA THR ILE LEU LYS PRO VAL LEU THR          
SEQRES  21 B  706  TYR GLU ASN LEU GLU ASP GLU GLU ARG ASN GLU VAL ALA          
SEQRES  22 B  706  ASP ILE VAL ARG MET GLU PRO GLY LYS ARG LEU ASN LEU          
SEQRES  23 B  706  ILE ARG TYR ILE LEU ARG ARG TYR VAL LYS ALA LEU ARG          
SEQRES  24 B  706  ASP TYR GLY TRP TYR ILE SER PRO GLU GLU GLU ARG ALA          
SEQRES  25 B  706  LYS GLY LYS LEU ASN PHE LYS ASP THR VAL LEU ASP ALA          
SEQRES  26 B  706  LYS GLY LYS ASN THR LYS VAL ILE THR ASN LEU ARG LYS          
SEQRES  27 B  706  PHE LEU GLU LEU CYS ARG PRO PHE VAL LYS LYS ASP VAL          
SEQRES  28 B  706  LEU SER VAL GLU ILE ILE SER VAL SER VAL TYR LYS LYS          
SEQRES  29 B  706  LEU GLU TRP ARG LYS GLU GLU PHE LEU LYS GLU LEU ILE          
SEQRES  30 B  706  ASN PHE LEU LYS ASN LYS GLY ILE LYS LEU LYS ILE LYS          
SEQRES  31 B  706  GLY LYS SER LEU ILE LEU ALA GLN THR ARG GLU GLU ALA          
SEQRES  32 B  706  LYS GLU LYS LEU ILE PRO VAL ILE ASN LYS ILE LYS ASP          
SEQRES  33 B  706  VAL ASP LEU VAL ILE VAL PHE LEU GLU GLU TYR PRO LYS          
SEQRES  34 B  706  VAL ASP PRO TYR LYS SER PHE LEU LEU TYR ASP PHE VAL          
SEQRES  35 B  706  LYS ARG GLU LEU LEU LYS LYS MET ILE PRO SER GLN VAL          
SEQRES  36 B  706  ILE LEU ASN ARG THR LEU LYS ASN GLU ASN LEU LYS PHE          
SEQRES  37 B  706  VAL LEU LEU ASN VAL ALA GLU GLN VAL LEU ALA LYS THR          
SEQRES  38 B  706  GLY ASN ILE PRO TYR LYS LEU LYS GLU ILE GLU GLY LYS          
SEQRES  39 B  706  VAL ASP ALA PHE VAL GLY ILE ASP ILE SER ARG ILE THR          
SEQRES  40 B  706  ARG ASP GLY LYS THR VAL ASN ALA VAL ALA PHE THR LYS          
SEQRES  41 B  706  ILE PHE ASN SER LYS GLY GLU LEU VAL ARG TYR TYR LEU          
SEQRES  42 B  706  THR SER TYR PRO ALA PHE GLY GLU LYS LEU THR GLU LYS          
SEQRES  43 B  706  ALA ILE GLY ASP VAL PHE SER LEU LEU GLU LYS LEU GLY          
SEQRES  44 B  706  PHE LYS LYS GLY SER LYS ILE VAL VAL HIS ARG ASP GLY          
SEQRES  45 B  706  ARG LEU TYR ARG ASP GLU VAL ALA ALA PHE LYS LYS TYR          
SEQRES  46 B  706  GLY GLU LEU TYR GLY TYR SER LEU GLU LEU LEU GLU ILE          
SEQRES  47 B  706  ILE LYS ARG ASN ASN PRO ARG PHE PHE SER ASN GLU LYS          
SEQRES  48 B  706  PHE ILE LYS GLY TYR PHE TYR LYS LEU SER GLU ASP SER          
SEQRES  49 B  706  VAL ILE LEU ALA THR TYR ASN GLN VAL TYR GLU GLY THR          
SEQRES  50 B  706  HIS GLN PRO ILE LYS VAL ARG LYS VAL TYR GLY GLU LEU          
SEQRES  51 B  706  PRO VAL GLU VAL LEU CYS SER GLN ILE LEU SER LEU THR          
SEQRES  52 B  706  LEU MET ASN TYR SER SER PHE GLN PRO ILE LYS LEU PRO          
SEQRES  53 B  706  ALA THR VAL HIS TYR SER ASP LYS ILE THR LYS LEU MET          
SEQRES  54 B  706  LEU ARG GLY ILE GLU PRO ILE LYS LYS GLU GLY ASP ILE          
SEQRES  55 B  706  MET TYR TRP LEU                                              
SEQRES   1 C   22    A   G   A   C   A   G   C   A   U   A   U   A   U          
SEQRES   2 C   22    G   C   U   G   U   C   U   U   U                          
SEQRES   1 D   22    A   G   A   C   A   G   C   A   U   A   U   A   U          
SEQRES   2 D   22    G   C   U   G   U   C   U   U   U                          
FORMUL   5  HOH   *30(H2 O)                                                     
CRYST1   79.697  117.516   98.620  90.00  99.12  90.00 P 1 21 1      4          
ATOM      1  N   LYS A   3      14.185   6.334  36.306  1.00 79.59           N  
ATOM      2  CA  LYS A   3      14.345   6.598  37.773  1.00 80.09           C  
ATOM      3  C   LYS A   3      15.596   5.923  38.410  1.00 80.14           C  
ATOM      4  O   LYS A   3      15.649   5.703  39.619  1.00 80.64           O  
ATOM      5  CB  LYS A   3      13.027   6.285  38.532  1.00 79.75           C  
ATOM      6  CG  LYS A   3      13.072   6.407  40.072  1.00 79.84           C  
ATOM      7  CD  LYS A   3      11.681   6.700  40.648  1.00 80.62           C  
ATOM      8  CE  LYS A   3      11.683   6.909  42.156  1.00 79.13           C  
ATOM      9  NZ  LYS A   3      10.429   7.599  42.487  1.00 76.10           N  
ATOM     10  N   GLU A   4      16.598   5.592  37.603  1.00 79.87           N  
ATOM     11  CA  GLU A   4      17.845   5.043  38.138  1.00 79.70           C  
ATOM     12  C   GLU A   4      18.910   6.073  37.871  1.00 77.61           C  
ATOM     13  O   GLU A   4      19.127   6.471  36.737  1.00 77.91           O  
ATOM     14  CB  GLU A   4      18.210   3.703  37.476  1.00 79.48           C  
ATOM     15  CG  GLU A   4      19.719   3.315  37.572  1.00 82.26           C  
ATOM     16  CD  GLU A   4      20.058   1.907  37.020  1.00 83.78           C  
ATOM     17  OE1 GLU A   4      19.106   1.135  36.688  1.00 92.07           O  
ATOM     18  OE2 GLU A   4      21.269   1.555  36.914  1.00 86.17           O  
ATOM     19  N   ALA A   5      19.576   6.528  38.907  1.00 75.74           N  
ATOM     20  CA  ALA A   5      20.569   7.530  38.675  1.00 73.95           C  
ATOM     21  C   ALA A   5      21.870   7.052  39.224  1.00 72.76           C  
ATOM     22  O   ALA A   5      21.971   6.680  40.377  1.00 71.97           O  
ATOM     23  CB  ALA A   5      20.162   8.850  39.292  1.00 74.22           C  
ATOM     24  N   LEU A   6      22.863   7.074  38.350  1.00 71.86           N  
ATOM     25  CA  LEU A   6      24.222   6.684  38.659  1.00 70.55           C  
ATOM     26  C   LEU A   6      25.047   7.902  38.975  1.00 69.74           C  
ATOM     27  O   LEU A   6      24.824   8.959  38.390  1.00 70.45           O  
ATOM     28  CB  LEU A   6      24.831   6.046  37.423  1.00 70.40           C  
ATOM     29  CG  LEU A   6      24.314   4.652  37.063  1.00 70.23           C  
ATOM     30  CD1 LEU A   6      25.471   3.850  36.511  1.00 70.43           C  
ATOM     31  CD2 LEU A   6      23.704   3.940  38.257  1.00 67.95           C  
ATOM     32  N   LEU A   7      26.015   7.760  39.874  1.00 67.94           N  
ATOM     33  CA  LEU A   7      26.999   8.805  40.078  1.00 66.32           C  
ATOM     34  C   LEU A   7      28.396   8.321  39.725  1.00 65.46           C  
ATOM     35  O   LEU A   7      28.717   7.140  39.906  1.00 65.01           O  
ATOM     36  CB  LEU A   7      26.947   9.318  41.510  1.00 66.29           C  
ATOM     37  CG  LEU A   7      25.598   9.960  41.867  1.00 67.45           C  
ATOM     38  CD1 LEU A   7      24.648   8.923  42.464  1.00 68.01           C  
ATOM     39  CD2 LEU A   7      25.772  11.136  42.815  1.00 65.61           C  
ATOM     40  N   ASN A   8      29.215   9.234  39.196  1.00 64.38           N  
ATOM     41  CA  ASN A   8      30.636   8.980  38.957  1.00 62.70           C  
ATOM     42  C   ASN A   8      31.451   8.819  40.257  1.00 62.37           C  
ATOM     43  O   ASN A   8      32.454   9.497  40.494  1.00 62.30           O  
ATOM     44  CB  ASN A   8      31.207  10.054  38.044  1.00 62.45           C  
ATOM     45  CG  ASN A   8      31.152  11.439  38.655  1.00 62.76           C  
ATOM     46  OD1 ASN A   8      30.146  11.825  39.250  1.00 63.69           O  
ATOM     47  ND2 ASN A   8      32.240  12.206  38.501  1.00 62.84           N  
ATOM     48  N   LEU A   9      31.004   7.893  41.099  1.00 61.98           N  
ATOM     49  CA  LEU A   9      31.602   7.639  42.398  1.00 61.39           C  
ATOM     50  C   LEU A   9      31.785   6.146  42.466  1.00 61.71           C  
ATOM     51  O   LEU A   9      30.813   5.431  42.253  1.00 62.69           O  
ATOM     52  CB  LEU A   9      30.649   8.079  43.523  1.00 60.94           C  
ATOM     53  CG  LEU A   9      30.734   9.518  44.051  1.00 58.98           C  
ATOM     54  CD1 LEU A   9      29.549   9.914  44.893  1.00 55.72           C  
ATOM     55  CD2 LEU A   9      31.997   9.687  44.835  1.00 58.26           C  
ATOM     56  N   TYR A  10      33.007   5.685  42.757  1.00 61.38           N  
ATOM     57  CA  TYR A  10      33.363   4.274  42.720  1.00 61.36           C  
ATOM     58  C   TYR A  10      34.010   3.812  44.015  1.00 62.50           C  
ATOM     59  O   TYR A  10      35.041   4.337  44.439  1.00 62.59           O  
ATOM     60  CB  TYR A  10      34.306   4.007  41.547  1.00 60.82           C  
ATOM     61  CG  TYR A  10      33.714   4.409  40.232  1.00 59.70           C  
ATOM     62  CD1 TYR A  10      33.989   5.646  39.677  1.00 58.11           C  
ATOM     63  CD2 TYR A  10      32.844   3.566  39.558  1.00 60.55           C  
ATOM     64  CE1 TYR A  10      33.438   6.044  38.466  1.00 57.59           C  
ATOM     65  CE2 TYR A  10      32.270   3.950  38.354  1.00 61.55           C  
ATOM     66  CZ  TYR A  10      32.575   5.204  37.816  1.00 60.25           C  
ATOM     67  OH  TYR A  10      32.016   5.597  36.634  1.00 58.95           O  
ATOM     68  N   ARG A  11      33.398   2.810  44.647  1.00 63.90           N  
ATOM     69  CA  ARG A  11      33.959   2.166  45.840  1.00 64.07           C  
ATOM     70  C   ARG A  11      35.392   1.746  45.606  1.00 63.86           C  
ATOM     71  O   ARG A  11      35.728   1.246  44.527  1.00 63.94           O  
ATOM     72  CB  ARG A  11      33.153   0.953  46.214  1.00 63.86           C  
ATOM     73  CG  ARG A  11      32.435   1.148  47.487  1.00 67.35           C  
ATOM     74  CD  ARG A  11      31.481   0.003  47.723  1.00 74.38           C  
ATOM     75  NE  ARG A  11      30.190   0.217  47.068  1.00 77.30           N  
ATOM     76  CZ  ARG A  11      29.108  -0.496  47.332  1.00 77.55           C  
ATOM     77  NH1 ARG A  11      29.164  -1.476  48.228  1.00 78.68           N  
ATOM     78  NH2 ARG A  11      27.975  -0.215  46.717  1.00 77.63           N  
ATOM     79  N   ILE A  12      36.228   1.959  46.621  1.00 63.46           N  
ATOM     80  CA  ILE A  12      37.667   1.802  46.498  1.00 62.52           C  
ATOM     81  C   ILE A  12      38.280   1.488  47.838  1.00 62.80           C  
ATOM     82  O   ILE A  12      37.903   2.076  48.865  1.00 63.16           O  
ATOM     83  CB  ILE A  12      38.319   3.063  45.916  1.00 62.24           C  
ATOM     84  CG1 ILE A  12      39.834   2.993  46.035  1.00 61.45           C  
ATOM     85  CG2 ILE A  12      37.817   4.293  46.629  1.00 62.17           C  
ATOM     86  CD1 ILE A  12      40.584   3.890  45.066  1.00 62.05           C  
ATOM     87  N   GLU A  13      39.226   0.546  47.826  1.00 62.75           N  
ATOM     88  CA  GLU A  13      40.021   0.243  49.005  1.00 62.28           C  
ATOM     89  C   GLU A  13      41.429  -0.208  48.649  1.00 61.76           C  
ATOM     90  O   GLU A  13      41.678  -0.600  47.495  1.00 61.29           O  
ATOM     91  CB  GLU A  13      39.339  -0.811  49.852  1.00 62.56           C  
ATOM     92  CG  GLU A  13      39.018  -2.098  49.115  1.00 63.71           C  
ATOM     93  CD  GLU A  13      38.590  -3.169  50.095  1.00 65.64           C  
ATOM     94  OE1 GLU A  13      38.922  -2.998  51.307  1.00 65.36           O  
ATOM     95  OE2 GLU A  13      37.922  -4.150  49.663  1.00 64.92           O  
ATOM     96  N   TYR A  14      42.312  -0.177  49.668  1.00 61.00           N  
ATOM     97  CA  TYR A  14      43.716  -0.497  49.536  1.00 60.08           C  
ATOM     98  C   TYR A  14      44.115  -1.658  50.437  1.00 60.29           C  
ATOM     99  O   TYR A  14      44.201  -1.529  51.657  1.00 59.89           O  
ATOM    100  CB  TYR A  14      44.537   0.728  49.881  1.00 59.88           C  
ATOM    101  CG  TYR A  14      46.029   0.589  49.591  1.00 59.95           C  
ATOM    102  CD1 TYR A  14      46.490   0.282  48.307  1.00 57.91           C  
ATOM    103  CD2 TYR A  14      46.977   0.787  50.603  1.00 58.44           C  
ATOM    104  CE1 TYR A  14      47.837   0.150  48.045  1.00 58.38           C  
ATOM    105  CE2 TYR A  14      48.339   0.676  50.349  1.00 59.17           C  
ATOM    106  CZ  TYR A  14      48.778   0.364  49.062  1.00 60.47           C  
ATOM    107  OH  TYR A  14      50.159   0.258  48.798  1.00 60.95           O  
ATOM    108  N   ARG A  15      44.366  -2.808  49.840  1.00 60.60           N  
ATOM    109  CA  ARG A  15      44.728  -3.957  50.642  1.00 61.49           C  
ATOM    110  C   ARG A  15      45.810  -4.707  49.932  1.00 62.28           C  
ATOM    111  O   ARG A  15      45.526  -5.695  49.247  1.00 62.44           O  
ATOM    112  CB  ARG A  15      43.538  -4.888  50.854  1.00 61.42           C  
ATOM    113  CG  ARG A  15      42.253  -4.219  51.236  1.00 60.33           C  
ATOM    114  CD  ARG A  15      42.207  -3.885  52.699  1.00 60.04           C  
ATOM    115  NE  ARG A  15      40.985  -3.140  52.954  1.00 63.73           N  
ATOM    116  CZ  ARG A  15      40.792  -2.295  53.965  1.00 65.39           C  
ATOM    117  NH1 ARG A  15      41.759  -2.058  54.863  1.00 66.52           N  
ATOM    118  NH2 ARG A  15      39.617  -1.679  54.062  1.00 63.79           N  
ATOM    119  N   PRO A  16      47.057  -4.225  50.068  1.00 63.05           N  
ATOM    120  CA  PRO A  16      48.244  -4.839  49.465  1.00 63.14           C  
ATOM    121  C   PRO A  16      48.826  -5.931  50.335  1.00 63.38           C  
ATOM    122  O   PRO A  16      48.585  -5.965  51.557  1.00 62.80           O  
ATOM    123  CB  PRO A  16      49.221  -3.683  49.401  1.00 63.30           C  
ATOM    124  CG  PRO A  16      48.877  -2.872  50.627  1.00 63.43           C  
ATOM    125  CD  PRO A  16      47.394  -3.000  50.818  1.00 63.15           C  
ATOM    126  N   LYS A  17      49.589  -6.812  49.695  1.00 63.92           N  
ATOM    127  CA  LYS A  17      50.365  -7.837  50.395  1.00 64.91           C  
ATOM    128  C   LYS A  17      51.511  -7.229  51.225  1.00 65.44           C  
ATOM    129  O   LYS A  17      51.667  -7.562  52.386  1.00 66.04           O  
ATOM    130  CB  LYS A  17      50.895  -8.838  49.391  1.00 64.38           C  
ATOM    131  CG  LYS A  17      49.970  -8.919  48.240  1.00 66.16           C  
ATOM    132  CD  LYS A  17      50.447  -9.839  47.180  1.00 69.59           C  
ATOM    133  CE  LYS A  17      49.254 -10.263  46.335  1.00 72.45           C  
ATOM    134  NZ  LYS A  17      49.526 -11.648  45.810  1.00 77.81           N  
ATOM    135  N   ASP A  18      52.311  -6.343  50.631  1.00 66.10           N  
ATOM    136  CA  ASP A  18      53.286  -5.579  51.389  1.00 66.40           C  
ATOM    137  C   ASP A  18      52.537  -4.488  52.144  1.00 66.53           C  
ATOM    138  O   ASP A  18      51.819  -3.699  51.539  1.00 66.71           O  
ATOM    139  CB  ASP A  18      54.314  -4.957  50.449  1.00 66.62           C  
ATOM    140  CG  ASP A  18      55.628  -4.607  51.152  1.00 67.61           C  
ATOM    141  OD1 ASP A  18      55.605  -4.192  52.349  1.00 67.96           O  
ATOM    142  OD2 ASP A  18      56.687  -4.738  50.484  1.00 67.23           O  
ATOM    143  N   THR A  19      52.725  -4.444  53.459  1.00 66.48           N  
ATOM    144  CA  THR A  19      51.966  -3.562  54.335  1.00 66.40           C  
ATOM    145  C   THR A  19      52.903  -2.626  55.120  1.00 66.75           C  
ATOM    146  O   THR A  19      52.542  -2.079  56.176  1.00 66.72           O  
ATOM    147  CB  THR A  19      51.117  -4.454  55.235  1.00 66.14           C  
ATOM    148  OG1 THR A  19      50.015  -4.889  54.460  1.00 66.58           O  
ATOM    149  CG2 THR A  19      50.572  -3.755  56.448  1.00 65.98           C  
ATOM    150  N   THR A  20      54.106  -2.420  54.577  1.00 66.75           N  
ATOM    151  CA  THR A  20      55.216  -1.867  55.353  1.00 66.37           C  
ATOM    152  C   THR A  20      55.670  -0.521  54.880  1.00 65.44           C  
ATOM    153  O   THR A  20      56.342  -0.407  53.862  1.00 65.23           O  
ATOM    154  CB  THR A  20      56.414  -2.772  55.278  1.00 66.86           C  
ATOM    155  OG1 THR A  20      55.965  -4.130  55.118  1.00 68.44           O  
ATOM    156  CG2 THR A  20      57.261  -2.619  56.537  1.00 66.93           C  
ATOM    157  N   PHE A  21      55.315   0.480  55.668  1.00 64.55           N  
ATOM    158  CA  PHE A  21      55.608   1.872  55.392  1.00 63.84           C  
ATOM    159  C   PHE A  21      56.775   2.346  56.221  1.00 63.36           C  
ATOM    160  O   PHE A  21      57.073   1.769  57.254  1.00 63.88           O  
ATOM    161  CB  PHE A  21      54.383   2.703  55.746  1.00 63.57           C  
ATOM    162  CG  PHE A  21      53.308   2.603  54.742  1.00 63.63           C  
ATOM    163  CD1 PHE A  21      52.762   1.361  54.411  1.00 63.61           C  
ATOM    164  CD2 PHE A  21      52.863   3.740  54.075  1.00 63.01           C  
ATOM    165  CE1 PHE A  21      51.757   1.257  53.443  1.00 63.52           C  
ATOM    166  CE2 PHE A  21      51.867   3.647  53.116  1.00 62.46           C  
ATOM    167  CZ  PHE A  21      51.310   2.403  52.802  1.00 63.01           C  
ATOM    168  N   THR A  22      57.445   3.393  55.783  1.00 62.53           N  
ATOM    169  CA  THR A  22      58.428   4.000  56.636  1.00 62.09           C  
ATOM    170  C   THR A  22      57.850   5.330  57.051  1.00 62.36           C  
ATOM    171  O   THR A  22      57.268   6.055  56.229  1.00 62.95           O  
ATOM    172  CB  THR A  22      59.761   4.147  55.940  1.00 61.82           C  
ATOM    173  OG1 THR A  22      60.160   2.878  55.405  1.00 61.78           O  
ATOM    174  CG2 THR A  22      60.799   4.580  56.928  1.00 62.34           C  
ATOM    175  N   VAL A  23      57.966   5.642  58.333  1.00 62.27           N  
ATOM    176  CA  VAL A  23      57.274   6.798  58.888  1.00 62.21           C  
ATOM    177  C   VAL A  23      58.278   7.828  59.389  1.00 62.49           C  
ATOM    178  O   VAL A  23      59.359   7.477  59.848  1.00 62.59           O  
ATOM    179  CB  VAL A  23      56.274   6.383  60.001  1.00 62.22           C  
ATOM    180  CG1 VAL A  23      55.371   7.553  60.413  1.00 61.85           C  
ATOM    181  CG2 VAL A  23      55.422   5.199  59.546  1.00 61.79           C  
ATOM    182  N   PHE A  24      57.902   9.099  59.289  1.00 62.72           N  
ATOM    183  CA  PHE A  24      58.790  10.206  59.559  1.00 62.88           C  
ATOM    184  C   PHE A  24      58.056  11.253  60.351  1.00 63.68           C  
ATOM    185  O   PHE A  24      56.878  11.487  60.125  1.00 63.90           O  
ATOM    186  CB  PHE A  24      59.249  10.805  58.246  1.00 62.43           C  
ATOM    187  CG  PHE A  24      60.087   9.877  57.424  1.00 61.83           C  
ATOM    188  CD1 PHE A  24      59.493   8.909  56.623  1.00 60.23           C  
ATOM    189  CD2 PHE A  24      61.479   9.974  57.450  1.00 61.91           C  
ATOM    190  CE1 PHE A  24      60.256   8.049  55.865  1.00 60.37           C  
ATOM    191  CE2 PHE A  24      62.264   9.117  56.693  1.00 61.94           C  
ATOM    192  CZ  PHE A  24      61.648   8.146  55.900  1.00 61.79           C  
ATOM    193  N   LYS A  25      58.762  11.897  61.268  1.00 64.75           N  
ATOM    194  CA  LYS A  25      58.145  12.817  62.202  1.00 66.07           C  
ATOM    195  C   LYS A  25      58.943  14.109  62.192  1.00 66.89           C  
ATOM    196  O   LYS A  25      60.166  14.068  62.161  1.00 67.12           O  
ATOM    197  CB  LYS A  25      58.162  12.192  63.594  1.00 66.31           C  
ATOM    198  CG  LYS A  25      57.115  12.704  64.583  1.00 66.70           C  
ATOM    199  CD  LYS A  25      57.287  12.035  65.964  1.00 66.60           C  
ATOM    200  CE  LYS A  25      58.704  12.235  66.558  1.00 66.72           C  
ATOM    201  NZ  LYS A  25      59.105  13.683  66.686  1.00 66.10           N  
ATOM    202  N   PRO A  26      58.257  15.263  62.202  1.00 67.71           N  
ATOM    203  CA  PRO A  26      58.931  16.554  62.127  1.00 68.34           C  
ATOM    204  C   PRO A  26      59.655  16.839  63.411  1.00 69.05           C  
ATOM    205  O   PRO A  26      59.337  16.242  64.437  1.00 69.37           O  
ATOM    206  CB  PRO A  26      57.780  17.558  61.938  1.00 68.32           C  
ATOM    207  CG  PRO A  26      56.581  16.737  61.567  1.00 68.53           C  
ATOM    208  CD  PRO A  26      56.798  15.422  62.266  1.00 68.18           C  
ATOM    209  N   THR A  27      60.624  17.740  63.354  1.00 69.88           N  
ATOM    210  CA  THR A  27      61.496  17.964  64.489  1.00 71.00           C  
ATOM    211  C   THR A  27      61.018  19.175  65.244  1.00 71.70           C  
ATOM    212  O   THR A  27      61.578  19.526  66.299  1.00 71.96           O  
ATOM    213  CB  THR A  27      62.953  18.201  64.054  1.00 71.07           C  
ATOM    214  OG1 THR A  27      63.071  19.495  63.439  1.00 71.26           O  
ATOM    215  CG2 THR A  27      63.419  17.094  63.101  1.00 70.88           C  
ATOM    216  N   HIS A  28      59.988  19.807  64.684  1.00 72.06           N  
ATOM    217  CA  HIS A  28      59.482  21.090  65.156  1.00 72.57           C  
ATOM    218  C   HIS A  28      58.098  21.242  64.560  1.00 72.99           C  
ATOM    219  O   HIS A  28      57.953  21.317  63.341  1.00 73.48           O  
ATOM    220  CB  HIS A  28      60.518  22.208  64.840  1.00 72.47           C  
ATOM    221  CG  HIS A  28      60.020  23.370  64.030  1.00 73.03           C  
ATOM    222  ND1 HIS A  28      58.720  23.828  64.062  1.00 73.62           N  
ATOM    223  CD2 HIS A  28      60.690  24.211  63.205  1.00 74.08           C  
ATOM    224  CE1 HIS A  28      58.597  24.869  63.257  1.00 73.76           C  
ATOM    225  NE2 HIS A  28      59.780  25.126  62.728  1.00 74.47           N  
ATOM    226  N   GLU A  29      57.077  21.224  65.417  1.00 73.39           N  
ATOM    227  CA  GLU A  29      55.679  21.133  64.961  1.00 74.20           C  
ATOM    228  C   GLU A  29      55.374  21.993  63.720  1.00 74.34           C  
ATOM    229  O   GLU A  29      55.522  23.225  63.771  1.00 74.49           O  
ATOM    230  CB  GLU A  29      54.711  21.488  66.093  1.00 74.42           C  
ATOM    231  CG  GLU A  29      53.365  20.759  65.992  1.00 75.38           C  
ATOM    232  CD  GLU A  29      52.160  21.699  66.044  1.00 76.70           C  
ATOM    233  OE1 GLU A  29      52.332  22.897  66.400  1.00 75.34           O  
ATOM    234  OE2 GLU A  29      51.040  21.227  65.707  1.00 77.03           O  
ATOM    235  N   ILE A  30      54.961  21.350  62.618  1.00 74.42           N  
ATOM    236  CA  ILE A  30      54.732  22.057  61.339  1.00 74.47           C  
ATOM    237  C   ILE A  30      53.498  22.936  61.362  1.00 74.67           C  
ATOM    238  O   ILE A  30      52.435  22.534  61.826  1.00 74.09           O  
ATOM    239  CB  ILE A  30      54.646  21.136  60.093  1.00 74.15           C  
ATOM    240  CG1 ILE A  30      55.790  20.126  60.078  1.00 74.87           C  
ATOM    241  CG2 ILE A  30      54.691  21.975  58.813  1.00 73.87           C  
ATOM    242  CD1 ILE A  30      55.827  19.224  58.849  1.00 74.66           C  
ATOM    243  N   GLN A  31      53.668  24.149  60.851  1.00 75.40           N  
ATOM    244  CA  GLN A  31      52.580  25.085  60.720  1.00 76.16           C  
ATOM    245  C   GLN A  31      51.636  24.526  59.658  1.00 76.01           C  
ATOM    246  O   GLN A  31      52.078  23.926  58.687  1.00 75.65           O  
ATOM    247  CB  GLN A  31      53.152  26.452  60.373  1.00 76.38           C  
ATOM    248  CG  GLN A  31      52.142  27.542  60.081  1.00 79.05           C  
ATOM    249  CD  GLN A  31      52.788  28.705  59.322  1.00 83.02           C  
ATOM    250  OE1 GLN A  31      53.668  29.407  59.862  1.00 84.76           O  
ATOM    251  NE2 GLN A  31      52.361  28.914  58.061  1.00 82.81           N  
ATOM    252  N   LYS A  32      50.340  24.714  59.865  1.00 76.65           N  
ATOM    253  CA  LYS A  32      49.306  23.945  59.158  1.00 77.48           C  
ATOM    254  C   LYS A  32      49.326  24.075  57.641  1.00 77.27           C  
ATOM    255  O   LYS A  32      49.298  23.080  56.907  1.00 77.38           O  
ATOM    256  CB  LYS A  32      47.926  24.317  59.685  1.00 77.71           C  
ATOM    257  CG  LYS A  32      47.921  24.604  61.181  1.00 80.92           C  
ATOM    258  CD  LYS A  32      46.676  24.003  61.826  1.00 84.81           C  
ATOM    259  CE  LYS A  32      46.475  24.504  63.250  1.00 85.51           C  
ATOM    260  NZ  LYS A  32      45.184  23.948  63.735  1.00 86.58           N  
ATOM    261  N   GLU A  33      49.392  25.312  57.173  1.00 77.00           N  
ATOM    262  CA  GLU A  33      49.376  25.587  55.749  1.00 76.54           C  
ATOM    263  C   GLU A  33      50.704  25.231  55.102  1.00 75.21           C  
ATOM    264  O   GLU A  33      50.863  25.385  53.899  1.00 75.55           O  
ATOM    265  CB  GLU A  33      49.002  27.049  55.492  1.00 77.35           C  
ATOM    266  CG  GLU A  33      49.516  28.051  56.564  1.00 80.43           C  
ATOM    267  CD  GLU A  33      48.460  29.105  56.940  1.00 84.41           C  
ATOM    268  OE1 GLU A  33      48.144  29.984  56.092  1.00 86.57           O  
ATOM    269  OE2 GLU A  33      47.943  29.047  58.087  1.00 84.68           O  
ATOM    270  N   LYS A  34      51.650  24.754  55.900  1.00 73.34           N  
ATOM    271  CA  LYS A  34      52.869  24.180  55.359  1.00 71.94           C  
ATOM    272  C   LYS A  34      52.776  22.663  55.139  1.00 71.04           C  
ATOM    273  O   LYS A  34      53.684  22.062  54.555  1.00 70.71           O  
ATOM    274  CB  LYS A  34      54.060  24.489  56.265  1.00 71.97           C  
ATOM    275  CG  LYS A  34      54.597  25.904  56.161  1.00 71.22           C  
ATOM    276  CD  LYS A  34      55.642  26.144  57.236  1.00 69.85           C  
ATOM    277  CE  LYS A  34      55.970  27.600  57.354  1.00 69.22           C  
ATOM    278  NZ  LYS A  34      57.012  27.782  58.379  1.00 68.92           N  
ATOM    279  N   LEU A  35      51.686  22.041  55.586  1.00 70.00           N  
ATOM    280  CA  LEU A  35      51.615  20.559  55.608  1.00 68.90           C  
ATOM    281  C   LEU A  35      51.586  19.841  54.232  1.00 68.04           C  
ATOM    282  O   LEU A  35      52.451  18.977  53.989  1.00 67.92           O  
ATOM    283  CB  LEU A  35      50.489  20.058  56.524  1.00 68.84           C  
ATOM    284  CG  LEU A  35      50.644  20.316  58.029  1.00 68.70           C  
ATOM    285  CD1 LEU A  35      49.314  20.113  58.733  1.00 67.71           C  
ATOM    286  CD2 LEU A  35      51.750  19.456  58.664  1.00 67.69           C  
ATOM    287  N   ASN A  36      50.633  20.215  53.354  1.00 66.23           N  
ATOM    288  CA  ASN A  36      50.565  19.713  51.965  1.00 64.84           C  
ATOM    289  C   ASN A  36      51.820  19.922  51.083  1.00 64.91           C  
ATOM    290  O   ASN A  36      52.059  19.147  50.139  1.00 65.33           O  
ATOM    291  CB  ASN A  36      49.384  20.323  51.227  1.00 64.30           C  
ATOM    292  CG  ASN A  36      48.039  19.862  51.754  1.00 62.77           C  
ATOM    293  OD1 ASN A  36      47.949  19.012  52.640  1.00 63.03           O  
ATOM    294  ND2 ASN A  36      46.973  20.430  51.197  1.00 58.82           N  
ATOM    295  N   LYS A  37      52.600  20.970  51.373  1.00 64.13           N  
ATOM    296  CA  LYS A  37      53.842  21.271  50.646  1.00 63.04           C  
ATOM    297  C   LYS A  37      54.977  20.391  51.120  1.00 62.41           C  
ATOM    298  O   LYS A  37      55.886  20.069  50.364  1.00 62.36           O  
ATOM    299  CB  LYS A  37      54.239  22.741  50.806  1.00 62.86           C  
ATOM    300  CG  LYS A  37      53.107  23.698  50.553  1.00 62.88           C  
ATOM    301  CD  LYS A  37      53.582  25.001  50.011  1.00 62.67           C  
ATOM    302  CE  LYS A  37      52.478  26.014  50.161  1.00 63.65           C  
ATOM    303  NZ  LYS A  37      52.581  27.064  49.119  1.00 65.94           N  
ATOM    304  N   VAL A  38      54.930  20.017  52.385  1.00 61.83           N  
ATOM    305  CA  VAL A  38      55.917  19.105  52.922  1.00 61.24           C  
ATOM    306  C   VAL A  38      55.659  17.720  52.363  1.00 60.85           C  
ATOM    307  O   VAL A  38      56.572  17.094  51.813  1.00 60.13           O  
ATOM    308  CB  VAL A  38      55.872  19.077  54.452  1.00 61.34           C  
ATOM    309  CG1 VAL A  38      56.758  17.987  54.971  1.00 61.02           C  
ATOM    310  CG2 VAL A  38      56.316  20.419  55.015  1.00 60.92           C  
ATOM    311  N   ARG A  39      54.401  17.274  52.491  1.00 60.80           N  
ATOM    312  CA  ARG A  39      53.949  15.951  52.018  1.00 60.72           C  
ATOM    313  C   ARG A  39      54.348  15.703  50.568  1.00 60.57           C  
ATOM    314  O   ARG A  39      55.106  14.756  50.256  1.00 60.41           O  
ATOM    315  CB  ARG A  39      52.432  15.786  52.143  1.00 60.62           C  
ATOM    316  CG  ARG A  39      51.961  14.363  51.825  1.00 60.48           C  
ATOM    317  CD  ARG A  39      50.607  14.335  51.132  1.00 61.05           C  
ATOM    318  NE  ARG A  39      50.691  14.785  49.741  1.00 64.56           N  
ATOM    319  CZ  ARG A  39      51.293  14.118  48.743  1.00 66.02           C  
ATOM    320  NH1 ARG A  39      51.895  12.947  48.938  1.00 64.63           N  
ATOM    321  NH2 ARG A  39      51.297  14.633  47.523  1.00 67.39           N  
ATOM    322  N   TRP A  40      53.837  16.567  49.689  1.00 59.70           N  
ATOM    323  CA  TRP A  40      54.271  16.574  48.313  1.00 59.04           C  
ATOM    324  C   TRP A  40      55.827  16.496  48.180  1.00 58.43           C  
ATOM    325  O   TRP A  40      56.360  15.660  47.449  1.00 57.37           O  
ATOM    326  CB  TRP A  40      53.687  17.794  47.629  1.00 59.36           C  
ATOM    327  CG  TRP A  40      54.405  18.159  46.401  1.00 59.86           C  
ATOM    328  CD1 TRP A  40      55.221  19.239  46.217  1.00 59.57           C  
ATOM    329  CD2 TRP A  40      54.404  17.431  45.179  1.00 60.12           C  
ATOM    330  NE1 TRP A  40      55.723  19.224  44.951  1.00 60.78           N  
ATOM    331  CE2 TRP A  40      55.234  18.127  44.286  1.00 60.75           C  
ATOM    332  CE3 TRP A  40      53.763  16.261  44.742  1.00 60.87           C  
ATOM    333  CZ2 TRP A  40      55.447  17.697  42.974  1.00 60.43           C  
ATOM    334  CZ3 TRP A  40      53.971  15.832  43.438  1.00 60.17           C  
ATOM    335  CH2 TRP A  40      54.813  16.544  42.573  1.00 60.08           C  
ATOM    336  N   ARG A  41      56.542  17.339  48.922  1.00 58.11           N  
ATOM    337  CA  ARG A  41      57.997  17.322  48.876  1.00 57.95           C  
ATOM    338  C   ARG A  41      58.568  15.995  49.313  1.00 57.68           C  
ATOM    339  O   ARG A  41      59.593  15.552  48.770  1.00 57.63           O  
ATOM    340  CB  ARG A  41      58.603  18.461  49.686  1.00 58.13           C  
ATOM    341  CG  ARG A  41      58.982  19.647  48.839  1.00 58.75           C  
ATOM    342  CD  ARG A  41      58.831  20.925  49.617  1.00 62.72           C  
ATOM    343  NE  ARG A  41      58.857  22.099  48.751  1.00 66.63           N  
ATOM    344  CZ  ARG A  41      57.785  22.633  48.163  1.00 68.70           C  
ATOM    345  NH1 ARG A  41      56.565  22.109  48.346  1.00 66.65           N  
ATOM    346  NH2 ARG A  41      57.942  23.706  47.388  1.00 69.43           N  
ATOM    347  N   VAL A  42      57.903  15.348  50.270  1.00 57.30           N  
ATOM    348  CA  VAL A  42      58.332  14.006  50.698  1.00 56.62           C  
ATOM    349  C   VAL A  42      58.193  12.990  49.570  1.00 56.07           C  
ATOM    350  O   VAL A  42      59.095  12.197  49.349  1.00 55.01           O  
ATOM    351  CB  VAL A  42      57.595  13.518  51.953  1.00 56.60           C  
ATOM    352  CG1 VAL A  42      57.939  12.063  52.245  1.00 56.98           C  
ATOM    353  CG2 VAL A  42      57.956  14.373  53.136  1.00 56.01           C  
ATOM    354  N   PHE A  43      57.074  13.040  48.845  1.00 56.32           N  
ATOM    355  CA  PHE A  43      56.844  12.108  47.721  1.00 56.50           C  
ATOM    356  C   PHE A  43      57.956  12.196  46.669  1.00 56.86           C  
ATOM    357  O   PHE A  43      58.546  11.165  46.330  1.00 57.06           O  
ATOM    358  CB  PHE A  43      55.432  12.258  47.119  1.00 56.12           C  
ATOM    359  CG  PHE A  43      55.247  11.593  45.773  1.00 55.89           C  
ATOM    360  CD1 PHE A  43      55.351  10.210  45.630  1.00 56.43           C  
ATOM    361  CD2 PHE A  43      54.925  12.349  44.653  1.00 55.55           C  
ATOM    362  CE1 PHE A  43      55.159   9.600  44.386  1.00 55.72           C  
ATOM    363  CE2 PHE A  43      54.749  11.755  43.405  1.00 55.01           C  
ATOM    364  CZ  PHE A  43      54.855  10.378  43.277  1.00 55.66           C  
ATOM    365  N   LEU A  44      58.269  13.416  46.206  1.00 56.91           N  
ATOM    366  CA  LEU A  44      59.336  13.632  45.225  1.00 57.04           C  
ATOM    367  C   LEU A  44      60.602  12.961  45.664  1.00 57.11           C  
ATOM    368  O   LEU A  44      61.124  12.106  44.954  1.00 56.60           O  
ATOM    369  CB  LEU A  44      59.626  15.107  45.020  1.00 57.02           C  
ATOM    370  CG  LEU A  44      58.460  16.010  44.626  1.00 59.24           C  
ATOM    371  CD1 LEU A  44      58.975  17.333  44.036  1.00 59.13           C  
ATOM    372  CD2 LEU A  44      57.484  15.301  43.662  1.00 59.73           C  
ATOM    373  N   GLN A  45      61.063  13.340  46.855  1.00 57.70           N  
ATOM    374  CA  GLN A  45      62.353  12.909  47.387  1.00 58.52           C  
ATOM    375  C   GLN A  45      62.436  11.408  47.480  1.00 58.56           C  
ATOM    376  O   GLN A  45      63.168  10.770  46.721  1.00 59.08           O  
ATOM    377  CB  GLN A  45      62.600  13.501  48.771  1.00 58.84           C  
ATOM    378  CG  GLN A  45      62.863  15.013  48.786  1.00 59.91           C  
ATOM    379  CD  GLN A  45      63.903  15.410  49.832  1.00 60.01           C  
ATOM    380  OE1 GLN A  45      64.919  14.727  49.987  1.00 59.08           O  
ATOM    381  NE2 GLN A  45      63.661  16.526  50.539  1.00 59.39           N  
ATOM    382  N   THR A  46      61.664  10.868  48.418  1.00 58.70           N  
ATOM    383  CA  THR A  46      61.484   9.434  48.630  1.00 58.37           C  
ATOM    384  C   THR A  46      61.237   8.704  47.334  1.00 58.02           C  
ATOM    385  O   THR A  46      61.776   7.642  47.133  1.00 57.70           O  
ATOM    386  CB  THR A  46      60.266   9.152  49.532  1.00 58.43           C  
ATOM    387  OG1 THR A  46      60.375   9.886  50.751  1.00 58.37           O  
ATOM    388  CG2 THR A  46      60.235   7.730  49.883  1.00 60.11           C  
ATOM    389  N   GLY A  47      60.414   9.276  46.460  1.00 58.03           N  
ATOM    390  CA  GLY A  47      59.939   8.552  45.290  1.00 57.99           C  
ATOM    391  C   GLY A  47      58.707   7.712  45.591  1.00 58.27           C  
ATOM    392  O   GLY A  47      57.998   7.317  44.672  1.00 58.82           O  
ATOM    393  N   LEU A  48      58.420   7.448  46.868  1.00 58.19           N  
ATOM    394  CA  LEU A  48      57.337   6.528  47.213  1.00 58.13           C  
ATOM    395  C   LEU A  48      56.073   7.263  47.536  1.00 58.60           C  
ATOM    396  O   LEU A  48      56.144   8.333  48.107  1.00 59.00           O  
ATOM    397  CB  LEU A  48      57.708   5.667  48.417  1.00 57.72           C  
ATOM    398  CG  LEU A  48      59.029   4.915  48.333  1.00 56.49           C  
ATOM    399  CD1 LEU A  48      59.442   4.567  49.737  1.00 55.93           C  
ATOM    400  CD2 LEU A  48      58.948   3.684  47.429  1.00 54.98           C  
ATOM    401  N   PRO A  49      54.902   6.688  47.180  1.00 59.17           N  
ATOM    402  CA  PRO A  49      53.620   7.211  47.667  1.00 59.47           C  
ATOM    403  C   PRO A  49      53.637   7.488  49.172  1.00 60.15           C  
ATOM    404  O   PRO A  49      54.395   6.861  49.928  1.00 59.81           O  
ATOM    405  CB  PRO A  49      52.634   6.091  47.336  1.00 58.89           C  
ATOM    406  CG  PRO A  49      53.194   5.458  46.146  1.00 58.68           C  
ATOM    407  CD  PRO A  49      54.699   5.544  46.270  1.00 59.05           C  
ATOM    408  N   THR A  50      52.797   8.430  49.585  1.00 60.90           N  
ATOM    409  CA  THR A  50      52.929   9.074  50.877  1.00 61.69           C  
ATOM    410  C   THR A  50      51.632   9.695  51.322  1.00 62.09           C  
ATOM    411  O   THR A  50      51.021  10.446  50.552  1.00 62.66           O  
ATOM    412  CB  THR A  50      53.937  10.231  50.764  1.00 61.69           C  
ATOM    413  OG1 THR A  50      55.209   9.718  50.354  1.00 61.99           O  
ATOM    414  CG2 THR A  50      54.076  10.977  52.089  1.00 61.51           C  
ATOM    415  N   PHE A  51      51.209   9.401  52.553  1.00 62.43           N  
ATOM    416  CA  PHE A  51      50.067  10.118  53.152  1.00 62.52           C  
ATOM    417  C   PHE A  51      50.427  10.687  54.515  1.00 62.78           C  
ATOM    418  O   PHE A  51      51.358  10.220  55.172  1.00 62.87           O  
ATOM    419  CB  PHE A  51      48.772   9.272  53.202  1.00 62.61           C  
ATOM    420  CG  PHE A  51      48.859   8.041  54.086  1.00 62.65           C  
ATOM    421  CD1 PHE A  51      48.868   8.155  55.481  1.00 62.89           C  
ATOM    422  CD2 PHE A  51      48.912   6.770  53.519  1.00 62.33           C  
ATOM    423  CE1 PHE A  51      48.957   7.040  56.287  1.00 62.74           C  
ATOM    424  CE2 PHE A  51      48.992   5.638  54.311  1.00 62.18           C  
ATOM    425  CZ  PHE A  51      49.015   5.768  55.699  1.00 63.56           C  
ATOM    426  N   ARG A  52      49.683  11.707  54.917  1.00 63.33           N  
ATOM    427  CA  ARG A  52      49.878  12.383  56.180  1.00 64.32           C  
ATOM    428  C   ARG A  52      48.968  11.725  57.185  1.00 65.09           C  
ATOM    429  O   ARG A  52      47.740  11.739  57.016  1.00 64.99           O  
ATOM    430  CB  ARG A  52      49.479  13.861  56.040  1.00 64.72           C  
ATOM    431  CG  ARG A  52      50.230  14.869  56.909  1.00 64.20           C  
ATOM    432  CD  ARG A  52      49.694  16.263  56.661  1.00 64.04           C  
ATOM    433  NE  ARG A  52      48.405  16.426  57.320  1.00 65.82           N  
ATOM    434  CZ  ARG A  52      47.301  16.921  56.758  1.00 68.58           C  
ATOM    435  NH1 ARG A  52      47.278  17.357  55.495  1.00 70.44           N  
ATOM    436  NH2 ARG A  52      46.199  17.005  57.482  1.00 69.42           N  
ATOM    437  N   ARG A  53      49.561  11.129  58.216  1.00 66.18           N  
ATOM    438  CA  ARG A  53      48.786  10.683  59.363  1.00 67.33           C  
ATOM    439  C   ARG A  53      49.163  11.531  60.551  1.00 68.44           C  
ATOM    440  O   ARG A  53      50.193  11.277  61.189  1.00 68.91           O  
ATOM    441  CB  ARG A  53      49.011   9.201  59.677  1.00 67.13           C  
ATOM    442  CG  ARG A  53      48.161   8.731  60.850  1.00 66.32           C  
ATOM    443  CD  ARG A  53      47.853   7.268  60.789  1.00 64.50           C  
ATOM    444  NE  ARG A  53      46.856   6.995  59.771  1.00 63.43           N  
ATOM    445  CZ  ARG A  53      46.698   5.810  59.194  1.00 63.59           C  
ATOM    446  NH1 ARG A  53      47.491   4.785  59.554  1.00 62.68           N  
ATOM    447  NH2 ARG A  53      45.765   5.657  58.254  1.00 61.35           N  
ATOM    448  N   GLU A  54      48.331  12.532  60.847  1.00 69.56           N  
ATOM    449  CA  GLU A  54      48.573  13.435  61.977  1.00 71.20           C  
ATOM    450  C   GLU A  54      49.791  14.313  61.697  1.00 71.17           C  
ATOM    451  O   GLU A  54      49.894  14.935  60.645  1.00 71.52           O  
ATOM    452  CB  GLU A  54      48.791  12.645  63.297  1.00 71.91           C  
ATOM    453  CG  GLU A  54      47.559  11.957  63.880  1.00 74.60           C  
ATOM    454  CD  GLU A  54      46.371  12.910  64.013  1.00 79.76           C  
ATOM    455  OE1 GLU A  54      46.577  14.083  64.440  1.00 79.81           O  
ATOM    456  OE2 GLU A  54      45.231  12.483  63.673  1.00 83.04           O  
ATOM    457  N   ASP A  55      50.722  14.344  62.636  1.00 70.95           N  
ATOM    458  CA  ASP A  55      51.984  15.019  62.408  1.00 71.00           C  
ATOM    459  C   ASP A  55      52.963  14.159  61.582  1.00 70.88           C  
ATOM    460  O   ASP A  55      54.007  14.673  61.161  1.00 71.60           O  
ATOM    461  CB  ASP A  55      52.635  15.476  63.741  1.00 71.03           C  
ATOM    462  CG  ASP A  55      52.399  14.488  64.916  1.00 70.77           C  
ATOM    463  OD1 ASP A  55      51.577  13.528  64.805  1.00 68.84           O  
ATOM    464  OD2 ASP A  55      53.035  14.701  65.973  1.00 70.21           O  
ATOM    465  N   GLU A  56      52.636  12.886  61.338  1.00 69.67           N  
ATOM    466  CA  GLU A  56      53.602  11.953  60.758  1.00 69.10           C  
ATOM    467  C   GLU A  56      53.360  11.568  59.293  1.00 68.79           C  
ATOM    468  O   GLU A  56      52.250  11.690  58.769  1.00 69.31           O  
ATOM    469  CB  GLU A  56      53.691  10.712  61.614  1.00 69.36           C  
ATOM    470  CG  GLU A  56      53.933  11.030  63.066  1.00 71.02           C  
ATOM    471  CD  GLU A  56      54.337   9.822  63.885  1.00 73.37           C  
ATOM    472  OE1 GLU A  56      53.714   8.737  63.707  1.00 73.88           O  
ATOM    473  OE2 GLU A  56      55.275   9.974  64.713  1.00 73.97           O  
ATOM    474  N   PHE A  57      54.412  11.098  58.635  1.00 67.70           N  
ATOM    475  CA  PHE A  57      54.396  10.953  57.195  1.00 66.68           C  
ATOM    476  C   PHE A  57      54.702   9.513  56.820  1.00 66.70           C  
ATOM    477  O   PHE A  57      55.745   8.970  57.187  1.00 66.40           O  
ATOM    478  CB  PHE A  57      55.418  11.906  56.560  1.00 66.44           C  
ATOM    479  CG  PHE A  57      55.066  13.372  56.687  1.00 65.62           C  
ATOM    480  CD1 PHE A  57      55.358  14.079  57.839  1.00 64.69           C  
ATOM    481  CD2 PHE A  57      54.460  14.051  55.633  1.00 66.73           C  
ATOM    482  CE1 PHE A  57      55.036  15.435  57.946  1.00 65.63           C  
ATOM    483  CE2 PHE A  57      54.127  15.417  55.728  1.00 66.28           C  
ATOM    484  CZ  PHE A  57      54.413  16.105  56.883  1.00 65.85           C  
ATOM    485  N   TRP A  58      53.799   8.895  56.067  1.00 66.81           N  
ATOM    486  CA  TRP A  58      53.879   7.456  55.816  1.00 66.84           C  
ATOM    487  C   TRP A  58      54.291   7.097  54.381  1.00 66.76           C  
ATOM    488  O   TRP A  58      53.569   7.449  53.441  1.00 66.74           O  
ATOM    489  CB  TRP A  58      52.534   6.818  56.166  1.00 66.87           C  
ATOM    490  CG  TRP A  58      52.249   6.725  57.638  1.00 66.77           C  
ATOM    491  CD1 TRP A  58      52.235   7.751  58.555  1.00 67.76           C  
ATOM    492  CD2 TRP A  58      51.915   5.546  58.357  1.00 67.10           C  
ATOM    493  NE1 TRP A  58      51.931   7.269  59.806  1.00 67.32           N  
ATOM    494  CE2 TRP A  58      51.724   5.919  59.712  1.00 67.38           C  
ATOM    495  CE3 TRP A  58      51.755   4.204  57.993  1.00 67.22           C  
ATOM    496  CZ2 TRP A  58      51.382   4.995  60.698  1.00 67.28           C  
ATOM    497  CZ3 TRP A  58      51.414   3.288  58.974  1.00 67.24           C  
ATOM    498  CH2 TRP A  58      51.230   3.689  60.312  1.00 67.09           C  
ATOM    499  N   CYS A  59      55.420   6.380  54.235  1.00 66.27           N  
ATOM    500  CA  CYS A  59      56.001   6.025  52.927  1.00 66.34           C  
ATOM    501  C   CYS A  59      55.832   4.581  52.482  1.00 65.76           C  
ATOM    502  O   CYS A  59      56.503   3.685  52.981  1.00 65.70           O  
ATOM    503  CB  CYS A  59      57.487   6.350  52.906  1.00 66.40           C  
ATOM    504  SG  CYS A  59      57.806   8.099  53.105  1.00 70.77           S  
ATOM    505  N   ALA A  60      54.952   4.374  51.504  1.00 65.78           N  
ATOM    506  CA  ALA A  60      54.677   3.060  50.891  1.00 65.24           C  
ATOM    507  C   ALA A  60      55.936   2.427  50.269  1.00 65.21           C  
ATOM    508  O   ALA A  60      56.020   2.216  49.050  1.00 65.31           O  
ATOM    509  CB  ALA A  60      53.551   3.183  49.858  1.00 64.41           C  
ATOM    510  N   GLY A  61      56.909   2.142  51.128  1.00 64.88           N  
ATOM    511  CA  GLY A  61      58.158   1.505  50.737  1.00 64.91           C  
ATOM    512  C   GLY A  61      59.072   1.465  51.943  1.00 64.95           C  
ATOM    513  O   GLY A  61      58.745   2.045  52.981  1.00 64.50           O  
ATOM    514  N   LYS A  62      60.191   0.755  51.829  1.00 65.22           N  
ATOM    515  CA  LYS A  62      61.217   0.810  52.875  1.00 65.75           C  
ATOM    516  C   LYS A  62      62.155   1.986  52.580  1.00 65.46           C  
ATOM    517  O   LYS A  62      62.440   2.295  51.419  1.00 65.35           O  
ATOM    518  CB  LYS A  62      61.990  -0.506  52.989  1.00 65.68           C  
ATOM    519  CG  LYS A  62      61.143  -1.663  53.478  1.00 66.16           C  
ATOM    520  CD  LYS A  62      61.919  -2.980  53.510  1.00 66.60           C  
ATOM    521  CE  LYS A  62      60.972  -4.189  53.281  1.00 68.43           C  
ATOM    522  NZ  LYS A  62      61.590  -5.519  53.675  1.00 69.08           N  
ATOM    523  N   VAL A  63      62.597   2.657  53.636  1.00 65.12           N  
ATOM    524  CA  VAL A  63      63.418   3.847  53.513  1.00 64.79           C  
ATOM    525  C   VAL A  63      64.512   3.758  54.552  1.00 64.93           C  
ATOM    526  O   VAL A  63      64.238   3.724  55.748  1.00 64.73           O  
ATOM    527  CB  VAL A  63      62.584   5.120  53.748  1.00 64.70           C  
ATOM    528  CG1 VAL A  63      63.475   6.325  53.956  1.00 64.99           C  
ATOM    529  CG2 VAL A  63      61.644   5.371  52.591  1.00 64.88           C  
ATOM    530  N   GLU A  64      65.758   3.710  54.103  1.00 65.40           N  
ATOM    531  CA  GLU A  64      66.857   3.541  55.049  1.00 65.73           C  
ATOM    532  C   GLU A  64      67.632   4.816  55.362  1.00 65.36           C  
ATOM    533  O   GLU A  64      68.582   4.766  56.130  1.00 65.78           O  
ATOM    534  CB  GLU A  64      67.778   2.377  54.665  1.00 65.91           C  
ATOM    535  CG  GLU A  64      68.005   2.173  53.176  1.00 68.42           C  
ATOM    536  CD  GLU A  64      69.373   1.532  52.882  1.00 73.35           C  
ATOM    537  OE1 GLU A  64      70.176   2.153  52.144  1.00 73.13           O  
ATOM    538  OE2 GLU A  64      69.662   0.416  53.393  1.00 75.32           O  
ATOM    539  N   LYS A  65      67.214   5.948  54.774  1.00 64.99           N  
ATOM    540  CA  LYS A  65      67.715   7.293  55.136  1.00 64.43           C  
ATOM    541  C   LYS A  65      67.038   7.786  56.420  1.00 63.92           C  
ATOM    542  O   LYS A  65      65.845   8.119  56.388  1.00 63.61           O  
ATOM    543  CB  LYS A  65      67.380   8.312  54.033  1.00 64.51           C  
ATOM    544  CG  LYS A  65      68.575   8.952  53.290  1.00 64.92           C  
ATOM    545  CD  LYS A  65      68.292  10.447  52.958  1.00 64.79           C  
ATOM    546  CE  LYS A  65      67.954  10.701  51.466  1.00 65.60           C  
ATOM    547  NZ  LYS A  65      66.764   9.902  50.923  1.00 65.76           N  
ATOM    548  N   ASP A  66      67.766   7.865  57.537  1.00 63.02           N  
ATOM    549  CA  ASP A  66      67.093   8.255  58.788  1.00 62.38           C  
ATOM    550  C   ASP A  66      66.750   9.744  58.923  1.00 61.60           C  
ATOM    551  O   ASP A  66      66.117  10.158  59.892  1.00 61.83           O  
ATOM    552  CB  ASP A  66      67.783   7.714  60.051  1.00 62.57           C  
ATOM    553  CG  ASP A  66      69.224   8.117  60.149  1.00 63.17           C  
ATOM    554  OD1 ASP A  66      70.052   7.468  59.470  1.00 64.10           O  
ATOM    555  OD2 ASP A  66      69.529   9.056  60.924  1.00 63.77           O  
ATOM    556  N   THR A  67      67.138  10.544  57.941  1.00 60.44           N  
ATOM    557  CA  THR A  67      66.743  11.944  57.935  1.00 59.33           C  
ATOM    558  C   THR A  67      66.319  12.399  56.534  1.00 58.62           C  
ATOM    559  O   THR A  67      66.680  11.788  55.525  1.00 58.67           O  
ATOM    560  CB  THR A  67      67.851  12.822  58.533  1.00 59.33           C  
ATOM    561  OG1 THR A  67      68.402  12.143  59.662  1.00 59.93           O  
ATOM    562  CG2 THR A  67      67.306  14.171  59.003  1.00 59.17           C  
ATOM    563  N   LEU A  68      65.521  13.457  56.493  1.00 57.59           N  
ATOM    564  CA  LEU A  68      64.972  13.956  55.268  1.00 56.95           C  
ATOM    565  C   LEU A  68      64.989  15.429  55.425  1.00 56.73           C  
ATOM    566  O   LEU A  68      64.348  15.953  56.333  1.00 56.92           O  
ATOM    567  CB  LEU A  68      63.515  13.506  55.132  1.00 56.97           C  
ATOM    568  CG  LEU A  68      63.082  12.778  53.857  1.00 56.58           C  
ATOM    569  CD1 LEU A  68      64.201  11.859  53.321  1.00 56.29           C  
ATOM    570  CD2 LEU A  68      61.842  11.974  54.157  1.00 54.66           C  
ATOM    571  N   TYR A  69      65.719  16.113  54.563  1.00 56.55           N  
ATOM    572  CA  TYR A  69      65.677  17.561  54.597  1.00 56.81           C  
ATOM    573  C   TYR A  69      64.930  18.050  53.379  1.00 56.98           C  
ATOM    574  O   TYR A  69      65.221  17.648  52.257  1.00 56.62           O  
ATOM    575  CB  TYR A  69      67.083  18.174  54.679  1.00 57.14           C  
ATOM    576  CG  TYR A  69      67.889  17.767  55.911  1.00 56.98           C  
ATOM    577  CD1 TYR A  69      68.878  16.779  55.828  1.00 57.31           C  
ATOM    578  CD2 TYR A  69      67.668  18.376  57.150  1.00 56.67           C  
ATOM    579  CE1 TYR A  69      69.626  16.400  56.953  1.00 57.84           C  
ATOM    580  CE2 TYR A  69      68.398  18.005  58.278  1.00 56.97           C  
ATOM    581  CZ  TYR A  69      69.379  17.017  58.180  1.00 57.45           C  
ATOM    582  OH  TYR A  69      70.108  16.654  59.301  1.00 56.45           O  
ATOM    583  N   LEU A  70      63.949  18.908  53.622  1.00 57.60           N  
ATOM    584  CA  LEU A  70      63.060  19.400  52.581  1.00 58.19           C  
ATOM    585  C   LEU A  70      62.958  20.933  52.630  1.00 59.19           C  
ATOM    586  O   LEU A  70      62.226  21.484  53.469  1.00 59.73           O  
ATOM    587  CB  LEU A  70      61.652  18.825  52.752  1.00 57.61           C  
ATOM    588  CG  LEU A  70      61.388  17.388  53.183  1.00 57.35           C  
ATOM    589  CD1 LEU A  70      60.450  17.394  54.365  1.00 56.67           C  
ATOM    590  CD2 LEU A  70      60.833  16.520  52.062  1.00 57.21           C  
ATOM    591  N   THR A  71      63.671  21.611  51.728  1.00 59.70           N  
ATOM    592  CA  THR A  71      63.485  23.036  51.471  1.00 60.33           C  
ATOM    593  C   THR A  71      62.127  23.352  50.815  1.00 60.95           C  
ATOM    594  O   THR A  71      61.774  22.754  49.791  1.00 60.38           O  
ATOM    595  CB  THR A  71      64.568  23.525  50.507  1.00 60.37           C  
ATOM    596  OG1 THR A  71      65.727  22.685  50.617  1.00 60.62           O  
ATOM    597  CG2 THR A  71      64.935  24.953  50.805  1.00 60.40           C  
ATOM    598  N   LEU A  72      61.376  24.291  51.399  1.00 62.09           N  
ATOM    599  CA  LEU A  72      60.215  24.883  50.710  1.00 63.68           C  
ATOM    600  C   LEU A  72      60.675  26.041  49.795  1.00 64.17           C  
ATOM    601  O   LEU A  72      61.871  26.345  49.712  1.00 63.94           O  
ATOM    602  CB  LEU A  72      59.136  25.410  51.677  1.00 64.18           C  
ATOM    603  CG  LEU A  72      58.696  24.957  53.092  1.00 66.06           C  
ATOM    604  CD1 LEU A  72      57.174  25.244  53.279  1.00 66.05           C  
ATOM    605  CD2 LEU A  72      59.005  23.501  53.455  1.00 67.08           C  
ATOM    606  N   SER A  73      59.722  26.692  49.119  1.00 64.86           N  
ATOM    607  CA  SER A  73      60.044  27.770  48.166  1.00 65.08           C  
ATOM    608  C   SER A  73      60.738  28.973  48.795  1.00 65.09           C  
ATOM    609  O   SER A  73      61.560  29.602  48.148  1.00 65.58           O  
ATOM    610  CB  SER A  73      58.799  28.219  47.403  1.00 65.03           C  
ATOM    611  OG  SER A  73      57.806  28.668  48.292  1.00 65.81           O  
ATOM    612  N   ASN A  74      60.404  29.277  50.051  1.00 65.10           N  
ATOM    613  CA  ASN A  74      61.053  30.334  50.841  1.00 64.56           C  
ATOM    614  C   ASN A  74      62.491  30.037  51.202  1.00 64.29           C  
ATOM    615  O   ASN A  74      63.174  30.883  51.776  1.00 64.38           O  
ATOM    616  CB  ASN A  74      60.299  30.533  52.145  1.00 64.67           C  
ATOM    617  CG  ASN A  74      58.961  31.178  51.942  1.00 65.50           C  
ATOM    618  OD1 ASN A  74      58.189  30.777  51.062  1.00 66.17           O  
ATOM    619  ND2 ASN A  74      58.662  32.179  52.763  1.00 66.21           N  
ATOM    620  N   GLY A  75      62.947  28.826  50.893  1.00 64.09           N  
ATOM    621  CA  GLY A  75      64.284  28.376  51.277  1.00 63.61           C  
ATOM    622  C   GLY A  75      64.283  27.805  52.679  1.00 63.28           C  
ATOM    623  O   GLY A  75      65.332  27.454  53.211  1.00 63.39           O  
ATOM    624  N   GLU A  76      63.095  27.719  53.268  1.00 63.04           N  
ATOM    625  CA  GLU A  76      62.914  27.204  54.608  1.00 63.13           C  
ATOM    626  C   GLU A  76      63.057  25.686  54.628  1.00 63.24           C  
ATOM    627  O   GLU A  76      62.323  24.989  53.911  1.00 63.92           O  
ATOM    628  CB  GLU A  76      61.534  27.599  55.127  1.00 63.10           C  
ATOM    629  CG  GLU A  76      61.194  26.934  56.447  1.00 63.48           C  
ATOM    630  CD  GLU A  76      59.866  27.379  56.990  1.00 64.93           C  
ATOM    631  OE1 GLU A  76      59.830  27.771  58.173  1.00 65.58           O  
ATOM    632  OE2 GLU A  76      58.860  27.347  56.245  1.00 65.68           O  
ATOM    633  N   ILE A  77      63.979  25.172  55.445  1.00 62.94           N  
ATOM    634  CA  ILE A  77      64.176  23.717  55.576  1.00 62.64           C  
ATOM    635  C   ILE A  77      63.378  23.117  56.746  1.00 62.75           C  
ATOM    636  O   ILE A  77      63.644  23.401  57.919  1.00 62.47           O  
ATOM    637  CB  ILE A  77      65.659  23.365  55.795  1.00 62.55           C  
ATOM    638  CG1 ILE A  77      66.503  23.852  54.615  1.00 61.94           C  
ATOM    639  CG2 ILE A  77      65.828  21.868  56.001  1.00 62.48           C  
ATOM    640  CD1 ILE A  77      67.994  23.764  54.853  1.00 20.00           C  
ATOM    641  N   VAL A  78      62.389  22.292  56.401  1.00 62.88           N  
ATOM    642  CA  VAL A  78      61.736  21.409  57.359  1.00 62.96           C  
ATOM    643  C   VAL A  78      62.540  20.109  57.449  1.00 63.48           C  
ATOM    644  O   VAL A  78      62.905  19.522  56.421  1.00 64.03           O  
ATOM    645  CB  VAL A  78      60.277  21.126  56.973  1.00 62.58           C  
ATOM    646  CG1 VAL A  78      59.743  19.979  57.771  1.00 62.66           C  
ATOM    647  CG2 VAL A  78      59.408  22.365  57.214  1.00 62.48           C  
ATOM    648  N   GLU A  79      62.848  19.680  58.670  1.00 63.51           N  
ATOM    649  CA  GLU A  79      63.577  18.433  58.883  1.00 63.51           C  
ATOM    650  C   GLU A  79      62.619  17.368  59.430  1.00 63.70           C  
ATOM    651  O   GLU A  79      61.752  17.676  60.258  1.00 63.71           O  
ATOM    652  CB  GLU A  79      64.744  18.674  59.845  1.00 63.13           C  
ATOM    653  CG  GLU A  79      65.551  17.435  60.224  1.00 63.21           C  
ATOM    654  CD  GLU A  79      66.523  17.706  61.364  1.00 63.53           C  
ATOM    655  OE1 GLU A  79      66.131  18.376  62.334  1.00 64.01           O  
ATOM    656  OE2 GLU A  79      67.683  17.257  61.301  1.00 63.52           O  
ATOM    657  N   LEU A  80      62.758  16.129  58.967  1.00 63.75           N  
ATOM    658  CA  LEU A  80      61.991  15.033  59.557  1.00 63.91           C  
ATOM    659  C   LEU A  80      62.903  13.935  60.004  1.00 64.13           C  
ATOM    660  O   LEU A  80      63.683  13.411  59.204  1.00 63.99           O  
ATOM    661  CB  LEU A  80      61.018  14.399  58.573  1.00 63.68           C  
ATOM    662  CG  LEU A  80      60.193  15.223  57.611  1.00 63.74           C  
ATOM    663  CD1 LEU A  80      59.852  14.340  56.453  1.00 64.39           C  
ATOM    664  CD2 LEU A  80      58.948  15.765  58.271  1.00 63.15           C  
ATOM    665  N   LYS A  81      62.777  13.566  61.274  1.00 64.67           N  
ATOM    666  CA  LYS A  81      63.392  12.343  61.783  1.00 64.87           C  
ATOM    667  C   LYS A  81      62.532  11.146  61.384  1.00 65.09           C  
ATOM    668  O   LYS A  81      61.312  11.271  61.213  1.00 64.74           O  
ATOM    669  CB  LYS A  81      63.590  12.393  63.302  1.00 64.90           C  
ATOM    670  CG  LYS A  81      64.410  13.575  63.803  1.00 64.26           C  
ATOM    671  CD  LYS A  81      64.693  13.452  65.295  1.00 64.82           C  
ATOM    672  CE  LYS A  81      64.568  14.808  65.977  1.00 66.23           C  
ATOM    673  NZ  LYS A  81      65.625  15.076  67.008  1.00 66.54           N  
ATOM    674  N   ARG A  82      63.207  10.005  61.222  1.00 65.54           N  
ATOM    675  CA  ARG A  82      62.622   8.728  60.800  1.00 65.60           C  
ATOM    676  C   ARG A  82      62.240   7.927  62.050  1.00 65.88           C  
ATOM    677  O   ARG A  82      63.108   7.555  62.830  1.00 65.79           O  
ATOM    678  CB  ARG A  82      63.649   7.966  59.945  1.00 65.18           C  
ATOM    679  CG  ARG A  82      63.231   6.619  59.417  1.00 65.22           C  
ATOM    680  CD  ARG A  82      64.464   5.786  59.079  1.00 66.43           C  
ATOM    681  NE  ARG A  82      64.133   4.561  58.349  1.00 67.07           N  
ATOM    682  CZ  ARG A  82      63.931   3.369  58.916  1.00 67.18           C  
ATOM    683  NH1 ARG A  82      64.024   3.231  60.232  1.00 67.63           N  
ATOM    684  NH2 ARG A  82      63.628   2.311  58.168  1.00 66.35           N  
ATOM    685  N   VAL A  83      60.940   7.694  62.244  1.00 66.44           N  
ATOM    686  CA  VAL A  83      60.423   6.916  63.376  1.00 66.78           C  
ATOM    687  C   VAL A  83      60.728   5.432  63.200  1.00 67.60           C  
ATOM    688  O   VAL A  83      61.359   4.802  64.060  1.00 67.62           O  
ATOM    689  CB  VAL A  83      58.907   7.103  63.512  1.00 66.81           C  
ATOM    690  CG1 VAL A  83      58.252   5.914  64.236  1.00 66.32           C  
ATOM    691  CG2 VAL A  83      58.586   8.435  64.187  1.00 66.27           C  
ATOM    692  N   GLY A  84      60.279   4.879  62.077  1.00 68.23           N  
ATOM    693  CA  GLY A  84      60.520   3.473  61.781  1.00 69.39           C  
ATOM    694  C   GLY A  84      59.387   2.832  61.008  1.00 69.92           C  
ATOM    695  O   GLY A  84      58.339   3.444  60.806  1.00 70.27           O  
ATOM    696  N   GLU A  85      59.601   1.595  60.575  1.00 70.42           N  
ATOM    697  CA  GLU A  85      58.613   0.893  59.790  1.00 71.18           C  
ATOM    698  C   GLU A  85      57.364   0.704  60.671  1.00 72.21           C  
ATOM    699  O   GLU A  85      57.483   0.495  61.884  1.00 72.63           O  
ATOM    700  CB  GLU A  85      59.168  -0.441  59.243  1.00 70.60           C  
ATOM    701  CG  GLU A  85      60.659  -0.421  58.944  1.00 70.78           C  
ATOM    702  CD  GLU A  85      61.041  -1.012  57.599  1.00 70.90           C  
ATOM    703  OE1 GLU A  85      61.350  -2.225  57.538  1.00 68.83           O  
ATOM    704  OE2 GLU A  85      61.077  -0.240  56.605  1.00 72.17           O  
ATOM    705  N   GLU A  86      56.179   0.867  60.073  1.00 72.93           N  
ATOM    706  CA  GLU A  86      54.915   0.458  60.690  1.00 73.56           C  
ATOM    707  C   GLU A  86      54.033  -0.227  59.660  1.00 73.91           C  
ATOM    708  O   GLU A  86      54.138   0.033  58.455  1.00 73.73           O  
ATOM    709  CB  GLU A  86      54.171   1.628  61.305  1.00 73.43           C  
ATOM    710  CG  GLU A  86      54.682   2.042  62.639  1.00 74.55           C  
ATOM    711  CD  GLU A  86      53.860   3.174  63.209  1.00 77.53           C  
ATOM    712  OE1 GLU A  86      52.652   2.957  63.478  1.00 78.43           O  
ATOM    713  OE2 GLU A  86      54.416   4.285  63.387  1.00 78.52           O  
ATOM    714  N   GLU A  87      53.175  -1.114  60.150  1.00 74.35           N  
ATOM    715  CA  GLU A  87      52.331  -1.918  59.297  1.00 74.96           C  
ATOM    716  C   GLU A  87      50.973  -1.243  59.081  1.00 75.73           C  
ATOM    717  O   GLU A  87      50.242  -0.949  60.037  1.00 76.17           O  
ATOM    718  CB  GLU A  87      52.165  -3.302  59.908  1.00 74.95           C  
ATOM    719  CG  GLU A  87      53.435  -4.128  59.912  1.00 74.77           C  
ATOM    720  CD  GLU A  87      53.849  -4.554  58.518  1.00 75.25           C  
ATOM    721  OE1 GLU A  87      53.051  -5.230  57.826  1.00 74.64           O  
ATOM    722  OE2 GLU A  87      54.977  -4.199  58.116  1.00 75.54           O  
ATOM    723  N   PHE A  88      50.642  -0.984  57.824  1.00 76.10           N  
ATOM    724  CA  PHE A  88      49.416  -0.295  57.478  1.00 76.53           C  
ATOM    725  C   PHE A  88      48.231  -1.242  57.650  1.00 77.48           C  
ATOM    726  O   PHE A  88      48.029  -2.147  56.836  1.00 77.80           O  
ATOM    727  CB  PHE A  88      49.529   0.208  56.040  1.00 76.23           C  
ATOM    728  CG  PHE A  88      48.238   0.686  55.451  1.00 75.92           C  
ATOM    729  CD1 PHE A  88      47.754   1.955  55.741  1.00 75.87           C  
ATOM    730  CD2 PHE A  88      47.513  -0.126  54.591  1.00 74.96           C  
ATOM    731  CE1 PHE A  88      46.565   2.399  55.197  1.00 75.47           C  
ATOM    732  CE2 PHE A  88      46.331   0.310  54.051  1.00 74.54           C  
ATOM    733  CZ  PHE A  88      45.855   1.579  54.347  1.00 75.27           C  
ATOM    734  N   ARG A  89      47.458  -1.058  58.717  1.00 78.29           N  
ATOM    735  CA  ARG A  89      46.280  -1.894  58.916  1.00 79.13           C  
ATOM    736  C   ARG A  89      45.145  -1.312  58.062  1.00 78.22           C  
ATOM    737  O   ARG A  89      44.389  -2.066  57.439  1.00 78.55           O  
ATOM    738  CB  ARG A  89      45.921  -2.024  60.405  1.00 79.66           C  
ATOM    739  CG  ARG A  89      46.637  -3.204  61.125  1.00 81.69           C  
ATOM    740  CD  ARG A  89      46.634  -3.140  62.722  1.00 81.54           C  
ATOM    741  NE  ARG A  89      46.976  -4.445  63.356  1.00 86.02           N  
ATOM    742  CZ  ARG A  89      46.970  -4.711  64.682  1.00 90.21           C  
ATOM    743  NH1 ARG A  89      46.626  -3.764  65.571  1.00 91.52           N  
ATOM    744  NH2 ARG A  89      47.305  -5.933  65.140  1.00 89.26           N  
ATOM    745  N   GLY A  90      45.070   0.021  57.986  1.00 77.25           N  
ATOM    746  CA  GLY A  90      44.059   0.716  57.160  1.00 76.08           C  
ATOM    747  C   GLY A  90      44.062   2.247  57.218  1.00 75.19           C  
ATOM    748  O   GLY A  90      44.871   2.857  57.925  1.00 75.43           O  
ATOM    749  N   PHE A  91      43.146   2.869  56.477  1.00 74.05           N  
ATOM    750  CA  PHE A  91      43.008   4.335  56.436  1.00 73.27           C  
ATOM    751  C   PHE A  91      42.143   4.968  57.530  1.00 72.60           C  
ATOM    752  O   PHE A  91      41.105   4.438  57.901  1.00 72.84           O  
ATOM    753  CB  PHE A  91      42.430   4.784  55.085  1.00 73.29           C  
ATOM    754  CG  PHE A  91      43.393   4.688  53.925  1.00 72.95           C  
ATOM    755  CD1 PHE A  91      42.980   4.136  52.724  1.00 72.31           C  
ATOM    756  CD2 PHE A  91      44.694   5.173  54.028  1.00 71.91           C  
ATOM    757  CE1 PHE A  91      43.840   4.058  51.647  1.00 71.86           C  
ATOM    758  CE2 PHE A  91      45.546   5.077  52.980  1.00 70.86           C  
ATOM    759  CZ  PHE A  91      45.113   4.525  51.775  1.00 71.77           C  
ATOM    760  N   GLN A  92      42.547   6.142  57.991  1.00 71.84           N  
ATOM    761  CA  GLN A  92      41.741   6.911  58.935  1.00 71.06           C  
ATOM    762  C   GLN A  92      40.826   7.964  58.271  1.00 69.98           C  
ATOM    763  O   GLN A  92      39.970   8.551  58.931  1.00 70.24           O  
ATOM    764  CB  GLN A  92      42.637   7.576  59.986  1.00 71.08           C  
ATOM    765  CG  GLN A  92      43.419   6.607  60.867  1.00 71.84           C  
ATOM    766  CD  GLN A  92      44.196   7.301  61.990  1.00 71.98           C  
ATOM    767  OE1 GLN A  92      44.004   8.487  62.275  1.00 72.65           O  
ATOM    768  NE2 GLN A  92      45.084   6.553  62.629  1.00 73.99           N  
ATOM    769  N   ASN A  93      40.994   8.229  56.985  1.00 68.70           N  
ATOM    770  CA  ASN A  93      40.116   9.211  56.334  1.00 68.14           C  
ATOM    771  C   ASN A  93      40.406   9.450  54.871  1.00 67.51           C  
ATOM    772  O   ASN A  93      41.522   9.245  54.400  1.00 67.99           O  
ATOM    773  CB  ASN A  93      40.115  10.565  57.060  1.00 68.06           C  
ATOM    774  CG  ASN A  93      41.505  11.071  57.328  1.00 68.48           C  
ATOM    775  OD1 ASN A  93      42.271  11.372  56.402  1.00 68.75           O  
ATOM    776  ND2 ASN A  93      41.861  11.134  58.606  1.00 68.89           N  
ATOM    777  N   GLU A  94      39.394   9.934  54.171  1.00 66.41           N  
ATOM    778  CA  GLU A  94      39.486  10.150  52.768  1.00 65.88           C  
ATOM    779  C   GLU A  94      40.780  10.835  52.450  1.00 65.37           C  
ATOM    780  O   GLU A  94      41.410  10.497  51.459  1.00 65.24           O  
ATOM    781  CB  GLU A  94      38.365  11.046  52.383  1.00 65.90           C  
ATOM    782  CG  GLU A  94      38.002  11.867  53.550  1.00 68.24           C  
ATOM    783  CD  GLU A  94      36.576  12.287  53.498  1.00 73.42           C  
ATOM    784  OE1 GLU A  94      35.875  12.022  54.509  1.00 74.99           O  
ATOM    785  OE2 GLU A  94      36.153  12.846  52.441  1.00 74.47           O  
ATOM    786  N   ARG A  95      41.189  11.784  53.300  1.00 65.08           N  
ATOM    787  CA  ARG A  95      42.319  12.650  52.965  1.00 64.07           C  
ATOM    788  C   ARG A  95      43.565  11.840  52.786  1.00 64.08           C  
ATOM    789  O   ARG A  95      44.256  12.040  51.809  1.00 64.03           O  
ATOM    790  CB  ARG A  95      42.553  13.742  53.983  1.00 63.69           C  
ATOM    791  CG  ARG A  95      43.297  14.944  53.409  1.00 63.32           C  
ATOM    792  CD  ARG A  95      44.420  15.468  54.314  1.00 60.86           C  
ATOM    793  NE  ARG A  95      44.320  14.972  55.682  1.00 60.77           N  
ATOM    794  CZ  ARG A  95      45.206  14.168  56.276  1.00 61.57           C  
ATOM    795  NH1 ARG A  95      46.290  13.772  55.633  1.00 62.84           N  
ATOM    796  NH2 ARG A  95      45.015  13.757  57.527  1.00 60.83           N  
ATOM    797  N   GLU A  96      43.835  10.902  53.698  1.00 64.25           N  
ATOM    798  CA  GLU A  96      45.017  10.024  53.557  1.00 64.67           C  
ATOM    799  C   GLU A  96      44.869   9.158  52.325  1.00 63.62           C  
ATOM    800  O   GLU A  96      45.807   8.980  51.554  1.00 64.17           O  
ATOM    801  CB  GLU A  96      45.217   9.094  54.749  1.00 64.72           C  
ATOM    802  CG  GLU A  96      44.939   9.667  56.131  1.00 66.14           C  
ATOM    803  CD  GLU A  96      45.046   8.591  57.210  1.00 66.77           C  
ATOM    804  OE1 GLU A  96      44.640   7.429  56.932  1.00 69.34           O  
ATOM    805  OE2 GLU A  96      45.546   8.899  58.325  1.00 68.97           O  
ATOM    806  N   CYS A  97      43.676   8.619  52.149  1.00 62.62           N  
ATOM    807  CA  CYS A  97      43.378   7.754  51.031  1.00 61.32           C  
ATOM    808  C   CYS A  97      43.613   8.457  49.703  1.00 60.17           C  
ATOM    809  O   CYS A  97      44.247   7.903  48.829  1.00 59.64           O  
ATOM    810  CB  CYS A  97      41.929   7.309  51.130  1.00 61.50           C  
ATOM    811  SG  CYS A  97      41.485   6.211  49.825  1.00 63.50           S  
ATOM    812  N   GLN A  98      43.090   9.679  49.583  1.00 59.45           N  
ATOM    813  CA  GLN A  98      43.220  10.552  48.415  1.00 58.51           C  
ATOM    814  C   GLN A  98      44.671  10.779  48.074  1.00 58.25           C  
ATOM    815  O   GLN A  98      45.074  10.716  46.901  1.00 57.98           O  
ATOM    816  CB  GLN A  98      42.559  11.911  48.705  1.00 58.42           C  
ATOM    817  CG  GLN A  98      42.429  12.867  47.496  1.00 58.52           C  
ATOM    818  CD  GLN A  98      41.453  14.028  47.718  1.00 58.72           C  
ATOM    819  OE1 GLN A  98      41.836  15.189  47.688  1.00 60.98           O  
ATOM    820  NE2 GLN A  98      40.190  13.713  47.942  1.00 60.33           N  
ATOM    821  N   GLU A  99      45.462  11.049  49.102  1.00 57.90           N  
ATOM    822  CA  GLU A  99      46.825  11.428  48.875  1.00 58.44           C  
ATOM    823  C   GLU A  99      47.533  10.248  48.250  1.00 58.52           C  
ATOM    824  O   GLU A  99      47.916  10.292  47.088  1.00 58.84           O  
ATOM    825  CB  GLU A  99      47.472  11.877  50.169  1.00 58.39           C  
ATOM    826  CG  GLU A  99      47.011  13.253  50.583  1.00 60.63           C  
ATOM    827  CD  GLU A  99      47.261  13.553  52.062  1.00 64.95           C  
ATOM    828  OE1 GLU A  99      48.064  12.823  52.701  1.00 65.63           O  
ATOM    829  OE2 GLU A  99      46.654  14.530  52.575  1.00 65.73           O  
ATOM    830  N   LEU A 100      47.638   9.170  49.009  1.00 58.57           N  
ATOM    831  CA  LEU A 100      48.293   7.964  48.549  1.00 58.39           C  
ATOM    832  C   LEU A 100      47.853   7.545  47.152  1.00 58.62           C  
ATOM    833  O   LEU A 100      48.710   7.242  46.318  1.00 59.10           O  
ATOM    834  CB  LEU A 100      48.041   6.837  49.534  1.00 57.91           C  
ATOM    835  CG  LEU A 100      48.995   5.680  49.356  1.00 57.59           C  
ATOM    836  CD1 LEU A 100      50.262   5.889  50.196  1.00 58.84           C  
ATOM    837  CD2 LEU A 100      48.291   4.476  49.802  1.00 57.26           C  
ATOM    838  N   PHE A 101      46.540   7.552  46.900  1.00 58.42           N  
ATOM    839  CA  PHE A 101      45.997   7.156  45.602  1.00 59.05           C  
ATOM    840  C   PHE A 101      46.501   8.010  44.456  1.00 59.67           C  
ATOM    841  O   PHE A 101      46.972   7.472  43.451  1.00 59.41           O  
ATOM    842  CB  PHE A 101      44.475   7.179  45.589  1.00 59.50           C  
ATOM    843  CG  PHE A 101      43.879   6.844  44.248  1.00 59.87           C  
ATOM    844  CD1 PHE A 101      43.859   5.529  43.783  1.00 61.24           C  
ATOM    845  CD2 PHE A 101      43.346   7.831  43.449  1.00 60.82           C  
ATOM    846  CE1 PHE A 101      43.313   5.206  42.534  1.00 60.43           C  
ATOM    847  CE2 PHE A 101      42.789   7.517  42.184  1.00 61.22           C  
ATOM    848  CZ  PHE A 101      42.784   6.209  41.734  1.00 60.81           C  
ATOM    849  N   ARG A 102      46.392   9.338  44.600  1.00 60.17           N  
ATOM    850  CA  ARG A 102      46.951  10.257  43.597  1.00 60.17           C  
ATOM    851  C   ARG A 102      48.404   9.936  43.323  1.00 60.18           C  
ATOM    852  O   ARG A 102      48.765   9.811  42.178  1.00 59.96           O  
ATOM    853  CB  ARG A 102      46.780  11.723  43.987  1.00 59.84           C  
ATOM    854  CG  ARG A 102      45.339  12.213  44.001  1.00 60.33           C  
ATOM    855  CD  ARG A 102      45.294  13.722  43.948  1.00 60.73           C  
ATOM    856  NE  ARG A 102      43.944  14.276  43.935  1.00 63.66           N  
ATOM    857  CZ  ARG A 102      43.588  15.448  44.491  1.00 65.36           C  
ATOM    858  NH1 ARG A 102      44.490  16.187  45.126  1.00 65.24           N  
ATOM    859  NH2 ARG A 102      42.326  15.899  44.412  1.00 63.45           N  
ATOM    860  N   ASP A 103      49.209   9.762  44.374  1.00 61.16           N  
ATOM    861  CA  ASP A 103      50.655   9.526  44.261  1.00 62.74           C  
ATOM    862  C   ASP A 103      50.906   8.280  43.406  1.00 63.37           C  
ATOM    863  O   ASP A 103      51.869   8.210  42.594  1.00 62.63           O  
ATOM    864  CB  ASP A 103      51.267   9.258  45.641  1.00 63.23           C  
ATOM    865  CG  ASP A 103      51.798  10.512  46.339  1.00 65.36           C  
ATOM    866  OD1 ASP A 103      51.308  11.643  46.070  1.00 67.56           O  
ATOM    867  OD2 ASP A 103      52.699  10.338  47.209  1.00 66.44           O  
ATOM    868  N   PHE A 104      50.032   7.288  43.617  1.00 63.45           N  
ATOM    869  CA  PHE A 104      50.101   6.056  42.856  1.00 63.64           C  
ATOM    870  C   PHE A 104      49.800   6.260  41.377  1.00 64.34           C  
ATOM    871  O   PHE A 104      50.393   5.588  40.536  1.00 65.02           O  
ATOM    872  CB  PHE A 104      49.179   5.022  43.438  1.00 62.77           C  
ATOM    873  CG  PHE A 104      49.828   4.147  44.464  1.00 62.59           C  
ATOM    874  CD1 PHE A 104      49.569   4.333  45.827  1.00 60.99           C  
ATOM    875  CD2 PHE A 104      50.680   3.112  44.074  1.00 59.79           C  
ATOM    876  CE1 PHE A 104      50.148   3.497  46.779  1.00 59.43           C  
ATOM    877  CE2 PHE A 104      51.253   2.286  45.022  1.00 58.18           C  
ATOM    878  CZ  PHE A 104      50.988   2.476  46.373  1.00 59.01           C  
ATOM    879  N   LEU A 105      48.912   7.201  41.052  1.00 64.70           N  
ATOM    880  CA  LEU A 105      48.655   7.551  39.658  1.00 64.68           C  
ATOM    881  C   LEU A 105      49.902   8.149  39.086  1.00 64.95           C  
ATOM    882  O   LEU A 105      50.313   7.803  37.964  1.00 64.85           O  
ATOM    883  CB  LEU A 105      47.518   8.546  39.550  1.00 64.49           C  
ATOM    884  CG  LEU A 105      46.230   7.933  40.080  1.00 65.28           C  
ATOM    885  CD1 LEU A 105      45.209   9.014  40.305  1.00 64.72           C  
ATOM    886  CD2 LEU A 105      45.744   6.819  39.102  1.00 66.93           C  
ATOM    887  N   THR A 106      50.521   9.020  39.882  1.00 64.93           N  
ATOM    888  CA  THR A 106      51.650   9.747  39.403  1.00 65.75           C  
ATOM    889  C   THR A 106      52.749   8.760  39.128  1.00 66.33           C  
ATOM    890  O   THR A 106      53.425   8.846  38.089  1.00 66.50           O  
ATOM    891  CB  THR A 106      52.131  10.781  40.396  1.00 66.12           C  
ATOM    892  OG1 THR A 106      51.119  11.779  40.565  1.00 66.81           O  
ATOM    893  CG2 THR A 106      53.447  11.464  39.888  1.00 66.55           C  
ATOM    894  N   LYS A 107      52.917   7.808  40.052  1.00 66.81           N  
ATOM    895  CA  LYS A 107      54.046   6.875  39.964  1.00 66.17           C  
ATOM    896  C   LYS A 107      53.854   6.039  38.738  1.00 65.44           C  
ATOM    897  O   LYS A 107      54.821   5.678  38.101  1.00 65.66           O  
ATOM    898  CB  LYS A 107      54.191   5.984  41.201  1.00 66.12           C  
ATOM    899  CG  LYS A 107      55.651   5.568  41.502  1.00 68.11           C  
ATOM    900  CD  LYS A 107      55.819   4.018  41.792  1.00 71.68           C  
ATOM    901  CE  LYS A 107      55.292   3.532  43.195  1.00 70.14           C  
ATOM    902  NZ  LYS A 107      55.060   2.049  43.309  1.00 67.08           N  
ATOM    903  N   THR A 108      52.608   5.759  38.371  1.00 65.03           N  
ATOM    904  CA  THR A 108      52.394   4.758  37.321  1.00 64.60           C  
ATOM    905  C   THR A 108      52.228   5.348  35.939  1.00 63.82           C  
ATOM    906  O   THR A 108      52.515   4.695  34.947  1.00 63.22           O  
ATOM    907  CB  THR A 108      51.260   3.780  37.661  1.00 64.62           C  
ATOM    908  OG1 THR A 108      50.026   4.487  37.712  1.00 65.25           O  
ATOM    909  CG2 THR A 108      51.525   3.082  39.005  1.00 64.21           C  
ATOM    910  N   LYS A 109      51.788   6.599  35.893  1.00 63.50           N  
ATOM    911  CA  LYS A 109      51.775   7.382  34.658  1.00 63.11           C  
ATOM    912  C   LYS A 109      50.535   7.206  33.776  1.00 63.16           C  
ATOM    913  O   LYS A 109      50.572   7.533  32.590  1.00 62.86           O  
ATOM    914  CB  LYS A 109      53.039   7.111  33.858  1.00 62.61           C  
ATOM    915  CG  LYS A 109      54.208   7.940  34.314  1.00 63.62           C  
ATOM    916  CD  LYS A 109      55.067   8.367  33.130  1.00 65.51           C  
ATOM    917  CE  LYS A 109      56.512   8.496  33.557  1.00 66.71           C  
ATOM    918  NZ  LYS A 109      57.392   8.299  32.387  1.00 68.27           N  
ATOM    919  N   VAL A 110      49.437   6.723  34.376  1.00 63.38           N  
ATOM    920  CA  VAL A 110      48.239   6.278  33.657  1.00 62.99           C  
ATOM    921  C   VAL A 110      47.497   7.458  33.123  1.00 63.59           C  
ATOM    922  O   VAL A 110      47.295   7.572  31.922  1.00 64.13           O  
ATOM    923  CB  VAL A 110      47.283   5.590  34.571  1.00 62.72           C  
ATOM    924  CG1 VAL A 110      46.531   4.486  33.815  1.00 62.53           C  
ATOM    925  CG2 VAL A 110      48.027   5.073  35.783  1.00 62.28           C  
ATOM    926  N   LYS A 111      47.071   8.316  34.040  1.00 64.21           N  
ATOM    927  CA  LYS A 111      46.546   9.636  33.728  1.00 64.86           C  
ATOM    928  C   LYS A 111      47.364  10.252  32.568  1.00 65.74           C  
ATOM    929  O   LYS A 111      46.803  10.830  31.618  1.00 65.73           O  
ATOM    930  CB  LYS A 111      46.612  10.508  34.992  1.00 64.44           C  
ATOM    931  CG  LYS A 111      45.884  11.828  34.929  1.00 62.90           C  
ATOM    932  CD  LYS A 111      45.537  12.263  36.342  1.00 61.63           C  
ATOM    933  CE  LYS A 111      44.780  13.589  36.343  1.00 61.38           C  
ATOM    934  NZ  LYS A 111      44.211  13.921  37.694  1.00 57.79           N  
ATOM    935  N   ASP A 112      48.683  10.092  32.635  1.00 66.28           N  
ATOM    936  CA  ASP A 112      49.527  10.590  31.580  1.00 67.48           C  
ATOM    937  C   ASP A 112      49.335   9.830  30.284  1.00 67.86           C  
ATOM    938  O   ASP A 112      49.110  10.433  29.230  1.00 67.55           O  
ATOM    939  CB  ASP A 112      50.981  10.512  31.996  1.00 67.84           C  
ATOM    940  CG  ASP A 112      51.403  11.685  32.784  1.00 69.08           C  
ATOM    941  OD1 ASP A 112      50.512  12.454  33.229  1.00 70.97           O  
ATOM    942  OD2 ASP A 112      52.630  11.830  32.944  1.00 70.11           O  
ATOM    943  N   LYS A 113      49.439   8.507  30.361  1.00 68.51           N  
ATOM    944  CA  LYS A 113      49.369   7.716  29.165  1.00 69.79           C  
ATOM    945  C   LYS A 113      48.014   7.975  28.554  1.00 70.40           C  
ATOM    946  O   LYS A 113      47.865   7.927  27.334  1.00 71.15           O  
ATOM    947  CB  LYS A 113      49.584   6.235  29.445  1.00 69.43           C  
ATOM    948  CG  LYS A 113      49.889   5.410  28.184  1.00 70.36           C  
ATOM    949  CD  LYS A 113      50.294   3.982  28.537  1.00 71.29           C  
ATOM    950  CE  LYS A 113      49.636   2.953  27.584  1.00 74.71           C  
ATOM    951  NZ  LYS A 113      48.174   2.660  27.893  1.00 72.66           N  
ATOM    952  N   PHE A 114      47.039   8.310  29.401  1.00 70.90           N  
ATOM    953  CA  PHE A 114      45.696   8.588  28.939  1.00 70.82           C  
ATOM    954  C   PHE A 114      45.519   9.890  28.195  1.00 71.44           C  
ATOM    955  O   PHE A 114      44.911   9.916  27.140  1.00 71.55           O  
ATOM    956  CB  PHE A 114      44.700   8.572  30.070  1.00 70.49           C  
ATOM    957  CG  PHE A 114      43.353   9.007  29.631  1.00 71.15           C  
ATOM    958  CD1 PHE A 114      42.586   8.186  28.805  1.00 71.04           C  
ATOM    959  CD2 PHE A 114      42.871  10.269  29.959  1.00 71.76           C  
ATOM    960  CE1 PHE A 114      41.335   8.611  28.345  1.00 70.53           C  
ATOM    961  CE2 PHE A 114      41.629  10.690  29.503  1.00 72.08           C  
ATOM    962  CZ  PHE A 114      40.863   9.852  28.688  1.00 70.39           C  
ATOM    963  N   ILE A 115      45.995  10.995  28.746  1.00 72.53           N  
ATOM    964  CA  ILE A 115      45.873  12.248  28.009  1.00 73.73           C  
ATOM    965  C   ILE A 115      46.617  12.171  26.663  1.00 74.85           C  
ATOM    966  O   ILE A 115      46.264  12.868  25.684  1.00 75.31           O  
ATOM    967  CB  ILE A 115      46.303  13.458  28.853  1.00 73.66           C  
ATOM    968  CG1 ILE A 115      45.103  13.962  29.646  1.00 73.79           C  
ATOM    969  CG2 ILE A 115      46.805  14.607  27.958  1.00 73.84           C  
ATOM    970  CD1 ILE A 115      45.308  13.947  31.119  1.00 74.45           C  
ATOM    971  N   SER A 116      47.631  11.309  26.615  1.00 75.43           N  
ATOM    972  CA  SER A 116      48.374  11.107  25.402  1.00 76.27           C  
ATOM    973  C   SER A 116      47.545  10.384  24.342  1.00 76.53           C  
ATOM    974  O   SER A 116      47.343  10.901  23.238  1.00 76.61           O  
ATOM    975  CB  SER A 116      49.673  10.387  25.708  1.00 76.57           C  
ATOM    976  OG  SER A 116      50.596  11.325  26.233  1.00 77.91           O  
ATOM    977  N   ASP A 117      47.050   9.205  24.702  1.00 76.91           N  
ATOM    978  CA  ASP A 117      46.222   8.394  23.822  1.00 77.44           C  
ATOM    979  C   ASP A 117      45.055   9.213  23.285  1.00 77.67           C  
ATOM    980  O   ASP A 117      44.738   9.180  22.095  1.00 77.76           O  
ATOM    981  CB  ASP A 117      45.724   7.134  24.560  1.00 77.58           C  
ATOM    982  CG  ASP A 117      46.825   6.065  24.747  1.00 78.76           C  
ATOM    983  OD1 ASP A 117      47.890   6.107  24.084  1.00 80.24           O  
ATOM    984  OD2 ASP A 117      46.623   5.159  25.573  1.00 80.27           O  
ATOM    985  N   PHE A 118      44.436   9.979  24.171  1.00 78.24           N  
ATOM    986  CA  PHE A 118      43.298  10.775  23.798  1.00 78.39           C  
ATOM    987  C   PHE A 118      43.590  11.810  22.714  1.00 78.68           C  
ATOM    988  O   PHE A 118      42.763  12.032  21.834  1.00 78.48           O  
ATOM    989  CB  PHE A 118      42.708  11.460  25.005  1.00 78.21           C  
ATOM    990  CG  PHE A 118      41.418  12.128  24.702  1.00 78.71           C  
ATOM    991  CD1 PHE A 118      40.222  11.429  24.820  1.00 78.21           C  
ATOM    992  CD2 PHE A 118      41.392  13.437  24.235  1.00 78.35           C  
ATOM    993  CE1 PHE A 118      39.033  12.027  24.518  1.00 77.51           C  
ATOM    994  CE2 PHE A 118      40.201  14.037  23.927  1.00 78.41           C  
ATOM    995  CZ  PHE A 118      39.019  13.335  24.071  1.00 78.11           C  
ATOM    996  N   TYR A 119      44.746  12.460  22.801  1.00 79.41           N  
ATOM    997  CA  TYR A 119      45.233  13.310  21.716  1.00 80.04           C  
ATOM    998  C   TYR A 119      45.512  12.512  20.430  1.00 80.47           C  
ATOM    999  O   TYR A 119      44.920  12.774  19.383  1.00 80.07           O  
ATOM   1000  CB  TYR A 119      46.471  14.067  22.168  1.00 80.21           C  
ATOM   1001  CG  TYR A 119      46.171  15.436  22.708  1.00 80.47           C  
ATOM   1002  CD1 TYR A 119      45.966  15.648  24.071  1.00 80.44           C  
ATOM   1003  CD2 TYR A 119      46.098  16.531  21.851  1.00 80.72           C  
ATOM   1004  CE1 TYR A 119      45.688  16.933  24.560  1.00 80.39           C  
ATOM   1005  CE2 TYR A 119      45.828  17.806  22.328  1.00 81.05           C  
ATOM   1006  CZ  TYR A 119      45.623  17.998  23.676  1.00 80.53           C  
ATOM   1007  OH  TYR A 119      45.350  19.265  24.118  1.00 81.42           O  
ATOM   1008  N   LYS A 120      46.384  11.514  20.521  1.00 81.19           N  
ATOM   1009  CA  LYS A 120      46.644  10.653  19.382  1.00 82.54           C  
ATOM   1010  C   LYS A 120      45.347  10.347  18.641  1.00 83.63           C  
ATOM   1011  O   LYS A 120      45.355  10.161  17.429  1.00 84.16           O  
ATOM   1012  CB  LYS A 120      47.339   9.347  19.802  1.00 82.47           C  
ATOM   1013  CG  LYS A 120      48.821   9.489  20.247  1.00 82.67           C  
ATOM   1014  CD  LYS A 120      49.474   8.123  20.578  1.00 82.27           C  
ATOM   1015  CE  LYS A 120      50.852   8.273  21.250  1.00 81.86           C  
ATOM   1016  NZ  LYS A 120      51.907   7.332  20.711  1.00 78.88           N  
ATOM   1017  N   LYS A 121      44.233  10.325  19.365  1.00 84.76           N  
ATOM   1018  CA  LYS A 121      42.953   9.948  18.773  1.00 86.11           C  
ATOM   1019  C   LYS A 121      42.100  11.117  18.311  1.00 86.53           C  
ATOM   1020  O   LYS A 121      41.562  11.078  17.209  1.00 86.89           O  
ATOM   1021  CB  LYS A 121      42.136   9.071  19.732  1.00 86.43           C  
ATOM   1022  CG  LYS A 121      40.992   8.313  19.060  1.00 88.14           C  
ATOM   1023  CD  LYS A 121      40.715   6.982  19.783  1.00 92.03           C  
ATOM   1024  CE  LYS A 121      40.094   5.911  18.838  1.00 93.67           C  
ATOM   1025  NZ  LYS A 121      38.990   5.112  19.514  1.00 93.89           N  
ATOM   1026  N   PHE A 122      41.959  12.144  19.142  1.00 86.94           N  
ATOM   1027  CA  PHE A 122      40.999  13.188  18.846  1.00 87.25           C  
ATOM   1028  C   PHE A 122      41.646  14.524  18.706  1.00 87.54           C  
ATOM   1029  O   PHE A 122      40.959  15.528  18.695  1.00 87.57           O  
ATOM   1030  CB  PHE A 122      39.886  13.222  19.894  1.00 87.43           C  
ATOM   1031  CG  PHE A 122      39.088  11.949  19.953  1.00 88.21           C  
ATOM   1032  CD1 PHE A 122      39.122  11.143  21.083  1.00 88.70           C  
ATOM   1033  CD2 PHE A 122      38.328  11.531  18.861  1.00 89.77           C  
ATOM   1034  CE1 PHE A 122      38.400   9.941  21.134  1.00 89.16           C  
ATOM   1035  CE2 PHE A 122      37.601  10.322  18.895  1.00 90.37           C  
ATOM   1036  CZ  PHE A 122      37.642   9.527  20.036  1.00 89.34           C  
ATOM   1037  N   ARG A 123      42.968  14.527  18.551  1.00 88.34           N  
ATOM   1038  CA  ARG A 123      43.758  15.760  18.507  1.00 88.94           C  
ATOM   1039  C   ARG A 123      43.127  16.777  17.596  1.00 89.91           C  
ATOM   1040  O   ARG A 123      42.942  17.930  17.971  1.00 90.24           O  
ATOM   1041  CB  ARG A 123      45.177  15.484  18.022  1.00 88.93           C  
ATOM   1042  CG  ARG A 123      46.190  16.578  18.367  1.00 88.75           C  
ATOM   1043  CD  ARG A 123      47.575  16.327  17.740  1.00 88.12           C  
ATOM   1044  NE  ARG A 123      47.942  14.910  17.727  1.00 86.19           N  
ATOM   1045  CZ  ARG A 123      48.660  14.293  18.661  1.00 85.19           C  
ATOM   1046  NH1 ARG A 123      49.119  14.947  19.701  1.00 85.00           N  
ATOM   1047  NH2 ARG A 123      48.938  13.008  18.542  1.00 85.58           N  
ATOM   1048  N   ASP A 124      42.774  16.331  16.402  1.00 91.01           N  
ATOM   1049  CA  ASP A 124      42.276  17.219  15.368  1.00 92.25           C  
ATOM   1050  C   ASP A 124      40.935  17.825  15.735  1.00 92.76           C  
ATOM   1051  O   ASP A 124      40.780  19.041  15.713  1.00 92.92           O  
ATOM   1052  CB  ASP A 124      42.252  16.463  14.057  1.00 92.39           C  
ATOM   1053  CG  ASP A 124      43.506  15.617  13.886  1.00 93.82           C  
ATOM   1054  OD1 ASP A 124      44.498  16.138  13.315  1.00 93.99           O  
ATOM   1055  OD2 ASP A 124      43.518  14.462  14.395  1.00 94.95           O  
ATOM   1056  N   LYS A 125      39.994  16.984  16.138  1.00 93.70           N  
ATOM   1057  CA  LYS A 125      38.688  17.446  16.638  1.00 94.85           C  
ATOM   1058  C   LYS A 125      38.691  18.331  17.916  1.00 95.10           C  
ATOM   1059  O   LYS A 125      37.622  18.769  18.366  1.00 95.17           O  
ATOM   1060  CB  LYS A 125      37.749  16.240  16.820  1.00 95.15           C  
ATOM   1061  CG  LYS A 125      36.962  15.906  15.563  1.00 96.06           C  
ATOM   1062  CD  LYS A 125      36.873  14.424  15.325  1.00 97.09           C  
ATOM   1063  CE  LYS A 125      36.870  14.171  13.836  1.00 98.18           C  
ATOM   1064  NZ  LYS A 125      36.849  12.717  13.549  1.00 99.83           N  
ATOM   1065  N   ILE A 126      39.879  18.599  18.470  1.00 95.41           N  
ATOM   1066  CA  ILE A 126      40.058  19.290  19.765  1.00 95.36           C  
ATOM   1067  C   ILE A 126      40.530  20.737  19.613  1.00 95.54           C  
ATOM   1068  O   ILE A 126      40.372  21.552  20.520  1.00 95.28           O  
ATOM   1069  CB  ILE A 126      41.087  18.535  20.624  1.00 95.30           C  
ATOM   1070  CG1 ILE A 126      40.439  17.357  21.325  1.00 94.25           C  
ATOM   1071  CG2 ILE A 126      41.789  19.457  21.641  1.00 95.91           C  
ATOM   1072  CD1 ILE A 126      41.472  16.408  21.850  1.00 93.79           C  
ATOM   1073  N   THR A 127      41.144  21.028  18.473  1.00 96.15           N  
ATOM   1074  CA  THR A 127      41.565  22.377  18.128  1.00 96.49           C  
ATOM   1075  C   THR A 127      40.456  22.988  17.276  1.00 97.19           C  
ATOM   1076  O   THR A 127      39.836  22.292  16.479  1.00 97.33           O  
ATOM   1077  CB  THR A 127      42.881  22.355  17.327  1.00 96.38           C  
ATOM   1078  OG1 THR A 127      43.369  21.008  17.229  1.00 94.89           O  
ATOM   1079  CG2 THR A 127      43.925  23.249  17.986  1.00 95.52           C  
ATOM   1080  N   VAL A 128      40.202  24.279  17.441  1.00 98.13           N  
ATOM   1081  CA  VAL A 128      39.058  24.935  16.788  1.00 99.21           C  
ATOM   1082  C   VAL A 128      39.379  26.406  16.406  1.00 99.63           C  
ATOM   1083  O   VAL A 128      39.960  27.141  17.212  1.00 99.99           O  
ATOM   1084  CB  VAL A 128      37.781  24.808  17.706  1.00 99.22           C  
ATOM   1085  CG1 VAL A 128      36.779  25.917  17.453  1.00 99.81           C  
ATOM   1086  CG2 VAL A 128      37.108  23.432  17.546  1.00 99.21           C  
ATOM   1087  N   GLN A 129      39.009  26.833  15.195  1.00100.13           N  
ATOM   1088  CA  GLN A 129      39.268  28.232  14.723  1.00100.79           C  
ATOM   1089  C   GLN A 129      38.228  29.332  15.029  1.00100.90           C  
ATOM   1090  O   GLN A 129      37.467  29.271  16.011  1.00101.10           O  
ATOM   1091  CB  GLN A 129      39.550  28.248  13.220  1.00100.79           C  
ATOM   1092  CG  GLN A 129      40.938  28.738  12.874  1.00101.51           C  
ATOM   1093  CD  GLN A 129      41.644  27.819  11.897  1.00102.13           C  
ATOM   1094  OE1 GLN A 129      41.028  26.934  11.303  1.00102.96           O  
ATOM   1095  NE2 GLN A 129      42.948  28.016  11.734  1.00102.00           N  
ATOM   1096  N   GLY A 130      38.221  30.349  14.173  1.00100.89           N  
ATOM   1097  CA  GLY A 130      37.280  31.453  14.303  1.00101.21           C  
ATOM   1098  C   GLY A 130      37.949  32.800  14.117  1.00101.41           C  
ATOM   1099  O   GLY A 130      38.543  33.331  15.067  1.00101.52           O  
ATOM   1100  N   LYS A 131      37.828  33.338  12.893  1.00101.23           N  
ATOM   1101  CA  LYS A 131      38.424  34.627  12.425  1.00101.07           C  
ATOM   1102  C   LYS A 131      39.925  34.867  12.715  1.00100.75           C  
ATOM   1103  O   LYS A 131      40.767  34.591  11.851  1.00100.43           O  
ATOM   1104  CB  LYS A 131      37.557  35.869  12.774  1.00100.99           C  
ATOM   1105  CG  LYS A 131      37.584  36.291  14.245  1.00101.73           C  
ATOM   1106  CD  LYS A 131      37.427  37.788  14.450  1.00101.84           C  
ATOM   1107  CE  LYS A 131      37.614  38.110  15.923  1.00101.37           C  
ATOM   1108  NZ  LYS A 131      37.291  39.526  16.213  1.00102.50           N  
ATOM   1109  N   ASN A 132      40.243  35.380  13.909  1.00100.54           N  
ATOM   1110  CA  ASN A 132      41.620  35.735  14.270  1.00100.26           C  
ATOM   1111  C   ASN A 132      42.328  34.754  15.203  1.00 99.73           C  
ATOM   1112  O   ASN A 132      43.338  34.182  14.810  1.00 99.82           O  
ATOM   1113  CB  ASN A 132      41.733  37.190  14.764  1.00100.46           C  
ATOM   1114  CG  ASN A 132      42.170  38.173  13.644  1.00101.36           C  
ATOM   1115  OD1 ASN A 132      41.854  37.986  12.463  1.00102.20           O  
ATOM   1116  ND2 ASN A 132      42.892  39.226  14.029  1.00102.27           N  
ATOM   1117  N   ARG A 133      41.806  34.551  16.413  1.00 99.16           N  
ATOM   1118  CA  ARG A 133      42.422  33.608  17.378  1.00 98.72           C  
ATOM   1119  C   ARG A 133      42.272  32.110  16.976  1.00 97.77           C  
ATOM   1120  O   ARG A 133      41.485  31.760  16.077  1.00 97.72           O  
ATOM   1121  CB  ARG A 133      41.895  33.864  18.813  1.00 98.80           C  
ATOM   1122  CG  ARG A 133      42.906  33.568  19.946  1.00 99.13           C  
ATOM   1123  CD  ARG A 133      42.406  34.073  21.321  1.00 99.56           C  
ATOM   1124  NE  ARG A 133      43.506  34.601  22.150  1.00102.05           N  
ATOM   1125  CZ  ARG A 133      43.416  34.954  23.441  1.00102.72           C  
ATOM   1126  NH1 ARG A 133      42.264  34.839  24.110  1.00103.13           N  
ATOM   1127  NH2 ARG A 133      44.493  35.420  24.077  1.00101.83           N  
ATOM   1128  N   LYS A 134      43.049  31.241  17.627  1.00 96.45           N  
ATOM   1129  CA  LYS A 134      42.840  29.792  17.524  1.00 95.25           C  
ATOM   1130  C   LYS A 134      42.613  29.239  18.934  1.00 93.82           C  
ATOM   1131  O   LYS A 134      42.952  29.914  19.914  1.00 93.71           O  
ATOM   1132  CB  LYS A 134      44.021  29.104  16.829  1.00 95.69           C  
ATOM   1133  CG  LYS A 134      43.645  27.801  16.128  1.00 96.38           C  
ATOM   1134  CD  LYS A 134      44.682  27.409  15.076  1.00 97.44           C  
ATOM   1135  CE  LYS A 134      44.234  26.177  14.260  1.00 98.08           C  
ATOM   1136  NZ  LYS A 134      45.022  25.957  12.983  1.00 97.88           N  
ATOM   1137  N   ILE A 135      42.044  28.032  19.038  1.00 91.88           N  
ATOM   1138  CA  ILE A 135      41.609  27.489  20.341  1.00 90.11           C  
ATOM   1139  C   ILE A 135      41.762  25.973  20.577  1.00 88.70           C  
ATOM   1140  O   ILE A 135      41.453  25.149  19.712  1.00 88.58           O  
ATOM   1141  CB  ILE A 135      40.159  27.963  20.699  1.00 90.30           C  
ATOM   1142  CG1 ILE A 135      40.229  29.226  21.557  1.00 89.51           C  
ATOM   1143  CG2 ILE A 135      39.357  26.874  21.427  1.00 89.91           C  
ATOM   1144  CD1 ILE A 135      38.891  29.715  22.008  1.00 90.07           C  
ATOM   1145  N   ALA A 136      42.233  25.639  21.779  1.00 86.80           N  
ATOM   1146  CA  ALA A 136      42.315  24.269  22.259  1.00 85.10           C  
ATOM   1147  C   ALA A 136      41.324  23.999  23.423  1.00 84.16           C  
ATOM   1148  O   ALA A 136      40.927  24.910  24.163  1.00 83.80           O  
ATOM   1149  CB  ALA A 136      43.736  23.962  22.684  1.00 84.81           C  
ATOM   1150  N   LEU A 137      40.923  22.733  23.554  1.00 82.75           N  
ATOM   1151  CA  LEU A 137      40.118  22.242  24.675  1.00 81.12           C  
ATOM   1152  C   LEU A 137      40.777  20.992  25.214  1.00 79.56           C  
ATOM   1153  O   LEU A 137      40.654  19.932  24.607  1.00 79.58           O  
ATOM   1154  CB  LEU A 137      38.733  21.819  24.200  1.00 81.47           C  
ATOM   1155  CG  LEU A 137      38.107  22.498  22.999  1.00 81.46           C  
ATOM   1156  CD1 LEU A 137      37.259  21.474  22.274  1.00 82.15           C  
ATOM   1157  CD2 LEU A 137      37.278  23.652  23.491  1.00 81.62           C  
ATOM   1158  N   ILE A 138      41.453  21.090  26.350  1.00 77.38           N  
ATOM   1159  CA  ILE A 138      42.324  19.998  26.770  1.00 74.92           C  
ATOM   1160  C   ILE A 138      41.693  19.156  27.873  1.00 73.56           C  
ATOM   1161  O   ILE A 138      41.165  19.700  28.834  1.00 74.38           O  
ATOM   1162  CB  ILE A 138      43.647  20.554  27.180  1.00 74.59           C  
ATOM   1163  CG1 ILE A 138      44.082  21.588  26.135  1.00 74.16           C  
ATOM   1164  CG2 ILE A 138      44.633  19.441  27.252  1.00 74.83           C  
ATOM   1165  CD1 ILE A 138      44.957  22.675  26.651  1.00 73.57           C  
ATOM   1166  N   PRO A 139      41.707  17.824  27.734  1.00 71.78           N  
ATOM   1167  CA  PRO A 139      40.967  17.045  28.719  1.00 70.22           C  
ATOM   1168  C   PRO A 139      41.660  17.124  30.040  1.00 68.97           C  
ATOM   1169  O   PRO A 139      42.886  17.125  30.077  1.00 68.79           O  
ATOM   1170  CB  PRO A 139      41.056  15.624  28.180  1.00 70.43           C  
ATOM   1171  CG  PRO A 139      42.312  15.617  27.354  1.00 71.16           C  
ATOM   1172  CD  PRO A 139      42.361  16.969  26.728  1.00 71.85           C  
ATOM   1173  N   GLU A 140      40.875  17.218  31.104  1.00 67.92           N  
ATOM   1174  CA  GLU A 140      41.367  17.265  32.480  1.00 67.67           C  
ATOM   1175  C   GLU A 140      40.757  16.101  33.237  1.00 66.97           C  
ATOM   1176  O   GLU A 140      39.523  15.985  33.292  1.00 67.13           O  
ATOM   1177  CB  GLU A 140      40.868  18.522  33.197  1.00 67.61           C  
ATOM   1178  CG  GLU A 140      41.647  19.814  33.046  1.00 68.29           C  
ATOM   1179  CD  GLU A 140      41.114  20.927  33.975  1.00 69.25           C  
ATOM   1180  OE1 GLU A 140      40.168  20.654  34.772  1.00 71.22           O  
ATOM   1181  OE2 GLU A 140      41.635  22.078  33.904  1.00 71.39           O  
ATOM   1182  N   VAL A 141      41.588  15.257  33.845  1.00 66.05           N  
ATOM   1183  CA  VAL A 141      41.084  14.166  34.677  1.00 64.86           C  
ATOM   1184  C   VAL A 141      41.286  14.596  36.096  1.00 65.21           C  
ATOM   1185  O   VAL A 141      42.294  15.188  36.423  1.00 65.97           O  
ATOM   1186  CB  VAL A 141      41.822  12.858  34.389  1.00 64.39           C  
ATOM   1187  CG1 VAL A 141      41.395  11.768  35.315  1.00 62.16           C  
ATOM   1188  CG2 VAL A 141      41.587  12.454  32.954  1.00 64.33           C  
ATOM   1189  N   ASN A 142      40.312  14.319  36.941  1.00 65.72           N  
ATOM   1190  CA  ASN A 142      40.346  14.727  38.338  1.00 66.01           C  
ATOM   1191  C   ASN A 142      39.903  13.591  39.225  1.00 66.36           C  
ATOM   1192  O   ASN A 142      38.942  12.869  38.890  1.00 66.62           O  
ATOM   1193  CB  ASN A 142      39.412  15.921  38.561  1.00 65.88           C  
ATOM   1194  CG  ASN A 142      39.892  17.154  37.850  1.00 66.36           C  
ATOM   1195  OD1 ASN A 142      40.977  17.671  38.137  1.00 66.74           O  
ATOM   1196  ND2 ASN A 142      39.108  17.621  36.884  1.00 66.53           N  
ATOM   1197  N   GLU A 143      40.597  13.441  40.352  1.00 66.46           N  
ATOM   1198  CA  GLU A 143      40.235  12.446  41.358  1.00 67.02           C  
ATOM   1199  C   GLU A 143      40.138  13.075  42.722  1.00 66.43           C  
ATOM   1200  O   GLU A 143      41.015  13.793  43.117  1.00 66.69           O  
ATOM   1201  CB  GLU A 143      41.273  11.304  41.443  1.00 67.27           C  
ATOM   1202  CG  GLU A 143      41.905  10.902  40.161  1.00 68.57           C  
ATOM   1203  CD  GLU A 143      42.894  11.923  39.686  1.00 71.70           C  
ATOM   1204  OE1 GLU A 143      43.407  12.705  40.526  1.00 74.24           O  
ATOM   1205  OE2 GLU A 143      43.151  11.953  38.469  1.00 72.58           O  
ATOM   1206  N   LYS A 144      39.084  12.781  43.450  1.00 66.57           N  
ATOM   1207  CA  LYS A 144      39.051  13.048  44.872  1.00 67.49           C  
ATOM   1208  C   LYS A 144      38.540  11.785  45.521  1.00 67.42           C  
ATOM   1209  O   LYS A 144      37.992  10.918  44.831  1.00 67.61           O  
ATOM   1210  CB  LYS A 144      38.128  14.227  45.214  1.00 67.11           C  
ATOM   1211  CG  LYS A 144      38.740  15.645  45.102  1.00 68.06           C  
ATOM   1212  CD  LYS A 144      37.824  16.730  45.733  1.00 69.24           C  
ATOM   1213  CE  LYS A 144      37.599  16.515  47.307  1.00 74.55           C  
ATOM   1214  NZ  LYS A 144      36.265  17.000  47.872  1.00 71.47           N  
ATOM   1215  N   VAL A 145      38.726  11.667  46.832  1.00 67.60           N  
ATOM   1216  CA  VAL A 145      38.218  10.530  47.574  1.00 67.71           C  
ATOM   1217  C   VAL A 145      37.277  10.967  48.671  1.00 68.75           C  
ATOM   1218  O   VAL A 145      37.592  11.831  49.509  1.00 69.01           O  
ATOM   1219  CB  VAL A 145      39.316   9.727  48.214  1.00 67.40           C  
ATOM   1220  CG1 VAL A 145      38.717   8.501  48.877  1.00 67.10           C  
ATOM   1221  CG2 VAL A 145      40.368   9.340  47.186  1.00 67.67           C  
ATOM   1222  N   LEU A 146      36.116  10.330  48.681  1.00 69.77           N  
ATOM   1223  CA  LEU A 146      35.070  10.632  49.653  1.00 70.46           C  
ATOM   1224  C   LEU A 146      34.637   9.390  50.423  1.00 71.05           C  
ATOM   1225  O   LEU A 146      34.942   8.260  50.035  1.00 71.29           O  
ATOM   1226  CB  LEU A 146      33.867  11.242  48.930  1.00 70.42           C  
ATOM   1227  CG  LEU A 146      34.101  12.226  47.780  1.00 68.49           C  
ATOM   1228  CD1 LEU A 146      32.784  12.479  47.087  1.00 65.47           C  
ATOM   1229  CD2 LEU A 146      34.751  13.526  48.266  1.00 66.67           C  
ATOM   1230  N   LYS A 147      33.913   9.621  51.509  1.00 71.93           N  
ATOM   1231  CA  LYS A 147      33.401   8.561  52.365  1.00 72.89           C  
ATOM   1232  C   LYS A 147      31.864   8.526  52.285  1.00 73.41           C  
ATOM   1233  O   LYS A 147      31.201   9.484  52.618  1.00 73.87           O  
ATOM   1234  CB  LYS A 147      33.863   8.845  53.792  1.00 72.49           C  
ATOM   1235  CG  LYS A 147      34.260   7.632  54.555  1.00 73.54           C  
ATOM   1236  CD  LYS A 147      34.538   7.972  56.004  1.00 75.12           C  
ATOM   1237  CE  LYS A 147      34.798   6.724  56.829  1.00 76.06           C  
ATOM   1238  NZ  LYS A 147      34.236   6.818  58.209  1.00 76.54           N  
ATOM   1239  N   SER A 148      31.294   7.431  51.828  1.00 74.77           N  
ATOM   1240  CA  SER A 148      29.840   7.267  51.853  1.00 76.33           C  
ATOM   1241  C   SER A 148      29.323   7.155  53.287  1.00 77.27           C  
ATOM   1242  O   SER A 148      30.114   7.051  54.238  1.00 77.58           O  
ATOM   1243  CB  SER A 148      29.456   5.971  51.166  1.00 76.22           C  
ATOM   1244  OG  SER A 148      29.775   4.902  52.053  1.00 76.62           O  
ATOM   1245  N   GLU A 149      27.996   7.108  53.416  1.00 77.95           N  
ATOM   1246  CA  GLU A 149      27.317   6.913  54.694  1.00 78.85           C  
ATOM   1247  C   GLU A 149      27.691   5.597  55.360  1.00 78.72           C  
ATOM   1248  O   GLU A 149      27.995   5.563  56.542  1.00 78.83           O  
ATOM   1249  CB  GLU A 149      25.806   6.957  54.493  1.00 78.91           C  
ATOM   1250  CG  GLU A 149      25.034   7.236  55.772  1.00 79.86           C  
ATOM   1251  CD  GLU A 149      23.523   7.083  55.599  1.00 80.50           C  
ATOM   1252  OE1 GLU A 149      23.071   6.464  54.581  1.00 79.51           O  
ATOM   1253  OE2 GLU A 149      22.795   7.593  56.504  1.00 82.63           O  
ATOM   1254  N   GLU A 150      27.676   4.512  54.601  1.00 78.95           N  
ATOM   1255  CA  GLU A 150      28.003   3.192  55.146  1.00 79.53           C  
ATOM   1256  C   GLU A 150      29.491   3.039  55.480  1.00 78.99           C  
ATOM   1257  O   GLU A 150      29.920   1.937  55.852  1.00 79.64           O  
ATOM   1258  CB  GLU A 150      27.606   2.057  54.171  1.00 80.13           C  
ATOM   1259  CG  GLU A 150      26.271   2.238  53.415  1.00 83.55           C  
ATOM   1260  CD  GLU A 150      26.404   3.158  52.200  1.00 88.80           C  
ATOM   1261  OE1 GLU A 150      27.378   2.962  51.423  1.00 90.76           O  
ATOM   1262  OE2 GLU A 150      25.550   4.077  52.028  1.00 89.70           O  
ATOM   1263  N   GLY A 151      30.287   4.101  55.304  1.00 77.74           N  
ATOM   1264  CA  GLY A 151      31.716   4.017  55.555  1.00 75.92           C  
ATOM   1265  C   GLY A 151      32.646   3.573  54.422  1.00 74.91           C  
ATOM   1266  O   GLY A 151      33.860   3.564  54.596  1.00 75.30           O  
ATOM   1267  N   TYR A 152      32.144   3.224  53.250  1.00 73.53           N  
ATOM   1268  CA  TYR A 152      33.090   2.883  52.167  1.00 72.55           C  
ATOM   1269  C   TYR A 152      33.847   4.128  51.679  1.00 70.21           C  
ATOM   1270  O   TYR A 152      33.276   5.211  51.609  1.00 70.00           O  
ATOM   1271  CB  TYR A 152      32.390   2.224  50.954  1.00 74.25           C  
ATOM   1272  CG  TYR A 152      31.232   1.293  51.266  1.00 76.87           C  
ATOM   1273  CD1 TYR A 152      30.091   1.295  50.453  1.00 77.62           C  
ATOM   1274  CD2 TYR A 152      31.262   0.423  52.397  1.00 78.38           C  
ATOM   1275  CE1 TYR A 152      29.005   0.453  50.732  1.00 79.34           C  
ATOM   1276  CE2 TYR A 152      30.180  -0.417  52.691  1.00 79.40           C  
ATOM   1277  CZ  TYR A 152      29.048  -0.400  51.845  1.00 79.41           C  
ATOM   1278  OH  TYR A 152      27.958  -1.227  52.094  1.00 78.95           O  
ATOM   1279  N   PHE A 153      35.118   3.989  51.325  1.00 66.96           N  
ATOM   1280  CA  PHE A 153      35.752   5.090  50.610  1.00 63.85           C  
ATOM   1281  C   PHE A 153      35.310   5.063  49.162  1.00 62.57           C  
ATOM   1282  O   PHE A 153      35.064   3.976  48.631  1.00 62.06           O  
ATOM   1283  CB  PHE A 153      37.259   5.025  50.718  1.00 62.92           C  
ATOM   1284  CG  PHE A 153      37.778   5.435  52.058  1.00 61.72           C  
ATOM   1285  CD1 PHE A 153      38.975   4.942  52.532  1.00 61.12           C  
ATOM   1286  CD2 PHE A 153      37.073   6.322  52.856  1.00 61.96           C  
ATOM   1287  CE1 PHE A 153      39.449   5.320  53.767  1.00 59.38           C  
ATOM   1288  CE2 PHE A 153      37.549   6.702  54.103  1.00 58.86           C  
ATOM   1289  CZ  PHE A 153      38.728   6.202  54.547  1.00 59.72           C  
ATOM   1290  N   LEU A 154      35.217   6.241  48.530  1.00 60.70           N  
ATOM   1291  CA  LEU A 154      34.665   6.368  47.169  1.00 59.42           C  
ATOM   1292  C   LEU A 154      35.519   7.184  46.241  1.00 58.59           C  
ATOM   1293  O   LEU A 154      35.735   8.333  46.469  1.00 59.36           O  
ATOM   1294  CB  LEU A 154      33.298   7.039  47.221  1.00 59.15           C  
ATOM   1295  CG  LEU A 154      32.106   6.295  47.821  1.00 59.59           C  
ATOM   1296  CD1 LEU A 154      30.967   7.273  48.130  1.00 59.01           C  
ATOM   1297  CD2 LEU A 154      31.654   5.125  46.898  1.00 59.53           C  
ATOM   1298  N   LEU A 155      36.000   6.622  45.167  1.00 58.34           N  
ATOM   1299  CA  LEU A 155      36.763   7.439  44.226  1.00 58.30           C  
ATOM   1300  C   LEU A 155      35.811   8.350  43.455  1.00 58.88           C  
ATOM   1301  O   LEU A 155      34.876   7.878  42.816  1.00 59.91           O  
ATOM   1302  CB  LEU A 155      37.550   6.551  43.260  1.00 57.48           C  
ATOM   1303  CG  LEU A 155      38.130   7.235  42.048  1.00 56.34           C  
ATOM   1304  CD1 LEU A 155      39.229   8.156  42.549  1.00 57.85           C  
ATOM   1305  CD2 LEU A 155      38.688   6.234  41.071  1.00 55.07           C  
ATOM   1306  N   HIS A 156      36.030   9.658  43.510  1.00 59.02           N  
ATOM   1307  CA  HIS A 156      35.209  10.604  42.735  1.00 58.64           C  
ATOM   1308  C   HIS A 156      36.029  10.899  41.464  1.00 59.61           C  
ATOM   1309  O   HIS A 156      37.115  11.458  41.528  1.00 59.22           O  
ATOM   1310  CB  HIS A 156      34.873  11.808  43.637  1.00 57.70           C  
ATOM   1311  CG  HIS A 156      34.376  13.029  42.935  1.00 56.19           C  
ATOM   1312  ND1 HIS A 156      33.834  13.018  41.671  1.00 57.03           N  
ATOM   1313  CD2 HIS A 156      34.302  14.312  43.359  1.00 55.14           C  
ATOM   1314  CE1 HIS A 156      33.465  14.240  41.334  1.00 54.69           C  
ATOM   1315  NE2 HIS A 156      33.737  15.043  42.343  1.00 54.23           N  
ATOM   1316  N   LEU A 157      35.548  10.429  40.317  1.00 60.70           N  
ATOM   1317  CA  LEU A 157      36.337  10.492  39.107  1.00 62.12           C  
ATOM   1318  C   LEU A 157      35.639  11.287  38.013  1.00 63.96           C  
ATOM   1319  O   LEU A 157      34.566  10.887  37.571  1.00 64.38           O  
ATOM   1320  CB  LEU A 157      36.604   9.085  38.623  1.00 61.36           C  
ATOM   1321  CG  LEU A 157      37.316   8.945  37.286  1.00 61.03           C  
ATOM   1322  CD1 LEU A 157      38.713   9.454  37.372  1.00 61.64           C  
ATOM   1323  CD2 LEU A 157      37.360   7.502  36.946  1.00 62.10           C  
ATOM   1324  N   ASP A 158      36.232  12.398  37.555  1.00 65.45           N  
ATOM   1325  CA  ASP A 158      35.541  13.232  36.566  1.00 66.47           C  
ATOM   1326  C   ASP A 158      36.419  13.494  35.395  1.00 66.40           C  
ATOM   1327  O   ASP A 158      37.610  13.282  35.468  1.00 66.31           O  
ATOM   1328  CB  ASP A 158      35.080  14.561  37.166  1.00 67.31           C  
ATOM   1329  CG  ASP A 158      33.952  15.253  36.325  1.00 71.15           C  
ATOM   1330  OD1 ASP A 158      33.814  14.955  35.104  1.00 73.34           O  
ATOM   1331  OD2 ASP A 158      33.198  16.108  36.889  1.00 73.39           O  
ATOM   1332  N   LEU A 159      35.805  13.929  34.308  1.00 66.94           N  
ATOM   1333  CA  LEU A 159      36.505  14.375  33.146  1.00 68.23           C  
ATOM   1334  C   LEU A 159      35.960  15.727  32.706  1.00 70.36           C  
ATOM   1335  O   LEU A 159      34.764  15.868  32.465  1.00 70.77           O  
ATOM   1336  CB  LEU A 159      36.265  13.392  32.045  1.00 67.71           C  
ATOM   1337  CG  LEU A 159      36.669  13.763  30.623  1.00 67.65           C  
ATOM   1338  CD1 LEU A 159      38.114  14.194  30.552  1.00 65.86           C  
ATOM   1339  CD2 LEU A 159      36.388  12.554  29.698  1.00 68.22           C  
ATOM   1340  N   LYS A 160      36.834  16.721  32.576  1.00 72.05           N  
ATOM   1341  CA  LYS A 160      36.413  18.002  32.066  1.00 73.70           C  
ATOM   1342  C   LYS A 160      37.297  18.430  30.904  1.00 74.27           C  
ATOM   1343  O   LYS A 160      38.199  17.695  30.502  1.00 74.81           O  
ATOM   1344  CB  LYS A 160      36.448  19.033  33.170  1.00 74.34           C  
ATOM   1345  CG  LYS A 160      35.099  19.711  33.375  1.00 78.50           C  
ATOM   1346  CD  LYS A 160      35.244  21.244  33.373  1.00 83.96           C  
ATOM   1347  CE  LYS A 160      33.899  21.942  33.075  1.00 85.27           C  
ATOM   1348  NZ  LYS A 160      33.953  23.415  33.423  1.00 86.18           N  
ATOM   1349  N   PHE A 161      37.021  19.601  30.337  1.00 74.97           N  
ATOM   1350  CA  PHE A 161      37.867  20.172  29.282  1.00 75.61           C  
ATOM   1351  C   PHE A 161      38.088  21.615  29.645  1.00 75.60           C  
ATOM   1352  O   PHE A 161      37.111  22.354  29.901  1.00 75.96           O  
ATOM   1353  CB  PHE A 161      37.214  20.107  27.885  1.00 76.09           C  
ATOM   1354  CG  PHE A 161      37.142  18.726  27.311  1.00 76.63           C  
ATOM   1355  CD1 PHE A 161      36.189  17.814  27.762  1.00 77.56           C  
ATOM   1356  CD2 PHE A 161      38.022  18.334  26.313  1.00 78.30           C  
ATOM   1357  CE1 PHE A 161      36.132  16.522  27.242  1.00 78.42           C  
ATOM   1358  CE2 PHE A 161      37.978  17.036  25.783  1.00 78.47           C  
ATOM   1359  CZ  PHE A 161      37.036  16.135  26.250  1.00 78.64           C  
ATOM   1360  N   ARG A 162      39.355  22.018  29.689  1.00 74.84           N  
ATOM   1361  CA  ARG A 162      39.661  23.411  29.907  1.00 74.20           C  
ATOM   1362  C   ARG A 162      40.063  23.996  28.570  1.00 74.55           C  
ATOM   1363  O   ARG A 162      40.818  23.369  27.785  1.00 74.34           O  
ATOM   1364  CB  ARG A 162      40.714  23.628  31.004  1.00 74.19           C  
ATOM   1365  CG  ARG A 162      42.146  23.656  30.518  1.00 73.86           C  
ATOM   1366  CD  ARG A 162      43.163  23.753  31.629  1.00 73.52           C  
ATOM   1367  NE  ARG A 162      44.435  23.271  31.097  1.00 73.35           N  
ATOM   1368  CZ  ARG A 162      44.924  22.049  31.282  1.00 72.24           C  
ATOM   1369  NH1 ARG A 162      44.272  21.177  32.038  1.00 70.88           N  
ATOM   1370  NH2 ARG A 162      46.083  21.712  30.723  1.00 71.87           N  
ATOM   1371  N   ILE A 163      39.519  25.201  28.344  1.00 74.53           N  
ATOM   1372  CA  ILE A 163      39.604  25.960  27.105  1.00 73.88           C  
ATOM   1373  C   ILE A 163      40.780  26.917  27.212  1.00 74.28           C  
ATOM   1374  O   ILE A 163      40.898  27.638  28.187  1.00 74.49           O  
ATOM   1375  CB  ILE A 163      38.304  26.738  26.910  1.00 73.76           C  
ATOM   1376  CG1 ILE A 163      37.108  25.771  26.908  1.00 73.22           C  
ATOM   1377  CG2 ILE A 163      38.365  27.546  25.641  1.00 74.81           C  
ATOM   1378  CD1 ILE A 163      35.716  26.410  26.958  1.00 72.57           C  
ATOM   1379  N   GLN A 164      41.667  26.898  26.226  1.00 74.89           N  
ATOM   1380  CA  GLN A 164      42.924  27.645  26.295  1.00 75.57           C  
ATOM   1381  C   GLN A 164      43.376  27.994  24.897  1.00 75.93           C  
ATOM   1382  O   GLN A 164      43.156  27.220  23.973  1.00 75.73           O  
ATOM   1383  CB  GLN A 164      44.051  26.825  26.952  1.00 75.66           C  
ATOM   1384  CG  GLN A 164      43.896  26.496  28.445  1.00 76.48           C  
ATOM   1385  CD  GLN A 164      45.240  26.437  29.179  1.00 76.82           C  
ATOM   1386  OE1 GLN A 164      45.775  25.361  29.457  1.00 75.58           O  
ATOM   1387  NE2 GLN A 164      45.789  27.603  29.487  1.00 77.77           N  
ATOM   1388  N   PRO A 165      44.020  29.161  24.736  1.00 76.68           N  
ATOM   1389  CA  PRO A 165      44.570  29.566  23.460  1.00 77.38           C  
ATOM   1390  C   PRO A 165      46.005  29.091  23.248  1.00 78.39           C  
ATOM   1391  O   PRO A 165      46.538  28.313  24.044  1.00 78.23           O  
ATOM   1392  CB  PRO A 165      44.512  31.091  23.536  1.00 77.38           C  
ATOM   1393  CG  PRO A 165      44.507  31.430  24.978  1.00 76.62           C  
ATOM   1394  CD  PRO A 165      44.232  30.191  25.766  1.00 76.83           C  
ATOM   1395  N   PHE A 166      46.614  29.539  22.158  1.00 79.87           N  
ATOM   1396  CA  PHE A 166      47.998  29.210  21.889  1.00 81.87           C  
ATOM   1397  C   PHE A 166      48.850  30.439  22.164  1.00 83.23           C  
ATOM   1398  O   PHE A 166      49.738  30.769  21.378  1.00 83.30           O  
ATOM   1399  CB  PHE A 166      48.176  28.768  20.435  1.00 81.67           C  
ATOM   1400  CG  PHE A 166      47.601  27.410  20.121  1.00 81.82           C  
ATOM   1401  CD1 PHE A 166      46.217  27.193  20.128  1.00 81.61           C  
ATOM   1402  CD2 PHE A 166      48.441  26.359  19.767  1.00 81.62           C  
ATOM   1403  CE1 PHE A 166      45.679  25.944  19.813  1.00 80.54           C  
ATOM   1404  CE2 PHE A 166      47.914  25.111  19.450  1.00 82.06           C  
ATOM   1405  CZ  PHE A 166      46.522  24.904  19.477  1.00 81.39           C  
ATOM   1406  N   GLU A 167      48.581  31.120  23.278  1.00 84.92           N  
ATOM   1407  CA  GLU A 167      49.195  32.422  23.512  1.00 87.02           C  
ATOM   1408  C   GLU A 167      49.780  32.669  24.896  1.00 87.75           C  
ATOM   1409  O   GLU A 167      49.222  33.391  25.721  1.00 88.08           O  
ATOM   1410  CB  GLU A 167      48.262  33.551  23.080  1.00 87.30           C  
ATOM   1411  CG  GLU A 167      48.476  33.956  21.627  1.00 90.54           C  
ATOM   1412  CD  GLU A 167      47.259  34.626  20.995  1.00 94.45           C  
ATOM   1413  OE1 GLU A 167      46.264  34.904  21.715  1.00 95.66           O  
ATOM   1414  OE2 GLU A 167      47.306  34.869  19.762  1.00 95.95           O  
ATOM   1415  N   THR A 168      50.931  32.050  25.112  1.00 89.06           N  
ATOM   1416  CA  THR A 168      51.826  32.316  26.233  1.00 90.09           C  
ATOM   1417  C   THR A 168      51.868  33.795  26.614  1.00 90.94           C  
ATOM   1418  O   THR A 168      51.975  34.671  25.743  1.00 91.29           O  
ATOM   1419  CB  THR A 168      53.238  31.759  25.894  1.00 90.06           C  
ATOM   1420  OG1 THR A 168      53.480  30.570  26.660  1.00 90.33           O  
ATOM   1421  CG2 THR A 168      54.348  32.775  26.142  1.00 90.36           C  
ATOM   1422  N   LEU A 169      51.766  34.056  27.916  1.00 91.82           N  
ATOM   1423  CA  LEU A 169      51.779  35.414  28.468  1.00 92.64           C  
ATOM   1424  C   LEU A 169      52.910  36.306  27.966  1.00 93.76           C  
ATOM   1425  O   LEU A 169      52.701  37.488  27.674  1.00 93.51           O  
ATOM   1426  CB  LEU A 169      51.839  35.356  29.987  1.00 92.26           C  
ATOM   1427  CG  LEU A 169      50.547  35.737  30.686  1.00 91.13           C  
ATOM   1428  CD1 LEU A 169      50.446  34.971  31.972  1.00 90.54           C  
ATOM   1429  CD2 LEU A 169      50.484  37.234  30.939  1.00 90.29           C  
ATOM   1430  N   GLN A 170      54.110  35.743  27.882  1.00 95.32           N  
ATOM   1431  CA  GLN A 170      55.242  36.504  27.409  1.00 97.29           C  
ATOM   1432  C   GLN A 170      54.836  37.201  26.129  1.00 98.66           C  
ATOM   1433  O   GLN A 170      54.910  38.433  26.044  1.00 99.05           O  
ATOM   1434  CB  GLN A 170      56.457  35.610  27.158  1.00 97.44           C  
ATOM   1435  CG  GLN A 170      57.770  36.373  27.035  1.00 97.36           C  
ATOM   1436  CD  GLN A 170      58.185  36.976  28.353  1.00 97.89           C  
ATOM   1437  OE1 GLN A 170      58.124  38.190  28.534  1.00 97.91           O  
ATOM   1438  NE2 GLN A 170      58.582  36.126  29.298  1.00 98.50           N  
ATOM   1439  N   THR A 171      54.372  36.409  25.155  1.00100.01           N  
ATOM   1440  CA  THR A 171      54.013  36.914  23.830  1.00101.32           C  
ATOM   1441  C   THR A 171      52.976  38.026  23.922  1.00102.27           C  
ATOM   1442  O   THR A 171      53.104  39.063  23.247  1.00102.37           O  
ATOM   1443  CB  THR A 171      53.534  35.784  22.898  1.00101.08           C  
ATOM   1444  OG1 THR A 171      54.568  34.809  22.803  1.00101.03           O  
ATOM   1445  CG2 THR A 171      53.252  36.310  21.496  1.00101.52           C  
ATOM   1446  N   LEU A 172      51.979  37.820  24.782  1.00103.32           N  
ATOM   1447  CA  LEU A 172      50.916  38.794  24.944  1.00104.72           C  
ATOM   1448  C   LEU A 172      51.397  40.121  25.547  1.00105.56           C  
ATOM   1449  O   LEU A 172      51.017  41.187  25.067  1.00105.96           O  
ATOM   1450  CB  LEU A 172      49.722  38.209  25.718  1.00104.85           C  
ATOM   1451  CG  LEU A 172      48.904  37.041  25.121  1.00105.38           C  
ATOM   1452  CD1 LEU A 172      47.606  36.802  25.923  1.00105.15           C  
ATOM   1453  CD2 LEU A 172      48.583  37.216  23.621  1.00105.40           C  
ATOM   1454  N   LEU A 173      52.247  40.072  26.565  1.00106.43           N  
ATOM   1455  CA  LEU A 173      52.685  41.312  27.210  1.00107.40           C  
ATOM   1456  C   LEU A 173      53.766  42.026  26.406  1.00108.14           C  
ATOM   1457  O   LEU A 173      53.782  43.256  26.331  1.00108.00           O  
ATOM   1458  CB  LEU A 173      53.150  41.055  28.646  1.00107.51           C  
ATOM   1459  CG  LEU A 173      52.201  40.292  29.574  1.00107.36           C  
ATOM   1460  CD1 LEU A 173      52.583  40.509  31.033  1.00107.40           C  
ATOM   1461  CD2 LEU A 173      50.758  40.706  29.320  1.00107.09           C  
ATOM   1462  N   GLU A 174      54.660  41.228  25.820  1.00109.31           N  
ATOM   1463  CA  GLU A 174      55.727  41.691  24.936  1.00110.49           C  
ATOM   1464  C   GLU A 174      55.167  42.334  23.682  1.00111.50           C  
ATOM   1465  O   GLU A 174      55.118  43.560  23.547  1.00111.64           O  
ATOM   1466  CB  GLU A 174      56.543  40.495  24.448  1.00110.38           C  
ATOM   1467  CG  GLU A 174      57.820  40.169  25.165  1.00110.35           C  
ATOM   1468  CD  GLU A 174      58.547  39.025  24.474  1.00110.32           C  
ATOM   1469  OE1 GLU A 174      57.885  38.007  24.155  1.00109.29           O  
ATOM   1470  OE2 GLU A 174      59.771  39.149  24.234  1.00110.05           O  
ATOM   1471  N   ARG A 175      54.733  41.459  22.775  1.00112.75           N  
ATOM   1472  CA  ARG A 175      54.474  41.782  21.375  1.00113.92           C  
ATOM   1473  C   ARG A 175      53.186  42.573  21.160  1.00114.38           C  
ATOM   1474  O   ARG A 175      53.041  43.271  20.145  1.00114.51           O  
ATOM   1475  CB  ARG A 175      54.446  40.484  20.545  1.00114.07           C  
ATOM   1476  CG  ARG A 175      55.761  39.698  20.569  1.00114.33           C  
ATOM   1477  CD  ARG A 175      55.741  38.493  19.645  1.00114.25           C  
ATOM   1478  NE  ARG A 175      57.001  38.400  18.904  1.00115.07           N  
ATOM   1479  CZ  ARG A 175      57.478  37.297  18.331  1.00115.42           C  
ATOM   1480  NH1 ARG A 175      56.817  36.144  18.408  1.00115.12           N  
ATOM   1481  NH2 ARG A 175      58.637  37.351  17.685  1.00115.42           N  
ATOM   1482  N   ASN A 176      52.269  42.476  22.124  1.00114.87           N  
ATOM   1483  CA  ASN A 176      50.908  42.976  21.954  1.00115.28           C  
ATOM   1484  C   ASN A 176      50.514  44.199  22.794  1.00115.65           C  
ATOM   1485  O   ASN A 176      50.224  45.265  22.248  1.00115.78           O  
ATOM   1486  CB  ASN A 176      49.893  41.843  22.207  1.00115.09           C  
ATOM   1487  CG  ASN A 176      50.020  40.678  21.220  1.00114.91           C  
ATOM   1488  OD1 ASN A 176      51.091  40.402  20.658  1.00114.55           O  
ATOM   1489  ND2 ASN A 176      48.913  39.975  21.025  1.00114.25           N  
ATOM   1490  N   ASP A 177      50.542  44.048  24.115  1.00116.14           N  
ATOM   1491  CA  ASP A 177      49.584  44.741  24.990  1.00116.78           C  
ATOM   1492  C   ASP A 177      49.864  46.128  25.594  1.00116.81           C  
ATOM   1493  O   ASP A 177      50.661  46.930  25.086  1.00116.68           O  
ATOM   1494  CB  ASP A 177      49.141  43.791  26.112  1.00117.10           C  
ATOM   1495  CG  ASP A 177      47.743  43.232  25.892  1.00118.38           C  
ATOM   1496  OD1 ASP A 177      47.083  43.643  24.899  1.00119.79           O  
ATOM   1497  OD2 ASP A 177      47.309  42.393  26.723  1.00118.76           O  
ATOM   1498  N   PHE A 178      49.119  46.370  26.678  1.00116.88           N  
ATOM   1499  CA  PHE A 178      49.125  47.583  27.483  1.00116.88           C  
ATOM   1500  C   PHE A 178      49.056  47.178  28.961  1.00116.68           C  
ATOM   1501  O   PHE A 178      50.093  47.033  29.611  1.00116.71           O  
ATOM   1502  CB  PHE A 178      47.891  48.438  27.182  1.00117.12           C  
ATOM   1503  CG  PHE A 178      47.827  48.974  25.784  1.00117.40           C  
ATOM   1504  CD1 PHE A 178      47.257  48.218  24.758  1.00117.45           C  
ATOM   1505  CD2 PHE A 178      48.292  50.260  25.502  1.00117.50           C  
ATOM   1506  CE1 PHE A 178      47.180  48.718  23.470  1.00117.44           C  
ATOM   1507  CE2 PHE A 178      48.221  50.777  24.216  1.00117.64           C  
ATOM   1508  CZ  PHE A 178      47.664  50.003  23.196  1.00117.84           C  
ATOM   1509  N   ASN A 179      47.825  46.985  29.463  1.00116.33           N  
ATOM   1510  CA  ASN A 179      47.528  46.756  30.895  1.00116.04           C  
ATOM   1511  C   ASN A 179      46.776  45.436  31.182  1.00115.75           C  
ATOM   1512  O   ASN A 179      45.565  45.467  31.424  1.00115.79           O  
ATOM   1513  CB  ASN A 179      46.687  47.920  31.463  1.00115.97           C  
ATOM   1514  CG  ASN A 179      47.503  49.173  31.759  1.00116.08           C  
ATOM   1515  OD1 ASN A 179      48.687  49.269  31.431  1.00116.06           O  
ATOM   1516  ND2 ASN A 179      46.856  50.149  32.387  1.00116.28           N  
ATOM   1517  N   PRO A 180      47.488  44.282  31.191  1.00115.44           N  
ATOM   1518  CA  PRO A 180      46.841  42.944  31.302  1.00114.89           C  
ATOM   1519  C   PRO A 180      46.226  42.650  32.678  1.00114.07           C  
ATOM   1520  O   PRO A 180      45.386  43.423  33.156  1.00113.98           O  
ATOM   1521  CB  PRO A 180      47.997  41.978  31.021  1.00114.98           C  
ATOM   1522  CG  PRO A 180      49.224  42.735  31.475  1.00115.26           C  
ATOM   1523  CD  PRO A 180      48.962  44.171  31.104  1.00115.37           C  
ATOM   1524  N   LYS A 181      46.642  41.540  33.292  1.00113.06           N  
ATOM   1525  CA  LYS A 181      46.340  41.246  34.702  1.00112.38           C  
ATOM   1526  C   LYS A 181      44.894  40.796  34.908  1.00111.56           C  
ATOM   1527  O   LYS A 181      44.114  40.739  33.953  1.00111.71           O  
ATOM   1528  CB  LYS A 181      46.650  42.464  35.599  1.00112.70           C  
ATOM   1529  CG  LYS A 181      48.005  43.152  35.333  1.00112.96           C  
ATOM   1530  CD  LYS A 181      48.133  44.464  36.101  1.00112.52           C  
ATOM   1531  CE  LYS A 181      49.592  44.870  36.230  1.00112.38           C  
ATOM   1532  NZ  LYS A 181      49.863  45.493  37.553  1.00111.96           N  
ATOM   1533  N   ARG A 182      44.544  40.488  36.158  1.00110.27           N  
ATOM   1534  CA  ARG A 182      43.196  40.033  36.534  1.00109.38           C  
ATOM   1535  C   ARG A 182      42.825  38.654  35.965  1.00108.13           C  
ATOM   1536  O   ARG A 182      42.207  37.834  36.680  1.00108.04           O  
ATOM   1537  CB  ARG A 182      42.133  41.087  36.191  1.00109.41           C  
ATOM   1538  CG  ARG A 182      42.452  42.457  36.783  1.00110.43           C  
ATOM   1539  CD  ARG A 182      41.314  43.476  36.655  1.00110.63           C  
ATOM   1540  NE  ARG A 182      41.602  44.690  37.438  1.00113.22           N  
ATOM   1541  CZ  ARG A 182      40.789  45.744  37.564  1.00114.32           C  
ATOM   1542  NH1 ARG A 182      39.605  45.773  36.953  1.00115.14           N  
ATOM   1543  NH2 ARG A 182      41.163  46.784  38.309  1.00114.53           N  
ATOM   1544  N   ILE A 183      43.210  38.416  34.698  1.00106.37           N  
ATOM   1545  CA  ILE A 183      43.001  37.145  33.978  1.00104.54           C  
ATOM   1546  C   ILE A 183      43.775  36.001  34.626  1.00103.31           C  
ATOM   1547  O   ILE A 183      44.995  36.123  34.841  1.00103.15           O  
ATOM   1548  CB  ILE A 183      43.456  37.200  32.489  1.00104.47           C  
ATOM   1549  CG1 ILE A 183      42.745  38.321  31.721  1.00105.46           C  
ATOM   1550  CG2 ILE A 183      43.189  35.864  31.799  1.00104.01           C  
ATOM   1551  CD1 ILE A 183      42.962  38.300  30.181  1.00104.77           C  
ATOM   1552  N   ARG A 184      43.060  34.902  34.903  1.00101.27           N  
ATOM   1553  CA  ARG A 184      43.629  33.663  35.463  1.00 99.58           C  
ATOM   1554  C   ARG A 184      44.380  32.716  34.468  1.00 97.46           C  
ATOM   1555  O   ARG A 184      44.118  32.692  33.252  1.00 97.41           O  
ATOM   1556  CB  ARG A 184      42.563  32.898  36.269  1.00 99.99           C  
ATOM   1557  CG  ARG A 184      41.332  32.418  35.474  1.00100.90           C  
ATOM   1558  CD  ARG A 184      40.430  31.574  36.362  1.00101.11           C  
ATOM   1559  NE  ARG A 184      39.041  32.016  36.235  1.00105.98           N  
ATOM   1560  CZ  ARG A 184      38.021  31.561  36.964  1.00107.03           C  
ATOM   1561  NH1 ARG A 184      38.216  30.633  37.899  1.00106.82           N  
ATOM   1562  NH2 ARG A 184      36.799  32.041  36.749  1.00107.84           N  
ATOM   1563  N   VAL A 185      45.276  31.899  35.032  1.00 94.69           N  
ATOM   1564  CA  VAL A 185      46.383  31.267  34.304  1.00 91.63           C  
ATOM   1565  C   VAL A 185      46.709  29.794  34.739  1.00 89.46           C  
ATOM   1566  O   VAL A 185      46.214  29.315  35.760  1.00 89.14           O  
ATOM   1567  CB  VAL A 185      47.606  32.188  34.455  1.00 91.55           C  
ATOM   1568  CG1 VAL A 185      48.744  31.719  33.621  1.00 92.56           C  
ATOM   1569  CG2 VAL A 185      47.234  33.597  34.040  1.00 91.08           C  
ATOM   1570  N   LYS A 186      47.530  29.090  33.950  1.00 86.82           N  
ATOM   1571  CA  LYS A 186      47.939  27.697  34.214  1.00 84.03           C  
ATOM   1572  C   LYS A 186      49.320  27.428  33.655  1.00 82.75           C  
ATOM   1573  O   LYS A 186      49.538  27.568  32.463  1.00 82.48           O  
ATOM   1574  CB  LYS A 186      46.972  26.728  33.556  1.00 83.72           C  
ATOM   1575  CG  LYS A 186      47.038  25.313  34.067  1.00 81.48           C  
ATOM   1576  CD  LYS A 186      47.965  24.430  33.287  1.00 77.67           C  
ATOM   1577  CE  LYS A 186      47.585  22.986  33.525  1.00 75.08           C  
ATOM   1578  NZ  LYS A 186      48.741  22.058  33.474  1.00 73.04           N  
ATOM   1579  N   PRO A 187      50.263  27.040  34.513  1.00 81.62           N  
ATOM   1580  CA  PRO A 187      51.609  26.788  34.018  1.00 81.03           C  
ATOM   1581  C   PRO A 187      51.700  25.473  33.264  1.00 80.70           C  
ATOM   1582  O   PRO A 187      51.149  24.478  33.698  1.00 80.60           O  
ATOM   1583  CB  PRO A 187      52.451  26.724  35.294  1.00 80.61           C  
ATOM   1584  CG  PRO A 187      51.549  27.169  36.406  1.00 80.87           C  
ATOM   1585  CD  PRO A 187      50.168  26.859  35.966  1.00 81.31           C  
ATOM   1586  N   ILE A 188      52.371  25.485  32.121  1.00 80.52           N  
ATOM   1587  CA  ILE A 188      52.681  24.274  31.397  1.00 80.20           C  
ATOM   1588  C   ILE A 188      53.359  23.350  32.384  1.00 80.47           C  
ATOM   1589  O   ILE A 188      54.252  23.765  33.112  1.00 80.31           O  
ATOM   1590  CB  ILE A 188      53.653  24.547  30.238  1.00 80.15           C  
ATOM   1591  CG1 ILE A 188      53.160  25.695  29.367  1.00 80.25           C  
ATOM   1592  CG2 ILE A 188      53.808  23.325  29.372  1.00 79.99           C  
ATOM   1593  CD1 ILE A 188      54.223  26.226  28.431  1.00 81.80           C  
ATOM   1594  N   GLY A 189      52.904  22.106  32.427  1.00 81.07           N  
ATOM   1595  CA  GLY A 189      53.517  21.080  33.269  1.00 81.79           C  
ATOM   1596  C   GLY A 189      53.288  21.157  34.770  1.00 82.20           C  
ATOM   1597  O   GLY A 189      54.021  20.510  35.537  1.00 82.01           O  
ATOM   1598  N   ILE A 190      52.290  21.945  35.184  1.00 82.81           N  
ATOM   1599  CA  ILE A 190      51.946  22.161  36.601  1.00 83.64           C  
ATOM   1600  C   ILE A 190      50.448  22.232  36.708  1.00 84.82           C  
ATOM   1601  O   ILE A 190      49.796  22.803  35.844  1.00 84.50           O  
ATOM   1602  CB  ILE A 190      52.543  23.477  37.195  1.00 83.61           C  
ATOM   1603  CG1 ILE A 190      54.084  23.446  37.174  1.00 83.50           C  
ATOM   1604  CG2 ILE A 190      52.015  23.723  38.619  1.00 82.58           C  
ATOM   1605  CD1 ILE A 190      54.768  24.786  37.218  1.00 82.22           C  
ATOM   1606  N   ASP A 191      49.906  21.650  37.775  1.00 86.80           N  
ATOM   1607  CA  ASP A 191      48.463  21.480  37.903  1.00 88.53           C  
ATOM   1608  C   ASP A 191      47.772  22.810  38.163  1.00 89.37           C  
ATOM   1609  O   ASP A 191      47.089  23.328  37.284  1.00 89.73           O  
ATOM   1610  CB  ASP A 191      48.121  20.447  38.979  1.00 88.68           C  
ATOM   1611  CG  ASP A 191      46.820  19.709  38.693  1.00 89.92           C  
ATOM   1612  OD1 ASP A 191      46.030  20.208  37.866  1.00 90.81           O  
ATOM   1613  OD2 ASP A 191      46.588  18.630  39.298  1.00 91.59           O  
ATOM   1614  N   PHE A 192      47.971  23.358  39.357  1.00 90.35           N  
ATOM   1615  CA  PHE A 192      47.437  24.668  39.765  1.00 91.65           C  
ATOM   1616  C   PHE A 192      46.996  25.655  38.648  1.00 91.87           C  
ATOM   1617  O   PHE A 192      47.671  25.821  37.636  1.00 91.43           O  
ATOM   1618  CB  PHE A 192      48.459  25.320  40.707  1.00 92.20           C  
ATOM   1619  CG  PHE A 192      48.113  26.725  41.143  1.00 93.35           C  
ATOM   1620  CD1 PHE A 192      47.639  26.965  42.436  1.00 93.80           C  
ATOM   1621  CD2 PHE A 192      48.311  27.814  40.281  1.00 93.90           C  
ATOM   1622  CE1 PHE A 192      47.350  28.260  42.856  1.00 94.17           C  
ATOM   1623  CE2 PHE A 192      48.013  29.109  40.687  1.00 94.48           C  
ATOM   1624  CZ  PHE A 192      47.537  29.338  41.982  1.00 94.25           C  
ATOM   1625  N   VAL A 193      45.855  26.304  38.874  1.00 92.67           N  
ATOM   1626  CA  VAL A 193      45.290  27.321  37.976  1.00 93.71           C  
ATOM   1627  C   VAL A 193      44.794  28.531  38.790  1.00 94.39           C  
ATOM   1628  O   VAL A 193      44.024  28.340  39.722  1.00 94.93           O  
ATOM   1629  CB  VAL A 193      44.072  26.749  37.222  1.00 93.50           C  
ATOM   1630  CG1 VAL A 193      43.442  27.798  36.319  1.00 93.13           C  
ATOM   1631  CG2 VAL A 193      44.464  25.526  36.429  1.00 93.96           C  
ATOM   1632  N   GLY A 194      45.181  29.762  38.456  1.00 94.78           N  
ATOM   1633  CA  GLY A 194      44.675  30.892  39.241  1.00 95.62           C  
ATOM   1634  C   GLY A 194      44.878  32.303  38.744  1.00 96.42           C  
ATOM   1635  O   GLY A 194      45.697  32.557  37.876  1.00 96.19           O  
ATOM   1636  N   ARG A 195      44.126  33.228  39.331  1.00 97.53           N  
ATOM   1637  CA  ARG A 195      44.173  34.652  38.974  1.00 98.57           C  
ATOM   1638  C   ARG A 195      45.556  35.282  39.177  1.00 98.53           C  
ATOM   1639  O   ARG A 195      46.266  34.919  40.119  1.00 98.72           O  
ATOM   1640  CB  ARG A 195      43.122  35.446  39.780  1.00 99.21           C  
ATOM   1641  CG  ARG A 195      41.845  34.671  40.135  1.00100.97           C  
ATOM   1642  CD  ARG A 195      40.578  35.418  39.686  1.00103.98           C  
ATOM   1643  NE  ARG A 195      39.419  34.513  39.632  1.00106.02           N  
ATOM   1644  CZ  ARG A 195      38.272  34.756  38.992  1.00106.37           C  
ATOM   1645  NH1 ARG A 195      38.093  35.891  38.316  1.00106.87           N  
ATOM   1646  NH2 ARG A 195      37.299  33.853  39.029  1.00105.57           N  
ATOM   1647  N   VAL A 196      45.913  36.220  38.291  1.00 98.52           N  
ATOM   1648  CA  VAL A 196      47.135  37.055  38.382  1.00 98.30           C  
ATOM   1649  C   VAL A 196      46.946  38.189  39.402  1.00 98.23           C  
ATOM   1650  O   VAL A 196      45.854  38.755  39.507  1.00 97.89           O  
ATOM   1651  CB  VAL A 196      47.472  37.695  36.997  1.00 98.40           C  
ATOM   1652  CG1 VAL A 196      48.620  38.693  37.092  1.00 98.51           C  
ATOM   1653  CG2 VAL A 196      47.798  36.641  35.967  1.00 98.09           C  
ATOM   1654  N   GLN A 197      48.002  38.516  40.146  1.00 98.46           N  
ATOM   1655  CA  GLN A 197      47.940  39.590  41.155  1.00 98.96           C  
ATOM   1656  C   GLN A 197      49.204  40.450  41.297  1.00 98.94           C  
ATOM   1657  O   GLN A 197      49.353  41.118  42.322  1.00 98.93           O  
ATOM   1658  CB  GLN A 197      47.551  39.025  42.532  1.00 99.13           C  
ATOM   1659  CG  GLN A 197      46.062  38.717  42.685  1.00100.28           C  
ATOM   1660  CD  GLN A 197      45.813  37.408  43.407  1.00101.16           C  
ATOM   1661  OE1 GLN A 197      46.679  36.923  44.137  1.00102.21           O  
ATOM   1662  NE2 GLN A 197      44.627  36.827  43.207  1.00100.55           N  
ATOM   1663  N   ASP A 198      50.091  40.433  40.289  1.00 99.07           N  
ATOM   1664  CA  ASP A 198      51.358  41.213  40.277  1.00 99.23           C  
ATOM   1665  C   ASP A 198      52.278  40.904  39.103  1.00 98.86           C  
ATOM   1666  O   ASP A 198      52.630  39.752  38.891  1.00 98.75           O  
ATOM   1667  CB  ASP A 198      52.177  40.969  41.548  1.00 99.64           C  
ATOM   1668  CG  ASP A 198      52.296  42.205  42.420  1.00101.13           C  
ATOM   1669  OD1 ASP A 198      52.477  43.329  41.882  1.00102.40           O  
ATOM   1670  OD2 ASP A 198      52.224  42.036  43.659  1.00103.08           O  
ATOM   1671  N   VAL A 199      52.702  41.933  38.370  1.00 98.66           N  
ATOM   1672  CA  VAL A 199      53.700  41.757  37.301  1.00 98.48           C  
ATOM   1673  C   VAL A 199      54.880  42.738  37.409  1.00 98.41           C  
ATOM   1674  O   VAL A 199      54.695  43.947  37.641  1.00 98.37           O  
ATOM   1675  CB  VAL A 199      53.086  41.860  35.862  1.00 98.53           C  
ATOM   1676  CG1 VAL A 199      54.150  41.573  34.776  1.00 98.25           C  
ATOM   1677  CG2 VAL A 199      51.900  40.919  35.691  1.00 98.78           C  
ATOM   1678  N   PHE A 200      56.087  42.193  37.237  1.00 98.07           N  
ATOM   1679  CA  PHE A 200      57.304  42.988  37.030  1.00 97.82           C  
ATOM   1680  C   PHE A 200      58.243  42.335  36.018  1.00 97.23           C  
ATOM   1681  O   PHE A 200      58.313  41.111  35.933  1.00 97.16           O  
ATOM   1682  CB  PHE A 200      58.063  43.297  38.346  1.00 98.11           C  
ATOM   1683  CG  PHE A 200      57.611  42.489  39.555  1.00 98.51           C  
ATOM   1684  CD1 PHE A 200      57.928  41.134  39.677  1.00 98.15           C  
ATOM   1685  CD2 PHE A 200      56.908  43.115  40.599  1.00 98.77           C  
ATOM   1686  CE1 PHE A 200      57.523  40.414  40.801  1.00 98.66           C  
ATOM   1687  CE2 PHE A 200      56.496  42.403  41.729  1.00 98.42           C  
ATOM   1688  CZ  PHE A 200      56.802  41.051  41.831  1.00 98.58           C  
ATOM   1689  N   LYS A 201      58.961  43.156  35.252  1.00 96.53           N  
ATOM   1690  CA  LYS A 201      60.043  42.646  34.409  1.00 95.88           C  
ATOM   1691  C   LYS A 201      61.022  41.827  35.247  1.00 95.42           C  
ATOM   1692  O   LYS A 201      61.194  42.079  36.442  1.00 95.42           O  
ATOM   1693  CB  LYS A 201      60.795  43.776  33.695  1.00 95.82           C  
ATOM   1694  CG  LYS A 201      60.301  44.085  32.280  1.00 95.46           C  
ATOM   1695  CD  LYS A 201      61.368  44.809  31.464  1.00 94.66           C  
ATOM   1696  CE  LYS A 201      60.758  45.599  30.325  1.00 94.36           C  
ATOM   1697  NZ  LYS A 201      61.801  46.283  29.517  1.00 93.77           N  
ATOM   1698  N   ALA A 202      61.653  40.846  34.609  1.00 94.70           N  
ATOM   1699  CA  ALA A 202      62.642  39.995  35.261  1.00 93.90           C  
ATOM   1700  C   ALA A 202      63.992  40.686  35.414  1.00 93.29           C  
ATOM   1701  O   ALA A 202      64.796  40.309  36.276  1.00 92.91           O  
ATOM   1702  CB  ALA A 202      62.808  38.707  34.482  1.00 94.07           C  
ATOM   1703  N   LYS A 203      64.225  41.697  34.573  1.00 92.72           N  
ATOM   1704  CA  LYS A 203      65.518  42.395  34.478  1.00 91.96           C  
ATOM   1705  C   LYS A 203      65.907  43.070  35.799  1.00 91.33           C  
ATOM   1706  O   LYS A 203      67.079  43.373  36.027  1.00 90.93           O  
ATOM   1707  CB  LYS A 203      65.480  43.406  33.328  1.00 92.08           C  
ATOM   1708  CG  LYS A 203      66.838  43.829  32.766  1.00 92.05           C  
ATOM   1709  CD  LYS A 203      66.720  45.128  31.972  1.00 91.17           C  
ATOM   1710  CE  LYS A 203      66.052  46.216  32.810  1.00 91.61           C  
ATOM   1711  NZ  LYS A 203      66.486  47.576  32.412  1.00 93.10           N  
ATOM   1712  N   GLU A 204      64.905  43.283  36.655  1.00 90.77           N  
ATOM   1713  CA  GLU A 204      65.093  43.727  38.037  1.00 90.28           C  
ATOM   1714  C   GLU A 204      66.027  42.817  38.857  1.00 89.76           C  
ATOM   1715  O   GLU A 204      66.916  43.312  39.549  1.00 89.89           O  
ATOM   1716  CB  GLU A 204      63.749  43.757  38.765  1.00 90.28           C  
ATOM   1717  CG  GLU A 204      62.856  44.959  38.554  1.00 90.34           C  
ATOM   1718  CD  GLU A 204      61.612  44.870  39.441  1.00 90.64           C  
ATOM   1719  OE1 GLU A 204      61.652  44.127  40.449  1.00 90.54           O  
ATOM   1720  OE2 GLU A 204      60.594  45.533  39.144  1.00 91.42           O  
ATOM   1721  N   LYS A 205      65.814  41.500  38.781  1.00 88.97           N  
ATOM   1722  CA  LYS A 205      66.426  40.537  39.713  1.00 88.14           C  
ATOM   1723  C   LYS A 205      67.843  40.104  39.341  1.00 87.81           C  
ATOM   1724  O   LYS A 205      68.141  39.880  38.168  1.00 87.87           O  
ATOM   1725  CB  LYS A 205      65.530  39.301  39.863  1.00 88.09           C  
ATOM   1726  CG  LYS A 205      64.090  39.603  40.235  1.00 87.00           C  
ATOM   1727  CD  LYS A 205      63.973  40.186  41.620  1.00 85.70           C  
ATOM   1728  CE  LYS A 205      62.612  40.809  41.793  1.00 85.52           C  
ATOM   1729  NZ  LYS A 205      62.371  41.160  43.211  1.00 86.15           N  
ATOM   1730  N   GLY A 206      68.700  39.957  40.353  1.00 87.36           N  
ATOM   1731  CA  GLY A 206      70.125  39.664  40.149  1.00 86.88           C  
ATOM   1732  C   GLY A 206      70.406  38.215  39.795  1.00 86.43           C  
ATOM   1733  O   GLY A 206      69.534  37.515  39.293  1.00 86.54           O  
ATOM   1734  N   GLU A 207      71.631  37.766  40.052  1.00 85.99           N  
ATOM   1735  CA  GLU A 207      72.010  36.382  39.790  1.00 85.36           C  
ATOM   1736  C   GLU A 207      71.344  35.421  40.763  1.00 85.34           C  
ATOM   1737  O   GLU A 207      70.710  34.454  40.332  1.00 85.73           O  
ATOM   1738  CB  GLU A 207      73.531  36.206  39.808  1.00 85.47           C  
ATOM   1739  CG  GLU A 207      74.191  36.331  38.434  1.00 84.34           C  
ATOM   1740  CD  GLU A 207      73.730  35.254  37.464  1.00 81.95           C  
ATOM   1741  OE1 GLU A 207      73.155  34.244  37.916  1.00 80.89           O  
ATOM   1742  OE2 GLU A 207      73.947  35.415  36.248  1.00 80.73           O  
ATOM   1743  N   GLU A 208      71.462  35.702  42.062  1.00 84.91           N  
ATOM   1744  CA  GLU A 208      70.832  34.892  43.126  1.00 84.60           C  
ATOM   1745  C   GLU A 208      69.401  34.437  42.834  1.00 84.11           C  
ATOM   1746  O   GLU A 208      69.098  33.247  42.918  1.00 83.92           O  
ATOM   1747  CB  GLU A 208      70.816  35.662  44.447  1.00 84.71           C  
ATOM   1748  CG  GLU A 208      71.784  35.174  45.509  1.00 85.25           C  
ATOM   1749  CD  GLU A 208      72.106  36.265  46.527  1.00 85.93           C  
ATOM   1750  OE1 GLU A 208      71.158  36.843  47.102  1.00 85.58           O  
ATOM   1751  OE2 GLU A 208      73.308  36.555  46.746  1.00 86.43           O  
ATOM   1752  N   PHE A 209      68.536  35.394  42.500  1.00 83.50           N  
ATOM   1753  CA  PHE A 209      67.096  35.160  42.413  1.00 83.06           C  
ATOM   1754  C   PHE A 209      66.667  33.978  41.520  1.00 82.88           C  
ATOM   1755  O   PHE A 209      65.726  33.253  41.861  1.00 82.83           O  
ATOM   1756  CB  PHE A 209      66.365  36.435  42.001  1.00 82.93           C  
ATOM   1757  CG  PHE A 209      64.883  36.298  42.020  1.00 83.05           C  
ATOM   1758  CD1 PHE A 209      64.166  36.550  43.193  1.00 83.99           C  
ATOM   1759  CD2 PHE A 209      64.195  35.885  40.882  1.00 82.87           C  
ATOM   1760  CE1 PHE A 209      62.762  36.407  43.235  1.00 83.78           C  
ATOM   1761  CE2 PHE A 209      62.803  35.736  40.903  1.00 83.65           C  
ATOM   1762  CZ  PHE A 209      62.078  36.001  42.088  1.00 83.44           C  
ATOM   1763  N   PHE A 210      67.345  33.785  40.389  1.00 82.44           N  
ATOM   1764  CA  PHE A 210      67.044  32.646  39.517  1.00 81.74           C  
ATOM   1765  C   PHE A 210      67.848  31.410  39.895  1.00 81.30           C  
ATOM   1766  O   PHE A 210      67.401  30.302  39.620  1.00 81.00           O  
ATOM   1767  CB  PHE A 210      67.240  32.988  38.039  1.00 81.90           C  
ATOM   1768  CG  PHE A 210      66.815  34.385  37.677  1.00 82.42           C  
ATOM   1769  CD1 PHE A 210      67.770  35.368  37.405  1.00 82.98           C  
ATOM   1770  CD2 PHE A 210      65.469  34.728  37.619  1.00 82.46           C  
ATOM   1771  CE1 PHE A 210      67.386  36.671  37.068  1.00 82.61           C  
ATOM   1772  CE2 PHE A 210      65.078  36.030  37.283  1.00 82.58           C  
ATOM   1773  CZ  PHE A 210      66.040  37.001  37.011  1.00 82.22           C  
ATOM   1774  N   ARG A 211      69.022  31.588  40.520  1.00 80.99           N  
ATOM   1775  CA  ARG A 211      69.703  30.467  41.187  1.00 80.52           C  
ATOM   1776  C   ARG A 211      68.633  29.821  42.090  1.00 80.23           C  
ATOM   1777  O   ARG A 211      68.279  28.645  41.931  1.00 79.92           O  
ATOM   1778  CB  ARG A 211      70.935  30.915  42.016  1.00 80.40           C  
ATOM   1779  CG  ARG A 211      72.113  31.552  41.233  1.00 80.79           C  
ATOM   1780  CD  ARG A 211      73.496  31.444  41.961  1.00 80.56           C  
ATOM   1781  NE  ARG A 211      74.514  32.360  41.408  1.00 80.92           N  
ATOM   1782  CZ  ARG A 211      75.810  32.409  41.766  1.00 81.24           C  
ATOM   1783  NH1 ARG A 211      76.301  31.578  42.682  1.00 81.56           N  
ATOM   1784  NH2 ARG A 211      76.633  33.295  41.196  1.00 78.96           N  
ATOM   1785  N   LEU A 212      68.072  30.651  42.973  1.00 79.92           N  
ATOM   1786  CA  LEU A 212      67.110  30.247  44.005  1.00 79.27           C  
ATOM   1787  C   LEU A 212      65.796  29.647  43.504  1.00 78.95           C  
ATOM   1788  O   LEU A 212      65.321  28.672  44.066  1.00 79.05           O  
ATOM   1789  CB  LEU A 212      66.847  31.416  44.961  1.00 79.08           C  
ATOM   1790  CG  LEU A 212      68.081  31.877  45.751  1.00 78.39           C  
ATOM   1791  CD1 LEU A 212      67.773  33.120  46.584  1.00 77.73           C  
ATOM   1792  CD2 LEU A 212      68.638  30.745  46.617  1.00 76.84           C  
ATOM   1793  N   CYS A 213      65.213  30.218  42.457  1.00 78.59           N  
ATOM   1794  CA  CYS A 213      64.007  29.640  41.869  1.00 78.31           C  
ATOM   1795  C   CYS A 213      64.287  28.313  41.195  1.00 78.20           C  
ATOM   1796  O   CYS A 213      63.440  27.434  41.203  1.00 78.31           O  
ATOM   1797  CB  CYS A 213      63.399  30.573  40.840  1.00 78.14           C  
ATOM   1798  SG  CYS A 213      62.672  32.064  41.501  1.00 78.60           S  
ATOM   1799  N   MET A 214      65.464  28.177  40.597  1.00 78.14           N  
ATOM   1800  CA  MET A 214      65.832  26.944  39.921  1.00 78.37           C  
ATOM   1801  C   MET A 214      65.935  25.826  40.947  1.00 78.03           C  
ATOM   1802  O   MET A 214      65.279  24.795  40.815  1.00 78.25           O  
ATOM   1803  CB  MET A 214      67.159  27.097  39.175  1.00 78.36           C  
ATOM   1804  CG  MET A 214      67.389  26.073  38.076  1.00 78.66           C  
ATOM   1805  SD  MET A 214      69.142  25.665  37.855  1.00 79.47           S  
ATOM   1806  CE  MET A 214      69.217  24.033  38.633  1.00 78.55           C  
ATOM   1807  N   GLU A 215      66.744  26.055  41.979  1.00 77.66           N  
ATOM   1808  CA  GLU A 215      66.994  25.057  43.010  1.00 77.39           C  
ATOM   1809  C   GLU A 215      65.709  24.519  43.665  1.00 77.01           C  
ATOM   1810  O   GLU A 215      65.650  23.352  44.047  1.00 77.03           O  
ATOM   1811  CB  GLU A 215      67.948  25.625  44.062  1.00 77.26           C  
ATOM   1812  CG  GLU A 215      69.384  25.756  43.566  1.00 78.55           C  
ATOM   1813  CD  GLU A 215      70.154  26.947  44.180  1.00 80.55           C  
ATOM   1814  OE1 GLU A 215      69.568  27.716  44.985  1.00 81.90           O  
ATOM   1815  OE2 GLU A 215      71.354  27.120  43.843  1.00 79.71           O  
ATOM   1816  N   ARG A 216      64.678  25.357  43.738  1.00 76.41           N  
ATOM   1817  CA  ARG A 216      63.480  25.071  44.533  1.00 76.04           C  
ATOM   1818  C   ARG A 216      62.259  24.555  43.753  1.00 75.98           C  
ATOM   1819  O   ARG A 216      61.671  23.545  44.118  1.00 75.84           O  
ATOM   1820  CB  ARG A 216      63.095  26.313  45.331  1.00 75.97           C  
ATOM   1821  CG  ARG A 216      64.215  26.840  46.199  1.00 75.56           C  
ATOM   1822  CD  ARG A 216      63.917  28.232  46.689  1.00 73.78           C  
ATOM   1823  NE  ARG A 216      64.971  28.726  47.573  1.00 73.76           N  
ATOM   1824  CZ  ARG A 216      64.975  29.940  48.119  1.00 74.23           C  
ATOM   1825  NH1 ARG A 216      63.979  30.783  47.867  1.00 74.28           N  
ATOM   1826  NH2 ARG A 216      65.970  30.320  48.914  1.00 73.77           N  
ATOM   1827  N   SER A 217      61.879  25.261  42.692  1.00 76.13           N  
ATOM   1828  CA  SER A 217      60.736  24.892  41.852  1.00 76.02           C  
ATOM   1829  C   SER A 217      60.570  23.384  41.742  1.00 75.73           C  
ATOM   1830  O   SER A 217      61.455  22.671  41.270  1.00 75.88           O  
ATOM   1831  CB  SER A 217      60.852  25.534  40.461  1.00 76.12           C  
ATOM   1832  OG  SER A 217      61.998  25.066  39.764  1.00 76.39           O  
ATOM   1833  N   THR A 218      59.409  22.921  42.182  1.00 75.66           N  
ATOM   1834  CA  THR A 218      59.137  21.494  42.412  1.00 75.53           C  
ATOM   1835  C   THR A 218      58.723  20.723  41.144  1.00 75.32           C  
ATOM   1836  O   THR A 218      58.353  19.536  41.204  1.00 75.00           O  
ATOM   1837  CB  THR A 218      58.052  21.324  43.530  1.00 75.61           C  
ATOM   1838  OG1 THR A 218      57.136  22.430  43.485  1.00 74.90           O  
ATOM   1839  CG2 THR A 218      58.702  21.280  44.918  1.00 75.17           C  
ATOM   1840  N   HIS A 219      58.794  21.410  40.004  1.00 74.99           N  
ATOM   1841  CA  HIS A 219      58.326  20.868  38.736  1.00 74.44           C  
ATOM   1842  C   HIS A 219      59.346  21.053  37.641  1.00 74.09           C  
ATOM   1843  O   HIS A 219      60.130  22.003  37.673  1.00 74.08           O  
ATOM   1844  CB  HIS A 219      57.001  21.511  38.355  1.00 74.31           C  
ATOM   1845  CG  HIS A 219      55.896  21.172  39.298  1.00 74.43           C  
ATOM   1846  ND1 HIS A 219      55.011  20.137  39.071  1.00 75.43           N  
ATOM   1847  CD2 HIS A 219      55.559  21.698  40.498  1.00 73.86           C  
ATOM   1848  CE1 HIS A 219      54.169  20.052  40.084  1.00 74.80           C  
ATOM   1849  NE2 HIS A 219      54.478  20.992  40.960  1.00 74.21           N  
ATOM   1850  N   LYS A 220      59.325  20.145  36.673  1.00 73.64           N  
ATOM   1851  CA  LYS A 220      60.306  20.161  35.604  1.00 73.66           C  
ATOM   1852  C   LYS A 220      60.198  21.419  34.739  1.00 73.42           C  
ATOM   1853  O   LYS A 220      61.206  22.094  34.499  1.00 73.26           O  
ATOM   1854  CB  LYS A 220      60.215  18.883  34.783  1.00 73.39           C  
ATOM   1855  CG  LYS A 220      60.106  17.707  35.676  1.00 74.33           C  
ATOM   1856  CD  LYS A 220      60.842  16.514  35.139  1.00 77.04           C  
ATOM   1857  CE  LYS A 220      60.694  15.338  36.116  1.00 78.44           C  
ATOM   1858  NZ  LYS A 220      61.219  14.068  35.531  1.00 80.58           N  
ATOM   1859  N   SER A 221      58.970  21.735  34.322  1.00 73.18           N  
ATOM   1860  CA  SER A 221      58.676  22.921  33.512  1.00 73.09           C  
ATOM   1861  C   SER A 221      59.069  24.232  34.193  1.00 72.99           C  
ATOM   1862  O   SER A 221      59.716  25.079  33.573  1.00 73.22           O  
ATOM   1863  CB  SER A 221      57.200  22.956  33.102  1.00 73.22           C  
ATOM   1864  OG  SER A 221      56.337  22.958  34.225  1.00 72.94           O  
ATOM   1865  N   SER A 222      58.692  24.396  35.459  1.00 72.72           N  
ATOM   1866  CA  SER A 222      59.150  25.540  36.237  1.00 72.55           C  
ATOM   1867  C   SER A 222      60.685  25.545  36.382  1.00 73.15           C  
ATOM   1868  O   SER A 222      61.332  26.578  36.182  1.00 72.99           O  
ATOM   1869  CB  SER A 222      58.416  25.654  37.584  1.00 72.00           C  
ATOM   1870  OG  SER A 222      58.525  24.487  38.367  1.00 71.01           O  
ATOM   1871  N   LYS A 223      61.267  24.384  36.672  1.00 73.73           N  
ATOM   1872  CA  LYS A 223      62.713  24.290  36.871  1.00 74.58           C  
ATOM   1873  C   LYS A 223      63.532  24.565  35.602  1.00 75.42           C  
ATOM   1874  O   LYS A 223      64.548  25.299  35.649  1.00 75.25           O  
ATOM   1875  CB  LYS A 223      63.088  22.929  37.454  1.00 74.55           C  
ATOM   1876  CG  LYS A 223      64.305  22.980  38.334  1.00 74.00           C  
ATOM   1877  CD  LYS A 223      64.428  21.728  39.147  1.00 73.86           C  
ATOM   1878  CE  LYS A 223      65.839  21.596  39.666  1.00 74.80           C  
ATOM   1879  NZ  LYS A 223      66.137  20.186  40.003  1.00 75.10           N  
ATOM   1880  N   LYS A 224      63.100  23.966  34.482  1.00 75.97           N  
ATOM   1881  CA  LYS A 224      63.738  24.194  33.185  1.00 76.44           C  
ATOM   1882  C   LYS A 224      63.700  25.677  32.836  1.00 76.71           C  
ATOM   1883  O   LYS A 224      64.712  26.251  32.386  1.00 76.84           O  
ATOM   1884  CB  LYS A 224      63.071  23.369  32.081  1.00 76.53           C  
ATOM   1885  CG  LYS A 224      63.747  22.027  31.825  1.00 77.53           C  
ATOM   1886  CD  LYS A 224      62.885  21.094  30.982  1.00 79.13           C  
ATOM   1887  CE  LYS A 224      63.463  19.664  30.916  1.00 79.15           C  
ATOM   1888  NZ  LYS A 224      62.400  18.651  30.532  1.00 80.05           N  
ATOM   1889  N   ALA A 225      62.534  26.285  33.076  1.00 76.46           N  
ATOM   1890  CA  ALA A 225      62.271  27.669  32.717  1.00 76.22           C  
ATOM   1891  C   ALA A 225      63.146  28.668  33.482  1.00 76.34           C  
ATOM   1892  O   ALA A 225      63.715  29.573  32.872  1.00 76.54           O  
ATOM   1893  CB  ALA A 225      60.805  27.981  32.908  1.00 76.14           C  
ATOM   1894  N   TRP A 226      63.253  28.512  34.805  1.00 76.33           N  
ATOM   1895  CA  TRP A 226      64.146  29.358  35.613  1.00 76.10           C  
ATOM   1896  C   TRP A 226      65.597  29.133  35.229  1.00 76.68           C  
ATOM   1897  O   TRP A 226      66.406  30.063  35.312  1.00 76.86           O  
ATOM   1898  CB  TRP A 226      64.004  29.076  37.106  1.00 75.44           C  
ATOM   1899  CG  TRP A 226      62.722  29.503  37.699  1.00 74.24           C  
ATOM   1900  CD1 TRP A 226      61.737  28.697  38.146  1.00 73.72           C  
ATOM   1901  CD2 TRP A 226      62.282  30.845  37.927  1.00 74.06           C  
ATOM   1902  NE1 TRP A 226      60.696  29.437  38.637  1.00 73.85           N  
ATOM   1903  CE2 TRP A 226      61.000  30.764  38.516  1.00 74.09           C  
ATOM   1904  CE3 TRP A 226      62.839  32.111  37.683  1.00 73.62           C  
ATOM   1905  CZ2 TRP A 226      60.259  31.897  38.870  1.00 74.42           C  
ATOM   1906  CZ3 TRP A 226      62.110  33.238  38.040  1.00 73.70           C  
ATOM   1907  CH2 TRP A 226      60.827  33.123  38.626  1.00 74.04           C  
ATOM   1908  N   GLU A 227      65.925  27.900  34.828  1.00 77.27           N  
ATOM   1909  CA  GLU A 227      67.257  27.586  34.293  1.00 77.72           C  
ATOM   1910  C   GLU A 227      67.551  28.418  33.060  1.00 78.06           C  
ATOM   1911  O   GLU A 227      68.588  29.070  32.995  1.00 78.46           O  
ATOM   1912  CB  GLU A 227      67.406  26.101  33.959  1.00 77.90           C  
ATOM   1913  CG  GLU A 227      68.764  25.733  33.361  1.00 76.91           C  
ATOM   1914  CD  GLU A 227      69.334  24.478  33.981  1.00 76.52           C  
ATOM   1915  OE1 GLU A 227      68.663  23.420  33.961  1.00 76.32           O  
ATOM   1916  OE2 GLU A 227      70.455  24.558  34.508  1.00 76.35           O  
ATOM   1917  N   GLU A 228      66.643  28.398  32.089  1.00 78.25           N  
ATOM   1918  CA  GLU A 228      66.786  29.272  30.940  1.00 78.68           C  
ATOM   1919  C   GLU A 228      67.165  30.684  31.382  1.00 78.75           C  
ATOM   1920  O   GLU A 228      68.251  31.168  31.053  1.00 78.77           O  
ATOM   1921  CB  GLU A 228      65.512  29.295  30.111  1.00 78.74           C  
ATOM   1922  CG  GLU A 228      65.669  28.644  28.767  1.00 79.79           C  
ATOM   1923  CD  GLU A 228      64.374  28.066  28.264  1.00 81.75           C  
ATOM   1924  OE1 GLU A 228      63.466  28.837  27.849  1.00 80.95           O  
ATOM   1925  OE2 GLU A 228      64.269  26.821  28.300  1.00 83.93           O  
ATOM   1926  N   LEU A 229      66.285  31.314  32.160  1.00 78.77           N  
ATOM   1927  CA  LEU A 229      66.490  32.687  32.621  1.00 78.79           C  
ATOM   1928  C   LEU A 229      67.713  32.875  33.538  1.00 79.08           C  
ATOM   1929  O   LEU A 229      68.215  34.004  33.682  1.00 79.41           O  
ATOM   1930  CB  LEU A 229      65.216  33.266  33.262  1.00 78.62           C  
ATOM   1931  CG  LEU A 229      63.980  33.500  32.379  1.00 78.21           C  
ATOM   1932  CD1 LEU A 229      62.831  34.084  33.193  1.00 77.77           C  
ATOM   1933  CD2 LEU A 229      64.300  34.397  31.203  1.00 77.38           C  
ATOM   1934  N   LEU A 230      68.198  31.795  34.160  1.00 78.94           N  
ATOM   1935  CA  LEU A 230      69.506  31.881  34.800  1.00 78.98           C  
ATOM   1936  C   LEU A 230      70.522  32.131  33.688  1.00 78.92           C  
ATOM   1937  O   LEU A 230      71.105  33.217  33.608  1.00 78.80           O  
ATOM   1938  CB  LEU A 230      69.885  30.623  35.611  1.00 79.02           C  
ATOM   1939  CG  LEU A 230      71.347  30.634  36.127  1.00 78.60           C  
ATOM   1940  CD1 LEU A 230      71.458  31.287  37.495  1.00 78.53           C  
ATOM   1941  CD2 LEU A 230      72.007  29.266  36.148  1.00 77.98           C  
ATOM   1942  N   LYS A 231      70.663  31.144  32.805  1.00 78.67           N  
ATOM   1943  CA  LYS A 231      71.755  31.094  31.845  1.00 78.77           C  
ATOM   1944  C   LYS A 231      71.721  32.141  30.724  1.00 78.81           C  
ATOM   1945  O   LYS A 231      72.683  32.907  30.577  1.00 78.88           O  
ATOM   1946  CB  LYS A 231      71.896  29.681  31.289  1.00 78.72           C  
ATOM   1947  CG  LYS A 231      72.296  28.690  32.358  1.00 78.99           C  
ATOM   1948  CD  LYS A 231      72.535  27.314  31.792  1.00 80.17           C  
ATOM   1949  CE  LYS A 231      73.117  26.400  32.859  1.00 80.78           C  
ATOM   1950  NZ  LYS A 231      72.465  25.056  32.829  1.00 81.81           N  
ATOM   1951  N   ASN A 232      70.630  32.185  29.956  1.00 78.87           N  
ATOM   1952  CA  ASN A 232      70.540  33.096  28.807  1.00 78.96           C  
ATOM   1953  C   ASN A 232      70.430  34.566  29.165  1.00 79.22           C  
ATOM   1954  O   ASN A 232      69.388  35.078  29.586  1.00 78.74           O  
ATOM   1955  CB  ASN A 232      69.504  32.658  27.787  1.00 78.81           C  
ATOM   1956  CG  ASN A 232      69.965  31.466  26.979  1.00 79.01           C  
ATOM   1957  OD1 ASN A 232      71.041  31.485  26.363  1.00 77.41           O  
ATOM   1958  ND2 ASN A 232      69.158  30.404  26.989  1.00 79.81           N  
ATOM   1959  N   ARG A 233      71.564  35.212  28.916  1.00 80.03           N  
ATOM   1960  CA  ARG A 233      72.004  36.450  29.540  1.00 80.48           C  
ATOM   1961  C   ARG A 233      71.067  37.651  29.419  1.00 80.93           C  
ATOM   1962  O   ARG A 233      70.866  38.388  30.394  1.00 80.98           O  
ATOM   1963  CB  ARG A 233      73.406  36.780  29.022  1.00 80.45           C  
ATOM   1964  CG  ARG A 233      74.525  36.002  29.713  1.00 80.04           C  
ATOM   1965  CD  ARG A 233      74.916  36.707  31.009  1.00 79.22           C  
ATOM   1966  NE  ARG A 233      76.360  36.861  31.166  1.00 77.95           N  
ATOM   1967  CZ  ARG A 233      76.953  37.984  31.574  1.00 78.14           C  
ATOM   1968  NH1 ARG A 233      76.230  39.066  31.846  1.00 77.78           N  
ATOM   1969  NH2 ARG A 233      78.278  38.038  31.691  1.00 78.06           N  
ATOM   1970  N   GLU A 234      70.498  37.848  28.232  1.00 81.42           N  
ATOM   1971  CA  GLU A 234      69.635  39.004  27.985  1.00 81.81           C  
ATOM   1972  C   GLU A 234      68.151  38.656  28.052  1.00 82.06           C  
ATOM   1973  O   GLU A 234      67.302  39.553  28.031  1.00 81.94           O  
ATOM   1974  CB  GLU A 234      70.000  39.682  26.657  1.00 81.76           C  
ATOM   1975  CG  GLU A 234      71.259  40.540  26.750  1.00 81.61           C  
ATOM   1976  CD  GLU A 234      71.933  40.773  25.410  1.00 81.64           C  
ATOM   1977  OE1 GLU A 234      71.225  40.888  24.386  1.00 81.88           O  
ATOM   1978  OE2 GLU A 234      73.180  40.847  25.386  1.00 81.21           O  
ATOM   1979  N   LEU A 235      67.849  37.362  28.171  1.00 82.43           N  
ATOM   1980  CA  LEU A 235      66.461  36.904  28.200  1.00 83.09           C  
ATOM   1981  C   LEU A 235      65.650  37.463  29.380  1.00 83.31           C  
ATOM   1982  O   LEU A 235      64.416  37.481  29.331  1.00 83.09           O  
ATOM   1983  CB  LEU A 235      66.360  35.375  28.182  1.00 83.16           C  
ATOM   1984  CG  LEU A 235      67.037  34.462  27.152  1.00 84.06           C  
ATOM   1985  CD1 LEU A 235      66.062  33.318  26.806  1.00 84.65           C  
ATOM   1986  CD2 LEU A 235      67.535  35.156  25.877  1.00 84.73           C  
ATOM   1987  N   ARG A 236      66.348  37.920  30.422  1.00 83.60           N  
ATOM   1988  CA  ARG A 236      65.714  38.484  31.620  1.00 83.82           C  
ATOM   1989  C   ARG A 236      65.116  39.867  31.342  1.00 84.23           C  
ATOM   1990  O   ARG A 236      64.109  40.255  31.945  1.00 84.29           O  
ATOM   1991  CB  ARG A 236      66.717  38.582  32.771  1.00 83.64           C  
ATOM   1992  CG  ARG A 236      67.638  37.380  32.950  1.00 83.60           C  
ATOM   1993  CD  ARG A 236      69.003  37.865  33.389  1.00 84.36           C  
ATOM   1994  NE  ARG A 236      69.630  37.015  34.395  1.00 84.77           N  
ATOM   1995  CZ  ARG A 236      70.410  37.472  35.375  1.00 85.21           C  
ATOM   1996  NH1 ARG A 236      70.651  38.772  35.495  1.00 84.64           N  
ATOM   1997  NH2 ARG A 236      70.941  36.629  36.249  1.00 86.50           N  
ATOM   1998  N   GLU A 237      65.746  40.613  30.440  1.00 84.66           N  
ATOM   1999  CA  GLU A 237      65.200  41.887  30.009  1.00 85.09           C  
ATOM   2000  C   GLU A 237      63.897  41.651  29.271  1.00 85.63           C  
ATOM   2001  O   GLU A 237      62.890  42.311  29.536  1.00 85.75           O  
ATOM   2002  CB  GLU A 237      66.162  42.576  29.073  1.00 85.00           C  
ATOM   2003  CG  GLU A 237      67.585  42.589  29.529  1.00 84.59           C  
ATOM   2004  CD  GLU A 237      68.324  43.711  28.868  1.00 83.91           C  
ATOM   2005  OE1 GLU A 237      67.802  44.840  28.915  1.00 83.83           O  
ATOM   2006  OE2 GLU A 237      69.400  43.468  28.284  1.00 83.25           O  
ATOM   2007  N   LYS A 238      63.941  40.696  28.344  1.00 86.30           N  
ATOM   2008  CA  LYS A 238      62.784  40.294  27.546  1.00 87.00           C  
ATOM   2009  C   LYS A 238      61.678  39.565  28.336  1.00 87.72           C  
ATOM   2010  O   LYS A 238      60.486  39.759  28.066  1.00 87.84           O  
ATOM   2011  CB  LYS A 238      63.239  39.455  26.343  1.00 86.70           C  
ATOM   2012  CG  LYS A 238      63.620  40.281  25.145  1.00 86.08           C  
ATOM   2013  CD  LYS A 238      62.377  40.887  24.511  1.00 85.33           C  
ATOM   2014  CE  LYS A 238      62.606  42.327  24.108  1.00 84.77           C  
ATOM   2015  NZ  LYS A 238      63.698  42.436  23.105  1.00 84.77           N  
ATOM   2016  N   ALA A 239      62.074  38.729  29.297  1.00 88.35           N  
ATOM   2017  CA  ALA A 239      61.123  38.001  30.139  1.00 88.83           C  
ATOM   2018  C   ALA A 239      60.429  38.903  31.153  1.00 89.40           C  
ATOM   2019  O   ALA A 239      61.055  39.792  31.741  1.00 89.47           O  
ATOM   2020  CB  ALA A 239      61.809  36.864  30.851  1.00 88.71           C  
ATOM   2021  N   PHE A 240      59.129  38.670  31.335  1.00 90.07           N  
ATOM   2022  CA  PHE A 240      58.324  39.324  32.362  1.00 90.79           C  
ATOM   2023  C   PHE A 240      57.863  38.213  33.345  1.00 91.38           C  
ATOM   2024  O   PHE A 240      57.681  37.058  32.937  1.00 91.33           O  
ATOM   2025  CB  PHE A 240      57.121  40.050  31.718  1.00 90.89           C  
ATOM   2026  CG  PHE A 240      57.484  41.229  30.785  1.00 91.17           C  
ATOM   2027  CD1 PHE A 240      58.767  41.381  30.230  1.00 92.02           C  
ATOM   2028  CD2 PHE A 240      56.506  42.163  30.428  1.00 90.78           C  
ATOM   2029  CE1 PHE A 240      59.082  42.467  29.364  1.00 91.39           C  
ATOM   2030  CE2 PHE A 240      56.809  43.241  29.567  1.00 91.01           C  
ATOM   2031  CZ  PHE A 240      58.101  43.391  29.039  1.00 91.04           C  
ATOM   2032  N   LEU A 241      57.696  38.549  34.630  1.00 92.05           N  
ATOM   2033  CA  LEU A 241      57.350  37.555  35.678  1.00 92.51           C  
ATOM   2034  C   LEU A 241      56.031  37.807  36.403  1.00 93.06           C  
ATOM   2035  O   LEU A 241      55.791  38.895  36.929  1.00 93.08           O  
ATOM   2036  CB  LEU A 241      58.441  37.456  36.739  1.00 92.31           C  
ATOM   2037  CG  LEU A 241      59.883  37.381  36.279  1.00 92.85           C  
ATOM   2038  CD1 LEU A 241      60.817  37.333  37.490  1.00 93.53           C  
ATOM   2039  CD2 LEU A 241      60.080  36.188  35.359  1.00 92.98           C  
ATOM   2040  N   VAL A 242      55.216  36.757  36.476  1.00 94.00           N  
ATOM   2041  CA  VAL A 242      53.860  36.801  37.035  1.00 94.75           C  
ATOM   2042  C   VAL A 242      53.815  36.225  38.458  1.00 95.33           C  
ATOM   2043  O   VAL A 242      54.619  35.363  38.803  1.00 95.50           O  
ATOM   2044  CB  VAL A 242      52.866  36.047  36.104  1.00 94.65           C  
ATOM   2045  CG1 VAL A 242      51.427  36.220  36.570  1.00 95.23           C  
ATOM   2046  CG2 VAL A 242      53.006  36.535  34.669  1.00 93.98           C  
ATOM   2047  N   VAL A 243      52.897  36.744  39.276  1.00 96.19           N  
ATOM   2048  CA  VAL A 243      52.650  36.268  40.641  1.00 97.00           C  
ATOM   2049  C   VAL A 243      51.166  35.967  40.748  1.00 97.66           C  
ATOM   2050  O   VAL A 243      50.314  36.839  40.554  1.00 97.83           O  
ATOM   2051  CB  VAL A 243      53.059  37.305  41.734  1.00 96.99           C  
ATOM   2052  CG1 VAL A 243      52.655  36.819  43.136  1.00 96.51           C  
ATOM   2053  CG2 VAL A 243      54.566  37.602  41.673  1.00 96.93           C  
ATOM   2054  N   LEU A 244      50.859  34.721  41.063  1.00 98.30           N  
ATOM   2055  CA  LEU A 244      49.491  34.269  41.020  1.00 98.91           C  
ATOM   2056  C   LEU A 244      48.738  34.520  42.331  1.00 99.40           C  
ATOM   2057  O   LEU A 244      49.210  35.254  43.199  1.00 99.45           O  
ATOM   2058  CB  LEU A 244      49.463  32.789  40.608  1.00 99.05           C  
ATOM   2059  CG  LEU A 244      50.081  32.468  39.236  1.00 98.68           C  
ATOM   2060  CD1 LEU A 244      50.489  31.011  39.141  1.00 97.96           C  
ATOM   2061  CD2 LEU A 244      49.147  32.843  38.081  1.00 98.56           C  
ATOM   2062  N   GLU A 245      47.554  33.915  42.440  1.00100.12           N  
ATOM   2063  CA  GLU A 245      46.721  33.952  43.636  1.00100.68           C  
ATOM   2064  C   GLU A 245      47.442  33.448  44.885  1.00100.42           C  
ATOM   2065  O   GLU A 245      47.475  34.142  45.907  1.00100.59           O  
ATOM   2066  CB  GLU A 245      45.470  33.117  43.419  1.00101.04           C  
ATOM   2067  CG  GLU A 245      44.735  32.822  44.715  1.00104.04           C  
ATOM   2068  CD  GLU A 245      43.987  31.504  44.689  1.00107.86           C  
ATOM   2069  OE1 GLU A 245      43.655  31.015  43.577  1.00109.94           O  
ATOM   2070  OE2 GLU A 245      43.722  30.963  45.788  1.00109.08           O  
ATOM   2071  N   LYS A 246      47.990  32.235  44.807  1.00100.06           N  
ATOM   2072  CA  LYS A 246      48.764  31.660  45.915  1.00 99.61           C  
ATOM   2073  C   LYS A 246      50.255  31.977  45.761  1.00 99.22           C  
ATOM   2074  O   LYS A 246      51.101  31.065  45.780  1.00 99.34           O  
ATOM   2075  CB  LYS A 246      48.516  30.149  46.039  1.00 99.72           C  
ATOM   2076  CG  LYS A 246      47.117  29.794  46.534  1.00 99.71           C  
ATOM   2077  CD  LYS A 246      46.734  28.379  46.146  1.00100.60           C  
ATOM   2078  CE  LYS A 246      45.214  28.245  45.981  1.00101.30           C  
ATOM   2079  NZ  LYS A 246      44.770  26.912  45.469  1.00101.07           N  
ATOM   2080  N   GLY A 247      50.555  33.277  45.597  1.00 98.52           N  
ATOM   2081  CA  GLY A 247      51.923  33.822  45.514  1.00 97.07           C  
ATOM   2082  C   GLY A 247      52.947  32.774  45.131  1.00 96.10           C  
ATOM   2083  O   GLY A 247      53.867  32.476  45.896  1.00 95.86           O  
ATOM   2084  N   TYR A 248      52.761  32.200  43.948  1.00 95.14           N  
ATOM   2085  CA  TYR A 248      53.630  31.143  43.473  1.00 94.15           C  
ATOM   2086  C   TYR A 248      54.773  31.626  42.572  1.00 92.88           C  
ATOM   2087  O   TYR A 248      55.832  31.004  42.549  1.00 92.69           O  
ATOM   2088  CB  TYR A 248      52.819  30.044  42.796  1.00 94.86           C  
ATOM   2089  CG  TYR A 248      52.552  28.826  43.666  1.00 95.94           C  
ATOM   2090  CD1 TYR A 248      51.255  28.299  43.781  1.00 96.79           C  
ATOM   2091  CD2 TYR A 248      53.597  28.188  44.366  1.00 96.78           C  
ATOM   2092  CE1 TYR A 248      50.992  27.165  44.570  1.00 97.57           C  
ATOM   2093  CE2 TYR A 248      53.352  27.051  45.164  1.00 97.74           C  
ATOM   2094  CZ  TYR A 248      52.041  26.542  45.261  1.00 97.81           C  
ATOM   2095  OH  TYR A 248      51.778  25.421  46.038  1.00 97.23           O  
ATOM   2096  N   THR A 249      54.560  32.725  41.849  1.00 91.20           N  
ATOM   2097  CA  THR A 249      55.611  33.374  41.037  1.00 89.93           C  
ATOM   2098  C   THR A 249      56.300  32.505  39.965  1.00 88.90           C  
ATOM   2099  O   THR A 249      57.132  31.652  40.268  1.00 88.77           O  
ATOM   2100  CB  THR A 249      56.689  34.054  41.909  1.00 89.91           C  
ATOM   2101  OG1 THR A 249      56.075  34.581  43.093  1.00 90.14           O  
ATOM   2102  CG2 THR A 249      57.380  35.164  41.121  1.00 89.00           C  
ATOM   2103  N   TYR A 250      55.973  32.772  38.708  1.00 87.57           N  
ATOM   2104  CA  TYR A 250      56.483  31.996  37.591  1.00 86.53           C  
ATOM   2105  C   TYR A 250      56.957  32.917  36.455  1.00 86.38           C  
ATOM   2106  O   TYR A 250      56.564  34.085  36.436  1.00 86.44           O  
ATOM   2107  CB  TYR A 250      55.377  31.068  37.106  1.00 85.78           C  
ATOM   2108  CG  TYR A 250      55.053  29.948  38.072  1.00 84.97           C  
ATOM   2109  CD1 TYR A 250      53.887  29.966  38.841  1.00 83.60           C  
ATOM   2110  CD2 TYR A 250      55.911  28.859  38.204  1.00 84.13           C  
ATOM   2111  CE1 TYR A 250      53.588  28.919  39.720  1.00 82.71           C  
ATOM   2112  CE2 TYR A 250      55.629  27.825  39.075  1.00 83.99           C  
ATOM   2113  CZ  TYR A 250      54.469  27.849  39.835  1.00 83.64           C  
ATOM   2114  OH  TYR A 250      54.230  26.790  40.701  1.00 83.35           O  
ATOM   2115  N   PRO A 251      57.829  32.419  35.532  1.00 86.01           N  
ATOM   2116  CA  PRO A 251      58.101  33.105  34.256  1.00 85.83           C  
ATOM   2117  C   PRO A 251      56.825  33.423  33.486  1.00 85.93           C  
ATOM   2118  O   PRO A 251      55.727  33.226  33.997  1.00 86.12           O  
ATOM   2119  CB  PRO A 251      58.923  32.078  33.470  1.00 85.48           C  
ATOM   2120  CG  PRO A 251      59.611  31.305  34.487  1.00 85.54           C  
ATOM   2121  CD  PRO A 251      58.657  31.206  35.662  1.00 85.95           C  
ATOM   2122  N   ALA A 252      56.955  33.916  32.263  1.00 86.15           N  
ATOM   2123  CA  ALA A 252      55.767  34.197  31.466  1.00 86.01           C  
ATOM   2124  C   ALA A 252      55.555  33.110  30.424  1.00 85.77           C  
ATOM   2125  O   ALA A 252      54.420  32.663  30.216  1.00 85.74           O  
ATOM   2126  CB  ALA A 252      55.859  35.561  30.827  1.00 86.19           C  
ATOM   2127  N   THR A 253      56.654  32.668  29.811  1.00 85.24           N  
ATOM   2128  CA  THR A 253      56.628  31.651  28.765  1.00 85.13           C  
ATOM   2129  C   THR A 253      55.972  30.335  29.223  1.00 85.20           C  
ATOM   2130  O   THR A 253      55.606  29.486  28.400  1.00 85.19           O  
ATOM   2131  CB  THR A 253      58.048  31.364  28.235  1.00 85.08           C  
ATOM   2132  OG1 THR A 253      58.897  32.490  28.483  1.00 85.15           O  
ATOM   2133  CG2 THR A 253      58.014  31.088  26.738  1.00 85.21           C  
ATOM   2134  N   ILE A 254      55.823  30.192  30.539  1.00 85.19           N  
ATOM   2135  CA  ILE A 254      55.267  29.003  31.187  1.00 85.23           C  
ATOM   2136  C   ILE A 254      53.758  29.108  31.359  1.00 85.49           C  
ATOM   2137  O   ILE A 254      53.069  28.112  31.648  1.00 85.26           O  
ATOM   2138  CB  ILE A 254      55.910  28.828  32.570  1.00 85.16           C  
ATOM   2139  CG1 ILE A 254      56.912  27.688  32.537  1.00 86.06           C  
ATOM   2140  CG2 ILE A 254      54.892  28.572  33.650  1.00 84.57           C  
ATOM   2141  CD1 ILE A 254      57.459  27.354  33.904  1.00 87.62           C  
ATOM   2142  N   LEU A 255      53.250  30.325  31.169  1.00 85.64           N  
ATOM   2143  CA  LEU A 255      51.882  30.642  31.564  1.00 85.45           C  
ATOM   2144  C   LEU A 255      50.922  30.887  30.395  1.00 85.57           C  
ATOM   2145  O   LEU A 255      51.235  31.626  29.458  1.00 85.61           O  
ATOM   2146  CB  LEU A 255      51.886  31.795  32.571  1.00 85.04           C  
ATOM   2147  CG  LEU A 255      52.602  31.532  33.905  1.00 83.95           C  
ATOM   2148  CD1 LEU A 255      52.590  32.782  34.741  1.00 83.48           C  
ATOM   2149  CD2 LEU A 255      51.995  30.388  34.694  1.00 82.38           C  
ATOM   2150  N   LYS A 256      49.769  30.222  30.475  1.00 85.74           N  
ATOM   2151  CA  LYS A 256      48.719  30.255  29.469  1.00 86.27           C  
ATOM   2152  C   LYS A 256      47.385  30.566  30.160  1.00 86.95           C  
ATOM   2153  O   LYS A 256      47.195  30.205  31.310  1.00 86.70           O  
ATOM   2154  CB  LYS A 256      48.622  28.902  28.762  1.00 85.96           C  
ATOM   2155  CG  LYS A 256      49.727  28.586  27.765  1.00 85.91           C  
ATOM   2156  CD  LYS A 256      49.384  27.308  26.989  1.00 86.51           C  
ATOM   2157  CE  LYS A 256      50.595  26.726  26.267  1.00 87.20           C  
ATOM   2158  NZ  LYS A 256      50.511  25.237  26.135  1.00 87.08           N  
ATOM   2159  N   PRO A 257      46.452  31.243  29.465  1.00 87.98           N  
ATOM   2160  CA  PRO A 257      45.175  31.590  30.111  1.00 88.64           C  
ATOM   2161  C   PRO A 257      44.110  30.498  30.067  1.00 89.43           C  
ATOM   2162  O   PRO A 257      44.087  29.677  29.140  1.00 89.24           O  
ATOM   2163  CB  PRO A 257      44.682  32.794  29.305  1.00 88.65           C  
ATOM   2164  CG  PRO A 257      45.483  32.791  28.010  1.00 88.70           C  
ATOM   2165  CD  PRO A 257      46.535  31.734  28.075  1.00 88.01           C  
ATOM   2166  N   VAL A 258      43.225  30.496  31.060  1.00 90.25           N  
ATOM   2167  CA  VAL A 258      42.067  29.624  30.985  1.00 91.25           C  
ATOM   2168  C   VAL A 258      40.779  30.424  30.914  1.00 92.31           C  
ATOM   2169  O   VAL A 258      40.346  31.082  31.870  1.00 92.17           O  
ATOM   2170  CB  VAL A 258      42.031  28.565  32.095  1.00 91.18           C  
ATOM   2171  CG1 VAL A 258      40.859  27.597  31.876  1.00 90.70           C  
ATOM   2172  CG2 VAL A 258      43.341  27.812  32.120  1.00 91.20           C  
ATOM   2173  N   LEU A 259      40.183  30.339  29.740  1.00 93.90           N  
ATOM   2174  CA  LEU A 259      39.024  31.107  29.381  1.00 95.74           C  
ATOM   2175  C   LEU A 259      37.779  30.282  29.656  1.00 97.41           C  
ATOM   2176  O   LEU A 259      37.780  29.063  29.456  1.00 97.13           O  
ATOM   2177  CB  LEU A 259      39.091  31.434  27.888  1.00 95.48           C  
ATOM   2178  CG  LEU A 259      40.433  31.306  27.157  1.00 94.38           C  
ATOM   2179  CD1 LEU A 259      40.192  30.941  25.712  1.00 92.46           C  
ATOM   2180  CD2 LEU A 259      41.287  32.564  27.277  1.00 93.81           C  
ATOM   2181  N   THR A 260      36.724  30.951  30.119  1.00 99.89           N  
ATOM   2182  CA  THR A 260      35.420  30.314  30.237  1.00102.29           C  
ATOM   2183  C   THR A 260      34.641  30.502  28.956  1.00104.26           C  
ATOM   2184  O   THR A 260      34.702  31.564  28.323  1.00104.81           O  
ATOM   2185  CB  THR A 260      34.532  30.911  31.337  1.00102.00           C  
ATOM   2186  OG1 THR A 260      35.334  31.426  32.405  1.00102.05           O  
ATOM   2187  CG2 THR A 260      33.553  29.843  31.855  1.00102.23           C  
ATOM   2188  N   TYR A 261      33.921  29.445  28.593  1.00106.47           N  
ATOM   2189  CA  TYR A 261      32.771  29.490  27.706  1.00108.38           C  
ATOM   2190  C   TYR A 261      32.329  30.917  27.413  1.00109.19           C  
ATOM   2191  O   TYR A 261      32.644  31.466  26.367  1.00109.02           O  
ATOM   2192  CB  TYR A 261      31.632  28.771  28.414  1.00109.17           C  
ATOM   2193  CG  TYR A 261      30.814  27.885  27.535  1.00110.18           C  
ATOM   2194  CD1 TYR A 261      30.727  26.529  27.807  1.00110.82           C  
ATOM   2195  CD2 TYR A 261      30.115  28.396  26.437  1.00111.46           C  
ATOM   2196  CE1 TYR A 261      29.974  25.686  27.016  1.00111.82           C  
ATOM   2197  CE2 TYR A 261      29.349  27.558  25.626  1.00112.67           C  
ATOM   2198  CZ  TYR A 261      29.283  26.197  25.934  1.00112.04           C  
ATOM   2199  OH  TYR A 261      28.536  25.329  25.174  1.00111.66           O  
ATOM   2200  N   GLU A 262      31.609  31.508  28.365  1.00110.51           N  
ATOM   2201  CA  GLU A 262      31.168  32.899  28.279  1.00111.80           C  
ATOM   2202  C   GLU A 262      32.139  33.778  27.484  1.00112.30           C  
ATOM   2203  O   GLU A 262      31.821  34.196  26.375  1.00112.24           O  
ATOM   2204  CB  GLU A 262      30.937  33.458  29.685  1.00111.88           C  
ATOM   2205  CG  GLU A 262      29.876  32.697  30.463  1.00113.17           C  
ATOM   2206  CD  GLU A 262      30.386  32.187  31.806  1.00115.52           C  
ATOM   2207  OE1 GLU A 262      30.824  33.023  32.643  1.00115.29           O  
ATOM   2208  OE2 GLU A 262      30.344  30.944  32.019  1.00116.24           O  
ATOM   2209  N   ASN A 263      33.332  34.010  28.024  1.00113.20           N  
ATOM   2210  CA  ASN A 263      34.274  34.978  27.443  1.00114.11           C  
ATOM   2211  C   ASN A 263      34.993  34.513  26.172  1.00114.62           C  
ATOM   2212  O   ASN A 263      36.164  34.829  25.957  1.00114.59           O  
ATOM   2213  CB  ASN A 263      35.295  35.425  28.491  1.00114.22           C  
ATOM   2214  CG  ASN A 263      34.660  35.735  29.836  1.00114.76           C  
ATOM   2215  OD1 ASN A 263      33.727  35.052  30.279  1.00114.59           O  
ATOM   2216  ND2 ASN A 263      35.179  36.760  30.506  1.00114.81           N  
ATOM   2217  N   LEU A 264      34.285  33.752  25.340  1.00115.47           N  
ATOM   2218  CA  LEU A 264      34.732  33.445  23.978  1.00116.30           C  
ATOM   2219  C   LEU A 264      33.789  34.177  23.021  1.00116.94           C  
ATOM   2220  O   LEU A 264      32.885  34.883  23.466  1.00116.94           O  
ATOM   2221  CB  LEU A 264      34.687  31.930  23.691  1.00116.30           C  
ATOM   2222  CG  LEU A 264      35.276  30.875  24.641  1.00116.24           C  
ATOM   2223  CD1 LEU A 264      34.746  29.481  24.309  1.00115.74           C  
ATOM   2224  CD2 LEU A 264      36.791  30.891  24.629  1.00116.09           C  
ATOM   2225  N   GLU A 265      33.992  34.004  21.717  1.00117.90           N  
ATOM   2226  CA  GLU A 265      33.109  34.595  20.705  1.00118.93           C  
ATOM   2227  C   GLU A 265      31.802  33.812  20.501  1.00119.32           C  
ATOM   2228  O   GLU A 265      31.620  32.721  21.053  1.00119.42           O  
ATOM   2229  CB  GLU A 265      33.846  34.752  19.369  1.00119.15           C  
ATOM   2230  CG  GLU A 265      34.623  36.056  19.221  1.00119.78           C  
ATOM   2231  CD  GLU A 265      35.913  35.856  18.461  1.00120.96           C  
ATOM   2232  OE1 GLU A 265      35.864  35.338  17.317  1.00120.84           O  
ATOM   2233  OE2 GLU A 265      36.980  36.201  19.021  1.00121.24           O  
ATOM   2234  N   ASP A 266      30.892  34.396  19.720  1.00119.92           N  
ATOM   2235  CA  ASP A 266      29.642  33.740  19.316  1.00120.32           C  
ATOM   2236  C   ASP A 266      29.946  32.450  18.540  1.00120.51           C  
ATOM   2237  O   ASP A 266      29.504  31.354  18.932  1.00120.66           O  
ATOM   2238  CB  ASP A 266      28.780  34.689  18.449  1.00120.35           C  
ATOM   2239  CG  ASP A 266      27.952  35.673  19.273  1.00119.95           C  
ATOM   2240  OD1 ASP A 266      28.524  36.403  20.109  1.00119.73           O  
ATOM   2241  OD2 ASP A 266      26.722  35.728  19.063  1.00119.17           O  
ATOM   2242  N   GLU A 267      30.714  32.604  17.452  1.00120.50           N  
ATOM   2243  CA  GLU A 267      31.088  31.506  16.541  1.00120.35           C  
ATOM   2244  C   GLU A 267      31.972  30.448  17.208  1.00119.96           C  
ATOM   2245  O   GLU A 267      31.749  29.238  17.026  1.00120.10           O  
ATOM   2246  CB  GLU A 267      31.759  32.043  15.259  1.00120.35           C  
ATOM   2247  CG  GLU A 267      32.810  33.155  15.476  1.00120.75           C  
ATOM   2248  CD  GLU A 267      33.709  33.383  14.257  1.00120.63           C  
ATOM   2249  OE1 GLU A 267      34.415  32.432  13.835  1.00120.35           O  
ATOM   2250  OE2 GLU A 267      33.712  34.520  13.730  1.00120.20           O  
ATOM   2251  N   GLU A 268      32.962  30.912  17.977  1.00119.23           N  
ATOM   2252  CA  GLU A 268      33.835  30.035  18.745  1.00118.44           C  
ATOM   2253  C   GLU A 268      32.998  29.130  19.650  1.00117.83           C  
ATOM   2254  O   GLU A 268      33.033  27.898  19.514  1.00117.94           O  
ATOM   2255  CB  GLU A 268      34.830  30.855  19.573  1.00118.43           C  
ATOM   2256  CG  GLU A 268      36.007  31.426  18.786  1.00118.44           C  
ATOM   2257  CD  GLU A 268      37.042  32.090  19.686  1.00118.39           C  
ATOM   2258  OE1 GLU A 268      36.899  32.003  20.923  1.00117.76           O  
ATOM   2259  OE2 GLU A 268      38.003  32.701  19.163  1.00118.70           O  
ATOM   2260  N   ARG A 269      32.218  29.758  20.529  1.00116.74           N  
ATOM   2261  CA  ARG A 269      31.457  29.058  21.555  1.00115.89           C  
ATOM   2262  C   ARG A 269      30.556  27.949  21.065  1.00115.47           C  
ATOM   2263  O   ARG A 269      30.484  26.894  21.669  1.00115.40           O  
ATOM   2264  CB  ARG A 269      30.628  30.038  22.353  1.00115.81           C  
ATOM   2265  CG  ARG A 269      31.310  30.475  23.593  1.00115.23           C  
ATOM   2266  CD  ARG A 269      30.362  31.263  24.424  1.00114.80           C  
ATOM   2267  NE  ARG A 269      30.184  32.590  23.864  1.00113.34           N  
ATOM   2268  CZ  ARG A 269      29.317  33.478  24.321  1.00112.36           C  
ATOM   2269  NH1 ARG A 269      28.535  33.184  25.353  1.00111.59           N  
ATOM   2270  NH2 ARG A 269      29.240  34.662  23.738  1.00112.31           N  
ATOM   2271  N   ASN A 270      29.851  28.187  19.979  1.00115.15           N  
ATOM   2272  CA  ASN A 270      28.958  27.163  19.477  1.00114.85           C  
ATOM   2273  C   ASN A 270      29.708  25.927  18.924  1.00114.57           C  
ATOM   2274  O   ASN A 270      29.214  24.811  19.065  1.00114.55           O  
ATOM   2275  CB  ASN A 270      27.975  27.760  18.457  1.00114.86           C  
ATOM   2276  CG  ASN A 270      26.611  27.095  18.505  1.00113.99           C  
ATOM   2277  OD1 ASN A 270      26.201  26.454  17.537  1.00111.92           O  
ATOM   2278  ND2 ASN A 270      25.904  27.236  19.635  1.00112.69           N  
ATOM   2279  N   GLU A 271      30.887  26.135  18.318  1.00113.99           N  
ATOM   2280  CA  GLU A 271      31.760  25.048  17.832  1.00113.49           C  
ATOM   2281  C   GLU A 271      32.391  24.306  19.005  1.00113.00           C  
ATOM   2282  O   GLU A 271      32.324  23.083  19.111  1.00112.99           O  
ATOM   2283  CB  GLU A 271      32.886  25.605  16.955  1.00113.59           C  
ATOM   2284  CG  GLU A 271      32.663  25.552  15.435  1.00113.98           C  
ATOM   2285  CD  GLU A 271      33.683  26.407  14.654  1.00113.96           C  
ATOM   2286  OE1 GLU A 271      34.904  26.144  14.760  1.00114.17           O  
ATOM   2287  OE2 GLU A 271      33.266  27.343  13.932  1.00113.65           O  
ATOM   2288  N   VAL A 272      33.026  25.074  19.876  1.00112.36           N  
ATOM   2289  CA  VAL A 272      33.606  24.576  21.106  1.00111.77           C  
ATOM   2290  C   VAL A 272      32.584  23.783  21.929  1.00111.48           C  
ATOM   2291  O   VAL A 272      32.895  22.715  22.451  1.00111.27           O  
ATOM   2292  CB  VAL A 272      34.119  25.776  21.918  1.00111.64           C  
ATOM   2293  CG1 VAL A 272      34.400  25.397  23.332  1.00112.10           C  
ATOM   2294  CG2 VAL A 272      35.355  26.369  21.266  1.00111.72           C  
ATOM   2295  N   ALA A 273      31.364  24.317  21.993  1.00111.36           N  
ATOM   2296  CA  ALA A 273      30.273  23.854  22.867  1.00111.19           C  
ATOM   2297  C   ALA A 273      29.908  22.395  22.727  1.00111.08           C  
ATOM   2298  O   ALA A 273      29.562  21.736  23.702  1.00110.95           O  
ATOM   2299  CB  ALA A 273      29.036  24.692  22.623  1.00111.31           C  
ATOM   2300  N   ASP A 274      29.956  21.905  21.498  1.00111.14           N  
ATOM   2301  CA  ASP A 274      29.661  20.515  21.213  1.00111.45           C  
ATOM   2302  C   ASP A 274      30.531  19.627  22.096  1.00111.37           C  
ATOM   2303  O   ASP A 274      30.098  18.571  22.584  1.00111.35           O  
ATOM   2304  CB  ASP A 274      29.929  20.229  19.734  1.00111.57           C  
ATOM   2305  CG  ASP A 274      29.366  21.320  18.808  1.00112.76           C  
ATOM   2306  OD1 ASP A 274      28.121  21.455  18.698  1.00113.64           O  
ATOM   2307  OD2 ASP A 274      30.170  22.048  18.179  1.00113.17           O  
ATOM   2308  N   ILE A 275      31.750  20.098  22.336  1.00111.01           N  
ATOM   2309  CA  ILE A 275      32.763  19.281  22.962  1.00110.79           C  
ATOM   2310  C   ILE A 275      32.876  19.474  24.491  1.00110.44           C  
ATOM   2311  O   ILE A 275      32.897  18.485  25.226  1.00110.66           O  
ATOM   2312  CB  ILE A 275      34.109  19.420  22.224  1.00110.82           C  
ATOM   2313  CG1 ILE A 275      33.869  19.942  20.798  1.00111.14           C  
ATOM   2314  CG2 ILE A 275      34.819  18.071  22.193  1.00111.16           C  
ATOM   2315  CD1 ILE A 275      35.125  20.312  20.004  1.00110.91           C  
ATOM   2316  N   VAL A 276      32.923  20.722  24.964  1.00109.89           N  
ATOM   2317  CA  VAL A 276      33.008  21.005  26.413  1.00109.40           C  
ATOM   2318  C   VAL A 276      31.832  20.377  27.171  1.00109.19           C  
ATOM   2319  O   VAL A 276      32.043  19.617  28.114  1.00109.08           O  
ATOM   2320  CB  VAL A 276      33.129  22.544  26.749  1.00109.51           C  
ATOM   2321  CG1 VAL A 276      33.105  22.810  28.274  1.00108.85           C  
ATOM   2322  CG2 VAL A 276      34.383  23.123  26.157  1.00109.19           C  
ATOM   2323  N   ARG A 277      30.607  20.712  26.762  1.00108.91           N  
ATOM   2324  CA  ARG A 277      29.390  20.090  27.303  1.00108.79           C  
ATOM   2325  C   ARG A 277      29.041  18.923  26.375  1.00108.05           C  
ATOM   2326  O   ARG A 277      29.058  19.071  25.141  1.00108.53           O  
ATOM   2327  CB  ARG A 277      28.222  21.098  27.413  1.00108.87           C  
ATOM   2328  CG  ARG A 277      28.606  22.466  28.030  1.00109.85           C  
ATOM   2329  CD  ARG A 277      27.417  23.296  28.507  1.00109.75           C  
ATOM   2330  NE  ARG A 277      27.685  24.731  28.357  1.00112.53           N  
ATOM   2331  CZ  ARG A 277      26.909  25.732  28.794  1.00113.70           C  
ATOM   2332  NH1 ARG A 277      25.770  25.500  29.458  1.00112.55           N  
ATOM   2333  NH2 ARG A 277      27.289  26.990  28.565  1.00113.18           N  
ATOM   2334  N   MET A 278      28.759  17.761  26.958  1.00106.59           N  
ATOM   2335  CA  MET A 278      28.632  16.537  26.180  1.00105.43           C  
ATOM   2336  C   MET A 278      27.633  15.576  26.805  1.00103.87           C  
ATOM   2337  O   MET A 278      27.586  15.444  28.030  1.00103.62           O  
ATOM   2338  CB  MET A 278      30.010  15.879  26.049  1.00105.61           C  
ATOM   2339  CG  MET A 278      29.987  14.358  25.758  1.00106.43           C  
ATOM   2340  SD  MET A 278      31.530  13.433  26.083  1.00106.71           S  
ATOM   2341  CE  MET A 278      32.277  14.363  27.446  1.00104.84           C  
ATOM   2342  N   GLU A 279      26.843  14.908  25.963  1.00102.10           N  
ATOM   2343  CA  GLU A 279      25.906  13.872  26.428  1.00100.87           C  
ATOM   2344  C   GLU A 279      26.437  13.124  27.672  1.00 98.86           C  
ATOM   2345  O   GLU A 279      27.527  12.536  27.639  1.00 98.96           O  
ATOM   2346  CB  GLU A 279      25.582  12.863  25.307  1.00100.81           C  
ATOM   2347  CG  GLU A 279      25.150  13.480  23.966  1.00102.09           C  
ATOM   2348  CD  GLU A 279      24.716  12.431  22.923  1.00102.41           C  
ATOM   2349  OE1 GLU A 279      24.479  11.251  23.293  1.00104.46           O  
ATOM   2350  OE2 GLU A 279      24.604  12.790  21.726  1.00103.12           O  
ATOM   2351  N   PRO A 280      25.702  13.189  28.794  1.00 97.02           N  
ATOM   2352  CA  PRO A 280      26.034  12.363  29.980  1.00 95.65           C  
ATOM   2353  C   PRO A 280      26.535  10.921  29.724  1.00 93.86           C  
ATOM   2354  O   PRO A 280      27.536  10.529  30.320  1.00 93.71           O  
ATOM   2355  CB  PRO A 280      24.740  12.389  30.790  1.00 95.69           C  
ATOM   2356  CG  PRO A 280      24.180  13.759  30.479  1.00 96.06           C  
ATOM   2357  CD  PRO A 280      24.582  14.107  29.068  1.00 96.41           C  
ATOM   2358  N   GLY A 281      25.873  10.165  28.841  1.00 92.02           N  
ATOM   2359  CA  GLY A 281      26.232   8.764  28.568  1.00 89.08           C  
ATOM   2360  C   GLY A 281      27.635   8.634  28.015  1.00 87.29           C  
ATOM   2361  O   GLY A 281      28.416   7.781  28.446  1.00 86.99           O  
ATOM   2362  N   LYS A 282      27.932   9.498  27.052  1.00 85.38           N  
ATOM   2363  CA  LYS A 282      29.254   9.658  26.469  1.00 83.85           C  
ATOM   2364  C   LYS A 282      30.340   9.914  27.502  1.00 81.93           C  
ATOM   2365  O   LYS A 282      31.402   9.280  27.494  1.00 81.69           O  
ATOM   2366  CB  LYS A 282      29.239  10.867  25.533  1.00 84.38           C  
ATOM   2367  CG  LYS A 282      28.963  10.595  24.075  1.00 86.10           C  
ATOM   2368  CD  LYS A 282      29.857  11.529  23.270  1.00 88.54           C  
ATOM   2369  CE  LYS A 282      29.283  11.818  21.905  1.00 89.75           C  
ATOM   2370  NZ  LYS A 282      30.074  12.906  21.288  1.00 88.86           N  
ATOM   2371  N   ARG A 283      30.066  10.887  28.361  1.00 79.92           N  
ATOM   2372  CA  ARG A 283      31.002  11.322  29.377  1.00 77.90           C  
ATOM   2373  C   ARG A 283      31.231  10.182  30.338  1.00 76.07           C  
ATOM   2374  O   ARG A 283      32.374   9.845  30.655  1.00 75.88           O  
ATOM   2375  CB  ARG A 283      30.445  12.541  30.101  1.00 78.28           C  
ATOM   2376  CG  ARG A 283      31.390  13.181  31.092  1.00 79.95           C  
ATOM   2377  CD  ARG A 283      30.716  14.351  31.800  1.00 85.71           C  
ATOM   2378  NE  ARG A 283      31.062  15.653  31.208  1.00 91.22           N  
ATOM   2379  CZ  ARG A 283      31.760  16.603  31.838  1.00 93.39           C  
ATOM   2380  NH1 ARG A 283      32.189  16.407  33.090  1.00 94.55           N  
ATOM   2381  NH2 ARG A 283      32.029  17.752  31.226  1.00 93.68           N  
ATOM   2382  N   LEU A 284      30.135   9.571  30.772  1.00 73.85           N  
ATOM   2383  CA  LEU A 284      30.197   8.426  31.650  1.00 72.37           C  
ATOM   2384  C   LEU A 284      30.868   7.232  30.971  1.00 72.39           C  
ATOM   2385  O   LEU A 284      31.498   6.427  31.626  1.00 72.59           O  
ATOM   2386  CB  LEU A 284      28.802   8.057  32.102  1.00 71.61           C  
ATOM   2387  CG  LEU A 284      28.611   6.936  33.111  1.00 68.78           C  
ATOM   2388  CD1 LEU A 284      28.959   7.363  34.494  1.00 65.20           C  
ATOM   2389  CD2 LEU A 284      27.175   6.562  33.029  1.00 65.88           C  
ATOM   2390  N   ASN A 285      30.738   7.107  29.660  1.00 72.03           N  
ATOM   2391  CA  ASN A 285      31.497   6.093  28.977  1.00 71.76           C  
ATOM   2392  C   ASN A 285      32.979   6.396  29.037  1.00 70.67           C  
ATOM   2393  O   ASN A 285      33.780   5.480  29.266  1.00 71.12           O  
ATOM   2394  CB  ASN A 285      31.034   5.912  27.539  1.00 72.56           C  
ATOM   2395  CG  ASN A 285      29.758   5.081  27.437  1.00 75.15           C  
ATOM   2396  OD1 ASN A 285      29.451   4.259  28.325  1.00 77.46           O  
ATOM   2397  ND2 ASN A 285      28.996   5.295  26.346  1.00 77.07           N  
ATOM   2398  N   LEU A 286      33.351   7.659  28.857  1.00 68.50           N  
ATOM   2399  CA  LEU A 286      34.743   8.033  29.056  1.00 67.04           C  
ATOM   2400  C   LEU A 286      35.214   7.803  30.491  1.00 65.98           C  
ATOM   2401  O   LEU A 286      36.249   7.188  30.725  1.00 65.39           O  
ATOM   2402  CB  LEU A 286      34.966   9.471  28.674  1.00 67.23           C  
ATOM   2403  CG  LEU A 286      35.011   9.650  27.169  1.00 68.46           C  
ATOM   2404  CD1 LEU A 286      34.678  11.108  26.836  1.00 69.51           C  
ATOM   2405  CD2 LEU A 286      36.366   9.183  26.566  1.00 66.35           C  
ATOM   2406  N   ILE A 287      34.452   8.297  31.457  1.00 64.82           N  
ATOM   2407  CA  ILE A 287      34.817   8.115  32.844  1.00 63.36           C  
ATOM   2408  C   ILE A 287      35.096   6.642  33.116  1.00 63.43           C  
ATOM   2409  O   ILE A 287      36.104   6.316  33.721  1.00 63.90           O  
ATOM   2410  CB  ILE A 287      33.767   8.723  33.778  1.00 63.31           C  
ATOM   2411  CG1 ILE A 287      33.867  10.250  33.719  1.00 60.25           C  
ATOM   2412  CG2 ILE A 287      33.907   8.190  35.232  1.00 62.54           C  
ATOM   2413  CD1 ILE A 287      32.845  10.936  34.579  1.00 57.25           C  
ATOM   2414  N   ARG A 288      34.241   5.749  32.628  1.00 63.46           N  
ATOM   2415  CA  ARG A 288      34.467   4.296  32.747  1.00 63.57           C  
ATOM   2416  C   ARG A 288      35.755   3.869  32.048  1.00 63.94           C  
ATOM   2417  O   ARG A 288      36.478   2.998  32.540  1.00 63.58           O  
ATOM   2418  CB  ARG A 288      33.304   3.505  32.139  1.00 63.61           C  
ATOM   2419  CG  ARG A 288      32.092   3.455  33.004  1.00 63.31           C  
ATOM   2420  CD  ARG A 288      30.866   3.207  32.219  1.00 64.52           C  
ATOM   2421  NE  ARG A 288      29.780   3.263  33.182  1.00 69.01           N  
ATOM   2422  CZ  ARG A 288      28.483   3.055  32.926  1.00 70.44           C  
ATOM   2423  NH1 ARG A 288      28.026   2.769  31.708  1.00 70.60           N  
ATOM   2424  NH2 ARG A 288      27.628   3.139  33.924  1.00 70.84           N  
ATOM   2425  N   TYR A 289      36.023   4.480  30.887  1.00 64.01           N  
ATOM   2426  CA  TYR A 289      37.216   4.174  30.146  1.00 63.98           C  
ATOM   2427  C   TYR A 289      38.417   4.495  31.015  1.00 63.72           C  
ATOM   2428  O   TYR A 289      39.241   3.616  31.284  1.00 63.65           O  
ATOM   2429  CB  TYR A 289      37.259   4.975  28.870  1.00 64.95           C  
ATOM   2430  CG  TYR A 289      38.273   4.471  27.892  1.00 66.90           C  
ATOM   2431  CD1 TYR A 289      38.029   3.309  27.166  1.00 69.49           C  
ATOM   2432  CD2 TYR A 289      39.475   5.142  27.682  1.00 68.69           C  
ATOM   2433  CE1 TYR A 289      38.946   2.811  26.266  1.00 69.84           C  
ATOM   2434  CE2 TYR A 289      40.418   4.663  26.740  1.00 69.43           C  
ATOM   2435  CZ  TYR A 289      40.135   3.486  26.047  1.00 69.30           C  
ATOM   2436  OH  TYR A 289      41.009   2.954  25.118  1.00 69.33           O  
ATOM   2437  N   ILE A 290      38.491   5.738  31.491  1.00 62.89           N  
ATOM   2438  CA  ILE A 290      39.610   6.146  32.299  1.00 62.41           C  
ATOM   2439  C   ILE A 290      39.739   5.179  33.460  1.00 63.17           C  
ATOM   2440  O   ILE A 290      40.810   4.595  33.653  1.00 63.49           O  
ATOM   2441  CB  ILE A 290      39.502   7.592  32.780  1.00 62.13           C  
ATOM   2442  CG1 ILE A 290      39.531   8.552  31.594  1.00 61.26           C  
ATOM   2443  CG2 ILE A 290      40.645   7.936  33.725  1.00 60.89           C  
ATOM   2444  CD1 ILE A 290      38.834   9.924  31.853  1.00 60.58           C  
ATOM   2445  N   LEU A 291      38.654   4.968  34.205  1.00 63.64           N  
ATOM   2446  CA  LEU A 291      38.676   4.006  35.313  1.00 64.84           C  
ATOM   2447  C   LEU A 291      39.339   2.632  34.986  1.00 66.03           C  
ATOM   2448  O   LEU A 291      40.153   2.118  35.762  1.00 65.99           O  
ATOM   2449  CB  LEU A 291      37.275   3.783  35.834  1.00 64.27           C  
ATOM   2450  CG  LEU A 291      37.106   2.659  36.853  1.00 64.52           C  
ATOM   2451  CD1 LEU A 291      37.851   2.915  38.176  1.00 62.39           C  
ATOM   2452  CD2 LEU A 291      35.600   2.498  37.106  1.00 66.86           C  
ATOM   2453  N   ARG A 292      38.992   2.043  33.845  1.00 67.19           N  
ATOM   2454  CA  ARG A 292      39.567   0.756  33.487  1.00 68.46           C  
ATOM   2455  C   ARG A 292      41.081   0.844  33.367  1.00 68.34           C  
ATOM   2456  O   ARG A 292      41.788   0.004  33.927  1.00 68.62           O  
ATOM   2457  CB  ARG A 292      38.898   0.140  32.249  1.00 68.60           C  
ATOM   2458  CG  ARG A 292      37.634  -0.659  32.602  1.00 69.06           C  
ATOM   2459  CD  ARG A 292      36.924  -1.201  31.366  1.00 70.29           C  
ATOM   2460  NE  ARG A 292      35.950  -0.268  30.788  1.00 75.21           N  
ATOM   2461  CZ  ARG A 292      36.040   0.269  29.564  1.00 78.12           C  
ATOM   2462  NH1 ARG A 292      37.063  -0.025  28.742  1.00 77.51           N  
ATOM   2463  NH2 ARG A 292      35.092   1.118  29.153  1.00 79.19           N  
ATOM   2464  N   ARG A 293      41.574   1.886  32.700  1.00 68.44           N  
ATOM   2465  CA  ARG A 293      43.018   2.170  32.697  1.00 68.54           C  
ATOM   2466  C   ARG A 293      43.609   2.101  34.126  1.00 68.98           C  
ATOM   2467  O   ARG A 293      44.492   1.263  34.397  1.00 68.80           O  
ATOM   2468  CB  ARG A 293      43.330   3.512  32.035  1.00 67.87           C  
ATOM   2469  CG  ARG A 293      42.754   3.655  30.662  1.00 67.19           C  
ATOM   2470  CD  ARG A 293      43.825   4.074  29.670  1.00 66.85           C  
ATOM   2471  NE  ARG A 293      43.389   4.104  28.259  1.00 65.17           N  
ATOM   2472  CZ  ARG A 293      44.213   4.302  27.229  1.00 62.97           C  
ATOM   2473  NH1 ARG A 293      45.514   4.484  27.455  1.00 63.32           N  
ATOM   2474  NH2 ARG A 293      43.754   4.329  25.985  1.00 60.14           N  
ATOM   2475  N   TYR A 294      43.080   2.956  35.013  1.00 69.22           N  
ATOM   2476  CA  TYR A 294      43.383   2.981  36.472  1.00 69.72           C  
ATOM   2477  C   TYR A 294      43.403   1.613  37.197  1.00 69.76           C  
ATOM   2478  O   TYR A 294      44.390   1.292  37.900  1.00 69.53           O  
ATOM   2479  CB  TYR A 294      42.400   3.898  37.219  1.00 69.58           C  
ATOM   2480  CG  TYR A 294      42.608   5.366  36.991  1.00 70.55           C  
ATOM   2481  CD1 TYR A 294      43.365   5.844  35.908  1.00 72.23           C  
ATOM   2482  CD2 TYR A 294      42.032   6.293  37.842  1.00 70.81           C  
ATOM   2483  CE1 TYR A 294      43.548   7.213  35.701  1.00 71.63           C  
ATOM   2484  CE2 TYR A 294      42.201   7.660  37.646  1.00 70.80           C  
ATOM   2485  CZ  TYR A 294      42.956   8.113  36.579  1.00 71.51           C  
ATOM   2486  OH  TYR A 294      43.102   9.475  36.403  1.00 72.18           O  
ATOM   2487  N   VAL A 295      42.316   0.844  37.042  1.00 69.03           N  
ATOM   2488  CA  VAL A 295      42.195  -0.474  37.642  1.00 68.41           C  
ATOM   2489  C   VAL A 295      43.352  -1.364  37.203  1.00 68.01           C  
ATOM   2490  O   VAL A 295      43.966  -2.050  38.016  1.00 66.97           O  
ATOM   2491  CB  VAL A 295      40.866  -1.136  37.244  1.00 68.51           C  
ATOM   2492  CG1 VAL A 295      40.808  -2.577  37.758  1.00 68.93           C  
ATOM   2493  CG2 VAL A 295      39.704  -0.357  37.793  1.00 68.85           C  
ATOM   2494  N   LYS A 296      43.638  -1.326  35.903  1.00 68.20           N  
ATOM   2495  CA  LYS A 296      44.684  -2.131  35.296  1.00 68.75           C  
ATOM   2496  C   LYS A 296      46.098  -1.678  35.745  1.00 68.34           C  
ATOM   2497  O   LYS A 296      46.983  -2.506  35.950  1.00 68.22           O  
ATOM   2498  CB  LYS A 296      44.530  -2.078  33.776  1.00 69.27           C  
ATOM   2499  CG  LYS A 296      45.101  -3.294  33.056  1.00 72.30           C  
ATOM   2500  CD  LYS A 296      44.611  -3.383  31.606  1.00 76.68           C  
ATOM   2501  CE  LYS A 296      45.517  -2.598  30.653  1.00 79.33           C  
ATOM   2502  NZ  LYS A 296      45.286  -3.018  29.233  1.00 82.62           N  
ATOM   2503  N   ALA A 297      46.291  -0.368  35.923  1.00 67.87           N  
ATOM   2504  CA  ALA A 297      47.552   0.202  36.457  1.00 67.13           C  
ATOM   2505  C   ALA A 297      47.784   0.011  37.972  1.00 66.92           C  
ATOM   2506  O   ALA A 297      48.916   0.157  38.446  1.00 66.45           O  
ATOM   2507  CB  ALA A 297      47.657   1.695  36.105  1.00 66.55           C  
ATOM   2508  N   LEU A 298      46.722  -0.290  38.729  1.00 66.62           N  
ATOM   2509  CA  LEU A 298      46.824  -0.244  40.186  1.00 66.01           C  
ATOM   2510  C   LEU A 298      46.467  -1.514  40.962  1.00 66.11           C  
ATOM   2511  O   LEU A 298      46.905  -1.654  42.096  1.00 66.11           O  
ATOM   2512  CB  LEU A 298      46.132   1.018  40.770  1.00 65.64           C  
ATOM   2513  CG  LEU A 298      46.759   2.413  40.530  1.00 64.42           C  
ATOM   2514  CD1 LEU A 298      45.966   3.473  41.197  1.00 63.80           C  
ATOM   2515  CD2 LEU A 298      48.190   2.553  41.006  1.00 63.43           C  
ATOM   2516  N   ARG A 299      45.715  -2.454  40.390  1.00 66.66           N  
ATOM   2517  CA  ARG A 299      45.409  -3.689  41.152  1.00 67.44           C  
ATOM   2518  C   ARG A 299      46.700  -4.304  41.664  1.00 67.80           C  
ATOM   2519  O   ARG A 299      46.845  -4.544  42.871  1.00 68.20           O  
ATOM   2520  CB  ARG A 299      44.656  -4.747  40.343  1.00 67.16           C  
ATOM   2521  CG  ARG A 299      44.632  -4.475  38.872  1.00 69.03           C  
ATOM   2522  CD  ARG A 299      44.073  -5.650  38.126  1.00 72.80           C  
ATOM   2523  NE  ARG A 299      44.710  -5.710  36.810  1.00 76.57           N  
ATOM   2524  CZ  ARG A 299      44.118  -6.117  35.691  1.00 78.59           C  
ATOM   2525  NH1 ARG A 299      42.842  -6.503  35.698  1.00 79.42           N  
ATOM   2526  NH2 ARG A 299      44.804  -6.119  34.556  1.00 80.44           N  
ATOM   2527  N   ASP A 300      47.644  -4.526  40.751  1.00 67.86           N  
ATOM   2528  CA  ASP A 300      48.940  -5.107  41.106  1.00 68.51           C  
ATOM   2529  C   ASP A 300      49.651  -4.490  42.336  1.00 68.06           C  
ATOM   2530  O   ASP A 300      50.553  -5.097  42.892  1.00 68.43           O  
ATOM   2531  CB  ASP A 300      49.880  -5.129  39.886  1.00 69.29           C  
ATOM   2532  CG  ASP A 300      49.491  -6.211  38.846  1.00 70.96           C  
ATOM   2533  OD1 ASP A 300      48.755  -7.167  39.220  1.00 71.89           O  
ATOM   2534  OD2 ASP A 300      49.922  -6.096  37.658  1.00 71.25           O  
ATOM   2535  N   TYR A 301      49.243  -3.298  42.757  1.00 67.29           N  
ATOM   2536  CA  TYR A 301      49.842  -2.649  43.909  1.00 66.20           C  
ATOM   2537  C   TYR A 301      48.873  -2.696  45.087  1.00 65.67           C  
ATOM   2538  O   TYR A 301      49.135  -2.093  46.140  1.00 65.39           O  
ATOM   2539  CB  TYR A 301      50.214  -1.208  43.557  1.00 66.51           C  
ATOM   2540  CG  TYR A 301      51.214  -1.112  42.438  1.00 66.44           C  
ATOM   2541  CD1 TYR A 301      50.821  -0.849  41.126  1.00 66.30           C  
ATOM   2542  CD2 TYR A 301      52.563  -1.302  42.692  1.00 67.91           C  
ATOM   2543  CE1 TYR A 301      51.775  -0.770  40.094  1.00 66.74           C  
ATOM   2544  CE2 TYR A 301      53.515  -1.226  41.678  1.00 68.00           C  
ATOM   2545  CZ  TYR A 301      53.120  -0.963  40.390  1.00 67.09           C  
ATOM   2546  OH  TYR A 301      54.105  -0.918  39.437  1.00 66.65           O  
ATOM   2547  N   GLY A 302      47.757  -3.404  44.893  1.00 64.81           N  
ATOM   2548  CA  GLY A 302      46.827  -3.736  45.977  1.00 64.69           C  
ATOM   2549  C   GLY A 302      45.587  -2.860  46.102  1.00 64.81           C  
ATOM   2550  O   GLY A 302      44.868  -2.921  47.113  1.00 65.13           O  
ATOM   2551  N   TRP A 303      45.356  -2.028  45.089  1.00 64.10           N  
ATOM   2552  CA  TRP A 303      44.216  -1.134  45.034  1.00 63.65           C  
ATOM   2553  C   TRP A 303      43.018  -1.875  44.434  1.00 64.08           C  
ATOM   2554  O   TRP A 303      43.166  -2.610  43.440  1.00 64.33           O  
ATOM   2555  CB  TRP A 303      44.571   0.062  44.148  1.00 63.13           C  
ATOM   2556  CG  TRP A 303      45.400   1.090  44.861  1.00 63.02           C  
ATOM   2557  CD1 TRP A 303      46.770   1.230  44.834  1.00 61.43           C  
ATOM   2558  CD2 TRP A 303      44.911   2.120  45.717  1.00 60.82           C  
ATOM   2559  NE1 TRP A 303      47.143   2.285  45.615  1.00 59.62           N  
ATOM   2560  CE2 TRP A 303      46.023   2.841  46.177  1.00 60.50           C  
ATOM   2561  CE3 TRP A 303      43.639   2.512  46.121  1.00 59.43           C  
ATOM   2562  CZ2 TRP A 303      45.897   3.917  47.048  1.00 62.07           C  
ATOM   2563  CZ3 TRP A 303      43.517   3.585  46.980  1.00 61.41           C  
ATOM   2564  CH2 TRP A 303      44.636   4.273  47.438  1.00 61.93           C  
ATOM   2565  N   TYR A 304      41.835  -1.666  45.018  1.00 63.81           N  
ATOM   2566  CA  TYR A 304      40.618  -2.384  44.615  1.00 63.43           C  
ATOM   2567  C   TYR A 304      39.541  -1.398  44.331  1.00 63.78           C  
ATOM   2568  O   TYR A 304      39.031  -0.794  45.246  1.00 64.45           O  
ATOM   2569  CB  TYR A 304      40.132  -3.289  45.747  1.00 62.41           C  
ATOM   2570  CG  TYR A 304      40.914  -4.557  45.876  1.00 60.30           C  
ATOM   2571  CD1 TYR A 304      42.052  -4.599  46.645  1.00 59.29           C  
ATOM   2572  CD2 TYR A 304      40.520  -5.709  45.219  1.00 58.38           C  
ATOM   2573  CE1 TYR A 304      42.788  -5.744  46.762  1.00 59.47           C  
ATOM   2574  CE2 TYR A 304      41.240  -6.865  45.343  1.00 58.92           C  
ATOM   2575  CZ  TYR A 304      42.380  -6.872  46.116  1.00 59.40           C  
ATOM   2576  OH  TYR A 304      43.127  -8.000  46.253  1.00 59.06           O  
ATOM   2577  N   ILE A 305      39.175  -1.230  43.076  1.00 64.42           N  
ATOM   2578  CA  ILE A 305      38.163  -0.231  42.743  1.00 64.93           C  
ATOM   2579  C   ILE A 305      36.947  -0.868  42.099  1.00 65.03           C  
ATOM   2580  O   ILE A 305      37.042  -1.443  41.011  1.00 65.54           O  
ATOM   2581  CB  ILE A 305      38.688   0.806  41.758  1.00 64.83           C  
ATOM   2582  CG1 ILE A 305      39.936   1.472  42.280  1.00 65.03           C  
ATOM   2583  CG2 ILE A 305      37.645   1.872  41.520  1.00 66.20           C  
ATOM   2584  CD1 ILE A 305      40.854   1.860  41.140  1.00 68.19           C  
ATOM   2585  N   SER A 306      35.805  -0.750  42.758  1.00 65.08           N  
ATOM   2586  CA  SER A 306      34.561  -1.234  42.203  1.00 65.34           C  
ATOM   2587  C   SER A 306      34.426  -0.810  40.746  1.00 65.67           C  
ATOM   2588  O   SER A 306      34.684   0.339  40.381  1.00 65.44           O  
ATOM   2589  CB  SER A 306      33.387  -0.686  43.002  1.00 65.60           C  
ATOM   2590  OG  SER A 306      32.192  -1.357  42.666  1.00 66.21           O  
ATOM   2591  N   PRO A 307      34.047  -1.748  39.883  1.00 66.18           N  
ATOM   2592  CA  PRO A 307      33.831  -1.310  38.526  1.00 66.62           C  
ATOM   2593  C   PRO A 307      32.552  -0.514  38.371  1.00 67.52           C  
ATOM   2594  O   PRO A 307      32.373   0.124  37.330  1.00 68.72           O  
ATOM   2595  CB  PRO A 307      33.735  -2.614  37.754  1.00 66.16           C  
ATOM   2596  CG  PRO A 307      33.271  -3.583  38.726  1.00 65.50           C  
ATOM   2597  CD  PRO A 307      33.852  -3.196  40.038  1.00 65.78           C  
ATOM   2598  N   GLU A 308      31.689  -0.515  39.383  1.00 68.02           N  
ATOM   2599  CA  GLU A 308      30.361   0.067  39.219  1.00 69.31           C  
ATOM   2600  C   GLU A 308      30.013   1.314  39.971  1.00 68.60           C  
ATOM   2601  O   GLU A 308      30.268   1.421  41.170  1.00 69.03           O  
ATOM   2602  CB  GLU A 308      29.305  -0.941  39.554  1.00 70.42           C  
ATOM   2603  CG  GLU A 308      28.595  -1.428  38.329  1.00 76.26           C  
ATOM   2604  CD  GLU A 308      28.031  -2.810  38.538  1.00 83.89           C  
ATOM   2605  OE1 GLU A 308      27.324  -3.041  39.580  1.00 85.16           O  
ATOM   2606  OE2 GLU A 308      28.328  -3.659  37.654  1.00 87.59           O  
ATOM   2607  N   GLU A 309      29.368   2.227  39.249  1.00 67.75           N  
ATOM   2608  CA  GLU A 309      28.904   3.511  39.774  1.00 67.24           C  
ATOM   2609  C   GLU A 309      28.023   3.376  41.005  1.00 66.15           C  
ATOM   2610  O   GLU A 309      27.368   2.362  41.197  1.00 66.37           O  
ATOM   2611  CB  GLU A 309      28.131   4.266  38.688  1.00 67.33           C  
ATOM   2612  CG  GLU A 309      29.014   4.779  37.556  1.00 69.32           C  
ATOM   2613  CD  GLU A 309      29.296   3.724  36.496  1.00 72.16           C  
ATOM   2614  OE1 GLU A 309      28.459   2.799  36.360  1.00 73.68           O  
ATOM   2615  OE2 GLU A 309      30.334   3.830  35.789  1.00 71.64           O  
ATOM   2616  N   GLU A 310      27.985   4.405  41.827  1.00 64.82           N  
ATOM   2617  CA  GLU A 310      27.082   4.398  42.945  1.00 64.44           C  
ATOM   2618  C   GLU A 310      25.709   4.892  42.500  1.00 64.49           C  
ATOM   2619  O   GLU A 310      25.592   5.459  41.425  1.00 65.15           O  
ATOM   2620  CB  GLU A 310      27.673   5.229  44.067  1.00 64.58           C  
ATOM   2621  CG  GLU A 310      28.870   4.569  44.749  1.00 64.78           C  
ATOM   2622  CD  GLU A 310      28.447   3.724  45.917  1.00 65.29           C  
ATOM   2623  OE1 GLU A 310      27.695   4.265  46.750  1.00 65.08           O  
ATOM   2624  OE2 GLU A 310      28.838   2.534  46.003  1.00 65.61           O  
ATOM   2625  N   ARG A 311      24.665   4.662  43.300  1.00 64.61           N  
ATOM   2626  CA  ARG A 311      23.281   5.005  42.904  1.00 64.69           C  
ATOM   2627  C   ARG A 311      22.563   6.005  43.787  1.00 64.71           C  
ATOM   2628  O   ARG A 311      22.595   5.940  45.000  1.00 64.83           O  
ATOM   2629  CB  ARG A 311      22.431   3.746  42.765  1.00 64.18           C  
ATOM   2630  CG  ARG A 311      22.900   2.943  41.631  1.00 67.10           C  
ATOM   2631  CD  ARG A 311      22.441   1.514  41.623  1.00 74.96           C  
ATOM   2632  NE  ARG A 311      23.078   0.832  40.478  1.00 81.81           N  
ATOM   2633  CZ  ARG A 311      22.474  -0.076  39.703  1.00 84.02           C  
ATOM   2634  NH1 ARG A 311      21.202  -0.432  39.945  1.00 83.75           N  
ATOM   2635  NH2 ARG A 311      23.134  -0.608  38.674  1.00 81.78           N  
ATOM   2636  N   ALA A 312      21.876   6.933  43.162  1.00 65.97           N  
ATOM   2637  CA  ALA A 312      21.021   7.853  43.898  1.00 67.30           C  
ATOM   2638  C   ALA A 312      20.308   7.093  45.006  1.00 68.04           C  
ATOM   2639  O   ALA A 312      19.712   6.084  44.740  1.00 68.75           O  
ATOM   2640  CB  ALA A 312      20.007   8.459  42.944  1.00 66.94           C  
ATOM   2641  N   LYS A 313      20.345   7.524  46.253  1.00 69.35           N  
ATOM   2642  CA  LYS A 313      19.484   6.798  47.213  1.00 70.43           C  
ATOM   2643  C   LYS A 313      17.979   6.975  46.980  1.00 71.08           C  
ATOM   2644  O   LYS A 313      17.219   6.279  47.608  1.00 71.72           O  
ATOM   2645  CB  LYS A 313      19.777   7.125  48.681  1.00 70.35           C  
ATOM   2646  CG  LYS A 313      19.316   6.008  49.625  1.00 69.35           C  
ATOM   2647  CD  LYS A 313      19.083   6.541  51.018  1.00 70.05           C  
ATOM   2648  CE  LYS A 313      19.605   5.607  52.069  1.00 69.79           C  
ATOM   2649  NZ  LYS A 313      19.989   6.390  53.283  1.00 72.16           N  
ATOM   2650  N   GLY A 314      17.550   7.900  46.112  1.00 71.34           N  
ATOM   2651  CA  GLY A 314      16.124   8.196  45.953  1.00 71.34           C  
ATOM   2652  C   GLY A 314      15.837   9.623  45.523  1.00 71.56           C  
ATOM   2653  O   GLY A 314      16.731  10.310  45.030  1.00 72.42           O  
ATOM   2654  N   LYS A 315      14.590  10.057  45.695  1.00 71.01           N  
ATOM   2655  CA  LYS A 315      14.148  11.435  45.444  1.00 70.41           C  
ATOM   2656  C   LYS A 315      13.636  11.964  46.769  1.00 69.65           C  
ATOM   2657  O   LYS A 315      13.225  11.185  47.628  1.00 70.13           O  
ATOM   2658  CB  LYS A 315      12.993  11.407  44.446  1.00 70.73           C  
ATOM   2659  CG  LYS A 315      12.673  12.697  43.669  1.00 71.58           C  
ATOM   2660  CD  LYS A 315      11.592  12.396  42.603  1.00 70.79           C  
ATOM   2661  CE  LYS A 315      10.653  13.579  42.345  1.00 71.10           C  
ATOM   2662  NZ  LYS A 315      11.156  14.473  41.227  1.00 72.07           N  
ATOM   2663  N   LEU A 316      13.656  13.268  46.972  1.00 68.67           N  
ATOM   2664  CA  LEU A 316      13.047  13.801  48.186  1.00 67.88           C  
ATOM   2665  C   LEU A 316      11.938  14.677  47.731  1.00 68.32           C  
ATOM   2666  O   LEU A 316      12.053  15.345  46.706  1.00 68.52           O  
ATOM   2667  CB  LEU A 316      13.997  14.632  49.028  1.00 67.25           C  
ATOM   2668  CG  LEU A 316      15.430  14.207  49.328  1.00 66.13           C  
ATOM   2669  CD1 LEU A 316      16.202  15.377  49.930  1.00 63.08           C  
ATOM   2670  CD2 LEU A 316      15.465  13.001  50.210  1.00 62.53           C  
ATOM   2671  N   ASN A 317      10.840  14.628  48.469  1.00 68.94           N  
ATOM   2672  CA  ASN A 317       9.712  15.479  48.215  1.00 69.49           C  
ATOM   2673  C   ASN A 317       9.836  16.626  49.156  1.00 69.84           C  
ATOM   2674  O   ASN A 317      10.219  16.454  50.339  1.00 70.30           O  
ATOM   2675  CB  ASN A 317       8.415  14.748  48.497  1.00 69.95           C  
ATOM   2676  CG  ASN A 317       7.934  13.969  47.311  1.00 72.11           C  
ATOM   2677  OD1 ASN A 317       8.623  13.919  46.277  1.00 75.29           O  
ATOM   2678  ND2 ASN A 317       6.745  13.342  47.433  1.00 72.49           N  
ATOM   2679  N   PHE A 318       9.524  17.802  48.645  1.00 69.25           N  
ATOM   2680  CA  PHE A 318       9.503  18.956  49.481  1.00 69.46           C  
ATOM   2681  C   PHE A 318       8.170  19.666  49.227  1.00 70.30           C  
ATOM   2682  O   PHE A 318       7.394  19.312  48.305  1.00 69.97           O  
ATOM   2683  CB  PHE A 318      10.674  19.829  49.131  1.00 68.78           C  
ATOM   2684  CG  PHE A 318      10.757  20.087  47.692  1.00 69.59           C  
ATOM   2685  CD1 PHE A 318      10.137  21.219  47.139  1.00 68.45           C  
ATOM   2686  CD2 PHE A 318      11.381  19.156  46.851  1.00 68.64           C  
ATOM   2687  CE1 PHE A 318      10.173  21.428  45.778  1.00 68.50           C  
ATOM   2688  CE2 PHE A 318      11.422  19.363  45.486  1.00 68.33           C  
ATOM   2689  CZ  PHE A 318      10.818  20.500  44.944  1.00 68.14           C  
ATOM   2690  N   LYS A 319       7.891  20.637  50.091  1.00 70.81           N  
ATOM   2691  CA  LYS A 319       6.721  21.430  49.984  1.00 71.17           C  
ATOM   2692  C   LYS A 319       6.916  22.306  48.758  1.00 72.03           C  
ATOM   2693  O   LYS A 319       7.578  23.351  48.839  1.00 72.77           O  
ATOM   2694  CB  LYS A 319       6.612  22.263  51.246  1.00 71.14           C  
ATOM   2695  CG  LYS A 319       6.550  21.441  52.534  1.00 71.82           C  
ATOM   2696  CD  LYS A 319       5.497  20.355  52.414  1.00 72.87           C  
ATOM   2697  CE  LYS A 319       5.043  19.800  53.741  1.00 72.90           C  
ATOM   2698  NZ  LYS A 319       4.111  18.671  53.414  1.00 73.87           N  
ATOM   2699  N   ASP A 320       6.382  21.868  47.616  1.00 72.30           N  
ATOM   2700  CA  ASP A 320       6.497  22.638  46.381  1.00 72.87           C  
ATOM   2701  C   ASP A 320       5.215  23.379  46.100  1.00 72.80           C  
ATOM   2702  O   ASP A 320       5.053  23.992  45.061  1.00 73.59           O  
ATOM   2703  CB  ASP A 320       6.858  21.745  45.196  1.00 73.08           C  
ATOM   2704  CG  ASP A 320       5.843  20.673  44.971  1.00 74.29           C  
ATOM   2705  OD1 ASP A 320       4.847  20.687  45.724  1.00 75.96           O  
ATOM   2706  OD2 ASP A 320       6.026  19.837  44.057  1.00 74.99           O  
ATOM   2707  N   THR A 321       4.304  23.341  47.044  1.00 73.17           N  
ATOM   2708  CA  THR A 321       3.033  24.026  46.887  1.00 73.53           C  
ATOM   2709  C   THR A 321       3.067  25.528  47.254  1.00 73.07           C  
ATOM   2710  O   THR A 321       3.581  25.909  48.330  1.00 73.18           O  
ATOM   2711  CB  THR A 321       1.974  23.229  47.623  1.00 73.96           C  
ATOM   2712  OG1 THR A 321       1.580  22.153  46.760  1.00 75.32           O  
ATOM   2713  CG2 THR A 321       0.761  24.073  47.988  1.00 74.59           C  
ATOM   2714  N   VAL A 322       2.493  26.341  46.350  1.00 72.21           N  
ATOM   2715  CA  VAL A 322       2.699  27.803  46.245  1.00 71.91           C  
ATOM   2716  C   VAL A 322       1.395  28.565  45.875  1.00 72.00           C  
ATOM   2717  O   VAL A 322       0.666  28.136  44.976  1.00 72.03           O  
ATOM   2718  CB  VAL A 322       3.882  28.086  45.193  1.00 71.71           C  
ATOM   2719  CG1 VAL A 322       3.511  29.041  44.069  1.00 70.62           C  
ATOM   2720  CG2 VAL A 322       5.131  28.563  45.869  1.00 71.69           C  
ATOM   2721  N   LEU A 323       1.105  29.688  46.535  1.00 72.23           N  
ATOM   2722  CA  LEU A 323      -0.171  30.399  46.303  1.00 73.06           C  
ATOM   2723  C   LEU A 323      -0.096  31.906  46.237  1.00 74.09           C  
ATOM   2724  O   LEU A 323       0.791  32.525  46.837  1.00 74.58           O  
ATOM   2725  CB  LEU A 323      -1.216  30.067  47.378  1.00 73.03           C  
ATOM   2726  CG  LEU A 323      -1.020  30.656  48.788  1.00 71.83           C  
ATOM   2727  CD1 LEU A 323      -2.307  31.244  49.356  1.00 70.71           C  
ATOM   2728  CD2 LEU A 323      -0.438  29.588  49.707  1.00 70.43           C  
ATOM   2729  N   ASP A 324      -1.090  32.492  45.563  1.00 75.02           N  
ATOM   2730  CA  ASP A 324      -1.195  33.952  45.405  1.00 75.51           C  
ATOM   2731  C   ASP A 324      -2.079  34.626  46.450  1.00 76.31           C  
ATOM   2732  O   ASP A 324      -2.517  34.010  47.416  1.00 76.48           O  
ATOM   2733  CB  ASP A 324      -1.677  34.324  43.988  1.00 75.30           C  
ATOM   2734  CG  ASP A 324      -3.145  33.947  43.720  1.00 75.06           C  
ATOM   2735  OD1 ASP A 324      -3.918  33.719  44.678  1.00 74.88           O  
ATOM   2736  OD2 ASP A 324      -3.532  33.901  42.530  1.00 74.19           O  
ATOM   2737  N   ALA A 325      -2.339  35.906  46.215  1.00 77.61           N  
ATOM   2738  CA  ALA A 325      -3.155  36.759  47.075  1.00 78.55           C  
ATOM   2739  C   ALA A 325      -4.632  36.368  47.132  1.00 79.50           C  
ATOM   2740  O   ALA A 325      -5.371  36.845  47.990  1.00 79.34           O  
ATOM   2741  CB  ALA A 325      -3.001  38.205  46.644  1.00 78.43           C  
ATOM   2742  N   LYS A 326      -5.059  35.505  46.221  1.00 81.12           N  
ATOM   2743  CA  LYS A 326      -6.377  34.918  46.318  1.00 82.91           C  
ATOM   2744  C   LYS A 326      -6.258  33.648  47.142  1.00 83.76           C  
ATOM   2745  O   LYS A 326      -6.840  33.540  48.221  1.00 84.32           O  
ATOM   2746  CB  LYS A 326      -6.963  34.631  44.935  1.00 83.25           C  
ATOM   2747  CG  LYS A 326      -7.256  35.875  44.104  1.00 84.32           C  
ATOM   2748  CD  LYS A 326      -8.005  36.925  44.918  1.00 86.38           C  
ATOM   2749  CE  LYS A 326      -8.326  38.141  44.069  1.00 87.66           C  
ATOM   2750  NZ  LYS A 326      -8.614  39.301  44.946  1.00 88.01           N  
ATOM   2751  N   GLY A 327      -5.463  32.708  46.664  1.00 84.63           N  
ATOM   2752  CA  GLY A 327      -5.295  31.449  47.363  1.00 86.42           C  
ATOM   2753  C   GLY A 327      -5.233  30.320  46.369  1.00 87.72           C  
ATOM   2754  O   GLY A 327      -5.609  29.193  46.677  1.00 87.33           O  
ATOM   2755  N   LYS A 328      -4.756  30.651  45.171  1.00 89.35           N  
ATOM   2756  CA  LYS A 328      -4.665  29.723  44.065  1.00 91.22           C  
ATOM   2757  C   LYS A 328      -3.353  28.969  44.192  1.00 92.37           C  
ATOM   2758  O   LYS A 328      -2.354  29.534  44.644  1.00 92.54           O  
ATOM   2759  CB  LYS A 328      -4.763  30.469  42.751  1.00 91.19           C  
ATOM   2760  CG  LYS A 328      -5.923  31.458  42.739  1.00 92.69           C  
ATOM   2761  CD  LYS A 328      -5.946  32.277  41.446  1.00 95.76           C  
ATOM   2762  CE  LYS A 328      -7.173  33.181  41.377  1.00 96.91           C  
ATOM   2763  NZ  LYS A 328      -7.191  33.936  40.093  1.00 97.58           N  
ATOM   2764  N   ASN A 329      -3.375  27.706  43.766  1.00 93.40           N  
ATOM   2765  CA  ASN A 329      -2.502  26.682  44.289  1.00 94.60           C  
ATOM   2766  C   ASN A 329      -1.670  26.005  43.225  1.00 96.20           C  
ATOM   2767  O   ASN A 329      -1.651  26.436  42.080  1.00 96.43           O  
ATOM   2768  CB  ASN A 329      -3.370  25.610  44.981  1.00 94.23           C  
ATOM   2769  CG  ASN A 329      -3.640  25.915  46.442  1.00 93.29           C  
ATOM   2770  OD1 ASN A 329      -4.053  27.014  46.781  1.00 93.42           O  
ATOM   2771  ND2 ASN A 329      -3.408  24.938  47.316  1.00 91.37           N  
ATOM   2772  N   THR A 330      -0.994  24.928  43.637  1.00 98.32           N  
ATOM   2773  CA  THR A 330      -0.468  23.885  42.756  1.00100.33           C  
ATOM   2774  C   THR A 330      -1.607  23.199  42.039  1.00101.61           C  
ATOM   2775  O   THR A 330      -1.363  22.448  41.090  1.00102.35           O  
ATOM   2776  CB  THR A 330       0.219  22.756  43.541  1.00100.81           C  
ATOM   2777  OG1 THR A 330       0.483  23.191  44.883  1.00102.63           O  
ATOM   2778  CG2 THR A 330       1.516  22.229  42.831  1.00 99.95           C  
ATOM   2779  N   LYS A 331      -2.835  23.413  42.528  1.00102.73           N  
ATOM   2780  CA  LYS A 331      -4.070  23.035  41.822  1.00103.66           C  
ATOM   2781  C   LYS A 331      -4.147  23.612  40.411  1.00104.16           C  
ATOM   2782  O   LYS A 331      -4.730  22.986  39.514  1.00104.11           O  
ATOM   2783  CB  LYS A 331      -5.314  23.404  42.645  1.00103.64           C  
ATOM   2784  CG  LYS A 331      -5.682  22.291  43.618  1.00104.48           C  
ATOM   2785  CD  LYS A 331      -6.248  22.766  44.963  1.00105.20           C  
ATOM   2786  CE  LYS A 331      -6.180  21.622  46.004  1.00104.79           C  
ATOM   2787  NZ  LYS A 331      -7.187  21.712  47.107  1.00104.22           N  
ATOM   2788  N   VAL A 332      -3.547  24.787  40.215  1.00104.87           N  
ATOM   2789  CA  VAL A 332      -3.340  25.318  38.862  1.00106.07           C  
ATOM   2790  C   VAL A 332      -1.960  24.937  38.295  1.00106.76           C  
ATOM   2791  O   VAL A 332      -1.806  24.726  37.078  1.00106.87           O  
ATOM   2792  CB  VAL A 332      -3.550  26.856  38.783  1.00105.94           C  
ATOM   2793  CG1 VAL A 332      -3.129  27.399  37.405  1.00105.46           C  
ATOM   2794  CG2 VAL A 332      -5.009  27.213  39.076  1.00106.40           C  
ATOM   2795  N   ILE A 333      -0.979  24.835  39.194  1.00107.46           N  
ATOM   2796  CA  ILE A 333       0.443  24.661  38.842  1.00107.95           C  
ATOM   2797  C   ILE A 333       0.747  23.522  37.815  1.00108.43           C  
ATOM   2798  O   ILE A 333       1.906  23.330  37.398  1.00108.51           O  
ATOM   2799  CB  ILE A 333       1.357  24.633  40.154  1.00108.40           C  
ATOM   2800  CG1 ILE A 333       1.141  25.914  40.994  1.00107.46           C  
ATOM   2801  CG2 ILE A 333       2.880  24.334  39.829  1.00107.87           C  
ATOM   2802  CD1 ILE A 333       1.806  25.933  42.364  1.00107.12           C  
ATOM   2803  N   THR A 334      -0.295  22.807  37.384  1.00108.61           N  
ATOM   2804  CA  THR A 334      -0.171  21.884  36.240  1.00108.94           C  
ATOM   2805  C   THR A 334       0.069  22.657  34.928  1.00108.60           C  
ATOM   2806  O   THR A 334       0.270  22.052  33.861  1.00108.92           O  
ATOM   2807  CB  THR A 334      -1.367  20.896  36.144  1.00109.17           C  
ATOM   2808  OG1 THR A 334      -1.566  20.299  37.430  1.00109.99           O  
ATOM   2809  CG2 THR A 334      -1.105  19.777  35.108  1.00108.70           C  
ATOM   2810  N   ASN A 335       0.042  23.988  35.022  1.00107.61           N  
ATOM   2811  CA  ASN A 335       0.750  24.857  34.073  1.00106.93           C  
ATOM   2812  C   ASN A 335       1.430  26.009  34.824  1.00106.09           C  
ATOM   2813  O   ASN A 335       0.759  26.896  35.380  1.00106.12           O  
ATOM   2814  CB  ASN A 335      -0.169  25.390  32.963  1.00107.05           C  
ATOM   2815  CG  ASN A 335      -0.512  24.340  31.904  1.00108.07           C  
ATOM   2816  OD1 ASN A 335       0.321  23.506  31.533  1.00109.97           O  
ATOM   2817  ND2 ASN A 335      -1.744  24.392  31.401  1.00108.52           N  
ATOM   2818  N   LEU A 336       2.761  25.980  34.859  1.00104.75           N  
ATOM   2819  CA  LEU A 336       3.520  27.036  35.526  1.00103.30           C  
ATOM   2820  C   LEU A 336       3.246  28.398  34.863  1.00101.80           C  
ATOM   2821  O   LEU A 336       3.038  29.401  35.553  1.00101.51           O  
ATOM   2822  CB  LEU A 336       5.019  26.695  35.569  1.00103.77           C  
ATOM   2823  CG  LEU A 336       5.457  25.571  36.532  1.00104.58           C  
ATOM   2824  CD1 LEU A 336       6.927  25.155  36.313  1.00104.82           C  
ATOM   2825  CD2 LEU A 336       5.212  25.960  37.988  1.00105.11           C  
ATOM   2826  N   ARG A 337       3.214  28.401  33.527  1.00 99.59           N  
ATOM   2827  CA  ARG A 337       2.819  29.562  32.740  1.00 97.65           C  
ATOM   2828  C   ARG A 337       1.364  29.913  33.006  1.00 96.15           C  
ATOM   2829  O   ARG A 337       1.043  31.028  33.455  1.00 96.04           O  
ATOM   2830  CB  ARG A 337       3.004  29.292  31.245  1.00 97.88           C  
ATOM   2831  CG  ARG A 337       4.419  28.854  30.814  1.00 98.37           C  
ATOM   2832  CD  ARG A 337       4.707  29.201  29.341  1.00 98.26           C  
ATOM   2833  NE  ARG A 337       5.881  28.484  28.837  1.00100.41           N  
ATOM   2834  CZ  ARG A 337       6.305  28.513  27.573  1.00100.50           C  
ATOM   2835  NH1 ARG A 337       5.658  29.237  26.663  1.00 99.02           N  
ATOM   2836  NH2 ARG A 337       7.384  27.815  27.225  1.00100.39           N  
ATOM   2837  N   LYS A 338       0.475  28.960  32.746  1.00 93.98           N  
ATOM   2838  CA  LYS A 338      -0.935  29.190  33.013  1.00 92.00           C  
ATOM   2839  C   LYS A 338      -1.151  29.679  34.446  1.00 89.98           C  
ATOM   2840  O   LYS A 338      -2.171  30.297  34.730  1.00 89.47           O  
ATOM   2841  CB  LYS A 338      -1.784  27.947  32.702  1.00 92.12           C  
ATOM   2842  CG  LYS A 338      -3.316  28.189  32.656  1.00 92.92           C  
ATOM   2843  CD  LYS A 338      -4.074  27.090  31.897  1.00 92.65           C  
ATOM   2844  CE  LYS A 338      -3.774  27.119  30.370  1.00 95.19           C  
ATOM   2845  NZ  LYS A 338      -4.472  26.052  29.549  1.00 94.52           N  
ATOM   2846  N   PHE A 339      -0.186  29.431  35.330  1.00 87.79           N  
ATOM   2847  CA  PHE A 339      -0.324  29.887  36.712  1.00 86.27           C  
ATOM   2848  C   PHE A 339      -0.015  31.362  36.894  1.00 85.49           C  
ATOM   2849  O   PHE A 339      -0.647  32.042  37.705  1.00 84.88           O  
ATOM   2850  CB  PHE A 339       0.530  29.072  37.689  1.00 85.76           C  
ATOM   2851  CG  PHE A 339       0.380  29.512  39.129  1.00 84.29           C  
ATOM   2852  CD1 PHE A 339      -0.717  29.115  39.882  1.00 83.06           C  
ATOM   2853  CD2 PHE A 339       1.320  30.340  39.719  1.00 83.20           C  
ATOM   2854  CE1 PHE A 339      -0.871  29.533  41.212  1.00 82.60           C  
ATOM   2855  CE2 PHE A 339       1.171  30.749  41.052  1.00 83.66           C  
ATOM   2856  CZ  PHE A 339       0.068  30.348  41.793  1.00 82.46           C  
ATOM   2857  N   LEU A 340       0.970  31.843  36.150  1.00 84.64           N  
ATOM   2858  CA  LEU A 340       1.481  33.173  36.370  1.00 83.75           C  
ATOM   2859  C   LEU A 340       0.609  34.151  35.654  1.00 83.44           C  
ATOM   2860  O   LEU A 340       0.427  35.265  36.126  1.00 83.31           O  
ATOM   2861  CB  LEU A 340       2.905  33.294  35.870  1.00 83.75           C  
ATOM   2862  CG  LEU A 340       3.943  32.384  36.513  1.00 83.80           C  
ATOM   2863  CD1 LEU A 340       4.889  31.904  35.438  1.00 83.58           C  
ATOM   2864  CD2 LEU A 340       4.691  33.109  37.638  1.00 84.50           C  
ATOM   2865  N   GLU A 341       0.068  33.747  34.510  1.00 83.14           N  
ATOM   2866  CA  GLU A 341      -0.942  34.572  33.857  1.00 83.11           C  
ATOM   2867  C   GLU A 341      -2.065  34.903  34.841  1.00 82.69           C  
ATOM   2868  O   GLU A 341      -2.247  36.061  35.209  1.00 83.07           O  
ATOM   2869  CB  GLU A 341      -1.529  33.881  32.644  1.00 83.03           C  
ATOM   2870  CG  GLU A 341      -0.513  33.305  31.728  1.00 84.83           C  
ATOM   2871  CD  GLU A 341      -1.155  32.486  30.629  1.00 88.16           C  
ATOM   2872  OE1 GLU A 341      -2.183  32.932  30.054  1.00 88.21           O  
ATOM   2873  OE2 GLU A 341      -0.626  31.384  30.342  1.00 90.60           O  
ATOM   2874  N   LEU A 342      -2.791  33.883  35.293  1.00 82.00           N  
ATOM   2875  CA  LEU A 342      -3.970  34.090  36.126  1.00 81.29           C  
ATOM   2876  C   LEU A 342      -3.591  34.579  37.497  1.00 80.84           C  
ATOM   2877  O   LEU A 342      -4.333  35.338  38.104  1.00 81.51           O  
ATOM   2878  CB  LEU A 342      -4.792  32.809  36.259  1.00 81.34           C  
ATOM   2879  CG  LEU A 342      -5.012  31.965  34.999  1.00 81.85           C  
ATOM   2880  CD1 LEU A 342      -4.891  30.482  35.335  1.00 82.02           C  
ATOM   2881  CD2 LEU A 342      -6.334  32.299  34.282  1.00 81.39           C  
ATOM   2882  N   CYS A 343      -2.428  34.171  37.986  1.00 80.08           N  
ATOM   2883  CA  CYS A 343      -2.081  34.448  39.373  1.00 79.47           C  
ATOM   2884  C   CYS A 343      -2.201  35.923  39.729  1.00 78.21           C  
ATOM   2885  O   CYS A 343      -2.006  36.797  38.900  1.00 77.92           O  
ATOM   2886  CB  CYS A 343      -0.674  33.969  39.681  1.00 79.68           C  
ATOM   2887  SG  CYS A 343       0.530  35.293  39.601  1.00 81.87           S  
ATOM   2888  N   ARG A 344      -2.503  36.196  40.981  1.00 77.14           N  
ATOM   2889  CA  ARG A 344      -2.706  37.562  41.380  1.00 76.60           C  
ATOM   2890  C   ARG A 344      -1.816  37.886  42.575  1.00 75.09           C  
ATOM   2891  O   ARG A 344      -2.039  37.395  43.666  1.00 74.80           O  
ATOM   2892  CB  ARG A 344      -4.199  37.807  41.623  1.00 77.51           C  
ATOM   2893  CG  ARG A 344      -5.078  37.120  40.540  1.00 80.13           C  
ATOM   2894  CD  ARG A 344      -6.265  37.961  40.125  1.00 86.01           C  
ATOM   2895  NE  ARG A 344      -7.344  37.159  39.523  1.00 90.63           N  
ATOM   2896  CZ  ARG A 344      -8.655  37.421  39.666  1.00 93.95           C  
ATOM   2897  NH1 ARG A 344      -9.076  38.458  40.406  1.00 94.04           N  
ATOM   2898  NH2 ARG A 344      -9.560  36.640  39.076  1.00 94.72           N  
ATOM   2899  N   PRO A 345      -0.782  38.710  42.346  1.00 73.83           N  
ATOM   2900  CA  PRO A 345       0.346  38.904  43.242  1.00 72.69           C  
ATOM   2901  C   PRO A 345       0.018  39.665  44.503  1.00 71.66           C  
ATOM   2902  O   PRO A 345      -0.926  40.450  44.537  1.00 71.56           O  
ATOM   2903  CB  PRO A 345       1.288  39.762  42.405  1.00 72.67           C  
ATOM   2904  CG  PRO A 345       0.384  40.567  41.577  1.00 72.89           C  
ATOM   2905  CD  PRO A 345      -0.645  39.557  41.149  1.00 73.71           C  
ATOM   2906  N   PHE A 346       0.837  39.435  45.516  1.00 70.53           N  
ATOM   2907  CA  PHE A 346       0.805  40.192  46.731  1.00 69.95           C  
ATOM   2908  C   PHE A 346       1.395  41.583  46.558  1.00 69.72           C  
ATOM   2909  O   PHE A 346       2.637  41.755  46.650  1.00 69.28           O  
ATOM   2910  CB  PHE A 346       1.590  39.446  47.772  1.00 69.96           C  
ATOM   2911  CG  PHE A 346       0.978  38.171  48.151  1.00 69.08           C  
ATOM   2912  CD1 PHE A 346       1.353  37.002  47.514  1.00 69.08           C  
ATOM   2913  CD2 PHE A 346       0.020  38.130  49.159  1.00 68.29           C  
ATOM   2914  CE1 PHE A 346       0.782  35.779  47.880  1.00 70.41           C  
ATOM   2915  CE2 PHE A 346      -0.562  36.941  49.535  1.00 68.01           C  
ATOM   2916  CZ  PHE A 346      -0.184  35.753  48.892  1.00 70.32           C  
ATOM   2917  N   VAL A 347       0.497  42.564  46.344  1.00 69.16           N  
ATOM   2918  CA  VAL A 347       0.879  43.932  45.957  1.00 68.40           C  
ATOM   2919  C   VAL A 347       1.106  44.815  47.146  1.00 68.37           C  
ATOM   2920  O   VAL A 347       0.177  45.109  47.863  1.00 68.45           O  
ATOM   2921  CB  VAL A 347      -0.169  44.643  45.094  1.00 67.85           C  
ATOM   2922  CG1 VAL A 347       0.413  45.950  44.585  1.00 68.16           C  
ATOM   2923  CG2 VAL A 347      -0.601  43.794  43.928  1.00 67.11           C  
ATOM   2924  N   LYS A 348       2.336  45.260  47.350  1.00 68.66           N  
ATOM   2925  CA  LYS A 348       2.576  46.249  48.384  1.00 68.77           C  
ATOM   2926  C   LYS A 348       3.113  47.570  47.821  1.00 68.79           C  
ATOM   2927  O   LYS A 348       3.415  48.500  48.575  1.00 68.75           O  
ATOM   2928  CB  LYS A 348       3.456  45.676  49.491  1.00 69.03           C  
ATOM   2929  CG  LYS A 348       2.798  44.493  50.208  1.00 69.80           C  
ATOM   2930  CD  LYS A 348       3.521  44.154  51.482  1.00 70.92           C  
ATOM   2931  CE  LYS A 348       3.863  42.677  51.548  1.00 72.03           C  
ATOM   2932  NZ  LYS A 348       4.658  42.379  52.780  1.00 73.93           N  
ATOM   2933  N   LYS A 349       3.209  47.671  46.495  1.00 68.66           N  
ATOM   2934  CA  LYS A 349       3.506  48.966  45.884  1.00 68.29           C  
ATOM   2935  C   LYS A 349       2.729  49.230  44.600  1.00 67.89           C  
ATOM   2936  O   LYS A 349       3.210  48.973  43.513  1.00 68.23           O  
ATOM   2937  CB  LYS A 349       5.007  49.192  45.702  1.00 68.11           C  
ATOM   2938  CG  LYS A 349       5.312  50.660  45.562  1.00 68.04           C  
ATOM   2939  CD  LYS A 349       6.764  50.977  45.778  1.00 67.12           C  
ATOM   2940  CE  LYS A 349       6.953  52.476  45.745  1.00 65.73           C  
ATOM   2941  NZ  LYS A 349       8.376  52.842  45.845  1.00 65.33           N  
ATOM   2942  N   ASP A 350       1.529  49.768  44.776  1.00 67.56           N  
ATOM   2943  CA  ASP A 350       0.566  50.094  43.722  1.00 67.31           C  
ATOM   2944  C   ASP A 350       1.177  50.768  42.491  1.00 66.38           C  
ATOM   2945  O   ASP A 350       0.954  50.325  41.351  1.00 66.76           O  
ATOM   2946  CB  ASP A 350      -0.524  51.005  44.300  1.00 67.77           C  
ATOM   2947  CG  ASP A 350      -1.129  50.463  45.614  1.00 70.34           C  
ATOM   2948  OD1 ASP A 350      -2.381  50.417  45.677  1.00 72.06           O  
ATOM   2949  OD2 ASP A 350      -0.381  50.101  46.583  1.00 72.70           O  
ATOM   2950  N   VAL A 351       1.935  51.839  42.719  1.00 64.79           N  
ATOM   2951  CA  VAL A 351       2.619  52.561  41.639  1.00 62.72           C  
ATOM   2952  C   VAL A 351       4.113  52.277  41.653  1.00 61.77           C  
ATOM   2953  O   VAL A 351       4.740  52.345  42.702  1.00 61.69           O  
ATOM   2954  CB  VAL A 351       2.382  54.071  41.752  1.00 62.23           C  
ATOM   2955  CG1 VAL A 351       3.273  54.845  40.794  1.00 60.84           C  
ATOM   2956  CG2 VAL A 351       0.956  54.350  41.476  1.00 61.91           C  
ATOM   2957  N   LEU A 352       4.668  51.968  40.481  1.00 60.50           N  
ATOM   2958  CA  LEU A 352       6.115  51.772  40.309  1.00 59.45           C  
ATOM   2959  C   LEU A 352       6.753  52.861  39.468  1.00 58.90           C  
ATOM   2960  O   LEU A 352       6.209  53.194  38.422  1.00 59.60           O  
ATOM   2961  CB  LEU A 352       6.348  50.469  39.572  1.00 59.58           C  
ATOM   2962  CG  LEU A 352       6.092  49.213  40.365  1.00 59.38           C  
ATOM   2963  CD1 LEU A 352       6.859  48.086  39.692  1.00 58.11           C  
ATOM   2964  CD2 LEU A 352       6.543  49.479  41.821  1.00 59.37           C  
ATOM   2965  N   SER A 353       7.899  53.416  39.862  1.00 57.80           N  
ATOM   2966  CA  SER A 353       8.595  54.293  38.906  1.00 57.21           C  
ATOM   2967  C   SER A 353       9.859  53.679  38.251  1.00 57.01           C  
ATOM   2968  O   SER A 353      10.829  53.282  38.927  1.00 56.78           O  
ATOM   2969  CB  SER A 353       8.868  55.674  39.461  1.00 56.78           C  
ATOM   2970  OG  SER A 353      10.173  55.728  39.973  1.00 57.33           O  
ATOM   2971  N   VAL A 354       9.822  53.653  36.919  1.00 56.25           N  
ATOM   2972  CA  VAL A 354      10.747  52.884  36.094  1.00 55.66           C  
ATOM   2973  C   VAL A 354      11.616  53.771  35.212  1.00 55.23           C  
ATOM   2974  O   VAL A 354      11.151  54.792  34.683  1.00 55.08           O  
ATOM   2975  CB  VAL A 354       9.948  51.949  35.191  1.00 55.54           C  
ATOM   2976  CG1 VAL A 354      10.850  51.110  34.372  1.00 54.52           C  
ATOM   2977  CG2 VAL A 354       9.027  51.120  36.042  1.00 55.35           C  
ATOM   2978  N   GLU A 355      12.876  53.381  35.063  1.00 54.37           N  
ATOM   2979  CA  GLU A 355      13.795  54.145  34.225  1.00 54.09           C  
ATOM   2980  C   GLU A 355      14.296  53.243  33.093  1.00 53.74           C  
ATOM   2981  O   GLU A 355      14.829  52.128  33.325  1.00 54.11           O  
ATOM   2982  CB  GLU A 355      14.948  54.698  35.052  1.00 53.95           C  
ATOM   2983  CG  GLU A 355      15.733  55.777  34.373  1.00 55.23           C  
ATOM   2984  CD  GLU A 355      15.347  57.161  34.822  1.00 59.65           C  
ATOM   2985  OE1 GLU A 355      15.188  57.367  36.052  1.00 59.87           O  
ATOM   2986  OE2 GLU A 355      15.223  58.062  33.940  1.00 63.22           O  
ATOM   2987  N   ILE A 356      14.113  53.718  31.866  1.00 52.23           N  
ATOM   2988  CA  ILE A 356      14.326  52.865  30.712  1.00 50.85           C  
ATOM   2989  C   ILE A 356      15.614  53.189  29.972  1.00 49.77           C  
ATOM   2990  O   ILE A 356      15.826  54.338  29.530  1.00 48.82           O  
ATOM   2991  CB  ILE A 356      13.067  52.862  29.795  1.00 51.25           C  
ATOM   2992  CG1 ILE A 356      12.001  51.978  30.444  1.00 50.86           C  
ATOM   2993  CG2 ILE A 356      13.373  52.424  28.318  1.00 50.12           C  
ATOM   2994  CD1 ILE A 356      10.629  52.167  29.862  1.00 50.87           C  
ATOM   2995  N   ILE A 357      16.456  52.157  29.848  1.00 47.95           N  
ATOM   2996  CA  ILE A 357      17.683  52.264  29.084  1.00 46.87           C  
ATOM   2997  C   ILE A 357      17.693  51.357  27.869  1.00 46.42           C  
ATOM   2998  O   ILE A 357      17.659  50.148  27.991  1.00 46.73           O  
ATOM   2999  CB  ILE A 357      18.891  51.997  29.956  1.00 46.31           C  
ATOM   3000  CG1 ILE A 357      18.899  53.007  31.096  1.00 46.03           C  
ATOM   3001  CG2 ILE A 357      20.143  52.129  29.147  1.00 45.57           C  
ATOM   3002  CD1 ILE A 357      19.910  52.723  32.120  1.00 46.55           C  
ATOM   3003  N   SER A 358      17.741  51.944  26.688  1.00 45.91           N  
ATOM   3004  CA  SER A 358      17.928  51.140  25.508  1.00 46.01           C  
ATOM   3005  C   SER A 358      19.275  51.410  24.852  1.00 45.88           C  
ATOM   3006  O   SER A 358      19.655  52.559  24.623  1.00 45.32           O  
ATOM   3007  CB  SER A 358      16.786  51.325  24.522  1.00 46.16           C  
ATOM   3008  OG  SER A 358      16.835  50.333  23.502  1.00 47.32           O  
ATOM   3009  N   VAL A 359      19.992  50.321  24.592  1.00 46.11           N  
ATOM   3010  CA  VAL A 359      21.289  50.347  23.911  1.00 46.62           C  
ATOM   3011  C   VAL A 359      21.140  49.666  22.558  1.00 47.12           C  
ATOM   3012  O   VAL A 359      20.837  48.460  22.495  1.00 47.64           O  
ATOM   3013  CB  VAL A 359      22.344  49.517  24.677  1.00 46.13           C  
ATOM   3014  CG1 VAL A 359      23.726  49.693  24.077  1.00 44.11           C  
ATOM   3015  CG2 VAL A 359      22.326  49.874  26.132  1.00 47.19           C  
ATOM   3016  N   SER A 360      21.373  50.397  21.480  1.00 46.86           N  
ATOM   3017  CA  SER A 360      21.339  49.748  20.188  1.00 47.16           C  
ATOM   3018  C   SER A 360      22.312  50.322  19.144  1.00 46.67           C  
ATOM   3019  O   SER A 360      22.991  51.312  19.382  1.00 46.14           O  
ATOM   3020  CB  SER A 360      19.886  49.702  19.687  1.00 47.52           C  
ATOM   3021  OG  SER A 360      19.528  50.900  19.003  1.00 50.01           O  
ATOM   3022  N   VAL A 361      22.367  49.697  17.979  1.00 46.96           N  
ATOM   3023  CA  VAL A 361      23.285  50.134  16.950  1.00 47.38           C  
ATOM   3024  C   VAL A 361      22.697  51.189  16.064  1.00 47.85           C  
ATOM   3025  O   VAL A 361      23.444  51.909  15.454  1.00 48.09           O  
ATOM   3026  CB  VAL A 361      23.822  48.986  16.073  1.00 47.03           C  
ATOM   3027  CG1 VAL A 361      24.937  49.480  15.231  1.00 46.57           C  
ATOM   3028  CG2 VAL A 361      24.379  47.922  16.929  1.00 47.88           C  
ATOM   3029  N   TYR A 362      21.378  51.307  15.992  1.00 48.90           N  
ATOM   3030  CA  TYR A 362      20.773  52.205  14.994  1.00 49.65           C  
ATOM   3031  C   TYR A 362      19.621  52.978  15.567  1.00 50.15           C  
ATOM   3032  O   TYR A 362      19.348  52.833  16.749  1.00 51.00           O  
ATOM   3033  CB  TYR A 362      20.350  51.400  13.769  1.00 50.15           C  
ATOM   3034  CG  TYR A 362      21.525  50.968  12.898  1.00 50.41           C  
ATOM   3035  CD1 TYR A 362      22.039  49.662  12.954  1.00 49.92           C  
ATOM   3036  CD2 TYR A 362      22.132  51.874  12.037  1.00 49.97           C  
ATOM   3037  CE1 TYR A 362      23.115  49.279  12.166  1.00 49.41           C  
ATOM   3038  CE2 TYR A 362      23.207  51.508  11.266  1.00 51.26           C  
ATOM   3039  CZ  TYR A 362      23.689  50.214  11.324  1.00 51.29           C  
ATOM   3040  OH  TYR A 362      24.749  49.904  10.508  1.00 52.85           O  
ATOM   3041  N   LYS A 363      18.919  53.779  14.776  1.00 50.72           N  
ATOM   3042  CA  LYS A 363      18.059  54.776  15.419  1.00 52.37           C  
ATOM   3043  C   LYS A 363      16.543  54.571  15.419  1.00 53.13           C  
ATOM   3044  O   LYS A 363      15.855  54.935  16.397  1.00 53.82           O  
ATOM   3045  CB  LYS A 363      18.380  56.198  14.958  1.00 52.64           C  
ATOM   3046  CG  LYS A 363      17.874  57.260  15.942  1.00 53.56           C  
ATOM   3047  CD  LYS A 363      17.761  58.618  15.314  1.00 54.28           C  
ATOM   3048  CE  LYS A 363      17.706  59.676  16.393  1.00 55.82           C  
ATOM   3049  NZ  LYS A 363      17.764  61.054  15.783  1.00 57.28           N  
ATOM   3050  N   LYS A 364      16.000  54.046  14.333  1.00 53.53           N  
ATOM   3051  CA  LYS A 364      14.556  53.873  14.309  1.00 53.72           C  
ATOM   3052  C   LYS A 364      14.230  52.387  14.362  1.00 53.82           C  
ATOM   3053  O   LYS A 364      13.576  51.872  13.447  1.00 54.91           O  
ATOM   3054  CB  LYS A 364      13.923  54.491  13.053  1.00 53.39           C  
ATOM   3055  CG  LYS A 364      14.212  55.969  12.741  1.00 53.46           C  
ATOM   3056  CD  LYS A 364      13.832  56.179  11.241  1.00 53.99           C  
ATOM   3057  CE  LYS A 364      14.647  57.238  10.517  1.00 52.85           C  
ATOM   3058  NZ  LYS A 364      13.939  58.574  10.450  1.00 51.15           N  
ATOM   3059  N   LEU A 365      14.699  51.675  15.380  1.00 52.58           N  
ATOM   3060  CA  LEU A 365      14.327  50.283  15.478  1.00 51.84           C  
ATOM   3061  C   LEU A 365      14.171  49.927  16.949  1.00 52.20           C  
ATOM   3062  O   LEU A 365      14.877  49.064  17.486  1.00 52.16           O  
ATOM   3063  CB  LEU A 365      15.340  49.376  14.787  1.00 51.39           C  
ATOM   3064  CG  LEU A 365      15.803  49.632  13.345  1.00 51.04           C  
ATOM   3065  CD1 LEU A 365      17.250  49.229  13.216  1.00 50.69           C  
ATOM   3066  CD2 LEU A 365      14.979  48.934  12.256  1.00 50.05           C  
ATOM   3067  N   GLU A 366      13.234  50.612  17.600  1.00 51.90           N  
ATOM   3068  CA  GLU A 366      12.863  50.293  18.964  1.00 51.26           C  
ATOM   3069  C   GLU A 366      11.627  49.418  19.026  1.00 50.85           C  
ATOM   3070  O   GLU A 366      11.278  48.946  20.098  1.00 50.68           O  
ATOM   3071  CB  GLU A 366      12.639  51.573  19.775  1.00 51.75           C  
ATOM   3072  CG  GLU A 366      13.890  52.359  20.094  1.00 52.92           C  
ATOM   3073  CD  GLU A 366      15.086  51.452  20.230  1.00 56.48           C  
ATOM   3074  OE1 GLU A 366      15.305  50.897  21.338  1.00 55.77           O  
ATOM   3075  OE2 GLU A 366      15.792  51.290  19.202  1.00 58.65           O  
ATOM   3076  N   TRP A 367      10.980  49.182  17.889  1.00 50.70           N  
ATOM   3077  CA  TRP A 367       9.707  48.483  17.886  1.00 51.29           C  
ATOM   3078  C   TRP A 367       9.648  47.209  18.691  1.00 51.85           C  
ATOM   3079  O   TRP A 367       8.753  47.064  19.518  1.00 52.60           O  
ATOM   3080  CB  TRP A 367       9.114  48.279  16.498  1.00 51.54           C  
ATOM   3081  CG  TRP A 367       9.797  47.312  15.645  1.00 51.80           C  
ATOM   3082  CD1 TRP A 367      10.876  47.551  14.844  1.00 52.31           C  
ATOM   3083  CD2 TRP A 367       9.440  45.947  15.443  1.00 52.37           C  
ATOM   3084  NE1 TRP A 367      11.234  46.414  14.169  1.00 52.13           N  
ATOM   3085  CE2 TRP A 367      10.372  45.407  14.510  1.00 53.28           C  
ATOM   3086  CE3 TRP A 367       8.438  45.117  15.960  1.00 51.92           C  
ATOM   3087  CZ2 TRP A 367      10.330  44.061  14.079  1.00 52.86           C  
ATOM   3088  CZ3 TRP A 367       8.389  43.769  15.529  1.00 51.98           C  
ATOM   3089  CH2 TRP A 367       9.333  43.263  14.594  1.00 52.40           C  
ATOM   3090  N   ARG A 368      10.579  46.286  18.525  1.00 52.38           N  
ATOM   3091  CA  ARG A 368      10.408  45.039  19.282  1.00 52.86           C  
ATOM   3092  C   ARG A 368      10.376  45.377  20.774  1.00 53.64           C  
ATOM   3093  O   ARG A 368       9.656  44.760  21.556  1.00 54.44           O  
ATOM   3094  CB  ARG A 368      11.472  43.992  18.955  1.00 52.74           C  
ATOM   3095  CG  ARG A 368      11.403  43.431  17.535  1.00 51.66           C  
ATOM   3096  CD  ARG A 368      12.048  42.090  17.451  1.00 51.53           C  
ATOM   3097  NE  ARG A 368      11.857  41.508  16.136  1.00 55.05           N  
ATOM   3098  CZ  ARG A 368      12.746  41.611  15.147  1.00 59.80           C  
ATOM   3099  NH1 ARG A 368      13.885  42.276  15.336  1.00 62.83           N  
ATOM   3100  NH2 ARG A 368      12.505  41.061  13.962  1.00 59.79           N  
ATOM   3101  N   LYS A 369      11.114  46.411  21.144  1.00 53.79           N  
ATOM   3102  CA  LYS A 369      11.267  46.769  22.524  1.00 53.71           C  
ATOM   3103  C   LYS A 369      10.114  47.688  22.935  1.00 54.38           C  
ATOM   3104  O   LYS A 369       9.675  47.705  24.092  1.00 54.95           O  
ATOM   3105  CB  LYS A 369      12.627  47.447  22.723  1.00 53.78           C  
ATOM   3106  CG  LYS A 369      13.800  46.871  21.872  1.00 53.61           C  
ATOM   3107  CD  LYS A 369      15.137  47.495  22.299  1.00 53.17           C  
ATOM   3108  CE  LYS A 369      16.200  47.476  21.226  1.00 51.02           C  
ATOM   3109  NZ  LYS A 369      16.872  48.820  21.140  1.00 51.80           N  
ATOM   3110  N   GLU A 370       9.605  48.470  22.002  1.00 54.51           N  
ATOM   3111  CA  GLU A 370       8.439  49.258  22.337  1.00 54.75           C  
ATOM   3112  C   GLU A 370       7.233  48.331  22.557  1.00 55.02           C  
ATOM   3113  O   GLU A 370       6.543  48.419  23.569  1.00 54.26           O  
ATOM   3114  CB  GLU A 370       8.168  50.321  21.283  1.00 54.06           C  
ATOM   3115  CG  GLU A 370       6.970  51.161  21.611  1.00 55.69           C  
ATOM   3116  CD  GLU A 370       7.185  52.062  22.802  1.00 57.66           C  
ATOM   3117  OE1 GLU A 370       7.925  51.647  23.708  1.00 58.74           O  
ATOM   3118  OE2 GLU A 370       6.617  53.191  22.838  1.00 60.39           O  
ATOM   3119  N   GLU A 371       7.008  47.416  21.620  1.00 55.85           N  
ATOM   3120  CA  GLU A 371       5.923  46.449  21.760  1.00 57.12           C  
ATOM   3121  C   GLU A 371       5.999  45.659  23.061  1.00 57.04           C  
ATOM   3122  O   GLU A 371       5.060  45.696  23.835  1.00 57.53           O  
ATOM   3123  CB  GLU A 371       5.833  45.520  20.557  1.00 57.33           C  
ATOM   3124  CG  GLU A 371       5.314  46.248  19.334  1.00 60.47           C  
ATOM   3125  CD  GLU A 371       5.389  45.412  18.064  1.00 64.45           C  
ATOM   3126  OE1 GLU A 371       5.572  44.159  18.191  1.00 64.36           O  
ATOM   3127  OE2 GLU A 371       5.258  46.028  16.953  1.00 64.32           O  
ATOM   3128  N   PHE A 372       7.104  44.975  23.318  1.00 56.85           N  
ATOM   3129  CA  PHE A 372       7.275  44.332  24.615  1.00 57.15           C  
ATOM   3130  C   PHE A 372       6.890  45.238  25.795  1.00 57.33           C  
ATOM   3131  O   PHE A 372       5.868  45.036  26.453  1.00 56.77           O  
ATOM   3132  CB  PHE A 372       8.701  43.831  24.791  1.00 56.96           C  
ATOM   3133  CG  PHE A 372       8.897  43.026  26.033  1.00 56.69           C  
ATOM   3134  CD1 PHE A 372       8.567  41.671  26.053  1.00 55.42           C  
ATOM   3135  CD2 PHE A 372       9.401  43.627  27.199  1.00 57.66           C  
ATOM   3136  CE1 PHE A 372       8.760  40.903  27.201  1.00 56.66           C  
ATOM   3137  CE2 PHE A 372       9.584  42.883  28.381  1.00 57.53           C  
ATOM   3138  CZ  PHE A 372       9.264  41.509  28.382  1.00 58.11           C  
ATOM   3139  N   LEU A 373       7.715  46.241  26.049  1.00 58.14           N  
ATOM   3140  CA  LEU A 373       7.428  47.217  27.076  1.00 59.33           C  
ATOM   3141  C   LEU A 373       5.936  47.515  27.169  1.00 60.50           C  
ATOM   3142  O   LEU A 373       5.365  47.446  28.230  1.00 60.33           O  
ATOM   3143  CB  LEU A 373       8.204  48.492  26.803  1.00 59.08           C  
ATOM   3144  CG  LEU A 373       8.331  49.429  27.990  1.00 58.90           C  
ATOM   3145  CD1 LEU A 373       9.199  48.784  29.038  1.00 59.09           C  
ATOM   3146  CD2 LEU A 373       8.937  50.713  27.519  1.00 58.75           C  
ATOM   3147  N   LYS A 374       5.310  47.831  26.038  1.00 62.83           N  
ATOM   3148  CA  LYS A 374       3.859  47.995  25.981  1.00 64.61           C  
ATOM   3149  C   LYS A 374       3.095  46.815  26.572  1.00 65.75           C  
ATOM   3150  O   LYS A 374       2.453  46.979  27.617  1.00 66.74           O  
ATOM   3151  CB  LYS A 374       3.368  48.328  24.579  1.00 64.04           C  
ATOM   3152  CG  LYS A 374       2.752  49.699  24.563  1.00 66.58           C  
ATOM   3153  CD  LYS A 374       3.228  50.533  23.389  1.00 71.02           C  
ATOM   3154  CE  LYS A 374       3.425  52.011  23.791  1.00 72.42           C  
ATOM   3155  NZ  LYS A 374       3.498  52.893  22.562  1.00 73.98           N  
ATOM   3156  N   GLU A 375       3.188  45.638  25.947  1.00 66.45           N  
ATOM   3157  CA  GLU A 375       2.334  44.496  26.307  1.00 67.08           C  
ATOM   3158  C   GLU A 375       2.545  44.035  27.768  1.00 67.12           C  
ATOM   3159  O   GLU A 375       1.972  43.033  28.231  1.00 67.69           O  
ATOM   3160  CB  GLU A 375       2.508  43.349  25.291  1.00 67.21           C  
ATOM   3161  CG  GLU A 375       1.319  42.356  25.204  1.00 69.36           C  
ATOM   3162  CD  GLU A 375       0.098  42.851  24.385  1.00 71.78           C  
ATOM   3163  OE1 GLU A 375      -0.155  44.080  24.288  1.00 72.76           O  
ATOM   3164  OE2 GLU A 375      -0.635  41.984  23.851  1.00 72.39           O  
ATOM   3165  N   LEU A 376       3.315  44.821  28.501  1.00 66.63           N  
ATOM   3166  CA  LEU A 376       3.845  44.400  29.763  1.00 66.64           C  
ATOM   3167  C   LEU A 376       3.455  45.389  30.834  1.00 66.69           C  
ATOM   3168  O   LEU A 376       3.142  45.001  31.963  1.00 67.31           O  
ATOM   3169  CB  LEU A 376       5.336  44.326  29.595  1.00 66.93           C  
ATOM   3170  CG  LEU A 376       6.294  44.681  30.687  1.00 67.86           C  
ATOM   3171  CD1 LEU A 376       6.914  43.386  31.181  1.00 70.01           C  
ATOM   3172  CD2 LEU A 376       7.321  45.539  30.004  1.00 69.57           C  
ATOM   3173  N   ILE A 377       3.471  46.670  30.483  1.00 66.28           N  
ATOM   3174  CA  ILE A 377       2.727  47.662  31.228  1.00 65.67           C  
ATOM   3175  C   ILE A 377       1.316  47.097  31.377  1.00 65.61           C  
ATOM   3176  O   ILE A 377       0.768  47.046  32.482  1.00 65.89           O  
ATOM   3177  CB  ILE A 377       2.648  48.989  30.473  1.00 65.55           C  
ATOM   3178  CG1 ILE A 377       3.999  49.706  30.482  1.00 64.84           C  
ATOM   3179  CG2 ILE A 377       1.525  49.886  31.059  1.00 66.06           C  
ATOM   3180  CD1 ILE A 377       4.015  50.926  29.500  1.00 65.77           C  
ATOM   3181  N   ASN A 378       0.762  46.658  30.248  1.00 65.22           N  
ATOM   3182  CA  ASN A 378      -0.555  46.061  30.154  1.00 65.29           C  
ATOM   3183  C   ASN A 378      -0.790  45.044  31.261  1.00 65.57           C  
ATOM   3184  O   ASN A 378      -1.553  45.262  32.202  1.00 65.42           O  
ATOM   3185  CB  ASN A 378      -0.653  45.358  28.805  1.00 65.26           C  
ATOM   3186  CG  ASN A 378      -2.061  45.309  28.260  1.00 65.74           C  
ATOM   3187  OD1 ASN A 378      -3.017  45.254  29.011  1.00 66.08           O  
ATOM   3188  ND2 ASN A 378      -2.192  45.335  26.926  1.00 67.37           N  
ATOM   3189  N   PHE A 379      -0.102  43.926  31.118  1.00 65.99           N  
ATOM   3190  CA  PHE A 379      -0.132  42.813  32.040  1.00 66.41           C  
ATOM   3191  C   PHE A 379       0.001  43.231  33.517  1.00 66.29           C  
ATOM   3192  O   PHE A 379      -0.814  42.837  34.345  1.00 66.46           O  
ATOM   3193  CB  PHE A 379       1.004  41.892  31.616  1.00 66.87           C  
ATOM   3194  CG  PHE A 379       1.077  40.602  32.357  1.00 66.98           C  
ATOM   3195  CD1 PHE A 379       0.373  39.498  31.906  1.00 67.42           C  
ATOM   3196  CD2 PHE A 379       1.914  40.474  33.460  1.00 66.70           C  
ATOM   3197  CE1 PHE A 379       0.472  38.283  32.567  1.00 68.38           C  
ATOM   3198  CE2 PHE A 379       2.029  39.266  34.142  1.00 67.18           C  
ATOM   3199  CZ  PHE A 379       1.308  38.163  33.697  1.00 68.09           C  
ATOM   3200  N   LEU A 380       1.019  44.027  33.829  1.00 66.02           N  
ATOM   3201  CA  LEU A 380       1.239  44.538  35.182  1.00 65.96           C  
ATOM   3202  C   LEU A 380       0.088  45.389  35.738  1.00 65.86           C  
ATOM   3203  O   LEU A 380      -0.114  45.467  36.953  1.00 65.54           O  
ATOM   3204  CB  LEU A 380       2.512  45.375  35.199  1.00 66.02           C  
ATOM   3205  CG  LEU A 380       3.825  44.607  35.159  1.00 67.04           C  
ATOM   3206  CD1 LEU A 380       4.950  45.592  35.037  1.00 67.84           C  
ATOM   3207  CD2 LEU A 380       4.018  43.780  36.404  1.00 67.47           C  
ATOM   3208  N   LYS A 381      -0.615  46.075  34.842  1.00 65.74           N  
ATOM   3209  CA  LYS A 381      -1.762  46.877  35.198  1.00 65.40           C  
ATOM   3210  C   LYS A 381      -2.924  45.981  35.557  1.00 64.69           C  
ATOM   3211  O   LYS A 381      -3.572  46.169  36.576  1.00 64.94           O  
ATOM   3212  CB  LYS A 381      -2.157  47.753  34.031  1.00 65.91           C  
ATOM   3213  CG  LYS A 381      -1.328  49.005  33.894  1.00 68.56           C  
ATOM   3214  CD  LYS A 381      -2.082  50.045  33.030  1.00 71.31           C  
ATOM   3215  CE  LYS A 381      -1.571  51.455  33.295  1.00 72.47           C  
ATOM   3216  NZ  LYS A 381      -1.129  52.057  32.007  1.00 73.89           N  
ATOM   3217  N   ASN A 382      -3.191  45.002  34.713  1.00 63.73           N  
ATOM   3218  CA  ASN A 382      -4.145  43.969  35.053  1.00 62.95           C  
ATOM   3219  C   ASN A 382      -3.815  43.227  36.322  1.00 61.81           C  
ATOM   3220  O   ASN A 382      -4.498  42.289  36.688  1.00 61.68           O  
ATOM   3221  CB  ASN A 382      -4.258  42.965  33.918  1.00 63.55           C  
ATOM   3222  CG  ASN A 382      -5.037  43.507  32.773  1.00 64.49           C  
ATOM   3223  OD1 ASN A 382      -5.358  44.701  32.735  1.00 64.35           O  
ATOM   3224  ND2 ASN A 382      -5.350  42.644  31.819  1.00 66.33           N  
ATOM   3225  N   LYS A 383      -2.765  43.625  36.997  1.00 60.84           N  
ATOM   3226  CA  LYS A 383      -2.521  43.034  38.279  1.00 60.89           C  
ATOM   3227  C   LYS A 383      -2.348  44.077  39.346  1.00 61.28           C  
ATOM   3228  O   LYS A 383      -1.819  43.797  40.405  1.00 61.34           O  
ATOM   3229  CB  LYS A 383      -1.361  42.061  38.214  1.00 60.79           C  
ATOM   3230  CG  LYS A 383      -1.805  40.768  37.575  1.00 61.03           C  
ATOM   3231  CD  LYS A 383      -0.715  40.036  36.865  1.00 60.05           C  
ATOM   3232  CE  LYS A 383      -1.300  38.726  36.424  1.00 61.03           C  
ATOM   3233  NZ  LYS A 383      -0.318  37.600  36.584  1.00 61.45           N  
ATOM   3234  N   GLY A 384      -2.830  45.281  39.051  1.00 61.78           N  
ATOM   3235  CA  GLY A 384      -2.911  46.359  40.021  1.00 62.40           C  
ATOM   3236  C   GLY A 384      -1.646  47.172  40.107  1.00 63.08           C  
ATOM   3237  O   GLY A 384      -1.392  47.843  41.117  1.00 63.18           O  
ATOM   3238  N   ILE A 385      -0.841  47.115  39.051  1.00 63.76           N  
ATOM   3239  CA  ILE A 385       0.407  47.851  39.058  1.00 64.37           C  
ATOM   3240  C   ILE A 385       0.642  48.700  37.814  1.00 64.88           C  
ATOM   3241  O   ILE A 385       0.664  48.214  36.667  1.00 65.42           O  
ATOM   3242  CB  ILE A 385       1.590  46.923  39.340  1.00 64.64           C  
ATOM   3243  CG1 ILE A 385       1.212  45.916  40.443  1.00 63.43           C  
ATOM   3244  CG2 ILE A 385       2.840  47.757  39.688  1.00 65.35           C  
ATOM   3245  CD1 ILE A 385       2.357  45.439  41.273  1.00 62.40           C  
ATOM   3246  N   LYS A 386       0.792  49.993  38.068  1.00 65.05           N  
ATOM   3247  CA  LYS A 386       1.114  50.968  37.045  1.00 64.98           C  
ATOM   3248  C   LYS A 386       2.605  51.229  37.104  1.00 64.87           C  
ATOM   3249  O   LYS A 386       3.140  51.579  38.175  1.00 64.98           O  
ATOM   3250  CB  LYS A 386       0.420  52.289  37.355  1.00 65.11           C  
ATOM   3251  CG  LYS A 386      -1.021  52.386  36.965  1.00 66.04           C  
ATOM   3252  CD  LYS A 386      -1.530  53.787  37.312  1.00 67.07           C  
ATOM   3253  CE  LYS A 386      -2.956  53.973  36.842  1.00 67.41           C  
ATOM   3254  NZ  LYS A 386      -3.688  54.878  37.759  1.00 68.53           N  
ATOM   3255  N   LEU A 387       3.280  51.085  35.970  1.00 64.47           N  
ATOM   3256  CA  LEU A 387       4.630  51.627  35.845  1.00 64.23           C  
ATOM   3257  C   LEU A 387       4.546  53.034  35.319  1.00 64.15           C  
ATOM   3258  O   LEU A 387       4.086  53.234  34.201  1.00 64.70           O  
ATOM   3259  CB  LEU A 387       5.452  50.822  34.860  1.00 64.02           C  
ATOM   3260  CG  LEU A 387       5.340  49.326  35.031  1.00 64.16           C  
ATOM   3261  CD1 LEU A 387       5.553  48.718  33.700  1.00 64.38           C  
ATOM   3262  CD2 LEU A 387       6.345  48.833  36.059  1.00 63.69           C  
ATOM   3263  N   LYS A 388       4.957  54.010  36.119  1.00 64.04           N  
ATOM   3264  CA  LYS A 388       5.239  55.330  35.589  1.00 64.09           C  
ATOM   3265  C   LYS A 388       6.657  55.297  35.036  1.00 63.91           C  
ATOM   3266  O   LYS A 388       7.609  54.944  35.747  1.00 64.21           O  
ATOM   3267  CB  LYS A 388       5.108  56.388  36.664  1.00 64.38           C  
ATOM   3268  CG  LYS A 388       3.740  56.390  37.368  1.00 66.36           C  
ATOM   3269  CD  LYS A 388       2.543  56.461  36.384  1.00 67.98           C  
ATOM   3270  CE  LYS A 388       1.219  56.666  37.121  1.00 66.31           C  
ATOM   3271  NZ  LYS A 388       1.226  57.987  37.796  1.00 65.95           N  
ATOM   3272  N   ILE A 389       6.794  55.595  33.746  1.00 63.05           N  
ATOM   3273  CA  ILE A 389       8.107  55.744  33.166  1.00 61.61           C  
ATOM   3274  C   ILE A 389       8.585  57.122  33.557  1.00 61.22           C  
ATOM   3275  O   ILE A 389       8.032  58.112  33.126  1.00 60.68           O  
ATOM   3276  CB  ILE A 389       8.076  55.651  31.659  1.00 61.53           C  
ATOM   3277  CG1 ILE A 389       7.709  54.235  31.242  1.00 60.86           C  
ATOM   3278  CG2 ILE A 389       9.422  56.075  31.081  1.00 60.64           C  
ATOM   3279  CD1 ILE A 389       7.560  54.073  29.749  1.00 63.16           C  
ATOM   3280  N   LYS A 390       9.595  57.157  34.416  1.00 60.86           N  
ATOM   3281  CA  LYS A 390      10.250  58.382  34.801  1.00 60.20           C  
ATOM   3282  C   LYS A 390      11.077  58.969  33.664  1.00 58.93           C  
ATOM   3283  O   LYS A 390      11.362  60.147  33.720  1.00 59.19           O  
ATOM   3284  CB  LYS A 390      11.151  58.142  36.011  1.00 60.76           C  
ATOM   3285  CG  LYS A 390      10.431  58.142  37.362  1.00 63.32           C  
ATOM   3286  CD  LYS A 390      11.359  58.597  38.528  1.00 63.48           C  
ATOM   3287  CE  LYS A 390      10.541  58.872  39.797  1.00 65.60           C  
ATOM   3288  NZ  LYS A 390      11.314  59.395  40.991  1.00 66.88           N  
ATOM   3289  N   GLY A 391      11.463  58.170  32.657  1.00 57.31           N  
ATOM   3290  CA  GLY A 391      12.310  58.639  31.550  1.00 55.70           C  
ATOM   3291  C   GLY A 391      13.041  57.531  30.815  1.00 55.05           C  
ATOM   3292  O   GLY A 391      13.407  56.542  31.433  1.00 55.83           O  
ATOM   3293  N   LYS A 392      13.224  57.678  29.491  1.00 53.88           N  
ATOM   3294  CA  LYS A 392      14.020  56.751  28.625  1.00 52.51           C  
ATOM   3295  C   LYS A 392      15.418  57.352  28.372  1.00 51.31           C  
ATOM   3296  O   LYS A 392      15.639  58.526  28.591  1.00 51.08           O  
ATOM   3297  CB  LYS A 392      13.294  56.482  27.269  1.00 52.61           C  
ATOM   3298  CG  LYS A 392      13.777  55.240  26.358  1.00 53.39           C  
ATOM   3299  CD  LYS A 392      12.893  55.047  25.032  1.00 52.63           C  
ATOM   3300  CE  LYS A 392      13.262  53.843  24.063  1.00 53.41           C  
ATOM   3301  NZ  LYS A 392      12.658  52.411  24.296  1.00 51.83           N  
ATOM   3302  N   SER A 393      16.370  56.533  27.941  1.00 50.36           N  
ATOM   3303  CA  SER A 393      17.649  57.007  27.403  1.00 48.53           C  
ATOM   3304  C   SER A 393      18.018  56.035  26.344  1.00 47.78           C  
ATOM   3305  O   SER A 393      18.250  54.865  26.630  1.00 48.06           O  
ATOM   3306  CB  SER A 393      18.761  56.992  28.446  1.00 48.24           C  
ATOM   3307  OG  SER A 393      18.353  57.641  29.624  1.00 47.47           O  
ATOM   3308  N   LEU A 394      18.069  56.504  25.118  1.00 47.13           N  
ATOM   3309  CA  LEU A 394      18.537  55.673  24.009  1.00 47.18           C  
ATOM   3310  C   LEU A 394      20.046  55.901  23.705  1.00 46.62           C  
ATOM   3311  O   LEU A 394      20.423  56.939  23.164  1.00 47.03           O  
ATOM   3312  CB  LEU A 394      17.663  55.942  22.774  1.00 47.09           C  
ATOM   3313  CG  LEU A 394      18.244  55.622  21.405  1.00 47.29           C  
ATOM   3314  CD1 LEU A 394      17.909  54.173  20.960  1.00 47.14           C  
ATOM   3315  CD2 LEU A 394      17.774  56.672  20.406  1.00 47.04           C  
ATOM   3316  N   ILE A 395      20.892  54.952  24.073  1.00 45.65           N  
ATOM   3317  CA  ILE A 395      22.301  55.041  23.745  1.00 45.59           C  
ATOM   3318  C   ILE A 395      22.584  54.335  22.411  1.00 46.14           C  
ATOM   3319  O   ILE A 395      22.297  53.123  22.279  1.00 45.94           O  
ATOM   3320  CB  ILE A 395      23.156  54.358  24.849  1.00 45.69           C  
ATOM   3321  CG1 ILE A 395      23.115  55.167  26.138  1.00 44.47           C  
ATOM   3322  CG2 ILE A 395      24.606  54.095  24.381  1.00 44.44           C  
ATOM   3323  CD1 ILE A 395      23.534  54.370  27.358  1.00 44.02           C  
ATOM   3324  N   LEU A 396      23.155  55.069  21.440  1.00 46.46           N  
ATOM   3325  CA  LEU A 396      23.696  54.441  20.187  1.00 46.79           C  
ATOM   3326  C   LEU A 396      25.167  54.041  20.374  1.00 47.39           C  
ATOM   3327  O   LEU A 396      25.938  54.805  20.928  1.00 48.01           O  
ATOM   3328  CB  LEU A 396      23.517  55.355  18.966  1.00 45.48           C  
ATOM   3329  CG  LEU A 396      22.133  55.984  18.779  1.00 44.02           C  
ATOM   3330  CD1 LEU A 396      22.059  56.836  17.535  1.00 43.61           C  
ATOM   3331  CD2 LEU A 396      21.012  54.972  18.741  1.00 43.36           C  
ATOM   3332  N   ALA A 397      25.566  52.856  19.946  1.00 48.22           N  
ATOM   3333  CA  ALA A 397      26.924  52.369  20.273  1.00 50.24           C  
ATOM   3334  C   ALA A 397      27.337  51.180  19.418  1.00 51.42           C  
ATOM   3335  O   ALA A 397      26.487  50.347  19.108  1.00 52.06           O  
ATOM   3336  CB  ALA A 397      27.009  51.981  21.766  1.00 50.15           C  
ATOM   3337  N   GLN A 398      28.619  51.052  19.066  1.00 52.84           N  
ATOM   3338  CA  GLN A 398      28.993  50.049  18.031  1.00 54.44           C  
ATOM   3339  C   GLN A 398      29.834  48.833  18.400  1.00 55.99           C  
ATOM   3340  O   GLN A 398      29.883  47.857  17.646  1.00 56.19           O  
ATOM   3341  CB  GLN A 398      29.550  50.730  16.805  1.00 53.94           C  
ATOM   3342  CG  GLN A 398      28.440  51.291  15.971  1.00 53.84           C  
ATOM   3343  CD  GLN A 398      28.908  52.373  15.073  1.00 53.98           C  
ATOM   3344  OE1 GLN A 398      29.884  52.220  14.335  1.00 53.37           O  
ATOM   3345  NE2 GLN A 398      28.218  53.497  15.124  1.00 56.55           N  
ATOM   3346  N   THR A 399      30.427  48.882  19.590  1.00 57.94           N  
ATOM   3347  CA  THR A 399      31.223  47.818  20.183  1.00 59.14           C  
ATOM   3348  C   THR A 399      30.585  47.607  21.539  1.00 60.18           C  
ATOM   3349  O   THR A 399      29.794  48.452  21.931  1.00 60.63           O  
ATOM   3350  CB  THR A 399      32.615  48.381  20.484  1.00 59.30           C  
ATOM   3351  OG1 THR A 399      32.888  49.524  19.647  1.00 58.35           O  
ATOM   3352  CG2 THR A 399      33.671  47.306  20.334  1.00 60.00           C  
ATOM   3353  N   ARG A 400      30.927  46.551  22.289  1.00 61.46           N  
ATOM   3354  CA  ARG A 400      30.551  46.506  23.729  1.00 62.74           C  
ATOM   3355  C   ARG A 400      31.291  47.598  24.476  1.00 63.37           C  
ATOM   3356  O   ARG A 400      30.767  48.192  25.413  1.00 63.93           O  
ATOM   3357  CB  ARG A 400      30.893  45.188  24.396  1.00 62.60           C  
ATOM   3358  CG  ARG A 400      30.594  43.979  23.571  1.00 65.58           C  
ATOM   3359  CD  ARG A 400      30.636  42.767  24.436  1.00 70.47           C  
ATOM   3360  NE  ARG A 400      31.036  41.555  23.722  1.00 73.00           N  
ATOM   3361  CZ  ARG A 400      31.108  40.354  24.307  1.00 75.64           C  
ATOM   3362  NH1 ARG A 400      30.806  40.213  25.606  1.00 75.36           N  
ATOM   3363  NH2 ARG A 400      31.482  39.287  23.606  1.00 76.74           N  
ATOM   3364  N   GLU A 401      32.520  47.844  24.039  1.00 63.99           N  
ATOM   3365  CA  GLU A 401      33.386  48.858  24.594  1.00 64.59           C  
ATOM   3366  C   GLU A 401      32.752  50.239  24.513  1.00 63.86           C  
ATOM   3367  O   GLU A 401      32.691  50.930  25.529  1.00 63.84           O  
ATOM   3368  CB  GLU A 401      34.760  48.807  23.908  1.00 65.34           C  
ATOM   3369  CG  GLU A 401      35.524  47.474  24.170  1.00 69.90           C  
ATOM   3370  CD  GLU A 401      36.170  46.833  22.897  1.00 75.21           C  
ATOM   3371  OE1 GLU A 401      36.257  47.514  21.832  1.00 74.78           O  
ATOM   3372  OE2 GLU A 401      36.596  45.636  22.982  1.00 76.55           O  
ATOM   3373  N   GLU A 402      32.264  50.635  23.333  1.00 63.39           N  
ATOM   3374  CA  GLU A 402      31.656  51.968  23.172  1.00 63.10           C  
ATOM   3375  C   GLU A 402      30.441  52.128  24.089  1.00 63.16           C  
ATOM   3376  O   GLU A 402      30.266  53.175  24.742  1.00 63.20           O  
ATOM   3377  CB  GLU A 402      31.236  52.241  21.727  1.00 62.87           C  
ATOM   3378  CG  GLU A 402      30.538  53.616  21.561  1.00 62.77           C  
ATOM   3379  CD  GLU A 402      30.206  54.011  20.107  1.00 63.19           C  
ATOM   3380  OE1 GLU A 402      30.380  53.195  19.176  1.00 64.91           O  
ATOM   3381  OE2 GLU A 402      29.759  55.157  19.886  1.00 62.73           O  
ATOM   3382  N   ALA A 403      29.619  51.073  24.114  1.00 62.81           N  
ATOM   3383  CA  ALA A 403      28.407  50.990  24.902  1.00 61.95           C  
ATOM   3384  C   ALA A 403      28.744  51.195  26.350  1.00 62.08           C  
ATOM   3385  O   ALA A 403      28.267  52.169  26.946  1.00 62.39           O  
ATOM   3386  CB  ALA A 403      27.768  49.655  24.710  1.00 61.89           C  
ATOM   3387  N   LYS A 404      29.586  50.300  26.896  1.00 61.80           N  
ATOM   3388  CA  LYS A 404      30.004  50.342  28.303  1.00 61.96           C  
ATOM   3389  C   LYS A 404      30.277  51.773  28.666  1.00 61.32           C  
ATOM   3390  O   LYS A 404      29.686  52.310  29.604  1.00 61.59           O  
ATOM   3391  CB  LYS A 404      31.254  49.485  28.559  1.00 61.78           C  
ATOM   3392  CG  LYS A 404      32.567  50.247  28.926  1.00 63.35           C  
ATOM   3393  CD  LYS A 404      33.792  49.267  29.175  1.00 64.30           C  
ATOM   3394  CE  LYS A 404      35.039  49.577  28.232  1.00 65.59           C  
ATOM   3395  NZ  LYS A 404      35.665  48.339  27.559  1.00 63.20           N  
ATOM   3396  N   GLU A 405      31.132  52.393  27.857  1.00 60.55           N  
ATOM   3397  CA  GLU A 405      31.568  53.754  28.052  1.00 59.63           C  
ATOM   3398  C   GLU A 405      30.426  54.753  28.177  1.00 58.75           C  
ATOM   3399  O   GLU A 405      30.458  55.618  29.062  1.00 58.91           O  
ATOM   3400  CB  GLU A 405      32.448  54.183  26.892  1.00 60.14           C  
ATOM   3401  CG  GLU A 405      33.528  53.220  26.474  1.00 60.53           C  
ATOM   3402  CD  GLU A 405      34.208  53.696  25.203  1.00 61.50           C  
ATOM   3403  OE1 GLU A 405      34.030  54.894  24.837  1.00 60.11           O  
ATOM   3404  OE2 GLU A 405      34.909  52.869  24.568  1.00 62.28           O  
ATOM   3405  N   LYS A 406      29.444  54.673  27.279  1.00 57.31           N  
ATOM   3406  CA  LYS A 406      28.337  55.626  27.335  1.00 56.31           C  
ATOM   3407  C   LYS A 406      27.360  55.240  28.450  1.00 56.23           C  
ATOM   3408  O   LYS A 406      26.792  56.118  29.126  1.00 56.72           O  
ATOM   3409  CB  LYS A 406      27.622  55.749  26.007  1.00 55.54           C  
ATOM   3410  CG  LYS A 406      28.544  56.053  24.875  1.00 55.20           C  
ATOM   3411  CD  LYS A 406      27.739  56.365  23.653  1.00 55.14           C  
ATOM   3412  CE  LYS A 406      28.625  56.655  22.478  1.00 55.47           C  
ATOM   3413  NZ  LYS A 406      27.843  57.227  21.351  1.00 55.47           N  
ATOM   3414  N   LEU A 407      27.193  53.937  28.674  1.00 54.62           N  
ATOM   3415  CA  LEU A 407      26.325  53.498  29.724  1.00 53.47           C  
ATOM   3416  C   LEU A 407      26.685  54.131  31.069  1.00 53.44           C  
ATOM   3417  O   LEU A 407      25.788  54.384  31.868  1.00 53.70           O  
ATOM   3418  CB  LEU A 407      26.331  51.977  29.811  1.00 53.52           C  
ATOM   3419  CG  LEU A 407      25.364  51.216  28.905  1.00 51.66           C  
ATOM   3420  CD1 LEU A 407      25.835  49.810  28.762  1.00 48.54           C  
ATOM   3421  CD2 LEU A 407      23.948  51.246  29.436  1.00 49.49           C  
ATOM   3422  N   ILE A 408      27.977  54.402  31.303  1.00 53.23           N  
ATOM   3423  CA  ILE A 408      28.491  54.933  32.604  1.00 52.73           C  
ATOM   3424  C   ILE A 408      27.838  56.254  33.090  1.00 52.70           C  
ATOM   3425  O   ILE A 408      27.171  56.264  34.132  1.00 52.54           O  
ATOM   3426  CB  ILE A 408      30.051  55.018  32.646  1.00 52.51           C  
ATOM   3427  CG1 ILE A 408      30.650  53.638  32.865  1.00 51.75           C  
ATOM   3428  CG2 ILE A 408      30.533  55.914  33.769  1.00 51.61           C  
ATOM   3429  CD1 ILE A 408      31.903  53.410  32.058  1.00 51.89           C  
ATOM   3430  N   PRO A 409      27.986  57.355  32.330  1.00 52.35           N  
ATOM   3431  CA  PRO A 409      27.348  58.548  32.861  1.00 52.60           C  
ATOM   3432  C   PRO A 409      25.834  58.373  32.971  1.00 52.94           C  
ATOM   3433  O   PRO A 409      25.241  58.914  33.907  1.00 53.84           O  
ATOM   3434  CB  PRO A 409      27.679  59.629  31.840  1.00 51.90           C  
ATOM   3435  CG  PRO A 409      28.820  59.093  31.083  1.00 52.48           C  
ATOM   3436  CD  PRO A 409      28.627  57.620  31.037  1.00 52.37           C  
ATOM   3437  N   VAL A 410      25.226  57.608  32.058  1.00 52.46           N  
ATOM   3438  CA  VAL A 410      23.786  57.318  32.129  1.00 51.75           C  
ATOM   3439  C   VAL A 410      23.395  56.631  33.461  1.00 51.98           C  
ATOM   3440  O   VAL A 410      22.611  57.196  34.232  1.00 52.24           O  
ATOM   3441  CB  VAL A 410      23.261  56.550  30.878  1.00 51.42           C  
ATOM   3442  CG1 VAL A 410      21.842  56.058  31.080  1.00 50.08           C  
ATOM   3443  CG2 VAL A 410      23.316  57.431  29.649  1.00 50.53           C  
ATOM   3444  N   ILE A 411      23.944  55.452  33.743  1.00 51.78           N  
ATOM   3445  CA  ILE A 411      23.609  54.719  34.977  1.00 52.03           C  
ATOM   3446  C   ILE A 411      23.941  55.558  36.193  1.00 53.20           C  
ATOM   3447  O   ILE A 411      23.177  55.654  37.146  1.00 53.18           O  
ATOM   3448  CB  ILE A 411      24.397  53.408  35.097  1.00 51.46           C  
ATOM   3449  CG1 ILE A 411      23.884  52.383  34.107  1.00 50.81           C  
ATOM   3450  CG2 ILE A 411      24.293  52.852  36.475  1.00 49.81           C  
ATOM   3451  CD1 ILE A 411      24.780  51.215  33.984  1.00 51.22           C  
ATOM   3452  N   ASN A 412      25.113  56.163  36.142  1.00 54.80           N  
ATOM   3453  CA  ASN A 412      25.549  57.096  37.147  1.00 55.90           C  
ATOM   3454  C   ASN A 412      24.421  57.984  37.664  1.00 55.89           C  
ATOM   3455  O   ASN A 412      24.249  58.097  38.851  1.00 56.21           O  
ATOM   3456  CB  ASN A 412      26.628  57.991  36.539  1.00 56.63           C  
ATOM   3457  CG  ASN A 412      27.679  58.397  37.543  1.00 58.52           C  
ATOM   3458  OD1 ASN A 412      27.506  59.372  38.338  1.00 57.67           O  
ATOM   3459  ND2 ASN A 412      28.797  57.643  37.527  1.00 59.47           N  
ATOM   3460  N   LYS A 413      23.653  58.602  36.773  1.00 55.89           N  
ATOM   3461  CA  LYS A 413      22.726  59.659  37.171  1.00 56.04           C  
ATOM   3462  C   LYS A 413      21.381  59.188  37.721  1.00 55.66           C  
ATOM   3463  O   LYS A 413      20.643  59.959  38.333  1.00 55.64           O  
ATOM   3464  CB  LYS A 413      22.556  60.647  36.027  1.00 55.84           C  
ATOM   3465  CG  LYS A 413      23.877  61.256  35.690  1.00 57.80           C  
ATOM   3466  CD  LYS A 413      23.837  61.982  34.382  1.00 63.11           C  
ATOM   3467  CE  LYS A 413      25.248  62.198  33.825  1.00 64.56           C  
ATOM   3468  NZ  LYS A 413      25.206  63.207  32.704  1.00 67.28           N  
ATOM   3469  N   ILE A 414      21.089  57.915  37.539  1.00 55.44           N  
ATOM   3470  CA  ILE A 414      19.812  57.370  37.966  1.00 56.13           C  
ATOM   3471  C   ILE A 414      19.620  57.388  39.501  1.00 57.04           C  
ATOM   3472  O   ILE A 414      20.254  56.622  40.243  1.00 57.02           O  
ATOM   3473  CB  ILE A 414      19.580  55.940  37.382  1.00 55.81           C  
ATOM   3474  CG1 ILE A 414      19.896  55.928  35.888  1.00 54.78           C  
ATOM   3475  CG2 ILE A 414      18.143  55.483  37.620  1.00 55.16           C  
ATOM   3476  CD1 ILE A 414      19.890  54.581  35.254  1.00 52.87           C  
ATOM   3477  N   LYS A 415      18.747  58.280  39.963  1.00 57.72           N  
ATOM   3478  CA  LYS A 415      18.411  58.351  41.376  1.00 58.37           C  
ATOM   3479  C   LYS A 415      16.988  57.912  41.515  1.00 58.54           C  
ATOM   3480  O   LYS A 415      16.249  57.929  40.542  1.00 58.71           O  
ATOM   3481  CB  LYS A 415      18.522  59.773  41.882  1.00 58.13           C  
ATOM   3482  CG  LYS A 415      19.838  60.411  41.573  1.00 59.83           C  
ATOM   3483  CD  LYS A 415      19.760  61.917  41.821  1.00 64.81           C  
ATOM   3484  CE  LYS A 415      20.074  62.309  43.284  1.00 66.16           C  
ATOM   3485  NZ  LYS A 415      20.385  63.775  43.329  1.00 67.92           N  
ATOM   3486  N   ASP A 416      16.613  57.496  42.720  1.00 58.98           N  
ATOM   3487  CA  ASP A 416      15.211  57.340  43.092  1.00 58.84           C  
ATOM   3488  C   ASP A 416      14.341  56.644  42.046  1.00 57.79           C  
ATOM   3489  O   ASP A 416      13.468  57.281  41.422  1.00 57.83           O  
ATOM   3490  CB  ASP A 416      14.616  58.721  43.426  1.00 59.30           C  
ATOM   3491  CG  ASP A 416      15.058  59.224  44.779  1.00 61.98           C  
ATOM   3492  OD1 ASP A 416      15.655  58.435  45.556  1.00 64.69           O  
ATOM   3493  OD2 ASP A 416      14.796  60.411  45.079  1.00 65.75           O  
ATOM   3494  N   VAL A 417      14.569  55.356  41.829  1.00 55.81           N  
ATOM   3495  CA  VAL A 417      13.608  54.622  41.038  1.00 54.64           C  
ATOM   3496  C   VAL A 417      13.364  53.302  41.664  1.00 53.33           C  
ATOM   3497  O   VAL A 417      14.227  52.757  42.339  1.00 52.30           O  
ATOM   3498  CB  VAL A 417      14.026  54.378  39.533  1.00 55.05           C  
ATOM   3499  CG1 VAL A 417      14.150  55.653  38.751  1.00 55.23           C  
ATOM   3500  CG2 VAL A 417      15.311  53.582  39.417  1.00 56.70           C  
ATOM   3501  N   ASP A 418      12.188  52.766  41.396  1.00 52.80           N  
ATOM   3502  CA  ASP A 418      11.897  51.415  41.813  1.00 52.71           C  
ATOM   3503  C   ASP A 418      12.472  50.383  40.856  1.00 52.97           C  
ATOM   3504  O   ASP A 418      12.622  49.221  41.234  1.00 53.77           O  
ATOM   3505  CB  ASP A 418      10.400  51.203  41.972  1.00 52.62           C  
ATOM   3506  CG  ASP A 418       9.772  52.169  42.954  1.00 52.27           C  
ATOM   3507  OD1 ASP A 418      10.154  52.199  44.157  1.00 49.52           O  
ATOM   3508  OD2 ASP A 418       8.874  52.901  42.497  1.00 55.01           O  
ATOM   3509  N   LEU A 419      12.813  50.795  39.632  1.00 52.72           N  
ATOM   3510  CA  LEU A 419      13.305  49.852  38.634  1.00 52.13           C  
ATOM   3511  C   LEU A 419      14.048  50.513  37.476  1.00 52.84           C  
ATOM   3512  O   LEU A 419      13.759  51.665  37.106  1.00 53.59           O  
ATOM   3513  CB  LEU A 419      12.129  49.029  38.093  1.00 52.04           C  
ATOM   3514  CG  LEU A 419      12.322  47.829  37.166  1.00 50.76           C  
ATOM   3515  CD1 LEU A 419      13.163  46.705  37.786  1.00 47.25           C  
ATOM   3516  CD2 LEU A 419      10.956  47.339  36.731  1.00 50.39           C  
ATOM   3517  N   VAL A 420      14.993  49.772  36.897  1.00 52.52           N  
ATOM   3518  CA  VAL A 420      15.662  50.192  35.680  1.00 52.38           C  
ATOM   3519  C   VAL A 420      15.464  49.077  34.672  1.00 52.76           C  
ATOM   3520  O   VAL A 420      15.743  47.903  34.959  1.00 53.21           O  
ATOM   3521  CB  VAL A 420      17.177  50.437  35.888  1.00 52.10           C  
ATOM   3522  CG1 VAL A 420      17.833  50.826  34.583  1.00 52.19           C  
ATOM   3523  CG2 VAL A 420      17.422  51.499  36.899  1.00 51.00           C  
ATOM   3524  N   ILE A 421      14.971  49.409  33.489  1.00 52.63           N  
ATOM   3525  CA  ILE A 421      14.944  48.386  32.454  1.00 52.54           C  
ATOM   3526  C   ILE A 421      15.941  48.711  31.340  1.00 52.67           C  
ATOM   3527  O   ILE A 421      16.048  49.870  30.888  1.00 53.31           O  
ATOM   3528  CB  ILE A 421      13.543  48.115  31.935  1.00 52.28           C  
ATOM   3529  CG1 ILE A 421      12.670  47.672  33.104  1.00 51.44           C  
ATOM   3530  CG2 ILE A 421      13.590  47.021  30.858  1.00 51.94           C  
ATOM   3531  CD1 ILE A 421      11.196  47.669  32.809  1.00 50.97           C  
ATOM   3532  N   VAL A 422      16.695  47.694  30.929  1.00 51.98           N  
ATOM   3533  CA  VAL A 422      17.772  47.897  29.989  1.00 51.16           C  
ATOM   3534  C   VAL A 422      17.583  46.950  28.857  1.00 51.32           C  
ATOM   3535  O   VAL A 422      17.561  45.737  29.066  1.00 51.73           O  
ATOM   3536  CB  VAL A 422      19.149  47.598  30.584  1.00 50.97           C  
ATOM   3537  CG1 VAL A 422      20.180  48.429  29.865  1.00 50.45           C  
ATOM   3538  CG2 VAL A 422      19.186  47.842  32.097  1.00 50.20           C  
ATOM   3539  N   PHE A 423      17.430  47.498  27.662  1.00 51.37           N  
ATOM   3540  CA  PHE A 423      17.409  46.689  26.471  1.00 51.97           C  
ATOM   3541  C   PHE A 423      18.783  46.812  25.845  1.00 52.67           C  
ATOM   3542  O   PHE A 423      19.214  47.915  25.441  1.00 52.38           O  
ATOM   3543  CB  PHE A 423      16.391  47.215  25.476  1.00 52.27           C  
ATOM   3544  CG  PHE A 423      14.980  47.123  25.926  1.00 52.09           C  
ATOM   3545  CD1 PHE A 423      14.295  48.285  26.324  1.00 50.66           C  
ATOM   3546  CD2 PHE A 423      14.311  45.887  25.927  1.00 52.20           C  
ATOM   3547  CE1 PHE A 423      12.956  48.235  26.754  1.00 50.09           C  
ATOM   3548  CE2 PHE A 423      12.962  45.815  26.342  1.00 52.85           C  
ATOM   3549  CZ  PHE A 423      12.284  47.010  26.760  1.00 52.00           C  
ATOM   3550  N   LEU A 424      19.465  45.680  25.757  1.00 53.34           N  
ATOM   3551  CA  LEU A 424      20.823  45.667  25.292  1.00 54.60           C  
ATOM   3552  C   LEU A 424      20.876  45.002  23.980  1.00 56.60           C  
ATOM   3553  O   LEU A 424      20.381  43.893  23.821  1.00 56.79           O  
ATOM   3554  CB  LEU A 424      21.674  44.842  26.212  1.00 54.10           C  
ATOM   3555  CG  LEU A 424      22.058  45.364  27.569  1.00 53.02           C  
ATOM   3556  CD1 LEU A 424      23.105  44.413  27.994  1.00 52.53           C  
ATOM   3557  CD2 LEU A 424      22.630  46.762  27.479  1.00 52.07           C  
ATOM   3558  N   GLU A 425      21.503  45.646  23.018  1.00 59.46           N  
ATOM   3559  CA  GLU A 425      21.773  44.906  21.824  1.00 62.29           C  
ATOM   3560  C   GLU A 425      23.018  44.085  21.949  1.00 64.09           C  
ATOM   3561  O   GLU A 425      23.803  44.233  22.878  1.00 64.11           O  
ATOM   3562  CB  GLU A 425      21.864  45.767  20.607  1.00 62.39           C  
ATOM   3563  CG  GLU A 425      21.812  44.898  19.396  1.00 64.26           C  
ATOM   3564  CD  GLU A 425      21.830  45.689  18.139  1.00 67.28           C  
ATOM   3565  OE1 GLU A 425      21.320  46.846  18.133  1.00 66.22           O  
ATOM   3566  OE2 GLU A 425      22.354  45.125  17.151  1.00 70.26           O  
ATOM   3567  N   GLU A 426      23.179  43.200  20.987  1.00 66.92           N  
ATOM   3568  CA  GLU A 426      24.193  42.185  21.076  1.00 69.70           C  
ATOM   3569  C   GLU A 426      25.412  42.653  20.316  1.00 70.31           C  
ATOM   3570  O   GLU A 426      25.304  43.079  19.185  1.00 70.34           O  
ATOM   3571  CB  GLU A 426      23.613  40.867  20.552  1.00 70.21           C  
ATOM   3572  CG  GLU A 426      24.146  40.403  19.221  1.00 73.83           C  
ATOM   3573  CD  GLU A 426      24.272  38.897  19.202  1.00 79.02           C  
ATOM   3574  OE1 GLU A 426      23.744  38.259  20.149  1.00 80.81           O  
ATOM   3575  OE2 GLU A 426      24.914  38.360  18.263  1.00 81.18           O  
ATOM   3576  N   TYR A 427      26.563  42.634  20.967  1.00 72.03           N  
ATOM   3577  CA  TYR A 427      27.795  43.023  20.295  1.00 73.75           C  
ATOM   3578  C   TYR A 427      28.702  41.789  20.129  1.00 76.55           C  
ATOM   3579  O   TYR A 427      29.230  41.233  21.108  1.00 76.67           O  
ATOM   3580  CB  TYR A 427      28.459  44.204  21.004  1.00 72.28           C  
ATOM   3581  CG  TYR A 427      27.603  45.452  20.990  1.00 70.18           C  
ATOM   3582  CD1 TYR A 427      26.552  45.611  21.892  1.00 67.89           C  
ATOM   3583  CD2 TYR A 427      27.826  46.462  20.065  1.00 68.58           C  
ATOM   3584  CE1 TYR A 427      25.752  46.723  21.870  1.00 66.38           C  
ATOM   3585  CE2 TYR A 427      27.031  47.593  20.048  1.00 67.56           C  
ATOM   3586  CZ  TYR A 427      25.999  47.719  20.956  1.00 67.90           C  
ATOM   3587  OH  TYR A 427      25.212  48.841  20.953  1.00 68.15           O  
ATOM   3588  N   PRO A 428      28.904  41.372  18.869  1.00 79.28           N  
ATOM   3589  CA  PRO A 428      29.179  39.948  18.629  1.00 81.38           C  
ATOM   3590  C   PRO A 428      30.545  39.528  19.155  1.00 83.67           C  
ATOM   3591  O   PRO A 428      30.699  38.443  19.732  1.00 83.65           O  
ATOM   3592  CB  PRO A 428      29.132  39.839  17.097  1.00 81.61           C  
ATOM   3593  CG  PRO A 428      29.422  41.269  16.575  1.00 80.28           C  
ATOM   3594  CD  PRO A 428      28.970  42.209  17.643  1.00 79.22           C  
ATOM   3595  N   LYS A 429      31.516  40.410  18.960  1.00 86.45           N  
ATOM   3596  CA  LYS A 429      32.905  40.103  19.197  1.00 89.79           C  
ATOM   3597  C   LYS A 429      33.445  41.060  20.238  1.00 91.36           C  
ATOM   3598  O   LYS A 429      32.654  41.709  20.934  1.00 91.78           O  
ATOM   3599  CB  LYS A 429      33.694  40.206  17.879  1.00 89.97           C  
ATOM   3600  CG  LYS A 429      33.669  38.919  17.034  1.00 90.84           C  
ATOM   3601  CD  LYS A 429      34.046  39.172  15.572  1.00 90.48           C  
ATOM   3602  CE  LYS A 429      33.683  37.982  14.715  1.00 91.12           C  
ATOM   3603  NZ  LYS A 429      33.849  36.712  15.490  1.00 92.65           N  
ATOM   3604  N   VAL A 430      34.783  41.104  20.341  1.00 93.43           N  
ATOM   3605  CA  VAL A 430      35.569  42.062  21.149  1.00 95.08           C  
ATOM   3606  C   VAL A 430      36.976  41.511  21.445  1.00 95.93           C  
ATOM   3607  O   VAL A 430      37.179  40.299  21.380  1.00 95.96           O  
ATOM   3608  CB  VAL A 430      34.797  42.525  22.440  1.00 95.48           C  
ATOM   3609  CG1 VAL A 430      35.548  42.198  23.766  1.00 95.33           C  
ATOM   3610  CG2 VAL A 430      34.370  44.019  22.301  1.00 95.38           C  
ATOM   3611  N   ASP A 431      37.938  42.395  21.744  1.00 97.13           N  
ATOM   3612  CA  ASP A 431      39.292  41.972  22.178  1.00 98.27           C  
ATOM   3613  C   ASP A 431      39.238  40.804  23.173  1.00 98.67           C  
ATOM   3614  O   ASP A 431      38.576  40.896  24.229  1.00 98.66           O  
ATOM   3615  CB  ASP A 431      40.104  43.135  22.787  1.00 98.62           C  
ATOM   3616  CG  ASP A 431      40.931  43.920  21.743  1.00 99.47           C  
ATOM   3617  OD1 ASP A 431      41.583  43.307  20.862  1.00100.33           O  
ATOM   3618  OD2 ASP A 431      40.942  45.174  21.826  1.00100.04           O  
ATOM   3619  N   PRO A 432      39.940  39.702  22.840  1.00 98.99           N  
ATOM   3620  CA  PRO A 432      39.821  38.471  23.616  1.00 99.17           C  
ATOM   3621  C   PRO A 432      40.309  38.622  25.067  1.00 99.46           C  
ATOM   3622  O   PRO A 432      40.000  37.769  25.907  1.00 99.85           O  
ATOM   3623  CB  PRO A 432      40.680  37.470  22.826  1.00 99.09           C  
ATOM   3624  CG  PRO A 432      40.853  38.075  21.457  1.00 98.93           C  
ATOM   3625  CD  PRO A 432      40.886  39.550  21.718  1.00 99.02           C  
ATOM   3626  N   TYR A 433      41.050  39.695  25.353  1.00 99.51           N  
ATOM   3627  CA  TYR A 433      41.446  40.009  26.729  1.00 99.65           C  
ATOM   3628  C   TYR A 433      40.466  40.982  27.387  1.00 99.15           C  
ATOM   3629  O   TYR A 433      40.007  40.730  28.519  1.00 99.33           O  
ATOM   3630  CB  TYR A 433      42.848  40.620  26.823  1.00100.32           C  
ATOM   3631  CG  TYR A 433      43.629  40.739  25.534  1.00101.52           C  
ATOM   3632  CD1 TYR A 433      43.628  41.947  24.793  1.00102.06           C  
ATOM   3633  CD2 TYR A 433      44.398  39.670  25.067  1.00102.39           C  
ATOM   3634  CE1 TYR A 433      44.360  42.073  23.611  1.00101.28           C  
ATOM   3635  CE2 TYR A 433      45.135  39.788  23.884  1.00103.22           C  
ATOM   3636  CZ  TYR A 433      45.109  40.987  23.163  1.00101.72           C  
ATOM   3637  OH  TYR A 433      45.843  41.063  22.007  1.00101.44           O  
ATOM   3638  N   LYS A 434      40.164  42.085  26.684  1.00 98.09           N  
ATOM   3639  CA  LYS A 434      39.221  43.121  27.163  1.00 96.89           C  
ATOM   3640  C   LYS A 434      37.781  42.612  27.403  1.00 96.18           C  
ATOM   3641  O   LYS A 434      36.846  43.407  27.560  1.00 95.41           O  
ATOM   3642  CB  LYS A 434      39.225  44.323  26.216  1.00 96.85           C  
ATOM   3643  CG  LYS A 434      40.470  45.191  26.339  1.00 96.70           C  
ATOM   3644  CD  LYS A 434      40.503  46.309  25.296  1.00 96.66           C  
ATOM   3645  CE  LYS A 434      41.924  46.851  25.116  1.00 95.79           C  
ATOM   3646  NZ  LYS A 434      42.088  47.606  23.849  1.00 94.99           N  
ATOM   3647  N   SER A 435      37.644  41.282  27.468  1.00 95.48           N  
ATOM   3648  CA  SER A 435      36.361  40.577  27.583  1.00 94.78           C  
ATOM   3649  C   SER A 435      35.523  40.883  28.842  1.00 93.95           C  
ATOM   3650  O   SER A 435      35.572  40.149  29.837  1.00 94.05           O  
ATOM   3651  CB  SER A 435      36.550  39.053  27.390  1.00 94.99           C  
ATOM   3652  OG  SER A 435      37.690  38.545  28.076  1.00 95.56           O  
ATOM   3653  N   PHE A 436      34.778  41.992  28.777  1.00 92.76           N  
ATOM   3654  CA  PHE A 436      33.628  42.262  29.658  1.00 91.24           C  
ATOM   3655  C   PHE A 436      32.414  41.456  29.146  1.00 89.34           C  
ATOM   3656  O   PHE A 436      32.359  41.084  27.970  1.00 89.13           O  
ATOM   3657  CB  PHE A 436      33.269  43.765  29.625  1.00 91.79           C  
ATOM   3658  CG  PHE A 436      34.035  44.630  30.624  1.00 93.50           C  
ATOM   3659  CD1 PHE A 436      34.714  45.791  30.185  1.00 94.49           C  
ATOM   3660  CD2 PHE A 436      34.040  44.319  32.007  1.00 93.98           C  
ATOM   3661  CE1 PHE A 436      35.415  46.622  31.103  1.00 94.76           C  
ATOM   3662  CE2 PHE A 436      34.734  45.138  32.935  1.00 94.21           C  
ATOM   3663  CZ  PHE A 436      35.425  46.292  32.482  1.00 94.34           C  
ATOM   3664  N   LEU A 437      31.445  41.175  30.009  1.00 86.84           N  
ATOM   3665  CA  LEU A 437      30.117  40.833  29.507  1.00 84.43           C  
ATOM   3666  C   LEU A 437      29.207  42.050  29.704  1.00 82.70           C  
ATOM   3667  O   LEU A 437      29.111  42.589  30.814  1.00 82.98           O  
ATOM   3668  CB  LEU A 437      29.548  39.607  30.207  1.00 84.56           C  
ATOM   3669  CG  LEU A 437      30.101  38.206  29.925  1.00 85.16           C  
ATOM   3670  CD1 LEU A 437      29.400  37.148  30.797  1.00 85.02           C  
ATOM   3671  CD2 LEU A 437      29.980  37.840  28.444  1.00 85.67           C  
ATOM   3672  N   LEU A 438      28.560  42.502  28.633  1.00 80.00           N  
ATOM   3673  CA  LEU A 438      27.774  43.732  28.690  1.00 76.93           C  
ATOM   3674  C   LEU A 438      26.673  43.643  29.740  1.00 75.36           C  
ATOM   3675  O   LEU A 438      26.532  44.538  30.564  1.00 74.78           O  
ATOM   3676  CB  LEU A 438      27.214  44.113  27.307  1.00 76.86           C  
ATOM   3677  CG  LEU A 438      26.923  45.608  27.127  1.00 76.24           C  
ATOM   3678  CD1 LEU A 438      28.092  46.443  27.617  1.00 76.32           C  
ATOM   3679  CD2 LEU A 438      26.582  45.995  25.697  1.00 76.18           C  
ATOM   3680  N   TYR A 439      25.923  42.544  29.718  1.00 73.59           N  
ATOM   3681  CA  TYR A 439      24.841  42.303  30.664  1.00 72.17           C  
ATOM   3682  C   TYR A 439      25.417  42.330  32.067  1.00 71.39           C  
ATOM   3683  O   TYR A 439      24.918  43.042  32.913  1.00 71.61           O  
ATOM   3684  CB  TYR A 439      24.175  40.979  30.328  1.00 72.35           C  
ATOM   3685  CG  TYR A 439      23.020  40.506  31.198  1.00 73.50           C  
ATOM   3686  CD1 TYR A 439      21.717  40.360  30.656  1.00 73.58           C  
ATOM   3687  CD2 TYR A 439      23.225  40.120  32.547  1.00 74.34           C  
ATOM   3688  CE1 TYR A 439      20.623  39.874  31.456  1.00 74.54           C  
ATOM   3689  CE2 TYR A 439      22.143  39.651  33.359  1.00 74.27           C  
ATOM   3690  CZ  TYR A 439      20.855  39.522  32.807  1.00 74.61           C  
ATOM   3691  OH  TYR A 439      19.826  39.061  33.600  1.00 74.07           O  
ATOM   3692  N   ASP A 440      26.497  41.595  32.294  1.00 70.35           N  
ATOM   3693  CA  ASP A 440      27.267  41.683  33.525  1.00 69.62           C  
ATOM   3694  C   ASP A 440      27.612  43.098  33.976  1.00 67.90           C  
ATOM   3695  O   ASP A 440      27.273  43.505  35.079  1.00 67.62           O  
ATOM   3696  CB  ASP A 440      28.551  40.893  33.360  1.00 70.78           C  
ATOM   3697  CG  ASP A 440      28.323  39.393  33.484  1.00 75.55           C  
ATOM   3698  OD1 ASP A 440      27.196  39.037  33.936  1.00 80.60           O  
ATOM   3699  OD2 ASP A 440      29.254  38.582  33.156  1.00 78.21           O  
ATOM   3700  N   PHE A 441      28.304  43.839  33.129  1.00 65.90           N  
ATOM   3701  CA  PHE A 441      28.654  45.199  33.450  1.00 64.38           C  
ATOM   3702  C   PHE A 441      27.442  45.985  33.997  1.00 63.82           C  
ATOM   3703  O   PHE A 441      27.504  46.541  35.100  1.00 63.34           O  
ATOM   3704  CB  PHE A 441      29.255  45.871  32.223  1.00 64.17           C  
ATOM   3705  CG  PHE A 441      29.468  47.336  32.387  1.00 63.87           C  
ATOM   3706  CD1 PHE A 441      30.585  47.820  33.062  1.00 64.88           C  
ATOM   3707  CD2 PHE A 441      28.556  48.244  31.870  1.00 63.13           C  
ATOM   3708  CE1 PHE A 441      30.794  49.214  33.218  1.00 65.47           C  
ATOM   3709  CE2 PHE A 441      28.749  49.632  32.016  1.00 64.15           C  
ATOM   3710  CZ  PHE A 441      29.869  50.121  32.695  1.00 64.11           C  
ATOM   3711  N   VAL A 442      26.350  46.004  33.219  1.00 62.97           N  
ATOM   3712  CA  VAL A 442      25.100  46.725  33.539  1.00 61.71           C  
ATOM   3713  C   VAL A 442      24.540  46.184  34.844  1.00 61.88           C  
ATOM   3714  O   VAL A 442      24.069  46.920  35.702  1.00 61.33           O  
ATOM   3715  CB  VAL A 442      24.054  46.587  32.380  1.00 61.09           C  
ATOM   3716  CG1 VAL A 442      22.752  47.187  32.723  1.00 59.83           C  
ATOM   3717  CG2 VAL A 442      24.530  47.254  31.165  1.00 59.94           C  
ATOM   3718  N   LYS A 443      24.626  44.873  34.981  1.00 62.52           N  
ATOM   3719  CA  LYS A 443      24.173  44.179  36.165  1.00 63.26           C  
ATOM   3720  C   LYS A 443      25.010  44.636  37.361  1.00 63.84           C  
ATOM   3721  O   LYS A 443      24.457  45.014  38.399  1.00 63.65           O  
ATOM   3722  CB  LYS A 443      24.297  42.679  35.928  1.00 62.82           C  
ATOM   3723  CG  LYS A 443      23.069  41.845  36.236  1.00 64.12           C  
ATOM   3724  CD  LYS A 443      21.766  42.619  36.474  1.00 65.33           C  
ATOM   3725  CE  LYS A 443      20.567  41.651  36.404  1.00 66.28           C  
ATOM   3726  NZ  LYS A 443      19.353  42.136  37.113  1.00 65.86           N  
ATOM   3727  N   ARG A 444      26.336  44.631  37.204  1.00 64.60           N  
ATOM   3728  CA  ARG A 444      27.222  45.113  38.264  1.00 65.33           C  
ATOM   3729  C   ARG A 444      26.889  46.551  38.667  1.00 64.79           C  
ATOM   3730  O   ARG A 444      26.555  46.803  39.825  1.00 65.41           O  
ATOM   3731  CB  ARG A 444      28.702  44.969  37.910  1.00 65.76           C  
ATOM   3732  CG  ARG A 444      29.170  43.532  37.835  1.00 69.99           C  
ATOM   3733  CD  ARG A 444      30.631  43.388  38.303  1.00 78.72           C  
ATOM   3734  NE  ARG A 444      31.470  42.806  37.229  1.00 86.05           N  
ATOM   3735  CZ  ARG A 444      32.043  43.539  36.233  1.00 89.02           C  
ATOM   3736  NH1 ARG A 444      31.878  44.897  36.187  1.00 89.02           N  
ATOM   3737  NH2 ARG A 444      32.792  42.927  35.286  1.00 90.45           N  
ATOM   3738  N   GLU A 445      26.938  47.485  37.718  1.00 63.76           N  
ATOM   3739  CA  GLU A 445      26.750  48.910  38.046  1.00 62.38           C  
ATOM   3740  C   GLU A 445      25.520  49.183  38.875  1.00 60.81           C  
ATOM   3741  O   GLU A 445      25.564  50.016  39.753  1.00 60.91           O  
ATOM   3742  CB  GLU A 445      26.748  49.812  36.791  1.00 62.77           C  
ATOM   3743  CG  GLU A 445      28.114  49.996  36.117  1.00 64.69           C  
ATOM   3744  CD  GLU A 445      29.274  49.668  37.054  1.00 68.60           C  
ATOM   3745  OE1 GLU A 445      29.572  50.493  37.933  1.00 71.42           O  
ATOM   3746  OE2 GLU A 445      29.876  48.573  36.934  1.00 70.59           O  
ATOM   3747  N   LEU A 446      24.433  48.472  38.597  1.00 59.55           N  
ATOM   3748  CA  LEU A 446      23.127  48.781  39.193  1.00 58.49           C  
ATOM   3749  C   LEU A 446      22.978  48.132  40.543  1.00 57.92           C  
ATOM   3750  O   LEU A 446      22.489  48.742  41.462  1.00 58.41           O  
ATOM   3751  CB  LEU A 446      21.960  48.364  38.282  1.00 58.23           C  
ATOM   3752  CG  LEU A 446      21.740  49.154  36.973  1.00 57.80           C  
ATOM   3753  CD1 LEU A 446      20.997  48.325  35.917  1.00 54.34           C  
ATOM   3754  CD2 LEU A 446      21.093  50.564  37.185  1.00 55.05           C  
ATOM   3755  N   LEU A 447      23.393  46.886  40.665  1.00 57.22           N  
ATOM   3756  CA  LEU A 447      23.456  46.268  41.963  1.00 56.34           C  
ATOM   3757  C   LEU A 447      24.219  47.155  42.927  1.00 56.27           C  
ATOM   3758  O   LEU A 447      23.713  47.444  44.010  1.00 56.66           O  
ATOM   3759  CB  LEU A 447      24.074  44.881  41.874  1.00 56.42           C  
ATOM   3760  CG  LEU A 447      23.097  43.802  41.407  1.00 55.02           C  
ATOM   3761  CD1 LEU A 447      23.855  42.499  41.221  1.00 52.41           C  
ATOM   3762  CD2 LEU A 447      21.945  43.658  42.427  1.00 52.46           C  
ATOM   3763  N   LYS A 448      25.408  47.618  42.525  1.00 55.93           N  
ATOM   3764  CA  LYS A 448      26.175  48.607  43.318  1.00 55.32           C  
ATOM   3765  C   LYS A 448      25.266  49.683  43.871  1.00 54.55           C  
ATOM   3766  O   LYS A 448      25.399  50.077  45.017  1.00 55.20           O  
ATOM   3767  CB  LYS A 448      27.295  49.255  42.506  1.00 54.83           C  
ATOM   3768  CG  LYS A 448      28.476  48.334  42.200  1.00 55.37           C  
ATOM   3769  CD  LYS A 448      29.541  49.084  41.395  1.00 56.58           C  
ATOM   3770  CE  LYS A 448      30.747  48.202  41.088  1.00 59.07           C  
ATOM   3771  NZ  LYS A 448      31.636  48.822  40.031  1.00 60.54           N  
ATOM   3772  N   LYS A 449      24.316  50.123  43.059  1.00 53.68           N  
ATOM   3773  CA  LYS A 449      23.383  51.180  43.430  1.00 52.76           C  
ATOM   3774  C   LYS A 449      22.189  50.707  44.269  1.00 52.19           C  
ATOM   3775  O   LYS A 449      21.401  51.516  44.721  1.00 51.96           O  
ATOM   3776  CB  LYS A 449      22.851  51.877  42.164  1.00 53.00           C  
ATOM   3777  CG  LYS A 449      23.879  52.602  41.289  1.00 52.39           C  
ATOM   3778  CD  LYS A 449      23.330  53.969  40.872  1.00 51.94           C  
ATOM   3779  CE  LYS A 449      24.437  54.835  40.287  1.00 52.71           C  
ATOM   3780  NZ  LYS A 449      24.607  56.144  40.974  1.00 48.33           N  
ATOM   3781  N   MET A 450      22.023  49.402  44.451  1.00 52.05           N  
ATOM   3782  CA  MET A 450      20.896  48.897  45.221  1.00 52.03           C  
ATOM   3783  C   MET A 450      19.544  49.053  44.506  1.00 51.90           C  
ATOM   3784  O   MET A 450      18.484  48.926  45.120  1.00 52.10           O  
ATOM   3785  CB  MET A 450      20.815  49.628  46.568  1.00 52.57           C  
ATOM   3786  CG  MET A 450      22.077  49.619  47.436  1.00 53.08           C  
ATOM   3787  SD  MET A 450      22.367  47.997  48.165  1.00 53.12           S  
ATOM   3788  CE  MET A 450      23.435  47.374  46.861  1.00 58.85           C  
ATOM   3789  N   ILE A 451      19.580  49.332  43.212  1.00 51.77           N  
ATOM   3790  CA  ILE A 451      18.380  49.523  42.410  1.00 51.19           C  
ATOM   3791  C   ILE A 451      18.059  48.227  41.669  1.00 51.50           C  
ATOM   3792  O   ILE A 451      18.894  47.699  40.929  1.00 50.80           O  
ATOM   3793  CB  ILE A 451      18.603  50.646  41.399  1.00 50.94           C  
ATOM   3794  CG1 ILE A 451      19.124  51.887  42.113  1.00 50.13           C  
ATOM   3795  CG2 ILE A 451      17.328  50.954  40.646  1.00 51.11           C  
ATOM   3796  CD1 ILE A 451      19.494  52.993  41.203  1.00 47.98           C  
ATOM   3797  N   PRO A 452      16.838  47.696  41.861  1.00 52.11           N  
ATOM   3798  CA  PRO A 452      16.481  46.456  41.145  1.00 52.09           C  
ATOM   3799  C   PRO A 452      16.616  46.722  39.651  1.00 51.72           C  
ATOM   3800  O   PRO A 452      16.331  47.823  39.224  1.00 52.44           O  
ATOM   3801  CB  PRO A 452      15.004  46.246  41.507  1.00 51.65           C  
ATOM   3802  CG  PRO A 452      14.828  46.997  42.791  1.00 52.54           C  
ATOM   3803  CD  PRO A 452      15.741  48.187  42.715  1.00 52.19           C  
ATOM   3804  N   SER A 453      17.027  45.741  38.859  1.00 50.77           N  
ATOM   3805  CA  SER A 453      17.056  45.955  37.421  1.00 49.24           C  
ATOM   3806  C   SER A 453      16.557  44.737  36.623  1.00 48.61           C  
ATOM   3807  O   SER A 453      16.653  43.616  37.067  1.00 48.40           O  
ATOM   3808  CB  SER A 453      18.468  46.329  37.008  1.00 48.98           C  
ATOM   3809  OG  SER A 453      19.362  45.287  37.361  1.00 48.40           O  
ATOM   3810  N   GLN A 454      16.009  44.972  35.442  1.00 47.89           N  
ATOM   3811  CA  GLN A 454      15.719  43.904  34.544  1.00 46.88           C  
ATOM   3812  C   GLN A 454      16.398  44.234  33.225  1.00 47.11           C  
ATOM   3813  O   GLN A 454      16.109  45.250  32.579  1.00 47.36           O  
ATOM   3814  CB  GLN A 454      14.245  43.795  34.341  1.00 46.95           C  
ATOM   3815  CG  GLN A 454      13.900  42.682  33.438  1.00 47.69           C  
ATOM   3816  CD  GLN A 454      13.914  41.434  34.195  1.00 50.93           C  
ATOM   3817  OE1 GLN A 454      13.597  41.435  35.385  1.00 52.74           O  
ATOM   3818  NE2 GLN A 454      14.273  40.335  33.542  1.00 52.17           N  
ATOM   3819  N   VAL A 455      17.311  43.358  32.842  1.00 46.72           N  
ATOM   3820  CA  VAL A 455      18.135  43.541  31.679  1.00 46.93           C  
ATOM   3821  C   VAL A 455      17.628  42.603  30.567  1.00 47.47           C  
ATOM   3822  O   VAL A 455      17.533  41.379  30.741  1.00 47.25           O  
ATOM   3823  CB  VAL A 455      19.631  43.297  32.042  1.00 46.60           C  
ATOM   3824  CG1 VAL A 455      20.529  43.442  30.846  1.00 46.50           C  
ATOM   3825  CG2 VAL A 455      20.065  44.286  33.044  1.00 46.40           C  
ATOM   3826  N   ILE A 456      17.269  43.182  29.434  1.00 47.59           N  
ATOM   3827  CA  ILE A 456      16.688  42.379  28.384  1.00 48.18           C  
ATOM   3828  C   ILE A 456      17.567  42.414  27.139  1.00 48.17           C  
ATOM   3829  O   ILE A 456      17.793  43.452  26.523  1.00 48.83           O  
ATOM   3830  CB  ILE A 456      15.175  42.719  28.147  1.00 47.98           C  
ATOM   3831  CG1 ILE A 456      14.363  42.222  29.332  1.00 50.44           C  
ATOM   3832  CG2 ILE A 456      14.618  41.929  27.021  1.00 47.23           C  
ATOM   3833  CD1 ILE A 456      13.156  43.068  29.703  1.00 51.15           C  
ATOM   3834  N   LEU A 457      18.097  41.258  26.812  1.00 48.14           N  
ATOM   3835  CA  LEU A 457      18.908  41.087  25.644  1.00 48.07           C  
ATOM   3836  C   LEU A 457      18.066  41.149  24.389  1.00 48.90           C  
ATOM   3837  O   LEU A 457      17.058  40.452  24.268  1.00 48.83           O  
ATOM   3838  CB  LEU A 457      19.564  39.715  25.708  1.00 47.86           C  
ATOM   3839  CG  LEU A 457      20.523  39.341  26.828  1.00 44.47           C  
ATOM   3840  CD1 LEU A 457      21.173  38.059  26.338  1.00 43.14           C  
ATOM   3841  CD2 LEU A 457      21.552  40.440  27.012  1.00 41.64           C  
ATOM   3842  N   ASN A 458      18.504  41.955  23.428  1.00 49.88           N  
ATOM   3843  CA  ASN A 458      17.841  41.983  22.146  1.00 50.57           C  
ATOM   3844  C   ASN A 458      17.780  40.628  21.429  1.00 50.95           C  
ATOM   3845  O   ASN A 458      16.815  40.362  20.708  1.00 50.21           O  
ATOM   3846  CB  ASN A 458      18.471  42.996  21.252  1.00 50.59           C  
ATOM   3847  CG  ASN A 458      17.450  43.766  20.512  1.00 54.31           C  
ATOM   3848  OD1 ASN A 458      17.066  43.424  19.393  1.00 56.71           O  
ATOM   3849  ND2 ASN A 458      16.946  44.812  21.151  1.00 59.10           N  
ATOM   3850  N   ARG A 459      18.790  39.769  21.619  1.00 51.79           N  
ATOM   3851  CA  ARG A 459      18.664  38.395  21.134  1.00 53.14           C  
ATOM   3852  C   ARG A 459      17.325  37.836  21.570  1.00 53.65           C  
ATOM   3853  O   ARG A 459      16.629  37.244  20.730  1.00 54.14           O  
ATOM   3854  CB  ARG A 459      19.723  37.451  21.677  1.00 53.41           C  
ATOM   3855  CG  ARG A 459      20.970  37.426  20.937  1.00 56.79           C  
ATOM   3856  CD  ARG A 459      21.793  36.208  21.337  1.00 62.59           C  
ATOM   3857  NE  ARG A 459      22.657  36.445  22.491  1.00 68.17           N  
ATOM   3858  CZ  ARG A 459      22.507  35.837  23.665  1.00 73.16           C  
ATOM   3859  NH1 ARG A 459      21.529  34.948  23.830  1.00 76.07           N  
ATOM   3860  NH2 ARG A 459      23.341  36.097  24.674  1.00 75.10           N  
ATOM   3861  N   THR A 460      16.969  38.013  22.858  1.00 53.27           N  
ATOM   3862  CA  THR A 460      15.796  37.358  23.395  1.00 53.76           C  
ATOM   3863  C   THR A 460      14.546  37.774  22.648  1.00 54.52           C  
ATOM   3864  O   THR A 460      13.737  36.932  22.280  1.00 54.84           O  
ATOM   3865  CB  THR A 460      15.579  37.665  24.859  1.00 54.39           C  
ATOM   3866  OG1 THR A 460      16.637  37.111  25.656  1.00 55.17           O  
ATOM   3867  CG2 THR A 460      14.248  37.085  25.329  1.00 53.74           C  
ATOM   3868  N   LEU A 461      14.390  39.071  22.404  1.00 55.23           N  
ATOM   3869  CA  LEU A 461      13.288  39.546  21.594  1.00 55.89           C  
ATOM   3870  C   LEU A 461      13.301  38.942  20.182  1.00 57.58           C  
ATOM   3871  O   LEU A 461      12.264  38.796  19.534  1.00 58.45           O  
ATOM   3872  CB  LEU A 461      13.297  41.065  21.540  1.00 55.15           C  
ATOM   3873  CG  LEU A 461      13.285  41.852  22.869  1.00 54.39           C  
ATOM   3874  CD1 LEU A 461      13.129  43.349  22.629  1.00 50.96           C  
ATOM   3875  CD2 LEU A 461      12.211  41.370  23.864  1.00 51.50           C  
ATOM   3876  N   LYS A 462      14.465  38.558  19.700  1.00 59.27           N  
ATOM   3877  CA  LYS A 462      14.550  38.125  18.328  1.00 61.25           C  
ATOM   3878  C   LYS A 462      14.312  36.643  18.142  1.00 62.35           C  
ATOM   3879  O   LYS A 462      13.779  36.223  17.131  1.00 62.52           O  
ATOM   3880  CB  LYS A 462      15.906  38.504  17.759  1.00 61.85           C  
ATOM   3881  CG  LYS A 462      15.953  39.878  17.133  1.00 62.04           C  
ATOM   3882  CD  LYS A 462      17.390  40.302  16.953  1.00 63.59           C  
ATOM   3883  CE  LYS A 462      17.434  41.492  16.044  1.00 65.84           C  
ATOM   3884  NZ  LYS A 462      18.603  42.358  16.325  1.00 69.57           N  
ATOM   3885  N   ASN A 463      14.719  35.859  19.124  1.00 63.81           N  
ATOM   3886  CA  ASN A 463      14.618  34.403  19.074  1.00 65.67           C  
ATOM   3887  C   ASN A 463      13.358  33.819  19.693  1.00 66.34           C  
ATOM   3888  O   ASN A 463      12.865  32.758  19.266  1.00 66.60           O  
ATOM   3889  CB  ASN A 463      15.817  33.824  19.801  1.00 65.66           C  
ATOM   3890  CG  ASN A 463      17.113  34.339  19.231  1.00 67.91           C  
ATOM   3891  OD1 ASN A 463      17.441  34.088  18.060  1.00 68.53           O  
ATOM   3892  ND2 ASN A 463      17.853  35.095  20.043  1.00 70.15           N  
ATOM   3893  N   GLU A 464      12.848  34.530  20.694  1.00 67.08           N  
ATOM   3894  CA  GLU A 464      11.883  33.998  21.619  1.00 67.76           C  
ATOM   3895  C   GLU A 464      10.534  34.662  21.519  1.00 67.82           C  
ATOM   3896  O   GLU A 464      10.422  35.849  21.192  1.00 67.74           O  
ATOM   3897  CB  GLU A 464      12.446  34.088  23.014  1.00 67.72           C  
ATOM   3898  CG  GLU A 464      13.628  33.201  23.164  1.00 72.42           C  
ATOM   3899  CD  GLU A 464      13.301  31.781  22.709  1.00 80.06           C  
ATOM   3900  OE1 GLU A 464      12.418  31.172  23.370  1.00 82.17           O  
ATOM   3901  OE2 GLU A 464      13.890  31.287  21.687  1.00 82.35           O  
ATOM   3902  N   ASN A 465       9.513  33.868  21.814  1.00 68.19           N  
ATOM   3903  CA  ASN A 465       8.128  34.240  21.565  1.00 68.90           C  
ATOM   3904  C   ASN A 465       7.706  35.268  22.585  1.00 68.41           C  
ATOM   3905  O   ASN A 465       8.021  35.133  23.763  1.00 68.29           O  
ATOM   3906  CB  ASN A 465       7.227  32.990  21.577  1.00 69.42           C  
ATOM   3907  CG  ASN A 465       7.789  31.847  20.653  1.00 73.07           C  
ATOM   3908  OD1 ASN A 465       7.574  31.850  19.417  1.00 73.46           O  
ATOM   3909  ND2 ASN A 465       8.544  30.885  21.265  1.00 74.39           N  
ATOM   3910  N   LEU A 466       7.026  36.313  22.125  1.00 67.99           N  
ATOM   3911  CA  LEU A 466       6.664  37.409  23.006  1.00 67.80           C  
ATOM   3912  C   LEU A 466       6.110  37.013  24.394  1.00 67.93           C  
ATOM   3913  O   LEU A 466       6.514  37.592  25.410  1.00 67.90           O  
ATOM   3914  CB  LEU A 466       5.727  38.381  22.296  1.00 67.78           C  
ATOM   3915  CG  LEU A 466       5.496  39.725  23.007  1.00 67.76           C  
ATOM   3916  CD1 LEU A 466       6.812  40.383  23.415  1.00 67.18           C  
ATOM   3917  CD2 LEU A 466       4.611  40.703  22.177  1.00 67.45           C  
ATOM   3918  N   LYS A 467       5.214  36.023  24.431  1.00 67.86           N  
ATOM   3919  CA  LYS A 467       4.535  35.614  25.668  1.00 67.81           C  
ATOM   3920  C   LYS A 467       5.439  34.879  26.624  1.00 67.38           C  
ATOM   3921  O   LYS A 467       5.365  35.052  27.835  1.00 67.49           O  
ATOM   3922  CB  LYS A 467       3.317  34.753  25.363  1.00 68.26           C  
ATOM   3923  CG  LYS A 467       2.280  35.461  24.517  1.00 70.50           C  
ATOM   3924  CD  LYS A 467       0.895  35.477  25.169  1.00 73.36           C  
ATOM   3925  CE  LYS A 467      -0.157  35.482  24.065  1.00 76.12           C  
ATOM   3926  NZ  LYS A 467      -0.027  34.261  23.155  1.00 75.24           N  
ATOM   3927  N   PHE A 468       6.289  34.040  26.069  1.00 67.37           N  
ATOM   3928  CA  PHE A 468       7.310  33.389  26.840  1.00 67.52           C  
ATOM   3929  C   PHE A 468       8.138  34.439  27.541  1.00 67.35           C  
ATOM   3930  O   PHE A 468       8.241  34.442  28.767  1.00 67.28           O  
ATOM   3931  CB  PHE A 468       8.191  32.545  25.945  1.00 67.91           C  
ATOM   3932  CG  PHE A 468       9.353  31.950  26.647  1.00 70.07           C  
ATOM   3933  CD1 PHE A 468       9.168  30.923  27.582  1.00 72.61           C  
ATOM   3934  CD2 PHE A 468      10.647  32.416  26.390  1.00 71.98           C  
ATOM   3935  CE1 PHE A 468      10.267  30.362  28.264  1.00 74.05           C  
ATOM   3936  CE2 PHE A 468      11.764  31.853  27.038  1.00 73.56           C  
ATOM   3937  CZ  PHE A 468      11.576  30.819  27.985  1.00 72.97           C  
ATOM   3938  N   VAL A 469       8.696  35.361  26.761  1.00 67.22           N  
ATOM   3939  CA  VAL A 469       9.540  36.410  27.328  1.00 66.42           C  
ATOM   3940  C   VAL A 469       8.768  37.290  28.281  1.00 66.46           C  
ATOM   3941  O   VAL A 469       9.288  37.672  29.331  1.00 66.47           O  
ATOM   3942  CB  VAL A 469      10.205  37.240  26.262  1.00 66.04           C  
ATOM   3943  CG1 VAL A 469      11.047  38.300  26.903  1.00 65.37           C  
ATOM   3944  CG2 VAL A 469      11.072  36.340  25.419  1.00 65.31           C  
ATOM   3945  N   LEU A 470       7.524  37.589  27.924  1.00 66.18           N  
ATOM   3946  CA  LEU A 470       6.661  38.350  28.804  1.00 66.15           C  
ATOM   3947  C   LEU A 470       6.553  37.729  30.183  1.00 65.96           C  
ATOM   3948  O   LEU A 470       6.701  38.416  31.191  1.00 66.18           O  
ATOM   3949  CB  LEU A 470       5.272  38.470  28.207  1.00 66.38           C  
ATOM   3950  CG  LEU A 470       4.285  39.342  28.991  1.00 67.68           C  
ATOM   3951  CD1 LEU A 470       4.634  40.843  28.922  1.00 66.87           C  
ATOM   3952  CD2 LEU A 470       2.867  39.046  28.477  1.00 69.68           C  
ATOM   3953  N   LEU A 471       6.286  36.435  30.230  1.00 65.49           N  
ATOM   3954  CA  LEU A 471       6.088  35.791  31.505  1.00 65.66           C  
ATOM   3955  C   LEU A 471       7.370  35.801  32.345  1.00 65.79           C  
ATOM   3956  O   LEU A 471       7.400  36.472  33.382  1.00 66.00           O  
ATOM   3957  CB  LEU A 471       5.469  34.398  31.325  1.00 66.09           C  
ATOM   3958  CG  LEU A 471       3.952  34.449  30.991  1.00 66.40           C  
ATOM   3959  CD1 LEU A 471       3.423  33.248  30.174  1.00 64.12           C  
ATOM   3960  CD2 LEU A 471       3.090  34.700  32.249  1.00 64.30           C  
ATOM   3961  N   ASN A 472       8.429  35.121  31.882  1.00 65.64           N  
ATOM   3962  CA  ASN A 472       9.742  35.100  32.556  1.00 65.55           C  
ATOM   3963  C   ASN A 472      10.059  36.396  33.331  1.00 65.41           C  
ATOM   3964  O   ASN A 472      10.456  36.347  34.507  1.00 65.86           O  
ATOM   3965  CB  ASN A 472      10.886  34.875  31.557  1.00 65.66           C  
ATOM   3966  CG  ASN A 472      10.756  33.576  30.740  1.00 68.39           C  
ATOM   3967  OD1 ASN A 472       9.700  32.944  30.668  1.00 72.29           O  
ATOM   3968  ND2 ASN A 472      11.850  33.190  30.098  1.00 68.86           N  
ATOM   3969  N   VAL A 473       9.865  37.534  32.655  1.00 64.33           N  
ATOM   3970  CA  VAL A 473      10.297  38.845  33.099  1.00 63.56           C  
ATOM   3971  C   VAL A 473       9.323  39.342  34.135  1.00 63.66           C  
ATOM   3972  O   VAL A 473       9.709  39.874  35.186  1.00 64.35           O  
ATOM   3973  CB  VAL A 473      10.293  39.862  31.910  1.00 63.77           C  
ATOM   3974  CG1 VAL A 473      10.568  41.290  32.369  1.00 62.33           C  
ATOM   3975  CG2 VAL A 473      11.289  39.467  30.838  1.00 63.88           C  
ATOM   3976  N   ALA A 474       8.043  39.190  33.826  1.00 63.03           N  
ATOM   3977  CA  ALA A 474       6.995  39.635  34.716  1.00 61.82           C  
ATOM   3978  C   ALA A 474       7.164  38.966  36.080  1.00 61.50           C  
ATOM   3979  O   ALA A 474       6.995  39.620  37.110  1.00 61.26           O  
ATOM   3980  CB  ALA A 474       5.665  39.316  34.127  1.00 61.51           C  
ATOM   3981  N   GLU A 475       7.531  37.683  36.097  1.00 60.86           N  
ATOM   3982  CA  GLU A 475       7.637  36.978  37.376  1.00 61.00           C  
ATOM   3983  C   GLU A 475       8.693  37.602  38.293  1.00 60.52           C  
ATOM   3984  O   GLU A 475       8.463  37.766  39.504  1.00 60.93           O  
ATOM   3985  CB  GLU A 475       7.886  35.480  37.200  1.00 60.97           C  
ATOM   3986  CG  GLU A 475       8.211  34.746  38.495  1.00 60.78           C  
ATOM   3987  CD  GLU A 475       8.449  33.255  38.288  1.00 62.14           C  
ATOM   3988  OE1 GLU A 475       8.706  32.815  37.139  1.00 63.24           O  
ATOM   3989  OE2 GLU A 475       8.364  32.507  39.279  1.00 63.26           O  
ATOM   3990  N   GLN A 476       9.825  37.982  37.699  1.00 59.34           N  
ATOM   3991  CA  GLN A 476      10.935  38.577  38.422  1.00 57.66           C  
ATOM   3992  C   GLN A 476      10.692  39.994  38.747  1.00 56.90           C  
ATOM   3993  O   GLN A 476      10.956  40.437  39.864  1.00 56.21           O  
ATOM   3994  CB  GLN A 476      12.131  38.585  37.543  1.00 57.61           C  
ATOM   3995  CG  GLN A 476      12.950  37.408  37.728  1.00 58.21           C  
ATOM   3996  CD  GLN A 476      13.864  37.293  36.600  1.00 60.11           C  
ATOM   3997  OE1 GLN A 476      14.311  38.305  36.034  1.00 60.12           O  
ATOM   3998  NE2 GLN A 476      14.149  36.060  36.218  1.00 61.91           N  
ATOM   3999  N   VAL A 477      10.235  40.722  37.737  1.00 56.60           N  
ATOM   4000  CA  VAL A 477      10.000  42.147  37.912  1.00 56.10           C  
ATOM   4001  C   VAL A 477       9.108  42.353  39.114  1.00 56.34           C  
ATOM   4002  O   VAL A 477       9.376  43.234  39.895  1.00 56.44           O  
ATOM   4003  CB  VAL A 477       9.429  42.846  36.658  1.00 55.58           C  
ATOM   4004  CG1 VAL A 477       9.077  44.285  36.994  1.00 52.91           C  
ATOM   4005  CG2 VAL A 477      10.442  42.791  35.523  1.00 53.74           C  
ATOM   4006  N   LEU A 478       8.092  41.507  39.279  1.00 56.71           N  
ATOM   4007  CA  LEU A 478       7.202  41.564  40.440  1.00 57.47           C  
ATOM   4008  C   LEU A 478       7.907  41.322  41.775  1.00 57.81           C  
ATOM   4009  O   LEU A 478       7.813  42.143  42.701  1.00 58.10           O  
ATOM   4010  CB  LEU A 478       6.071  40.561  40.277  1.00 57.86           C  
ATOM   4011  CG  LEU A 478       4.937  40.950  39.333  1.00 58.25           C  
ATOM   4012  CD1 LEU A 478       4.228  39.687  38.817  1.00 57.10           C  
ATOM   4013  CD2 LEU A 478       3.996  41.877  40.081  1.00 57.79           C  
ATOM   4014  N   ALA A 479       8.601  40.191  41.862  1.00 57.91           N  
ATOM   4015  CA  ALA A 479       9.425  39.863  43.006  1.00 57.96           C  
ATOM   4016  C   ALA A 479      10.328  41.028  43.373  1.00 58.50           C  
ATOM   4017  O   ALA A 479      10.155  41.634  44.442  1.00 59.02           O  
ATOM   4018  CB  ALA A 479      10.247  38.657  42.699  1.00 58.10           C  
ATOM   4019  N   LYS A 480      11.295  41.315  42.501  1.00 58.92           N  
ATOM   4020  CA  LYS A 480      12.155  42.496  42.586  1.00 59.87           C  
ATOM   4021  C   LYS A 480      11.498  43.729  43.220  1.00 60.50           C  
ATOM   4022  O   LYS A 480      12.101  44.422  44.039  1.00 61.18           O  
ATOM   4023  CB  LYS A 480      12.585  42.915  41.173  1.00 60.38           C  
ATOM   4024  CG  LYS A 480      13.797  42.231  40.626  1.00 60.71           C  
ATOM   4025  CD  LYS A 480      13.953  42.531  39.173  1.00 59.28           C  
ATOM   4026  CE  LYS A 480      14.340  41.253  38.509  1.00 60.80           C  
ATOM   4027  NZ  LYS A 480      15.119  41.400  37.272  1.00 63.49           N  
ATOM   4028  N   THR A 481      10.273  44.032  42.829  1.00 60.76           N  
ATOM   4029  CA  THR A 481       9.684  45.252  43.290  1.00 61.71           C  
ATOM   4030  C   THR A 481       8.944  45.142  44.627  1.00 61.76           C  
ATOM   4031  O   THR A 481       8.537  46.130  45.197  1.00 60.97           O  
ATOM   4032  CB  THR A 481       8.824  45.861  42.207  1.00 62.17           C  
ATOM   4033  OG1 THR A 481       9.662  46.174  41.085  1.00 62.13           O  
ATOM   4034  CG2 THR A 481       8.219  47.155  42.723  1.00 64.17           C  
ATOM   4035  N   GLY A 482       8.808  43.926  45.126  1.00 63.07           N  
ATOM   4036  CA  GLY A 482       8.208  43.675  46.429  1.00 64.08           C  
ATOM   4037  C   GLY A 482       6.763  43.258  46.266  1.00 64.71           C  
ATOM   4038  O   GLY A 482       5.902  43.560  47.103  1.00 65.27           O  
ATOM   4039  N   ASN A 483       6.470  42.592  45.166  1.00 64.81           N  
ATOM   4040  CA  ASN A 483       5.100  42.223  44.944  1.00 65.45           C  
ATOM   4041  C   ASN A 483       4.987  40.727  44.757  1.00 65.72           C  
ATOM   4042  O   ASN A 483       4.000  40.233  44.245  1.00 66.81           O  
ATOM   4043  CB  ASN A 483       4.479  43.024  43.790  1.00 65.32           C  
ATOM   4044  CG  ASN A 483       4.672  44.525  43.951  1.00 65.66           C  
ATOM   4045  OD1 ASN A 483       3.860  45.223  44.562  1.00 65.42           O  
ATOM   4046  ND2 ASN A 483       5.761  45.027  43.392  1.00 67.27           N  
ATOM   4047  N   ILE A 484       6.032  40.010  45.141  1.00 65.42           N  
ATOM   4048  CA  ILE A 484       5.917  38.594  45.432  1.00 64.80           C  
ATOM   4049  C   ILE A 484       4.609  38.062  44.852  1.00 64.62           C  
ATOM   4050  O   ILE A 484       3.566  38.144  45.502  1.00 65.28           O  
ATOM   4051  CB  ILE A 484       6.047  38.405  46.976  1.00 64.78           C  
ATOM   4052  CG1 ILE A 484       7.534  38.478  47.355  1.00 64.72           C  
ATOM   4053  CG2 ILE A 484       5.422  37.095  47.482  1.00 64.09           C  
ATOM   4054  CD1 ILE A 484       7.902  39.481  48.486  1.00 64.84           C  
ATOM   4055  N   PRO A 485       4.661  37.521  43.622  1.00 64.20           N  
ATOM   4056  CA  PRO A 485       3.526  37.058  42.815  1.00 64.19           C  
ATOM   4057  C   PRO A 485       2.956  35.744  43.339  1.00 64.54           C  
ATOM   4058  O   PRO A 485       2.105  35.123  42.676  1.00 64.54           O  
ATOM   4059  CB  PRO A 485       4.173  36.765  41.454  1.00 63.84           C  
ATOM   4060  CG  PRO A 485       5.526  36.315  41.802  1.00 63.24           C  
ATOM   4061  CD  PRO A 485       5.937  37.244  42.939  1.00 64.20           C  
ATOM   4062  N   TYR A 486       3.517  35.292  44.462  1.00 64.61           N  
ATOM   4063  CA  TYR A 486       3.082  34.119  45.197  1.00 64.77           C  
ATOM   4064  C   TYR A 486       3.988  33.888  46.391  1.00 65.46           C  
ATOM   4065  O   TYR A 486       5.152  34.309  46.383  1.00 65.59           O  
ATOM   4066  CB  TYR A 486       3.042  32.876  44.328  1.00 64.20           C  
ATOM   4067  CG  TYR A 486       4.294  32.593  43.554  1.00 63.84           C  
ATOM   4068  CD1 TYR A 486       5.362  31.902  44.126  1.00 65.24           C  
ATOM   4069  CD2 TYR A 486       4.386  32.943  42.232  1.00 63.37           C  
ATOM   4070  CE1 TYR A 486       6.502  31.605  43.384  1.00 63.87           C  
ATOM   4071  CE2 TYR A 486       5.506  32.660  41.497  1.00 63.77           C  
ATOM   4072  CZ  TYR A 486       6.555  32.004  42.075  1.00 63.17           C  
ATOM   4073  OH  TYR A 486       7.646  31.759  41.311  1.00 63.45           O  
ATOM   4074  N   LYS A 487       3.419  33.247  47.418  1.00 66.08           N  
ATOM   4075  CA  LYS A 487       4.116  32.867  48.651  1.00 66.17           C  
ATOM   4076  C   LYS A 487       4.119  31.332  48.726  1.00 66.60           C  
ATOM   4077  O   LYS A 487       3.372  30.650  48.011  1.00 66.54           O  
ATOM   4078  CB  LYS A 487       3.401  33.474  49.879  1.00 66.21           C  
ATOM   4079  CG  LYS A 487       3.469  35.027  49.994  1.00 66.23           C  
ATOM   4080  CD  LYS A 487       2.723  35.654  51.211  1.00 65.63           C  
ATOM   4081  CE  LYS A 487       3.236  37.094  51.513  1.00 66.95           C  
ATOM   4082  NZ  LYS A 487       2.241  38.218  51.912  1.00 66.19           N  
ATOM   4083  N   LEU A 488       4.974  30.775  49.569  1.00 67.26           N  
ATOM   4084  CA  LEU A 488       4.869  29.347  49.887  1.00 68.01           C  
ATOM   4085  C   LEU A 488       3.768  29.052  50.959  1.00 69.12           C  
ATOM   4086  O   LEU A 488       3.562  29.815  51.947  1.00 68.96           O  
ATOM   4087  CB  LEU A 488       6.219  28.813  50.366  1.00 67.36           C  
ATOM   4088  CG  LEU A 488       7.279  28.383  49.363  1.00 66.71           C  
ATOM   4089  CD1 LEU A 488       8.626  28.772  49.914  1.00 66.16           C  
ATOM   4090  CD2 LEU A 488       7.218  26.887  49.080  1.00 66.66           C  
ATOM   4091  N   LYS A 489       3.065  27.943  50.754  1.00 69.76           N  
ATOM   4092  CA  LYS A 489       2.122  27.454  51.734  1.00 70.54           C  
ATOM   4093  C   LYS A 489       2.885  27.138  53.002  1.00 70.85           C  
ATOM   4094  O   LYS A 489       2.531  27.595  54.094  1.00 70.93           O  
ATOM   4095  CB  LYS A 489       1.445  26.199  51.188  1.00 70.72           C  
ATOM   4096  CG  LYS A 489       0.126  25.854  51.846  1.00 72.73           C  
ATOM   4097  CD  LYS A 489      -0.678  24.870  51.000  1.00 75.18           C  
ATOM   4098  CE  LYS A 489      -2.005  24.533  51.673  1.00 77.58           C  
ATOM   4099  NZ  LYS A 489      -2.197  23.053  51.801  1.00 78.29           N  
ATOM   4100  N   GLU A 490       3.964  26.384  52.823  1.00 71.66           N  
ATOM   4101  CA  GLU A 490       4.725  25.780  53.917  1.00 73.02           C  
ATOM   4102  C   GLU A 490       6.078  25.216  53.463  1.00 72.90           C  
ATOM   4103  O   GLU A 490       6.268  24.845  52.304  1.00 72.85           O  
ATOM   4104  CB  GLU A 490       3.910  24.644  54.578  1.00 73.30           C  
ATOM   4105  CG  GLU A 490       3.163  23.726  53.558  1.00 73.69           C  
ATOM   4106  CD  GLU A 490       2.459  22.523  54.187  1.00 74.52           C  
ATOM   4107  OE1 GLU A 490       2.375  21.498  53.490  1.00 77.30           O  
ATOM   4108  OE2 GLU A 490       1.972  22.579  55.347  1.00 76.64           O  
ATOM   4109  N   ILE A 491       7.000  25.157  54.411  1.00 73.16           N  
ATOM   4110  CA  ILE A 491       8.246  24.456  54.269  1.00 73.70           C  
ATOM   4111  C   ILE A 491       8.268  23.457  55.415  1.00 74.01           C  
ATOM   4112  O   ILE A 491       7.899  23.797  56.536  1.00 74.49           O  
ATOM   4113  CB  ILE A 491       9.428  25.430  54.432  1.00 73.70           C  
ATOM   4114  CG1 ILE A 491       9.208  26.694  53.598  1.00 74.25           C  
ATOM   4115  CG2 ILE A 491      10.772  24.769  54.090  1.00 73.04           C  
ATOM   4116  CD1 ILE A 491      10.138  27.881  53.983  1.00 74.65           C  
ATOM   4117  N   GLU A 492       8.693  22.232  55.142  1.00 74.45           N  
ATOM   4118  CA  GLU A 492       8.839  21.219  56.170  1.00 75.77           C  
ATOM   4119  C   GLU A 492       9.723  21.568  57.344  1.00 75.77           C  
ATOM   4120  O   GLU A 492      10.788  22.165  57.190  1.00 75.83           O  
ATOM   4121  CB  GLU A 492       9.403  19.965  55.578  1.00 76.33           C  
ATOM   4122  CG  GLU A 492       8.363  19.113  54.983  1.00 80.63           C  
ATOM   4123  CD  GLU A 492       8.978  17.907  54.345  1.00 86.61           C  
ATOM   4124  OE1 GLU A 492       9.577  17.125  55.131  1.00 87.62           O  
ATOM   4125  OE2 GLU A 492       8.873  17.763  53.080  1.00 88.49           O  
ATOM   4126  N   GLY A 493       9.282  21.113  58.514  1.00 75.93           N  
ATOM   4127  CA  GLY A 493       9.929  21.406  59.791  1.00 76.14           C  
ATOM   4128  C   GLY A 493       9.159  22.496  60.515  1.00 76.25           C  
ATOM   4129  O   GLY A 493       8.131  22.990  60.031  1.00 76.15           O  
ATOM   4130  N   LYS A 494       9.653  22.892  61.671  1.00 76.07           N  
ATOM   4131  CA  LYS A 494       9.053  24.018  62.320  1.00 76.67           C  
ATOM   4132  C   LYS A 494      10.109  25.079  62.561  1.00 76.51           C  
ATOM   4133  O   LYS A 494      10.285  25.613  63.664  1.00 77.30           O  
ATOM   4134  CB  LYS A 494       8.284  23.579  63.568  1.00 77.38           C  
ATOM   4135  CG  LYS A 494       7.042  22.773  63.168  1.00 79.13           C  
ATOM   4136  CD  LYS A 494       6.487  21.961  64.304  1.00 81.70           C  
ATOM   4137  CE  LYS A 494       5.839  20.694  63.765  1.00 81.60           C  
ATOM   4138  NZ  LYS A 494       5.657  19.750  64.910  1.00 81.91           N  
ATOM   4139  N   VAL A 495      10.812  25.383  61.489  1.00 75.77           N  
ATOM   4140  CA  VAL A 495      11.749  26.470  61.489  1.00 74.99           C  
ATOM   4141  C   VAL A 495      10.984  27.767  61.621  1.00 74.63           C  
ATOM   4142  O   VAL A 495       9.856  27.882  61.138  1.00 74.56           O  
ATOM   4143  CB  VAL A 495      12.485  26.484  60.198  1.00 74.62           C  
ATOM   4144  CG1 VAL A 495      13.618  27.443  60.279  1.00 74.82           C  
ATOM   4145  CG2 VAL A 495      13.003  25.114  59.950  1.00 75.45           C  
ATOM   4146  N   ASP A 496      11.605  28.737  62.283  1.00 74.13           N  
ATOM   4147  CA  ASP A 496      11.003  30.062  62.466  1.00 73.35           C  
ATOM   4148  C   ASP A 496      11.720  31.157  61.701  1.00 72.12           C  
ATOM   4149  O   ASP A 496      11.131  32.213  61.460  1.00 71.81           O  
ATOM   4150  CB  ASP A 496      10.919  30.413  63.952  1.00 73.62           C  
ATOM   4151  CG  ASP A 496      10.049  29.434  64.731  1.00 75.11           C  
ATOM   4152  OD1 ASP A 496       9.211  28.711  64.111  1.00 74.99           O  
ATOM   4153  OD2 ASP A 496      10.212  29.396  65.974  1.00 77.57           O  
ATOM   4154  N   ALA A 497      12.984  30.894  61.345  1.00 70.87           N  
ATOM   4155  CA  ALA A 497      13.784  31.754  60.456  1.00 70.04           C  
ATOM   4156  C   ALA A 497      14.781  30.976  59.597  1.00 69.54           C  
ATOM   4157  O   ALA A 497      15.288  29.924  59.991  1.00 69.87           O  
ATOM   4158  CB  ALA A 497      14.513  32.818  61.242  1.00 69.98           C  
ATOM   4159  N   PHE A 498      15.070  31.504  58.414  1.00 68.66           N  
ATOM   4160  CA  PHE A 498      16.066  30.913  57.533  1.00 66.79           C  
ATOM   4161  C   PHE A 498      17.034  31.994  57.222  1.00 65.95           C  
ATOM   4162  O   PHE A 498      16.664  33.022  56.678  1.00 66.07           O  
ATOM   4163  CB  PHE A 498      15.434  30.414  56.256  1.00 66.23           C  
ATOM   4164  CG  PHE A 498      14.682  29.130  56.426  1.00 66.75           C  
ATOM   4165  CD1 PHE A 498      13.288  29.134  56.584  1.00 66.92           C  
ATOM   4166  CD2 PHE A 498      15.351  27.914  56.433  1.00 65.38           C  
ATOM   4167  CE1 PHE A 498      12.581  27.955  56.747  1.00 64.30           C  
ATOM   4168  CE2 PHE A 498      14.649  26.740  56.595  1.00 64.55           C  
ATOM   4169  CZ  PHE A 498      13.254  26.767  56.750  1.00 64.37           C  
ATOM   4170  N   VAL A 499      18.278  31.762  57.596  1.00 65.11           N  
ATOM   4171  CA  VAL A 499      19.307  32.766  57.478  1.00 64.26           C  
ATOM   4172  C   VAL A 499      20.413  32.421  56.475  1.00 64.24           C  
ATOM   4173  O   VAL A 499      21.189  31.475  56.677  1.00 64.57           O  
ATOM   4174  CB  VAL A 499      19.907  33.022  58.831  1.00 63.63           C  
ATOM   4175  CG1 VAL A 499      20.933  34.102  58.739  1.00 63.85           C  
ATOM   4176  CG2 VAL A 499      18.831  33.439  59.734  1.00 63.21           C  
ATOM   4177  N   GLY A 500      20.485  33.196  55.399  1.00 63.65           N  
ATOM   4178  CA  GLY A 500      21.607  33.091  54.491  1.00 63.78           C  
ATOM   4179  C   GLY A 500      22.773  33.908  54.993  1.00 64.06           C  
ATOM   4180  O   GLY A 500      22.601  35.046  55.416  1.00 64.66           O  
ATOM   4181  N   ILE A 501      23.970  33.338  54.939  1.00 64.12           N  
ATOM   4182  CA  ILE A 501      25.165  34.028  55.416  1.00 64.24           C  
ATOM   4183  C   ILE A 501      26.240  34.048  54.345  1.00 64.43           C  
ATOM   4184  O   ILE A 501      26.618  32.984  53.846  1.00 64.47           O  
ATOM   4185  CB  ILE A 501      25.617  33.397  56.772  1.00 64.21           C  
ATOM   4186  CG1 ILE A 501      25.413  34.416  57.864  1.00 64.61           C  
ATOM   4187  CG2 ILE A 501      27.044  32.876  56.797  1.00 63.72           C  
ATOM   4188  CD1 ILE A 501      24.615  33.857  58.999  1.00 66.45           C  
ATOM   4189  N   ASP A 502      26.691  35.241  53.959  1.00 64.60           N  
ATOM   4190  CA  ASP A 502      27.848  35.343  53.084  1.00 65.71           C  
ATOM   4191  C   ASP A 502      28.841  36.398  53.492  1.00 66.12           C  
ATOM   4192  O   ASP A 502      28.458  37.498  53.869  1.00 66.79           O  
ATOM   4193  CB  ASP A 502      27.440  35.590  51.637  1.00 66.39           C  
ATOM   4194  CG  ASP A 502      28.488  35.063  50.629  1.00 68.82           C  
ATOM   4195  OD1 ASP A 502      28.637  33.795  50.493  1.00 69.81           O  
ATOM   4196  OD2 ASP A 502      29.149  35.919  49.976  1.00 70.27           O  
ATOM   4197  N   ILE A 503      30.126  36.067  53.383  1.00 66.90           N  
ATOM   4198  CA  ILE A 503      31.218  36.976  53.748  1.00 67.37           C  
ATOM   4199  C   ILE A 503      32.421  36.870  52.788  1.00 67.96           C  
ATOM   4200  O   ILE A 503      32.902  35.784  52.511  1.00 68.44           O  
ATOM   4201  CB  ILE A 503      31.678  36.725  55.197  1.00 66.96           C  
ATOM   4202  CG1 ILE A 503      30.457  36.683  56.132  1.00 67.44           C  
ATOM   4203  CG2 ILE A 503      32.635  37.837  55.619  1.00 67.82           C  
ATOM   4204  CD1 ILE A 503      30.586  35.899  57.449  1.00 67.16           C  
ATOM   4205  N   SER A 504      32.890  37.993  52.266  1.00 68.83           N  
ATOM   4206  CA  SER A 504      34.145  38.023  51.521  1.00 70.23           C  
ATOM   4207  C   SER A 504      35.096  38.999  52.181  1.00 71.16           C  
ATOM   4208  O   SER A 504      34.665  39.955  52.823  1.00 71.45           O  
ATOM   4209  CB  SER A 504      33.924  38.471  50.077  1.00 70.27           C  
ATOM   4210  OG  SER A 504      32.820  37.828  49.475  1.00 71.77           O  
ATOM   4211  N   ARG A 505      36.390  38.793  52.004  1.00 72.48           N  
ATOM   4212  CA  ARG A 505      37.371  39.690  52.625  1.00 73.91           C  
ATOM   4213  C   ARG A 505      38.577  39.974  51.714  1.00 74.94           C  
ATOM   4214  O   ARG A 505      39.236  39.057  51.242  1.00 75.65           O  
ATOM   4215  CB  ARG A 505      37.822  39.100  53.970  1.00 73.66           C  
ATOM   4216  CG  ARG A 505      38.033  37.577  53.923  1.00 73.98           C  
ATOM   4217  CD  ARG A 505      38.364  36.988  55.282  1.00 73.74           C  
ATOM   4218  NE  ARG A 505      37.229  36.290  55.895  1.00 72.90           N  
ATOM   4219  CZ  ARG A 505      37.151  35.999  57.193  1.00 72.90           C  
ATOM   4220  NH1 ARG A 505      38.139  36.352  58.022  1.00 73.39           N  
ATOM   4221  NH2 ARG A 505      36.087  35.370  57.671  1.00 72.14           N  
ATOM   4222  N   ILE A 506      38.861  41.236  51.448  1.00 76.05           N  
ATOM   4223  CA  ILE A 506      40.128  41.579  50.800  1.00 77.58           C  
ATOM   4224  C   ILE A 506      41.318  41.237  51.731  1.00 78.74           C  
ATOM   4225  O   ILE A 506      41.158  41.169  52.957  1.00 79.04           O  
ATOM   4226  CB  ILE A 506      40.143  43.056  50.331  1.00 77.37           C  
ATOM   4227  CG1 ILE A 506      39.386  43.171  48.999  1.00 77.19           C  
ATOM   4228  CG2 ILE A 506      41.570  43.575  50.199  1.00 76.88           C  
ATOM   4229  CD1 ILE A 506      38.808  44.543  48.704  1.00 75.24           C  
ATOM   4230  N   THR A 507      42.496  41.001  51.148  1.00 79.82           N  
ATOM   4231  CA  THR A 507      43.659  40.557  51.923  1.00 80.93           C  
ATOM   4232  C   THR A 507      44.989  41.193  51.453  1.00 82.06           C  
ATOM   4233  O   THR A 507      45.194  41.422  50.261  1.00 82.51           O  
ATOM   4234  CB  THR A 507      43.730  39.014  51.920  1.00 80.79           C  
ATOM   4235  OG1 THR A 507      42.440  38.493  52.261  1.00 80.30           O  
ATOM   4236  CG2 THR A 507      44.760  38.482  52.912  1.00 80.35           C  
ATOM   4237  N   ARG A 508      45.864  41.508  52.409  1.00 83.08           N  
ATOM   4238  CA  ARG A 508      47.224  41.995  52.144  1.00 84.01           C  
ATOM   4239  C   ARG A 508      48.199  41.208  53.028  1.00 84.20           C  
ATOM   4240  O   ARG A 508      47.812  40.736  54.110  1.00 83.97           O  
ATOM   4241  CB  ARG A 508      47.353  43.489  52.465  1.00 84.04           C  
ATOM   4242  CG  ARG A 508      46.638  44.453  51.535  1.00 84.76           C  
ATOM   4243  CD  ARG A 508      47.199  45.876  51.728  1.00 85.02           C  
ATOM   4244  NE  ARG A 508      46.140  46.890  51.773  1.00 87.72           N  
ATOM   4245  CZ  ARG A 508      46.306  48.189  51.516  1.00 88.50           C  
ATOM   4246  NH1 ARG A 508      47.502  48.666  51.177  1.00 88.85           N  
ATOM   4247  NH2 ARG A 508      45.264  49.017  51.593  1.00 88.69           N  
ATOM   4248  N   ASP A 509      49.459  41.102  52.584  1.00 84.67           N  
ATOM   4249  CA  ASP A 509      50.494  40.246  53.213  1.00 85.18           C  
ATOM   4250  C   ASP A 509      49.922  38.860  53.432  1.00 85.45           C  
ATOM   4251  O   ASP A 509      50.126  37.972  52.605  1.00 85.69           O  
ATOM   4252  CB  ASP A 509      51.022  40.794  54.556  1.00 85.36           C  
ATOM   4253  CG  ASP A 509      51.000  42.322  54.645  1.00 85.55           C  
ATOM   4254  OD1 ASP A 509      51.211  42.996  53.611  1.00 85.47           O  
ATOM   4255  OD2 ASP A 509      50.776  42.846  55.765  1.00 85.69           O  
ATOM   4256  N   GLY A 510      49.207  38.695  54.550  1.00 85.64           N  
ATOM   4257  CA  GLY A 510      48.406  37.495  54.844  1.00 85.71           C  
ATOM   4258  C   GLY A 510      47.386  37.797  55.935  1.00 85.74           C  
ATOM   4259  O   GLY A 510      47.157  36.972  56.828  1.00 85.75           O  
ATOM   4260  N   LYS A 511      46.772  38.984  55.845  1.00 85.59           N  
ATOM   4261  CA  LYS A 511      45.891  39.545  56.894  1.00 85.27           C  
ATOM   4262  C   LYS A 511      44.530  40.084  56.347  1.00 85.19           C  
ATOM   4263  O   LYS A 511      44.488  40.735  55.295  1.00 85.51           O  
ATOM   4264  CB  LYS A 511      46.645  40.647  57.668  1.00 84.97           C  
ATOM   4265  CG  LYS A 511      48.061  40.252  58.083  1.00 84.72           C  
ATOM   4266  CD  LYS A 511      48.759  41.340  58.867  1.00 84.91           C  
ATOM   4267  CE  LYS A 511      50.045  40.826  59.507  1.00 84.41           C  
ATOM   4268  NZ  LYS A 511      50.336  41.516  60.797  1.00 83.31           N  
ATOM   4269  N   THR A 512      43.428  39.802  57.052  1.00 84.46           N  
ATOM   4270  CA  THR A 512      42.103  40.345  56.704  1.00 83.57           C  
ATOM   4271  C   THR A 512      42.083  41.876  56.809  1.00 82.70           C  
ATOM   4272  O   THR A 512      42.273  42.428  57.907  1.00 82.86           O  
ATOM   4273  CB  THR A 512      41.002  39.737  57.609  1.00 83.87           C  
ATOM   4274  OG1 THR A 512      40.563  38.482  57.062  1.00 84.34           O  
ATOM   4275  CG2 THR A 512      39.808  40.691  57.746  1.00 84.08           C  
ATOM   4276  N   VAL A 513      41.858  42.556  55.679  1.00 81.37           N  
ATOM   4277  CA  VAL A 513      41.866  44.045  55.644  1.00 79.93           C  
ATOM   4278  C   VAL A 513      40.444  44.676  55.579  1.00 78.60           C  
ATOM   4279  O   VAL A 513      39.941  45.178  56.582  1.00 78.76           O  
ATOM   4280  CB  VAL A 513      42.842  44.632  54.532  1.00 80.14           C  
ATOM   4281  CG1 VAL A 513      42.877  46.170  54.564  1.00 80.30           C  
ATOM   4282  CG2 VAL A 513      44.260  44.089  54.682  1.00 79.58           C  
ATOM   4283  N   ASN A 514      39.828  44.672  54.396  1.00 76.65           N  
ATOM   4284  CA  ASN A 514      38.449  45.096  54.199  1.00 74.33           C  
ATOM   4285  C   ASN A 514      37.656  43.807  54.370  1.00 72.76           C  
ATOM   4286  O   ASN A 514      38.255  42.733  54.397  1.00 72.65           O  
ATOM   4287  CB  ASN A 514      38.326  45.676  52.776  1.00 74.48           C  
ATOM   4288  CG  ASN A 514      36.947  46.296  52.470  1.00 75.28           C  
ATOM   4289  OD1 ASN A 514      36.056  46.356  53.325  1.00 77.33           O  
ATOM   4290  ND2 ASN A 514      36.780  46.767  51.233  1.00 74.68           N  
ATOM   4291  N   ALA A 515      36.338  43.894  54.519  1.00 70.93           N  
ATOM   4292  CA  ALA A 515      35.448  42.716  54.508  1.00 69.24           C  
ATOM   4293  C   ALA A 515      34.010  43.161  54.344  1.00 68.40           C  
ATOM   4294  O   ALA A 515      33.592  44.112  55.002  1.00 68.42           O  
ATOM   4295  CB  ALA A 515      35.583  41.908  55.786  1.00 69.15           C  
ATOM   4296  N   VAL A 516      33.258  42.482  53.467  1.00 67.36           N  
ATOM   4297  CA  VAL A 516      31.819  42.756  53.269  1.00 66.02           C  
ATOM   4298  C   VAL A 516      30.957  41.508  53.577  1.00 65.29           C  
ATOM   4299  O   VAL A 516      31.210  40.417  53.055  1.00 64.26           O  
ATOM   4300  CB  VAL A 516      31.478  43.345  51.838  1.00 66.08           C  
ATOM   4301  CG1 VAL A 516      30.099  43.974  51.831  1.00 65.39           C  
ATOM   4302  CG2 VAL A 516      32.489  44.389  51.386  1.00 65.61           C  
ATOM   4303  N   ALA A 517      29.951  41.702  54.438  1.00 64.71           N  
ATOM   4304  CA  ALA A 517      29.033  40.635  54.888  1.00 64.18           C  
ATOM   4305  C   ALA A 517      27.666  40.872  54.330  1.00 63.69           C  
ATOM   4306  O   ALA A 517      27.249  42.031  54.189  1.00 64.06           O  
ATOM   4307  CB  ALA A 517      28.933  40.605  56.404  1.00 64.26           C  
ATOM   4308  N   PHE A 518      26.953  39.783  54.056  1.00 62.46           N  
ATOM   4309  CA  PHE A 518      25.653  39.890  53.458  1.00 61.59           C  
ATOM   4310  C   PHE A 518      24.767  38.800  53.958  1.00 60.97           C  
ATOM   4311  O   PHE A 518      24.992  37.631  53.681  1.00 61.57           O  
ATOM   4312  CB  PHE A 518      25.787  39.799  51.954  1.00 61.84           C  
ATOM   4313  CG  PHE A 518      24.510  40.066  51.210  1.00 62.80           C  
ATOM   4314  CD1 PHE A 518      23.651  41.081  51.606  1.00 62.72           C  
ATOM   4315  CD2 PHE A 518      24.181  39.313  50.082  1.00 63.66           C  
ATOM   4316  CE1 PHE A 518      22.470  41.328  50.909  1.00 62.28           C  
ATOM   4317  CE2 PHE A 518      23.006  39.561  49.372  1.00 64.19           C  
ATOM   4318  CZ  PHE A 518      22.150  40.583  49.788  1.00 62.34           C  
ATOM   4319  N   THR A 519      23.733  39.197  54.670  1.00 60.16           N  
ATOM   4320  CA  THR A 519      22.919  38.271  55.428  1.00 59.90           C  
ATOM   4321  C   THR A 519      21.470  38.492  55.004  1.00 59.64           C  
ATOM   4322  O   THR A 519      21.064  39.627  54.818  1.00 59.95           O  
ATOM   4323  CB  THR A 519      23.107  38.533  56.995  1.00 60.32           C  
ATOM   4324  OG1 THR A 519      24.501  38.575  57.350  1.00 59.10           O  
ATOM   4325  CG2 THR A 519      22.394  37.488  57.855  1.00 59.75           C  
ATOM   4326  N   LYS A 520      20.675  37.442  54.842  1.00 59.39           N  
ATOM   4327  CA  LYS A 520      19.284  37.664  54.449  1.00 59.29           C  
ATOM   4328  C   LYS A 520      18.398  36.741  55.213  1.00 59.59           C  
ATOM   4329  O   LYS A 520      18.515  35.528  55.061  1.00 59.70           O  
ATOM   4330  CB  LYS A 520      19.025  37.367  52.972  1.00 59.59           C  
ATOM   4331  CG  LYS A 520      20.058  37.786  51.953  1.00 59.25           C  
ATOM   4332  CD  LYS A 520      19.614  37.263  50.635  1.00 59.13           C  
ATOM   4333  CE  LYS A 520      20.763  36.754  49.841  1.00 62.38           C  
ATOM   4334  NZ  LYS A 520      20.291  35.815  48.764  1.00 64.95           N  
ATOM   4335  N   ILE A 521      17.464  37.328  55.962  1.00 59.73           N  
ATOM   4336  CA  ILE A 521      16.580  36.606  56.875  1.00 59.61           C  
ATOM   4337  C   ILE A 521      15.171  36.424  56.289  1.00 60.19           C  
ATOM   4338  O   ILE A 521      14.517  37.391  55.874  1.00 59.58           O  
ATOM   4339  CB  ILE A 521      16.530  37.322  58.251  1.00 59.22           C  
ATOM   4340  CG1 ILE A 521      17.910  37.280  58.899  1.00 58.44           C  
ATOM   4341  CG2 ILE A 521      15.481  36.703  59.166  1.00 58.98           C  
ATOM   4342  CD1 ILE A 521      18.235  38.404  59.840  1.00 54.96           C  
ATOM   4343  N   PHE A 522      14.734  35.168  56.259  1.00 61.11           N  
ATOM   4344  CA  PHE A 522      13.413  34.786  55.765  1.00 62.28           C  
ATOM   4345  C   PHE A 522      12.559  34.197  56.864  1.00 63.44           C  
ATOM   4346  O   PHE A 522      13.068  33.467  57.737  1.00 63.62           O  
ATOM   4347  CB  PHE A 522      13.539  33.690  54.734  1.00 61.70           C  
ATOM   4348  CG  PHE A 522      14.149  34.126  53.451  1.00 62.21           C  
ATOM   4349  CD1 PHE A 522      15.524  34.261  53.329  1.00 62.56           C  
ATOM   4350  CD2 PHE A 522      13.348  34.380  52.344  1.00 61.67           C  
ATOM   4351  CE1 PHE A 522      16.080  34.652  52.130  1.00 61.69           C  
ATOM   4352  CE2 PHE A 522      13.901  34.753  51.147  1.00 60.04           C  
ATOM   4353  CZ  PHE A 522      15.256  34.886  51.032  1.00 60.58           C  
ATOM   4354  N   ASN A 523      11.253  34.464  56.791  1.00 64.42           N  
ATOM   4355  CA  ASN A 523      10.295  33.863  57.735  1.00 65.04           C  
ATOM   4356  C   ASN A 523      10.053  32.351  57.488  1.00 65.44           C  
ATOM   4357  O   ASN A 523      10.618  31.759  56.570  1.00 65.67           O  
ATOM   4358  CB  ASN A 523       8.984  34.685  57.813  1.00 64.91           C  
ATOM   4359  CG  ASN A 523       8.045  34.467  56.608  1.00 64.91           C  
ATOM   4360  OD1 ASN A 523       8.203  33.510  55.827  1.00 65.77           O  
ATOM   4361  ND2 ASN A 523       7.049  35.358  56.468  1.00 61.20           N  
ATOM   4362  N   SER A 524       9.211  31.741  58.312  1.00 65.77           N  
ATOM   4363  CA  SER A 524       9.015  30.305  58.295  1.00 66.12           C  
ATOM   4364  C   SER A 524       8.336  29.849  57.016  1.00 66.39           C  
ATOM   4365  O   SER A 524       8.413  28.672  56.663  1.00 66.75           O  
ATOM   4366  CB  SER A 524       8.174  29.879  59.490  1.00 66.20           C  
ATOM   4367  OG  SER A 524       6.788  29.917  59.166  1.00 66.91           O  
ATOM   4368  N   LYS A 525       7.645  30.774  56.356  1.00 66.21           N  
ATOM   4369  CA  LYS A 525       7.040  30.519  55.062  1.00 66.61           C  
ATOM   4370  C   LYS A 525       8.060  30.838  53.984  1.00 65.60           C  
ATOM   4371  O   LYS A 525       7.851  30.535  52.805  1.00 65.55           O  
ATOM   4372  CB  LYS A 525       5.860  31.457  54.843  1.00 66.82           C  
ATOM   4373  CG  LYS A 525       4.465  30.928  55.148  1.00 68.98           C  
ATOM   4374  CD  LYS A 525       3.409  31.989  54.691  1.00 68.79           C  
ATOM   4375  CE  LYS A 525       1.997  31.622  55.129  1.00 72.41           C  
ATOM   4376  NZ  LYS A 525       1.843  31.831  56.607  1.00 75.35           N  
ATOM   4377  N   GLY A 526       9.137  31.511  54.376  1.00 64.81           N  
ATOM   4378  CA  GLY A 526      10.151  31.928  53.411  1.00 64.09           C  
ATOM   4379  C   GLY A 526       9.873  33.193  52.599  1.00 63.48           C  
ATOM   4380  O   GLY A 526      10.414  33.337  51.491  1.00 62.50           O  
ATOM   4381  N   GLU A 527       9.013  34.081  53.128  1.00 62.65           N  
ATOM   4382  CA  GLU A 527       8.983  35.474  52.707  1.00 62.13           C  
ATOM   4383  C   GLU A 527      10.245  36.016  53.318  1.00 61.43           C  
ATOM   4384  O   GLU A 527      10.671  35.531  54.372  1.00 61.58           O  
ATOM   4385  CB  GLU A 527       7.815  36.254  53.305  1.00 62.40           C  
ATOM   4386  CG  GLU A 527       6.413  35.822  52.904  1.00 65.08           C  
ATOM   4387  CD  GLU A 527       5.373  36.041  54.027  1.00 68.78           C  
ATOM   4388  OE1 GLU A 527       4.933  37.185  54.252  1.00 68.79           O  
ATOM   4389  OE2 GLU A 527       4.990  35.054  54.699  1.00 70.82           O  
ATOM   4390  N   LEU A 528      10.855  36.996  52.649  1.00 60.59           N  
ATOM   4391  CA  LEU A 528      12.043  37.696  53.153  1.00 59.38           C  
ATOM   4392  C   LEU A 528      11.585  38.777  54.112  1.00 59.39           C  
ATOM   4393  O   LEU A 528      10.606  39.466  53.846  1.00 59.22           O  
ATOM   4394  CB  LEU A 528      12.866  38.300  52.012  1.00 58.33           C  
ATOM   4395  CG  LEU A 528      13.702  39.550  52.299  1.00 57.37           C  
ATOM   4396  CD1 LEU A 528      15.176  39.262  52.490  1.00 55.16           C  
ATOM   4397  CD2 LEU A 528      13.504  40.617  51.215  1.00 57.52           C  
ATOM   4398  N   VAL A 529      12.309  38.919  55.217  1.00 59.36           N  
ATOM   4399  CA  VAL A 529      11.906  39.775  56.301  1.00 59.24           C  
ATOM   4400  C   VAL A 529      12.771  41.012  56.265  1.00 59.51           C  
ATOM   4401  O   VAL A 529      12.264  42.133  56.345  1.00 60.72           O  
ATOM   4402  CB  VAL A 529      12.002  39.009  57.656  1.00 59.75           C  
ATOM   4403  CG1 VAL A 529      11.940  39.929  58.869  1.00 58.47           C  
ATOM   4404  CG2 VAL A 529      10.926  37.905  57.737  1.00 59.80           C  
ATOM   4405  N   ARG A 530      14.073  40.837  56.150  1.00 59.45           N  
ATOM   4406  CA  ARG A 530      14.980  41.976  55.956  1.00 60.37           C  
ATOM   4407  C   ARG A 530      16.290  41.407  55.432  1.00 59.70           C  
ATOM   4408  O   ARG A 530      16.525  40.208  55.584  1.00 60.27           O  
ATOM   4409  CB  ARG A 530      15.163  42.852  57.236  1.00 59.81           C  
ATOM   4410  CG  ARG A 530      14.124  44.014  57.386  1.00 60.94           C  
ATOM   4411  CD  ARG A 530      14.595  45.226  58.276  1.00 63.13           C  
ATOM   4412  NE  ARG A 530      14.121  45.173  59.683  1.00 70.43           N  
ATOM   4413  CZ  ARG A 530      14.354  46.089  60.655  1.00 73.94           C  
ATOM   4414  NH1 ARG A 530      15.080  47.193  60.439  1.00 75.30           N  
ATOM   4415  NH2 ARG A 530      13.850  45.910  61.887  1.00 74.58           N  
ATOM   4416  N   TYR A 531      17.095  42.230  54.761  1.00 59.10           N  
ATOM   4417  CA  TYR A 531      18.468  41.867  54.402  1.00 59.02           C  
ATOM   4418  C   TYR A 531      19.364  42.824  55.140  1.00 59.47           C  
ATOM   4419  O   TYR A 531      18.895  43.852  55.609  1.00 59.82           O  
ATOM   4420  CB  TYR A 531      18.736  41.890  52.863  1.00 58.59           C  
ATOM   4421  CG  TYR A 531      18.714  43.257  52.164  1.00 58.03           C  
ATOM   4422  CD1 TYR A 531      19.767  44.145  52.285  1.00 58.48           C  
ATOM   4423  CD2 TYR A 531      17.642  43.640  51.360  1.00 57.81           C  
ATOM   4424  CE1 TYR A 531      19.734  45.391  51.672  1.00 57.37           C  
ATOM   4425  CE2 TYR A 531      17.605  44.869  50.741  1.00 55.71           C  
ATOM   4426  CZ  TYR A 531      18.652  45.740  50.904  1.00 57.45           C  
ATOM   4427  OH  TYR A 531      18.634  46.978  50.290  1.00 58.48           O  
ATOM   4428  N   TYR A 532      20.646  42.502  55.266  1.00 60.04           N  
ATOM   4429  CA  TYR A 532      21.603  43.461  55.808  1.00 60.45           C  
ATOM   4430  C   TYR A 532      22.864  43.384  55.014  1.00 60.37           C  
ATOM   4431  O   TYR A 532      23.504  42.322  54.933  1.00 59.89           O  
ATOM   4432  CB  TYR A 532      21.910  43.203  57.277  1.00 61.34           C  
ATOM   4433  CG  TYR A 532      20.686  43.195  58.126  1.00 62.45           C  
ATOM   4434  CD1 TYR A 532      19.942  42.021  58.295  1.00 63.50           C  
ATOM   4435  CD2 TYR A 532      20.239  44.358  58.734  1.00 63.92           C  
ATOM   4436  CE1 TYR A 532      18.786  41.993  59.068  1.00 63.55           C  
ATOM   4437  CE2 TYR A 532      19.078  44.347  59.519  1.00 66.06           C  
ATOM   4438  CZ  TYR A 532      18.361  43.149  59.678  1.00 64.25           C  
ATOM   4439  OH  TYR A 532      17.219  43.130  60.440  1.00 64.18           O  
ATOM   4440  N   LEU A 533      23.205  44.519  54.420  1.00 60.32           N  
ATOM   4441  CA  LEU A 533      24.397  44.631  53.641  1.00 60.54           C  
ATOM   4442  C   LEU A 533      25.407  45.428  54.433  1.00 61.34           C  
ATOM   4443  O   LEU A 533      25.386  46.655  54.375  1.00 62.12           O  
ATOM   4444  CB  LEU A 533      24.087  45.325  52.331  1.00 59.72           C  
ATOM   4445  CG  LEU A 533      25.215  45.232  51.305  1.00 59.54           C  
ATOM   4446  CD1 LEU A 533      25.615  43.771  51.034  1.00 57.67           C  
ATOM   4447  CD2 LEU A 533      24.804  45.922  50.020  1.00 57.25           C  
ATOM   4448  N   THR A 534      26.292  44.738  55.164  1.00 61.99           N  
ATOM   4449  CA  THR A 534      27.297  45.400  56.046  1.00 62.33           C  
ATOM   4450  C   THR A 534      28.781  45.135  55.716  1.00 62.22           C  
ATOM   4451  O   THR A 534      29.156  44.013  55.325  1.00 62.47           O  
ATOM   4452  CB  THR A 534      27.078  45.001  57.522  1.00 62.49           C  
ATOM   4453  OG1 THR A 534      25.695  45.182  57.874  1.00 63.07           O  
ATOM   4454  CG2 THR A 534      27.978  45.827  58.441  1.00 61.91           C  
ATOM   4455  N   SER A 535      29.614  46.158  55.890  1.00 61.64           N  
ATOM   4456  CA  SER A 535      31.058  46.001  55.731  1.00 61.94           C  
ATOM   4457  C   SER A 535      31.819  46.187  57.052  1.00 62.28           C  
ATOM   4458  O   SER A 535      31.414  46.983  57.914  1.00 62.91           O  
ATOM   4459  CB  SER A 535      31.589  46.982  54.700  1.00 61.47           C  
ATOM   4460  OG  SER A 535      31.192  48.287  55.061  1.00 62.44           O  
ATOM   4461  N   TYR A 536      32.933  45.468  57.207  1.00 62.10           N  
ATOM   4462  CA  TYR A 536      33.789  45.649  58.379  1.00 62.02           C  
ATOM   4463  C   TYR A 536      35.185  46.116  57.992  1.00 62.33           C  
ATOM   4464  O   TYR A 536      35.678  45.800  56.898  1.00 62.50           O  
ATOM   4465  CB  TYR A 536      33.886  44.360  59.192  1.00 61.69           C  
ATOM   4466  CG  TYR A 536      32.545  43.773  59.572  1.00 61.46           C  
ATOM   4467  CD1 TYR A 536      31.885  42.862  58.737  1.00 61.94           C  
ATOM   4468  CD2 TYR A 536      31.925  44.130  60.758  1.00 60.39           C  
ATOM   4469  CE1 TYR A 536      30.646  42.317  59.101  1.00 60.87           C  
ATOM   4470  CE2 TYR A 536      30.694  43.602  61.111  1.00 59.60           C  
ATOM   4471  CZ  TYR A 536      30.070  42.708  60.285  1.00 59.67           C  
ATOM   4472  OH  TYR A 536      28.876  42.203  60.667  1.00 60.18           O  
ATOM   4473  N   PRO A 537      35.833  46.884  58.880  1.00 62.43           N  
ATOM   4474  CA  PRO A 537      37.245  47.169  58.679  1.00 62.36           C  
ATOM   4475  C   PRO A 537      38.049  46.111  59.436  1.00 62.19           C  
ATOM   4476  O   PRO A 537      37.465  45.149  59.926  1.00 62.41           O  
ATOM   4477  CB  PRO A 537      37.405  48.574  59.283  1.00 62.36           C  
ATOM   4478  CG  PRO A 537      36.300  48.685  60.298  1.00 62.87           C  
ATOM   4479  CD  PRO A 537      35.322  47.527  60.100  1.00 62.56           C  
ATOM   4480  N   ALA A 538      39.361  46.283  59.530  1.00 61.97           N  
ATOM   4481  CA  ALA A 538      40.237  45.265  60.085  1.00 62.25           C  
ATOM   4482  C   ALA A 538      39.940  44.837  61.528  1.00 62.79           C  
ATOM   4483  O   ALA A 538      39.910  45.649  62.446  1.00 62.93           O  
ATOM   4484  CB  ALA A 538      41.669  45.703  59.950  1.00 62.33           C  
ATOM   4485  N   PHE A 539      39.703  43.544  61.700  1.00 63.81           N  
ATOM   4486  CA  PHE A 539      39.730  42.885  63.000  1.00 64.56           C  
ATOM   4487  C   PHE A 539      40.549  41.648  62.756  1.00 65.45           C  
ATOM   4488  O   PHE A 539      40.280  40.902  61.792  1.00 66.23           O  
ATOM   4489  CB  PHE A 539      38.343  42.447  63.475  1.00 64.26           C  
ATOM   4490  CG  PHE A 539      37.363  43.566  63.647  1.00 63.57           C  
ATOM   4491  CD1 PHE A 539      36.560  43.967  62.598  1.00 63.66           C  
ATOM   4492  CD2 PHE A 539      37.219  44.199  64.868  1.00 64.01           C  
ATOM   4493  CE1 PHE A 539      35.637  44.995  62.754  1.00 64.33           C  
ATOM   4494  CE2 PHE A 539      36.307  45.235  65.036  1.00 63.88           C  
ATOM   4495  CZ  PHE A 539      35.512  45.628  63.976  1.00 63.88           C  
ATOM   4496  N   GLY A 540      41.548  41.439  63.603  1.00 65.94           N  
ATOM   4497  CA  GLY A 540      42.455  40.314  63.458  1.00 66.75           C  
ATOM   4498  C   GLY A 540      41.693  39.046  63.733  1.00 67.50           C  
ATOM   4499  O   GLY A 540      40.919  38.567  62.892  1.00 67.21           O  
ATOM   4500  N   GLU A 541      41.879  38.514  64.934  1.00 68.25           N  
ATOM   4501  CA  GLU A 541      41.213  37.267  65.300  1.00 69.13           C  
ATOM   4502  C   GLU A 541      39.751  37.477  65.671  1.00 68.41           C  
ATOM   4503  O   GLU A 541      39.021  36.530  65.929  1.00 68.32           O  
ATOM   4504  CB  GLU A 541      41.952  36.581  66.448  1.00 69.94           C  
ATOM   4505  CG  GLU A 541      43.292  35.969  66.042  1.00 72.61           C  
ATOM   4506  CD  GLU A 541      43.826  35.011  67.089  1.00 75.67           C  
ATOM   4507  OE1 GLU A 541      43.023  34.183  67.584  1.00 77.66           O  
ATOM   4508  OE2 GLU A 541      45.036  35.086  67.418  1.00 76.84           O  
ATOM   4509  N   LYS A 542      39.316  38.722  65.682  1.00 67.94           N  
ATOM   4510  CA  LYS A 542      38.005  38.996  66.218  1.00 67.37           C  
ATOM   4511  C   LYS A 542      36.935  39.105  65.135  1.00 66.96           C  
ATOM   4512  O   LYS A 542      35.754  39.171  65.461  1.00 67.54           O  
ATOM   4513  CB  LYS A 542      38.017  40.248  67.119  1.00 67.29           C  
ATOM   4514  CG  LYS A 542      38.916  40.175  68.337  1.00 65.70           C  
ATOM   4515  CD  LYS A 542      38.871  41.495  69.056  1.00 65.80           C  
ATOM   4516  CE  LYS A 542      40.076  41.676  69.941  1.00 65.66           C  
ATOM   4517  NZ  LYS A 542      40.395  43.118  70.117  1.00 65.17           N  
ATOM   4518  N   LEU A 543      37.305  39.111  63.864  1.00 65.98           N  
ATOM   4519  CA  LEU A 543      36.263  39.322  62.853  1.00 65.80           C  
ATOM   4520  C   LEU A 543      35.102  38.356  62.955  1.00 65.90           C  
ATOM   4521  O   LEU A 543      33.944  38.751  62.859  1.00 65.96           O  
ATOM   4522  CB  LEU A 543      36.808  39.259  61.432  1.00 65.82           C  
ATOM   4523  CG  LEU A 543      35.692  39.261  60.386  1.00 64.86           C  
ATOM   4524  CD1 LEU A 543      34.929  40.596  60.362  1.00 64.44           C  
ATOM   4525  CD2 LEU A 543      36.237  38.921  59.017  1.00 64.99           C  
ATOM   4526  N   THR A 544      35.428  37.088  63.148  1.00 66.19           N  
ATOM   4527  CA  THR A 544      34.455  36.034  63.038  1.00 66.50           C  
ATOM   4528  C   THR A 544      33.425  36.196  64.122  1.00 66.10           C  
ATOM   4529  O   THR A 544      32.227  36.296  63.836  1.00 66.30           O  
ATOM   4530  CB  THR A 544      35.143  34.656  63.057  1.00 67.04           C  
ATOM   4531  OG1 THR A 544      35.742  34.418  61.766  1.00 68.18           O  
ATOM   4532  CG2 THR A 544      34.144  33.532  63.368  1.00 67.99           C  
ATOM   4533  N   GLU A 545      33.899  36.267  65.362  1.00 65.72           N  
ATOM   4534  CA  GLU A 545      33.020  36.516  66.501  1.00 65.23           C  
ATOM   4535  C   GLU A 545      32.151  37.715  66.178  1.00 64.23           C  
ATOM   4536  O   GLU A 545      30.925  37.648  66.265  1.00 64.09           O  
ATOM   4537  CB  GLU A 545      33.806  36.770  67.801  1.00 65.24           C  
ATOM   4538  CG  GLU A 545      34.668  35.601  68.286  1.00 66.22           C  
ATOM   4539  CD  GLU A 545      34.861  35.571  69.811  1.00 67.87           C  
ATOM   4540  OE1 GLU A 545      35.343  36.579  70.377  1.00 68.49           O  
ATOM   4541  OE2 GLU A 545      34.545  34.527  70.444  1.00 68.74           O  
ATOM   4542  N   LYS A 546      32.788  38.795  65.757  1.00 63.29           N  
ATOM   4543  CA  LYS A 546      32.072  40.035  65.627  1.00 63.37           C  
ATOM   4544  C   LYS A 546      30.888  39.829  64.714  1.00 63.09           C  
ATOM   4545  O   LYS A 546      29.726  39.823  65.166  1.00 63.74           O  
ATOM   4546  CB  LYS A 546      32.964  41.155  65.116  1.00 63.38           C  
ATOM   4547  CG  LYS A 546      32.718  42.438  65.855  1.00 64.58           C  
ATOM   4548  CD  LYS A 546      32.726  43.626  64.920  1.00 68.19           C  
ATOM   4549  CE  LYS A 546      32.150  44.877  65.613  1.00 70.92           C  
ATOM   4550  NZ  LYS A 546      32.340  46.131  64.796  1.00 71.89           N  
ATOM   4551  N   ALA A 547      31.194  39.619  63.442  1.00 62.10           N  
ATOM   4552  CA  ALA A 547      30.179  39.421  62.422  1.00 61.44           C  
ATOM   4553  C   ALA A 547      29.149  38.348  62.728  1.00 60.60           C  
ATOM   4554  O   ALA A 547      28.002  38.468  62.323  1.00 60.83           O  
ATOM   4555  CB  ALA A 547      30.832  39.130  61.075  1.00 61.78           C  
ATOM   4556  N   ILE A 548      29.535  37.282  63.404  1.00 59.55           N  
ATOM   4557  CA  ILE A 548      28.539  36.272  63.651  1.00 59.19           C  
ATOM   4558  C   ILE A 548      27.487  36.801  64.644  1.00 59.15           C  
ATOM   4559  O   ILE A 548      26.289  36.804  64.359  1.00 57.51           O  
ATOM   4560  CB  ILE A 548      29.176  34.919  64.003  1.00 59.54           C  
ATOM   4561  CG1 ILE A 548      29.984  34.415  62.784  1.00 59.25           C  
ATOM   4562  CG2 ILE A 548      28.085  33.919  64.383  1.00 60.15           C  
ATOM   4563  CD1 ILE A 548      30.703  33.073  62.918  1.00 58.55           C  
ATOM   4564  N   GLY A 549      27.972  37.303  65.778  1.00 60.00           N  
ATOM   4565  CA  GLY A 549      27.150  38.009  66.759  1.00 60.92           C  
ATOM   4566  C   GLY A 549      26.234  39.077  66.187  1.00 61.55           C  
ATOM   4567  O   GLY A 549      25.051  39.145  66.533  1.00 61.36           O  
ATOM   4568  N   ASP A 550      26.775  39.920  65.314  1.00 62.41           N  
ATOM   4569  CA  ASP A 550      25.955  40.904  64.596  1.00 63.66           C  
ATOM   4570  C   ASP A 550      24.683  40.336  63.978  1.00 64.03           C  
ATOM   4571  O   ASP A 550      23.650  41.008  63.941  1.00 64.51           O  
ATOM   4572  CB  ASP A 550      26.771  41.607  63.522  1.00 63.65           C  
ATOM   4573  CG  ASP A 550      27.647  42.707  64.096  1.00 66.30           C  
ATOM   4574  OD1 ASP A 550      27.824  42.767  65.343  1.00 68.47           O  
ATOM   4575  OD2 ASP A 550      28.156  43.523  63.300  1.00 68.24           O  
ATOM   4576  N   VAL A 551      24.752  39.095  63.507  1.00 64.20           N  
ATOM   4577  CA  VAL A 551      23.617  38.480  62.875  1.00 64.18           C  
ATOM   4578  C   VAL A 551      22.611  38.100  63.954  1.00 64.50           C  
ATOM   4579  O   VAL A 551      21.402  38.278  63.777  1.00 64.42           O  
ATOM   4580  CB  VAL A 551      24.080  37.308  61.988  1.00 64.76           C  
ATOM   4581  CG1 VAL A 551      22.915  36.354  61.577  1.00 64.81           C  
ATOM   4582  CG2 VAL A 551      24.870  37.844  60.746  1.00 64.42           C  
ATOM   4583  N   PHE A 552      23.121  37.639  65.095  1.00 64.96           N  
ATOM   4584  CA  PHE A 552      22.269  37.231  66.228  1.00 65.16           C  
ATOM   4585  C   PHE A 552      21.486  38.371  66.829  1.00 65.30           C  
ATOM   4586  O   PHE A 552      20.271  38.234  67.030  1.00 65.81           O  
ATOM   4587  CB  PHE A 552      23.065  36.514  67.319  1.00 65.10           C  
ATOM   4588  CG  PHE A 552      23.311  35.074  67.021  1.00 65.14           C  
ATOM   4589  CD1 PHE A 552      24.244  34.702  66.043  1.00 65.76           C  
ATOM   4590  CD2 PHE A 552      22.594  34.094  67.672  1.00 64.69           C  
ATOM   4591  CE1 PHE A 552      24.470  33.377  65.732  1.00 64.92           C  
ATOM   4592  CE2 PHE A 552      22.813  32.759  67.383  1.00 65.74           C  
ATOM   4593  CZ  PHE A 552      23.760  32.396  66.409  1.00 66.00           C  
ATOM   4594  N   SER A 553      22.167  39.484  67.108  1.00 65.07           N  
ATOM   4595  CA  SER A 553      21.507  40.657  67.665  1.00 65.01           C  
ATOM   4596  C   SER A 553      20.438  41.147  66.704  1.00 65.01           C  
ATOM   4597  O   SER A 553      19.300  41.295  67.085  1.00 65.06           O  
ATOM   4598  CB  SER A 553      22.510  41.751  68.011  1.00 65.01           C  
ATOM   4599  OG  SER A 553      23.022  42.368  66.850  1.00 65.97           O  
ATOM   4600  N   LEU A 554      20.794  41.346  65.444  1.00 65.55           N  
ATOM   4601  CA  LEU A 554      19.805  41.613  64.405  1.00 66.13           C  
ATOM   4602  C   LEU A 554      18.565  40.707  64.444  1.00 65.97           C  
ATOM   4603  O   LEU A 554      17.453  41.155  64.160  1.00 65.55           O  
ATOM   4604  CB  LEU A 554      20.455  41.531  63.024  1.00 66.29           C  
ATOM   4605  CG  LEU A 554      21.302  42.749  62.643  1.00 68.00           C  
ATOM   4606  CD1 LEU A 554      21.902  42.541  61.255  1.00 68.99           C  
ATOM   4607  CD2 LEU A 554      20.533  44.105  62.736  1.00 69.05           C  
ATOM   4608  N   LEU A 555      18.757  39.437  64.781  1.00 66.22           N  
ATOM   4609  CA  LEU A 555      17.629  38.520  64.890  1.00 66.53           C  
ATOM   4610  C   LEU A 555      16.748  38.920  66.057  1.00 67.20           C  
ATOM   4611  O   LEU A 555      15.532  39.027  65.899  1.00 67.53           O  
ATOM   4612  CB  LEU A 555      18.077  37.063  64.997  1.00 66.10           C  
ATOM   4613  CG  LEU A 555      18.323  36.343  63.671  1.00 65.47           C  
ATOM   4614  CD1 LEU A 555      18.991  35.023  63.908  1.00 65.50           C  
ATOM   4615  CD2 LEU A 555      17.045  36.120  62.878  1.00 64.35           C  
ATOM   4616  N   GLU A 556      17.361  39.169  67.212  1.00 67.47           N  
ATOM   4617  CA  GLU A 556      16.637  39.700  68.371  1.00 68.34           C  
ATOM   4618  C   GLU A 556      15.953  41.034  68.084  1.00 67.61           C  
ATOM   4619  O   GLU A 556      14.891  41.295  68.631  1.00 67.80           O  
ATOM   4620  CB  GLU A 556      17.566  39.857  69.568  1.00 67.79           C  
ATOM   4621  CG  GLU A 556      16.860  40.249  70.847  1.00 69.89           C  
ATOM   4622  CD  GLU A 556      17.758  40.127  72.092  1.00 71.43           C  
ATOM   4623  OE1 GLU A 556      18.829  39.480  71.987  1.00 75.32           O  
ATOM   4624  OE2 GLU A 556      17.392  40.670  73.177  1.00 74.70           O  
ATOM   4625  N   LYS A 557      16.563  41.863  67.231  1.00 67.24           N  
ATOM   4626  CA  LYS A 557      16.042  43.185  66.881  1.00 66.74           C  
ATOM   4627  C   LYS A 557      14.808  43.084  66.028  1.00 66.34           C  
ATOM   4628  O   LYS A 557      14.019  44.008  65.945  1.00 65.92           O  
ATOM   4629  CB  LYS A 557      17.080  43.983  66.122  1.00 66.96           C  
ATOM   4630  CG  LYS A 557      18.284  44.369  66.931  1.00 69.08           C  
ATOM   4631  CD  LYS A 557      19.401  44.926  66.044  1.00 72.42           C  
ATOM   4632  CE  LYS A 557      20.576  45.410  66.900  1.00 74.51           C  
ATOM   4633  NZ  LYS A 557      21.350  46.490  66.224  1.00 76.05           N  
ATOM   4634  N   LEU A 558      14.656  41.953  65.365  1.00 66.54           N  
ATOM   4635  CA  LEU A 558      13.429  41.664  64.656  1.00 66.73           C  
ATOM   4636  C   LEU A 558      12.593  40.896  65.644  1.00 67.24           C  
ATOM   4637  O   LEU A 558      11.463  40.503  65.363  1.00 67.31           O  
ATOM   4638  CB  LEU A 558      13.721  40.849  63.396  1.00 66.47           C  
ATOM   4639  CG  LEU A 558      14.658  41.525  62.367  1.00 65.56           C  
ATOM   4640  CD1 LEU A 558      15.541  40.514  61.663  1.00 61.55           C  
ATOM   4641  CD2 LEU A 558      13.879  42.410  61.351  1.00 65.08           C  
ATOM   4642  N   GLY A 559      13.187  40.700  66.817  1.00 67.95           N  
ATOM   4643  CA  GLY A 559      12.591  39.980  67.926  1.00 68.86           C  
ATOM   4644  C   GLY A 559      12.059  38.621  67.565  1.00 69.61           C  
ATOM   4645  O   GLY A 559      10.863  38.415  67.604  1.00 70.13           O  
ATOM   4646  N   PHE A 560      12.924  37.694  67.182  1.00 70.23           N  
ATOM   4647  CA  PHE A 560      12.484  36.321  67.073  1.00 71.07           C  
ATOM   4648  C   PHE A 560      12.571  35.786  68.486  1.00 72.38           C  
ATOM   4649  O   PHE A 560      13.648  35.844  69.098  1.00 72.88           O  
ATOM   4650  CB  PHE A 560      13.403  35.530  66.165  1.00 70.49           C  
ATOM   4651  CG  PHE A 560      12.978  35.517  64.732  1.00 69.61           C  
ATOM   4652  CD1 PHE A 560      13.399  36.512  63.856  1.00 68.09           C  
ATOM   4653  CD2 PHE A 560      12.184  34.487  64.243  1.00 68.90           C  
ATOM   4654  CE1 PHE A 560      13.019  36.485  62.519  1.00 66.95           C  
ATOM   4655  CE2 PHE A 560      11.798  34.458  62.910  1.00 68.16           C  
ATOM   4656  CZ  PHE A 560      12.216  35.462  62.047  1.00 67.66           C  
ATOM   4657  N   LYS A 561      11.454  35.299  69.025  1.00 73.59           N  
ATOM   4658  CA  LYS A 561      11.412  34.903  70.453  1.00 74.86           C  
ATOM   4659  C   LYS A 561      12.356  33.742  70.798  1.00 75.01           C  
ATOM   4660  O   LYS A 561      12.594  32.854  69.973  1.00 75.25           O  
ATOM   4661  CB  LYS A 561       9.973  34.622  70.924  1.00 75.13           C  
ATOM   4662  CG  LYS A 561       9.206  35.905  71.270  1.00 76.31           C  
ATOM   4663  CD  LYS A 561       7.823  35.614  71.800  1.00 77.21           C  
ATOM   4664  CE  LYS A 561       7.046  36.902  71.934  1.00 77.86           C  
ATOM   4665  NZ  LYS A 561       6.100  36.787  73.065  1.00 79.29           N  
ATOM   4666  N   LYS A 562      12.907  33.772  72.009  1.00 75.02           N  
ATOM   4667  CA  LYS A 562      13.770  32.697  72.494  1.00 75.01           C  
ATOM   4668  C   LYS A 562      13.097  31.332  72.266  1.00 74.98           C  
ATOM   4669  O   LYS A 562      11.866  31.240  72.205  1.00 74.83           O  
ATOM   4670  CB  LYS A 562      14.120  32.920  73.965  1.00 74.93           C  
ATOM   4671  CG  LYS A 562      14.772  34.300  74.248  1.00 75.83           C  
ATOM   4672  CD  LYS A 562      15.139  34.461  75.735  1.00 75.00           C  
ATOM   4673  CE  LYS A 562      16.340  35.359  75.917  1.00 74.07           C  
ATOM   4674  NZ  LYS A 562      17.239  34.793  76.962  1.00 73.93           N  
ATOM   4675  N   GLY A 563      13.911  30.289  72.101  1.00 74.91           N  
ATOM   4676  CA  GLY A 563      13.424  28.972  71.729  1.00 74.86           C  
ATOM   4677  C   GLY A 563      12.943  28.862  70.284  1.00 75.00           C  
ATOM   4678  O   GLY A 563      12.398  27.835  69.888  1.00 74.81           O  
ATOM   4679  N   SER A 564      13.124  29.914  69.489  1.00 75.24           N  
ATOM   4680  CA  SER A 564      12.763  29.847  68.059  1.00 75.26           C  
ATOM   4681  C   SER A 564      13.838  29.070  67.296  1.00 75.16           C  
ATOM   4682  O   SER A 564      15.030  29.202  67.605  1.00 75.30           O  
ATOM   4683  CB  SER A 564      12.536  31.251  67.458  1.00 75.32           C  
ATOM   4684  OG  SER A 564      13.507  32.192  67.886  1.00 73.75           O  
ATOM   4685  N   LYS A 565      13.437  28.228  66.350  1.00 74.61           N  
ATOM   4686  CA  LYS A 565      14.444  27.458  65.637  1.00 74.81           C  
ATOM   4687  C   LYS A 565      14.972  28.362  64.553  1.00 73.57           C  
ATOM   4688  O   LYS A 565      14.204  29.059  63.877  1.00 73.66           O  
ATOM   4689  CB  LYS A 565      13.900  26.161  65.002  1.00 75.92           C  
ATOM   4690  CG  LYS A 565      12.774  25.478  65.756  1.00 79.53           C  
ATOM   4691  CD  LYS A 565      12.982  23.957  65.787  1.00 85.99           C  
ATOM   4692  CE  LYS A 565      12.266  23.377  67.031  1.00 88.86           C  
ATOM   4693  NZ  LYS A 565      12.990  22.225  67.674  1.00 90.12           N  
ATOM   4694  N   ILE A 566      16.280  28.357  64.372  1.00 71.69           N  
ATOM   4695  CA  ILE A 566      16.836  29.143  63.308  1.00 69.91           C  
ATOM   4696  C   ILE A 566      17.816  28.307  62.472  1.00 69.35           C  
ATOM   4697  O   ILE A 566      18.778  27.761  63.010  1.00 69.27           O  
ATOM   4698  CB  ILE A 566      17.439  30.407  63.887  1.00 69.53           C  
ATOM   4699  CG1 ILE A 566      16.326  31.191  64.571  1.00 69.63           C  
ATOM   4700  CG2 ILE A 566      18.054  31.241  62.810  1.00 69.13           C  
ATOM   4701  CD1 ILE A 566      16.700  32.551  65.082  1.00 71.38           C  
ATOM   4702  N   VAL A 567      17.548  28.188  61.171  1.00 68.09           N  
ATOM   4703  CA  VAL A 567      18.456  27.505  60.246  1.00 67.41           C  
ATOM   4704  C   VAL A 567      19.430  28.453  59.545  1.00 66.64           C  
ATOM   4705  O   VAL A 567      19.032  29.490  59.045  1.00 66.75           O  
ATOM   4706  CB  VAL A 567      17.661  26.774  59.174  1.00 67.76           C  
ATOM   4707  CG1 VAL A 567      18.560  25.884  58.339  1.00 67.95           C  
ATOM   4708  CG2 VAL A 567      16.591  25.932  59.815  1.00 68.13           C  
ATOM   4709  N   VAL A 568      20.701  28.090  59.486  1.00 66.00           N  
ATOM   4710  CA  VAL A 568      21.677  28.909  58.762  1.00 66.24           C  
ATOM   4711  C   VAL A 568      22.281  28.266  57.486  1.00 66.47           C  
ATOM   4712  O   VAL A 568      22.793  27.149  57.527  1.00 66.53           O  
ATOM   4713  CB  VAL A 568      22.811  29.323  59.673  1.00 65.98           C  
ATOM   4714  CG1 VAL A 568      23.861  30.040  58.879  1.00 66.61           C  
ATOM   4715  CG2 VAL A 568      22.291  30.221  60.750  1.00 65.86           C  
ATOM   4716  N   HIS A 569      22.226  28.965  56.356  1.00 66.52           N  
ATOM   4717  CA  HIS A 569      22.873  28.453  55.153  1.00 66.78           C  
ATOM   4718  C   HIS A 569      24.058  29.314  54.773  1.00 67.97           C  
ATOM   4719  O   HIS A 569      23.949  30.557  54.781  1.00 67.93           O  
ATOM   4720  CB  HIS A 569      21.921  28.440  53.976  1.00 66.14           C  
ATOM   4721  CG  HIS A 569      20.683  27.634  54.189  1.00 64.55           C  
ATOM   4722  ND1 HIS A 569      20.632  26.550  55.031  1.00 62.70           N  
ATOM   4723  CD2 HIS A 569      19.456  27.731  53.626  1.00 63.00           C  
ATOM   4724  CE1 HIS A 569      19.420  26.025  54.993  1.00 62.43           C  
ATOM   4725  NE2 HIS A 569      18.690  26.720  54.142  1.00 62.70           N  
ATOM   4726  N   ARG A 570      25.185  28.667  54.452  1.00 69.01           N  
ATOM   4727  CA  ARG A 570      26.320  29.377  53.869  1.00 70.33           C  
ATOM   4728  C   ARG A 570      26.737  28.702  52.612  1.00 71.33           C  
ATOM   4729  O   ARG A 570      26.839  27.466  52.573  1.00 71.79           O  
ATOM   4730  CB  ARG A 570      27.541  29.411  54.772  1.00 70.44           C  
ATOM   4731  CG  ARG A 570      28.665  30.311  54.215  1.00 71.00           C  
ATOM   4732  CD  ARG A 570      30.030  29.794  54.621  1.00 72.73           C  
ATOM   4733  NE  ARG A 570      30.943  30.795  55.187  1.00 74.97           N  
ATOM   4734  CZ  ARG A 570      30.915  31.222  56.455  1.00 74.66           C  
ATOM   4735  NH1 ARG A 570      30.007  30.775  57.288  1.00 75.37           N  
ATOM   4736  NH2 ARG A 570      31.795  32.106  56.905  1.00 75.32           N  
ATOM   4737  N   ASP A 571      26.992  29.537  51.596  1.00 72.36           N  
ATOM   4738  CA  ASP A 571      27.590  29.142  50.319  1.00 72.30           C  
ATOM   4739  C   ASP A 571      29.117  28.929  50.480  1.00 72.12           C  
ATOM   4740  O   ASP A 571      29.914  29.552  49.816  1.00 72.62           O  
ATOM   4741  CB  ASP A 571      27.252  30.215  49.259  1.00 72.52           C  
ATOM   4742  CG  ASP A 571      27.718  29.844  47.829  1.00 73.50           C  
ATOM   4743  OD1 ASP A 571      27.899  28.642  47.549  1.00 75.92           O  
ATOM   4744  OD2 ASP A 571      27.901  30.754  46.978  1.00 71.86           O  
ATOM   4745  N   GLY A 572      29.536  28.043  51.363  1.00 72.11           N  
ATOM   4746  CA  GLY A 572      30.951  27.748  51.435  1.00 72.53           C  
ATOM   4747  C   GLY A 572      31.358  27.100  52.728  1.00 72.96           C  
ATOM   4748  O   GLY A 572      30.713  27.245  53.755  1.00 72.94           O  
ATOM   4749  N   ARG A 573      32.451  26.374  52.668  1.00 73.40           N  
ATOM   4750  CA  ARG A 573      33.022  25.720  53.831  1.00 74.37           C  
ATOM   4751  C   ARG A 573      33.002  26.650  55.041  1.00 73.86           C  
ATOM   4752  O   ARG A 573      33.673  27.684  55.014  1.00 74.56           O  
ATOM   4753  CB  ARG A 573      34.470  25.403  53.472  1.00 75.04           C  
ATOM   4754  CG  ARG A 573      34.979  24.026  53.758  1.00 78.31           C  
ATOM   4755  CD  ARG A 573      36.475  24.090  53.496  1.00 83.33           C  
ATOM   4756  NE  ARG A 573      37.237  22.999  54.093  1.00 86.45           N  
ATOM   4757  CZ  ARG A 573      38.564  22.990  54.168  1.00 88.17           C  
ATOM   4758  NH1 ARG A 573      39.260  24.025  53.695  1.00 88.06           N  
ATOM   4759  NH2 ARG A 573      39.196  21.956  54.720  1.00 89.52           N  
ATOM   4760  N   LEU A 574      32.239  26.312  56.084  1.00 73.39           N  
ATOM   4761  CA  LEU A 574      32.372  26.995  57.382  1.00 73.38           C  
ATOM   4762  C   LEU A 574      33.500  26.327  58.106  1.00 74.33           C  
ATOM   4763  O   LEU A 574      33.608  25.105  58.075  1.00 75.24           O  
ATOM   4764  CB  LEU A 574      31.177  26.791  58.273  1.00 72.44           C  
ATOM   4765  CG  LEU A 574      29.783  26.745  57.722  1.00 72.61           C  
ATOM   4766  CD1 LEU A 574      29.136  25.535  58.295  1.00 72.96           C  
ATOM   4767  CD2 LEU A 574      29.039  27.987  58.121  1.00 72.41           C  
ATOM   4768  N   TYR A 575      34.330  27.101  58.789  1.00 75.26           N  
ATOM   4769  CA  TYR A 575      35.456  26.519  59.517  1.00 76.14           C  
ATOM   4770  C   TYR A 575      35.131  26.339  61.010  1.00 76.42           C  
ATOM   4771  O   TYR A 575      34.072  26.768  61.482  1.00 76.03           O  
ATOM   4772  CB  TYR A 575      36.743  27.317  59.238  1.00 76.77           C  
ATOM   4773  CG  TYR A 575      36.965  27.460  57.755  1.00 77.60           C  
ATOM   4774  CD1 TYR A 575      36.235  28.396  57.005  1.00 78.91           C  
ATOM   4775  CD2 TYR A 575      37.842  26.623  57.081  1.00 78.55           C  
ATOM   4776  CE1 TYR A 575      36.398  28.508  55.628  1.00 78.74           C  
ATOM   4777  CE2 TYR A 575      38.021  26.728  55.694  1.00 79.26           C  
ATOM   4778  CZ  TYR A 575      37.291  27.672  54.981  1.00 79.05           C  
ATOM   4779  OH  TYR A 575      37.461  27.782  53.620  1.00 79.11           O  
ATOM   4780  N   ARG A 576      36.037  25.682  61.733  1.00 76.98           N  
ATOM   4781  CA  ARG A 576      35.817  25.327  63.136  1.00 77.34           C  
ATOM   4782  C   ARG A 576      35.538  26.545  64.031  1.00 76.67           C  
ATOM   4783  O   ARG A 576      34.577  26.544  64.803  1.00 76.49           O  
ATOM   4784  CB  ARG A 576      37.018  24.557  63.696  1.00 78.16           C  
ATOM   4785  CG  ARG A 576      37.602  23.490  62.799  1.00 79.50           C  
ATOM   4786  CD  ARG A 576      38.892  22.982  63.412  1.00 81.76           C  
ATOM   4787  NE  ARG A 576      38.969  21.539  63.231  1.00 86.08           N  
ATOM   4788  CZ  ARG A 576      39.864  20.730  63.802  1.00 87.52           C  
ATOM   4789  NH1 ARG A 576      40.808  21.203  64.616  1.00 88.08           N  
ATOM   4790  NH2 ARG A 576      39.815  19.426  63.547  1.00 88.13           N  
ATOM   4791  N   ASP A 577      36.378  27.568  63.908  1.00 75.69           N  
ATOM   4792  CA  ASP A 577      36.234  28.798  64.664  1.00 75.23           C  
ATOM   4793  C   ASP A 577      34.863  29.448  64.505  1.00 74.83           C  
ATOM   4794  O   ASP A 577      34.427  30.202  65.372  1.00 75.02           O  
ATOM   4795  CB  ASP A 577      37.309  29.787  64.239  1.00 75.47           C  
ATOM   4796  CG  ASP A 577      37.048  30.384  62.864  1.00 76.80           C  
ATOM   4797  OD1 ASP A 577      36.568  29.659  61.951  1.00 78.77           O  
ATOM   4798  OD2 ASP A 577      37.328  31.592  62.698  1.00 76.68           O  
ATOM   4799  N   GLU A 578      34.196  29.167  63.391  1.00 74.45           N  
ATOM   4800  CA  GLU A 578      32.868  29.718  63.106  1.00 74.31           C  
ATOM   4801  C   GLU A 578      31.762  28.915  63.790  1.00 73.73           C  
ATOM   4802  O   GLU A 578      30.776  29.471  64.280  1.00 73.29           O  
ATOM   4803  CB  GLU A 578      32.621  29.757  61.588  1.00 74.42           C  
ATOM   4804  CG  GLU A 578      32.971  31.078  60.934  1.00 75.22           C  
ATOM   4805  CD  GLU A 578      33.538  30.921  59.534  1.00 76.99           C  
ATOM   4806  OE1 GLU A 578      32.797  30.570  58.590  1.00 76.90           O  
ATOM   4807  OE2 GLU A 578      34.747  31.169  59.375  1.00 78.82           O  
ATOM   4808  N   VAL A 579      31.928  27.598  63.791  1.00 73.15           N  
ATOM   4809  CA  VAL A 579      30.955  26.701  64.374  1.00 72.56           C  
ATOM   4810  C   VAL A 579      30.886  26.994  65.848  1.00 72.26           C  
ATOM   4811  O   VAL A 579      29.813  27.020  66.443  1.00 71.94           O  
ATOM   4812  CB  VAL A 579      31.396  25.244  64.238  1.00 72.45           C  
ATOM   4813  CG1 VAL A 579      30.227  24.319  64.527  1.00 72.56           C  
ATOM   4814  CG2 VAL A 579      31.956  24.988  62.865  1.00 72.53           C  
ATOM   4815  N   ALA A 580      32.057  27.202  66.433  1.00 72.14           N  
ATOM   4816  CA  ALA A 580      32.159  27.423  67.857  1.00 72.21           C  
ATOM   4817  C   ALA A 580      31.541  28.782  68.145  1.00 72.51           C  
ATOM   4818  O   ALA A 580      31.008  29.019  69.249  1.00 72.87           O  
ATOM   4819  CB  ALA A 580      33.590  27.375  68.289  1.00 71.80           C  
ATOM   4820  N   ALA A 581      31.596  29.651  67.128  1.00 72.24           N  
ATOM   4821  CA  ALA A 581      31.021  30.979  67.192  1.00 71.90           C  
ATOM   4822  C   ALA A 581      29.508  30.890  67.232  1.00 71.83           C  
ATOM   4823  O   ALA A 581      28.876  31.519  68.067  1.00 71.97           O  
ATOM   4824  CB  ALA A 581      31.477  31.801  66.015  1.00 71.99           C  
ATOM   4825  N   PHE A 582      28.931  30.082  66.352  1.00 71.91           N  
ATOM   4826  CA  PHE A 582      27.478  29.894  66.303  1.00 71.83           C  
ATOM   4827  C   PHE A 582      26.950  29.158  67.508  1.00 72.26           C  
ATOM   4828  O   PHE A 582      25.781  29.323  67.864  1.00 72.30           O  
ATOM   4829  CB  PHE A 582      27.057  29.139  65.040  1.00 71.39           C  
ATOM   4830  CG  PHE A 582      26.923  30.015  63.841  1.00 70.62           C  
ATOM   4831  CD1 PHE A 582      27.958  30.125  62.930  1.00 68.97           C  
ATOM   4832  CD2 PHE A 582      25.764  30.752  63.630  1.00 69.85           C  
ATOM   4833  CE1 PHE A 582      27.827  30.946  61.824  1.00 68.58           C  
ATOM   4834  CE2 PHE A 582      25.641  31.573  62.511  1.00 68.60           C  
ATOM   4835  CZ  PHE A 582      26.667  31.666  61.620  1.00 68.15           C  
ATOM   4836  N   LYS A 583      27.806  28.330  68.110  1.00 72.91           N  
ATOM   4837  CA  LYS A 583      27.456  27.602  69.330  1.00 73.60           C  
ATOM   4838  C   LYS A 583      27.302  28.582  70.488  1.00 73.79           C  
ATOM   4839  O   LYS A 583      26.314  28.517  71.241  1.00 73.41           O  
ATOM   4840  CB  LYS A 583      28.501  26.530  69.643  1.00 73.58           C  
ATOM   4841  CG  LYS A 583      28.309  25.243  68.863  1.00 74.29           C  
ATOM   4842  CD  LYS A 583      29.624  24.460  68.684  1.00 76.42           C  
ATOM   4843  CE  LYS A 583      29.344  22.963  68.381  1.00 77.91           C  
ATOM   4844  NZ  LYS A 583      30.362  22.348  67.461  1.00 77.76           N  
ATOM   4845  N   LYS A 584      28.264  29.502  70.589  1.00 74.22           N  
ATOM   4846  CA  LYS A 584      28.279  30.505  71.643  1.00 75.44           C  
ATOM   4847  C   LYS A 584      26.953  31.263  71.705  1.00 75.47           C  
ATOM   4848  O   LYS A 584      26.266  31.285  72.739  1.00 75.36           O  
ATOM   4849  CB  LYS A 584      29.418  31.517  71.437  1.00 75.71           C  
ATOM   4850  CG  LYS A 584      30.844  31.013  71.675  1.00 76.82           C  
ATOM   4851  CD  LYS A 584      31.792  32.148  72.191  1.00 76.71           C  
ATOM   4852  CE  LYS A 584      33.206  31.566  72.539  1.00 79.04           C  
ATOM   4853  NZ  LYS A 584      33.806  31.972  73.898  1.00 79.44           N  
ATOM   4854  N   TYR A 585      26.606  31.879  70.577  1.00 75.58           N  
ATOM   4855  CA  TYR A 585      25.477  32.801  70.502  1.00 75.49           C  
ATOM   4856  C   TYR A 585      24.181  31.997  70.413  1.00 75.38           C  
ATOM   4857  O   TYR A 585      23.103  32.455  70.832  1.00 75.17           O  
ATOM   4858  CB  TYR A 585      25.660  33.784  69.325  1.00 75.46           C  
ATOM   4859  CG  TYR A 585      26.947  34.623  69.391  1.00 75.70           C  
ATOM   4860  CD1 TYR A 585      28.076  34.263  68.654  1.00 75.46           C  
ATOM   4861  CD2 TYR A 585      27.034  35.769  70.192  1.00 75.81           C  
ATOM   4862  CE1 TYR A 585      29.250  35.005  68.702  1.00 74.50           C  
ATOM   4863  CE2 TYR A 585      28.214  36.522  70.244  1.00 75.64           C  
ATOM   4864  CZ  TYR A 585      29.316  36.124  69.493  1.00 75.34           C  
ATOM   4865  OH  TYR A 585      30.490  36.844  69.522  1.00 75.77           O  
ATOM   4866  N   GLY A 586      24.314  30.783  69.879  1.00 75.30           N  
ATOM   4867  CA  GLY A 586      23.273  29.778  69.958  1.00 75.11           C  
ATOM   4868  C   GLY A 586      22.703  29.838  71.346  1.00 74.84           C  
ATOM   4869  O   GLY A 586      21.542  30.202  71.509  1.00 75.03           O  
ATOM   4870  N   GLU A 587      23.547  29.532  72.334  1.00 74.72           N  
ATOM   4871  CA  GLU A 587      23.221  29.701  73.768  1.00 74.78           C  
ATOM   4872  C   GLU A 587      22.788  31.123  74.130  1.00 73.65           C  
ATOM   4873  O   GLU A 587      21.618  31.360  74.423  1.00 73.08           O  
ATOM   4874  CB  GLU A 587      24.411  29.312  74.658  1.00 74.82           C  
ATOM   4875  CG  GLU A 587      24.768  27.818  74.717  1.00 76.18           C  
ATOM   4876  CD  GLU A 587      26.219  27.577  75.198  1.00 76.61           C  
ATOM   4877  OE1 GLU A 587      26.568  27.971  76.351  1.00 78.73           O  
ATOM   4878  OE2 GLU A 587      27.008  26.991  74.414  1.00 78.16           O  
ATOM   4879  N   LEU A 588      23.736  32.063  74.093  1.00 73.12           N  
ATOM   4880  CA  LEU A 588      23.534  33.421  74.648  1.00 72.52           C  
ATOM   4881  C   LEU A 588      22.221  34.089  74.219  1.00 71.59           C  
ATOM   4882  O   LEU A 588      21.697  34.949  74.927  1.00 71.38           O  
ATOM   4883  CB  LEU A 588      24.737  34.358  74.389  1.00 72.71           C  
ATOM   4884  CG  LEU A 588      26.247  34.007  74.543  1.00 74.13           C  
ATOM   4885  CD1 LEU A 588      27.087  35.287  74.808  1.00 74.14           C  
ATOM   4886  CD2 LEU A 588      26.620  32.915  75.577  1.00 74.33           C  
ATOM   4887  N   TYR A 589      21.698  33.687  73.064  1.00 70.62           N  
ATOM   4888  CA  TYR A 589      20.405  34.188  72.587  1.00 69.49           C  
ATOM   4889  C   TYR A 589      19.299  33.163  72.862  1.00 69.43           C  
ATOM   4890  O   TYR A 589      18.137  33.521  73.131  1.00 69.29           O  
ATOM   4891  CB  TYR A 589      20.479  34.602  71.101  1.00 68.13           C  
ATOM   4892  CG  TYR A 589      21.132  35.962  70.895  1.00 66.46           C  
ATOM   4893  CD1 TYR A 589      22.526  36.110  70.964  1.00 65.36           C  
ATOM   4894  CD2 TYR A 589      20.371  37.096  70.657  1.00 64.41           C  
ATOM   4895  CE1 TYR A 589      23.139  37.348  70.786  1.00 64.27           C  
ATOM   4896  CE2 TYR A 589      20.984  38.349  70.481  1.00 63.72           C  
ATOM   4897  CZ  TYR A 589      22.367  38.468  70.545  1.00 64.55           C  
ATOM   4898  OH  TYR A 589      22.982  39.698  70.386  1.00 64.14           O  
ATOM   4899  N   GLY A 590      19.680  31.892  72.797  1.00 68.99           N  
ATOM   4900  CA  GLY A 590      18.804  30.815  73.202  1.00 68.98           C  
ATOM   4901  C   GLY A 590      17.882  30.317  72.118  1.00 69.08           C  
ATOM   4902  O   GLY A 590      16.672  30.263  72.324  1.00 69.40           O  
ATOM   4903  N   TYR A 591      18.460  29.933  70.976  1.00 69.03           N  
ATOM   4904  CA  TYR A 591      17.708  29.447  69.824  1.00 68.63           C  
ATOM   4905  C   TYR A 591      18.278  28.100  69.441  1.00 68.97           C  
ATOM   4906  O   TYR A 591      19.496  27.933  69.479  1.00 68.92           O  
ATOM   4907  CB  TYR A 591      17.953  30.336  68.618  1.00 68.56           C  
ATOM   4908  CG  TYR A 591      17.642  31.827  68.679  1.00 68.10           C  
ATOM   4909  CD1 TYR A 591      16.380  32.300  69.016  1.00 68.38           C  
ATOM   4910  CD2 TYR A 591      18.593  32.753  68.273  1.00 67.61           C  
ATOM   4911  CE1 TYR A 591      16.100  33.677  69.022  1.00 68.45           C  
ATOM   4912  CE2 TYR A 591      18.324  34.109  68.268  1.00 69.01           C  
ATOM   4913  CZ  TYR A 591      17.078  34.574  68.643  1.00 68.40           C  
ATOM   4914  OH  TYR A 591      16.826  35.932  68.621  1.00 67.83           O  
ATOM   4915  N   SER A 592      17.432  27.150  69.039  1.00 69.35           N  
ATOM   4916  CA  SER A 592      17.939  25.916  68.422  1.00 69.68           C  
ATOM   4917  C   SER A 592      18.270  26.173  66.948  1.00 69.77           C  
ATOM   4918  O   SER A 592      17.430  26.667  66.164  1.00 69.57           O  
ATOM   4919  CB  SER A 592      17.003  24.707  68.613  1.00 70.04           C  
ATOM   4920  OG  SER A 592      15.633  25.019  68.370  1.00 71.23           O  
ATOM   4921  N   LEU A 593      19.516  25.852  66.608  1.00 69.59           N  
ATOM   4922  CA  LEU A 593      20.161  26.303  65.393  1.00 69.65           C  
ATOM   4923  C   LEU A 593      20.533  25.137  64.545  1.00 70.05           C  
ATOM   4924  O   LEU A 593      21.133  24.185  65.036  1.00 70.62           O  
ATOM   4925  CB  LEU A 593      21.471  27.023  65.706  1.00 69.32           C  
ATOM   4926  CG  LEU A 593      21.530  28.487  66.118  1.00 69.87           C  
ATOM   4927  CD1 LEU A 593      22.659  29.185  65.346  1.00 68.69           C  
ATOM   4928  CD2 LEU A 593      20.191  29.183  65.867  1.00 70.41           C  
ATOM   4929  N   GLU A 594      20.230  25.221  63.255  1.00 70.08           N  
ATOM   4930  CA  GLU A 594      20.755  24.256  62.326  1.00 69.83           C  
ATOM   4931  C   GLU A 594      21.727  24.882  61.359  1.00 68.89           C  
ATOM   4932  O   GLU A 594      21.344  25.704  60.551  1.00 68.93           O  
ATOM   4933  CB  GLU A 594      19.628  23.551  61.606  1.00 70.37           C  
ATOM   4934  CG  GLU A 594      19.503  22.095  62.049  1.00 74.05           C  
ATOM   4935  CD  GLU A 594      18.547  21.917  63.210  1.00 77.51           C  
ATOM   4936  OE1 GLU A 594      17.435  21.419  62.963  1.00 79.84           O  
ATOM   4937  OE2 GLU A 594      18.886  22.277  64.361  1.00 79.34           O  
ATOM   4938  N   LEU A 595      22.988  24.484  61.471  1.00 68.24           N  
ATOM   4939  CA  LEU A 595      24.060  24.983  60.628  1.00 67.93           C  
ATOM   4940  C   LEU A 595      24.328  24.121  59.378  1.00 67.72           C  
ATOM   4941  O   LEU A 595      24.656  22.948  59.455  1.00 67.94           O  
ATOM   4942  CB  LEU A 595      25.332  25.150  61.454  1.00 67.89           C  
ATOM   4943  CG  LEU A 595      26.441  26.095  60.963  1.00 68.12           C  
ATOM   4944  CD1 LEU A 595      25.908  27.502  60.740  1.00 66.86           C  
ATOM   4945  CD2 LEU A 595      27.591  26.127  61.966  1.00 67.97           C  
ATOM   4946  N   LEU A 596      24.193  24.724  58.211  1.00 67.47           N  
ATOM   4947  CA  LEU A 596      24.355  23.996  56.977  1.00 66.89           C  
ATOM   4948  C   LEU A 596      25.464  24.632  56.194  1.00 66.72           C  
ATOM   4949  O   LEU A 596      25.575  25.860  56.129  1.00 66.39           O  
ATOM   4950  CB  LEU A 596      23.048  23.989  56.180  1.00 66.59           C  
ATOM   4951  CG  LEU A 596      22.156  22.787  56.470  1.00 66.20           C  
ATOM   4952  CD1 LEU A 596      20.741  22.947  56.019  1.00 66.20           C  
ATOM   4953  CD2 LEU A 596      22.729  21.564  55.814  1.00 67.00           C  
ATOM   4954  N   GLU A 597      26.302  23.783  55.626  1.00 66.52           N  
ATOM   4955  CA  GLU A 597      27.371  24.249  54.768  1.00 66.76           C  
ATOM   4956  C   GLU A 597      27.016  23.682  53.414  1.00 66.18           C  
ATOM   4957  O   GLU A 597      26.689  22.502  53.303  1.00 66.45           O  
ATOM   4958  CB  GLU A 597      28.738  23.776  55.295  1.00 66.50           C  
ATOM   4959  CG  GLU A 597      29.868  23.658  54.282  1.00 67.26           C  
ATOM   4960  CD  GLU A 597      31.050  22.789  54.789  1.00 68.16           C  
ATOM   4961  OE1 GLU A 597      31.170  21.603  54.382  1.00 70.92           O  
ATOM   4962  OE2 GLU A 597      31.862  23.280  55.605  1.00 70.63           O  
ATOM   4963  N   ILE A 598      27.029  24.546  52.400  1.00 65.71           N  
ATOM   4964  CA  ILE A 598      26.677  24.168  51.033  1.00 64.44           C  
ATOM   4965  C   ILE A 598      27.904  24.317  50.163  1.00 64.56           C  
ATOM   4966  O   ILE A 598      28.354  25.430  49.963  1.00 65.00           O  
ATOM   4967  CB  ILE A 598      25.566  25.073  50.500  1.00 63.68           C  
ATOM   4968  CG1 ILE A 598      24.274  24.762  51.248  1.00 62.91           C  
ATOM   4969  CG2 ILE A 598      25.422  24.921  48.982  1.00 62.46           C  
ATOM   4970  CD1 ILE A 598      23.227  25.789  51.112  1.00 62.09           C  
ATOM   4971  N   ILE A 599      28.481  23.226  49.681  1.00 64.29           N  
ATOM   4972  CA  ILE A 599      29.534  23.376  48.705  1.00 65.06           C  
ATOM   4973  C   ILE A 599      28.936  23.147  47.329  1.00 66.58           C  
ATOM   4974  O   ILE A 599      28.424  22.063  47.043  1.00 66.74           O  
ATOM   4975  CB  ILE A 599      30.729  22.443  48.955  1.00 64.72           C  
ATOM   4976  CG1 ILE A 599      31.695  23.047  49.962  1.00 63.15           C  
ATOM   4977  CG2 ILE A 599      31.537  22.229  47.662  1.00 65.50           C  
ATOM   4978  CD1 ILE A 599      31.337  22.804  51.346  1.00 62.84           C  
ATOM   4979  N   LYS A 600      28.995  24.168  46.473  1.00 68.40           N  
ATOM   4980  CA  LYS A 600      28.328  24.100  45.159  1.00 69.59           C  
ATOM   4981  C   LYS A 600      29.206  23.670  44.000  1.00 70.70           C  
ATOM   4982  O   LYS A 600      28.700  23.226  42.983  1.00 71.62           O  
ATOM   4983  CB  LYS A 600      27.681  25.434  44.800  1.00 69.39           C  
ATOM   4984  CG  LYS A 600      28.662  26.457  44.313  1.00 69.59           C  
ATOM   4985  CD  LYS A 600      27.985  27.774  44.076  1.00 68.61           C  
ATOM   4986  CE  LYS A 600      29.024  28.881  44.012  1.00 65.63           C  
ATOM   4987  NZ  LYS A 600      28.391  30.091  44.557  1.00 64.51           N  
ATOM   4988  N   ARG A 601      30.512  23.812  44.106  1.00 71.83           N  
ATOM   4989  CA  ARG A 601      31.316  23.454  42.943  1.00 73.29           C  
ATOM   4990  C   ARG A 601      31.978  22.070  42.985  1.00 72.08           C  
ATOM   4991  O   ARG A 601      32.456  21.624  44.026  1.00 73.65           O  
ATOM   4992  CB  ARG A 601      32.307  24.577  42.604  1.00 74.01           C  
ATOM   4993  CG  ARG A 601      31.638  25.805  41.900  1.00 75.57           C  
ATOM   4994  CD  ARG A 601      32.625  27.008  41.715  1.00 75.76           C  
ATOM   4995  NE  ARG A 601      32.012  28.184  41.055  1.00 80.64           N  
ATOM   4996  CZ  ARG A 601      31.637  29.318  41.683  1.00 85.68           C  
ATOM   4997  NH1 ARG A 601      31.805  29.457  43.013  1.00 86.06           N  
ATOM   4998  NH2 ARG A 601      31.094  30.330  40.981  1.00 85.91           N  
ATOM   4999  N   ASN A 602      31.960  21.386  41.854  1.00 70.45           N  
ATOM   5000  CA  ASN A 602      32.787  20.199  41.620  1.00 69.40           C  
ATOM   5001  C   ASN A 602      32.300  18.926  42.263  1.00 68.36           C  
ATOM   5002  O   ASN A 602      33.093  18.063  42.600  1.00 68.66           O  
ATOM   5003  CB  ASN A 602      34.229  20.438  42.062  1.00 69.65           C  
ATOM   5004  CG  ASN A 602      34.786  21.687  41.493  1.00 69.88           C  
ATOM   5005  OD1 ASN A 602      35.003  21.776  40.285  1.00 70.56           O  
ATOM   5006  ND2 ASN A 602      34.995  22.685  42.344  1.00 69.78           N  
ATOM   5007  N   ASN A 603      30.998  18.804  42.435  1.00 67.09           N  
ATOM   5008  CA  ASN A 603      30.456  17.684  43.150  1.00 65.32           C  
ATOM   5009  C   ASN A 603      30.274  16.603  42.148  1.00 65.14           C  
ATOM   5010  O   ASN A 603      30.357  16.890  40.960  1.00 65.12           O  
ATOM   5011  CB  ASN A 603      29.172  18.103  43.827  1.00 64.48           C  
ATOM   5012  CG  ASN A 603      29.433  19.108  44.926  1.00 64.75           C  
ATOM   5013  OD1 ASN A 603      30.422  19.012  45.648  1.00 64.07           O  
ATOM   5014  ND2 ASN A 603      28.578  20.095  45.037  1.00 67.20           N  
ATOM   5015  N   PRO A 604      30.116  15.340  42.600  1.00 64.77           N  
ATOM   5016  CA  PRO A 604      29.827  14.274  41.662  1.00 64.55           C  
ATOM   5017  C   PRO A 604      28.517  14.534  40.949  1.00 64.72           C  
ATOM   5018  O   PRO A 604      27.641  15.148  41.536  1.00 64.57           O  
ATOM   5019  CB  PRO A 604      29.721  13.072  42.569  1.00 64.26           C  
ATOM   5020  CG  PRO A 604      30.569  13.421  43.711  1.00 63.45           C  
ATOM   5021  CD  PRO A 604      30.252  14.809  43.961  1.00 64.16           C  
ATOM   5022  N   ARG A 605      28.419  14.116  39.686  1.00 65.25           N  
ATOM   5023  CA  ARG A 605      27.244  14.365  38.842  1.00 65.86           C  
ATOM   5024  C   ARG A 605      26.288  13.201  38.996  1.00 65.60           C  
ATOM   5025  O   ARG A 605      26.687  12.143  39.489  1.00 66.14           O  
ATOM   5026  CB  ARG A 605      27.653  14.451  37.382  1.00 66.22           C  
ATOM   5027  CG  ARG A 605      28.503  15.646  37.004  1.00 69.42           C  
ATOM   5028  CD  ARG A 605      29.341  15.278  35.778  1.00 76.25           C  
ATOM   5029  NE  ARG A 605      30.299  16.328  35.447  1.00 83.66           N  
ATOM   5030  CZ  ARG A 605      30.021  17.379  34.673  1.00 88.99           C  
ATOM   5031  NH1 ARG A 605      28.816  17.500  34.118  1.00 90.75           N  
ATOM   5032  NH2 ARG A 605      30.948  18.314  34.439  1.00 90.89           N  
ATOM   5033  N   PHE A 606      25.034  13.393  38.591  1.00 64.96           N  
ATOM   5034  CA  PHE A 606      24.087  12.289  38.467  1.00 64.74           C  
ATOM   5035  C   PHE A 606      23.927  12.024  36.970  1.00 65.53           C  
ATOM   5036  O   PHE A 606      23.590  12.955  36.222  1.00 66.23           O  
ATOM   5037  CB  PHE A 606      22.717  12.699  38.971  1.00 63.87           C  
ATOM   5038  CG  PHE A 606      22.587  12.773  40.446  1.00 63.24           C  
ATOM   5039  CD1 PHE A 606      22.686  13.992  41.100  1.00 60.59           C  
ATOM   5040  CD2 PHE A 606      22.292  11.621  41.195  1.00 65.00           C  
ATOM   5041  CE1 PHE A 606      22.521  14.079  42.466  1.00 59.64           C  
ATOM   5042  CE2 PHE A 606      22.112  11.684  42.583  1.00 62.32           C  
ATOM   5043  CZ  PHE A 606      22.224  12.923  43.215  1.00 62.33           C  
ATOM   5044  N   PHE A 607      24.147  10.784  36.524  1.00 65.65           N  
ATOM   5045  CA  PHE A 607      23.858  10.387  35.143  1.00 65.68           C  
ATOM   5046  C   PHE A 607      22.621   9.541  35.152  1.00 67.14           C  
ATOM   5047  O   PHE A 607      22.557   8.551  35.897  1.00 67.93           O  
ATOM   5048  CB  PHE A 607      24.969   9.553  34.589  1.00 64.81           C  
ATOM   5049  CG  PHE A 607      26.278  10.205  34.657  1.00 63.43           C  
ATOM   5050  CD1 PHE A 607      26.879  10.439  35.874  1.00 64.87           C  
ATOM   5051  CD2 PHE A 607      26.922  10.582  33.509  1.00 62.65           C  
ATOM   5052  CE1 PHE A 607      28.095  11.049  35.930  1.00 67.20           C  
ATOM   5053  CE2 PHE A 607      28.147  11.194  33.546  1.00 62.66           C  
ATOM   5054  CZ  PHE A 607      28.741  11.438  34.738  1.00 64.74           C  
ATOM   5055  N   SER A 608      21.643   9.915  34.330  1.00 68.24           N  
ATOM   5056  CA  SER A 608      20.311   9.356  34.459  1.00 69.55           C  
ATOM   5057  C   SER A 608      19.434   9.710  33.293  1.00 70.61           C  
ATOM   5058  O   SER A 608      19.586  10.741  32.675  1.00 70.94           O  
ATOM   5059  CB  SER A 608      19.653   9.856  35.761  1.00 69.33           C  
ATOM   5060  OG  SER A 608      18.288   9.454  35.864  1.00 69.06           O  
ATOM   5061  N   ASN A 609      18.477   8.847  33.032  1.00 72.58           N  
ATOM   5062  CA  ASN A 609      17.485   9.075  31.999  1.00 74.30           C  
ATOM   5063  C   ASN A 609      16.351  10.006  32.409  1.00 75.53           C  
ATOM   5064  O   ASN A 609      15.861  10.764  31.581  1.00 76.62           O  
ATOM   5065  CB  ASN A 609      16.931   7.737  31.517  1.00 74.35           C  
ATOM   5066  CG  ASN A 609      17.832   7.100  30.494  1.00 74.74           C  
ATOM   5067  OD1 ASN A 609      18.368   7.820  29.645  1.00 74.57           O  
ATOM   5068  ND2 ASN A 609      18.046   5.761  30.580  1.00 72.10           N  
ATOM   5069  N   GLU A 610      15.923   9.963  33.662  1.00 76.26           N  
ATOM   5070  CA  GLU A 610      14.902  10.887  34.093  1.00 77.57           C  
ATOM   5071  C   GLU A 610      15.292  12.376  33.909  1.00 77.64           C  
ATOM   5072  O   GLU A 610      16.319  12.821  34.447  1.00 78.43           O  
ATOM   5073  CB  GLU A 610      14.550  10.643  35.531  1.00 77.55           C  
ATOM   5074  CG  GLU A 610      13.576  11.690  35.934  1.00 82.62           C  
ATOM   5075  CD  GLU A 610      12.348  11.114  36.562  1.00 91.33           C  
ATOM   5076  OE1 GLU A 610      12.275   9.852  36.690  1.00 94.43           O  
ATOM   5077  OE2 GLU A 610      11.464  11.930  36.948  1.00 94.05           O  
ATOM   5078  N   LYS A 611      14.481  13.149  33.178  1.00 77.04           N  
ATOM   5079  CA  LYS A 611      14.762  14.575  33.021  1.00 76.56           C  
ATOM   5080  C   LYS A 611      14.499  15.345  34.297  1.00 75.48           C  
ATOM   5081  O   LYS A 611      15.026  16.431  34.467  1.00 75.22           O  
ATOM   5082  CB  LYS A 611      13.900  15.194  31.926  1.00 77.23           C  
ATOM   5083  CG  LYS A 611      14.349  16.630  31.511  1.00 78.40           C  
ATOM   5084  CD  LYS A 611      13.224  17.408  30.786  1.00 77.74           C  
ATOM   5085  CE  LYS A 611      13.647  18.864  30.417  1.00 79.08           C  
ATOM   5086  NZ  LYS A 611      12.663  19.644  29.512  1.00 78.89           N  
ATOM   5087  N   PHE A 612      13.655  14.797  35.174  1.00 74.56           N  
ATOM   5088  CA  PHE A 612      13.148  15.542  36.331  1.00 73.29           C  
ATOM   5089  C   PHE A 612      13.805  15.080  37.613  1.00 72.52           C  
ATOM   5090  O   PHE A 612      13.208  14.395  38.455  1.00 72.98           O  
ATOM   5091  CB  PHE A 612      11.627  15.532  36.362  1.00 73.17           C  
ATOM   5092  CG  PHE A 612      11.046  16.128  35.144  1.00 74.68           C  
ATOM   5093  CD1 PHE A 612      10.642  15.324  34.084  1.00 76.40           C  
ATOM   5094  CD2 PHE A 612      11.024  17.509  34.981  1.00 76.31           C  
ATOM   5095  CE1 PHE A 612      10.173  15.893  32.902  1.00 76.37           C  
ATOM   5096  CE2 PHE A 612      10.535  18.092  33.806  1.00 75.41           C  
ATOM   5097  CZ  PHE A 612      10.113  17.290  32.771  1.00 75.63           C  
ATOM   5098  N   ILE A 613      15.058  15.502  37.731  1.00 70.56           N  
ATOM   5099  CA  ILE A 613      15.982  15.068  38.733  1.00 69.03           C  
ATOM   5100  C   ILE A 613      15.834  15.769  40.092  1.00 67.87           C  
ATOM   5101  O   ILE A 613      15.990  15.147  41.113  1.00 67.76           O  
ATOM   5102  CB  ILE A 613      17.384  15.232  38.166  1.00 69.47           C  
ATOM   5103  CG1 ILE A 613      17.799  13.944  37.476  1.00 69.06           C  
ATOM   5104  CG2 ILE A 613      18.405  15.574  39.244  1.00 70.49           C  
ATOM   5105  CD1 ILE A 613      19.210  14.024  37.084  1.00 70.90           C  
ATOM   5106  N   LYS A 614      15.579  17.069  40.087  1.00 66.73           N  
ATOM   5107  CA  LYS A 614      15.245  17.835  41.282  1.00 65.00           C  
ATOM   5108  C   LYS A 614      14.810  16.899  42.403  1.00 65.22           C  
ATOM   5109  O   LYS A 614      13.822  16.191  42.254  1.00 65.07           O  
ATOM   5110  CB  LYS A 614      14.089  18.794  40.933  1.00 64.34           C  
ATOM   5111  CG  LYS A 614      14.295  20.263  41.239  1.00 59.33           C  
ATOM   5112  CD  LYS A 614      13.645  20.673  42.518  1.00 54.38           C  
ATOM   5113  CE  LYS A 614      13.182  22.141  42.504  1.00 56.72           C  
ATOM   5114  NZ  LYS A 614      14.192  23.276  42.506  1.00 54.31           N  
ATOM   5115  N   GLY A 615      15.549  16.898  43.513  1.00 65.71           N  
ATOM   5116  CA  GLY A 615      15.267  16.016  44.677  1.00 66.32           C  
ATOM   5117  C   GLY A 615      16.079  14.709  44.786  1.00 66.63           C  
ATOM   5118  O   GLY A 615      16.164  14.087  45.847  1.00 66.74           O  
ATOM   5119  N   TYR A 616      16.663  14.272  43.676  1.00 66.92           N  
ATOM   5120  CA  TYR A 616      17.536  13.121  43.673  1.00 66.93           C  
ATOM   5121  C   TYR A 616      18.685  13.368  44.631  1.00 67.00           C  
ATOM   5122  O   TYR A 616      19.175  14.503  44.749  1.00 67.60           O  
ATOM   5123  CB  TYR A 616      18.058  12.893  42.271  1.00 67.14           C  
ATOM   5124  CG  TYR A 616      17.202  11.941  41.458  1.00 69.10           C  
ATOM   5125  CD1 TYR A 616      15.885  12.271  41.089  1.00 69.84           C  
ATOM   5126  CD2 TYR A 616      17.707  10.698  41.053  1.00 69.90           C  
ATOM   5127  CE1 TYR A 616      15.104  11.384  40.343  1.00 69.11           C  
ATOM   5128  CE2 TYR A 616      16.927   9.810  40.317  1.00 69.37           C  
ATOM   5129  CZ  TYR A 616      15.640  10.162  39.973  1.00 68.59           C  
ATOM   5130  OH  TYR A 616      14.913   9.285  39.237  1.00 69.83           O  
ATOM   5131  N   PHE A 617      19.100  12.332  45.353  1.00 66.32           N  
ATOM   5132  CA  PHE A 617      20.176  12.512  46.306  1.00 65.50           C  
ATOM   5133  C   PHE A 617      20.974  11.262  46.608  1.00 64.60           C  
ATOM   5134  O   PHE A 617      20.555  10.128  46.323  1.00 64.15           O  
ATOM   5135  CB  PHE A 617      19.632  13.093  47.611  1.00 66.22           C  
ATOM   5136  CG  PHE A 617      18.931  12.088  48.475  1.00 67.97           C  
ATOM   5137  CD1 PHE A 617      19.396  11.810  49.746  1.00 67.33           C  
ATOM   5138  CD2 PHE A 617      17.808  11.399  48.010  1.00 70.19           C  
ATOM   5139  CE1 PHE A 617      18.748  10.867  50.550  1.00 66.39           C  
ATOM   5140  CE2 PHE A 617      17.177  10.438  48.818  1.00 70.32           C  
ATOM   5141  CZ  PHE A 617      17.661  10.187  50.085  1.00 66.93           C  
ATOM   5142  N   TYR A 618      22.119  11.507  47.229  1.00 63.34           N  
ATOM   5143  CA  TYR A 618      23.014  10.475  47.695  1.00 62.73           C  
ATOM   5144  C   TYR A 618      23.606  10.906  49.049  1.00 63.82           C  
ATOM   5145  O   TYR A 618      23.726  12.087  49.276  1.00 64.72           O  
ATOM   5146  CB  TYR A 618      24.092  10.283  46.669  1.00 60.56           C  
ATOM   5147  CG  TYR A 618      25.048   9.179  46.966  1.00 57.18           C  
ATOM   5148  CD1 TYR A 618      24.827   7.908  46.475  1.00 52.76           C  
ATOM   5149  CD2 TYR A 618      26.193   9.415  47.722  1.00 53.22           C  
ATOM   5150  CE1 TYR A 618      25.695   6.912  46.724  1.00 52.23           C  
ATOM   5151  CE2 TYR A 618      27.068   8.425  47.976  1.00 52.31           C  
ATOM   5152  CZ  TYR A 618      26.817   7.182  47.461  1.00 54.79           C  
ATOM   5153  OH  TYR A 618      27.704   6.184  47.692  1.00 58.01           O  
ATOM   5154  N   LYS A 619      23.950   9.972  49.945  1.00 64.94           N  
ATOM   5155  CA  LYS A 619      24.317  10.325  51.308  1.00 65.91           C  
ATOM   5156  C   LYS A 619      25.730   9.870  51.611  1.00 66.29           C  
ATOM   5157  O   LYS A 619      26.007   8.682  51.545  1.00 66.32           O  
ATOM   5158  CB  LYS A 619      23.322   9.714  52.300  1.00 66.32           C  
ATOM   5159  CG  LYS A 619      22.774  10.687  53.383  1.00 67.61           C  
ATOM   5160  CD  LYS A 619      22.373   9.936  54.695  1.00 66.81           C  
ATOM   5161  CE  LYS A 619      22.155  10.870  55.899  1.00 68.10           C  
ATOM   5162  NZ  LYS A 619      21.962  10.190  57.227  1.00 68.82           N  
ATOM   5163  N   LEU A 620      26.610  10.831  51.913  1.00 67.00           N  
ATOM   5164  CA  LEU A 620      27.990  10.592  52.329  1.00 68.04           C  
ATOM   5165  C   LEU A 620      28.187  10.514  53.865  1.00 69.97           C  
ATOM   5166  O   LEU A 620      27.231  10.597  54.662  1.00 70.89           O  
ATOM   5167  CB  LEU A 620      28.867  11.715  51.805  1.00 67.18           C  
ATOM   5168  CG  LEU A 620      28.894  11.974  50.307  1.00 66.78           C  
ATOM   5169  CD1 LEU A 620      29.227  13.408  50.063  1.00 66.08           C  
ATOM   5170  CD2 LEU A 620      29.903  11.089  49.591  1.00 67.07           C  
ATOM   5171  N   SER A 621      29.438  10.389  54.293  1.00 71.33           N  
ATOM   5172  CA  SER A 621      29.754  10.466  55.708  1.00 72.71           C  
ATOM   5173  C   SER A 621      29.311  11.776  56.342  1.00 73.43           C  
ATOM   5174  O   SER A 621      29.038  12.758  55.664  1.00 73.88           O  
ATOM   5175  CB  SER A 621      31.250  10.331  55.915  1.00 72.65           C  
ATOM   5176  OG  SER A 621      31.543   9.020  56.304  1.00 74.94           O  
ATOM   5177  N   GLU A 622      29.267  11.781  57.663  1.00 74.18           N  
ATOM   5178  CA  GLU A 622      29.143  13.014  58.419  1.00 74.56           C  
ATOM   5179  C   GLU A 622      28.013  13.919  57.981  1.00 73.08           C  
ATOM   5180  O   GLU A 622      28.214  15.119  57.879  1.00 73.88           O  
ATOM   5181  CB  GLU A 622      30.476  13.755  58.410  1.00 75.25           C  
ATOM   5182  CG  GLU A 622      31.306  13.451  59.668  1.00 81.55           C  
ATOM   5183  CD  GLU A 622      32.753  13.020  59.354  1.00 88.56           C  
ATOM   5184  OE1 GLU A 622      33.452  13.758  58.592  1.00 90.43           O  
ATOM   5185  OE2 GLU A 622      33.182  11.947  59.878  1.00 90.29           O  
ATOM   5186  N   ASP A 623      26.839  13.341  57.722  1.00 71.33           N  
ATOM   5187  CA  ASP A 623      25.607  14.104  57.473  1.00 69.77           C  
ATOM   5188  C   ASP A 623      25.641  15.027  56.287  1.00 67.86           C  
ATOM   5189  O   ASP A 623      25.156  16.146  56.343  1.00 67.23           O  
ATOM   5190  CB  ASP A 623      25.190  14.892  58.705  1.00 70.46           C  
ATOM   5191  CG  ASP A 623      24.317  14.091  59.620  1.00 73.24           C  
ATOM   5192  OD1 ASP A 623      23.596  13.190  59.102  1.00 76.44           O  
ATOM   5193  OD2 ASP A 623      24.369  14.353  60.848  1.00 76.18           O  
ATOM   5194  N   SER A 624      26.217  14.539  55.206  1.00 66.62           N  
ATOM   5195  CA  SER A 624      26.311  15.307  53.984  1.00 65.65           C  
ATOM   5196  C   SER A 624      25.751  14.529  52.786  1.00 64.79           C  
ATOM   5197  O   SER A 624      25.764  13.292  52.741  1.00 65.13           O  
ATOM   5198  CB  SER A 624      27.741  15.706  53.730  1.00 65.19           C  
ATOM   5199  OG  SER A 624      28.376  14.541  53.329  1.00 66.24           O  
ATOM   5200  N   VAL A 625      25.277  15.289  51.815  1.00 63.25           N  
ATOM   5201  CA  VAL A 625      24.315  14.817  50.862  1.00 61.91           C  
ATOM   5202  C   VAL A 625      24.575  15.445  49.489  1.00 61.79           C  
ATOM   5203  O   VAL A 625      24.474  16.651  49.322  1.00 62.24           O  
ATOM   5204  CB  VAL A 625      22.903  15.259  51.308  1.00 61.50           C  
ATOM   5205  CG1 VAL A 625      21.881  14.868  50.275  1.00 60.11           C  
ATOM   5206  CG2 VAL A 625      22.575  14.712  52.672  1.00 59.78           C  
ATOM   5207  N   ILE A 626      24.899  14.644  48.496  1.00 61.00           N  
ATOM   5208  CA  ILE A 626      24.850  15.177  47.156  1.00 60.49           C  
ATOM   5209  C   ILE A 626      23.389  15.401  46.761  1.00 60.42           C  
ATOM   5210  O   ILE A 626      22.644  14.469  46.569  1.00 60.80           O  
ATOM   5211  CB  ILE A 626      25.635  14.313  46.156  1.00 59.86           C  
ATOM   5212  CG1 ILE A 626      27.108  14.425  46.501  1.00 58.99           C  
ATOM   5213  CG2 ILE A 626      25.478  14.852  44.746  1.00 58.95           C  
ATOM   5214  CD1 ILE A 626      27.784  13.127  46.523  1.00 59.32           C  
ATOM   5215  N   LEU A 627      22.987  16.652  46.653  1.00 60.58           N  
ATOM   5216  CA  LEU A 627      21.626  16.973  46.285  1.00 60.92           C  
ATOM   5217  C   LEU A 627      21.551  17.651  44.924  1.00 61.60           C  
ATOM   5218  O   LEU A 627      22.288  18.581  44.667  1.00 61.83           O  
ATOM   5219  CB  LEU A 627      21.026  17.876  47.346  1.00 60.32           C  
ATOM   5220  CG  LEU A 627      19.607  18.341  47.160  1.00 59.56           C  
ATOM   5221  CD1 LEU A 627      18.755  17.153  46.875  1.00 61.84           C  
ATOM   5222  CD2 LEU A 627      19.191  18.971  48.430  1.00 59.21           C  
ATOM   5223  N   ALA A 628      20.657  17.182  44.064  1.00 62.25           N  
ATOM   5224  CA  ALA A 628      20.362  17.858  42.809  1.00 63.20           C  
ATOM   5225  C   ALA A 628      19.144  18.801  42.955  1.00 63.98           C  
ATOM   5226  O   ALA A 628      18.103  18.420  43.508  1.00 64.10           O  
ATOM   5227  CB  ALA A 628      20.123  16.836  41.728  1.00 63.04           C  
ATOM   5228  N   THR A 629      19.283  20.028  42.456  1.00 64.61           N  
ATOM   5229  CA  THR A 629      18.285  21.070  42.681  1.00 65.23           C  
ATOM   5230  C   THR A 629      17.490  21.469  41.458  1.00 66.40           C  
ATOM   5231  O   THR A 629      16.356  21.856  41.564  1.00 66.15           O  
ATOM   5232  CB  THR A 629      18.933  22.345  43.072  1.00 64.84           C  
ATOM   5233  OG1 THR A 629      19.871  22.102  44.104  1.00 64.74           O  
ATOM   5234  CG2 THR A 629      17.882  23.284  43.550  1.00 65.66           C  
ATOM   5235  N   TYR A 630      18.111  21.459  40.296  1.00 68.76           N  
ATOM   5236  CA  TYR A 630      17.400  21.821  39.098  1.00 70.55           C  
ATOM   5237  C   TYR A 630      17.321  20.602  38.233  1.00 72.01           C  
ATOM   5238  O   TYR A 630      18.077  19.631  38.444  1.00 71.39           O  
ATOM   5239  CB  TYR A 630      18.052  23.015  38.392  1.00 71.02           C  
ATOM   5240  CG  TYR A 630      19.505  22.869  37.969  1.00 70.93           C  
ATOM   5241  CD1 TYR A 630      19.835  22.650  36.611  1.00 71.39           C  
ATOM   5242  CD2 TYR A 630      20.546  23.005  38.895  1.00 68.73           C  
ATOM   5243  CE1 TYR A 630      21.162  22.538  36.187  1.00 70.63           C  
ATOM   5244  CE2 TYR A 630      21.877  22.885  38.493  1.00 70.00           C  
ATOM   5245  CZ  TYR A 630      22.182  22.644  37.138  1.00 71.69           C  
ATOM   5246  OH  TYR A 630      23.498  22.519  36.730  1.00 72.02           O  
ATOM   5247  N   ASN A 631      16.357  20.622  37.311  1.00 73.95           N  
ATOM   5248  CA  ASN A 631      16.193  19.504  36.394  1.00 75.88           C  
ATOM   5249  C   ASN A 631      17.193  19.633  35.282  1.00 77.94           C  
ATOM   5250  O   ASN A 631      17.781  20.701  35.099  1.00 78.44           O  
ATOM   5251  CB  ASN A 631      14.795  19.434  35.839  1.00 74.89           C  
ATOM   5252  CG  ASN A 631      13.780  19.300  36.901  1.00 73.75           C  
ATOM   5253  OD1 ASN A 631      13.712  18.298  37.585  1.00 72.70           O  
ATOM   5254  ND2 ASN A 631      12.974  20.319  37.060  1.00 73.97           N  
ATOM   5255  N   GLN A 632      17.413  18.533  34.574  1.00 80.45           N  
ATOM   5256  CA  GLN A 632      18.338  18.506  33.452  1.00 83.23           C  
ATOM   5257  C   GLN A 632      17.937  19.429  32.270  1.00 85.70           C  
ATOM   5258  O   GLN A 632      16.810  19.352  31.730  1.00 86.00           O  
ATOM   5259  CB  GLN A 632      18.549  17.058  32.979  1.00 83.13           C  
ATOM   5260  CG  GLN A 632      19.809  16.422  33.561  1.00 82.43           C  
ATOM   5261  CD  GLN A 632      19.841  14.910  33.496  1.00 80.58           C  
ATOM   5262  OE1 GLN A 632      18.807  14.235  33.504  1.00 77.06           O  
ATOM   5263  NE2 GLN A 632      21.051  14.367  33.464  1.00 80.76           N  
ATOM   5264  N   VAL A 633      18.852  20.323  31.902  1.00 88.06           N  
ATOM   5265  CA  VAL A 633      18.737  20.975  30.623  1.00 90.56           C  
ATOM   5266  C   VAL A 633      19.655  20.187  29.710  1.00 92.38           C  
ATOM   5267  O   VAL A 633      20.566  19.515  30.195  1.00 92.76           O  
ATOM   5268  CB  VAL A 633      19.150  22.442  30.655  1.00 90.68           C  
ATOM   5269  CG1 VAL A 633      18.287  23.217  29.658  1.00 90.60           C  
ATOM   5270  CG2 VAL A 633      19.020  23.035  32.077  1.00 90.65           C  
ATOM   5271  N   TYR A 634      19.388  20.235  28.407  1.00 94.67           N  
ATOM   5272  CA  TYR A 634      20.243  19.595  27.403  1.00 96.71           C  
ATOM   5273  C   TYR A 634      21.473  20.465  27.189  1.00 97.81           C  
ATOM   5274  O   TYR A 634      22.595  19.944  27.171  1.00 98.11           O  
ATOM   5275  CB  TYR A 634      19.478  19.374  26.086  1.00 97.35           C  
ATOM   5276  CG  TYR A 634      20.282  18.992  24.824  1.00 98.15           C  
ATOM   5277  CD1 TYR A 634      20.225  17.691  24.298  1.00 98.30           C  
ATOM   5278  CD2 TYR A 634      21.033  19.954  24.117  1.00 98.63           C  
ATOM   5279  CE1 TYR A 634      20.922  17.344  23.123  1.00 98.70           C  
ATOM   5280  CE2 TYR A 634      21.740  19.616  22.940  1.00 99.24           C  
ATOM   5281  CZ  TYR A 634      21.674  18.312  22.449  1.00 99.35           C  
ATOM   5282  OH  TYR A 634      22.368  17.976  21.298  1.00 99.40           O  
ATOM   5283  N   GLU A 635      21.269  21.781  27.033  1.00 98.90           N  
ATOM   5284  CA  GLU A 635      22.408  22.687  26.798  1.00 99.70           C  
ATOM   5285  C   GLU A 635      23.373  22.557  27.980  1.00 99.40           C  
ATOM   5286  O   GLU A 635      24.538  22.143  27.800  1.00 99.32           O  
ATOM   5287  CB  GLU A 635      22.006  24.170  26.619  1.00 99.96           C  
ATOM   5288  CG  GLU A 635      20.517  24.484  26.543  1.00101.85           C  
ATOM   5289  CD  GLU A 635      20.127  25.565  27.562  1.00104.54           C  
ATOM   5290  OE1 GLU A 635      20.841  25.710  28.586  1.00105.50           O  
ATOM   5291  OE2 GLU A 635      19.104  26.256  27.361  1.00104.83           O  
ATOM   5292  N   GLY A 636      22.851  22.870  29.177  1.00 98.94           N  
ATOM   5293  CA  GLY A 636      23.628  22.954  30.434  1.00 97.72           C  
ATOM   5294  C   GLY A 636      24.457  21.741  30.812  1.00 96.39           C  
ATOM   5295  O   GLY A 636      24.299  20.661  30.231  1.00 96.29           O  
ATOM   5296  N   THR A 637      25.363  21.939  31.770  1.00 95.12           N  
ATOM   5297  CA  THR A 637      26.053  20.826  32.449  1.00 93.93           C  
ATOM   5298  C   THR A 637      25.545  20.771  33.897  1.00 91.83           C  
ATOM   5299  O   THR A 637      25.982  21.565  34.728  1.00 91.80           O  
ATOM   5300  CB  THR A 637      27.622  20.985  32.422  1.00 94.63           C  
ATOM   5301  OG1 THR A 637      28.111  21.023  31.066  1.00 96.10           O  
ATOM   5302  CG2 THR A 637      28.306  19.852  33.170  1.00 94.09           C  
ATOM   5303  N   HIS A 638      24.610  19.857  34.181  1.00 89.28           N  
ATOM   5304  CA  HIS A 638      24.018  19.734  35.526  1.00 86.79           C  
ATOM   5305  C   HIS A 638      25.092  19.432  36.587  1.00 84.88           C  
ATOM   5306  O   HIS A 638      25.840  18.445  36.478  1.00 84.79           O  
ATOM   5307  CB  HIS A 638      22.837  18.701  35.587  1.00 87.08           C  
ATOM   5308  CG  HIS A 638      22.383  18.363  36.991  1.00 86.48           C  
ATOM   5309  ND1 HIS A 638      21.271  18.934  37.581  1.00 85.21           N  
ATOM   5310  CD2 HIS A 638      22.912  17.532  37.928  1.00 85.53           C  
ATOM   5311  CE1 HIS A 638      21.145  18.483  38.817  1.00 84.38           C  
ATOM   5312  NE2 HIS A 638      22.125  17.628  39.052  1.00 83.82           N  
ATOM   5313  N   GLN A 639      25.164  20.298  37.593  1.00 82.01           N  
ATOM   5314  CA  GLN A 639      26.005  20.048  38.734  1.00 79.96           C  
ATOM   5315  C   GLN A 639      25.190  20.239  39.999  1.00 77.96           C  
ATOM   5316  O   GLN A 639      24.684  21.336  40.257  1.00 77.76           O  
ATOM   5317  CB  GLN A 639      27.224  20.951  38.731  1.00 80.34           C  
ATOM   5318  CG  GLN A 639      28.314  20.539  37.780  1.00 82.61           C  
ATOM   5319  CD  GLN A 639      28.940  21.751  37.092  1.00 87.26           C  
ATOM   5320  OE1 GLN A 639      29.067  22.827  37.690  1.00 87.45           O  
ATOM   5321  NE2 GLN A 639      29.320  21.586  35.817  1.00 89.78           N  
ATOM   5322  N   PRO A 640      25.027  19.154  40.779  1.00 75.85           N  
ATOM   5323  CA  PRO A 640      24.350  19.225  42.049  1.00 74.31           C  
ATOM   5324  C   PRO A 640      25.187  19.857  43.126  1.00 72.77           C  
ATOM   5325  O   PRO A 640      26.394  20.027  43.001  1.00 72.32           O  
ATOM   5326  CB  PRO A 640      24.136  17.759  42.403  1.00 74.32           C  
ATOM   5327  CG  PRO A 640      25.237  17.081  41.776  1.00 74.75           C  
ATOM   5328  CD  PRO A 640      25.434  17.774  40.477  1.00 75.56           C  
ATOM   5329  N   ILE A 641      24.511  20.139  44.208  1.00 71.25           N  
ATOM   5330  CA  ILE A 641      25.066  20.802  45.322  1.00 70.15           C  
ATOM   5331  C   ILE A 641      25.366  19.808  46.467  1.00 69.89           C  
ATOM   5332  O   ILE A 641      24.762  18.733  46.570  1.00 69.68           O  
ATOM   5333  CB  ILE A 641      24.086  21.894  45.653  1.00 70.03           C  
ATOM   5334  CG1 ILE A 641      24.787  23.211  45.451  1.00 71.26           C  
ATOM   5335  CG2 ILE A 641      23.398  21.730  47.002  1.00 69.07           C  
ATOM   5336  CD1 ILE A 641      24.034  24.114  44.472  1.00 74.00           C  
ATOM   5337  N   LYS A 642      26.349  20.138  47.294  1.00 69.07           N  
ATOM   5338  CA  LYS A 642      26.649  19.300  48.434  1.00 68.30           C  
ATOM   5339  C   LYS A 642      26.260  20.037  49.702  1.00 68.41           C  
ATOM   5340  O   LYS A 642      26.727  21.137  49.980  1.00 68.82           O  
ATOM   5341  CB  LYS A 642      28.107  18.889  48.450  1.00 67.80           C  
ATOM   5342  CG  LYS A 642      28.511  18.230  49.725  1.00 66.28           C  
ATOM   5343  CD  LYS A 642      29.646  17.275  49.515  1.00 66.58           C  
ATOM   5344  CE  LYS A 642      30.998  17.956  49.416  1.00 67.20           C  
ATOM   5345  NZ  LYS A 642      31.957  17.000  50.024  1.00 70.61           N  
ATOM   5346  N   VAL A 643      25.361  19.424  50.447  1.00 68.51           N  
ATOM   5347  CA  VAL A 643      24.798  20.023  51.639  1.00 68.57           C  
ATOM   5348  C   VAL A 643      25.311  19.156  52.774  1.00 68.85           C  
ATOM   5349  O   VAL A 643      25.447  17.947  52.610  1.00 69.03           O  
ATOM   5350  CB  VAL A 643      23.252  19.976  51.600  1.00 68.41           C  
ATOM   5351  CG1 VAL A 643      22.667  20.388  52.914  1.00 67.20           C  
ATOM   5352  CG2 VAL A 643      22.699  20.841  50.477  1.00 67.92           C  
ATOM   5353  N   ARG A 644      25.581  19.768  53.917  1.00 68.66           N  
ATOM   5354  CA  ARG A 644      26.292  19.116  54.968  1.00 68.37           C  
ATOM   5355  C   ARG A 644      25.781  19.722  56.226  1.00 68.08           C  
ATOM   5356  O   ARG A 644      25.848  20.955  56.400  1.00 68.45           O  
ATOM   5357  CB  ARG A 644      27.767  19.442  54.826  1.00 68.83           C  
ATOM   5358  CG  ARG A 644      28.665  18.529  55.626  1.00 70.90           C  
ATOM   5359  CD  ARG A 644      29.994  19.188  55.900  1.00 72.11           C  
ATOM   5360  NE  ARG A 644      30.280  19.035  57.310  1.00 74.79           N  
ATOM   5361  CZ  ARG A 644      31.002  19.888  58.026  1.00 76.47           C  
ATOM   5362  NH1 ARG A 644      31.541  20.968  57.456  1.00 77.28           N  
ATOM   5363  NH2 ARG A 644      31.175  19.660  59.324  1.00 76.70           N  
ATOM   5364  N   LYS A 645      25.264  18.869  57.102  1.00 67.40           N  
ATOM   5365  CA  LYS A 645      24.722  19.316  58.373  1.00 66.86           C  
ATOM   5366  C   LYS A 645      25.859  19.387  59.339  1.00 66.76           C  
ATOM   5367  O   LYS A 645      26.319  18.386  59.826  1.00 66.97           O  
ATOM   5368  CB  LYS A 645      23.674  18.332  58.874  1.00 66.82           C  
ATOM   5369  CG  LYS A 645      22.962  18.745  60.132  1.00 66.26           C  
ATOM   5370  CD  LYS A 645      22.895  17.550  61.031  1.00 64.68           C  
ATOM   5371  CE  LYS A 645      21.889  17.710  62.151  1.00 62.34           C  
ATOM   5372  NZ  LYS A 645      21.473  16.350  62.653  1.00 58.88           N  
ATOM   5373  N   VAL A 646      26.335  20.584  59.598  1.00 67.53           N  
ATOM   5374  CA  VAL A 646      27.481  20.749  60.476  1.00 68.27           C  
ATOM   5375  C   VAL A 646      27.074  20.578  61.905  1.00 69.09           C  
ATOM   5376  O   VAL A 646      27.878  20.086  62.676  1.00 69.45           O  
ATOM   5377  CB  VAL A 646      28.154  22.108  60.329  1.00 68.16           C  
ATOM   5378  CG1 VAL A 646      29.020  22.405  61.537  1.00 68.14           C  
ATOM   5379  CG2 VAL A 646      28.980  22.127  59.099  1.00 68.27           C  
ATOM   5380  N   TYR A 647      25.861  21.016  62.266  1.00 70.24           N  
ATOM   5381  CA  TYR A 647      25.236  20.598  63.531  1.00 71.69           C  
ATOM   5382  C   TYR A 647      23.721  20.817  63.607  1.00 71.91           C  
ATOM   5383  O   TYR A 647      23.185  21.643  62.889  1.00 71.98           O  
ATOM   5384  CB  TYR A 647      25.970  21.193  64.750  1.00 72.35           C  
ATOM   5385  CG  TYR A 647      25.520  22.560  65.192  1.00 73.40           C  
ATOM   5386  CD1 TYR A 647      24.563  22.699  66.195  1.00 73.77           C  
ATOM   5387  CD2 TYR A 647      26.071  23.714  64.639  1.00 74.72           C  
ATOM   5388  CE1 TYR A 647      24.137  23.944  66.627  1.00 74.08           C  
ATOM   5389  CE2 TYR A 647      25.648  24.993  65.059  1.00 75.26           C  
ATOM   5390  CZ  TYR A 647      24.670  25.094  66.060  1.00 74.97           C  
ATOM   5391  OH  TYR A 647      24.231  26.337  66.513  1.00 75.15           O  
ATOM   5392  N   GLY A 648      23.037  20.068  64.472  1.00 72.08           N  
ATOM   5393  CA  GLY A 648      21.617  20.318  64.696  1.00 72.59           C  
ATOM   5394  C   GLY A 648      20.683  19.131  64.903  1.00 73.05           C  
ATOM   5395  O   GLY A 648      20.984  18.008  64.517  1.00 73.01           O  
ATOM   5396  N   GLU A 649      19.525  19.414  65.498  1.00 73.23           N  
ATOM   5397  CA  GLU A 649      18.549  18.411  65.893  1.00 73.28           C  
ATOM   5398  C   GLU A 649      17.721  17.800  64.756  1.00 73.22           C  
ATOM   5399  O   GLU A 649      16.964  16.868  65.023  1.00 73.91           O  
ATOM   5400  CB  GLU A 649      17.574  19.021  66.895  1.00 73.32           C  
ATOM   5401  CG  GLU A 649      18.225  19.765  68.020  1.00 76.27           C  
ATOM   5402  CD  GLU A 649      17.447  19.663  69.343  1.00 81.00           C  
ATOM   5403  OE1 GLU A 649      17.327  18.530  69.892  1.00 81.71           O  
ATOM   5404  OE2 GLU A 649      16.994  20.731  69.848  1.00 82.74           O  
ATOM   5405  N   LEU A 650      17.814  18.310  63.519  1.00 72.40           N  
ATOM   5406  CA  LEU A 650      16.989  17.773  62.423  1.00 71.43           C  
ATOM   5407  C   LEU A 650      17.749  16.849  61.468  1.00 70.82           C  
ATOM   5408  O   LEU A 650      18.967  16.949  61.340  1.00 70.83           O  
ATOM   5409  CB  LEU A 650      16.321  18.893  61.634  1.00 71.56           C  
ATOM   5410  CG  LEU A 650      14.956  19.347  62.149  1.00 72.51           C  
ATOM   5411  CD1 LEU A 650      14.744  20.843  61.956  1.00 72.64           C  
ATOM   5412  CD2 LEU A 650      13.841  18.573  61.465  1.00 74.29           C  
ATOM   5413  N   PRO A 651      17.028  15.935  60.797  1.00 69.94           N  
ATOM   5414  CA  PRO A 651      17.673  15.120  59.764  1.00 69.31           C  
ATOM   5415  C   PRO A 651      17.983  15.886  58.447  1.00 68.95           C  
ATOM   5416  O   PRO A 651      17.069  16.432  57.828  1.00 68.76           O  
ATOM   5417  CB  PRO A 651      16.645  13.995  59.529  1.00 69.12           C  
ATOM   5418  CG  PRO A 651      15.329  14.573  59.929  1.00 68.43           C  
ATOM   5419  CD  PRO A 651      15.606  15.576  60.992  1.00 69.59           C  
ATOM   5420  N   VAL A 652      19.247  15.885  58.007  1.00 68.32           N  
ATOM   5421  CA  VAL A 652      19.638  16.523  56.729  1.00 67.58           C  
ATOM   5422  C   VAL A 652      18.645  16.430  55.588  1.00 68.12           C  
ATOM   5423  O   VAL A 652      18.521  17.381  54.790  1.00 68.45           O  
ATOM   5424  CB  VAL A 652      20.925  15.994  56.133  1.00 66.81           C  
ATOM   5425  CG1 VAL A 652      22.070  16.762  56.657  1.00 67.07           C  
ATOM   5426  CG2 VAL A 652      21.066  14.526  56.359  1.00 66.32           C  
ATOM   5427  N   GLU A 653      17.961  15.293  55.479  1.00 67.95           N  
ATOM   5428  CA  GLU A 653      17.004  15.126  54.392  1.00 67.81           C  
ATOM   5429  C   GLU A 653      15.867  16.108  54.620  1.00 67.37           C  
ATOM   5430  O   GLU A 653      15.292  16.633  53.667  1.00 67.47           O  
ATOM   5431  CB  GLU A 653      16.477  13.686  54.259  1.00 67.97           C  
ATOM   5432  CG  GLU A 653      17.532  12.619  54.096  1.00 68.26           C  
ATOM   5433  CD  GLU A 653      18.162  12.186  55.429  1.00 70.74           C  
ATOM   5434  OE1 GLU A 653      17.939  12.844  56.476  1.00 72.88           O  
ATOM   5435  OE2 GLU A 653      18.890  11.176  55.436  1.00 70.75           O  
ATOM   5436  N   VAL A 654      15.547  16.381  55.874  1.00 66.67           N  
ATOM   5437  CA  VAL A 654      14.592  17.457  56.098  1.00 66.77           C  
ATOM   5438  C   VAL A 654      15.159  18.851  55.727  1.00 67.38           C  
ATOM   5439  O   VAL A 654      14.471  19.631  55.050  1.00 67.71           O  
ATOM   5440  CB  VAL A 654      13.984  17.439  57.499  1.00 66.30           C  
ATOM   5441  CG1 VAL A 654      13.441  18.837  57.862  1.00 64.54           C  
ATOM   5442  CG2 VAL A 654      12.918  16.366  57.545  1.00 64.79           C  
ATOM   5443  N   LEU A 655      16.393  19.142  56.164  1.00 67.15           N  
ATOM   5444  CA  LEU A 655      17.096  20.356  55.783  1.00 67.23           C  
ATOM   5445  C   LEU A 655      17.266  20.460  54.249  1.00 67.46           C  
ATOM   5446  O   LEU A 655      17.133  21.555  53.680  1.00 68.20           O  
ATOM   5447  CB  LEU A 655      18.464  20.422  56.456  1.00 67.25           C  
ATOM   5448  CG  LEU A 655      18.555  20.320  57.978  1.00 68.32           C  
ATOM   5449  CD1 LEU A 655      20.007  20.540  58.452  1.00 70.20           C  
ATOM   5450  CD2 LEU A 655      17.621  21.281  58.685  1.00 67.99           C  
ATOM   5451  N   CYS A 656      17.562  19.345  53.579  1.00 66.38           N  
ATOM   5452  CA  CYS A 656      17.587  19.358  52.136  1.00 65.82           C  
ATOM   5453  C   CYS A 656      16.225  19.689  51.537  1.00 65.72           C  
ATOM   5454  O   CYS A 656      16.146  20.538  50.661  1.00 66.60           O  
ATOM   5455  CB  CYS A 656      18.095  18.047  51.592  1.00 65.89           C  
ATOM   5456  SG  CYS A 656      19.871  17.813  51.771  1.00 68.40           S  
ATOM   5457  N   SER A 657      15.154  19.030  51.995  1.00 65.22           N  
ATOM   5458  CA  SER A 657      13.788  19.406  51.631  1.00 64.11           C  
ATOM   5459  C   SER A 657      13.576  20.952  51.766  1.00 63.22           C  
ATOM   5460  O   SER A 657      13.105  21.635  50.856  1.00 62.74           O  
ATOM   5461  CB  SER A 657      12.820  18.611  52.504  1.00 64.29           C  
ATOM   5462  OG  SER A 657      11.508  19.175  52.535  1.00 66.81           O  
ATOM   5463  N   GLN A 658      13.965  21.508  52.895  1.00 62.23           N  
ATOM   5464  CA  GLN A 658      13.851  22.941  53.077  1.00 62.12           C  
ATOM   5465  C   GLN A 658      14.539  23.654  51.916  1.00 61.87           C  
ATOM   5466  O   GLN A 658      13.947  24.513  51.240  1.00 62.11           O  
ATOM   5467  CB  GLN A 658      14.437  23.352  54.435  1.00 61.81           C  
ATOM   5468  CG  GLN A 658      13.779  22.596  55.588  1.00 62.45           C  
ATOM   5469  CD  GLN A 658      14.269  23.005  56.957  1.00 62.56           C  
ATOM   5470  OE1 GLN A 658      15.428  23.348  57.135  1.00 65.98           O  
ATOM   5471  NE2 GLN A 658      13.382  22.963  57.935  1.00 61.37           N  
ATOM   5472  N   ILE A 659      15.784  23.256  51.665  1.00 61.15           N  
ATOM   5473  CA  ILE A 659      16.596  23.896  50.663  1.00 59.81           C  
ATOM   5474  C   ILE A 659      15.873  23.848  49.324  1.00 59.67           C  
ATOM   5475  O   ILE A 659      15.717  24.875  48.671  1.00 60.12           O  
ATOM   5476  CB  ILE A 659      17.980  23.280  50.569  1.00 59.19           C  
ATOM   5477  CG1 ILE A 659      18.811  23.638  51.802  1.00 57.00           C  
ATOM   5478  CG2 ILE A 659      18.654  23.791  49.330  1.00 60.42           C  
ATOM   5479  CD1 ILE A 659      20.251  23.177  51.749  1.00 51.93           C  
ATOM   5480  N   LEU A 660      15.383  22.675  48.946  1.00 59.21           N  
ATOM   5481  CA  LEU A 660      14.544  22.557  47.752  1.00 59.27           C  
ATOM   5482  C   LEU A 660      13.353  23.552  47.734  1.00 59.25           C  
ATOM   5483  O   LEU A 660      13.103  24.240  46.726  1.00 59.09           O  
ATOM   5484  CB  LEU A 660      14.083  21.123  47.581  1.00 58.77           C  
ATOM   5485  CG  LEU A 660      15.219  20.156  47.261  1.00 59.84           C  
ATOM   5486  CD1 LEU A 660      14.692  18.734  47.238  1.00 62.59           C  
ATOM   5487  CD2 LEU A 660      15.894  20.477  45.924  1.00 58.66           C  
ATOM   5488  N   SER A 661      12.650  23.678  48.854  1.00 59.02           N  
ATOM   5489  CA  SER A 661      11.580  24.665  48.907  1.00 58.79           C  
ATOM   5490  C   SER A 661      12.100  26.070  48.565  1.00 58.10           C  
ATOM   5491  O   SER A 661      11.645  26.692  47.608  1.00 57.22           O  
ATOM   5492  CB  SER A 661      10.878  24.643  50.264  1.00 58.74           C  
ATOM   5493  OG  SER A 661      10.021  23.526  50.347  1.00 59.94           O  
ATOM   5494  N   LEU A 662      13.065  26.549  49.338  1.00 57.82           N  
ATOM   5495  CA  LEU A 662      13.591  27.898  49.138  1.00 57.75           C  
ATOM   5496  C   LEU A 662      14.067  28.205  47.683  1.00 57.65           C  
ATOM   5497  O   LEU A 662      13.906  29.319  47.216  1.00 57.80           O  
ATOM   5498  CB  LEU A 662      14.675  28.203  50.168  1.00 57.48           C  
ATOM   5499  CG  LEU A 662      14.235  28.128  51.621  1.00 57.41           C  
ATOM   5500  CD1 LEU A 662      15.289  28.724  52.552  1.00 57.28           C  
ATOM   5501  CD2 LEU A 662      12.908  28.827  51.817  1.00 58.20           C  
ATOM   5502  N   THR A 663      14.638  27.227  46.982  1.00 56.70           N  
ATOM   5503  CA  THR A 663      14.733  27.272  45.530  1.00 56.06           C  
ATOM   5504  C   THR A 663      13.616  28.043  44.801  1.00 56.01           C  
ATOM   5505  O   THR A 663      13.854  28.693  43.816  1.00 55.77           O  
ATOM   5506  CB  THR A 663      14.719  25.852  45.001  1.00 55.83           C  
ATOM   5507  OG1 THR A 663      16.052  25.470  44.667  1.00 56.31           O  
ATOM   5508  CG2 THR A 663      13.827  25.701  43.778  1.00 54.84           C  
ATOM   5509  N   LEU A 664      12.384  27.951  45.271  1.00 56.35           N  
ATOM   5510  CA  LEU A 664      11.278  28.470  44.504  1.00 56.35           C  
ATOM   5511  C   LEU A 664      11.159  29.931  44.872  1.00 56.68           C  
ATOM   5512  O   LEU A 664      10.509  30.720  44.187  1.00 57.82           O  
ATOM   5513  CB  LEU A 664       9.993  27.676  44.777  1.00 55.82           C  
ATOM   5514  CG  LEU A 664      10.034  26.166  44.444  1.00 57.06           C  
ATOM   5515  CD1 LEU A 664       9.246  25.311  45.411  1.00 58.86           C  
ATOM   5516  CD2 LEU A 664       9.544  25.870  43.058  1.00 59.80           C  
ATOM   5517  N   MET A 665      11.827  30.316  45.940  1.00 56.29           N  
ATOM   5518  CA  MET A 665      11.752  31.692  46.367  1.00 56.26           C  
ATOM   5519  C   MET A 665      12.685  32.562  45.593  1.00 56.73           C  
ATOM   5520  O   MET A 665      12.669  33.768  45.757  1.00 57.07           O  
ATOM   5521  CB  MET A 665      12.030  31.805  47.853  1.00 55.85           C  
ATOM   5522  CG  MET A 665      10.977  31.103  48.647  1.00 56.42           C  
ATOM   5523  SD  MET A 665       9.368  31.872  48.479  1.00 56.24           S  
ATOM   5524  CE  MET A 665       8.516  30.997  47.174  1.00 53.85           C  
ATOM   5525  N   ASN A 666      13.521  31.951  44.761  1.00 57.31           N  
ATOM   5526  CA  ASN A 666      14.297  32.711  43.806  1.00 57.89           C  
ATOM   5527  C   ASN A 666      13.412  33.353  42.742  1.00 57.61           C  
ATOM   5528  O   ASN A 666      13.845  34.270  42.063  1.00 57.48           O  
ATOM   5529  CB  ASN A 666      15.371  31.849  43.175  1.00 58.14           C  
ATOM   5530  CG  ASN A 666      16.484  31.544  44.134  1.00 60.52           C  
ATOM   5531  OD1 ASN A 666      17.011  32.447  44.782  1.00 64.94           O  
ATOM   5532  ND2 ASN A 666      16.851  30.263  44.245  1.00 62.60           N  
ATOM   5533  N   TYR A 667      12.171  32.894  42.634  1.00 57.37           N  
ATOM   5534  CA  TYR A 667      11.187  33.512  41.753  1.00 58.24           C  
ATOM   5535  C   TYR A 667      11.560  33.482  40.251  1.00 59.52           C  
ATOM   5536  O   TYR A 667      11.485  34.488  39.532  1.00 59.49           O  
ATOM   5537  CB  TYR A 667      10.834  34.923  42.244  1.00 57.51           C  
ATOM   5538  CG  TYR A 667       9.983  34.905  43.478  1.00 56.84           C  
ATOM   5539  CD1 TYR A 667      10.542  35.108  44.726  1.00 56.94           C  
ATOM   5540  CD2 TYR A 667       8.619  34.660  43.407  1.00 56.39           C  
ATOM   5541  CE1 TYR A 667       9.760  35.075  45.877  1.00 57.05           C  
ATOM   5542  CE2 TYR A 667       7.828  34.629  44.566  1.00 56.19           C  
ATOM   5543  CZ  TYR A 667       8.415  34.829  45.784  1.00 55.71           C  
ATOM   5544  OH  TYR A 667       7.675  34.795  46.918  1.00 56.18           O  
ATOM   5545  N   SER A 668      11.931  32.293  39.786  1.00 60.94           N  
ATOM   5546  CA  SER A 668      12.524  32.129  38.492  1.00 61.96           C  
ATOM   5547  C   SER A 668      12.119  30.798  37.892  1.00 63.15           C  
ATOM   5548  O   SER A 668      12.941  29.965  37.553  1.00 63.34           O  
ATOM   5549  CB  SER A 668      14.034  32.263  38.593  1.00 61.46           C  
ATOM   5550  OG  SER A 668      14.584  32.226  37.279  1.00 63.72           O  
ATOM   5551  N   SER A 669      10.815  30.615  37.751  1.00 65.08           N  
ATOM   5552  CA  SER A 669      10.236  29.384  37.229  1.00 66.54           C  
ATOM   5553  C   SER A 669      10.935  28.798  36.011  1.00 67.78           C  
ATOM   5554  O   SER A 669      11.098  27.587  35.919  1.00 68.54           O  
ATOM   5555  CB  SER A 669       8.776  29.641  36.892  1.00 66.20           C  
ATOM   5556  OG  SER A 669       8.008  29.727  38.075  1.00 68.64           O  
ATOM   5557  N   PHE A 670      11.342  29.657  35.077  1.00 69.39           N  
ATOM   5558  CA  PHE A 670      11.728  29.228  33.737  1.00 70.51           C  
ATOM   5559  C   PHE A 670      13.197  28.891  33.637  1.00 71.16           C  
ATOM   5560  O   PHE A 670      13.615  28.170  32.747  1.00 70.93           O  
ATOM   5561  CB  PHE A 670      11.446  30.343  32.762  1.00 70.86           C  
ATOM   5562  CG  PHE A 670      10.015  30.605  32.567  1.00 72.19           C  
ATOM   5563  CD1 PHE A 670       9.347  31.519  33.376  1.00 74.49           C  
ATOM   5564  CD2 PHE A 670       9.316  29.958  31.563  1.00 74.51           C  
ATOM   5565  CE1 PHE A 670       7.990  31.773  33.194  1.00 75.01           C  
ATOM   5566  CE2 PHE A 670       7.960  30.217  31.355  1.00 75.35           C  
ATOM   5567  CZ  PHE A 670       7.299  31.116  32.178  1.00 74.56           C  
ATOM   5568  N   GLN A 671      13.985  29.457  34.536  1.00 72.17           N  
ATOM   5569  CA  GLN A 671      15.407  29.224  34.523  1.00 73.03           C  
ATOM   5570  C   GLN A 671      15.882  28.574  35.825  1.00 72.75           C  
ATOM   5571  O   GLN A 671      15.708  29.118  36.926  1.00 71.89           O  
ATOM   5572  CB  GLN A 671      16.161  30.505  34.183  1.00 73.43           C  
ATOM   5573  CG  GLN A 671      15.680  31.078  32.843  1.00 78.04           C  
ATOM   5574  CD  GLN A 671      16.707  31.985  32.196  1.00 83.88           C  
ATOM   5575  OE1 GLN A 671      17.739  32.268  32.801  1.00 87.07           O  
ATOM   5576  NE2 GLN A 671      16.445  32.434  30.953  1.00 84.30           N  
ATOM   5577  N   PRO A 672      16.546  27.419  35.683  1.00 72.65           N  
ATOM   5578  CA  PRO A 672      16.953  26.605  36.800  1.00 72.62           C  
ATOM   5579  C   PRO A 672      17.814  27.503  37.678  1.00 72.45           C  
ATOM   5580  O   PRO A 672      18.588  28.300  37.136  1.00 73.36           O  
ATOM   5581  CB  PRO A 672      17.855  25.565  36.123  1.00 72.68           C  
ATOM   5582  CG  PRO A 672      18.355  26.278  34.878  1.00 72.22           C  
ATOM   5583  CD  PRO A 672      17.098  26.898  34.422  1.00 72.33           C  
ATOM   5584  N   ILE A 673      17.702  27.403  39.000  1.00 71.26           N  
ATOM   5585  CA  ILE A 673      18.677  28.089  39.852  1.00 69.37           C  
ATOM   5586  C   ILE A 673      19.244  27.141  40.907  1.00 68.08           C  
ATOM   5587  O   ILE A 673      18.521  26.652  41.739  1.00 68.23           O  
ATOM   5588  CB  ILE A 673      18.101  29.436  40.401  1.00 69.69           C  
ATOM   5589  CG1 ILE A 673      18.260  30.521  39.315  1.00 68.52           C  
ATOM   5590  CG2 ILE A 673      18.806  29.847  41.697  1.00 69.52           C  
ATOM   5591  CD1 ILE A 673      17.416  31.768  39.475  1.00 68.30           C  
ATOM   5592  N   LYS A 674      20.534  26.865  40.841  1.00 66.74           N  
ATOM   5593  CA  LYS A 674      21.173  25.855  41.692  1.00 65.94           C  
ATOM   5594  C   LYS A 674      20.888  26.049  43.200  1.00 65.31           C  
ATOM   5595  O   LYS A 674      20.638  25.080  43.927  1.00 64.59           O  
ATOM   5596  CB  LYS A 674      22.678  25.903  41.479  1.00 65.44           C  
ATOM   5597  CG  LYS A 674      23.275  24.621  41.070  1.00 68.40           C  
ATOM   5598  CD  LYS A 674      24.827  24.615  41.147  1.00 72.41           C  
ATOM   5599  CE  LYS A 674      25.509  25.374  39.967  1.00 76.15           C  
ATOM   5600  NZ  LYS A 674      26.875  25.926  40.306  1.00 74.02           N  
ATOM   5601  N   LEU A 675      20.903  27.307  43.647  1.00 63.98           N  
ATOM   5602  CA  LEU A 675      21.058  27.625  45.062  1.00 62.49           C  
ATOM   5603  C   LEU A 675      19.754  28.082  45.728  1.00 62.02           C  
ATOM   5604  O   LEU A 675      18.878  28.634  45.065  1.00 62.45           O  
ATOM   5605  CB  LEU A 675      22.183  28.675  45.233  1.00 62.23           C  
ATOM   5606  CG  LEU A 675      23.636  28.183  45.181  1.00 60.23           C  
ATOM   5607  CD1 LEU A 675      24.595  29.297  45.107  1.00 59.57           C  
ATOM   5608  CD2 LEU A 675      23.974  27.376  46.396  1.00 60.29           C  
ATOM   5609  N   PRO A 676      19.601  27.851  47.042  1.00 61.24           N  
ATOM   5610  CA  PRO A 676      18.313  28.283  47.563  1.00 60.84           C  
ATOM   5611  C   PRO A 676      18.336  29.773  47.729  1.00 60.31           C  
ATOM   5612  O   PRO A 676      19.409  30.358  47.847  1.00 60.10           O  
ATOM   5613  CB  PRO A 676      18.230  27.601  48.930  1.00 61.05           C  
ATOM   5614  CG  PRO A 676      19.654  27.429  49.356  1.00 61.44           C  
ATOM   5615  CD  PRO A 676      20.452  27.240  48.079  1.00 61.29           C  
ATOM   5616  N   ALA A 677      17.153  30.368  47.762  1.00 59.50           N  
ATOM   5617  CA  ALA A 677      17.020  31.797  47.827  1.00 58.31           C  
ATOM   5618  C   ALA A 677      17.839  32.423  48.959  1.00 58.33           C  
ATOM   5619  O   ALA A 677      18.303  33.561  48.821  1.00 59.15           O  
ATOM   5620  CB  ALA A 677      15.562  32.197  47.882  1.00 57.74           C  
ATOM   5621  N   THR A 678      18.072  31.695  50.047  1.00 58.06           N  
ATOM   5622  CA  THR A 678      18.853  32.244  51.183  1.00 58.38           C  
ATOM   5623  C   THR A 678      20.215  32.800  50.797  1.00 58.60           C  
ATOM   5624  O   THR A 678      20.628  33.864  51.275  1.00 58.71           O  
ATOM   5625  CB  THR A 678      19.153  31.185  52.216  1.00 58.04           C  
ATOM   5626  OG1 THR A 678      19.210  29.917  51.556  1.00 60.00           O  
ATOM   5627  CG2 THR A 678      18.077  31.157  53.255  1.00 58.19           C  
ATOM   5628  N   VAL A 679      20.907  32.069  49.928  1.00 58.75           N  
ATOM   5629  CA  VAL A 679      22.269  32.374  49.601  1.00 58.60           C  
ATOM   5630  C   VAL A 679      22.448  32.584  48.099  1.00 59.43           C  
ATOM   5631  O   VAL A 679      23.582  32.615  47.598  1.00 60.26           O  
ATOM   5632  CB  VAL A 679      23.195  31.247  50.090  1.00 58.23           C  
ATOM   5633  CG1 VAL A 679      23.245  31.177  51.583  1.00 55.87           C  
ATOM   5634  CG2 VAL A 679      22.729  29.932  49.522  1.00 58.94           C  
ATOM   5635  N   HIS A 680      21.347  32.713  47.365  1.00 60.04           N  
ATOM   5636  CA  HIS A 680      21.428  32.833  45.901  1.00 60.56           C  
ATOM   5637  C   HIS A 680      21.995  34.216  45.528  1.00 61.51           C  
ATOM   5638  O   HIS A 680      21.452  35.220  45.971  1.00 62.20           O  
ATOM   5639  CB  HIS A 680      20.057  32.598  45.240  1.00 59.57           C  
ATOM   5640  CG  HIS A 680      20.024  32.997  43.792  1.00 60.05           C  
ATOM   5641  ND1 HIS A 680      20.782  32.363  42.817  1.00 58.47           N  
ATOM   5642  CD2 HIS A 680      19.371  34.005  43.165  1.00 57.63           C  
ATOM   5643  CE1 HIS A 680      20.576  32.953  41.659  1.00 56.11           C  
ATOM   5644  NE2 HIS A 680      19.730  33.954  41.842  1.00 54.97           N  
ATOM   5645  N   TYR A 681      23.085  34.270  44.752  1.00 62.41           N  
ATOM   5646  CA  TYR A 681      23.725  35.546  44.365  1.00 63.47           C  
ATOM   5647  C   TYR A 681      24.432  36.226  45.498  1.00 63.57           C  
ATOM   5648  O   TYR A 681      25.026  37.280  45.295  1.00 64.00           O  
ATOM   5649  CB  TYR A 681      22.703  36.579  43.908  1.00 64.61           C  
ATOM   5650  CG  TYR A 681      22.555  36.869  42.439  1.00 66.40           C  
ATOM   5651  CD1 TYR A 681      22.200  38.140  42.021  1.00 67.67           C  
ATOM   5652  CD2 TYR A 681      22.714  35.884  41.473  1.00 67.67           C  
ATOM   5653  CE1 TYR A 681      22.013  38.432  40.688  1.00 68.77           C  
ATOM   5654  CE2 TYR A 681      22.542  36.164  40.113  1.00 68.31           C  
ATOM   5655  CZ  TYR A 681      22.178  37.440  39.728  1.00 68.73           C  
ATOM   5656  OH  TYR A 681      21.988  37.759  38.380  1.00 69.56           O  
ATOM   5657  N   SER A 682      24.297  35.700  46.707  1.00 63.53           N  
ATOM   5658  CA  SER A 682      24.924  36.320  47.852  1.00 63.59           C  
ATOM   5659  C   SER A 682      26.428  36.475  47.633  1.00 63.55           C  
ATOM   5660  O   SER A 682      26.984  37.516  47.938  1.00 63.55           O  
ATOM   5661  CB  SER A 682      24.649  35.516  49.110  1.00 63.72           C  
ATOM   5662  OG  SER A 682      23.271  35.500  49.401  1.00 64.85           O  
ATOM   5663  N   ASP A 683      27.077  35.460  47.075  1.00 63.72           N  
ATOM   5664  CA  ASP A 683      28.488  35.564  46.836  1.00 64.12           C  
ATOM   5665  C   ASP A 683      28.833  36.675  45.832  1.00 64.06           C  
ATOM   5666  O   ASP A 683      29.827  37.365  46.010  1.00 64.43           O  
ATOM   5667  CB  ASP A 683      29.080  34.238  46.400  1.00 64.47           C  
ATOM   5668  CG  ASP A 683      30.590  34.338  46.114  1.00 67.23           C  
ATOM   5669  OD1 ASP A 683      31.015  34.963  45.095  1.00 69.43           O  
ATOM   5670  OD2 ASP A 683      31.367  33.792  46.917  1.00 69.26           O  
ATOM   5671  N   LYS A 684      28.046  36.853  44.780  1.00 63.78           N  
ATOM   5672  CA  LYS A 684      28.331  37.935  43.842  1.00 63.82           C  
ATOM   5673  C   LYS A 684      28.232  39.307  44.544  1.00 63.39           C  
ATOM   5674  O   LYS A 684      29.104  40.196  44.368  1.00 63.03           O  
ATOM   5675  CB  LYS A 684      27.404  37.881  42.628  1.00 64.82           C  
ATOM   5676  CG  LYS A 684      27.501  36.581  41.863  1.00 67.57           C  
ATOM   5677  CD  LYS A 684      26.546  36.575  40.663  1.00 74.54           C  
ATOM   5678  CE  LYS A 684      26.478  35.158  39.965  1.00 75.17           C  
ATOM   5679  NZ  LYS A 684      26.197  35.277  38.447  1.00 79.30           N  
ATOM   5680  N   ILE A 685      27.188  39.459  45.364  1.00 62.23           N  
ATOM   5681  CA  ILE A 685      26.931  40.718  46.039  1.00 61.04           C  
ATOM   5682  C   ILE A 685      28.062  41.074  46.971  1.00 60.71           C  
ATOM   5683  O   ILE A 685      28.634  42.133  46.827  1.00 61.20           O  
ATOM   5684  CB  ILE A 685      25.570  40.747  46.713  1.00 60.80           C  
ATOM   5685  CG1 ILE A 685      24.532  41.090  45.655  1.00 60.64           C  
ATOM   5686  CG2 ILE A 685      25.521  41.809  47.764  1.00 60.25           C  
ATOM   5687  CD1 ILE A 685      23.143  40.746  46.024  1.00 62.10           C  
ATOM   5688  N   THR A 686      28.420  40.188  47.891  1.00 59.82           N  
ATOM   5689  CA  THR A 686      29.512  40.487  48.793  1.00 59.14           C  
ATOM   5690  C   THR A 686      30.709  40.872  47.971  1.00 59.07           C  
ATOM   5691  O   THR A 686      31.348  41.910  48.207  1.00 58.51           O  
ATOM   5692  CB  THR A 686      29.936  39.279  49.602  1.00 59.25           C  
ATOM   5693  OG1 THR A 686      30.244  38.218  48.703  1.00 58.85           O  
ATOM   5694  CG2 THR A 686      28.856  38.845  50.566  1.00 59.06           C  
ATOM   5695  N   LYS A 687      31.016  40.028  46.994  1.00 59.24           N  
ATOM   5696  CA  LYS A 687      32.218  40.245  46.189  1.00 59.97           C  
ATOM   5697  C   LYS A 687      32.180  41.560  45.441  1.00 59.97           C  
ATOM   5698  O   LYS A 687      33.192  42.250  45.291  1.00 59.97           O  
ATOM   5699  CB  LYS A 687      32.488  39.089  45.239  1.00 59.40           C  
ATOM   5700  CG  LYS A 687      33.784  38.423  45.582  1.00 60.78           C  
ATOM   5701  CD  LYS A 687      33.608  36.930  45.761  1.00 62.53           C  
ATOM   5702  CE  LYS A 687      34.770  36.322  46.508  1.00 62.15           C  
ATOM   5703  NZ  LYS A 687      34.628  34.840  46.438  1.00 66.86           N  
ATOM   5704  N   LEU A 688      30.999  41.901  44.980  1.00 60.07           N  
ATOM   5705  CA  LEU A 688      30.851  43.078  44.194  1.00 60.41           C  
ATOM   5706  C   LEU A 688      31.168  44.264  45.043  1.00 61.34           C  
ATOM   5707  O   LEU A 688      31.855  45.158  44.593  1.00 62.32           O  
ATOM   5708  CB  LEU A 688      29.431  43.146  43.678  1.00 60.17           C  
ATOM   5709  CG  LEU A 688      29.053  44.214  42.693  1.00 58.71           C  
ATOM   5710  CD1 LEU A 688      29.920  44.085  41.481  1.00 58.55           C  
ATOM   5711  CD2 LEU A 688      27.576  44.027  42.382  1.00 57.60           C  
ATOM   5712  N   MET A 689      30.706  44.253  46.291  1.00 62.42           N  
ATOM   5713  CA  MET A 689      30.811  45.422  47.160  1.00 63.13           C  
ATOM   5714  C   MET A 689      32.227  45.642  47.660  1.00 64.28           C  
ATOM   5715  O   MET A 689      32.607  46.758  47.898  1.00 64.71           O  
ATOM   5716  CB  MET A 689      29.826  45.349  48.333  1.00 62.66           C  
ATOM   5717  CG  MET A 689      28.342  45.214  47.955  1.00 61.37           C  
ATOM   5718  SD  MET A 689      27.608  46.605  47.043  1.00 61.10           S  
ATOM   5719  CE  MET A 689      28.419  46.433  45.456  1.00 57.93           C  
ATOM   5720  N   LEU A 690      32.998  44.574  47.808  1.00 65.94           N  
ATOM   5721  CA  LEU A 690      34.381  44.646  48.277  1.00 67.42           C  
ATOM   5722  C   LEU A 690      35.201  45.735  47.655  1.00 68.39           C  
ATOM   5723  O   LEU A 690      36.089  46.283  48.305  1.00 68.69           O  
ATOM   5724  CB  LEU A 690      35.125  43.329  48.024  1.00 67.64           C  
ATOM   5725  CG  LEU A 690      35.369  42.337  49.164  1.00 68.07           C  
ATOM   5726  CD1 LEU A 690      36.170  41.129  48.681  1.00 68.81           C  
ATOM   5727  CD2 LEU A 690      36.076  43.003  50.342  1.00 68.53           C  
ATOM   5728  N   ARG A 691      34.958  46.042  46.393  1.00 69.94           N  
ATOM   5729  CA  ARG A 691      35.780  47.082  45.771  1.00 72.18           C  
ATOM   5730  C   ARG A 691      35.317  48.440  46.247  1.00 72.37           C  
ATOM   5731  O   ARG A 691      36.131  49.314  46.561  1.00 72.15           O  
ATOM   5732  CB  ARG A 691      35.709  47.004  44.264  1.00 72.89           C  
ATOM   5733  CG  ARG A 691      35.859  45.605  43.735  1.00 76.07           C  
ATOM   5734  CD  ARG A 691      35.648  45.627  42.255  1.00 81.65           C  
ATOM   5735  NE  ARG A 691      35.886  44.305  41.720  1.00 86.87           N  
ATOM   5736  CZ  ARG A 691      35.249  43.782  40.678  1.00 89.83           C  
ATOM   5737  NH1 ARG A 691      34.309  44.475  40.028  1.00 91.82           N  
ATOM   5738  NH2 ARG A 691      35.547  42.544  40.299  1.00 90.79           N  
ATOM   5739  N   GLY A 692      33.991  48.575  46.300  1.00 73.12           N  
ATOM   5740  CA  GLY A 692      33.285  49.722  46.872  1.00 73.71           C  
ATOM   5741  C   GLY A 692      34.095  50.467  47.901  1.00 74.08           C  
ATOM   5742  O   GLY A 692      33.841  50.372  49.113  1.00 74.46           O  
ATOM   5743  N   ILE A 693      35.095  51.177  47.393  1.00 74.05           N  
ATOM   5744  CA  ILE A 693      35.863  52.132  48.159  1.00 74.29           C  
ATOM   5745  C   ILE A 693      34.906  52.861  49.098  1.00 74.22           C  
ATOM   5746  O   ILE A 693      34.099  53.672  48.643  1.00 74.57           O  
ATOM   5747  CB  ILE A 693      36.525  53.133  47.185  1.00 74.46           C  
ATOM   5748  CG1 ILE A 693      37.374  52.360  46.152  1.00 75.50           C  
ATOM   5749  CG2 ILE A 693      37.303  54.220  47.940  1.00 73.48           C  
ATOM   5750  CD1 ILE A 693      37.489  53.019  44.751  1.00 77.03           C  
ATOM   5751  N   GLU A 694      34.956  52.518  50.389  1.00 73.83           N  
ATOM   5752  CA  GLU A 694      34.162  53.189  51.420  1.00 73.56           C  
ATOM   5753  C   GLU A 694      33.060  52.330  52.074  1.00 73.66           C  
ATOM   5754  O   GLU A 694      32.449  51.472  51.404  1.00 73.72           O  
ATOM   5755  CB  GLU A 694      33.589  54.495  50.883  1.00 73.78           C  
ATOM   5756  CG  GLU A 694      32.373  55.002  51.580  1.00 75.02           C  
ATOM   5757  CD  GLU A 694      32.525  56.474  51.885  1.00 78.57           C  
ATOM   5758  OE1 GLU A 694      32.952  57.228  50.966  1.00 78.18           O  
ATOM   5759  OE2 GLU A 694      32.237  56.871  53.053  1.00 79.81           O  
ATOM   5760  N   PRO A 695      32.836  52.558  53.402  1.00 73.26           N  
ATOM   5761  CA  PRO A 695      31.837  52.001  54.326  1.00 72.42           C  
ATOM   5762  C   PRO A 695      30.434  51.843  53.777  1.00 71.39           C  
ATOM   5763  O   PRO A 695      29.980  52.623  52.938  1.00 71.24           O  
ATOM   5764  CB  PRO A 695      31.803  53.033  55.442  1.00 72.38           C  
ATOM   5765  CG  PRO A 695      33.191  53.494  55.525  1.00 73.27           C  
ATOM   5766  CD  PRO A 695      33.743  53.485  54.121  1.00 73.22           C  
ATOM   5767  N   ILE A 696      29.752  50.825  54.279  1.00 70.24           N  
ATOM   5768  CA  ILE A 696      28.452  50.446  53.786  1.00 69.28           C  
ATOM   5769  C   ILE A 696      27.679  49.894  54.972  1.00 68.41           C  
ATOM   5770  O   ILE A 696      28.197  49.093  55.762  1.00 67.61           O  
ATOM   5771  CB  ILE A 696      28.559  49.390  52.631  1.00 69.11           C  
ATOM   5772  CG1 ILE A 696      29.389  49.948  51.479  1.00 69.62           C  
ATOM   5773  CG2 ILE A 696      27.187  48.984  52.121  1.00 68.93           C  
ATOM   5774  CD1 ILE A 696      29.623  48.993  50.326  1.00 70.57           C  
ATOM   5775  N   LYS A 697      26.447  50.375  55.093  1.00 67.81           N  
ATOM   5776  CA  LYS A 697      25.457  49.841  56.007  1.00 67.43           C  
ATOM   5777  C   LYS A 697      24.084  50.037  55.399  1.00 66.79           C  
ATOM   5778  O   LYS A 697      23.549  51.142  55.388  1.00 66.88           O  
ATOM   5779  CB  LYS A 697      25.522  50.512  57.387  1.00 67.69           C  
ATOM   5780  CG  LYS A 697      25.965  49.564  58.492  1.00 69.38           C  
ATOM   5781  CD  LYS A 697      25.428  49.970  59.846  1.00 72.22           C  
ATOM   5782  CE  LYS A 697      26.172  49.230  60.968  1.00 74.07           C  
ATOM   5783  NZ  LYS A 697      26.364  50.095  62.180  1.00 74.84           N  
ATOM   5784  N   LYS A 698      23.522  48.964  54.872  1.00 65.92           N  
ATOM   5785  CA  LYS A 698      22.202  49.026  54.298  1.00 65.38           C  
ATOM   5786  C   LYS A 698      21.378  47.830  54.772  1.00 65.40           C  
ATOM   5787  O   LYS A 698      21.891  46.735  55.003  1.00 65.81           O  
ATOM   5788  CB  LYS A 698      22.281  49.027  52.767  1.00 65.05           C  
ATOM   5789  CG  LYS A 698      23.258  49.993  52.158  1.00 64.72           C  
ATOM   5790  CD  LYS A 698      22.644  50.623  50.928  1.00 66.04           C  
ATOM   5791  CE  LYS A 698      23.032  52.103  50.762  1.00 67.19           C  
ATOM   5792  NZ  LYS A 698      22.115  52.842  49.809  1.00 67.27           N  
ATOM   5793  N   GLU A 699      20.086  48.043  54.906  1.00 64.99           N  
ATOM   5794  CA  GLU A 699      19.177  46.955  55.099  1.00 64.58           C  
ATOM   5795  C   GLU A 699      18.008  47.231  54.191  1.00 63.89           C  
ATOM   5796  O   GLU A 699      17.898  48.327  53.658  1.00 64.07           O  
ATOM   5797  CB  GLU A 699      18.725  46.957  56.537  1.00 65.33           C  
ATOM   5798  CG  GLU A 699      17.900  48.173  56.924  1.00 67.31           C  
ATOM   5799  CD  GLU A 699      16.981  47.900  58.109  1.00 70.78           C  
ATOM   5800  OE1 GLU A 699      16.957  46.750  58.611  1.00 71.75           O  
ATOM   5801  OE2 GLU A 699      16.288  48.841  58.554  1.00 72.62           O  
ATOM   5802  N   GLY A 700      17.128  46.263  54.007  1.00 63.03           N  
ATOM   5803  CA  GLY A 700      15.962  46.501  53.183  1.00 63.10           C  
ATOM   5804  C   GLY A 700      15.059  45.322  53.310  1.00 63.42           C  
ATOM   5805  O   GLY A 700      15.396  44.409  54.027  1.00 63.91           O  
ATOM   5806  N   ASP A 701      13.923  45.334  52.620  1.00 64.08           N  
ATOM   5807  CA  ASP A 701      12.938  44.259  52.697  1.00 64.92           C  
ATOM   5808  C   ASP A 701      12.417  43.868  51.318  1.00 65.65           C  
ATOM   5809  O   ASP A 701      11.272  43.407  51.190  1.00 66.36           O  
ATOM   5810  CB  ASP A 701      11.763  44.732  53.531  1.00 65.23           C  
ATOM   5811  CG  ASP A 701      11.254  46.103  53.092  1.00 67.26           C  
ATOM   5812  OD1 ASP A 701      11.491  46.456  51.907  1.00 68.87           O  
ATOM   5813  OD2 ASP A 701      10.641  46.834  53.930  1.00 68.68           O  
ATOM   5814  N   ILE A 702      13.252  44.050  50.296  1.00 65.64           N  
ATOM   5815  CA  ILE A 702      12.847  43.902  48.910  1.00 65.64           C  
ATOM   5816  C   ILE A 702      13.963  43.188  48.154  1.00 65.71           C  
ATOM   5817  O   ILE A 702      15.119  43.613  48.203  1.00 65.90           O  
ATOM   5818  CB  ILE A 702      12.509  45.287  48.301  1.00 65.60           C  
ATOM   5819  CG1 ILE A 702      11.007  45.526  48.339  1.00 66.13           C  
ATOM   5820  CG2 ILE A 702      12.992  45.438  46.844  1.00 65.98           C  
ATOM   5821  CD1 ILE A 702      10.622  47.047  48.403  1.00 70.06           C  
ATOM   5822  N   MET A 703      13.632  42.104  47.462  1.00 65.46           N  
ATOM   5823  CA  MET A 703      14.674  41.282  46.846  1.00 65.96           C  
ATOM   5824  C   MET A 703      15.273  41.970  45.625  1.00 65.70           C  
ATOM   5825  O   MET A 703      15.106  41.507  44.478  1.00 66.01           O  
ATOM   5826  CB  MET A 703      14.141  39.904  46.488  1.00 65.62           C  
ATOM   5827  CG  MET A 703      13.082  39.448  47.460  1.00 66.91           C  
ATOM   5828  SD  MET A 703      12.589  37.743  47.244  1.00 67.57           S  
ATOM   5829  CE  MET A 703      14.083  36.879  47.757  1.00 66.82           C  
ATOM   5830  N   TYR A 704      15.994  43.065  45.881  1.00 64.87           N  
ATOM   5831  CA  TYR A 704      16.471  43.929  44.814  1.00 64.15           C  
ATOM   5832  C   TYR A 704      17.442  43.257  43.871  1.00 64.32           C  
ATOM   5833  O   TYR A 704      17.737  43.795  42.799  1.00 64.98           O  
ATOM   5834  CB  TYR A 704      17.122  45.182  45.386  1.00 63.81           C  
ATOM   5835  CG  TYR A 704      18.513  44.984  45.894  1.00 61.82           C  
ATOM   5836  CD1 TYR A 704      19.599  45.129  45.062  1.00 61.17           C  
ATOM   5837  CD2 TYR A 704      18.738  44.673  47.201  1.00 61.51           C  
ATOM   5838  CE1 TYR A 704      20.878  44.950  45.522  1.00 62.24           C  
ATOM   5839  CE2 TYR A 704      20.017  44.503  47.682  1.00 62.51           C  
ATOM   5840  CZ  TYR A 704      21.085  44.634  46.843  1.00 62.75           C  
ATOM   5841  OH  TYR A 704      22.367  44.435  47.321  1.00 62.83           O  
ATOM   5842  N   TRP A 705      17.936  42.089  44.257  1.00 64.18           N  
ATOM   5843  CA  TRP A 705      19.063  41.490  43.559  1.00 64.52           C  
ATOM   5844  C   TRP A 705      18.631  40.476  42.517  1.00 65.68           C  
ATOM   5845  O   TRP A 705      19.479  39.942  41.802  1.00 66.19           O  
ATOM   5846  CB  TRP A 705      20.049  40.850  44.548  1.00 63.65           C  
ATOM   5847  CG  TRP A 705      19.425  39.771  45.298  1.00 62.29           C  
ATOM   5848  CD1 TRP A 705      19.350  38.485  44.934  1.00 61.95           C  
ATOM   5849  CD2 TRP A 705      18.715  39.889  46.518  1.00 61.29           C  
ATOM   5850  NE1 TRP A 705      18.648  37.780  45.847  1.00 62.30           N  
ATOM   5851  CE2 TRP A 705      18.252  38.622  46.844  1.00 60.96           C  
ATOM   5852  CE3 TRP A 705      18.438  40.950  47.381  1.00 63.12           C  
ATOM   5853  CZ2 TRP A 705      17.522  38.368  47.992  1.00 62.19           C  
ATOM   5854  CZ3 TRP A 705      17.709  40.703  48.519  1.00 62.49           C  
ATOM   5855  CH2 TRP A 705      17.253  39.419  48.812  1.00 62.42           C  
ATOM   5856  N   LEU A 706      17.334  40.191  42.417  1.00 66.60           N  
ATOM   5857  CA  LEU A 706      16.890  39.277  41.369  1.00 68.01           C  
ATOM   5858  C   LEU A 706      16.970  39.885  39.934  1.00 68.91           C  
ATOM   5859  O   LEU A 706      16.810  39.170  38.918  1.00 69.27           O  
ATOM   5860  CB  LEU A 706      15.510  38.707  41.696  1.00 67.83           C  
ATOM   5861  CG  LEU A 706      15.404  37.911  43.017  1.00 69.50           C  
ATOM   5862  CD1 LEU A 706      14.081  37.203  43.027  1.00 69.71           C  
ATOM   5863  CD2 LEU A 706      16.548  36.898  43.351  1.00 69.22           C  
ATOM   5864  OXT LEU A 706      17.237  41.102  39.732  1.00 69.05           O  
TER    5865      LEU A 706                                                      
END
MOLECULE T0487_13_176.pdb
ATOM     73  N   ARG    13      31.973   4.298  40.466  1.00 59.39           N  
ATOM     74  CA  ARG    13      33.105   3.822  41.263  1.00 59.66           C  
ATOM     75  C   ARG    13      33.481   2.448  40.739  1.00 58.30           C  
ATOM     76  O   ARG    13      32.677   1.781  40.081  1.00 57.95           O  
ATOM     77  CB  ARG    13      32.738   3.647  42.732  1.00 61.21           C  
ATOM     78  CG  ARG    13      32.238   4.874  43.367  1.00 64.16           C  
ATOM     79  CD  ARG    13      31.922   4.635  44.811  1.00 64.95           C  
ATOM     80  NE  ARG    13      31.799   5.931  45.453  1.00 67.21           N  
ATOM     81  CZ  ARG    13      31.859   6.124  46.754  1.00 67.14           C  
ATOM     82  NH1 ARG    13      32.031   5.086  47.557  1.00 67.21           N  
ATOM     83  NH2 ARG    13      31.788   7.358  47.235  1.00 67.78           N  
ATOM     84  N   PHE    14      34.693   2.018  41.061  1.00 56.41           N  
ATOM     85  CA  PHE    14      35.175   0.726  40.616  1.00 56.49           C  
ATOM     86  C   PHE    14      36.086   0.154  41.681  1.00 57.15           C  
ATOM     87  O   PHE    14      36.900   0.879  42.249  1.00 58.82           O  
ATOM     88  CB  PHE    14      35.932   0.875  39.278  1.00 53.89           C  
ATOM     89  CG  PHE    14      35.121   1.536  38.191  1.00 49.26           C  
ATOM     90  CD1 PHE    14      34.945   2.918  38.170  1.00 47.28           C  
ATOM     91  CD2 PHE    14      34.490   0.773  37.217  1.00 47.81           C  
ATOM     92  CE1 PHE    14      34.149   3.519  37.193  1.00 45.49           C  
ATOM     93  CE2 PHE    14      33.687   1.367  36.231  1.00 43.95           C  
ATOM     94  CZ  PHE    14      33.520   2.730  36.220  1.00 45.62           C  
ATOM     95  N   ALA    15      35.957  -1.144  41.949  1.00 58.08           N  
ATOM     96  CA  ALA    15      36.778  -1.786  42.977  1.00 58.87           C  
ATOM     97  C   ALA    15      38.078  -2.370  42.429  1.00 59.13           C  
ATOM     98  O   ALA    15      38.104  -2.971  41.355  1.00 58.72           O  
ATOM     99  CB  ALA    15      35.973  -2.871  43.685  1.00 57.67           C  
ATOM    100  N   LEU    16      39.158  -2.183  43.178  1.00 59.18           N  
ATOM    101  CA  LEU    16      40.451  -2.692  42.771  1.00 60.54           C  
ATOM    102  C   LEU    16      41.004  -3.676  43.799  1.00 62.32           C  
ATOM    103  O   LEU    16      40.410  -3.886  44.849  1.00 61.77           O  
ATOM    104  CB  LEU    16      41.408  -1.530  42.524  1.00 60.96           C  
ATOM    105  CG  LEU    16      40.958  -0.626  41.353  1.00 62.16           C  
ATOM    106  CD1 LEU    16      41.844   0.609  41.279  1.00 60.09           C  
ATOM    107  CD2 LEU    16      41.002  -1.395  40.025  1.00 60.38           C  
ATOM    108  N   ARG    17      42.132  -4.299  43.491  1.00 64.81           N  
ATOM    109  CA  ARG    17      42.691  -5.285  44.397  1.00 67.20           C  
ATOM    110  C   ARG    17      42.740  -4.768  45.820  1.00 70.61           C  
ATOM    111  O   ARG    17      42.742  -3.564  46.052  1.00 71.60           O  
ATOM    112  CB  ARG    17      44.097  -5.685  43.957  1.00 65.33           C  
ATOM    113  CG  ARG    17      45.128  -4.601  44.135  1.00 65.08           C  
ATOM    114  CD  ARG    17      46.521  -5.172  44.309  1.00 63.68           C  
ATOM    115  NE  ARG    17      47.310  -4.329  45.200  1.00 65.95           N  
ATOM    116  CZ  ARG    17      48.390  -3.652  44.826  1.00 68.32           C  
ATOM    117  NH1 ARG    17      48.821  -3.724  43.574  1.00 70.06           N  
ATOM    118  NH2 ARG    17      49.024  -2.876  45.692  1.00 68.14           N  
ATOM    119  N   PRO    18      42.737  -5.676  46.804  1.00 73.90           N  
ATOM    120  CA  PRO    18      42.797  -5.206  48.191  1.00 75.11           C  
ATOM    121  C   PRO    18      44.229  -4.734  48.409  1.00 76.77           C  
ATOM    122  O   PRO    18      45.119  -5.076  47.631  1.00 76.09           O  
ATOM    123  CB  PRO    18      42.485  -6.464  48.998  1.00 74.96           C  
ATOM    124  CG  PRO    18      41.629  -7.278  48.054  1.00 74.85           C  
ATOM    125  CD  PRO    18      42.363  -7.100  46.749  1.00 74.46           C  
ATOM    126  N   LEU    19      44.460  -3.939  49.445  1.00 79.33           N  
ATOM    127  CA  LEU    19      45.815  -3.482  49.711  1.00 81.93           C  
ATOM    128  C   LEU    19      46.609  -4.638  50.331  1.00 84.42           C  
ATOM    129  O   LEU    19      46.132  -5.323  51.247  1.00 84.14           O  
ATOM    130  CB  LEU    19      45.805  -2.274  50.657  1.00 81.55           C  
ATOM    131  CG  LEU    19      45.371  -0.907  50.111  1.00 82.04           C  
ATOM    132  CD1 LEU    19      43.983  -1.003  49.491  1.00 82.27           C  
ATOM    133  CD2 LEU    19      45.377   0.124  51.236  1.00 81.12           C  
ATOM    134  N   ASN    20      47.811  -4.867  49.810  1.00 86.67           N  
ATOM    135  CA  ASN    20      48.664  -5.925  50.321  1.00 89.22           C  
ATOM    136  C   ASN    20      49.231  -5.463  51.655  1.00 91.10           C  
ATOM    137  O   ASN    20      49.189  -4.273  51.968  1.00 91.62           O  
ATOM    138  CB  ASN    20      49.797  -6.223  49.332  1.00 90.95           C  
ATOM    139  CG  ASN    20      50.740  -5.042  49.129  1.00 92.05           C  
ATOM    140  OD1 ASN    20      51.271  -4.479  50.088  1.00 93.47           O  
ATOM    141  ND2 ASN    20      50.972  -4.680  47.872  1.00 91.60           N  
ATOM    142  N   PRO    21      49.758  -6.394  52.469  1.00 92.64           N  
ATOM    143  CA  PRO    21      50.329  -6.043  53.777  1.00 93.03           C  
ATOM    144  C   PRO    21      51.253  -4.819  53.795  1.00 93.26           C  
ATOM    145  O   PRO    21      51.094  -3.941  54.648  1.00 94.03           O  
ATOM    146  CB  PRO    21      51.036  -7.333  54.212  1.00 93.16           C  
ATOM    147  CG  PRO    21      51.168  -8.143  52.932  1.00 93.95           C  
ATOM    148  CD  PRO    21      49.887  -7.837  52.217  1.00 92.99           C  
ATOM    149  N   GLU    22      52.196  -4.748  52.855  1.00 92.42           N  
ATOM    150  CA  GLU    22      53.135  -3.621  52.783  1.00 92.25           C  
ATOM    151  C   GLU    22      52.464  -2.242  52.784  1.00 90.18           C  
ATOM    152  O   GLU    22      52.927  -1.316  53.438  1.00 88.53           O  
ATOM    153  CB  GLU    22      54.008  -3.731  51.525  1.00 94.48           C  
ATOM    154  CG  GLU    22      54.916  -4.942  51.487  1.00 98.22           C  
ATOM    155  CD  GLU    22      54.143  -6.239  51.645  1.00101.59           C  
ATOM    156  OE1 GLU    22      53.215  -6.484  50.842  1.00101.73           O  
ATOM    157  OE2 GLU    22      54.462  -7.014  52.577  1.00103.69           O  
ATOM    158  N   GLU    23      51.374  -2.113  52.040  1.00 89.02           N  
ATOM    159  CA  GLU    23      50.660  -0.849  51.932  1.00 87.43           C  
ATOM    160  C   GLU    23      49.761  -0.589  53.128  1.00 86.72           C  
ATOM    161  O   GLU    23      49.181   0.489  53.258  1.00 86.51           O  
ATOM    162  CB  GLU    23      49.844  -0.845  50.641  1.00 87.07           C  
ATOM    163  CG  GLU    23      50.691  -1.231  49.439  1.00 86.82           C  
ATOM    164  CD  GLU    23      49.876  -1.575  48.209  1.00 86.51           C  
ATOM    165  OE1 GLU    23      48.796  -2.186  48.354  1.00 86.21           O  
ATOM    166  OE2 GLU    23      50.334  -1.251  47.092  1.00 86.66           O  
ATOM    167  N   LEU    24      49.636  -1.585  53.998  1.00 85.54           N  
ATOM    168  CA  LEU    24      48.811  -1.436  55.182  1.00 84.08           C  
ATOM    169  C   LEU    24      49.744  -1.004  56.299  1.00 84.53           C  
ATOM    170  O   LEU    24      49.316  -0.552  57.365  1.00 84.00           O  
ATOM    171  CB  LEU    24      48.119  -2.760  55.510  1.00 82.17           C  
ATOM    172  CG  LEU    24      46.849  -3.050  54.707  1.00 80.47           C  
ATOM    173  CD1 LEU    24      46.452  -4.502  54.869  1.00 80.15           C  
ATOM    174  CD2 LEU    24      45.729  -2.132  55.171  1.00 79.01           C  
ATOM    175  N   ARG    25      51.035  -1.131  56.020  1.00 85.12           N  
ATOM    176  CA  ARG    25      52.076  -0.756  56.959  1.00 86.52           C  
ATOM    177  C   ARG    25      53.008   0.280  56.323  1.00 85.98           C  
ATOM    178  O   ARG    25      54.157  -0.004  56.002  1.00 85.01           O  
ATOM    179  CB  ARG    25      52.871  -1.998  57.377  1.00 89.00           C  
ATOM    180  CG  ARG    25      52.353  -2.724  58.619  1.00 90.63           C  
ATOM    181  CD  ARG    25      50.940  -3.226  58.432  1.00 91.79           C  
ATOM    182  NE  ARG    25      50.573  -4.153  59.492  1.00 93.59           N  
ATOM    183  CZ  ARG    25      49.434  -4.833  59.530  1.00 94.01           C  
ATOM    184  NH1 ARG    25      48.539  -4.690  58.562  1.00 92.90           N  
ATOM    185  NH2 ARG    25      49.196  -5.665  60.537  1.00 95.41           N  
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
ATOM    744  N   PRO    97      51.524   0.356  61.154  1.00 90.60           N  
ATOM    745  CA  PRO    97      50.191  -0.065  60.693  1.00 89.48           C  
ATOM    746  C   PRO    97      48.978   0.872  60.896  1.00 88.63           C  
ATOM    747  O   PRO    97      48.822   1.536  61.935  1.00 88.58           O  
ATOM    748  CB  PRO    97      49.981  -1.359  61.459  1.00 90.16           C  
ATOM    749  CG  PRO    97      50.550  -0.981  62.800  1.00 90.97           C  
ATOM    750  CD  PRO    97      51.837  -0.271  62.462  1.00 90.82           C  
ATOM    751  N   LEU    98      48.086   0.876  59.908  1.00 87.92           N  
ATOM    752  CA  LEU    98      46.852   1.679  59.909  1.00 87.54           C  
ATOM    753  C   LEU    98      45.641   0.780  59.628  1.00 86.35           C  
ATOM    754  O   LEU    98      45.745  -0.173  58.859  1.00 86.40           O  
ATOM    755  CB  LEU    98      46.911   2.768  58.822  1.00 89.09           C  
ATOM    756  CG  LEU    98      47.644   4.109  58.968  1.00 88.65           C  
ATOM    757  CD1 LEU    98      49.045   3.940  59.521  1.00 89.22           C  
ATOM    758  CD2 LEU    98      47.712   4.745  57.589  1.00 89.87           C  
ATOM    759  N   ASP    99      44.496   1.091  60.237  1.00 85.53           N  
ATOM    760  CA  ASP    99      43.278   0.289  60.041  1.00 84.74           C  
ATOM    761  C   ASP    99      42.159   0.999  59.284  1.00 81.33           C  
ATOM    762  O   ASP    99      41.670   2.054  59.692  1.00 80.11           O  
ATOM    763  CB  ASP    99      42.725  -0.242  61.384  1.00 88.35           C  
ATOM    764  CG  ASP    99      42.224   0.868  62.316  1.00 92.89           C  
ATOM    765  OD1 ASP    99      41.730   0.534  63.424  1.00 95.55           O  
ATOM    766  OD2 ASP    99      42.325   2.066  61.956  1.00 93.80           O  
ATOM    767  N   PRO   100      41.737   0.410  58.163  1.00 78.86           N  
ATOM    768  CA  PRO   100      40.674   0.945  57.306  1.00 78.44           C  
ATOM    769  C   PRO   100      39.360   1.178  58.059  1.00 77.45           C  
ATOM    770  O   PRO   100      38.489   1.927  57.613  1.00 75.53           O  
ATOM    771  CB  PRO   100      40.540  -0.128  56.220  1.00 78.10           C  
ATOM    772  CG  PRO   100      41.927  -0.685  56.129  1.00 77.63           C  
ATOM    773  CD  PRO   100      42.346  -0.792  57.566  1.00 77.31           C  
ATOM    774  N   LYS   101      39.234   0.528  59.207  1.00 78.45           N  
ATOM    775  CA  LYS   101      38.036   0.627  60.029  1.00 79.90           C  
ATOM    776  C   LYS   101      37.967   1.948  60.801  1.00 79.56           C  
ATOM    777  O   LYS   101      36.885   2.405  61.159  1.00 77.93           O  
ATOM    778  CB  LYS   101      37.991  -0.549  61.005  1.00 81.68           C  
ATOM    779  CG  LYS   101      38.480  -1.865  60.414  1.00 83.52           C  
ATOM    780  CD  LYS   101      40.002  -1.878  60.264  1.00 83.96           C  
ATOM    781  CE  LYS   101      40.473  -3.135  59.539  1.00 84.31           C  
ATOM    782  NZ  LYS   101      41.955  -3.210  59.437  1.00 84.04           N  
ATOM    783  N   ASP   102      39.129   2.551  61.041  1.00 80.64           N  
ATOM    784  CA  ASP   102      39.234   3.817  61.761  1.00 82.70           C  
ATOM    785  C   ASP   102      39.176   5.025  60.814  1.00 82.44           C  
ATOM    786  O   ASP   102      40.081   5.235  59.997  1.00 79.79           O  
ATOM    787  CB  ASP   102      40.541   3.850  62.555  1.00 85.74           C  
ATOM    788  CG  ASP   102      40.646   5.056  63.475  1.00 89.25           C  
ATOM    789  OD1 ASP   102      40.780   6.196  62.968  1.00 89.10           O  
ATOM    790  OD2 ASP   102      40.594   4.852  64.716  1.00 92.75           O  
ATOM    791  N   PRO   103      38.118   5.851  60.944  1.00 82.42           N  
ATOM    792  CA  PRO   103      37.898   7.046  60.124  1.00 82.10           C  
ATOM    793  C   PRO   103      39.133   7.908  59.860  1.00 80.70           C  
ATOM    794  O   PRO   103      39.308   8.421  58.753  1.00 80.86           O  
ATOM    795  CB  PRO   103      36.808   7.792  60.897  1.00 81.86           C  
ATOM    796  CG  PRO   103      35.983   6.671  61.431  1.00 81.48           C  
ATOM    797  CD  PRO   103      37.062   5.740  61.971  1.00 82.18           C  
ATOM    798  N   GLY   104      39.988   8.049  60.864  1.00 79.06           N  
ATOM    799  CA  GLY   104      41.177   8.864  60.700  1.00 78.37           C  
ATOM    800  C   GLY   104      42.316   8.198  59.953  1.00 78.10           C  
ATOM    801  O   GLY   104      42.884   8.779  59.025  1.00 77.03           O  
ATOM    802  N   GLU   105      42.659   6.981  60.360  1.00 78.40           N  
ATOM    803  CA  GLU   105      43.744   6.240  59.725  1.00 78.99           C  
ATOM    804  C   GLU   105      43.413   5.894  58.278  1.00 77.22           C  
ATOM    805  O   GLU   105      44.285   5.858  57.419  1.00 77.36           O  
ATOM    806  CB  GLU   105      44.048   4.974  60.528  1.00 81.54           C  
ATOM    807  CG  GLU   105      45.054   5.222  61.641  1.00 87.07           C  
ATOM    808  CD  GLU   105      44.955   4.232  62.795  1.00 90.76           C  
ATOM    809  OE1 GLU   105      45.013   3.005  62.546  1.00 92.73           O  
ATOM    810  OE2 GLU   105      44.829   4.689  63.957  1.00 92.21           O  
ATOM    811  N   ARG   106      42.142   5.654  58.013  1.00 75.03           N  
ATOM    812  CA  ARG   106      41.705   5.331  56.675  1.00 73.33           C  
ATOM    813  C   ARG   106      41.866   6.555  55.777  1.00 72.50           C  
ATOM    814  O   ARG   106      42.196   6.428  54.598  1.00 72.89           O  
ATOM    815  CB  ARG   106      40.243   4.905  56.703  1.00 73.84           C  
ATOM    816  CG  ARG   106      39.655   4.610  55.355  1.00 77.66           C  
ATOM    817  CD  ARG   106      38.140   4.759  55.372  1.00 81.26           C  
ATOM    818  NE  ARG   106      37.583   4.603  54.032  1.00 85.82           N  
ATOM    819  CZ  ARG   106      36.351   4.962  53.678  1.00 88.83           C  
ATOM    820  NH1 ARG   106      35.532   5.506  54.572  1.00 89.61           N  
ATOM    821  NH2 ARG   106      35.940   4.785  52.423  1.00 89.25           N  
ATOM    822  N   SER   107      41.633   7.742  56.333  1.00 70.78           N  
ATOM    823  CA  SER   107      41.744   8.972  55.549  1.00 67.82           C  
ATOM    824  C   SER   107      43.176   9.174  55.080  1.00 66.49           C  
ATOM    825  O   SER   107      43.404   9.793  54.035  1.00 66.15           O  
ATOM    826  CB  SER   107      41.315  10.190  56.368  1.00 66.66           C  
ATOM    827  OG  SER   107      42.429  10.756  57.037  1.00 68.47           O  
ATOM    828  N   VAL   108      44.127   8.651  55.858  1.00 64.47           N  
ATOM    829  CA  VAL   108      45.549   8.755  55.549  1.00 62.95           C  
ATOM    830  C   VAL   108      45.921   7.759  54.472  1.00 63.50           C  
ATOM    831  O   VAL   108      46.596   8.109  53.502  1.00 64.63           O  
ATOM    832  CB  VAL   108      46.429   8.496  56.800  1.00 62.97           C  
ATOM    833  CG1 VAL   108      47.877   8.232  56.397  1.00 60.07           C  
ATOM    834  CG2 VAL   108      46.361   9.699  57.725  1.00 63.07           C  
ATOM    835  N   LEU   109      45.482   6.515  54.632  1.00 63.15           N  
ATOM    836  CA  LEU   109      45.787   5.491  53.635  1.00 62.19           C  
ATOM    837  C   LEU   109      45.290   5.942  52.257  1.00 60.92           C  
ATOM    838  O   LEU   109      45.945   5.686  51.249  1.00 60.16           O  
ATOM    839  CB  LEU   109      45.147   4.145  54.026  1.00 60.53           C  
ATOM    840  CG  LEU   109      45.900   3.301  55.070  1.00 60.39           C  
ATOM    841  CD1 LEU   109      44.999   2.165  55.552  1.00 58.69           C  
ATOM    842  CD2 LEU   109      47.205   2.765  54.486  1.00 55.69           C  
ATOM    843  N   SER   110      44.140   6.616  52.240  1.00 58.67           N  
ATOM    844  CA  SER   110      43.528   7.117  51.015  1.00 58.92           C  
ATOM    845  C   SER   110      44.305   8.276  50.422  1.00 58.98           C  
ATOM    846  O   SER   110      44.239   8.524  49.218  1.00 58.97           O  
ATOM    847  CB  SER   110      42.092   7.587  51.269  1.00 58.40           C  
ATOM    848  OG  SER   110      41.194   6.498  51.302  1.00 59.26           O  
ATOM    849  N   ALA   111      45.009   9.006  51.277  1.00 57.94           N  
ATOM    850  CA  ALA   111      45.800  10.128  50.821  1.00 56.24           C  
ATOM    851  C   ALA   111      46.970   9.522  50.079  1.00 55.63           C  
ATOM    852  O   ALA   111      47.416  10.037  49.065  1.00 57.35           O  
ATOM    853  CB  ALA   111      46.282  10.926  51.989  1.00 55.30           C  
ATOM    854  N   LEU   112      47.472   8.416  50.595  1.00 54.79           N  
ATOM    855  CA  LEU   112      48.578   7.749  49.942  1.00 55.19           C  
ATOM    856  C   LEU   112      48.104   7.275  48.576  1.00 53.33           C  
ATOM    857  O   LEU   112      48.802   7.438  47.587  1.00 53.50           O  
ATOM    858  CB  LEU   112      49.076   6.573  50.794  1.00 55.11           C  
ATOM    859  CG  LEU   112      49.862   7.035  52.030  1.00 56.18           C  
ATOM    860  CD1 LEU   112      49.829   5.963  53.111  1.00 55.35           C  
ATOM    861  CD2 LEU   112      51.307   7.388  51.622  1.00 54.94           C  
ATOM    862  N   ALA   113      46.907   6.709  48.533  1.00 51.67           N  
ATOM    863  CA  ALA   113      46.326   6.221  47.292  1.00 51.20           C  
ATOM    864  C   ALA   113      46.153   7.357  46.274  1.00 50.60           C  
ATOM    865  O   ALA   113      46.504   7.200  45.117  1.00 50.46           O  
ATOM    866  CB  ALA   113      44.989   5.575  47.576  1.00 52.01           C  
ATOM    867  N   ARG   114      45.613   8.489  46.716  1.00 49.15           N  
ATOM    868  CA  ARG   114      45.409   9.632  45.856  1.00 49.51           C  
ATOM    869  C   ARG   114      46.769   9.996  45.270  1.00 51.04           C  
ATOM    870  O   ARG   114      46.915  10.198  44.061  1.00 51.84           O  
ATOM    871  CB  ARG   114      44.826  10.810  46.660  1.00 49.19           C  
ATOM    872  CG  ARG   114      44.355  12.000  45.807  1.00 52.27           C  
ATOM    873  CD  ARG   114      43.813  13.194  46.619  1.00 55.32           C  
ATOM    874  NE  ARG   114      44.149  14.496  46.007  1.00 61.37           N  
ATOM    875  CZ  ARG   114      44.054  15.691  46.618  1.00 65.98           C  
ATOM    876  NH1 ARG   114      43.627  15.784  47.883  1.00 65.95           N  
ATOM    877  NH2 ARG   114      44.396  16.812  45.970  1.00 64.49           N  
ATOM    878  N   ARG   115      47.781  10.034  46.127  1.00 52.10           N  
ATOM    879  CA  ARG   115      49.120  10.377  45.690  1.00 52.46           C  
ATOM    880  C   ARG   115      49.695   9.356  44.726  1.00 51.72           C  
ATOM    881  O   ARG   115      50.507   9.687  43.874  1.00 50.66           O  
ATOM    882  CB  ARG   115      50.034  10.504  46.893  1.00 54.19           C  
ATOM    883  CG  ARG   115      51.333  11.201  46.591  1.00 58.70           C  
ATOM    884  CD  ARG   115      51.122  12.658  46.193  1.00 64.25           C  
ATOM    885  NE  ARG   115      52.386  13.379  46.300  1.00 71.61           N  
ATOM    886  CZ  ARG   115      53.425  13.202  45.483  1.00 74.87           C  
ATOM    887  NH1 ARG   115      53.351  12.338  44.479  1.00 75.09           N  
ATOM    888  NH2 ARG   115      54.562  13.858  45.696  1.00 77.88           N  
ATOM    889  N   LEU   116      49.270   8.108  44.875  1.00 53.33           N  
ATOM    890  CA  LEU   116      49.737   7.024  44.025  1.00 53.58           C  
ATOM    891  C   LEU   116      49.196   7.267  42.632  1.00 54.07           C  
ATOM    892  O   LEU   116      49.904   7.129  41.641  1.00 53.57           O  
ATOM    893  CB  LEU   116      49.223   5.685  44.541  1.00 53.00           C  
ATOM    894  CG  LEU   116      49.707   4.495  43.700  1.00 55.61           C  
ATOM    895  CD1 LEU   116      51.238   4.431  43.760  1.00 55.15           C  
ATOM    896  CD2 LEU   116      49.088   3.196  44.202  1.00 52.60           C  
ATOM    897  N   LEU   117      47.927   7.644  42.575  1.00 55.37           N  
ATOM    898  CA  LEU   117      47.273   7.909  41.312  1.00 56.86           C  
ATOM    899  C   LEU   117      48.001   9.045  40.601  1.00 58.79           C  
ATOM    900  O   LEU   117      48.218   8.992  39.397  1.00 57.58           O  
ATOM    901  CB  LEU   117      45.817   8.285  41.549  1.00 54.08           C  
ATOM    902  CG  LEU   117      45.092   8.604  40.250  1.00 55.91           C  
ATOM    903  CD1 LEU   117      45.068   7.355  39.383  1.00 52.57           C  
ATOM    904  CD2 LEU   117      43.685   9.124  40.549  1.00 54.28           C  
ATOM    905  N   GLN   118      48.364  10.076  41.357  1.00 61.30           N  
ATOM    906  CA  GLN   118      49.087  11.212  40.813  1.00 64.01           C  
ATOM    907  C   GLN   118      50.420  10.789  40.208  1.00 65.87           C  
ATOM    908  O   GLN   118      50.724  11.114  39.060  1.00 66.18           O  
ATOM    909  CB  GLN   118      49.369  12.240  41.904  1.00 66.27           C  
ATOM    910  CG  GLN   118      48.333  13.338  42.033  1.00 70.48           C  
ATOM    911  CD  GLN   118      48.967  14.674  42.403  1.00 71.81           C  
ATOM    912  OE1 GLN   118      49.490  14.842  43.507  1.00 72.65           O  
ATOM    913  NE2 GLN   118      48.936  15.627  41.470  1.00 71.99           N  
ATOM    914  N   GLU   119      51.226  10.070  40.984  1.00 67.06           N  
ATOM    915  CA  GLU   119      52.523   9.645  40.494  1.00 67.50           C  
ATOM    916  C   GLU   119      52.431   8.820  39.221  1.00 67.60           C  
ATOM    917  O   GLU   119      53.225   9.003  38.302  1.00 68.48           O  
ATOM    918  CB  GLU   119      53.275   8.878  41.573  1.00 68.66           C  
ATOM    919  CG  GLU   119      53.928   9.767  42.620  1.00 71.97           C  
ATOM    920  CD  GLU   119      54.828  10.844  42.016  1.00 74.74           C  
ATOM    921  OE1 GLU   119      55.733  10.510  41.209  1.00 75.46           O  
ATOM    922  OE2 GLU   119      54.630  12.031  42.356  1.00 75.41           O  
ATOM    923  N   ARG   120      51.465   7.918  39.154  1.00 67.09           N  
ATOM    924  CA  ARG   120      51.316   7.101  37.962  1.00 67.86           C  
ATOM    925  C   ARG   120      50.855   7.967  36.786  1.00 67.81           C  
ATOM    926  O   ARG   120      51.320   7.796  35.664  1.00 67.79           O  
ATOM    927  CB  ARG   120      50.324   5.966  38.224  1.00 68.54           C  
ATOM    928  CG  ARG   120      50.763   5.028  39.331  1.00 70.24           C  
ATOM    929  CD  ARG   120      50.838   3.592  38.829  1.00 73.28           C  
ATOM    930  NE  ARG   120      51.951   2.858  39.433  1.00 74.70           N  
ATOM    931  CZ  ARG   120      51.835   1.959  40.406  1.00 75.34           C  
ATOM    932  NH1 ARG   120      50.644   1.651  40.908  1.00 76.24           N  
ATOM    933  NH2 ARG   120      52.925   1.377  40.890  1.00 75.76           N  
ATOM    934  N   LEU   121      49.947   8.899  37.050  1.00 68.08           N  
ATOM    935  CA  LEU   121      49.439   9.791  36.018  1.00 68.24           C  
ATOM    936  C   LEU   121      50.554  10.682  35.488  1.00 70.62           C  
ATOM    937  O   LEU   121      50.622  10.976  34.292  1.00 71.40           O  
ATOM    938  CB  LEU   121      48.317  10.687  36.563  1.00 64.60           C  
ATOM    939  CG  LEU   121      46.905  10.115  36.721  1.00 63.20           C  
ATOM    940  CD1 LEU   121      45.941  11.241  37.003  1.00 62.27           C  
ATOM    941  CD2 LEU   121      46.476   9.417  35.457  1.00 62.87           C  
ATOM    942  N   ARG   122      51.433  11.111  36.385  1.00 72.33           N  
ATOM    943  CA  ARG   122      52.519  11.988  35.998  1.00 73.62           C  
ATOM    944  C   ARG   122      53.534  11.322  35.066  1.00 74.20           C  
ATOM    945  O   ARG   122      54.229  12.009  34.319  1.00 74.67           O  
ATOM    946  CB  ARG   122      53.219  12.521  37.242  1.00 74.51           C  
ATOM    947  CG  ARG   122      54.192  13.639  36.940  1.00 78.84           C  
ATOM    948  CD  ARG   122      54.973  14.074  38.172  1.00 81.78           C  
ATOM    949  NE  ARG   122      55.975  13.088  38.585  1.00 85.00           N  
ATOM    950  CZ  ARG   122      57.036  12.739  37.856  1.00 86.41           C  
ATOM    951  NH1 ARG   122      57.243  13.290  36.664  1.00 87.13           N  
ATOM    952  NH2 ARG   122      57.900  11.843  38.322  1.00 85.88           N  
ATOM    953  N   ARG   123      53.609   9.995  35.087  1.00 74.20           N  
ATOM    954  CA  ARG   123      54.559   9.288  34.242  1.00 75.77           C  
ATOM    955  C   ARG   123      53.935   8.726  32.975  1.00 76.88           C  
ATOM    956  O   ARG   123      54.529   7.891  32.286  1.00 77.15           O  
ATOM    957  CB  ARG   123      55.226   8.171  35.042  1.00 77.07           C  
ATOM    958  CG  ARG   123      56.273   8.678  36.018  1.00 79.66           C  
ATOM    959  CD  ARG   123      56.275   7.859  37.307  1.00 84.37           C  
ATOM    960  NE  ARG   123      57.260   8.341  38.279  1.00 87.36           N  
ATOM    961  CZ  ARG   123      58.298   7.629  38.714  1.00 88.63           C  
ATOM    962  NH1 ARG   123      58.499   6.390  38.268  1.00 88.48           N  
ATOM    963  NH2 ARG   123      59.143   8.157  39.595  1.00 88.92           N  
ATOM    964  N   LEU   124      52.736   9.194  32.660  1.00 78.38           N  
ATOM    965  CA  LEU   124      52.048   8.723  31.472  1.00 79.17           C  
ATOM    966  C   LEU   124      52.505   9.401  30.195  1.00 81.39           C  
ATOM    967  O   LEU   124      52.708  10.620  30.141  1.00 80.31           O  
ATOM    968  CB  LEU   124      50.540   8.876  31.631  1.00 77.62           C  
ATOM    969  CG  LEU   124      49.923   7.711  32.394  1.00 76.01           C  
ATOM    970  CD1 LEU   124      48.422   7.901  32.513  1.00 75.32           C  
ATOM    971  CD2 LEU   124      50.252   6.424  31.660  1.00 75.36           C  
ATOM    972  N   GLU   125      52.652   8.574  29.164  1.00 84.49           N  
ATOM    973  CA  GLU   125      53.110   8.994  27.845  1.00 85.71           C  
ATOM    974  C   GLU   125      52.056   9.689  26.994  1.00 85.14           C  
ATOM    975  O   GLU   125      50.935   9.205  26.858  1.00 85.22           O  
ATOM    976  CB  GLU   125      53.637   7.770  27.105  1.00 87.34           C  
ATOM    977  CG  GLU   125      52.672   6.596  27.120  1.00 90.13           C  
ATOM    978  CD  GLU   125      53.277   5.342  26.503  1.00 93.48           C  
ATOM    979  OE1 GLU   125      52.526   4.364  26.264  1.00 93.88           O  
ATOM    980  OE2 GLU   125      54.508   5.332  26.262  1.00 94.50           O  
ATOM    981  N   GLY   126      52.432  10.827  26.421  1.00 84.38           N  
ATOM    982  CA  GLY   126      51.525  11.569  25.567  1.00 84.11           C  
ATOM    983  C   GLY   126      50.109  11.654  26.094  1.00 84.57           C  
ATOM    984  O   GLY   126      49.202  10.961  25.621  1.00 84.45           O  
ATOM    985  N   VAL   127      49.923  12.512  27.088  1.00 84.08           N  
ATOM    986  CA  VAL   127      48.620  12.718  27.692  1.00 82.67           C  
ATOM    987  C   VAL   127      48.748  13.875  28.618  1.00 81.90           C  
ATOM    988  O   VAL   127      49.804  14.183  29.172  1.00 82.37           O  
ATOM    989  CB  VAL   127      48.136  11.527  28.488  1.00 83.19           C  
ATOM    990  CG1 VAL   127      48.848  11.468  29.813  1.00 83.20           C  
ATOM    991  CG2 VAL   127      46.632  11.661  28.705  1.00 85.44           C  
ATOM    992  N   TRP   128      47.632  14.468  28.887  1.00 80.51           N  
ATOM    993  CA  TRP   128      47.734  15.623  29.638  1.00 80.52           C  
ATOM    994  C   TRP   128      47.141  15.645  31.061  1.00 79.00           C  
ATOM    995  O   TRP   128      45.951  15.445  31.262  1.00 77.99           O  
ATOM    996  CB  TRP   128      47.134  16.624  28.761  1.00 82.46           C  
ATOM    997  CG  TRP   128      46.958  17.666  29.437  1.00 85.61           C  
ATOM    998  CD1 TRP   128      46.005  17.899  30.373  1.00 86.56           C  
ATOM    999  CD2 TRP   128      47.763  18.784  29.346  1.00 86.36           C  
ATOM   1000  NE1 TRP   128      46.174  19.156  30.883  1.00 86.71           N  
ATOM   1001  CE2 TRP   128      47.266  19.720  30.273  1.00 86.60           C  
ATOM   1002  CE3 TRP   128      48.886  19.099  28.561  1.00 87.01           C  
ATOM   1003  CZ2 TRP   128      47.840  20.951  30.448  1.00 86.74           C  
ATOM   1004  CZ3 TRP   128      49.470  20.322  28.713  1.00 87.31           C  
ATOM   1005  CH2 TRP   128      48.950  21.250  29.666  1.00 87.56           C  
ATOM   1006  N   VAL   129      47.980  15.960  32.033  1.00 75.97           N  
ATOM   1007  CA  VAL   129      47.559  15.911  33.410  1.00 75.60           C  
ATOM   1008  C   VAL   129      47.448  17.230  34.159  1.00 76.75           C  
ATOM   1009  O   VAL   129      48.377  18.013  34.180  1.00 77.49           O  
ATOM   1010  CB  VAL   129      48.481  14.982  34.158  1.00 73.90           C  
ATOM   1011  CG1 VAL   129      47.937  14.678  35.508  1.00 72.70           C  
ATOM   1012  CG2 VAL   129      48.676  13.740  33.319  1.00 74.83           C  
ATOM   1013  N   GLU   130      46.312  17.452  34.812  1.00 77.77           N  
ATOM   1014  CA  GLU   130      46.095  18.674  35.558  1.00 78.92           C  
ATOM   1015  C   GLU   130      45.676  18.287  36.984  1.00 78.24           C  
ATOM   1016  O   GLU   130      44.547  18.553  37.417  1.00 78.14           O  
ATOM   1017  CB  GLU   130      45.014  19.508  34.858  1.00 81.69           C  
ATOM   1018  CG  GLU   130      45.052  21.006  35.164  1.00 87.16           C  
ATOM   1019  CD  GLU   130      44.100  21.814  34.283  1.00 90.28           C  
ATOM   1020  OE1 GLU   130      42.880  21.856  34.573  1.00 91.28           O  
ATOM   1021  OE2 GLU   130      44.580  22.401  33.286  1.00 92.44           O  
ATOM   1022  N   GLY   131      46.598  17.647  37.702  1.00 76.55           N  
ATOM   1023  CA  GLY   131      46.330  17.230  39.068  1.00 74.58           C  
ATOM   1024  C   GLY   131      45.865  15.791  39.106  1.00 73.64           C  
ATOM   1025  O   GLY   131      46.671  14.882  38.911  1.00 73.38           O  
ATOM   1026  N   LEU   132      44.571  15.590  39.366  1.00 72.73           N  
ATOM   1027  CA  LEU   132      43.975  14.258  39.397  1.00 71.14           C  
ATOM   1028  C   LEU   132      43.165  14.024  38.134  1.00 70.81           C  
ATOM   1029  O   LEU   132      42.451  13.033  38.009  1.00 70.97           O  
ATOM   1030  CB  LEU   132      43.082  14.082  40.626  1.00 69.55           C  
ATOM   1031  CG  LEU   132      43.854  13.777  41.914  1.00 69.71           C  
ATOM   1032  CD1 LEU   132      42.862  13.482  43.025  1.00 68.93           C  
ATOM   1033  CD2 LEU   132      44.797  12.593  41.702  1.00 67.63           C  
ATOM   1034  N   ALA   133      43.291  14.946  37.190  1.00 70.99           N  
ATOM   1035  CA  ALA   133      42.580  14.843  35.932  1.00 70.67           C  
ATOM   1036  C   ALA   133      43.492  14.341  34.812  1.00 70.47           C  
ATOM   1037  O   ALA   133      44.708  14.505  34.855  1.00 69.45           O  
ATOM   1038  CB  ALA   133      41.990  16.195  35.566  1.00 70.41           C  
ATOM   1039  N   VAL   134      42.892  13.691  33.827  1.00 70.67           N  
ATOM   1040  CA  VAL   134      43.635  13.193  32.689  1.00 71.29           C  
ATOM   1041  C   VAL   134      42.827  13.645  31.498  1.00 72.40           C  
ATOM   1042  O   VAL   134      41.604  13.543  31.505  1.00 71.80           O  
ATOM   1043  CB  VAL   134      43.695  11.657  32.623  1.00 70.65           C  
ATOM   1044  CG1 VAL   134      44.702  11.235  31.579  1.00 69.82           C  
ATOM   1045  CG2 VAL   134      44.058  11.080  33.954  1.00 72.45           C  
ATOM   1046  N   TYR   135      43.514  14.167  30.492  1.00 73.97           N  
ATOM   1047  CA  TYR   135      42.872  14.607  29.267  1.00 74.92           C  
ATOM   1048  C   TYR   135      43.616  13.860  28.175  1.00 76.66           C  
ATOM   1049  O   TYR   135      44.782  14.113  27.913  1.00 77.04           O  
ATOM   1050  CB  TYR   135      42.971  16.128  29.138  1.00 72.52           C  
ATOM   1051  CG  TYR   135      42.156  16.810  30.207  1.00 70.54           C  
ATOM   1052  CD1 TYR   135      42.708  17.125  31.442  1.00 70.96           C  
ATOM   1053  CD2 TYR   135      40.795  17.033  30.027  1.00 71.86           C  
ATOM   1054  CE1 TYR   135      41.918  17.651  32.484  1.00 70.63           C  
ATOM   1055  CE2 TYR   135      39.989  17.548  31.060  1.00 71.08           C  
ATOM   1056  CZ  TYR   135      40.559  17.855  32.283  1.00 70.70           C  
ATOM   1057  OH  TYR   135      39.771  18.361  33.292  1.00 68.68           O  
ATOM   1058  N   ARG   136      42.931  12.891  27.579  1.00 79.43           N  
ATOM   1059  CA  ARG   136      43.527  12.047  26.553  1.00 82.21           C  
ATOM   1060  C   ARG   136      43.487  12.561  25.112  1.00 82.50           C  
ATOM   1061  O   ARG   136      44.511  12.540  24.426  1.00 83.13           O  
ATOM   1062  CB  ARG   136      42.885  10.662  26.595  1.00 84.89           C  
ATOM   1063  CG  ARG   136      42.700  10.095  27.989  1.00 89.03           C  
ATOM   1064  CD  ARG   136      42.321   8.624  27.926  1.00 94.02           C  
ATOM   1065  NE  ARG   136      41.072   8.379  27.196  1.00 98.32           N  
ATOM   1066  CZ  ARG   136      40.660   7.178  26.773  1.00100.24           C  
ATOM   1067  NH1 ARG   136      41.394   6.092  26.997  1.00100.92           N  
ATOM   1068  NH2 ARG   136      39.507   7.054  26.123  1.00 99.02           N  
ATOM   1069  N   ARG   137      42.323  13.020  24.652  1.00 81.91           N  
ATOM   1070  CA  ARG   137      42.193  13.456  23.266  1.00 80.78           C  
ATOM   1071  C   ARG   137      41.467  14.750  22.926  1.00 81.03           C  
ATOM   1072  O   ARG   137      40.510  15.150  23.587  1.00 80.59           O  
ATOM   1073  CB  ARG   137      41.551  12.334  22.471  1.00 81.17           C  
ATOM   1074  CG  ARG   137      40.339  11.709  23.145  1.00 79.96           C  
ATOM   1075  CD  ARG   137      39.832  10.566  22.298  1.00 81.08           C  
ATOM   1076  NE  ARG   137      40.939   9.735  21.829  1.00 82.40           N  
ATOM   1077  CZ  ARG   137      41.252   8.539  22.320  1.00 83.14           C  
ATOM   1078  NH1 ARG   137      40.541   8.007  23.307  1.00 84.17           N  
ATOM   1079  NH2 ARG   137      42.283   7.872  21.823  1.00 82.61           N  
ATOM   1080  N   GLU   138      41.920  15.368  21.837  1.00 82.42           N  
ATOM   1081  CA  GLU   138      41.378  16.626  21.331  1.00 83.22           C  
ATOM   1082  C   GLU   138      39.941  16.567  20.846  1.00 83.78           C  
ATOM   1083  O   GLU   138      39.455  15.521  20.442  1.00 84.00           O  
ATOM   1084  CB  GLU   138      42.252  17.147  20.198  1.00 83.28           C  
ATOM   1085  CG  GLU   138      43.532  17.798  20.665  1.00 85.60           C  
ATOM   1086  CD  GLU   138      44.228  18.547  19.553  1.00 87.23           C  
ATOM   1087  OE1 GLU   138      43.518  19.061  18.659  1.00 87.20           O  
ATOM   1088  OE2 GLU   138      45.477  18.632  19.582  1.00 88.25           O  
ATOM   1089  N   HIS   139      39.271  17.713  20.880  1.00 85.40           N  
ATOM   1090  CA  HIS   139      37.882  17.815  20.449  1.00 87.35           C  
ATOM   1091  C   HIS   139      37.633  19.055  19.610  1.00 87.96           C  
ATOM   1092  O   HIS   139      36.544  19.230  19.068  1.00 89.27           O  
ATOM   1093  CB  HIS   139      36.934  17.840  21.652  1.00 88.46           C  
ATOM   1094  CG  HIS   139      36.643  16.485  22.219  1.00 91.04           C  
ATOM   1095  ND1 HIS   139      37.569  15.763  22.942  1.00 92.06           N  
ATOM   1096  CD2 HIS   139      35.540  15.704  22.138  1.00 91.59           C  
ATOM   1097  CE1 HIS   139      37.049  14.596  23.281  1.00 91.95           C  
ATOM   1098  NE2 HIS   139      35.818  14.536  22.806  1.00 91.16           N  
ATOM   1099  N   ALA   140      38.641  19.912  19.507  1.00 87.65           N  
ATOM   1100  CA  ALA   140      38.535  21.147  18.742  1.00 87.55           C  
ATOM   1101  C   ALA   140      39.808  21.893  19.044  1.00 88.15           C  
ATOM   1102  O   ALA   140      40.442  21.615  20.060  1.00 88.01           O  
ATOM   1103  CB  ALA   140      37.340  21.957  19.209  1.00 87.03           C  
ATOM   1104  N   ARG   141      40.194  22.829  18.180  1.00 88.44           N  
ATOM   1105  CA  ARG   141      41.412  23.568  18.440  1.00 89.04           C  
ATOM   1106  C   ARG   141      41.438  25.018  17.965  1.00 90.28           C  
ATOM   1107  O   ARG   141      41.049  25.905  18.701  1.00 90.53           O  
ATOM   1108  CB  ARG   141      42.622  22.784  17.912  1.00 87.72           C  
ATOM   1109  CG  ARG   141      42.749  22.703  16.423  1.00 88.27           C  
ATOM   1110  CD  ARG   141      43.439  21.425  15.983  1.00 90.32           C  
ATOM   1111  NE  ARG   141      44.515  20.972  16.866  1.00 92.61           N  
ATOM   1112  CZ  ARG   141      45.688  21.580  17.032  1.00 93.88           C  
ATOM   1113  NH1 ARG   141      45.969  22.699  16.373  1.00 95.14           N  
ATOM   1114  NH2 ARG   141      46.588  21.054  17.857  1.00 93.25           N  
ATOM   1115  N   GLY   142      41.885  25.290  16.753  1.00 91.38           N  
ATOM   1116  CA  GLY   142      41.936  26.682  16.346  1.00 91.80           C  
ATOM   1117  C   GLY   142      43.212  27.332  16.866  1.00 91.86           C  
ATOM   1118  O   GLY   142      43.961  26.711  17.629  1.00 91.91           O  
ATOM   1119  N   PRO   143      43.475  28.595  16.496  1.00 91.92           N  
ATOM   1120  CA  PRO   143      44.680  29.316  16.926  1.00 91.04           C  
ATOM   1121  C   PRO   143      44.930  29.490  18.429  1.00 90.18           C  
ATOM   1122  O   PRO   143      44.177  30.172  19.126  1.00 89.84           O  
ATOM   1123  CB  PRO   143      44.547  30.656  16.206  1.00 91.64           C  
ATOM   1124  CG  PRO   143      43.056  30.866  16.185  1.00 92.31           C  
ATOM   1125  CD  PRO   143      42.544  29.498  15.788  1.00 91.67           C  
ATOM   1126  N   GLY   144      45.996  28.861  18.917  1.00 89.03           N  
ATOM   1127  CA  GLY   144      46.369  28.993  20.315  1.00 87.46           C  
ATOM   1128  C   GLY   144      45.532  28.326  21.392  1.00 85.90           C  
ATOM   1129  O   GLY   144      45.972  28.235  22.530  1.00 85.97           O  
ATOM   1130  N   TRP   145      44.322  27.892  21.078  1.00 84.14           N  
ATOM   1131  CA  TRP   145      43.525  27.220  22.092  1.00 82.52           C  
ATOM   1132  C   TRP   145      43.294  25.798  21.635  1.00 80.56           C  
ATOM   1133  O   TRP   145      43.558  25.467  20.483  1.00 81.96           O  
ATOM   1134  CB  TRP   145      42.188  27.921  22.320  1.00 83.40           C  
ATOM   1135  CG  TRP   145      41.329  28.067  21.105  1.00 86.17           C  
ATOM   1136  CD1 TRP   145      41.407  29.047  20.155  1.00 86.41           C  
ATOM   1137  CD2 TRP   145      40.204  27.254  20.748  1.00 88.09           C  
ATOM   1138  NE1 TRP   145      40.395  28.901  19.238  1.00 87.17           N  
ATOM   1139  CE2 TRP   145      39.641  27.811  19.575  1.00 87.21           C  
ATOM   1140  CE3 TRP   145      39.615  26.105  21.305  1.00 88.76           C  
ATOM   1141  CZ2 TRP   145      38.517  27.262  18.950  1.00 87.59           C  
ATOM   1142  CZ3 TRP   145      38.490  25.557  20.676  1.00 88.82           C  
ATOM   1143  CH2 TRP   145      37.957  26.140  19.513  1.00 88.14           C  
ATOM   1144  N   ARG   146      42.825  24.949  22.537  1.00 77.09           N  
ATOM   1145  CA  ARG   146      42.575  23.562  22.194  1.00 74.62           C  
ATOM   1146  C   ARG   146      41.838  22.850  23.318  1.00 72.32           C  
ATOM   1147  O   ARG   146      42.250  22.868  24.464  1.00 72.39           O  
ATOM   1148  CB  ARG   146      43.904  22.878  21.828  1.00 75.07           C  
ATOM   1149  CG  ARG   146      44.366  21.686  22.648  1.00 75.81           C  
ATOM   1150  CD  ARG   146      45.612  21.142  21.964  1.00 77.61           C  
ATOM   1151  NE  ARG   146      46.308  20.063  22.664  1.00 80.87           N  
ATOM   1152  CZ  ARG   146      47.153  20.233  23.679  1.00 82.13           C  
ATOM   1153  NH1 ARG   146      47.413  21.449  24.142  1.00 82.86           N  
ATOM   1154  NH2 ARG   146      47.776  19.182  24.205  1.00 82.93           N  
ATOM   1155  N   VAL   147      40.711  22.250  22.975  1.00 70.54           N  
ATOM   1156  CA  VAL   147      39.896  21.549  23.948  1.00 68.67           C  
ATOM   1157  C   VAL   147      40.288  20.081  24.042  1.00 67.90           C  
ATOM   1158  O   VAL   147      40.510  19.431  23.023  1.00 67.92           O  
ATOM   1159  CB  VAL   147      38.405  21.628  23.568  1.00 68.06           C  
ATOM   1160  CG1 VAL   147      37.590  20.726  24.466  1.00 67.90           C  
ATOM   1161  CG2 VAL   147      37.924  23.049  23.674  1.00 66.33           C  
ATOM   1162  N   LEU   148      40.385  19.564  25.266  1.00 66.41           N  
ATOM   1163  CA  LEU   148      40.715  18.157  25.464  1.00 63.56           C  
ATOM   1164  C   LEU   148      39.663  17.514  26.337  1.00 62.01           C  
ATOM   1165  O   LEU   148      39.061  18.161  27.191  1.00 60.42           O  
ATOM   1166  CB  LEU   148      42.079  17.995  26.111  1.00 62.43           C  
ATOM   1167  CG  LEU   148      43.245  18.583  25.330  1.00 63.05           C  
ATOM   1168  CD1 LEU   148      44.543  18.188  25.999  1.00 64.18           C  
ATOM   1169  CD2 LEU   148      43.223  18.070  23.913  1.00 62.67           C  
ATOM   1170  N   GLY   149      39.428  16.234  26.100  1.00 61.64           N  
ATOM   1171  CA  GLY   149      38.447  15.521  26.884  1.00 60.17           C  
ATOM   1172  C   GLY   149      39.090  14.360  27.600  1.00 60.50           C  
ATOM   1173  O   GLY   149      39.861  13.596  27.007  1.00 60.87           O  
ATOM   1174  N   GLY   150      38.782  14.245  28.888  1.00 59.65           N  
ATOM   1175  CA  GLY   150      39.302  13.161  29.702  1.00 57.19           C  
ATOM   1176  C   GLY   150      38.365  12.972  30.881  1.00 56.01           C  
ATOM   1177  O   GLY   150      37.140  12.950  30.697  1.00 54.74           O  
ATOM   1178  N   ALA   151      38.928  12.848  32.086  1.00 53.87           N  
ATOM   1179  CA  ALA   151      38.128  12.676  33.295  1.00 52.26           C  
ATOM   1180  C   ALA   151      38.894  13.034  34.565  1.00 51.67           C  
ATOM   1181  O   ALA   151      40.091  12.764  34.670  1.00 49.71           O  
ATOM   1182  CB  ALA   151      37.633  11.231  33.393  1.00 50.92           C  
ATOM   1183  N   VAL   152      38.213  13.660  35.521  1.00 51.42           N  
ATOM   1184  CA  VAL   152      38.858  13.962  36.797  1.00 52.53           C  
ATOM   1185  C   VAL   152      38.692  12.631  37.517  1.00 52.46           C  
ATOM   1186  O   VAL   152      37.633  12.014  37.446  1.00 53.17           O  
ATOM   1187  CB  VAL   152      38.157  15.115  37.561  1.00 52.93           C  
ATOM   1188  CG1 VAL   152      38.479  16.431  36.899  1.00 53.90           C  
ATOM   1189  CG2 VAL   152      36.666  14.941  37.533  1.00 54.66           C  
ATOM   1190  N   LEU   153      39.746  12.170  38.173  1.00 51.56           N  
ATOM   1191  CA  LEU   153      39.712  10.876  38.824  1.00 50.97           C  
ATOM   1192  C   LEU   153      40.001  10.939  40.304  1.00 53.35           C  
ATOM   1193  O   LEU   153      40.428  11.971  40.836  1.00 54.32           O  
ATOM   1194  CB  LEU   153      40.769   9.964  38.211  1.00 49.44           C  
ATOM   1195  CG  LEU   153      40.998   9.830  36.703  1.00 48.15           C  
ATOM   1196  CD1 LEU   153      42.318   9.086  36.495  1.00 47.23           C  
ATOM   1197  CD2 LEU   153      39.854   9.103  36.040  1.00 43.93           C  
ATOM   1198  N   ASP   154      39.778   9.812  40.971  1.00 53.61           N  
ATOM   1199  CA  ASP   154      40.093   9.718  42.380  1.00 53.31           C  
ATOM   1200  C   ASP   154      40.356   8.268  42.720  1.00 52.51           C  
ATOM   1201  O   ASP   154      39.785   7.369  42.110  1.00 51.87           O  
ATOM   1202  CB  ASP   154      38.972  10.285  43.243  1.00 55.47           C  
ATOM   1203  CG  ASP   154      39.475  10.759  44.603  1.00 56.67           C  
ATOM   1204  OD1 ASP   154      40.692  10.605  44.873  1.00 57.83           O  
ATOM   1205  OD2 ASP   154      38.663  11.285  45.392  1.00 56.10           O  
ATOM   1206  N   LEU   155      41.244   8.056  43.685  1.00 52.57           N  
ATOM   1207  CA  LEU   155      41.630   6.720  44.124  1.00 53.42           C  
ATOM   1208  C   LEU   155      41.853   6.732  45.624  1.00 54.92           C  
ATOM   1209  O   LEU   155      42.752   7.407  46.127  1.00 54.74           O  
ATOM   1210  CB  LEU   155      42.924   6.262  43.422  1.00 50.84           C  
ATOM   1211  CG  LEU   155      43.420   4.864  43.802  1.00 49.30           C  
ATOM   1212  CD1 LEU   155      42.417   3.820  43.326  1.00 49.80           C  
ATOM   1213  CD2 LEU   155      44.763   4.594  43.167  1.00 50.73           C  
ATOM   1214  N   TRP   156      41.027   5.974  46.334  1.00 57.64           N  
ATOM   1215  CA  TRP   156      41.112   5.880  47.790  1.00 59.74           C  
ATOM   1216  C   TRP   156      40.881   4.461  48.283  1.00 60.15           C  
ATOM   1217  O   TRP   156      40.627   3.544  47.497  1.00 59.26           O  
ATOM   1218  CB  TRP   156      40.082   6.811  48.433  1.00 60.32           C  
ATOM   1219  CG  TRP   156      38.930   7.049  47.558  1.00 63.67           C  
ATOM   1220  CD1 TRP   156      38.922   7.740  46.375  1.00 66.54           C  
ATOM   1221  CD2 TRP   156      37.614   6.535  47.731  1.00 65.16           C  
ATOM   1222  NE1 TRP   156      37.676   7.679  45.794  1.00 67.32           N  
ATOM   1223  CE2 TRP   156      36.854   6.944  46.607  1.00 67.03           C  
ATOM   1224  CE3 TRP   156      37.004   5.767  48.719  1.00 64.21           C  
ATOM   1225  CZ2 TRP   156      35.516   6.607  46.452  1.00 67.24           C  
ATOM   1226  CZ3 TRP   156      35.688   5.436  48.568  1.00 66.86           C  
ATOM   1227  CH2 TRP   156      34.950   5.855  47.437  1.00 68.51           C  
ATOM   1228  N   VAL   157      40.981   4.293  49.597  1.00 61.19           N  
ATOM   1229  CA  VAL   157      40.770   3.000  50.236  1.00 62.27           C  
ATOM   1230  C   VAL   157      39.403   2.961  50.958  1.00 62.56           C  
ATOM   1231  O   VAL   157      38.846   3.998  51.318  1.00 62.00           O  
ATOM   1232  CB  VAL   157      41.919   2.723  51.219  1.00 62.30           C  
ATOM   1233  CG1 VAL   157      41.728   1.388  51.909  1.00 64.43           C  
ATOM   1234  CG2 VAL   157      43.237   2.727  50.465  1.00 62.97           C  
ATOM   1235  N   SER   158      38.845   1.767  51.135  1.00 64.49           N  
ATOM   1236  CA  SER   158      37.560   1.625  51.831  1.00 67.24           C  
ATOM   1237  C   SER   158      37.751   1.081  53.262  1.00 68.87           C  
ATOM   1238  O   SER   158      38.877   0.755  53.675  1.00 67.12           O  
ATOM   1239  CB  SER   158      36.631   0.699  51.042  1.00 66.15           C  
ATOM   1240  OG  SER   158      37.240  -0.564  50.826  1.00 66.46           O  
ATOM   1241  N   ASP   159      36.654   1.003  54.021  1.00 71.30           N  
ATOM   1242  CA  ASP   159      36.709   0.479  55.396  1.00 73.47           C  
ATOM   1243  C   ASP   159      36.947  -1.027  55.344  1.00 72.53           C  
ATOM   1244  O   ASP   159      37.199  -1.660  56.365  1.00 72.71           O  
ATOM   1245  CB  ASP   159      35.409   0.762  56.154  1.00 75.20           C  
ATOM   1246  CG  ASP   159      34.196   0.151  55.480  1.00 78.36           C  
ATOM   1247  OD1 ASP   159      34.355  -0.832  54.717  1.00 79.99           O  
ATOM   1248  OD2 ASP   159      33.077   0.646  55.723  1.00 79.78           O  
ATOM   1249  N   SER   160      36.855  -1.572  54.134  1.00 71.61           N  
ATOM   1250  CA  SER   160      37.073  -2.983  53.856  1.00 72.21           C  
ATOM   1251  C   SER   160      38.554  -3.179  53.541  1.00 72.10           C  
ATOM   1252  O   SER   160      39.067  -4.295  53.606  1.00 72.06           O  
ATOM   1253  CB  SER   160      36.235  -3.423  52.643  1.00 74.47           C  
ATOM   1254  OG  SER   160      34.848  -3.133  52.811  1.00 75.86           O  
ATOM   1255  N   GLY   161      39.231  -2.092  53.162  1.00 71.78           N  
ATOM   1256  CA  GLY   161      40.656  -2.168  52.869  1.00 69.97           C  
ATOM   1257  C   GLY   161      41.140  -2.440  51.454  1.00 68.35           C  
ATOM   1258  O   GLY   161      42.212  -3.023  51.264  1.00 67.64           O  
ATOM   1259  N   ALA   162      40.368  -2.026  50.456  1.00 67.82           N  
ATOM   1260  CA  ALA   162      40.768  -2.219  49.060  1.00 66.31           C  
ATOM   1261  C   ALA   162      40.673  -0.886  48.323  1.00 64.90           C  
ATOM   1262  O   ALA   162      39.918   0.005  48.734  1.00 64.15           O  
ATOM   1263  CB  ALA   162      39.865  -3.249  48.383  1.00 65.17           C  
ATOM   1264  N   PHE   163      41.429  -0.753  47.235  1.00 61.59           N  
ATOM   1265  CA  PHE   163      41.395   0.472  46.449  1.00 58.00           C  
ATOM   1266  C   PHE   163      40.062   0.678  45.768  1.00 57.52           C  
ATOM   1267  O   PHE   163      39.458  -0.259  45.278  1.00 59.00           O  
ATOM   1268  CB  PHE   163      42.460   0.447  45.377  1.00 54.06           C  
ATOM   1269  CG  PHE   163      43.837   0.594  45.902  1.00 50.52           C  
ATOM   1270  CD1 PHE   163      44.718  -0.477  45.875  1.00 49.21           C  
ATOM   1271  CD2 PHE   163      44.269   1.815  46.392  1.00 48.02           C  
ATOM   1272  CE1 PHE   163      46.015  -0.330  46.326  1.00 49.90           C  
ATOM   1273  CE2 PHE   163      45.562   1.973  46.844  1.00 48.71           C  
ATOM   1274  CZ  PHE   163      46.443   0.902  46.813  1.00 49.07           C  
ATOM   1275  N   LEU   164      39.614   1.920  45.728  1.00 57.55           N  
ATOM   1276  CA  LEU   164      38.365   2.263  45.075  1.00 57.26           C  
ATOM   1277  C   LEU   164      38.730   3.412  44.124  1.00 57.53           C  
ATOM   1278  O   LEU   164      39.370   4.387  44.533  1.00 56.25           O  
ATOM   1279  CB  LEU   164      37.349   2.697  46.131  1.00 57.98           C  
ATOM   1280  CG  LEU   164      35.912   2.189  45.989  1.00 59.74           C  
ATOM   1281  CD1 LEU   164      35.844   0.674  46.042  1.00 59.30           C  
ATOM   1282  CD2 LEU   164      35.095   2.751  47.116  1.00 62.37           C  
ATOM   1283  N   LEU   165      38.351   3.285  42.854  1.00 57.37           N  
ATOM   1284  CA  LEU   165      38.675   4.297  41.850  1.00 55.98           C  
ATOM   1285  C   LEU   165      37.434   5.036  41.363  1.00 55.73           C  
ATOM   1286  O   LEU   165      36.470   4.404  40.963  1.00 56.30           O  
ATOM   1287  CB  LEU   165      39.378   3.626  40.653  1.00 54.80           C  
ATOM   1288  CG  LEU   165      39.518   4.427  39.344  1.00 52.01           C  
ATOM   1289  CD1 LEU   165      40.715   5.304  39.447  1.00 50.99           C  
ATOM   1290  CD2 LEU   165      39.648   3.522  38.158  1.00 48.67           C  
ATOM   1291  N   GLU   166      37.469   6.369  41.388  1.00 56.74           N  
ATOM   1292  CA  GLU   166      36.346   7.198  40.921  1.00 58.45           C  
ATOM   1293  C   GLU   166      36.673   7.782  39.546  1.00 57.73           C  
ATOM   1294  O   GLU   166      37.808   8.165  39.281  1.00 57.50           O  
ATOM   1295  CB  GLU   166      36.070   8.357  41.899  1.00 61.94           C  
ATOM   1296  CG  GLU   166      34.696   9.057  41.715  1.00 66.38           C  
ATOM   1297  CD  GLU   166      34.790  10.579  41.505  1.00 70.05           C  
ATOM   1298  OE1 GLU   166      33.887  11.304  41.984  1.00 71.91           O  
ATOM   1299  OE2 GLU   166      35.747  11.063  40.848  1.00 72.07           O  
ATOM   1300  N   VAL   167      35.673   7.868  38.680  1.00 57.94           N  
ATOM   1301  CA  VAL   167      35.885   8.387  37.335  1.00 58.56           C  
ATOM   1302  C   VAL   167      34.695   9.207  36.828  1.00 60.05           C  
ATOM   1303  O   VAL   167      33.565   8.727  36.847  1.00 60.55           O  
ATOM   1304  CB  VAL   167      36.104   7.236  36.323  1.00 57.58           C  
ATOM   1305  CG1 VAL   167      36.498   7.800  34.973  1.00 57.01           C  
ATOM   1306  CG2 VAL   167      37.151   6.277  36.838  1.00 58.12           C  
ATOM   1307  N   ASP   168      34.953  10.435  36.377  1.00 59.99           N  
ATOM   1308  CA  ASP   168      33.906  11.282  35.832  1.00 60.21           C  
ATOM   1309  C   ASP   168      34.446  12.147  34.689  1.00 62.04           C  
ATOM   1310  O   ASP   168      35.305  13.009  34.887  1.00 62.04           O  
ATOM   1311  CB  ASP   168      33.289  12.169  36.918  1.00 60.99           C  
ATOM   1312  CG  ASP   168      31.954  12.776  36.487  1.00 61.77           C  
ATOM   1313  OD1 ASP   168      31.289  12.180  35.623  1.00 61.73           O  
ATOM   1314  OD2 ASP   168      31.555  13.836  37.012  1.00 64.32           O  
ATOM   1315  N   PRO   169      33.954  11.906  33.465  1.00 62.54           N  
ATOM   1316  CA  PRO   169      34.358  12.640  32.267  1.00 62.04           C  
ATOM   1317  C   PRO   169      34.256  14.144  32.449  1.00 62.31           C  
ATOM   1318  O   PRO   169      33.307  14.649  33.057  1.00 60.82           O  
ATOM   1319  CB  PRO   169      33.379  12.142  31.215  1.00 62.41           C  
ATOM   1320  CG  PRO   169      33.167  10.738  31.618  1.00 63.31           C  
ATOM   1321  CD  PRO   169      32.999  10.839  33.120  1.00 62.76           C  
ATOM   1322  N   ALA   170      35.250  14.837  31.903  1.00 62.45           N  
ATOM   1323  CA  ALA   170      35.341  16.285  31.947  1.00 63.07           C  
ATOM   1324  C   ALA   170      36.097  16.741  30.689  1.00 64.66           C  
ATOM   1325  O   ALA   170      36.689  15.924  29.973  1.00 64.85           O  
ATOM   1326  CB  ALA   170      36.084  16.710  33.195  1.00 60.17           C  
ATOM   1327  N   TYR   171      36.066  18.034  30.403  1.00 64.63           N  
ATOM   1328  CA  TYR   171      36.787  18.537  29.245  1.00 66.52           C  
ATOM   1329  C   TYR   171      37.591  19.713  29.740  1.00 67.32           C  
ATOM   1330  O   TYR   171      37.192  20.375  30.693  1.00 69.33           O  
ATOM   1331  CB  TYR   171      35.827  19.018  28.160  1.00 66.79           C  
ATOM   1332  CG  TYR   171      34.923  20.122  28.638  1.00 68.70           C  
ATOM   1333  CD1 TYR   171      33.812  19.838  29.431  1.00 70.55           C  
ATOM   1334  CD2 TYR   171      35.204  21.458  28.354  1.00 68.74           C  
ATOM   1335  CE1 TYR   171      33.002  20.857  29.935  1.00 70.62           C  
ATOM   1336  CE2 TYR   171      34.399  22.489  28.854  1.00 69.66           C  
ATOM   1337  CZ  TYR   171      33.303  22.179  29.645  1.00 69.77           C  
ATOM   1338  OH  TYR   171      32.513  23.173  30.169  1.00 67.58           O  
ATOM   1339  N   ARG   172      38.723  19.979  29.108  1.00 66.90           N  
ATOM   1340  CA  ARG   172      39.522  21.109  29.521  1.00 66.95           C  
ATOM   1341  C   ARG   172      39.938  21.934  28.310  1.00 66.95           C  
ATOM   1342  O   ARG   172      40.433  21.392  27.316  1.00 66.90           O  
ATOM   1343  CB  ARG   172      40.772  20.645  30.268  1.00 67.46           C  
ATOM   1344  CG  ARG   172      41.364  21.719  31.162  1.00 70.04           C  
ATOM   1345  CD  ARG   172      40.433  21.940  32.339  1.00 74.46           C  
ATOM   1346  NE  ARG   172      40.334  23.324  32.784  1.00 76.61           N  
ATOM   1347  CZ  ARG   172      39.466  23.734  33.706  1.00 79.04           C  
ATOM   1348  NH1 ARG   172      38.638  22.855  34.273  1.00 77.36           N  
ATOM   1349  NH2 ARG   172      39.403  25.023  34.046  1.00 79.54           N  
ATOM   1350  N   ILE   173      39.723  23.243  28.390  1.00 65.29           N  
ATOM   1351  CA  ILE   173      40.124  24.129  27.312  1.00 63.66           C  
ATOM   1352  C   ILE   173      41.474  24.704  27.680  1.00 62.98           C  
ATOM   1353  O   ILE   173      41.576  25.455  28.637  1.00 62.68           O  
ATOM   1354  CB  ILE   173      39.162  25.310  27.140  1.00 62.85           C  
ATOM   1355  CG1 ILE   173      37.725  24.814  27.040  1.00 61.85           C  
ATOM   1356  CG2 ILE   173      39.515  26.064  25.875  1.00 62.71           C  
ATOM   1357  CD1 ILE   173      36.719  25.914  26.921  1.00 62.07           C  
ATOM   1358  N   LEU   174      42.508  24.347  26.936  1.00 63.11           N  
ATOM   1359  CA  LEU   174      43.834  24.875  27.208  1.00 65.88           C  
ATOM   1360  C   LEU   174      44.241  26.025  26.270  1.00 67.64           C  
ATOM   1361  O   LEU   174      43.879  26.044  25.098  1.00 67.57           O  
ATOM   1362  CB  LEU   174      44.884  23.771  27.089  1.00 66.60           C  
ATOM   1363  CG  LEU   174      44.896  22.548  28.011  1.00 68.44           C  
ATOM   1364  CD1 LEU   174      46.192  21.798  27.738  1.00 67.09           C  
ATOM   1365  CD2 LEU   174      44.821  22.931  29.487  1.00 67.41           C  
ATOM   1366  N   CYS   175      45.002  26.984  26.786  1.00 69.71           N  
ATOM   1367  CA  CYS   175      45.479  28.083  25.957  1.00 71.26           C  
ATOM   1368  C   CYS   175      46.927  27.756  25.633  1.00 72.34           C  
ATOM   1369  O   CYS   175      47.711  27.487  26.534  1.00 72.52           O  
ATOM   1370  CB  CYS   175      45.416  29.397  26.713  1.00 71.46           C  
ATOM   1371  SG  CYS   175      45.466  30.815  25.626  1.00 75.01           S  
ATOM   1372  N   GLU   176      47.282  27.779  24.354  1.00 74.58           N  
ATOM   1373  CA  GLU   176      48.641  27.449  23.915  1.00 76.40           C  
ATOM   1374  C   GLU   176      49.640  28.604  23.900  1.00 75.71           C  
ATOM   1375  O   GLU   176      50.763  28.438  23.428  1.00 75.54           O  
ATOM   1376  CB  GLU   176      48.603  26.806  22.517  1.00 79.08           C  
ATOM   1377  CG  GLU   176      48.006  25.390  22.486  1.00 84.44           C  
ATOM   1378  CD  GLU   176      48.012  24.747  21.089  1.00 87.05           C  
ATOM   1379  OE1 GLU   176      47.703  23.537  21.000  1.00 87.91           O  
ATOM   1380  OE2 GLU   176      48.314  25.441  20.086  1.00 87.82           O  
END
