
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  101 ( 1548),  selected  101 , name 1fj7_A
# Molecule2: number of CA atoms   71 (  558),  selected   71 , name T0487_26_96.pdb
# PARAMETERS: 1fj7_A.T0487_26_96.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    H     3_A      -       -           -
LGA    M     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    E     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    P     8_A      -       -           -
LGA    V     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    G    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    E    13_A      -       -           -
LGA    S    14_A      -       -           -
LGA    T    15_A      -       -           -
LGA    T    16_A      -       -           -
LGA    P    17_A      P      26          2.207
LGA    F    18_A      W      27          1.544
LGA    N    19_A      R      28          1.271
LGA    L    20_A      L      29          1.803
LGA    F    21_A      E      30          1.142
LGA    I    22_A      V      31          1.435
LGA    G    23_A      V      32          1.170
LGA    N    24_A      L      33          2.007
LGA    L    25_A      D      34          4.800
LGA    N    26_A      P      35          4.361
LGA    P    27_A      P      36          2.573
LGA    N    28_A      P      37          2.956
LGA    K    29_A      G      38          4.049
LGA    -       -      R      39           -
LGA    -       -      E      40           -
LGA    S    30_A      E      41          0.505
LGA    V    31_A      V      42          0.248
LGA    A    32_A      Y      43          1.090
LGA    E    33_A      P      44          1.537
LGA    L    34_A      L      45          1.024
LGA    K    35_A      L      46          1.221
LGA    V    36_A      A      47          2.017
LGA    A    37_A      Q      48          1.367
LGA    I    38_A      V      49          1.260
LGA    S    39_A      A      50          3.027
LGA    E    40_A      R      51          3.304
LGA    L    41_A      R      52          2.190
LGA    F    42_A      A      53          4.041
LGA    A    43_A      G      54          5.357
LGA    K    44_A      -       -           -
LGA    N    45_A      -       -           -
LGA    D    46_A      -       -           -
LGA    L    47_A      G      55          1.472
LGA    A    48_A      V      56          1.320
LGA    V    49_A      T      57          1.125
LGA    V    50_A      V      58          3.115
LGA    D    51_A      R      59          3.325
LGA    V    52_A      -       -           -
LGA    R    53_A      M      60          3.507
LGA    T    54_A      G      61          4.780
LGA    G    55_A      -       -           -
LGA    T    56_A      -       -           -
LGA    N    57_A      -       -           -
LGA    R    58_A      -       -           -
LGA    K    59_A      -       -           -
LGA    F    60_A      -       -           -
LGA    G    61_A      D      62          3.419
LGA    Y    62_A      G      63          1.311
LGA    V    63_A      L      64          0.569
LGA    D    64_A      A      65          0.917
LGA    F    65_A      S      66          0.783
LGA    E    66_A      W      67          1.109
LGA    S    67_A      S      68          2.084
LGA    A    68_A      P      69          1.274
LGA    E    69_A      -       -           -
LGA    D    70_A      -       -           -
LGA    L    71_A      P      70          1.482
LGA    E    72_A      E      71          1.137
LGA    K    73_A      V      72          2.254
LGA    A    74_A      L      73          1.846
LGA    L    75_A      -       -           -
LGA    E    76_A      -       -           -
LGA    L    77_A      V      74          1.378
LGA    T    78_A      L      75          3.284
LGA    G    79_A      E      76          3.448
LGA    L    80_A      G      77          0.930
LGA    K    81_A      T      78          1.168
LGA    V    82_A      L      79          2.816
LGA    F    83_A      A      80          3.372
LGA    -       -      R      81           -
LGA    -       -      M      82           -
LGA    -       -      G      83           -
LGA    -       -      Q      84           -
LGA    G    84_A      T      85          2.882
LGA    N    85_A      Y      86          2.522
LGA    E    86_A      A      87          2.432
LGA    I    87_A      Y      88          1.146
LGA    K    88_A      R      89          1.248
LGA    L    89_A      L      90          1.853
LGA    E    90_A      Y      91          1.949
LGA    K    91_A      P      92          3.976
LGA    P    92_A      K      93          3.682
LGA    K    93_A      -       -           -
LGA    G    94_A      -       -           -
LGA    R    95_A      G      94          3.182
LGA    D    96_A      R      95           #
LGA    G    97_A      R      96           #
LGA    T    98_A      -       -           -
LGA    R    99_A      -       -           -
LGA    G   100_A      -       -           -
LGA    C   101_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  101   71    5.0     63    2.49    14.29     60.436     2.433

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.924357 * X  +  -0.179077 * Y  +  -0.336891 * Z  + -15.106180
  Y_new =  -0.010009 * X  +  -0.894080 * Y  +   0.447795 * Z  +  13.879963
  Z_new =  -0.381397 * X  +  -0.410551 * Y  +  -0.828242 * Z  +  86.994125 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.681400    0.460193  [ DEG:  -153.6329     26.3671 ]
  Theta =   0.391307    2.750285  [ DEG:    22.4203    157.5797 ]
  Phi   =  -0.010827    3.130765  [ DEG:    -0.6204    179.3796 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1fj7_A                                        
REMARK     2: T0487_26_96.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1fj7_A.T0487_26_96.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  101   71   5.0   63   2.49   14.29  60.436
REMARK  ---------------------------------------------------------- 
MOLECULE 1fj7_A
HEADER    STRUCTURAL PROTEIN                      07-AUG-00   1FJ7              
TITLE     SOLUTION STRUCTURE OF NUCLEOLIN RBD1                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NUCLEOLIN RBD1;                                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: PROTEIN C23;                                                
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MESOCRICETUS AURATUS;                           
SOURCE   3 ORGANISM_COMMON: GOLDEN HAMSTER;                                     
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: BL21(DE3)PLYSS                            
KEYWDS    RNP, RBD, RRM, RNA BINDING DOMAIN, NUCLEOLUS                          
EXPDTA    NMR, 34 STRUCTURES                                                    
AUTHOR    F.H.-T.ALLAIN,D.E.GILBERT,P.BOUVET,J.FEIGON                           
REVDAT   2   01-APR-03 1FJ7    1       JRNL                                     
REVDAT   1   16-OCT-00 1FJ7    0                                                
JRNL        AUTH   F.H.ALLAIN,D.E.GILBERT,P.BOUVET,J.FEIGON                     
JRNL        TITL   SOLUTION STRUCTURE OF THE TWO N-TERMINAL                     
JRNL        TITL 2 RNA-BINDING DOMAINS OF NUCLEOLIN AND NMR STUDY OF            
JRNL        TITL 3 THE INTERACTION WITH ITS RNA TARGET.                         
JRNL        REF    J.MOL.BIOL.                   V. 303   227 2000              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1FJ7 A    1   101  UNP    P08199   NUCL_MESAU     291    391             
SEQRES   1 A  101  GLY SER HIS MET LEU GLU ASP PRO VAL GLU GLY SER GLU          
SEQRES   2 A  101  SER THR THR PRO PHE ASN LEU PHE ILE GLY ASN LEU ASN          
SEQRES   3 A  101  PRO ASN LYS SER VAL ALA GLU LEU LYS VAL ALA ILE SER          
SEQRES   4 A  101  GLU LEU PHE ALA LYS ASN ASP LEU ALA VAL VAL ASP VAL          
SEQRES   5 A  101  ARG THR GLY THR ASN ARG LYS PHE GLY TYR VAL ASP PHE          
SEQRES   6 A  101  GLU SER ALA GLU ASP LEU GLU LYS ALA LEU GLU LEU THR          
SEQRES   7 A  101  GLY LEU LYS VAL PHE GLY ASN GLU ILE LYS LEU GLU LYS          
SEQRES   8 A  101  PRO LYS GLY ARG ASP GLY THR ARG GLY CYS                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      37.860  19.452  53.864  1.00  0.00           N  
ATOM      2  CA  GLY A   1      38.742  20.100  54.877  1.00  0.00           C  
ATOM      3  C   GLY A   1      39.531  19.026  55.628  1.00  0.00           C  
ATOM      4  O   GLY A   1      40.682  18.768  55.335  1.00  0.00           O  
ATOM      5  H2  GLY A   1      37.480  20.177  53.222  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      39.427  20.771  54.380  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      38.137  20.654  55.578  1.00  0.00           H  
ATOM      8  H1  GLY A   1      38.411  18.759  53.318  1.00  0.00           H  
ATOM      9  H3  GLY A   1      37.077  18.966  54.345  1.00  0.00           H  
ATOM     10  N   SER A   2      38.923  18.398  56.598  1.00  0.00           N  
ATOM     11  CA  SER A   2      39.640  17.341  57.367  1.00  0.00           C  
ATOM     12  C   SER A   2      38.668  16.229  57.768  1.00  0.00           C  
ATOM     13  O   SER A   2      38.400  16.015  58.933  1.00  0.00           O  
ATOM     14  CB  SER A   2      40.181  18.053  58.606  1.00  0.00           C  
ATOM     15  OG  SER A   2      39.126  18.772  59.233  1.00  0.00           O  
ATOM     16  H   SER A   2      37.994  18.620  56.819  1.00  0.00           H  
ATOM     17  HA  SER A   2      40.455  16.940  56.787  1.00  0.00           H  
ATOM     18  HB2 SER A   2      40.575  17.327  59.297  1.00  0.00           H  
ATOM     19  HB3 SER A   2      40.970  18.733  58.313  1.00  0.00           H  
ATOM     20  HG  SER A   2      38.316  18.271  59.115  1.00  0.00           H  
ATOM     21  N   HIS A   3      38.139  15.517  56.810  1.00  0.00           N  
ATOM     22  CA  HIS A   3      37.184  14.420  57.137  1.00  0.00           C  
ATOM     23  C   HIS A   3      37.823  13.059  56.843  1.00  0.00           C  
ATOM     24  O   HIS A   3      37.536  12.432  55.842  1.00  0.00           O  
ATOM     25  CB  HIS A   3      35.981  14.656  56.225  1.00  0.00           C  
ATOM     26  CG  HIS A   3      34.787  15.035  57.057  1.00  0.00           C  
ATOM     27  ND1 HIS A   3      34.813  16.098  57.947  1.00  0.00           N  
ATOM     28  CD2 HIS A   3      33.525  14.503  57.147  1.00  0.00           C  
ATOM     29  CE1 HIS A   3      33.602  16.171  58.527  1.00  0.00           C  
ATOM     30  NE2 HIS A   3      32.778  15.221  58.076  1.00  0.00           N  
ATOM     31  H   HIS A   3      38.367  15.706  55.877  1.00  0.00           H  
ATOM     32  HA  HIS A   3      36.881  14.478  58.170  1.00  0.00           H  
ATOM     33  HB2 HIS A   3      36.206  15.454  55.533  1.00  0.00           H  
ATOM     34  HB3 HIS A   3      35.762  13.753  55.675  1.00  0.00           H  
ATOM     35  HD1 HIS A   3      35.575  16.690  58.121  1.00  0.00           H  
ATOM     36  HD2 HIS A   3      33.166  13.655  56.583  1.00  0.00           H  
ATOM     37  HE1 HIS A   3      33.328  16.908  59.269  1.00  0.00           H  
ATOM     38  N   MET A   4      38.686  12.599  57.707  1.00  0.00           N  
ATOM     39  CA  MET A   4      39.341  11.280  57.476  1.00  0.00           C  
ATOM     40  C   MET A   4      38.312  10.257  56.988  1.00  0.00           C  
ATOM     41  O   MET A   4      38.513   9.582  55.998  1.00  0.00           O  
ATOM     42  CB  MET A   4      39.899  10.871  58.839  1.00  0.00           C  
ATOM     43  CG  MET A   4      41.004   9.830  58.647  1.00  0.00           C  
ATOM     44  SD  MET A   4      42.618  10.613  58.881  1.00  0.00           S  
ATOM     45  CE  MET A   4      42.879  10.087  60.592  1.00  0.00           C  
ATOM     46  H   MET A   4      38.903  13.121  58.508  1.00  0.00           H  
ATOM     47  HA  MET A   4      40.144  11.377  56.763  1.00  0.00           H  
ATOM     48  HB2 MET A   4      40.305  11.740  59.337  1.00  0.00           H  
ATOM     49  HB3 MET A   4      39.109  10.447  59.440  1.00  0.00           H  
ATOM     50  HG2 MET A   4      40.880   9.037  59.369  1.00  0.00           H  
ATOM     51  HG3 MET A   4      40.943   9.421  57.649  1.00  0.00           H  
ATOM     52  HE1 MET A   4      42.006   9.552  60.941  1.00  0.00           H  
ATOM     53  HE2 MET A   4      43.042  10.951  61.215  1.00  0.00           H  
ATOM     54  HE3 MET A   4      43.746   9.441  60.641  1.00  0.00           H  
ATOM     55  N   LEU A   5      37.210  10.136  57.677  1.00  0.00           N  
ATOM     56  CA  LEU A   5      36.169   9.157  57.253  1.00  0.00           C  
ATOM     57  C   LEU A   5      36.733   7.733  57.293  1.00  0.00           C  
ATOM     58  O   LEU A   5      36.594   6.974  56.356  1.00  0.00           O  
ATOM     59  CB  LEU A   5      35.814   9.553  55.819  1.00  0.00           C  
ATOM     60  CG  LEU A   5      34.321   9.870  55.731  1.00  0.00           C  
ATOM     61  CD1 LEU A   5      33.512   8.656  56.191  1.00  0.00           C  
ATOM     62  CD2 LEU A   5      34.001  11.066  56.632  1.00  0.00           C  
ATOM     63  H   LEU A   5      37.067  10.689  58.473  1.00  0.00           H  
ATOM     64  HA  LEU A   5      35.297   9.236  57.883  1.00  0.00           H  
ATOM     65  HB2 LEU A   5      36.386  10.424  55.535  1.00  0.00           H  
ATOM     66  HB3 LEU A   5      36.046   8.736  55.152  1.00  0.00           H  
ATOM     67  HG  LEU A   5      34.063  10.108  54.709  1.00  0.00           H  
ATOM     68 HD11 LEU A   5      32.838   8.952  56.983  1.00  0.00           H  
ATOM     69 HD12 LEU A   5      34.184   7.893  56.557  1.00  0.00           H  
ATOM     70 HD13 LEU A   5      32.943   8.267  55.361  1.00  0.00           H  
ATOM     71 HD21 LEU A   5      33.822  11.938  56.022  1.00  0.00           H  
ATOM     72 HD22 LEU A   5      34.835  11.253  57.291  1.00  0.00           H  
ATOM     73 HD23 LEU A   5      33.120  10.849  57.218  1.00  0.00           H  
ATOM     74  N   GLU A   6      37.369   7.369  58.372  1.00  0.00           N  
ATOM     75  CA  GLU A   6      37.942   5.995  58.471  1.00  0.00           C  
ATOM     76  C   GLU A   6      36.922   5.041  59.100  1.00  0.00           C  
ATOM     77  O   GLU A   6      36.061   5.447  59.854  1.00  0.00           O  
ATOM     78  CB  GLU A   6      39.166   6.142  59.374  1.00  0.00           C  
ATOM     79  CG  GLU A   6      38.735   6.688  60.737  1.00  0.00           C  
ATOM     80  CD  GLU A   6      39.533   5.993  61.842  1.00  0.00           C  
ATOM     81  OE1 GLU A   6      40.255   5.062  61.528  1.00  0.00           O  
ATOM     82  OE2 GLU A   6      39.408   6.405  62.984  1.00  0.00           O  
ATOM     83  H   GLU A   6      37.470   7.997  59.117  1.00  0.00           H  
ATOM     84  HA  GLU A   6      38.241   5.641  57.498  1.00  0.00           H  
ATOM     85  HB2 GLU A   6      39.635   5.177  59.505  1.00  0.00           H  
ATOM     86  HB3 GLU A   6      39.869   6.825  58.922  1.00  0.00           H  
ATOM     87  HG2 GLU A   6      38.919   7.752  60.773  1.00  0.00           H  
ATOM     88  HG3 GLU A   6      37.682   6.499  60.883  1.00  0.00           H  
ATOM     89  N   ASP A   7      37.014   3.775  58.795  1.00  0.00           N  
ATOM     90  CA  ASP A   7      36.051   2.797  59.375  1.00  0.00           C  
ATOM     91  C   ASP A   7      36.473   2.419  60.797  1.00  0.00           C  
ATOM     92  O   ASP A   7      37.637   2.487  61.139  1.00  0.00           O  
ATOM     93  CB  ASP A   7      36.120   1.579  58.453  1.00  0.00           C  
ATOM     94  CG  ASP A   7      35.015   1.673  57.399  1.00  0.00           C  
ATOM     95  OD1 ASP A   7      34.416   2.730  57.290  1.00  0.00           O  
ATOM     96  OD2 ASP A   7      34.787   0.686  56.721  1.00  0.00           O  
ATOM     97  H   ASP A   7      37.717   3.469  58.184  1.00  0.00           H  
ATOM     98  HA  ASP A   7      35.053   3.205  59.374  1.00  0.00           H  
ATOM     99  HB2 ASP A   7      37.083   1.552  57.965  1.00  0.00           H  
ATOM    100  HB3 ASP A   7      35.986   0.679  59.034  1.00  0.00           H  
ATOM    101  N   PRO A   8      35.505   2.031  61.580  1.00  0.00           N  
ATOM    102  CA  PRO A   8      35.769   1.635  62.982  1.00  0.00           C  
ATOM    103  C   PRO A   8      36.486   0.290  63.027  1.00  0.00           C  
ATOM    104  O   PRO A   8      35.893  -0.744  63.265  1.00  0.00           O  
ATOM    105  CB  PRO A   8      34.386   1.534  63.598  1.00  0.00           C  
ATOM    106  CG  PRO A   8      33.467   1.274  62.447  1.00  0.00           C  
ATOM    107  CD  PRO A   8      34.086   1.924  61.236  1.00  0.00           C  
ATOM    108  HA  PRO A   8      36.346   2.391  63.489  1.00  0.00           H  
ATOM    109  HB2 PRO A   8      34.353   0.716  64.305  1.00  0.00           H  
ATOM    110  HB3 PRO A   8      34.128   2.461  64.078  1.00  0.00           H  
ATOM    111  HG2 PRO A   8      33.368   0.210  62.288  1.00  0.00           H  
ATOM    112  HG3 PRO A   8      32.499   1.712  62.639  1.00  0.00           H  
ATOM    113  HD3 PRO A   8      33.949   1.304  60.361  1.00  0.00           H  
ATOM    114  HD2 PRO A   8      33.672   2.905  61.079  1.00  0.00           H  
ATOM    115  N   VAL A   9      37.758   0.310  62.798  1.00  0.00           N  
ATOM    116  CA  VAL A   9      38.549  -0.955  62.819  1.00  0.00           C  
ATOM    117  C   VAL A   9      40.036  -0.644  63.012  1.00  0.00           C  
ATOM    118  O   VAL A   9      40.581   0.244  62.389  1.00  0.00           O  
ATOM    119  CB  VAL A   9      38.308  -1.594  61.453  1.00  0.00           C  
ATOM    120  CG1 VAL A   9      38.724  -0.619  60.351  1.00  0.00           C  
ATOM    121  CG2 VAL A   9      39.137  -2.876  61.337  1.00  0.00           C  
ATOM    122  H   VAL A   9      38.195   1.164  62.610  1.00  0.00           H  
ATOM    123  HA  VAL A   9      38.194  -1.608  63.600  1.00  0.00           H  
ATOM    124  HB  VAL A   9      37.259  -1.831  61.346  1.00  0.00           H  
ATOM    125 HG11 VAL A   9      38.488  -1.044  59.386  1.00  0.00           H  
ATOM    126 HG12 VAL A   9      39.786  -0.437  60.414  1.00  0.00           H  
ATOM    127 HG13 VAL A   9      38.191   0.312  60.474  1.00  0.00           H  
ATOM    128 HG21 VAL A   9      38.842  -3.566  62.114  1.00  0.00           H  
ATOM    129 HG22 VAL A   9      40.184  -2.637  61.447  1.00  0.00           H  
ATOM    130 HG23 VAL A   9      38.969  -3.328  60.370  1.00  0.00           H  
ATOM    131  N   GLU A  10      40.696  -1.372  63.872  1.00  0.00           N  
ATOM    132  CA  GLU A  10      42.147  -1.118  64.104  1.00  0.00           C  
ATOM    133  C   GLU A  10      42.986  -1.859  63.061  1.00  0.00           C  
ATOM    134  O   GLU A  10      42.814  -3.042  62.837  1.00  0.00           O  
ATOM    135  CB  GLU A  10      42.426  -1.664  65.505  1.00  0.00           C  
ATOM    136  CG  GLU A  10      42.906  -0.527  66.410  1.00  0.00           C  
ATOM    137  CD  GLU A  10      43.974  -1.054  67.370  1.00  0.00           C  
ATOM    138  OE1 GLU A  10      45.020  -1.461  66.894  1.00  0.00           O  
ATOM    139  OE2 GLU A  10      43.727  -1.040  68.564  1.00  0.00           O  
ATOM    140  H   GLU A  10      40.238  -2.084  64.366  1.00  0.00           H  
ATOM    141  HA  GLU A  10      42.355  -0.060  64.073  1.00  0.00           H  
ATOM    142  HB2 GLU A  10      41.520  -2.091  65.911  1.00  0.00           H  
ATOM    143  HB3 GLU A  10      43.190  -2.423  65.450  1.00  0.00           H  
ATOM    144  HG2 GLU A  10      43.324   0.264  65.802  1.00  0.00           H  
ATOM    145  HG3 GLU A  10      42.072  -0.142  66.977  1.00  0.00           H  
ATOM    146  N   GLY A  11      43.895  -1.175  62.420  1.00  0.00           N  
ATOM    147  CA  GLY A  11      44.743  -1.842  61.392  1.00  0.00           C  
ATOM    148  C   GLY A  11      46.207  -1.447  61.602  1.00  0.00           C  
ATOM    149  O   GLY A  11      46.760  -0.663  60.856  1.00  0.00           O  
ATOM    150  H   GLY A  11      44.018  -0.222  62.614  1.00  0.00           H  
ATOM    151  HA2 GLY A  11      44.641  -2.914  61.482  1.00  0.00           H  
ATOM    152  HA3 GLY A  11      44.428  -1.531  60.407  1.00  0.00           H  
ATOM    153  N   SER A  12      46.838  -1.984  62.610  1.00  0.00           N  
ATOM    154  CA  SER A  12      48.265  -1.639  62.865  1.00  0.00           C  
ATOM    155  C   SER A  12      48.400  -0.148  63.187  1.00  0.00           C  
ATOM    156  O   SER A  12      49.488   0.391  63.234  1.00  0.00           O  
ATOM    157  CB  SER A  12      48.992  -1.974  61.564  1.00  0.00           C  
ATOM    158  OG  SER A  12      50.384  -2.100  61.823  1.00  0.00           O  
ATOM    159  H   SER A  12      46.373  -2.615  63.199  1.00  0.00           H  
ATOM    160  HA  SER A  12      48.659  -2.236  63.673  1.00  0.00           H  
ATOM    161  HB2 SER A  12      48.619  -2.905  61.170  1.00  0.00           H  
ATOM    162  HB3 SER A  12      48.819  -1.186  60.843  1.00  0.00           H  
ATOM    163  HG  SER A  12      50.557  -3.008  62.083  1.00  0.00           H  
ATOM    164  N   GLU A  13      47.302   0.522  63.410  1.00  0.00           N  
ATOM    165  CA  GLU A  13      47.364   1.973  63.731  1.00  0.00           C  
ATOM    166  C   GLU A  13      48.298   2.682  62.764  1.00  0.00           C  
ATOM    167  O   GLU A  13      48.875   3.710  63.059  1.00  0.00           O  
ATOM    168  CB  GLU A  13      47.916   2.020  65.140  1.00  0.00           C  
ATOM    169  CG  GLU A  13      47.255   3.157  65.921  1.00  0.00           C  
ATOM    170  CD  GLU A  13      46.906   2.674  67.331  1.00  0.00           C  
ATOM    171  OE1 GLU A  13      46.145   1.726  67.439  1.00  0.00           O  
ATOM    172  OE2 GLU A  13      47.405   3.260  68.277  1.00  0.00           O  
ATOM    173  H   GLU A  13      46.439   0.069  63.372  1.00  0.00           H  
ATOM    174  HA  GLU A  13      46.385   2.409  63.694  1.00  0.00           H  
ATOM    175  HB2 GLU A  13      47.716   1.078  65.623  1.00  0.00           H  
ATOM    176  HB3 GLU A  13      48.978   2.181  65.096  1.00  0.00           H  
ATOM    177  HG2 GLU A  13      47.936   3.994  65.985  1.00  0.00           H  
ATOM    178  HG3 GLU A  13      46.352   3.464  65.415  1.00  0.00           H  
ATOM    179  N   SER A  14      48.438   2.125  61.611  1.00  0.00           N  
ATOM    180  CA  SER A  14      49.327   2.728  60.578  1.00  0.00           C  
ATOM    181  C   SER A  14      48.575   2.875  59.254  1.00  0.00           C  
ATOM    182  O   SER A  14      47.577   2.224  59.021  1.00  0.00           O  
ATOM    183  CB  SER A  14      50.487   1.745  60.428  1.00  0.00           C  
ATOM    184  OG  SER A  14      50.119   0.491  60.988  1.00  0.00           O  
ATOM    185  H   SER A  14      47.950   1.301  61.427  1.00  0.00           H  
ATOM    186  HA  SER A  14      49.696   3.686  60.912  1.00  0.00           H  
ATOM    187  HB2 SER A  14      50.716   1.613  59.384  1.00  0.00           H  
ATOM    188  HB3 SER A  14      51.357   2.137  60.937  1.00  0.00           H  
ATOM    189  HG  SER A  14      50.919   0.053  61.285  1.00  0.00           H  
ATOM    190  N   THR A  15      49.048   3.724  58.384  1.00  0.00           N  
ATOM    191  CA  THR A  15      48.362   3.909  57.076  1.00  0.00           C  
ATOM    192  C   THR A  15      49.301   3.514  55.933  1.00  0.00           C  
ATOM    193  O   THR A  15      48.892   3.361  54.800  1.00  0.00           O  
ATOM    194  CB  THR A  15      48.011   5.404  57.023  1.00  0.00           C  
ATOM    195  OG1 THR A  15      46.835   5.584  56.248  1.00  0.00           O  
ATOM    196  CG2 THR A  15      49.159   6.209  56.403  1.00  0.00           C  
ATOM    197  H   THR A  15      49.857   4.238  58.592  1.00  0.00           H  
ATOM    198  HA  THR A  15      47.462   3.319  57.039  1.00  0.00           H  
ATOM    199  HB  THR A  15      47.835   5.758  58.026  1.00  0.00           H  
ATOM    200  HG1 THR A  15      46.186   6.035  56.793  1.00  0.00           H  
ATOM    201 HG21 THR A  15      49.296   5.908  55.375  1.00  0.00           H  
ATOM    202 HG22 THR A  15      50.068   6.026  56.956  1.00  0.00           H  
ATOM    203 HG23 THR A  15      48.921   7.262  56.439  1.00  0.00           H  
ATOM    204  N   THR A  16      50.557   3.357  56.230  1.00  0.00           N  
ATOM    205  CA  THR A  16      51.533   2.979  55.167  1.00  0.00           C  
ATOM    206  C   THR A  16      52.663   2.126  55.747  1.00  0.00           C  
ATOM    207  O   THR A  16      52.825   2.037  56.948  1.00  0.00           O  
ATOM    208  CB  THR A  16      52.085   4.306  54.644  1.00  0.00           C  
ATOM    209  OG1 THR A  16      51.631   5.371  55.468  1.00  0.00           O  
ATOM    210  CG2 THR A  16      51.606   4.527  53.213  1.00  0.00           C  
ATOM    211  H   THR A  16      50.860   3.493  57.152  1.00  0.00           H  
ATOM    212  HA  THR A  16      51.034   2.451  54.370  1.00  0.00           H  
ATOM    213  HB  THR A  16      53.164   4.275  54.656  1.00  0.00           H  
ATOM    214  HG1 THR A  16      51.957   5.219  56.358  1.00  0.00           H  
ATOM    215 HG21 THR A  16      51.878   3.676  52.605  1.00  0.00           H  
ATOM    216 HG22 THR A  16      52.069   5.414  52.816  1.00  0.00           H  
ATOM    217 HG23 THR A  16      50.533   4.646  53.206  1.00  0.00           H  
ATOM    218  N   PRO A  17      53.405   1.522  54.859  1.00  0.00           N  
ATOM    219  CA  PRO A  17      54.535   0.657  55.268  1.00  0.00           C  
ATOM    220  C   PRO A  17      55.756   1.502  55.653  1.00  0.00           C  
ATOM    221  O   PRO A  17      56.425   1.230  56.629  1.00  0.00           O  
ATOM    222  CB  PRO A  17      54.824  -0.164  54.016  1.00  0.00           C  
ATOM    223  CG  PRO A  17      54.327   0.666  52.873  1.00  0.00           C  
ATOM    224  CD  PRO A  17      53.253   1.584  53.403  1.00  0.00           C  
ATOM    225  HA  PRO A  17      54.248   0.007  56.078  1.00  0.00           H  
ATOM    226  HB2 PRO A  17      55.887  -0.339  53.921  1.00  0.00           H  
ATOM    227  HB3 PRO A  17      54.290  -1.101  54.051  1.00  0.00           H  
ATOM    228  HG2 PRO A  17      55.140   1.248  52.462  1.00  0.00           H  
ATOM    229  HG3 PRO A  17      53.910   0.027  52.109  1.00  0.00           H  
ATOM    230  HD3 PRO A  17      53.411   2.593  53.046  1.00  0.00           H  
ATOM    231  HD2 PRO A  17      52.276   1.228  53.116  1.00  0.00           H  
ATOM    232  N   PHE A  18      56.057   2.520  54.890  1.00  0.00           N  
ATOM    233  CA  PHE A  18      57.240   3.368  55.216  1.00  0.00           C  
ATOM    234  C   PHE A  18      56.810   4.613  55.995  1.00  0.00           C  
ATOM    235  O   PHE A  18      56.167   5.499  55.468  1.00  0.00           O  
ATOM    236  CB  PHE A  18      57.833   3.755  53.862  1.00  0.00           C  
ATOM    237  CG  PHE A  18      58.351   2.517  53.170  1.00  0.00           C  
ATOM    238  CD1 PHE A  18      59.608   2.001  53.508  1.00  0.00           C  
ATOM    239  CD2 PHE A  18      57.573   1.883  52.195  1.00  0.00           C  
ATOM    240  CE1 PHE A  18      60.087   0.851  52.869  1.00  0.00           C  
ATOM    241  CE2 PHE A  18      58.051   0.732  51.557  1.00  0.00           C  
ATOM    242  CZ  PHE A  18      59.309   0.216  51.893  1.00  0.00           C  
ATOM    243  H   PHE A  18      55.511   2.726  54.102  1.00  0.00           H  
ATOM    244  HA  PHE A  18      57.961   2.800  55.783  1.00  0.00           H  
ATOM    245  HB2 PHE A  18      57.070   4.216  53.252  1.00  0.00           H  
ATOM    246  HB3 PHE A  18      58.646   4.451  54.009  1.00  0.00           H  
ATOM    247  HD1 PHE A  18      60.209   2.490  54.260  1.00  0.00           H  
ATOM    248  HD2 PHE A  18      56.604   2.282  51.934  1.00  0.00           H  
ATOM    249  HE1 PHE A  18      61.057   0.453  53.129  1.00  0.00           H  
ATOM    250  HE2 PHE A  18      57.451   0.243  50.804  1.00  0.00           H  
ATOM    251  HZ  PHE A  18      59.678  -0.671  51.401  1.00  0.00           H  
ATOM    252  N   ASN A  19      57.166   4.684  57.248  1.00  0.00           N  
ATOM    253  CA  ASN A  19      56.790   5.864  58.071  1.00  0.00           C  
ATOM    254  C   ASN A  19      57.975   6.296  58.932  1.00  0.00           C  
ATOM    255  O   ASN A  19      58.815   5.499  59.298  1.00  0.00           O  
ATOM    256  CB  ASN A  19      55.637   5.385  58.953  1.00  0.00           C  
ATOM    257  CG  ASN A  19      54.653   4.569  58.114  1.00  0.00           C  
ATOM    258  OD1 ASN A  19      53.557   5.014  57.838  1.00  0.00           O  
ATOM    259  ND2 ASN A  19      55.000   3.383  57.695  1.00  0.00           N  
ATOM    260  H   ASN A  19      57.683   3.961  57.650  1.00  0.00           H  
ATOM    261  HA  ASN A  19      56.462   6.675  57.442  1.00  0.00           H  
ATOM    262  HB2 ASN A  19      56.028   4.771  59.751  1.00  0.00           H  
ATOM    263  HB3 ASN A  19      55.129   6.238  59.371  1.00  0.00           H  
ATOM    264 HD21 ASN A  19      55.885   3.024  57.919  1.00  0.00           H  
ATOM    265 HD22 ASN A  19      54.379   2.853  57.157  1.00  0.00           H  
ATOM    266  N   LEU A  20      58.047   7.553  59.258  1.00  0.00           N  
ATOM    267  CA  LEU A  20      59.176   8.041  60.098  1.00  0.00           C  
ATOM    268  C   LEU A  20      58.826   9.391  60.730  1.00  0.00           C  
ATOM    269  O   LEU A  20      57.740   9.909  60.556  1.00  0.00           O  
ATOM    270  CB  LEU A  20      60.355   8.188  59.135  1.00  0.00           C  
ATOM    271  CG  LEU A  20      60.024   9.241  58.078  1.00  0.00           C  
ATOM    272  CD1 LEU A  20      60.250  10.639  58.656  1.00  0.00           C  
ATOM    273  CD2 LEU A  20      60.934   9.040  56.865  1.00  0.00           C  
ATOM    274  H   LEU A  20      57.357   8.175  58.953  1.00  0.00           H  
ATOM    275  HA  LEU A  20      59.415   7.320  60.864  1.00  0.00           H  
ATOM    276  HB2 LEU A  20      61.232   8.494  59.686  1.00  0.00           H  
ATOM    277  HB3 LEU A  20      60.544   7.243  58.652  1.00  0.00           H  
ATOM    278  HG  LEU A  20      58.991   9.139  57.777  1.00  0.00           H  
ATOM    279 HD11 LEU A  20      60.663  11.282  57.892  1.00  0.00           H  
ATOM    280 HD12 LEU A  20      60.938  10.578  59.486  1.00  0.00           H  
ATOM    281 HD13 LEU A  20      59.309  11.043  58.998  1.00  0.00           H  
ATOM    282 HD21 LEU A  20      60.933   9.937  56.262  1.00  0.00           H  
ATOM    283 HD22 LEU A  20      60.572   8.210  56.277  1.00  0.00           H  
ATOM    284 HD23 LEU A  20      61.939   8.833  57.200  1.00  0.00           H  
ATOM    285  N   PHE A  21      59.741   9.961  61.463  1.00  0.00           N  
ATOM    286  CA  PHE A  21      59.468  11.275  62.114  1.00  0.00           C  
ATOM    287  C   PHE A  21      60.341  12.368  61.491  1.00  0.00           C  
ATOM    288  O   PHE A  21      61.461  12.126  61.086  1.00  0.00           O  
ATOM    289  CB  PHE A  21      59.835  11.067  63.584  1.00  0.00           C  
ATOM    290  CG  PHE A  21      59.936  12.405  64.273  1.00  0.00           C  
ATOM    291  CD1 PHE A  21      58.952  13.377  64.062  1.00  0.00           C  
ATOM    292  CD2 PHE A  21      61.015  12.673  65.124  1.00  0.00           C  
ATOM    293  CE1 PHE A  21      59.047  14.619  64.702  1.00  0.00           C  
ATOM    294  CE2 PHE A  21      61.110  13.915  65.764  1.00  0.00           C  
ATOM    295  CZ  PHE A  21      60.126  14.888  65.553  1.00  0.00           C  
ATOM    296  H   PHE A  21      60.610   9.524  61.588  1.00  0.00           H  
ATOM    297  HA  PHE A  21      58.424  11.530  62.027  1.00  0.00           H  
ATOM    298  HB2 PHE A  21      59.071  10.472  64.064  1.00  0.00           H  
ATOM    299  HB3 PHE A  21      60.783  10.556  63.649  1.00  0.00           H  
ATOM    300  HD1 PHE A  21      58.120  13.171  63.406  1.00  0.00           H  
ATOM    301  HD2 PHE A  21      61.774  11.923  65.287  1.00  0.00           H  
ATOM    302  HE1 PHE A  21      58.288  15.369  64.539  1.00  0.00           H  
ATOM    303  HE2 PHE A  21      61.942  14.121  66.421  1.00  0.00           H  
ATOM    304  HZ  PHE A  21      60.199  15.846  66.047  1.00  0.00           H  
ATOM    305  N   ILE A  22      59.837  13.569  61.413  1.00  0.00           N  
ATOM    306  CA  ILE A  22      60.636  14.678  60.819  1.00  0.00           C  
ATOM    307  C   ILE A  22      60.605  15.897  61.749  1.00  0.00           C  
ATOM    308  O   ILE A  22      59.703  16.060  62.543  1.00  0.00           O  
ATOM    309  CB  ILE A  22      59.954  14.971  59.474  1.00  0.00           C  
ATOM    310  CG1 ILE A  22      60.620  14.131  58.382  1.00  0.00           C  
ATOM    311  CG2 ILE A  22      60.083  16.456  59.117  1.00  0.00           C  
ATOM    312  CD1 ILE A  22      59.564  13.670  57.376  1.00  0.00           C  
ATOM    313  H   ILE A  22      58.932  13.743  61.748  1.00  0.00           H  
ATOM    314  HA  ILE A  22      61.653  14.360  60.654  1.00  0.00           H  
ATOM    315  HB  ILE A  22      58.909  14.709  59.540  1.00  0.00           H  
ATOM    316 HG12 ILE A  22      61.366  14.726  57.876  1.00  0.00           H  
ATOM    317 HG13 ILE A  22      61.091  13.267  58.828  1.00  0.00           H  
ATOM    318 HG21 ILE A  22      59.290  17.011  59.598  1.00  0.00           H  
ATOM    319 HG22 ILE A  22      60.007  16.577  58.047  1.00  0.00           H  
ATOM    320 HG23 ILE A  22      61.039  16.827  59.456  1.00  0.00           H  
ATOM    321 HD11 ILE A  22      59.006  14.525  57.024  1.00  0.00           H  
ATOM    322 HD12 ILE A  22      58.891  12.973  57.854  1.00  0.00           H  
ATOM    323 HD13 ILE A  22      60.048  13.187  56.540  1.00  0.00           H  
ATOM    324  N   GLY A  23      61.589  16.750  61.654  1.00  0.00           N  
ATOM    325  CA  GLY A  23      61.617  17.954  62.535  1.00  0.00           C  
ATOM    326  C   GLY A  23      62.016  19.187  61.720  1.00  0.00           C  
ATOM    327  O   GLY A  23      61.990  19.176  60.505  1.00  0.00           O  
ATOM    328  H   GLY A  23      62.309  16.597  61.006  1.00  0.00           H  
ATOM    329  HA2 GLY A  23      60.637  18.107  62.963  1.00  0.00           H  
ATOM    330  HA3 GLY A  23      62.335  17.802  63.326  1.00  0.00           H  
ATOM    331  N   ASN A  24      62.383  20.251  62.382  1.00  0.00           N  
ATOM    332  CA  ASN A  24      62.780  21.488  61.650  1.00  0.00           C  
ATOM    333  C   ASN A  24      61.577  22.064  60.900  1.00  0.00           C  
ATOM    334  O   ASN A  24      61.508  22.021  59.688  1.00  0.00           O  
ATOM    335  CB  ASN A  24      63.865  21.041  60.669  1.00  0.00           C  
ATOM    336  CG  ASN A  24      64.670  22.259  60.210  1.00  0.00           C  
ATOM    337  OD1 ASN A  24      64.269  23.384  60.427  1.00  0.00           O  
ATOM    338  ND2 ASN A  24      65.799  22.079  59.580  1.00  0.00           N  
ATOM    339  H   ASN A  24      62.393  20.237  63.362  1.00  0.00           H  
ATOM    340  HA  ASN A  24      63.182  22.219  62.333  1.00  0.00           H  
ATOM    341  HB2 ASN A  24      64.522  20.335  61.155  1.00  0.00           H  
ATOM    342  HB3 ASN A  24      63.405  20.574  59.814  1.00  0.00           H  
ATOM    343 HD21 ASN A  24      66.124  21.171  59.405  1.00  0.00           H  
ATOM    344 HD22 ASN A  24      66.321  22.853  59.281  1.00  0.00           H  
ATOM    345  N   LEU A  25      60.629  22.604  61.615  1.00  0.00           N  
ATOM    346  CA  LEU A  25      59.428  23.181  60.948  1.00  0.00           C  
ATOM    347  C   LEU A  25      59.315  24.673  61.259  1.00  0.00           C  
ATOM    348  O   LEU A  25      59.390  25.091  62.397  1.00  0.00           O  
ATOM    349  CB  LEU A  25      58.241  22.421  61.538  1.00  0.00           C  
ATOM    350  CG  LEU A  25      58.132  21.046  60.877  1.00  0.00           C  
ATOM    351  CD1 LEU A  25      59.395  20.234  61.171  1.00  0.00           C  
ATOM    352  CD2 LEU A  25      56.913  20.309  61.435  1.00  0.00           C  
ATOM    353  H   LEU A  25      60.704  22.627  62.592  1.00  0.00           H  
ATOM    354  HA  LEU A  25      59.473  23.025  59.882  1.00  0.00           H  
ATOM    355  HB2 LEU A  25      58.386  22.299  62.602  1.00  0.00           H  
ATOM    356  HB3 LEU A  25      57.333  22.976  61.361  1.00  0.00           H  
ATOM    357  HG  LEU A  25      58.024  21.168  59.808  1.00  0.00           H  
ATOM    358 HD11 LEU A  25      60.090  20.340  60.352  1.00  0.00           H  
ATOM    359 HD12 LEU A  25      59.134  19.193  61.289  1.00  0.00           H  
ATOM    360 HD13 LEU A  25      59.851  20.596  62.081  1.00  0.00           H  
ATOM    361 HD21 LEU A  25      56.820  20.514  62.491  1.00  0.00           H  
ATOM    362 HD22 LEU A  25      57.033  19.247  61.283  1.00  0.00           H  
ATOM    363 HD23 LEU A  25      56.023  20.646  60.924  1.00  0.00           H  
ATOM    364  N   ASN A  26      59.136  25.476  60.250  1.00  0.00           N  
ATOM    365  CA  ASN A  26      59.016  26.944  60.469  1.00  0.00           C  
ATOM    366  C   ASN A  26      57.915  27.242  61.492  1.00  0.00           C  
ATOM    367  O   ASN A  26      56.743  27.101  61.203  1.00  0.00           O  
ATOM    368  CB  ASN A  26      58.645  27.504  59.099  1.00  0.00           C  
ATOM    369  CG  ASN A  26      58.386  29.007  59.211  1.00  0.00           C  
ATOM    370  OD1 ASN A  26      58.760  29.630  60.185  1.00  0.00           O  
ATOM    371  ND2 ASN A  26      57.757  29.621  58.247  1.00  0.00           N  
ATOM    372  H   ASN A  26      59.078  25.112  59.342  1.00  0.00           H  
ATOM    373  HA  ASN A  26      59.957  27.356  60.795  1.00  0.00           H  
ATOM    374  HB2 ASN A  26      59.457  27.325  58.408  1.00  0.00           H  
ATOM    375  HB3 ASN A  26      57.754  27.012  58.741  1.00  0.00           H  
ATOM    376 HD21 ASN A  26      57.455  29.120  57.462  1.00  0.00           H  
ATOM    377 HD22 ASN A  26      57.586  30.584  58.309  1.00  0.00           H  
ATOM    378  N   PRO A  27      58.336  27.644  62.660  1.00  0.00           N  
ATOM    379  CA  PRO A  27      57.379  27.968  63.747  1.00  0.00           C  
ATOM    380  C   PRO A  27      56.691  29.308  63.473  1.00  0.00           C  
ATOM    381  O   PRO A  27      55.759  29.688  64.153  1.00  0.00           O  
ATOM    382  CB  PRO A  27      58.265  28.055  64.987  1.00  0.00           C  
ATOM    383  CG  PRO A  27      59.627  28.395  64.470  1.00  0.00           C  
ATOM    384  CD  PRO A  27      59.730  27.833  63.074  1.00  0.00           C  
ATOM    385  HA  PRO A  27      56.654  27.180  63.865  1.00  0.00           H  
ATOM    386  HB2 PRO A  27      57.906  28.833  65.647  1.00  0.00           H  
ATOM    387  HB3 PRO A  27      58.290  27.107  65.500  1.00  0.00           H  
ATOM    388  HG2 PRO A  27      59.755  29.468  64.447  1.00  0.00           H  
ATOM    389  HG3 PRO A  27      60.381  27.945  65.098  1.00  0.00           H  
ATOM    390  HD3 PRO A  27      60.230  28.534  62.422  1.00  0.00           H  
ATOM    391  HD2 PRO A  27      60.246  26.886  63.082  1.00  0.00           H  
ATOM    392  N   ASN A  28      57.144  30.028  62.481  1.00  0.00           N  
ATOM    393  CA  ASN A  28      56.513  31.341  62.166  1.00  0.00           C  
ATOM    394  C   ASN A  28      55.284  31.133  61.280  1.00  0.00           C  
ATOM    395  O   ASN A  28      54.466  32.017  61.113  1.00  0.00           O  
ATOM    396  CB  ASN A  28      57.588  32.130  61.419  1.00  0.00           C  
ATOM    397  CG  ASN A  28      58.781  32.373  62.345  1.00  0.00           C  
ATOM    398  OD1 ASN A  28      59.444  31.442  62.757  1.00  0.00           O  
ATOM    399  ND2 ASN A  28      59.085  33.594  62.690  1.00  0.00           N  
ATOM    400  H   ASN A  28      57.896  29.704  61.943  1.00  0.00           H  
ATOM    401  HA  ASN A  28      56.240  31.856  63.073  1.00  0.00           H  
ATOM    402  HB2 ASN A  28      57.909  31.568  60.553  1.00  0.00           H  
ATOM    403  HB3 ASN A  28      57.183  33.080  61.101  1.00  0.00           H  
ATOM    404 HD21 ASN A  28      58.551  34.345  62.357  1.00  0.00           H  
ATOM    405 HD22 ASN A  28      59.848  33.760  63.282  1.00  0.00           H  
ATOM    406  N   LYS A  29      55.148  29.967  60.713  1.00  0.00           N  
ATOM    407  CA  LYS A  29      53.976  29.690  59.839  1.00  0.00           C  
ATOM    408  C   LYS A  29      53.136  28.561  60.438  1.00  0.00           C  
ATOM    409  O   LYS A  29      53.188  28.300  61.623  1.00  0.00           O  
ATOM    410  CB  LYS A  29      54.576  29.266  58.498  1.00  0.00           C  
ATOM    411  CG  LYS A  29      54.310  30.353  57.456  1.00  0.00           C  
ATOM    412  CD  LYS A  29      52.820  30.375  57.109  1.00  0.00           C  
ATOM    413  CE  LYS A  29      52.412  31.792  56.696  1.00  0.00           C  
ATOM    414  NZ  LYS A  29      51.376  32.198  57.686  1.00  0.00           N  
ATOM    415  H   LYS A  29      55.819  29.270  60.864  1.00  0.00           H  
ATOM    416  HA  LYS A  29      53.379  30.579  59.711  1.00  0.00           H  
ATOM    417  HB2 LYS A  29      55.641  29.127  58.610  1.00  0.00           H  
ATOM    418  HB3 LYS A  29      54.123  28.341  58.176  1.00  0.00           H  
ATOM    419  HG2 LYS A  29      54.602  31.314  57.855  1.00  0.00           H  
ATOM    420  HG3 LYS A  29      54.882  30.145  56.565  1.00  0.00           H  
ATOM    421  HD2 LYS A  29      52.630  29.693  56.293  1.00  0.00           H  
ATOM    422  HD3 LYS A  29      52.245  30.075  57.973  1.00  0.00           H  
ATOM    423  HE2 LYS A  29      53.265  32.456  56.746  1.00  0.00           H  
ATOM    424  HE3 LYS A  29      51.993  31.788  55.702  1.00  0.00           H  
ATOM    425  HZ1 LYS A  29      50.775  32.940  57.275  1.00  0.00           H  
ATOM    426  HZ2 LYS A  29      51.840  32.562  58.544  1.00  0.00           H  
ATOM    427  HZ3 LYS A  29      50.789  31.376  57.930  1.00  0.00           H  
ATOM    428  N   SER A  30      52.365  27.890  59.630  1.00  0.00           N  
ATOM    429  CA  SER A  30      51.526  26.779  60.161  1.00  0.00           C  
ATOM    430  C   SER A  30      52.184  25.433  59.873  1.00  0.00           C  
ATOM    431  O   SER A  30      52.830  25.247  58.856  1.00  0.00           O  
ATOM    432  CB  SER A  30      50.204  26.879  59.410  1.00  0.00           C  
ATOM    433  OG  SER A  30      49.853  28.246  59.248  1.00  0.00           O  
ATOM    434  H   SER A  30      52.338  28.116  58.678  1.00  0.00           H  
ATOM    435  HA  SER A  30      51.359  26.901  61.218  1.00  0.00           H  
ATOM    436  HB2 SER A  30      50.308  26.420  58.440  1.00  0.00           H  
ATOM    437  HB3 SER A  30      49.437  26.361  59.969  1.00  0.00           H  
ATOM    438  HG  SER A  30      48.946  28.285  58.935  1.00  0.00           H  
ATOM    439  N   VAL A  31      52.013  24.483  60.745  1.00  0.00           N  
ATOM    440  CA  VAL A  31      52.619  23.152  60.498  1.00  0.00           C  
ATOM    441  C   VAL A  31      51.889  22.479  59.337  1.00  0.00           C  
ATOM    442  O   VAL A  31      52.464  21.719  58.584  1.00  0.00           O  
ATOM    443  CB  VAL A  31      52.439  22.360  61.794  1.00  0.00           C  
ATOM    444  CG1 VAL A  31      53.293  21.093  61.733  1.00  0.00           C  
ATOM    445  CG2 VAL A  31      52.887  23.209  62.988  1.00  0.00           C  
ATOM    446  H   VAL A  31      51.475  24.643  61.546  1.00  0.00           H  
ATOM    447  HA  VAL A  31      53.664  23.258  60.272  1.00  0.00           H  
ATOM    448  HB  VAL A  31      51.401  22.092  61.908  1.00  0.00           H  
ATOM    449 HG11 VAL A  31      53.227  20.568  62.674  1.00  0.00           H  
ATOM    450 HG12 VAL A  31      54.322  21.362  61.544  1.00  0.00           H  
ATOM    451 HG13 VAL A  31      52.936  20.456  60.939  1.00  0.00           H  
ATOM    452 HG21 VAL A  31      52.836  22.615  63.888  1.00  0.00           H  
ATOM    453 HG22 VAL A  31      52.242  24.067  63.089  1.00  0.00           H  
ATOM    454 HG23 VAL A  31      53.905  23.539  62.833  1.00  0.00           H  
ATOM    455  N   ALA A  32      50.627  22.773  59.175  1.00  0.00           N  
ATOM    456  CA  ALA A  32      49.864  22.171  58.047  1.00  0.00           C  
ATOM    457  C   ALA A  32      50.463  22.654  56.727  1.00  0.00           C  
ATOM    458  O   ALA A  32      50.576  21.912  55.771  1.00  0.00           O  
ATOM    459  CB  ALA A  32      48.433  22.683  58.213  1.00  0.00           C  
ATOM    460  H   ALA A  32      50.187  23.401  59.784  1.00  0.00           H  
ATOM    461  HA  ALA A  32      49.886  21.096  58.104  1.00  0.00           H  
ATOM    462  HB1 ALA A  32      47.930  22.105  58.975  1.00  0.00           H  
ATOM    463  HB2 ALA A  32      47.904  22.584  57.277  1.00  0.00           H  
ATOM    464  HB3 ALA A  32      48.455  23.722  58.506  1.00  0.00           H  
ATOM    465  N   GLU A  33      50.865  23.893  56.682  1.00  0.00           N  
ATOM    466  CA  GLU A  33      51.481  24.434  55.438  1.00  0.00           C  
ATOM    467  C   GLU A  33      52.834  23.760  55.221  1.00  0.00           C  
ATOM    468  O   GLU A  33      53.224  23.468  54.107  1.00  0.00           O  
ATOM    469  CB  GLU A  33      51.653  25.932  55.698  1.00  0.00           C  
ATOM    470  CG  GLU A  33      50.288  26.563  55.977  1.00  0.00           C  
ATOM    471  CD  GLU A  33      49.540  26.769  54.659  1.00  0.00           C  
ATOM    472  OE1 GLU A  33      50.113  26.471  53.623  1.00  0.00           O  
ATOM    473  OE2 GLU A  33      48.408  27.220  54.706  1.00  0.00           O  
ATOM    474  H   GLU A  33      50.777  24.464  57.472  1.00  0.00           H  
ATOM    475  HA  GLU A  33      50.834  24.272  54.589  1.00  0.00           H  
ATOM    476  HB2 GLU A  33      52.299  26.078  56.552  1.00  0.00           H  
ATOM    477  HB3 GLU A  33      52.092  26.401  54.831  1.00  0.00           H  
ATOM    478  HG2 GLU A  33      49.714  25.909  56.619  1.00  0.00           H  
ATOM    479  HG3 GLU A  33      50.423  27.516  56.465  1.00  0.00           H  
ATOM    480  N   LEU A  34      53.545  23.489  56.283  1.00  0.00           N  
ATOM    481  CA  LEU A  34      54.859  22.811  56.144  1.00  0.00           C  
ATOM    482  C   LEU A  34      54.638  21.432  55.532  1.00  0.00           C  
ATOM    483  O   LEU A  34      55.453  20.929  54.785  1.00  0.00           O  
ATOM    484  CB  LEU A  34      55.389  22.690  57.573  1.00  0.00           C  
ATOM    485  CG  LEU A  34      56.301  23.876  57.884  1.00  0.00           C  
ATOM    486  CD1 LEU A  34      55.591  24.828  58.850  1.00  0.00           C  
ATOM    487  CD2 LEU A  34      57.591  23.368  58.529  1.00  0.00           C  
ATOM    488  H   LEU A  34      53.206  23.717  57.173  1.00  0.00           H  
ATOM    489  HA  LEU A  34      55.531  23.398  55.541  1.00  0.00           H  
ATOM    490  HB2 LEU A  34      54.559  22.682  58.264  1.00  0.00           H  
ATOM    491  HB3 LEU A  34      55.948  21.774  57.671  1.00  0.00           H  
ATOM    492  HG  LEU A  34      56.535  24.402  56.970  1.00  0.00           H  
ATOM    493 HD11 LEU A  34      54.853  25.403  58.312  1.00  0.00           H  
ATOM    494 HD12 LEU A  34      56.314  25.496  59.294  1.00  0.00           H  
ATOM    495 HD13 LEU A  34      55.106  24.255  59.627  1.00  0.00           H  
ATOM    496 HD21 LEU A  34      58.438  23.877  58.092  1.00  0.00           H  
ATOM    497 HD22 LEU A  34      57.684  22.305  58.359  1.00  0.00           H  
ATOM    498 HD23 LEU A  34      57.563  23.563  59.591  1.00  0.00           H  
ATOM    499  N   LYS A  35      53.525  20.824  55.838  1.00  0.00           N  
ATOM    500  CA  LYS A  35      53.225  19.483  55.273  1.00  0.00           C  
ATOM    501  C   LYS A  35      53.044  19.602  53.759  1.00  0.00           C  
ATOM    502  O   LYS A  35      53.645  18.880  52.989  1.00  0.00           O  
ATOM    503  CB  LYS A  35      51.920  19.052  55.943  1.00  0.00           C  
ATOM    504  CG  LYS A  35      52.231  18.245  57.205  1.00  0.00           C  
ATOM    505  CD  LYS A  35      52.749  19.181  58.298  1.00  0.00           C  
ATOM    506  CE  LYS A  35      53.592  18.382  59.295  1.00  0.00           C  
ATOM    507  NZ  LYS A  35      54.851  18.064  58.565  1.00  0.00           N  
ATOM    508  H   LYS A  35      52.880  21.259  56.435  1.00  0.00           H  
ATOM    509  HA  LYS A  35      54.013  18.790  55.511  1.00  0.00           H  
ATOM    510  HB2 LYS A  35      51.345  19.928  56.208  1.00  0.00           H  
ATOM    511  HB3 LYS A  35      51.349  18.441  55.259  1.00  0.00           H  
ATOM    512  HG2 LYS A  35      51.334  17.752  57.547  1.00  0.00           H  
ATOM    513  HG3 LYS A  35      52.986  17.506  56.981  1.00  0.00           H  
ATOM    514  HD2 LYS A  35      53.356  19.956  57.852  1.00  0.00           H  
ATOM    515  HD3 LYS A  35      51.913  19.628  58.815  1.00  0.00           H  
ATOM    516  HE2 LYS A  35      53.803  18.981  60.171  1.00  0.00           H  
ATOM    517  HE3 LYS A  35      53.086  17.471  59.573  1.00  0.00           H  
ATOM    518  HZ1 LYS A  35      55.027  18.790  57.843  1.00  0.00           H  
ATOM    519  HZ2 LYS A  35      54.760  17.133  58.108  1.00  0.00           H  
ATOM    520  HZ3 LYS A  35      55.646  18.046  59.235  1.00  0.00           H  
ATOM    521  N   VAL A  36      52.226  20.524  53.330  1.00  0.00           N  
ATOM    522  CA  VAL A  36      52.008  20.715  51.869  1.00  0.00           C  
ATOM    523  C   VAL A  36      53.334  21.028  51.184  1.00  0.00           C  
ATOM    524  O   VAL A  36      53.576  20.614  50.074  1.00  0.00           O  
ATOM    525  CB  VAL A  36      51.072  21.911  51.768  1.00  0.00           C  
ATOM    526  CG1 VAL A  36      50.567  22.049  50.331  1.00  0.00           C  
ATOM    527  CG2 VAL A  36      49.884  21.712  52.711  1.00  0.00           C  
ATOM    528  H   VAL A  36      51.762  21.101  53.973  1.00  0.00           H  
ATOM    529  HA  VAL A  36      51.551  19.845  51.426  1.00  0.00           H  
ATOM    530  HB  VAL A  36      51.613  22.799  52.047  1.00  0.00           H  
ATOM    531 HG11 VAL A  36      49.586  22.502  50.336  1.00  0.00           H  
ATOM    532 HG12 VAL A  36      50.509  21.072  49.874  1.00  0.00           H  
ATOM    533 HG13 VAL A  36      51.248  22.670  49.768  1.00  0.00           H  
ATOM    534 HG21 VAL A  36      50.113  22.143  53.676  1.00  0.00           H  
ATOM    535 HG22 VAL A  36      49.689  20.656  52.827  1.00  0.00           H  
ATOM    536 HG23 VAL A  36      49.012  22.196  52.299  1.00  0.00           H  
ATOM    537  N   ALA A  37      54.200  21.751  51.839  1.00  0.00           N  
ATOM    538  CA  ALA A  37      55.510  22.068  51.211  1.00  0.00           C  
ATOM    539  C   ALA A  37      56.276  20.770  50.995  1.00  0.00           C  
ATOM    540  O   ALA A  37      56.967  20.596  50.011  1.00  0.00           O  
ATOM    541  CB  ALA A  37      56.233  22.970  52.213  1.00  0.00           C  
ATOM    542  H   ALA A  37      53.992  22.074  52.739  1.00  0.00           H  
ATOM    543  HA  ALA A  37      55.366  22.582  50.276  1.00  0.00           H  
ATOM    544  HB1 ALA A  37      55.629  23.076  53.103  1.00  0.00           H  
ATOM    545  HB2 ALA A  37      56.396  23.941  51.770  1.00  0.00           H  
ATOM    546  HB3 ALA A  37      57.183  22.529  52.473  1.00  0.00           H  
ATOM    547  N   ILE A  38      56.139  19.847  51.902  1.00  0.00           N  
ATOM    548  CA  ILE A  38      56.836  18.544  51.747  1.00  0.00           C  
ATOM    549  C   ILE A  38      56.044  17.662  50.781  1.00  0.00           C  
ATOM    550  O   ILE A  38      56.593  16.813  50.107  1.00  0.00           O  
ATOM    551  CB  ILE A  38      56.858  17.931  53.147  1.00  0.00           C  
ATOM    552  CG1 ILE A  38      57.673  18.827  54.083  1.00  0.00           C  
ATOM    553  CG2 ILE A  38      57.499  16.543  53.086  1.00  0.00           C  
ATOM    554  CD1 ILE A  38      57.203  18.622  55.524  1.00  0.00           C  
ATOM    555  H   ILE A  38      55.563  20.006  52.679  1.00  0.00           H  
ATOM    556  HA  ILE A  38      57.842  18.692  51.388  1.00  0.00           H  
ATOM    557  HB  ILE A  38      55.847  17.844  53.518  1.00  0.00           H  
ATOM    558 HG12 ILE A  38      58.720  18.570  54.005  1.00  0.00           H  
ATOM    559 HG13 ILE A  38      57.534  19.861  53.804  1.00  0.00           H  
ATOM    560 HG21 ILE A  38      57.479  16.094  54.066  1.00  0.00           H  
ATOM    561 HG22 ILE A  38      58.522  16.634  52.751  1.00  0.00           H  
ATOM    562 HG23 ILE A  38      56.948  15.923  52.394  1.00  0.00           H  
ATOM    563 HD11 ILE A  38      58.036  18.761  56.197  1.00  0.00           H  
ATOM    564 HD12 ILE A  38      56.812  17.622  55.637  1.00  0.00           H  
ATOM    565 HD13 ILE A  38      56.430  19.340  55.755  1.00  0.00           H  
ATOM    566  N   SER A  39      54.755  17.870  50.693  1.00  0.00           N  
ATOM    567  CA  SER A  39      53.942  17.049  49.751  1.00  0.00           C  
ATOM    568  C   SER A  39      54.112  17.597  48.337  1.00  0.00           C  
ATOM    569  O   SER A  39      54.043  16.878  47.358  1.00  0.00           O  
ATOM    570  CB  SER A  39      52.498  17.208  50.224  1.00  0.00           C  
ATOM    571  OG  SER A  39      52.136  16.084  51.015  1.00  0.00           O  
ATOM    572  H   SER A  39      54.326  18.576  51.233  1.00  0.00           H  
ATOM    573  HA  SER A  39      54.239  16.013  49.798  1.00  0.00           H  
ATOM    574  HB2 SER A  39      52.408  18.103  50.816  1.00  0.00           H  
ATOM    575  HB3 SER A  39      51.846  17.282  49.364  1.00  0.00           H  
ATOM    576  HG  SER A  39      52.596  16.152  51.855  1.00  0.00           H  
ATOM    577  N   GLU A  40      54.354  18.872  48.231  1.00  0.00           N  
ATOM    578  CA  GLU A  40      54.547  19.493  46.897  1.00  0.00           C  
ATOM    579  C   GLU A  40      55.974  19.245  46.427  1.00  0.00           C  
ATOM    580  O   GLU A  40      56.226  18.986  45.266  1.00  0.00           O  
ATOM    581  CB  GLU A  40      54.303  20.976  47.130  1.00  0.00           C  
ATOM    582  CG  GLU A  40      53.495  21.553  45.966  1.00  0.00           C  
ATOM    583  CD  GLU A  40      54.445  21.981  44.846  1.00  0.00           C  
ATOM    584  OE1 GLU A  40      55.534  22.431  45.160  1.00  0.00           O  
ATOM    585  OE2 GLU A  40      54.066  21.851  43.694  1.00  0.00           O  
ATOM    586  H   GLU A  40      54.421  19.424  49.037  1.00  0.00           H  
ATOM    587  HA  GLU A  40      53.840  19.108  46.191  1.00  0.00           H  
ATOM    588  HB2 GLU A  40      53.754  21.105  48.050  1.00  0.00           H  
ATOM    589  HB3 GLU A  40      55.249  21.484  47.198  1.00  0.00           H  
ATOM    590  HG2 GLU A  40      52.812  20.801  45.596  1.00  0.00           H  
ATOM    591  HG3 GLU A  40      52.935  22.410  46.309  1.00  0.00           H  
ATOM    592  N   LEU A  41      56.909  19.307  47.329  1.00  0.00           N  
ATOM    593  CA  LEU A  41      58.324  19.057  46.949  1.00  0.00           C  
ATOM    594  C   LEU A  41      58.484  17.590  46.568  1.00  0.00           C  
ATOM    595  O   LEU A  41      59.272  17.239  45.712  1.00  0.00           O  
ATOM    596  CB  LEU A  41      59.145  19.389  48.195  1.00  0.00           C  
ATOM    597  CG  LEU A  41      60.483  19.999  47.775  1.00  0.00           C  
ATOM    598  CD1 LEU A  41      60.254  21.414  47.241  1.00  0.00           C  
ATOM    599  CD2 LEU A  41      61.419  20.058  48.983  1.00  0.00           C  
ATOM    600  H   LEU A  41      56.676  19.505  48.259  1.00  0.00           H  
ATOM    601  HA  LEU A  41      58.611  19.693  46.129  1.00  0.00           H  
ATOM    602  HB2 LEU A  41      58.602  20.094  48.809  1.00  0.00           H  
ATOM    603  HB3 LEU A  41      59.324  18.486  48.760  1.00  0.00           H  
ATOM    604  HG  LEU A  41      60.928  19.391  47.001  1.00  0.00           H  
ATOM    605 HD11 LEU A  41      60.059  21.370  46.180  1.00  0.00           H  
ATOM    606 HD12 LEU A  41      61.133  22.013  47.422  1.00  0.00           H  
ATOM    607 HD13 LEU A  41      59.406  21.856  47.745  1.00  0.00           H  
ATOM    608 HD21 LEU A  41      62.263  20.692  48.754  1.00  0.00           H  
ATOM    609 HD22 LEU A  41      61.769  19.064  49.217  1.00  0.00           H  
ATOM    610 HD23 LEU A  41      60.886  20.462  49.831  1.00  0.00           H  
ATOM    611  N   PHE A  42      57.726  16.732  47.190  1.00  0.00           N  
ATOM    612  CA  PHE A  42      57.810  15.292  46.862  1.00  0.00           C  
ATOM    613  C   PHE A  42      56.963  15.018  45.621  1.00  0.00           C  
ATOM    614  O   PHE A  42      57.177  14.062  44.904  1.00  0.00           O  
ATOM    615  CB  PHE A  42      57.225  14.592  48.081  1.00  0.00           C  
ATOM    616  CG  PHE A  42      58.251  14.541  49.190  1.00  0.00           C  
ATOM    617  CD1 PHE A  42      58.867  15.720  49.633  1.00  0.00           C  
ATOM    618  CD2 PHE A  42      58.584  13.316  49.779  1.00  0.00           C  
ATOM    619  CE1 PHE A  42      59.815  15.670  50.661  1.00  0.00           C  
ATOM    620  CE2 PHE A  42      59.532  13.267  50.809  1.00  0.00           C  
ATOM    621  CZ  PHE A  42      60.147  14.445  51.249  1.00  0.00           C  
ATOM    622  H   PHE A  42      57.087  17.037  47.869  1.00  0.00           H  
ATOM    623  HA  PHE A  42      58.835  14.990  46.707  1.00  0.00           H  
ATOM    624  HB2 PHE A  42      56.360  15.133  48.417  1.00  0.00           H  
ATOM    625  HB3 PHE A  42      56.937  13.597  47.813  1.00  0.00           H  
ATOM    626  HD1 PHE A  42      58.612  16.666  49.181  1.00  0.00           H  
ATOM    627  HD2 PHE A  42      58.109  12.407  49.439  1.00  0.00           H  
ATOM    628  HE1 PHE A  42      60.290  16.579  51.002  1.00  0.00           H  
ATOM    629  HE2 PHE A  42      59.788  12.321  51.263  1.00  0.00           H  
ATOM    630  HZ  PHE A  42      60.878  14.407  52.044  1.00  0.00           H  
ATOM    631  N   ALA A  43      56.002  15.866  45.360  1.00  0.00           N  
ATOM    632  CA  ALA A  43      55.141  15.670  44.160  1.00  0.00           C  
ATOM    633  C   ALA A  43      55.936  16.023  42.902  1.00  0.00           C  
ATOM    634  O   ALA A  43      55.766  15.429  41.857  1.00  0.00           O  
ATOM    635  CB  ALA A  43      53.970  16.634  44.346  1.00  0.00           C  
ATOM    636  H   ALA A  43      55.854  16.638  45.951  1.00  0.00           H  
ATOM    637  HA  ALA A  43      54.784  14.654  44.111  1.00  0.00           H  
ATOM    638  HB1 ALA A  43      53.343  16.287  45.154  1.00  0.00           H  
ATOM    639  HB2 ALA A  43      53.391  16.677  43.435  1.00  0.00           H  
ATOM    640  HB3 ALA A  43      54.346  17.619  44.580  1.00  0.00           H  
ATOM    641  N   LYS A  44      56.814  16.983  43.006  1.00  0.00           N  
ATOM    642  CA  LYS A  44      57.638  17.374  41.828  1.00  0.00           C  
ATOM    643  C   LYS A  44      58.917  16.537  41.801  1.00  0.00           C  
ATOM    644  O   LYS A  44      59.552  16.383  40.776  1.00  0.00           O  
ATOM    645  CB  LYS A  44      57.964  18.853  42.043  1.00  0.00           C  
ATOM    646  CG  LYS A  44      57.116  19.706  41.097  1.00  0.00           C  
ATOM    647  CD  LYS A  44      57.432  21.185  41.323  1.00  0.00           C  
ATOM    648  CE  LYS A  44      56.223  22.034  40.923  1.00  0.00           C  
ATOM    649  NZ  LYS A  44      56.325  22.177  39.444  1.00  0.00           N  
ATOM    650  H   LYS A  44      56.940  17.440  43.863  1.00  0.00           H  
ATOM    651  HA  LYS A  44      57.079  17.245  40.915  1.00  0.00           H  
ATOM    652  HB2 LYS A  44      57.746  19.124  43.066  1.00  0.00           H  
ATOM    653  HB3 LYS A  44      59.010  19.025  41.839  1.00  0.00           H  
ATOM    654  HG2 LYS A  44      57.341  19.440  40.074  1.00  0.00           H  
ATOM    655  HG3 LYS A  44      56.069  19.529  41.293  1.00  0.00           H  
ATOM    656  HD2 LYS A  44      57.659  21.350  42.366  1.00  0.00           H  
ATOM    657  HD3 LYS A  44      58.282  21.468  40.720  1.00  0.00           H  
ATOM    658  HE2 LYS A  44      55.305  21.529  41.193  1.00  0.00           H  
ATOM    659  HE3 LYS A  44      56.272  23.004  41.392  1.00  0.00           H  
ATOM    660  HZ1 LYS A  44      55.982  21.307  38.988  1.00  0.00           H  
ATOM    661  HZ2 LYS A  44      57.318  22.340  39.180  1.00  0.00           H  
ATOM    662  HZ3 LYS A  44      55.746  22.981  39.131  1.00  0.00           H  
ATOM    663  N   ASN A  45      59.294  15.989  42.924  1.00  0.00           N  
ATOM    664  CA  ASN A  45      60.523  15.153  42.976  1.00  0.00           C  
ATOM    665  C   ASN A  45      60.214  13.747  42.460  1.00  0.00           C  
ATOM    666  O   ASN A  45      61.104  13.012  42.084  1.00  0.00           O  
ATOM    667  CB  ASN A  45      60.903  15.112  44.454  1.00  0.00           C  
ATOM    668  CG  ASN A  45      61.961  16.178  44.738  1.00  0.00           C  
ATOM    669  OD1 ASN A  45      62.968  15.903  45.359  1.00  0.00           O  
ATOM    670  ND2 ASN A  45      61.773  17.393  44.304  1.00  0.00           N  
ATOM    671  H   ASN A  45      58.763  16.123  43.737  1.00  0.00           H  
ATOM    672  HA  ASN A  45      61.315  15.606  42.400  1.00  0.00           H  
ATOM    673  HB2 ASN A  45      60.028  15.303  45.057  1.00  0.00           H  
ATOM    674  HB3 ASN A  45      61.300  14.139  44.696  1.00  0.00           H  
ATOM    675 HD21 ASN A  45      60.959  17.615  43.804  1.00  0.00           H  
ATOM    676 HD22 ASN A  45      62.442  18.086  44.480  1.00  0.00           H  
ATOM    677  N   ASP A  46      58.950  13.378  42.469  1.00  0.00           N  
ATOM    678  CA  ASP A  46      58.509  12.021  42.005  1.00  0.00           C  
ATOM    679  C   ASP A  46      58.495  11.079  43.196  1.00  0.00           C  
ATOM    680  O   ASP A  46      58.692   9.887  43.074  1.00  0.00           O  
ATOM    681  CB  ASP A  46      59.500  11.550  40.934  1.00  0.00           C  
ATOM    682  CG  ASP A  46      58.810  10.547  40.007  1.00  0.00           C  
ATOM    683  OD1 ASP A  46      57.683  10.179  40.298  1.00  0.00           O  
ATOM    684  OD2 ASP A  46      59.419  10.165  39.022  1.00  0.00           O  
ATOM    685  H   ASP A  46      58.273  14.000  42.810  1.00  0.00           H  
ATOM    686  HA  ASP A  46      57.518  12.088  41.585  1.00  0.00           H  
ATOM    687  HB2 ASP A  46      59.840  12.399  40.359  1.00  0.00           H  
ATOM    688  HB3 ASP A  46      60.345  11.075  41.410  1.00  0.00           H  
ATOM    689  N   LEU A  47      58.245  11.622  44.350  1.00  0.00           N  
ATOM    690  CA  LEU A  47      58.195  10.788  45.573  1.00  0.00           C  
ATOM    691  C   LEU A  47      56.800  10.172  45.703  1.00  0.00           C  
ATOM    692  O   LEU A  47      56.208   9.744  44.731  1.00  0.00           O  
ATOM    693  CB  LEU A  47      58.485  11.767  46.718  1.00  0.00           C  
ATOM    694  CG  LEU A  47      59.522  11.157  47.663  1.00  0.00           C  
ATOM    695  CD1 LEU A  47      58.920   9.942  48.370  1.00  0.00           C  
ATOM    696  CD2 LEU A  47      60.748  10.721  46.858  1.00  0.00           C  
ATOM    697  H   LEU A  47      58.080  12.588  44.408  1.00  0.00           H  
ATOM    698  HA  LEU A  47      58.947  10.019  45.542  1.00  0.00           H  
ATOM    699  HB2 LEU A  47      58.868  12.693  46.313  1.00  0.00           H  
ATOM    700  HB3 LEU A  47      57.580  11.971  47.263  1.00  0.00           H  
ATOM    701  HG  LEU A  47      59.815  11.891  48.398  1.00  0.00           H  
ATOM    702 HD11 LEU A  47      58.217  10.274  49.120  1.00  0.00           H  
ATOM    703 HD12 LEU A  47      59.707   9.372  48.841  1.00  0.00           H  
ATOM    704 HD13 LEU A  47      58.410   9.321  47.648  1.00  0.00           H  
ATOM    705 HD21 LEU A  47      60.732   9.649  46.728  1.00  0.00           H  
ATOM    706 HD22 LEU A  47      61.646  11.005  47.388  1.00  0.00           H  
ATOM    707 HD23 LEU A  47      60.734  11.201  45.891  1.00  0.00           H  
ATOM    708  N   ALA A  48      56.270  10.128  46.885  1.00  0.00           N  
ATOM    709  CA  ALA A  48      54.913   9.547  47.078  1.00  0.00           C  
ATOM    710  C   ALA A  48      54.499   9.679  48.540  1.00  0.00           C  
ATOM    711  O   ALA A  48      54.215   8.707  49.212  1.00  0.00           O  
ATOM    712  CB  ALA A  48      55.042   8.077  46.680  1.00  0.00           C  
ATOM    713  H   ALA A  48      56.761  10.480  47.647  1.00  0.00           H  
ATOM    714  HA  ALA A  48      54.199  10.044  46.442  1.00  0.00           H  
ATOM    715  HB1 ALA A  48      55.908   7.950  46.046  1.00  0.00           H  
ATOM    716  HB2 ALA A  48      54.156   7.769  46.145  1.00  0.00           H  
ATOM    717  HB3 ALA A  48      55.155   7.474  47.567  1.00  0.00           H  
ATOM    718  N   VAL A  49      54.464  10.881  49.031  1.00  0.00           N  
ATOM    719  CA  VAL A  49      54.076  11.105  50.438  1.00  0.00           C  
ATOM    720  C   VAL A  49      52.665  10.588  50.675  1.00  0.00           C  
ATOM    721  O   VAL A  49      51.704  11.050  50.093  1.00  0.00           O  
ATOM    722  CB  VAL A  49      54.142  12.616  50.623  1.00  0.00           C  
ATOM    723  CG1 VAL A  49      55.603  13.069  50.634  1.00  0.00           C  
ATOM    724  CG2 VAL A  49      53.401  13.305  49.474  1.00  0.00           C  
ATOM    725  H   VAL A  49      54.695  11.640  48.475  1.00  0.00           H  
ATOM    726  HA  VAL A  49      54.771  10.617  51.101  1.00  0.00           H  
ATOM    727  HB  VAL A  49      53.680  12.877  51.555  1.00  0.00           H  
ATOM    728 HG11 VAL A  49      55.887  13.341  51.639  1.00  0.00           H  
ATOM    729 HG12 VAL A  49      55.719  13.924  49.984  1.00  0.00           H  
ATOM    730 HG13 VAL A  49      56.232  12.264  50.287  1.00  0.00           H  
ATOM    731 HG21 VAL A  49      52.770  12.587  48.972  1.00  0.00           H  
ATOM    732 HG22 VAL A  49      54.118  13.706  48.772  1.00  0.00           H  
ATOM    733 HG23 VAL A  49      52.794  14.107  49.866  1.00  0.00           H  
ATOM    734  N   VAL A  50      52.550   9.620  51.523  1.00  0.00           N  
ATOM    735  CA  VAL A  50      51.216   9.026  51.822  1.00  0.00           C  
ATOM    736  C   VAL A  50      50.614   9.677  53.069  1.00  0.00           C  
ATOM    737  O   VAL A  50      49.415   9.845  53.171  1.00  0.00           O  
ATOM    738  CB  VAL A  50      51.494   7.541  52.065  1.00  0.00           C  
ATOM    739  CG1 VAL A  50      50.202   6.743  51.884  1.00  0.00           C  
ATOM    740  CG2 VAL A  50      52.541   7.044  51.061  1.00  0.00           C  
ATOM    741  H   VAL A  50      53.352   9.272  51.959  1.00  0.00           H  
ATOM    742  HA  VAL A  50      50.555   9.143  50.979  1.00  0.00           H  
ATOM    743  HB  VAL A  50      51.864   7.403  53.071  1.00  0.00           H  
ATOM    744 HG11 VAL A  50      49.679   6.685  52.827  1.00  0.00           H  
ATOM    745 HG12 VAL A  50      50.440   5.747  51.542  1.00  0.00           H  
ATOM    746 HG13 VAL A  50      49.575   7.234  51.155  1.00  0.00           H  
ATOM    747 HG21 VAL A  50      52.696   5.986  51.192  1.00  0.00           H  
ATOM    748 HG22 VAL A  50      53.471   7.567  51.225  1.00  0.00           H  
ATOM    749 HG23 VAL A  50      52.193   7.238  50.058  1.00  0.00           H  
ATOM    750  N   ASP A  51      51.431  10.047  54.017  1.00  0.00           N  
ATOM    751  CA  ASP A  51      50.888  10.686  55.250  1.00  0.00           C  
ATOM    752  C   ASP A  51      51.847  11.758  55.770  1.00  0.00           C  
ATOM    753  O   ASP A  51      53.040  11.707  55.546  1.00  0.00           O  
ATOM    754  CB  ASP A  51      50.757   9.549  56.263  1.00  0.00           C  
ATOM    755  CG  ASP A  51      49.593   9.842  57.213  1.00  0.00           C  
ATOM    756  OD1 ASP A  51      49.012  10.907  57.095  1.00  0.00           O  
ATOM    757  OD2 ASP A  51      49.303   8.994  58.041  1.00  0.00           O  
ATOM    758  H   ASP A  51      52.397   9.905  53.919  1.00  0.00           H  
ATOM    759  HA  ASP A  51      49.918  11.114  55.054  1.00  0.00           H  
ATOM    760  HB2 ASP A  51      50.572   8.624  55.741  1.00  0.00           H  
ATOM    761  HB3 ASP A  51      51.671   9.467  56.832  1.00  0.00           H  
ATOM    762  N   VAL A  52      51.330  12.729  56.471  1.00  0.00           N  
ATOM    763  CA  VAL A  52      52.198  13.813  57.025  1.00  0.00           C  
ATOM    764  C   VAL A  52      51.504  14.435  58.239  1.00  0.00           C  
ATOM    765  O   VAL A  52      50.615  15.252  58.102  1.00  0.00           O  
ATOM    766  CB  VAL A  52      52.363  14.863  55.912  1.00  0.00           C  
ATOM    767  CG1 VAL A  52      53.741  15.514  56.036  1.00  0.00           C  
ATOM    768  CG2 VAL A  52      52.245  14.212  54.527  1.00  0.00           C  
ATOM    769  H   VAL A  52      50.366  12.743  56.643  1.00  0.00           H  
ATOM    770  HA  VAL A  52      53.161  13.415  57.306  1.00  0.00           H  
ATOM    771  HB  VAL A  52      51.600  15.621  56.021  1.00  0.00           H  
ATOM    772 HG11 VAL A  52      53.986  15.642  57.080  1.00  0.00           H  
ATOM    773 HG12 VAL A  52      53.729  16.477  55.548  1.00  0.00           H  
ATOM    774 HG13 VAL A  52      54.481  14.882  55.568  1.00  0.00           H  
ATOM    775 HG21 VAL A  52      51.318  13.662  54.466  1.00  0.00           H  
ATOM    776 HG22 VAL A  52      53.075  13.537  54.376  1.00  0.00           H  
ATOM    777 HG23 VAL A  52      52.261  14.979  53.768  1.00  0.00           H  
ATOM    778  N   ARG A  53      51.888  14.048  59.426  1.00  0.00           N  
ATOM    779  CA  ARG A  53      51.229  14.615  60.636  1.00  0.00           C  
ATOM    780  C   ARG A  53      52.112  15.681  61.283  1.00  0.00           C  
ATOM    781  O   ARG A  53      53.314  15.703  61.103  1.00  0.00           O  
ATOM    782  CB  ARG A  53      51.040  13.429  61.581  1.00  0.00           C  
ATOM    783  CG  ARG A  53      50.176  13.857  62.768  1.00  0.00           C  
ATOM    784  CD  ARG A  53      49.682  12.616  63.516  1.00  0.00           C  
ATOM    785  NE  ARG A  53      50.300  12.711  64.867  1.00  0.00           N  
ATOM    786  CZ  ARG A  53      50.819  11.651  65.423  1.00  0.00           C  
ATOM    787  NH1 ARG A  53      50.273  10.480  65.235  1.00  0.00           N  
ATOM    788  NH2 ARG A  53      51.885  11.760  66.170  1.00  0.00           N  
ATOM    789  H   ARG A  53      52.600  13.381  59.520  1.00  0.00           H  
ATOM    790  HA  ARG A  53      50.270  15.032  60.379  1.00  0.00           H  
ATOM    791  HB2 ARG A  53      50.555  12.623  61.053  1.00  0.00           H  
ATOM    792  HB3 ARG A  53      52.003  13.097  61.940  1.00  0.00           H  
ATOM    793  HG2 ARG A  53      50.762  14.472  63.434  1.00  0.00           H  
ATOM    794  HG3 ARG A  53      49.328  14.421  62.410  1.00  0.00           H  
ATOM    795  HD2 ARG A  53      48.603  12.629  63.590  1.00  0.00           H  
ATOM    796  HD3 ARG A  53      50.016  11.718  63.018  1.00  0.00           H  
ATOM    797  HE  ARG A  53      50.316  13.570  65.340  1.00  0.00           H  
ATOM    798 HH11 ARG A  53      49.457  10.396  64.664  1.00  0.00           H  
ATOM    799 HH12 ARG A  53      50.671   9.668  65.661  1.00  0.00           H  
ATOM    800 HH21 ARG A  53      52.303  12.657  66.315  1.00  0.00           H  
ATOM    801 HH22 ARG A  53      52.282  10.948  66.596  1.00  0.00           H  
ATOM    802  N   THR A  54      51.521  16.568  62.032  1.00  0.00           N  
ATOM    803  CA  THR A  54      52.309  17.637  62.692  1.00  0.00           C  
ATOM    804  C   THR A  54      52.764  17.182  64.081  1.00  0.00           C  
ATOM    805  O   THR A  54      52.149  16.336  64.702  1.00  0.00           O  
ATOM    806  CB  THR A  54      51.332  18.804  62.800  1.00  0.00           C  
ATOM    807  OG1 THR A  54      50.159  18.375  63.476  1.00  0.00           O  
ATOM    808  CG2 THR A  54      50.965  19.298  61.401  1.00  0.00           C  
ATOM    809  H   THR A  54      50.553  16.536  62.161  1.00  0.00           H  
ATOM    810  HA  THR A  54      53.156  17.916  62.085  1.00  0.00           H  
ATOM    811  HB  THR A  54      51.789  19.602  63.350  1.00  0.00           H  
ATOM    812  HG1 THR A  54      50.246  18.611  64.402  1.00  0.00           H  
ATOM    813 HG21 THR A  54      50.854  20.373  61.416  1.00  0.00           H  
ATOM    814 HG22 THR A  54      50.035  18.845  61.091  1.00  0.00           H  
ATOM    815 HG23 THR A  54      51.746  19.027  60.706  1.00  0.00           H  
ATOM    816  N   GLY A  55      53.835  17.737  64.574  1.00  0.00           N  
ATOM    817  CA  GLY A  55      54.333  17.344  65.922  1.00  0.00           C  
ATOM    818  C   GLY A  55      54.523  18.597  66.776  1.00  0.00           C  
ATOM    819  O   GLY A  55      55.163  19.550  66.366  1.00  0.00           O  
ATOM    820  H   GLY A  55      54.314  18.417  64.057  1.00  0.00           H  
ATOM    821  HA2 GLY A  55      53.615  16.688  66.394  1.00  0.00           H  
ATOM    822  HA3 GLY A  55      55.279  16.832  65.824  1.00  0.00           H  
ATOM    823  N   THR A  56      53.959  18.602  67.957  1.00  0.00           N  
ATOM    824  CA  THR A  56      54.077  19.788  68.856  1.00  0.00           C  
ATOM    825  C   THR A  56      53.461  21.015  68.182  1.00  0.00           C  
ATOM    826  O   THR A  56      53.108  20.980  67.020  1.00  0.00           O  
ATOM    827  CB  THR A  56      55.579  19.984  69.090  1.00  0.00           C  
ATOM    828  OG1 THR A  56      56.038  19.018  70.026  1.00  0.00           O  
ATOM    829  CG2 THR A  56      55.833  21.388  69.643  1.00  0.00           C  
ATOM    830  H   THR A  56      53.446  17.821  68.250  1.00  0.00           H  
ATOM    831  HA  THR A  56      53.584  19.592  69.796  1.00  0.00           H  
ATOM    832  HB  THR A  56      56.112  19.866  68.161  1.00  0.00           H  
ATOM    833  HG1 THR A  56      55.440  19.027  70.777  1.00  0.00           H  
ATOM    834 HG21 THR A  56      55.270  21.523  70.555  1.00  0.00           H  
ATOM    835 HG22 THR A  56      55.522  22.123  68.916  1.00  0.00           H  
ATOM    836 HG23 THR A  56      56.887  21.508  69.849  1.00  0.00           H  
ATOM    837  N   ASN A  57      53.320  22.096  68.905  1.00  0.00           N  
ATOM    838  CA  ASN A  57      52.717  23.328  68.311  1.00  0.00           C  
ATOM    839  C   ASN A  57      53.190  23.510  66.867  1.00  0.00           C  
ATOM    840  O   ASN A  57      52.421  23.845  65.988  1.00  0.00           O  
ATOM    841  CB  ASN A  57      53.218  24.475  69.189  1.00  0.00           C  
ATOM    842  CG  ASN A  57      52.505  24.432  70.542  1.00  0.00           C  
ATOM    843  OD1 ASN A  57      51.297  24.546  70.608  1.00  0.00           O  
ATOM    844  ND2 ASN A  57      53.207  24.272  71.631  1.00  0.00           N  
ATOM    845  H   ASN A  57      53.606  22.096  69.842  1.00  0.00           H  
ATOM    846  HA  ASN A  57      51.641  23.277  68.352  1.00  0.00           H  
ATOM    847  HB2 ASN A  57      54.284  24.372  69.339  1.00  0.00           H  
ATOM    848  HB3 ASN A  57      53.011  25.416  68.705  1.00  0.00           H  
ATOM    849 HD21 ASN A  57      54.181  24.180  71.577  1.00  0.00           H  
ATOM    850 HD22 ASN A  57      52.759  24.244  72.502  1.00  0.00           H  
ATOM    851  N   ARG A  58      54.450  23.284  66.617  1.00  0.00           N  
ATOM    852  CA  ARG A  58      54.984  23.433  65.233  1.00  0.00           C  
ATOM    853  C   ARG A  58      56.506  23.296  65.247  1.00  0.00           C  
ATOM    854  O   ARG A  58      57.219  24.130  64.726  1.00  0.00           O  
ATOM    855  CB  ARG A  58      54.575  24.837  64.785  1.00  0.00           C  
ATOM    856  CG  ARG A  58      54.828  25.839  65.916  1.00  0.00           C  
ATOM    857  CD  ARG A  58      53.511  26.521  66.295  1.00  0.00           C  
ATOM    858  NE  ARG A  58      53.910  27.712  67.096  1.00  0.00           N  
ATOM    859  CZ  ARG A  58      53.020  28.614  67.410  1.00  0.00           C  
ATOM    860  NH1 ARG A  58      52.009  28.838  66.617  1.00  0.00           N  
ATOM    861  NH2 ARG A  58      53.143  29.293  68.519  1.00  0.00           N  
ATOM    862  H   ARG A  58      55.048  23.009  67.342  1.00  0.00           H  
ATOM    863  HA  ARG A  58      54.547  22.695  64.579  1.00  0.00           H  
ATOM    864  HB2 ARG A  58      55.156  25.119  63.919  1.00  0.00           H  
ATOM    865  HB3 ARG A  58      53.527  24.843  64.530  1.00  0.00           H  
ATOM    866  HG2 ARG A  58      55.228  25.321  66.774  1.00  0.00           H  
ATOM    867  HG3 ARG A  58      55.535  26.585  65.584  1.00  0.00           H  
ATOM    868  HD2 ARG A  58      52.977  26.824  65.405  1.00  0.00           H  
ATOM    869  HD3 ARG A  58      52.903  25.860  66.892  1.00  0.00           H  
ATOM    870  HE  ARG A  58      54.839  27.818  67.388  1.00  0.00           H  
ATOM    871 HH11 ARG A  58      51.915  28.319  65.768  1.00  0.00           H  
ATOM    872 HH12 ARG A  58      51.328  29.529  66.858  1.00  0.00           H  
ATOM    873 HH21 ARG A  58      53.918  29.121  69.127  1.00  0.00           H  
ATOM    874 HH22 ARG A  58      52.461  29.984  68.760  1.00  0.00           H  
ATOM    875  N   LYS A  59      57.009  22.252  65.843  1.00  0.00           N  
ATOM    876  CA  LYS A  59      58.485  22.068  65.893  1.00  0.00           C  
ATOM    877  C   LYS A  59      58.908  20.891  65.012  1.00  0.00           C  
ATOM    878  O   LYS A  59      59.988  20.883  64.454  1.00  0.00           O  
ATOM    879  CB  LYS A  59      58.802  21.781  67.361  1.00  0.00           C  
ATOM    880  CG  LYS A  59      59.818  22.804  67.873  1.00  0.00           C  
ATOM    881  CD  LYS A  59      59.134  24.162  68.042  1.00  0.00           C  
ATOM    882  CE  LYS A  59      59.363  24.675  69.466  1.00  0.00           C  
ATOM    883  NZ  LYS A  59      57.996  24.878  70.025  1.00  0.00           N  
ATOM    884  H   LYS A  59      56.417  21.591  66.262  1.00  0.00           H  
ATOM    885  HA  LYS A  59      58.982  22.970  65.579  1.00  0.00           H  
ATOM    886  HB2 LYS A  59      57.896  21.849  67.945  1.00  0.00           H  
ATOM    887  HB3 LYS A  59      59.217  20.788  67.451  1.00  0.00           H  
ATOM    888  HG2 LYS A  59      60.211  22.475  68.825  1.00  0.00           H  
ATOM    889  HG3 LYS A  59      60.626  22.896  67.162  1.00  0.00           H  
ATOM    890  HD2 LYS A  59      59.550  24.864  67.334  1.00  0.00           H  
ATOM    891  HD3 LYS A  59      58.074  24.055  67.865  1.00  0.00           H  
ATOM    892  HE2 LYS A  59      59.905  23.941  70.046  1.00  0.00           H  
ATOM    893  HE3 LYS A  59      59.896  25.612  69.447  1.00  0.00           H  
ATOM    894  HZ1 LYS A  59      57.601  25.767  69.663  1.00  0.00           H  
ATOM    895  HZ2 LYS A  59      58.050  24.918  71.064  1.00  0.00           H  
ATOM    896  HZ3 LYS A  59      57.384  24.088  69.739  1.00  0.00           H  
ATOM    897  N   PHE A  60      58.073  19.897  64.876  1.00  0.00           N  
ATOM    898  CA  PHE A  60      58.452  18.732  64.024  1.00  0.00           C  
ATOM    899  C   PHE A  60      57.206  17.960  63.591  1.00  0.00           C  
ATOM    900  O   PHE A  60      56.219  17.919  64.292  1.00  0.00           O  
ATOM    901  CB  PHE A  60      59.346  17.863  64.910  1.00  0.00           C  
ATOM    902  CG  PHE A  60      58.702  17.680  66.264  1.00  0.00           C  
ATOM    903  CD1 PHE A  60      57.547  16.901  66.391  1.00  0.00           C  
ATOM    904  CD2 PHE A  60      59.266  18.285  67.393  1.00  0.00           C  
ATOM    905  CE1 PHE A  60      56.954  16.727  67.647  1.00  0.00           C  
ATOM    906  CE2 PHE A  60      58.673  18.113  68.649  1.00  0.00           C  
ATOM    907  CZ  PHE A  60      57.517  17.333  68.776  1.00  0.00           C  
ATOM    908  H   PHE A  60      57.199  19.915  65.333  1.00  0.00           H  
ATOM    909  HA  PHE A  60      59.005  19.063  63.160  1.00  0.00           H  
ATOM    910  HB2 PHE A  60      59.484  16.899  64.445  1.00  0.00           H  
ATOM    911  HB3 PHE A  60      60.305  18.343  65.031  1.00  0.00           H  
ATOM    912  HD1 PHE A  60      57.112  16.434  65.520  1.00  0.00           H  
ATOM    913  HD2 PHE A  60      60.158  18.887  67.295  1.00  0.00           H  
ATOM    914  HE1 PHE A  60      56.062  16.126  67.746  1.00  0.00           H  
ATOM    915  HE2 PHE A  60      59.107  18.580  69.521  1.00  0.00           H  
ATOM    916  HZ  PHE A  60      57.060  17.199  69.746  1.00  0.00           H  
ATOM    917  N   GLY A  61      57.242  17.351  62.437  1.00  0.00           N  
ATOM    918  CA  GLY A  61      56.054  16.588  61.960  1.00  0.00           C  
ATOM    919  C   GLY A  61      56.490  15.215  61.447  1.00  0.00           C  
ATOM    920  O   GLY A  61      57.655  14.974  61.201  1.00  0.00           O  
ATOM    921  H   GLY A  61      58.050  17.399  61.884  1.00  0.00           H  
ATOM    922  HA2 GLY A  61      55.357  16.460  62.774  1.00  0.00           H  
ATOM    923  HA3 GLY A  61      55.576  17.130  61.159  1.00  0.00           H  
ATOM    924  N   TYR A  62      55.561  14.314  61.278  1.00  0.00           N  
ATOM    925  CA  TYR A  62      55.920  12.955  60.776  1.00  0.00           C  
ATOM    926  C   TYR A  62      55.387  12.764  59.364  1.00  0.00           C  
ATOM    927  O   TYR A  62      54.534  13.496  58.904  1.00  0.00           O  
ATOM    928  CB  TYR A  62      55.257  11.975  61.743  1.00  0.00           C  
ATOM    929  CG  TYR A  62      55.786  12.203  63.139  1.00  0.00           C  
ATOM    930  CD1 TYR A  62      55.448  13.371  63.834  1.00  0.00           C  
ATOM    931  CD2 TYR A  62      56.613  11.245  63.738  1.00  0.00           C  
ATOM    932  CE1 TYR A  62      55.938  13.581  65.128  1.00  0.00           C  
ATOM    933  CE2 TYR A  62      57.103  11.456  65.033  1.00  0.00           C  
ATOM    934  CZ  TYR A  62      56.765  12.623  65.728  1.00  0.00           C  
ATOM    935  OH  TYR A  62      57.247  12.831  67.005  1.00  0.00           O  
ATOM    936  H   TYR A  62      54.625  14.531  61.481  1.00  0.00           H  
ATOM    937  HA  TYR A  62      56.988  12.817  60.778  1.00  0.00           H  
ATOM    938  HB2 TYR A  62      54.187  12.129  61.735  1.00  0.00           H  
ATOM    939  HB3 TYR A  62      55.476  10.962  61.437  1.00  0.00           H  
ATOM    940  HD1 TYR A  62      54.811  14.109  63.371  1.00  0.00           H  
ATOM    941  HD2 TYR A  62      56.874  10.345  63.202  1.00  0.00           H  
ATOM    942  HE1 TYR A  62      55.678  14.482  65.664  1.00  0.00           H  
ATOM    943  HE2 TYR A  62      57.740  10.717  65.496  1.00  0.00           H  
ATOM    944  HH  TYR A  62      56.884  13.658  67.328  1.00  0.00           H  
ATOM    945  N   VAL A  63      55.902  11.795  58.661  1.00  0.00           N  
ATOM    946  CA  VAL A  63      55.441  11.577  57.266  1.00  0.00           C  
ATOM    947  C   VAL A  63      55.578  10.103  56.874  1.00  0.00           C  
ATOM    948  O   VAL A  63      56.535   9.441  57.223  1.00  0.00           O  
ATOM    949  CB  VAL A  63      56.374  12.440  56.415  1.00  0.00           C  
ATOM    950  CG1 VAL A  63      55.754  12.649  55.043  1.00  0.00           C  
ATOM    951  CG2 VAL A  63      56.585  13.807  57.077  1.00  0.00           C  
ATOM    952  H   VAL A  63      56.602  11.225  59.046  1.00  0.00           H  
ATOM    953  HA  VAL A  63      54.422  11.910  57.148  1.00  0.00           H  
ATOM    954  HB  VAL A  63      57.324  11.940  56.311  1.00  0.00           H  
ATOM    955 HG11 VAL A  63      56.291  13.426  54.523  1.00  0.00           H  
ATOM    956 HG12 VAL A  63      54.720  12.938  55.158  1.00  0.00           H  
ATOM    957 HG13 VAL A  63      55.812  11.730  54.481  1.00  0.00           H  
ATOM    958 HG21 VAL A  63      55.626  14.259  57.282  1.00  0.00           H  
ATOM    959 HG22 VAL A  63      57.148  14.444  56.411  1.00  0.00           H  
ATOM    960 HG23 VAL A  63      57.129  13.680  58.000  1.00  0.00           H  
ATOM    961  N   ASP A  64      54.630   9.594  56.136  1.00  0.00           N  
ATOM    962  CA  ASP A  64      54.696   8.172  55.699  1.00  0.00           C  
ATOM    963  C   ASP A  64      54.907   8.112  54.185  1.00  0.00           C  
ATOM    964  O   ASP A  64      54.449   8.968  53.453  1.00  0.00           O  
ATOM    965  CB  ASP A  64      53.341   7.580  56.079  1.00  0.00           C  
ATOM    966  CG  ASP A  64      53.101   7.774  57.577  1.00  0.00           C  
ATOM    967  OD1 ASP A  64      54.069   7.981  58.290  1.00  0.00           O  
ATOM    968  OD2 ASP A  64      51.953   7.714  57.985  1.00  0.00           O  
ATOM    969  H   ASP A  64      53.876  10.149  55.861  1.00  0.00           H  
ATOM    970  HA  ASP A  64      55.487   7.652  56.213  1.00  0.00           H  
ATOM    971  HB2 ASP A  64      52.564   8.075  55.518  1.00  0.00           H  
ATOM    972  HB3 ASP A  64      53.335   6.528  55.849  1.00  0.00           H  
ATOM    973  N   PHE A  65      55.603   7.117  53.711  1.00  0.00           N  
ATOM    974  CA  PHE A  65      55.848   7.020  52.244  1.00  0.00           C  
ATOM    975  C   PHE A  65      55.033   5.880  51.631  1.00  0.00           C  
ATOM    976  O   PHE A  65      54.288   5.199  52.308  1.00  0.00           O  
ATOM    977  CB  PHE A  65      57.347   6.763  52.113  1.00  0.00           C  
ATOM    978  CG  PHE A  65      58.081   8.051  52.398  1.00  0.00           C  
ATOM    979  CD1 PHE A  65      57.793   9.195  51.645  1.00  0.00           C  
ATOM    980  CD2 PHE A  65      59.037   8.106  53.419  1.00  0.00           C  
ATOM    981  CE1 PHE A  65      58.460  10.395  51.911  1.00  0.00           C  
ATOM    982  CE2 PHE A  65      59.706   9.308  53.685  1.00  0.00           C  
ATOM    983  CZ  PHE A  65      59.417  10.452  52.931  1.00  0.00           C  
ATOM    984  H   PHE A  65      55.968   6.441  54.317  1.00  0.00           H  
ATOM    985  HA  PHE A  65      55.597   7.952  51.764  1.00  0.00           H  
ATOM    986  HB2 PHE A  65      57.649   6.007  52.824  1.00  0.00           H  
ATOM    987  HB3 PHE A  65      57.573   6.433  51.111  1.00  0.00           H  
ATOM    988  HD1 PHE A  65      57.056   9.152  50.857  1.00  0.00           H  
ATOM    989  HD2 PHE A  65      59.259   7.223  54.001  1.00  0.00           H  
ATOM    990  HE1 PHE A  65      58.237  11.277  51.329  1.00  0.00           H  
ATOM    991  HE2 PHE A  65      60.444   9.351  54.472  1.00  0.00           H  
ATOM    992  HZ  PHE A  65      59.932  11.379  53.136  1.00  0.00           H  
ATOM    993  N   GLU A  66      55.151   5.684  50.344  1.00  0.00           N  
ATOM    994  CA  GLU A  66      54.361   4.608  49.678  1.00  0.00           C  
ATOM    995  C   GLU A  66      55.268   3.503  49.134  1.00  0.00           C  
ATOM    996  O   GLU A  66      54.841   2.670  48.360  1.00  0.00           O  
ATOM    997  CB  GLU A  66      53.640   5.312  48.527  1.00  0.00           C  
ATOM    998  CG  GLU A  66      52.131   5.294  48.774  1.00  0.00           C  
ATOM    999  CD  GLU A  66      51.479   4.243  47.874  1.00  0.00           C  
ATOM   1000  OE1 GLU A  66      51.694   3.067  48.119  1.00  0.00           O  
ATOM   1001  OE2 GLU A  66      50.777   4.632  46.955  1.00  0.00           O  
ATOM   1002  H   GLU A  66      55.744   6.257  49.817  1.00  0.00           H  
ATOM   1003  HA  GLU A  66      53.646   4.197  50.362  1.00  0.00           H  
ATOM   1004  HB2 GLU A  66      53.980   6.335  48.463  1.00  0.00           H  
ATOM   1005  HB3 GLU A  66      53.857   4.803  47.601  1.00  0.00           H  
ATOM   1006  HG2 GLU A  66      51.938   5.054  49.808  1.00  0.00           H  
ATOM   1007  HG3 GLU A  66      51.719   6.266  48.546  1.00  0.00           H  
ATOM   1008  N   SER A  67      56.506   3.478  49.528  1.00  0.00           N  
ATOM   1009  CA  SER A  67      57.411   2.405  49.015  1.00  0.00           C  
ATOM   1010  C   SER A  67      58.824   2.544  49.555  1.00  0.00           C  
ATOM   1011  O   SER A  67      59.160   3.467  50.272  1.00  0.00           O  
ATOM   1012  CB  SER A  67      57.437   2.583  47.502  1.00  0.00           C  
ATOM   1013  OG  SER A  67      57.746   3.936  47.194  1.00  0.00           O  
ATOM   1014  H   SER A  67      56.835   4.153  50.155  1.00  0.00           H  
ATOM   1015  HA  SER A  67      57.021   1.434  49.253  1.00  0.00           H  
ATOM   1016  HB2 SER A  67      58.193   1.943  47.077  1.00  0.00           H  
ATOM   1017  HB3 SER A  67      56.477   2.316  47.092  1.00  0.00           H  
ATOM   1018  HG  SER A  67      57.858   4.006  46.243  1.00  0.00           H  
ATOM   1019  N   ALA A  68      59.661   1.635  49.158  1.00  0.00           N  
ATOM   1020  CA  ALA A  68      61.082   1.679  49.569  1.00  0.00           C  
ATOM   1021  C   ALA A  68      61.767   2.737  48.730  1.00  0.00           C  
ATOM   1022  O   ALA A  68      62.798   3.279  49.078  1.00  0.00           O  
ATOM   1023  CB  ALA A  68      61.625   0.304  49.206  1.00  0.00           C  
ATOM   1024  H   ALA A  68      59.355   0.935  48.544  1.00  0.00           H  
ATOM   1025  HA  ALA A  68      61.187   1.875  50.624  1.00  0.00           H  
ATOM   1026  HB1 ALA A  68      62.456   0.418  48.525  1.00  0.00           H  
ATOM   1027  HB2 ALA A  68      60.845  -0.272  48.727  1.00  0.00           H  
ATOM   1028  HB3 ALA A  68      61.954  -0.202  50.097  1.00  0.00           H  
ATOM   1029  N   GLU A  69      61.176   3.020  47.611  1.00  0.00           N  
ATOM   1030  CA  GLU A  69      61.737   4.031  46.695  1.00  0.00           C  
ATOM   1031  C   GLU A  69      61.355   5.427  47.182  1.00  0.00           C  
ATOM   1032  O   GLU A  69      62.064   6.391  46.964  1.00  0.00           O  
ATOM   1033  CB  GLU A  69      61.081   3.700  45.362  1.00  0.00           C  
ATOM   1034  CG  GLU A  69      62.131   3.745  44.256  1.00  0.00           C  
ATOM   1035  CD  GLU A  69      61.787   4.861  43.266  1.00  0.00           C  
ATOM   1036  OE1 GLU A  69      62.139   5.997  43.541  1.00  0.00           O  
ATOM   1037  OE2 GLU A  69      61.179   4.561  42.253  1.00  0.00           O  
ATOM   1038  H   GLU A  69      60.342   2.557  47.369  1.00  0.00           H  
ATOM   1039  HA  GLU A  69      62.807   3.928  46.621  1.00  0.00           H  
ATOM   1040  HB2 GLU A  69      60.656   2.707  45.412  1.00  0.00           H  
ATOM   1041  HB3 GLU A  69      60.302   4.410  45.161  1.00  0.00           H  
ATOM   1042  HG2 GLU A  69      63.100   3.932  44.693  1.00  0.00           H  
ATOM   1043  HG3 GLU A  69      62.145   2.798  43.739  1.00  0.00           H  
ATOM   1044  N   ASP A  70      60.255   5.536  47.879  1.00  0.00           N  
ATOM   1045  CA  ASP A  70      59.850   6.858  48.415  1.00  0.00           C  
ATOM   1046  C   ASP A  70      60.599   7.069  49.720  1.00  0.00           C  
ATOM   1047  O   ASP A  70      60.859   8.179  50.137  1.00  0.00           O  
ATOM   1048  CB  ASP A  70      58.343   6.756  48.664  1.00  0.00           C  
ATOM   1049  CG  ASP A  70      57.620   6.500  47.341  1.00  0.00           C  
ATOM   1050  OD1 ASP A  70      58.150   6.890  46.313  1.00  0.00           O  
ATOM   1051  OD2 ASP A  70      56.548   5.918  47.379  1.00  0.00           O  
ATOM   1052  H   ASP A  70      59.716   4.743  48.078  1.00  0.00           H  
ATOM   1053  HA  ASP A  70      60.069   7.644  47.711  1.00  0.00           H  
ATOM   1054  HB2 ASP A  70      58.146   5.942  49.345  1.00  0.00           H  
ATOM   1055  HB3 ASP A  70      57.986   7.679  49.094  1.00  0.00           H  
ATOM   1056  N   LEU A  71      60.965   5.990  50.354  1.00  0.00           N  
ATOM   1057  CA  LEU A  71      61.718   6.095  51.625  1.00  0.00           C  
ATOM   1058  C   LEU A  71      63.195   6.352  51.316  1.00  0.00           C  
ATOM   1059  O   LEU A  71      63.876   7.065  52.026  1.00  0.00           O  
ATOM   1060  CB  LEU A  71      61.530   4.742  52.315  1.00  0.00           C  
ATOM   1061  CG  LEU A  71      62.230   4.749  53.677  1.00  0.00           C  
ATOM   1062  CD1 LEU A  71      63.743   4.649  53.477  1.00  0.00           C  
ATOM   1063  CD2 LEU A  71      61.898   6.047  54.417  1.00  0.00           C  
ATOM   1064  H   LEU A  71      60.751   5.107  49.984  1.00  0.00           H  
ATOM   1065  HA  LEU A  71      61.310   6.882  52.230  1.00  0.00           H  
ATOM   1066  HB2 LEU A  71      60.475   4.555  52.454  1.00  0.00           H  
ATOM   1067  HB3 LEU A  71      61.954   3.963  51.698  1.00  0.00           H  
ATOM   1068  HG  LEU A  71      61.890   3.905  54.258  1.00  0.00           H  
ATOM   1069 HD11 LEU A  71      64.136   3.850  54.089  1.00  0.00           H  
ATOM   1070 HD12 LEU A  71      64.207   5.582  53.763  1.00  0.00           H  
ATOM   1071 HD13 LEU A  71      63.958   4.444  52.439  1.00  0.00           H  
ATOM   1072 HD21 LEU A  71      62.280   5.994  55.426  1.00  0.00           H  
ATOM   1073 HD22 LEU A  71      60.828   6.183  54.443  1.00  0.00           H  
ATOM   1074 HD23 LEU A  71      62.355   6.881  53.904  1.00  0.00           H  
ATOM   1075  N   GLU A  72      63.688   5.783  50.249  1.00  0.00           N  
ATOM   1076  CA  GLU A  72      65.115   5.998  49.876  1.00  0.00           C  
ATOM   1077  C   GLU A  72      65.292   7.419  49.334  1.00  0.00           C  
ATOM   1078  O   GLU A  72      66.285   8.078  49.587  1.00  0.00           O  
ATOM   1079  CB  GLU A  72      65.402   4.967  48.784  1.00  0.00           C  
ATOM   1080  CG  GLU A  72      66.287   3.854  49.353  1.00  0.00           C  
ATOM   1081  CD  GLU A  72      67.258   3.372  48.274  1.00  0.00           C  
ATOM   1082  OE1 GLU A  72      68.091   4.160  47.860  1.00  0.00           O  
ATOM   1083  OE2 GLU A  72      67.152   2.221  47.881  1.00  0.00           O  
ATOM   1084  H   GLU A  72      63.116   5.220  49.686  1.00  0.00           H  
ATOM   1085  HA  GLU A  72      65.760   5.832  50.724  1.00  0.00           H  
ATOM   1086  HB2 GLU A  72      64.471   4.544  48.435  1.00  0.00           H  
ATOM   1087  HB3 GLU A  72      65.913   5.444  47.962  1.00  0.00           H  
ATOM   1088  HG2 GLU A  72      66.844   4.234  50.197  1.00  0.00           H  
ATOM   1089  HG3 GLU A  72      65.668   3.030  49.672  1.00  0.00           H  
ATOM   1090  N   LYS A  73      64.316   7.912  48.621  1.00  0.00           N  
ATOM   1091  CA  LYS A  73      64.416   9.293  48.102  1.00  0.00           C  
ATOM   1092  C   LYS A  73      64.140  10.222  49.265  1.00  0.00           C  
ATOM   1093  O   LYS A  73      64.624  11.335  49.330  1.00  0.00           O  
ATOM   1094  CB  LYS A  73      63.326   9.407  47.035  1.00  0.00           C  
ATOM   1095  CG  LYS A  73      63.641   8.455  45.880  1.00  0.00           C  
ATOM   1096  CD  LYS A  73      64.264   9.240  44.724  1.00  0.00           C  
ATOM   1097  CE  LYS A  73      63.232   9.406  43.606  1.00  0.00           C  
ATOM   1098  NZ  LYS A  73      63.375   8.185  42.766  1.00  0.00           N  
ATOM   1099  H   LYS A  73      63.507   7.389  48.459  1.00  0.00           H  
ATOM   1100  HA  LYS A  73      65.390   9.479  47.678  1.00  0.00           H  
ATOM   1101  HB2 LYS A  73      62.371   9.145  47.467  1.00  0.00           H  
ATOM   1102  HB3 LYS A  73      63.288  10.420  46.663  1.00  0.00           H  
ATOM   1103  HG2 LYS A  73      64.336   7.698  46.217  1.00  0.00           H  
ATOM   1104  HG3 LYS A  73      62.731   7.982  45.543  1.00  0.00           H  
ATOM   1105  HD2 LYS A  73      64.574  10.214  45.077  1.00  0.00           H  
ATOM   1106  HD3 LYS A  73      65.120   8.704  44.344  1.00  0.00           H  
ATOM   1107  HE2 LYS A  73      62.235   9.466  44.022  1.00  0.00           H  
ATOM   1108  HE3 LYS A  73      63.450  10.286  43.020  1.00  0.00           H  
ATOM   1109  HZ1 LYS A  73      62.527   8.070  42.175  1.00  0.00           H  
ATOM   1110  HZ2 LYS A  73      63.486   7.353  43.382  1.00  0.00           H  
ATOM   1111  HZ3 LYS A  73      64.210   8.280  42.155  1.00  0.00           H  
ATOM   1112  N   ALA A  74      63.378   9.745  50.208  1.00  0.00           N  
ATOM   1113  CA  ALA A  74      63.080  10.567  51.395  1.00  0.00           C  
ATOM   1114  C   ALA A  74      64.365  10.741  52.199  1.00  0.00           C  
ATOM   1115  O   ALA A  74      64.577  11.743  52.852  1.00  0.00           O  
ATOM   1116  CB  ALA A  74      62.041   9.779  52.188  1.00  0.00           C  
ATOM   1117  H   ALA A  74      63.020   8.835  50.139  1.00  0.00           H  
ATOM   1118  HA  ALA A  74      62.683  11.513  51.090  1.00  0.00           H  
ATOM   1119  HB1 ALA A  74      62.441   8.810  52.443  1.00  0.00           H  
ATOM   1120  HB2 ALA A  74      61.152   9.656  51.589  1.00  0.00           H  
ATOM   1121  HB3 ALA A  74      61.795  10.317  53.091  1.00  0.00           H  
ATOM   1122  N   LEU A  75      65.240   9.773  52.124  1.00  0.00           N  
ATOM   1123  CA  LEU A  75      66.529   9.874  52.846  1.00  0.00           C  
ATOM   1124  C   LEU A  75      67.381  10.921  52.144  1.00  0.00           C  
ATOM   1125  O   LEU A  75      67.955  11.794  52.764  1.00  0.00           O  
ATOM   1126  CB  LEU A  75      67.159   8.487  52.723  1.00  0.00           C  
ATOM   1127  CG  LEU A  75      68.071   8.228  53.919  1.00  0.00           C  
ATOM   1128  CD1 LEU A  75      69.265   9.183  53.866  1.00  0.00           C  
ATOM   1129  CD2 LEU A  75      67.292   8.455  55.215  1.00  0.00           C  
ATOM   1130  H   LEU A  75      65.056   8.987  51.571  1.00  0.00           H  
ATOM   1131  HA  LEU A  75      66.373  10.131  53.882  1.00  0.00           H  
ATOM   1132  HB2 LEU A  75      66.378   7.740  52.697  1.00  0.00           H  
ATOM   1133  HB3 LEU A  75      67.737   8.435  51.813  1.00  0.00           H  
ATOM   1134  HG  LEU A  75      68.423   7.209  53.881  1.00  0.00           H  
ATOM   1135 HD11 LEU A  75      69.247   9.731  52.934  1.00  0.00           H  
ATOM   1136 HD12 LEU A  75      70.182   8.617  53.933  1.00  0.00           H  
ATOM   1137 HD13 LEU A  75      69.208   9.877  54.692  1.00  0.00           H  
ATOM   1138 HD21 LEU A  75      67.579   7.711  55.943  1.00  0.00           H  
ATOM   1139 HD22 LEU A  75      66.233   8.375  55.017  1.00  0.00           H  
ATOM   1140 HD23 LEU A  75      67.513   9.439  55.601  1.00  0.00           H  
ATOM   1141  N   GLU A  76      67.442  10.856  50.841  1.00  0.00           N  
ATOM   1142  CA  GLU A  76      68.228  11.863  50.092  1.00  0.00           C  
ATOM   1143  C   GLU A  76      67.448  13.176  50.046  1.00  0.00           C  
ATOM   1144  O   GLU A  76      67.925  14.178  49.549  1.00  0.00           O  
ATOM   1145  CB  GLU A  76      68.373  11.292  48.690  1.00  0.00           C  
ATOM   1146  CG  GLU A  76      69.789  10.747  48.498  1.00  0.00           C  
ATOM   1147  CD  GLU A  76      69.878  10.016  47.158  1.00  0.00           C  
ATOM   1148  OE1 GLU A  76      68.894   9.406  46.772  1.00  0.00           O  
ATOM   1149  OE2 GLU A  76      70.929  10.079  46.540  1.00  0.00           O  
ATOM   1150  H   GLU A  76      66.954  10.152  50.355  1.00  0.00           H  
ATOM   1151  HA  GLU A  76      69.194  12.003  50.544  1.00  0.00           H  
ATOM   1152  HB2 GLU A  76      67.655  10.500  48.553  1.00  0.00           H  
ATOM   1153  HB3 GLU A  76      68.187  12.074  47.973  1.00  0.00           H  
ATOM   1154  HG2 GLU A  76      70.494  11.566  48.511  1.00  0.00           H  
ATOM   1155  HG3 GLU A  76      70.020  10.060  49.297  1.00  0.00           H  
ATOM   1156  N   LEU A  77      66.247  13.177  50.564  1.00  0.00           N  
ATOM   1157  CA  LEU A  77      65.431  14.421  50.556  1.00  0.00           C  
ATOM   1158  C   LEU A  77      65.903  15.374  51.657  1.00  0.00           C  
ATOM   1159  O   LEU A  77      65.251  16.352  51.962  1.00  0.00           O  
ATOM   1160  CB  LEU A  77      63.997  13.959  50.826  1.00  0.00           C  
ATOM   1161  CG  LEU A  77      63.098  14.332  49.643  1.00  0.00           C  
ATOM   1162  CD1 LEU A  77      63.355  15.783  49.231  1.00  0.00           C  
ATOM   1163  CD2 LEU A  77      63.399  13.408  48.462  1.00  0.00           C  
ATOM   1164  H   LEU A  77      65.884  12.358  50.960  1.00  0.00           H  
ATOM   1165  HA  LEU A  77      65.487  14.901  49.592  1.00  0.00           H  
ATOM   1166  HB2 LEU A  77      63.986  12.887  50.962  1.00  0.00           H  
ATOM   1167  HB3 LEU A  77      63.629  14.438  51.720  1.00  0.00           H  
ATOM   1168  HG  LEU A  77      62.063  14.222  49.932  1.00  0.00           H  
ATOM   1169 HD11 LEU A  77      62.441  16.350  49.323  1.00  0.00           H  
ATOM   1170 HD12 LEU A  77      63.695  15.811  48.206  1.00  0.00           H  
ATOM   1171 HD13 LEU A  77      64.110  16.213  49.872  1.00  0.00           H  
ATOM   1172 HD21 LEU A  77      64.462  13.223  48.410  1.00  0.00           H  
ATOM   1173 HD22 LEU A  77      63.071  13.875  47.545  1.00  0.00           H  
ATOM   1174 HD23 LEU A  77      62.877  12.471  48.595  1.00  0.00           H  
ATOM   1175  N   THR A  78      67.040  15.108  52.253  1.00  0.00           N  
ATOM   1176  CA  THR A  78      67.544  16.014  53.320  1.00  0.00           C  
ATOM   1177  C   THR A  78      67.831  17.393  52.742  1.00  0.00           C  
ATOM   1178  O   THR A  78      68.078  18.345  53.456  1.00  0.00           O  
ATOM   1179  CB  THR A  78      68.825  15.360  53.841  1.00  0.00           C  
ATOM   1180  OG1 THR A  78      68.729  13.950  53.693  1.00  0.00           O  
ATOM   1181  CG2 THR A  78      69.015  15.709  55.318  1.00  0.00           C  
ATOM   1182  H   THR A  78      67.559  14.322  51.997  1.00  0.00           H  
ATOM   1183  HA  THR A  78      66.823  16.092  54.099  1.00  0.00           H  
ATOM   1184  HB  THR A  78      69.671  15.725  53.278  1.00  0.00           H  
ATOM   1185  HG1 THR A  78      69.353  13.680  53.016  1.00  0.00           H  
ATOM   1186 HG21 THR A  78      68.506  14.978  55.929  1.00  0.00           H  
ATOM   1187 HG22 THR A  78      68.605  16.689  55.511  1.00  0.00           H  
ATOM   1188 HG23 THR A  78      70.068  15.707  55.556  1.00  0.00           H  
ATOM   1189  N   GLY A  79      67.782  17.506  51.453  1.00  0.00           N  
ATOM   1190  CA  GLY A  79      68.031  18.825  50.806  1.00  0.00           C  
ATOM   1191  C   GLY A  79      66.710  19.596  50.711  1.00  0.00           C  
ATOM   1192  O   GLY A  79      66.474  20.332  49.772  1.00  0.00           O  
ATOM   1193  H   GLY A  79      67.570  16.720  50.911  1.00  0.00           H  
ATOM   1194  HA2 GLY A  79      68.739  19.389  51.396  1.00  0.00           H  
ATOM   1195  HA3 GLY A  79      68.428  18.672  49.813  1.00  0.00           H  
ATOM   1196  N   LEU A  80      65.846  19.429  51.677  1.00  0.00           N  
ATOM   1197  CA  LEU A  80      64.537  20.143  51.652  1.00  0.00           C  
ATOM   1198  C   LEU A  80      64.679  21.541  52.252  1.00  0.00           C  
ATOM   1199  O   LEU A  80      65.769  22.010  52.513  1.00  0.00           O  
ATOM   1200  CB  LEU A  80      63.611  19.289  52.521  1.00  0.00           C  
ATOM   1201  CG  LEU A  80      62.717  18.427  51.629  1.00  0.00           C  
ATOM   1202  CD1 LEU A  80      62.677  17.000  52.176  1.00  0.00           C  
ATOM   1203  CD2 LEU A  80      61.301  19.008  51.620  1.00  0.00           C  
ATOM   1204  H   LEU A  80      66.057  18.831  52.421  1.00  0.00           H  
ATOM   1205  HA  LEU A  80      64.150  20.200  50.649  1.00  0.00           H  
ATOM   1206  HB2 LEU A  80      64.205  18.651  53.159  1.00  0.00           H  
ATOM   1207  HB3 LEU A  80      62.994  19.933  53.130  1.00  0.00           H  
ATOM   1208  HG  LEU A  80      63.112  18.417  50.624  1.00  0.00           H  
ATOM   1209 HD11 LEU A  80      61.651  16.681  52.279  1.00  0.00           H  
ATOM   1210 HD12 LEU A  80      63.162  16.971  53.141  1.00  0.00           H  
ATOM   1211 HD13 LEU A  80      63.192  16.339  51.496  1.00  0.00           H  
ATOM   1212 HD21 LEU A  80      60.776  18.693  52.509  1.00  0.00           H  
ATOM   1213 HD22 LEU A  80      60.772  18.656  50.746  1.00  0.00           H  
ATOM   1214 HD23 LEU A  80      61.354  20.087  51.597  1.00  0.00           H  
ATOM   1215  N   LYS A  81      63.580  22.204  52.477  1.00  0.00           N  
ATOM   1216  CA  LYS A  81      63.632  23.573  53.067  1.00  0.00           C  
ATOM   1217  C   LYS A  81      62.227  24.110  53.246  1.00  0.00           C  
ATOM   1218  O   LYS A  81      61.907  25.223  52.879  1.00  0.00           O  
ATOM   1219  CB  LYS A  81      64.376  24.412  52.059  1.00  0.00           C  
ATOM   1220  CG  LYS A  81      65.734  24.834  52.627  1.00  0.00           C  
ATOM   1221  CD  LYS A  81      66.605  25.399  51.504  1.00  0.00           C  
ATOM   1222  CE  LYS A  81      68.071  25.052  51.770  1.00  0.00           C  
ATOM   1223  NZ  LYS A  81      68.538  24.374  50.529  1.00  0.00           N  
ATOM   1224  H   LYS A  81      62.716  21.798  52.258  1.00  0.00           H  
ATOM   1225  HA  LYS A  81      64.149  23.559  54.005  1.00  0.00           H  
ATOM   1226  HB2 LYS A  81      64.515  23.829  51.168  1.00  0.00           H  
ATOM   1227  HB3 LYS A  81      63.790  25.286  51.834  1.00  0.00           H  
ATOM   1228  HG2 LYS A  81      65.586  25.590  53.385  1.00  0.00           H  
ATOM   1229  HG3 LYS A  81      66.224  23.978  53.065  1.00  0.00           H  
ATOM   1230  HD2 LYS A  81      66.298  24.971  50.561  1.00  0.00           H  
ATOM   1231  HD3 LYS A  81      66.493  26.472  51.465  1.00  0.00           H  
ATOM   1232  HE2 LYS A  81      68.643  25.953  51.948  1.00  0.00           H  
ATOM   1233  HE3 LYS A  81      68.153  24.382  52.611  1.00  0.00           H  
ATOM   1234  HZ1 LYS A  81      68.064  24.795  49.705  1.00  0.00           H  
ATOM   1235  HZ2 LYS A  81      68.309  23.361  50.582  1.00  0.00           H  
ATOM   1236  HZ3 LYS A  81      69.566  24.494  50.433  1.00  0.00           H  
ATOM   1237  N   VAL A  82      61.400  23.309  53.806  1.00  0.00           N  
ATOM   1238  CA  VAL A  82      59.985  23.716  54.037  1.00  0.00           C  
ATOM   1239  C   VAL A  82      59.930  25.170  54.510  1.00  0.00           C  
ATOM   1240  O   VAL A  82      60.604  25.553  55.445  1.00  0.00           O  
ATOM   1241  CB  VAL A  82      59.468  22.777  55.125  1.00  0.00           C  
ATOM   1242  CG1 VAL A  82      58.142  23.309  55.670  1.00  0.00           C  
ATOM   1243  CG2 VAL A  82      59.253  21.383  54.532  1.00  0.00           C  
ATOM   1244  H   VAL A  82      61.722  22.429  54.074  1.00  0.00           H  
ATOM   1245  HA  VAL A  82      59.405  23.591  53.136  1.00  0.00           H  
ATOM   1246  HB  VAL A  82      60.191  22.724  55.926  1.00  0.00           H  
ATOM   1247 HG11 VAL A  82      58.323  24.203  56.247  1.00  0.00           H  
ATOM   1248 HG12 VAL A  82      57.685  22.560  56.299  1.00  0.00           H  
ATOM   1249 HG13 VAL A  82      57.481  23.539  54.847  1.00  0.00           H  
ATOM   1250 HG21 VAL A  82      58.867  21.475  53.527  1.00  0.00           H  
ATOM   1251 HG22 VAL A  82      58.547  20.838  55.140  1.00  0.00           H  
ATOM   1252 HG23 VAL A  82      60.192  20.852  54.508  1.00  0.00           H  
ATOM   1253  N   PHE A  83      59.138  25.984  53.869  1.00  0.00           N  
ATOM   1254  CA  PHE A  83      59.051  27.414  54.281  1.00  0.00           C  
ATOM   1255  C   PHE A  83      60.452  27.972  54.550  1.00  0.00           C  
ATOM   1256  O   PHE A  83      60.625  28.907  55.306  1.00  0.00           O  
ATOM   1257  CB  PHE A  83      58.214  27.410  55.560  1.00  0.00           C  
ATOM   1258  CG  PHE A  83      56.758  27.595  55.203  1.00  0.00           C  
ATOM   1259  CD1 PHE A  83      56.281  28.863  54.846  1.00  0.00           C  
ATOM   1260  CD2 PHE A  83      55.887  26.500  55.223  1.00  0.00           C  
ATOM   1261  CE1 PHE A  83      54.934  29.035  54.510  1.00  0.00           C  
ATOM   1262  CE2 PHE A  83      54.539  26.673  54.887  1.00  0.00           C  
ATOM   1263  CZ  PHE A  83      54.062  27.939  54.531  1.00  0.00           C  
ATOM   1264  H   PHE A  83      58.604  25.657  53.116  1.00  0.00           H  
ATOM   1265  HA  PHE A  83      58.556  27.994  53.519  1.00  0.00           H  
ATOM   1266  HB2 PHE A  83      58.343  26.469  56.073  1.00  0.00           H  
ATOM   1267  HB3 PHE A  83      58.532  28.218  56.202  1.00  0.00           H  
ATOM   1268  HD1 PHE A  83      56.954  29.708  54.831  1.00  0.00           H  
ATOM   1269  HD2 PHE A  83      56.253  25.522  55.497  1.00  0.00           H  
ATOM   1270  HE1 PHE A  83      54.567  30.012  54.235  1.00  0.00           H  
ATOM   1271  HE2 PHE A  83      53.867  25.829  54.903  1.00  0.00           H  
ATOM   1272  HZ  PHE A  83      53.023  28.072  54.271  1.00  0.00           H  
ATOM   1273  N   GLY A  84      61.455  27.406  53.932  1.00  0.00           N  
ATOM   1274  CA  GLY A  84      62.845  27.903  54.145  1.00  0.00           C  
ATOM   1275  C   GLY A  84      63.494  27.147  55.306  1.00  0.00           C  
ATOM   1276  O   GLY A  84      64.457  27.601  55.893  1.00  0.00           O  
ATOM   1277  H   GLY A  84      61.293  26.656  53.323  1.00  0.00           H  
ATOM   1278  HA2 GLY A  84      63.423  27.746  53.245  1.00  0.00           H  
ATOM   1279  HA3 GLY A  84      62.820  28.955  54.374  1.00  0.00           H  
ATOM   1280  N   ASN A  85      62.981  25.995  55.637  1.00  0.00           N  
ATOM   1281  CA  ASN A  85      63.574  25.204  56.755  1.00  0.00           C  
ATOM   1282  C   ASN A  85      63.777  23.758  56.306  1.00  0.00           C  
ATOM   1283  O   ASN A  85      62.844  22.982  56.236  1.00  0.00           O  
ATOM   1284  CB  ASN A  85      62.549  25.277  57.889  1.00  0.00           C  
ATOM   1285  CG  ASN A  85      62.427  26.722  58.375  1.00  0.00           C  
ATOM   1286  OD1 ASN A  85      62.981  27.625  57.780  1.00  0.00           O  
ATOM   1287  ND2 ASN A  85      61.722  26.982  59.442  1.00  0.00           N  
ATOM   1288  H   ASN A  85      62.209  25.644  55.145  1.00  0.00           H  
ATOM   1289  HA  ASN A  85      64.509  25.638  57.070  1.00  0.00           H  
ATOM   1290  HB2 ASN A  85      61.590  24.935  57.531  1.00  0.00           H  
ATOM   1291  HB3 ASN A  85      62.874  24.651  58.707  1.00  0.00           H  
ATOM   1292 HD21 ASN A  85      61.276  26.254  59.923  1.00  0.00           H  
ATOM   1293 HD22 ASN A  85      61.638  27.905  59.762  1.00  0.00           H  
ATOM   1294  N   GLU A  86      64.986  23.391  55.986  1.00  0.00           N  
ATOM   1295  CA  GLU A  86      65.237  21.997  55.527  1.00  0.00           C  
ATOM   1296  C   GLU A  86      64.687  20.999  56.543  1.00  0.00           C  
ATOM   1297  O   GLU A  86      65.353  20.627  57.488  1.00  0.00           O  
ATOM   1298  CB  GLU A  86      66.754  21.878  55.416  1.00  0.00           C  
ATOM   1299  CG  GLU A  86      67.388  22.095  56.791  1.00  0.00           C  
ATOM   1300  CD  GLU A  86      68.368  23.268  56.723  1.00  0.00           C  
ATOM   1301  OE1 GLU A  86      69.022  23.410  55.703  1.00  0.00           O  
ATOM   1302  OE2 GLU A  86      68.448  24.005  57.692  1.00  0.00           O  
ATOM   1303  H   GLU A  86      65.725  24.032  56.038  1.00  0.00           H  
ATOM   1304  HA  GLU A  86      64.784  21.835  54.563  1.00  0.00           H  
ATOM   1305  HB2 GLU A  86      67.009  20.894  55.051  1.00  0.00           H  
ATOM   1306  HB3 GLU A  86      67.121  22.625  54.728  1.00  0.00           H  
ATOM   1307  HG2 GLU A  86      66.614  22.313  57.513  1.00  0.00           H  
ATOM   1308  HG3 GLU A  86      67.917  21.203  57.089  1.00  0.00           H  
ATOM   1309  N   ILE A  87      63.473  20.563  56.355  1.00  0.00           N  
ATOM   1310  CA  ILE A  87      62.879  19.590  57.308  1.00  0.00           C  
ATOM   1311  C   ILE A  87      63.863  18.458  57.583  1.00  0.00           C  
ATOM   1312  O   ILE A  87      64.571  18.004  56.706  1.00  0.00           O  
ATOM   1313  CB  ILE A  87      61.628  19.050  56.616  1.00  0.00           C  
ATOM   1314  CG1 ILE A  87      61.940  18.748  55.150  1.00  0.00           C  
ATOM   1315  CG2 ILE A  87      60.511  20.089  56.699  1.00  0.00           C  
ATOM   1316  CD1 ILE A  87      61.414  17.356  54.795  1.00  0.00           C  
ATOM   1317  H   ILE A  87      62.954  20.876  55.588  1.00  0.00           H  
ATOM   1318  HA  ILE A  87      62.605  20.083  58.227  1.00  0.00           H  
ATOM   1319  HB  ILE A  87      61.310  18.143  57.112  1.00  0.00           H  
ATOM   1320 HG12 ILE A  87      61.465  19.486  54.521  1.00  0.00           H  
ATOM   1321 HG13 ILE A  87      63.009  18.777  54.996  1.00  0.00           H  
ATOM   1322 HG21 ILE A  87      60.848  21.013  56.254  1.00  0.00           H  
ATOM   1323 HG22 ILE A  87      60.253  20.259  57.734  1.00  0.00           H  
ATOM   1324 HG23 ILE A  87      59.643  19.727  56.167  1.00  0.00           H  
ATOM   1325 HD11 ILE A  87      60.721  17.030  55.556  1.00  0.00           H  
ATOM   1326 HD12 ILE A  87      62.240  16.662  54.740  1.00  0.00           H  
ATOM   1327 HD13 ILE A  87      60.911  17.394  53.841  1.00  0.00           H  
ATOM   1328  N   LYS A  88      63.901  17.996  58.794  1.00  0.00           N  
ATOM   1329  CA  LYS A  88      64.824  16.886  59.144  1.00  0.00           C  
ATOM   1330  C   LYS A  88      64.014  15.613  59.368  1.00  0.00           C  
ATOM   1331  O   LYS A  88      62.812  15.657  59.533  1.00  0.00           O  
ATOM   1332  CB  LYS A  88      65.509  17.326  60.438  1.00  0.00           C  
ATOM   1333  CG  LYS A  88      66.440  18.505  60.148  1.00  0.00           C  
ATOM   1334  CD  LYS A  88      67.888  18.012  60.104  1.00  0.00           C  
ATOM   1335  CE  LYS A  88      68.401  18.058  58.663  1.00  0.00           C  
ATOM   1336  NZ  LYS A  88      69.173  16.797  58.491  1.00  0.00           N  
ATOM   1337  H   LYS A  88      63.312  18.374  59.475  1.00  0.00           H  
ATOM   1338  HA  LYS A  88      65.556  16.740  58.365  1.00  0.00           H  
ATOM   1339  HB2 LYS A  88      64.759  17.626  61.157  1.00  0.00           H  
ATOM   1340  HB3 LYS A  88      66.084  16.505  60.839  1.00  0.00           H  
ATOM   1341  HG2 LYS A  88      66.179  18.944  59.196  1.00  0.00           H  
ATOM   1342  HG3 LYS A  88      66.337  19.245  60.927  1.00  0.00           H  
ATOM   1343  HD2 LYS A  88      68.502  18.647  60.726  1.00  0.00           H  
ATOM   1344  HD3 LYS A  88      67.934  16.997  60.468  1.00  0.00           H  
ATOM   1345  HE2 LYS A  88      67.570  18.092  57.970  1.00  0.00           H  
ATOM   1346  HE3 LYS A  88      69.047  18.910  58.520  1.00  0.00           H  
ATOM   1347  HZ1 LYS A  88      68.598  15.991  58.809  1.00  0.00           H  
ATOM   1348  HZ2 LYS A  88      70.046  16.845  59.054  1.00  0.00           H  
ATOM   1349  HZ3 LYS A  88      69.414  16.671  57.487  1.00  0.00           H  
ATOM   1350  N   LEU A  89      64.652  14.480  59.367  1.00  0.00           N  
ATOM   1351  CA  LEU A  89      63.909  13.212  59.573  1.00  0.00           C  
ATOM   1352  C   LEU A  89      64.350  12.540  60.872  1.00  0.00           C  
ATOM   1353  O   LEU A  89      65.191  13.039  61.592  1.00  0.00           O  
ATOM   1354  CB  LEU A  89      64.283  12.351  58.373  1.00  0.00           C  
ATOM   1355  CG  LEU A  89      63.411  12.728  57.174  1.00  0.00           C  
ATOM   1356  CD1 LEU A  89      64.288  13.334  56.077  1.00  0.00           C  
ATOM   1357  CD2 LEU A  89      62.718  11.474  56.635  1.00  0.00           C  
ATOM   1358  H   LEU A  89      65.617  14.460  59.224  1.00  0.00           H  
ATOM   1359  HA  LEU A  89      62.845  13.391  59.584  1.00  0.00           H  
ATOM   1360  HB2 LEU A  89      65.321  12.511  58.129  1.00  0.00           H  
ATOM   1361  HB3 LEU A  89      64.129  11.316  58.618  1.00  0.00           H  
ATOM   1362  HG  LEU A  89      62.670  13.449  57.481  1.00  0.00           H  
ATOM   1363 HD11 LEU A  89      64.120  14.400  56.030  1.00  0.00           H  
ATOM   1364 HD12 LEU A  89      64.036  12.888  55.126  1.00  0.00           H  
ATOM   1365 HD13 LEU A  89      65.328  13.143  56.299  1.00  0.00           H  
ATOM   1366 HD21 LEU A  89      61.727  11.731  56.292  1.00  0.00           H  
ATOM   1367 HD22 LEU A  89      62.647  10.737  57.421  1.00  0.00           H  
ATOM   1368 HD23 LEU A  89      63.290  11.071  55.813  1.00  0.00           H  
ATOM   1369  N   GLU A  90      63.784  11.407  61.170  1.00  0.00           N  
ATOM   1370  CA  GLU A  90      64.160  10.686  62.420  1.00  0.00           C  
ATOM   1371  C   GLU A  90      63.506   9.303  62.449  1.00  0.00           C  
ATOM   1372  O   GLU A  90      62.478   9.080  61.841  1.00  0.00           O  
ATOM   1373  CB  GLU A  90      63.624  11.557  63.556  1.00  0.00           C  
ATOM   1374  CG  GLU A  90      64.785  12.023  64.436  1.00  0.00           C  
ATOM   1375  CD  GLU A  90      64.310  12.147  65.885  1.00  0.00           C  
ATOM   1376  OE1 GLU A  90      63.887  11.145  66.438  1.00  0.00           O  
ATOM   1377  OE2 GLU A  90      64.376  13.243  66.418  1.00  0.00           O  
ATOM   1378  H   GLU A  90      63.110  11.030  60.568  1.00  0.00           H  
ATOM   1379  HA  GLU A  90      65.233  10.599  62.497  1.00  0.00           H  
ATOM   1380  HB2 GLU A  90      63.117  12.416  63.142  1.00  0.00           H  
ATOM   1381  HB3 GLU A  90      62.931  10.983  64.153  1.00  0.00           H  
ATOM   1382  HG2 GLU A  90      65.589  11.303  64.381  1.00  0.00           H  
ATOM   1383  HG3 GLU A  90      65.135  12.983  64.091  1.00  0.00           H  
ATOM   1384  N   LYS A  91      64.093   8.371  63.149  1.00  0.00           N  
ATOM   1385  CA  LYS A  91      63.503   7.003  63.215  1.00  0.00           C  
ATOM   1386  C   LYS A  91      62.774   6.804  64.547  1.00  0.00           C  
ATOM   1387  O   LYS A  91      63.389   6.517  65.555  1.00  0.00           O  
ATOM   1388  CB  LYS A  91      64.694   6.051  63.107  1.00  0.00           C  
ATOM   1389  CG  LYS A  91      65.098   5.906  61.638  1.00  0.00           C  
ATOM   1390  CD  LYS A  91      66.072   4.734  61.489  1.00  0.00           C  
ATOM   1391  CE  LYS A  91      66.979   4.974  60.279  1.00  0.00           C  
ATOM   1392  NZ  LYS A  91      67.853   3.770  60.209  1.00  0.00           N  
ATOM   1393  H   LYS A  91      64.922   8.571  63.633  1.00  0.00           H  
ATOM   1394  HA  LYS A  91      62.828   6.844  62.389  1.00  0.00           H  
ATOM   1395  HB2 LYS A  91      65.525   6.449  63.672  1.00  0.00           H  
ATOM   1396  HB3 LYS A  91      64.420   5.085  63.500  1.00  0.00           H  
ATOM   1397  HG2 LYS A  91      64.217   5.721  61.039  1.00  0.00           H  
ATOM   1398  HG3 LYS A  91      65.577   6.813  61.304  1.00  0.00           H  
ATOM   1399  HD2 LYS A  91      66.675   4.652  62.381  1.00  0.00           H  
ATOM   1400  HD3 LYS A  91      65.516   3.820  61.343  1.00  0.00           H  
ATOM   1401  HE2 LYS A  91      66.386   5.065  59.379  1.00  0.00           H  
ATOM   1402  HE3 LYS A  91      67.579   5.858  60.427  1.00  0.00           H  
ATOM   1403  HZ1 LYS A  91      68.359   3.656  61.110  1.00  0.00           H  
ATOM   1404  HZ2 LYS A  91      68.541   3.887  59.436  1.00  0.00           H  
ATOM   1405  HZ3 LYS A  91      67.270   2.928  60.032  1.00  0.00           H  
ATOM   1406  N   PRO A  92      61.479   6.964  64.502  1.00  0.00           N  
ATOM   1407  CA  PRO A  92      60.647   6.800  65.719  1.00  0.00           C  
ATOM   1408  C   PRO A  92      60.541   5.320  66.100  1.00  0.00           C  
ATOM   1409  O   PRO A  92      61.177   4.469  65.509  1.00  0.00           O  
ATOM   1410  CB  PRO A  92      59.287   7.352  65.299  1.00  0.00           C  
ATOM   1411  CG  PRO A  92      59.254   7.208  63.810  1.00  0.00           C  
ATOM   1412  CD  PRO A  92      60.677   7.308  63.324  1.00  0.00           C  
ATOM   1413  HA  PRO A  92      61.045   7.378  66.536  1.00  0.00           H  
ATOM   1414  HB2 PRO A  92      58.493   6.777  65.753  1.00  0.00           H  
ATOM   1415  HB3 PRO A  92      59.203   8.393  65.571  1.00  0.00           H  
ATOM   1416  HG2 PRO A  92      58.836   6.248  63.543  1.00  0.00           H  
ATOM   1417  HG3 PRO A  92      58.666   8.002  63.376  1.00  0.00           H  
ATOM   1418  HD3 PRO A  92      60.851   6.602  62.522  1.00  0.00           H  
ATOM   1419  HD2 PRO A  92      60.899   8.312  63.003  1.00  0.00           H  
ATOM   1420  N   LYS A  93      59.743   5.006  67.085  1.00  0.00           N  
ATOM   1421  CA  LYS A  93      59.599   3.582  67.503  1.00  0.00           C  
ATOM   1422  C   LYS A  93      58.804   2.799  66.455  1.00  0.00           C  
ATOM   1423  O   LYS A  93      58.030   3.359  65.703  1.00  0.00           O  
ATOM   1424  CB  LYS A  93      58.834   3.633  68.826  1.00  0.00           C  
ATOM   1425  CG  LYS A  93      57.385   4.047  68.564  1.00  0.00           C  
ATOM   1426  CD  LYS A  93      56.678   4.305  69.895  1.00  0.00           C  
ATOM   1427  CE  LYS A  93      57.154   5.639  70.476  1.00  0.00           C  
ATOM   1428  NZ  LYS A  93      56.152   5.982  71.522  1.00  0.00           N  
ATOM   1429  H   LYS A  93      59.239   5.707  67.549  1.00  0.00           H  
ATOM   1430  HA  LYS A  93      60.567   3.133  67.654  1.00  0.00           H  
ATOM   1431  HB2 LYS A  93      58.854   2.658  69.291  1.00  0.00           H  
ATOM   1432  HB3 LYS A  93      59.299   4.354  69.482  1.00  0.00           H  
ATOM   1433  HG2 LYS A  93      57.369   4.946  67.966  1.00  0.00           H  
ATOM   1434  HG3 LYS A  93      56.875   3.255  68.036  1.00  0.00           H  
ATOM   1435  HD2 LYS A  93      55.610   4.342  69.735  1.00  0.00           H  
ATOM   1436  HD3 LYS A  93      56.912   3.510  70.587  1.00  0.00           H  
ATOM   1437  HE2 LYS A  93      58.137   5.527  70.914  1.00  0.00           H  
ATOM   1438  HE3 LYS A  93      57.166   6.399  69.711  1.00  0.00           H  
ATOM   1439  HZ1 LYS A  93      55.219   5.616  71.243  1.00  0.00           H  
ATOM   1440  HZ2 LYS A  93      56.101   7.016  71.627  1.00  0.00           H  
ATOM   1441  HZ3 LYS A  93      56.433   5.554  72.426  1.00  0.00           H  
ATOM   1442  N   GLY A  94      58.988   1.508  66.399  1.00  0.00           N  
ATOM   1443  CA  GLY A  94      58.242   0.691  65.400  1.00  0.00           C  
ATOM   1444  C   GLY A  94      59.038   0.625  64.096  1.00  0.00           C  
ATOM   1445  O   GLY A  94      58.487   0.430  63.030  1.00  0.00           O  
ATOM   1446  H   GLY A  94      59.617   1.076  67.015  1.00  0.00           H  
ATOM   1447  HA2 GLY A  94      58.100  -0.308  65.788  1.00  0.00           H  
ATOM   1448  HA3 GLY A  94      57.282   1.144  65.208  1.00  0.00           H  
ATOM   1449  N   ARG A  95      60.332   0.787  64.169  1.00  0.00           N  
ATOM   1450  CA  ARG A  95      61.161   0.732  62.932  1.00  0.00           C  
ATOM   1451  C   ARG A  95      60.706  -0.427  62.041  1.00  0.00           C  
ATOM   1452  O   ARG A  95      60.554  -0.280  60.845  1.00  0.00           O  
ATOM   1453  CB  ARG A  95      62.591   0.502  63.423  1.00  0.00           C  
ATOM   1454  CG  ARG A  95      63.226   1.844  63.789  1.00  0.00           C  
ATOM   1455  CD  ARG A  95      63.586   1.851  65.277  1.00  0.00           C  
ATOM   1456  NE  ARG A  95      64.972   1.311  65.340  1.00  0.00           N  
ATOM   1457  CZ  ARG A  95      65.732   1.581  66.366  1.00  0.00           C  
ATOM   1458  NH1 ARG A  95      65.194   1.949  67.496  1.00  0.00           N  
ATOM   1459  NH2 ARG A  95      67.029   1.483  66.261  1.00  0.00           N  
ATOM   1460  H   ARG A  95      60.757   0.943  65.038  1.00  0.00           H  
ATOM   1461  HA  ARG A  95      61.102   1.666  62.396  1.00  0.00           H  
ATOM   1462  HB2 ARG A  95      62.573  -0.139  64.293  1.00  0.00           H  
ATOM   1463  HB3 ARG A  95      63.169   0.034  62.641  1.00  0.00           H  
ATOM   1464  HG2 ARG A  95      64.121   1.991  63.202  1.00  0.00           H  
ATOM   1465  HG3 ARG A  95      62.528   2.642  63.587  1.00  0.00           H  
ATOM   1466  HD2 ARG A  95      63.554   2.860  65.666  1.00  0.00           H  
ATOM   1467  HD3 ARG A  95      62.915   1.211  65.830  1.00  0.00           H  
ATOM   1468  HE  ARG A  95      65.315   0.753  64.610  1.00  0.00           H  
ATOM   1469 HH11 ARG A  95      64.200   2.024  67.576  1.00  0.00           H  
ATOM   1470 HH12 ARG A  95      65.776   2.156  68.283  1.00  0.00           H  
ATOM   1471 HH21 ARG A  95      67.441   1.201  65.395  1.00  0.00           H  
ATOM   1472 HH22 ARG A  95      67.610   1.690  67.048  1.00  0.00           H  
ATOM   1473  N   ASP A  96      60.487  -1.578  62.617  1.00  0.00           N  
ATOM   1474  CA  ASP A  96      60.041  -2.745  61.803  1.00  0.00           C  
ATOM   1475  C   ASP A  96      58.535  -2.657  61.536  1.00  0.00           C  
ATOM   1476  O   ASP A  96      57.916  -1.633  61.745  1.00  0.00           O  
ATOM   1477  CB  ASP A  96      60.364  -3.970  62.658  1.00  0.00           C  
ATOM   1478  CG  ASP A  96      59.426  -4.014  63.865  1.00  0.00           C  
ATOM   1479  OD1 ASP A  96      58.280  -4.389  63.686  1.00  0.00           O  
ATOM   1480  OD2 ASP A  96      59.871  -3.671  64.948  1.00  0.00           O  
ATOM   1481  H   ASP A  96      60.615  -1.674  63.583  1.00  0.00           H  
ATOM   1482  HA  ASP A  96      60.586  -2.788  60.874  1.00  0.00           H  
ATOM   1483  HB2 ASP A  96      60.234  -4.865  62.066  1.00  0.00           H  
ATOM   1484  HB3 ASP A  96      61.386  -3.911  63.000  1.00  0.00           H  
ATOM   1485  N   GLY A  97      57.941  -3.726  61.077  1.00  0.00           N  
ATOM   1486  CA  GLY A  97      56.478  -3.702  60.799  1.00  0.00           C  
ATOM   1487  C   GLY A  97      56.178  -4.557  59.567  1.00  0.00           C  
ATOM   1488  O   GLY A  97      55.046  -4.920  59.312  1.00  0.00           O  
ATOM   1489  H   GLY A  97      58.459  -4.542  60.915  1.00  0.00           H  
ATOM   1490  HA2 GLY A  97      55.943  -4.096  61.651  1.00  0.00           H  
ATOM   1491  HA3 GLY A  97      56.162  -2.686  60.613  1.00  0.00           H  
ATOM   1492  N   THR A  98      57.181  -4.880  58.798  1.00  0.00           N  
ATOM   1493  CA  THR A  98      56.953  -5.713  57.582  1.00  0.00           C  
ATOM   1494  C   THR A  98      56.926  -7.197  57.953  1.00  0.00           C  
ATOM   1495  O   THR A  98      56.274  -7.997  57.312  1.00  0.00           O  
ATOM   1496  CB  THR A  98      58.125  -5.418  56.651  1.00  0.00           C  
ATOM   1497  OG1 THR A  98      59.235  -6.226  57.016  1.00  0.00           O  
ATOM   1498  CG2 THR A  98      58.513  -3.939  56.737  1.00  0.00           C  
ATOM   1499  H   THR A  98      58.087  -4.577  59.021  1.00  0.00           H  
ATOM   1500  HA  THR A  98      56.033  -5.432  57.097  1.00  0.00           H  
ATOM   1501  HB  THR A  98      57.829  -5.646  55.642  1.00  0.00           H  
ATOM   1502  HG1 THR A  98      59.957  -6.029  56.413  1.00  0.00           H  
ATOM   1503 HG21 THR A  98      57.700  -3.378  57.174  1.00  0.00           H  
ATOM   1504 HG22 THR A  98      58.719  -3.562  55.747  1.00  0.00           H  
ATOM   1505 HG23 THR A  98      59.395  -3.833  57.352  1.00  0.00           H  
ATOM   1506  N   ARG A  99      57.633  -7.572  58.984  1.00  0.00           N  
ATOM   1507  CA  ARG A  99      57.650  -9.005  59.397  1.00  0.00           C  
ATOM   1508  C   ARG A  99      57.407  -9.125  60.904  1.00  0.00           C  
ATOM   1509  O   ARG A  99      56.343  -9.516  61.342  1.00  0.00           O  
ATOM   1510  CB  ARG A  99      59.048  -9.505  59.036  1.00  0.00           C  
ATOM   1511  CG  ARG A  99      59.142  -9.718  57.524  1.00  0.00           C  
ATOM   1512  CD  ARG A  99      59.726 -11.103  57.238  1.00  0.00           C  
ATOM   1513  NE  ARG A  99      60.036 -11.095  55.781  1.00  0.00           N  
ATOM   1514  CZ  ARG A  99      60.935 -11.910  55.301  1.00  0.00           C  
ATOM   1515  NH1 ARG A  99      60.794 -13.199  55.451  1.00  0.00           N  
ATOM   1516  NH2 ARG A  99      61.975 -11.438  54.670  1.00  0.00           N  
ATOM   1517  H   ARG A  99      58.153  -6.912  59.488  1.00  0.00           H  
ATOM   1518  HA  ARG A  99      56.906  -9.563  58.849  1.00  0.00           H  
ATOM   1519  HB2 ARG A  99      59.781  -8.774  59.345  1.00  0.00           H  
ATOM   1520  HB3 ARG A  99      59.238 -10.441  59.542  1.00  0.00           H  
ATOM   1521  HG2 ARG A  99      58.155  -9.645  57.089  1.00  0.00           H  
ATOM   1522  HG3 ARG A  99      59.783  -8.963  57.093  1.00  0.00           H  
ATOM   1523  HD2 ARG A  99      60.627 -11.256  57.816  1.00  0.00           H  
ATOM   1524  HD3 ARG A  99      59.001 -11.870  57.458  1.00  0.00           H  
ATOM   1525  HE  ARG A  99      59.565 -10.478  55.183  1.00  0.00           H  
ATOM   1526 HH11 ARG A  99      59.996 -13.562  55.935  1.00  0.00           H  
ATOM   1527 HH12 ARG A  99      61.482 -13.824  55.084  1.00  0.00           H  
ATOM   1528 HH21 ARG A  99      62.083 -10.450  54.555  1.00  0.00           H  
ATOM   1529 HH22 ARG A  99      62.663 -12.062  54.303  1.00  0.00           H  
ATOM   1530  N   GLY A 100      58.386  -8.792  61.699  1.00  0.00           N  
ATOM   1531  CA  GLY A 100      58.211  -8.888  63.176  1.00  0.00           C  
ATOM   1532  C   GLY A 100      59.342  -9.727  63.773  1.00  0.00           C  
ATOM   1533  O   GLY A 100      60.003 -10.476  63.080  1.00  0.00           O  
ATOM   1534  H   GLY A 100      59.237  -8.479  61.326  1.00  0.00           H  
ATOM   1535  HA2 GLY A 100      58.231  -7.895  63.605  1.00  0.00           H  
ATOM   1536  HA3 GLY A 100      57.265  -9.357  63.398  1.00  0.00           H  
ATOM   1537  N   CYS A 101      59.572  -9.608  65.051  1.00  0.00           N  
ATOM   1538  CA  CYS A 101      60.662 -10.401  65.690  1.00  0.00           C  
ATOM   1539  C   CYS A 101      60.071 -11.566  66.489  1.00  0.00           C  
ATOM   1540  O   CYS A 101      60.120 -12.681  65.998  1.00  0.00           O  
ATOM   1541  CB  CYS A 101      61.374  -9.419  66.619  1.00  0.00           C  
ATOM   1542  SG  CYS A 101      63.163  -9.664  66.499  1.00  0.00           S  
ATOM   1543  OXT CYS A 101      59.579 -11.321  67.579  1.00  0.00           O  
ATOM   1544  H   CYS A 101      59.028  -8.999  65.592  1.00  0.00           H  
ATOM   1545  HA  CYS A 101      61.349 -10.766  64.943  1.00  0.00           H  
ATOM   1546  HB2 CYS A 101      61.129  -8.407  66.330  1.00  0.00           H  
ATOM   1547  HB3 CYS A 101      61.055  -9.590  67.637  1.00  0.00           H  
ATOM   1548  HG  CYS A 101      63.536  -9.567  67.379  1.00  0.00           H  
TER    1549      CYS A 101                                                      
END
MOLECULE T0487_26_96.pdb
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
END
